﻿USE sofia;
DROP TABLE IF EXISTS sofia.tel2010_vpl;
CREATE TABLE tel2010_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tel2010_vpl WRITE;
INSERT INTO tel2010_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","మొట్ట మొదటి దేవుడు ఆకాశాన్ని భూమిని చేశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","భూమి మొత్తం శూన్యంగా ఉంది. భూమిమీద ఏమీ లేదు. మహా సముద్రాన్ని చీకటి ఆవరించింది. దేవుని ఆత్మ నీళ్లమీద సంచరిస్తూ ఉండెను. ");
INSERT INTO tel2010_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","అప్పుడు దేవుడు, “వెలుగు కలుగును గాక!” అన్నాడు. వెలుగు ప్రకాశించటం మొదలయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","దేవుడు ఆ వెలుగును చూశాడు. ఆయనకు అది చక్కగా కనబడింది. అప్పుడు దేవుడు ఆ వెలుగును చీకటి నుండి వేరు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","వెలుగుకు “పగలు” అని, చీకటికి “రాత్రి” అని దేవుడు పేరు పెట్టాడు. అస్తమయము అయింది, ఆ తర్వాత ఉదయం అయింది. ఇది మొదటి రోజు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","అప్పుడు దేవుడు, “జలములను రెండు భాగములుగా చేయుటకు అంతరిక్షం ఉండును గాక!” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","కనుక దేవుడు అంతరిక్షాన్ని చేసి, నీళ్లను వేరుపర్చాడు. కొంత నీరు గాలికి పైగాను, కొంత నీరు గాలికి కిందను ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","దేవుడు ఆ అంతరిక్షానికి “ఆకాశం” అని పేరు పెట్టాడు. అస్తమయం అయింది, ఆ తర్వాత ఉదయం అయింది. ఇది రెండవ రోజు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","అప్పుడు దేవుడు, “పొడి నేల కనబడునట్లు, ఆకాశం కింద నీరు ఒక్క చోట చేరునుగాక!” అన్నాడు. అలాగే జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ఆ పొడి నేలకు “భూమి” అని దేవుడు పేరు పెట్టాడు. మరియు ఒక్క చోట చేరిన నీటికి “సముద్రాలు” అని దేవుడు పేరు పెట్టాడు. ఆయనకు ఇది చక్కగా ఉన్నట్టు కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","అప్పుడు దేవుడు, “భూమి గడ్డిని, ఆహార ధాన్యపు మొక్కలను, ఫలవృక్షాలను మొలిపించు గాక, ఫలవృక్షాలు విత్తనాలుగల పండ్లను పండిస్తాయి. మరియూ ప్రతి మొక్క తన స్వంత రకం విత్తనాన్ని రూపొందిస్తుంది. ఈ మొక్కలు భూమిమీద పెరుగును గాక” అన్నాడు. అలాగే జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","గడ్డిని, ఆహార ధాన్యపు మొక్కలను భూమి మొలిపించింది. మరియు అది విత్తనాలుగల పండ్ల చెట్లను మొలిపించింది. ప్రతి మొక్క తన స్వంత రకం విత్తనాలను రూపొందించింది. దేవునికి ఇది చక్కగా ఉన్నట్లు కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","అస్తమయం అయింది, ఆ తర్వాత ఉదయం అయింది. ఇది మూడవ రోజు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","అప్పుడు, “ఆకాశంలో జ్యోతులు ఉండును గాక. ఈ జ్యోతులు రాత్రి నుండి పగలును వేరు చేస్తాయి. జ్యోతులు ప్రత్యేక సంకేతాలను, ప్రత్యేక సమావేశాల ప్రారంభాన్ని సూచించేందుకు ఉపయోగించబడతాయి. మరియు రోజులను సంవత్సరాలను తెలుపుటకు అవి ఉపయోగించబడతాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","భూమి మీద వెలుగును ప్రకాశింప చేయుటకు ఈ జ్యోతులు ఆకాశంలో ఉంటాయి” అన్నాడు దేవుడు. అలాగే జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","కనుక ఆ రెండు పెద్ద జ్యోతులను దేవుడు చేసాడు. పగటి వేళను ఏలుటకు దేవుడు పెద్ద జ్యోతిని చేసాడు. రాత్రి వేళను ఏలుటకు ఆయన చిన్న జ్యోతిని చేసాడు. దేవుడు నక్షత్రాలను కూడా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","భూమి మీద ప్రకాశించుటకు ఈ జ్యోతులను దేవుడు ఆకాశంలో ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","పగటిని, రాత్రిని ఏలుటకు ఈ జ్యోతులను ఆకాశంలో ఉంచాడు. ఈ జ్యోతులు చీకటి నుండి వెలుగును వేరు చేసాయి. దేవునికి ఇది చక్కగా ఉన్నట్టు కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","అస్తమయం అయింది, ఆ తర్వాత ఉదయం అయింది. ఇది నాలుగవ రోజు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","అప్పుడు, “నీళ్లు అనేక ప్రాణులతో నిండి పోవును గాక. మరియు భూమికి పైగా గాలిలో ఎగురుటకు పక్షులు ఉండును గాక!” అన్నాడు దేవుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","కనుక దేవుడు సముద్రపు పెద్ద జంతువులను చేసాడు. సముద్రంలో సంచరించే ప్రతి ప్రాణిని దేవుడు చేసాడు. సముద్ర జంతువులు ఎన్నో రకాలు ఉన్నాయి. వాటన్నిటినీ దేవుడు చేసాడు. ఆకాశంలో ఎగిరే ప్రతి రకం పక్షిని కూడ దేవుడు చేసాడు. మరియు ఇది చక్కగా ఉన్నట్టు దేవునికి కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ఈ జంతువులను దేవుడు ఆశీర్వదించాడు. అవి అనేక పిల్లల్ని పెట్టి, సముద్రాలు నిండిపోవాలని దేవుడు వాటితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","అస్తమయం అయింది, ఆ తర్వాత ఉదయం అయింది. ఇది ఐదవ రోజు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","అప్పుడు దేవుడు, “భూమి అనేక ప్రాణులను చేయును గాక. అనేక రకాల జంతువులు ఉండును గాక. పెద్ద జంతువులు, ప్రాకే అన్ని రకాల పురుగులు చిన్న జంతువులు ఉండును గాక! మరియు ఈ జంతువులన్నీ యింకా వాటి రకపు జంతువుల్ని ఎక్కువగా వృద్ధి చేయుగాక” అన్నాడు దేవుడు. ఈ సంగతులు అన్నీ జరిగాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","కనుక దేవుడు ప్రతి రకపు జంతువును చేసాడు. క్రూర జంతువులను, సాధు జంతువులను, ప్రాకుచుండు చిన్న వాటన్నింటినీ దేవుడు చేశాడు. మరియు ఇది చక్కగా ఉన్నట్టు దేవునికి కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","అప్పుడు, “ఇప్పుడు మనం మనిషిని చేద్దాం. మనం మన పోలికతో మనుష్యుల్ని చేద్దాం. మనుష్యులు మనలా ఉంటారు. సముద్రంలోని చేపలన్నింటి మీద, గాలిలో పక్షులన్నిటి మీద వారు ఏలుబడి చేస్తారు. భూమి మీద పెద్ద జంతువులన్నింటి మీదను, ప్రాకు చిన్న వాటన్నింటిమీదను వారు ఏలుబడి చేస్తారు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","కనుక దేవుడు తన స్వంత రూపంలో మనుష్యుల్ని చేశాడు. తన ప్రతిరూపంలో దేవుడు మనుష్యుల్ని చేశాడు. దేవుడు వారిని మగ, ఆడ వారిగా చేశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","దేవుడు, వారిని “ఇంకా అనేక మంది ప్రజలు ఉండునట్లు పిల్లలను కనండి. భూమిమీద నిండిపోయి, దానిని స్వాధీనం చేసుకోండి. సముద్రంలో చేపల మీద, గాలిలో పక్షుల మీద ఏలుబడి చేయండి. భూమి మీద సంచరించే ప్రతి ప్రాణిమీద ఏలుబడి చేయండి” అని ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","“ఆహార ధాన్యపు మొక్కలన్నిటిని, ఫలవృక్షాలు అన్నింటిని నేను మీకు ఇస్తున్నాను. ఆ చెట్లు విత్తనాలు గల పండ్లను పండిస్తాయి. ఈ ఆహార ధాన్యం, పండ్లు మీ ఆహారం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","మరియు పచ్చ మొక్కలు అన్నింటిని జంతువులకు నేను ఇస్తున్నాను. ఆ పచ్చ మొక్కలు వాటికి ఆహారం అవుతాయి. భూమిమీద ప్రతి జంతువు, గాలిలో ఎగిరే ప్రతి పక్షి, భూమిమీద ప్రాకుచుండు చిన్న ప్రాణులు అన్నీ ఆ ఆహారాన్ని తింటాయి” అని దేవుడు చెప్పాడు. ఈ సంగతులు అన్నీ జరిగాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","దేవుడు తాను చేసినది అంతా చూశాడు. అది అంతా చాలా చక్కగా ఉన్నట్టు దేవునికి కనబడింది. అస్తమయం అయింది, ఆ తర్వాత ఉదయం అయింది. ఇది ఆరవ రోజు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","కనుక భూమి, ఆకాశం, వాటిలోని ప్రతిదీ పూర్తయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","దేవుడు తాను చేస్తున్న పని ముగించాడు. కనుక ఏడవ రోజున దేవుడు తన పని నుండి విశ్రాంతి తీసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ఏడవ రోజును దేవుడు ఆశీర్వదించి, దానిని పవిత్ర దినంగా చేసాడు. దేవుడు ప్రపంచాన్ని చేసేటప్పుడు జరిగించిన పని అంతటి నుండి ఆ రోజున విశ్రాంతి తీసుకొన్నాడు గనుక, ఆ రోజును ఆయన ప్రత్యేకమైనదిగా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ఇదే భూమి, ఆకాశం చరిత్ర. భూమిని, ఆకాశాన్ని దేవుడు చేసినప్పుడు జరిగిన సంగతుల విషయం ఇది. ");
INSERT INTO tel2010_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","భూమి మీద మొక్కలు ఏమీ లేవు. పొలాల్లో ఏమీ పెరగటం లేదు. అప్పటికి యింకా ఎక్కడా మొక్కలు మొలవలేదు. అప్పటికి భూమిమీద యింకా వర్షం యెహోవా కురిపించలేదు. మొక్కలను గూర్చి జాగ్రత్త తీసుకొనే ఏ మనిషి అప్పటికి లేడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","భూమి నుండి ఆవిరి ఉబికి నేల అంతటిని తడిపింది. ");
INSERT INTO tel2010_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","అప్పుడు యెహోవా దేవుడు నేలనుండి మట్టి తీసుకొని మనిషిని చేశాడు. మనిషి నాసికా రంధ్రాలలో జీవ వాయువును దేవుడు ఊదగా మనిషి సజీవుడు అయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","అప్పుడు తూర్పున ఏదెను అను చోట ఒక తోటను యెహోవా నాటాడు. యెహోవా దేవుడు తాను చేసిన మనిషిని ఆ తోటలో ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","అప్పుడు చూచుటకు అందంగా కనబడే చెట్లన్నింటినీ, మరియు ఆహారానికి మంచివైన చెట్లు అన్నింటినీ భూమి పుట్టించునట్లు దేవుడు చేసాడు. జీవ వృక్షమును, మంచి చెడుల తెలివిని ఇచ్చే వృక్షమును ఆ తోట మధ్యలో ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ఏదెను తోటలో నుండి ఒక నది ప్రవహిస్తూ ఆ తోటకు నీటిని ఇస్తుంది. ఆ నది పాయలై నాలుగు చిన్న నదులయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","మొదటి నది పేరు పీషోను. ఇది హవీలా దేశం అంతటా ప్రవహించే నది. ");
INSERT INTO tel2010_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","(ఆ దేశంలో బంగారం ఉంది, ఆ బంగారం చాలా మంచిది. ఆ దేశంలో బోళం, గోమేధికము కూడా ఉన్నాయి). ");
INSERT INTO tel2010_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","రెండవ నది పేరు గీహోను. ఆ నది కూషు దేశమంతటా ప్రవహిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","మూడో నది పేరు హిద్దెకెలు. ఆ నది అష్షూరు తూర్పు దిక్కున ప్రవహిస్తుంది. నాలుగో నది యూఫ్రటీసు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","మనిషిని ఏదేను తోటలో యెహోవా దేవుడు ఉంచాడు. మొక్కలు నాటి తోటనుగూర్చి శ్రద్ధ తీసుకోవడం మనిషి పని. ");
INSERT INTO tel2010_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","యెహోవా దేవుడు మనిషికి ఈ ఆజ్ఞ యిచ్చాడు: “ఈ తోటలోని ఏ చెట్టు ఫలమునైనా నీవు తినవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","అయితే మంచి, చెడ్డల తెలివిని ఇచ్చే చెట్టు ఫలమును నీవు తినకూడదు. ఆ చెట్టు పండు నీవు తిన్న రోజున తప్పక చస్తావు.” ");
INSERT INTO tel2010_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","అప్పుడు యెహోవా దేవుడు, “పురుషుడు ఒంటరిగా ఉండటం మంచిది కాదు. అతనికి సాటియైన సహకారిణిని నేను చేస్తాను. మరియు ఆ సహకారిణి అతనికి సహాయం చేస్తుంది” అనుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","పొలాల్లోని ప్రతి జంతువును, గాలిలోని ప్రతి పక్షిని నేలనుండి యెహోవా దేవుడు చేసాడు. ఈ జంతువులన్నింటిని యెహోవా దేవుడు మనిషి దగ్గరకు రప్పించాడు, మనిషి ప్రతిదానికి పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","సాధు జంతువులన్నింటికీ, ఆకాశ ఫక్షులన్నింటికి, అడవి క్రూర జంతువులన్నింటికి మనిషి పేర్లు పెట్టాడు. ఎన్నెన్నో జంతువుల్ని పక్షుల్ని మనిషి చూశాడు. అయితే తనకు సరిపోయే సహాయంగా ఏదీ అతనికి కనబడలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","అందుచేత ఆ పురుషుడు గాఢనిద్ర పోయేటట్టు చేసాడు యెహోవా దేవుడు. అతడు నిద్రపోతూ ఉండగా, అతని శరీరంలోని పక్క ఎముకలలో ఒకదాన్ని తీసాడు. పక్క ఎముకను తీసిన చోటును అతని మాంసముతో యెహోవా దేవుడు పూడ్చి వేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","స్త్రీని చేసేందుకు, అతని ప్రక్క ఎముకను యెహోవా దేవుడు ఉపయోగించాడు. అప్పుడు ఆ స్త్రీని ఆ పురుషుని దగ్గరకు యెహోవా దేవుడు తీసుకొని వచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","అప్పుడు ఆ పురుషుడు ఇలా అన్నాడు: “ఇప్పుడు, ఇది నావంటి మనిషే అమె ఎముక నా ఎముకల్లోనుంచి వచ్చింది. ఆమె శరీరం నా శరీరంలోనుంచి వచ్చింది. ఆమె నరుని లోనుండి తీయబడింది గనుక ఆమెను నారి అంటాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ఇందువల్ల పురుషుడు తన తండ్రిని, తల్లిని విడిచి, తన భార్యను హత్తుకొంటాడు. వాళ్లిద్దరు ఏకమవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ఆ తోటలో ఆ పురుషుడు, అతని భార్యా నగ్నంగా ఉన్నారు. కాని వారికి సిగ్గు తెలియదు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ఆ సమయంలో ఆ స్త్రీతో సర్పం మాట్లాడింది. యెహోవా దేవుడు సృష్టించిన అడవి జంతువులన్నిటిలో సర్పం చాలా తెలివైనది, కపటమైనది. ఆ సర్పం స్త్రీని మోసగించాలనుకొని, “ఏమమ్మా ఈ తోటలోని ఏ చెట్టు ఫలమైనా తినివద్దని దేవుడు నిజంగా నీతో చెప్పాడా?” అంది. ");
INSERT INTO tel2010_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","సర్పానికి ఆమె ఇలా జవాబిచ్చింది: “లేదు! దేవుడు అలాగు చెప్పలేదు. తోటలోని చెట్ల ఫలాలు మేము తినవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","అయితే ఒక చెట్టుంది, దాని ఫలము మేము తినకూడదు. ‘తోట మధ్యలో ఉన్న చెట్టు ఫలం మీరు తినకూడదు. అసలు ఆ చెట్టును మీరు ముట్టుకోకూడదు. అలాచేస్తే మీరు చస్తారు’ అని దేవుడు మాతో చెప్పాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","అయితే సర్పం ఆ స్త్రీతో ఇలా అంది: “మీరు చావరు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ఆ చెట్టు ఫలం మీరు తింటే, మంచి చెడ్డలను గూర్చి మీరు తెలుసుకొంటారని దేవునికి తెలుసు. అప్పుడు మీరు దేవునివలె ఉంటారు!” ");
INSERT INTO tel2010_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ఆ చెట్టు చాలా అందంగా ఉన్నట్టు ఆ స్త్రీ చూసింది; ఆ ఫలం తినటానికి మంచిదిగా ఉన్నట్టు, ఆ చెట్టు తెలివినిస్తుందని ఆమె తెలుసుకొంది. కనుక ఆ స్త్రీ ఆ చెట్టు ఫలం తీసుకొని దానిని తిన్నది. ఆ పండులో కొంత ఆమె భర్తకు ఇచ్చింది, అతడు కూడా దాన్ని తిన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","అప్పుడు ఆ పురుషుడు, స్త్రీ ఇద్దరూ మారిపోయారు. వారి కళ్లు తెరవబడ్డట్టు, వారికి అన్నీ వేరుగా కనబడ్డాయి. వారికి బట్టలు లేనట్లు నగ్నంగా ఉన్నట్లు వాళ్లు చూశారు. కనుక వారు అంజూరపు ఆకులను కుట్టి వాటినే బట్టలుగా ధరించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","సాయంకాలపు చల్లని వేళలో యెహోవా దేవుడు ఆ తోటలో నడుస్తుండగా ఆ పురుషుడు, స్త్రీ ఆ చప్పుడు విని తోటలోని చెట్లమధ్య దాగుకొన్నారు. యెహోవా దేవుని నుండి దాగుకొనేందుకు వారు ప్రయత్నించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","అయితే యెహోవా దేవుడు ఆ పురుషుని పిలిచాడు. “నీవు ఎక్కడున్నావు?” అన్నాడు యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","“నీవు తోటలో నడుస్తున్న చప్పుడు విన్నాను, నాకు భయం వేసింది. నేను నగ్నంగా ఉన్నాను, అందుకే దాగుకొన్నాను” అన్నాడు ఆ పురుషుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","దేవుడు ఆ పురుషునితో ఇలా అన్నాడు. “నీవు నగ్నంగా ఉన్నావని నీతో ఎవరు చెప్పారు? నిన్ను సిగ్గుపడేటట్లు చేసింది ఏమిటి? నేను తినవద్దని చెప్పిన పండు నీవు తిన్నావా ఏమిటి? ఆ చెట్టు ఫలం తినవద్దని నేను నీకు ఆజ్ఞాపించానుగదా!” ");
INSERT INTO tel2010_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","అందుకు ఆ పురుషుడు, “నా కోసం నీవు చేసిన ఈమె ఆ చెట్టు ఫలాన్ని నాకిచ్చింది, అందుచేత నేను తిన్నాను” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","అప్పుడు యెహోవా దేవుడు, “ఏమిటి నీవు చేసింది?” అన్నాడు ఆ స్త్రీతో. ఆ స్త్రీ, “సర్పం నన్ను మోసం చేసింది. నన్ను వెర్రిదాన్ని చేస్తే ఆ పండు తినేసాను” అని చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","అందుచేత యెహోవా దేవుడు సర్పంతో ఇలా అన్నాడు: “ఈ మహా చెడ్డ పని నీవే చేసావు కనుక నీవు శపించబడ్డావు. జంతువులన్నీటి కంటే నీ పరిస్థితి హీనంగా ఉంటుందు. నీవు నీ పొట్టతో పాకడం తప్పనిసరౌవుతుంది. నీవు జీవిత కాలమంతా మట్టి తింటావు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ఈ స్త్రీని, నిన్ను ఒకరికొకర్ని విరోధుల్నిగా నేను చేస్తాను. నీ సంతానము, ఆమె సంతానము ఒకరికొకరు విరోధులవుతారు. నీవు ఆమె శిశువు పాదం మీద కాటేస్తావు ఈ శిశువు నీ తలను చతుక కొడతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","అప్పుడు స్త్రీతో యెహోవా దేవుడు ఇలా అన్నాడు: “నీవు గర్భవతిగా ఉన్నప్పుడు నేను నీకు బహు ప్రయాస కలుగజేస్తాను. నీవు పిల్లల్ని కనేటప్పుడు మహా గొప్ప బాధ నీకు కలుగుతుంది. నీవు నీ భర్తను వాంఛిస్తావు కాని అతడే నిన్ను ఏలుతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","అప్పుడు పురుషునితో దేవుడు ఈలాగు అన్నాడు: “ప్రత్యేకమైన చెట్టుఫలాన్ని తినవద్దని నేను నీకు ఆజ్ఞాపించాను. అయితే నీవు నీ భార్య చెప్పిన మాటలు విన్నావు ఆ చెట్టు ఫలాన్ని తిన్నావు కనుక నీ మూలంగా భూమిని నేను శపిస్తాను. భూమి ఇచ్చే ఆహారం కోసం నీవు నీ జీవితాంతం ఎంతో కష్టపడాల్సి ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","పొలంలో పండే మొక్కల్ని నీవు తినాలని అనుకొంటావు కాని ముళ్లను, పొదలను నేల నీకోసం పండిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","నీ భోజనం కోసం నీవు చాలా కష్టపడి పని చేస్తావు. నీ ముఖం అంతా చెమటతో నిండి పోయేంతగా నీవు పని చేస్తావు. నీవు చనిపోయే రోజు వరకు కష్టపడి పని చేస్తావు మరణించాక నీవు మరలా మట్టి అయిపోతావు. నేను నిన్ను చేసినప్పుడు మట్టిలో నుంచే నీవు తీయబడ్డావు మళ్లీ నీవు చనిపోయినప్పుడు తిరిగి మట్టిలోనే కలిసిపోతావు.” ");
INSERT INTO tel2010_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","ఆదాము తన భార్యకు హవ్వ అని పేరు పెట్టాడు. ఎన్నడైనా సరే బతికిన ప్రతి మనిషికి ఈమె తల్లి కనుక ఆయన ఆమెకు ఆ పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","యెహోవా దేవుడు జంతు చర్మాలతో ఆ పురుషునికి, అతని భార్యకు చొక్కాలు చేసాడు. ఆ తరువాత ఆ చొక్కాలను వారికి తొడిగించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","అప్పుడు యెహోవా దేవుడు అన్నాడు: “చూడండి, మనిషి మనలా తయారయ్యాడు. మంచి, చెడ్డలు మనిషికి తెలుసు. ఇప్పుడు ఆ మనిషి జీవ వృక్షం నుండి ఫలములు తీసుకొని తింటే అతడు శాశ్వతంగా జీవిస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","కనుక ఏదెను తోటనుండి ఆ మనిషిని యెహోవా దేవుడు వెళ్లగొట్టాడు. ఆదాము బలవంతంగా వెళ్లగొట్టబడి ఏ నేల నుండి అతడు తీయబడ్డాడో ఆ నేలను సేద్యం చేయటం మొదలు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","తరువాత ఆ తోటకు కాపలాగా దాని ద్వారం దగ్గర కెరూబులను దేవుడు ఉంచాడు. ఒక అగ్ని ఖడ్గాన్ని కూడా అక్కడ ఉంచాడు. జీవ వృక్షమునకు పోయే మార్గాన్ని కాపలా కాస్తూ ఆ ఖడ్గం చుట్టూరా తిరుగుతూవుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","ఆదాముకు అతని భార్య హవ్వకు లైంగిక సంబంధాలు కలిగాయి. హవ్వ ఒక శిశువుకు జన్మనిచ్చింది. ఆ శిశువుకు కయీను అని నామకరణం జరిగింది. హవ్వ “యెహోవా సహాయంతో నేను ఒక మనిషిని పొందాను” అంది. ");
INSERT INTO tel2010_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","ఆ తర్వాత హవ్వ మరో శిశువుకు జన్మనిచ్చింది. ఈ శిశువు కయీనుకు తమ్ముడు అతనికి హేబెలు అని నామకరణం చేశారు. హేబెలు గొర్రెల కాపరి అయ్యాడు. కయీను వ్యవసాయదారుడయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","4","కోతకాలంలో కయీను యెహోవాకు ఒక అర్పణను తెచ్చాడు. నేలనుండి తాను పండించిన ఆహార పదార్థాన్ని కయీను తెచ్చాడు. హేబెలు తన మందలో నుండి కొన్ని మంచి బలిసిన తొలిచూలు గొర్రెల్ని తెచ్చాడు. హేబెలును, అతని అర్పణను దేవుడు స్వీకరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","అయితే కయీనును, అతని అర్పణను దేవుడు అంగీకరించలేదు. అందువల్ల కయీను దుఃఖించాడు. అతనికి చాలా కోపం వచ్చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","యెహోవా కయీనును అడిగాడు: “నీవెందుకు కోపంగా ఉన్నావు? నీ ముఖం అలా విచారంగా ఉందేమిటి? ");
INSERT INTO tel2010_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","నీవు మంచి పనులు చేస్తే నాతో నీవు సరిగ్గా ఉంటావు. అప్పుడు నిన్ను నేను అంగీకరిస్తాను. కాని నీవు చెడ్డ పనులు చేస్తే అప్పుడు నీ జీవితంలో ఆ పాపం ఉంటుంది. నీ పాపం నిన్ను అదుపులో ఉంచుకోవాలనుకొంటుంది. కానీ నీవే ఆ పాపమును అదుపులో పెట్టాలి.” ");
INSERT INTO tel2010_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","“మనం పొలంలోకి వెళ్దాం రా” అన్నాడు కయీను తన తమ్ముడైన హేబెలుతో. కనుక కయీను, హేబెలు పొలంలోకి వెళ్లారు. అప్పుడు కయీను తన తమ్ముడైన హేబెలు మీద పడి అతన్ని చంపేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","తర్వాత, “నీ తమ్ముడు ఎక్కడ ఉన్నాడు?” అంటూ కయీనును యెహోవా అడిగాడు. “నాకు తెలియదు. నా తమ్ముణ్ణి కాపలా కాయడం, వాణ్ణి గూర్చి జాగ్రత్త తీసుకోవడమేనా నా పని” అని కయీను జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","అప్పుడు యెహోవా యిలా అన్నాడు, “నీవు చేసింది ఏమిటి? నీవే నీ తమ్ముణ్ణి చంపేసావు. నీ తమ్ముని రక్తం నేల నుండి నాకు మొర్ర పెట్టుతూ వుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","(నీవు నీ తమ్మణ్ణి చంపావు) నీ చేతులనుండి అతని రక్తాన్ని తీసుకోవటానికి భూమి నోరు తెరచుకుంది. భూమిమీద నుండి నీవు శపించబడ్డావు. ");
INSERT INTO tel2010_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ఇది వరకు నీవు మొక్కలు నాటుకొన్నావు. అవి చక్కగా పెరిగాయి. కాని ఇప్పుడు నీవు మొక్కలు నాటినా, నీ మొక్కలు ఏపుగా ఎదగటానికి నేల తోడ్పడదు. భూమి మీద నీకు ఇల్లు కూడా ఉండదు. ఒక చోటు నుండి మరొక చోటుకు నీవు తిరుగుతూ ఉంటావు.” ");
INSERT INTO tel2010_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","అప్పుడు కయీను అన్నాడు: “ఇది నేను భరించలేని శిక్ష! ");
INSERT INTO tel2010_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","చూడు! నన్ను ఈ భూమిని విడిచిపెట్టేటట్లు నీవు బలవంతం చేశావు. నేను నీనుండి వెళ్లపోయి దాగుకొంటాను. (నీ రక్షణనుండి దూరంగా వెళ్తాను). నేనిక్కడ, అక్కడ తిరుగుతుంటాను. నన్ను ఎవరు చూస్తారో వాళ్లు నన్ను చంపేస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","అప్పుడు కయీనుతో యెహోవా ఇలా అన్నాడు: “నేను అలా జరుగనివ్వను! కయీనూ, నిన్ను ఎవరైనా చంపితే, నేను వారిని మరింతగా శిక్షిస్తా” తరువాత కయీనుకు యెహోవా ఒక గుర్తు వేసాడు. ఎవ్వరూ అతణ్ణి చంపకూడదు అని ఈ గుర్తు సూచిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","అప్పుడు కయీను యెహోవా సన్నిధి నుండి వెళ్లపోయాడు. ఏదెనుకు తూర్పునవున్న నోదు దేశములో కయీను నివసించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","కయీను తన భార్యతో కలసినప్పుడు, ఆమె గర్భవతియై హనోకు అనే కుమారుని కన్నది. కయీను ఒక పట్టణం కట్టించి తన కుమారుడైన హనోకు పేరు దానికి పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","హనోకుకు ఈరాదు అనే కుమారుడు పుట్టాడు. ఈరాదుకు మహూయాయేలు అనే కుమారుడు పుట్టాడు. మహూయాయేలుకు మతూషాయేలు అనే కుమారుడు పుట్టాడు. మతూషాయేలుకు లెమెకు అనే కుమారుడు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","లెమెకు ఇద్దరు స్త్రీలను వివాహం చేసుకొన్నాడు. ఒక భార్య పేరు ఆదా, మరొక భార్య పేరు సిల్లా. ");
INSERT INTO tel2010_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ఆదా యాబాలుకు జన్మనిచ్చింది. గుడారములలో నివసిస్తూ, పశువులను పెంచుట ద్వారా జీవనోపాధి సంపాదించుకొనే ప్రజలందరికి యాబాలు తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","ఆదాకు యూబాలు అనే మరో కుమారుడు ఉన్నాడు. (యూబాలు యాబాలు సోదరుడు). సితారాను పిల్లన గ్రోవిని ఊదేవారందరికిని యూబాలు తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","సిల్లా తూబల్కయీనుకు జన్మనిచ్చింది. ఇత్తడి, యినుము పనులు చేసే వాళ్లందరికీ తూబల్కయీను తండ్రి. తూబల్కయీను సోదరికి నయమా అని పేరు పెట్టబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","లెమెకు తన భార్యతలో ఇలా అన్నాడు: “ఆదా, సిల్లా, నా మాట వినండి! లెమెకు భార్య లారా నేను చెప్పే సంగతులను వినండి: ఒకడు నన్ను గాయపర్చాడు కనుక వాడ్ని చంపేసాను ఒక పిల్లవాడు నన్ను కొట్టగా నేనతనిని చంపేసాను. ");
INSERT INTO tel2010_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","కయీనును చంపినందుకు శిక్ష చాలా అధికం! కనుక నన్ను చంపినందుకు శిక్ష మరి ఎంతో అధికంగా ఉంటుందు.” ");
INSERT INTO tel2010_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","ఆదాము హవ్వతో కలసినప్పుడు హవ్వ మరో కుమారుణ్ణి కన్నది. ఈ కుమారునికి షేతు అని పేరు పెట్టారు. నాకు ఇంకో కుమారుణ్ణి దేవుడు ఇచ్చాడు. కయీను హేబెలును చంపాడు, అయితే ఇప్పుడు నాకు షేతు ఉన్నాడు అంది హవ్వ. ");
INSERT INTO tel2010_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","షేతుకు కూడ ఒక కుమారుడు పుట్టాడు. అతనికి, ఎనోషు అని అతడు పేరుపెట్టాడు. ఆ సమయంలో ప్రజలు యెహోవాను ప్రార్థించటం మొదలుబెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ఆదాము వంశాన్ని గూర్చిన గ్రంథం ఇది. దేవుడు తన పోలికలో మనిషిని (ఆదాము) చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","ఒక పురుషుణ్ణి, మరో స్త్రీని దేవుడు చేసాడు. వాళ్లిద్దర్నీ చేసిన రోజున ఆయన వాళ్లను ఆశీర్వదించి, అప్పుడు వాళ్లకు మనుష్యులు అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","ఆదాముకు 130 సంవత్సరములు వయస్సు వచ్చాక ఇంకో కుమారునికి తండ్రి అయ్యాడు. ఈ కుమారుడు అచ్చం ఆదాములాగే ఉన్నాడు. ఆదాము తన కుమారునికి షేతు అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","షేతు పుట్టిన తర్వాత ఆదాము 800 సంవత్సరములు బతికాడు. ఆ కాలంలో ఆదాముకు ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","కనుక ఆదాము మొత్తం 930 సంవత్సరములు జీవించాడు. అప్పుడు అతడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","షేతుకు 105 సంవత్సరముల వయస్సులో ఎనోషు అనే ఒక కుమారుడు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ఎనోషు పుట్టిన తర్వాత షేతు 807 సంవత్సరాలు జీవించాడు. ఆ కాలంలో షేతుకు ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","కనుక మొత్తం 912 సంవత్సరాలు షేతు జీవించాడు. అప్పుడు అతడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","తొంబై సంవత్సరాల వయస్సు దాటిన తరువాత ఎనోషుకు కేయినాను అనే కుమారుడు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","కేయినాను పుట్టిన తర్వాత, ఎనోషు 815 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి యింకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","కనుక మొత్తం 905 సంవత్సరాలు ఎనోషు జీవించాడు. అప్పుడు అతడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","కేయినాను 70 సంవత్సరాల వయస్సు దాటిన తర్వాత, మహలలేలు అనే కుమారుడు అతినికి పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","మహలలేలు పుట్టిన తర్వాత కేయినాను 840 సంవత్సరాలు జీవించాడు. ఆ కాలంలో కేయినానుకు ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","కనుక కేయినాను మొత్తం 910 సంవత్సరాలు జీవించాడు. అప్పుడు అతడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","మహలలేలు 65 సంవత్సరాల వయస్సులో ఉన్నప్పుడు యెరెదు అను కుమారుడు అతనికి పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","యెరెదు పుట్టిన తర్వాత, మహలలేలు 830 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","కనుక మహలలేలు మొత్తం 895 సంవత్సరాలు జీవించాడు. అప్పుడు అతడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","యెరెదుకు 162 సంవత్సరాల వయస్సు దాటిన తర్వాత హనోకు అనే కుమారుడు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","హనోకు పుట్టిన తర్వాత, యెరెదు 800 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","కనుక యెరెదు మొత్తం 962 సంవత్సరాలు జీవించాడు. అప్పుడు అతడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","హనోకు 65 సంవత్సరాల వయస్సు దాటిన తర్వాత మెతూషెల అనే కుమారుడు అతనికి పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","మెతూషెల పుట్టిన తర్వాత, హనోకు యింకా 300 సంవత్సరాలు దేవునితో సహవాసం చేసాడు. ఆ కాలంలో అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","కనుక హనోకు మొత్తం 365 సంవత్సరాలు జీవించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","హనోకు దేవునికి సన్నిహితంగా ఉన్నాడు. ఒకనాడు దేవుడు హనోకును తనతో తీసుకుపోయాడు గనుక అతడు కనబడకుండా పోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","మెతూషెలకు 187 సంవత్సరాల వయస్సు దాటిన తర్వాత లెమెకు అనే కుమారుడు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","లెమెకు పుట్టిన తర్వాత, మెతూషెల 782 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","కనుక మెతూషెల మొత్తం 969 సంవత్సరాలు జీవించాడు. అతడు అప్పుడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","లెమెకు వయస్సు 182 సంవత్సరాలు ఉన్నప్పుడు అతనికి ఒక కుమారుడు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","లెమెకు తన కుమారునికి నోవహు అని పేరు పెట్టాడు. “దేవుడు భూమిని శపించాడు గనుక వ్యయసాయ దారులమైన మనం చాసా కష్టపడి పని చేస్తున్నాం. అయితే నోవహు మనకు నెమ్మది కలుగజేస్తాడు” అన్నాడు లెమెకు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","నోవహుకు పుట్టిన తర్వాత లెమెకు 595 సంవత్సరములు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","కనుక లెమెకు మొత్తం 777 సంవత్సరాలు జీవించాడు. అప్పుడు అతడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","నోవహు 500 సంవత్సరములు దాటిన తర్వాత షేము, హాము, యాఫెతు అనే కుమారులు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","భూమిమీద మనుష్యుల సంఖ్య పెరుగుతూ పోయింది. వీరికి ఆడపిల్లలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","4","ఈ ఆడపిల్లలు చాలా అందంగా ఉన్నట్టు దేవుని కుమారులు చాశారు. కనుక దేవుని కుమారులు వారికి నచ్చిన ఆడపిల్లల్ని వాళ్లు పెళ్లి చేసుకొన్నారు. ఆ స్త్రీలు పిల్లల్ని కన్నారు, ఆ కాలంలోను, ఆ తర్వాత కాలంలోను నెఫీలులనువారు ఆ దేశంలో నివసించారు. వారు చాలా ప్రఖ్యాతి చెందిన ప్రజలు, ప్రాచీన కాలంనుండి వారు మహా వీరులు. అప్పుడు యెహోవా అన్నాడు, “మనుష్యులు మానవ మాత్రులు, వారి మూలంగా నా ఆత్మను ఎల్లప్పుడు కలవరపడనియ్యను. 120 సంవత్సరాలు వారిని బతకనిస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","భూమిమీద మనుష్యులు చాలా చెడ్డవాళ్లుగా ఉన్నట్టు యెహోవా చూశాడు. ప్రజలు ఎల్లప్పుడునూ చెడ్డ వాటిని గూర్చి మాత్రమే తలుస్తున్నట్టు యెహోవా చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ఈ భూమిమీద మనుష్యులను చేసినందుకు యెహోవా విచార పడ్డాడు. దేవుని హృదయంలో అది ఎంతో దుఃఖం కలిగించింది. ");
INSERT INTO tel2010_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","కనుక యెహోవా ఇలా అన్నాడు: “భూమిమీద నేను చేసిన మనుష్యులందరినీ నేను నాశనం చేసేస్తాను. ప్రతి మనుష్యుని, ప్రతి జంతువును, భూమిమీద ప్రాకు ప్రతి జీవిని నాశనం చేస్తాను. ఆకాశ పక్షుల్ని కూడా నేను నాశనం చేస్తాను. ఎందుచేతనంటే, వీటన్నింటినీ నేను చేసినందుకు విచారిస్తున్నాను గనుక.” ");
INSERT INTO tel2010_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","అయితే భూమిమీద యెహోవాను సంతోష పెట్టిన మనిషి ఒక్కడు ఉన్నాడు. అతడు నోవహు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ఇది నోవహు కుటుంబ కథ. నోవహు తన తరం వారిలోనే నీతిమంతుడు. అతడు ఎల్లప్పుడు దేవునిని అనుసరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","నోవహుకు షేము, హాము, యాఫెతు అని ముగ్గురు కుమారులు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","దేవుడు భూమిని చూసి, మనుష్యులు దానిని పాడుచేసినట్టు కనుగొన్నాడు. ఎక్కడ చూసినా చెడుతనం ప్రజలు చెడ్డవారై పోయి, క్రూరులై, భూమిమీద వారి జీవితాన్ని నాశనం చేసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","కనుక నోవహుతో దేవుడు ఇలా చెప్పాడు: “మనుష్యులంతా ఈ భూమిని కోపంతో హింసతో నింపేసారు. కనుక జీవిస్తున్న వాటన్నింటిని నేను నాశనం చేస్తాను. ఈ భూమిమీద నుండి వారిని నేను తీసివేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","చితిసారకపు చెక్కతో నీ కోసం ఒక ఓడను నిర్మించు, ఓడలో గదులను చేసి ఓడకు తారు పైపూత పూయి. ");
INSERT INTO tel2010_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","“నీవు చేయాల్సిన ఓడ కొలత ఇలా ఉండాలి. 300 అ. పొడవు, 50 అ. వెడల్పు, 30 అ. ఎత్తు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","కప్పుకు సుమారు 18 అంగుళాల క్రింద ఓడకు ఒక కిటికీ చేయి. ఓడకు ఒక ప్రక్క తలుపు పెట్టు. ఓడలో మూడు అంతస్తులు చేయి. పై అంతస్తు, మధ్య అంతస్తు, క్రింది అంతస్తు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“నేను నీతో చెబుతోంది గ్రహించు. ఈ భూమి మీదకి ఒక మహాగొప్ప జలప్రళయాన్ని నేను తీసుకొస్తున్నాను. ఆకాశం క్రింద జీవిస్తున్న సకల ప్రాణులను నేను నాశనం చేస్తాను. భూమిమీద ఉండే ప్రతీ ప్రాణి చస్తుంది. భూమిమీద ఉన్న అన్నీ చస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","అయితే నిన్ను నేను రక్షిస్తాను. అప్పుడు నీతో నేను ఒక ప్రత్యేక ఒడంబడిక చేస్తాను. నీవు, నీ కుమారులు, నీ భార్య, నీ కోడళ్లు అందరు ఓడలో ఎక్కాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","భూమిమీద జీవిస్తోన్న ప్రాణులన్నింటిలో రెండేసి చొప్పున నీవు సంపాదించాలి. ఆడ, మగ చొప్పున వాటిని ఓడలోనికి తీసుకొని రావాలి. వాటిని నీతో కూడా సజీవంగా ఉంజనివ్వు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","భూమిమీద ఉన్న ప్రతీ జాతి పక్షుల్లోనుంచి రెండేసి తీసుకురా. భూమిమీద ఉన్న అన్ని రకాల జంతువుల్లోనుంచి రెండేసి తీసుకురా. నేలమీద ప్రాకు ప్రతి ప్రాణులలో రెండేసి చొప్పున తీసుకురా, భూమిమీద ఉండే అన్ని రకాల జంతువులు మగది, ఆడది నీతో ఉండాలి. ఓడలో వాటిని సజీవంగా ఉంచు. ");
INSERT INTO tel2010_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","అలాగే భూమి మీద ఉండే ప్రతి విధమైన ఆహారాన్ని ఓడలోనికి తీసుకొనిరా. అది నీకు, జంతువులకు భోజనం అవుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","వీటన్నింటినీ నోవహు చేసాడు. దేవుడు ఆజ్ఞాపించినట్లే నోవహు వాటన్నిటినీ చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","అప్పుడు నోవహుతో యెహోవా ఇలా చెప్పాడు: “ఈ కాలపు దుర్మార్గుల మధ్య నీవు మంచి వాడివిగా నాకు కనబడ్డావు. కనుక నీ కుటుంబం అంతటినీ కలుపుకొని మీరంతా ఓడలోపలికి వెళ్లండి. ");
INSERT INTO tel2010_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","శుద్ధమయిన జంతువులన్నింటిలో నుండి ఏడేసి జాతులు. (మగవి ఏడు, ఆడవి ఏడు) తీసుకో, భూమి మీద ఉన్న ఇతర జంతువులన్నింటిలోనుండి ఒక్క జత (మగది ఒకటి, ఆడది ఒకటి) తీసుకో. ఈ జంతువులన్నింటిని నీతోబాటు ఓడలోనికి నడిపించు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ఆకాశంలో ఎగిరే పక్షులన్నింటిలో నుండి ఏడేసి జతలు (మగవి ఏడు, ఆడవి ఏడు) తీసుకో. ఇలా చేయటంవల్ల మిగతా జంతువులన్ని నాశనం చేయబడిన తర్వాత కూడా ఈ జంతువులన్ని భూమిమీద జీవించడానికి వీలవుతుందు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","ఇంక ఏడు రోజులకు భూమిమీద విస్తారమైన వర్షం కురిపిస్తాను. 40 పగళ్లు, 40 రాత్రులు వర్షం కురుస్తుంది. భూమిమీద జీవించే ప్రతిప్రాణి నాశనం చేయబడుతుంది. నేను చేసినవన్నీ నశించిపోతాయి.” ");
INSERT INTO tel2010_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","యెహోవా ఆజ్ఞాపించిన వీటన్నిటి విషయంలో నోవహు విధేయుడయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ఈ జలప్రళయము వచ్చినప్పుడు నోవహు వయస్సు 600 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","వరద నీటినుండి తప్పించుకొనేందుకు నోవహు, అతని కుంటుంబం ఓడలో ప్రవేశించారు. నోవహు భార్య, అతని కుమారులు, వారి భార్యలు అతనితో కూడ ఓడలో ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","పవిత్ర జంతువులన్నీ, భూమిమీది ఇతర జంతువులన్నీ, పక్షులన్నీ, నేలమీద ప్రాకు ప్రాణులన్నీ నోవహుతో పాటు ఓడలోకి వెళ్లాయి. దేవుడు నోవహుకు ఆజ్ఞాపించినట్లుగా ఆడ, మగ అనే జంటలుగ లోపలికి వెళ్లాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ఏడు రోజుల తర్వాత వరద రారంభమయింది. భూమిమీద వర్షం కురవటం మొదలయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","13","రెండవ నెల 17వ రోజున భూమి క్రింద ఉన్న జల ఊటలన్నీ బ్రద్దలై, నేలనుండి నీరు ప్రవహించటం మొదలయింది. అదే రోజున భూమిమీద భారీ వర్షాలు కురవటం ప్రారంభం అయింది. ఆకాశానికి కిటికీలు తెర తీసినట్టుగా ఉంది. 40 పగళ్లు 40 రాత్రులు భూమి మీద వర్షం కురిసింది. సరిగ్గా అదే రోజున నోవహు, అతని భార్య, అతని కుమారులు షేము, హాము, యాఫెతు వారి భార్యలు ఓడ ఎక్కారు. ఈ సమయంలో నోవహు 600 సంవత్సరాల వయస్సువాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ఆ మనుష్యులు, భూమిమీదనున్న అన్ని రకాల జంతువులు ఆ ఓడలో ఉన్నారు. అన్ని రకాల పశువులు, నేలమీద ప్రాకు అన్ని రకాల జంతువులు, అన్ని రకాల పక్షులు ఆ ఓడలో ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ఈ జంతువులన్నీ నోవహుతో కలిసి ఓడలోకి వెళ్లాయి. ప్రాణం ఉన్న ప్రతి రకం జంతువు రెండేసి చొప్పున వచ్చాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","సరిగ్గా దేవుడు ఆజ్ఞాపించినట్లే ఈ జంతువులన్నీ ఓడలో జతలు జతలుగా ప్రవేశించాయి. తరువాత యెహోవా ఓడ తలుపులు మూసివేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","40 రోజుల పాటు నీళ్లు భూమిమీద వరదలై పారాయి. నీటిమట్టం పెరుగుతూ ఓడను నేలమీదనుండి పైకి లేపడం మొదలయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","నీటిమట్టం పెరగటం కొనసాగుతునే ఉంది. ఓడ నేలకు చాలా ఎత్తుగా నీటిమీద తేలుతొంది. ");
INSERT INTO tel2010_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","నీటి మట్టం చాలా పైకి లేచినందువల్ల గొప్ప ఎత్తయిన పర్వతాలు అన్నీ నీళ్లలో మునిగిపోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","పర్వత శిఖరాలకు పైగా నీటిమట్టం లేస్తూనే ఉంది. అన్నింటికంటే ఎత్తయిన పర్వత శిఖరానికి ఇంకా 20 అడుగులు ఎత్తుగానే నీటిమట్టం ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","భూమిమీద బ్రతికి ఉన్న ప్రతి ప్రాణీ చనిపోయింది. ప్రతి పురుషుడు, స్త్రీ మరణించారు. పక్షులు, పశువులు, జంతువులు ఎగిరే ప్రతి ప్రాణి చంపివేయబడ్డాయి. బ్రతికి శ్వాసించే ప్రతి జీవి చనిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","కనుక భూమిమీద ఉన్న సకల ప్రాణులను, ప్రతి మనిషి, ప్రతి జంతువు, ప్రాకు ప్రతి ప్రాణి, ప్రతి పక్షి అన్నింటినీ దేవుడు నాశనం చేసాడు. ఇవన్నీ భూమిమీద నుండి నాశనం చేయబడ్డాయి. ఓడలోవున్న నోవహు అతనితో ఉన్న మనుష్యులు, జంతువులు మాత్రమే బ్రతికి ఉన్న ప్రాణులు. ");
INSERT INTO tel2010_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","150 రోజుల పాటు నీళ్లు భూమిని కప్పేసాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","అయితే నోవహును దేవుడు మరచిపోలేదు. నోవహును, అతనితో కూడ ఓడలో ఉన్న జంతువులన్నింటిని, పశువులన్నింటిని దేవుడు జ్ఞాపకం చేసుకొన్నాడు. భూమిమీద గాలి వీచేటట్టు దేవుడు చేసాడు. నీళ్లన్నీ కనపడకుండా పోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ఆకాశం నుండి వర్షం కురవటం ఆగిపోయింది. భూమి క్రింద నుండి నీళ్లు ఉబుకుట కూడ నిలిచిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","4","నేలమీద నిండిన నీళ్లు బాగా ఇంకిపోవడం మొదలయింది. 150 రోజుల తర్వాత నీళ్లు బాగా తగ్గిపోయాయి, గనుక ఓడ మరల నేలమీద నిలిచింది. అరారాతు పర్వతాల్లో ఒకదాని మీద ఓడ నిలిచింది. ఇది ఏడవ నెల పదిహేడవ రోజు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","నీళ్లు ఇంకిపోతూనే ఉన్నాయి, పదవ నెల మొదటి రోజుకు కొండ శిఖరాలు నీళ్లకు పైగా కనబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","నలభై రోజుల తర్వాత నోవహు తాను చేసిన ఓడ కిటికీ తెరిచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ఒక కాకిని నోవహు బయటకు పంపాడు. నీళ్లన్నీ ఇంకి పోయి, నేల ఆరిపోయేంత వరకు ఒక చోటునుండి మరో చోటుకు ఆ కాకి ఎగురుతూనే ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ఒక పావురాన్ని కూడా నోవహు పంపించాడు. ఆరిన నేలను పావురం తెల్సుకోవాలను కొన్నాడు నోవహు. అతడు నేల ఇంకా నీళ్లతో నిండి ఉందేమో తెల్సుకోవాలను కొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","నేలమీద ఇంకా నీళ్లు నిండి ఉండటం చేత పావురం తిరిగి ఓడలోకి వచ్చేసింది. నోవహు చేయి బయటకు చాచి పావురాన్ని పట్టుకున్నాడు. ఆ పావురాన్ని నోవహు మళ్లీ ఓడలోకి తెచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","ఏడు రోజుల తర్వాత నోవహు పావురాన్ని మళ్లీ బయటకి పంపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ఆ మధ్యాహ్నం ఆ పావురం మళ్లీ నోవహు దగ్గరకు వచ్చేసింది. తాజా ఓలీవ ఆకు ఆ పావురం నోటవుంది. భూమిమీద ఆరిన నేల ఉన్నట్టుగా నోవహుకు అది ఒక గుర్తు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","ఏడు రోజుల తర్వాత నోవహు పావురాన్ని మరల బయటకి పంపించాడు. అయితే ఈసారి పావురం మరల ఎన్నడూ తిరిగిరాలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ఆ తర్వాత నోవహు ఓడ తలుపులు తెరిచాడు. నేల ఆరిపోయినట్టుగా నోవహు చూశాడు. అది సంవత్సరములో మొదటి నెల మొదటి రోజు. అప్పుడు నోవహు వయస్సు 601 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","రెండవ నెల 27వ రోజుకు నేల పూర్తిగా ఆరిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","అప్పుడు యెహోవా నోవహుతో అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“ఓడ నేలకు దిగింది. నీవు, నీ భార్య, నీ కుమారులు, నీ కోడళ్లు ఇప్పుడు బయటకు వెళ్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","జీవమున్న ప్రతి జంతువును, పక్షులన్నింటిని, భూమిమీద ప్రాకు ప్రాణులన్నిటిని నీతోబాటు బయటకు తీసుకొనిరా. ఆ జంతువులు సంతానాభివృద్ధి చెంది, అవి మరల భూమిని నింపుతాయి.” ");
INSERT INTO tel2010_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","తన కుమారులు, తన భార్య, తన కోడళ్లతో నోవహు బయటకు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","జంతువులన్నీ ప్రాకు ప్రాణులన్నీ, ప్రతి పక్షి ఓడను విడచి వెళ్లాయి. జంతువులన్నీ వాటి జాతి ప్రకారం గుంపులుగా బయటకు వచ్చాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","అప్పుడు యెహోవాకు ఒక బలిపీఠాన్ని నోవహు కట్టాడు. పవిత్రమైన పక్షులన్నింటిలో నుండి, పవిత్రమైన జంతువులన్నింటిలో నుండి కొన్నింటిని నోవహు తీసుకొని, దేవునికి కానుకగా బలిపీఠం మీద వాటిని దహించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","యెహోవా ఈ బలుల సువాసనను ఆఘ్రాణించి ఆనందించాడు. యెహోవా తనలో తాను అనుకొన్నాడు, “మనుష్యుల్ని శిక్షించేందుకోసం ఒక పద్ధతిగా మరల ఎన్నడు నేను భూమిని శపించను. మనుష్యులు చిన్నప్పటి నుండే దుర్మార్గులు కనుక భూమిమీద జీవిస్తున్న వాటన్నింటిని మరల ఎన్నడును నాశనం చేయను. లేదు మరల నేను ఇలా చేయను. ");
INSERT INTO tel2010_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","భూమి ఉన్నంత కాలమూ, నాటుటకు, పంట కోయుటకు ఎల్లప్పుడూ ఒక సమయం ఉంటుంది. భూమిమీద ఎప్పటికీ, చల్లదనం, వేడి, వేసివికాలం, చలికాలం, పగలు, రాత్రిళ్లు ఉంటాయి.” ");
INSERT INTO tel2010_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","నోవహును, అతని కుమారులను దేవుడు ఆశీర్వదించాడు. దేవుడు అతనితో చెప్పాడు: “అధిక సంతానం కలిగి, నీ జనంతో భూమిని నింపు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","భూమి మీదనున్న ప్రతి జంతువు, గాలిలో ఎగిరే ప్రతి పక్షి, నేలమీద ప్రాకు ప్రతి ప్రాణి, సముద్రంలోని ప్రతి చేప నీకు భయపడతాయి. వాటన్నిటిపైన నీవు పాలకునిగా ఉంటావు.” ");
INSERT INTO tel2010_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","“గతంలో నీవు తినేందుకు పచ్చ మొక్కల్ని ఇచ్చాను. ఇప్పుడు ప్రతి జంతువు నీకు ఆహారం అవుతుంది. భూమిపై నున్న సమస్తాన్ని నీకు ఇస్తున్నాను–అదంతా నీదే. ");
INSERT INTO tel2010_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","అయితే నీకు నేను ఒక ఆజ్ఞ యిస్తున్నాను. దానిలో ఇంకా ప్రాణము (రక్తం) ఉన్న మాంసాన్ని మీరు తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","అనగా ఏ మనిషినైనా ఒక జంతువు చంపితే దాని రక్తాన్ని అడుగుతాను, అలానే ఏ మనిషినైనా మరో మనిషి ప్రాణం తీస్తే, ఆ మనిషి రక్తాన్ని అడుగుతాను. ");
INSERT INTO tel2010_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“దేవుడు అచ్చం తనలాగే మనుష్యులను చేసాడు. కనుక యింకొక మనిషిని చంపిన వాడు మరో మనిషి చేత చంపబడాలి.” ");
INSERT INTO tel2010_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","నోవహూ, “నీవు, నీ కుమారులు అధిక సంతానం కలిగి, నీ జనంతో భూమిని నింపుదురు గాక.” ");
INSERT INTO tel2010_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","తర్వాత నోవహుతో అతని కుమారుతో దేవుడు ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“నీతోను నీ తర్వాత నీ ప్రజలతోను ఇప్పుడు నేను నా వాగ్దానం చేస్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","నీతోబాటు ఓడలో నుండి బయటకు వచ్చిన పక్షులన్నింటితోను, పశువులన్నింటితోను, జంతువులన్నింటితోను, నేను వాగ్దానం చేస్తున్నాను. భూమి మీదనున్న ప్రతి ప్రాణితో నేను వాగ్దానం చేస్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","ఇదే నీకు నా వాగ్దానం. వరద నీటిచేత, భూమిమీద సకల ప్రాణులు నాశనం చేయబడ్డాయి. అయితే ఇక ఎన్నటికీ మరల అలా జరుగదు. భూమిమీద సకల ప్రాణులను ఒక వరద మాత్రం ఇక ఎన్నటికీ తిరిగి నాశనం చేయదు.” ");
INSERT INTO tel2010_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","తర్వాత నోవహు, అతని కుమారులతో యెహోవా యిలా అన్నాడు: “ఈ వాగ్దానం నేను మీకు యిచ్చినట్టు రుజువుగా నేను మీకు ఒకటి ఇస్తాను. మీతోను, భూమిమీద జీవించే ప్రతి ప్రాణితోను ఈ వాగ్దానం నేను చేసానని చెప్పేందుకు ఇది రుజువు. ఈ వాగ్దానం రాబోయే కాలములన్నిటిలో కొనసాగుతుంది. ఇదే ఆ రుజువు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","మేఘాల్లో నా రంగుల ధనస్సునుంచుచున్నాను. నాకు, భూమికి జరిగిన ఒడం బడికకు రుజువు ఆ రంగుల ధనస్సు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","భూమికి పైగా మేఘాలను నేను రప్పించినపుడు, మేఘాలలో రంగుల ధనస్సును మీరు చూస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","రంగుల ధనస్సును నేను చూపినప్పుడు నీతోను, భూమిమీదనున్న సకల ప్రాణులతోను జరిగిన ఒడంబడికను నేను జ్ఞాపకం చేసుకొంటాను. ఈ భూమిమీద సకల ప్రాణులను ఒక జలప్రళయం మాత్రం ఇంకెన్నడూ నాశనం చేయదు అని ఆ ఒప్పందం చెబుతోంది. ");
INSERT INTO tel2010_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","మేఘాల్లో ఆ రంగుల ధనస్సును నేను చూచినప్పుడు శాశ్వతంగా కొనసాగే ఆ ఒడంబడికను నేను జ్ఞాపకం చేసుకొంటాను. నాకు, భూమిమీద సకల ప్రాణులకు మధ్య జరిగిన ఒడంబడికను నేను జ్ఞాపకం చేసుకొంటాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","కనుక, “భూమిమీద సకల ప్రాణులతోని నేను చేసిన ఒడంబడికకు ఆ మేఘ ధనస్సు రుజువు” అని నోవహుతో యెహోవా చెప్పాడు. కనుక నోవహుతో ప్రభువు, “భూమిమీద సకల ప్రాణులతోను నేను చేసిన ఒడంబడికకు మేఘములోని ధనస్సు రుజువు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","నోవహుతో కూడ అతని కుమారులు ఓడలో నుండి బయటకు వచ్చారు. వారి పేర్లు షేము, హాము, యాఫెతు. (హాము కనానుకు తండ్రి). ");
INSERT INTO tel2010_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","ఆ ముగ్గురు మగవాళ్లు నోవహు కుమారులు. మరియు భూమిమీద ప్రజలంతా ఆ ముగ్గురి కుమారుల నుండి వచ్చినవాళ్లే. ");
INSERT INTO tel2010_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","నోవహు వ్యయసాయదారుడయ్యాడు. అతడు ఒక ద్రాక్షతోట నాటాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","నోవహు ద్రాక్షారసం చేసి, దాన్ని తాగాడు. అతడు మత్తెక్కి తన గుడారంలో పండుకొన్నాడు. నోవహు బట్టలు ఏమీ వేసుకొనలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","కనాను తండ్రి హాము, దిగంబరంగా ఉన్న తన తండ్రిని చూశాడు. గుడారం వెలుపలున్న తన సోదరులతో హాము ఈ విషయం చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","అప్పుడు షేము, యాఫెతు కలసి ఒక అంగీని తెచ్చారు. వాళ్లు ఆ అంగీని తమ భుజాలమీద మోసి గుడారంలోకి తీసుకువెళ్లారు. వారు వెనక్కి గుడారంలోకి నడిచివెళ్లి బట్టలు లేకుండా ఉన్న తమ తండ్రి ఒంటిమీద బట్ట కప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ఆ తర్వాత నోవహు మేల్కొన్నాడు. (ద్రాక్షారసంవల్ల అతడు నిద్రపోతూ ఉన్నాడు). అప్పుడు తన చిన్న కుమారుడు హాము తనకు చేసిన దాన్ని అతడు తెలుసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","కనుక నోవహు అన్నాడు: “కనాను శపించబడును గాక! కనాను తన సోదరులకు బానిస అగును గాక!” ");
INSERT INTO tel2010_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","నోవహు ఇంకా ఇలా అన్నాడు: “షేము దేవుడగు యెహోవా స్తుతించబడును గాక! కనాను షేముకు బానిస అవును గాక. ");
INSERT INTO tel2010_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","యాఫెతుకు దేవుడు ఇంకా ఎక్కువ భూమిని ఇచ్చును గాక! షేము గుడారాలలో దేవుడు నివసించు గాక! కనాను వారికి బానిస అవును గాక!” ");
INSERT INTO tel2010_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","జలప్రళయం తర్వాత నోవహు 350 సంవత్సరాలు బతికాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","నోవహు మొత్తం 950 సంవత్సరాలు బతికాడు. తరువాత అతడు మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","నోవహు కుమారులు షేము, హాము, యాఫెతు. ప్రళయం తర్వాత ఈ ముగ్గురు మగవాళ్లు ఇంకా అనేకమంది కుమారులకు తండ్రులయ్యారు. షేము, హాము, యాఫెతు ద్వారా వచ్చిన కుమారుల జాబితా ఇది. యాఫెతు వంశస్థులు: ");
INSERT INTO tel2010_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","యాఫెతు కుమారులు గోమెరు, మాగోగు, మాదయి, యావాను, తుబాలు, మెషెకు, తీరసు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","గోమెరు కుమారులు అష్కనజు, రీఫతు, తోగర్మా ");
INSERT INTO tel2010_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","యావాను కుమారులు ఎలీషా, తర్షీషు, కిత్తీము, దాదోనీము. ");
INSERT INTO tel2010_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","మధ్యధరా సముద్రానికి చుట్టు ప్రక్కల దేశాల్లో నివశించు ప్రజలంతా ఈ యాఫెతు కుమారుల సంతానమే. ఒక్కో కుమారునికి ఒక్కో స్వంత దేశం ఉంది. కుటుంబాలన్ని పెరిగి వేరు వేరు జాతుల వారయ్యారు. ప్రతి జాతివారికి వారి స్వంత భాష ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","హాము కుమారులు కూషు, మిస్రాయిము, పూతు, కనాను. ");
INSERT INTO tel2010_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","కూషు కుమారులు సెబా, హవీలా, సబ్తా. రాయమా కుమారులు షేబ, దదాను. ");
INSERT INTO tel2010_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","కూషుకు నిమ్రోదు అనే కుమారుడు కూడా ఉన్నాడు. భూమిమీద నిమ్రోదు చాలా శక్తిమంతుడయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","నిమ్రోదు యెహోవా యెదుట గొప్ప వేటగాడు. అందుకే మనుష్యులు కొందరిని నిమ్రోదుతో పోల్చి, “ఆ మనిషి నిమ్రోదు వలె యెహోవా యెదుట గొప్ప వేటగాడు” అంటారు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","షీనారు దేశంలో బాబెలు, ఎరెకు, అక్కదు అనే చోట్ల నిమ్రోదు రాజ్యం ఆరంభం అయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","నిమ్రోదు అష్షూరు కూడా వెళ్లాడు. అక్కడే నీనెవె రహోబో, తీరు, కాలహు, ");
INSERT INTO tel2010_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","రెసెను పట్టణాలను అతడు నిర్మించాడు. (నీనెవెకు, కాలహు మహా పట్టణానికి మధ్య రెసెను ఉంది.) ");
INSERT INTO tel2010_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","లూదీయులు, అనామీయులు, లెహాబీయులు, సఫ్తుహీయులు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","సత్రుసీయులు, కఫ్తోరీయుల జనాంగములకు మిస్రాయము తండ్రి. (ఫిలిష్తీయులు కస్లూహీయులలో నుండి వచ్చిన వారే.) ");
INSERT INTO tel2010_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","సీదోను తండ్రి కనాను. కనాను జ్యేష్ఠ కుమారుడు సీదోను, హేతుకు కనాను తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","యెబూసీయులు, అమోరీయులు, గీర్గాషీయులు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","హివ్వీయులు, అర్కీయులు, సినీయులు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","అర్వాదీయులు, సెమారీయులు, హమాతీయులు అందరికి కనాను తండ్రి. కనాను వంశాలు ప్రపంచంలోని వేర్వేరు భాగాలకు వ్యాప్తి చెందాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ఉత్తరాన సీదోను నుండి దక్షీణాన గెరారు వరకు, పశ్చిమాన గాజా నుండి తూర్పున సొదొమ, గొమొర్రా, అద్మా. సెబోయిము నుండి లాషా వరకు కనాను ప్రజల భూభాగమే. ");
INSERT INTO tel2010_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","ఆ ప్రజలంతా హాము సంతానం. ఆ ప్రజలందరికీ వారికి స్వంత భాషలు, స్వంత దేశాలు ఉన్నాయు. వారు వేరు వేరు జాతులయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","యాఫెతు అన్న షేము. షేము వంశస్థుల్లో ఒకడైన ఏబెరు హెబ్రీ ప్రజలందరికీ తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","షేము కుమారులు, ఏలాము, అష్షూరు, అర్పక్షదు, లూదు, అరాము. ");
INSERT INTO tel2010_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","అరాము కుమారులు ఊజు, హోలు, గెతెరుమాష. ");
INSERT INTO tel2010_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","అర్పక్షదు షేలహుకు తండ్రి. షేలహు ఏబెరుకు తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ఏబెరు ఇద్దరు కుమారులకు తండ్రి, ఒక కుమారునికి పెలెగు అని పేరు పెట్టబడింది. అతని జీవిత కాలములోనే భూమి విభజించబడింది. కనుక అతనికి ఈ పేరు పెట్టబడింది. మరో సోదరుడి పేరు యొక్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","యొక్తాను కుమారులు అల్మదాదు, షెలపు, హసర్మావెతు, యెరహు, ");
INSERT INTO tel2010_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","హదోరము, ఊజాలు, దిక్లాను ");
INSERT INTO tel2010_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ఓబాలు, అబీమాయెలు, షేబ, ");
INSERT INTO tel2010_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ఓఫీరు, హవీలా, యోబాబు. ఈ మనుష్యులంతా యొక్తాను కుమారులు. ");
INSERT INTO tel2010_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","మేషాకు దేశానికి, తూర్పునున్న కొండ దేశానికి మధ్య ఆ ప్రజలు జీవించారు. సెపారా దేశపు దిశలో మేషా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","వాళ్లు షేము వంశంనుండి వచ్చిన ప్రజలు. వంశాలు, భాషలు, దేశాలు, జాతులను బట్టి వారి క్రమం ఏర్పాటు చేయబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","నోవహు కుమారుల వంశాల జాబితా అది. అవి వారి జాతుల ప్రకారం ఏర్పాటు చేయబడ్డాయి. జలప్రళయం తర్వాత భూమి అంతటా వ్యాపించిన ప్రజలందరూ ఆ వంశాల నుండి వచ్చిన వారే. ");
INSERT INTO tel2010_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","జలప్రళయం తర్వాత మానవులంతా ఒకే భాష మాట్లాడారు. ప్రజలంతా ఒకే పదజాలం ఉపయోగించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","తూర్పు నుండి ప్రజలు కదిలిపోయారు. షీనారు దేశంలో మైదాన భూమిని వారు కనుగొన్నారు. బతుకుదెరువు కోసం ప్రజలంతా అక్కడే ఉండిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","“మనం ఇటుకలు చేసి, అవి గట్టిపడేందుకు వాటిని కాల్చాలి” అనికొన్నారు ప్రజలు. ఇళ్లు కట్టుటకు ప్రజలు రాళ్లు గాక ఇటుకలనే ఉపయోగించారు. అలానే అడుసు గాక తారు ఉపయోగించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","అప్పుడు ప్రజలు ఇలా అన్నారు: “మన కోసం మనం ఒక పట్టణం కట్టుకోవాలి. ఆకాశం అంత ఎత్తుగా మనం ఒక గోపుర శిఖరం కట్టుకోవాలి. ఇలా గనుక చేస్తే మనం ప్రఖ్యాతి చెందుతాం ప్రపంచమంతటా మనం చెల్లా చెదురవకుండా ఒకే చోట మనమంతా కలసి ఉంటాం.” ");
INSERT INTO tel2010_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ఆ పట్టణాన్ని, ఆ గోపుర శిఖరాన్ని చూచుటకు యెహోవా దిగి వచ్చాడు. వాటిని ప్రజలు నిర్మిస్తూ ఉండటం యెహోవా చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","యెహోవా ఇలా అన్నాడు: “ఈ ప్రజలంతా ఒకే భాష మాట్లాడుతున్నారు. వీళ్లంతా కలసి ఉమ్మడిగా ఈ పని చేస్తున్నట్టు నాకు కనబడుతోంది. వారు చేయగలగిన దానికి ఇది ప్రారంభం మాత్రమే. త్వరలో వాళ్లు యోచించినదేదైనా చేయ గలుగుతారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","అందుచేత మనం కిందికి వెళ్లి వారి భాషను గలిబిలి చేద్దాం. అప్పుడు వాళ్లు ఒకరినొకరు అర్థం చేసుకోలేరు.” ");
INSERT INTO tel2010_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ఆ ప్రజలు భూలోకం అంతటా చెదిరిపోయేటట్టు యెహోవా చేసాడు. కనుక ఆ పట్టణాన్ని కట్టుకోవటం ఆ ప్రజలు ముగించలేకపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","మొత్తం ప్రపంచంలోని భాషను దేవుడు గలిబిలి చేసిన చోటు అదే. కనుక ఆ స్థలం బాబెలు అని పిలువబడింది. కనుక ఆ స్థలం నుండి భూమిమీద ఇతర చోట్లన్నింటికీ ఆ ప్రజలను యెహోవా చెదరగొట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","షేము కుటుంబ చరిత్ర ఇది. జలప్రళయం తర్వాత రెండు సంవత్సరాలకు, షేము 100 సంవత్సరాల వయస్సులో ఉన్నప్పుడు, అతని కుమారుడు అర్పక్షదు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ఆ తర్వాత షేము 700 సంవత్సరాలు జీవించాడు. అతనికి ఇంకా కుమారులు కమార్తెలు, ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","అర్పక్షదు 35 సంవత్సరాల వయస్సులో ఉన్నప్పుడు, అతని కుమారుడు షేలహు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","షేలహు పుట్టిన తర్వాత అర్పక్షదు 403 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కొందరు కుమారులు కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","షేలహుకు 30 సంవత్సరాలు నిండిన తర్వాత అతని కుమారుడు ఏబెరు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ఏబెరు పుట్టిన తర్వాత షేలహు 403 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కొందరు, కుమారలు కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ఏబెరుకు 34 సంవత్సరాలు నిండిన తర్వాత అతని కుమారుడు పెలెగు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","పెలెగు పుట్టిన తర్వాత ఏబెరు 430 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కుమారులు కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","పెలెగుకు 30 సంవత్సరాలు నిండినప్పుడు అతని కుమారుడు రయూ పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","రయూ పుట్టిన తర్వాత, పెలెగు ఇంకా 209 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కొందరు కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","రయూకు 32 సంవత్సరాలు నిండినప్పుడు, అతని కుమారుడు సెరూగు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","సెరూగు పుట్టిన తర్వాత రయూ 207 సంవత్సరాలు బతికాడు. ఆ కాలంలో అతనికి ఇంకా కుమార్తెలు, కుమారులు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","సెరూగుకు 30 సంవత్సరాలు నిండినప్పుడు అతని కుమారుడు నాహోరు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","నాహోరు పుట్టిన తర్వాత, సేరూగు 200 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","నాహోరుకు 29 సంవత్సరాలు నిండినప్పుడు అతని కుమారుడు తెరహు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","తెరహు పుట్టిన తర్వాత నాహోరు 119 సంవత్సరాలు జీవించాడు. ఆ కాలంలో అతనికి ఇంకా కుమారులు, కుమార్తెలు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","తెరహుకు 70 సంవత్సరాలు నిండినప్పుడు, అతని కుమారులు అబ్రాము, నాహోరు, హారాను పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","తెరహు కుటుంబ చరిత్ర ఇది. అబ్రాము, నాహోరు, హారానులకు తండ్రి తెరహు. లోతుకు హారాను తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","కల్దీయుల ఊర్ అనే తన స్వగ్రామంలో హారాను మరణించాడు. తన తండ్రి తెరహు బ్రతికి ఉన్నప్పుడే హారాను చనిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","అబ్రాము, నాహోరు పెళ్లి చేసుకొన్నారు. అబ్రాము భార్యకు శారయి అని పేరు పెట్టబడింది. నాహోరు భార్యకు మిల్కా అని పేరు పెట్టబడింది. మిల్కా హారాను కుమార్తె. మిల్కా ఇస్కాలకు హారాను తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","శారయి పిల్లలను కనే అవకాశం లేనందువల్ల ఆమెకు పిల్లలు లేరు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","తెరహు తన కుటుంబముతోబాటు కల్దీయుల ఊర్ అను పట్టణమును విడచిపెట్టేసాడు. కనానుకు ప్రయాణం చేయాలని వారు ఏర్పాటు చేసుకొన్నారు. తన కుమారుడు అబ్రామును, మనమడు లోతును (హారాను కుమారుడు), కోడలు శారయిని తెరహు తన వెంట తీసుకు వెళ్లాడు. వారు హారాను పట్టణం వరకు ప్రయాణం చేసి, అక్కడ ఉండిపోవాలని నిర్ణయించుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","తెరహు 205 సంవత్సరాలు జీవించాడు. తర్వాత అతడు హారానులో మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","అబ్రాముతో యెహోవా ఇలా అన్నాడు, “నీ దేశాన్ని, నీ ప్రజలను విడిచిపెట్టు. నీ తండ్రి కుటుంబాన్ని విడిచిపెట్టి, నేను నీకు చూపించు దేశానికి వెళ్లు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","నిన్ను ఆశీర్వదిస్తాను. నిన్ను ఒక గొప్ప జాతిగా నేను చేస్తాను నీ పేరును నేను ప్రఖ్యాతి చేస్తాను. ఇతరులను ఆశీర్వదించటానికి ప్రజలు నీ పేరు ఉపయోగిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","నిన్ను ఆశీర్వదించే వారిని నేను ఆశీర్వదిస్తాను. నిన్ను శపించే వాళ్లను నేను శపిస్తాను. భూమి మీదనున్న మనుష్యులందరిని ఆశీర్వదించడానికి నేను నిన్ను ఉపయోగిస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","కనుక అబ్రాము యెహోవాకు విధేయుడై కనాను వెళ్లాడు. అతడు హారానును విడిచిపెట్టాడు, లోతు అతనితో కూడ వెళ్లాడు. ఈ సమయంలో అబ్రాము వయస్సు 75 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","అబ్రాము హారానును విడిచిపెట్టినప్పుడు అతడు ఒంటరి వాడు కాడు. తన భార్య శారయిని, తమ్ముని కుమారుడు లోతును, హారానులో వారికి కలిగిన సమస్తాన్ని అబ్రాము తనతో తీసుకు వెళ్లాడు. హారానులో అబ్రాము సంపాదించిన బానిసలు అంతా వారితో వెళ్లారు. అబ్రాము అతని వర్గంవారు హారాను విడిచి, కనాను దేశానికి ప్రయాణం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","అబ్రాము కనాను దేశం గుండా సంచారం చేసాడు. అబ్రాము షెకము పట్టణానికి పయనించి మోరేలో వున్న మహా వృక్షం దగ్గరకు వచ్చాడు. ఆ కాలంలో కనానీ ప్రజలు ఈ దేశంలో నివసించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","అబ్రాముకు యెహోవా ప్రత్యక్షమయ్యి, “ఈ దేశాన్ని నీ సంతానానికి ఇస్తాను” అన్నాడు. ఆ స్థలంలో అబ్రాముకు యెహోవా ప్రత్యక్షమయ్యాడు. కనుక ఆ స్థలంలో యెహోవాను ఆరాధించటానికి అబ్రాము ఒక బలిపీఠం కట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","తర్వాత అబ్రాము ఆ స్థలం విడిచిపెట్టి బేతేలుకు తూర్పున ఉన్న పర్వత ప్రాంతాలకు వెళ్లాడు. అక్కడ అబ్రాము తన గుడారం వేసుకొన్నాడు. పడమటకి బేతేలు పట్టణం ఉంది. తూర్పున హాయి పట్టణం ఉంది. ఆ స్థలంలో యెహోవా కోసం మరో బలిపీఠాన్ని అబ్రాము నిర్మించాడు. అక్కడ అబ్రాము యెహోవాను ఆరాధించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","ఆ తర్వాత అబ్రాము మరల ప్రయాణం మొదలు పెట్టాడు. నెగెబు దిశగా అతడు ప్రయాణం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","ఆ కాలంలో భూమి చాలా ఎండిపోయింది. వర్షం లేదు కనుక ఏ పంటా పెరగటం లేదు. కనుక అబ్రాము నివసించటానికి ఈజిప్టుకు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","తన భార్య శారయి చాలా అందంగా ఉండటం అబ్రాము గమనించాడు. కనుక వారు ఈజిప్టు చేరకముందే అబ్రాము శారయితో ఇలా చెప్పాడు: “నీవు చాలా అందమైన స్త్రీవని నాకు తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ఈజిప్టీయులు నిన్ను చూస్తారు. ఈ స్త్రీ అతని భార్య అని వాళ్లు అంటారు. తర్వాత వాళ్లు నిన్ను అశించి నన్ను చంపేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","కనుక నీవు నా సోదరివి అని ప్రజలతో చెప్పు. అప్పుడు వాళ్లు నన్ను చంపరు. నేను నీ సోదరుణ్ణి అని అనుకొంటారు గనుక వాళ్లు నామీద దయ చూపిస్తారు. ఈ విధంగా నీవు నా ప్రాణం కాపాడుతావు.” ");
INSERT INTO tel2010_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","కనుక అబ్రాము తన భార్యతో ఈజిప్టు దేశంలో ప్రవేశించారు. శారయి చాలా అందగత్తె అని ఈజిప్టు ప్రజలు చూశారు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ఈజిప్టు నాయకులు కూడ కొందరు ఆమెను చూశారు. ఆమె చాలా అందగత్తె అని ఫరోతో వాళ్లు చెప్పారు. ఆ నాయకులు శారయిని ఫరో యింటికి తీసుకెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","శారయికి అబ్రాము సోదరుడు అనుకొని ఫరో అబ్రాము మీద దయ చూపించాడు. గొర్రెలు, పశువులు, గాడిదలను ఫరో అబ్రాముకు ఇచ్చాడు. సేవకులు, సేవకురాండ్రు, ఒంటెలను కూడా అబ్రాముకు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","అబ్రాము భార్యను ఫరో తీసుకొన్నాడు. కనుక ఫరోకు అతని ఇంటిలోని మనుష్యులందరికి చాలా తీవ్రమైన రోగాలు వచ్చేటట్టు యెహోవా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","అందుచేత ఫరో అబ్రామును పిలిచాడు. ఫరో ఇలా అన్నాడు, “నీవు నాకు చాలా అపకారం చేశావు. శారయి నీ భార్య అని నాతో ఎందుకు నీవు చెప్పలేదు? ");
INSERT INTO tel2010_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","ఈమె నీ సోదరి అని చెప్పావు. నీవు ఎందుకలా చెప్పావు? అమె నా భార్యగా ఉండాలని అమెను నేను తీసుకొన్నాను. అయితే ఇప్పుడు నీ భార్యను మరల నేను నీకు ఇచ్చేస్తున్నాను. ఆమెను తీసుకొని వెళ్లిపో!” ");
INSERT INTO tel2010_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","తర్వాత అబ్రామును ఈజిప్టు నుండి పంపించి వేయుమని ఫరో తన మనుష్యులకు ఆజ్ఞాపించాడు. కనుక అబ్రాము, అతని భార్య ఆ స్థలం విడచి వెళ్లీపోయారు. వాళ్లకు ఉన్న సమస్తాన్ని తీసుకొని వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","కనుక అబ్రాము ఈజిప్టు విడచిపెట్టాడు. తన భార్యను, స్వంతంగా తనకు ఉన్నదంతా తీసుకొని, నెగెబుగుండా అబ్రాము ప్రయాణం చేసాడు. లోతు కూడా వాళ్లతో ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","ఈ సమయానికి అబ్రాము చాలా ఐశ్వర్యవంతుడు. అతనికి చాలా విస్తారంగా పశువులు ఉన్నాయి. చాలా వెండి, బంగారం ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","అబ్రాము చుట్టుప్రక్కల సంచరిస్తూనే ఉన్నాడు. నెగెబు విడచిపెట్టి మళ్లీ బేతేలు వెనుకకు వెళ్లాడు. బేతేలు పట్టణానికి, హాయి పట్టణానికి మధ్యనున్న చోటుకు అతడు వెళ్లాడు. ఇంతకు ముందు అబ్రాము నివసించిన స్థలమే ఇది. ");
INSERT INTO tel2010_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","అబ్రాము ఒక బలిపీఠాన్ని నిర్మించిన స్థలమిది. కనుక ఈ స్థలంలో అబ్రాము యెహోవాను ఆరాధించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ఈ సమయంలో అబ్రాముతో లోతు గూడా ప్రయాణం చేస్తున్నాడు. లోతుకు గొర్రెలు, పశువులు, గుడారాలు చాలా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","అబ్రాముకు, లోతుకు పశువులు విస్తారంగా ఉన్నందువల్ల వాళ్లిద్దరికి ఈ భూమి సరిపోలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","అబ్రాము గొర్రెల కాపరులు లోతు గొర్రెల కాపరులు వాదించుకోవడం మొదలు పెట్టారు. అదే సమయంలో కనానీయులు, పెరిజ్జీయులు కూడా ఈ దేశంలో నివసిస్తున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","కనుక లోతుతో అబ్రాము ఇలా అన్నాడు: “నీకు, నాకు మధ్య వాదం ఏమీ ఉండకూడదు. నీ మనుష్యులు నా మనుష్యులు వాదించుకోగూడదు. మనమంతా సోదరులం. ");
INSERT INTO tel2010_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","మనం వేరైపోవాలి. నీకు ఇష్టం వచ్చిన స్థలం ఏదైనా నీవు కోరుకో నీవు ఎడమకు వెళ్తే నేను కుడికి వెళ్తాను. నీవు కుడికి వెళ్తే, నేను ఎడమకు వెళ్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","లోతు పరిశీలించి యోర్దాను లోయను చూశాడు. అక్కడ నీళ్లు విస్తారంగా ఉన్నట్టు లోతు చూశాడు. (ఇది సొదొమ గొమొర్రాలను యెహోవా నాశనము చేయకముందు ఆ కాలంలో సోయరు వరకు యోర్దాను లోయ యెహోవా తోటలా ఉంది, ఈజిప్టు భూమిలా ఇది కూడ మంచి భూమి.) ");
INSERT INTO tel2010_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","అందుచేత యోర్దాను లోయలో జీవించాలని లోతు నిర్ణయించుకొన్నాడు. ఆ ఇద్దరు మనుష్యులు వేరైపోయారు, లోతు తూర్పు దిక్కుగా ప్రయాణం మొదలు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","అబ్రాము కనాను దేశంలోనే ఉండిపోయాడు, లోతు లోయలోని పట్టణాల్లో నివసించాడు. బాగా దక్షిణాదిన ఉన్న సొదొమకు తరలిపోయి అక్కడ లోతు నివాసం ఏర్పర్చుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","సొదొమ ప్రజలు చాలా దుర్మార్గులు. వాళ్లు ఎప్పుడూ యెహోవాకు వ్యతిరేకంగా పాపం చేస్తున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","లోతు వెళ్లపోయిన తర్వాత అబ్రాముతో యెహోవా ఇలా అన్నాడు: “నీ చుట్టు చూడు ఉత్తరం, దక్షిణం, తూర్పు, పడమర చూడు. ");
INSERT INTO tel2010_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","నీవు చూస్తోన్న ఈ దేశం అంతా నీకు, నీ వారుసులకు నేను ఇస్తాను. ఇది శాశ్వతంగా నీ దేశం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","భూమిమీద ధూళి కణాలు ఎంత విస్తారమో, నీ వారసులను గూడ అంత విస్తరింప జేస్తాను. నేలమీద ధూళి కణాలను ఎవరైనా లెక్కించగలిగితే అది నీ ప్రజల సంఖ్య అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","కనుక వెళ్లు నీ దేశంలో సంచరించు. దానిని ఇప్పుడు నేను నీకు ఇస్తున్నాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","కనుక అబ్రాము తన గుడారాలను తరలించాడు, మమ్రే సమీపంలోని మహా వృక్షాల దగ్గర నివసించాలని అతడు వెళ్లాడు. ఇది హెబ్రోను పట్టణానికి దగ్గరగా ఉంది. యెహోవాను ఆరాధించటానికి ఈ స్థలంలో ఒక బలిపీఠాన్ని అబ్రాము కట్టించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","షీనారు రాజైన అమ్రాపేలు, ఎల్లాసరు రాజైన అర్యోకు, ఏలాం రాజైన కదొర్లాయోమెరు, మరియు గోయియుల రాజైన తిదాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ఈ రాజులంతా కలసి సొదొమ రాజు బెరాతోను, గొమొర్రా రాజు బిర్షా, అద్మా రాజు షినాబు, సెబోయీయుల రాజు షెమేబెరు, బెల రాజు (సోయరు అని కూడ బెల పిలవబడింది) లతో యుద్ధము చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ఈ రాజులంతా సిద్దీము లోయలో వారి సైన్యాలతో కలుసుకున్నారు. (సిద్దీమ లోయ యిప్పుడు ఉప్పు సముద్రం) ");
INSERT INTO tel2010_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","ఈ రాజులు పన్నెండు సంవత్సరాల పాటు కదొర్లాయోమెరుకు సేవ చేసారు. అయితే 13వ సంవత్సరంలో వారంతా అతని మీద తిరుగుబాటు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","కనుక 14వ సంవత్సరంలో కదొర్లాయోమెరు రాజు, అతనితో ఉన్న రాజులు వీరిమీద యుద్ధం చేయటానికి వచ్చారు. కదొర్లొయోమెరు, అతనితో ఉన్న రాజులు అష్తారోతు కర్నాయిములో రఫాయి ప్రజలను ఓడించారు. హాములో జూజీయులను కూడా వారు ఓడించారు. షావే కిర్యతాయిములో ఏమీయులను వారు ఓడించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","శేయీరు కొండ ప్రదేశం నుండి ఏల్పారాను వరకు హోరీయులను వారు ఓడించారు. (ఏల్పారాను ఎడారి దగ్గరగా ఉంది.) ");
INSERT INTO tel2010_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","తర్వాత కదొర్లాయోమెరు రాజు ఉత్తర దిశగా తిరిగి ఏన్మిష్పతు (అంటే కాదేషు) వెళ్లి, అమాలేకీ ప్రజలందర్నీ ఓడించాడు. అమోరీ ప్రజలను కూడా అతడు ఓడించాడు. హససోన్ తమారులో ఈ ప్రజలు నివసిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ఆ సమయంలో సొదొమ రాజు, గొమొర్రా రాజు, అద్మా రాజు, సెబోయిము రాజు, బెల రాజు (బెల అంటె సోయరు) కలసి వారి శత్రువుల మీద సిద్దీము లోయలో యుద్ధం చేయటానికి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","ఏలాము రాజు కదొర్లాయోమెరు, గోయీయుల రాజు తిదాలు, షీనారు రాజు అమ్రాపేలు, ఎల్లాసరు రాజు అర్యోకు మీద వారు యుద్ధము చేసారు. అందుచేత ఈ నలుగురు రాజులు ఆ అయిదుగురితో యుద్ధం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","సిద్దీం లోయలో తారుతో నింపబడ్డ గుంటలు చాలా ఉన్నాయి. సొదొమ, గొమొర్రాల రాజులు వారి సైన్యాలు పారిపోయారు. చాలా మంది సైనికులు ఆ గుంటల్లో పడిపోయారు. అయితే మిగిలివాళ్లు కొండల్లోకి పారిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","కనుక సొదొమ, గొమొర్రా ప్రజల ఆస్తినంతా వారి శత్రువులు తీసుకుపోయారు. వారి బట్టలు, భోజనం అంతా తీసుకొని వారు వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","అబ్రాము సోదరుని కుమారుడు లోతు సొదొమలో నివసిస్తుండగా శత్రువు అతణ్ణి బంధించాడు. అతని ఆస్తి మొత్తం తీసుకొని శత్రువు వెళ్లిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","పట్టుబడని లోతుయొక్క మనుష్యులలో ఒకడు అబ్రాము దగ్గరకు వెళ్లి జరిగినదాన్ని చెప్పాడు. అమ్మోరీవాడగు మమ్రే చెట్లదగ్గర అబ్రాము నివాసం చేస్తున్నాడు. మమ్రే, ఎష్కోలు, అనేరు ఒకరికి ఒకరు సహాయ ఒడం బడిక చేసుకొన్నారు. అబ్రాహాముకు సహాయం చేసేందుకు గూడ వారు ఒక ఒడంబడిక చేసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","లోతు బంధించబడ్డాడని అబ్రాముకు తెలిసింది. కనుక అబ్రాము తన కుటుంబం అతంటిని సమావేశ పర్చాడు. వారిలో 318 మంది శిక్షణ పొందిన సైనికులు ఉన్నారు. అబ్రాము తన మనుష్యులకు నాయకత్వం వహించి, దాను పట్టణం వరకు శత్రువును పూర్తిగా తరిమివేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","ఆ రాత్రి అతడు, అతని మనుష్యులు శత్రువు మీద అకస్మాత్తుగా దాడి జరిపారు. వారు శత్రువును ఓడించి దమస్కుకు ఉత్తరాన హూబ వరకు వారిని తరిమివేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","అప్పుడు అబ్రాము శత్రువు దొంగిలించిన వస్తువులన్నింటిని మరల వెనుకకు తీసుకొని వచ్చాడు. స్త్రీలను, సేవకులను, లోతును, అతని ఆస్తి అంతటిని అబ్రాము వెనుకకు తీసుకొని వచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","కదొర్లాయోమెరును, అతనితో ఉన్న రాజులను ఓడించిన తర్వాత అబ్రాము తన యింటికి తిరిగి వెళ్లాడు. అతడు యింటికి వచ్చుచున్నప్పుడు షావే లోయలో అతణ్ణి కలుసుకొనేందుకు సొదొమ రాజు వెళ్లాడు. (ఇప్పుడు దీనిని రాజు లోయ అంటారు.) ");
INSERT INTO tel2010_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","షాలెము రాజు మెల్కీసెదెకు కూడా అబ్రామును కలుసుకొనేందుకు వెళ్లాడు. సర్వోన్నతుడైన దేవునికి మెల్కీసెదెకు యాజకుడు. రొట్టెను ద్రాక్షారసాన్ని మెల్కీసెదెకు తెచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","మెల్కీసెదెకు అబ్రామును ఆశీర్వదించి ఇలా అన్నాడు: “అబ్రామా, మహోన్నతుడైన దేవుడు నీకు దీవెనలు ప్రసాదించుగాక, దేవుడు భూమ్యాకాశాలను చేసినవాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","సర్వోన్నతుడైన దేవుణ్ణి మనం స్తుతిస్తున్నాం నీ శత్రవుల్ని ఓడించటానికి ఆయనే నీకు సహాయం చేసాడు.” యుద్ధ సమయంలో అబ్రాము తెచ్చుకొన్న దానంతటిలో నుండి పదోవంతు మెల్కీసెదెకునకు అతడు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","అప్పుడు సొదొమ రాజు, “వీటన్నింటిని నీ కోసమే ఉంచుకో. శత్రువుచేత బాధించబడి తీసుకొనిపోబడ్డ నా మనుష్యులను మాత్రం నాకు ఇచ్చేయి” అని అబ్రాముతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","అయితే సొదొమ రాజుతో అబ్రాము ఇలా చెప్పాడు: “భూమిని ఆకాశాన్ని చేసిన మహోన్నతుడైన యెహోవా దేవుని పేర నేను వాగ్దానం చేస్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","నీకు చెందినది ఏదీ నేను ఉంచుకోను. ఒక నూలుపోగైనా లేక జోళ్ల దారాలయినా, ఏదీ ఉంచుకోనని నేను వాగ్దానం చేస్తున్నాను. ‘అబ్రామును నేనే ధనికునిగా చేసానని నీవు చెప్పడం నాకిష్టం లేదు.’ ");
INSERT INTO tel2010_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","నా యువకులు భుజించిన ఆహారం ఒక్కటి మాత్రము నేను స్వీకరిస్తాను. అయితే మిగిలిన వారికి వారి వంతు నీవు ఇవ్వాలి. యుద్ధములో మేము గెలుచుకొన్న వాటిని తీసుకొని, ఆనేరు, ఎష్కోలు, మమ్రేలకు రావలసిన భాగాలు వారికి ఇవ్వు. వీళ్లు నాకు యుద్ధంలో సహాయపడ్డారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ఈ సంగతులన్నీ జరిగాక, ఒక దర్శనంలో అబ్రాముకు యెహోవా వాక్కు వచ్చి “అబ్రామూ భయపడకు, నేను నిన్ను కాపాడుతాను. నేను నీకు గొప్ప ప్రతిఫలం ఇస్తాను” అన్నాడు దేవుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","అయితే అబ్రాము అన్నాడు; “యెహోవో దేవా, నన్ను సంతోష పెట్టగలిగేందుకు నీవు ఇవ్వగలిగింది ఏదీ లేదు. ఎందుచేతనంటే నాకు కుమారుడు లేడు. కనుక నేను చనిపోయిన తర్వాత, నా సేవకుడును దమస్కువాడైన ఎలీయెజెరు నా ఆస్తి అంతటికి కర్త అవుతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","అబ్రాము: “చూడు దేవా, నాకు నీవు కుమారుణ్ణి ఇవ్వలేదు. కనుక నా ఇంటిలో పుట్టిన సేవకుడు నాకు గల ఆస్తి అంతా దక్కించుకొంటాడు,” ");
INSERT INTO tel2010_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","అప్పుడు అబ్రాముతో యెహోవా మాట్లాడాడు: “నీకు ఉన్నవాటన్నింటిని పొందేవాడు నీ సేవకుడు కాదు. నీకు ఒక కుమారుడు కలుగుతాడు. నీకుగల వాటన్నింటిని నీ కుమారుడు పొందుతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","అంతట దేవుడు అబ్రామును గుడారము బయటకు తీసుకొని వెళ్లి, ఇలా చెప్పాడు: “ఆకాశం చూడు, అక్కడ ఎన్ని నక్షత్రాలు ఉన్నాయో చూడు. అవి చాలా ఉన్నాయి. నీవు లెక్కపెట్టలేవు. భవిష్యత్తులో నీ కుటుంబం అలాగే ఉంటుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","అబ్రాము దేవుణ్ణి నమ్మాడు, అబ్రాముయొక్క విశ్వాసాన్ని దేవుడు నీతిగా అంగీకరించాడు ");
INSERT INTO tel2010_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","అబ్రాముతో దేవుడు ఇలా అన్నాడు, “కల్దీయుల ఊరు అను పట్టణము నుండి నిన్ను బయటకు నడిపించిన యెహోవాను నేనే. ఈ దేశాన్ని నీకు ఇచ్చేందుకు నేను అలా చేసాను. ఈ దేశం నీ స్వంతం అవుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","అయితే అబ్రాము, “యెహోవా, నా ప్రభువా ఈ దేశం నాదే అవుతుందని నాకు ఎలా తెలుస్తుంది?” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","అబ్రాముతో దేవుడు అన్నాడు: “మనం ఒక ఒడంబడిక చేసుకొందాం. మూడు సంవత్సరాల ఆవు ఒకటి, మూడు సంవత్సరాల మేక ఒకటి, మూడు సంవత్సరాల పొట్టేలు ఒకటి తీసుకురా. ఇంకా నా కోసం ఒక పావురాన్ని, ఒక చిన్న పావురాన్ని తీసుకురా.” ");
INSERT INTO tel2010_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","దేవుని కోసం వీటన్నిటిని అబ్రాము తెచ్చాడు. ఆ జంతువులన్నింటిని చంపి ఒక్కోదాన్ని రెండేసి ముక్కలు చేసాడు, తర్వాత అబ్రాము ఈ భాగాలను ఒకదానికొకటి ఎదురెదురుగా వేసాడు. పక్షులను రెండు భాగాలుగా అబ్రాము ఖండించలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","తర్వాత ఈ జంతువులను తినటానికి పెద్ద పక్షులు వచ్చి వాలాయి. కాని అబ్రాము వాటిని వెళ్లగొట్టేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","తర్వాత ఆ రోజు సూర్యుడు అస్తమిస్తున్నాడు. అబ్రాముకు బాగా నిద్ర వచ్చి నిద్రపోయాడు. అతడు నిద్రపోతూ ఉండగా భయంకర గాఢ చీకటి కమ్మింది. ");
INSERT INTO tel2010_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","అప్పుడు అబ్రాముతో యెహోవా ఇలా చెప్పాడు: “ఈ సంగతులు నీవు తెలుసుకోవాలి, నీ సంతానము విదేశీయులై వారి స్వంతం కాని దేశంలో అపరిచితులుగా ఉంటారు. వారు అక్కడ బానిసలుగా ఉంటారు. ఇంకా, 400 సంవత్సరాలు కఠినంగా వాళ్లు శ్రమ పెట్టబడతారు. ");
INSERT INTO tel2010_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","అయితే వాళ్లకు యజమానిగా ఉన్న దేశాన్ని, 400 సంవత్సారాల తరువాత నేను శిక్షిస్తాను. మరి నీ ప్రజలేమో ఆ దేశాన్ని విడిచి పెట్టేస్తారు. నీ ప్రజలు వెళ్లిపోయేటప్పుడు విస్తారమైన ఆస్తులను వారితో తీసుకొనిపోతారు. ");
INSERT INTO tel2010_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","“నీ మట్టుకు నీవు చాలా వృద్ధాప్యం వరకు జీవిస్తావు, మనశ్శాంతితో నీవు మరణిస్తావు. నీ వంశం వారితో నీవు పాతి పెట్టబడతావు. ");
INSERT INTO tel2010_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","నాలుగు తరాల తర్వాత నీ ప్రజలు మరల ఈ దేశం వస్తారు. ఆ సమయంలో అమోరీ ప్రజలను నీ ప్రజలు ఓడిస్తారు. అక్కడ నివసిస్తోన్న అమోరీ ప్రజలను శిక్షించుటానికి నీ ప్రజలను నేను వాడుకొంటాను. ఇది భవిష్యత్తులో జరుగుతుంది. ఎందుచేతనంటే, శిక్షకు తగినంత చెడుతనం ఇప్పుడు అమోరీ ప్రజల్లో లేదు.” ");
INSERT INTO tel2010_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","సూర్యుడు అస్తమించాక, చాలా చీకటి పడింది, చచ్చిన జంతువులు రెండేసి ముక్కలుగా ఖండించబడి ఇంకా అక్కడే నేలమీద పడి ఉన్నాయి. ఆ సమయంలో పొగమంటల వరుస చచ్చిన జంతువుల రెండేసి ముక్కల మధ్యగా సాగిపోయింది. దేవుడు అబ్రాముతో చేసుకొన్న ఒప్పందానికి ఇది ఒక “ముద్ర” లేక “సంతకం.” ఆ రోజుల్లో, కోయబడ్డ జంతువుల ముక్కల మధ్య నడవడం అనే ఒడంబడిక ఆ మనిషి యొక్క నిజాయితీని తెలుపుతుంది. “నేను ఈ ఒడంబడికను అనుసరించకపోతే ఇదే నాకు జరుగనీ” అన్నది దీని అర్థం. ");
INSERT INTO tel2010_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","కనుక ఆనాడు, ఒక వాగ్దానాన్ని, ఒక ఒడంబడికను అబ్రాముతో యెహోవా చేసాడు. యెహోవా అన్నాడు: “ఈ దేశాన్ని నీ సంతానమునకు నేను ఇస్తాను. ఈజిప్టు నదికి, యూఫ్రటీసు నదికి మధ్య ఉన్న దేశాన్ని నేను వారికి ఇస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","కెనీయులు, కెనిజ్జీయులు, కద్మానీయులు, ");
INSERT INTO tel2010_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","హిత్తీయులు, పెరిజ్జీయులు, రెఫాయీమీయులు, ");
INSERT INTO tel2010_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","అమోరీయులు, కనానీయులు, గిర్గాషీయులు, యోబూషీయుల దేశమిది.” ");
INSERT INTO tel2010_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","అబ్రాము భార్య శారయి. ఆమెకు, అబ్రాముకు పిల్లలు లేరు. శారయికి ఈజిప్టుకు చెందిన పని పిల్ల ఉంది. ఆమె పేరు హాగరు. ");
INSERT INTO tel2010_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","శారయి అబ్రాముతో యిలా చెప్పింది: “చూడండి నాకు పిల్లలు పుట్టకుండా చేసాడు యెహోవా. కనుక మీరు నా పని మనిషితో పొండి. ఆమె ద్వారా పుట్టే శిశువును నా స్వంత శిశువుగా నేను స్వీకరిస్తాను.” తన భార్య శారయి మాట అబ్రాము విన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","కనాను దేశంలో అబ్రాము పది సంవత్సరాలు జీవించిన తర్వాత ఇది జరిగింది. హాగరును తన భర్త అబ్రాముకు శారయి యిచ్చింది. (హాగరు ఈజిప్టు నుండి వచ్చిన దాసి) ");
INSERT INTO tel2010_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","అబ్రాము వల్ల హాగరు గర్భవతి అయింది. హాగరు ఇది గమనించినప్పుడు. ఆమె చాలా గర్వపడి, తన యజమానురాలైన శారయికంటే తాను గొప్పదాన్ని అని తలంచడం మొదలు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","అయితే శారయి అబ్రాముతో, “నా పనిమనిషి ఇప్పుడు నన్నే అసహ్యించుకొంటుంది. దీనికి నేను నిన్నే నిందిస్తాను. ఆమెను నేను నీకు ఇచ్చాను. ఆమె గర్భవతి అయింది. అయితే ఆమె నాకంటే గొప్పదని భావిస్తుంది. మనలో ఎవరు సరియైనవాళ్లో యెహోవాయే నిర్ణయించాలని నేను కోరుతున్నాను” అని అనింది. ");
INSERT INTO tel2010_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","కాని అబ్రాము, “హాగరుకు నీవు యజమానురాలివి, నీ యిష్టం వచ్చినట్టు నీవు ఆమెకు చేయవచ్చు” అన్నాడు శారయితో. అందుచేత శారయి తన పనిమనిషిని చాలా చులకనగా చూసింది. ఆ పనిమనిషి పారిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ఎడారిలో నీటి ఊట దగ్గర యెహోవా దూతకు ఆ పనిమనిషికి కనబడింది. షూరు మార్గంలో ఆ ఊట ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","“హాగరూ, నీవు శారయి పని మనిషివి గదూ! ఇక్కడెందుకు ఉన్నావు? నీవు ఎక్కడికి వెళ్తున్నావు?” అని ఆ దూత అడుగగా, “నా యజమానురాలు శారయి నుండి పారిపోతున్నాను” అని చెప్పింది హాగరు. ");
INSERT INTO tel2010_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","“నీ యజమానురాలి దగ్గరకు నీవు తిరిగి వెళ్లు, ఆమెకు లోబడి నడుచుకో” అని యెహోవా దూత ఆమెతో చెప్పడం జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","“నీలో నుండి అనేక జనములు వస్తారు. వారు చాలామంది ఉంటారు గనుక వాళ్లను లెక్కపెట్టడం కూడ కుదరదు” అని కూడ యెహోవా దూత చెప్పడం జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ఇంకా యెహోవా దూత, “ఇప్పుడు నీవు గర్భవతివి, మరి నీకు ఒక కుమారుడు పుడ్తాడు. అతనికి ఇష్మాయేలు అని పేరు పెడతావు. ఎందుచేతనంటే నీ కష్టాల్ని గూర్చి యెహోవా విన్నాడు. ఆయన నీకు సహాయం చేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","ఇష్మాయేలు అడవి గాడిదలా అదుపులేక, స్వేచ్ఛగా ఉంటాడు అతడు అందరికి వ్యతిరేకమే ప్రతి ఒక్కరూ అతనికి వ్యతిరేకమే తన సోదరులకు దగ్గరగా అతడు నివసిస్తాడు కాని అతడు వారికి వ్యతిరేకంగా ఉంటాడు.” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","ఆ పనిమనిషితో యెహోవా మాట్లాడాడు. దేవునికి ఆమె ఒక కొత్త పేరు ప్రయోగించింది. “నన్ను చూసే దేవుడవు నీవు” అని ఆయనతో చెప్పింది. “ఈ స్థలంలో కూడా దేవుడు నన్ను చూస్తున్నాడు, రక్షిస్తున్నాడు” అని అనుకొన్నందువల్ల ఆమె ఇలా చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","కనుక ఆ బావి బెయేర్ లహాయిరోయి అని పిలువబడింది. కాదేషుకు బెరెదుకు మధ్య ఉంది ఆ బావి. ");
INSERT INTO tel2010_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","హాగరు ఒక కుమారునికి జన్మనిచ్చింది. ఆ కుమారునికి ఇష్మాయేలు అని అబ్రాము పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","హాగరుకు ఇష్మాయలు పుట్టినప్పుడు అబ్రాము వయస్సు 86 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","అబ్రాముకు 99 సంవత్సారల వయస్సు ఉన్నప్పుడు యెహోవా అతనికి కనపడి యిలా చెప్పాడు: “నేను సర్వశక్తిమంతుడైన దేవుడిని నా కోసం ఈ పనులు చేయి. నాకు విధేయుడవై, సరైన జీవితం జీవించు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","ఇలా గనుక నీవు చేస్తే మన ఇద్దరి మధ్య ఒక ఒడంబడికను నేను తయారు చేస్తాను. నిన్ను బాగా అభివృద్ధి చేస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","అప్పుడు దేవునియెదుట అబ్రాము సాష్టాంగ పడ్డాడు. అతనితో దేవుడు అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“మన ఒడంబడికలో నా భాగం ఇది. అనేక జనములకు నిన్ను తండ్రిగా నేను చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","నీ పేరు నేను మార్చేస్తాను. నీ పేరు అబ్రాము కాదు—నీ పేరు అబ్రాహాము. అనేక జనాంగములకు నీవు తండ్రివి అవుతావు గనుక, నీకు నేను ఈ పేరు పెడుతున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","నీకు నేను పెద్ద సంతానాన్ని ఇస్తాను. నీనుండి కొత్త జనాంగాలు ఉద్భవిస్తాయి. నీనుండి కొత్త రాజులు వస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","నీకు నాకు మధ్య ఒక ఒడంబడికను నేను ఏర్పాటు చేస్తాను. నీ సంతానానికి ఈ ఒడంబడిక వర్తిస్తుంది. నేను నీకు దేవునిగా ఉంటాను. నీ సంతానానికి దేవునిగా ఉంటాను. ");
INSERT INTO tel2010_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","నీవు పరాయివాడిగా నివసిస్తున్న ఈ దేశాన్ని అంటే కనాను దేశాన్ని నీకును, నీ సంతానపు వారందిరికిని శాశ్వతపు హక్కుగా ఇస్తాను. నేను మీకు దేవునిగా ఉంటాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","అబ్రాహాముతో దేవుడు ఇంకా ఇలా చెప్పాడు: “ఇక, ఒడంబడికలో నీ భాగం యిది. ఒడంబడికను నీవు నిలబెట్టాలి నీవూ, నీ సంతానమంతా నా ఒడంబడికకు విధేయులు కావాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","మీరు విధేయులు కావాల్సిన ఒడంబడిక ఇదే. ఇది మీకు, నాకు మధ్య ఒడంబడిక. ఇది నీ సంతానము వారి కోసమూను; పుట్టిన ప్రతి పిల్లవాడికి తప్పక సున్నతి చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","నీకు నాకు మధ్యగల ఒడంబడికను నీవు అనుసరిస్తావని తెలియ చేసేందుకు నీవు నీ మర్మాంగపు ముందు చర్మాన్ని కోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","నీ జనములో పుట్టిన ప్రతి బాలుడు, నీ జనమునుండి కాక, ఇతర జనములనుండి డబ్బుతో బానిసగా కొనబడిన వారిలో ప్రతి పురుషుడు సున్నతి చేయించుకొనవలెను. ");
INSERT INTO tel2010_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","కనుక నీ జాతి అంతటిలో ప్రతి పిల్లవానికి సున్నతి జరుగుతున్నది. నీ వంశంలో పుట్టిన ప్రతి పిల్లవాడికి, లేక బానిసగా కొనబడిన పిల్లవాడికి సున్నతి జరుగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ఇది నా చట్టం, నీకు నాకు మధ్యనున్న ఒడంబడిక. సున్నతి చేయని ఏ మగవాడైనా సరే తన ప్రజల్లో నుండి తొలగించివేయ బడతాడు. ఎందుచేతనంటే, ఆ వ్యక్తి నా ఒడంబడికను ఉల్లంఘించాడు కనుక.” ");
INSERT INTO tel2010_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","అబ్రాహాముతో దేవుడు అన్నాడు: “నీ భార్య శారయికి నేను ఒక కొత్త పేరు పెడ్తాను. ఆమె కొత్త పేరు శారా. ");
INSERT INTO tel2010_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","ఆమెను నేను ఆశీర్వదిస్తాను. ఆమెకు ఒక కుమారుణ్ణి నేను ఇస్తాను, మరి నీవు తండ్రివి అవుతావు. అనేక కొత్త జనాంగములకు ఆమె తల్లి అవుతుంది. జనముల రాజులు ఆమెలోనుండి వస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","దేవుణ్ణి గౌరవించుటకు అబ్రాహాము ముఖం క్రిందికి దించుకొన్నాడు. అయితే అతడు నవ్వి తనలో తాను అనుకొన్నాడు: “నా వయస్సు 100 సంవత్సరాలు. నాకు కొడుకు పుట్టజాలడు. మరి శారా వయస్సు 90 సంవత్సరాలు. ఆమెకు శిశువు జన్మించడం అసాధ్యం.” ");
INSERT INTO tel2010_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","అప్పుడు అబ్రాహాము దేవునితో ఇలా అన్నాడు: “నా కుమారుడు ఇష్మాయేలు జీవించి నిన్ను సేవిస్తాడని అశిస్తున్నాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","దేవుడు చెప్పాడు: “లేదు! నీ భార్య శారాకు కుమారుడు పుడతాడని నేను చెప్పాను. అతనికి ఇస్సాకు అని నీవు పేరు పెడ్తావు. అతనితో నేను నా ఒడంబడిక చేసుకొంటాను. ఆ ఒడంబడిక అతని సంతానాలన్నిటితోను శాశ్వతంగా కొనసాగే ఒడంబడికగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“ఇష్మాయేలును గూర్చి నీవు నన్ను అడిగావు, నేను విన్నాను. అతణ్ణి నేను ఆశీర్వదిస్తాను. అతనికి చాలా మంది పిల్లలు ఉంటారు. పన్నెండు మంది మహా నాయకులకు అతడు తండ్రి అవుతాడు. అతని కుటుంబం ఒక గొప్ప జాతి అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","అయితే ఇస్సాకుతో నేను నా ఒడంబడిక చేస్తాను. శారాకు పుట్టబోయే కుమారుడు ఇస్సాకు. వచ్చే సంవత్సరం సరిగ్గా ఇదే కాలంలో నీకు కుమారుడు పుడతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","అబ్రాహాముతో దేవుడు మాట్లాడటం ముగించిన తర్వాత అబ్రాహాము ఒంటరిగా ఉన్నాడు. దేవుడు లేచి అబ్రాహామును విడచి వెళ్లపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","తన కుటుంబంలోని మగవాళ్లకు, బాలురకు సున్నతి చేయమని అబ్రాహాముతో దేవుడు చెప్పాడు. కనుక ఇష్మాయేలును, తన ఇంట పుట్టిన సేవకులందరిని అబ్రాహాము సమావేశపర్చాడు. డబ్బుతో కొనబడిన సేవకులను గూడ అబ్రాహాము సమావేశపర్చాడు. అబ్రాహాము ఇంటిలోని ప్రతి పురుషుడు, బాలుడు ఒక చోట సమావేశ పర్చబడ్డారు. వారందరికి సున్నతి చేయబడింది. అబ్రాహాము దేవుడు చెప్పినట్లు వారందరికి సున్నతి చేశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","అబ్రాహాము సున్నతి జరిగినప్పుడు అతని వయస్సు 99 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","అతని కుమారుడు ఇష్మాయేలుకి సున్నతి జరిగినప్పుడు అతడు 13 ఏండ్లవాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","అబ్రాహాము, అతని కుమారుడు ఇద్దరు ఒకే రోజున సున్నతి చేయబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ఆ రోజునే అబ్రాహాము ఇంటిలోని మగవాళ్లందరికి గూడ సున్నతి జరిగింది. అతని ఇంట పుట్టిన సేవకులందరికి, అతడు కొన్న సేవకులందరికి సున్నతి జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","తర్వాత మళ్లీ అబ్రాహామునకు యెహోవా ప్రత్యక్షమయ్యాడు. మమ్రేలోని సింధూర వనమునకు దగ్గర్లో అబ్రాహాము నివసిస్తున్నాడు. ఒకనాడు మిట్ట మధ్యాహ్నం అబ్రాహాము తన గుడార ద్వారం దగ్గర కూర్చున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","అబ్రాహాము తలెత్తి చూడగా, తన ముందర నిలచిన ముగ్గురు మనుష్యులు కనబడ్డారు. అబ్రాహాము వాళ్లను చూడగానే అతడు వారి దగ్గరకు వెళ్లి: వారి ముందు వంగి, ");
INSERT INTO tel2010_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","ఇలా అన్నాడు, “అయ్యలారా, మీ దాసుడనైన నా దగ్గర దయచేసి కొంత కాలం ఉండండి. ");
INSERT INTO tel2010_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","మీ కాళ్లు కడుక్కొనేందుకు నేను నీళ్లు తెస్తాను. చెట్ల కింద మీరు విశ్రాంతి తీసుకోవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","మీ కోసం నేను భోజనం తెస్తాను, కడుపు నిండా భోంచేయండి. తర్వాత మీ దారిన మీరు వెళ్లొచ్చు.” “చాలా బాగుంది, అలాగే కానీయి” అన్నారు ఆ ముగ్గురు మనుష్యులు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","అబ్రాహాము తన గుడారము దగ్గరకు త్వరత్వరగా వెళ్లాడు. “మూడు రొట్టెలకు సరిపడె గోధుమలు త్వరగా తయారు చేయి” అన్నాడు శారాతో అబ్రాహాము. ");
INSERT INTO tel2010_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","తర్వాత అబ్రాహాము తన పశువుల దగ్గరకు పరుగెత్తాడు. అబ్రాహాము చాలా మంచి యవ్వనంలో ఉన్న దూడను తీసుకొని తన సేవకునికి ఇచ్చాడు. త్వరగా ఆ దూడను వధించి, దానితో భోజనం సిద్ధం చేయుమని అబ్రాహాము చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","ఆ మాంసాన్ని ఆ ముగ్గురు మనుష్యులు భోంచేసేందుకు అబ్రాహాము ఇచ్చాడు. అతడు పాలు, వెన్న కూడ వాళ్లకు ఇచ్చాడు. ఆ ముగ్గురు చెట్టు కింద భోజనం చేస్తూ ఉండగా అబ్రాహాము వారి దగ్గర నిలబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","“నీ భార్య శారా ఎక్కడ?” అంటూ ఆ ముగ్గురు అబ్రాహామును అడిగారు. “అమె అక్కడ గుడారంలో ఉంది” అన్నాడు అబ్రాహాము. ");
INSERT INTO tel2010_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","అప్పుడు యెహోవా, “మళ్లీ వసంతకాలంలో నేను వస్తాను. అప్పటికి నీ భార్య శారాకు ఒక కుమారుడు కలిగి ఉంటాడు” అన్నాడు. గుడారం లోపల శారా ఈ విషయాలు విన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","అబ్రాహాము శారాలు చాలా ముసలివాళ్లు. స్త్రీలు పిల్లలను కనగల వయస్సు శారాకు దాటిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","అందుచేత తాను విన్న మాటలను శారా నమ్మలేదు. “ఇప్పుడు నేను ముసలిదాన్ని, నా భర్త ముసలివాడు. నాకు కొడుకు పుట్టటానికి నేను మరీ ముసలిదాన్ని కదా” అనుకొంది తనలో తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","అప్పుడు అబ్రాహాముతో యెహోవా ఇలా అన్నాడు: “నేను చెప్పింది శారా నమ్మటం లేదు. ఆమె నవ్వింది. నాకు కొడుకు పుట్టటానికి నేను మరీ ముసలిదాన్ని కదా!” అంది. ");
INSERT INTO tel2010_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","యెహోవాకు అసాధ్యమైనది ఏదైనా ఉందా? నేను వస్తానని చెప్పిన వసంతకాలంలో మళ్లీ వస్తాను, అప్పుడు నీ భార్య శారాకు కుమారుడు ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","అయితే శారా, “నేను నవ్వలేదు” అంది. (భయపడి అమె అలా అంది.) కాని యెహోవా, “కాదు, నీవు చెప్పేది నిజం కాదని నాకు తెలుసు. నీవు నవ్వావు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","అప్పుడు ఆ మనుష్యులు వెళ్లటానికి లేచారు. వారు సొదొమ వైపు చూసి, ఆ దిశగా నడక ప్రారంభించారు. వారికి వీడ్కోలు చెప్పటానికి అబ్రాహాము వాళ్లతో కొంత దూరం నడిచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","యెహోవా తనలో తాను ఇలా అనుకొన్నాడు: “ఇప్పుడు నేను చేయబోతున్నది అబ్రాహాముకు నేను చెప్పాలా? ");
INSERT INTO tel2010_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","అబ్రాహాము గొప్ప శక్తిగల జనానికి మూల పురుషుడు అవుతాడు. అతని మూలంగా భూమి మీది ప్రజలంతా ఆశీర్వదించబడుతారు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","అబ్రాహాముతో నేను ఒక ప్రత్యేక ఒడంబడిక చేసుకున్నాను. అతని పిల్లలు, సంతానము యెహోవా ఇష్ట ప్రకారం జీవించేటట్టు అబ్రాహాము వారికి ఆజ్ఞాపించాలని చెప్పి, నేను ఇలా చేసాను. సక్రమంగా న్యాయంగా వాళ్లు జీవించాలని చెప్పి నేను ఇలా చేసాను. అప్పుడు, యెహోవానైన నేను వాగ్దానం చేసిన వాటిని అతనికి ఇవ్వగలను.” ");
INSERT INTO tel2010_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","మరల యెహోవా ఇలా అన్నాడు: “సొదొమ గొమొర్రాల అరుపులు చాలా పెద్దవి. వారి పాపం చాలా భయంకరమైనది. అని నేను విన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","కనుక నేను వెళ్లి, అక్కడి విషయాలు నేను విన్నంత చెడ్డగా ఉన్నాయేమో చుస్తాను. అప్పుడు నాకు నిశ్చయంగా తెలుస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","అంచేత ఆ మనుష్యులు మళ్లీ, సొదొమవైపు నడక ప్రారంభించారు. అయితే అబ్రాహాము యెహోవాతో అక్కడ ఉండిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","అప్పుడు అబ్రాహాము యెహోవాను సమీపించి ఇలా అడిగాడు. “యెహోవా, నీవు దుష్టులను నాశనం చేసేటప్పుడు మంచి వారిని కూడా నాశనం చేస్తావా? ");
INSERT INTO tel2010_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ఆ పట్టణంలో ఒకవేళ 50 మంది మంచి వాళ్లు ఉంటే ఎలా? ఆ పట్టణాన్ని నాశనం చేసేస్తావా? అక్కడ నివసిస్తున్న 50 మంది మంచివాళ్ల కోసం తప్పక నీవు ఆ పట్టణాన్ని కాపాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ఆ పట్టణాన్ని నీవు అసలు నాశనం చేయనే చేయవు. చెడ్డవాళ్లను చంపడంకోసం 50 మంది మంచి వాళ్లను నీవు నాశనం చేయవు. అలా గనుక జరిగితే మంచివాళ్లు చెడ్డవాళ్లు సమానమై, ఇద్దరూ శిక్షించబడుతారు. భూలోకమంతటికి నీవు న్యాయమూర్తివి. నిజంగా నీవు సరైనదే చేస్తావని నాకు తెలుసు.” ");
INSERT INTO tel2010_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","అప్పుడు, “సొదొమ పట్టణంలో 50 మంది మంచి వాళ్లు నాకు కనబడితే, నేను ఆ పట్టణం అంతటిని కాపాడుతాను” అన్నాడు యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","దానికి అబ్రాహాము ఇలా అన్నాడు: “ప్రభూ, నీతో పోల్చుకొంటే, నేను ధూళిని, బూడిదను మాత్రమే. అయినా నేను మరోసారి తెగించి ఈ ప్రశ్న అడుగుతున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ఒకవేళ అయిదుగురు మంచివాళ్లు తప్పిపోయి, 45 మంది మాత్రమే మంచివాళ్లు ఆ పట్టణంలో ఉంటే ఎలా? కేవలం అయిదుగురు తక్కువ అయినందువల్ల మొత్తం పట్టణమంతటిని నాశనం చేస్తావా?” “అక్కడ 45 మంది మంచివాళ్లు గనుక నాకు కనబడితే, ఆ పట్టణాన్ని నేను వదిలివేస్తాను” అన్నాడు యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","మరల అబ్రాహాము, “అక్కడు 40 మంది మాత్రమే మంచివాళ్లు నీకు కనబడినా, నీవు ఆ పట్టణాన్ని నాశనం చేస్తావా?” అని యెహోవాను అడిగాడు. “40 మంది మంచి వాళ్లు నాకు కనబడితే, నేను ఆ పట్టణాన్ని నాశనం చేయను” అన్నాడు యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","అందుకు అబ్రాహాము, “ప్రభూ, నా మీద కోపగించకు. మరొక్క మాట అడుగుతాను. ఆ పట్టణంలో 30 మంది మాత్రమే మంచివాళ్లు కనబడితే, నీవు ఆ పట్టణాన్ని నాశనం చేస్తావా?” అని అడిగాడు. అందుకు యెహోవా, “అక్కడ 30 మంది మంచి వాళ్లు నాకు కనబడితే, ఆ పట్టణాన్ని నేను నాశనం చేయను” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","అప్పుడు అబ్రాహాము, “నా ప్రభువుతో మరోసారి మాటలాడ తెగించితిని ఒకవేళ అక్కడ 20 మంది మంచివాళ్లే ఉంటే” అన్నాడు. “20 మంది మంచివాళ్లు నాకు కనబడితే ఆ పట్టణాన్ని నేను నాశనం చేయను” అని జవాబిచ్చాడు యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","అప్పుడు అబ్రాహాము ఇలా అన్నాడు, “ప్రభూ నాపై కోపగించకు, ఈ ఒక్కసారే చివరిగా నీతో మాటలాడ తెగిస్తున్నాను. పదిమంది మంచివాళ్లే గనుక అక్కడ నీకు కనబడితే, నీవేం చేస్తావు?” “పదిమంది మంచివాళ్లు గనుక అక్కడ నాకు కనబడితే, ఆ పట్టణాన్ని నేను నాశనం చేయను అన్నాడు” యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","యెహోవా అబ్రాహాముతో మాట్లాడటం అయిపోయింది, గనుక యెహోవా వెళ్లిపోయాడు. అబ్రాహాము తన ఇంటికి వెళ్లిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ఆ సాయంకాలం, ఆ ఇద్దరు దేవదూతలు సొదొమ పట్టణం వచ్చారు. పట్టణ ద్వారం దగ్గర కూర్చొని ఉన్న లోతు ఆ దేవదూతల్ని చూశాడు. లోతు లేచి, దేవదూతల దగ్గరకు వెళ్లి, సాష్టాంగ పడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","లోతు ఇలా అన్నాడు: “అయ్యలారా, దయతో నా ఇంటికి రండి, నేను మీకు సేవ చేస్తాను. అక్కడ మీరు మీ కాళ్లు కడుక్కొని, రాత్రి బస చేయవచ్చును. ఆ తరువాత మీరు మీ ప్రయాణం కొనసాగించవచ్చు.” “లేదు. ఈ రాత్రికి మేము ఈ ఖాళీ స్థలంలో బస చేస్తాం” అన్నారు దేవదూతలు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","కాని, వారిని తన ఇంటికి రమ్మని లోతు బలవంతము చేసెను. అంచేత లోతు ఇంటికి వెళ్లడానికి దేవదూతలు ఒప్పుకొన్నారు. వారు ఇంటికి వెళ్లగానే, వారు తినేందుకు లోతు భోజనం తయారు చేసాడు, వాళ్ల కోసం రొట్టెలు చేసాడు. లోతు వండిన భోజనం దేవదూతలు తిన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ఆ రాత్రి పండుకొనక ముందు, పట్టణం నలుమూలల నుండి పురుషులు చిన్నలూ, పెద్దలూ లోతు ఇంటికి వచ్చారు. సొదొమ ప్రజలు లోతు ఇంటిని చుట్టుముట్టి, లోతును పిల్చారు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","“ఈ రాత్రి నీ ఇంటికి వచ్చిన ఆ ఇద్దరు మనుష్యులు (దేవదూతలు) ఎక్కడ? వాళ్లను బయటకు మా దగ్గరకు తీసుకురా. మేము వాళ్లను సంభోగించాలి” అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","లోతు బయటకు వెళ్లి, తన వెనుకగా తలుపు మూసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“వద్దు, నా సోదరులారా, దయచేసి ఈ చెడ్డపని మీరు చేయవద్దని బతిమాలాడుతున్నాను” అని ఆ మనుష్యులతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","“చూడండి, నాకు ఇద్దరు కుమార్తెలు ఉన్నారు. వారు ఇదివరకు ఎన్నడూ ఏ పురుషునివద్ద పడుకోలేదు. నా కూతుళ్లను మీకు ఇస్తాను. మీ ఇష్టం వచ్చినట్టు వాళ్లను చేసుకోండి. కాని దయచేసి ఈ మనుష్యులను మాత్రం ఏమీ చేయకండి. వీళ్లు నా ఇంటికి వచ్చారు, నేను వాళ్లను కాపాడాలి” లోతు ఆ మనుష్యులతో అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","“దారిలోనుంచి తప్పుకో” అంటూ ఇంటి చుట్టూ ఉన్నవాళ్లంతా అరిచారు. “ఈ లోతు ఒక యాత్రికుడుగా మన పట్టణం వచ్చాడు. ఇప్పుడు మనకే నీతులు చెబుతున్నాడు” అని వాళ్లలో వాళ్లు చెప్పుకొన్నారు. అప్పుడు వాళ్లు లోతుతో, “వాళ్లకు చేసే వాటికంటే ఎక్కువ కీడు నీకు చేస్తాం” అని చెప్పారు కనుక ఆ మనుష్యులు లోతు దగ్గరకు మరింత సమీపంగా వెళ్లి, తలుపు బద్దలు కొట్టడానికి సిద్ధమయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","అయితే లోతు ఇంటిలో వున్న ఆ యిద్దరు మనుష్యులు తలుపు తెరచి లోతును లోపలికి లాగేసారు. తర్వాత వాళ్లు తలుపు మూసేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ద్వారమునకు వెలుపల ఉన్న మనుష్యులు గ్రుడ్డివాళ్లు అయ్యేటట్టు ఆ దేవదూతలు చేసారు. కనుక ఇంటిలోనికి ప్రవేశించాలని ప్రయత్నించిన ఆ మనుష్యులు, పెద్దవాళ్లు, చిన్నవాళ్లు అందరు గుడ్డివాళ్లయిపోయి ద్వారం ఎక్కడుందో కనుక్కోలేక పోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","“మీ కుటుంబాలకు చెందిన వాళ్లు ఇంకెవరైనా ఈ పట్టణంలో ఉన్నారా? అల్లుళ్లు, కుమారులు, కుమార్తెలు, లేక ఇంకెవరైనా మీ కుటుంబంలో ఉన్నారా? మీ కుటుంబానికి చెందిన వాళ్లు ఇంకెవరైనా ఈ పట్టణంలో ఉంటే, వాళ్లను ఇప్పుడే ఈ చోటు విడిచిపెట్టమని చెప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","మేము ఈ పట్టణాన్ని నాశనం చేస్తున్నాం. ఈ పట్టణంలో ఉన్న దుష్టత్వాన్ని గూర్చి యెహోవా అంతా చూశాడు. కనుక ఈ పట్టణాన్ని నాశనం చేయటానికి యెహోవా మమ్ముల్ని పంపించాడు” అని ఆ ఇద్దరు మనుష్యులు లోతుకు చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","కనుక లోతు బయటకు వెళ్లి, తన కుమార్తెలను పెళ్లాడనైయున్న తన అల్లుళ్లతో మాట్లాడాడు. “త్వరగా ఈ పట్టణం వదిలిపెట్టిండి. యెహోవా దీన్ని త్వరగా నాశనం చేస్తాడు” అన్నాడు లోతు. అయితే లోతు పరిహాసం చేస్తున్నాడనుకొన్నారు వాళ్లు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","మర్నాడు సూర్యోదయాన దేవదూతలు లోతును తొందరపెట్టి ఈలాగన్నారు. “చూడు, ఈ పట్టణం శిక్షించబడుతుంది. కనుక ఇంక నీతో ఉన్న నీ భార్యను, నీ యిద్దరు కుమార్తెలను తోడుకొని ఈ స్థలం విడిచిపెట్టు. అప్పుడు ఈ పట్టణంతోబాటు నీవు నాశనంగాకుండా ఉంటావు.” ");
INSERT INTO tel2010_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","కాని, లోతు కలవరపడి, వెళ్లిపోయేందుకు త్వరపడలేదు. కనుక ఆ ఇద్దరు మనుష్యులు, (దేవదూతలు) లోతు, అతని భార్య, అతని యిద్దరు కుమార్తెల చేతులు పట్టుకొన్నారు. లోతును అతని కుటుంబాన్ని ఆ ఇద్దరు మనుష్యులు ఆ పట్టణంలోనుంచి క్షేమంగా బయటకు నడిపించారు. లోతు, అతని కుటుంబం యెడల యెహోవా దయ చూపెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","అందుచేత లోతును అతని కుటుంబాన్ని ఆ ఇద్దరు మనుష్యులు ఆ పట్టణంలోనుండి బయటకు తీసుకొని వచ్చారు. వారు బయటకు వచ్చాక, ఆ మనుష్యులలో ఒకరు ఇలా అన్నారు: “ఇప్పుడు మీ ప్రాణం కాపాడుకోవటానికి పారిపొండి. మళ్లీ వెనక్కు తిరిగి పట్టణం వైపు చూడకండి. లోయలో ఎక్కడా ఆగకండి. పర్వతాలు చేరేంత వరకు పరుగెత్తండి. అలా చేయకపోతే, పట్టణంతో పాటు మీరూ నాశనం అయిపోతారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","అయితే ఆ ఇద్దరు మనుష్యులతో లోతు ఇలా చెప్పాడు: “అయ్యలారా, అంత దూరం పరుగెత్తమని నన్ను బలవంతం చేయవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","మీ సేవకుడైన నా మీద మీరు చాలా దయ చూపించారు. నన్ను రక్షించటం మీరు చూపించిన మహా గొప్ప దయ. కానీ, నేను పర్వతాల వరకు పరుగెత్తలేను. నేను మరీ నిదానమైతే, ఆ నగరానికి సంభవించవలసిన శిక్ష నాకు తగిలి నేను మరణిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","అయితే చూడండి, ఇక్కడికి సమీపంలో ఒక చిన్న ఊరుంది. నన్ను ఆ ఊరికి పారిపోనివ్వండి, అక్కడ నా ప్రాణం రక్షించబడుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","దేవదూత లోతుతో, “సరే మంచిది, అలాగే కానివ్వు. నీవు వెళ్తున్న ఆ ఊరిని నేను నాశనం చేయను. ");
INSERT INTO tel2010_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","అయితే అక్కడికి వేగంగా పరుగెత్తు. నీవు క్షేమంగా ఆ ఊరు చేరేంతవరకు, సొదొమను నేను నాశనం చేయను” అనెను. (ఆ ఊరు చిన్నది గనుక అది సోయరు అని పిలువబడింది.) ");
INSERT INTO tel2010_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","సూర్యోదయం అయ్యేటప్పటికి లోతు సోయరులో ప్రవేశిస్తున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","సొదొమ గొమొర్రాలను యెహోవా నాశనం చేయటం మొదలు బెట్టాడు. ఆకాశం నుండి అగ్ని గంధక వర్షాన్ని యెహోవా పంపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","కనుక ఆ పట్టణాలను యెహోవా నాశనం చేసాడు, మరియు ఆ లోయను, ఆ నగరాల్లో నివసిస్తోన్న ప్రజలందరిని, చెట్లన్నింటిని ఆయన నాశనం చేశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","వారు పారిపోతూ ఉండగా లోతు భార్య వెనుకకు తిరిగి పట్టణం వైపు చూసింది. ఆమె వెనుకకు తిరిగిచూడగానే ఉప్పుస్తంభం అయిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","ఆ ఉదయమే పెందలకడ అబ్రాహాము లేచి నిన్న యెహోవా ఎదుట నిలిచిన స్థలానికి వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","అబ్రాహాము సొదొమ గొమొర్రాలవైపు కిందుగా చూశాడు. ఆ లోయ ప్రదేశమంతా అబ్రాహాము చూశాడు. ఆ చోటనుండి విస్తారమైన పొగలు రావటం చూశాడు. అది ఒక మహాగొప్ప మంటనుండి లేచిన పొగలా కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ఆ లోయలోని పట్టణాలను దేవుడు నాశనం చేసాడు. అయితే దేవుడు ఇది చేసినప్పుడు, అబ్రాహాము అడిగిన దానిని ఆయన జ్ఞాపకం చేసుకొన్నాడు. లోతు ప్రాణాన్ని దేవుడు రక్షించాడు, కాని లోతు నివసించిన పట్టణాన్ని యెహోవా నాశనం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","సోయరులో జీవితం గడిపేందుకు లోతు భయపడ్డాడు. కనుక అతడు, అతని ఇద్దరు కుమార్తెలు వెళ్లి పర్వతాల్లో నివాసం చేశారు. అక్కడ ఒక గుహలో వారు నివసించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ఒక రోజున పెద్ద కుమార్తె చిన్న కుమార్తెతో ఇలా చెప్పింది: “భూమిమీద అంతటా స్త్రీలు పురుషులు పెళ్లి చేసుకొని కుటుంబం కలిగి ఉంటారు. కానీ మనం పెళ్లి చేసుకొని పిల్లలు కలిగేందుకు ఇక్కడ ఎవ్వరూ మగవాళ్లు లేరు. మన తండ్రి ముసలివాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","కానీ మన కుటుంబం సాగాలి గనుక మనకు పిల్లలు పుట్టడం కోసం మనం మన తండ్రిని ఉపయోగించుకోవాలి. మనం మన తండ్రి దగ్గరకు వెళ్లి, ఆయనతో పాటు మధుపానం చేసి, ఆయనకు మత్తు కలిగిద్దాం. అప్పుడు మనం ఆయనతో పండుకోవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","ఆ రాత్రి ఇద్దరు అమ్మాయిలో తమ తండ్రి దగ్గరకు వెళ్లి, అతనికి ద్రాక్షారసాన్ని తాగించి మత్తుగా చేశారు. అప్పుడు పెద్దమ్మాయు తన తండ్రి పడక మీదకు వెళ్లి, అతనితో లైంగికంగా కలసికొన్నది. లోతు తాగిన మత్తులో ఉన్నాడు గనుక, ఆమె ఎప్పుడు తనతో పండుకొన్నది, లేచి వెళ్లినది, అతనికి తెలియలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","మర్నాడు పెద్దమ్మాయి చిన్నమ్మాయితో చెప్పింది: “గత రాత్రి నా తండ్రితో నేను పండుకొన్నాను. ఈ రాత్రి మళ్లీ మనం ఆయనకు ద్రాక్షారసముతో మత్తు కలిగిద్దాం. అప్పుడు నీవు ఆయన పడక మీదకి వెళ్లి ఆయనతో లైంగికంగా కలసికొనవచ్చు. ఈ విధంగా మన కుటుంబం అంతం కాకుండా పిల్లలు పుట్టేందుకు మనం మన తండ్రిని ఉపయోగించుకోవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","కనుక ఆ రాత్రి తమ తండ్రికి మత్తు ఎక్కేంతవరకు ఆ ఇద్దరు అమ్మాయిలూ తమ తండ్రికి ద్రాక్షారసాన్ని తాగించారు. అప్పుడు చిన్నమ్మాయి అతని పడక మీదకి వెళ్లి అతనితో పడుకొంది. అతని కుమార్తె అతనితో పండుకొన్నట్టు లోతుకు మరల తెలియలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","అందుచేత లోతు కుమార్తెలు ఇద్దరూ గర్భవతులయ్యారు. వారి తండ్రి వారి శిశువులకు తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","పెద్ద కుమార్తెకు ఒక కొడుకు పుట్టాడు. ఆమె ఆ కుమారునికు మోయాబు అని పేరు పెట్టింది. నేటికి జీవిస్తోన్న మోయాబు ప్రజలందరికి అతడు తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","చిన్న కుమార్తెకు కూడ ఒక కొడుకు పుట్టాడు. ఆమె తన కుమారునికి బెన్నమ్మి అని పేరు పెట్టింది. నేటికి జీవిస్తోన్న అమ్మనీ ప్రజలందిరికి బెన్నమ్మి తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","అబ్రాహాము ఆ చోటు విడిచి నెగెబుకు ప్రయాణం కట్టాడు. కాదేషుకు, షూరుకు మధ్యనున్న గెరారుకు అబ్రాహాము వెళ్లాడు. గెరారులో ఉన్నప్పుడు ");
INSERT INTO tel2010_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","శారా తన సోదరి అని అబ్రాహాము ప్రజలతో చెప్పాడు. గెరారు రాజు అబీమెలెకు ఇది విన్నాడు. అబీమెలెకు శారాను ఇష్టపడి, ఆమెను తీసుకుని వచ్చేందుకు కొందరు సేవకుల్ని పంపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","అయితే ఆ రాత్రి దర్శనంలో అబీమెలెకుతో దేవుడు మాట్లాడి, “చూడు, నీవు చస్తావు. నీవు తెచ్చుకొన్న ఆ స్త్రీ వివాహితురాలు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","కానీ అప్పటికి అబీమెలెకు శారాతో శయనించ లేదు. కనుక అబీమెలెకు, “ప్రభూ, నేను దోషిని కాను. నిర్దోషిని నీవు చంపుతావా? ");
INSERT INTO tel2010_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","‘ఈ స్త్రీ నా సోదరి’ అని అబ్రాహాము స్వయంగా నాతో చెప్పాడు. ఆ స్త్రీ కూడా ‘ఈ పురుషుడు నా సోదరుడు’ అని చెప్పింది. నేను నిర్దోషిని. నేను చేస్తున్నది ఏమిటో నాకు తెలియలేదు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ఆ దర్శనంలో అబీమెలెకుతో దేవుడు ఇలా చెప్పాడు: “అవును, నాకు తెలుసు, నీవు నిర్దోషివి. నీవు చేస్తున్నది ఏమిటో నీకు తెలియదు అని నాకు తెలుసు. నేను నిన్ను కాపాడాను. నాకు వ్యతిరేకంగా నిన్ను నేను పాపం చేయనీయలేదు. నీవు ఆమెతో శయనించకుండా చేసింది నేనే. ");
INSERT INTO tel2010_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","కనుక అబ్రాహాము భార్యను తిరిగి అతనికి అప్పగించు. అబ్రాహాము ఒక ప్రవక్త. అతడు నీ కోసం ప్రార్థిస్తాడు, అప్పుడు నీవు బతుకుతావు. కానీ శారాను నీవు తిరిగి అబ్రాహాముకు ఇవ్వకపోతే, నీవు మరణించడం తప్పదు. నీతోబాటు నీ కుటుంబం అంతా మరణిస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","కనుక మర్నాడు వేకువనే, అబీమెలెకు తన సేవకులందరినీ పిల్చాడు. దర్శనంలో సంభవించిన సంగతులన్నీ అబీమెలెకు వారితో చెప్పాడు. సేవకులు చాలా భయపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","అప్పుడు అబీమెలెకు అబ్రాహామును పిలిచి, అతనితో అన్నాడు: “నీవు మాకు ఎందుకు ఇలా చేసావు? నీకు నేను ఏమి అపకారం చేసాను? ఎందుకలా అబద్ధం చెప్పి, ఆమె నీ సోదరి అన్నావు? నా రాజ్యానికి నీవు చాలా చిక్కు తెచ్చిపెట్టావు. నాకు నీవు ఇలా చేయకుండా ఉండాల్సింది. ");
INSERT INTO tel2010_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","నీవు దేనికి ఇలా చేసావు?” ");
INSERT INTO tel2010_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","అందుకు అబ్రాహాము చెప్పాడు: “నేను భయపడ్డాను. దేవుడంటే ఇక్కడ ఎవరికీ భయము లేదని అనుకొన్నాను. శారాను పొందటం కోసం ఎవరైనా నన్ను చంపేస్తారు అనుకొన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ఆమె నా భార్య, అయితే నా సోదరి కూడాను. ఆమె నా తండ్రి కుమార్తె గాని, నా తల్లి కుమార్తె కాదు. ");
INSERT INTO tel2010_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","నా తండ్రి ఇంటినుండి దేవుడు నన్ను బయటకు నడిపించాడు. అనేక చోట్ల సంచారం చేసేటట్టు దేవుడు నన్ను నడిపించాడు. అలా జరిగినప్పుడు, ‘నీవు నా సోదరివని ప్రజలతో మనం వెళ్లిన చోటల్లా చెప్పు, నాకు ఈ మేలు చేయి’ అని నేను శారాతో చెప్పాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","అప్పుడు జరిగిందేమిటో అబీమెలెకు అర్థం చేసుకొన్నాడు. కనుక శారాను అబీమెలెకు తిరిగి అబ్రాహాముకు అప్పగించేసాడు. కొన్ని గొర్రెలు, పశువులు, కొందరు ఆడ, మగ బానిసలను కూడ అబీమెలెకు అబ్రాహాముకు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","మరియు “నీ చుట్టూ చూడు. ఇది నా దేశం. నీకు ఇష్టం వచ్చిన చోట నీవు ఉండవచ్చు” అన్నాడు అబీమెలెకు. ");
INSERT INTO tel2010_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","“చూడు, నీ సోదరుడైన అబ్రాహాముకు 1,000 వెండి నాణెములు ఇచ్చాను. జరిగిన వాటి విషయమై నా పశ్చాత్తాపం వ్యక్తం చేయడానికి యిది చేసాను. నేను సక్రమంగా జరిగించినట్టు అందరూ చూడాలని నేను కోరుతున్నాను” అని అబీమెలెకు శారాతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","అబీమెలెకు కుటుంబంలోని స్త్రీలను గొడ్రాళ్లుగా చేసాడు యెహోవా. అబ్రాహాము భార్య శారాను అబీమెలెకు తీసుకొన్నందుచేత దేవుడు ఇలా చేసాడు. అయితే అబ్రాహాము ప్రార్థించగా అబీమెలెకును, అతని భార్యను మరియు అతని దాసీలను దేవుడు స్వస్థపరచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","యెహోవా శారాకు అనుగ్రహిస్తానని ఆమెకు వాగ్దానం చేసాడు. ఆయన వాగ్దానం చేసినట్టే ఆమెపై అనుగ్రహాన్ని చూపాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","అబ్రాహాము వృద్దాప్యంలో శారా గర్భవతి అయ్యింది, అతనికి ఒక కుమారుని కన్నది. ఈ సంగతులన్నీ సరిగ్గా దేవుడు వాగ్దానం చేసినట్టే జరిగాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","శారా కుమారుని కన్నది, అబ్రాహాము వానికి ఇస్సాకు అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","దేవుడు ఆజ్ఞాపించినట్టు, ఇస్సాకుకు ఎనిమిది రోజులు నిండగానే అబ్రాహాము అతనికి సున్నతి చేశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","తన కుమారుడు ఇస్సాకు పుట్టినప్పుడు అబ్రాహాము నయస్సు 100 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","“దేవుడు నన్ను సంతోషపెట్టాడు. ఇది విన్న ప్రతి ఒక్కరూ నాతో సంతోషిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","నేను శారాను, అబ్రాహాము కుమారుణ్ణి పొందుతాడని ఏ ఒక్కరూ తలంచలేదు. కానీ ఆయన వృద్ధుడుగా ఉన్నప్పుడు అబ్రాహాముకు నేను ఒక కుమారుని కన్నాను” అంది శారా. ");
INSERT INTO tel2010_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ఇస్సాకు ఎదుగుతున్నాడు. త్వరలోనే గట్టి పదార్థాలు భోజనం చేసేటంతటి పెద్దవాడయ్యాడు. అప్పట్లో అబ్రాహాము ఒక మహా గొప్ప విందు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","గతంలో ఈజిప్టు బానిసైన స్త్రీ హాగరు ఒక కుమారుని కన్నది. ఆ కుమారునికి కూడా తండ్రి అబ్రాహామే. అయితే ఆ కుమారుడు ఇప్పుడు ఇస్సాకును వేధించడం శారా చూసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","“కనుక ఆ బానిస స్త్రీని, ఆమె కుమారుణ్ణి బలవంతంగా వెళ్లగొట్టు. మన మరణం తరువాత మన కుమారుడు ఇస్సాకు మన ఆస్తి అంతటికి వారసుడవుతాడు. దానిలో దాసీ కుమారుడు ఇస్సాకుతో భాగం పంచుకోవటం నాకు ఇష్టం లేదు అంటూ” శారా అబ్రాహాముతో చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ఇదంతా అబ్రాహాముకు బాధ కలిగించింది. తన కుమారుడైన ఇష్మాయేలును గూర్చి అతడు చింతించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","కానీ అబ్రాహాముతో దేవుడన్నాడు: “ఆ పిల్లవాణ్ణి గూర్చి నీవు చింతించకు. ఆ బానిస స్త్రీని గూర్చి నీవు చింతపడకు. శారా కోరినట్టే చేయి. ఇస్సాకు మాత్రమే నీకు వారసుడయిన కుమారుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","అయితే నీ బానిస స్త్రీ కుమారుణ్ణి కూడా నేను ఆశీర్వదిస్తాను. అతడు నీ కుమారుడే, కనుక అతని వంశం నుండి గూడ నేను ఒక గొప్ప జనాన్ని చేస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","మర్నాడు వేకువనే అబ్రాహాము కొంత భోజనాన్ని, తిత్తిలో నీళ్లు తెచ్చాడు. అబ్రాహాము వీటిని హాగరుకు ఇచ్చాడు. హాగరు వీటిని తీసుకొని, తన కుమారునితో కలసి వెళ్లిపోయింది. హాగరు ఆ చోటు విడిచి బెయేర్షెబా అరణ్యంలో సంచరించింది. ");
INSERT INTO tel2010_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","కొన్నాళ్లకు తిత్తిలోని నీళ్లన్నీ అయిపోయాయి. తాగటానికి ఏమీ మిగలలేదు. కనుక హాగరు తన కుమారుణ్ణి ఒక పొద పక్కన పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","హాగరు కొంచె దూరం నడచి వెళ్లింది. అక్కడ ఆగిపోయి కూర్చుంది. నీళ్లు లేవు గనుక తన కుమారుడు చనిపోతాడనుకొంది హాగరు. వాడు చస్తోంటే చూడటం ఆమెకు ఇష్టం లేదు. ఆమె అక్కడ కూర్చొని ఏడ్వటం మొదలు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ఆ పిల్లవాడు ఏడ్వడం దేవుడు విన్నాడు. పరలోకంనుండి దేవుని దూత హాగరును పిలిచాడు. అతడన్నాడు, “హాగరూ, ఏం జరిగింది? భయపడకు. అక్కడ పిల్లవాడు ఏడ్వడం యెహోవా విన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","వెళ్లి పిల్లవాడికి సహాయం చేయి. వాడి చేయి పట్టి నడిపించు. ఒక గొప్ప జనాంగానికి అతణ్ణి తండ్రిగా నేను చేస్తాను” ");
INSERT INTO tel2010_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","అంతలో హాగరుకు ఒక బావి కనబడేటట్టు చేసాడు దేవుడు. కనుక హాగరు ఆ బావి దగ్గరకు వెళ్లి తన తిత్తిని నీళ్లతో నింపుకొన్నది. తర్వాత పిల్లవాడు తాగటానికి ఆమె నీళ్లు ఇచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ఆ పిల్లవాడు ఎదుగుతూ ఉండగా దేవుడు వానికి తోడుగానే ఉన్నాడు. ఇష్మాయేలు అరణ్యంలో జీవిస్తూ, వేయగాడయ్యాడు. బాణం కొట్టడంలో నిపుణత నేర్చుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","అతని తల్లి అతని కోసం ఈజిప్టులో భార్యను కనుగొన్నది. వారు పారాను అరణ్యంలోనే జీవిస్తూ ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","అంతట ఆబీమెలెకు, ఫీకోలు అబ్రాహాముతో మాట్లాడారు. అబీమెలెకు, అతని సైన్యాధిపతి ఫికోలు అబ్రాహాముతో ఇలా చెప్పారు: “నీవు చేసే ప్రతి దానిలోను దేవుడు నీతో ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","కనుక ఇక్కడ దేవుని యెదుట నాకు ఒక వాగ్దానం చేయాలి. నాతో, నా పిల్లలతో నీవు న్యాయంగా వ్యవహరిస్తావని వాగ్దానం చేయాలి. నీవు నివసించిన ఈ దేశం మీద, నా మీద నీవు దయగలిగి ఉంటానని వాగ్దానం చేయాలి. నీపైన నేను ఎంత దయ చూపెట్టానో, నాపైన నీవు కూడా అంత దయ చూపెడ్తానని వాగ్దానం చేయాలి.” ");
INSERT INTO tel2010_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","“నన్ను నీవు ఎలా పరామర్శించావో నేను కాడు నిన్ను అలాగే పరామర్శిస్తానని నేను వాగ్దానం చేస్తున్నాను” అన్నాడు అబ్రాహాము. ");
INSERT INTO tel2010_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","అప్పుడు అబ్రాహాము అబీమెలెకుతో ఒక ఫిర్యాదు చేసాడు. అబీమెలెకు సేవకులు ఒక మంచి నీటి బావిని స్వాధీనం చేసుకొన్నందుచేత అబ్రాహాము అబీమెలెకుతో ఫిర్యాదు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","కానీ అబీమెలెకు, “ఇది ఎవరు చేసారో నాకు తెలియదు. ఇంతకు ముందు ఈ విషయం నీవు నాతో చెప్పలేదు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","కనుక అబ్రాహాము, అబీమెలెకు ఒక ఒడంబడిక చేసుకొన్నారు. ఆ ఒడంబడిక సూచనగా కొన్ని గొర్రెలను, పశువులను అబీమెలెకుకు అబ్రాహాము ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","ఏడు ఆడ గొర్రె పిల్లల్ని కూడా అబీమెలెకు ఎదుట ఉంచాడు అబ్రాహాము. ");
INSERT INTO tel2010_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","“ఈ ఏడు ఆడ గొర్రెపిల్లల్ని ఇలా ప్రత్యేకంగా ఎందుకు పెట్టావు?” అని అబీమెలెకు అబ్రాహామును అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","“ఈ గొర్రెపిల్లల్ని నా దగ్గర నుండి నీవు స్వీకరించినప్పుడు, ఈ బావిని నేను తవ్వించినట్టు రుజువు అవుతుంది” అని అబ్రాహాము జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","కనుక ఆ తర్వాత ఆ బావి బెయేర్షెబా అని పిలువబడింది. వారిద్దరు ఒకరికి ఒకరు ఆ స్థలంలో వాగ్దానం చేసుకొన్న చోటు గనుక దానికి వారు ఆ పేరు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","కనుక అబ్రాహాము, అబీమెలెకు బెయేర్షెబా దగ్గర ఒక ఒడంబడిక చేసుకొన్నారు. అప్పుడు అబెమెలెకు, అతని సైన్యాధిపతి తిరిగి ఫిలిష్తీ ప్రజల దేశం వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","బెయేర్షెబాలో అబ్రాహాము ఒక అలంకారపు చెట్టు నాటాడు. అప్పుడు అబ్రాహాము ప్రభువు, ఎల్లప్పుడు జీవిస్తున్న దేవుడైన యెహోవాకు అతడు అక్కడ ప్రార్థన చేశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","ఫిలిష్తీయుల దేశంలో అబ్రాహాము చాలాకాలం నివసించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ఆ సంగతులు జరిగిన తర్వాత అబ్రాహాము యొక్క విశ్వాసాన్ని పరీక్షించాలని దేవుడు అనుకొన్నాడు. “అబ్రాహామూ” అని దేవుడు అతణ్ణి పిలిచాడు. దానికి అబ్రాహాము “చిత్తం” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","అప్పుడు దేవుడు చెప్పాడు, “నీ కుమారుని మోరీయా దేశం తీసుకొని వెళ్లు. మోరీయాలో నీ కుమారుణ్ణి నాకు బలిగా చంపు. నీ ఒకే కుమారుడు, నీవు ప్రేమిస్తున్న నీ కుమారుడైన ఇస్సాకును ఇలా చేయాలి. అక్కడ కొండల్లో ఒక దానిమీద అతణ్ణి దహనబలిగా ఉపయోగించు. ఏ కొండ అనేదీ నేను నీతో చెబుతాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","ఉదయాన అబ్రాహాము లేచి తన గాడిదను సిద్ధం చేసాడు. ఇస్సాకును తన ఇద్దరు సేవకులను అబ్రాహాము తన వెంట తీసుకు వెళ్లాడు. బలి అర్పణ కోసం కట్టెలను అబ్రాహాము నరికాడు. తర్వాత వారు వెళ్లాలని దేవుడు అతనితో చెప్పిన చోటుకి వారు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","వారు మూడు రోజులు ప్రయాణం చేసిన తర్వాత, అబ్రాహాము కనులెత్తి దూరంలో వారు వెళ్లవలసిన చోటును చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","అప్పుడు అబ్రాహాము, “మీరు ఈ గాడిదతో ఇక్కడ ఉండండి. నేను నా కుమారుణ్ణి తీసుకొని, అక్కడికి వెళ్లి ఆరాధన చేస్తాం. ఆ తర్వాత మేము మీ దగ్గరకు తిరిగి వస్తాం” అని తన సేవకులతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","అబ్రాహాము బలికోసం కట్టెలు తీసుకొని తన కుమారుని భుజంమీద పెట్టాడు. ఒక ప్రత్యేక ఖడ్గం, నిప్పు అబ్రాహాము పట్టుకొన్నాడు. అప్పుడు అబ్రాహాము, అతని కుమారుడు యిద్దరు కలిసి ఆరాధనా స్థలానికి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ఇస్సాకు “తండ్రీ!” అని తన తండ్రి అబ్రాహామును పిలిచాడు. “ఏమిటి కొడుకా?” అని అడిగాడు అబ్రాహాము. “కట్టెలు, నిప్పు నాకు కనబడుతున్నాయి. కాని మనం బలిగా దహించే గొర్రెపిల్ల ఏది?” అని ఇస్సాకు అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","“నా కుమారుడా, బలికోసం గొర్రెపిల్లను సరైన సమయంలో దేవుడు మనకు ఇస్తాడు” అని అబ్రాహాము జవాబిచ్చాడు. కనుక అబ్రాహాము, అతని కుమారుడు ఇద్దరూ కలిసి ఆ చోటుకి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","దేవుడు వారికి వెళ్లమని చెప్పిన చోటుకి వారు వెళ్లారు. అక్కడ అబ్రహాము ఒక బలిపీఠం కట్టాడు. కట్టెలను ఆ బలిపీఠం మీద పెట్టాడు. తర్వాత తన కుమారుడు ఇస్సాకును అబ్రాహాము కట్టివేసాడు. బలిపీఠం మీద కట్టెలపై ఇస్సాకును పరుండబెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","అప్పుడు అబ్రాహాము తన ఖడ్గం తీసుకొని తన కుమారుని చంపడానికి సిద్ధమయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","కాని అప్పుడు యెహోవా దూత అబ్రాహామును ఆపు చేసాడు. దేవుదూత ఆకాశం నుండి “అబ్రాహామా, అబ్రాహామా” అని పిలిచాడు. “చిత్తం” అని అబ్రాహాము జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","“నీ కుమారుని చంపవద్దు, అతనికి ఏ హానీ చేయవద్దు. నీకు దేవుని పట్ల భయం, ఆరాధనా భావం ఉన్నాయని నాకిప్పుడు తెలుసు. నా కోసం, నీ కుమారుణ్ణి అదీ నీ ఒకే ఒక్క కుమారుణ్ణి చంపడానికి గూడా నీవు సిద్ధమేనని నేను చూశాను” అన్నాడు దేవదూత. ");
INSERT INTO tel2010_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","అబ్రాహాము అటు ప్రక్క చూడగా ఒక పొట్టేలు కనబడింది. ఆ పొట్టేలు కొమ్ములు ఒక పొదలో చిక్కుకొన్నాయు. కనుక అబ్రాహాము వెళ్లి, పొట్టేలును పట్టుకొని దానిని చంపాడు. ఆ పొట్టేలును దేవునికి బలిగా అబ్రాహాము ఉపయోగించాడు. అబ్రాహాము కుమారుడు రక్షించబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","అందుచేత ఆ స్థలానికి “యెహోవా ఈరె” అని అబ్రాహాము పేరు పెట్టాడు. “ఈ పర్వతం మీద యెహోవా చూసుకుంటాడు” అని ఇప్పటికి ప్రజలు చెబుతారు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ఆకాశంనుండి యెహోవా దూత అబ్రాహామును రెండవసారి పిల్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","యెహోవా దూత చెప్పాడు: “నా కోసం నీ కుమారుణ్ణి చంపడానికి నీవు సిద్ధపడ్డావు. అతడు నీకు ఒక్కడే కుమారుడు. నా కోసం నీవు ఇలా చేశావు గనుక నీకు ఈ వాగ్దానం చేస్తున్నాను. యెహోవానైన నేను వాగ్దానం చేసేది ఏమిటంటే ");
INSERT INTO tel2010_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","నిజంగా నిన్ను నేను ఆశీర్వదిస్తాను. ఆకాశంలో అసంఖ్యాక నక్షత్రాలులాగా సముద్ర తీరంలో ఇసుకలాగా నీ సంతానమును చేస్తాను. నీ ప్రజలు వారి శత్రువులనందరినీ ఓడిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","నీ సంతానం ద్వారా భూమిమీద ప్రతిజనం ఆశీర్వదించబడతారు. నీవు నాకు విధేయుడవయ్యావు కనుక నేను దీన్ని చేస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","అప్పుడు అబ్రాహాము మళ్లీ తన సేవకుల దగ్గరకు వెళ్లిపోయాడు. వాళ్లంతా బెయేర్షెబాకు ప్రయాణమై వెళ్లిపోయారు, అబ్రాహాము అక్కడ నివసించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ఈ సంగతులన్నీ జరిగాక, అబ్రాహాముకు ఒక సందేశం పంపబడింది. ఆ సందేశం ఇది, “నీ సోదరుడు నాహోరు, అతని భార్య మిల్కాకు ఇప్పుడు పిల్లలు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","మొదటి కుమారుడు ఊజు. రెండవ కుమారుడు బూజు, మూడవ కుమారుడు కెమూయేలు, అతడు అరాము తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ఆ తర్వాత కెసెదు, హజో, పిల్దాషు, యిద్లాపు, బెతూయోలు అనువారు ఉన్నారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","బెతూయేలు రిబ్కాయొక్క తండ్రి. ఈ ఎనిమిది మంది కుమారులకు తల్లి మిల్కా, తండ్రి నాహోరు. నాహోరు అబ్రాహాము సోదరుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","మరియు నాహోరు దాసియైన రయూమా ద్వారా అతనికి ఇంకా నలుగురు కుమారులు తెబహు, గహము, తహషు, మయకా కలిగారు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","శారా 127 సంవత్సరాలు జీవించింది. ");
INSERT INTO tel2010_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","కనాను దేశంలోని కిర్యతర్బా పట్టణంలో (అనగా హెబ్రోను) అమె మరణించింది. అబ్రాహాము చాలా దుఃఖించి, ఆమె కోసం అక్కడ ఏడ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","అప్పుడు మరణించిన తన భార్యను విడచిపెట్టి, హిత్తీ ప్రజలతో మాట్లాడేందుకు అబ్రాహాము వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“నేను ఈ దేశవాసిని కాను. ఇక్కడ నేను యాత్రికుడను మాత్రమే. అందుచేత నా భార్యను పాతిపెట్టుటకు నాకు స్థలము లేదు. నేను నా భార్యను పాతిపెట్టడానికి దయచేసి నాకు కొంత స్థలం ఇవ్వండి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","హిత్తీ ప్రజలు అబ్రాహాముకు ఇలా జవాబు చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“అయ్యా, మా మధ్య మీరు దేవుని మహా నాయకులలో ఒకరు. చనిపోయిన మీ వాళ్లను పాతిపెట్టేందుకు మా శ్రేష్ఠమైన స్థలాన్ని మీరు తీసుకోవచ్చు. చనిపోయిన వాళ్లను పాతిపెట్టే మా స్థలాల్లో మీకు ఏది కావాలంటే అది తీసుకోవచ్చు. అక్కడ మీ భార్యను పాతిపెట్టడానికి మేము ఎవ్వరం అడ్డు చెప్పం.” ");
INSERT INTO tel2010_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","అబ్రాహాము లేచి ప్రజలకు నమస్కరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","అబ్రాహాము వాళ్లతో చెప్పాడు: “నేను నా భార్యను పాతిపెట్టడానికి మీరు నిజంగా నాకు సహాయం చేయగోరితే, సోహరు కుమారుడు ఎఫ్రోనుతో నా పక్షంగా మీరు మాట్లాడండి. ");
INSERT INTO tel2010_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","మక్పేలా గుహను నేను కొనాలని కోరుతున్నాను. ఇది ఎఫ్రోను స్వంతం. అది అతని పొలం చివరిలో ఉంది. దాని విలువ ఎంతో అంత మొత్తం నేను చెల్లిస్తాను. పాతిపెట్టే స్థలంగా దీనిని నేను కొంటున్నట్టు మీరంతా సాక్షులుగా ఉండాలని నేను కోరుతున్నాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ఎఫ్రోను ఆ జనం మధ్యలో కూర్చొని ఉన్నాడు. ఎఫ్రోను అబ్రాహాముకు ఇలా జవాబిచ్చాడు: ");
INSERT INTO tel2010_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“లేదయ్యా, నేను ఆ స్థలం ఇక్కడ మా అందరి ప్రజల సమక్షంలో నీకిచ్చేస్తాను. ఆ గుహను నేను నీకిస్తాను. నీవు నీ భార్యను పాతిపెట్టుకొనేందుకు ఆ స్థలం నేను నీకు ఇచ్చివేస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","అప్పుడు అబ్రాహాము హిత్తీయుల ముందు వంగి నమస్కారం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","అబ్రాహాము, “ఆ పొలానికి పూర్తి ధర నేను చెల్లిస్తాను. నా డబ్బు స్వీకరించి, నా మృతులను నేను పాతిపెట్టుకొంటాను” అని ప్రజలందరి ముందు ఎఫ్రోనుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","అబ్రాహాముకు ఎఫ్రోను జవాబు చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“అయ్యా నా మాట వినండి. 400 తులాల వెండి మీకు గాని నాకు గాని ఏపాటి? భూమిని తీసుకొని, చనిపోయిన నీ భార్యను పాతిపెట్టుకో.” ");
INSERT INTO tel2010_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","తనతో ఆ పొలం వెల ఎఫ్రోను చెబుతున్నాడని గ్రహించి ఆ వెల 400 తులాల వెండి తూచి అబ్రాహాము అతనికి ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","కనుక ఎఫ్రోను పొలానికి స్వంతదారులు మారిపోయారు. ఈ పొలం మమ్రేకు తూర్పున మక్పేలాలో ఉంది. ఆ పొలానికి, పొలంలో ఉన్న గుహకు, అందులోని చెట్లన్నిటికీ, అబ్రాహాము స్వంతదారుడయ్యాడు. ఎఫ్రోను అబ్రాహాముల మధ్య కుదిరిన ఒప్పందాన్ని ఆ పట్టణ ప్రజలంతా చూశారు. ");
INSERT INTO tel2010_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ఇది జరిగిన తర్వాత మమ్రే దగ్గర ఉన్న మక్పేలా గుహలో అబ్రాహాము తన భార్యను పాతి పెట్టాడు (అది కనానులోని హెబ్రోను) ");
INSERT INTO tel2010_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","ఆ పొలాన్ని, దానిలోని గుహను హిత్తీ ప్రజల దగ్గర అబ్రాహాము కొన్నాడు. ఇది అతని ఆస్తి అయ్యింది, దాన్ని అతడు పాతిపెట్టే స్థలంగా ఉపయోగించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","అబ్రాహాము కురువృద్ధుడయ్యేంత వరకు జీవించాడు. అబ్రాహామును, అతడు చేసిన దాన్నంతటిని దేవుడు ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","అబ్రాహాము యొక్క పాత సేవకుడు ఆస్తి వ్యవహారాలన్నింటి మీద నిర్వాహకునిగా ఉన్నాడు. ఆ సేవకుణ్ణి అబ్రాహాము తన దగ్గరకు పిలిచి ఇలా చెప్పాడు: “నీ చేయి నా తొడకింద పెట్టు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ఇప్పుడు నీవు నాకు ఒక వాగ్దానం చేయాలి. కనాను స్త్రీలలో ఎవరినీ నా కుమారుని పెళ్లి చేసుకోనివ్వవని భూమ్యాకాశాలకు దేవుడుగు యెహోవా ఎదుట నాకు వాగ్దానం చేయి. మనం ఆ ప్రజల మధ్య నివసిస్తున్నాం గాని అతణ్ణి మాత్రం కనాను స్త్రీని వివాహం చేసుకోనివ్వవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","నా దేశంలోని నా స్వంత ప్రజల దగ్గరకు వెళ్లు. అక్కడ నా కుమారుని కోసం భార్యను చూడు. అప్పుడు ఆమెను ఇక్కడికి (అతని దగ్గరకు) తీసుకురా.” ");
INSERT INTO tel2010_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ఆ సేవకుడు, “ఒకవేళ ఆ స్త్రీ నాతో కలిసి ఈ దేశం రావడానికి ఇష్టపడకపోతే, నీ కుమారుడ్ని నేను నీ స్వంత దేశానికి తీసుకొని వెళ్లవచ్చునా?” అని అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","అబ్రాహాము అతనితో చెప్పాడు: “వద్దు, నా కుమారుని ఆ దేశం తీసుకు వెళ్లొద్దు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","పరలోక దేవుడైన యెహోవా నా స్వదేశము నుండి ఇక్కడికి నన్ను తీసుకొని వచ్చాడు. ఆ దేశం నా తండ్రికి, నా కుటుంబానికి మాతృదేశం కాని ఈ నూతన దేశం నీ కుటుంబానికి చెందుతుందని యెహోవా వాగ్దానం చేసాడు. ప్రభువు నీకంటే ముందర తన దేవదూతను పంపిస్తాడు. మరి నీవు నా కుమారునికి వధువును అక్కడనుంచి తెస్తావు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","అయితే అమ్మాయి నీతో రావటానికి నిరాకరిస్తే, ఈ వాగ్దాన విషయంలో నీ బాధ్యత తీరుపోతుంది. అంతేగాని నా కుమారుని మాత్రం నీవు ఆ దేశానికి తిరిగి తీసుకువెళ్లొద్దు.” ");
INSERT INTO tel2010_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","కనుక ఆ సేవకుడు తన యజమాని తొడకింద తన చేయి పెట్టి వాగ్దానం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","అబ్రాహాము ఒంటెలలో పదింటిని తీసుకొని ఆ సేవకుడు ఆ చోటు విడిచి వెళ్లాడు. రకరకాల అందాల కానుకలు ఎన్నో తనతో కూడ ఆ సేవకుడు తీసుకెళ్లాడు. మెసపొతేమియాలోని నాహోరు పట్టణం వెళ్లాడు ఆ సేవకుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","పట్టణం వెలుపల ఉన్న మంచి నీళ్ల బావి దగ్గరకు ఆ సేవకుడు సాయంకాలం వెళ్లాడు. నీళ్లు తీసుకొని పోయేందుకు స్త్రీలు సాయంకాలం వస్తారు. ఆ సేవకుడు తన ఒంటెలను అక్కడ మోకరింపజేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","ఆ సేవకుడు చెప్పాడు: “ప్రభూ, నీవు నా యజమాని అబ్రాహాము దేవుడవు. ఈ వేళ నన్ను అతని కుమారుని కోసం భార్యను కనుగొనునట్లు చేయుము. నా యజమాని అబ్రాహాముకు దయచేసి ఈ మేలు అనుగ్రహించు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ఇదిగో, మంచి నీళ్లు బావి దగ్గర నేను ఉన్నాను, పట్టణం నుండి అమ్మాయిలు నీళ్లు తోడటానికి ఇక్కడికి వస్తున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","ఇస్సాకు కోసం ఏ అమ్మాయి సరైనదో తెలుసుకొనేందుకు ఒక ప్రత్యేక సూచన కోసం నేను కనిపెడుతున్నాను. ఆ ప్రత్యేక సూచన ఏమిటంటే: ‘నేను నీళ్లు తాగాలి, నీ కడవ కింద పెట్టు’ అని అమ్మాయితో నేను అంటాను. ‘తాగు నీ ఒంటెలకు కూడా నేను నీళ్లు పోస్తాను’ అని అమ్మాయి గనుక చెబితే, అప్పుడు ఆమె సరైన అమ్మాయి అని నేను తెలుసుకొంటాను. అలా జరిగితే ఆమె ఇస్సాకుకు సరైన జోడు అని నీవు రుజువు చేసినట్టే. నా యజమానికి నీవు కరుణ చూపించావని నాకు తెలుస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","అంతలో, ఆ సేవకుడు ప్రార్థన ముగించక ముందే రిబ్కా అనే ఒక అమ్మాయి తన గ్రామం నుండి బావి దగ్గరకు వచ్చింది. రిబ్కా బెతూయేలు కుమార్తె. బెతూయేలు అబ్రాహాము సోదరుడు నాహోరు, మిల్కాల కుమారుడు. రిబ్కా తన నీళ్ల కడవ తన భుజంమీద పెట్టుకొని బావి దగ్గరకు వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","ఆ అమ్మాయి చాలా చక్కగా ఉంది. ఆమె కన్య. ఆమె ఎన్నడూ పురుషునితో శయనించలేదు. ఆమె తన కడవ నింపుకోటానికి బావిలోనికి దిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","అప్పుడు ఆ సేవకుడు ఆమె దగ్గరకు పరుగెత్తి వెళ్లి, “నాకు తాగటానికి దయచేసి నీ కడవలో కొన్ని నీళ్లు ఇస్తావా” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","రిబ్కా త్వరగా తన భుజంమీద నుండి కడవ దించి, అతనికి నీళ్లు ఇచ్చింది. “అయ్యా, ఇదిగో తాగండి” అంది రిబ్కా. ");
INSERT INTO tel2010_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","అతను తాగటానికి పోయడం అయిన వెంటనే, “నీ ఒంటెలకు గూడా నేను నీళ్లు పోస్తాను” అంది రిబ్కా. ");
INSERT INTO tel2010_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","రిబ్కా వెంటనే తన కడవలోని నీళ్లన్నీ ఒంటెల కోసం అని చెప్పి నీళ్ల తొట్టిలో పోసింది. తర్వాత ఇంకా నీళ్లు తెచ్చేందుకు ఆమె బావి దగ్గరకు పరుగెత్తింది. ఆ ఒంటెలన్నింటికి ఆమె నీళ్లు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ఆ సేవకుడు మౌనంగా ఆమెను గమనించాడు. యెహోవా తనకు జవాబిచ్చాడని, తన ప్రయాణాన్ని విజయవంతం చేశాడని అతను రూఢిగా తెలుసుకోవాలనుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ఒంటెలు నీళ్లు తాగడం అయిపోగానే, అతడు అరతులం బంగారపు ఉంగరం రిబ్కాకు ఇచ్చాడు. 5 తులాల ఎత్తుగల బంగారపు గాజులు రెండు అతడు ఆమెకు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“నీ తండ్రి ఎవరు? మా గుంపు పండుకొనేందుకు నీ తండ్రి ఇంటిలో చోటు ఉందా?” అని ఆ సేవకుడు ఆమెను అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","“నా తండ్రి బెతూయేలు, నాహోరు మిల్కాయొక్క కుమారుడు” అని రిబ్కా జవాబిచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","తర్వాత, “అవునండి, మీ ఒంటెలకు గడ్డి, మీరు పండుకొనేందుకు స్థలం మా దగ్గర ఉంది” అని ఆమె చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ఆ సేవకుడు వంగి యెహోవాను ఆరాధించి, ");
INSERT INTO tel2010_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“నా యజమాని అబ్రాహాము దేవుడైన యెహోవా స్తుతించబడు గాక. యెహోవా నా యజమానుని పట్ల దయ చూపాడు. నా యజమాని బంధువు యింటికి యెహోవా నన్ను నడిపించాడు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","అప్పుడు రిబ్కా పరుగెత్తి వెళ్లి తన ఇంటివారికి ఈ సంగతులన్నీ చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","రిబ్కాకు ఒక సోదరుడు ఉన్నాడు. అతని పేరు లాబాను. ఆ మనిషి తనతో చెప్పిన విషయాలు రిబ్కా చెప్పింది. లాబాను ఆమె మాటలు వింటున్నాడు. ఎప్పుడైతే తన సోదరి చేతులకు ఉంగరం, గాజులు లాబాను చూశాడో, అప్పుడు బావి దగ్గరకు అతడు పరుగెత్తాడు. అక్కడ ఆ మనిషి బావి దగ్గర ఒంటెల పక్కగా నిలబడి ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“అయ్యా, తమరికి లోనికి సుస్వాగతం. మీరలా ఇక్కడే బయట నిలబడి ఉండనక్కర్లేదు. మీ ఒంటెలకు స్థలం, మీరు పండుకొనేందుకు గది నేను సిద్ధం చేసాను” అని లాబాను చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","కనుక అబ్రాహాము సేవకుడు ఆ ఇంటిలో ప్రవేశించాడు. ఒంటెల పనిలో అతనికి లాబాను సహాయం చేసి, అతని ఒంటెలకు గడ్డి వేసాడు. అతను, అతనితో ఉన్న మనుష్యులకు కాళ్లు కడుక్కొనేందుకు నీళ్లు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","తర్వాత లాబాను అతనికి భోజనం పెట్టాడు. అయితే ఆ సేవకుడు తినకుండా నిరాకరించాడు. “నేను ఎందుకు వచ్చానో మీతో చేప్పకుండా నేను భోజనం చేయను” అన్నాడు అతను. కనుక లాబాను, “అలాగైతే మాతో చెప్పు మరి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","ఆ సేవకుడు చెప్పింది ఇది: “నేను అబ్రాహాము సేవకుడను. ");
INSERT INTO tel2010_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","అన్ని విషయాల్లోను యెహోవా నా యజమానిని ఎంతో గొప్పగా ఆశీర్వదించాడు. నా యజమాని మహా ఘనుడయ్యాడు. గొర్రెల మందలు, పశువుల మందలు విస్తారంగా యెహోవా అబ్రాహాముకు ఇచ్చాడు. అబ్రాహాముకు వెండి బంగారాలు విస్తారంగా ఉన్నాయి. చాలా మంది ఆడ మగ సేవకులు ఉన్నారు. ఒంటెలు, గాడిదలు చాలా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","నా యజమాని భార్య శారా. ఆమె చాలా వృద్ధాప్యంలో ఒక కుమారుని కన్నది. నా యజమాని తన ఆస్తి సర్వం ఆ కుమారునికి ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","నేను ఒక వాగ్దానం చేయాలని నా యజమాని నన్ను బలవంతం చేసాడు. నా యజమాని ‘నా కుమారుణ్ణి కనాను అమ్మాయిల్లో ఎవర్నీ చేసుకోనివ్వగూడదు. మనం ఆ ప్రజల మధ్య నివసిస్తున్నాం కాని కనాను అమ్మాయిల్నెవరినీ అతడు చేసుకోవటం నాకు ఇష్టం లేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","కనుక నీవు నా తండ్రి దేశానికి వెళ్తావని వాగ్దానం చేయాలి. నా వంశం వారి దగ్గరకు వెళ్లి, నా కుమారుని కోసం భార్యను కుదుర్చి’ అని నాతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","‘ఒక వేళ ఆ స్త్రీ నాతో కలిసి ఈ దేశానికి రాదేమో’ అని నేను నా యజమానితో అన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","అయితే నా యజమాని నాతో ఇలా చెప్పాడు, ‘నేను యెహోవాను సేవిస్తాను, యెహోవా తన దూతను నీతో కూడ పంపి నీకు సహాయం చేస్తాడు. అక్కడి ప్రజలలో నా కుమారుని కోసం భార్యను నీవు కనుక్కొంటావు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","కాని నీవు నా తండ్రి దేశం వెళ్లాక, నా కుమారుని కోసం భార్యను ఇచ్చేందుకు వారు నిరాకరిస్తే, అప్పుడు ఈ ప్రమాణ బాధ్యత నీకు ఉండదు.’ ");
INSERT INTO tel2010_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“ఈ వేళ నేను ఈ బావి దగ్గరకు వచ్చి అన్నాను: ‘నా యజమాని అబ్రాహాము దేవుడైన యెహోవా, దయతో నా ప్రయాణం విజయవంతం చేయి. ");
INSERT INTO tel2010_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","నేను ఈ బావి దగ్గర నిలబడి, నీళ్లకోసం ఒక అమ్మాయి ఇక్కడికి రావాలని నిరీక్షిస్తాను. అప్పుడు నేను, దయచేసి తాగటానికి నీ కడవలోనుంచి నీళ్లు ఇమ్మని అడుగుతాను. ");
INSERT INTO tel2010_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","సరైన అమ్మాయి అయితే ఒక ప్రత్యేక విధానంలో జవాబిస్తుంది. ఈ నీళ్లు తాగు, నీ ఒంటెలకు గూడ నేను నీళ్లు తెస్తాను అని ఆమె అంటుంది. ఆ విధంగా, నా యజమాని కుమారుని కోసం యెహోవా ఏర్పరచిన స్త్రీ ఆమె అని నేను తెలుసుకొంటాను.’ ");
INSERT INTO tel2010_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“నేను ప్రార్థించటం ముగించక ముందే, నీళ్ల కోసం రిబ్కా బావి దగ్గరకు వచ్చింది. ఆమె తన నీళ్ల కడవ తన భుజం మీద పెట్టుకొంది. ఆమె వెళ్లి బావినుండి నీళ్లు తోడింది. ‘దయచేసి కొంచెం నీళ్లు ఇమ్మని’ నేను ఆమెతో అన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","వెంటనే ఆమె తన భుజం మీదనుండి కడవదించి, నాకు నీళ్లు పోసి, ‘ఇవి త్రాగు, నీ ఒంటెలకు గూడ నేను నీళ్లు తెస్తాను’ అంది. అందుచేత నేను నీళ్లు తాగాను, నా ఒంటెలకు కూడా ఆమె నీళ్లు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","అప్పుడు ‘నీ తండ్రి ఎవరు?’ అని నేను ఆమెను అడిగాను. ‘మిల్కా నాహోరుల కుమారడైన బెతూయేలు నా తండ్రి’ అని ఆమె జవాబిచ్చింది. అప్పుడు ఆమె చేతికి ఉంగరం, గాజులు నేను ఇచ్చాను. ");
INSERT INTO tel2010_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","ఆ సమయంలో నేను నా తలవంచి యెహోవాకు వందనాలు చేశాను. నా యజమాని దేవుడైన యెహోవాను నేను స్తుతించాను. నా యజమాని సోదరుని మనుమరాలి దగ్గరకే నన్ను ఆయన తిన్నగా నడిపించినందుకు ఆయనకు వందనాలు చెప్పాను. ");
INSERT INTO tel2010_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ఇప్పుడు మీరేం చేస్తారో నాకు చెప్పండి. నా యజమాని యెడల మీరు దయ, నమ్మకత్వం చూపి, మీ కుమార్తెను ఆయనకు ఇస్తారా? లేక మీ కుమార్తెను ఇవ్వటానికి నిరాకరిస్తారా? నేను ఏమి చెయ్యాలో నాకు తెలిసేటట్టు, మీరు చెప్పండి.” ");
INSERT INTO tel2010_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","అప్పుడు లాబాను, బెతూయేలు జవాబిచ్చారు. “ఇది యెహోవా నుండి వచ్చినట్లు మేము చూస్తున్నాము. కాబట్టి దీన్ని మార్చమని మేము చెప్పుటకు ఏమీలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","రిబ్కా నీ ముందే వున్నది. ఆమెను తీసుకొని వెళ్లు. నీ యజమాని కుమారుణ్ణి ఆమె పెళ్లి చేసుకొంటుంది. ఇదే యెహోవా కోరేది.” ");
INSERT INTO tel2010_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","అబ్రాహాము సేవకుడు ఈ మాటలు విని, యెహోవా యెదుట నేలపై సాగిలపడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","అప్పుడు ఆ సేవకుడు తాను తెచ్చిన కానుకలను రిబ్కాకు ఇచ్చాడు బంగారు వెండి నగలు, ఎన్నో అందమైన బట్టలు అతడు రిబ్కాకు యిచ్చాడు. ఆమె సోదరునికి, తల్లికి గూడ చాలా ఖరీదైన కానుకలు అతడు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","ఆ సేవకుడు, అతనితోనున్న సేవకులు తిని, తాగి అక్కడే ఉన్నారు. ఆ రాత్రి వారు అక్కడే ఉన్నారు. మర్నాడు ఉదయం వారు లేచి, “ఇప్పుడు మేం తిరిగి మా యజమాని దగ్గరకు వెళ్తాం” అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","అప్పుడు రిబ్కా తల్లి, సహోదరుడు ఈ విధంగా చెప్పారు, “రిబ్కాను కొన్నాళ్లు మా దగ్గర ఉండనివ్వు. పది రోజులు ఉండనివ్వు. ఆ తర్వాత ఆమె వెళ్లవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","కానీ ఆ సేవకుడు, “నన్ను ఇంక ఆపవద్దు. నా ప్రయాణాన్ని యెహోవా విజయవంతం చేసాడు. కనుక ఇప్పుడు నా యజమాని దగ్గరకు నన్ను వెళ్లనివ్వండి” అని వారితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","“రిబ్కాను పిలిచి, ఆమె ఇష్టం ఏమీటో మేము అడుగుతాం” అన్నారు రిబ్కా అన్న, తల్లి. ");
INSERT INTO tel2010_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","వారు రిబ్కాను పిలిచి, “నీవు ఈ మనుష్యునితో కలిసి ఇప్పుడే వెళ్తావా?” అని అడిగారు. “అవును, నేను వెళ్తాను అంది రిబ్కా.” ");
INSERT INTO tel2010_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","కనుక అబ్రాహాము సేవకునితో, అతని మనుష్యులతో కలిసి రిబ్కా వెళ్లటానికి వారు అనుమతించారు. రిబ్కా దాది కూడ వారితో వెళ్లింది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","వారు వెళ్తున్నప్పుడు రిబ్కాతో వారు ఇలా చెప్పారు: “మా సోదరి, వేలమందికి, పది వేలమందికి నీవు తల్లిని అవుదువు గాక. నీ సంతానము వారి శత్రువులను ఓడించి వారి పట్టణాలను స్వాధీనం చేసుకొందురు గాక!” ");
INSERT INTO tel2010_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","అప్పుడు రిబ్కా, ఆమె దాది ఒంటెలను ఎక్కి ఆ సేవకుని, అతని మనుష్యులను వెంబడించారు. ఆ విధంగా ఆ సేవకుడు రిబ్కాను తోడుకొని తిరుగు ప్రయాణమయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","అప్పటికి ఇస్సాకు బెయేర్ లహాయిరోయి విడిచి, నెగెవులో నివసిస్తున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","ఒక సాయంకాలం ఇస్సాకు ధ్యానించుట కోసం అలా బయటకు పోలాల్లోకి వెళ్లాడు. ఇస్సాకు తలెత్తి చూచేటప్పటికి అంత దూరంలో వస్తున్న ఒంటెలు కనిపించాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","రిబ్కా తలెత్తి ఇస్సాకును చూసింది. అప్పుడామె ఒంటె మీద నుండి క్రిందికి దిగెను. ");
INSERT INTO tel2010_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“మనలను కలుసుకొనేందుకు ఆ పొలాల్లో నడిచి వస్తున్న యువకుడు ఎవరు?” అంటు ఆమె సేవకుని అడిగింది. “ఆయనే నా యజమాని కుమారుడు” అని చెప్పాడు ఆ సేవకుడు. కనుక రిబ్కా తన ముఖం మీద ముసుగు కప్పుకొంది. ");
INSERT INTO tel2010_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","జరిగిన సంగతులన్నీ ఇస్సాకుతో ఆ సేవకుడు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","అప్పుడు ఇస్సాకు ఆ అమ్మాయిని తన తల్లి గుడారంలోకి తీసుకు వచ్చాడు. ఆ రోజు రిబ్కా ఇస్సాకు భార్య అయ్యింది. ఇస్సాకు ఆమెను చాలా ప్రేమించాడు. తన తల్లి మరణించిన తర్వాత ఇస్సాకు దుఃఖనివారణ పొందాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","అబ్రాహాము మళ్లీ పెళ్లి చేసుకొన్నాడు. ఆయన కొత్త భార్య పేరు కెతూరా. ");
INSERT INTO tel2010_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","కెతూరాకు జిమ్రాను, యొక్షాను, మెదాను, మిద్యాను, ఇష్బాకు, షూవహు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","యొక్షాను, షేబ, దెదానులకు తండ్రి. అష్షూరు, లెయుమీ మరియు లెతూషీ ప్రజలు దెదాను సంతానము. ");
INSERT INTO tel2010_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","మిద్యాను కుమారులు ఏఫా, ఏఫెరు, హనోకు, అబీదా, ఎల్దాయా. అబ్రాహాము కెతూరా, వివాహం మూలంగా ఈ కుమారులంతా పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","అబ్రాహాము చనిపోక ముందు తన దాసీల కుమారులందరికి అతడు కొన్ని కానుకలు ఇచ్చాడు. ఆ కుమారులను అబ్రాహాము తూర్పునకు పంపాడు. అతడు వారిని ఇస్సాకుకు దూరంగా పంపించి వేసాడు. అప్పుడు అబ్రాహాము తన ఆస్తి సర్వస్వం ఇస్సాకుకు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","అబ్రాహాము 175 సంవత్సరాలు వయస్సు వరకు జీవించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","అప్పుడు అబ్రాహాము బలము తగ్గిపోయి చనిపోయాడు. సుదీర్ఘ సంతృప్తికర జీవతం అతడు జీవించాడు. అతడు మరణించి తనవారి దగ్గరకు చేర్చబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","అతని కుమారులు ఇస్సాకు, ఇష్మాయేలు కలసి మక్పేలా గుహలో అతణ్ణి పాతిపెట్టారు. సోహరు కుమారుడు ఎఫ్రోను పొలంలో ఈ గుహ ఉంది. అది మమ్రేకు తూర్పున ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","హిత్తీ ప్రజల దగ్గర్నుండి అబ్రాహాము కొన్న గుహ ఇదే. అబ్రాహాము తన భార్య శారాతో అక్కడ పాతిపెట్టబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","అబ్రాహాము చనిపోయిన తరువాత, ఇస్సాకును దేవుడు ఆశీర్వదించాడు. మరియు ఇస్సాకు బేయేర్ లహాయిలోనే నివాసం కొనసాగించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ఇష్మాయేలు వంశంవారి జాబితా ఇది. అబ్రాహాము హాగరుల కుమారుడు ఇష్మాయేలు. (శారాకు ఈజిప్టు దాసి హాగరు.) ");
INSERT INTO tel2010_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ఇష్మాయేలు కుమారుల పేర్లు ఇవి: మొదటి కుమారుని పేరు సేబాయోతు, తర్వాత కేదారు పుట్టాడు, తర్వాత అద్బయేలు, మిబాశిము, ");
INSERT INTO tel2010_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","మిష్మా, దమారమశ్శా, ");
INSERT INTO tel2010_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","హదరు, తేమా, యెతూరు, నాపీషు, కెదెమా పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","అవి ఇష్మాయేలు కుమారుల పేర్లు. ఒక్కో కుమారునికి ఒక్కో స్వంత శిబిరం ఉండేది, అదే ఒక చిన్న పట్టణం అయింది. పన్నెండు మంది కుమారులు, వారి స్వంత ప్రజలతో, పన్నెండు మంది యువరాజుల్లా ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","ఇష్మాయేలు 137 సంవత్సరాలు బతికాడు. తరువాత అతను చనిపోయి, అతని పూర్వీకులతో చేర్చబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ఇష్మాయేలు సంతానం వారు ఎడారి ప్రాంతమంతా బసచేసారు. ఈ ప్రాంతం ఈజిప్టు దగ్గర హవీలా, షూరు నుండి ఉత్తరపు చివరన అష్షూరు వరకు విస్తరించి ఉంది. ఇష్మాయేలు సంతానము తరచూ అతని సోదరుని ప్రజలను ఎదుర్కొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ఇస్సాకు కుటుంబం చరిత్ర ఇది. అబ్రాహాముకు ఇస్సాకు అనే కుమారుడు ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ఇస్సాకు వయస్సు 40 సంవత్సరాలు ఉన్నప్పుడు రిబ్కాను అతడు వివాహం చేసుకొన్నాడు. రిబ్కా పద్దనరాముకు చెందినది. ఆమె బెతూయేలు కుమార్తె, అరామీయుడగు లాబానుకు సోదరి. ");
INSERT INTO tel2010_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ఇస్సాకు భార్యకు పిల్లలు పుట్టలేదు. కనుక ఇస్సాకు తన భార్య కోసం ప్రార్థించాడు. ఇస్సాకు ప్రార్థన యెహోవా విన్నాడు. రిబ్కాను గర్భవతి కానిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","రిబ్కా గర్భవతిగా ఉన్నప్పుడు, ఆమె గర్భంలో కవల పిల్లలు పెనుగులాడారు. రిబ్కా యెహోవాను ప్రార్థించి, “ఎందుకు నాకు ఇలా జరిగింది?” అని అడిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ఆమెతో యెహోవా చెప్పాడు: “నీ గర్భంలో రెండు జనాంగాలు ఉన్నాయి. రెండు వంశాల పాలకులు నీలోనుండి పుడతారు. కాని వారు విభజించబడతారు. ఒక కుమారుడు మరో కుమారుని కంటే బలవంతుడుగా ఉంటాడు. పెద్ద కుమారుడు చిన్న కుమారుని సేవిస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","తగిన సమయం రాగానే రిబ్కా కవల పిల్లల్ని కన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","మొదట శిశువు ఎరుపు. వాని చర్మం బొచ్చు అంగీలా ఉంది. కనుక వానికి ఏశావు అని పేరు పెట్టబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","రెండవ శిశువు పుట్టినప్పుడు వాడు ఏశావు మడిమను గట్టిగా పట్టుకొని ఉన్నాడు. కనుక ఆ శిశువుకు యాకోబు అని పేరు పెట్టబడింది. యాకోబు, ఏశావు పుట్టినప్పుడు ఇస్సాకు వయస్సు 60 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","అబ్బాయిలు పెద్దవాళ్లయ్యారు. ఏశావు నిపుణతగల వేటగాడయ్యాడు. బయట పొలాల్లో ఉండటం అంటే అతనికి చాలా ఇష్టం. అయితే యాకోబు నెమ్మదిపరుడు. అతను తన గుడారంలోనే ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ఇస్సాకు ఏశావును చాలా ప్రేమించాడు. ఏశావు వేటాడిన జంతువులను తినటం అతనికి ఇష్టం. కాని రిబ్కాకు యాకోబు మీద ప్రేమ. ");
INSERT INTO tel2010_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ఒకసారి ఏశావు వేటనుండి తిరిగి వచ్చాడు. అతను అలసిపోయి, ఆకలితో బలహీనంగా ఉన్నాడు. యాకోబు వంట పాత్రలో చిక్కుడుకాయలు వండుతున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","కనుక ఏశావు, “నేను ఆకలితో నీరసం అయిపోయాను ఆ ఎర్రటి చిక్కుడు కాయలు నాకు కొంచెం పెట్టు” అని యాకోబును అడిగాడు. (అందుకే ప్రజలు అతణ్ణి ఏదోం అని పిలిచేవాళ్లు.) ");
INSERT INTO tel2010_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","అయితే యాకోబు, “నీ జ్యేష్ఠత్వపు జన్మ హక్కుల్ని ఈ వేళ నాకు అమ్మివేయాలి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ఏశావు “నేను ఆకలితో దాదాపు చచ్చాను. నేను చనిపోతే, నా తండ్రి ఐశ్వర్యారన్నీ నాకు సహాయపడవు. కనుక నా వాటా నీకు ఇచ్చేస్తాను” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","కానీ యాకోబు దాన్ని, “నాకు ఇస్తావని ముందు ప్రమాణం చేయాలి” అన్నాడు. కనుక ఏశావు యాకోబుకు ప్రమాణం చేసాడు. తన తండ్రి ఐశ్వర్యంలో తన వాటాను ఏశావు యాకోబుకు అమ్మివేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","అప్పుడు యాకోబు రొట్టె, భోజనం ఏశావుకు ఇచ్చాడు. ఏశావు తిని, తాగి వెళ్లిపోయాడు. కనుక ఏశావు తన జ్యేష్ఠత్వపు హక్కులను లక్ష్యపెట్ట లేదని వ్యక్తం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ఒకసారి కరువుకాలం వచ్చింది. అబ్రాహాము జీవిత కాలంలో వచ్చిన కరువులాంటిదే ఇది. కనుక గెరారు పట్టణంలో ఉన్న ఫిలిష్తీ ప్రజల రాజు అబీమెలెకు దగ్గరకు ఇస్సాకు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ఇస్సాకుతో యెహోవా మాట్లాడాడు. యెహోవా చెప్పాడు: “ఈజిప్టు వెళ్లవద్దు. నీవు ఉండాలని నేను నీకు ఆజ్ఞాపించిన దేశంలోనే నీవు నివసించాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ఆ దేశంలోనే నీవు నివాసం ఉండు, నేను నీతో ఉంటాను. నిన్ను నేను ఆశీర్వదిస్తాను. నీకు నీ వంశానికి ఈ భూభాగాలన్నీ ఇస్తాను. నీ తండ్రి అబ్రాహాముకు నేను వాగ్దానం చేసినదంతా నీకు నేను ఇస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","ఆకాశ నక్షత్రాలు ఎన్నో, నీ సంతానం అంతటిదిగా నేను చేస్తాను. ఈ దేశాలన్నీ నీ కుటుంబానికి నేను ఇస్తాను. నీ సంతానం మూలంగా భూమిమీద జనాంగాలన్నీ ఆశీర్వదించబడతాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","నీ తండ్రియైన అబ్రాహాము నా మాటలకు లోబడి, నేను చెప్పిన వాటిని చేసాడు గనుక నేను ఇది చేస్తాను. అబ్రాహాము నా ఆజ్ఞలకు చట్టాలకు, నియమాలకు విధేయుడయ్యాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","కనుక ఇస్సాకు గెరారులో ఉండిపోయి అక్కడ నివసించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","ఇస్సాకు భార్య రిబ్కా చాలా అందగత్తె. రిబ్కాను గూర్చి అక్కడి మనుష్యులు ఇస్సాకును అడిగారు. “ఆమె నా సోదరి” అని చెప్పాడు ఇస్సాకు. రిబ్కా తన భార్య అని వారితో చెప్పడానికి ఇస్సాకు భయపడ్డాడు. ఆమెను పొందటం కోసం ఆ మనుష్యులు తనను చంపివేస్తారని ఇస్సాకు భయపడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ఇస్సాకు అక్కడు చాలా కాలం ఉన్న తర్వాత, ఇస్సాకు అతని భార్యతో సరసాలు ఆడుకోవటం అబీమెలెకు తన కిటికీ గుండా చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","అబీమెలెకు ఇస్సాకును పిలిచి “ఈ స్త్రీ నీ భార్య. ఈమె నీ సోదరి అని మాతో ఎందుకు చెప్పావు?” అని అడిగాడు. “నీవు ఈమెను పొందటం కోసం నన్ను చంపేస్తావని నేను భయపడ్డాను” అని ఇస్సాకు అతనితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","“నీవు మాకు కీడు చేసావు. మా మనుష్యుల్లో ఎవడైనా ఒకడు నీ భార్యతో శయనించి ఉండేవాడు. అప్పుడు అతడు మహా పాపము చేసిన నేరస్థుడయ్యైవాడు” అన్నాడు అబీమెలెకు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","అందుచేత అబీమెలెకు ప్రజలందరికి హెచ్చరిక ఇచ్చాడు. “ఈ పురుషునిగాని, ఇతని భార్యనుగాని ఎవరూ బాధించగూడదు. వారిని బాధించినవాడు ఎవరైనా సరే చంపివేయబడతాడు” అని అతడు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ఆ దేశంలో ఇస్సాకు పొలాల్లో విత్తనాలు విత్తాడు. ఆ సంవత్సరం అతడు విస్తారంగా పంట కూర్చుకున్నాడు. యెహోవా అతన్ని ఎంతో అశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","ఇస్సాకు ధనికుడయ్యాడు. అతడు మహా ఐశ్వర్యవంతుడు అయ్యేవరకు మరింత విస్తారంగా ఐశ్వర్యం కూర్చుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","గొర్రెల మందలు, పశువుల మందలు అతనికి విస్తారంగా ఉన్నాయి. అతనికి చాలా మంది బానిసలు కూడా ఉన్నారు. ఫిలిష్తీ ప్రజలంతా అతని మీద అసూయ పడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","కనుక ఇస్సాకు తండ్రియైన అబ్రాహాము, అతని సేవకులు తవ్విన చాలా బావుల్ని ఫిలిష్తీ ప్రజలు పాడుచేశారు. ఆ బావుల్ని ఫిలిష్తీ ప్రజలు మట్టితో నింపారు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","అబీమెలెకు ఇస్సాకుతో, “మా దేశం వదలి పెట్టు. నీవు మాకంటే చాలా అత్యధికంగా శక్తిమంతుడవయ్యావు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","కనుక ఇస్సాకు ఆ స్థలం విడిచిపెట్టి, గెరారు చిన్న నదికి సమీపంలో నివాసం చేసాడు. ఇస్సాకు అక్కడ ఉండి జీవించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","దీనికి ఎంతో ముందు అబ్రాహాము చాలా బావులు తవ్వాడు. అబ్రాహాము చనిపోయిన తర్వాత ఫిలిష్తీ ప్రజలు ఆ బావులను చెత్తతో నింపేసారు. కనుక ఇస్సాకు తిరిగి వెళ్లి ఆ బావులను మళ్లీ తవ్వాడు. వాటికి తన తండ్రి పెట్టిన పేర్లే ఇస్సాకు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","చిన్న నది దగ్గర ఇస్సాకు సేవకులు ఒక బావి తవ్వారు. ఆ బావిలో నీటి ఊట ఒకటి ఉబికింది. ");
INSERT INTO tel2010_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","అయితే గెరారు లోయలో గొర్రెల మందలను కాసేవాళ్లు ఇస్సాకు పనివాళ్లతో జగడమాడారు. “ఈ నీళ్లు మావి అన్నారు వాళ్లు.” కనుక ఆ బావికి “ఏశెకు” అని ఇస్సాకు పేరు పెట్టాడు. అక్కడ ఆ మనుష్యులు అతనితో జగడమాడారు గనుక దానికి ఆ పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","అప్పుడు ఇస్సాకు సేవకులు మరో బావి తవ్వారు. ఆ బావి మూలంగా అక్కడి ప్రజలు కూడా జగడమాడారు. కనుక ఆ బావికి “శిత్నా” అని ఇస్సాకు పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","ఇస్సాకు అక్కడనుండి వెళ్లపోయి మరో బావి తవ్వాడు. ఆ బావి విషయం వాదించటానికి ఎవరూ రాలేదు. కనుక ఆ బావికి “రహెబోతు” అని ఇస్సాకు పేరు పెట్టాడు. “ఇప్పుడు మనకోసం యెహోవా ఒక స్థలం ఇచ్చాడు. ఈ దేశంలో మనం అభివృద్ధిపొంది సఫలము కావాలి.” అన్నాడు ఇస్సాకు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","ఆ చోటు నుండి ఇస్సాకు బెయేర్షెబాకు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ఆ రాత్రి ఇస్సాకుతో యెహోవా మాట్లాడాడు. “నీ తండ్రి అబ్రాహాము దేవుణ్ణి నేను. భయపడకు. నేను నీకు తోడుగా ఉన్నాను, నేను నిన్ను ఆశీర్వదిస్తాను. నీ వంశస్తులను అభివృద్ధి చేస్తాను. నా సేవకుడు అబ్రాహాము కారణంగా నేను ఇది చేస్తాను” అని చెప్పాడు యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","కనుక ఆ స్థలంలో దేవుణ్ణి ఆరాధించేందుకు ఒక బలిపీఠాన్ని ఇస్సాకు కట్టించాడు. ఇస్సాకు అక్కడ నివాసం చేయగా, అతని సేవకులు ఒక బావి తవ్వారు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ఇస్సాకును చూసేందుకు గెరారు నుండి అబీమెలెకు వచ్చాడు. సలహాదారుడు అహుజతును సైన్యాధిపతయైన ఫీకోలును వెంటబెట్టుకొని అబీమెలెకు వచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ఇస్సాకు వారితో, “ఇంతకుముందు నీవు నాతో స్నేహంగా లేవు గదా. నీ దేశం వదిలిపెట్టేట్టు నీవు నన్ను బలవంతం గూడా చేసావు గదా. ఇప్పుడు నన్ను చూడటానికి ఎందుకు వచ్చావు?” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","వారు జవాబు చెప్పారు: “యెహోవా నీకు తోడుగా ఉన్నాడని ఇప్పుడు మాకు తెలిసింది. మనం ఒక ఒడంబడిక చేసుకోవాలని మా అభిప్రాయం. మాకు నీవు ఒక ప్రమాణం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","మేము నిన్ను బాధించలేదు. ఇప్పుడు నీవు కూడా మమ్మల్ని బాధించనని ప్రమాణం చేయాలి. నిన్ను మేము పంపించివేసినా, సమాధానంగా పంపించాం. యెహోవా నిన్ను ఆశీర్వదించాడని యిప్పుడు తేటగా తెలుస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ఇస్సాకు వారికి విందు చేసాడు. వారు తిని తాగారు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","మర్నాడు ఉదయం ఒక్కొక్కరు ఒక్కో ప్రమాణం చేసారు. తర్వాత ఆ మనుష్యులు సమాధానంగా వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ఆ రోజున ఇస్సాకు సేవకులు వచ్చి, వారు తవ్విన బావిని గూర్చి చెప్పారు. “ఆ బావిలో నీళ్లు చూశాం” అని చెప్పారు సేవకులు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","కనుక ఆ బావికి “షేబ” అని పేరు పెట్టాడు ఇస్సాకు. ఆ పట్టణం ఇప్పటికీ బెయేర్షెబా అని పిలువబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ఏశావు 40 సంవత్సరాల వయస్సులో హిత్తీ స్త్రీలను ఇద్దరిని వివాహం చేసుకొన్నాడు. ఒక స్త్రీ బేయేరి కుమార్తె యహూదీతు. ఇంకొక ఆమె ఏలోను కుమార్తె బాశెమతు. ");
INSERT INTO tel2010_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","ఈ వివాహాలు ఇస్సాకు రిబ్కాలను చాలా బాధపెట్టాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ఇస్సాకు ముసలివాడైనప్పుడు అతని చూపు సన్నగిల్లింది. ఇస్సాకు తేటగా చూడలేకపోయాడు. ఒకనాడు తన పెద్ద కుమారుని అతడు తన దగ్గరకు పిల్చాడు, “కుమారుడా” అన్నాడు. “ఇదిగో ఇక్కడే ఉన్నాను” అని జవాబిచ్చాడు ఏశావు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ఇస్సాకు చెప్పాడు: “చూడు, నేను ముసలివాడనయ్యాను. ఒకవేళ త్వరలో నేను చనిపోతానేమో! ");
INSERT INTO tel2010_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","కనుక నీ విల్లు, అంబులు తీసుకొని వేటకు వెళ్లు. నేను తినటానికి ఒక జంతువును చంపు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","నాకు ఇష్టమైన భోజనం తయారు చేయి. అది నా దగ్గరకు తీసుకురా, నేను తింటాను. అప్పుడు నేను మరణించక ముందు నిన్ను ఆశీర్వదిస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","కనుక ఏశావు వేటకు వెళ్లాడు. ఇస్సాకు తన కుమారుడైన ఏశావుతో ఆ సంగతులు చెబతున్నప్పుడు రిబ్కా విన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","తన కుమారుడైన యాకోబుతో రిబ్కా చెప్పింది: “విను, నీ సోదరుడు ఏశావుతో నీ తండ్రి మాట్లాడటం నేను విన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘నేను తినటానికి ఒక జంతువును చంపి నా కోసం భోజనం సిద్ధం చేయి, నేను భోంచేస్తాను. అప్పుడు నేను మరణించక ముందు నిన్ను ఆశీర్వదిస్తాను’ అని నీ తండ్రి చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","కనుక, కుమారుడా నేను చెప్పేది విని అలా చేయి. ");
INSERT INTO tel2010_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","మన మేకల మందలోనికి వెళ్లి, రెండు మేక పిల్లల్ని నా దగ్గరకు తీసుకురా. నీ తండ్రికి ఇష్టమైన పద్ధతిలో నేను వాటిని సిద్ధం చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","అప్పుడు ఆ భోజనాన్ని నీవే నీ తండ్రి దగ్గరకు తీసుకొని వెళ్లు. ఆయన మరణించక ముందు నిన్ను ఆశీర్వదిస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","అయితే యాకోబు తన తల్లి రిబ్కాతో ఇలా చెప్పాడు: “అయితే నా సోదరుడి శరీరమంతా వెంట్రుకలు ఉంటాయి, అతనిలా నాకు వెంట్రుకలు ఉండవు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","నా తండ్రి నన్ను తాకితే నేను ఏశావును కానని ఆయన తెలుసుకొంటాడు. అప్పుడు ఆయన నన్ను ఆశీర్వదించడు. నేను ఆయన్ను మోసం చేయటానికి ప్రయత్నించినందువల్ల ఆయన నన్ను శపిస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","కనుక రిబ్కా, “ఏదైనా కష్టం వస్తే ఆ నింద నేను భరిస్తాను. నేను చెప్పినది చేయి. వెళ్లి మేకల్ని తెచ్చి నాకు ఇవ్వు” అని అతనితో చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","కనుక యాకోబు వెళ్లి రెండు మేకల్ని తీసుకొని, తెచ్చి వాటిని తల్లికి ఇచ్చాడు. ఇస్సాకుకు ఇష్టమైన ఒక ప్రత్యేక విధానంలో అతని తల్లి ఆ మేకలతో వంట చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","తర్వాత ఆమె, తన కుమారుడు ఏశావు ఎక్కువగా ఇష్టపడి ధరించే బట్టలు తెచ్చింది. ఆ బట్టలను చిన్న కుమారుడు యాకోబుకు ధరింపజేసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ఆ మేకల చర్మాలను రిబ్కా తీసుకొని, వాటిని యాకోబు చేతుల మీద వేసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","తర్వాత రిబ్కా తాను వండిన భోజనం తెచ్చి, దానిని యాకోబుకు యిచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","యాకోబు తన తండ్రి దగ్గరకు వెళ్లి, “తండ్రీ” అని పిల్చాడు. “ఏమీ కుమారుడా, ఎవరు నీవు” అన్నాడు తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","“నేను ఏశావును, నీ పెద్ద కుమారుడను. నీవు నాకు చెప్పిన పనులు చేసాను. నీ కోసం నేను వేటాడి తెచ్చిన జంతువులను సమకూర్చి వాటిచే నీకొరకైన భోజనమును సిద్ధపరచితిని. దానిని తిని, తృప్తిపొంది నన్ను ఆశీర్వదించవచ్చు” అని యాకోబు తన తండ్రితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","అయితే ఇస్సాకు, “నీవు ఇంత త్వరగా ఎలా వేటాడి జంతువుల్ని చంపగలిగావు?” అని తన కుమారుణ్ణి అడిగాడు. “త్వరగా నేను జంతువుల్ని సంపాదించటానికి నీ దేవుడైన యెహోవా నాకు సహాయంచేసాడు గనుక” అని యాకోబు జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","అప్పుడు ఇస్సాకు, “నా కుమారుడా నేను నిన్ను తడిమి చూడాలి. కనుక నీవిలా నా దగ్గరగా రా. నిన్ను నేను తడిమి చూస్తే, నిజంగా నీవు నా కుమారుడు ఏశావువో కాదో తెలుస్తుంది” అన్నాడు యాకోబతో. ");
INSERT INTO tel2010_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","కనుక తన తండ్రియైన ఇస్సాకు దగ్గరకు యాకోబు వెళ్లాడు. ఇస్సాకు అతణ్ణి తడిమి చూసి, “నీ స్వరం యాకోబు స్వరంలా ఉంది. కానీ, నీ చేతులు మాత్రం ఏశావు చేతుల్లా వెంట్రుకలతో ఉన్నాయి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","యాకోబు చేతులు ఏశావు చేతులవలె వెంట్రుకలతో ఉన్నందువల్ల అతడు యాకోబు అని ఇస్సాకుకు తెలియలేదు. కనుక ఇస్సాకు యాకోబును ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","“నిజంగా నీవు నా కుమారుడు ఏశావువేనా?” అన్నాడు ఇస్సాకు. “అవును, నేనే”అని యాకోబు జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","అప్పుడు ఇస్సాకు, “ఆ భోజనం నా దగ్గరకు తీసుకురా. నేను అది భోంచేసి, నిన్ను ఆశీర్వదిస్తాను” అన్నాడు. కనుక యాకోబు అతనికి భోజనం ఇచ్చాడు, అతడు భోంచేసాడు. యాకోబు అతనికి ద్రాక్షారసం ఇచ్చాడు, అతడు త్రాగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","అప్పుడు ఇస్సాకు, “కుమారుడా, దగ్గరకు వచ్చి నన్ను ముద్దు పెట్టుకో” అని అతనితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","కనుక యాకోబు తన తండ్రి దగ్గరకు వెళ్లి, అతణ్ణి ముద్దు పెట్టుకొన్నాడు. అతని వస్త్రాలను ఇస్సాకు వాసన చూచి, అతణ్ణి ఆశీర్వదించాడు. ఇస్సాకు ఇలా అన్నాడు: “నా కుమారుని వాసన యెహోవా ఆశీర్వదించిన చేని సువాసనా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","విస్తారమైన పంటలు, ద్రాక్షారసం నీకు ఉండేటట్టు వర్షాలు యెహోవా నీకు సమృద్ధిగా ఇచ్చుగాక. ");
INSERT INTO tel2010_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","మనుష్యులంతా నిన్నే సేవిస్తారు గాక, జనములు నీకు సాగిలపడుదురు గాక, నీ సోదరుల మీద నీవు పరిపాలన చేస్తావు నీ తల్లియొక్క కుమారులు నీకు సాగిలపడి నీకు లోబడుతారు, “నిన్ను శపించే ప్రతీ వ్యక్తి శపించబడుతాడు, నిన్ను ఆశీర్వదించే ప్రతి వ్యక్తీ ఆశీర్వదించబడుతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","యాకోబును ఆశీర్వదించటం ముగించాడు ఇస్సాకు. అప్పుడు, తన తండ్రి ఇస్సాకును విడిచి యాకోబు వెళ్తుండగా, వేటనుండి ఏశావు తిరిగి వచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","తన తండ్రికి ఇష్టమైన ప్రత్యేక విధానంలో భోజనం తయారు చేసాడు ఏశావు. దానిని ఏశావు తన తండ్రి దగ్గరకు తెచ్చాడు. అతడు తన తండ్రితో, “నాయనా, లేచి నీ కుమారుడు నీ కోసం వేటాడి తెచ్చి వండిన మాంసాన్ని తిను, అప్పుడు నీవు నన్ను దీవించగలవు”. ");
INSERT INTO tel2010_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","అయితే ఇస్సాకు, “ఎవరు నీవు?” అన్నాడు అతనితో. “నేను నీ మొదటి కుమారుణ్ణి ఏశావును” అన్నాడతను. ");
INSERT INTO tel2010_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","అప్పుడు ఇస్సాకు చాలా బాధపడి, “అలాగైతే నీవు రాకముందు భోజనం వండి నా దగ్గరకు తీసుకు వచ్చినదెవరు? నేను అదంతా శుభ్రంగా భోంచేసి, అతణ్ణి నేను ఆశీర్వదించానుగదా. ఇప్పుడు మళ్లీ నా ఆశీర్వాదాన్ని నేను వెనుకకు తీసుకోవటానికి సమయం మించిపోయిందే” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ఏశావు తన తండ్రి మాటలు విన్నాడు. అతనిలో కోపం, కక్ష రెచ్చిపోయాయి. అతను గట్టిగా ఏడ్చేసి “అలాగైతే నన్ను కూడా ఆశీర్వదించు నాయనా” అని తన తండ్రితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","“నీ సోదరుడు నన్ను మోసం చేసాడు. అతను వచ్చి, నీ ఆశీర్వాదాలు తీసుకొన్నాడు” అన్నాడు ఇస్సాకు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","“అతని పేరే యాకోబు (మోసగాడు). అది అతనికి సరైన పేరు. రెండుసార్లు అతడు నన్ను మోసం చేసాడు. జ్యేష్ఠత్వపు హక్కు తీసువేసుకొన్నాడు, ఇప్పుడు నా ఆశీర్వాదాలు తీసువేసుకొన్నాడు.” అని చెప్పి ఏశావు, “మరి నా కోసం ఆశీర్వాదాలు ఏమైనా మిగిల్చావా?” అని ప్రశ్నించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","“లేదు, ఇప్పుడు చాలా ఆలస్యమైపోయింది. నీ మీద పరిపాలన చేసే అధికారం యాకోబుకు నేనిచ్చాను. అతని సోదరులంతా అతని సేవకులవుతారని కూడా నేను చెప్పాను. ధాన్యం, ద్రాక్షారసం, సమృద్ధిగా కలిగే అశీర్వాదం కూడా నేను అతనికి యిచ్చాను. నీకు ఇచ్చేందుకు యింకేమీ మిగల్లేదు కుమారుడా” అని జవాబిచ్చాడు ఇస్సాకు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","తన తండ్రిని బ్రతిమలాడుతూనే ఉన్నాడు. “నాయనా, నీ దగ్గర ఒక్క ఆశీర్వదమే ఉందా? నన్ను కూడా ఆశీర్వదించు నాయనా” అంటూ ఏశావు ఏడ్వటం మొదలుబెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","అప్పుడు అతనితో ఇస్సాకు ఇలా చెప్పాడు: “నీవు సారం లేని దేశంలో నివసిస్తావు నీకు వర్షపాతం ఎక్కువగా ఉండదు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","నీ మనుగడ కోసం నీవు పోరాడాలి, నీవు నీ సోదరునికి బానిసవు అవుతావు అయితే స్వతంత్రం కోసం నీవు పోరాడతావు అతని స్వాధీనం నుండి నీవు విడిపోతావు.” ");
INSERT INTO tel2010_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ఆ తరువాత తన తండ్రి అతణ్ణి ఆశీర్వదించడంవల్ల యాకోబును ఏశావు అసహ్యించుకొన్నాడు. ఏశావు “త్వరలోనే నా తండ్రి చనిపోతాడు, నేను అతని కోసం దుఃఖిస్తాను. కాని ఆ తర్వాత యాకోబును నేను చంపేస్తాను” అని తనలో తాను అనుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ఏశావు యాకోబును చంపాలని చేస్తున్న ఆలోచనను గూర్చి రిబ్కా విన్నది. యాకోబును పిలిపించి, అతనితో ఆమె ఇలా చెప్పింది. “ఇది విను, నీ అన్న ఏశావు నిన్ను చంపాలని ప్రయత్నం చేస్తున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","అందుచేత, కుమారుడా, నేను చెప్పినట్టు చేయి. హారానులో నా సోదరుడు లాబాను ఉన్నాడు. అతని దగ్గరకు వెళ్లి దాగుకో. ");
INSERT INTO tel2010_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","కొన్నాళ్లపాటు అతని దగ్గరే ఉండు. నీ అన్న కోపం చల్లారే వరకు అతని దగ్గరే ఉండు. ");
INSERT INTO tel2010_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","కొన్ని రోజులు కాగానే నీవు నీ అన్నకు చేసినది అతడు మరచిపోతాడు. అప్పుడు నిన్ను వెనుకకు తీసుకొని రావటానికి నేను ఒక సేవకుని పంపిస్తాను. నా ఇద్దరు కుమారులను ఒకేనాడు పోగొట్టుకోవటం నాకు ఇష్టం లేదు.” ");
INSERT INTO tel2010_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","అప్పుడు రిబ్కా ఇస్సాకుతో, “నీ కుమారుడైన ఏశావు హిత్తీ స్త్రీలను పెళ్లి చేసుకొన్నాడు. వాళ్లు మన ప్రజలు కారు గనుక వారితో నేను చాలా విసిగిపోయాను. యాకోబు కూడా వాళ్లలో ఒక స్త్రీని పెళ్లి చేసుకొంటే, నేను చావటం మంచిది” అని చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ఇస్సాకు యాకోబును పిలిచి ఆశీర్వదించాడు. తర్వాత ఇస్సాకు అతనికి ఒక ఆజ్ఞ ఇచ్చాడు. ఇస్సాకు ఇలా చెప్పాడు: “కనాను స్త్రీని మాత్రం నీవు వివాహం చేసుకోగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","కనుక ఈ చోటు విడిచి, పద్దనరాము వెళ్లు. నీ తల్లి తండ్రియైన బెతూయేలు ఇంటికి వెళ్లు. నీ తల్లి సోదరుడు లాబాను అక్కడే నివసిస్తున్నాడు. అతని కుమార్తెల్లో ఒకదాన్ని పెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","సర్వశక్తిమంతుడైన దేవుడు నిన్ను ఆశీర్వదించి, అధిక సంతానాన్ని నీకు ప్రసాదించాలని ప్రార్థిస్తున్నా. ఒక గొప్ప జనాంగానికి నీవు పితరుడవు కావాలని నా ప్రార్థన. ");
INSERT INTO tel2010_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","దేవుడు అబ్రాహామును ఆశీర్వదించినట్టే నిన్ను, నీ పిల్లలను ఆశీర్వదించాలని నా ప్రార్థన. నీవు నివసించే దేశం నీ స్వంతం కావాలని నా ప్రార్థన. ఇది దేవుడు అబ్రాహాముకు ఇచ్చిన దేశం.” ");
INSERT INTO tel2010_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ఇస్సాకు యాకోబును పద్దనరాముకు పంపించాడు. రిబ్కా సోదరుడైన లాబాను దగ్గరకు యాకోబు వెళ్లాడు. లాబాను రిబ్కానకు తండ్రి బెతూయేలు. యాకోబు, ఏశావులకు తల్లి రిబ్కా. ");
INSERT INTO tel2010_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","తన తండ్రియైన ఇస్సాకు యాకోబును ఆశీర్వదించాడని ఏశావుకు తెలిసింది. యాకోబు భార్యను సంపాదించు కొనేందుకు ఇస్సాకు అతణ్ణి పద్దనరాముకు పంపినట్టు ఏశావుకు తెలిసింది. యాకోబు కనాను స్త్రీని వివాహము చేసుకోగూడదని ఇస్సాకు ఆజ్ఞాపించినట్టు ఏశావుకు తెలిసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","యాకోబు తన తల్లిదండ్రుల మాటకు విధేయుడై పద్దనరాము వెళ్లినట్టు ఏశావుకు తెలిసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","తన కుమారులు కనానీ స్త్రీలను వివాహం చేసుకోవటం తండ్రికి ఇష్టం లేదని దీనిద్వారా ఏశావుకు తెలిసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","అప్పటికే ఏశావుకు ఇద్దరు భార్యలు ఉన్నారు. అయితే అతడు ఇష్మాయేలు దగ్గరకు వెళ్లి, మరో స్త్రీని పెళ్లి చేసికొన్నాడు. ఇష్మాయేలు కుమార్తె మాహలతును అతను పెళ్లి చేసుకొన్నాడు. ఇష్మాయేలు అబ్రాహాము కుమారుడు. మాహలతు నెబాయోతు సోదరి. ");
INSERT INTO tel2010_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","యాకోబు బెయేర్షెబా విడిచి హారాను వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","యాకోబు ప్రయాణం చేస్తూ ఉండగా సూర్యాస్తమయం అయింది. అందుచేత ఆ రాత్రి ఉండేందుకు యాకోబు ఒక చోటుకి వెళ్లాడు. అక్కడ ఒక బండ కనబడింది. నిద్రపోయేందుకు యాకోబు దానిమీద తలపెట్టి పండుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","యాకోబుకు ఒక కల వచ్చింది. నేలమీద ఒక నిచ్చెన ఉండి, అది ఆకాశాన్ని అంటుకొన్నట్టు అతనికి కల వచ్చింది. దేవుని దూతలు ఆ నిచ్చెన మీద ఎక్కుచు, దిగుచు ఉన్నట్టు యాకోబు చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","అప్పుడు ఆ నిచ్చెన దగ్గర యెహోవా నిలిచినట్టు యాకోబు చూశాడు. యెహోవా చెప్పాడు: “నీ తాత అబ్రాహాము దేవుణ్ణి, యెహోవాను నేను. నేను ఇస్సాకు దేవుణ్ణి ఇప్పుడు నీవు నిద్రపోతున్న ఈ దేశాన్ని నీకు నేనిస్తాను. నీకు, నీ పిల్లలకు ఈ స్థలం నేనిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","నేలమీద ధూళి కణముల్లాగ నీకు గూడా ఎంతోమంది వారసులు ఉంటారు. తూర్పు పడమరలకు, ఉత్తర దక్షిణాలకు వారు విస్తరిస్తారు. నీ మూలంగా, నీ సంతానం మూలంగా భూమిమీదనున్న కుటుంబాలన్నీ ఆశీర్వదించబడతాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","“నేను నీకు తోడుగా ఉన్నాను, నీవు వెళ్లే ప్రతి చోట నేను నిన్ను కాపాడుతాను. మళ్లీ నిన్ను ఈ దేశానికి నేను తీసుకొని వస్తాను. నేను వాగ్ధానం చేసినది నెరవేర్చేవరకు నిన్ను నేను విడువను.” ");
INSERT INTO tel2010_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","అప్పుడు యాకోబు నిద్రనుండి మేల్కొని “యెహోవా ఈ స్థలములో ఉన్నాడని నాకు తెలుసు. అయితే ఆయన ఇక్కడ ఉన్నట్టు, నేను నిద్రపోయేంత వరకు నాకు తెలియదు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","యాకోబు భయపడ్డాడు. “ఇది మహా గొప్ప స్థానం. ఇది దేవుని మందిరం. ఇది పరలోక ద్వారం” అన్నాడు అతను. ");
INSERT INTO tel2010_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ఉదయం పెందలాడే లేచాడు యాకోబు. అతడు పండుకొన్న రాయి తీసుకొని, దానిని అంచుమీద నిలబెట్టాడు యాకోబు. తర్వాత ఆ రాయిమీద అతడు నూనె పోసాడు. ఈ విధంగా అతడు ఆ రాయిని దేవుని జ్ఞాపకార్థ చిహ్నంగా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","ఆ స్థలం పేరు లూజు. అయితే బేతేలు అని దానికి యాకోబు పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","అప్పుడు యాకోబు ఒక ప్రమాణం చేసాడు. “దేవుడు నాకు తోడుగా ఉంటే, నేను ఎక్కడికి వెళ్లినా దేవుడు నన్ను కాపాడుచు ఉంటే, తినుటకు భోజనం, ధరించుటకు బట్టలు దేవుడు నాకు ఇస్తూ ఉంటే, ");
INSERT INTO tel2010_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","నా తండ్రి ఇంటికి నేను సమాధానంగా తిరిగి రాగలిగితే, ఇవన్నీ దేవుడు చేస్తే, అప్పుడు యెహోవాయే నా దేవుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","నేను ఈ రాయిని యిక్కడ నిలబెడతాను. దేవుని కోసం ఇది పరిశుద్ధ స్థలం అని అది తెలియజేస్తుంది. దేవుడు నాకు ఇచ్చే వాటన్నింటిలో పదవ భాగం నేను ఆయనకు ఇస్తాను” అని అతను చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ఇంకా యాకోబు తన ప్రయాణం కొనసాగించాడు. తూర్పు దేశానికి అతడు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","యాకోబు అలా చూడగానే, పొలాల్లో ఒక బావి కనబడింది. గొర్రెల మందలు మూడు ఆ బావి దగ్గర పండుకొని ఉన్నాయి. ఆ గొర్రెలు నీళ్లు తాగే స్థలం ఆ బావి. ఆ బావిమీద ఒక పెద్ద బండ పెట్టి ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","గొర్రెలన్నీ అక్కడికి రాగానే, ఆ గొర్రెల కాపరులు ఆ బావిమీద బండను దొర్లిస్తారు. అప్పుడు గొర్రెలన్నీ ఆ నీళ్లు తాగుతాయి. ఆ గొర్రెలు పూర్తిగా తాగిన తర్వాత గొర్రెల కాపరులు ఆ బండను మళ్లీ దాని స్థానంలో పెట్టేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","“సోదరులారా, ఎక్కడి వాళ్లు మీరు?” అని ఆ గొర్రెల కాపరులను యాకోబు అడిగాడు. “మేము హారాను వాళ్లం” అని వారు జవాబిచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","అందుకు యాకోబు, “నాహోరు కుమారుడు లాబాను తెలుసా మీకు?” అని అడిగాడు. “మాకు తెలుసు” అని గొర్రెల కాపరులు జవాబు ఇచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","అప్పుడు యాకోబు “ఆయన ఎలా ఉన్నాడు?” అని అడిగాడు. “ఆయన బాగానే ఉన్నాడు, అంతా క్షేమమే. అదిగో చూడు, ఆ వస్తున్నది ఆయన కుమార్తె. ఆమె పేరు రాహేలు, ఆయన గొర్రెలు తోలుకొస్తున్నది” అన్నారు వాళ్లు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","“చూడండి, ఇప్పుడు ఇంకా పగలు ఉంది. సూర్యాస్తమయానికి చాలా సమయం ఉంది. రాత్రి కోసం గొర్రెల్ని మందగా చేర్చటానికి ఇంకా వేళ కాలేదు. కనుక వాటికి నీళ్లు పెట్టి, మళ్లీ పొలాల్లోనికి వెళ్లనీయ్యండి” అన్నాడు యాకోబు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","కానీ గొర్రెల కాపరులు, “మందలన్నీ ఇక్కడ గుమిగూడేవరకు మేము అలా చేయటానికి వీల్లేదు. అప్పుడు మేము బావిమీద బండ దొర్లిస్తాము, గొర్రెలు నీళ్లు తాగుతాయి” అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","కాపరులతో యాకోబు మాట్లాడుతుండగానే, రాహేలు తన తండ్రి గొర్రెలతో అక్కడికి వచ్చింది. (ఆ గొర్రెల బాధ్యత రాహేలుది.) ");
INSERT INTO tel2010_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","లాబాను కుమార్తె రాహేలు. యాకోబు తల్లి రిబ్కాకు సోదరుడు లాబాను. రాహేలును చూడగానే యాకోబు వెళ్లి, బండను దొర్లించి గొర్రెలకు నీళ్లు యిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","అప్పుడు యాకోబు రాహేలును ముద్దుపెట్టుకొని ఏడ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","తను ఆమె తండ్రి బంధువు అని యాకోబు రాహేలుతో చెప్పాడు. తను రిబ్కా కుమారుడనని రాహేలుతో చెప్పాడు. కనుక రాహేలు యింటికి పరుగెత్తి, తన తండ్రితో చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","తన సోదరి కుమారుడు యాకోబును గూర్చిన వార్త లాబాను విన్నాడు. అందుచేత అతణ్ణి కలుసుకొనేందుకు లాబాను పరుగెత్తాడు. లాబాను అతడ్ని కౌగిలించుకొని, ముద్దు పెట్టుకొని, తన యింటికి తీసుకొని వచ్చాడు. జరిగినదంతా యాకోబు లాబానుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","అప్పుడు లాబాను, “ఇదంతా భలే బాగుందే, అయితే నీవు నా స్వంత కుటుంబపు వాడివే సుమా” అన్నాడు. అందువల్ల యాకోబు లాబానుతో ఒక నెల అక్కడే నివసించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ఒకనాడు లాబాను, “జీతం లేకుండా నా దగ్గర నీవు ఇలా పనిచేస్తూ ఉండటం సరిగా లేదు. నీవు బంధువుడివి. అంతేగాని బానిసవు కావు. నేను నీకు ఏమి చెల్లించాలి?” అని యాకోబును అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","లాబానుకు యిద్దరు కుమార్తెలుండిరి. పెద్దామె లేయా, చిన్నామె రాహేలు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","రాహేలు అందగత్తె. లేయా కళ్ల సమస్యగలది. ");
INSERT INTO tel2010_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","యాకోబు రాహేలును ప్రేమించాడు. యాకోబు “నన్ను, నీ చిన్న కుమార్తె రాహేలును పెళ్లాడనిస్తే, నేను నీకు ఏడు సంవత్సరాల పాటు పనిచేస్తాను” అని లాబానుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","“మరొకర్ని చేసుకోవడం కంటే ఆమె నిన్ను పెళ్లి చేసుకోవడం మంచిది. కనుక నా దగ్గరే ఉండు” అన్నాడు లాబాను. ");
INSERT INTO tel2010_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","కనుక యాకోబు అక్కడే ఉండి, లాబాను కోసం ఏడు సంవత్సరాలు పని చేసాడు. అయితే అతడు రాహేలును ప్రేమించాడు గనుక అది చాలా కొద్ది కాలంలాగే కనబడింది అతనికి. ");
INSERT INTO tel2010_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ఏడు సంవత్సరాలు అయ్యాక, “రాహేలును నాకు యివ్వండి, పెళ్లి చేసుకొంటాను. నీ దగ్గర నేను చేయాల్సిన కాలం తీరిపోయింది” అని యాకోబు లాబానుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","కనుక ఆ ప్రదేశంలోని ప్రజలందరికి లాబాను విందు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ఆ రాత్రి లాబాను తన కుమార్తె అయిన లేయాను యాకోబు దగ్గరకు తీసుకు వచ్చాడు. యాకోబు లేయాలు లైంగికంగా కలుసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","తన దాసి జిల్ఫాను తన కుమార్తెకు దాసీగా లాబాను ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","తాను సంభోగించినది లేయా అని తెల్లవారినప్పుడు యాకోబు తెలుసుకొన్నాడు. లాబానుతో యాకోబు, “నీవు నన్ను మోసం చేసావు. నేను రాహేలును పెళ్లి చేసుకోవాలని నీ దగ్గర కష్టపడి పని చేసాను. ఎందుకు నన్ను నీవు మోసం చేసావు?” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","లాబాను చెప్పాడు: “పెద్ద కూతురికి పెళ్లికాక ముందు చిన్న కూతురికి పెళ్లి చేయటానికి మా దేశంలో ఒప్పుకోరు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","అయితే పెళ్లి ఆచారంగా వారం రోజులు ముగించు, రాహేలునుకూడ పెళ్లి చేసుకొనేందుకు ఇస్తాను. కానీ నీవు మాత్రం మరో ఏడు సంవత్సరాలు నా దగ్గర పని చేయాలి.” ");
INSERT INTO tel2010_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","కనుక యాకోబు అలాగే వారం ముగించాడు. అప్పుడు లాబాను తన కుమార్తె రాహేలును అతనికి భార్యగా ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","తన దాసీ బిల్హాను తన కుమార్తె రాహేలుకు దాసీగా ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","కనుక యాకోబు రాహేలుతో కూడా సంభోగించాడు. లేయాకంటే రాహేలును యాకోబు ఎక్కువగా ప్రేమించాడు. లాబాను దగ్గర మరో ఏడు సంవత్సరాలు యాకోబు పని చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","లేయాకంటె రాహేలును యాకోబు ఎక్కువగా ప్రేమించడం యెహోవా చూశాడు. అందుచేత లేయాకు పిల్లలు పుట్టేలాగు చేసాడు యెహోవా. రాహేలుకు పిల్లలు లేరు. ");
INSERT INTO tel2010_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","లేయాకు ఒక కొడుకు పుట్టాడు. ఆమె అతనికి రూబేను అని పేరు పెట్టింది. “నా కష్టాలను యెహోవా చూశాడు. నా భర్త నన్ను ప్రేమించటం లేదు. ఒకవేళ నా భర్త ఇప్పుడైనా నన్ను ప్రేమిస్తాడేమో” అని లేయా అతనికి ఈ పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","లేయా మళ్లీ గర్భవతి అయింది, మరో కొడుకు పుట్టాడు. ఈ కుమారునికి షిమ్యోను అని ఆమె పేరు పెట్టింది. “నేను ప్రేమించబడటం లేదని తెలిసి యోహోవా నాకు ఈ కుమారుణ్ణి ఇచ్చాడు” అని చెప్పింది లేయా. ");
INSERT INTO tel2010_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","లేయా మళ్లీ గర్భవతి అయింది, మరో కొడుకు పుట్టాడు. ఆ కుమారునికి ఆమె లేవి అని పేరు పెట్టింది. “ఇప్పుడు నా భర్త నన్ను తప్పకుండా ప్రేమిస్తాడు. అతనికి ముగ్గురు కుమారుల్ని నేను ఇచ్చాను” అనుకొంది లేయా. ");
INSERT INTO tel2010_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","అప్పుడు లేయాకు మరో కొడుకు పుట్టాడు. ఈ కుమారునికి యూదా అని ఆమె పేరు పెట్టింది. “నేను ఇప్పుడు యెహోవాను స్తుతిస్తాను” అని చెప్పి అతనికి ఆ పేరు పెట్టింది లేయా. అంతటితో ఆమెకు సంతాన ప్రాప్తి ఆగిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","తాను యాకోబుకు పిల్లల్ని కనటం లేదని లేయాను రాహేలు తెలుసుకొంది. రాహేలు, తన సోదరి లేయాను గూర్చి అసూయపడింది. అందుచేత “నాకూ పిల్లల్ని యివ్వు, లేకపోతే నేను చస్తాను” అంది యాకోబుతో రాహేలు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","యాకోబుకు రాహేలు మీద కోపం వచ్చింది. “నేనేమి దేవుణ్ణి కాను. నీకు పిల్లలు పుట్టకుండా చేసింది దేవుడు” అని చెప్పాడు యాకోబు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","అప్పుడు రాహేలు “నా దాసిని బిల్హాను నీవు తీసుకో. ఆమెతో శయనించు. నా కోసం ఆమె బిడ్డను కంటుంది. అప్పుడు ఆమె మూలంగా నేను తల్లినవుతాను” అని చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","కనుక రాహేలు తన దాసియైన బిల్హాను యాకోబుకు ఇచ్చింది. యాకోబు బిల్హాతో సంభోగించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","బిల్హా గర్భవతి అయింది, యాకోబుకు ఒక కుమారుని కన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","“దేవుడు నా ప్రార్థన విన్నాడు. నాకు ఒక కుమారుని ఇవ్వాలని ఆయన నిర్ణయం చేసాడు” అని చెప్పి, రాహేలు ఆ కుమారునికి “దాను” అని పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","బిల్హా మరల గర్భవతియై, యాకోబుకు మరో కుమారుని కన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","రాహేలు “నా అక్కతో పోటిలో చాలా కష్టపడి పోరాడాను. నేనే గెలిచాను” అని చెప్పి ఆ కుమారునికి “నఫ్తాలి” అని పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","లేయా తనకు ఇక పిల్లలు పుట్టడం లేదని గ్రహించింది. అంచేత తన దాసి జిల్ఫాను ఆమె యాకోబుకు ఇచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","అప్పుడు జిల్ఫాకు ఒక కొడుకు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","లేయా “నేను అదృష్టవంతురాలిని” అనుకొని, ఆ కుమారునికి “గాదు” అని పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","జిల్ఫాకు మరో కుమారుడు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","“నాకు చాలా సంతోషంగా ఉంది. ఇప్పుడు స్త్రీలు నన్ను సంతోషం అని పిలుస్తారు” అని చెప్పి లేయా ఆ కుమారునికి “ఆషేరు” అని పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","గోధుమ కోతకాలంలో రూబేను పొలాల్లోకి వెళ్లాడు. అక్కడ ప్రత్యేకమైన పూలు అతనికి కనబడ్డాయి. ఆ పూలు తెచ్చి రూబేను తన తల్లి లేయాకు ఇచ్చాడు. అయితే రాహేలు, “నీ కొడుకు తెచ్చిన పూలు దయచేసి నాకూ కొన్ని ఇవ్వవూ” అని లేయాను అడిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","లేయా, “ఇప్పటికే నీవు నా భర్తను తీసివేసుకొన్నవు. ఇప్పుడేమో నా కొడుకు తెచ్చిన పూలను తీసుకోవటానికి ప్రయత్నిస్తున్నావా” అంది. కాని రాహేలు “నీ కొడుకు తెచ్చిన పూలు గనుక నీవు నాకు ఇస్తే, ఈ వేళ రాత్రికి నీవు యాకోబుతో శయనించవచ్చు” అని జవాబిచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ఆ రాత్రి యాకోబు పొలంనుంచి వచ్చాడు. అతన్ని చూచి, అతన్ని కలుసుకోవటానికి లేయా బయటకు వెళ్లింది. “ఈ వేళ రాత్రి నీవు నాతో పండుకోవాలి. నా కొడుకు తెచ్చిన పూలతో నిన్ను నేను కొన్నాను” అని ఆమె చెప్పింది. కనుక ఆ రాత్రి యాకోబు లేయాతో పండుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","అప్పుడు దేవుడు లేయాను మళ్లీ గర్భవతిని కానిచ్చాడు. ఆమె అయిదవ కుమారుని కన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","లేయా అంది, “నా భర్తకు నా దాసిని ఇచ్చాను గనుక దేవుడు నాకు ప్రతిఫలాన్ని యిచ్చాడు.” అందుకని చెప్పి లేయా అతనికి ఇశ్శాఖారు అని పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","లేయా మళ్లీ గర్భవతి అయింది, ఆరో కుమారుణ్ణి కన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","లేయా అంది “ఒక చక్కని బహుమానం దేవుడు నాకు ఇచ్చాడు. ఇప్పుడు తప్పక యాకోబు నన్ను స్వీకరిస్తాడు. ఎందుకంటే ఆయనకు నేను ఆరుగురు కుమారుల్ని యిచ్చాను.” కనుక జెబూలూను అని చెప్పి ఆ కుమారునికి పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","తర్వాత లేయాకు కూతురు పుట్టింది. ఆ కూతురుకు దీనా అని పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","అప్పుడు రాహేలు ప్రార్థన దేవుడు విన్నాడు. రాహేలుకు పిల్లలు పుట్టేట్టుగా దేవుడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","24","రాహేలు గర్భవతి అయింది, ఒక కుమారుణ్ణి కన్నది. “దేవుడు నా అవమానం తొలగించి, నాకూ ఒక కుమారుణ్ణి ఇచ్చాడు” అని చెప్పింది. “దేవుడు నాకు మరో కుమారుణ్ణి అనుగ్రహించు గాక” అంటూ రాహేలు ఆ కుమారునికి యోసేపు అని పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","యోసేపు పుట్టిన తర్వాత లాబానుతో యాకోబు అన్నాడు: “ఇక నా మాతృదేశంలోని నా స్వంత యింటికి నన్ను వెళ్లనివ్వు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","నా భార్యల్ని, పిల్లలను నాకు అప్పగించు. నీ దగ్గర 14 సంవత్సరాలు పనిచేసి నేను వాళ్లను సంపాదించుకొన్నాను. నీ దగ్గర నేను మంచి పని చేసానని నీకు తెలుసు.” ");
INSERT INTO tel2010_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","అతనితో లాబాను అన్నాడు: “నన్ను ఒక్క మాట చెప్పనివ్వు. నీ మూలంగానే యోహోవా నన్ను ఆశీర్వదించాడని నాకు తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","నీకు ఏం చెల్లించమంటావో చెప్పు, అది నీకు నేను చెల్లిస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","యాకోబు జవాబిచ్చాడు: “నీ కోసం నేను కష్టపడి పని చేసానని నీకు తెలుసు. నీ గొర్రెల మందలను నేను కాస్తూ ఉండగా అవి విస్తరించాయి, క్షేమంగా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","నేను వచ్చిన మొదట్లో నీకు ఉన్నది స్వల్పం. ఇప్పుడు నీకు చాలా విస్తారంగా ఉంది. నీ కోసం నేను ఏదైనా చేసినప్పుడల్లా యోహోవా నిన్ను ఆశీర్వదించాడు. ఇప్పుడు ఇక నా కోసం నేను పని చేసుకోవాలి, నా ఇంటిని నేను కట్టుకోవాలి.” ");
INSERT INTO tel2010_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","“అలాగైతే నేను నీక ఏమి ఇవ్వాలి?” అని లాబాను అడిగాడు. యాకోబు ఇలా జవాబిచ్చాడు: “నీవు నాకు ఏమీ యివ్వక్కర్లేదు. నేను చేసిన పనికి తగినట్టుగా నీవు నాకు ఇస్తే చాలు. ఈ ఒక్క పని చేయి. నేను మళ్లీ వెళ్లి నీ గొర్రెలను కాస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","అయితే ఈ వేళ నీ గొర్రెల మందల్లో నన్ను నడువనియ్యి, వాటిలో మచ్చలుగాని చారలుగాని ఉన్న వాటన్నిటిని నన్ను తీసుకోనివ్వు. అలాగే నల్ల మేకపిల్లలు అన్నిటిని నన్ను తీసుకోనివ్వు. చారలు మచ్చలు ఉన్న ప్రతి ఆడ మేకను నన్ను తీసుకోనివ్వు. అదే నాకు జీతం. ");
INSERT INTO tel2010_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","నా నిజాయితీ ఏమిటో భవిష్యత్తులో నీవు తేలిగ్గా తెలుసుకోవచ్చు. నీవు వచ్చి నా మందల్ని చూడవచ్చు. మచ్చలేని మేకగాని, నలుపు లేని గొర్రెగాని నా దగ్గర ఉంటే, దాన్ని నేను దొంగిలించిన్నట్టు నీకు తెలుస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","“అది నాకు సమ్మతమే. నీవు అడిగినట్టు మనం చేద్దాం” అన్నాడు లాబాను. ");
INSERT INTO tel2010_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","అయితే మచ్చలు ఉన్న మేకపోతులన్నింటిని ఆ రోజే లాబాను దాచిపెట్టేసాడు. మచ్చలు ఉన్న ఆడ మేకలన్నింటిని గూడ లాబాను దాచిపెట్టేసాడు. ఈ గొర్రెలను కనిపెట్టి ఉండమని లాబాను తన కుమారులతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","కనుక ఆ కుమారులు మచ్చలుగల గొర్రెలలన్నింటిని మరో చోటుకు తోలుకొని వెళ్లారు. మూడు రోజుల పాటు వారు ప్రయాణం చేసారు. యాకోబు అక్కడ ఉండి, మిగిలిన జంతువులన్నింటి విషయం జాగ్రత్త పుచ్చుకొన్నాడు. అయితే అక్కడ ఉన్నవాటిలో మచ్చలు ఉన్నవి గాని చారలు ఉన్నవి గాని ఏ జంతువు లేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","కనుక బూరగ, బాదాం అను చెట్ల పచ్చటి కొమ్మలు యాకోబు నరికాడు. వాటిలో కొన్ని చువ్వల పైబెరడు యాకోబు తీసివేసినందువల్ల వాటి మీద తెల్ల చారలు కనబడుతున్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","నీళ్లు త్రాగే స్థలాల్లో మందల ముందు యాకోబు ఆ చువ్వలను ఉంచాడు. ఆ జంతువులు నీళ్లు త్రాగటానికి వచ్చినప్పుడు, అక్కడే అవి కలిసేవి. ");
INSERT INTO tel2010_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ఆ చువ్వల ముందర మేకలు చూలు కట్టినప్పుడు, మచ్చలు, చారలు, నలుపుగల పిల్లలు వాటికి పుట్టాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","మచ్చలు, నలుపు ఉన్న జంతువులను మిగతా జంతువులనుండి యాకోబు వేరుచేసాడు. యాకోబు తన జంతువులను లాబాను జంతువులనుండి వేరుగా ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","మందలోని బలమైన జంతువులు ఎదైనప్పుడుల్లా యాకోబు ఆ చువ్వలను వాటి కళ్లముందు ఉంచాడు. ఆ కొమ్మల దగ్గర ఆ జంతువులు చూలు కట్టేవి. ");
INSERT INTO tel2010_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","అయితే ఒక్కటి, బలహీనమైన జంతువులు ఎదైనప్పుడు యాకోబు ఆ కొమ్మలను అక్కడ పెట్టలేదు. కనుక బలహీనమైన జంతువులకు పుట్టిన పిల్లలన్నీ లాబానువే. బలమైన జంతువులకు పుట్టిన పిల్లలన్నీ యాకోబువి. ");
INSERT INTO tel2010_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ఈ విధంగా యాకోబు చాలా ధనికుడయ్యాడు. పెద్ద మందలు, చాలా మంది సేవకులు, ఒంటెలు, గాడిదలు అతనికి ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ఒక రోజున లాబాను కొడుకులు మాట్లాడుకోవడం యాకోబు విన్నాడు. “మన తండ్రికి ఉన్నదంతా యాకోబు తీసివేసుకొన్నాడు. యాకోబు ధనికుడైపోయాడు, ఈ ఐశ్వర్యం అంతా మన తండ్రి దగ్గర నుండి యాకోబు తీసుకున్నాడు.” అని వాళ్లు చెప్పుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","అప్పుడు లాబాను ఇదివరలో ఉన్నంత స్నేహంగా తనతో యిప్పుడు లేనట్టు యాకోబు గమనించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","అప్పుడు యెహోవా “నీ పూర్వీకుల నివాస దేశానికి నీవు తిరిగి వెళ్లిపో. నేను నీకు తోడుగా ఉంటాను” అని యాకోబుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","కనుక యాకోబు తన గొర్రెలు, మేకలు మందలను ఉంచిన పొలాల్లో తనను కలిసికోమని రాహేలు, లేయాలకు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","రాహేలు, లేయాలతో యాకోబు ఇలా చెప్పాడు: “మీ తండ్రి నామీద కోపంగా ఉన్నాడు. ఇది వరకు ఎప్పుడూ అతడు నాతో స్నేహంగా ఉండేవాడు, కాని ఇప్పుడు లేడు. అయితే, నా తండ్రి దేవుడు నాతో వున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","నాకు చేతనైనంత మట్టుకు నేను మీ తండ్రి కోసం కష్టపడ్డానని మీ ఇద్దరికి తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","అయితే మీ తండ్రి నన్ను మోసం చేసాడు. నా జీతం పదిసార్లు మీ తండ్రి మార్చాడు. అయినా ఈ కాలమంతటిలో, లాబాను మోసాలన్నిటి నుండి దేవుడు నన్ను కాపాడాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","“ఒకసారి లాబాను అన్నాడు: ‘మచ్చలు ఉన్న మేకలన్నీ నీవు ఉంచుకోవచ్చు. ఇది నీ జీతం.’ అతడు ఇలా చెప్పిన తర్వాత జంతువులన్నీ మచ్చలు ఉన్న పిల్లలనే కన్నాయి. కనుక అవి అన్నీ నావే. కానీ అప్పుడు లాబాను, ‘మచ్చలు గల మేకలను నేను తీసుకొంటాను, చారలున్న మేకలన్నీ నీవే. అది నీకు జీతం’ అన్నాడు. అతడు యిలా చెప్పిన తర్వాత జంతువులన్నీ చారలు గల పిల్లల్ని పెట్టాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","కనుక జంతువులను దేవుడు మీ తండ్రి దగ్గర్నుండి తీసివేసి వాటిని నాకు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“జంతువులు కలిసే సమయంలో నాకు ఒక కల వచ్చింది. ఎదవుతోన్న మగ మేకలన్నీ మచ్చలు, చారలు గలవేనని నేను చూశాను. ");
INSERT INTO tel2010_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","కలలో ఆ దేవదూత నాతో మాట్లాడాడు. ఆ దేవదూత, ‘యాకోబూ!’ అన్నాడు. “‘చిత్తం’ అన్నాను నేను.” ");
INSERT INTO tel2010_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“ఆ దేవదూత అన్నాడు: ‘చూడు, మచ్చలు, చారలు ఉన్న మేకలు మాత్రమే ఎదవుతున్నాయి. ఇలా జరిగేటట్టు నేను చేస్తున్నాను. లాబాను నీ యెడల చేస్తోన్న అపకారం అంతా నేను చూశాను. కొత్తగా పుట్టిన మేక పిల్లలన్నీ నీకే చెందాలని నేను ఇలా చేస్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","బేతేలులో నీ దగ్గరకు వచ్చిన దేవుణ్ణి నేనే. ఆ స్థలంలో నీవు ఒక బలిపీఠం కట్టావు. ఆ బలిపీఠం మీద ఒలీవ నూనె నీవు పోసావు. అక్కడ నాకు నీవు ఒక వాగ్దానం చేసావు. నీవు తిరిగి నీ పుట్టిన స్థలానికి వెళ్లేందుకు ఇప్పుడు సిద్ధపడు.’” ");
INSERT INTO tel2010_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","15","రాహేలు, లేయాలు యాకోబుతో అన్నారు: “మా తండ్రి చనిపోయినప్పుడు అతను మాకు ఇచ్చేది ఏమీ లేదు. అతను మమ్మల్ని పరాయి వాళ్లుగా చాశాడు. అతను మమ్మల్ని నీకు అమ్మేసాడు, మరియు అప్పుడు మాకు రావలసిన సొమ్ము అంతా వాడేసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","మా తండ్రి దగ్గర్నుండి ఈ ఆస్తి అంతా దేవుడు తీసివేసాడు, ఇప్పుడు అది మనది మన పిల్లలది. కనుక నీవు ఏం చేయాలని దేవుడు నీతో చెప్పాడో అలాగే నీవు చేయాలి!” ");
INSERT INTO tel2010_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","అందుచేత యాకోబు తన ప్రయాణానికి సిద్ధపడ్డాడు. తన కుమారులను, భార్యలను ఒంటెల మీద ఎక్కించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","అప్పుడు వాళ్లు, అతని తండ్రి నివసించిన కనాను దేశానికి తిరిగి ప్రయాణం మొదలుబెట్టారు. యాకోబు సంపాదించిన పశువుల మందలన్నీ వారికి ముందుగా నడిచాయి. అతడు పద్దనరాములో నివసించినప్పుడు సంపాదించుకొన్న సమస్తం అతడు తీసికొని వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ఈ సమయంలో లాబాను తన గొర్రెల బొచ్చు కత్తిరించటానికి వెళ్లాడు. అతడు వెళ్లిపోయాక, రాహేలు అతని ఇంటిలోకి వెళ్లి, తన తండ్రికి చెందిన విగ్రహాల్ని దొంగిలించింది. ");
INSERT INTO tel2010_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","సిరియావాడైన లాబానును యాకోబు మోసం చేసాడు. అతడు వెళ్లిపోతున్నట్టు లాబానుతో చెప్పలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","యాకోబు తన కుటుంబాన్ని, తనకి ఉన్న సమస్తాన్ని తీసుకొని వెంటనే వెళ్లిపోయాడు. వాళ్లు యూఫ్రటీసు నది దాటి గిలాదు కొండవైపు ప్రయాణం అయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","యాకోబు పారిపోయినట్టు మూడు రోజుల తర్వాత లాబానుకు తెలిసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","కనుక లాబాను తన మనుష్యుల్ని సమావేశపరచి, యాకోబును తరమటం మొదలు పెట్టాడు. ఏడు రోజుల తర్వాత గిలాదు పర్వతం దగ్గర లాబాను యాకోబును చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ఆ రాత్రి ఒక దర్శనంలో లాబానుకు దేవుడు ప్రత్యక్షమయ్యి, “నీవు యాకోబుతో చెప్పే ప్రతీ మాట గూర్చి జాగ్రత్త సుమా!” అన్నాడు దేవుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","మర్నాడు ఉదయాన్నే యాకోబును లాబాను పట్టుకొన్నాడు. కొండమీద యాకోబు గుడారం వేసికొన్నాడు. కనుక లాబాను, అతని మనుష్యులంతా గిలాదు కొండమీద గుడారాలు వేసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","యాకోబుతో లాబాను అన్నాడు: “నీవెందుకు నన్ను మోసం చేసావు? యుద్ధంలో చెరపట్టిన స్త్రీలవలె నా కూతుళ్లను ఎందుకు తీసుకు పోతున్నావు? ");
INSERT INTO tel2010_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","నాకు చెప్పకుండా నీవెందుకు పారిపోతున్నావు? నీవు నాతో చెప్పి ఉంటే నీకు నేను విందు చేసేవాణ్ణి. వాయిద్యాలతో సంగీతం, నాట్యం ఉండేవి. ");
INSERT INTO tel2010_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","కనీసం నా మనవళ్లను, మనవరాళ్లను ముద్దు పెట్టుకోనివ్వలేదు, నా కూతుళ్లకు వీడ్కోలు చెప్పనివ్వలేదు. నీవు ఇలా చేయటం చాలా బుద్ధి తక్కువ పని. ");
INSERT INTO tel2010_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","నిజంగా నిన్ను బాధించగల శక్తి నాకు ఉంది. అయితే గత రాత్రి నీ తండ్రి దేవుడు నాకు దర్శనం యిచ్చాడు. ఏ విధంగా కూడ నిన్ను బాధ పెట్టవద్దని ఆయన నన్ను హెచ్చరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","నీవు తిరిగి నీ ఇంటికి వెళ్లిపోవాలన్న ఆశ నీకు ఉన్నట్టు నాకు తెలుసు. అందుకే నీవు బయల్దేరావు. కాని నా యింటి దేవతలను ఎందుకు దొంగిలించావు?” ");
INSERT INTO tel2010_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","యాకోబు ఇలా జవాబిచ్చాడు: “భయం చేత నీకు చెప్పకుండా బయల్దేరాను. నీ కుమార్తెలను నా దగ్గర్నుండి నీవు తీసుకొంటావేమో అనుకొన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","అంతేగాని నీ విగ్రహాలను మాత్రం నేను దొంగిలించలేదు. ఇక్కడ నాతో ఉన్నవాళ్లలో ఎవరి దగ్గరయినా నీ విగ్రహాలు దొరికితే, అలాంటి వ్యక్తి చంపివేయబడుగాక. నీ మనుష్యులే నాకు సాక్షులు. నీకు చెందినది ఏదైనా ఉందేమో నీవు వెదకవచ్చు. ఏదైనా సరే నీదైతే దాన్ని తీసుకో” లాబాను దేవుళ్లను రాహేలు దొంగిలించినట్లు యాకోబుకు తెలియదు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","కనుక లాబాను వెళ్లి యాకోబు గుడారాల్లో వెదికాడు. యాకోబు గుడారంలోను, తర్వాత లేయా గుడారంలోను అతడు వెదికాడు. ఆ తర్వాత బానిస స్త్రీలు ఇద్దరూ ఉంటున్న గుడారంలో అతడు వెదికాడు. కాని అతని నివాసంలో దేవుళ్లు కనబడలేదు. అప్పుడు లాబాను రాహేలు గుడారంలోకి వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","రాహేలు తన ఒంటె సామాగ్రిలో ఆ దేవుళ్లను దాచిపెట్టి, వాటి మీద కూర్చొంది. లాబాను గుడారం అంతా వెదికాడు, కాని ఆ విగ్రహాలు అతనికి దొరకలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","“నాయనా, నా మీద కోపగించకు. నీ యెదుట నేను నిలబడలేక పోతున్నాను. నేను రుతు క్రమంలో ఉన్నాను” అని రాహేలు తన తండ్రితో చెప్పింది. కనుక లాబాను ఆ బస అంతటా వెదికాడు, కాని తన ఇంటి దేవుళ్లు అతనికి కనబడలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","అప్పుడు యాకోబుకు చాలా కోపం వచ్చింది. యాకోబు అన్నాడు: “నేనేం తప్పు చేసాను? ఏ ఆజ్ఞను నేను ఉల్లంఘించాను? నన్ను వెంటాడే హక్కు నీకెక్కడిది? ");
INSERT INTO tel2010_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","నా ఆస్తి అంతా నీవు వెదికావు. నీకు చెందినది ఏమీ నీకు దొరకలేదు. నీకేమైనా దొరికి ఉంటే దాన్ని నాకు చూపించు. మన మనుష్యులకు కనబడేటట్టు దాన్ని ఇక్కడ పెట్టు. మనలో ఎవరిది సరిగా ఉందో మనవాళ్లే నిర్ణయిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","ఇరవై సంవత్సరాలు నీ కోసం నేను పని చేసాను. ఆ కాలమంతటిలో గొర్రెపిల్లగాని, మేకపిల్లగాని ఒక్కటి గూడా పుట్టుకలో చావలేదు. నీ మందలోని పొట్టేళ్లలో ఒక్కటి గూడా నేను తినలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","ఎప్పుడైనా సరే అడవి మృగాలు గొర్రెల్ని చంపితే, ఆ విలువ నేనే చెల్లించాను. చచ్చిన జంతువును ఎప్పుడూ నీకు చూపెట్టి, ఇది నా తప్పు కాదు అని నేను చెప్పలేదు. అయినా సరే రాత్రింబవళ్లు నీ మందల్ని కాపలా కాచాను. ");
INSERT INTO tel2010_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","పగలు ఎండకు నా బలం క్షీణించింది. రాత్రి చలి మూలంగా నా కన్నులకు నిద్ర దూరమయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","20 సంవత్సరాలు ఒక బానిసలా నేను నీకు పని చేసాను. నీ కుమార్తెలను సంపాదించుకోవటానికి మొదట 14 సంవత్సరాలు నేను నీకు పని చేసాను. తర్వాత ఆరు సంవత్సరాలు నీ జంతువుల్ని సంపాదించటంకోసం పని చేసాను. ఆ కాలంలో నా జీతాన్ని నీవు పదిసార్లు మార్చావు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","అయితే నా పూర్వీకుల దేవుడు, అబ్రాహాము దేవుడు, ఇస్సాకు భయపడిన దేవుడు నాకు తోడుగా ఉన్నాడు. దేవుడే గనుక నాకు తోడుగా లేకపోతే, నీను నన్ను వట్టి చేతులతో పంపి ఉండేవాడివి. కాని నా కష్టాలను దేవుడు చూశాడు. నేను చేసిన పనిని దేవుడు చూశాడు. నాదే సరి అని గతరాత్రి దేవుడు రుజువు చేసాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","యాకోబుతో లాబాను చెప్పాడు: “ఈ అమ్మాయిలు నా కుమార్తెలు. వారి పిల్లలు నాకు చెందినవాళ్లు. ఈ జంతువులన్నీ నావే. ఇక్కడ నీకు కనబడుతోన్న సమస్తం నాదే. అయినప్పటికీ నా కుమార్తెలను, వారి పిల్లలను నా దగ్గర ఉంచుకొనేందుకు నేను చేయగలిగింది ఏమీ లేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","కనుక నీతో ఒడంబడిక చేసుకొనేందుకు నేను సిద్ధంగా ఉన్నాను. మనకు ఒడంబడిక ఒకటి కుదిరిందని సూచించేందుకు మనం ఇక్కడ ఒక రాళ్ల కుప్ప వేద్దాం.” ");
INSERT INTO tel2010_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","కనుక యాకోబు ఒక పెద్ద బండను తెచ్చాడు, అతడు ఒక ఒడంబడిక చేసుకొన్నట్టు సూచనగా దాన్ని నిలువబెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","మరికొన్ని రాళ్లు తెచ్చి కుప్పగా వేయుమని అతడు తన సేవకులతో చెప్పాడు. అప్పుడు ఆ రాళ్ల కుప్ప ప్రక్కన వాళ్లు భోజనం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ఆ స్థలానికి యగర్ శాహదూత అని లాబాను పేరు పెట్టాడు. కానీ యాకోబు ఆ స్థలానికి గలేదు అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","“మనం ఇద్దరం మన ఒడంబడికను జ్ఞాపకం చేసుకొనేందుకు ఈ రాళ్ల కుప్ప సహాయపడుతుంది” అన్నాడు లాబాను యాకోబుతో. అందుకే ఆ స్థలానికి గలేదు అని యాకోబు పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","అప్పుడు లాబాను, “మనం ఒకరినుండి ఒకరం విడిపోయేటప్పుడు యోహోవా మనల్ని కాపాడును గాక!” అన్నాడు కనుక ఆ స్థలానికి మిస్పా అని కూడ పేరు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","అప్పుడు లాబాను అన్నాడు, “నా కుమార్తెలను నీవు బాధిస్తే, దేవుడు నిన్ను శిక్షిస్తాడని జ్ఞాపకం ఉంచుకో. నీవు ఇతర స్త్రీలను పెళ్లి చేసుకొంటే దేవుడు నిన్ను చూస్తూనే ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ఇవిగో, ఇవి మన యిద్దరి మధ్య నేను ఉంచిన రాళ్లు. మనమిద్దరం ఒక ఒడంబడిక చేసుకొన్నామని సూచించేందుకు, జ్ఞాపకం ఉంచుకొనేందుకు ఈ రాళ్ల కుప్ప. ఇది ప్రత్యేక బండ. ");
INSERT INTO tel2010_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","మనం మన ఒడంబడికను జ్ఞాపకం ఉంచుకొనేందుకు ఈ రాళ్ల కుప్ప ఈ ప్రత్యేక బండ మనకు తోడ్పడుతాయి. నేనెన్నడూ ఈ రాళ్లు దాటి నీ మీదకు రాను. అలానే నీవు కూడా ఎన్నడూ ఈ రాళ్లు దాటి నామీద పోరాడటానికి రాకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ఈ ఒప్పందాన్ని గనుక మనం మీరితే, అబ్రాహాము దేవుడు, నాహోరు దేవుడు, వారి పూర్వికుల దేవుడు మనలను నేరస్థులుగా తీర్పు చెప్పును గాక.” యాకోబు తండ్రియైన ఇస్సాకు, దేవుణ్ణి “భయంకరుడు” అని పిల్చాడు. కనుక యాకోబు ఆ పేరు మీదనే వాగ్దానం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","అప్పుడు యాకోబు ఒక పశువును వధించి, ఆ కొండమీద దానిని బలిగా అర్పించాడు. భోజనంలో పాలు పుచ్చుకోమని అతడు తన వాళ్లను పిల్చాడు. భోజనం చేసి, ఆ రాత్రికి వారు ఆ కొండమీదనే గడిపారు. ");
INSERT INTO tel2010_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","మర్నాడు ఉదయాన్నే లాబాను తన కుమార్తెలకు, వారి పిల్లలకు వీడ్కోలు ముద్దు పెట్టాడు. అతడు వాళ్లను ఆశీర్వదించి తిరిగి తన యింటికి వెళ్లిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","యాకోబు కూడ అక్కడ నుండి వెళ్లి పోయాడు. అతడు ప్రయాణం చేస్తుండగా దేవుని దూతలను చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","యాకోబు వారిని చూసినప్పుడు, “ఇది దేవుని శిబిరం” అన్నాడు. కనుక ఆ స్థలానికి “మహనయీము” అని యాకోబు పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","యాకోబు అన్న ఏశావు శేయెరు అనే ప్రాంతంలో నివసిస్తున్నాడు. ఇది ఏదోం పర్వత ప్రాంతం. యాకోబు ఏశావుకు వార్తాహరులను పంపాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","“ఏశావుకు ఇలా చెప్పండి అని వార్తాహరులతో చెప్పాడు యాకోబు: ‘మీ సేవకుడైన యాకోబు, నా యజమాని ఏశావుకు చెప్పేదేమిటంటే, ఇన్ని సంవత్సరాలు నేను లాబానుతో నివసించాను. ");
INSERT INTO tel2010_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","పశువులు, గాడిదలు, మందలు, అనేక మంది సేవకులు, దాసీలు నాకు ఉన్నారు. అవన్నీ నేను నీకు పంపిస్తున్నాను. నీవు మమ్మల్ని చేర్చుకోవాలని మనవి.’” ");
INSERT INTO tel2010_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","వార్తాహరులు తిరిగి వచ్చి, “నీ అన్న ఏశావును కలుసుకొనేందుకు మేము వెళ్లాం. నిన్ను కలుసుకొనేందుకు అతడు వస్తున్నాడు. అతనితో 400 మంది మనుష్యులు ఉన్నారు” అని యాకోబుతో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ఆ వార్త యాకోబుకు భయం కలిగించింది. తనతో ఉన్న మనుష్యులందరినీ అతడు రెండు గుంపులుగా విభజించాడు. మందలను, పశువులను, ఒంటెలను రెండు గుంపులుగా విభజించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","“ఏశావు వచ్చి ఒక గుంపును హతమార్చినా, మరో గుంపు పారిపోయి తప్పించుకోవచ్చు” అనుకున్నాడు యాకోబు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","యాకోబు ఇలా అన్నాడు “నా తండ్రి అబ్రాహాము దేవా! నా తండ్రి ఇస్సాకు దేవా! ఓ యెహోవా, నన్ను మళ్లీ నా కుటుంబం దగ్గరకు, నా స్వదేశానికి నీవే వచ్చేయమన్నావు. నీకు నాకు మేలు చేస్తానన్నావు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","నా యెడల నీవు ఎంతో దయ చూపించావు. నాకు ఎన్నో మేళ్లు చేసావు. మొదటిసారి నేను యోర్దాను దాటినప్పుడు, నా చేతి కర్ర తప్ప యింకేమీ నా స్వంతం లేదు. ఇప్పుడు రెండు గుంపులకు సరిపడినంత నాకు ఉన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","దయచేసి నా అన్న ఏశావు నుంచి నన్ను కాపాడు. నాకు అతడంటే భయంగా ఉంది. అతడు వచ్చి మమ్మల్ని అందరిని, చివరికి తల్లులను పిల్లలను కూడ చంపేస్తాడని భయంగా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","నేను నీతో మంచిగా ఉంటాను. నేను నీ కుటుంబాన్ని వర్ధిల్లచేసి, నీ పిల్లల్ని ఇసుక రేణువులంత విస్తారంగా చేస్తాను. లెక్కింప జాలనంత విస్తారంగా వారుంటారు” అని నీవు నాతో అన్నావు గదా ప్రభూ. ");
INSERT INTO tel2010_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","యాకోబు ఆ రాత్రి అక్కడే ఉండిపోయాడు. ఏశావుకు కానుకలుగా ఇచ్చేందుకు కొన్ని వస్తువులను యాకోబు సిద్ధం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","యాకోబు 200 ఆడ మేకలను, 20 మేకపోతులను, 200 ఆడ గొర్రెలను, 20 పొట్టేళ్లను తీసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 ఒంటెలను, వాటి పిల్లలను, 40 ఆవులను, 10 ఎద్దులను, 20 ఆడ గాడిదలను, 10 మగ గాడిదలు యాకోబు తీసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","“ఒక్కొక్క రకం జంతువుల మందను యాకోబు తన సేవకులకు అప్పగించాడు. అప్పుడు యాకోబు తన సేవకులతో ఒక్కో రకం జంతువుల మందను వేరు చేయండి నాకు ముందుగా నడుస్తూ, ఒక్కో మందకు మధ్య ఎడం ఉంచండి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","యాకోబు వారికి ఇవ్వవలసిన ఆజ్ఞలన్నీ ఇచ్చాడు. మొదటి మంద వెంబడి ఉన్న సేవకులతో యాకోబు “నా అన్న ఏశావు నీ దగ్గరకు వచ్చి, ‘ఇవి ఎవరి జంతువులు? నీవు ఎక్కడికి వెళ్తున్నావు? నీవు ఎవరి సేవకుడువి?’ అని అడిగితే, ");
INSERT INTO tel2010_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","‘ఇవి నీ సేవకుడైన యాకోబు మందలు. నా యజమాని ఏశావుకు కానుకగా యాకోబు వీటిని పంపించాడు. యాకోబు కూడా మా వెనుక వస్తున్నాడు’ అని నీవు చె ప్పాలి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","అందరూ అలాగే చేయాలి అని రెండవ సేవకునికి, మూడవ సేవకునికి, మిగిలిన సేవకులందరికి యాకోబు ఆజ్ఞాపించాడు. “ఏశావును మీరు కలుసుకొన్నప్పుడు, ఏశావుకు మీరు ఇలానే చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‘ఇది నీ కోసం కానుక, నీ సేవకుడైన యాకోబు వెనుక ఉన్నాడు’” అని మీరు చె ప్పాలి అన్నాడు యాకోబు. “ఈ కానుకలు ఇచ్చి వీళ్లను ముందు పంపిస్తే ఒకవేళ ఏశావు నన్ను క్షమించి చేర్చుకొంటాడేమో” అనుకొన్నాడు యాకోబు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","కనుక యాకోబు ఏశావుకు కానుకలు పంపించాడు. అయితే యాకోబు మాత్రం ఆ రాత్రి శిబిరంలోనే వుండిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ఆ రాత్రి చాలా గడిచిన తర్వాత యాకోబు లేచి బయల్దేరాడు. అతని భార్యలను, ఇద్దరు దాసీలను, తన పదకొండుమంది పిల్లలను అతడు తనతో కూడ వెంటబెట్టుకొని బయల్దేరాడు. యబ్బోకు నదిని దాటవలసిన చోట యాకోబు దాటాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","తన కుటుంబాన్ని నది దాటించాడు యాకోబు. తర్వాత యాకోబు తనకి కలిగిన దాన్ని అంతటినీ నది దాటించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","అందరికంటే చివర యాకోబు నదిని దాటాడు. అయితే అతడు దాటక ముందు, అతడు ఇంకా ఒంటరిగా ఉండగానే, ఒక మనిషి వచ్చి అతనితో పోరాడాడు. సూర్యుడు ఉదయించే వరకు ఆ మనిషి అతనితో పోరాడాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ఆ మనిషి యాకోబును ఓడించలేనట్టు గ్రహించాడు. అందుచేత అతడు యాకోబు కాలును తాకాడు. అప్పుడే యాకోబు కాలి కీలు జారిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","అప్పుడు ఆ మనిషి, “నన్ను వెళ్లనివ్వు, సూర్యుడు వచ్చేస్తున్నాడు” అని యాకోబుతో అన్నాడు. కాని యాకోబు, “నేను నిన్ను వెళ్లనియ్యను. నీవు నన్ను ఆశీర్వదించాల్సిందే” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","“నీ పేరేమిటి?” ఆ మనిషి అడిగాడు. “నా పేరు యాకోబు” అన్నాడు యాకోబు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","అప్పుడు, “నీ పేరు ఇకమీదట యాకోబు కాదు. ఇప్పుడు నీ పేరు ఇశ్రాయేలు. దేవునితోను, మనుష్యులతోను నీవు పోరాడి, ఓడిపోలేదు గనుక నీకు నేను ఈ పేరు పెడుతున్నాను” అన్నాడు ఆ మనిషి. ");
INSERT INTO tel2010_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","అప్పుడు యాకోబు, “దయచేసి నీ పేరు ఏమిటో చెప్పు” అని అడిగాడు. అయితే ఆ మనిషి “నీవు నా పేరెందుకు అడగాలి?” అన్నాడు. అప్పుడే యాకోబును అతడు ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","అందుచేత ఆ స్థలానికి పెనూయేలు అని యాకోబు పేరు పెట్టాడు. “ఇక్కడ దేవుణ్ణి నేను ముఖాముఖిగా చూసాను. అయినప్పుటికి నా ప్రాణం దక్కింది” అన్నాడు యాకోబు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","అతడు పెనూయేలు దాటుతుండగా సూర్యుడు ఉదయించాడు. యాకోబు కాలికి అలా జరిగినందువల్ల అతడు కుంటుతున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","అందుచేత తొడ గూటి మీద ఉన్న కండరమును ఇశ్రాయేలీయులు ఈ రోజువరకు తినరు, ఎందుకంటే అక్కడే యాకోబుకు దెబ్బ తగిలింది. ");
INSERT INTO tel2010_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","యాకోబు చూడగా ఏశావు రావడం కనబడింది. ఏశావు, అతనితో 400 మంది మనుష్యులు వస్తున్నారు. యాకోబు తన కుటుంబాన్ని నాలుగు గుంపులుగా చేసాడు. లేయా, ఆమె పిల్లలు ఒక గుంపులో ఉన్నారు, రాహేలు, యోసేపు ఒక గుంపులో ఉన్నారు, ఇద్దరు దాసీలు, వారి పిల్లలు మరి రెండు గుంపుల్లో ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","దాసీలను వారి పిల్లలను యాకోబు ముందు ఉంచాడు. తర్వాత యాకోబు లేయాను ఆమె పిల్లలను ఉంచాడు. ఆ తర్వాత, చివరగా రాహేలును, యోసేపును ఉంచాడు యాకోబు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","యాకోబు తానే ఏశావు వస్తున్న వైపు ముందుగా వెళ్లాడు. కనుక ఏశావు దగ్గరకు వచ్చిన మొదటివాడు అతడే. యాకోబు తన అన్న దగ్గరకు నడుస్తూ ఏడు సార్లు నేలమీద సాగిలపడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","యాకోబును చూడగానే అతణ్ణి కలుసుకొనేందుకు ఏశావు పరుగెత్తాడు. ఏశావు అతణ్ణి కౌగిలించుకొని హత్తుకొన్నాడు. ఏశావు అతని మెడమీద ముద్దు పెట్టుకొని, వారిద్దరు సంతోషముతో ఏడ్చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ఏశావు చూడగా స్త్రీలు పిల్లలు అతనికి కనబడ్డారు. “నీతో ఉన్న వీళ్లంతా ఎవరు?” అని అతడు అడిగాడు. “దేవుడు నాకు ఇచ్చిన పిల్లలు వీళ్లంతాను. దేవుడు నాకు మేలు చేసాడు” అంటూ జవాబు చెప్పాడు యాకోబు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","తర్వాత ఇద్దరు దాసీలు, వారితో ఉన్న పిల్లలు ఏశావు దగ్గరకు వెళ్లారు. వాళ్లంతా అతని ముందు సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","తర్వాత లేయా, ఆమెతో ఉన్న పిల్లలు ఏశావు దగ్గరకు వెళ్లి సాష్టాంగపడ్డారు. తరువాత, రాహేలు, యోసేపు ఏశావు దగ్గరకు వెళ్లి సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","“నేను ఇక్కడికి వస్తున్నప్పుడు నాకు కనబడిన ప్రజలంతా ఎవరు? పైగా ఆ జంతువులన్నీ దేని కోసం?” అని ఏశావు అడిగాడు. దానికి యాకోబు “నీవు నన్ను స్వీకరించాలని చెప్పి అవన్నీ నీకు నా కానుకలు” అని జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","కాని ఏశావు, “సోదరా, నాకు నీవు కానుకలు ఇవ్వాల్సిన పని లేదు. నాకు కావాల్సినంత ఉన్నది” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","యాకోబు అన్నాడు: “అలా కాదు, నేను నిన్ను బతిమలాడుకొంటున్నాను. నీవు నిజంగా నన్ను అంగీకరిస్తుంటే, నీవు నా కానుకలు గూడా అంగికరించాలి. మరలా నేను నీ ముఖం చూడటం నాకెంతో సంతోషంగా ఉంది. దేవుని ముఖము చూసినట్టు ఉంది. నీవు నన్ను అంగీకరించటం చూస్తే నాకు ఎంతో సంతోషంగా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","అందుచేత నేను నీకు ఇస్తున్న కానుకలను గూడ స్వీకరించుమని ప్రార్థిస్తున్నా. దేవుడు నాకు ఎంతో మేలు చేసాడు. నాకు కావల్సిన దానికంటే ఎక్కువగా ఉంది.” ఈ విధంగా తన కానుకల్ని తీసుకోమని చెప్పి యాకోబు ఏశావును బతిమలాడాడు. కనుక ఏశావు ఆ కానుకలను స్వీకరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","అప్పుడు ఏశావు, “ఇంక నీవు ప్రయాణం కొనసాగించు. నేను కూడ నీతో వస్తాను” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","కాని యాకోబు అతనితో ఇలా చెప్పాడు: “నా పిల్లలు బలహీనులని నీకు తెలుసు. పైగా నా మందలు, వాటి పిల్లలను గూర్చిన జాగ్రత్త నేను తీసుకోవాలి. ఒక్క రోజునే నేను వాటిని చాలా దూరం నడిపిస్తే అవి చస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","అందుచేత నీవు ముందు వెళ్లిపో. నేను మెల్లగా నీ వెనుక వస్తా. పశువులు, మిగిలిన జంతువులు క్షేమంగా ఉండగలిగినంత నిదానంగా నేను నడుస్తాను. మరియు నా పిల్లలు కూడ మరీ అలసిపోకుండా నేను మెల్లగా వస్తాను. శేయీరులో నేను నిన్ను కలుసుకొంటాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ఏశావు, “అలాగైతే నీకు సహాయంగా నా మనుష్యులను కొందర్ని నీతో ఉంచుతాను” అన్నాడు. కానీ యాకోబు, “అదంతా నీ దయ. కాని అలా చేయాల్సిన అవసరం ఏమీ లేదు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","కనుక ఆ రోజు ఏశావు శేయీరుకు తిరుగు ప్రయాణం కట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","అయితే యాకోబు సుక్కోతు వెళ్లాడు. అక్కడ తనకోసం ఒక యిల్లు, తన పశువుల కోసం కొట్టములు కట్టాడు. అందుకే ఆ చోటుకు సుక్కోతు అని పేరు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ఆ తర్వాత, యాకోబు పద్దనరాము నుండి కనానులో ఉన్న షెకెము పట్టణం వరకు తన ప్రయాణాన్ని క్షేమంగా ముగించాడు. ఆ పట్టణానికి సమీపంగా ఒక పొలంలో యాకోబు తన నివాసం ఏర్పాటు చేసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","షెకెము తండ్రియైన హమోరు కుటుంబం దగ్గర యాకోబు ఆ పొలాన్ని కొన్నాడు. యాకోబు నూరు వెండి నాణ్యాలు చెల్లించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","దేవుణ్ణి ఆరాధించటానికి యాకోబు అక్కడ ఒక బలిపీఠం కట్టాడు. ఆ స్థలానికి “ఏల్, ఇశ్రాయేలీయుల దేవుడు” అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","యాకోబు లేయాల కుమార్తె దీనా. ఒక రోజు, ఆ ఊరి స్త్రీలను చూడాలని దీనా బయటకు వెళ్లింది. ");
INSERT INTO tel2010_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ఆ దేశం రాజైన హమోరు కుమారుడు షెకెము దీనాను చూసాడు. అతడు ఆమెను బంధించి, బలవంతంగా ఆమెతో సంభోగించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","షెకెము దీనాను ప్రేమించాడు. ఆమె తనను పెళ్లి చేసుకునేలా ఒప్పించేందుకు ఆమెతో మాట్లాడాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","“నేను పెళ్లి చేసుకోవటానికి దయచేసి ఈ అమ్మాయినే తెచ్చి పెట్టమని” షెకెము తన తండ్రితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ఆ యువకుడు తన కూతురికి చేసిన దుష్కార్యాన్ని గూర్తి యాకోబు విన్నాడు. అయితే యాకోబు కుమారులంతా పశువులతోబాటు పొలాల్లో ఉన్నారు. అందుచేత వాళ్లు ఇంటికి తిరిగి వచ్చేంత వరకు యాకోబు ఏమీ చేయలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","అదే సమయంలో షెకెము తండ్రి హమోరు యాకోబుతో మాట్లాడేందుకు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","జరిగిన దాన్ని గూర్చి యాకోబు కుమారులకు పొలంలోనే తెలిసింది. ఇది విని వాళ్లకు చాలా కోపం వచ్చింది. యాకోబు కూతురుతో శయనించి, షెకెము ఇశ్రాయేలీయుల వంశానికి అవమానం తెచ్చాడు గనుక వారికి పిచ్చి కోపం రెచ్చిపోయింది. షెకెము చాలా చెడ్డపని చేసాడు కనుక ఆ సోదరులంతా పొలాలనుండి వచ్చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","అయితే హమోరు ఆ సోదరులతో మాట్లాడాడు. “నా కుమారుడు షెకెముకు దీనా కావాలని ఉంది. దయచేసి వాడిని ఆమెను పెళ్లి చేసుకోనివ్వండి. ");
INSERT INTO tel2010_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","మనకు ఒక ప్రత్యేక ఒడంబడిక ఉన్నట్టు ఈ వివాహం వ్యక్తం చేస్తుంది. అప్పుడు మా మగవాళ్లు మీ అమ్మాయిలను, మీ మగవాళ్లు మా అమ్మాయిలను పెళ్లి చేసుకోవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ఈ దేశంలోనే మీరు కూడ మాతో కలసి ఉండవచ్చును. భూమిని స్వంతం చేసుకొనేందుకు, వ్యాపారం చేసేందుకు ఇక్కడ మీకు స్వేచ్ఛ ఉంటుంది” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","షెకెము కూడ యాకోబుతో, అన్నదమ్ములతో మాట్లాడాడు. షెకెము అన్నాడు: “దయచేసి నన్ను స్వీకరించండి, నేను చేసిన దాని విషయంలో నన్ను క్షమించండి. మీరు నన్నేమి చేయమంటే అది చేస్తా. ");
INSERT INTO tel2010_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","మీరు నన్ను దీనాను పెళ్లి చేసుకోనిస్తే, మీరు కోరిన కన్యాశుల్కం మీకు ఇస్తా. మీరు ఏమి అడిగితే అది ఇస్తా కాని దీనాను నన్ను పెళ్లాడనివ్వండి.” ");
INSERT INTO tel2010_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","షెకెముతో, అతని తండ్రితో అబద్ధం చె ప్పాలని యాకోబు కుమారులు నిశ్చయించుకున్నారు. వారి సోదరి షెకెము చేసిన నీచకార్యాన్ని బట్టి ఆ సోదరులు ఇంకా కోపంగానే ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","కనుక ఆ సోదరులు, “నీకు ఇంకా సున్నతి కాలేదు గనుక నిన్ను మా సోదరిని పెళ్లి చేసుకోనివ్వం. మా సోదరి నిన్ను చేసుకోవడం తప్పు అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","అయితే నీవు ఈ ఒక్క పని చేస్తే నిన్ను ఆమెను పెళ్లి చేసుకోనిస్తాం. మీ పట్టణంలో ప్రతి పురుషుడూ మాలాగే సున్నతి చేసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","అప్పుడు మీ పురుషులు మా స్త్రీలను, మా పురుషులు మీ స్త్రీలను పెళ్లి చేసుకోవచ్చు. అప్పుడు మనమంతా ఒక్క ప్రజ అవుతాం ");
INSERT INTO tel2010_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","సున్నతికి మీరు నిరాకరిస్తే, దీనాను మేము తీసివేసుకొంటాం” అని అతనితో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ఈ ఒడంబడిక హమోరుకు, షెకెముకు చాలా సంతోషం కలిగించింది. ");
INSERT INTO tel2010_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","దీనా సోదరులు అడిగినట్టు చేయాలంటే షెకెముకు చాలా సంతోషంగా ఉంది. షెకెము, అతని కుటుంబంలోకెల్లా చాలా గౌరవం గలవాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","హమోరు, షెకెము వారి పట్టణంలో సమావేశ స్థలానికి వెళ్లారు. ఆ పట్టణంలోని పురుషులతో వారు మాట్లాడి, అన్నారు: ");
INSERT INTO tel2010_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ఈ ఇశ్రాయేలీయులు మనతో నిజంగా స్నేహంగా ఉండాలని కోరుతున్నారు. వాళ్లను మన దేశంలోనే నివసించి వ్యాపారం చేసుకోనిద్దాం. మనందరికి సరిపోయేంత భూమి మనకు ఉంది. మనం వాళ్ల స్త్రీలను స్వేచ్ఛగా వివాహం చేసుకోవచ్చు. అలానే వారి పురుషులు వివాహం చేసుకొనేందుకు మన స్త్రీలను సంతోషంగా మనం ఇవ్వవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","అయితే మన పురుషులంతా ఒక పని చేయడానికి ఒప్పకోవాలి. ఇశ్రాయేలు ప్రజల్లాగే మన మగవాళ్లంతా సున్నతి చేసుకొనేందుకు సమ్మతించాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","మనం ఇలా చేస్తే, వాళ్ల ఆల మందలు, జంతువులు, వస్తుజాలం అన్నీ మనకి దక్కి, మనం ధనికులం అవుతాం. కనుక మనం వాళ్లతో ఈ ఒడంబడిక చేయాల్సిందే, వాళ్లు మనతోనే ఉంటారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","సమావేశ స్థలంలో ఈ మాటను విన్న మగవాళ్లంతా షెకెము, హమోరులతో ఏకీభవించారు. ఆ సమయంలో ప్రతి పురుషునికి సున్నతి జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","మూడు రోజుల తర్వాత, సున్నతి పొందిన మగవాళ్లు ఇంకా బాధపడుతూనే ఉన్నారు. ఈ సమయంలో ఆ మనుష్యులు బలహీనంగా ఉంటారని యాకోబు ఇద్దరు కుమారులు షిమ్యోను, లేవీలకు తెలుసు. కనుక వారు పట్టణంలోకి వెళ్లి, ఆ పురుషులందర్నీ అక్కడే చంపేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","దీనా సోదరులు షిమ్యోను, లేవీ కలిసి హమోరును, అతని కుమారుని చంపేసారు. అంతట వారు షెకెము యింటినుండి దీనాను తీసుకొని వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","యాకోబు మిగిలిన కుమారులు ఆ పట్టణంలోకి వెళ్లి, అక్కడ ఉన్న సమస్తం దోచుకొన్నారు. వారి సోదరికి, షెకెము చేసిన దాని విషయంలో వారు ఇంకా కోపంగా ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","కనుక వారి జంతువులన్నింటినీ ఆ సోదరులు తీసుకుపోయారు. వారి గాడిదలను, పట్టణంలో, పొలాల్లో మిగిలినదంతా వారు దోచుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ప్రజలకు ఉన్నదంతా ఆ సోదరులు దోచుకుపోయారు. చివరికి వారి భార్యలను, పిల్లలను కూడా ఆ సోదరులు తీసుకొని వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","అయితే షిమ్యోనుతోనూ, లేవీతోనూ యాకోబు అన్నాడు, “మీరు నాకు చాలా కష్టం తెచ్చి పెట్టారు. ఈ దేశంలో ఉన్న ప్రజలంతా నన్ను అసహ్వించుకొంటారు. కనానీ ప్రజలు, పెరిజ్జీ ప్రజలు అంతానాకు వ్యతిరేకంగా లేస్తారు. మనమేమో చాలా కొద్దిమందిమే ఉన్నాం. ఈ దేశంలో ఉన్నవాళ్లంతా ఏకమై మనమీద యుద్ధానికి వస్తే, నన్ను నాశనం చేస్తారు. నాతోబాటే మన ప్రజలందర్నీ నాశనం చేస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","అయితే ఆ సోదరులు, “ఈ ప్రజలు మా సోదరిని ఒక వేశ్యలా చేస్తే, చూస్తూ ఊరుకోమంటావా? లేదు, మా సోదరికి అలా చేయటం వారిది తప్పు” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","“బేతేలు పట్టణం వెళ్లు. అక్కడ నివసించి, ఆరాధనకు బలిపీఠం నిర్మించు. నీవు నీ అన్న ఏశావు దగ్గర్నుండి పారిపోతున్నప్పుడు నీకు అక్కడ ప్రత్యక్షమైన ఏల్ దేవుణ్ణి జ్ఞాపకం చేసుకో. అక్కడ ఆ దేవుణ్ణి ఆరాధించటానికి ఒక బలిపీఠం తయారు చేసుకో” అని దేవుడు యాకోబుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","కనుక యాకోబు తన కుటుంబం అంతటితో, సేవకులందరితో ఇలా చెప్పాడు: “మీ దగ్గర ఉన్న చెక్క, లోహములతో చేయబడిన ఆ తప్పుడు దేవతలన్నిటిని నాశనం చేయండి. మిమ్మల్ని మీరు శుద్ధి చేసుకోండి. శుభ్రమైన వస్త్రాలను ధరించండి. ");
INSERT INTO tel2010_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","మనం యిక్కడ్నుండి బేతేలుకు వెళ్లిపోవాలి. ఆ స్థలంలో నాకు కష్టం కలిగినప్పుడు సహాయం చేసినటువంటి దేవునికి బలిపీఠం కట్టాను. ఆ దేవుడే నేను వెళ్లిన ప్రతి చోటా నాతో ఉన్నాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","కనుక ప్రజలు వారి దగ్గర ఉన్న అసత్య దేవతలన్నిటిని యాకోబుకు ఇచ్చివేసారు. వారంతా వారి చెవులకు ధరించిన నగలను యాకోబుకు ఇచ్చివేసారు. షెకెము దగ్గర ఉన్న సింధూర వృక్షం కింద యాకోబు వీటన్నిటిని పాతి పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","యాకోబు, అతని కుమారులు ఆ స్థలం విడిచి వెళ్లిపోయారు. ఆ ఊరి ప్రజలు వీరిని వెంబడించి, చంపాలనుకొన్నారు. అయినా వారు చాలా భయపడి, యాకోబును వెంబడించలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","కనుక యాకోబు, అతని వాళ్లంతా లూజు వెళ్లారు. లూజు ఇప్పుడు బేతేలు అని పిలువబడుతోంది. అది కనాను దేశంలో ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","అక్కడ యాకోబు ఒక బలిపీఠం కట్టాడు. ఆ స్థలానికి ఏల్ బేతేలు అని యాకోబు పేరు పెట్టాడు. అతడు తన సోదరుని నుండి పారిపోతున్నప్పుడు మొట్టమొదటి సారిగా అక్కడే దేవుడు అతనికి ప్రత్యక్షమైన కారణంగా యాకోబు ఈ పేరును నిర్ణయించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","రిబ్కా దాది దెబోరా అక్కడే చనిపోయింది. బేతేలులో సింధూర వృక్షం కింద ఆమెను వారు పాతిపెట్టారు. ఆ స్థలానికి అల్లోను బాకూతో అని వారు పేరు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","పద్దనరాము నుండి యాకోబు తిరిగి వస్తుండగా, దేవుడు మరల అతనికి ప్రత్యక్షమయ్యి, యాకోబును ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","“నీ పేరు యాకోబు. కాని, ఆ పేరును నేను మార్చేస్తాను. ఇప్పుడు నీవు యాకోబు అని పిలువబడవు. ‘నీ కొత్త పేరు ఇశ్రాయేలు’ అని ఉంటుంది” కాబట్టి దేవుడు అతనికి ఇశ్రాయేలు అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","అతనితో దేవుడన్నాడు: నేను సర్వశక్తిమంతుడనైన దేవుణ్ణి. కనుక నీకు ఈ ఆశీర్వాదం ఇస్తున్నాను: నీకు చాలా సంతోషం కలిగి, ఒక గొప్ప జనాంగంగా పెరుగుదువు! మరిన్ని జనాంగాలు, మరికొందరు రాజులు నీలో నుండి ఉద్భవిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","అబ్రాహాము, ఇస్సాకులకు ఒక ప్రత్యేక దేశం నేనిచ్చాను. ఇప్పుడు ఆ దేశాన్ని నేను నీకు ఇస్తున్నాను. పైగా నీ తర్వాత జీవించే నీ ప్రజలందరికీ ఆ దేశాన్ని నేను ఇస్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","అంతలో దేవుడు అక్కడ్నుండి వెళ్లిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","ఈ స్థలంలో ఒక స్మారక శిల యాకోబు నిలబెట్టాడు. ద్రాక్షారసం, తైలం పోసి ఆ బండను పవిత్రం చేసాడు యాకోబు. ఆ స్థలంలో దేవుడు యాకోబుతో మాట్లాడాడు గనుక ఇది ఒక ప్రత్యేక స్థలం. యాకోబు ఆ స్థలానికి బేతేలు అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","యాకోబు, అతని వాళ్లు బేతేలు నుండి ప్రయాణమయ్యారు. ఇంక వారు ఎఫ్రాతా (బెత్లెహేం) చేరుతారనగా, రాహేలుకు ప్రసవ వేదన ప్రారంభమయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","అయితే ఈ కాన్పులో రాహేలు చాలా కష్టపడుతోంది. ఆమె విపరీతంగా బాధపడుతోంది. రాహేలు పనిమనిషి ఇది చూసి, “రాహేలూ భయపడకు. నీవు మరో కుమారుణ్ణి కంటున్నావు” అని చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","కుమారుని కంటూనే రాహేలు చనిపోయింది. చనిపోక ముందు ఆ పిల్లవాడికి బెనోని అని ఆమె పేరు పెట్టింది. అయితే యాకోబు అతనికి బెన్యామీను అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","ఎఫ్రాతా మార్గంలో రాహేలు సమాధి చేయబడింది (ఎఫ్రాతా అంటే బెత్లేహేం). ");
INSERT INTO tel2010_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","రాహేలు గౌరవార్థం, ఆమె సమాధి మీద యాకోబు ఒక ప్రత్యేక బండను ఉంచాడు. ఆ ప్రత్యేక బండ నేటికీ అక్కడ ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","అప్పుడు ఇశ్రాయేలు (యాకోబు) తన ప్రయాణం కొనసాగించాడు. ఏదెరు శిఖరానికి కొద్దిగా దక్షిణంగా అతడు శిబిరం వేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ఇశ్రాయేలు అక్కడ కొన్నాళ్లపాటు ఉండిపోయాడు. అతడు అక్కడ ఉంటున్నప్పుడు ఇశ్రాయేలు దాసి బిల్హాతో రూబేను శయనించాడు. ఇశ్రాయేలు ఇది విని చాలా కోపగించుకొన్నాడు. యాకోబుకు (ఇశ్రాయేలు) 12 మంది కుమారులు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","అతని భార్య లేయా మూలంగా అతనికి ఆరుగురు కుమారులు ఉన్నారు. రూబేను, షిమ్యోను, లేవి, యూదా, ఇశ్శాఖారు, జెబూలును. ");
INSERT INTO tel2010_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","అతని భార్య రాహేలు మూలంగా అతనికి ఇద్దరు కుమారులున్నారు. యోసేపు, బెన్యామీను. ");
INSERT INTO tel2010_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","రాహేలు పనిమనిషి బిల్హా మూలంగా అతనికి ఇద్దరు కుమారులు ఉన్నారు. దాను, నఫ్తాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","లేయా పనిమనిషి జిల్ఫా మూలంగా అతనికి ఇద్దరు కుమారులు ఉన్నారు. గాదు, ఆషేరు. వీరు పద్దనరాములో యాకోబుకు (ఇశ్రాయేలుకు) పుట్టిన కుమారులు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","కిర్యతర్బాలోని (హెబ్రోను) మమ్రేలోనున్న తన తండ్రి ఇస్సాకు దగ్గరకు యాకోబు వెళ్లాడు. అబ్రాహాము, ఇస్సాకులు నివసించిన చోటు ఇది. ");
INSERT INTO tel2010_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ఇస్సాకు 180 సంవత్సరాల వయస్సులో ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ఇస్సాకు చాలకాలం నిండు జీవితాన్ని జీవించాడు. అతడు చనిపోయినప్పుడు వృద్ధుడు. అతని సమాధి చేయబడిన చోటనే, అతని కుమారులైన ఏశావు, యాకోబులు అతణ్ణి కూడ సమాధి చేశారు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ఏశావు కుటుంబ జాబితా ఇది: (ఎదోము అని కూడ అతనికి పేరు) ఏశావు కనాను దేశపు స్త్రీలను పెళ్లి చేసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ఏశావు భార్యలు ఎవరంటే: ఆదా, హిత్తీవాడైన ఏలోను కుమార్తె అహోలీబామా, హివ్వీవాడైన సిబ్యోను కుమారుడు అనా కుమార్తె, ");
INSERT INTO tel2010_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","బాశెమతు, ఇశ్మాయేలు కుమార్తె, నెబాయోతు సోదరి. ");
INSERT INTO tel2010_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ఎలీఫజు అనే కుమారుని ఆదా ఏశావుకు కన్నది. రగూయేలు అనే కుమారుని బాశెమతు ఏశావుకు కన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","అహోలీబామా ఏశావుకు ముగ్గురు కుమారులను కన్నది: యూషు, యాలాము, కోరహు. వీరు ఏశావు కుమారులు. వీరు కనాను దేశంలో పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","ఏశావు కుటుంబం, యాకోబు కుటుంబం కలిసి ఒకే చోట నివసించటం వల్ల ఆ ప్రాంతం వాళ్ల పోషణకు చాలలేదు. కనుక ఏశావు కనాను విడిచిపెట్టి తన సోదరుడు యాకోబుకు దూరంగా మరో దేశం వెళ్లిపోయాడు. ఏశావు తనకు కలిగినదంతా తనతోబాటు తీసుకొని పోయాడు. ఇవన్నీ అతడు కనానులో నివసించినప్పుడు సంపాదించుకొన్నాడు. కనుక తన భార్యలను, కుమారులను, కుమార్తెలను, తన బానిసలందరిని, పశువులను, ఇతర జంతువులను ఏశావు తనతో కూడ తెచ్చుకొన్నాడు. కనుక ఏశావు శేయీరు కొండ ప్రాంతానికి తరలి పోయాడు. (ఏశావుకు ఎదోము అని కూడ పేరు). (మరియు ఎదోము, శేయీరు దేశానికి మరో పేరు) ");
INSERT INTO tel2010_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ఎదోమి ప్రజలకు ఏశావు తండ్రి. శేయీరు (ఎదోము) కొండ ప్రాంతంలో నివసిస్తోన్న ఏశావు కుటుంబంలోని వాళ్ల పేర్లు యివి: ");
INSERT INTO tel2010_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","ఏశావు కుమారులు ఎలీఫజు, ఏశావు, ఆదాలకు పుట్టిన కుమారుడు. రగూయేలు, ఏశావు, బాశెమతులకు పుట్టిన కుమారుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","ఎలీఫజుకు అయిదుగురు కుమారులు: తేమాను, ఓమారు, సెపో, గాతాము మరియు కనజు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ఎలీఫెజుకు తిమ్నా అనే ఒక దాసి కూడ ఉంది. తిమ్నా, ఎలీఫజులకు అమాలేకు పుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","రగూయేలుకు ముగ్గురు కుమారులు: నహతు, జెరహు, షమ్మా, మిజ్జ. వీరు బాశెమతు మూలంగా ఏశావుకు మనుమళ్లు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","అనా కుమార్తె అహోలీబామా ఏశావుకు మూడవ భార్య. (అనా సిబ్యోను కుమారుడు) ఏశావు, అహోలీబామాలకు పుట్టిన పిల్లలు: యూషు, యాలాము, కోరహు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","ఏశావు ద్వారా వచ్చిన వంశాలు యివి: ఏశావు మొదటి కుమారుడు ఎలీఫజు. ఎలీఫజుకు పుట్టిన వారు: తేమాను, ఓమారు, సెపో, కనజు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","కోరహు, గాతాము, అమాలేకు. ఈ వంశాలన్నీ ఏశావు భార్య ఆదానుండి ఉద్భవించాయి ");
INSERT INTO tel2010_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","ఏశావు కుమారుడు రగూయేలు ఈ కింది కుటుంబాలకు తండ్రి: నహతు, జెరహు, షమ్మా, మిజ్జ. ఈ కుటుంబాలన్నీ ఏశావు భార్య బాశెమతు నుండి ఉద్భవించాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","అనా కుమార్తె, ఏశావు భార్య అహోలీబామాకు యూషు, యగ్లాము, కోరహు పుట్టారు. ఈ ముగ్గురు వారికి పుట్టిన కుటుంబాలకు పెద్దలు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","ఈ కుటుంబాలన్నీ ఏశావునుండి ఉద్భవించాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","ఏశావుకంటె ముందు హోరీవాడైన శేయీరు ఎదోములో నివసించాడు. శేయీరు కుమారులు వీరు: లోతాను, శోబాలు, సిబ్యోను, అనా, ");
INSERT INTO tel2010_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","దిషోను, ఏసెరు, దీషాను. వీరు ఏశావు (ఎదోము) ప్రాంతంనుండి వచ్చిన హోరీయ కుటుంబ నాయకులు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","హోరీ, హేమీము. వీరికి లోతాను తండ్రి. (తిమ్నా లోతాను సోదరి.) ");
INSERT INTO tel2010_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","అల్వాన్, మానహదు, ఏబాలు, షపో, ఓనాము. వీరి తండ్రి శోబాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","సిబ్యోనుకు ఇద్దరు కుమారులు. అయ్యా, అనా. (అనా తన తండ్రి గాడిదలను కాస్తూ ఉండగా ఎడారిలో ఉష్ణధారలను కనుగొన్నవాడు.) ");
INSERT INTO tel2010_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","దిషాను, అహోలీబామా అనే వారికి అనా తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","దిషోనుకు నలుగురు కుమారులు: హెన్దూను, ఎష్బాను, ఇత్రాను, కెరాను. ");
INSERT INTO tel2010_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","ఏసెరుకు ముగ్గురు కుమారులు: బిల్హాను, జవాను, అకాను. ");
INSERT INTO tel2010_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","దీషానుకు ఇద్దరు కుమారులు: ఊజు, అరాను. ");
INSERT INTO tel2010_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","హోరీ కుటుంబాల పెద్దల పేర్లు ఇవి: లోతాను, శోబాలు, సిబ్యోను, అనా, ");
INSERT INTO tel2010_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","దిషోను, ఏసెరు, దీషాను, శేయీరు (ఎదోము) దేశంలో నివసించిన కుటుంబాల పెద్దలు వీరంతాను. ");
INSERT INTO tel2010_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","అప్పట్లో, ఎదోములో రాజులు ఉన్నారు. ఇశ్రాయేలీయుల రాజులకంటె చాలా ముందే ఎదోములో రాజులు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","బెయారు కుమారుడు బెల ఎదోమును పాలించిన ఒక రాజు. అతడు దిన్హాబా పట్టణమును పాలించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","బెల చనిపోయినప్పుడు యోబాబు రాజయ్యాడు. యోబాబు బొస్రావాడైన జెరహు కుమారుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","యోబాబు చనిపోయినప్పుడు హుషాము పాలించాడు. హుషాము తేమాని ప్రజల దేశవాసి. ");
INSERT INTO tel2010_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","హుషాము చనిపోయాక హదదు ఆ ప్రాంతాన్ని పాలించాడు. బదదు కుమారుడు హదదు. (మోయాబు దేశంలో మిద్యానును జయించినవాడు హదదు.) హదదు అవీతు పట్టణంవాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","హదదు మరణించాక శమ్లా ఆ దేశాన్ని పాలించాడు. శమ్లా మశ్రేకనుండి వచ్చినవాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","శమ్లా మరణించాక షావూలు ఆ ప్రాంతాన్ని పాలించాడు. యూఫ్రటీసు నదీ ప్రాంతంలోని రహెబోతువాడు షావూలు. ");
INSERT INTO tel2010_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","షావూలు మరణానంతరం బయల్ హానాను ఆ దేశాన్ని పాలించాడు. అక్బోరు కుమారుడు బయల్ హనాను. ");
INSERT INTO tel2010_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","బయల్ హనాను మరణించాక హదదు (హదరు) ఆ దేశాన్ని పాలించాడు. హదదు పాపు నగరవాసి. అతని భార్య పేరు మహేతబేలు. ఆమె మత్రేదు కుమార్తె. (మత్రేదు తండ్రి మేజాహాబు). ");
INSERT INTO tel2010_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","తిమ్నా, అల్వా, యతేతు, అహోలీబామా, ఏలా, పీనోను, కనజు, తేమాను, మిబ్సారు, మగ్దీయేలు, ఈరాము: ఈ ఎదోమీ కుటుంబాలకు పితరుడు ఏశావు. వీటిలో ఒక్కో కుటుంబం, తన కుటుంబం పేరుతోనే పిలువబడే ప్రాంతంలో నివసించింది. ");
INSERT INTO tel2010_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","యాకోబు కనాను దేశంలో ఉంటూ, అక్కడే నివసించాడు. ఇదీ, అతని తండ్రి నివసించినదీ ఒకటే దేశం. ");
INSERT INTO tel2010_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ఇదీ యాకోబు కుటుంబ గాధ. యోసేపు 17 సంవత్సరాల యువకుడు. గొర్రెల్ని, మేకల్ని కాయటం అతని పని. తన సోదరులైన బిల్హా, జిల్ఫా, కుమారులతో కలిసి యోసేపు ఈ పని చేసాడు. (బిల్హా, జిల్ఫా అతని తండ్రి భార్యలు.) అతని సోదరులు చేసే చెడ్డ పనులను గూర్చి యోసేపు తన తండ్రితో చెప్పేవాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","అతని తండ్రి ఇశ్రాయేలు (యాకోబు) చాలా వృద్ధుడుగా ఉన్నప్పుడు యోసేపు పుట్టాడు. కనుక ఇశ్రాయేలు (యాకోబు) తన కుమారులందరికంటే యోసేపును ఎక్కువగా ప్రేమించాడు. యాకోబు తన కుమారునికి ఒక ప్రత్యేకతగల అంగీ ఇచ్చాడు. ఈ అంగీ చాలా పొడుగ్గా, అందంగా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","యోసేపు సోదరులు వారి తండ్రి వారందరికంటే యోసేపును ఎక్కువగా ప్రేమించటం గమనించారు. అందుచేత వారు వారి సోదరుణ్ణి ద్వేషంచారు. వాళ్లు యోసేపుతో స్నేహభావంతో మాట్లాడలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ఒకసారి యోసేపుకు ఒక ప్రత్యేకమైన కల వచ్చింది. తర్వాత ఈ కల విషయం యోసేపు తన అన్నలతో చెప్పాడు. దీని తర్వాత అతని అన్నలు అతణ్ణి మరింతగా ద్వేషించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","“నాకో కల వచ్చింది, ");
INSERT INTO tel2010_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","మనమంతా పొలంలో పని చేస్తున్నాం. మనం గోధుమ పనలు కడ్తున్నాం. నా పన నిలబడింది, దాని చుట్టూ మీ పనలు లేచి నిలబడ్డాయి. అప్పుడు మీ పనలన్నీ నా పనకు సాష్టాంగపడ్డాయి” అని చెప్పాడు యోసేపు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","అతని సోదరులు, “అంటే మా మీద నీవు రాజువై అధికారం చేస్తావా?” అని అడిగారు. వారిని గూర్చి యోసేపుకు వస్తోన్న కలల మూలంగా ఇప్పుడు వారు అతణ్ణి ఇంకా ఎక్కువ ద్వేషిస్తున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","అప్పుడు యోసేపుకు మళ్లీ ఒక కల వచ్చింది. ఈ కలను గూర్చి యోసేపు తన సోదరులకు చెప్పాడు. “నాకు ఇంకో కల వచ్చింది. సూర్యుడు, చంద్రుడు, మరియు 11 నక్షత్రాలు నాకు సాష్టాంగపడటం నేను చూసాను” అంటూ చెప్పాడు యోసేపు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ఈ కల విషయమై యోసేపు తన తండ్రితో కూడ చెప్పాడు. కాని అతని తండ్రి అతణ్ణి విమర్శించాడు. “ఇదేం కల? నేనూ, మీ అమ్మ, నీ సోదరులు అందరం నీకు సాష్టాంగపడతామని నీవు నమ్ముతున్నావా?” అన్నాడు అతని తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","యోసేపు సోదరులు మాత్రం అతని మీద అసూయ పడుతూనే ఉన్నారు. అయితే యోసేపు తండ్రి వీటన్నింటిని గూర్చి చాలా ఆలోచన చేసి వీటి భావం ఏమై ఉంటుందా అని ఆశ్చర్యపడుతూ వున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ఒకరోజు, యోసేపు సోదరులు తమ తండ్రి గొర్రెల్ని మేపుకొనేందుకు షెకెం వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","యాకోబు, “నీ, సోదరులు షెకెంలో నా గొర్రెల్ని కాస్తున్నారు. నీవు అక్కడికి వెళ్లాలి” అని యోసేపుతో చెప్పాడు. “అలాగే నేను వెళ్తా,” అన్నాడు యోసేపు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","యోసేపు తండ్రి, “నీవు వెళ్లి నీ సోదరులు క్షేమంగా ఉన్నారో లేదో చూచి, మళ్లీ వచ్చి నా గొర్రెల క్షేమ సమాచారం నాకు చెప్పాలి” అన్నాడు. అందుచేత యోసేపు తండ్రి హెబ్రోను లోయనుండి షెకెముకు అతడ్ని పంపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","షెకెములో యోసేపు తప్పిపోయాడు. అతడు పొలాల్లో తిరుగుతోంటే ఒక మనిషి చూశాడు. “ఏమిటి వెదుకుతున్నావు” అన్నాడు ఆ మనిషి. ");
INSERT INTO tel2010_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","“నేను నా అన్నల కోసం వెదుకుతున్నాను. వాళ్లు గొర్రెల్ని మేపుకొంటూ ఎక్కడ ఉన్నారో నీవు చెప్పగలవా?” అన్నాడు యోసేపు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ఆ మనిషి “అప్పుడే వాళ్లు వెళ్లిపోయారు గదా. వాళ్లు దోతాను వెళ్తాం అని చెప్పుకోవటం నేను విన్నాను” అన్నాడు. కనుక యోసేపు తన సోదరులను వెంబడించి, దోతానులో వారిని చూడగలిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","యోసేపు రావటం అతని అన్నలు అంత దూరం నుంచే చూసారు. అతణ్ణి చంపేందుకు ఒక పథకం వేయాలని వారు తీర్మానించుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","ఆ సోదరులు వాళ్లలో వారు ఇలా చెప్పుకొన్నారు, “కలలుకనే యోసేపు ఇక్కడికి వస్తున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ఇప్పుడు మనకు వీలైనప్పుడే మనం వాణ్ణి చంపివేయాలి. వాని శవాన్ని ఇక్కడే ఏదో ఖాళీ బావిలో పడవేస్తే సరిపోతుంది. అడవి మృగం ఏదో వాణ్ణి చంపేసిందని మన తండ్రితో మనం చెప్పొచ్చు. అప్పుడు అతని కలలన్నీ అర్థము లేనివని వానికి మనం చూపెట్టవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","కానీ రూబేను యోసేపును కాపాడాలి అనుకొన్నాడు, “వాణ్ణి మనం చంపొద్దు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","వానికి హాని చేయకుండానే ఒక బావిలో పడవేస్తే సరిపోతుంది” అని చెప్పాడు రూబేను. యోసేపును రక్షించి, అతని తండ్రి దగ్గరకు పంపించాలని రూబేను వేసిన పథకం ఇది. ");
INSERT INTO tel2010_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","యోసేపు తన సోదరుల దగ్గరకు వచ్చాడు. వారు అతని మీద పడి, అందమైన అతని పొడవాటి అంగీని చింపేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","తర్వాత, ఎండిపోయి ఖాళీగా ఉన్న ఒక బావిలో అతణ్ణి పడవేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","యోసేపు బావిలో పడి ఉంటే, అతని సోదరులు భోజనం చేసేందుకు కూర్చున్నారు. అప్పుడు వారు చూడగా, గిలాదునుండి ఈజిప్టుకు ప్రయాణం చేస్తోన్న వ్యాపారస్తుల బృందం ఒకటి కనబడింది. వారి ఒంటెలు గుగ్గిలం, మస్తకి, బోళం, ఐశ్వర్యాలు మోస్తున్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","కనుక యూదా తన సోదరులతో “మనం మనసోదరుని చంపి, వాని మరణాన్ని దాచిపెడితే మనకేం లాభం? ");
INSERT INTO tel2010_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ఈ వ్యాపారస్తులకు గనుక మనం వాణ్ణి అమ్మివేస్తే మనకు లాభం వస్తుంది. పైగా మన సొంత సోదరుని చంపిన అపరాధం మనమీద ఉండదు” అన్నాడు. మిగిలిన సోదరులు సమ్మతించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","మిద్యానీ వ్యాపారవేత్తలు అటు రాగానే, ఆ సోదరులు యోసేపును బావిలో నుండి బయటకు తీసారు. 20 వెండి నాణాలకు వారతణ్ణి ఆ వ్యాపారవేత్తలకు అమ్మివేసారు. వ్యాపారవేత్తలు అతణ్ణి ఈజిప్టుకు తీసుకువెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ఇంతసేపూ రూబేను అక్కడ తన సోదరులతో లేడు. యోసేపును వారు అమ్మివేసినట్టు అతనికి తెలియదు. రూబేను బావి దగ్గరకు వచ్చినప్పుడు, యోసేపు బావిలో లేడు. రూబేనుకు ఎక్కడాలేని విచారం కలిగింది. తన విషాదాన్ని తెలియజేయడానికి తన గుడ్డలను చింపివేసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","రూబేను తన సోదరుల దగ్గరకు వెళ్లి, “పిల్లవాడు బావిలో లేడు, నేనేం చేయాలి?” అని అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","ఆ సోదరులు ఒక మేకను చంపి, దాని రక్తాన్ని యోసేపుయొక్క అందమైన అంగీకి పూసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","తర్వాత ఆ సోదరులు ఆ అంగీని తమ తండ్రికి చూపించారు. “ఈ అంగీ మాకు దొరికింది. ఇది యోసేపుదా?” అంటూ అడిగారు ఆ సోదరులు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","తండ్రి అంగీని చూచి, అది యోసేపుదేనని తెలుసుకొన్నాడు. “అవును, అది అతనిదే, ఒకవేళ అడవి మృగం ఏదైనా అతణ్ణి చంపివేసిందేమో. నా కుమారుడు యోసెపును అడవి మృగం ఏదో భక్షించి వేసింది!” అన్నాడు ఆ తండ్రి. ");
INSERT INTO tel2010_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","యాకోబు తన కుమారుని గూర్చిన దుఃఖంతో తన వస్త్రాలు చింపి వేసుకున్నాడు. అతడు దుఃఖంలో ఉన్నట్టు వ్యక్తం చేసేందుకు ప్రత్యేక వస్త్రలు యాకోబు ధరించాడు. యాకోబు తన కుమారుని విషయం చాలా కాలం దుఃఖంగానే ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","యాకోబు కుమారులు, కుమార్తెలు అందరూ అరణ్ణి ఓదార్చాలని ప్రయత్నించారు. అయినా యాకోబుకు ఎన్నడూ ఆదరణ కలుగలేదు. యాకోబు “నా మరణ దినంవరకు నా కుమారుని గూర్చి దుఃఖస్తూనే ఉంటాను” అన్నాడు. అందుచేత అతని కుమారుడైన యోసేపు కోసం యోకోబు దుఃఖంలోనే కాలం గడుపుతూ ఉండిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","యోసేపును కొన్న మిద్యాని వ్యాపారవేత్తలు దరిమిలా అతణ్ణి ఈజిప్టులో ఫరో సంరక్షక సేనాధిపతి పోతీఫరుకు అమ్మివేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","సుమారు అదే సమయంలో యూదా తన సోదరులను విడిచి, హీరా అనే ఒకతని దగ్గర ఉండేందుకు వెళ్లాడు. హీరా అదుల్లాము నివాసి. ");
INSERT INTO tel2010_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","అక్కడ యూదా ఒక కనానీ అమ్మాయిని కలుసుకొని ఆమెను పెళ్లి చేసుకొన్నాడు. ఆ అమ్మాయి తండ్రి పేరు షూయ. ");
INSERT INTO tel2010_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","ఆ కనానీ స్త్రీకి ఒక కుమారుడు పుట్టగా, వారు అతనికి ఏరు అని పేరు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","తర్వాత ఆమె మరో కుమారుని కన్నది. ఆ కుమారునికి వారు ఓనాను అని పేరు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","తర్వాత షేలా అనే పేరుగల ఇంకో కుమారుడు ఆమెకు పుట్టాడు. యూదాకు మూడో కుమారుడు పుట్టునప్పుడు, అతడు కజీబులో నివాసం ఉంటున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","యూదా తన మొదటి కుమారుడైన ఏరుకు భార్యగా ఒక అమ్మాయిని ఏర్పాటు చేసాడు. ఆ అమ్మాయి పేరు తామారు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","కానీ ఏరు చాలా చెడ్డపనులు చేసాడు. అతని విషయంలో యెహోవాకు సంతోషం లేదు. అందుచేత యెహోవా అతణ్ణి చంపేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","అప్పుడు యూదా అతని సోదరుడైన ఓనానుతో “పోయి, చచ్చిన నీ సోదరుని భార్యతో శయనించు. ఆమెకు భర్తలా ఉండు. పిల్లలు పుడితే వారు నీ సోదరుడైన ఏరు పిల్లలుగా పరిగణించ బడతారు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ఈ సంబంధంవలన కలిగే పిల్లలు తన పిల్లలుగా పరిగణింపబడరని ఓనానుకు తెలుసు. ఓనాను తామారుతో సంభోగించి, ఇంద్రియమును బయట పడవేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","దీనితో యెహోవాకు కోపము వచ్చి ఆయన ఓనానును చంపేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","అప్పుడు యూదా “నీవు తిరిగి నీ తండ్రి యింటికి వెళ్లిపో. నా చిన్న కుమారుడు షేలా పెద్దవాడయ్యేంత వరకు నీవు మళ్లీ పెళ్లి చేసుకోకు” అని తన కోడలైన తామారుతో చెప్పాడు. షేలా కూడ తన అన్నల్లాగే చస్తాడేమోనని యూదాకు భయం. అతని కోడలు తామారు తిరిగి తన తండ్రి ఇంటికి వెళ్లిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","ఆ తర్వాత షూయ కుమార్తె, యూదా భార్య చనిపోయింది. యూదాకు దుఃఖ కాలం తీరిపోయ్యాక, అతడు తన స్నేహితుడు, అదుల్లాము మివాసి హీరాతో కలిసి తిమ్నాతునకు వెళ్లాడు. తన గొర్రెల బొచ్చు కత్తిరించాలని యూద తిమ్నాతునకు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","తామారు తన మామగారు యూదా తన గొర్రెల బొచ్చు కత్తిరించేందుకు తిమ్నాతునకు వస్తున్నాడని తెలుసుకొంది. ");
INSERT INTO tel2010_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","తామారు ఎప్పుడు విధవరాలి గుడ్డలే ధరించేది. కనుక ఇప్పుడు వేరే వస్త్రాలు ధరించి, నెత్తిమీద ముసుగు వేసుకొంది. అప్పుడు తిమ్నాతునకు దగ్గర్లో ఎనాయిం అనే పట్టణానికి పోయే మార్గంలో కూర్చొంది. యూదా చిన్న కుమారుడు షేల ఇప్పుడు పెద్దవాడయ్యాడని తామారుకు తెలుసు. అయినా గాని ఆమె అతణ్ణి పెళ్లి చేసికొనే ఏర్పాట్లు యూదా చేయటం లేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","యూదా ఆ మార్గాన ప్రయాణం చేసాడు. అతడు ఆమెను చూశాడు గాని ఆమె వేశ్య అనుకొన్నాడు. (వేశ్యాలా ఆమె ముఖం మీద ముసుగు వేసుకొంది.) ");
INSERT INTO tel2010_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","కనుక యూదా ఆమె దగ్గరకు వెళ్లి, “నన్ను నీతో లైంగింకంగా కలవనీ” అని అడిగాడు. (ఆమె తన కోడలు తామారు అని యూదాకు తెలియదు.) “అసలు నీవు ఏ మాత్రం ఇస్తావేంటి?” అంది ఆమె. ");
INSERT INTO tel2010_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","యూదా, “నా మందలోనుంచి ఒక మేక పిల్లను పంపిస్తా” అని జవాబిచ్చాడు. “సరే, ఒప్పుకొంటాను. కాని నీవు ఆ మేక పిల్లను పంపించేంత వరకు నా దగ్గర ఉంచుకొనేందుకు నీవు యింకేమైన నాకు ఇవ్వాలి సుమా” అని జవాబు చెప్పింది ఆమె. ");
INSERT INTO tel2010_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","“నేను నీకు మేకపిల్లను పంపిస్తానని రుజువుగా ఉండేందుకు నన్నేమి ఇవ్వమంటావు?” అడిగాడు యూదా. తామారు, “నీవు నీ ఉత్తరాల మీద ఉపయోగించే నీ ముద్ర, దాని దారం, నీ చేతి కర్ర ఇవ్వు” అని చెప్పింది. యూదా అవన్నీ ఆమెకు ఇచ్చాడు. అప్పుడు యూదా తామారుతో సంభోగించగా ఆమె గర్భవతి అయ్యింది. ");
INSERT INTO tel2010_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","తామారు ఇంటికి వెళ్లి, తన ముఖం మీద ముసుగు తీసివేసింది. మరల విధవ వస్త్రాలే ఆమె ధరించింది. ");
INSERT INTO tel2010_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","యూదా తామారుకు ఇచ్చిన మాట ప్రకారం ఒక మేకను ఇచ్చి తన స్నేహితుడు హీరాను ఆమె ఇంటికి పంపించాడు. మరియు ఆమె దగ్గర్నుండి ప్రత్యేక ముద్రను, చేతి కర్రను తీసుకొని రమ్మని యూదా అతనితో చెప్పాడు. కానీ హీరాకు ఆమె కనబడలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","“ఇక్కడ దారి ప్రక్కగా ఉంటూండే ఆ వేశ్య ఏమయింది?” అని ఏనాయిము దగ్గర కొందరిని అడిగాడు హీరా. “ఇక్కడ ఎన్నడూ వేశ్య నివసించలేదే” అని వాళ్లు అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","కనుక యూదా స్నేహితుడు యూదా దగ్గరకు తిరిగి వెళ్లి, “ఆ స్త్రీ నాకు కనబడలేదు. అక్కడ ఎన్నడూ వేశ్య లేదని అక్కడ ఉండేవాళ్లు చెప్పారు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","అందుచేత యూదా, “ఆ వస్తువులు ఆమె దగ్గరే ఉండనివ్వు. మనుష్యులు నన్ను చూచి నవ్వటం నాకు ఇష్టం లేదు. ఆమెకు మేకను ఇవ్వాలని నేను ప్రయత్నంచేసాను, కానీ ఆమె మనకు కనబడలేదు. అది చాలు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","మూడు నెలల తర్వాత, “నీ కోడలు తామారు ఒక వేశ్యలా పాపం చేసింది, ఇప్పుడు గర్భవతిగా ఉంది” అని యూదాతో చెప్పారు. అప్పుడు యూదా, “ఆమెను బయటకు లాగి చంపేసి, ఆమె శరీరాన్ని కాల్చివేయండి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","తామారును చంపటానికి మనుష్యులు వెళ్లారు. అయితే ఆమె తన మామగారికి ఒక సందేశం పంపింది. “నన్ను గర్భవతిగా చేసినవాడు ఈ వస్తువుల స్వంతదారుడే. (ప్రత్యేక ముద్ర, చేతి కర్ర ఆమె అతనికి చూపించింది.) ఈ వస్తువులు చూడు. ఇవి ఎవరిది? ఈ ముద్ర, దారం ఎవరివి? ఈ చేతి కర్ర ఎవరిది?” ");
INSERT INTO tel2010_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","వాటిని యూదా గుర్తుపట్టి, “ఆమెదే సరి. నాదే తప్పు. నేను వాగ్దానం చేసిన ప్రకారం నా కుమారుడైన షేలాను నేను ఆమెకు ఇవ్వలేదు” అన్నాడు. యూదా మళ్లీ ఇక ఆమెతో శయనించలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","తామారు ప్రసవించే సమయం వచ్చినప్పుడు ఆమెకు కవలలు పుడతారని వారికి తెలిసింది. ");
INSERT INTO tel2010_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ఆమె ప్రసవిస్తున్నప్పుడు ఒక శిశువు చేయి బయటకు వచ్చింది. మంత్రసాని ఆ చేతికి ఒక ఎర్ర దారం కట్టి, “ఈ శిశువు ముందు పుట్టాడు” అంది. ");
INSERT INTO tel2010_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","అయితే ఆ శిశువు తన చేయి లోపలకు లాగేసాడు. అప్పుడు మరో శిశువు ముందు పుట్టాడు. కనుక “మొత్తానికి నీవే ముందు భేదించుకొని పుట్టావన్న మాట” అంది మంత్రసాని. అంచేత వారు పెరెసు అని వానికి పేరు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","తర్వాత రెండో శిశువు పట్టాడు. చేతికి ఎర్రదారం కట్టబడిన శిశువు వీడు. వారు వాడికి జెరహు అనే పేరు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","యోసేపును కొన్న వ్యాపార వేత్తలు అతణ్ణి ఈజిప్టుకు తీసుకు వెళ్లారు. ఫరో సంరక్షకుల అధిపతి పోతీఫరుకు వారు అతన్ని అమ్మేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","అయితే యెహోవా యోసేపుకు సహాయం చేసాడు. యోసేపు విజయ సారధి అయ్యాడు. తన యజమాని, ఈజిప్టు వాడైన పోతీఫరు ఇంటిలో యోసేపు నివాసం ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","యెహోవా యోసేపుకు తోడుగా ఉన్నట్టు పోతీఫరు తెలుసుకొన్నాడు. యోసేపు చేసిన ప్రతి పనిలో యెహోవా అతనికి తోడుగా ఉన్నట్టు పోతీఫరు గ్రహించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","అందుచేత యోసేపు విషయంలో పోతీఫరు చాల సంతోషించాడు. పోతీఫరు యోసేపును తనకు సహాయం చేయనిస్తూ, తన ఇంటి వ్యవహారాలన్నీ పర్యవేక్షింపనిచ్చాడు. పోతీఫరుకు ఉన్న సమస్తంమీద యోసేపు అధికారి. ");
INSERT INTO tel2010_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ఆ ఇంటిమీద యోసేపు అధికారిగా చేయబడిన తర్వాత, యెహోవా ఆ ఇంటినీ, పోతీఫరుకు ఉన్న సమస్తాన్నీ ఆశీర్వదించాడు. ఇదంతా యోసేపువల్లనే యెహోవా చేసాడు. పోతీఫరు పొలాల్లో పెరిగే వాటన్నిటినీ యెహోవా ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","కనుక పోతీఫరు తన ఇంటిలో అన్ని విషయాల బాధ్యత యోసేపునే తీసుకోనిచ్చాడు. పోతీఫరు తాను భుజించే భోజనం విషయం తప్ప మరి దేనిగూర్చీ చింతించలేదు. యోసేపు చాలా అందగాడు. చూడ చక్కని వాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","కొన్నాళ్ల తర్వాత యోసేపు యజమాని భార్య యోసేపు మీద మోజుపడసాగింది. ఒకనాడు ఆమె, “నాతో శయనించు” అని అతనితో అంది. ");
INSERT INTO tel2010_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","కానీ యోసేపు నిరాకరించాడు. అతడు చెప్పాడు: “నా యజమాని తన ఇంటిలో అన్ని విషయాల్లోనూ నన్ను నమ్మాడు. ఇక్కడ ఉన్న ప్రతిదాని గూర్చి అతడు నాకు బాధ్యత పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","నా యజమాని తన ఇంట నన్ను దాదాపుగా అతనికి సమానంగా ఉంచాడు. నేను అతని భార్యతో శయనించకూడదు. అది తప్పు అది దేవునికి వ్యతిరేకంగా పాపం.” ");
INSERT INTO tel2010_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","ఆమె ప్రతిరోజూ యోసేపుతో మాట్లాడుతున్నప్పటికీ యోసేపు ఆమెతో శయనించేందుకు నిరాకరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ఒక రోజు యోసేపు తన పని చేసుకొనేందుకని ఇంటిలోనికి వెళ్లాడు. ఆ సమయంలో అతను ఒక్కడే ఇంటిలో ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","అతని యజమాని భార్య అతని అంగీ పట్టి లాగి, “వచ్చి నాతో శయనించు” అంది అతనితో. అయితే యోసేపు ఇంట్లోనుంచి బయటకు పారిపోయాడు. పైగా అతడు తన అంగీని ఆమె చేతిలోనే వదిలేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","యోసేపు అతని అంగీని తన చేతిలోనే విడిచి వెళ్లినట్టు ఆ స్త్రీ గమనించింది. జరిగిన దాని విషయమై ఆమె అబద్ధం చెప్పాలని నిర్ణయించుకొంది. బయటకు పరిగెత్తింది. ");
INSERT INTO tel2010_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ఆమె తన ఇంటిలో ఉన్న పురుషులను పిలిచింది. ఆమె అంది, “చూడండి, మనలను ఆట పట్టించటానికే ఈ హెబ్రీ బానిసను తెచ్చారు. ఇతడు లోనికి వచ్చి నన్ను బలవంతం చేయటానికి ప్రయత్నించాడు. కానీ నేను గట్టిగా కేక పెట్టేసరికి ");
INSERT INTO tel2010_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","అతను భయపడి పారిపోయాడు. అయితే అతని అంగీ నా దగ్గరే వదిలేసిపోయాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","తన భర్త, అంటే యోసేపు యజమాని ఇంటికి వచ్చేంత వరకు ఆమె ఆ అంగీని ఉంచింది. ");
INSERT INTO tel2010_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","ఆమె తన భర్తతో అదే కథ చెప్పింది. ఆమె, “నీవు ఇక్కడికి తీసుకొని వచ్చిన ఈ హెబ్రీ బానిస నామీద పడటానికి ప్రయత్నం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","అయితే అతడు నా దగ్గరకు రాగానే నేను గట్టిగా కేక వేసాను. అతను పారిపోయాడు గాని అతడు అంగీ విడిచిపెట్టేసాడు” అని చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","యోసేపు యజమాని అతని భార్య చెప్పిందంతా విన్నాడు. అతనికి చాలా కోపం వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","రాజ ద్రోహులను బంధించే ఒక చెరసాల ఉంది. కనుక యోసేపును ఆ చెరసాలలో వేసాడు పోతీఫరు. యోసేపు అందులోనే ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","అయితే యోసేపుకు యెహోవా తోడుగా ఉన్నాడు. యెహోవా యోసేపుకు తన దయనుచూపెడ్తూనే ఉన్నాడు. కొన్నాళ్లయ్యేటప్పటికి చెరసాల కాపలాదారుల నాయకునికి యోసేపు అంటే ఇష్టం కలిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","కాపలాదారుల అధిపతి ఖైదీలందరి మీద యోసేపును నాయకునిగా ఉంచాడు. యోసేపు వారికి నాయకుడు, అయినప్పటికీ వారి చేసిన పనులే అతడు కూడా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","చెరసాలలో ఉన్న ప్రతిదాని విషయంలోను ఆ కాపలాదారుల నాయకుడు యోసేపును నమ్మాడు. యెహోవా యోసేపుతో ఉన్నందుచేత ఇలా జరిగింది. యోసేపు చేసే ప్రతి పనిలో అతనికి కార్యసాధన కలిగేటట్టు యెహోవా యోసేపుకు సహాయం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ఆ తరువాత ఫరో సేవకులు ఇద్దరు ఫరోకు అపకారం చేసారు. ఆ సేవకుల్లో ఒకడు రొట్టెలు కాల్చేవాడు. మరొకడు ద్రాక్షా పాత్రలు అందించేవారి పెద్ద. ");
INSERT INTO tel2010_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","వంటల పెద్ద, ద్రాక్షా పాత్రల, పెద్ద మీద ఫరోకు కోపం వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","కనుక వారిని కూడా యోసేపు ఉన్న చెరసాలలోనే వేయించాడు ఫరో రాజు సంరక్షకుల అధికారియైన పోతీఫరు ఈ చెరసాల అధికారి. ");
INSERT INTO tel2010_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","ఈ ఇద్దరు ఖైదీలను యోసేపు బాధ్యతకు అప్పగించాడు అధికారి. ఆ ఇద్దరు మనుష్యులు కొన్నాళ్ల వరకు అలా జైల్లోనే ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ఒక రాత్రి ఆ ఇద్దరు ఖైదీలకు కలలు వచ్చాయి. (ఆ ఇద్దరు ఖైదీలు ఈజిప్టు రాజు సేవకులు—ఒకడు రొట్టెలు కాల్చేవాడు, మరొకడు ద్రాక్షా పాత్రల పెద్ద). ఒక్కో ఖైదీకి ఒక్కో కల వచ్చింది. ఒక్కో కలకు ఒక్కో భావం ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","మర్నాడు ఉదయం యోసేపు వాళ్ల దగ్గరకు వెళ్లాడు. ఆ ఇద్దరు మనుష్యులు ఏదో చింతిస్తున్నట్టు యోసేపు గమనించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","“ఏమిటి, ఈ వేళ మీరు చాలా చింతిస్తున్నట్టు కనబడుతున్నారు?” అని వారిని అడిగాడు యోసేపు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","“రాత్రి మాకు కలలు వచ్చాయి కాని మేము కన్న కల మాకు అర్థం కాలేదు. ఆ కలలు ఏమిటో, వాటి భావం ఏమిటో మాకు వివరించే వాళ్లెవరూ లేరు” అని వాళ్లిద్దరు జవాబిచ్చారు. యోసేపు, “కలలను తెలిసికొని, వాటి భావం చెప్పగలవాడు దేవుడు మాత్రమే కనుక దయచేసి మీ కలలు నాకు చెప్పండి” అని వారితో అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","కనుక ద్రాక్షా పాత్రల సేవకుడు యోసేపుతో తన కల చెప్పాడు. ఆ సేవకుడు ఇలా చెప్పాడు: “నా కలలో ఒక ద్రాక్షావల్లి కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ఆ ద్రాక్షావల్లికి మూడు తీగెలున్నాయి. నేను చూస్తుండగా ఆ తీగెలకు పూలు పూసి, ద్రాక్షాగెలలు అయ్యాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","నేను ఫరో పాత్ర పట్టుకొని ఉన్నాను. కనుక నేను ఆ ద్రాక్షాలను తీసుకొని ఆ పాత్రలో వాటి రసం పిండాను. అప్పుడు ఆ పాత్ర నేను ఫరోకు ఇచ్చాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","అప్పుడు యోసేపు అన్నాడు: “ఆ కలను నీకు నేను వివరిస్తాను. మూడు కొమ్మలంటే మూడు రోజులు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","మూడు రోజులు గతించక ముందే ఫరో నిన్ను క్షమించి, నిన్ను మళ్లీ నీ పని చేసుకోనిస్తాడు. ఇది వరకు నీవు ఫరో దగ్గర పని చేసిన పని నీవు మళ్లీ చేస్తావు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","నీకు విడుదల అయింతర్వాత నన్ను జ్ఞాపకం చేసుకో. నా మీద దయ ఉంచి, నాకు సహాయం చేయి. నాకుగూడ ఈ చెరసాలలో నుంచి విముక్తి కలిగేటట్టు నా గురించి ఫరోతో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","నన్ను అన్యాయంగా బలవంతంగా నా యింటినుండి నా ప్రజలైన హీబ్రూలనుండి తీసుకొనివచ్చారు. నేనేమి తప్పు చేయలేదు. అందుచేత నేను ఈ చెరసాలలో ఉండకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","మరో సేవకుని కల బాగున్నట్టు రొట్టెలు కాల్చేవాడికి తోచింది. వాడు యోసేపుతో అన్నాడు, “నాకూ ఒక కల వచ్చింది. నా తలమీద రొట్టెల బుట్టలు మూడు ఉన్నట్టు నాకు కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","పై బుట్టలో అన్ని రకాల కాల్చిన ఆహారాలు ఉన్నాయి. ఈ భోజనం రాజుగారి కోసం. కాని పక్షులు ఈ భోజనాన్ని తినేస్తున్నాయి.” ");
INSERT INTO tel2010_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","యోసేపు జవాబిచ్చాడు: “ఈ కల అర్థం ఏమిటో నీకు నేను చెబతాను. మూడు బుట్టలు అంటే మూడు రోజులు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","మూడు రోజులు గడవక ముందే రాజుగారు నిన్ను ఈ చెరసాలలోనుంచి విడుదల చేస్తారు. తర్వాత రాజుగారు నీ తల నరికేస్తాడు, నీ శరీరాన్ని ఒక స్తంభానికి వేలాడదీస్తాడు, పక్షులు నీ శరీరాన్ని తినివేస్తాయి.” ");
INSERT INTO tel2010_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","మూడు రోజుల తర్వాత రాజుగారి పుట్టిన రోజు వచ్చింది. ఫరో తన సేవకులందరికీ ఒక విందు చేసాడు. ఆ విందులో ఫరో తన రొట్టెలు కాల్చేవాడిని, ద్రాక్షా పాత్రల సేవకుణ్ణి చెరసాలలోనుంచి బయటకు రప్పించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","ద్రాక్షాపాత్రల సేవకుడ్ని ఫరో విడుదల చేసాడు. అతని ఉద్యోగం మరల ఫరో అతనికి ఇచ్చాడు. ద్రాక్షా పాత్రల సేవకుడు ద్రాక్షారసపు పాత్ర ఒకటి ఫరో చేతికి అందించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","కానీ ఫరో రొట్టెలు కాల్చే వాడిని చంపేసాడు. ఎలా జరుగుతుందని యోసేపు చెప్పాడో అంతా అలాగే జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","అయితే ద్రాక్షా పాత్రల సేవకుడు యోసేపుకు సహాయం చెయ్యటం మరచిపోయాడు. యోసేపు విషయం ఫరోతో అతడేమీ చెప్పలేదు. ద్రాక్షాపాత్రల సేవకుడు యోసేపును గూర్చి మర్చిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","రెండు సంవత్సరాల తర్వాత ఫరోకు ఒక కల వచ్చింది. ఫరో నైలునది ప్రక్కగా నిలబడినట్టు అతనికి కల వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","అప్పుడు ఏడు ఆవులు నదిలోనుంచి బయటకు రావటం ఫరో చూశాడు. ఆవులు బలిసి అందంగా ఉన్నాయి. ఆవులు అక్కడ నిలబడి గడ్డి తింటున్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","అప్పుడు ఇంక ఏడు ఆవులు నదిలోనుంచి బయటకు వచ్చాయి. కానీ ఈ ఆవులు చిక్కిపోయి, బక్కగా ఉన్నాయి. అందంగా ఉన్న ఏడు ఆవుల ప్రక్కగా ఈ ఏడు ఆవులు నిలబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","అసహ్యంగా ఉన్న ఏడు ఆవులు అందంగా బలిసి ఉన్న ఏడు ఆవులను తినివేసాయి. అంతలో ఫరో మేల్కొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","ఫరో మరల నిద్రపోగా రెండవసారి కల వచ్చింది. ఒకే ధాన్యపు మొక్కకు ఏడు వెన్నులు పెరగటం అతడు తన కలలో చూశాడు. ఆ ధాన్యపు గింజలు బలంగా, బాగుండటం అతడు చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","తర్వాత అదే ధాన్యపు మొక్కకు మరో ఏడు వెన్నులు పెరగటం అతడు చూశాడు. అయితే ఈ వెన్నులు పీలగా ఉండి, వేడి గాడ్పులకు పాడైపోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","అప్పుడు పీలగా ఉన్న వెన్నులు, బలంగా బాగున్న వెన్నులను తినివేసాయి. ఫరోకు మరల మెళుకువ వచ్చింది. అదంతా కల మాత్రమేనని ఫరో గ్రహించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","మర్నాడు ఉదయం ఆ కలల విషయమై ఫరోకు కలవరం కలిగింది. కనుక అతడు ఈజిప్టులోని మంత్రగాళ్లందరిని పిలిపించాడు. విద్వాంసులందరిని అతడు పిలిపించాడు. ఆ కలను గూర్చి ఫరో వాళ్లతో చెప్పాడు. అయితే వాళ్లలో ఒక్కడు కూడా ఆ కలను వివరించలేక పోయారు. దాని భావం చెప్పలేకపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","అప్పుడు ద్రాక్షాపాత్రల సేవకునికి యోసేపు జ్ఞాపకం వచ్చాడు. ఆ సేవకుడు ఫరోతో ఇలా చెప్పాడు: “నాకు జరిగిన ఒక విషయం జ్ఞాపకం వస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","నా మీద, మరో సేవకుని మీద తమరికి కోపం వచ్చింది. మీరు మమ్మల్ని చెరసాలో వేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","చెరసాలలో మా యిద్దరికీ ఒకే రాత్రి కల వచ్చింది. ఒక్కో కలకు ఒక్కో అర్థం ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","హెబ్రీ యువకుడు ఒకడు మాతో బాటు ఆ చెరసాలలోనే ఉన్నాడు. రాజు సంరక్షక ధళాధిపతికి అతడు సేవకుడు. మేము మా కలలు అతనితో చెబితే, అతడు వాటిని మాకు వివరించాడు. ఒక్కో కల అర్థం అతడు మాకు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","అతడు చెప్పిన అర్థాలు సత్యం. నాకు విడుగల అవుతుందని, నా పాత ఉద్యోగం మళ్లీ నాకు లభిస్తుందని అతడు నాకు చెప్పాడు. అది సత్యమే. వంటల పెద్ద మరణిస్తాడని అతడు చెప్పాడు, అదీ సత్యమే.” ");
INSERT INTO tel2010_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","కనుక ఫరో చెరసాలలోనుంచి యోసేపును పిలిపించాడు. సంరక్షకులు వెంటనే యోసేపును చెరసాలలోనుంచి తీసుకొని వచ్చారు. యోసేపు క్షవరం చేసుకొని శుభ్రమైన బట్టలు వేసుకొన్నాడు. అప్పుడు అతడు వెళ్లి ఫరో ముందర నిలవబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","అప్పుడు ఫరో “నాకో కల వచ్చింది, అయితే ఆ కలను నాకు వివరించగల వాళ్లు ఒక్కళ్లూ లేరు. ఎవరైనా వారి కల నీతో చెబితే నీవు వాటిని వివరించి, భావంకూడ చెప్పగలవని నేను విన్నాను” అని యోసేపుతో అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","యోసేపు, “కలలను గ్రహించటంలో నా నైపుణ్యం ఏమీ లేదు. ఆ శక్తి దేవుడికే ఉంది. కనుక దేవుడే ఫరోకు గూడ ఈ పని చేసి పెడ్తాడు” అని జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","అప్పుడు ఫరో యోసేపుతో చెప్పాడు: “నా కలలో నేను నైలునది పక్కగా నిలబడ్డాను. ");
INSERT INTO tel2010_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ఆ నదిలోనుంచి ఏడు ఆవులు బయటకు వచ్చి గడ్డి మేయటం నేను చూశాను. ఈ ఆవులు బలిసి, అందంగా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","అప్పుడు మరో ఏడు ఆవులు నదిలో నుంచి రావటం నేను చూశాను. ఈ ఆవులు బక్కచిక్కి రోగిష్టివిగా ఉన్నాయి. ఈజిప్టు దేశం మొత్తంలో నేను చూసిన ఆవుల్లో అవి పరమ అసహ్యంగా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","అసహ్యమైన ఈ ఏడు ఆవులు ముందు వచ్చిన అందమైన ఏడు ఆవులను తినివేసాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","అయితే ఆ ఏడు ఆవులను తినివేసిన తర్వాత కూడ అవి ఇంకా బక్కచిక్కి ఉన్నాయి. వాటిని చూస్తే, అవి ఏడు ఆవులను తిన్న వాటిల్లాగ అగుపించవు. ముందు అవి ఎంత బక్కగా అసహ్యంగా ఉన్నాయో యిప్పుడూ అలానే కనబడ్డాయి. అప్పుడు నేను మేల్కొన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“తర్వాత నాకు వచ్చిన మరో కలలో ఒకే ధాన్యపు మొక్కకు ఏడు వెన్నులు పెరగటం నేను చూశాను. ఆ వెన్నులు నిండుగా, చక్కగా, అందంగా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","తర్వాత వాటికి యింకా ఏడు వెన్నులు పెరిగాయి. కానీ ఆ వెన్నులు పీలగా, అసహ్యంగా ఉండి, వేడి గాడ్పులకు పాడైపోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","అప్పుడు ఏడు మంచి వెన్నులను పీల వెన్నులు తినివేసాయి. “మంత్రాలు తెలిసిన నా మనుష్యులకు, విద్వాంసులకు నేను ఈ కల చెప్పాను. కానీ ఎవ్వరూ ఆ కలను వివరించలేక పోతున్నారు. ఏమిటి దీని భావం?” ");
INSERT INTO tel2010_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","అప్పుడు ఫరోతో యోసేపు ఇలా చెప్పాడు: “ఈ రెండు కలల భావం ఒక్కటే. ఏమి చేయనున్నాడో అది దేవుడు మీతో చెబతున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ఏడు మంచి ఆవులు ఏడు సంవత్సరాలు. ఏడు మంచి ధాన్యపు వెన్నులు ఏడు సంవత్సరాలు. రెండు కలల్లోని సంగతి ఒక్కటే. ");
INSERT INTO tel2010_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","బక్కచిక్కి ఉన్న ఏడు ఆవులు, పీలగా ఉన్న ఏడు ధాన్యపు వెన్నులు కూడ, ఏడు అంటే, అవి ఈ దేశంలో ఏడు ఆకలి సంవత్సరాలు. ఏడు మంచి సంవత్సరాల తర్వాత ఈ ఏడు సంవత్సరాలు వస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","త్వరలో ఏమి జరుగుతుందో దాన్ని దేవుడు మీకు చూపెట్టాడు. నేను చెప్పినట్టే ఇది జరుగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","ఈజిప్టు దేశమంతటా ఏడేళ్లపాటు మంచి పంటలు పండి తినటానికి సమృద్ధిగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","అయితే ఆ ఏడు సంవత్సరాల తర్వాత, దేశమంతటా కరువు సంవత్సరాలు ఏడు వస్తాయి. ఈజిప్టులో పండిన పంట ఎంత ఉన్నదానిని మరచిపోతారు. ఈ ఆకలి దేశాన్ని నాశనం చేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","సమృద్ధగా భోజనం చేయటం అంటే ఏమిటో ప్రజలు మరచిపోతారు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","“ఫరోగారూ, ఒకే విషయాన్ని గూర్చి మీకు రెండు కలలు ఎందుకు వచ్చాయి? దేవుడు తప్పక జరిపిస్తాడని చూపించేందుకు ఇలా జరిగింది. అదీ త్వరలోనే దేవుడు జరిగిస్తాడని సూచిస్తోంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","కనుక ఓ ఫరో, చాలా తెలివి, జ్ఞానం ఉన్న ఒక మనిషిని మీరు ఏర్పాటు చేసుకోవాలి. ఆ మనిషిని ఈజిప్టు దేశం అంతటిమీద అధికారిగా మీరు నియమించాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ఆ తర్వాత ప్రజల దగ్గర్నుండి ధాన్యం సేకరించేందుకు మరి కొందర్ని మీరు నియమించాలి. ప్రతీ వ్యక్తి ఏడు మంచి సంవత్సరాల్లో పండించే మంచి పంటలో అయిదవ భాగం ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","రాబోయే మంచి సంవత్సరాల కాలంలో ఈ ధాన్యం అంతా సేకరించమని ఈ మనుష్యులకు ఆజ్ఞాపించండి. ఈ ధాన్యం పట్టణాల్లో భద్రం చేయటానికి వాళ్లకు అధికారం ఉందని ఈ మనుష్యులకు చెప్పండి. తర్వాత ఆ ధాన్యం అవసరం వచ్చేంతవరకు వారు దాన్ని కాపాడాలి. ఫరో! ఈ విధంగా ఆ ఆహారం మీ అధీనంలో ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ఈజిప్టు దేశంలో వచ్చే ఏడు ఆకలి సంవత్సరాల్లో ఈ ధాన్యం సహాయపడుతుంది. అప్పుడు ఈజిప్టు ప్రజలు ఆ ఏడు సంవత్సరాల్లో కరువు కారణంగా మరణించరు.” ");
INSERT INTO tel2010_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ఇది చాలా చక్కని తలంపులా కనబడింది ఫరోకు. అతని సేవకులంతా ఒప్పుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","“ఈ పని చేసేందుకు యోసేపు కంటే మంచివాడ్ని ఇంకెవరినైనా మీరు కనుగొనగలరా? దేవుని ఆత్మ మూలంగా ఇతడు నిజంగా జ్ఞాని” అని ఫరో తన సేవకులతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","కనుక ఫరో, “వీటన్నింటిని దేవుడే నీకు చూపెట్టాడు కనుక నీవు అందరిలో మహా జ్ఞానివై ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","అంచేత నిన్నే ఈ దేశం మీద అధిపతిగా నేను చేస్తాను. ప్రజలు నీ ఆజ్ఞలన్నింటికి విధేయులవుతారు. ఈ దేశంలో నేను ఒక్కడ్ని మాత్రమే నీకంటె గొప్ప అధికారిగా ఉంటాను” అని యోసేపుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","(ఫరో యోసేపును రాజ్యపాలకునిగా నియమించినప్పుడు ప్రత్యేక సమావేశం మరియు ఊరేగింపు వుండినవి.) అప్పుడు ఫరో, “ఇప్పుడు ఈజిప్టు దేశం అంతటి మీద నిన్ను నేను పాలకునిగా నియమిస్తున్నాను” అని యోసేపుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","అప్పుడు ఫరో రాజముద్రగల తన ఉంగరాన్ని యోసేపుకు ఇచ్చాడు. యోసేపు ధరించటానికి నాణ్యతగల ఒక అంగీని అతడు ఇచ్చాడు. యోసేపు మెడలో ఒక బంగారు గొలుసు ఫరో వేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","రెండో రాజరథం మీద తిరిగమని ఫరో యోసేపుతో చెప్పాడు. ప్రత్యేక సంరక్షకులు అతని రథానికి ముందర నడిచారు. “ప్రజలారా, యోసేపుకు సాష్టాంగపడండి” అంటూ వాళ్లు ప్రజలను హెచ్చరించారు. కనుక ఈజిప్టు దేశం అంతటి మీద యోసేపు పాలకునిగా నియమించబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","అతనితో ఫరో అన్నాడు: “నేను ఫరోను అంటే రాజును. కనుక నేను ఏమి అయినా చేయాలనుకొంటే అది చేస్తాను. కానీ, ఈజిప్టులో మరి ఏ వ్యక్తి అయినా నీవు చెప్పకుండ ఒక చేయి ఎత్తకూడదు, కాలు కదపగూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","యోసేపుకు జప్నత్సనేహు అనే మరో పేరు ఫరో పెట్టాడు. ఓను యాజకుడు పోతీఫెర కుమార్తె ఆసెనతును యోసేపుకు భార్యగా ఫరో ఇచ్చాడు. కనుక ఈజిప్టు దేశం అంతటిమీద యోసేపు పాలకుడయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","యోసేపు ఈజిప్టు రాజు కొలువులో పని చేయడం మొదలు బెట్టినప్పుడు అతని వయస్సు 30 సంవత్సరాలు. యోసేపు ఈజిప్టు దేశం అంతటా సంచారం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ఏడు మంచి సంవత్సరాల కాలంలోనూ దేశంలో పంటలు బాగుగా పండాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ఆ ఏడు సంవత్సరాల్లో యోసేపు చాలా ధాన్యం ఈజిప్టులో పొదుపు చేసాడు. ఆహారాన్ని యోసేపు పట్టణాల్లో భద్రపరచాడు. ప్రతి పట్టణం చుట్టు ప్రక్కల పండిన పంటను ఆ పట్టణంలోనే యోసేపు భద్రపరచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","యోసేపు విస్తారంగా ధాన్యం చేర్చి పెట్టాడు. సముద్రపు ఇసుకలా ఉంది అదంతాను. కొలిచేందుకు గూడ వీలు లేనంత విస్తారంగా ఉంది అతడు చేర్చిపెట్టిన ధాన్యం. ");
INSERT INTO tel2010_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ఓను యాజకుడైన పోతీఫెర కుమార్తె అయిన ఆసెనతు యోసేపుకు భార్య. మొదటి ఆకలి సంవత్సరం రాకముందే యోసేపు ఆసెనెతులకు ఇద్దరు కుమారులు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","మొదటి కుమారుని పేరు మనష్షే. “నా కష్టాలు అన్నింటినీ, నా ఇంటని గూర్చిన విషయాలన్నింటినీ నేను మరచిపోయేటట్టు దేవుడు చేసాడు” అని అనుకొన్నాడు గనుక యోసేపు అతనికి ఈ పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","యోసేపు తన రెండవ కుమారునికి ఎఫ్రాయిము అని పేరు పెట్టాడు. “నాకు ఎన్నో గొప్ప కష్టాలు వచ్చాయి, గాని అన్ని విషయాల్లో దేవుడు నాకు సాఫల్యాన్ని కార్యసాధనను కల్గించాడు” అని యోసేపు అనుకొన్నాడు గనుక యోసేపు అతనికి ఈ పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ఏడు సంవత్సరాల పాటు ప్రజలు తినేందుకు అవసరమైన ఆహారం అంతా వారికి ఉంది. కానీ సంవత్సరాలన్నీ ముగిశాయి. అవసరమైనది అంతా పండింది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","అయితే ఏడు సంవత్సరాల ఆకలి కాలం మొదలయింది. సరిగ్గా యోసేపు చెప్పినట్టే ఇది జరిగింది. అన్ని దేశాలలో, అంతట ఏ ఆహారం పండలేదు. తినుటకు ప్రజలకు ఏమీ లేదు. కానీ యోసేపు ధాన్యం భద్రపరచినందువల్ల ఈజిప్టులో ప్రజలు తినుటకు సరిపడినంత ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","కరువు కాలం ప్రారంభం కాగానే ఆహారంకోసం ప్రజలు ఫరోకు మొరపెట్టారు. ఫరో, “యోసేపును అడగండి. అతడు ఏమి చేయమంటే అలా చేయండి” అని చెప్పాడు ఈజిప్టు ప్రజలతో. ");
INSERT INTO tel2010_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","కనుక ఆ దేశంలో ఎక్కడ చూసినా కరువు ప్రబలుతున్నప్పుడు, ధాన్యము భద్రపరచిన గదులలో నుండి యోసేపు ప్రజలకు ధాన్యం ఇచ్చాడు. చేర్చిపెట్టిన ధాన్యం ఈజిప్టు ప్రజలకు యోసేపు విక్రయించాడు. ఈజిప్టులో కరువు చాలా భయంకరంగా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ఈజిప్టు చుట్టుపక్కల దేశాల ప్రజలంతా ధాన్యం కొనేందుకు ఈజిప్టు వచ్చారు. కరువు ఈజిప్టులోను, మరి యితర ప్రాంతాలలోను ఎక్కువగా ఉంది. ఈజిప్టు చుట్టుపక్కల దేశాలవారు యోసేపు దగ్గరకు వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ఈ సమయంలో కనాను దేశంలోను కరువు ప్రబలుతోంది. అయితే ఈజిప్టులో ధాన్యం ఉన్నట్టు యాకోబు తెలుసుకొన్నాడు: కనుక యాకోబు తన కుమారులతో ఇలా చెప్పాడు. “ఏమీ చేయకుండా ఇక్కడ ఎందుకు మనం కూర్చోవటం? ");
INSERT INTO tel2010_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","ఈజిప్టులో అమ్మకానికి ధాన్యం ఉన్నట్టు నేను విన్నాను. అందుచేత మనం అక్కడికి వెళ్లి మనం తినేందుకు ధాన్యం కొనుక్కోవాలి. అప్పుడు మనం చావకుండా బతుకుతాం.” ");
INSERT INTO tel2010_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","కనుక యోసేపు సోదరులు పదిమంది ధాన్యం కొనేందుకు ఈజిప్టు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","బెన్యామీనును యాకోబు పంపలేదు. (బెన్యామీను ఒక్కడే యోసేపుకు స్వంత తమ్ముడు). బెన్యామీనుకు ఏదైనా కీడు సంభవిస్తుందేమోనని యాకోబు భయపడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","కనానులో కరువు కాలం చాలా దారుణంగా ఉంది. ధాన్యం కొనుగోలు చేసేందుకు ఎంతోమంది ప్రజలు కనానునుండి ఈజిప్టు వెళ్లారు. వారిలో ఇశ్రాయేలు కుమారులు కూడ ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ఆ సమయంలో ఈజిప్టు అంతటి మీద యోసేపు పాలకుడు. ఈజిప్టుకు వచ్చిన ప్రజలకు ధాన్యం అమ్మకం చేసేందుకు గాను నియమింపబడిన అధికారి యోసేపు. అయితే యోసేపు సోదరులు అతని దగ్గరకు వచ్చి అతని ఎదుట సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","యోసేపు తన సోదరులను చూసాడు, వారెవరయిందీ అతనికి తెలుసు, కానీ యోసేపు వారిని ఎరుగనట్టే వారితో మాట్లాడాడు. అతడు వారితో కఠినంగా మాట్లాడాడు. “ఎక్కడనుండి వచ్చారు మీరు?” అని అతడు అడిగాడు. ఆ సోదరులు “మేము కనాను దేశంనుండి వచ్చాం. ఆహారం కొనేందుకు మేము వచ్చాం” అని జవాబిచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ఈ మనుష్యులు తన సోదరులని యోసేపుకు తెలుసును. కానీ అతను ఎవరయిందీ వారికి తెలియదు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","అతని అన్నల విషయంలో అతనికి వచ్చిన కలలను యోసేపు జ్ఞాపకం చేసుకొన్నాడు. యోసేపు తన అన్నలతో, “మీరు ఆహారం కొనేందుకు రాలేదు. మీరు గూఢచారులు. మా బలహీనతలు తెలుసుకొనేందుకే మీరు వచ్చారు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","అయితే ఆ సోదరులు, “లేదండి అయ్యా, మీ సేవకులంగా మేము వచ్చాం. ఆహారం కొనేందుకు మాత్రమే మేం వచ్చాం. ");
INSERT INTO tel2010_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","మేమంతా అన్నదమ్మలం మా అందరి తండ్రి ఒక్కడే. మేము నిజాయితీగల మనుష్యులం, మేము గూఢచారలం కాము. ఆహారం కొనేందుకు మాత్రమే మేం వచ్చాం” అని అతనితో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","అప్పుడు యోసేపు, “లేదు, లేదు, ఏ విషయంలో మేం బలహీనులమో తెలుసుకొనేందుకే మీరు వచ్చారు” అన్నాడు వారితో. ");
INSERT INTO tel2010_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","ఆ సోదరులు అన్నారు: “లేదు, మేమంతా అన్నదమ్ములం. మా కుటుంబంలో మొత్తం పన్నెండుమంది సోదరులం. మా అందరికీ తండ్రి ఒక్కడే. మా అందరిలో చిన్న తమ్ముడు ఇంకా ఇంటి దగ్గర మా తండ్రితోనే ఉన్నాడు. మరో తమ్ముడు చాలకాలం క్రిందటే చనిపోయాడు. మీ ముందర మేం సేవకుల్లాంటి వాళ్లం. మేము కనాను దేశం వాళ్లం.” ");
INSERT INTO tel2010_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","అయితే యోసేపు వారితో ఇలా అన్నాడు: “లేదు, నేను అన్నదే సరియైనట్టు నాకు తెలుస్తోంది. మీరు గూఢచారులు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","అయితే మీరు సత్యమే చెబతున్నట్టు మిమ్మల్ని రుజువు చేయనిస్తాను. మీ చిన్నతమ్ముడు ఇక్కడికి వచ్చేంతవరకు మిమ్మల్ని వదలి పెట్టనని ఫరో పేరు మీద ప్రమాణం చేసి చెబతున్నాను మిమ్మల్ని వదలిపెట్టనని. ");
INSERT INTO tel2010_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","కనుక మీలో ఒకరు తిరిగి వెళ్లి మీ చిన్న తమ్ముడ్ని ఇక్కడికి తీసుకొని రావాలి. అంతవరకు మిగిలిన వారు ఇక్కడే జైల్లో ఉండాలి. మీరు సత్యం చెబతున్నారో లేదో మేం చూస్తాం. అయితే మీరు గూఢచారులనే నా నమ్మకం.” ");
INSERT INTO tel2010_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","తర్వాత యోసేపు వాళ్లందర్నీ మూడు రోజుల పాటు చెరసాలలో పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","మూడు రోజుల తర్వాత వారితో యోసేపు ఇలా అన్నాడు, “నేను దేవునికి భయపడేవాణ్ణి. అంచేత మీరు సత్యమే చెబతున్నారని రుజువు చేసేందుకు మీకు ఒక అవకాశం ఇస్తాను. ఇలా మీరు చేస్తే నేను మిమ్మల్ని బతకనిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","మీరు నమ్మకమైన మనుష్యులైతే, మీ సోదరులలో ఒకరు ఇక్కడ జైల్లో ఉండాలి. మిగిలినవారు మీ వాళ్లకోసం ధాన్యం తీసుకొని వెళ్లవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","అప్పుడు మీ చిన్న తమ్ముడ్ని ఇక్కడికి తీసుకొని రండి. ఈ విధంగా, మీరు సత్యం చెబతున్నారేమో నేను తెలుసుకొంటాను.” ఆ సోదరులు దీనకి ఒప్పుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","“మన చిన్న తమ్ముడికి మనం చేసిన కీడు మూలంగా శిక్ష అనుభవిస్తున్నాం. అతడు కష్టంతో ఉండటం మనం కళ్లారా చూశాం. రక్షించమని అతడు మనల్ని బతిమలాడాడు. కానీ వినటానికి గూడ మనం నిరాకరించాం. అందుకే ఇప్పుడు మనం కష్టపడుతున్నాం” అని వాళ్లలో వారు చెప్పుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","అప్పుడు రూబేను, “ఆ పిల్లవానికి మీరేమి కీడు చేయకండి అని నేను మీతో చెప్పాను కాని మీరు నా మాట వినకపోయారు. కనుక అతని మరణం మూలంగానే ఇప్పుడు మనం శిక్ష పొందుతున్నాం,” అని వాళ్లతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","యోసేపు తన సోదరులతో మాట్లాడేందుకు ఒక అనువాదకుడ్ని వాడుకొన్నాడు. అందుచేత వారి భాష యోసేపు గ్రహించినట్లు ఆ సోదరులకు తెలియదు. కానీ వారు చెప్పిన ప్రతి మాటా యోసేపు విని, గ్రహించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","వారి మాటలు యోసేపుకు చాలా దుఃఖం కలిగించాయి. అందుచేత యోసేపు వాళ్లను విడిచి వెళ్లి ఏడ్చేసాడు. కొంచెం సేపయ్యాక యోసేపు మళ్లీ వాళ్ల దగ్గరకు వెళ్లాడు. అతడు ఆ సోదరులలో ఒకడైన షిమ్యోనును పట్టుకొని మిగిలిన సోదరులు చూస్తుండగానే కట్టివేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","వారి సంచులను ధాన్యంతో నింపమని కొందరు సేవకులతో యోసేపు చెప్పాడు. ఈ ధాన్యం కోసం ఆ సోదరులు యోసేపుకు సొమ్ము చెల్లించారు. కానీ యోసేపు ఆ డబ్బు ఉంచుకోలేదు. ఆ డబ్బును తిరిగి వారి సంచుల్లోనే పెట్టేసాడు యోసేపు. అప్పుడు వారి ప్రయాణానికి అవసరమైన వాటన్నింటిని యోసేపు వారికి ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","కనుక ఆ సోదరులు ఆ ధాన్యం గాడిదలమీద వేసుకొని వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","ఆ సోదరులు ఆ రాత్రి ఒకచోట బస చేసారు. ఆ సోదరులలో ఒకడు కొంచెం ధాన్యం తన గాడిద కోసమని తన సంచి తెరిచాడు. అతని డబ్బు అతని సంచిలోనే కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","అతడు, “చూడండి, ధాన్యంకోసం నేను చెల్లించిన డబ్బు ఇదిగో. ఈ డబ్బును ఎవరో మళ్లీ నా సంచిలో పెట్టేసారు” అని మిగతా సోదరులతో చెప్పాడు. ఆ సోదరులకు చాలా భయం వేసింది, “దేవుడు మనకు ఏం చేస్తున్నాడు?” అని ఒకరితో ఒకరు చెప్పుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","ఈ సోదరులు కనాను దేశంలో ఉన్న తమ తండ్రి యాకోబు దగ్గరకు వెళ్లారు. జరిగిన విషయాలన్నీ యాకోబుతో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","వాళ్లు ఇలా చెప్పారు: “ఆ దేశ పాలకుడు మాతో కఠినంగా మాట్లాడాడు. మేము అక్కడి ప్రజల్ని నాశనం చేయాలనుకొనే గూఢచారులమని అనుకొన్నాడు అతడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","కానీ మేము నిజాయితీపరలం అని, గూఢచారులకు చెందినవాళ్లం కాదని మేము చెప్పాం. ");
INSERT INTO tel2010_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","మేము పన్నెండుమంది సోదరులం అని చెప్పాం. కనానులో ఇంటి దగ్గర మా తండ్రితో మా చిన్న తమ్ముడు ఒకడు ఉన్నాడని మరియు మా మరియొక చిన్న తమ్ముడు ఒకడు చనిపోయాడని మేము అతనితో చెప్పాం. ");
INSERT INTO tel2010_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“అప్పుడు, ఆ దేశపాలకుడు మాతో ఇలా అన్నాడు: ‘మీరు నమ్మకమైన వాళ్లని రుజువు చేయటానికి ఇదొక మార్గం. మీ సోదరులలో ఒకడ్ని నా దగ్గర ఉంచండి. మీ ధాన్యం మీ కుటుంబాలకు తీసుకొని వెళ్లండి. ");
INSERT INTO tel2010_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","తర్వాత మీ కనిష్ఠ సోదరుడ్ని నా దగ్గరకు తీసుకొని రండి. అప్పుడు నిజంగా మీరు నిజాయితీపరులో, లేక మమ్మల్ని నాశనం చేసేందుకు పంపబడిన గూఢచారులో నాకు తెలుస్తుంది. మీరు చెప్పేది నిజమైతే మీ సోదరుడ్ని మళ్లీ మీకు అప్పగిస్తాను. అతణ్ణి మీకు అప్పగిస్తాను, మా దేశంలో మీరు స్వేచ్ఛగా ధాన్యం కొనుక్కోవచ్చు.’” ");
INSERT INTO tel2010_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","అప్పుడు ఆ సోదరులు వారి సంచుల్లో నుండి ధాన్యం తీయటానికి వెళ్లగా వారిలో ప్రతి సోదరునికి తన ధాన్యపు సంచిలో తన డబ్బు సంచి కనిపించింది. ఆ సోదరులు, వారి తండ్రి కూడ ఆ డబ్బును చూచి చాలా భయపడిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","యాకోబు, “నేను నా పిల్లలందర్నీ పోగొట్టకోవాలని మీరు అనుకొంటున్నారా? యోసేపు పోయాడు. షిమ్యోను పోయాడు. ఇప్పుడు బెన్యామీనును గూడ మీరు తీసుకొని పోవాలనుకొంటున్నారు” అని వాళ్లతో అన్నాడు, ");
INSERT INTO tel2010_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","అప్పుడు రూబేను, “నాయనా, బెన్యామీనును గనుక నేను తిరిగి నీ దగ్గరకు తీసుకొని రాకపోతే, నా ఇద్దరు కుమారులను నీవు చంపేసేయ్. నన్ను నమ్ము. బెన్యామీనును నేను మళ్లీ నీ దగ్గరకు తీసుకొని వస్తాను” అని తన తండ్రితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","అయితే యాకోబు చెప్పాడు: “బెన్యామీనును మీతో నేను వెళ్లనివ్వను. అతని సోదరుడు మరణించాడు, నా భార్య రాహేలు కుమారులలో ఇతను ఒక్కడే మిగిలాడు. ఈజిప్టు ప్రయాణంలో ఇతనికి ఏమైనా సంభవిస్తే నేను చచ్చిపోతాను. నా వృద్ధాప్యంలో దుఃఖంతోనే మీరు నన్ను సమాధికి పంపిస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","దేశంలో కరువు చాలా దారుణంగా ఉంది. అక్కడ ఎలాంటి ఆహారం పండటం లేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ప్రజలు ఈజిప్టునుండి తెచ్చుకొన్న ధాన్యం అంతా తినేసారు. ధాన్యం అయిపోయినప్పుడు, “మళ్లీ ఈజిప్టు వెళ్లి, మనం తినేందుకు మరింత ధాన్యం కొనండి” అని యాకోబు తన కుమారులతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","అయితే యాకోబుతో యూదా చెప్పాడు: “ఆ దేశ పాలకుడు మమ్మల్ని హెచ్చరించాడు. మీ సోదరుడ్ని మీరు నా దగ్గరకు తీసుకొని రాకపోతే నేను మీతో మాట్లాడను. ");
INSERT INTO tel2010_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","బెన్యామీనును నీవు మాతో పంపిస్తేనే మేము వెళ్లి ధాన్యం కొంటాం. ");
INSERT INTO tel2010_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","కానీ బెన్యామీనును పంపించేందుకు నీవు ఒప్పుకొనకపోతే మేం వెళ్లం. అతడు లేకుండా తిరిగి రావద్దని ఆయన మమ్మల్ని హెచ్చరించాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","“మీకు ఇంకో సోదరుడు ఉన్నాడని అసలు మీరెందుకు చెప్పారు? ఇంత కీడు మీరెందుకు నాకు చేసారు?” ఇశ్రాయేలు (యాకోబు) అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","ఆ సోదరులు జవాబు చెప్పారు: “ఆ మనిషి మమ్మల్ని అనేక ప్రశ్నలు వేశాడు. మా విషయం, మా కుటుంబం విషయం అతడు తెలుసుకోవాలనుకున్నాడు, ‘మీ తండ్రి ఇంకా బతికే ఉన్నాడా? ఇంటి దగ్గర మీకు ఇంకో సోదరుడు ఉన్నాడా?’ అని అతడు మమ్మల్ని అడిగాడు. అతని ప్రశ్నలకు మాత్రమే మేము జవాబిచ్చాం. మా మిగిలిన సోదరుని కూడ తన దగ్గరకు తీసుకొని రమ్మంటాడని మాకు తెలియదు!” ");
INSERT INTO tel2010_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","అప్పుడు యూదా తన తండ్రి ఇశ్రాయేలుతో ఇలా చెప్పాడు: “బెన్యామీనును నాతో పంపించు. అతని విషయం నేను జాగ్రత్తగా చూసుకొంటాను. మేము మాత్రం ఈజిప్టు వెళ్లాలి, ఆహారం తీసుకురావాలి. మేము వెళ్లకపోతే మనమూ, మన పిల్లలు అందరం చస్తాం. ");
INSERT INTO tel2010_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","అతని క్షేమం నేను చూసుకొంటాను. అతని భాద్యత నాది. అతణ్ణి నేను తిరిగి నీ దగ్గరకు తీసుకొని రాకపోతే శాశ్వతంగా నీవు నన్ను నిందించవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","నీవు మమ్మల్ని వెళ్లనిచ్చి ఉంటే ఇప్పటికి రెండు సార్లు వెళ్లి వచ్చే వాళ్లం.” ");
INSERT INTO tel2010_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","అప్పుడు వారి తండ్రి ఇశ్రాయేలు అన్నాడు: “ఇదే గనుక నిజంగా సత్యమైతే, అలాగే బెన్యామీనును నీతే తీసుకొని వెళ్లు. అయితే ఆ పాలకునికి కానుకలు తీసుకొని వెళ్లు. మన దేశంలో మనం సంపాదించగలిగినవి కొన్ని తీసుకొని వెళ్లు. కొంచె మస్తకి, కొంచెం తేనె, సుగంధద్రవ్యాలు, బోళం, పిస్తాచ కాయలు, బాదం కాయలు, అతనికి తీసుకొని వెళ్లండి. ");
INSERT INTO tel2010_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","ఈ సారి రెండంతల డబ్బు మీతో తీసుకు వెళ్లండి. పోయిన సారి మీరు చెల్లించగా తిరిగి మీకు ఇవ్వబడిన సొమ్ము మళ్లీ తీసుకు వెళ్లండి. ఒకవేళ ఆ పాలకుడు పొరబడ్డాడేమో. ");
INSERT INTO tel2010_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","బెన్యామీనును తీసుకొని ఆ మనిషి దగ్గరకు తిరిగి వెళ్లు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","మీరు ఆ పాలకుని ముందర నిలిచినప్పుడు సర్వశక్తిమంతుడైన దేవుడు మీకు సహాయం చేయాలని నేను ప్రార్థన చేస్తాను. బెన్యామీను, షిమ్యోనులను అతడు క్షేమంగా తిరిగి వెళ్లనిచ్చేటట్టు నేను ప్రార్థన చేస్తాను. లేనట్లయితే నా కుమారుని పోగొట్టుకొని నేను మరల దుఃఖంలో మునిగిపోతాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","కనుక ఆ పాలకుని కోసం కానుకలన్నీ తీసుకొన్నారు ఆ సోదరులు. వారు మొదటిసారి తీసుకొని వెళ్లిన దానికి రెట్టింపు సొమ్ము వారితో కూడా తీసుకొని వెళ్లారు. బెన్యామీను ఆ సోదరులతో కలసి ఈజిప్టు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ఈజిప్టులో, వారితోబాటు బెన్యామీను ఉండటం యోసేపు చాశాడు. యోసేపు “ఆ మనుష్యుల్ని నా ఇంటికి తీసుకొని రండి. ఒక పశువును చంపి వంట చేయండి. ఈవేళ మధ్యాహ్నం వాళ్లు నాతోనే భోజనం చేస్తారు” అని తన గృహనిర్వాహకునితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","అతను చెప్పినట్టే ఆ సేవకుడు చేసాడు. అతడు వాళ్లను యోసేపు ఇంటికి తీసుకొని వచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","వాళ్లు యోసేపు ఇంటికి తీసుకొని రాబడినప్పుడు ఆ సోదరులు భయపడ్డారు. “పోయినసారి మన సంచుల్లో డబ్బు ఉంచబడ్డందువల్లనే మనల్ని ఇక్కడకు తీసుకు వచ్చారు. మనల్ని నేరస్తులుగా నిరూపించటానికి దాన్ని వారు వినియోగిస్తారు. తర్వాత మన గాడిదల్ని దొంగిలించి, మనల్ని బానిసలుగా చేస్తారు” అని వారనుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","కనుక యోసేపు ఇంటికి బాధ్యుడైన వాని దగ్గరకు ఆ సోదరులు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","వారు చెప్పారు: “అయ్యా, ప్రమాణం చేసి సత్యం చెబతున్నాం. పోయినసారి మేము వచ్చినప్పుడు ఆహారం కొనుగోలు చేసేందుకే మేం వచ్చాం. ");
INSERT INTO tel2010_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","ఇంటికి వెళ్తూ మార్గంలో మేము మా సంచులు విప్పితే మా ప్రతి ఒక్కరి సంచిలోనూ డబ్బు కనబడింది. ఆ డబ్బు అక్కడికి ఎలా వచ్చిందో మాకు తెలియదు. అయితే ఆ డబ్బు మళ్లీ మీకు ఇచ్చేయాలని ఇప్పుడు మాతో తెచ్చాం. పైగా ఇప్పుడు మేము కొనాలనుకొంటున్న ధాన్యంకోసం ఇంకా ఎక్కువ మొత్తంకూడ మళ్లీ ఇప్పుడు తెచ్చాం.” ");
INSERT INTO tel2010_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","అయితే ఆ సేవకుడు, “భయపడకండి, నన్ను నమ్మండి. మీ దేవుడు, మీ తండ్రి దేవుడు ఆ డబ్బును మీ సంచుల్లో కానుకగా పెట్టి ఉంటాడు. పోయిన సారి మీరు ధాన్యంకోసం డబ్బును మీరు నాకే చెల్లించినట్టు నాకు గుర్తు” అని వారితో చెప్పాడు. ఆ సేవకుడు షిమ్యోనును చెరసాలలోనుంచి బయటకు తీసుకొని వచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ఆ సేవకుడు వాళ్లందరిని యోసేపు ఇంటికి తీసుకొని వెళ్లాడు. అతడు వారికి నీళ్లు ఇస్తే, వాళ్లు కాళ్లు కడుక్కొన్నారు. తర్వాత అతడు వారి గాడిదలకు మేత పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","ఆ సోదరులు తాము యోసేపుతోబాటు భోంచేయబోతున్నట్టు విన్నారు. కనుక వారు అతనికోసం తెచ్చిన కానుకల్ని మధ్యాహ్నంవరకు సిద్ధం చేసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","యోసేపు ఇంటికి వచ్చాడు, ఆ సోదరులు వారితో తెచ్చిన కానుకలు అతనికి ఇచ్చారు. తర్వాత వారు నేలమీద సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","వారెలా ఉన్నారని యోసేపు వాళ్లను అడిగాడు, “మీరు నాతో చెప్పిన మీ ముసలి తండ్రి క్షేమంగా ఉన్నాడా? ఆయన ఇంకా బతికే ఉన్నాడా?” అన్నాడు యోసేపు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ఆ సోదరులు, “అయ్యా, మా తండ్రి బాగున్నాడు. ఆయన ఇంకా బతికి ఉన్నాడు” అని జవాబిచ్చారు. మళ్లీ వాళ్లంతా యోసేపు ముందర సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","అప్పుడు యోసేపు తన సోదరుడు బెన్యామీనును చూశాడు, (బెన్యామీను, యోసేపులు ఒక్క తల్లి పిల్లలు). “మీరు నాతో చెప్పిన మీ కనిష్ఠ సోదరుడు ఇతడేనా?” అని యోసేపు అడిగాడు. అప్పుడు యోసేపు, “కుమారుడా, దేవుడు నిన్ను ఆశీర్వదించు గాక!” అన్నాడు బెన్యామీనుతో. ");
INSERT INTO tel2010_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","అప్పుడు యోసేపు ఆ గదిలోనుంచి పరుగెత్తిపోయాడు. బెన్యామీను మీద తనకు ఉన్న ప్రేమను అతనికి చూపెట్టాలని యోసేపు ఎంతో ఆశించాడు. అతనికి ఏడ్చెయ్యాలనిపించింది గాని అతడు ఏడ్వటం అతని సోదరులు చూడకూడదు అనుకొన్నాడు. కనుక యోసేపు తన గదిలోనికి పెరుగెత్తి పోయి అక్కడ ఏడ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","తర్వాత యోసేపు తన ముఖం కడుక్కొని బయటకు వచ్చాడు. అతడు తనను తాను ఓదార్చుకొని, “భోజనానికి వేళ అయ్యింది” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ఆ సేవకులు యోసేపు ఒక్కడికి ఒక బల్ల దగ్గర వేరుగాను, సోదరులను మరో బల్ల దగ్గర వేరుగాను కూర్చుండబెట్టారు. వారితో భోంచేస్తున్న ఈజిప్టు వారిని వారి మట్టుకే ఒక బల్లదగ్గర కూర్చుండ బెట్టారు. ఈజిప్టువాళ్లు హీబ్రూవారితో కలిసి భోజనం చేయరు, అది ఈజిప్టు మత విరోధం. ");
INSERT INTO tel2010_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","యోసేపు సోదరులు అతనికి ఎదురుగా ఇంకో బల్ల దగ్గర కూర్చున్నారు. ఆ సోదరులు జ్యేష్ఠనితో మొదలుబెట్టి కనుష్ఠుని వరకు వరసక్రమంలో కూర్చున్నారు. జరుగుతున్నదంతా ఏమిటా అన్నట్టు అన్నదమ్ములంతా ఒకరి ముఖాలు ఒకరు చూసుకొంటున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","సేవకులు యోసేపు బల్లమీద నుంచే వారికి భోజనం వడ్డిస్తున్నారు. అయితే ఆ సేవకులు మిగిలిన వాళ్లకంటె అయిదు రెట్లు ఎక్కువగా బెన్యామీనుకు వడ్డించారు. ఆ సోదరులు దాదాపు మత్తెక్కినంత వరకు యోసేపుతో కలిసి తిని తాగారు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","అప్పుడు యోసేపు తన సేవకునికి ఒక ఆజ్ఞ ఇచ్చాడు: “ఈ మనుష్యులు మోసుకొని పోగలిగినంత ధాన్యం వారి సంచుల్లో నింపు. ప్రతి ఒక్కరి సొమ్మును తిరిగి వారి వారి ధాన్యపు సంచుల్లో పెట్టు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","అందరిలో చిన్న తమ్ముని సంచిలో డబ్బు పెట్టు. అయితే నా ప్రత్యేకమైన వెండి పాత్రనుకూడ అతని సంచిలో పెట్టు.” ఆ సేవకుడు యోసేపు చెప్పినట్టు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","మర్నాటి ఉదయాన్నే ఆ సోదరులు వారి గాడిదలతోబాటు వారి దేశం పంపించబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","వారు పట్టణం విడిచిన తర్వాత యోసేపు తన సేవకులతో చెప్పాడు: “నీవు వెళ్లి ఆ మనుష్యుల్ని వెంబడించు. వాళ్లను ఆపుజేసి మేము మీతో మంచిగా ఉన్నాం. అయినా మీరెందుకు మాతో చెడ్డగా ప్రవర్తిస్తున్నారు? మా యజమాని వెండి పాత్రను మీరెందుకు దొంగిలించారు? ");
INSERT INTO tel2010_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ఇది నా యజమాని యోసేపు పానం చేసే పాత్ర. రహస్య విషయాలను తెలుసుకొనేందుకు ఆయన ఉపయోగించే పాత్ర ఇది. ఆయన పాత్రను దొంగిలించి మీరు తప్పు చేసారు, అని వాళ్లతో చెప్పు.” ");
INSERT INTO tel2010_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","అందుచేత ఆ సేవకుడు విధేయుడయ్యాడు. అతడు సవారి చేసి ఆ సోదరులను ఆపుజేసాడు. అతడు చెప్పాల్సిందిగా యోసేపు అతనికి చెప్పిన విషయాలు ఆ సేవకుడు వారితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","అయితే ఆ సోదరులు ఆ సేవకునితో ఇలా అన్నారు: “ఆ పాలకుడు యిలా ఎందుకు అన్నాడు? అలాంటిదేమీ మేము చేయము. ");
INSERT INTO tel2010_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ఇంతకు ముందు మా సంచుల్లో మాకు దొరికిన డబ్బు మేం తెచ్చి ఇచ్చాం. అందుచేత మీ యజమాని ఇంటినుండి వెండి బంగారం ఏవీ మేము నిజంగా దొంగిలించం. ");
INSERT INTO tel2010_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","మాలో ఎవరి సంచిలోనైనా సరె ఆ వెండి పాత్ర నీకు కనబడితే, వాడు చావాల్సిందే. అతణ్ణి నీవు చంపేయి, మేము మీకు బానిసలమవుతాం.” ");
INSERT INTO tel2010_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“మీరు చెప్పినట్టే చేద్దాం. కాని నేను మాత్రం ఎవర్నీ చంపను. వెండి పాత్ర గనుక నాకు కనబడితే ఆ మనిషి మాత్రం నాకు బానిస అవుతాడు. మిగిలిన వాళ్లు స్వేచ్ఛగా వెళ్లొచ్చు” అన్నాడు ఆ సేవకుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","అప్పుడు ప్రతి ఒక్క సోదరుడూ తన సంచిని నేలమీద పెట్టి తెరిచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","సేవకుడు సంచుల్లో చూశాడు. అతడు జ్యేష్ఠునితో మొదలు బెట్టి కనిష్ఠునితో ముగించాడు. బెన్యామీను సంచిలో ఆ పాత్ర అతనికి కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","సోదరులకు దుఃఖం వచ్చేసింది. దుఃఖంతో వాళ్లు వారి వస్త్రాలు చింపేసుకొన్నారు. వారు వారి సంచుల్ని మళ్లీ గాడిదలమీద పెట్టి తిరిగి ఆ పట్టణం వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","యూదా, అతని సోదరులు యోసేపు ఇంటికి వెళ్లారు. యోసేపు ఇంకా అక్కడే ఉన్నాడు. ఆ సోదరులంతా నేలమీద సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","యోసేపు “మీరెందుకు ఇలా చేసారు? రహస్యాలు తెలుసుకొనే ఒక ప్రత్యేక పద్ధతి నా దగ్గర ఉందని మీకు తెలియదా? ఈ పని నాకంటె బాగగా ఇంకెవ్వరూ చేయలేరు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","యూదా, “అయ్యా, మేం ఇంకేమీ చెప్పలేం. వివరించే దారి యింకొకటి లేదు. మేం నేరస్థులం కాదని చూపించే విధం ఇంకొకటి లేదు. మేము చేసిన మరో పని మూలంగా దేవుడు మమ్మల్ని నేరస్థులుగా తీర్పు తీర్చాడు. కనుక మేము అందరం చివరకు బెన్యామీనుతో కూడ బానిసలవుతాం” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","కానీ యోసేపు, “నేను మిమ్మల్ని అందరినీ బానిసలుగా చేయను. పాత్రను దొంగిలించిన మనిషి ఒక్కడే నాకు బానిస అవుతాడు. మిగిలిన మీరు సమాధానంగా మీ తండ్రి దగ్గరకు వెళ్లవచ్చు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","అప్పుడు యోసేపు దగ్గరకు యూదా వెళ్లి ఇలా చెప్పాడు: “అయ్యా, దయచేసి తమరితో నన్ను తేటగా చెప్పనివ్వండి. దయచేసి నాపై కోపగించకండి. మీరు ఫరో అంతటి వారని నాకు తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","క్రితంసారి మేము ఇక్కడు ఉన్నప్పుడు ‘మీకు తండ్రిగాని సోదరుడు గాని ఉన్నాడా?’ అని తమరు అడిగారు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","దానికి మేము జవాబు చెప్పాం, మాకు ఒక తండ్రి ఉన్నాడు, ఆయన ముసలివాడు. మాకు ఒక చిన్న తమ్ముడు ఉన్నాడు, వాడు మా తండ్రికి ముసలితనంలో పుట్టాడు, అందుచేత మా తండ్రికి వాడంటే చాలా ప్రేమ. పైగా ఆ చిన్న కుమారుని అన్న చనిపోయాడు. అందుచేత ఆ తల్లికి పుట్టిన కుమారులలో మిగిలినవాడు ఇతడు ఒక్కడే. మా తండ్రికి ఇతనంటే ఎంతే ప్రేమ. ");
INSERT INTO tel2010_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","అప్పుడు ‘ఆ సోదరుని నా దగ్గరకు తీసుకొని రండి, నేను అతడ్ని చూడాలి’ అన్నారు తమరు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","దానికి మేము ‘ఆ చిన్నవాడు రావటానికి వీల్లేదు. అతడ్ని తన తండ్రిని విడిచిపెట్టలేడు. అతని తండ్రి అతణ్ణి గనక పోగొట్టుకొంటే, అతని తండ్రి దుఃఖంతో మరణిస్తాడు’ అని తమరితో చెప్పాం. ");
INSERT INTO tel2010_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","కానీ తమరేమో ‘మీరు మీ చిన్న తమ్ముడ్ని తప్పక తీసుకొని రావాల్సిందే, లేకపోతే మీకు ధాన్యం అమ్మేది లేదు’ అన్నారు మాతో. ");
INSERT INTO tel2010_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","కనుక మేము తిరిగి మా తండ్రి దగ్గరకు వెళ్లి, మీరు మాతో చెప్పినది ఆయనకు చెప్పాం. ");
INSERT INTO tel2010_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“తర్వాత మా తండ్రి ‘మీరు మళ్లీ వెళ్లి మనకోసం ధాన్యం కొనండి’ అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","మేము మా తండ్రితో ‘మా చిన్న తమ్ముడు లేకుండా మేము వెళ్లలేం. మా చిన్న తమ్ముడ్ని చూచేంత వరకు మళ్లీ మాకు ధాన్యం అమ్మనని ఆ పాలకుడు అన్నాడు’ అని చెప్పాం. ");
INSERT INTO tel2010_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","అప్పుడు మా తండ్రి మాతో అన్నాడు ‘నా భార్య రాహేలు ఇద్దరు కుమారుల్ని నాకు కన్నది. ");
INSERT INTO tel2010_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","ఒక కుమారుడ్ని నేను బయటకు వెళ్లనిస్తే, అతణ్ణి అడవి మృగం చంపేసింది. అప్పట్నుండి నేను అతణ్ణి చూడలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","రెండో కుమారునిగూడా మీరు నా దగ్గర్నుండి తీసుకొని పోతే, అతనికి ఏమైనా సంభవిస్తే ఆ దుఃఖంతో నేను మరణించాల్సిందే!’ ");
INSERT INTO tel2010_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","కనుక ఇప్పుడు మేము మా కనిష్ఠ సోదరుడు మాతో లేకుండా మేము ఇంటికి వెళ్తే, ఏమి జరుగుతుందో ఊహించండి. మా తండ్రి జీవితంలో ఈ కుర్రవాడు చాలా ముఖ్యం. ");
INSERT INTO tel2010_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ఈ కుర్రవాడు మాతో లేకపోవటం గమనిస్తే, మా తండ్రి చనిపోతాడు. ఆ తప్పు మాదే అవుతుంది. మహాగొప్ప దుఃఖంతో మా తండ్రి చనిపోయేటట్టు చెసిన వాళ్లమవుతాం. ");
INSERT INTO tel2010_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“ఈ పిల్లవాని విషయం నేను బాధ్యత తీసుకొన్నాను. ‘ఇతణ్ణి మళ్లీ నీ దగ్గరకు తీసుకొని రాకపోతే నా జీవితకాలమంతా నన్ను నీవు నిందించమని’ నా తండ్రితో నేను చెప్పాను. ");
INSERT INTO tel2010_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","కనుక ఇప్పుడు నేను మీకు మనవి చేసేది, మిమ్మల్ని బ్రతిమాలాడేది ఏమిటంటే, దయచేసి ఈ పిల్లవాణ్ణి తన సోదరులతో వెళ్లనివ్వండి. నేను ఇక్కడే ఉండి, మీకు బానిసను అవుతాను. ");
INSERT INTO tel2010_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ఈ పిల్లవాడు నాతో లేకపోతే నేను తిరిగి నా తండ్రి దగ్గరకు వెళ్లలేను. నా తండ్రికి ఏం జరుగుతుందోనని నాకు చాలా భయంగా ఉంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","యోసేపు ఇంకెంతమాత్రం తనను తాను ఓర్చుకోలేక పోయాడు. అక్కడున్న ప్రజలందరి ముందు అతడు గట్టిగా ఏడ్చేసాడు. “అందర్నీ ఇక్కడనుండి వెళ్లిపొమ్మనండి” అన్నాడు యోసేపు. అందుచేత అందరూ అక్కడనుండి వెళ్లిపోయారు. ఆ సోదరులు మాత్రమే యోసేపు దగ్గర ఉన్నారు. అప్పుడు యోసేపు తాను ఎవరయిందీ వారితో చెప్పేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","యోసేపు ఇంకా ఏడుస్తూనే ఉన్నందుచేత, ఫరో ఇంటిలో ఉన్న ఈజిప్టు ప్రజలంతా అది విన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","యోసేపు తన సోదరులతో “మీ సోదరుడు యోసేపును నేనే, నా తండ్రి ఇంకా బ్రతికి ఉన్నాడా?” అన్నాడు. కాని ఆ సోదరులు నోటమాట రాలేదు. వారు భయంతో కలవరపడిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","కనుక యోసేపు మళ్లీ తన సోదరులతో, “నా దగ్గరకు రండి. ఇలా నా దగ్గరకు రమ్మని బ్రతిమాలుతున్నాను రండి” అన్నాడు. కనుక ఆ సోదరులంతా యోసేపుకు దగ్గరగా వెళ్లారు. యోసేపు వాళ్లతో చెప్పాడు, “నేనే మీ సోదరుణ్ణి, యోసేపును. ఈజిప్టుకు బానిసగా మీరు అమ్మిన వాడిని నేనే. ");
INSERT INTO tel2010_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","ఇప్పుడేమీ బాధపడకండి. మీరు చేసినదాన్ని బట్టి మీ మీద మీరు కోపం తెచ్చుకోవద్దు. నేను ఇక్కడికి రావటం దేవుని ఏర్పాటు. మీ ప్రాణం కాపాడేందుకు నేను ఇక్కడికి వచ్చాను. ");
INSERT INTO tel2010_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","భయంకరమైన ఈ కరువు కాలం ఇప్పటికే రెండు సంవత్సరాలనుండి ఉంది. నాట్లు వేయకుండా, కోతలు కోయకుండా ఇంకా అయిదు సంవత్సరాలు గడచిపోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","కనుక మీ వాళ్లందరినీ ఈ దేశంలో నేను రక్షించాలని చెప్పి దేవుడే నన్ను మీకంటె ముందుగా ఇక్కడికి పంపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","నేను యిక్కడికి పంపబడటం మీ తప్పకాదు. అదంతా దేవుని సంకల్పం. దేవుడు నన్ను ఫరోకు తండ్రిలా చేసాడు. ఆయన దివాణం అంతటిమీదను, మొత్తం ఈజిప్టు అంతటికి నేను పాలకుడ్ని.” ");
INSERT INTO tel2010_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“కనుక మీరు త్వరగా నా తండ్రి దగ్గరకు వెళ్లండి. ఆయన కుమారుడు యోసేపు పంపిన సందేశం ఇది అని నా తండ్రితో చెప్పండి అన్నాడు యోసేపు. ‘దేవుడు నన్ను ఈజిప్టు అంతటి మీద అధికారినిగా చేసాడు. ఇక్కడికి నా దగ్గరకు వచ్చేయండి. ఇంకా వేచి ఉండవద్దు ఇప్పుడే వచ్చేయండి. ");
INSERT INTO tel2010_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","గోషను దేశంలో నా దగ్గర మీరు నివసిస్తారు. మీరు, మీ పిల్లలు, మీ పిల్లల పిల్లలు, మీ జంతువులు, మీ మందలు ఇక్కడికి రావాలని ఆహ్వానిస్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","వచ్చే అయిదు కరువు సంవత్సరాల కాలంలోనూ నేను మిమ్మల్ని చూచుకొంటాను. అందుచేత మీరూ, మీ కుటుంబాలు, మీ స్వంతది ఏదీ నష్టపోదు.’ ");
INSERT INTO tel2010_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“యోసేపు తన సోదరులతో మాట్లాడటం కొనసాగిస్తూనే ఉన్నాడు. ఇప్పుడు మీరు నిజంగా, నేను యోసేపు అని చూడగలుగుతున్నారు. అన్నాడు అతడు. నేనే అని మీ సోదరుడు బెన్యామీనుకు తెలుసు. మీతో మాట్లాడుతున్న నేను మీ సోదరుణ్ణి. ");
INSERT INTO tel2010_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","కనుక ఇక్కడ ఈజిప్టులో నాకు ఉన్న సమస్త ఘనతను గూర్చి నా తండ్రికి చెప్పండి. మీరు ఇక్కడ చూచిన వాటన్నింటి గూర్చి నా తండ్రికి చెప్పండి. ఇక మీరు త్వరపడి నా తండ్రిని నా దగ్గరకు తీసుకురండి.” ");
INSERT INTO tel2010_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","అప్పుడు యోసేపు తన తమ్ముడు బెన్యామీనును కౌగలించుకొని ఏడ్చాడు. బెన్యామీను కూడ ఏడ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","తర్వాత యోసేపు తన సోదరులందరినీ ముద్దు పెట్టుకొని, వారి మీదపడి ఏడ్చాడు. ఆ తర్వాత ఆ సోదరులు అతనితో మాట్లాడటం మొదలు బెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","యోసేపు సోదరులు అతని దగ్గరకు వచ్చినట్లు ఫరోకు తెలిసింది. ఫరో ఇల్లంతా ఈ వార్త పాకిపోయింది. దీని విషయమై ఫరో, ఆతని సేవకులు చాలా సంతోషించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","కనుక యోసేపుతో ఫరో అన్నాడు: “నీ సోదరులకు కావలసినంత ఆహారం తీసుకొని తిరిగి కనాను దేశం వెళ్లమని చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","నీ తండ్రిని, వారి కుటుంబాలను తిరిగి ఇక్కడికి నా దగ్గరకు తీసుకొని రమ్మని వారితో చెప్పు. ఈజిప్టులో శ్రేష్ఠమైన భూమిని నివాసానికి నేను నీకు ఇస్తాను. ఇక్కడ మనకు ఉన్న శ్రేష్ఠ ఆహారం నీ కుటుంబం భోంచేస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","తర్వాత ఫరో అన్నాడు: “మన బండ్లలో మంచి వాటిని కొన్నింటిని మీ సోదరులకు ఇయ్యి. కనాను వెళ్లి, మీ తండ్రిని, స్త్రీలందరిని, పిల్లలను ఆ బండ్లమీద తీసుకొని రమ్మని వారితో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","వారి అన్ని సామానులు తెచ్చుకొనే విషయంలో ఏమీ చింత పడవద్దు. ఈజిప్టులో మనకు ఉన్న శ్రేష్ఠ వస్తువులు మనం వారికి ఇద్దాం.” ");
INSERT INTO tel2010_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","కనుక ఇశ్రాయేలు కుమారులు అలా చేసారు. ఫరో వాగ్ధానం చేసినట్టే యోసేపు వారికి మంచి బండ్లు ఇచ్చాడు. వారి ప్రయాణానికి సరిపడినంత ఆహారం యోసేపు వారికి ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ఒక్కో సోదరునికి ఒక్కో జత చక్కని వస్త్రాలు యిచ్చాడు యోసేపు. అయితే బెన్యామీనుకు అయిదు జతల మంచి బట్టలు యోసేపు ఇచ్చాడు. మరియు 300 వెండి నాణాలు కూడ యోసేపు బెన్యామీనుకు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","యోసేపు తన తండ్రికి కానుకలుకూడా పంపించాడు. ఈజిప్టులోని మంచి వస్తువులు చాలా సంచులనిండా నింపి పది గాడిదలమీద అతడు పంపించాడు. అతని తండ్రి తిరిగి వచ్చేటప్పుడు అవసరమైన ఆహారం, రొట్టె, ధాన్యం విస్తారంగా పది ఆడగాడీదల మీద అతడు పంపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","అప్పుడు యోసేపు అతని సోదరులను వెళ్లమన్నాడు. వారు వెళ్తూ ఉండగా యోసేపు “తిన్నగా ఇంటికి వెళ్లండి. దారిలో పోట్లాడకండి” అని వారితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","కనుక ఆ సోదరులు ఈజిప్టు దేశం విడిచి, కనాను దేశంలో ఉన్న తమ తండ్రి దగ్గరకు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","ఆసోదరులు “నాయనా, యోసేపు బతికే ఉన్నాడు, ఈజిప్టు దేశం అంతటికి అతడే అధికారి” అని అతనితో చెప్పారు. వారి తండ్రి ఆశ్చర్యచకితుడయ్యాడు. అతడు వాళ్లను నమ్మలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","అయితే యోసేపు చెప్పినదంతా ఆ సోదరులు వారి తండ్రికి చెప్పారు. తర్వాత అతనిని ఈజిప్టు తీసుకొని రమ్మని యోసేపు పంపిన బండ్లను యాకోబు చూశాడు. అప్పుడు యాకోబు సంతోషంతో ఉప్పొంగిపొయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","“ఇప్పుడు నేను మిమ్మల్ని నమ్ముతాను. నా కుమారుడు యోసేపు ఇంకా బతికే ఉన్నాడు! నేను మరణించక ముందు అతణ్ణి చూస్తాను” అన్నాడు ఇశ్రాయేలు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","కనుక ఇశ్రాయేలు ఈజిప్టుకు తన ప్రయాణం మొదలు పెట్టాడు. మొదట ఇశ్రాయేలు బెయేర్షెబాకు వెళ్లాడు. అక్కడ తన తండ్రియైన ఇస్సాకు దేవుణ్ణి ఇశ్రాయేలు ఆరాధించాడు. అతడు బలులు అర్పించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ఆ రాత్రి ఒక కలలో దేవుడు ఇశ్రాయేలుతో మాట్లాడాడు. “యాకోబూ, యాకోబూ” అన్నాడు దేవుడు. “ఇదిగో ఇక్కడే ఉన్నాను” అని ఇశ్రాయేలు జవాబు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","అప్పుడు దేవుడు అన్నాడు: “నేను దేవుణ్ణి, నీ తండ్రి దేవుణ్ణి. ఈజిప్టు వెళ్లేందుకు భయపడకు. ఈజిప్టులో నిన్ను ఒక గొప్ప జనంగా నేను చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","నీతో కూడ నేను ఈజిప్టుకు వస్తాను. మళ్లీ నేనే నిన్ను ఈజిప్టునుండి బయటకు తీసుకొని వస్తాను. నీవు ఈజిప్టులో మరిణిస్తావు, కాని యోసేపు నీతో ఉంటాడు. నీవు చనిపోయినప్పుడు అతని స్వంత చేతులే నీ కళ్లను మూస్తాయి.” ");
INSERT INTO tel2010_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","అప్పుడు యాకోబు బెయేర్షెబా విడిచి, ఈజిప్టుకు ప్రయాణం చేసాడు. అతని కుమారులు, ఇశ్రాయేలు కుమారులు తమ తండ్రిని, భార్యలను, తమ పిల్లలందరిని ఈజిప్టుకు తీసుకొని వచ్చారు. ఫరో పంపిన బండ్లలో వారు ప్రయాణం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","తమ పశువులు, కనాను దేశంలో వారికి ఉన్నవి అన్నీ వారితోబాటు ఉన్నవి. కనుక ఇశ్రాయేలు తన పిల్లలందరితో, తన కుటుంబం అంతటితో కలిసి ఈజిప్టు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","అతని కుమారులు అతని మనుమళ్లు, అతని కుమార్తెలు, అతని మనమరాళ్లు అతనితో ఉన్నారు. అతని కుటుంబం అంతా అతనితో కలిసి ఈజిప్టుకు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","ఇశ్రాయేలుతో కలిసి ఈజిప్టు వెళ్లిన అతని కుమారులు, కుటుంబము వాళ్ల పేర్లు: రూబేను యాకోబయొక్క మొదటి కుమారుడు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","రూబేను కుమారులు: హనోకు, పల్లు, హెస్రోను, కర్మీ. ");
INSERT INTO tel2010_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","షిమ్యోను కుమారులు; యెమూయేలు, యామీను, ఓహదు, యాకీను, సోహరు, కనానీ స్త్రీ కుమారుడు షావూలు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","లేవీ కుమారులు: గెర్షోను, కహాతు, మెరారీ. ");
INSERT INTO tel2010_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","యూదా కుమారులు: ఏరు, ఓనాను, షేలా, పెరెసు, జెరహు. (ఏరు, ఓనాను కనానులో ఉన్నప్పుడే చనిపోయారు) పెరెసు కుమారులు: హెస్రోను, హామూలు, ");
INSERT INTO tel2010_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","ఇశ్శాఖారు కుమారులు: తోలా, పువ్యా, యోబు, షిమ్రోను. ");
INSERT INTO tel2010_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","జెబలూను కుమారులు: సెరెదు, ఏలోను, యహలేలు ");
INSERT INTO tel2010_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","రూబేను, షిమ్యోను, లేవి, యూదా, ఇశ్శాఖారు, జెబూలూనులు, యాకోబు భార్య లేయా ద్వారా అతని కుమారులు. లేయా ఆ కుమారులను పద్దనరాములో కన్నది. ఆమె కుమార్తె దీనా కూడ ఉంది. ఈ కుటుంబంలో 33 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","గాదు కుమారులు: సిప్యోను, హగ్గీ, షూనీ, ఎస్బోను, ఏరీ, అరోదీ, అరేలీ, ");
INSERT INTO tel2010_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","ఆషేరు కుమారులు: ఇమ్నా, ఇష్వా, ఇష్వి, బెరీయా, వారి సోదరి శెరహు, హెబెరు, మల్కీయేలు, ");
INSERT INTO tel2010_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","బెరీయా కుమారులు: వారంతా యాకోబుకు అతని భార్య సేవకురాలు జిల్ఫాద్వారా పుట్టిన కుమారులు. ఈ కుటుంబంలో 16 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","మరియు అతని భార్య రాహేలు ద్వారా పుట్టిన కుమారుడు బెన్యామీను కూడ యాకోబుతో ఉన్నాడు. (యోసేపు కూడ రాహేలుకు పుట్టినవాడే కాని అతడు అప్పటికే ఈజిప్టులో ఉన్నాడు.) ");
INSERT INTO tel2010_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ఈజిప్టులో యోసేపుకు ఇద్దరు కుమారులు: మనష్షే, ఎఫ్రాయిము. (ఓను పట్టణ యాజకుడు పోతీఫెర కుమార్తె ఆసెనతు యోసేపు భార్య). ");
INSERT INTO tel2010_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","బెన్యామీను కుమారులు, బెల, బేకెరు, అష్బేలు, గెరా, నయమాను, ఏహి, రోషు, ముప్పీము, హుప్పీము, అర్దు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","వారంతా యాకోబుకు అతని భార్య రాహేలు ద్వారా కలిగిన సంతానం. ఈ కుటుంబంలో 14 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","దాను కుమారుడు: హుషీము ");
INSERT INTO tel2010_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","నఫ్తాలి కుమారులు: యహసేలు, గూనీ, యోసేరు, షల్లేము ");
INSERT INTO tel2010_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","వారు యాకోబు, బిల్హాలకు పుట్టిన కుమారులు (రాహేలు సేవకురాలు బిల్హా). ఈ కుటుంబంలో ఏడుగురు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ఇలా యాకోబు సంతానం ఈజిప్టు వెళ్లారు. యాకోబు మూలంగా కలిగిన పిల్లలు మొత్తం 66 మంది. (యాకోబు భార్యలు ఈ లెక్కలో లేరు). ");
INSERT INTO tel2010_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","మరియు యోసేపు ఇద్దరు కుమారులు కూడ ఉన్నారు. వారు ఈజిప్టులో పుట్టారు. కనుక ఈజిప్టులో యాకోబు కుటుంబంలో 70 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","యాకోబు మొదట యూదాను యోసేపు దగ్గరకు పంపించాడు. గోషేను దేశంలోని యోసేపు దగ్గరకు యూదా వెళ్లాడు. ఆ తర్వాత యాకోబు, అతని వాళ్లు ఆ దేశంలో ప్రవేశించారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","యోసేపు తన తండ్రి వచ్చేస్తున్నాడని విన్నాడు. గోషేనులో తన తండ్రి ఇశ్రాయేలును ఎదుర్కొనుటకు యోసేపు తన రథం సిద్ధం చేసుకొని బయల్దేరాడు. యోసేపు తన తండ్రిని చూడగానే అతని మెడమీద పడి కౌగిలించుకొని చాలాసేపు ఏడ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","అప్పుడు ఇశ్రాయేలు, “ఇప్పుడు నేను మనశ్శాంతిగా మరణించవచ్చు నీ ముఖం నేను చూశాను, నీవు ఇంకా బ్రతికే ఉన్నావని నేను చూడగలిగాను,” అన యోసేపుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","తన సోదరులతోను, తన తండ్రి కుటుంబంతోను యోసేపు ఇలా చెప్పాడు: “నేను వెళ్లి మీరు వచ్చినట్టు ఫరోతో చెబతాను. ఫరోతో నేను ఏమని చెబతానంటే ‘నా అన్నలు, నా తండ్రి కుటుంబం కనాను దేశం విడిచి ఇక్కడ నా దగ్గరకు వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ఈ నా కుటుంబం గొర్రెల కాపరుల కుటుంబం. నిత్యం వాళ్లు పశువుల్ని, మందల్ని కలిగి ఉండేవాళ్లు. వారి పశువుల్ని, వారికి కలిగిన అంతటిని వాళ్లతోబాటు వారు తెచ్చుకొన్నారు.’ ");
INSERT INTO tel2010_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ఫరో మిమ్మల్ని పిలిచినప్పుడు మీరేం పని చేస్తారు? అని మిమ్మును అడుగుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","అప్పుడు మీరు ‘మేము గొర్రెల కాపరులం, మా జీవితకాలమంతా మా పశువుల్ని మేపుకొంటూ జీవించాం. మాకు ముందు మా పూర్వీకులు ఇలాగే జీవించారు’ అని చెప్పండి. అప్పుడు ఫరో మిమ్మును గోషేను దేశంలో జీవింపనిస్తాడు. గొర్రెల కాపరులంటే ఈజిప్టు ప్రజలకు యిష్టం లేదు, కనుక మీరు గోషేను దేశంలో ఉండవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","యోసేపు ఫరో దగ్గరకు వెళ్లి, “నా తండ్రి, నా సోదరులు, వారి కుటుంబాలు మొత్తం ఇక్కడికి వచ్చారు. వారి పశువులు, కనాను దేశంలో వారికి కలిగినది మొత్తం వారితో తెచ్చుకొన్నారు. వారిప్పుడు గోషెనులో ఉన్నారు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","యోసేపు తన సోదరులలో అయిదుగురిని తనతో కూడ ఫరో ఎదుటికి తీసుకొని వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","“మీ వృత్తి ఏమిటి?” అని ఫరో ఆ సోదరులను అడిగాడు. ఆ సోదరులు ఫరోతో, “అయ్యా, మేము గొర్రెల కాపరులం. మాకు ముందున్న మా పూర్వీకులు కూడా గొర్రెల కాపరులే” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","“కనాను దేశంలో కరువు కాలం చాలా దారుణంగా ఉంది. మా పశువులకు అవరమైన గడ్డి ఉన్న పొలాలు ఎక్కడా లేవు. అందుచేత ఈ దేశంలో బతుకుదామని మేము ఇక్కడికి వచ్చాం. మీరు దయచేసి మమ్మల్ని గోషెను దేశంలో ఉండనివ్వాల్సిందిగా మనవి చేస్తున్నాం” అని వారు ఫరోతో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","అప్పుడు యోసేపుతో ఫరో చెప్పాడు: “నీ తండ్రి, నీ సోదరులు నీ దగ్గరకు వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","వారు నివసించేందుకు ఈజిప్టులో ఏ స్థలమైనా సరే నీవు వారికోసం కోరుకోవచ్చు. నీ తండ్రికి, నీ సోదరులకు శ్రేష్ఠమైన భూమి ఇవ్వు. గోషెను దేశంలో వారిని ఉండనివ్వు. వారు నైపుణ్యంగల కాపరులైతే, వారు నా పశువులకను కూడ చూసుకోవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","అప్పుడు యోసేపు తన తండ్రి యాకోబును ఫరో ఎదుటికి తీసుకొని వచ్చాడు. యాకోబు ఫరోను ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","అప్పుడు ఫరో “నీ వయస్సెంత?” అని యాకోబును అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","“నేను తక్కువ కాలం ఎక్కువ కష్టాలతో బతికాను. 130 సంవత్సరాలే నేను బతికాను. నా తండ్రి, ఆయన పూర్వీకులు నాకంటె చాలా ఎక్కువ కాలం బతికారు” అని ఫరోతో యాకోబు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","యాకోబు ఫరోను ఆశీర్వదించాడు. తర్వాత యాకోబు ఫరో ఎదుటి నుండి వెళ్లిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","యోసేపు ఫరోకు విధేయుడయ్యాడు. అతడు తన తండ్రికి, తన సోదరులకు ఈజిప్టలో మంచి భూమిని సమీపంగా ఇచ్చాడు. ఈజిప్టులో రామసేసు నగరానికి దగ్గరలోవున్న ఈ భూమి అతి శ్రేష్ఠమైంది. ");
INSERT INTO tel2010_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","మరియు తన తండ్రికి, సోదరులకు, వారి మనుష్యులందరికీ అవసరమైన ఆహారాన్ని యోసేపు వారికి ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","కరువు కాలం మరీ తీవ్రం అయింది. దేశంలో ఎక్కడా ఆహారం లేదు. ఈ కష్టకాలం మూలంగా ఈజిప్టు, కనాను దరిద్రంగా తయారయ్యాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ఆ దేశంలో ప్రజలు మరింత ధాన్యం కొన్నారు. యోసేపు ఆ ధనం ఆదా చేసి, దానిని ఫరో ఇంటికి తెచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","కొన్నాళ్లకు ఈజిప్టులోను కనానులోను ప్రజల దగ్గర పైకం అయిపోయింది. ధాన్యం కొనేందుకే వారి డబ్బు అంతా ఖర్చు పెట్టారు. కనుక ప్రజలు యోసేపు దగ్గరకు వెళ్లి, “దయచేసి మాకు ధాన్యం ఇవ్వండి. మా డబ్బు అయిపోయింది. మేము భోజనం చేయకపోతే మీరు చూస్తుండగానే మేము మరణిస్తాం” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","“మీ పశువుల్ని ఇవ్వండి, నేను మీకు ఆహారం ఇస్తాను” అని యోసేపు జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","కనుక ప్రజలు ఆహారం కొనేందుకు వారి పశువులను, గుర్రాలను, మిగిలిన జంతువులన్నిటిని ఉపయోగించారు. ఆ సంవత్సరం యోసేపు వారికి ఆహారం ఇచ్చి, వారి పశువులను తీసుకున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","అయితే ఆ తర్వాత సంవత్సరం ప్రజల దగ్గర జంతువులు లేవు, ఆహారం కొనేందుకు ఉపయోగించటానికి ఏమీ లేవు. కనుక ప్రజలు యోసేపు దగ్గరకు వెళ్లి “మా దగ్గర ఇంకేమీ డబ్బు లేదని మీకు తెలుసు. మా పశువులన్నీ మీవే ఇప్పుడు. మా దగ్గర నీవు చూస్తున్న మా శరీరాలు, మా భూమి తప్ప ఇంకేమి లేవు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","మీరు చూస్తుండగానే నిశ్చయంగా మేము చనిపోతాం. కానీ, మీరు మాకు ఆహారం ఇస్తే, మేము మా భూమిని ఫరోకు ఇస్తాం, మేము ఆయన బానిసలంగా ఉంటాము. మేము నాట్లు వేయటానికి మాకు విత్తనాలు ఇవ్వండి. అప్పుడు మేము చావక బతుకుతాం. భూమి మా కోసం మరోసారి పంటను ఇస్తుంది” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","కనుక యోసేపు ఈజిప్టులోని భూమి అంతటినీ ఫరోకోసం కొన్నాడు. ఈజిప్టులోని ప్రజలంతా వారి భూములను యోసేపుకు అమ్మివేసారు. వారు చాలా కరువుతో ఉన్నందుచేత ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","మరియు ప్రజలందకు ఫరోకు బానిసలయ్యారు. ఈజిప్టు అంతటిలో ప్రజలు ఫరోకు బానిసలు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","యాజకుల స్వంత భూములను మాత్రమే యోసేపు కొనలేదు. యాజకుల పనికి ఫరో జీతం ఇచ్చాడు గనుక వారు వారి భూములను అమ్ముకోవాల్సిన అవసరం లేదు. ఆ డబ్బును ఆహారం కొనేందుకు వారు ఉపయోగించుకొనేవారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","యోసేపు ప్రజలతో చెప్పాడు, “ఇప్పుడు మిమ్మల్ని, మీ భూముల్ని ఫరోకోసం నేను కొన్నాను. కనుక నేను విత్తనాలు ఇస్తాను, మీరు మీ భూముల్లో నాట్లు వేయవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","కోతకాలంలో మీ పంటలో అయిదింట ఒక వంతు ఫరోకు ఇవ్వాలి. అయిదింట నాలుగు వంతులు మీకోసం మీరు ఉంచుకోవచ్చు. మీరు ఉంచుకొనే గింజలను మీ ఆహారం కోసమూ, వచ్చే సంవత్సరం విత్తనాల కోసం ఉపయోగించుకోవచ్చు. ఇప్పుడు మీరు మీ కుటుంబాలను, పిల్లలను పోషించుకోవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ప్రజలు, “మీరు మా ప్రాణాలు రక్షించారు. మేము సంతోషంగా మీకు, ఫరోకు బానసలంగా ఉంటాం” అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","కనుక ఈ సమయంలో యోసేపు ఆ దేశంలో చట్టం చేసాడు. ఆ చట్టం నేటికీ కొనసాగుతుంది. భూమిలోనుండి వచ్చే దిగుబడి అంతటిలోనూ అయిదింట ఒక వంతు ఫరోకు చెందుతుంది అనేది ఆ చట్టం. భూములన్నీ ఫరో స్వంతం. యాజకుల భూమి మాత్రమే ఫరో స్వంతం కాలేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","ఇశ్రాయేలు (యాకోబు) ఈజిప్టులో ఉన్నాడు. గోషెను దేశంలో నివసించాడు. అతని కుటుంబం పెరిగి చాలా పెద్దది అయింది. ఈజిప్టులో వారు ఆ భూమిని సంపాదించి వర్ధిల్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","యాకోబు ఈజిప్టులో 17 సంవత్సరాలు జీవించాడు. కనుక యాకోబు వయస్సు 147 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","తాను త్వరలో చనిపోతానని తెలిసి, ఇశ్రాయేలు (యాకోబు) తన కుమారుడు యోసేపును తన దగ్గరకు పిల్చాడు. “నీవు నన్ను ప్రేమిస్తే, నీ చేయి నా తొడకింద పెట్టి ప్రమాణం చేయి. నేను చెప్పినట్లు నీవు చేస్తానని, నాకు నీవు నమ్మకంగా ఉంటావని వాగ్దానం చేయి. నేను మరిణించినప్పుడు నన్ను ఈజిప్టులో పాతిపెట్టవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","నా పూర్వీకులు పాతి పెట్టబడిన చోట నన్ను పాతిపెట్టు. ఈజిప్టు నుండి నన్ను తీసుకొనిపోయి, మన కుటుంబ సమాధుల స్థలంలో నన్ను పాతిపెట్టు” అన్నాడు. “నీవు చెప్పినట్టు చేస్తానని నేను వాగ్దానం చేస్తున్నా” అని యోసేపు జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","అప్పుడు యాకోబు, “నాకు ప్రమాణం చేయి” అన్నాడు. అందుకు యోసేపు అలా చేస్తానని ప్రమాణం చేసాడు. అంతట ఇశ్రాయేలు పడక మీద తన తల వెనుకకు వాల్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","కొంత కాలం తర్వాత, తన తండ్రి చాలా అస్వస్థతగా ఉన్నాడని యోసేపుకు తెలిసింది. కనుక మనష్షే, ఎఫ్రాయిము అనే తన యిద్దరు కుమారులను తీసుకొని, యోసేపు తన తండ్రి దగ్గరకు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","యోసేపు వచ్చినప్పుడు ఎవరో ఇశ్రాయేలుతో చెప్పారు, “నీ కుమారుడు యోసేపు నిన్ను చూడటానికి వచ్చాడు” అని. ఇశ్రాయేలు చాలా బలహీనంగా ఉన్నాడు, అయినప్పటికీ కష్టంగా ప్రయత్నించి తన పడకమీద కూర్చున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","అప్పుడు యోసేపుతో ఇశ్రాయేలు అన్నాడు, “కనాను దేశంలోని ఊజు వద్ద సర్వశక్తిమంతుడైన దేవుడు నాకు ప్రత్యక్షమయ్యాడు. అక్కడే దేవుడు నన్ను ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","దేవుడు నాతో చెప్పాడు: ‘నిన్ను ఒక గొప్ప వంశంగా నేను చేస్తాను. నీకు అనేకమంది పిల్లలను నేను ఇస్తాను, మీరు గొప్ప జనం అవుతారు. మీ వంశీకులు ఈ భూమిని శాశ్వతంగా స్వంతం చేసుకుంటారు.’ ");
INSERT INTO tel2010_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","ఇప్పుడు నీకు ఇద్దరు కుమారులు ఉన్నారు. నేను రాకముందు యిక్కడ ఈజిప్టు దేశంలో ఈ ఇద్దరు కుమారులు పుట్టారు. ఎఫ్రాయిము, మనష్షే అనే నీ యిద్దరు కుమారులు నా స్వంత కుమారుల్లాగే ఉంటారు. రూబేను, షిమ్యోనులు నాకెలాగో వారూకూడ నాకు అంతే. ");
INSERT INTO tel2010_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","కనుక ఈ ఇద్దరు బాలురు నా కుమారులే. నాకు ఉన్న దానంతటిలో వారికి గూడ భాగం ఉంది. అయితే నీకు ఇంకా కుమారులు పుడితే వాళ్లు నీ స్వంత కుమారులుగా ఉంటారు. అయితే వారు ఎఫ్రాయిము మనష్షేలకు కుమారులుగా ఉంటారు. అంటే భవిష్యత్తులో ఎఫ్రాయిము, మనష్షేలు కలిగి ఉండే దానంతటిలో వాళ్లూ భాగస్థులవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","పద్దనరాము నుండి చేసిన ప్రయాణంలో రాహేలు చనిపోయింది. ఇది నాకు చాలా దుఃఖం కలిగించింది. ఆమె కనాను దేశంలో చనిపోయింది. అప్పటికి మేము ఇంకా ఎఫ్రాతా వైపు ప్రయాణం చేస్తున్నాం. ఎఫ్రాతా పోయే మార్గంలో నేను ఆమెను సమాధి చేసాను.” (ఎఫ్రాతా బెత్లెహేము) ");
INSERT INTO tel2010_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","అప్పుడు యోసేపు కుమారులను ఇశ్రాయేలు చూశాడు. “ఈ పిల్లలు ఎవరు?” అని యోసేపును అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","యోసేపు తన తండ్రితో, “వీళ్లు నా కుమారులు. దేవుడు నాకు ఇచ్చిన అబ్బాయిలు వీళ్లే” అని చెప్పాడు. “నీ కుమారులను నా దగ్గరకు తీసుకొని రా! నేను వారిని ఆశీర్వదిస్తాను” అన్నాడు ఇశ్రాయేలు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ఇశ్రాయేలు వృద్ధుడు గనుక అతని చూపు సరిగ్గా లేదు అందుచేత యోసేపు ఆ బాలురను తన తండ్రికి దగ్గరగా తీసుకొని వచ్చాడు. ఇశ్రాయేలు వారిని కౌగలించుకొని ముద్దు పెట్టుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","అప్పుడు ఇశ్రాయేలు, “నీ ముఖం మళ్లీ చూస్తానని నేను ఎన్నడూ అనకోలేదు. అయితే చూడు! నిన్ను, నీ పిల్లలను కూడ దేవుడు నన్ను చూడనిచ్చాడు” అన్నాడు యోసేపుతో. ");
INSERT INTO tel2010_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","అప్పుడు యోసేపు ఆ బాలురను ఇశ్రాయేలు ఒడిలోనుండి దించగా, వారు అతని తండ్రి ఎదుట సాగిలపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","ఎఫ్రాయిమును అతని కుడి ప్రక్కను, మనష్షేను అతని ఎడమ ప్రక్కను యోసేపు ఉంచాడు. (కనుక ఇశ్రాయేలుకు ఎడమ ప్రక్క ఎఫ్రాయిము, కుడి ప్రక్క మనష్షే ఉన్నారు). ");
INSERT INTO tel2010_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","కానీ ఇశ్రాయేలు తన చేతులను అటుయిటు మార్చి చిన్న పిల్లవాడు ఎఫ్రాయిము తలమీద తన కుడి చేతిని పెట్టాడు. తర్వాత ఇశ్రాయేలు పెద్దపిల్లవాడు మనష్షే తలమీద తన ఎడమ చేతిని పెట్టాడు. మనష్షే జ్యేష్ఠుడైనప్పటికి అతడు తన ఎడమ చేతిని మనష్షే మీద ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","మరియు ఇశ్రాయేలు యోసేపును ఆశీర్వదించి ఇలా చెప్పాడు: “నా పూర్వీకులు అబ్రాహాము, ఇస్సాకు మన దేవుణ్ణి ఆరాధించారు. ఆ దేవుడే నా జీవితమంతా నన్ను నడిపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","అయితే నా కష్టాలన్నింటినుండి నన్ను రక్షించిన దూత. ఆయనే ఈ బాలురను దీవించాలని నేను ప్రార్థిస్తున్నాను. ఇప్పుడు ఈ పిల్లలకు నా పేరు ఉంటుంది మన పూర్వీకులు అబ్రాహాము, ఇస్సాకుల పేర్లు వారికి ఉంటాయి. వారు ఈ భూమి మీద గొప్ప వంశాలుగా గొప్ప రాజ్యాలుగా ఎదగాలని నా ప్రార్థన.” ");
INSERT INTO tel2010_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","తన తండ్రి కుడిచేయి ఎఫ్రాయిము మీద ఉంచినట్లు యోసేపు చూశాడు. ఇది యోసేపుకు సంతోషం గలిగించలేదు. యోసేపు తన తండ్రి చేయి తీసుకొని, ఎఫ్రాయిం తలమీదనుండి తీసి, మనష్షే తలమీద ఉంచాలనుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","యోసేపు తన తండ్రితో, “నీ కుడి చేయి సరైన వాడిమీద పెట్టలేదు. మనష్షే జ్యేష్ఠుడు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","అయితే అతని తండ్రి వాదించి చెప్పాడు, “నాకు తెలుసు కొడుకా. మనష్షే జ్యేష్ఠుడు అతడు గొప్ప వాడవుతాడు. అతడు అనేకమంది ప్రజలకు తండ్రి కూడ అవుతాడు. కానీ చిన్నవాడు పెద్దవాడికంటె గొప్ప వాడవుతాడు. మరియు చిన్నవాడి వంశం ఇంకా చాలా పెద్దదిగా ఉంటుంది.” ");
INSERT INTO tel2010_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","అలా ఇశ్రాయేలు ఆనాడు వారిని ఆశీర్వదించాడు. “ఇశ్రాయేలువారు ఆశీర్వదించుటకు నీ నామాన్ని ఉపయోగిస్తారు. ఎవరినైనా ఆశీర్వదించినప్పుడు ‘దేవుడు ఎఫ్రాయిము మరియు మనష్షేవలె చేయునుగాక అని వాళ్లంటారు’ అని అతడు చెప్పాడు.” ఈ విధంగా మనష్షేకంటె ఎఫ్రాయిమును గొప్ప చేశాడు ఇశ్రాయేలు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","అప్పుడు యోసేపుతో ఇశ్రాయేలు అన్నాడు “చూడు, నా మరణ ఘడియ దాదాపు సమీపించింది. అయితే దేవుడు మాత్రం ఇంకా మీతో ఉంటాడు. మీ పూర్వీకుల దేశానికి ఆయన మిమ్మును నడిపిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","నీ సోదరలకు ఇవ్వనిది నేను నీకు ఇచ్చాను. అమోరీ ప్రజలనుండి నేను గెలుచుకొన్న పర్వతాన్ని నేను నీకు ఇస్తున్నాను. ఆ పర్వతం కోసం నా కత్తితో, నా బాణంతో నేను ఆ మనుష్యులతో పోరాడి గెల్చాను.” ");
INSERT INTO tel2010_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","అప్పుడు యాకోబు తన కుమారులందరినీ తన దగ్గరకు పిలిచాడు. అతడు చెప్పాడు: “నా కుమారులందరూ ఇక్కడ నా దగ్గరకు రండి. భవిష్యత్తులో ఏం జరుగుతుందో నేను మీకు చెబతాను. ");
INSERT INTO tel2010_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“యాకోబు కుమారులారా, మీరంతా కలిసి వచ్చి వినండి. మీ తండ్రి ఇశ్రాయేలు మాటలు వినండి. ");
INSERT INTO tel2010_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“రూబేనూ, నీవు మొట్టమొదటి కుమారుడవు. పురుషునిగా నా శక్తికి మొదటి ఋజువు నీవే. నా కుమారులందరిలోను గౌరవించదగిన మహా బలశాలివి నీవు. నీవు నా ప్రథమ సంతానం. నా కుమారులందరిలో నీవు మహా బలవంతుడవు, అతిశయాస్పదమైన వాడవు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","కానీ నీవు ఉద్రేకంతో అదుపుదప్పిన ప్రవాహం వలే ఉన్నావు. కాబట్టి నీవు ఎక్కువ గౌరవించదగిన కుమారుడవు కావు నీ తండ్రికి చెందిన స్త్రీతో నీవు శయనించావు నీ తండ్రి పడకను నీవు ఎక్కావు. నీవు నా పడకకు అవమానం తెచ్చావు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“షిమ్యోను, లేవీ సోదరులు. తమ ఖడ్గములతో పోరాడటం అంటే వారికి ప్రీతి. ");
INSERT INTO tel2010_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","రహస్యమందు వారు చెడు కార్యాలను తలస్తారు. వారి పథకాలలో నా ఆత్మ భాగాన్ని కోరటం లేదు, వారి రహస్య సమావేశాలను నేను అంగీకరించను, వారు వారి పగవారిని కోపంతో చంపారు వారు కేవలం సరదాలకు పశువులకు హాని చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","వారి కోపం శాపం అది చాల బలీయమయింది. వారికి కోపం వచ్చినప్పుడు వారు చాలా క్రూరులు యాకోబు దేశంలో వారి వంశాలకు వారి స్వంత భూమి వారికి ఉండదు ఇశ్రాయేలు అంతటిలో వారు చెదరి ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“యూదా, నీ సోదరులు నిన్ను పొగడుదురు. నీవు నీ శత్రువులను ఓడిస్తావు. నీ సోదరులు నీకు సాగిలపడ్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","యూదా సింహంలాంటివాడు. కుమారుడా, తాను చంపిన జంతువు దగ్గర నిలిచిన సింహం వంటి వాడవు నీవు. యూదా సింహంవంటి వాడు. అతడు విశ్రాంతికోసం పండుకొంటాడు. అతణ్ణి లేపుటకు ఎవరూ సాహసించరు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","యూదా వంశపు పురుషులు రాజులుగా ఉంటారు. అతని కుటుంబం పరిపాలిస్తుంది, అనే సూచన అసలైన రాజు వచ్చేంతవరకు అతని కుటుంబాన్ని విడువదు. అప్పుడు అనేక మంది అతనికి విధేయులై అతణ్ణి సేవిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","అతడు ద్రాక్షావల్లికి తన గాడిదను కట్టివేస్తాడు శ్రేష్ఠమైన ద్రాక్షావల్లికి అతడు తన గాడిద పిల్లను కట్టివేస్తాడు. అతడు తన బట్టలు ఉదుకుటకు శ్రేష్ఠమైన ద్రాక్షారసాన్ని ఉపయోగిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","ద్రాక్షారసం తాగి అతని కళ్లు ఎరుపెక్కి ఉంటాయి. పాలు తాగి అతని పళ్లు తెల్లగా ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“జెబూలూను సముద్రానికి సమీపంగా జీవిస్తాడు. అతని తీరం ఓడలకు క్షేమ స్థలంగా ఉంటుంది. అతని భూమి సీదోను వరకు విస్తరిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ఇశ్శాఖారు చాలా ప్రయాసపడిన గాడిదల వలె ఉంటాడు భారమైన బరువు మోసినందుచేత అతడు పండుకొని ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","అతడు తన విశ్రాంతి స్థలం మంచిదిగా ఉండేటట్టు చూసుకొంటాడు తన భూమి రమ్యమైనదిగా ఉండేటట్టు అతడు చూసుకొంటాడు. తర్వాత అతడు బరువులు మోయుటకు ఒప్పుకొంటాడు. బానిసగా పని చేసేందుకు అతడు ఒప్పుకొంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ఇతర ఇశ్రాయేలు వంశస్థుల్లాగే దాను తన ప్రజలకు తర్పు తీరుస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","దారి ప్రక్కన ఉండే పామువలె దాను ఉండునుగాక త్రోవ దగ్గర పొంచి ఉండే కట్లపామువలె అతడు ఉండుగాక. ఆ పాము గుర్రపు మడిమెను కాటు వేస్తుంది. ఆ గుర్రంమీద స్వారీ చేసే మనిషి గుర్రం మీదనుండి పడిపోతాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“యెహోవా, నీ రక్షణకోసం నేను కనిపెట్టకొని ఉన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“దొంగల గుంపు గాదు మీద పడ్తారు. కానీ గాదు వారిని తరిమివేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“ఆషేరు భూమి మంచి ఆహారాన్ని సమృధ్ధిగా పండిస్తుంది ఒక రాజుకు సరిపోయేలాంటి భోజనం అతనికి ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“స్వేచ్ఛగా పరుగులెత్తే లేడివంటివాడు. నఫ్తాలి దాటి అందమైన పిల్లల్లా అతని మాటలు ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“యోసేపు చాలా విజయశాలి నీళ్ల ఊట దగ్గర ఎదిగే ద్రాక్షావల్లిలా కంచెమీద అల్లుకొనే ద్రాక్షా తీగెలా అతడు ఫలిస్తాడు ");
INSERT INTO tel2010_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","చాలామంది అతనిమీద ఎదురు తిరిగి అతనితో పోరాడారు బాణాలు పట్టుకొనేవారు అతనికి శత్రువులయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","అయితే తన మహత్తర విల్లుతోను, నైపుణ్యంగల తన చేతులతోను పోరాటం గెల్చాడు అతడు తన శక్తిని యాకోబు యొక్క శక్తిమంతుని నుండి గొర్రెల కాపరినుండి ఇశ్రాయేలు బండనుండి ");
INSERT INTO tel2010_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","నీ తండ్రి దేవునినుండి పొందుతాడు. “దేవుడు నిన్ను ఆశీర్వదిస్తాడు. సర్వశక్తిమంతుడగు దేవుడు నిన్ను ఆశీర్వదించునుగాక! పైన ఆకాశంనుండి ఆశార్వాదములను, అగాధ స్థలముల నుండి ఆశీర్వాదములను ఆయన నీకు అనుగ్రహించుగాక స్తనముల దీవెనలు గర్భపు దీవెనలు ఆయన నీకు ఇచ్చుగాక. ");
INSERT INTO tel2010_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","నా తల్లిదండ్రులకు ఎన్నెన్నో మేళ్లు జరిగాయి. మరియు నీ తండ్రినైన నేను అంతకంటె ఎక్కువగ ఆశీర్వదించబడ్డాను నీ సోదరులు నీకు ఏమీ లేకుండా నిన్ను విడిచిపెట్టి వేసేందుకు ప్రయత్నించారు అయితే ఇప్పుడు నా ఆశీర్వాదములన్నీ కొండంత ఎత్తుగా నీమీద క్రుమ్మరించబడతాయి. ");
INSERT INTO tel2010_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“బెన్యామీను ఆకలిగొన్న తోడేలు వంటివాడు ఉదయాన అతడు చంపుకొని తింటాడు మిగిలిన దానిని అతడు సాయంకాలం పంచుకొంటాడు.” ");
INSERT INTO tel2010_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","అవి ఇశ్రాయేలు పండ్రెండు కుటుంబాలు. మరియు వారి తండ్రి వారితో చెప్పిన విషయాలు అవి. వారిలో ప్రతి కుమారునికి తగిన ఆశీర్వాదం అతడు వారికి ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","తర్వాత ఇశ్రాయేలు వారికి ఒక ఆజ్ఞ ఇచ్చాడు. అతడు ఇలా చెప్పాడు, “నేను మరణించినప్పుడు నా ప్రజలతో ఉండాలని నేను కోరుచున్నాను. హిత్తీయుడగు ఎఫ్రోను పొలంలోని గుహలో నా పూర్వీకులతో బాటు పాతిపెట్టబడాలని కోరుతున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ఆ గుహ మమ్రే దగ్గర మక్ఫేలా పొలంలో ఉంది. అది కనాను దేశంలో ఉంది. అబ్రాహాము తనను పాతిపెట్టేందుకు స్థలం ఉండాలని ఎఫ్రోను దగ్గర ఆ భూమి కొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","అబ్రాహాము, అతని భార్య శారా ఆ గుహలోనే పాతిపెట్టబడ్డారు. ఇస్సాకు, అతని భార్య రిబ్కా ఆ గుహలోనే పాతిపెట్టబడ్డారు. నా భార్య లేయాను నేను ఆ గుహలోనే పాతిపెట్టాను. ");
INSERT INTO tel2010_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","హిత్తీ మనుష్యుల దగ్గర కొన్న పొలంలో ఉంది ఆ గుహ.” ");
INSERT INTO tel2010_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","యాకోబు తన కుమారులతో మాట్లాడటం ముగించిన తర్వాత అతడు పండుకొని, పడకమీద తన కాళ్లు చాపుకొని మరణించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ఇశ్రాయేలు మరణించినప్పుడు యోసేపు చాలా విచారించాడు. అతడు తన తండ్రిని కౌగలించుకొని, అతని మీద పడి ఏడ్చి, అతనిని ముద్దు పెట్టుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","తన తండ్రి దేహమును సిద్ధం చేయుమని అతడు తన సేవకులకు ఆజ్ఞాపించాడు (ఆ సేవకులు వైద్యులు). యాకోబు శరీరాన్ని సమాధి చేసేందుకు వైద్యులు సిద్ధం చేసారు. ఈజిప్టువారి ప్రత్యేక పద్ధతిలో ఆ శరీరాన్ని వారు సిద్ధం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ఈజిప్టు వారు ఈ పద్ధతిలో శరీరాన్ని సిద్ధం చేయాలంటే, ఆ శరీరాన్ని సమాధి చేసేందుకు ముందు 40 రోజులు వారికి అవసరం. తర్వాత ఈజిప్టువాళ్లు యాకోబు కోసం దుఃఖించటానికి ప్రత్యేక సమయం తీసుకొన్నారు. ఆ సమయం 70 రోజులు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","డెబ్భైరోజుల తర్వాత దఃఖసమయం ముగిసింది. కనుక ఫరో అధికారలతో యోసేపు మాట్లాడాడు. “దయచేసి ఫరోతో ఇది చెప్పండి: ");
INSERT INTO tel2010_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘నా తండ్రి మరణ ఘడియల్లో నేను ఆయనకు ఒక వాగ్దానం చేసాను. కనాను దేశంలోని ఒక గుహలో నేను ఆయనను సమాధి చేస్తానని నేను వాగ్దానం చేసాను. ఇది ఆయన తనకోసం సిద్ధం చేసుకొన్న గుహ. కనుక దయచేసి వెళ్లి, నా తండ్రిని సమాధి చేసుకోనివ్వండి. అప్పుడు నేను తిరిగి మీ దగ్గరకు వస్తాను’” అన్నాడు యోసేపు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","“నీ మాట నిలబెట్టకో, వెళ్లి నీ తండ్రిని సమాధి చేయి” అని ఫరో జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","కనుక యోసేపు తన తండ్రిని సమాధి చేసేందుకు వెళ్లాడు. ఫరో అధికారులంతా ఫరో పెద్దలు (నాయకులు) యోసేపుతో కూడ వెళ్లారు. ఫరో నాయకులు, ఈజిప్టులోని పెద్దలందరూ యోసేపుతో వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","యోసేపు కుటుంబంలోని వాళ్లందరూ, అతనితో వెళ్లారు. మరియు తన తండ్రి కుటుంబం అంతా యోసేపుతో వెళ్లారు. పిల్లలు, పశువులు మాత్రమే గోషెను దేశంలో విడువబడటం జరిగింది ");
INSERT INTO tel2010_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","యోసేపుతో వెళ్లటానికి అందరూ రథాలమీద, గుర్రాలమీద వెళ్లారు. అది చాలా పెద్ద గుంపు అయింది. ");
INSERT INTO tel2010_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","యోర్దాను నదికి తూర్పున గోరెన్ ఆఠదు కళ్లం దగ్గరకు వారు వెళ్లారు. ఆ స్థలంలో వారు ఇశ్రాయేలు నిమిత్తం భూస్థాపన క్రమాలు దీర్ఘంగా జరిగించారు. ఆ భూస్థాపన క్రమం ఏడు రోజులపాటు కొనసాగింది. ");
INSERT INTO tel2010_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","గోరెన్ ఆఠదులో జరిగిన భూస్థాపన క్రమాన్ని కనానులో నివసిస్తున్న ప్రజలు చూశారు. వారు “ఆ ఈజిప్టు వాళ్లు ఎంతగా దుఃఖిస్తున్నారో అని చెప్పుకొన్నారు” కనుక ఆ స్థలం ఇప్పుడు ఆబేల్ మిస్రాయిము అని పిలువబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","కనుక యాకోబు కుమారులు తమ తండ్రి ఆజ్ఞాపించిన ప్రకారం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","వారు అతని శరీరాన్ని కనానుకు తీసుకొని వెళ్లి, మక్ఫేలా గుహలో దానిని పాతిపెట్టారు. హిత్తీయుడగు ఎఫ్రోను దగ్గర అబ్రహాము కొన్న పొలంలోని మమ్రే సమీపాన ఉన్న గుహ ఇది. సమాధిస్థలంగా ఉపయోగించేందుకు అబ్రహాము ఆ గుహను కొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","యోసేపు తన తండ్రిని పాతిపెట్టిన తర్వాత, అతనూ, అతనితో ఆ గుంపులో ఉన్న ప్రతి ఒక్కరూ తిరిగి ఈజిప్టు వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","యాకోబు మరణించిన తర్వాత యోసేపు సోదరులు దిగులుపడిపోయారు. చాలాకాలం క్రిందట వారు చేసినదాన్ని బట్టి యోసేపు ఇంకా వారిమీద కోపంగా ఉంటాడని వారు భయపడ్డారు. మనము చేసినదాని విషయంలో “బహుశాః యోసేపు మనల్ని ఇంకా ద్వేషించవచ్చు. మరియు మనం అతనికి చేసిన కీడంతటికి తిరిగి పగ తీర్చుకోవచ్చు” అని తమలో తాము అనుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","కనుక ఆ సోదరులు యోసేపుకు ఈ సందేశం పంపించారు: “నీ తండ్రి చనిపోక ముందు మాకు ఒక ఆజ్ఞ ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘యోసేపుకు వారు చేసిన కీడును దయతో క్షమించమని నేను అతణ్ణి బ్రతిమాలుతున్నానని యోసేపుతో చెప్పండి’ అని అతడు చెప్పాడు. కనుక యోసేపూ, మేము చేసిన తప్పు పనిని దయచేసి ఇప్పుడు క్షమించు. మేము నీ తండ్రి దేవుని దాసులం.” యోసేపు సోదరులు చెప్పిన విషయాలు యోసేపుకు చాలా దుఃఖం కలిగించాయి, అతడు ఏడ్చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","యోసేపు సోదరులు అతని దగ్గరకు వెళ్లి అతని ఎదుట సాగిలపడ్డారు. వారు “మేము నీకు దాసులం” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","అప్పుడు యోపేసు, “భయపడకండి, నేనేం దేవుణ్ణి కాను. మిమ్మల్ని శిక్షించే హక్కు నాకు లేదు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","మీరు నాకు ఏదో కీడు చేయాలని తలపెట్టారు. కాని దేవుడు నిజంగా మంచి వాటిని తలపెట్టాడు. అనేకమంది ప్రజల ప్రాణాలు కాపాడుటకు నన్ను వాడుకోవటం దేవుని ఏర్పాటు. ఈ వేళ ఇంకా అదే ఆయన ఏర్పాటు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","కనుక భయపడవద్దు. నేను మీ కోసం, మీ పిల్లలకోసం జాగ్రత్త పుచ్చుకుంటాను” అని చెప్పాడు. యోసేపు తన సోదరులతో దయగా మాట్లాడాడు. ఆ సోదరులకు యిది నెమ్మది కలిగించింది. ");
INSERT INTO tel2010_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","యోసేపు తన తండ్రి కుటుంబంతో సహా ఈజిప్టులోనే జీవించటం కొనసాగించాడు. యోసేపు 110 సంవత్సరాల వయస్సులో చనిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","యోసేపు జీవించి ఉన్నప్పుడు, ఎఫ్రాయిముకు పిల్లలు, పిల్లల పిల్లలు పుట్టారు. మరియు అతని కుమారుడు మనష్షేకు మాకీరు అనే పేరుగల ఒక కొడుకు ఉన్నాడు. మాకీరు పిల్లలను చూచేంతవరకు యోసేపు జీవించాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","యోసేపు మరణం దగ్గరపడినప్పుడు, అతడు, “నేను చనిపోవాల్సిన సమయం దాదాపు వచ్చేసింది. అయితే దేవుడు మిమ్మల్ని కాపాడుతాడని నాకు తెలుసు. ఆయన మిమ్మల్ని ఈ దేశంనుండి బయటకు తీసుకొని వెళ్తాడు. అబ్రహాము, ఇస్సాకు, యాకోబలకు ఆయన ఇస్తానని వాగ్దానం చేసిన దేవుడు మిమ్మల్ని నడిపిస్తాడు” అని తన సోదరులతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","అప్పుడు యోసేపు తన వాళ్లందర్నీ ఒక వాగ్దానం చెయ్యమని అడిగాడు. “దేవుడు మిమ్మల్ని ఆ నూతన దేశానికి నడిపించినప్పుడు, నా యెముకలను మీతో కూడ తీసుకొని వెళ్తామని నాకు వాగ్దానం చేయండి” అన్నాడు యోసేపు. ");
INSERT INTO tel2010_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","యోసేపు 110 సంవత్సరాల వయస్సు ఉన్నప్పుడు ఈజిప్టులో మరణించాడు. వైద్యులు అతని శరీరాన్ని సమాధి చేసేందుకు సిద్ధంచేసి, ఈజిప్టులో సమాధి పెట్టెలో ఆ శరీరాన్ని ఉంచారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","యాకోబు (ఇశ్రాయేలు) తన కుమారులతో పాటు ఈజిప్టు వెళ్లాడు. ఇశ్రాయేలు కుమారుల పేర్లు ఏవంటే: ");
INSERT INTO tel2010_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","రూబేను, షిమ్యోను, లేవి, యూదా, ");
INSERT INTO tel2010_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ఇశ్శాఖారు, జెబూలూను, బెన్యామీను, ");
INSERT INTO tel2010_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","దాను, నఫ్తాలి, గాదు, ఆషేరు. ప్రతియొక్కరూ కుటుంబ సమేతంగా వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","యాకోబు సంతానం మొత్తం డెబ్బయి మంది. (12 మంది కుమారుల్లో మరొకడు యోసేపు. అతను అప్పటికే ఈజిప్టులో వున్నాడు.) ");
INSERT INTO tel2010_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","తర్వాత యోసేపు, అతని సోదరులు, వారి తరం వారు అందరూ చనిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","అయితే, ఇశ్రాయేలు ప్రజలకు పిల్లలు చాలామంది ఉన్నారు. వారి సంఖ్య చాలా పెరిగిపోయింది. ఆ ప్రజలు చాలా బలవంతులు కాగా ఈజిప్టు దేశం వాళ్లతోనే నిండిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","అప్పుడు ఒక కొత్తరాజు ఈజిప్టును పాలించడం మొదలు పెట్టాడు. ఈ రాజుకు యోసేపు తెలియదు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","ఈ రాజు తన ప్రజలతో ఇలా అన్నాడు, “ఇశ్రాయేలు జనాన్ని చూడండి. వాళ్లు చాలామంది ఉన్నారు! పైగా వాళ్లు మనకంటె చాలా బలంగా ఉన్నారు! ");
INSERT INTO tel2010_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","వాళ్లపైన మనం ఏదైనా పథకం వేయాలి. లేకపోతే ఏదైనా యుద్ధం వచ్చినప్పుడు ఇశ్రాయేలు ప్రజలు మన శత్రువులతో ఏకం కావచ్చు. అల్లాంటప్పుడు వాళ్లు మనల్ని ఓడించి, మన దగ్గర్నుండి తప్పించుకొని పారిపోవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ఈజిప్టు ప్రజలు ఇశ్రాయేలు ప్రజలకు జీవితాన్ని కష్టతరం చేయాలనుకొన్నారు. అందుచేత బానిసలపైన ఉండే అధికారులను ఇశ్రాయేలీయుల మీద నియమించారు. ఆ యజమానులు ఇశ్రాయేలు ప్రజలను బలవంతం చేసి ఫరోకోసం ధాన్యాదులను నిలువ చేయు పీతోము, రామసేను పట్టణాలను కట్టించారు. (ధాన్యం మొదలైన వాటిని వాళ్లు ఈ పట్టణాల్లో నిల్వ చేసేవాళ్లు) ");
INSERT INTO tel2010_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","ఇశ్రాయేలీయులు ప్రయాసపడి పనిచేయునట్లు ఈజిప్టు వాళ్లు వారిని బలవంతపెట్టారు. కాని పనిలో ఇశ్రాయేలు ప్రజలు ఎంతగా బలవంతం చేయబడితే, అంతగా వాళ్లు పెరిగి విస్తరించిపోయారు. కనుక ఇశ్రాయేలు ప్రజలను చూస్తోంటే, ఈజిప్టు వాళ్లు మరింత ఎక్కువగా భయపడిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","అందుచేత ఈజిప్టు వారు ఇశ్రాయేలు ప్రజల శరీర శ్రమను మునుపటికన్నా ఎక్కువగా కష్టతరం చేసి బలవంత పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","ఇశ్రాయేలీయుల జీవితాన్ని చాలా కష్టతరం చేశారు ఈజిప్టువారు. అడుసు తొక్కి ఇటుకలు చేయడంలో వాళ్లు ఇశ్రాయేలు ప్రజల్ని బలవంతం చేశారు. అలాగే పొలాల్లో పనిచేయడానికి కూడా వాళ్లను చాల బలవంత పెట్టారు. వాళ్లు చేసిన ప్రతి పనిలోనూ వాళ్లను చాల బలవంత పెట్టి ఒత్తిడి చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","షిఫ్రా, పూయా అను ఇద్దరు మంత్రసానులుండే వారు. వీరు ఇశ్రాయేలు స్త్రీల కాన్పు సమయాల్లో సహాయ పడేవారు. ఈజిప్టు రాజు ఈ మంత్రసానులను పిలిచి, ");
INSERT INTO tel2010_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“ఈ హీబ్రూ స్త్రీలు పిల్లల్ని కనడంలో మీరు ఇలానే సహాయం చేస్తూ ఉండండి. ఒకవేళ ఆడపిల్ల పుడితే ఆ పిల్లను బ్రతకనివ్వండి, కాని శిశువు మగవాడైతే మాత్రం తప్పక చంపేయండి” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ఆ మంత్రసానులు దైవ భక్తిగలవాళ్లు గనుక వారు రాజుగారి ఆజ్ఞకు లోబడలేదు. మగ పిల్లలందర్నీ వాళ్లు బ్రతకనిచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ఈజిప్టు రాజు ఆ మంత్రసానులను పిలిచి, “మీరు ఎందుకిలా చేసారు? ఆ మగపిల్లల్ని ఎందుకు బ్రతకనిచ్చారు?” అంటూ ప్రశ్నించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","“ఈజిప్టు స్త్రీలకంటె హీబ్రూ స్త్రీలకు చాల బలం ఉంది. సహాయం చేసేందుకు మేము వెళ్లేలోపుగానే వాళ్లు పిల్లల్ని కనేసారు.” అంటూ మంత్రసానులు ఫరోతో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","ఆ మంత్రసానుల విషయమై దేవుడు సంతోషించాడు కనుక వాళ్లకూ వారి స్వంత కుటుంబాలు ఉండేటట్టు దేవుడు వారికి మేలు చేశాడు. హీబ్రూ ప్రజలు ఇంకా పిల్లల్ని కంటూనే ఉన్నారు. వాళ్లు చాలా బలవంతులయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","కనుక ఫరో, “మగశిశువు పుట్టినప్పుడల్లా, మీరు వాడ్ని నైలు నదిలో పడవేయండి. కాని ఆడపిల్లల్ని అందరినీ బ్రతకనియ్యండి” అని తన ప్రజలకు ఆజ్ఞాపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","లేవీ వంశానికి చెందిన ఒకడు ఉన్నాడు. లేవీ వంశానికి చెందినదాన్నే ఒకామెను అతడు పెళ్లి చేసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","ఆమె గర్భవతియై ఒక కుమారుణ్ణి కన్నది. శిశువు చాలా అందంగా ఉండడం చూసి ఆ తల్లి మూడ్నెల్లపాటు ఆ శిశువును దాచి ఉంచింది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","అయితే మూడు నెలలు అయ్యాక ఆ శిశువు సంగతి తెలిసిపోతుందేమోనని ఆ తల్లి భయపడింది. అలా తెలిస్తే ఆ శిశువు మగపిల్లవాడు కనుక వాడ్ని చంపేస్తారు. అందుకని ఆమె జమ్ముతో ఒక బుట్టను తయారు చేసి, అది నీళ్లలో తేలడానికిగాను దానికి తారు పూసింది. శిశువును ఆ బుట్టలో పెట్టింది. ఆమె తర్వాత నది ఒడ్డున ఏపుగా పెరిగిన జమ్ములో ఆ బుట్టను పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ఆ పసివాడి అక్క అక్కడే వుండి గమనిస్తూవుంది. ఆమె ఆ పసివాడికి ఏమి జరుగుతుందో చూడాలని అనుకొంది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","సరిగ్గా అదే సమయంలో ఫరో కూతురు స్నానం చేయడానికి నది దగ్గరకు వెళ్లింది. ఆమె పని మనుషులు నది గట్టు మీద తిరుగుతూ ఉన్నారు. జమ్ములో ఉన్న బుట్టను ఆమె చూసింది. వెళ్లి ఆ బుట్టను తీసుకు రమ్మని ఆమె తన పనికత్తెల్లో ఒక దానితో చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","రాజకుమారి ఆ బుట్ట తెరచి, అందులో ఉన్న మగ పిల్లాడ్ని చూసింది. ఆ పసివాడు ఏడుస్తూ ఉండడం చూసి, ఆమె జాలి పడింది. “వీడు హీబ్రూ పిల్లవాడని” ఆమె చెప్పింది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ఇంకా అప్పటివరకు దాక్కొని ఉన్న ఆ పసివాని అక్క లేచి, “ఈ పసివాడ్ని పెంచటానికి మీకు సహాయం చేసేందుకు ఒక హీబ్రూ స్త్రీని వెదకి తీసుకొని రమ్మంటారా?” అని రాజకుమారిని అడిగింది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","“సరే అలాగే తీసుకురా” అంది రాజకుమారి. ఆ పిల్ల వెళ్లి ఆ పసివాడి స్వంత తల్లినే తీసుకొచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","“ఈ పసివాడ్ని తీసుకొని వెళ్లి పాలిచ్చి నాకోసం పెంచు. పసివాడ్ని జాగ్రత్తగా చూడు. నీకు నేను జీతం ఇస్తాను” అంది ఆ రాజకుమారి. కనుక ఆ స్త్రీతన పసివాణ్ణి తీసుకొని జాగ్రత్తగా పెంచింది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ఆ పసివాడు పెద్దవాడయ్యాడు. కొన్నాళ్లకు ఆ స్త్రీ పిల్లవాడ్ని రాజకుమారి దగ్గరకు తీసుకొచ్చింది. రాజకుమారి ఆ పిల్లవాడ్ని తన సొంత కుమారుడుగా స్వీకరించింది. ఆ పిల్లవాడ్ని నీళ్లలోంచి బయటికి తీసింది కనుక ఆమె వానికి మోషే అని పేరు పెట్టింది. ");
INSERT INTO tel2010_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","మోషే పెరిగి పెద్దవాడయ్యాడు. తన ప్రజలు అంటే, హీబ్రూవారు బలవంతంగా చాలా కష్టపడి పని చేయాల్సి ఉన్నట్టు మోషే గ్రహించాడు. ఒకరోజు ఈజిప్టు వాడొకడు హీబ్రూవాడ్ని కొట్టడం మోషే చూసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","ఎవరైనా గమనిస్తున్నారేమోనని మోషే అటు ఇటు చూసాడు. తర్వాత మోషే ఆ ఈజిప్టువాడ్ని చంపేసి ఇసుకలో పాతిపెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","మర్నాడు హీబ్రూవాళ్లే ఇద్దరు పోట్లాడుకోవడం మోషే చూసాడు. వారిలో ఒకడిది తప్పని తెలుసుకొని “అతనితో ఎందుకిలా మీవాడ్ని కొడుతున్నావు?” అని అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","దానికి అతను జవాబిస్తూ, “మామీద నీవు అధికారివనిగాని, న్యాయమూర్తివనిగాని ఎవరయినా నియమించారా? నిన్న నీవు ఆ ఈజిప్టువాడ్ని చంపినట్టు నన్నూ చంపుతావా?” అన్నాడు. అప్పుడు మోషే భయపడిపోయాడు. “అలాగైతే నేను చేసిన ఆ పని ఇప్పుడు అందరికీ తెలిసిపోయిందని” మోషే తనలో తాను అనుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","మోషే చేసినదాన్ని గూర్చి విని ఫరో మోషేను చంపెయ్యాలనే నిర్ణయానికొచ్చాడు! కానీ ఫరో దగ్గర్నుండి మోషే పారిపోయాడు. మోషే మిద్యాను దేశానికి పారిపోయి అక్కడ ఒక బావివద్ద ఆగిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","మిద్యానులో ఒక యాజకునికి ఏడుగురు కుమార్తెలు. ఒకరోజు వారు తమ తండ్రిగారి గొర్రెలకు నీళ్లు తీసుకొని రావడానికి ఆ బావి దగ్గరకు వెళ్లారు. వారు ఆ నీళ్ల కుండలను నింపడానికి ప్రయత్నం చేస్తూ ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","కాని అక్కడ ఉన్న కొందరు గొర్రెల కాపరులు ఆ అమ్మాయిలను నీళ్లు చేదుకోనివ్వకుండా వెళ్లగొట్టేస్తున్నారు. కనుక ఆ అమ్మాయిలకు మోషే సహాయం చేసి, వారి గొర్రెల మందకు నీళ్లు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","తర్వాత వాళ్లు వారి తండ్రి రగూయేలు దగ్గరకు వెళ్లిపోయారు. “ఆయన వారితో ఈ రోజు మీరు చాలా త్వరగా ఇంటికి వచ్చేశారు” అని అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","“గొర్రెల కాపరులు కొందరు మమ్మల్ని వెళ్లగొట్టడానికి ప్రయత్నం చేసారు. అయితే ఈజిప్టు మనిషి ఒకతను సహాయం చేసాడు. అతడే మాకోసం నీళ్లు చేది, మా మందలకు పెట్టాడు” అంటూ జవాబు చెప్పారు ఆ అమ్మాయిలు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","అందుకు రగూయేలు “అలాగైతే అతనేడి? అతణ్ణి ఎందుకలా విడిచిపెట్టారు? మీరు అతణ్ణి మనతో భోజనం చేయమని పిలవండి” అన్నాడు తన కూతుళ్లతో. ");
INSERT INTO tel2010_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","అతనితో కలిసి ఉండటానికి మోషే అంగీకరించాడు. అతను సిప్పోర అనే తన కూతుర్ని మోషేకు భార్యగా ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","సిప్పోరాకు కొడుకు పుట్టాడు. అతనికి గెర్షోము అని మోషే పేరు పెట్టాడు. మోషే తనది కాని మరో పరాయి దేశంలో ఉండడం చేత తన కొడుక్కు ఈ పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","చాలాకాలం గడచిపోయింది. ఈజిప్టురాజు చనిపోయాడు. అప్పటికి ఇశ్రాయేలు వాళ్లు ఇంకా కష్టతరమైన పనులు చేసేందుకు బలవంత పెట్టబడుతూనే ఉన్నారు. వాళ్లు సహాయం కోసం మొరపెడుతూ ఉన్నారు. దేవుడు వారి మొర విన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","దేవుడు వారి ప్రార్థనలు విని, అబ్రాహాం, ఇస్సాకు, యాకోబులతో తాను చేసుకొన్న ఒడంబడికను జ్ఞాపకం చేసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ఇశ్రాయేలీయుల కష్టాలను దేవుడు చూచాడు. త్వరలోనే వారి కష్టాలను కడతేర్చాలని ఆయనకు తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","మోషే మామగారి పేరు యిత్రో (ఈయన మిద్యాను వారికి యాజకుడు). యిత్రో గొర్రెలకు మోషే కాపరి అయ్యాడు. ఒకనాడు మోషే అరణ్యానికి పశ్చిమంగా ఆ గొర్రెల్ని తోలుకుపోయాడు. అక్కడ హోరేబు అనే ఒక కొండ ఉంది. అది దేవుని కొండ. ");
INSERT INTO tel2010_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","ఆ కొండమీద మండుతున్న ఒక పొదలో యెహోవా దూతను మోషే చూసాడు. ఆ పొద మండిపోతూ కాలిపోకుండా ఉండటం మోషే చూశాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","అందుచేత మోషే, “ఈ పొద మండుతూ ఉండి కాలిపోకుండా ఎలా వుందో దగ్గరకు వెళ్లి చూడాలి” అనుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ఆ పొదను చూచేందుకు మోషే వస్తూ ఉండటం యెహోవా చూశాడు. అందుచేత ఆ పొదలోంచే దేవుడు, “మోషే, మోషే” అని మోషేను పిల్చాడు. “చిత్తం ప్రభూ” అన్నాడు మోషే. ");
INSERT INTO tel2010_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","అప్పుడు దేవుడు ఇలా అన్నాడు, “ఇక దగ్గరకు రాకు. నీ చెప్పులు విడువు. నీవు నిలబడింది పవిత్ర స్థలం ");
INSERT INTO tel2010_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","నేను నీ పూర్వీకుల దేవుణ్ణి. నేను అబ్రాహాం, ఇస్సాకు, యాకోబుల దేవుణ్ణి.” దేవుణ్ణి చూడాలంటే, భయం వేసింది కనుక మోషే తన ముఖం కప్పుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","యెహోవా “ఈజిప్టులో నా ప్రజలు అనుభవిస్తున్న కష్టాలు నేను చూశాను. ఈజిప్టు వాళ్లు నా ప్రజల్ని బాధపెట్టినప్పుడు వారు మొర పెట్టడం నేను విన్నాను. వారి బాధ నాకు తెలుసు ");
INSERT INTO tel2010_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ఈజిప్టు వాళ్ల బారినుండి నా ప్రజల్ని రక్షించేందుకు ఇక నేను దిగి వస్తాను. ఆ దేశం నుండి వాళ్లను బయటకు తెచ్చి, మరో మంచి దేశానికి నడిపిస్తాను. అక్కడ వాళ్లు ఏ కష్టాలూ లేకుండా స్వేచ్ఛగా ఉంటారు. అది మంచి మంచి వాటితో నిండిన చాలా మంచి దేశం. కనానీయులు, హిత్తీయులు, అమోరీయులు, పెరిజ్జీయులు, హివ్వీయులు, యోబూసీయులు, రకరకాల మనుష్యులు అక్కడ నివసిస్తున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","ఇశ్రాయేలీయుల మొరలు నేను విన్నాను. వాళ్ల జీవితాన్ని ఈజిప్టు వాళ్లు ఎంత కష్టతరం చేసారో నేను చూశాను. ");
INSERT INTO tel2010_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","అందుచేత నేను ఇప్పుడు ఫరో దగ్గరకు నిన్ను పంపిస్తున్నాను. వెళ్లు, నా ప్రజలైన ఇశ్రాయేలీయులను ఈజిప్టు నుంచి బయటకు తీసుకువెళ్లు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","అయితే మోషే, “నేనేమీ అంతగొప్ప వాణ్ణి కాదే. ఫరో దగ్గరకు వెళ్లేందుకుగాని, ఈజిప్టు నుండి ఇశ్రాయేలీయులను బయటకు నడిపించేందుకుగాని నేను ఎంతటివాణ్ణి?” అంటూ దేవుణ్ణి అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","“నేను నీకు తోడుగా ఉంటాను గనుక నీవు చేయగలవు. నేనే నిన్ను పంపిస్తున్నాను అనేందుకు రుజువు ఏమిటంటే, నీవు ఈ ప్రజల్ని ఈజిప్టు నుండి బయటికి నడిపించిన తర్వాత నీవు మళ్లీ వచ్చి ఈ కొండమీదనే నన్ను ఆరాధిస్తావు!” అని దేవుడు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","దానికి మోషే, “నేను ఇశ్రాయేలీయుల దగ్గరకు వెళ్లి ‘మీ పూర్వీకుల దేవుడు నన్ను మీ దగ్గరకు పంపించాడు’ అని చెబితే, ‘ఆ దేవుడి పేరేమిటి’ అని వాళ్లు నన్ను అడుగుతారు గదా! మరి నేనేమని చెప్పాలి,” అని దేవుణ్ణి అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","“‘నేను ఉన్నవాడను’ (అని వారితో చెప్పు) అన్నాడు దేవుడు మోషేతో. ఇశ్రాయేలీయుల దగ్గరకు నీవు వెళ్లినప్పుడు, ‘ఉన్నవాడను,’ అనువాడు నన్ను మీ దగ్గరకు పంపించాడు అని చెప్పు” అన్నాడు దేవుడు మోషేతో. ");
INSERT INTO tel2010_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","దేవుడు మోషేతో ఇలా చెప్పాడు: “మీ పూర్వీకులు, అబ్రాహాము, ఇస్సాకు, యాకోబలకు ఎల్లప్పుడూ నా పేరు యెహోవాగానే ఉంటుంది. తరతరాల ప్రజలు ఆ పేరుతోనే నన్ను తెలుసుకొంటారు. ‘యెహోవా నన్ను మీ దగ్గరకు పంపించాడు’ అని వాళ్లతో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“వెళ్లి ఇశ్రాయేలు సమాజంలోని పెద్దలందరిని సమావేశపరిచి, ‘మీ పూర్వీకుల దేవుడైన యెహోవా నాకు ప్రత్యక్షం అయ్యాడు. అబ్రాహాము, ఇస్సాకు, యాకోబుల దేవుడు నాతో మాట్లాడాడు. మిమ్మల్ని గూర్చి ఈజిప్టులో మీకు సంభవించిన సంగతులను గూర్చి నేను ఆలోచించాను. ");
INSERT INTO tel2010_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ఈజిప్టులో మీరు అనుభవిస్తున్న శ్రమలనుండి మిమ్మల్ని తప్పించాలనే నిర్ణయానికొచ్చాను. ప్రస్తుతం కనానీయులు, హిత్తీయులు, అమోరీయులు, పెరిజ్జీయులు, హివ్వీయులు, యోబూసీయులు, అనే రకరకాల ప్రజలకు చెందిన ఒక దేశానికి నేను మిమ్మల్ని నడిపిస్తాను. చాలా మంచి మంచి వాటితో నిండిన ఒక మంచి దేశానికి నేను మిమ్మల్ని నడిపిస్తాను’ అని వాళ్లతో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“పెద్దలు (నాయకులు) నీ మాట వింటారు. అప్పుడు నీవు, పెద్దలు (నాయకులు) కలిసి ఈజిప్టు రాజు దగ్గరకు వెళ్లాలి. ‘హీబ్రూ ప్రజల దేవుడైన యెహోవా మాకు ప్రత్యక్షమయ్యాడు. మూడు రోజుల దూరము అరణ్యంలోనికి ప్రయాణం చేసి వెళ్లమని ఆయన చెప్పాడు. అక్కడ మా యెహావా దేవునికి మేము బలులు అర్పించాలి. అని నీవు అతనితో చెప్పాలి.’ ");
INSERT INTO tel2010_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“అయితే ఈజిప్టు రాజు మిమ్మల్ని పోనియ్యడని నాకు తెలుసు. అతడు మిమ్మల్ని పోనిచ్చేటట్టు ఒక మహాశక్తి మాత్రమే అతణ్ణి బలవంతం చేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","కనుక ఈజిప్టు మీద నేను నా మహాశక్తిని ప్రయోగిస్తాను. ఆ దేశంలో అద్భుతాలు జరిగేటట్టు చేస్తాను. నేను అలా చేసిన తర్వాత అతడు మిమ్మల్ని వెళ్లనిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","అంతే కాదు ఈజిప్టు వాళ్లు ఇశ్రాయేలు ప్రజలమీద దయ చూపించేటట్టుగా చేస్తాను. అందుచేత మీరు వెళ్లిపోయేటప్పుడు నీ ప్రజలకు వాళ్లు కానుకలను ఇస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","“హీబ్రూవాళ్లలో ప్రతి స్త్రీ తన పొరుగున ఉండే ఈజిప్టు వాళ్లను, ఆ ఇళ్లలో వుండే వాళ్లందర్నీ అడగ్గానే వాళ్లు ఆమెకు కానుకలు ఇస్తారు. వెండి, బంగారం, మంచి బట్టలు, కానుకలుగా మీవారికి దొరుకుతాయి. మీరు ఈజిప్టు విడిచి వెళ్లేటప్పుడు మీరు ఆ కానుకలను మీ పిల్లలకు పెట్టాలి. ఈ విధంగా ఈజిప్టు ఐశ్వర్యాన్ని మీరు తీసుకోవాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","అప్పుడు మోషే, “నీవు నన్ను పంపించావు అని చెబితే ఇశ్రాయేలు ప్రజలు నమ్మరు గదా! ‘యెహోవా నీకు కనబడనే లేదు అంటారు వాళ్లు’” అన్నాడు దేవునితో. ");
INSERT INTO tel2010_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","అయితే దేవుడు, “నీ చేతిలోనిది ఏమిటి” అని మోషేను అడిగాడు. “ఇది నా చేతికర్ర” అని మోషే జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","అప్పుడు దేవుడు, “నీ కర్ర కింద పడవెయ్యి” అన్నాడు. మోషే తన కర్రను నేల మీద పడేసాడు. ఆ కర్ర ఒక పాముగా మారిపోయింది. మోషే భయపడి దాని దగ్గర్నుండి పారిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","అయితే యెహోవా మోషేతో, “ముందుకు వెళ్లి ఆ పాము తోక అందుకో” అన్నాడు. మోషే ముందుకు వెళ్లి పాముతోక అందుకొన్నాడు. మోషే అలా చేయగానే ఆ పాము మళ్లీ కర్ర అయిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","“ఈ కర్రను ఇలా ప్రయోగించు, అప్పుడు మీ పూర్వీకుల దేవుడు, అబ్రాహాము దేవుడు, ఇస్సాకు దేవుడు, యాకోబు దేవుడు అయిన యెహోవా నీకు ప్రత్యక్షమయ్యాడని నీ ప్రజలు నమ్ముతారు” అన్నాడు దేవుడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ఆ తర్వాత యెహోవా, “నీకు ఇంకో రుజువు ఇస్తాను. నీ చెయ్యి నీ చొక్కాలోపల పెట్టు” అన్నాడు మోషేతో. కనుక మోషే తన చొక్కా తెరిచి తన చేతిని లోపల పెట్టాడు. మళ్లీ మోషే తన చొక్కాలోనుంచి తన చేతిని బయటికి తీయగానే అది మారిపోయింది. అతని చేతినిండా మంచులాంటి తెల్లని కుష్ఠు మచ్చలు కప్పేసాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","“నీ చేతిని మళ్లీ నీ చొక్కాలో పెట్టు” అన్నాడు దేవుడు. మోషే తన చేతిని మళ్లీ తన చొక్కాలోపల పెట్టాడు. మోషే అలా పెట్టి మళ్లీ తన చేతిని బయటికి తీయగానే అతని చెయ్యి మారిపోయింది. ఇప్పుడు అతని చెయ్యి బాగైపోయి మళ్లీ మునుపటిలానే ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“నీకర్రను ఉపయోగించినప్పుడు ప్రజలు నిన్ను నమ్మకపోతే, నీవు ఈ సూచన చూపెట్టినప్పుడు వాళ్లు నిన్ను నమ్ముతారు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","నీవు వాళ్లకు ఈ రెండు సూచనలు చూపించాక కూడ వాళ్లు నమ్మటానికి నిరాకరిస్తే, అప్పుడు నైలు నదిలోనుంచి కొన్ని నీళ్లు తీసుకో, ఆ నీళ్లను నేలమీద పొయ్యి. అవి నేలను తాకగానే రక్తం అవుతాయి” అన్నాడు దేవుడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","అయితే మోషే దేవునితో, “కానీ ప్రభూ నేను నిజం చెప్పేస్తున్నాను. నేనేమీ నైపుణ్యంగల మాటకారిని కాను. నాకు మనుష్యులతో చక్కగా మాట్లాడ్డం ఎప్పుడూ చేతకాలేదు. కనీసం ఇప్పుడు నీతో మాట్లాడిన తర్వాత కూడ నేను మంచి మాటకారిని కాలేదు. నా మాట నిదానం అనీ, నాకు మంచి పద ప్రయోగంరాదనీ నీకు తెలుసు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","“మనిషి నోటిని చేసిందెవరు? ఒకన్ని చెవిటివాడిగా లేక మూగవాడిగా చేయగలిగింది ఎవరు? ఒకన్ని గుడ్డివానిగా చేయగలిగింది, చూడగలిగేటట్టు చేయగలిగింది ఎవరు? నీటన్నింటిని చేయగలిగింది నేనే, నేను యెహోవాను, ");
INSERT INTO tel2010_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","అందుచేత వెళ్లు. నీవు మాట్లాడేటప్పుడు నేను నీతో ఉంటాను. చెప్పాల్సిన మాటలు నేనే నీకు చెబతాను” అని అతనితో యెహోవా అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","కానీ మోషే, “నా ప్రభువా, నన్ను విడిచిపెట్టి మరెవర్నయినా పంపించుమని బతిమాలు కొంటున్నాను” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","యెహోవాకు మోషేమీద కోపం వచ్చింది, “లేవీ వంశానికి చెందిన నీ సోదరుడు అహరోనును నేను వాడుకొంటాను. అతనికి మాట్లాడుటలో నైపుణ్యం ఉంది. అహరోను నీ దగ్గరకు వస్తాడు. నిన్ను చూచి సంతోషిస్తాడు, ");
INSERT INTO tel2010_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","అతడు నీతోకూడ ఫరో దగ్గరకు వస్తాడు. నీవు చెప్పాల్సిందేమిటో నేను నీకు చెబతాను, అది నీవు అహరోనుకు చెప్పాలి. ఫరోతో చెప్పటానికి అహరోను సరైన మాటల్ని సిద్ధం చేసుకొంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","ప్రజలతో కూడ అహరోనే నీ పక్షంగా మాట్లాడుతాడు. అతనికి నీవు ఒక మహారాజులా ఉంటావు. అతనే అధికారంతో నీ తరపున మాట్లాడతాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","కనుక వెళ్లు. నీతోకూడ నీ కర్ర తీసుకొని వెళ్లు. నీకు నేను తోడుగా ఉన్నానని ప్రజలకు తెలియడానికి నీ కర్రను, మిగతా అద్భుతాలను ప్రయోగించు” అన్నాడు దేవుడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","అప్పుడు మోషే తన మామ యిత్రో ఇంటికి తిరిగి వెళ్లాడు. “ఈజిప్టులో నా ప్రజల దగ్గరకు నేను మళ్లీ వెళతాను, నన్ను పోనివ్వండి. వాళ్లు ఇంకా బతికే ఉన్నారేమో నేను వెళ్లి చూడాలి” అని యిత్రోతో చెప్పాడు మోషే. “నీవు సమాధానంగా వెళ్లొచ్చు” అన్నాడు యిత్రో మోషేతో. ");
INSERT INTO tel2010_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","తర్వాత మోషే ఇంకా మిద్యానులో ఉండగానే దేవుడు మోషేతో, “ఇప్పుడు నీవు మళ్లీ ఈజిప్టు వెళ్లడం నీకు క్షేమం. నిన్ను చంపాలని చూస్తున్న వాళ్లు ఇప్పుడు చనిపోయారు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","కనుక మోషే తన భార్యను, తన కొడుకును బయల్దేరదీసి గాడిదల మీద ఎక్కించాడు. తిరిగి ఈజిప్టు దేశానికి ప్రయాణం కట్టాడు. దేవుని శక్తిగల తన కర్రను మోషే తనతో తీసుకొని వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","మోషే ఈజిప్టుకు ప్రయాణం చేస్తూండగా దేవుడు అతనితో మాట్లాడాడు: “నీవు ఫరోతో మాట్లాడేటప్పుడు నీవు ఏమేమి అద్భుతాలు చేసేందుకు నీకు శక్తి ఇచ్చానో వాటన్నింటినీ చేయాలని జ్ఞాపకం ఉంచుకో! అయితే నేను మాత్రం ఫరో ఇంకా మొండికెత్తేటట్లు చేస్తాను. అతడు ప్రజల్ని వెళ్లనియ్యడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","అప్పుడు నీవు ఫరోతో ");
INSERT INTO tel2010_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","‘ఇశ్రాయేలు నా ప్రథమ సంతానంగా పుట్టిన కుమారుడు. నా కుమారుడు వెళ్లి నన్ను ఆరాధించనివ్వు అని నేను నీతో చెబతున్నాను. నీవే గనుక ఇశ్రాయేలీయులను వెళ్లనివ్వకపోతే, నీ పెద్ద కుమారుణ్ణి నేను చంపేస్తాను.’” అని యెహోవా అనుచున్నాడని అతనితో చెప్పెను. ");
INSERT INTO tel2010_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","మోషే ఈజిప్టుకు తన ప్రయాణం కొనసాగించాడు. నిద్రపోవాలని అతడు ఒక సత్రములో ఆగాడు. అక్కడ దేవుడు మోషేను కలుసుకొని అతణ్ణి చంపదలచాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","కాని సిప్పోర పదునైన ఒక కత్తి తీసుకొని తన కుమారునికి సున్నతి చేసింది. ఆ చర్మం పట్టుకొని ఆమె అతని పాదాలను తాకింది. అప్పుడు ఆమె (మోషేతో) “నీవు రక్త సంబంధమైన భర్తవు అని అంది” ");
INSERT INTO tel2010_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","సిప్పోర తన కుమారునికి సున్నతి చేసినందువల్ల ఇలా చెప్పింది. అందుచేత దేవుడు మోషేను క్షమించాడు (అతణ్ణి చంపలేదు). ");
INSERT INTO tel2010_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","యెహోవా అహరోనుతో, “అరణ్యంలోకి వెళ్లి మోషేను కలుసుకో” అని చెప్పాడు. కనుక అహరోను వెళ్లి దేవుని పర్వతం దగ్గర మోషేను కలుసుకొన్నాడు. అహరోను మోషేను చూడగానే అతణ్ణి ముద్దు పెట్టుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","దేవుడు తనతో చెప్పినదంతా మోషే అహరోనుతో చెప్పాడు. దేవుడు తనను ఎందుకు పంపిందీ, అహరోనుతో చెప్పాడు మోషే. అలాగే అతను చేయాల్సిన అద్భుతాలు, చూపాల్సిన రుజువులు అన్నింటిని మోషే అహరోనుకు వివరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","అందుచేత మోషే, అహరోనూ వెళ్లి ఇశ్రాయేలు పెద్దలందర్నీ సమావేశం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","అప్పుడు ఆ ప్రజలతో వారు మాట్లాడారు. యెహోవా మోషేతో చెప్పిన విషయాలన్నీ అతడు వాళ్లతో చెప్పాడు. అప్పుడు వాళ్లందరూ చూచేటట్టు మోషే అద్భుతాలు చేసి రుజువు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","దేవుడు మోషేను పంపించాడని ఆ ప్రజలు నమ్మారు. ఇశ్రాయేలీయులకు సహాయం చేసేందుకు దేవుడు వచ్చాడని తెలిసి ఆ ప్రజలు దేవుని ముందర తలలు వంచుకొని ఆరాధించారు. వారి కష్టాలను దేవుడు చూసాడని తెలిసి వాళ్లు దేవుడ్ని ఆరాధించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","మోషే, అహరోనూ ప్రజలతో మాట్లాడిన తరువాత ఫరో దగ్గరికి వెళ్లారు, “‘నా కోసం పండుగ జరుపుకొనేందుకు నా ప్రజల్ని అరణ్యంలోకి వెళ్లనివ్వు’ అని ఇశ్రాయేలీయుల దేవుడైన యెహోవా చెబతున్నాడు,” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","అయితే ఫరో, “ఆ యెహోవా ఎవరు? అతనికి నేనెందుకు లోబడాలి? ఇశ్రాయేలీయులను నేనెందుకు వెళ్లనివ్వాలి? యెహోవా అని మీరు చెబతున్న వాడు నాకు తెలియదు. అందుచేత ఇశ్రాయేలీయులను నేను వెళ్లనీయను” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","దానికి మోషే, అహరోనులు, “హీబ్రూ ప్రజల దేవుడు మాతో మాట్లాడాడు. కనుక మూడు రోజుల ప్రయాణమంత దూరం మమ్మల్ని అరణ్యంలోనికి వెళ్లనివ్వాల్సిందిగా మనవి చేస్తున్నాము. అక్కడ మా యెహోవా దేవునికి ఒక బలి అర్పిస్తాము. ఇది మేము చేయకపోతే ఆయనకు కోపం వచ్చి మమ్మల్ని నాశనం చేస్తాడేమో. ఒక రోగం ద్వారానో, కత్తి చేతనో మమ్మల్ని చంపేస్తాడేమో” అని అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","కానీ ఫరో, “మోషే, అహరోనూ, ప్రజలను పని చేయనీయకుండా మీరు చేస్తున్నారు. మళ్లీ పోయి పనిచేసుకోమని ఆ బానిసలకు చెప్పండి. ");
INSERT INTO tel2010_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","పనివాళ్లు చాలా విస్తారంగా ఉన్నారు, మీరేమో వాళ్లను పని చెయ్యనివ్వడం లేదు” అని వాళ్లతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","అదేరోజు ఇశ్రాయేలీయుల పని మరింత కష్టతరం చేయమని ఫరో ఆజ్ఞాపించాడు. బానిసలపైనున్న యజమానులతో ");
INSERT INTO tel2010_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ఈ ప్రజలు ఇటుకలు చేసేందుకు గడ్డి ఎప్పుడూ మీరే ఇచ్చారు. కాని ఇప్పుడు ఇటుకలు చేసేందుకు అవసరమైన గడ్డిని వాళ్లే పోయి తెచ్చుకోవాలని వారికి చెప్పండి. ");
INSERT INTO tel2010_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","అయితే వాళ్లు మాత్రం ఇంతకు ముందు ఎన్ని ఇటుకలు చేసేవాళ్లో ఇప్పుడు కూడా అన్ని చేయాల్సిందే. వాళ్లు బద్ధకస్తులయి పోయారు. అందుకే వాళ్లను పోనివ్వుమని నన్ను అడుగుతున్నారు. వాళ్లు చేసేందుకు సరిపడినంత పనిలేదు. అందుకే తమ దేవునికి బలి ఇవ్వడానికి వెళ్లనిమ్మని నన్ను అడుగుతున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","కనుక వీళ్ల పని మరింత కష్టం అయేటట్టు చేయండి. వాళ్లకు బాగా పని చెప్పండి. అప్పుడు మోషే చెప్పే అబద్ధాలు వినేందుకు వాళ్లకు సమయం ఉండదు” అని చెప్పాడు ఫరో. ");
INSERT INTO tel2010_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","అందుచేత బానిసల పైనున్న ఈజిప్టు యజమానులు, హీబ్రూ ప్రజల నాయకుల దగ్గరకు వెళ్లి, “మీ ఇటుకల కోసం గడ్డి ఇవ్వకూడదని ఫరో నిర్ణయించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","మీకు మీరే పోయి గడ్డి తెచ్చుకోవాలి. కనుక వెళ్లి గడ్డి వెదుక్కోండి. అయితే మీరు మాత్రం ఇంతకు ముందు ఎన్ని ఇటుకలు చేసేవారో ఇప్పుడు కూడా అన్ని చేయాల్సిందే” అని వాళ్లతో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","కనుక గడ్డికోసం వెదుక్కొంటూ ఆ ప్రజలు ఈజిప్టు దేశ వ్యాప్తంగా వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","ఆ ప్రజలు మరింత కష్టపడి పనిచేసేటట్టు బానిస యజమానులు వాళ్లని బలవంతం చేస్తూనే ఉన్నారు. ఆ ప్రజలు అంతకు ముందు ఎన్ని ఇటుకలు చేసేవాళ్లో అన్ని చేసేటట్టు వారు వాళ్లను బలవంతపెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","బానిసలపై ఉండే ఈజిప్టు యజమానులు హీబ్రూ నాయకులను ఏర్పరచుకొని ప్రజలు చేసే పనికి వీళ్లను బాధ్యులుగా చేసారు, “మీరు ఇంతకు ముందు ఎన్ని ఇటుకలు చేసారో ఇప్పుడు కూడ అన్ని ఎందుకు చెయ్యడం లేదు? ఇది వరకు చేయగలిగారు అంటే, ఇప్పుడూ చేయగల్గుతారు!” అంటూ బానిసలపై ఉండే ఈజిప్టు యజమానులు హీబ్రూ నాయకులను కొట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","అప్పుడు హీబ్రూ నాయకులు ఫరో దగ్గరకు వెళ్లారు, “మేము నీ సేవకులము నీవు మమ్మల్ని ఎందుకు ఇలా చూస్తున్నావు? ");
INSERT INTO tel2010_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","నీవేమో మాకు గడ్డి ఇవ్వవు. కాని మేము మాత్రం ఇదివరకు ఎన్ని ఇటుకలు చేసామో అన్ని చేస్తూనే ఉండాలని ఆజ్ఞాపించావు. పైగా ఇప్పుడు ఈ యజమానులు మమ్మల్ని కొడుతున్నారు. ఇలా చేయడం నీ మనుష్యులదే తప్పు” అంటూ వారు ఫిర్యాదు చేసి చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ఫరో జవాబిస్తూ, “మీరు సోమరులు, మీకు పని చేయడం ఇష్టంలేదు. అందుకే మిమ్మల్ని పోనివ్వమని నన్ను అడుగుతున్నారు. అందుకే మీరు ఇక్కడ్నుండి వెళ్లిపోయి యెహోవాకు బలులు అర్పించాలని అంటున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","ఇక వెళ్లి పనిచెయ్యండి. మేము మీకు గడ్డి ఇవ్వము కాని మీరు మాత్రం ఇది వరకు ఎన్ని ఇటుకలు చేసేవాళ్లో ఇప్పుడు కూడ అన్ని చేయాలి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","చిక్కుల్లో పడ్డట్టు ఇశ్రాయేలు పెద్దలకు అర్థమయింది. వారు ఇంతకు ముందు చేసినన్ని ఇటుకలు ఇప్పుడు చేయలేరని ఆ నాయకులకు తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","వారు ఫరో సమావేశం నుండి వెళ్తూ మోషే, అహరోను ఉన్నచోట ఆగారు. వారికోసం మోషే అహరోనూ వేచియున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","వారు మోషే అహరోనులతో, “మమ్మల్ని వెళ్లనిమ్మని మీరు ఫరోతో చెప్పడం చాల తప్పు. ఫరో, అతని అధికారులు మమ్మల్ని ద్వేషించేటట్టు మీరు చేసారు కనుక యెహోవా మిమ్మల్ని శిక్షించాలి. మమ్మల్ని చంపే అవకాశం మీరే వారికి ఇచ్చారు” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","అప్పుడు మోషే యెహోవాను ప్రార్థించి, “ప్రభువా, ఎందుకు ఇలా నీ ప్రజలకు నీవు కీడు చేసావు? నీవు ఇక్కడికి నన్నెందుకు పంపించావు? ");
INSERT INTO tel2010_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","నన్ను చెప్పమని నీవు చెప్పిన సంగుతులన్నీ నేను ఫరో దగ్గరకు వెళ్లి చెప్పాను. కాని అప్పట్నుంచి నీ ప్రజల విషయంలో అతడు చాల నీచంగా ప్రవర్తిస్తున్నాడు. నీవు వాళ్లు సహాయం కోసం ఏమీ చేయలేదు!” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","అందుకు యెహోవా, “ఫరోకు నేను ఏమి చేస్తానో నీవు ఇప్పుడు చూస్తావు. అతని మీద నేను నా మహాశక్తిని ప్రయోగిస్తాను. దానితో అతడు నా ప్రజలను వెళ్లనిస్తాడు. వారు వెళ్లిపోవడానికి అతడు ఎంత ఇష్టపడతాడంటే, అతడే వారిని వెళ్లిపొమ్మని బలవంతం చేస్తాడు” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","మోషేతో దేవుడు ఇలా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","“యెహోవాను నేనే. అబ్రాహాము, ఇస్సాకు, యాకోబలకు నేను ప్రత్యక్షమయ్యాను. వాళ్లు, (ఎల్‌షద్దయి) సర్వశక్తిగల దేవుడు అని నన్ను పిలిచారు. నా పేరు యెహోవా అని వారికి తెలియలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","వారితో నేను ఒక ఒడంబడిక చేసాను. కనాను దేశం వారికి ఇస్తానని వాగ్దానం చేసాను. వారు ఆ దేశంలో నివసించారు గాని అది వారి స్వంత దేశం కాదు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ఇప్పుడు ఇశ్రాయేలు వాళ్లకు ఉన్న కష్టాలు నాకు తెలుసు. వారు ఈజిప్టుకు బానిసలుగా ఉన్నారని నాకు తెలుసు. నా ఒడంబడిక కూడా నాకు జ్ఞాపకం ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","కనుక నేను వాళ్లతో నీవు ఇలా చెప్పమన్నట్టు ప్రజలతో చెప్పు. ‘నేనే యెహోవాను, నేనే మిమ్మల్ని రక్షిస్తాను. నేను మిమ్మల్ని స్వతంత్రుల్నిగా చేస్తాను. ఈజిప్టు వాళ్లకు మీరు బానిసలుగా ఉండరు. నేను నా మహాశక్తిని ప్రయోగించి మహా భయంకర శిక్షను ఈజిప్టు వారి మీదికి రప్పిస్తాను. అప్పుడు మిమ్మల్ని నేను రక్షిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","మీరు నా ప్రజలుగా ఉంటారు. నేనే మీ దేవుడిగా ఉంటాను. నేనే యెహోవాను, మీ దేవుడనని, ఈజిప్టునుండి నేనే మిమ్మల్ని విడిపించానని మీరు తెలుసుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","అబ్రాహాము, ఇస్సాకు, యాకోబలకు నేను ఒక గొప్ప వాగ్దానం చేసాను. అందుచేత నేనే మిమ్మల్ని ఆ దేశానికి నడిపిస్తాను. ఆ దేశాన్ని నేను మీకు ఇస్తాను. అది మీదే అవుతుంది. నేను యెహోవాను.’” ");
INSERT INTO tel2010_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","అందుచేత మోషే ఇదంతా ఇశ్రాయేలు వాళ్లతో చెప్పాడు. అయితే, ప్రజలు పనిలో చాలా కష్టపడుచున్నందుచేత మోషేను వారు సహించలేదు. అతని మాట వారు వినలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","అప్పుడు యెహోవా మోషేతో ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ఇశ్రాయేలు ప్రజల్ని తన దేశంనుండి తప్పక వెళ్లిపోనివ్వాలని ఫరో దగ్గరకు వెళ్లి చెప్పు.” ");
INSERT INTO tel2010_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","అయితే మోషే, “ఇశ్రాయేలు ప్రజలే నా మాట వినరు. అలాంటప్పుడు ఫరో అంతకంటె వినడు. అసలే నాకు మాట్లాడటం చేతకాదు.”q అని అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","కాని మోషే, అహరోనులతో యెహోవా మాట్లాడాడు. వారు వెళ్లి ఇశ్రాయేలు ప్రజలతో మాట్లాడాలని యెహోవా వారికి ఆజ్ఞాపించాడు. ఫరో దగ్గరికి వెళ్లి అతనితో కూడ మాట్లాడాలని ఆయన వారికి ఆజ్ఞాపించాడు. ఇశ్రాయేలు ప్రజల్ని ఈజిప్టు నుండి బయటకు నడిపించుమని దేవుడు వారికి ఆజ్ఞాపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ఇశ్రాయేలు కుటుంబాల నాయకుల పేర్లు ఇవి: ఇశ్రాయేలు జ్యేష్ఠపుత్రుడు రూబేనుకు హనోకు, పల్లు, హెస్రోన్, కర్మి అనే నలుగురు కుమారులు గలరు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","యెమూయేలు, యామీను, ఓహదు, యాకీను, సోహరు, షావూలు అనువారు షిమ్యోను కుమారులు. (షావూలు కనానీ స్త్రీ ద్వారా పుట్టిన కుమారుడు). ");
INSERT INTO tel2010_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","లేవీ 137 సంవత్సరాలు బతికాడు. గెర్షోను, కహాతు, మెరారీ అనువారు లేవీ కుమారులు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","గెర్షోను కుమారులు లిబ్నీ, షిమీ. ");
INSERT INTO tel2010_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","కహాతు 133 సంవత్సరాలు బ్రతికాడు. అమ్రాము, ఇస్హారు, హెబ్రోను, ఉజ్జీయేలు అనువారు కహాతు కుమారులు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","మహలి, ముషి అను వారు మెరారీ కుమారులు. ఈ కుటుంబాలన్ని ఇశ్రాయేలు కుమారుడు లేవీ సంతానం. ");
INSERT INTO tel2010_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","అమ్రాము 137 సంవత్సరాలు బతికాడు. అమ్రాము తన తండ్రి సోదరి యోకెబెదును వివాహం చేసుకొన్నాడు. ఈ అమ్రాము కుమారులే మోషే, అహరోను. ");
INSERT INTO tel2010_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","కోరహు, నెపెగు, జిఖ్రీ అనువారు ఇస్హారు కుమారులు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","మిషాయేలు, ఎల్జఫను, సిత్రీ అనువారు ఉజ్జీయేలు కుమారులు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","అహరోను ఎలీషెబను వివాహం చేసుకొన్నాడు. (ఎలీషెబ అమ్మినాదాబు కుమార్తె. నయసోను సోదరి) అహరోను ఎలీషెబలకు నాదాబు, అబీహు, ఎలియాజరు, ఈతామారులు పుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","కోరహు కుమారులు అంటే, అస్సీరు, ఎల్కానా, అబియాసాపు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","అహరోను కుమారుడైన ఎలియాజరు పుతీయేలు కుమార్తెను పెండ్లాడాడు, వాళ్లు ఫీనెహాసుకు జన్మనిచ్చారు. ఈ మనుష్యులంతా ఇశ్రాయేలు కుమారుడైన లేవీ సంతానం. ");
INSERT INTO tel2010_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","అహరోను, మోషే ఈ వంశానికి చెందిన వాళ్లు, “ఇశ్రాయేలు ప్రజల వంశాలను నడిపించండి” అని యెహోవా చెప్పింది వీళ్లకే. ");
INSERT INTO tel2010_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","ఈజిప్టు రాజైన ఫరోతో మాట్లాడిన వాళ్లు అహరోను, మోషే, ఇశ్రాయేలు ప్రజల్ని ఈజిప్టు విడిచి పెట్టి వెళ్లనివ్వాల్సిందిగా ఫరోతో చెప్పింది వీళ్లే. ");
INSERT INTO tel2010_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ఈజిప్టు దేశంలో దేవుడు మోషేతో మాట్లాడాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“నేను యెహోవాను నేను నీతో చెప్పిందంతా ఈజిప్టు రాజుతో చెప్పు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","“కానీ, నేను చక్కగా మాట్లాడలేను గదా! రాజు నా మాట వినడు” అని జవాబిచ్చాడు మోషే. ");
INSERT INTO tel2010_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","మోషేతో యెహోవా ఇలా అన్నాడు, “నేను నీకు తోడుగా ఉంటాను. ఫరోకు నీవు ఒక మహారాజులా ఉంటావు. అహరోను నీ పక్షంగా మాట్లాడే మాటకారిగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","నీకు నేను ఆజ్ఞాపించేదంతా అహరోనుతో చెప్పు. నేను చెప్పే విషయాలన్నీ అతను రాజుతో చెబతాడు. ఇక ఫరో ఇశ్రాయేలు ప్రజలను ఈ దేశాన్ని వదిలిపోనిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","అయితే నేను ఫరోను మొండిగా చేస్తాను. (మీరు అతనితో చెప్పే సంగతులను అతడు లెక్క చేయడు) అప్పుడు నేను ఈజిప్టులో అనేక అద్భుతాలు చేస్తాను. అయినా అతను వినేందుకు నిరాకరిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","అందుచేత ఈజిప్టును నేను ఘోరంగా శిక్షిస్తాను. తర్వాత నా ప్రజలను ఆ దేశం నుండి నేను బయటకు నడిపిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","అప్పుడు నేనే యెహోవాను అని ఈజిప్టు ప్రజలు తెలుసుకుంటారు. నేను వాళ్లకు వ్యతిరేకంగా ఉంటాను. నేనే యెహోవానని వారు తెలుసుకొంటారు. అప్పుడు నేనే నా ప్రజలను ఆ దేశంనుండి బయటకు నడిపిస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","మోషే, అహరోనులు యెహోవా తమతో చెప్పిన ఈ మాటలకు విధేయులయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","అప్పటికి మోషే వయస్సు 80 సంవత్సరాలు అహరోను వయస్సు 83 సంవత్సరాలు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","మోషే, అహరోనులతో యెహోవా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“మీ శక్తి రుజువు చేయమని ఫరో మిమ్మల్ని అడుగుతాడు. ఒక అద్భుతం చేయమని మిమ్మల్ని అడుగుతాడు. అతని కర్ర నేలమీద పడవేయమని అహరోనుతో చెప్పు. ఫరో చూస్తూ ఉండగానే ఆ కర్ర పావు అవుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","కనుక మోషే, అహరోను ఫరో దగ్గరకు వెళ్లి యెహోవా చెప్పినట్టు చేసారు. అహరోను తన చేతి కర్రను కింద పడవేసాడు. ఫరో తన అధికారులతో కలసి చూస్తూ ఉండగానే ఆ కర్ర పాముగా అయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","కనుక రాజు తన విద్వాంసులను, మంత్రగాళ్లను పిలిపించాడు. వాళ్లు మంత్రాలు వేసి, అహరోను చేసినట్లే చేయగల్గారు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","వాళ్లు కూడా వారి కర్రలను నేల మీద పడవేసారు. ఆ కర్రలు పాములయ్యాయి, కాని అహరోను కర్ర వాళ్ల కర్రలను మింగేసింది. ");
INSERT INTO tel2010_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","అయినా సరే ప్రజలను వెళ్లనిచ్చేందుకు ఫరో ఒప్పుకోలేదు. ఎలా జరుగుతుందని యెహోవా చెప్పాడో అలాగే ఇది జరిగింది. మోషే, అహరోనుల మాట వినేందుకు రాజు ఒప్పుకోలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","అప్పుడు మోషే, అహరోనులతో యెహోవా ఇలా చెప్పాడు: “ఫరో మొండికెత్తాడు. ప్రజల్ని పోనిచ్చేందుకు ఫరో నిరాకరిస్తున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ఉదయాన్నే ఫరో నైలు నదికి వెళ్తాడు. నది ఒడ్డున అతని దగ్గరకు వెళ్లు. పాముగా మారిన ఆ కర్రను నీ వెంట తీసుకొనివెళ్లు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","అతనికి ఇలా చెప్పు: ‘హీబ్రూ ప్రజల దేవుడైన యెహోవా నన్ను నీ దగ్గరకు పంపించాడు. అరణ్యంలో నన్ను ఆరాధించటానికి నా ప్రజలను వెళ్లనివ్వు అని నీతో చెప్పమని యెహోవా నాతో చెప్పాడు. ఇప్పటివరకు నీవేమో యెహోవా మాట వినలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","కనుక యెహోవా చెబతున్నాడు, నేనే యెహోవానని చెప్పి నీవు ఇలా తెల్సుకొంటావు నా చేతిలో ఉన్న ఈ కర్రతో నైలు నది నీళ్లను నేను కొడతాను. నైలునది రక్తంగా మారిపోతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","దానితో నదిలో చేపలన్నీ చస్తాయి, నది కుళ్లు కంపు కొడుతుంది. అంతటితో ఈజిప్టు వాళ్లు నదిలో నీళ్లు తాగలేక పోతారు.’” ");
INSERT INTO tel2010_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","యెహోవా మోషేకు ఈ ఆజ్ఞ ఇచ్చాడు: “వారి నదులు, కాలువలు, చెరువుల మీద, వారు నీరు నిల్వ చేసే ప్రతి స్థలం మీద తన చేతి కర్ర చాపాలని అహరోనుకు చెప్పు. అతను ఇలా చెయ్యగానే నీళ్లన్నీ రక్తంగా మారిపోతాయి. చెక్క పాత్రలు, రాతి పాత్రల్లో ఉన్న నీళ్లతో సహా మొత్తం నీళ్లన్నీ రక్తంగా మారిపోతాయి.” ");
INSERT INTO tel2010_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","యెహోవా ఆజ్ఞ ప్రకారం మోషే, అహరోనులు చేసారు. అతను కర్ర పైకెత్తి నైలునది నీళ్లమీద కొట్టాడు. ఫరో, అతని అధికారులు అందరి ముందు అతడు ఇలా చేసాడు. నదిలో నీళ్లన్నీ రక్తంగా మారిపోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","నదిలో చేపలు చచ్చాయి. నది కుళ్లు కంపు కొట్టడం మొదలయింది. అందుచేత ఈజిప్టు వాళ్లు ఆ నదిలో నీళ్లు తాగలేక పోయారు. ఈజిప్టు అంతా రక్తమయం అయిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","మాంత్రికులు కూడ మాయలు చేసి అలాగే చేసారు. కనుక మోషే, అహరోనుల మాటను ఫరో లెక్కచేయలేదు. ఇది సరిగ్గా యెహోవా చెప్పినట్టే జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ఫరో ముఖం తిప్పుకొని తన ఇంట్లోకి వెళ్లిపోయాడు. మోషే, అహరోనులు చేసిన దాన్ని ఫరో అలక్ష్యం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ఈజిప్టు వాళ్లు నదిలో నీళ్లు త్రాగలేక పోయారు. అందుచేత తాగే నీళ్ల కోసం వాళ్లు ఆ నది చుట్టూ బావులు తవ్వారు. ");
INSERT INTO tel2010_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","నైలు నది నీళ్లను యెహోవా మార్చేసిన తర్వాత ఏడు రోజులు గడిచాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","మోషేతో యెహోవా ఇలా అన్నాడు, “ఫరో దగ్గరకు వెళ్లి, ‘నన్ను ఆరాధించడానికి నా ప్రజలను వెళ్లనివ్వు, అని యెహోవా చెబతున్నాడని అతనితో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","వారు వెళ్లడానికి ఫరో నిరాకరిస్తే నేను ఈజిప్టును కప్పలతో నింపేస్తాను ");
INSERT INTO tel2010_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","నైలు నది కప్పలతో నిండిపోతుంది. అవి నదిలోనుంచి వచ్చి మీ ఇళ్లలో దూరుతాయి. అవి మీ పడక గదుల్లో పడకల మీద వుంటాయి. మీ అధికారుల ఇళ్లలో, మీ వంట పాత్రల్లో, నీళ్ల బానల్లో కప్పలే ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","నీవు, నీ ప్రజలు, నీ అధికారులు అందరి మీదికీ కప్పలు వచ్చేస్తాయి.’” ");
INSERT INTO tel2010_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","అప్పుడు మోషేతో యెహోవా, “కాలువలు, నదులు, చెరువులు, అన్నింటి మీదికీ తన చేతి కర్రను ఎత్తమని అహరోనుతో చెప్పు. కప్పలు బయటకు వచ్చి ఈజిప్టు అంతటా నిండుతాయి” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","కనుక ఈజిప్టు జలాలపై అహరోను తన చేయి ఎత్తగా నీళ్లలో నుండి కప్పలు బయటకు వచ్చి, ఈజిప్టు దేశమంతా నిండిపోవటం మొదలయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","మాయలు చేసే ఈజిప్టు మాంత్రికులు కూడా అలాగే చేసారు, కనుక ఈజిప్టు మీదికి ఇంకా ఎక్కువ కప్పలు వచ్చాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","మోషే, అహరోనులను ఫరో పిలిపించాడు, “నా దగ్గర్నుండి, నా ప్రజల దగ్గర్నుండి కప్పలను తీసివేయుమని యెహోవాను అడగండి. యెహోవాకు బలులు అర్పించేందుకు ప్రజల్ని నేను వెళ్లనిస్తాను” అన్నాడు ఫరో. ");
INSERT INTO tel2010_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ఫరోతో మోషే ఇలాగు చెప్పాడు, “కప్పలు ఎప్పుడు పోవాలనుకుంటున్నావో నాతో చెప్పు, నీ కోసం, నీ ప్రజల కోసం, నీ అధికారుల కోసం నేను ప్రార్థన చేస్తాను. అప్పుడే కప్పలు మిమ్మల్ని, మీ ఇళ్లను విడిచిపెట్టి నదిలోనే ఉండిపోతాయి. (కప్పలు ఎప్పుడు నిన్ను వదిలి పోవాలనుకొంటున్నావు?)” ");
INSERT INTO tel2010_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","“రేపే” అన్నాడు ఫరో. మోషే అన్నాడు: “నీవు చెప్పినట్టే జరుగుతుంది. మా దేవుడైన, యెహోవాలాంటి దేవుడు ఇంకెవ్వరూ లేరని నీవు తెలుసుకొంటావు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","నిన్ను, నీ ఇంటిని, నీ అధికారుల్ని, నీ ప్రజల్ను కప్పలు విడిచిపోతాయి. ఆ కప్పలు నదిలోనే ఉండిపోతాయి.” ");
INSERT INTO tel2010_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","మోషే, అహరోను ఫరో దగ్గర్నుండి వెళ్లిపోయారు. ఫరో మీదికి ఆయన పంపిన కప్పల్నిగూర్చి మోషే యెహోవాకు మొరపెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","మోషే అడిగిన ప్రకారం దేవుడు చేసాడు. ఇళ్లలో, వాకిళ్లలో, పొలాల్లో కప్పలు చచ్చాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","అవి కుళ్లిపోయి దేశమంతా కంపు కొట్టడం మొదలయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","కప్పల బాధ వదలిపోవడం చూచి ఫరో మళ్లీ మొండికెత్తాడు. అతను ఏమి చెయ్యాలని మోషే అహరోనులు అడిగారో, అలా చేయలేదు. ఇదంతా సరిగ్గా యెహోవా చెప్పినట్టే జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","యెహోవా మోషేతో ఇలా అన్నాడు “నీ కర్ర పై కెత్తి నేలమీద దుమ్మును కొట్టు ఈజిప్టుదేశ వ్యాప్తంగా దుమ్ము పేలు అవుతాయి. అని అహరోనుతో చెప్పు.” ");
INSERT INTO tel2010_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","వారు అలా చేసారు. అహరోను తన చేతి కర్ర పై కెత్తి నేలమీద దుమ్మును కొట్టాడు. ఈజిప్టు అంతటా దుమ్ము పేలు అయింది. మనుష్యుల మీద జంతువుల మీద పేలు ఎక్కేసాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ఈజిప్టు మాంత్రికులు వారి మాయల్ని ప్రయోగించి వారు కూడ అలా చేయాలని ప్రయత్నం చేసారు. కానీ దుమ్ము నుండి పేలు వచ్చేటట్టు చేయలేక పోయారు. జంతువుల మీద, మనుష్యుల మీద పేలు అలాగే ఉండిపోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","కనుక ఇది యెహోవా శక్తివల్లే జరిగిందని మాంత్రికులు ఫరోతో చెప్పారు. కాని ఫరో వారు చెప్పింది ఒప్పుకోలేదు. ఇదీ సరిగ్గా యెహోవా చెప్పినట్టే జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","యెహోవా మోషేతో ఇలా అన్నాడు, “ఉదయాన్నే లేచి ఫరో దగ్గరకు వెళ్లు. ఫరో నదికి వెళ్తాడు. ‘నన్ను ఆరాధించడానికి నా ప్రజల్ని వెళ్లనివ్వు’ అని యెహోవా అంటున్నాడని అతనితో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","‘నీవు నా ప్రజల్ని వెళ్లనివ్వక పోతే, నీ ఇండ్లలోకి ఈగలు వచ్చేస్తాయి, నీ మీద, నీ అధికారుల మీద ఈగలు పట్టేస్తాయి. ఈజిప్టు గృహాలన్నీ ఈగలతో నిండిపోతాయి. ఈజిప్టు దేశమంతా ఈగలతో నిండిపోతుంది.’ ");
INSERT INTO tel2010_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","అయితే ఈజిప్టు ప్రజలను చూచినట్టు మాత్రం ఇశ్రాయేలు ప్రజల్ని నేను చూడను. నా ప్రజలు నివసిస్తున్న గోషెనులో మాత్రం ఈగలు ఉండవు. ఈ విధంగా నేను అంటే యెహోవాను ఈ భూమి మీద ఉన్నానని నీవు తెలుసుకొంటావు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","కనుక రేపు నా ప్రజల్ని నీ ప్రజల కంటే వేరుగా చూస్తాను. అదే నా రుజువు.” ");
INSERT INTO tel2010_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","అందుచేత యెహోవా అలాగే చేసాడు. ఈజిప్టు మీదికి విస్తారంగా ఈగలు వచ్చేసాయి. ఫరో ఇంట్లోను, అతని అధికారుల ఇండ్లన్నింటిలోను ఈగలు ఉన్నాయి. ఈజిప్టు అంతటా ఈగలు ముసురుకొన్నాయి. ఈగలు దేశాన్ని నాశనం చేస్తున్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","కనుక మోషే అహరోనుల్ని ఫరో పిలిపించాడు. “ఈ దేశంలోనే ఇక్కడే మీ దేవునికి బలులు అర్పించండి” అని ఫరో వాళ్లతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","కానీ మోషే అన్నాడు, “అలా చేయటం సరికాదు. మా దేవుడైన యెహోవాకు బలులు అర్పించటం చాలా భయంకర విషయం అని ఈజిప్టు వాళ్లు అనుకొంటారు. ఈజిప్టు వాళ్లకు కనబడేటట్టు మేము గనుక ఇలా చేస్తే, ఈజిప్టు వాళ్లు మమ్మల్ని రాళ్లతో కొట్టి చంపుతారు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","మూడు రోజుల ప్రయాణమంత దూరం మమ్మల్ని అరణ్యంలోకి వెళ్లనిచ్చి, అక్కడ మా యెహోవా దేవునికి బలులు అర్పించనివ్వు. యెహోవా మమ్మల్ని ఇలాగే చేయమన్నాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","అందుకు ఫరో, “మీరు వెళ్లి అరణ్యంలో మీ యెహోవా దేవునికి బలులు అర్పించనిస్తాను. కానీ మీరు మాత్రం మూడు రోజుల ప్రయాణమంత దూరంకంటే ఎక్కువ దూరం వెళ్లకూడదు. ఇక పోయి నాకోసం ప్రార్థించు.” అని మోషేతో అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","“సరే రేపు నీ నుండి, నీ ప్రజలనుండి, నీ అధికారుల దగ్గర్నుండి ఈగలను తొలిగించమని నేను పోయి యెహోవాను వేడుకొంటాను. కాని, ప్రజలు బలులు అర్పించకుండా నీవు మాత్రం ఆపు చేయకూడదు” అన్నాడు మోషే. ");
INSERT INTO tel2010_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","కనుక మోషే ఫరో దగ్గర్నుండి వెళ్లిపోయి యెహోవాకు ప్రార్థన చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","మోషే కోరినట్టు యెహోవా చేసాడు. ఫరోనుండి, అతని ప్రజలనుండి అధికారుల నుండి ఈగలను యెహోవా తొలగించాడు. ఈగలు ఒక్కటి కూడా మిగుల లేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","అయితే ఫరో మళ్లీ మొండికెత్తి ప్రజలను వెళ్ల నివ్వలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","అప్పుడు మోషేతో యెహోవా ఇలా చెప్పాడు: “నన్ను ఆరాధించేందుకు నా ప్రజలను వెళ్లనివ్వు అని హీబ్రూ ప్రజల ‘దేవుడైన యెహోవా అంటున్నాడని ఫరో దగ్గరికి వెళ్లి అతనితో చెప్పు.’ ");
INSERT INTO tel2010_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ఇంకా నీవు వారిని పోనివ్వక ఆపి ఉంచితే ");
INSERT INTO tel2010_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","పొలాల్లోని నీ జంతువులు అన్నింటి మీద యెహోవా తన శక్తిని ఉపయోగిస్తాడు. నీ గుర్రాలు, నీ గాడిదలు, ఒంటెలు, పశువులు, గొర్రెలు అన్నింటికీ భయంకర రోగం వచ్చేటట్టు యెహోవా చేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ఈజిప్టు జంతుజాలంకంటె ఇశ్రాయేలీయుల జంతువుల్ని యెహోవా ప్రత్యేకంగా చూస్తాడు. ఇశ్రాయేలీయులకు చెందిన జంతువుల్లో ఏదీ చావదు ");
INSERT INTO tel2010_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ఇదంతా జరగటానికి యెహోవా సమయాన్ని నిర్ణయించాడు. రేపు ఈ దేశంలో ఇది జరిగేటట్టు యెహోవా చేస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","మర్నాడు ఉదయాన్నే ఈజిప్టు పొలాల్లోని జంతువులన్నీ చచ్చాయి. కానీ ఇశ్రాయేలు ప్రజలకు చెందిన జంతువుల్లో ఒక్కటికూడా చావలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ఇశ్రాయేలీయుల జంతువులు ఏవైనా చచ్చాయేమో చూడమని ఫరో మనుష్యుల్ని పంపాడు. ఇశ్రాయేలీయుల జంతువుల్లో ఒక్కటి కూడ చావలేదు. ఫరో మాత్రం మొండిగానే ఉండిపోయాడు. అతడు ప్రజల్ని వెళ్లనివ్వలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","మోషే, అహరోనులకు యెహోవా ఇలా చెప్పాడు, “మీ చేతుల నిండా కొలిమిలోని బూడిదను తీసుకోండి. మోషే, ఫరో ముందర గాలిలో ఈ బూడిదను వెదజల్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","ఇది దుమ్ముగా మారి ఈజిప్టు దేశం అంతటా వ్యాపిస్తుంది. ఈజిప్టులో ఎప్పుడెప్పుడు ఏ వ్యక్తిని లేక జంతువును ఈ దుమ్ము తాకుతుందో ఆ చర్మంమీద దద్దుర్లు పుడతాయి.” ");
INSERT INTO tel2010_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","మోషే, అహరోనులు కొలిమి నుండి బూడిద తీసుకొన్నారు. తర్వాత వెళ్లి ఫరో ఎదుట నిలబడ్డారు. ఆ బూడిదను వారు గాలిలో వెదజల్లారు, మనుష్యుల మీద, జంతువుల మీద దద్దుర్లు పుట్టడం మొదలయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","చివరికి మాంత్రికులకు కూడా ఆ దద్దుర్లు వచ్చినందువల్ల మోషే ఇలా చేయకుండా మాంత్రికులు కూడా ఆపలేక పోయారు. ఈజిప్టు అంతటా ఇది జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","అయితే యెహోవా ఫరోను మొండి వాడిగా చేసాడు. అందుచేత మోషే, అహరోనుల మాట వినేందుకు ఫరో ఒప్పుకోలేదు. ఇది సరిగ్గా యెహోవా చెప్పినట్టే జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","అప్పుడు మోషేతో యెహోవా ఇలా అన్నాడు: “ఉదయాన్నే లేచి, ఫరో దగ్గరికి వెళ్లు. ‘నన్ను ఆరాధించడానికి, నా ప్రజలను వెళ్లనివ్వు అని హీబ్రూ ప్రజల దేవుడైన, యెహోవా అంటున్నాడని అతనితో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","నీవు గనుక ఇలా చెయ్యకపోతే, అప్పుడు నీ మీద, నీ ప్రజలమీద, నీ అధికారుల మీద నా శక్తి అంతా ప్రయోగిస్తాను. అప్పుడు నాలాంటి దేవుడు ప్రపంచంలోనే లేడని నీకు తెలుస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","నేను నా శక్తిని ప్రయోగించి, ఒక్క రోగం రప్పించానంటే, అది నిన్ను, నీ ప్రజల్ని భూమి మీద లేకుండా తుడిచి పారేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","అయితే ఒక కారణం వల్ల నేను నిన్ను ఇక్కడ ఉంచాను. నా శక్తిని నీవు చూడాలని నిన్ను ఇక్కడ ఉంచాను. అప్పుడు ప్రపంచ వ్యాప్తంగా ప్రజలు నా విషయం తెల్సుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","నీవు ఇంకా నా ప్రజలకు వ్యతిరేకంగా ఉన్నావు. నీవు వాళ్లను స్వతంత్రంగా వెళ్లనివ్వడంలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","కనుక రేపు ఈ వేళకు మహా బాధాకరమైన వడగళ్ల వానను నేను కురిపిస్తాను. ఇంతకు ముందు ఎన్నడూ ఈజిప్టు ఒక దేశంగా ఏర్పడినప్పటి నుండి ఇప్పటి వరకూ ఇలాంటి వడగళ్ల వాన పడలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ఇక నీవు నీ జంతువుల్ని క్షేమంగా ఉండేచోట పెట్టుకోవాలి. ప్రస్తుతం పొలాల్లో ఉన్న నీ స్వంతదైన ప్రతిదాన్నీ భద్రమైన చోట నీవు ఉంచుకోవాలి. ఎందుచేతనంటే పొలాల్లో నిలబడి ఉండే మనిషిగాని జంతువుగాని చచ్చినట్లే. ఇంట్లో చేర్చబడకుండా ఉండే ప్రతి దానిపై నా వడగళ్లు కురుస్తాయి.’” ");
INSERT INTO tel2010_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ఫరో అధికారులలో కొందరు యెహోవా మాటను గమనించారు. వాళ్లు వెంటనే వారి పశువులన్నిటినీ, బానిసలందరినీ ఇండ్లలో చేర్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","కాని మిగతా వాళ్లు యెహోవా సందేశాన్ని లెక్క చేయలేదు. అలాంటి వారు పొలాల్లో ఉన్న తమ బానిసలందరిని, జంతువులన్నింటిని అక్కడే ఉండ నిచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","నీ చేతులు గాలిలో పైకి ఎత్తు, “ఈజిప్టు అంతటా వడగళ్ల వాన ప్రారంభం అవుతుంది. ఈజిప్టు పొలాల్లో ఉన్న మొక్కలన్నిటి మీద, జంతువుల మీద, మనుష్యులందరి మీద వడగళ్లు పడతాయి” అని మోషేతో యెహోవా చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","కనుక మోషే తన కర్రను పైకి ఎత్తాడు, ఉరుములు, మెరుపులు వచ్చేటట్టు, భూమి మీద వడగళ్లు కురిసేటట్టు యెహోవా చేసాడు. ఈజిప్టు అంతటా వడగళ్లు పడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","వడగళ్లు పడుతోంటే, ఆ వడగళ్లతో పాటు మెరుపులు మెరిసాయి. ఈజిప్టు ఒక రాజ్యంగా ఏర్పడినప్పటి నుండి, ఈజిప్టును ఇంత దారుణంగా దెబ్బతీసిన వడగళ్ల వాన ఇదే. ");
INSERT INTO tel2010_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ఈజిప్టు పొలాల్లో ఉన్న సర్వాన్నీ ఈ వడగళ్ల వాన నాశనం చేసింది. మనుష్యుల్ని, జంతువుల్ని, మొక్కల్ని వడగళ్లు నాశనం చేసాయి. వడగళ్ల మూలంగా పొలాల్లోని చెట్లన్నీ విరిగి పోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ఇశ్రాయేలు ప్రజలు నివసించే గోషేను ఒక్కటే వడగళ్లు పడని ఒకే ఒక చోటు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","మోషే అహరోనులను ఫరో పిలిపించాడు. ఫరో వారితో, “ఈ సారి నేను పాపం చేసాను. యెహోవా న్యాయమంతుడు. తప్పు నాది, నా ప్రజలది. ");
INSERT INTO tel2010_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","వడగళ్లు, ఉరుములు మరీ భయంకరంగా ఉన్నాయి! వాటిని ఆపేయమని దేవుణ్ణి అడుగు. నేను మిమ్మల్ని వెళ్లిపోనిస్తాను. మీరు ఇక్కడ ఉండనక్కర్లేదు.” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","మోషే ఫరోతో చెప్పాడు: “నేను ఈ పట్టణంనుండి యెహోవా ఎదుట నా చేతులు చాచి ప్రార్థిస్తాను. ఉరుములు, వడగళ్లు ఆగిపోతాయి. ఈ భూమిమీద యెహోవా ఉన్నాడని మీరు అప్పుడు తెలుసుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","అయినా నీవు నీ అధికారులు ఇంకా యెహోవాకు భయపడడంలేదని నాకు తెలుసు.” ");
INSERT INTO tel2010_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","అప్పుడే జనుము గింజ పట్టింది. యవలు అప్పుడే పూత పట్టాయి. అయిననూ ఈ మొక్కలు నాశనం అయ్యాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","అయితే గోధుమలు, మిరప ఇతర ధాన్యాలకంట్టె ఆలస్యంగా పక్వానికి వస్తాయి. అందుచేత ఈ మొక్కలు నాశనం కాలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","మోషే ఫరోను విడిచి పట్టణం బయటికి వెళ్లాడు. యెహోవా యెదుట అతడు తన చేతులు చాచాడు. ఉరుములు, వడగళ్లు ఆగిపోయాయి. నేలమీద వర్షం కురవడం కూడ ఆగిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ఎప్పుడయితే వర్షం, వడగళ్లు, ఉరుములు ఆగిపోవడం ఫరో చూశాడో, అప్పుడు అతను మళ్లీ తప్పు చేసాడు. అతను అతని అధికారులు మళ్లీ మొండికెత్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","ఇశ్రాయేలు ప్రజల్ని స్వేచ్ఛగా వెళ్లనిచ్చేందుకు నిరాకరించాడు ఫరో. యెహోవా మోషే ద్వారా చెప్పినట్లే ఇది జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","యెహోవా మోషేతో, “ఫరో దగ్గరకు వెళ్లు. నేనే అతణ్ణి అతని అధికారులని మొండిగా చేస్తాను. నా మహత్తర అద్భుతాలను నేను వాళ్లకు చూపించాలని నేనే ఇలా చేసాను. ");
INSERT INTO tel2010_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","అలాగే ఈజిప్టులో నేను చేసిన అద్భుతాలు, ఇతర మహత్యాల విషయం మీరుకూడ మీ పిల్లలకు మీ పిల్లల పిల్లలకు చెప్పవచ్చని వీటిని చేసాను. అప్పుడు నేనే యెహోవానని మీరంతా తెల్సుకొంటారు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","మోషే, అహరోనులు ఫరో దగ్గరకు వెళ్లారు. “‘ఎంత కాలం నీవు నాకు లోబడకుండా తిరస్కరిస్తావు? నన్ను ఆరాధించడానికి నా ప్రజలను వెళ్లనివ్వు అని హీబ్రూ ప్రజల యెహోవా దేవుడు అంటున్నాడు అని వారు అతనితో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","నీవు నా ప్రజలను వెళ్లనివ్వకపోతే, రేపు నీ దేశంలోకి మిడతలను తీసుకొస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","నేల అంతా మిడతలతో నిండి పోతుంది. నీకు నేల కనబడనంత విస్తారంగా మిడతలు ఉంటాయి. వడగళ్ల వానలో మిగిలింది యింకేమైనా ఉంటే, దాన్ని కాస్తా మిడతలు తినేస్తాయి. పొలాల్లో చెట్ల ఆకులన్నిటినీ మిడతలు తినేస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","మీ ఇండ్లు మీ అధికారుల ఇండ్లు, ఈజిప్టులో ఉన్న మొత్తం ఇండ్లన్నీ మిడతలతో నిండిపోతాయి. మీ తల్లిదండ్రులు, తాతలు ఎన్నడైనా చూచిన వాటికంటే ఎక్కువ మిడతలు ఉంటాయి. ఈజిప్టులో మనుష్యులు నివాసం మొదలు పెట్టినప్పటినుండి ఎన్నడైనా ఉన్న మిడతల కంటె ఎక్కువ మిడతలు ఉంటాయి.’” తరువాత మోషే ఫరోను విడిచి, వెనుదిరిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","“ఇంకెన్నాళ్లు ఈ మనుష్యులు మనల్ని చిక్కుల్లో పెడతారు. మగవాళ్లందర్నీ వారి యెహోవా దేవుడ్ని ఆరాధించుకొనేందుకు వెళ్లనివ్వు. నీవు వాళ్లను వెళ్లనియ్యకపోతే, నీవు గుర్తించక ముందే, ఈజిప్టు నాశనం అయిపోతుంది” అని ఫరో అధికారులు అతనితో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","కనుక మోషే అహరోనులను తన దగ్గరకు మళ్లీ తీసుకురమ్మని ఫరో తన అధికారులతో చెప్పాడు. “మీరు వెళ్లి మీ యెహోవా దేవుడ్ని ఆరాధించండి, అయితే ఎవరెవరు వెళ్లుచున్నది నాకు సరిగ్గా చెప్పండి?” అన్నాడు ఫరో. ");
INSERT INTO tel2010_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","“మా ప్రజలలో పడుచువాళ్లు, వృద్ధులు వెళ్తారు! మాతోబాటు మా కుమారులు మా కుమార్తెలను, మా గొర్రెల్ని మా పశువుల్ని కూడ తీసుకుపోతాం. ఇది మా యెహోవా పండుగ గనుక మేమంతా వెళ్తాము” అని జవాబిచ్చాడు మోషే. ");
INSERT INTO tel2010_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ఫరో వాళ్లతో, “నేను మిమ్మల్ని, మీ పిల్లల్ని వెళ్లనిచ్చే ముందు యెహోవా నిజంగా మీతో ఉండి తీరాలి. చూస్తోంటే, ");
INSERT INTO tel2010_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","మీరేదో దుర్మార్గం తలపెట్టి నట్లుంది. మగాళ్లు వెళ్లి యెహోవాను ఆరాధించవచ్చు. అసలు మీరడిగింది అదే. అంతేగాని మీరంతా మొత్తం వెళ్లి పోయేందుకు వీల్లేదు” అని చెప్పి మోషే, అహరోనులను ఫరో పంపించి వేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","యెహోవా మోషేతో “ఈజిప్టు మీద నీ చేయి ఎత్తు, మిడతలు వచ్చేస్తాయి. ఈజిప్టు మొత్తం నేలమీద మిడతలు ఆవరించేస్తాయి. వడగళ్లు నాశనం చేయకుండా మిగిలిన పంట అంతటినీ ఆ మిడతలు తినేస్తాయి” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","కనుక మోషే ఈజిప్టు దేశం మీద తన కర్ర ఎత్తగా తూర్పు నుండి బలంగా గాలి వీచేటట్టు యెహోవా చేసాడు. ఆ రోజంతా, రాత్రి అంతా గాలి వీచింది. తెల్లవారేటప్పటికి ఈజిప్టు అంతటా మిడతల్ని తెచ్చి పడేసింది ఆ గాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","మిడతలు ఈజిప్టు దేశంలోకి ఎగిరివచ్చి నేలమీదంతటా కమ్మాయి. ఈజిప్టులో ఇది వరకు ఎన్నడూ లేనన్ని మిడతలు వచ్చేసాయి. పూర్వం ఎన్నడూ అన్ని మిడతలు ఉండలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","నేల అంతా మిడతలు కమ్మేశాయి. దేశం అంతా చీకటి అయిపోయింది. వడగళ్లు నాశనం చేయకుండా మిగిల్చిన చెట్లలో ప్రతి ఫలాన్ని, నేలమీద ఉన్న ప్రతి మొక్కనూ మిడతలు తినేసాయి. మొత్తం ఈజిప్టులో ఎక్కడేగాని ఏ చెట్లకూ మొక్కలకూ ఒక్క ఆకు గూడ మిగల్లేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","వెంటనే మోషే అహరోనులను పిలిపించాడు ఫరో, “మీకు, మీ యెహోవా దేవునికి వ్యతిరేకంగా నేను పాపం చేసాను. ");
INSERT INTO tel2010_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ఈ సారికి నా పాపాలు క్షమించండి. నా దగ్గర్నుండి ఈ మృత్యువును (మిడతలను) తీసివేయమని యెహోవాను అడగండి” అని చెప్పాడు ఫరో. ");
INSERT INTO tel2010_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","మోషే ఫరో దగ్గరనుండి వెళ్లిపోయి యెహోవాను ప్రార్థించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","కనుక యెహోవా ఆ గాలిని మార్చేసాడు. పడమటినుండి గాలి బలంగా వీచేటట్టు చేసాడు. ఆ గాలి మిడతలన్నింటినీ ఎర్ర సముద్రంలోకి కొట్టేసింది. ఈజిప్టులో ఒక్క మిడతకూడ మిగల్లేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","అయితే యెహోవా ఫరోను మాత్రం ఇంకా మొండిగా చేసాడు. ఇశ్రాయేలు ప్రజల్ని ఫరో వెళ్లనివ్వలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","అప్పుడు యెహోవా, “నీ చెయ్యి పైకెత్తు, ఈజిప్టు చీకటిమయం అవుతుంది. చీకటిలో తడవులాడేటంత కటిక చీకటి కమ్ముతుంది” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","కనుక మోషే తన చేతిని పైకి ఎత్తగానే ఒక చీకటి మేఘం ఈజిప్టును ఆవరించేసింది. ఈజిప్టులో మూడు రోజుల పాటు ఆ చీకటి ఉండిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ఎవ్వరూ ఎవ్వర్నీ చూడలేక పోయారు. మూడు రోజుల వరకు ఎవ్వరూ వాళ్ల స్థానాలు విడిచి పెట్టలేదు. అయితే ఇశ్రాయేలు ప్రజలు నివసించే ప్రదేశాలన్నింటిలో వెలుగు ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ఫరో మళ్లీ మోషేను పిలిపించి, “వెళ్లి యెహోవాను ఆరాధించండి. మీరు మీ పిల్లల్ని మీతో కూడా తీసుకొని వెళ్లొచ్చు. కాని మీ గొర్రెల్ని, పశువుల్ని మాత్రం ఇక్కడ విడిచి పెట్టిండి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","“మా గొర్రెల్ని, పశువుల్ని మాతో కూడ తీసుకొని వెళ్లడమేకాదు, మేము వెళ్లేటప్పుడు మీరు కూడ కానుకలు, బలి అర్పణలు మాకు యివ్వాలి. మా యెహోవా దేవుడ్ని ఆరాధించడానికి ఈ బలులను మేము వాడుకొంటాము. ");
INSERT INTO tel2010_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","యెహోవాను ఆరాధించేందుకు మా జంతువుల్ని కూడ మేము తీసుకొని వెళ్తాము. ఒక్క డెక్క కూడ ఇక్కడ విడిచి పెట్టబడదు. యెహోవాను ఆరాధించేందుకు ఏమేమి కావాలో సరిగ్గా మాకూ ఇంకా తెలియదు. మేము వెళ్తున్న చోటికి చేరిన తర్వాతే అది మాకు తెలుస్తుంది. అందుచేత యివన్నీ మేము తీసుకెళ్లాల్సిందే” అని మోషే అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","యెహోవా ఫరోను ఇంకా మొండిగా చేసాడు. అందుచేత ఫరో ప్రజలను వెళ్లనివ్వలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","అప్పుడు ఫరో మోషేతో, “పో, నా దగ్గర్నుండి వెళ్లిపో! నీవు మళ్లీ ఇక్కడకు రాకూడదు. నన్ను కలుసుకోవాలని మరోసారి వస్తే, నీవు చస్తావు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","“మోషే ఫరోతో, నీవు చెప్పింది నిజమే. నిన్ను చూడ్డానికి నేను మళ్లీ రాను” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","అప్పుడు యెహోవా మోషేతో ఇలా అన్నాడు: “ఫరో మీదికి, ఈజిప్టు మీదికి నేను ఇంకా నాశనం తీసుకు రావల్సి ఉంది. దాని తర్వాత అతడు మిమ్మల్ని ఈజిప్టు నుండి పంపించి వేస్తాడు. వాస్తవానికి మీరు ఈ దేశం వదలి వెళ్లిపోవాలని అతడు మిమ్మల్ని బలవంతం చేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","ఇశ్రాయేలు ప్రజలకు ఈ సందేశం మీరు చెప్పాలి, ‘మీరు స్త్రీలు పురుషులు అందరూ మీ చుట్టు ప్రక్కల వాళ్ల దగ్గరకు వెళ్లి, వారి వెండి, బంగారు వస్తువులన్నీ మీకు ఇమ్మని అడగాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ఈజిప్టు వాళ్లకు మీపై దయ కలిగేటట్టు యెహోవా చేస్తాడు.’” అప్పటికే ఈజిప్టు ప్రజలు మరియు ఫరో అధికారులు కూడా మోషేను ఒక మహాత్మునిగా ఎంచుతున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","మోషే ప్రజలతో ఇలా చెప్పాడు: “ఈ వేళ మధ్య రాత్రి నేను ఈజిప్టులో తిరుగుతాను. ");
INSERT INTO tel2010_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ఫరో పెద్ద కుమారుడు మొదలు ధాన్యం తిరుగలి విసరుతున్న బానిసయొక్క, పెద్ద కుమారుడు వరకు ఈజిప్టులో ప్రతి పెద్ద కుమారుడు మరణిస్తాడు. అలాగే జంతువుల్లో మొదట పుట్టినవన్నీ చస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","గతంలోకంటె, భవిష్యత్తులోకంటె, ఇప్పుడు ఈజిప్టులోవినబడే ఏడ్పులు మరీ దారుణంగా ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","కాని ఇశ్రాయేలు ప్రజల్లో ఏ ఒక్కరికీ హాని కలుగదు. కనీసం వారిపై ఒక కుక్క కూడ మొరగడం ఉండదు. ఇశ్రాయేలు ప్రజల్లో ఏ ఒక్కరుగాని, వారి జంతువుల్లో ఏ ఒక్కటిగాని బాధపడవు. ఈ విధంగా ఇశ్రాయేలు ప్రజల్ని ఈజిప్టు వాళ్లకంటె, ప్రత్యేకంగా నేను చూశానని మీరు తెలుసుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","అప్పుడు మీ బానిసలు (ఈజిప్టు వాళ్లు) సాష్టాంగపడి నన్ను ఆరాధిస్తారు. ‘మీ ప్రజలందరినీ తీసుకొని మీరు వెళ్లిపోండి’ అని వాళ్లే అప్పుడు చెబతారు. అప్పుడు నేను కోపంగా ఫరోను విడిచి వెళ్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","యెహోవా మోషేతో, “నీ మాట ఎందుచేత ఫరో వినలేదు? ఈజిప్టులో నా మహత్తర శక్తిని నేను చూపించ గలిగేందుకే” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ఆ కారణం చేతనే ఫరో యెదుట మోషే, అహరోనులు ఈ మహా అద్భుతాలన్నీ చేసారు. అందుకే ఫరో ఇశ్రాయేలు ప్రజల్ని తన దేశం నుండి వెళ్లనియ్యకుండా అంత మొండికెత్తేటట్టు యెహోవా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","మోషే, అహారోనులు ఇంకా ఈజిప్టులో ఉండగానే, యెహోవా వాళ్లతో మాట్లాడాడు. యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ఈనెల మీకు సంవత్సరంలో మొదటి నెలగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ఈ ఆజ్ఞ ఇశ్రాయేలు సమాజం అంతటికీ చెందుతుంది. ఈ నెల పదో రోజున ఒక్కొక్కరు తన ఇంటివారి కోసం ఒక గొర్రె పిల్లను తీసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ఒక గొర్రెపిల్లను పూర్తిగా తినగలిగినంత మంది తన ఇంట్లో లేకపోతే, అలాంటి వారు తమ భోజనం తినేందుకు ఇంటి పక్కవాళ్లను ఆహ్వానించాలి. ప్రతి ఒక్కరూ తినడానికి సరిపడినంతగా గొర్రెపిల్ల ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","గొర్రెపిల్ల ఒక సంవత్సరం వయసు గల మగది కావాలి, అది మంచి ఆరోగ్యంగా ఉండాలి. ఈ జంతువు చిన్న గొర్రె లేక చిన్న మేక కావచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","నెలలో 14వ రోజువరకు మీరు ఆ జంతువును గమనించాలి. ఆ రోజు ఇశ్రాయేలు సమాజంలోని ప్రజలంతా సాయంకాల సమయంలో ఈ జంతువులను చంపాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ఈ జంతువుల రక్తం అంతా భద్రం చేయాలి. ఏ ఇండ్లలోనైతే ప్రజలు ఈ ఆహారం భోజనం చేస్తారో ఆ ఇళ్ల ద్వార బంధాల నిలువు కమ్ములమీద, పైకమ్మి మీద ఆ రక్తం చల్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","“ఆ రాత్రే మీరు ఆ గొర్రెపిల్ల మాంసం కాల్చి దాన్ని మొత్తం తినెయ్యాలి. చేదుగా ఉండే ఆకు కూరలు, పొంగని రొట్టె కూడా మీరు తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","గొర్రె పిల్ల మాంసాన్ని మీరు నీళ్లతో వండకూడదు. మొత్తం గొర్రెపిల్లను నిప్పుమీద పేల్చాలి. అప్పటికి ఇంకా ఈ గొర్రెపిల్ల తల, కాళ్లు, ఆంత్రాలతోనే ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ఆ మాంసం అంతా ఆ రాత్రికి రాత్రే మీరు భోంచేయాలి. మాంసంలో ఏమైనా మర్నాటి ఉదయం వరకు మిగిలి పోతే దాన్ని నిప్పులో వేసి కాల్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“మీరు ఆ భోజనం చేసేటప్పుడు ప్రయాణం చేస్తున్న వారిలా బట్టలు వేసుకోవాలి. మీ అంగీని మీ నడుంకు బిగించాలి. మీరు మీ చెప్పులు తొడుక్కోవాలి. మీ చేతి కర్రను చేతితో పట్టుకోవాలి. ఆతురంగా మీరు భోజనం చేయాలి. ఎందుచేతనంటే, ఇది యెహోవాయొక్క పస్కాబలి (యెహోవా తన ప్రజలను కాపాడి, వారిని ఈజిప్టునుండి త్వరగా బయటకు నడిపించిన సమయం.) ");
INSERT INTO tel2010_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“ఈ రాత్రి నేను ఈజిప్టు అంతటా సంచారం చేసి ఈజిప్టులోని ప్రతి పెద్ద కుమారుణ్ణీ చంపేస్తాను. మనుష్యుల్లోను, జంతువుల్లోను, మొదటి సంతానాన్ని నేను చంపేస్తాను. ఈజిప్టు దేవతలందరికీ శిక్ష విధిస్తాను. నేనే యెహోవానని వారికి తెలిసేటట్టు చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","అయితే, మీ ఇళ్లమీదనున్ను రక్తం ఒక ప్రత్యేక గుర్తుగా ఉంటుంది. నేను ఆ రక్తాన్ని చూడగానే మీ ఇంటిని దాటి వెళ్లిపోతాను. ఈజిప్టు వాళ్లకు మాత్రం కీడు జరిగేటట్టు చేస్తాను. అయితే, ఆ కీడు, రోగాలు మిమ్మల్ని ఎవరినీ బాధించవు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“కనుక ఈ రాత్రిని మీరు ఎల్లప్పుడూ జ్ఞాపకం ఉంచుకొంటారు. మీకు అది ఒక ప్రత్యేక పండుగ రోజుగా ఉంటుంది. మీ తర్వాత మీ సంతానము శాశ్వతంగా ఈ పండుగను ఆచరించి యెహోవాను ఘనపర్చాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","ఈ పండుగనాడు ఏడు రోజుల పాటు పొంగని రొట్టెలు మీరు తినాలి. ఈ పండుగ మొదటి రోజున పులిసే పదార్థాన్ని మీ ఇండ్లలోనుంచి తీసివేయాలి. ఈ పండుగ జరిగే మొత్తం ఏడు రోజుల్లోనూ పులిసిన పదార్థాన్ని ఏ ఒక్కరూ తినకూడదు. ఎవరైనా సరే పులిసే పదార్థం తింటే, ఆ వ్యక్తిని ఇశ్రాయేలు వాళ్లనుండి మీరు వేరుచేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","పండుగలో మొదటి రోజున, చివరి రోజున పరిశుద్ధ సమావేశాలు ఉంటాయి. ఈ రోజుల్లో మీరు ఏ పనీ చేయకూడదు. ఇలాంటి రోజుల్లో మీరు భోంచేయటానికి అవసరమైన భోజనాన్ని సిద్ధం చేసుకోవడం ఒక్కటే మీరు చెయ్యొచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","పులియని పిండితో చేసే రొట్టెల పండుగను మీరు జ్ఞాపకం ఉంచుకోవాలి. ఎందుచేతనంటే, సరిగ్గా ఈ రోజే మీ వంశాలన్నింటినీ ఈజిప్టు నుండి నేను బయటకు నడిపిన రోజు. అందుచేత మీ తర్వాత మీ సంతానమంతా ఈ రోజును జ్ఞాపకం చేసుకోవాలి. ఇది శాశ్వతంగా ఉండిపోయే చట్టం. ");
INSERT INTO tel2010_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","కనుక మొదటి నెల (నిసాను) 14వ రోజు సాయంత్రం నుండి మీరు పులియని రొట్టెలు తినడం మొదలు పెట్టాలి. అదే నెల 21 రోజు సాయంత్రం వరకు అలాంటి రొట్టెలే మీరు తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ఏడు రోజుల పాటు మీ ఇళ్లలో ఎక్కడా పులిసిన పదార్థం ఉండకూడదు. ఇశ్రాయేలు పౌరుడేకాని, విదేశీయుడేగాని ఏ వ్యక్తిగాని ఈ సందర్భంలో పులిసిన పదార్థం తింటే, మిగిలిన ఇశ్రాయేలీయులందరినుండి ఆ వ్యక్తి వేరు చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ఈ పండుగ సమయంలో మీరు పులిసిన పదార్థం తినకూడదు. మీరు ఎక్కడ ఉన్నాసరే, పులియని రొట్టెలు మాత్రమే మీరు తినాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","కనుక పెద్దలందర్నీ మోషే పిలిచి, “మీ కుటుంబాల కోసం గొర్రెపిల్లల్ని తెచ్చుకొని, పస్కా పండుగకు ఆ గొర్రెపిల్లల్ని తీసుకోండి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","హిస్సోపు కొమ్మలు తీసుకొని రక్తంతో నింపిన పాత్రల్లో వాటిని ముంచండి. ద్వారబంధాల నిలువు కమ్ముల మీద, పై కమ్మి మీద ఆ రక్తాన్ని పూయండి. తెల్లారేవరకు ఎవరూ తమ ఇండ్లు విడిచి వెళ్ల కూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ఈజిప్టులో జ్యేష్ఠ సంతానాన్ని చంపడానికి యెహోవా సంచరించే సమయంలో, ద్వారబంధాల నిలువు కమ్ముల మీద పైకమ్మి మీద రక్తాన్ని ఆయన చూస్తాడు. అప్పుడు యెహోవా ఆ ఇంటిని కాపాడుతాడు నాశనకారుడ్ని యెహోవా మీ ఇంట్లోకి రానివ్వడు. మిమ్మల్ని బాధింపనియ్యడు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","ఈ ఆజ్ఞ మీరు జ్ఞాపకం ఉంచుకోవాలి. ఈ చట్టం మీకు, మీ సంతానానికి శాశ్వతంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","యెహోవా మీకు ఇచ్చే దేశానికి వెళ్లిన తర్వాత కూడ మీరు దీన్ని చేయటం జ్ఞాపకం ఉంచుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","‘ఈ ఆచారం మనం ఎందుకు పాటిస్తున్నాము?’ అని మీ పిల్లలు మిమ్మల్ని అడిగినప్పుడు ");
INSERT INTO tel2010_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","‘యెహోవాను ఘనపర్చడం కోసమే ఈ పస్కా పండుగ. ఎందుచేతనంటే, మనం ఈజిప్టులో ఉన్నప్పుడు యెహోవా ఇశ్రాయేలు గృహాలను దాటిపోయాడు యెహోవా ఈజిప్టు వాళ్లను చంపేసాడు. కానీ మన ఇళ్లల్లో వారిని ఆయన రక్షించాడు. అందుచేత ఇప్పుడు ప్రజలు సాష్టాంగపడి యెహోవాను ఆరాధిస్తున్నారు’ అని మీరు చెప్పాలి.” అని అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","మోషే అహరోనులకు యెహోవా ఈ ఆజ్ఞ ఇచ్చాడు. అందుచేత యెహోవా ఆజ్ఞ ప్రకారం ఇశ్రాయేలు ప్రజలు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","అర్ధరాత్రి వేళ ఫరో (ఈజిప్టు రాజ్యపాలకుడు) ఇంట పెద్ద కుమారుడు మొదలుకొని చెరసాలలో కూర్చొన్న ఖైదీ పెద్ద కుమారుని వరకు ఈజిప్టులో పెద్ద కుమారులందర్నీ యెహోవా చంపేసాడు. అలాగే జంతువుల్లో మొదటి సంతానం అన్నీ చచ్చాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ఆ రాత్రి ఈజిప్టులో ప్రతీ ఇంటా ఎవరో ఒకరు చనిపోయారు. ఫరో, అతని అధికారులు, ఈజిప్టులోని ప్రజలంతా ఘోల్లున ఏడ్వడం మొదలు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","కనుక ఆ రాత్రి మోషే, అహరోనులను ఫరో పిలిపించాడు. “మీరు వెంటనే నా ప్రజల్ని విడిచి వెళ్లండి. మీరు చెప్పినట్టే మీరూ, మీ ప్రజలూ చెయ్యండి. వెళ్లి యెహోవాను ఆరాధించండి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","మీరు చెప్పినట్టే మీ గొర్రెలను, పశువులను, అన్నింటినీ మీతోబాటు తీసుకొనిపోవచ్చు. వెళ్లండి. నన్నుకూడ ఆశీర్వదించండి.” అని వారితో ఫరో అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","వాళ్లను త్వరగా విడిచిపొమ్మని ఈజిప్టు ప్రజలు కూడ వారిని అడిగారు ఎందుకంటే, “మీరు వెళ్లకపోతే మేమందరం చస్తాము” అని వాళ్లు చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","తమ రొట్టెల్లో పులిసిన పదార్థం వేసుకొనేంత సమయం ఇశ్రాయేలు ప్రజలకు లేదు. పిండి ముద్దలున్న పాత్రలను బట్టలో కట్టుకొని వారు వారి భుజాన వేసుకొని మోసుకుపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","అప్పుడు మోషే వారిని ఏమి చేయమని చెప్పాడో అలాగే ఇశ్రాయేలు ప్రజలు చేసారు. వారు వారి పక్క ఇండ్ల వారి దగ్గరకు వెళ్లి బట్టలు, వెండి, బంగారు వస్తువులు ఇమ్మని అడిగారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ఈజిప్టువారు ఇశ్రాయేలు ప్రజల మీద దయ చూపించేటట్టు యెహోవా చేసాడు. అందుచేత ఈజిప్టు వాళ్లు వారి ఐశ్వర్యాలను ఇశ్రాయేలు ప్రజలకు యిచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","ఇశ్రాయేలు ప్రజలు ప్రయాణం కట్టి రామసేసునుండి సుక్కోతుకి వెళ్లారు. వారు పురుషులే సుమారు 6,00,000 మంది. ఇందులో పిల్లల సంఖ్యలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","గొర్రెలు, పశువులు, ఇతర సామగ్రి చాల విస్తారంగా ఉన్నాయి. వారితో బాటు చాల మంది రకరకాల ప్రజలు ప్రయాణం చేస్తున్నారు. వీళ్లు ఇశ్రాయేలీయులు కారు, గాని వారితో కలిసి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","అయితే ప్రజలకు మాత్రం వారి రొట్టెల్లో పులిసిన పదార్థం వేసుకొనే సమయం లేదు. వారు తమ ప్రయాణం కోసం ప్రత్యేకమైన భోజనం ఏదీ సిద్ధం చేసుకోలేదు. కనుక పులవని పిండితోనే వారు రొట్టెలు చేసుకోవాల్సి వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","ఇశ్రాయేలు ప్రజలు ఈజిప్టులో 430 సంవత్సరాలు జీవించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","నాలుగువందల ముప్పై సంవత్సరాల తర్వాత ఆరోజే మొత్తం యెహోవా సైన్యాలన్నీ ఈజిప్టు దేశాన్ని విడిచి వెళ్లిపోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","కనుక యెహోవా చేసిన దానిని ప్రజలు జ్ఞాపకం చేసుకొంటారు. అది చాల ప్రత్యేకమైన రాత్రి కనుక తరతరాలవరకు జ్ఞాపకం చేసుకొంటారు. ఇశ్రాయేలు ప్రజలంతా ఆ రాత్రిని శాశ్వతంగా జ్ఞాపకం ఉంచుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","మోషే అహరోనులతో యెహోవా యిలా చెప్పాడు: “పస్కా పండుగకు నియమాలు ఇవి. పస్కా భోజనం విదేశీయుడెవరూ తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ఒకడు బానిసను కొంటే, ఆ బానిసకు అతడు సున్నతి చేస్తే అప్పుడు ఆ బానిస పస్కా పండుగ భోజనం చెయ్యవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","అయితే, ఒక వ్యక్తి కేవలం మీ దేశంలో ఉంటున్నా, లేక మీకోసం పని చేసేందుకు కూలికి కుదుర్చుకొన్నా, అలాంటి వ్యక్తి పస్కా పండుగ భోజనం చెయ్యకూడదు. (పస్కా పండుగ ఇశ్రాయేలీయులకు మాత్రమే)” ");
INSERT INTO tel2010_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ప్రతి కుటుంబము ఒకే ఇంటిలో భోజనం చేయాలి. భోజనాన్ని ఎవ్వరూ ఇంటి బయట తినకూడదు. మీరు గొర్రెమాంసము తిని దాని ఎముకను విరువకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ఇశ్రాయేలు ప్రజలందరు ఈ పండుగను ఆచరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","ఇశ్రాయేలు సమాజంలో సభ్యుడు కాని ఏ వ్యక్తి అయినా మీతోబాటు నివసిస్తూ ఉండి యెహోవా పస్కా పండుగలో అతడు పాల్గొనాలనుకొంటే, అతనికి సున్నతి చేయాలి. అప్పుడు అతను కూడ ఇశ్రాయేలు పౌరుడుగా ఆ భోజనంలో పాల్గొనవచ్చు. కాని ఒకడు సున్నతి చేసుకోకపోతే అతను పస్కా పండుగ భోజనంలో పాల్గొన కూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","అందరికీ ఇవే నియమాలు వర్తిస్తాయి. మీ దేశంలో నివసిస్తున్న వ్యక్తి పౌరుడైనా సరే, విదేశీయుడైనా సరే యివే నియమాలు వర్తిస్తాయి.” ");
INSERT INTO tel2010_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","మోషే అహరోనులకు యెహోవా ఇచ్చిన ఆజ్ఞలకు ప్రజలంతా విధేయులయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","కనుక అదే రోజు ఇశ్రాయేలు ప్రజలందరినీ ఈజిప్టు దేశం నుండి యెహోవా బయటకు నడిపించాడు. ప్రజలు గుంపులుగా బయల్దేరారు. ");
INSERT INTO tel2010_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","అప్పుడు యెహోవా మోషేతో యిలా అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ఇశ్రాయేలులో పెద్దకుమారుడు ప్రతి ఒక్కడూ నాకు చెందుతాడు. ప్రతి స్త్రీకి పుట్టిన పెద్దకుమారుడూ నావాడు. మీ జంతువుల్లో మొదట పుట్టే ప్రతి మగదాన్నీ మీరు నాకు అర్పించాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","మోషే ప్రజలతో ఇలా చెప్పాడు: “ఈ రోజును జ్ఞాపకం ఉంచుకోండి. మీరు ఈజిప్టులో బానిసలుగా ఉండేవారు. అయితే ఈనాడు యెహోవా తన మహా శక్తిని ప్రయోగించి మిమ్మల్ని విడుదల చేసాడు. మీరు మాత్రం పులిసిన పదార్థంతో రొట్టెలు తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","అబీబు మాసంలో ఈనాడు మీరు ఈజిప్టును విడిచి వెళ్తున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","మీ పూర్వీకులకు యెహోవా వాగ్దానం చేసాడు. కనానీ ప్రజలు, హిత్తీ ప్రజలు, అమోరీ ప్రజలు, హివ్వీ ప్రజలు, యెబూసీ ప్రజలు నివసిస్తోన్న దేశాన్ని మీకు ఇస్తానని యెహోవా వాగ్దానం చేసాడు. యెహోవా మిమ్మల్ని పాలు తేనెలు ప్రవహిస్తోన్న ఆ సుందర దేశానికి నడిపించిన తర్వాత అప్పుడు కూడా మీరు ఈ రోజును జ్ఞాపకం చేసుకోవాలి. ప్రతి సంవత్సరం మొదటి నెలలో ఈరోజు ఒక ప్రత్యేకమైన ఆరాధన రోజుగా మీకు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","“ఏడు రోజులపాటు పులియని రొట్టెలే మీరు తినాలి. ఏడోనాడు ఒక గొప్ప విందు ఉంటుంది. ఈ విందు యెహోవా ఘనతను సూచిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","కనుక ఏడు రోజులు పులిసిన పదార్థంతో చేయబడ్డ రొట్టెలు ఏవీ మీరు తినకూడదు. మీ దేశం మొత్తంలో ఎక్కడా పులిసిన పదార్థంతో తయారైన రొట్టెలు ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","‘యెహోవా ఈజిప్టునుండి మమ్మల్ని బయటకు రప్పించాడు. కనుక మనం ఈ పండుగ చేసుకొంటున్నాము’ అని ఈ రోజు నాడు మీరు మీ పిల్లలతో చెప్పాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“మీరు జ్ఞాపకం చేసుకొనేందుకు ఈ పండుగ మీకు తోడ్పడుతుంది. అది మీ ముంజేతి మీద కట్టుకొన్న దారం పోగులా ఉంటుంది. అది మీ కళ్లముందు కనబడే ఒక జ్ఞాపికలా ఉంటుంది. యెహోవా ప్రబోధాలను జ్ఞాపకం చేసుకొనేందుకు ఈ పండుగ మీకు సహాయ పడుతుంది. మిమ్మల్ని ఈజిప్టు నుండి బయటకు రప్పించేందుకు యెహోవా తన మహత్తర శక్తిని ప్రయోగించాడని జ్ఞాపకం చేసుకొనేందుకు ఇది మీకు సహాయ పడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","కనుక ప్రతి సంవత్సరం సరైన సమయంలో ఈ పండుగను జ్ఞాపకం చేసుకోండి. ");
INSERT INTO tel2010_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“మీకు ఇస్తానని వాగ్దానం చేసిన దేశానికి యెహోవా మిమ్మల్ని నడిపిస్తాడు. కనానీయులు ఇప్పుడు అక్కడ నివసిస్తున్నారు. అయితే ఈ దేశాన్ని మీకు ఇస్తానని మీ పూర్వీకులకు యెహోవా వాగ్దానం చేసాడు. దేవుడు ఈ దేశాన్ని మీకు ఇచ్చిన తర్వాత ");
INSERT INTO tel2010_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ప్రతి పెద్ద కుమారుణ్ణి ఆయనకు ఇవ్వాలని మీరు జ్ఞాపకం ఉంచుకోవాలి. అలాగే జంతువుల్లో ప్రథమంగా పుట్టిన ప్రతి మగపిల్లనూ యెహోవాకు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","తొలి పిల్లగా పుట్టిన ప్రతి గాడిదనూ యెహోవా దగ్గర్నుండి మళ్లీ కొనుక్కోవచ్చు. మీరు ఆ గాడిదకు బదులుగా ఒక గొర్రెపిల్లను ఇచ్చి, గాడిదను విడిపించుకోవచ్చును. యెహోవా దగ్గర్నుండి ఆ గాడిదను కొని విడిపించుకోనట్లయితే, దాన్ని చంపేయాలి. మీరు దాని మెడ విరుగగొట్టాలి. అది బలి అర్పణ అవుతుంది. ప్రతి పెద్ద సంతానాన్నీ యెహోవా దగ్గరనుండి మళ్లీ కొనుక్కోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“మీరెందుకు ఇలా చేస్తున్నారని భవిష్యత్తులో మీ పిల్లలు మిమ్మల్ని అడుగుతారు. ‘దీనంతటికీ భావం ఏమిటి?’ అని వారు అంటారు. దానికి మీరు యిలా జవాబిస్తారు. ‘ఈజిప్టు నుండి మనల్ని రక్షించేందుకు యెహోవా తన మహత్తర శక్తిని ప్రయోగించాడు. అక్కడ మనం బానిసలంగా ఉంటిమి. అయితే యెహోవా మనల్ని అక్కడ నుండి బయటకు నడిపించి ఇక్కడకు తీసుకొచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ఈజిప్టులో ఫరో మొండికెత్తాడు. మనల్ని వెళ్లనిచ్చేందుకు అతడు నిరాకరించాడు. కనుక ఆ దేశంలో ప్రతి జ్యేష్ఠ సంతానాన్నీ యెహోవా చంపేసాడు. (పెద్ద కుమారుల్ని, తొలి చూలు జంతువుల్ని యెహోవా చంపేసాడు) ఆ కారణంచేత జంతువుల్లో మొదటి సంతానంగా పుట్టిన ప్రతి మగపిల్లనూ నేను యెహోవాకు అర్పిస్తున్నాను. ఆ కారణంచేతనే నా పెద్ద కుమారుల్లో ప్రతి ఒక్కరినీ నేను యెహోవా దగ్గర్నుండి కొంటున్నాను.’ ");
INSERT INTO tel2010_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ఇది మీ ముంజేతికి కట్టబడ్డ దారం పోగులాంటిది. అది నీ కంటికి ఒక బాసికంలాంటిది. యెహోవా తన మహత్తర శక్తిచేత మనల్ని ఈజిప్టు నుండి బయటకు రప్పించాడని జ్ఞాపకం చేసుకొనేందుకు ఇది మీకు సహాయకరంగా ఉంటుంది.” ");
INSERT INTO tel2010_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ఫరో ఈజిప్టును విడిచి వెళ్లనిచ్చాడు. సముద్రం వెంబడి పోయే మార్గంలో ఆ ప్రజలను యెహోవా వెళ్లనీయలేదు. ఈ మార్గం పాలస్తీనాకు దగ్గర దారి. కాని “ప్రజలు ఆ దారిన వెళ్తే యుద్ధం చేయాల్సి వస్తుంది. అలాంటప్పుడు వాళ్లు మనసు మార్చుకొని మళ్లీ ఈజిప్టుకు వెళ్లిపోవచ్చు.” ");
INSERT INTO tel2010_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","కనుక వారిని ఇంకో మార్గాన యెహోవా నడిపించాడు. ఎర్ర సముద్రం పక్కగా ఉండే అరణ్యంలోనుంచి ఆయన వారిని నడిపించాడు. అయితే, ఇశ్రాయేలు ప్రజలు ఈజిప్టు విడిచి పెట్టినప్పుడు యుద్ధ వస్త్రాలు ధరించి బయల్దేరారు. ");
INSERT INTO tel2010_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","మోషే తనతో బాటు యోసేపు ఎముకలను తీసుకొని వెళ్లాడు. ఇలా చేయాలనిచెప్పి యోసేపు తాను చనిపోక ముందే ఇశ్రాయేలి కుమారులతో ప్రమాణం చేయించుకొన్నాడు. “దేవుడు మిమ్మల్ని రక్షించినప్పుడు ఈజిప్టులోనుంచి నా ఎముకల్ని మీతో తీసుకు వెళ్లాలని జ్ఞాపకం ఉంచుకోండి” అని తాను చనిపోక ముందు యోసేపు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","ఇశ్రాయేలు ప్రజలు సుక్కోతు విడిచి ఏతాములో బసచేసారు. ఏతాము ఎడారికి సమీపంగా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","యెహోవా ముందు దారితీశాడు. పగటి వేళ ప్రజలను నడిపించేందుకు ఒక ఎత్తయిన మేఘ స్తంభాన్ని యెహోవా ఉపయోగించాడు, మరియు రాత్రివేళ మార్గం చూపించడానికి ఒక ఎత్తయిన అగ్నిస్తంభాన్ని యెహోవా ఉపయోగించాడు. వాళ్లు రాత్రి సమయంలో కూడ ప్రయాణం చేయగలిగేటట్టు ఆ అగ్ని వారికి వెలుతురు నిచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","పగటి వేళంతా ఆ ఎత్తయిన మేఘమూ, రాత్రి వేళంతా అగ్ని స్తంభమూ వాళ్లతోటే ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","అప్పుడు మోషేతో యెహోవా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“ప్రజలు వెనక్కు తిరిగి పీహ హీరోతుకు ప్రయాణం కట్టమని చెప్పు. మిగ్దోలుకు, సముద్రానికి మధ్య ప్రదేశంలో రాత్రికి బసచేయాలని వారితో చెప్పు. ఇది బయల్సెఫోను దగ్గర్లో ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ఇశ్రాయేలు ప్రజలు ఎడారిలో తప్పిపోయి ఉంటారని ఫరో తలుస్తాడు. పైగా ప్రజలు వెళ్ల గలిగినచోటు ఇంకేమీ ఉండదు అనుకొంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","ఫరోను నేను ధైర్యశాలిగా చేస్తాను. అతడేమో మిమ్మల్ని తరుముతాడు. అయితే ఫరోను, అతని సైన్యాన్ని నేను ఓడిస్తాను. ఇది నాకు కీర్తి తెచ్చి పెడుతుంది. నేనే యెహోవానని ఈజిప్టు వాళ్లు అప్పుడు తెల్సుకొంటారు.” ఇశ్రాయేలు ప్రజలు దేవుని మాటకు విధేయులై ఆయన చెప్పినట్టు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ఇశ్రాయేలు ప్రజలు పారిపోయారని ఫరోకు ఒక సమాచారం అందింది. ఎప్పుడైతే ఈ సంగతి విన్నారో అప్పుడు వెంటనే ఫరో, అతని అధికారులు తాము చేసిన దాన్ని గూర్చి తమ మనసు మార్చుకొన్నారు. “ఇశ్రాయేలు ప్రజల్ని అసలు మనం ఎందుకు వెళ్లనిచ్చాం? వాళ్లను మనం ఎందుకు పారిపోనిచ్చాం? ఇప్పుడు మనం మన బానిసల్ని పోగొట్టుకొన్నాం” అన్నాడు ఫరో. ");
INSERT INTO tel2010_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","కనుక ఫరో తన యుద్ధరథాన్ని సిద్ధం చేసుకొని, తన మనుష్యుల్ని వెంట పెట్టుకొని వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","తన మనుష్యుల్లో బలవంతులయిన వాళ్లు 600 మందిని, రథాలు అన్నింటిని తనతో తీసుకొని వెళ్లాడు. ఒక్కోరథానికి ఒక్కో అధికారి ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ఇశ్రాయేలీయులు విజయ సంకేతంగా చేతులు పైకెత్తి వెళ్లి పోతున్నారు. కానీ ఈజిప్టురాజైన ఫరో ఇంకా ధైర్యశాలి అయ్యేటట్టు యెహోవా చేసాడు. ఫరో ఇశ్రాయేలు ప్రజల్ని ఇంకా తరిమాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ఈజిప్టు సైన్యంలో అశ్వదళాలు, రథాలు చాల ఉన్నాయి. వారు ఇశ్రాయేలు ప్రజల్ని తరిమి, వారు బయల్సెఫోనుకు తూర్పున పీహహీరోతు వద్ద ఎర్ర సముద్రానికి దగ్గర్లో బస చేస్తూ ఉండగానే వారిని సమీపించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ఫరో, అతని సైన్యం తమవైపే రావడం ఇశ్రాయేలు ప్రజలు చూసారు. ప్రజలు చాల భయపడ్డారు. సహాయం చేయమని వారు యెహోవాకు మొరపెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","మోషేతో వాళ్లు యిలా అన్నారు, “అసలు ఈజిప్టు నుండి నీవు మమ్మల్నెందుకు బయటకు తీసుకొచ్చావు? చావడానికి నీవు మమ్మల్ని ఈ ఎడారిలోకి తీసుకురావడం ఎందుకు? మేము హాయిగా ఈజిప్టులోనే చచ్చేవాళ్లం అక్కడ ఈజిప్టులో కావాల్సినన్ని సమాధులున్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ఇలా జరుగుతుందని మేము నీతో చెప్పాము. ‘దయచేసి మమ్మల్ని విసిగించకు. మమ్మల్ని ఇక్కడే ఉండనిచ్చి, ఈజిప్టు వాళ్లకు సేవ చేయనియ్యి అని ఈజిప్టులోనే మేము చెప్పాము.’ ఇలా బయటకు వచ్చి ఈఎడారిలో చావడంకంటె ఈజిప్టులోనే ఉండిపోయి బానిసలంగా ఉంటేనే యింకా బాగుండేది మాకు.” ");
INSERT INTO tel2010_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","కానీ మోషే జవాబు ఇలా చెప్పాడు: “భయ పడకండి! పారిపోకండి! యెహోవా ఈనాడు మిమ్మల్ని రక్షించటం వేచి చూడండి. ఈ ఈజిప్టు వారిని ఈరోజు తర్వాత మళ్లీ ఎన్నడూ మీరు చూడరు! ");
INSERT INTO tel2010_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","మీరు ఊరకనే మౌనంగా ఉండటం తప్ప చేయాల్సిందేమీ లేదు. మీ పక్షంగా యెహోవా యుద్ధం చేస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","అప్పుడు మోషేతో యెహోవా ఇలా అన్నాడు, “ఇంకా నీవెందుకు నాకు మొర పెడుతున్నావు? ఇశ్రాయేలు ప్రజల్ని ముందడుగు వేయమని ఆజ్ఞాపించు ");
INSERT INTO tel2010_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","నీ చేతిలో కర్రను ఎర్రసముద్రం మీదకు చాపు, ఎర్రసముద్రం రెండుగా విడిపోతుంది. అప్పుడు ప్రజలు ఆరిపోయిన నేలమీద సముద్రంలోనుంచి నడిచి వెళ్లిపోవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","ఈజిప్టు వాళ్లను ధైర్యంగల వాళ్లుగా నేను చేస్తాను. ఇలా చేసినందువల్ల వారు మిమ్మల్ని తరుముతారు. అయితే ఫరోకంటె, అతని అశ్వదళాలు, రథాలు, అన్నిటికంటె నేను ఎక్కువ శక్తిగలవాడ్ని అని మీకు తెలియజేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","నేనే యెహోవానని ఈజిప్టు అప్పుడు తెలుసు కొంటుంది. ఫరోను, అతని అశ్వ దళాలను, రథాలను నేను ఓడించినప్పుడు వాళ్లు నన్ను గౌరవిస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ఆ సమయంలో యెహోవా దూత ప్రజల వెనక్కు వెళ్లడం జరిగింది. (సాధారణంగా యెహోవా దూత ప్రజలకు ముందర ఉండి వారిని నడిపించడం జరుగుతుంది) కనుక ఎత్తైన మేఘం ప్రజల ముందర నుండి కదలిపోయి, ప్రజల వెనక్కు వెళ్లింది ");
INSERT INTO tel2010_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ఈ విధంగా ఈజిప్టు వాళ్లకు, ఇశ్రాయేలీయులకు మధ్య ఆ మేఘం నిలిచింది. ఇశ్రాయేలు ప్రజలకు వెలుగు ఉంది. కానీ ఈజిప్టు వారికి అంతా చీకటి. అందుచేత ఆరాత్రి ఈజిప్టు వాళ్లు ఇశ్రాయేలు ప్రజల సమీపానికి రాలేకపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","మోషే ఎర్ర సముద్రం మీదికి తన చేయి ఎత్తగానే తూర్పునుండి ఒక బలమైన గాలి వీచేటట్టు యెహోవా చేసాడు. ఆ గాలి రాత్రి అంతా వీచింది. సముద్రం రెండుగా విడిపోయింది. ఆ గాలి నేలను ఆరిపోయ్యేటట్టు చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","ఇశ్రాయేలు ప్రజలు సముద్రంలో పొడినేల మీద వెళ్లారు. వాళ్లకు కుడిప్రక్క, ఎడమప్రక్క నీళ్లు గోడలా నిలిచాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","అప్పుడు ఫరో రథాలు, అశ్వదళాలు అన్నీ వాళ్ల వెంట సముద్రంలో ప్రవేశించాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ఆ ఉదయం ఎత్తయిన మేఘం నుండి అగ్ని స్తంభం నుండి యెహోవా ఈజిప్టు సైన్నాన్ని చూచాడు. యెహోవా వాళ్లను ఎదుర్కొని ఓడించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","రథచక్రాలు బిగిసిపోయి కదలడం లేదు. రథాలను అదుపుచెయ్యడం చాలా కష్టతరంగా ఉంది. “మనం ఇక్కడ్నుంచి పారిపోదాం రండి! యెహోవా మనకు వ్యతిరేకంగా పోరాడుతున్నాడు. ఆయన ఇశ్రాయేలీయులకోసం యుద్ధం చేస్తున్నాడు.” అంటూ ఈజిప్టు వాళ్లు కేకలు వేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","అప్పుడు యెహోవా మోషేతో, “నీ చేయి సముద్రం మీదికి ఎత్తు, నీళ్లు పడిపోయి ఈజిప్టు రథాలను, అశ్వదళాలను ముంచేస్తాయి.” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","కనుక తెల్లవారు ఝామున మోషే తన చేతిని సముద్రం మీదికి ఎత్తాడు. నీళ్లు యధాస్థానానికి వచ్చి పడ్డాయి. ఈజిప్టు వాళ్లు పారిపోయేందుకు ప్రయత్నిస్తున్నారు. అయితే ఈజిప్టు వాళ్లు సముద్రంలో కొట్టుకుపోయేటట్టు యెహోవా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","నీళ్లు యధాస్థానానికి మళ్లీ రావడం చేత రథాలను, అశ్వదళాలను కప్పేశాయి. ఇశ్రాయేలు ప్రజలను తరుముకొచ్చిన ఫరో సైన్యాలన్నీ నాశనం చేయబడ్డాయి. వాళ్లలో ఒక్కడూ బతకలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","అయితే ఇశ్రాయేలు ప్రజలు మాత్రం పొడినేల మీద సముద్రాన్ని దాటిపోయారు. వారి కుడి ఎడమ ప్రక్కల్లో నీళ్లు ఒక గోడలా నిలిచిపోయాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ఆ రోజు ఇశ్రాయేలు ప్రజలను ఈజిప్టువాళ్లు చేతినుండి యెహోవాయే రక్షించాడు. ఎర్రసముద్ర తీరాన ఈజిప్టువాళ్ల శవాలను ఇశ్రాయేలు ప్రజలు చూచారు. ");
INSERT INTO tel2010_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","యెహోవా ఈజిప్టు వాళ్లను ఓడించినప్పుడు ఆయన మహత్తర శక్తిని ఇశ్రాయేలు ప్రజలు చూశారు. అందుచేత ప్రజలు యెహోవాకు భయపడి ఆయనను ఘనపర్చారు. యెహోవాను, ఆయన సేవకుడైన మోషేను నమ్మారు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","అప్పుడు మోషే, అతనితో బాటు ఇశ్రాయేలు ప్రజలూ యెహోవాకు ఈ పాట పాడటం మొదలు పెట్టారు. “యెహోవాను గూర్చి నేను గానం చేస్తాను. ఆయన గొప్ప కార్యాలు చేసాడు గనుక గుర్రాలను, రౌతులను ఆయనే సముద్రంలో పడవేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","యెహోవా నా బలం, నన్ను రక్షించేది ఆయనే ఆయన్ను గూర్చి నేను స్తుతిగీతాలు పాడుకొంటాను. యెహోవా నా దేవుడు, ఆయన్ను నేను స్తుతిస్తాను. నా పూర్వీకుల దేవుడు యెహోవా ఆయన్ని నేను ఘనపరుస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","వీరుడు ఆయన పేరే యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","రథాలను అశ్వదళాలను సముద్రంలో పడవేసాడు యెహోవా ఫరో ప్రధాన అధికారులు ఎర్ర సముద్రంలో మునిగిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","లోతైన జలాలు వారిని కప్పేసాయి లోతు నీటిలో బండల్లా వాళ్లు మునిగిపొయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“నీ కుడిచేతిలో ఆశ్చర్యం కలిగించేటంత బలం ఉంది. ప్రభూ, నీ కుడిచేయి శత్రువును పటాపంచలు చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","నీకు వ్యతిరేకంగా నిలిచిన వారిని నీ మహా ఘనత చేత నాశనం చేసావు గడ్డిని తగుల బెట్టినట్టు నీ కోపం వారిని నాశనం చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","నీవు విసరిన పెనుగాలి నీళ్లను ఉవ్వెత్తున నిలిపేసింది వేగంగా ప్రవహించే నీళ్లు గట్టి గోడలా అయ్యాయి సముద్రం, దాని లోపలి భాగాలవరకు గడ్డ కట్టెను. ");
INSERT INTO tel2010_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“శత్రువు, ‘నేను వాళ్లను తరిమి పట్టుకొంటాను వాళ్ల ఐశ్వర్యాలన్నీ దోచుకొంటాను నేను నా కత్తి ప్రయోగించి, వాళ్ల సర్వస్వం దోచుకొంటాను సర్వం నా కోసమే నా చేతుల్తో దోచుకొంటాను’ అని అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","కానీ నీవు వాళ్లు మీదకి గాలి రేపి సముద్రంతో వాళ్లను కప్పేసావు సముద్ర అగాధంలో సీసం మునిగిపోయినట్టు వాళ్లు మునిగిపొయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“యెహోవా, నీలాంటి పరాక్రమముగల దేవుడు మరొకడు లేడు పరిశుద్ధతలో నీవు గొప్పవాడవు. స్తుతి కీర్తనలతో ఆరాధించబడుటకు యోగ్యుడవు ఆశ్చర్యకార్యములు చేయువాడవు నీకు సాటి వేరెవ్వరూ లేరు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","నీ కుడి హస్తాన్ని పైకెత్త ప్రపంచాన్నే నాశనం చేయగలవు! ");
INSERT INTO tel2010_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","నీవు రక్షించిన ప్రజల్ని నీ దయతో నీవు నడిపిస్తావు ఉల్లాసకరమైన నీ పవిత్ర దేశానికి నీ బలంతో నీవు వీళ్లను నడిపిస్తావు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","“ఈ గాథను ఇతర జన సమూహాలు వింటారు ఎంతైనా వాళ్లు భయపడ్తారు. ఫిలిష్తీ ప్రజలు భయంతో వణకిపోతారు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","తరువాత ఎదోము నాయకులు భయంతో వణకిపోతారు. మోయాబు నాయకులు భయంతో వణకిపోతారు. కనాను ప్రజలు తమ ధైర్యం కోల్పోతారు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ఆ ప్రజలు నీ బలాన్ని చూచి భయంతో నిండిపోతారు యెహోవా ప్రజలు దాటి పొయ్యేంత వరకు ఆ ప్రజల్ని నీవు దాటించేంత వరకు వాళ్లు బండలా మౌనంగా ఉండిపోతారు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","యెహోవా నీవు నీ సింహాసనం కోసం సిద్ధం చేసిన నీ పర్వతానికి నీ ప్రజల్ని నడిపిస్తావు ఓ ప్రభో, నీ హస్తాలతో నీ ఆలయాన్ని నిర్మించు ");
INSERT INTO tel2010_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“యెహోవా శాశ్వతంగా సదా ఏలునుగాక!” ");
INSERT INTO tel2010_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ఫరో గుర్రాలు, రౌతులు, రథాలు సముద్రంలోకి వెళ్లిపొయ్యాయి. సముద్ర జలాలతో యెహోవా వాళ్లను కప్పేసాడు. అయితే ఇశ్రాయేలు ప్రజలు పొడి నేల మీద సముద్రంలో నడిచివెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","అప్పుడు అహరోను సోదరి, మహిళా ప్రవక్తి మిర్యాము తంబుర పట్టుకొంది. మిర్యాము, మిగతా స్త్రీలు పాటలు పాడుతూ నాట్యం చేయడం మొదలు పెట్టారు. మిర్యాము ఈ మాటనే మరల మరల పల్లవిగా పలికింది, ");
INSERT INTO tel2010_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","“ఆయన గొప్ప కార్యాలు చేసాడు గనుక యెహోవాకు గానం చేయండి గుర్రాలను, దాని రౌతులను ఆయన సముద్రంలో పడవేసాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","మోషే మాత్రం ఇశ్రాయేలు ప్రజల్ని ఎర్ర సముద్రం నుండి దూరంగా నడిపిస్తూనే ఉన్నాడు. ప్రజలు షూరు ఎడారిలోకి వెళ్లారు. ఎడారిలో మూడు రోజులు వాళ్లు ప్రయాణం చేసారు. ప్రజలకు నీళ్లు ఏవీ దొరకలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","మూడురోజుల తర్వాత ప్రజలు మారాకు ప్రయాణమై వెళ్లారు. మారాలో నీళ్లున్నాయి గాని అవి త్రాగలేకపోయారు. ఆ నీళ్లు త్రాగలేనంత చేదుగా ఉన్నాయి. అందుకే ఆ స్థలానికి మారా అని పేరు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ప్రజలు మోషేకు ఫిర్యాదు చేయటం మొదలు బెట్టారు, “ఇప్పుడు మేము ఏమి త్రాగాలి?” అన్నారు ప్రజలు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","మోషే యెహోవాకు మొర పెట్టాడు. యెహోవా అతనికి ఒక చెట్టును చూపించాడు. మోషే ఆ చెట్టును నీళ్లలో వేసాడు. అతను యిలా చేయగానే ఆ నీళ్లు తాగే మంచి నీళ్లయ్యాయి. ఆ స్థలంలో ప్రజలకు యెహోవా తీర్పు తీర్చి వారికి ఒక ఆజ్ఞను ఇచ్చాడు. ఆ ప్రజల విశ్వాసాన్ని కూడ యెహోవా పరీక్షించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“మీ యెహోవా దేవునికి మీరు విధేయులు కావాలి. ఆయన ఏవి సరైనవని చెబతాడో వాటిని మీరు చేయాలి. యెహోవా ఆజ్ఞలకు, చట్టానికి మీరు విధేయులైతే, ఈజిప్టు వాళ్లలా మీరు రోగులు అవ్వరు. నేను, యెహోవాను, ఈజిప్టు వాళ్ల మీదకు పంపిన రోగాలు ఏవీ మీ మీదకు పంపించను. నేనే యెహోవాను. మిమ్మల్ని స్వస్థపరచేవాడ్ని నేనే.” ");
INSERT INTO tel2010_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","అప్పుడు ప్రజలు ఏలీమునకు ప్రయాణమయ్యారు. ఏలీములో 12 నీటి ఊటలు ఉన్నాయి. ఇంకా అక్కడ 70 ఈత చెట్లు ఉన్నాయి. అందుచేత ఆ నీళ్ల దగ్గర వారు బసను ఏర్పాటు చేసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","తర్వాత ప్రజలు ఏలీము నుండి ప్రయాణం చేసి సీనాయి ఎడారి చేరుకొన్నారు. ఈ స్థలం ఏలీముకి, సీనాయికి మధ్య ఉంది. ఈజిప్టు వదలిన తర్వాత రెండోనెల 15వ రోజున వారు ఈ స్థలానికి వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","అప్పుడు ఇశ్రాయేలు ప్రజలు మళ్లీ ఫిర్యాదు చేయటం మొదలు పెట్టారు. ఆ ఎడారిలో వారు మోషే అహరోనులకు ఫిర్యాదు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“ఈజిప్టు దేశంలోనే యెహోవా మమ్మల్ని చంపేసి ఉంటే మాకు బాగుండేది. ఈజిప్టులో తినేందుకు మాకు సమృద్ధిగా ఉండేది. మాకు కావాల్సిన భోజనం అంతా మాకు ఉండేది. కానీ ఇప్పుడు నీవు మమ్మల్ని ఈ ఎడారిలోనికి తీసుకొచ్చావు. మేమంతా ఆకలితో ఇక్కడే చస్తాము” అంటూ ప్రజలు మోషే అహరోనులతో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","అప్పుడు మోషేతో యెహోవా అన్నాడు, “ఆకాశం నుండి ఆహారం కురిపిస్తాను. ఈ ఆహారం మీరు తినేందుకే. ప్రతిరోజూ ప్రజలు బయటకు వెళ్లి ఆరోజు తాము తినేందుకు ఎంత భోజనం అవసరమో అంతే సమకూర్చు కోవాలి. నేను చెప్పినట్టు ప్రజలు చేస్తారో లేదో చూద్దామని నేను యిలా చేసాను. ");
INSERT INTO tel2010_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","ఒక్క రోజుకు ఎంత భోజనం సరిపోతుందో సరిగ్గా అంతే ప్రజలు ప్రతిరోజూ తీసుకోవాలి. అయితే శుక్రవారం నాడు ప్రజలు భోజనం సిద్ధం చేసుకొనేటప్పుడు రెండు రోజులకు సరిపడే భోజనం ఉండేటట్టు వారు చూసుకోవాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","కనుక మోషే అహరోనులు ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పారు, “ఈ రాత్రి యెహోవా శక్తి మీరు చూస్తారు. ఈజిప్టు దేశం నుండి ఆయనే మిమ్మల్ని రక్షించాడని మీరు తెలుసుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","యెహోవా మహిమను రేపు ఉదయం మీరు చూస్తారు. యెహోవాకు మీరు ఫిర్యాదు చేసారు. ఆయన మా మనవి విన్నాడు. (ఆయన మీకు సహాయం చేస్తాడు) మీరు మా దగ్గర ఫిర్యాదు మీద ఫిర్యాదు చేసారు. మేము ఏ పాటి వారం?” ");
INSERT INTO tel2010_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","“మీరు ఫిర్యాదు చేస్తూ ఉన్నారు, యెహోవా మీ ఫిర్యాదులు విన్నాడు. కనుక రాత్రివేళ ఆయన మీకు మాంసం ఇస్తాడు. మీకు అవసరం ఉన్న భోజనం అంతా ప్రతి ఉదయం మీకు ఉంటుంది. నా దగ్గర, అహరోను దగ్గర మీరు ఫిర్యాదు చేస్తూ ఉండినారు. కానీ ఇప్పుడు మేము కొంచెం విశ్రాంతి తీసుకొంటాం. మీరు ఫిర్యాదు చేస్తోంది నా మీద, అహరోను మీద కాదని జ్ఞాపకం ఉంచుకోండి. మీరు యెహోవాకు విరోధంగా ఫిర్యాదు చేస్తున్నారు” అన్నాడు మోషే. ");
INSERT INTO tel2010_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ఆ తర్వాత మోషే అహరోనుతో, “నీవు ఇశ్రాయేలు ప్రజలతో మాట్లాడు: ‘యెహోవా, మీ ఫిర్యాదులు విన్నాడు గనుక ఆయన ఎదుట సమావేశం అవ్వండి’ అని వారితో చెప్పు అన్నాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","అహరోను ఇశ్రాయేలు ప్రజలందరితో మాట్లాడాడు. వాళ్లంతా ఒక్కచోట చేరారు. అహరోను మాట్లాడుతూ ఉండగా, ప్రజలంతా పక్కకు తిరిగి ఎడారిలోకి చూచారు. యెహోవా మహిమ ఒక మేఘంలా ప్రత్యక్షమవడం వారు చూశారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“ఇశ్రాయేలు ప్రజల ఫిర్యాదులు నేను విన్నాను. కనుక నేను చెబతున్న నా మాటలు వారికి చెప్పు. ‘రాత్రివేళ మాంసం మీరు తింటారు. ప్రతి ఉదయం మీకు కావాల్సినంత భోజనం మీరు తింటారు. అప్పుడు మీ యెహోవా దేవుణ్ణి నమ్ముకోవచ్చని మీరు తెలుసుకొంటారు.’” ");
INSERT INTO tel2010_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ఆ రాత్రి వారి బస అంతటా పూరీళ్లు (పిట్టలు) వచ్చాయి. (మాంసం కోసం ప్రజలు ఈ పిట్టల్ని పట్టుకొన్నారు) ప్రతి ఉదయం బసకు దగ్గర్లో నేలమీద మంచు కురిసింది. ");
INSERT INTO tel2010_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","సూర్యోదయం కాగానే ఆ మంచు కరిగిపోయింది. అయితే మంచు పోగానే నేలమీద నూగుమంచు ఉండేది. ");
INSERT INTO tel2010_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","ఇశ్రాయేలు ప్రజలు అది చూసి “అది ఏమిటి?” అంటూ ఒకళ్లనొకళ్లు ప్రశ్నించుకొన్నారు. ఈ పదార్థం ఏమిటో వారికి అర్థం కాలేదు కనుక వాళ్లు ఈ ప్రశ్న అడిగారు. మోషే వాళ్లతో చెప్పాడు: “మీరు భోజనంచేయడానికి యెహోవా మీకు ఇచ్చిన భోజనం ఇది. ");
INSERT INTO tel2010_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ప్రతి వ్యక్తి తనకు అవసరమైనంత మాత్రమే తీసుకోవాలి. మీ కుటుంబంలో ప్రతి వ్యక్తికీ 2 పావుల కొలత ప్రకారం మీలో ఒక్కొక్కరు తీసుకోవాలి అని యెహోవా చెబతున్నాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","కనుక ఇశ్రాయేలు ప్రజలు అలాగే చేసారు. ప్రతి వ్యక్తి ఈ భోజనం కూర్చుకొన్నారు. కొంతమంది మిగతా వాళ్ల కంటె ఎక్కువ కూర్చుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ఆ ప్రజలు వారి కుటుంబంలో ప్రతివొక్కరికీ ఆ భోజనం పెట్టారు. ఆ భోజన పదార్థం కొలుచుకొన్నప్పుడల్లా, ప్రతి వ్యక్తికీ సరిపడ్డంత మాత్రమే ఉండేది. కాని ఎన్నడూ ఎక్కువ మిగిలేది కాదు. ప్రతి వ్యక్తీ తాను, తన కుటుంబం ఎంత తినగలరో సరిగ్గా అంతే తీసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","“రేపటికోసం ఆ భోజనం దాచుకోకండి” అని మోషే వారితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","కానీ ప్రజలు మోషేకు లోబడలేదు. కొంత మంది మర్నాడు తినవచ్చని తమ భోజనంలో కొంత దాచుకొన్నారు. అలా దాచుకొన్న భోజనం పురుగులు పట్టేసి, కంపు కొట్టేసింది. ఇలా చేసినవాళ్ల మీద మోషేకు కోపం వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ప్రతి ఉదయం ప్రజలు భోజనం కూర్చుకొన్నారు. ప్రతి వ్యక్తీ తాను తిన గలిగినంత కూర్చుకొన్నాడు. అయితే, ఎండ ఎక్కువ కాగానే ఆహారం కరిగిపోయి కనబడకుండా పోయింది. ");
INSERT INTO tel2010_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","శుక్రవారంనాడు, రెండంతల ఆహారం ప్రజలు కూర్చుకొన్నారు. ఒక్కొక్క మనిషికి 4 పావుల ప్రకారం వారు కూర్చుకొన్నారు. కనుక ప్రజానాయకులు మోషే దగ్గరకు వచ్చి ఈ విషయం తెలియజేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","“ఇలా జరుగుతుందని యెహోవా చెప్పాడు. ఎందుచేత? రేపు సబ్బాతు కనుక. అది యెహోవాకు ప్రత్యేకంగా విశ్రాంతి రోజు. ఈరోజు వండుకోవాల్సిన భోజనం అంతా వండుకోండి, అయితే మిగతా భోజనం రేపు ఉదయానికి దాచుకోండి” అన్నాడు మోషే వాళ్లతో. ");
INSERT INTO tel2010_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","కనుక ప్రజలు ఆ భోజనంలో మిగిలినదాన్ని మర్నాటికోసం దాచుకొన్నారు. ఆ భోజనంలో ఏమీ చెడిపోలేదు. అందులో కొంచెము కూడా పురుగుపట్టలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","శనివారం నాడు ప్రజలతో మోషే ఇలా చెప్పాడు: “ఈవేళ సబ్బాతు, అంటే యెహోవా విశ్రాంతి రోజు. అందుచేత మీలో ఏ ఒక్కరూ బయట పొలాల్లో ఉండకూడదు. నిన్న కూర్చుకొన్న భోజనాన్ని తినండి. ");
INSERT INTO tel2010_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","ఆరు రోజుల కోసం మీరు ఆహారం కూర్చుకోవాలి. అయితే ఏడోరోజు విశ్రాంతి రోజు కనుక నేల మీద ప్రత్యేక ఆహారం ఏమీ దొరకదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","శనివారంనాడు ప్రజల్లో కొంతమంది ఆహారం కూర్చుకోవాలని బయటకు వెళ్లారు కాని వారికి ఆహారం ఏమీ కనబడలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","అప్పుడు మోషేతో యెహోవా అన్నాడు. “నా ఆజ్ఞలకు ఉపదేశాలకు లోబడకుండా ఎన్నాళ్లు మీరు తిరస్కరిస్తారు? ");
INSERT INTO tel2010_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","చూడండి, శనివారం మీకు విశ్రాంతి రోజుగా చేసాడు యెహోవా. అందుచేత రెండు రోజులకు సరిపడేంత ఆహారం శుక్రవారమే యెహోవా మీకు ఇస్తాడు. కనుక శనివారంనాడు మీలో ప్రతి ఒక్కరూ కూర్చొని విశ్రాంతి తీసుకోవాలి. ఎక్కడి వాళ్లు అక్కడే ఉండండి.” ");
INSERT INTO tel2010_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","కనుక శనివారంనాడు ప్రజలు విశ్రాంతి తీసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ఆ ప్రత్యేక ఆహారాన్ని “మన్నా” అని పిలవడం మొదలుబెట్టారు ప్రజలు. మన్నా కొత్తిమెర గింజల్లా చిన్నగా తెల్లగా ఉండి, తేనెపూసిన పూతరేకుల్లా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","అప్పుడు మోషే అన్నాడు, “నేను మిమ్మల్ని ఈజిప్టునుండి బయటికి రప్పించినప్పుడు ఎడారిలో నేను మీకు ఇచ్చిన ఆహారాన్ని మీ సంతానం వాళ్లు చూడ గలిగేటట్టు ఈ ఆహారం 2 పావులు దాచి ఉంచమని యెహోవా చెప్పాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","కనుక మోషే అహరోనుతో ఇలా అన్నాడు: “ఒక పాత్ర తీసుకొని దానిలో 8 పావులు మన్నా నింపు. ఈ మన్నాను మన సంతానం వారి కోసం దాచిపెట్టు” ");
INSERT INTO tel2010_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","మోషే యెహోవా చెప్పినట్టు చేసాడు. మన్నా పాత్రను ఒడంబడిక పెట్టె ముందర పెట్టాడు అహరోను. ");
INSERT INTO tel2010_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","40 సంవత్సరాల పాటు ప్రజలు మన్నా తిన్నారు. కనాను దేశ సరిహద్దుల వచ్చేంతవరకు వారు దాన్ని తిన్నారు ");
INSERT INTO tel2010_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(మన్నా కొలిచేందుకు వారి ఉపయోగించిన కొలత ఓమెరు. ఓమెరు అంటే ఏపాలో పదో భాగం.) ");
INSERT INTO tel2010_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ఇశ్రాయేలు ప్రజలంతా కలసి సీను అరణ్యమునుండి ప్రయాణమయ్యారు. యెహోవా ఆజ్ఞాపించినట్లెల్లా ఒక తావు నుండి మరో తావుకు వాళ్లు ప్రయాణం చేసారు. ప్రజలు రెఫిదీముకు ప్రయాణం చేసి అక్కడ బసచేసారు. అక్కడ ప్రజలు తాగేందుకు నీళ్లు లేవు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","కనుక ప్రజలు మోషే మీదికి లేచి, ఆయనతో వాదించటం మొదలు పెట్టారు. “తాగేందుకు నీళ్లు ఇమ్మని” ప్రజలు మోషేను అడిగారు. అయితే మోషే, “మీరెందుకు నామీదికి ఇలా లేచారు? మీరు యెహోవాను ఎందుకు పరీక్షిస్తున్నారు?” (యెహోవా మనతో లేడని మీరనుకొంటున్నారా?) అని వారితో అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","కాని ప్రజలు మాత్రం నీళ్ల కోసం చాల దాహంగా ఉన్నారు. అందుచేత వాళ్లు మోషేకు ఫిర్యాదు చేస్తూనే ఉన్నారు, “అసలు నీవు మమ్మల్ని ఈజిప్టు నుండి ఎందుకు తీసుకొచ్చావు? నీళ్లు లేక మేము, మా పిల్లలు, మా పశువులు చావాలని నీవు మమ్మల్ని యిక్కడికి తీసుకొచ్చావా?” అన్నారు ప్రజలు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","కనుక మోషే, “ఈ ప్రజల్ని నేనేమి చేయాలి? నన్ను చంపెయ్యటానకి వాళ్లు సిద్ధంగా ఉన్నారు” అంటూ యెహోవాకు మొరబెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","మోషేతో యెహోవా అన్నాడు, “ఇశ్రాయేలు ప్రజల ముందుకు వెళ్లు. ప్రజల పెద్దలలో (నాయకులు) కొందర్ని నీ వెంట తీసుకొని వెళ్లు. నీ చేతి కర్రను తీసుకొని వెళ్లు. నీవు నైలునదిని కొట్టిన కర్ర యిది. ");
INSERT INTO tel2010_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","హోరేబులో (సీనాయి పర్వతం) నీ యెదుట ఒక బండమీద నేను నిలబడతాను. కర్రతో ఆ బండను కొట్టు, దానిలో నుండి నీళ్లు వస్తాయి. అప్పుడు ప్రజలు తాగవచ్చు.” మోషే ఈ పనులు చేసాడు, ఇశ్రాయేలు పెద్దలు (నాయకులు) అది చూచారు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","మెరీబా అని మస్సా అని ఆ స్థలానికి మోషే పేరు పెట్టాడు. ఎందుచేతనంటే, ప్రజలు తన మీదికి లేచి యెహోవాను పరీక్షించిన స్థలం ఇది. యెహోవా వారితో ఉన్నాడో లేదో తెల్సుకోవాలని ప్రజలు కోరారు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","రెఫిదీము వద్ద అమాలేకీ ప్రజలు వచ్చి ఇశ్రాయేలు ప్రజలతో యుద్ధం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","కనుక, “కొందరు మనుష్యుల్ని ఏర్పాటు చేసుకొని రేపు వెళ్లి అమాలేకీయులతో యుద్ధం చేయి. నేనేమో కొండ శిఖరం మీద నిన్ను గమనిస్తూంటాను. దేవుడు నాకు ఇచ్చిన కర్రను నేను పట్టుకొని ఉంటాను,” అని యెహోషువాతో మోషే చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","మోషే మాటకు విధేయుడై యెహోవాషువ మర్నాడు అమాలేకీ ప్రజలతో యుద్ధం చేసేందుకు వెళ్లాడు. అదే సమయంలో మోషే, అహరోను, హూరు అనువారు కొండ శిఖరం మీదికి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","మోషే తన చేతి కర్రను ఎప్పుడు పైకి ఎత్తితే అప్పుడు ఇశ్రాయేలు ప్రజలు యుద్ధం గెలుస్తున్నారు. అయితే మోషే తన చేయి కిందికి దించగానే ఇశ్రాయేలు ప్రజలు యుద్ధంలో ఓడిపోవడం మొదలవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","కొంచెం సేపయ్యాక, మోషే చేతులు అలసి పోయి (మోషే చేతుల్ని అలానే పైకి ఎత్తి ఉంచే మార్గం చూడాలను కొన్నారు మోషేతో ఉన్న మనుష్యులు) అందుచేత వాళ్లు ఒక పెద్ద బండ తెచ్చి మోషే కూర్చొనేందుకు వేసారు. అప్పుడు అహరోను మోషే చేతుల్ని పైకి ఎత్తి పట్టి ఉంచాడు. మోషేకు ఒకపక్క అహరోను, మరోపక్క హూరు ఉన్నారు. సూర్యుడు అస్తమించే వరకు వారు ఆయన చేతులను అలాగే పట్టి ఉంచారు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","కనుక యెహోషువ (అతని మనుష్యులు) అమాలేకీయులను ఆ యుద్ధంలో ఓడించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","అప్పుడు యెహోవా, “ఈ యుద్ధాన్ని గురించి వ్రాసి ఉంచు. ఇక్కడ ఏమి జరిగిందో అది ప్రజలు జ్ఞాపకం ఉంచుకొనేటట్టు ఈ సంగతులన్నీ ఒక గ్రంథంలో వ్రాసి ఉంచు. అమాలేకీయులను ఈ భూమి మీద నుండి పూర్తిగ నాశనం చేసేస్తానని యెహోవాషువతో తప్పక చెప్పు” అని మోషేతో అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","తర్వాత మోషే ఒక బలిపీఠం నిర్మించాడు, “యెహోవా నా ధ్వజం”. అని మోషే దానికి పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","“యెహోవా సింహాసనం వైపు నేను నా చేతులు ఎత్తాను. కనుక తను ఎప్పుడూ చేసినట్టే, యెహోవా అమాలేకీయులతో పోరాడాడు,” అన్నాడు మోషే. ");
INSERT INTO tel2010_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","మోషే మామ యిత్రో, మిద్యానులో యాజకుడు. మోషేకు, ఇశ్రాయేలు ప్రజలకు దేవుడు సహాయం చేసిన ఎన్నో విధానాల గూర్చి యిత్రో విన్నాడు. ఇశ్రాయేలు ప్రజలను ఈజిప్టు నుండి యెహోవా బయటకు నడిపించిన విషయం యిత్రో విన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","దేవుని పర్వతం దగ్గర మోషే ఉన్నప్పుడు మోషే భార్య సిప్పోరాను వెంటబెట్టుకొని, యిత్రో మోషే దగ్గరకు వెళ్లాడు. (సిప్పోరాను మోషే ఇంటికి పంపించినందు చేత ఆమె మోషే వద్ద లేదు) ");
INSERT INTO tel2010_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","మోషే ఇద్దరు కుమారులను కూడ యిత్రో తన వెంట తీసుకొని వచ్చాడు. “ఒక దేశంలో నేను పరాయివాణ్ణి అని మోషే చెప్పాడు గనుక. మొదటి కుమారునికి గెర్షోము అని పేరు పెట్టాడు.” “నా తండ్రి దేవుడు నాకు సహాయం చేసాడు. ఈజిప్టు రాజు బారినుండి నన్ను రక్షించాడు” అని మోషే అన్నాడు గనుక. ");
INSERT INTO tel2010_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","మరో కుమారునికి ఎలీయెజరు అని పేరు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","దేవుని పర్వతం దగ్గర ఎడారిలో మోషే బస చేస్తున్నప్పుడు యిత్రో మోషే దగ్గరకు వెళ్లాడు. మోషే భార్య, అతని ఇద్దరు కుమారులు యిత్రోతోనే ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","(మోషేకు యిత్రో ఒక సందేశం పంపించాడు), “నేను నీ మామ యిత్రోను. నీ భార్యను, నీ ఇద్దరు కుమారులను నేను నీ దగ్గరకు తీసుకొని వస్తున్నాను,” అన్నాడు యిత్రో. ");
INSERT INTO tel2010_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","కనుక మోషే తన మామగార్ని కలుసు కొనేందుకు బయటకు వెళ్లాడు. మోషే అతని ఎదుట వంగి, అతణ్ణి ముద్దు పెట్టుకొన్నాడు. వాళ్లిద్దరూ వారి వారి క్షేమాన్ని గూర్చి అడిగి తెలుసుకొన్నారు. తర్వాత ఇంకా మాట్లాడుకొనేందుకు వాళ్లిద్దరూ మోషే గుడారంలోకి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ఇశ్రాయేలు ప్రజలకోసం యెహోవా చేసినదంతా మోషే యిత్రోకు చెప్పాడు. ఫరోకు, ఈజిప్టు ప్రజలకు యెహోవా చేసిన విషయాల్ని గూర్చి మోషే అతనితో చెప్పాడు. దారిలో వారికి కలిగిన సమస్యలన్నిటిని గూర్చీ మోషే చెప్పాడు. కష్టం వచ్చినప్పుడల్లా ఆ ప్రజల్ని యెహోవా ఏ విధంగా రక్షించిందీ, మోషే తన మామగారితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ఇశ్రాయేలీయుల కోసం యెహోవా చేసిన మంచి పనులన్నింటిని గూర్చి విన్నప్పుడు యిత్రో చాలా సంతోషించాడు. ఈజిప్టు వాళ్ల నుండి, ఇశ్రాయేలు ప్రజలను యెహోవా విడుదల చేసినందుకు యిత్రో సంతోషించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","యిత్రో అన్నాడు: “యెహోవాను స్తుతించండి. ఈజిప్టు మనుష్యులనుండి ఆయన మిమ్మల్ని విడిపించాడు. ఫరో బారినుండి యెహోవా మిమ్మల్ని రక్షించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","ఈజిప్టు వాళ్లంటె నీ ప్రజలు గొప్ప వాళ్లుగా చేయబడిన విధానాన్ని బట్టి దేవుళ్లందరికంటె యెహోవా గొప్ప వాడని ఇప్పుడు నాకు తెలిసింది.” ");
INSERT INTO tel2010_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","అప్పుడు యిత్రో బలి అర్పణలు, కానుకలు యెహోవాకు సమర్పించాడు. తర్వాత అహరోను, అశ్రాయేలు పెద్దలు (నాయకులు) మోషే మామగారైన యిత్రోతో కలిసి భోజనం చేసేందుకు వచ్చారు. దేవుడ్ని ఆరాధించేందుకు ఒక ప్రత్యేక పద్ధతిగా వారు ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","మర్నాడు ప్రజలకు న్యాయం తీర్చాల్సిన ప్రత్యేక పని మోషేకు ఉంది. (అక్కడ చాలామంది ప్రజలున్నారు) అందుచేత ప్రజలు రోజంతా మోషే ఎదుట నిలబడాల్సి వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","ప్రజలకు మోషే న్యాయం తీర్చడం యిత్రో చూసాడు, “నీవు ఎందుకు ఇలా చేస్తున్నావు? ఎందుచేత నీవు ఒక్కడివే న్యాయమూర్తిగా ఉన్నావు? ప్రజలు రోజంతా నీ దగ్గరకు రావడం ఏమిటి?” అన్నాడు అతను. ");
INSERT INTO tel2010_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","అప్పుడు మోషే తన మామగారితో చెప్పాడు: “ప్రజలు వారి సమస్యల విషయంలో దేవుని నిర్ణయం ఏమిటో నేను అడిగి తెలుసుకోవాలని నన్ను అడిగేందుకు నా దగ్గరకు వస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","ఎవరిది సరిగ్గా ఉందో నేను నిర్ణయిస్తాను. ఈ విధంగా దేవుడి చట్టాన్ని, ఆయన ప్రబోధాల్ని నేను ప్రజలకు ప్రబోధిస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","అయితే మోషే మామ అతనితో ఇలా అన్నాడు: “నీవు చేస్తోన్న ఈ పని బాగుండలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","నీవు ఒక్కడివీ చెయ్యాలంటే, ఇది చాలా పెద్ద పని. దీనివల్ల నీవు అలసిపోతావు. ఇది ప్రజలు కూడ అలసిపొయ్యేటట్టు చేస్తుంది. ఈ పని నీవు ఒక్కడివీ చేయలేవు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","నీకు నేను సలహా ఇస్తాను, ఏమి చేయాలో నీకు చెబతాను, దేవుడు నీకు తోడుగా ఉండాలని ప్రార్థిస్తాను. (నీవు చేయాల్సింది ఇది) ప్రజల సమస్యలను గూర్చి నీవు వింటూ ఉండాల్సిందే. ఈ విషయాలను గూర్చి నీవు దేవునితో చెబుతూ ఉండాల్సిందే. ");
INSERT INTO tel2010_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","దేవుడి కట్టడలను, విధులను నీవు ప్రజలకు బోధించాలి. కట్టడలను ఉల్లంఘించొద్దని ప్రజలను హెచ్చరించు. సరైన జీవిత విధానం ఏమిటో ప్రజలకు చెప్పు. వాళ్లేమి చేయాలో వాళ్లకు చెప్పు.” ");
INSERT INTO tel2010_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","అయితే, “ప్రజల్లోనుంచి మంచి మనుష్యుల్ని నీవు ఏర్పాటు చేసుకోవాలి. డబ్బుకోసం నిర్ణయాలు మార్చుకోనటువంటి మనుష్యుల్ని ఏర్పాటు చేసుకో.” “వీళ్లను ప్రజల మీద పరిపాలకులుగా చేయి. 1,000 మంది 100 మందికి, 50 మందికి, చివరకి 10 మందికి పైన పరిపాలకులు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","ఈ పరిపాలకుల్ని ప్రజలకు న్యాయం తీర్చనివ్వు. ముఖ్యమైన వ్యాజ్యము ఏదైనా వుంటే అప్పుడు నిర్ణయంకోసం వాళ్లు నీ దగ్గరకు రావచ్చు. అయితే మిగతా వ్యాజ్యాలను వాళ్లే నిర్ణయించవచ్చు. ఈ విధంగా నీకు తేలిక అవుతుంది. పైగా ఈ మనుష్యులు నీ పనిని నీతోబాటు పంచుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","నీవు ఈ నీ పనులు చేస్తే, యెహోవాకు ఇష్టమైతే, నీ పని నీవు కొనసాగించటానికి నీకు చేతనవుతుంది. అదే సమయంలో ప్రజలంతా వారి సమస్యలు పరిష్కారమై ఇంటికి వెళ్లగల్గుతారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","యిత్రో తనకు చెప్పినట్టు మోషే చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","ఇశ్రాయేలు ప్రజల్లోనుంచి మంచి మనుష్యుల్ని మోషే ఏర్పాటు చేసాడు. మోషే వాళ్లను ప్రజలమీద నాయకులుగా చేసాడు. 1,000 మంది ప్రజల మీద 100 మంది ప్రజలమీద 50 మంది ప్రజలమీద 10 మంది ప్రజలమీద పరిపాలకులు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","ఈ పరిపాలకులే ప్రజలకు న్యాయమూర్తులు. ఎప్పుడైనా సరే ప్రజలు తమ వాదాలను ఈ పరిపాలకుల దగ్గరకు తీసుకురావచ్చు. ప్రాముఖ్యమైన వ్యాఖ్యాలను మాత్రమే మోషే పరిష్కారం చేయాల్సి ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","కొద్దికాలం తర్వాత మోషే తన మామ యిత్రోకు వీడ్కోలు చెప్పాడు. యిత్రో తన స్వగృహానికి వెళ్లిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","ఇశ్రాయేలు ప్రజలు ఈజిప్టు విడిచి ప్రయాణమైన మూడో నెలలో వారు సీనాయి అరణ్యము చేరుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","ప్రజలు రెఫిదీము విడిచి, సీనాయి అరణ్యమునకు వచ్చారు. పర్వత సమీపంలోని అరణ్యములో ఇశ్రాయేలు ప్రజలు బసచేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","అప్పుడు మోషే పర్వతం మీద దేవుడి దగ్గరకు వెళ్లాడు. మోషే ఆ పర్వతం మీద ఉన్నప్పుడు, అతనితో దేవుడు ఇలా చెప్పాడు. “యాకోబు మహా వంశమైన ఇశ్రాయేలు ప్రజలకు ఈ విషయాలు చెప్పు: ");
INSERT INTO tel2010_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘నా శత్రువులకు నేను చేసిన పనులన్నీ మీరు చూసారు. ఈజిప్టు వాళ్లకు నేను ఏమి చేసానో మీరు చూసారు. పక్షిరాజువలె నేను మిమ్మల్ని ఈజిప్టు నుండి మోసుకొని వచ్చి, నా దగ్గరకు, ఇక్కడికి తీసుకొచ్చాను. ");
INSERT INTO tel2010_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","కనుక ఇప్పుడు మీరు నా మాటలకు లోబడాలి అంటున్నాను. నా ఒడంబడికను నిలబెట్టండి. మీరు ఇలా చేస్తే, మీరు వా ప్రత్యేకమైన స్వంత ప్రజలుగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","మీరు ఒక ప్రత్యేక జాతిగా యాజకుల సామ్రాజ్యంగా మీరు ఉంటారు.’ మోషే, నేను నీతో చెప్పిన ఈ విషయాలు ఇశ్రాయేలు ప్రజలతో నీవు తప్పక చెప్పాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","కనుక మోషే పర్వతం దిగివచ్చి ప్రజల పెద్దలను (పరిపాలకులను) సమావేశపర్చాడు. వాళ్లతో చెప్పమని యెహోవా తనకు ఆజ్ఞాపించిన విషయాలన్నింటినీ మోషే ఆ పెద్దలకు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ప్రజలంతా కలిసి మాట్లాడారు. “యెహోవా చెప్పిన దానికంతటికీ మేము విధేయులం” అని వారు చెప్పారు. తర్వాత పర్వతం మీద దేవుని దగ్గరకు మోషే వెళ్లాడు. ప్రజలు ఆయనకు విధేయులవుతారు అని మోషే దేవునితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","“దట్టమైన మేఘంలో నేను మీ దగ్గరకు వస్తాను. నేను నీతో మాట్లాడుతాను. నేను నీతో మాట్లాడటం ప్రజలంతా వింటారు. నీవు చెప్పే విషయాలు ప్రజలు ఎల్లప్పుడూ నమ్మేటట్టుగా నేను ఈ పని చేస్తాను.” అని యెహోవా మోషేతో చెప్పాడు. అప్పుడు ప్రజలు చెప్పిన సంగతులన్నీ యెహోవాతో చెప్పాడు మోషే. ");
INSERT INTO tel2010_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","యెహోవా మోషేతో ఇలా చెప్పాడు: “ప్రత్యేకమైన ఒక సమావేశంగా ప్రజల్ని ఇవ్వాళ రేపు నీవు సిద్ధం చేయాలి. ప్రజలు తమ బట్టలు ఉదుక్కొని ");
INSERT INTO tel2010_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","మూడో రోజున నా కోసం సిద్ధంగా ఉండాలి. మూడో రోజున సీనాయి పర్వతం మీదికి యెహోవా దిగివస్తాడు. ప్రజలంతా నన్ను చూస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","13","అయితే ప్రజలు పర్వతానికి దూరంగా ఉండాలని నీవు తప్పక చెప్పాలి. ఒక గీతగీసి ప్రజలు ఆ గీత దాటి రాకుండా చూడు. ఏ మనిషిగాని, జంతువుగాని పర్వతాన్ని తాకినట్లయితే, చంపేయాలి. బాణాలతో, లేక రాళ్లతో కొట్టి చంపేయాలి. కాని అలాంటి వాణ్ణి ఎవరూ ముట్టుకోకూడదు. బూర ఊదేంత వరకు ప్రజలు వేచి ఉండాలి. అప్పుడే వాళ్లు పర్వతం మీదికి వెళ్లేందుకు అనుమతి ఇవ్వబడుతుంది,” అని మోషేతో యెహోవా చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","కనుక మోషే పర్వతం దిగి కిందికి వెళ్లాడు. ఆయన ప్రజల దగ్గరికి వెళ్లి, ప్రత్యేక సమావేశం కోసం వాళ్లను సిద్ధం చేసాడు. ప్రజలు వాళ్ల బట్టలు ఉదుక్కొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","అప్పుడు మోషే ప్రజలతో, “ఇంక మూడు రోజుల్లో యెహోవాతో సమావేశం అయ్యేందుకు సిద్ధంగా ఉండండి. అంతవరకు పురుషులు స్త్రీలను ముట్టుకోగూడదు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","మూడవ రోజు ఉదయాన పర్వతం మీద ఉరుములు, మెరుపులు వచ్చాయి. దట్టమైన ఒక మేఘం ఆ పర్వతం మీదికి వచ్చింది. ఒక బూర శబ్దం చాల పెద్దగా వినబడింది. ఆ బసలో ఉన్న ప్రజలంతా భయపడిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","అప్పుడు పర్వతం దగ్గర దేవుణ్ణి కలుసుకొనేందుకు ప్రజలను వారి బసలోనుంచి మోషే బయటకు నడిపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","సీనాయి పర్వతం పొగతో నిండిపోయింది. కొలిమిలోనుంచి లేచినట్టు పొగ ఆ పర్వతం మీద నుండి పైకి లేచింది. యెహోవా అగ్నిలా ఆ పర్వతం మీదికి వచ్చినందువల్ల యిలా జరిగింది. పైగా పర్వతం అంతా వణకడం మొదలయ్యింది. ");
INSERT INTO tel2010_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","బూర శబ్దం మరింత గట్టిగా మోగింది. దేవునితో మోషే మాట్లాడినప్పుడల్లా ఉరుములాంటి స్వరంతో యెహోవా జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","సీనాయి కొండ మీదికి యెహోవా దిగి వచ్చాడు. పరలోకంనుంచి ఆ కొండ శిఖరం మీదికి యెహోవా దిగి వచ్చాడు. అప్పుడు మోషేను తనతో కూడ పర్వత శిఖరం మీదికి రమ్మని యెహోవా పిలిచాడు. కనుక మోషే పర్వతం మీదికి వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","అప్పుడు యెహోవా మోషేతో, “నీవు కిందికి వెళ్లి, ప్రజలు నాకు సమీపంగా రాకూడదని, నావైపు చూడకూడదని వారితో చెప్పు. వారు కనుక అలా చేస్తే, వారిలో చాల మంది చస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","నాకు సమీపంగా వచ్చే యాజకులు ఈ ప్రత్యేక సమావేశం కోసం వారిని సిద్ధం చేసుకోవాలని వారితో చెప్పు. వారు ఇలా చేయకపోతే, నేను వాళ్లను శిక్షిస్తాను” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","కానీ మోషే యెహోవాతో “ప్రజలు పర్వతం మీదికి రాలేరు. ఒక గీత గీయమని, ప్రజల్ని ఆ గీత దాటి పవిత్ర స్థలం దగ్గరకు రానివ్వవద్దని నీవే మాకు చెప్పావు” అని అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","యెహోవా మోషేతో, “కింద ప్రజల దగ్గరకు వెళ్లి, అహరోనును తీసుకొనిరా. అతణ్ణి నీతోపాటు తీసుకొనిరా, కాని యాజకుల్ని, ప్రజల్ని, రానివ్వవద్దు. వాళ్లు నాకు సమీపంగా వస్తే, నేను వాళ్లను శిక్షిస్తాను” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","మోషే ప్రజల దగ్గరకు కిందికి వెళ్లి, ఈ సంగతులు వారితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","అప్పుడు మోషేతో దేవుడు ఈ మాటలు చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“నేను మీ దేవుణ్ణి. యెహోవాను. ఈజిప్టు దేశం నుండి నేనే మిమ్మల్ని బయటికి రప్పించాను. బానిసత్వం నుండి నేనే మిమ్మల్ని విడుదల చేసాను. (కనుక ఈ ఆజ్ఞలకు మీరు విధేయులు కావాలి) ");
INSERT INTO tel2010_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“నేను గాక వేరే దేవుళ్లు ఎవ్వరినీ మీరు ఆరాధించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“విగ్రహాలు ఏవీ మీరు చేయకూడదు పైన ఆకాశానికి సంబంధించింది గాని, క్రింద భూమికి సంబంధించిందిగాని, భూమి క్రింద నీళ్లకు సంబంధించిందిగాని, దేని విగ్రహాన్ని లేక పటాన్ని చేయవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","ఎలాంటి విగ్రహాల్నీ పూజించవద్దు, సేవించవద్దు. ఎందుకంటే, యెహోవాను నేనే మీ దేవుణ్ణి. నేను నా ప్రజలు వేరే దేవుళ్లను పూజించటాన్ని ద్వేషిస్తాను. ఒక వ్యక్తి నాకు వ్యతిరేకంగా పాపం చేస్తే ఆ వ్యక్తి నన్ను ద్వేషిస్తున్నాడు. ఆ వ్యక్తి సంతానాన్ని మూడు, నాలుగు తరాల వరకు నేను శిక్షిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","అయితే నా ఆజ్ఞలను ప్రేమించి, విధేయులయ్యే ప్రజలకు వేల తరాలవరకు నేను ఎంతో దయ చూపిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“మీ దేవుడైన యెహోవా పేరును మీరు తప్పుగా ప్రయోగించకూడదు. ఒక వ్యక్తి గనుక యెహోవా పేరును తప్పుగా ప్రయోగిస్తే, ఆ వ్యక్తి దోషి. యెహోవా అతణ్ణి నిర్దోషిగా చేయడు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“సబ్బాతును ఒక ప్రత్యేక రోజుగా ఉంచుకోవడం మరచిపోవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","వారానికి ఆరు రోజులు మీరు మీ పని చేసుకోవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","అయితే, యెహోవా గౌరవార్థం ఏడవరోజు విశ్రాంతి రోజు కనుక ఆ రోజు ఏ వ్యక్తీ పని చేయకూడదు. అంటే మీరు, మీ కొడుకులు, కూతుళ్లు, మీ ఆడ, మగ బానిసలు, చివరికి మీ జంతువులు, మీ పట్టణాల్లో నివసించే విదేశీయులు కూడాను. ");
INSERT INTO tel2010_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ఎందుకంటే, యెహోవా ఆరు రోజులు పనిచేసి ఆకాశాన్ని, భూమిని, సముద్రాన్ని వాటిలో ఉండే సమస్తాన్ని చేసాడు. ఏడో రోజున దేవుడు విశ్రాంతి తీసుకొన్నాడు. ఈ విధంగా ఏడవరోజును యెహోవా ఆశీర్వదించాడు. దాన్ని చాలా ప్రత్యేకమైన రోజుగా యెహోవా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“నీ తండ్రిని, నీ తల్లిని సన్మానించు. నీ దేవుడైన యెహోవా నీకిచ్చే దేశంలో నీకు పూర్తి ఆయుష్షు ఉండేటట్టుగా నీవు ఇలా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“నీవు ఎవ్వరినీ హత్య చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“వ్యభిచార పాపం నీవు చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“నీవు దొంగతనం చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“నీ పొరుగువాళ్ల విషయంలో నీవు అబద్ధాలు చెప్పకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“ఇతరుల వస్తువుల్ని నీవు తీసుకోవాలని ఆశ పడకూడదు. నీ పొరుగు వాడి ఇంటిని, లేక వాని భార్యను, లేక వాని ఆడ, మగ సేవకులను, లేక వాని ఆవులను, లేక అతని గాడిదలను తీసుకోవాలని నీవు ఆశపడకూడదు. నీ పొరుగువానికి చెందినది ఏదీ తీసుకోవాలని నీవు ఆశపడకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ఇంతసేపూ లోయలో ప్రజలు కొండమీది ఉరుము శబ్దం వింటూనే ఉన్నారు. మెరుపులు చూస్తునే ఉన్నారు. కొండమీద నుండి పొగ లేవడం వారు చూసారు. ప్రజలు భయపడి వణకిపోయారు. వాళ్లు కొండకు దూరంగా నిలబడి గమనించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","అప్పుడు ప్రజలు మోషేతో “నీవు మాతో మాట్లాడాలంటే మేము వింటాం. కాని దేవుణ్ణి మాత్రం మాతో మాట్లాడనివ్వకు. అలా జరిగితే మేము చస్తాము,” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","అప్పుడు మోషే, “తాను మిమ్మల్ని ప్రేమిస్తున్నాడని రుజువు చేయడానికే, యెహోవా వచ్చాడు. మీరు పాపం చేయకుండా ఉండేలా మీరు ఆయనను గౌరవించాలని ఆయన కోరుతున్నాడు” అని ప్రజలకు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","దేవుడువున్న దట్టమైన మేఘం దగ్గరకు మోషే వెళుతోంటే, ప్రజలు ఆ కొండకు దూరంగా నిలబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","అప్పుడు ఈ సంగతులు ఇశ్రాయేలు ప్రజలతో చెప్పమని యెహోవా మోషేతో చెప్పాడు. “ఆకాశం నుండి నేను మీతో మాట్లాడటం మీరు చూసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","కనుక మీరు బంగారంతోగాని, వెండితోగాని నాకు పోటీగా విగ్రహాలు చేసుకోకూడదు. ఈ అబద్ధపు దేవుళ్లను మీరు చేసుకోకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“నా కోసం ఒక ప్రత్యేక బలిపీఠం చేయండి. ఈ బలిపీఠం చేయడానికి మట్టి ఉపయోగించండి. ఈ బలిపీఠం మీద దహనబలులు, సమాధాన బలులు, బలిగా నాకు అర్పితం చేయండి. ఇలా చేయటానికి మీ గొర్రెల్ని, పశువుల్ని వాడుకోండి. నన్ను జ్ఞాపకం చేసుకోమని నేను మీకు చెప్పే ప్రతి చోటా మీరు యిలా చేయాలి. అప్పుడు నేను వచ్చి మిమ్మల్ని ఆశీర్వదిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","మీరు బండలతో బలిపీఠం కడితే, చెక్కబడిన బండలతో దానిని కట్టవద్దు. ఎందుకంటే, పనిముట్లతో మీరు పని చేసినప్పుడు మీరు దానిని అపవిత్రం చేస్తారు. బండల మీద మీరు ఏవైనా పని ముట్లు ప్రయోగిస్తే, ఆ బలిపీఠాన్ని నేను అంగీకరించను. ");
INSERT INTO tel2010_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","బలిపీఠం మీదికి వెళ్లేందుకు మీరు మెట్లు చేయకూడదు. అలా మెట్లు ఉంటే, ప్రజలు బలిపీఠం వైపుకి చూసినప్పుడు మీ దిగంబరత్వం అంతా వారికి కనబడుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","(అప్పుడు మోషేతో యెహోవా అన్నాడు), “ఇవి నీవు ప్రజలకు ఇవ్వాల్సిన మిగతా ఆజ్ఞలు: ");
INSERT INTO tel2010_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“హీబ్రూ బానిసను కనుక నీవు కొంటే, ఆ బానిస ఆరు సంవత్సరాలు మాత్రమే నీ సేవ చేయాలి. ఆరు సంవత్సరాల తర్వాత వాడు స్వతంత్రుడవుతాడు. వాడు చెల్లించాల్సింది ఏమీ ఉండదు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","ఆ వ్యక్తి నీకు బానిస అయినప్పుడు పెళ్లిగాకుండా ఉంటే అతడు స్వతంత్రుడయినప్పుడు భార్యలేని వానిగానే నీ దగ్గర్నుండి వెళ్తాడు. అయితే అతడు నీకు బానిస అయినప్పుడు పెళ్లయిన వాడైతే, అతడు విడదల చేయబడినప్పుడు తన భార్యను తనతో ఉంచుకొంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","బానిస బ్రహ్మచారి అయితే యజమాని అతనికి ఒక భార్యను ఇవ్వవచ్చు. ఆ భార్యకు కొడుకులు, కూతుళ్లు పుడితే, ఆ స్త్రీ, ఆమె పిల్లలు యజమానికి చెందుతారు. ఆ బానిస సేవాకాలం తీరిపోతే, అప్పుడు అతడు విడుదల చేయబడతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“అయితే ఒక వేళ ఆ యజమాని దగ్గరే ఉండిపోవాలని బానిస తీర్మానించుకొంటే, ‘నా యజమాని అంటే నాకు ప్రేమ. నా భార్య పిల్లల మీద నాకు ప్రేమ కనుక నాకు స్వతంత్రం అక్కర్లేదు, నేను ఇలాగే ఉండిపోతాను’ అని అతడు తప్పక చెప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ఇలా కనుక జరిగితే యజమాని ఆ బానిసను దేవుని దగ్గరకు తీసుకరావాలి. తలుపు దగ్గరకు గాని, ద్వార బంధం దగ్గరకు గాని యజమాని ఆ బానిసను తీసుకు రావాలి. యజమాని ఏదైనా పదునుగల పరికరాన్ని ప్రయోగించి, ఆ బానిస చెవికి రంధ్రం చేయాలి. అప్పుడు బానిస జీవితాంతం ఆ యజమానినే సేవిస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ఒకడు తన కూతుర్ని బానిసగా అమ్మి వేయాలని నిర్ణయించవచ్చు. ఇలా కనుక జరిగితే, ఆమెను విడుదల చేసేందుకు సంబంధించిన నియమాలు మగ బానిసలను విడుదల చేసే నియమాల్లాంటివి కావు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ఆ స్త్రీ విషయం యజమానికి ఇష్టం లేకపోతే అతడు ఆ స్త్రీని తిరిగి తన తండ్రికి అమ్మివేయవచ్చును. ఒకవేళ ఆ స్త్రీని పెళ్లి చేసుకొంటానని ఆ యజమాని వాగ్దానం చేసి ఉంటే, ఇతరులకు ఆ స్త్రీని అమ్మివేసే అధికారం అతను కోల్పోతాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ఆ యజమాని తన కుమారుణ్ణి పెళ్లి చేసుకోవచ్చని వాగ్దానం చేసి ఉంటే, అప్పుడు ఆమె బానిసగా ఎంచబడదు. ఒక కూతురిగా ఆమె చూడబడుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“ఒకవేళ యజమాని మరో స్త్రీని పెండ్లాడితే, మొదటి స్త్రీకి భోజనం, బట్ట, అతడు తక్కువ చేయకూడదు. ఆమెకు ఏవేవి అనుభవించటానికి పెళ్లిద్వారా హక్కు లభించిందో వాటన్నిటినీ అతడు ఆమెకు ఇస్తూనే ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ఈ మూడింటినీ మగవాడు ఆమె కోసం చేయాలి. అతడు చేయకపోతే, ఆమెకు ఏ ఖర్చూ లేకుండానే ఆమె విడుదల చేయబడుతుంది. ఆమె అతడకి డబ్బు ఏమీ రుణపడి ఉండదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ఒకడు ఎవరినైనా కొట్టి చంపితే, వాడిని కూడ చంపెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","అయితే ఏదైనా ప్రమాదం జరిగి, ఏ పధకం వెయ్యకుండానే ఒకడు మరొకడ్ని చంపితే, అది దేవుడు జరుగనిచ్చినదే అవుతుంది. భద్రతకోసం ప్రజలు పారిపోయేందుకు ప్రత్యేక స్థలాలు కొన్నింటిని నేను ఏర్పాటు చేస్తాను. కనుక ఆ వ్యక్తి వీటిలో ఒక చోటికి పారిపోవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ఒకడు మరొకని మీద కోపంతో, లేక ద్వేషంతో చంపడానికి పధకం వేస్తే, అలాంటి హంతకుడు శిక్షించబడాలి. వానిని నా బలిపీఠం నుండి దూరంగా తీసుక పోయి చంపేయాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ఎవడైనా తన తండ్రిని గాని, తల్లినిగాని కొడితే వానిని చర పేయ్యాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“బానిసగా అమ్మేందుకు, లేక తనకు బానిసగా ఉండేందుకు ఎవరైనా మరొకడ్ని ఎత్తుకుపోతే, ఆ వ్యక్తిని చంపెయ్యాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ఎవరైనా తన తండ్రిని లేక తల్లిని శపిస్తే ఆ వ్యక్తిని చంపెయ్యాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ఇద్దరు వ్యక్తులు జగడమాడుకొని, వారిలో ఒకడు రాతితో గాని, పిడికిలితో గాని మరొకనిని కొడితే, (అలాంటివాడిని ఎలా శిక్షిస్తావు?) దెబ్బ తగిలిన వాడు చావకపోతే, అతడ్ని దెబ్బకొట్టి వాణ్ణి చంపకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","అయితే దెబ్బ తిన్నవాడు కొన్నాళ్లపాటు పడక మీద ఉండాల్సివస్తే, అతణ్ణి కొట్టినవాడే అతణ్ణి పోషించాలి. అతణ్ణి కొట్టినవాడే అతనికి కలిగిన సమయం నష్టానికి పరిహారం చెల్లించాలి. అతడు పూర్తిగా బాగయ్యేవరకు ఆ వ్యక్తి అతణ్ణి పోషించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“కొన్నిసార్లు ప్రజలు తమ ఆడ లేక మగ బానిసలను కొడతారు. అలా కొట్టినతర్వాత బానిస చస్తే, హంతకుడు శిక్షించబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","అయితే బానిస చావకుండా, కొన్ని రొజుల తర్వాత బాగైతే, అప్పుడు ఆ వ్యక్తి శిక్షించబడడు. ఎందుకంటే, బానిసకోసం యజమాని డబ్బు చెల్లించాడు గనుక బానిస అతనికే చెందుతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ఇద్దరు మగవాళ్లు పోట్లాడుకొంటునప్పుడు ఒక గర్భవతికి దెబ్బ తగలవచ్చు. ఒకవేళ ఆమె ప్రసవించినా ఆమెకు తీవ్రంగా దెబ్బ తగలకపోతే, ఆమెకు దెబ్బ తగిలించినవాడు డబ్బు చెల్లించాలి. అతడు ఎంత డబ్బు చెల్లించాలి అనే విషయం ఆమె భర్త నిర్ణయిస్తాడు. ఆ నష్టం మొత్తం ఎంత అనేది నిర్ణయించడంలో న్యాయాధిపతులు అతనికి సహాయం చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","అయితే, ఆ స్త్రీకి తీవ్రంగా దెబ్బ తగిలితే ఆమెను కొట్టినవాడు శిక్షించబడాలి. ఒక వ్యక్తి చంపబడితే, ఆ వ్యక్తిని చంపిన వాణ్ణి చంపెయ్యాలి. ఒకడి ప్రాణానికి బదులుగా మరొకడి ప్రాణం తియ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","కంటికి కన్ను, పంటికి పన్ను, చేతికి చేయి, పాదానికి పాదం, ");
INSERT INTO tel2010_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","వాతకు వాత, గాయానికి గాయం, కోతకు కోత ఉండాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ఒకడు ఒక బానిస కంటిమీద గుద్దితే, ఆ బానిసకు ఆ కన్ను గుడ్డిదైతే అప్పుడు ఆ బానిస స్వతంత్రుడిగా వెళ్లిపోవచ్చు. అతని కన్ను అతని విడుదలకు వెలఅవుతుంది. ఆడ బానిసకైనా మగ బానిసకైనా ఇంతే. ");
INSERT INTO tel2010_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","ఒకవేళ యజమాని తన బానిస మూతి మీద కొడితే, ఆ బానిసకు ఒక పన్ను ఊడితే ఆ బానిస స్వతంత్రుడుగా వెళ్లిపోవచ్చు. ఆ బానిస విడుదలకు ఆ బానిస పన్ను వెల అవుతుంది. ఆడ బానిసకైనా మగ బానిసకైనా ఇంతే, ");
INSERT INTO tel2010_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ఒక వేళ ఒకడి ఎద్దు ఏ పురుషుణ్ణి గాని, స్త్రీనిగాని చంపితే, అప్పుడు ఆ ఎద్దును రాళ్లతో కొట్టి చంపాలి. ఎద్దును మీరు తినకూడదు. కాని ఎద్దు యజమాని మాత్రం నేరస్తుడు కాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","అయితే అంతకు ముందు ఆ ఎద్దు ఎవర్నయినా పొడిచి ఉంటే, దాని యజమానికి హెచ్చరిక ఇవ్వబడి ఉంటే, అప్పుడు ఆ యజమాని నేరస్తుడే, ఎందుకంటే, ఆ ఎద్దును అతడు కట్టి వెయ్యలేదు. లేక దాని స్థానంలో దాన్ని బంధించలేదు. కనుక ఎద్దును విచ్చలవిడిగా తిరుగనిస్తే, అది ఎవర్నయినా చంపేస్తే, అప్పుడు ఆ యజమాని నేరస్తుడే, మీరు ఎద్దును రాళ్లతో కొట్టి చంపాలి. తర్వాత యజమానిని కూడ చంపెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","అయితే చనిపోయిన వాని కుటుంబం డబ్బు తీసుకోవచ్చు. ఒకవేళ వారు అలా డబ్బు తీసుకొంటే, ఎద్దు స్వంతదారుడ్ని చంపకూడదు. కాని న్యాయాధిపతి నిర్ణయించిన డబ్బు అతడు చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“ఒకరి కొడుకును లేక కూతుర్ని ఎద్దు చంపేస్తే యిదే చట్టాన్ని పాటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ఒక ఎద్దు ఒక బానిసను గనుక చంపేస్తే, మరొక కొత్త బానిస కోసం యజమానికి ముప్పయి వెండి నాణాలను ఎద్దు స్వంతదారుడు చెల్లించాలి. ఎద్దును మాత్రం రాళ్లతో కొట్టి చంపాలి. మగ బానిసలకు, ఆడ బానిసలకు ఈ చట్టం సమానంగా వర్తిస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ఒకడు గొయ్యిగాని, బావిగాని తవ్వి మూత పెట్టక పోవచ్చును. మరొకడి జంతువు వచ్చి ఆ గుంటలో పడితే ఆ గుంట స్వంతదారుడు నేరస్తుడు. ");
INSERT INTO tel2010_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","ఆ గుంట స్వంతదారుడు ఆ జంతువు కోసం డబ్బు చెల్లించాలి. అయితే ఆ జంతువు కోసం అతడు డబ్బు చెల్లించాక అతడు ఆ జంతువు శవాన్ని ఉంచు కొనేందుకు అనుమతి ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ఒకవేళ ఒకరి ఎద్దు మరొకరి ఎద్దును చంపేస్తే అప్పుడు బతికి ఉన్న ఎద్దును అమ్మివేయాలి. ఆ ఎద్దును అమ్మిన డబ్బు వాళ్లిద్దరూ సగం సగం తీసుకోవాలి, చంపబడ్డ ఎద్దులో కూడ వాళ్లిద్దరికి సగం సగం వస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","అయితే ఒకని ఎద్దు అంతకు ముందు ఇతరుల జంతువులను పొడిచి ఉంటే, అతని ఎద్దు విషయం ఆ యజమాని బాధ్యుడు. ఒకవేళ అతని ఎద్దు మరొక ఎద్దును చంపేస్తే, ఆ ఎద్దును స్వేచ్ఛగా తిరుగనిచ్చినందుకు అతడు నేరస్థుడు, అతడు ఎద్దుకు బదులు ఎద్దును ఇవ్వాలి. చంపబడిన ఎద్దుకు బదులుగా అతడు తన ఎద్దును ఇవ్వాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ఒక ఎద్దును లేక గొర్రెను దొంగతనం చేసిన వాడిని నీవు ఎలా శిక్షిస్తావు? వాడు ఆ జంతువును చంపేసినా లేక అమ్మేసినా అతడు దాన్ని తిరిగి ఇవ్వలేడు. కనుక వాడు దొంగిలించిన ఒక్క ఎద్దుకు బదులు అయిదు ఎడ్ల నివ్వాలి. లేక వాడు దొంగతనం చేసిన ఒక్క గొర్రెకు బదులు నాలుగు గొర్రెలు ఇవ్వాలి. దొంగతనానికి అతడు శిక్ష చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","3","వాడికి స్వంతది అంటూ ఏమీ లేకపోతే, వాడ్ని బానిసగా అమ్మాలి. అయితే ఆ జంతువు ఇంకా వాని దగ్గరే ఉంటే, దాన్ని, నీవు చూస్తే అప్పుడు వాడు ఆ దొంగిలించిన ప్రతి జంతువుకు బదులుగా రెండు జంతువుల్ని యజమానికి ఇవ్వాలి. ఆ జంతువు ఎద్దు, గాడిద, గొర్రె, ఏదైనా ఫర్వాలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","దొంగ రాత్రివేళ ఒక ఇంటికి కన్నము వేయటానికి ప్రయత్నిస్తూండగా చంపబడితే, వాణ్ణి చంపిన నేరం ఎవ్వరి మీదా ఉండదు. అయితే ఇది పగలు జరిగితే వాణ్ణి చంపిన వాడు నేరస్థుడే (దోషి). ");
INSERT INTO tel2010_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ఒకడు తన పొలంలో లేక ద్రాక్షాతోటలో మంట రాజబెడితే, ఆ మంట పాకిపోయి, పక్కవాడి పొలాన్ని లేక ద్రాక్షా తోటను కాల్చివేస్తే అతడు తన శ్రేష్ఠమైన పంటను తన పొరుగువాడికి నష్టపరిహారంగా ఇవ్వాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ఒకడు తన పొలంలో ముళ్ల పొదలను తగుల బెట్టడానికి మంట పెట్టవచ్చును. కానీ ఆ మంట పెద్దదై పొరుగువాడి పొలాన్ని లేక పొరుగువాడి పొలంలో పండుతున్న ధాన్యాన్ని కాల్చివేస్తే, అప్పుడు ఆ మంటను రాజబెట్టిన వ్యక్తి తాను కాల్చివేసిన వాటికి బదులుగా డబ్బు చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ఒకడు తన డబ్బును లేక ఇంకేవైనా వస్తువుల్ని పొరుగువాని ఇంట్లో దాచి పెట్టమని తన పొరుగువాణ్ణి అడగవచ్చు. ఆ పొరుగువాడి ఇంట్లోనుంచి ఆ డబ్బు లేక వస్తువులు దొంగిలించబడితే, నీవేం చేయాలి? దొంగను పట్టుకొనేందుకు నీవు ప్రయత్నం చేయాలి. నీవు ఆ దొంగను పట్టుకొంటే, అప్పుడు వాడు ఆ వస్తువుల విలువకు రెండంతలు చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","కానీ ఆ దొంగను నీవు పట్టుకోలేక పోతే, ఆ ఇంటి యజమాని నేరస్థుడైతే, అప్పుడు దేవుడే న్యాయం తీరుస్తాడు. ఆ ఇంటి యజమాని దేవుని ఎదుటకి వెళ్లాలి. అతడే దొంగిలించి ఉంటే దేవుడు న్యాయం తీరుస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","“పోయిన ఒక ఎద్దు లేక గాడిద, గొర్రె లేక వస్త్రం లేక ఇంక దేన్నిగూర్చిగానీ ఇద్దరు వ్యక్తులకు ఒడంబడిక కుదరకపోతే, అప్పుడు నీవేం చేయాలి? ‘ఇది నాది’ అని ఒకడంటే, లేదు, ‘ఇది నాది’ అని ఇంకొకడు అంటాడు. ఆ ఇద్దరు మనుష్యులు దేవుని ఎదుటికి వెళ్లాలి. నేరస్థుడు ఎవరో దేవుడే నిర్ణయిస్తాడు. తప్పుచేసిన వాడు ఆ వస్తువు విలువకు రెండంతలు అవతలి వానికి చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“తన జంతువు విషయమై శ్రద్ధ పుచ్చుకోవడం ద్వారా తనకు సహాయం చేయమని ఒకడు తన పొరుగు వాణ్ణి అడగవచ్చు. ఈ జంతువు గాడిద కావచ్చు, ఎద్దు కావచ్చు, గొర్రె కావచ్చు. అయితే ఆ జంతువు చనిపోయినా, ఆ జంతువుకు దెబ్బ తగిలినా లేక ఎవరూ చూడకుండా ఆ జంతువును ఇంకెవరైనా తీసుకొనిపోయినా నీవేం చేయాలి? ");
INSERT INTO tel2010_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ఆ జంతువును తాను దొంగిలించలేదని ఆ పొరుగువాడు వివరించి చెప్పాలి. ఇదే కనుక సత్యం అయితే, తాను దొంగతనం చేయలేదని ఆ పొరుగువాడు యెహవాకు ప్రమాణం చేయాలి. జంతువు యజమాని ఈ ప్రమాణాన్ని అంగీకరించాలి. ఆ పొరుగువాడు జంతువుకోసం దాని యజమానికి ఏమీ చెల్లించనక్కర్లేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","అయితే, ఆ పొరుగు వాడు జంతువును దొంగిలిస్తే, అప్పుడు ఆ జంతువు కోసం దాని యజమానికి అతడు విలువ చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ఒకవేళ అడవి మృగాలు ఆ జంతువును చంపేస్తే, ఆ పొరుగువాడు దాని శవాన్ని రుజువుగా తీసుకరావాలి. చంపబడ్డ జంతువు కోసం దాని యజమానికి ఆ పొరుగువాడు ఏమీ చెల్లించనక్కరలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ఒకడు తన పొరుగు వాని దగ్గర దేన్నయినా బదులు తీసుకొంటే దానికి అతడే బాధ్యుడు. ఒకవేళ ఒక జంతువుకు దెబ్బ తగిలినా లేక ఆ జంతువు చచ్చినా, అప్పుడు ఆ పొరుగువాడు దాని యజమానికి వెల చెల్లించాలి. యజమాని స్వయంగా అక్కడ లేడు గనుక ఆ పొరుగువాడే దానికి బాధ్యుడు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","అయితే దాని యజమాని ఆ జంతువుతో కూడా ఉంటే, పొరుగువాడు ఏమీ చెల్లించనక్కరలేదు. లేక, ఆ పొరుగువాడు ఆ జంతువుతో పని చేయించుకొనేందుకుగాను డబ్బు చెల్లిస్తోంటే, ఆ జంతువుకు దెబ్బ తగిలినా, అది చచ్చినా, అతడు ఏమీ చెల్లించనక్కర్లేదు. ఆ జంతువును వాడుకొనేందుకు అతడు చెల్లించిన డబ్బే సరిపోతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“పెళ్లికాని పవిత్రమైన ఒక పడుచుదానితే ఒకవేళ ఒకడికి లైంగిక సంబంధం ఉంటే, అతడు ఆమెను పెళ్లి చేసుకోవాలి. ఆమె తండ్రికి అతడు నిండుగా కట్నం యివ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","అతణ్ణి పెళ్లి చేసుకొనేందుకు ఆమె తండ్రి అంగీకరించకపోయినా, అతడు ఆ డబ్బు చెల్లించాల్సిందే. ఆమె కోసం పూర్తి మొత్తాన్ని అతడు చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“నీవు ఏ స్త్రీనీ కూడా మాయపనులు చెయ్యనివ్వకూడదు. ఒకవేళ ఆమె చేస్తే, అలాంటి దాన్ని నీవు బతకనివ్వకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“నీవు ఎవ్వర్నీ జంతు సంయోగం చెయ్య నియ్యాకూడదు. ఇలా కనుక జరిగితే, ఆ వ్యక్తిని చంపేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ఎవడైనా సరే దేవుడు కాని వాడికి బలి అర్పిస్తే, అలాంటివాడ్ని నాశనం చేయాలి. యెహోవా దేవుడు ఒక్కడికే నీవు బలులు అర్పించాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“జ్ఞాపకం ఉంచుకో ఇదివరకు మీరు ఈజిప్టు దేశంలో పరాయివాళ్లు. కనుక మీ దేశంలో ఉండే విదేశీయులలో ఎవర్నీ మీరు మోసం చేయకూడదు. కొట్టగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“విధవరాండ్రకు, అనాధలకు మీరు ఎన్నడూ ఎట్లాంటి కీడు చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ఆ విధవరాండ్రకు లేక అనాధలకు మీరు ఏదైనా కీడు చేస్తే అది నాకు తెలుస్తుంది. వారి శ్రమను గూర్చి నేను వింటాను. ");
INSERT INTO tel2010_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","అంతేకాదు, నాకు చాల కోపం వస్తుంది. కత్తితో నేను మిమ్మల్ని చంపేస్తాను. అప్పుడు మీ భార్యలు విధవరాండ్రయి పోతారు. మీ పిల్లలు అనాధలు అయిపోతారు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“నా ప్రజల్లో ఒకరు పేదవారైతే, నీవు వానికి డబ్బు అప్పిస్తే, ఆ డబ్బుకు నీవు అతని దగ్గర వడ్డీ తీసుకోకూడదు. ఆ డబ్బు త్వరగా తిరిగి ఇచ్చి వేయమని నీవు అతణ్ణి తొందర చేయకూడదు: ");
INSERT INTO tel2010_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","అతడు నీకు బాకీ ఉన్న డబ్బు నీకు చెల్లిస్తాడని ప్రమాణంగా ఎవరైనా ఒకరు తన అంగీని నీకు ఇవ్వవచ్చును. కాని సూర్యాస్తమయం కాకముందే నీవు ఆ అంగీని తిరిగి ఇచ్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ఒకవేళ ఆ వ్యక్తికి ఆ అంగీ లేకపోతే, తన శరీరాన్ని కప్పుకొనేందుకు అతనికి ఇంకేమీ లేకపోవచ్చును. అతను నిద్రపోయినప్పుడు చల్లబడిపోతాడు. మరి అతడు నాకు మొరబెడితే, అప్పుడు నేను అతని మొర వింటాను. నేను దయగలవాణ్ణి కనుక నేను వింటాను. ");
INSERT INTO tel2010_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“నీ దేవుణ్ణిగాని, నీ ప్రజల నాయకులనుగాని నీవు దూషించగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“కోత కాలంలో నీ మొదటి గింజల్ని, నీ ఫలాల్లో మొదటి రసాన్ని నీవు నాకు ఇవ్వాలి. సంవత్సరాంతం వరకు వేచి ఉండొద్దు. “నీ పెద్దకుమారుల్ని నాకు ఇవ్వు. ");
INSERT INTO tel2010_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","అలాగే నీ ఆవుల్లో, గొర్రెల్లో, మొదట పుట్టిన వాటిని నాకు ఇవ్వు. అవి ఏడు రోజులు వాటి తల్లితో ఉండవచ్చు. ఎనిమిదవ రోజున వాటిని నాకు ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","మీరు నా ప్రత్యేక ప్రజలు. కనుక అడవి మృగాలు చంపిన ఏదో ఒకదాని మాంసం మీరు తినవద్దు. చచ్చిన ఆ జంతువులను కుక్కల్ని తిననివ్వండి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ప్రజలకు వ్యతిరేకంగా అబద్ధాలు చెప్పకండి. న్యాయస్థానంలో మీరు సాక్షులుగా ఉంటే, ఒక దుర్మార్గుడు అబద్ధాలు చెప్పేందుకు సహాయం చేయడానికి ఒప్పుకోవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“మిగిలిన వారంతా చేస్తున్నారనిచెప్పి నువ్వు ఏదీ చేయవద్దు. ఒక గుంపు ప్రజలు తప్పు చేస్తోంటే, నువ్వు వారితో కలువ వద్దు. నువ్వు చెడ్డ పనులు చేసేటట్టు ఆ ప్రజలు నిన్ను ఒప్పించనియ్యవద్దు. సరియైనది, న్యాయమైనది నువ్వు చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","“ఒక పేదవానికి తీర్పు జరుగుతోంటే, కొన్నిసార్లు అతని విషయంలో జాలిపడి, కొందరు అతణ్ణి బలపరుస్తారు. నువ్వు అలా చేయకూడదు. (అతనిది సరిగ్గా ఉంటేనే బలపర్చు.) ");
INSERT INTO tel2010_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“తప్పిపోయిన ఒక ఎద్దును లేక గాడిదను నీవు చూస్తే, దాన్ని దాని యజమానికి నీవు తిరిగి అప్పగించాలి. ఆ యజమాని నీకు శత్రువైనా సరే, నీవు ఇలా చేయాల్సిందే. ");
INSERT INTO tel2010_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","మోయలేనంత భారం ఉండడం చేత ఒక జంతువు నడవలేక పోతున్నట్టు నీవు చూస్తే, నీవు ఆగి ఆ జంతువుకు సహాయం చేయాలి. ఆ జంతువు నీ శత్రువులలో ఒకనికి చెందినా సరే నీవు దానికి సహాయం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ఒక పేదవానికి ప్రజలు అన్యాయం చేయ నివ్వకూడదు నీవు. ఇతరులు ఎవరికైనా తీర్చబడినట్టే తీర్పు తీర్చాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","“ఏదైనా విషయంలో ఒకడు నేరస్థుడు అని నీవు చెబితే, నీవు చాల జాగ్రత్తగా ఉండాలి. ఒకడి మీద అబద్ధపు నిందలు వేయవద్దు. నిర్దోషియైన ఒకడ్ని తాను చేయని పనికి శిక్షగా ఎన్నడూ మరణించనివ్వవద్దు. ఒక నిర్దోషిని చంపేవాడు ఎవడైనా సరే చెడ్డవాడే, ఆ మనిషిని నేను క్షమించను. ");
INSERT INTO tel2010_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“ఒకడు తప్పు చేస్తూ నీవు అతనితో ఏకీభవించాలని చెప్పి, నీకు డబ్బు ఇవ్వ జూస్తే, ఆ డబ్బు తీసుకోవద్దు. అలా చెల్లించిన డబ్బు న్యాయమూర్తులు సత్యాన్ని చూడకుండా చేస్తుంది. అలా చెల్లించిన డబ్బు మంచివాళ్లు అబద్ధాలు చెప్పేటట్టు చేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“విదేశీయుని యెడల నీవు ఎన్నడూ తప్పు చేయకూడదు. మీరు ఈజిప్టు దేశంలో నివసించినప్పుడు మీరు పరాయి వాళ్లేనని జ్ఞాపకం ఉంచుకోవాలి. (ఒకడు తన స్వంతంకాని దేశంలో వుంటే వాడికి ఎలా వుంటుందో మీరు అర్థం చేసుకోవాలి.) ");
INSERT INTO tel2010_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“విత్తనాలు చల్లి పంటకోసి, ఆరు సంవత్సరాల పాటు భూమిని సాగుచేయండి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","అయితే ఏడో సంవత్సరం భూమిని ఉపయోగించకండి. (ఏడో సంవత్సరం భూమికి ఒక ప్రత్యేక విశ్రాంతి సమయంగా ఉండాలి) మీ పొలాల్లో ఏమీ నాటవద్దు. ఒకవేళ అక్కడ ఏవైనా పంటలు పెరిగితే, వాటిని పేద ప్రజలను తీసుకోనివ్వాలి. మిగిలిపోయిన ఆహారాన్ని అడవి మృగాల్ని తిననివ్వాలి మీ ద్రాక్షాతోటలు, ఒలీవ మొక్కలు, తోటల విషయంలో కూడ మీరు అలాగే చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ఆరు రోజులు పని చేయండి. ఏడోరోజున విశ్రాంతి! మీ బానిసలు, ఇతర పని వాళ్లకు దీనివల్ల విశ్రాంతి, మరియు విరామం లభిస్తుంది. మీ ఎడ్లు, మీ గాడిదలకు కూడ విశ్రాంతి దొరుకుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ఈ ఆజ్ఞలన్నింటికీ విధేయులు కావాలని మాత్రం ఖచ్చితంగా తెల్సుకోండి. వేరే దేవుళ్లను పూజించకండి. చివరకి వాళ్ల పేర్లు కూడా మీరు పలుకగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“ప్రతి సంవత్సరం మూడు ప్రత్యేక పండుగలు మీకు ఉంటాయి. ఈ పండుగల రోజుల్లో మీరు నన్ను ఆరాధించటానికి నా ప్రత్యేక స్థలానికి రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","మొదటి పండుగ పులియని రొట్టెల విందు. ఇది నేను మీకు ఆజ్ఞాపించినట్టే ఉంటుంది. ఈ సమయంలో పులియజేసే పదార్థం వినియోగించ కుండా చేయబడ్డ రొట్టెలు మీరు తింటారు. ఇలా ఏడు రోజుల పాటు కొనసాగుతుంది. అబీబు మాసంలో మీరు దీన్ని చేయాలి. ఎందుకంటే మీరు ఈజిప్టు నుండి బయటకు వచ్చిన సమయం యిదే. ఆ సమయంలో ప్రతి వ్యక్తి ఒక బలి అర్పణ నాకు తీసుకురావాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“రెండోది పెంతుకోస్తు పండగ. ఈ పండుగ వేసవి పూర్వార్ధంలో అంటే మీ పొలాల్లో మీరు నాట్లు వేసిన పంటల కోత మొదలుబెట్టే సమయంలో ఉంటుంది. మూడోది ఆశ్రయాల పండగ. “ఇది ఆకురాలు కాలంలో ఉంటుంది. ఇది మీ పొలాల్లో పంటలన్నీ కూర్చుకొనే సమయంలో ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“కనుక యెహోవా ప్రభువుతో ఉండేందుకు సంవత్సరానికి మూడుసార్లు పురుషులంతా ఒక ప్రత్యేక స్థలానికి వస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“నీవు ఒక జంతువును చంపి దాని రక్తం బలిగా అర్పించేటప్పుడు, పులియజేసే పదార్థంతో చేయబడ్డ రొట్టెలు నీవు అర్పించకూడదు. ఈ బలి అర్పణలోని మాంసం మీరు తినేటప్పుడు ఆ మాంసం అంతా ఒక్క రోజులోనే తినెయ్యాలి. మాంసంలో ఏమీ మర్నాటికి మిగల్చకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“మీరు మీ పంట కూర్చుకొనే కోత కాలంలో మీరు కోసే ప్రతి దానిలో మొదటి భాగం మీ యెహోవా దేవుని ఆలయానికి తీసుకురావాలి. “దాని తల్లి పాలతో ఉడకబెట్టబడిన మేకపిల్ల మాంసాన్ని మీరు తినకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","దేవుడు యిలా చెప్పాడు: “మీకు ముందర ఒక దేవదూతను నేను పంపుతున్నాను. మీ కోసం నేను సిద్ధం చేసిన చోటుకి ఈ దేవదూత మిమ్మల్ని నడిపించటం జరుగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ఈ దేవదూతకు విధేయులుగా వెంబడించండి. ఆయన మీద తిరుగుబాటు చేయవద్దు. ఆయన విషయంలో మీరు చేసే తప్పిదాలను ఈ దేవదూత క్షమించడు. ఆయనలో నా శక్తి ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ఆయన చెప్పే ప్రతి దానికీ మీరు లోబడాలి. నేను మీతో చెప్పే ప్రతీదీ మీరు చేయాలి. మీ శత్రువులందరికీ నేను వ్యతిరేకంగా ఉంటాను. మీకు వ్యతిరేకంగా ఉండే ప్రతి వ్యక్తికి నేను విరోధినే.” ");
INSERT INTO tel2010_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","దేవుడు చెప్పాడు: “ఈ దేశంలోనుంచి నా దూత మిమ్మల్ని నడిపిస్తాడు. అమోరీయులు, హిత్తీయులు, పెరిజ్జీయులు, కనానీయులు, హివ్వీయులు, యెబూసీయులు అనే వేర్వేరు ప్రజల మీదికి ఆయన మిమ్మల్ని నడిపిస్తాడు. అయితే వీళ్లందర్నీ నేను ఓడిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","“వాళ్ల దేవుళ్లను పూజించవద్దు. ఆ దేవుళ్లకు ఎన్నడూ సాష్టాంగపడవద్దు. వాళ్ల జీవిత విధానంలో మీరు ఎన్నడూ జీవించకూడదు. వాళ్ల విగ్రహాల్ని మీరు నాశనం చేయాలి. వాళ్ల దేవుళ్లను వాళ్లు జ్ఞాపకం చేసుకొనేందుకు వాళ్లకు తోడ్పడే వాటన్నిటినీ మీరు విరుగగొట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","మీ యెహోవా దేవుణ్ణి మీరు సేవించాలి. మీరు ఇలా చేస్తే, భోజన పానీయాలు సమృద్ధిగా ఇచ్చి నేను మిమ్మల్ని ఆశీర్వదిస్తాను. సర్వరోగాల్నీ మీలోనుండి తొలగించి వేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","మీ స్త్రీలంతా పిల్లల్ని కనగల్గుతారు. వారి శిశువుల్లో ఏ ఒక్కరూ పుట్టుకలో చావరు. మిమ్మల్ని అందరినీ సుదీర్ఘ ఆయుష్షుతో బ్రతకనిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“మీరు మీ శత్రువుతో యుద్ధం చేసేటప్పుడు నా మహత్తర శక్తిని మీ ముందర పంపిస్తాను. మీరు మీ శత్రువులందర్నీ ఓడించటానికి నేను మీకు సహాయం చేస్తాను. మీకు వ్యతిరేకంగా ఉండే మనుష్యులు యుద్ధంలో కలవరపడిపోయి, పారిపోతారు. ");
INSERT INTO tel2010_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","మీకు ముందు కందిరీగలను నేను పంపిస్తాను. ఆ కందిరీగలు మీ శత్రువులు పారిపొయ్యేట్టు చేస్తాయి. హివ్వీ ప్రజలు, కనానీ ప్రజలు, హిత్తీ ప్రజలు, మీ దేశాన్ని వదిలేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","అయితే త్వరగా మీ దేశాన్ని విడిచి పెట్టేటట్టు నేను వాళ్లను బలవంతం చేయను. ఇదంతా నేను ఒక్క సంవత్సరంలోనే చేయను. ఆ ప్రజల్ని నేను అంత వేగంగా వెళ్లగొడితే, దేశం ఖాళీగా ఉంటుంది. అలాగైతే అడవి మృగాలు అధికమై దేశాన్ని ఆక్రమించుకొంటాయి. అవి మీకు చాల తొందర కలిగిస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","కనుక ఆ ప్రజల్ని చాలా నిదానంగా బయటకు వెళ్లగొడతాను. దేశంలోనికి మీరు చొచ్చుకు పోతూనే ఉంటారు. మరి మీరు ఎక్కడికి వెళ్లినా, అక్కడ ఇతర ప్రజలను నేను బలవంతంగా వెళ్లగొట్టేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“ఎర్ర సముద్రం నుండి యూఫ్రటీస్ నదివరకు ఉన్న దేశం అంతా నేను మీకు యిస్తాను. ఫిలిష్తీ సముద్రం (మధ్యధరా సముద్రం) పశ్చిమాన సరిహద్దుగాను, అరేబియా ఎడారి తూర్పు సరిహద్దుగాను ఉంటాయి. అక్కడ నివసిస్తున్న ప్రజల్ని మీరు ఓడించేటట్టు చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","“ఆ ప్రజల్లో ఎవరితో గాని లేక వారి దేవుళ్లతోగాని మీరు ఎలాంటి ఒడంబడికలూ చేసుకోకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","వాళ్లను మీ దేశంలో ఉండనివ్వవద్దు. మీరు వాళ్లను ఉండనిస్తే, మీరు పాపం చేయటానికి వాళ్లు కారకులు అవుతారు. ఒకవేళ మీరు వాళ్లను ఉండనిస్తే వాళ్లు ఒక ఉరిలా ఉంటారు. మీరేమో వాళ్ల దేవుళ్లను పూజించటం మొదలు పెడతారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","మోషేతో దేవుడు ఇలా చెప్పాడు: “నీవు, అహరోను, నాదాబు, అబీహు, ఇశ్రాయేలీయుల డెబ్బయి మంది పెద్దలు (నాయకులు) పర్వతం మీదకు వచ్చి అంత దూరంలోనుంచే నన్ను ఆరాధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","అప్పుడు మోషే తాను మాత్రం యెహోవాకు సమీపంగా రావాలి. మిగతా పురుషులు యెహోవాకు సమీపంగా రాకూడదు. మిగతా ప్రజలు పర్వతం మీదకి కూడా రాకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","కనుక యెహోవా ఇచ్చిన నియమాలు, ఆజ్ఞలు అన్నింటిని గూర్చీ మోషే ప్రజలతో చెప్పాడు. అప్పుడు ప్రజలంతా, “యెహోవా చెప్పిన ఆజ్ఞలు అన్నింటికీ మేము విధేయులమవుతాము” అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","కనుక యెహోవా ఆజ్ఞలు అన్నింటినీ మోషే రాసాడు. మర్నాటి ఉదయం పర్వతం దగ్గర మోషే ఒక బలిపీఠం నిర్మించాడు. ఇశ్రాయేలీయుల పన్నెండు వంశాల్లో ఒక్కోదానికి ఒకటి చొప్పున పన్నెండు రాళ్లు నిలబెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","అప్పుడు బలులు అర్పించటానికి యువకులను మోషే పంపించాడు. దహన బలులుగా, సమాధాన బలులుగా ఎడ్లను ఈ మనుష్యులు అర్పించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ఈ జంతువుల రక్తాన్ని మోషే భధ్రం చేసాడు. రక్తంలో సగాన్ని పాత్రల్లో ఉంచాడు మోషే. మిగతా సగం రక్తాన్ని బలిపీఠం మీద ఆయన పోసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","ప్రత్యేక ఒడంబడిక రాయబడ్డ పత్రాన్ని మోషే చదివాడు. ఆయన చదువుతోంది ప్రజలంతా వినగలిగేటట్టు మోషే ఆ ఒడంబడిక పత్రం చదివాడు. అప్పుడు ప్రజలు, “యెహోవా మాకు ఇచ్చిన ఆజ్ఞలన్నీ మేము విన్నాము. వాటికి విధేయులం అయ్యేందుకు మేము ఒప్పుకొంటున్నాము” అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","తర్వాత బలి అర్పణ రక్తంతో నిండిన పాత్రలను మోషే పట్టుకొన్నాడు. ఆ రక్తాన్ని ప్రజలమీద మోషే చిలకరించాడు “మీతో యెహోవా ఒక ప్రత్యేక ఒడంబడిక చేసాడు అని ఈ రక్తం సూచిస్తుంది. మీకు దేవుడు ఇచ్చిన ఆజ్ఞలే ఈ ఒడంబడికను వివరిస్తాయి,” అని ఆయన చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","అప్పుడు మోషే, అహరోను, నాదాబు, అబీహు, ఇశ్రాయేలు పెద్దలు డెబ్బయి మంది పర్వతం మీదకు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","పర్వతం మీద ఈ మనుష్యులు ఇశ్రాయేలీయుల దేవుణ్ణి చూసారు. ఆకాశం అంత నిర్మలంగా కనబడుతున్న నీలంలాటి దేనిమీదనో దేవుడు నిలబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ఇశ్రాయేలు నాయకులంతా దేవుణ్ణి చూచారు, కాని దేవుడు వాళ్లను నాశనం చేయలేదు. వాళ్లంతా కలిసి తిని తాగారు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","“పర్వతం మీద నా దగ్గరకు రా, నా ప్రబోధాలను, ఆజ్ఞలను పలకలుగా ఉన్న రెండు రాళ్ల మీద రాసాను. ఈ ప్రబోధాలు ప్రజలకోసం. ఆ రాతి పలకలను నేను నీకిస్తాను” అని యెహోవా మోషేతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","కనుక మోషే, ఆయన సహాయకుడైన యెహోషువ కలసి దేవుని పర్వతం మీదకు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","మోషే, “మాకోసం ఇక్కడ వేచి ఉండండి. మేము తిరిగి మీ దగ్గరకు వస్తాము. నేను లేనప్పుడు అహరోను, హోరు మీ దగ్గరే ఉన్నారు. ఎవరికైనా సమస్య ఉంటే వాళ్ల దగ్గరకు వెళ్లండి,” అని ఆ పెద్దలతో (నాయకులతో) చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","అప్పుడు మోషే పర్వతం మీదికి వెళ్లాడు. ఆ పర్వతాన్ని మేఘం కప్పేసింది. ");
INSERT INTO tel2010_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","సీనాయి పర్వతం మీద యెహోవా మహిమ దిగివచ్చింది. ఆరు రోజుల పాటు పర్వతాన్ని మేఘం కప్పేసింది. ఏడోరోజున ఆ మేఘంలోనుంచి యెహోవా మోషేతో మాట్లాడాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ఇశ్రాయేలు ప్రజలు యెహవా మహిమను చూడగలిగారు. అది ఆ పర్వతం మీద మండుతున్న అగ్నిలా వుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","అప్పుడు మోషే ఆ పర్వతం మీద యింకా పైకి ఎక్కి మేఘంలోకి వెళ్లాడు. నలభై పగళ్లూ, నలభై రాత్రులు మోషే ఆ పర్వతం మీదే ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“నాకు కానుకలు తీసుకు రమ్మని ఇశ్రాయేలు ప్రజలతో చెప్పు. నాకు ఇవ్వాల్సింది ఏమిటి? ప్రతి మనిషి తన హృదయంలో తీర్మానించుకోవాలి. నా కోసం ఈ కానుకల్ని స్వీకరించు. ");
INSERT INTO tel2010_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","ప్రజల దగ్గర్నుండి నీవు స్వీకరించాల్సిన వాటి జాబితా యిది: బంగారం, వెండి, కంచు, ");
INSERT INTO tel2010_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","నీలం వస్త్రం, ఊదారంగు వస్త్రం, ఎరుపు వస్త్రం, మేలిమి వస్త్రం, మేక బొచ్చు, ");
INSERT INTO tel2010_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","గొర్రె చర్మాలు, మేలురకం తోళ్లు, తుమ్మకర్ర ");
INSERT INTO tel2010_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","దీపాలకు నూనె, ధూపం. ప్రత్యేక అభిషేక తైలానికి సువాసన చేకూర్చే పరిమళ వస్తువులు, ");
INSERT INTO tel2010_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ఇంకా లేత పచ్చరాళ్లు, ఏఫోదు మీద లేక న్యాయ తీర్పుపై వస్త్రం మీద పొదిగించడానికి విలువైన రాళ్లు.” ");
INSERT INTO tel2010_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","(ఇంకా దేవుడు ఇలా అన్నాడు): “నా కోసం ప్రజలు ఒక పవిత్ర స్థలాన్ని నిర్మిస్తారు. అప్పుడు నేను వారి మధ్య నివసిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","పవిత్ర గుడారం ఎలా ఉండాలో నేను మీకు చూపిస్తాను. దానిలో ఏమేమి వస్తువులు ఎలా ఉండాలో నేను మీకు చూపిస్తాను. సరిగ్గా నేను నీకు చూపించినట్టు ఒడంబడిక పెట్టె తయారు చెయ్యి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“తుమ్మకర్ర ఉపయోగించి ఒక ప్రత్యేక పెట్టె తయారు చెయ్యి. ఈ పెట్టె పొడవు 45 అంగుళాల వెడల్పు 27 అంగుళాలు ఎత్తు 27 అంగుళాలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ఆ పెట్టెలోపల, బంగారు రేకుతో పెట్టెను కప్పాలి. ఆ పెట్టె చుట్టూ అంచుల మీద బంగారపు నగిషీబద్ద పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ఆ పెట్టె చుట్టూ మోసేందుకు నాలుగు బంగారు ఉంగరాలను తయారు చెయ్యాలి. ఆ పెట్టెకు ఒక్కోపక్క రెండేసి చొప్పున నాలుగు మూలలా ఆ ఉంగరాలను అమర్చాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","తర్వాత పెట్టెను మోసేందుకు కర్రలను తయారు చేయాలి. ఈ కర్రలను తుమ్మకర్రతో చేసి వాటికి బంగారం పొదిగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ఆ పెట్టె మూలల్లో ఉన్న ఉంగరాల గుండా ఆ కర్రలను పెట్టాలి. ఆ పెట్టెను మోసేందుకు ఈ కర్రలను ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ఈ కర్రలు ఎప్పుడూ వాటి ఉంగరాల్లోనే ఉండాలి. కర్రలను బయటికి తియ్యవద్దు.” ");
INSERT INTO tel2010_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","దేవుడు అన్నాడు: “నేను ఒడంబడికను నీకు ఇస్తాను. ఆ ఒడంబడికను ఈ పెట్టెలో పెట్టు. ");
INSERT INTO tel2010_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","ఆ పెట్టెకు ఒక మూత చెయ్యాలి. స్వచ్ఛమైన బంగారంతో దీన్ని చెయ్యాలి. 45 అంగుళాల పొడవు 27 అంగుళాల వెడల్పుతో దీన్ని చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","తర్వాత రెండు బంగారు కెరూబు దూతలను చేసి ఆ మూతకు రెండుకొనల మీద పెట్టాలి. కొట్టిన బంగారంతో ఈ దూతల్ని చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ఆ మూతకు ఒక కొనమీద ఒక దూతను, మరో కొనమీద మరో దూతను ఉంచాలి. మూత, దూతలు అంతా ఒకే వస్తువుగా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","కెరూబులు ఒకదానికి ఎదురుగా ఇంకొకటి ఉండాలి. ఆ దూతల ముఖాలు మూత వైపుకు చూస్తూ ఉండాలి. ఆ కెరూబుల రెక్కలు మూతను అవరించి ఉండాలి. ఆ కెరూబుల రెక్కలు ఆకాశం వైపు ఎత్తబడి ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","“ఒడంబడిక రుజువు నేనే మీకిచ్చాను. ఆ ఒడంబడికను పెట్టెలో పెట్టి, ప్రత్యేక మూతను పెట్టెమీద పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","నేను నిన్ను కలుసుకొనేటప్పుడు ఆ ఒడంబడిక పెట్టె ప్రత్యేక మూత మీద ఉన్న కెరూబు దూతల మధ్యనుండి నేను మాట్లాడుతాను. అక్కడినుండే నేను నా ఆజ్ఞలన్నింటినీ ఇశ్రాయేలు ప్రజలకు యిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“తుమ్మ కర్రతో ఒక బల్ల తయారు చెయ్యాలి. ఈ బల్ల పొడవు 36 అంగుళాలు వెడల్పు 18 అంగుళాలు ఎత్తు 27 అంగుళాలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","బల్లను స్వచ్ఛమైన బంగారంతో కప్పాలి. దాని చుట్టూ బంగారపు నగిషీబద్ద పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","తర్వాత 4 అంగుళాల, బంగారు నగీషీ బద్దను బల్ల చుట్టూ చేయాలి. ఇది కూడ స్వచ్ఛమైన బంగారంతో చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","అప్పుడు నాలుగు బంగారు ఉంగరాలు చేసి, బల్ల నాలుగు మూలలా వాటిని ఉంచాలి. ఒక్కో కాలు దగ్గర ఒక్కో ఉంగరం పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","బల్ల పై భాగానికి చుట్టూవున్న నగిషీ బద్దకు సమీపంగా ఉంగరాలను ఉంచాలి. బల్లను మోసే మోత కర్రలను ఈ ఉంగరాలు పట్టి ఉంచుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","మోత కర్రలు చేసేందుకు తుమ్మ కర్రను ఉపయోగించి వాటికి బంగారంతో తాపడం చేయాలి. వాటితో బల్లను మోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","బల్లమీద ఉండే ప్రతి పళ్లెము, గిన్నె స్వచ్ఛమైన బంగారంతో చేయబడాలి. అర్పితాలను పోసేందుకు ఉపయోగించే పాత్రలు, గిన్నెలు స్వచ్ఛమైన బంగారంతో చెయ్యబడి ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ప్రత్యేకమైన రొట్టెను నా యెదుట బల్ల మీద పెట్టాలి. అవి నా యెదుట ఎల్లప్పుడూ అక్కడ ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“అప్పుడు నీవు ఒక దీపస్తంభం చేయాలి. దీపస్తంభంలో ప్రతి భాగాన్నీ సాగకొట్టబడ్డ స్వచ్ఛమైన బంగారంతో చేయాలి. అందంగా కనబడేటట్టు దీపానికి పూలు చేయాలి. ఈ పూలలో మొగ్గలు, రేకులు స్వచ్ఛమైన బంగారంతో చేయాలి. ఇవన్నీ దీప స్తంభంతోపాటు ఒకే వస్తువుగా కలిసి ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","“దీపస్తంభానికి ఒక పక్క మూడు కొమ్మలు మరో పక్క మూడు కొమ్మలు మొత్తం ఆరు కొమ్మలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ఒక్కో కొమ్మకు మూడు పువ్వులు ఉండాలి. ఈ పువ్వులను మొగ్గలు, రేకులుగల బాదం పూలుగా చేయి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","దీప స్తంభానికి మరో నాలుగు పూలు చేయి మొగ్గులు, రేకులుగల బాదం పూవుల్లా చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","కాండమునకు ఇరు ప్రక్కల మూడేసి కొమ్మల చొప్పున దీపస్తంభానికి ఆరు కొమ్మలు ఉండాలి. కొమ్మలు కాండంలో కలిసే మూడు చోట్లలో ఒక్కో దాని కింద మొగ్గలు, రేకులు గల ఒక పువ్వును చేయి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","పువ్వులు కొమ్మలతో సహా మొత్తం దీపస్తంభం స్వచ్ఛమైన బంగారంతో చేయబడాలి. ఈ బంగారం అంతా సాగకొట్టబడిన ఒకే ముక్కగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","అప్పుడు దీపస్తంభం మీదకు ఏడు దీపాలు చేయి. ఈ దీపాలు దీపస్తంభం ఉన్న చోట వెలుగునిస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ప్రమిదలు, దీపపు వత్తులను తిప్పే పిడి చేసేందుకు స్వచ్ఛమైన బంగారం ఉపయోగించు. ");
INSERT INTO tel2010_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","దీపస్తంభం, దానితోబాటు ఉపయోగించే వస్తువులను చేసేందుకు 75 పౌన్ల స్వచ్ఛమైన బంగారం ఉపయోగించు. ");
INSERT INTO tel2010_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","ప్రతీది సరిగ్గా నేను నీకు ఆ పర్వతం మీద చూపించిన ప్రకారమే చేసేందుకు చాల జాగ్రత్తపడు. ");
INSERT INTO tel2010_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“పది తెరలతో పవిత్ర గుడారం చెయ్యాలి. సున్నితమైన బట్ట, నీలం, ఎరుపు, ఊదా రంగుల బట్టతో ఈ తెరలు చేయాలి. రెక్కలుగల కెరూబుల చిత్ర పటాలను ఒక నిపుణుడు తెరలమీద కుట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","తెరలన్నీ ఒకే కొలతలో తయారు చేయాలి. ప్రతి తెరా 14 గజాల పొడవు 2 గజాల వెడల్పు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","తెరలను రెండు భాగాలుగా కుట్టాలి. అయిదు తెరలను ఒక విభాగానికి, అయిదు తెరలను మరో విభాగానికి కలిపి కుట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","చివరి తెర అంచుకు ఉంగరాలు కుట్టాలి. ఈ ఉంగరాలు చేసేందుకు నీలము గుడ్డ ఉపయోగించాలి. తెరల రెండు విభాగాల కింది అంచులకు ఉంగరాలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","మొదటి విభాగంలోని చివరి తెరకు 50 ఉంగరాలు, రెండో విభాగంలోని చివరి తెరకు 50 ఉంగరాలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","ఈ ఉంగరాలను జత చేయటానికి 50 బంగారు ఉంగరాలు చెయ్యాలి. పవిత్ర గుడారం అంతా ఒక్కటిగా ఉండటానికి ఇది తెరలన్నింటినీ జత చేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“తర్వాత పవిత్ర గుడారాన్ని కప్పేందుకు ఇంకో గుడారాన్ని నీవు చెయ్యాలి. ఈ గుడారం చేయటానికి మేక వెంట్రుకలతో చేయబడ్డ 11 తెరలను ఉపయోగించు. ");
INSERT INTO tel2010_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ఈ తెరలన్నీ ఒకే కొలతలో ఉండాలి. అవి 15 గజాలు పొడవు, 2 గజాలు వెడల్పు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","అయిదు తెరలను ఒక విభాగంగా కలిపి కుట్టాలి. తర్వాత మిగిలిన ఆరు తెరలను మరో విభాగంగా కలిపి కుట్టాలి. ఆరో తెరను గుడారం ముందటి భాగాన్ని కప్పేందుకు ఉపయోగించాలి. తలుపులా తెరచుకొనేందుకు వీలుగా దీన్ని చుట్టిపెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ఒక భాగంలోని చివరి తెర అంచుకు 50 కొలుకులు తయారు చెయ్యాలి. మరో విభాగంలోని చివరి తెర కింది అంచుకు కూడ అలానే చెయ్యాలి. మరో విభాగంలోని చివరి తెర కింది అంచుకు కూడ అలానే చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","అప్పుడు 50 ఇత్తడి ఉంగరాలు చెయ్యాలి. గుడ్డ ఉంగరాలను జతచేయటానికి ఈ ఇత్తడి ఉంగరాలను ఉపయోగించాలి. ఇలా చేయడంవల్ల తెరలన్నీ కలిసి ఒకే గుడారంగా తయారువుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ఈ తెరలు పవిత్ర గుడారం కంటె పొడవుగా ఉంటాయి. కనుక తెరల్లో కొంత భాగం గుడారం వెనుకగా వేలాడుతుంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","తెర గుడారం ప్రక్కల్లో వేలాడుతుంటుంది. ఇది గుడారాన్ని భద్రంగా ఉంచుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","పవిత్ర గుడారానికి ఇంకా రెండు పైకప్పులు చేయాలి. ఒకటి ఎర్ర రంగు పూసిన పొట్టేలు చర్మంతో చేయాలి. ఇంకొకటి మేలు రకం తోలుతో చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“పవిత్ర గుడారం చట్రానికి ఉపయోగించే పలకలను తుమ్మకర్రతో చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","చట్రాలు 15 అంగుళాల పొడవు, 27 అంగుళాల వెడల్పు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ప్రతి చట్రం ఒకేలా ఉండాలి. ప్రతి చట్రానికి పక్క పక్కగా రెండేసి పక్కకర్రలు (దిమ్మలో అమర్చేవి) ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","పవిత్ర గుడారం దక్షిణ పక్కకు 20 చట్రాలు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ప్రతి చట్రం కింద పెట్టడానికి రెండేసి వెండిదిమ్మలు చేయాలి. కనుక చట్రాలన్నింటికీ 40 వెండిదిమ్మలు నీవు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","పవిత్ర గుడారం ఉత్తరదిక్కుకోసం ఇంకా 20 చట్రాలు చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","అంటే ఒక్కో చట్రానికి రెండేసి చొప్పున చట్రాలకోసం మొత్తం 40 వెండి దిమ్మలు చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","గుడారం వెనుక పశ్చిమ కొనకు ఇంకా ఆరు చట్రాలు నీవు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","మూలల కోసం రెండు చట్రాలు చెయ్యాలి ");
INSERT INTO tel2010_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","మూలల్లో ఉండే రెండు చట్రాలు జత చేయాలి. రెండుచట్రాలు అడుగు భాగాన జతపర్చబడాలి. పైభాగంలో ఉన్న ఒక ఉంగరం రెండు చట్రాలను జత పరుస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","కనుక (గుడారం చివరన) మొత్తం ఎనిమిది చట్రాలు ఉంటాయి. ఒక్కో చట్రం కింద రెండు దిమ్మల చొప్పున మొత్తం 16 వెండి దిమ్మలుంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“పవిత్ర గుడారం చట్రాలకు తుమ్మ కర్రతో అడ్డకమ్ములు చేయాలి. పవిత్ర గుడారం మొదటి ప్రక్కకు అయిదు అడ్డకమ్ములు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","పవిత్ర గుడారం పశ్చిమాన వెనుకవైపు చట్రానికి అయిదు అడ్డకమ్ములు ఉండాలి. పవిత్ర గుడారం పశ్చిమ దిక్కున చట్రానికి అయిదు అడ్డకమ్ములు ఉండాలి. (అంటే పవిత్ర గుడారం వెనుక) ");
INSERT INTO tel2010_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","అయిదు చట్రాలకు మధ్య ఉండే అడ్డకమ్మి పైనుండి కిందికి సగం సగంగా ఉండాలి. ఈ కొననుండి ఆకొన వరకు చట్రాల గుండా ఈ అడ్డకమ్మి దూర్చబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","చట్రాలను బంగారంతో తాపడం చేయాలి. అడ్డకమ్ములను పట్టి ఉంచడానికి చట్రాలకు ఉంగరాలు చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","నేను నీకు పర్వతం మీద చూపించినట్టే, పవిత్ర గుడారం నిర్మించు. ");
INSERT INTO tel2010_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“సున్నితమైన వస్త్రంతో గుడారం లోపలి భాగం కోసం ప్రత్యేకమైన ఒక తెరను తయారు చెయ్యాలి. నీలం, ఊదా, ఎరుపు రంగు బట్టతో ఈ తెరను తయారు చేయాలి. కెరూబుల చిత్రపటాలను ఈ బట్టమీద కుట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","తుమ్మ కర్రతో నాలుగు స్తంభాలు చెయ్యి. బంగారు కొక్కేల ఆ నాలుగు స్తంభాలకు అమర్చు. స్తంభాలకు బంగారు తాపడం చెయ్యి. స్తంభాల కింద నాలుగు వెండి దిమ్మలు పెట్టు. తర్వాత తెరను బంగారు కొక్కేల మీద వ్రేలాడదీయి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","కొక్కేల మీద తెరను వేలాడ దీసిన తరువాత, ఒడంబడిక పెట్టెను తెర వెనుక పెట్టు. పవిత్ర స్థానాన్ని, మహా పవిత్ర స్థానాన్ని, ఈ తెర వేరుచేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","మహా పవిత్ర స్థానంలో ఒడంబడిక పెట్టె మీద మూత పెట్టు. ");
INSERT INTO tel2010_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","“పవిత్ర స్థానంలో నీవు చేసిన బల్లను తెర అవతలి ప్రక్క పెట్టు. పవిత్ర గుడారంలో ఉత్తరంగా బల్ల ఉండాలి. పవిత్ర గుడారంలో దక్షిణంగా దీపం ఉండాలి. ఇది బల్ల ప్రక్క అడ్డంగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“తర్వాత గుడారం ద్వారానికి ఒక తెర చెయ్యి. తెర చేయటానికి నీలం, ఊదా, ఎరుపు బట్టను సున్నితమైన బట్టను ఉపయోగించు. ఆ బట్టలో చిత్రపటాలను అల్లిక చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","తలుపుపై ఉండే తెరకు బంగారు కొక్కేలు చేయాలి. బంగారు తాపడం చేయబడ్డ అయిదు తుమ్మకర్ర స్తంభాలు చెయ్యాలి. అయిదు స్తంభాలకూ అయిదు ఇత్తడిదిమ్మలు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“తుమ్మకర్రతో ఒక బలిపీఠం నిర్మించు. బలిపీఠం చతురస్రంగా ఉండాలి. అది 7 1/2 అంగుళాల పొడవు 7 1/2 అంగుళాల వెడల్పు 4 1/2 అంగుళాల ఎత్తు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","బలిపీఠం నలుమూలలా ఒక్కోదానికి ఒక్కో కొమ్మ చేయాలి. అంతా ఒక్క వస్తువుగా ఉండేటట్టు ఒక్కో కొమ్మును దాని మూలకు జత చేయాలి. బలిపీఠాన్ని యిత్తడితో తాపడం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","“బలిపీఠం మీద ఉపయోగించబడే పరికరాలు, పాత్రలు అన్నింటినీ ఇత్తడితో చేయాలి. బిందెలు, పారలు, పాత్రలు, పళ్లపారలు, నిప్పునెత్తే పెంకులు ఇత్తడితో చేయాలి. బలిపీఠం నుండి బూడిద ఎత్తి శుభ్రం చేయడానికి యివి ఉపయోగించబడతాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ఒక పెద్ద యిత్తడి జల్లెడలాంటి దానిని చేయాలి. తెర నాలుగు మూలలకు నాలుగు యిత్తడి ఉంగరాలు చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","బలిపీఠానికి అడుగున మెట్టు కింద తెరను పెట్టాలి. కింద నుండి బలిపీఠంలో సగం పై వరకు, తెర ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","“బలిపీఠపు కర్రలు చేయడానికి తుమ్మకర్ర ఉపయోగించి వాటిని ఇత్తడితో తాపడం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","బలిపీఠం రెండు వైపులా ఉండే ఉంగరాల్లోనుంచి ఆ కర్రలను దూర్చాలి. బలిపీఠం మోయడానికి ఈ కర్రలను ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","బలిపీఠం గుల్లగా ఉంటుంది. దాని ప్రక్కలు పలకలతో చేయబడతాయి. నేను నీకు పర్వతం మీద చూపించినట్టే బలిపీఠాన్ని తయారు చెయ్యి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","(“పవిత్ర గుడారం చుట్టూ తెరలతో గోడకట్టు ఇది గుడారానికి ఆవరణ అవుతుంది.) దక్షిణం వైపున యాభై గజాల పొడవు తెరల గోడ ఉండాలి. సున్నితమైన బట్టతో ఈ తెరలు చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ఇరవై స్తంభాలు, ఆ స్తంభాల కింద 20 యిత్తడి దిమ్మలు ఉపయోగించాలి. స్తంభాల కొక్కేల తెరల కడ్డీలు వెండితో చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","దక్షిణ వైపున ఉన్నంత పొడవే ఉత్తరం వైపున కూడా ఉండాలి. దానికి 100 తెరలు, 20 స్తంభాలు, 20 ఇత్తడి దిమ్మలు ఉండాలి. స్తంభాల కొక్కేలు తెరల కడ్డీలు వెండితోనే చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“ఆవరణం పడమటికొనవైపు 25 గజాల పొడవుగల తెరలతో ఒక గోడ ఉండాలి. ఆ గోడ మీద 10 స్తంభాలు, 10 దిమ్మలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ఆవరణ తూర్పు వైపు కూడా 25 గజాల పొడవు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","(ఈ తూర్పు వైపే ఆవరణకు ప్రవేశం) ప్రవేశ ద్వారానికి అన్ని వైపులా ఏడున్నర గజాల పొడవు గల తెరలు ఉండాలి. ఆ పక్క మూడు స్తంభాలు మూడు దిమ్మలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","అవతల వైపున కూడా ఏడున్నర గజాల పొడవుగల తెరలు ఉండాలి. ఆ పక్కన మూడు స్తంభాలు మూడు దిమ్మలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“ఆవరణ ప్రవేశాన్ని కప్పడానికి 10 అంగుళాల పొడవుగల తెర చెయ్యాలి. సున్నితమైన బట్ట నీలం, ఎరుపు, ఊదారంగు బట్టలతో ఆ తెరను చేయాలి. ఆ తెరమీద చిత్ర పటాల అల్లిక ఉండాలి. నాలుగు స్తంభాలు, నాలుగు దిమ్మలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ఆవరణ చుట్టూ ఉండే స్తంభాలన్నీ వెండి కడ్డీలతో జత కలపాలి. స్తంభాల కొక్కేలు వెండితోను, స్తంభాల దిమ్మలు యిత్తడితోను చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ఆవరణ 50 గజాల పొడవు 25 గజాల వెడల్పు ఉండాలి. ఆవరణ చుట్టు గోడ ఏడున్నర అడుగుల ఎత్తు ఉండాలి. తెరలు సున్నితమైన బట్టతో చేయాలి. స్తంభాలన్నింటి కింద ఉండే దిమ్మల్ని ఇత్తడితోనే చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","అన్ని పరికరాలు, పవిత్ర గుడారం మేకులు పవిత్ర గుడారంలో ఉపయోగించే ఇతర వస్తువులు అన్నిటినీ ఇత్తడితోనే చేయాలి. మేకులు (ఆవరణ చుట్టూ తెరలకు) అన్నీ ఇత్తడితో చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“శ్రేష్ఠమైన ఒలీవ నూనె తీసుకొని రమ్మని ఇశ్రాయేలు ప్రజలకు ఆజ్ఞాపించు. ప్రతి సాయంకాలం వెలిగించాల్సిన దీపం కోసం ఈ నూనె ఉపయోగించు. ");
INSERT INTO tel2010_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","దీపం విషయం అహరోను, అతని కుమారులు శ్రద్ధ వహించాల్సి ఉంటుంది. సన్నిధి గుడారంలో మొదటి గదిలోకి వారు వెళ్తారు. ఇది ఒడంబడిక పెట్టె ఉండే గది బయట (రెండు గదులను వేరు పరచే) తెర ముందర ఉంటుంది. ఇక్కడ సాయంత్రం నుండి తెల్లవారే వరకు యెహోవా ఎదుట దీపాలు తప్పక వెలుగుతూ ఉండేటట్టు వారు బాధ్యత వహిస్తారు. ఇశ్రాయేలు ప్రజలు, వారి వారసులు శాశ్వతంగా ఈ ఆజ్ఞకు విధేయులు కావాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“నీ సోదరుడైన అహరోను, అతని కుమారులు నాదాబు, అబీహు, ఎలియాజరు, ఈతామారు, ఇశ్రాయేలు ప్రజల్లోనుంచి, నీ దగ్గరకు రావాలని చెప్పు. వీళ్లు యాజకులుగా నన్ను సేవిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","“నీ సోదరుడైన అహరోనుకు ప్రత్యేక వస్త్రాలు చేయించు. ఈ వస్త్రాలు అతనికి గౌరవ మర్యాదలు కల్గిస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","ఈ బట్టలు తయారుచేయగల నిపుణులు ప్రజల్లో ఉన్నారు. ఈ మనుష్యులకు ప్రత్యేక జ్ఞానం నేనిచ్చాను. అహరోనుకు బట్టలు తయారు చేయుమని వారికి చెప్పు. అతను ఒక ప్రత్యేక విధానంలో నన్ను సేవిస్తున్నాడని ఈ బట్టలు చూపెడ్తాయి. అప్పుడు ఒక యాజకునిగా అతడు నన్ను సేవించవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ఆ మనుష్యులు చేయాల్సిన బట్టలు ఇవే: న్యాయతీర్పు వస్త్రం ఏఫోదు, చేతుల్లేని ఒక ప్రత్యేక అంగీ, తల కప్పుకొనే బట్ట, ఒక నడికట్టు పట్టి నీ సోదరుడైన అహరోనుకు, అతని కుమారులకోసం ఆ మనుష్యులు ఈ ప్రత్యేక దుస్తులను తయారు చేయాలి. అప్పుడు అహరోను, అతని కుమారులు యాజకులుగా నన్ను సేవించవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","బంగారు దారాలు, సున్నితమైన బట్ట, నీలం, ఎరుపు, ఊదా రంగుల బట్టలను ఉపయోగించాలని ఆ మనుష్యులకు చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ఏఫోదు తయారు చేయటానికి బంగారు దారాలు, సన్నని పేనిన నార బట్ట సున్నితమైన బట్ట, నీలం, ఎరుపు, ఊదా రంగుల నూలు ఉపయోగించాలి. నైపుణ్యం గల పనివారు ఈ ఏఫోదు చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ఏఫోదు భుజాల దగ్గర ఒక్కో దాని దగ్గర ఒక్కో భుజం బట్ట వేయబడుతుంది. ఏఫోదు రెండుకొనలు ఈ భుజం బట్టలకు కట్టబడతాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","“ఏఫోదు మీద వేసుకొనే కండువాను వారు చాల జాగ్రత్తగా వేస్తారు. ఏఫోదులో ఉండేవాటితోనే బంగారు దారాలు, సున్నితమైన బట్ట, నీలం, ఎరుపు, ఊదా రంగు బట్టతోనే ఈ కండువా తయారు చేయబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“నీవు రెండు లేతపచ్చ రాళ్లు తీసుకోవాలి. ఇశ్రాయేలు పండ్రెండు మంది కుమారుల పేర్లు ఈ రత్నాల మీద చెక్కాలి ");
INSERT INTO tel2010_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ఒక రత్నం మీద ఆరు పేర్లు, మరో రత్నం మీద ఆరు పేర్లు రాయాలి. పెద్ద కుమారుడు మొదలుకొని చిన్న కుమారుని వరకు క్రమపద్ధతిలో పేర్లు చెక్కు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","ముద్రలు చేసేవాడు ఎలాగైతే చెక్కుతాడో, అలా ఇశ్రాయేలు కుమారుల పేర్లను ఈ రాళ్ల మీద చెక్కు. ఈ రత్నాలను బంగారంలో పొదుగు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","అప్పుడు ఏఫోదు మీద ఉండే ఒక్కో భుజం బట్ట మీద ఒక్కో రత్నాన్ని అమర్చు. అహరోను యెహోవా ఎదుట నిలబడ్డప్పుడు ప్రత్యేకమైన ఈ అంగీ ధరిస్తాడు. ఇశ్రాయేలు కుమారుల పేర్లు చెక్కబడ్డ రెండు రాళ్లు ఏఫోదు మీద ఉంటాయి. ఇశ్రాయేలు ప్రజల్ని గూర్చి తలంచేందుకు ఇది దేవునికి సహాయ పడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","ఏఫోదు మీద రాళ్లు నిలబడి ఉండేటట్టు మంచి బంగారం ఉపయోగించు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","స్వచ్ఛమైన బంగారు గొలుసులను కలిపి తాడు పేనినట్టు మెలిపెట్టు. ఇలాంటివి రెండు బంగారు గొలుసులు చేసి, వాటిని బంగారు అల్లికలకు బిగించు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ప్రధాన యాజకుని కోసం న్యాయపతకం చేయి, ఏఫోదు చేసినట్టు నైపుణ్యం గల పనివారు ఈ పైవస్త్రం చేయాలి. బంగారు దారాలు, సున్నితమైన నారబట్ట, నీలం, ఎరుపు, ఊదారంగుబట్ట వాళ్లు ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ఈ న్యాయతీర్పు పైవస్త్రం 9 అంగుళాల పొడవు, 9 అంగుళాల వెడల్పు ఉండాలి. అది ఒక సంచి అయ్యేటట్టుగా మడత చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","న్యాయ పతకం మీద అందమైన రత్నాలు నాలుగు వరుసలు పెట్టాలి. ఈ రత్నాల మొదటి వరసలో పద్మరాగం, గోమేధికం, మరకతం ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","రెండో వరుసలో ఆకుపచ్చ నీలమణి, పచ్చమరకతం ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","మూడో వరుసలో ఎరుపు వన్నె మణి, ఊదారంగు మణి, వంగరంగు మణి ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","నాలుగో వరుసలో రక్తవర్ణం రాయి, లేతపచ్చ రాయి, సూర్యకాంతం ఉండాలి. న్యాయతీర్పు పైవస్త్రం మీద ఈ రత్నాలన్నీ నిలబడేట్టు బంగారం ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ఇశ్రాయేలు కుమారుల్లో ఒకొక్కరికి ఒకొక్కటి చొప్పున న్యాయ తీర్పు పైవస్త్రం మీద పన్నెండు రత్నాలు ఉంటాయి. ఈ రాళ్లలో ఒక్కొదానిమీద ఇశ్రాయేలు కుమారుల్లో ఒక్కొక్కరిది ఒక దాని మీది రాయి. ఒక్కోరాయిలో ఈ పేర్లను ముద్రించినట్టుగా చెక్కు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“న్యాయతీర్పు పైవస్తానికి స్వచ్ఛమైన బంగారంతో గొలుసులు చేయాలి. ఈ గొలుసులు తాడులా ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","బంగారు ఉంగరాలు రెండు చేసి న్యాయపతకం రెండు మూలల్లో పెట్టు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","న్యాయతీర్పు పైవస్త్రం మూలల్లో ఉన్న రెండు ఉంగరాల్లోనుంచి ఈ బంగారు గొలుసులు రెంటిని దూర్చాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","ఆ గొలుసుల అవతలి కొనలను ఏఫోదు ముందర రెండు భుజం బట్టలమీద పెట్టు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ఇంకో రెండు బంగారు ఉంగరాలు చేసి, న్యాయతీర్పు పైవస్త్రం, అవతల ఉన్న మరి రెండుమూలల్లో పెట్టాలి. ఏఫోదు దగ్గరగా ఉన్న న్యాయతీర్పు పైవస్త్రం లోపలి వైపు ఇది. ");
INSERT INTO tel2010_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","ఇంకా రెండు బంగారు ఉంగరాలు చేసి, ఏఫోదు ముందర భాగంలోని భుజభాగాల అడుగున పెట్టాలి ఏఫోదు దట్టీ పైభాగానికి దగ్గరగా బంగారు ఉంగరాలను ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","న్యాయతీర్పు పైవస్త్రం ఉంగరాలను ఏఫోదు ఉంగరాలకు జత చేయాలి. నడికట్లతో వీటిని జత చేసేందుకు నీలం పతకం ఉపయోగించాలి. ఇలా చేయడం వల్ల న్యాయతీర్పు పైవస్త్రం నడికట్టును పట్టుకొని ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“అహరోను పరిశుద్ధ స్థలంలో ప్రవేశించినప్పుడు, ఇశ్రాయేలు కుమారుల పేర్లు ఆయన గుండెమీద ఉంటాయి. న్యాయం తీర్చడానికి ఆయన ధరించే తీర్పు పతకం మీద ఈ పేర్లు ఉంటాయి. ఈ విధంగా ఇశ్రాయేలు కుమారులు పన్నెండు మందిని యెహోవా ఎల్లప్పుడూ జ్ఞాపకం ఉంచుకొంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","దేవుని నిర్ణయాలు తెలుసుకొనేందుకు ఊరీము, తుమ్మీములను ప్రయోగిస్తాడు. అందుచేత ఊరీము, తుమ్మీములను న్యాయతీర్పు పైవస్త్రములో ఉంచాలి. అహరోను యెహోవా ముందర ఉన్నప్పుడు ఈ విషయాలు అతని గుండెమీద ఉంటాయి. కనుక అహరోను యెహోవా యెదుట ఉన్నప్పుడు, ఇశ్రాయేలీయులకు తీర్పు తీర్చే ఒక విధానాన్ని ఎల్లప్పుడూ తనతో తీసుకువెళ్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ఏఫోదు పైన ధరించేందుకు ఒక అంగీని చెయ్యాలి. అంగీని నీలంరంగు బట్టతోనే చెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","దాని మధ్యలో తల పట్టేందుకు ఒక రంధ్రం ఉండాలి. అది మెడచుట్టూ చిరిగిపోకుండా గోటు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","నీలం, ఎరుపు, ధూమ్ర వర్ణం రంగుల బట్టతో దానిమ్మపండు చేయాలి. అంగీ కింది భాగంలో దానిమ్మ పండును వేలాడదీయాలి. దానిమ్మపండు మధ్య బంగారు గంటలు వ్రేలాడదీయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","అంగీ అడుగున చుట్టూరా ఒక బంగారు దానిమ్మపండు ఒక గంట, మరో దానిమ్మపండు, మరో గంట ఇలా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","అహరోను యాజకునిగా పని చేసేటప్పుడు ఈ అంగీని ధరించి, యెహోవా ఎదుట పరిశుద్ధ స్థలంలో ప్రవేశిస్తాడు. అతడు పరిశుద్ధ స్థలంలో ప్రవేశించేటప్పుడు గంటలు మోగుతాయి. ఈ విధంగా అహరోను మరణించడు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","37","“స్వచ్ఛమైన బంగారంతో ఒక బద్ద చేయాలి, “యెహోవా పరిశుద్ధుడు” అనే మాటలు ఒక ముద్రగా తలపాగా చుట్టూ ముందరవైపు కట్టేందుకు నీలం పతకం ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","అహరోను దీన్ని తన తలమీద ధరిస్తాడు. ఇశ్రాయేలీయుల కానుకల విషయంలో దోషాలు ఏమైన ఉంటే ఆ దోషాన్ని అతడు భరించినప్పుడు, ఇది అతన్ని పరిశుద్ధంగా ఉంచుతుంది. ఈ కానుకలు ప్రజలు యెహోవాకు అర్పించేవి. ప్రజల కానుకలను యెహోవా స్వీకరించేటట్టు అహరోను దీనిని ఎప్పుడూ తన తలమీద ధరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“అంగీని తయారు చేసేందుకు సున్నితమైన నార బట్టను ఉపయోగించాలి. తలపాగా చేసేందుకు సున్నితమైన నారబట్టను ఉపయోగించాలి. నడికట్టు మీద బుట్టా కుట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","చొక్కాలు, పట్టాలు, తలపాగాలు కూడా తయారు చేయాలి. ఇవి వారికి గౌరవమర్యాదలు కలిగిస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","నీ సోదరుడైన అహరోనుకు, అతని కుమారులకు ఈ బట్టలు ధరింపజేయాలి. తర్వాత వారు యాజకులని చూపెట్టేందుకుగాను వారి తలమీద ఒలీవనూనె పోయాలి. ఇది వాళ్లను యాజకులుగా చేస్తుంది. ఒక ప్రత్యేక విధానంలో వారు నన్ను సేవిస్తున్నారని ఈ విధంగా నీవు తెలియజేస్తావు. అప్పుడు వారు నన్ను యాజకులుగా సేవిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“వారి ప్రత్యేక యాజక వస్త్రాల కింద ధరించేందుకు శ్రేష్ఠమైన బట్టను ఉపయోగించాలి. లోపల ధరించే ఈ వస్త్రాలు నడుంనుండి కాళ్ల వరకు ధరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","అహరోను, అతని కుమారులు సన్నిధి గుడారములో ఎప్పుడు ప్రవేశించినా, ఈ వస్త్రాలు ధరించాలి. పరిశుద్ధ స్థలంలో యాజకులుగా సేవ చేసేందుకు బలిపీఠం దగ్గరకు ఎప్పుడు వచ్చినా వారు ఈ వస్త్రాలు ధరించాలి. వారు ఈ వస్త్రాలు ధరించకపోతే, తప్పు చేసిన నేరస్థులై చావాల్సి వస్తుంది. అహరోను, అతని తర్వాత అతని కుటుంబం అంతటికీ ఇదంతా నిత్యం కొనసాగే ఒక చట్టంగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“అహరోను, అతని కుమారులు యాజకులుగా ఒక ప్రత్యేక విధానంలో నన్ను సేవిస్తున్నారని తెలియజేసేందుకు నీవు చేయాల్సిన దానిని యిప్పుడు నీకు నేను చెబతాను. ఒక గిత్తను, కళంకం లేని రెండు పొట్టేళ్లను సంపాదించు. ");
INSERT INTO tel2010_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","తర్వాత పులియజేసే పదార్థంలేని సన్నని గోధుమ పిండితో రొట్టె చేయాలి. ఒలీవ నూనెతో కలిపి చేసే రొట్టెలకు గూడ అవే వస్తువులు ఉపయోగించాలి. నూనెతో కలిపి చిన్న చిన్న పల్చటి అప్పడాలు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","ఈ రొట్టెలు, అప్పడాలు ఒక బుట్టలో పెట్టాలి. ఆ బుట్టను అహరోనుకు, అతని కుమారులకు ఇవ్వాలి. అదే సమయంలో గిత్తను రెండు పొట్టేళ్లను కూడ వారికి ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“తర్వాత అహరోనును అతని కుమారులను సన్నిధి గుడారం ముందటి ద్వారం దగ్గరకు తీసుకు రావాలి. నీళ్లతో వాళ్లకు స్నానం చేయించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","అహరోనుకు అతని చొక్కా తొడిగించాలి. ప్రత్యేక ఏఫోదుతో వుండే అంగీని అతనికి ధరింపజేయాలి. అప్పుడు ఏఫోదును, న్యాయతీర్పు పైవస్త్రాన్ని అతనికి కట్టాలి. అందమైన దట్టీని అతనికి కట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","తర్వాత అతని తలమీద తలపాగ చుట్టాలి. ప్రత్యేక కిరీటాన్ని బంగారు బద్ద తలపాగా చుట్టూరా ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","అభిషేక తైలము తీసుకొని అతని తలమీద పోయాలి. అహరోను ఈ పనికి ఏర్పరచబడ్డాడని ఇది సూచిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“తర్వాత అతని కుమారులను అక్కడికి తీసుకరావాలి. వారికి తెల్ల అంగీలు ధరింపజేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","అప్పుడు వారి నడుములకు దట్టీలు చుట్టాలి. ధరించేందుకు ప్రత్యేక టోపీలను వారికి ఇవ్వాలి. వారు యాజకులుగా ఉండడం అప్పుడు ప్రారంభం అవుతుంది. శాశ్వతంగా కొనసాగే ప్రత్యేక చట్టంవల్ల వారు యాజకులుగా ఉంటారు. ఈ విధంగా అహరోనును, అతని కుమారులను నీవు యాజకులుగా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“తర్వాత సన్నిధి గుడారం ఎదుటకు గిత్తను తీసుకురావాలి. అహరోను, అతని కుమారులు ఆ గిత్త తల మీద వారి చేతులు పెట్టాలి, ");
INSERT INTO tel2010_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","“అప్పుడు ఆ సన్నిధి గుడారం ఎదుట ఆ గిత్తను చంపాలి. దీనిని యెహోవా చూస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","అప్పుడు గిత్త రక్తంలో కొంత తీసుకొని బలిపీఠం దగ్గరకు వెళ్లాలి. బలిపీఠం కొమ్ముల మీద నీ వేళ్లతో కొంచెం రక్తం చిలకరించాలి. మిగిలిన రక్తం అంతా బలిపీఠం అడుగున కుమ్మరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","తర్వాత గిత్త లోపలి కొవ్వు అంతా తీయాలి. కాలేయంలో కొవ్విన భాగాన్ని రెండు మూతగ్రంథులను వాటి చుట్టూ ఉండే కొవ్వును తీసి బలిపీఠం మీద దహించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","తర్వాత గిత్త మాంసం, చర్మం, ఇతర భాగాలు తీసుకొని మీ పాళెము వెలుపటికి వెళ్లాలి. అక్కడ, పాళెము వెలుపల వీటిని కాల్చివేయాలి. ఇది యాజకుల పాపాలను తీసివేయు అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“తర్వాత పొట్టేళ్లలో ఒకదాని తలమీద తమ చేతులు పెట్టమని అహరోనుకు, అతని కుమారులకు చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","అప్పుడ ఆ పొట్టేలును చంపి ఆ రక్తం భద్రం చేయాలి. ఆ రక్తాన్ని బలిపీఠం నలువైపుల వెదచల్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","అప్పుడు పొట్టేలును ముక్కలు ముక్కలుగా కోయాలి. పొట్టేలు లోపలి భాగాలను కాళ్లను కడగాలి. వీటిని పొట్టేలు తల ఇతరభాగాలతో కలిపి పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","అప్పుడు ఆ మొత్తాన్ని బలిపీఠం మీద దహించి వేయాలి. ఇది దహించబడ్డ దహన బలి. ఇది యెహోవాకు అర్పించబడింది. యెహోవా అర్పణను వాసన చూస్తాడు. అది ఆయనకు ఎంతో ప్రీతికరంగా ఉంటుంది. ఇది నిప్పు ఉపయోగించి యెహోవాకు అర్పించే అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ఇంకో పొట్టేలు మీద వారి చేతులు వుంచమని అహరోనుకు, అతని కుమారులకు చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ఆ పొట్టేలును చంపి, దాని రక్తం భద్రం చేయాలి. అహరోనుకు, అతని కుమారులకు వారి కుడి చెవి కొనల మీద ఆ రక్తం చల్లాలి. ఇంక వారి కుడి చేతుల బొటన వేళ్ల మీద కొంత రక్తం ఉంచాలి. వారి కుడి పాదాల బొటన వేళ్లపై మరికొంత రక్తం ఉంచాలి. అప్పుడ బలిపీఠం మీద నాల్గువైపులా రక్తం చల్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","తర్వాత బలిపీఠం నుండి కొంత రక్తం తీసుకోవాలి. ప్రత్యేక తైలంతో దాన్ని కలిపి, అహరోను మీద, అతని బట్టల మీద దాన్ని చల్లాలి. ఆయన కుమారుల మీద, వారి బట్టల మీద దాన్ని చల్లాలి, అహరోను, అతని కుమారులు ఒక ప్రత్యేక విధానంలో నన్ను సేవిస్తున్నారని ఇది సూచిస్తుంది. ప్రత్యేక సందర్భాల్లో మాత్రమే, వారి బట్టలు ఉపయోగించబడుతాయని ఇది సూచిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“అప్పుడు పొట్టేలు నుండి కొవ్వును తీయాలి. (అహరోనును ప్రధాన యాజకునిగా చేసే ఆచార క్రమంలో ఉపయోగించబడే పొట్టేలు ఇది). తోక చుట్టూ ఉండే క్రొవ్వును, శరీరం లోపలి భాగాలను కప్పివుండే కొవ్వును తీయాలి. కాలేయంలో క్రొవ్విన భాగాన్ని తీయాలి. మూతగ్రంధులు రెండింటిని, కుడి కాలును తీయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","పులియని పదార్థం లేకుండా నీవు చేసిన రొట్టెలు గల బుట్టను తీసుకొని యెహోవా ముందు పెట్టాలి. బుట్టలోని రొట్టె ఒకటి, ఒలీవ నూనెతో చేసిన రొట్టె ఒకటి, పలుచని చిన్న అప్పడం ఒకటి బుట్టలో నుండి బయటికి తీయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","అప్పుడు వీటిని అహరోనుకు, అతని కుమారులకు ఇవ్వు. యెహోవా యెదుట వీటిని తమ చేతులతో పట్టుకొని ఉండమని వారితో చెప్పు. ఇది యెహోవాకు ప్రత్యేకమైన అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","అప్పుడు అహరోను, అతని కుమారుల చేతుల్లోనుంచి వీటిని తీసుకొని, పొట్టేలుతో బాటు బలిపీఠం మీద పెట్టు. యెహోవా ఈ దహనబలి అర్పణ వాసన చూసి ఆనందిస్తాడు. ఇది నిప్పు ఉపయోగించి యెహోవాకు ఇచ్చే అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","“అప్పుడ పొట్టేలుయొక్క బోరను తీసుకోవాలి. (ఇది అహరోను ప్రధాన యాజకునిగా చేసే ఆచార క్రమంలో ఉపయోగించే పొట్టేలు). పొట్టేలు బోరను యెహోవా సన్నిధిలో ఇచ్చి పుచ్చుకొనే ప్రత్యేక అర్పణగా అర్పించాలి. జంతువుల్లోని ఈ భాగం నీది. ");
INSERT INTO tel2010_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","అప్పుడు అహరోనును ప్రధాన యాజకునిగా చేయుటకు ఉపయోగించి పొట్టేలు రొమ్ము, కాలు తీసుకో, వాటిని అహరోనుకు, అతని కుమారులకు ఇయ్యి. ఇది అర్పణలో ఒక ప్రత్యేక భాగం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ఇశ్రాయేలు ప్రజలు ఈ భాగాలను అహరోనుకు, అతని కుమారులకు ఎల్లప్పుడూ ఇస్తూ ఉండాలి. ఇశ్రాయేలు ప్రజలు యెహోవాకు అర్పణ అర్పించినప్పుడల్లా ఈ భాగాలు ఎప్పుడూ యాజకులకే చెందుతాయి. ఈ భాగాలను వారు యాజకులకు ఇచ్చినప్పుడు అవి యెహోవాకు ఇచ్చినట్టే అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“అహరోను తయారు చేసిన ఆ ప్రత్యేక వస్త్రాలను భద్రం చేయాలి. అతని తర్వాత జీవించే వారందరికీ ఈ వస్త్రాలు చెందుతాయి. వారు యాజకులుగా ఏర్పాటు చేయబడినప్పుడు ఈ వస్త్రాలు ధరిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","అహరోను తర్వాత అతని కుమారుడు ప్రధాన యాజకుడు అవుతాడు. ఈ కుమారుడు పరిశుద్ధ స్థలంలో పరిచర్య చేసేందుకు సన్నిధి గుడారంలోనికి వచ్చినప్పుడు ఆ వస్త్రాలు ధరిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“అహరోనును ప్రధాన యాజకునిగా చేసేందుకు ఉపయోగించిన పొట్టేలు మాంసాన్ని ఒక పవిత్ర స్థలంలో వండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","అప్పుడు అహరోను, అతని కుమారులు సన్నిధి గుడారం ఎదుటి ద్వారం ముందు ఆ మాంసం తినాలి. మరియు బుట్టలోని రొట్టెను కూడ వారు తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","వారు యాజకులుగా చేయబడ్డప్పుడు వారి పాపాలను పరిహరించేందుకు ఈ అర్పణలు ఉపయోగించబడ్డాయి. ఇప్పుడు వారు ఈ అర్పణలను తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ఆ పొట్టేలు మాంసంలోగాని, ఆ రొట్టెలోగాని ఏమైనా మర్నాటి ఉదయానికి మిగిలి ఉంటే దానిని కాల్చివేయాలి. ఆ రొట్టె, మాంసం ఒక ప్రత్యేక సమయంలో, ఒక ప్రత్యేక విధానంలో మాత్రమే తినవలసినవి గనుక మీరు వాటిని తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“అహరోను, అతని కుమారులకోసం నీవు చేయాలని నేను నీకు ఆజ్ఞాపించిన వీటన్నింటినీ నీవు చేయాలి. వీటిని ఏడురోజుల వ్యవధిలో నీవు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","రోజుకు ఒక ఎద్దు చొప్పున ఏడు రోజులు వధించాలి. ఇది అహరోను, అతని కుమారుల పాపముకోసం అర్పణగా ఉంటుంది. బలిపీఠాన్ని పవిత్రం చేసేందుకు నీవు ఈ బలులను ఉపయోగించాలి. బలిపిఠాన్ని పవిత్రం చేసేందుకు దాని మీద ఒలీవ నూనెపోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","ఏడురోజుల పాటు బలిపీఠాన్ని నీవు పవిత్రం చేయాలి. ఆ సమయంలో బలిపీఠం అతిపవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“బలిపీఠం మీద ప్రతిరోజూ ఒక అర్పణ అర్పించాలి. ఒక సంవత్సరం వయస్సుగల రెండు గొర్రె పిల్లల్ని వధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ఒక గొర్రెపిల్లను ఉదయం, మరో గొర్రెప్లిను ఉదయం, అర్పణ పవిత్రం చేయాలి. గనుక వపొట్టేలు మాంసాన్ని ఒక పవిత్ర ల్లను సాయంత్రం అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","మొదటి గొర్రెపిల్లను నీవు వధించినప్పుడు పదవవంతు సన్నటి గోధుమ పిండిని ఒక పావు ద్రాక్షారసంతో కలిపి అర్పణగా చేయాలి. ఉదయం చేసినట్టే సాయంత్రం రెండో గొర్రెపిల్లను వధించినప్పుడు కూడ పదవవంతు సన్నని పిండిని అర్పించాలి. ఒక పావు ద్రాక్షారసం అర్పించాలి. ఇది యెహోవాకు భోజన అర్పణం అవుతుంది. ఈ అర్పణ నీవు దహించినప్పుడు, యెహోవా దీని సునాసనను చూసి ఆనందిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ప్రతిరోజూ యెహోవాకు అర్పణగా వీటిని నీవు దహించాలి. సమావేశ గుడారం ముందు ద్వారం దగ్గర, యెహోవా ఎదుట వీటిని చేయాలి. ఇలానే ఎల్లప్పుడూ చేస్తూ ఉండాలి. నీవు అర్పణ అర్పించునప్పుడు, యెహోవానైన నేను నిన్ను అక్కడ కలుసుకొని నీతో మాట్లాడుతాను. ");
INSERT INTO tel2010_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ఆ స్థలంలో నేను ఇశ్రాయేలు ప్రజల్ని కలుసుకొంటాను. నా మహిమవల్ల ఆ స్థలం పవిత్ర పర్చబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“కనుక సన్నిధి గుడారాన్ని నేను పవిత్రం చేస్తాను. మరియు బలిపీఠాన్ని నేను పవిత్రం చేస్తాను. అహరోను, అతని కుమారులు నాకు యాజకులుగా సేవ చేయగలిగేటట్టు నేను వారిని పవిత్రం చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","నేను ఇశ్రాయేలు ప్రజలతో నివసిస్తాను. నేను వారికి దేవుడిగా ఉంటాను. ");
INSERT INTO tel2010_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","‘నేనే యెహోవాను, వారి దేవుడ్ని’, అని ప్రజలు తెలుసుకొంటారు. నేను వారితో నివసించేందుకు వారిని ‘ఈజిప్టునుండి బయటికి రప్పించింది నేనే’ అని వారు తెలుసుకొంటారు. నేనే వారి దేవుడైన యెహోవాను.” ");
INSERT INTO tel2010_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“తుమ్మ కర్రతో ఒక వేదిక చేయి. ధూపం వేసేందుకు ఈ పీఠమును నీవు ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","వేదికను 18 అంగుళాలు పొడవు, 18 అంగుళాలు వెడల్పు గల చతురస్రముగా నీవు చేయాలి. దీని ఎత్తు 36 అంగుళాలు ఉండాలి. నాలుగు మూలల కొమ్ములు ఉండాలి. ఈ కొమ్ముల్ని వేదికతో కలిపి ఒకటిగా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","బలిపీఠం పైభాగాన్ని, అన్ని ప్రక్కలను స్వచ్ఛమైన బంగారం పొదిగించాలి. బలిపీఠం చుట్టూ బంగారు నగిషిబద్ద పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","నగిషీబద్ద అడుగు భాగాన బంగారు ఉంగరాలు నాలు ఉండాలి. ఈ బలిపీఠానికి ఎదురుగా రెండు బంగారు ఉంగరాలు ఉండాలి. బలిపీఠం మోసే కర్రలకోసం ఈ బంగారు ఉంగరాలు ఉపయోగించబడతాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","తుమ్మకర్రతోనే ఆ కర్రలు చేయాలి. కర్రలకు బంగారు తాపడం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","ప్రత్యేక తెరముందు ఈ బలిపీఠాన్ని ఉంచాలి. ఒడంబడిక పెట్టెను తెర అవతల ఉంచాలి. ఆ పెట్టె మూతకు ముందర బలిపీఠం ఉంచాలి. నేను నిన్ను కలుసుకోనే చోటు ఇదే. ");
INSERT INTO tel2010_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“ప్రతీ ఉదయం పరిమళ ద్రవ్యాల ధూపాన్ని బలిపీఠం మీద అహరోను వేయాలి. దీపాలు సరిచేసేందుకు వచ్చినప్పుడు అతడు దీనిని చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","మరల సాయంత్రం అతడు ధూపం వేయాలి. ఇది అతడు సాయంత్రం దీపాలను సరిచేసే వేళ. కనుక ప్రతిరోజూ శాశ్వతంగా యెహోవా ఎదుట ధూపం వేయబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","ఇంకే విధమైన ధూపం వేసేందుకు గాని, దహన బలి కోసంగాని ఈ బలిపీఠాన్ని ఉపయోగించవద్దు. ఏ విధమైన ధాన్యార్పణగాని, పానార్పణంగాని అర్పించేదుకు బలిపీఠాన్ని ఉపయోగించవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","“సంవత్సరానికి ఒక సారి అహరోను యెహోవాకు ఒక ప్రత్యేక బలి అర్పించాలి. ప్రజల పాప పరిహారం నిమిత్తం చెల్లించేందుకు పాపపరిహారార్థ బలి రక్తాన్ని అహరోను ఉపయోగించాలి. ఈ బలిపీఠపు కొమ్ముల దగ్గర అహరోను దీనిని చేయాలి. ఇది, ప్రాయశ్చిత్తార్థ దినం అని పిలువబడుతుంది. ఇది యెహవాకు అతి ప్రత్యేక దినం.” ");
INSERT INTO tel2010_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","మోషేతో యెహోవా ఇలా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ఎంత మంది ప్రజలు ఉన్నారో నీకు తెలిసేటట్టు, ఇశ్రాయేలు ప్రజల్ని లెక్కబెట్టు. ఇలా చేసినప్పుడల్లా, ప్రతి వ్యక్తీ తనకోసం యెహోవాకు పన్ను చెల్లించాలి. ప్రతి వ్యక్తీ ఇలా చేస్తే ఏ విధమైన దారుణం ప్రజలకు సంభంవిచదు. ");
INSERT INTO tel2010_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","లెక్కించబడ్డ ప్రతి మనిషీ అరతులం చెల్లించాలి. (ఇది అధికార పూర్వకమైన తులంలో సగం, అధికార తులం అంటే 20 గొర్రెలు). ఈ అరతులం యెహోవాకు అర్పణం ");
INSERT INTO tel2010_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","లెక్కించబడి, 20 సంవత్సరాలు లేక అంతకు ఎక్కువ వయసుగల ప్రతి వ్యక్తీ యెహోవాకు ఈ అర్పణ చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ధనికులు అరతులం కంటె ఎక్కువ చెల్లించకూడదు. ప్రజలందరూ ఒకే అర్పణ యెహోవాకు చెల్లించాలి. ఇది మీ ప్రాణం కోసం చెల్లించే అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ఇశ్రాయేలు ప్రజల దగ్గర్నుండి ఈ సొమ్ము పోగుచేయి. సన్నిధి గుడారంలో సేవకోసం ఈ సొమ్ము ఉపయోగించు. యెహోవా తన ప్రజలను జ్ఞాపకం ఉంచుకొనేందుకు ఈ చెల్లింపు ఒక విధానం. వారు తమ స్వంత ప్రాణాల నిమిత్తం చెల్లిస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","మోషేతో యెహోవా ఇలా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ఇత్తడి గంగాళం ఒకటి చేసి ఇత్తడి పీటమీద దాన్ని పెట్టు. కడుగుకొనేందుకు నీవు దీనిని ఉపయోగించాలి. సన్నిధి గుడారానికి, బలిపీఠానికి మధ్య దీనిని ఉంచి, నీళ్లతో నింపు. ");
INSERT INTO tel2010_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","ఈ గంగాళంలోని నీళ్లతో అహరోను, అతని కుమారులు వారి కాళ్లు చేతు లు కడుక్కోవాలి ");
INSERT INTO tel2010_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","సన్నిధి గుడారం ప్రవేశించేటప్పుడు, లేక బలిపీఠం సమీపించేటప్పుడు ప్రతిసారీ వారు నీళ్లతో కడుక్కోవాలి. ఈ విధంగా వారు మరణించరు. ");
INSERT INTO tel2010_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","మరియు తమ చావకుండా ఉండేందుకు వారు తమ కాళ్లు చేతులు కడుక్కోవాలి. అహరోనుకీ, అతని ప్రజలకీ ఎప్పటికీ కొనసాగే చట్టం యిది. భవిష్యత్తులో జీవించే అహరోను సంతతి వాళ్లందరికీ యిది కొనసాగుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","అప్పుడు మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“శ్రేష్ఠమైన సుగంధద్రవ్యాలు సంపాదించు. పరిమళ ధూపం చేయడానికి 500 తులాల స్వచ్ఛమైన గోపరసం, 250 తులాల సువాసనగల లవంగపట్ట, 500 తులాల సుగంధ ద్రవ్యాలు, ");
INSERT INTO tel2010_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","500 తులాల లవంగపట్ట తీసుకో. వీటన్నింటినీ కొలిచేందుకు అధికారిక కొలత ఉపయోగించు. మరియు మూడు పళ్ల ఒలీవ నూనె తీసుకో. ");
INSERT INTO tel2010_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“ఒక పరిమళ అభిషేక తైలంగా చేయటానికి వీటన్నింటినీ కలపాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","సన్నిధి గుడారం మీద, ఒడంబడిక పెట్టె మీద ఈ తైలం పోయి, వీటికి ఒక ప్రత్యేక ఉద్దేశం వుంది అని ఇది తెలియజేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","బల్లమీద, బల్లమీద ఉన్న పాత్రలన్నింటిమీద తైలం పోయి. దీపం మీద, దాని పరికరాలన్నింటి మీద ఈ తైలం పోయి. ధూపవేదిక మీద తైలం పోయి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ఇంకా దేవునికి అర్పణలు దహనం చేసే బలిపీఠం మీద ఈ తైలం పోయి. ఆ బలిపీఠం పైన ఉండే సమస్తం మీద తైలం పోయి. గంగాళంమీద, దాని పీటమీద ఈ తైలం పోయి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","వీటన్నింటినీ నీవు పవిత్రం చేయాలి. అవి యెహోవాకు చాల ప్రత్యేకం. వీటిని ఏది తాకినా అది పవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“అహరోను, అతని కుమారుల మీద ఈ తైలంపోయి. వారు ఒక ప్రత్యేక విధానంలో నన్ను సేవిస్తున్నారని ఇది తెలియజేస్తుంది. అప్పుడు యాజకులుగా వారు నా సేవ చేయవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","అభిషేక తైలం ఎల్లప్పుడు నాకు ప్రత్యేకమైనదిగా ఉంటుందని ఇశ్రాయేలు ప్రజలతో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","సామాన్యమైన సుగంధ తైలంగా ఎవరూ దీనిని వాడకూడదు. ఈ ప్రత్యేక తైలం తయారు చేసిన విధానంలో సుగంధ తైలం తయారు చేయకూడదు. ఈ తైలం పవిత్రం, ఇది మీకు చాల ప్రత్యేకమైనదిగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ఎవరైనా ఈ పవిత్ర తైలం వలె సుగంధ తైలం తయారు చేసి అన్యునికి యిస్తే, ఆ వ్యక్తి తన ప్రజల్లో నుండి వేరు చేయబడాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","అప్పుడు మోషేతో యెహోవా ఇలా చెప్పాడు, “ఈ పరిమళ ద్రవ్యాలను తీసుకరా! జటామాంసి, గోపి చందనం, గంధపుచెక్క స్వచ్ఛమైన సాంబ్రాణి. ఈ పరిమళ ద్రవ్యాలన్నీ సమపాళ్లలో ఉండేటట్టు తప్పక చూడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","సుగంధ పరిమళ ధూపంగా ఉండేటట్టు ఈ పరిమళ ద్రవ్యాలన్నిటినీ కలపాలి. పరిమళ తైలం తయారుచేసే వాడు చేసినట్టే దీనిని చేయాలి. మరియు ఈ ధూపంలో ఉప్పు కలుపు. అది దీనిని స్వచ్ఛమైనదిగా, ప్రత్యేకమైనదిగా చేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","ధూప ద్రవ్యంలో కొంత మెత్తటి పొడుం అయ్యేంత వరకు నూరాలి. సన్నిధి గుడారంలో, ఒడంబడిక పెట్టె ఎదుట ఆ పొడుం ఉంచు. ఇది నేను నిన్ను కలుసుకొనే చోటు. ఈ ధూపపు పొడుంను దాని ప్రత్యేక పని కోసమే నీవు ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","యెహోవా కోసం ఈ ప్రత్యేక విధానంలో మాత్రమే నీవు ఈ ధూపాన్ని ఉపయోగించాలి. ఈ ధూపాన్ని ఒక ప్రత్యేక పద్ధతిలో నీవు తయారు చేయాలి. ఇంకే యితరమైన ధూపం చేయడానికి కూడ ఈ ప్రత్యేక పద్ధతిని వినియోగించవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ఒక వ్యక్తి, తన కోసం ఈ ధూపం కొంత తయారు చేసి, దాని పరిమళాన్ని అనుభవించాలని కోరవచ్చు. అయితే, అతడు గనుక అలా చేస్తే, వాడు తన ప్రజల నుండి వేరు చేయబడాలి.” ");
INSERT INTO tel2010_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","అప్పుడు మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“యూదా గోత్రంలో ఊరు కుమారుడైన బెసలేలును నేను ఏర్పరచుకొన్నాను (హూరు కుమారుడు ఊరు). ");
INSERT INTO tel2010_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","బెసలేలును నేను దేవుని ఆత్మతో నింపాను. అన్ని రకాల వస్తువులు చేసేందుకు జ్ఞానం, నైపుణ్యం నేను అతనికి ఇచ్చాను. ");
INSERT INTO tel2010_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","నమూనాలు గీయటంలో బెసలేలు చాల ప్రజ్ఞ గలవాడు. బంగారు, వెండి, ఇత్తడితో అతడు వస్తువులు చేయగలడు. ");
INSERT INTO tel2010_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","బెసలేలు అందమైన నగలను చెక్కి, పొదుగగలడు. అతడు చెక్క పని చేయగలడు. బెసలేలు అన్ని రకాల పనులు చేయగలడు. ");
INSERT INTO tel2010_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","అతనితో పని చేయటానికి అహూలియాబును కూడ నేను ఏర్పరచుకొన్నాను. అహూలియాబు దాను గోత్రపు అహీసామాకు కుమారుడు. నేను నీకు ఆజ్ఞాపించిన వాటన్నింటినీ చేయగలిగేటట్టు మిగిలిన పని వాళ్లందరికీ నేను నైపుణ్యం యిచ్చాను. ");
INSERT INTO tel2010_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","సన్నిధి గుడారం ఒడంబడిక పెట్టె పెట్టెను మూసే కరుణా పీఠము. ");
INSERT INTO tel2010_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","బల్ల, దానిమీద ఉండాల్సినవన్నీ ధూప వేదిక ");
INSERT INTO tel2010_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","దహన బలులు దహించే బలిపీఠం బలిపీఠం దగ్గర ఉపయోగించే వస్తువులు గంగాళం, దాని క్రింద పీట. ");
INSERT INTO tel2010_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","యాజకుడు అహరోనుకు ప్రత్యేక వస్త్రాలన్నీ, అతని కుమారులు యాజకులుగా పరిచర్య చేసేటప్పుడు ధరించాల్సిన ప్రత్యేక వస్త్రాలన్నీ, ");
INSERT INTO tel2010_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","అభిషేకానికి పరిమళ సువాసనగల తైలం, పవిత్ర స్థలానికి అవసరమైన పరిమళ వాసనగల ధూపం. ఈ పని వాళ్లు నేను నీకు ఆజ్ఞాపించిన ప్రకారం అన్ని వస్తువులనూ తయారు చేస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","అప్పుడు మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ఇశ్రాయేలు ప్రజలతో దీన్ని చెప్పు; ‘నా ప్రత్యేక విశ్రాంతి రోజులను గూర్చిన నియమాలను మీరు పాటించాలి. రాబోయే తరాలన్నింటిలో మీకు, నాకు మధ్య అవి ఒక గురుతుగా ఉంటాయి కనుక మీరు ఇలా చేయాలి. యెహోవానైన నేనే మిమ్మల్ని నా ప్రత్యేక ప్రజలుగా ఏర్పరచుకొన్నానని ఇది మీకు తెలియజేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘సబ్బాతు రోజును ఒక ప్రత్యేక రోజుగా చేయి. ఏ వ్యక్తి అయినా సరే సబ్బాతు రోజును మామూలు రోజుగానే పరిగణిస్తే, ఆ వ్యక్తిని చంపేయాలి. సబ్బాతు రోజున ఏ వ్యక్తి అయినా సరే పనిచేస్తే ఆ వ్యక్తి తన ప్రజల నుండి వేరు చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","పని చేయడానికి వారంలో ఇంకా ఆరు రోజులున్నాయి. అయితే, ఏడో రోజు చాల ప్రత్యేకమైన విశ్రాంతి రోజు. సబ్బాతు నాడు ఏ వ్యక్తి అయినా సరే పనిచేస్తే వాణ్ణి చంపెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","ఇశ్రాయేలు ప్రజలు సబ్బాతు రోజును జ్ఞాపకం ఉంచుకొని, దాన్ని ఒక ప్రత్యేక రోజుగా చేయాలి. ఇది నాకూ, వారికీ మధ్య శాశ్వతంగా కొనసాగే ఒడంబడిక ");
INSERT INTO tel2010_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ఇశ్రాయేలీయులకూ, నాకూ మధ్య శాశ్వత సంకేతం సబ్బాతు రోజే. యెహోవా ఆరు రోజులు పనిచేసి ఆకాశాన్ని, భూమిని చేసాడు. ఏడోరోజున ఏ పని చేయక విశ్రాంతి తీసుకొన్నాడు.’” ");
INSERT INTO tel2010_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","అలా సీనాయి పర్వతం మీద యెహోవా మోషేతో మాట్లాడ్డం ముగించాడు. అప్పుడు ఆజ్ఞలు రాయబడ్డ రెండు రాతి పలకలను యెహోవా మోషేకు ఇచ్చాడు. దేవుడు తన వ్రేలితో రాళ్లమీద ఈ ఆజ్ఞలు రాసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","చాలాకాలం గడిచిపోయినా, మోషే పర్వతం దిగి రాకపోవడం ప్రజలు గమనించారు. కనుక ప్రజలు అహరోను చుట్టూ చేరారు, “చూడు, ఈజిప్టు దేశం నుండి మోషే మమ్మల్ని బయటకు నడిపించాడు. అయితే అతనికి ఏమయిందో మాకు తెలియదు. అందుచేత మా ముందర నడవడానికి ఒక దేవతను చేసి మమ్మల్ని నడిపించు” అని వారతినితో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","“మీ భార్యలు, కుమారులు, కుమార్తెలకు చెందిన బంగారు వస్తువులను తీసుకురండి” అని అహరోను ప్రజలతో అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","కాబట్టి ప్రజలంతా వారి బంగారు వస్తువులను పోగుచేసి వాటిని అహరోను దగ్గరకు తెచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","ప్రజల దగ్గర నుండి అహరోను బంగారం తీసుకున్నాడు. అప్పుడు వాటితో ఒక దూడ విగ్రహం చేసాడు. విగ్రహం చెక్కడానికి అహరోను ఉలి ఉపయోగించాడు. (తర్వాత దానికి బంగారం పొదిగించాడు.) అప్పుడు ప్రజలు, “ఓ ఇశ్రాయేలూ, ఈజిప్టు నుండి మిమ్మల్ని బయటకు నడిపించింది ఈ దేవుడే” అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","అహరోను వీటన్నింటినీ చూసాడు. కనుక ఆ దూడ ఎదుట ఒక బలిపీఠం నిర్మించాడు. అప్పుడు అహరోను ఒక ప్రకటన చేసాడు. “రేపు యెహోవాకు ప్రత్యేక పండుగ” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","మర్నాడు ఉదయం పెందలాడే ప్రజలు మేల్కొన్నారు. వాళ్లు జంతువులను చంపి దహన బలులుగాను, సమాధాన బలులుగాను అర్పించారు. తిని, తాగేందుకు ప్రజలు కూర్చున్నారు. అప్పుడు వాళ్లు విచ్చలవిడిగా సంబరం చేసుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","అదే సమయంలో మోషేతో యెహోవా ఇలా అన్నాడు: “ఈ పర్వతం దిగి వెళ్లు. నీ ప్రజలు, ఈజిప్టు దేశం నుండి నీవు బయటకు తీసుకు వచ్చిన ప్రజలు భయంకర పాపం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","వాళ్లు చేయాలని నేను ఆజ్ఞాపించిన సంగతుల నుండి వాళ్లు చాల త్వరగా తప్పి పోయారు. కరగించిన బంగారంతో వాళ్లు ఒక దూడను చేసుకొన్నారు. వాళ్లు ఆ దూడను పూజిస్తూ దానికి బలులు చెల్లిస్తున్నారు. ‘ఇశ్రాయేలూ, ఈజిప్టు నుండి నిన్ను బయటకు రప్పించిన దేవుడు ఇదే, అని ప్రజలు చెప్పుకొనుచున్నారు.’” ");
INSERT INTO tel2010_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“ఈ ప్రజలను నేను చూశాను. వీళ్లు ఎప్పుడూ నన్ను వ్యతిరేకించే మొండి ప్రజలని నాకు తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","కనుక కోపంతో వాళ్లను నాశనం చేయనివ్వు, అప్పుడు నీలోనుండి ఒక జనాన్ని నేను తయారు చేస్తాను” అని మోషేతో యెహోవా అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","అయితే, మోషే తన దేవుడైన యెహవాను బ్రతిమాలుకొని: “ప్రభూ! నీ కోపం చేత నీ ప్రజలను నాశనం చేయకు. నీవే నీ మహాశక్తితో బలంతో ఈ ప్రజలను ఈజిప్టు నుండి తీసుకువచ్చావు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","అయితే, నీవే నీ ప్రజలను నాశనం చేస్తే, ‘యెహోవా తన ప్రజలకు చెడ్డకార్యాలను చేయాలని తలపెట్టాడు. అందుకే ఆయన వాళ్లను ఈజిప్టు నుండి బయటకు రప్పించాడు. పర్వతాల్లోనే వాళ్లను చంపాలని ఆయన అనుకున్నాడు. భూమి మీద తన ప్రజల్ని నాశనం చేయాలని ఆయన అనుకొంటున్నాడు’ అని ఈజిప్టు ప్రజలు చెప్పవచ్చు. కనుక నీ ప్రజల మీద కోపగించవద్దు. నీ కోపం విడిచిపెట్టేయి. నీ ప్రజల్ని నాశనం చేయకు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","నిన్ను సేవించిన మనుష్యులు అబ్రహాము, ఇస్సాకు, ఇశ్రాయేలును (యాకోబు) జ్ఞాపకం చేసుకో. నీవు నీ పేరు ప్రయోగించి ఆ మనుష్యులకు వాగ్దానం చేసావు. ‘నీ ప్రజలను ఆకాశంలో నక్షత్రాలు ఎన్ని ఉన్నాయో అంతగా చేస్తాను. నేను వారికి వాగ్దానం చేసిన ఈ దేశం అంతా నీ ప్రజలకు ఇస్తాను. ఈ దేశం శాశ్వతంగా వారిదే అవుతుంది’ అని నీవు చెప్పావు.” ");
INSERT INTO tel2010_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","కనుక యెహోవా తన ప్రజలను గూర్చి సంతాపపడ్డాడు. ఆయన చేస్తానన్న కీడును వారికి చేయలేదు. అంటే, ప్రజలను ఆయన నాశనం చేయలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","అప్పుడు మోషే పర్వతం దిగి వెళ్లాడు. ఆజ్ఞలు రాయబడ్డ రెండు రాతి పలకలు మోషే దగ్గర ఉన్నాయి. రాతికి వెనుక, ముందు రెండు వైపుల ఆజ్ఞలు రాయబడి ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","దేవుడు తానే ఆ రాళ్లను చేసాడు. మరియు దేవుడే ఆ రాళ్ల మీద ఆజ్ఞలు రాసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","వారు పర్వతం దిగి వెళ్తున్నప్పుడు ప్రజలు బస చేసిన చోటు నుండి వచ్చిన శబ్ధం యెహోషువా విన్నాడు, “కింద బసలో యుద్ధధ్వని వినిపిస్తున్నట్టుంది” అని మోషేతో యెహోషువా అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","“అందుకు మోషే, అది జయధ్వనులు చేస్తున్న సైన్యం శబ్దం కాదు. ఓటమివల్ల ఒక సైన్యం ఏడుస్తున్న శబ్దమూ కాదు అది, నాకు వినబడుతోన్నది సంగీత శబ్దం” అని జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","మోషే బసను సమీపించినప్పుడు, అతడు బంగారు దూడను, ప్రజలు నాట్యమాడటమూ చూసాడు. మోషేకు చాలా కోపం వచ్చి, ఆ ప్రత్యేక రాతి పలకలను నేలకేసి కొట్టాడు. పర్వతం కింది భాగంలో ఆ రాతి పలకలు ముక్కలు ముక్కలయ్యాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","అప్పుడు ప్రజలు చేసిన దూడను మోషే నాశనం చేసాడు. దాన్ని మంటల్లో వేసి కరిగించేసాడు. అప్పుడు ఆ బంగారం దుమ్ము అయ్యేంత వరకు నూరేసాడు. ఆ దుమ్మును నీళ్లలో పడేసి ఇశ్రాయేలు ప్రజల చేత బలవంతంగా ఆ నీళ్లు తాగించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","“ఈ ప్రజలు నీకేమి చేసారు? ఇలాంటి చెడ్డ పాపం చేయడానికి నీవెందుకు వాళ్లను నడిపించావు?” అని అహరోనును మోషే అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","“అయ్యా, కోపగించకు. ఈ ప్రజలు తప్పు చేసేందుకు ఎప్పుడూ సిద్ధమేనని నీకు తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","‘ఈజిప్టు నుండి మోషే మమ్మల్ని నడిపించాడు. అయితే అతనికి ఏమయిందో మాకు తెలియదు. కనుక మమ్మల్ని నడిపించేందుకు మా కోసం ఒక దేవతను తయారు చేయి’ అని ప్రజలు నాతో అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","కనుక ‘మీవద్ద ఉన్న బంగారు నగలను నాకు ఇవ్వండి’ అని ప్రజలతో చెప్పాను. ప్రజలు వారి బంగారం నాకు ఇచ్చారు. నేను ఆ బంగారాన్ని అగ్నిలో వేసాను. అగ్నిలో నుండి ఆ దూడ బయటకు వచ్చింది” అని అహరోను జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","అహరోను అక్కడ గలభాకు కారణమని మోషే తెలుసుకున్నాడు. శత్రువులంతా చూడుగలిగేటట్టు ప్రజలు వెర్రివాళ్లలా విచ్చలవిడిగా తిరుగుతున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","కనుక నివాసాల ప్రవేశం దగ్గర మోషే నిలబడ్డాడు. “యెహోవాను వెంబడించాలని కోరేవారు ఎవరో వారు నా దగ్గరకు రావాలి.” అన్నాడు. లేవీ కుటుంబానికి చెందిన ప్రజలంతా మోషే దగ్గరకు పరుగెత్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","అప్పుడు మోషే అన్నాడు, “ఇశ్రాయేలీయుల దేవుడైన యెహోవా ఏమి చెబతున్నాడో నేను మీకు చెబతాను. ‘ప్రతి మనిషీ తన కత్తి తీసుకొని మన బసలో ఒక చివర నుండి మరో చివరకు వెళ్లాలి. ప్రతి మనిషి తన సోదరుణ్ణి, స్నేహితుల్ని, ఇరుగు పొరుగువారిని పంపాల్సి వచ్చినా మీరు వారిని చంపాలి.’” ");
INSERT INTO tel2010_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","లేవీ కుటుంబానికి చెందిన ప్రజలు మోషే మాటకులోబడ్డారు. ఆ రోజు ఇశ్రాయేలీయులతో సుమారు 3,000 మంది చనిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","అప్పుడు, “మీ కుమారులను మీ సోదరులను దీవించే వారినిగా యెహవా నేడు మిమ్మల్ని ఏర్పరచుకున్నాడు” అని మోషే చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","మర్నాటి ఉదయం ప్రజలందరికీ మోషే, “మీరు భయంకర పాపం చేసారు. అయితే ఇప్పుడు నేను యెహోవా దగ్గరకు పైకి వెళ్తాను. ఆయన మీ పాపం విషయం మిమ్మల్ని క్షమించేందుకు నేనేమైనా చేయగలనేమో” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","కనుక మోషే యెహోవా దగ్గరకు తిరిగి వెళ్లి, “దయచేసి ఆలకించు! ఈ ప్రజలు చాలా చెడ్డ పాపం చేసి, బంగారంతో దేవుణ్ణి చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ఇప్పుడు ఈ పాపం విషయం వారిని క్షమించు. నీవు గనుక వారిని క్షమించకపోతే, నీవు వ్రాసిన గ్రంథంలో నా పేరు తుడిచేయి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","అయితే మోషేతో యెహోవా అన్నాడు, “నాకు వ్యతిరేకంగా ఎవరు పాపం చేస్తారో ఆ ప్రజల పేర్లు మాత్రమే నా గ్రంథంలో నుండి తుడిచి వేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","కనుక కిందకు వెళ్లి, నేను నీకు చెప్పిన చోటుకు ప్రజలను నడిపించు. నీకు ముందు నా దేవదూత నడుస్తూ నిన్ను నడిపిస్తాడు. పాపం చేసిన వాళ్లను శిక్షించవలసిన సమయం వచ్చినప్పుడు వాళ్లు శిక్షించబడుతారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","కనుక ఆ ప్రజలకు భయంకర వ్యాధి వచ్చేటట్టు యెహోవా చేసాడు. వారు బంగారు దూడను చేయమని అహరోనుతో చెప్పినందువల్ల ఆయన అలా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","అయితే మోషేతో యెహోవా యిలా అన్నాడు: “ఈజిప్టు నుండి నీవు బయటకు తీసుకు వచ్చిన నీ ప్రజలూ, నీవూ ఇక్కడనుండి వెళ్లిపోవాలి. అబ్రాహాము, ఇస్సాకు, యాకోబలకు ఇస్తానని నేను వాగ్దానం చేసిన దేశానికి వెళ్లండి. నేను వాళ్లకు వాగ్దానం చేసాను. మీ సంతానమునకు ఆ దేశాన్ని ఇస్తానని నేను చెప్పాను. ");
INSERT INTO tel2010_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","మీకు ముందు వెళ్లడానికి ఒక దూతను నేను పంపిస్తాను. కనానీయులను, అమ్మోరీయులను, హిత్తీయులను పెరిజ్జీయులను. హివ్వీయులను, యెబూసీయులను నేను ఓడిస్తాను. ఆ ప్రజలు మీ దేశాన్ని విడిచి పెట్టేసేటట్టు బలవంతం చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","కనుక అనేక మంచి వాటితో నిండిన దేశానికి వెళ్లండి. కానీ నేను మీతో రాను. మీరు చాలా మొండివారు. నేను మీతో వస్తే మార్గంలో కోపంవచ్చి మిమ్మల్ని నేను నాశనం చేయవల్సి వస్తుందేమో.” ");
INSERT INTO tel2010_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ఈ దుర్వార్తను ప్రజలు విని చాలా విచారించారు. దీని తర్వాత ప్రజలు నగలు పెట్టుకోలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","“మీరు మొండివారు నేను మీతో కొంచెంసేపు ప్రయాణం చేసినా సరే నేను మిమ్మల్ని నాశనం చేయాల్సి వస్తుంది. కనుక మీ నగలన్నీ తీసి వేయండి. అప్పుడు మీ విషయం ఏమి చేయాలో నేను ఆలోచిస్తాను” అని మోషేతో యెహోవా చెప్పినందువల్ల వారు నగలు ధరించలేదు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","కనుక హోరేబు కొండ దగ్గర ఇశ్రాయేలు ప్రజలు వారి నగలన్నీ తీసి వేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","గుడారాన్ని, నివాస డేరాలకు కొంత దూరం బయటకు జరిపాడు మోషే. “సన్నిధి గుడారం” అని మోషే దానికి పేరు పెట్టాడు. ఏ వ్యక్తిగాని యెహోవాను ఏదైనా అడగాలంటే, నివాస డేరాలకు వెలుపల ఉన్న సన్నిధి గుడారానికి వెళ్లాల్సి వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ఎప్పుడేనా సరే, బయటకు ఆ గుడారానికి మోషే వెళ్తే ప్రజలంతా అతన్ని గమనిస్తూ ఉండేవారు. ప్రజలంతా వారి గుడారపు ద్వారం దగ్గర నిలబడి మోషే సన్నిధి గుడారంలో ప్రవేశించేవరకు అతణ్ణి గమనించి చుస్తుండేవారు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","మోషే సన్నిధి గుడారంలోకి వెళ్లినప్పుడల్లా స్తంభంలా నిలువుగా ఉన్న మేఘం నిలిచి ఉండేది. ఈ విధంగా మోషేతో యెహోవా మాట్లాడతాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","సన్నిధి గుడారపు ద్వారం దగ్గర మేఘాన్ని చూడగానే ప్రజలు యెహోవాను ఆరాధించుటకు సాష్టాంగపడేవారు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","మోషేతో ముఖాముఖీగా యెహోవా మాట్లాడాడు. ఒక మనిషి తన స్నేహితునితో మాట్లాడినట్లు మోషేతో యెహోవా మాట్లాడాడు. దేవునితో మాట్లాడిన తర్వాత, మోషే ఎప్పుడూ బసకు వెళ్లిపోయేవాడు. నూను కుమారుడైన యెహోషువ అనే ఒక యువకుడు మోషేకు సహాయకుడు. మోషే సన్నిధి గుడారం వదిలినప్పుడల్లా యెహోషువ సన్నిధి గుడారంలో నిలిచి ఉండేవాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","యెహోవాతో మోషే ఇలా అన్నాడు: “ఈ ప్రజల్ని నడిపించమని నీవు చెప్పావు. నాతో ఎవర్ని నీవు పంపిస్తావో నీవు చెప్పలేదు. ‘నీవు నాకు బాగా తెలుసు. నిన్ను గూర్చి నేను ఆనందిస్తున్నాను.’ అని నీవు నాతో చెప్పావు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","నిజంగా నేను నీక ఆనందం కలిగించి ఉంటే, నీ మార్గాలు నాకు బోధించు. నేను నిన్ను వాస్తవంగా తెలుసుకోవాలని కోరుతున్నాను. అలాగైతే, నేను ఎల్లప్పుడూ నిన్ను సంతోషపెడ్తూ ఉండగలుగుతాను. వీళ్లంతా నీ ప్రజలని జ్ఞాపకం ఉంచుకో.” ");
INSERT INTO tel2010_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","“నేను నీతో కూడా వస్తాను నేను మిమ్మల్ని నడిపిస్తాను” అని యెహోవా జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","అప్పుడు మోషే ఆయనతో అన్నాడు: “నీవు మాతో రాకపోతే మాత్రం, మమ్మల్ని యిక్కడ నుండి పంపించి వేయకు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","మరియు నా విషయంలో, ఈ ప్రజల విషయంలో నీవు సంతోషిస్తున్నట్టు మాకెలా తెలుస్తుంది? నీవు మాతో కూడా వస్తే, అప్పుడు మాకు తెలుస్తుంది. నీవు మాతో రాకపోతే, ఈ భూమి మీద ఉన్న ఏ ఇతర ప్రజలకంటే నేను, ఈ ప్రజలు ప్రత్యేకం కాదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","అప్పుడు మోషేతో యెహోవా ఇలా అన్నాడు: “నీవు అడిగినట్టు నేను చేస్తాను. నీ పట్ల నాకు ఆనందం గనుక నేను ఇలా చేస్తాను. నీవు నాకు బాగా తెలుసు.” ");
INSERT INTO tel2010_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","అప్పుడు మోషే, “అలాగైతే నీ మహిమ నాకు చూపించు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","అప్పుడు యెహోవా జవాబిచ్చాడు: “నా మంచితనం అంతా నీ ముందు నడిచేటట్లు చేస్తాను. నేను యెహోవాను. నీకు వినబడేటట్టు నా పేరు నేను ప్రకటిస్తాను. నేను ప్రకటించుకున్న వారికి ప్రేమ, దయ నేను చూపెడతాను. ");
INSERT INTO tel2010_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","కాని నా ముఖం నీవు చూడలేవు. ఏ మనిషీ నన్ను చూచి కూడా బ్రతకలేడు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","“అక్కడ నా దగ్గర ఒక చోట ఒక బండ వుంది. నీవు ఆ బండమీద నిలబడవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","నా మహిమ ఆ స్థలాన్ని దాటి వెళ్తుంది. ఆ బండలోని ఒక పెద్ద సందులో నేను నిన్ను ఉంచి, నేను దాటి వెళ్లేటప్పుడు, నా చేతితో నిన్ను కప్పుతాను. ");
INSERT INTO tel2010_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","అప్పుడు నేను నా చేయిని తీసివేస్తాను. నీవు నా వెనుకవైపు చూస్తావు. కాని నా ముఖం మాత్రము నీవు చూడలేవు.” ");
INSERT INTO tel2010_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","అప్పుడు మోషేతో యెహోవా ఇలాగు చెప్పాడు: “ముందు పగులగొట్టబడ్డ రెండు రాతి పలకల్లాంటివే మరో రెండు రాతి పలకలు తయారు చేయి. మొదటి రెండు రాళ్లమీద రాయబడ్డ మాటలే ఈ రాళ్ల మీద నేను రాస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","రేపు ఉదయం సిద్ధంగా ఉండు. సీనాయి కొండమీదికి రమ్ము. అక్కడ కొండ శిఖరం మీద నా ఎదుట నిలబడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","నీతో ఇంక ఏ వ్యక్తీ రావడానికి వీలులేదు. కొండమీద ఎక్కడా ఏ వ్యక్తి కనబడకూడదు. కనీసం ఆ కొండ కిందకూడ నీ పశువుల మందలు కాని, గొర్రెల మందలు గాని మేత కూడ మేయకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","కనుక మొదటి వాటిలాగే మరో రెండు రాతి పలకలను మోషే చేసాడు. ఆ మర్నాడు ఉదయాన్నే సీనాయి కొండ మీదికి అతడు వెళ్లాడు. యెహోవా అతనికి ఆజ్ఞాపించిన ప్రకారమే అంతా చేసాడు. ఆ రెండు రాతి పలకలను మోషే తీసుకొని వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","మోషే కొండ మీద ఉన్నప్పుడు, ఒక మేఘం మీద యెహోవా దిగి వచ్చాడు. అక్కడ మోషే దగ్గర యెహోవా నిలబడ్డాడు. అతడు యెహోవాను పేరుపెట్టి పిలిచాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","మోషే ఎదుట యెహోవా దాటి వెళ్తూ ఇలా అన్నాడు: “యెహోవా దయ, జాలిగల దేవుడు. యెహోవా త్వరగా కోపపడడు. యెహోవా మహా ప్రేమపూర్ణుడు. యెహోవా నమ్ముకోదగినవాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","వేలాది తరాలకు దయచూపించే వాడు యెహోవా. ప్రజలు చేసే తప్పులను యెహోవా క్షమిస్తాడు. అయితే నేరస్తులను శిక్షించడం యెహోవా మరచిపోడు. నేరస్తులను యెహోవా శిక్షించడమే కాదు, వారు చేసే తప్పులవల్ల వారి పిల్లలు, మనుమళ్లు, మూడు నాలుగు తరాల వరకు శ్రమ అనుభవిస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","వెంటనే మోషే సాష్టాంగపడి యెహోవాను ఆరాధించాడు. మోషే ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“ప్రభూ, నా విషయం నీకు ఇష్టమైతే దయచేసి మాతోకూడా రమ్ము. వీళ్లు మొండి ప్రజలని నాకు తెలుసు. అయితే మేము చేసిన తప్పుల విషయంలో మమ్మల్ని క్షమించు. మమ్మల్ని నీ ప్రజలుగా స్వీకరించు.” ");
INSERT INTO tel2010_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","అప్పుడు యెహోవా చెప్పాడు: “నీ ప్రజలందరితో నేను ఈ ఒడంబడికను చేస్తున్నాను. భూమి మీద ఈ జనం కోసం ఇదివరకు ఎన్నడూ చేయని అద్భుతకార్యాలు నేను చేస్తాను. యెహోవానైన నేను మహాఘనుడనని నీతో ఉన్న ప్రజలు చూస్తారు. నేను నీ కోసం చేసే అద్భుత కార్యాలను వారు చూస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ఈ వేళ నీకు నేను ఆజ్ఞాపిస్తున్న విషయాలకు లోబడు, నీ శత్రువులు నీ దేశము వదలివెళ్లి పోయేటట్టు నేను వారిని బలవంతం చేస్తాను. అమోరీయులను, కనానీయలను, హిత్తీయులను, పెరిజీయులను, హివ్వీయులను, యెబసీయులను నేను బయటకు వెళ్ళగొడతాను. ");
INSERT INTO tel2010_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","జాగ్రత్తగా ఉండు! నీవు వెళ్తోన్న దేశంలో నివసించే ప్రజలతో ఎలాంటి ఒడంబడిక చేయకు. ఆ ప్రజలతో నీవు ఏదైనా ఒడంబడిక చేస్తే, అది నీకు చిక్కు తెచ్చిపెడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","అయితే వారి బలిపీఠాలు నాశనం చేయి. వారు పూజించే రాళ్లను విరుగగొట్టు. వారి విగ్రహాలను నరికి వెయ్యి. ");
INSERT INTO tel2010_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","మరో దేవుడ్ని ఎవర్నీ ఆరాధించవద్దు. నేను ఎల్కానా, రోషముగల యెహోవాను. అది నా పేరు. నేను ఎల్కానా, అంటే రోషముగల దేవుడ్ని. ");
INSERT INTO tel2010_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“ఆ దేశములో నివసించే ప్రజలతో ఎలాంటి ఒడంబడిక చేయకుండా జాగ్రత్తగా ఉండు. నీవు గనుక అలా చేస్తే, వారు వారి వారి దేవతలను ఆరాధించేటప్పుడు వాళ్లతో కలవమని ఆ ప్రజలు నిన్ను పిలుస్తారు. వాళ్ల బలుల మాంసం నీవు తినకుండ జాగ్రత్త పడుము. ");
INSERT INTO tel2010_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","వారి కూతుళ్లు కొందరిని మీ కుమారులకు భార్యలుగా మీరు చేసుకుంటారేమో. ఆ కూతుళ్లు తప్పుడు దేవతలను సేవిస్తారు. మీ కుమారులు కూడా అలాగే చేసేటట్టు వారు నడిపించవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“విగ్రహాలు చేసుకోవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“పులియని రొట్టెల పండుగ ఆచరించు. నేను ఇదివరకు మీతో చెప్పిన ప్రకారము పులియచేసే పదార్థం లేకుండా తయారు చేయబడిన రొట్టెలను ఏడు రోజులపాటు తినాలి. నేను ఏర్పరచుకున్న అబీబు నెలలో దీన్ని చేయాలి. ఎందుకంటే మీరు ఈజిప్టు నుండి బయటకు వచ్చిన నెల అది. ");
INSERT INTO tel2010_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ఒక స్త్రీకి పుట్టిన ప్రథమ శిశువు ఎల్లప్పుడూ నాకే చెందుతుంది. మీ పశువులకు, గొర్రెలకు మొదటిదిగా పుట్టే పిల్లలు కూడా నాకే చెందుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","మొదటిదిగ పుట్టిన ఒక గాడిదను నీవు ఉంచుకోవాలంటే ఒక గొర్రె పిల్లను యిచ్చి నీవు దాన్ని కొనుక్కోవచ్చు. అయితే నీవు ఒక గొర్రె పిల్లను యిచ్చి ఆ గాడిదను కొనకపోతే, ఆ గాడిద మెడ నీవు విరుగగొట్టాలి. ప్రథమ సంతానమైన నీ కుమారులందరినీ నా దగ్గర్నుంచి నీవు కొనాలి. కానుక లేకుండా ఏ మనిషీ నా దగ్గరకు రాకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ఆరు రోజులు నీవు పనిచేస్తావు. అయితే ఏడో రోజున నీవు విశ్రాంతి తీసుకోవాలి. నాట్లు వేసేటప్పుడు, కోత కోసేటప్పుడు గూడ నీవు విశ్రాంతి తీసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“నీవు వారాల పండుగ ఆచరించాలి. గోధుమ కోతలో నుండి మొదటి గింజల్ని ఈ పండుగకు వినియోగించాలి. సంవత్సరాంతములో కోతకాలపు పండుగ ఆచరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“ప్రతి సంవత్సరమూ మూడుసార్లు మీ పురుషులంతా మీ యజమానీ, ఇశ్రాయేలీయుల దేవుడైన యెహోవా తోఉండేందుకు వెళ్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“మీరు మీ దేశంలోకి వెళ్లినప్పుడు, ఆ దేశంలో నుండి మీ శత్రువులను నేను వెళ్లగొట్టి వేస్తాను. మీ సరిహద్దులను నేను విశాలం చేస్తాను. మీకు ఇంకా భూమి లభిస్తుంది. ప్రతి సంవత్సరం మూడు సార్లు మీరు యెహోవా దేవుని ఎదుటకి వెళ్లాలి. ఆ సమయంలో ఎవ్వరూ మీ భూమిని మీ దగ్గర నుండి తీసుకునేందుకు ప్రయత్నించరు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“బలి రక్తం నీవు నాకు అర్పిస్తే పులిసిన పదార్థము ఏదీ దానితోపాటు అర్పించవద్దు. “పస్కా భోజనంలోని మాంసం ఏ మాత్రము మరునాటి ఉదయానికి మిగులకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“మీ కోతలో నుండి మొట్టమొదటి పంట యెహోవాకు ఇవ్వాలి. మీ యెహోవా దేవుని ఆలయములోనికి వాటిని తీసుకొని రావాలి. “మేక పిల్లను దాని తల్లి పాలతో ఎన్నడూ వండకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","అప్పుడు మోషేతో యెహోవా, “నేను నీకు చెప్పిన విషయాలన్నీ రాయి. నీతోను, ఇశ్రాయేలు ప్రజలతోను నేను చేసిన ఒడంబడిక విషయాలు అవి” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","నలభై పగళ్లు నలభై రాత్రుళ్లు మోషే అక్కడే యెహోవాతో ఉన్నాడు. ఆ సమయంలో అతను భోజనం చేయలేదు, నీళ్లు తాగలేదు. ఒడంబడిక మాటలు అంటే పది ఆజ్ఞలు రెండు రాతి పలకల మీద మోషే వ్రాసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","అప్పుడు మోషే సీనాయి పర్వతం కిందికి వచ్చాడు. దేవుని ఆజ్ఞలు రాయబడ్డ ఆ రెండు రాతి పలకలనూ, అతను పట్టుకొచ్చాడు. మోషే యెహోవాతో మాట్లాడాడు. కనుక అతని ముఖం ప్రకాశిస్తూ ఉండినది. అయితే అది మోషేకు తెలియదు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","మోషే ముఖం మెరిసిపోతూ ప్రకాశిస్తూ ఉండటం అహరోను, ఇశ్రాయేలు ప్రజలందరూ చూశారు. అందుచేత అతని దగ్గరకు వెళ్లడానికి భయపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","అయితే మోషే వాళ్లను పిలిచాడు. కనుక అహరోను, ప్రజానాయకులు అందరూ మోషే దగ్గరకు వెళ్లారు. మోషే వాళ్లతో మాట్లాడాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ఆ తర్వాత, ఇశ్రాయేలు ప్రజలంతా మోషే దగ్గరకు వచ్చారు. సీనాయి కొండ మీద యెహోవా తనకు ఇచ్చిన ఆజ్ఞలను మోషే వారికీ ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","మోషే ప్రజలతో మాట్లాడ్డం ముగించగానే తన ముఖం మీద ముసుగు కప్పుకున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","యెహోవాతో మాట్లాడేందుకు ఆయన ఎదుటికి వెళ్లినప్పుడల్లా మోషే తన ముఖం మీద ముసుగు తీసివేసాడు. తరువాత మోషే బయటకు వచ్చి — యెహోవా ఆజ్ఞాపించిన విషయాలను ఇశ్రాయేలు ప్రజలకు చెప్పేవాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","మోషే ముఖం ప్రకాశంగా మెరిసిపోతున్నట్టు ప్రజలు చూసేవాళ్లు కనుక మోషే మరల తన ముఖం కప్పుకొనేవాడు. మరల యెహోవాతో మాట్లాడేందుకు వెళ్లేంతవరకు మోషే తన ముఖం పైనుండి ముసుకును తీసే వాడుకాదు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ఇశ్రాయేలు ప్రజలందర్నీ మోషే సమావేశ పర్చాడు. మోషే వారితో చెప్పాడు: “మీరు చేయాలని యెహోవా ఆజ్ఞాపించిన విషయాలు నేను మీకు చెబతాను. ");
INSERT INTO tel2010_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“పని చేయడానికి ఆరు రోజులున్నాయి. అయితే ఏడో రోజు మీకు చాల ప్రత్యేకమైన విశ్రాంతి రోజు. ఆ ప్రత్యేక దినాన విశ్రాంతి తీసుకోవడంవల్ల మీరు యెహోవాను ఘనపరుస్తారు. ఏడో రోజున పనిచేసే వ్యక్తిని చంపెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","సబ్బాతు రోజున మీరు నివసించే స్థలాల్లో నిప్పు కూడ రాజబెట్టకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ఇశ్రాయేలు ప్రజలందరితో మోషే ఇలా చెప్పాడు: “యెహోవా ఆజ్ఞాపించినది ఇదే. ");
INSERT INTO tel2010_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","యెహోవా కోసం ప్రత్యేక కానుకలు సమకూర్చండి. మీరు ఏమి ఇస్తారో మీలో ప్రతి ఒక్కరూ మీ హృదయంలో తీర్మానం చేసుకోవాలి. అప్పుడు ఆ కానుక యెహోవా కోసం తీసుకుని రావాలి. బంగారం, వెండి, ఇత్తడి. ");
INSERT INTO tel2010_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","నీలం, ధూమ్ర వర్ణం, ఎరుపు బట్ట, శ్రేష్ఠమైన సన్నటి బట్ట, మేక బొచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ఎరుపు రంగు వేసిన గొర్రె తోళ్లు, మంచి చర్మాలు, తుమ్మ కర్ర, ");
INSERT INTO tel2010_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","దీపాల కోసం ఒలీవ నూనె, అభిషేక తైలం కోసం పరిమళ ద్రవ్యాలు, సువాసన ధూపంకోసం పరిమళ ద్రవ్యాలు, ");
INSERT INTO tel2010_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","లేతపచ్చ రాళ్లు, యితర నగలు కానుకలుగా తీసుకు రావాలి. యాజకులు ధరించే ఏఫోదు, న్యాయ తీర్పు పైవస్త్రం మీద ఈ రాళ్లు, నగలు అమర్చబడుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“నైపుణ్యంగల వాళ్లందరూ యెహోవా ఆజ్ఞాపించిన వీటన్నింటినీ చేయాలి. (యెహోవా ఆజ్ఞాపించిన వస్తువులు ఇవి): ");
INSERT INTO tel2010_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","పవిత్ర గుడారం, దాని బయటి గుడారం, దాని కప్పు, కొక్కీలు, చట్రాలు, అడ్డకర్రలు, స్తంభాలు, దిమ్మలు, ");
INSERT INTO tel2010_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ఒడంబడిక పవిత్ర పెట్టె, దాని కర్రలు, పెట్టెను మూసే దాని మూత, పెట్టె ఉండే చోటును కప్పి ఉంచే తెర ");
INSERT INTO tel2010_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","బల్ల, దాని కర్రలు, బల్ల మీద వస్తువులన్నీ, బల్ల మీద ఉండే ప్రత్యేక రొట్టె, ");
INSERT INTO tel2010_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","వెలుగు కోసం ఉపయోగించే దీప స్తంభం, దీప స్తంభానికి సంబంధించిన వస్తువులన్నీను, దీపాలు, దీపానికి నూనె, ");
INSERT INTO tel2010_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ధూపం వేసేందుకు బలిపీఠం, దాని కర్రలు, అభిషేక తైలం, సువాసన గల ధూపద్రవ్యాలు, పవిత్ర గుడారం, ప్రవేశం దగ్గర ద్వారాన్ని కప్పి ఉంచే తెర, ");
INSERT INTO tel2010_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","అర్పణలు దహించే బలిపీఠం, దాని ఇత్తడి తెర, కర్రలు, బలిపీఠం దగ్గర ఉపయోగించే అన్ని వస్తువులు, గంగాళం, దాని పీట, ");
INSERT INTO tel2010_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ఆవరణపు తెరలు, వాటి కర్రలు, దిమ్మలు, ఆవరణ ద్వారపు తెర ");
INSERT INTO tel2010_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","గుడారం, ఆవరణ గుడారం పట్టి ఉంచే మేకులు, మేకులకు కట్టే తాళ్లు, ");
INSERT INTO tel2010_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","పరిశుద్ధ స్థలంలో యాజకులు ధరించే ప్రత్యేక నేత వస్త్రాలు. యాజకుడైన అహరోను, అతని కుమారులు ధరించాల్సిన ప్రత్యేక వస్త్రాలు ఇవి. వాళ్లు యాజకులుగా సేవ చేసేటప్పుడు ఈ వస్త్రాలు ధరిస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","అప్పుడు ప్రజలంతా మోషే దగ్గర్నుంచి వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ఇవ్వాలి అనుకొన్న ప్రజలంతా వచ్చి యెహోవాకు కానుక తెచ్చారు. సన్నిధి గుడారం, గుడారంలోని సమస్త సామగ్రి, ప్రత్యేక వస్త్రాలు చేసేందుకు ఈ కానుకలు ప్రయోగించబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ఇవ్వాలనుకున్న స్త్రీ పురుషులంతా అన్ని రకాల బంగారు వస్త్రాలూ తెచ్చారు. పిన్నులు, చెవిపోగులు, ఉంగరాలు, ఇతర బంగారు వస్తువులు వారు తీసుకు వచ్చారు. వాళ్లంతా వారి బంగారాన్ని యెహోవాకు ఇచ్చారు. ఇది యెహోవాకు ప్రత్యేక అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","నాణ్యమైన బట్ట, నీలం, ధూమ్రవర్ణం, ఎరుపు బట్ట ఉన్న ప్రతి వ్యక్తీ వాటిని యెహోవా కోసం తెచ్చాడు. మేక బొచ్చు, లేక ఎరుపు రంగు వేయబడ్డ గొర్రె చర్మాలు లేక నాణ్యమైన తోలు ఉన్నవారు ఎవరైనా సరే వాటిని యెహోవా కోసం తెచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","వెండిని లేక ఇత్తడి ఇవ్వాలనుకున్న ప్రతి వ్యక్తీ వచ్చి, దానిని యెహోవాకు కానుకగా తెచ్చారు. తుమ్మకర్ర ఉన్న ప్రతి వ్యక్తీ వచ్చి, దానిని యెహోవాకు కానుకగా ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","నిపుణతగల ప్రతి స్త్రీ నాణ్యమైన బట్ట, నీలం, ధూమ్ర వర్ణం, ఎరుపు బట్ట తయారు చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","సహాయం చేయాలనుకొన్న నైపుణ్యంగల స్త్రీలంతా మేక వెంట్రుకలతో వస్త్రాలు తయారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","పెద్దలు లేతపచ్చలు, ప్రశస్తమైన ఇతర రాళ్లు తెచ్చారు. యాజకుని ఏఫోదు, న్యాయతీర్పు పైవస్త్రం మీద ఈ రాళ్లు రత్నాలు అమర్చబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","సుగంధ ద్రవ్యాలు, ఒలీవ నూనె కూడ ప్రజలు తెచ్చారు. సువాసనగల పరిమళ ద్రవ్యం, అభిషేక తైలం, దీపాల నూనె కోసం ఉపయోగించబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","సహాయం చేయాలనుకొన్న ఇశ్రాయేలు ప్రజలంతా యెహవాకు కానుకలు తెచ్చారు. ఈ కానుకలు ఉచితం, మరియు ప్రజలు ఇవ్వాలనుకొన్నారు గనుక వాటిని ఇచ్చారు. మోషేకు, ప్రజలకు యెహోవా ఇచ్చిన ఆజ్ఞ ప్రకారం చేసేందుకు ఈ కానుకలు ఉపయోగించబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","అప్పుడు ప్రజలతో మోషే ఇలా అన్నాడు: “చూడండి, యూదా గోత్రానికి చెందిన ఊర్ కుమారుడు బెసలేలును యెహోవా ఏర్పరచుకొన్నాడు. (హోరు కుమారుడు ఊర్). ");
INSERT INTO tel2010_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","బెసలేలును యెహోవా తన ఆత్మతో నింపాడు. అన్ని రకాల పనులు చేయడానికి యెహోవా అతనికి నైపుణ్యం ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","అతడు నమూనాలు చేసి బంగారం, వెండి, ఇత్తడితో వస్తువులు చేయగలడు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","ప్రశస్తమైన రాళ్లను రత్నాలను చెక్కిసానబెట్టగలడు. బెసలేలు చెక్కపని చేసి అన్ని రకాల వస్తువులు తయారు చేయగలడు. ");
INSERT INTO tel2010_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ఇతరులకు నేర్పించగల నైపుణ్యాన్ని బెసలేలుకు, అహోలీయాబుకు దేవుడు యిచ్చాడు. (దాను గోత్రానికి చెందిన అహీసామాకు కుమారుడు అహోలియాబు). ");
INSERT INTO tel2010_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","అన్ని రకాల పనులు చేయటానికి ప్రత్యేక నైపుణ్యాన్ని యెహోవా వారికి ఇచ్చాడు. వడ్లవాని పనులు, లోహపు పనులు వారు చేయగలరు. నీలం, ధూమ్రవర్ణం, ఎరుపు, నాణ్యమైన బట్టల మీద బుటా పని వారు చేయగలరు. ఉన్ని వస్త్రాలను వారు నేయగలరు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“కనుక బెసలేలు, అహోలియాబు, ఇంకా నైపుణ్యంగల పురుషులందరూ యెహోవా ఆజ్ఞాపించిన పనులన్నీ చేస్తారు. ఈ పరిశుద్ధ స్థలం నిర్మించేందుకు అవసరమైన వాటిన్నింటినీ చేయటానికి అవసరమైన జ్ఞానం, అవగాహన దేవుడు ఈ మనుష్యులకు ఇచ్చాడు.” ");
INSERT INTO tel2010_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","తర్వాత బెసలేలును, అహోలియాబను, యెహోవా నైపుణ్యాన్ని ఇచ్చిన ఇతర నిపుణులను మోషే పిలిచాడు. పనిలో సహాయం చేయాలని వీళ్లంతా వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","ఇశ్రాయేలు ప్రజలు కానుకగా తెచ్చిన వస్తువులన్నింటినీ మోషే ఈ మనుష్యులకు ఇచ్చాడు. పవిత్ర గుడారం నిర్మించడానికి వీటన్నింటినీ వారు ఉపయోగించారు. ప్రతి ఉదయం ప్రజలు కానుకలు తెస్తున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","చివరకు నిపుణలైన పని వాళ్లు ఒక్కొక్కరు, ఆ పవిత్ర స్థలంలో వారు చేస్తున్న పని విడిచి పెట్టి, మోషేతో మాట్లాడటానికి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","“ప్రజలు కానుకలను విపరీతంగా తెచ్చేసారు. గుడారం పని ముగించడానికి కావలసిన దానికంటే మా దగ్గర ఎక్కువే ఉంది” అన్నారు వారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","అప్పుడు, “ఇంక ఏ స్త్రీగాని, పురుషుడుగాని గుడారం కోసం ఏ విధమైన కానుకా తీసుకురాకూడదు” అని బస అంతటికీ మోషే కబురు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","పవిత్ర స్థలానికి అవసరమైన దానికంటే ఎక్కువ వస్తువులను ప్రజలు సిద్ధం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","అప్పుడు నిపుణులు పవిత్ర గుడారం తయారు చేయటం మొదలు పెట్టారు. నీలం, ఎరుపు సన్నని నారబట్టతో పది తెరలు వారు చేసారు. రెక్కలు గల కెరూబుల చిత్రాలను ఆ బట్ట మీద వారు కుట్టి పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ప్రతి తెరా ఒకే కొలత. అది 14 గజాలు పొడువు, 2 గజాల వెడల్పు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","అయిదు తెరలు కలిపి ఒక భాగంగాను మిగిలిన అయిదు ముక్కలు కలిపి మరో భాగంగాను కలపబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","తర్వాత మొదటి అయిదు తెరల భాగానికి బట్ట అంచు వెంబడి నీలం గుడ్డతో ఉంగరాలు చేస్తారు. మరో అయిదు ముక్కల భాగానికి కూడ అలానే చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ఒక భాగంలో చివరి తెర మీద 50 ఉంగరాలు మరో భాగంలో చివర తెర మీద 50 ఉంగరాలు ఉన్నాయి. ఈ ఉంగరాలు ఒక దానికి ఒకటి ఎదురెదురుగా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","అప్పుడు వారు 50 బంగారు ఉంగరాలు చేసారు. రెండు తెరలను ఒకటిగా కలిపేందుకు ఈ బంగారు ఉంగరాలను వారు ఉపయోగించారు. అందుచేత గుడారం మొత్తం పవిత్ర స్థలంగా కలపబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","అప్పుడు పవిత్ర గుడారం పైకప్పు కోసం మేక వెంట్రుకలతో 11 తెరలను పనివారు తయారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","మొత్తం 11 తెరలు ఒకే కొలత గలవి. వాటి పొడువు 15 గజాలు వెడల్పు 2 గజాలు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","అయిదు తెరలను ఒక భాగంగా కలిపి కుట్టారు. పనివాళ్లు తర్వాత ఆరు తెరలను మరో భాగంగా కలిపి కుట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","మొదటి భాగంలోని చివరి తెర అంచుకు 50 ఉంగరాలు అమర్చారు. మరో భాగంలోని చివరి తెర అంచుకు 50 ఉంగరాలు అమర్చారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","ఈ రెండు భాగాలను ఒక్కటిగా కలిపేందుకు 50 ఇత్తడి కొలుకులను పనివారు తయారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","తర్వాత గుడారానికి ఇంకా రెండు పై కప్పులను వారు తయారు చేసారు. ఒక పై కప్పు ఎరుపు రంగు వేసిన గొర్రె చర్మంతోను, మరొకటి నాణ్యమైన తోలుతోను చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","తర్వాత తుమ్మ కర్రతో పనివారు పలకలు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ఒక్కో పలక పొడవు 15 అడుగులు వెడల్పు 27 అంగుళాలు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ఒక్కో పలక అడుగున పక్క పక్కగా రెండు కొక్కీలు ఉన్నాయి. పవిత్ర గుడారపు పలకల్లో ప్రతి ఒక్కటీ ఇలాగే చేయబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","గుడారం దక్షిణ భాగానికి 20 చట్రాలను వారు తయారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ఆ తర్వాత ఈ 20 చట్రాల కింద పెట్టడానికి 40 వెండి దిమ్మలను వారు చేసారు. ప్రతి పలకకీ రెండేసి దిమ్మలు ఉన్నాయి. ఒక్కో బల్ల కింద ప్రతి పక్కా కర్రలు, ఒక దిమ్మ. ");
INSERT INTO tel2010_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","గుడారం అవతలి వైపుకు (ఉత్తరం వైపు) కూడా వారు 20 పలకలు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","ఒక్కో చట్రం కిందా రెండేసి చొప్పున 40 వెండి దిమ్మలు అతడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","పవిత్ర గుడారం వెనుక భాగానికి (పడమటి వైపున) ఆరు పలకలు అతడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","పవిత్ర గుడారం వెనుక వైపు మూలలకు రెండు చట్రాలు అతడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ఈ చట్రాలు అడుగు భాగాన కలిపి బిగించబడ్డాయి. పై భాగాన అది జతచేయబడ్డ ఉంగరంలో అమర్చబడ్డాయి. ప్రతి మూలకూ అతడు ఇలాగే చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","కనుక పవిత్ర గుడారం పశ్చిమాన 8 చట్రాలు, 16 వెండి దిమ్మలు అంటే ఒక్కో చట్రం కింద రెండేసి దిమ్మలు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","తర్వాత అతడు తుమ్మ కర్రతో అడ్డ కర్రలు చేసాడు — పవిత్ర గుడారం మొదటి పక్కకు 5 అడ్డ కర్రలు, ");
INSERT INTO tel2010_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","పవిత్ర గుడారం రెండో పక్కకు 5 అడ్డ కర్రలు, గుడారం వెనుక పక్కకు 5 అడ్డ కర్రలు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ఒక్కో చట్రంలోనుంచి దూరి అన్ని చట్రాల గుండా అమర్చబడేటట్టు మధ్య అడ్డ కర్రను అతడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ఈ చట్రాలను బంగారంతో అతడు తాపడం చేసాడు. అడ్డ కర్రలను పట్టి ఉంచేందుకు బంగారు ఉంగరాలను అతడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","తర్వాత అతి పవిత్ర స్థలం యొక్క ప్రవేశ ద్వారానికి తెరను వారు చేయటానికి నాణ్యమైన సన్నని నారబట్ట, నీలం, ఎరుపు, ధూమ్ర వర్ణపు బట్ట వారు ఉపయోగించారు. నాణ్యమైన బట్టమీద కెరూబుల చిత్రాలను అతడు కుట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","తుమ్మ కర్రతో నాలుగు స్తంభాలు చేసి వాటికి బంగారం తాపడం చేసారు. ఆ స్తంభాలకు బంగారు కొక్కీలు వారు చేసారు. ఆ స్తంభాలకు నాలుగు వెండి దిమ్మలను వారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","తర్వాత గుడారం ప్రవేశ ద్వారానికి ఒక తెరను వారు తయారు చేసారు. నాణ్యమైన బట్ట, నీలం, ధూమ్ర వర్ణం, ఎరుపు బట్టను వారు ఉపయోగించారు. ఆ బట్ట మీద చిత్ర పటాల బుటాపని వారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","తర్వాత ఈ తెరకోసం అయిదు స్తంభాలు, కొక్కీలు వారు చేసారు. స్తంభాల శిఖరాలకు, తెరల కడ్డీలకు అతడు బంగారు తాపడం చేసాడు. స్తంభాలకు అయిదు ఇత్తడి దిమ్మలను వారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","తుమ్మ కర్రతో పవిత్ర పెట్టెను బెసెలేలు చేసాడు. ఆ పెట్టె పొడవు 45 అంగుళాలు, వెడల్పు 27 అంగుళాలు. ఎత్తు 27 అంగుళాలు, ");
INSERT INTO tel2010_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","పెట్టె లోపల, బయట స్వచ్ఛమైన బంగారంతో అతడు తాపడం చేసాడు. తర్వాత పెట్టె చుట్టూ బంగారు నగిషీబద్ద కట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","బంగారు ఉంగరాలు నాలుగు చేసి నాలుగు మూలలా వాటిని అమర్చాడు. పెట్టె మోయటానికి ఈ ఉంగరాలు ఉపయోగించబడ్డాయి. ఒక్కో ప్రక్క రెండేసి ఉంగరాలు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","తర్వాత పెట్టెను మోసేందుకు కర్రలను అతడు చేసాడు. తుమ్మ కర్రతో చేసి ఆ కర్రలకు స్వచ్ఛమైన బంగారం తాపడం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","పెట్టెకు ఒక్కో ప్రక్క ఉంగరాల గుండా కర్రలను దూర్చిపెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","తర్వాత స్వచ్ఛమైన బంగారంతో అతడు మూత చేసాడు. దాని పొడవు 45 అంగుళాలు, వెడల్పు 27 అంగుళాలు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","తర్వాత బెసలేలు కొట్టబడ్డ బంగారంతో రెండు కెరూబలను చేసాడు. ఆ కెరూబలను మూత కొనల మీద ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ఒక కొనమీద ఒక కెరూబను, మరో కొనమీద మరో కెరూబును ఉంచాడు. అంతా ఒకే భాగంలో ఉండేటట్టు ఆ కెరూబులు మూతతో కలిపి చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","కెరూబుల రెక్కలు ఆకాశంవైపు విప్పబడ్డాయి. ఆ కెరూబుల రెక్కలు పెట్టెను కప్పి ఉంచాయి. కెరూబులు ఎదురెదురుగా మూతను చూస్తూ ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","తర్వాత అతడు తుమ్మ కర్రతో బల్లను చేసాడు. ఆ బల్ల పొడవు 36 అంగుళాలు, వెడల్పు 18 అంగుళాలు, ఎత్తు 27 అంగుళాలు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","అతడు ఆ బల్లను బంగారంతో తాపడం చేసాడు. బల్ల నాలుగు ప్రక్కల బంగారు నగిషీబద్ద చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","అప్పుడు అతడు ఆ బల్ల చుట్టూ మూడు అంగుళాల చట్రం చేసాడు. ఆ చట్రం మీద బంగారు నగిషీబద్దను అతడు ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","అప్పుడు అతడు ఆ బల్లకు నాలుగు బంగారు ఉంగరాలు చేసాడు. నాలుగు మూలలా నాలుగు బంగారు ఉంగరాలు అతడు అమర్చాడు. అక్కడే నాలుగు కాళ్లు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ఉంగరాలను బల్ల పైభాగంలో చట్రానికి దగ్గరగా అతడు పెట్టాడు. బల్లను మోసేందుకు ఉపయోగించే కర్రలను ఉంగరాలు పట్టి ఉంచుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","తర్వాత బల్లలను మోసేందుకు కర్రలను అతడు చేసాడు. తుమ్మ కర్ర ఉపయోగించి చేసిన, ఆ కర్రలకు స్వచ్ఛమైన బంగారు పూత పూసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","అప్పుడు బల్ల మీద ప్రయోగించే వస్తువులన్నింటినీ తయారు చేసాడు. పానార్పణము పోసేందుకు పళ్లెములు, గరిటెలు, గిన్నెలు, పాత్రలు అతడు తయారు చేసాడు. ఇవన్నీ స్వచ్ఛమైన బంగారంతో తయారు చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","తర్వాత అతడు దీపస్తంభం చేసాడు. స్వచ్ఛమైన బంగారం ఉపయోగించి, దాని దిమ్మను, స్తంభాన్ని తీర్చిదిద్దాడు. తర్వాత పువ్వుల్లా కనపడే గిన్నెలు చేసాడు. గిన్నెలకు మొగ్గలు, పువ్వులు ఉన్నాయి. అన్నీ స్వచ్ఛమైన బంగారంతోనే చేయబడ్డాయి. ఈ వస్తువులన్నీ ఒకే భాగంగా కలుపబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","దీపస్తంభం ప్రక్కల్లో ఆరు కొమ్మలు ఉన్నాయి. ఒక పక్క మూడు కొమ్మలు, మరో పక్క మూడు కొమ్మలు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ఒక్కో కొమ్మకు మూడేసి బంగారు పూలున్నాయి. ఈ పూలు బాదం పూలవలె చేయబడ్డాయి. వాటికి మొగ్గలు, రేకులు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","బంగారంతో చేయబడ్డ నాలుగు పూవులు దీపస్తంభంపు కాండానికి ఉన్నాయి. అవి కూడా మొగ్గలు, రేకులతో బాదం పూవుల్లానే ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ఆరు కొమ్మలు రెండేసి చొప్పున మూడు భాగాలుగా ఉన్నాయి. ఒక్కో కొమ్మ విభాగం కింద ఒక్కో మొగ్గ ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","మొగ్గలు, కొమ్మలు, దీపస్తంభం అన్నీ స్వచ్ఛమైన బంగారంతో చేయబడ్డాయి. ఈ బంగారం అంతా కొట్టబడి, ఒకే భాగంగా చేయబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","ఈ దీపస్తంభానికి అతడు ఏడు దీపాలు చేసాడు. తర్వాత అతడు పళ్లెం, పట్టకారులు చేసాడు. సమస్తం స్వచ్ఛమైన బంగారంతో చేయబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","దీపస్తంభం, దాని పరికరాలు అన్నీ తయారు చేయడానికి అతడు 75 పౌన్ల స్వచ్ఛమైన బంగారం ఉపయోగించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","ధూపం వేసేందుకు అతడు ధూప వేదిక చేసాడు. తుమ్మ కర్రతో అతడు దీన్ని చేసాడు. వేదిక చతురస్రాకారం. దాని పొడవు 18 అంగుళాలు, వెడల్పు 18 అంగుళాలు, ఎత్తు 36 అంగుళాలు. వేదిక మీద నాలుగు కొమ్మలు ఉన్నాయి. ఒక్కొక్క మూలను ఒక్కొక్క కొమ్మ ఉంది. ఈ కొమ్మలు వేదికతో కలిపి ఒకే భాగంగా చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","పై భాగం, అన్ని ప్రక్కలు, కొమ్మలకీ అతడు బంగారు తాపడం చేసాడు. తర్వాత అతడు బలిపీఠం చుట్టూ బంగారు నగిషీబద్ద చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","బలిపీఠానికి అతడు రెండు బంగారు ఉంగరాలు చేసాడు. బలపీఠం నగిషీబద్దకు అడుగు భాగాన ఒక్కో ప్రక్క ఒక్కోటిగా బంగారు ఉంగరాలను అమర్చాడు. వేదికను మోసే కర్రలను ఈ బంగారు ఉంగరాలు పట్టి వుంచేవి. ");
INSERT INTO tel2010_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","స్తంభాలను తుమ్మ కర్రతో చేసి, బంగారం తాపడం చేసాడు అతడు. ");
INSERT INTO tel2010_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","తర్వాత అభిషేకించే పవిత్ర తైలం చేసాడు. స్వచ్ఛమైన పరిమళ వాసనగల ధూపం కూడ అతడు చేసాడు. అత్తరు చేసే నైపుణ్యంగల ఒకని చేత ఇవన్నీ చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","తర్వాత బెసలేలు బలిపీఠం కట్టాడు. ఇది దహన బలులను దహించటానికి ఉపయోగించిన బలిపీఠం. తుమ్మ కర్రతో అతడు బలిపీఠం చేసాడు. బలిపీఠం చతురస్రం, దాని పొడువు ఏడున్నర అడుగులు, వెడల్పు ఏడున్నర అడుగులు, ఎత్తు నాలుగున్నర అడుగులు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ఒక్కొక్క మూలకు ఒక కొమ్మును అతడు చేసాడు. కొమ్ములను బలిపీఠంతో ఏకభాగంగా అతడు చేసాడు. తర్వాత అతడు దాన్నంతటినీ యిత్తడితో తాపడం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","తర్వాత బలిపీఠం మీద ఉపయోగించే పరికరాలు అన్నింటినీ అతడు చేసాడు. బిందెలు, గరిటెలు, గిన్నెలు, ముల్లు గరిటెలు, నిప్పు పాత్రలు అతడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","తర్వాత అతడు బలిపీఠం కోసం ఒక వలలాంటి ఇత్తడి జల్లెడ తయారు చేసాడు. ఈ ఇత్తడి జల్లెడ వలలా ఉంది. బలిపీఠం అడుగున అంచు కింద ఉంచబడింది. అది అడుగు భాగాన కింద నుండి బలిపీఠం లోనికి సగం వరకు వుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","తర్వాత ఇత్తడి ఉంగరాలు చేసాడు. బలిపీఠాన్ని మోసే కర్రలను పట్టి వుంచేందుకు ఈ ఉంగరాలు ఉపయోగించ బడ్డాయి. ఆ ఉంగరాలకు ఇత్తడి జల్లెడ నాలుగు మూలలను అతడు అమర్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","తర్వాత అతడు తుమ్మకర్రతో కర్రలు చేసి, వాటిని యిత్తడితో తాపడం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","ఆ కర్రలను ఉంగరాలలో అమర్చాడు అతడు. బలిపీఠం పక్కలో ఉన్న కర్రలు బలిపీఠాన్ని మోసేందుకు ఉపయోగించబడ్డాయి. బలిపీఠం చేయడానికి అతడు తుమ్మ కర్ర పలకలను ఉపయోగించాడు. బలిపీఠం లోపల ఖాళీ గంగాళం వుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","దాని దిమ్మను అతడు ఇత్తడితో చేసాడు. స్త్రీలు ఇచ్చిన ఇత్తడి అద్దాలను అతడు ఉపయోగించాడు. సమావేశ గుడార ప్రవేశం దగ్గర పరిచర్య చేసే స్త్రీలు వీరు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","తర్వాత ఆవరణ చుట్టూ తెరలను అతడు చేసాడు. దక్షిణం వైపు తెరల పొడవు 50 గజాలు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","దక్షిణం వైపు 20 స్తంభాల ఆధారంతో తెరలు నిలబడ్డాయి. ఈ తెరలు సన్నని నారతో చేయబడ్డాయి. ఆ స్తంభాలు 20 యిత్తడి దిమ్మల మీద ఉన్నాయి. స్తంభాలకు, కర్రలకు కొక్కీలు వెండితో చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ఆవరణ ఉత్తరం వైపుకూడ దక్షిణం వైపులాగే ఉంది. 20 ఇత్తడి దిమ్మల మీద 20 స్తంభాలు ఉన్నాయి. స్తంభాలకు, కర్రలకు కొక్కీలు వెండితో చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ఆవరణ పడమటి వైపు తెరలు 25 గజాలు పొడవు. స్తంభాలు 10, దిమ్మలు 10 ఉన్నాయి. స్తంభాలకు కొక్కెములు బిగించే తెరల కడ్డీలు వెండితో చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ఆవరణ ప్రవేశం తూర్పున ఉంది. తూర్పున 25 గజాలు వెడల్పు, ");
INSERT INTO tel2010_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ప్రవేశానికి ఒక ప్రక్క ఏడున్నర గజాలు పొడవు గల ఒక తెర ఉంది. ఆ తెరకు మూడు స్తంభాలు, మూడు దిమ్మలు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ప్రవేశానికి మరో పక్క ఇంకో తెర ఉంది. దాని పొడవు కూడ ఏడున్నర గజాలు. ఆ తెరకు కూడా మూడు స్తంభాలు, మూడు దిమ్మలు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ఆవరణ చుట్టూ ఉన్న తెరలన్నీ నాణ్యమైన బట్టతో చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","స్తంభాలకు దిమ్మలు ఇత్తడితో చేయబడ్డాయి. కొక్కెములు, తెరల కడ్డీలు వెండితో చేయబడ్డాయి. స్తంభాల శిఖరాలు కూడ వెండితో తాపడం చేయబడ్డాయి. ఆవరణలోని స్తంభాలన్నీ తెరల వెండి కడ్డీలతో కలుపబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","నీలం, ఎరుపు ధూమ్రవర్ణం బట్ట, నాణ్యమైన సన్నని నార బట్టతో ఆవరణ ప్రవేశానికి తెర చేయబడింది. నిపుణుడు వీటన్నింటినీ కలిపి కట్టాడు. ఆ తెర 10 గజాలు పొడవు, రెండున్నర గజాలు ఎత్తు ఉంది. ఆవరణలో తెరల వలే అవి కూడ అదే ఎత్తు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ఆ తెర నాలుగు స్తంభాలు, నాలుగు ఇత్తడి దిమ్మల మీద ఆధారపడి ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","స్తంభాల మీద కొక్కెములు వెండితో చేయబడ్డాయి. స్తంభాల శిఖరాలు, బిగించే కడ్డీలు వెండితో చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","పవిత్ర గుడారం (ఒడంబడిక గుడారం) తయారు చేసేందుకు ఉపయోగించిన వస్తువులన్నింటినీ రాసి పెట్టమని లేవీ ప్రజలకు మోషే ఆజ్ఞాపించాడు. అహరోను కుమారుడు ఈతామారు ఈ జాబితా బాధ్యత వహించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","దేవుడు మోషేకు ఆజ్ఞాపించిన సమస్తాన్నీ యూదా వంశాపు హూరు కుమారుడైన ఊరి కుమారుడు బెసలేలు తయారు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ఇంకా దాను వంశాపు అహీమాసాకీ కుమారుడు అహోలీయాబు అతనికి సహాయం చేసాడు. అహోలీయాబు నిపుణుడు, నమూనాలు గీయగలడు. శ్రేష్ఠమైన నారబట్టలతో నీలం, ఎరుపు, ధూమ్ర వర్ణంగల బట్టతో బుటా పని చేయగలవాడు అతడు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","పవిత్ర గుడారం కోసం రెండు టన్నులకంటే ఎక్కువ బంగారం యెహోవాకు అర్పణగా ఇవ్వబడింది. (ఆలయపు అధికారిక కొలత ప్రకారం ఇది తూచబడింది). ");
INSERT INTO tel2010_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ప్రజలు మూడుముప్పావు టన్నులకు మించి వెండిని యిచ్చారు. (ఇది ఆలయపు అధికారిక కొలత ప్రకారం తూచబడింది). ");
INSERT INTO tel2010_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ఇరవై సంవత్సరాలు, అంతకు పైబడ్డ మగవాళ్లందరినీ లెక్కించారు. మొత్తం 6,03,550 మంది మగవారున్నారు. వారిలో ప్రతి ఒక్కడు ఒక వెండి బాకా (అరతులం వెండి) పన్ను చెల్లించాలి. (ఒక వెండి బాకా అంటే అధికారిక కొలత ప్రకారం ఒక అరతులం.) ");
INSERT INTO tel2010_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","అందులో మూడు ముప్పావు టన్నుల వెండి పవిత్ర గుడారపు 100 దిమ్మలు చేసేందుకు, తెరచేసేందుకు వినియోగించబడింది. ఒక్క దిమ్మకు 75 పౌన్ల వెండి వారు ఉపయోగించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","కొక్కెములు, తెరల కడ్డీలు చేయటానికి, స్తంభాలకు వెండి తాపడం చేయటానికి మరో 50 పౌన్ల వెండి ఉపయోగించబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ఇత్తడి ఇరవై ఆరున్నర టన్నులకు పైగా యెహోవాకు ఇవ్వబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","సన్నిధి గుడార ప్రవేశం దగ్గర దిమ్మలు చేయటానికి ఆ ఇత్తడి ఉపయోగించబడింది. బలిపీఠం, ఇత్తడి తెర చేసేందుకు కూడా వారు ఇత్తడి ఉపయోగించారు. బలిపీఠం కోసం పరికరాలు, పాత్రలు అన్నీ చేయటానికి కూడా ఇదే ఇత్తడి వాడబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","ఆవరణ చుట్టూ తెరల దిమ్మలు చేసేందుకు, ప్రవేశం దగ్గర తెరల దిమ్మలు చేసేందుకు కూడా ఇదే ఇత్తడి వాడబడింది. పవిత్ర గుడారానికి, ఆవరణ చుట్టూ ఉన్న తెరలకూ కావల్సిన మేకులు చేసేందుకు కూడా ఇత్తడి ఉపయోగించబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","పవిత్ర స్థలంలో యాజకులు పరిచర్య చేసేటప్పుడు ధరించే ప్రత్యేక వస్త్రాలు తయారు చేసేందుకు నీలం, ఎరుపు, ధూమ్ర వర్ణంగల బట్టను పనివారు ఉపయోగించారు. మోషేకు యెహోవా ఆజ్ఞాపించిన ప్రకారం వారు అహరోనుకు గూడ ప్రత్యేక వస్త్రాలు తయారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","బంగారు తీగ, శ్రేష్ఠమైన బట్ట, నీలం, ఎరుపు, ధూమ్రవర్ణం గల బట్టతో అతడు ఏఫోదును చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","బంగారాన్ని సన్నని రేకులుగా వారు కొట్టారు. తర్వాత బంగారాన్ని పొడవైన తీగలుగా కోసారు. నీలం, ఎరుపు, ధూమ్ర వర్ణంగల బట్ట, నాణ్యమైన బట్టతో బంగారాన్ని కలిపి కొట్టారు. ఇది చాల నైపుణ్యంగల వాని పని. ");
INSERT INTO tel2010_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","ఏఫోదుకు భుజభాగాలను వారు చేసారు. ఈ భాగాలు బట్ట అంచులకు బిగించబడ్డాయి. అప్పుడు అన్ని భాగాలు కలిసి కట్టబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","దట్టి కూడ ఆలాగే చేయబడింది అది ఏఫోదులో ఒక భాగంగా ఉండేటట్టు కలుపబడింది. యెహోవా మోషేకు ఆజ్ఞాపించినట్టే బంగారు తీగ, నాణ్యమైన బట్ట, నీలం, ఎరుపు, ధూమ్ర వర్ణం బట్టలతో అది చేయబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","రత్నాలను బంగారపు జవలలో పనివాళ్లు పొదిగించారు. ఇశ్రాయేలు కుమారుల పేర్లను వారు రత్నాలపై చెక్కారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","తర్వాత ఏఫోదు భుజ భాగాల మీద రత్నాలను వారు అమర్చారు. ఇశ్రాయేలు కుమారులలో ఒక్కొక్కరికి ఒక్కో రత్నం సూచనగా ఉంది. యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారమే ఇది చేయబడంది. ");
INSERT INTO tel2010_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","తర్వాత న్యాయతీర్పు పైవస్త్రం బెసలేలు చేసాడు. నిపుణుని పనిగా అది చేయబడింది. బంగారు దారాలు, నీలం, ఎరుపు, ధూమ్రవర్ణం బట్టలతో అది చేయబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","న్యాయతీర్పు పైవస్త్రం చతురస్రంగా ఉంది, రెండుగా మడత చేయబడింది. దాని పొడవు 9 అంగుళాలు, వెడల్పు 9 అంగుళాలు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","తర్వాత పనివాళ్లు అందమైన రత్నాలను నాలుగు వరుసలుగా దాని మీద పెట్టారు. మొదటి వరుసలో మాణిక్యం, గోమేధికం, మరకతం ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","రెండవ వరుసలో పద్మరాగం, నీలం, సూర్యకాంతమణి వున్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","మూడవ వరుసలో గారుత్మతకం, యష్మురాయి. ఇంద్రనీలం వున్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","నాలుగవ వరుసలో రక్తవర్ణపు రాయి, సులిమానిరాయి, సూర్యకాంతం ఉన్నాయి. ఈ రత్నాలన్నీ బంగారంలో పొదిగించబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ఒక పనివాడు ఒక ముద్రను చేసినట్టు, ఇశ్రాయేలు కుమారుల పేర్లు ఈ పన్నెండు రాళ్లమీద చెక్కబడ్డాయి. ఇశ్రాయేలు కుమారులు ఒక్కొక్కరి పేరు ఒక్కో రాయి మీద ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","న్యాయతీర్పు పైవస్త్రం కోసం స్వచ్ఛమైన బంగారంతో ఒక గొలుసు చేయబడింది. అది తాడుతో అల్లిక చేయబడింది. ");
INSERT INTO tel2010_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","పనివాళ్లు రెండు బంగారు దిమ్మలు, రెండు బంగారు ఉంగరాలు చేసారు. న్యాయ తీర్పు వస్త్రం పైభాగంలోని రెండు మూలల్లో బంగారు ఉంగరాలు రెండు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","తర్వాత బంగారు గొలుసులు రెంటిని న్యాయతీర్పు వస్త్రానికి మూలల్లో రెండు ఉంగరాలకు కట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","బంగారు తాళ్ల అవతలి కొనలను రెండు జవలకు కట్టారు. తర్వాత ఏఫోదు ఎదుట భాగంలోని రెండు భుజాలకు వారు వాటిని బిగించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","తర్వాత వారు మరి రెండు బంగారు ఉంగరాలు చేసి, ఏఫోదు అడుగు భాగపు రెండు మూలల్లో పెట్టారు. ఏఫోదు దగ్గర లోపలి భాగంలో వారు ఆ ఉంగరాలను పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","భుజభాగాల ముందర అడుగు భాగంలో కూడా రెండు బంగారు ఉంగరాలను వారు పెట్టారు. ఏఫోదు దట్టీకి పైగా బిగింపు కూర్పునకు దగ్గరగా ఈ ఉంగరాలు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","తర్వాత నీలి (దారంతో అల్లిన బట్ట) దట్టీతో తీర్పు పతకపు ఉంగరాలను ఏఫోదు ఉంగరాలకు కట్టారు. ఈ విధంగా తీర్పు పతకం నడికట్టును హత్తుకొని ఉంది. అది పడిపోదు. యెహోవా ఆజ్ఞాపించినట్లే వాళ్లు ఇవన్నీ చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","తర్వాత ఏఫోదు అంగీని వారు తయారు చేసారు. నీలం గుడ్డతో దాన్ని తయారు చేసారు. అది ఒక నిపుణుని పనితనం. ");
INSERT INTO tel2010_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","అంగీ మధ్యలో ఒక రంధ్రం ఉంది, ఆ రంధ్రం చుట్టూ ఒక గుడ్డ ముక్క కట్టబడింది. ఆ గుడ్డ ముక్క గోటు. ఆ రంధ్రం చినిగి పోకుండా ఉంచుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","తర్వాత నాణ్యమైన బట్ట నీలం, ఎరుపు ధూమ్ర వర్ణపు నారబట్ట ఉపయోగించారు. అంగీ అడుగు భాగానికి చుట్టూరా దానిమ్మలను కట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","తర్వాత స్వచ్ఛమైన బంగారంతో గంటలను వారు చేసారు. అంగీ అడుగు భాగాన దానిమ్మలకు మధ్య ఈ గంటలను వారు కట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","అంగీ అడుగు భాగం చుట్టూరా గంటలు, దానిమ్మలు ఉన్నాయి. ప్రతి దానిమ్మకూ మధ్య ఒక గంట వుంది సరిగా యెహోవా మోషేకు ఆజ్ఞాపించినట్టే యాజకుడు యెహోవాకు సేవ చేసేటప్పుడు ఈ అంగీని ధరించేవాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","అహరోనుకు, అతని కుమారులకు చొక్కాలను పనివారు తయారు చేసారు. నాణ్యమైన బట్టతో ఈ చొక్కాలు చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","ఇంకా పనివాళ్లు నాణ్యమైన బట్టతో తలపాగాలను చేసారు. తలకు లోపలను, ఏఫోదు తీర్పు పతకాల కింద ధరించే బట్టలను వాళ్లు తయారు చేసారు. నాణ్యమైన బట్టతో వాళ్లు వీటిని తయారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","నాణ్యమైన బట్ట నీలం, ఎరుపు, ధూమ్ర వర్ణంగల బట్టతో నడికట్టును వారు తయారు చేసారు. బట్టతో చిత్రపటాలు కుట్టబడ్డాయి. యెహోవా ఆజ్ఞాపించినట్టే ఇవన్నీ చేయబడ్డాయి. ");
INSERT INTO tel2010_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","తర్వాత పవిత్ర కిరీటం కోసం ఒక బంగారు బద్ద తయారు చేసారు. దాన్ని స్వచ్ఛమైన బంగారంతో వాళ్లు చేసారు. బంగారం మీద వాళ్లు “యెహోవాకు పవిత్రం.” అనే మాటలు వ్రాసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","తర్వాత వాళ్లు యెహోవా మోషేకు ఆజ్ఞాపించినట్టే ఆ బంగారు బద్దకు ఒక నీలసూత్రం కట్టి దాని తలపాగాకు కట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","కనుక సన్నిధి గుడారపు పని అంతా అయిపోయింది. సరిగ్గా యెహోవా మోషేకు ఆజ్ఞాపించినట్టే ఇశ్రాయేలు ప్రజలు సమస్తం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","తర్వాత పవిత్ర సమావేశ గుడారాన్ని వారు మోషేకు చూపించారు. గుడారాన్ని, అందులో ఉన్న సమస్తాన్ని వాళ్లు అతనికి చూపించారు. ఉంగరాలు, చట్రాలు, కమ్ములు, స్తంభాలు, దిమ్మలు, అన్నీ వాళ్లు అతనికి చూపించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ఎరుపు రంగు వేయబడ్డ గొర్రె చర్మాలతో తయారు చేయబడిన గుడారపు పైకప్పును వారు అతనికి చూపించారు. పొట్టేళ్ల తోలుతో చేయబడ్డ పైకప్పును వారు అతనికి చూపించారు. మరియు శ్రేష్ఠమైన తోలుతో చేయబడ్డ పవిత్ర స్థల ప్రవేశానికి వేసే తెరను కూడా అతనికి చూపించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ఒడంబడిక పెట్టెను వారు మోషేకు చూపించారు. ఆ పెట్టెను మోసేందుకు ఉపయోగించే కర్రలను, పెట్టెను మూసివుంచే మూతను వారు అతనికి చూపించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","బల్లను, గోనెమీద ఉంచే వాటన్నింటిని, దేవుని ప్రత్యేక రొట్టెను వారు మోషేకు చూపెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","స్వచ్ఛమైన బంగారంతో చేయబడ్డ దీపస్తంభాన్ని, దాని మీద దీపాలను వారు మోషేకు చూపించారు. దీపాలకు ఉపయోగించే నూనె, ఇతర వస్తువులన్నింటిని వారు మోషేకు చూపించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","బంగారు బలిపీఠం, అభిషేక తైలం, పరిమళ వాసనగల ధూపం, గుడారపు ప్రవేశాన్ని మూసి వుంచే తెరను వారు అతనికి చూపించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ఇత్తడి బలిపీఠమును, ఇత్తడి తెరను వారు అతనికి చూపించారు. బలిపీఠాన్ని మోసేందుకు ఉపయోగించే కర్రలను వారు మోషేకు చూపించారు. బలిపీఠం మీద ఉపయోగించే వస్తువులన్నింటినీ వారు మోషేకు చూపించారు. గంగాళాన్ని గంగాళం కింద ఉండే దిమ్మను వారు అతనికి చూపించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ఆవరణలో స్తంభాలు, దిమ్మలతో ఉన్న తెరల గోడను మోషేకు వారు చూపించారు. ఆవరణ ద్వారాన్ని కప్పి ఉంచే తెరను వారు అతనికి చూపించారు. తాళ్లను, పవిత్ర గుడారపు మేకలను వారు. అతనికి చూపించారు. పవిత్ర గుడారంలో, సన్నిధి గుడారంలో ఉన్నవాటన్నింటినీ వారు అతనికి చూపించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","తర్వాత పవిత్ర గుడారంలో సేవలు చేసే యాజకుల కోసం తయారు చేయబడ్డ వస్త్రాలను వారు మోషేకు చూపించారు. యాజకుడైన అహరోను, అతని కుమారుల కోసం తయారు చేయబడ్డ ప్రత్యేక వస్త్రాలను వారు అతనికి చూపించారు. వారు యాజకులుగా సేవ చేసినప్పుడు ఆ వస్త్రాలు ధరించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","సరిగ్గా యెహోవా మోషేకు ఆజ్ఞాపించినట్టే ఇశ్రాయేలు ప్రజలు ఈ పని అంతా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","పని అంతటినీ మోషే చాలా సునిశితంగా పరిశీలించాడు. సరిగ్గా యెహోవా ఆజ్ఞాపించినట్టే పని జరిగినట్టు మోషే చూసాడు. కనుక వాళ్లను మోషే ఆశీర్వదించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","అప్పుడు మోషేతో యెహోవా యిలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“మొదటి నెల మొదటి రోజున పవిత్ర గుడారాన్ని నిలబెట్టు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ఒడంబడిక పెట్టెను సమావేశ పవిత్ర గుడారంలో పెట్టు. తెరతో ఆ పెట్టెను కప్పివేయి. ");
INSERT INTO tel2010_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","తర్వాత బల్లను లోపలికి తీసుకురా. బల్లమీద ఉండాల్సిన వస్తువులను దాని మీద ఉంచు. తర్వాత దీపస్తంభాన్ని గుడారంలో ఉంచు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","ధూపార్పణ కోసం బంగారపు వేదికను గుడారంలో పెట్టు, ఒడంబడిక పెట్టెకు ముందర ఈ వేదికను పెట్టు. తర్వాత పవిత్ర గుడారపు ప్రవేశానికి తెరవేయి. ");
INSERT INTO tel2010_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“పవిత్ర గుడారపు (సన్నిధి గుడారం) ప్రవేశానికి ముందర దహనబలి అర్పణల పీఠాన్ని ఉంచు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ఈ బలిపీఠానికి, సన్నిధి గుడారానికి మధ్య గంగాళం ఉంచు. గంగాళంలో నీళ్లు పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ఆవరణ చుట్టూ తెరలు తగిలించాలి. తర్వాత ఆవరణ ప్రవేశం దగ్గర తెరవేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“అభిషేకతైలం ఉపయోగించి పవిత్ర గుడారాన్ని, అందులో ఉండే సమస్తాన్ని అభిషేకించు. ఈ వస్తువుల మీద నీవు తైలం పోసినప్పుడు వాటిని నీవు పవిత్రం చేస్తావు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","దహన బలులను దహించే బలిపీఠాన్ని, అభిషేకించు, బలిపీఠం మీద ఉండే సమస్తాన్నీ అభిషేకించు. ఆ బలిపీఠాన్ని నీవు పవిత్రం చేస్తావు. అది అతి పరిశుద్ధంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","తర్వాత గంగాళాన్ని, దాని కింద దిమ్మను అభిషేకించు. ఆ వస్తువులను పవిత్రం చేసేందుకు ఇలా చేయి. ");
INSERT INTO tel2010_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“అహరోనును, అతని కుమారులను సన్నిధి గుడారం ప్రవేశం దగ్గరకు తీసుకురా. నీళ్లతో వాళ్లకు స్నానం చేయించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","తర్వాత అహరోనుకు ప్రత్యేక వస్త్రాలను తొడిగించాలి. తైలంతో అతన్ని అభిషేకించి అతన్ని పవిత్రం చెయ్యి. అప్పుడే అతడు యాజకుడుగా సేవచేయగలడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","తర్వాత అతని కుమారులకు వస్త్రాలు తొడిగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","వాళ్ల తండ్రిని నీవు అభిషేకించినట్టే కుమారులను కూడా అభిషేకించు. అప్పుడు వాళ్లు కూడా యాజకులుగా నా సేవ చేయగలరు. వాళ్లను నీవు అభిషేకించినప్పుడు వాళ్లు యాజకులవుతారు. రాబోయే కాలమంతా ఆ కుటుంబము యాజకులుగా కొనసాగుతారు.” ");
INSERT INTO tel2010_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","మోషే యెహోవాకు విధేయుడయ్యాడు. యెహోవా తనకు ఆజ్ఞాపించిన దానంతటి ప్రకారం అతడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","కనుక సరైన సమయంలో పవిత్రగుడారం నిలబెట్టబడింది. వారు ఈజిప్టు విడిచిన తర్వాత అది రెండవ సంవత్సరం మొదటి నెల మొదటి రోజు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","యెహోవా చెప్పినట్టే పవిత్ర గుడారాన్ని మోషే నిలబెట్టాడు. అతడు దిమ్మలను ముందుగా కింద పెట్టాడు. తర్వాత ఆ దిమ్మల మీద చట్రాలను పెట్టాడు. తర్వాత అతడు కమ్ములను అమర్చి, స్తంభాలను నిలబెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","ఆ తర్వాత పవిత్ర గుడారం కప్పును మోషే నిలబెట్టాడు. తర్వాత గుడారపు కప్పు మీద మరో కప్పును అతడు వేసాడు. యెహోవా ఆజ్ఞాపించినట్టే అతడు వీటన్నింటినీ చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","దేవుని ఆజ్ఞలు రాయబడ్డ రాతి పలకలను ఒడంబడిక పెట్టెలో మోషే పెట్టాడు. ఆ పెట్టెకు కర్రలను మోషే పెట్టాడు. తర్వాత అతడు ఆ పెట్టెకు మూత పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","తర్వాత ఆ పవిత్ర పెట్టెను గుడారంలోకి మోషే తీసుకు వచ్చాడు. సరైన చోట అతడు తెర వేసాడు. ఇది సన్నిధి గుడారంలో పవిత్ర పెట్టెను మరుగు చేస్తుంది. యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం మోషే వీటన్నింటినీ చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","తర్వాత సన్నిధి గుడారపు బల్లను మోషే పెట్టాడు. గుడారం ఉత్తరాన అతడు దీన్ని పెట్టాడు. (పవిత్ర స్థలంలో) తెరముందర అతడు దీన్ని పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","తర్వాత యెహోవా సన్నిధిలో బల్ల మీద రొట్టెను అతడు పెట్టాడు. యెహోవా తనకు ఆజ్ఞాపించినట్టు అతడు దీన్ని చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","తర్వాత మోషే దీపస్తంభాన్ని సన్నిధి గుడారంలో పెట్టాడు. గుడారం దక్షిణాన, బల్లకు ఎదుట అతడు దీపస్తంభం పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","తర్వాత యెహోవా సన్నిధిలో దీపస్తంభం మీద దీపాలను అతడు పెట్టాడు. యెహోవా తనకు ఆజ్ఞాపించినట్టే అతడు దీన్ని చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","తర్వాత బంగారపు ధూపవేదికను సన్నిధి గుడారంలో మోషే పెట్టాడు. ఆ వేదికను తెరముందర అతడు పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","తర్వాత ఆ బంగారు బలిపీఠం మీద సువాసనగల పరిమళ ధూపం అతడు వేసాడు. యెహోవా తనకు ఆజ్ఞాపించినట్టే అతడు దీన్ని చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","తర్వాత పవిత్ర గుడారం ప్రవేశానికి మోషే తెర వేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","పవిత్ర గుడారం, సన్నిధి గుడారం ప్రవేశం దగ్గర దహన బలులను దహించే బలిపీఠాన్ని మోషే పెట్టాడు. అప్పుడు ఒక దహన బలి అర్పణను ఆ బలిపీఠం మీద మోషే అర్పించాడు. యెహోవాకు ధాన్యార్పణ కూడ అతడు అర్పించాడు. యెహోవా అతనికి ఆజ్ఞాపించినట్టే అతడు వీటన్నింటినీ చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","తర్వాత మోషే సన్నిధి గుడారానికి, బలిపీఠానికి మధ్య గంగాళం ఉంచాడు, కడుక్కొనేందుకు గంగాళంలో నీళ్లు పోసాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","మోషే, అహరోను, అహరోను కుమారులు వారి కాళ్లు చేతులు కడుక్కొనేందుకు ఈ గంగాళాన్ని ఉపయోగించారు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","వారు సన్నిధి గుడారంలో ప్రవేశించినప్పుడల్లా కాళ్లు కడుక్కొనేవారు. వాళ్లు బలిపీఠాన్ని సమీపించిన ప్రతీసారీ వాళ్లను వాళ్లు కడుక్కొనేవారు. యెహోవా మోషేకు ఆజ్ఞాపించిన ప్రకారం వాళ్లు ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","తర్వాత గుడారపు ఆవరణలో తెరలను మోషే తగిలించాడు. మోషే గుడారపు ఆవరణలో బలిపీఠాన్ని పెట్టాడు. తర్వాత అతడు ఆవరణ ప్రవేశం దగ్గర తెరను వేసాడు. కనుక అతడు చేయాలని చెప్పి యెహోవా తనకు అప్పగించిన పని అంతా మోషే ముగించాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","అంతా ముగించిన తర్వాత సన్నిధి గుడారాన్ని ఒక మేఘం ఆవరించింది. యెహోవా మహిమ ఆ పవిత్ర గుడారాన్ని నింపివేసింది. ");
INSERT INTO tel2010_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ఆ మేఘం పవిత్ర గుడారం మీద నిలిచిపోగా యెహోవా మహిమ దాన్ని నింపేసింది. కనుక మోషే ఆ సన్నిధి గుడారంలో ప్రవేశించలేక పోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","(ప్రజలు ఎప్పుడు సాగిపోవాల్సిందీ చూపెట్టిన మేఘం) పవిత్ర గుడారంనుండి మేఘం పైకి లేచినప్పుడు, ప్రజలు ప్రయాణం మొదలు పెట్టేవారు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","అయితే ఆ మేఘం పవిత్ర గుడారం మీద నిలిచి ఉన్నప్పుడు ప్రజలు సాగిపోయే ప్రయత్నం చేయలేదు. మేఘం లేచేంతవరకు వాళ్లు ఆ స్థలంలోనే ఉండిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","కనుక యెహోవా మేఘం పగటివేళ పవిత్ర గుడారం మీద నిలిచి ఉండేది. మరియు రాత్రివేళ ఆ మేఘంలో అగ్ని ఉండేది. కనుక ఇశ్రాయేలు ప్రజలంతా ప్రయాణం చేస్తున్నప్పుడు ఆ మేఘాన్ని చూడగలిగారు. ");
INSERT INTO tel2010_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","యెహోవా దేవుడు మోషేను పిలిచి, సన్నిధి గుడారంలో నుండి అతనితో మాట్లాడాడు. యెహోవా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పు, మీలో ఎవరైనా యెహోవాకు అర్పణ తెచ్చినప్పుడు, ఆవుల మందలోనుండి గాని, గొర్రెల మందలోనుండి గాని దానిని తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ఒక వ్యక్తి తన ఆవుల మందలో ఒక దానిని దహనబలిగా అర్పిస్తుంటే, అది నిర్దోషమైన గిత్తయి వుండాలి. ఆ వ్యక్తి ఆ గిత్తను సన్నిధి గుడారపు ద్వారం దగ్గరకు తీసుకొని వెళ్లాలి. అప్పుడు యెహోవా ఆ అర్పణను అంగీకరిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ఈ వ్యక్తి ఆ గిత్త తలమీద తన చేయి పెట్టాలి. ఆ వ్యక్తి పాపానికి ప్రాయశ్చిత్తంగా ఆ దహనబలి అర్పణను యెహోవా అంగీకరిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“ఆ వ్యక్తి యొక్క గిత్తను యోహోవా ఎదుట వధించాలి. అప్పుడు అహరోను కుమారులైన యాజకులు ఆ గిత్త రక్తాన్ని తీసుకొని రావాలి. సన్నిధి గుడారపు ద్వారం దగ్గర బలిపీఠం చుట్టూ ఆ రక్తాన్ని వారు చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","అతడు ఆ పశువు చర్మాన్ని ఒలిచి, ఆ పశువును ముక్కలుగా నరకాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","యాజకులైన అహరోను కుమారులు బలిపీఠం మీద కట్టెలు, నిప్పు ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","యాజకులైన అహరోను కుమారులు ఆ ముక్కలను (తల, కొవ్వు) కట్టెలు మీద పెట్టాలి. ఆ కట్టెలు బలిపీఠం మీద నిప్పుల్లో ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","ఆ పశువు లోపలి భాగాలను, కాళ్లను నీళ్లతో యాజకుడు కడగాలి. తర్వాత ఆ పశువు అవయవాలు అన్నింటినీ బలిపీఠం మీద యాజకుడు దహించాలి. అది అగ్నిపై అర్పించబడే దహనబలి, ఇది యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2010_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ఒక వ్యక్తి గొర్రెనుగాని మేకనుగాని దహన బలిగా అర్పిస్తుంటే, ఏ దోషం లేని మగదానిని మాత్రమే అతడు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","ఆ వ్యక్తి బలిపీఠానికి ఉత్తరాన, యెహోవా ఎదుట ఆ జంతువును వధించాలి. అప్పుడు యాజకులైన అహరోను కుమారులు, ఆ జంతువు రక్తాన్ని బలిపీఠం చుట్టూ చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","అప్పుడు యాజకుడు ఆ జంతువును ముక్కలుగా నరకాలి. ఆ జంతువు తల, కొవ్వులను యాజకుడు ఉంచుకొంటాడు. ఆ ముక్కలను యాజకుడు కట్టెల మీద చక్కగా పేర్చాలి. బలిపీఠం మీద నిప్పుల్లో ఆ కట్టెలు ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","లోపలి భాగాలను, కాళ్లను నీళ్లతో యాజకుడు కడగాలి. అప్పుడు యాజకుడు ఆ జంతువు అవయవాలన్నింటినీ అర్పించి, బలిపీఠం మీద దహించాలి. అది అగ్నిపై అర్పించబడే దహనబలి, ఇది యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2010_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ఒక వ్యక్తి ఒక పక్షిని యెహోవాకు దహన బలిగా అర్పించాలను కొంటే, తెల్ల గువ్వ, లేక పావురం పిల్ల మాత్రమే యివ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","అర్పణను యాజకుడు ఆ బలిపీఠం దగ్గరకు తీసుకొని రావాలి. యాజకుడు ఆ పక్షి తలను తుంచివేయాలి. అప్పుడు ఆ పక్షిని బలిపీఠం మీద యాజకుడు దహించాలి. ఆ పక్షి రక్తాన్ని బలిపీఠం పక్కగా కార్చివెయ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","యాజకుడు ఆ పక్షి మేత పొట్టను, దాని ఈకలను తీసివేసి, బలిపీఠానికి తూర్పుగా పారవేయాలి. ఇది వారు బలిపీఠపు బూడిదను పారవేసేచోటు. ");
INSERT INTO tel2010_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","అప్పుడు యాజకుడు ఆ పక్షి రెక్కలను పట్టి చీల్చాలి గాని దానిని రెండు భాగాలుగా విడదీయకూడదు. బలిపీఠం మీద అగ్నిలో ఉన్న కట్టెలపైన ఆ పక్షిని యాజకుడు దహించాలి. అది అగ్నిపైన అర్పించబడే దహనబలి, ఇది యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2010_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ఎవరైనా యెహోవాకు ధాన్యార్పణ పెట్టేటప్పుడు అది శ్రేష్ఠమైన పిండిగా ఉండాలి. ఆ వ్యక్తి ఆ పిండిమీద నూనెపోసి, సాంబ్రాణి వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","అప్పుడు దానిని యాజకులైన అహరోను కుమారుల దగ్గరకు అతడు తీసుకొని రావాలి. సాంబ్రాణిని, నూనె కలిపిన పిండిలో ఒక గుప్పెడు ఆ వ్యక్తి తీసుకోవాలి. అప్పుడు యాజకుడు బలిపీఠపు అగ్నితో ఆ పిండిని జ్ఞాపకార్థ అర్పణగా దహించాలి. అది యెహోవాకు ఇష్టమైన సువాసనగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","మిగిలిపోయిన ధాన్యార్పణ అహరోనుకు, అతని కుమారులకు చెందుతుంది. యెహోవాకు అర్పించే హోమములు అన్నింటిలో ఇది అతి పవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“పొయ్యిమీద కాల్చబడిన ధాన్యార్పణ నీవు పెట్టేటప్పుడు అది నూనె కలిపిన శ్రేష్ఠమైన పిండితో చేయబడ్డ పొంగని రొట్టెలు, లేక నూనె రాయబడ్డ పొంగని అప్పడాలు కావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","పెనం మీద కాల్చబడిన ధాన్యార్పణ నీవు తెస్తే అది నూనెతో కలిపిన పొంగని మంచి పిండి కావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","దానిని నీవు ముక్కలు చేసి, దాని మీద నూనెపోయాలి. అది ధాన్యార్పణ. ");
INSERT INTO tel2010_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","నీవు వంట గిన్నెలో వండిన ధాన్యార్పణ తెస్తే అది నూనెతో కలుపబడిన మంచి పిండికావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","“ఈ పదార్థాలతో చేయబడిన ధాన్యార్పణను నీవు యెహోవాకు తీసుకొని రావాలి. నీవు వాటిని యాజకుని దగ్గరకు తీసుకొనివెళ్లాలి, అతడు వాటిని బలిపీఠం మీద ఉంచుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","ఇది జ్ఞాపకార్థమైన అర్పణ. అది బలిపీఠం మీద దహించబడాలి. అగ్నిమీద అది దహించ బడుతుంది. ఇది యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2010_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","మిగిలిపోయిన ధాన్యార్పణలు అహరోనుకు, అతని కుమారులకు చెందుతుంది. యెహోవాకు అర్పించే హోమాలలో ఇది అతి పవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“పులిసిన పదార్థం ఉన్న ధాన్యార్పణ ఏదీ మీరు యెహోవాకు తీసుకొని రాకూడదు. పులిసిన పదార్థంగాని, తేనెగాని యెహోవాకు అర్పణగా అగ్నిమీద దహించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","మొదటి పంటలో నుండి పులిసిన పదార్థాన్ని, తేనెను యెహోవాకు అర్పణగా మీరు తీసుకొని రావచ్చును. కానీ బలిపీఠం మీద ఇష్టమైన సువాసనగా ఉండేందుకు పులిసిన పదార్థం, తేనె దహించబడకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","నీవు తీసుకొని వచ్చే ప్రతి ధాన్యార్పణలో ఉప్పు తప్పక వేయాలి. నీవు అర్పించు ధాన్యార్పణలో ఉప్పు వేయవలెను. ");
INSERT INTO tel2010_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“మొదటి పంటలో నుండి నీవు యెహోవాకు ధాన్యార్పణ అర్పిస్తే, వాటిని పేల్చి తీసుకురావాలి. కొత్త ధాన్యం నుండి వాటిని ఒలిచి తీసుకొని రావాలి. ఇది మొదటి పంటలోనుండి నీ కొరకైన ధాన్యార్పణ అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","దానిమీద నూనెను, సాంబ్రాణిని నీవు వేయాలి. అది ధాన్యార్పణ అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ఒలిచిన ధాన్యాన్ని, నూనెలోనుండి కొంతభాగాన్ని, సాంబ్రాణి మొత్తాన్ని జ్ఞాపకార్థ అర్పణగా యాజకుడు దహించాలి. ఇది యెహోవాకు హోమమైయుండును. ");
INSERT INTO tel2010_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ఒక వేళ ఒక వ్యక్తి ఇచ్చే అర్పణ సమాధాన బలి అయితే, మగ లేక ఆడ జంతువును తన పశువుల మందలోనుండి అతడు యెహోవాకు ఇస్తే ఆ పశువులో ఎలాంటి దోషం ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ఆ వ్యక్తి ఆ పశువు తలమీద తన చేతులు ఉంచాలి. సన్నిధి గుడార ద్వారం దగ్గర ఆ పశువును అతడు వధించాలి. అప్పుడు అహరోను కుమారులైన యాజకులు ఆ రక్తాన్ని బలిపీఠం చుట్టూ చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","ఈ వ్యక్తి సమాధాన బలిలోనుంచి యెహోవాకు హోమం చేయాలి. అంత్రములకు, లోపలి అవయవాలకు ఉండే కొవ్వు అంతటినీ అతడు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","మూత్రపిండాలను ఆ రెండింటి మీద కొవ్వును, నడుం దగ్గర కొవ్వును అతడు అర్పించాలి. మూత్రపిండాలతో బాటు కార్జమును కప్పి ఉండే కొవ్వును అతడు తీయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","అప్పుడు ఆ కొవ్వును అహరోను కుమారులు బలిపీఠం మీద దహించాలి. దీనిని వారు అగ్నిలో కట్టెలమీద ఉన్న దహనబలి వేస్తారు. ఇది యెహోవాకు ఇష్టమైన సువాసనను యిచ్చే హోమం. ");
INSERT INTO tel2010_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ఒకవేళ ఆ వ్యక్తి, యెహోవాకు సమాధాన అర్పణగా ఒక జంతువును మందలోనుండి తెస్తే, అది ఆడదిగాని, మగదిగాని దోషం లేనిదిగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","అతడు ఒక గొర్రెపిల్లను తన అర్పణగా తెస్తే, అతడు దానిని యెహోవా ఎదుటికి తేవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","సన్నిధి గుడారం ఎదుట అతడు దాని తలమీద చేయి పెట్టి, దానిని వధించాలి. దాని రక్తాన్ని అహరోను కుమారులు బలిపీఠం చుట్టూ చిలకరిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","అప్పుడు అతడు సమాధాన బలిలో నుంచి కొంత యెహోవాకు హోమం చేయాలి. కొవ్వు, కొవ్విన తోకమొత్తం, దాని లోపలి అవయవాల మీద చుట్టూ ఉండే కొవ్వు అతడు తీసుకొని రావాలి. వెన్నుపూస నుండి ఉండే తోకను అతడు కోసి వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","రెండు మూత్రపిండాలను, వాటిని కప్పి ఉండే కొవ్వును, నడుం దగ్గరనున్న కొవ్వును అతడు అర్పించాలి. కార్జానికి ఉండే కొవ్వుకూడా అతడు అర్పించాలి. మూత్రపిండాలతో బాటు కార్జాన్ని కూడా అతడు తీయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","అప్పుడు యాజకుడు ఆ జంతువును బలిపీఠం మీద దహిస్తాడు. అది యెహోవాకు ప్రజలు అగ్నితో అర్పించిన ఆహారం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ఒక వ్యక్తి ఇచ్చే అర్పణ మేక అయితే, అతడు దానిని యెహోవా ఎదుట అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","సన్నిధి గుడార ద్వారం దగ్గర అతడు దాని తల మీద చేయి పెట్టి దానిని వధించాలి. అప్పుడు అహరోను కుమారులు ఆ మేక రక్తాన్ని బలిపీఠం చుట్టూ చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","తర్వాత ఆ మేకలోని కొంతభాగాన్ని అతడు యెహోవాకు హోమం చేయాలి. లోపలి భాగాల్లోను, వాటి మీదను ఉండే కొవ్వును అతడు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","రెండు మూతగ్రంథుల్ని, వాటి మీద ఉండే కొవ్వును, ఆ మేక నడుం దగ్గరి కొవ్వును అతడు అర్పణ చేయాలి. కార్జాన్ని కప్పి ఉండే కొవ్వును అతడు అర్పణ చేయాలి. మూత్రపిండాలతో బాటు కార్జాన్ని కూడా అతడు తీయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","మేక అవయవాలను యాజకుడు దహనం చేయాలి. అది అగ్నితో అర్పించబడ్డ ఆహారం అవుతుంది. అది ఇష్టమైన సువాసనగా ఉంటుంది. కొవ్వు మొత్తం యెహోవాకు చెందుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","మీ తరాలన్నింటికీ శాశ్వతంగా ఈ నియమం కొనసాగుతుంది. మీరు ఎక్కడ నివసించినా కొవ్వునుగాని రక్తాన్నిగాని మీరు తినకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","మోషేతో యెహోవా మాట్లాడి ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పు: ప్రమాదవశాత్తు ఎవరైనా పాపం చేసి, చేయకూడదని యెహోవా చెప్పిన వాటిని చేస్తే, అప్పుడు అతడు ఇలా చేయాలి: ");
INSERT INTO tel2010_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“అభిషేకించబడిన యాజకుడు పాపం చేసి, ప్రజలమీదికి దోషం రప్పిస్తే, అప్పుడు అతడు తాను చేసిన పాపం నిమిత్తం యెహోవాకు ఒక అర్పణను అర్పించాలి. ఏ దోషమూ లేని ఒక కోడెదూడను అతడు అర్పించాలి. పాపపరిహారార్థ బలిగా ఆ కోడెదూడను అతడు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","సన్నిధి గుడార ద్వారం దగ్గర యెహోవా ఎదుటకు అభిషేకించబడిన యాజకుడు ఆ కోడెదూడను తీసుకొనిరావాలి. అతడు కోడెదూడ తల మీద తన చేతులు ఉంచి, యెహోవా ఎదుట దానిని వధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","అభిషిక్తుడైన యాజకుడు అప్పుడు ఆ దూడ రక్తాన్ని కొంత తీసుకొని, దానిని సన్నిధిగుడారం దగ్గరకు తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","యాజకుడు ఆ రక్తంలో తన వేలు ముంచి, పవిత్రగది తెర ముందు యెహోవా ఎదుట ఏడు సార్లు ఆ రక్తాన్ని చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","యాజకుడు సుగంధద్రవ్వాల ధూప వేదిక మీద ఆ రక్తంలో కొంత పూయాలి, (ఈ ధూపవేదిక సన్నిధిగుడారంలో యెహోవా ఎదుట ఉంటుంది). ఆ కోడెదూడ రక్తాన్ని అంతా దహన బలిపీఠం అడుగున యాజకుడు పోయాలి. ఆ బలిపీఠం సన్నిధి గుడారపు ద్వారం దగ్గర ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","మరియు అతడు పాప పరిహారార్థపు కోడెదూడ కొవ్వునంతా తీసివేయాలి. లోపలి భాగాలమీద, చుట్టూ ఉండే కొవ్వు అంతా అతడు తీసివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","రెండుమూత్ర పిండాలను, వాటిమీది కొవ్వును, నడుం దగ్గరనున్న కొవ్వును అతడు తీసుకోవాలి. కార్జాన్ని కప్పి ఉన్న కొవ్వును అతడు తీసుకోవాలి. మరియు అతడు మూత్రపిండాలతో బాటు కార్జాన్ని కూడా తీసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","సమాధాన బలిలో బలియివ్వబడే కోడెదూడనుండి తీసినట్టే అతడు వీటన్నింటినీ తీయాలి. యాజకుడు దహన బలి పీఠంమీద దాని భాగాలన్నింటినీ కాల్చాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","కాని, ఆ కోడెదూడ చర్మాన్ని, దాని మాంసం అంతటినీ, దాని తల, కాళ్లు, లోపలి భాగాలను, దాని పేడను యాజకుడు బయటకు తీసుకొనిపోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","బసకు వెలుపల బూడిద పారబోసే ప్రత్యేకమైన చోటుకు ఆ కోడెదూడ కళేబరాన్ని యాజకుడు తీసుకుపోవాలి. అక్కడ కట్టెల మీద నిప్పుతో ఆ కోడెదూడను యాజకుడు కాల్చివేయాలి. బూడిద పారబోసే చోట ఆ కోడెదూడ కాల్చివేయబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ఒక వేళ ఇశ్రాయేలు జనులంతా తెలియకుండా పాపం చేయటం తటస్థించవచ్చు. చేయకూడదని యెహోవా ఆజ్ఞాపించిన వాటిలో దేనినైనా వారు చేసినట్లయితే వారు అపరాధులు అవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ఆ పాపం విషయమై వారు తెలుసుకొంటే, అప్పుడు ఆ జనాంగం అంతటి నిమిత్తం పాప పరిహారార్థబలిగా ఒక కోడెదూడను అర్పించాలి. సన్నిధి గుడారం ఎదుటికి వారు ఆ కోడెదూడను తీసుకొనిరావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","సమాజపు పెద్దలందరూ, యెహోవా ఎదుట ఆ కోడెదూడ మీద వారి చేతులు ఉంచాలి. యెహోవా ఎదుట ఆ కోడెదూడ వధించబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","అప్పుడు అభిషిక్తుడైన యాజకుడు ఆ కోడెదూడ రక్తంలో కొంత సన్నిధి గుడారం దగ్గరకు తీసుకొనిరావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","యాజకుడు ఆ రక్తంలో తన వేలు ముంచి, తెరముందు యెహోవా ఎదుట ఏడు సార్లు దాన్ని చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","అప్పుడు యాజకుడు బలిపీఠం కొమ్ములకు కొంత రక్తం పూయాలి. ఆ బలిపీఠం అడుగున యాజకుడు పోయాలి. ఆ బలిపీఠం సన్నిధి గుడారంలో యెహోవా ఎదుట ఉంది. రక్తాన్నంతా దహన బలిపీఠం సన్నిధి గుడార ద్వారం దగ్గర ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","అప్పుడు యాజకుడు దాని కొవ్వు అంతా తీసి బలిపీఠంమీద దహించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","పాప పరిహారార్థ బలిపశువుకు చేసినట్టే అతడు ఈ కోడెదూడకు కూడా చేయాలి ఈ విధంగా యాజకుడు ప్రజల పాపాలకు ప్రాయశ్చిత్తం చేస్తాడు. మరియు ఇశ్రాయేలు ప్రజలను దేవుడు క్షమిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","యాజకుడు ఆ కోడెదూడను బస బయటకు తీసుకొని వెళ్లి దానిని కాల్చివేయాలి. ఇదీ మొదటి కోడెదూడకు చేసినట్టే. ఇది మొత్తం సమాజానికి పాప పరిహారార్థ బలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“చేయకూడదని యెహోవా చెప్పిన ఆజ్ఞలలో దేనినైనా ఒక ఆధికారి పొరబాటున అతిక్రమన చేసినట్లయితే, అప్పడు ఆ అధికారి అపరాధి అవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","అతడు తన పాపం విషయమై తెలుసుకొంటే, అతడు ఏదోషమూ లేని ఒక మగ మేకను తీసుకొని రావాలి. అది అతని అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","ఆ అధికారి ఆ మేక మీద తన చేయి ఉంచి, యెహోవా ఎదుట వారు దహనబలి పశువును వధించు చోట దానిని వధించాలి. ఆ మేక పాపపరిహారార్థ బలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","యాజకుడు పాప పరిహారార్థబలిలో కొంత రక్తాన్ని తన వేలితో తీసుకోవాలి. యాజకుడు ఆ రక్తాన్ని దహన బలిపీఠం కొమ్ములకు పూయాలి. మిగిలిన రక్తాన్ని యాజకుడు దహన బలిపీఠం అడుగున పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","ఆ మేక కొవ్వు అంతటినీ యాజకుడు బలిపీఠం మీద దహించాలి. సమాధాన బలిలో కొవ్వును దహించినట్లు అతడు దానిని దహించాలి. ఈ విధంగా యాజకుడు అధికారి పాపమునకు ప్రాయశ్చితంచేస్తాడు. మరియు దేవుడు ఆ అధికారిని క్షమిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“చేయకూడదని యెహోవా ఆజ్ఞాపించిన వాటిలో దేనినైనా ఒక సామాన్యుడు పొరబాటున చేయటం తటస్థించవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","అతడు తన పాపాన్ని గుర్తించినట్లయితే ఏదోషం లేని ఒక ఆడ మేకను అతడు తీసుకొని రావాలి. అది ఆ వ్యక్తి అర్పణ. అతడు చేసిన పాపం నిమిత్తం అతడు ఆ మేకను తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","అతడు దాని తల మీద తన చేతిని ఉంచి, దహనబలి స్థలంలో దానిని వధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","అప్పుడు యాజకుడు ఆ మేక రక్తంలో కొంచెంతన వేలితో తీసుకొని, దహనబలిపీఠం కొమ్ములకు దానిని పూయాలి. ఆ మేక రక్తాన్నంతా బలిపీఠం అడుగున యాజకుడు పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","తర్వాత సమాధాన బలినుండి కొవ్వు అంతా తీసి వేసినట్టే ఆ మేక కొవ్వు అంతటినీ యాజకుడు తీసివేయాలి. దానిని యెహోవాకు ఇష్టమైన సువాసనగా బలిపీఠం మీద యాజకుడు దహించాలి. ఈ విధంగా ఆ వ్యక్తి పాపాన్ని యాజకుడు తుడిచి వేస్తాడు. మరియు ఆ వ్యక్తిని దేవుడు క్షమిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ఈ వ్యక్తి తన పాపపరిహారార్థ బలిగా ఒక గొర్రె పిల్లను తీసుకొని వస్తే, అది ఏదోషమూలేని ఆడ గొర్రెయై ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","అతడు దాని తలమీద తన చేయి ఉంచి, దహనబలి పశువును వధించే స్థలంలో, పాపపరిహారార్థ బలిగా దానిని కూడా వధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ఆ పాప పరిహారార్థ బలి రక్తాన్ని యాజకుడు తనవేలితో తీసుకొని, దహన బలిపీఠం కొమ్ములకు పూయాలి. తర్వాత ఆ గొర్రె రక్తాన్నంతా బలిపీఠం అడుగున అతడు పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","సమాధాన బలిలో గొర్రెపిల్ల కొవ్వునంతా తీసివేసినట్టే, ఆ గొర్రెపిల్ల యొక్క కొవ్వు అంతటినీ యాజకుడు తీసివేయాలి. యాజకుడు యెహోవాకు అర్పించే హోమంలా బలిపీఠం మీద ఆ ముక్కలను దహించాలి. ఈ విధంగా, ఆ వ్యక్తి పాపాలను యాజకుడు తుడిచి వేస్తాడు. మరియు దేవుడు ఆ వ్యక్తిని క్షమిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ఒక వ్యక్తి హెచ్చరికను వినవచ్చు, లేక ఒక వ్యక్తి తాను యితరులతో చెప్పాల్సిన ఒక విషయాన్ని వినటమో, చూడటమో తటస్థిస్తుంది. ఆ వ్యక్తి తాను చూసిన దాన్ని లేక విన్నదాన్ని చెప్పకపోతే అతడు అపరాధి. ");
INSERT INTO tel2010_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“లేక ఒకవేళ ఏదైనా అపవిత్రమైన దాన్ని ఒక వ్యక్తి తాకవచ్చును. అది అపవిత్ర జంతువు శవం గాని, లేక అపవిత్ర పశు శవంగాని, లేక అపవిత్రమైన ఒక పాకెడు జంతువు శవమేగాని కావచ్చును. వాటిని ముట్టుకొన్నట్టు అతనికి తెలియకపోయినా అతడు మాత్రం అపరాధి అవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“ఒక మనిషి నుండి అపవిత్రం అయినవి ఎన్నోవస్తాయి. ఒక వ్యక్తి అవతల వ్యక్తిలోని యిలాంటి అపవిత్రమైన వాటిలో దేనినైనా ముట్టుకోవచ్చు అది అతనికి తెలియకపోవచ్చు. అపవిత్రమైనది ఏదో తాను ముట్టుకొన్నానని అతనికి తెలిసినప్పుడు అతడు అపరాధి అవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“లేక ఒక వ్యక్తి మంచిగాని చెడుగాని ఒకటి చేస్తానని తొందరపడి వాగ్దానం చేయవచ్చు. మనుష్యులు తొందరపడి చాలా వాగ్దానాలు చేస్తూంటారు. ఒకడు అలాంటి వాగ్దానంచేసి, దానిని మరిచిపోయి, మరల ఆ వాగ్దానాన్ని జ్ఞాపకం చేసుకొన్నప్పుడు అతను దానిని చేయక పోతే అపరాధి అవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","కనుక వీటిలో దేని విషయంలో అతడు అపరాధియైనా, అతడు చేసిన తప్పు ఏమిటో అతడు చెప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","అతడు చేసిన పాపానికి పరిహారంగా అపరాధ పరిహారార్థబలిని యెహోవాకు అర్పించాలి. గొర్రెల మందలోనుండి ఒక ఆడ జంతువును పాప పరిహారార్థబలిగా అతడు తీసుకొని రావాలి. అది గొర్రెపిల్ల కావచ్చును, లేక మేక కావచ్చును. అప్పుడు ఆవ్యక్తి పాపాన్ని తుడిచివేసేందుకు చేయాల్సిన వాటిని యాజకుడు చేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ఆ వ్యక్తి గొర్రెపిల్లను ఇవ్వలేకపోతే అతడు రెండు గువ్వలనుగాని, రెండు పావురాలను గాని తీసుకొని రావాలి. ఇవి అతని అపరాధ పరిహారార్థబలి. ఒకటి పాపపరిహారార్థ బలికోసం, మరొకటి దహన బలికోసం. ");
INSERT INTO tel2010_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ఆ వ్యక్తి వాటిని యాజకుని దగ్గరకు తీసుకొని రావాలి. పాపపరిహారార్థ బలిగా మొదట ఒక దాన్ని యాజకుడు అర్పిస్తాడు. యాజకుడు దాని తలను మెడనుండి వేరు చేస్తాడు. కానీ ఆ పక్షిని రెండు భాగాలుగా మాత్రం యాజకుడు విడదీయడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","పాప పరిహారార్థబలి రక్తాన్ని బలిపీఠం ప్రక్కలో యాజకుడు చిలకరించాలి. తర్వాత మిగిలిన రక్తాన్ని బలిపీఠం అడుగున యాజకుడు పోయాలి. అది పాపపరిహారార్థ బలి. ");
INSERT INTO tel2010_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","తర్వాత యాజకుడు చట్టం ప్రకారం దహన బలిగా రెండో పక్షిని అర్పించాలి. ఈ విధంగా యాజకుడు ఆ వ్యక్తి పాపాన్ని తుడిచి వేస్తాడు. మరియు దేవుడు ఆ వ్యక్తిని క్షమిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ఆ వ్యక్తికి రెండు పావురాలను, రెండు గువ్వలను యిచ్చే సామర్థ్యం లేకపోతే తూమెడు మంచి పిండిలో పదోవంతును అతడు తీసుకొని రావాలి. ఇది అతని పాపపరిహారార్థ బలి అర్పణ. ఆ పిండిమీద అతడు నూనె పోయకూడదు. అది పాపపరిహారార్థ బలి గనుక అతడు దానిమీద సాంబ్రాణి కూడా వేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","అతడు ఆ పిండిని యాజకుని దగ్గరకు తీసుకొని రావాలి. ఆ పిండిలోనుండి యాజకుడు పిడికెడు పిండిని జ్ఞాపకార్థ అర్పణగా తీసుకోవాలి. యెహోవాకు హోమం వేయు బలిపీఠం మీద యాజకుడు ఆ పిండిని దహించాలి. అది పాపపరిహారార్థ బలి. ");
INSERT INTO tel2010_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ఈ విధంగా ఆ వ్యక్తి పాపాన్ని యాజకుడు నిర్మూలిస్తాడు. మరియు దేవుడు ఆ వ్యక్తిని క్షమిస్తాడు. ధాన్యార్పణలో వలెనే పాపపరిహారార్థ బలిలో మిగిలినది కూడా యాజకునికి చెందుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“యెహోవా పవిత్ర విషయాలకు వ్యతిరేకంగా ఒకడు పొరబాటున ఏదైనా తప్పు చేయవచ్చును. అప్పుడు అతడు ఏ దోషమూ లేని ఒక పొట్టేలును మందలో నుండి తీసుకొని రావాలి. ఇది యెహోవాకు అతని అపరాధ పరిహారార్థ బలి అర్పణ. పవిత్ర స్థానపు అధికారిక కొలత ప్రకారం ఆ పొట్టేలుకు నీవు ధర నిర్ణయించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","పవిత్ర విషయానికి విరుద్ధంగా అతడు చేసిన పాపానికి అతడు ప్రాయశ్చిత్తం చేసుకోవాలి. ఆ ధరకు అయిదో వంతు అతడు కలపాలి. ఈ మొత్తాన్ని అతడు యాజకునికి ఇవ్వాలి. ఈ విధంగా అపరాధ పరిహారార్థ బలి పోట్టేలుతో ఆ వ్యక్తి పాపాన్ని యాజకుడు నిర్మూలిస్తాడు. దేవుడు ఆ వ్యక్తిని క్షమిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ఒకడు పాపం చేసి, చేయగూడదని యెహోవా ఆజ్ఞాపించిన వాటిలో దేనినైనా చేసినప్పుడు అది అతనికి తెలియకపోయినా ఆ వ్యక్తి అపరాధి అవుతాడు. అతడు తన పాపానికి బాధ్యత వహించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","ఆ వ్యక్తి ఏ దోషమూ లేని ఒక పొట్టేలును మందలోనుండి యాజకుని దగ్గరకు తీసుకొని రావాలి. ఆ పొట్టేలు అపరాధ పరిహారార్థబలి అర్పణ. ఆ వ్యక్తి తెలియక చేసిన పాపాన్ని ఈ విధంగా యాజకుడు నిర్మూలిస్తాడు. దేవుడు ఆ వ్యక్తిని క్షమిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ఆ వ్యక్తి చేస్తున్నది పాపం అని అతనికి తెలియకపోయినా అతడు అపరాధి అవుతాడు. కనుక అపరాధ పరిహారార్థ బలిని అతడు యెహోవాకు అర్పించాలి.” ");
INSERT INTO tel2010_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ఒకడు యిలాంటి పాపాలు చేసి, యెహోవాకు విరోధంగా అపరాధం చేయవచ్చు, ఒక వ్యక్తి మరొకరి పక్షంగా దేనికైనా కాపలా కాస్తూండగా దానికి జరిగిన దాన్ని గూర్చి అతడు అబద్ధం చెప్పవచ్చు, లేక ఒకడు తాను చేసిన ప్రమాణం విషయంలో అబద్ధం చెప్పవచ్చు, లేక ఒకడు దేనినైనా దొంగిలించవచ్చు, లేక ఎవర్నయినా మోసం చేయవచ్చు, ");
INSERT INTO tel2010_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","లేక ఒకడు పోయింది దొరికినప్పుడు దాన్ని గూర్చి అబద్ధం చెప్పవచ్చు, లేక ఒకడు ఏదో చేస్తానని వాగ్దానం చేసి తర్వాత అతడు వాగ్దాన ప్రకారం చేయకపొవచ్చు, లేక ఒకడు ఇంకేదైనా చెడుకార్యం చేయవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ఒక వ్యక్తి వీటిలో ఏదైనా చేస్తే, అప్పుడు ఆ వ్యక్తి అపరాధి అవుతాడు. అతడు దొంగతనంగా తీసుకొన్నదిగాని, మోసంచేసి తీసుకొన్నదిగాని, మరోవ్యక్తి భద్రంగా ఉంచమని ఇవ్వగా అతడు తీసుకొన్నదిగాని, దొరికినా అబద్ధం చెప్పి దాన్ని, లేక ");
INSERT INTO tel2010_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","దేన్ని గూర్చి అతడు అబద్ధ ప్రమాణం చేసాడో దాన్ని అతడు తిరిగి ఇచ్చిచేయాలి. దాని పూర్తివిలువను అతడు చెల్లించాలి. తర్వాత దాని విలువలో అయిదోవంతు అదనంగా అతడు చెల్లించాలి. దాని అసలైన సోంతదారునికి అతడు ఆ మొత్తాన్ని ఇవ్వాలి. అతడు తన అపరాధ పరిహారార్థ బలి తెచ్చిననాడే దీన్ని చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ఆ వ్యక్తి అపరాధ పరిహారార్థ బలిని యాజకుని దగ్గరకు తీసుకొని రావాలి. అది మందలోనుంచి తెచ్చిన పొట్టేలు. ఆ పొట్టేలుకు ఏదోషమూ ఉండకూడదు. అది యాజకుడు నిర్ణయించిన ధరకు తగినదిగా ఉండాలి. అది యెహోవాకు అపరాధ పరిహారార్థ బలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","అప్పుడ యాజకుడు యెహోవా దగ్గరకు వెళ్లి, ఆ వ్యక్తి చేసిన పాపాన్ని నిర్మూలిస్తాడు. అప్పుడు అతణ్ణి దేవుడు క్షమిస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“అహరోనుకు అతని కుమారులకు ఈ ఆజ్ఞ ఇవ్వు. ఇది దహనబలి అర్పణ నియమము. రాత్రి అంతా, తెల్ల వారేవరకు దహనబలి అర్పణ బలిపీఠం మీద దహనం అవుతూనే ఉండాలి. బలిపీఠం మీద బలిపీఠపు అగ్ని మండుతూనే ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","యాజకుడు తన మేలురకపు అంగీని ధరించాలి. అతడు తన మేలు రకపు చెడ్డీని వేసుకోవాలి. తర్వాత బలిపీఠం మీద దహనబలిని అగ్ని దహించగా మిగిలిన బూడిదను అతడు తీసుకోవాలి. ఈ బూడిదను యాజకుడు బలిపీఠం పక్కగా పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","అప్పుడు యాజకుడు తన బట్టలు తీసి వేసి వేరే బట్టలు ధరించాలి. తర్వాత అతడు ఆ బూడిదను బస వెలుపల ఒక ప్రత్యేక స్థలానికి తీసుకొని వెళ్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","అయితే బలిపీఠపు అగ్నిని మాత్రం బలిపీఠం మీద మండుతూ ఉండనివ్వాలి. దానిని ఆరిపోనివ్వ కూడదు. ప్రతి ఉదయం బలిపీఠం మీద యాజకుడు కట్టెలను కాల్చుతూఉండాలి. బలిపీఠం మీద అతడు కట్టెలు పేర్చాలి. సమాధాన బలుల కొవ్వును అతడు దహించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","ఎల్లప్పుడూ ఆగకుండా బలిపీఠం మీద అగ్ని మండుతూ ఉండాలి. అది ఆరిపోకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ధాన్యార్పణలకు గల విధి ఇది. అహరోను కుమారులు యెహోవాకు బలిపీఠం ఎదుట దీనిని తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ధాన్యార్పణలోనుంచి పిడికెడు మంచి పిండిని యాజకుడు తీసుకోవాలి. ధాన్యార్పణ మీద నూనె, సాంబ్రాణి ఉండాలి. ధాన్యార్పణాన్ని బలిపీఠం మీద యాజకుడు దహించాలి. అది ఇష్టమైన సువాసనగాను, యెహోవాకు జ్ఞాపకార్థ అర్పణగాను ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","“మిగిలిపోయిన ధాన్యార్పణాన్ని అహరోను, అతని కుమారులు తినాలి. ధాన్యార్పణ పొంగని రొట్టెలా ఉంటుంది. యాజకులు ఈ రొట్టెను పవిత్ర స్థలంలో తినాలి. సన్నిధి గుడారపు ఆవరలో వారు ఈ ధాన్యార్పణను తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ధాన్యార్పణను పులిసిన పదార్థం లేకుండా చేయాలి. అగ్నిద్వారా నాకు అర్పించబడిన అర్పణల్లో అది వారి భాగంగా నేను దానిని ఇచ్చాను. పాపపరిహారార్థ బలిలా, అపరాధ పరిహారార్థ బలి అర్పణలా అది కూడ అతి పవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","యెహోవాకు అగ్నిద్వారా అర్పించబడిన అర్పణల్లోనుంచి అహరోను మగ సంతానం అందరూ తినవచ్చును. మీ తరాలన్నింటికీ ఇది శాశ్వత నియమము. ఈ అర్పణలస్పర్శ వారిని పవిత్రులను చేస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“అహరోను, అతని కుమారులు యెహోవాకు తీసుకొని రావాల్సిన అర్పణలు ఇవి. అహరోను అభిషేకించబడిన రోజున వారు ఇలా చేయాలి. తూమెడు మంచి పిండిలో పదోవంతు వారు ఎల్లప్పుడూ ధాన్యార్పణగా తీసుకొనిరావాలి. అందులోనుంచి సగం ఉదయం, సగం సాయంత్రం వారు తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","మంచి పిండిని నూనెతో కలిపి, పెనం మీద దాన్ని చేయాలి. అది ఉడికిన తర్వాత దానిని మీరు లోనికి తీసుకొని రావాలి. ధాన్యార్పణాన్ని మీరు భాగాలుగా చేయాలి. దానిని మీరు యెహోవాకు ఇష్టమైన సువాసనగా దహించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","“అహరోను, తర్వాత అతని సంతానంవారు ఎవరైతే అహరోను స్థానంలో అభిషేకించబడతారో వారు ఈ ధాన్యార్పణాన్ని యెహోవాకు పెట్టాలి. ఇది శాశ్వత నియమము, ధాన్యార్పణాన్ని యెహోవాకు పూర్తిగా దహించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","యాజకుల ప్రతీ ధాన్యార్పణను పూర్తిగాకాల్చాలి. దానిని తినకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“అహరోను, అతని కుమారులతో ఇలా చెప్పు: పాప పరిహారార్థ అర్పణ విధి ఇది. యెహోవా ఎదుట దహనబలి పశువు వధించబడే చోటనే పాపపరిహారార్థ బలి పశువుకూడ అర్పించ బడాలి. అది అతి పరిశుద్ధం. ");
INSERT INTO tel2010_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","పాప పరిహారార్థబలిని అర్పించే యాజకుడే దానిని తినాలి. సన్నిధి గుడారం యొక్క ఆవరణలో ఒక పరిశుద్ధ స్థలంలో అతడు దానిని తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","పాప పరి హారార్థబలి మాంసాన్ని తాకిన ప్రతి ఒక్కడూ పరిశుద్ధుడవుతాడు. మరియు తాకిన ప్రతి వస్తువూ పరిశుద్ధం అవుతుంది. “చిలకరించబడిన రక్తం ఏ బట్టలమీద పడినా, మీరు ఆ బట్టలను ఉతకాలి. పరిశుద్ధ స్థలంలో మీరు ఆ బట్టలను ఉతకాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","పాపపరిహారార్థ బలి గనుక మట్టి పాత్రలో ఉడకబెడితే ఆ పాత్రను పగుల గొట్టివేయాలి. పాపపరిహారార్థ బలిని ఇత్తడి పాత్రలో ఉడకబెడితే ఆ పాత్రను తోమి, నీళ్లతో కడగాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","“యాజకులలో ప్రతి ఒక్కడూ పాపపరిహారార్థ బలిని తినవచ్చును. అది అతి పరిశుద్ధం. ");
INSERT INTO tel2010_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","కానీ పాపపరిహారార్థ బలి రక్తాన్ని గనుక పరిశుద్ధస్థలాన్ని శుద్ధి చేసేందుకని సన్నిధి గుడారంలోనికి తీసుకొని వెళ్తే, అప్పుడు ఆ పాపపరిహారార్థ బలిని అగ్నిలో కాల్చి వేయాలి. ఆ పాపపరిహారార్థ బలిని యాజకులు తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“అపరాధ పరిహారార్థ బలుల నియమాలు ఇవి. ఇది అతి పరిశుద్ధం. ");
INSERT INTO tel2010_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","దహనబలి అర్పణలు వారు ఎక్కడ వధిస్తారో అక్కడే అపరాధ పరిహారార్థ బలులను కూడా యాజకుడు వధించాలి. అంతట యాజకుడు అపరాధ పరిహారార్థ బలి రక్తాన్ని బలిపీఠం చుట్టూ చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","“అపరాధ పరిహారార్థ బలిలోని కొవ్వు అంతటినీ యాజకుడు అర్పించాలి. దాని కొవ్విన తోకను, దాని లోపలి భాగాలమీది కొవ్వును, ");
INSERT INTO tel2010_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","రెండు మూత్ర గ్రంథులను, వాటిమీద కొవ్వును, నడుందగ్గరి కొవ్వును, కార్జం యొక్క కొవ్విన భాగాన్ని అతడు అర్పించాలి. దానిని మూత్ర గ్రంథులతో బాటు అతడు తీసివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","వీటన్నింటినీ బలిపీఠం మీద యాజకుడు దహించాలి. అవి యెహోవాకు హోమంగా అర్పించబడ్డ అర్పణలు అవుతాయి. అది అపరాధ పరిహారార్థబలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","“యాజకుని కుటుంబంలో ఏ పురుషుడై నాసరే అపరాధపరిహారార్థ బలిని తినవచ్చును. అది అతి పరిశుద్ధం గనుక దాన్ని ఒక పరిశుద్ధ స్థలంలోనే తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","అపరాధి పరిహారార్థ బలి కూడా పాపపరిహారార్థ బలిలాంటిదే. రెండు అర్పణలకు నియమాలు ఒక్కటే. బలులను చేసే యాజకుడు ఆహారంగా ఆ మాంసం తీసుకొంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","బలి అర్పణ చేసే యాజకుడు దహన బలిపశువు చర్మాన్ని కూడా తీసుకోవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ధాన్యార్పణ పెట్టే యాజకునికే ప్రతి ధాన్యార్పణ చెందుతుంది. పొయ్యిమీద వండిన ప్రతి ధాన్యార్పణ, పాత్రలోగాని, పెనంమీదగాని వండిన ప్రతి ధాన్యార్పణ ఆ యాజకునిదే అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ధాన్యార్పణలన్నీ అహరోను కుమారులకే చెందుతాయి. అవి పొడివైనా, లేక నూనెతో కలుపబడినా భేదం ఏమీ లేదు. అహరోను కుమారులు (యాజకులు) అందరూ ఈ ఆహారాన్ని పంచుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ఒక వ్యక్తి యెహోవాకు అర్పించాల్సిన సమాధాన బలులను గూర్చిన విధి ఇది. ");
INSERT INTO tel2010_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","ఆ వ్యక్తి తన కృతజ్ఞతలు తెలుపుకొనేందుకు సమాధాన బలులు తేవచ్చును. కృతజ్ఞతలు చెల్లించేందుకు అతడు తన బలిని తీసుకొని వచ్చినట్లయితే, నూనెతో కలుపబడిను పులియని రొట్టెలను, నూనె పూసిన పొంగని అప్పడాలు, నూనెకలిపి కాల్చబడిన గోధుమ పిండివంటలు అతడు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","సమాధాన బలితో బాటు, పులియని రొట్టెలనుగూడ అతడు అర్పణగా తీసుకొనిరావాలి. ఇది ఒకడు తన కృతజ్ఞతను దేవునికి తెలియజేసేందుకు తీసుకొని రావాల్సిన అర్పణను గూర్చిన విధి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","సమాధాన బలుల రక్తాన్ని చిలకరించే యాజకునికి ఆ రొట్టెలలో ఒకటి చెందుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ఈ సమాధాన బలి అర్పించిన రోజునే దాని మాంసం తినివేయాలి. దేవునికి కృతజ్ఞతలు తెలియజేసేందుకు ఒక పద్ధతిగా ఒకడు కానుక అర్పిస్తాడు. కాని దాని మాంసంలో ఏమీ మర్నాటి ఉదయం వరకు మిగిలి ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ఒక వ్యక్తి కేవలం దేవునికి ఒక కానుకగా మాత్రమే సమాధాన బలిని తేవచ్చును. లేక ఒక వ్యక్తి దేవునికి ఒక ప్రత్యేక వాగ్దానం చేసుకొని ఉండొచ్చు. అదే నిజ మైతే ఆ బలిని అర్పించిన రోజునే దాన్ని తినివేయాలి. ఒకవేళ ఏమైనా మిగిలితే, మర్నాడు దాన్ని తినివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","అయితే ఈ బలి పశువు మాంసం మూడోరోజుకు కూడా మిగిలి ఉంటే దానిని నిప్పుమీద కాల్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","సమాధాన బలిలోని మాంసాన్ని ఎవరైనా మూడో రోజున తింటే. ఆ వ్యక్తి విషయంలో యెహోవా సంతోషించడు. ఆ బలిని అతని పక్షంగా యెహోవా లెక్కించడు. ఆ బలి ఆపవిత్రం అవుతుంది. ఆ మాంసంలో ఏదైనా తిన్నవాడు తన పాపానికి తానే బాధ్యుడవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ఏదైనా అపవిత్రమైన దానికి తగిలిన మాంసాన్ని కూడా ప్రజలు తినకూడదు. అలాంటి మాంసాన్ని వారు అగ్నితో కాల్చివేయాలి. పరిశుద్ధమైన ప్రతివ్యక్తీ మాంసం తినవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","కానీ అపవిత్రమైనవాడు ఒకడు, యెహోవాకు చెందిన సమాధాన బలి మాంసం తిన్నట్లయితే, అతణ్ణి తన ప్రజల్లోనుండి వేరు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","“ఒకవేళ ఒక వ్యక్తి ఏదైనా అపవిత్రమైన దాన్ని ముట్టవచ్చు. అది మనుష్యులచేత అపవిత్రం చేయబడిందే కావచ్చు లోక అపవిత్రమైన జంతువు కావచ్చు లేక అసహ్యకరమైన అపవిత్రత కావచ్చును. అలాంటివాడు అపవిత్రుడు. యెహోవాకు చెందిన సమాధాన బలి మాంసం అతడు తిన్నట్లయితే ఆ వ్యక్తిని అతని ప్రజల్లోనుండి వేరు చేయాలి.” ");
INSERT INTO tel2010_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“ఇశ్రాయేలు ప్రజలతో పశువుల, గొర్రెల, మేకల కొవ్వును మీరు తినకూడదని చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","వాటంతట అవే చచ్చినా, లేక యితర జంతువుల చేత చంపబడినా వాటి కొవ్వును మీరు వాడుకోవచ్చును. కాని దాన్ని మాత్రం ఎప్పుడూ తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","యెహోవాకు హోమంగా అర్పించబడిన జంతువు కొవ్వును ఒక వ్యక్తి తింటే ఆ వ్యక్తిని అతని ప్రజల్లోనుంచి వేరు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","“మీరు ఎక్కడ నివసించినాసరే జంతువు రక్తంగాని, పక్షిరక్తంగాని ఎప్పుడూ మీరు తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ఎవరైనా సరే ఈ రక్తాన్ని తింటే ఆ వ్యక్తిని అతని ప్రజల్లోనుంచి వేరుచేయాలి.” ");
INSERT INTO tel2010_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పు, ఒక వ్యక్తి సమాధాన బలిని యెహోవాకు తీసుకొని వస్తే ఆ కానుకలో కొంత భాగాన్ని యెహోవాకు ఆ వ్యక్తి ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","కానుకలోని ఆ భాగాన్ని హోమంగా కాల్చాలి. ఆ కానుకను అతడు స్వయంగా తన చేతుల్తో తీసుకొని రావాలి. ఆ జంతువు బోరమీదనున్న కొవ్వును, బోరను యాజకుని దగ్గరకు అతడు తీసుకొని రావాలి. ఆ బోర యెహోవా ఎదుట పైకి ఎత్తబడుతుంది. ఇదే ఆ నైవేద్యము. ");
INSERT INTO tel2010_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","అప్పుడు యాజకుడు బలిపీఠం మీద కొవ్వును దహించాలి. అయితే ఆ జంతువు బోర అహరోనుకు, అతని కుమారులకు చెందుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","సమాధాన బలి పశువు కుడితొడ కూడా మీరు యాజకునికి ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","సమాధాన బలి పశువు రక్తాన్ని మరియు కొవ్వును అర్పించే యాజకునికే సమాధాన అర్పణలోని కుడి తొడ చెందుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","నైవేద్యంలోని బోరను, సమాధాన అర్పణలోని కుడి తొడను ఇశ్రాయేలు ప్రజలనుండి నేను తీసుకొని, అహరోనుకు, మరియు అతని కుమారులకు నేను వాటినిస్తున్నాను. ఇది ఇశ్రాయేలు ప్రజలకు శాశ్వతమైన విధి.” ");
INSERT INTO tel2010_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","యెహోవాకు అగ్నిచేత అర్పించబడు అర్పణల్లో, ఆ భాగాలు అహరోనుకు, అతని కుమారులకు చెందుతాయి. అహరోనుకు, అతని కుమారులు యెహోవాకు యాజకులుగా పని చేసినప్పుడు బలి అర్పణల్లో వారికి కొంతభాగం లభిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","యెహోవా, యాజకులను అభిషేకించినప్పుడే ఈ విషయాన్ని చెప్పాడు, ఇశ్రాయేలు ప్రజలు ఆ భాగాలను యాజకులకు ఇవ్వవలెను. వారి తరాలన్నింటిలో శాశ్వతంగా వారు ఆ భాగాలను యాజకులకు ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","దహన బలి అర్పణ, నైవేద్యము, పాపపరిహారార్థ బలి, అపరాధ పరిహారార్థ బలి, యాజకుల నియామకం, సమాధాన బలి విధులు అవి. ");
INSERT INTO tel2010_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","సీనాయి పర్వతంమీద మోషేకు యెహోవా వాటిని ఇచ్చాడు. సీనాయి ఎడారిలో ఇశ్రాయేలు ప్రజలు యెహోవాకు వారి అర్పణలు తీసుకొని రావాలని ఆయన ఆజ్ఞాపించిన రోజునే ఈ విధులను యెహోవా ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“అహరోనును, అతని కుమారులను, వారి వస్త్రాలు, అభిషేకించే తైలాన్ని, పాపపరిహారార్థపు కోడెదూడ, రెండు పొట్టేళ్ళను, ఒక గంపెడు పులియని రొట్టెలను నీతో తీసుకొని, ");
INSERT INTO tel2010_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ప్రజలందరినీ సన్నిధి గుడారం యొక్క ద్వారం దగ్గర సమావేశపర్చు.” ");
INSERT INTO tel2010_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","యెహోవా తనకు ఆజ్ఞాపించినట్లే మోషే చేసాడు. ప్రజలు సన్నిధి గుడారం దగ్గర సమావేశం అయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","అప్పుడు మోషే, “చేయవలసినదానిని యెహోవా సెలవిచ్చాడు.” ");
INSERT INTO tel2010_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","అప్పుడు అహరోనును, అతని కుమారులను మోషే తీసుకొని వచ్చాడు. అతడు వారికి నీళ్లతో స్నానం చేయించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","అప్పుడ అహరోనుకు మోషే చొక్కా తొడిగించాడు. అహరోనుకు నడికట్టును మోషే చుట్టాడు. అంతట ఒక నిలువుపాటి అంగీని మోషే అహరోనుకు తొడిగించాడు. తర్వాత మోషే ఏఫోదును అహరోనుకు ధరింపజేసాడు. నైపుణ్యంగా అల్లిక చేయబడిన నడికట్టును మోషే అహరోను నడుముకు బిగించాడు. ఆ విధంగా ఏఫోదును అహరోనుకు మోషే ధరింపజేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","తర్వాత మోషే, న్యాయతీర్పు పైవస్త్రంలో ఊరీము, తుమ్మీములను ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","అహరోను తలమీద తలపాగాను కూడా మోషే పెట్టాడు. ఈ తలపాగా ముందర భాగంలో బంగారు బద్దను మోషే పెట్టాడు. ఈ బంగారు బద్ద పరిశుద్ధ కిరీటం. యెహోవా తనకు ఆజ్ఞాపించినట్లు మోషే ఇలా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","తర్వాత మోషే అభిషేక తైలాన్ని తీసుకొని పవిత్ర గుడారాన్నీ, దానిలోని వస్తువులన్నిటినీ ప్రతిష్ఠించాడు. ఈ విధంగా వాటిని మోషే పరిశుద్ధం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ఆ అభిషేక తైలంలో కొంత బలిపీఠం మీద ఏడుసార్లు మోషే చిలకపించాడు. బలిపీఠం, దాని పరికరాలు, పాత్రలు అన్నింటినీ మోషే ప్రతిష్ఠించాడు. గంగాళాన్ని, దాని పీటను కూడా మోషే ప్రతిష్ఠించాడు. ఈవిధంగా మోషే వాటిని పరిశుద్ధం చేశాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","అప్పుడు అభిషేక తైలంలో కొంత అహరోను తలమీద మోషే పోసాడు, ఈ విధంగా అహరోనును అతడు పరిశుద్ధం చేశాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","అప్పుడు మోషే అహరోను కుమారులను తీసుకొనివచ్చి, వారికి ప్రత్యేకమైన చొక్కాలను తొడిగించాడు. అతడు వారికి ప్రత్యేకమైన చొక్కాలను తొడిగించాడు. అతడు వారికి దట్టీలు కట్టాడు. తర్వాత వారి తలలమీద పాగాలను అతడు చుట్టాడు. యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారమే మోషే ఇవన్నీ చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","అప్పుడు పాపపరిహారార్థ బలిగా ఒక కోడెదూడను మోషే తీసుకొనివచ్చాడు. పాపపరిహారార్థ బలికొరకైన కోడె దూడ తలమీద అహరోను, అతని కుమారులు వారి చేతులు ఉంచారు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","అప్పుడు మోషే ఆ కోడె దూడను వధించి, దాని రక్తాన్ని తీసాడు. మోషే కొంచెం రక్తం తీసుకొని, తన వ్రేలితో దానిని బలిపీఠపు కొమ్ములన్నింటి మీద చల్లాడు. ఈ విధంగా బలిపీఠాన్ని బలులకోసం మోషే సిద్ధం చేసాడు, తర్వాత ఆ రక్తాన్ని బలిపీఠపు అడుగున మోషే పోసాడు. ఈ విధంగా ప్రజల పాపాలను పరిహారం చేసే బలుల కోసం బలిపీఠాన్ని మోషే సిద్ధం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","ఆ కోడెదూడ లోపలి భాగాలనుండి కొవ్వు అంతటినీ మోషే తీసాడు. కాలేయం యొక్క కొవ్విన భాగాన్ని, రెండు మూత్ర పిండాలను, వాటిమీద కొవ్వును మోషే తీసి బలిపీఠం మీద వాటిని దహించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","అయితే ఆ కోడెదూడ చర్మాని దాన్ని మాంసాన్ని, దాని పేడను వారి బస వెలుపలకు మోషే తీసుకుపోయాడు. నివాసానికి వెలుపల మంట వేసి అందులో వాటిని మోషే కాల్చివేసాడు. యెహోవా తనకు ఆజ్ఞాపించినట్లే మోషే అవన్నీ చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","తర్వాత మోషే దహనబలి పొట్టేలును తీసుకొచ్చాడు. అహరోను, అతని కుమారులు ఆ పొట్టేలు తలమీద వారి చేతులు ఉంచారు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","అప్పుడు మోషే ఆ పొట్టేలును వధించి, దాని రక్తాన్ని బలిపీఠం చుట్టూ చల్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","పొట్టేలును మోషే ముక్కలుగా కోసాడు. లోపలి భాగాలను, కాళ్లను, నీళ్ళతో మోషే కడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","తర్వాత మొత్తం పొట్టేలును బలిపీఠం మీద మోషే దహించాడు. తలను, భాగాలను, కొవ్వును మోషే దహించాడు. అది హోమంగా అర్పించబడిన దహనబలి. అది యెహోవాకు ఇష్టమైన సువాసన. యెహోవా ఆజ్ఞాపించినట్లే మోషే వాటిని చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","అప్పుడు మోషే మరొక పొట్టేలును తీసుకొచ్చాడు. అహరోనును, అతని కుమారులను యాజకులుగా నియమించుటకు ఈ పొట్టేలు ఉపయోగించబడింది. అహరోను, అతని కుమారులు ఆ పోట్టేలు తలమీద వారి చేతులు ఉంచారు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","అప్పుడు మోషే ఈ పోట్టేలును వధించాడు. దాని రక్తంలో కొంత అతడు తీసుకొని, అహరోను చెవి కొనమీద, కుడిచేతి బొటన వేలిమీద, అహరోను కుడికాలి బొటనవేలి మీద వేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","తర్వాత అహరోను కమారులను బలిపీఠం దగ్గరకు మోషే తీసుకొని వచ్చాడు. ఆ రక్తంలో కొంత వారి కుడి చెవుల కొనలమీద, కుడి చేతుల బొటనవేళ్ళమీద, వారి కుడి కాళ్ల బొటనవ్రేళ్ల మీద మోషే వేసాడు. తర్వాత బలిపీఠంచుట్టూ ఆ రక్తాన్ని మోషే చిలకరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","కొవ్వును, కొవ్విన తోకను, లోపలి భాగాలమీద కొవ్వు అంతటినీ, కాలేయం యొక్క కొవ్విన భాగాన్ని రెండు మూత్ర పిండాలను, వాటి కొవ్వును, కుడి తొడను మోషే తీసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ఒక గంపెడు పులియని రొట్టెలు ప్రతిరోజూ యెహోవా ముందు ఉంచబడ్డాయి. ఆ రొట్టెల్లో నూనె కలిపి చేయబడ్డ రొట్టె ఒకటి, పులియని రొట్టెల్లోనుంచి ఒక రొట్టెను మోషే తీసుకొని, పొట్టేలు కుడి తొడమీద, కొవ్వుమీద ఆ రొట్టె ముక్కల్ని ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","తర్వాత మోషే వాటన్నింటినీ అహరోను, అతని కుమారుల చేతుల్లో పెట్టాడు. నైవేద్యంగా ఆ ముక్కలను యెహోవా ఎదుట మోషే అల్లాడించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","అప్పుడు అహరోను అతని కుమారుల చేతుల్లోనుండి మోషే వాటిని తీసుకొన్నాడు. బలిపీఠం మీద దహనబలిగా వాటిని దహించాడు. కాబట్టి అహరోనును, అతని కుమారులను యాజకులుగా నియమించుటకు అర్పణ అది. అది అగ్నితో అర్పించబడిన అర్పణ. అది యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2010_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","దాని బోరను మోషే తీసుకొని, యెహోవా ఎదుట అర్పణగా దానిని అల్లాడించాడు. యాజకులను నియమించుటలో పొట్టేలు యొక్క ఆ భాగం మోషేకు చెందుతుంది. ఇది యెహోవా మోషేకు ఆజ్ఞాపించినట్టు జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","బలిపీఠం మీద ఉన్న అభిషేకతైలం కొంత, రక్తం కొంత మోషే తీసుకొన్నాడు. అందులో కొంచెం అహరోను మీద, అతని వస్త్రాల మీద, మరియు అహకోనుతో ఉన్న అతని కుమారుల మీద, వారి వస్త్రాల మీద కొంచెం చల్లాడు. ఈ విధంగా అహరోనును అతని వస్త్రాలను, అతని కుమారులను వారి వస్త్రాలను మోషే పవిత్రం చేసాడు. బలులు, అర్పణల నియమాలు ");
INSERT INTO tel2010_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","అప్పుడు అహరోనుతో, అతని కుమారులతో మోషే ఇలా చెప్పాడు: “మీకు నా ఆజ్ఞ జ్ఞాపకం ఉందా? ‘అహరోను, అతని కుమారులు వీటిని తినాలి’ అని నేను చెప్పాను. కనుక నియామక కార్యక్రమంనుండి రొట్టెలు, మాంసం ఉన్న గంప తీసుకోండి. సన్నిధి దగ్గర ఆ మాంసాన్ని ఉడకబెట్టండి. ఆ రొట్టెను ఆ మాంసాన్ని అక్కడే మీరు తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","రొట్టెగాని మాంసాన్నిగాని ఏమైనా మిగిలిపోతే, దాన్ని కాల్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","నియామక క్రమం ఏడు రోజులపాటు ఉంటుంది. మీ అభిషేకం పూర్తి అయ్యేంతవరకు మీరు సన్నిధి గుడారంనుండి బయటకు వెళ్ల కూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ఈ వేళ మనం చేసిన వాటన్నింటినీ చేయుమని యెహోవా ఆజ్ఞాపించాడు. మీ పాపాలను తుడిచివేసేందుకు ఆయన వీటిని ఆజ్ఞాపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","ఏడు రోజుల పాటు రాత్రింబవళ్లు సన్నిధి గుడారం దగ్గరే మీరు నిలిచి ఉండాలి. యెహోవా ఆజ్ఞలకు మీరు విధేయులు కాకాపోతే మీరు చనిపోతారు. ఈ ఆజ్ఞలు నాకు యెహోవా ఇచ్చాడు.” ");
INSERT INTO tel2010_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","కనుక యెహోవా మోషేకు ఆజ్ఞాపించిన వాటన్నింటినీ అహరోను, అతని కుమారులు జరిగించారు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ఎనిమిదో రోజున అహరోనును, అతని కుమారులను మోషే పిలిచాడు. ఇశ్రాయేలు పెద్దలను కూడా అతడు పిలిచాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","అహరోనుతో మోషే చెప్పాడు, “ఒక కోడెదూడను, పొట్టేలును తీసుకొని రండి. వాటిలో ఏ దోషం ఉండకూడదు. కోడెదూడ పాపపరిహారార్థ (బలి) విషయమై పొట్టేలు దహనబలి. వాటిని యెహోవాకు అర్పించండి. ");
INSERT INTO tel2010_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ఇశ్రాయేలు ప్రజలతో ఇలా చెప్పండి, ‘పాపపరిహారార్థ బలిగా ఒక మగ మేకను తీసుకోండి. దహన బలికోసం ఒక కోడెదూడను, ఒక గొర్రెపిల్లను తీసుకోండి. కోడెదూడ, గొర్రెపిల్ల ఒక్క సంవత్సరం వయస్సుగలవి కావాలి. ఆ జంతువుల్లో ఏ దోషమూ ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","సమాధాన బలుల కోసం ఒక కోడెదూడను, ఒక పొట్టేలును తీసుకోండి. ఆ జంతువులను, నూనెతో కలుపబడ్డ నైవేద్యాన్ని తీసుకొని, వాటిని యెహోవాకు అర్పించండి. ఎందుకంటే ఈవేళ యెహోవా మీకు ప్రత్యక్ష మవుతాడు.’” ");
INSERT INTO tel2010_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","కనుక ప్రజలంతా సన్నిధి గుడారం దగ్గరకు వచ్చారు. మోషే ఆజ్ఞాపించిన వాటన్నింటినీ వారంతా తీసుకొచ్చారు. ప్రజలంతా యెహోవా ఎదుట నిలబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","“యెహోవా ఆజ్ఞప్రకారం మీరు చేసారు కనుక యెహోవా మహిమను మీరు చూస్తారు” అన్నాడు మోషే. ");
INSERT INTO tel2010_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","అప్పుడు అహరోనుతో మోషే ఈ సంగతులు చెప్పాడు: “వెళ్లి, యెహోవా ఆజ్ఞాపించిన వాటిని జరిగించు. బలిపీఠం దగ్గరకు వెళ్లి, పాపపరిహారార్థ బలులు, దహనబలి అర్పణలు అర్పించు. మీ పాపాలు, ప్రజల పాపాలు తుడిచివేయబడేందుకు వాటిని జరిగించు. ప్రజల బలులను నీవు తీసుకొని, వారి పాపాలను పరిహరించే వాటిని జరిగించు.” ");
INSERT INTO tel2010_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","కనుక అహరోను బలిపీఠం దగ్గరకు వెళ్లాడు. పాపపరిహారార్థ బలికోసం కోడె దూడను అతడు వధించాడు. ఈ పాపపరిహారార్థ బలి అతని కోసమే. ");
INSERT INTO tel2010_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","అప్పుడు అహరోను కుమారులు ఆ రక్తాన్ని అహరోను దగ్గరకు తెచ్చారు. అహరోను తన వేలు ఆ రక్తంలో ముంచి, బలిపీఠం కొమ్ములమీద దాన్ని చల్లాడు. తర్వాత అహరోను ఆ రక్తాన్ని బలిపీఠం అడుగున పోసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","పాపపరిహారార్థ బలిలోనుంచి కొవ్వును, మూతగ్రంథులను, కాలేయం యొక్క కొవ్విన భాగాన్ని అహరోను తీసుకొని, బలిపీఠం మీద అతడు వాటిని దహించాడు. మోషేకు యెహోవా ఆజ్ఞాపించినట్లే అతడు అలా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","తర్వాత మాంసాన్ని, చర్మాన్ని పాళెము వెలుపల అగ్నితో అహరోను కాల్చివేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","తర్వాత, దహనబలి పశువును అహరోను వధించాడు. అది ముక్కలుగా కోయబడింది. దాని రక్తాన్ని అహరోను కుమారులు అహరోను దగ్గరకు తీసుకొని వచ్చారు. అహరోను ఆ రక్తాన్ని బలిపీఠం చుట్టూ చిలకరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","దహనబలి పశువు యొక్క ముక్కలను, దాని తలను అహరోను కుమారులు అహరోనుకు అందించారు. అప్పుడు అహరోను వాటిని బలిపీఠం మీద దహించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","దహన బలి పశువు లోపలి భాగాలను, కాళ్లను కూడా అహరోను కడిగాడు. వాటిని బలిపీఠం మీద అతడు కాల్చివేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","తర్వాత ప్రజల అర్పణను అహరోను తీసుకొచ్చాడు. ప్రజల పాప పరిహారార్థ బలిగా మేకను వధించాడు. మొదటిదాని వలెనే అతడు పాప పరిహారార్థంగా ఆ మేకను అర్పించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","అహరోను దహనబలి తీసుకొనివచ్చి అర్పించాడు. యెహోవా ఆజ్ఞప్రకారం అహరోను చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","అహరోను బలిపీఠం దగ్గరకు ధాన్యార్పణను తీసుకువచ్చాడు. అతడు గుప్పెడు ధాన్యార్పణ తీసుకొని, బలిపీఠం మీద ఆనాటి అనుదిన బలిని పక్కగా పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","ప్రజల సమాధాన బలి అర్పణలుగా కోడెదూడను, పొట్టేలును కూడ అహరోను వధించాడు. అహరోను కుమారులు రక్తాన్ని అహరోను దగ్గరకు తెచ్చారు. ఈ రక్తాన్ని అహరోను బలిపీఠం చుట్టూ చిలకరించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","కోడెదూడ, పొట్టేలు కొవ్వునుకూడ అహరోను కుమారులు అహరోను దగ్గరకు తెచ్చారు. కొవ్విన తోకను లోపలి భాగాలమీది కొవ్వును మూతగ్రంథులను, కాలేయము యొక్క కొవ్విన భాగాన్ని వారు తీసుకొచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","కొవ్విన ఈ భాగాలను కోడెదూడ, పొట్టేలు బోరలమీద అహరోను కుమారులు ఉంచారు. కొవ్విన ఈ భాగాలను బలిపీఠం మీద అహరోను కాల్చివేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","మోషే ఆజ్ఞాపించిన ప్రకారం నైవేద్యంగా బోరలను, కుడితొడను యెహోవా ఎదుట అహరోను అల్లాడించాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","అప్పుడు అహరోను ప్రజల వైపుగా తన చేతులు ఎత్తి వారిని ఆశీర్వదించాడు. అహరోను పాపపరిహారార్థ బలి అర్పణను, దహనబలి అర్పణను, సమాధాన బలి అర్పణ, అర్పించటం ముగించిన తర్వాత అతడు బలిపీఠం నుండి దిగి వచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","మోషే, అహరోనులు సన్నిధి గుడారం లోపలకు వెళ్లారు. వారు బయటకు వచ్చి ప్రజలను ఆశీర్వదించారు. యెహోవా మహిమ ప్రజలందరికీ కనబడెను. ");
INSERT INTO tel2010_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","యెహోవా నుండి అగ్ని వచ్చి బలిపీఠం మీది దహన బలిని, కొవ్వును దహించి వేసింది. ప్రజలంతా ఇది చూచినప్పుడు ఉత్సాహధ్వనిచేసి సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","అప్పుడు అహరోను కుమారులైన నాదాబు, అబీహులు పాపం చేసారు. ధూపం వేసేందుకు ఒక్కో కుమారుడు ఒక్కో ధూపార్తిని తీసుకొన్నాడు. వారు వేరే నిప్పు తీసుకొని ధూపం అంటించారు. వారు ఉపయోగించాలని దేవుడు ఆజ్ఞాపించిన నిప్పును వారు ఉపయోగించలేదు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","కనుక యెహోవా నుండి అగ్ని వచ్చి నాదాబు, అబీహులను నాశనం చేసింది. యెహోవా ఎదుట వారు మరణించారు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","అప్పుడు అహరోనుతో మోషే ఇలా చెప్పాడు: “యెహోవా ఈలాగు సెలవిస్తున్నాడు, ‘నా దగ్గరకు వచ్చే యాజకులు నన్ను గౌరవించాలి. వారికీ, ప్రజలందరికీ నేను పరిశుద్ధుడుగా ఉండాలి.’” కనుక అహరోను తన కుమారుల చావునుగూర్చి ఏమీ అనలేదు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","అహరోను పినతండ్రియైన ఉజ్జీయేలుకు ఇద్దరు కుమారులుండిరి. వారు మిషాయేలు, ఎల్సాఫాను. “పరిశుద్ధ స్థలం ముందునకు వెళ్లండి. మీ సోదరుల శవాలను బస వెలుపలకు తీసుకొని పొండి” అని మోషే వారిద్దరితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","కనుక మిషాయేలు, ఎల్సాఫాను మోషేకు విధేయులయ్యారు. నాదాబు, అబీహు శవాలను బస వెలుపలకు వారు మోసుకొని పోయారు. నాదాబు, అబీహు అప్పటికి ఇంకా వారి ప్రత్యేక చొక్కాలు ధరించే ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","అప్పుడు అహరోనుతోను, అతని ఇతర కుమారులు ఎలీయాజరు, ఈ తామారులతో మోషే ఇలా మాట్లాడాడు. “ఏమి విచారపడకండి. మీబట్టలు చింపుకోవద్దు, జుట్టు చిందరవందర చేసుకోవద్దు. మీరు అలాంటివి చేయకుండా ఉంటే మీరు చావకుండా ఉంటారు. అలానే యెహోవా తన ప్రజలందరి మీద కోపగించకుండా ఉంటాడు. ఇశ్రాయేలు జాతి మొత్తం మీ బంధువులే. నాదాబు, అబీహులను యెహోవా కాల్చివేసినందుకు వారంతా ఏడుస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","కాని మీరు మాత్రం సన్నిధి గుడారం వదిలి వెళ్లకూడదు. ఆ ద్వారం నుండి కనుక మీరు బయటకు వెళ్తే మీరు చనిపోతారు. ఎందుచేతనంటే యెహోవా ప్రత్యేక తైలం మీమీద ఉంది.” గనుక అహరోను, ఎలీయాజరు, ఈతామారు మోషేకు విధేయులయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","అప్పుడు అహరోనుతో యెహోవా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“మీరు సన్నిధి గుడారంలోనికి వచ్చేటప్పుడు నీవుగాని నీ కుమారులుగాని ద్రాక్షారసం, మద్యం తాగకూడదు. మీరు అలాంటివి చేస్తే చనిపోతారు. మీతరాలన్నింటికీ ఈ ఆజ్ఞ శాశ్వతంగా కొనసాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","పవిత్రం, అపవిత్రం అనే నిర్దిష్టమైన వ్యత్యాసాన్ని మీరు పాటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","యెహోవా తన ఆజ్ఞలను మోషేకు ఇచ్చాడు, వాటిని మోషే ప్రజలకు ఇచ్చాడు. అహరోనూ, నీవు ఆ ఆజ్ఞలు అన్నింటి విషయమై ప్రజలకు ప్రబోధించాలి.” ");
INSERT INTO tel2010_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","అహరోనుకు ఎలీయాజరు, ఈ తామారు అనే ఇద్దరు కుమారులు ఇంకా బతికి ఉన్నారు. అహరోనుతో, అతని ఇద్దరు కుమారులతో మోషే ఇలా అన్నాడు: “అగ్నిచే దహించబడిన బలులలో ధాన్యార్పణ కొంత మిగిలిపోయింది. ధాన్యార్పణంలోని ఆ భాగాన్ని మీరు తినాలి. అయితే అందులో పొంగే పదార్థం కలుపకుండా మీరు తినాలి. బలిపీఠం దగ్గరే దాన్ని తినాలి. ఎందుచేతనంటే ఆ అర్పణ అతి పరిశుద్ధం. ");
INSERT INTO tel2010_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","అది యెహోవా కోసం అగ్నిమీద దహించబడిన అర్పణలలో భాగమైయున్నది. ఆ భాగం నీకు నీ కుమారులకు చెందుతుంది అని నీకు నేను ఇచ్చిన ఆజ్ఞ ప్రబోధిస్తుంది. అయితే ఒక పరిశుద్ద స్థలంలోనే మీరు దాన్ని తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","“మరియు నీవు, నీ కుమారులు, నీ కుమార్తెలు, నైవేద్యంల్లోనుంచి బోరను తినవచ్చును. మీరు వాటిని పవిత్ర స్థలంలో తినాల్సిన అవసరం లేదు గాని పరిశుభ్రమైన స్థలంలో తినాలి. ఎందుచేతనంటే అవి సమాధాన బలిలోనివి. ఆ కానుకలను ఇశ్రాయేలు ప్రజలు దేవునికి ఇస్తారు. ఆ జంతువుల్లో కొంత భాగాన్ని ప్రజలు తింటారు కాని బోర మాత్రం మీ వంతు అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","నిప్పుమీద దహించబడిన బలిలో భాగంగా ప్రజలు వారు అర్పించే జంతువుల కొవ్వును తీసుకొని రావాలి. సమాధాన బలిలోని తొడను, నైవేద్యంలోని బోరనుకూడా వారు తీసుకుని రావాలి. అది యెహోవా ఎదుట అల్లాడించబడుతుంది. ఆ తర్వాత అది ఆ అర్పణలో మీ భాగం అవుతుంది. బలి అర్పణల్లోని ఆ భాగం యెహోవా ఆజ్ఞాపించినట్టు శాశ్వతంగా మీ వంతు అవుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","పాప పరిహారార్థబలి మేక కోసం మోషే చూశాడు. అయితే అప్పటికే అది దహించివేయబడింది. అహరోను కుమారుల్లో మిగిలిన వారి మీద (ఎలీయాజరు, ఈతామారు) మోషేకు చాలా కోపం వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","మోషే, “ఆ మేకను మీరు పరిశుద్ధ స్థలంలోనే తినాల్సిఉంది. అది చాలా పరిశుద్ధం. దాన్ని యెహోవా ఎదుట మీరెందుకు తినలేదు? ప్రజల దోషాన్ని తీసివేసేందుకు దాన్ని యెహోవా మీకు ఇచ్చాడు. ఆ మేక బలి ప్రజల పాపాలను తుడిచి వేసేందుకు ఉద్దేశించబడింది. ");
INSERT INTO tel2010_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","చూడండి, ఆ మేక రక్తాన్ని పవిత్ర స్థలం లోపలకు మీరు తీసుకొని రాలేదు. నేను ఆజ్ఞాపించిన ప్రకారం మీరు దాన్ని పరిశుద్ధ స్థలంలోనే తినాల్సి ఉంది”! అని అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","కాని, మోషేతో అహరోను చెప్పాడు: “చూడు, ఈవేళ వారు తమ పాపపరిహారార్థ బలిని, దహన బలి అర్పణను యెహోవా ఎదుటికి తెచ్చారు. అయితే ఈవేళ నాకు ఏమి జరిగిందో నీకు తెలుసు. పాపపరిహారార్థ బలిని ఈ వేళ నేను తింటే యెహోవా ఆనందిస్తాడని నీవు అనుకొంటావా? లేదు!” ");
INSERT INTO tel2010_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","మోషే ఇది విన్నప్పుడు ఒప్పుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","మోషే, అహరోనులతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పండి: మీరు తినదగిన జంతువులు ఏవంటే: ");
INSERT INTO tel2010_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ఏ జంతువు డెక్కలు చీలి ఉండి, నెమరు వేస్తుందో దాని మాంసం మీరు తినవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","6","“కొన్ని జంతువులు నెమరు వేస్తాయి గాని వాటి డెక్కలు చీలి ఉండవు. అలాంటి జంతువుల్ని తినవద్దు. ఒంటెలు, సిరాయారకపు పొట్టికుందేలు, కుందేలు అలాంటివే కనుక అవి మీకు అపవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","మరికొన్ని జంతువులకు డెక్కలు చీలి ఉంటాయి గాని అవి నెమరు వేయవు. అలాంటి జంతువుల్ని తినవద్దు. పందులు కూడా మీకు అపవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","ఆ జంతువుల (పందుల) మాంసం తినవద్దు. వాటి శవాలను కనీసం తాకవద్దు అవి మీకు అపవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“సముద్రంలోగాని, నదిలోగాని ఉండే జలచరాలకు రెక్కలు, పొలుసు ఉంటే, మీరు వాటిని తిన వచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","11","అయితే సముద్రంలోగాని నదిలో గాని ఉండే జలచరం దేనికైనా రెక్కలు, పొలుసు లేకపోతే, వాటని మీరు తినకూడదు. అలాంటిది అసహ్యమయినది. దాని మాంసం తినవద్దు. కనీసం దాని శవాన్ని కూడా తాకవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","సముద్రంలోనూ, నదిలోనూ ఉండే ఏ జలచరానికైనా రెక్కలు, పొలుసులు లేకపోతే అది అసహ్యమయిందిగానే మీరు ఎంచుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“అలానే మీరు తినకూడని పక్షులు ఇవి. ఈ పక్షుల్లో దేనినీ తినవద్దు: పక్షిరాజులు, రాబందులు, క్రౌంచ పక్షులు, ");
INSERT INTO tel2010_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","గద్ద, అన్నిరకాల గద్దలు, ");
INSERT INTO tel2010_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","అన్ని రకాల నల్ల పక్షులు, ");
INSERT INTO tel2010_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","నిప్పుకోళ్లు, కపిరిగాళ్లు, అన్ని రకాల డేగలు, ");
INSERT INTO tel2010_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","గుడ్లగూబలు, పగిడికంటెలు, పెద్దగుడ్ల గూబలు, ");
INSERT INTO tel2010_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","నీటి కాకులు, కొంగలు, నల్లబోరువలు, ");
INSERT INTO tel2010_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","గూడ బాతులు, సంకుబుడి కొంగలు, అన్నిరకాల కొంగలు, కుకుడుగువ్వలు, గబ్బిలాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“రెక్కలు ఉండి మొత్తం నాలుగు కాళ్లతో నడిచే జీవులన్నీ అసహ్యమైనవే. రెక్కలు ఉండి, నాలుగు కాళ్లతో నడిచే కీటకాలన్నీ అసహ్యమైనవే. ఆ కీటకాలను తినవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","అయితే కీటకాలకు రెక్కలు ఉండి నాలుగు కాళ్లతో నడిస్తే, వాటికి కనుక పాదాలకు పైగా కీళ్లు ఉండి అవి ఎగురగలిగినవైతే, అలాంటి కీటకాలను మీరు తినవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","ఏ కీటకాలను మీరు తినవచ్చునంటే: అన్ని రకాల మిడతలు, రెక్కలున్న అన్నిరకాల మిడతలు, అన్ని రకాల పెద్ద మిడతలు, అన్నిరకాల ఆకు మిడతలు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","“అయితే రెక్కలు, నాలుగు పాదాలు ఉన్న మిగిలిన కీటకాలు అన్నీ మీకు అసహ్యం. ");
INSERT INTO tel2010_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","ఆ కీటకాలు మిమ్మల్ని అపవిత్రపరుస్తాయి. ఈ కీటకాల శవాలను తాకిన ఏ వ్యక్తి అయినా సరే సాయంత్రంవరకు అపవిత్రం అవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ఒక వ్యక్తి చచ్చిన కీటకాల్లో ఒకదాన్ని గనుక పట్టుకొంటే ఆ వ్యక్తి తన బట్టలు ఉతుక్కోవాలి. ఈ వ్యక్తి సాయంత్రం వరకు అపవిత్రుడు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","27","“కొన్ని జంతువులకు డెక్కలు చీలి ఉంటాయిగాని డెక్కలు సమానంగా చీలి ఉండవు. కొన్ని జంతువులు నెమరు వేయవు. కొన్ని జంతువులకు డెక్కలు ఉండవు, అవి వాటి పాదాలమీద నడుస్తాయి. ఆ జంతువులన్నీ మీకు అపవిత్రం. వాటిని ఎవరైనా తాకితే వారు అపవిత్రం అవుతారు. ఆ వ్యక్తి సాయంత్రం వరకు అపవిత్రుడు ");
INSERT INTO tel2010_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","వాటి శవాలను ఎవరైనా ఎత్తితే, ఆ వ్యక్తి తన బట్టలు ఉతుక్కోవాలి. ఆ వ్యక్తి సాయంత్రంవరకు అపవిత్రుడవుతాడు. ఆ జంతువులు మీకు అపవిత్రము. ");
INSERT INTO tel2010_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ప్రాకే ఈ జంతువులు మీకు అపవిత్రం: ముంగిసలు, పందికొక్కులు అన్ని రకాల పెద్ద బల్లులు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","అడవి ఎలుకలు, మొసళ్లు, తొండలు, సరటాలు, ఊసరవెల్లులు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ప్రాకే ఈ జంతువులు మీకు అపవిత్రం. వాటిలో చచ్చిన వాటిని ఎవరైనా తాకితే అలాంటివారు సాయంత్రం వరకు అపవిత్రులవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","“అపవిత్రమైన ఆ జంతువుల్లో ఏదైనా చచ్చి దేనిమీదైనా పడితే, అది అపవిత్రం అవుతుంది. అది చెక్కతో, బట్టతో, తోలుతో చేయబడిన వస్తువులు కానీ, లేక ఏదైనా పనిముట్టుగానీ కావచ్చును. అది ఏదైనాసరే దాన్ని నీళ్లతో కడగాలి. సాయంత్రం వరకు అది అపవిత్రం. తర్వాత అది మరల పవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","“అపవిత్రమైన ఆ జంతువుల శవం ఏదైనా మట్టి పాత్రలో పడితే, ఆ ప్రాతలో ఉన్నది ఏదైనా సరే అది అపవిత్రం అవుతుంది. నీవు ఆ పాత్రను పగులగొట్టి తీరాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","అపవిత్రమైన మట్టి పాత్రలోని నీళ్లు ఏ ఆహారపదార్థం మీద పడినా, అందులోని ఆహారం అపవిత్రం అవుతుంది. అపవిత్రమైన పాత్రలోని పానీయం ఏదైనా అపవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","అపవిత్రమైచచ్చిన జంతువుయొక్క అవయవం ఒకటి దేనిమీద పడినా అది అపవిత్రం. అది మట్టి పొయ్యికావచ్చును, మట్టి కుంపటి కావచ్చును. దాన్ని ముక్కలుగా పగులగొట్టాలి. అవి ఇంకెంత మాత్రం పరిశుద్ధంగా ఉండవు. అవి మీకు ఎప్పటికీ అపవిత్రంగానే ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","“నీళ్లు ఊరుతూండే ఊటగాని, బావిగాని, పరిశుద్ధంగా ఉంటుంది. అయితే అపవిత్రమైన ఏ జంతువు శవాన్నీ, తాకిన ఏ వ్యక్తి అయినాసరే అపవిత్రుడు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","అపవిత్ర జంతువుల్లోని ఏ శవమైనా, నాట్లువేసే ఏ విత్తనంమీద పడినా, ఆ విత్తనం ఇంకా పరిశుద్ధంగానే ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","అయితే ఆ విత్తనాలమీద నీళ్లు పోసిన తర్వాత అపవిత్ర జంతువుయొక్క శవంలోని ఏ భాగమైనా ఆ విత్తనాలమీద పడితే, అప్పుడు మీకు ఆ విత్తనాలు అపవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“మీరు ఆహారానికి ఉపయోగించే జంతువు ఏదైనా చస్తే, దాని శవాన్ని తాకిన వ్యక్తి ఆ సాయంత్రం వరకు అపవిత్రుడవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","మరియు ఈ జంతు మాంసం తిన్న వ్యక్తి తన బట్టలు ఉతుక్కోవాలి. ఈ వ్యక్తి సాయంత్రం వరకు అపవిత్రుడవుతాడు. ఆ జంతు శవాన్ని ఎత్తే మనిషి తప్పక తన బట్టలు ఉతుక్కోవాలి. ఆ వ్యక్తి సాయంత్రం వరకు అపవిత్రుడవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“నేలమీద ప్రాకే ప్రతి జంతువు అసహ్యమయిందే. దాన్ని తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","పొట్టతో పాకే జంతువుల్లో దేనిని గాని లేక నాలుగు పాదాలతో నడిచే ఏ జంతువునుగాని లేక చాలా పాదాలుగల జంతువును గాని మీరు తినకూడదు. అవి మీకు అసహ్యమైనవి. ");
INSERT INTO tel2010_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","అసహ్యమైన ఆ జంతువుల మూలంగా మిమ్మల్ని మీరు హేయం చేసుకోవద్దు. వాటితో మిమ్మల్ని మీరు అపవిత్రం చేసుకోవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","ఎందుచేతనంటే నేను మీ దేవుడైన యెహోవాను గనుక. నేను పరిశుద్ధుడ్ని కనుక మీరు పరిశుద్ధంగా ఉండాలి. అసహ్యమైన ఆ పాకే జంతువుల మూలంగా మిమ్మల్ని మీరు అపవిత్రం చేసుకోవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","మిమ్మల్ని ఈజిప్టునుండి నేను తీసుకొచ్చాను. మీరు నాకు ప్రత్యేకమైన ప్రజలుగా ఉండేందుకు నేను ఇలా చేసాను. మీకు నేను దేవుడిగా ఉండాలని నేను ఇలా చేసాను. నేను పరిశుద్ధుడ్ని గనుక మీరు కూడా పరిశుద్ధంగా ఉండాలి!” ");
INSERT INTO tel2010_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","భూమిమీద ఉండే పశువులు, పక్షులు, ఇతర జంతువులు అన్నింటిని గూర్చిన నియమాలు అవి. సముద్రంలో ఉండే జలచరాలు, నేలమీద పాకే జంతువులు అన్నింటిని గూర్చిన నియమాలు అవి. ");
INSERT INTO tel2010_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","పవిత్ర జంతువులు ఏవో అపవిత్ర జంతువులు ఏవో ప్రజలు తేలుసుకోగలిగేందుకే ఆ ప్రబోధాలు. అందుచేత ఏ జంతువుల్ని తినవచ్చో, ఏ జంతువుల్ని తినకూడదో ప్రజలకు తెలుస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పు: “ఒక స్త్రీ మగ శిశువుకు జన్మనిస్తే ఆ స్త్రీ ఏడు రోజుల వరకు అపవిత్రగావుంటుంది. ఇది ఆమె నెలసరి రక్తస్రావం విషయంలో అపవిత్రంగా ఉన్నట్టే. ");
INSERT INTO tel2010_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","ఎనిమిదో రోజున ఆ మగ శిశువుకు సున్నతి చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","అప్పుడు ఆమె తన రక్తస్రావంనుండి పవిత్రం అయ్యేందుకు ముప్పయిమూడు రోజులు పడుతుంది. పరిశుద్ధమయింది దేన్నీ ఆమె తాకగూడదు. ఆమె పవిత్రపరచబడటం పూర్తి అయ్యేంతవరకు పరిశుద్ధ స్థలంలో ఆమె ప్రవేశించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","కానీ ఆ స్త్రీ ఒక ఆడ శిశువుకు జన్మయిస్తే నెలసరి రక్తస్రావ సమయంలో ఉన్నట్టే రెండు వారాలు ఆమె అపవిత్రంగా ఉంటుంది. ఆమె తన రక్తస్రావంనుండి పవిత్రం అయ్యేందుకు అరవై ఆరు రోజులు అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ప్రసవించిన తల్లి పవిత్రం అయ్యేందుకు ఒక ప్రత్యేక సమయం ఉంటుంది. పవిత్రపర్చబడే ఆ ప్రత్యేక సమయం అయిపోగానే ఆడపిల్ల తల్లియైనా, మగపిల్ల తల్లియైనా, ఆ తల్లి ప్రత్యేకమైన బలి అర్పణలను సన్నిధి గుడారానికి తీసుకొనిరావాలి. సన్నిధి గుడార ద్వారం దగ్గర ఆ బలి అర్పణలను ఒక యాజకునికి ఇవ్వాలి. దహన బలికోసం ఒక సంవత్సరం వయస్సుగల ఒక గొర్రెపిల్లను, పాపపరిహారార్థబలిగా ఒక పావురం పిల్లను లేక ఒక గువ్వను ఆమె తీసుకొనిరావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","8","ఒకవేళ ఆ స్త్రీ గొర్రెపిల్లను ఇవ్వలేక పోతే, రెండు పావురపు పిల్లల్నిగాని రెండుగువ్వలనుగాని ఆమె తీసుకొని రావచ్చును. అందులో ఒకటి దహనబలి కోసం, మరొకటి పాప పరిహారార్థ బలికోసం. వాటిని యాజకుడు యెహోవా ఎదుట అర్పిస్తాడు. ఈ విధంగా ఆమెకోసం అతడు ఆమె పాపాలను తుడిచి వేస్తాడు. అప్పుడు ఆమె తన రక్తస్రావంనుండి పవిత్రం అవుతుంది. ఒక మగశిశువుకు లేదా ఆడశిశువుకు జన్మనిచ్చే స్త్రీకి అవి నియమాలు.” ");
INSERT INTO tel2010_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","మోషే, అహరోనులకు యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ఒక వ్యక్తి చర్మం మీద వాపు ఉండవచ్చును, లేక అది పొక్కుగాని, నిగనిగలాడు మచ్చగాని కావచ్చును. ఆ మచ్చ కుష్ఠురోగంలా కనబడితే, యాజకుడగు అహరోను దగ్గరకు గాని, యాజకులైన అతని కుమారుల దగ్గరకుగాని ఆ వ్యక్తిని తీసుకొనిరావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ఆ వ్యక్తి చర్మంమీది మచ్చను యాజకుడు పరిశీలించాలి. ఆ మచ్చలోని వెంట్రుకలు తెల్లబడినా, ఆ మచ్చ అతని చర్మంకంటె లోతుకు ఉన్నా అది కుష్ఠురోగమే. యాజకుడు ఆ వ్యక్తిని పరిశీలించటం ముగించగానే ఆ వ్యక్తి కుష్ఠురోగి అని యాజకుడు ప్రకటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","“కొన్నిసార్లు ఒక వ్యక్తి చర్మంమీద ఒక తెల్లమచ్చ ఉంటుంది. కానీ ఆ మచ్చ చర్మంలోపలికి ఉండదు. అదే నిజమైతే ఆ వ్యక్తిని ఏడు రోజులపాటు ఇతరులనుండి యాజకుడు వేరు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ఏడో రోజున యాజకుడు ఆ వ్యక్తిని పరిశీలించాలి. ఆ మచ్చలో మార్పు లేకుండా, అది చర్మంమీద విస్తరించకుండా ఉన్నట్టు యాజకునికి కనబడితే, అప్పుడు ఆ వ్యక్తిని మరో ఏడు రోజులపాటు యాజకుడు ప్రత్యేకించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","ఏడు రోజుల తర్వాత మరల ఆ వ్యక్తిని యాజకుడు పరిశీలించాలి. ఆ మచ్చ మానిపోయి, చర్మంమీద విస్తరించకుండా ఉంటే, ఆ వ్యక్తి పరిశుద్ధుడు అని యాజకుడు ప్రకటించాలి. ఆ మచ్చ కేవలం పొక్కే. ఆ వ్యక్తి తన బట్టలు ఉతుక్కొని, మళ్లీ పవిత్రుడు కావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","“అయితే ఆ వ్యక్తి మరల శుద్ధి చేయబడేందుకు తనను తాను యాజకునికి కనబరచుకొన్న తర్వాత, ఆ పొక్కు చర్మంమీద మరలా విస్తరిస్తే, అప్పుడు ఆ వ్యక్తి మరల యాజకుని దగ్గరకు రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","యాజకుడు తప్పక పరిశీలించాలి. ఒకవేళ ఆ పొక్కు చర్మం మీద విస్తరిస్తే, ఆవ్యక్తి అపవిత్రుడని యాజకుడు తప్పక ప్రకటించాలి. అది కుష్ఠురోగం. ");
INSERT INTO tel2010_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ఒక వ్యక్తికి కుష్ఠురోగం ఉంటే అతణ్ణి యాజకుని దగ్గరకు తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","యాజకుడు తప్పక ఆ వ్యక్తిని పరిశీలించాలి. చర్మంలో తెల్లని వాపుఉండి, వెంట్రుకలు తెల్లబడి ఉండి, వాపులో చర్మంతెల్లగా కనబడితే ");
INSERT INTO tel2010_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","అప్పుడు అది ఆ వ్యక్తి చర్మంమీద చాలకాలంగా ఉన్న కుష్ఠురోగం. ఆ వ్యక్తి అపవిత్రుడు అని యాజకుడు తప్పక ప్రకటించాలి. కొద్దికాలం ఆ వ్యక్తిని మిగిలిన ప్రజలనుండి యాజకుడు ప్రత్యేకించాలి. ఎందుచేతనంటే ఆ వ్యక్తి అపవిత్రుడు అని అతనికి తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“కొన్నిసార్లు చర్మరోగం ఒక వ్యక్తి శరీరమంతటా వ్యాపిస్తుంది. ఆ వ్యక్తి తలనుండి పాదంవరకు చర్మంమీద అంతటా చర్మరోగం ఆవరిస్తుంది. యాజకుడు ఆ వ్యక్తి శరీరమంతా తప్పక చూడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","చర్మరోగం శరీరమంతా వ్యాపించినట్టు, అది ఆ వ్యక్తి చర్మాన్ని పూర్తిగా తెలుపు చేసినట్టు యాజకుడు చూస్తే, అప్పుడు ఆ వ్యక్తి పవిత్రుడు అని యాజకుడు ప్రకటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","అయితే ఆ వ్యక్తి చర్మం పచ్చిగా ఉంటే అతడు పవిత్రుడుకాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","యాజకుడు చర్మం పచ్చిగా ఉండటం చూసినప్పుడు, ఆ వ్యక్తి అపవిత్రుడని అతడు ప్రకటించాలి. పచ్చి చర్మం పవిత్రం కాదు. అది కుష్ఠురోగం. ");
INSERT INTO tel2010_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","“చర్మం మరల పచ్చిగా తయారై తెల్లగా మారితే, అప్పుడు ఆ వ్యక్తి తప్పక యాజకుని దగ్గరకు రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","యాజకుడు తప్పక ఆ వ్యక్తిని పరిశీలించాలి. ఆ పొడ తెల్లబారితే ఆ పొడగల ఆ వ్యక్తి పవిత్రుడని యాజకుడు ప్రకటించాలి. ఆ వ్యక్తి పవిత్రుడు. ");
INSERT INTO tel2010_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ఒకవేళ దేహపు చర్మంమీద మానిపోయినపుండు ఉండవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","కాని ఆ పుండు స్థానంలో తెల్లటి వాపుగాని, తెలుపు ఎరుపు కలిసి నిగనిగలాడే మచ్చగానీ ఉండవచ్చును. అప్పుడు దేహం మీది ఈ చోటును యాజకునికి చూపెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","యాజకుడు పరిశీలించాలి. వాపు చర్మంకంటె లోతుగా ఉండి, దాని మీది వెంట్రుకలు తెల్లబడి ఉంటే, అప్పుడు ఆ వ్యక్తి అపవిత్రుడు అని యాజకుడు ప్రకటించాలి. ఆ మచ్చ కుష్ఠురోగం పుండులోపలనుండి కుష్ఠురోగం బయటపడింది. ");
INSERT INTO tel2010_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","కానీ యాజకుడు ఆ మచ్చను చూడగా దానిమీద వెంట్రుకలు తెల్లబడక, ఆ మచ్చ చర్మంకంటె లోతుగా ఉండక మానుతున్నట్టు కనబడితే అప్పుడు యాజకుడు, ఆ వ్యక్తిని ఏడు రోజులపాటు ప్రత్యేకంగా ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ఒకవేళ ఆ మచ్చయింకా ఎక్కువగా చర్మంమీద విస్తరిస్తే, ఆ వ్యక్తి అపవిత్రుడని యాజకుడు ప్రకటించాలి. అది కుష్ఠుపొడ. ");
INSERT INTO tel2010_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","అయితే నిగనిగలాడే ఆ మచ్చ విస్తరించక, ఉన్నచోటనే ఉంటే, అది పాతపుండుకు సంబంధించిన దద్దురు మాత్రమే. ఆ వ్యక్తి పవిత్రుడు అని యాజకుడు తప్పక ప్రకటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","25","“ఒక వ్యక్తి చర్మంమీద కాలి వాత కావచ్చును. ఒకవేళ ఆ పచ్చి చర్మం తెల్లగా గాని, తెలుపు ఎరుపురంగు మచ్చలా కానీ మారితే యాజకుడు తప్పక దాన్ని పరిశీలించాలి. ఆ తెల్ల మచ్చ చర్మంకంటె లోతుగా ఉన్నట్టుగానీ, ఆ మచ్చ మీది వెంట్రుకలు తెల్లబడినా అది కుష్ఠురోగం. ఆ వాతలోనుంచి కుష్ఠురోగం బయటపడింది. అప్పుడు ఆ వ్యక్తి అపవిత్రుడు అని యాజకుడు ప్రకటించాలి. అది కుష్ఠురోగం. ");
INSERT INTO tel2010_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","కానీ యాజకుడు ఆ మచ్చను చూడగా నిగనిగలాడే మచ్చమీద వెంట్రుకలు లేకుండా ఆ మచ్చ చర్మంకంటె లోతుగా లేకుండ అది మానుతున్నట్టు ఉంటే ఆ వ్యక్తిని ఏడు రోజులపాటు యాజకుడు వేరుచేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ఏడవ రోజున యాజకుడు ఆ వ్యక్తిని మరల పరిశీలించాలి. ఆ మచ్చ చర్మంమీద విస్తరిస్తే, అప్పుడు ఆ వ్యక్తి అపవిత్రుడని యాజకుడు ప్రకటించాలి. అది కుష్ఠురోగం. ");
INSERT INTO tel2010_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","అయితే నిగనిగలాడే ఆ మచ్చ చర్మంమీద విస్తరించక మానుతుంటే, అది వాత మీది వాపు మాత్రమే. ఆ వ్యక్తి పవిత్రుడు అని యాజకుడు ప్రకటించాలి. అది కేవలం వాత మచ్చ మాత్రమే. ");
INSERT INTO tel2010_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ఒక వ్యక్తి తలమీదగాని గెడ్డంమీద గాని పొడరావచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ఒక యాజకుడు ఆ పొడను పరిశీలించాలి. ఆ పొడ చర్మంకంటె లోతుగా ఉన్నట్టు కనబడినా, దానిచుట్టూ వెంట్రుకలు పలుచగాను, పసుపుగాను ఉన్నా, ఆ వ్యక్తి అపవిత్రుడు అని యాజకుడు ప్రకటించాలి. అది చెడ్డ చర్మరోగం. ");
INSERT INTO tel2010_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ఒక వేళ ఆ పొడ చర్మంకంటె లోతుగా లేకపోయినా, దానిలో నల్ల వెంట్రుకలు లేకపోతే ఆ వ్యక్తిని ఏడురోజులపాటు యాజకుడు ప్రత్యేకించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ఏడవ రోజున ఆ పొడను యాజకుడు పరిశీలించాలి. ఆ పొడ విస్తరించకపోయినా, దానిలో పసుపు వెంట్రుకలు పెరగకపోయినా, ఆ పొడ చర్మంకంటె లోతుగా ఉన్నట్టు కనబడకపోయినా, ");
INSERT INTO tel2010_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ఆ వ్యక్తి క్షౌరం చేసుకోవాలి. కానీ అతడు ఆ పొడను కత్తిరించకూడదు. ఆ వ్యక్తిని యింకో ఏడు రోజుల వరకు యాజకుడు ప్రత్యేకించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ఏడవ రోజున యాజకుడు ఆ పొడను పరిశీలించాలి. ఆ పొడ చర్మంలోనికి విస్తరించక, అది చర్మంకంటె లోతుగా ఉన్నట్టు కనబడకపోయినా, ఆ వ్యక్తి పవిత్రుడు అని యాజకుడు ప్రకటించాలి. ఆ వ్యక్తి తన బట్టలు ఉతుకుకొని శుద్ధుడు కావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","కానీ ఆ వ్యక్తి పవిత్రుడయిన తర్వాత ఆ పొడ చర్మంమీద వ్యాపిస్తే, ");
INSERT INTO tel2010_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","యాజకుడు మరల ఆ వ్యక్తిని పరిశీలించాలి. ఆ పొడ చర్మంమీద వ్యాపిస్తే, పసుపు వెంట్రుకల కోసం యాజకుడు చూడక్కర్లేదు. ఆ వ్యక్తి అపవిత్రుడు. ");
INSERT INTO tel2010_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","అయితే ఆ వ్యాధి మానిపోయినట్టు యాజకుడు తలిస్తే, దానిలో నల్ల వెంట్రుకలు పెరుగుతుంటే ఆ రోగం మాని పోయింది. ఆ వ్యక్తి పవిత్రుడు. ఆ వ్యక్తి పవిత్రుడు అని యాజకుడు ప్రకటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ఒక వ్యక్తి చర్మంమీద తెల్ల మచ్చలు ఉంటే, ");
INSERT INTO tel2010_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ఒక యాజకుడు ఆ మచ్చలను పరిశీలించాలి. ఒకవేళ ఆ వ్యక్తి చర్మంమీది మచ్చలు వాడిపోయి తెలుపుగా ఉంటే అది హానికరము కాని పొక్కులు మాత్రమే. ఆ వ్యక్తి పవిత్రుడు. ");
INSERT INTO tel2010_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ఒక వ్యక్తి తలమీద వెంట్రుకలు ఊడి పోవచ్చును. అతడు పవిత్రుడు. అది కేవలం బట్టతల ");
INSERT INTO tel2010_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ఒకని తల ముందు భాగంలో వెంట్రుకలు రాలిపోవచ్చును. అతడు పవిత్రుడు. అది కేవలం మరో రకం బట్టతల. ");
INSERT INTO tel2010_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","కానీ అతని తలమీద ఎరుపు తెలుపు పొడ ఉంటే అది చర్మవ్యాధి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ఒక యాజకుడు ఆ వ్యక్తిని పరిశీలించాలి. ఆ పొడ వాపు ఎరుపు తెలుపుగా ఉండి, శరీరంలోని ఇతర భాగాల్లో కుష్ఠు రోగంలా కనబడితే, ");
INSERT INTO tel2010_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ఆ వ్యక్తి తలమీద కుష్ఠు రోగం ఉంది. ఆ వ్యక్తి అపవిత్రుడు అని యాజకుడు ప్రకటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ఒక వ్యక్తికి కుష్ఠు రోగం ఉంటే అతడు ఇతరులను హెచ్చరించాలి. అపవిత్రుణ్ణి అపవిత్రుణ్ణి అని కేకలు వేయాలి. అతడు తన బట్టలను చింపివేయాలి, తన తల వెంట్రుకలు విరబోసుకోవాలి, తన నోరు కప్పుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","ఆ వ్యాధి ఉన్న కాలమంతా అతను అపవిత్రుడే. ఆ వ్యక్తి అపవిత్రుడు. అతడు ఒంటరిగా బతకాలి. అతని నివాసం బసకు వెలుపల ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“కొన్ని బట్టల మీద కుష్ఠుపొడ ఉండవచ్చును. ఆ బట్ట నాణ్యమైనది లేక ఉన్నది కావచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","బట్ట అల్లినది కావచ్చు, కుట్టినది కావచ్చు, లేదా ఒక తోలు మీద కాని, తోలుతో చేయబడిన మరి దేనిమీద కాని ఆ కుష్ఠు పొడ ఉండవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ఆ కుష్ఠుపొడ పచ్చగా కానీ ఎర్రగా కానీ ఉంటే దాన్ని యాజకునికి చూపించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ఆ కుష్ఠుపొడను యాజకుడు పరిశీలించాలి. దానిని ఏడు రోజుల వరకు ఒక ప్రత్యేక స్థలంలో అతడు ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","52","ఏడవ రోజున ఆ కుష్ఠుపొడను యాజకుడు పరిశీలించాలి. ఆ కుష్ఠుపొడ తోలు మీద ఉన్నా బట్టమీద ఉన్నా ఒకటే. ఆ బట్ట కుట్టిందైనా అల్లినదైనా ఒకటే. ఆ తోలు ఉపయోగించబడింది దేని కొరకైనా ఒకటే. కుష్ఠుపొడ వ్యాపిస్తే అది నాశన కరమైనది. ఆ బట్ట లేక తోలు అపవిత్రం. ఆ పొడ అపవిత్రం. ఆ బట్ట లేక తోలును యాజకుడు కాల్చి వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ఆ కుష్ఠుపొడ వ్యాపించినట్టు యాజకునికి కనబడకపోతే, ఆ తోలును లేక ఆ బట్టను ఉతకాలి. అది తోలుగాని, బట్టగాని లేక బట్ట అల్లికగాని, కుట్టింది గాని, దాన్ని ఉతకాల్సిందే. ");
INSERT INTO tel2010_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ఆ బట్టను లేక తోలును ఉతకమని ఆ మనుష్యులకు యాజకుడు ఆజ్ఞాపించాలి. అప్పుడు యాజకుడు ఆ బట్టలను ఇంకా ఏడు రోజుల వరకు వేరుపరచాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ఆ సమయం తీరగానే యాజకుడు మళ్లీ పరిశీలించాలి. ఆ కుష్ఠుపొడ ఇంకా అలానే కనబడితే అది అపవిత్రం. ఆ పొడ వ్యాపించకపోయినా సరే ఆ బట్టను లేక ఆ తోలును మీరు కాల్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","“కానీ ఒక వేళ, ఆ తోలు ముక్కను లేక ఆ బట్టను యాజకుడు చూచినప్పుడు, కుష్ఠుపొడ వాడిపోయి ఉంటే, ఆ బట్ట మీద లేక తోలు మీద ఉన్న ఆ పొడను యాజకుడు చింపివేయాలి. ఆ బట్ట అల్లికది గాని, పడుగుది కానీ ఫర్వాలేదు. ");
INSERT INTO tel2010_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","లేదా ఆ బట్టమీద లేక ఆ తోలుమీద కుష్ఠుపొడ తిరిగి రావచ్చును. అలా జరిగతే ఆ కుష్ఠు పొడ వ్యాపిస్తుంది. ఆ చించిన బట్ట ముక్కను లేక తోలు ముక్కను కాల్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","అయితే ఉతకిన తర్వాత కుష్ఠుపొడ మళ్లీ రాకపోతే అప్పుడు ఆ బట్ట ముక్క లేక తోలు ముక్క పవిత్రం. ఆ బట్ట కుట్టిందిగానీ అల్లిందిగానీ ఏదైనా ఫర్వాలేదు. ఆ బట్ట పవిత్రం.” ");
INSERT INTO tel2010_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","తోలు ముక్కలు లేక బట్టముక్కల మీద కుష్ఠుపొడకు సంబంధించిన నియమాలు అవి. బట్ట కుట్టింది గాని అల్లిందిగాని ఫర్వాలేదు. ");
INSERT INTO tel2010_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","యెహోవా మోషేతో ఇలా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“చర్మరోగాలు కలిగి బాగుపడిన ప్రజలకు నియమాలు ఇవీ. “ఆ వ్యక్తిని పవిత్రం చేసేందుకే ఇవే నియమాలు. చర్మవ్యాధి వచ్చిన వ్యక్తిని ఒక యాజకుడు చూడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","బస వెలుపల ఆ వ్యక్తి దగ్గరకు యాజకుడు వెళ్లాలి. ఆ చర్మవ్యాధి బాగుపడినదేమో తెలుసుకొనేందుకు యాజకుడు పరిశీలించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ఆ వ్యక్తి ఆరోగ్యవంతంగా ఉంటే అతణ్ణి ఈ పనులు చేయమని యాజకుడు చెప్పాలి: ప్రాణంతో ఉన్న రెండు పవిత్ర పక్షుల్ని అతడు తీసుకొని రావాలి, ఒక దేవదారు చెక్క ముక్కను, ఎర్రటి గుడ్డ ముక్కను, ఒక హిస్సోపు ముక్కను కూడా అతడు తీసుకొని రావాలి. ఇవన్నీ ఆవ్యక్తిని శుద్ధిచేసే పనికోసమే. ");
INSERT INTO tel2010_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ఒక మట్టి పాత్రలో పారుతున్న నీళ్లమీద ఒక పక్షిని చంపమని యాజకుడు చెప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","అప్పుడుయింకా ప్రాణంతో ఉన్న రెండో పక్షిని, దేవదారు చెక్కముక్క, ఎర్ర గుడ్డ ముక్క, హిస్సోపు ముక్కను యాజకుడు తీసుకోవాలి. పారుతున్న నీళ్లమీద చంపబడిన మొదటి పక్షి రక్తంలో, ప్రాణంతో ఉన్న రెండో పక్షిని, మిగతా వస్తువులను యాజకుడు ముంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","చర్మవ్యాధి ఉన్న వ్యక్తి మీద యాజకుడు ఏడుసార్లు చిలకరించాలి. అప్పుడు ఆ వ్యక్తి పవిత్రుడు అని యాజకుడు ప్రకటించాలి. అప్పుడు యాజకుడు బహిరంగ స్థలానికి వెళ్లి, ప్రాణంతో ఉన్న పక్షిని స్వేచ్ఛగా ఎగిరిపోనివ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“తర్వాత ఆ వ్యక్తి తన బట్టలు ఉతుక్కోవాలి. అతడు తన వెంట్రుకలన్నింటినీ క్షౌరం చేసుకోవాలి. అతడు నీళ్లతో స్నానం చేయాలి. అప్పుడు అతడు పవిత్రం అవుతాడు. అప్పుడు ఆ వ్యక్తి బసలోనికి వెళ్లవచ్చును. కానీ అతడు ఏడు రోజులవరకు తన గుడారంబయట ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ఏడవ రోజున అతడు తన వెంట్రు కలన్నీ క్షౌరం చేసుకోవాలి. అతడు తన తల, గడ్డం, కనుబోమలు, వెంట్రుకలు అన్నీ క్షౌరం చేసుకోవాలి. తర్వాత అతడు తన బట్టలు ఉతుక్కొని, నీళ్లలో స్నానం చేయాలి. అప్పుడు అతడు పవిత్రుడవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ఎనిమిదో రోజున, చర్మవ్యాధి కలిగి ఉండినవాడు ఏ దోషం లేని రెండు మగ గొర్రెపిల్లలను తీసుకొని వెళ్లాలి. ఏ దేషం లోని ఒక్క సంవత్సరపు ఆడ గొర్రె పిల్లను కూడా అతడు తీసుకొని వెళ్లాలి. ధాన్యార్పణ కోసం నూనె కలిపిన మూడు పదోవంతుల మంచి పిండిని అతడు తీసుకొని వెళ్లాలి. ఒక అర్ధసేరు ఒలీవ నూనె ఆ వ్యక్తి తీసుకొని వెళ్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ఆ వ్యక్తి పవిత్రుడు అని ప్రకటించే యాజకుడు, ఆ వ్యక్తిని, అతని బలులను సన్నిధిగుడార ద్వారం దగ్గర యెహోవా ఎదుటికి తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","గొర్రె పిల్లల్లో ఒకదాన్ని అపరాధపరిహారార్థ బలిగా అర్పించాలి. ఆ గొర్రెపిల్లను, కొంతనూనెను యెహోవా ఎదుట నైవేద్యంగా అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","పాపపరిహారార్థ బలి, దహనబలి వధించే పవిత్ర స్థలంలోనే యాజకుడు మగ గొర్రెపిల్లను వధించాలి. అపరాధ పరిహారార్థ బలి పాపపరిహారార్థ బలిలాగే ఉంటుంది. అది యాజకునికే చెందుతుంది. అది చాలా పవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","“అపరాధ పరిహారార్థ బలినుండి కొంత రక్తాన్ని యాజకుడు తీసుకోవాలి. పవిత్ర పర్చబడాల్సిన వ్యక్తికుడి చెవి కొన మీద ఈ రక్తంలో కొంచెం యాజకుడు వేయాలి. ఆ వ్యక్తి కుడి చేతి బొటన వేలిమీద, కుడి పాదపు బొటనవేలిమీద ఈ రక్తంలో కొంచెం యాజకుడు వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","యాజకుడు కొంచెం నూనె తీసుకొని తన ఎడమ అర చేతిలో పోసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","అప్పుడు యాజకుడు తన ఎడమ చేతిలో ఉన్న నూనెలో తన కుడి చేత వేలిని ముంచాలి. ఆ నూనెలో కొంచెం యెహోవా ఎదుట ఏడుసార్లు చిలకరించేందుకు ఆవేలిని అతడు ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","పవిత్ర పర్చబడాల్సిన ఆ వ్యక్తి కుడి చెవి కొనమీద యాజకుడు తన అరచేతిలోని నూనె కొంచెం పోయాలి. ఆ వ్యక్తి కుడి చేతి బొటన వేలిమీద కుడి పాదం బొటనవేలి మీద యాజకుడు ఆ నూనెలో కొంచెం పోయాలి. అపరాధ పరిహారార్థ బలి అర్పణపు రక్తం మీద యాజకుడు ఆ నూనెలో కొంచెం పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","యాజకుడు తన అరచేతిలో మిగిలిన నూనెను పవిత్రపర్చబడాల్సిన వ్యక్తి తలమీద పోయాలి. ఈ విధంగా యెహోవా ఎదుట ఆ వ్యక్తి పాపాలను యాజకుడు తుడిచి వేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“తర్వాత ఆ వ్యక్తి పవిత్రుడయ్యేటట్టు యాజకుడు పాపపరిహారార్థ బలిని అర్పించి, ఆ వ్యక్తి పాపాలను తుడిచివేయాలి. ఆ తర్వాత దహనబలి పశువును యాజకుడు వధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","అప్పుడు యాజకుడు దహనబలి అర్పణను, ధాన్యార్పణను బలిపీఠం మీద అర్పించాలి. ఈ విధంగా ఆ వ్యక్తి పాపాలను యాజకుడు తుడిచివేయాలి. ఆ వ్యక్తి పవిత్రుడవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“అయితే ఆ వ్యక్తి పేదవాడై అలాంటి అర్పణలు ఇవ్వలేకపోతే, అపరాధ పరిహారార్థబలిగా ఒక మగ గొర్రెపిల్లను అతడు తీసుకొని రావాలి. యాజకుడు ఆ వ్యక్తి పాపాలను తుడిచివేసేందుకు అది నైవేద్యం. ధాన్యార్పణగా తూములో పదోవంతు నూనెతో కలిసిన గోధుమ పిండిని ఒక అర్థసేరు నూనెను ");
INSERT INTO tel2010_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","రెండు గువ్వలను, రెండు పావురపు పిల్లలను అతడు తీసుకొనిరావాలి. పేదవాళ్లుకూడ వాటిని తీసుకొని రాగలుగుతారు. ఒక పక్షి పాపపరిహారార్థబలి కొరకు, మరొకటి దహనబలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“ఎనిమిదో రోజున సన్నిధి గుడారం దగ్గర యాజకుని వద్దకు అతడు వాటిని తీసుకొని రావాలి. ఆ వ్యక్తి పవిత్రుడయ్యేందుకు వాటిని యెహోవా ఎదుట అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","అపరాధ పరిహారార్థ బలికోసం గొర్రెపిల్లను, నూనెను, యాజకుడు తీసుకొని యెహోవా ఎదుట నైవేద్యంగా వాటిని అల్లాడించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","అప్పుడు అపరాధ పరిహారార్థ బలికొరకైన గొర్రెపిల్లను యాజకుడు వధించాలి. అపరాధ పరిహారార్థ బలి రక్తంలో కొంచెం యాజకుడు తీసుకోవాలి. పవిత్రం చేయబడాల్సిన వ్యక్తి కుడి చెవి కొనమీద ఈ రక్తంలో కొంచెం యాజకుడు పోయాలి. ఈ వ్యక్తి కుడి చేతి బొటనవేలిమీద, కుడి పాదం బొటనవేలిమీద యాజకుడు ఈ రక్తం కొంచెం పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ఈ నూనెలో కూడ కొంచెం అతని ఎడమ చేతిలో యాజకుడు పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","యాజకుడు తన కుడిచేతి వేలిని ప్రయోగించి తన ఎడమ చేతిలోని నూనె కొంచెం తీసి యెహోవా ఎదుట ఏడుసార్లు చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","తర్వాత యాజకుడు తన చేతిలోని నూనె కొంచెం తీసి పవిత్రం కావాల్సిన వ్యక్తి కుడి చెవి కొనమీద వేయాలి. ఆ వ్యక్తి కుడి చేతి బొటన వేలి మీద, కుడి పాదం బొటన వేలిమీద యాజకుడు ఈ నూనెను కొంచెం వేయాలి. అపరాధ పరిహారార్థబలి రక్త స్థానంలో యాజకుడు ఈ నూనె కొంచెం వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","యాజకుడు తన చేతిలో మిగిలిపోయిన నూనెను, పవిత్రం కావాల్సిన వాని తల మీద పోయాలి. ఈ విధంగా యెహోవా ఎదుట ఆ వ్యక్తి పాపాలను యాజకుడు తుడిచివేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","“అప్పుడు ఆ వ్యక్తి ఒక గువ్వ లేక పావురపు పిల్లలలో ఒకదానిని అర్పించాలి. (పేదవారు కూడా ఆ పక్షులను ఇవ్వగలరు, ఆ వ్యక్తి ఇవ్వగలిగిందే ఇవ్వాలి). ");
INSERT INTO tel2010_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ఒక పక్షిని పాప పరిహారార్థబలిగాను మరొక దాన్ని దహనబలిగాను ఆ వ్యక్తి అర్పించాలి. అతడు వాటిని ధాన్యార్పణతో బాటు అర్పించాలి. “ఈ విధంగా యాజకుడు ఆ వ్యక్తి పాపాలను యెహోవా ఎదుట తుడిచి వేస్తాడు. మరియు ఆ వ్యక్తి పవిత్రం అవుతాడు.” ");
INSERT INTO tel2010_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ఒక వ్యక్తి చర్మ వ్యాధినుండి బాగు పడిన తర్వాత అతణ్ణి పవిత్రం చేయటానికి అవీ నియమాలు. “పవిత్రం అయ్యేందుకు నియమం ప్రకారం బలులు అర్పించలేని ప్రజలకు అవీ నియమాలు.” ");
INSERT INTO tel2010_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","మోషే, అహరోనులతో యెహోవా ఇంకా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“కనాను దేశాన్ని నేను నీ ప్రజలకు ఇస్తున్నాను. నీ ప్రజలు ఆ దేశం చేరుతారు. ఆ సమయంలో ఎవరి యింట్లోనైనా నేను కుష్ఠుపొడను పెరగనీయవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","ఆ యింటి స్వంతదారుడు యాజకుని దగ్గరకు వచ్చి, ‘కుష్ఠుపొడలాంటిది ఏదో నాయింట్లో కనిపిస్తుంది’, అనిచెప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","“అప్పుడు యాజకుడు ఆ ఇంటి వారిని ఇల్లు ఖాళీచేయమని ఆజ్ఞాపించాలి.” యాజకుడు కుష్ఠుపొడను చూడటానికి వెళ్లక ముందే వారు ఇల్లు ఖాళీచేయాలి. ఈ విధంగా ఆ ఇంట్లోని అపవిత్రమైన వాటన్నింటినీ యాజకుడు కాపాడవలసిన పనిలేదు. ఆ మనుష్యులు ఇల్లు ఖాళీచేసిన తర్వాత, ఆ ఇంటిని చూడటానికి యాజకుడు లోనికి వెళ్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","యాజకుడు కుష్ఠుపొడను పరిశీలించాలి. ఆ ఇంటి గోడలమీద పొడకు పచ్చటి లేక ఎర్రటి రంధ్రాలు ఉండి, ఆ పొడ గోడల ఉపరితలంలో చొచ్చుకు పోతున్నట్లు కనబడితే, ");
INSERT INTO tel2010_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","యాజకుడు ఆ ఇంటినుండి బయటకు వెళ్లిపోయి ఏడు రోజులవరకు ఆ ఇంటికి తాళంవేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","“ఏడో రోజున యాజకుడు తిరిగి వచ్చి ఆ ఇంటిని పరిశీలించాలి.” ఆ పొడ ఇంటి గోడలమీద వ్యాపించి ఉంటే, ");
INSERT INTO tel2010_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","పొడ ఉన్న రాళ్లను లాగి పారవేయమని యాజకుడు ఆ ప్రజలకు ఆజ్ఞాపించాలి. పట్టణం బయట ప్రత్యేకమైన ఒక అపవిత్ర స్థలంలో వారు ఆ రాళ్లను వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","అప్పుడు యాజకుడు ఆ ఇంటిలోపల అంతా గీకించాలి. అలా గీకిన పెచ్చులను వారు పారవేయాలి. పట్టణం బయట ప్రత్యేకమైన ఒక అపవిత్ర స్థలంలో ఆ పెచ్చులను వారు వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","అప్పుడు ఆ వ్యక్తి ఆ ఇంటికి కొత్త రాళ్లు పెట్టాలి. అతడు ఆ రాళ్లకు కొత్త అడుసు పూయించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ఒకవేళ ఒకడు పాతరాళ్లను, పాత పెచ్చులను తీసివేసి, కొత్తరాళ్లు, కొత్త అడుసు పెట్టి ఉండొచ్చు. ఒకవేళ ఆ ఇంటిలో మరల పొడ కనబడవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","అప్పుడు యాజకుడు లోనికి వచ్చి ఇంటిని పరిశీలించాలి. ఆ పొడ ఇంటిలో వ్యాపించి ఉంటే, అది త్వరగా యితర స్థలాలకు గూడా వ్యాపించే వ్యాధి. అందుచేత ఆ యిల్లు అపవిత్రము. ");
INSERT INTO tel2010_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","ఆ వ్యక్తి ఆ ఇంటిని కూలగొట్టాలి. ఆ రాళ్లను, పెచ్చులను, చెక్కముక్కలను పట్టణం వెలుపల అపవిత్రమైన ప్రత్యేక స్థలానికి తీసుకొని పోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","ఆ ఇంట్లోకి వెళ్లే ఏ వ్యక్తి అయినాసరే సాయంత్రం వరకు అపవిత్రమవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ఎవరైనా ఆ ఇంటిలో భోజనంచేసినా, పండుకొన్నా ఆ వ్యక్తి తన బట్టలు ఉతుక్కోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ఆ ఇంట్లో కొత్త అడుసుతో కొత్త రాళ్లు వేసిన తర్వాత యాజకుడు ఆ ఇంటిని పరిశీలించాలి. ఒకవేళ ఆ పొడ ఇంటిలో వ్యాపించకపోతే ఆ ఇల్లు పవిత్రం అని యాజకుడు ప్రకటించాలి. ఎందుచేతనంటే ఆ పొడ పోయింది గనుక! ");
INSERT INTO tel2010_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","“అప్పుడు ఆ ఇంటిని పవిత్రం చేయటానికి యాజకుడు రెండు పక్షులను, దేవదారు చెక్క ముక్కను, ఒక ఎర్ర గుడ్డ ముక్కను, ఒక హిస్సోపు రెమ్మను తీసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","పారుతున్న నీళ్లలో ఒక మట్టి పాత్రలో యాజకుడు ఒక పక్షిని వధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","తరువాత యాజకుడు దేవదారు చెక్క ముక్కను, హిస్సోపును, ఎర్రగుడ్డ ముక్కను, ప్రాణంతో ఉన్న పక్షిని తీసుకోవాలి. పారుతున్న నీళ్లలో వధించబడిన పక్షి రక్తంలో యాజకుడు వీటన్నింటినీ ముంచాలి. అప్పుడు యాజకుడు ఆ రక్తన్ని ఇంటిమీద ఏడు సార్లు చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","ఈ విధంగా యాజకుడు ఆ యింటిని పవిత్రం చేయటానికి వీటిని ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","యాజకుడు పట్టణం వెలుపలి బయలు ప్రదేశానికి వెళ్లి, బతికి ఉన్న పక్షిని అక్కడ స్వేచ్ఛగా విడిచిపెట్టాలి. ఈ విధంగా యాజకుడు ఆ యింటిని పవిత్రం చేయాలి. ఆ ఇల్లు పవిత్రం అవుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ఏ విధమైన కుష్ఠువ్యాధికి, ");
INSERT INTO tel2010_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","బట్టమీద లేక ఇంటి మీద కుష్ఠు పొడకు సంబంధించిన నియమాలు అవి. ");
INSERT INTO tel2010_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","చర్మంమీద వాపులు, దద్దురులు, నిగనిగలాడే మచ్చలకు అవి నియమాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","వస్తువులు పవిత్రంగా ఉన్నది లేనిదీ ఆ నియమాలు నేర్పిస్తాయి. అలాంటి వ్యాధులకు సంబంధించిన నియమాలు అవి. ");
INSERT INTO tel2010_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","మోషే, అహరోనులతో యెహోవా యింకా యిలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“ఇశ్రాయేలు ప్రజలకు మీరిలా చెప్పండి: ఎవని దేహంలోనైనా స్రావం ఉంటేవాడు అపవిత్రుడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","వాని శరీరంలోనుండి స్రావం కారుతున్నా లేక నిలిచిపోయినా సరే ఫర్వాలేదు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“స్రావం ఉన్న వ్యక్తి పరుపుమీద పండుకొంటే, ఆ పరుపు అపవిత్రం. ఆ వ్యక్తి కూర్చొనేవన్నీ అపవిత్రం అవుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ఒకవేళ ఏ వ్యక్తి అయినా ఈ వ్యక్తి పరుపును తాకితే అతడు తన బట్టలు ఉతుక్కొని, నీళ్లతో స్నానంచేయాలి. సాయంత్రంవరకు అతడు అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ఇంకా స్రావంగల వాడు కూర్చున్న దేనిమీ దనైనా సరే కూర్చున్న ఏ వ్యక్తిగాని తన బట్టలు ఉతుక్కోవాలి, నీళ్లతో స్నానం చేయాలి. సాయంత్రంవరకు అతడు అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","అలానే స్రావంఉన్న వ్యక్తిని తాకిన ఏ వ్యక్తిగాని తన బట్టలు ఉతుక్కొని, నీళ్లతో స్నానం చేయాలి. సాయంత్రం వరకు అతడు అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","స్రావంగల వాడు ఒక పవిత్రునిమీద ఉమ్మివేస్తే, ఈ పవిత్రుడు తన బట్టలు ఉతుక్కొని, నీళ్లతో స్నానం చేయాలి. ఈ వ్యక్తి సాయంత్రంవరకు అపవిత్రుడుగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","స్రావంగల వ్యక్తి కూర్చొని స్వారీ చేసిన ప్రతి ఆసనం అపవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","కనుక స్రావంగలవాని కింద ఉన్న దేనినైనా తాకిన ప్రతి ఒక్కరూ సాయంత్రంవరకు అపవిత్రంగా వుంటారు. స్రావంగల వాని కింద ఉండే వస్తువులను మోసిన వ్యక్తి తన బట్టలు ఉదుకుకొని, నీళ్లతో స్నానం చేయాలి. సాయంత్రంవరకు అతడు అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","ఒకవేళ స్రావంగల వ్యక్తి నీళ్లతో తన చేతులు కడుగుకోకుండా మరొక వ్యక్తిని తాకవచ్చును. అప్పుడు అవతల వ్యక్తి తన బట్టలు ఉతుక్కొని స్నానం చేయాలి. సాయంత్రంవరకు అతడు అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“అయితే స్రావంగల వ్యక్తి ఒక మట్టి పాత్రను తాకితే ఆ పాత్రను పగులగొట్టివేయాలి. స్రావంగల ఈ వ్యక్తి గనుక ఒక చెక్క పాత్రను తాకితే, ఆ పాత్రను నీళ్లతో కడగాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“స్రావంగల వాడు తన స్రావం నుండి పవిత్రునిగా చేయబడితే అతడు తన శుద్ధికోసం తానే ఏడు రోజులు లెక్కబెట్టుకోవాలి. అప్పుడు అతడు పారుతున్న నీటిలో తన బట్టలు ఉతుక్కొని, స్నానం చేయాలి. అతడు పవిత్రుడు అవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","ఎనిమిదో రోజున రెండు గువ్వలను గాని రెండు పావురపు పిల్లలనుగాని ఆ వ్యక్తి తనకోసం తీసుకొని వెళ్లాలి. సన్నిధి గుడారద్వారం దగ్గర యెహోవా ఎదుటికి అతడు రావాలి. ఆ వ్యక్తి రెండు పక్షులను యాజకునికి యివ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ఒక పక్షిని పాప పరిహారార్థ బలిగాను, మరో పక్షిని దహనబలిగాను యాజకుడు అర్పించాలి. కనుక యాజకుడు ఆ వ్యక్తిని యెహోవాకు పవిత్రునిగా చేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ఒకనికి వీర్యస్ఖలనం అవుతోంటే అతడు నీళ్లలో పూర్తిగా స్నానం చేయాలి. సాయంత్రంవరకు అతడు అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ఒకవేళ ఏ బట్టమీద గాని తోలుమీదగాని వీర్యం పడితే, ఆ బట్టను లేక తోలును నీళ్లలో కడగాలి. సాయంత్రంవరకు అది అపవిత్రంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ఒకవేళ ఒక పురుషుడు ఒక స్త్రీతో శయనించగా వీర్యస్ఖలనమైనప్పుడు ఆ స్త్రీ పురుషులు ఇద్దరూ నీళ్లతో స్నానం చేయాలి. సాయంత్రం వరకు వారు అపవిత్రంగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ఒక స్త్రీకి తన నెలసరి రక్తస్రావంనుండి స్రావంతో ఉంటే, ఆమె ఏడు రోజులు అపవిత్రంగా ఉంటుంది. ఎవరైనా ఆమెను తాకితే వారు ఆ రోజు సాయంత్రంవరకు అపవిత్రంగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","మరియు ఆ స్త్రీ తన నెలసరి రక్తస్రావ సమయంలో పండు కొనేవన్నీ అపవిత్రం అవుతాయి. ఆ సమయంలో ఆమె కూర్చొనేవన్నీ అపవిత్రం అవుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ఎవరైనా ఆ స్త్రీ పడకను తాకినట్టుయితే ఆ వ్యక్తి తన బట్టలు ఉతుక్కొని, నీళ్లలో స్నానం చేయాలి. సాయంత్రం వరకు ఆ వ్యక్తి అపవిత్రుడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ఒకవేళ ఎవరైనా ఆమె కూర్చున్న దేనినైనా తాకితే. ఆ వ్యక్తి తన బట్టలు ఉతుక్కొని, నీళ్లలో స్నానం చేయాలి. సాయంత్రం వరకు ఆ వ్యక్తి అపవిత్రం. ");
INSERT INTO tel2010_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ఒకవ్యక్తి ఆమె పడకను తాకినా, లేక ఆమె కూర్చున్న దేనినైనా తాకినా, ఆ వ్యక్తి ఆ సాయంత్రం వరకు అపవిత్రుడవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“మరియు ఒక స్త్రీ నెలసరి రక్తస్రావ సమయంలో ఒక పురుషుడు ఆమెతో లైంగిక పొందు అనుభవిస్తే, ఆ పురుషుడు ఏడురోజులపాటు అపవిత్రంగా ఉంటాడు. ఆ పురుషుడు పండుకొనే ప్రతి పడకా అపవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ఒక స్త్రీకి నెలసరి రక్తస్రావ సమయంలో గాక, ఆ తర్వాత ఆమెకు రక్తం చాల రోజుల వరకు స్రవిస్తే, అలా రక్తం స్రవించినన్నాళ్లూ, నెలసరి రక్తస్రావంలో వలెనే ఆమె అపవిత్రంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","రక్త స్రావ సమయమంతటిలో ఆ స్త్రీ ఏ పడకమీద పరుండినా సరే, ఆమె నెలసరి రక్తస్రావ సమయంలో వలెనే ఉంటుంది ఆ పడక. ఆమె కూర్చొనేది ఏదైనా సరే, ఆమె నెలసరి రక్తస్రావ సమయంలో అపవిత్రమైనట్టే అపవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ఆ వస్తువులను ఏ వ్యక్తి తాకితే ఆ వ్యక్తి అపవిత్రం అవుతాడు. ఆ వ్యక్తి తన బట్టలు ఉతుక్కొని, నీళ్లతో స్నానం చేయాలి. సాయంత్రంవరకు అతడు అపవిత్రుడవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","ఆ తర్వాత ఆ స్త్రీ తన స్రావంనుండి పవిత్రం అయిన తర్వాత, ఆమె ఏడు రోజులు లెక్క పెట్టాలి. ఆ తర్వాత ఆమె పవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","అప్పుడు ఎనిమిదో రోజున ఆమె రెండు గువ్వలను లేదా రెండు పావురపు పిల్లలను తీసుకొని రావాలి. సన్నిధి గుడార ద్వారం వద్ద యాజకుని దగ్గరకు ఆమె వాటిని తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","అప్పుడు ఒక పక్షిని పాపపరిహారార్థబలిగాను మరో పక్షిని దహనబలిగాను యాజకుడు అర్పించాలి. అలా యాజకుడు యెహోవా ఎదుట ఆమెను పవిత్రం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“అందుచేత ఇశ్రాయేలు ప్రజలు తమ అపవిత్రత విషయంలో వారి అపవిత్రతనుండి ప్రత్యేకించుకోవాల్సిందిగా మీరు హెచ్చరించాలి. మీరు ప్రజలను హెచ్చరించకపోతే, అప్పుడు వారు నా పవిత్ర గుడారాన్ని అపవిత్రం చేస్తారు. అప్పుడు వాళ్లు చావాల్సిఉంటుంది!” ");
INSERT INTO tel2010_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","స్రావంగల వారి విషయంలో అవి నియమాలు. వీర్యస్ఖలనం వలన అపవిత్రులైన పురుషులను గూర్చిన నియమాలు అవి. ");
INSERT INTO tel2010_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","మరియు నెలసరి రక్తస్రావం మూలంగా అపవిత్రమైన స్త్రీలకు అవి నియమాలు. అపవిత్రమైన స్త్రీతో శయనించి అపవిత్రమైన ఏ వ్యక్తికైనా అవి నియమాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","యెహోవాకు ధూపం వేస్తూ అహరోను ఇద్దరు కుమారులూ చనిపోయారు. అది జరిగిన తర్వాత మోషేతో యెహోవా మాట్లాడాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","మోషేతో యెహోవా ఇలా అన్నాడు: “నీ సోదరుడైన అహరోనుతో మాట్లాడు.” పవిత్ర స్థలంలో తెర వెనుకకు అతడు వెళ్లజాలని కొన్ని ప్రత్యేక సమయాలు ఉన్నాయని అతనితో చెప్పు. ఆ తెర వెనుక గదిలో ఒడంబడిక పెట్టె ఉన్నది. ఆ పవిత్ర పెట్టెమీద కరుణాపీఠం ఉంది. ఆ పెట్టెకు పైగా మేఘంలో నేను ప్రత్యక్ష మవుతాను. అందుచేత యాజకుడు ఎల్లప్పుడూ ఆ గదిలోనికి వెళ్లజాలడు. అతడు ఆ గదిలోనికి వెళ్తే, అతడు మరణించవచ్చు! ");
INSERT INTO tel2010_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“ప్రాయశ్చిత్తపు రోజున అహరోను పరిశుద్ధ స్థలంలో ప్రవేశించక ముందు, పాపపరిహారార్థ బలిగా ఒక కోడెదూడను, దహన బలిగా ఒక పొట్టేలును అతడు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","అహరోను నీళ్లతో పూర్తిగా స్నానంచేయాలి. అప్పుడు అహరోను ఈ బట్టలు ధరించాలి. అహరోను పవిత్రమైన చొక్కోధరించాలి. లోపల వేసు కొనే బట్టలు శరీరాన్ని అంటిపెట్టుకొనేవిగా ఉండాలి. మేలురకం దట్టిని నడుంకు కట్టుకోవాలి. మేలురకం బట్టతో తలపాగా చుట్టుకోవాలి. ఇవి పవిత్ర వస్త్రాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","“మరియు పాపపరిహారార్థ బలికోసం రెండు మగ మేకలను, దహనబలికోసం ఒక పొట్టేలును ఇశ్రాయేలు ప్రజల దగ్గర నుండి అహరోను తీసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","అప్పుడు అహరోను పాపపరిహారార్థ బలిగా ఒక కోడెదూడను అర్పించాలి. ఈ పాపపరిహారార్థ బలి తనకోసమే. అప్పుడు అతనిని, అతని కుటుంబాన్ని పవిత్రంచేసే ఆచారాన్ని అహరోను జరిగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","“తర్వాత, అహరోను ఆ రెండు మేకలను సన్నిధి గుడార ద్వారం దగ్గరకు తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","ఆ రెండు మేకలకు అహరోను చీట్లు వేయాలి. ఒకచీటి యెహోవాకు, ఇంకొకటి విడిచిపెట్టే అజాజేలుకు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","“అప్పుడు అహరోను చీటి ద్వారా నిర్ణయించబడిన మేకను యెహోవాకు అర్పించాలి. ఈ మేకను అహరోను పాపపరిహారార్థ బలిగా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","అయితే విడిచి పెట్టేందుకు చీటి ద్వారా నిర్ణయించబడిన మేకను ప్రాణంతోనే యెహోవా ఎదుటికి తీసుకొని రావాలి. దాన్ని పవిత్రం చేసే క్రమాన్ని యాజకుడు జరిగించాలి. తర్వాత ఈ మేక అర్యణంలో విడిచిపెట్టబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“తర్వాత అహరోను తన కోసం ఒక కోడెదూడను పాపపరిహారార్థ బలిగా అర్పించాలి. తనను, తన కుటుంబాన్ని అహరోను పవిత్రం చేసుకోవాలి. అహరోను అతని కోసమే పాపపరిహారార్థ బలిగా ఆ కోడెదూడను వధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","అప్పుడు యెహోవా సన్నిధిలోని ధూపపీఠంనుండి ధూపార్తి నిండా నిప్పులు తీసుకోవాలి. చూర్ణం చేయబడిన పరిమళ ధూపాన్ని రెండు గుప్పెళ్ల నిండా అహరోను తీసుకోవాలి. తెర వెనుక నున్న గదిలోనికి అహరోను ఆ పరిమళ ధూపాన్ని తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","యెహోవా సన్నిధిలో అహరోను ఆ ధూపాన్ని నిప్పులు మీద వేయాలి. అప్పుడు ఒడంబడిక పెట్టె మీద ఉన్న కరుణా పీఠాన్ని ఆ ధూపపొగ ఆవరిస్తుంది. ఈ విధంగా చేస్తే అహరోను మరణించడు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","అహరోను ఆ కోడెదూడ రక్తంలో కొంచెం తీసుకొని, తన వేలితో తూర్పుకు కరుణాపీఠం మీదికి చిలకరించాలి. కరుణాపీఠం ముందర అతడు తన వేలితో ఏడుసార్లు రక్తాన్ని చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“తర్వాత అహరోను ప్రజలకోసం పాప పరిహారార్థ బలి మేకను వధించాలి. తెరవెనుక ఉన్న గదిలోనికి ఈ మేక రక్తాన్ని అహరోను తీసుకొని రావాలి. కోడెదూడ రక్తంతో ఏమైతేచేసాడో అలాగే మేక రక్తంతోకూడ అహరోను చేయాలి. కరుణాపీఠం మీద, కరుణాపీఠం ఎదుట ఆ మేక రక్తాన్ని అహరోను చిలకరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ఇశ్రాయేలు ప్రజలు అపవిత్రమయిన సందర్భాలెన్నో ఉన్నాయి కనుక ఇశ్రాయేలు ప్రజల పాపాలు, నేరాలనుండి ఆ అతిపరిశుద్ధ స్థలాన్ని పవిత్రం చేసేందుకు జరగాల్సిన ప్రాయశ్చిత్తాన్ని అహరోను చేయాలి. అహరోను ఎందుకు ఇవన్నీ చేయాలి? సన్నిధిగుడారం అపవిత్ర ప్రజల మధ్య ఉంటుందిగనుక. ");
INSERT INTO tel2010_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","“అతి పరిశుద్ధ స్థలాన్ని అహరోను పవిత్రం చేసే సమయంలో సన్నిధిగుడారంలో ఎవ్వరూ ఉండకూడదు. అహరోను బయటకు వచ్చేంతవరకు ఏ వ్యక్తీ లోకిని వెళ్లకూడదు. కనుక అహరోను తనను, తన కుటుంబాన్ని పవిత్రం చేసుకోవాలి. తర్వాత ఇశ్రాయేలు ప్రజలందరినీ అతడు పవిత్రం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","తర్వాత యెహోవా సన్నిధిలో ఉన్న బలిపీఠం దగ్గరకు అహరోను వెళ్లాలి. అహరోను బలిపీఠాన్ని పవిత్రం చేస్తాడు. కోడెదూడ రక్తంలో కొంచెం, మేక రక్తంలో కొంచెం తీసుకొని బలిపీఠం అన్ని వైపులా ఉన్న దాని కొమ్ములకు అహరోను పూయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","తర్వాత అహరోను తన వేలితో కొంత రక్తాన్ని బలి పీఠం మీద ఏడుసార్లు చిలకరించాలి. ఈ విధంగా ఇశ్రాయేలు ప్రజల పాపాలన్నింటి నుండి బలిపీఠాన్ని అహరోను పరిశుద్ధంగా, పవిత్రంగా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“అతి పరిశుద్ధ స్థలాన్ని, సన్నిధి గుడారాన్ని, బలిపీఠాన్ని, అహరోను పవిత్రం చేస్తాడు. అలా జరిగిన తర్వాత ఆ మేకను ప్రాణంతోనే యెహోవా సన్నిధికి అహరోను తీసుకొని వస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","బతికే ఉన్న ఆ మేక తలమీద అహరోను తన రెండు చేతులు ఉంచుతాడు. అప్పుడు ఇశ్రాయేలు ప్రజల పాపాలను, నేరాలను ఆ మేకమీద అహరోను ఒప్పుకొంటాడు. ఈ విధంగా అహరోను ప్రజల పాపాలను మేక నెత్తిమీద మోపుతాడు. అప్పుడు ఆ మేకను అరణ్యంలోకి వదిలి పెట్టేస్తాడు. ఈ మేకను అతను తోలివేయటానికి పక్కనే ఒక మనిషి సిద్ధంగా నిలబడి ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","కనుక ప్రజలందరి పాపాలను ఆ మేక తనమీద మోసుకొని ఖాళీ అరణ్యంలోనికి తీసుకొనిపోతుంది. ఆ మేకను తోలు కొనిపోయిన వాడు అరణ్యంలో దానిని విడిచి పెట్టివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“అప్పుడు అహరోను సన్నిధి గుడారంలో ప్రవేశించాలి. పవిత్రస్థలంలోనికి వెళ్లినప్పుడు తాను ధరించిన వస్త్రాలను అతడు తీసివేయాలి. వాటిని అక్కడే వదిలివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","ఒక పవిత్ర స్థలంలో అతడు నీళ్లతో స్నానం చేయాలి. అప్పుడు అతడు తన ఇతర ప్రత్యేక వస్త్రాలు ధరించాలి. అతడు బయటకు వచ్చి తనకోసం దహన బలిని, ప్రజలకోసం దహనబలిని అర్పించాలి. అతని కోసం, ప్రజలకోసం అతడు తనను పవిత్రంచేసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","అప్పుడు పాపపరిహారార్థ బలి పశువు యొక్క కొవ్వును అతడు బలిపీఠం మీద దహించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“విడిచిపెట్టే మేకను అరణ్యంలో విడిచి పెట్టిన వ్యక్తి తన బట్టలు ఉతుక్కొని, నీళ్లలో స్నానం చేయాలి. ఆ తర్వాత ఆ వ్యక్తి బసలోనికి రావచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","“పాపపరిహారార్థ బలిపశువులైన కోడెదూడను, మేకలను బస వెలుపలికి తీసుకొనిపోవాలి. ఈ జంతువుల రక్తం పవిత్ర వస్తువులను పవిత్రం చేసేందుకు పవిత్ర స్థలానికి తీసుకొని రాబడింది. ఆ జంతువుల చర్మాలను శవాలను, వాటి మలమును యాజకులు అగ్నితో కాల్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","తర్వాత వాటిని కాల్చిన వ్యక్తి తన వస్త్రాలను ఉతుక్కొని, నీళ్లలో స్నానంచేయాలి. ఆ తర్వాత ఆ వ్యక్తి బసలోనికి రావచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ఆ ఆజ్ఞ మీకు శాశ్వతంగా ఉంటుంది. ఏడవ నెల పదో రోజున మిమ్మల్ని మీరు తగ్గించుకోవాలి. మీరేమీపని చేయకూడదు. మీ మధ్య నివసిస్తున్న విదేశీ యాత్రికులు ఎవరూ పని చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ఎందుచేతనంటే ఆ రోజు యాజకుడు మిమ్మల్ని పవిత్రంచేసి, మీ పాపాలను కడిగివేస్తాడు. అప్పుడు మీరు యెహోవాకు పవిత్రం చేయబడిన వారవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ఇది మీకు చాల ముఖ్యమైన విశ్రాంతి రోజు. మీరు భోజనం చేయకూడదు. ఈ ఆజ్ఞ ఎప్పటికీ కొన సాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","“కనుక నియమించబడిన ప్రధాన యాజకుడు, అంటే యాజకత్వం చేసేందుకు నియమించబడ్డ మనిషి. అతడు అన్నింటినీ పవిత్రం చేసే కార్యక్రమాన్ని జరిగిస్తాడు. ఆ యాజకుడు పవిత్ర నార వస్త్రాలు ధరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","అతి పరిశుద్ధ స్థలాన్ని, సన్నిధి గుడారాన్ని, బలిపీఠాన్ని అతడు పవిత్రం చేయాలి. యాజకులను, ఇశ్రాయేలు ప్రజలందరినీ అతడు పవిత్రం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","ఇశ్రాయేలు ప్రజలను పవిత్రం చేసేందుకు ఇవ్వబడ్డ ఆ ఆజ్ఞ శాశ్వతంగా కొనసాగుతుంది. ప్రతి సంవత్సరంలో ఒక సారి మీరు వాటిని జరిగించాలి. ఎందుకంటే ఇశ్రాయేలు ప్రజల పాపాల మూలంగా వీటిని చేయవలెను.” కనుక మోషేకు యెహోవా ఆజ్ఞాపించిన వీటన్నింటినీ వారు జరిగించారు. ");
INSERT INTO tel2010_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“అహరోనుతో, అతని కుమారులతో, ప్రజలందరితో ఇలా చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ఇదే యెహోవా ఆజ్ఞ అని వారితో చెప్పు: ఇశ్రాయేలు మనిషి ఒకడు ఒక కోడెదూడను లేక గొర్రెపిల్లను, లేక ఒక మేకను బసలోగాని బస వెలుపలగానీ చంపవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ఆ వ్యక్తి ఆ జంతువును సన్నిధి గుడార ద్వారం దగ్గరకు తీసుకొని రావాలి. ఆ జంతువుయొక్క ఒక భాగాన్ని యెహోవాకు కానుకగా అతడు అర్పించాలి. ఆ వ్యక్తి దాని రక్తాన్ని చిందించాడు. కనుక అతడు తన కానుకను యెహోవా పవిత్ర గుడారానికి తీసుకొని వెళ్లాలి. ఆ జంతువులో ఒక భాగాన్ని యెహోవాకు కానుకగా అతడు తీసుకొని వెళ్లకపోతే, ఆ వ్యక్తి తన ప్రజల్లోనుండి వేరు చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ప్రజలు వారి సమాధాన బలిని యెహోవాకు అర్పించేందుకే ఈ నియమం. ఇశ్రాయేలు ప్రజలు పొలాల్లో చంపే జంతువులను కూడా తీసుకొని రావాలి. ఆ జంతువులను సన్నిధి గుడార ద్వారం దగ్గర వారు యెహోవాకు అర్పించాలి. ఆ జంతువులను వారు యాజకుని దగ్గరకు తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","అప్పుడు ఆ జంతువుల రక్తాన్ని సన్నిధి గుడారం దగ్గర యెహోవా బలిపీఠం మీద యాజకుడు చల్లుతాడు. మరియు ఆ జంతువుల కొవ్వును బలిపీఠం మీద యాజకుడు దహించాలి. ఇది యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2010_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","వారు వారి ‘మేక పోతు విగ్రహాలకు’ ఇంక ఎలాంటి బలులూ అర్పించకూడదు. ఆ ఇతర దేవుళ్ళను వారు వెంబడిస్తూ వచ్చారు. అలా వారు వ్యభిచారిణుల్లా ప్రవర్తించారు. ఈ నియమాలు ఎప్పటికీ కొనసాగుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“ప్రజలతో చెప్పు: ఒక ఇశ్రాయేలు పౌరుడు లేక ఒక యాత్రికుడు, లేక మీ మధ్య నివసిస్తున్న ఒక విదేశీయుడు దహన బలిగాని ప్రాయశ్చిత్త బలిగాని అర్పించవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","ఆ వ్యక్తి తన బలిని సన్నిధి గుడార ద్వారం దగ్గరకు తీసుకొని వెళ్లి అక్కడ దానిని యెహోవాకు అర్పించాలి. ఆ వ్యక్తి యిలా చేయకపోతే, అతడు తన ప్రజల్లోనుండి వేరు చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“రక్తాన్ని తినే వాళ్లకు నేను విరోధిని. ఆ వ్యక్తి ఇశ్రాయేలు పౌరుడు కావచ్చు లేక మీ మధ్య నివసించే విదేశీయుడు కావచ్చు. ఆ వ్యక్తిని తన ప్రజల్లోనుంచి నేను వేరు చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ఎందుచేతనంటే దేహానికి ప్రాణం రక్తంలోనే ఉంది. ఆ రక్తాన్ని బలిపీఠం మీద ప్రోక్షించే నియమాలు నేను మీకు ఇచ్చాను. మిమ్మల్ని మీరు పవిత్రం చేసుకొనేందుకు మీరిలా చేయాలి. మీరు తీసిన ప్రాణానికి విలువ చెల్లింపుగా ఆ రక్తాన్ని మీరు నాకు యివ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","కనుక ఇశ్రాయేలు ప్రజలకు నేను చెప్పేది ఇదే: మీలో ఎవ్వరూ రక్తం తినవద్దు. మీ మధ్య నివసించే ఏ విదేశీయుడూ రక్తం తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“తినదగిన జంతువును లేక పక్షిని ఎవరైనా పట్టుకొంటే, ఆ వ్యక్తి దాని రక్తాన్ని నేలమీద పోసి మట్టితో కప్పివేయాలి. ఆ వ్యక్తి ఇశ్రాయేలు పౌరుడు కావచ్చు లేక మీ మధ్య నివసించే విదేశీయుడు కావచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","మీరెందుకు ఇలా చేయాలి? ఎందుచేతనంటే దాని మాంసంలో ఇంకా రక్తం గనుక ఉంటే, ఆ జంతువు ప్రాణం దాని మాంసంలో ఉంటుంది. కనుక ఇశ్రాయేలు ప్రజలకు నేను ఈ ఆజ్ఞ ఇస్తున్నాను. ఇంకా రక్తంతో ఉన్న మాంసం తినవద్దు. రక్తం తినే ఏవ్యక్తి అయినాసరే తన ప్రజలనుండి వేరు చేయబడాల్సిందే. ");
INSERT INTO tel2010_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“మరియు దానంతట అదే చచ్చిన జంతువును తిన్నవాడుగాని, లేక మరో జంతువుచే చంపబడ్డ జంతువును తిన్నవాడుగాని ఆ సాయంత్రం వరకు అపవిత్రుడుగా వుంటాడు. ఆవ్యక్తి తన బట్టలు ఉతుక్కోవాలి. నీళ్లతో పూర్తి స్నానం చేయాలి. ఆ వ్యక్తి ఇశ్రాయేలు పౌరుడు కావచ్చును, లేక మీ మధ్య నివసిస్తున్న విదేశీయుడు కావచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ఆ వ్యక్తి తన బట్టలు ఉతుక్కోక పోయినా, స్నానం చేయకపోయినా అతడు పాపం చేత దోషిగా ఉంటాడు.” ");
INSERT INTO tel2010_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు ");
INSERT INTO tel2010_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పు: నేను యెహోవాను, మీ దేవుణ్ణి. ");
INSERT INTO tel2010_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","గతంలో మీరు ఈజిప్టులో జీవించారు. ఆ దేశంలో జరిగించిన వాటిని మీరు ఇప్పుడు చేయకూడదు. నేను మిమ్మల్ని కనానుకు నడిపిస్తున్నాను. ఆ ప్రజల ఆచారాలను పాటించవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","మీరు నా నియమాలకు విధేయులై, నా ఆజ్ఞలను పాటించాలి. ఎందుచేతనంటే నేను మీ దేవుడైన యెహోవాను గనుక. ");
INSERT INTO tel2010_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","అందుచేతనే మీరు నా ఆజ్ఞలను నియమాలను పాటించాలి. నా ఆజ్ఞలకు నియమాలకు విధేయుడయ్యే వ్యక్తి జీవిస్తాడు! నేనే యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“నీ రక్తసంబంధులతో నీవు ఎన్నడూ లైంగిక సంబంధం కలిగి ఉండకూడదు. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“నీ తండ్రితో, నీ తల్లితో నీవు ఎన్నడూ లైంగిక సంబంధం కలిగి ఉండకూడదు. ఆమె నీ తల్లి, ఆమెతో నీవు లైంగిక సంబంధము కలిగి ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","నీ తండ్రి యొక్క ఏ భార్యతో check brackets (ఆమె నీ తల్లి కానప్పటికీ) నీవు లైంగిక సంబంధం కలిగి ఉండకూడదు. నీ తండ్రి యొక్క ఏ భార్యతోనైనా నీ తండ్రికి మాత్రమే లైంగిక సంబంధాలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“నీ తండ్రి కుమార్తె లేక నీ తల్లి కుమార్తె నీకు సోదరి, ఆమెతో నీకు లైంగిక సంబంధాలు ఉండ కూడదు. నీ సోదరి నీ యింట పుట్టినా, లేక మరోచోట పుట్టినా సరే. ");
INSERT INTO tel2010_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“నీ మనుమరాలితో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ఆ పిల్లలు నీలో ఒక భాగం. ");
INSERT INTO tel2010_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“నీ తండ్రికి తల్లికి ఒక కుమార్తె ఉంటే, ఆమె నీ సోదరి. ఆమెతో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“నీ తండ్రి సోదరితో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ఆమె నీ తండ్రి రక్త సంబంధీకురాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","నీ తల్లి సోదరితో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ఆమె నీ తల్లి రక్తసంబంధీకురాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","నీ తండ్రి సోదరుని భార్యతో నీకు లైంగిక సంబంధాలు ఉండకూడదు. అనగా నీ పినతండ్రి భార్యతో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ఆమె నీ పినతల్లి. ");
INSERT INTO tel2010_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“నీ కోడలితో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ఆమె నీ కుమారుని భార్య. ఆమెతో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“నీ సోదరుని భార్యతో నీకు లైంగిక సంబంధాలు ఉండకూడదు. నీ సోదరుడు మాత్రమే తన భార్యతో లైంగిక సంబంధాలు కలిగి ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“తల్లి, కూతుళ్లతో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ఆ తల్లి మనుమరాలితో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ఈ మనుమరాలు ఆ తల్లి కుమారుని బిడ్డ కావచ్చు, కుమార్తె బిడ్డ కావచ్చు. ఆమె మనుమరాళ్లు ఆమె రక్తసంబంధీకులు. వారితో లైంగిక సంబంధాలు కలిగి ఉండటం తప్పు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“నీ భార్య బతికి ఉండగా, ఆమె సోదరిని నీకు మరో భార్యగా చేసుకోకూడదు. దీని మూలంగా అక్క చెల్లెళ్లు విరోధులవుతారు. నీ భార్య సోదరితో నీకు లైంగిక సంబంధాలు ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“మరియు ఒక స్త్రీకి నెలసరి రక్తస్రావం అవుతున్నప్పుడు, లైంగిక సంబంధాలకోసం నీవు ఆమె చెంతకు పోకూడదు. ఈ సమయంలో ఆమె అపవిత్రంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“నీ పొరుగువాని భార్యతో నీకు లైంగిక సంబంధాలు ఉండకూడదు. దీని మూలంగా నీవు అపవిత్రం అవుతావు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“మోలెకు కోసం నీ పిల్లల్లో ఎవరినీ అగ్నిగుండం దాటనియ్యకూడదు. ఒకవేళ నీవు అలా చేస్తే, నీ దేవుని నామం అంటే నీకు గౌరవం లేదని నీవు చూపించినట్టే, నేనే యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ఒక స్త్రీతో ఉన్నట్టు పురుషునితో నీకు లైంగిక సంబంధాలు ఉండకూడదు. అది భయంకర పాపం! ");
INSERT INTO tel2010_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ఏ జంతువుతోను నీకు లైంగిక సంబంధాలు ఉండకూడదు. దీని మూలంగా నీవు అపవిత్రం అవుతావు. అలాగే స్త్రీ జంతువుతో లైంగిక సంబంధాలు కలిగి ఉండకూడదు. అది సృష్టి విరుద్ధం! ");
INSERT INTO tel2010_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“అలాంటి వాటిలో దేనిమూలంగాను మిమ్మల్ని మీరు అపవిత్రం చేసుకోవద్దు. నేను జనాలను వారి దేశాలనుండి వెళ్లగొట్టి, వారి దేశాలను నేను మీకు యిస్తున్నాను. ఎందుచేతనంటే ఆ ప్రజలు ఆ చెడుకార్యాలు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","కనుక దేశం మైలపడిపోయింది. అలాంటి కార్యాలతో ఇప్పుడు దేశం రోగభూయిష్టమయింది. మరియు అక్కడ నివసించిన ప్రజలను ఆ దేశం ఇప్పుడు వెళ్లగొడుతుంది! ");
INSERT INTO tel2010_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","“కనుక మీరు నా ఆజ్ఞలకు, నియమాలకు విధేయులు కావాలి. ఆ భయంకర పాపాలు ఏవీ మీరు చేయకూడదు. ఇశ్రాయేలు పౌరులకు, మీ మధ్య నివసించే ప్రజలకు నియమాలు యివి. ");
INSERT INTO tel2010_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ఆ దేశంలో మీకు ముందు నివసించిన ప్రజలు ఆ భయంకర సంగతులన్నీ జరిగించారు. అందుచేత దేశం మైలపడింది. ");
INSERT INTO tel2010_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","మీరూ ఈ పనులు చేస్తే, మీరూ ఆ దేశాన్ని మైల చేస్తారు. మరియు మీకంటె ముందు అక్కడ ఉన్న వాళ్ళను వెళ్ళగొట్టినట్లు అది మిమ్మల్ని కూడ వెళ్ళగొడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","ఏ వ్యక్తి గాని ఈ దారుణ పాపాలలో దేనినైనా జరిగిస్తే, ఆ వ్యక్తి తన ప్రజల్లోనుండి వేరు చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","ఇతరులు ఆ భయంకర పాపాలు చేశారు. కాని మీరు మాత్రం నా ఆజ్ఞలకు విధేయులు కావాలి. ఆ భయంకర పాపాలేవీ మీరు చేయకూడదు. ఆ భయంకర పాపాలతో మిమ్మల్ని మీరు మైల చేసుకోవద్దు. నేను యెహోవాను, మీ దేవుణ్ణి.” ");
INSERT INTO tel2010_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పు: నేను మీ దేవుడైన యెహోవాను నేను పవిత్రుణ్ణి కనుక మీరునూ పవిత్రంగా ఉండాలి! ");
INSERT INTO tel2010_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“మీలో ప్రతి ఒక్కరూ తన తల్లిని, తండ్రిని గౌరవించాలి, నా ప్రత్యేక విశ్రాంతి దినాలను పాటించాలి. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“విగ్రహాలను పూజించకండి. మీకోసం అచ్చు వేసిన విగ్రహ దేవతలను చేసుకోవద్దు. నేనే మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“మీరు యెహోవాకు సమాధాన బలి అర్పించేటప్పుడు, మీరు స్వీకరించబడేందుకు దానిని అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","మీరు దాన్ని అర్పించిన రోజున, ఆ మరునాడు దాన్ని తినవచ్చును. కానీ ఆ బలిలో ఏమైనా మూడో నాటికి మిగిలి ఉంటే దాన్ని మీరు అగ్నితో కాల్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","బలిలోనిది ఏదైనా మూడో రోజున తింటే అది దారుణ పాపం. అది స్వీకరించబడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","అలా చేసే వ్యక్తి పాపం చేసిన అపరాధి అవుతాడు. ఎందు చేతనంటే యెహోవాకు చెందిన పవిత్ర విషయాలను అతడు గౌరవించలేదు కనుక ఆ వ్యక్తి తన ప్రజల్లోనుంచి వేరు చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“కోతకాలంలో మీరు మీ పంటకోసేప్పుడు, మొత్తం మీ పొలాల మూలవరకు కోసెయ్యకండి. ఒకవేళ గింజలు ఏమైనా నేలమీద పడితే ఆ గింజలు మీరు ఏరుకోగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","మీ ద్రాక్షా తోటల్లో ద్రాక్షాపండ్లన్నీ ఏరుకోవద్దు. నేలమీద పడిన ద్రాక్షపండ్లను ఏరుకోవద్దు. ఎందుచేతనంటే, పేదవాళ్ళ కోసం, మీ దేశంగుండా ప్రయాణం చేసే వాళ్ళకోసమూ మీరు వాటిని విడిచిపెట్టాలి. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“మీరు దొంగతనం చేయకూడదు. మీరు ప్రజల్ని మోసం చేయకూడదు. మీరు ఒకరితో ఒకరు అబద్ధం చెప్పకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","నా నామాన్ని ప్రయోగించి దొంగ వాగ్దానాలు చేయకూడదు. మీరు అలా చేస్తే, మీ దేవుని పేరుమీద మీకు భక్తి లేదని మీరు వ్యక్తంచేస్తారు. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“మీ పొరుగువారికి మీరు కీడు చేయకూడదు. మీరు అతని దగ్గర దోచు కోగూడదు. కూలివాని కూలి మర్నాటి ఉదయం వరకు మీరు బిగబట్టి ఉంచకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“మీరు చెవిటివారిని శపించకూడదు. గుడ్డివారి యెదుట ఏదీ అడ్డముంచి వారిని పడిపోయే విధంగా చేయకూడదు. కాని నీవు దేవునికి భయపడాలి. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“తీర్పు విషయంలో మీరు న్యాయంగా ఉండాలి. పేదవాళ్ళని చెప్పి ప్రత్యేకంగా పక్షపాతం చూపెట్టకూడదు. ప్రముఖులనీ పక్షపాతం చూపెట్ట కూడదు. మీ పొరుగు వారికి తీర్పు చెప్పేటప్పుడు మీరు న్యాయంగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","మీరు ఇతరులను గూర్చి తప్పడు కథలు వ్యాపింపజేస్తూ తిరగకూడదు. నీ పొరుగువాని ప్రాణానికి అపాయం కలిగించేది ఏదీ చేయవద్దు. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“నీ సోదరుణ్ణి నీ హృదయంలో కూడా నీవు ద్యేషించకూడదు. ఒకవేళ నీ పొరుగువాడు ఏదైనా తప్పు చేస్తే దాన్ని గూర్చి అతనితో మాట్లాడు. అయితే అతణ్ణి క్షమించు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","మనుష్యులు నీకు చేసిన కీడును మరచిపో. వారికి తిరిగి కీడు చేయాలని ప్రయత్నించకు. నిన్ను నీవు ప్రేమించుకొన్నట్టే నీ పొరుగువాణ్ణి ప్రేమించు. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“నా ఆజ్ఞలకు నీవు విధేయత చూపాలి. రెండురకాల పశువులను కలిసి సంతానోత్సత్తి చేయకూడదు. రెండు రకాల విత్తనాలు నీ పొలంలో నీవు చల్లకూడదు. రెండు రకాల మిశ్రమ దారాలతో నేయబడిన బట్టలు నీవు తొడగకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“మరొకని బానిస స్త్రీతో ఒకడు లైంగిక సంబంధాలు పెట్టుకోవటం సంభవించవచ్చు. అయితే ఈ బానిస స్త్రీ డబ్బుతో ఖరీదు చేయబడలేదు, లేక స్వతంత్రమూ పొందలేదు. ఇలా గనుక జరిగితే వారికి శిక్ష విధించాలి. కానీ వారికి మరణ శిక్ష లేదు. ఎందుచేతనంటే ఆ స్త్రీ స్వతంత్రురాలు కాదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ఆ మగవాడు సన్నిధి గుడార ద్వారం దగ్గరకు అపరాధ పరిహారార్థ బలి అర్పణను తీసుకొని రావాలి. అపరాధ పరిహారార్థ బలిగా ఒక గొర్రెపొట్టేలును అతడు తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","అతణ్ణి పవిత్రం చేసే కార్యాన్ని యాజకుడు జరిగిస్తాడు. ఆ పొట్టేలును అతడు చేసిన పాపం కోసం అపరాధ పరిహారార్థ బలిగా యెహోవా ఎదుట యాజకుడు అర్పించాలి. అప్పుడు అతడు చేసిన పాపం విషయంలో అతడు క్షమాపణ పొందుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ముందుకు మీరు మీ దేశంలో ప్రవేశిస్తారు. ఆ సమయంలో ఆహారంకోసం మీరు ఎన్నో రకాల చెట్లు నాటుతారు. ఒక చెట్టును నాటిన తర్వాత మూడు సంవత్సరాలవరకు ఆ చెట్టు ఫలం ఏదీ మీరు తినకూడదు. ఆ ఫలాన్ని మీరు ఉపయోగించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","నాలుగో సంవత్సరం ఆ చెట్టు ఫలం యెహోవాదే అవుతుంది. అది యెహోవాకు పవిత్ర స్తుతి అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","అప్పుడు అయిదో సంవత్సరం ఆ చెట్టు ఫలం మీరు తినవచ్చు. మరియు ఆ చెట్టు మీకు విస్తార ఫలాన్ని యిస్తుంది. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ఇంకా, రక్తం ఉన్నది. ఏదీ మీరు తినకూడదు. “భవిష్యత్తుగూర్చి ముందుగా చెప్పటానికి మంత్ర తంత్రాలు ఏవీ మీరు ఉపయోగించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“మీ తల చుట్టూ పెరిగే వెంట్రుకలను గుండ్రంగా క్షౌరం చేయకూడదు. మీ గడ్డం కొనలు కత్తిరించి వేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","చనిపోయిన వాళ్ల జ్ఞాపకార్థం మీరు మీ దేహాలను కోసుకోగూడదు. మీరు మీ ఒంటి మీద పచ్చలు పొడిపించుకోగూడదు. నేను మీ దేవుడైన యోహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“మీ కుమార్తెను వేశ్యగా మార్చవద్దు. అలా చేయటం ఆమెపై మీకు గౌరవం లేదని వ్యక్తం చేస్తుంది. మీ దేశంలో ప్రజల్ని వేశ్యలు కానీయవద్దు. అలాంటి పాపంతో మీ దేశాన్ని నిండనీయవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“నా ప్రత్యేక విశ్రాంతి దినాల్లో మీరు పని చేయకూడదు. నా పవిత్రస్థలాన్ని మీరు ఘనంగా చూడాలి. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“సలహాకోసం కర్ణపిశాచులు, సోదెగాళ్ల దగ్గరకు వెళ్లకూడదు. వాళ్ల దగ్గరకు వెళ్ళొద్దు, వారు మిమ్మల్ని అపవిత్రం చేస్తారు. నేను యెహోవాను, మీ దేవుణ్ణి. ");
INSERT INTO tel2010_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“వృద్ధులను గౌరవించండి. వారు గదిలోనికి వచ్చినప్పుడు లేచి నిలబడండి. మీ దేవునికి గౌరవం చూపెట్టండి. నేను యోహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“మీ దేశంలో నివసిస్తున్న విదేశీయులకు కీడు చేయకండి. ");
INSERT INTO tel2010_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","మీ స్వంత పౌరులను గౌరవించినట్టే, విదేశీయుల్ని కూడా మీరు గౌరవించాలి. మిమ్మల్ని మీరు ఎలా ప్రేమించుకొంటారో విదేశీయుల్ని కూడా అలా ప్రేమించాలి. ఎందుచేతనంటే ఒకప్పుడు మీరూ ఈజిప్టులో విదేశీయులే. నేను మీ దేవుడైన యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ప్రజలు తీర్పు తీర్చేటప్పుడు మీరు న్యాయంగా ఉండాలి. అలానే వస్తువుల్ని తూచేటప్పుడు, కొలిచేటప్పుడ మీరు న్యాయంగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","మీ తక్కెడలు సమానంగా ఉండాలి. మీ మొగ్గులు ద్రావకాలను సరిగ్గా నింపేవిగా ఉండాలి. మీ త్రాసులు, తూనికరాళ్లు వస్తువుల్ని సరిగ్గా తూచేవిగా ఉండాలి. నేను మీ దేవుడైన యెహోవాను. నేనే మిమ్మన్ని ఈజిప్టు దేశంనుండి బయటకు తీసుకొనివచ్చాను! ");
INSERT INTO tel2010_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“నా ఆజ్ఞలు, నియమాలు అన్నీ మీరు జ్ఞాపకం ఉంచుకోవాలి. వాటికి మీరు విధేయులు కావాలి. నేను యెహోవాను!” ");
INSERT INTO tel2010_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“ఇశ్రాయేలు ప్రజలతో ఈ విషయాలు కూడా నీవు చెప్పాలి: మీ దేశంలో ఒక వ్యక్తి తన పిల్లలలో ఒకరిని దొంగదేవత మోలెకునకు అర్పించడం జరగవచ్చు, అప్పుడు ఆ వ్యక్తిని చంపెయ్యాలి. ఆ వ్యక్తి ఇశ్రాయేలు పౌరుడైనా నా ఇశ్రాయేలులో నివసిస్తున్న విదేశీయుడైనా సరే, ఆ వ్యక్తిమీద మీరు రాళ్లు విసిరి చంపివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","నేను ఆ వ్యక్తికి విముఖుడ్ని. అతణ్ణి అతని ప్రజల్లోనుంచి నేను వేరుచేస్తాను. ఎందుచేతనంటే అతడు తన పిల్లల్ని మోలెకునకు ఇచ్చాడు. నా పవిత్ర నామం అంటే అతనికి గౌరవం లేదని అతడు వ్యక్తం చేసాడు. నా పవిత్ర స్థలాన్ని అతడు అపవిత్రం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ఒకవేళ సామాన్యులు అతణ్ణి పట్టించుకోక పోవచ్చు, ఒకవేళ తన పిల్లల్ని మోలెకునకు అర్పించినవాణ్ణి వారు పట్టించు కొనక పోవచ్చును, ");
INSERT INTO tel2010_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","కానీ నేను మాత్రం అతనికి, అతని కుటుంబానికి విరోధంగా ఉంటాను. అతణ్ణి తన ప్రజల్లోనుంచి నేను వేరుచేసేస్తాను. నాకు అపనమ్మకంగా ఉండి, మోలెకును వెంబడించే ఏ వ్యక్తినైనా సరే నేను వేరు చేసేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“సలహాకోసం కర్ణపిశాచుల దగ్గరకు, సోదె చెప్పేవారి దగ్గరకు వెళ్ళే ఏ వ్యక్తికైనా సరే నేను విరోధంగా ఉంటాను. అలాంటి వ్యక్తి నాకు అపనమ్మకంగా ఉన్నాడు. కనుక అలాంటి వాణ్ణి తన ప్రజల్లోనుంచి నేను వేరు చేసేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ప్రత్యేకంగా ఉండండి. మిమ్మల్ని మీరు పవిత్రం చేసుకోండి. ఎందుచేతనంటే నేను పవిత్రుడను గనుక. నేను యెహోవాను మీ దేవుణ్ణి. ");
INSERT INTO tel2010_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","నా ఆజ్ఞలు జ్ఞాపకం చేసుకొని విధేయులుగా ఉండండి. నేను యెహోవాను మరియు నా ప్రత్యేక ప్రజలుగా నేను మిమ్మల్ని చేసాను. ");
INSERT INTO tel2010_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ఏ వ్యక్తిగాని తన తండ్రిని లేక తల్లిని శపించినట్లయితే ఆ వ్యక్తిని చంపేయాలి. అతడు తన తండ్రిని లేక తల్లిని శపించాడు గనుక అతణ్ణి చెంపేయాల్సిందే. ");
INSERT INTO tel2010_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“మగవాడు ఒకడు తన పొరుగువాని భార్యతో లైంగిక సంబంధాలు పెట్టుకొంటే ఆ మగవాడు ఆడది ఇద్దరూ వ్యభిచార అపరాధులే. అందుచేత మగవాడు, ఆడది ఇద్దరూ చంపబడాల్సిందే. ");
INSERT INTO tel2010_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","ఒక మగవాడు తన తండ్రి భార్యతో లైంగిక సంబంధాలు పెట్టుకొంటే ఆ మగవాడు చంపివేయాలి. ఆ మగవాడు, అతని తండ్రి భార్యను, ఇద్దర్నీ చంపివేయాలి. వాడు తన తండ్రికి విరుద్ధంగా పాపం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ఒక మగవాడు తన కోడలితో లైంగిక సంబంధాలు కలిగి ఉంటే, వాళ్ళిద్దర్నీ చంపివేయాలి. వాళ్లు చాలా దారుణమైన లైంగిక పాపం చేసారు. వాళ్లు శిక్షించబడాల్సిందే. ");
INSERT INTO tel2010_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ఒక మగవాడు ఒక స్త్రీతో కలిగి ఉన్నట్టుగా మరో మగవాడితో లైంగిక సంబంధాలు కలిగి ఉంటే, వీళ్ళిద్దరు మగవాళ్లూ చాలా దారుణ పాపం చేసినట్టే. వాళ్ళను చంపివేయాల్సిందే. వాళ్ళ శిక్షకు వాళ్లే కారకులు. ");
INSERT INTO tel2010_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ఒక మగవాడు ఒక స్త్రీతో, ఆమె తల్లితో కూడా లైంగిక సంబంధాలు కలిగి ఉంటే అది లైంగిక పాపం. ఆ మగవాడ్ని, ఆడవాళ్లు ఇద్దర్నీ ప్రజలు కాల్చి వేయాలి. మీ ప్రజల మధ్య ఇలాంటి లైంగిక పరమైన పాపం జరగనివ్వకండి. ");
INSERT INTO tel2010_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ఒక మగావాడు ఒక జంతువుతో లైంగిక సంబంధాలు కలిగి ఉంటే అతణ్ణి చంపివేయాల్సిందే. మరియు మీరు ఆ జంతువును గూడ చంపివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","ఒక స్త్రీ గనుక ఒక జంతువుతో లైంగిక సంబంధం పెట్టుకొంటే, ఆ స్త్రీని, జంతువును కూడ మీరు చంపివేయాలి. వారిని చంపేయాలి, వాళ్ళ శిక్షకు వాళ్లే కారకులు. ");
INSERT INTO tel2010_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ఒక సోదరుడు అతని సోదరి అనగా తండ్రి కుమార్తెగాని, తల్లి కుమార్తెగాని ఒకరితో ఒకరు లైంగిక సంబంధం పెట్టుకోవటం చాలా సిగ్గుచేటు. వాళ్లను బహిరంగంగా శిక్షించాలి. వాళ్ల ప్రజల్లోనుంచి వాళ్లను వేరు చేయాలి. తన సోదరితో లైంగిక సంబంధం పెట్టుకొన్న మగవాడు అతని పాపం నిమిత్తం శిక్షపొందాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ఒక స్త్రీ నెలసరి రక్తస్రావ సమయంలో ఒక మగవాడు ఆమెతో లైంగిక సంబంధం పెట్టుకొంటే ఆ స్త్రీ పురుషులు ఇద్దర్నీ వాళ్ల ప్రజల్లోనుంచి వేరు చేయాలి. ఆమె రక్తస్రావ స్థానాన్ని వారు బహిర్గతం చేసారు గనుక వాళ్లు పాపం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“మీ తల్లి సోదరితో గాని, తండ్రి సోదరితో గాని లైంగిక సంబంధాలు పెట్టుకో గూడదు. అది రక్తసంబంధికుల పాపం. వాళ్ల పాపం మూలంగా వాళ్లు శిక్ష పొందాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ఒకడు తన పినతల్లితో శయనించగూడదు. అతడు, అతని పినతల్లికూడ వారు చేసిన పాపం మూలంగా శిక్ష పొందుతారు. వాళ్లు పిల్లలు లేకుండా చస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ఎవడైనా తన సోదరుని భార్యను చేర్చుకోవడం తప్పు. వాడు తన సోదరునికి విరోధంగా పాపం చేసాడు. వాళ్లకూ పిల్లలు ఉండరు. ");
INSERT INTO tel2010_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“నా ఆజ్ఞలు, నియమాలు అన్నీ మీరు జ్ఞాపకం ఉంచుకోవాలి. వాటికి మీరు విధేయులు కావాలి. నేను మిమ్మల్ని మీ దేశానికి నడిపిస్తున్నాను. ఆ దేశంలో మీరు నివసిస్తారు. మీరు నా ఆజ్ఞలకు, నియమాలకు విధేయులైతే ఆ దేశం మిమ్మల్ని వెళ్లగొట్టదు. ");
INSERT INTO tel2010_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","ఇతర ప్రజల్ని ఆ దేశంలో నుండి నేను వెళ్ల గొట్టేస్తున్నాను. ఎందుచేతనంటే వాళ్లు అలాంటి పాపాలన్నీ చేసారు. ఆ పాపాలంటే నాకు అసహ్యం. కనుక వాళ్లు జీవించినట్టు మీరు జీవించకండి. ");
INSERT INTO tel2010_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","వాళ్ల దేశం మీది అవుతుంది. అని నేను మీతో చెప్పాను. వాళ్ల దేశాన్ని నేను మీకు యిస్తాను. అది మీ దేశం అవుతుంది. ఆ దేశం చాలా మంచి దేశం. పాలు, తేనెలు ప్రవహించే దేశం అది. నేను మీ దేవుడైన యెహోవాను. “నేను మిమ్మల్ని నా ప్రత్యేక ప్రజలుగా చేసుకొన్నాను. ఇతరులకంటే మిమ్మల్ని నేను వేరుగా చూసుకొన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","కనుక పవిత్ర జంతువుల్ని అపవిత్ర జంతువులకంటె వేరుగా మీరు చూసుకోవాలి. పవిత్ర పక్షుల్ని అపవిత్ర పక్షుల కంటే వేరుగా మీరు చూసుకోవాలి. అపవిత్ర పక్షులు, జంతువులు, నేలమీద ప్రాకే వాటిలో దేన్నీ మీరు తినవద్దు. నేను వాటిని అపవిత్రంగా చేసాను. ");
INSERT INTO tel2010_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","నేను మిమ్మల్ని నా ప్రత్యేక ప్రజలుగా చేసాను. అందుచేత మీరు నా కోసం పవిత్రంగా ఉండాలి. ఎందుచేతనంటే నేను యెహోవాను, నేను పవిత్రుణ్ణి. ");
INSERT INTO tel2010_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“కర్ణపిశాచి, సోదెచెప్పేవారు, మగవాడు గాని, స్త్రీగాని చంపబడాల్సిందే. రాళ్లతో ప్రజలు వారిని చంపివేయాలి. వాళ్లు శిక్షించబడాలి.” ");
INSERT INTO tel2010_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","“యాజకులైన అహరోను కుమారులతో ఈ విషయాలు చెప్పు: అహరోను కుమారులు, యాజకులు: చనిపోయిన వారి శవాన్ని తాకి యాజకుడు అపవిత్రుడు కాకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","అయితే చనిపోయిన వ్యక్తి గనుక తన రక్త సంబంధీకుడైతే. అప్పుడు అతడు ఆ శవాన్ని తాకవచ్చు. చనిపోయిన వ్యక్తి యాజకుని తల్లి లేక తండ్రి, కుమారుడు లేక కుమార్తె, సోదరుడు లేక అవివాహిత సోదరి అయితే యాజకుడు అపవిత్రం కావచ్చు. (ఈ సోదరికి భర్త లేడు గనుక ఆమె అతనికి చాలా దగ్గర అవుతుంది. కనుక ఆమె మరణిస్తే, ఆమెకోసం యాజకుడు మైల పడవచ్చు). ");
INSERT INTO tel2010_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","కానీ చనిపోయిన వ్యక్తి యాజకుని బానిసల్లో ఒక వ్యక్తి అయితే మాత్రం యాజకుడు మైలపడకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“యాజకులు వారి తలలు గుండు గీసికో గూడదు. యాజకులు వారి గెడ్డాల కొనలు కత్తిరించగూడదు. యాజకులు వారి దేహాల్లో ఎక్కడా కోసుకోగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","యాజకులు వారి దేవుని కోసం పవిత్రంగా ఉండాలి. దేవుని పేరంటే వారు భక్తి చూపించాలి. ఎందుచేతనంటే వారు నైవేద్యం, హోమం దేవునికి అర్పించువారు. కనుక వారు పవిత్రంగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“యాజకుడు దేవుణ్ణి ప్రత్యేకంగా సేవించేవాడు. అందుచేత మరో మగవాడితో లైంగిక సంబంధం ఉన్న స్త్రీని యాజకుడు వివాహం చేసుకోగూడదు. వేశ్యనుగాని, విడువబడిన స్త్రీనిగాని యాజకుడు వివాహం చేసుకోగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","యాజకుడు ప్రత్యేక విధానంలో దేవుణ్ణి సేవించేవాడు. కనుక మీరు అతణ్ణి ప్రత్యేక విధానంలో చూసుకోవాలి. ఎందుచేతనంటే అతడు పవిత్ర వస్తువుల్ని మోసేవాడు గనుక. పవిత్ర రొట్టెల్ని అతడు దేవునికి తీసుకొనివస్తాడు, నేను పరిశుద్ధుడను. నేను యెహోవాను, మరియు నేను మిమ్మల్ని పరిశుద్ధులుగా చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ఒక యాజకుని కుమార్తె వేశ్య అయితే ఆమె తన పేరును నాశనం చేసికొంటుంది, తన తండ్రికి అవమానం కలిగిస్తుంది. కనుక ఆమెను కాల్చివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ప్రధాన యాజకుడు తన సోదరుల్లోనుంచి ఎంపిక చేయబడినవాడు. అతని తలమీద అభిషేకతైలం పోయబడింది. ఈ విధంగా అతడు ప్రధాన యాజకునిగా ప్రత్యేక పనికి నియమించబడ్డాడు. ప్రత్యేక వస్త్రాలు ధరించేందుకు అతడు ఏర్పాటు చేయబడ్డాడు. కనుక అతడు తన విచారాన్ని బాహాటంగా చూపించే పనులు చేయకూడదు. అతడు తన తల వెంట్రుకలను చింపిరిజుట్టుగా పెరగ నివ్వకూడదు. అతడు తన బట్టలు చింపుకోగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","మృత దేహాన్ని తాకి అతడు అపవిత్రుడు కాకూడదు. అతని స్వంత తండ్రి, తల్లి చనిపోయినా సరే అతడు ఆ శవాన్ని తాకగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ప్రధాన యాజకుడు పరిశుద్ధ స్థలంనుండి బయటకు వెళ్లగూడదు. అతడు అలా గనుకచేస్తే, అతడు అపవిత్రుడై, తర్వాత దేవుని పరిశుద్ధ స్థలాన్ని అతడు అపవిత్రం చేయవచ్చు. ప్రధాన యాజకుని తలమీద ప్రత్యేక తైలం పోయబడింది. ఇదే అతణ్ణి మిగిలిన ప్రజలకంటే ప్రత్యేకం చేసింది. నేను పరిశుద్ధుడైన యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ప్రధాన యాజకుడు కన్యగా ఉన్న స్త్రీని వివాహం చేసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","ఇదివరకే మరొకనితో లైంగిక సంబంధాలు కలిగి ఉన్న స్త్రీని ప్రధాన యాజకుడు వివాహం చేసుకోగూడదు. ఒక వేశ్యనుగాని, విడువబడిన స్త్రీనిగాని, లేక విధవరాలిని గాని ప్రధాన యాజకుడు వివాహం చేసుకోగూడదు. ప్రధాన యాజకుడు తన స్వంత ప్రజల్లోనే ఒక కన్యను వివాహం చేసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ఈ విధంగా ప్రజలు అతని పిల్లలకు మర్యాదనిస్తారు. ప్రధాన యాజకుణ్ణి అతని ప్రత్యేక పని నిమిత్తం యెహోవానగు నేనే ప్రత్యేకించాను.” ");
INSERT INTO tel2010_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“అహరోనుతో చెప్పు: నీ సంతానంలోని పిల్లలు ఎవరైనాసరే ఏదైనా శారీరక లోపం గలవారైతే వారు దేవునికి ప్రత్యేక రొట్టెలు తీసుకొని వెళ్లకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","అంగవిహీనం ఉన్న ఏ మనిషికూడ యాజకునిగా నాకు సేవ చేయకూడదు, నాకు బలులు అర్పించకూడదు. ఎలాంటివారు యాజకులుగా నన్ను సేవించగూడదు అంటే: గుడ్డి వాళ్లు, కుంటివాళ్లు, పాడైపోయిన ముఖం ఉన్నవాళ్లు, చేతులుగాని కాళ్లుగాని విపరీతంగా పొడవు ఉన్నవాళ్లు, ");
INSERT INTO tel2010_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","కాలైనా, చేయైనా విరిగినవాళ్లు, ");
INSERT INTO tel2010_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","గూనివాళ్లు, మరుగుజ్జువాళ్లు, కంటిలో లోపాలు ఉన్నవాళ్లు, దురద లేక చర్మ వ్యాధి ఉన్నవాళ్లు, అణగగొట్టబడిన వృషణాలు ఉన్నవాళ్లు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","“అహరోను సంతానంలో ఎవరిలోనైనా ఏదోషమైనా ఉంటే అలాంటి వ్యక్తి యెహోవాకు హోమ అర్పణలు అర్పంచకూడదు. ఆ వ్యక్తి ప్రత్యేక రొట్టెల్ని కూడా దేవునికి తీసుకొని వెళ్ల కూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","ఆ వ్యక్తి యాజక కుటుంబంలోని వాడు గనుక అతడు పవిత్ర రొట్టెల్ని తినవచ్చును. అతి పవిత్రమైన రొట్టెల్ని కూడా అతడు తినవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","కానీ అతడు మాత్రం తెరలోపలి అతి పరిశుద్ధ స్థలంలోనికి వెళ్లకూడదు, బలిపీఠం దగ్గరకు గూడ అతడు వెళ్లగూడదు. ఎందుచేతనంటే అతనిలో ఏదో తప్పు ఉంది. అతడు నా పరిశుద్ధ స్థలాన్ని అపవిత్రం చేయకూడదు. నేను యెహోవాను ఆ స్థలాల్ని పరిశుద్ధం చేస్తాను!” ");
INSERT INTO tel2010_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","కనుక అహరోనుతో, అతని కుమారులతో, ఇశ్రాయేలు ప్రజలందరితో మోషే ఈ సంగతులు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","యెహోవా దేవుడు మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“అహరోనుతో, అతని కుమారులతో చెప్పు: ఇశ్రాయేలు ప్రజలు నాకు వస్తువులను అర్పిస్తారు. ఆ వస్తువులు పవిత్రం అవుతాయి. అవినావి. అందుచేత యాజకులైన మీరు వాటిని తీసుకోగూడదు. పవిత్రమైన ఆ వస్తువుల్ని మీరు ఉపయోగిస్తే, నా పవిత్రనామం అంటే మీకు గౌరవం లేదని మీరు వ్యక్తం చేస్తారు. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","మీ సంతానమంతటిలో ఎవరైనా వాటిని తాకితే ఆ వ్యక్తి అపవిత్రం అవుతాడు. ఆ వ్యక్తి నానుండి వేరు చేయబడతాడు. ఇశ్రాయేలు ప్రజలు ఆ వస్తువుల్ని నాకు ఇచ్చారు. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“అహరోను సంతానంలో ఎవరికైనా దారుణమైన చర్మవ్యాధి ఉంటే, లేక స్రావరోగం ఉంటే అతడు పవిత్రం అయ్యేంతవరకు పవిత్రం భోజనం చేసేందుకు వీల్లేదు. అపవిత్రుడైన ఏ యాజకునికైనా ఆ నియమం వర్తిస్తుంది. అలాంటి యాజకుడు ఒక శవం మూలంగా కానీ, లేక తన ఇంద్రియం మూలంగా కానీ అపవిత్రుడు కావచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","అపవిత్రమైన, పాకే జంతువుల్లో దేన్ని తాకినా అతడు అపవిత్రుడు అవుతాడు. మరియు అపవిత్రమైన మరో మనిషిని తాకుట వల్ల అతడు అపవిత్రుడు అవుతాడు. దేని మూలంగా అతడు అపవిత్రమైనా సరే ");
INSERT INTO tel2010_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ఒక వ్యక్తి వాటిలో దేనిని తాకినా అతడు సాయంత్రంవరకు అపవిత్రుడవుతాడు. ఆ వ్యక్తి పవిత్ర భోజనాన్ని తినకూడదు. అతడు నీళ్లతో స్నానము చేసినా సరే అతడు పవిత్ర భోజనం తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","సూర్యాస్తమయం తర్వాతనే అతడు పవిత్రుడవుతాడు. అప్పడు అతడు పవిత్ర భోజనం తినవచ్చును. ఎందుచేతనంటే ఆ భోజనం అతనికి చెందుతుంది గనుక. ");
INSERT INTO tel2010_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","“ఒక జంతువు దానంతట అదేచచ్చినా, లేక మరో జంతువుచే చంపబడినా, చచ్చిన ఆ జంతువును యాజకుడు తినకూడదు. ఆ వ్యక్తి ఆ జంతువును తింటే అతడు అపవిత్రుడవుతాడు. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“యాజకులు నన్ను సేవించేందుకు నిర్ణీత సమయాలు ఉన్నాయి. ఆ సమయాల్లో వాళ్లు జాగ్రాత్తగా ఉండాలి. పవిత్రమైన వాటిని అపవిత్రం చేయకుండా వారు జాగ్రత్తగా ఉండాలి. వాళ్లు గనుక జాగ్రత్తగా ఉంటే వాళ్లు చావరు. నేనే, యెహోవాను. వాళ్లను ఈ ప్రత్యేక పనికోసం ప్రత్యేకించాను. ");
INSERT INTO tel2010_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","యాజక కుటుంబంలోని వాళ్లు మాత్రమే పవిత్ర భోజనం తినవచ్చు. యాజకునితో ఉంటున్న అతిధి లేక యాజకుని కూలివాడు పవిత్ర భోజనం తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","అయితే యాజకుడు తన స్వంత డబ్బుతో ఒక వ్యక్తిని బానిసగా గనుక కొనివుంటే ఆ వ్యక్తి పవిత్రమైన వాటిలో కొంత తినవచ్చును. యాజకుని ఇంట పుట్టిన బానిసలు కూడ యాజకుని భోజనంలో కొంత తినవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","యాజకుని కుమార్తె, యాజకుడు కాని వాణ్ణి వివాహం చేసుకోవచ్చు. ఆమె గనుక అలా చేస్తే, అప్పుడు ఆమె పవిత్ర అర్పణల్లోనివి ఏవీ తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ఒక యాజకుని కుమార్తె విధవరాలు కావచ్చును, లేదా విడాకులు పొందవచ్చును. ఆమెను పొషించే పిల్లలు ఆమెకు లేని కారణంగా ఆమె బాల్యంలో నివసించిన తన తండ్రి ఇంటికి తిరిగి వేళ్తే, అప్పుడు ఆమె తన తండ్రి భోజనాన్ని తినవచ్చును. అయితే యాజక కుటుంబంలోని వారు మాత్రమే ఈ భోజనంలో కొంత తినవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ఒక వ్యక్తి పవిత్ర భోజనంలో కొంత పోరబాటున తిన్నట్లయితే ఆ వ్యక్తి అంత పవిత్ర బోజనాన్ని యాజకునికి ఇచ్చివేయాలి. అయిదింట ఒకటి వంతున ఆ భోజనం ఖరీదు గూడ అతడు చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","“ఇశ్రాయేలు ప్రజలు యెహోవాకు కానుకలుయిస్తారు. ఆ కానుకలు పవిత్రం అవుతాయి. కనుక ఆ పవిత్ర వస్తువుల్ని యాజకుడు అపవిత్రం చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ఒక వేళ యాజకులు గనుక ఆ వస్తువులు పవిత్రం కావు అన్నట్టు వాటిని చూస్తే, పవిత్ర భోజనం తిన్నప్పుడు వారు వారి పాపాన్ని అధికం చేసుకొన్న వాళ్లవుతారు. యెహోవాను. నేనే వాటిని పవిత్రం చేస్తాను!” ");
INSERT INTO tel2010_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","యెహోవా దేవుడు మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“అహరోను, అతని కుమారులు, ఇశ్రాయేలు ప్రజలు అందరితో ఇలా చెప్పు: ఒకవేళ ఒక ఇశ్రాయేలు పౌరుడు, లేక ఒక విదేశీయుడు ఒక అర్పణ తీసుకొని రావాలను కొంటాడు. ఒకవేళ అది ఆ వ్యక్తి చేసుకొన్న ఏదో ఒక ప్రత్యేక వాగ్దానంగా కావచ్చు లేక ఒకవేళ ఆ వ్యక్తి ఇవ్వాలనుకొన్న ఒక ప్రత్యేక బలి కావచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","20","ఆ ప్రజలు నిజంగా దేవునికి కానుకలు ఇవ్వాలని కోరుకొన్నందుచేత వారు తెచ్చే కానుకలు అవి. దోష భూయిష్టమైన ఏ అర్పణా నీవు అంగీకరించగూడదు. అలాంటి అర్పణవల్ల నాకు సంతోషం కలుగదు. కనుక ఒక కోడెదూడ, గొర్రె, మేక అయితే అది మగదైఉండాలి. ఆపైన దానిలో ఏ దోషమూ ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","“ఒక వ్యక్తి సమాధాన బలి యెహోవాకు తీసుకొని రావచ్చును. ఆ సమాధాన బలి ఆ వ్యక్తి చేసుకొన్న ఏదో ప్రత్యేక వాగ్దానానికి చెల్లింపు కావచ్చును. లేక అది ఆ వ్యక్తి యెహోవాకు అర్పించాలనుకొన్న ఒక ప్రత్యేక కానుక కావచ్చును. అది ఇక కోడెదూడ కావచ్చును లేక గొర్రె కావచ్చును. కానీ అది ఆరోగ్యంగా ఉండాలి. ఆ జంతువులో ఏ దోషమూ ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","గుడ్డిది, ఎముకలు విరిగింది, కుంటిది లేక స్రావరోగం ఉన్నది, లేక దారుణమైన చర్మవ్యాధి ఉన్నది, ఏ జంతువును మీరు యెహోవాకు అర్పించకూడదు. యెహోవా బలిపీఠపు అగ్నిమీద రోగగ్రస్థమైన జంతువులను మీరు అర్పించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","“కొన్నిసార్లు ఒక కాలు మరీ పొడవుగానో లేక సరిగ్గా పెరగని ఒక పాదమో ఉన్న ఒక కోడెదూడగాని గొర్రెగాని ఉండవచ్చు. ఒకవేళ ఒక వ్యక్తి అలాంటి జంతువును యెహోవాకు ప్రత్యేక కానుకగా అర్పించాలనుకొంటే, అది అంగీకారం అవుతుంది. అయితే ఆ వ్యక్తి చేసిన ప్రత్యేక వాగ్దానానికి చెల్లింపుగా మాత్రం అది అంగీకరించబడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","“ఒక జంతువుకు గాయపడ్డ, లేక అణగగొట్టబడిన లేక చినిగిన వృషణాలు ఉంటే అలాంటి జంతువును మీరు యెహోవాకు అర్పించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","“విదేశీయుల దగ్గర్నుండి జంతువుల్ని యెహోవాకు బలిగా మీరు తీసుకోగూడదు. ఎందుచేతనంటే ఆ జంతువులు ఏ విధంగానైనా దెబ్బతిన్నాయేమో, లేదా వాటిలో ఏదైనా లోపం ఉండొచ్చు అందుచేత అవి అంగీకరించబడవు!” ");
INSERT INTO tel2010_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ఒక కోడెదూడ, లేక ఒక గొర్రె, లేక ఒక మేక పుట్టినప్పుడు ఏడు రోజులు అది తన తల్లితో ఉండాలి, అప్పుడు ఎనిమిదో రోజునగాని ఆ తర్వాతగాని యెహోవాకు హోమంగా అర్పించే బలిగా అది అంగీకరించ బడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","కానీ ఆ జంతువును, దాని తల్లిని ఒకే రోజున మీరు చంపకూడదు. పశువులకు, గొర్రెలకు యిదే నియమం వర్తిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“ఏదైనా ప్రత్యేక కృతజ్ఞత అర్పణ మీరు యెహోవాకు అర్పించాలని కోరితే, మీరు స్వచ్ఛగా ఆ కానుకను అర్పించవచ్చును. అయితే అది దేవుణ్ణి సంతోషపెట్టే విధానంలో మీరు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","మొత్తం జంతువును ఆ రోజే మీరు తినాలి. దాని మాంసంలో ఏమీ మర్నాటి ఉదయానికి మీరు మిగల్చకూడదు. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“నా ఆజ్ఞలను జ్ఞాపకం ఉంచుకోండి. వాటికి విధేయులవ్వండి. నేను యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","నా పవిత్ర నామానికి గౌరవం చూపించండి. ఇశ్రాయేలు ప్రజలకు నేను ఎంతో ప్రత్యేకంగా ఉండాలి. నేను, యెహోవాను, మిమ్మల్ని నా ప్రత్యేక ప్రజలుగా చేసుకొన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","నేనే మిమ్మల్ని ఈజిప్టునుండి తీసుకొని వచ్చాను. నేను మీకు దేవుణ్ణి అయ్యాను. నేను యెహోవాను!” ");
INSERT INTO tel2010_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పు: యెహోవా ఏర్పాటు చేసిన పండుగలను పవిత్ర సమావేశాలుగా మీరు ప్రకటించాలి. నా ప్రత్యేక దినాలు ఏవంటే: ");
INSERT INTO tel2010_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ఆరు రోజులు పని చేయండి. అయితే ఏడో రోజు సబ్బాతు, అది పవిత్ర సమావేశం జరిగే రోజు. మీరేమీ పని చేయకూడదు. మీ అందరి గృహాల్లోను ఆది యెహోవా నియమించిన సబ్బాతు. ");
INSERT INTO tel2010_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ఇవి యెహోవా ఏర్పాటు చేసిన పండుగ రోజులు. నిర్ణీత సమాయాల్లో పవిత్ర సమావేశాల్ని గూర్చి మీరు ప్రకటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","మొదటి నెల 14వ రోజు సాయంకాలం యెహోవా పస్కాపండుగ. ");
INSERT INTO tel2010_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","“అదే నెల 15వ రోజు పులియని రొట్టెల పండుగ. పులియని రొట్టెలను ఏడు రోజులు మీరు తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ఈ సెలవల్లో మొదటి రోజున మీకు ఒక పవిత్ర సమావేశం ఉంటుంది. ఆ రోజున మీరు ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ఏడు రోజులవరకు మీరు యెహోవాకు బలి అర్పించాలి. ఏడవ రోజున ఒక పవిత్ర సమావేశం జరుగుతుంది. ఆ రోజున మీరు ఏ పనీ చేయకూడదు.” ");
INSERT INTO tel2010_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“ఇశ్రాయేలు ప్రజలతో చెప్పు: నేను మీకు ఇచ్చే దేశంలో మీరు ప్రవేశిస్తారు. మీరు అక్కడ పంటలు కోస్తారు. ఆ సమయంలో మీ పంటలోని ప్రథమ పనను యాజకుని దగ్గరకు మీరు తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","ఆ పనను యాజకుడు యెహోవా ఎదుట అల్లాడిస్తాడు. అప్పుడు మీరు స్వీకరించబడతారు. యాజకుడు ఆదివారం ఉదయం ఆ పనను అల్లాడిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","“మీరు పనను అల్లాడించే రోజున, ఒక సంవత్సరపు పోతు గొర్రె పిల్లను మీరు అర్పించాలి. ఆ గొర్రె పిల్లకు ఏ దోషం ఉండకూడదు. ఆ గొర్రెపిల్ల యెహోవాకు దహనబలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ఒలీవ నూనెతో కలిపిన రెండు పదోవంతుల పిండిని ధాన్యార్పణగా మీరు అర్పించాలి. ముప్పావు ద్రాక్షారసమును కూడా మీరు అర్పించాలి. ఆ అర్పణలు యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2010_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","దేవునికి ఆ అర్పణలు చెల్లించేవరకు, కొత్త ధాన్యంగాని, ఫలాలుగాని, లేక కొత్త ధాన్యంతో చేయబడిన రొట్టెగాని మీరు తినకూడదు. మీరు ఎక్కడ నివసించినా సరే మీ తరాలన్నింటినీ ఈ ఆజ్ఞ కొన సాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ఆ ఆదివారం మొదలు కొని (నైవేద్యం కోసం మీరు పన తీసుకొని వచ్చిన రోజునుండి) ఏడు వారాలు లెక్కించండి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ఏడవ వారం తర్వాత ఆదివారం నాడు (అంటే యాభై రోజుల తర్వాత) యెహోవాకు మీరు కొత్త ధాన్యార్పణను తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","ఆ రోజున మీ యిండ్ల నుండి రెండు రొట్టెలు తీసుకొని రండి. ఆ రొట్టె నైవేద్యంకోసం. 4 పావులు గోధుమ పిండిలో, పులిసిన పదార్థం ఉపయోగించి ఆ రొట్టెలు తయారుచేయాలి. అది మీ ప్రథమ పంటల్లోనుంచి మీరు యెహోవాకు అర్పించే కానుక. ");
INSERT INTO tel2010_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","“ప్రజలు ధాన్యార్పణతో బాటు ఒక దూడను ఒక పొట్టేలును, ఏడాది పోతును, ఏడు గొర్రెపిల్లలను అర్పించాలి. వాటిలో ఏ దోషమూ ఉండకూడదు. అవి యెహోవాకు దహనబలి అర్పణ. అవి హోమంగా అర్పించబడి, యెహోవాకు కమ్మని సువాసనగా ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","పాప పరిహారార్థ బలిగా ఒక మేకపోతును, సమాధాన బలిగా రెండు ఏడాది మగ గొర్రెపిల్లలను మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","“నైవేద్యంగా ప్రథమ ఫలంలోని రొట్టెతో పాటు వాటిని, రెండు గొర్రెపిల్లలను యెహోవా ఎదుట యాజకుడు అల్లాడించాలి. అవి యెహోవాకు పవిత్రమైనది. అవి యాజకునికి చెందుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","అదే రోజున మీరు ఒక పవిత్ర సమావేశాన్ని ఏర్పాటు చేయాలి. ఈ రోజులలో మీరేమి పని చేయకూడదు. మీ గృహాలన్నింటిలో ఈ ఆజ్ఞ శాశ్వతంగా కొనసాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“మరియు, మీరు మీ పొలంలో పంట కోసేటప్పుడు పొలం అంచులమట్టుకు కోసి వేయవద్దు. నేలమీద పడే కంకులు ఏరుకోవద్దు. పేదవారికోసమూ, మీ దేశం గుండా ప్రయాణించే విదేశీయుల కోసమూ వాటిని విడిచిపెట్టండి. నేను యెహోవాను, మీ దేవుణ్ణి!” ");
INSERT INTO tel2010_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","మరల మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“ఇశ్రాయేలు ప్రజలతో చెప్పు ఏడవ నెల మొదటి రోజున మీకు ప్రత్యేకమైన విశ్రాంతి రోజు ఉండాలి. అప్పుడు ఒక పవిత్ర సమావేశం ఉంటుంది. ప్రత్యేక జ్ఞాపకార్థ సమయంగా మీరు బూర ఊదాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ఆ రోజున మీరు ఏ పనీ చేయకూడదు. మీరు యెహోవాకు హోమ అర్పణలు అర్పించాలి” ");
INSERT INTO tel2010_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","మోషేతో యెహోవా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ఏడవ నెల పదవరోజు ప్రాయశ్చిత్త దినంగా ఉంటుంది. ఒక పవిత్ర సమావేశం ఉంటుంది. మీరు భోజనం చేయకూడదు, యోహోవాకు మీరు హోమ అర్పణ తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ఆ రోజున మీరు ఏ పనీ చేయకూడదు. ఎందు చేతనంటే అది ప్రాయశ్చిత్త దినం. ఆ రోజు, యాజకులు యెహోవా ఎదుటికి వెళ్లి, మిమ్మల్ని పవిత్రం చేసే ఆచారక్రమాన్ని జరిగిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","“ఆ రోజున భోజనం చేయకుండా ఉండేందుకు ఎవరైనా తిరస్కరిస్తే, ఆ వ్యక్తిని తన ప్రజలనుండి వేరు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ఆ రోజున ఎవరైనా పని చేస్తే ఆ వ్యక్తిని తన ప్రజల్లోనుంచి నేను నాశనం చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","మీరు అసలు ఏమీ పని చేయాకూడదు. మీరు ఎక్కడ నివసించినా ఈ ఆజ్ఞ శాశ్వతంగా కొనసాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","అది మీకు ఒక ప్రత్యేక విశ్రాంతి దినం. మీరు భోజనం చేయకూడదు. నెలలో తొమ్మిదవ రోజు తర్వాత సాయంకాలంనుండి ఈ ప్రత్యేక విశ్రాంతి దినం మీరు ప్రారంభించాలి. ఆ సాయంత్రంనుండి మర్నాటి సాయంకాలం వరకు ఈ ప్రత్యేక విశ్రాంతి దినం కొనసాగుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","మరల మోషేతో యెహోవా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“ఇశ్రాయేలు ప్రజలతో చెప్పు: ఏడవ నెల పదిహేనోవ తేదీన పర్ణశాలల పండుగ యెహోవాకు ఈ పండుగ ఏడు రోజులపాటు కొనసాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","మొదటి రోజున పవిత్ర సమావేశం ఉంటుంది. మీరు ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ఏడు రోజులు యెహోవాకు హోమార్పణలు మీరు అర్పించాలి. ఎనిమిదో రోజు మీకు మరో పవిత్ర సమావేశం జరుగుతుంది. మీరు యెహోవాకు హోమార్పణలు అర్పించాలి. ఇది పవిత్ర సమావేశంగా ఉంటుంది. మీరు ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“అవి యెహోవా ప్రత్యేక పండుగలు. ఆ పండుగల్లో పవిత్ర సమావేశాలు జరుగుతాయి. అర్పణలు, బలి అర్పణలు, పానార్పణలు, దహనబలులు, ధాన్యార్పణలు మీరు యెహోవాకు తీసుకొని రావాల్సిన హోమార్పణలు. ఆ కానుకలు తగిన సమయంలో మీరు తీసుకొని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","యెహోవా సబ్బాతు రోజులు జ్ఞాపకం చేసుకోవటంతోబాటు ఈ పండుగలన్నీ మీరు ఆచరించాలి. యెహోవాకు మీరు అర్పించే మీ ఇతర అర్పణలుగాక ఈ కానుకలు అర్పించాలి. మీ ప్రత్యేక వాగ్దానాల చెల్లింపుగా మీరు అర్పించే అర్పణలు గాక వీటిని మీరు అర్పించాలి. మీరు యెహోవాకు ఇవ్వాలనుకొన్న ప్రత్యేక అర్పణలుకాక ఇవి మీరు ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ఏడువ నెల పదిహేనొవ రోజున, దేశంలో మీరు పంటలు కూర్చుకొన్నప్పుడు, యెహోవా పండుగను ఏడు రోజుల పాటు మీరు ఆచరించాలి. మొదటి రోజున, ఏడో రోజున మీరు విశ్రాంతి తీసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","మొదటి రోజు పండ్ల చెట్లనుండి మంచి పండ్లు మీరు కూర్చాలి. ఈత మట్టలు, గొంజి చెట్ల కొమ్మలు, కాలువల దగ్గరి నిరవంజి చెట్లు మీరు తీసుకోవాలి. మీ యెహోవా దేవుని ఎదుట ఏడు రోజులు మీరు పండుగ ఆచరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ప్రతి సంవత్సరం ఏడు రోజులు యెహోవాకు పండుగగా మీరు దీనిని ఆచరించాలి. ఈ ఆజ్ఞ శాశ్వతంగా కొనసాగుతుంది. ఏడవ నెలలో మీరు ఈ పండుగను ఆచరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ఏడు రోజులు తాత్కాలిక గుడారాల్లో మీరు నివసించాలి. ఇశ్రాయేలీయులలో పుట్టిన వాళ్ళంతా ఆ పర్ణశాలల్లోనే నివసించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ఇశ్రాయేలు ప్రజలను ఈజిప్టునుండి నేను బయటకు తీసుకొని వచ్చినప్పుడు, తాత్కాలిక గుడారాల్లో నేను వారిని నివసింపజేసానని మీ సంతానం అంతా తెలుసుకోవాలి. నేను మీ దేవుడనైన యోహోవాను!” ");
INSERT INTO tel2010_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","కనుక యెహోవా పండుగ రోజులు అన్నింటిని గూర్చి ఇశ్రాయేలు ప్రజలందరితో మోషే చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“గానుగ ఆడిన ఒలీవలనుండి పవిత్ర తైలం తీసుకొని రమ్మని ఇశ్రాయేలు ప్రజలకు ఆజ్ఞాపించు. ఆ నూనె దీపాల కోసం. ఆ దీపాలు ఆరిపోకుండా వెలగాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","సన్నిధి గుడారంలో యెహోవా ఎదుట సాయంత్రం నుండి ఉదయం వరకు దీపం వెలిగేటట్లు అహరోను చూసుకొంటాడు. ఇది సాక్ష్యపు తెర ఎదుట ఉంటుంది. అతి పవిత్రస్థలంలో ఈ తెర వెనుకనే ఒడంబడిక పెట్టె ఉంటుంది. ఈ ఆజ్ఞ శాశ్వతంగా కొనసాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","యెహోవా ఎదుట స్వచ్ఛమైన బంగారపు దీపస్తంభం మీద దీపాలను అహరోను ఎల్లప్పుడూ వెలగనిస్తూఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“మంచి రకం గోధుమ పిండి తీసుకొని, దానితో పన్నెండు రొట్టెలు చేయాలి. ఒక్కో రొట్టెకు నాలుగు పావుల గోధుమపిండి ఉపయోగించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","యెహోవా ఎదుట బంగారు బల్లమీద ఆ రొట్టెలను రెండు వరుసలుగా పెట్టాలి. ఒక్కో వరుసలో ఆరు రొట్టెలు ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","ఒక్కో వరుసమీద స్వచ్ఛమైన సాంబ్రాణి వేయాలి. ఇది యెహోవాకు అర్పించబడిన హోమాన్ని ఆయనను జ్ఞాపకం చేసుకొనేట్టు చేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ప్రతి సబ్బాతు నాడు అహరోను ఈ రొట్టెలను యెహోవా ఎదుట క్రమంలో ఉంచాలి. శాశ్వతంగా ఇలా చేయాలి. ఇశ్రాయేలు ప్రజలతో ఈ ఒడంబడిక ఎప్పటికీ కొనసాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ఆ రొట్టె అహరోనుకు, అతని కుమారులకు చెందుతుంది. వారు ఈ రొట్టెను పరిశుద్ధ స్థలంలో తినాలి. ఎందుచేతనంటే యోహోవాకు హోమంగా అర్పించబడిన అర్పణల్లో అది ఒకటి. ఆ రొట్టె ఎప్పటికీ అహరోను భాగం అవుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ఒక ఇశ్రాయేలు స్త్రీకి కుమారుడు ఒకడు ఉన్నాడు. వాని తండ్రి ఈజిప్టువాడు. ఈ ఇశ్రాయేలు స్త్రీ కుమారుడు ఇశ్రాయేలువాడే. అతడు ఇశ్రాయేలు ప్రజల మధ్య తిరుగుతూ, బసలో పోరాడటం మొదలుపెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","ఆ ఇశ్రాయేలు స్త్రీ కుమారుడు యెహోవా నామాన్ని శపిస్తూ, దూషణ మాటలు మాట్లాడటం మొదలు పెట్టాడు కనుక ప్రజలు అతణ్ణి మోషే దగ్గరకు తీసుకొని వచ్చారు. (అతని తల్లి పేరు షెలోమితు, దాను కుటుంబ వంశానికి చెందిన దిబ్రీ కుమార్తె) ");
INSERT INTO tel2010_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ప్రజలు వాణ్ణి బందీగా పట్టి, యెహోవా ఆజ్ఞ వివరంగా తెలియటం కోసం కనిపెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","అప్పుడు మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ఆ శపించినవాణ్ణి బసవెలుపలికి తీసుకొని రండి. తర్వాత అతడు శపిస్తూండగా విన్న ప్రజలందర్నీ సమావేశ పరచండి. వాళ్లు అతని తలమీద చేతులు వేయాలి. తర్వాత ప్రజలంతా వాణ్ణి రాళ్లతో కొట్టి చంపాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","ఇశ్రాయేలు ప్రజలతో నీవు చెప్పు: ఎవడైనా తన దేవుణ్ణి శపిస్తే వాడు ఈ విధంగా శిక్షించబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","యెహోవా నామానికి వ్యతిరేకంగా ఎవరైనా దూషణచేస్తే, వాణ్ణి చంపివేయాలి, ప్రజలంతా వాణ్ణి రాళ్ళతో కొట్టాలి. ఇశ్రాయేలీయులలో పుట్టిన వాడిలా గానే, విదేశీయులు కూడా శిక్షించబడాలి. ఏ వ్యక్తిగాని యెహోవా నామాన్ని శపిస్తే ఆ వ్యక్తిని చంపివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ఇంకా ఒకడు మరొక వ్యక్తిని గనుక చంపేస్తే, అలాంటివాణ్ణి చంపివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","మరొకరికి చెందిన జంతువును చంపినవాడు ఆ జంతువుకు బదులుగా మరొక జంతువును ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","“ఒకడు తన పొరుగువానికి గాయం చేస్తే, వానికి కూడా అలానే చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","విరిగిన ఎముకకు విరిగిన ఎముక, కంటికి కన్ను, పంటికి పన్ను. ఒకనికి ఎలాంటి దెబ్బలు తగిలితే, వాటి కారకునికి గూడా అలాంటి దెబ్బలే. ");
INSERT INTO tel2010_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","కనుక ఒకని జంతువును చంపినవాడు దాని స్థానంలో మరో జంతువును ఇవ్వాలి. అయితే మరొ కడ్ని చంపినవాణ్ణి మాత్రం చంపివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","“మీకు ఒకే రకం న్యాయం ఉంటుంది. మీ స్వంత దేశంలో ఉండే విదేశీయునికి కూడా అదే న్యాయం ఉంటుంది. ఎందుచేతనంటే నేను మీ దేవుడైన యెహోవాను గనుక.” ");
INSERT INTO tel2010_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","అప్పుడు మోషే ఇశ్రాయేలు ప్రజలతో మాట్లాడగా, శపించిన వ్యక్తిని బసవెలుపలకు వారు తీసుకొని వచ్చారు. అప్పుడు వాళ్లు రాళ్లతో కొట్టి అతణ్ణి చంపివేసారు. కనుక మోషేకు యెహోవా ఆజ్ఞాపించినట్టే ఇశ్రాయేలు ప్రజలు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","సీనాయి కొండ దగ్గర యెహోవా మోషేతో మాట్లాడాడు. యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పు: నేను మీకు ఇవ్వబోతున్న దేశంలో మీరు ప్రవేశిస్తారు. ఆ సమయంలో మీరు భూమికి ఒక ప్రత్యేక విశ్రాంతి సమయాన్ని కేటాయించాలి. ఇది యెహోవాను ఘనపర్చేందుకు ఒక ప్రత్యేక సమయంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ఆరు సంవత్సరాలు మీరు మీ భూమిలో విత్తనాలు చల్లుకోవాలి. మీ ద్రాక్షా తోటల్లోని తీగెలను ఆరు సంవత్సరాలు మీరు కత్తిరించుకొంటూ, దాని ఫలాన్ని కూర్చుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","అయితే ఏడో సంవత్సరం మీరు భూమిని విశ్రాంతి తీసుకోనివ్వాలి. ఇది యెహోవాను ఘనపర్చేందుకు ప్రత్యేక విశ్రాంతి సమయంగా ఉంటుంది. మీరు మీ పొలాల్లో విత్తనాలు చల్లకూడదు లేక మీ ద్రాక్షాతోటల్లో తీగలను కత్తిరించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","మీ పంట కోత అయిపోయిన తర్వాత వాటంతట అవే పెరిగే పంటను మీరు కోయకూడదు. కత్తిరించ బడని ద్రాక్షాతీగెలనుండి ద్రాక్షా పండ్లను మీరు కూర్చగూడదు. భూమికి అది విశ్రాంతి సంవత్సరంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","“భూమికి ఒక సంవత్సరం విశ్రాంతి సంవత్సరంగా ఉంటుంది గాని మీకు మాత్రం యింకా సరిపడినంత ఆహారం ఉంటుంది. మీ ఆడ, మగ సేవకులందరికీ సరిపడినంత ఆహారం ఉంటుంది. మీ కూలి వాళ్లకు, మీ దేశంలో నివసించే విదేశీయులకు ఆహారం ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","మీ పశువులు, ఇతర జంతువులు తినేందుకు సరిపడినంత ఆహారం ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ఏడేసి సంవత్సరాల సముదాయంగల ఏడు సంవత్సరాలనుకూడ మీరు లెక్కించాలి. అది 49 సంవత్సరాలు అవుతుంది. ఆ సమయంలో దేశంలో ఏడు సంవత్సరాలు విశ్రాంతి ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ప్రాయశ్చిత్తం రోజున పొట్టేలు కొమ్మును మీరు ఊదాలి. అది ఏడో నెల పదోరోజు. పొట్టేలు కొమ్మును మీరు దేశ వ్యాప్తంగా ఊదాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","50వ సంత్సరాన్ని మీరు ఒక ప్రత్యేక సంవత్సరంగా చేయాలి. మీ దేశంలో నివసించే మనుష్యులందరికీ మీరు స్వతంత్రం ప్రకటించాలి. ఇది బూరధ్వని చేసే మహోత్సవ కాలం అని పిలువబడుతుంది. మీలో ప్రతి ఒక్కరూ తన స్వంత ఆస్తిని తిరిగి పొందాలి. మరియు మీలో ప్రతి ఒక్కరూ తన కుటుంబానికి తిరిగి వెళ్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","50వ సంవత్సరం మీకు ప్రత్యేక సంబరంగా వుంటుంది. ఆ సంవత్సరములో విత్తనాలు చల్లవద్దు. వాటంతట అవే మొలిచే మొక్కల్ని కోయవద్దు. కత్తిరించబడని ద్రాక్షావల్లులనుండి ద్రాక్షాపండ్లు కూర్చవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","అది బూరధ్వని చేసే మహోత్సవ కాలం. అది మీకు పవిత్ర సమయంగా ఉంటుంది. పొలంనుండి వచ్చే పంటలను మీరు తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","బూరధ్వని చేసే మహోత్సవ కాలంలో ప్రతి వ్యక్తీ తన స్వంత ఆస్తిని తిరిగి పొందాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“నీ పొరుగువానికి మీ భూమిని అమ్మినప్పుడు నీవు అతనికి మోసం చేయవద్దు. మరియు నీవు అతని వద్ద భూమిని కొన్నప్పుడు అతడ్ని నిన్ను మోసం చేయనీయకు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","నీ పొరుగువాని భూమిని నీవు కొనాలనుకొన్నప్పుడు, గడచిన బూరధ్వని చేసే మహోత్సవ కాలంనుండి ఎన్ని సంవత్సరాలు అయిందో లెక్కచూచి, దాన్ని బట్టి ధర నిర్ణయం చేయాలి. ఒకవేళ నీవు భూమి అమ్మితే, పంటలు కోసిన సంవత్సరాలు లెక్కించి, ఆ లెక్క ప్రకారం ధర నిర్ణయించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","చాలా సంవత్సరాలు ఉంటే, ఖరీదు ఎక్కువ ఉంటుంది. సంవత్సరాలు తక్కువ ఉంటే ఖరీదు తగ్గించాలి. ఎందుచేతనంటే నీ పొరుగువాడు నిజానికి కొన్ని పంటలు మాత్రమే నీకు అమ్ముతున్నాడు. వచ్చే ఉత్సవంలో ఆ భూమి తిరిగి అతని కుటుంబ పరం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","మీరు ఒకరికి ఒకరు మోసం చేయకూడదు. మీ దేవుణ్ణి మీరు ఘనపర్చాలి. నేను యెహోవాను మీ దేవుణ్ణి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“నా ఆజ్ఞలు, నియమాలు జ్ఞాపకం ఉంచుకోండి వాటికి విధేయులుగా ఉండండి. అప్పుడు మీరు మీ దేశంలో క్షేమంగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","మరియు భూమి మీకు మంచి పంటను ఇస్తుంది. అప్పుడు మీకు ఆహారం సమృద్ధిగా ఉంటుంది. మీరు దేశంలో క్షేమంగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","“కానీ ఒకవేళ మీరు, ‘మేము విత్తనాలు చల్లి, పంట కూర్చుకొనకపోతే ఏడో సంవత్సరం తినేందుకు మాకు ఏమీ ఉండదు అనవచ్చు.’ ");
INSERT INTO tel2010_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","చింతపడకండి. ఆరవ సంవత్సరంలో నా ఆశీర్వాదాలు మీకు లభించేటట్టుగా నేను ఆజ్ఞాపిస్తాను. భూమి మూడు సంవత్సరాల పాటు పంట ఇస్తూనే ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ఎనిమిదో సంవత్సరంలో మీరు నాట్లు వేసినప్పుడు, మీరు యింకా పాత పంటనే తింటూ ఉంటారు. ఎనిమిదో సంవత్సరంలో మీరు నాటిన పంట చేతికి అందేవరకు, అంటే తొమ్మిదో సంవత్సరం వరకు పాత పంటనే తింటూ ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“వాస్తవానికి భూమి నాది. అందుచేత మీరు దాన్ని శాశ్వతంగా అమ్మజాలరు. మీరు కేవలం నాతో, నా భూమి మీద నివసిస్తున్న యాత్రికులు, విదేశీయులు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","మనుష్యులు వారి భూమిని అమ్మివేయ వచ్చును కానీ ఎల్లప్పుడూ ఆ భూమి తిరిగి ఆ కుటుంబా నిదే అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","మీ దేశంలో ఒక వ్యక్తి చాల నిరుపేద కావచ్చును. అతడు తన ఆస్తి అమ్ముకోవాల్సినంత పేదవాడై పోవచ్చును. కనుక అతని రక్తసంబంధీకులు వచ్చి తమ బంధువుకోసం ఆ ఆస్తిని కొనాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","తన భూమిని తిరిగి తనకోసం కొనేందుకు ఒకనికి రక్తసంబంధి ఎవరూ లేక పోవచ్చును. అయితే తన భూమిని తనకోసం కొనేందుకు కావలసినంత డబ్బు సంపాదించవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","అప్పుడు అతడు భూమి అమ్మివేసి ఎన్ని సంవత్సరాలు అయిందో లెక్క పెట్టాలి. ఆ లెక్కను ఉపయోగించి ఆ భూమి ధర నిర్ణయం చేయాలి. అప్పుడు అతడు ఆ భూమిని తిరిగి కొనుక్కోవాలి. ఆ భూమి మరల అతని ఆస్తి అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","అయితే ఈ వ్యక్తి ఆ భూమిని తిరిగి తనకోసం కొనేందుకు సరిపడినంత డబ్బు అతని వద్ద లేకపోతే, అతడు అమ్మి వేసిన భూమి, వచ్చే బూరధ్వని చేసే మహోత్సవకాలం వరకు దానిని కొన్న వారి స్వాధీనంలోనే ఉంటుంది. అప్పుడు బూరధ్వని చేసే మహోత్సవ సమయంలో ఆ భూమి దాని మొదటి స్వంతదారుల పరం అవుతుంది. కనుక ఆ ఆస్తి తిరిగి దాని అసలైన కుటుంబానికి చెందుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ప్రాకారంగల పట్టణంలో ఒకడు తన ఇల్లు అమ్మినట్టయితే, ఆ తర్వాత ఒక పూర్తి సంవత్సరం పాటు ఆ ఇల్లును తిరిగి పొందే హక్కు ఆ వ్యక్తికి ఉంటుంది. ఇంటిని తిరిగి పొందే హక్కు ఒక సంవత్సరంవరకు కొనసాగుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","అయితే ఒక సంవత్సరం పూర్తయ్యేలోపల ఆ ఇంటి స్వంతదారుడు కొనక పోయినట్టయితే, అప్పుడు ప్రాకారంగల పట్టణంలోని ఆ ఇల్లు, దానిని కొన్నవానికి, అతని సంతానానికి స్వంతం అవుతుంది. బూరధ్యని చేసే మహోత్సవ సమయంలో ఆ యిల్లు తిరిగి దాని ప్రథమ స్వంత దారుని వశం కాదు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","ప్రాకారాలు లేని పట్టణాలు బహిరంగ పొలాల్లో గుర్తించ బడుతాయి. కనుక అలాంటి పట్టణాల్లో నిర్మించబడిన ఇళ్లు బూరధ్వని చేసే మహోత్సవ సమయంలో తిరిగి వాటి ప్రథమ స్వంత దారులపరం అవుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“అయితే లేవీయుల పట్టణాల విషయం. లేవీయులు వారికి చెందిన పట్టణాల్లోని వారి ఇళ్లను ఎప్పుడైనా సరే తిరిగి కొనవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ఒక వ్యక్తి ఒక లేవీయుని దగ్గర ఒక ఇల్లు కొంటే, లేవీయుల పట్టణంలోని ఆ ఇల్లు బూరధ్వని చేసే మహోత్సవ కాలంలో తిరిగి లేవీయులకే చెందుతుంది. ఎందుచేతనంటే లేవీయుల పట్టణాలు లేవీ వంశపు ప్రజలకు చెందినవి. ఆ పట్టణాలను ఇశ్రాయేలు ప్రజలే లేవీయులకు ఇచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","అలానే, లేవీయుల పట్టణాల చుట్టు ప్రక్కల పొలాలు, పచ్చికబయళ్లు అమ్మేందుకు వీల్లేదు. ఆ పొలాలు శాశ్వతంగా లేవీయులకే చెందుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ఒకవేళ మీ దేశ ప్రజల్లో ఒకడు పోషణ సాగనంత పేదరికంలో పడవచ్చు. మీరు అతణ్ణి అతిథిలా మీతో జీవింపనియ్యాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","మీరు అతనికి అప్పుగా యిచ్చే మొత్తంమీద వడ్డీ కట్టవద్దు. ఆ సోదరుణ్ణి నీతో నివసింపనిచ్చి, నీ దేవుణ్ణి ఘనపరచు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","అతనికి వడ్డీకి అప్పు ఇవ్వవద్దు. అతడు భోజనం చేసే ఆహారం మీద లాభాలు గడించేందుకు ప్రయత్నించవద్దు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","నేను మీ దేవుడైన యోహోవాను. కనాను దేశాన్ని మీకు ఇచ్చి, మీకు దేవుణ్ణిగా ఉండేందుకు నేనే మిమ్మల్ని ఈజిప్టు దేశంనుండి బయటకు తీసుకునివచ్చాను. ");
INSERT INTO tel2010_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ఒకవేళ నీ సోదరుల్లో ఒకడు మరీ దరిద్రుడై, నీకు బానిసగా అమ్ముడుపోవచ్చును. నీవు అతణ్ణి ఒక బానిసలా పని చేయించకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","అతడు ఒక కిరాయి పనివానిలా, అతిధిలా బూరధ్వని చేసే మహోత్సవ కాలం వరకు నీతో ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","తర్వాత అతడు నిన్ను విడిచి పెట్టవచ్చును. అతడు తన పిల్లలను తీసుకొని తిరిగి తన కుటుంబంలోనికి వెళ్ళిపోవచ్చును. అతడు తన పూర్వీకుల ఆస్తులను తిరిగి పొందవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","ఎందుచేతనంటే, వాళ్లు నా సేవకులు, ఈజిప్టు బానిసత్వంలో నుండి నేను వాళ్లను తీసుకొనివచ్చాను. వాళ్లు మరల బానిసలు కాకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ఇలాంటి వ్యక్తిని నీవు కఠినంగా పాలించగూడదు. నీ దేవుణ్ణి నీవు ఘనపర్చాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“నీ స్త్రీ, పురుష బానిసల విషయం: మీ చుట్టు పక్కల దేశాలనుండి ఆడ, మగ బానిసలను మీరు తెచ్చుకోవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","మరియు, మీ దేశంలో నివసిస్తున్న విదేశీయుల పిల్లలు వస్తానంటే వారిని కూడ మీరు బానిసలుగా తీసుకోవచ్చును. ఆ పిల్ల బానిసలు మీకు చెందుతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","ఈ విదేశీ బానిసలు మీ పిల్లల వశం అయ్యేటట్టు, మీ మరణానంతరం మీరు వారిని మీ పిల్లలకు అప్పగించవచ్చును. వాళ్లు శాశ్వతంగా మీకు బానిసలు. ఈ విదేశీయుల్ని మీరు బానిసలుగా చేసుకోవచ్చును. కానీ మీ స్వంత సోదరులైన ఇశ్రాయేలు ప్రజలను మాత్రం కఠినంగా పాలించగూడదు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ఒకవేళ ఒక విదేశీయుడు లేక అతిథి మీ మధ్యధనికుడు కావచ్చు, ఒకవేళ మీ దేశంలో ఒకడు దరిద్రుడై మీ మధ్య నివసిస్తున్న ఒక విదేశీయునికి బానిసగా లేక అతని కుటుంబంలో సభ్యునిగా అమ్ముడు పోయాడనుకోండి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ఆ వ్యక్తి తిరిగి కొనబడి, స్వంతంత్రుడు అయ్యేందుకు అతనికి హక్కు ఉంటుంది. అతని సోదరుల్లో ఒకరు అతణ్ణి తిరిగి కొనవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","అతని పినతండ్రిగాని, పిన తండ్రి కుమారుడు గాని అతణ్ణి కొనవచ్చును. లేక అతని వంశంలో అతని రక్తసంబంధి ఎవరైనా అతణ్ణి కొనవచ్చును. లేక ఒకవేళ ఆ వ్యక్తి తానే సరిపడినంత ధనం సంపాయించు కొంటే, తానే డబ్బు చెల్లించి మరల స్వతంత్రుడు కావచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","“వెల మీరెలా నిర్ణయిస్తారు? అతడు విదేశీయునికి తనను తాను అమ్ముకొన్న సమయంనుండి వచ్చే బూరధ్వని చేసే మహోత్సవ కాలంవరకు ఎన్ని సంవత్సరాలో మీరు లెక్కగట్టాలి. వెల నిర్ణయం చేయటానికి ఆ లెక్కను ఉపయోగించాలి. ఎందుచేతనంటే అవతలి వ్యక్తి యితణ్ణి వాస్తవానికి కొన్ని సంవత్సరాలకోసమే ‘కిరాయికి’ పెట్టుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","బూరధ్వని చేసే మహోత్సవ కాలానికి ఇంకా చాల సంవత్సరాలు కావాల్సిఉంటే, ఆ వ్యక్తి వెలలో అధిక భాగం తిరిగి చెల్లించాలి. అదంతా సంవత్సరాల సంఖ్యమీద ఆధారపడి ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ఉత్సవ సంవత్సరానికి మరికొన్ని యేండ్లు మాత్రమే మిగిలి ఉంటే, అప్పుడు ఆ వ్యక్తి అసలు వెలలో కొద్ది మాత్రమే చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","అయితే ఆ వ్యక్తి కిరాయి పని వాడిలాగానే ఆ విదేశీయుని దగ్గర ప్రతి సంవత్సరం నివసిస్తాడు. ఆ విదేశీయుడు ఆ వ్యక్తి మీద కఠినంగా ప్రవర్తించకుండును గాక. ");
INSERT INTO tel2010_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ఆ వ్యక్తిని ఎవకూ కొనకపోయినప్పటికి, అతడు స్వతంత్రుడు అవుతాడు. బూరధ్వని చేసే మహోత్సవ కాలంలో అతడు, అతని పిల్లలు స్వతంత్రులవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","ఎందుచేతనంటే, ఇశ్రాయేలు ప్రజలు నా సేవకులు. వాళ్లు నా సేవకులు. ఈజిప్టు బానిసత్వం నుండి నేను వాళ్లను తీసుకొని వచ్చాను. నేను మీ దేవుడైన యెహోవాను! ");
INSERT INTO tel2010_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“మీకోసం మీరు విగ్రహాల్ని చేసుకోవద్దు. విగ్రహాల్ని, జ్ఞాపక చిహ్నాల్ని నిలబెట్టవద్దు. మీరు మొక్కేందుకు మీ దేశంలో రాతి విగ్రహాలను నిలబెట్టవద్దు. ఎందుచేతనంటే, నేను మీ దేవుణ్ణి, యెహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“నా ప్రత్యేక విశ్రాంతి రోజుల్ని జ్ఞాపకం ఉంచు కొని, నా పవిత్ర స్థలాన్ని గౌరవించండి. నేను యోహోవాను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“నా ఆజ్ఞలు, నియమాలు జ్ఞాపకం ఉంచుకోండి. వాటికి విధేయులు అవ్వండి. ");
INSERT INTO tel2010_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","వాటిని మీరు జరిగిస్తే, నేను మీకు సకాలంలో వర్షాలు కురిపిస్తాను. భూమి పంటను యిస్తుంది, పొలంలో చెట్లు వాటి ఫలాలను ఇస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ద్రాక్షాపండ్ల కోతకాలం వచ్చేంతవరకు మీరు గానుగ పట్టడం కొనసాగుతుంది వరు మళ్ళ మొక్కలు నాటడం మొదలు పెట్టేంతవరకు మీరు ద్రాక్షాపండ్లు కూర్చుకోవటం కొనసాగుతుంది. అప్పుడు మీరు తినేందుకు సమృద్ధిగా ఉంటుంది. మరియు మీరు మీ దేశంలో క్షేమంగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","నేను మీ దేశానికి శాంతిని ప్రసాదిస్తున్నాను. మీరు ప్రశాంతంగా పండుకొంటారు. ఎవరూ మిమ్మల్ని భయపెట్టేందుకు రారు. హానికరమైన జంతువులను నేను మీ దేశానికి దూరంగా ఉంచుతాను. మరియు సైన్యాలు మీ దేశం గుండా వెళ్లజాలవు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","“మీరు మీ శత్రువులను తరిమి, వారిని ఓడిస్తారు. మీరు మీ ఖడ్గంతో వారిని చంపుతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","మీలో అయిదుగురు 100 మందిని తరుముతారు, మీలో 100 మంది 10,000 మందిని తరుముతారు. మీరు మీ శత్రువులను ఓడించి, మీ ఖడ్గంతో వారిని చంపేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“అప్పుడు నేను మీ వైపు తిరుగుతాను. మీకు అధికంగా సంతానం కలుగనిస్తాను. మీతో నా ఒడంబడికను నేను నిలబెడతాను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","ఒక సంవత్సరం కంటె ఎక్కువ కాలానికి సరిపోయేంత పంట మీకు ఉంటుంది. మీరు కొత్త పంట కోసుకొంటారు. అయితే కొత్త పంట నిల్వ చేయటానికి స్థలం కావాలి గనుక పాత పంటను పారవేయాల్సి ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","నేను నా పవిత్ర గుడారాన్ని కూడ మీ మధ్య ఉంచుతాను. మీనుండి నేను తిరిగిపోను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","నేను మీతో నడుస్తాను, మీ దేవునిగా ఉంటాను. మీరు నా ప్రజలుగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","నేను యోహోవాను, మీ దేవుణ్ణి. మీరు ఆ ఈజిప్టులో బానిసలుగా ఉన్నారుగాని నేను మిమ్మల్ని ఈజిప్టునుండి బయటకు తీసుకొని వచ్చాను. బానిసలుగా భారమైన బరువులు మోసి మీరు చాలా వంగిపోయారు. అయితే మీ భుజాలమీద కాడిని నేను విరుగగొట్టేసాను. నేను మిమ్మల్ని మరల తల ఎత్తుకొని తిరిగేటట్టు చేస్తాను! ");
INSERT INTO tel2010_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“అయితే మీరు నాకు విధేయులు కాకుండా, నా ఆజ్ఞలన్నింటినీ పాటించకుండా ఉంటే, అప్పుడు మీకు ఈ కీడులన్నీ జరుగుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","నా ఆజ్ఞలు, నియమాలు పాటించడానికి మీరు నిరాకరిస్తే, మీరు నా ఒడంబడికను ఉల్లంఘించినట్టే. ");
INSERT INTO tel2010_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","మీరు గనుక అలా చేస్తే అప్పుడు భయంకరమైన సంగతుల్ని మీకు సంభవింపజేస్తాను. నేను మీకు రోగం, జ్వరం వచ్చేటట్టు చేస్తాను. అవి మీ కళ్లను పాడుచేసి, మీ ప్రాణాల్ని తీస్తాయి. మీరు విత్తనాలు జల్లినప్పుడు ఫలితం ఉండదు. మీ శత్రువులు మీ పంటను తినివేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","నేను మీకు విరోధంగా ఉంటాను గనుక మీ శత్రువులు మిమ్మల్ని ఓడిస్తారు. ఆ శత్రువులు మిమ్మల్ని ద్వేషించి, మీ మీద అధికారం చేస్తారు. ఎవరూ మిమ్మల్ని తరమకుండానే మీరు పారిపోతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ఇవన్నీ జరిగినా మీరు నాకు విధేయులు కాకపోతే, మీ పాపాలకోసం నేను మిమ్మల్ని ఏడంతలుగా శిక్షిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","మీకు అతిశయ కారణమైన మీ గొప్ప పట్టణాలను నేను కూలగొట్టేస్తాను. ఆకాశంవర్షాన్ని ఇవ్వదు, భూమి పంటనివ్వదు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","మీరు కష్టపడి పనిచేస్తారు, కాని దానివల్ల ప్రయోజనం ఉండదు. మీ భూమి పంటలేమీ ఇవ్వదు, మీ చెట్లు వాటి ఫలాలను ఇవ్వవు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“మీరు ఇంకా నాకు వ్యతిరేకంగా తిరిగి, నాకు విధేయులయ్యేందుకు తిరస్కరిస్తే, అప్పుడు ఇంకా ఏడు రెట్లు కఠినంగా నేను మిమ్మల్ని కొడతాను. మీరు ఎక్కువ పాపం చేసినకొద్దీ, మరింత ఎక్కువగా శిక్షించబడతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","నేను మీ మీదికి అడవి మృగాలను పంపిస్తాను. అవి మీ పిల్లలను మీ దగ్గరనుండి లాక్కొనిపోతాయి. అవి మీ పశువుల్ని నాశనం చేస్తాయి. అవి మీ సంఖ్యను క్షీణింప చేస్తాయి. రహదారులు ఖాళీగా ఉంటాయి గనుక ప్రయాణం చేయటానికి ప్రజలు భయపడతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“అన్ని జరిగినా మీరు పాఠం నేర్చుకోకపోతే, ఇంకా అప్పటికీ నాకు మీరు విరుద్ధంగా తిరిగితే, ");
INSERT INTO tel2010_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","అప్పుడు నేను కూడా మీకు విరుద్ధంగా తిరుగుతాను. నేను, అవును నేనే, మీ పాపాలకోసం ఏడుసార్లు మిమ్మల్ని శిక్షిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","మీరు నా ఒడంబడికను ఉల్లంఘించారు కనుక నేను మిమ్మల్ని శిక్షిస్తాను. సైన్యాలను నేను మీమీదికి రప్పిస్తాను. భద్రతకోసం మీరు మీ పట్టణాల్లోకి పారిపోతారు. కాని నేను మీ మధ్య వ్యాధుల్ని వ్యాపింప జేస్తాను. అప్పుడు మీ శత్రువు మిమ్మల్ని ఓడించేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ఆ పట్టణంలో మిగిలిపోయిన ధాన్యంలో కొంత భాగం నేను మీకు ఇస్తాను. కానీ తినేందుకు బహుకొంచెం మాత్రమే ఆహారం ఉంటుంది. వారి భోజనాన్ని అంతా ఒక్క పాత్రలో పదిమంది ఆడవాళ్లు వండగలుగుతారు. ఆ భోజనం ముద్దలు ఒక్కొక్కదాన్ని వారు లెక్కబెట్టగలుగుతారు. మీరు తింటారు గాని మీ ఆకలి తీరదు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“మీరు ఇంకా నా మాట వినకపోతే, ఇంకా నాకు విరోధంగా ఉంటే ");
INSERT INTO tel2010_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","అప్పుడు నేను నిజంగా నా కోపం చూపిస్తాను. నేను, అవును నేనే, మీ పాపాలకోసం ఏడుసార్లు మిమ్మల్ని శిక్షిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","మీ కుమారులు, కుమార్తెల శరీరాల్ని మీరు తింటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","మీ ఉన్నత స్థలాలను నేను నాశనం చేస్తాను. మీ ధూప వేధికలను నేను పడగొట్టేస్తాను. మీ శవాలను మీ విగ్రహాల శవాల మీద నేను పడవేస్తాను. మీరు నాకు చాలా అసహ్యంగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","మీ పట్టణాలను నేను నాశనం చేస్తాను. మీ పరిశుద్ధ స్థలాన్ని నేను శూన్యం చేస్తాను. మీ అర్పణల సువాసన నేను ఆఘ్రాణించను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","మీ పట్టణాల్లో నివసించేందుకు వచ్చే మీ శత్రువులు చూచి అదిరి పోయేంతగా మీ దేశాన్ని నేను ఖాళీ చేస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ఇంకా నేను మిమ్మల్ని రాజ్యాల్లో చెదరగొట్టేస్తాను. నేను నా ఖడ్గం దూసి, మిమ్మల్ని నాశనం చేస్తాను. మీ దేశం శూన్యంగాను, మీ పట్టణాలు చెత్తగాను ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","“మిమ్మల్ని మీ శత్రువులు తమ దేశానికి తీసుకొని పోతారు. మీ దేశం ఖాళీ అయిపోతుంది. అందుచేత మీ భూమికి చివరికి విశ్రాంతి లభిస్తుంది. భూమి దాని విశ్రాంతిని అనుభవిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ఏడేండ్లకు ఒకసారి ఒక సంవత్సరం పాటు భూమికి విశ్రాంతి ఉండాలని ఆజ్ఞ ప్రబోధిస్తుంది. మీరు దానిలో నివసించినప్పుడు దానికి మీరు ఇవ్వని విశ్రాంతిని, భూమి ఖాళీగా ఉన్న ఆ సమయంలో అది పొందుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","శేషించిన ప్రజలు వారి శత్రు దేశంలో ధైర్యం కోల్పోతారు. ప్రతిదానికీ వారు భయపడిపోతారు. గాలికి కొట్టుకొని పోయే ఆకులా వారు అటుఇటు పరుగులెత్తుతారు. ఎవరో వారిని కత్తితో తరుముతున్నట్టు వారు పరుగులెడతారు. వారిని ఎవరూ తరమక ముందే వారు పడిపోతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ఎవరో వారిని కత్తితో తరుముతున్నట్టుగా వారు పరుగులెడతారు. వారిని ఎవరూ తరమకుండానే వారు ఒకరిమీద ఒకరు కూలిపోతారు. “మీరు మీ శత్రువులను ఎదిరించి నిలిచే అంతటి బలం మీకు ఉండదు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","ఇతర దేశాల్లో తప్పిపోతారు. మీ శత్రుదేశాల్లోనికి మీరు అదృశ్యమవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","కనుక మిగిలిన వాళ్లు వారి పాపంవలన వారి శత్రుదేశంలో క్షీణించిపోయెదరు. వారు కూడా వారి పూర్వీకులవలెనే, వారి పాపంవలన క్షీణించిపోయెదరు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“అయితే ఒకవేళ ప్రజలు వారి పాపాలు ఒప్పుకొంటారేమో. వారు, వారి పూర్వీకుల పాపాలు ఒప్పు కొంటారేమో. ఒకవేళ వారు నాకు విరోధంగా తిరిగినట్టు ఒప్పుకోవచ్చు. ఒకవేళ వారు నాకు విరోధంగా పాపం చేసినట్టు ఒప్పుకోవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ఒకవేళ నేను వారికి విరోధంగా తిరిగి వారి శత్రుదేశంలోనికి నేనే వాళ్ళను తీసుకొని పోయినట్టు వారు ఒప్పుకోవచ్చు. ఆ ప్రజలు నన్ను ఎరుగని వాళ్లలా ప్రవర్తించారు. వాళ్లు తగ్గించు కొని, వారి పాపపు శిక్షను స్వీకరిస్తే ");
INSERT INTO tel2010_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","అప్పుడు యాకోబుతో నా ఒడంబడికను నేను జ్ఞాపకం చేసుకొంటాను. ఇస్సాకుతో నా ఒడంబడికను నేను జ్ఞాపకం చేసుకొంటాను. అబ్రాహాముతో నా ఒడంబడికను నేను జ్ఞాపకం చేసుకొంటాను. ఈ దేశాన్ని నేను జ్ఞాపకం చేసుకొంటాను. ");
INSERT INTO tel2010_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","“ఈ దేశం ఖాళీ అవుతుంది. భూమి దాని విశ్రాంతి సమయాన్ని అనుభవిస్తుంది. అప్పుడు మిలిగిన వాళ్లు వారి పాపపు శిక్షను అంగీకరిస్తారు. వారు నా ఆజ్ఞలను ద్వేషించి, నా నియమాలను విధేయులయ్యేందుకు నిరాకరించినందువల్లే వారు శిక్ష పొందినట్టు వారు గ్రహిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","వాస్తవంగా వారు పాపం చేసారు. అయితే సహాయంకోసం వారు నా దగ్గరకు వస్తే, నేను వారినుండి తిరిగిపోను. వారు వారి శత్రువుల దేశంలో ఉన్నప్పుటికీ నేను వారి మొర అలకిస్తాను. నేను వారిని పూర్తిగా నాశనం చెయ్యను. వారితో నా ఒడంబడికను తెగతెంపులు చేయను. నేను యెహోవాను, వారి దేవుణ్ణి. ");
INSERT INTO tel2010_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","వారి పూర్వీకులతో నాకుగల ఒడంబడికను నేను జ్ఞాపకం చేసుకొంటాను. నేను వారికి దేవునిగా ఉండేందుకు నేను వారి పూర్వీకుల్ని ఈజిప్టు నుండి బయటకు రప్పించాను. ఇతర రాజ్యాలు వాటన్నింటినీ చూసాయి. నేను యెహోవాను!” ");
INSERT INTO tel2010_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","అవి యెహోవా ఇశ్రాయేలు ప్రజలకు యిచ్చిన చట్టాలు, నియమాలు, ప్రబోధాలు. యెహోవాకు, ఇశ్రాయేలు ప్రజలకు మధ్య ఆ ఆజ్ఞలే ఒక ఒడంబడిక. సీనాయి పర్వతం దగ్గర ఆ ఆజ్ఞలను యెహోవా ఇచ్చాడు. ఆయన వాటిని మోషేకు ఇవ్వగా, మోషే వాటిని ప్రజలకు యిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","యెహోవా మోషేతో చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“ఇశ్రాయేలు ప్రజలతో చెప్పు: ఒకవ్యక్తి యెహోవాకు ఒక ప్రత్యేక వాగ్దానం చేయవచ్చు. ఆ వ్యక్తి ఒక మనిషిని యెహోవాకు అర్పిస్తానని వాగ్దానం చేసి ఉండొచ్చు. అలాగైతే ఆ మనిషి ఒక ప్రత్యేక విధానంలో యెహోవాను సేవించాలి. ఆ మనిషికి యాజకుడు కొంత విలువ నిర్ణయించాలి. ప్రజలు ఆ మనిషిని యెహోవా దగ్గర తిరిగి కొనాలంటే వారు ఆ విలువ చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ఇరవై నుండి అరవై సంవత్సరాల వయసుగల ఒక మగవాడి విలువ యాభై తులాల వెండి. (వెండిని తూచేందుకు పవిత్ర స్థలంలోని అధికారిక కొలతనే మీరు ఉపయోగించాలి). ");
INSERT INTO tel2010_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ఇరవై నుండి అరవై సంవత్సరాల వయస్సుగల ఒక స్త్రీ విలువ ముప్పైతులాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ఐదు నుండి ఇరవై సంవత్సరాల వయస్సుగల ఒక మగవాని విలువ ఇరవైతులాలు. ఐదు నుండి ఇరవై సంవత్సరాల వయస్సుగల ఒక స్త్రీ విలువ పది తులాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ఒక నెలనుండి ఐదు సంవత్సరాల వయస్సుగల ఒక మగ శిశువు వెల ఐదు తులాలు. ఆడ శిశువు వెల మూడు తులాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","అరవై సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉన్న ఒక మగవాని వెల పదిహేను తులాలు. ఒక స్త్రీ వెల పది తులాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","“ఒక మనిషి ఆ వెల చెల్లించలేనంత పేదవాడైతే ఆ వ్యక్తిని యాజకుని దగ్గరకు తీసుకొని రావాలి. ఆ వ్యక్తి ఎంత మొత్తం చెల్లించగలడు అనే విషయం యాజకుడు తీర్మానిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“కొన్ని జంతువులు యెహోవాకు బలిగా ఉపయోగపడతాయి. అలాంటి ఒక జంతువును ఒక వ్యక్తి తీసుకొని వస్తే, ఆ జంతువు పవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ఆ వ్యక్తి ఆ జంతువునే యోహోవాకు ఇస్తానని వాగ్దానం చేసాడు గనుక దానికి బదులు ఇంకోదాన్ని యివ్వటానికి అతడు ప్రయత్నించకూడదు. ఇంకో దానితో దీన్ని మార్చేందుకు అతడు ప్రయత్నించకూడదు. మంచి జంతువుకు బదులుగా పనికిరాని జంతువును మార్చాలని అతడు ప్రయత్నించకూడదు. పనికిరాని జంతువుకు బదులుగా మంచి జంతువును మార్చాలనీ అతడు ప్రయత్నించకూడదు. ఆ మనిషి అలా జంతువుల్ని మార్చటానికి ప్రయత్నిస్తే, అప్పుడు ఆ జంతువులు రెండూ పవిత్రం అవుతాయి. అందుచేత అవి రెండూ యెహోవాకే చెందుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","“కొన్ని జంతువులు యెహోవాకు అర్పించేందుకు పనికిరావు. అలాంటి అపవిత్ర జంతువును ఒకదాన్ని ఒకడు యోహోవాకు యిచ్చేందుకు తీసుకొనివస్తే, అప్పుడు ఆ జంతువును యాజకుని దగ్గరకు తీసుకొనిరావాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","యాజకుడు ఆ జంతువుకు విలువ నిర్ణయం చేస్తాడు. యాజకుడు వెల నిర్ణయం చేసిన తర్వాత ఆ జంతువు మంచిదేగాని పనికిరానిదేగాని, దాని వెల అంతే. ");
INSERT INTO tel2010_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ఒక వేళ ఆ వ్యక్తి తిరిగి జంతువును కొనుక్కోవాలనుకొంటే, అతడు దాని వెలకు అయిదో వంతు అదనంగా చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ఇప్పుడు ఒక వ్యక్తి తన ఇంటిని యెహోవాకు పవిత్రంగా ప్రతిష్ఠ చేస్తే, యాజకుడు దాని వెల నిర్ణయం చేయాలి. యాజకుడు అలా వెల నిర్ణయిస్తే ఆ ఇల్లు మంచిదేగాని, పనికి రానిదేగాని ఆ వెల అంతే. ");
INSERT INTO tel2010_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","అయితే ఆ ఇంటిని ఇచ్చిన వ్యక్తి తిరిగి దానిని తీసుకొనగోరితే, దాని విలువకు అయిదోవంతు అదనంగా చెల్లించాలి. అప్పుడు ఆ ఇల్లు ఆ వ్యక్తికి చెందుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ఒక వ్యక్తి తన పొలాల్లో కొంత భాగం యెహోవాకు ప్రతిష్ఠ చేస్తే, దానిలో నాటేందుకు ఎంత విత్తనం అవసరం ఉంటుందో అనేదానిమీద ఆ పొలాల వెల ఆధారపడి ఉంటుంది. పది తూముల యవల విత్తనాల వెల ఏబై తులాల వెండితో సమానము ");
INSERT INTO tel2010_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ఒకవేళ బూరధ్వని చేసే మహోత్సవ కాలంలో ఆ వ్యక్తి తన పొలాన్ని కానుకగా యిస్తే, యాజకుడు నిర్ణయించేదేదాని వెల అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","కానీ ఆ వ్యక్తి బూరధ్వని మహోత్సన కాలం దాటిపోయాక తన పొలాన్ని కానుకగా యిస్తే, దాని ఖచ్చితమైన వెలను యాజకుడు నిర్ణయించాలి. తర్వాత వచ్చే బూరధ్వని మహోత్సవ కాలానికి ఎన్ని సంవత్సరాలు ఉన్నాయో అతడు లెక్కించాలి. అప్పుడు ఆ లెక్క ఆధారంగా వెలకట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ఒకవేళ తన పొలాన్ని కానుకగా యిచ్చిన వ్యక్తి తిరిగి తన పొలాన్ని తీసుకోవాలనుకొంటే, దాని వెలకు అయిదో వంతు అతడు అదనంగా చెల్లించాలి. అప్పుడు ఆ పొలం తిరిగి అతనిదే అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","“ఆ వ్యక్తి ఆ పొలాన్ని తిరిగి కొనకపోతే, అప్పుడు ఆ పొలం ఎల్లప్పుడూ యాజకులకే చెందుతుంది. ఒకవేళ ఆ భూమిని మరొకరికి అమ్మివేస్తే, ఆ మొదటి వ్యక్తి తిరిగి ఆ పొలం కొనేందుకు వీల్లేదు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ఒకవేళ ఆ వ్యక్తి గనుక ఆ పొలాన్ని మళ్లీ కొనకపొతే, బూరధ్వని చేసే మహోత్సవ కాలంలో ఆ భూమి యోహోవాకు పవిత్రంగా ఉండిపోతుంది. అది శాశ్వతంగా యాజకునిదే అవుతుంది. అది సంపూర్ణంగా యెహోవాకు ఇవ్వబడిన భూమిగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ఒకవేళ ఒక వ్యక్తి అతడు కొన్న పొలాన్ని యోహోవాకు ప్రతిష్ఠస్తే, అది అతని స్వంత పొలంలో ఒక భాగం కానప్పుడు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","యాజకుడు బూరధ్వని చేసే మహోత్సవ కాలంవరకుగల సంవత్సరాలను లెక్కించి, దాని ప్రకారం ఆ పొలం వెల నిర్ణయించాలి. అప్పుడు ఆ భూమి యెహోవాదే అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","బూరధ్వని చేసే మహోత్సవ కాలంలో ఆ భూమి దాని స్వంతదారునిది అవుతుంది. ఆ భూమి ఏ కుటుంబంవారి స్వంతమో తిరిగి వారికే దక్కుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","“ఆ ధరలు చెల్లించేందుకు పవిత్రస్థలంలోని అధికారిక కొల తనే మీరు ఉపయోగించాలి. పవిత్ర స్థలంలో అధికారతులం బరువు 20 చిన్నాలు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“పశువుల్ని, గొర్రెల్ని, ప్రజలు యెహోవాకు కానుకగా ఇవ్వవచ్చును. అయితే ఆ జంతువు తొలిచూలు అయితే అది ముందే యెహోవాది. కనుక తొలిచూలు వాటిని ప్రజలు కానుకగా యివ్వలేరు. ");
INSERT INTO tel2010_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","తొలిచూలు జంతువులను ప్రజలు యెహోవాకు ఇవ్వాలి. అయితే ఆ తొలిచూలు జంతువు అపవిత్రమైనదిగా ఉంటే అప్పుడు ఆ వ్యక్తి తిరిగి దానిని కొనుక్కోవాలి. ఆ జంతువు వెల యాజకుడు నిర్ణయించగా, ఆ వ్యక్తి, దాని వెలకు అయిదోవంతు అదనంగా చెల్లించాలి. ఒకవేళ ఆ వ్యక్తి గనుక ఆ జంతువును తిరిగి కొనలేకపోతే, యాజకుడు తానే నిర్ణయించే వెలకు ఆ జంతువును అమ్మివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ప్రజలు యెహోవాకు ఇచ్చే ఒక ప్రత్యేక రకమైన కానుక ఉంది. ఆ కానుక సంపూర్ణంగా యెహోవాదే అవుతుంది. ఆ కానుకను అమ్మటానికి, తిరిగి కొనడానికి వీల్లేదు. ఆ కానుక యెహోవాకు చెందినది. ప్రజలు, జంతువులు, కుటుంబపు ఆస్తిలోని పొలాలు ఆ కానుక కావచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","ఒకవేళ ఆ ప్రత్యేకమైన కానుక ఒక వ్యక్తి అయివుంటే ఆ వ్యక్తిని తిరిగి కొనేందుకు వీల్లేదు. ఆ వ్యక్తి చంపబడవలసినదే. ");
INSERT INTO tel2010_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“పంటలన్నింటిలో పదోవంతు యెహోవాకు చెందుతుంది. అంటే పొలాల్లోని పంటలు, చెట్ల ఫలాలు అని అర్ధం. ఆ పదోవంతు యెహోవదే అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","కనుక ఎవరైనా తన పదోవంతు తిరిగి తీసుకోవాలి అనుకొంటే. వారు దాని వెలకు అయిదో వంతు అదనంగా చెల్లించి, అప్పుడు దానిని తిరిగి కొనుక్కోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","“ఒక వ్యక్తికిగల పశువులు, గొర్రెలలో నుండి ప్రతి పదో జంతువును యాజకులు తీసుకోవాలి. పదోజంతువు ప్రతీదీ యెహోవాదే అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","కోరుకొన్న ఆ జంతువు మంచిదైనా చెడ్డదైనా, దాని స్వంతదారుడు చింతించవలసిన అవసరం లేదు. అతడు ఆ జంతువును మరో జంతువుతో మార్చకూడదు. అలా మరో జంతువుతో దాన్ని మార్చాలని అతడు నిర్ణయించుకొంటే అప్పుడు ఆ రెండు జంతువులూ యెహోవావే అవుతాయి. ఆ జంతువును తిరిగికొనేందుకు వీల్లేదు.” ");
INSERT INTO tel2010_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","సీనాయి పర్వతం దగ్గర మోషేకు యెహోవా ఆజ్ఞాపించిన ఆజ్ఞలు అవి. అవి ఇశ్రాయేలు ప్రజలకోసమైన ఆజ్ఞలు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","సన్నిధి గుడారంలో మోషేతో యెహోవా ఇలా మాట్లాడాడు. ఇది సీనాయి అరణ్యంలో ఉంది. ఇశ్రాయేలు ప్రజలు ఈజిప్టు విడిచిన రెండవ సంవత్సరం రెండవ నెల మొదటి రోజు అది, మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ఇశ్రాయేలు ప్రజలందరి సంఖ్యను లెక్కించు. ప్రతి పురుషుని పేరు అతని వంశం, కుటుంబంతో పాటు జాబితా చేయి ");
INSERT INTO tel2010_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ఇశ్రాయేలు పురుషులందరినీ, నీవు, అహరోను లెక్కించాలి. 20 సంవత్సరాలు, అంతకు ఎక్కువ వయస్సు ఉన్న వారిని మీరు లెక్కించాలి. (వారు ఇశ్రాయేలు సైన్యంలో ఉండదగిన వాళ్లు.) వారి వంశాల ప్రకారం వారి జాబితా చేయి. ");
INSERT INTO tel2010_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ప్రతి కుటుంబము నుండి ఒక మనిషి మీకు సహాయం చేస్తాడు, ఈ మనిషి తన వంశానికి నాయకుడుగా ఉంటాడు, ");
INSERT INTO tel2010_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","మీతో ఉండి మీకు సహాయం చేసే పురుషుల పేర్లు ఇవి; రూబేను వంశంనుండి-షెదేయూరు కుమారుడు ఎలీసూరు; ");
INSERT INTO tel2010_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","షిమ్యోను వంశంనుండి—సూరీషద్దాయి కుమారుడు షెలుమీయేలు ");
INSERT INTO tel2010_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","యూదా వంశంనుండి అమ్మీనాదాబు కుమారుడు నయస్సోను. ");
INSERT INTO tel2010_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ఇశ్శాఖారు వంశంనుండి సూయారు కుమారుడు నెతనేలు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","జెబూలూను వంశంనుండి హెలోను కుమారుడు ఎలీయాబు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","యోసేపు సంతానమందు ఎఫ్రాయిము వంశంనుండి అమిహూదు కుమారుడు ఎలీషామాయు మనష్షే వంశంనుండి పెదాసూరు కుమారుడు గమలీయేలు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","బెన్యామీను వంశంనుండి గిద్యోనీ కుమారుడు అబీదాను. ");
INSERT INTO tel2010_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","దాను వంశంనుండి అమీషద్దాయి కుమారుడు అహీయెజెరు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ఆషెరు వంశంనుండి ఒక్రాను కుమారుడు పగీయేలు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","గాదు వంశంనుండి దెయూవేలు కుమారుడు ఎలాసాపు; ");
INSERT INTO tel2010_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","నఫ్తాలి వంశంనుండి ఏనాను కుమారుడు అహీర.” ");
INSERT INTO tel2010_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ఈ పురుషులు వారి కుటుంబాలకు నాయకులు, వారి వంశాలకు నాయకులుగా కూడా, ప్రజలు ఈ పురుషులను ఏర్పటు చేసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","18","పేరు పేరునా ఈ పురుషులు ఏర్పరచుకోబడ్డారు. కనుక రెండవ నెల మొదటి రోజున ఈ పురుషులను, ఇశ్రాయేలు ప్రజలందరినీ మోషే అహరోనులు పిలిచారు. అప్పుడు ప్రజలు వారి కుటుంబాల ప్రకారం, వారి వంశాల ప్రకారం జాబితా చేయబడ్డారు. 20 సంవత్సరాలు, అంతకు పై బడిన పురుషులు అంతా జాబితాలో ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","సరిగ్గా యెహోవా ఆజ్ఞాపించినట్లే మోషే చేసాడు. ప్రజలు సీనా అరణ్యంలో ఉన్నప్పుడే మోషే వారిని లెక్కించాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ఇశ్రాయేలు జ్యేష్ఠకుమారుడు రూబేను యొక్క సంతతి లెక్కించబడింది. 20 సంవత్సరాలు లేక అంతకు ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగలిగిన పురుషులందరి పేర్లు వ్రాయబడ్డాయి. వారు వారి కుటుంబాలు, వంశాలతో కూడ జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","రూబేను సంతతినుండి లెక్కించబడిన పురుషుల సంఖ్య మొత్తం 46,500. ");
INSERT INTO tel2010_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","షిమ్యోను సంతతి లెక్కించబడ్డారు. 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారు, వారి కుటుంబాలు, వంశాలతో బాటు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","షిమ్యోను సంతతినుండి లెక్కించబడిన పురుషులు మొత్తం 59,300. ");
INSERT INTO tel2010_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","గాదు సంతతి లెక్కించబడింది. 20 సంవత్సరాలు అంతకంటె, ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారి కుటుంబాలు, వంశాలతో బాటు వారు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","గాదు సంతతి నుండి లెక్కించబడిన పురుషులు మొత్తం 45,650. ");
INSERT INTO tel2010_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","యూదా సంతతి లెక్కించబడింది. 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగలిగిన పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారు, వారి కుటుంబాలు, వంశాలతో బాటు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","యూదా సంతతి నుండి లెక్కించబడ్డ పురుషులు మొత్తం 74,600. ");
INSERT INTO tel2010_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ఇశ్శాఖారు సంతతి లెక్కించబడింది. 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు కలిగి ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారు, వారి కుటుంబాలు, వంశాలతో బాటు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ఇశ్శాఖారు సంతతిలో లెక్కించబడిన పురుషులు మొత్తం 54,400. ");
INSERT INTO tel2010_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","జెబులూను సంతతి లెక్కించబడింది. 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారు వారి కుటుంబాలు, వంశాలతోబాటు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","జెబులూను సంతతిలో లెక్కించబడిన పురుషులు మొత్తం 57,400. ");
INSERT INTO tel2010_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","యోసేపు కుమారుడైన ఎఫ్రాయిము సంతతి లెక్కించబడింది. 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారు వారి కుటుంబాలు, వంశాలతో బాటు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ఎఫ్రాయిము సంతతిలో లెక్కించబడిన పురుషులు మొత్తం 40,500. ");
INSERT INTO tel2010_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","యోసేపు కుమారుడైన మనష్షే సంతతి లెక్కించబడింది. 20 సంవత్సరాలు అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారి కుటుంబాలు, వంశాలతోబాటు వారు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","మనష్షే సంతతినుండి లెక్కించబడిన పురుషులు మొత్తం 32,200. ");
INSERT INTO tel2010_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","బెన్యామీను సంతతి లెక్కించబడింది, 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారి కుటుంబాలు, వంశాలతో బాటు వారు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","బెన్యామీను సంతతితో లెక్కించబడిన పురుషులు మొత్తం 35,400. ");
INSERT INTO tel2010_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","దాను సంతతి లెక్కించబడింది. 20 సంవ త్సరాలు అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారి కుటుంబాలు, వంశాలతోబాటు వారు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","దాను సంతతిలో లెక్కించబడిన పురుషులు మొత్తం 62,700. ");
INSERT INTO tel2010_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ఆషేరు సంతతి లెక్కించబడింది. 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారి కుటుంబాలు, వంశాలతో బాటు వారు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ఆషేరు సంతతిలో లెక్కించబడిన పురుషులు మొత్తం 41,500. ");
INSERT INTO tel2010_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","నఫ్తాలి సంతతి లెక్కించబడింది. 20 సంవత్సరాలు అంతకంటె ఎక్కువ వయస్సు ఉండి, యుద్ధంలో పని చేయగల పురుషులందరి పేర్లు జాబితాలో చేర్చబడ్డాయి. వారి కుటుంబాలు, వంశాలతోబాటు వారు జాబితాలో చేర్చబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","నఫ్తాలి సంతతిలో లెక్కించబడిన పురుషులు మొత్తం 53,400. ");
INSERT INTO tel2010_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ఈ పురుషులందర్నీ మోషే, అహరోను ఇశ్రాయేలు పెద్దలు లెక్కించారు. (పన్నెండుమంది నాయకులు, ఒక్కో వంశంనుండి ఒక్కో నాయకుడు ఉన్నారు.) ");
INSERT INTO tel2010_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","ఇశ్రాయేలీయులలో 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉండి, సైన్యంలో పని చేయగల ప్రతి పురుషుడు లెక్కించబడ్డాడు. అ పురుషులు వారి వంశాలతో బాటు లెక్కించబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","పురుషుల సంఖ్య మొత్తం 6,03,550. ");
INSERT INTO tel2010_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","లేవీ వంశపు కుటుంబాలు ఇశ్రాయేలీయులలో ఇతరులతో బాటు జాబితాలో లెక్కించబడలేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","యెహోవా మోషేతో ఇలా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“లేవీ వంశంలోని పురుషులను నీవు లెక్కించకూడదు. ఇశ్రాయేలు ప్రజలలో ఇతరులతో భాగంగా వీరిని చేర్చకు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ఒడంబడిక పవిత్ర గుడారానికి వారు బాధ్యులని లేవీ మనుష్యులతో చెప్పు. దాని విషయం, దానితోబాటు ఉండె వాటన్నింటి విషయం, వారు జాగ్రత్త తీసుకోవాలి. పవిత్ర గుడారాన్ని, దానిలో ఉండే వాటన్నింటినీ వారు మోయాలి. వారి నివాసం దాని చుట్టు ఏర్పపరచుకొని, దానినిగూర్చి జాగ్రత్త తీసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","పవిత్ర గుడారం ఎప్పుడైనా ముందుకు తీసుకుని పోదలిస్తే లేవీ మనుష్యులే అది చేయాలి. ఎప్పుడైనా సరే ఒకచోట పవిత్రగుడారం వేయబడితే, అది లేవీ మనుష్యులే వేయాలి. పవిత్ర గుడారం విషయం జాగ్రత్త తీసుకునేవారు వాళ్లే. లేవీ కుటుంబానికి చెందనివారు ఇంకెవరయినా గుడారాన్ని గూర్చి శ్రద్ధ తీసుకునేందుకు ప్రయత్నిస్తే, అతడు చంపివేయబడతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","ఇశ్రాయేలు ప్రజలు వేరు వేరు వంశాలుగా వారి నివాసాలు ఏర్పాటు చేసుకోవాలి. ప్రతి మనిషీ తన కుటుంబ ధ్వజానికి దగ్గరగా డేరాలు వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","అయితే లేవీ ప్రజలు పవిత్ర గుడారం చుట్టూ డేరాలు వేయాలి. ఒడంబడిక పవిత్ర గుడారాన్ని లేవీ ప్రజలు కాపాడుతారు. ఇశ్రాయేలు ప్రజలకు ఎలాంటి కీడూ జరుగకుండా వారు పవిత్ర గుడారాన్ని కాపాడుతారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","కనుక మోషేకు యెహోవా ఆజ్ఞాపించిన విషయాలన్నింటిలో ఇశ్రాయేలీయులు విధేయులయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","మోషే, అహరోనులతో యెహోవా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“ఇశ్రాయేలు ప్రజలు వారి డేరాను సన్నిది గుడారం చుట్టూ వేసుకోవాలి. ఒక్కోవంశానికి దాని స్వంత ధ్వజం ఉంటుంది, ఎవరి వంశ ధ్వజం దగ్గర వారు నివాసం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","“యూదా డేరా పతాకం తూర్పుపక్క అంటే సూర్యోదయ దిశన ఉంటుంది. యూదా ప్రజలకు అమ్మీనాదాబు కుమారుడైన నయస్సోను నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ఈ విభాగములో 74,600 మంది పురుషులు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","“యూదావారి పక్కన ఇశ్శాఖారు వంశంవారి డేరా ఉంటుంది. సూయారు కుమారుడైన నెతనేలు ఇశ్శాఖారు వంశానికి నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ఈ విభాగములో 54,400 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","“జెబూలూను వంశం కూడ యూదా వంశం పక్కగానే ఉంటారు. హేలోను కుమారుడైన ఏలీయాబు జెబూలూను వారికి నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ఈ విభాగములో 57,400 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","“యూదా సంతతిలో 1,86,400 మంది పురుషులు ఉన్నారు. వీరంతా వారివారి వంశాల ప్రకారముగా విభజించబడ్డారు. ప్రజలు ఒక చోటనుండి మరో చోటకు తరలి వెళ్లేటప్పుడు యూదా వంశం వారు ముందుగా నడుస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","“పవిత్ర గుడారానికి దక్షిణాన రూబేను డేరా ధ్వజం ఉంటుంది. ఒక్కో వంశం దాని ధ్వజం దగ్గర నివాసం చేస్తారు. షెదేయూరు కుమారుడు ఏలీసూరు రూబేను వారికి నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ఈ విభాగములో 46, 500 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","“రూబేను వంశానికి పక్కగా షిమ్యోను వంశంవారు నివాసం చేస్తారు. సూరీషద్దాయి కుమారుడు షెలుమీయేలు, షిమ్యోను వారికి నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ఈ విభాగములో 59,300 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","“గాదు వంశంకూడ రూబేను వారి పక్కగా నివాసంచేస్తారు. రగూయేలు కుమారుడైన ఎలీయాసావు గాదు వారికి నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ఈ విభాగములో 45,650 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","“మొత్తం రూబేను నివాసంలో ఉన్న విభాగములన్నిటిలో కలిసి 1,51,450 మంది పురుషులు ఉన్నారు. ప్రజలు ఒక చోటనుండి మరోచోటికి తరలి వెళ్లేటప్పుడు రూబేను వంశం రెండో విభాగముగా బయల్దేరుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","“ప్రజలు ప్రయాణం చేసేటప్పుడు లేవీ వంశంవారు తర్వాత బయల్దేరతారు. సన్నిధి గుడారం వారితో బాటు ఇతర వంశాలవారి మధ్య ఉంటుంది. వారు బయల్దేరి వెళ్లే క్రమంలోనే వారి నివాసం ఏర్పాటు చేసుకొంటారు. ప్రతి వ్యక్తి తన వంశ ధ్వజం దగ్గర ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","“ఎఫ్రాయిము వారి గుడారపు ధ్వజం పడమటి దిక్కున ఉంటుంది. ఎఫ్రాయిము విభాగములు అక్కడ నివసిస్తాయి. అమీహూదు కుమారుడైన ఎలీషామా ఎఫ్రాయిము ప్రజలకు నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ఈ విభాగములో 40,500 మంది ప్రజలు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","“ఎఫ్రాయిము కుటుంబానికి పక్కగా మనష్షే వంశం నివసిస్తుంది. పెదాసూరు కుమారుడు గమలీయేలు మనష్షే మనుష్యులకు నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ఈ విభాగములో 32,200 మంది మనుష్యులు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","“బెన్యామీను వంశం కూడ ఎఫ్రాయిము కుటుంబానికి పక్కగా నివాసం చేస్తారు. గిద్యోనీ కుమారుడు అబీదాను బెన్యామీను ప్రజలకు నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ఈ విభాగములో 35,400 మంది మనుష్యులు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","“ఎఫ్రాయిము నివాసములో మొత్తం 1,08,100 పురుషులు ఉన్నారు. ప్రజలు ఒక చోటునుండి మరోచోటుకు తరలి వెళ్లినప్పుడు వారు మూడో కుటుంబంగా బయల్దేరతారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","“దాను వారి గుడారపు ధ్వజం ఉత్తర దిశనఉంటుంది. దాను కుటుంబ విభాగాలు అక్కడ నివసిస్తాయి. అమీషద్ధాయి కుమారుడైన అహీయెజెరు దాను వారికి నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ఈ విభాగములో 62,700 మంది ప్రజలు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","“ఆషేరు వంశాల వారు దాను కుటుంబ విభాగము పక్కగా నివాసం చేస్తారు. ఒక్రాను కుమారుడు పగీయేలు, ఆషేరు ప్రజల నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ఈ వంశలో 41,500 మంది ప్రజలు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","“నఫ్తాలి వంశంకూడ దాను వంశానికి పక్కగా నివాసం చేస్తారు. ఏనాను కుమారుడైన అహీరా నఫ్తాలి ప్రజల నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ఈ విభాగంలో 53,400 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","“దాను నివాసంలో మొత్తం 1,57,600 మంది పురుషులు ఉన్నారు. ప్రజలు ఒక చోట నుండి మరో చోటుకు తరలినప్పుడు, వీరు చివరి కుటుంబముగా బయల్దేరతారు. వారు తమ స్వంత ధ్వజం క్రిందనే నివాసం చేస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","అన్ని నివాసాలలోను ఉన్న మొత్తం వంశాలన్నింటిలో కలిపి 6,03,550 మంది పురుషులు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","మోషే ఇశ్రాయేలు ప్రజలందరిలో కలిపి లేవీయులను లెక్కించలేదు. ఇది యెహోవా ఇచ్చిన ఆజ్ఞ. ");
INSERT INTO tel2010_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","కనుక మోషేతో యెహోవా ెచెప్పిన వాటన్నింటికి ఇశ్రాయేలు ప్రజలు విధేయులయ్యారు. యెహోవా వారితో చెప్పినట్టే ఇశ్రాయేలు ప్రజలు వారివారి పతాకాలదగ్గర నివాసం చేసారు. యెహోవా వారితో చెప్పిన విధానంలోనే ఇశ్రాయేలు ప్రజలు ప్రయాణం చేసారు. ప్రతి వ్యక్తి తన కుటుంబంతో, వంశంతోనే ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","సీనాయి పర్వతం మీద మోషేతో యెహోవా మాట్లాడిన సమయంలో అహరోను, మోషేల కుటుంబ చరిత్ర ఇది. ");
INSERT INTO tel2010_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","అహరోనుకు కుమారులు నలుగురు. నాదాబు మొదటి కుమారుడు. ఆ తర్వాత అబీహు, ఎలీయాజరు, ఈతామారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ఈ కుమారులు అభిషేకించబడిన యాజకులు. యాజకులుగా యెహోవాను సేవించే ప్రత్యేక పని ఈ కుమారులుకు ఇవ్వబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","అయితే నాదాబు, అబీహు యెహోవాను సేవిస్తూనే పాపంచేసారు గనుక వారు చనిపోయారు. వారు యెహోవాకు ఒక అర్పణ తయారు చేసారు కాని, యోహోవా అనుమతించని అగ్నిని వారు ఉపయోగించరు. ఇది సీనాయి అరణ్యంలో సంభవించింది. కనుక నాదాబు, అబీహు అక్కడే చనిపోయారు. వారికి కుమారులు లేనందుచేత ఎలీయాజరు, ఈతామారు యాజకులై యెహోవాను సేవించారు. వారి తండ్రి అహరోను జీవించి ఉండగానే వారు ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“లేవీ కుటుంబంలోని వాళ్లందర్నీ తీసుకునిరా, అహరోను యాజకుని దగ్గరకు వాళ్లను తీసుకునిరా. వారు అహరోనుకు సహాయకులు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","అహరోను సన్నిధి గుడారంలో పరిచర్య చేసేటప్పుడు లేవీయులు అహరోనుకు సహాయం చేస్తారు. ఇశ్రాయేలు ప్రజలు పవిత్ర గుడారంలో ఆరాధించటానికి వచ్చినప్పుడు వాళ్లందరికి లేవీయులు సహాయం చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","సన్నిధి గుడారంలో సామగ్రి అంతటినీ ఇశ్రాయేలు ప్రజలు కాపాడాలి. అది వారి బాధ్యత. కానీ లేవీయులు వీటి విషయం జాగ్రత్త పుచ్చుకొని ఇశ్రాయేలు ప్రజలందరికీ సేవచేస్తారు. పవిత్ర గుడారంలో ఆరాధించటంలో ఇది వారి విధానం. ");
INSERT INTO tel2010_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","“లేవీయులు అశ్రాయేలు ప్రజలందరిలో నుండి ఏర్పాటు చేసుకోబడ్డారు. ఈ లేవీయులు అహరోనుకు, అతని కుమారులకు సహాయం చేసేందుకు ఏర్పాటు చేయబడ్డారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","“అహరోనును, అతని కుమారులను యాజకులుగా నీవు నియమించు. వారు, వారి బాధ్యతను నిర్వహిస్తూ యాజకులుగా సేవ చేయాలి, పవిత్ర వస్తువులను సమీపించేందుకు ప్రయత్నించే ఏ వ్యక్తి అయినా చంపివేయబడాలి.” ");
INSERT INTO tel2010_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ఇంకా మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ఇశ్రాయేలీయులు ప్రతి కుటుంబంలోను పెద్దకుమారుణ్ణి నాకు ఇవ్వాలని, నేను నీతో చెప్పాను, కానీ నన్ను సేవించేందుకు ఇప్పుడు లేవీయులను నేను ఏర్పాటు చేసుకుంటున్నాను. వారు నా వారై ఉంటారు. అందుచేత మిగిలిన ఇశ్రాయేలు ప్రజలంతా వారి పెద్ద కుమారులను నాకు ఇవ్వాల్సిన అవసరం లేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","మీరు ఈజిప్టులో ఉన్నప్పుడు, ఈజిప్టు ప్రజల పెద్ద కుమారులందర్ని నేను చంపాను. ఆ సమియంలో ఇశ్రాయేలు పెద్ద కుమారులందరిని నా వాళ్లగా నేను అంగీకరించాను. పెద్ద కుమారుందరు నా వారు, పశువులలో ప్రథమంగా పుట్టినవన్నీ నావే. కానీ మీ పెద్దలందరినీ నేను మీకు తిరిగి ఇచ్చివేస్తున్నాను, మరియు లేవీయులను నా వారిగా చేసుకుంటున్నాను. నేను యెహోవాను.” ");
INSERT INTO tel2010_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","సీనాయి అరణ్యంలో మోషేతో మరోసారి యెహోవా మాట్లాడాడు: యెహోవా ఇలా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“లేవీ వంశంలో ఉన్న లేవీలను, కుటుంబాలను అన్నింటినీ లెక్కించు. ప్రతి పురుషుని, ఒక నెలగాని అంతకంటె ఎక్కువగాని వయస్సు ఉన్న ప్రతి బాలుని లెక్కించు.” ");
INSERT INTO tel2010_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","కనుక మోషే యెహోవాకు విధేయుడయ్యాడు. అతడు వాళ్లందర్నీ లెక్కించాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","లేవీకి ముగ్గురు కుమారులు. వారి పేర్లు: గెర్షోను, కహాతు, మెరారి. ");
INSERT INTO tel2010_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ఒక్కో కుమారుడు ఎన్నో వంశాలకు నాయకుడు. గెర్షోను కుటుంబంలో, లిబ్నీ, షిమీ. ");
INSERT INTO tel2010_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","కహాతు కుటుంబంలో, అమ్రాము, ఇస్హారు, హెబ్రోను, ఉజ్జీయేలు, ");
INSERT INTO tel2010_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","మెరారి కుటుంబంలో, మహలి, ముషి. ఇవి లేవీ వంశానకి చెందిన కుటుంబాలు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","లిబ్ని, షిమివంశాలు గెర్షోము కుటుంబానికి చెందినవి. అవి గెర్షోనీ వంశాలు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ఈ రెండు కుటుంబాలలోను ఒక నెల వయసు దాటిన బాలురు, పురుషులు 7,500 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","గెర్షోని కుటుంబాలు పశ్చిమాన నివాసం చేయాలని చెప్పబడింది. పవిత్ర గుడారం వెనుకవైపు వారు నివాసము చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","లాయెలు కుమారుడు ఎలీయా సావు గెర్షోనీ ప్రజల కుటుంబాలకు నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","పవిత్ర గుడారం, దాని కప్పు, వెలుపలి గుడారం కాపాడుట పవిత్ర గుడారంలో గెర్షోనీ ప్రజలు బాధ్యత. సన్నిధి గుడారం ప్రవేశంలో ఉన్న తెర బాధ్యత కూడా వారే తీసుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ఆవరణలో తెర బాధ్యత కూడా వారే వహించారు. ఆవరణానికి గల ప్రవేశం యొక్కతెర విషయం కూడా వారే శ్రద్ధ పుచ్చుకున్నారు. పవిత్ర గుడారానికి, బలి పీఠానికి చుట్టూ ఉంది ఈ ఆవరణ. తాళ్ల విషయం, తెరలకు సంబంధించిన వాటన్నింటి విషయం వారే జాగ్రత్త తీసుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","అమ్రాము, ఇస్హారు, హెబ్రోను, ఉజ్జీయేలు వంశాలు కహాతు కుటుంబానికి చెందినవి. వారు కహాతీ వంశపువారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","పురుషులు ఒక నెల వయసు దాటిన బాలురు, 8,600 మంది ఈ కుటుంబంలో ఉన్నారు. పవిత్ర స్థలంలోని వాటిని కాపాడే బాధ్యత కహాతు ప్రజలకు ఇవ్వబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","పవిత్ర గుడారం దక్షిణ దిశ కహాతీ వంశానికి ఇవ్వబడింది. ఇది వారు నివాసం చేసిన ప్రదేశం. ");
INSERT INTO tel2010_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ఉజ్జీయేలు కుమారుడు ఎలీషాపాను కహాతీ వంశాల నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","పవిత్ర పెట్టె, బల్ల, దీపస్తంభం, పవిత్ర స్థలంలోని పాత్రలను కాపాడటం వారి బాధ్యత. తెర విషయం, దానితోబాటు ఉపయోగించిన వస్తువులన్నింటి విషయంకూడా వారు శ్రద్ధ తీసుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","అహరోను కుమారుడును యాజకుడైన ఎలియాజరు లేవీ ప్రజానాయకులకు నాయకుడు. పవిత్ర పరికరాలను కాపాడే వారందరిపై ఎలియాజరు పరీశీలకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","34","మహలీ, మూషి కుటుంబాలు మెరారి వంశానికి చెందినవి. ఒక నెల దాటిన బాలురు, పురుషులు మహలీ కుటుంబంలో 6,200 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","అబీహాయిలు కుమారుడైన సూరీయేలు మెరారి వంశానికి నాయకుడు. పవిత్ర గుడారం ఉత్తర ప్రదేశం ఈ వంశానికి ఇవ్వబడింది. ఇది వారు నివాసం చేసిన ప్రదేశం. ");
INSERT INTO tel2010_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","పవిత్ర గుడారపు చట్రాలను కాపాడే బాధ్యత మెరారి ప్రజలకు ఇవ్వబడింది. పవిత్ర గుడారపు చట్రాలతో బాటు వాటి పలకలను, అడ్డకర్రలను, స్తంభాలను. దిమ్మలను, పరికరాలను, దానికి సంబంధించిన వాటన్నింటినీ వారు కాపాడారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","పవిత్ర గుడారం చుట్టు ప్రక్కల స్తంభాలన్నింటినీ వారు కాపాడారు. వాటి దిమ్మలు, మేకులు, తాళ్లు కూడ ఇందులో ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","సన్నిధి గుడారం ఎదుట పవిత్ర గుడారానికి తూర్పున మోషే, అహరోను, అతని కుమారులు విడిదిచేసారు. పవిత్ర స్థలాన్ని కాపాడే బాధ్యత వారికి ఇవ్వబడింది. ఇది ఇశ్రాయేలీయులందరి పక్షంగా వారు చేసారు. వేరే వారెవరైనా పవిత్ర స్థలం దగ్గరగా వస్తే చంపేయాల్సిందే. ");
INSERT INTO tel2010_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","లేవీ వంశంలో ఒక నెలగాని, అంతకు మించిగాని వయస్సున్న బాలురను పురుషులను లెక్కించమని మోషే, అహరోనులకు యెహోవా ఆజ్ఞాపించాడు. మొత్తం సంఖ్య 22,000. ");
INSERT INTO tel2010_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","మోషేతో యెహోవా ఇలా అన్నాడు: “ఇశ్రాయేలీయులలో ఒక నెలగాని అంతకంటె ఎక్కువగాని వయసుగల మొదట పుట్టిన బాలురను, పురుషులను అందరినీ లెక్కించు, వారి పేర్ల జాబితా ఒకటి తయారుచేయి. ");
INSERT INTO tel2010_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ఇప్పుడు ఇశ్రాయేలీయుల పెద్ద కుమారులను నేను తీసుకోను. ఇప్పుడు యెహోవానగు నేను లేవీయులను స్వీకరిస్తాను. ఇశ్రాయేలీయులలో ఇతరుల పశువులలో మొదటి ఫలమంతటినీ తీసుకొనే బదులు లేవీయుల పశువుల మొదటి ఫలాన్ని నేను తీసుకుంటాను.” ");
INSERT INTO tel2010_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","కనుక యెహోవా ఆజ్ఞాపించిన ప్రకారం మోషేచేసాడు. ఇశ్రాయేలు ప్రజలు పిల్లల్లో పెద్ద వారినందరినీ మోషే లెక్కించాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ఒక నెల, అంతకంటె ఎక్కువ వయసుగల మొదట పుట్టిన బాలురను, పురుషులను మోషే జాబితా చేసాడు. ఆ జాబితాలో 22,273 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","మోషేతో యెహోవా ఇంకా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“నేనే, యెహోవాను ఈ ఆజ్ఞ ఇస్తున్నాను: ‘ఇశ్రాయేలీయుల ఇతర కుటుంబాల్లోని మొదట పుట్టిన వారందరి బదులు లేవీయులను తీసుకో. మిగిలిన ప్రజల పశువులకు బదులు లేవీయుల పశువులను నేను తీసుకుంటాను. లేవీయులు నా వారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","లేవీయులు 22,000 మంది ఉన్నారు కానీ, ఇతర కుటుంబాల్లోని పెద్ద కుమారులు 22,273 మంది ఉన్నారు. అనగా లేవీయులకంటె 273 మంది పెద్ద కుమారులు ఎక్కువగా ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","కనుక ఆ 273 మందిలో ప్రతి ఒక్కరి వద్దా అధికారిక కొలతనుపయోగించి అయిదు తులాల వెండి తీసుకో. (ఇది 20 చిన్నములు బరువుగల అధికారిక కొలత.) ఇశ్రాయేలు ప్రజలవద్ద ఆ వెండి వసూలు చేయి. ");
INSERT INTO tel2010_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ఆ వెండిని అహరోనుకు అతని కుమారులకు ఇవ్వు. అది 273 మంది ఇశ్రాయేలీయులకు విమోచనా ధనం.’” ");
INSERT INTO tel2010_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","కనుక 273 మంది కొరకు ఈ ధనాన్ని మోషే వసూలు చేసాడు. ఈ 273 మంది స్థానాన్ని లేవీ వంశం వహించలేకపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","ఇశ్రాయేలు ప్రజలలో మొదట పుట్టినవారినుండి వెండిని మోషే వసూలు చేసాడు. అధికారిక కొలత ప్రకారం 1,365 వెండి తులాలను అతడు వసూలు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","యెహోవాకు మోషే విధేయుడయ్యాడు. యెహోవా ఆజ్ఞాపించిన ప్రకారం అహరోనుకు, అతని కుమారులకు ఆ వెండిని మోషే ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","మోషే అహరోనులతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“కహాతు వంశంలోని కుటుంబాలకు చెందిన పురుషులను లెక్కించండి. (కహాతు వంశం లేవీ వంశంలోని ఒక భాగం.) ");
INSERT INTO tel2010_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","సైన్యంలో పని చేసిన వారిలో 30 నుండి 50 సంవత్సరాల వరకు వయసుగల పురుషులందరినీ లెక్కించండి. ఈ పురుషులు సన్నిధి గుడారంలో పని చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","సన్నధి గుడారంలో అత్యంత పవిత్ర స్థలాన్ని జాగ్రత్తగా చూసుకోవటం వారి పని. ");
INSERT INTO tel2010_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","“ఇశ్రాయేలు ప్రజలు ఒక కొత్త స్థలానికి ప్రయాణం చేసినప్పుడు, అహరోను, అతని కుమారులు సన్నిధి గుడారంలోనికి వెళ్లి, తెరనుదించి, దానితో పవత్ర ఒడంబడిక పెట్టెను కప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","తర్వాత దీనంతటినీ శ్రేష్ఠమైన తోలుతో కప్పాలి. అప్పుడు దానంతటి మీద నీలం రంగు బట్ట పరచి, దాని మోత కర్రలను పవిత్ర పెట్టె ఉంగరాలలో దూర్చాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“తర్వతా పవిత్ర బల్ల మీద ఒక నీలం బట్టను వారు పర్చాలి. అప్పుడు గిన్నెలను, ధూపార్తులను, పాత్రలను, పానము చేయు పాత్రలను వారు ఆ బల్ల మీద పెట్టాలి. ప్రత్యేక రొట్టెలను కూడ ఆ బల్ల మీద పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","అప్పుడు వీటన్నింటిమీద ఒక ఎర్రబట్టను మీరు వేయాలి. తర్వాత శ్రేష్ఠమైన తోలుతో అన్నింటినీ కప్పాలి. అప్పుడు బల్ల ఉంగరాల్లో దండెలను పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“తర్వాత దీపస్తంభాన్ని, దాని దీపాలను నీలం బట్టతో కప్పాలి. దీపాలను ప్రకాశింప చేసేందుకు వినియోగించిన వస్తువులన్నింటినీ, దీపాలకు ఉపయోగించిన నూనె పాత్రలను కప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","అప్పుడు ప్రతి దానిని శ్రేష్ఠమైన తోలుతో చుట్టి, వీటిని మోసేందుకు ఉపయోగించే దండెలమీద వీటిని ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“బంగారు బలిపీఠం మీద నీలం బట్టను పరచాలి. దానిని శ్రేష్ఠమైన తోలుతో కప్పాలి. అప్పుడు బలిపీఠపు ఉంగరాలలో దాని, మోత కర్రలను ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“తర్వాత పవిత్ర స్థలంలో ఆరాధనకు ఉపయోగించే ప్రత్యేక వస్తులన్నింటినీ సమకూర్చాలి. ఆ వస్తువులను ఒక్క చోట సమకూర్చి, నీలం బట్టతో వాటిని చుట్టి పెట్టాలి. అప్పుడు దాన్ని శ్రేష్ఠమైన తోలుతో కప్పాలి. వీటిని మోసేందుకు ఒక చట్రంమీద వాటిని ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“ఇత్తడి బలిపీఠపు బూడిదను తీసివేసి, ధూమ్రవర్ణంగల బట్టను దానిమీద పరచాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","తర్వాత బలిపీఠందగ్గర ఆరాధనకు ఉపయోగించే వస్తులన్నింటినీ సమకూర్చాలి. అవి ఏవనగా, ధూపార్తి, ముండ్ల గరిటెలు, గిన్నెలు, ఇతర పరికారాలు. వీటన్నింటినీ యిత్తడి బలిపీఠం మీద ఉంచాలి. తర్వాత బలిపీఠం మీద శ్రేష్ఠమైన తోలు కప్పాలి. బలిపీఠపు ఉంగరాల్లో దానిమోత కర్రలు ఉంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“అహరోను, అతని కుమారులు పవిత్ర స్థలంలో పవిత్ర వస్తువులన్నింటినీ కప్పటం అయిన తర్వాత, కహాతు కుటుంబపు పురుషులు లోనికి వెళ్లి, ఆ వస్తువులను మోయటం మొదులు పెట్టవచ్చు. ఈ విధంగా వారు చావకుండేలా పవిత్ర స్థలాన్ని తాకరు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“యాజకుడైన అహరోను కుమారుడు ఎలియాజరు పవిత్ర గడారానికి బాధ్యుడు. పవిత్ర స్థలానికి, దానిలోని సమస్తానికి అతడు బాధ్యుడు. దీపాల నూనె, పరిమళ ధూపద్రవ్యాలు, నిత్యార్పణ, అభిషేక తైలం, వీటన్నింటికీ అతడు బాధ్యుడు.” ");
INSERT INTO tel2010_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","మోషే అహరోనులతో యెహోవా ఈలాగు అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“జాగ్రత్తగా ఉండండి, ఆ కహాతీ మనుష్యుల్ని నాశనం కానివ్వకండి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","కహాతీ మనుష్యులు అతి పవిత్ర స్థలాన్ని సమీపించికూడ మరణించకుండా ఉండేటట్టుగా మీరు వీటిని చేయాలి. అహరోను, అతని కుమారులు లోనికి వెళ్లి, కహాతీ మనుష్యులు ఒక్కొక్కరు ఏమేమి చేయాల్సిందీ చూపెట్టాలి. ఒక్కొక్కడు మోయవలసిన వాటిని వారు ఒక్కొక్కనికి ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","మీరు ఇలా చేయకపోతే, కహాతీ మనుష్యులు లోనికి వెళ్లి, పవిత్ర వస్తువులను చూచి, అవి ముఖ్యమైనవి కానట్టుగా ఎంచవచ్చును. వారు గనుక అలా ఒక క్షణంపాటుచేస్తే, వారు మరణిస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“గెర్షోను సంతతిలో మనుష్యులందరినీ లెక్కించు. వంశాలుగా, కుటుంబాలుగా వారి జాబితా తయారుచేయి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","30 నుండి 50 సంవత్సరాల వయస్సుగలిగి, యుద్ధంలో పనిచేసిన పురుషులందరినీ లెక్కించు. వీరంతా సన్నిధి గుడారాన్ని జాగ్రత్తగా చూసుకునే పని చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“గెర్షోను కుటుంబమువారు చేయాల్సినవి, మోయాల్సినవి ఇవి: ");
INSERT INTO tel2010_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","పవిత్ర గుడారపు తెరలు, సన్నిధి గుడారం, దాని కప్పు, శ్రేష్ఠమైన తోలుతో చేయబడ్డ కప్పు వారు మోయాలి. సన్నిధి గుడార ప్రవేశం దగ్గర తెరను కూడా వారు మోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","పవిత్ర గుడారం చుట్టూ బలిపీఠం చుట్టూ ఉండే ఆవరణ తెరలన్నీ వారు మోయాలి. మరియు ఆవరణ ప్రవేశానికి ఉండే తెరను కూడా వారు మోయాలి. తెరలకు ఉపయోగించే వస్తువులన్నింటినీ, తాళ్లన్నింటినీ వారే మోయాలి. వీటి విషయంలో ఏది చేయాల్సి వచ్చినా గెర్షోను కుటుంబము వాళ్లే బాధ్యలు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","జరుగుతున్న పని అంతటినీ అహరోను, అతని కుమారులు గమనిస్తూ ఉంటారు. గెర్షోను ప్రజలు మోసేవాటిని, చేసేవాటినీ అన్నింటినీ అహరోను, అతని కుమారులు గమనిస్తుంటారు. వారు ఏ వస్తువులు మోయుటకు బాధ్యలో వాటన్నింటిని గూర్చి నీవు వారితో చెప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","గెర్షోను కుటుంబమువారు సన్నిధి గుడారం కోసం చేయాల్సిన పని ఇది. యాజకుడైన అహరోను కుమారుడు ఈతామారు వారి పనికి బాధ్యుడు.” ");
INSERT INTO tel2010_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“మెరారియులలోని వంశాలు, కుటుంబాలలో ఉన్న పురుషులందరినీ లెక్కించు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","30 నుండి 50 సంవత్సరాల వయసు కలిగి యుద్ధంలో పని చేసిన పురుషులందరినీ లెక్కించు. వీరు సన్నిధి గుడారం కోసం ఒక ప్రత్యేక పని చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","మీరు ప్రయాణం టప్పుడు సన్నిధి గుడారపు పలకలు మోయటం వారి పని. అడ్డకర్రలు, స్తంభాలు, దిమ్మలను వారు మోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ఆవరణ చుట్టూ ఉండే స్తంభాలు కూడ వారు మోయాలి. దిమ్మలను, గుడారపు మేకులను, తాళ్లను, ఆవరణ చుట్టూ ఉండే స్తంభాలకు ఉపయోగించే సమస్తం వారు మోయాలి. పేర్ల జాబితా చేసి, సరిగ్గా ఒక్కో మనిషి ఏమి మోయాలో వారికి చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","సన్నిధి గుడారపు పనిలో సేవ చేసేందుకు మెరారి ప్రజలు చేయాల్సిన పనులు ఇవి. యాజకుడైన అహరోను కుమారుడు ఈతామారు వారి పనికి బాధ్యుడు.” ");
INSERT INTO tel2010_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","మోషే, అహరోను, ఇశ్రేయేలు ప్రజా నాయకులు కహాతీ ప్రజలను లెక్కించారు. వంశాలుగా, కుటుంబాలుగా వారు వారిని లెక్కించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","30 నుండి 50 సంవత్సరాల వయసు గలిగి యుద్ధంలో పని చేసిన పురుషులందరిని వారు లెక్కించారు. సన్నిధి గుడారంకోసం చేయాల్సిన ప్రత్యేక పని వీరికి అప్పగించబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","ఈ పని చేసేందుకు అర్హులు 2,750 మంది పురుషులు కహాతు వంశంలో ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","కనుక కహాతు వంశంలోని ఈ పురుషులకు సన్నిధి గుడారం కోసం చేయాల్సిన ప్రత్యేక పని అప్పగించబడింది. మోషేతో యెహోవా చెప్పిన ప్రకారం మోషే, అహరోను యిలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","మరియు, గెర్షోను కుటుంబం కూడ లెక్కించబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","30 నుండి 50 సంవత్సరాల వయసు ఉండి సైన్యంలో పని చేసిన పురుషులంతా లెక్కించబడ్డారు. సన్నిధి గుడారం కోసం వారు చేయాల్సిన ప్రత్యేక పని ఈ మనుష్యులకు అప్ప గించటం జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","గెర్షోను వంశాల్లో అర్హులైన పురుషులు 2,630 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","కనుక గెర్షోను వంశంలోని ఈ మనుష్యులకు సన్నిధి గుడారం కోసం చేయాల్సిన ప్రత్యేక పని అప్పగించటం జరిగింది. మోషేకు యెహోవా చెప్పిన ప్రకారం మోషే, అహరోను ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","మరియు మెరారి వంశంలోని పురుషులు లెక్కించబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","30 నుండి 50 సంవత్సరాల వయసు ఉండి సైన్యంలో పని చేసిన పురుషులంతా లెక్కించబడ్డారు. సన్నిధి గుడారం కోసం వీరు చేయాల్సిన ప్రత్యేక పని వీరికి అప్పగించబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","మెరారి వంశాల్లో అర్హులైన పురుషులు 3,200 మంది ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","కనుక మెరారి వంశంలోని ఈ పురుషులకు వారి ప్రత్యేక పని అప్పగించబడింది. మోషేతో యెహోవా చెప్పిన ప్రకారం మోషే అహరోనులు ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","కనుక మోషే, అహరోను, ఇశ్రేయేలు ప్రజా నాయకులు లేవీయులలోని పురుషులందరినీ లెక్కించారు. ప్రతి వంశాన్ని, ప్రతి కుటుంబాన్ని వారు లెక్కించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","30 నుండి 50 సంవత్సరాల వయసువుండి సైన్యంలో పని చేసిన పురుషులందరూ లెక్కించబడ్డారు. సన్నిధి గుడారం కోసం చేయాల్సిన ప్రత్యేక పని వీరికి అప్పగించబడింది. వారు ప్రయాణం చేసినప్పుడు సన్నిధి గుడారాన్ని మోషే పనిని వారు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","వారి మొత్తం సంఖ్య 8,500. ");
INSERT INTO tel2010_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","మోషేకు ఈ ఆజ్ఞను యెహోవా ఇచ్చాడు. ఒక్కో మనిషికి ఒక్కో పని ఇవ్వబడింది. ఏ మనిషి ఏమి మోయాలో ఆ మనిషికి చెప్పబడింది. కనుక యెహోవా ఆజ్ఞ ప్రకారం చేయబడింది. పురుషులంతా లెక్కించబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ఇశ్రేయేలు ప్రజలు వ్యాధులు, రోగములు లేకుండవారి నివాసమును కాపాడుకోవాలని నేను ఆజ్ఞాపిస్తున్నాను. కుష్ఠురోగం ఉన్న ఏ మనిషినైనా సరే వారి నివాసములో నుండి పంపించి వేయాలని ప్రజలతో చెప్పు. స్రావంగల ప్రతి మనిషికి వారి నివాసంలోనుండి పంపివేయాలని వారితో చెప్పు. శవాన్ని ముట్టిన ప్రతి మనిషినీ వారి నివాసమునుండి పంపివేయాలని వారితో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","అతడు స్త్రీగాని, పురుషుడుగాని గొప్పేమీ కాలేదు. రోగాన్ని వ్యాధిని వారు మీ నివాసములో వ్యాపింపజేయకుండునట్లు వారిని మీ నివాసమునుండి బయటకు పంపించివేయండి. మీ నివాసములో మీ మధ్య నేను నివసిస్తున్నాను.” ");
INSERT INTO tel2010_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","కనుక ఇశ్రేయేలు ప్రజలు దేవుని ఆజ్ఞకు విధేయులయ్యారు. అలాంటి వారిని నివాసము వెలుపలకు వారు పంపించివేసారు. మోషేకు యెహోవా ఆజ్ఞాపించిన ప్రకారం వారు ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","మోషేతో యెహోవా ఈలాగు చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ఇశ్రేయేలు ప్రజలతో ఇలా చెప్పు: ఒకడు మరొక వ్యక్తికి కీడు చేస్తాడు. (ఒకడు ఇతరులకు కీడు చేస్తే వాడు నిజానికి దేవునికి వ్యతిరేకంగా పాపం చేస్తున్నాడు.) అతడు దోషి. ");
INSERT INTO tel2010_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","కనుక అతడు తాను చేసిన పాపం గూర్చి ప్రజలతో చెప్పాలి. తర్వాత అతడు చేసిన తప్పుకు పూర్తిగా విలువ చెల్లించాలి. అతడు ఎవరికి నష్టం కలిగించాడో ఆ మనిషికి చెల్లించాల్సినదానికి ఇంకా ఐదో వంతు కలిపి చెల్లించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","కానీ ఒక వేళ ఎవరికైతే అతడు నష్టం కలిగించాడో అతడు చనిపోతాడు. ఒక వేళ నష్టపరిహరం పుచ్చుకొనేందుకు, చనిపోయిన వ్యక్తికి నావాళ్లు అనుటకు ఎవరు ఉండరు. అలాంటప్పుడు తప్పు చేసినవాడు ఆ విలువను యహోవాకు చెల్లించాలి. అతడు పూర్తి మొత్తాన్ని యాజకునికి చెల్లించాలి. యాజకుడు ప్రాయశ్చిత్తార్థపు పొట్టేలును బలిగా అర్పించాలి. తప్పు చేసిన ఆ మనిషి పాపాలు క్షమింపబడుటకు బలిగా పొట్టేలు అర్పించబడాలి. మిగిలిన విలువను యాజకుడు ఉంచు కోవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","“ఇశ్రేయేలు ప్రజల్లో ఒకడు దేవునికి ఒక ప్రత్యేక కానుక ఇస్తే, దానిని స్వీకరించే యాజకుడు దానిని ఉంచుకోవచ్చును. అది అతనిదే. ");
INSERT INTO tel2010_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ఈ ప్రత్యేక కానుకలు అర్పించాల్సిన అవసరం అంటూ ఏమీ లేదు. కాని ఎవరైనా అలా ఇస్తే, అవి యాజకునికే చెందుతాయి.” ");
INSERT INTO tel2010_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","అప్పుడు మోషేతో యోహోవా ఈలాగున చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“ఇశ్రేయేలు ప్రజలతో ఈ విషయాలు చెప్పు: ఒకని భార్య అతనికి అపనమ్మకంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ఆమె మరొకనితో శయనించి, తన భర్తకు తెలియకుండా ఈ విషయం దాచిపెడుతుంది. ఆమె చేసిన తప్పునుగూర్చి ఆమె భర్తకు ఎప్పటికి తెలియకపోవచ్చు. ఆమె ఆ పాపం చేసిందని అతనితో చెప్పే వారు ఎవరూ ఉండక పోవచ్చు. మరియు ఆ స్త్రీ తన పాపం విషయం తన భర్తకు చెప్పకపోవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","కానీ, తన భార్య తనకు వ్యతిరేకంగా పాపం చేసిందని ఆ భర్త అనుమానించటం ప్రారంభం కావచ్చు. అతనిలో కోపం కలుగుతూ వుండవచ్చు. ఆమె పవిత్రంగా లేదని, తనకు నమ్మకంగా లేదని అతనిలో అనుమానం ఏర్పడుతూ ఉండవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","అలా జరిగితే, అతడు తన భార్యను యాజకుని దగ్గరకు తీసుకునిపోవాలి. ఆ భర్త ఒక అర్పణకూడ తీసుకొని వెళ్లాలి. ఆ అర్పణ తూమెడు యవలపిండిలో పదోవంతు. యవలపిండిలో నూనెగాని సాంబ్రాణిగాని వేయకూడదు. ఈ యవల పిండి యెహోవాకు ధాన్యార్పణ. భర్త రోషం మూలంగా అది అర్పించబడింది. అతని భార్య అతనికి అపనమ్మకంగా ఉందని అతడు నమ్ముతున్నట్టు ఈ అర్పణ సూచిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“యాజకుడు ఆ స్త్రీని యెహోవా ఎదుట నిలువబెడ్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","అప్పుడు యాజకుడు మట్టి పాత్రలో పవిత్ర జలం పోస్తాడు. పవిత్ర గుడాకంలోని నేల మీద మట్టి కొంత తీసుకుని, దానిని ఆ నీళ్లలో వేస్తాడు యాడకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ఆ స్త్రీని యెహోవా ఎదుట నిలచివుండమని యాజకుడు ఆమెను బలవంతం చేస్తాడు. అప్పుడతడు ఆమె తల వెంట్రుకలను వదులుగా విడిచి, ధాన్యార్పణను ఆమె చేతిలో పెడతాడు. ఇది తన భర్త రోషం విషయం అర్పించే యవల పిండి. అదే సమయంలో పవిత్ర జలం ఉన్న మట్టి పాత్రను అతడు పట్టుకొంటాడు. ఇది ఆ స్త్రీకి చిక్కుతెచ్చిపెట్టే పవిత్ర జలం. ");
INSERT INTO tel2010_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","“అప్పుడు అబద్ధం చెప్పకూడదని యాజకుడు ఆ స్త్రీతో చెబుతాడు. సత్యం చెబుతానని ఆమె వాగ్ధానం చేయాలి. యాజకుడు ఆమెతో ఇలా అంటాడు, ‘నీవు ఇంకో మగవాడితో శయనించి ఉండకపోతే, నీ భర్తను పెళ్లాడిన నీవు, అతనికి వ్యతిరేకంగా పాపం చేసి ఉండకపోతే, కష్టం కలిగించే ఆ జలం నీకు హాని చేయదు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","కానీ నీవు నీ భర్తకు వ్యతిరేకంగా పాపం చేసి ఉంటే, నీవు మరో మగవాడితో శయనించి ఉంటే నీకు ఏదో కీడు జరుగుతుంది. నీవు పవిత్రురాలివి కాదు. ఎందు చేతనంటే నీ భర్తకాని వాడైన పర పురుషుడు నీతో శయనించి నిన్ను అపవిత్రం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","కనుక నీవు ప్రత్యేక జలం తాగినప్పుడు నీకు గొప్ప కీడు సంభవిస్తుంది. నీ కడుపు ఉబ్బిపోతుంది, ఇంక నీకు పిల్లలు పుట్టరు. నీవు గర్భవతివి అయితే నీ శిశువు చనిపోతుంది. అప్పుడు నీ వాళ్లంతా నిన్ను విడిచిపెట్టేసి, నిన్నుగూర్చి చెడుదా చెప్పుకొంటారు.’ “ఆ స్త్రీ యెహోవాకు ప్రత్యేక ప్రమాణం చేయాలని యాజకుడు ఆమెతో చెప్పాలి. ఆ స్త్రీ అబద్ధం గనుక చెబితే ఈ కీడు తనకు జరుగుతుందని ఒప్పుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","‘నీ శరీరంలో హాని కలిగించే ఈ నీళ్లు నీవు తాగాలి. నీవు పాపం చేసి ఉంటే నీకు పిల్లలు పుట్టరు, నీకు కలిగే ఏ శిశువైనా సరే పుట్టక ముందే చనిపోతుంది’ అని యాజకుడు చెప్పాలి. అప్పుడు ఆ స్త్రీ ‘నీవు చెప్పినట్టు చేయటానికి నేను ఒప్పుకుంటున్నాను’ అని చెప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“యాజకుడు ఈ హెచ్చరికలను ఒక పత్రంమీద వ్రాయాలి. అప్పుడు అతడు ఆ మాటలను నీళ్లలోనికి తుడిచివేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","అప్పుడు హాని కలిగించే ఆ నీళ్లను ఆ స్త్రీ తాగుతుంది. ఆ నీళ్లు ఆమెలో ప్రవేశించి, ఆమె దోషి అయితే, ఆమెకు చాల శ్రమ కలిగిస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","“అప్పుడు యాజకుడు ఆమె దగ్గరనుండి ధాన్యార్పణ తీసుకుని (రోషమునకు అర్పించు అర్పణ) దానిని యెహోవా ఎదుట పైకి ఎత్తుతాడు. తర్వాత బలిపీఠం దగ్గరకు దానిని తెస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ఆ తర్వాత యాజకుడు తన చేతినిండా ధాన్యార్పణ పట్టుకొని బలిపీఠం మీద ఉంచుతాడు. అప్పుడు అతడు దానిని దహిస్తాడు. ఆ తర్వాత ఆ నీళ్లు త్రాగమని అతడు ఆ స్త్రీతో చెబుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ఆ స్త్రీ తన భర్తకు వ్యతిరేకంగా పాపం గనుక చేసి ఉంటే, ఆ నీళ్లు ఆమెకు హాని కలిగిస్తాయి. ఆ నీళ్లు ఆమె శరీరంలోనికి పోయి, ఆమెకు చాలా శ్రమ కలిగిస్తాయి. ఆమెలో ఏదైనా శిశువు ఉంటే అది పుట్టక ముందే మరణిస్తుంది, ఆమె ఎన్నటికీ పిల్లలను కనదు. ప్రజలంతా ఆమెకు వ్యతిరేకం అవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","కానీ ఆస్త్రీ తన భర్తకు వ్యతిరేకంగా పాపం చేసి ఉండకపోతే, ఆమె పవిత్రంగా ఉంటే అప్పుడు ఆమె నిర్దోషి అని యాజకుడు చెబుతాడు. అప్పుడు ఆమె మామూలుగా ఉండి పిల్లలను కనగల్గుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“అందుచేత రోషమునుగూర్చిన ఆజ్ఞ ఇది. తన భర్తతో వివాహం జరిగిన ఒక స్త్రీ తన భర్తకు వ్యతిరేకంగా పాపం చేసినప్పుడు నీవు చేయాల్సింది ఇది. ");
INSERT INTO tel2010_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","లేక ఒకడు తన భార్య తనకు వ్యతిరేకంగా పాపం చేసిందని అనుమానించినప్పుడు అతడు చేయాల్సింది ఇది. ఆ స్త్రీని యెహోవా యెదుట నిలువమని యాజకుడు చెప్పాలి. అప్పుడు యాజకుడు ఇవన్నీ చేయాలి. ఇది ఆజ్ఞ. ");
INSERT INTO tel2010_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ఇలా చేసినందువల్ల భర్త తప్పు చేసినట్టు కాదు. కానీ ఆ స్త్రీ మాత్రం పాపం చేసి ఉంటే శ్రమ అనుభవిస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","మోషేతో యెహోవా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“ఇశ్రేయేలీయులతో ఈ విషయాలు చెప్పు: ఒక పురుషుడు గాని స్త్రీగాని కొన్నాళ్ల పాటు ఒకరినుండి ఒకరు ప్రత్యేకంగా ఉండాలని కోరవచ్చును. ఈ ప్రత్యేకించు కోవటంలో ఉద్దేశం, అతడు ఆ వ్యవధిలో తనను తాను సంపూర్ణంగా యెహోవాకు అర్పించుకోవటమే. అతడు నాజీరు అని పిలువబడతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ఆ కాలంలో అతడు ద్రాక్షామద్యంగాని ఇంకే మత్తు పానీయంగాని తాగకూడదు. ద్రాక్షారసంనుండి తీయబడిన చిరకను గాని ఇంకే మప్త సానీయంగాని అతడు తాగకూడదు. ద్రాక్షాపండ్లుగాని, ఎండిన ద్రాక్షాలుగాని అతడు తినకూడదు, ద్రాక్షారసం తాగకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","వేరుగా ఉండే ఆ ప్రత్యేక సమయంలో ద్రాక్షానుండి వచ్చేది ఏదీ అతడు తినకూడదు. ద్రాక్షాగింజలను, దాని తోలును కూడ అతడు తినకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“అలా వేరుగా ఉండే కాలంలో అతడు తన తల వెంట్రుకలు కత్తిరించుకోకూడదు. అతడు వేరుగా ఉండాల్సిన రోజులు గడచిపోయేంతవరకు అతడు పవిత్రంగా ఉండాలి. అతడు తన వెంట్రుకలను పొడవుగా పెరగనివ్వాలి. అతడు దేవునికి చేసిన వాగ్దానంలో అతని తల వెంట్రుకలు ఒక భాగం. ఆ వెంట్రుకలను ఒక కానుకగా అతడు దేవునికి ఇస్తాడు. అందుచేత వేరుగా ఉండే సమయం అయిపోయేంత వరకు అతడు తన తల వెంట్రుకలను పొడవుగా పెంచాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“నాజీరు వేరుగా ఉన్న సమయంలో, అతడు శవాన్ని సమీపించకూడదు. ఎందుచేతనంటే అతడు తనను తాను పూర్తిగా యోహోవాకు అర్పించుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","అతని సొంత తండ్రి లేక తల్లి, సోదరుడు లేక సోదరి చనిపోయినా సరే అతడు వారిని తాకగూడదు. అలా తాకితే అతడు అపవిత్రుడవుతాడు. అతడు ప్రత్యేకించుకొన్నట్టు, పూర్తిగా యెహోవాకు అర్పించు కొన్నట్టు అతడు చూపెట్టుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","అతడు వేరుగా ఉన్న కాలమంతటిలో తనను తాను పూర్తిగా యెహోవాకు అర్పించుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","నాజీరు మరొకనితో ఉన్నప్పుడు, ఆ మరొకడు అకస్మాత్తుగా మరణించవచ్చును. చనిపోయినవానిని నాజీరు ముట్టినట్టయితే నాజీరు అపవిత్రుడవుతాడు. ఇలా జరిగినట్లయితే నాజీరు తన తల వెంట్రుకలను తీసివేయాలి. (ఆ వెంట్రుకలు అతని ప్రమాణంలో ఒక భాగం.) ఏడో రోజున అతడు తన వెంట్రుకలను తీసివేయాలి. ఎందుచేతనంటే ఆ రోజునే అతడు శుద్ధి చయబడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ఎనిమిదో రోజున అతడు రెండు గువ్యలను, రెండు పావురపు పిల్లలను యాజకుని దగ్గరకు తీసుకుని రావాలి. పవిత్ర గుడార ద్వారం దగ్గరే అతడు వాటిని యాజకునికి ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","అప్పుడు యాజకుడు పాపపరిహారార్థబలిగా ఒకదాన్ని అర్పిస్తాడు. రెండో దానిని దహన బలిగా అతడు అర్పిస్తాడు. ఈ దహనబలి ఆ మనిషి చేసిన పాపానికి ప్రాయశ్చిత్తం. (అతడు శవం దగ్గర ఉండటమే అతని పాపం.) అతడు తన తలవెంట్రుకలను దేవునికి ఇస్తానని ఆ సమయంలో మరల ప్రమాణం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","అనగా అతడు మరల ప్రత్యేకంగా ఉండేందుకు తనను యెహోవాకు అర్పించుకోవాలని దీని అర్థం. ఒక సంవత్సరం వయసు గల ఒక మగ గొర్రెపిల్లను అతడు తీసుకురావాలి. అపరాధ పరిహారార్థ బలిగా అతడు దీనిని ఇవ్వాలి. అతడు ప్రత్యేకంగా ఉన్న రోజులన్నీ మరచిపోవటం జరిగింది. అతడు మరల ప్రత్యేకంగా ఉండటం ప్రారంభించాలి. అతడు మొదటిసారి ప్రత్యేకంగా ఉన్నప్పుడు శవాన్ని ముట్టినందువల్ల ఇలా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ఆ మనిషి ప్రత్యేకంగా ఉండాల్సిన సమయం అయిపోయిన తర్వాత అతడు ఇలా చేయాలి: సన్నిధి గుడార ద్వారం దగ్గరకు అతడు వెళ్లాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","అక్కడ తన అర్పణను అతడు యెహోవాకు ఇవ్వాలి. అతని అర్పణ ఏమిటంటే: దహనబలి కోసం ఒక్క సంవత్సరపు మగ గొర్రెపిల్ల. (ఈ గొర్రెపిల్లకు ఎలాంటి లోపం ఉండకూడదు.) పాప పరిహారార్థబలి కోసం ఒక్క సంవత్సరపు ఆడ గొర్రెపిల్ల. (ఈ గొర్రెపిల్లకు ఎలాంటి లోపం ఉండ కూడదు.) సమాధాన బలికోసం ఒక్క మగ గొర్రె (ఈ గొర్రెకు ఎలాంటి లోపం ఉండ కూడదు.) ");
INSERT INTO tel2010_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ఒక గంపనిండా పొంగనిపిండి రొట్టెలు, (నూనెతో చేసిన మంచి గోధుమపిండి రొట్టెలు, ఈ రొట్టెల మీద నూనెపూయాలి). ధాన్యార్పణ, పానార్పణ ఈ కానుకలలో భాగంగా వుండాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“అప్పుడు యాజకుడు వీటిని యెహోవాకు అర్పిస్తాడు. పాపపరిహారార్థబలిని, దహనబలిని యాజకుడు అర్పిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","రొట్టెలబుట్టను యాజకుడు యెహోవాకు అర్పిస్తాడు. తర్వాత యెహోవాకు సమాధానబలిగా మగ గొర్రెను అతడు వధిస్తాడు. ధాన్యార్పణ, పానార్పణాలతో అతడు దానిని యెహోవాకు అర్పిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“సన్నిధి గుడారపు ప్రవేశం దగ్గరకు వాజీరు వెళ్లాలి. యెహోవాకోసం అతడు పెంచిన తలవెంట్రుకలను అక్కడ అతడు తీసివేయాలి. సమాధాన బలియాగం క్రింద మండుతున్న మంటల్లో ఆ వెంట్రుకలు వేయబడుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“నాజీరు తన తల వెంట్రుకలు తీసివేసిన తర్వాత, ఉడికిన మగ గొర్రె జబ్బను, గంపలో నుండి పెద్దది ఒకటి, చిన్నది ఒకటి, రెండు రొట్టెలను యాజకుడు అతనికి ఇస్తాడు. ఈ రెండు రొట్టెలు పులియని పిండితో చేయబడినవి. ");
INSERT INTO tel2010_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","అప్పుడు యాజకుడు వీటిని యెహోవా ముందర అల్లాడిస్తాడు. ఇది నైవేద్యము. ఇవి పవిత్రమైనవి, యాజకునికి చెందుతాయి. మరియు మగ గొర్రె బోర, తొడ యెహోవా ముందర అల్లాడించబడుతాయి. ఇవికూడా యాజకునికి చెందుతాయి. ఆ తర్వాత నాజీరు ద్రాక్షారసం తాగవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ఒక వ్యక్తి నాజీరుగా ప్రత్యేకించబడాలని నిర్ణయించుకొంటే, అప్పుడు అతడు ఈ కానుకలన్నీ యెహోవాకు అర్పించాలి. నాజీరు ప్రయాణానికి సంబంధించిన చట్టం అది. అయితే ఒక వ్యక్తి ఇంతకంటె చాల ఎక్కువే యెహోవాకి ఇవ్వగలిగి ఉండొచ్చు. అలాంటివాడు ఎక్కువ చేస్తానని వాగ్దనంచేస్తే, అతడు తన వాగ్దానాన్ని నిలబెట్టుకోవాలి. అది కూడ నాజీరు వాగ్దానపు చట్టమే.” ");
INSERT INTO tel2010_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","మోషేతో యెహోవా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“అహరోను, అతని కుమారులతో ఇలా చెప్పు. ఇశ్రేయేలు ప్రజలను మీరు ఈ విధంగా ఆశీర్వదించాలి. వారు ఇలా అనాలి: ");
INSERT INTO tel2010_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","‘యెహోవా నిన్ను ఆశీర్వదించి కాపాడును గాక. ");
INSERT INTO tel2010_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","యెహోవా తన ముఖకాంతిని నీపై ప్రకాశింప చేయును గాక. ఆయన తన ప్రేమను నీకు కనబర్చును గాక. ");
INSERT INTO tel2010_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","యెహోవా నిన్ను చూచి, నీకు సమాధానం అనుగ్రహించును గాక.’ ");
INSERT INTO tel2010_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","అప్పుడు యెహోవా, ఈ విధంగా అహరోను, అతని కుమారులు ఇశ్రేయేలీయులను నా నామమును బట్టి ఆశీర్వదించినట్లు పలికినప్పుడు నేను వారిని ఆశీర్వదిస్తాను” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","పవిత్ర గుడారాన్ని నిలబెట్టడం మోషే ముగించిన రోజే దానిని అతడు యెహోవాకు ప్రతిష్ఠించాడు. గుడారం మీద, దానిలో ప్రయోగించే పరికరాలన్నింటి మీద ప్రత్యేక తైలం పోసాడు. బలిపీఠం మీద, దానితో ఉపయోగించే వాటన్నింటి మీద మోషే ఆ తైలంపోసాడు. ఇది వీటన్నింటినీ పవిత్రం చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","అప్పుడు ఇశ్రేయేలీయుల నాయకులు అర్పణలు అర్పించారు. వీరు ఒక్కో కుటుంబానికి నాయకులు, వారి వంశాల పెద్దలు. ఈ నాయకులు ప్రజలను లెక్కబెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ఈ నాయకులు యెహోవాకు అర్పణలు తెచ్చారు. ఆరు గూడు బండ్లను, వాటిని లాగటానికి పన్నెండు ఎద్దులను వీరు తెచ్చారు. (ఒక్కో ఎద్దును ఒక్కో నాయకుడు ఇచ్చాడు. ఒక్కో నాయకుడు మరో నాయకునితో కలిసి ఒక బండిని ఇచ్చాడు.) పవిత్ర గుడారం దగ్గర నాయకులు వీటిని యెహోవాకు ఇచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","మోషేతో యెహోవా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“నాయకుల దగ్గర నుండి ఈ కానుకులు స్వీకరించు. సన్నిధి గుడారపు పనిలో ఈ కానుకలను ఉపయోగించవచ్చు. లేవీవాళ్లకు వీటిని ఇవ్వు. వాళ్లు వారి పని చేసుకొనేందుకు ఇవి సహాయపడ్తాయి.” ");
INSERT INTO tel2010_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","కనుక ఆ బండ్లను, ఎద్దులను మోషే స్వీకరించాడు. వీటిని లేవీ మనుష్యులకు అతడు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","గెర్షోను మనుష్యులకు రెండు బండ్లు, నాలుగు ఎడ్లు అతడు ఇచ్చాడు. వారి పనికోసం ఎడ్లు, బండ్లు వారికి అవసరం. ");
INSERT INTO tel2010_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","తర్వాత మెరారి మనుష్యులకు నాలుగు బండ్లు, ఎనిమిది ఎడ్లు మోషే ఇచ్చాడు. వారి పనికోసం ఎడ్లు, బండ్లు వారికి అవసరం. ఆ మనుష్యులందరి పనికి యాజకుడైన అహరోను కుమారుడు ఈతమారు బాధ్యుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","కహాతీ మనుష్యులకు బండ్లుగాని, ఎడ్లుగాని ఏమీ మోషే ఇవ్వలేదు. వీళ్లు పవిత్ర వస్తువులన్నింటినీ వారి భుజాలమీదే మోయాలి. ఇది వారు చేసేందుకు ఇవ్వబడిన పని. ");
INSERT INTO tel2010_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","బలిపీఠం ప్రతిష్ఠించబడిన తర్వాత నాయకులు వారి అర్పణలు అక్కడకు తీసుకునివచ్చారు. ఆ బలిపీఠం ఎదుట వారు వారి అర్పణలను యెహోవాకు అర్పించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","“ఒక్కో నాయకుడు ఒక్కో రోజున బలిపీఠం ప్రతిష్ఠలో తన వంతుగా తన అర్పణలు తీసుకుని రావాలి” అని యెహోవా అంతకు ముందే మోషేతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","పన్నెండుమంది నాయకుల్లో ప్రతి ఒక్కరూ పవిత్ర గుడారపు ప్రతిష్ఠకోసం తమ అర్పణలను తెచ్చారు. ఆ కానుకలు ఏవనగా: ఒక్కొక్క నాయకుడు 130 తులముల బరువుగల ఒక వెండి పళ్లెం తెచ్చాడు. ఒక్కొక్క నాయకుడు 70 తులాల బరువుగల వెండి గిన్నె తెచ్చాడు. నూనెతో కలిపిన మంచి గోధుమ పిండితో ఆ పళ్లెం, గిన్నె నింపాడు. ఇది ధాన్యార్పణ కోసం ఉపయోగించేది. 10 తులాల బరువుగల బంగారు ధూపార్తిని ఒక్కొక్క నాయకుడు ఒక్కొక్కటి తెచ్చాడు. ధూపార్తి ధూపంతో నింపబడింది. ఒక్కొక్క నాయకుడు ఒక కోడెదూడను, ఒక పొట్టేలును, ఒక సంవత్సరపు మగ గొర్రెపిల్లను తీసుకునివచ్చాడు. ఈ జంతువులు దహనబలికోసం. పాపపరిహారార్థ బలిగా ఉపయోగించటంకోసం, ప్రతి నాయకుడూ ఒక మగ మేకను తెచ్చాడు. ప్రతి నాయకుడూ రెండు కోడెదూడలను, ఐదు పొట్టేళ్లను, ఐదు మగ మేకలను, ఒక సంవత్సరపు మగ గొర్రెపిల్లలు ఐదింటిని తీసుకొని వచ్చాడు. ఇవన్నీ సమాధాన బలిగా ఇవ్వబడ్డాయి. మొదటి రోజున యూదా కుటుంబ నాయకుడును, అమ్మీనాదాబు కుమారుడునైన నయస్సోను తన అర్పణలు తీసుకుని వచ్చాడు. రెండో రోజున ఇశ్శాఖారు ప్రజల నాయకుడు, సూయారు కుమారుడైన నెతనేలు తన అర్పణలు తీసుకుని వచ్చాడు. మూడో రోజున జెబూలూను ప్రజల నాయకుడు, హెలోను కుమారుడైన ఎలియాబు తన అర్పణలు తీసుకొనివచ్చాడు. నాలుగో రోజున రూబేను ప్రజల నాయకుడునైన షెదేయూరు కుమారుడునైన ఏలీసూరు తన అర్పణలు తీసుకొని వచ్చాడు. ఐదో రోజున షిమ్యోను ప్రజల నాయకుడును, సూరీషద్దాయి కుమారుడైన షెలుమీయేలు తన అర్పణలు తీసుకొని వచ్చాడు. ఆరో రోజున గాదు ప్రజల నాయకుడు, దెయూవేలు కుమారుడునైన ఎలీయాసాపా తన అర్పణలు తీసుకుని వచ్చాడు. ఏడో రోజున ఎఫ్రాయిము ప్రజల నాయకుడును, అమీహోదు కుమారుడు ఎలీషామా తన అర్పణలు తీసుకుని వచ్చాడు. ఎనిమిదో రోజున మనష్షే ప్రజల నాయకుడును, పెదాసూరు కుమారుడునైన గమలీయేలు తన అర్పణలు తీసుకుని వచ్చాడు. తొమ్మిదో రోజున బెన్యామీను ప్రజల నాయకుడును, గిద్యోనీ కుమారుడునైన అబీదాని తన అర్పణలు తీసుకుని వచ్చాడు. పదో రోజున దాను ప్రజల నాయకుడును, అమీషదాయి కుమారుడైన అహీయెజెరు తన అర్పణలు తీసుకుని వచ్చాడు. పదకొండవ రోజున ఆషేరు ప్రజల నాయకుడు, ఒక్రాను కుమారుడైన పగీయేలు తన అర్పణలు తీసుకుని వచ్చాడు. పన్నెండో రోజున నఫ్తాలీ ప్రజల నాయకుడైన, ఏనాను కుమారుడైన అహీర తన అర్పణలు తీసుకుని వచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","కనుక ఇవన్నీ ఇశ్రాయేలు ప్రజల నాయకులనుండి వచ్చిన కానుకలు. మోషే ప్రత్యేక తైలము పోసి బలిపీఠాన్ని ప్రతిష్ఠించిన సందర్భంలో వారు ఈ వస్తువులను తెచ్చారు. వెండి పళ్లెములు పన్నెండు, వెండిగిన్నెలు పన్నెండు, బంగారు ధూపార్తులు పన్నెండు వారు తీసుకుని వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ఒక్కో వెండి పళ్లెం బరువు 130 తులాలు. ఒక్కో గిన్నె బరువు 70 తులాలు. వెండిపళ్లాలు, వెండిగిన్నెలు అన్నీ కలిసి 2,400 తులాల బరువు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ధూపద్రవ్యంతో నిండిన పన్నెండు బంగారు ధూపార్తులలో ఒక్కొక్కటి పది తులాల బరువు. మొత్తం పన్నెండు బంగారు ధూపార్తులు కలిసి 120 తులాల బరువు కలవి. ");
INSERT INTO tel2010_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","దహలబలి అర్పణకు మొత్తం జంతువులు పన్నెండు కోడెదూడలు, పన్నెండు పొట్టేళ్లు, ఒక్కో సంవత్సరపు మగ గొర్రెపిల్లలు పన్నెండు. ధాన్యార్పణ కూడా ఉంది. పాపపరిహారార్థ బలిగా యెహోవాకు అర్పించేందుకు పన్నెండు మగ మేకలు కూడా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","సమాధాన బలిగా వధించి ఉపయోగించేందుకు కూడ నాయకులు జంతువులను ఇచ్చారు. ఈ జంతువులు మొత్తం 24 కోడెదూడలు, 60 పొట్టేళ్లు, 60 మగ మేకలు, ఒక్క సంవత్సరపు మగ గొర్రెపిల్లలు 60 బలిపీఠం ప్రతిష్ఠ సమయంలో ఇవన్నీ అర్పణలుగా ఇవ్వబడ్డాయి. ఈ విధంగా బలిపీఠం మీద ప్రత్యేక తైలాన్ని మోషే పోసిన తర్వాత వారు ప్రతిష్ఠించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","యెహోవాతో మాట్లాడేందుకు మోషే సన్నిధి గుడారంలోకి వెళ్లాడు. ఆ సమయంలో అతనితో మాట్లాడుతున్న యెహోవా స్వరం అతడు విన్నాడు. ఒడంబడిక పెట్టెపైనున్న కరుణాపీఠంమీది రెండు కెరూబుదూతల మధ్య భాగంనుండి ఆ స్వరం వస్తోంది. ఇలా దేవుడు మోషేతో మాటలాడెను. ");
INSERT INTO tel2010_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","మోషేతో యెహోవా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“అహరోనుతో మాట్లాడి అతనితో ఇలా చెప్పు, నేను నీకు చూపించిన స్థలంలో ఏడు దీపాలను ఉంచు. దీపస్తంభం ముందు భాగాన్ని ఆ దీపాలు వెలిగించాలి.” ");
INSERT INTO tel2010_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","అహరోను అలా చేసాడు. అహరోను ఆ దీపాలను సరైన చోట పెట్టి, దీపస్తంభం ముందు భాగాన్ని అవి వెలిగించేటట్టుగా అతడు వాటిని ఉంచాడు. మోషేకు యెహోవా ఇచ్చిన ఆజ్ఞకు అతడు విధేయుడయ్యాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","దీపస్తంభం కొట్టబడిన బంగారంతో చేయబడింది. దిమ్మదగ్గర మొదలుకొని బంగారు పూలవరకు అంతా బంగారమే. మోషేకు యెహోవా చూపించిన ప్రకారమే అదంతా చేయబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","మోషేతో యెహోవా అలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ఇశ్రాయేలీయులలో ఇతరులనుండి లేవీ ప్రజలను వేరు చేయి. ఆ లేవీ మనుష్యులను శుద్ధి చేయి. ");
INSERT INTO tel2010_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","వారిని శుద్ధి చేసెందుకు నీవు చేయాల్సింది ఇదే. పాప పరిహారార్థ అర్పణనుండి ప్రత్యేక జలాన్ని వారిమీద చల్లాలి. ఈ జలం వారిని శుద్ధి చేస్తుంది. అప్పుడు వారు శరీరం అంతటా క్షవరం చేసుకొని, వారి బట్టలు ఉదుకు కోవాలి. ఇది వారి శరీరాలను పవిత్రం చేస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","“అప్పుడు వారు ఒక కోడెదూడను, దానికి సంబంధించిన ధాన్యార్పణను తీసుకోవాలి. ఈ ధాన్యార్ఫణ నూనెతో కలుపబడ్డ గోధుమపిండి. అప్పుడు పాపపరిహారార్థ బలిగా ఇంకో కోడెదూడను తీసుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","లేవీ ప్రజలను సన్నిధి గుడారం ఎదుటి భాగంలోనికి తీసుకునిరావాలి. అప్పుడు ఇశ్రాయేలు ప్రజలందరినీ చుట్టూరా సమావేశపర్చాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","అప్పుడు నీవు లేవీ ప్రజలను యెహోవా ఎదుటికి తీసుకునిరావాలి. ఇశ్రాయేలు ప్రజలు వారిమీద తమ చేతులు ఉంచుతారు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","అప్పుడు అహరోను లేవీ మనుష్యులను యెహోవా ఎదుట కనపరుస్తాడు. వారు దేవునికి ఒక అర్పణవలె ఉంటారు. ఈ విధంగా యెహోవాకు ప్రత్యేక పని చేసేందుకు లేవీ ప్రజలు సిద్ధంగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“లేవీ మనుష్యులు కోడెదూడ తలలమీద చేతులు ఉంచాలని వారితో చెప్పు. ఒక కోడెదూడ పాపపరిహారార్థ బలిగాను మరొక కోడెదూడ దహన బలిగాను యెహోవాకు అర్పించాలి. ఈ అర్పణలు లేవీ ప్రజల పాపాలను కప్పిపుచ్చుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","అహరోను, అతని కుమారుల ఎదుట నిలబడమని లేవీ మనుష్యులతో చెప్పు. అప్పుడు ఒక ప్రతిష్ఠ అర్పణగా లేవీ మనుష్యులను యెహోవాకు అర్పించు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ఈ విధంగా లేవీ మనుష్యులు ప్రత్యేకం అవుతారు. ఇశ్రాయేలీయులలో ఇతరులకు వీరు వేరుగా ఉంటారు. లేవీ ప్రజలు నావారై ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“కనుక లేవీ మనుష్యులను పవిత్రం చేయి. ప్రతిష్ఠార్పణగా వారిని యెహోవాకు అర్పించు. ఇలా చేసిన తర్వాత వారు సన్నిధి గుడారంలోనికి వచ్చి వారి పని చేయవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","ఈ లేవీయులు నాకు ఇవ్వబడిన ఇశ్రాయేలు ప్రజలు. వారిని నా స్వంత ప్రజలుగా నేను స్వీకరించాను. గతంలో ఇశ్రాయేలీయుల ప్రతి కుటుంబంలో ప్రతి పెద్ద కుమారుడు నాకు ప్రతిష్ఠించబడ్డాడు. అయితే ఇశ్రాయేలుల్లో ఇతరుల జ్యేష్ఠ కుమారుల బదులు లేవీయులు మనుష్యులను నేను స్వీకరించాను. ");
INSERT INTO tel2010_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","ఇశ్రాయేలీయుల ప్రతి కుటుంబములో మొదట పుట్టిన ప్రతి మగ శిశువు నావాడే. అది మనిషిగాని పశువుగాని నాకే. ఎందుకంటే ఈజిప్టులో మొదట పుట్టిన పిల్లలను, జంతువులనుగూడ నేను చంపేసాను, కనుక మొదట పుట్టినవారు నావారై ఉండాలని పెద్ద కుమారులను మీ నుండి వేరు చేసాను. ");
INSERT INTO tel2010_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","ఇప్పుడు నేను లేవీ మనుష్యులను తీసుకున్నాను. ఇశ్రాయేలు కుటుంబాల్లో మొదటగా పుట్టిన కుమారులందరి స్థానంలో నేను వీరిని తీసుకున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ఇశ్రాయేలు ప్రజలందరిలోనుండి లేవీ మనష్యులను నేను ఏర్పాటు చేసుకున్నాను. నేను వారిని అహరోనుకు అతని కుమారులకు కానుకలుగా ఇచ్చాను. సన్నిధి గుడారం దగ్గర వారు పని చేయాలని నేను కోరుతున్నాను. ఇశ్రాయేలు ప్రజలందరి పక్షంగా వారు సేవ చేస్తారు. ఇశ్రాయేలు ప్రజల పాపాలను కప్పిపుచ్చే బలులు అర్పించుటలో వారు సహాయం చేస్తారు. అప్పుడు ఇశ్రాయేలు ప్రజల పవిత్ర స్థలాన్ని సమీపించినా ఏ గొప్ప రోగంగాని, కష్టంగాని వారికి కలుగదు.” ");
INSERT INTO tel2010_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","కనుక మోషే, అహరోను, ఇశ్రాయేలు ప్రజలందరు యెహోవాకు విధేయులయ్యారు. యెహోవా మోషేకు ఆజ్ఞాపించిన దానిని లేవీ మనుష్యులకు వారు జరిగించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","లేవీ ప్రజలు పవిత్రులయ్యారు. వారు వారిని శుద్ధి చేసుకున్నారు, వారి వస్త్రాలు ఉదుకు కొన్నారు. అప్పుడు అహరోను వారిని యెహోవా ఎదుట ప్రతిష్టార్పణగా అర్పించాడు. వారి పాపాలను క్షమించే అర్పణలను కూడా అర్పించి, అహరోను వారిను పవిత్రం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ఆ తర్వాత లేవీ మనుష్యులు వారి పని చేసుకొనేందుకు సన్నిధి గుడారానికి వచ్చారు. అహరోను, అతని కుమారులు వారిని పర్యవేక్షించారు. లేవీ ప్రజల పనికి వారు బాధ్యులు. యెహోవా మోషేకు ఇచ్చిన ఆజ్ఞకు అహరోను, అతని కుమారులు విధేయులయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ఇది లేవీ ప్రజలకు ఒక ప్రత్యేక ఆజ్ఞ. 25 సంవత్సరాలు, అంతకంటె ఎక్కువ వయసుగల ప్రతి లేవీ మనిషి సన్నిధి గుడారం దగ్గరకు వచ్చి అక్కడ పని చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","అయితే ఒకని వయసు 50 సంవత్సరాలు ఉన్నప్పుడు, అతడు తన దినచర్యనుండి విశ్రాంతి తీసుకోవాలి. అతడు తిరిగి పని చేయాల్సిన అవసరం లేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","50 సంవత్సరాలు, అంతకంటె ఎక్కువ వయసుగల పురుషులు సన్నిధి గుడారం దగ్గర వారి సోదరులకు సహాయం చేయవచ్చును. కాని వారే స్వయంగా ఆ పని చేయకూడదు. వారిని విరమించుకోనివ్వవచ్చు. లేవీ ప్రజలకు వారి పనులను చెప్పేటప్పుడు ఇది చెప్పటం జ్ఞాపకం ఉంచుకో.” ");
INSERT INTO tel2010_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","సీనాయి అరణ్యంలో మోషేతో యెహోవా మాట్లాడాడు: ఇశ్రాయేలీయులు ఈజిప్టు నుండి బయటకు వచ్చిన తర్వాత ఒక సంవత్సరం, ఒక మాసం నాటి మాట ఇది. మోషేతో యెహోవా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“నిర్ణీత సమయంలో పస్కా విందు భోజనం చేయటం జ్ఞాపకం ఉంచుకోవాలని ఇశ్రాయేలు ప్రజలతో చెప్పు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ఈ నెల పద్నాల్గవ రోజు ఆ నిర్ణీత సమయం. మసక చీకటి వేళ వారు ఆ విందు భోజనం చేయాలి. మరియు విందునుగూర్చి నేను ఇచ్చిన నియమాలన్నింటినీ వారు జ్ఞాపకం ఉంచుకోవాలి.” ");
INSERT INTO tel2010_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","కనుక పస్కా విందుభోజనం చేయటం జ్ఞాపకం ఉంచుకోమని ఇశ్రాయేలు ప్రజలకు మోషే చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","పద్నాల్గవ రోజున మసక చీకటివేళ సీనాయి అరణ్యంలో ప్రజలు ఇది చేసారు. ఇది మొదటి నెలలో. మోషేకు యెహోవా ఆజ్ఞాపించిన దానంతటి ప్రకారం ఇశ్రాయేలీయులు జరిగించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","అయితే ఆ రోజున కొందరు ప్రజలు పస్కా విందు భోజనం చేయలేకపోయారు. ఒక శవంమూలంగా వారు అపవిత్రులయ్యారు. కనుక ఆ రోజున మోషే అహరోనుల దగ్గరకు వారు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“ఒక శవం మూలంగా మేము ‘అపవిత్రులమయ్యాము’ అయితే ఇశ్రాయేలీయుల్లోని ఇతరులతో కలిసి మేము కూడ యెహోవాకు ఈ నిర్ణీత సమయంలో కానుకలు అర్పించటంలోను పస్కా ఆచరించుటలోను యాజకులు అడ్డుకొన్నారు” అని ఆ ప్రజలు మోషేతో చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","“దీన్ని గూర్చి యెహోవా ఏమంటాడో నేను అడుగుతాను” అన్నాడు మోషే వారితో. ");
INSERT INTO tel2010_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","అప్పుడు మోషేతో యెహోవా: ");
INSERT INTO tel2010_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“ఇశ్రాయేలీయులతో ఈ విషయాలు చెప్పు, ఒకవేళ సరైన సమయంలో మీరు పస్కాను ఆచరించలేకపోతున్నారేమో. మీరో లేక మీ సంతానంలో వారెవరైనా ఒక శవాన్ని ముట్టినందువల్ల అపవిత్రంగా ఉన్నారేమో. లేదా మీరు ప్రయాణంలో ఉన్నారేమో. ");
INSERT INTO tel2010_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","అయితే మీరు కూడ పస్కాను ఆచరించగలరు గాని నిర్ణీత సమయంలో కాదు. రెండవ నెల పద్నాలుగో రోజు సందెవేళ మీరు పస్కాను ఆచరించాలి. ఆ సమయంలో మీరు గొర్రెపిల్లను, పులియని రొట్టెలను, చేదు ఆకుకూరలను తినాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ఆ భోజనంలో ఏమీ మర్నాటి ఉదయానికి మీరు మిగల్చకూడదు. మరియు ఎముకలు ఏవీ మీరు విరుగగొట్టకూడదు. మీరు పస్కావిందు భోజనం చేసేటప్పుడు నియమాలన్నింటినీ మీరు పాటించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","అయితే ఆచరించగల ప్రతి మనిషి పస్కావిందును నిర్ణీత సమయంలో తినాలి. అతడు పవిత్రుడై, ప్రయాణంలో లేకుండా ఉండి పస్కాను ఆచరించకపోతే, అతనికి క్షమాపణ లేదు. అతుడు నిర్ణీత సమయంలో పస్కా విందుభోజనం చేయకపోతే, అప్పుడు అతడ్ని తన ప్రజల్లోనుంచి వెళ్లగొట్టి వేయాలి. ఎందుచేతనంటే నిర్ణీత సమయంలో అతడు తన అర్పణను యెహోవాకు అర్పించలేదు గనుక అతడు దోషి. ");
INSERT INTO tel2010_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ఇశ్రాయేలీయులకు చెందని ఒకడు మీతో నివసిస్తుంటే, అతడు మీతో కలిసి యెహోవా పస్కాలో పాలు పుచ్చుకోవాలనుకోవచ్చు. ఇది అంగీకారమే గాని మీకు ఇవ్వబడిన నియమాలన్నిటినీ అతడు పాటించాలి. మీకోసం ఉన్న నియమాలే మీరు ఇతరులకోసం కూడ పెట్టాలి.” ");
INSERT INTO tel2010_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","పవిత్ర గుడారం (ఒడంబడిక గుడారం) నిలబెట్టిన రోజున ఒక మేఘం దానిమీద నిలిచింది. రాత్రి పూట ఆ మేఘం అగ్నిలా కనబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ఆ మేఘం రాత్రి అంతా పవిత్ర గుడారం మీదే నిలిచి ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ఆ మేఘం పవిత్ర గుడారం మీద నుండి కదలినప్పుడు ఇశ్రాయేలీయులు దానిని వెంబడించారు. ఆ మేఘం ఆగిపోయినప్పుడు, అక్కడే ఇశ్రాయేలు ప్రజలు గుడారాలు వేసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","ఇశ్రాయేలు ప్రజలను ఈ విధంగా సాగిపొమ్మని యెహోవా ఆజ్ఞాపించాడు అలాగే వారు గుడారాలు వేసే స్థలం విషయంకూడా. ఆయన ఇచ్చిన ఆజ్ఞ ఇదే. మేఘం పవిత్రగుడారం మీద నిలిచి ఉండగా, ప్రజలు ఆ చోటనే నివాసం కొనసాగించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","కొన్నిసార్లు చాలకాలంగా పవిత్ర గుడారంమీదనే ఆ మేఘం నిలిచిపోయేది. ఇశ్రాయేలీయులు యెహోవాకు విధేయులై ముందుకు కదల్లేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","కొన్నిసార్లు కొద్ది రోజులవరకు మాత్రమే మేఘం పవిత్ర గుడారంమీద నిలిచేది. ప్రజలు యెహోవా ఆజ్ఞకు విధేయులయ్యారు. మేఘం కదిలినప్పుడు వారు ఆ మేఘాన్ని వెంబడించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","కొన్నిసార్లు ఆ మేఘము రాత్రి మాత్రమే నిలిచి ఉండేది. ఆ మర్నాడు మేఘము కదలగానే, ప్రజలుకూడా వారి సామగ్రి కూర్చుకొని వెంబడించారు. పగలుకాని రాత్రికాని మేఘము కదిలితే అప్పుడు ప్రజలుకూడా బయల్దేరారు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","రెండు రోజులుకానీ, ఒక నెలకానీ, ఒక సంవత్సరంకానీ ఆ మేఘము పవిత్ర గుడారంమీద నిలిచిన కూడ ప్రజలు యెహోవాకు విధేయులవుతూనే ఉన్నారు. తర్వాత మేఘము తన స్థానంనుండి లేచి బయల్దేరితే, ప్రజలు కూడ బయల్దేరారు. ");
INSERT INTO tel2010_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","కనుక ప్రజలు యెహోవా ఆజ్ఞకు విధేయులయ్యారు. యెహోవా వారికి చూపించిన చోట వారు గుడారాలు వేసారు. మరల బయల్దేరమని యెహోవా ఆజ్ఞాపించగానే వారు బయల్దేరారు, మేఘాన్ని వెంబడించారు. యెహోవా ఆజ్ఞకు ప్రజలులోబడ్డారు. ఇది మోషే ద్వారా ఆయన వారికి ఇచ్చిన ఆజ్ఞ. ");
INSERT INTO tel2010_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“రెండు వెండి బూరలు చేయించు. వెండిని ఉపయోగించి, బూరలు చేసేందుకు దానిని నలుగ గొట్టాలి. ఆ బూరలు ప్రజలందర్నీ సమావేశపర్చి సేనలను ఎప్పుడు బయలుదేరదీయాలో చెప్పటానికి ఉండవలెను. ప్రజలు ఎక్కడ నివాసం చేయాలి అనేది వారికి చెప్పటానికి ఇది నీకు సహాయకరంగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ఆ రెండు బూరలు ఒక ప్రకటనగా ఉంటాయి. ప్రజలంతా అది విని, సన్నిధి గుడార ప్రవేశం దగ్గర నీ ఎదుట కూడుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","నీవు ఒకే బూర ఊదితే నాయకులు (ఇశ్రాయేలు పన్నెండు కుటుంబాల నాయకులు) నీ ఎదుట కూడుకొంటారు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","“నీవు ఒక బూరను పదే పదే ఊదితే, తూర్పు వైపున నివాసం చేస్తున్న వంశాలు బయల్దేరాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ఒక బూరను నీవు రెండోసారి కూడా అలాగే ఊదితే దక్షిణాన నివాసం చేస్తున్నవారు బయల్దేరాలి. బూర శబ్దం ప్రజలు బయల్దేరాలని చెప్పే ఒక ప్రకటన. ");
INSERT INTO tel2010_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ప్రజలందరినీ ఒక్కచోట నీవు సమకూర్చాలంటే, బూరలను మరో విధంగా అంటే ఏకధాటిగా ఒకే శృతిలో ఊదాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","అహరోను కుమారులు, యాజకులు బూరలు ఊదాలి. ఇది మీకు భవిష్యత్తులో కూడ కొనసాగే ఆజ్ఞ. ");
INSERT INTO tel2010_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“మీ స్వంత స్థలంలో మీరు శత్రువుతో యుద్ధం చేయాల్సివస్తే, మీరు వారిమీదికి వెళ్లక ముందు బూరలను గట్టిగా ఊదాలి. అప్పుడు మీ యెహోవా దేవుడు వింటాడు, మీ శత్రువులనుండి ఆయన మిమ్ములను రక్షిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","అలాగే మీ ప్రత్యేక సంతోష సమయాల్లోకూడ మీరు బూరలు ఊదాలి. మీ ప్రత్యేక పండుగ దినాల్లోను, నెలల ఆరంభ దినాల్లోను మీ బూరలు ఊదండి. మీ దహన బలులు, మీ సమాధాన బలులు అర్పించేటప్పుడు మీ బూరలు ఊదండి. అది మీరు మీ దేవుని జ్ఞాపకం చేసుకునేందుకు సహాయకరమైన ఒక ప్రత్యేక విషయం. మీరు ఇలా చేయాలని నేను మీకు ఆజ్ఞాపిస్తున్నాను. నేను యెహోవాను, మీ దేవుడ్ని.” ");
INSERT INTO tel2010_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ఇశ్రాయేలు ప్రజలు ఈజిప్టు విడిచిన తర్వాత రెండో సంవత్సరం, రెండో నెలలో (20వ రోజు) సన్నిధి గుడారం మీదనుండి మేఘం పైకి లేచింది. ");
INSERT INTO tel2010_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","అందుచేత ఇశ్రాయేలు ప్రజలంతా సీనాయి అరణ్యంనుండి బయల్దేరి ప్రయాణం మొదలుబెట్టారు. పారాను అరణ్యంలో ఆ మేఘం నిలిచిపోయేంత వరకు, వారు ప్రయాణం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","మోషేకు యెహోవా ఆజ్ఞాపించిన ప్రకారంగా ఆ ప్రజలు వారి స్థలాన్ని మార్చటం ఇది మొదటి సారి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","యూదా గుడారంలో మూడు విభాగాలు ముందుగా వెళ్లాయి. వారు వారి ధ్వజం క్రిందనే ప్రయాణం చేసారు. మొదటి విభాగం యూదా వంశం. అమ్మీనాదాబు కుమారుడైన నయస్సోను ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","తర్వాత ఇశ్శాఖారు విభాగం. సూయారు కుమారుడైన నెతనేలు ఆ కుటుంబ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ఆ తర్వాత జెబూలూను విభాగం. హెలోను కుమారుడైన ఏలీయాబు ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","అప్పుడు సన్నిధి గుడారం దించబడింది. గెర్షోను, మెరారి కుటుంబ పురుషులు పవిత్ర గుడారం మోసారు. కనుక తర్వాత ఈ కుటుంబాల ప్రజలు వరుసలో ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","తర్వాత రూబేను నివాసము నుండి మూడు భాగాలు వచ్చాయి. వారు వారి ధ్వజం క్రింద ప్రయాణం చేసారు. మొదటిది రూబేను వంశం. షెదెయూరు కుమారుడైన ఏలీసూరు ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","తర్వాత షిమ్యోను వంశం. సూరిషదాయి కుమారుడైన షెలుమీయేలు ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","తర్వాత గాదు వంశం. దెయువేలు కుమారుడు ఎలీయాసాపు ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","తర్వాత కహాతు కుటుంబ ప్రజలు. పవిత్ర గుడారం లోపల ఉండే పవిత్ర పరికరాలను వారు మోసారు. ఈ ప్రజలంతా వచ్చేయకముందే పవిత్ర గుడారం నిలబెట్టేందుకు వీలుగా వీరు ఈ సమయంలో వచ్చారు. ప్రజలు కూడా వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","తర్వాత ఎఫ్రాయిము నివాసంనుండి మూడు విభాగాలు వచ్చాయి. వారు వారి ధ్వజం క్రిందనే ప్రయాణం చేసారు. మొట్టమొదటి విభాగాం ఎఫ్రాయిము వంశం. అమీహూదు కుమారుడైన ఎలీషామా ఆ భాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","తర్వాత మనష్షే వంశం. పెదాసూరు కుమారుడైన గమలీయేలు ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","తర్వాత బెన్యామీను వంశం. గిద్యోనీ కుమారుడైన అబీదాను ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","వరుసలో చివరి మూడు వంశాలు మిగిలిన విభాగాలన్నిటికీ వెనుక కాపుగా ఉన్నాయి. ఇవి దాను నివాసానికి చెందినవి. వారు వారి ధ్వజం క్రింద ప్రయాణం చేసారు. మొదటి విభాగం దాను వంశం. అమీషదాయి కుమారుడైన అహీయెజరు ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","తర్వాత ఆషేరు వంశం. ఒక్రాను కుమారుడైన పగీయేలు ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","తర్వాత నఫ్తాలి వంశం. ఏనాను కుమారుడైన అహీరా ఆ విభాగానికి సైన్యాధిపతి. ");
INSERT INTO tel2010_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ఇశ్రాయేలు ప్రజలు ఒక చోటు నుండి మరో చోటకు బయల్దేరినప్పుడు, వారు వెళ్లిన విధానం అది. ");
INSERT INTO tel2010_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","మిద్యానీ వాడగు రెవూయేలు కుమారుడు హోబాబు. (రెవూయేలు మోషేకు మామ.) “దేవుడు మాకు ఇస్తానని వాగ్దానం చేసిన దేశానికి మేము ప్రయాణం చేస్తున్నాము. కనుక మాతో రమ్ము. మేము నీకు మేలు చేస్తాము. ఇశ్రాయేలు ప్రజలకు యెహోవా మంచివాటిని వాగ్దానం చేసాడు” అని హోబాబుతో మోషే చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","“నేను మీతో రాను, నేను నా సొంతదేశానికి, నా స్వంత ప్రజల దగ్గరకు వెళ్లిపోతాను” అని హోబాబు జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","అప్పుడు మోషే, “దయచేసి మమ్మల్ని విడువకు. అరణ్యంగూర్చి మాకంటె నీకే ఎక్కువ తెలుసు. నీవు మాకు మార్గదర్శిగా ఉండొచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","నీవు మాతో వస్తే, యెహోవా మాకు ఇచ్చే మంచివాటన్నింటిలో మేము నీకు భాగం ఇస్తాము” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","కనుక హోబాబు ఒప్పుకొన్నాడు యెహోవా పర్వతం దగ్గరనుండి వారు ప్రయాణం మొదలు బెట్టారు. పురుషులు యెహోవా ఒడంబడిక పవిత్ర పెట్టెను పట్టుకొని ప్రజల ముందు నడిచారు. వారు స్థలం కోసం వెదుకుతూ, మూడు రోజులపాటు పవిత్ర పెట్టెను మోసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","యెహోవా మేఘం ప్రతిరోజూ వారిమీద ఉంది. ప్రతి ఉదయం వారు తమ స్థలం విడిచిపెట్టినప్పుడు, వారిని నడిపించేందుకి మేఘం అక్కడ ఉండేది: ");
INSERT INTO tel2010_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ప్రజలు ప్రయాణం మొదలు బెట్టి, పవిత్రపెట్టె వారితో పాటు వెడలగానే, మోషే ఎప్పుడూ ఇలా చెప్పేవాడు: “యెహోవా, లెమ్ము నీ శత్రువులు అన్ని దిక్కుల్లో పారిపోదురు గాక: నీకు వ్యతిరేకంగా ఉన్న మనుష్యులు నీ ఎదుట నుండి పారిపోదురుగాక,” ");
INSERT INTO tel2010_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","పవిత్ర పెట్టెను, దాని స్థలంలో దాన్ని ఉంచి నప్పుడు, మోషే ఎప్పుడూ ఇలా చెప్పేవాడు, “యెహోవా, లక్షలాదిమంది ఇశ్రాయేలు ప్రజల దగ్గరకు తిరిగి రమ్ము.” ");
INSERT INTO tel2010_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ఈ సారి ప్రజలు వారి కష్టాలనుగూర్చి ఫిర్యాదు చేసారు. వారి ఫిర్యాదులను యెహోవా విన్నాడు. యెహోవా వీటిని విన్నప్పుడు ఆయనకు కోపం వచ్చింది. యెహోవా దగ్గరనుండి అగ్ని వచ్చి ప్రజల మధ్య రగులుకొంది. వారున్న స్థలంలో ఒక చివర కొన్ని ప్రాంతాలను అగ్ని కాల్చివేసింది. ");
INSERT INTO tel2010_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","కనుక ప్రజలు మోషేకు మొరపెట్టుకొన్నారు. మోషే యెహోవాను ప్రార్థించగా అగ్ని కాల్చివేయటం ఆగిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","అందుచేత ఆ చోటు తబేరా అని పిలువబడింది. ఆ ప్రజల మధ్య యెహోవా అగ్నిని దహింపజేసాడు గనుక ఆ స్థలానికి వారు ఆ పేరు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ఇశ్రాయేలీయులతో చేరిన విదేశీయులు తినేందుకు ఇంకా ఏవేవో కావాలనికోరటం మొదలు పెట్టారు. త్వరలోనే మొత్తం ఇశ్రాయేలీయులంతా మళ్లీ ఫిర్యాదు చేయటం మొదలు పెట్టారు. ప్రజలు ఇలా అన్నారు, “తినటానికి మాకు మాంసం కావాలి! ");
INSERT INTO tel2010_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ఈజిప్టులో మేము తిన్న చేపలు మాకు జ్ఞాపకం వస్తున్నాయి. చేపలు మాకు ఉచితంగా దొరికేవి. మంచి కూరగాయలు— దోసకాయలు, పుచ్చకాయలు, ఆకు కూరలు, ఉల్లిపాయలు, వెల్లుల్లి పాయలు మాకు దొరికేవి. ");
INSERT INTO tel2010_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","కానీ ఇప్పుడు మాకు బలంలేదు. మేము, ఈ మన్నా తప్ప ఇంకేమి తినటంలేదు!” ");
INSERT INTO tel2010_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","ఆ మన్నా కొత్తివీమెర గింజల్లా ఉండి, చూపునకు చెట్టుమీద జిగురు (బంక)లా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ప్రజలు దీనిని పోగుచేసి, నూరి పిండి చేస్తారు. లేక బండలను ఉపయెగించి దాన్ని పొడుం చేస్తారు. తర్వాత ఒక కుండలో దాన్ని వంట చేసేవారు, లేదా తియ్యటి అప్పాలు చేసేవారు. అప్పాలు ఒలీవ నూనెతో చేసిన రొట్టెల్లా రుచిగా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ప్రతి రాత్రీ నేల అంతా మంచుతో తడిసినప్పుడు మన్నా నేలమీద కురిసింది. ");
INSERT INTO tel2010_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ప్రితి కుటుంబం వాళ్లు ఫిర్యాదు చేయటం మోషే విన్నాడు. ప్రజలంతా వారివారి గుడారాంల్లో గొణుగుతున్నారు. యెహోవాకు చాల కోపం వచ్చింది. దానితో మోషేకు చాలా చికాకు కలిగింది. ");
INSERT INTO tel2010_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","మోషే యెహోవాను అడిగాడు, “యెహోవా, నీ సేవకుడనైన నాకు ఇంత కష్టం ఎందుకు కలిగించావు? నేనేమి పొరబాటు చేసాను? నీకు సంతోషం లేకుండేటట్టు నేను చేసింది ఏమిటి? ఈ ప్రజలందరి బాధ్యత నీవు నాకెందుకు ఇచ్చావు? ");
INSERT INTO tel2010_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ఈ ప్రజలందరికీ నేను తండ్రిని కానని నీకు తెలుసు. నేను వీరికి జన్మ ఇవ్వలేదనీ నీకు తెలుసు. కానీ పాలిచ్చి పెంచే దాదిలా నేనే వీరిని నా చేతుల్లో ఎత్తుకొని పోవాల్సినట్టు కనబడుతుంది. నేను ఇలా చేసేటట్టుగా నీవెందుకు నన్ను బలవంతం చేస్తున్నావు? నీవు మా పూర్వీకులకు వాగ్దానం చేసిన దేశానికి నేను వారిని మోసుకొని వెళ్లాలని నీవెందుకు నన్ను బలవంతం చేస్తున్నావు? ");
INSERT INTO tel2010_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","ఈ ప్రజలందరికీ మాంసం నాదగ్గర లేదు. కానీ వారు నాకు ఫిర్యాదు చేస్తూనే ఉన్నారు. ‘తినటానికి మాంసం ఇవ్వు’ అంటున్నారు వారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","ఈ ప్రజలందరినీ గూర్చి నేను ఒక్కడినే బాధ్యత వహించలేను. ఈ భారం నాకు చాల బరువుగా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","వారి కష్టాలన్నీ నీవు నా మీదే పెట్టాలనుకొంటే, ఇప్పుడే నన్ను చంపేయి. నన్ను నీ సేవకునిగా నీవు అంగీకరిస్తే, నన్ను ఇప్పుడే చావనివ్వు. అప్పుడు నా కష్టాలన్నీ తీరిపోతాయి.” ");
INSERT INTO tel2010_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","మోషేతో యెహోవా ఇలా అన్నాడు: “ఇశ్రాయేలీయుల పెద్దలను (నాయకులను) 70 మందిని నాదగ్గరకు తీసుకునిరా. వీరు ప్రజలలో నాయకులు. సన్నిధి గుడారం దగ్గరకు వారిని తీసుకునిరా. అక్కడ నీతోబాటు వారిని నిలబెట్టు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","అప్పుడు నేను దిగివచ్చి, అక్కడ నీతో మాట్లాడతాను. ఇప్పుడు నీ మీదికి వచ్చిన ఆత్మను వారికికూడ నేను కొంత ఇస్తాను. అప్పుడు నీవు ప్రజల బాధ్యత వహించటంలో వారు కూడ నీకు సహాయం చేస్తారు. ఈ విధంగా ఈ ప్రజల బాధ్యత నీవు ఒంటరిగా భరించాల్సిన అవసరం ఉండదు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“ప్రజలతో ఇలా చెప్పు: రేపటికోసం మిమ్మల్ని మీరు సిద్ధం చేసుకోండి. రేపు మీరు మాంసం తింటారు. మీ ఏడ్పు యెహోవా విన్నాడు. ‘తినటానికి మాకు మాంసం కావాలి. ఈజిప్టులోనే బాగుంది మాకు’ అని మీరు చెప్పిన మాటలు యెహోవా విన్నాడు. కనుక యెహోవా ఇప్పుడు మీకు మాంసం ఇస్తాడు. మీరు అది తింటారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","ఒకటి, రెండు, అయిదు, పది, ఇరవై రోజులకంటె ఎక్కువగానే మీరు అది తింటారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ఒక నెల అంతా మీరు ఆ మాంసం తింటారు. మొఖం మొత్తేటంతవరకు మీరు ఆ మాంసం తింటారు. యెహోవాకు వ్యతిరేకంగా మీరు ఫిర్యాదు చేసారు కనుక మీకు ఇలా జరుగుతుంది. యెహోవా మీ మధ్య సంచరిస్తూ, మీ అవసరాలను గ్రహిస్తాడు. కానీ మీరు ఆయన ఎదుట ఏడ్చి, ఫిర్యాదు చేసారు! అసలు ‘మేము ఈజిప్టు ఎందుకు విడిచిపెట్టాము’ అన్నారు మీరు.” ");
INSERT INTO tel2010_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","మోషే అన్నాడు: “యెహోవా, ఇక్కడ 6,00,000 మంది పురుషులు సంచరిస్తున్నారు. ‘నీవేమో వారు ఒక నెలంతా తినటానికి సరిపోయే మాంసం ఇస్తాను అంటున్నావు!’ ");
INSERT INTO tel2010_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","మొత్తం గొర్రెలు, పశువులు అన్నింటినీ వధించినా, ఇంత మంది ప్రజలకు ఒక నెల అంతా భోజనంగా పెట్టాలంటే అది చాలదు. అలానే సముద్రంలో ఉన్న మొత్తం చేపలన్నీ మేము పట్టినా, అవీ వారికి చాలవు.” ");
INSERT INTO tel2010_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","అయితే, “యెహోవా శక్తిని పరిమితం చేయకు. నేను చేస్తానని చెప్పినవాటిని చేస్తానో లేదో నీవు చూస్తావు” అని మోషేతో యెహోవా చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","కనుక మోషే ప్రజలతో మాట్లాడటానికి బయటకు వెళ్లాడు. యెహోవా చెప్పినది మోషే వారితో చెప్పాడు. అప్పుడు మోషే 70 మంది పెద్దలను సమావేశ పరచాడు. గుడారం చుట్టూ నిలబడమని మోషే వారితో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","అప్పుడు యెహోవా ఒక మేఘంలో దిగివచ్చి, మోషేతో మాట్లాడాడు. మోషే మీద ఉన్న దేవుని ఆత్మను ఆ 70 మంది పెద్దల మీద ఉంచాడు యెహోవా. ఆత్మ వారిమీదికి దిగిరాగానే వారు ప్రవచించటం మొదలు పెట్టారు. అయితే ఈ ఒక్కసారి మాత్రమే ఆ మనుష్యులు ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ఎల్దాదు, మేదాదు అనే అద్దరు పెద్దలు బయట గుడారం దగ్గరకు వెళ్లలేదు. వారి పేర్లు పెద్దల జాబితాలో ఉన్నాయి గాని వారు వారి గుడారంలోనే ఉండిపోయారు. కానీ దేవుని ఆత్మ వారిమీదకి కూడ వచ్చి నందుచేత, వారుకూడ వారి గుడారంలోనే ప్రవచించటం మొదలుపెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ఒక యువకుడు పరుగెత్తి వెళ్లి మోషేతో చెప్పాడు. “ఎల్దాదు, మేదాదు గుడారంలోనే ప్రవచిస్తున్నారు” అని అతడు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","అయితే నూను కుమారుడైన యెహోషువ “అయ్యా మోషే, నీవు వారిని ఆపివేయాలి” అని మోషేతో చెప్పాడు. (యెహోషువ చిన్నతనం నుండి మోషేకు సహాయకుడుగా ఉన్నాడు.) ");
INSERT INTO tel2010_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","కానీ మోషే, “ఇప్పుడు నేను నాయకుడ్ని కానని ప్రజలు తలుస్తారేమోనని నీవు భయపడుతున్నావా? యెహోవా ప్రజలు అందరూ ప్రవచిస్తే బాగుటుందని నా ఆశ. వారందరి మీద యెహోవా తన ఆత్మను ఉంచితే బాగుండునని నా ఆశ” అని బదులు చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","అప్పుడు మోషే, ఇశ్రాయేలు నాయకులు అంతా తిరిగి గుడారాలకు వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","అప్పుడు యెహోవా సముద్రం నుండి గొప్పగాలి వీచేటట్టుగా చేసాడు. ఆ గాలి పూరేళ్లను ఆ ప్రాంతంలోకి విసిరాయి. వారి నివాసాల చుట్టూరా పూరేళ్లు ఎగిరాయి. నేల అంతా పూరేళ్లతో నిండి పోయేటన్ని ఉన్నాయి అవి. నేలమీద మూడు అడుగుల ఎత్తుగా పూరేళ్లు నిండిపోయాయి. ఒక మనిషి ఒక రోజున నడువగలిగినంత దూరం అన్ని దిశల్లో పూరేళ్లు ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ప్రజలు బయటకు వెళ్లి ఆ రాత్రి పగలు అంతా పూరేళ్లను ఏరుకొన్నారు. ఆ మర్నాడు అంతా వారు పూరేళ్లు పోగుచేసుకొన్నారు. తక్కువ కూర్చుకొన్నవాడు నూరు తూములుకన్నా ఎక్కువ పూరేళ్లను పోగుచేసుకున్నాడు. తర్వాత ప్రజలు ఆ పూరేళ్లను వారి గుడారాల చుట్టూ ఎండటానికి ఎండలో పరిచారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ప్రజలు మాంసం తినటం మొదలుపెట్టారు కాని యెహోవాకు చాల కోపం వచ్చింది. ఆ మాంసం ఇంకా వారి నోటిలో ఉండగానే, ప్రజలు దానిని తినటంముగించక ముందే ఆ ప్రజలకు భయంకరమైన రోగం వచ్చేటట్టు చేసాడు యెహోవా. అనేకులు అక్కడే మరణించినందువల్ల అక్కడే పాతిపెట్టబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","కనుక ప్రజలు ఆ చోటుకు కిబ్రోత్ హత్తావా అని పేరు పెట్టారు. గొప్ప భోజనం కోసం బలీయమైన కోరికగల వారందరినీ అక్కడ పాతిపెట్టినందువల్ల వారు ఆ చోటుకు ఆ పేరు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","కిబ్రోత్ హత్తావా నుండి ప్రయాణం చేసి ప్రజలు హజేరోతు చేరి అక్కడ నివసించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","మిర్యాము, అహరోనూ మోషేకు వ్యతిరేకంగా మాట్లాడటం మొదలు పెట్టారు. అతని భార్య ఇథియోపియా స్త్రీ గనుక వారు అతణ్ణి విమర్శించారు. మోషే ఇథియోపియా ప్రజల్లోని స్త్రీని వివాహం చేసు కోవటం మంచిది కాదని వారు తలంచారు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","“ప్రజలతో మాట్లాడటానికి యెహోవా మోషేను వాడుకొన్నాడు. కానీ మోషే ఒక్కడే ఉన్నాడా? మన ద్వారా కూడ యెహోవా మాట్లాడాడు కదా” అని వారు తమలో తాము అనుకొన్నారు. యెహోవా ఇది విన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(మోషే చాలా దీనుడు. అతడు గొప్పలు చెప్పుకోలేదు, సణగ లేదు, భూమి మీద అందరికంటె అతడు దీనుడు.) ");
INSERT INTO tel2010_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","కనుక యెహోవా అకస్మాత్తుగా మోషే, అహరోను, మిర్యాములతో మాట్లాడాడు. “మీరు ముగ్గురూ ఇప్పుడే సన్నిధి గుడారానికి రండి” అని చెప్పాడు. కనుక మోషే, అహరోను, మిర్యాము గుడారానికి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","అప్పుడు యెహోవా ఒక మేఘంలో దిగివచ్చాడు. గుడార ప్రవేశం దగ్గర యెహోవా నిలబడ్డాడు. “అహరోను, మిర్యామును” తన దగ్గరకు రమ్మని పిల్చాడు యెహోవా. వాళ్లిద్దరూ ఆయనకు దగ్గరగా రాగానే ");
INSERT INTO tel2010_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","దేవుడు అన్నాడు: “నా మాటలు వినండి, మీ మధ్యకు నేను ప్రవక్తలను పంపినప్పుడు, యెహోవా నగు నేను వారికి దర్శనంలో కనబడతాను. కలలో నేనే వారితో మాట్లాడతాను. ");
INSERT INTO tel2010_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","కానీ నా సేవకుడైన మోషే అట్టివాడు కాదు. అతడు నా ఇల్లంతటిలో నమ్మకస్థుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","నేను అతనితో మాట్లాడినప్పుడు ముఖాముఖీగా నేను అతనితో మాట్లాడతాను. అతనితో నేను చెప్పాలనుకొనే విషయాలు వివరంగా నేను చెబుతాను. గూఢార్థపు పొడుపు కథలు నేను ప్రయోగించను. మోషే సాక్షాత్తు యెహోవా రూపాన్ని చూడవచ్చు. కనుక నా సేవకుడైన మోషేకు వ్యతిరేకంగా మీరెందుకు అంత ధైర్యంగా మాట్లాడారు?” ");
INSERT INTO tel2010_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","అంతట యెహోవా వారిని విడిచి వెళ్లి పోయాడు. కానీ ఆయనకు వారిమీద చాలా కోపం వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","యెహోవా మేఘం గుడారం మీదనుండి పైకి లేచి పోయింది. అప్పుడు అహరోను అటు తిరిగి మిర్యామును చూడగా, ఆమెకు భయంకర కుష్ఠురోగం రావటం అతనికి కనబడింది. ఆమె శరీరం మంచులా తెల్లగా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","అప్పుడు మోషేతో అహరోను అన్నాడు: “అయ్యా బుద్ధిహీనంగా మేము పాపం చేసాము, మమ్మల్ని క్షమించు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","చచ్చి పుట్టిన శిశువులా ఆమె తన శరీరాన్ని పోగొట్టుకోనియ్యకు.” (కొన్ని సార్లు అలాంటి శిశువు సగం శరీరం తినివేయబడిపుడుతుంది.) ");
INSERT INTO tel2010_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","కనుక మోషే, “ఓ దేవా ఈ రోగంనుండి ఆమెను బాగుచేయి” అని యెహోవాకు మొరపెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","“ఆమె తండ్రి ఆమె ముఖం మీద ఉమ్మి వేస్తే ఆమెకు ఏడు రోజులు అవమానం కలుగుతుంది. కనుక ఆమెను ఏడురోజులు పాళెమునకు బయట ఉంచండి. ఆ తర్వాత ఆమె తిరిగి లోనికి రావచ్చు” అని యెహోవా జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","కనుక మిర్యాము ఏడు రోజులపాటు పాళెమునకు వెలుపల ఉంచబడింది. ఆమె మరల లోనికి తీసుకొని రాబడేంతవరకు ప్రజలు అక్కడనుండి కదలలేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","అది జరిగిన తర్వాత ప్రజలు హజేరోతు విడిచి పారాను అరణ్యనికి ప్రయాణం చేసారు. ప్రజలు ఆ అరణ్యంలో గుడారాలు వేసుకొనిరి. ");
INSERT INTO tel2010_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“కనాను దేశాన్ని తరచి చూడ్డానికి కొందరు మనుష్యుల్ని పంపించు. ఇదే నేను ఇశ్రాయేలీయులకు ఇచ్చే దేశం. పన్నెండు వంశాల్లో ఒక్కొక్క దానినుండి ఒక్కొక్కరిని పంపించు.” ");
INSERT INTO tel2010_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","కనుక యెహోవా ఆజ్ఞకు మోషే విధేయుడయ్యాడు. పారాను అరణ్యంలోనికి నాయకులను అతడు పంపించాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","వారి పేర్లు ఇవి: రూబేను వంశంనుండి జక్కూరు కుమారుడైన షమ్మూయ. ");
INSERT INTO tel2010_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","షిమ్యోను వంశంనుండి హోరీ కుమారుడైన షాపాతు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","యూదా వంశంనుండి యెపున్నె కుమారుడైన కాలేబు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ఇఖారు వంశంనుండి యోసేపు కుమారుడైన ఇగాలు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ఎఫ్రాయిము వంశంనుండి నూను కుమారుడైన హోషేయ. ");
INSERT INTO tel2010_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","బెన్యామీను వంశంనుండి రాఫు కుమారుడైన పల్తీ. ");
INSERT INTO tel2010_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","జెబూలూను వంశంనుండి సోరీ కుమారుడైన గదీయేలు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","మనష్షే (యెసేపు వంశాల్లో ఒకటి) వంశంనుండి సూసీ కుమారుడైన గదీ. ");
INSERT INTO tel2010_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","దాను వంశంనుండి గెమలి కుమారుడైన అమ్మీయేలు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ఆషేరు వంశంనుండి మిఖాయేలు కుమారుడైన సెతూరు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","నఫ్తాలి వంశంనుండి వాపెసీ కుమారుడైన నహబీ. ");
INSERT INTO tel2010_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","గాదు వంశంనుండి మాకీ కుమారుడైన గెయువేలు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ఆ దేశాన్ని చూచి పరిశీలించేందుకు మోషే పంపించిన వారి పేర్లు అవి. (నూను కుమారుడైన హోషేయను మోషే యెహోషువ అని మరో పేరు పెట్టి పిలిచేవాడు.) ");
INSERT INTO tel2010_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","కనాను దేశాన్ని కనుక్కొనేందుకు మోషే వారిని పంపించినప్పుడు అతడు ఇలా చెప్పాడు: “నెగెవు ఎడారిలోనుండి వెళ్లండి, తర్వాత ఆ కొండల దేశంలోకి వెళ్లండి. ");
INSERT INTO tel2010_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ఆ దేశం ఎలా ఉందో చూడండి. అక్కడ నివసిస్తున్న ప్రజలనుగూర్చి తెలుసుకోండి. వారు బలవంతులా? బలహీనులా? వారు కొద్ది మందేనా? చాలమంది ఉన్నారా? ");
INSERT INTO tel2010_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","వారు నివసిస్తున్న దేశాన్ని గూర్చి తెలుసుకోండి. ఆ భూమి మంచిదా కాదా? వారు నివసించే పట్టణాలు ఎలాంటివి? ఆ పట్టణాలకు గోడలు ఉన్నాయా? ఆ పట్టణాలకు బలీయమైన కాపుదల ఉందా? ");
INSERT INTO tel2010_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ఆ దేశాన్ని గూర్చి ఇతర విషయాలు కూడ తెలుసుకోండి. ఆ భూమి, సారమైనదా కాదా? ఆ భూమి మీద చెట్లు ఉన్నాయా? అక్కడనుండి కొన్ని పండ్లు తీసుకుని రావటానికి ప్రయత్నించండి.” (ద్రాక్ష ప్రథమ ఫలాల కాలం ఇది). ");
INSERT INTO tel2010_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","అప్పుడు వారు ఆ దేశాన్ని పరిశీలించి చూసారు. వారు సీను అరణ్యం నుండి రెహోబు, లెబ్రోహమాతు వరకు వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","నెగెవు ద్వారా ప్రయాణించి హెబ్రోను పట్టణం చేరుకొన్నారు. (ఈజిప్టులోని సోయను పట్టణం కంటె హెబ్రోను ఏడేండ్లు ముందు నిర్మించబడింది.) అక్కడ అహీమాను, షేషయి, తల్మయి నివసించారు. వీరు అనాకీ ప్రజలు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","వాళ్లు ఎష్కోలు లోయలో ఒక ద్రాక్ష కొమ్మ కోసారు. ఆ కొమ్మకు ఒక ద్రాక్ష గెల ఉంది. ఇద్దరు మనుష్యులు ఆ గెలను ఒక కర్రకు కట్టి మోసుకొచ్చారు. కొన్ని దానిమ్మ, అంజూరపు పండ్లు కూడ వారు తెచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","అక్కడ ఇశ్రాయేలు మనుష్యులు ద్రాక్ష గుత్తిని కోసినందుచేత ఆ చోటు ఎష్కోలు అని పిలువబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","40 రోజుల పాటు వారు ఆ దేశాన్ని పరిశీలించారు. అప్పుడు వారు తిరిగి వారి నివాసమునకు వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","ఆ మనుష్యులు కాదేషు దగ్గర మోషే, అహరోను, ఇశ్రాయేలు ప్రజలందరి దగ్గరకు తిరిగి వచ్చారు. ఇది పారాను అరణ్యంలో ఉంది. అప్పుడు వారు చూచిన విషయాలన్నింటినీ మోషే, అహరోను, ఇశ్రాయేలు ప్రజలు అందరితో చెప్పారు. వారు ఆ దేశపు పండ్లను వారికి చూపించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","ఆ మనుష్యులు మోషేతో ఇలా చెప్పారు: “నీవు మమ్మల్ని పంపిన దేశంలోకి మేము వెళ్లాము. ఆ దేశం చాలా బాగుంది. అక్కడ పాలు, తేనెలు ప్రవహిస్తున్నాయి! అక్కడ మేము చూచిన పండ్లు ఇవిగో. ");
INSERT INTO tel2010_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","కానీ అక్కడ నివసిస్తున్న మనుష్యులు చాలా బలము, శక్తి ఉన్న వాళ్లు. వారి పట్టణాలు బలంగా కాపుదలలో ఉన్నాయి. ఆ పట్టణాలు చాల పెద్దవి. అనాకు కుటుంబానికి చెందిన కొందరు మనుష్యుల్ని కూడ మేము అక్కడ చూశాము. ");
INSERT INTO tel2010_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","అమాలేకీ ప్రజలు నెగెవు లోయలో నివసిస్తున్నారు. హిత్తీయులు, యెబూసీయులు, అమోరీయులు కొండల ప్రాంతంలో నివసిస్తున్నారు. కనానీ ప్రజలు సముద్రతీర ప్రాంతంలోను, యోర్దాను నదీతీరంలోను నివసిస్తున్నారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","అప్పుడు మోషే దగ్గర ఉన్న వాళ్లను నిశ్శబ్దంగా ఉండమన్నాడు కాలేబు. అప్పుడు కాలేబు, “మనం వెళ్లి ఆ దేశాన్ని మనకోసం స్వాధీనం చేసుకోవాలి. తేలికగా మనం ఆ దేశాన్ని స్వాధీనం చేసుకోవచ్చు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","కానీ అతనిలో కూడ వెళ్లినవారు, “ఆ మనుష్యులతో మనం పోరాడలేం. వాళ్లు మనకంటె చాల బలంగలవాళ్లు అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","మనం ఆ దేశ ప్రజలను జయించేందుకు తగిన బలవంతులం కాదు” అని ఇశ్రాయేలు ప్రజలందరితో వారు చెప్పారు. వారు ఇలా చెప్పారు: “మేము చూచిన దేశంనిండా బలాఢ్యులు ఉన్నారు. అక్కడికి వెళ్లిన ఎవరినైనాసరే తేలికగా జయించ గలిగినంత బలంగలవాళ్లు వారు. ");
INSERT INTO tel2010_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","అక్కడ మేము నెఫీలీ ప్రజలకు చూసాం (నెఫీలీ ప్రజలవాడగు అనాకు సంతానం.) వాళ్ల ముందు నిలబడితే మేము మిడుతల్లా ఉన్నట్టు అనుపించింది. మేమేదో మిడుతలంత చిన్నవాళ్లంగా మమ్మల్ని చూసారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ఆ రాత్రి గుడారాలలో ఉన్న ప్రజలంతా గట్టిగా ఏడ్వటం మొదలుపెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","ఇశ్రాయేలు ప్రజలంతా మోషే, అహరోనులకు వ్యతిరేకంగా ఫిర్యాదు చేసారు. ప్రజలంతా కూడి వచ్చి మోషే, అహరోనులతో ఇలా చెప్పారు, “ఈజిప్టులోనో లేక అరణ్యంలోనో మేము చావాల్సింది. మన కొత్త దేశంలో కత్తిచేత చావటంకంటె అదే బాగుండేది. ");
INSERT INTO tel2010_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","మమ్మల్ని ఈ కొత్త దేశానికి చావటానికి తీసుకొచ్చాడా? మా భార్యల్ని, మా పిల్లల్ని మా దగ్గరనుండి తీసుకుపోయి మమ్మల్ని కత్తులతో చంపేస్తారు. మేము మళ్లీ ఈజిప్టు వెళ్లి పోవటమే మాకు క్షేమం.” ");
INSERT INTO tel2010_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","అప్పుడు వాళ్లు, “మనం ఇంకో నాయకుడ్ని ఏర్పాటు చేసుకొని, తిరిగి ఈజిప్టు వెళ్లిపోదాము” అని ఒకళ్లతో ఒకరు చెప్పుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","అప్పుడు అక్కడ సమావేశమైన ఇశ్రాయేలు ప్రజలందరి ముందు మోషే, అహరోను సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ఆ దేశాన్ని కనుక్కొని వచ్చిన ఇద్దరు వ్యక్తులు నూను కుమారుడైన యెహోషువ యెపున్నె కుమారుడైన కాలేబు బట్టలు చించుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ఈ ఇద్దరు మనుష్యులూ అక్కడ సమావేశమైన ఇశ్రాయేలీయులందరితో ఇలా చెప్పారు: “మేము చూచిన దేశం చాలబాగుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","మనమీద దేవునికి ఇష్టం ఉంటే, ఆయనే మనల్ని ఆ దేశంలోనికి నడిపిస్తాడు. ఆ దేశం పాలు తేనెలు ప్రవహిస్తున్నంత సౌభాగ్యమయినది. ఆ దేశాన్ని మనకు ఇచ్చేందుకు యెహోవా తన శక్తి ప్రయోగిస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","అంతేగాని మనం యెహోవాకు ఎదురు తిరుగకూడదు. ఆ దేశంలో ప్రజలకు కూడ మనం భయపడకూడదు. మనం వాళ్లను తేలికగా జయించేస్తాం. వాళ్లకు ఎలాంటి భద్రతా లేదు, వాళ్లను క్షేమంగా ఉంచగలిగింది ఏమి లేదు. కానీ మనకు యెహోవా ఉన్నాడు. అందుచేత ఆ మనుష్యుల్ని గూర్చి భయపడకండి!” ");
INSERT INTO tel2010_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","అప్పుడు అక్కడ చేరిన ఇశ్రాయేలు ప్రజలంతా వీళ్లిద్దర్నీ రాళ్లతో కొట్టి చంపేయాలని మాట్లాడుకొన్నారు. అయితే యెహోవా మహిమ సన్నిధి గుడారం మీదికి దిగివచ్చింది. ఇశ్రాయేలు ప్రజలంతా అది చూడగలిగారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","అప్పుడు మోషేతో, యోహోవా: “ఇంకా ఎన్నాళ్లు ఈ ప్రజలు ఇలా చేస్తారు? వాళ్లు నన్ను నమ్మటంలేదనే వ్యక్తం చేస్తున్నారు. నా శక్తి మీద వాళ్లకు నమ్మకంలేనట్టే కనబడుతోంది. శక్తివంతమైన ఎన్నో సూచనలు నేను వాళ్లకు చూపించిన తర్వాతకూడ వాళ్లు నన్ను నమ్మటానికి నిరాకరిస్తున్నారు. వాళ్లమధ్య నేను ఎన్నో మహాకార్యాలు చేసాను. ");
INSERT INTO tel2010_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","ఒక భయంకర రోగంతో వాళ్లందరినీ నేను చంపేస్తాను. వాళ్లను నేను నాశనం చేస్తాను. మరో జనాంగాన్ని తయారు చేసేందుకు నిన్ను నేను వాడు కొంటాను. ఆ జనాంగం ఈ ప్రజలకంటె గొప్పదిగా, బలమైనదిగా ఉంటుంది.” అని అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","అప్పుడు యెహోవాతో మోషే ఇలా అన్నాడు: “నీవు అలాగనుక చేస్తే, నీ ప్రజలందరినీ నీవే చంపేసావని ఈజిప్టు ప్రజలు వింటారు. ఈ ప్రజలను ఈజిప్టు నుండి బయటకు తీసుకుని వచ్చేందుకు నీవు నీ గొప్ప శక్తిని ప్రయోగించావు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","ఈ గొప్ప శక్తినిగూర్చి ఈ దేశ నివాసులందరికీ ఈజిప్టు ప్రజలు చెప్పారు. ఒక యెహోవా, వాళ్లు ఇప్పటికే నిన్నుగూర్చి విన్నారు. నీవు నీ ప్రజలకు తోడుగా ఉన్నావనీ ప్రతి ఒక్కరూ నిన్ను చూసారనీ వారికి తెలుసు. నీ ప్రజలమీద నిలిచే మేఘాన్ని గూర్చి కూడ ఈ దేశవాసులకు తెలుస్తుంది. పగలు నీ ప్రజలను నడిపించేందుకు నీవు ఆ మేఘాన్ని వాడుకొన్నావు. రాత్రిపూట నీ ప్రజలకు నడిపించటానికి తిరిగి ఆ మేఘం అగ్నిగా మారుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","అందుచేత ఇప్పుడు నీవు ఈ ప్రజలను చంపకూడదు. ఒకవేళ నీవు వారిని చంపితే, నీ శక్తిని గూర్చి విన్న దేశాలన్నీ ఏమంటాయంటే ");
INSERT INTO tel2010_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘యెహోవా ఈ ప్రజలకు వాగ్దానం చేసిన దేశంలోకి వారిని తీసుకుని రాలేకపోయాడు. అందుకని వాళ్లను అరణ్యంలోనే చంపేసాడు అంటారు.’ ");
INSERT INTO tel2010_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“కనుక యెహోవా, ఇప్పుడు నీ బలం చూపెట్టాలి. నీవు చూపిస్తానని ప్రకటించిన విధానంలో నీవు చూపించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘యెహోవా త్వరగా కోపపడడు. ఆయన మహా ప్రేమమూర్తి. యెహోవా పాపాన్ని ఆయనకు ఎదురు తిరిగేవారిని క్షమిస్తాడు. అయితే నేరస్థులను మాత్రం యెహోవా ఎప్పుడూ శిక్షిస్తాడు. తల్లిదండ్రులు చేసిన పాపాలకుకూడా యెహోవా పిల్లల్ని శిక్షిస్తాడు. వారి తాత ముత్తాతల పాపాలకు యెహోవా పిల్లల్నికూడ శిక్షిస్తాడు’ అని నీవు చెప్పావు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","కనుక నీ మహా ప్రేమను ఈ ప్రజలకు చూపించు. వారి పాపం క్షమించు. వారు ఈజిప్టు విడిచినప్పటినుండి నీవు వారిని క్షమించినట్టే ఇప్పుడు కూడా క్షమించు.” ");
INSERT INTO tel2010_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","యెహోవా జవాబిచ్చాడు: “నీవు అడిగినట్టే నేను ఈ ప్రజలను క్షమించాను. ");
INSERT INTO tel2010_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","అయితే సత్యం ఏమిటో నీతో చెబుతాను. నేను జీవిస్తున్నంత నిశ్చయంగా, నా శక్తి ఈ భూమి అంతటా ఆవరించినంత నిశ్చయంగా, నేను నీకు ఆ వాగ్దానం చేస్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ఈజిప్టు నుండి నేను బయటకు నడిపించిన ప్రజల్లో ఏ ఒక్కరూ ఆ కనాను దేశాన్ని చూడరు. ఈజిప్టులో నేను చేసిన మహా సూచనలను, నా మహిమను చూసారు ఆ ప్రజలు. అరణ్యంలో నేను చేసిన మహా కార్యాలు వారు చూసారు. అయినా వారు నాకు అవిధేయులై, పదిసార్లు నన్ను శోధించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","వారి పూర్వీకులకు ఆ గొప్ప దేశాన్ని ఇస్తానని నేను వాగ్ధానం చేసాను. అయితే నాకు ఇలాంటి కీడు చేసిన ఏ వ్యక్తి ఎన్నటికీ ఆ దేశంలో ప్రవేశించడు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","కానీ నా సేవకుడైన కాలేబు విషయం వేరు. అతడు పూర్తిగా నన్ను వెంబడిస్తాడు. కనుక అతడు ఇప్పుడు చూసిన ఆ దేశంలోకి అతడ్ని తీసుకొస్తాను. అతని మనుష్యులకు ఆ దేశం దొరుకుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","అమాలేకీ, కనానీ ప్రజలు లోయలో నివసిస్తున్నారు. రేపు ఈ చోటు విడిచి, తిరిగి ఎర్ర సముద్రం మార్గంగా అరణ్యానికి వెళ్లండి.” ");
INSERT INTO tel2010_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","మోషే, అహరోనులతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ఈ దుర్మార్గులు ఇంకెన్నాళ్లు ఇలా నా మీద ఫిర్యాదు చేస్తుంటారు? వారి ఫిర్యాదులు, సణుగుడు నేను విన్నాను. ");
INSERT INTO tel2010_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","కనుక వారితో ఇలా చెప్పు, మీరు ఫిర్యాదు చేసిన విషయాలన్నింటినీ యెహోవా తప్పక జరిగిస్తాడు. మీకు ఏమి సంభవిస్తుందంటే, ");
INSERT INTO tel2010_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ఈ అరణ్యంలోనే మీ శరీరాలు చచ్చిపడతాయి. మీలో 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉన్న వాళ్లంతా మన ప్రజల్లో సభ్యులుగా లెక్కించబడ్డారు. మీలో ప్రతి ఒక్కరూ, యెహోవానైన నా మీద ఫిర్యాదు చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","మీకు ఇస్తానని నేను వాగ్దానం చేసిన దేశంలో మీరు ఒక్కరుకూడా ప్రవేశించరు. యెపున్నె కుమారుడైన కాలేబు, నూను కుమారుడైన యెహోషువ మాత్రమే ఆ దేశంలోని ప్రవేశిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","మీరు భయపడి, ఆ కొత్త దేశంలో మీ శత్రువులు మీ పిల్లలను మీ దగ్గరనుండి తీసుకుని పోతారని ఫిర్యాదు చేసారు. అయితే ఆ పిల్లల్నే ఆ దేశంలోకి నేను తీసుకుని వస్తానని నేను మీతో చెబుతున్నాను. మీరు అంగీకరించకుండా నిరాకరించిన వాటిని వారు అనుభవిస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","మీ విషయానికొస్తే, మీ శరీరాలు ఈ అరణ్యంలోనే రాలిపోతాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","“మీ పిల్లలు ఈ అరణ్యంలో 40 సంవత్సరాలపాటు కాపరులుగా ఉంటారు. మీకు విశ్వాసం లేదు గనుక వారు శ్రమపడుతారు. మీరంతా చచ్ఛేంతవరకు వారు ఈ అరణ్యంలోనే ఉండాలి. అప్పుడు మీ అందరి శరీరాలు ఈ అరణ్యంలోనే పడి ఉంటాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","మీ పాపాలకోసం 40 సంవత్సరాలు మీరు శ్రమ అనుభవిస్తారు. (ఆ దేశాన్ని కనుగొన్న 40 రోజుల్లో ఒక్కో రోజుకు ఒక్కో సంవత్సరం చొప్పున.) నేను మీకు వ్యతిరేకంగా ఉండటం ఎంతో దారుణంగా ఉంటుందని మీరు తెలుసుకుంటారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","“నేను యెహోవాను, నేనే మాట్లాడాను. ఈ దుర్మార్గులందరికీ ఇవన్నీ నేను చేస్తానని ప్రమాణం చేస్తున్నాను. వీరంతా కలిసి నామీదికి వచ్చారు. అందుచేత వీళ్లంతా ఇక్కడే అరణ్యంలోనే చస్తారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ఆ కొత్త దేశాన్ని కనుగొనేందుకు మోషే పంపిచిన మనుష్యులు తిరిగి వచ్చి ఇశ్రాయేలు ప్రజల్లో ఫిర్యాదులు వ్యాపింప చేసారు. ఈ దేశంలో ప్రవేశించటానికి సరిపడినంత బలంగల వాళ్లం కాదు అని వారే చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ఇశ్రాయేలు ప్రజల్లో కష్టాలు వ్యాపించటానికి వాళ్లే బాధ్యులు. అందుకని వాళ్లందర్నీ చంపేయటానికి ఒక రోగాన్ని రప్పించాడు యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","అయతే ఆ దేశాన్ని పరిశీలించటానికి పంపబడ్డవాళ్లలో నూను కుమారుడైన యెహోషువ, యెపున్నె కుమారుడైన కాలేబు కూడ ఉన్నారు. యెహోవా వాళ్లిద్దర్నీ రక్షించాడు. మిగతా పదిమందిని చని పోవునట్లు చేసిన రోగం వారికి రాలేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ఈ సంగతులన్నీ మోషే ఇశ్రాయేలు ప్రజలకు చెప్పాడు. ప్రజలు చాలా, చాలా విచారించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","మర్నాడు ఉదయాన్నే ప్రజలు కొండల దేశానికి బయల్దేరారు. ఆ ప్రజలు, “మేము పాపము చేసాము. మేము యోహోవా మీద నమ్మకం ఉంచనందుకు మేము విచారిస్తున్నాము. యెహోవా వాగ్దానం చేసిన దేశానికి మేము వెళ్తాము” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","కానీ మోషే ఇలా అన్నాడు: “యెహోవా ఆజ్ఞకు మీరెందుకు విధేయులవటం లేదు? మీకు జయం కలుగదు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","మీరు ఆ దేశం వెళ్లవద్దు. యెహోవా మీకు తోడుగా లేడు. మీ శత్రువులు మిమ్మల్ని తేలికగా ఓడించేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","అక్కడ అమాలేకీయులు, కనానీయులు మీతో పొరాడుతారు. మీరు యెహోవానుండి వేరైపోయారు. అందుచేత మీరు వాళ్లతో యుద్ధం చేసేటప్పుడు ఆయన మీకు తోడుగా ఉండడు. మీరంతా వారి ఖడ్గాలతో చంపబడతారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","కానీ ప్రజలు మోషేను నమ్మలేదు. వారు అలానే ఆ కొండల దేశంవైపు వెళ్లారు. అయితే మోషేగాని, యెహోవా ఒడంబడిక పెట్టెగాని వారితో వెళ్లలేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","అప్పుడు ఆ కొండల దేశంలో నివసిస్తున్న అమాలేకీ ప్రజలు, కనానీ ప్రజలు దిగివచ్చి ఇశ్రాయేలు ప్రజలమీద దాడిచేసారు. అమాలేకీ ప్రజలు, కనానీ ప్రజలు తేలికగా వీరిని ఓడించి, హోర్మా వరకు వారిని తరిమికొట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","మోషేతో యెహోవా ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ఇశ్రాయేలు ప్రజలతో మాట్లాడి వారికి చెప్పు: మీకు నివాసంగా నేను ఇస్తున్న ఒక దేశంలో మీరు ప్రవేశిస్తారు. మీరు ఆ దేశంలో ప్రవేశించగానే మీరు యెహోవాకు బలులు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ఈ అర్పణల్లో కొన్నింటిని మీరు అగ్నితో దహించాలి. మీ పశువుల మందల్లోనుండి, గొర్రెలమందల్లోనుండి మీరు అర్పణలు ఇవ్వాలి. ఇది యెహోవాకు ప్రీతిని కలిగిస్తుంది. దహనబలులు, బలి అర్పణలు, ప్రత్యేక ప్రమాణాలు, ప్రత్యేక కానుకలు, సమాధాన బలులు, ప్రత్యేక సెలవు దినాలు ఇవన్నీ యెహోవాకు చాల ఇష్టం. ");
INSERT INTO tel2010_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","“ఆ సమయంలో తన అర్పణను తెచ్చేవాడు యెహోవాకు ధాన్యార్పణ కూడ పెట్టాలి. ఆ ధాన్యార్పణ ముప్పావు ఒలీవ నూనెతో కలపబడ్డ రెండు పడుల పిండి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ఒక గొర్రెపిల్లను దహనబలిగా నీవు అర్పించిన ప్రతిసారీ ముప్పావు ద్రాక్షారసం పానార్పణంగా నీవు సిద్ధం చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“మీరు ఒక పొట్టేలును అర్పిస్తుంటే కూడ ధాన్యార్పణ సిద్ధం చేయాలి. ఆ ధాన్యార్పణ ఒక పడి ఒలీవ నూనెతో కలుపబడ్డ నాలుగు పడుల పిండి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ఒక పడి ద్రాక్షారసాన్ని పానార్పణంగా నీవు సిద్ధం చేయాలి. దాన్ని యెహోవాకు అర్పించు. అది ఆయన్ను సంతోషపెడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“అర్పణగా, బలిగా, సమాధాన బలిగా, లేక యెహోవాకు ఒక ప్రత్యేక వాగ్దానంగా నీవు ఒక కోడెదూడను సిద్ధం చేయవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","కనుక ఆ కోడెదూడతోబాటు ధాన్యార్పణ కూడ నీవు తీసుకొనిరావాలి. ఆ ధాన్యార్పణ పడిన్నర ఒలీవ నూనెతో కలుపబడిన ఆరు పడుల గోధుమ పిండి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","మరియు పడిన్నర ద్రాక్షారసం పానార్పణంగా తేవాలి. ఈ అర్పణ హోమంలో దహించబడటం యెహోవాకు ఎంతో సంతోషం. ");
INSERT INTO tel2010_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","నీవు యెహోవాకు అర్పించే ప్రతి కోడెదూడ, పోట్టేలు, గొర్రెపిల్ల, మేక పిల్ల ఈ విధంగా సిద్ధం చేయబడాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","నీవు అర్పించే ప్రతి జంతువుకూ నీవు ఇలా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ప్రజలు ఇలా దహన బలులు అర్పించినప్పుడు వారు యెహోవాను సంతోషపెడుతారు. అయితే ఇశ్రాయేలీయుల్లో ప్రతి పౌరుడూ వీటన్నింటినీ నేను నీతో చెప్పినట్టే చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","మరియు రాబోయే కాలమంతటిలో ఇశ్రాయేలు కుటుంబంలో జన్మించనివాడు మీ మధ్య నివసిస్తుంటే, అతడు కూడా వీటన్నింటికీ విధేయుడు కావాలి. నేను నీకు చెప్పిన విధంగానే అతడు ఇవన్నీ చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ఇశ్రాయేలు వంశంలో పుట్టిన మీకు, మీ మధ్య నివసించే ఇతరులకు ఒకే రకమైన నియమాలు ప్రజలకు ఉండాలి. ఈ ఆజ్ఞ ఇప్పటినుండి భవిష్యత్తు వరకు కొనసాగుతుంది. మీరు, మీ మధ్య ఉండే ఇతరులు అంతా ఒకటే యెహోవా ఎదుట. ");
INSERT INTO tel2010_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","అంటే మీరు ఒకే ఆజ్ఞలు, నియమాలు పాటించాలని దీని భావం. ఇశ్రాయేలు వంశంలో పుట్టిన మీకు, మీ మధ్య నివసించే ఇతర ప్రజలందరకు ఇవే ఆజ్ఞలు, నియమాలు.” ");
INSERT INTO tel2010_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“ఇశ్రాయేలు ప్రజలతో ఈ విషయాలు చెప్పు: నేను మిమ్మల్ని మరో దేశానికి తీసుకుని వెళ్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ఆ దేశంలో పండే ఆహారం మీరు తినేటప్పుడు దానిలో భాగం యెహోవాకు అర్పణగా మీరు ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","మీరు ధాన్యం విసిరి, ముద్దగా చేయాలి. దాన్ని రొట్టెలుగా చేయాలి. ఆ రొట్టెల్లో మొదటిది యెహోవాకు ఇవ్వాలి. అది కళ్లం నుండి వచ్చే ధాన్యార్పణ. ");
INSERT INTO tel2010_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ఇప్పుడు, రాబోయే కాలమంతా ఈ అర్పణను మీరు యెహోవాకు ఇవ్వాలి. అనగా మీరు ఆహారంగా విసరు కొనే ధాన్యంలో మొదటిది యెహోవాకు ఇవ్వాలని అర్థం. ");
INSERT INTO tel2010_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“మోషేకు యెహోవా ఇచ్చిన ఈ ఆజ్ఞలలో దేనికైనా విధేయులవటం మీరు మరచిపోతే మీరేమిచేయాలి? ");
INSERT INTO tel2010_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ఇవి మోషే ద్వారా మీకివ్వబడిన ఆజ్ఞలు. వీటిని యెహోవా మీకు ఇచ్చిన రోజే ఈ ఆజ్ఞలు ప్రారంభం అయ్యాయి. ఈ ఆజ్ఞలు రాబోయే కాలమంతా కొనసాగుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","అయితే వీటిలో ఏదైనా ఒక ఆజ్ఞకు మీరు విధేయులు కాకపోవటం జరుగవచ్చు. మీరు ఒక ఆజ్ఞకు విధేయులవటం మరచిపోయినా, ప్రజలంతా ఆ ఆజ్ఞ మరచిపోయి దోషులైనా, ప్రజలంతా ఒక కోడెదూడను యెహోవాకు అర్పణగా ఇవ్వాలి. ఇది దహనబలి, ఇది యెహోవాను సంతోషపెడుతుంది. కోడె దూడతో బాటు ధాన్యార్పణ, పానార్పణం కూడ ఇవ్వాలని జ్ఞాపకం ఉంచుకోండి. మరియు పాప పరిహర బలిగా ఒక మగ మేకనుకూడ మీరు ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","“కనుక ఆ పాపం నిమిత్తం ఆ చెల్లింపును యాజకుడు అర్పిస్తాడు. ఇశ్రాయేలు ప్రజలందరి కోసం అతడు ఇలా చేస్తాడు. వారు పాపం చేస్తున్నట్టు ప్రజలకు తెలియదు. అయితే దాన్నిగూర్చి వారు తెలుసుకొన్నప్పుడు, వారి తప్పిదం నిమిత్తం యెహోవాకు అర్పించేందుకు వారు ఒక అర్పణం తెచ్చారు. అది హోమంలో దహించబడిన పాప పరిహారార్థ అర్పణ. ");
INSERT INTO tel2010_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ఇశ్రాయేలు ప్రజలందరు, వారి మధ్య నివసిస్తున్న ఇతర ప్రజలంతా క్షమించబడతారు. వారు చేస్తోంది తప్పు అని వారికి తెలియదు గనుక వారు క్షమించబడతారు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“అయితే ఒక వ్యక్తి మాత్రమే ఒక ఆజ్ఞను పాటించటం మరచిపోతే, అతడు ఒక సంవత్సరపు ఆడ మేకను పాపపరిహారార్థ బలిగా తీసుకుని రావాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ఆ పాపం నిమిత్తం యెహోవా ఎదుట యాజకుడు ఆ చెల్లింపును అర్పిస్తాడు. అతని నిమిత్తం యాజకుడు చెల్లింపును అర్పించాడు గనుక అతడు క్షమించ బడతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","పాపం చేసినప్పటికి తాను తప్పు చేస్తున్నానని ఎరుగని ప్రతి వ్యక్తికి ఈ ఆజ్ఞ వర్తిస్తుంది. ఇశ్రాయేలు వంశంలో పుట్టిన వారికి, మీ మధ్యలో నివసిస్తున్న ఇతర ప్రజలకు కూడా ఇదే ఆజ్ఞ. ");
INSERT INTO tel2010_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“కానీ ఎవరైనా సరే తాను చేస్తోంది తప్పు అని తెలిసికూడ పాపం చేస్తే, అలాంటివాడు యెహోవాకు విరోధంగా జీవిస్తున్నాడు. అతడిని తన ప్రజలనుండి పంపించి వేయాలి. ఇశ్రాయేలు వంశంలో పుట్టిన వానికి, మీ మధ్య నివసించే వానికి ఇది సమానం. ");
INSERT INTO tel2010_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","అతడు యెహోవా మాటకు అడ్డం తిరిగాడు. అతడు యెహోవా ఆజ్ఞలకు విధేయుడు కాలేదు. అతడు తప్పకుండ మీ మధ్యనుండి వెళ్లగొట్టబడాలి. అతడు దోషిగానే ఉంటాడు.” ");
INSERT INTO tel2010_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ఇప్పటికి ఇశ్రాయేలు ప్రజలు ఇంకా అరణ్యంలోనే ఉన్నారు. ఒకడు వంట కట్టెలు చూడటం తటస్థించింది. కనుక అతడు ఆ కట్టెలు ప్రోగుచేస్తున్నాడు కాని అది సబ్బాతు. అతడు ఇలా చేయటం మరికొందరు చూసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","అతడు కట్టెలు ఏరటం చూచిన వాళ్లు అతన్ని, మోషే, అహరోను దగ్గరకు తీసుకుని వచ్చారు. ప్రజలంతా వాడ్ని చుట్టేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ఆ మనిషిని ఎలా శిక్షించాలో వారికి తెలియదు గనుక వారు అతణ్ణి అక్కడే ఉంచారు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","అప్పుడు యెహోవా, “ఆ మనిషిచావాలి. నివాస స్థలపు వెలుపల, ప్రజలంతా వానిమీద రాళ్లు విసరాలి” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","కనుక ప్రజలు అతణ్ణి నివాస స్థలమునుండి వెలుపలకు తీసు కుని వెళ్లి రాళ్లతో కొట్టి చంపారు. మోషేకు యెహోవా ఆజ్ఞాపించిన విధంగానే వారు ఇలా చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","మోషేతో యెహోవా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“ఇశ్రాయేలు ప్రజలతో మాట్లాడి ఇలా చెప్పు: మీరు నా ఆజ్ఞలు జ్ఞాపకం ఉంచుకొనేందుకు నేను మీకు ఒకటి ఇస్తాను. దారం ముక్కలు కొన్ని తీసుకొని వాటిని పేని, మీ బట్టల అంచులకు వాటిని కట్టాలి. ఆ కుచ్చుల్లో ఒక్కొక్క దాని మధ్య ఒక నీలం దారం ఉంచాలి. ఇప్పుడూ, ఇక ముందుకూ ఎప్పటికీ మీరు వాటిని ధరించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","మీరు ఈ కుచ్చులను చూచి, యెహోవా మీకిచ్చిన ఆజ్ఞలన్నింటిని జ్ఞాపకం ఉంచుకో గలుగుతారు. అప్పుడు మీరు ఆ ఆజ్ఞలకు విధేయులవుతారు. ఆజ్ఞలను మరచిపోయి, మీ శరీరాలు, కండ్లు కోరిన ప్రకారం చేయరు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","మీరు నా ఆజ్ఞలు అన్నింటికి విధేయులు కావాలని జ్ఞాపకం ఉంచుకొంటారు. అప్పుడు మీరు దేవుని ప్రత్యక ప్రజలుగా ఉంటారు. ");
INSERT INTO tel2010_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","నేను యెహోవాను, మీ దేవుడ్ని. మిమ్మల్ని ఈజిప్టు నుండి బయటకు తీసుకుని వచ్చింది నేనే. నేను మీ దేవునిగా ఉండటానికి ఇలా చేసాను. నేను యెహోవాను, మీ దేవుడ్ని.” ");
INSERT INTO tel2010_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","కోరహు, దాతాను, అబీరాము, ఓను అనవారు మోషేకు ఎదురు తిరిగారు. (కోరహు ఇస్హారు కుమారుడు. ఇస్హారు కహాతు కుమారుడు, కహాతు లేవీ కుమారుడు. దాతాను, అబీరాము సోదరులు ఎలీయాబు కుమారులు. ఓను పెలెతు కుమారుడు) దాతాను, అబీరాము ఓను రూబేను వంశస్థులు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ఈ నలుగురూ ఇశ్రాయేలీయులలో మరో 250 మందిని పోగుజేసి మోషే మీదికి వచ్చారు. ఈ 250 మంది ఇశ్రాయేలీయులలో పేరున్న పెద్ద మనుష్యులు. వారు సభా సభ్యులుగా ఎన్నుకోబడినవారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","వారు మోషే, అహరోనులకు వ్యతిరేకంగా మాట్లాడటానికి గుంపుగా వచ్చి. “మీరు చేసింది మేము ఒప్పు కోవటం లేదు. ఇశ్రాయేలీయుల నివాసంలో ఉన్న వాళ్లంతా పవిత్రులు. వారిలో ప్రతి ఒక్కరూ మంచి వారు. పైగా యెహోవా వారితో ఉన్నాడు. అలాంటప్పుడు మేము ఆ దేశంలో ప్రవేశించం అని చెబుతావేమి? నిన్ను నీవే అందరికంటె గొప్ప చేసుకొంటున్నావు” అని వాళ్లు మోషే, అహరోనులతో అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","మోషే ఈ సంగతులు వినగానే, వినయంతో సాష్టాంగపడ్డాడు. తాను గర్విష్ఠిని కానని చూపించటానికి ");
INSERT INTO tel2010_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","అప్పుడు కోరహుతో, అతనితో ఉన్న వాళ్లందరితో మోషే ఇలా అన్నాడు: “వాస్తవానికి ఎవరు యెహోవాకు చెందినవారో రేపు ఉదయం ఆయన తెలియజేస్తాడు. అలాంటివాడిని ఆయన తన దగ్గరకు రానిస్తాడు. ఆ మనిషిని యెహోవా ఎన్నిక చేసి, యెహోవాయే అతడ్ని తన దగ్గరకు తీసుకొస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","అందుచేత కోరహు, నీవూ, నీ అనుచరులంతా ఇలా చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","రేపు ధూపార్తుల్లో నిప్పు, సాంబ్రాణి వెయ్యండి. అప్పుడు వాటిని యెహోవా సన్నిధికి తీసుకొనిరండి. నిజంగా పవిత్రుడ్ని యెహోవా ఎంచుకొంటాడు. కానీ, నీవూ, నీ లేవీ సోదరులు తప్పుచేసి మితిమీరిపోయారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","కోరహుతో మోషే ఇంకా ఇలా అన్నాడు: “లేవీయులారా, నా మాట వినండి. ");
INSERT INTO tel2010_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ఇశ్రాయేలు దేవుడు మిమ్మల్ని వేరు చేసి, ప్రత్యేకంగా ఉంచినందుకు మీరు సంతోషించాలి. మిగతా ఇశ్రాయేలు ప్రజలందరి కంటె మీరు ప్రత్యేకం. ఇశ్రాయేలు ప్రజలు యెహోవాను ఆరాధించేందుకు సహాయకరంగా యెహోవా పవిత్ర గుడారంలో ప్రత్యేక పని చేయటానికి యెహోవా మిమ్మల్ని తనకు దగ్గరగా తెచ్చుకొన్నాడు. అది చాలదా? ");
INSERT INTO tel2010_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","యెహోవా తానే నిన్ను, లేవీ ప్రజలందర్నీ తన దగ్గరకు చేర్చుకొన్నాడు. కానీ ఇప్పుడు మీరే యాజకులు అయ్యేందుకు కూడా ప్రయత్నిస్తున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","నీవూ, నీ అనుచరులూ యెహోవా మీదికి రావటానికి ఏకమయ్యారు. మీరు అహరోను మీదికివచ్చి, అతనికి వ్యతిరేకంగా ఫిర్యాదు చేయటం తప్పు.” ");
INSERT INTO tel2010_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","అప్పుడు ఎలీయాబు కుమారులైన దాతాను, అబీరాములను మోషే పిల్చాడు. కానీ వాళ్లిద్దరు చెప్పారు: “మేము రాము. ");
INSERT INTO tel2010_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","పాలు తేనెలు ప్రవహించే మంచి ధనిక దేశంనుండి నీవు మమ్మల్ని బయటకు తీసుకుచ్చావు. ఈ అరణ్యంలో మమ్మల్ని చంపటానికి నీవు మమ్మల్ని ఇక్కడికి తీసుకుచ్చావు. పైగా నీకు మామీద చాల అధికారం ఉన్నట్టు చూపించాలను కొంటున్నావు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","మేము నిన్నెందుకు వెంబండించాలి? పాలు తేనెలు ప్రవహించే ఒక కొత్త ధనిక దేశానికి మమ్మల్ని నీవు తీసుకుని రాలేదు. దేవుడు వాగ్దానం చేసిన దేశం నీవు మాకు ఇవ్వలేదు. పొలాలు, ద్రాక్షాతోటలు నీవేమి మాకు ఇవ్వలేదు. ఈ మనుష్యుల్ని నీ బానిసలుగా చేస్తావా? లేదు, మేము రాము.” ");
INSERT INTO tel2010_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","అందుచేత మోషేకు చాల కోపం వచ్చింది. అతడు యెహోవాతో “వారి కానుకలు స్వీకరించకు. వారి దగ్గరనుండి నేనేమి తీసుకోలేదు, కనీసం ఒక గాడిదను కూడా తీసుకోలేదు. పైగా వారిలో ఎవ్వరికీ నేనేమి కీడు చేయలేదు” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","అప్పుడు మోషే కోరహుతో అన్నాడు: “నీవూ, నీ అనుచరులంతా రేపు యెహోవా ఎదుట నిలబడాలి. మీతోబాటు అహరోనుకూడ యెహోవా ఎదుట నిలబడతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","మీలో ప్రతి ఒక్కరూ ఒక ధూపార్తి తీసుకుని, అందులో సాంబ్రాణి వేసి దానిని యెహోవాకు అర్పించాలి. నాయకులకు 250 ధూపార్తులు, నీకు ఒక ధూపార్తి, అహరోనుకు ఒక ధూపార్తి ఉండాలి.” ");
INSERT INTO tel2010_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","కనుక ప్రతి ఒక్కరూ ఒక్కో ధూపార్తిని సాంబ్రాణితో నింపారు. అప్పుడు వారు సన్నిధి గుడారపు ప్రవేశం దగ్గర నిలబడ్డారు. మోషే, అహరోను కూడ అక్కడ నిలబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","కోరహు తన అనుచరులందరినీ సమావేశపర్చాడు (వీళ్లే మోషే, అహరోనులను ఎదిరించినవారు). సన్నిధి గుడార ప్రవేశం దగ్గర వీళ్లందర్నీ కోరహు సమావేశ పర్చాడు. అప్పుడు అక్కడ ప్రతి ఒక్కరికీ యెహోవా మహిమ ప్రత్యక్షం అయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","మోషే, అహరోనులతో యెహోవా ");
INSERT INTO tel2010_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“ఈ మనుష్యులకు దూరంగా వెళ్లిపోండి, నేను వాళ్లను ఇప్పుడే నాశనం చేసేస్తాను” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","అయితే మోషే, అహరోనూ సాష్టాంగపడిపోయి “ఓ దేవా, మనుష్యులందరి ఆత్మలను ఎరిగిన యెహోవా నీవు. మొత్తం ఈ గుంపు అంతటి మీద కోపగించకు. నిజానికి పాపం చేసింది ఒక్కడే” అంటూ మొరపెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","అప్పుడు యెహోవా మోషేతో ");
INSERT INTO tel2010_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“కోరహు, దాతాను, అబీరాము గుడారాల దగ్గరనుండి అందర్నీ దూరంగా వెళ్లిపొమ్మని చెప్పు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","మోషే లేచి దాతాను, అబీరాము దగ్గరకు వెళ్లాడు. ఇశ్రాయేలు పెద్దలంతా అతన్ని వెంబడించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","మోషే ప్రజలను ఈ రీతిగా హెచ్చరించాడు: “ఈ దుర్మార్గుల గుడారాల నుండి దూరంగా వెళ్లిపొండి. వారి వాటిని ఏవీ తాకకండి. మీరు తాకితే వారి పాపాలవల్ల మీరుకూడ నాశనం చేయబడతారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","కనుక వాళ్లంతా కోరహు, దాతాను, అబీరాము గుడారాలనుండి దూరంగా వెళ్లిపోయారు. దాతాను, అబీరాము వారి భార్యలు, పిల్లలు, శిశువులతోబాటు వారి గుడారాల బయట నిలబడి ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","అప్పుడు మోషే చెప్పాడు: “నేను మీతో చెప్పిన విషయాలన్నీ చేసేందుకు యెహోవా నన్ను పంపించాడని నేను మీకు రుజువు చూపిస్తాను. అవన్నీ నా స్వంత తలంపులు కావని నేను మీకు చూపిస్తాను. ");
INSERT INTO tel2010_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ఈ మనుష్యులు ఇక్కడే చస్తారు. కానీ సాధారణంగా మనుష్యులు చనిపోయే సామాన్య విధానంలోనే గనుక వీరు మరణిస్తే, నన్ను నిజంగా యెహోవా పంపించలేదని అర్థం. ");
INSERT INTO tel2010_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","కానీ ఈ మనుష్యులు వేరే విధంగా, మరో క్రొత్తరకంగా మరణించేటట్టు యెహోవా గనుక చేస్తే అప్పుడు వీళ్లు నిజంగా యెహోవాకు వ్యతిరేకంగా పాపం చేసారని మీకు తెలుస్తుంది. భూమి తెరచుకొని వీళ్లను మింగేస్తుంది. వారు సజీవ సమాధి అయిపోతారు. వీరికి చెందినది అంతా వీరితోబాటే లోపలికి వెళ్లిపోతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","మోషే ఈ మాటలు చెబుతూ ఉండగానే ఆ మనుష్యుల కాళ్ల క్రింద భూమి తెరచుకొంది. ");
INSERT INTO tel2010_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","అది భూమి తన నోరు తెరచి వారిని మింగివేసినట్టుగా ఉంది. వారి కుటుంబాలన్నీ, కోరహు మనుష్యులంతా, వారికి ఉన్నదంతా భూమిలోకి వెళ్లిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","వారు సజీవంగానే సమాధిలోనికి వెళ్లిపోయారు. వారికి ఉన్నదంతా వారితో బాటే లోపలికి వెళ్లిపోయింది. అప్పుడు వారిమీద భూమి కప్పివేసింది. వారు నాశనమైపోయి, పాళెములో లోకుండా పోయారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","నాశనం చేయబడు తోన్న మనష్యుల అరుపులు ఇశ్రాయేలు ప్రజలు విన్నారు. అందుచేత వాళ్లంతా “భూమి మనల్నికూడ మ్రింగివేస్తుంది” అంటూ అటు ఇటు పరుగులెత్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","తర్వాత యెహోవా దగ్గర్నుండి అగ్ని దిగి వచ్చి, ధూపం వేస్తున్న ఆ 250 మందిని నాశనం చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","38","“చచ్చిన ఆ మనుష్యుల మధ్య ఉన్న ధూపార్తులన్నింటినీ వెదకమని యాజకుడైన అహరోను కుమారుడైన ఎలీయాజరుతో చెప్పు. ఆ నిప్పుకణికలను నివాసానికి దూరంగా చల్లండి. ధూపార్తులు ఇంకా పవిత్రమైనవే. ఇవి నాకు వ్యతిరేకంగా పాపం చేసిన మనుష్యులు ఉపయోగించిన ధూపార్తులు. వారి పాపం వారి ప్రాణాలు తీసింది. ధూపార్తులను రేకులుగా కొట్టండి. బలిపీఠం కప్పటానికి ఈ రేకులు వాడండి. అవి యెహోవా ఎదుట అర్పించబడినవి గనుక అవి పవిత్రం. రేకులు చేయబడ్డ ఆ ధూపార్తులు ఇశ్రాయేలు ప్రజలందరకు హెచ్చరికగా ఉండుగాక!” ");
INSERT INTO tel2010_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","కనుక ఆ మనుష్యుల ఇత్తడి ధూపార్తులను అన్నింటినీ ఎలీయాజరు పోగుచేసాడు. వాళ్లంతా కాల్చివేయబడ్డారు గాని ధూపార్తులు మాత్రం అక్కడ ఉన్నాయి. ఆ ధూపార్తులను వెడల్పు రేకులుగా కొట్టమని కొందరితో చెప్పాడు ఎలీయాజరు. అప్పుడు ఆ వెడల్పు రోకులను అతడు బలిపీఠం చుట్టూ పెట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","మోషే ద్వారా యెహోవా తనకు ఆజ్ఞాపించిన ప్రకారం అతడు ఇలా చేసాడు. అహరోను కుటుంబానికి చెందిన వ్యక్తి మాత్రమే యోహోవా ఎదుట ధూపం వేయాలని ఇశ్రాయేలు ప్రజలు జ్ఞాపకం ఉంచుకొనేందుకు ఇది సహాయకరమైన సూచన. ఇంకొక వ్యక్తి గనుక యోహోవా ఎదుట ధూపం వేస్తే, అతడు కోరహు, అతని అనుచరుల్లా అవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","మరునాడు ఇశ్రాయేలు ప్రజలంతా మోషే, అహరోనుల మీద ఫిర్యాదు చేసారు. వారు, “యెహోవా ప్రజలను మీరు చంపారు” అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","మోషే, అహరోనులు సన్నిధి గుడారం ప్రవేశం దగ్గర నిలబడి ఉన్నారు. మోషే, అహరోనుల మీద ఫిర్యాదు చేయటానికి ప్రజలు ఆచోట చేరారు. అయితే వారు సన్నిద గుడారం వైపు చూచినప్పుడు, మేఘం దానిని అవరించి, యెహోవా మహిమ అక్కడ ప్రత్యక్షమయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","అప్పుడు మోషే. అహరోనులు సన్నిధి గుడారం ఎదుటకి వెళ్లారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","అప్పుడు యెహోవా మోషేతో ");
INSERT INTO tel2010_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“ఇప్పుడు నేను వీళ్లను నాళనం చేస్తాను గనుక మీరు దూరంగా తొలగిపొండి” అని చెప్పాడు. కనుక మోషే, అహరోనులు సాష్టాంగపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","అప్పుడు మోషే “నీ ధూపార్తిని బలిపీఠపు నిప్పులతో నింపు. దానిమీద సాంబ్రాణి వేయి. త్వరపడి ప్రజల సమాజం దగ్గరకు వెళ్లి వారి పాపానికి ప్రాయశ్చిత్తం చేయి. యోహోవా వారి మీద కోపంగా ఉన్నాడు. కష్టాలు అప్పుడే మొదలయ్యాయి” అని అహరోనుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","కనుక మోషే చెప్పినట్టు అహరోను చేసాడు. అతడు నిప్పులు, సాంబ్రాణి తీసుకొని ప్రజలందరి మధ్యకు పరుగెత్తాడు, అయితే అప్పుటకే ప్రజల్లో రోగం మొదలయింది. ప్రజలకోసం ప్రాయశ్చిత్తంగా అహరోను ధూపం వేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","బ్రతికి ఉన్నవాళ్లుకు, చచ్చిన వాళ్లకు మధ్య నిలబడ్డాడు అహరోను. అంతటితో ఆ రోగం ఆగిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","అయితే వారి పాపం నిమత్తం అపరోను ప్రాయశ్చిత్తం చేయకముందే ఆ రోగంవల్ల కోరహు మూలంగా చచ్చినవాళ్లు కాక ఇంకా 14,700 మంది చనిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","అప్పుడు సన్నిధి గుడార ప్రవేశం దగ్గర ఉన్న మోషే వద్దకు అహరోను తిరిగి వెళ్లాడు. ప్రజల్లో ఆ భయంకర రోగం నిలిచిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","మోషేతో యెహోవా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“ఇశ్రాయేలు ప్రజలతో మాట్లాడు. వారి దగ్గరనుండి పన్నెండు చేతికర్రలు తీసుకునిరా. పన్నెండు వంశాలలో ఒక్కొక్క నాయకుని దగ్గర్నుండి ఒకటి తీసుకో, ఒక్కొక్కరి పేరు ఒక్కో కర్ర మీద వ్రాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","లేవీ వాళ్ల కర్రమీద అహరోను పేరు వ్రాయి. పన్నెండు వంశాల్లో ప్రతి పెద్దకు ఒక కర్ర ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","సన్నిధి గుడారంలో ఒడంబడిక పెట్టె ఎదుట ఈ చేతి కర్రలను పెట్టు. ఇది నేను నిన్ను కలుసుకొనే చోటు. ");
INSERT INTO tel2010_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ఒక్క మనిషిని నేను ఏర్పాటు చేసుకొంటాను. ఏ మనిషిని నేను ఎంచుకుంటానో నీకు తెలుస్తుంది. ఎందుచేత నంటే అతని కర్రకు కొత్త ఆకులు మొలవటం ప్రారంభమవుతుంది. ఈ విధంగా, ప్రజలు నీకు, నాకు ఎల్లప్పుడు వ్యతిరేకంగా ఫిర్యాదు చేయటం నేను ఆపుచేస్తాను.” ");
INSERT INTO tel2010_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","కనుక మోషే ఇశ్రాయేలు ప్రజలతో మాట్లాడాడు. పెద్దలంతా ఒక్కొక్కరు ఒక కర్ర అతనికి ఇచ్చారు మొత్తం కర్రల సంఖ్య పన్నెండు. ఒక్కో వంశం నాయకుని దగ్గరనుండి ఒక్కో కర్ర వచ్చింది. వాటి మధ్య అహరోను కర్ర ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","మోషే ఆ చేతి కర్రలను సన్నిధి గుడారంలో ఒడంబడిక పెట్టె దగ్గర యెహోవా ఎదుట ఉంచాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ఆ మరునాడు మోషే గుడారంలో ప్రవేశించాడు. లేవీ వంశపు కర్ర, అంటే అహరోను చేతికర్ర కొత్త ఆకులు తొడగటం మొదలు పెట్టినట్టు అతడు చూసాడు. ఆ కర్రకు కొమ్మలుకూడ పెరిగి, బాదంకాయలు కాసింది. ");
INSERT INTO tel2010_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","కనుక యెహోవా స్థానం నుండి మోషే ఆ కర్రలంటినీ బయటకు తెచ్చాడు. ఆ చేతి కర్రలను ఇశ్రాయేలు ప్రజలకు మోషే చూపించాడు. వాళ్లంతా ఆ కర్రలను చూచి, ఎవరి కర్ర వారు తిరిగి తీసుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","అప్పుడు యెహోవా మోషేతో ఇలా అన్నాడు: “అహరోను చేతి కర్రను మళ్లీ గుడారంలో పెట్టు. ఎల్లప్పుడూ నాకు వ్యతిరేకంగా ఎదురు తిరుగుచున్న ఈ ప్రజలకు ఇది ఒక హెచ్చరికగా ఉంటుంది. నామీద వారు ఫిర్యాదు చేయటం ఇది ఆపుచేస్తుంది. ఈ విధంగా వారు చావకుండా ఉంటారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","కనుక మోషే తనకు యెహోవా చెప్పినట్టు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","ఇశ్రాయేలు ప్రజలు మేము “చనిపోతామని మాకు తెలుసు. మేము నశించిపోయాము. మేము అంతా నశించిపోయాము. ");
INSERT INTO tel2010_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ఎవరైనా యెహోవా పవిత్ర స్థలం సమీపంగా వచ్చినా సరే చస్తారు. మేము అందరము చనిపోతామా?” అని మోషేతో అన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","అహరోనుతో యెహోవా ఇలా చెప్పాడు: “పవిత్ర స్థలానికి వ్యతిరేకంగా ఎలాంటి అపచారాలు జరిగినా ఇక మీదట నీవు, నీ కుమారులు, నీ తండ్రి కుటుంబం బాధ్యులు. యాజకులకు వ్యతిరేకంగా జరిగే అపచారాలకు నీవు, నీ కుమారులు బాధ్యులు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","నీ వంశంలో మిగిలిన లేవీ మనుష్యులను కూడ నీతో చేర్చుకో. ఒడంబడిక, పవిత్ర గుడారంలో నీవు, నీ కుమారులు చేయాల్సిన పనిలో వారు మీకు సహాయం చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","లేవీ వంశంలోని ఆ మనుష్యులు నీ స్వాధీనంలో ఉంటారు. గుడారంలో జరగాల్సిన పని అంతా వారు చేస్తారు. అయితే పవిత్ర స్థలంలోగాని, బలిపీఠం దగ్గరగాని ఉన్న వస్తువులను వారు సమీపించకూడదు. ఒకవేళ వారు వెళ్తే, వారూ, నీవు కూడా చనిపోతావు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","వారు నీతో కలిసి పనిచేస్తారు. సన్నిధి గుడారం విషయమై జాగ్రత్త తీసుకోవటం వారి బాధ్యత. గుడారంలో జరగాల్సిన పని అంతా వాళ్లు చేస్తారు. నీవు ఉన్న చోటికి ఇంకెవ్వరూ రాకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“పవిత్ర స్థలాన్ని, బలిపీఠాన్ని జాగ్రత్తగా చూసుకోవటం నీ బాధ్యత, ఇశ్రాయేలు ప్రజల మీద నేను మళ్లీ కోపగించుకోవటం నాకు ఇష్టం లేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","ఇశ్రాయేలు ప్రజలందరిలోనుండి లేవీ ప్రజలను అంటే నీ ప్రజలను నేనే ఏర్పాటు చేసుకొన్నాను. వారు నీకు ఒక కానుక వంటివారు. యెహోవాను సేవించటం, సన్నిధి గుడారం పని చేయటం ఒక్కటే వారి ఉద్దేశ్యం. ");
INSERT INTO tel2010_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","అయితే నీవు, నీ కుమారులు మాత్రమే యాజకులుగా పని చేయవచ్చు. బలిపీఠం దగ్గరకు వెళ్లగలిగేది మీరు మాత్రమే. మీరు మాత్రమే తెర లోపలకు వెళ్లగలవారు. యాజకునిగా మీ సేవ అనేది నేను మీకు కానుకగా ఇస్తున్నాను. అతి పవిత్ర స్థలాన్ని ఇంకెవరు సమీపించినా వారిని చంపెయ్యాలి.” ");
INSERT INTO tel2010_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","అప్పుడు యెహోవా అహరోనుతో ఇలా చెప్పాడు: “నాకు అర్పించబడిన అర్పణలన్నింటిమీద నేనే నీకు బాధ్యత ఇచ్చాను. ఇశ్రాయేలు ప్రజలు నాకు అర్పించే పవిత్ర అర్పణలన్నీ నేను నీకు ఇస్తాను. ఈ కానుకలను నీవూ, నీ కుమారులూ పంచుకోవచ్చు. ఎప్పుడూ అవి మీకే చెందుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","దహించబడని పవిత్ర అర్పణలన్నింటిలో మీకు వంతు ఉంటుంది. ప్రజలు తమ కానుకులను అతి పవిత్ర అర్పణలుగా నా దగ్గరకు తీసుకుస్తారు. ఇవి ధాన్యార్పణలు, పాప పరిహారార్థ అర్పణలు, అపరాధ పరిహారార్థ అర్పణలు. అయితే ఇవన్నీ నీవి, నీ కుమారులవి. ");
INSERT INTO tel2010_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","అవి అత్యంత పవిత్రమైనవిగా వాటిని తినాలి. నీ కుటుంబంలో మగవారు ప్రతి ఒక్కరూ దానిని తినాలి. అది పవిత్రం అని నీవు చెప్పాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ఇశ్రాయేలు ప్రజలు నైవేద్యంగా ఇచ్చు అర్పణలు అన్నీ నీవే. ఇది నీకూ, నీ కుమారులకు, కుమార్తెలకు నేను ఇస్తున్నాను. ఇది నీ వంతు. నీ కుటుంబంలో పవిత్రంగా ఉన్న ప్రతి వ్యక్తీ దీనిని తినగలుగుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“శ్రేష్ఠమైన ఒలీవ నూనె అంతయు, శ్రేష్ఠమైన కొత్త ద్రాక్షారసం అంతయు, ధాన్యం అంతయు నేను నీకిస్తున్నాను. ఇవన్నీ యెహోవానైన నాకు ఇశ్రాయేలు ప్రజలు ఇచ్చేవి. ఇవన్నీ వారి పంట కోతలో ప్రథమ ఫలాలు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","ప్రజలు పంటకోత కూర్చినప్పుడు, మొదటివి అన్నీ వారు యెహోవాకు ఇస్తారు. కనుక వీటిని నేను నీకు ఇస్తాను. నీ కుటుంబంలో పవిత్రంగా ఉన్న ప్రతి వ్యక్తీ అది తినవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“ఇశ్రాయేలులో యెహోవాకు అర్పించబడిన ప్రతిదీ నీదే. ");
INSERT INTO tel2010_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","“ఒక కుటుంబంలో, మనిషికి గాని జంతువుకు గాని పుట్టిన మొట్టమొదటిది యెహోవాకు అర్పించబడుతుంది. అది నీదే అవుతుంది. అయితే అపవిత్రంగా పుట్టిన ప్రతి మొదటి శిశువుకు, ప్రతి మొదటి మగ జంతువుకు నీవు వెల చెల్లించాలి. అప్పుడు ఆ మొదటి శిశువు తిరిగి తన కుటుంబానికే చెందుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","వారు ఒక నెల వయసులో ఉన్నప్పుడు వారికోసం నీవు వెల చెల్లించాలి. ఆ వెల అయిదు తులాల వెండి. ");
INSERT INTO tel2010_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“అయితే ఆవులలో, గొర్రెలలో మేకలలో మొదట పుట్టిన దానికి నీవు వెల చెల్లింపకూడదు. ఆ జంతువులు పవిత్రం— పరిశుభ్రం. వాటి రక్తం బలిపీఠం మీద చిలకరించి వాటి కొవ్వును దహించాలి. ఇది హోమంగా అర్పించబడిన అర్పణ. దీని వాసన యెహోవానగు నాకు ఎంతో సంతోషం కలిగిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","అయితే ఆ జంతువుల మాంసం నీదే అవుతుంది. మరియు నైవేద్యంలోని బోర నీదే. మిగిలిన అర్పణల్లోకుడి తొడ నీదే. ");
INSERT INTO tel2010_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","పవిత్ర కానుకలుగా ప్రజలు అర్పించేవి ఏవైనా సరే, యెహోవానగు నేను నీకు ఇస్తాను. ఇది నీ వంతు. నీకు, నీ కుమారులకు, నీ కుమార్తెలకు నేను ఇస్తాను, ఇది శాశ్వతంగా కొనసాగే వాగ్ధానం. నీకూ, నీ సంతతికీ నేను ఈ వాగ్దానం చేస్తున్నాను.” ");
INSERT INTO tel2010_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","అహరోనుతో యెహోవా ఇంకా ఇలా చెప్పాడు: “దేశంలో నీకేమీ స్వాస్థ్యం ఉండదు. ఇతరులు స్వంతంగా కలిగి ఉన్నవి ఏవి నీకు స్వంతంగా ఉండవు. నేను, యెహోవాను నీ స్వంతం. నేను వాగ్దానం చేసిన దేశాన్ని ఇశ్రాయేలు ప్రజలు పొందుతారు. అయితే నీకు మాత్రం నేనే నీ కానుకగా ఉంటాను. ");
INSERT INTO tel2010_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“ఇశ్రాయేలు ప్రజలు వారికి ఉన్న ప్రతి దానిలోను పదోవంతు నాకు ఇస్తారు. కనుక ఆ పదోవంతును నేను లేవీ ప్రజలకు ఇస్తాను. వారు సన్నిధి గుడారంలో సేవించేటప్పుడు చేసే పనికి ఇది వారికి జీతం. ");
INSERT INTO tel2010_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","అయితే ఇశ్రాయేలీయుల్లో ఇతరులు ఎన్నడూ సన్నిధి గుడారం సమీపించకూడదు. వారు అలా వెళ్తే, వారి పాపం నిమిత్తం ప్రాయశ్చిత్తం చెల్లించి మరీచస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","సన్నిధి గుడారంలో పనిచేసే లేవీ ప్రజలే, దానికి వ్యతిరేకంగా జరిగే పాపాలకు బాధ్యులు. ఈ ఆజ్ఞ భవిష్యత్ కాలంలో కూడ కొనసాగుతుంది. ఇతర ఇశ్రాయేలు ప్రజలకు నేను వాగ్దానం చేసిన దేశాన్ని లేవీ ప్రజలు మాత్రం పొందరు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","అయితే ఇశ్రాయేలు ప్రజలు వారికి ఉన్న ప్రతి దానిలోనుండి పదోవంతునాకు ఇస్తారు. కనుక ఆ పదో వంతును నేను లేవీ ప్రజలకు ఇస్తాను. అందుకే లేవీ వాళ్లను గూర్చి నేను ఈ మాటలు చెప్పాను. ఇశ్రాయేలు ప్రజలకు నేను వాగ్దానం చేసిన దేశాన్ని ఆ లేవీ ప్రజలు పొందరు.” ");
INSERT INTO tel2010_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“లేవీ ప్రజలతో మాట్లాడి వారికి ఇలా చెప్పు: ఇశ్రాయేలు ప్రజలు వారికి ఉన్న ప్రతి దానిలోనుండి పదోవంతు యెహోవాకు ఇవ్వాలి. ఆ పదోవంతు లేవీ ప్రజలకు చెందుతుంది. అయితే అందులో పదోవంతు యెహోవా అర్పణగా మీరు ఆయనకు ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","పంట కోసిన తర్వాత ధాన్యం, ద్రాక్ష గానుగ నుండి రసం మీకు ఇవ్వబడుతాయి. అప్పుడు అవి కూడ యెహోవాకు మీ అర్పణలు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","ఈ విధంగా ఇతర ఇశ్రాయేలు ప్రజలు చేసినట్టు, మీరు కూడ యెహోవాకు అర్పణ ఇవ్వాలి. ఇశ్రాయేలు ప్రజలు యెహోవాకు ఇచ్చే పదోవంతు మీకు ఇవ్వ బడుతుంది. దానిలో పదోవంతును మీరు యాజకుడైన అహరోనుకు ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ఇశ్రాయేలు ప్రజలు వారికి ఉన్నదానంతటిలో నుండి పదోవంతు మీకు ఇచ్చినప్పుడు, వాటిలో శ్రేష్ఠమైనవి, అత్యంత పవిత్రమైనవి మీరు ప్రత్యేకించాలి. అది మీరు యెహోవాకు ఇచ్చే పదోవంతు. ");
INSERT INTO tel2010_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“మోషే! లేవీ ప్రజలకు ఇది చెప్పు: ఇశ్రాయేలు ప్రజలు వారి పంటలో నుండి, ద్రాక్షారసంలో నుండి పదోవంతు మీకు ఇస్తారు. అప్పుడు అందులో శ్రేష్ఠమైన భాగం మీరు యెహోవాకు ఇవ్వాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","మిగిలి పోయినదంతా మీరు, మీ కుటుంబాలు తినవచ్చు. సన్నిధి గుడారంలో మీరు చేసే పనికి ఇది మీకు జీతం. ");
INSERT INTO tel2010_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","మరియు ఎల్లప్పుడూ దానిలోని శ్రేష్ఠ భాగాన్నే మీరు యెహోవాకు ఇస్తే, మీరు ఎన్నటికీ అపరాధులు కారు. ఇశ్రాయేలు ప్రజల నుండి అనేకుల పవిత్ర అర్పణలని మీరు ఎన్నటికీ గుర్తుంచుకుంటారు. మీరు చావరు.” ");
INSERT INTO tel2010_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","మోషేతో, అహరోనుతో యెహోవా మాట్లాడాడు. ఆయన ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ఇశ్రాయేలు ప్రజలకు ఇచ్చే ఆజ్ఞలు, ప్రబోధాలు ఇవే. వారు బలంగా ఉన్న ఒక ఎర్ర ఆవును నీ దగ్గరకు తీసుకుని రావాలి. ఆ ఆవుకు ఎలాంటి గాయాలు ఉండకూడదు. ఆ ఆవు ఎన్నడూ కాడి మోసి ఉండకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ఆ ఆవును యాజకుడైన ఎలీయాజరుకు ఇవ్వాలి. ఎలీయాజరు ఆవును నివాసం యొక్క వెలుపలికి తీసుకునిపోయి, అక్కడ దాన్ని వధించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","అప్పుడు యాజకుడైన ఎలీయాజరు దాని రక్తంలో కొంత తన వేలిమీద వేసుకొవాలి. తర్వాత అతడు ఆ రక్తంలో కొంత పవిత్ర గుడారం వైపు చల్లాలి. అతడు ఇలా ఏడు సార్లు చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","అప్పుడు మొత్తం ఆవు అతని ఎదుట దహించబడాలి. దాని చర్మం, మాంసం, రక్తం, ప్రేగులు అన్నీ దహించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","అప్పుడు యాజకుడు ఒక దేవదారు కర్రను, హిస్సోపు కొమ్మను, ఎర్ర నూలును తీసుకుని, ఆవు దహించబడుతున్న అగ్నిలో వేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","అప్పుడు యాజకుడు స్నానం చేసి, నీళ్లతో తన బట్టలు ఉదుకుకోవాలి. అతడు తిరిగి నివాసానికి రావాలి. యాజకుడు సాయంత్రం వరకు అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ఆ ఆవును దహించే వ్యక్తి స్నానం చేసి, నీళ్లతో తన బట్టలు ఉదుక్కోవాలి. సాయంత్రం వరకు అతడు అపవిత్రంగానే ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“అప్పుడు పవిత్రుడైనవాడు ఒకడు ఆ ఆవు బూడిదను పోగు చేయాలి. అతడు నివాసానికి బయట పరిశుభ్రమైన స్థలంలో ఆ బూడిదను ఉంచుతాడు ప్రజలు పవిత్రులయ్యేందు కోసం ఒక ప్రత్యేక ఆచారాన్ని పాటించేటప్పుడు ఈ బూడిద ఉపయోగించబడుతుంది. ఒక వ్యక్తి పాపాలను తొలగించేందుకు కూడా ఈ బూడిద ఉపయోగించబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","“ఆవు బూడిదను పోగుచేసే వ్యక్తి తన బట్టలు ఉదుక్కోవాలి. అతను సాయంత్రం వరకు అపవిత్రంగా ఉంటాడు. “ఈ నియమం శాశ్వతంగా కొనసాగుతుంది. ఇశ్రాయేలు పౌరులకు, మీతో కలసి నివసిస్తున్న విధేశీయులకు ఈ నియమం వర్తిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","ఎవరైనా ఒకరు ఒక శవాన్ని తాకితే, అప్పుడు అతుడు ఏడు రోజులు అపవిత్రంగా ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","ప్రత్యేక జలంతో మూడోరోజున, మళ్లీ ఏడో రోజున అతడు తనను తాను కడుక్కోవాలి. అతడు ఇలా చేయకపోతే అపవిత్రంగానే ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ఒకడు ఒక శవాన్ని తాకితే అతడు అపవిత్రుడు. అతడు అపవిత్రుడుగానే ఉండి, పవిత్ర గుడారానికి వెళ్తే, అప్పుడు ఆ పవిత్ర గుడారం అపవిత్రం అవుతుంది. కనుక అతనిని ఇశ్రాయేలు ప్రజల్లోనుంచి తొలగించి వేయాలి. ఒక అపవిత్రునిమీద ప్రత్యేకజలం చల్లకపోతే అతడు అపవిత్రంగానే ఉండిపోతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“తమ గుడారాల్లోనే మరణించే వారిని గూర్చిన నియమం ఇది. ఒకడు తన గుడారంలో మరణిస్తే, ఆ గుడారంలో ఉన్న ప్రతి ఒక్కరూ అపవిత్రులే. ఏడు రోజులపాటు వారు అపవిత్రం అవుతారు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","మూతలేని ప్రతి పాత్ర అపవిత్రం అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","ఏ మనిషిగాని శవాన్నిగాని ముట్టుకొంటే, ఆ మనిషి అపవిత్రుడుగా ఏడు రోజులు ఉంటాడు. శవం బయట పొలంలో ఉన్నా, లేక యుద్ధంలో చచ్చిన వానిదైనా సరే ఇదే వర్తిస్తుంది. మరియు చచ్చిన మనిషి ఎముకను ఒక దాన్ని ఎవరైనా ముట్టుకుంటే అప్పుడ అతడు అపవిత్రుడౌతాడు ");
INSERT INTO tel2010_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“కనుక అతనిని మరల పవిత్రం చేయటానకి దహించబడ్డ ఆవు బూడిదను నీవు ప్రయోగించాలి. పాత్రలో బూడిద మీద స్వచ్ఛమైన నీళ్లు పోయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","పవిత్రుడు ఒకడు హిస్సోపు కొమ్మను తీసుకుని, దానిని ఆ నీళ్లలో ముంచాలి. అప్పుడు అతడు గుడారంమీదా, గిన్నెలమీదా, గుడారంలోని మనుష్యులందరి మీదా దానిని చల్లాలి. శవాన్ని ముట్టు కొన్న ఎవరికైనా నీవు ఇలాగే చేయాలి. యుద్ధంలో చంపబడిన ఒకరి శవాన్ని ముట్టుకొనిన ఎవరికైనా సరే, చచ్చిన మనిషి ఎముకను తాకిన ఎవరికైనా సరే నీవు ఇలాగే చేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","“అప్పుడు పవిత్రంగా ఉన్న ఒక మనిషి అపవిత్రంగా ఉన్న వానిమీద మూడో రోజున, మరల ఏడో రోజున ఈ నీళ్లు చల్లాలి. ఏడో రోజున అతడు పవిత్రం అవుతాడు. అతడు తన వస్త్రాలను నీళ్లలో ఉతుక్కోవాలి. ఆ సాయంకాలం అతడు పవిత్రుడవుతాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","“ఒక వ్యక్తి అపవిత్రుడై, పవిత్రుడుగా చేయబడకపోతే, అతడు ఇశ్రాయేలు ప్రజల్లోనుంచి వేరు చేయబడాలి. అతనిమీద ప్రత్యేక జలం చల్లబడలేదు. అతడు పవిత్రుడు కాలేదు. కనుక అతడు పవిత్ర గుడారాన్ని అపవిత్రం చేస్తాడేమో. ");
INSERT INTO tel2010_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ఇది మీకు శాశ్యత నియమం. ఒక వ్యక్తిమీద ప్రత్యేక జలం చల్లబడితే అతడు తన బట్టలను కూడ ఉదుక్కోవాలి. ఆ ప్రత్యేకజలాన్ని ముట్టినవాడు ఆ సాయంకాలంవరకు మాత్రం అపవిత్రంగానే ఉంటాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","అపవిత్రుడు ఒకడు ఇంకో వ్యక్తిని ముట్టుకుంటే అతడుకూడా అపవిత్రుడవుతాడు. అతడు ఆ సాయంత్రం వరకు అపవిత్రంగా ఉంటాడు.” ");
INSERT INTO tel2010_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","మొదటి నెల ఇశ్రాయేలు ప్రజలు సీను అరణ్యానికి వచ్చారు. ప్రజలు కాదేషులో నివాసం చేసారు. మిర్యాము చనిపోయి, అక్కడే పాతి పెట్టబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ఆ స్థలంలో ప్రజలకు చాలినంతగా నీళ్లు లేవు. కనుక ప్రజలు మోషే, అహరోనులతో ఫిర్యాదు చేయటానికి సమావేశమయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","ప్రజలు మోషేతో వాదించారు. వారు ఇలా అన్నారు: “ఒక వేళ మా సోదరుల్లా మేము కూడా యెహోవా ఎదుట మరణించి ఉంటేబాగుండేది. ");
INSERT INTO tel2010_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","యెహోవా ప్రజలను నీవు ఈ అరణ్యంలోనికి ఎందుకు తీసుకొచ్చావు? మేమూ, మా పశువులూ ఇక్కడే చావాలని కోరుతున్నావా? ");
INSERT INTO tel2010_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ఈజిప్టు నుండి మమ్మల్ని ఎందుకు తీసుకొచ్చావు? ఈ పనికిమాలిన చోటుకు మమ్మల్ని నీవెందుకు తీసుకుచ్చావు? ఇక్కడ ధాన్యం లేదు. అంజూరపు పండ్లు, ద్రాక్షాపండ్లు, దానిమ్మ పండ్లు ఏమీ లేవు. కనీసం తాగటానికి నీళ్లు కూడ లేవు.” ");
INSERT INTO tel2010_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","కనుక మోషే, అహరోను ఆ జవాన్ని విడిచి, సన్నిధి గుడార ద్వారం దగ్గరకు వెళ్లారు. వారు సాష్టాంగపడగా యెహోవా మహిమ ప్రత్యక్షమయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","యెహోవా మోషేతో మాట్లాడాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“నీ సోదరుడు అహరోనును, ఈ జనాన్ని తీసుకుని ఆ బండ దగ్గరకు వెళ్లు నీ కర్ర కూడా తీసుకుని వెళ్లు. ఆ బండ ఎదుట ప్రజలతో మాట్లాడు. అప్పుడు ఆ బండనుండి నీళ్లు ప్రవహిస్తాయి. అప్పుడు ప్రజలకు, పశువులకు నీవు ఆ నీళ్లు ఇవ్వవచ్చును” అన్నాడు ఆయన. ");
INSERT INTO tel2010_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","కనుక యెహోవా చెప్పిన ప్రకారం మోషే ఆయన ఎదుటనుండి కర్ర తీసుకున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","అప్పుడు ప్రజలంతా ఆ బండ ముందు సమావేశం కావాలని మోషే, అహరోను వారితో చెప్పారు. అప్పుడు మోషే, “మీరు ఎప్పుడూ సణుగుతున్నారు. ఇప్పుడు నా మాటవినండి. ఈ బండలోనుండి నీళ్లు వచ్చేటట్టు మేము చేస్తాము”అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","మోషే తన చేయి పై కెత్తి రెండుసార్లు ఆ బండను కొట్టాడు. బండనుండి నీళ్లు ప్రవహించటం మొదలయ్యింది. ప్రజలు, పశువులు ఆ నీళ్లు త్రాగారు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","అయితే మోషే, ఆహరోనులతో యెహోవా అన్నాడు: “ఇశ్రాయేలు ప్రజలంతా చుట్టూచేరారు. కానీ మీరు నాకు ఘనత చూపలేదు. నీళ్లను ప్రవహింప జేసిన శక్తి నా దగ్గరనుండి వచ్చిందని ఇశ్రాయేలు ప్రజలకు మీరు చూపించలేదు. మీరు నన్ను నమ్ముకొన్నట్టుగా మీరు ప్రజలకు చూపించలేదు. ఆ ప్రజలకు నేను వాగ్దానం చేసిన దేశాన్ని వారికి ఇస్తాను. అయితే వాళ్లను ఈ దేశంలోనికి నడిపించేవాళ్లు మాత్రం మీరు కారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ఈ స్థలం మెరీబా జలాలు అని పిలువబడింది. ఇక్కడనే ఇశ్రాయేలు ప్రజలు యెహోవాతో వాదించారు. ఆయన పవిత్రుడని యెహోవా ఇక్కడనే వారికి చూపించాడు.! ");
INSERT INTO tel2010_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","మోషే కాదేషులో ఉన్నప్పుడు, కొందరు మనుష్యులను ఎదోము రాజు దగ్గరకి పంపి ఈలాగు చెప్పమన్నాడు. ఆ సందేశం ఇది: “మీ సోదరులైన ఇశ్రాయేలీయులు మీతో చెప్పేది ఏమంటే: మాకు కలిగిన కష్టాలన్నీ నీకు తెలుసు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","చాల సంవత్సరాల క్రిందట మా పూర్వీకులు ఈజిప్టు వెళ్లారు. చాల సంవత్సరాలు మేము అక్కడ జీవించాము. ఈజిప్టు ప్రజలు మా యెడల కృ-రంగా ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","అయితే మేము యెహోవాను సహాయం అడిగాము. యెహోవా మా మొర విని, మాకు సహాయం చేసేందుకు ఒక దేవదూతను పంపించాడు. యెహోవా మమ్మల్ని ఈజిప్టునుండి బయటకు రప్పించాడు. “ఇదిగో ఇప్పుడు మేము నీ దేశ సరిహద్దు అయిన కాదేషులో ఉన్నాము. ");
INSERT INTO tel2010_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","దయచేసి నీ దేశంలో నుంచి మమ్మల్ని ప్రయాణం చేయనివ్వు. పొలాల్లోనుంచి, ద్రాక్షా తోటల్లోనుంచి మేము నడువము. మీ బావుల్లో దేనినుండి మేము నీళ్లు తాగము. రాజమార్గంలో మాత్రమే మేము ప్రయాణం చేస్తాము. ఆ మార్గర నుండి కుడికి గాని ఎడమకు గాని మేము తొలగము. మీ దేశం దాటిపోయేంత వరకు మేము రాజ మార్గాననే ఉంటాము.” ");
INSERT INTO tel2010_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","అయితే ఎదోము రాజు, “మీరు మా దేశంలోనుండి ప్రయాణం చేయగూడదు. మా దేశంలోనుండి ప్రయాణం చేయటానికి మీరు ప్రయత్నిస్తే, మేము వచ్చి కత్తులతో మీతో పోరాడుతాము” అని జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","ఇశ్రాయేలు ప్రజలు, “మేము రహదారి వెంబడే ప్రయాణం చేస్తాము. మా పశువులు మీ నీళ్లు ఏమైనా తాగితే, దానికి మేము వెల చెల్లిస్తాము. మేము మీ దేశంలోనుంచి నడుస్తాము, అంతే. అంతేగాని, దాన్ని మేము తీసుకోము” అని జవాబిచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","అయితే, “మేము మిమ్మల్ని మా దేశంలోంచి పోనియ్యము” అని ఎదోము జవాబిచ్చాడు. అప్పుడు ఎదోము రాజు బలంగల విస్తార సైన్యాన్ని సమకూర్చుకొని, ఇశ్రాయేలు ప్రజలతో పోరాడటానికి వారి మీదికి వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ఇశ్రాయేలు ప్రజలను తన దేశంగుండా వెళ్లనిచ్చేందుకు ఎదోము రాజు నిరాకరించాడు. ఇశ్రాయేలు ప్రజలు వెనక్కు తిరిగి మరో మార్గంగుండా వెళ్లిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ఇశ్రాయేలు ప్రజలంతా కాదేషు నుండి హోరు కొండకు ప్రయాణం చేస్తారు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","హోరు కొండ ఎదోము సరిహద్దుకు దగ్గర్లో ఉంది. మోషే, అహరోనులతో యెహోవా చెప్పాడు, ");
INSERT INTO tel2010_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“అహరోను తన పూర్వీకుల దగ్గరకు వెళ్తాడు ఇశ్రాయేలు ప్రజలకు నేను వాగ్దానం చేసిన దేశంలో అతడు ప్రవేశించాడు. మోషే, అహరోనూ, మీరు మెరీబా జలాల దగ్గర నేను మీరు ఇచ్చిన ఆజ్ఞకు పూర్తిగా విధేయులు కాలేదుగనుక నేను మీతో ఇలా చెబుతున్నాను: ");
INSERT INTO tel2010_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","“అహరోనును, అతని కుమారుడైన ఎలీయాజరును హోరు కొండమీదికి తీసుకుని రా. ");
INSERT INTO tel2010_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","అహరోను ప్రత్యేక దుస్తులు అతని దగ్గరనుండి తీసుకుని, అతని కుమారుడైన ఎలీయాజరుకు వాటిని తొడిగించు. అహరోను కొండమీద మరణిస్తాడు. అతడు తన పూర్వీకుల దగ్గరకు వెళ్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","యెహోవా ఆజ్ఞకు మోషే విధేయుడయ్యాడు. మోషే, అహరోను, ఎలీయాజరు హోరు కొండ శిఖరం మీదికు వెళ్లారు. వారు వెళ్లటం ఇశ్రాయేలు ప్రజలంతా చూసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","అహరోను వస్త్రాలన్నీ తీసి అతని కుమారుడైన ఎలీయాజరు మీద వేసాడు మోషే. అప్పుడు అహరోను ఆ కొండ శిఖరం మీద చనిపోయాడు. మోషే, ఎలీయాజరు కొండ దిగి క్రిందికి వచ్చారు. ");
INSERT INTO tel2010_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","అప్పుడు అహరోను చనిపోయినట్టు ప్రజలంతా తెలుసుకొన్నారు. కనుక ఇశ్రాయేలులో ప్రతి వ్యక్తి 30 రోజులపాటు సంతాపపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","కనానీ ప్రజల రాజు పేరు అరాదు. అతడు నెగెవు లోయలో నివసించాడు. ఇశ్రాయేలు ప్రజలు అతారీము దారిన వస్తున్నారని అరాదు రాజు విన్నాడు. కనుక రాజు బయలుదేరి వెళ్లి ఇశ్రాయేలు ప్రజల మీద దాడి చేసాడు. వారిలో కొందరిని అతడు బంధించి, బందీలుగా చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","ఇశ్రాయేలు ప్రజలు యెహోవాతో, “యెహోవా, దయచేసి ఈ ప్రజలను రక్షించు. వారిని మరల మా దగ్గరకు తీసుకునిరా. ఇది నీవు చేస్తే, మేము వారి పట్టణాలను సర్వనాశనం చేస్తాము” అని ప్రమాణం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ఇశ్రాయేలు ప్రజల మాట యెహోవా ఆలకించాడు. ఇశ్రాయేలు ప్రజలు కనానీ ప్రజలను ఓడించటానికి యెహోవా సమ్మతించాడు. కనానీ ప్రజలను, వారి పట్టణాలను ఇశ్రాయేలు ప్రజలు పూర్తిగా నాశనంచేసారు. అందుచేత ఆ స్థలానికి హోర్మ అని పేరు పెట్టబడింది. ");
INSERT INTO tel2010_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","ఇశ్రాయేలు ప్రజలు హోరు కొండ విడిచి ఎర్ర సముద్రానికి వెళ్లే మార్గంలో ప్రయాణం చేసారు. ఎదోము అనే ప్రాంతాన్ని చుట్టి వచ్చేందుకు వారు ఇలా చేసారు. కానీ ప్రజల్లో సహనం లేదు. ప్రయాణం చేస్తూ దూరాన్ని గూర్చి వారు సణిగారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","దేవునికి, మోషేకు ప్రజలు వ్యతిరేకంగా మాట్లాడారు. “మమ్మల్ని ఈజిప్టునుండి నీవెందుకు తీసుకుచ్చావు? మేము ఇక్కడ అరణ్యంలోనే చస్తాము! రొట్టెలేదు, నీళ్లు లేవు. ఈ దారుణమైన ఆహారం మాకు అసహ్యము” అన్నారు ప్రజలు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","కనుక విష సర్పాలను ఆ ప్రజల మధ్యకు యెహోవా పంపించాడు. ఆ పాములు ప్రజలను కరిచాయి. ఇశ్రాయేలు ప్రజలు చాల మంది చనిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ప్రజలు మోషే దగ్గరకు వచ్చి, “యెహోవాకు, నీకు వ్యతిరేకంగా మాట్లాడి మేము పాపం చేసామని మాకు తెలుసు. యెహోవాకు ప్రార్థన చేసి ఈ పాములను తీసివేయమని అడుగు” అని చెప్పారు. కనుక ఆ ప్రజల కోసం మోషే ప్రార్థించాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","“ఇత్తడి సరం ఒకటి చేసి దాన్ని ఒక స్తంభం మీద ఉంచు. పాము కరిచిన వ్యక్తి ఆ స్తంభం మీది ఇత్తడి సర్పాన్ని చూడాలి. అప్పుడు అతడు చావడు”అని యెహోవా మోషేతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","కనుక మోషే యెహోవా చెప్పినట్టు చేసాడు. అతడు ఒక ఇత్తడి సర్పాన్ని చేసి, ఒక స్తంభం మీద దాన్ని పెట్టాడు. అప్పుడు ఎవర్నయినా పాము కరిస్తే, ఆ మనిషి స్తంభం మీది ఇత్తడి సర్పాన్ని చూచి బతికాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","ఇశ్రాయేలు ప్రజలు ప్రయాణం కొన సాగించారు. ఓబోతు అనే చోట వారు నివాసం చేసుకొనిరి. ");
INSERT INTO tel2010_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","తర్వాత ఆ ప్రజలు ఓబోతునుండి ఈయ్యె అబారీము వెళ్లారు. ఇది తూర్పున మోయాబు సమీపంగా అరణ్యంలో ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","తర్వాత ప్రజలు ఆ స్థలం విడిచి, జెరెదు లోయకు ప్రయాణం చేసారు. అక్కడ నివాసాలు చేసుకొనిరి. ");
INSERT INTO tel2010_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","మళ్లీ ప్రజలు అర్నోను లోయకువచ్చి, అక్కడికి సమీపంలో నివాసం చేసుకొనిరి. ఇవి అమోరీయ దేశానికి దగ్గర్లో ఉన్న అరణ్యంలో ఉంది. మోయాబు ప్రజలను అమోరీ ప్రజలకు అర్నోనులోయ సరిహద్దు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","అందుకే యెహోవా యుద్ధాల గ్రంథంలో ఇలా కనబడుతుంది. “సుప్పాలోని వాహేబు, అర్నోను లోయలు, ");
INSERT INTO tel2010_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","ఆరు అను పట్టణం వరకుగల లోయల పక్క కొండలు. ఈ స్థలాలు మోయాబు సరిహద్దులో ఉన్నాయి.” ");
INSERT INTO tel2010_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","ఇశ్రాయేలు ప్రజలు ఆ స్థలం విడిచి బెయేరు చేరారు. ఈ స్థలంలో ఒక బావి ఉంది. యెహోవా “ప్రజలను ఇక్కడికి తీసుకొనిరా. నేను వారికి నీళ్లిస్తాను” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","అప్పుడు ఇశ్రాయేలు ప్రజలు ఈ పాట పాడారు, “బావీ, ఉప్పొంగి ప్రవహించు, దానిగూర్చి పాడండి! ");
INSERT INTO tel2010_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","మహాత్ములు ఈ బావి తవ్వారు. ప్రముఖ నాయకులు ఈ బావి తవ్వారు. అధికార దండములతో, కర్రలతో వారు ఈ బావి తవ్వారు. అరణ్యంలో ఇది ఒక కానుక.” మత్తాన అని పిలువబడే ఈ బావి దగ్గర ప్రజలు ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","అప్పుడు ప్రజలు మత్తానానుండి నహలీయేలుకు ప్రయాణం చేసారు. మళ్లీ వారు నహలీయేలు నుండి బామోతుకు ప్రయాణం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","బామోతునుండి మోయాబు లోయకు ప్రజలు ప్రయాణం చేసారు. ఇక్కడ ఎడారికి ఎదురుగా పిస్గా శిఖరం కనబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","అమోరీ ప్రజల రాజు సీహోను దగ్గరకు ఇశ్రాయేలు ప్రజలు కొందరు మనుష్యుల్ని పంపారు. వారు ఆ రాజుతో ");
INSERT INTO tel2010_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“మమ్మల్ని నీ దేశంలో నుండి ప్రయాణం చేయనివ్వు. మేము పొలాల్లోనుంచి గాని, ద్రాక్షా తోటల్లోనుంచిగాని నడువము. నీ బావుల్లోనుంచి నీళ్లు తాగము. రాజ మార్గంలోనే మేము నడుస్తాము. నీ దేశం దాటి వెళ్లేంతవరకు మేము ఆ మార్గంలోనే ఉంటాము” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","అయితే సీహోను రాజు ఇశ్రాయేలు ప్రజలను తన రాజ్యంలోనుండి ప్రయాణం చేయనియ్యలేదు. రాజు తన సైన్యాన్ని సమకూర్చుకొని అరణ్యంలోకి నడిపించాడు. ఇశ్రాయేలు ప్రజలమీదికి అతడు వెళ్తూఉన్నాడు. యాహజు అనే చోట ఆ రాజు సైన్యం ఇశ్రాయేలు ప్రజల మీద యుద్ధం చేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","కానీ ఇశ్రాయేలు ప్రజలు ఆ రాజును చంపారు. అప్పుడు అర్నోను లోయ మొదలుకొని యబ్భోకు ప్రాంతంవరకు అతని దేశాన్ని వారు స్వాధీనం చేసుకొన్నారు. అమ్మోనీ ప్రజల సరిహద్దు వరకు ఇశ్రాయేలు ప్రజలు స్వాధీనం చేసుకొన్నారు. అమ్మోనీ ప్రజలు ఆ సరిహద్దును చాల గట్టిగా కాపాడు తున్నందుచేత వారు అంతకంటె ఎక్కువ భూమిని స్వాధీనం చేసుకోలేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","అమోరీయుల ఈ పట్టణాలన్నింటినీ ఇశ్రాయేలీయులు స్వాధీనం చేసికొని, అమోరీయుల పట్టణాలన్నింటిలో హెష్బోను, దాని చుట్టు పక్కల ఉన్న చిన్న చిన్న పట్టణాలన్నింటిలోను వారు నివసించటం మొదలు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","సీహోను రాజు నివసించిన పట్టణం హెష్బోను. గతంలో మోయాబు రాజును సీహోను ఓడించాడు. అందువల్ల అర్నోను లోయవరకు మోయాబు దేశాన్ని సీహోను రాజు స్వాధీనం చేసుకొన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","అందుకే గాయకులు ఇలా పాడతారు: “హెష్బోనూ, నీ నిర్మాణం మళ్లీ జరగాలి. సీహోను పట్టణం మళ్లీ కట్టబడును గాక! ");
INSERT INTO tel2010_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","హెష్బోనులో అగ్ని రగులుకొంది. ఆ అగ్ని సీహోను పట్టణంలో రగులుకొంది. ఆర్, మోయాబులను అగ్ని నాశనం చేసింది. అర్నోను ఉన్నత స్థలాల కొండలను అది కాల్చేసింది. ");
INSERT INTO tel2010_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ఓ మోయాబూ, అది నీకు కీడు. కెమోషు ప్రజలు నాశనం చేయబడ్డారు. అతని కుమారులు పారిపోయారు. అమోరీ ప్రజల రాజైన సీహోను చేత అతని కుమార్తెలు బందీలు చేయబడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","అయితే మేము ఆ అమోరీలను ఓడించాము. హెష్బోను నుండి దీబోను వరకు నషీమునుండి మేదెబా దగ్గరి నొఫహువరకు వారి పట్టణాలను మేము నాశనం చేసాం.” ");
INSERT INTO tel2010_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","కనుక ఇశ్రాయేలు ప్రజలు అమోరీ ప్రజల దేశంలో నివాసం ఏర్పరచుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","యాజెరు పట్టణాన్ని చూచి రమ్మని మోషే కొందరు మనుష్యుల్ని పంపించాడు. మోషే ఇలా చేసిన తర్వాత, ఇశ్రాయేలు ప్రజలు ఆ పట్టణాన్ని స్వాధీనం చేసుకున్నారు. దాని చుట్టూ ఉన్న చిన్న చిన్న పట్టణాలను కూడ వారు స్వాధీనం చేసుకున్నారు. అక్కడ నివసిస్తున్న అమోరీ ప్రజలు పారిపొయ్యేటట్టుగా ఇశ్రాయేలు ప్రజలు వారిని తరిమివేసారు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","అప్పుడు ఇశ్రాయేలు ప్రజలు బాషాను దారిన ప్రయాణం చేసారు. బాషాను రాజైన ఓగు తన సైన్యాన్ని సిద్ధం చేసి ఇశ్రాయేలు ప్రజల మీదికి వెళ్లాడు. ఎద్రేయి అనే చోట అతడు వారితో యుద్ధం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","అయితే యెహోవా, “ఆ రాజును గూర్చి భయపడవద్దు. మీరు అతన్ని ఓడించునట్లు నేను చేస్తాను. మొత్తం అతని సైన్యాన్ని, దేశాన్ని కూడ మీరు స్వాధీనం చేసుకొంటారు. అమోరీ ప్రజల రాజైన హెష్బోనులో నివసించిన సీహోనుకు చేసినట్టే ఇతనికి కూడచేయండి” అని మోషేతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","కనుక ఓగును, అతని సైన్యాన్ని ఇశ్రాయేలు ప్రజలు ఓడించేసారు. అతన్ని, అతని కుమారులను, అతని సైన్యం అంతటినీ వారు చంపారు. అప్పుడు అతని దేశం అంతా ఇశ్రాయేలు ప్రజలు స్వాధీనం చేసుకున్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","తర్వాత ఇశ్రాయేలు ప్రజలు మోయాబు మైదానాలకు ప్రయాణం చేసారు. యెరికోకు ఎదురుగా యొర్దాను నది దగ్గర వారు నివాసాలు కట్టుకొనిరి. ");
INSERT INTO tel2010_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","3","ఇశ్రాయేలు ప్రజలు అమోరీ ప్రజలకు చేసిన వాటన్నిటినీ సిప్పోరు కుమారుడైన బాలాకు చూసాడు. ఇశ్రాయేలు ప్రజలు చాలమంది ఉండటం చూచి, మోయాబు రాజైన భయపడ్డాడు. ఇశ్రాయేలు ప్రజలంటే మోయాబువాళ్లు భయపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","మోయాబు రాజు “ఆవు పొలంలో గడ్డి అంతా తినివేసినట్టు ఈ గొప్ప ప్రజా సమూహం మన చుట్టూ ఉన్న మొత్తం నాశనం చేసేస్తుంది” అని మిద్యాను నాయకులతో చెప్పాడు. అప్పట్లో సిప్పోరు కుమారుడైన బాలాకు మోయాబు రాజు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","బెయారు కుమారుడు బిలామును పిలువమని అతడు మనుష్యులను పంపించాడు. బిలాము యూఫ్రటీసు నది దగ్గర పెతోరు అనే చోట ఉన్నాడు. బాలాకు ఈ విధంగా సందేశం పంపాడు: “ఈజిప్టునుండి ఒక కొత్త జాతి ప్రజలు వచ్చారు. దేశం అంతా కమ్మే సేటంతమంది ఉన్నారు వారు. వాళ్లు నా ప్రక్కనే గుడారాలు వేసుకొన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","వీళ్లను ఎదుర్కోటానికి నీవు వచ్చి నాకు సహాయం చేయి. అప్పుడు ఒకవేళ వారిని ఓడించగలనేమో వారి ముందు నా బలం చాలదు. అప్పుడు వారిని నా దేశంనుండి తరిమివేయగలను. నీకు గొప్పశక్తి ఉందని నాకు తెలుసు. నీవు ఎవరినైనా ఆశీర్వదిస్తే, వారికి మేలు జరుగుతుంది. నీవు ఎవరినైనా శపిస్తే వారికి కీడు జరుగుతుంది. అందుచేత వచ్చి ఈ ప్రజలను శపించు. అప్పుడు, నేను వారిని ఈ దేశం నుండి తోలి వేయగలను.” ");
INSERT INTO tel2010_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","మోయాబు, మిద్యాను నాయకులు వెళ్లిపోయారు. బిలాముతో మాట్లాడటానికి వారు వెళ్లారు. అతని సేవకోసం అతనికి చెల్లించేందుకు వారు డబ్బు తీసుకుని వెళ్లారు. బాలాకు చెప్పిన విషయం వారు అతనికి చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","బిలాము, “ఈ రాత్రికి మీరు ఇక్కడ ఉండండి. నేను యెహోవాతో మాట్లాడి, ఆయన నాకు అచ్చే జవాబు మీకు చెబుతాను” అని వారితో చెప్పాడు. అందుచేత మోయాబు ప్రజా నాయకులు ఆ రాత్రి వారితో ఉండిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","దేవుడు బిలాము దగ్గరకు వచ్చి, “నీతో ఉన్న ఈ మనుష్యులు ఎవరు?” అని అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","బిలాము దేవునితో చెప్పాడు: “మోయాబు రాజును, సిప్పోరు కుమారుడునైన బాలాకు నాకు ఒక కబురు చెప్పమని వారిని పంపాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","ఆ సందేశం ఇది: ఈజిప్టునుండి ఒక కొత్త దేశపు జనాంగం వచ్చింది. వారు భూమి అంతా నిండిపొయ్యేంత మంది ఉన్నారు. కనుక వచ్చి వీళ్లను శపించు, అప్పుడు ఒకవేళ నేను వాళ్లతో యుద్ధం చేసి నా దేశంనుండి వెళ్లగొట్ట గలుగుతానేమో.” ");
INSERT INTO tel2010_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","అయితే దేవుడు, “వాళ్లతో వెళ్లవద్దు. ఈ ప్రజలను నీవు శపించకూడదు. వీరు నా ప్రజలు” అని బిలాముతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","మరునాటి ఉదయం బిలాము లేచి, “మీ స్వదేశానికి తిరిగి వెళ్లిపొండి. యెహోవా నన్ను మీతో వెళ్ల నివ్వడు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","కనుక మోయాబు నాయకులు తిరిగి బాలాకు దగ్గరకు వెళ్లిపోయి అతనితో, “మాతో రావటానికి బిలాము నిరాకరించాడు” అని చెప్పారు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","కనుక బాలాకు మరికొందరు నాయకులను బిలాము దగ్గరకు పంపించాడు. మొదటి సారికంటే ఈ సారి చాల ఎక్కువ మందిని అతడు పంపించాడు. మొదటిసారి అతడు పంపిన వారికంటె వీరు ప్రముఖ నాయకులు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","వారు బిలాము దగ్గరకు వెళ్లి చెప్పారు: “సిప్పోరు కుమారుడైన బాలాకు నీతోఇలా చెప్పమన్నాడు. దయచేసి నీవు రాకుండా ఏదీ నిన్ను అడ్డుపెట్టనియ్యకు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","నేను అడిగిన దాన్ని నీవు చేస్తే, నేను నీకు విస్తారంగా డబ్బు ఇస్తాను. నీవు వచ్చి, నా పక్షంగా ఈ ప్రజలను శపించు.” ");
INSERT INTO tel2010_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","కానీ బిలాము ఆ మనుష్యులకు తన జవాబిచ్చాడు. అతడు ఇలా చెప్పాడు: “నా దేవుడైన యెహోవాకు నేను విధేయుడ్ని కావాలి. ఆయన ఆజ్ఞకు వ్యతిరేకంగా నేనేమి చేయలేను. నేను చెయ్యొచ్చు అని నా ప్రభువు చెబితేనే తప్ప లేకపోతే సామాన్యమైనదైనా గొప్పదైనా నేనేమి చేయలేను. బాలాకు రాజు అందమైన తన భవనమంతా వెండి బంగారాలతో నింపి నాకు ఇచ్చినా సరే, నా ప్రభువు ఆజ్ఞకు వ్యతిరేకంగా నేనేమి చేయను. ");
INSERT INTO tel2010_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","అయితే ఇదివరకు వచ్చిన వారిలాగే మీరు ఈ రాత్రి ఇక్కడ వుండవచ్చు. ఈ రాత్రి యెహోవా నాతో ఏమి చెబుతాడో నేను తెలుసుకొంటాను.” ");
INSERT INTO tel2010_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ఆ రాత్రి యెహోవా బిలాము దగ్గరకు వచ్చి, “ఈ మనుష్యులు వారితో కూడ నిన్ను రమ్మని అడగటానికి మళ్లీ వచ్చారు. కనుక నీవు వారితో వెళ్లవచ్చు. అయితే నేను నీతో ఏమి చెబుతానో అలా మాత్రమే చేయాలి” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","మరునాడు ఉదయాన్నే బిలాము లేచి తన గాడిదకు గంత కట్టాడు. అప్పుడు అతడు మోయాబు నాయకులతో వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","బిలాము తన గాడిద మీద వెళ్తున్నాడు. అతని ఇద్దరు సేవకులు అతనితో ఉన్నారు. బిలాము ప్రయాణం చేస్తుండగా దేవునికు కోపం వచ్చింది. కనుక యెహోవా దూత మార్గంలో బిలాము ఎదుట నిలబడ్డాడు. ఆ దూత బిలామును ఆపుజేయబోతున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","దారిలో యెహోవా దూత నిలబడటం బిలాము గాడిద చూచింది. ఆ దూత చేతిలో ఖడ్గం ఉంది. కనుక గాడిద దారి తొలగి పక్క పొలంలోకి వెళ్లింది. బిలాము యెహోవా దూతను చూడలేదు. అందుచేత అతనికి తన గాడిద మీద చాల కోపం వచ్చింది. అతడు గాడిదను కొట్టి, మళ్లీ దారి మీదికి వెళ్లేందుకు దాన్ని బలవంతం చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","తర్వాత ఆ దారిలో ఇరుకైన చోట యెహోవా దూత నిలబడ్డాడు. ఇది రెండు ద్రాక్ష తోటల మధ్యఉంది. దారికి రెండు వైపులా గోడలు ఉన్నాయి ");
INSERT INTO tel2010_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","మళ్లీ ఆ గాడిద యెహోవా దూతను చూచింది. అందుచేత ఆ గాడిద గోడకు రాసుకొనే అంత దగ్గరగా వెళ్లింది. కనుక బిలాము పాదం గోడకేసి నొక్కేసింది. బిలాము తన గాడిదను మళ్లీ కొట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","తర్వాత యెహోవా దూత మరో చోట నిలబడ్డాడు. ఇది కూడ ఇరుకు దారి. గాడిద వెనుకకు తిరిగే అంత చోటుకూడ అక్కడలేదు. ఆ గాడిద కుడికి ఎడమకు కూడ తిరుగలేక పోయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","యెహోవాను ఆ గాడిద మళ్లీ చూచింది. కనుక బిలాముతో సహా ఆ గాడిద కూలబడింది. బిలాముకు ఆ గాడిద మీద చాలా కోపం వచ్చింది. అందుచేత అతడు తన కర్రతో దాన్ని కొట్టాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","అప్పుడు యోహోవా ఆ గాడిద మాట్లాడేటట్టు చేసాడు. ఆ గాడిదా, “నీవు నా మీద ఎందుకు కోపగించు కొంటున్నావు? నీకు నేనేమి చేసాను? నీవు నన్ను మూడుసార్లు కొట్టావు” అంది బిలాముతో. ");
INSERT INTO tel2010_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","“నన్ను ఒక వెర్రివాడిలా చేసావు నీవు. నా చేతిలోనే గనుక ఒక కత్తి ఉంటే, ఈ పాటికి నిన్ను నరికేసి ఉండేవాడ్ని” అన్నాడు బిలాము తన గాడిదతో. ");
INSERT INTO tel2010_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","అయితే ఆ గాడిద “ఎన్నేన్నో సంవత్సరాలుగా నీవు స్వారీ చేస్తున్న నీ సొంత గాడిదను నేను. ఇంతకు ముందు ఎన్నడూ నేను నీకు ఇలా చేయలేదని నీకు తెలుసు” అంది బిలాముతో. “అది నిజమే” బిలాము అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","అప్పుడు దారి మీద నిలబడ్డ దేవదూతను బిలాము చూడగలిగేటట్టు చేసెను యోహోవా. ఆ దేవదూతను, అతని కత్తిని బిలాము చూసాడు. అప్పుడు బిలాము నేలమీద సాష్టాంగపడ్డాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","యెహోవా దూత బిలామును అడిగాడు: “నీవు నీ గాడిదను ఎందుకు మూడుసార్లు కొట్టావు? నీకు నామీద కోపం రావాలి. నిన్ను ఆపు చేయటానికే సరిగ్గా సమయానికి నేను ఇక్కడికి వచ్చాను. ");
INSERT INTO tel2010_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","గాడిద నన్ను చూచి మూడు సార్లు నా నుండి పక్కకు తప్పుకొంది. ఆ గాడిద కనుక తప్పుకొని ఉండకపోతే నిన్ను చంపేసి ఉండేవాడ్ని. కానీ నీ గాడిదను నేను చంపేవాడ్ని కాదు.” ");
INSERT INTO tel2010_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","అప్పుడు బిలాము: “నేను పాపం చేసాను. దారి మీద నీవు నిలబడ్డావని నేనెరగను. నేను చేస్తోంది తప్పు అయితే నేను తిరిగి ఇంటికి వెళ్లిపోతాను” అని యెహోవా దూతతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","“లేదు! ఈ మనుష్యులతో, నీవు వెళ్లవచ్చు. అయితే జాగ్రత్తగా ఉండు. నీవు చెప్పాలని నేను నీతో చెప్పేమాటలే నీవు చెప్పాలి” అన్నాడు బిలాముతో యెహోవా దూత. కనుక బాలాకు పంపిన మనుష్యులతో బిలాము వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","బిలాము వస్తున్నాడని బాలాకు విన్నాడు. కనుక అర్నోను సపిహద్దులో ఉన్న మోయాబు పట్టణం దగ్గర అతణ్ణి కలుసుకొనేందుకు బాలాకు వెళ్లాడు. ఇది అతని దేశపు పొలిమేర. ");
INSERT INTO tel2010_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","బాలాకు బిలామును చూడగానే “నీవు రావాలని ఇది చాలా ముఖ్యమయిందని ఇంతకు ముందే నీతో చెప్పాను. నీవు నా దగ్గరకు ఎందుకు రాలేదు? నేను నీకు ఇప్పుడు ఏమీ చెల్లించ లేకపోవచ్చును” అన్నాడు బిలాముతో. ");
INSERT INTO tel2010_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","అయితే బిలాము: “ఇప్పుడు నేను నీ దగ్గరకు వచ్చాను. కానీ నీవు అడిగింది మాత్రం నేను చేయలేక పోవచ్చు. చెప్పమని యెహోవా దేవుడు నాకు చెప్పిన సంగతులు మాత్రమే నేను చెప్పగలను,” అని జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","అప్పుడు బిలాము బాలాకుతోకూడ కిర్యాత్ హుచ్చోతుకు వెళ్లాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","బాలాకు తన బలి అర్పణగా కొన్ని ఎడ్లను, గొర్రెలను వధించాడు. ఆ మాంసం కొంత బిలాముకు, మరికొంత అతనితో ఉన్న నాయకులకు అతడు ఇచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ఆ మర్నాటి ఉదయం బాలాకు బామోతు బయలు పట్టణానికి బిలామును తీసుకుని వెళ్లాడు. ఆ పట్టణం నుండి వారు ఇశ్రాయేలు ప్రజలు వేసుకొన్న గుడారాలను కొంత చూడగలరు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","బిలాము “ఇక్కడ ఏడు బలిపీఠాలు కట్టండి. నాకోసం ఏడు ఎద్దులు, ఏడు పొట్టేళ్లు సిద్ధంచేయండి” అని చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","బిలాము అడిగినట్టే బాలాకు దీన్ని చేసాడు. అప్పుడు బాలాకు, బిలాము ఒక్కో బలిపీఠం మీద ఒక్కో పొట్టేలును, ఒక్కో ఎద్దును వధించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","అప్పుడు బిలాము, “ఈ బలిపీఠం దగ్గరగా ఉండు. నేను ఇంకో చోటికి వెళ్తాను. అప్పుడు యెహోవా నా దగ్గరకు వచ్చి నేను చెప్పాల్సింది ఏమిటో నాకు చెబుతాడు” అని బాలాకుతో చెప్పాడు. అప్పుడు బిలాము మరో ఉన్నత స్థలానికి వెళ్లిపోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","అక్కడ దేవుడు బిలాము దగ్గరకు వచ్చాడు. “ఏడు బలిపీఠాలు నేను సిద్ధం చేసాను. ఒక్కో బలిపీఠంమీద ఒక్కో ఎద్దును ఒక్కోపొట్టేలును బలిగా నేను వధించాను” అన్నాడు బిలాము. ");
INSERT INTO tel2010_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","అప్పుడు బిలాము ఏమి చెప్పాల్సిందీ యెహోవా అతనికి చెప్పాడు. అప్పుడు, “తిరిగి వెళ్లి, చెప్పమని నేను నీకు చెప్పిన విషయాలు బాలాకుతో చెప్పు” అన్నాడు యెహోవా. ");
INSERT INTO tel2010_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","కనుక బిలాము తిరిగి బాలాకు దగ్గరకు వెళ్లాడు. బాలాకు ఇంకా బలిపీఠం దగ్గరే నిలిచి ఉన్నాడు. మోయాబు నాయకులంతా వారితో నిలిచి ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","అప్పుడు బిలాము ఈ విషయాలు చెప్పాడు: “తూర్పు కొండల్లో నుండి ఆరాము నుండి మోయాబు రాజైన బాలాకు నన్ను ఇక్కడకు తీసుకుచ్చాడు. వచ్చి ఇశ్రాయేలు ప్రజలను శపించు! ‘వచ్చి నా పక్షంగా యాకోబును శపించు, వచ్చి ఇశ్రాయేలు ప్రజలను శపించు!’ అన్నాడు నాతో బాలాకు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","దేవుడు ఆ ప్రజలకు వ్యతిరేకంగా లేడు అందుచేత నేనుకూడ వారిని శపించలేను. ఆ ప్రజల విషయమై యెహోవా చెడ్డ విషయాలను చెప్పలేదు అందుచేత నేను అలా చేయలేను. ");
INSERT INTO tel2010_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","కొండమీద నుండి నేను ఆ ప్రజలను చూస్తున్నాను. ఎత్తయిన కొండల నుండి నేను చూస్తున్నాను. ఒంటరిగా బతుకుతున్న ప్రజలను నేను చూస్తున్నాను, వాళ్లు మరో జనములో భాగంకారు యాకోబు ప్రజలను ఎవరు లెక్కించగలరు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ఇసుక రేణవులకంటె ఎక్కువ ఉన్నారు యాకోబు ప్రజలు. ఇశ్రాయేలు ప్రజల్లో నాలుగోవంతు మనుష్యుల్ని కూడ ఎవరూ లెక్కించలేరు. ఒక మంచి మనిషిగా నన్ను చావనివ్వండి ఆ మనుష్యులు మరణించినంత సంతోషంగా నన్ను మరణించనివ్వండి!” ");
INSERT INTO tel2010_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","బాలాకు బిలాముతో, “ఏమిటి నీవు నాకు చేసింది? నా శత్రువుల్ని శపించమని నేను నిన్ను ఇక్కడికి తీసుకుని వచ్చాను. కానీ నీవు మాత్రం వాళ్లను ఆశీర్వదించావు” అన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","కానీ బిలాము, “నేను చెప్పాల్సింది దేవుడు నాకు చెప్పిన విషయాలు మాత్రమే” అని జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","అప్పుడు, “అలాగైతే, నాతో మరో చోటికి రా. అక్కడకూడ నీవు మనుష్యుల్ని చూడగలవు. అయితే అందర్నీ కాదుగాని కొందర్ని మాత్రం చూడగలవు. అక్కడనుండి నీవు నా కోసం వాళ్లను శపించవచ్చు” అని అతనితో చెప్పాడు బాలాకు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","కనుక బాలాకు యోఫీం పొలంలోకి బిలామును తీసుకుని వెళ్లాడు. ఇది పిస్గా కొండ శిఖరం మీద ఉంది. ఆ స్థలంలో బాలాకు ఏడు బలిపీఠాలు కట్టించాడు. అప్పుడు బాలాకు ఒక్కో బలిపీఠం మీద ఒక్కో ఎద్దును, ఒక్కో పొట్టేలును బలిగా వధించాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","కనుక బిలాము, “ఈ బలిపీఠం దగ్గర ఉండు. నేను వెళ్లి అక్కడ దేవుడ్ని కలుసుకొంటాను” అని బాలాకుతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","కనుక యెహోవా బిలాము దగ్గరకు వచ్చి, అతడు ఏమి చెప్పాల్సిందీ అతనికి తెలియజేసాడు. అప్పుడు యెహోవా, బిలామును వెళ్లి ఆ సంగతులు బాలాకుతో చెప్పమన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","కనుక బిలాము బాలాకు దగ్గరకు వెళ్లాడు. బాలాకు ఇంకా బలిపీఠం దగ్గరే నిలిచి ఉన్నాడు. మోయాబు నాయకులు వారితోబాటు ఉన్నారు. అతడు రావటం చూచి, “ఏమి చెప్పాడు యెహోవా?” అన్నాడు బాలాకు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","అప్పుడు బిలాము ఈ విషయాలు చెప్పాడు: “బాలాకూ లేచి నా మాట విను. సిప్పోరు కుమారుడా, బాలాకూ, నా మాట విను. ");
INSERT INTO tel2010_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","దేవుడు మనిషికాడు, ఆయన అబద్ధం చెప్పడు. దేవుడు మానవ కుమారుడు కాడు, ఆయన నిర్ణయాలు మారవు. ఏదైనా చేస్తానని యెహోవా చెబితే ఆయన అలా చేస్తాడు. యెహోవా ఒక వాగ్దానం చేస్తే, ఆయన తన వాగ్దానం ప్రకారం చేస్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ఆ ప్రజలను ఆశీర్వదించమని యెహోవా నాకు ఆజ్ఞాపించాడు. యెహోవా వారిని ఆశీర్వదించాడు కనుక నేను దాన్ని మార్చలేను. ");
INSERT INTO tel2010_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","దేవునికి యాకోబు ప్రజల్లో తప్పేమీ కనబడలేదు. ఇశ్రాయేలు ప్రజల్లో ఏ పాపమూ దేవునికి కనబడలేదు. యెహోవా వారి దేవుడు, ఆయన వారితో ఉన్నాడు. మహారాజు వారితో ఉన్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","దేవుడు వారిని ఈజిప్టు నుండి బయటకు తీసుకొచ్చాడు. అడవి ఎద్దుల్లా వారు బలంగా ఉన్నారు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","యాకోబు ప్రజలను ఓడించగల శక్తి ఏదీ లేదు. ఇశ్రాయేలు ప్రజలకు ఎదురు వెళ్లగల మంత్రమూ ఏదీ లేదు. ‘దేవుడు చేసిన మహా కార్యాలను చూడండి’ అని యాకోబును గూర్చి, ఇశ్రాయేలు ప్రజలను గూర్చి మనుష్యులు అంటారు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ఆ ప్రజలు బలమైన సింహంలా ఉంటారు. సింహంలా వారు పోరాడతారు. ఆ సింహం తన శత్రువును తినివేసేంత వరకు విశ్రాంతి తీసుకోదు. తనకు వ్యతిరేకంగా ఉండేవారి రక్తం తాగేంతవరకు ఆ సింహం ఊరుకోదు.” ");
INSERT INTO tel2010_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","అప్పుడు బాలాకు, “ఆ ప్రజలకు మేలు జరగాలని నీవు అడుగలేదు గాని కీడు జరగాలని కూడ నీవు అడుగలేదు” అన్నాడు బిలాముతో. ");
INSERT INTO tel2010_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","బిలాము, “యెహోవా నాకు చెప్పిన విషయాలు మాత్రమే చెబుతానని నేను నీకు ముందే చెప్పాను” అని జవాబిచ్చాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","అప్పుడు బాలాకు, “అలాగైతే నాతో మరో బలిపీఠం దగ్గరకు రా. ఒకవేళ అక్కడ దేవుడు సంతోషించి, అక్కడనుండి ఆ ప్రజలను శపించనిస్తాడేమో” అని బిలాముతో చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","కనుక బాలాకు పీయోరు కొండకు బిలామును తీసుకుని వెళ్లాడు. ఈ కొండ నుండి అరణ్యాన్ని చూడవచ్చు. ");
INSERT INTO tel2010_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","“ఇక్కడ ఏడు బలిపీఠాలు నిర్మించు. తర్వాత బలికోసం ఏడు ఎద్దుల్ని, ఏడు పొట్టేళ్లను సిద్ధం చేయి” అన్నాడు బిలాము. ");
INSERT INTO tel2010_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","బిలాము అడిగినట్టు బాలాకు చేసాడు. ప్రతి బలిపీఠం మీద ఒక్కో ఎద్దును, ఒక్కో పొట్టేలును బాలాకు బలిగా వధించాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","ఇశ్రాయేలును యెహోవా ఆశీర్వదించాలనే కోరుతున్నట్టు బిలాము గమనించాడు. కనుక ఎలాంటి మంత్రాలు ప్రయోగించినా గాని దానిని బిలాము మార్చదలచుకోలేదు. కానీ బిలాము పక్కకు తిరిగి అరణ్యం చూసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","బిలాము అరణ్యాన్ని చూచి, అక్కడున్న ఇశ్రాయేలు ప్రజలందర్నీ చూసాడు. వారు, వారి కుటుంబాలతో ఆ ప్రదేశాల్లో నివసిస్తున్నారు. అప్పుడు దేవుని ఆత్మ బిలాము మీదికి రాగా ");
INSERT INTO tel2010_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","బిలాము ఈ విషయాలు చెప్పాడు: “బెయోరు కుమారుడు ఈ విషయాలు చెబుతున్నాడు. నా కళ్లు తేటగా చూస్తున్నాయి కనుక ఈ మాటలు పలుకుతున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","నేను దేవుని మాటలు వింటున్నాను కనుక ఈ మాటలు చెబుతున్నాను. నేను చూడాలని ఆ సర్వశక్తిమంతుడు కోరుతున్న వాటిని నేను చూడ గలుగుతున్నాను. నేను సాగిలపడి తేటగా చూసినవాటిని చెబుతున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“యాకోబు ప్రజలారా, మీ గుడారాలు చాలా అందంగా ఉన్నాయి. ఇశ్రాయేలు ప్రజలారా, మీ నివాసాలు అందంగా ఉన్నాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","భూమి మీద మీ గుడారాలు లోయల్లా పరచుకొన్నాయి. అవి నదీ తీరంలో తోటలా ఉన్నాయి. యెహోవా నాటిన అది చక్కటి సువాసనగల మొక్కలా ఉంది. అది నీళ్ల దగ్గర పెరిగే అందమైన చెట్లలా ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","మీకు ఎల్లప్పుడూ తాగటానికి కావాల్సినంత నీరు ఉంటుంది. మీ ఆహారం పండించుకోవటానికి కావాల్సినంత నీరు ఎల్లప్పుడూ ఉంటుంది మీకు. ఆ ప్రజల రాజు అగాగుకంటె గొప్పవాడుగా ఉంటాడు. వారి రాజ్యం చాలా గొప్పది అవుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“ఆ ప్రజలను ఈజిప్టునుండి దేవుడే బయటకు తీసుకొచ్చాడు. వారు అడవి ఆవు అంతటి బలంగలవారు. తమ శత్రువులందర్నీ వారు ఓడిస్తారు. వారి శత్రువుల ఎముకల్ని వారు విరుగగొడ్తారు. వారి బాణాలు వారి శత్రువుల్ని చంపేస్తాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","తన ఆహారం మీదికి ఎగబడటానికి సిద్ధంగా వున్న సింహంలా ఇశ్రాయేలీయులున్నారు. వారు నిద్రపోతున్న కొదమ సింహంలా ఉన్నారు. దానిని మేల్కొలి పేందుకు ఎవడికి ధైర్యం చాలదు. నిన్ను ఆశీర్వదించే వారు ఆశీర్వాదం పొందుతారు. నిన్ను ఎవరైనా శపిస్తే వారికి గొప్ప కష్టాలు వస్తాయి.” ");
INSERT INTO tel2010_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","అప్పుడు బాలాకు బిలాముమీద చాల కోపపడ్డాడు. బిలాముతో బాలాకు అన్నాడు: “నిన్ను వచ్చి నా శత్రువులను శపించుమని పిలిచాను. కానీ నీవు వాళ్లను ఆశీర్వదించావు. వాళ్లను మూడు సార్లు నీవు ఆశీర్వదించావు. ");
INSERT INTO tel2010_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","ఇప్పుడు ఇంటికి వెళ్లిపో. నీకు చాలా ఇస్తానని నేను నీతో చెప్పాను. అయితే నీవు నీ ప్రతిఫలం పోగొట్టుకొనేటట్టు చేసాడు యెహోవా.” ");
INSERT INTO tel2010_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","బాలాకుతో బిలాము అన్నాడు: “నీవు నా దగ్గరకు మనుష్యుల్ని పంపించావు. నన్ను రమ్మని వాళ్లు అడిగారు. ");
INSERT INTO tel2010_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","కానీ వారితో నేను, ‘బాలాకు అతి సుందరమైన తన భవనాన్ని వెండి, బంగారాలతో నింపి ఇవ్వవచ్చుగాక. నేను మాత్రం నన్ను చెప్పమని యెహోవా నాకు చెప్పిన మాటలే చెబుతాను మంచిగాని చెడుగాని, నా అంతట నేనే ఏదీ చెయలేను. యెహోవా ఆజ్ఞాపించినట్లు నేను చేసి తీరాల్సిందే’ అన్నాను. ఈ సంగతులు నేను నీ మనుష్యులతో చెప్పటం నీకు జ్ఞాపకంలేదా? ");
INSERT INTO tel2010_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ఇప్పుడు నేను నా స్వంత ప్రజల దగ్గరకు వెళ్తున్నాను. అయితే నేను నీకు ఒక హెచ్చరిక ఇస్తున్నాను. నీకూ, నీ ప్రజలకూ ఇశ్రాయేలు ప్రజలు ఇక ముందు ఏమి చేస్తారో నేను నీకు చెబుతాను.” ");
INSERT INTO tel2010_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","అప్పుడు బిలాము ఈ విషయాలు చెప్పాడు: “బెయెరు కుమారుడైన బిలాము మాటలు ఇవి. విషయాలను తేటగా చూడగలవాని మాటలు ఇవి. ");
INSERT INTO tel2010_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","మాటలను దేవుని దగ్గరనుండి వినగల వాని మాటలు ఇవి. మహోన్నతుడైన దేవుడు నాకు నేర్పినవాటిని నేను నేర్చుకున్నాను. నేను చుడాలని సర్వశక్తుడైన దేవుడు కోరినవాటిని నేను చూసాను. నేను ఆయనకు సాగిల పడుతున్నాను. దేవునికి కావలసినదానిని నేను తేటగా చూడగలను. ");
INSERT INTO tel2010_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“యెహోవా రావటం నేను చూస్తున్నాను, కానీ ఇప్పుడే కాదు. ఆయన రాక నేను చూస్తున్నాను, కానీ అది త్వరలోనే జరగదు. యాకోబు వంశంనుండి ఒక నక్షత్రం వస్తుంది. ఇశ్రాయేలు నుండి ఒక కొత్త పాలకుడు వస్తాడు. ఆ పాలకుడు మోయాబు ప్రజల తలలు చితకగొడ్తాడు. షేతు కుమారులందరి తలలు ఆ పాలకుడు చితకగొడ్తాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ఇశ్రాయేలీయులు బలము గలవారవుతారు. అతనికి ఏదోము దేశము, అతని శత్రువైన శేయీరు దొరుకుతాయి. ");
INSERT INTO tel2010_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","“యాకోబు వంశంనుండి ఒక కొత్త పాలకుడు వస్తాడు. పట్టణంలో ఇంకా బతికి ఉన్న వాళ్లను ఆ పాలకుడు నాశనం చేస్తాడు.” ");
INSERT INTO tel2010_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","తర్వాత బిలాము అమాలేకు ప్రజలను చూచి ఈ మాటలు చెప్పాడు: “దేశాలన్నింటిలో అమాలేకు అతి బలంగలది. కానీ అమాలేకు కూడ నాశనం చేయబడుతుంది”! ");
INSERT INTO tel2010_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","తర్వాత బిలాము కెనాతీ ప్రజలను చూచి ఈ మాటలు చెప్పాడు: “మీ దేశం క్షేమంగా ఉందని మీ నమ్మకం. ఎత్తయిన కొండమీద పక్షి గూడులా అది కాపాడ బడుతోందని మీ నమ్మకం. ");
INSERT INTO tel2010_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","అయితే మీరు కెనాతీ ప్రజలు నాశనం చేయబడతారు. అష్షూరు మిమ్మల్ని బందీలుగా చేస్తుంది.” ");
INSERT INTO tel2010_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","అప్పుడు బిలాము ఈ మాటలు చెప్పాడు: “దేవుడు ఇలా చేసినప్పుడు ఏ వ్యక్తి బతకలేడు. ");
INSERT INTO tel2010_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","కిత్తీము తీరాలకు ఓడలు వస్తాయి. ఆ ఓడలు అష్షూరు, ఎబెరులను ఓడిస్తాయి. అయితే తర్వాత ఆ ఓడలు కూడ నాశనం చేయ బడతాయి” ");
INSERT INTO tel2010_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","అప్పుడు బిలాము లేచి, తన స్వంత ఊరికి తిరిగి వెళ్లి పోయాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","ఇశ్రాయేలు ప్రజలు ఇంకా షిత్తీము దగ్గరే నివాసం చేస్తున్నారు. ఆ సమయంలో పురుషులు మోయాబీ స్త్రీలతో లైంగిక పాపం చేయటం మొదలు పెట్టారు. ");
INSERT INTO tel2010_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","3","మోయాబీ స్త్రీలు వారి నకిలీ దేవుళ్లకు బలులు అర్పించేటప్పుడు వచ్చి సహాయం చేయుమని ఆ పురుషులను అహ్యానించారు. యూదులు కొంతమంది ఆ దేవుళ్లను కొలిచి, అక్కడ భోజనం చేసారు. కనుక ఆ విధంగా ఇశ్రాయేలు ప్రజలు పెయోరులో బయలు దేవతను కొలవటం మొదలు పెట్టారు. యెహోవాకు ఈ ప్రజలమీద చాల కోపం వచ్చింది. ");
INSERT INTO tel2010_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","“ఈ ప్రజల నాయకులందర్నీ పిలువు. ప్రజలంతా చూసేటట్టు వారిని చంపు. వారి శరీరాల్ని యెహోవా ఎదుట పడవేయి. అప్పుడు ఇశ్రాయేలు ప్రజలమీద యెహోవా కోపగించడు” అని మోషేతో యెహోవా చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ఇశ్రాయేలీయుల న్యాయమూర్తులతో “పెయోరులో నకిలీ దేవుడైన బయలును కొలిచేందుకు ప్రజలను నడిపించిన మీ వంశపు నాయకులను ఒక్కొక్కరిని మీరు తెలుసుకోవాలి. తర్వాత మీరు వారిని చంపేయాలి” అని మోషే చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ఆ సమయంలో మోషే, మరియు ఇశ్రాయేలు పెద్దలూ అంత సన్నిధి గుడార ద్వారం దగ్గర చేరారు. ఇశ్రాయేలు మగవాడొకడు ఒక మిద్యానీ స్త్రీని తన ఇంటికి, తన కుటుంబం దగ్గరకు తీసుకొనివచ్చాడు. మోషే, మరియు పెద్దలూ అందరూ చూసేటట్టుగా వాడు ఇలా చేసాడు. మోషే, ఆ పెద్దలూ చాల విచారపడ్డారు. ");
INSERT INTO tel2010_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","అహరోను కుమారుడైన ఎలీయాజరు కుమారుడు ఫీనెహసు యాజకుడు ఇది చూసాడు. కనుక అతడు సమాజంనుండి వెళ్లి తన ఈటె తీసుకున్నాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ఇశ్రాయేలు పురుషునితోబాటు వాని గుడారంలోకి అతడు వెళ్లాడు. ఆ ఇశ్రాయేలు వానిని మిద్యానీ స్త్రీనీ ఈటెతో అతడు చంపేసాడు. ఆ ఈటెతో అతడు వారిద్దరి శరీరాలూ పొడిచినాడు. ఆ సందర్భంలో ఇశ్రాయేలు ప్రజల్లో గొప్ప రోగం పుట్టింది. అయితే వీళ్లద్దర్నీ ఫీనెహసు చంపగానే ఆ రోగం ఆగిపోయింది. ");
INSERT INTO tel2010_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ఈ రోగం మూలంగా 24,000 మంది చనిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“యాజకుడు అహరోను కుమారుడైన ఎలీయాజరు కుమారుడు ఫీనెహసు ఇశ్రాయేలు ప్రజలను నా కోపం నుండి రక్షించాడు. నన్ను సంతోష పెట్టేందుకు అతడు ఎంతో కష్టపడి ప్రయత్నించాడు. అతడు నాలాగే ఉన్నాడు. ప్రజల మద్య నా మర్యాద కాపాడటానికి అతడు ప్రయత్నం చేసాడు. అందుచేత నేను అనుకొన్న ప్రకారం ప్రజలను చంపను. ");
INSERT INTO tel2010_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","కనుక నేను ఫీనెహసుతో ఒక శాంతి ఒడంబడిక చేస్తున్నానని అతనితో చెప్పండి. ");
INSERT INTO tel2010_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","అతడు, అతని తర్వాత జీవించే అతని కుటుంబీకులు అందరికీ ఒక ఒడంబడిక ఉంటుంది. వారు ఎప్పటికీ యాజకులే. ఎందుచేతనంటే అతడు తన దేవుడి మర్యాద కాపాడటానికి ఎంతో కష్టపడి ప్రయత్నించాడు. అతడు చేసినది ఇశ్రాయేలు ప్రజల తప్పులకు ప్రాయశ్చిత్తం చేసింది.” ");
INSERT INTO tel2010_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","మిద్యానీ స్త్రీతో బాటు చంపబడ్డ ఇశ్రాయేలు మగవాడు, సాలు కుమారుడైన జిమ్రీ. షిమ్యోను వంశంలో ఒక కుటుంబానికి అతడు నాయకుడు. ");
INSERT INTO tel2010_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","చంపబడిన మిద్యానీ స్త్రీ పేరు కొజ్బీ. ఆమె షూరు కూమారై. షూరు మిద్యానీ ప్రజల్లో నాయకుడు. అతడు తన వంశానికి పెద్ద. ");
INSERT INTO tel2010_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","మోషేతో యెహోవా ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“మిద్యానీ ప్రజలు మీకు శత్రువులు. మీరు వాళ్లను చంపేయాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ఇప్పటికే వాళ్లు మిమ్మల్ని శత్రువులుగా చేసుకున్నారు. మీరు పెయోరు నకిలీ దేవుడిని కొలిచేటట్టుగా వాళ్లు మిమ్మల్ని మోసం చేసారు. మిద్యానీ నాయకుని కుమారై కొజ్బీని మీ వాడొకడు దాదాపు వివాహం చేసుకున్నంత పని చేసారు వారు. అదే ఇశ్రాయేలు ప్రజలకు రోగం వచ్చినప్పుడు చంపబడ్డ స్త్రీకి పెయోరులో ప్రజలు బయలు నకిలీ దేవణ్ణి కొలిచిన కారణంగానే ఆ రోగం వచ్చినది.” ");
INSERT INTO tel2010_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ఆ మహా రోగం తర్వాత మోషేతో, అహరోను కుమారుడు యాజకుడైన ఎలీయాజరుతో యెహోవా మాట్లాడాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ఇశ్రాయేలు ప్రజలందరినీ లెక్కించండి. ప్రతి కుటుంబాన్నీ చూచి, 20 సంవత్సరాలు, అంతకంటె ఎక్కువ వయస్సు ఉన్న పురుషులందరిని లెక్కించండి. వీరు ఇశ్రాయేలు సైన్యంలో పని చేయటానికి సమర్థులు” అని ఆయన చెప్పాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ఇప్పటికి మోయాబు మైదానంలోనే ప్రజలు నివాసం చేస్తున్నారు. ఇది యెరికోకు ఎదురుగా యోర్దాను నది దగ్గర ఉంది. కనుక మోషే, యాజకుడైన ఎలీయాజరు ప్రజలతో మాట్లాడారు. వారు ");
INSERT INTO tel2010_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“20 గాని, అంతకంటె ఎక్కువ వయసు గాని ఉన్న మగవాళ్ల సంఖ్య లెక్కించాలి. ఇది మోషేకు యెహోవా ఇచ్చిన ఆజ్ఞ అన్నారు.” ఈజిప్టు నుండి బయటకు వచ్చిన ఇశ్రాయేలు ప్రజల జాబితా ఇది: ");
INSERT INTO tel2010_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","రూబేను సంతతి వాళ్లు వీరే. (యాకోబుకు) ఇశ్రాయేలు పెద్ద కుమారుడు రూబేను. వంశాలు: హనోకు—హనోకీల వంశం పల్లు పల్లువారి వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","హెస్రోను హెస్రోనీల వంశం కర్మి కర్మీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","రూబేను సంతతిలోని వంశాలు అవి. మొత్తం 43, 730 మంది పురుషులు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","పల్లు కుమారుడు ఏలీయాబు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","నెమూయేలు, దాతాను, అబీరాము ముగ్గురూ ఏలీయాబు కుమారులు. మోషే, అహరోనులకు ఎదురు తిరిగిన నాయకులు దాతాను, అబీరాము అని జ్ఞాపకం ఉంచుకోండి. యెహోవాకు కోరహు ఎదురు తిరిగినప్పుడు వారు కోరహును వెంబడించారు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","అప్పుడే భూమి తెరచుకొని, కోరహును, అతని అనుచరులు అందరినీ మింగివేసింది. చనిపోయిన వారి సంఖ్య మొత్తం 250 మంది పురుషులు. ఇశ్రాయేలు ప్రజలందరికీ ఇది ఒక హెచ్చరిక, గుర్తు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","అయితే కోరహు కుటుంబంలోని ఇతరులు మరణించలేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","షిమ్యోను సంతతిలోని వంశాలు ఇవి: నెమూయేలు—నెమూయేలీ వంశం యామీను—యామీనీల వంశం యాకీను—యాకీనీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","జెరహు—జెరహీల వంశం షావూలు—వూలీ వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","షిమ్యోను సంతతిలోని వంశాలు అవి. వారు మొత్తం 22,200 మంది. ");
INSERT INTO tel2010_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","గాదు సంతతిలోని వంశాలు ఇవి: సెపోను—సెపోనీల వంశం హగ్గి—హగ్గీల వంశం షూనీ—షూనీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ఓజని—ఓజనీల వంశం ఏరీ—ఏరీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","అరోది—అరోదీల వంశం అరేలి—అరేలీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","అవి గాదు సంతతిలోని వంశాలు. వారు మొత్తం 40,500 మంది పురుషులు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","20","యూదా సంతతిలోని వంశాలు ఇవి: షేలా—షేలావారి వంశం పెరెసు—పెరెసీల వంశం జెరహు—జెరహీల వంశం (యూదా కుమారులు ఏరు, ఓనాను అనే ఇద్దరు కనానులో చనిపోయారు.) ");
INSERT INTO tel2010_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","పెరెసు వంశాలు ఇవి: హెస్రోను—హెస్రోనీల వంశం హములు—హములీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","యూదా సంతతిలోని వంశాలు ఇవి. పురుషుల సంఖ్య మొత్తం 76,500. ");
INSERT INTO tel2010_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","ఇశ్శాఖారు సంతతిలోని వంశాలు ఇవి: తోల — తోలాలీ వారి వంశం పువ్వా — పువ్వీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","యాషుబు — యాషుబీల వంశం షిమ్రోను — షిమ్రోనీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ఇశ్శాఖారు సంతతిలోని వంశాలు అవి. పురుషుల సంఖ్య మొత్తం 64,300. ");
INSERT INTO tel2010_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","జెబూలూను సంతతిలోని వంశాలు: సెరెదు — సెరెదీల వంశం ఏలోను — ఏలోనీల వంశం యహలేలు — యహలేల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","జెబూలూను సంతతిలోని వంశాలు అవి. పురుషులు సంఖ్య మొత్తం 60,500. ");
INSERT INTO tel2010_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","యోసేపు ఇద్దరు కుమారులు మనష్షే, ఎఫ్రాయిము. ఒక్కో కుమారుడు కొన్ని స్వంత వంశాలతో కూడిన ఒక్కో సంతతి అయ్యారు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","మనష్షే సంతతి ఏవనగా: మాకీరు — మాకీరువారి వంశం (మాకీరు గిలాదుకు తండ్రి,) గిలాదు — గిలాదీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","గిలాదు వంశాలు: ఈజురు — ఈజరీల వంశం హెలెకు — హెలెకీవారి వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","అశ్రీయేలు — అశ్రీయేలీల వంశం షెకెము — షెకెమీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","షెమిద — షెమిదీల వంశం హెపెరు — హెపెరీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","హెపెరు కుమారుడు సెలోపెహదు. కానీ అతనికి కుమార్తెలు తప్ప కుమారులు లేరు. అతని కుమార్తెల పేర్లు మహల, నోయా, హోగ్ల, మిల్కా తిర్సా. ");
INSERT INTO tel2010_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","అవన్నీ మనష్షే సంతతిలోని వంశాలు. పురుషుల సంఖ్య మొత్తం 52,700. ");
INSERT INTO tel2010_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","ఎఫ్రాయిము సంతతిలోని వంశాలు ఏవనగా: షుతల — షుతలీల వంశం బేకరు — బేకరీల వంశం తహను — తహనీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","షుతలహు వంశం వాడు ఏరాను. అతని వంశ ఏరానీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ఎఫ్రాయిము సంతతిలోని వంశాలు అవి. పురుషుల సంఖ్య మొత్తం 32,500. యోసేపు సంతతికి చెందిన మొత్తం మనుష్యులు వారే. ");
INSERT INTO tel2010_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","బెన్యామీను సంతతిలోని వంశాలు: బెలా — బెలాలీ వంశం అష్బెలు — అష్బెలీ వంశం అహీరం — అహీరమీయీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","షుపం — షుపామీల వంశం హుపం — హుపామీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","బెలా వంశాలు ఏవనగా: ఆర్దు — ఆర్దీల వంశం నయమాను — నయమానీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","బెన్యామీను సంతతిలోని వంశాలన్నీ అవి. పురుషుల సంఖ్య మొత్తం 45,600. ");
INSERT INTO tel2010_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","దాను సంతతిలోని వంశాలు: షూషాము- షూషామల వంశం. అది దాను సంతతిలోని కుటుంబం. ");
INSERT INTO tel2010_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","షూషామీల వంశంలో ఎన్నో కుటుంబాలు ఉన్నాయి. పురుషుల సంఖ్య మొత్తం 64,400. ");
INSERT INTO tel2010_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","ఆషేరు సంతతిలోని వంశాలు: ఇమ్నా — ఇమ్నా వారి వంశం ఇష్వి — ఇష్వీల వంశం బెరీయ — బెరీయాల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","బెరీయా వంశాలు: హెబెరు — హెబెరీల వంశం మల్కీయేలు — మల్కీయేలీల వంశం. ");
INSERT INTO tel2010_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","(ఆషేరుకు శెరహు అనే కూతురు కూడ ఉంది.) ");
INSERT INTO tel2010_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ఆషేరు సంతతిలోని వంశాలు అవి. పురుషుల సంఖ్య మొత్తం 53,400. ");
INSERT INTO tel2010_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","నఫ్తాలీ సంతతిలోని వంశాలు: యహసియేలు — యహసియేలీల వంశం గూని — గూనీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","యెసెరు — యెసెరీల వంశం షిల్లేము — షిల్లేమీల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","నఫ్తాలీ సంతతిలోని వంశాలు అవి. పురుషుల సంఖ్య మొత్తం 45,400. ");
INSERT INTO tel2010_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","కనుక ఇశ్రాయేలు పురుషుల సంఖ్య మొత్తం 6,01,730. ");
INSERT INTO tel2010_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","యెహోవా మోషేతో ఇలా చెప్పాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ప్రతి వంశానికి దేశం లభిస్తుంది. ఇది నేను వారికి వాగ్దానం చేసిన దేశం. లెక్కించబడిన ప్రజలందరికీ సరిపడినంత భూమి ప్రతి వంశానికి లభిస్తుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","పెద్ద వంశానికి ఎక్కువ భూమి లభిస్తుంది. చిన్న వంశానికి తక్కువ భూమి లభిస్తుంది. అయితే నేను వాగ్దానం చేసిన దేశం ప్రతి వంశానికీ లభిస్తుంది. మరియు వారికి లభించే భూమి, లెక్కించబడిన వారందరికీ సరిపోయేటంత ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ప్రతి వంశానికీ ఆ భూమి ఇవ్వబడుతుంది. ఏ వంశం వారి భూమికి ఆ పేరే పెట్టబడుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ప్రజలకు ఇస్తానని నేనే వాగ్దానం చేసినంతగా ఉంటుంది ఆ భూమి. పెద్ద వంశాలకీ, చిన్నవాటికీ అందివ్వబడుతుంది.” ");
INSERT INTO tel2010_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","లేవీ సంతతి కూడ లెక్కించబడింది. లేవీ సంతతిలోని వంశాలు ఇవి: గెర్షోను — గెర్షోనీల వంశం కహాతు — కహాతీల వంశం మెరారి — మెరారిల వంశం ");
INSERT INTO tel2010_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ఇవి కూడ లేవీ సంతతిలోని వంశాలే: లిబ్నీల వంశం హెబ్రోనీల వంశం మహ్లీ వంశం మూషీల వంశం కోరహీల వంశం అమ్రాము కహాతు వంశం వాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","అమ్రాము భార్య పేరు యొకెబెదు. ఆమె కూడ లేవీ సంతతిలోనిదే. ఆమె ఈజిప్టులో పుట్టింది. అమ్రాము, యొకెబెదులకు అహరోను, మోషే ఇద్దరు కుమారులు. వారికి మిర్యాము అని ఒక కుమార్తె కూడ ఉంది. ");
INSERT INTO tel2010_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","నాదాబు, అబీహు, ఎలీయాజరు, ఈతామారులకు తండ్రి అహరోను. ");
INSERT INTO tel2010_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","కానీ నాదాబు, అబీహు చనిపోయారు. అంగీకారం కాని అగ్నితో దేవునికి అర్పణచేసినందువల్ల వారు చనిపోయారు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","లేవీ సంతతిలో పురుషుల సంఖ్య మొత్తం 23,000, అయితే ఇతర ఇశ్రాయేలు మనుష్యులతో వీరు లెక్కించబడలేదు. మిగిలినవారికి యెహూవా వాగ్దానం చేసిన భూమి మాత్రం లేదు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","మోషే, యాజకుడైన ఎలీయాజరు ఈ ప్రజలందరినీ లెక్క చేసారు. మోయాబు మైదానాల్లో వారు ఇశ్రాయేలు ప్రజలను లెక్క తీసారు. ఇది యెరికో ఎదుట యోర్దాను నది అవతల జరిగింది. ");
INSERT INTO tel2010_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","చాలకాలం క్రిందట సీనాయి అరణ్యంలో ఇశ్రాయేలు ప్రజలందరినీ మోషే, యాజకుడైన అహరోనూ లెక్కపెట్టారు. అయితే వాళ్లంతా చనిపోయారు. మోషే మోయాబు మైదానాల్లో లెక్కపెట్టిన వారు వేరు, అంతకుముందు లెక్కపెట్టిన వారు వేరు. ");
INSERT INTO tel2010_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","వారు అందరూ ఎడారిలోనే చస్తారు అని ఇశ్రాయేలు ప్రజలతో యెహోవా చెప్పినందువల్ల ఇలా జరిగింది. సజీవంగా ఉన్నవాళ్లు యెఫున్నె కుమారుడైన కాలేబు, నూను కుమారుడైన యెహోషువ మాత్రమే. ");
INSERT INTO tel2010_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","హెసెరు కుమారుడు సెలోపెహాదు. హెసెరుగిలాదు కుమారుడు. గిలాదు మాకీరు కుమారుడు. మాకీరు మనష్షే కుమారుడు. మనష్షే యోసేపు కుమారుడు. సెలోపెహాదుకు ఐదుగురు కుమార్తెలు ఉన్నారు. వారి పేర్లు మహలా, నోయా, హోగ్లా, మిల్కా, తిర్సా. ");
INSERT INTO tel2010_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","సన్నిధి గుడారం దగ్గర సమావేశం అవుతోన్న మోషే, యాజకుడైన ఎలీయాజరు, పెద్దలు, ప్రజలు అందరి ముందరకు ఈ అయిదుగురు స్త్రీలూ వెళ్లి సన్నిధి గుడారం ఎదుట నిలబడ్డారు. ఈ ఐదుగురు కూతుళ్లు ఈ విధంగా చెప్పారు: ");
INSERT INTO tel2010_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“మనం అరణ్య ప్రయాణంలో ఉన్నప్పుడే మా తండ్రి చనిపోయాడు. అతడు కోరహు గుంపులో చేరినవాడు కాడు. (కోరహు యెహోవానుంచి తొలగి ఎదురు తిరిగినవాడు.) మా తండ్రిది సహజ మరణం. కానీ మా తండ్రికి కుమారులు లేరు. ");
INSERT INTO tel2010_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","అంటే మా తండ్రి పేరు కొనసాగదు. మా తండ్రి పేరు కొనసాగక పోవటం సక్రమం కాదు. ఆయనకు కుమారులు లేరు గనుక ఆయన పేరు అంతం అవుతుంది. అందుచేత మా తండ్రి సోదరులకు వచ్చే భూమిలో మాకు కొంత ఇవ్వవలసినదిగా మేము మీకు మనవి చేస్తున్నాము.” ");
INSERT INTO tel2010_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","కనుక ఏమి చేయాలని యెహోవాను మోషే అడిగాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","అతనిలో యెహోవా ఇలా అన్నాడు, ");
INSERT INTO tel2010_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“సెలోపెహాదు కుమార్తెలు చెప్పినది సరియైనదే. వాళ్లు వారి తండ్రి సోదరులతో పాటు భూమిని పంచుకోవలసినదే. కనుక నీవు వారి తండ్రికిచ్చిన భూమిని వారికి ఉవ్వవలెను. ");
INSERT INTO tel2010_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“కనుక ఇశ్రాయేలు ప్రజలకు, ఇలా చట్టం తయారు చేయి. ‘ఒకనికి కుమారులు లేకుండానే అతడు చనిపోతే, అతని ఆస్తి అంతా అతని కుమార్తెకు ఇవ్వవలెను. ");
INSERT INTO tel2010_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","అతనికి కుమార్తె లేకపోతే, అతని ఆస్తి అంతా అతని సోదరులకు ఇవ్వవలెను. ");
INSERT INTO tel2010_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","అతనికి సోదరులు లేకపోతే అతని ఆస్తి అంతా అతని తండ్రి సోదరులకు ఇవ్వవలెను. ");
INSERT INTO tel2010_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","అతని తండ్రికి సోదరులు లేకపోతే, అతని ఆస్తి అంతా, అతని కుటుంబంలో దగ్గర బంధువులకు ఇవ్వాలి. ఇశ్రాయేలు ప్రజల్లో ఇది ఒక చట్టంగా ఉండాలి. యెహోవాయే ఈ ఆజ్ఞను మోషేకు ఇస్తున్నాడు.’” ");
INSERT INTO tel2010_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","అప్పుడు మోషేతో యెహోవా ఇలా చెప్పాడు: “ఆ కొండమీదికి ఎక్కుము. యొర్దాను నదికి తూర్పున ఉన్న కొండల్లో అది ఒకటి. ఇశ్రాయేలు ప్రజలకు నేను ఇస్తున్న దేశాన్ని నీవు అక్కడ నుండి చూస్తావు. ");
INSERT INTO tel2010_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","నీవు ఈ దేశాన్ని చూశాక, నీ సోదరుడు అహరోను మరణించినట్టే నీవు మరణిస్తావు. ");
INSERT INTO tel2010_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","సీను అరణ్యంలో నీళ్లకోసం ప్రజలు కోపగించుకోవటం జ్ఞాపకం చేసుకొనుము. నీవూ, అహరోనూ కూడ నా ఆజ్ఞకు విధేయులయ్యేందుకు నిరాకరించారు. ప్రజల ముందు నీవు నన్ను ఘనపర్చలేదు, పవిత్రంగా చూడలేదు.” (ఇది సీను అరణ్యంలో కాదేషు దగ్గర మెరీబా నీళ్ల సంగతి.) ");
INSERT INTO tel2010_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","యెహోవాతో మోషే ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ప్రజల ఆలోచనలు తెలిసిన దేవుడు యెహోవా ప్రభువు, నీవే ఈ ప్రజలకోసం మరో నాయకుడిని ఎంచుకోమని మనవి చేస్తున్నాను. ");
INSERT INTO tel2010_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ఈ దేశంలోనుండి వీరిని బయటకు నడిపించి, కొత్త దేశంలో చేర్చగల నాయకుడిని ఎంచవలసినదిగా నేను యెహోవాకు మనవి చేస్తున్నాను. అప్పుడు యెహోవా ప్రజలు కాపరి లేని గొర్రెల్లా ఉండరు.” ");
INSERT INTO tel2010_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","కనుక మోషేతో యెహోవా ఇలా అన్నాడు: “నూను కుమారుడైన యెహోషువ నాయకుడుగా ఉంటాడు. యోహోషువ ఆత్మను పొందినవాడు. అతడిని కొత్త నాయకునిగా చేయి. ");
INSERT INTO tel2010_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","యాజకుడైన ఎలీయాజరు ఎదుటా, ప్రజలందరి ఎదుటా నిలబడమని అతనితో చెప్పు. అప్పుడు అతడికి కొత్త నాయకునిగా నీవు చేయి. ");
INSERT INTO tel2010_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","“అతడిని నీవు నాయకునిగా చేస్తున్నావని ప్రజలకు చూపెట్టు, అప్పుడు ప్రజలంతా అతనికి లోబడతారు. ");
INSERT INTO tel2010_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","ఒకవేళ యెహోషువ ఒక కొత్త నిర్ణయం ఏదైనా చేయాలంటే అతడు యాజకుడైన ఎలీయాజరు దగ్గరకు వెళతాడు. యెహోవా జవాబు తెలుసుకొనేందుకు ఎలీయాజరు ఊరీమును ప్రయోగిస్తాడు. అప్పుడు యెహోషువ, ప్రజలందరూ దేవుడు చెప్పిన వాటిని చేస్తారు. ‘యుద్ధానికి వెళ్లండి’ అని అతడు చెబితే వారు యుద్ధానికి వెళ్తారు. ఒకవేళ ‘ఇంటికి వెళ్లండి’ అని అతడు చెబితే వారు ఇంటికి వెళతారు.” ");
INSERT INTO tel2010_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","మోషే యెహోవాకు విధేయుడయ్యాడు. యాజకుడైన ఎలీయాజరు ముందు, ప్రజలందరి ఎదుట నిలబడమని యెహోషువాతో చెప్పాడు. మోషే, ");
INSERT INTO tel2010_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","అప్పుడు అతడే కొత్త నాయకుడు అని చూపెట్టేందుకు అతనిమీద మోషే చేతులు పెట్టాడు. అతనితో యెహోవా చెప్పినట్టే అతడు చేసాడు. ");
INSERT INTO tel2010_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","అప్పుడు యెహోవా మోషేతో మాట్లాడాడు. ఆయన ఇలా అన్నాడు: ");
INSERT INTO tel2010_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“ఇశ్రాయేలు ప్రజలకు ఈ ఆజ్ఞ ఇవ్వవలెను. ప్రత్యేక కానుకలను సరైన సమయంలోనే నాకు ఇవ్వవలెనని వారితో చెప్పుము. ధాన్యార్పణలు, దహనబలులు నాకు ఇవ్వాలని వారితో చెప్పుము. ఆ దహనబలుల వాసన యెహోవాకు ఇష్టం. ");
INSERT INTO tel2010_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","వారు యెహోవాకు ఇవ్వవలసిన దహనబలులు ఇవే. ప్రతిరోజూ పుష్టిగల, ఒక సంవత్సరం వయసున్న రెండు మగ గొర్రె పిల్లలు. ");
INSERT INTO tel2010_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ఒక గొర్రెపిల్ల ఉదయం, మరో గొర్రెపిల్లను సాయం కాలమందు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","మరియు ఒక పావు ఒలీవనూనెతో కలుపబడ్డ రెండుపావుల మంచి పిండి ధాన్యార్పణగా పెట్టాలి.” ");
INSERT INTO tel2010_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","సీనాయి కొండ దగ్గర వారు ప్రతి దినం అర్పణలు అర్పించటం మొదలుపెట్టారు. ఆ దహనబలి అర్ఫణల వాసన యెహోవాకు ఇష్టమయినది. ");
INSERT INTO tel2010_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","దహనబలి అర్పణతో బాటు ప్రజలు పానార్పణ కూడ అర్పించాలి. ప్రతి గొర్రె పిల్లతోబాటు వారు ముప్పావు ద్రాక్షారసం అర్పించాలి. పవిత్ర స్థలంలో బలిపీఠం మీద పానార్పణం పోయాలి. ఇది యోహోవాకు కానుక. ");
INSERT INTO tel2010_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","రెండో గొర్రెపిల్లను సాయంకాలమందు అర్పించాలి. సరిగ్గా ఉదయార్పణలాగే దీనిని అర్పించాలి. అలాగే అదే రకం పానార్పణం ఇవ్వాలి. ఈ దహనబలి యెహోవాకు సువాసనగా ఉంటుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“విశ్రాంతి దినం శనివారం నాడు, ఒక సంవత్సరం వయసుగల లోపంలేని రెండు గొర్రె పిల్లల్ని, తూమెడు పిండిలో రెండు పదోవంతుల మంచి పిండి ఒలీవ నూనెలో కలిపిన పానార్పణం మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","విశ్రాంతి దినం కోసం ఇది ప్రత్యేక అర్పణ. ప్రతి రోజూ ఇచ్చే అర్పణ పానార్పణం గాక ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ప్రతి నెలా మొదటి రోజున ప్రత్యేకమైన దహనబలి మీరు యెహోవాకు అర్పించాలి. ఈ అర్పణలోపంలేని రెండు కోడె దూడలు, ఒక పొట్టేలు, ఒక సంవత్సరపు గొర్రెపిల్లలు ఏడు. ");
INSERT INTO tel2010_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","మరియు ఒలీవ నూనెతో కలుపబడిన తూమెడు మంచి పిండితో మూడు పదోవంతులను ధాన్యార్పణగా ప్రతి కోడె దూడతోబాటు అర్పించాలి. అలాగే, ఒలీవ నూనెతో కలుపబడిన మంచి పిండిలో ఒక పదోవంతును పొట్టేలుతో బాటు ధాన్యార్పణగా అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ఒలీవ నూనెతో కలుపబడిన మంచి పిండిలో ఒక పదోవంతును ఒక్కో గొర్రెపిల్లతోబాటు ధాన్యార్పణగా అర్పించాలి. ఇది యెహోవాకు సువాసన ఇచ్చే దహనబలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ప్రతి కోడె దూడతోబాటు పడిన్నర ద్రాక్షారసం, పొట్టేలుతోబాటు ఒక్క పడి ద్రాక్షారసం, ప్రతి గొర్రెపిల్లతోబాటు ముప్పావు ద్రాక్షారసం పానార్పణం. ఇది సంవత్సరంలో నెలనెలా అర్పించాల్సిన దహనబలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","ప్రతి రోజూ అర్పించే దహనబలి, పానార్పణంగాక ఒక మగ మేకను యెహోవాకు మీరు అర్పించాలి. ఆ మేక పాప పరిహారార్థ బలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“మొదటి నెల (నిసాను) పదునాలుగవ రోజున పస్కా. ");
INSERT INTO tel2010_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","పులియని రొట్టెల పండుగ అదే నెల పది హేనో రోజున ప్రారంభం అవుతుంది. ఆ పండుగ ఏడు రోజులపాటు ఉంటుంది. పొంగని రొట్టెలు మాత్రమే మీరు తినవచ్చును. ");
INSERT INTO tel2010_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ఈ పండుగ మొదటి రోజున మీరు ఒక ప్రత్యేక సభజరపాలి. ఆ రోజు మీరు ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","మీరు యెహోవాకు దహనబలులు అర్పించాలి. దహనబలులు రెండు కోడె దూడలు, ఒక పొట్టేలు, అంగవిహీనం లేని సంవత్సరపు మగ గొర్రె పిల్లలు ఏడు. ");
INSERT INTO tel2010_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","21","ఒక్కొక్క కోడె దూడతో తూములో మూడు పదివంతులును, పొట్టేలుతో రెండు పది వంతులును, ఒక్కో గొర్రెపిల్లతో, ఒక్కో పదోవంతు మంచి పిండి ఒలీవ నూనెతో కలిపి ధాన్యార్పణంగా పెట్టాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","ఒక మగ మేకను కూడ మీరు ఇవ్వాలి. ఆ మేక మీ కోసం పాప పరిహారార్థబలి అవుతుంది. అది మీ పాపాలను కప్పి పుచ్చుతుంది. ");
INSERT INTO tel2010_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ప్రతి ఉదయం మీరు అర్పించే దహన బలి అర్పణ కాక ఈ అర్పణలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","“అదే విధంగా ఏడు రోజులపాటు మీరు ఆహార అర్పణలు అర్పించాలి. ప్రతి రోజూ దానిని హోమాంగా మీరు అర్పించాలి. ఈ అర్పణ యెహోవాకు ఇష్టమైన సునాసన. మీరు దహనబలిని, దాని పానార్పణను క్రమంగా అర్పించాలి. ఇవిగాక ఆహారం (ప్రజలకు) మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","“అప్పుడు పస్కా పండుగ ఏడవ రోజున మీకు ఒక ప్రత్యేక సభ జరుగుతుంది. ఆ రోజున మీరు ఏ పనీ చేయరు. ");
INSERT INTO tel2010_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ప్రథమ ఫలాల పండుగలో (వారాల పండుగ) కొత్త ధాన్యంలోనుంచి మీరు ధాన్యార్పణ యెహోవాకు ఇవ్వవలెను. ఆ సమయంలో కూడ మీరు ఒక ప్రత్యేక సభ ఏర్పాటు చేయాలి. ఆ రోజున మీరు ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","మీరు దహనబలులు అర్పించాలి. ఆ బలి అర్పణలు యెహోవాకు ఇష్టమైన సువాసన. రెండు కోడెదూడలు, ఒక పొట్టేలు, ఒక సంవత్సరపు మగ గొర్రె పిల్లలు ఏడు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ప్రతి కోడెదూడతోను, నూనెతో కలుపబడిన తూమెడు పిండిలో మూడు పదోవంతులు, ప్రతి పొట్టేలుతో రెండు పదోవంతులు ");
INSERT INTO tel2010_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ఒక్కో గొర్రె పిల్లతో ఒక్కో పదోవంతును మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","మీ పాపాలకు ప్రాయశ్చిత్తంగా ఒక మగ మేకనుకూడ మీరు బలి ఇవ్వవలెను. ");
INSERT INTO tel2010_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","రోజువారీ దహనబలులు, ధాన్యార్పణాలు గాక వీటిని మీరు అర్పించాలి. జంతువులు అంగహీనము కానివిగా ఉండేటట్టు తప్పక చూడాలి. పానార్పణం పరిశుభ్రమయినదిగా ఉండాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ఏడో నెల మొదటి రోజున ఒక ప్రత్యేక సభ జరుగుతుంది. ఆ రోజు మీరు ఏ పనీ చేయకూడదు. అది బూర ఊదే రోజు. ");
INSERT INTO tel2010_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","దహనబలులను మీరు అర్పించాలి. ఆ బలి అర్పణలు యెహోవాకు ఇష్టమైన సువాసనగా ఉంటాయి. ఒక కోడెదూడను, ఒక పొట్టేలును, పుష్టిగల ఒక సంవత్సరపు ఏడు మగ గొర్రెపిల్లలను మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","కోడె దూడతో బాటు తూములో మూడు పదోవంతుల మంచి పిండి నూనెతో కలిపినది, పొట్టేలుకు రెండు పదోవంతులును, ");
INSERT INTO tel2010_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ఏడు గర్రెపిల్లల్లో ఒక్కోదానికి ఒక్కో పదోవంతును మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","మరియు పాపపరిహారార్థ బలిగా ఒక మగ మేకను అర్పించండి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","నెలపొడుపు బలులు, దాని ధాన్యార్పణం గాక బలులు అర్పించాలి. ప్రతిదిన బలులు, దాని ధాన్యార్పణం, పానార్పణలకి అదనం. అవి వాటి నియమాల ప్రకారం జరగాలి. అని అగ్నిలో దహించబడాలి. అది యెహోవాకు ఇష్టమైన సువాసన. ");
INSERT INTO tel2010_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ఏడో నెల పదో రోజున ఒక ప్రత్యేక సభ జరుగుతుంది. ఆ రోజు మీరు ఏమీ భోజనం చేయకూడదు. ఏ పనీ మీరు చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","దహనబలులు మీరు అర్పించాలి. అది యెహోవాకు ఇష్టమైన సువాసనగా ఉంటుంది. ఒక కోడె దూడ, ఒక పొట్టేలు, అంగహీనము కాని ఒక సంవత్సరపు ఏడు మగ గొర్రె పిల్లలను మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ఒలీవ నూనెతో కలుపబడిన మంచి పిండితూములో మూడు పదోవంతులు ఒక కోడె దూడతోను, రెండు పదోవంతులు పొట్టేలుతోను, ");
INSERT INTO tel2010_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ఏడు గొర్రె పిల్లల్లో ఒక్కోదానిలో పదోవంతును మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","ఒక పోతు మేకను కూడ పాపపరిహారార్థ బలిగా మీరు అర్పించాలి. ప్రాయశ్చిత్త దినపు పాపపరిహారార్థ బలి అర్పణకు ఇది అదనం. ప్రతిదినం బలి, దాని ధాన్యార్పణం, పానార్పణలకు ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ఏడోనెల పదిహేనవ రోజున ఒక ప్రత్యేక సభ జరుగుతుంది. ఆ రోజు మీరు ఏ పనీ చేయకూడదు. ఏడు రోజులు యెహోవాకు ప్రత్యేక పండుగ రోజులుగా మీరు జరుపుకోవాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","దహన బలులు మీరు అర్పించాలి. అది యెహోవాకు ఇష్టమైన సువాసన. కోడెదూడలు 13, పొట్టేళ్లు 2, పుష్టిగల ఒక సంవత్సరపు గొర్రెపిల్లలు 14 మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","పధ్నాలుగు కోడె దూడల్లో ఒక్కోదానితో నూనెతో కలుపబడిన మంచి పిండి తూములో మూడు పదోవంతులు, రెండు పొట్టేళ్లలో ఒక్కోదానితో రెండు పదోవంతులు, ");
INSERT INTO tel2010_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","పదునాలుగు గొర్రెపిల్లల్లో ఒక్కోదానితో ఒక్కో పదోవంతు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","ఒక మగమేకను కూడ మీరు అర్పించాలి. రోజువారీ బలి అర్పణ, దాని ధాన్యార్పణ, పానార్పణలకు ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ఈ పండుగ రెండోనాడు 12 కోడెదూడలు, 2 పొట్టేళ్లు, 14 పుష్టిగల యేడాది గొర్రెపిల్లలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","కోడెదూడలకు, పొట్టేళ్లకు, గొర్రెపిల్లలకు సరైన లెక్క ప్రకారం ధాన్యార్పణ, పానార్పణ కూడ మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","పాపపరిహారార్థ బలిగా ఒక మగ మేకను కూడా మీరు అర్పించాలి. రోజువారీ బలి అర్పణ, దాని ధాన్యార్పణ, పానార్పణలకు ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ఈ పండుగ మూడోనాడు 11 కోడెదూడలు, 2 పొట్టేళ్లు, 14 అంగహీనముకాని యేడాది గొర్రెపిల్లలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","కోడెదూడలకు, పొట్టేళ్లకు, గొర్రె పిల్లలకు సరైన లెక్క ప్రకారం ధాన్యార్పణ, పానార్పణలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","పాపపరిహారార్థ బలిగా ఒక మగమేకను మీరు అర్పించాలి. రోజువారి బలి అర్పణ, దాని ధాన్యార్పణ, పానార్పణకు ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ఈ పండుగ నాలుగో రోజున 10 కోడెదూడలు, 2 పొట్టేళ్లు, 14 అంగహీనముకాని యేడాది గొర్రెపిల్లలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","కోడెదూడలు, పొట్టేళ్లు, గొర్రెపిల్లలకు సరైన లెక్క ప్రకారం ధాన్యార్పణ, పానార్పణలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","పాపపరిహారార్థ బలిగా ఒక మేకను మీరు అర్పించాలి. ప్రతిదినము బలి అర్పణ, దాని ధాన్యార్పణ, పానార్పణకు ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ఈ పండుగ ఐదో రోజున 9 కోడెదూడలు, 2 పొట్టేళ్లు, 14 అంగహీనముకాని యేడాది గొర్రెపిల్లలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","కోడెదూడలు, పొట్టేళ్లు, గొర్రెపిల్లలకు సరైన లెక్క ప్రకారం ధాన్యార్పణ, పానార్పణ మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","పాపపరిహారార్థ బలిగా ఒక మేకను మీరు అర్పించాలి. ప్రతిదినము బలి అర్పణ, దాని ధాన్యార్పణ సానార్పణకు ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ఈ పండుగ ఆరోనాడు 8 కోడె దూడలు, 2 పొట్టేళ్లు, 14 పుష్టిగల యేడాది గొర్రెపిల్లలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","కోడెదూడలు, పొట్టేళ్లు, గొర్రెపిల్లలకు సరైన లెక్క ప్రకారం ధాన్యార్పణ, పానార్పణం మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","పాపపరిహారార్థ బలిగా ఒక మేకను మీరు అర్పించాలి. ప్రతిదినము బలి దాని ధాన్యార్పణ, పానార్పణకు ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ఈ పండుగ ఏడోనాడు 7 కోడెదూడలు, 2 పొట్టేళ్లు, 14 పుష్టిగల గొర్రెపిల్లలు మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","కోడె దూడలు, పొట్టేళ్లు, గొర్రెపిల్లలకు సరైన లెక్క ప్రకారం ధాన్యార్పణ, పానార్పణం మీరు అర్పించాలి. ");
INSERT INTO tel2010_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","పాపపరిహారార్థ బలిగా ఒక మేకను మీరు అర్పించాలి. ప్రతిదినం బలి అర్పణ, దాని ధాన్యార్పణ, పానార్పణకు ఇది అదనం. ");
INSERT INTO tel2010_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ఈ పండుగ ఎనిమిదో రోజు మీకు చాల ప్రత్యేక సమావేశం ఉంటుంది. ఆ రోజు మీరు ఏ పనీ చేయకూడదు. ");
INSERT INTO tel2010_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","మీరు ఒక దహనబలి అర్పించాలి. అది హోమార్పణ. యెహోవాకు ఇష్టమైన సువాసన. ఒక కోడెదూడ, ఒక పొట్టేలు, పుష్