﻿USE sofia;
DROP TABLE IF EXISTS sofia.teeNT_vpl;
CREATE TABLE teeNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES teeNT_vpl WRITE;
INSERT INTO teeNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ju ani yuchi ixtapaka'ut'an ju mak'aniya ixlacpa'itni ju Jesucristo acsni tavanan quitsucuchilh ju ani tachi lapanac. Pus ju yuchi mak'aniya ixpapanti ixjunita ju David chai ju Abraham. ");
INSERT INTO teeNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Pus ju Abraham alilh ju ists'alh chai lhimapaka'ulh Isaac. Chai ju Isaac alilh ju ists'alh chai lhimapaka'ulh Jacob. Chai ju Jacob alilh ju ists'alh chai lhimapaka'ulh Judá. Vachu' alilh ju ali'in is'ap'isek'en. ");
INSERT INTO teeNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Chai ju Judá t'a'amask'at'analh ju Tamar. Alhimapaka'ulh ju ists'alan Fares chai ju Zara. Pus ju Fares alilh ju ists'alh chai lhimapaka'ulh Esrom. Chai ju Esrom alilh ju ists'alh chai lhimapaka'ulh Aram. ");
INSERT INTO teeNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Chai ju Aram alilh ju ists'alh chai lhimapaka'ulh Aminadab. Chai ju Aminadab alilh ju ists'alh chai lhimapaka'ulh Naasón. Chai ju Naasón alilh ju ists'alh chai lhimapaka'ulh Salmón. ");
INSERT INTO teeNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Chai ju Salmón t'a'amask'at'analh ju Rahab. Chai lhimapaka'ulh ju ists'alh Booz. Pus ju Booz t'a'amask'at'analh ju Rut. Lhimapaka'ulh ju ists'alh Obed. Chai ju Obed alilh ju ists'alh chai lhimapaka'ulh Isaí. ");
INSERT INTO teeNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Pus ju Isaí alilh ju ists'alh chai lhimapaka'ulh David ju valh k'ai ucxtin. Pus ju k'ai ucxtin David t'a'alilh ists'alh ju ix'amachaka' ixjunita ju lijunto Urías. Chai talhimapaka'ulh ists'alh Salomón. ");
INSERT INTO teeNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Chai ju Salomón alilh ju ists'alh chai lhimapaka'ulh Roboam. Chai ju Roboam alilh ju ists'alh chai lhimapaka'ulh Abías. Chai ju Abías alilh ju ists'alh chai lhimapaka'ulh Asa. ");
INSERT INTO teeNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Chai ju Asa alilh ju ists'alh chai lhimapaka'ulh Josafat. Chai ju Josafat alilh ju ists'alh chai lhimapaka'ulh Joram. Chai ju Joram alilh ju ists'alh chai lhimapaka'ulh Uzías. ");
INSERT INTO teeNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Chai ju Uzías alilh ju ists'alh chai lhimapaka'ulh Jotam. Chai ju Jotam alilh ju ists'alh chai lhimapaka'ulh Acaz. Chai ju Acaz alilh ju ists'alh chai lhimapaka'ulh Ezequías. ");
INSERT INTO teeNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Chai ju Ezequías alilh ju ists'alh chai lhimapaka'ulh Manasés. Chai ju Manasés alilh ju ists'alh chai lhimapaka'ulh Amón. Chai ju Amón alilh ju ists'alh chai lhimapaka'ulh Josías. ");
INSERT INTO teeNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Chai ju Josías alilh ju ists'alh chai lhimapaka'ulh Jeconías. Vachu' alilh ju is'ap'isek'en. Pus acsnich ju tatsuculh ju Jeconías chai is'ap'isek'en acsni tach'in alhi'ancalh ju israelitanin ju xalacat'un Babilonia. ");
INSERT INTO teeNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Chai ju anch pus ju Jeconías alilh ju ists'alh chai lhimapaka'ulh Salatiel. Chai ju Salatiel alilh ju ists'alh chai lhimapaka'ulh Zorobabel. ");
INSERT INTO teeNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Chai ju Zorobabel alilh ju ists'alh chai lhimapaka'ulh Abiud. Chai ju Abiud alilh ju ists'alh chai lhimapaka'ulh Eliaquim. Chai ju Eliaquim alilh ju ists'alh chai lhimapaka'ulh Azor. ");
INSERT INTO teeNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Chai ju Azor alilh ju ists'alh chai lhimapaka'ulh Sadoc. Chai ju Sadoc alilh ju ists'alh chai lhimapaka'ulh Aquim. Chai ju Aquim alilh ju ists'alh chai lhimapaka'ulh Eliud. ");
INSERT INTO teeNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Chai ju Eliud alilh ju ists'alh chai lhimapaka'ulh Eleazar. Chai ju Eleazar alilh ju ists'alh chai lhimapaka'ulh Matán. Chai ju Matán alilh ju ists'alh chai lhimapaka'ulh Jacob. ");
INSERT INTO teeNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Chai ju Jacob alilh ju ists'alh chai lhimapaka'ulh José. Chai yuchach ju valhch ixpapa ju Malia ixnati ju Jesús ju Cristo juncan. Yuchi ju ixnoncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Pus tus acsni tsuculh ju Abraham tus acsni tsuculh ju David quilhmaccaut'at'i va ju tatsuculh ju lapanacni. Chai aquilhmaccaut'at'i va ju tatsuculh tus acsni tsuculh ju David tus acsni alhi'ancalh ju israelitanin tach'in ju xalacat'un Babilonia. Chai aquilhmaccaut'at'i va ju tatsuculh tus acsni alhi'ancalh tach'in ju israelitanin ju xalacat'un Babilonia tus acsni tavanan tsuculh ju Cristo. ");
INSERT INTO teeNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Acsni tavanan lak'aulhch ju Jesucristo pus chanich va. Pus yuchi ju Malia ju ixnati cajuna' va is'asq'uinintica' ixjunita ju José. Para acsni jantuca' ixtalat'atsucui acsnich ju c'atsacalh ni ixpacxanta ju is'ask'at'a la'ixtachaput ju Spiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pus ju José na ixnavi tachi ixnajun la'ixlhamap'aksin ju Moisés chai ju anch ixlhik'alhtsajui ni xamati' va k'aya calalh. Pus ixlhiyuchi ju José jantu ixt'atamak'axtokputun ju Malia acsni c'atsa ta yu ixjunita. Para jantu ixmamaxaniputun ju Malia lacatalhavat ni va cachivimak'alh. Alai va sekch ixmaco'ulaputun. ");
INSERT INTO teeNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Para acsni pastaclich ju chunch pus lana talacasunilh pumatam anquilh la'ilhtatat chai chani juni: ―José. Ju uxint'i mak'aniya ixpapanti David unit'a. Jantu at'alhan. Jantu anauch ni jantu navip'ut'un mi'amachaka' ju Malia. Pus ju tuchi pacxanta ix'anuch ju Spiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Chai ju yuchi camaklok'onach pumatam ts'alh chai alhimap'ak'a'uya'ich Jesús ni yuchach ju camak'alhtaxtuya' ixlapanacni la'ix'alactu'unti'an. ―Chunch ju junicalh ju José. ");
INSERT INTO teeNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pus tachi chun ju ani chunch ju tapasalh ni chunch ju pu'uctaxtulh ju tuchi ixnajunta ju mak'aniya lapanac ju ixnajun ixchivinti Dios. Pus chani ixnajun: ");
INSERT INTO teeNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ju pumatam atsi' ju va is'akstuca' ma capacxana' ju ask'at'a chai camaklok'ona' pumatam ts'alh chai calhimapaka'uyach Emanuel. Pus ju Emanuel va nomputun ni quintat'avilanch ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Pus ju tunculh acsni cujlh ju José pus navilh tachi ju junilh ju anu' anquilh chai lhi'alh ju Malia la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Para jantu t'atsuculh tus acsni tsuculh ist'asast'i is'ask'at'a. Chai ju yuchi lhimapaka'ulh Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ju Herodes gobernador ixjunita ju xa'estado Judea acsni tavanan tsucuchalh ju Jesús ju lak'achak'an Belén lhiJudea. Chai ju acsnich tachincha lak'achak'an Jerusalén ali'in lapanacni ju ixtalhatalanininta ju st'acu. Tamincha lhich'ato'anta. ");
INSERT INTO teeNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Chai ta'asacminilh. Tanaulh: ―Tas anchach ju vi ju ix'ucxtin'an ju israelitanin ju va tsuculhca'. Pus laquint'un quinc'an iclakts'iuch ju st'acu ju tasu chai ju nomputun ni tsuculh ju yuchi. Chai ju quijnan icmintau ni va iclak'ayaputunau. ");
INSERT INTO teeNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Para acsni k'asmatlh ju gobernador Herodes ju ani chivinti pus na talhanalh. Chai vachu' chunch talalh tachi chun ju amachak'an ju lak'achak'an Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pus ju acsnich ju gobernador alact'asanik'o chux ju xalack'ajin palijni chai ju yu'unch ju ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin chai asacmi ta ixnajunch ju ixchivinti Dios ju ists'okcanta mak'anchich. Ma tas anchach ju catsucuyanta ju Cristo ju anu' ju ixnoncan ni camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Chai ju yu'unch tajunilh: ―Pus ju yuchi catsucuyanta ju lak'achak'an Belén laxa'estado Judea. Icpunonau chunch ni chanich ju xanajun pumatam mak'aniya ixlapanac Dios la'is'ats'oknut: ");
INSERT INTO teeNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Jantu lai actinaulh ni va palai jantu tu'u' ju ixtapalhni ju lak'achak'an Belén laxa'estado Judea. Palai tu'u' ju ali'in lak'achak'an ju ani lacat'un. Jantu lai chun actinaulh ni anchach ju catsucuyanta pumatam k'ai ucxtin. Chai yuchi ju calhist'ac'a' ju israelitanin ju ixlapanacni Dios tajunita. Chunch ma naulh ju ixlapanac Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Pus ju acsnich ju Herodes sekch alact'asanilh ju anuch lapanacni ju ixtalhatalaninin ju st'acu. Va isc'atsaputun ju ixtavasalanti tavananch ju tasulh ju anu' st'acu. ");
INSERT INTO teeNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Chai acsni c'atsa pus amalakachalh ju lak'achak'an Belén chai ajuni: ―Inchit'it puxconin anch ju ask'at'a. Chai acsni alhit'a'uya'it'it pus aquiminau lajuninin. Ac'ananta vachu' lak'ayana'. ");
INSERT INTO teeNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Pus ju yu'unch tak'asmatnilh ju gobernador chai ta'alh. Chai acsni ta'alh ju lacati pus ap'ulhnilh ju anu' st'acu ju ixtalakts'intacha la'ixt'un'an. Ap'ulanalh tus acsni cha'alh junta ixtanun ju ask'at'a Jesús. Chai anchach ju astacnalh. ");
INSERT INTO teeNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Pus ju anuch lapanacni ni talakts'ilh ju st'acu pus na tak'achalh. ");
INSERT INTO teeNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Chai acsni tatanu lacachaka' talakts'ilh ju ask'at'a chai ixnati ju Malia ixjuncan. Pus tata'aktsokotanilh chai talak'ayalh. Chai tapaxk'otlh ju ixtalhiminta chai taxtaknilh ju lhak'ailakts'in ju oro chai ju pum chai ju xak'alhch'at lakatam q'uiu ju na c'us acamin. ");
INSERT INTO teeNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chai acsni ta'anchokolh la'ixt'un'an k'ank'atam ti tapu'anchokolh. Chunch ju talalh ni Dios xa'ajuni la'ix'aklak'avanti'an ni jantu catalak'anchokolh ju Herodes. ");
INSERT INTO teeNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Astan acsni ixta'anchokota la'ixt'un'an ju anuch lapanacni pus pumatam anquilh talacasunilh ju José la'ilhtatat chai juni: ―Ak'ost'a'ulh. Alhip'inchich ju ask'at'a chai ixnati ju xalacat'un Egipto. Chai anchach ju at'olhchit'it tus va acxak'alachokoyan. Ap'inchit'it anch ni calhinona' ixpuxcajuca ju ask'at'a ju Herodes ni va makniputunch. ");
INSERT INTO teeNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Pus ju José lana k'ostavilh. Lhi'alh ju ask'at'a Jesús chai ixnati ju anuch atats'isni. Ta'alh ju xalacat'un Egipto. ");
INSERT INTO teeNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chai tatolhcha anch tus acsni va nilh ju Herodes. Chai ni chunch ju talalh pus uctaxtulh tuchi ixnajuntach ju mak'anch ju ixlapanac Dios junta ma chani xanajun: “Laxalacat'un Egipto ict'asanilh ju quints'alh”. ");
INSERT INTO teeNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Pus ju Herodes acsni machakxa ni va ta'okxchok'olh ju anuch lapanacni pus slivasalh na talhk'amalh. Chai lhinaulh ixmaknica tachi chun ju ts'alan ju ix'alin ju lak'achak'an Belén chai chux ju ali' lak'achak'anixni junta vanin ixjunita. Amaknik'o tachi chun ju ixtapacxanta lakat'iyun c'ata chai ju palaica' lact'icst'in. Ixnajun ni ca'amaknich ju ali'in pus tap'astu vachu' camakniya' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Chai ni chunch ju lalh ju Herodes pus uctaxtulh tuchi ixnajunta mak'anchich ju ixlapanac Dios ju Jeremías ixjuncan. Ju yuchi ma chani naulh: ");
INSERT INTO teeNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ma k'asmatcancha ju lak'achak'an Ramá ju na talact'asai. Ma na lack'alhuncan chai slivasalh lact'asacan. Ma tachi ju vasalh yuchi ju Raquel ju k'alhun. Ma va alhik'alhun ju ists'alan. Chai ma jantu xamati' lai amatan'ulani ix'alhunut'an ni amaknik'ocalh ju ists'alan. Chunch ju ma naulh ju Jeremías. ");
INSERT INTO teeNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Pus acsni nilh ju Herodes pus talacasunichokolh ju anquilh ju José la'ilhtatat acsni ixvilhchaca' ju lak'achak'an Egipto chai chani juni: ");
INSERT INTO teeNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Alac'at'ayat'ich. Alhip'inch'ok'ochich ju ask'at'a chai ixnati ju la'ixt'un'an ju mint'a'israelitanin. Laich ap'inch'ok'oya'it'it ju chavai ni tanitach ju ixtamakniputun ju ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Pus ju José lacataya chai lhi'alh ju ask'at'a chai ixnati ju la'ixt'un'an ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Para na talhanalh acsni k'asmatlh ni Arquelao gobernador va laxa'estado Judea acsni nilh ju ixpai ju Herodes ixjuncan. Pus jantu ix'amputun ju anch. Chai ni junilh ju Dios la'ilhtatat ni ca'alh ju xa'estado Galilea pus anch ju alaclhi'alh ju ask'at'a chai ixnati. ");
INSERT INTO teeNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Chai acsni tacha'alh pus tatsucucha ju lak'achak'an Nazaret. Chai ni anch ju ta'alh pus uctaxtulh tuchi ixtanajunta ju mak'aniya ixlapanacni Dios acsni tanaulh ni amachaka' Nazaret cajuna' ju Cristo. ");
INSERT INTO teeNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chai ju acsnich ju Xivan ju amakpaxana' chincha ju xa'estado Judea. Chai lacamacni amalanilh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Chai chani ix'ajuni: ―Amac'a'unt'it ju mi'alactu'unti'an ni vaninch minta ju avilhchan acsni calhinona' ju Dios. ―Chunch ix'ajuni ju lapanacni ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Pus ju mak'aniya ixlapanac Dios ju ixjuncan Isaías ixnajunta ta yu canona' ju Xivan mas tuca' istsucui ju yuchi. Pus chani ixnajun ju Isaías: K'asmatcan ixchivinti ju pumatam ju na p'as chivinin lacamacni. Chai ju yuchi ma chani najun: Alak'oxit'it ju mi'atalacpast'ac'at'an ni camina' ju mi'ucxtin'an. Chach salaka va ju mi'alhunut'an. Ma chunch ju ixnajun ju Isaías. ");
INSERT INTO teeNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Pus ju ixlakch'ita ju Xivan apaksivinti ix'apamat camello ixjunita. Chai lakatam axt'ak'an ixtank'aijucalh. Chai ix'ui ju tu'u' tachi silek ixlakts'inca. Vachu' ix'ui ju xat'axcat lacaq'uivin. ");
INSERT INTO teeNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Pus ju amachak'an lak'achak'an Jerusalén chai chux ju amachak'an ju xa'estado Judea chai chux ju lapanacni ju ixtat'ajun ixtalakachoko ju k'ai xcan Jordán ixtalak'an ju Xivan ni ixtak'asmatniputun ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Chai ju Xivan ix'amakpaxai ju laxak'ai xcan Jordán acsni ixtanajun ni catamacona' ju ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Para ju Xivan acsni alakts'ilh ni na lhu ju ixta'akpaxputun ju ixtalhilaksi ju ixlhamap'aksin ju fariseonin chai ju ixtalhilaksi ju ixlhamap'aksin ju saduceonin pus chani ajuni: ―Chunch ju lap'ut'unat'it tachi ju tu'u' lu. Ju yuchi va acsnich ju ats'alai acsni xavacan ju ach'itin junta t'ajun. Pus vachu' chun ju lap'ut'unat'it ju uxijnan. Va acsnich ju tamch p'ast'acp'ut'unat'it ni xak'asmat'at'it ni catamamak'alhk'ajniyan ju Dios. Tis chavaich ju xatajunan ni anaviya'it'it tu'u' ni jantu catamamak'alhk'ajniyan ju Dios acsni cachina' ju anu' avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Pus ni vasalh t'ak'alht'axt'up'ut'unat'it amalac'asut'it lami'atsucunti'an ni mac'ont'at'it ju mi'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Chai jantu va k'aya ana'unt'it ni lai ap'ut'ak'alht'axt'uya'it'it va ixlaca'atalh ni mak'aniya ix'apapanatnich ju Abraham unt'at'it. Pus ju Dios ni va ixlacasq'uilh ni lhu ca'ix'alilh ix'apapanatnich ju Abraham pus laich ca'ix'amalok'oni ju ani lacma chiux ni ca'ixtavalh ix'apapanatnich ju Abraham. ");
INSERT INTO teeNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chai mas chavai va lacats'unin tic'acx tus ca'amamak'alhk'ajniya' ju lapanacni ju Dios. Chai tachi chun ju lapanacni ju jantu tasui la'is'atsucunti'an ni vasalh tamacajunta ju ix'alactu'unti'an pus ca'amamak'alhk'ajnik'alhicana'. ");
INSERT INTO teeNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ju quit'in vasalh iclamakpaxayau lacaxcan ni catac'atsaya' ju lapanacni ni vasalh mac'omp'ut'unat'it ju mi'alactu'unti'an. Para camina' apumatam astan ju palai xak'ai. Palai jantu ju quit'in. Ju quit'in jantu tu'u' quintapalhni. Jantu lai actich'anxk'otlh nin mas va yuchi ju samusni ju ixch'anxt'ak'an. Pus ju anu' ju camina' astan cataxtakniyan ju ali'in milhi'uxijnan ju Spiritu Santu. Para ju ali'in ju jantu lai talaca'i pus ca'amamak'alhk'ajniyach. ");
INSERT INTO teeNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ju yuchi ca'ulhtuya' ju lapanacni tachi ju tam lapanac ju lacsunui ju ixcapen. Ju yuchi lacsacxtui ju xacapen chai mak'ani ju xa'amacxtalh. Pus chunchach vachu' ca'a'ulhtuya' ju lapanacni ju Jesús. Ju vasalh tamacajunta ix'alactu'unti'an casacxtucana' chai camak'alhtaxtucana'. Para ju jantu macajunta ix'alactu'unti camaca'ancana' junta jonk'alhita mak'alhk'ajnat. ");
INSERT INTO teeNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ju acsnich ju Jesús mincha ju xa'estado Galilea. Lakmilh ju Xivan ju laxak'ai xcan Jordán ni laich ca'akpaxlh vachu'. ");
INSERT INTO teeNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Para ju Xivan jantu ixmakpaxaputun. Chai chani juni ju Jesús: ―Tajuch ni laich q'uilakt'ant'a ju quit'in ni acmakpaxayan ju uxint'i. Alai tasq'uini ni quit'in ju aq'uimakp'axat'i. ");
INSERT INTO teeNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Para ju Jesús chani ju lhik'alhtailh: ―Lamapainin aq'uimakp'axat'i ni tasq'uini ni canavik'oyau chux tachi ju k'achani ju Dios. Pus ju acsnich makpaxa ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Chai acsni akpaxk'o ju Jesús pus tacutlh ju lacxcan chai lana talhtek'a ju lact'iyan chai ju Jesús lakts'ilh ju iSpiritu Santu ju Dios ni milh tachi ju tu'u' lak'axk'avan. Chai lakmilh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Chai chivincancha ju lact'iyan chai k'asmatcalh ju lacat'un junta ixya ju Jesús. Chai chani naulh: ―Ju ani ya yuchi ju quints'alh. Ju yuchi na icmapaini. Na iclhik'achanch ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Pus ju acsnich ju Spiritu Santu lhi'alh ju Jesús ju lacamacni ni laich canavi talacmask'atinti ju lhacaticuru ni ts'a ma laich ca'ixmalactu'uni ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pus t'up'uxam avilhchan chai t'up'uxam atats'isni jantu vailh ju Jesús chai astan na chavanilh. ");
INSERT INTO teeNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Chai ju acsnich lana chincha ju lhacaticuru chai ixmalactu'uniputun ju Jesús. Chai chani juni: ―Ni sala vasalh ists'alh Dios'at pus a'unch ni chach junlh xkapavati junima chiux. ");
INSERT INTO teeNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Para ju Jesús k'alhtailh. Juni: ―Jantu lai chun actinavi ni najun ju ixchivinti Dios ju ts'okcanta ni jantu va yuchi ju xkapavati ju canaviya' cuenta ju tam lapanac. Alai canaviya' cuenta tachi chun ju ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ju acsnich ju lhacaticuru alhi'ananalh. Lhi'alh ju Jesús ju lak'achak'an Jerusalén. Chai anch ju yocalh junta palai aksti putank'ai ixjunita ju ixpujitat'an ju israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Chai chani juni: ―Ni sala vasalh ists'alh'at Dios pus amak'anlht'ujnuch. Lai chunch alat'i ni chani ju ts'okcanta la'ixchivinti Dios: Ju Dios ma ca'alhimap'aksiya' ju ix'anquilhnin ni catalhist'ac'an. Ma la'ixmaca'an catach'ixan ni jantu cach'an'uyan tu'u' chiux. ");
INSERT INTO teeNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Para ju Jesús chani lhi'ak'alhtayanalh: ―Vachu' ts'okcanta ju anch ni jantu alakts'int'anut'i ju Dios ni camuctaxtuya' ju ixchivinti u jantu. ");
INSERT INTO teeNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Astan ju lhacaticuru alhi'anananchokolh la'ix'ucxni lakatam talhpa ju na putank'ai ixjunita. Chai ju anch malacasunik'o tachi chun ju xalacpu'ucxtin ju ani lacamunutpa' chai tachi chun ju ixpuxak'ai'an. ");
INSERT INTO teeNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Chai chani juncan ju Jesús: ―Uxint'i ju acxtaknik'oyan chux ju ani ni aq'uint'a'akts'ok'ot'aniya'ich chai aq'uilak'ayat'ich. ");
INSERT INTO teeNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Para ju Jesús chani ak'alhtayanalh: ―Ap'inchich ji Satanás ni najun la'ixchivinti Dios ju ts'okcanta ni yuchi ju ucxtin Dios ju calak'ayacalh chai va yuchi ju caquiclaca'icalh. ");
INSERT INTO teeNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Pus ju acsnich ju lhacaticuru lana macoyaulh ju Jesús chai talakmilh ju anquilhnin chai talhiminilh ju ixvaiti. ");
INSERT INTO teeNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Pus ju Jesús acsni c'atsa ni tach'in navicalh ju Xivan pus anchokolh la'ixt'un lhiGalilea. ");
INSERT INTO teeNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Para jantu mak'an tolhcha la'ixlak'achak'an junta Nazaret ixjuncan. Alai alh tsucunu' ju Capernaum ju vi la'ixquilhtu' atants'in junta Galilea juncan. Chai vanin ixvi ju xalacat'un Zabulón chai ju xalacat'un Neftalí. ");
INSERT INTO teeNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Pus ni alh ju anch pus uctaxtulh ju ixchivinti ju mak'aniya ixlapanac Dios ju Isaías ixjuncan acsni chani xanajun la'is'ats'oknut. ");
INSERT INTO teeNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ju xalacat'un Zabulón chai ju xalacat'un Neftalí tavilanancha la'ixquilhtu' ju atants'in ju ma lak'antacutni ju k'ai xcan Jordán laxa'estado Galilea junta na lhu tat'ajun ju jantu israelitanin tajunita. ");
INSERT INTO teeNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Chai ju amachak'an anch tachi ju va ixtat'ajun laca'atats'isni ni jantu ixtamispai ju ixtavasalanti ixlacata ju Dios. Para ju chavai tachi ju va talakts'ilh ju atuncunu' ni ajunicalh ju stavasalanti. Ju amachak'an anch ix'alacmuc'anicanta ju ix'aninti'an junta jonk'alhita mak'alhk'ajnat. Para ju chavai talakts'inta ju atuncunu' ni ajunicalh ju stavasalanti. Chunch ju naulh ju Isaías. ");
INSERT INTO teeNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Pus acsni ixvilhcha ju lak'achak'an Capernaum ju Jesús acsnich ju tai'ula ix'amalanica ju lapanacni. Chani ix'ajuni: ―Amac'a'unt'it ju mi'alactu'unti'an ni vanin minta ju avilhchan acsni calhinona' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Pus ju Jesús ix'alhtanan la'ixquilhtu' ju xa'atants'in Galilea acsni alakts'ilh ixt'iyun'an lhi'alak'avin. Ju pumatam yuchi ju Simón ju vachu' Pitalu' ixjuncan. Chai ju pumatam Tilix ixjuncan. Ju yu'unch ixtat'ajun munin ixch'okxni'an laca'atants'in ni ixch'apanin pamata ixtajunita. ");
INSERT INTO teeNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Pus ju acsnich ju Jesús chani ajuni: ―Aquilach'ak'ok'au chai tachi ju ixmak'aixt'ok'at'it ju pamata pus vana va chun aclaxtakniyau ju lhich'alhcat ni amak'aixt'ok'a'it'it ju lapanacni ju aquintalhilaca'ana'. ―Chunch ju alacjuni. ");
INSERT INTO teeNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pus ju yu'unch lana tamacaulich ju ixch'okxni'an chai tach'ak'ok'alh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Chai ni alhtanampa alacats'unin ju Jesús pus alakts'impa ju ali'in ixt'iyun'an lhi'alak'avin. Yuchi ju Jacobo chai ju Xivan ists'alan ju Zebedeo. Ju yu'unch ixtat'atajun ju ixpai'an la'ixbarco'an. Va ixtat'ajun lakyonin ixch'okxni'an. Pus ju Jesús alact'asanilh ixt'iyun'an lhi'alak'avin. ");
INSERT INTO teeNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Chai lana tatacutcha lacabarco. Tamacaulh ju ixpai'an. Chai tach'ak'ok'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Pus ju Jesús ixlacaputoc'at'ajun ixlhilacaputs'un ju xa'estado Galilea. Ix'amalaninin la'ixlacpujitat'an ju lakatamin lak'achak'an. Ix'ajuni ju lapanacni ni lhinomputun ju Dios la'ix'alhunut'an ju yu'unch. Vachu' palaich ix'anavi ju lapanacni ju ixtach'apata mas va tuchi tak'ank'at. ");
INSERT INTO teeNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pus mas tus xalacat'un Siria lacc'atsak'ocalh ixlacata ju Jesús. Chai alhiminik'ocalh ju lapanacni ju ixtat'ajun lhimak'alhk'ajnin tijpachux mak'alhk'ajnat. Alaclhimini ju ixtalactak'ank'ai chai ju yu'unch ju ix'ach'apanita is'aktsulh'an ju lhacaticuru chai ju va ixtalhtucuni chai ju va ixtalacalhtuculuntach. Chai ju Jesús si palai anavik'o. ");
INSERT INTO teeNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pus na lhu lapanacni tach'ak'ok'alh ju Jesús. Amachak'an xa'estado Galilea chai ju amachak'an ju anu' lakacau lak'achak'anixni chai ju amachak'an lak'achak'an Jerusalén chai chux ju lacat'un ju xa'estado Judea chai ju xalacat'un ju lak'antacutni k'ai xcan Jordán. ");
INSERT INTO teeNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Pus ju Jesús acsni alakts'ilh ni na lhu tatak'aixtoklh ju lapanacni pus alh junta ixvi lakatam akstijun chai tolhcha ju anch. Chai talakmilh ju ixtamamaka'un. ");
INSERT INTO teeNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Chai ju Jesús tsuculh amalanini'. Chani ix'ajuni: ");
INSERT INTO teeNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Va paxcatch ju lapanacni ju tac'atsai ni na tamaktasq'uini ju Dios. Pus catacha'ana' ju lact'iyan junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Va paxcatch ju yu'unch ju na ta'amak'aninin. Pus ju Dios ca'amak'ank'achayach ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Va paxcatch ju yu'unch ju lana jantu tu'u' talhitak'ayai. Pus ca'axtaknicana' ju lacat'un ju ak'alhtasunita ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Va paxcatch ju na talacasq'uin ju soknic'a atsucunti. Pus chunch cajuna' is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Va paxcatch ju na ta'amapaininin. Pus vachu' ca'amapainicana' ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Va paxcatch ju jantu tu'u' tapast'ac'a macxcai la'ix'alhunut'an. Ju yu'unch catalakts'ina' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Va paxcatch ju yu'unch ju talamak'oxamixich junta alin ju tu'u' axcayanti. Yu'unch ju cajuncana' is'ask'at'an Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Va paxcatch ju yu'unch ju na amamak'alhk'ajnican va ixlaca'atalh ni soknic'a ju is'atsucunti'an. Ju yu'unch catacha'ana' ju lact'iyan junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Va paxcatch unt'at'it ju uxijnan acsni tajunan macxcai chivinti ju lapanacni chai acsni alhimakch'ap'uc'anat'it chai acsni muc'anic'anat'it tachi chun ju macxcai mas jantu slivasalh. Tachi chun ju ani ta'ulhtuyan va ixlacata ni quilalhilaca'anauch ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pus alhik'ach'ant'it chai na k'ox alhiulat'it acsni chunch a'ulht'uc'ana'it'it. Chunch alat'it ni slivasalh na k'ox ju axt'aknic'ana'it'it ju lact'iyan. Chai ap'ast'act'it ni vana va chunch ju anavicalh ju ixlapanacni Dios ju mak'anchich ixtat'ajun acsni tuca' ixt'onat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Na k'ox ju matsat. Para ju matsat ni jantu sk'ok'o cava pus jantu lhitapalai. Jantu lai tu'u' punavican. Alai va mak'ancanch chai va taputayalhavananch ju lapanacni. Pus vana va chun ju uxijnan. Lhitapalai ju mi'atsucunti'an acsni vasalh tasui ni quilalhilaca'anau. Para ni jantu chun tasui lami'atsucunti'an pus jantu lhitapalai ju mi'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mas va lakatam maclhcu makat mapulhcui. Pus vana va chun ju uxijnan. Na lhu talakts'inan chai tac'atsai ni quilapanacni unt'at'it. Tachi ju tu'u' lak'achak'an ju la'ix'ucxni talhpa jantu lai xamati' cati'akxtakma. ");
INSERT INTO teeNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Chai ju tu'u' maclhcu jantiyu' lhixavacan ni va ca'akxtak'ulacalh lacatu'u' caja. Alai muc'acan talaclhman ni laich mapulhcuni tachi chun ju tatanumanalh lacachaka'. ");
INSERT INTO teeNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Pus vana va chun ju uxijnan. Ju Dios ta'ulatan ju ani lacamunutpa' ni laich catac'atsaya' ju lapanacni lami'atsucunti'an ni vasalh quilalhilaca'anau ju quit'in. Pus jantu tu'u' anavit'it ju va ca'asastucnulh. Ju chunch acsni talakts'inan ni na k'ox ju naviyat'it pus catalak'ayayach ju quimpai'an Dios ju vilhcha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju ixtamamaka'un: ―Jantu va ana'unt'it ni va icminta samak'ana' ju lhamap'aksin ju ts'ok'ula ju Moisés nin ixchivinti'an ixlapanacni Dios ju mak'anchich ixtat'ajun. Jantu icminta samak'ana' ju yuchi. Alai icminta muctaxtunu'. ");
INSERT INTO teeNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Slivasalh ju iclajunau. Acsni ti'alinca' ju lact'iyan chai ju lacat'un pus nin lacats'unin ju najun lacalhamap'aksin lai catixacaxtulh xamati'. Chux lana ca'uctaxtuk'oya'. ");
INSERT INTO teeNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Pus va tichi chavaich ju jantu camuctaxtuk'oya' tachi chun junima lhamap'aksin mas yuchi ju tanajun ju ali'in ni jantu lhitapalai ni canavicalh chai ni va chunch ju ca'alhimalani ju lapanacni pus va lacat'icst'i calakts'incananta ju lact'iyan junta lhinajun ju Dios. Para va tichi chavaich ju camuctaxtuya' chux tachi ju najun la'ixlhamap'aksin Dios chai ni chunch ju ca'alhimalaniya' ju ali'in lapanacni pus ju yuchi calhimispacanach ni xak'ai ju lact'iyan junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Para chani iclajunau. Ni at'anuya'it'it ju lact'iyan junta lhinajun ju Dios pus tasq'uini ni palai soknic'a cava ju mi'atsucunti'an ju uxijnan. Jantu chun tachi ju fariseonin nin tachi ju yu'unch ju talhatalaninintach ju milhamap'aksin'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju lapanacni: ―Ju uxijnan k'asmat'at'it ni ix'ajuncan ju mak'aniya lapanacni ni jantu catalamakni. Chai va tichi chavaich ju ca'amakninina' pus camuc'anicana' ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Para ju quit'in iclajunau ni camuc'anicana' ixtalak'alhin va tichi chavaich ju va cat'alatalhk'amniya' ju tam ixlak'au. Chai va tichi chavaich ju cajunach macxcai chivinti ju tam ixlak'au camamak'alhk'ajnicana' la'ixmaca'an ju xalack'ajin ucxtinin. Chai va tichi chavaich ju cajunilh tam ixlak'au ni jantu k'ox ju is'aktsulh pus camamak'alhk'ajnicana' ni camaca'ancana' ju lacajipi. ");
INSERT INTO teeNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Pus ni lhip'int'ach ju milhak'ailakts'in junta xtaknican ju Dios pus jantu xcai ni ap'ast'act'i ni va ixt'alak'a'it'a ju milak'au. ");
INSERT INTO teeNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Pus ni p'ast'act'a ju chunch pus amac'auch ju milhak'ailakts'in ju anch junta xtakcan. A'inch'ok'ochich. P'ulhnan at'ap'aininich ju milak'au. Acsnica' ju laich ap'ina' xtakna' ju milhak'ailakts'in. ");
INSERT INTO teeNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ni catachivimak'anan tam xamati' chai catak'ailhi'anan lacapu'ucxtin pus vats'alhti at'at'ak'oxit'it acsni t'ap'int'at'itca' ju lacati. Ni jantu pus ju mint'alaxcai'an laich catalhicha'anan lacapu'ucxtin. Chai ju ucxtin catamak'axtakniyanch ju pulasiyajni chai catat'alhnuyanch. ");
INSERT INTO teeNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Chai slivasalh ju iclajunau. Jantu at'it'axt'ut'it ju anch tus acsni amap'ala'it'it chux ju mimulhta'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ju uxijnan k'asmat'at'it ni ix'ajuncan ju mak'aniya lapanacni ni jantu catat'atsuculh ju jantu ix'amachaka' u jantu ixpapa. ");
INSERT INTO teeNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Para ju quit'in iclajunau ni alactu'ununtach la'ix'alhunut va tichi chavaich ju lakts'in tam chako'ulh ju lana t'atsucuputunch. ");
INSERT INTO teeNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Pus ni yuchi ju lakts'imp'ut'unat'it lamilakchulh'an ju lamilhicana'an ju catamapast'ac'aniyan ju alactu'unti pus jantu alakts'int'it. Alai alat'it tachi ju va maxt'ut'at'it ju milakchulh'an chai mak'ant'at'it. Pus palai k'ox cava ni cats'ank'a lacats'unin ju milacatuna'an. Jantu chux ju milacatuna'an ju ca'alh ju lacajipi. ");
INSERT INTO teeNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chai ni p'u'alact'u'unump'ut'unat'it ju mimaca'an lamilhicana'an pus alat'it tachi ju va ch'akxp'uxt'at'it chai mak'ant'at'it. Pus palai k'ox cava ni cats'ank'a lacats'unin ju milacatuna'an. Jantu chux ju milacatuna'an ju ca'alh ju lacajipi. ");
INSERT INTO teeNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Vachu' ixnoncan ni caxtaknilh ix'alhiqui ju lapumaconcan va tichi chavaich ju camacaulh ju ix'amachaka'. ");
INSERT INTO teeNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Para ju quit'in iclajunau ni va acsnich ju lai mac'onat'it ju mi'amachaka'an ni va t'at'ajun apumatam jok'at. Para ni va k'aya amac'ona'it'it ju mi'amachaka'an pus uxijnan ju malact'u'unit'it ju mi'amachaka'an ni astan cat'atsuculh apumatam jok'at ju yuchi. Chai va tichi chavaich ju cat'atsucuya' ju va maconcanta vachu' navi ju alactu'unti. ");
INSERT INTO teeNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Vachu' k'asmat'at'it ni ix'ajuncan ju mak'aniya lapanacni ni catamuctaxtulh ni talhipastacta ju Dios ixpumavasalaca ju ixchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Para ju quit'in iclajunau ni jantu tu'u' alhip'ast'act'it ju ixpumavasalaca ju minchivinti'an mas va tuch'i anaviya'it'it. Nin yuchi ni lai alhip'ast'act'it ju lact'iyan ni anchach ju lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nin yuchi ni lai alhip'ast'act'it ju lacat'un ni anchach ju ch'antai ju Dios. Nin yuchi ju lak'achak'an Jerusalén ni yuchach ixlak'achak'an ju k'ai ucxtin Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nin yuchi ni lai alhip'ast'act'it ju mi'aktsulh'an ju ixpumavasalaca ju minchivinti'an. Jantu lai alhip'ast'act'it ju yuchi ni jantu lai xnapapa at'inavit'it ju mi'ai'an nin smalaka. ");
INSERT INTO teeNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Alai chach tac'atsaya' ju lapanacni ni vasalh a ju nomp'ut'unat'it acsni nonat'it a. Chai vasalh jantu ju nomp'ut'unat'it acsni nonat'it ni jantu. Para ni makt'asq'uiniyat'it tu'u' atumpa va nomputun ni na va alact'u'ununat'it chai ixlhiyuchi jantu lai lalhiq'uiclac'a'iyat'it ni jantuch tu'u' lhip'ast'ac'at'it ju ixpumavasalaca ju minchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju lapanacni: ―Ju uxijnan k'asmat'at'it ni ixtanajun ju mak'aniya milacpa'itni'an ni xamati' canavinilh tu'u' talak'alhin ju apumatam pus vana va chunch canavinicalh ju anu' ju alactu'unulh. ");
INSERT INTO teeNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Chunch ju ixnoncan. Para ju quit'in iclajunau ni jantu at'alasat'it ju alactu'unu' va ixlaca'atalh ni amamap'alanip'ut'ut'it. Alai ni xamati' cata'ulaniyan ju lamilakxtan'an pus axt'aknich'ok'ot'it ju mintalakxtantam'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Chai ni xamati' catachivimak'anan chai catatai'iniputunan ju mimpumpu'an pus jantu alhik'a'it'it vachu' ju mincutun'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Chai ni xamati' taropa tap'astu tamac'uc'ayan ju ixtac'uc'at ni alhip'iniya'it'it ixlhimakat tachi ju lhcacanta lacalhamap'aksin pus palai k'ox cava ni palai makat ju alhip'it'it. Palai jantu k'ox cava ni va alhit'alhk'amt'it. ");
INSERT INTO teeNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chai va tichi chavaich ju catasq'uiniyan tu'u' jantiyu' ju jantu alhixt'aknip'ut'ut'it ni va mak'ap'ut'unat'it mi'akstu'an. Chai va tichi chavaich ju catamats'isq'uiniyan tu'u' jantu a'una'it'it ni jantu va ixlacata ni mak'ap'ut'unat'it mi'akstu'an. ");
INSERT INTO teeNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Vachu' k'asmat'at'it ni ixtanajun ju mak'aniya milacpa'itni'an ni amap'ainit'it ju tamapainiyan chai alhit'alaxc'a'it'it ju tanaviyan macxcai. ");
INSERT INTO teeNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Chunch ju ixnoncan. Para ju quit'in iclajunau ni amap'ainit'it ju mint'alaxcai'an chai asq'uint'it ju k'ox is'atsucunti'an ju macxcai tajunan. Chai anavinit'it k'ox ju na taxcayan. Chai at'ap'aininit'it ju Dios ixlacata'an ju talhimakchapuyan. ");
INSERT INTO teeNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chai ni chunch ju a'ulht'ut'it pus anaviya'it'it tachi ju navi ju quimpai'an Dios ju vilhcha lact'iyan. Pus ju yuchi amacamini ju asc'unu' chai ju xcan ju k'ai tajunita chai ju lack'oxin lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Pus ni va yu'unch ju amap'ainiya'it'it ju tamapainiyan pus ja k'oxich ju chunch. Mas yu'unch ju ta'okxchok'omaxtui ju tumin tanavi ju chunch. ");
INSERT INTO teeNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Chai ni va yu'unch ju mi'alak'avin ju at'alaxak'alayat'it pus vana va chunch ju naviyat'it tachi ju tanavi ju lapanacni ju jantuca' tamispai ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Pus sok ats'uc'ut'it ju uxijnan tachi ju quimpaich'an ju vilhcha lact'iyan ni sok navi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju lapanacni: ―Alakts'int'it. Tun t'inavit'it ju tu'u' k'ox la'ix'ucxlacapu'an ju lapanacni va ixlaca'atalh ni na k'oxich catapulhiulayan. Ni chunch ju alat'it pus jantu tu'u' ap'ulha'aya'it'it la'ixmacni ju quimpai'an ju vilhcha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Chai acsni a'akt'ai'uya'it'it ju quilhpatinin jantu chunch a'ulht'ut'it ta yu laich catac'atsaya' tachi chun ju lapanacni. Pus chunch ju talai ju yu'unch ju tanajun ni tanavini ixlhamap'aksin Dios mas jantu. Ju yu'unch taxt'ak'a ju ixtumin'an la'ixpujitat'an chai lacati ni laich catac'atsaya' ju lapanacni chai catanaulh ni lack'oxin lapanacni tajunita. Pus slivasalh ju iclajunau. Ju yu'unch ta'amaklhtayanank'ota ju ixtalhaja'an ju ani lacamunutpa' ni alak'ayacan la'ixmacni ju ixt'alapanacni'an. ");
INSERT INTO teeNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Para ju uxijnan acsni axt'ak'a'it'it ju tu'u' pus va sek axt'akt'it. ");
INSERT INTO teeNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chai ni va sek ju axt'ak'a'it'it pus ju quimpai'an Dios cataxtakniyan ju mintalhaja'an. Pus ju yuchi lakts'in tuchi sek navican. ");
INSERT INTO teeNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Chai acsni t'ach'ivinint'it ju Dios jantu chun ju alat'it tachi ju talai ju yu'unch ju tanajun ni tanavini ixlhamap'aksin Dios mas jantu. Ju yu'unch na k'oxich talhiulai acsni tatayai lacpujitat u lacatalhavat acsni tat'achivinin ju Dios. Vachu' tat'achivinin ju Dios mas lacati ni laich catalakts'ilh ju lapanacni. Para slivasalh ju iclajunau. Ju yu'unch ta'amaklhtayananta ju ixtalhaja'an ju chavai ni na alak'ayacanta. ");
INSERT INTO teeNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Para ju uxijnan acsni t'ach'ivinint'it ju Dios at'anut'it ju laminchaka'an. Chai at'ola'it'it va mi'akstu'an. Chai at'ach'ivinint'it ju quimpai'an Dios ju vachu' vi junta aseknic'a. Chai ju quimpai'an Dios ju lakts'in tuchi navican junta aseknic'a yuchach ju cataxtakniyan ju mintalhaja'an. ");
INSERT INTO teeNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Chai acsni t'onat'it t'achivinin ju Dios jantu na paklhu ana'unt'it ju tijtam chivinti tachi ju talai ju ali'in lapanacni ju jantuca' tamispai ju Dios. Pus ju yu'unch tanajun ni va acsnich ju laich cak'asmatnicalh ni na lhu chivinti catanaulhch. ");
INSERT INTO teeNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pus jantu chun ju anavit'it tachi ju talai ju yu'unch. Pus ju quimpai'an Dios c'atsai tuch'i makt'asq'uiniyat'it mas tuca' sq'uiniyat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pus ju uxijnan chanich anona'it'it acsni at'ach'ivinina'it'it ju Dios: Quimpai ju vilhchi' lact'iyan chach tac'atsa ju lapanacni ni na salaka'at ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chach chilh ju avilhchan acsni alhinona' ju uxint'i. Chach navicalh ju mink'achat ju ani lacat'un tachi ju navicantacha ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Aquilaxtakniuch ju chavai ju vaiti ju icmaktasq'uiniyau. ");
INSERT INTO teeNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Aquilamac'acxaniuch ju quintalak'alhin quinc'an ni vachu' ic'amac'acxanitauch ju quintanavitan tu'u' macxcai. ");
INSERT INTO teeNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jantu aquilalhi'au junta acmapast'ac'anicau tu'u' macxcai. Alai aquilamak'osuniuch ju macxcai. Pus uxint'i ju lhina'un chai uxint'i ju alin ju mintachaput chai uxint'i ju lak'ayac'an tus va tavananch. Slivasalh chunch ju unit'a. Chunch ju anona'it'it acsni at'ach'ivinina'it'it ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju lapanacni: ―Chai ni amac'acxaniya'it'it ju lapanacni ju ix'alactu'unti'an ju tanavinitan pus vachu' catamac'acxaniyan ju uxijnan ju quimpai'an ju vilhcha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Para ni jantu amac'acxaniya'it'it ju lapanacni ju ix'alactu'unti'an pus nin yuchi ju quimpai'an Dios jantu catitamac'acxanin ju mintalak'alhin'an ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Acsni at'asc'a'aya'it'it jantu chun alaya'it'it tachi ju talai ju quint'a'israelitanin'an ju tanajun ni tanavi ju ixlhamap'aksin Dios mas jantu. Pus ju yu'unch tamalacasui ju amak'anit la'ix'ucxpu'an chai tamuc'ai ju lhc'ac'a la'ix'ucxpu'an ni catasulh ni tatascajaich. Pus slivasalh ju iclajunau. Ju yu'unch ta'amaklhtayananta ju ixtalhaja'an ju ani lacamunutpa' ni na alak'ayacan. ");
INSERT INTO teeNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Para ju uxijnan acsni at'asc'a'aya'it'it at'u'uya'it'it ju mi'ai'an chai alakp'uch'ak'aya'it'itch. ");
INSERT INTO teeNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ju chunch jantu catac'atsaya' ju lapanacni ni t'asc'a'ayat'it. Va yuchi ju quimpai'an Dios ju cac'atsaya' ni lakts'in ju yuchi tuchi navican junta aseknic'a. Chai yuchi ju cataxtakniyan ju mintalhaja'an. ");
INSERT INTO teeNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jantu alalhavat'it ju mimak'alit'an ju ani lacat'un junta na alin ju sa'ats'acana' chai junta va cajoksa' chai junta alin ju ak'alhonin ju tak'alhotanui lacachaka'. ");
INSERT INTO teeNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Alai anch ju lact'iyan ju ap'ulhavaya'it'it ju mimak'alit'an va ixlacata ni naviyat'it ju k'ox ju ani lacat'un. Pus ju anch mati' ju sa'ats'acana' cativa chai jantu lai joks ju tu'u' nin cata'alilh ju ak'alhonin ju lai catak'alhotanu. ");
INSERT INTO teeNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Pus chunch ju alat'it ni va tsa tsa pastaccan ju xataxtokni ju lacamunutpa' acsni ani ju mak'acan ju mimak'alit'an. Para ju tamak'ai ju ixmak'alit'an ju lact'iyan pus anchach ju tapastact'ajun. ");
INSERT INTO teeNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Ju milakchulh'an chunch junita tachi ju tu'u' maclhcu ni yuchach ju pu'alac'avanancan. Pus ju milakchulh'an ni na lack'ox pus laich alac'avananat'it. Para ju milakchulh'an ni jantu k'ox pus tachi ju va t'onat'it laca'atats'isni. Pus vana va chun ju mi'atalacpast'ac'at'an. Ni alacp'ast'acnant'it ju k'ox pus laich amach'akxaya'it'it ixchivinti Dios. Para ni asamak'ana'it'it ixchivinti Dios pus jantu k'ox ju mi'atalacpast'ac'at'an chai va ixt'achunch jun ju mi'atsucunti'an tachi ju va t'onat'itca' laca'atats'isni. ");
INSERT INTO teeNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jantu xamati' lai pumat'ui catinavi ix'ucxtin ju vaktam. Pus akts'iya jantu tu'u' calhiulaya' ju pumatam chai na camapainiya' ju apumatam. U ni jantu para akts'iya calhilaksiya' ju pumatam chai ju apumatam lana jantu tu'u' canaviya' cuenta. Pus vana va chun ju uxijnan. Jantu lai at'imap'ainit'it ju Dios chai vachu' ju tumin. ");
INSERT INTO teeNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Iclajunau ni jantu alhamak'aninint'it ixlacata ju mi'atsucunti'an ju tuch'i a'uya'it'it u tuch'i ak'ot'a'it'it nin yuchi ixlacata tuch'i ju amalakch'inina'it'it. Pus palai tu'u' ju mi'atsucunti'an. Palai jantu ju va tu'u' vaiti. Chai palai tu'u' ju milacatuna'an. Palai jantu ju va mimpumpu'an. ");
INSERT INTO teeNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Alakts'int'it ju ts'oknin. Ju yu'unch jantu ta'ach'ananan. Chai jantu taxk'a'i ju catamak'aya' ju xatoc'at. Chai jantu tamak'ai ju ixvaiti'an lacatu'u' pac'atsa. Para ju mimpai'an ju vilhcha lact'iyan yuchi ju amavai. Pus ju Dios palai tu'u' talhiulayan ju uxijnan. Palai jantu ju va tu'u' ts'ok'o. ");
INSERT INTO teeNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Chai jantu xamati' ju milhi'uxijnan ju lai palai putank'ai catijunlh mas na lhu capastaclh. ");
INSERT INTO teeNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Chai tajuch ni na va lhamak'anininat'it ixlacata ju mimalakch'intich'an. Alakts'int'it ta yu tak'ayaich ju xaxanti lacaq'uivin. Ju yu'unch jantu tach'alhcatnan nin cata'asiunilh. ");
INSERT INTO teeNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Para iclajunau nin yuchi ju k'ai ucxtin Salomón mas na mak'ali' ixjunita jantu malakch'inilh tachi ju tu'u' xanti. ");
INSERT INTO teeNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pus ju Dios na c'us malakch'ini ju ach'itin ju alin mas va lacaq'uivin. Chai ju yuchi jantu jonk'alhi. Ju chavai stak'auca'. Para ju lhi calacxavacana'. Pus ja va a ti uxijnan jantu cataxtakniyan ju Dios ju mimpumpu'an. Para ju uxijnan na lacats'unin lhilaksiyat'it ju Dios ni lai cataxtaknin ju tuch'i makt'asq'uiniyat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Pus ni cataxtakniyan ju Dios tuch'i amakt'asq'uiniya'it'it pus jantu alhamak'aninint'it. Jantu ana'unt'it: “Tijuch nu' ju ca'uyau ju chavai”. U “tijuch nu' ju cak'ot'au ju chavai”. U “tijuch nu' ju calakch'iyau ju chavai”. ");
INSERT INTO teeNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Jantu alhamak'aninint'it ju ani taxtokni ni chunch ju talai ju yu'unch ju jantuca' tamispai ju Dios. Para alin ju quimpai'an ju vilhcha lact'iyan chai ju yuchi c'atsai ni makt'asq'uiniyat'it tachi chun ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Para yuchi ju p'ulhnan anavit'it cuenta ta yu palai lai calhinona' ju Dios lami'atsucunti'an. Vachu' yuchi ju anavit'it cuenta ta yu laich soknic'a cava ju mi'atsucunti'an tachi ju k'achani ju Dios. Chai ni chunch ju alat'it pus ju yuchi cataxtakniyan tachi chun ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pus jantu alhamak'aninint'it ju catapasayach ju lhi. Pus chux avilhchan na alin ju ixlhamak'an. Chai jantu lhijun ni na alhamak'aninint'it ju tuchi laich camilh ju alhi. ");
INSERT INTO teeNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju lapanacni: ―Jantu ana'unt'it ni talak'alhin ju xanavi ju ak'antam. Ni chunch ju alat'it pus ju Dios canona' ni vachu' navit'at'it talak'alhin ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Pus tachi ju ulaniyat'it ixtalak'alhin ju ak'antam pus vana va chun ju a'ulanic'ana'it'it ju uxijnan. Chai ju tuch'i anaviniya'it'it ju ak'antam pus vana va chun ju anavic'ana'it'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tajuch ni na naviyat'it cuenta ju tu'u' lacat'icst'i talak'alhin ju navi tam milhilak'au para lana jantu naviyat'it cuenta ju k'ai talak'alhin ju naviyat'it mi'akstu'an. Ni chunch ju layat'it pus ixt'achunch unt'at'it tachi tam lapanac ju cajunilh ak'antam ni tanun ju lacat'icst'i amacxtalh la'ixlakchulh mas tanun ju palai k'ai amacxtalh la'ixlakchulh is'akstu. ");
INSERT INTO teeNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Chai tas laich a'unit'it ju tam milhilak'au: “Alak'a'it'ich ni ac'aktaijuyan ni amacona' ju talak'alhin ju navi”. Tas laich chunch a'unit'it ni jantu naviyat'it cuenta ju k'ai talak'alhin ju naviyat'it ju uxijnan. Pus acsni chunch ju layat'it pus ixt'achunch unt'at'it tachi tam lapanac ju cajunilh ak'antam: “Acmaxtuniyanch ju lacat'icst'i amacxtalh ju tanun lamilakchulh”. Laich chunch juni mas palai k'ai amacxtalh ju tanun la'ixlakchulh is'akstu. ");
INSERT INTO teeNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Para ju uxijnan acsni chunch ju layat'it pus va acxp'ut'iyununat'it. Pus p'ulhnan amac'a'unt'it ju k'ai talak'alhin ju naviyat'it. Chai ju chunch lai a'akt'ai'uya'it'it ju milak'au'an ni camacaulh ju lacat'icst'i talak'alhin ju navi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jantu a'unch'ok'ot'it ju ixchivinti Dios ju lapanacni ju tamispai para va tasamak'anta. Jantu xcai ni catalhitalhk'amalh u catalhits'i'ilh ju ixchivinti Dios. Pus ni a'unch'ok'oya'it'it ixchivinti Dios ju chunch talai pus va ixt'achun tapasai tachi acsni xtaknican ju can ixvaiti'an ju tu'u' xk'oyun chai ju yu'unch catatalhk'amalh chai catats'acayan. U tachi ju tu'u' p'axnin ni axt'akniya'it'it ju tu'u' chiux ju na laklhu ixtapalh para ju yu'unch va taputayalhavanan ni jantu tac'atsai ni laklhu ixtapalh. ");
INSERT INTO teeNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Asq'uinit'it ju Dios chai ju yuchi cataxtakniyan. Ap'uxc'a'ut'it la'ixmacni Dios ju tuch'i makt'asq'uiniyat'it chai alhit'a'uya'it'it. Va tsa tsa asq'uinit'it ju Dios tachi acsni va tsa tsa sacan laca tu'u' malhtich chai ju Dios cataxtakniyan. ");
INSERT INTO teeNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Pus va tichi chavaich ju casq'uiniya' ju Dios ju tu'u' pus caxtaknicana'. Chai va tichi chavaich ju puxcajui tu'u' la'ixmacni Dios calhitajuya'. Chai va tichi chavaich ju va tsa tsa sai ju malhtich pus camalhtek'anicana'. ");
INSERT INTO teeNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Jantu xamati' ju milhi'uxijnan ju lai caxtaknilh tam is'ask'at'a lakatam chiux acsni casq'uinilh ju vati. ");
INSERT INTO teeNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","U ni casq'uinilh ju pamata jantu xamati' milhi'uxijnan ju laich caxtaknilh lakatam lu. ");
INSERT INTO teeNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Pus ju uxijnan mas na k'ai unt'at'it lai xt'akniyat'it ju k'ox ju mi'ask'at'an'an. Pus ja va a ti yuchach ju quimpai'an Dios ju vilhcha lact'iyan jantu cati'axtaknilh ju k'ox ju yu'unch ju tasq'uini. ");
INSERT INTO teeNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Pus ni lac'asq'uinat'it ni k'ox catat'alalhi'an ju lapanacni pus vachu' k'ox at'alalhi'it'it ju yu'unch. Pus chunch ju najun la'ixlhamap'aksin ju Moisés chai chunch ixtanajun ju mak'aniya lapanacni ju ixtanajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Anch ju ap'up'it'it junta va put'icst'i ju ti. Pus junta na pok'ai ti chai junta na ak'ox anchach ju pu'ancan junta jonk'alhita mak'alhk'ajnat. Chai na lhu ju tapu'anch ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Para na put'icst'i chai na axcai ju xati ju pu'ancan ju lact'iyan junta alin ju atsucunti jonk'alhita. Chai na lacats'unin ju tapu'an ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Alhist'acc'ant'it ni jantu cata'okxchok'oyan ju lapanacni ju talacasui tachi ju lapanacni ju tanajun ixchivinti Dios mas jantu. Ju yu'unch tamalacasuniyan tachi ju vasalh lack'oxin lapanacni tajunita. Para la'ix'alhunut'an chunch tajunita tachi ju tu'u' maktilin. Ju yu'unch va talak'alhiniputunan ju mi'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Para la'is'atsucunti'an ap'umisp'aya'it'it tichi chava'itnich ju yu'unch. Pus ju uxijnan c'ats'ayat'it ni jantu toc'ai ju uvas laca'alhtucunan. Nin yuchi ju capen lai catoc'alh lacachatai. ");
INSERT INTO teeNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pus tachi chun ju k'oxi q'uiu caxt'ak'a' ju k'ox xalhi'ut. Chai ju tu'u' q'uiu ju jantu k'ox pus caxt'ak'a' ju lhi'ut ju jantu k'ox. ");
INSERT INTO teeNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pus ju tu'u' k'oxi q'uiu jantu lai catixtaklh ju xalhi'ut ju jantu k'ox. Chai ju tu'u' q'uiu ju jantu k'ox jantu lai catixtaklh ju xalhi'ut ju k'ox. ");
INSERT INTO teeNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pus tachi chun ju q'uiu ju jantu xt'ak'a ju xalhi'ut ju k'ox pus chakxmak'ancan chai lakxavacanch. ");
INSERT INTO teeNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Pus vana va chun ju lami'atsucunti'an. Laich ap'umisp'aya'it'it tichi lapanacnich ju la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Tachi chun ju lapanacni ju quintajuni ni ix'ucxtin icjunita jantu si catatanuyanta ju lact'iyan junta lhinajun ju Dios. Va yu'unch ju catatanuyanta ju tanavini ju ixk'achat ju quimpai ju vilhcha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Pus ju anu' avilhchan acsni camak'osaspitcana' ju lapanacni na lhu chanich aquintajunach: “Qui'ucxtin ju quijnan xac'ajunau ju lapanacni ju minchivinti lamintapaka'ut. Chai lamintapaka'ut icxcoxtuch ju lhacaticuru la'ixlacatuna'an ju lapanacni. Chai lamintapaka'ut na lhu xacnaviyau ju lhamak'an”. Chunch ju aquintajunach. ");
INSERT INTO teeNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Para ju acsnich chani ac'ajunach: “Jantu tavanan xaclamispayau. Ak'ost'it ju laquimacni ju uxijnan ju naviyat'it ju alactu'unti”. ");
INSERT INTO teeNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Va tichi chavaich ju quink'asmatni ju quinchivinti chai canaviya' tachi ju icnajun pus ixt'achunch junita tachi tam lapanac ju na ac'atsananta. Pus ju yuchi na talhman lana ju pucutulh tus lhitajulh ju chiux. Chai la'ix'ucxni ju anu' chiux ju yaulh ju xatantun ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Chai astan lalh ju xcan. Alilh ju akmuxtutu. Chai na p'as lalh ju un. Para jantu ta'aktalh ju anu' chaka' ni la'ix'ucxni chiux ju ixch'antai. ");
INSERT INTO teeNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Para va tichi chavaich ju quink'asmatni ju quinchivinti para jantu canaviya' tachi ju icnajun pus ju yuchi ixt'achunch junita tachi ju apumatam lapanac ju na tonto ixjunita. Pus ju yuchi yaulh ixchaka' lacacucujni. ");
INSERT INTO teeNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Chai astan lalh ju xcan. Alilh ju akmuxtutu. Chai na p'as lalh ju un. Pus ta'aktalh ju anu' chaka' chai lana tak'alhik'o. ");
INSERT INTO teeNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Chai acsni chivink'olhch ju Jesús pus ju lapanacni va talhamak'aninilh ta yu xa'amalanininch. ");
INSERT INTO teeNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ixtalhamak'anininch ni ix'amalaninin tachi ju tam xak'ai. Jantu chun ixlai tachi ju ixta'amalaninin ju na ixtalhatalanininta ju ixlhamap'aksin'an. ");
INSERT INTO teeNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Acsni mincha ju Jesús ju lactalhpa na lhu lapanacni ju tach'ak'ok'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Chai lakmilh pumatam ju ixpacxanta ju macxcai ts'its'i ju ixpuch'i'an. Chai ju yuchi ta'aktsokotanilh ju Jesús chai juni: ―Qui'ucxtin ni va xaq'uinc'uch'up'ut'uch cava pus laich xaq'uinc'uch'ut'i. ");
INSERT INTO teeNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Pus ju acsnich ju Jesús mokslanilh ixmaca' la'ixlacatuna. Chai junich: ―Iclacasq'uinch. Palaich'at ju chavai. Chai acsni naulh ju chunch ju Jesús pus lana vats'alhti lacamacaxnilh ists'its'i ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Chai ju Jesús juni: ―Ak'asmat'ich ju icjunan. Tun xamati' t'i'un tu'u'. Va a'inchich t'alac'asunini' ju pali chai axt'akchich ju milhak'ailakts'in tachi ju ixnajun ju Moisés lacalhamap'aksin. Chai ju chunch ju lapanacni catac'atsaya' ni salaka ju milacatuna. ");
INSERT INTO teeNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Acsni cha'alh ju Jesús ju lak'achak'an Capernaum pus lakmilh pumatam capitán chai sq'uinilh lamapainin. Pus ju anu' capitán jantu israelita ixjunita. Romano ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Chanich ju juni ju Jesús: ―Qui'ucxtin ju quilapanac macha laquinchaka'. Va lacalhtuculunta chai slivasalh na mak'alhk'ajnan. ");
INSERT INTO teeNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Chai ju Jesús juni: ―Ac'anach c'uch'unu'. ");
INSERT INTO teeNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Para ju capitán chani k'alhtailh: ―Qui'ucxtin ju quit'in jantu tu'u' quintapalhni ni laich at'anut'i laquinchaka'. Para mas va anauch ju chivinti chai palaich cajuna' ju quilapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Icc'atsai ni laich chunch catapasalh ni alin vachu' ju quintalhijuni. Chai ju quit'in vachu' alin ju quintaropajni ju ic'alhijuni. Acsni icjuni ju pumatam ni ca'alh pus an. Chai acsni icjuni apumatam ni camilh pus min. Chai ni icjuni ju quilapanac ni canavi tu'u' pus navi. ―Chunch ju junilh ju anu' capitán. ");
INSERT INTO teeNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Chai ju Jesús acsni k'asmatlh ju ixchivinti na lhamak'aninilh. Chai ajuni ju ixtat'a'anta: ―Slivasalh ju iclajunau. Jantu iclhitajuta nin pumatam israelita ju aquilhilaksilh tachi ju quilhilaksi ju ani ya lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Chai iclajunau ni na lhu cataminanta ju ixlhilacaputs'un ju lacamunutpa' ju jantu israelitanin tajunita tachi ju ani ya lapanac. Chai catat'atolach ju Abraham chai ju Isaac chai ju Jacob ju lact'iyan junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Para ju ali'in uxijnan ju ixlhijun ni ixt'anut'it ju lact'iyan junta lhinajun ju Dios jantu lai at'anuya'it'it. Alai amac'ap'inc'ana'it'it laca'atats'isni. Chai ju anch alack'alhununa'it'it chai xvek xvek alacq'uict'a'una'it'it ni na amak'alhk'ajnana'it'it. ―Chunch ju ajuni ju lapanacni ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Astan chani ju juni ju capitán: ―A'inch'ok'ochich laminchaka'. Tachi ju xaq'uilhilaksich ni laich ac'ac'uch'unulh va laquinchivinti pus chunchach ju icnavilh. ―Chunch ju xajuni ju anu' capitán. Chai vasalh lana palaich va ju ixlapanac ju acs pants'iquis. ");
INSERT INTO teeNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ju aktam ju Jesús alh la'ixchaka' ju Pitalu' chai acsni chilh pus lakts'ilh ju ixput'ichako'ulh ju Pitalu' ni ixma la'ixputaman. Na ixch'apata ju iscacat. ");
INSERT INTO teeNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Pus ju Jesús quimacch'apalh chai lana macaulh ju iscacat ju tak'ank'an. Chai ju yuchi k'ostavi chai lana tsuculh alacmavana' ju Jesús chai ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Chai acsni tok'oxa na lhu alhiminicalh ju Jesús ju lapanacni ju ixtanun ju lhacaticuru la'ixtanquilhacni'an. Pus ju Jesús va lakatam chivinti ju ajuni ju lhacaticurulhni chai lana tataxtulh la'ixlacatuna'an ju lapanacni. Vachu' palai anavik'o ju tak'ank'anin ju ix'alhiminicanta. ");
INSERT INTO teeNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chai ni chunch ju navilhch ju Jesús pus uctaxtulh ju chivinti ju ixnajunta ju mak'aniya ixlapanac Dios ju Isaías ixjuncan. Pus ju yuchi ma chani naulh: “Yuchach ju mak'osulh ju quintak'ank'at'an”. ");
INSERT INTO teeNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ju Jesús acsni lakts'ilh ni na lhu lapanacni ixtavilanalh ixtalakachoko junta ixvi ju yuchi pus ajunilh ju ixtamamaka'un ni ca'alact'a'alh lhimak'antacutni atants'in. ");
INSERT INTO teeNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Para acsni tuca' ixta'anta pus lakmilh ju Jesús pumatam ju na ixlhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin chai juni: ―Amamaka'unu' acch'ak'ok'ayanch vanta anchach ju ap'ina'. ");
INSERT INTO teeNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Para ju Jesús junich: ―Ju zorra alin junta tanui. Chai ju ts'ok'o alin junta tatoc'ai. Para ju quit'in mati' ju quinchaka' junta lai ac'astacnalh. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Chai lana xak'ala ju Jesús apumatam ixtamamaka'un. Juncanch ju Jesús: ―Qui'ucxtin yauch aq'ui'un ni act'atolaca' ju quimpai. Ni caniya' ju yuchi pus acmacnuya' chai acsnich ju acch'ak'ok'ayan. ");
INSERT INTO teeNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Para ju Jesús chani k'alhtailh: ―Palai tu'u' aq'uilhiulat'i ju quit'in. Palai jantu ju mimpai. Chai aq'uinch'ak'ok'ach junta ac'uctsuntsucuya'. Chach tamacnu ju mimpai ju ta'amacnunun ju tanita. ");
INSERT INTO teeNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Pus ju acsnich ju Jesús tajulh lacabarco chai ju ixtamamaka'un vachu' tat'ataju. ");
INSERT INTO teeNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Chai acsni ta'alhtanalh lacats'unin pus k'ostaya ju k'ai un chai na p'as tanek'alh ju xcan. Chai na ixquitanui ju lacabarco. Pus ju barco ixqui'akpaxputunch. Para ju Jesús na ilhtatai. ");
INSERT INTO teeNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Pus ju acsnich talak'alh ju ixtamamaka'un chai tamacuju. Tajunich: ―Qui'ucxtin aquilamak'alhtaxtuch ni na muxtuputunauch. ");
INSERT INTO teeNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Para ju Jesús chani ak'alhtailh: ―Tajuch ni va t'alhananat'it. Ju uxijnan na lacats'unin quilalhilaksiyau. Chai acsni nonk'o chunch pus ju Jesús k'ostavi chai k'ailh ju un chai ju xcan. Chai lana sek avanalh chai jantu lucunulh ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Chai ju ixlapanacni lana na talhamak'aninilh. Talaclajuni: ―Tis lapanac nu' ju ani ni lai xataquiclaca'i ju un chai ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Pus ju Jesús chai ix'amamaka'ui tacha'alh ju lhimak'antacutni atants'in junta ixt'un'an ixjunita ju amachak'an Gadara. Chai acsni tatacutcha pus taquipakxtokchilh ixt'iyun'an ju ixtapacxanta ju lhacaticurulhni la'ixlacatuna'an. Ixtamintacha campusantu chai slivasalh lakachapunin ixtajunita. Jantu xamati' lai ixtamapasai ju anu' lacati. ");
INSERT INTO teeNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Chai lana tatsuculh t'asanin. Chai ju lhacaticurulhni na p'as tamachivina ju anu' lapanacni acsni chani tajuni ju Jesús: ―Tijuch ju quilamintau lhilakts'inin ju uxint'i ji Jesús ists'alh'at Dios. Ja va quilamintau mamak'alhk'ajninin mas tuca' chin ju avilhchan. ―Chunch ju tajuni ju anuch lhacaticurulhni ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Pus ju lhi'avinti lacats'unin na lhu ixtayanancha ju p'axnin. Ju yu'unch va ixtat'ajun k'exvenin. ");
INSERT INTO teeNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Pus ju lhacaticurulhni talhitapaininilh ju Jesús. Tajunich: ―Ni aquilatixcoxtuyau la'ixlacatuna'an ju ani tayanalh lapanacni pus aquilalacasq'uiniuch ni ac'anau la'ixlacatuna'an ju p'axnin. ");
INSERT INTO teeNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Chai ju Jesús ajuni: ―Ap'inchit'it. Pus ju anu' lhacaticurulhni tataxtulh la'ixlacatuna'an ju ixt'iyun'an lapanacni chai lana ta'alh tanunin la'ixlacatuna'an ju p'axnin. Chai acsni tatanu la'ixlacatuna'an ju p'axnin pus ju p'axnin ta'ats'alalh. Tin ta'alh junta vac anta. Tatajucha laca'atants'in chai tanitajuk'o lacxcan. ");
INSERT INTO teeNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Pus ju yu'unch ju ixtalhist'ac'a ju p'axnin na tatalhanalh chai ta'ats'alalh. Ta'alh ju lak'achak'an chai taquinonk'o chux tuchi ixtapasata la'is'atsucunti'an ju anu' lapanacni ju ixtapacxanta ju lhacaticurulhni. ");
INSERT INTO teeNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pus ju acsnich chux ju lapanacni amachak'an anch tataxtulh. Talakmilh ju Jesús. Chai acsni talakchilh tatapaininilh ni cataxtulh ju la'ixt'un'an. ");
INSERT INTO teeNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ju Jesús tanuchokolh lacabarco chai anchokolh lhimak'antacutni atants'in. Chai chinchokolh la'ixt'un. ");
INSERT INTO teeNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Chai lhicha'anicalh pumatam lapanac ju va ixlacalhtuculunta. Pulhicha'ancalh ju lona. Chai ju Jesús acsni alakts'ilh ni na ixtalhilaksi ju yuchi ju anuch lapanacni pus chani juni ju tak'ank'an: ―Jantu at'alhan ji quints'alh. Ju mi'alactu'unti mac'acxanicanta. ");
INSERT INTO teeNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Para ju ali'in ju ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin tak'asmatlh ixchivinti ju Jesús chai tanaulh la'ix'alhunut'an ni ma na macxcai chivinti xanajun ju Jesús ni ma tachi Dios ixjumputun. ");
INSERT INTO teeNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Para ju Jesús c'atsa tuchi ixtapast'ac'a chai chani ajuni: ―Tajuch ni va chunch ju p'ast'ac'at'it lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ni va acjunilh ni mac'acxanicalh ju ix'alactu'unti pus jantu lai p'uc'ats'ayat'it ni vasalh alin ju quintachaput u jantu. Para ni acjunilh ni cak'ostavi chai ca'alhtanalh pus ju chunch lai ap'uc'ats'aya'it'it ni alin ju quintachaput u jantu. ");
INSERT INTO teeNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Pus ju chavai aclamasuniyau ni vasalh alin ju quintachaput ju ani lacamunutpa' ni lai icmac'acxai ju alactu'unti. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Pus ju acsnich ju Jesús chani juni ju tak'ank'an: ―Ak'ost'a'ulh. Asact'ich ju mimputaman chai a'inchich laminchaka'. ");
INSERT INTO teeNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Pus ju acsnich ju anu' tak'ank'an ixjunita taya. Alh la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Chai ju lapanacni acsni talakts'ilh na tatalhanalh chai talak'ayalh ju Dios ni xtaknilh ju chunch tachaput ju Jesús ni laich ca'a'aktaijuya' ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Chai ju Jesús taxtulh ju anch chai acsni ix'anta ju lacati pus lakts'ilh pumatam ach'ini' ju ixvi junta amapalanancan. Ju yuchi Mateo ixjuncan. Chai ju Jesús chani juni: ―Aq'uinch'ak'ok'ach. Pus ju Mateo lana taya chai ch'ak'ok'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Pus ju aktam ju Jesús ixt'ajun vena' la'ixchaka' ju Mateo. Chai na lhu tacha'alh ju ach'inin chai vachu' ju ali'in alactu'unin. Chai k'aixtam tat'atavi ju Jesús lacamixa. Chaich ju ix'amamaka'ui vachu' anch ixtavilanalh. ");
INSERT INTO teeNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Para ju fariseonin acsni talakts'ilh ni anch ixvi ju Jesús chanich tajuni ju ix'alacmamaka'ui ju Jesús: ―Ju mi'amamaka'unu'an tajuch ni va k'aixtam alact'avajin ju ach'inin chai ju alactu'unin. ");
INSERT INTO teeNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Para ju Jesús acsni k'asmatlh ju ixchivinti'an chani alacjuni: ―Ju k'ox tat'ajun jantu tamaktasq'uini ju ac'uch'unu'. Va yu'unch ju talactak'ank'ai ju tamaktasq'uini ju ac'uch'unu'. ");
INSERT INTO teeNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Alanichit'it tuchi ju nomputun ju chivinti ju ts'okcanta la'ixchivinti Dios junta chani najun: “Ju quit'in iclacasq'uin ni a'akt'ai'uyat'it laca'amapaininti ju mint'alapanacni'an. Jantu va yuchi ni aquilalhik'ailakts'inau ju tu'u' atapacxat”. Chunch ju najun la'ixchivinti Dios chai chun ju icnavi. Pus ju quit'in jantiyu' iclhiminta ni ac'alact'asanilh ju lapanacni ju tanajun ni na soknic'a ju is'atsucunti'an. Alai icminta alact'asanini' ju alactu'unin ni catamacaulh ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ju acsnich ju ix'amamaka'ui ju Xivan talakmilh ju Jesús chai tasacmi: ―Ju quijnan chai ju fariseonin na paklhu ju ictascajayau. Para ju mintamamaka'un jantu tatascajai. Tajuch. ");
INSERT INTO teeNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ju acsnich ju Jesús chani ajuni: ―Ja laich cata'amak'aninilh ju tamak'anta junta alin ju tamak'axt'ok'at acsni makvilhca' ju anu' ts'alh ju catamak'axt'ok'a'. Pus vana va chunch ju quintamamaka'un. Jantu tatascajai ni ic'alact'avilhca'. Para cachina' avilhchan acsni acmak'osucana' ju ani lacamunutpa'. Chai acsnich ju catatascajaya' ni na aquintalhamak'anininach. ");
INSERT INTO teeNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jantu xamati' lai lhalakyavanan ju pumpu' ju jantu amakpanti chai lai va chunch camuc'alh ju lacak'at'ili pumpu'. Ni chunch calacalh pus va palai makat cak'exlh acsni talakatumi ju sast'i pumpu'. ");
INSERT INTO teeNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chai nin yuchi ni lai acpumuju ju sast'i vino lacak'at'ili axt'ak'an ni na k'alhp'asnica'. Ni chunch ju canavicalh pus va cak'exlh ju axt'ak'an chai ju vino capu'ank'olh. Chai ju axt'ak'an cats'ank'alh. Alai pumucan ju sast'i vino lacasast'i axt'ak'an. Ju chunch laich pumak'acan ju vino ju axt'ak'an. Chunch ju ajuni ju lapanacni ju Jesús. Va ix'amamachakxaniputun ni jantu lai catilhiyaulh ju mak'aniya ixlhamap'aksin ju Moisés ju sast'i ixlhamap'aksin ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Acsni ixt'ajun ajunini' ju lapanacni ju ani chivinti pus lakchilh pumatam xak'ai sia yu'unch ju ixtach'alhcatnan la'ixpujitat'an ju israelitanin. Chai ju yuchi ta'aktsokotanilh ju Jesús chai juni: ―Ju quintsi' va pants'iquisca' xani. Para ca'auch chai amokslanit'achi' ju mimaca' la'ixlacatuna chai catsucuchokoya'. ");
INSERT INTO teeNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Pus ju Jesús lacataya chai t'a'alh. Vachu' tat'a'alh ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Chai acsni ixta'anta ju lacati pus chincha pumatam chako'ulh la'ixlhipulacan ju Jesús. Chai ju yuchi va tachi ix'alinta ixtak'ank'at. Lakacaut'ui c'ata ixpacxanta ju anu' tak'ank'at. Pus ju yuchi lakcha'anilh ju ixquilhtu' ixpumpu' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Chunch ju lalh ni ixnajun la'ix'alhunut ni mas va yuchi ni calakcha'anilh lacats'unin ju ixpumpu' ju Jesús pus palai cajuna'. ");
INSERT INTO teeNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Chai ju Jesús talakasp'itlh. Lakts'ilh chai juni: ―Quintsi' jantu at'alhan. Ni xaquilhilaksi pus yuchi palai xalhi'un. Pus ju anu' chako'ulh palai va ju anu' pants'iquis. ");
INSERT INTO teeNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Pus ju Jesús acsni cha'alh la'ixchaka' ju anu' xak'ai pus alakts'ilh ju asanin chai ju lapanacni ni na ixtalack'alhun. ");
INSERT INTO teeNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Chai ajuni: ―Ap'inchit'it ju uxijnan. Ju atsi' jantu nita. Va lhtatai. ―Chunch ju ajuni. Para ju lapanacni va talhits'i'ilh. ");
INSERT INTO teeNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Para ju Jesús acsni alacxcoxtuk'o ju lapanacni pus tanulh chai macch'apalh ju anu' atsi' chai ju yuchi lana k'ostavi. ");
INSERT INTO teeNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Pus lana lacc'atsak'ocalh tachi ixlhilacaputs'un ju lacat'un ju vanin vi ju anu' lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Chai acsni taxtuchokolh ju Jesús ju anch pus tach'ak'ok'alh ixt'iyun'an alak'ach'ixnin. P'as ixtachivinin. Ixtalact'asai. Va tsa tsa ixtajuni ju Jesús: ―Aquila'aktaijuch ji ists'alh ju k'ai ucxtin David. ");
INSERT INTO teeNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Pus acsni chinchalh ju Jesús la'ixchaka' pus vachu' tacha'alh ju alak'ach'ixnin. Chai ju Jesús chani ajuni: ―Ja lac'a'iyat'it ni laich aclamalac'avaniu ju uxijnan. Chai ju yu'unch tak'alhtayanalh. Tajuni: ―Iclaca'iyau ji ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Pus ju acsnich ju Jesús ach'apanilh ixlakchulh'an ju anu' alak'ach'ixnin chai ajuni: ―Ni xaquilalhilaksiyau ju quit'in pus chunchach ju aclanaviniyau. ");
INSERT INTO teeNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Chai lana ta'alac'avanalh. Para ju Jesús slivasalh alhimap'aksi. Chai ajuni: ―Alakts'int'it. Tun xamati' a'unit'it tuch'i xat'ap'asayat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Para ju yu'unch acsni tataxtuchalh lana talacquilhuntsuculh tachi ixlhilacaputs'un ju anu' lacat'un tuchi ixtapasata la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Chai acsni tataxtulh ju yu'unch pus lana lhicha'anipalacalh pumatam lapanac ju va nunu' ixjunita ni ixtanun ju lhacaticuru la'ixlacatuna. ");
INSERT INTO teeNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Para acsni xcoxtulh ju Jesús ju lhacaticuru pus ju anu' nunu' chivinilh. Chai ju lapanacni slivasalh na talhamak'aninilh. Ixtanajun: ―Jantu tavanan lakts'incanta tu'u' ju chunch ju ani laquilacat'un'an. ");
INSERT INTO teeNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Para ju fariseonin chani ixtanajun: ―Ju ani ya lapanac xcoxtui ju lhacaticuru la'ixlacatuna'an ju lapanacni la'ixtachaput ju xak'ai lhacaticuru. ");
INSERT INTO teeNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pus ju Jesús talacaputoc'alh tachi chun ju k'ai lak'achak'anixni chai tachi chun ju lact'icst'i lak'achak'anixni. Ix'amalanininch la'ixlacpujitat'an ju yu'unch. Ix'ajuni ju lapanacni ni lhinomputun ju Dios la'is'atsucunti'an. Vachu' palai anavi ju lapanacni mas va tuchi tak'ank'at ju ixtapacxanta. ");
INSERT INTO teeNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Para acsni alakts'ilh ju lapanacni slivasalh na amapaini ni jantu xamati' ix'amasuni ju soknic'a ti. Chunch ixtajunita tachi ju tu'u' borregojni ju va mati' ix'alhistacna'an. ");
INSERT INTO teeNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Pus ju acsnich ju Jesús chani ajuni ju ix'amamaka'ui: ―Slivasalh na lhu ju xatoc'at ju ach'ananti chai na c'atata para na lacats'unin ju ch'alhcatnin. ");
INSERT INTO teeNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pus yuchi alhit'ap'aininit'it ju xa'ucxtin ju lhich'alhcat ni camacamilh ali' ju ch'alhcatnin la'ixlhich'alhcat. Ju Jesús chunch ajuni ju ix'amamaka'ui ni va ix'amamachakxaniputun ni na lhu alin ju lapanacni ju laich ca'amalaca'inicalh ixchivinti Dios para na lacats'unin ju ta'amalaninimputun. ");
INSERT INTO teeNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ju acsnich ju Jesús at'asanilh ju ixpumacaut'ui'an ix'amamaka'ui chai axtaknilh ixtachaput'an ni laich cataxcoxtuniya' ju lhacaticurulhni la'ixlacatuna'an ju lapanacni chai ni laich palai catanavi ju lapanacni ju ixtach'apata tachi chun ju tak'ank'at. ");
INSERT INTO teeNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Chani ix'ajuncan ju ixpumacaut'ui'an ixtamalakachan ju Jesús. P'ulhnan yuchi ju Simón ju vachu' juncan Pitalu'. Chai ixlak'au ju Tilix ixjuncan. Chai ju Jacobo chai ju Xivan. Pus ju Xivan isp'isek'e ixjunita ju Jacobo chai ju yu'unch ists'alan Zebedeo ixtajunita. ");
INSERT INTO teeNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Chai ju Pilipe chai ju Bartolomé chai ju Tumax chai ju Mateo ju ach'ini' ixjunita. Chai apumatam Jacobo ju ists'alh Alfeo ixjunita. Chai ju Lebeo ju vachu' Tadeo ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Chai apumatam Simón ju makyu'unch ixjunita ju cananistanin. Chai ju Judas Iscariote. Yuchi ju tucan mak'axtaklh ju Jesús astan. ");
INSERT INTO teeNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Pus ju Jesús amalakacha ju ani ixpumacaut'ui'an chai chani alhimap'aksi: ―Jantu ap'it'it junta tavilanancha ju yu'unch ju jantu quint'a'israelitanin tajunita. Nin yuchi ni ap'it'it la'ixlak'achak'an'an ju samaritanonin. ");
INSERT INTO teeNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Alai anchach ju ap'it'it junta tavilanancha ju quint'a'israelitanin. Ju yu'unch chunch tajunita tachi ju tu'u' borregojni ju va tats'ank'atach. ");
INSERT INTO teeNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Chai vanta anchach ju ach'ip'ina'it'it a'una'it'it ju lapanacni ni vaninch minta ju avilhchan acsni calhinona' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Palaich anavit'it ju tapacxanta ju macxcai ts'its'i ju va puch'i'an. Chai palaich anavit'it ju tapacxanta ju tu'u' atumpa tak'ank'at. Amalok'onit'it ju va tanita. Chai axc'oxt'ut'it ju lhacaticuru la'ixlacatuna'an ju lapanacni. Ju uxijnan jantu va xatamoyat'it ju ani tachaput. Pus vana va chun jantu ach'inint'it acsni a'akt'ai'uya'it'it ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Jantu alhip'it'it tu'u' tumin lamimpuxa'an. ");
INSERT INTO teeNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nin yuchi ni alhip'it'it ju mimpasti'an ixlacata ju lacati. Nin yuchi ni alhip'it'it k'alht'ui ju mimpumpu'an nin lakat'ui ju minch'anxt'ak'an'an. Nin tu'u' mimpalic'an. Pus tachi ju lapanacni ju tamakch'alhcatnan ni anch ju tasuk'ojui ju ixvaiti'an pus vana va chun ju uxijnan. Lhijunch ni catamavayan ju lapanacni ju a'una'it'it ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Chai vanta anchach ju at'anuya'it'it u lacak'ai lak'achak'an u lacalacat'icst'i lak'achak'an ap'uxc'a'ut'it pumatam ju na k'ox lapanac lhiulacan. Chai anchach la'ixchaka' ju at'ola'it'it tus acsni at'axt'uch'ok'oya'it'it ju anu' lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Chai acsni at'anuya'it'it ju anch junta at'ola'it'it pus amac'amit'it ju tatanumanalh anch. Chai a'una'it'it ni Dios ju ca'axtakniya' ju k'ox is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Chai ju yu'unch ju tatanumanalh anch ni k'oxich cata'amaklhtayananan pus ju Dios vasalh ca'axtakniya' ju k'ox is'atsucunti'an tachi ju sq'uint'it. Para ni jantu k'ox cata'amaklhtayananan pus ju Dios jantu cati'axtaknilh ju k'ox is'atsucunti'an tachi ju sq'uint'it. ");
INSERT INTO teeNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Chai ju amachak'an ju anu' chaka' u ju anu' lak'achak'an ni lana jantu ta'amaklhtayanamputunan nin catak'asmatniputunan pus acsni at'axt'uya'it'it ju anch ach'anc'alhap'uxc'ant'itch ju pokxni laminch'anxt'ak'an'an ni catac'atsaya' ni jantu k'ox tachi ju xatalai. ");
INSERT INTO teeNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Slivasalh iclajunau. Acsni cachinach ju avilhchan acsni camak'osaspitcana' ju lapanacni palai macxcai ca'alina' ju ixmak'alhk'ajnat'an ju amachak'an ju anu' lak'achak'an. Palai jantu ju amachak'an ju mak'aniya lak'achak'anixni Sodoma chai Gomorra. ");
INSERT INTO teeNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Pus iclamalakachayau tachi ju tu'u' borregojni junta na alin ju maktilin. Ac'ats'anant'it. Chai salaka ats'uc'ut'it. ");
INSERT INTO teeNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Alhist'acc'ant'it la'ixmacni'an ju lapanacni. Pus ju yu'unch catalhi'anan lacapu'ucxtin. Chai catalakanekmayan la'ixpujitat'an ju mint'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chai alhip'inc'ana'it'it la'ix'ucxlacapu'an ju gobernadornin chai ju xak'ai tucan junita va ixlaca'atalh ni quilat'a'alhtananau ju quit'in. Para ju chunch laich a'una'it'it ju quilacata ju xalack'ajin chai ju yu'unch ju jantu quint'a'israelitanin tajunita. ");
INSERT INTO teeNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Para acsni amak'axt'akc'ana'it'it la'ixmaca'an ju xalack'ajin tun t'i'amak'aninint'it ni jantu c'ats'ayat'it tuch'i anona'it'it nin ta yu alhak'alht'ayanana'it'it. Jantu alhamak'aninint'it ni Dios ju cataxtakniyan ju acs pants'iquis ju tuch'i anona'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Pus jantu uxijnan ju ach'ivina'it'it. Alai yuchi ju iSpiritu Santu ju quimpai'an Dios ju cataxtakniyan ju chivinti ju anona'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Na lhu ca'alina' ju laxcaiti ju va quilacata. Ju ixlak'au ju tam xamati' laich calhimak'axt'ak'a' la'ix'aninti. Ju xapai tam xamati' laich calhimak'axt'ak'a' ju is'ask'at'a la'ix'aninti. Chai ju sa'ask'at'an laich catat'alasaya' mas ixpaich'an chai catat'alalhinona' ixmaknica'an. ");
INSERT INTO teeNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Chai tachi chun ju lapanacni cataxcayan va ixlaca'atalh ni quilach'ak'ok'ayau. Para va tichi chavaich ju cach'ixach ju mak'alhk'ajnat tus catapasaya' pus ju yuchi camak'alhtaxtucana'. ");
INSERT INTO teeNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Chai acsni axc'aic'ana'it'it ju lakatam lak'achak'an pus ap'it'it ju alacatam. Pus slivasalh ju iclajunau. Jantu at'ilhilac'ap'ut'oc'ak'ot'it tachi chun ju ixlak'achak'an'an ju quint'a'israelitanin'an acsni acminchokoya' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ju amamaka'ucanta jantiyu' ju xalack'ajin. Alai yuchi ju xak'ai ju amamaka'unu'. Chai ju xalapanac jantiyu' ju xak'ai. Alai yuchi ju xak'ai ju ix'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Pus lhijunch ni vana va chunch ca'a'ulhtucana' ju xa'amamaka'unin tachi ju ulhtucalh ju ix'amamaka'unu'an. Chai lhijunch ni vana va chun ca'a'ulhtucana' ju xalapanacni tachi ju ulhtucalh ju ix'ucxtin'an. Pus ju quit'in mi'ucxtin'an icjunita. Chai ju lapanacni ni quintajuni ni icpuch'alhcatnan ixtachaput ju lhacaticuru pus ja va a ti uxijnan jantu vana va chun a'unc'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju ixtamamaka'un: ―Chai ni c'ats'ayat'it ni chunch ju a'ulht'uc'ana'it'it pus yuchi iclalhijunau ni jantu at'alhonit'it ju mint'alapanacni'an. Ac'ats'at'it ni jantu tu'u' ju va sek navicanta ju jantu catasuya'. Chai jantu tu'u' ju lai matank'anucan ju jantu cac'atsak'ocana'. ");
INSERT INTO teeNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pus ju tuchi iclajunau acsni va qui'akstu'an vilau pus yuchach ju a'unit'it ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jantu at'alhonit'it ju mint'alapanacni'an ju lai catamaknin para astan jantu lai tu'u' ali' catanaviyan. Alai yuchi ju at'alhonit'it ju Dios ni yuchach ju lai maca'an ju milacatuna'an chai ju mintacuvin'an ju lacajipi. ");
INSERT INTO teeNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jantu tasq'uini ni at'alhonit'it ju tam mint'alapanac'an. Alakts'int'it ju lacat'icst'i ts'ok'o ni lhist'acan ju lakat'ui ts'ok'o lakatam sentau. Pus mas va chunch ixtapalh ju yu'unch para jantu lai catipataju lakatam ju yu'unch ju lacat'un ni jantu calacasq'uina' ju mimpai'an Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Chai mas va mi'ai'an ju uxijnan si put'ek'ek'ocanta. ");
INSERT INTO teeNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Pus yuchi iclalhijunau ni jantu at'alhanant'it. Pus palai laklhu ju mintapalhni'an ju uxijnan. Palai jantu ju va tu'u' ts'ok'o mas na lhuch catava ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Va tichi chavaich ju canona' la'ix'ucxlacapu'an ju lapanacni ni quinch'ak'ok'ai pus vachu' acnona' la'ix'ucxlacapu' ju quimpai ju vilhcha lact'iyan ni quilapanac junita. ");
INSERT INTO teeNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Para va tichi chavaich ju canona' la'ix'ucxlacapu'an ju lapanacni ni jantu quilhilaksich pus vachu' quit'in acnona' la'ix'ucxlacapu' quimpai ju vilhcha lact'iyan ni jantu quilapanac junita. ");
INSERT INTO teeNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jantu ana'unt'it ni va icminta navini' ju ak'oxamixnit ju ani lacat'un. Jantu va icminta lak'oxini' ju lacamunutpa'. Alai va ixlaca'atalh ni icminta ca'alina' ju lak'aiti. Caxcaicana' ju yu'unch ju quintalhilaksi. ");
INSERT INTO teeNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Pus va ixlaca'atalh ni icminta ju tam lapanac cat'alaxcaya' ju ixpai. Chai ju tam atsi' cat'alaxcaya' ju ixnati. Chai ju tam xaput'i cat'alaxcaya' ju ixput'ichako'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ju tatanumanalh la'ixchaka'an ju quilapanacni yu'unch ju ixt'alaxcai'an catajuna'. ");
INSERT INTO teeNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Pus ju palai camapaini ixpai u ixnati palai jantu ju quit'in pus jantu lhijun ni quilapanac cava. Chai ju palai camapaini tam ists'alh u tam istsi' palai jantu ju quit'in pus jantu lhijun ni quilapanac cava. ");
INSERT INTO teeNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chai va tichi chavaich ju jantu quinch'ak'ok'aputun va ixlaca'atalh ni va lai mamak'alhk'ajnicalh pus jantu lhijun ni quilapanac cava. ");
INSERT INTO teeNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Chai va tichi chavaich ju najun ni jantu quinch'ak'ok'aputun va ixlaca'atalh ni jantu lacasq'uin ni camaknicalh pus ju yuchi camak'ats'ank'aya' ju sa'atsucunti ju lact'iyan. Para va tichi chavaich ju camak'ats'ank'aya' ju is'atsucunti va ixlaca'atalh ni quinch'ak'ok'ai ju quit'in pus ca'alina' is'atsucunti ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Pus ju cata'amaklhtayananan ju uxijnan pus tachi ju va jun quit'in ju qui'amaklhtayanan. Chai ju qui'amaklhtayanan pus tachi ju va jun Dios ju amaklhtayanan. Yuchi ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Pus va tichi chavaich ju ca'amaklhtayananach tam xamati' ju najun quinchivinti va ixlaca'atalh ni quilapanac junita pus vachu' ca'amaklhtayanana' tuchi caxtaknicananta ju quilapanac ju lact'iyan. Chai va tichi chavaich ju ca'amaklhtayananach tam xamati' ju soknic'a is'atsucunti va ixlaca'atalh ni soknic'a ju is'atsucunti pus vachu' ca'amaklhtayanana' tuchi caxtaknicananta ju lact'iyan ju lapanac ju soknic'a is'atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Chai slivasalh ju iclajunau. Vachu' caxtaknicananta ju lact'iyan ju ixtalhaja va tichi chavaich ju caxtakniya' mas va tam vaso ju ts'uc'unc'u xcan ju quinch'ak'ok'ai. Caxtaknicananta va ixlaca'atalh ni k'eu xalakts'in mas jantu tu'u' ixlhiulacan la'ixmacni'an ju ali'in ixt'alapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ju Jesús acsni amap'aksik'o ju ixpumacaut'ui'an ix'amamaka'ui pus taxtulh ju anch. Alh amalanini' ju lapanacni. Chai alh nona' ni lhinomputun ju Dios la'is'atsucunti'an. Ix'alhtanat'ajun tachi chun ju lak'achak'anixni ju vanin ixtavilanalh. ");
INSERT INTO teeNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Pus ju Xivan ixt'alhnucanta para c'atsa tuchi ixnavich ju Cristo. Chai amalakachanilh ju Jesús ixt'iyun'an ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ajunich ni catasacmi ju Jesús ni ma yuchach cava ju Cristo ju ixnoncan camalakachatachilh ju Dios u ma tasq'uini ni catipacxanchokolh apumatam. ");
INSERT INTO teeNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Pus acsni tacha'alh chai tasacmi pus ju Jesús chani ak'alhtayanalh: ―A'inch'ok'ochit'it. Amac'ats'anichit'it ju Xivan tuch'i xalakts'inat'it chai tuch'i xak'asmat'at'it. ");
INSERT INTO teeNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","A'unit'it ni lai ta'alac'avanan ju alak'ach'ixnin ixtajunita. Chai laich ta'alhtanan ju ixtalacch'antak'alhita. Chai talaclacamacaxlich ju ixtapacxanta ju macxcai ts'its'i ju puch'i'an. Chai laich tak'asmat'a ju va k'atapa ixtajunita. Chai ju ixtanita malok'onichokocalh. Chai ju quilhpatinin ajunicalh ta yu laich cataputak'alhtaxtulh. ");
INSERT INTO teeNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Vachu' a'unit'it ni na k'achan ju tam lapanac ju jantu astan najun ni jantu quinch'ak'ok'aputun. ―Chunch ju ajunicalh ju ix'amamaka'ui ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Chai acsni ta'anchokolh ju yu'unch pus ju Jesús lana tsuculh alacsacmini' ju lapanacni ixlacata ju Xivan. Chani ajuni: ―Acsni q'uilakts'int'it ju Xivan ju lacamacni tis chavaich ju ixlakts'imp'ut'unat'it. C'ats'ayat'it ni jantiyu' ju lhiq'uilat'it ju anch ni va alakts'imp'ut'ut'it tam lapanac ju va tam tam najun tachi ju lai ju tu'u' xaxk'oi actiyac acsni lacatam lacatam sun lhi'an ju un. ");
INSERT INTO teeNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Pus tis chavaich ju ixlakts'imp'ut'unat'it. C'ats'ayat'it ni jantiyu' ju lhiq'uilat'it ju anch ni va alakts'imp'ut'ut'it tam lapanac ju na va k'ox camalakch'inilh. Jantiyu' ju lhiq'uilat'it ju anch ni va la'ixchaka'an ju xalack'ajin ucxtinin tavilanancha ju na k'ox tamalakch'ininta. ");
INSERT INTO teeNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pus tis chavaich ju ixlakts'imp'ut'unat'it. C'ats'ayat'it ni va ixlakts'imp'ut'unat'it ju lapanac ju najun ixchivinti Dios. Chai vasalh chunch junita ju Xivan. Para palai k'ai lhich'alhcat ju xtaknicanta ju yuchi. Palai jantu va tichi lapanac ju najun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Pus yuchi ju Xivan ju ispastaccan acsni chani ju ts'ok'ulacalh la'ixchivinti Dios: Acmalakachaya' ju quilapanac ju p'ulhnan ca'ana'. Astan ju uxint'i. Chai yuchach ju ca'alak'oxiniya' ju ix'alhunut'an ju lapanacni ni cata'amaklhtayananan acsni ach'ip'ina'. Chunch ju ts'okcanta la'ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Slivasalh ju iclajunau. Tus chavai jantu tavanan alinta tam xamati' ju palai k'ai cava. Va yuchi ju Xivan ju amakpaxana'. Para va tichi chavaich ju palai jantu tu'u' lhiulacan la'ixmacni ixt'alapanacni sia yu'unch ju quintalhilaksi yuchach ju palai k'ai cajuna' ju lact'iyan junta lhinajun ju Dios. Palai jantu chun junita ju Xivan ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tus acsni tsuculh amalanini' ju Xivan tus chavai pus ju lapanacni slivasalh la'ixlhichux ix'alhunut'an ta'amputun ju lact'iyan junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pus acsni tuca' ixmin ju Xivan pus ju Moisés chai ju ali'in mak'aniya ixlapanacni Dios si tanonk'o ni ma calhinona' ju Dios ju ani lacamunutpa'. Chai acsni milh ju Xivan pus tsuculh uctaxtunu' ju ixchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Chai ni va c'ats'ap'ut'unat'it ixlacata ju Elías ju ixnoncan ni camina' pus yuchach ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Pus ju alin ixpak'asmatni cak'asmatlich ju iclajunau. ");
INSERT INTO teeNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ju uxijnan ju chavai t'onat'it ca laich acnaulh ni ixt'achunch unt'at'it tachi ju ask'at'an ju tak'amanan laclhitamau. Chai ju quilhmactam chani talajuni ju aquilhmactam: ");
INSERT INTO teeNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Ju quijnan xacsk'olau para ju uxijnan jantu xa'at'ininat'it. Chai icmilhpauch ju amak'anit para sin chunch jantu xak'ach'aniyat'it ni jantu xalack'alhunat'it”. ");
INSERT INTO teeNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Laich acnaulh ni vana va chunch unt'at'it ju uxijnan ni vachu' jantu tu'u' k'ox lhiulayat'it. Ju uxijnan ixnonat'it ni va ixpacxanta lhacaticuru ju Xivan ni va is'akstu ju ix'ucxunt'ajun chai jantu ix'alact'avemputun ju lapanacni chai jantu ixk'otputun ju vino. ");
INSERT INTO teeNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Chai astan icmilh ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Chai ju uxijnan nonat'it ni va chavani lapanac icjunita chai ic'ak'otnu lapanac chai ix'amigo'an icjunita ju ach'inin chai ju ali'in alactu'unin. Chunch ju nonat'it ni ic'alact'a'ucxunt'ajun ju lapanacni chai ic'alact'avajin chai ick'ot'a ju vino. Para ni alin ju lapanacni ju talaca'inilh ixchivinti ju Xivan chai quintalaca'inilh ju quinchivinti pus putasui ni slivasalh na ac'atsananta ju Dios ni chunch ju xaquintalhilhcayan ju laqui'atsucunti quinc'an. ");
INSERT INTO teeNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Pus ju acsnich ju Jesús tsuculh alak'ak'aimana' ju amachak'an ju lak'achak'anixni junta palai lhu ixnavita ju lhamak'an. Alak'ak'aima ni jantu tavanan ixtamacomputun ix'alactu'unti'an. Pus chani ajuni: ");
INSERT INTO teeNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","―Paini'itnich unt'at'it ju uxijnan ji amachak'an Corazín. Paini'itnich unt'at'it ju uxijnan ji amachak'an Betsaida. Pus ni ca'ix'anavinicancha ju amachak'an Tiro chai ju amachak'an Sidón ju lhamak'an ju malac'asunic'ant'at'it ju uxijnan pus mak'anchich ixtamacaulh ix'alactu'unti'an ju yu'unch. Chai ixtalakch'ilh ixlacpumpu'an ju na ts'iti chai ixtatavi lacalhc'ac'a ni cac'atsacalh ni vasalh na ixtamacomputun ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pus ixlhiyuchach acsni camuc'anicana' ju ixtalak'alhin'an ju lapanacni pus ju amachak'an Tiro chai ju amachak'an Sidón palai jantu lhu ca'alina' ju ixmak'alhk'ajnat'an. Palai lhu ju amamak'alhk'ajnic'ana'it'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Chai ju uxijnan ji quint'a'amachak'an ju lak'achak'an Capernaum na va tak'ayayat'it. Para amamaxanic'ana'it'it. Pus ni ca'ixnavicancha ju lak'achak'an Sodoma ju lhamak'an ju masunic'ant'at'it ju uxijnan ca'ix'alink'alhilhch tus chavai. ");
INSERT INTO teeNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Chai iclajunau ni palai jantu lhu ca'alina' ju ixmak'alhk'ajnat'an ju amachak'an Sodoma acsni camuc'anicana' ju ixtalak'alhin'an ju lapanacni. Palai lhu ca'alina' ju mimak'alhk'ajnat'an ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Pus ju acsnich ju Jesús chani naulh: ―Ju uxint'i ji quimpai xa'ucxtin'at ju lact'iyan chai ju lacat'un. Pus icjunan lak'ailakts'iuch ni jantu amavasalanit'a ju ani taxtokni ju na talhilaksi ix'atalaninti'an chai ixtac'atsan'an is'akstu'an. Alai amavasalanit'a ju yu'unch ju talhilaksiyan tachi ju lai tam ask'at'a acsni lhilaksi ix'amamaka'unu' ni yuchi ju camalaniya' tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Pus chunchach ji quimpai. Chunchach ju k'ox xalhiulai ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Chai ju acsnich ju Jesús chani ajuni ju lapanacni: ―Ju quimpai quixtaknik'ota tachi chun ju taxtokni. Para jantu xamati' vasalh quimispai. Va yuchi ju quimpai. Chai jantu xamati' vasalh mispai ju quimpai. Va quit'in ju ists'alh icjunita. Chai vachu' tamispai tachi chun ju iclacasq'uin ni catamispa. ");
INSERT INTO teeNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","At'at'it ju laquimacni tachi chun ju uxijnan ju na xk'opt'at'it ni jantu lai naviyat'it ju k'ox chai ju uxijnan ju alin tu'u' ju na ts'inq'ui lami'atsucunti'an. Pus laquimacni ju quit'in ast'acnana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Alac'a'it'it ju quilhamap'aksin chai alak'a'it'it ni mi'amamaka'unu'an acva. Pus ju quit'in jantu jeks ic'ui chai jantu tu'u' iclhitak'ayai. Pus ni chunch ju alat'it pus cak'achanach ju mi'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Pus jantu na lhixcai ixnavica ju quilhamap'aksin. Chai jantu axk'op'a'it'it ixnavica. ");
INSERT INTO teeNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Pus lakatam avilhchan pa'astacni ju Jesús ixt'ajun tapasana' junta ixch'ancanta ju trigo. Vachu' ixtat'a'anta ju ix'amamaka'ui. Chai ju yu'unch na ixtachavanita chai ixtap'uxlhi'anta ju xatoc'at ju trigo chai ixta'ui. ");
INSERT INTO teeNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Para acsni ta'alakts'inilh ju fariseonin tajunilh ju Jesús: ―Alakts'ich. Ju mintamamaka'un va tanavich ju lhich'alhcat. Para jantu lhijun ni chunch ju catalalh ni va avilhchan pa'astacni junita. ");
INSERT INTO teeNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Para ju Jesús chani alacjuni: ―Ja lana jantu p'ast'ac'at'it tuchi navilh ju David acsni chavanilh ju yuchi chai chux ju ixtat'a'anta. ");
INSERT INTO teeNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ja lana jantu p'ast'ac'at'it ni lai tanu junta ixlak'ayacan ju Dios chai ulh ju xkapavati ju ismokslanicanta ju Dios. Chai ju anu' xkapavati jantu lai va k'aya ix'ucan. Va yu'unch ju palijni ju lai ixta'ui. ");
INSERT INTO teeNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Chai ja lana jantu p'ast'ac'at'it tachi ju najun lacalhamap'aksin ju ts'oklh ju Moisés. Ju anch ma najun ni mati' ixtalak'alhin'an ju palijni mas tach'alhcatnan junta lak'ayacan ju Dios ju avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pus ni alin ju lhamap'aksin ni lai tach'alhcatnan ju palijni junta lak'ayacan ju Dios mas avilhchan pa'astacni junita pus iclajunau ni vana jantu talak'alhin tuchi xatanavi ju qui'amamaka'unti ni palai tu'u' ju quilhamap'aksin ju quit'in. Palai jantu ju anu' mak'aniya lhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Para ca jantu xamach'akxayat'it ju ixchivinti Dios ju ts'okcanta junta ma chani najun ju Dios: “Ju quit'in iclacasq'uin ni ala'akt'ai'ut'it laca'amapaininti. Jantu va yuchi ni aquilalhik'ailakts'iu ju tu'u' atapacxat”. Ni ca ixmach'akxat'it ju tuchi nomputun ju chunch pus jantu ca'ix'amuc'anit'it ixtalak'alhin'an ju lapanacni ju jantu tu'u' macxcai tanavita. ");
INSERT INTO teeNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Pus quit'in ju lai icnajun tuchi lai navican ju avilhchan pa'astacni. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Pus ju Jesús taxtucha ju anch. Milh la'ixpujitat'an ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chai ju anch ixtanumacha pumatam lapanac ju va ixixnita ju ixmaca'. Chai ju ali'in ju vachu' anch ixtatanumanalh va ixtapuxconiputun ixtalak'alhin ju Jesús. Chai yuchi chani talhijuni: ―Ja lai ac'uch'ununcan ju avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Chai ju Jesús chani alhik'alhtayanalh: ―Ju tam xamati' ju milhi'uxijnan ni capacxalh lakatam ixborrego chai ju yuchi cataju junta puculhucnic'a ju avilhchan pa'astacni ja jantu ca'alh macutunu'. ");
INSERT INTO teeNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Chai akts'iya palai tapalai ju is'atsucunti ju tam lapanac. Palai jantu ju va tu'u' borrego. Pus yuchi lai lhinavican ju k'ox ju avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Pus ju acsnich ju Jesús chani juni ju anu' lapanac: ―Alhit'ach ju mimaca'. Chai acsni xtaknilh ju ixmaca' pus lana tak'oxilh. Lana ixt'achunch va tachi ju ixjunita ju ixtamactam. ");
INSERT INTO teeNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Para ju fariseonin lana tataxtulh chai talacchivinilh sia yu'unch ixlacata ju Jesús ta yu laich catapumakni. ");
INSERT INTO teeNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Pus ju Jesús acsni c'atsa tuchi ixtapast'ac'a ju fariseonin pus taxtuchokolh ju anch. Chai lhu lapanacni tach'ak'ok'alh. Chai ju Jesús palaich anavik'o tachi chun ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Chai slivasalh alhimap'aksi ni jantu catanaulh tichi lapanac ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chai ni chunch ju xach'alhcatnan ju Jesús pus uctaxtulh ju tuchi naulh ju mak'aniya ixlapanac Dios ju Isaías ixjuncan. Ju yuchi ma naulh ni ma chani naulh ju Dios ixlacata ju Jesús: ");
INSERT INTO teeNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yuchi ju ani ju quilapanac ju icsacxtuta. Chai na icmapaini ju yuchi. Na iclhik'achan ju yuchi. Acxtakniya' ju quiSpiritu Santu. Chai ju yuchi ca'ajuna' ju lapanacni ju jantu israelitanin tajunita ta yu laich catatak'alhtaxtulh. ");
INSERT INTO teeNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ju yuchi jantu calasaya' nin p'as cachivina'. Chai jantu xamati' cak'asmatniya' ni na p'as cachivinilh lacatijixni. ");
INSERT INTO teeNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ju yuchi jantu lana camuc'aniya' ixtalak'alhin tam xamati' ju na xcai macajun ju amacxcai. Chai ju yuchi jantu casamak'ana' xamati' mas va lacats'unin ju lhilaksi ju Dios. Chunch ju canaviya' tus acsni ca'alina' ju ixpu'ucxtin junta si soknic'a cajuna'. ");
INSERT INTO teeNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Chai yu'unch ju jantu israelitanin catalhilaksiya' ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Pus ju acsnich lhiminicalh ju Jesús pumatam lapanac ju ixtanun ju lhacaticuru la'ixlacatuna. Chai ju yuchi alak'ach'ix ixjunita chai va ixnunulata. Pus ju Jesús c'uch'u. Chai ju acsnich ju anu' lapanac chivinilh chai alac'avanalh. ");
INSERT INTO teeNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Chai tachi chun ju lapanacni va talhamak'aninilh. Chai chani ixtanajun: ―Ju ani ja laich nu' yuchi cava ju ists'alh David. Ju ixnoncan ni camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Para ju fariseonin acsni tak'asmatlh ni chunch ixtanajun ju lapanacni tanaulh: ―Ju ani ya lapanac va tixcoxtui ju lhacaticuru la'ixlacatuna tam lapanac la'ixtachaput ju Satanás. ");
INSERT INTO teeNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pus ju Jesús mas jantu k'asmatnilh ixchivinti'an ju fariseonin para c'atsa tuchi ixtapast'ac'a chai chani ajuni: ―Tachi chun ju k'ai lacat'un junta lhinajun ju tam k'ai ucxtin ni quilhmaclhu cajuncalh chai catalaclasa ju sia is'akstu'an pus va ca'aclalh. Chai ju amachak'an va tuchi lak'achak'an u tuchi chaka' ju va catalaclak'ailh ju sia ixlhi'akstu'an pus jantu lai va lakputam catitatsucuk'alhi. ");
INSERT INTO teeNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Pus vana va chun ju lhacaticuru. Ju yuchi ni ca'atixcoxtulh ju ali'in ixt'alhacaticurulhni pus tachi ju va at'alasai ju ixlapanacni. Chai ju chunch jantu lai catilhinonk'alhi la'ixpu'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ju uxijnan nonat'it ni la'ixtachaput ju Satanás ju ictixcoxtui ju lhacaticurulhni. Para ju mintamamaka'un vachu' tamaktasq'uini ni xamati' ca'axtaknilh ixtachaput'an ni laich catatixcoxtuya' ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. Chai yu'unchach ju catajunan ni jantu slivasalh ni la'ixtachaput ju Satanás ju apuxcoxtucan ju lhacaticurulhni tachi ju nonat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Alai la'ixtachaput ju iSpiritu Santu Dios ju ic'axcoxtui ju lhacaticurulhni la'ixlacatuna'an ju lapanacni chai yuchi lhitasui ni lhinajun ju Dios lamilhi'uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tas laich calhitanuyach tam xamati' la'ixchaka' apumatam ju na tachapun junita chai laich camaxtunilh ixtaxtokni ni jantu p'ulhnan camacch'imalh. Acsnica' ju laich camaxtunicalh ju ixtaxtokni ni va jantu lai tamacyajui. Pus ju Jesús naulh ju chunch ni va ix'amamachakxaniputun ju lapanacni ni yuchi ju t'alalhajalh ju lhacaticuru chai yuchi lai alhixcoxtui ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Chai tailhi'alh ixchivinti ju Jesús. Naulh: ―Pus ju jantu quint'a'anta yuchi ju quint'alaxcai junita. Chai ju jantu qui'aktaijui ixmak'aixt'ok'a ju lapanacni ju aquintalhilaca'anach pus va asastucnun. ");
INSERT INTO teeNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Pus ni xaquilajunau ni la'ixtachaput ju Satanás ju icxcoxtui ju lhacaticurulhni la'ixlacatuna'an ju lapanacni pus yuchi iclalhijunau ni laich ca'amac'acxanicana' ju lapanacni tachi chun ju alactu'unti ju tanavi chai tachi chun ju macxcai chivinti ju tanajun. Para ni catanaulh macxcai chivinti ixlacata ju Spiritu Santu pus jantu lai tavanan cati'amac'acxanicalh. ");
INSERT INTO teeNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Chai va tichi chavaich ju canona' macxcai chivinti ju quilacata pus camac'acxanicana'. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Para va tichi chavaich ju canona' macxcai chivinti ixlacata ju Spiritu Santu jantu lai tavanan catimac'acxanicalh nin ani lacamunutpa' nin astan. ");
INSERT INTO teeNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ni k'ox ju xatoc'at ju tu'u' q'uiu pus puc'atsacan ni na k'ox ju xaq'uiu. U ni jantu k'ox ju xatoc'at pus puc'atsacan ni jantu k'ox ju xaq'uiu. Pus laxatoc'at ju puc'atsacan ju tu'u' q'uiu. Tamalhch ju k'ox chai tamalhch ju jantu. ");
INSERT INTO teeNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Pus vana va chun ju uxijnan. Ju uxijnan ni slivasalh na k'ai unt'at'it pus tas laich alhinona'it'it ju tu'u' k'ox. Pus tuchi alin lami'alhunut'an yuchach ju nonat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ju k'ox lapanac maxtui la'ix'alhunut ju k'oxi chivinti ni yuchach ju mak'ata la'ix'alhunut. Para ju tam lapanac ju k'ai junita pus la'ixpulacni ix'alhunut ju maxtui ju chivinti ju jantu k'ox ni yuchach ju mak'ata la'ix'alhunut. ");
INSERT INTO teeNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Pus chani iclajunau. Acsni cachina' ju avilhchan acsni camak'osaspitcana' ju lapanacni pus ju Dios ca'ulaniya' ixtalak'alhin'an tachi chun ju lapanacni ju ixtanajunta macxcai chivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Pus va ixlaca'atalh ju macxcai minchivinti'an capuc'atsacana' ni na k'ai unt'at'it chai ixlhiyuchi a'ulanic'ana'it'it ju mintalak'alhin'an. Para va tichi chavaich ju najun ju k'oxi chivinti pus capuc'atsacana' ni soknic'a is'atsucunti la'ixmacni Dios chai ixlhiyuchi jantu cati'ulanicalh ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Pus ju acsnich chani tajuni ju Jesús ju ali'in sia yu'unch ju fariseonin chai ali'in sia yu'unch ju na ixtalhatalanininta ixlhamap'aksin'an ju ist'a'israelitanin. ―Amamaka'unu' iclakts'imputunau tu'u' lhamak'an ju ap'umavasala' ni vasalh Cristo'at ju ixnoncan ni camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Para ju Jesús chani ak'alhtayanalh: ―Ju lapanacni ju na k'ai tajunita chai ju tamacajunta ju Dios yu'unchach ju tasq'uin tu'u' lhamak'an ju catapumispaya' ju Cristo. Para jantu cati'axtaknicalh tu'u' atumpa. Va yuchi ju ca'amapast'ac'anicana' tuchi ju tapasalh la'is'atsucunti ju mak'aniya lapanacni ju Jonás ixjuncan. Yuchi ju ixnajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Pus ju Jonás lakat'utu avilhchan chai lakat'utu atats'isni ixtajun la'ixpajan ju k'ai pamata. Chai vana va chun ju quit'in. Lakat'utu avilhchan chai lakat'utu atats'isni acta'acnuya' lacat'un ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Chai acsni cachina' ju avilhchan acsni camak'osaspitcana' ju lapanacni pus ju amachak'an Nínive catatayaya'. Chai va ixlacata'an ju yu'unch pus a'ulanic'ana'it'it ju mintalak'alhin'an. Pus ju yu'unch tamacaulh ix'alactu'unti'an acsni ajuni ixchivinti Dios ju Jonás. Para ju uxijnan jantu xamac'onat'it ju mi'alactu'unti'an mas ani icya ju palai xak'ai icjunita. Palai jantu ju Jonás. ");
INSERT INTO teeNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Vachu' ju acsni avilhchan acsni camak'osaspitcana' ju lapanacni pus ju anu' chako'ulh ju xa'ucxtin ixjunita ju lhisur catayaya'. Chai va ixlacata yuchi pus ju uxijnan amuc'anic'ana'it'it ju mintalak'alhin'an. Pus ju yuchi slivasalh na makat ju xaminacha ni va isk'asmatniputun ju ix'atalaninti ju k'ai ucxtin Salomón. Chai ani icya ju palai xak'ai icjunita ju quit'in. Palai jantu ju Salomón. Para ju uxijnan jantu k'asmatp'ut'unat'it ju quinchivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Ju lhacaticuru acsni taxtui la'ixlacatuna tam lapanac pus vaclhun ucxunt'ajun junta axixninta. Va puxcolhit'ajun ta anchach ju lai catavi. Para jantu lai lhitajui. ");
INSERT INTO teeNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Chai ju acsnich chani najun: “Alai ac'anchokoya' laquinchaka' junta xactaxtuyacha”. Chai acsni chinchokoi pus lana tanuchokoi la'ixlacatuna ju anu' lapanac ni tachi lakatam chaka' junita junta jantu xamati' tanun para na pulacp'alhcanta chai na c'us maxantilacanta. ");
INSERT INTO teeNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Pus ju acsnich ju anu' lhacaticuru taxtuchokoi. An ini' apumatujun lhacaticurulhni chai ak'ailhimink'ojui la'ixlacatuna ju anu' lapanac. Chai ju anu' ixpumatujun'an lhacaticurulhni palai k'ai tajunita. Palai jantu na chun ixjunita ju p'ulhnan ixtanun va is'akstu. Pus palai tak'alhilh ju is'atsucunti ju anu' lapanac ju acsni. Palai jantu na chun ixjunita ju p'ulhnan. Pus vana va chun cajuna' ju mi'atsucunti'an ju uxijnan ju t'onat'it ju chavai ju na k'ai unt'at'it. ");
INSERT INTO teeNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Acsni ixt'ajunca' xak'alana' ju lapanacni ju Jesús pus tachincha ju ixnati chai is'ap'isek'en. Chai tataya makspa' ni va ixtat'achivimputun ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Chai pumatam lapanac chani xajuni ju Jesús: ―Ju minati chai ju mi'ap'isek'en tayanancha makspa' chai tat'achivimputunan. ");
INSERT INTO teeNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Para ju Jesús chani juni ju anu' lapanac ju ixmalakachacanta: ―Tis chavaich ju quinati chai tis chava'itnich ju qui'ap'isek'en. ");
INSERT INTO teeNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Pus ju acsnich ju Jesús amac'anilh junta ixtavilanalh ix'amamaka'ui chai naulh: ―Ani tavilanalh ju quinati chai ju qui'ap'isek'en. ");
INSERT INTO teeNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pus va tichi chavaich ju canaviniya' ixk'achat ju quimpai ju vilhcha lact'iyan yuchach ju vasalh quimp'isek'e ts'alh chai vasalh quimp'isek'e atsi' chai vasalh quinati. ");
INSERT INTO teeNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Pus ju acsni avilhchan ju Jesús taxtulh ju lacachaka'. Chai tolhcha vanin la'ixquilhtu' ju atants'in. ");
INSERT INTO teeNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Chai ni na lhu talakcha'alh ju lapanacni pus ju yuchi taju lacabarco ni laich ca'amalanik'olh ixchux'an. Anch ju tavi chai tachi chun ju lapanacni lacat'un tataya la'ixquilhtu' atants'in. ");
INSERT INTO teeNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Pus ju acsnich ju Jesús na lhu taxtokni ju xa'amalani ju lapanacni. Para si lacatu'u' chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. Chani xa'ajuni: ―Pumatam ach'anana' alh lhavana' ju ix'ach'ananti. ");
INSERT INTO teeNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Chai acsni ixt'ajun lhavana' pus lacats'unin ju xat'in tamacha va lacati. Chai tamilh ju ts'ok'o chai tasac'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Chai ju ali' ju xat'in tamacha la'ix'ucxni chiux junta mati' lhu ixjunita ju t'un. Pus ju yuchi va ts'alhti p'unlh ni mati' lhu ixjunita ju t'un. ");
INSERT INTO teeNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Para acsni xajchilh ju avilhchan lana macchalh chai lana xixlh ni jantu makat ixtinui istisivic. ");
INSERT INTO teeNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Chai ju ali' ju xat'in tamacha junta vachu' ixma ju xat'in alhtucunu'. Pus ju alhtucunu' palai vats'alhti tak'aya chai akxtakmalh ju anu' ach'ananti. ");
INSERT INTO teeNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Para ju ali' xat'in tamacha junta na k'ox ixjunita ju t'un. Chai ju yuchi p'unlh. Tak'aya. Chai toc'alh ju xalhi'ut. Pus talhava ju akatamin ach'ananti. Ju ali' toc'alh tam cientos xalhi'ut. Ju ali' toc'alh sesenta xalhi'ut. Chai ju ali' toc'alh va lakap'uxamcau ju xalhi'ut. ");
INSERT INTO teeNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Pus va tichi chavaich ju alin ixpak'asmatni pus cak'asmatlich ju tuchi iclajunau. ");
INSERT INTO teeNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Pus ju acsnich ju ix'amamaka'ui ju Jesús talakmilh chai chani tajuni: ―Tajuch ni va alacmalani ju lapanacni lacatu'u' chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Chai ju Jesús alacjuni: ―Ju uxijnan lac'asq'uinic'ant'at'it ni amach'akxaya'it'it ju chivinti ju najun ni lhinomputun ju Dios la'is'atsucunti'an ju lapanacni. Para ju ali'in lapanacni jantu alak'a'inican ni catamachakxa. ");
INSERT INTO teeNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Pus ju laca'i ju juncan pus ali' cajuncana' chai lhu camachakxaya'. Para ju jantu laca'iputun ju tuchi juncan pus camac'ap'anicana' ju tuchi ixlaca'ita. ");
INSERT INTO teeNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Pus ju lapanacni ni lana jantu tamispai tuchi nomputun mas talakts'in tuchi icnavi chai lana jantu talaca'i nin catamachakxa ju quinchivinti mas tak'asmat'a pus yuchi ic'alhilhixak'alai ju lapanacni lacatu'u' chivinti ju ixt'alakts'ipaxcavaca ju tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Chai la'is'atsucunti'an ju yu'unch uctaxtui ixchivinti ju mak'aniya ixlapanac Dios ju Isaías ixjuncan. Pus ju yuchi chani naulh: Ju uxijnan slivasalh ak'asmat'a'it'it para jantu lana amach'akxaya'it'it. Chai slivasalh alac'avanana'it'it para jantu anaviya'it'it cuenta tuch'i ju lakts'inat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Chunch ju catapasaya' lami'atsucunti'an ni na p'as xajun ju mi'alhunut'an. Chai lana jantu k'asmat'at'it tu'u'. Chai tachi ju va lakpust'okt'it ni va jantu tu'u' lakts'imp'ut'unat'it. Chai jantu tu'u' k'asmatp'ut'unat'it. Chai jantu tu'u' mach'akxap'ut'unat'it. Chunch ju layat'it ni jantu mac'omp'ut'unat'it ju mi'alactu'unti'an ni laich aclamak'alhtaxtuch. Chunch ju naulh ju Isaías. ");
INSERT INTO teeNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Para na paxcat unt'at'it ju uxijnan ji quints'alan ni vasalh p'u'alac'avananat'it ju milakchulh'an chai p'ak'asmatnanat'it ju mi'ak'axk'olh'an. ");
INSERT INTO teeNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Pus slivasalh ju iclajunau. Na lhu ix'alin ju mak'aniya ixlapanacni Dios chai ju ali'in mak'aniya lapanacni ju soknic'a ixjunita ju is'atsucunti'an ju na ixtalakts'imputun ju tuch'i lakts'inat'it ju uxijnan. Para jantu tavanan talakts'ilh. Chai na ixtak'asmatputun ju tuch'i k'asmat'at'it para jantu tavanan tak'asmatlh. ");
INSERT INTO teeNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju ixtamamaka'un: ―Pus ak'asmat'it ju uxijnan tuchi nomputun ju chivinti ixlacata ju ach'anana'. ");
INSERT INTO teeNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Pus ju t'in ju tamacha vanin la'ixquilhtu' ti yu'unch ju tak'asmat'a ju chivinti junta najun ni lhinomputun ju Dios la'is'atsucunti'an ju lapanacni. Para ju yu'unch jantu tamachakxai. Chai lana min ju lhacaticuru chai amac'ap'ani ju chivinti ju ix'ach'ananicanta la'ix'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Chai ju t'in ju tamacha la'ix'ucxni chiux yu'unch ju tak'asmat'a ixchivinti Dios chai lana soko tak'achani. ");
INSERT INTO teeNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Para chunch tajunita tachi ju anu' xap'un la'ix'ucxni chiux. Jantu vasalh la'ixlhichux ix'alhunut'an ju tak'achani. Va pants'iquis ju talaca'i. Para acsni min ju tu'u' mak'alhk'ajnat u tu'u' axcayanti va ixlacata ni talaca'i ju ixchivinti Dios pus lana tamacajun ixti ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Chai ju t'in ju tamacha junta ix'alin ju xat'in alhtucunu' pus yu'unch ju tak'asmat'a ixchivinti Dios para va tachi talhamak'aninin ju xataxtokni ju ani lacamunutpa' chai va taputa'okxchok'oi ju tumin. Pus tachi chun ju ani taxtokni va amac'ap'ani ju chivinti ju ixch'ananicanta la'ix'alhunut'an chai jantu tavanan vasalh tasui ixtachaput ju Dios la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Para ju t'in ju tamacha lacak'oxi t'un yu'unch ju tak'asmat'a ju ixchivinti Dios chai tamachakxai. Chai lana tasui la'is'atsucunti'an ixtachaput ju Dios. Ju ali'in slivasalh lhu tasui ixtachaput Dios la'is'atsucunti'an. Ju ali'in palai na lacats'unin chai ju ali'in palai tucan na lacats'unin. ");
INSERT INTO teeNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Chai ju Jesús ajunilh ju lapanacni ju ani alakatam chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. ―Junta lhinajun ju Dios chunch tapasai tachi ju tapasalh la'is'atsucunti pumatam lapanac. Ju yuchi ch'anlh ju k'oxi xat'in trigo la'ixcuxtu. ");
INSERT INTO teeNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Para ju ts'is acsni ilhtatacan pus milh ju ixt'alaxcai ju anu' lapanac chai alhavanalh ju xat'in ach'itin. Va lhitayalh ju k'oxi t'in. Chai acsni ch'ank'o pus lana taxtucha. Alh. ");
INSERT INTO teeNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pus p'unlich ju k'oxi t'in chai vachu' p'unlich ju xat'in ach'itin. Tatak'aya. Para acsni tsuculh alini' ju xatoc'at ju trigo acsnica' ju tasu ju ach'itin ju ixch'ancanta. ");
INSERT INTO teeNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Pus ju acsnich ixlapanacni ju amat'un talakmilh chai tajuni: “Ja jantu xach'an ju k'oxi t'in lamincuxtu. Pus tas anchach ju xaminacha ju va ach'itin”. ");
INSERT INTO teeNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Chai ju amat'un ajunich: “Yuchi ju quint'alaxcai ju xach'an ju xat'in ju va ach'itin”. Chai ju acsnich ju ixlapanacni tasacmich. Tajunich: “Ja lac'asq'uin ni ac'auch laxtunin”. ");
INSERT INTO teeNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Para ju yuchi chani ajuni: “Jantu ni va lai t'ap'ulhut'it ju k'ox ach'ananti acsni t'ip'ulhuyat'it ju ach'itin. ");
INSERT INTO teeNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Amac'a'unt'it. Chach tak'aya k'aixtam tus acsni ca'alinach ju xatoc'at. Ju acsnich chani ac'ajuna' ju catap'uxa': P'ulhnan ap'ulhut'itch ju ach'itin. Chai ap'ach'imaya'it'it makxapatamin ni laich caxavacana'. Chai astan ap'ulhut'it ju trigo chai amak'at'it laquimpac'ats'a”. ");
INSERT INTO teeNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ju Jesús alacjuni ju lapanacni alakatam chivinti ju ix'apumavasalaniputun ni lhu catalhilaksiya' ju Dios acsni talakts'in ni lhinajun ju yuchi la'is'atsucunti'an ju ali'in ixt'alapanacni. Pus chani ju ajuni: ―Acsni lhinajun ju Dios la'is'atsucunti'an ju lapanacni pus chunch ju tapasai tachi ju tapasai acsni ch'ancan ju xat'in mostaza. ");
INSERT INTO teeNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ju anu' xat'in yuchi ju palai lacat'icst'i tachi chun ju t'in. Para acsni tak'ayai na k'alhapak'ai jun. Tasui tachi ju lacat'icst'i q'uiu. Chai ju ts'ok'o tamin chai tamuc'ai ixpamalhiqui'an la'ix'acatan. ");
INSERT INTO teeNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ju Jesús vachu' alacjuni ju lapanacni alakatam chivinti ju ix'apumavasalaniputun tuchi tapasai acsni lhinajun ju Dios la'is'atsucunti'an ju lapanacni. Pus chani ju ajuni: ―Acsni lhinajun ju Dios la'is'atsucunti'an ju lapanacni chunch ju tajunita tachi ju tu'u' xat'in xkapavati ju calhiyaulh tam chako'ulh ju lakat'utu ach'apanta ju harina. Pus lana lhitayak'ojui chux. ");
INSERT INTO teeNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tachi chun ju ani taxtokni ju Jesús ajunk'o ju lapanacni lacatu'u' chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. Jantu lana tu'u' ju vas ajunilh. ");
INSERT INTO teeNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chai ni chunch ju navilh ju Jesús pus uctaxtulh tuchi ju naulh ju mak'aniya lapanac ju ixnajun ixchivinti Dios. Chani ma xanajun ju yuchi: Ac'alhixak'alaya' ju lapanacni lacachivinti ju t'alakts'ipaxcavacan ju tu'u'. Ac'ajuna' ju taxtokni ju jantu ixtamachakxai ju lapanacni tus la'ixputai'ulacan lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Pus ju acsnich ju Jesús amac'amilh ju lapanacni chai milh la'ixchaka'. Pus lana talakmilh ju ix'amamaka'ui chai tajunich: ―Aquilamavasalaniu ju chivinti ixlacata ju t'in ju jantu k'ox ju ixch'ancanta la'ixt'un ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Pus ju acsnich chani alacjuni ju Jesús: ―Pus quit'in ju icch'an ju k'oxi xat'in. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Chai ju lacacuxtu yuchi ju lacamunutpa'. Chai ju k'oxi t'in yu'unch ju alhcanicanta ni laich catatanu ju lact'iyan junta lhinajun ju Dios. Chai ju t'in ju jantu k'ox ixjunita yu'unch ju na k'ai tajunita. ");
INSERT INTO teeNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Chai ju anu' ixt'alaxcai ju amat'un ju ch'anlh ju t'in ju jantu k'ox yuchi ju lhacaticuru. Chai acsni ixchakx'ican ju xatoc'at yuchi ix'aclanti ju lacamunutpa'. Chai ju ta'i ju xatoc'at yu'unch ju anquilhnin. ");
INSERT INTO teeNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Chai tachi ju tatip'ulhulh ju ach'itin ju jantu k'ox ixjunita chai talacxava pus chunchach vachu' catapasaya' la'ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Pus ju quit'in acmalakachatachilh ju qui'anquilhnin. Ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Chai ju qui'anquilhnin catamak'aixt'ok'ach chai catatamacxtuya' laquimpu'ucxtin tachi chun ju lapanacni ju ta'alactu'unun chai tachi chun ju amak'alhk'osui ju ali'in lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Chai ca'amaca'ancanach lacajipi. Pus ju anch catak'alhunanta chai catalamatants'acayach istatsalat'an ni na catamak'alhk'ajnana'. ");
INSERT INTO teeNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Pus ju acsnich ju alakts'incan ni soknic'a la'ixmacni Dios slap'ap'a catasuyach tachi ju tasui ju avilhchan. Chunch catajuna' junta lhinajun ju quimpai'an. Pus ju alin ju ixpak'asmatni chach k'asmatlh ju iclajunau. ");
INSERT INTO teeNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Junta lhinajun ju Dios chunch junita tachi ju tu'u' tumin ju ixmacnucanta ju lacat'un. Pus pumatam lapanac lhitajulh ju anu' tumin para lana macnuchokolh. Chai ni na ixlhik'achanta pus lana st'ak'o tachi chun ju ix'alinta chai lhitamaulh ju anu' lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Junta lhinajun ju Dios vachu' chunch junita tachi ju tam lapanac ju ixmalakxtui ju chiux ju laklhu ixtapalh. ");
INSERT INTO teeNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Pus acsni lhitajulh lakatam chiux ju slivasalh na k'ox ixjunita pus ju anu' lapanac alh chai st'ak'o tachi chun ju ix'alinta chai lhitamaulh ju anu' chiux. ");
INSERT INTO teeNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Junta lhinajun ju Dios vachu' chunch junita tachi lakatam ch'okxni ju maca'ancalh laca'alama chai anch ju tanulh tijpachux ju pamata. ");
INSERT INTO teeNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Chai acsni aktsamalh ju ch'okxni pus ju ixch'apanin pamata taxak'alhi'alh lak'akxixni. Chai anch tat'atavilhch chai tatsuculh maxtunin ju pamata ju k'ox. Tatsuculh munin la'ispasti'an. Chai tamak'alh ju jantu k'ox. ");
INSERT INTO teeNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Pus chunchach vachu' catapasaya' la'ix'aclanti ju lacamunutpa'. Cataminach ju anquilhnin chai catasacxtuya' ju alactu'unin. Catamaconach ju lakts'incan ni soknic'a la'ixmacni Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Chai camaca'ancanach ju alactu'unin lacajipi. Chai ju anch catak'alhunanta chai catalamatants'acayach istatsalat'an ni na catamak'alhk'ajnana'. ");
INSERT INTO teeNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Pus ju acsni ju Jesús chani asacmilh ju ix'amamaka'ui: ―Ja mach'akxayat'it tachi chun ju ani ju iclajuntau. Chai ju yu'unch tajunilh ni tamachakxa. ");
INSERT INTO teeNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Pus ju acsnich ju Jesús chani alacjuni: ―Tachi chun ju lapanacni ju talhatalanininta ju ixchivinti Dios chai talak'a'ita ni calhinaulh ju Dios la'is'atsucunti'an pus chunch tajunita tachi tam mak'ali'. Ju yuchi lai maxtui la'ixmak'alit ju taxtokni acsni maktasq'uinican. Lai maxtui ju va anca' mak'ata u yuchi ju mak'aniya mak'atach. Pus vana va chun ju anu' lapanacni. Ju yu'unch vachu' lai tamaxtui ju chivinti ju tamak'ata la'ix'alhunut'an ni laich catapu'aktaiju tam xamati'. Lai catamaxtulh ju chivinti ju mak'anch tac'atsata u yuchi ju va anca' xatalani. ");
INSERT INTO teeNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Pus ju Jesús acsni nonk'o tachi chun ju ani chivinti ju ixt'alakts'ipaxcavaich ju tu'u' pus taxtulh ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Milh la'ixt'un. Chai tsuculh amalanini' la'ixpujitat'an ju ist'a'israelitanin. Chai ixt'a'amachak'an na talhamak'aninilh chai chani tanaulh: ―Tas anchach nu' ju xalani ju ani chivinti. Tas laich lhinavi ju k'ai lhamak'an. ");
INSERT INTO teeNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ni yuchi jumpalat ju ists'alh ju axpitni'. Chai ixnati yuchi ju Malia. Chai ju is'ap'isek'en yu'unch ju Jacobo chai José chai Simón chai Judas. ");
INSERT INTO teeNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Chai is'ap'isek'en atsi'in ni ani tat'ajun vachu'. Pus tas anchach ju xalani ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Pus talhixcailich. Para ju Jesús chani ajuni: ―Ju lapanac ju najun ixchivinti Dios k'ox lhiulacan vanta anchach ju an. Va ixt'a'amachak'an chai ju tatanumanalh la'ixchaka' ju jantu k'ox talhiulai. ");
INSERT INTO teeNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Pus ju anch jantu lhu xanavi ju k'ai lhamak'an va ixlaca'atalh ni jantu ixtalhilaksi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Pus acsni ixt'ajun tapasana' ju ani taxtokni pus ju Herodes k'asmatlh ixlacata ju Jesús. Pus ju Herodes gobernador ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Chai ju yuchi chani ajuni ju ixlapanacni: ―Ju anu' ju Jesús talhixak'alai yuchach ju Xivan ju amakpaxana'. Ju yuchi ca va lok'onchokolh junta quimacnucalh chai yuchi na k'ai lhamak'an lhinavi. ―Chunch ju ajuni ju ixlapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Pus acsni ixt'ajunca' ju Xivan pus ju Herodes ixlhinajunta ixch'apaca. Chai lhinaulh ixmakch'ica chai ixt'alhnuca. Chunch ju ulhtucalh va ixlaca'atalh ju Herodías ju ix'amachaka' ixjunita ju isp'isek'e ju Pilipe ixjuncan. Para ju acsnich yuchi ju Herodes ixt'at'ajun. ");
INSERT INTO teeNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Pus ju Xivan acsni tuca' ixt'alhnucanta chani ixjunita ju Herodes: ―Jantu lhijun ju lhamap'aksin ni va at'ats'uc'uch'ok'och ju ix'amachaka' ixjunita ju mimp'isek'e. ");
INSERT INTO teeNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Pus ju Herodes lana ixlhinomputun ixmaknica ju Xivan para va ix'atalhoni ju lapanacni. Pus ju yu'unch ixtanajun ni ixlapanac Dios ixjunita ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Para acsni chilh ju avilhchan acsni c'atanilh ju Herodes pus istsi' ju Herodías tanucha junta ixtavilanalh ju lapanacni chai tsuculh at'ini'. Pus ju Herodes slivasalh na k'achanilh ju at'inti. ");
INSERT INTO teeNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Pus lhipastacnilh Dios chai junilh ju atsi' ni caxtakniya' va tuchi casq'uiniyach. ");
INSERT INTO teeNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pus ju anu' atsi' junilh ju Herodes tachi ju ixjunita ju ixnati. Naulh: ―Aq'uixt'akninch laca tu'u' k'ai casavila ju is'aktsulh ju Xivan ju amakpaxana'. ");
INSERT INTO teeNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Pus ju gobernador lana na amak'aninilh acsni k'asmatnilh ixchivinti ju anu' atsi'. Para ni ixlhipastacta ju Dios acsni junilh ju atsi' ni caxtakniyach va tuchi casq'uiniyach chai ni ixtak'asmat'a ju ixtavilanalh anch pus jantu lai junilh ni jantu. Akts'iya lhinaulh ixtaknica ju tuchi xasq'uinch ju atsi'. ");
INSERT INTO teeNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Pus malakachalh ju ixtaropa chai ju yuchi alh. Maknilh ju Xivan lacapulach'in. ");
INSERT INTO teeNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Chai lhiminicalh ju is'aktsulh lacak'ai casavila. Chai xtaknilh ju atsi'. Chai ju yuchi lana lhi'anilh ju ixnati. ");
INSERT INTO teeNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Pus ju acsnich tachincha ju ix'amamaka'ui ju Xivan. Taqui'i ju ixlacatuna chai taquimacnu. Astan taquimac'atsanilh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Pus ju Jesús acsni c'atsa ni ixmaknicanta ju Xivan pus lana taxtulh. Taju lacabarco chai alh ju lacatam junta va aseknic'a ixjunita. Para ju lapanacni tac'atsapa chai tataxtulh lak'achak'anixni. Tach'ajax'alh junta ixtanajun ni cacha'ana' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Pus ju Jesús acsni tacutcha lacabarco lakts'ilh ni na lhu ixtatak'aixtokta ju lapanacni. Pus na amapaini ju yu'unch chai ac'uch'ulh ju ixtalactak'ank'ai sia lhiyu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Para acsni tok'oxalh pus talak'alh ju ix'amamaka'ui chai tajuni: ―Ju ani slivasalh ni na aseknic'a chai tapasalh ju hora acsni vencan. Amalak'ach'at'i ju lapanacni. Chach ta'ancha ju lak'achak'anixni tamonin ixvaiti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Para ju Jesús chani alacjuni: ―Jantu tasq'uini ni cata'alh. Axt'aknit'it ju uxijnan ju vaiti. ");
INSERT INTO teeNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Chai ju yu'unch tajuni: ―Para va xaman akxquis vati chai lakat'ui pamata ju icmamatau ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Chai ju Jesús alacjuni: ―Aquilalhiminiuch. ");
INSERT INTO teeNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Pus ju acsnich ju Jesús ajuni ju lapanacni ni catatavi laca'ats'inan. Chai ju yuchi ch'apalh ju anu' akxquis vati chai ju lakat'ui pamata. Chai talakst'alh ju lact'iyan chai xtaklh lak'ailakts'iuch ixlacata ju vaiti. Astan ch'ek'elh ju vati chai ju pamata. Chai axtaknilh ju ix'amamaka'ui. Chai ju yu'unch tatsuculh lhilaksak'onin ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pus ta'ok'olh ixchux'an chai talhilalh. Chai tasacchokolh ju xajcha ju jantu xata'ok'ojui chai talaktsama lakacaut'ui tank'alin. ");
INSERT INTO teeNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Pus ju anuch ju tavailh ixtacha'anta lakaquis milh jok'atni. Jantu aput'ek'ecalh ju chakolun nin ju ask'at'an. ");
INSERT INTO teeNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Pus ju acsnich ju Jesús lana p'as alacjuni ju ix'amamaka'ui ni catataju lacabarco chai catap'ulh'anchalh ju lhimak'antacutni ju atants'in. Pus ju yuchi tavilhca' ni laich ca'amalakachachokoya' ju lapanacni la'ixchaka'an. ");
INSERT INTO teeNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Chai acsni ta'ank'o ju lapanacni pus ju Jesús alh junta akstijun ixjunita. Alh t'achivini' ju Dios va is'akstu. Chai acsni tok'oxalh pus va is'akstu ixvi ju Jesús ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Pus ju barco la'ixlacaitat ju atants'in ixcha'anta. Para ni na p'as ixlai ju un chai na ixnek'esp'it ju xcan pus jantu lai ixtamalhtanai ju barco. ");
INSERT INTO teeNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Para acsni ixt'ajun tuncuntilana' pus alak'alh ju Jesús. Alhtana'alh la'ix'ucxni xcan. ");
INSERT INTO teeNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Para ju ix'amamaka'ui acsni talakts'ilh ni alhtana'antachalh la'ix'ucxni xcan lana na tatalhanalh. Talaclajunich: ―Ca yuchi ju macxcai un. Chai na talact'asalh ni na ixtatalhanan. ");
INSERT INTO teeNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Para ju Jesús lana axak'ala. Chani alacjuni: ―Quit'in. Jantu at'alhanant'it. Ak'ach'ant'it. ");
INSERT INTO teeNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pus ju acsnich ju Pitalu' xak'ala ju Jesús chai juni: ―Qui'ucxtin ni vasalh uxint'i'at pus yauch aq'ui'un ni ac'anchan pakxtoknun. Ac'alhtana'anchalh la'ix'ucxni xcan. ");
INSERT INTO teeNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Chai ju Jesús juni: ―Asok'och. Pus ju Pitalu' lana tacutlh ju lacabarco. Alhtanalh la'ix'ucxni xcan ni ix'amputun pakxtoknu' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Para acsni lakts'ilh ni na p'as ixt'ajun ju un pus lana talhanalh chai ixnitajuputun lacxcan. Pus p'as t'asalh. Naulh: ―Qui'ucxtin aq'uimak'alht'axt'uch. ");
INSERT INTO teeNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pus ju Jesús lana xtaknilh ixmaca'. Macch'apacha chai chani juni: ―Tis va yuchach ji lapanac ni jantuch quilhilac'ap'in. Tas ni va xaq'uinc'ap'ach. ");
INSERT INTO teeNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Chai acsni tatajuchokolh ju yu'unch ju lacabarco pus lana sek va ju un. ");
INSERT INTO teeNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Pus ju acsnich ju ixtatanumanalh lacabarco talak'ayalh. Tajunich: ―Slivasalh ni ists'alh'at Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Acsni tacha'alh ju lhimak'antacutni ju atants'in ju Jesús chai ju ix'amamaka'ui pus tacha'alh ju xalacat'un Genesaret. ");
INSERT INTO teeNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Chai ju amachak'an anch acsni tamispa ju Jesús pus lana tamalakachalh chivinti tachi chun ju lak'achak'anixni ju vanin ixvi. Pus ju lapanacni talhiminilh ju Jesús tachi chun ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Chai tatapaininilh ni laich catalakcha'anilh mas va lacats'unin ixquilhtu' ixpumpu'. Pus ju Jesús alak'a'inilh. Chai tachi chun ju talakcha'anilh ju ixpumpu' palaich tava. ");
INSERT INTO teeNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ju acsnich talakmilh ju Jesús ju ali'in fariseonin chai ju lapanacni ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin amachak'an Jerusalén. Chai tasacmilh ju Jesús. Tajuni: ");
INSERT INTO teeNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―Ju mintamamaka'un tajuch ni jantu tu'u' talhiulai ju ixlhamap'aksin'an ju papaninch ni jantu chunch tamakch'ak'ai acsni tavajin tachi ju iclhilanitau ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Para ju Jesús chani ak'alhtailh: ―Pus ju uxijnan tajuch ni jantu navip'alat'it tachi ju najun la'ixlhamap'aksin ju Dios. Alai va naviyat'it ju mi'atalaninti'an mi'akstu'an. ");
INSERT INTO teeNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Pus ju Dios chani naulh: “At'alhonit'it ju mimpai'an chai ju minati'an”. Vachu' naulh ni camaknicalh va tichi chavaich ju cajuna' macxcai chivinti ju ixpai u ixnati. ");
INSERT INTO teeNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Para ju uxijnan lak'a'init'it ni chani cajunilh ju ixpai u ixnati ju tam lapanac: “Ju quit'in jantu lai actila'aktaiju va ixlaca'atalh ni iclhik'ailakts'ilh ju Dios ju tumin ju xaclapu'aktaiju ju uxijnan”. ");
INSERT INTO teeNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Pus ju uxijnan lak'a'iyat'it ni jantu ca'aktaiju ju ixpai u ixnati va tichi chavaich ju chunch canaulh. Chai ni chunch ju layat'it pus samak'ant'at'it ju ixlhamap'aksin Dios va ixlaca'atalh ni navip'ut'unat'it ju mi'atalaninti'an mi'akstu'an. ");
INSERT INTO teeNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ju uxijnan va a'okxchok'onin unt'at'it acsni chunch ju layat'it. Pus slivasalh tachi ju naulh ju Isaías ju milacata'an acsni chani xats'ok'ulai la'ixchivinti Dios: ");
INSERT INTO teeNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ju ani lapanacni va la'ixquilhni'an quintalak'ayai. Para ju la'ix'alhunut'an tam tapast'ac'a ju quilacata quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jantu lhitapalai ni quintalak'ayai ni ta'amalanininch va ixlhamap'aksin'an ju ixt'alapanacni'an. ");
INSERT INTO teeNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Acsni nonk'olh ju chunch ju Jesús pus at'asanilh ju ixtalhavat lapanacni chai chani alacjuni: ―Aquilak'asmatniu chai amach'akxat'it ju aclajunau. ");
INSERT INTO teeNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Jantiyu' ju ui tam lapanac ju malhquiliquini ju is'atsucunti. Alai yuchi ju chivinti ju taxtui la'ixquilhni. Yuchach ju malhquiliquini is'atsucunti ju tam lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Pus ju acsnich talakmilh ju Jesús ju ix'amamaka'ui chai chani tajuni: ―Ja c'ats'aich ni talhitalhk'amalh ju fariseonin ju tuch'i xa'a'uni. ");
INSERT INTO teeNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Para ju Jesús chani alacjuni: ―Tachi chun ju lapanacni ju jantu talaca'iputun ixchivinti ju quimpai ju vilhcha lact'iyan cata'aclaya'. Chunch ju ca'a'ulhtucana' tachi acsni tipulhucan ju tu'u' q'uiu. ");
INSERT INTO teeNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Pus amac'a'unt'it ju yu'unch ni chunch tajunita tachi ju tu'u' alak'ach'ixnin chai ta'ap'ulhniputun ju ixt'a'alak'ach'ixnin. Pus ju tam alak'ach'ix ni cap'ulhnilh ju ixt'a'alak'ach'ix pus ixt'iyun'an catinta'ana' junta puculhucnic'a. ");
INSERT INTO teeNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pus ju acsnich ju Pitalu' chani juni ju Jesús: ―Aquilamavasalaniuch ju chivinti ju xa'a'uni ju ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Chai ju Jesús ajuni: ―Ja vachu' jantu lai amach'akxanant'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ja va jantu mach'akxayat'it ni va lamimpajan'an ju tajui tachi chun ju q'uilht'anuyat'it. Chai astan va mak'ancanch. ");
INSERT INTO teeNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Para tachi chun ju macxcai chivinti ju q'uilht'axt'uyat'it pus lami'alhunut'an ju minacha. Chai yuchach ju tamalhquiliquiniyan ju mi'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pus laca'alhunut ju taxtui ju macxcai atalacpast'ac'at chai ju amakninti chai ju ixpuxcajuca apumatam chako'ulh u apumatam jok'at. Vachu' laca'alhunut ju taxtui ju ixk'achanica ni va lacati tsucucan chai ju ak'alha'unti chai ju ta'aklhtamat chai ju macxcai chivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Yuchach ju ani ju malhquiliquini is'atsucunti ju tam lapanac. Jantiyu' ni va jantu chun camakch'ak'alh acsni cavena' tachi ju talhilanita ju ali'in. ");
INSERT INTO teeNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Pus ju acsnich ju Jesús taxtucha ju anch. Alh ju xalacat'un junta ix'alin ju lak'achak'anixni Tiro chai Sidón. ");
INSERT INTO teeNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chai pumatam chako'ulh amachaka' Canaán lak'alh ju Jesús chai va tsa tsa tapaininilh. Chai na p'as ixchivinin acsni chani ixjuni: ―Qui'ucxtin. Ists'alh'at David. Lamapainin aq'ui'akt'ai'ut'ich. Alin ju lhacaticuru la'ixlacatuna ju quintsi' chai slivasalh na mak'alhk'ajnan. ");
INSERT INTO teeNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Chunch ju ixjuni ju Jesús para ju yuchi jantu ts'i junilh. Pus ju acsnich talakmilh ju Jesús ju ix'amamaka'ui chai tatapaininilh. Tajunich: ―Anavininch ju tuchi sq'uiniyan ni laich ca'anchokolh la'ixchaka' ni na jeks quintamavayan. ");
INSERT INTO teeNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Pus ju acsnich ju Jesús chani naulh: ―Ju Dios quimalakachatachilh ni va yu'unch ac'a'aktaijuya' ju quint'a'israelitanin ju catamak'alhk'ajnank'alhi ni catatailhi'alh ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Para ju anu' chako'ulh palai vanin milh junta ixya ju Jesús. Ta'aktsokotanilh. Chai chani juni: ―Qui'ucxtin aq'ui'akt'ai'ut'ich. ");
INSERT INTO teeNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Para ju Jesús juni: ―Jantu lhijun ni ac'aktaijun ju uxint'i. Ni chunch aclalh pus va ixt'achun cava tachi ju va ac'aquictai'i ju ixvaiti'an ju quint'a'amachivinti chai ac'axtaknilh ju sc'uyun. ");
INSERT INTO teeNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Para ju anu' chako'ulh chani juni: ―Vasalh ji qui'ucxtin. Para mas yu'unch ju sc'uyun tasac'ui ju xataquicpuchin ju patajui lacamixa junta tavajin ju ix'ucxtin'an. ");
INSERT INTO teeNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Pus ju acsnich ju Jesús juni: ―Chako'ulh slivasalh na q'uilhilaksich. Anavinic'ana'ich ju tuch'i xaq'uisq'uinich. Pus lana palai va ju istsi' ju anu' pants'iquis. ");
INSERT INTO teeNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Chai ju Jesús taxtucha chai milh vanin laxa'atants'in Galilea. Chai astan alh lakatam akstijun chai tolhcha ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Chai na lhu talakcha'alh ju lapanacni. Alaclhicha'anicalh ju jantu lai ixta'alhtanan chai ju alak'ach'ixnin chai ju nunu' chai ju macmututu chai ju alich na lhu tak'ank'anin. Vaninch amamacalh junta ixch'antai ju Jesús chai ju yuchi palai anavik'o. ");
INSERT INTO teeNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Pus ju lapanacni na talhamak'aninilh acsni talakts'ilh ni ixtachivinin ju nunu' ixtajunita. Chai ju macmututu ixjunita palai tajunlh. Chai ju va ch'anlhk'avilh ixtajunita laich sok ixta'alhtanan. Chai ju alak'ach'ixnin ixtajunita laich ixta'alac'avanan. Pus chux ju lapanacni na talhamak'aninilh. Chai na talak'ayalh ju isDios'an ju israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ju acsnich ju Jesús alact'asanilh ju ix'amamaka'ui chai chani ajuni: ―Paini'itnich ju ani tavilanalh lapanacni ni lakat'utu avilhchan xaquintat'atolan chai ju chavai matich ju tuchi cata'ulh. Chai jantu ic'amalakachaputun la'ixchaka'an ni va catachava'alh. Jantu xcai ni va catata'aktalh ju lacati ixchavan'an. ");
INSERT INTO teeNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pus ju ix'amamaka'ui tajuni: ―Para ju ani jantu xamati' t'ajun. Tas anchach ju lai ac'iyau ju quijnan ju lhu vaiti ni laich ac'amalhilanik'oju ju ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Chai ju Jesús asacmilh. Alacjuni: ―Tas akxchux vati ju ch'ap'at'at'it. Chai ju yu'unch tajuni: ―Va akxtujun vati chai lacats'unin lact'icst'i pamata. ");
INSERT INTO teeNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Pus ju acsnich ju Jesús ajuni ixtalhavat lapanacni ni catatavilhca' laca'ats'inan. ");
INSERT INTO teeNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Chai ju yuchi ch'apalh ju akxtujun vati chai ju pamata. Xtaknilh lhak'ailakts'in ju Dios. Chai astan lacch'ek'elh chai axtaknilh ju ix'amamaka'ui. Chai ju yu'unch ta'alhilaktsak'o tachi chun ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pus tavenk'o ixchux'an chai talhilalh. Chai astan tasacchokolh ju jantu ta'ok'o. Cha'alh lakatujun tank'alin. ");
INSERT INTO teeNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pus ju anuch ju tavailh ixcha'anta lakat'at'i milh jok'atni. Ju chakolun chai ju ask'at'an jantu aputek'ecalh. ");
INSERT INTO teeNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Pus ju Jesús amac'ami ju lapanacni. Taju lacabarco chai alh vanin ju lak'achak'an Magdala. ");
INSERT INTO teeNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ju fariseonin chai ju saduceonin talakmilh ju Jesús. Chai ni va ixtapuxconiputun ixtalak'alhin pus tatapaininilh ni canavilh lakatam lhamak'an ta yu laich catapuc'atsaya' ni vasalh Dios ju camalakachachilh. ");
INSERT INTO teeNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Para ju yuchi chani alhik'alhtailh: ―Ju tok'oxai acsni slapulh tasui ju lact'iyan pus ju uxijnan nonat'it ni k'oxich ca'avanana' ju ani laquint'un'an. ");
INSERT INTO teeNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Chai ju vats'isin acsni na slapulh tasui ju ataputs'i pus ju uxijnan nonat'it ni calayach ju xcan ju ani laquint'un'an. Pus ju uxijnan lai mach'akxayat'it ta yu avanan ju lact'iyan. Para va acxp'ut'iyununat'it ni nonat'it ni jantu lai mach'akxayat'it tuchi nomputun ju lhamak'an ju icnavit'ajun ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Pus ju lapanacni ju tat'ajun ju chavai na k'ai tajunita chai tamacajunta ju Dios. Chai yu'unchach ju tasq'uin tu'u' lhamak'an. Para jantu cati'axtaknicalh tu'u' atumpa. Va yuchi tachi ju tapasalh la'is'atsucunti ju Jonás. Chai acsni naulh ju chunch ju Jesús pus lana amacaulh. Alh. ");
INSERT INTO teeNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Pus ju ix'amamaka'ui ju Jesús tatapasalh ju lhimak'antacutni ju atants'in chai acsnica' ju tapastacli ni va ixtacapta ju ixkapavati'an. ");
INSERT INTO teeNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Pus ju acsnich ju Jesús alacjuni: ―Alacc'ats'anant'it ixlacata ju ixlevadura'an ju fariseonin chai ju saduceonin. ");
INSERT INTO teeNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pus ju ix'amamaka'ui talaclajuni sia yu'unch: ―Quintajunan chunch ni jantu lhimintau ju tu'u' xkapavati. ");
INSERT INTO teeNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Para ju Jesús c'atsa ni chunch ixtalajuni is'akstu'an chai alacjuni: ―Tajuch ni va lhamak'anininat'it ni jantu lhit'ant'at'it ju tu'u' xkapavati. Na lacats'unin ju quilalhilaksiyau. ");
INSERT INTO teeNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ja va jantuca' mach'akxayat'it tuchi nomputun ju lhamak'an ju icnavita. Ja va jantu p'ast'act'it ju anu' akxquis vati ju ta'ulh ju lakaquis milh jok'atni. Ja va jantu p'ast'act'it ta lakachux tank'alin ju sacch'ok'ot'it. ");
INSERT INTO teeNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chai ja va jantu p'ast'act'it ju akxtujun vati ju ta'ulh ju lakat'at'i milh jok'atni. Chai ja va jantu p'ast'act'it ta lakachux tank'alin ju sacch'ok'ot'it. ");
INSERT INTO teeNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Tajuch ni jantu lai mach'akxayat'it ni jantu xaclhichivinin ju tu'u' xkapavati acsni iclajunau ni alhic'ats'anant'it ixlacata ju ixlevadura'an ju fariseonin chai ju saduceonin. ");
INSERT INTO teeNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Pus acsnica' ju tamachakxa ni jantu va xalevadura ju xkapavati ju lhichivincalh. Alai ajuni ni calacc'atsanalh ixlacata ju ix'amalaninti ju fariseonin chai ju saduceonin. ");
INSERT INTO teeNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ju Jesús acsni milh vanin ju lak'achak'an Cesarea Filipo pus asacmilh ju ix'amamaka'ui. Alacjuni: ―Tas tanajun ju lapanacni. Tis chavaich quintalhiulai ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Chai ju yu'unch tajuni: ―Pus ju ali'in tanajun ni ma Xivan'at ju ix'amakpaxanan. Chai ju ali'in tanajun ni ma Elías'at. Chai ju ali'in tanajun ni ma Jeremías'at u ak'antam mak'aniya lapanac unit'a ju ixnajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Pus ju acsnich ju Jesús ajunchokopa: ―Chai ju uxijnan t'as nonat'it. Tis chavaich ju quilalhiulayau ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pus ju Simón Pitalu' naulh: ―Uxint'ich ju Cristo'at ju ixnoncan camalakachatachilh ju Dios. Ists'alh'at ju Dios ju lak'ajunta. ");
INSERT INTO teeNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Chai ju Jesús juni: ―Va paxcatch'at ji Simón ists'alh Jonás. Jantu va xamati' mint'alapanac ju xamasuniyan ju chunch. Va is'akstu quimpai ju vilhcha lact'iyan ju xamavasalaniyan chunch. ");
INSERT INTO teeNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Chai ju quit'in icjunan ni lhijunch ni Pitalu' unc'an ni vasalh chunch unit'a tachi ju tu'u' chiux chai chunch ju nomputun ju mintapaka'ut. Pus jantu va tam tam na'un ju uxint'i. Chai vachu' chux ju quilapanacni catalaca'iya' ju chivinti ju xana'un ju quilacata. Chai nin yuchi ju Satanás jantu lai cati'amac'ap'ani ju quilacata quit'in mas na tachapun junita ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Chai acxtakniyan ju uxint'i ju mintachaput ni xak'ai a'una' sia yu'unch ju talak'a'ita ni calhinaulh ju Dios la'is'atsucunti'an. Chai tachi chun ju jantu alak'a'iya' ju uxint'i ni catanavi ju yu'unch pus vachu' jantu calak'a'iya' ju Dios ju vilhcha lact'iyan. Chai tachi chun ju alak'a'iya' ni catanavi pus vachu' chunch calak'a'iya' ju Dios ju vilhcha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Pus ju acsnich ju Jesús alhimap'aksilh ju ix'amamaka'ui ni jantu xamati' catamac'atsani ni yuchach ju Cristo junita. Yuchi ju ixnoncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Pus tus acsni ju Jesús tai'ula ix'ajunica ju ix'amamaka'ui ni tasq'uini ni ca'alh ju lak'achak'an Jerusalén. Chai ju anch ma slivasalh na catamamak'alhk'ajniya' ju papaninch chai ju xalack'ajin palijni chai ju na talhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Chai ju anch ma camaknicana'. Para ma calok'onchokoya' ixlhilakat'utu avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pus ju acsnich ju Pitalu' t'asanilh va is'akstu ju Jesús. Lhi'alh alacatam chai tsuculh map'aksini'. Chani ju juncan ju Jesús: ―Ju Dios ca'aktaijuyan laca'amapaininti chai jantu tavanan chunch at'ap'asaya' ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Para ju Jesús talakasp'itlh chai chani ju junilh ju Pitalu': ―Ak'ost'ich ju laqui'ucxlacapu' ji lhacaticuru. Ju uxint'i va quimak'alhk'osup'ut'un. Ju uxint'i jantu chun alacp'ast'acnan tachi ju Dios. Ju uxint'i va alacp'ast'acnan tachi ju mint'alapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ju acsnich ju Jesús alacjuni ixchux'an ix'amamaka'ui: ―Ni xamati' quinch'ak'ok'aputun pus jantu lai canavilh ixk'achat is'akstu. Chai cach'ixa' ju mak'alhk'ajnat ju ca'alina' va ixlaca'atalh ni quinch'ak'ok'ai ju quit'in. Chai aquinch'ak'ok'ak'alhi. ");
INSERT INTO teeNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pus va tichi chavaich ju najun ni jantu quinch'ak'ok'aputun va ixlaca'atalh ni va lai maknicalh pus ju yuchi camak'ats'ank'aya' ju xa'atsucunti ju lact'iyan. Para va tichi chavaich ju camak'ats'ank'aya' ju is'atsucunti va ixlaca'atalh ni quinch'ak'ok'ai ju quit'in pus ca'alina' ju is'atsucunti ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Pus jantu tu'u' lhajai tam lapanac mas calhajak'o chux ju xataxtokni ju alin ju ani lacamunutpa' para ni va calhimak'ats'ank'a ju is'atsucunti ju ca'ix'alilh ju lact'iyan. Pus ni va chunch ju calalh pus jantu lai cati'alh ju anch mas camapalalh lacatumin. ");
INSERT INTO teeNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Pus vasalh chani ju catapasaya' ni acminchokoya' ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Acmina' la'ixtachaput ju quimpai. Chai ac'alact'amina' ju qui'anquilhnin. Chai ju acsnich ac'axtakniya' ju pumatamin tachi ju lhijunch ixlacata tuchi tanavita la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Slivasalh ju iclajunau. Alin ju lamilhi'uxijnan ju ani vilat'it ju jantu cataniya' tus acsni aquilalakts'inau ju quit'in acsni acminchokoya' chai aclhinona'. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Pus ixlhilakachaxan avilhchan astan pus ju Jesús at'asanilh ju Pitalu' chai ju Jacobo chai ju Xivan. Isp'isek'e ju Jacobo. Alhi'alh va is'akstu'an ju lactalhpa junta na putank'ai ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chai ju anch na tamch ju atalacasunilh ju yu'unch. Pus ju ix'ucxpu' slap'ap'a ixmaktaji tachi ju avilhchan. Chai ju ixpumpu' lana na xnapapa va tachi ju tu'u' atuncunu'. ");
INSERT INTO teeNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Chai vachu' talacasucha ju Moisés chai ju Elías ju mak'anchich ixtat'ajun. Ixtat'achivininch ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pus ju acsnich chani juni ju Pitalu' ju Jesús: ―Qui'ucxtin slivasalh na k'ox ni ani vilau. Ni lac'asq'uinch acyoyau ak'at'utu pac'ats'a. Ak'atam ju mi'anu'. Ak'atam ix'anu ju Moisés. Chai ju ak'atam ix'anu' ju Elías. ");
INSERT INTO teeNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pus acsni ixt'ajunca' chivini' ju Pitalu' lana tamacatalh ju ataputs'i ju k'ai slamnic'a ixjunita. A'akxtakmak'o ju yu'unch. Chai tak'asmatlh lakatam chivinti ju xaminacha laca'ataputs'i chai chani xanajun: ―Ju ani ya yuchi ju quints'alh chai na icmapaini. Slivasalh na iclhik'achan ju yuchi. Yuchach ju ak'asmatnit'it. ");
INSERT INTO teeNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Pus acsni tak'asmatlich ju ix'amamaka'ui ju Jesús pus lana tataquilhputalh ni na ixtatalhanan. ");
INSERT INTO teeNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Pus ju acsnich ju Jesús lana alak'alh. Apicla chai chani alacjuni: ―Ak'ost'olat'it. Jantu at'alhanant'it. ");
INSERT INTO teeNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Pus ju yu'unch acsni ta'alac'avanalh jantu xamati' talakts'ilh. Va is'akstu ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Chai acsni ixtat'ajun tak'alhtajunin ju anu' lactalhpa pus ju Jesús alhimap'aksilh ju ix'amamaka'ui. Chani ajuni: ―Tun xamati' t'i'unit'it ju tuch'i xalakts'inat'it. Va acsnich ju lai anona'it'it acsni aclok'onchokoya' junta acmacnucana'. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Pus ju acsnich ju ix'amamaka'ui tasacmi ju Jesús. Tajuni: ―Ju yu'unch ju na talhatalanininta ju quilhamap'aksin'an tajuch ni va tanajun ni tasq'uini ni p'ulhnan camilh ju Elías. Astan ju yuchi ju camalakachayachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Chai ju Jesús alacjuni: ―Slivasalh tachi ju tanajun ni p'ulhnan camina' ju Elías chai calak'oxik'oya' tachi chun ju taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Para iclajunau ni quilachilh ju Elías chai ju lapanacni jantu ixtamispai. Alai va tanavilh tachi ju talacasq'uilh. Chai vachu' ju quit'in aquintamamak'alhk'ajniya' ju yu'unch. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Pus ju acsnich ju ix'amamaka'ui tamachakxalh ni yuchi ju Xivan ju amakpaxana' ju ix'alhixak'alai tachi ju va Elías ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Pus acsni tacha'alh ju Jesús chai ixpumat'utu'an ix'amamaka'ui junta ixtayanancha ixtalhavat lapanacni pus lana lakmilh ju Jesús pumatam lapanac. Ta'aktsokotanilh chai junich: ");
INSERT INTO teeNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Ji qui'ucxtin lamapainin a'akt'ai'ut'ich ju quints'alh. Ju yuchi va lhtucuni chai na mak'alhk'ajnan. Na paklhu ju xata'aktai ju lacajipi chai lacxcan. ");
INSERT INTO teeNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ic'alhiminita ju mintamamaka'un para ju yu'unch jantu lai palai tanavi. ");
INSERT INTO teeNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Chai ju Jesús ak'alhtayanalh. Ajunich: ―Tis va yuchach ji lapanacni ni lana jantu lai lac'a'iyat'it. Lana jantu sok p'inat'it. Ja tasq'uini ni lana na mak'an aclat'atolau tus acsni amach'akxaya'it'it. Ja tasq'uini ni lana na mak'an aclach'ixniu tus acsni alac'a'iya'it'it. Aquilalhiminiuch ju anu' ts'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Chai acsni talhiminilh pus ju Jesús k'ailh ju lhacaticuru ju ixtanun la'ixlacatuna ju ts'alh chai lana taxtulh. Pus ju ts'alh palai va ju acs pants'iquis. ");
INSERT INTO teeNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ju astan ju ixtamamaka'un talak'alh ju Jesús va is'akstu'an chai tajuni: ―Tajuch ni jantu lai xacxcoxtuyau ju lhacaticuru la'ixlacatuna ju anu' ts'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Chai ju Jesús alacjuni: ―Ju uxijnan jantu lai xaxc'oxt'uyat'it ju lhacaticuru la'ixlacatuna ni jantu vasalh quilalhilaksiyau. Slivasalh ju iclajunau. Ni aquilalhilaksiyau mas va lacats'unin pus laich a'una'it'it ju ani talhpa ni cak'oslh. Ca'alh alacatam. Chai chunch ju catapasaya'. Ni vasalh aquilalhilaksiyau pus va tuchi ixtalakxtuch ju aquilasq'uiniyau pus anavinic'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Para ju lhacaticurulhni tachi ju ixtanun la'ixlacatuna ju anu' ts'alh va acsni ju catataxtuya' acsni at'ap'aininiya'it'it ju Dios ju ixlacata chai at'asc'a'aya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Acsni ix'alact'a'ucxunt'ajun ju Jesús ju ix'amamaka'ui ju xa'estado Galilea pus ju Jesús ajunchokopa ni camak'axtakcana' la'ixmaca'an ju lapanacni. Yuchi ju malakachatachilh Dios ni lapanac catsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Vachu' ajunilh ni catamakniya' para ixlhilakat'utu avilhchan calok'onchokoya'. Pus ju ix'amamaka'ui slivasalh na ta'amak'aninilh acsni tak'asmatnilh ixchivinti ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Acsni alact'acha'alh ju Jesús ju ix'amamaka'ui ju lak'achak'an Capernaum pus talak'alh ju Pitalu' ju lapanacni ju ixtapusac'a ju tumin ixlacata ju ixpujitat'an ju ist'a'israelitanin. Tajuni: ―Ju mi'amamaka'unu' ja amapalanan ju tamin c'ata ixlacata ju quimpujitat'an. ");
INSERT INTO teeNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pus ju Pitalu' junilh ni akts'iya amapalanan. Pus ju yuchi tanulh lacachaka' chai ju Jesús lana xak'ala. Juni: ―T'as na'unch ju uxint'i ji Simón. Ju xalack'ajin ju ani lacamunutpa' tis chavaich ju tach'i junta ast'anancan. Ja amachak'an anch u yu'unch ju alacatam tamintacha. ");
INSERT INTO teeNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chai ju Pitalu' juni: ―Pus yu'unch ju alacatam tamintacha. Pus ju acsnich ju Jesús juni: ―Pus ju chunch jantu tasq'uini ni cati'amapalanalh ju amachak'an anch. ");
INSERT INTO teeNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Para chani alat'i ni jantu catatalhk'amalh ju lapanacni chai catanaulh ni jantu tu'u' lhiulayau ju quimpujitat'an. Inchich laca'atants'in. Amuya'ich ju mimpaklava'in. Chai amac'ut'uch ju pamata ju p'ulhnan caquilhtanuya' ju mimpaklava'in. Amak'alhk'aya'ich chai alhit'a'uya'ich ju tumin. Ach'ap'ach. Alhimap'ala'ich ju quilacata chai ju milacata. ");
INSERT INTO teeNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ju acs avilhchan talakcha'alh ju Jesús ixchux'an ju ix'amamaka'ui chai tajuni: ―Tis chavaich ju palai xak'ai cajuna' acsni calhinona' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Pus ju acsnich ju Jesús t'asanilh pumatam ask'at'a. Yaulh la'ixlacaitat'an. ");
INSERT INTO teeNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Chai alacjuni: ―Slivasalh ju iclajunau. Ni jantu amap'axaya'it'it ju mi'atsucunti'an chai ni jantu ixlhichux ju mi'alhunut'an a'unt'it tachi ju tam ask'at'a ju jantu lhitak'ayai ju tu'u' pus jantu tavanan lai at'it'anut'it junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Pus va tichi chavaich ju jantu tu'u' calhitak'ayaya' tachi ju lai ju ani ya ask'at'a pus yuchach ju palai xak'ai cajuna' junta lhinajun ju Dios ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Chai va tichi chavaich ju lhik'ach ca'amaklhtayanana' ju tam quilapanac ju jantu tu'u' lhitak'ayai tachi ju lai ju ani ya ask'at'a pus tachi ju va jun quit'in ju qui'amaklhtayanan. ");
INSERT INTO teeNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Va tichi chavaich ju camak'alhk'osuya' tam xamati' ju jantuca' k'ox quilhilaksi pus palai k'ox ca'ixva ni ca'ixpixtuch'imuc'acalh ju tsasnatpuch'ipi chai ca'ixmaca'ancalh junta palai talhman laca'alama acsni tuca' ixmak'alhk'osui tam xamati'. ");
INSERT INTO teeNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Paini'itnich ju lapanacni ju tat'ajun ju ani lacamunutpa' ni akts'iya na alin ju puk'alhk'oscan. Para painich ju anu' lapanac ju camak'alhk'osu apumatam. ");
INSERT INTO teeNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Pus ni p'alact'u'unump'ut'unat'it ju mimaca'an pus jantu anavit'it. U ni anch ju p'imp'ut'unat'it junta ak'alhk'osa'it'it pus jantu ap'it'it ju anch. Alai alat'it tachi ju va ch'akxp'uxt'at'it chai mak'ant'at'it ju mimaca'an u minch'aja'an. Pus palai k'ox cava ni at'anuya'it'it ju lact'iyan mas va lakatamch ju mimaca'an u minch'aja'an. Palai jantu k'ox cava ni ap'acxant'it chux lakat'ui mimaca'an u minch'aja'an para va ap'umac'ap'inc'ant'it ju lacajipi. ");
INSERT INTO teeNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","U ni yuchi ju lakts'imp'ut'unat'it ju tamalactu'uniyan pus jantu alakts'int'it. Alai alat'it tachi ju va maxt'ut'at'it chai mak'ant'at'it ju milakchulh'an. Pus palai k'ox cava ni at'anuya'it'it ju lact'iyan mas va lakatamch ju milakchulh'an. Palai jantu k'ox cava ni ca'alilh chux lakat'ui ju milakchulh'an para va ap'umac'ap'inc'ant'it ju lacajipi. ");
INSERT INTO teeNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jantu tavanan ju va jantu tu'u' alhiulat'it ju uxijnan tam xamati' ju jantu tu'u' lhiulacan ju ani lacamunutpa'. Iclajunau chunch ni va tachi tayanancha lact'iyan ju anquilhnin ju ta'alhist'ac'a ju yu'unch. Vanin tayanalh junta vi ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Chai ju quit'in yuchi iclhimilh ju ani ni laich ac'amak'alhtaxtuya' ju istats'ank'ata. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Pus t'as nonat'it. Ju tam xamati' ni capacxalh tachi tam cientos ixborregojni chai ni camak'ats'ank'a lactalhpa lakatam ja jantu camacaulh ju noventa y nueve chai ca'alh puxcona' ju ists'ank'ata. ");
INSERT INTO teeNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Pus slivasalh ju iclajunau. Acsni calhitajuyach ju yuchi ju ists'ank'ata pus palai na calhik'achana' ju yuchi. Palai jantu ju noventa y nueve ju jantu istats'ank'ata. ");
INSERT INTO teeNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Pus vana va chun ju mimpai'an ju vilhcha lact'iyan. Ju yuchi jantu lacasq'uin ni cats'ank'a nin tachi pumatam ju sia yu'unch ju jantu tu'u' lhiulacan ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ju tam milhilak'au ni calactu'uyan pus inchich junini' va is'akstu. Chai ni calhilatola' chai catapaininiyan ni amac'acxaniya' pus akt'ai'ut'ach ju milak'au chai jantu camamak'alhk'ajnicana' ixlacata ju anu' xanavi. ");
INSERT INTO teeNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Para ni jantu lhilatolai pus ak'ailhip'i tachi pumatam u pumat'ui. Ju chunch ca'alina' pumat'ui u pumat'utu ju catak'asmatniya' ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Para ni jantu calhilatola' la'ix'ucxlacapu'an ju yu'unch pus a'unch chux ju tatak'aixt'ok'a ni talak'ayai ju Dios. Para ni jantu calhilatola' la'ix'ucxlacapu'an ju yu'unch pus alhimisp'at'ich tachi tam xamati' ju jantu mispai ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Slivasalh ju iclajunau ju uxijnan ju quilapanacni unt'at'it. Tachi chun ju jantu alak'a'iya'it'it ni catanavi ju yu'unch ju quintalhilaksi pus vachu' jantu calak'a'iya' ju Dios. Chai tachi chun ju alak'a'iya'it'it ni catanavi ju yu'unch ju quintalhilaksi pus vachu' calak'a'iya' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Vachu' iclajunau ju ani. Ni alin ixt'iyun'an ju milhi'uxijnan ju va lakatam catanaviya' ix'atalacpast'ac'at'an ixlacata ju tuchi tasq'uiniputun ju Dios pus ca'anaviniya' ju quimpai ju vilhcha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pus ca'anavinicana' ni quit'in ju ic'alact'avi ixpumat'ui u ixpumat'utu'an ju tatak'aixtokta ni quintalak'ayai. ");
INSERT INTO teeNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pus ju acsnich ju Pitalu' lak'alh ju Jesús chai juni: ―Ta pakchux ju acmac'acxaniya' tam quilak'au ju quinavinit'ajun tu'u' macxcai. Ja paktujun. ");
INSERT INTO teeNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Para ju Jesús junich: ―Jantu icjunan ni va paktujun. Para tus va ta pakchux. ");
INSERT INTO teeNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Iclajunau ni alamac'acxaya'it'it ni tamac'acxanitan ju Dios. Pus chani tapasai junta lhinajun ju Dios tachi ju tapasalh la'is'atsucunti pumatam k'ai ucxtin ju at'anavilh ju aput'ek'enti ju ixtalhi'anich. ");
INSERT INTO teeNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Pus acsni tai'ulalh ju aput'ek'enti pus lhiminicalh pumatam ju ixlhi'anich lakacau milh oro tumin. ");
INSERT INTO teeNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Para ju yuchi ni jantu lai jinta' ix'i ju ixlhimapalhcan pus ju ix'ucxtin lhinaulh ist'aca ju yuchi chai ju ix'amachaka' chai is'ask'at'an chai tachi chun ju ixtaxtokni. Chai caxtaknicana' ju ucxtin mas va yuchi ixtapalh tachi chun ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pus ju acsnich ju anu' lapanac ta'aktsokotanilh ju ix'ucxtin chai tapaininilh. Junich: “Qui'ucxtin aq'uimp'acxaca' lacats'unin chai acmapalhnik'oyan chux”. ");
INSERT INTO teeNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Pus ju anu' ucxtin mapainilh ju anu' ixlapanac chai xacanilh ju ix'alhi'aninti chai junilh ni laich ca'anchokolh la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Para ju yuchi acsni taxtulh lana t'alapakxtoklh apumatam ju vachu' ixlapanac ixjunita ju k'ai ucxtin. Chai ju yuchi ixlhi'ani ixt'axalapanac tam cientos oro tumin. Pus lana ch'apalh chai tsuculh pixtupalhitni. Juni: “Aq'uixt'aknin ju q'uilhip'ini”. ");
INSERT INTO teeNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Pus ju acsnich ju ixt'axalapanac ta'aktsokotanilh vanin la'ixch'aja' chai tapaininilh. Junich: “Aq'uimp'acxaca' lacats'unin chai acmapalhnik'oyan chux”. ");
INSERT INTO teeNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Para ju yuchi jantu ixpacxamputun. Alai alh chivimak'ana' chai lhinaulh ixt'alhnuca tus camapalach ix'alhi'aninti. ");
INSERT INTO teeNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Pus ju ixt'axalapanacni talakts'ilh tuchi ixnavican chai lana na ta'amak'aninilh. Pus ta'alh juninin ju ix'ucxtin'an tachi chun ju ixtalakts'inta. ");
INSERT INTO teeNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Pus ju acsnich ju ix'ucxtin t'asanilh chai junilh: “Tis va yuchach ji lapanac ni na va k'ai unit'a. Tachi chun ju anu' ju xaq'uilhip'ini icxacak'o acsni q'uint'ap'ainininch. ");
INSERT INTO teeNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ja jantu vachu' ixlhijun ni ix'amap'ainit'i ju mint'axalapanac tachi ju icmapainin ju uxint'i ju quit'in”. ");
INSERT INTO teeNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Pus ju acsnich ju ix'ucxtin slivasalh na talhk'amalh. Chai mak'axtaknilh ju lapanacni ju tamamak'alhk'ajni tus acsni jantu mapalhk'ojui ju ix'alhi'aninti. ");
INSERT INTO teeNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Chai ju Jesús tailhi'alh ixchivinti. Alacjuni ju lapanacni: ―Pus chunchach vachu' ju uxijnan. Ju quimpai ju vilhcha lact'iyan vana va chunch catanaviyan ju uxijnan ni jantu amac'acxaniya' ixlhichux mi'alhunut'an ju tam milhilak'au ni tu'u' catanaviniyan. ");
INSERT INTO teeNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Pus ju Jesús acsni nonk'o junima chivinti pus taxtulh ju xa'estado Galilea. Alh ju xa'estado Judea lhimak'antacutni ju k'ai xcan Jordán. ");
INSERT INTO teeNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Chai na lhu lapanacni tach'ak'ok'alh chai ju Jesús palai anavicha ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Chai vachu' talakchincha ju ali'in fariseonin. Va ixtapuxconiputun ixtalak'alhin chai yuchi chani talhisacmilh: ―Ja lhijun ju lhamap'aksin ni calhimacaulh ju ix'amachaka' tam lapanac va ixlaca'atalh tu'u' lacats'unin ju jantu k'ox lhiulai. ");
INSERT INTO teeNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Chai ju Jesús chani ak'alhtailh: ―Ja va jantu lakts'int'at'it la'ixchivinti Dios ju ts'okcanta junta najun ni yuchi ju Dios ju anavilh ju p'ulhnan lapanacni. Chai navilh pumatam ts'alh chai pumatam atsi'. ");
INSERT INTO teeNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Chai ju Jesús vachu' alacjuni ni alacatam la'ixchivinti Dios ju ts'okcanta najun ni yuchi calhimaconach ju tam lapanac ju ixpai chai ixnati chai cat'atsucuyach ju ix'amachaka'. Chai ju anu' ixpumat'ui'an tachi ju va pumatam catajuna'. ");
INSERT INTO teeNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Chai tailhi'alh ixchivinti ju Jesús. Alacjuni: ―Pus jantuch vana pumat'ui lapanacni tajunita. Alai tachi va pumatam lapanac tajunita. Pus ju malakxtokta ju Dios jantu catitalaclhvaklh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Pus ju acsnich chani tajuni ju fariseonin: ―Pus ni chunch ju lhilhcata ju Dios tajuch ni va naulh ju Moisés ni caxtaknicalh pumatam chako'ulh lakatam alhiqui ju pulamacau chai camacaulh. ");
INSERT INTO teeNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Chai ju Jesús alacjuni: ―Va ixlacata ni na p'as ju mi'alhunut'an yuchi lhinaulh ju Moisés ni laich amac'a'unt'it ju mi'amachaka'an. Para ju la'ixputai'ulacan ju lacamunutpa' jantu chun ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Chai iclajunau ni va acsnich ju lai mac'onat'it ju mi'amachaka'an ni va t'at'ajun apumatam jok'at. Para ni va k'aya mac'onat'it ju mi'amachaka'an chai t'ats'uc'uch'ok'oya'it'it apumatam pus alactu'unti ju naviyat'it. Chai va tichi chavaich ju cat'atsucuchokolh ju va maconcanta vachu' alactu'ununch. ");
INSERT INTO teeNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Pus ju acsnich ju ix'amamaka'ui tajuni: ―Pus ni chunchach lhi'ucx'anta ixlacata ju jok'at chai ix'amachaka' pus ca palai k'ox ni jantu tavanan catamak'axtoklh ju jok'at. ");
INSERT INTO teeNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Para ju Jesús alacjuni: ―Para jantu si lai catitamuctaxtulh tachi ju xanonat'it. Va yu'unch ju axtaknita ixtachaput'an ju Dios ni lai catamuctaxtulh. ");
INSERT INTO teeNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Pus alin lapanacni ju tak'alhinita ixlacatuna'an tus la'ixpulak'au'an chai yuchi jantu lai catalhitamak'axt'ok'a'. Chai alin lapanacni ju alak'alhinita ixlacatuna'an ixt'alapanac ni jantu lai catitamak'axtoklh. Chai alin lapanacni ju va is'akstu'an tanajun ni jantu catamak'axt'ok'a' ni va jantu talacasq'uin ni tu'u' ca'asastuclh acsni ta'ajuni ju lapanacni ixlacata ju Jesús. Pus ju laich camuctaxtulh ju chunch pus chach navi. ");
INSERT INTO teeNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ju acsnich alhiminicalh ju Jesús ju ask'at'an ni ca'amokslanilh ixmaca' la'ixlacatuna'an chai catapaininilh ju Dios ixlacata'an ni laich k'ox catatsucuya'. Para ju ix'amamaka'ui ju Jesús ta'alack'aima ju ixtalhicha'an is'ask'at'an. ");
INSERT INTO teeNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Para ju Jesús alacjuni: ―Amac'a'unt'it ju ask'at'an. Chach quintalakmilh. Jantu asasp'it'it ni quintalhilaksich ju yu'unch. Chai va tichi chavaich ju aquilhilaksiya' tachi ju quintalhilaksi ju ani tayanalh ask'at'an yuchi ju laich catanuyanta ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Pus ju acsnich ju Jesús amokslanilh ixmaca' la'ixlacatuna'an ju ask'at'an. Astan taxtuchokolh ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Chai chincha pumatam ts'alh chai chani juni ju Jesús: ―Amamaka'unu' ju uxint'i na k'ox lapanac'at. Aq'ui'unch. Tamalhch ju k'oxich ju acnavi ni ca'alilh ju qui'atsucunti ju conk'alhiyanta ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Chai ju Jesús juni: ―Ju uxint'i ni na'un ni va iclapanac pus tajuch ni q'ui'unich ni ick'ox. Jantu xamati' ju k'ox cava. Va yuchi ju Dios. Para ni p'acxamp'ut'un ju mi'atsucunti ju conk'alhiyanta lact'iyan pus amuct'axt'ut'i tachi ju najun lacalhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Chai ju anu' ts'alh juni: ―Tamalhch. Chai ju Jesús juni: ―Jantu amaknit'i xamati'. Jantu at'ats'uc'u ju jantu mi'amachaka'. Jantu ak'alhaun. Jantu anauch ta'aklhtamat chivinti ixlacata apumatam. ");
INSERT INTO teeNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","At'alhonin ju mimpai chai minatich. Chai amap'ainit'i ju mint'alapanac tachi ju va jun mi'akstu ju map'ainich'ok'oc'an. ");
INSERT INTO teeNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Chai ju ts'alh juni: ―Tachi chun ju ani icmuctaxtuk'ota tus quilhitalacat'icst'in. Tijuch ali' ju quinc'acxni. ");
INSERT INTO teeNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Chai ju Jesús juni: ―Pus ni vasalh lac'asq'uin ni jantu tu'u' camak'anc'acxniyan ni laich amaklht'ayanana' ju atsucunti ju jonk'alhita pus a'inchich. Ast'achich ju mi'alinta chai axt'akniya'ich ju quilhpatinin tachi chun ju amak'aixt'ok'a'. Ju chunch ca'alinach ju mimak'alit ju lact'iyan. Chai acsni anavik'oya' ju chunch pus at'at'ich. Aq'uinch'ak'ok'aya'ich. ");
INSERT INTO teeNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Para ju anu' ts'alh acsni k'asmatlh ju ani chivinti lana amak'anini'alh ni na lhu ix'alin ju ixmak'alit. ");
INSERT INTO teeNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ju acsnich ju Jesús chani alacjuni ju ix'amamaka'ui: ―Slivasalh ju iclajunau. Na k'ox lhixcai ni lai catanu ju lact'iyan junta lhinajun ju Dios tam mak'ali'. ");
INSERT INTO teeNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Aktam iclajunchokopalau ni na xcai ni lai catanu lact'iyan tam mak'ali'. Tachi ju tu'u' camello ni jantu lai catitapasalh junta tilhucucu ju macscat pus vana va chun ju tam mak'ali'. Ju yuchi jantu lai cati'alh ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Pus ju ix'amamaka'ui acsni tak'asmatlh ju ani chivinti slivasalh na talhamak'aninilh. Chai tanaulh: ―Pus tis chavaich ju lai catak'alhtaxtulh. ");
INSERT INTO teeNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Para ju Jesús alakts'ilh chai alacjuni: ―Pus ju va lapanac akts'iya palai tu'u' lhiulai ju ixmak'alit. Palai jantu ixtaxtokni ju Dios. Para ju Dios jantu tu'u' xcai lhiulai. Ju yuchi lai mapaxani ix'atalacpast'ac'at tam lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pus ju acsnich ju Pitalu' chani juni ju Jesús: ―Pus ju quijnan icmaconk'otauch chux quintaxtokni quinc'an chai iclach'ak'ok'atauch. Ju chavai tijuch ju aclhajayau ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Chai ju Jesús juni: ―Pus acsni catasast'ichokoya' chux ju lacamunutpa' pus actola' laquimpu'ucxtin ju slivasalh na k'ox cajuna'. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Chai ju uxijnan ni quilach'ak'ok'ayauch ju chavai pus ju acsnich vachu' at'ola'it'it lacalakacaut'ui pu'ucxtin. Chai alhi'una'it'it ju ixquilhmaccaut'ui'an ju mint'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Pus va tichi chavaich ju calhimacaulh ju ixchaka' u tam ixlak'au ts'alh u tam ixlak'au atsi' u tam ixpai u tam ixnati u tam ix'amachaka' u is'ask'at'an u ixlacat'un va ixlacata ni quinch'ak'ok'ai pus palai lhu caxtaknicana'. Jantu chun tachi ju macaulh ju quilacata. Chai vachu' ca'alina' is'atsucunti ju conk'alhiyanta ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Para ju lact'iyan ca'alina' lapanacni ju mak'anch xaquintalhilaksi. Para jantu lai actinaulh ni va ixlhiyuchi palai k'ox ca'alhilhiulacalh. Palai jantu ju ali'in. Chai vachu' cata'alina' lapanacni ju jantuca' mak'an xaquintalhilaksi. Para jantu lai actinaulh ni va ixlhiyuchi palai jantu k'ox ca'alhilhiulacalh. Palai k'ox ca'alhiulacalh ju ali'in. ");
INSERT INTO teeNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ju Jesús vachu' chani alacjuni ju lapanacni: ―Junta lhinajun ju Dios chunch ju tapasai tachi ju tapasalh la'is'atsucunti pumatam lapanac ju ix'alin ixpu'uvas. Pus ju yuchi vats'isin alh apuxcona' ju catap'uxnilh ju ix'uvas. ");
INSERT INTO teeNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Chai acsni at'atak'oxilh ju makch'alhcatnin ni ca'amapalhniya' tachi ju akts'iya talhajai ju tamin avilhchan pus amalakachalh la'ixlhich'alhcat. ");
INSERT INTO teeNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Pus ju amat'un taxtuchokolh tachi lakanajatsi hora vats'isin chai alakts'inchokolh ju ali'in ju va ixtavilanancha laclhitamau. Mati' ixjunita ixlhich'alhcat'an. ");
INSERT INTO teeNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Chai alacjuni: “Ap'it'it vachu' ju uxijnan laquilhich'alhcat. Chai aclamapalauch tachi ju k'oxich cava”. Pus ju yu'unch ta'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chai ju anu' amat'un aktam taxtuchokolh tachi ju k'atuncuj chai aktam tachi ju lakat'utu hora atok'oxana'. Chai vana va chun amalakachalh ju lapanacni la'ixlhich'alhcat. ");
INSERT INTO teeNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Chai acsni taxtuchokopa tachi ju lakaquis hora atok'oxana' pus alhitajuchokopa ju ali'in ju mati' ixjunita ju ixlhich'alhcat'an. Chai alacjuni: “Tajuch ni va anich ju vilat'it ju tontacuj ni jantu tu'u' ju naviyat'it”. ");
INSERT INTO teeNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Chai ju yu'unch tajuni: “Pus jantu xamati' quintaxtaknitan ju lhich'alhcat”. Pus ju acsnich ju anu' amat'un alacjuni: “Ap'it'it vachu' ju uxijnan laquilhich'alhcat. Chai aclamapalau tachi ju k'ox cava”. ");
INSERT INTO teeNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Pus ta'alh. Chai astan acsni tok'oxalh pus ju amanavin lhich'alhcat chani junilh ju ixlapanac ju ix'amapalai ju ixtach'alhcatnan: “At'asaninch ju makch'alhcatni lapanacni. Amap'alht'ich ix'avilhchan'an. Ap'ut'ai'ulat'i ju astan tacha'alh. Ap'umaclaya'ich ju p'ulhnan xatacha'an”. ");
INSERT INTO teeNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Pus ju acsnich tachincha ju ixtacha'anta ju lakaquis hora atok'oxana' chai axtaknicalh tachi ju akts'iya lhajacan acsni ch'alhcatnancan tam avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Chai astan acsni tamilh ju p'ulhnan ixtacha'anta pus ju yu'unch ixtanajun ni ca palai laklhu camapalhcana'. Para vana va chun axtaknicalh tachi ju akts'iya lhajacan ju tamin avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Pus acsni ta'amaklhtayanalh ixtalhaja'an pus tatalhk'amnilh ju anu' amanavin lhich'alhcat. ");
INSERT INTO teeNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Tajuni: “Ju ani ju astan xatachinacha va tam hora xatach'alhcatnan para ni vana va chun ju xa'amap'alhp'alai tachi ju xaquilamapalau ju quijnan ju tontacuj xacch'alhcatnanau chai xaquitanek'an ju asc'unu'”. ");
INSERT INTO teeNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Para ju amanavin lhich'alhcat chani junilh pumatam sia lhiyu'unchach. “Amigo. Jantu talak'alhin ju icnaviyan. Ja jantu chun iclalhit'ak'oxiu ni alha'aya' tachi ju akts'iya lhajacan ju tamin avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ach'ap'ach ju mintalhaja chai ap'inchich. Vachu' chun icmapalhputun ju astan xatachinacha tachi ju xacmapalanch ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ja jantu lai acpunavi ju qui'anu' tachi ju iclacasq'uinch. Pus ju uxint'i ca va lhacch'ip'in ju ali'in ni k'ox xac'amapalai”. Chunch ju junilh ju amat'un. ");
INSERT INTO teeNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Pus vana va chunch cajuna' ju lact'iyan. Ca'alina' lapanacni ju mak'anch quintalhilaksita. Para jantu lai actinaulh ni ixlhiyuchi palai k'ox ca'alhilhiulacana'. Chai ca'alina' lapanacni ju jantuca' mak'an quintalhilaksita. Para jantu lai actinaulh ni ixlhiyuchi palai jantu k'ox ca'alhilhiulacana'. Pus tachi chun ju at'asanilh ju Dios ni laich catatak'alhtaxtuya' na lacats'unin sia yu'unch ju asacxtucalh ni xalack'ajin catajuna' ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ju Jesús acsni ix'anta ju xati ju lak'achak'an Jerusalén pus na lhu lapanacni ju ixtat'a'anta. Para ju Jesús at'asanilh ixpumacaut'ui'an ju ix'amamaka'ui chai ak'ailhi'alh alacatam. Chai chani ju ajuni: ");
INSERT INTO teeNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Alakts'int'it. Ju chavai cacha'anau ju Jerusalén. Chai ju anch acmak'axtakcana' la'ixmaca'an ju xalack'ajin palijni chai ju yu'unch ju na talhatalanininta ju milhamap'aksin'an. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Chai ju yu'unch aquintalhinona' quimaknica. ");
INSERT INTO teeNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Chai ju yu'unch aquintamak'axt'ak'a' la'ixmaca'an ju jantu quint'a'israelitanin tajunita. Chai ju yu'unch aquintalhits'i'ina'. Chai aquintalakanekmaya'. Chai aquintamaquilhtaya'. Para ju ixlhilakat'utu avilhchan aclok'onchokoya'. ");
INSERT INTO teeNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ju acsnich lakchincha ju Jesús ixnati'an ju ists'alan ju Zebedeo. Yu'unch ju Jacobo chai ju Xivan. Alact'acha'alh ju ists'alan. Chai ju ixnati'an ta'aktsokotanilh ju Jesús chai tapaininilh. ");
INSERT INTO teeNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Chai ju Jesús junich: ―Tijuch ju lac'asq'uin. Chai ju yuchi juni: ―Acsni alhinona' ju uxint'i anauch ni catatavi vachu' anch ju ani ixt'iyun'an qui'ask'at'an. Ju pumatam catola' lamilhicana chai ju pumatam lamilhimacx. Ju chunch ni cac'atsacana' ni xalack'ajin tajunita. ");
INSERT INTO teeNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Para ju Jesús alacjuni: ―Ju uxijnan jantu c'ats'ayat'it tuch'i quilasq'uiniyau. Ja lai amak'alhk'ajnana'it'it tachi ju acmak'alhk'ajnana' ju quit'in. Pus ju yu'unch tajuni ni calayach. ");
INSERT INTO teeNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Chai ju Jesús alacjuni: ―Slivasalh chunch ju amak'alhk'ajnana'it'it tachi ju acmak'alhk'ajnana' ju quit'in. Para jantu quit'in ju acnona' tichi chavaich ju catola' laquilhicana chai laquilhimacx. Yu'unch ju catatola' anch ju asacxtuta ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Pus ju ixpumacau'an ix'amamaka'ui ju Jesús acsni tak'asmatlh tuchi ixtajunita ju Jesús ju ixt'iyun'an alak'avin pus na talhitalhk'amalh. ");
INSERT INTO teeNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Para ju Jesús alact'asanilh chai alacjuni: ―Ju uxijnan c'ats'ayat'it ni slivasalh na p'as talhinajun ju xa'ucxtin lakatamin k'ai lacat'un. Chai vachu' na alhimakchapui ju lapanacni ju salact'icst'i ucxtinin ju amalakachacan. ");
INSERT INTO teeNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","27","Para jantu chun ju alat'it ju uxijnan. Alai yuchi ju palai xak'ai jumputun lamilhi'uxijnan tasq'uini ni calhitalacasu tachi ju tam xalapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chunch ju alat'it tachi ju iclai ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Ju quit'in jantiyu' iclhiminta ni va aquintach'alhcatnanilh ju lapanacni. Alai iclhiminta ni laich ac'alacch'alhcatnaniya' ju lapanacni chai laich acxt'ak'a' ju qui'atsucunti ix'amalakxtuca lhu ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Acsni alact'ataxtucha ju Jesús ju lak'achak'an Jericó ju ix'amamaka'ui pus na lhu lapanacni tach'ak'ok'alh vachu'. ");
INSERT INTO teeNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chai ixtavilanalh la'ixquilhtu' ti ixt'iyun'an alak'ach'ixnin. Chai ju yu'unch acsni tak'asmatlich ni antachalh ju Jesús pus lana p'as tachivinilh. Tajuni: ―Jesús. Ists'alh'at ju k'ai ucxtin David. Aquila'aktaijuch lamapainin. ");
INSERT INTO teeNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Para ju lapanacni ju ixtat'aminta ju Jesús ju lacati tak'ailh. Tajunilh ni va sek catatavi. Para va apalai p'as ixtalacchivinin ju yu'unch. Tajuni ju Jesús: ―Jesús. Ists'alh'at ju k'ai ucxtin David. Aquila'aktaijuch lamapainin. ");
INSERT INTO teeNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Pus ju acsnich ju Jesús taya chai alact'asanilh ju anu' ixt'iyun'an alak'ach'ixnin chai alacjuni: ―Tijuch ju lac'asq'uinat'it ju aclanaviniu ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Chai ju yu'unch tajuni: ―Qui'ucxtin chach ic'alac'avanau. ");
INSERT INTO teeNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Pus ju acsnich ju Jesús amapaini ju yu'unch. Chai alacch'apanilh ixlakchulh'an. Pus lana tapu'alac'avanalh chai tach'ak'ok'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Vanin ju lak'achak'an Jerusalén ix'alin lakatam lak'achak'an ju Betfagé ixjuncan. Chai ju anch ixvi ju akstijun junta na lhu ixlacya ju xaq'uiu olivos. Pus ju Jesús acsni alact'acha'alh ju anch ju ixtalhavat lapanacni amalakachalh ixt'iyun'an ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Chai alacjuni: ―A'inchit'it ju anu' tasui lak'achak'an. Chai acsni at'anut'achit'it pus alhit'a'uya'it'it lakatam xanati puru ch'iyocanta. Chai vachu' anch ya ju is'ask'at'a. Axk'ot'aya'it'it chai alhit'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Chai ni xamati' catalhik'aiputunan va a'una'it'it ni ma maktasq'uini ju mi'ucxtin'an chai ma vats'alhti camalakachachokotachilh. ");
INSERT INTO teeNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Pus chunch ju navilh ju Jesús ni lai ca'uctaxtuya' ju chivinti ju xanajun ju mak'aniya lapanac ju ixnajun ixchivinti Dios. Ju yuchi ma chani xanajun: ");
INSERT INTO teeNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chani a'una'it'it ju amachak'an Jerusalén: “Alakts'int'it. Talakmintan ju mi'ucxtin'an. Ju yuchi jantu mak'ali' junita. Va puminta lakatam puru”. Chunch ju ixnajunta ju mak'aniya lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Pus ju ix'amamaka'ui ju Jesús ta'alh. Chai chunch ju tanavilh tachi ju ix'ajunita ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Talhimilh ju xanati puru chai ju sa'ask'at'a chai ta'akxch'amuc'alh ixcutun'an. Chai lana putoc'alh ju Jesús ju sa'ask'at'a. Chai alh. ");
INSERT INTO teeNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Chai ju ixtamakach'ak'ok'ananta na ilhu'an ixtajunita. Pus ixtamamalhi'anta ixpumpu'an ju lacati junta capumina' ju Jesús. Chai ju ali'in ixtat'ek'e'ich ju ix'acatan q'uiu chai ixtamamalhi'anta ju lacati. ");
INSERT INTO teeNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Chai ju lapanacni ju ixtap'ulanan chai ju ixtak'aixunun na p'as ixtalacchivinin. Ixtanajun: ―Chach lak'ayacalh ju ani ists'alh ju k'ai ucxtin David. Paxcat ju ani minta ju malakachatachilh ju Dios. Chach lak'ayacalh ju Dios ju vilhcha talaclhman. ―Chunch ixtanajun ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Chai acsni tanucha ju Jesús ju lak'achak'an Jerusalén pus chux ju lapanacni t'ilhi t'ilhi ixtalaich. Chai ixtalaclajuni: ―Tis nu' chavaich ju xachin. ");
INSERT INTO teeNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Chai ju lapanacni ju ixtat'a'anta ju Jesús alacjuni: ―Ju ani yuchi ju Jesús ju najun ixchivinti Dios. Yuchi ju amachaka' Nazaret laxa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chai astan ju Jesús tanucha lacak'ai ixpujitat'an ju ist'a'israelitanin. Chai atixcoxtuk'o tachi chun ju ixta'ulata ixlhist'at'an chai ju ixta'atamonan ju anch. Chai amatistanilh ju ixmixa'an ju ixmapaxanin tumin chai ju ixputolan'an ju istast'ai ju lak'axk'avan. ");
INSERT INTO teeNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Chai alacjuni: ―Ju la'ixchivinti Dios chani ju ts'okcanta: “Ju quinchaka' calhimispacana' ni anch ju t'achivincan ju Dios”. Chunch ju najun la'ixchivinti Dios. Para ju uxijnan va tachi ixchaka' ju ak'alhaunin lhimalacxt'ut'at'it. ");
INSERT INTO teeNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chai ju anch lacpujitat tachincha ju alak'ach'ixnin chai ju jantu lai ixta'alhtanan. Chai ju Jesús palai anavik'o. ");
INSERT INTO teeNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Para na tatalhk'amalh ju xalack'ajin palijni chai ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin acsni talakts'ilh ju lhamak'an ju ixnavi ju Jesús chai acsni tak'asmatlh ni na p'as ixtachivinin ju ts'alan ju anch lacpujitat chai ixtalak'ayai ju Jesús ists'alh ju k'ai ucxtin David. ");
INSERT INTO teeNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Chai tajunilh ju Jesús: ―Ja va jantu k'asmat'a tuchi tanajun ju yu'unch. Chai ju Jesús alacjuni: ―Ick'asmat'a. Para ju uxijnan chunch ju layat'it tachi ju jantu tavanan lakts'int'at'it ixchivinti Dios junta chani juncan ju Dios: Ju uxint'i lac'asq'uin ji Dios ni lak'ayac'an la'ixchivinti'an ju ask'at'an chai ju va tats'iquica'. Chai ju yu'unch talak'ayayan tachi ju lhijun ni alak'ayac'a ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Chai acsni nonk'o ju chunch ju Jesús pus lana alacmacaulh. Taxtulh ju lak'achak'an Jerusalén. Alh ju lak'achak'an Betania chai anch ju lakacujcha. ");
INSERT INTO teeNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Chai ju vats'isin acsni anchokolh ju Jesús ju lak'achak'an Jerusalén pus na chavanilh. ");
INSERT INTO teeNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Chai lakts'ilh ak'atam higo ju ixya vanin lacati. Pus ju Jesús lak'alh para jantu tu'u' lhitajunilh xalhi'ut. Va si xaxk'oi ix'alinta. Pus chani juni: ―Jantu tavanan lai at'ixt'akch'ok'o ju milhi'ut. Pus lana xixlh ju anu' higo. ");
INSERT INTO teeNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Pus ju ix'amamaka'ui ju Jesús acsni talakts'ilh na talhamak'aninilh. Chai tajuni: ―Tas laich va ts'alhti xalhixix ju higo. ");
INSERT INTO teeNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Chai ju Jesús alack'alhtailh. Alacjuni: ―Slivasalh ju iclajunau. Ni vasalh quilalhilaksiyau chai ni jantu va tam tam nonat'it pus laich anaviya'it'it vachu' tachi ju xac'ulhtui ju anu' xaq'uiu higo. Para jantu va yuchi. Vachu' lai a'unit'it ju ani talhpa: “Ak'ost'ich. Ap'inchich laca'alama”. Chai ni chunch ju a'unit'it pus chunch ju calalh. ");
INSERT INTO teeNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Pus tachi chun ju asq'uiniya'it'it ju Dios acsni at'ach'ivinina'it'it pus amaklht'ayanana'it'it. Va yuchi ni slivasalh alhilac'ap'it'it ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Chai astan ju Jesús tanucha lacak'ai ixpujitat'an ju ist'a'israelitanin chai tsuculh amalanini' ju lapanacni. Pus ju acsnich talakmilh ju xalack'ajin palijni chai ju papaninch chai tajuni: ―Tis chavaich ju xajunan ni laich anaviya' ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Chai ju Jesús chani alhik'alhtailh: ―Ju quit'in vachu' aclasacmiyau lakatam chivinti. Chai ni aquilajunau pus ju acsnich vachu' aclajunau tichi chavaich ju xaquijuni ni acnaviya' ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Pus tis chavaich ju xamalakachayachilh ju Xivan amakpaxana'. Ja yuchi ju Dios u yu'unch ju lapanacni. Pus ju acsnich ju anuch lapanacni talaclajuni ixlhi'akstu'an: ―Pus ni canaju ni Dios ju xamalakachayachilh pus laich aquintajunin tajuch ni jantu xalaca'iniyau. ");
INSERT INTO teeNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Chai jantu lai catinaju ni yu'unch ju lapanacni ju xatamalakachayachilh ni na atalhoniyau ju lapanacni ni ixchux'an talhimispai ju Xivan ni ixnajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Pus yuchi chani talhijuni ju Jesús: ―Jantu icc'atsayau. Pus ju acsnich ju Jesús alacjuni: ―Pus nin quit'in jantu actilajuniu tichi chavaich ju xaquijuni ni acnavi tachi chun ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Chai ju Jesús vachu' alacjuni: ―T'as nonat'it. Ju pumatam lapanac ix'alin ixt'iyun'an ists'alan. Pus ju yuchi lak'alh ju xak'ai ists'alh chai juni: “Quints'alh. Ap'inchich ju chavai ch'alhcatna' laquimpu'uvas”. ");
INSERT INTO teeNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Para ju anu' ts'alh juni ni jantu cati'alh. Para astan tamch xapast'ac'a chai alh. ");
INSERT INTO teeNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Chai astan ju xapai lak'alh ju salacat'icst'i chai vana va chun ju juni ju yuchi. Chai ju yuchi junilh ju ixpai ni canach. Para jantu alh. ");
INSERT INTO teeNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Pus aquilajunau. Ju anu' ixt'iyun'an ts'alan tis chavaich ju xanavini ixk'achat ju ixpai. Pus ju xalack'ajin palijni chai ju papanin tajuni: ―Yuchi ju xak'ai. Pus ju acsnich ju Jesús alacjuni: ―Slivasalh ju iclajunau. Ju ach'inin chai ju t'acunin ju va lacati ixtat'ajun palai lai catatanuya' junta lhinajun ju Dios. Palai jantu ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Iclajunau chunch ni quilachilh ju Xivan amakpaxana'. Chai ju yuchi naulh ta yu laich sok catatsuculh ju lapanacni para jantu xaq'uiclac'a'iyat'it ju uxijnan. Alai yu'unch ju talaca'inilh ju ach'inin chai ju t'acunin ju va lacati ixtat'ajun. Chai ju uxijnan lakts'int'at'it ni tam xajun is'atsucunti'an para ixlaquilhtu jantu xamac'onat'it ju mi'alactu'unti'an ni laich ixlac'a'it'it vachu'. ");
INSERT INTO teeNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ak'asmat'it vachu' ju ani chivinti ju iclajumputunau. Ix'alin pumatam lapanac ju ix'alin ixlacat'un. Chai ju yuchi ch'anlh ju xaq'uiu uvas. Chai coralhnu lacak'ex. Chai pok'aj'ula junta camaxtunicana' ju xaxcan uvas. Chai yaulh lakatam chaka' ju na putank'ai ni laich capulhistaccalh ju ixpu'uvas. Chai acsni navik'olh pus amach'ixtaknilh ju makch'alhcatnin. Chai ju yuchi alh makat. ");
INSERT INTO teeNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Chai acsni cha'alh ju avilhchan ni chalh ju uvas pus ju anu' amat'un amalakachanilh ju ixlapanacni ju anu' makch'alhcatnin ni cata'alh amaklhtayanin ju xalhi'ut tachi ju ix'alhit'atak'oxitach. ");
INSERT INTO teeNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Para ju anuch makch'alhcatnin tach'apalh ju xalapanacni. Ju pumatam talakanekma. Ju apumatam tamakni. Chai ju apumatam talacat'alhma. ");
INSERT INTO teeNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Chai aktam ju amat'un amalakachachokopa ju ali'in. Palai ilhu'an. Para vana va chun ju tat'alapa. ");
INSERT INTO teeNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Chai ju ixpu'aclanch malakachalhch ju ists'alh. Va ixnajun ni catatalhoniya' ju ists'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Para ju anuch makch'alhcatnin acsni talakts'ilh ju ists'alh ju amat'un talaclajuni sia yu'unch: “Yuchach ju ani ju amanavin cajuna' acsni caniya' ju ixpai. At'at'itch. Camakniuch chai qui'anuch'an cajuna' ju ani pu'ach'ananti”. ");
INSERT INTO teeNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Pus tach'apalh. Tatantamacxtulh lacapu'uvas. Chai tamaknilh. ");
INSERT INTO teeNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Chai ju Jesús acsni nonk'o ju ani chivinti chani ajuni ju xalack'ajin palijni chai ju papanin: ―T'as nonat'it. Acsni caminchokoya' is'akstu ju amat'un tas cat'alayach ju anuch makch'alhcatnin. ");
INSERT INTO teeNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Chai ju yu'unch tajuni ju Jesús: ―Pus nin lacats'unin jantu cati'amapaini. Alai ca'amaknik'oya' chai ali'in ju ca'amach'ixtaknichokoya' ju anu' pu'uvas. Ca'amach'ixtakniya' ju lapanacni ju cataxtakniya' ju xalhi'ut tachi ju ca'alhit'atak'oxiyach. ");
INSERT INTO teeNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Pus ju acsnich ju Jesús alacjuni: ―Ja va jantu tavanan lakts'int'at'it ixchivinti Dios ju ts'okcanta junta ma chani najun: Ju anu' chiux ju tasacmak'alh ju ixyonin chaka' yuchach ju valhch ju chiux ju mak'astumuc'acanta chaka' junta ts'okcanta tuchi c'atach ju yocanta. Yuchi ju Dios ju navilh ju chunch. Chai acsni iclakts'inau pus na k'ai lhamak'an iclhiulayau. Chun ju najun la'ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Chai ju uxijnan ni quilasamak'antauch tachi ju talalh ju anu' ak'exinin pus yuchi jantu lai vana catilhilhinaulh ju Dios lamilhi'uxijnan. Alai ca'alhijuna' ju ali'in lapanacni ju vasalh catasuya' la'is'atsucunti'an ni talhilaksi ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Acsni quintasamak'an ju lapanacni pus va ixt'achunch junita tachi acsni puk'alhk'oscan ju tu'u' chiux chai tac'atsanican. Chai acsni ic'a'ulani ju lapanacni ju ixtalak'alhin'an pus va ixt'achunch junita tachi acsni catant'alhma ju tu'u' k'ai chiux chai jantu tavanan lai k'ostolai. ");
INSERT INTO teeNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pus ju xalack'ajin palijni chai ju fariseonin acsni tak'asmatlh ju ani ixchivinti ju Jesús pus lana tamachakxalh ni yu'unch ju alhichivincanch. ");
INSERT INTO teeNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Chai lana ixtach'apaputun. Para va tatalhonilh ju ixtalhavat'an lapanacni ni ixtalhimispai ju Jesús ju lapanac ju ixnajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ju Jesús aktam puxcaulh ta yu laich ca'apumavasalanilh ju lapanacni ju tuchi ix'amalaniputun. Pus chani alacjuni: ");
INSERT INTO teeNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Junta lhinajun ju Dios lai chunch tapasai tachi ju tapasalh la'is'atsucunti pumatam k'ai ucxtin. Ju yuchi ixlhic'ataniputun pumatam ists'alh ni catamak'axt'ok'a'. ");
INSERT INTO teeNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Pus amalakachalh ixlapanacni ni cata'alh alact'asaninin ju ix'amac'atsanicanta ni ca'alina' ju lacvaiti. Para jantu xamati' mimputulh. ");
INSERT INTO teeNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Pus amalakachachokopa ju ali'in ixlapanacni chai alacjuni: “A'inchit'it ajuninin ju catalacvenach ni ma alin ju vaiti ni iclhinaulh ixmaknica ju quivacax chai ju ali' atapacxat ju na ixtalack'onta. Chai tak'oxik'otach ju chavai. Ma at'at'it makvenin”. Chunch ju xa'ajuni ju ixlapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pus ta'alh. Para ju lapanacni mas chunch ix'ajuncan jantu tu'u' talhiula. Alai alh pumatam la'ixcuxtu. Apumatam alh ast'ana'. ");
INSERT INTO teeNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Chai ju ali'in tach'apalh ju anu' alhtanin. Tamamak'alhk'ajni tus tamakni. ");
INSERT INTO teeNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Pus ju anu' k'ai ucxtin acsni k'asmatlich ta ixtalai ju anuch lapanacni pus na talhk'amalh. Lana amalakacha ju ixtaropajni. Amaknik'o ju anu' amakninin. Chai ju la'ixlak'achak'an'an manulh jipi. ");
INSERT INTO teeNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Chai astan alacjuni ju ixlapanacni: “Tak'oxik'ota ju vaiti para jantu ixlhijun ni lai ixtamilh venin ju p'ulhnan ix'aquit'asanican ni va k'ai ixtajunita. ");
INSERT INTO teeNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Palai k'ox cajuna' ni va ap'it'it lacatijixni junta tapumin ju lapanacni ju lak'achak'an chai ak'ailhit'ana'it'it ju lacvaiti va tichi alhit'a'uya'it'it”. ");
INSERT INTO teeNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Pus tataxtulh ju anu' xalapanacni. Ta'alhtanatsuculh ju lacatijixni. Chai tachi chun ju talhitajulh tak'ailhimink'olh. Chux ju lack'oxin lapanacni chai ju k'ai tajunita. Chai ju chunch na aktsamcalh ju anu' lacvaiti. ");
INSERT INTO teeNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Pus ju acsnich tanucha ju k'ai ucxtin. Va ixlakts'imputun ju makvenin. Pus lakts'ilh pumatam lapanac ju jantu ixlhimalakch'inin ixlacata ju lacvaiti. Jantu ixlakch'ita ju pumpu' ju ixtaknicanta. ");
INSERT INTO teeNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Pus juni: “Qui'amigo. T'as xalhit'anch ju ani ni jantu lhimalakch'ininta ixlacata ju lacvaiti”. Pus ju yuchi jantu tu'u' lai k'alhtailh. ");
INSERT INTO teeNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Pus ju acsnich ju k'ai ucxtin ajunich ju ixlapanacni ju ixtaxt'ak'a vaiti: “Ach'anch'it'it chai amakch'it'it chai amac'ap'it'it junta puts'is lhimakspa'. Ju anch lack'alhuncan chai laclamatantsacacan ju istatsalat'an ni na tamak'alhk'ajnan”. ");
INSERT INTO teeNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pus ju acsnich ju Jesús tailhi'alh ixchivinti. Alacjuni ju lapanacni: ―Na lhu at'asanicanta ni cata'alh ju lact'iyan. Para na lacats'unin ju vasalh catacha'ana'. ");
INSERT INTO teeNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Pus ju acsnich ta'alh ju fariseonin. Tapastaclh ta yu laich catapuxcolakxtunilh ju tu'u' chivinti ju Jesús ni laich catapumuc'anilh ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Pus ni tanaulh ta yu catalaya' pus tamalakachalh ju ali'in ix'amamaka'ui ju fariseonin. Alact'a'alh ju ali'in ju ixtach'ak'ok'ai ju gobernador Herodes. Talak'alh ju Jesús chai tajuni: ―Amamaka'unu' icc'atsayau ni na'un ju stavasalanti ju uxint'i. Chai sok masui ju ixti ju Dios. Chai jantu xamati' t'alhoni ni vaklhtam chun ju alakts'in ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Pus aquilajuniuch. T'as na'unch ju uxint'i. Ja lhijun ni ac'amapalanau la'ixmacni ju xa'ucxtin ju romanonin u jantu. ");
INSERT INTO teeNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Para ju Jesús lana amachakxanilh ni va ixta'okxchok'oputun. Chai chani alacjuni: ―Tajuch ni va quilapuxconiyau ju talak'alhin. Ju uxijnan va acxp'ut'iyununat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Aquilamasuniu ju tumin ju lhi'amap'alananat'it. Pus ju yu'unch tamalacasunilh ju anu' sentau. ");
INSERT INTO teeNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Pus ju Jesús acsni lakts'ilh alacsacmi: ―Tis ix'ucxpu' ju ani okslai. Tis ixtapaka'ut ju ts'okcanta ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Pus ju yu'unch tajuni ni ix'anuch ju César. Yuchi ju xak'ai tucan ju ixlhinonk'ojui chux ju xalacat'un Roma. Pus ju acsnich ju Jesús alacjuni: ―Pus axt'aknit'it ju César ju ix'anuch. Chai axt'aknit'it ju Dios ju ix'anuch Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Pus ju yu'unch acsni tak'asmatlh ju ixchivinti ju Jesús na talhamak'aninilh ni na k'ox xalhak'alhtayanan. Pus tamacaulich chai ta'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Pus vana ju acs avilhchan talakchimpalhcha ju saduceonin junta ixvi ju Jesús. Pus ju yu'unch tanajun ni jantu lai lok'onchokocan acsni va nicanch. Pus yuchi chani talhijuni ju Jesús: ");
INSERT INTO teeNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","―Amamaka'unu' ju Moisés naulh ni canilh tam lapanac chai camacontilalh ix'amachaka' para ni jantu cat'amacontilalh tam is'ask'at'a pus ju isp'isek'e ju anu' xani ma cat'atsucuchokolh ju ix'amachaka' ixjunita ju xani. Chai acsni ca'alilh tam ists'alh pus ju yuchi ma casacnilh ixtapaka'ut ju anu' xani. ");
INSERT INTO teeNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pus sia lhiquijnan ix'alin pumatujun lhi'alak'avin. Chai ju xak'ai tamak'axtoklich para astan nilh. Chai ni jantu tu'u' macontilalh is'ask'at'a pus maconilh ju isp'isek'e ju ix'amachaka' ixjunita. Para vachu' nipa chai vana jantu tu'u' macontilalh is'ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Pus vana va chun tapasapa ju ixlhipumat'uich chai ju ixlhipumat'utuch. Tus talaktsa ixlhipumatujun'an lhi'alak'avin. ");
INSERT INTO teeNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Chai astanch pus nilh vachu' ju anu' chako'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Pus acsni catalok'onchokoyanta ju tanita pus tis chavaich ju ixpumatujun'an lhi'alak'avin ju lai canaulh ni yuchi ix'amachakach junita ni ixpumatujun'an at'atsucuk'o ju anu' chako'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Chai ju Jesús alacjuni: ―Ju uxijnan jantu sok alacp'ast'acnanat'it. Ju uxijnan jantu mach'akxayat'it ni na lacalhu ju ts'okcanta la'ixchivinti Dios junta najun ni calok'onchokoya' ju tanita. Vachu' jantu c'ats'ayat'it tuchi lai navi ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Pus acsni calok'onchokoya' jantu catamak'axtokcana' nin cala'icalh. Va ixt'achunch catatsucuya' tachi ju anquilhnin ju tavilanancha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Chai ni va asacmininat'it ni laich catalok'onchokoya' ju tanita pus ja lana jantu p'ast'ac'at'it tuchi naulh ju Dios ixlacata ju tanita ni catalok'onchokoya'. Pus ju yuchi ma chani naulh: ");
INSERT INTO teeNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ju yuchi ma isDios'an junita ju Abraham chai ju Isaac chai ju Jacob. Chunch ma naulh ju Dios. Pus ju yuchi ni isDios junita ju lapanacni ju tat'ajun pus nomputun ni tat'ajun ju anuch lapanacni mas noncan ni mak'anch tanita. ");
INSERT INTO teeNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Pus ixtalhavat lapanacni acsni tak'asmatli ixchivinti ju Jesús slivasalh na talhamak'aninilh ju ix'atalaninti ni na k'ox xachivinin. ");
INSERT INTO teeNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ju saduceonin ni jantu lai tu'u' talhik'alhtailh ju Jesús pus tac'atsa ju fariseonin. Pus a yu'unch talakmimpa ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Chai sia yu'unch ix'alin pumatam ju na ixlhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Chai ju yuchi sacmilh ju Jesús lakatam chivinti. Va ixpupuxconiputun ixtalak'alhin. Chai chani ju junilh: ");
INSERT INTO teeNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Amamaka'unu' tachi chun ju ixlhamap'aksin ju Moisés tas malhch ju palai tasq'uini ni canavicalh. ");
INSERT INTO teeNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Chai ju Jesús juni: ―Amap'ainit'ich ju mi'ucxtin Dios la'ixlhichux mi'alhunut chai la'ixlhichux ju mi'atsucunti chai la'ixlhichux ju mintac'atsan. ");
INSERT INTO teeNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yuchach ju lhamap'aksin ju palai tasq'uini ni canavicalh. ");
INSERT INTO teeNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Chai ju ixlhilakat'ui va ixt'achunch junita. Ju yuchi najun ni amap'ainit'i ju vanin alact'avilht'i tachi ju va jun mi'akstu ju map'ainich'ok'oc'an. ");
INSERT INTO teeNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Pus tachi chun ju ts'oklh ju Moisés chai tachi chun ju tats'oklh ju mak'aniya ixlapanacni Dios vaklhtam chun tanomputun. Tanajun ta yu acpumapainilh ju Dios chai ta yu acpumapaini ju quint'alapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Acsni ixtavilanalhca' ju fariseonin pus ju Jesús alacsacmi: ");
INSERT INTO teeNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―T'as nonat'it ju uxijnan. Tis ists'alh lhiulayat'it ju Cristo ju ixnoncan camalakachatachilh ju Dios. Chai ju yu'unch tajuni: ―Pus ists'alh ju k'ai ucxtin David. ");
INSERT INTO teeNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Pus ju acsnich ju Jesús asacmichokolh. Alacjuni: ―Pus ju David yuchi ju Spiritu Santu ju mapast'ac'ani ni lhixak'ala ix'ucxtin ju Cristo. Pus t'as lhimach'akxayat'it ni lai chunch lalh. Pus ju yuchi ju David ma chani naulh: ");
INSERT INTO teeNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ju ucxtin Dios junilh ju qui'ucxtin ni vanin catavi tus acsni cat'alalhajaya' ju ixt'alaxcai. Chunch ma naulh ju David. ");
INSERT INTO teeNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Chai ni is'akstu ju naulh ju David ni ix'ucxtin junita pus ju chunch va nomputun ni jantu va ists'alh junita. ");
INSERT INTO teeNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Pus ju acsnich jantu lai xamati' tu'u' ixlhik'alhtaji. Chai tus acsnich avilhchan jantu lana xamati' isacmiputun tu'u' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Pus ju acsnich ju Jesús axak'ala ju ixtalhavat lapanacni chai ju ix'amamaka'ui. Chai chani ajuni: ");
INSERT INTO teeNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―Ju fariseonin chai ju lapanacni ju na talhatalanininta ju milhamap'aksin'an tanajun ni va yu'unch ju lai tamavasalai ixlhamap'aksin ju Moisés. ");
INSERT INTO teeNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pus aq'uiclac'a'it'it tachi chun ju tajunan. Para tun t'inavit'it tachi ju tanavi ju yu'unch. Pus ju yu'unch sok ta'amalaninin para jantu tamuctaxtui ju ta'amalaninin. ");
INSERT INTO teeNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Pus ju yu'unch na talalhavata ju ixlhamap'aksin ju Moisés tus chunch junita tachi ju tu'u' tac'uc'at ju na ts'inq'ui. Ju jantu lai lana malhtanacan. Chai ju yu'unch chunch ju tamuc'anita ju lapanacni para is'akstu'an nin lacats'unin jantu tamuctaxtui. ");
INSERT INTO teeNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pus ju yu'unch acsni tanavi tu'u' pus yuchi talhinavi ni laich catalakts'ina' ju lapanacni chai catanaulh ni slivasalh tamuctaxtui la'ixlhamap'aksin ju Dios. Pus palai akxak'ai tanavi ju pumpu' ju tach'imuc'ai la'ismuntsan'an chai la'ixmaca'an junta tamak'ai lacats'unin ixchivinti Dios ju ts'okcanta. Chai palai lhman tanavi ju isliston'an ju taquilhtumuc'ai la'ixtuch'it'an. Palai jantu na chun talai ju ali'in quint'alapanacni'an. ");
INSERT INTO teeNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Chai na tak'achani ju putolan lacapuvai chai lacpujitat junta tatolai ju xalack'ajin. ");
INSERT INTO teeNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Chai na talacasq'uin ni caxak'alacalh laclhitamau tachi tam xak'ai chai ca'ajunicalh ni amamaka'unin tajunita. ");
INSERT INTO teeNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Para ju uxijnan tun alac'asq'uint'it ni a'unc'ant'it amamaka'unu' ni va pumatam ju mi'amamaka'unu'an. Va quit'in. Chai minchux'an ju uxijnan va lhi'alak'avin unt'at'it. ");
INSERT INTO teeNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chai jantu alhixak'alat'it mimpai'an tam xak'ai ju ani lacamunutpa' ni va pumatam mimpai'an. Yuchi ju Dios ju vilhcha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Chai tun t'ilak'a'it'it ni xamati' catalhilaksiyan ni va uxijnan ju cataquiclaca'iyan. Jantu chun alat'it ni va pumatam ju lhinajun. Va quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Chai ju lamilhi'uxijnan yuchach ju xak'ai ju ach'alhcatnani ju ali'in. ");
INSERT INTO teeNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pus va tichi chavaich ju calak'ayachokocalh is'akstu camalacat'icst'icana'. Para va tichi chavaich ju va lacat'icst'i cac'atsa pus yuchi ju calak'ayacana'. ");
INSERT INTO teeNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Paini'itnich ju uxijnan ji lapanacni ju na lhat'alaninint'at'it ju milhamap'aksin'an ju israelitanin unt'at'it chai ju uxijnan ju fariseonin unt'at'it. Ju uxijnan na va acxp'ut'iyununat'it. Pus ju uxijnan ap'usast'uc'at'it lamilhamap'aksin'an ju lapanacni ju tatanuputun ju lact'iyan junta lhinajun ju Dios. Pus ju uxijnan jantu t'anup'ut'unat'it chai jantu alac'asq'uiniyat'it ni catatanu ju tatanuputunch. ");
INSERT INTO teeNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Paini'itnich ju uxijnan ji lapanacni ju na lhat'alaninint'at'it ju milhamap'aksin'an ju israelitanin unt'at'it chai ju uxijnan ju fariseonin unt'at'it. Ju uxijnan na va acxp'ut'iyununat'it. Pus ju uxijnan alact'ai'iniyat'it ju ixlacchaka'an ju chakolun ju animacontilacanta. Chai astan lap'alat'it tachi ju na va k'ox panicni ju t'ach'ivinat'it ju Dios ni lai ap'u'okxch'ok'oya'it'it ju lapanacni ni catanaulh ni na t'alhoniyat'it ju Dios. Pus ixlhiyuchi palai k'ai cajuna' ju mimak'alhk'ajnat'an. Palai jantu ju ali'in lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Paini'itnich ju uxijnan ji lapanacni ju na lhat'alaninint'at'it ju milhamap'aksin'an ju israelitanin unt'at'it chai ju uxijnan ju fariseonin unt'at'it. Ju uxijnan na va acxp'ut'iyununat'it. Slivasalh malac'a'inip'ut'unat'it mas anic'ach va pumatam ju mi'atalaninti'an. Chai acsni malac'a'iniyat'it pus akt'ai'uyat'it ni palaich na ca'alactu'unulh tus slivasalh na tak'alhinita ju is'atsucunti. Chai palai lhijun ni camamak'alhk'ajnicalh ju yuchi ju lacajipi. Palai jantu na chun ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Paini'itnich ju uxijnan. Chunch unt'at'it tachi ju tam xamati' ju ap'ulanan para va alak'ach'ix junita. Pus ju uxijnan nonat'it ni jantu tu'u' nomputun acsni lhipastaccan ju lacpujitat ju ixpumavasalaca tu'u' chivinti. Para va tichi chavaich ju calhipast'ac'a' ju xa'oro ju alin lacpujitat ni capumavasalaputuna' ju ixchivinti pus ma tap'astu camuctaxtuya' ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ju uxijnan na tontojni unt'at'it. Va alak'ach'ixnin unt'at'it. Jantiyu' ju oro ju palai tu'u' junita. Alai yuchi ju pujitat ju palai tu'u' junita ni ixchaka' Dios junita. Chai ixlhiyuchi vachu' ix'anu' Dios junita ju oro ju tanun ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Chai vachu' nonat'it ni jantu tu'u' nomputun acsni xamati' lhipast'ac'a junta makninican ju Dios ju tu'u' atapacxat va ixpumavasalaca ju ixchivinti. Para va tichi chavaich ju calhipast'ac'a' ju anu' atapacxat ju mokslacanta anch pus ma tap'astu camuctaxtuya' ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Na tontojni unt'at'it. Va alak'ach'ixnin unt'at'it. Jantiyu' ju atapacxat ju mokslacanta anch ju palai tu'u' junita. Alai anch junta mokslacanta. Yuchach ju palai tu'u' junita. Pus tachi chun ju mokslacanta anch ix'anu' Dios junita va ixlaca'atalh ni okslai ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Pus va tichi chavaich ju lhipast'ac'a junta makninican ju Dios ju atapacxat pus tap'astu lhipast'ac'a vachu' tachi chun ju okslai la'ix'ucxni. ");
INSERT INTO teeNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Chai va tichi chavaich ju lhipast'ac'a ju pujitat pus tap'astu lhipast'ac'a vachu' ju Dios ju t'ajun ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Chai ju lhipast'ac'a ju lact'iyan va ixpumavasalaca ju ixchivinti pus tap'astu lhipast'ac'a ju Dios ni yuchach ju lhinajun ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ju Jesús tailhi'alh ju ixchivinti chai naulh: ―Paini'itnich ju uxijnan ji lapanacni ju na lhat'alaninint'at'it ju milhamap'aksin'an ju israelitanin unt'at'it chai ju uxijnan ju fariseonin unt'at'it. Ju uxijnan na va acxp'ut'iyununat'it. Ju uxijnan vasalh muct'axt'uyat'it ju lhamap'aksin acsni xt'akniyat'it ju palijni lacts'unin ju mi'alhmujinu'an ju ch'ant'at'it chai lacts'unin ju mi'anis'an chai lacts'unin ju mincomino'an ju ch'ant'at'it. Para jantu sok ju ts'uc'uyat'it. Jantu akt'ai'uyat'it xamati' laca'amapaininti. Chai jantu lhilac'ap'inat'it ju Dios. Jantu chun ju layat'it mas yuchi ju palai tasq'uini ni anavit'it tachi chun ju najun la'ixlhamap'aksin ju Moisés mas vachu' at'ailhip'it'it ixtaknica ju lacts'unin ju tu'u' ach'itin. ");
INSERT INTO teeNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ju uxijnan chunch unt'at'it tachi tam xamati' ju ap'ulanan para va alak'ach'ix junita. Ju uxijnan slivasalh muct'axt'up'ut'unat'it ju lhamap'aksin ju palai jantu tu'u' lhitapalai. Para ju lhamap'aksin ju na tasq'uini ni anavit'it alai jantu naviyat'it cuenta. ");
INSERT INTO teeNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Paini'itnich ju uxijnan ju na lhat'alaninint'at'it ju milhamap'aksin'an ju israelitanin unt'at'it chai ju uxijnan ju fariseonin unt'at'it. Ju uxijnan va acxp'ut'iyununat'it. Ju uxijnan jantu vasalh lack'oxin lapanacni unt'at'it. Va lhit'alac'asuyat'it tachi ju na k'ox lapanacni unt'at'it para ju lami'alhunut'an va p'ast'act'onat'it ju mi'ak'alhajunti'an. Chai va lhimuc'unt'onat'it ju mi'alhaccha'anti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ju uxijnan ji fariseonin va alak'ach'ixnin unt'at'it. P'ulhnan salaka ats'uc'ut'it. Jantu vana alack'alha'ut'it tu'u' u alhacch'ip'it'it tu'u'. Chai ju chunch vasalh ni salaka cajuna' ju mi'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Paini'itnich ju uxijnan ju na lhat'alaninint'at'it ju milhamap'aksin'an ju israelitanin unt'at'it chai ju uxijnan ju fariseonin unt'at'it. Ju uxijnan va acxp'ut'iyununat'it. Ju uxijnan chunch unt'at'it tachi ju tu'u' panteon ju na xnapapa lak'oxicanta. Ju la'ixmacan islivasalh na c'usich tasui. Para la'ixpulacni na lhuch tanun ju xap'uch'in alucutni chai na lhquiliqui. ");
INSERT INTO teeNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Pus vana va chun ju uxijnan. Na soknic'a ju lhit'alac'asuniyat'it ju mint'alapanacni'an para ju lami'alhunut'an na aktsamanta ju mi'a'okxchok'onti'an chai ali' mi'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Paini'itnich ju uxijnan ju na lhat'alaninint'at'it ju milhamap'aksin'an ju israelitanin unt'at'it chai ju uxijnan ju fariseonin unt'at'it. Ju uxijnan na va acxp'ut'iyununat'it. Ju uxijnan naviyat'it ju ixpanteon'an ju mak'aniya lapanacni ju ixtanajun ixchivinti Dios. Chai na maxant'ilayat'it ju ixpanteon'an ju anu' soknic'a lapanacni ju mak'anch ixtat'ajun. ");
INSERT INTO teeNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Chai nonat'it ni laich acs cava ists'uc'uchit'it acsni ixtat'ajun ju mak'aniya milacpa'itni'an pus jantu ixmakt'anut'it ju ix'amaknica'an ju ixlapanacni Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pus ni nonat'it ni mimpai'an ixtajunita pus va nomputun ni vana va chun ju mi'alhunut'an tachi ju yu'unch ju tamaknilh ju lapanacni ju ixtanajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Pus alakts'amat'it ju uxijnan ixtalak'alhin'an ju mak'aniya milacpa'itni'an. ");
INSERT INTO teeNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ju uxijnan chunch unt'at'it tachi ju tu'u' lu ju makni ju tam lapanac. Ju uxijnan amalaniyat'it ju lapanacni ju chivinti ju jantu soknic'a. Chai ni talaca'iniyan pus cata'ana' junta jonk'alhita mak'alhk'ajnat. Chai ju uxijnan vachu' jantu lai at'it'ak'alht'axt'ut'it lacamak'alhk'ajnat ju jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Pus ju quit'in aclamalakachanitachiu ju lapanacni ju tanajun ixchivinti Dios chai ju lapanacni ju na ta'ac'atsananta chai ju lapanacni ju na lai ta'amalaninin ixchivinti Dios. Pus ju ali'in sia yu'unch amakniya'it'it chai amaq'uilht'aya'it'it lacacurus. Ju ali'in alak'anekmaya'it'it lamilacpujitat'an chai ach'ak'ok'axmaya'it'it acsni cata'ats'alhniyan ju lakatamin lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pus ju chunch ca'alinach ju mintalak'alhin'an ju uxijnan ixlacata ix'ac'alhni'an tachi chun ju lack'oxin lapanacni ju amaknicalh tus acsni maknicanchalh ju Abel tus acsni maknicanchalh ju Zacarías ists'alh ju Berequías. Pus ju Abel na soknic'a lapanac ixjunita chai yuchi ju p'ulhnan tucan maknicalh. Chai ju Zacarías xa'astan va tachi chun ju lhits'okcanta la'ixchivinti Dios. Ju yuchi maknicalh la'ixputsin pujitat junta ixt'alakxtokya junta ixmaknican ju atapacxat ju ixlhik'ailakts'incan ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Slivasalh ju iclajunau. Tachi chun ju ani taxtokni si yu' ju alhimak'alhk'ajnana'it'it ju uxijnan ju chavai t'onat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ji amachak'an Jerusalén. Ju uxijnan makniyat'it ju lapanacni ju tajunan ixchivinti Dios chai lac'at'alhmat'it ju tamalakachanichin ju Dios. Na paklhu xaclanaviputunau ju uxijnan tachi ju navi is'ask'at'an ju tu'u' chila' acsni amak'atai la'ixpak'achu ni laich ca'alhist'ac'a'. Vachu' xaclamak'aixtokputunau ju uxijnan tachi ju qui'ask'at'an ni laich xaclalhistacvi vachu'. Para ju uxijnan jantu xalac'asq'uinat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pus ju chavai ju Dios maco'ulata ju milak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Chai iclajunau ni jantu lai aquintilalakts'inchoko ju chavai. Va acsni ju aquilalakts'inchokoyau acsni cachina' ju avilhchan ni acminchokoya' chai chani aquilajunau: “Paxcat ju ani minta la'ixtapaka'ut ju Dios”. ");
INSERT INTO teeNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Pus ju Jesús taxtulh ju lacpujitat. Chai acsni ix'amputun ju lacati pus ju ix'amamaka'ui talakmilh chai tamalacasunilh ju k'ai pujitat ni na c'us ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Para ju Jesús ajunich: ―Alakts'int'it ju ani ya k'exi chaka'. Slivasalh ju iclajunau. Jantu tu'u' catila'ucxtavi ju chiux ju ixt'achiux. Si calak'alhik'ocana'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Astan ju Jesús chai ix'amamaka'ui ta'alh ju xa'akstijun junta ixlacya ju xaq'uiu olivos. Chai acsni tolhcha ju Jesús pus vanin talakchilh ju ix'amamaka'ui junta va is'akstu'an laich catalacchivinilh. Chai tajuni ju Jesús: ―Aquilajuniuch. Tas vananch ju catapasaya' tachi ju xana'un. Chai tijuch ju catapasaya' ju lai acpuc'atsayau ni vanin at'amp'ut'una' chai ca'aclaya' ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Pus ju acsnich ju Jesús chani alacjuni: ―Alakts'int'it ni jantu xamati' cata'okxchok'on. ");
INSERT INTO teeNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pus na lhu catamina' chai catanonach ni yu'unch ju Cristo ju ixnoncan camalakachatachilh ju Dios. Chai na pumalhu ju cata'okxchok'oya'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Chai ak'asmat'a'it'it ni alin ju lhilucut chai ni cak'ostayachokochalh ali' lhilucut alacatam. Para tun t'ilact'alhanant'it. Pus akts'iya tasq'uini ni catapasaya' tachi chun ju ani taxtokni. Para jantiyu' ju ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Pus ju amachak'an lakatam k'ai lacat'un cat'alasachokoya' ju amachak'an alakatam k'ai lacat'un. Chai ju lapanacni ju tach'ak'ok'ai tam k'ai ucxtin catat'alasaya' ju ixlapanacni ju apumatam k'ai ucxtin. Chai ca'alina' ju k'ai chavanti chai na lacalhu catataclha' ju t'un. ");
INSERT INTO teeNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Para chux ju ani taxtokni va ixputai'ulacan ju mak'alhk'ajnat. ");
INSERT INTO teeNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ju acsnich amak'axt'akc'ana'it'it ni amamak'alhk'ajnic'ana'it'it. Chai catamakniyan ju ali'in lamilhi'uxijnan. Chai ju amachak'an tachi chun ju lacat'un cataxcayan va ixlaca'atalh ni quilach'ak'ok'ayau. ");
INSERT INTO teeNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chai na lhu ju quintalhilaksita catac'ap'ach. Chai catalaxcaya'. Chai ju yu'unch catamak'axt'ak'ach ju vanach quintalhilaksi. ");
INSERT INTO teeNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Chai na lhu ca'alina' ju lapanacni ju a'okxchok'onin. Ju yu'unch catalhitalacasuyach tachi ju lapanacni ju tanajun ixchivinti Dios mas jantu. Chai na lhu cata'okxchok'oya'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chai ni na lhu catalhavaya' ju alactu'unti pus na lhu lapanacni jantu vasalh catalamapainiya'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Para va tichi chavaich ju aquilhilaksiyach tus la'ix'aninti mas mamak'alhk'ajnican pus ju yuchi catak'alhtaxtuya' chai laich ca'ana' ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Chai ju chivinti junta najun ni lhinomputun ju Dios la'ix'alhunut'an ju lapanacni canonk'ocana' ixlhilacaputs'un ju lacamunutpa' ni laich catac'atsaya' tachi chun ju lapanacni. Chai acsnich ju caminach ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Pus ju mak'aniya lapanac ju Daniel ixjuncan ts'ok'ula junta naulh ni ca'alina' lamimpujitat'an ju tu'u' ju na ts'isi ju Dios. Chai ixlhiyuchi jantu xamati' ju milhi'uxijnan catanuya' ju anch. Pus ju lakts'in ju ani chivinti chach machakxa tuchi nomputun. ");
INSERT INTO teeNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Pus ju uxijnan acsni alakts'ina'it'it ni uctaxtulh ju anu' ju lhichivinilh ju Daniel pus tachi chun ju tavilanancha ju laxa'estado Judea chach ta'ats'alalh. Cata'alh ju lactalhpa. ");
INSERT INTO teeNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Chai ju ca'akstitavi lacasotea chaka' va ts'alhti catak'alhtaju chai ca'ats'alalh. Para jantu cati'alilh ju ispants'iquis ni lai catanu la'ixchaka' ni camaxtulh ju tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Chai ju ch'alhcatnan la'ixcuxtu vachu' ca'ats'alalh chai jantu cati'alilh ju ispants'iquis ni lai catanuchokolh ju lak'achak'an va ix'ica ju ixpumpu'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Chai paini'itnich catajuna' ju yu'unch ju va tak'ak'ainanta chai ju ta'amats'iquinin ju acsnich avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","At'ap'aininit'it ju Dios ni jantu chunch catapasaya' va lacalhic'asnin nin laca'avilhchan pa'astacni acsni lhik'alhtsajui ju ixlhamap'aksin ju Moisés ni makat ca'alhtanalh xamati'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Iclajunau ni chunch ju alaya'it'it ni palai k'ai ca'alina' ju acsni ju mak'alhk'ajnat tachi ju jantu tavanan alinta tus la'ixputai'ulacan ju lacamunutpa' tus chavai. Chai jantu tavanan ca'alinchokoya' ju chunch. ");
INSERT INTO teeNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Pus ju Dios ni jantu ca'ixnaulh ni palai va lacats'unin ca'ixnavi ju anuch avilhchan pus jantu xamati' ca'ixtak'alhtaxtulh. Para ni na amapaini ju lapanacni ju ix'alacsacxtuta ju Dios pus yuchi va lacats'unin lhinavilh ju anu' avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Pus ju acsni avilhchan ni xamati' catajunan ni anich vi ju yuchi ju ixnoncan camalakachatachilh ju Dios u anu' vilhcha pus jantu alac'a'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Pus ju acsnich na lhu cata'alina' ju okxchok'oni lapanacni ju catanona' ni yu'unch ju Cristo ju ixnoncan camalakachatachilh ju Dios. Chai vachu' cata'alina' ju a'okxchok'onin ju catalhitalacasuya' tachi ju lapanacni ju tanajun ixchivinti Dios. Chai ju yu'unch catanaviya' ju k'ai lhamak'an chai ju tu'u' ju catapumavasalaniputuna' ju lapanacni ni vasalh ixlapanacni Dios tajunita mas jantu. Chunch catanaviya' ni va laich calalh catapu'okxchok'olh ju asacxtuta ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Pus iclajuntau ni chunch ju catapasaya' mas jantuca' tapasai. ");
INSERT INTO teeNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Pus ni xamati' catajunan ni anu' vilhcha ju Cristo junta aseknic'a pus jantu ap'it'it. U ni catajunan ni anu' sek tanun lacachaka' pus jantu alac'a'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Pus ju uxijnan c'ats'ayat'it ni vanta anchach tasui ju mak'alipni'. Pus vana va chunch cajuna' acsni acminchokoya' ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Pus lana va tam pants'iquis acmina' chai lana aquintalakts'ink'oya' tachi chun ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Pus acsni na lhu ca'alina' ju alactu'unti pus acsnich ju ca'alina' ju ixmak'alhk'ajnat'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Ju Jesús tailhi'alh ju ixchivinti chai naulh: ―Pus acsni catapasayach ju anu' avilhchan acsni na lhu ca'alina' ju mak'alhk'ajnat pus ju avilhchan chai ju malhquiyu' jantu catamapulhcuya' chai ju st'acu catapatajuya' ju lact'iyan. Chai tachi chun ju ani taxtokni catalaclucununach. ");
INSERT INTO teeNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Chai ju acsnich catalacasuyach ju tu'u' ju lact'iyan ju catapuc'atsaya' ju lapanacni ni acmina' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani lacamunutpa'. Chai catalack'alhunach ju lapanacni ju ani lacat'un. Chai aquintalakts'inach ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Acmina' laxa'ataputs'i ju lact'iyan chai catac'atsaya' ju lapanacni ni na alin ju quintachaput chai ni icxak'ai. ");
INSERT INTO teeNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Chai na p'as cat'asaya' ju sk'olh. Chai ju quit'in acmalakachayach ju qui'anquilhnin chai ju yu'unch catamak'aixt'ok'ach ju icsacxtuta ixlhilacaputs'un ju lacamunutpa' mas palai makat amachak'an catava. ");
INSERT INTO teeNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Alakts'int'it tachi ju tak'ayai ju tu'u' xaq'uiu higuera. Acsni catsucutachilh xajnichini' ju sast'i xaxk'oi pus p'uc'ats'ayat'it ni vaninch minta ju lacap'asni. ");
INSERT INTO teeNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Pus vana va chun acsni alakts'ina'it'it ni t'ajun tapasana' tachi chun ju ani ju iclajuntau pus ap'uc'ats'aya'it'it ni vaninch minta ju ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Slivasalh ju iclajunau. Jantuca' catitanik'o ju chavai tat'ajun lapanacni acsni tuca' tapasak'ojui chux ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Pus ju lact'iyan chai ju lacat'un catalaclak'oya'. Para ju quinchivinti akts'iya ca'uctaxtuya'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Para jantu xamati' c'atsai tavanan cachina' ju anu' avilhchan chai ju anu' hora. Nin yu'unch ju anquilhnin ju tavilanancha ju lact'iyan nin quit'in ju ists'alh Dios icjunita. Va yuchi ju quimpai. Va is'akstu c'atsai. ");
INSERT INTO teeNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Pus tachi ju ixjunita ju is'atsucunti'an ju lapanacni acsni ixt'ajun ju Noé pus vana va chun ju cajuna' is'atsucunti'an ju lapanacni ju catatsucuya' acsni acminchokoya' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Pus ju anu' avilhchan acsni tuca' ix'akmuxtucan pus ju lapanacni ixtavajin chai ixta'ak'otnun chai ixtatamak'axt'ok'ach chai ixla'ican. Va chunch ju tatailhi'alh tachi ju akts'iya ixtalai tus ju anu' avilhchan acsni tanulh ju Noé lacabarco. ");
INSERT INTO teeNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Chai lana jantu talaca'ilh tus acsni milh ju akmuxtut chai tamuxtuk'o ixchux'an. Pus vana va chun cajuna' acsni acminchokoya' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ju acsnich ca'alinach ixt'iyun'an ju k'aixtam catach'alhcatnana' lacacuxtu. Chai ju pumatam calhi'ancana' ju lact'iyan. Chai ju pumatam catamaconach ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ca'alina' ixt'iyun'an chakolun ju k'aixtam catasquitiyach. Ju pumatam calhi'ancana' ju lact'iyan. Chai ju pumatam catamaconach ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Pus sk'ala ats'uc'ut'it ni jantu c'ats'ayat'it tavanan ju acminchokoya'. Quit'in ju mi'ucxtin'an icjunita. ");
INSERT INTO teeNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pus ac'ats'at'it ju ani. Ju tam lapanac ni va cac'atsa cava tavanan ju camina' ju ak'alhona' pus calhistaclh ju ixchaka'. Jantu catilacasq'uinilh ni catanu ni cak'alhaunilh tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Pus chunchach vachu' ju uxijnan. Alhist'acc'ant'it. Chunch ju alaya'it'it ni acsnich ju acmina' acsni jantu p'ast'ac'at'it ni laich acmilh ju acs pants'iquis. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ak'asmat'it ju ani chivinti. Ix'alin pumatam xalapanac ju lai ixlhilaksican chai ju na ix'ac'atsananta. Chai ju ix'ucxtin ula ju la'ixchaka' ni ca'axtakniyach ixvaiti'an ju ali'in acsni cha'an ju hora. ");
INSERT INTO teeNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Pus acsni caminchokoya' ju ix'ucxtin pus na cak'achanach ju anu' xalapanac ni calhitajucana' ni chunch ju t'ajun navini'. ");
INSERT INTO teeNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pus slivasalh ju iclajunau. Ni camuctaxtuya' ju anu' xalapanac pus ju ix'ucxtin lana calhilaksiya' ni laich calhistacniya' tachi chun ju ix'alinta. ");
INSERT INTO teeNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Para ju anu' xalapanac ni va k'ai junita cajunlh pus laich canaulh la'ix'alhunut ni ca jantu sai catiminchokolh ju ix'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Chai catsucuyach lhimakchapunu' ju ixt'axalapanacni chai va cat'avena' chai cat'ak'ot'ach ju t'ak'ap'anin. ");
INSERT INTO teeNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Chai ni chunch ju calalh pus ju ix'ucxtin ju anu' xalapanac laich acs cachilh acsni jantu pacxantaji ju yuchi. Cachilh acsni ixnajunta ni jantu catimilh ju acs pants'iquis. ");
INSERT INTO teeNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Pus ju ix'ucxtin lana camamak'alhk'ajniya'. Caxtakniya' ju mak'alhk'ajnat ju ca'axtaknicana' ju a'okxchok'onin. Chai ju anch junta camaca'ancana' na lack'alhuncan chai na mapak'atsican ju istatsalat'an ni na tamak'alhk'ajnan. ");
INSERT INTO teeNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ju Jesús tailhi'alh ju ixchivinti chai naulh: ―Junta lhinajun ju Dios chunch ju tapasai tachi ju tapasalh la'is'atsucunti'an ixpumacau'an atsi'in. Ju yu'unch tach'apalh ju ixmaclhcu'an chai ta'alh pakxtoknin ju ts'alh ju catamak'axt'ok'a' ni vachu' va ixtamak'amputun. ");
INSERT INTO teeNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pus ixpumaquis'an ju yu'unch na ixtanavi cuenta tuchi ixtanavi. Chai ju ixpumaquis'an jantu. ");
INSERT INTO teeNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Pus ju yu'unch ju jantu ixtanavi cuenta ju tuchi ixtanavi pus tamujulh ju ixmaclhcu'an para jantu talhi'alh ali' ju xapumaclhcu. ");
INSERT INTO teeNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Para ju na ixtanavi cuenta tuchi ixtanavi pus talhi'alh ixmaclhcu'an para vachu' talhi'alh ali' ixpumaclhcu'an la'ixlumeti'an. ");
INSERT INTO teeNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Pus ni jantu sai ixchinacha ju ts'alh ju catamak'axt'ok'a' pus na ixtalaclhtataputun ixchux'an ixpumacau'an chai talaclhtatatavilh. ");
INSERT INTO teeNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Para acsni cha'alh paitat ts'is tak'asmatnilh ixchivinti ju pumatam ju p'as naulh: “Mintach ju ts'alh ju catamak'axt'ok'a'. A'inchit'it pakxtoknin”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Pus ju acsnich tachi chun ju anu' atsi'in tataya. Tatsuculh lak'oxinin ju ixmaclhcu'an. ");
INSERT INTO teeNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Chai ju yu'unch ju jantu ixtanavi cuenta tuchi ixtanavi chani tajuni ju yu'unch ju ixtalhiminta ju ixpumaclhcu'an: “Aquilamach'ixtakniuca' lacats'unin ju mimpumaclhcu'an. Ju quimaclhcu quinc'an ni va mixputun”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Para ju yu'unch ju ixtanavi cuenta tuchi ixtanavi ta'ak'alhtayanalh. Tajunich: “Jantu. Ca jantu catilhiva ju quilhichux'an. Alai inchit'it tamonin junta st'acan. At'ama'ut'it vachu' ju mi'anu'an ju uxijnan”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Para acsni ixta'anta tamonin ju ixpumaclhcu'an ju anu' ixpumaquis'an atsi'in pus lana chincha ju ts'alh ju catamak'axt'ok'a'. Pus ju ixpumaquis'an ju na ixtalakasivilanalh vachu' maktanulh junta xatanui ju ts'alh ju calhimac'atanicana' ni catamak'axt'ok'a'. Chai lana malacchaucalh. ");
INSERT INTO teeNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Astan tachinchalh vachu' ju ali'in atsi'in. Chai tajuni: “Qui'amigo aquilamalhtek'aniuch”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Para ju anu' ts'alh ak'alhtayanalh. Alacjuni: “Slivasalh ju iclajunau. Jantu iclamispayau ju uxijnan”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Pus acsni nonk'olh ju Jesús ju ani chivinti astan alacjuni ju anch ixtavilanalh: ―Vachu' chunch alat'it tachi ju talalh ju anuch atsi'in ju ixtalakasivilanalh. Vachu' alak'asits'uc'ut'it ni jantu c'ats'ayat'it tuchi avilhchan u tuchi hora ju acminchokoya'. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Alak'asits'uc'ut'it ni chunch ju tapasai junta lhinajun ju Dios tachi ju tapasalh la'is'atsucunti'an ixlapanacni pumatam mak'ali'. Pus ju anu' lapanac ix'amputun makat. Chai acsni jantuca' an pus at'asanilh ju ixlapanacni chai amach'ixtaknilh tachi chun ju ix'alinta. ");
INSERT INTO teeNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pus ju pumatam xtaknilh lakaquis milh. Ju apumatam lakat'ui milh. Chai ju apumatam tam milh. Xtaknilh pumatamin tachi ju laich catapuch'alhcatnalh. Chai astan ju yuchi alh makat. ");
INSERT INTO teeNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pus ju anu' xalapanac ju ixmach'ixtaknita lakaquis milh alh puch'alhcatna' chai lhajachokolh alakaquis milh. ");
INSERT INTO teeNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Vachu' chunch lalh ju ixmach'ixtaknita lakat'ui milh. Ju yuchi puch'alhcatnalh ju lakat'ui chai lhajachokolh alakat'ui milh. ");
INSERT INTO teeNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Para ju anu' xalapanac ju mach'ixtaknicalh va tam milh lhi'alh ju tumin chai quimacnulh ju lacat'un ni jantu cats'ank'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Chai acsni na mak'anch va pus minchokolh ju ix'ucxtin'an ju anu' xalapanacni. Chai ju yuchi tsuculh alact'aput'ek'eni'. ");
INSERT INTO teeNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Pus ju anu' ju ixmach'ixtaknicanta lakaquis milh lakmilh ju ix'ucxtin. Vachu' lhiminilh ju alakaquis milh ju ixlhajatach. Chai juni: “Qui'ucxtin ju uxint'i q'uimach'ixt'aknit'a lakaquis milh. Pus ju chavai acxtakniyan ju alakaquis milh ju icpulhajalh”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Chai ju ix'ucxtin juni: “Na k'ox xanavi. Ju uxint'i na k'ox lapanac unit'a chai na lai lhilaksic'an. Laich xalhist'ac'a lacats'unin. Pus ju chavai palai lhu acxtakniyan ju alhist'ac'a'. At'anut'ich junta icvi ni laich k'aixtam cak'achanau”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Chai astan chinchalh ju ixmach'ixtaknicanta ju lakat'ui milh. Chai ju yuchi junilh ju ix'ucxtin: “Ju uxint'i lakat'ui milh xaq'uimach'ixt'aknit'a. Pus ju chavai iclhiminitan vachu' alakat'ui milh ju iclhajata”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Chai ju ix'ucxtin juni: “Na k'ox xanavi. Ju uxint'i na k'ox lapanac unit'a chai na lai lhilaksic'an. Laich xalhist'ac'a lacats'unin. Pus ju chavai palai lhu acxtakniyan ju alhist'ac'a'. At'anut'ich junta icvi ni laich k'aixtam cak'achanau”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Chai vachu' chinchalh ju ixmach'ixtaknicanta ju tam milh. Chai ju yuchi junilh ju ix'ucxtin: “Xacc'atsai ni na p'as ju mi'alhunut ju uxint'i. Pus alakts'ich. Yu'unch ju milapanacni ju tach'alhcatnan ni laich na lhu cajuna' ju micebada. Chai yu'unch ju talacsununiyan ju micebada ni laich lhu amak'aixt'ok'a' ju uxint'i mas jantuch tu'u' talhajai ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Pus yuchi na xaclhitalhoniyan chai jantu xacpuch'alhcatnamputun ju mintumin. Pus ic'alh. Icmacnulh ju mintumin lacat'un. Anich iclhiminichokotan ju mi'anuch”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Pus ju acsnich ju ix'ucxtin chani juni: “Ju uxint'i na alact'u'unun chai na malheknin. Na'unch ni c'ats'aich ni ali'in ju tach'alhcatnan ni laich lhu ca'alilh ju quicebada. Chai ali'in ju quintalacsununi ju quicebada ni laich lhu acmak'aixt'ok'a'. Chai jantu tu'u' ic'axtakni ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Pus ni vasalh chunch q'uilakts'in pus palai k'ox ixva ni ixt'aknin ju quintumin ju lai tapuch'alhcatnan tumin. Ju chunch acsni xacmilh xac'amaklhtayananchokolh ju quintumin chai chux ju is'ask'at'a”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pus ju acsnich ju yuchi ajunilh ju ali'in ju ixtayanancha: “At'ai'init'it ju tam milh. Chai axt'aknit'it ju pacxanta lakacau milh. ");
INSERT INTO teeNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chunch ju alat'it ni palai lhu caxtaknicana' ju pacxanta tu'u'. Chai ju chunch palai lhu ca'alina' ju ix'alinta. Para ju mati' tu'u' pus catai'inicana' ju tuchi najun ni pacxanta. ");
INSERT INTO teeNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Chai ju ani lapanac ju jantu tu'u' ixtapalhni junita amac'ap'it'it laca'atats'isni lhimakspa'. Ju anch na lack'alhuncan chai na malatank'atsican ju istatsalat'an ni na tamak'alhk'ajnan”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ju Jesús tailhi'alh ju ixchivinti chai naulh: ―Ju quit'in quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Chai acsni acminchokoya' laquintachaput ac'alact'amina' tachi chun ju qui'anquilhnin chai ju acsnich ac'amaklhtayanana' ju quimpu'ucxtin chai slivasalh xak'ai acjuna'. ");
INSERT INTO teeNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Chai catak'aixt'ok'ach laqui'ucxlacapu' tachi chun ju amachak'an ixlhilacaputs'un ju ani lacat'un. Chai ju quit'in ac'alhvakpitsiya' ju yu'unch tachi ju navi tam alhistacna' acsni alhvakpitsi ju ixborregojni chai ju ixchivojni. ");
INSERT INTO teeNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pus ju lapanacni ju soknic'a alakts'in ju Dios catatayaya' laquilhicana. Chai ju lapanacni ju alactu'unun catatayaya' laquilhimacx. ");
INSERT INTO teeNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Chai ju acsnich ni k'ai ucxtin acjuna' pus ac'alacjuna' ju yu'unch ju tayanalh laquilhicana: “At'at'it ju uxijnan ju taxtaknitan ju k'ox mi'atsucunti'an ju quimpai. At'anut'it ju lact'iyan junta lhinajun ju yuchi ni anch ju talak'oxinitan tus acsni tavanan navicantacha ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Pus iclajunau ni ap'ina'it'it ju anch ni quilaxtakniu ju quivaiti acsni na xacchavanita. Chai quilaxtakniu ju ick'otlh acsni na xacquicxixta. Chai quilaxtakniu junta ictavi acsni makat xacmintacha. ");
INSERT INTO teeNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Chai acsni mati' ixjunita ju quimpumpu' pus quilaxtakniu. Chai acsni na xactak'ank'ai pus quilaquilakts'iu. Chai acsni xact'alhnucanta quilaquilakts'iu”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Pus ju acsnich ju yu'unch ju alakts'incan ni soknic'a is'atsucunti'an catajunach: “Para ji qui'ucxtin tas vananch ju iclalakts'iu ni va ixch'avanit'a chai iclaxtakniu ju mivaiti. U ni ixq'uicxixt'a chai iclaxtakniu ju xak'ot'a. ");
INSERT INTO teeNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Tas vananch ju makat ixt'ant'achi' chai iclaxtakniu junta xatolai. U va mati' ixjunita ju mimpumpu' chai iclaxtakniu. ");
INSERT INTO teeNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Tas vananch ju icquilalakts'iu acsni va ixt'ak'ank'ai u ixt'alhnuc'ant'a”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Pus ju acsnich ju quit'in ju k'ai ucxtin acjuna' chani ac'alacjunach: “Slivasalh ju iclajunau. Ni chunch ju xanaviniyat'it ju tam quilhilak'au mas yuchi ju noncan ni jantu tu'u' ixtapalhni pus va jun quit'inch ju chunch xaquilanaviyau”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Chai ju acsnich ni k'ai ucxtin acjuna' pus ac'alacjuna' ju yu'unch ju tayanalh laquilhimacx: “Ak'ost'it laquimacni ju uxijnan ju ulanic'ant'at'it ju mintalak'alhin'an. A'inchit'it ju lacajipi ju jantu tavanan mix. Anch junta lak'oxinicanta ju lhacaticuru chai ju ix'anquilhnin. ");
INSERT INTO teeNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Pus ju quit'in acsni na xacchavanita jantu xaquilaxtakniyau ju quivaiti. Chai acsni na xacquicxixta jantu xaquilaxtakniyau ju ack'otlh. ");
INSERT INTO teeNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Chai acsni na makat ju xacminacha jantu xaquilaxtakniyau junta lai actavi. Chai acsni mati' ixjunita ju quimpumpu' jantu xaquilaxtakniyau. Chai acsni na xactak'ank'ai chai acsni xact'alhnucanta jantu xaquilaquilakts'inau”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Pus ju acsnich ju yu'unch chani aquintajuna': “Ucxtin tas vananch iclalakts'iu ni na ixch'avanit'a u ixq'uicxixt'a u makat ixt'ant'achi' u mati' ixjunita ju mimpumpu' u va ixt'ak'ank'ai u ixt'alhnuc'ant'a chai jantu tu'u' xaclanaviniyau”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Chai ju quit'in ju k'ai ucxtin acjuna' pus chani ac'ajuna': “Slivasalh ju iclajunau. Ni jantu xanaviniyat'it tu'u' lamapainin ju ani ju quintalhilaksi ni va ixnonat'it ni jantu tu'u' ixtapalhni'an ju yu'unch pus tachi ju va jun quit'in ju jantu tu'u' xaquilanaviniyau”. ");
INSERT INTO teeNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Pus ju acsnich ju yu'unch cata'anach lacamak'alhk'ajnat ju jonk'alhita. Para ju alakts'incan ni soknic'a ju is'atsucunti'an cata'ana' junta alin ju atsucunti ju jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pus ju Jesús acsni nonk'o chux ju ani chivinti pus chani ajuni ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Ju uxijnan c'ats'ayat'it ni va lakat'ui avilhchan tic'acx tus ca'alinach ju c'atan ju ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju ists'alan ju mak'aniya milacpa'itni'an. Pus ju acsni c'atan acmak'axtakcana' ni laich acmaquilhtacana' ju lacacurus. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Pus lana acsni avilhchan vachu' tatak'aixtoklich ju xalack'ajin palijni chai ju xapapaninch ju anu' lak'achak'an chai ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Tatak'aixtoklich ixpulacni k'ex junta ixlakachak'axnucanta ju ixchaka' ju xak'ai pali ju Caifás ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tatsuculh lhilacchivinin ta yu laich catapu'okxchok'och'apaya' ju Jesús chai catamakniyach. ");
INSERT INTO teeNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Para ixtalaclajuni: ―Para jantu cach'apayau ju lacac'atan ni va lai tatalhk'amalh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ju Jesús ixvilhcha lak'achak'an Betania la'ixchaka' ju Simón ju ixlacats'its'ita para palaich ixnavita ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chai pumatam chako'ulh lakmilh ju Jesús. Ixlhiminta lakatam lumeti ju ixpumujuta ju perfume ju na laklhu ixtapalh ixjunita. Chai ju yuchi tsuculh lacpaxt'ek'emuc'ana' ju Jesús acsni ixvi lacamixa. ");
INSERT INTO teeNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Para ju ix'amamaka'ui ju Jesús acsni talakts'ilh na tatalhk'amalh. Talaclajunich: ―Tajuch ni va xalhak'amanan ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ju ani perfume lai laklhu ixlhist'acalh chai ju ixtapalh laich ixlhik'ailakts'ilh ju quilhpatinin. ");
INSERT INTO teeNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Para ju Jesús acsni machakxa tuchi ixtalaclajuni pus chani alacjuni: ―Tajuch ni va lhixc'ayat'it ju ani ya chako'ulh. Slivasalh na k'ox ju xaquinavi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Pus ju quilhpatinin akts'iya ca'alinach junta vilat'it. Para ju quit'in jantu actilat'a'alhtanank'alhiu. ");
INSERT INTO teeNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Chai ju ani perfume ju xaquixt'ek'emuc'ani laquilacatuna quixt'ek'emuc'anilh ni chunch ju lhilanicantau ni xamati' ta'acnui. ");
INSERT INTO teeNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Slivasalh ju iclajunau. Vanta lhi'anchach ju ani lacamunutpa' junta canoncana' ju chivinti ju quilacata pus vachu' canoncana' tuchi xanavich ju ani chako'ulh. Ju chunch jantu tavanan cacapcanach ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ju acsnich pumatam ju ixlhipumacaut'ui'an ju ix'amamaka'ui ju Jesús alak'alh ju xalack'ajin palijni. Pus ju yuchi Judas Iscariote ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Chai chani alacjuni: ―Tas chunchach ju aquilaxtakniyau ni aclamak'axtakniyau ju Jesús. Pus ju yu'unch talhit'atak'oxilh lakp'uxamcau plata tumin. Chai amaklhtayanalh ju Judas. ");
INSERT INTO teeNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chai tus acsni ju Judas puxcaulh ta yu laich capumak'axt'ak'a' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ju xap'ulhnan avilhchan ju anu' c'atan acsni jantu ixtalhiyajui ju xat'in ju ixkapavati'an pus talakmilh ju Jesús ju ix'amamaka'ui. Chai tajuni: ―Tas anchach ju lac'asq'uin ni aclak'oxiu junta ca'uyau ju borrego. ");
INSERT INTO teeNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Pus ju Jesús alacjuni: ―A'inchit'it ju lak'achak'an la'ixchaka' ju pumatam qui'amigo. Chai chani a'una'it'it: “Ju amamaka'unu' najun ni ma chinta ju ix'avilhchan chai ma laminchakach ju cat'a'uya' ju borrego ju ix'amamaka'ui”. Chunch ju a'una'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Pus ju ix'amamaka'ui ju Jesús ta'alh chai tanavilh tachi ju ix'ajunita ju Jesús. Chai talak'oxilh ju ixpuc'atanit'an. ");
INSERT INTO teeNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Chai ju anu' avilhchan acsni tok'oxalh pus ju Jesús alact'atavilh lacamixa ixpumacaut'ui'an ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Chai acsni ixtat'ajun venin pus ju Jesús chani alacjuni: ―Slivasalh ju iclajunau. Pumatam ju milhi'uxijnan aquimak'axt'ak'ach. ");
INSERT INTO teeNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pus ju acsnich na ta'amak'aninilh ju yu'unch. Chai k'antam k'antam tasacmich. Tajunich: ―Para ja quit'in ji qui'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Chai ju Jesús ak'alhtailh. Alacjuni: ―Yuchi ju va k'aixtam quint'atamack'oi laquinc'a'ulh. Yuchi ju aquimak'axt'ak'ach. ");
INSERT INTO teeNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Pus akts'iya acniya' tachi ju ts'okcanta la'ixchivinti Dios ju quilacata. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Para painich ju anu' lapanac ju aquimak'axt'ak'a'. Palai k'ox ca'ixva ni jantu ca'istsuculh ju anu' jok'at. ");
INSERT INTO teeNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Pus ju acsnich chivinilh ju Judas. Yuchi ju camak'axt'ak'a'. Junich: ―Para ja quit'in ji amamaka'unu'. Chai ju Jesús juni: ―Uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Chai acsni ixtat'ajun venin pus ju Jesús ch'apalh ju xkapavati chai xtaknilh lak'ailakts'iuch ju Dios. Chai astan lacch'ek'elh. Chai axtaknilh ju ix'amamaka'ui. Chai ajuni: ―A'ut'itch. Ju ani yuchach ju quilacatuna. ");
INSERT INTO teeNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Chai astan ch'apalh tam vaso ju vino. Xtaknilh lak'ailakts'iuch ju Dios. Chai axtaknilh ju yu'unch. Chai ajuni: ―Ak'ot'it minchux'an. ");
INSERT INTO teeNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ju yuchi qui'ac'alhni. Chai acsni cataxtuya' ju yuchi pus capumavasalaya' ju sast'i chivinti ju ca'alact'atak'oxiya' ju Dios ju lapanacni ni laich ca'amac'acxaniya' ix'alactu'unti'an na lhu lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Para iclajunau ni jantu actik'otchokolh ju vino tus acsni cachina' ju avilhchan acsni aclat'ak'otchokoyau ju uxijnan ju sasast'i vino junta lhinajun ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Acsni nonk'o ju chunch ju Jesús pus tamilhpa lakatam milhpat. Tataxtulh. Ta'alh laxa'akstijun junta ixya ju xaq'uiu olivos. ");
INSERT INTO teeNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Chai acsni ixta'anta ju lacati pus ju Jesús alacjuni ju ix'amamaka'ui: ―Chux ju uxijnan aquilamaco'ulayau ju chavai atats'isni. Icc'atsai ni chunch ju catapasaya' ni chunch ju ts'okcanta la'ixchivinti Dios junta chani najun ju yuchi: “Acmakniya' ju xa'alhistacna' chai ju ixborregojni catata'akpitsiyach”. Chunch ju najun la'ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Para aclok'onchokoyach chai quit'in ju p'ulhnan accha'ana' ju laxa'estado Galilea. Astan ach'ip'ina'it'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pus ju acsnich ju Pitalu' chani juni ju Jesús: ―Mas chux ju ali'in catatalhanana' ju milacata para ju quit'in jantu tavanan actitalhanalh. ");
INSERT INTO teeNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Para ju Jesús juni: ―Slivasalh ju icjunan. Acsni tuca' t'asai ju puyux acsni t'ajunch tuncuntilana' pus ju uxint'i pakt'utu na'unt'a ni jantu q'uimisp'aich. ");
INSERT INTO teeNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Para ju Pitalu' naulh: ―Mas tus act'aninch jantu lai tavanan actinaulh ni jantu icmispayan. Chai vana va chun tanaulh chux ju ali'in ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Pus ju acsnich ju Jesús alact'acha'alh ju ix'amamaka'ui junta Getsemaní juncan. Chai alacjuni ju yu'unch: ―At'olat'itca' ju ani. Chactiquit'achivinin ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Chai ak'ailhi'alh ju Pitalu' chai ixt'iyun'an ists'alan Zebedeo. Chai tsuculh amak'anini' chai na xcanilh ju ix'alhunut. ");
INSERT INTO teeNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Pus ju acsnich alacjuni ju ixpumat'utu'an: ―Slivasalh na ic'amak'aninin. Tachi ju va ict'ajun nini' ju chavai. At'olat'itca' ju ani. Aquilat'ak'alhcujvich lacats'unin. ");
INSERT INTO teeNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Pus ju acsnich ju Jesús alhtanampa lacats'unin. Chai lana taquilhputalh chai tsuculh t'achivini' ju Dios. Junich: ―Quimpai chach jantu alilh ju mak'alhk'ajnat ju q'uilhc'anit'a. Para jantu anavit'i tachi ju iclacasq'uinch ju quit'in. Alai anavit'i chunch tachi ju lac'asq'uinch ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Pus acsni nonk'o ju chunch ju Jesús pus alakchinchokolh ju ixpumat'utu'an ix'amamaka'ui. Chai alhitajulh ni na ixtalhtatanan. Pus ju Jesús junilh ju Pitalu': ―Ja va jantu lai quilat'ak'alhcujau mas va pants'iquis. ");
INSERT INTO teeNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ak'alhc'ujt'it chai at'ach'ivinint'it ju Dios. Ju chunch jantu cata'okxchok'oyan ju lhacaticuru. Pus ju lami'alhunut'an vasalh navip'ut'unat'it ju k'ox. Para ju va lami'akstu'an jantu lai naviyat'it. ");
INSERT INTO teeNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Pus aktam anchokopa ju ixlhipakt'uich t'achivini' ju Dios. Chai chani juni ju ixpai: ―Quimpai ni jantu lai aq'uint'imak'osunin ju ani k'ai mak'alhk'ajnat pus anavit'ich tuch'i lac'asq'uin ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Pus acsni nonk'o ju ani chivinti pus tasp'itchokocha chai aktam alhitajuchokopa ju ixpumat'utu'an ni aktam na ixtalhtatananchokopalai ni slivasalh na ixtalhtataputunch. ");
INSERT INTO teeNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Pus amaconchokolh chai anchokopa aktam t'achivini' ju ixpai ixlhipakt'utuch. Chai vana va yu' ju junchokopa. ");
INSERT INTO teeNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ju acsnich alakminchokopa ju ixpumat'utu'an chai alacjuni: ―Ja lana va alht'at'ak'alhiya'it'it chai ast'acnank'alhiya'it'it. Chilh ju hora chai acmak'axtakcana' la'ixmaca'an ju alactu'unin. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ak'ost'olat'it. Ca'auch apakxtoknin. Anich minta ju aquimak'axt'ak'ach. ");
INSERT INTO teeNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ju Jesús tuca' ixchivink'ojui acsni chincha ju Judas ju ixlhipumacaut'ui'an ixjunita. Chai alact'amilh ixtalhavat lapanacni ju ix'amalakachata ju xalack'ajin palijni chai ju xapapaninch ju anuch lak'achak'an. Ixtalhiminta ixmachita'an chai ixq'uiu'an. ");
INSERT INTO teeNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Pus ju Judas ju amak'axtakna' ix'ajunita ju ali'in ta yu catapumispayach. Ix'ajunita: ―Ju acmacch'uch'uyach yuchach. Ach'ap'aya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pus ju acsnich ju Judas lana lakcha'alh ju Jesús chai juni: ―Xanchi qui'amamaka'unu'. Chai lana macch'uch'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Pus ju Jesús juni: ―Qui'amigo tijuch ju lakt'ant'a. Pus ju acsnich lana tachincha ju ali'in. Tach'apalh ju Jesús chai tach'in tanavi. ");
INSERT INTO teeNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Para ju pumatam ix'amamaka'ui ju Jesús maxtulh ju ixmachita chai chakxp'uxnilh ju ix'ak'axk'olh ixlapanac ju xak'ai pali. ");
INSERT INTO teeNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Pus ju acsnich ju Jesús juni: ―Amak'ach'ok'och ju mimachita laxapajina. Icjunan chunch ni tachi chun ju catapulasaya' lacamachita pus lacamachita ca'amaknicanach. ");
INSERT INTO teeNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ja va jantu c'ats'ai ni lai actitapaininilh ju quimpai chai ju yuchi lai aquixtaknilh ixtalhavat'an ju anquilhnin. ");
INSERT INTO teeNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Para ni chunch ju aclalh tas laich calhi'uctaxtulh tachi chun ju ts'okcanta la'ixchivinti Dios ju quilacata. ");
INSERT INTO teeNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Pus ju acsnich ju Jesús alacjuni ju ixtalhavat'an lapanacni: ―Tajuch ni va quilanaviyau tachi ju tam ak'alhona' ju ch'ap'ap'ut'unat'it ni lhit'ant'at'it ju mimachita'an chai ju minq'uiu'an. Pus chux avilhchan xaclat'avilau ju uxijnan acsni xac'amalaninin ju lacpujitat chai jantu xaquilach'apayau ju acsnich. ");
INSERT INTO teeNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Para chunch ju t'ajun tapasana' ni laich capu'uctaxtuya' tachi chun ju tats'oklh la'ixchivinti Dios ju ixlapanacni ju quilacata. Pus acsni nonk'o ju chunch ju Jesús pus tachi chun ju ix'amamaka'ui ta'ats'alalh. Tamacoyaulh is'akstu ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Pus ju yu'unch ju taquich'apalh ju Jesús talhi'anilh ju Caifás ju xak'ai pali ixjunita. Chai vachu' anch tatak'aixtoklh ju papaninch chai ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pus ju Pitalu' va ixlhimakat ix'ach'ak'ok'ata ju yu'unch. Jantu va k'aixtam xa'alact'atanui acsni talhicha'alh ju Jesús la'ixpulacni ta ixlakachak'axnucanta ju ixchaka' ju xak'ai pali. Tus astan tanulh vachu' ju Pitalu' pulacni chai alact'atavi ju xapulasiyajni. Va ixlakts'imputun tuchi catapasayach. ");
INSERT INTO teeNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Pus ju xalack'ajin palijni chai ju papaninch chai chux ju xalack'ajin na ixtapuxcajui tichi chavaich ju laich canaulh tu'u' ta'aklhtamat ta yu laich catapulhinaulh ixmaknica ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Para jantu tavanan talhitajunilh tu'u' talak'alhin mas na lhuch lapanacni ixtanajun ta'aklhtamat chivinti. Para astan xcayama talhitajulh ixt'iyun'an ju vaklhtam chun ixtanajun lakatam ta'aklhtamat chivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Tanaulh: ―Ju ani ya lapanac naulh ni ma lai calak'alhiya' ju ixpujitat Dios chai ma va lakat'utu avilhchan ma capunavichokoya'. ");
INSERT INTO teeNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pus tayalh ju xak'ai pali chai junilh ju Jesús: ―Ja jantu tu'u' ak'alht'ayanana'. Tijuch ju talhichivimak'anan ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Para ju Jesús jantu tu'u' lhik'alhtailh. Pus ju acsnich ju xak'ai pali juni: ―Alhip'ast'act'i ju Dios ju t'ajun chai aquilajuniu ni vasalh Cristo'at ju ixnoncan camalakachatachilh ju Dios. Ja vasalh ists'alh'at. ");
INSERT INTO teeNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Chai ju Jesús juni: ―Vasalh tachi ju na'un. Chai vachu' aclajunau ni astan aquilalakts'inau acsni actola' vanin junta vi ju Dios chai acmina' laxa'ataputs'i lact'iyan. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Pus ju acsnich ju xak'ai pali lana lht'it k'exlh ju ixpumpu' ju va ixtalhk'amtich. Chai ajuni ju ali'in: ―Na macxcai chivinti xanajun ni tachi ju Dios ju jumputun. Tis ali' asacminti tasq'uini ni canaviu ju chavai ni k'asmatniyat'it ju macxcai ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","T'as nonat'it ju uxijnan. Pus ju yu'unch tanaulh: ―Na ka'i ixtalak'alhin. Tasq'uini ni canilh. ");
INSERT INTO teeNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Chai ju acsnich talacpuchujva. Chai talacpusama. Chai talakpuch'i. Chai ju ali'in taquincatisamalh. ");
INSERT INTO teeNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Tajuni: ―Ju uxint'i ni sala Cristo'at pus aquilajuniuch tichi chavaich ju xa'ulaniyan. ");
INSERT INTO teeNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pus ju Pitalu' lhimakspa' ixvilhcha. La'ixpulacni k'ex. Chai lakmilh pumatam atsi' chai juni: ―Ju uxint'i vachu' ixt'a'ucxunt'a'un ju Jesús amachaka' xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Para ju Pitalu' naulh la'ix'ucxlacapu'an ju ixtavilanalh anch ni jantu mispai ju Jesús. Junich ju atsi': ―Jantu icc'atsai tuch'i na'un. ");
INSERT INTO teeNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pus ju Pitalu' taxtulh. Chai acsni talacxtutaya pus apumatam atsi' lakts'impa chai ajuni ju ixtavilanalh: ―Ju ani vachu' ixt'a'ucxunt'ajun ju Jesús amachaka' Nazaret. ");
INSERT INTO teeNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Chai ju Pitalu' nonchokopa aktam ni jantu mispai. Tus lhipastack'o ju Dios acsni chani alacjuni: ―Jantu lana icmispai ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Chai ni pants'iquis jumpa pus talak'ampa ju Pitalu' ju lapanacni ju ixtavilanalh anch. Chai tajuni: ―Slivasalh vachu' mak'uxint'i ni vachu' chunch ju ch'ivinin. ");
INSERT INTO teeNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pus ju acsnich ju Pitalu' tsuculh nona' macxcai chivinti chai lhipastacchokolh ju Dios chai alacjuni: ―Jantu icmispai ju anu' lapanac. Pus lana t'asalh ju puyux ju acs pants'iquis. ");
INSERT INTO teeNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Chai lana pastaclh ju Pitalu' ju chivinti ju ixjunita ju Jesús acsni junilh ni ma pakt'utu canona' ni jantu mispai ju yuchi. Chai ma chunch canona' acsni tuca' t'asai ju puyux acsni t'ajun tuncuntilana'. Chai acsni pastaclich ju chunch ju Pitalu' pus lana taxtulh makspa'. Chai slivasalh na k'alhulh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pus acsni tunculh chux ju xalack'ajin palijni chai ju xapapaninch ju israelitanin va k'aixtam tanaulh ni akts'iya catalhinona' ixmaknica ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Pus tach'ilhi'alh chai taquimak'axtaknilh ju Pilato. Pus ju yuchi ixgobernador'an ixjunita ju romanonin. ");
INSERT INTO teeNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Pus ju Judas ju ix'amak'axtaknanta acsni c'atsalh ni tanaulh ju xalack'ajin ni camaknicana' ju Jesús pus tam xapastacchokoi. Chai alhiminichokolh ju lakp'uxamcau tumin ju xalack'ajin palijni chai ju xapapaninch. ");
INSERT INTO teeNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Chai alacjuni: ―Icnavilh alactu'unti ni iclamak'axtaknitau ju lapanac ju mati' ixtalak'alhin. Para ju yu'unch tajuni: ―Ju yuchi jantu quincuenta quinc'an. Mincuenta mi'akstu ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Pus ju Judas mak'alh ju anu' tumin la'ixpulacni lacpujitat chai taxtulh. Alh. Chai pixtuch'imaknichokocalh is'akstu. ");
INSERT INTO teeNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pus ju xalack'ajin palijni tasaclh ju anu' tumin chai talaclajuni: ―Jantu lhijun ni laich va calalhiyochoko ju ani tumin junta mak'atau ju ixtalhavat tumin ju xtakcan lacpujitat. Jantu lai chunch catilau ni ixtapalhch lapanac ju ani tumin. ");
INSERT INTO teeNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Pus ixchux'an tanaulh ni catalhitamoya' ju anu' tumin lakatam lacat'un. Chai anchach ju catata'acnuyach ju amachak'an makat ju tani ju anch lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Pus yuchi lhijunicalh ju anu' lacat'un ni xalacat'un ixtapalh lapanac. Chai jonk'alhitach chun tus chavai. ");
INSERT INTO teeNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Chai ni chunch ju talalh pus uctaxtulh tachi ju ixnajunta ju mak'aniya ixlapanac Dios ju Jeremías ixjuncan. Ju yuchi ma chani naulh: “Ju israelitanin ma tach'apalh ju lakp'uxamcau tumin tachi ju ixtalhcaich ixtapalhch cava ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Chai ma talhitamaulh ju lacat'un junta catata'acnuyach ju amachak'an makat. Ma tanavilh ju yu'unch tachi ju xaquijuni ju Dios ni catanaviya'”. Chunch ju naulh ju mak'aniya ixlapanac Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Pus ju Jesús ixya la'ix'ucxlacapu' ju ixgobernador'an ju romanonin. Chai ju yuchi sacmilh ju Jesús. Junich: ―Ju uxint'i ja ix'ucxtin'at ju israelitanin. Chai ju Jesús juni: ―Chunch tachi ju na'un. ");
INSERT INTO teeNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Chai acsni ixtachivimak'an ju yuchi ju xalack'ajin palijni chai ju papaninch pus ju Jesús jantu tu'u' ak'alhtayanalh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pus ju acsnich ju gobernador Pilato junilh: ―Ja va jantu k'asmat'i tachi chun ju tachivimak'anan ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Para ju Jesús jantu tu'u' lhik'alhtailh nin tachi lakatam chivinti. Pus ixlhiyuchi na lhamak'aninilh ju gobernador. ");
INSERT INTO teeNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pus ju israelitanin ixtalhismanita ni chux c'ata ix'amaconi tam tach'in ju gobernador acsni ixchin ju ani c'atan. Ix'amaconican va tichi chavaich ixtalacasq'uin. ");
INSERT INTO teeNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Pus ju acsnich ixt'alhnucanta pumatam tach'in ju ismispak'ocanta ni na k'ai ixjunita. Chai ju yuchi Barrabás ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pus ju Pilato acsni amak'aixtoklh ju xalack'ajin sia yu'unch ju israelitanin pus ajuni: ―Tis chavaich ju lac'asq'uinat'it ni aclamaconiyau. Ja yuchi ju Barrabás u yuchi ju Jesús ju vachu' Cristo juncan. ");
INSERT INTO teeNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pus ju Pilato ajuni chunch ni isc'atsai ni va ixtalhaccha'ani ju Jesús. Yuchi talhimak'axtaklh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pus acsni ixvi ju Pilato lacapu'ucxtin pus ix'amachaka' malakachanilh chivinti. Juni: “Tun tu'u' anavit'i ju ani soknic'a lapanac ni na lhu xacmak'alhk'ajnan ju lhiyaxch ts'is ni icmac'atsanicalh ni k'ai talak'alhin cava ni tu'u' anaviya' ju yuchi”. ");
INSERT INTO teeNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Para ju xalack'ajin palijni chai ju papaninch tamalaca'ini ju ixtalhavat lapanacni ni catasq'uinlich ni Barrabás ju camacajuncalh. Chai yuchach ju camaknicalh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pus ju gobernador ajunchokopalai aktam ju lapanacni: ―Ju anu' ixt'iyun'an tis chavaich ju lac'asq'uinat'it ni aclamacaulh. Chai ju yu'unch tajuni ni yuchi ju Barrabás. ");
INSERT INTO teeNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pus ju Pilato ajuni: ―Pus tas act'alayach ju Jesús ju vachu' Cristo juncan. Chai ju ixtalhavat lapanacni tanaulh: ―Alhinauch ixmaquilhtaca ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pus ju acsnich ju Pilato alacjuni: ―Para tajuch ni jantu tu'u' talak'alhin ju xanavi. Para va apalai talhilact'asalh. Ixtanajun: ―Alhinauch ixmaquilhtaca ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pus ju Pilato lakts'ilh ni jantu lai tu'u' xanavi. Alai va palai ixtalhilact'asai. Pus lhinaulh ix'ica ju xcan. Chai tsuculh makch'ak'ana' la'ix'ucxlacapu'an ju lapanacni. Chai alacjuni: ―Ju quit'in jantu actimaktanu la'ixmaknica ju ani lapanac ju vasalh soknic'a junita. Ni alhinona'it'it ixmaknica pus mincuenta'an ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pus chux ju lapanacni tanaulh: ―K'oxich. Ju quijnan chai ju qui'ask'at'an acc'uc'ayau ju talak'alhin ixlacata ju ixmaknica. ");
INSERT INTO teeNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pus ju acsnich ju Pilato lhinaulh ixmaxtuca ju Barrabás. Astan lhinaulh ixk'ainekmaca ju Jesús. Chai mak'axtaknilh ju taropajni ni catamaquilhta lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pus ju acsnich ju ixtaropajni ju gobernador talhi'alh ju Jesús junta lakachak'axnucanta lacapu'ucxtin. Chai amak'aixtokk'o chux ju ali'in ixt'ataropajni. ");
INSERT INTO teeNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Chai tamalakaxtuni ju Jesús. Tamalakch'inilh slapulh pumpu' tachi ju ixtamalakch'inin ju lack'ai ucxtinin. ");
INSERT INTO teeNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chai tanavilh lakatam corona si alhtucunu' chai tamaktanulh. Vachu' mach'apacalh ju snivenk'e q'uiu la'ixlhicana ni catasu tachi tam xak'ai. Chai ju acsni tata'aktsokotani. Para va ixtalhits'i'in. Ixtajunich: ―Ats'uc'uk'alhit'i ji xa'ucxtin ju israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Vachu' talakachujva. Chai tatai'inilh ju snivenk'e q'uiu chai tatsuculh pulakpaneknin. ");
INSERT INTO teeNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Astan acsni talhits'i'ink'o pus tamaxtunichokolh ju slapulh pumpu'. Chai tamalakch'inichokolh ju akts'iya ixpumpu'. Chai talhi'alh. Ta'alh maquilhtanin lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Chai acsni ixtat'ajun taxtunin ju lak'achak'an pus tapakxtoklh pumatam lapanac amachaka' Cirene. Ju yuchi Simón ixjuncan. Pus ju taropajni tap'astu tamakxk'ok'alh ju yuchi ju iscurus ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Chai tacha'alh junta Gólgota juncan. Pus ju chunch va nomputun ni chunch istasui tachi lakatam aktsulh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Acsni tacha'alh ju anch ixtaxtakniputun ju Jesús ju pinquin ju ixlhiya ju tu'u' ju na sun ni va catalhimatontolanilh ju ixlacatuna. Para ju Jesús acsni quilhc'atsa jantu k'otlh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Chai acsni tamaquilhtak'o ju Jesús pus ju taropajni talhilaslajlh ju ixpumpu' ju Jesús ni laich catac'atsa tamalhch ju calhi'alh k'antam k'antam. Chai acsni chunch ju talalh pus pu'uctaxtulh tuchi ixnajunta ju mak'aniya ixlapanac Dios. Pus ju yuchi ma chani naulh: “Catalhilaslaja' ju quimpumpu' ni catasuya' tichi chavaich ju catalhi'ana'”. Chunch ju naulh ju mak'aniya ixlapanac Dios. ");
INSERT INTO teeNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Chai astan tatavi ju anch ju taropajni ni laich catalhist'ac'a'. ");
INSERT INTO teeNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Pus ju la'is'aktsulh ju iscurus ju Jesús ta'ulanilh lakatam ats'oknut junta ixnajun tuchi talak'alhin ixtamuc'anita. Pus chani ixnajun: “Ju ani yuchi ju Jesús. Ix'ucxtin'an ju israelitanin”. ");
INSERT INTO teeNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Vachu' at'amaquilhtacalh ixt'iyun'an ak'alhonin. Ju pumatam maquilhtacalh la'iscurus la'ixlhicana iscurus ju Jesús. Ju apumatam la'ixlhimacx. ");
INSERT INTO teeNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Chai tachi chun ju ixtatapasai ixtajuni macxcai chivinti. Chai ixtamamaxani. ");
INSERT INTO teeNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ixtajuni: ―Uxint'i ju lai makt'ai ju pujitat chai va ixlhilakat'utu avilhchan yoch'ok'oi. Amak'alht'axt'uc'ach mi'akstu. Pus ni vasalh ists'alh'at Dios pus at'ak'alht'a'ut'ich ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chai vana va chun ixtalhits'i'in ju xalack'ajin palijni chai ju papaninch chai ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Ixtanajun: ");
INSERT INTO teeNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","―Ju yuchi ix'amak'alhtaxtui ju ali'in para jantu lai mak'alhtaxtuchokocan is'akstu. Ni vasalh ix'ucxtin ju israelitanin junita pus chach tak'alhtaju lacacurus chai acsnich ju aclhilaca'anauch ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ju yuchi lhilaksi ju Dios. Pus ni vasalh tu'u' lhiulai pus chach mak'alhtaxtulh ju chavai. Ju yuchi ni naulh ni ists'alh Dios junita. ");
INSERT INTO teeNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chai mas yu'unch ju ak'alhonin ju ix'at'amaquilhtacanta vachu' macxcai chivinti tajunilh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Pus acsni k'atunculh pus lana ts'islh tachi ixlhilacaputs'un ju lacamunutpa'. Tus lakat'utu hora atok'oxana' na ists'ista. ");
INSERT INTO teeNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chai tachi ju lakat'utu hora atok'oxana' pus ju Jesús ts'au t'asalh. Naulh: ―Elí, Elí, lama sabactani. Ju chunch va nomputun: QuiDios tajuch ni va xaq'uimac'a'un. ");
INSERT INTO teeNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Pus ju ali'in ju anch ixtayanalh acsni tak'asmatlh tuchi ixnajun ju Jesús talaclajuni: ―Elías ju t'asani. Yuchi ju ixlapanac Dios ixjunita ju mak'anchich. ");
INSERT INTO teeNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Pus lana ats'ala'alh pumatam sia lhiyu'unch ju taropajni. Ch'apalh ju tu'u' p'uch'ulh tachi panimac. Chai malaktanunilh ju suniya pinquin. Muc'anilh ix'acatan q'uiu. Chai lhi'anilh ju la'ixquilhni ju Jesús. Va ixmavaputun. ");
INSERT INTO teeNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Para ju ali'in tajuni: ―Amac'auch. Calakts'inauch ni vasalh camilh ju Elías p'uxnu'. ");
INSERT INTO teeNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pus ju Jesús aktam ts'au t'asachokopa chai lana nilh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Pus ju acsni pants'iquis ju xapumpu' lacpujitat lana pumakat'ui va. Yuchi ju pumpu' ju ixpulhvakpitsicanta ju ixlhipulact'ui junta ixlhi'anican ju Dios ju ac'alhni paktamin tamin c'ata. Pus tak'excha tus talaclhman tus lacat'un. Chai vachu' tataclh ju lacat'un. Chai ju ali' k'ai chiux tap'akxlh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Chai tap'akxlh ju ali' panteonin. Chai na lhu ju ixtalhilaca'anta ju Dios acsni ixtat'ajunca' pus talok'onchokolh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Pus tataxtulh junta ixta'acnunun. Chai astan acsni lok'onchokolh ju Jesús pus tatanulh ju lak'achak'an Jerusalén. Chai ju anch na lhu ju atalac'asunilh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Pus ju xacapitán taropajni chai ju ali'in ixt'ataropajni ju ixtat'ajun lhistacnin ju Jesús acsni talakts'ilh ni tataclh ju lacat'un chai ju ali' taxtokni ju tapasalh pus na tatalhanalh chai talaclajuni: ―Ju ani lapanac islivasalh ists'alh Dios ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Vachu' na lhu ixtayanalh ju chakolun. Va ixtalakts'in ju Jesús ixlhimakat. Ju yu'unch akts'iya ixtat'a'ucxunt'ajun ju Jesús acsni ixvilhcha ju xa'estado Galilea chai tat'amilh acsni milh ju yuchi ju Jerusalén. Chai ju yu'unch ixta'aktaijui ju Jesús lacatumin. ");
INSERT INTO teeNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ju ali'in sia yu'unch yuchi ju Malia amachaka' Magdala. Chai ju Malia ixnati'an ju Jacobo chai ju José. Chai ixnati ju ists'alan ju Zebedeo. ");
INSERT INTO teeNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Acsni tok'oxalh pus milh pumatam mak'ali' amachaka' Arimatea. Ju yuchi José ixjuncan. Chai vachu' ixlhilaksi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pus ju yuchi lak'alh ju Pilato chai sq'uinilh ixlacatuna ju lijunto Jesús. Chai ju Pilato lhinaulh ixtaknica. ");
INSERT INTO teeNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Chai ju José lhi'alh ixlacatuna ju lijunto. Pach'i lacasnak'ank'a pumpu'. ");
INSERT INTO teeNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Chai quimacnulh junta ixlhucucunicanta lactalhpa junta jantuca' tavanan xamati' ixta'acnui. Astan lhimalacchonilh k'ai chiux ju laxamalhtich junta tamacnu. Chai lana anchokolh ju José. ");
INSERT INTO teeNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Vachu' taquilalh anch ju Malia amachaka' Magdala chai ju ak'antam Malia. Tatavilh pants'iquis vanin junta macnucalh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ni viernes ixjunita pus ju lapanacni ixtalak'oxik'ota ju ixvaiti'an ixlacata ju k'ai c'atan. Chunch ixtalai ni jantu lai catitach'alhcatnalh ni catuncuna'. Pus ni tuncunchokolh mas na k'ai c'atan ixjunita para tatak'aixtokli ju xalack'ajin palijni chai ju fariseonin. Talak'alh ju Pilato. ");
INSERT INTO teeNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Chai tajuni: ―Ji qui'ucxtin icpastacvi ni ixnajun ju anu' a'okxchok'onu' acsni ixt'ajunca' ni ixlhilakat'utu avilhchan ma calok'onchokoya'. ");
INSERT INTO teeNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Pus lamapainin alhinauch ixlhist'ac'a tachi lakat'utu avilhchan junta acnui. Jantu xcai ni va catamilh ts'is ju ix'amamaka'ui chai catak'alhaulh ju ixlacatuna chai catajunilh ju lapanacni ni lok'onchokolh la'ix'aninti ju ix'amamaka'unu'an. Chai ni chunch ju catalalh pus palai cata'okxchok'olh ju lapanacni. Palai jantu na chun tachi acsni ixt'ajunca' ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Chai ju Pilato alacjuni: ―Alhip'inchit'it ju taropajni. K'oxich alak'oxit'it junta acnuich tachi ju anic'ach lai catilalh ni jantu lai cataxtulh. ");
INSERT INTO teeNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pus ta'alh ju yu'unch. Chai talak'oxilh junta acnuich ju Jesús. Tach'ilh ju chiux ju xamalhtich ixnavicanta chai tat'alamlakxtoklh ju talhpa. Vachu' ta'ula ju taropajni ju catalhistaclich ju malhtich. ");
INSERT INTO teeNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Pus acsni tapasalh ju anu' avilhchan pa'astacni chai ixt'ajun tuncuntilana' ju lhitumincu pus ju Malia amachaka' Magdala chai ju k'antam Malia ta'alh lakts'inin junta ixmacnucanta ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pus na p'as tataclh ju lacat'un. Chai ix'anquilh ju Dios mincha lact'iyan chai mak'osulh ju chiux ju xamalhtich ixjunita junta ix'acnui ju Jesús. Chai ucxtavilh ju chiux. ");
INSERT INTO teeNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pus chunch istasui tachi ju tu'u' mak'alipni'. Chai ju ixpumpu' slivasalh xnapapa ixjunita tachi ju tu'u' miqui. ");
INSERT INTO teeNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Chai ju taropajni acsni talakts'ilh slivasalh na tatalhanalh tus ta'axq'uip'ip'itnik'o. Chai lana tatatist'alh tachi ju va tanilh. ");
INSERT INTO teeNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pus ju acsnich ju anquilh axak'ala ju chakolun chai alacjuni: ―Jantu at'alhanant'it ju uxijnan. Icc'atsai ni Jesús ju p'uxc'oyat'it ju maquilhtacalh lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Para jantu ani vi. Lok'onchokotach tachi ju ixnajun. At'at'it. Alakts'int'it junta ixmacnucanta ju ixlacatuna. ");
INSERT INTO teeNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Chai ju chavai ni c'ats'ayat'it ni vasalh lok'onchokota pus vats'alhti a'inchit'it ajuninin ju ix'amamaka'ui ni lok'onchokotach ju yuchi mas ixnita. Vachu' a'una'it'it ni p'ulhnan ca'ananta ju xa'estado Galilea ju Jesús. Anchach ju catapacxantachan tus ach'ip'ina'it'it vachu'. Anchach ju alakts'int'achit'it. Yuchach ju iclajunau. ");
INSERT INTO teeNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Pus ju acsnich ju anu' chakolun tatasp'itchokocha junta ixmacnucanta ju Jesús. Na ixtatalhananta ni ixtalakts'inta ju anquilhnin. Para na ixtak'achanch ni tac'atsa ni lok'onchokotach ju Jesús. Pus ta'ats'ala'alh ajuninin ix'amamaka'ui ju Jesús ni lok'onchokota ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Para acsni ixta'antaca' ju lacati pus ju Jesús alacpakxtoklh. Amac'ami. Pus ju yu'unch lana talak'alh chai tach'anlakatanu. Talak'aya. ");
INSERT INTO teeNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Chai ju Jesús alacjuni: ―Jantu at'alhanant'it. A'inchit'it ajuninin ju qui'alak'avin ni chach ta'ancha ju xa'estado Galilea chai anchach ju aquintalakts'inanta. ");
INSERT INTO teeNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Chai acsni ixta'anchokota ju lak'achak'an ju chakolun pus ju ali'in sia yu'unch ju taropajni ju ixtalhistacni junta ix'acnui ju Jesús ta'alh vachu' ju lak'achak'an. Lana taquimac'atsani ju xalack'ajin palijni tachi chun ju taxtokni ju ixtalakts'inta. ");
INSERT INTO teeNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Pus ju yu'unch lana tamak'aixtokli chux ju xapapanin israelitanin. Chai yu'unchach ju tat'atak'oxilh ju chivinti ju taropajni. Chai na laklhu ju axtaknicalh ju taropajni. ");
INSERT INTO teeNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Chai chani ajunicalh: ―Ana'unt'it ni va taquilalh ju ts'is ju ix'amamaka'ui ju Jesús chai taquik'alhaulh ju ixlacatuna acsni na ilht'at'ayat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Chai ni va catamuc'aniputunan ju mintalak'alhin'an ju gobernador ni va ilht'at'ayat'it pus ju quijnan act'achivinau ju yuchi chai jantu tu'u' catanaviyan. ");
INSERT INTO teeNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Pus ju taropajni ta'amaklhtayanalh ju tumin chai chunch ju tajunilh ju lapanacni tachi ju ix'alhimap'aksicanta. Chai tus chavai ju israelitanin tanajun ni vasalh chunch ju tapasalh. ");
INSERT INTO teeNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Pus ju ixpumacautam'an ix'amamaka'ui ju Jesús ta'alh ju xa'estado Galilea. Ta'alh ju anu' akstijun junta ix'alhimap'aksita ju Jesús ni catacha'alh. ");
INSERT INTO teeNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chai anchach ju atalac'asunilh ju Jesús. Chai ju yu'unch acsni talakts'ilh talak'aya. Para ju ali'in jantu lai ixtalaca'i ni vasalh yuchi cava. ");
INSERT INTO teeNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pus ju acsnich ju Jesús alakmilh chai axak'ala. Alacjuni: ―Iclhinajun ju quit'in ju lact'iyan chai ju ani lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pus yuchi iclalhijunau ni ap'it'it ajuninin tachi chun ju lapanacni ixlhilacaputs'un ju lacamunutpa' ju chivinti ju quilacata. Chach vachu' quintach'ak'ok'alh ju yu'unch. Chai amakp'axaya'it'it la'ixtapaka'ut ju quimpai chai laquintapaka'ut ju ists'alh icjunita chai la'ixtapaka'ut ju Spiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chai amasuniya'it'it ni catamuctaxtuya' tachi chun ju chivinti ju iclajuntau ju uxijnan. Chai ju quit'in iclat'avilau ju uxijnan chux avilhchan tus la'ix'aclanti ju lacamunutpa'. Slivasalh chun tachi ju iclajunau.");
INSERT INTO teeNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Chani ju xatai'ulai ju amalaninti ixlacata ju Jesucristo ists'alh Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Pus ju Isaías ju anu' mak'aniya lapanac ju ixnajun ixchivinti Dios chani ju ts'oklh ixlacata ju Jesús: Ju Dios ma najun ni acsni tuca' min ju yuchi ju ani lacamunutpa' pus is'akstu ju Dios ma camalakachatachilh ju ixlapanac. Chai ju yuchi ma ca'alacjunach ju lapanacni ni catalak'oxilh ju ix'atalacpast'ac'at'an ni camina' ju ix'ucxtin'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Chai ju anu' ixlapanac ma p'as cachivina' ju makat lacamacni. Ma ca'alacjuna' ju lapanacni ni catalak'oxilh ju ix'atalacpast'ac'at'an ni camina' ju ix'ucxtin'an. Ma chach salaka va ju ix'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pus yuchi lhimilh ju Xivan. Yuchi ju anu' ixlapanac Dios ju lhichivinilh ju Isaías. Chai ju yuchi ix'amakpaxanan ju lacamacni chai ix'alacjuni ju lapanacni: ―Amac'a'unt'it ju mi'alactu'unti'an chai a'akp'axt'it. Ju chunch catamac'acxaniyan ju mi'alactu'unti'an ju Dios. ―Chunch ix'ajuni ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pus ju amachak'an ju xa'estado Judea chai ju amachak'an ju lak'achak'an Jerusalén ixtalak'an ju Xivan ni ixtak'asmatniputun ju ixchivinti. Chai ju Xivan amakpaxak'o ju anuch k'ai xcan Jordán acsni ixtanajun ni catamacona' ju ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ju ixpumpu' ju Xivan ispaksiucanta ix'apamat camello. Chai lakatam tak'aixt'ak'an ixtank'aijucalh. Chai ix'ui ju tu'u' tachi ju silek chai ju xat'axcat lacaq'uivin. ");
INSERT INTO teeNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ju yuchi chani ix'alacjuni ju lapanacni: ―Mintacha astan ju palai xak'ai. Palai jantu ju quit'in. Ju quit'in jantu tu'u' ju quintapalhni. Jantu laich actich'anxk'otlh nin mas va yuchi ju samusni ixch'anxt'ak'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Pus ju quit'in lacaxcan ju iclamakpaxau. Para ju yuchi cataxtakniyan ju Spiritu Santu ju catsucuyach lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pus ju acsnich ju Jesús mincha lak'achak'an Nazaret laxa'estado Galilea chai ju Xivan vachu' makpaxa ju yuchi lacak'ai xcan Jordán. ");
INSERT INTO teeNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Chai ju Jesús acsni tacutlh ju lacxcan lana lakts'ilh ju lact'iyan ni talhtek'a. Chai lakts'ilh ni milh ju Spiritu Santu tachi ju tu'u' lak'axk'avan. Chai lakmilh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Chai lana chivincancha ju lact'iyan chai k'asmatcalh ju lacat'un junta ixya ju Jesús. Chai chani junicalh ju Jesús: ―Ju uxint'i quints'alh'at. Slivasalh na icmapainiyan. Na iclhik'achananch. ");
INSERT INTO teeNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Pus ju Spiritu Santu lana k'ai lhi'alh ju Jesús lacamacni. ");
INSERT INTO teeNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","T'up'uxam avilhchan tolhcha lacamacni ju Jesús. Chai ju anch na ix'alin ju maktilin. Chai ju lhacaticuru navilh ju talacmask'atinti ni ts'a ma laich ca'ixmalactu'uni ju Jesús. Chai ju astan ju anquilhnin talhiminilh ju ixvaiti ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Acsni t'alhnucalh ju Xivan pus astan ju Jesús alh ju xa'estado Galilea. Ix'alacjuni ju lapanacni ni lhinomputun ju Dios la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Chani ix'alacjuni: ―Vaninch minta ju avilhchan acsni calhinona' ju Dios. Tamch alacp'ast'act'it lami'alhunut'an chai alac'a'it'it ju chivinti junta najun ta yu laich ap'ut'ak'alht'axt'uya'it'it. ―Chunch ix'alacjuni. ");
INSERT INTO teeNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Chai ju Jesús ix'alhtanan la'ixquilhtu' ju xa'atants'in Galilea acsni alakts'ilh ju Simón ju vachu' ixjuncan Pitalu' chai isp'isek'e ju Tilix ixjuncan. Va ixtat'ajun munin ixch'okxni'an laca'atants'in ni ixch'apanin pamata ixtajunita. ");
INSERT INTO teeNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Chai ju Jesús alacjuni: ―Aquilach'ak'ok'auch. Chai tachi ju ixmak'aixt'ok'at'it ju pamata pus vana va chun aclaxtakniyau ju lhich'alhcat ni amak'aixt'ok'a'it'it ju lapanacni ju aquintalhilaca'ana'. ―Chunch ju alacjuni. ");
INSERT INTO teeNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pus lana tamacaulh ixch'okxni'an chai tach'ak'ok'alh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Chai ni alhtanampa alacats'unin ju Jesús pus alakts'ilh ju Jacobo chai isp'isek'e ju Xivan ixjuncan. Ists'alan ju Zebedeo. Ju yu'unch ixtatajumanalh la'ixbarco'an. Va ixtat'ajun lacyonin ixch'okxni'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pus lana alact'asanilh ju Jesús. Chai ju yu'unch tamacaulh ju ixpai'an ju Zebedeo ixjuncan. Tat'amacaulh ju ixlapanacni ju lacabarco. Chai ju Jacobo chai ju Xivan tach'ak'ok'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Astan ju Jesús chai ju ixlapanacni tatanucha ju lak'achak'an Capernaum. Chai cha'alh ju avilhchan pa'astacni acsni lhik'alhts'aulh ju lhamap'aksin ni catach'alhcatnalh ju lapanacni. Pus ju acsnich ju Jesús alh la'ixpujitat'an ju ist'a'israelitanin. Alh amamaka'unu'. ");
INSERT INTO teeNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Pus ju lapanacni ju ixtavilanalh va talhamak'aninilh ta yu xa'amalaninin ni ix'alacmap'aksinin tachi tam xak'ai. Jantu chun tachi ju ixta'amalaninin ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pus ju anu' la'ixpujitat'an ix'alin pumatam lapanac ju ixtanun ju lhacaticuru la'ixlacatuna. Pus ju anu' lapanac lana ts'au t'asalh acsni lakts'ilh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Chai ju lhacaticuru puchivinilh ixquilhni ju lapanac acsni chani naulh: ―Tijuch ju quilamintau lhilakts'inin ji Jesús amachaka' Nazaret. Ja va quilamintauch maca'anin lacajipi. Icc'atsai tichi chavaich'at. Ju uxint'i salaka ists'alh Dios'at chai yuchi ju malakachachan ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pus ju Jesús k'ailh ju lhacaticuru. Junich: ―Va sekch ju uxint'i. At'axt'uch ju la'ixlacatuna ju lapanac. ―Chunch ju juni. ");
INSERT INTO teeNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Chai ju anu' lhacaticuru lana tin lhineklh ju lapanac. Lhtucu lhtucu ucxuntama. Ts'au t'asalh chai taxtulh lana. ");
INSERT INTO teeNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pus tachi chun ju lapanacni va talhamak'aninilh chai talasacmilh sia yu'unch. Talaclajunich: ―Tijuch nu' ju ani. Tis sast'i atalaninti nu' ju ani. Ju ani ya lapanac alin ixtachaput ni lai lhijuni ju lhacaticurulhni chai taquiclaca'i. ―Chunch ju talaclajuni. ");
INSERT INTO teeNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pus lana c'atsak'ocalh ixlacata ju Jesús tachi chun ju lak'achak'anixni ju alin ju xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Pus ju Jesús chai ju ix'amamaka'ui tataxtucha ju la'ixpujitat'an ju ist'a'israelitanin. Tacha'alh la'ixchaka'an ju Simón chai Tilix. Ixta'ank'ota vachu' ju Tiyacu chai ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pus ixput'ichako'ulh ju Simón ixma la'ixputaman. Na ixch'apata ju iscacat. Pus lana tajunilh ju Jesús ni na ixtak'ank'ai. ");
INSERT INTO teeNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Pus ju Jesús lana lak'alh junta ixma ju tak'ank'an. Ch'apanilh ju ixmaca' chai mak'ostola. Lana macaulh ju iscacat chai lana taya chai tsuculh alacmavana' ju Jesús chai ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Chai acsni tok'oxalhch lacats'unin acsni ancha ju avilhchan pus tachi chun ju tak'ank'anin alhimincalh junta ixvi ju Jesús. Vachu' alhiminicalh tachi chun ju ixtanun ju lhacaticuru la'ixlacatuna'an. ");
INSERT INTO teeNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pus tachi chun ju lapanacni tatak'aixtoktayak'o laxamalhtich ju ixchaka' ju Simón. ");
INSERT INTO teeNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Chai ju Jesús na lhu palaich anavi ju tak'ank'anin mas na tijlhu tak'ank'at ixtapacxanta. Vachu' ak'ailh ju lhacaticurulhni. Ajunilh ni catataxtulh la'ixlacatuna'an lhu ju lapanacni. Chai tataxtulh. Para ju Jesús jantu xa'alacasq'uini ni catachivinilh ju lhacaticurulhni va ixlacata ni istamispai ju Jesús. Chai ju yuchi va jantu ixlacasq'uin ni catajunilh ju lapanacni tichi chavaich ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Na vats'isin k'ostavi ju Jesús. Ists'istaca' acsni taxtulh va is'akstu. Alh ju lacamacni. Anch ju t'achivincha ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Pus ni tunculh ju Simón chaich ju ali'in ta'alh puxconin. ");
INSERT INTO teeNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Chai acsni talhitajucha ju Jesús tajuni: ―Chux ju lapanacni tapuxcoyan. ");
INSERT INTO teeNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Para ju Jesús alacjuni: ―Ca'auch ju lak'achak'anixni ju vanin vi ni laich camasunitachau vachu' ixchivinti Dios ni yuchi ju iclhiminta ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pus ju Jesús ixlac'aktanut'ajun ixlhilakapok'ai ju xa'estado Galilea. Ix'amalaninin la'ixlacpujitat'an ju xalapanacni anch. Chai ix'alacxcoxtuni ju lhacaticurulhni la'ixlacatuna'an lhu ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Pus pumatam lapanac ixpacxanta ju macxcai ts'its'i ju ixpuch'i'an. Chai ju yuchi lakmilh ju Jesús. Ta'aktsokotanilh. Juni: ―Ni va xaq'uinc'uch'up'ut'uch cava pus laich xaq'uinc'uch'ut'i. ");
INSERT INTO teeNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Pus ju Jesús na mapainilh ju tak'ank'an. Lana mokslanilh ixmaca' la'ixlacatuna ju tak'ank'an chai junilh: ―Iclacasq'uinch. Palaich'at ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Chai acsni naulh ju chunch ju Jesús pus lana vats'alhti lacmacaxnilh ju ists'its'i ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Chai ju Jesús na map'aksi chai malakachalhch la'ixlacpujitat'an ju ist'a'israelitanin. Junich: ");
INSERT INTO teeNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Ak'asmat'ich ju icjunan. Tun xamati' t'i'un tu'u'. Inchich talacasunini' ju pali. Chai axt'akchich ju milhak'ailakts'in tachi ju najunta ju Moisés lacalhamap'aksin. Ju chunch catac'atsayach ju lapanacni ni salaka ju milacatuna. ―Chunch ju junicalh ju tak'ank'an ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Para ju anu' tak'ank'an ixjunita acsni taxtucha ju la'ix'ucxlacapu' ju Jesús lana lacquilhuntsuculh tuchi ixtapasata. Chai ni xatac'atsak'ojui ju lapanacni pus ju Jesús jantu lai ixtanui ju tu'u' lak'achak'an va la'ix'ucxlacapu'an ju lapanacni. Va lacamacni ixtolacha. Chai ju anch na lhu lapanacni ixtalakcha'an ju vaklhun ixtamintacha. ");
INSERT INTO teeNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Astan acsni tapasalh lakatam lakat'ui avilhchan pus ju Jesús anchokopa ju lak'achak'an Capernaum. Chai tac'atsapa ju lapanacni ni anch vilhchokochalhch ju Jesús la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Pus lana talhitak'aixtokpa ju lapanacni ju la'ixchaka' ju Jesús. Chai ni na va ilhu'an ixtajunita pus jantuch lai ixtalhijun ju lacachaka'. Pus ixcha'antach ju lapanacni lacamalhtich acsni ix'alacmasuni ju ixchivinti Dios ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Pus lhimincancha pumatam tak'ank'an ju va ixlacalhtuculunta. Ixlhipumat'at'i'an lapanacni tach'ixlhicha'alh ju lacachaka' junta ixvi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Para jantu jinta' talhitaju junta laich catapumanu lacachaka' junta ixvi ju Jesús ni na is'aktsamcanta. Pus tatoc'alh la'ix'ucxni chaka' chai ta'ucxmak'alh junta ixlhivi ju Jesús. Chai anch ju tapumak'alhtaju lacalona ju anu' tak'ank'an. ");
INSERT INTO teeNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Chai ju Jesús ni c'atsa ni na ixtalhilaca'anta ju yuchi ju anuch ixpumat'at'i'an lapanacni pus junich ju tak'ank'an: ―Quints'alh mac'acxanik'ocantach ju mintalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Pus ixtavilanalh vachu' ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Chai ju yu'unch chani istapastacta la'ix'alhunut'an: ");
INSERT INTO teeNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tas ni va ta chivimpalai ju ani ya lapanac. Na macxcai chivinti ju najun ni tachi ju va Dios ju jumputun. Jantu xamati' lai mac'acxai ju talak'alhin. Va yuchi ju Dios”. ");
INSERT INTO teeNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Para ju Jesús lana c'atsa tuchi istapast'ac'a ju anuch lapanacni. Chai alacjuni: ―Tajuch ni va chunch ju p'ast'ac'at'it lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ni acjunilh ni mac'acxanicalh ju ix'alactu'unti pus jantu lai ap'uc'ats'aya'it'it ni vasalh alin ju quintachaput u jantu. Para ni acjunilh ni cak'ostavi chai ca'alhtanalh pus ju chunch lai ap'uc'ats'aya'it'it ni alin ju quintachaput. ");
INSERT INTO teeNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Pus alakts'int'it ju ani ju acnaviya' chai laich ap'uc'ats'aya'it'it ni alinch ju quintachaput ju ani lacamunutpa' ni lai icmac'acxani ju talak'alhin. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Chai ju acsnich ju Jesús junich ju tak'ank'an: ");
INSERT INTO teeNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","―Uxint'i ju icjunan. Ak'ost'a'ulh. Asact'ich ju mimputaman. A'inchich ju laminchaka'. ");
INSERT INTO teeNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Pus ju anu' tak'ank'an ixjunita taya. Saclh ju ixputaman. Chai taxtulh la'ix'alac'avanti'an chux ju lapanacni. Chai ju yu'unch na talhamak'aninilh. Talak'aya ju Dios. Chai talaclajuni: ―Jantu tavanan lakts'intau tu'u' ju chunch. ");
INSERT INTO teeNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Pus aktam taxtuchokopa ju Jesús. Alh la'ixquilhtu' ju atants'in. Pus chux ju lapanacni talakcha'ank'ochokopa chai ju yuchi ix'alacmalani. ");
INSERT INTO teeNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Chai acsni tavanan anchokolh ju Jesús ju lak'achak'an pus lakts'ilh pumatam ach'ini' ju Leví ixjuncan. Ists'alh ju Alfeo. Ju yuchi ixvi junta amapalanancan. Chai ju Jesús juni: ―Aq'uinch'ak'ok'ach. Pus lana taya ju Leví. Ch'ak'ok'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pus ju aktam ju Jesús ixt'ajun vena' la'ixchaka' ju Leví. Chai vachu' na lhu tacha'alh ju ach'inin chai vachu' ju ali'in alactu'unu lapanacni. Chai va k'aixtam tat'atavi ju Jesús chai ju ix'alacmamaka'uich lacamixa ni na lhu ixtach'ak'ok'ai ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Pus ju na ixtalhatalaninintach ju ixlhamap'aksin ju ist'a'israelitanin chaich ju ixtalhilaca'an ju ixlhamap'aksin'an ju fariseonin talakts'ilh ju Jesús ni ix'alact'avajin ju ta'ach'inin chai ju alactu'unin. Pus ju yu'unch tajunilh ju ix'alacmamaka'ui ju Jesús: ―Ju mi'amamaka'unu'an tajuch ni va k'aixtam alact'avajin ju ach'inin chai ju alactu'unin. ");
INSERT INTO teeNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Pus ju Jesús acsni k'asmatlh ju tuchi ixtanajun chani alacjuni: ―Ju k'ox tat'ajun jantu tamaktasq'uini ju ac'uch'unu'. Va yu'unch ju talactak'ank'ai ju tamaktasq'uini ju ac'uch'unu'. Pus ju quit'in jantiyu' iclhiminta ni ac'alact'asanilh ju laquimacni ju tanajun ni na soknic'a ju is'atsucunti'an. Alai icminta alact'asanini' ju alactu'unin. ");
INSERT INTO teeNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Pus ju ix'alacmamaka'ui ju Xivan chai ju fariseonin jantu ixtavajin ju anu' avilhchan ni chunch ju ixtalhilanita. Pus ju acsnich ju ali'in lapanacni talakmilh ju Jesús chai tajuni: ―Tajuch ni va tatascajai ju ix'alacmamaka'ui ju Xivan chai ix'alacmamaka'ui ju fariseonin. Para ju mintamamaka'un ju uxint'i jantu tatascajai. ");
INSERT INTO teeNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Pus ju Jesús alack'alhtailh. Alacjuni: ―Tachi chun ju tamak'ach'ak'ok'anan junta alin ju tamak'axt'ok'at ja lai jantu catavailh ni alinch ju k'achat ni vilhca' ju anu' ts'alh ju catamak'axt'ok'a'. Acsni vilhca' ju anu' ts'alh ju catamak'axt'ok'a' pus jantu lai tatascajai ju ix'amigojni. ");
INSERT INTO teeNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pus vana va chun ju quintamamaka'un. Jantu tatascajai ju chavai ni ic'alact'avi. Para cachina' avilhchan acsni acmak'osucana' ju ani lacamunutpa'. Chai acsnich ju catatascajaya' ni na aquintalhamak'anininach. ");
INSERT INTO teeNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jantu xamati' lai lhalakyavanan ju pumpu' ju jantu amakpanti chai lai va chunch camuc'alh ju lacak'at'ili pumpu'. Pus ni chunch ju calalh pus va palai makat cak'exlh acsni talakatumi ju sast'i pumpu'. ");
INSERT INTO teeNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Nin yuchi ni lai acpumuju ju sast'i vino lacak'at'ili axt'ak'an ni na k'alhp'asnica'. Ni chunch ju acnavi pus va cak'exlh ju axt'ak'an chai capu'ank'o ju vino chai ju axt'ak'an cats'ank'alh. Alai pumucan ju sast'i vino lacasast'i axt'ak'an. Chunch ju ajuni ju Jesús ju lapanacni ni va ix'amamachakxaniputun ni jantu lai catilhiyaulh ju mak'aniya ixlhamap'aksin ju Moisés ju ixlhamap'aksin ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Lakatam avilhchan pa'astacni ju Jesús tapasalh junta ixch'ancanta ju trigo. Chai ix'alacmamaka'ui ixtap'uxlhi'anta ju trigo chai ixta'uich. ");
INSERT INTO teeNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pus ju acsnich ju fariseonin tajunich ju Jesús: ―Alakts'ich. Tajuch ni va chunch tanavi ju mi'amamaka'ui ni jantu lai ch'alhcatnancan ju chavai ni avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Para ju Jesús alacjuni: ―Ja lana jantu p'ast'ac'at'it tuchi navilh ju David acsni ix'alin ixmaktasq'uinit chai acsni chavanilh ju yuchi chai ju ixtat'a'anta. ");
INSERT INTO teeNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ja lana jantu p'ast'ac'at'it ni tanulh ju yuchi junta ixlak'ayacan ju Dios acsni xak'ai pali ixjunita ju Abiatar. Chai ulh ju xkapavati ju ismokslanicanta ju Dios. Pus ju anu' xkapavati jantu lai va k'aya ix'ucan. Va yu'unch ju palijnin ju lai ixta'ui. Para ju David ni upa chai vachu' alacxtaknipa ju ix'alact'a'anta. ");
INSERT INTO teeNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ju Jesús vachu' alacjuni: ―Ju Dios lhca'ula ju avilhchan pa'astacni ixlacata ju lapanacni. Jantiyu' lhinavilh ju lapanacni ni va catamuctaxtulh ju lhamap'aksin ju navilh ju Dios ixlacata ju anu' avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Pus quit'in ju lai icnajun tuchi lai navican ju avilhchan pa'astacni. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ju Jesús aktam tanuchokopa la'ixpujitat'an ju ist'a'israelitanin. Chai ixtanumacha pumatam lapanac ju va ixixnita lakatam ixmaca'. ");
INSERT INTO teeNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Chai vachu' ix'alin ju anch ju lapanacni ju ixtalhistact'ajun ju Jesús. Va ixtalakts'imputun ni ca'ac'uch'unulh ju avilhchan pa'astacni u jantu. Va ixtapuxconi ta yu laich catapumuc'ani ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pus ju Jesús junilh ju anu' lapanac ju va ixixnita ju ixmaca': ―Ak'ost'a'ulh. At'aich ju ani junta laich catalakts'inan ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Chai alacjunich ju lapanacni: ―T'as nonat'it. Ja lhijun ni acnavi ju k'ox ju avilhchan pa'astacni u acnavi ju talak'alhin ni jantu ac'aktaiju tam xamati'. Ja lhijun ni acmak'alhtaxtulh ju atsucunti ju avilhchan pa'astacni u aclakts'imakni. Pus ju lapanacni va sekch tataya. ");
INSERT INTO teeNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Pus ju acsnich ju Jesús alakts'ilh ju lapanacni ju ixtalakachoko. Talhk'amalh. Chai na amak'aninilh ni na p'as ixjunita ix'alhunut'an. Pus junich ju tak'ank'an: ―Alhit'ach ju mimaca'. Pus ju anu' lapanac xtaknilh ju ixmaca'. Chai lana tachapunch va. ");
INSERT INTO teeNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Pus lana tataxtucha ju fariseonin. Ta'alh junta ixtavilanancha ju ixtach'ak'ok'ai ju gobernador Herodes. Ta'alh mach'anxtaminin ju chivinti ixlacata ju Jesús ta yu laich catapumakniya'. ");
INSERT INTO teeNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Pus ju Jesús alh la'ixquilhtu' atants'in. Alact'a'alh ju ix'alacmamaka'ui. Chai na lhu tach'ak'ok'alh ju amachak'an xa'estado Galilea chai ju amachak'an ju xa'estado Judea. ");
INSERT INTO teeNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Vachu' ju amachak'an lak'achak'an Jerusalén chai ju amachak'an ju xalacat'un Idumea. Chai ju lapanacni ju ixtat'ajun lhimak'antacutni lacxcan Jordán chai ixtalakachoko ju lak'achak'anixni Tiro chai Sidón. Na lhu lapanacni tak'asmatlh ni na k'ai lhamak'an xanavi ju Jesús chai talakmilh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Pus ju Jesús alacjuni ju ix'alacmamaka'ui ni catalakasipuxcaulh lacat'icst'i barco ni laich cataju anch ni na ixtatank'asi ju lapanacni ni na ilhu'an. ");
INSERT INTO teeNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pus ni na lhu ix'ac'uch'ui ju lapanacni ju Jesús pus ju ali'in ju ixtapacxanta ixtak'ank'at'an va k'asi k'asi ixtalak'an ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Chai vachu' ix'alin ju lapanacni ju ixtanun ju lhacaticurulhni la'ixlacatuna'an. Chai ju anu' lhacaticurulhni ixtamispai ju Jesús. Pus ju lapanacni ju ixtapacxanta ju lhacaticurulhni ta'aktsokotanilh la'ix'ucxlacapu' ju Jesús chai ju lhacaticurulhni tapuchivinilh ixquilhni'an ju anuch lapanacni. Na p'as tachivinilh. Tajunich ju Jesús: ―Ju uxint'i ists'alh'at Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Para ju Jesús p'as alhimap'aksi ni jantu catajunilh ju lapanacni tichi lapanac ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Chai ju Jesús ampa junta ixvilhcha lakatam akstijun chai alact'asanilh ju is'asacxtuputun. Chai ju yu'unch talakmilh. ");
INSERT INTO teeNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Pus asacxtulh pumacaut'ui ix'alacmamaka'ui ni laich ca'alact'a'alhtanatsuculh ju yuchi chai ni laich ca'alacmalakachaya' ixnajunca ju ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Vachu' axtaknilh ixtachaput'an ni laich palai catanavi ju lapanacni ju ixtach'apata ixtak'ank'at'an. Chai laich vachu' cataxcoxtuniya' ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Pus sacxtucalh ju Simón. Chai ju yuchi xtaknichokocalh alakatam ixtapaka'ut. Lhimapaka'ucalh Pitalu'. ");
INSERT INTO teeNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Chai sacxtucalh ju Jacobo chai ju Xivan. Pus ju Xivan isp'isek'e ixjunita ju Jacobo. Chai ju yu'unch ists'alan ju Zebedeo ixtajunita. Axtaknilh ixlhilakat'ui ixtapaka'ut'an. Alaclhixak'alacalh Boanerges. Ju chunch va nomputun ni na p'as ixtachivinin tachi acsni t'asai ju t'ajin. ");
INSERT INTO teeNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Chai sacxtucalh ju Tilix chai ju Pilipe chai ju Bartolomé chai ju Mateo chai ju Tumax chai apumatam Jacobo ju ists'alh Alfeo ixjunita. Chai sacxtulh ju Tadeo chai apumatam Simón ju makyu'unch ixjunita ju cananistanin. ");
INSERT INTO teeNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Vachu' sacxtucalh ju Judas Iscariote ju astan mak'axtaklh ju Jesús. Astan ju Jesús alact'a'alh ju ix'amamaka'ui lacachaka'. ");
INSERT INTO teeNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Chai aktam tatak'aixtokpa ju lapanacni. Chai ixlhiyuchi mati' ixjunita ju ispants'iquis'an ju Jesús chai ix'amamaka'ui ni laich catavailh. ");
INSERT INTO teeNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Pus acsni tak'alhak'asmatlh ju ixlhi'alak'avin ju Jesús ni chunch ixlai pus tamilh inin. Va ixtanajun ni jantu is'ac'atsananta ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Vachu' ixta'alin ju lapanacni ju ixtalhatalanininta ju ixlhamap'aksin ju ist'a'israelitanin. Ju yu'unch ixtamintacha ju lak'achak'an Jerusalén. Pus ju yu'unch ixtanajun ni va ixtanun ju Satanás la'ixlacatuna ju Jesús. Chai la'ixtachaput yuchi ju ixtixcoxtui ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Pus ju acsnich ju Jesús alact'asanilh ju anuch lapanacni chai alacjuni ju chivinti ju ix'apumavasalaniputun tu'u'. Chani ju ajuni: ―Ju Satanás jantu lai catixcoxtulh ixt'alhacaticurulhni. ");
INSERT INTO teeNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tachi chun ju k'ai lacat'un junta lhinajun ju tam k'ai ucxtin ni quilhmaclhu cajuncalh chai catalaclasaya' ju sia is'akstu'an pus va ca'aclaya'. ");
INSERT INTO teeNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Chai ju tatanumanalh lacachaka' ni va catalasachokolh ixlhi'akstu'an pus jantu lai vana lakputam catatsuculh. ");
INSERT INTO teeNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Chai vana va chun ju lhacaticuru. Ni ca'atixcoxtulh ju ali'in ixt'alhacaticurulhni pus tulai tailhi'an la'ixpu'ucxtin. Alin ix'aclanti ju ixtachaput. ");
INSERT INTO teeNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ni xamati' catanuputulh la'ixchaka' pumatam jok'at ju na tachapun chai camaxtuniputulh ju ixtaxtokni tasq'uini ni p'ulhnan camakch'imalh ju anu' jok'at. Acsnica' ju lai camaxtunilh ju ixtaxtokni ni va jantu lai tamacyajui. Pus chunch ju ajuni ju lapanacni ju Jesús ni ix'amamachakxaniputun ni yuchi ju t'alalhajalh ju lhacaticuru. Yuchi lai lhixcoxtui ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. Chai tailhi'alh ixchivinti. Ajuni: ");
INSERT INTO teeNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","―Slivasalh ju iclajunau. Tachi chun ju talak'alhin chai va tuchi macxcai chivinti ju tanajun ju lapanacni laich camac'acxanicana'. ");
INSERT INTO teeNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Para va tichi chavaich ju macxcai chivinti calhichivinilh ju Spiritu Santu jantu tavanan lai catimac'acxanicalh ju anu' alactu'unti. Va camuc'anik'alhicana' ju ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ju Jesús chunch ju ajuni ju lapanacni va ixlaca'atalh ni ixtanajunta ni lhacaticuru ju ixpuch'alhcatnan ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Astan tachincha ju is'ap'isek'en ju Jesús chaich ju ixnati. Tataya makspa' chai talhinaulh ist'asanica ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Pus ju lapanacni ju ixtalakavilanalh ixtalakachokoch ju Jesús tajuni: ―Ju minati chai ju mi'ap'isek'en tapuxcoyan makspa'. ");
INSERT INTO teeNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Para ju Jesús alack'alhtailh. Alacjuni: ―Tis chavaich ju quinati chai qui'ap'isek'en. ");
INSERT INTO teeNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Chai acsni naulh ju chunch pus ju Jesús alakts'ilh ju ixtalakavilanalh ixtalakachoko ju yuchi chai naulh: ―Ju anich tavilanalh yu'unch ju quinati chai qui'ap'isek'ench. ");
INSERT INTO teeNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Va tichi chavaich ju canaviniya' ju ixk'achat ju Dios yuchi ju vasalh quimp'isek'e chai vasalh quinati. ");
INSERT INTO teeNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ju Jesús aktam tai'ulachokopa ix'amalaninti la'ixquilhtu' atants'in. Chai ni na lhu tatak'aixtokpa ju lapanacni junta ixvi pus ju Jesús taju lacabarco ju ixvi la'ixquilhtu' atants'in chai tavi ni laich ca'amalanik'olh ixchux'an. Chai tachi chun ju lapanacni lacat'un ixtayanalh la'ixquilhtu' atants'in. ");
INSERT INTO teeNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Chai ju Jesús na lhu taxtokni xa'amalani ju lapanacni lacachivinti ju ixt'alakts'ipaxcavaich ju tu'u'. Chai acsni xa'alacmalani chani alacjuni: ");
INSERT INTO teeNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Ak'asmat'itch ju aclajunau. Pumatam ach'anana' alh lhavana' ju ix'ach'ananti. ");
INSERT INTO teeNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Chai acsni ixt'ajun lhavana' ju ix'ach'ananti pus ju ali' xat'in tama la'ixquilhtu' ti. Chai lana tamilh ju ts'ok'o chai tasac'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Chai ju alacats'unin ju xat'in tamacha junta va lacats'unin ix'alin ju t'un la'ix'ucxni ju chiux. Pus vats'alhti p'unlh ju t'in ni jantu lhu ix'alin ju t'un. ");
INSERT INTO teeNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Para acsni na lhi'ichich va pus lana lacxixlh ni va jantu makat ixtinui istisivic. ");
INSERT INTO teeNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Chai ju alacats'unin ju xat'in tamacha junta vachu' ixma ju xat'in alhtucunu'. Pus p'ulhnan tak'aya ju alhtucunu' chai akxtakma ju anu' ach'ananti chai jantu tu'u' xtaklh ju xatoc'at. ");
INSERT INTO teeNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ju alacats'unin xat'in tamacha lacak'oxi t'un. P'unlh. Tak'aya. Chai toc'alh ju xalhi'ut. Pus talhava ju akatamin ach'ananti. Ju ali' toc'alh lakap'uxamcau ju xalhi'ut. Ju ali' ach'ananti toc'alh sesenta ju xalhi'ut. Ju ali' ach'ananti toc'alh tam cientos ju xalhi'ut. ");
INSERT INTO teeNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ju acsnich ju Jesús alacjuni ju lapanacni: ―Va tichi chavaich ju alin ixpak'asmatni pus cak'asmatlh. ");
INSERT INTO teeNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Astan acsni ta'anchokolh la'ixchaka'an ju ixtalhavat lapanacni pus ju ixpumacaut'ui'an chai ju ali'in ix'alacmamaka'ui ju ixtat'avilanalhca' ju Jesús tatsuculh sacminin tuchi ixnomputun ju chivinti ju xanajun. ");
INSERT INTO teeNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Chai ju Jesús alacjuni: ―Ju uxijnan lac'asq'uinic'ant'at'it ni amach'akxayat'it ju chivinti ju najun ni lhinomputun ju Dios la'is'atsucunti'an ju lapanacni. Para ju ali'in lapanacni ju jantu quintalhilaksiputun va amasunican ixtaxtokni Dios laca tu'u' chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ju chunch ju yu'unch mas va tachi talakts'in tuchi icnavi para jantu catitamispa tuchi nomputun. Chai mas va tachi tat'ajun k'asmatnin ju quinchivinti para jantu tavanan catitamachakxa. Ju chunch jantu lai tam cativa ju is'atsucunti'an. Chai jantu tavanan camac'acxanicana' ju ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Chai ju Jesús chani alacjuni ju ix'amamaka'ui: ―Ni jantu lai mach'akxayat'it ixlacata ju ach'anana' ju ixt'alakts'ipaxcavaich ju tu'u' pus t'as alhimach'akxaya'it'it ju ali' chivinti ju t'alakts'ipaxcavaich tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pus chani ju nomputun. Ju ach'anana' yuchi ju najun ixchivinti Dios. Tachi ju va ch'an ju chivinti la'ix'alhunut'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Chai ju xat'in ju tamacha vanin la'ixquilhtu' ti yu'unch ju tak'asmat'a ixchivinti Dios para astan min ju lhacaticuru chai mac'ap'ani ju chivinti ju ix'ach'ananicanta la'ix'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Chai ju xat'in ju tamacha la'ix'ucxni chiux yu'unch ju tak'asmatlh ixchivinti Dios chai lana lhik'ach talaca'i. ");
INSERT INTO teeNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Para chunch tajunita tachi ju anu' xap'un la'ix'ucxni chiux. Ju yu'unch jantu vasalh la'ixlhichux ix'alhunut'an ju tak'achani. Va pants'iquis k'ox talhiulai. Para acsni min ju tu'u' mak'alhk'ajnat u tu'u' axcayanti va ixlacata ni talaca'inita ju ixchivinti Dios pus lana tamacajun ixti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Chai ju xat'in ju tamacha junta ix'alin ju xat'in alhtucunu' pus yu'unch ju tak'asmat'a ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Para va tachi talhamak'aninin ju xataxtokni ju alin ju ani lacamunutpa'. Chai va taputa'okxchok'oi ju tumin. Chai na lhu taxtokni ju tatamoputun. Pus tachi chun ju ani taxtokni va amac'ap'ani ju ixchivinti Dios ju ix'ach'ananicanta la'ix'alhunut'an. Chai jantu tavanan tasui ixtachaput Dios la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Para ju xat'in ju tamacha lacak'oxi t'un yu'unch ju tak'asmat'a ju ixchivinti Dios chai lana talaca'i. Chai lana tasui ixtachaput ju Dios la'is'atsucunti'an. Ju ali'in va lacats'unin tasui ju ixtachaput ju Dios la'is'atsucunti'an. Ju ali'in lapanacni palai lhu tasui ixtachaput Dios la'is'atsucunti'an. Chai ju ali'in lapanacni na lhu lana tasui ixtachaput Dios la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ju Jesús vachu' alacjuni ju lapanacni: ―Acsni lhimincan ju tu'u' maclhcu ju lacachaka' jantu va akxtak'ulacan laca tu'u' valhtila nin laxtank'apu' acapu' ca'ula. Alai va muc'acan talaclhman junta muc'acan ju maclhcu. ");
INSERT INTO teeNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chai vana va chun ju quinchivinti. Mas va mi'akstu'an xaclamavasalaniyau ju chivinti para astan amac'ats'aniya'it'it ju lapanacni. Chai tuchi chivinti ju jantu amamachakxanican ju ixtalhavat'an lapanacni pus uxijnan ju amac'ats'aniya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Pus ju alin ixpak'asmatni pus cak'asmatlh. ");
INSERT INTO teeNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Vachu' chani alacjuni ju lapanacni: ―Anavit'it cuenta ju tuch'i k'asmat'at'it. Ni anaviya'it'it cuenta ju tuchi iclajunau pus palai lhu catamak'asmatniyan ju Dios. Chai palai lhu amach'akxaya'it'it ju uxijnan ni vasalh anaviya'it'it cuenta ju quinchivinti. ");
INSERT INTO teeNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Pus ju navi cuenta ju tuchi k'asmat'a pus palai lhu camak'asmatnicana'. Para ju jantu tu'u' navi cuenta ju tuchi k'asmat'a pus camac'ap'anicana' ju lacats'unin ju mak'ata la'ix'alhunut. ");
INSERT INTO teeNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ju Jesús vachu' chani alacjuni ju lapanacni: ―Acsni lhinajun ju Dios la'ix'alhunut'an ju lapanacni chunch ju tapasai tachi ju tapasai acsni ach'ananan tam jok'at. ");
INSERT INTO teeNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pus ju yuchi lhtatai ju ts'is. Chai vats'isin k'ostolai. Para va is'akstu p'un ju ix'ach'ananti. Tak'ayai. Para ju anu' ach'anana' jantu machakxai tas lhip'unch. ");
INSERT INTO teeNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Pus va lacat'un ju p'un. P'ulhnan ju xaxk'oi ju p'un. Astan alinch ju xaxivic. Chai ju astan xacuxich ju toc'ai. ");
INSERT INTO teeNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Chai acsni c'at'atach ju xatoc'at pus lana ca'axk'anancanach ni k'oxich c'at'atach. ");
INSERT INTO teeNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ju Jesús vachu' chani alacjuni ju lapanacni: ―Tijuch nu' ju ixt'achunch jumputun tachi acsni lhinajun ju Dios la'is'atsucunti'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Pus acsni lhinajun ju Dios la'is'atsucunti'an ju lapanacni pus na lhu talhilaca'an ju Dios. Chunch ju tapasai tachi ju tapasai acsni ch'ancan ju xat'in mostaza ju lacat'un. Pus ju anu' t'in yuchi ju palai lact'icst'i tachi chun ju t'in ju alin ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Para acsni ch'ancan tak'ayai. Chai palai katak'aich jun tachi chun ali' ach'itin. Chai ju ts'ok'o lai ta'astacnan la'ixmakpu ju anu' ach'ananti. ");
INSERT INTO teeNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ju Jesús na tijlhu chivinti ju ix'ajuni ju lapanacni ju ixt'alakts'ipaxcavai ju tu'u'. Para va yuchi ix'ajuni ju laich ixtamachakxai. ");
INSERT INTO teeNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chai va tapakchux ju ix'amalani ju lapanacni akts'iya ixpuxcajui ju chivinti ju lai ixt'alakts'ipaxcavai ju tu'u'. Para acsni va is'akstu ix'alact'atolai ju ix'alacmamaka'ui pus lana vas ix'alacmavasalanik'ojui chux ju chivinti ju ix'ajunita ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chai ju anu' avilhchan acsni tok'oxalhch pus ju Jesús alacjuni ju ix'alacmamaka'ui: ―Catapasauch ju lhimak'antacutni atants'in. ");
INSERT INTO teeNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Pus talacmacaulh ju ixtalhavat lapanacni chai talhi'alh ju Jesús lacabarco junta ixvi acsni ix'amalani ju lapanacni. Chai ix'alin vachu' ju ali'in lapanacni ju ixtat'a'an lacalacat'icst'i ixbarco'an vachu'. ");
INSERT INTO teeNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Pus k'ostaya ju k'ai un chai na p'as tanek'elh ju xcan. Chai ixquitanuich lacabarco. Pus ju barco va is'aktsamputun ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Para ju Jesús va ilhtatai la'ixtimusni ju barco. La'is'akts'i ixlacpatai. Pus ju ix'alacmamaka'ui tamaklok'o ju Jesús chai tajuni: ―Amamaka'unu' ju uxint'i ja jantu tu'u' xcaniyan ni t'onau ninin lacxcan. ");
INSERT INTO teeNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Pus ju Jesús k'ostavi. K'ailh ju un. Chai juni ju xcan: ―Va sekch at'a'ulh. Pus lana va sek avanalh chai jantu lucunulh ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Chai ju Jesús alacsacmi ju ix'amamaka'ui: ―Tajuch ni va t'alhananat'it. Ja jantu lana quilalhilaca'anau. ");
INSERT INTO teeNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pus ju ix'alacmamaka'ui lana na talhamak'aninilh. Talaclajunich sia yu'unch: ―Tis chavaich nu' ju ani ni laich taquiclaca'i ju un chai ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Pus ju Jesús chai ix'amamaka'ui tacha'alh ju lhimak'antacutni atants'in junta ixt'un'an ixjunita ju amachak'an Gadara. ");
INSERT INTO teeNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Chai acsni tacutlh ju lacabarco ju Jesús pus lana xajchilh ju campusantu pumatam lapanac ju ixpacxanta ju lhacaticurulhni. Chai ju yuchi lana lak'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Pus ju anuch lapanac ix'amachak'ananta ju campusantu. Chai nin lacacadena jantu xamati' lai ixmakch'i. ");
INSERT INTO teeNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Va ta pakchux ixtach'anch'i chai ixtamakch'i lacacadena pus ju yuchi va ix'alack'exk'ojui ju cadena. Pus jantu xamati' lai ta ixnavi. ");
INSERT INTO teeNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chai ju tuncuj chai ju ts'is va tachi ist'asat'ajun lacatalhpan chai ju campusantu. Ixlacamac'atsanik'ocantach is'akstu ju lacachiux. ");
INSERT INTO teeNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pus ju anuch lapanac acsni lakts'ilh ju Jesús ixlhimakat lana ats'alalak'alh. Ta'aktsokotanilh. ");
INSERT INTO teeNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Chai ju lhacaticurulhni tapuchivinilh ixquilhni ju anu' lapanac. Chai na p'as ju tachivinilh acsni taxak'ala ju Jesús. Tajunich: ―Tijuch ju quilamintau lhilakts'inin ju uxint'i. Pus ju uxint'i ists'alh'at Dios ju vilhcha lact'iyan. La'ixtapaka'ut ju Dios iclatapaininiyau. Jantu aquilamamak'alhk'ajniu. ");
INSERT INTO teeNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Pus ju lhacaticurulhni tapunaulh chunch ni Jesús ix'ajunita ni catataxtulh la'ixlacatuna ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Chai ju Jesús sacmilh ju lapanac tuchi juncan. Chai ju yuchi ak'alhtayanalh: ―Legión icjuncan ni na quilhu quinc'an. Pus ju Legión ixtapaka'ut junita lhu taropajni. ");
INSERT INTO teeNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Chai ju anu' lhacaticurulhni na p'as tasq'uinilh lamapainin ju Jesús ni jantu ca'axcoxtulh ju anch lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Pus vanin ju anu' akstijun na lhu ixtat'ajun ju p'axnin. Va ixtat'ajun k'exvenin. ");
INSERT INTO teeNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Chai ixchux'an ju anu' lhacaticurulhni k'asi tasq'uinilh lamapainin ju Jesús. Tajunich: ―Aquilamaca'auch la'ixlacatuna'an ju p'axnin. Chach ictanuyau ju anch. ");
INSERT INTO teeNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Pus ju Jesús alak'a'inilh. Chai ju anuch lhacaticurulhni acsni tataxtulh la'ixlacatuna ju anu' lapanac pus lana tatanu la'ixlacatuna'an ju p'axnin. Chai ju ixtalhavat p'axnin lana tin ta'alh junta vak anta. Tatajucha laca'atants'in chai anch ju tanitajuk'o lacxcan. Pus ju anuch p'axnin ixtacha'anta lakat'ui milh. ");
INSERT INTO teeNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Pus ju ixtalhist'ac'a ju p'axnin na tatalhanalh chai ta'ats'alalh. Ta'alh nonin ju lak'achak'an chai ju lacacuxtun tuchi ixtapasata. Chai tataxtulh ju lapanacni amachak'an anch. Ta'alh lakts'inin tuchi ixtapasata. ");
INSERT INTO teeNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Talakmilh ju Jesús. Chai talakts'ilh ju anu' lapanac ju ixpacxanta lhu ju lhacaticurulhni. Para ju chavai ixmalakch'ininta junta ixvi. Chai ixtak'oxinita ju is'aktsulh. Pus na tatalhanalh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Chai ju lapanacni ju talakts'ilh ju tuchi ixtapasata ixlacata ju anu' lapanac chai ixlacata ju p'axnin tanonk'o. ");
INSERT INTO teeNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Pus tachi chun ju lapanacni tatapaininilh ju Jesús ni cataxtulh la'ixt'un'an. ");
INSERT INTO teeNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Chai acsni tanulh ju Jesús lacabarco pus ju anu' lapanac ju ixtaxtunita ju lhacaticurulhni la'ixlacatuna tap'astu ixch'ak'ok'aputun. ");
INSERT INTO teeNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Para ju Jesús jantu lacasq'uinilh. Va junich: ―Alai ap'inchich ju laminchaka'. A'unchich ju mint'a'amachak'an ni na k'ai lhamak'an ju xanaviniyan ju Dios lamilacatuna chai ni na xa'aktaijuyan laca'amapaininti. ");
INSERT INTO teeNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Pus ju anu' lapanac alh. Lacquilhuntsuculh ixlhilacaputs'un ju lacat'un junta ix'alin lakacau lak'achak'anixni. Ajuni ju lapanacni ni na k'ai lhamak'an ju navilh ju Jesús la'ixlacata. Pus va talhamak'aninilh chux ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Pus ju Jesús putapasachokopa aktam lacabarco la'ixlhimak'antacutni ju atants'in. Pus talhitak'aixtokpa lhu ju lapanacni. Chai ju Jesús taya la'ixquilhtu' ju atants'in. ");
INSERT INTO teeNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Pus ju acsnich chincha pumatam lapanac ju Jairo ixjuncan. Ju yuchi pumatam xak'ai ixjunita sia yu'unch ju ixtach'alhcatnan la'ixpujitat'an ju ist'a'israelitanin. Chai acsni lakchilh ju Jesús pus lana taquilhputanilh ju lacat'un vanin la'ixch'aja'. ");
INSERT INTO teeNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tapaininilh ju Jesús chai juni: ―Ju quintsi' t'ajun nini'. Aq'uint'ap'it'i k'ai lamapainin. Amokslanit'achi' ju mimaca' la'ixlacatuna ju yuchi ni palaich cajuna'. Jantu caniya'. ");
INSERT INTO teeNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Pus ju Jesús t'a'alh ju Jairo. Chai ixtalhavat lapanacni tach'ak'ok'alh. Na ixtalatank'asi'anta. ");
INSERT INTO teeNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chai pumatam chako'ulh ixmak'anta. Chai ju yuchi lakacaut'ui c'ata jantu ixlakxixta. ");
INSERT INTO teeNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Na lhu ixmak'alhk'ajnanta acsni ixtac'uch'ui ju ac'uch'unin. Chai ixmaca'ank'otach tachi chun ju ix'alinta para jantu tu'u' ixlhitapalai. Va apalai ixlhitap'asni. ");
INSERT INTO teeNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Pus ju anu' chako'ulh acsni k'asmatlh ni na lai ix'ac'uch'unun ju Jesús pus lana puchincha la'ixpulacan ju Jesús junta ix'alact'a'anta ixtalhavat lapanacni. Chai lakcha'anilh ixpumpu' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Va ixnajun la'ix'alhunut ni mas va yuchi ni calakcha'anilh lacats'unin ixpumpu' pus palaich cajuna'. ");
INSERT INTO teeNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Pus vasalh. Acsni lakcha'anilh ixpumpu' ju Jesús pus lana vats'alhti vak tamactalh ju ixtak'ank'at. Chai lana ucsac'atsa la'ixlacatuna ni palaich xajun. ");
INSERT INTO teeNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pus ju Jesús lana c'atsa ni ixc'uch'uta xamati'. Chai talakasp'itlh junta ix'anta la'ixtalhavat lapanacni chai alacjuni: ―Tis chavaich ju xaquilakcha'ani ju quimpumpu'. ");
INSERT INTO teeNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Para ju ix'alacmamaka'ui tajunich: ―Lakts'inch ni na lhu lapanacni ju tatank'asiyan ni t'isacminimp'alai tis chavaich ju xalakcha'aniyan ju mimpumpu'. ");
INSERT INTO teeNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Para ju Jesús alac'avanalh la'ixtalhavat lapanacni ni va ixlakts'imputun tichi chavaich ju ixlakcha'anita ju ixpumpu'. ");
INSERT INTO teeNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Pus ju anu' chako'ulh na ix'axq'uip'ip'itninta ni na ixtalhananta. Para ni c'atsa tuchi ixtapasata la'ixlacatuna pus lak'alh ju Jesús chai ta'aktsokotalh la'ix'ucxlacapu' chai jonk'o tuchi ixlaca'atalh ju lhilakcha'alh chai ni palaich va. ");
INSERT INTO teeNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Chai ju Jesús juni: ―Quintsi' ni xaq'uilhilac'ap'inch pus yuchi palai xalhi'un. Lhik'ach ap'it'i. Jantuch aktam ap'acxana' ju ani mintak'ank'at. ");
INSERT INTO teeNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Pus acsni ixt'ajunca' t'achivini' ju chako'ulh ju Jesús pus tachincha ju lapanacni ju ixtataxtutachalh ju ixchaka' ju anu' xak'ai. Tajunich ju yuchi: ―Ju mintsi' nitach. Tajuch ni va jeks amavap'ala' ju amamaka'unu'. ");
INSERT INTO teeNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Para ju Jesús acsni k'asmatlh ju ixchivinti'an lana junilh ju anu' xak'ai: ―Jantu at'alhan. Va aq'uilhilac'ap'ich. ");
INSERT INTO teeNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pus ju Jesús jantu lacasq'uilh ni xamati' cach'ak'ok'alh. Va yu'unch ju Pitalu' chai ju Jacobo chai ju Xivan isp'isek'e ju Jacobo. ");
INSERT INTO teeNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tamilh la'ixchaka' ju anu' xak'ai chai ju Jesús alakts'ilh ixtalhavat lapanacni ni na ixtalack'alhun. Na p'as ixtalact'asai. ");
INSERT INTO teeNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Chai acsni tanucha ju Jesús lacachaka' pus alacjuni ju lapanacni: ―Tajuch ni na va lhilact'asayap'alat'it chai na lhik'alhump'alat'it. Ju ani atsi' jantu nita. Va lhtatai. ");
INSERT INTO teeNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Para ju lapanacni va talhits'i'ilh ju Jesús. Pus ju acsnich ju Jesús alacxcoxtok'o ixchux'an. Va yuchi ixpaich ju anu' atsi' ju lhi'alh chai ixnatich chai ju ix'alact'aminta. Va yu'unch ju tat'atanu junta ixma ju atsi'. ");
INSERT INTO teeNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Chai ju Jesús ch'apanilh ixmaca' ju atsi' chai juni: ―Talita, cumi. Ju chunch va nomputun: Atsi' uxint'i ju icjunan. Ak'ost'a'ulhch. ");
INSERT INTO teeNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Pus ju atsi' lana k'ostavi. Alhtanalh. Ju yuchi lakacaut'ui c'ata ixpacxanta. Pus slivasalh na talhamak'aninilh ju lapanacni ju anch ixtavilanalh. ");
INSERT INTO teeNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Para ju Jesús slivasalh alaclhimap'aksi ju ixnati chai ixpai ju atsi' ni jantu xamati' catamac'atsani ju tuchi ixtapasata. Chai lana lhinaulh ixmavaca ju atsi'. ");
INSERT INTO teeNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ju Jesús taxtuchokopalhcha ju anch. Milh la'ixt'un. Chai vachu' tat'amilh ju ix'alacmamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Chai acsni cha'alh ju avilhchan pa'astacni pus ju Jesús alh la'ixpujitat'an ju ist'a'israelitanin chai tsuculh amalaninin. Pus na lhu ju tak'asmatlh na talhamak'aninilh ix'atalaninti. Ixtalaclajuni: ―Tas anchach nu' ju xalani ju ani chivinti ju ani ya lapanac. Tis atalaninti ju najun ju yuchi. Chai tas lai lhinavipalai ju k'ai lhamak'an. ");
INSERT INTO teeNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ni yuchi jumpalata ju axpitni'. Ists'alh ju Malia. Ixlak'au ju Jacobo chai ju José chai ju Judas chai ju Simón. Chai vachu' ani tat'ajun ju ix'ap'isek'ench atsi'in. Pus na taxcailich ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Para ju Jesús alacjuni: ―Ju lapanac ju najun ixchivinti Dios akts'iya tu'u' lhiulacan vanta anchach ju an. Va ixt'a'amachak'an chai ju ixt'a'amachivinti chai ixlhi'alak'avin ju jantu tu'u' talhiulai. ");
INSERT INTO teeNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Pus ju Jesús jantu lai tu'u' xanavi k'ai lhamak'an ju anch la'ixt'un. Va yuchi ni mama ixmaca' la'ixlacatuna'an ju tak'ank'anin chai ac'uch'u. Para jantu ilhu'an. ");
INSERT INTO teeNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Pus ju Jesús na ix'alaklhamak'aninin ju lapanacni ni jantu ixtalhilaksi ju yuchi. Pus astan ix'ucxu'an lak'achak'anixni ju vanin ixlacvi. Ix'amasuni ju lapanacni ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Pus alact'asanilh ju ixpumacaut'ui'an chai tsuculh alaclhca'ulana' pumat'iyun. Alacmalakacha ni cata'alh nonin ju ixchivinti Dios. Chai axtaknilh ixtachaput'an ni laich cataxcomak'alh ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Chai alacjuni ni jantu tu'u' catalhi'alh ju ixlacata ju lacati. Va yuchi ixpalic'an. Jantu catalhi'alh ispasti'an nin ixni'an nin ixtumin'an. ");
INSERT INTO teeNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Catach'antanu ju ixch'anxt'ak'an'an para jantu k'alht'ui catalhi'alh ju ixpumpu'an. ");
INSERT INTO teeNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Alacjuni: ―Ni xamati' catajunan ni lai alak'ac'ujt'it chai lai avenat'it la'ixchaka' pus anchach ju at'olht'achit'it tus acsni at'axt'uch'ok'oya'it'it ju anu' lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Para tachi chun ju jantu k'ox cata'amaklhtayananan nin yuchi ni catak'asmatniputunan ju minchivinti'an pus acsni at'axt'uya'it'it ju anu' lak'achak'an ach'anc'alhap'uxc'ant'it ju pokxni laminch'anxt'ak'an. Ju chunch catapuc'atsaya' ni talak'alhin ju tanavita. Slivasalh ju iclajunau. Ju anu' avilhchan acsni ca'amak'osaspitcana' ju lapanacni palai macxcai catamak'alhk'ajnana' ju anu' amachak'an ju jantu catak'asmat'a' ju minchivinti'an. Palai jantu ju amachak'anixni ju mak'aniya lak'achak'anixni Sodoma chai Gomorra. ―Chunch ju ajuni ju ixpumacaut'ui'an ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Pus ju yu'unch tataxtucha chai ajuni ju lapanacni ni catamacaulh ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Vachu' ixtaxcoxtui lhu ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. Chai ixtalacamuc'ai ju aceite lhu ju tak'ank'anin chai palaich ixtajun. ");
INSERT INTO teeNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Pus ju gobernador Herodes k'asmatlh tuchi ixnavi ju Jesús ni vanta anchach ispastaccanta. Chai naulh: ―Ju anu' ju Jesús tajuni ca yuchi ju Xivan ju amakpaxana'. Ca va ta'acxtuchokolh la'ix'aninti. Yuchi k'ai lhamak'an lhinavi. ");
INSERT INTO teeNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Para ju ali'in lapanacni ixtanajun: ―Jantiyu'. Alai ca yuchi ju Elías ju camina' acsni tuca' min ju najunta Dios ni camalakachatachilh. Chai ju ali'in ixtanajun: ―Jantiyu'. Alai ca yuchi ju lapanac ju najun ixchivinti Dios tachi ju ixtalai ju mak'aniya lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Para ju gobernador Herodes acsni k'asmatlh tuchi ixnavi ju Jesús naulh: ―Ju ani yuchi ju Xivan ju iclhinaulh ix'acch'uc'uca. Ca va ta'acxtuchokolh junta ixmacnucanta. ");
INSERT INTO teeNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Pus acsni tuca' ixmaknicanta ju Xivan pus ju Herodes ixlhinajunta ixch'ap'aca ju yuchi. Chai lhinaulh ixmakch'ica acsni t'alhnucalh. Chunch ju navilh ju gobernador ni ixnaviniputun ixk'achat ju Herodías. Pus ju Herodías ix'amachaka' ixjunita ju Pilipe. Isp'isek'e ju Herodes. Para ixmacajunta ju Pilipe chai ju Herodes ixt'at'ajun. ");
INSERT INTO teeNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Chai ju Xivan chani ixjunita ju Herodes: ―Jantuch lhijun ju lhamap'aksin ni va mi'amachaka' xanavi ju ix'amachaka' ixjunita ju mimp'isek'e. ");
INSERT INTO teeNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pus ju Herodías lhit'alaxcailh ju Xivan ixlacata ju ixchivinti. Chai ixlhinomputun ixmaknica. Para jantu lai ixnavi. ");
INSERT INTO teeNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Pus ju Herodes na ixtalhoni ju Xivan ni isc'atsai ni soknic'a ixjunita is'atsucunti chai ixlapanac Dios ixjunita. Pus yuchi jantu xalhilak'a'ini ju Herodías ni tu'u' macxcai canavi. Para ju Herodes mas va tam tam ixnajun acsni ixk'asmatni ju ixchivinti para ixlaquilhtu na ixk'asmatniputun ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pus lakatam avilhchan chilh ju pants'iquis ju ixpacxan ju Herodías. Pus ixc'atan ixjunita ju Herodes. Chai ju yuchi anavinilh k'ai lacvaiti ixt'axalack'ajin chai ju comandantenin chai ju xamak'alinin ju xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Chai tanucha ju istsi' ju Herodías junta ixtat'ajun venin chai tsuculh at'ini'. Pus lana k'achanilh ju ix'at'inti ju Herodes chai ju ix'alact'avi lacamixa. Chai ju Herodes junilh ju atsi': ―Aq'uisq'uininch va tuchi ixtalakxtuch ju lac'asq'uinch. Ju quit'in acxtakniyan. ");
INSERT INTO teeNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Pus ju Herodes lhipastacnilh Dios chai junilh ju atsi': ―Va tuchi ixtalakxtuch ju aq'uisq'uiniya' acxtakniyan mas aq'uisq'uiniya' ni alhinona' ju ali' lak'achak'an junta iclhinajun ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pus ju atsi' lana taxtucha. Alh sacmini' ju ixnati. Junich: ―Tijuch ju acsq'uiniya'. Pus ju ixnati junilh ni casq'uinilh ju is'aktsulh ju Xivan ju amakpaxana'. ");
INSERT INTO teeNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pus ju atsi' lana tanuchokocha junta ixvi ju Herodes chai junilh: ―Iclacasq'uin ni chavai lana aq'uixt'aknin lacatu'u' casavila is'aktsulh ju Xivan ju amakpaxana'. ");
INSERT INTO teeNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Pus ju acsnich ju gobernador lana na amak'aninilh. Para va ixlaca'atalh ni ixlhipastactach ju Dios acsni junilh ju atsi' ni caxtakniyach va tuchi casq'uiniyach chai ni tak'asmatlh ju ix'alact'avi lacamixa pus jantu lai naulh ni jantu. ");
INSERT INTO teeNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Pus ju gobernador lana malakachalh pumatam ixtaropa. Junilhch: ―Aq'uilhit'anin ju is'aktsulh ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Pus ju taropa alh acch'uc'unu' ju Xivan lacapulach'in. Chai lhiminilh ju aktsulh lacatu'u' casavila chai xtaknilh ju atsi'. Pus ju atsi' quixtaknilh ju ixnati. ");
INSERT INTO teeNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Chai acsni tac'atsa ju ix'alacmamaka'ui ju Xivan pus ta'alh. Tasaclh ju ixlacatuna. Taquimacnu. ");
INSERT INTO teeNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Pus tatasp'itchokocha ju ix'alacmalakachata ju Jesús ni cata'alh pumat'iyun amalaninin ju lapanacni. Chai talakminchokolh ju Jesús chai tajunk'o chux tuchi ixtanavi chai tuchi ixtamasunita ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Pus ju Jesús alacjuni: ―At'at'itch ju uxijnan lacamacni junta lai catolauch va qui'akstu'an. Junta lai ca'astacnanau pants'iquis. Ju Jesús alhijunilh chunch ni na lhu lapanacni ixtamin ixta'an junta ix'alact'avi ju Jesús ju ix'amamaka'ui. Pus lana mati' ixjunita ispants'iquis'an ni lai catavailh. ");
INSERT INTO teeNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Pus tatajulh is'akstu'an lacabarco. Ta'alh lhimak'antacutni atants'in junta jantu xamati' ixt'ajun. ");
INSERT INTO teeNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Para na pumalhu lapanacni talakts'ilh ju Jesús acsni alh. Chai tamispa. Chai ju amachak'an lakatamin lak'achak'an ta'ats'ala'alh junta ixta'amputun ju Jesús chai ix'amamaka'ui. Va tach'ajax'alh. Chai p'ulhnan tacha'alh ju va ixtach'ajax'anta. Astan tacha'alh ju Jesús chai ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Pus acsni tacutlh ju Jesús ju lacabarco pus alakts'ilh ju lapanacni ni na lhu ixtatak'aixtokta. Pus na alacmapaini ju yu'unch ni tachi ju tu'u' borregojni ixtajunita ju mati' ix'alhistacna'. Pus ju yu'unch vachu' mati' ixjunita xamati' ju ix'amasuni ju soknic'a ti. Pus lana tsuculh alacmasunini' chai na tijlhu chivinti ju xa'ajuni. ");
INSERT INTO teeNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Para acsni tok'oxalh pus ju ix'alacmamaka'ui talak'alh ju Jesús chai tajuni: ―Jantu xamati' t'ajun ju ani chai ju chavai na tok'oxatach. ");
INSERT INTO teeNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Amalak'ach'at'ich ju lapanacni ni cata'alh lacacuxtu junta lacyacha chaka' chai ju lak'achak'anixni ju vanin lacvi. Chach ta'ancha tamonin ju tuchi cata'uyach ni mati' tuchi cata'ulh ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Para ju Jesús ak'alhtayanalh. Alacjuni: ―Amavat'it ju uxijnan. Para ju ix'amamaka'ui ta'ak'alhtayanalh: ―Pus ja lai ac'anauch tamonin lakat'ui cientos tumin ju vati ni camavayauch. ");
INSERT INTO teeNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Para ju Jesús alacjuni: ―Tas akxchux vati ju alin. Inchit'it lakts'inin. Chai acsni tac'atsa tajuni: ―Alin akxquis vati chai lakat'ui pamata. ");
INSERT INTO teeNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Chai ju Jesús alacjuni: ―Alaclhc'a'ulachit'it ju lapanacni ju quilhmactamin quilhmactamin. Chach tatavi laca'ats'inan. ");
INSERT INTO teeNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Pus alhvakpitsicalh chai tatavi ju lapanacni. Ju quilhmactamin tamin cientos alhca'ulacalh. Chai ju aquilhmactamin cincuenta alhca'ulacalh. ");
INSERT INTO teeNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ju acsnich ju Jesús ch'apalh ju akxquis vati chai ju lakat'uich pamata. Talakst'alh ju lact'iyan chai xtaknilh lhak'ailakts'inti ju Dios. Ch'ek'elh ju vati. Chai axtaknilh ju ix'alacmamaka'ui ni cata'axtakniyach ju ixtalhavat lapanacni. Vachu' lhvakpitsik'o ju lakat'ui pamata. ");
INSERT INTO teeNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pus chux ju lapanacni tavailh chai talhilak'o. ");
INSERT INTO teeNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Chai ju ix'amamaka'ui ju Jesús tasacchokolh ju vati chai ju pamata ju tamaxajnicha ju jantu ta'ok'o. Lakacaut'ui tank'alin aktsamk'o. ");
INSERT INTO teeNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Pus sia yu'unch ju tavailh ixcha'anta lakaquis milh jok'atni. ");
INSERT INTO teeNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pus ju Jesús lana p'as ajuni ju ix'alacmamaka'ui ni catatajuchokolh la'ixbarco'an. Catap'ulh'alh ju lak'antacutni atants'in junta vilhcha ju lak'achak'an Betsaida. Ju yuchi tavilhca' ju anch ni laich ca'alacmalakachachokoya' la'ixchaka'an ju ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Chai ju Jesús acsni alacmalakachak'o ju lapanacni pus alh ju akstijun. Alh t'achivini' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Chai acsni tats'isi pus ju ix'amamaka'ui va la'ixlacaitatca' atants'in ixta'anta lacabarco. Para ju Jesús va is'akstu ixvilhchaca' ju lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Chai ju yuchi alakts'ilh ju ix'amamaka'ui ni na ixtaxk'optach ni ixtaxakatai'anta ju ixbarco'an. Para ni na p'as ixlai ju un chai na ixnek'esp'it'a ju xcan pus jantu lai ixtamalhtanai ju barco. Pus tachi lakat'utu hora vats'isin alakmilh ju ix'amamaka'ui ju Jesús. Ixtach'anta'anta la'ismusan ju xcan chai va ix'apu'iniputun ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Para ju yu'unch acsni talakts'ilh ni va alhtanaminta la'ismusan xcan pus tapastaclh ni ca yuchi ju macxcai un ju minta. Chai lana ts'au talact'asalh. ");
INSERT INTO teeNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Pus ixchux'an talakts'ilh chai slivasalh na tatalhanalh. Para ju Jesús lana soko axak'ala. Ajuni: ―K'ai anavit'it ju mi'alhunut'an. Quit'in. Jantu at'alhanant'it. ");
INSERT INTO teeNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Chai ju Jesús alact'ataju ju lacabarco. Chai lana sek va ju un. Chai ju yu'unch na tatalhanalh chai na talhamak'aninilh. ");
INSERT INTO teeNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Pus ju yu'unch lana jantu ixtamachakxai tichi lapanac ixlhitalacasui acsni amava ju akxquis vati ju lapanacni. Na va p'as ixjunita ju ix'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Acsni tacha'alh ju lhimak'antacutni ju atants'in ju Jesús chai ix'amamaka'ui pus tacha'alh ju xalacat'un Genesaret. Anch ju tach'i'ula ju ixbarco'an. ");
INSERT INTO teeNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Chai acsni tatacutlh ju yu'unch ju lacabarco pus lana tamispalhch ju Jesús ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Va ani ani ta'ats'ala'alh tachi chun ju lak'achak'anixni ju vanin ixlacvi. Tatsuculh lhiminin lacalona ju tak'ank'anin junta ixnoncan ixvi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Chai vanta anch ix'an ju Jesús u lacat'icst'i lak'achak'an u lack'ai lak'achak'an u lacacuxtu pus ix'amamacan ju tak'ank'anin ju lacati. Ixtatapaininich ju Jesús ni laich catalakcha'anilh mas va lacats'unin ixquilhtu' ixpumpu'. Pus ju Jesús alak'a'inilh chai tachi chun ju ixtalakcha'ani ixpumpu' palaich tava. ");
INSERT INTO teeNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lakatam avilhchan ju fariseonin chai ju ali'in ju na ixtalhatalanininta ixlhamap'aksin'an ju ist'a'israelitanin ju ixtamintacha ju Jerusalén tatak'aixtoklh junta ixvi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Chai ju yu'unch talakts'ilh ju ali'in ix'amamaka'ui ju Jesús ni jantu chun ixtamakch'ak'ai acsni ixtavajin tachi ju ixtalhilanita ju ist'a'israelitanin. Pus ixlhiyuchach tanaulh ni jantu k'ox tachi ju ixtalai ju ix'amamaka'ui ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Pus ju fariseonin chai ixchux'an ju ali'in israelitanin jantu ixtavajin ni jantu p'ulhnan na paklhu catamakch'ak'a. Pus chunch ixjunita ju iscostumbre'an ju ix'amacontilanita ju mak'aniya ixlacpa'itni'an. ");
INSERT INTO teeNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Chai acsni ixtatasp'ittacha ju laclhitamau pus jantu catavena' ni jantu catapaxa' p'ulhnan tachi ju ixtalhilanita. Chai na lhu ali' costumbre ju ixtanavi tachi ju ixtanavi ju mak'aniya ixlacpa'itni'an. Tachi acsni talak'ataxt'umak'an chai na paklhu ju talakch'ak'ai ju vaso chai ju xalu chai ju tsasnat xalu tachi ju akts'iya ixtalhilanita. ");
INSERT INTO teeNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Pus ju fariseonin chai ju ixtalhatalanininta ju lhamap'aksin tasacmilh ju Jesús. Tajunich: ―Ju mintamamaka'un tajuch ni jantu tanavi tachi ju akts'iya iclhilanitauch ju quijnan. Ju yu'unch ni lai tavajin mas jantu tamakch'ak'ata tachi ju iclhilanitauch ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pus ju Jesús alacmapuspitnilh ju chivinti chai alacjuni: ―Ju uxijnan na acxp'ut'iyununat'it. Slivasalh uctaxtulh tachi ju naulh ju mak'aniya lapanac ju Isaías ixjuncan. Ju yuchi naulh ni ca'alina' ju lapanacni ju chunch catalaya' tachi ju layat'it ju uxijnan. Ju yuchi ts'ok'ula ni ma chani naulh ju Dios: Ma yuchi ju Dios. Para ju ani lapanacni ma va la'ixquilhni'an ju tapunajun ni xak'ai ju yuchi. Para ju la'ix'alhunut'an ma lana jantu tu'u' talhiulai. ");
INSERT INTO teeNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ma jantu tu'u' nomputun ni tanajun ni yuchi ju xak'ai ju Dios. Ju yu'unch ma ta'amalaninin ju tu'u' tachi ju vasalh ixlhamap'aksin Dios mas va ixlhamap'aksin ixt'alapanac'an. Ju Isaías naulh ni ma chunch ju naulh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Chai ju quit'in iclajunauch ni vasalh chunch ju layat'it tachi ixnajun ju Isaías ni vachu' mac'a'unt'it ju uxijnan ju ixlhamap'aksin Dios. Va yuchi ju lac'a'iyat'it ixlhamap'aksin'an ju mint'alapanacni'an. Tachi acsni lak'at'axt'umak'anat'it chai na paklhu ju ch'ak'ayat'it ju tu'u' xalu chai ju tu'u' vaso. Chai vachu' alin palai lhu taxtokni va ixt'achun ju naviyat'it. ");
INSERT INTO teeNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Chai ju Jesús ix'alacjuni vachu': ―Ju uxijnan samak'ant'at'it ju ixlhamap'aksin Dios va ixlaca'atalh ni navip'ut'unat'it ju mi'atalaninti'an mi'akstu'an. ");
INSERT INTO teeNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Pus ju mak'aniya lapanac ju Moisés ixjuncan chani naulh: “At'alhonin ju mimpai chai ju minatich. Chai amakniya'it'it va tichi chavaich ju va taxtokni cajunilh ju tam ixpai u tam ixnati”. ");
INSERT INTO teeNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pus mas chunch ju nonat'it para lak'a'iyat'it ni chani cajunilh ju ixpai u ixnati ju tam lapanac: “Ju quit'in jantu lai actila'aktaiju va ixlaca'atalh ni iclhik'ailakts'ilh Dios ju anu' tumin ju xaclapu'aktaiju”. ");
INSERT INTO teeNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Chai ju uxijnan nonat'it ni ma jantu tasq'uini ni ca'aktaiju ju ixpai u ixnati ni va chunch ju canaulh tam lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Para ni chunch ju layat'it pus va samak'anat'it ixchivinti Dios ni va navip'ut'unat'it ju mak'aniya mi'atalaninti'an mi'akstu'an. Chai palai lhu taxtokni ju naviyat'it ju va ixt'achunch. Chai vachu' chun ju lacmasuniyat'it ju mi'ask'at'an'an. ―Chunch ju alacjuni ju lapanacni ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Chai aktam ju Jesús alact'asanilh ju ixtalhavat lapanacni chai alacjuni: ―Aquilak'asmatniuch minchux'an chai amach'akxat'it ju tuchi aclajunau. ");
INSERT INTO teeNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jantiyu' ju ui tam lapanac ju lai malhquiliquini is'atsucunti. Alai yuchi ju chivinti ju taxtui la'ix'alhunut. Yuchi ju malhquiliquini is'atsucunti tam lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ju uxijnan ju alin ju mimpak'asmatni'an pus ak'asmat'it. ");
INSERT INTO teeNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Pus ju acsnich ju Jesús taxtulh lacatalhavat. Alhtanalh. Chai acsni tanucha ju lacachaka' pus ju ix'alacmamaka'ui tasacmi tuchi ixnomputun ju anu' chivinti ju ix'ajunita ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Chai ju Jesús alacjuni: ―Ja vachu' jantu lai amach'akxananat'it ju uxijnan. Ja va jantu mach'akxayat'it ni jantu lai malhquiliquini is'atsucunti tam lapanac ju tuchi ui. ");
INSERT INTO teeNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ju tuchi ui jantu tanun la'ix'alhunut ju tam lapanac. Alai va la'ixpajan ju tajui chai astan va mak'ancanch. Pus ni catac'atsa ni si lai ok'ocan yuchi xa'alaclhijuni chunch ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Chai vachu' alacjuni: ―Tachi chun ju macxcai chivinti ju quilhtaxtui tam lapanac yuchi ju malhquiliquini ju is'atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Pus la'ix'alhunut'an ju lapanacni minacha ju jantu k'ox atalacpast'ac'at. Chai ixpuxcajuca apumatam chako'ulh u apumatam jok'at. Vachu' laca'alhunut minacha ju ixk'achanica ni va lacati tsucucan. Chai ju amakninti. ");
INSERT INTO teeNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Chai ju ak'alha'unti. Chai ju ixmakk'achanica ju jantu ix'anu'. Chai ixnavicach tachi chun ju ali' alactu'untich. Chai ju a'okxchok'onti. Chai acsni mati' ju maxanti. Chai ju alhaccha'anti. Chai ixnajunca ju macxcai ixlacata apumatam. Chai ju alhitak'ayanti. Chai ixk'achanica ju va lhilakachaput. ");
INSERT INTO teeNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pus tachi chun ju ani alactu'unti pulacni ix'alhunut ju lapanac ju minacha. Chai yuchach ju malhquiliquini is'atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ju Jesús taxtulh ju anu' lak'achak'an chai cha'alh ju xalacat'un junta ix'alin ju lak'achak'anixni Tiro chai Sidón. Chai ju Jesús anch ixt'ajun la'ixchaka' pumatam amachak'an anch. Para jantu ixlacasq'uin ni xamati' cac'atsa. Para jantu lai tatank'anu. ");
INSERT INTO teeNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Pus pumatam chako'ulh ix'alin istsi' ju ixtanun ju lhacaticuru la'ixlacatuna. Chai acsni k'alhak'asmatlh ni ixvi ju Jesús pus lana lakmilh. Ta'aktsokotanilh vanin la'ixch'aja'. ");
INSERT INTO teeNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Pus ju anu' chako'ulh ixchivinin ju lhigriego chai amachaka' Sirofenicia ixjunita. Pus ju yuchi tapaininilh ju Jesús ni caxcoxtunilh ju lhacaticuru la'ixlacatuna ju istsi'. ");
INSERT INTO teeNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Para ju Jesús chani juni: ―Chach p'ulhnan acti'aktaiju ju quint'a'amachivinti. Ni jantu chun aclalh pus ixt'achunch cava tachi ju va ac'aquictai'inilh ixni'an ju ask'at'an chai acxtaknilh ju sc'uyun. ");
INSERT INTO teeNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Para ju anu' chako'ulh ak'alhtayanalh. Junich: ―Vasalh ji qui'ucxtin. Para mas yu'unch ju sc'uyun ju tavilanalh ixtank'apu' mixa talacsac'ui ju xataquicpuchin ju talacamacajun ju ask'at'an. ");
INSERT INTO teeNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Pus ju acsnich ju Jesús junich: ―Slivasalh na k'ox xaquink'alht'a'i. Pus ap'inch'ok'ochit'ich ju laminchaka'. Ju lhacaticuru taxtuta la'ixlacatuna ju mintsi'. ");
INSERT INTO teeNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Pus ju chako'ulh alh. Chai acsni cha'alh la'ixchaka' pus lakts'ilh ju istsi' ni ixtaxtutach ju lhacaticuru la'ixlacatuna chai va ixmalhch la'ixputaman. ");
INSERT INTO teeNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ju Jesús taxtuchokocha junta ixvi vanin ju lak'achak'an Tiro. Pumilh ju lak'achak'an Sidón chai ju lacat'un junta ix'alin lakacau lak'achak'anixni. Cha'alh tus ju xa'atants'in Galilea. ");
INSERT INTO teeNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Pus lhiminicalh ju Jesús pumatam lapanac ju k'atapa ixjunita chai ju jantu lai k'ox ixchivinin. Chai ju lapanacni tatapaininilh ju Jesús ni camamanilh ixmaca' la'ixlacatuna ju anu' tak'ank'an ni palaich cajuna'. ");
INSERT INTO teeNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Pus ju Jesús malakxtinu ju tak'ank'an. Lhi'alh alacatam. Chai manunilh ixmaca' la'ix'ak'axk'olh. Quicchujva. Tsamalh ju isimak'at ju anu' tak'ank'an. ");
INSERT INTO teeNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Chai ju Jesús talakst'alh ju lact'iyan. Amak'aninilh. Chai junilh ju tak'ank'an: ―Epata. Ju chunch va nomputun: Ak'asmat'ich. ");
INSERT INTO teeNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pus lana laich ak'asmatnalh. Chai na k'oxich ixchivinin. ");
INSERT INTO teeNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Pus ju Jesús alaclhimap'aksilh ju lapanacni ni jantu xamati' catamac'atsani tuchi ixnavita. Para mas va ta pakchux ix'ajuni ju lapanacni va xa'apalaich ixtanajun tuchi ixnavich. ");
INSERT INTO teeNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Slivasalh ixtalhamak'aninin. Ixtanajun: ―Tachi chun si k'ox ju navik'ojui. Ju k'atapa lai lak'oxini ix'ak'axk'olh. Chai laich mak'asmat'ai. Chai ju jantu lai tachivinin lai machivini k'ox. ");
INSERT INTO teeNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ju acsnich na lhu ixtatak'aixtokta ju lapanacni. Chai mati' ixjunita tuchi cata'ulh. Pus ju Jesús alact'asanilh ju ix'alacmamaka'ui chai alacjuni: ");
INSERT INTO teeNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Paini'itnich ju ani tayanalh lapanacni ni lakat'utu avilhchan xaquintat'atolan chai ju chavai mati' tuchi cata'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ni aclacmalakachachokolh la'ixlacchaka'an nin tuca' tavajin jantu xcai ni catata'aktalh ju lacati ixchavan'an. Ju ali'in na makat tamintacha. ");
INSERT INTO teeNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Pus ju ix'alacmamaka'ui tak'alhtailh ju Jesús. Tajuni: ―Para tas anchach ju lai camalhilaniyau tachi tants'un ju lapanacni ju ani junta jantu xamati' t'ajun. ");
INSERT INTO teeNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Chai ju Jesús asacmipa: ―Tas akxchux vati ju ch'ap'at'at'it. Chai ju yu'unch tajunilh ni akxtujun. ");
INSERT INTO teeNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Pus ju Jesús alacjuni ju ixtalhavat lapanacni ni catatavi laca'ats'inan. Chai ju yuchi ch'apalh ju akxtujun vati. P'ulhnan xtaknilh lhak'ailakts'inti ju Dios chai astan ch'ek'elh ju vati. Xtaknilh ju ix'alacmamaka'ui. Chai ju yu'unch ta'alhilaktsak'o ju ixtalhavat. ");
INSERT INTO teeNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Vachu' ixtach'apata lacats'unin pamata. Pus ju Jesús xtaknilh lhak'ailakts'inti ju Dios chai ajunich ju ix'amamaka'ui ni cata'axtaknilh vachu' ju ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Pus taxtaknilh. Ta'ulh chai talhilalhch. Chai astan ju ix'amamaka'ui ju Jesús tasacchokolh ju tamaxajnicha. Talaktsama lakatujun tank'alin. ");
INSERT INTO teeNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Pus ju lapanacni ju tavailh ixcha'anta lakat'at'i milh jok'atni. Pus ju Jesús alacmac'ami. ");
INSERT INTO teeNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Chai lana alact'atajuchokolh lacabarco ju ix'alacmamaka'ui. Ta'alh ju xalacat'un Dalmanuta. ");
INSERT INTO teeNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Pus ju acsnich talakmilh ju Jesús ju fariseonin. Tatsuculh t'alak'ainin ju yuchi. P'as istasq'uini ni canavilh ju tu'u' ju catapuc'atsaya' ni vasalh yuchi ju ixnoncan camalakachatachilh ju Dios. Para va ixtalakts'intanuputun. ");
INSERT INTO teeNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pus ju Jesús amak'aninilh chai alacjuni: ―Ju uxijnan ju chavai t'onat'it tajuch ni va quilamakpuxcoyau tuchi laich icnavi ni nonat'it ni chunch laich ap'uc'ats'aya'it'it ni vasalh icCristo. Slivasalh ju iclajunau. Jantu tu'u' amasunic'ana'it'it ju uxijnan ju chavai t'onat'it. ");
INSERT INTO teeNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Chai ju acsnich ju Jesús lana alacmacoyaulh ju fariseonin. Tajuchokolh lacabarco. Anchokolh mak'antacutni ju atants'in. ");
INSERT INTO teeNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Pus ju ix'amamaka'ui ju Jesús ixtacaptach ixlhi'anca ju tu'u' xkapavati. Lacanix va lakatam xkapavati ixlhi'anta pumatam lacabarco. ");
INSERT INTO teeNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Pus ju Jesús alacjuni: ―Alacc'ats'anant'it ixlacata ixlevadura'an ju fariseonin chai ju ixlevadura ju Herodes. ");
INSERT INTO teeNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Chai ju ix'alacmamaka'ui ju Jesús talaclajunich sia yu'unch: ―Ni jantu iclhimintau tu'u' xkapavati ca yuchi quintalhijunan chunch. ");
INSERT INTO teeNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pus ju Jesús lana c'atsa tuchi ixtalaclajuni sia yu'unch. Chai alacjuni: ―Tajuch ni va lhamak'anininat'it ni jantu lhit'ant'at'it tu'u' xkapavati. Ja va jantuca' mach'akxayat'it ju uxijnan tuchi ju nomputun ju lhamak'an ju icnavita. Ja lana na va oktanp'as unt'at'it. ");
INSERT INTO teeNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Alinch ju milakchulh'an. Ja va jantu lakts'inat'it tu'u'. Alin ju mi'ak'axk'olh'an. Ja jantu lai p'ak'asmatnanat'it. Ja jantu lai p'ast'ac'at'it tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ja lana jantu p'ast'ac'at'it acsni tavanan icch'ek'elh akxquis vati chai talhilak'o lakaquis milh jok'atni. Ap'ast'act'it. Tas lakachux tank'alin ju xalakts'amayat'it ju xasacch'ok'oyat'it ju vati. Pus ju yu'unch tajunilh ni lakacaut'ui. ");
INSERT INTO teeNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Chai aktam ajunichokopa ju Jesús: ―Chai acsni icch'ek'elh ju akxtujun vati chai tavailh lakat'at'i milh lapanacni tas lakachux tank'alin ju xalakts'amayat'it ju xasacch'ok'oyat'it ju xajcha. Chai tak'alhtayanalh ni lakatujun. ");
INSERT INTO teeNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Chai ju Jesús alacjunich ju chavai: ―Ja ixlaquilhtu jantu lai mach'akxayat'it. ");
INSERT INTO teeNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ju astan ju Jesús chai ix'amamaka'ui tamilh ju lak'achak'an Betsaida. Chai ju lapanacni talhiminilh ju yuchi pumatam alak'ach'ix. Chai tatapaininilh ni calakts'ilh. ");
INSERT INTO teeNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Pus ju Jesús lana makch'apalh ju anu' alak'ach'ix. Maxtulh ju tak'ank'an. Lhi'alh tus lacamacni. Chai lakpuchujva la'ixlakchulh. Chai mokslanilh ixmaca' la'ix'ucxni ixlakchulh chai sacmi: ―Ja laich alac'avanan lacats'unin. ");
INSERT INTO teeNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Chai ju anu' alak'ach'ix ixjunita ni alac'avanalh naulh: ―Pus ju lapanacni ic'alakts'in ni ta'alhtanan. Para jantu k'ox ic'alakts'in. Tachi ju va q'uiu ic'alakts'in. ");
INSERT INTO teeNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Pus ju Jesús lana mokslanichokolh ixmaca' la'ix'ucxni ixlakchulh ju anu' alak'ach'ix chai ju yuchi alac'avananchokolh. Pus tak'oxinik'o ixlakchulh. K'ox alac'avanalh. ");
INSERT INTO teeNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Pus ju acsnich ju Jesús malakachachokolh la'ixchaka' ju va lacamacni ixyacha. Chai juni: ―Tun t'it'anut'ica' ju lak'achak'an. Chai tun t'i'a'un tu'u' ju amachak'an anch. ");
INSERT INTO teeNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Astan ju Jesús alact'ataxtulh ju ix'alacmamaka'ui. Va ixta'amputun ju lak'achak'anixni ju ixtalhilaca'anita ju lak'achak'an Cesarea Filipo. Chai ju lacati ju Jesús asacmilh ju ix'alacmamaka'ui. Alacjuni: ―Tis chavaich ju quintalhiulai ju quit'in ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Pus ju yu'unch tak'alhtayanalh. Tajuni: ―Pus ju ali'in lapanacni tanajun ni ma uxint'ich ju Xivan'at ju ix'amakpaxanan. Ju ali'in tanajun ni ma Elías'at. Ju ali'in tanajun ni ma uxint'ich pumatam mak'aniya lapanac ju ixnajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Pus ju acsnich ju Jesús alacsacmipa ju yu'unch. Ajuni: ―Para ju uxijnan tis chavaich ju quilalhiulayau ju quit'in. Chai ak'alhtayanalh ju Pitalu'. Juni: ―Uxint'i ju Cristo'at ju ixnoncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pus ju Jesús lana alaclhimap'aksi ni jantu xamati' catamac'atsani tichi chavaich ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ju acsnich ju Jesús tsuculh alacmalanini' ju ix'alacmamaka'ui. Ajuni: ―Akts'iya tasq'uini ni na lhu acmak'alhk'ajnana' ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Chai ju xalack'ajin lapanacni chai ju xalack'ajin palijni chai ju na talhatalanininta ju milhamap'aksin'an jantu tu'u' aquintalhiulaya'. Chai aquintamakniya'. Para acta'acxtuchokoya' junta acmacnucana' ixlhilakat'utu avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ju Jesús lana vas ajuni ju ani chivinti. Chai ju acsnich ju Pitalu' lhi'alh alacatam ju Jesús chai tsuculh amap'aksini'. ");
INSERT INTO teeNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Para ju Jesús talakasp'itlh. Alakts'ilh ju ali'in ix'alacmamaka'ui. Chai k'ailh ju Pitalu'. Junich: ―Ak'ost'i ju laqui'ucxlacapu' ji Satanás. Ju uxint'i jantu alacp'ast'acnan tachi ju alacpastacnan ju Dios. Ju uxint'i va alacp'ast'acnan tachi ju ta'alacpastacnan ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ju acsnich ju Jesús alact'asanik'o ju ix'alacmamaka'ui chai chux ju lapanacni. Alacjuni: ―Va tichi chavaich ju aquinch'ak'ok'aputulh ju quit'in pus jantu lai catinavi ixk'achat is'akstu. Chai cach'ixa' ju ixmak'alhk'ajnat ju ca'alina' va ixlaca'atalh ni quinch'ak'ok'ai ju quit'in. Chai aquinch'ak'ok'ak'alhi. ");
INSERT INTO teeNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Pus va tichi chavaich ju najun ni jantu quinch'ak'ok'aputun va ixlaca'atalh ni va lai maknicalh pus camak'ats'ank'aya' ju is'atsucunti ju ca'ix'alilh ju lact'iyan. Para va tichi chavaich ju camak'ats'ank'aya' ju is'atsucunti va ixlaca'atalh ni quinch'ak'ok'ai ju quit'in chai va ixlacata ni laca'ita ju chivinti ju najun ta yu lai tak'alhtaxtucan pus ca'alina' is'atsucunti ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Pus jantu tu'u' lhajai tam lapanac mas calhajak'o chux ju xataxtokni ju alin ju ani lacamunutpa' ni va calhimak'ats'ank'a ju is'atsucunti ju ca'ix'alilh ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Chai ni va chunch ju calalh pus jantu laich cati'alh ju anch mas camapalalh lacatumin. ");
INSERT INTO teeNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ju lapanacni ju tat'ajun ju chavai na tamacajunta ju Dios chai na ta'alactu'unun. Pus ni xamati' aquint'amaxanalh chai cat'amaxanalh ju quinchivinti la'ix'ucxlacapu'an ju yu'unch pus vachu' act'amaxanana' ju yuchi acsni acminchokoya' la'ixtachaput ju quimpai acsni ac'alact'amina' ju ix'anquilhnin. ");
INSERT INTO teeNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Vachu' ajunilh ju lapanacni ju Jesús: ―Slivasalh ju iclajunau. Alin ju lamilhi'uxijnan ju ani vilat'it ju jantu cataniya' tus acsni catalakts'ina' ta yu tasui acsni vi ju Dios la'ixpu'ucxtin. Chai catasuya' ni vasalh na tachapun ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Pus ju ixlhilakachaxan avilhchan astan ju Jesús alact'asanilh ju Pitalu' chai ju Jacobo chai ju Xivan. Alhi'alh va is'akstu'an ju lactalhpa junta na putank'ai ixjunita. Chai ju Jesús na tamch ju atalacasunilh ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ju ixpumpu' ju Jesús lana va lamnic'a va. Lana na xnapapa va tachi ju tu'u' miqui. Pus tachi chun ju amakpanin ju ani lacat'un jantu lai xamati' chunch snak'ank'a catinavi. ");
INSERT INTO teeNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Chai vachu' talacasuch ju Elías chai ju Moisés ju mak'anchich ixtat'ajun. Va ixtat'achivinin ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pus ju acsnich ju Pitalu' junilh ju Jesús: ―Qui'amamaka'unu' na k'oxich ni ani vilau. Acyoyau ak'at'utu pac'ats'a. Ak'atamch ju mi'anu'. Ak'atam ix'anu' ju Moisés. Chai ju ak'atamch ix'anu' ju Elías. ");
INSERT INTO teeNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pus ju Pitalu' jantu isc'atsai tuchi ixnajun ni na ixtalhanan. Ixchux'an na ixtatalhanan. ");
INSERT INTO teeNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Pus lana tamacatalh ju ataputs'i. A'akxtakmak'o ju yu'unch. Chai tak'asmatlh lakatam chivinti ju xaminacha laca'ataputs'i. Chai chani ixnajun: ―Ju ani ya yuchi ju quints'alh chai na icmapaini. Yuchach ju ak'asmatnit'it. ");
INSERT INTO teeNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Chai lana ta'alac'avanalh para jantu xamati' talakts'ilh. Va yuchi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Chai acsni ixtat'ajun tak'alhtajunin ju anu' lactalhpa pus ju Jesús alaclhimap'aksi ju ixpumat'utu'an ix'amamaka'ui. Ajuni: ―Tun xamati' t'i'unit'it ju tuch'i xalakts'inat'it. Va acsnich ju lai anona'it'it acsni va acta'acxtuchokotachilh junta acmacnucana' ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Pus jantu xamati' tajunilh. Para ixtalasacmi sia yu'unch. Ixtanajun: ―Tijuch nu' ju nomputun ju yuchi ni va nompalai ni cata'acxtuchokoya' junta camacnucana'. ");
INSERT INTO teeNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Pus ju acsnich tasacmilh ju Jesús. Tajunich: ―Tajuch ni va tanajun ju na talhatalanininta ju quilhamap'aksin'an ni tasq'uini ni p'ulhnan camilh ju Elías. Astan ju yuchi ju noncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Chai ju Jesús ak'alhtailh. Ajuni: ―Slivasalh ni p'ulhnan camina' ju Elías. Chai calak'oxik'oya' tachi chun ju taxtokni. Chai vachu' la'ixchivinti Dios ju ts'okcanta najun tuchi actapasayach ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Ju anch najun ni na lhu acmak'alhk'ajnana' chai jantu tu'u' aclhiulacana'. ");
INSERT INTO teeNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Para iclajunau ni quilachilh ju Elías chai ju lapanacni tanavilh chux tachi ju talacasq'uilh. Chai ni chunch ju talalh pus uctaxtulh tachi ju lhits'okcanta ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ju astan ju Jesús at'aminchokolh ju ixpumat'utu'an junta ixtayanalh ju ali'in ix'alacmamaka'ui. Chai alakts'ilh ni na lhu lapanacni ixk'aixtokcan ixtalakachoko'an ju yu'unch. Chai ju lapanacni ju na ixtalhatalanininta ju ixlhamap'aksin ju ist'a'israelitanin ixtat'ajun t'alak'ainin ju ix'amamaka'ui ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Para ju lapanacni acsni talakts'istuclh ju Jesús pus ixchux'an lana na talhamak'aninilh. Ta'ats'ala'alh pakxtoknin. Tamac'ami. ");
INSERT INTO teeNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Chai ju Jesús asacmi: ―Tijuch ju la'unat'it. ");
INSERT INTO teeNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pus ak'alhtayanalh pumatam ju ixmakminta. Junich: ―Amamaka'unu'. Iclhiminin ju quints'alh. Va tanun ju lhacaticuru la'ixlacatuna chai ixlhiyuchi jantu lai chivinin. ");
INSERT INTO teeNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Chai vanta anchach ju ch'apai ju lhacaticuru pus tin lhinek. Akpupuich. Va latants'acai ju istatsalat. Pus va t'ajun xixni'. Chai ic'atapaininilh ju mi'amamaka'ui ni cataxcoxtulh ju lhacaticuru la'ixlacatuna para jantu lai tanavi. ");
INSERT INTO teeNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Chai ak'alhtayanalh ju Jesús. Alacjuni: ―Tis va yuchach ji lapanacni ni lana jantu lai lac'a'iyat'it. Ja tasq'uini ni lana na mak'an aclat'atolau tus acsni laich amach'akxaya'it'it. Ja tasq'uini ni lana na mak'an aclach'ixniu tus acsni alac'a'iya'it'it. Aquilalhiminiuch ju anu' ts'alh. ");
INSERT INTO teeNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Pus lhiminicalh ju Jesús chai ju lhacaticuru acsni lakts'ilh ju Jesús pus lana tin lhineklh ju anu' ts'alh. Tin ta'aktalh. P'iliclh p'iliclh ucxuntama lacat'un. Akpuputamalhch. ");
INSERT INTO teeNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Pus ju acsnich ju Jesús sacmi ju ixpai ju anu' tak'ank'an. Junich: ―Ja mak'anch xa'aktaji ju ixtak'ank'at. Chai ju xapai junilh ju Jesús: ―Tus ixlhitalacat'icst'in. ");
INSERT INTO teeNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Chai ju lhacaticuru na paklhu ju maca'anta ju lacajipi chai lacxcan ni va makniputun. Pus ni laich navi tu'u' ju uxint'i aquila'aktaijuch. Aquilamapainiuch ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Chai ju Jesús junich: ―Ni laich lhilac'ap'in ju Dios pus sich lai canavinik'ocana' ju lhilaca'an yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pus ju acsnich ju ixpai ju ts'alh lana p'as chivinilh acsni chani ju junilh ju Jesús: ―Iclhilaca'an ju Dios. Para ni quinc'acxni lacats'unin pus aq'ui'akt'ai'ut'ich. ");
INSERT INTO teeNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Pus ju Jesús acsni alakts'ilh ju ixtalhavat lapanacni ni ixtalac'ats'alaminta pus k'ailh ju lhacaticuru. Junich: ―Ji lhacaticuru ju jantu lak'a'i ni cachivinilh nin cak'asmatlh ju ani ya ts'alh quit'in ju icjunan ni at'axt'uch la'ixlacatuna chai jantuch tavanan at'anuch'ok'oya'. ");
INSERT INTO teeNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Pus ju acsnich ju lhacaticuru ts'au t'asalh. Aktam tin lhineklh ju ts'alh. Chai lana taxtulh la'ixlacatuna. Pus ju ts'alh lhtucu tama tachi ju va xaninch. Chai akts'iya na lhu lapanacni ixtanajun ni va nitach. ");
INSERT INTO teeNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Para ju Jesús lana ch'apanilh ixmaca' ju ts'alh. Sa'ula. Chai ju yuchi taya. ");
INSERT INTO teeNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Pus ju acsnich ju Jesús tanucha lacachaka'. Chai ju ix'amamaka'ui acsni va is'akstu'an ixtat'avilanalh ju Jesús tasacmilh: ―Tajuch ni jantu lai xacxcoxtuyau ju lhacaticuru la'ixlacatuna ju anu' ts'alh. ");
INSERT INTO teeNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Pus ju Jesús alacjuni: ―Ju lhacaticurulhni tachi ju anu' ixtanun la'ixlacatuna ju anu' ts'alh va acsnich ju catataxtuya' acsni at'ap'aininiya'it'it ju Dios ju ixlacata chai at'asc'a'aya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ju Jesús chai ju ix'amamaka'ui acsni tataxtucha ju anch taputapasalh ju xa'estado Galilea. Chai ju Jesús jantu ixlacasq'uin ni xamati' cac'atsa ni anch ixvi. ");
INSERT INTO teeNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Va is'akstu ix'at'atolhputun ju ix'alacmamaka'ui ni ix'alacmalaniputun tu'u'. Ix'alacjuni: ―Ju quit'in acmak'axtakcanach la'ixmaca'an ju lapanacni chai aquintamakniyach. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Para mas acniyach acta'acxtuchokoya' junta acmacnucana' ixlhilakat'utu avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Para mas chunch ix'ajuni ixlaquilhtu jantu lai ixtamachakxai ju yu'unch tuchi ix'ajumputun. Chai na ixtatalhoni. Jantu istasacmiputun. ");
INSERT INTO teeNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Pus ju Jesús chai ju ix'alacmamaka'ui tacha'alh ju lak'achak'an Capernaum. Chai acsni ixtavilanalh lacachaka' pus ju Jesús alacsacmi ju ix'amamaka'ui. Ajunich: ―Tijuch ju ixlacq'uilhunt'onat'it ju uxijnan acsni xaminauch ju lacati. ");
INSERT INTO teeNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pus ju yu'unch va sek tatavi ni vasalh va ixtalaklak'aiminta ju lacati tichi chavaich ju palai xak'ai. ");
INSERT INTO teeNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Pus ju Jesús tavi chai alact'asanilh ixpumacaut'ui'an. Alacjuni: ―Ni alin pumatam ju jumputun xak'ai tasq'uini ni yuchi ju palai salacat'icst'i catalacasu tachi chun. Chai ca'alacch'alhcatnanilh tachi chun ju ali'in. ");
INSERT INTO teeNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Chai ju Jesús macch'apaxak'atailh pumatam ask'at'a. Yaulh la'ixlacaitat ju ixlacmamaka'ui. Astan ch'ixlh ju ask'at'a chai chani alacjunich ju yu'unch: ");
INSERT INTO teeNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Ju ca'amaklhtayanana' tam quilapanac ju jantu tu'u' lhit'ak'ayai tachi ju lai ju ani vi ask'at'a pus tachi ju va jun quit'in ju qui'amaklhtayanan. Chai ju qui'amaklhtayanan ju quit'in pus jantu qui'akstu ju qui'amaklhtayanan. Para tachi ju va jun amaklhtayanan vachu' ju Dios ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ju acsnich ju Xivan chani junilh ju Jesús: ―Qui'amamaka'unu' iclakts'iuch pumatam ju lamintapaka'ut ix'alacxcoxtui ju lhacaticuru la'ixlacatuna'an ju lapanacni. Para ick'ajiuch ni jantu lhiquijnan'an. ");
INSERT INTO teeNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Para ju Jesús junich: ―Jantu ixk'a'it'it ni jantu quint'alaxcai'an junita ju yuchi. Pus ju lai navi ju k'ai lhamak'an laquintapaka'ut pus qui'amigoch junita. Chai ju yuchi jantu lai astan macxcai aquilhichivina'. ");
INSERT INTO teeNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ju jantu quint'alaxcaich'an pus quijnanch'an. ");
INSERT INTO teeNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Slivasalh ju iclajunau. Va tichi chavaich ju cataxtakniyan mas va tam vaso ju xcan va ixlaca'atalh ni quilapanacni unt'at'it pus Dios ju camapalhniya'. Ju Jesús tailhi'alh ju ixchivinti chai chani naulh: ");
INSERT INTO teeNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","―Va tichi chavaich ju camak'alhk'osuya' tam xamati' ju jantuca' k'ox quilhilaca'anta quit'in pus palai k'ox ca'ixva ni ca'ixpixtuch'imuc'acalh ju xvati chai ca'ixmaca'ancalh laca'alama acsni tuca' ixmak'alhk'osui tam xamati'. ");
INSERT INTO teeNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Pus ni p'u'alact'u'ununat'it ju mimaca'an pus jantu anavit'it. Alai alat'it tachi ju va ch'akxp'uxcantach ju mimaca'an. Palai k'ox cava ni at'anuya'it'it ju lact'iyan mas va lakatamch ju mimaca'an. Palai jantu k'ox cava ni ap'acxant'it chux lakat'ui ju mimaca'an para va ap'umac'ap'inc'ant'it ju lacajipi junta jantu tavanan mixta. ");
INSERT INTO teeNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Junta alin ju tsapu ju jantu tavanan ni chai junta alin ju jipi ju jantu tavanan mixa. ");
INSERT INTO teeNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Pus ni p'imp'ut'unat'it junta ak'alhk'osa'it'it pus jantu ap'it'it ju anch. Alai alat'it tachi ju va ch'akxp'uxcantach ju minch'aja'an. Pus palai k'ox cava ni at'anuya'it'it ju lact'iyan mas va lakatamch ju minch'aja'an. Palai jantu k'ox cava ni ap'acxant'it chux lakat'ui ju minch'aja'an para va ap'umac'ap'inc'ant'it ju lacajipi junta jantu tavanan mixta. ");
INSERT INTO teeNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Junta alin ju tsapu ju jantu tavanan ni. Chai junta alin ju jipi ju jantu tavanan mixa. ");
INSERT INTO teeNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Chai ni yuchi ju lakts'imp'ut'unat'it ju tamalactu'uniyan pus jantu alakts'int'it. Alai alat'it tachi ju va maxt'ut'at'it chai mak'ant'at'it ju milakchulh'an. Pus palai k'ox cava ni at'anuya'it'it junta lhinajun ju Dios. Palai jantu k'ox ni ap'acxant'it chux lakat'ui ju milakchulh'an para va ap'umac'ap'inc'ant'it ju lacajipi junta jantu tavanan mixta. ");
INSERT INTO teeNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Junta alin ju tsapu ju jantu tavanan ni. Chai junta alin ju jipi ju jantu tavanan mixa. ");
INSERT INTO teeNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ju tu'u' jipi lhcuk'ojui ju amacxtalh. Chai ni acmuc'alh ju matsat lacatu'u' lhivai pus jantu catitak'alhi. Pus vana va chun lami'atsucunti'an. Acsni mak'alhk'ajnanat'it pus palai mac'onat'it ju amacxcai ju alin lami'atsucunti'an chai palai t'ailhip'inat'it ju k'ox ju akts'iya naviyat'it. ");
INSERT INTO teeNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Na k'ox ju matsat. Para ni jantu sk'ok'o cava pus jantu lhitapalai. Pus vana va chun ju uxijnan. Lhitapalai ju mi'atsucunti'an acsni vasalh tasui ni quilalhilaksiyau. Chai vachu' iclajunau ni jantu at'alasat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ju Jesús taxtulh ju lak'achak'an Capernaum. Milh ju xa'estado Judea lhimak'antacutni ju k'ai xcan Jordán. Chai aktam tak'aixtokchokopa ju lapanacni junta ixvi ju Jesús. Chai aktam alacmalani tachi ju akts'iya ixlai. ");
INSERT INTO teeNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Chai tachincha ju ali'in fariseonin. Va ixtapuxconiputun ixtalak'alhin ju Jesús. Chai tajuni: ―Ja lhijun ju lhamap'aksin ni camacaulh ju ix'amachaka' ju tam jok'at. ");
INSERT INTO teeNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Pus ju Jesús ak'alhtayanalh. Alacjuni: ―Tijuch ju naulh ju Moisés la'ixlhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Chai ju yu'unch ta'ak'alhtayanalh. Tajuni: ―Pus ju Moisés ixlak'a'i ni acts'oklh lakatam alhiqui ju pulamacau chai acmacaulh. ");
INSERT INTO teeNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Para ju Jesús alack'alhtailh. Alacjuni: ―Va ixlaca'atalh ni na p'as ju mi'alhunut'an yuchi xalhi'ats'oknun junima lhamap'aksin ju Moisés. ");
INSERT INTO teeNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Para acsni tavanan navitacha ju Dios ju lacamunutpa' ju yuchi navilh pumatam ts'alh chai pumatam atsi'. ");
INSERT INTO teeNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Pus ixlhiyuchi ju tam ts'alh camaconach ju ixpai chai ixnati chai cat'atsucuya' ju ix'amachaka'. ");
INSERT INTO teeNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Pus ju anu' ixpumat'ui'an tachi ju va pumatam catajuna'. Pus ju chunch jantuch vana pumat'ui tajunita. Alai tachi va pumatam lapanac tajunita. ");
INSERT INTO teeNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Pus ju malakxtokta ju Dios jantu catitalhvaklh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Chai acsni tanuchokolh lacachaka' ju Jesús pus ju ix'amamaka'ui aktam tasacmichokopa ixlacata ju anu' chivinti ju ix'ajunita ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Pus ju Jesús alacjuni: ―Va tichi chavaich ju camacona' ju ix'amachaka' chai cat'atsucuchokolh apumatam navi talak'alhin la'ixmacni ix'amachaka' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Chai ju chako'ulh ni camacaulh ju ixpapa chai cat'atsucuchokolh ak'antam pus talak'alhin ju navi vachu'. ");
INSERT INTO teeNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ju acsnich alhicha'anicalh ju Jesús ju ask'at'an ni ca'amokslanilh ixmaca' la'ixlacatuna'an ju yu'unch chai catapaininilh ju Dios ni k'ox catatsuculh. Para ju ix'alacmamaka'ui ta'alack'aima ju ixtalhicha'an ju is'ask'at'an. ");
INSERT INTO teeNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Para acsni lakts'ilh ju Jesús tuchi ixtanavi ju ix'alacmamaka'ui pus talhk'amalh. Alacjuni: ―Amac'a'unt'it ju ask'at'an. Chach quintalakmilh. Jantu asasp'it'it ni quintalhilaksich ju yu'unch. Chai va tichi chavaich ju aquilhilaksiya' tachi ju quintalhilaksi ju ani tayanalh ask'at'an yuchi ju laich catanuyanta ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Slivasalh ju iclajunau. Tachi chun ju lapanacni ju jantu quilhilaksi ju quit'in tachi ju tam ask'at'a lhilaksi ju ixpai pus jantu tavanan lai catitanu junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Pus ju acsnich ju Jesús alacch'ixlh ju ask'at'an. Alacmuc'anilh ixmaca' la'ix'ucxni ixlacatuna'an chai sq'uinlh ju k'ox is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ju Jesús taxtuchokopa ju anch. Chai acsni ix'amputun ju lacati pus ats'alamilh pumatam ts'alh chai ta'aktsokotanilh ju yuchi. Chai sacmilh: ―Amamaka'unu' ju uxint'i na k'ox lapanac'at. Tijuch ju acnaviya' ni ca'alilh ju qui'atsucunti ju conk'alhiyanta ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Pus ju Jesús juni: ―Ju uxint'i ni na'un ni va iclapanac pus tajuch ni va q'ui'unich ni ick'ox. Jantu xamati' ju k'ox. Va pumatam. Yuchi ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ju uxint'i misp'aich junta chani najun lamilhamap'aksin'an: “Jantu at'ats'uc'u ju jantu mi'amachaka'. Jantu amaknit'i xamati'. Jantu ak'alhaun. Jantu anau ta'aklhtamat chivinti ixlacata apumatam. Jantu a'okxch'ok'ot'ai'init'i tu'u' xamati'. At'alhonin ju mimpai chai ju minatich”. ");
INSERT INTO teeNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Pus ju anu' ts'alh ak'alhtayanalh. Junich ju Jesús: ―Amamaka'unu'. Chux ju ani icmuctaxtuk'ota tus quilhitalacat'icst'in. ");
INSERT INTO teeNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ju acsnich ju Jesús lakts'ilh ju anu' ts'alh chai na mapaini. Junich: ―Ti'alin lakatam taxtokni ju tasq'uini ni anavit'i. Inchich. Ast'achich tachi chun ju mi'alinta chai axt'aknin ju tumin ju amak'aixt'ok'a' ju quilhpatinin. Ju chunch ca'alina' ju mimak'alit ju lact'iyan. Chai astan aq'uinch'ak'ok'ach. Chai ach'ixt'ich ju mak'alhk'ajnat ju ca'alina' va ixlaca'atalh ni aquilhilaksiya' ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Para ju anu' ts'alh acsni k'asmatlh junima chivinti lana na amak'aninilh. Na amak'anini'alh ni na mak'ali' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ju acsnich ju Jesús alakts'ilh ju lapanacni ju ixtayanalh ixtalakachoko chai alacjuni ju ix'alacmamaka'ui: ―Na lhixcai ni lai catanu ju lact'iyan junta lhinajun ju Dios tam mak'ali'. ");
INSERT INTO teeNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Pus ju ix'alacmamaka'ui Jesús na talhamak'aninilh ju ixchivinti. Para ju Jesús alacjunchokopa: ―Quints'alan na lhixcai ni lai catatanu ju lact'iyan junta lhinajun ju Dios ju yu'unch ju na talhilaksi ju ixmak'alit'an. ");
INSERT INTO teeNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ju tu'u' camello jantu lai catitapasalh junta tilhucucu ju macscat. Pus vana va chun tam mak'ali'. Ju yuchi jantu lai catitanun ju lact'iyan junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pus ju ix'amamaka'ui acsni tak'asmatlh ju ani chivinti va palai talhamak'aninilh. Chai talaclajuni sia yu'unch. ―Pus tis chavaich ju lai camak'alhtaxtucana'. ");
INSERT INTO teeNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Para ju Jesús alakts'ilh. Ajuni: ―Ju va lapanac akts'iya palai tu'u' lhiulai ju ixmak'alit. Palai jantu ixtaxtokni Dios. Para ju Dios lai amapaxani ix'atalacpast'ac'at tam lapanac. Pus tachi chun ju taxtokni si lai navik'ojui ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ju acsnich ju Pitalu' junich: ―Ju quijnan icmaconk'otauch chux quintaxtokni quinc'an chai iclach'ak'ok'atauch. ");
INSERT INTO teeNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Chai ju Jesús ak'alhtayanalh. Junich: ―Slivasalh ju iclajunau. Va tichi chavaich ju calhimacaulh ju ixchaka' u tam ixlak'au ts'alh u tam ixlak'au atsi' u ixpai u ixnati u ix'amachaka' u is'ask'at'an u ixlacat'un va ixlaca'atalh ni quinch'ak'ok'ai ju quit'in chai va ixlacata ni laich ca'ajunilh ju lapanacni ta yu laich catatak'alhtaxtulh pus palai lhu caxtaknicana'. ");
INSERT INTO teeNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ju chunch calalh pus ca'alina' lhu chaka' junta laich cacha'ana' tachi ju va la'ixchaka' junita. Chai ca'alina' lhu lapanacni ju tachi vasalh ix'alak'avin catajuna' mas jantu. Chai ca'alina' ju tachi vasalh ixlacnati'an tajunita chai tachi ixlac'ask'at'an catajuna'. Chai ca'alina' lhu ju lacat'un junta lai camach'ixtaknicana' ni laich cach'alhcatnana' tachi ju va ix'anu'. Ca'alina' tachi chun ju ani para vachu' catamak'alhk'ajnana' ni vachu' ca'axcaicana'. Chai astan ca'alina' is'atsucunti'an ju conk'alhiyanta lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Para ju lact'iyan ca'alina' lapanacni ju mak'anch xaquintalhilaksi. Para jantu lai actinaulh ni va ixlhiyuchi palai k'ox ca'alhilhiulacalh. Palai jantu ju ali'in. Chai cata'alina' lapanacni ju jantuca' mak'an xaquintalhilaksi. Para jantu lai actinaulh ni ixlhiyuchi palai jantu k'ox ca'alhilhiulacalh. Palai k'ox ca'alhiulacalh ju ali'in. ");
INSERT INTO teeNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Pus ju Jesús chai ju ali'in ixta'alhtana'anta laxati ju Jerusalén. Chai ju Jesús ix'ap'ulhnita ju ali'in. Chai ju ix'amamaka'ui ni va ixtalhamak'aninin ju Jesús pus ixtatak'aixui. Chai na ixtatalhanan. Pus ju acsnich ju Jesús alact'asanilh ixpumacaut'ui'an chai va is'akstu'an alact'a'alhtanalh ju lacati. Chai ju yuchi tsuculh ajunini' ju taxtokni ju catapasaya' la'is'atsucunti ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Alacjuni: ―Alakts'int'it. Ju chavai cacha'anau ju Jerusalén. Chai ju quit'in acmak'axtakcana' la'ixmaca'an ju xalack'ajin palijni chai ju na talhatalanininta ju milhamap'aksin'an. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Chai ju yu'unch aquintalhinona' ju quimaknica. Chai aquintamak'axt'ak'a' la'ixmaca'an ju jantu quint'a'israelitanin'an. ");
INSERT INTO teeNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Chai ju yu'unch aquintalhits'i'ina'. Chai aquintak'ainekmaya'. Chai aquinta'acxpuchujvaya'. Chai aquintamakniya'. Para ju ixlhilakat'utu avilhchan acta'acxtuchokoya' junta acmacnucana'. ");
INSERT INTO teeNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ju acsnich ju Jacobo chai ju Xivan ists'alan ju Zebedeo talak'alh ju Jesús chai tajunich: ―Amamaka'unu' iclacasq'uinau ni aquilanaviniu ju tuchi aclasq'uiniyau. ");
INSERT INTO teeNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Chai ju Jesús alacjuni: ―Tijuch ju lac'asq'uinat'it ju aclanaviniu. ");
INSERT INTO teeNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Chai ju yu'unch tajunich: ―Va iclacasq'uinau ni alak'a'iya' ju uxint'i ni anch actolauch ju pumatam lamilhicana chai ju pumatam lamilhimacx acsni xak'ai a'una'. ");
INSERT INTO teeNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pus ju acsnich ju Jesús alacjuni: ―Ju uxijnan jantu c'ats'ayat'it tuch'i sq'uinat'it. Ja lai amak'alhk'ajnana'it'it tachi ju acmak'alhk'ajnana' ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ju yu'unch ta'ak'alhtayanalh. Tajunich ni calayach. Chai ju Jesús alacjuni: ―Slivasalh chunch ju amak'alhk'ajnana'it'it tachi ju acmak'alhk'ajnana' ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Para jantu quit'in ju acnona' tichi chavaich ju catola' laquilhicana chai laquilhimacx. Yu'unch ju catatolach anch ju asacxtuta. ");
INSERT INTO teeNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Pus ju ixpumacau'an ix'amamaka'ui ju Jesús acsni tak'asmatlh tuchi ixtanajunta ju Jacobo chai ju Xivan na talhitalhk'amalh. ");
INSERT INTO teeNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Para ju Jesús alact'asanilh ixchux'an chai alacjunich: ―Ju uxijnan c'ats'ayat'it ni slivasalh na p'as talhinajun ju xa'ucxtin lakatam k'ai lacat'un. Chai na alhimacchapui ju lapanacni ju salact'icst'i ucxtinin ju amalakachacan. ");
INSERT INTO teeNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Para jantu chun ju alat'it ju uxijnan. Alai va tichi chavaich ju lamilhi'uxijnan ju palai xak'ai jumputun tasq'uini ni calhitalacasu tachi ju tam xalapanac. ");
INSERT INTO teeNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Chai va tichi chavaich ju milhi'uxijnan ju xak'ai jumputun tasq'uini ni cacaplich ju chunch. Alai va cajunlh tachi ju va tam xalapanac. ");
INSERT INTO teeNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Chunch ju alat'it tachi ju iclai ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Pus ju quit'in jantiyu' iclhiminta ni va aquintach'alhcatnanilh ju lapanacni. Alai iclhiminta ni ac'alacch'alhcatnaniya' ju lapanacni chai acxt'ak'a' ju qui'atsucunti va ix'amalakxtuca lhu ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ju Jesús chai ju ix'amamaka'ui chai lhu lapanacni tamilh ju lak'achak'an Jericó. Chai acsni tataxtuchokolh ju anch pus ixvi la'ixquilhtu' ti ju Bartimeo. Ists'alh ju Timeo. Ju yuchi va alak'ach'ix ixjunita chai ispusac'a ju tumin. ");
INSERT INTO teeNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Chai ju yuchi acsni k'asmatlh ni minta ju Jesús amachaka' Nazaret pus tsuculh t'asanini'. Junich: ―Jesús. Ists'alh'at ju k'ai ucxtin David. Aq'uinavininch lamapainin. ");
INSERT INTO teeNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Para na lhu lapanacni ju ixtat'aminta ju Jesús ju lacati ixtalak'ak'aimai. Tajuni ni va sekch catavi. Para ju yuchi va apalai p'as ixchivinin. Ixnajun: ―Ji ists'alh ju k'ai ucxtin David aq'uinavinin lamapainin ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Pus ju acsnich ju Jesús lana taya. Lhinaulh ist'asanica ju Bartimeo. Pus ta'alh t'asaninin ju alak'ach'ix chai tajunich: ―Ak'ach'ach. At'aich. T'asaniyan ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Pus ju yuchi macoma ju ixcutun. Alhtujnutaya chai lak'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Chai ju Jesús junich: ―Tijuch ju acnaviniyan. Chai ju alak'ach'ix juni: ―Amamaka'unu' ic'alac'avamputun. ");
INSERT INTO teeNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Pus ju Jesús juni: ―Pus laich ap'ina'. Ni xaq'uilhilac'ap'inch pus laich alac'avanana'. Pus lana alac'avanalh ju anu' alak'ach'ix ixjunita. Chai t'a'alh ju Jesús ju lacati. ");
INSERT INTO teeNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ju vanin ju lak'achak'an Jerusalén ixta'alin lakat'ui lact'icst'i lak'achak'anixni. Ju lakatam ixjuncan Betfagé chai ju lakatam ixjuncan Betania. Chai vanin ju anu' lak'achak'anixni ix'alin ju akstijun junta ixch'ancanta ju xaq'uiu ju olivos ixjuncan. Pus ju Jesús acsni alact'acha'alh ju anch ju ixtalhavat lapanacni pus amalakacha pumat'ui ix'alacmamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Alacjunich: ―A'inchit'it ju anu' tasui lak'achak'an. Chai acsni at'anut'achit'it alhit'a'uya'it'it lakatam sast'i puru ch'iyocanta. Tuca' xamati' putoc'ai. Axk'ot'aya'it'it. Alhit'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Chai ni xamati' catajunan: “Tajuch ni va chun ju lap'alat'it”, pus va a'una'it'it ni ma maktasq'uini ju mi'ucxtin'an chai ma vats'alhti camalakachachokotachilh. ");
INSERT INTO teeNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Pus ta'alh. Chai talhitajucha ju puru junta ixch'iyocanta lacati vanin lacamalhtich. Chai taxk'otailh. ");
INSERT INTO teeNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pus ju ixtayanalh anch tajuni: ―Tijuch ju naviyat'it ni va xk'ot'ayat'it ju puru. ");
INSERT INTO teeNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Chai ju ix'amalakachan ju Jesús tajunilh tachi ix'ajuncanta. Chai ju acsnich yau ajunicalh ni catalhi'alh ju puru. ");
INSERT INTO teeNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Chai talhimilh ju puru junta ixvi ju Jesús. Ta'akxch'amuc'alh ixcutun'an chai ju Jesús putoc'alh. ");
INSERT INTO teeNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pus na lhu lapanacni ixtamamalhi'anta ixcutun'an ju lacati junta capumina' ju Jesús. Ju ali'in ixtachakx'i ju ix'acatan q'uiu chai ixtamamalhi'anta ju lacati. ");
INSERT INTO teeNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Chai ju ixta'ap'ulanan chai ju ixtak'aixunun ixtalact'asa'anta ju lacati. Ixtanajun: ―Chach lak'ayacalh ju ani minta. Paxcat ju ani ju minta ju malakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Na k'ox cajuna' ju ixpu'ucxtin ju ca'alina'. Chunch ju cajuna' tachi ixjunita ixpu'ucxtin ju mak'aniya quimpai'an David. Chach lak'ayacalh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Pus ju Jesús acsni tanu ju lak'achak'an Jerusalén alh ju lacak'ai ixpujitat'an ju ist'a'israelitanin. Chai acsni islakts'ink'otach tachi chun ju taxtokni ju anch pus alact'ataxtuchokolh ju ixpumacaut'ui'an. Chai ni na ixtok'oxatach pus alact'a'alh ju lak'achak'an Betania. ");
INSERT INTO teeNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chai acsni tuncunchokopa pus ju Jesús chai ju ix'amamaka'ui tataxtuchokocha ju Betania chai ju Jesús chavanilh. ");
INSERT INTO teeNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Chai acsni lakts'ilh ju ixlhimakat ak'atam xaq'uiu higo ju na xk'oyu ixlatach pus lak'alh. Ts'a ma laich calhitaju tu'u' xalhi'ut. Para acsni quilakts'ilh jantu tu'u' lhitaju. Va si xaxk'oi. Va ts'alhti ixlakap'unta mas tuca' ixcha'anta ju avilhchan acsni ca'alilh ju xatoc'at. ");
INSERT INTO teeNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Pus ju acsnich ju Jesús junilh ju anu' xaq'uiu higo: ―Jantu tavanan cati'alinchokolh ju mi'atoc'at ju lai cata'ulh ju lapanacni. Pus tak'asmatlh ju ix'alacmamaka'ui tuchi juni ju Jesús ju anu' xaq'uiu higo. ");
INSERT INTO teeNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Astan ju Jesús chai ju ix'alacmamaka'ui tamilh ju Jerusalén. Chai acsni tanulh ju Jesús ju lacak'ai ixpujitat'an ju ist'a'israelitanin pus tsuculh alactixcoxtunu' ju lapanacni ju ixta'ast'anan chai ju ixta'atamonan ju anch. Alakmakspusp'itnik'o ju ixmixa'an ju ixmapaxanin tumin chai ixputolan'an ju ist'anin lak'axk'avan. ");
INSERT INTO teeNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Chai jantu xalacasq'uin ni xamati' cac'uc'alhi'alh tu'u' ju la'ismakspa' k'ai ixpujitat'an ju ist'a'israelitanin ni tachi ju va lacati cata'ulhtulh. ");
INSERT INTO teeNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Chai ix'alacmasuni ju lapanacni chai alacjuni: ―Ts'okcanta la'ixchivinti Dios junta najun ni ixchaka' ma calhimispacana' ni anch ju lai cat'achivina' ju Dios va tichi chavaich. Chunch ju ts'okcanta para ju uxijnan ni va lhimalacxt'ut'at'it ju tu'u' lhucucu talhpa junta tatank'anui ju ak'alhonin. ");
INSERT INTO teeNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pus ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin chai ju xalack'ajin palijni tak'asmatlh ju tuchi ixnajunta ju Jesús. Chai ju acsnich tatsuculh puxconin ta yu laich catapumakniya'. Para va ixtatalhoni ju Jesús ni chux ju lapanacni na ixtalhamak'aninin ju ix'atalaninti. ");
INSERT INTO teeNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Para acsni tok'oxapa pus ju Jesús taxtuchokolh ju anch lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chai acsni tuncunchokolh pus ju Jesús chai ix'alacmamaka'ui ta'alhtanampa ju lacati. Chai talakts'ilh ju xaq'uiu higo ni ixixtach tus la'istisivic. ");
INSERT INTO teeNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ju acsnich ju Pitalu' pastaclich tuchi ixtapasata chai junich ju Jesús: ―Amamaka'unu' alakts'ich ju xaq'uiu higo ju lak'ak'aimat'i. Na xixtach ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Chai ju Jesús ak'alhtayanalh. Alacjuni: ―Alhilaksit'it ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Slivasalh ju iclajunau. Va tichi chavaich ju cajunilh ju ani talhpa: “Ak'ost'ich. At'a'uchich ju laca'alama”, pus canavinicana'. Para tasq'uini ni jantu va tam tam canona' la'ix'alhunut. Alai calaca'iya' ni calhixajanta tuchi canona'. ");
INSERT INTO teeNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Yuchi iclalhijunau ni tachi chun ju asq'uina'it'it acsni at'ach'ivinina'it'it ju Dios alac'a'it'it ni amaklht'ayanana'it'it chai axt'aknic'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Chai acsni ats'uc'uya'it'it t'ach'ivinin ju Dios amac'acxanin ni alin xamati' ju t'alak'aitan. Ju chunch ju mimpai'an ju vilhcha lact'iyan catamac'acxaniyanch vachu' ju uxijnan ju mintalak'alhin'an. ");
INSERT INTO teeNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Para ju uxijnan ni jantu amac'acxaniya'it'it ju mint'alaxcai'an pus nin yuchi ju mimpai'an ju vilhcha lact'iyan jantu catitamac'acxanin ju mintalak'alhin'an. ");
INSERT INTO teeNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ju acsnich ju Jesús chai ju ix'amamaka'ui ta'anchokopa ju lak'achak'an Jerusalén. Chai ju Jesús ix'alhtanat'ajun lacak'ai ixpujitat'an ju ist'a'israelitanin. Pus talakmilh ju yuchi ju xalack'ajin palijni chai ju papaninch chai ju na ixtalhatalaninintach ju ixlhamap'aksin'an ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Tajunich: ―Tis chavaich ju xajunan ni laich anaviya' ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Pus ju Jesús alack'alhtailh. Alacjunich: ―Vachu' aclasacmiyau ju uxijnan lakatam chivinti. Ni aquilajuniuch pus vachu' aclajunau tichi chavaich ju xaquijuni ni acnavi junima taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Pus tis chavaich ju xamalakachayachilh ju Xivan amakpaxana'. Ja yuchi ju Dios u yu'unch ju lapanacni. Aquilajuniuch. ");
INSERT INTO teeNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Pus ju acsnich ju yu'unch talaclajunilh ixlhi'akstu'an: ―Ni canaju ni Dios xamalakachayachilh pus ju yuchi laich aquintajunan tajuch ni jantu xalaca'iniyau. ");
INSERT INTO teeNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Chai vana jantu lai catinaju ni ixt'alapanac ju xamalakachayachilh amakpaxana'. Chunch ixtalaclajuni ni na ixtatalhoni ju lapanacni. Ju lapanacni si ixtanonk'ojui ni slivasalh ni ixnajun ixchivinti Dios ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Pus ta'ak'alhtayanalh chai tajunilh ju Jesús: ―Jantu icc'atsayau. Pus ju acsnich ju Jesús alack'alhtailh. Alacjuni: ―Nin quit'in jantu actilajuniu tichi chavaich ju xaquijuni ni acnaviya' junima taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ju acsnich ju Jesús tsuculh ajunini' ju lapanacni ju chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. Alacjuni: ―Pumatam lapanac chakxch'anlh ju xaq'uiu uvas la'ixlacat'un. Coralhnu lacak'ex. Pok'aj'ula junta catamaxtuya' ju xaxcan uvas. Yaulh ju chaka' ju na putank'ai ni laich capulhistaccalh ju ixpu'uvas. Chai acsni navik'o pus amach'ixtaknilh ixpu'uvas ju lapanacni ju makch'alhcatnin. Chai ju amat'un alh makat. ");
INSERT INTO teeNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Chai acsni cha'alh ju avilhchan ni chalh ju uvas pus ju amat'un malakachanilh pumatam ixlapanac ju anu' makch'alhcatnin ni ca'alh amaklhtayana' ju xalhi'ut tachi ju ix'alhit'atak'oxitach. ");
INSERT INTO teeNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Para ju anuch makch'alhcatnin tach'apalh ju ixlapanac ju amat'un. Talak'anekma. Talhixcavats'ala chai va chunch tamalakachachokolh. ");
INSERT INTO teeNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Pus ju amat'un amalakachanichokolh apumatam ixlapanac. Para ju anu' lapanacni va talacat'alhma. Tamac'atsani la'is'aktsulh. Chai tanavi tachi ju jantu chun. ");
INSERT INTO teeNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pus ju amat'un aktam amalakachanichokolh apumatam. Chai ju yuchi tamakni. Ju astan na lhu amalakachanicalh. Ju ali' tamac'atsani. Ju ali' talamakni. ");
INSERT INTO teeNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Pus ixti'alin pumatam ju ixt'avi ju anu' amat'un. Yuchi ju ists'alh ju na ixmapaini. Pus malakacha ju yuchi vachu' ju sa'astan. Ixnajun: “Catatalhoniya' ju quints'alh”. ");
INSERT INTO teeNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Para ju anuch makch'alhcatnin talaclajunich sia yu'unch: “Yuchi ju ani ju amanavin cajuna' acsni caniya' ju ixpai. Asok'ot'itch. Camakniuch. Ju chunch ju ani lacat'un ju xtakniputuncan ju yuchi qui'anuch'an cajuna'”. ");
INSERT INTO teeNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Pus lana tach'apalh. Tamaknilh. Chai tatantamacxtunilh ixlacatuna lacapu'uvas. ");
INSERT INTO teeNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Pus tas canaviyach ju chavai ju amanavin pu'uvas. Pus caminach is'akstu ju yuchi chai camaknik'oya' ju ixchux'an ju ixtach'alhcatnan ju anch. Chai ali'in ju ca'amach'ixtakniya' ju ixpu'uvas. ");
INSERT INTO teeNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ja va jantu tavanan lakts'int'at'it ixchivinti Dios ju ts'okcanta junta ma chani najun: Ju chiux ju tasacmack'alh ju ixyonin chaka' yuchach ju valhch ju chiux ju mak'astumuc'acanta chaka' junta ts'okcanta tuchi c'ata ju yocanta. ");
INSERT INTO teeNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yuchi ju Dios ju navilh ju ani. Chai acsni iclakts'inau pus na k'ai lhamak'an iclhiulayau. ");
INSERT INTO teeNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pus ju acsnich ju ixtat'ajun k'asmatnin ju ixchivinti ju Jesús na ixtach'apaputun ni ixtamachakxai ni yu'unch ju ix'alhichivinin ju Jesús acsni xanajun ju anu' chivinti ixlacata ju pu'uvas. Para akts'iya va ixtatalhoni ju ixtalhavat lapanacni. Pus tamacaulh. Ta'alh. ");
INSERT INTO teeNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ju astan amalakachacalh ju ali'in fariseonin chai ju ali'in ju ixtach'ak'ok'ai ju gobernador Herodes. Pus ju yu'unch talakmilh ju Jesús para va ixtapuxcolakxtuniputun ju tu'u' chivinti ju laich catalhimuc'anilh ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Pus talak'alh chai tajunich: ―Amamaka'unu' icc'atsayau ni na'un ju stavasalanti ju uxint'i. Chai jantu xamati' ju t'alhoni ni vaklhtam chun ju alakts'in ju lapanacni. Chai ju uxint'i akts'iya sok masui ju ixti ju Dios. Pus ja lhijun ni ac'amapalanau la'ixmacni ju xa'ucxtin ju romanonin u jantu. ");
INSERT INTO teeNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Para ju Jesús ixmachakxani ni va ixta'acxput'iyunun ju yu'unch chai alacjuni: ―Tajuch ni va quilapuxconiputunau ju quintalak'alhin. Aquilalhiminiuch ju tumin ju lhi'amap'alananat'it ni aclakts'inach. ");
INSERT INTO teeNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Pus ju yu'unch talhiminilh ju tumin. Chai ju Jesús acsni lakts'ilh alacjunich: ―Tis ix'ucxpu' ju ani okslai. Tis ixtapaka'ut ju ts'okcanta ju ani. Pus ju yu'unch tajuni ni ix'anu' ju César ix'ucxtin'an ju romanonin. ");
INSERT INTO teeNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Chai alack'alhtailh ju Jesús. Alacjuni: ―Pus axt'aknit'it ju César ju ix'anuch. Chai axt'aknit'it ju Dios ju ix'anuch. Pus ju lapanacni acsni tak'asmatlh tachi ju lhik'alhtayanalh ju Jesús na talhamak'aninilh ni na k'ox xanajun. ");
INSERT INTO teeNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Pus ju saduceonin ixtanajun ni jantu lai lok'onchokocan acsni va nicanch. Pus ju ali'in sia yu'unch talakmilh ju Jesús chai tajuni: ");
INSERT INTO teeNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Amamaka'unu' ju mak'aniya ixlapanac Dios ju Moisés ixjuncan chani quinta'ats'oknunilh: “Ju tam lapanac ni canilh chai ma camacontilalh ix'amachaka' para ma jantu tu'u' cat'amacontilalh is'ask'at'a pus ju isp'isek'e ma calhitsucuchokolh ju ix'amachakach ixjunita ju xani ni laich ca'alilh ju ists'alh. Chai ju anu' ts'alh ma casacnilh ju ixtapaka'ut ju lijunto ixlak'au”. ");
INSERT INTO teeNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Pus ix'alin pumatujun lhi'alak'avin. Chai ju xak'ai tamak'axtoklh. Chai acsni nilh jantu tu'u' macontilalh ju is'ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Pus ju ixlhipumat'uich lhi'alak'avin t'atsucuchokolh ju ix'amachakach ixjunita ju lijunto ixlak'au. Chai astan nipa ju yuchi sin tu'u' camacontilalh ju is'ask'at'a. Chai ju ixlhipumat'utu lhi'alak'avin vana va chun tapasapa. ");
INSERT INTO teeNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Pus ju anu' chako'ulh t'atsucuk'o ju ixpumatujun'an lhi'alak'avin chai pumatam pumatam tani. Para jantu xamati' macontilanilh is'ask'at'a. Chai acsni ixtanik'ota ju yu'unch pus astan vachu' nilh ju anu' chako'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Pus acsni cata'acxtuchokoya' ju tanita tis ix'amachaka' cajuna' ni ixpumatujun'an at'atsucuk'o ju anu' chako'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Pus ju acsnich ju Jesús ak'alhtailh. Alacjuni: ―Ju uxijnan jantu sok alacp'ast'acnanat'it ni jantu mach'akxayat'it ni na lacalhu ju ts'okcanta la'ixchivinti Dios junta najun ni catalok'onchokoya' ju tanita. Vachu' jantu misp'ayat'it tuchi lai navi ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Pus acsni cata'acxtuchokoya' ju tanita jantu catamak'axtokcana' nin cala'icalh. Va ixt'achunchach catatsucuya' tachi ju anquilhnin ju tavilanancha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Chai ni va asacmininat'it ni lai cata'acxtuchokoya' ju tanita u jantu pus ja lana jantu lakts'int'at'it junta ts'oklh ju Moisés junta najun ni lakts'ilh ju ach'itin ju ixmaktajita. Chai ni lak'alh pus ju Dios xak'ala chai juni ni isDios'an junita ju Abraham chai ju Isaac chai ju Jacob. ");
INSERT INTO teeNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Pus ju Dios ni isDios junita ju lapanacni ju tat'ajun pus nomputun ni tat'ajun ju anuch lapanacni mas noncan ni mak'anch tanita. Pus ju uxijnan na lhu mak'ats'ank'ayat'it ju mi'atalacpast'ac'at'an. ");
INSERT INTO teeNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chai pumatam ju na ixlhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin vachu' lakmilh ju Jesús. Ju yuchi isk'asmatach tachi ju ixtajuni ju Jesús ju saduceonin. Chai ju yuchi machakxa ni na k'oxich ju xalhak'alhtayanan ju Jesús. Pus vachu' sacmilh ju Jesús. Junich: ―Tachi chun ju ixlhamap'aksin ju Moisés tasmalhch ju palai tasq'uini ni canavicalh. ");
INSERT INTO teeNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Pus ju Jesús k'alhtailh. Junich: ―Ju lhamap'aksin ju palai tasq'uini ni anavit'i yuchi ju ani: “Ak'asmat'it ji israelitanin. Ju mi'ucxtin'an Dios va pumatam. ");
INSERT INTO teeNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Pus amap'ainit'it ju mi'ucxtin'an Dios la'ixlhichux mi'alhunut'an chai la'ixlhichux mi'atsucunti'an chai la'ixlhichux mintac'atsan'an. Amap'ainit'it istavasalanti”. Yuchach ju ani ju lhamap'aksin ju palai tasq'uini ni anavit'i. ");
INSERT INTO teeNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Chai ju ixlhilakat'ui va ixt'achunch junita. Ju yuchi najun ni amap'ainit'i ju vanin alact'avilht'i tachi ju va jun mi'akstu ju map'ainich'ok'oc'an. Mati' alakatam lhamap'aksin ju va palai tasq'uini ni anavit'i. ");
INSERT INTO teeNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Pus ju acsnich ju anu' lapanac ju na ixlhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin junilh ju Jesús: ―Vasalh ji amamaka'unu'. Stavasalanti tachi ju na'un ni va pumatam ju Dios. Mati' ak'antam. ");
INSERT INTO teeNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Chai vasalh tasq'uini ni acmapaini ju Dios la'ixlhichux ju qui'alhunut chai la'ixlhichux ju quintac'atsan chai la'ixlhichux ju qui'atsucunti. Acmapaini istavasalanti. Chai tasq'uini ni acmapaini ju vanin quint'avi tachi ju va jun qui'akstu ju icmapainichokocan. Vasalh palai lhitapalai ni acnavi chux ju ani. Palai jantu ni va tu'uch acmakninilh ju Dios u ni acxavanilh ju Dios tu'u' lhak'ailakts'inti. ");
INSERT INTO teeNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Pus ju Jesús acsni k'asmatlh ni akts'iya na k'ox ju xalhik'alhtaji ju anu' lapanac pus junich: ―Ju uxint'i vasalh mach'akxai tuchi lacasq'uin ju Dios. Ju chavai va yuchi ju c'acxniyan ni alak'a'it'i ni calhinonk'o ju Dios lami'atsucunti. Pus ju acsnich tachi chun ju lapanacni na ixtatalhoni ju Jesús. Jantu ixtaquilhasacmiputun tu'u' ali'. ");
INSERT INTO teeNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ju Jesús ix'alacmasuni ju lapanacni ju lacak'ai ixpujitat'an ju ist'a'israelitanin. Chai ajuni: ―Ju na talhatalanininta ju milhamap'aksin'an tas laich talhinajun ni ists'alh David ju Cristo ju ixnoncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tas laich tanajun ju chunch ni mapast'ac'ani ju Spiritu Santu ni chani canaulh ju David: Ju ucxtin Dios junilh ju qui'ucxtin: “Vanin at'a'ulh junta icvi tus acsni act'alalhajaya' ju mint'alaxcai”. ");
INSERT INTO teeNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Pus ni is'akstu ju naulh ju David ni ix'ucxtin junita pus ju chunch va nomputun ni jantu va ists'alh junita. Pus ixtalhavat lapanacni va lhik'ach ixtak'asmatni ju ixchivinti ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Chai ju Jesús chani alacjuni ju lapanacni acsni ix'amalaninin: ―Jantu alac'a'inik'ot'it tuchi tanajun ju yu'unch ju na talhatalanininta ju milhamap'aksin'an. Ju yu'unch na tapu'alhtanamputun lacalhman ixpumpu'an ni xalack'ajinch tatalacasuputun. Chai na k'oxich talhiulai acsni tamac'ami ju lapanacni ju laclhitamau junta chux catak'asmat'a'. ");
INSERT INTO teeNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Chai na tatolhputun junta tatolai ju xalack'ajin ju lacpujitat chai lacapuvai. ");
INSERT INTO teeNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Va tatai'ini ixlacchaka'an ju chakolun ju va animacontilacanta. Chai ni va talacasuputun tachi ju na va soknic'a ju is'atsucunti'an pus talapalai tachi ju na panicni ju tat'achivinin ju Dios. Pus ni chunch ju talai palai camamak'alhk'ajnicana' ju yu'unch. Palai jantu ju ali'in lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ju aktam ju Jesús ixvi la'ixpujitat'an ju ist'a'israelitanin. Anch ixvi la'ix'ucxlacapu' ju lacat'icst'i p'aklat junta ixtamujui ju tumin ju ixtalhak'ailakts'in ju Dios ju lapanacni. Pus ju yuchi ix'alakts'in ju lapanacni acsni ixtamujui ju ixtumin'an ju lacap'aklat. Pus na lhu mak'alinin na laklhu ixtamujui. ");
INSERT INTO teeNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Chai milh pumatam chako'ulh ju va ixnimacontilacanta. Na quilhpatini' ixjunita. Pus ju yuchi muju lakat'ui lact'icst'i tumin ju lana jantu laklhu ixtapalh ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Pus ju acsnich ju Jesús alact'asanilh ju ix'amamaka'ui chai alacjuni: ―Slivasalh ju iclajunau. Na k'ox xalhiulai ju Dios ju tuchi xamujui ju ani ya chako'ulh ju va nimacontilacanta chai ju na quilhpatini'. Palai jantu chun ju ali'in ju tamujui ju ixtumin'an ju lacap'aklat. ");
INSERT INTO teeNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ju yu'unch va tamujui ju va xatanxajni ixtumin'an. Para ju ani quilhpatini' muk'o tachi chun ju ixpacxanta. Chux ju ca'ixlhitama'uta ju ixvaiti. ");
INSERT INTO teeNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ju Jesús taxtulh ju lacak'ai ixpujitat'an ju ist'a'israelitanin. Chai pumatam ix'amamaka'ui junich: ―Qui'amamaka'unu' alakts'ich ju ani chiux ni na lacc'us chai ju lacchaka' ni na lack'ox. ");
INSERT INTO teeNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Para ak'alhtayanalh ju Jesús. Junich: ―Alakts'int'it ju ani lack'ai k'exichaka'. Pus camina' avilhchan acsni jantu tu'u' catila'ucxtavi ju chiux ju ixt'achiux. Chux lana calak'alhik'ocana'. ");
INSERT INTO teeNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Pus ju Jesús chai ju ix'amamaka'ui ta'alh ju akstijun junta ixch'ancanta ju xaq'uiu ju olivos juncan. Chai ju anch ixt'alalaca'anita lacak'ai ixpujitat'an ju israelitanin. Chai acsni tavi ju Jesús pus ju Pitalu' chai ju Jacobo chai ju Xivan chai ju Tilix va is'akstu'an taquilhasacmi. Tajuni: ");
INSERT INTO teeNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Aquilajuniuch. Tas vananch ju catapasaya' ju anu' taxtokni ju xaquilajunau. Tas acpuc'atsayau ni chinta ju avilhchan acsni cata'uctaxtuya' chux ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Pus ju Jesús alack'alhtailh. Ajuni: ―Alhist'acc'ant'it ni jantu xamati' cata'okxchok'on. ");
INSERT INTO teeNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Pus na lhu catamina' chai catanonach ni yu'unchach ju Cristo ju ixnoncan camalakachatachilh ju Dios. Chai na lhu cata'okxchok'oya'. ");
INSERT INTO teeNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Para acsni ak'asmat'a'it'it ni alin ju lhilucut chai ni cak'ostayachokochalh ali' lhilucut alacatam pus jantu at'alhanana'it'it. Akts'iya tasq'uini ni chunch ju catapasaya'. Para jantiyu' ju ixpu'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Pus ju amachak'an ju k'ai lak'achak'an cat'alasaya' ju amachak'an alakatam k'ai lak'achak'an. Chai ju lapanacni ju tach'ak'ok'ai tam k'ai ucxtin catat'alasaya' ju ixlapanacni ju apumatam k'ai ucxtin. Catataclha' ju lacat'un ju vaklhun. Chai ca'alina' ju k'ai chavan chai mak'alhk'ajnat. Pus ju ani va ixputai'ulacan ju mak'alhk'ajnat. ");
INSERT INTO teeNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Para ju uxijnan alhist'acc'ant'it mi'akstu'an ni alhip'inc'ana'it'it lacapu'ucxtin. Chai ju la'ixpujitat'an ju mint'a'israelitanin ak'ainekmac'ana'it'it. Chai alhip'inc'ana'it'it la'ix'ucxlacapu'an ju ucxtinin chai ju lacalack'ai ucxtinin va ixlacata ni quilalhilaca'anau ju quit'in. Pus ju chunch laich a'una'it'it ju yu'unch ju quilacata. ");
INSERT INTO teeNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Chai ni tuca' chin ju ix'aclanti ju lacamunutpa' pus tasq'uini ni p'ulhnan ca'alacjunk'ocana' chux ju lapanacni ta yu lai pu'ancan ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Chai acsni alhip'inc'ana'it'it junta mak'axt'akc'ana'it'it lacapu'ucxtin pus jantu alhamak'aninina'it'it tuch'i ju anona'it'it ni jantuca' ch'ip'inat'it. Nin yuchi ni ap'ast'act'it tuch'i anona'it'it. Para va tuchi cataxtakniyan ju Dios ju lami'alhunut'an ju acsnich pants'iquis pus yuchach ju anona'it'it. Chunch ju anona'it'it ni jantu uxijnan ju ach'ivina'it'it para is'akstu ju Spiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Chai ju lapanacni catalamak'axt'ak'a' va ixlaca'atalh ni axcaican ju quintalhilaca'anta quit'in. Pus ju lapanacni catamak'axt'ak'a' ju tam ixlak'au'an la'ix'aninti. Chai ju xalacpa'itni catamak'axt'ak'a' ju is'ask'at'an la'ix'aninti'an. Chai ju sa'ask'at'an catat'alasaya' ju ixpai'an chai ixnatich'an chai catalhinona' ixmaknica'an. ");
INSERT INTO teeNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pus chux ju lapanacni slivasalh catalhixcayan va ixlacata ni quilalhilaca'anau. Para ju aquilhilaksiya' tus la'ix'aclanti ju is'atsucunti yuchi ju catak'alhtaxtuya' chai laich ca'ana' ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ju mak'aniya lapanac ju Daniel ixjuncan ixnajun ixchivinti Dios. Chai ju yuchi ts'ok'ula junta naulh ni ma ca'alina' lamimpujitat'an ju tu'u' ju na lhits'isi ju Dios. Chai ixlhiyuchi jantu xamati' ju milhi'uxijnan catanuya' ju anch. Pus ju lakts'in ju ani chivinti chach machakxa tuchi ju nomputun. Chai acsni alakts'ina'it'it ni uctaxtulh ju anu' ju lhichivinilh ju Daniel pus tachi chun ju tavilanalh laxa'estado Judea chach ta'ats'alalh. Cata'alh ju lactalhpa. ");
INSERT INTO teeNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Chai ju ca'akstitavi lacasotea chaka' va ts'alhti catak'alhtaju chai ca'ats'alalh. Para jantu cati'alilh ispants'iquis ni lai catanu ju la'ixchaka' ni va ca'alh maxtunu' tu'u' ju ixtaxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Chai ju ch'alhcatnan la'ixcuxtu vachu' ca'ats'alalh. Chai jantu catasp'itchokolh la'ixchaka' ni va ca'alh ini' ju ixcutun. ");
INSERT INTO teeNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Paini'itnich ju yu'unch ju jantu lacak'ox chai ju va tat'ajun mats'iquinin is'ask'at'an ju acsnich avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","At'ap'aininit'it ju Dios ni jantu tasq'uini ni ats'alaya'it'it lacalhic'asnin. ");
INSERT INTO teeNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chunch alhisq'uinit'it ni na lhu catamak'alhk'ajnana' ju lapanacni ju acs avilhchan. Catamak'alhk'ajnana' tachi ju jantu tavanan mak'alhk'ajnancanta tus acsni tavanan navicantacha ju Dios ju lacamunutpa'. Chai jantu aktam chun catamak'alhk'ajnanchokoya' tavanan. ");
INSERT INTO teeNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Pus ju qui'ucxtin'an Dios ni jantu ca'ixnaulh ni palai va lacats'unin ca'ixnavi ju anuch avilhchan pus jantu xamati' ca'ixtak'alhtaxtulh. Ixtanik'ota. Para ni na amapaini ju lapanacni ju ix'alacsacxtuta pus yuchi va lacats'unin lhinavilh ju anu' avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Pus ju acsnich jantu xcai ni xamati' chani catajunan: “Alakts'ich. Ani ya ju Cristo ju ixnoncan camalakachatachilh ju Dios”. U chani catajunan: “Alakts'ich anu' ya”. Pus ni chunch ju catajunan xamati' jantu alac'a'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Pus ju acsnich ca'alina' ju lapanacni ju catanona' ni yu'unch ju Cristo ju ixnoncan camalakachatachilh ju Dios mas jantu. Chai ca'alina' ju lapanacni ju catanona' ju ta'aklhtamat chivinti. Para chunch catachivina' tachi ju vasalh tat'ajun nonin ju ixchivinti Dios. Chai na lhu catanaviya' ju taxtokni ju catapumavasalaputunach ni vasalh ixlapanacni Dios tajunita mas jantu. Chai catanaviya' ju lhamak'an ni va laich catapu'okxchok'olh ju lapanacni ju asacxtuta ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Para ju uxijnan alhist'acc'ant'it. Iclajuntauch chux ju ani mas tuca' tapasai ni laich ac'ats'aya'it'it ni chunch ju catapasaya'. Ju Jesús tailhi'alh ixchivinti chai ajuni ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","―Ju acsni avilhchan acsni catapasaya' ju anu' mak'alhk'ajnat pus cats'isa' ju avilhchan. Chai ju malhquiyu' jantu camapulhcuya'. ");
INSERT INTO teeNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Chai catapatajuya' ju st'acu. Chai tachi chun ju ani catataclha'. ");
INSERT INTO teeNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Pus ju acsnich ju lapanacni aquintalakts'inach ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Aquintalakts'inach acsni acminach laca'ataputs'i. Chai catac'atsaya' ni na alin ju quintachaput chai xak'ai icjunita. ");
INSERT INTO teeNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Chai ju acsnich acmalakachatachilh ju qui'anquilhnin. Chai ju yu'unch catamak'aixt'ok'ach ju lapanacni ju ic'asacxtuta. Chai ju anu' lapanacni cataminanta ju ixlhilacaputs'un ju lacamunutpa' mas palai makat cava ju ani lacat'un u ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Alakts'int'it tachi ju tak'ayai ju tu'u' xaq'uiu higo. Acsni catsucuya' xajchini' ju sast'i xaxk'oi pus p'uc'ats'ayat'it ni vaninch minta ju lacap'asni. ");
INSERT INTO teeNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Pus vana va chun ju ani. Acsni alakts'ina'it'it ni catapasaya' ju ani taxtokni pus ap'uc'ats'aya'it'it ni slivasalh jantu mak'an tic'acx tus ca'aclaya' ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Slivasalh ju iclajunau. Jantu catanik'oya' ju lapanacni ju chavai tat'ajun tus cata'aktsak'oya' tachi chun junima taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ju t'iyan chai ju lacat'un cats'ank'ak'oya'. Para ju quinchivinti akts'iya ca'uctaxtuya'. ");
INSERT INTO teeNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Para jantu xamati' c'atsai tis avilhchan chai tuchi hora ju acmina' ju quit'in. Nin yu'unch ju anquilhnin ju tavilanancha lact'iyan nin quit'in mas ists'alh Dios icjunita. Va is'akstu ju quimpai ju c'atsai. ");
INSERT INTO teeNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Pus sk'alalhch ats'uc'ut'it. Alhist'acc'ant'it. At'ach'ivinint'it ju Dios ni jantu c'ats'ayat'it tavananch ju acmina'. ");
INSERT INTO teeNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Pus ju acsnich chunch cajuna' tachi acsni an makat tam jok'at. Ni tuca' an pus ajuni ju ixlapanacni ni catalhistaclh ju ixchaka'. Chai pumatamin axtakni ixlhich'alhcat ju catanaviya'. Chai juncanch ju ixlhist'ac'a malhtich ni calhistaclich. ");
INSERT INTO teeNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Pus vana va chun ju uxijnan. Alhist'acc'ant'it ni vachu' jantu c'ats'ayat'it tavananch ju acmina' quit'in ju mi'ucxtin'an icjunita. U tok'oxai. U paitat ts'is. U acsni pakt'utu t'asata ju chila'. U acsni catuncuntilayach. ");
INSERT INTO teeNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jantu xcai ni va tam pants'iquis acmilh chai aclalhitajuyau ni tachi ju va lht'at'ayat'it lami'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ju tuchi iclajunau ju uxijnan ic'alacjuni tachi chun ju lapanacni. Alhist'acc'ant'it. ");
INSERT INTO teeNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pus va lakat'ui avilhchan ixc'acx tus ca'alina' ju c'atan ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. Chai vachu' acs ix'alin alakatam c'atan acsni ixta'ui ju xkapavati ju jantu ixtamaca'anita ju xat'in. Pus ju xalack'ajin palijni chai ju lapanacni ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin tapuxcaulh ta yu laich ca'ixtapu'okxchok'och'apalh la'ixchivinti ju Jesús ni laich catalhinona' ixmaknica. ");
INSERT INTO teeNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Para ixtanajun: ―Jantu cach'apayau acsni va alin ju c'atan ni na aktsamcanta ju acsnich. Va laich catatalhk'amalh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pus ju Jesús ixvilhcha lak'achak'an Betania la'ixchaka' ju Simón ju na ixpacxanta ists'its'i para palaich ixnavita ju Jesús. Chai acsni ixvi ju lacamixa pus milh pumatam chako'ulh ju ixlhiminta lakatam lumeti ju chiux ixlhinavicanta. Para na stac'ac'a ixjunita. Chai ju anu' chiux alabastro juncan. Pus ju anu' lumeti ixputajun ju tu'u' ju na saksi ix'acamin. Chai ju yuchi nardo ixjuncan chai na laklhu ixtapalh ixjunita. Pus ju anu' chako'ulh kekp'akxlh ju lumeti chai tsuculh lakxtixt'ek'emuc'ana' ju Jesús ju ixtajun. ");
INSERT INTO teeNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Pus ju ali'in ju ixtavilanalh ju anch talhitalhk'amalh. Chai talaclajunilh sia is'akstu'an: ―Tajuch ni va xalhak'amanan ju ani saksi acamin. ");
INSERT INTO teeNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ju yuchi jantu va lakat'utu cientos tumin ixtapalh junita. Ni ca'ist'acalh pus lai ca'ixtaknicalh ju quilhpatinin ju ixtapalh. Pus lana jantu k'ox xatalhiulai tuchi navilh ju anu' chako'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Para ju Jesús alacjuni: ―Amac'a'unt'it. Tajuch ni va lhixc'ayat'it. Na k'ox ju tuchi xaquinavinich. ");
INSERT INTO teeNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Akts'iya alin ju quilhpatinin junta vilat'it. Chai acsni alac'asq'uina'it'it laich anaviniya'it'it ju k'ox. Para ju quit'in jantu actilat'a'alhtanank'alhiu. ");
INSERT INTO teeNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ju ani ya chako'ulh navilh tachi ju lai xanavi. Mas tuca' icmacnucanta para ju yuchi acsni quilacamuc'alh ju c'uch'u pus tachi ju va jun quimuc'alh ixlacata qui'aninti ni chunch ju lhilanicantauch ni xamati' ta'acnui. ");
INSERT INTO teeNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Slivasalh ju iclajunau. Vanta anchach ju lacamunutpa' junta canoncana' ta yu lai tak'alhtaxtucan pus vachu' canoncana' tuchi ju xanavi ju ani ya chako'ulh. Ju chunch jantuch cacapcana' ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ju Judas Iscariote pumatam ixlhipumacaut'ui'an ixjunita. Pus ju acsnich ju yuchi alak'alh ju xalack'ajin palijni. Alh at'atak'oxini' ta yu laich capumak'axt'ak'a' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Chai ju yu'unch acsni tak'asmatlh ju ixchivinti ju Judas na talack'achalh. Tamach'anulh. Tajunilh ju Judas ni cataxtakniya' ju tumin. Pus ju Judas tus acsnich na ixpuxcajui ta yu laich capumak'axt'ak'a' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pus ju xap'ulhnan avilhchan ixjunita ju anu' c'atan acsni ixta'ui ju xkapavati ju jantu ixtamaca'anita ju xat'in chai acsni ixtamakni ixborrego'an ju ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. Pus ju acsnich ju ix'alacmamaka'ui ju Jesús tajunich: ―Tas anchach ju k'oxich lhiulai ju uxint'i ju ac'anau lak'oxinin junta laich ca'u ju borrego. ");
INSERT INTO teeNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Pus ju Jesús amalakachalh ixt'iyun'an ix'alacmamaka'ui. Chai alacjunich: ―Ap'inchit'it ju lak'achak'an. Chai ju anch ap'akxt'ok'a'it'it pumatam jok'at ju lhi'anta xcan lacaxalu. Pus at'aimalhip'ina'it'it ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Chai junta catanuya' ju yuchi pus vachu' at'anuya'it'it. Chai chani ju a'una'it'it ju amachaka': “Ju amamaka'unu' ma najun ni ta ma anchach ju alin ju cuarto junta lai cat'a'uya' ju borrego ju ix'alacmamaka'ui”. ");
INSERT INTO teeNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Chai ju anu' amachaka' catamasuniyanch ixlhitantalakt'ui junta k'aich ixchaka'. Ju anch lakasilak'oxinincantach. Pus anchach ju alak'oxiniya'it'it ju vaiti quilacatach'an quijnan'an. ");
INSERT INTO teeNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Pus ju ix'amamaka'ui ta'alh ju lak'achak'an chai vasalh talhitajulh tachi ju ix'ajuncantach. Chai anchach ju talak'oxinilh ju vaiti ixlacata ju c'atan. ");
INSERT INTO teeNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Chai acsni tok'oxa pus ju Jesús anch ju alact'a'alh ju ixpumacaut'ui'an ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Chai acsni tatavilh lacamixa chai tatsuculh venin pus ju Jesús alacjuni: ―Slivasalh ju iclajunau. Pumatam ju milhi'uxijnan ju quilat'avenau aquimak'axt'ak'a'. ");
INSERT INTO teeNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Pus ju acsnich ju yu'unch na ta'amak'aninilh. K'antam k'antam tajunich: ―Para ja quit'in. Chai apumatam ixnajun: ―Para ja quit'in. ");
INSERT INTO teeNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Chai ju Jesús alack'alhtailh. Alacjunich: ―Yuchi ju pumatam ju sia uxijnan ju mimpumacaut'ui'an ju lakputam quint'atamajk'oi laquinc'a'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Slivasalh ni ac'ana' laqui'aninti tachi ju iclhits'okcanta. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. Para painich ju anu' lapanac ju aquimak'axt'ak'a'. Palai k'ox ixva ni jantu tavanan istsuculh ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Chai acsni ixtat'ajun venin pus ju Jesús ch'apalh ju xkapavati. Xtaknilh lhak'ailakts'iuch ju Dios. Acsnica' ju ch'ek'elh. Alacxtaknilh ju ix'amamaka'ui chai alacjunich: ―A'ut'itch. Ju ani quilacatuna junita. ");
INSERT INTO teeNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Vachu' xakatailh ju tasa ju ixputajun ju vino. Xtaknilh lhak'ailakts'iuch ju Dios chai axtaknilh ju ix'amamaka'ui. Chai ju yu'unch tak'otk'o ixchux'an. ");
INSERT INTO teeNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ju acsnich ju Jesús alacjunich: ―Ju yuchi qui'ac'alhni. Chai acsni cataxtuya' ju yuchi pus camavasalaya' ju sast'i chivinti ju ca'alaclhit'atak'oxiya' ju Dios ju lapanacni ni laich ca'amac'acxaniya' ix'alactu'unti'an lhu lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Slivasalh ju iclajunau. Jantuch tavanan actik'otchokolh ju vino tus acsnich avilhchan acsni ack'ot'ach ju sast'i vino junta lhinonacha ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Pus acsni talak'aya ju Dios lacamilhpat pus tataxtulh ju lacachaka'. Ta'alh ju anu' akstijun junta ch'ancanta ju xaq'uiu olivos. ");
INSERT INTO teeNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Chai acsni tacha'alh ju anch pus ju Jesús alacjunich: ―Minchux'an aquilamacoyok'oyau ju chavai atats'isni. Icc'atsai ni chunch ju alaya'it'it ni chani najun ju Dios la'ixchivinti ju ts'okcanta: “Acmakniya' ju xa'alhistacna'. Chai ju ixborregojni catata'akpitsiya'”. Chunch ma naulh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Para ju astanch acsni acta'acxtuchokoya' junta acmacnucana' pus acp'ulh'ana' ju xa'estado Galilea. Astan ach'ip'ina'it'it ju anch ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pus ju acsnich ju Pitalu' junilh: ―Mas cata'ats'alhk'o ju ali'in para ju quit'in jantu tavanan actimacoya'un. ");
INSERT INTO teeNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Para ju Jesús junilh ju Pitalu': ―Slivasalh ju icjunan. Ju chavai atats'isni acsni tuca' t'asai pakt'ui ju chila' ju uxint'i pakt'utu na'unt'a ni jantu q'uimisp'ai. ");
INSERT INTO teeNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Para ju Pitalu' na p'as ixnajun ni jantu tavanan catinaulh ni jantu mispai mas tus cat'amaknicalh. Chai si chun ixtanajun ju ali'in ix'alacmamaka'ui ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Pus ju astan ju Jesús chai ju ix'alacmamaka'ui tacha'alh junta ixjuncan Getsemaní. Chai acsni tacha'alh ju anch pus ju Jesús alacjuni ju ix'alacmamaka'ui: ―Anich at'olat'itca' pants'iquis. Chactiquit'achivini' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pus ju Jesús alack'ailhi'alh ju Pitalu' chai ju Jacobo chai ju Xivan. Ta'alh palai avinti lacats'unin chai ju Jesús na talhanalh. Chai tsuculh amak'aninin. ");
INSERT INTO teeNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Chai alacjunich: ―Slivasalh na ic'amak'aninin. Tachi ju va aquimakniya' ju qui'amak'anit. Aquilapacxauch ju ani. Jantu alht'at'at'it. ");
INSERT INTO teeNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ju acsnich ju Jesús palai makat alh lacats'unin chai ta'aktsokotavi chai taquilhputalh ju lacat'un. T'achivinilh ju Dios. Sq'uinilh ni va laich cava jantu vana canaulh ju ixpai ni tasq'uini ni camaknicalh tachi ju akts'iya ilhcata. ");
INSERT INTO teeNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Chanich ju juni: ―Quimpai ju uxint'i lai navik'o'ui tachi chun ju taxtokni. Aq'uimak'osunin ju ani mak'alhk'ajnat ju slivasalh na ts'inq'ui. Para jantu anavit'i tachi ju iclacasq'uin ju quit'in. Va yuchi ju anavit'i tachi ju anona' ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Chai acsni tasp'itcha ju Jesús alaclhitajulh ju ixt'utun'an ni va ixtalhtatavilanalh. Chai ju yuchi junilh ju Pitalu': ―Simón ja va lht'at'aich. Ja lana jantu lai ixk'alhc'ujt'i va pants'iquis. ");
INSERT INTO teeNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ak'alhc'ujt'it. At'ach'ivinint'it ju Dios. Ju chunch jantu cata'okxchok'oyan ju lhacaticuru. Pus ju lami'alhunut'an vasalh navip'ut'unat'it ju k'ox. Para ju va lami'akstu'an jantu lai naviyat'it. ");
INSERT INTO teeNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Pus aktam anchokopa ju Jesús t'achivini' ju Dios. Chai vana va chun ju nonchokopa. ");
INSERT INTO teeNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Chai acsni tasp'itcha aktam alaclhitajuchokopa ixpumat'utu'an ix'alacmamaka'ui ni aktam ixtalhtatananchokopalai. Pus na ts'inq'ui ixjunita ixlakchulh'an ni na ixtalaclhtataputun. Chai ju yu'unch jantu ixtac'atsai tuchi lai catajunilh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pus ampa t'achivini' ju Dios chai acsni minchokolh ixlhipakt'utuch pus alacjunich: ―Ja lana va alht'at'ak'alhiya'it'it chai ast'acnank'alhiya'it'it. K'oxich ju chavai. Chilh ju hora acsni acmak'axtakcanach la'ixmaca'an ju alactu'unin. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ak'ost'olat'it. Ca'auch apakxtoknin. Va anich minta ju aquimak'axt'ak'ach. ");
INSERT INTO teeNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Pus lana chincha ju Judas acsni ixt'ajunca' chivini' ju Jesús. Yuchi ju Judas ju ixlhipumacaut'ui ixjunita ix'alacmamaka'ui. Ju yuchi ix'ak'ailhiminta lhu ju lapanacni. Ixlapanacnich ixtajunita ju xalack'ajin palijni chai ju papanin chai ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Ju ali'in ixtalhiminta ju ixmachita'an chai ali'in ixtalhiminta ju tu'u' q'uiu. ");
INSERT INTO teeNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Pus ju anu' ju camak'axtaknanach ix'alaclhijunitach ju ixtalhavat lapanacni ta yu capumak'axt'ak'ach. Chani ix'alacjunita: ―Ju acmacch'uch'uya' yuchach. Ach'ap'aya'it'it. Alhip'ina'it'it. K'ox alhist'ac'a'it'it. ");
INSERT INTO teeNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Pus acsni cha'alh ju Judas lana lak'alh junta ixya ju Jesús. Junich: ―Amamaka'unu'. Chai lana macch'uch'ulh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Pus lana soko tach'apalh ju ali'in. Tach'in tanavi. ");
INSERT INTO teeNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Para ju pumatam ju ixt'avi ju Jesús lana soko maxtulh ixmachita. Chai ulanilh ixlapanac ju xak'ai pali. Lana chakxp'uxnilh ju ix'ak'axk'olh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Pus ju Jesús alacjuni ju ixtalhavat lapanacni: ―Tajuch ni va quilanaviyau tachi ju tam ak'alhona' ju ch'ap'ap'ut'unat'it ni va lhit'ant'at'it ju mimachita'an chai ju q'uiu. ");
INSERT INTO teeNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Chux avilhchan xaclat'atanuyau lacak'ai mimpujitat'an ju uxijnan. Chai xaclamalaniyau. Para jantu xaquilach'apayauch ju acsnich. Para chunchach ju t'ajun tapasana' ni ca'uctaxtuya' tachi chun ju ts'okcanta la'ixchivinti Dios ju quilacata. ");
INSERT INTO teeNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ju acsnich tachi chun ju ix'alacmamaka'ui ju Jesús tamacoyaulh. Ta'ats'alhk'o ixchux'an. ");
INSERT INTO teeNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Chai pumatam ts'alh ixch'ak'ok'ai ju Jesús. Chai ju yuchi va ixmacajucalh lakatam k'ai pumpu'. Va yuchach ju ixlakch'ita. Pus ju ixtalhavat lapanacni tach'apalh vachu' ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Para ju yuchi macontilalh ju k'ai ixpumpu'. Va k'ai tsasau ats'ala'alh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Pus ixtalhavat lapanacni talhi'alh ju Jesús la'ixchaka' ju xak'ai pali. Chai ju anch talhitak'aixtoklh chux ju xalack'ajin palijni chai ju papaninch chai ju na ixtalhatalanininta ju ixlhamap'aksin ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pus ju Pitalu' va ixlhimakat ixch'ak'ok'ata ju Jesús tus tanu vachu' pulacni ta ixlakachak'axnucanta ju ixchaka' ju xak'ai pali. Chai ju anch alact'atavi ju pulasiyajni. Ju yu'unch ixtalacsk'onvilanalh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pus ju xalack'ajinch palijni chai ixchux'an ju ucxtinin ixtapuxconich tichi chavaich ju lai catanaulh tu'u' ta'aklhtamat chivinti ni laich catalhinaulh ixmaknica ju Jesús. Para jantu tavanan talhitajunilh tu'u' talak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Na lhu lapanacni ixtanajun ta'aklhtamat chivinti ixlacata ju Jesús. Para jantu va lakatam ixtanavi ixchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ju ali'in lapanacni tataya. Tanaulh ta'aklhtamat chivinti ixlacata ju yuchi. Ixtanajun: ");
INSERT INTO teeNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Ju quijnan ick'asmatnitau acsni naulh ni ma calaclhmoka' ju k'ai pujitat ju yocanta la'ixmaca' lapanacni. Chai ixlhilakat'utu avilhchan ma cayochokoya' alakatam. Para ma jantu lapanacni ju catayoya'. ");
INSERT INTO teeNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Para nin chunch jantu lai va lakatam ixtanavi ixchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pus ju acsnich ju xak'ai pali taya la'ix'ucxlacapu'an ixtalhavat lapanacni. Sacmilh ju Jesús. Junich: ―Ja jantu tu'u' ak'alht'ayanana'. Tijuch ju talhichivimak'anan ju ani tayanalh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Para ju Jesús va sek taya. Jantu tu'u' xa'ak'alhtayanan. Chai ju xak'ai pali aktam sacmichokopa. Junich: ―Ja uxint'i ju Cristo'at ju ixnoncan camalakachatachilh ju Dios. Ja ists'alh'at ju Dios ju lak'ayacan. ");
INSERT INTO teeNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Chai ju acsnich ju Jesús ak'alhtayanalh: ―Quit'inch. Chai astan aquilalakts'inau acsni actola' vanin junta vi ju Dios ju na tachapun. Chai aquilalakts'inau acsni acmina' laxa'ataputs'i ju lact'iyan. Quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pus ju acsnich ju xak'ai pali lana lht'it k'exlh ju ixpumpu' ju va ixtalhk'amtich. Chai naulh: ―Tis ali' chivinti maktasq'uiniyau. ");
INSERT INTO teeNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","K'asmat'at'it ju macxcai chivinti ju xanajun ni tachi ju Dios ju jumputun. Tas nonat'it ju chavai. Pus ju yu'unch ts'an tanonk'o ni lhijunch ni camaknicalh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Pus ju acsnich ju ali'in tatsuculh lakpuchujvanin ju Jesús. Talakpuch'ilh chai ta'ulanilh chai tajunich: ―Anauch tichi chavaich ju xa'ulaniyan. Chai astan ju pulasiyajni taquincatisamalh. ");
INSERT INTO teeNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pus ju Pitalu' makspa' ixvi la'ixpulacni k'ex. Chai xajchilh pumatam isquiti' ju xak'ai pali. ");
INSERT INTO teeNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Chai acsni lakts'ilh ju Pitalu' junta ismaksk'onvi skotutu. Junich: ―Ju uxint'i vachu' ixt'a'ucxunt'a'un ju Jesús amachaka' Nazaret. ");
INSERT INTO teeNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Para ju Pitalu' junilh: ―Jantu icmispai chai jantu icmachakxai tuch'i q'ui'ump'ut'un. Chai lana taxtulh ju Pitalu'. Talacxtutaya. Chai lana t'asalh ju puyux. ");
INSERT INTO teeNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Pus ju anuch squiti' ni lakts'inchokopa aktam ju Pitalu' pus alacjunchokopa ju anuch ixtavilanalh: ―Ju ani vachu' makyuchi. ");
INSERT INTO teeNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Para aktam nonchokopa ju Pitalu' ni jantu slivasalh. Chai ni pants'iquis jumpa pus yu'unch ju ixtavilanalh tajunchokopa ju Pitalu': ―Slivasalh ni vachu' makyuch'at ni vachu' amachaka'at Galilea ni vachuch chun ju ch'ivinin tachi ju tachivinin ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Para ju Pitalu' naulh: ―Chach quimamak'alhk'ajni ju Dios ni jantu slivasalh ju tuchi iclajunau. Dios c'atsai ni jantu icmispai ju anu' lapanac tichi lhasacmininat'it. ");
INSERT INTO teeNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Chai ju puyux lana t'asalh ixlhipakt'uich. Chai ju Pitalu' lana pastaclh ju ixchivinti ju Jesús ju ixjunita acsni junich ni pakt'utu canona' ni jantu mispai acsni tuca' pakt'ui t'asata ju puyux. Pus ju Pitalu' acsni pastaclh ju chunch lana tsuculh k'alhunu'. ");
INSERT INTO teeNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Acsni tunculh talacchivinilh ju xalack'ajin palijni chai ju papanin chai ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin chai ju ali'in ix'ucxtinin ju israelitanin. Chai talhi'alh ju Jesús tach'in. Taquimak'axtaknilh ju ixgobernador'an ju romanonin. Yuchi ju Pilato ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Chai ju Pilato sacmilh ju Jesús. Junich: ―Ja vasalh uxint'i ju xa'ucxtin'at ju israelitanin. Chai ju Jesús ak'alhtayanalh. Junich: ―Chunch tachi ju na'un. ");
INSERT INTO teeNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pus ju xalack'ajin palijni na lhu talak'alhin tamuc'anilh ju Jesús para ju Jesús jantu tu'u' ak'alhtayanalh. ");
INSERT INTO teeNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Chai ju Pilato aktam sacmichokopa ju Jesús. Junich: ―Ja jantu tu'u' ak'alht'ayanana'. Na lhu talak'alhin tamuc'aniyan. ");
INSERT INTO teeNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Para ju Jesús jantu tavanan ak'alhtayanalh tu'u'. Chai ju Pilato na lhamak'aninilh ni jantu tu'u' xanajun ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Chux c'ata ju gobernador Pilato ix'amasmanita ju lapanacni ni ixmaxtui lacapulach'in pumatam tach'in ju acs c'atan. Ixmaxtui va tichi chavaich ju tasq'uinlich ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chai ju acsnich c'ata ix'alin pumatam tach'in ju ixjuncan Barrabás. Ju yuchi ix'alact'at'alhnucanta ju ixt'a'amakninin. Ju yu'unch ixtamaknita ju lapanacni acsni tat'alasalh ju k'ai ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Pus ju ixtalhavat lapanacni talak'alh ju Pilato. Tatsuculh tapaininin ni chunchach ca'anavinicalh tachi akchux ixtac'atanich. ");
INSERT INTO teeNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pus ju Pilato ix'anaviniputun ixk'achat'an ju yu'unch chai yuchi chani alaclhijunich ju israelitanin: ―Ja lac'asq'uinat'it ni acmacaulh ju ani ya mi'ucxtin'an ji israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ju Pilato yuchi chunch alaclhijuni ni ixmachakxai ni va ix'axcayantich'an ju ixtapumak'axtakta ju Jesús ju xalack'ajin palijni. ");
INSERT INTO teeNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Chai ju xalack'ajin palijni talacmalaca'inilh ixtalhavat lapanacni ni catasq'uinlh ni alai camacajuncalh ju Barrabás. ");
INSERT INTO teeNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pus ju acsnich ju Pilato ak'alhtayanalh chai alacjunchokopa ju israelitanin: ―Para tijuch ju lac'asq'uinat'it ju acnavi ju unat'it mi'ucxtin'an. ");
INSERT INTO teeNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Pus ju ixtalhavat lapanacni p'as tanaulh ni lacacurus camaquilhtacalh. ");
INSERT INTO teeNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Para ju Pilato alacjuni: ―Tajuch. Tis talak'alhin ju navita. Para ju ixtalhavat lapanacni palai p'as ixtalacnajun: ―Amaq'uilht'at'ich ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pus ju acsnich ju Pilato anavinilh ju ixk'achat'an ju lapanacni. Pus maxtulh lacapulach'in ju Barrabás. Chai lhinaulh ixlakanekmaca ju Jesús. Astan mak'axtaknilh ju taropajni ni camaquilhtacalh ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pus ju acsnich ju ixtaropajni ju Pilato talhi'alh ju Jesús ixpulacni junta lakachak'axnucanta lacapu'ucxtin. Chai acsni tacha'alh alact'asanik'ocalh chux ju ixt'ataropajni. ");
INSERT INTO teeNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Tamalakch'inilh ju Jesús smumu pumpu' tachi ixtalakch'i ju xalack'ajin. Chai tanavinilh ju corona si alhtucunu' chai tamalacpatanulh. ");
INSERT INTO teeNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Chai k'antam k'antam ixtamac'ami tachi ju mac'amican tam xak'ai. Na ixtamamaxani acsni ixtajuni: ―Ats'uc'uk'alhit'i ji ix'ucxtin ju israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Chai lacasnivenk'e q'uiu tatsuculh lakpanekmanin. Chai talakachujva ju Jesús. Chai tamalacasunilh tachi ju vasalh va ixtalak'ayaputun mas jantu. ");
INSERT INTO teeNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Chai acsni tamamaxanik'o pus tamaxtunilh ju smumu pumpu' chai tamalakch'inichokolh ju akts'iya ixpumpuch. Tamaxtulh ju anch. Talhi'alh junta catamaquilhtaya' ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pus ixt'ajun tapasana' pumatam lapanac ju Simón ixjuncan. Ju yuchi amachaka' Cirene ixjunita. Ixpai ju Alejandro chai Rufo. Ju yuchi va ixmintacha lacacuxtu. Pus ju taropajni tamakxk'ok'a ju Simón ju iscurus ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tak'ailhi'alh ju Jesús junta Gólgota ixjuncan. Ju anch va lhitapacutui chunch ni tachi ju va aktsulh istasui ju anu' talhpa. ");
INSERT INTO teeNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ixtamak'ot'uputun ju vino ju ixlhiya ju ach'itin ju mirra juncan ni va catalhimatontolanilh ju ixlacatuna. Para ju Jesús jantu k'otlh. ");
INSERT INTO teeNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Pus taxtucmuc'alh ju lacacurus. Chai ju taropajni talhilaslajlh ixpumpu' ju Jesús tamalhch ju calhi'ana' k'antam k'antam. Chunch ju talalhvakpitsilh ju ixpumpu' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Acsni tavanan tamaquilhta lacacurus ju Jesús pus lakanajatsi hora vats'isin ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Chai ta'ulanilh ju chivinti ju la'is'aktsulh iscurus ju Jesús junta naulh tuchi talak'alhin ixmuc'anicanta. Pus ju anu' chivinti chani naulh: “Ix'ucxtin'an ju israelitanin”. ");
INSERT INTO teeNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Chai tat'amaquilhta pumat'ui ak'alhonin. Ju pumatam la'ixlhicana ju Jesús ju taquilhta. Ju pumatam la'ixlhimacx. ");
INSERT INTO teeNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pus ni chunch ju ulhtucalh ju Jesús va uctaxtulh tachi ju ists'okcanta junta najun: “Ju yuchi mispacalh ni tachi ju vachu' va alactu'unu' ixjunita”. ");
INSERT INTO teeNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Chai tachi chun ju ixtatapasai ju anch ixtamamaxani ju Jesús. Ixtalhits'i'in chai ixtajunich: ―Ju uxint'i na'un ni lai lak'alhi ju k'ai pujitat chai ixlhilakat'utu avilhchan laich anavich'ok'oya'. ");
INSERT INTO teeNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Pus ni vasalh tachapun'at amak'alht'axt'uch'ok'oc'ach mi'akstu. At'ak'alht'a'ut'ich ju lacacurus. ―Chunch ju tajuni. ");
INSERT INTO teeNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chai vana va chun ixtamamaxani ju xalack'ajin palijni chai ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Ixtalajunich sia yu'unch: ―Ju yuchi lai ixmak'alhtaxtui ju ak'antam. Para ju va is'akstu jantu lai mak'alhtaxtuchokocan. ");
INSERT INTO teeNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ju yuchi ni vasalh Cristo junita ju noncan camalakachatachilh ju Dios chai ni vasalh ix'ucxtin'an ju israelitanin pus chach tak'alhtaju ju lacacurus ju chavai. Ju chunch aclakts'inau qui'akstu'an chai acsnich ju aclhilaca'anauch vachu'. Chunch ixtanajun sia is'akstu'an. Para va ixtalhits'i'in. Chai mas yu'unch ju ix'alact'ajucalh lacacurus ixtajuni macxcai chivinti. ");
INSERT INTO teeNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Acsni k'atunculh pus ts'islich ju ixlhilacaputs'un ju lacamunutpa' tus lakat'utu hora atok'oxana'. ");
INSERT INTO teeNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chai acsni cha'alh ju lakat'utu hora pus ju Jesús ts'au t'asalh. Naulh: ―Eloi, Eloi, lama sabactani. Ju chunch va nomputun: QuiDios. Tajuch ni va qui'akstu xaq'uimac'a'un. ");
INSERT INTO teeNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Chai tak'asmatlh ju ali'in ju ixtayanalh anch. Chai talaclajunilh: ―Ak'asmat'it. T'asani Elías ju mak'aniya ixlapanac Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Pus ats'alalh pumatam. Quik'avanilh ju tu'u' tachi k'ai pulhulh panimac laca tu'u' tachi ju axvicnit. Lhi'anilh la'ixquilhni ju Jesús lacalhman snivenk'a q'uiu. Va ixmak'ot'uputunch. Chai alacjuni ju ali'in lapanacni ju anch ixtayanalh: ―Capacxauch. Calakts'inauch ni va camilh ju Elías p'uxnu' ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pus ju acsnich ts'au t'asachokopa ju Jesús. Chai lana nilh. ");
INSERT INTO teeNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ju acsnich lana lht'it k'exlh la'ixlacaitat ju k'ai pumpu' ju ixyocanta lacpujitat ni pulact'ui ixpunavicanta. Tsuculh k'exni' ju talaclhman tus lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pus ju xacapitán taropajni ju ixya la'ix'ucxlacapu' ju Jesús lakts'ilh acsni t'asalh ju yuchi chai nilhch. Chai ju acsnich ju anu' capitán naulh: ―Ju ani lapanac slivasalh ists'alh Dios ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pus vachu' ixtayanalh ju anch ju chakolun. Va ixtalakts'inch ju Jesús ixlhimakat. Vachu' ixtamakyanalh ju Malia amachaka' Magdala chai ju Salomé chaich ju Malia ixnati'an ju José chai ju putant'icst'i Jacobo. ");
INSERT INTO teeNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ju anuch chakolun akts'iya ixtach'ak'ok'ata ju Jesús. Chai ixtalhich'alhcatnani acsni ixvilhcha ju xa'estado Galilea. Vachu' ixtamakyanalh ju ali'in na ilhu'an chakolun ju ixtat'aminta k'aixtam ju Jesús ju lak'achak'an Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ju acsnich va xavísperas c'atan ixjunita. Chai acsni tok'oxalh pus ju lapanacni talaklakasilack'oxilh ju ixvaiti'an ju cata'uya' ni catuncunchokoya' ni avilhchan pa'astacni cajuna' ju acsni. ");
INSERT INTO teeNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Chai acsni tats'isi pus ju José amachaka' Arimatea caplich ju ixtalhanti chai lak'alh ju Pilato chai sq'uinlh ju ixlacatuna ju lijunto Jesús. Pus ju José makyu'unch ixjunita ju xalack'ajin sia yu'unch ju israelitanin. Chai chux ju lapanacni ixtalhilaksi ju yuchi. Vachu' ixpacxan ju anu' avilhchan acsni calhinonk'oya' ju Dios ju ani lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pus ju Pilato va lhamak'aninilh ni laich vats'alhti canilh ju Jesús. Chai t'asanilh ju xacapitán chai sacmilh ni vasalh nita ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pus ju xacapitán ni naulh ni vasalh nita ju Jesús pus ju acsnich ju Pilato yau junilh ju José ni laich calhi'alh ixlacatuna ju lijunto. ");
INSERT INTO teeNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pus ju José tamaulh lakatam lhman pumpu' ju na k'ox ixjunita. Chai acsni p'uxcalh ju ixlacatuna ju Jesús pus pupach'icalh lacalhman pumpu'. Quimacnulh junta ixpulhucucucanta ju lactalhpa. Lhimalacch'aulh lacalakatam k'ai lhk'ajana chiux junta tamacnu. ");
INSERT INTO teeNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pus ju Malia amachaka' Magdala chai ju Malia ixnatich ju José talakts'ilh junta macnucalh ju lijunto Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Acsni tapasalh ju avilhchan pa'astacni pus ju Malia amachaka' Magdala chai ju Salomé chai ju Malia ixnati ju Jacobo tatamaulh ju tu'u' ach'itin ju na c'us acamin. Va ixtalacamuc'aputun ju ixlacatuna ju lijunto Jesús ni chunch ixtalhilanita. ");
INSERT INTO teeNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pus vats'isin ju lhitumincu acsni ixt'onachilh xajchini' ju avilhchan ju yu'unch tacha'alh junta ixmacnucanta ju lijunto Jesús. ");
INSERT INTO teeNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ixtalaclajuni ixlhi'akstu'an acsni ixtaminta ju lacati: ―Tis chavaich ju aquintamak'osunin ju k'ai chiux ju quicyocanta junta acnui ju lijunto. ");
INSERT INTO teeNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Para acsni talaca'alh talakts'ilh ju chiux ni mak'osucanta. Chai ju anu' chiux na k'ai ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Chai acsni tatanu junta ixmacnucanta ju ixlacatuna ju Jesús pus talakts'ilh pumatam ts'alh. Ju yuchi ixvi la'ixlhicana'an junta ixtayanalh ju chakolun. Chai ixmak'anch'ita lhman pumpu' ju na xnapapa ixjunita. Pus ju chakolun na tatalhonilh. ");
INSERT INTO teeNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Para ju yuchi alacjuni: ―Jantu at'alhanant'it. Ju uxijnan p'uxc'oyat'it ju Jesús amachaka' Nazaret ju maquilhtacalh lacacurus. Pus ta'acxtuchokolh. Jantu ani vi. Alakts'int'it junta ixmamacanta ju ixlacatuna. ");
INSERT INTO teeNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Pus a'inch'ok'ochit'it. A'una'it'it ju Pitalu' chai ju ali'in ix'alacmamaka'ui ju Jesús ni cap'ulh'anach ju Jesús ju laxa'estado Galilea. Astan ap'ina'it'it ju uxijnan chai anchach ju alakts'int'achit'it tachi ju xatajunan acsni tuca' ixmaknican. ");
INSERT INTO teeNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Pus ju yu'unch ta'ats'alataxtulh junta ixmacnucanta ixlacatuna ju Jesús acsni tuca' ixlok'onchokota. Na ixta'axq'uip'ip'itnintach ni na ixtatalhanan. Chai jantu tu'u' xatajuni xamati' ni va ixtatalhananch. ");
INSERT INTO teeNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Pus ju Jesús na vats'isin lhitumincu ju ta'acxtuchokolh junta ixmak'acanta. Pus talacasunilh p'ulhnan ju Malia amachaka' Magdala. Yuchi ju ixmaxtunicanta pumatujun lhacaticurulhni la'ixlacatuna. ");
INSERT INTO teeNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Chai ju yuchi alh amac'atsanini' ju ix'alact'a'ucxunt'ajun ju Jesús acsni tuca' ixmaknican. Pus ju yu'unch na va ixtalac'amak'aninin chai na ixtalack'alhuvilanalh. ");
INSERT INTO teeNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Para mas tak'asmatlh ni ta'acxtuchokolh ju Jesús chai t'ajun ju chavai chai ni ixlakts'intach ju yuchi ju Malia para jantu lai ixtalaca'i. ");
INSERT INTO teeNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ju astanch ju Jesús atalacasunilh ixt'iyun'an lapanacni acsni ixta'alhtana'anta ju lacati. Para jantu chun ju atalacasunilh ju yu'unch tachi ju talacasunilh ju Malia. ");
INSERT INTO teeNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pus ju yu'unch ta'anchokolh amac'atsaninin ju ali'in ixt'atamaka'ui ju Jesús. Para nin yu'unch jantu aquiclaca'icalh. ");
INSERT INTO teeNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Astan ju Jesús alactalacasunilh ixpumacautam'an acsni ixtat'ajun venin. Pus alhilak'ak'aima ni na p'as ixjunita ix'alhunut'an chai lana jantu lai ixtalhilaksita ju ixchivinti ju ix'ajunita acsni tuca' ixmaknicanta. Vachu' alhilak'ak'aima ni jantu tavanan ixtaquiclaca'ita ju yu'unch ju ixtalakts'inta ju Jesús acsni ixta'acxtuchokota junta ixmacnucanta. ");
INSERT INTO teeNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Vachu' alacjunich: ―Ap'inchit'it ixlhilacaputs'un ju lacamunutpa'. A'una'it'it chux ju lapanacni ta yu lai putak'alhtaxtucan ni jantu ancan ju lacajipi. ");
INSERT INTO teeNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ju calaca'iya' chai ca'akpaxach catak'alhtaxtuya'. Para ju jantu calaca'iya' camuc'anik'alhicana' ju ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Chai ju catalaca'iya' laich catanaviya' ju ani taxtokni ju capuc'atsacana' ni vasalh quilapanacni tajunita. Laquintapaka'ut cataxcomaxtuyach ju lhacaticuru la'ixlacatuna'an ju lapanacni. Chai catachivina' ju tumpa chivinti ju jantu aktam tachivininta. ");
INSERT INTO teeNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Chai ni cata'oksp'alalacach'apalh ju lu u ni catak'ot'a' ju taxtokni ju va lhinican jantu tu'u' catitapasaya'. Chai catamuc'aya' ixmaca'an la'ixlacatuna'an ju tak'ank'anin chai palaich catanaviya'. ");
INSERT INTO teeNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Astan acsni alact'achivink'o ju ix'alacmamaka'ui pus ju k'ai ix'ucxtin'an Jesús lana lhi'ancalh tus lact'iyan chai tavi vanin junta vi ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Pus ju ix'alacmamaka'ui ta'alh vanta anchach nonin ta yu laich putak'alhtaxtucan. Chai is'akstu ix'ucxtin'an Jesús ix'alact'ach'alhcatnan. Ju yuchi ixmavasalai ju chivinti ju ixtanajun ju ix'alacmamaka'ui. Ixpumavasalai lacak'ai lhamak'an ju ixtanavi ju ix'alacmamaka'ui. Chunch vasalh ixlai.");
INSERT INTO teeNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Na lhu lapanacni tats'ok'ulata tijtamin taxtokni ju c'atsacan ni vasalh tapasata junta t'onau ju quijnan'an ju lhilaca'antauch ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Chai ju yu'unch chai ju quit'in icts'ok'ulatauch tachi ju quintajunin ju yu'unch ju talakts'ilh tuchi tapasalh chai ju yu'unch ju tamasulh ju chivinti ixlacata ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Pus vachu' na k'ox iclhiula ju quit'in ni ac'ats'oknunin ju uxint'i ji xak'ai Teófilo chai sok acjunin ta yu xalhi'ucx'anch. Para p'ulan k'ox icmachakxa tachi chun ju taxtokni ju tapasalh tus la'ixputai'ulacan. ");
INSERT INTO teeNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ju chunch lai palai ap'umisp'aya' ni stavasalanti ju chivinti ju masunic'ant'a. ");
INSERT INTO teeNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Acsni gobernador ixjunita ju Herodes ju laxa'estado Judea pus ixt'ajun pumatam pali ju Zacarías ixjuncan. Ju yuchi makyu'unch ixjunita ju ixlapanacni ju Abías. Chai quilhmaktamin ju yu'unch ixtach'alhcatnan lacpujitat tachi ix'alhcanican. Chai ix'alin ju ix'amachaka' ju ixpapanti ixjunita ju p'ulhnan xak'ai pali ju Aarón ixjuncan. Chai ju yuchi Elisabet ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chai ixt'iyun'an na lack'oxin lapanacni ixtajunita la'ixmacni Dios. Si ixtaquiclaca'ik'ojui tachi ju najun la'ixlhamap'aksin chai la'ixchivinti Dios chai jantu xamati' lai ix'amuc'ani tu'u' ixtalak'alhin'an. ");
INSERT INTO teeNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Para mati' ixjunita ju is'ask'at'a'an ni va jantu lai ix'alin ju is'ask'at'a ju Elisabet chai ju acsnich na papanin ixtajunita. ");
INSERT INTO teeNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Para lakatam avilhchan acsni ixtach'alhcatnan ixlapanacni ju Abías junta ixlak'ayacan ju Dios pus vachu' ixch'alhcatnan ju Zacarías. ");
INSERT INTO teeNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chai tachi ju akts'iya ixtalhilanita ju ixlhipali'an pus istasacxtui pumatam pali ju catanuya' pulacni la'ixpujitat'an ju ist'a'israelitanin chai anch ju caxavayach ju pum. Pus ju acsnich avilhchan yuchi ju Zacarías ju isacxtucanta ni caxavayach ju pum. Pus ju yuchi tanulh la'ixpujitat'an. ");
INSERT INTO teeNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Chai acsni ixt'ajun xavana' ju pum ju Zacarías pus ixtalhavat'an lapanacni ixtat'ajun t'achivinin ju Dios makspa'. ");
INSERT INTO teeNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Pus talacasunilh ix'anquilh Dios ju Zacarías. Tayachilh la'ixlhicana ju mixa junta xavacan ju pum. ");
INSERT INTO teeNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Pus ju Zacarías acsni lakts'ilh ju anquilh lana na lhamak'aninilh chai na talhanalh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Para ju anquilh chani junilh: ―Jantu at'alhan ji Zacarías. Ju Dios k'asmatnin ju tuch'i sasq'uini chai ju mi'amachaka' camaklok'oniyan lakatam ists'alh chai alhimap'ak'a'uya'ich Xivan. ");
INSERT INTO teeNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Chai alhik'ach'ana'it'it chai na k'ox alhiulaya'it'it. Chai vachu' na lhu ju ali'in lapanacni catalhik'achana' acsni calok'ona'. ");
INSERT INTO teeNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Chai ju yuchi xak'ai cajuna' la'ixmacni Dios. Chai jantu cak'ot'a' ju vino nin tu'u' atumpa pinquin. Chai ju Spiritu Santu calhinonk'oya' la'is'atsucunti tus acsni camaklok'oncanach. ");
INSERT INTO teeNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Chai ju yuchi ca'amalhilaca'anichokoya' ju ix'ucxtin'an Dios na lhu ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Chai ju mints'alh cap'ulhniya' ju Dios ju astan catalacasuya'. Chai chunch cajuna' ju is'atsucunti chai ixtachaput tachi ju ixjunita ju mak'aniya ixlapanac Dios ju Elías ixjuncan. Chai ju yuchi tamch ca'amalaca'iniya' ix'alhunut'an ju xalacpa'itnich ni catamapainiya' ju is'ask'at'an'an. Chai ju israelitanin ju jantu lai talaca'ini ixchivinti Dios pus ju yuchi tamch ca'amalaca'iniya' ju ix'alhunut'an ni k'ox cajuna' ixtac'atsan'an tachi ju ixjunita ixtac'atsan'an ju mak'aniya lapanacni ju soknic'a ixtajunita. Chai ni chunch ju canaviya' ju mints'alh pus k'ox cajuna' ix'alhunut'an ju lapanacni chai cata'amaklhtayanana' ju Dios acsni tavanan camina'. ―Chunch ju junilh ju anquilh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Chai ju Zacarías chani ak'alhtayanalh. ―Tas acpuc'atsaya' ni vasalh chunch catapasaya' tachi ju xaq'ui'uni. Pus ju quit'in ni na icpapach chai ju qui'amachaka' na t'acuch. ");
INSERT INTO teeNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Chai ju anquilh ak'alhtayanalh. Junich: ―Ju quit'in icGabriel chai icnavini ixlhich'alhcat ju Dios. Chai yuchi ju quimalakachachilh ni act'achivininch chai acjunin ju ani k'ox chivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Para ju uxint'i anunulaya'. Jantu lai at'ich'ivin tus acsni jantu chin ju avilhchan acsni ca'uctaxtuya' ju ani taxtokni. Chunch a'una' ni va jantu xalac'a'i ju quinchivinti mas ca'uctaxtuya' ju tuchi xacjunan acsni cachina' ju avilhchan ju lhilhcata ju Dios. ―Chunch ju junilh ju anquilh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Pus ju ixtalhavat lapanacni ju ixtayanancha makspa' ixtapacxan ju Zacarías chai na ixtalhamak'anininch ni jantu sai ixtaxtui lacpujitat. ");
INSERT INTO teeNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Para acsni tavanan taxtulh ju Zacarías pus jantuch lai axak'ala ju lapanacni tachi ju akts'iya ixtalai ju palijni. Alai va atamacyonilh ni jantu lai lana ixchivinin. Pus ju lapanacni tapumachakxa ni ca va tu'u' xalakts'in ju lacpujitat. ");
INSERT INTO teeNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Pus acsni muctaxtuk'o tachi chun ju avilhchan ju ilhca'ulanicanta ni cach'alhcatnalh lacpujitat pus ju Zacarías anchokolh la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chai acsni tapasalh lakatam lakat'ui avilhchan pus ju Elisabet ju ix'amachaka' ixjunita ju Zacarías pacxalh ju is'ask'at'a. Chai ju yuchi tatank'anu la'ixchaka' lakaquis malhquiyu'. Va ixnajun: ");
INSERT INTO teeNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Chunchach ju xaquinavini ju Dios ju chavai avilhchan ni xaquilakts'in ta yu xacjunita. Va quimak'osunilh ju quimaxanti la'ix'ucxlacapu'an ju lapanacni ni jantu lai ix'alin ju qui'ask'at'a”. ―Chunch ju ixnajun ju Elisabet. ");
INSERT INTO teeNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Pus ju ixlhilakachaxan malhquiyu' ju Dios malakachachokopa ju anu' anquilh ju Gabriel juncan alakatam lak'achak'an junta Nazaret juncan. Ju yuchi anch vi ju xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Pus ju anquilh lak'alh pumatam atsi' ju Malia ixjuncan. Ju yuchi is'asq'uininti ixjunita pumatam ts'alh ju José ixjuncan. Chai ju yuchi mak'aniya ixpapanti ixjunita ju k'ai ucxtin David. ");
INSERT INTO teeNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Chai acsni tanucha ju anquilh junta ixvi ju Malia pus chanich xajuni: ―Xanchi. Slivasalh na k'ai lamapainin ju xanaviniyan ju Dios ju t'avilan. ―Chunch xajuni ju anquilh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Para ju Malia acsni lakts'ilh pus na lhamak'aninilh ju ixchivinti chai pastaclich tuchi canomputulh ju chunch amac'aminti. ");
INSERT INTO teeNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Pus ju acsnich ju anquilh chani juni: ―Jantu at'alhan ji Malia ni na k'ai lamapainin ju tanavinitan ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Pus ju uxint'i ap'acxana' ju mi'ask'at'a. Chai amaklok'ona' pumatam mints'alh. Chai alhimap'ak'a'uya'ich Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Chai ju yuchi xak'ai cajuna'. Chai calhimispacanach ni ists'alh Dios junita. Chai ju Dios caxtakniya' ju ixpu'ucxtin ixjunita ju mak'aniya k'ai ucxtin ju David ixjuncan. Caxtaknicana' ju mi'ask'at'a ni ixpapanti cajuna' ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Chai ju yuchi k'ai mi'ucxtin'an cajuna' ju uxijnan ju israelitanin unt'at'it. Jantu tavanan ca'aclaya' ju ixpu'ucxtin ju yuchi. ―Chunch ju junilh ju anquilh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Pus ju acsnich ju Malia chani junilh ju anquilh: ―Pus tas calhi'alinach ju qui'ask'at'a ni mati'ca' ju quimpapa. ");
INSERT INTO teeNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Chai ju anquilh junich: ―Yuchi ju Spiritu Santu ju calakminan chai la'ixtachaput Dios ju anavic'ana' chunch. Pus ixlhiyuchi ju ask'at'a ju calok'ona' salaka cajuna'. Chai ni chunch junita pus jantu catinavilh ju alactu'unti. Chai calhimispacana' ni ists'alh Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Chai vachu' ju milhilak'au Elisabet pacxanta ju is'ask'at'a mas na t'acuch. Chai mas ixlhimispacan ni jantu lai ix'alin is'ask'at'a para ju chavai lakachaxan malhquiyu' junita ju xapacxanta ju is'ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Pus mati' tu'u' ju xcai calhiula ju Dios. ―Chunch ju junilh ju anquilh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Pus ju acsnich ju Malia chani junilh: ―Pus ixlapanac Dios icjunita. Chach quinavi tachi ju ani xaq'ui'uni. ―Chunch ju naulh ju Malia. Chai ju acsnich lana taxtulh ju anquilh junta ixvi ju Malia. ");
INSERT INTO teeNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Pus acsni tapasalh lacats'unin avilhchan pus ju Malia taxtulh. Lana soko alh ju xalacatalhpan laxa'estado Judea tus cha'alh junta ixvi lakatam lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Chai tanucha la'ixchaka' ju Zacarías chai mac'amilh ju Elisabet. ");
INSERT INTO teeNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Chai acsni tavanan k'asmatlh ju Elisabet ju ix'amac'aminti ju Malia pus lana na lucunulh ju ask'at'a la'ixpajan. Chai ju Spiritu Santu lana lhinonk'o la'is'atsucunti ju Elisabet chai mapast'ac'ani tuchi canaulh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Pus na p'as ju chivinilh chai chani ju junilh ju Malia: ―Palai k'ox atsucunti ju xaxtakniyan ju uxint'i ju Dios. Palai jantu tachi chun ju mint'a'atsi'in. Chai vana na k'ox atsucunti ju xaxtakni ju mi'ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Chai tis quintalakxtu ni laich xaquilakmin ju quit'in ju ixnati ju qui'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Pus acsni tavanan ick'asmatnin ju mi'amac'aminti pus lana lucunulh ju ask'at'a laquimpajan ni na ixk'achanch. ");
INSERT INTO teeNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Chai na paxcat'at ju uxint'i ni xalac'a'i ju chivinti ju ix'unc'an. Chai ca'uctaxtuyach ju tuchi xajunan ju Dios. ―Chunch ju naulh ju Elisabet. ");
INSERT INTO teeNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Chai ju acsnich ju Malia chani naulh: ―Slivasalh na iclak'ayai ju Dios laquintac'atsan. ");
INSERT INTO teeNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Chai na iclhik'achanch ju Dios ju qui'amak'alhtaxtunu' junita. ");
INSERT INTO teeNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Quimapainilh mas jantu tu'u' quintapalhni ixjunita. Quit'in ju ixlapanac icjunita. Chai tus chavai tachi chun ju lapanacni aquintajunach ni slivasalh na paxcat ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Pus ju Dios na tachapun chai yuchi ju xaquinavini na k'ai lhamak'an. Chai ju yuchi na salaka. ");
INSERT INTO teeNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chai ju yuchi a'aktaijunun laca'amapaininti tachi chun ju tatalhoni ju yuchi mas va tavananch ju catatsuculh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Chai ju tuchi navi ju yuchi putasui ni na tachapun ju yuchi. Jantu tu'u' ixtapalhni anavi ju yu'unch ju na ixtalhitak'ayai ix'atalaninti'an la'ix'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Amak'osu ju la'ixpu'ucxtin'an ju xalack'ajin. Chai alak'ayalh ju jantu tu'u' ixtapalhni'an ix'alakts'incan. ");
INSERT INTO teeNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chai ju na tac'atsai ni alin ixmaktasq'uinit'an ni salaka catava pus ju Dios axtaknilh. Chai ju na va k'ai tac'atsai ju la'is'atsucunti'an pus ju Dios jantu tu'u' axtaknilh ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ju yuchi quinta'aktaijun ju quijnan'an ju israelitanin juntau ju ixlapanacni juntau. Chai lhinavilh chunch ni cac'atsayau ni jantu ixcapta ju anu' lamapainin ju ixnajunta ni canaviya'. ");
INSERT INTO teeNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Chunch tachi ju ajuni ju mak'aniya quilacpai'an acsni ajuni ni capast'ac'a' ju lamapainin ju k'alhtasunilh ju Abraham chai ix'amask'at'anti. Chai ju anu' lamapainin ju aquintanaviniyan aquintapu'aktaijuk'alhiyan. ―Chunch ju naulh ju Malia. ");
INSERT INTO teeNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Pus ju Malia t'atolhcha ju Elisabet tachi lakat'utu malhquiyu'. Astan anchokolh la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Pus ju Elisabet acsni cha'alh ju ixpulak'auch pus maklak'aulh pumatam ists'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Pus acsni tak'asmatlh ju ixt'atolhnin chai ju ixlhi'alak'avin ni Dios ju xa'aktaijui lacak'ai amapaininti pus na tat'ak'achalh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Chai acsni cha'alh ju ixlhilakatsajin avilhchan pus tamilh ch'uc'unin ju ix'axt'ak'a ju anu' ts'alh tachi ju ixtalhilanita ju israelitanin. Chai ixtalhixak'alaputun Zacarías ni va ixtucai ixta'ulaniputun ju ixpai. ");
INSERT INTO teeNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Para ju ixnati ju ask'at'a lana ajuni: ―Jantu chun cajuncana'. Ma Xivan cajuncana'. ");
INSERT INTO teeNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Chai ju yu'unch tajuni: ―Tajuch. Jantu xamati' ju milhi'alak'avin ju chunch juncan. ");
INSERT INTO teeNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Pus ju acsnich taxak'ala ju ixpai. Va ixtatamacyonich acsni istasacmiputun tis cajuncanach ju ists'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Chai ju yuchi sq'uinlh ju tu'u' junta lai ca'ats'oknulh tuchi cajuncana' ju ists'alh. Chai ts'ok'ulalh ni Xivan cajuncana'. Pus ixchux'an ju anch ixtavilanalh va talhamak'aninilh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Pus lana tak'oxinilh ju ixquilhni ju Zacarías chai ju yuchi tsuculh chivini' chai lak'ayalh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Pus na tatalhanalh ju ixt'atolhnin. Chai tachi chun ju lapanacni ju ixtat'ajun ju xalacatalhpan ju xa'estado Judea tac'atsak'o tachi chun ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Chai tachi chun ju tak'asmatlh ju ani taxtokni va tachi ixtapastact'ajun la'ix'alhunut'an. Chai ixtalaclajuni: ―Tis atsucunti nu' ju capacxana' ju anu' ask'at'a. Chunch ju ixtalaclajuni ju lapanacni ni na ix'aktaijui ju anu' ask'at'a ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Pus ju Spiritu Santu lhinaulh la'is'atsucunti ju Zacarías ju ixpai Xivan ixjunita. Chai ju yuchi tsuculh nona' ixchivinti Dios. Pus chani naulh: ");
INSERT INTO teeNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","―Chach lak'ayacalh ju quiDios'an ju israelitanin juntau ni quintaquilakts'inchinch chai quintaquimalakxtuchinch ju quijnan'an ju ixlapanacni juntau. ");
INSERT INTO teeNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ju yuchi quintaxtaknitan pumatam amak'alhtaxtunu' ju na tachapun junita. Chai ju yuchi ixpapanti junita ju David ju ixlapanac Dios ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ju Dios naulh ni chunch ju catapasaya'. Naulich la'ixchivinti'an ju ixlapanacni ju is'asacxtuta ni catanona' ixchivinti tus mak'anchich. ");
INSERT INTO teeNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ju yuchi naulh ni aquintamak'alhtaxtuyan la'ixmaca'an ju quint'alaxcai'an chai tachi chun ju jantu quintalakts'imputunan. ");
INSERT INTO teeNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ju chunch ju Dios amuctaxtuni ju anu' chivinti ju ak'alhtasunilh ju mak'aniya quilacpai'an acsni ajuni ni ca'a'aktaijuyach laca'amapaininti. Chai putasui ni jantu xac'ap'a ju chivinti ju xa'at'atak'oxi ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Yuchach ju anu' chivinti ju ixjunita ju mak'aniya quimpai'an Abraham chai mavasalanilh ni vasalh canaviya'. ");
INSERT INTO teeNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ju yuchi naulh ni aquintamak'alhtaxtuyan la'ixmaca'an ju quint'alaxcai'an. Ju chunch ni laich cach'alhcatnaniyau ju yuchi chai jantu catalhananau. ");
INSERT INTO teeNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Chai jantu ca'alactu'ununau para va tachi canaviyau ju soknic'a. Chai va tachi chunch ju catsucuyau chux avilhchan acsni t'onau ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Chai ju uxint'i ji quints'alh alhimisp'ac'ana' ni ixlapanac Dios unit'a chai anona' ixchivinti. Chunch ju alhimisp'ac'ana' ni uxint'i ju a'una' ju lapanacni ni catalak'oxilh ix'atalacpast'ac'at'an ni camina' ju ix'ucxtin'an. Chunch ju alaya' acsni tuca' min ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Chai uxint'i ju amamach'akxaniya' ju lapanacni ni catatak'alhtaxtuya' acsni ca'amac'acxanicana' ju ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chai chunchach ju lai ca'anavicana' ni quintanavinitan lamapainin ju Dios ni quintamacaminin ju akts'iya ixnoncan ni camalakachatachilh. ");
INSERT INTO teeNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Chai ju yuchi camapulhcuniya' la'ix'atalacpast'ac'at'an ju yu'unch ju tat'ajunca' tachi ju va laca'atats'isni chai na ta'amak'aninin ni na tatalhoni ju aninti. Chai ju yuchi vachu' aquintamalhtanayan ju laxati junta alin ju ak'oxamixnit la'ixmacni Dios. ―Pus chunch ju naulh ju Zacarías. ");
INSERT INTO teeNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Pus ju ask'at'a Xivan tak'aya. Chai ixlhichux ix'alhunut ixlhilaksi ju Dios. Chai anch ju ixt'ajun junta jantu xamati' ixt'ajun tus acsni atalacasunilh ju ist'a'israelitanin ni ixlapanac Dios ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Pus ju acsnich ju k'ai ucxtin Augusto lhinaulh is'ats'ok'ulaca chux ju lapanacni ixlhilacaputs'un ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Chai ju ani yuchi ju xap'ulhnan ats'ok'ulanti ixjunita ju ixtalhavat lapanacni. Chai ju acsnich Cirenio xagobernador ixjunita ju xa'estado Siria. ");
INSERT INTO teeNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Chai chux ju lapanacni anch ju ixta'anchokoi ists'ok'ulaca'an junta akts'iya ixt'unch'an ixjunita ju pumatamin. ");
INSERT INTO teeNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Pus ju José vachu' taxtulh ju lak'achak'an Nazaret laxa'estado Galilea. Alh ju lak'achak'an Belén laxa'estado Judea. Pus ju Belén ixt'un ixjunita ju mak'aniya lapanac ju David ixjuncan. Chai ju José mak'aniya ixpapanti ixjunita ju David chai yuchi lhi'alh ju anch. ");
INSERT INTO teeNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Chai acsni alh tats'oknu' ju José pus t'a'alh ju Malia ju ix'amachaka' ixjunita. Para tachi ju va is'asq'uinintica' ju ixlakts'in. Pus t'a'alh ju Malia chai ju yuchi ix'ak'ainanta. ");
INSERT INTO teeNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chai acsni ixtavilanancha anch pus cha'alh ju avilhchan acsni ixlok'omputunch. ");
INSERT INTO teeNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Chai maklak'aulich lakatami ists'alh. Chai pach'ilh lacapumpu' chai mujulh junta ixtavajin ju caballo. Anchach ju satsucui ju Jesús ni va jantuch lai ixtalhijun ju lacachaka' junta laich catatavi. ");
INSERT INTO teeNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chai ixta'alin ju ixlhistacnin borregojni vanin ju lak'achak'an Belén. Chai ju yu'unch ixtat'ajun lhistacnin ju ixborrego'an ju anu' atats'isni acsni tsuculh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Chai acsni talhic'atsanalh chincha ju ix'anquilh Dios junta ixtavilanalh. Chai na xlap'ap'a ixmaktajita junta ixtavilanalh ju ixlhistacnin borregojni. Pus lana na tatalhanalh. ");
INSERT INTO teeNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Para ju anquilh chani ajuni: ―Jantu at'alhanant'it ni va iclajumputunau lakatam chivinti ju k'ox alhiulaya'it'it. Chai ixlacata yuchi slivasalh ak'ach'ana'it'it ju uxijnan chai tachi chun ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Pus chavai tsuculh ju mi'amak'alhtaxtunu'an ju ani la'ixlak'achak'an David. Yuchi ju ixnoncan camalakachatachilh ju Dios. Yuchi ju mi'ucxtin'an. ");
INSERT INTO teeNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Chai chani ju ap'umisp'aya'it'it. Pus alhit'a'uya'it'it ju ask'at'a ni pach'icanta lacapumpu' chai mucanta junta vajin ju caballo. ―Chunch ju ajunilh ju anquilh. ");
INSERT INTO teeNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Chai lana va tam pants'iquis na lhu xatat'atalacasui ju ixt'a'anquilhnin. Chai ixtalak'ayai ju Dios chai chani ixtanajun: ");
INSERT INTO teeNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","―Chach lak'ayacalh ju Dios ju vilhcha talaclhman. Chai ju ani lacat'un ca'alina' ju ak'oxamixnit ixlacata'an ju xa'anavini lamapainin ju Dios ―chunch ju tanaulh ju ixtalhavat anquilhnin. ");
INSERT INTO teeNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Chai astan ju anquilhnin ta'anchokolh ju lact'iyan. Pus ju acsnich ju ixlhistacnin borregojni talaclajunich ju sia yu'unch: ―Ca'auch ju chavai ju lak'achak'an Belén. Ca'au lakts'inin ju tuchi alinch. Ju tuchi xaquintamac'atsaniyan ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Pus lana vats'alhti ta'alh. Chai talhitajulh ju Malia chai ju José chai ju ask'at'a ni ixt'ajunch junta vajin ju caballo. ");
INSERT INTO teeNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Chai acsni talakts'ilh pus tamac'atsanilh ju lapanacni ju tuchi ix'ajuncanta ixlacata ju anu' ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chai tachi chun ju ixtak'asmat'a va talhamak'aninilh tuchi ixtanajunch ju ixlhistacnin borregojni. ");
INSERT INTO teeNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Para ju Malia va ixmak'ak'ojuich tachi chun ju ani taxtokni la'ix'alhunut. Va la'is'akstu ispastact'ajun. ");
INSERT INTO teeNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Chai ju ixlhistacnin borregojni ta'anchokolh la'ixlhich'alhcat'an. Chai ixtalak'ayai ju Dios chai ixtajuni lak'ailakts'iuch ixlacata tachi chun ju ani taxtokni ju ixtak'asmat'a chai ju ixtalakts'inta. Pus chunch lana uctaxtuk'o tachi ju ix'ajuncanta. ");
INSERT INTO teeNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Chai acsni cha'alh ju ixlhilakatsajin avilhchan pus tach'uc'unilh ju ix'axt'ak'a ju ask'at'a chai lhimapaka'ucalh Jesús ni chunchach ju ixnajunta ju anquilh mas tuca' ixpacxan ju ixnati. ");
INSERT INTO teeNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ju la'ixlhamap'aksin ju Moisés ilhca'ulani tam chako'ulh ju avilhchan acsni calakts'incalh ni tachi ju va lhquiliqui acsni istsucui tam is'ask'at'a. Pus acsni tavanan ta'aktsa ju anu' avilhchan ixlacata ju Malia pus talhi'alh ju ask'at'a Jesús lacak'ai ixpujitat'an ju ist'a'israelitanin ju lak'achak'an Jerusalén. Anch ju tamak'axtaknilh ju Dios ju ask'at'a Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Pus chunchach ju tanavi ni chunchach ju najun la'ixlhamap'aksin ju Moisés. Pus chani najun: “Tachi chun ju xap'ulhnan ask'at'a ju catsucuya' ni ts'alh pus camispacanach ni ix'anu' ju Dios”. Chunch ju najun la'ixlhamap'aksin Moisés. ");
INSERT INTO teeNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Chai vachu' najun la'ixlhamap'aksin Moisés ni caxtakniya' tu'u' atapacxat ju Dios ni salaka calakts'inchokocalh tam chako'ulh. Pus ju va quilhpatinin laich cataxt'ak'a' lakat'ui lak'axk'avan. U ni jantu pus lakat'ui palumax. Chai yuchach ju taxtaklh ju Malia chai ju José. ");
INSERT INTO teeNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chai ju lak'achak'an Jerusalén ix'alin pumatam lapanac ju Simeón ixjuncan. Chai ju yuchi na soknic'a ixjunita la'ixmacni Dios chai na ixtalhoni ju Dios. Chai ju yuchi ixpacxantajich ju anu' ju ixnoncan camalakachatachilh ju Dios ni ca'amak'alhtaxtuya' ju israelitanin. Chai ju Spiritu Santu ixlhinajun la'is'atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Chai ju Spiritu Santu ixmac'atsanita ju Simeón ni jantu catini tus acsni jantuca' lakts'in ju yuchi ju camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chai ju Spiritu Santu mac'atsani ni ca'alh ju acsnich ju lacpujitat. Chai lana acsnich ju tat'aquilalh lacpujitat ju ask'at'a Jesús ju José chai ju Malia. Va ixtamak'axtakniputun ju ask'at'a ju Dios tachi ju talhilanita lacalhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Pus ju Simeón c'atsalh ni yuchi junita ju Jesús ju anu' ju ixnoncan camalakachatachilh ju Dios. Chai ju Simeón lana ch'ixlh ju ask'at'a. Chai lak'aya ju Dios. Chai chani naulh: ");
INSERT INTO teeNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","―Ju chavai ji Dios laich alak'a'it'i ni acniya' ju quit'in ju milapanac icjunita ni mati' tu'u' ju chavai ju aclhamak'aninina'. Laich acniya' ju chavai ni iclakts'inta ju yuchi ju q'uink'alht'asunit'a ni aclakts'ina' acsni tuca' icni. ");
INSERT INTO teeNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Pus lai lhik'ach acnilh ju chavai ni iclakts'inta ju yuchi ju xamalak'ach'ayach'it'a ni amak'alhtaxtunu' junita. ");
INSERT INTO teeNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Chai mac'at'ant'a ju yuchi ni laich catamispaya' tachi chun ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ju yuchi chunch cajuna' tachi ju tu'u' maclhcu ni camapulhcuniya' ju ixtac'atsan'an ju jantu israelitanin tajunita. Chai ixlacata yuchi aclak'ayacanau ju quijnan ju israelitanin icjuntau ju milapanacni icjuntau ―chunch ju naulh ju Simeón. ");
INSERT INTO teeNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Chai ju José chai ju ixnati ju Jesús na talhamak'aninilh ju taxtokni ju ixnoncan ixlacata ju ask'at'a Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Chai ju Simeón sq'uinilh ju Dios ni k'ox catatsucuya' chai chani ju junilh ju Malia ixnati ju ask'at'a: ―Ju ani ask'at'a lhca'ulacanta ni catapuk'alhk'osa' na lhu ju quint'a'israelitanin'an chai vachu' na lhu catapuk'ostayaya'. Chai ixlacata yuchi ju lapanacni catapuc'atsaya' ni laich catak'alhtaxtucana'. Para na lhu ju jantu k'ox catalhiulaya'. ");
INSERT INTO teeNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Chai ni chunch ju catalaya' ju lapanacni pus camalacasucanach ju ix'atalacpast'ac'at'an ju alin la'ix'alhunut'an na lhu lapanacni. Chai ju uxint'i ji ixnati slivasalh na amak'alhk'ajnana' ixlacata tachi chun ju ani taxtokni ju catapasaya'. ―Chunch ju naulh ju Simeón. ");
INSERT INTO teeNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chai vachu' ixt'ajun ju acsnich pumatam chako'ulh ju ixnajun ixchivinti Dios. Ju yuchi Ana ixjuncan. Istsi' ixjunita ju Fanuel chai ixpapanti ju Aser. Chai ju yuchi na t'acuch ixjunita. Pus acsni tavanan ix'icanta pus va lakatujun c'ata ju t'atsuculh ju ixpapa. ");
INSERT INTO teeNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Chai acsni tavanan nimacontilacalh pus va is'akstu ju tsuculh ochenta y cuatro c'ata. Pus ju yuchi jantu tavanan ixtaxtui ju lacpujitat. Para chux tok'oxai chai chux tuncujun ixlak'ayai ju Dios. Istascajai chai ixt'achivinin ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Pus ju yuchi vachu' acsnich ju alakmilh ju José chai ju Malia. Chai vachu' junilh lak'ailakts'iuch ju Dios ixlacata ju ask'at'a. Chai astan ix'alacjuni ixlacata ju Jesús tachi chun ju amachak'an Jerusalén ju ixtapacxantaji ju ixputak'alhtaxtun'an. ");
INSERT INTO teeNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Chai acsni tamuctaxtuk'o tachi chun ju taxtokni tachi ju ixnajun la'ixlhamap'aksin ju Dios pus ta'anchokolh laxa'estado Galilea. La'ixlak'achak'an'an junta Nazaret ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Pus ju ask'at'a Jesús tak'aya chai palai tachapun va. Chai palai ac'atsanalh. Chai va tachi ixnavini lamapainin ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ju José chai ju Malia ixta'anch chux c'ata ju lak'achak'an Jerusalén acsni ix'alinacha ju anu' c'atan ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Chai ju Jesús acsni pacxalh lakacaut'ui c'ata pus vachu' alact'a'alh ju yu'unch ju lak'achak'an Jerusalén tachi ju akts'iya ixtalai acsni ix'alinacha ju c'atan. ");
INSERT INTO teeNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Chai acsni lak'olh ju c'atan pus ju José chai ju Malia tataxtuchokolh ju lak'achak'an. Ixta'anchokoputun la'ixchaka'an. Para ju ask'at'a Jesús ixtamacontacha ju lak'achak'an Jerusalén para jantu istac'atsai ju José nin ixnati. ");
INSERT INTO teeNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Va ixtanajun ni ca anch ixmak'anta lacatalhavat. Pus ta'alhtanalh tam vilhchan. Chai astan tasacmi ju ixlhi'alak'avin chai ju ixt'alamispanch'an ni ixtalakts'inta ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Chai acsni jantu talhitaju pus ta'anchokopa ju lak'achak'an Jerusalén. Va tapuxcolhi'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Pus lhitajucalh ixlhilakat'utuch avilhchan ju la'ixpujitat'an ju ist'a'israelitanin. Anch ixmakvi junta ixtavilanalh ju yu'unch ju ixtamasui tuchi ixnomputun ju lhamap'aksin. Pus ju Jesús ixt'ajun ak'asmatnini' tuchi ixtanajun chai is'asacmininch vachu'. ");
INSERT INTO teeNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Chai tachi chun ju ixtak'asmatnich va ixtalhamak'aninin ju ix'ac'atsanti ju anu' ask'at'a ni na sok ix'ak'alhtayanan. ");
INSERT INTO teeNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Para ju José chai ixnati ni talakts'ilh na talhamak'aninilh. Chai ju ixnati chani juni: ―Tajuch ji quints'alh ni va chunch xaquila'ulhtuyau. Ju ani mimpai chai ju quit'in na iclalhamak'anininau ni iclapuxcolhit'onauch. ");
INSERT INTO teeNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Para ju Jesús chani ajuni: ―Tajuch ni jantu isc'ats'ayat'it ta'anchach ju icvi. Ja va jantu c'ats'ayat'it ni tasq'uini ni acnavinilh ju ixlhich'alhcat ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Para ju yu'unch jantu lai tamachakxanilh ixchivinti tuchi ju lhak'alhtayanalh. ");
INSERT INTO teeNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Pus ju Jesús lana alact'amincha. Taminchokolh la'ixchaka'an ju lak'achak'an Nazaret. Chai ju yuchi aquiclaca'inilh ju José chai ju Malia. Pus ju ixnati va ixmak'ai tachi chun ju ani taxtokni la'ix'alhunut. ");
INSERT INTO teeNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Chai ju Jesús palai ixt'ajun lhita'okslana' ju ixtac'atsanti chai ju ixtak'ayanti. Chai ju Dios ismasuni ix'amapaininti ju ask'at'a Jesús. Chai ju lapanacni vachu' na k'ox talhiula ju ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Acsni ixtailhi'anta ju lakacauquisi c'ata la'ixpu'ucxtin ju Tiberio ju xak'ai tucan ixjunita pus Poncio Pilato gobernador ixjuntacha ju xa'estado Judea. Chai ju Herodes ixlhinajun ju xa'estado Galilea. Chai ixlak'au ju Herodes ju Pilipe ixjuncan yuchi ju gobernador ixjuntacha ju xalacat'un Iturea chai ju lacat'un Traconite. Chai ju Lisanias gobernador ixjuntacha ju xalacat'un Abilinia. ");
INSERT INTO teeNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Chai ju Anás chai ju Caifás yu'unch ju xalack'ajin palijni ixtajunita. Pus acsni ixtat'ajun ju ani xalack'ajin chai ju ani palijni pus acsnich ju xak'ala ju Dios ju Xivan junta ixvilhcha junta va aseknic'a. Yuchi ju Xivan ju ists'alh Zacarías ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Pus ju yuchi ucsuntsuculh chux ju xalacat'un la'ixquilhtu' ju k'ai xcan Jordán. Ix'ajuni ju lapanacni ni catamacaulh ju ix'alactu'unti'an chai cata'akpaxlh. Chai ju chunch ju Dios ca'amac'acxaniya' ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Chai acsni chunch ju lalh ju Xivan pus uctaxtulh ju ixchivinti ju Isaías ju mak'aniya lapanacni ixjunita. Pus ju yuchi ixnajun ixchivinti Dios chai chani ju xats'ok'ulai: P'as chivinin pumatam junta aseknic'a junita. Chai chani najun: “Alak'oxit'it ju mi'alhunut'an ni camina' ju ucxtin. Alasoknic'at'it ju mi'atsucunti'an junta jantu sok junita. ");
INSERT INTO teeNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tachi chun ju tac'acxniyan la'ixmacni Dios ma axt'aknic'ana'it'it. Chai tachi chun ju tu'u' k'ai u ju tu'u' mas va lacat'icst'i ju tasastucniyan lami'atsucunti'an ma amak'osunic'ana'it'it. Chai tachi chun ju jantu soknic'a lami'atsucunti'an ma alasoknic'ana'it'it. Chai tachi chun ju macxcai ju alinca' la'is'atsucunti'an ju talhilaca'anta ju Jesús ma camak'osunicana'. ");
INSERT INTO teeNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Chai tachi chun ju lapanacni ma catalakts'ina' ju macaminta ju Dios ni laich catatak'alhtaxtuya' ju yu'unch”. Chunch ju naulh ju mak'aniya lapanac ju Isaías ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Pus ju Xivan chani ix'ajuni ju lapanacni ju ixtalakmin ni va ixta'akpaxputun la'ixmacni ju yuchi: ―Chunch ju lap'ut'unat'it tachi ju tu'u' lu. Ju yuchi va acsnich ju ats'alai acsni xavacan ju ach'itin junta t'ajun. Pus vachu' chun ju lap'ut'unat'it ju uxijnan. Va acsnich ju tamch p'ast'acp'ut'unat'it ni xak'asmat'at'it ni catamamak'alhk'ajniyan ju Dios. Tis chavaich ju xatajunan ni anaviya'it'it tu'u' ni jantu catamamak'alhk'ajniyan ju Dios acsni cachina' ju anu' avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Pus ni vasalh t'ak'alht'axt'up'ut'unat'it pus amalac'asut'it lami'atsucunti'an ni mac'ont'at'it ju mi'alactu'unti'an. Chai jantuch va k'aya ana'unt'it ju lami'alhunut'an ni laich at'ak'alht'axt'uya'it'it va ixlaca'atalh ni mak'aniya ix'apapanatnich Abraham unt'at'it. Jantu chun ana'unt'it ni iclajunau ni va ixlacasq'uilh ju Dios ni lhu ca'alilh ix'apapanatnich ju Abraham pus laich ca'ixmalok'oni ju ani ma chiux ni ca'ixtava ix'apapanatnich ju Abraham. ");
INSERT INTO teeNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chai mas chavai va lacats'unin tic'acx tus ca'amamak'alhk'ajniya' ju lapanacni ju Dios. Chai tachi chun ju lapanacni ju jantu tasui la'is'atsucunti'an ni vasalh tamacajunta ju ix'alactu'unti'an pus ca'amamak'alhk'ajnicana'. ");
INSERT INTO teeNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Pus ju acsnich ju lapanacni tasacmi. Chani tajuni: ―Ni vasalh tachi ju quilajunau pus tijuch ju acnaviyau. ");
INSERT INTO teeNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Chai ju Xivan ak'alhtailh. Chani ajuni: ―Pus ju alin k'alht'ui ixpumpu' chach xtaknilh ju mati' ixpumpu'. Chai ju alin ixvaiti pus vana caxtaknilh lacats'unin ju mati' tu'u' ju ca'ulh. ");
INSERT INTO teeNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pus vachu' talakmilh ju Xivan ju ach'inin. Vachu' va ixta'akpaxputun. Chai tajuni: ―Amamaka'unu' tijuch ju acnaviyau ju quijnan ni jantu acmamak'alhk'ajnicanau. ");
INSERT INTO teeNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Chai ju Xivan ajuni: ―Jantu na laklhu ach'inint'it tachi ju jantu lhijun ju lacalhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Chai ta'asacminin vachu' ju taropajni. Tajuni: ―Chai ju quijnan tijuch ju acnaviyau. Chai ju Xivan ajuni: ―Jantu xamati' alhimacch'ap'ut'it va ixmaxtunica ju ixtumin. Nin yuchi ni va k'aya amuc'anit'it ixtalak'alhin tam xamati' ni va maxt'up'ut'unat'it ixtumin. Alhik'ach'ant'it tachi ju map'alhc'ant'it. ");
INSERT INTO teeNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Pus ju lapanacni na ixtamakpacxan ju ixnoncan camalakachatachilh ju Dios. Chai ixtanajun la'ix'alhunut'an: “Ts'a ma yuchi ju Cristo ju Xivan. Yuchach ju camina' noncan”. ");
INSERT INTO teeNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Para ju Xivan ajuni: ―Ju quit'in islivasalh ni va lacaxcan ju iclamakpaxayau ni catac'atsaya' ju lapanacni ni mac'ont'at'it ju macxcai. Para mintachalhca' ju palai xak'ai. Palai jantu ju quit'in. Pus ju quit'in jantu tu'u' ju quintapalhni. Jantu lai actich'anxk'otlh nin mas va yuchi ju samusni ixch'anxt'ak'an. Pus ju yuchi acsni cachina' cataxtakniyan ju stavasalanti amakpaxanti. Yuchi ju Spiritu Santu ju catanuya' lami'alhunut'an chai cataxacaniyan chux ju macxcai chai salaka catanaviyan tachi ju lai ju tu'u' jipi ni xavak'ojui tachi chun ju amacxtalh. ");
INSERT INTO teeNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Chai ju anu' ju camina' chunch ju ca'ulhtuya' ju lapanacni tachi ju lai tam lapanac ju lacsunui ju iscebada. Ju yuchi ch'apai ju ixpalacsunun la'ixmaca' chai acsni patajui ju cebada pus ju xa'amacxtalh lacatamch tamai. Chai astan ju amanavin mak'ai ju xacebada la'ixpac'ats'a para alacxavai ju xa'amacxtalh. Chai ju chunch salaka jun ju ixchaka'. Pus vana va chun calaya' ju anu' ju camina'. Camak'alhtaxtuya' ju lapanacni ju vasalh talhilaca'anta ju yuchi. Para ju jantu pus camaca'ancana' lacajipi junta jantu tavanan lai mamixican. ");
INSERT INTO teeNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Para jantu va yuchi ni xalak'ak'aimai ju lapanacni ju Xivan. Para vachu' na tijlhu amap'aksinti ju xa'axtakni ju lapanacni chai alacjuni ju yu'unch ta yu laich cataputak'alhtaxtuya'. ");
INSERT INTO teeNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chai vachu' lak'ak'aima ju gobernador ju Herodes ixjuncan. K'ailh ni ix'amachakach navichokolh ju ix'amachaka' ixjunita ju isp'isek'e ju Pilipe ixjuncan. Pus ju anu' chako'ulh Herodías ixjuncan. Vachu' lhik'ailh ixlacata tachi chun ali' talak'alhin ju ixnavita ju Herodes. ");
INSERT INTO teeNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Chai ju Herodes palai lalhava ju ixtalak'alhin acsni t'alhnu ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Pus acsni ix'amakpaxai ju lapanacni ju Xivan pus vachu' ju Jesús akpaxlh. Chai acsni ixt'achivinin ju Dios ju Jesús pus lana talht'ek'a ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Chai lana lakmilh ju Spiritu Santu tachi ju tu'u' lak'axk'avan. Chai lana chivincancha ju lact'iyan chai k'asmatcalh ju lacat'un junta chani junicalh ju Jesús: ―Ju uxint'i quints'alh'at. Chai na icmapainiyan. Na iclhik'achan ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ju Jesús acsni tavanan tai'ula ju ixlhich'alhcat ixpacxanta tachi lakap'uxamcau c'ata. Chai ixtalhimispaich tachi ju va ists'alh ixjunita ju José. Pus ju José ists'alh ixjunita ju Elí. ");
INSERT INTO teeNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Chai ju ixpai ju Elí ixjuncan Matat. Chai ju ixpai Matat ixjuncan Leví. Chai ixpai ju Leví ixjuncan Melqui. Chai ju ixpai ju Melqui ixjuncan Jana. Chai ju ixpai ju Jana ixjuncan José. ");
INSERT INTO teeNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Chai ixpai ju José ixjuncan Matatías. Chai ixpai ju Matatías ixjuncan Amós. Chai ixpai ju Amós ixjuncan Nahum. Chai ixpai ju Nahun ixjuncan Esli. Chai ixpai ju Esli ixjuncan Nagai. ");
INSERT INTO teeNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Chai ixpai ju Nagai ixjuncan Maat. Chai ixpai ju Maat ixjuncan Matatías. Chai ixpai ju Matatías ixjuncan Semei. Chai ixpai ju Semei ixjuncan José. Chai ixpai ju José ixjuncan Judá. ");
INSERT INTO teeNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Chai ixpai ju Judá ixjuncan Joana. Chai ixpai ju Joana ixjuncan Resa. Chai ixpai ju Resa ixjuncan Zorobabel. Chai ixpai ju Zorobabel ixjuncan Salatiel. Chai ju ixpai ju Salatiel ixjuncan Neri. ");
INSERT INTO teeNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Chai ixpai ju Neri ixjuncan Melqui. Chai ixpai ju Melqui ixjuncan Adi. Chai ixpai ju Adi ixjuncan Cosam. Chai ju ixpai ju Cosam ixjuncan Elmodam. Chai ixpai ju Elmodam ixjuncan Er. ");
INSERT INTO teeNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Chai ixpai ju Er ixjuncan Josué. Chai ixpai ju Josué ixjuncan Eliezer. Chai ixpai ju Eliezer ixjuncan Jorim. Chai ixpai ju Jorim ixjuncan Matat. ");
INSERT INTO teeNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Chai ixpai ju Matat ixjuncan Leví. Chai ixpai ju Leví ixjuncan Simeón. Chai ixpai ju Simeón ixjuncan Judá. Chai ixpai ju Judá ixjuncan José. Chai ixpai ju José ixjuncan Jonán. Chai ixpai ju Jonán ixjuncan Eliaquim. ");
INSERT INTO teeNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Chai ixpai ju Eliaquim ixjuncan Melea. Chai ixpai ju Melea ixjuncan Mainán. Chai ixpai ju Mainán ixjuncan Matata. Chai ixpai ju Matata ixjuncan Natán. ");
INSERT INTO teeNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Chai ixpai ju Natán ixjuncan David. Chai ixpai ju David ixjuncan Isaí. Chai ixpai ju Isaí ixjuncan Obed. Chai ixpai ju Obed ixjuncan Booz. Chai ixpai ju Booz ixjuncan Salmón. Chai ixpai ju Salmón ixjuncan Naasón. ");
INSERT INTO teeNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Chai ixpai ju Naasón ixjuncan Aminadab. Chai ixpai ju Aminadab ixjuncan Aram. Chai ixpai ju Aram ixjuncan Esrom. Chai ixpai ju Esrom ixjuncan Fares. Chai ixpai ju Fares ixjuncan Judá. ");
INSERT INTO teeNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Chai ixpai ju Judá ixjuncan Jacob. Chai ju ixpai ju Jacob ixjuncan Isaac. Chai ixpai ju Isaac ixjuncan Abraham. Chai ixpai ju Abraham ixjuncan Taré. Chai ju ixpai ju Taré ixjuncan Nacor. ");
INSERT INTO teeNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Chai ixpai ju Nacor ixjuncan Serug. Chai ixpai ju Serug ixjuncan Ragau. Chai ixpai ju Ragau ixjuncan Peleg. Chai ixpai ju Peleg ixjuncan Heber. Chai ixpai ju Heber ixjuncan Sala. ");
INSERT INTO teeNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Chai ixpai ju Sala ixjuncan Cainán. Chai ixpai ju Cainán ixjuncan Arfaxad. Chai ixpai ju Arfaxad ixjuncan Sem. Chai ixpai ju Sem ixjuncan Noé. Chai ixpai ju Noé ixjuncan Lamec. ");
INSERT INTO teeNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Chai ixpai ju Lamec ixjuncan Matusalén. Chai ixpai ju Matusalén ixjuncan Enoc. Chai ixpai ju Enoc ixjuncan Jared. Chai ixpai ju Jared ixjuncan Mahalaleel. Chai ixpai ju Mahalaleel ixjuncan Cainán. ");
INSERT INTO teeNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Chai ixpai ju Cainán ixjuncan Enós. Chai ixpai ju Enós ixjuncan Set. Chai ixpai ju Set ixjuncan Adán. Chai ju Adán yuchi ju Dios ixpai junita. ");
INSERT INTO teeNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ju Spiritu Santu ixlhinonk'ojui la'is'atsucunti ju Jesús. Chai acsni mincha ju xak'ai xcan Jordán ju Jesús pus ju Spiritu Santu juni ta anchach ju ca'alhtana'alh junta va aseknic'a. ");
INSERT INTO teeNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Pus t'up'uxam avilhchan ju ixvilhcha junta aseknic'a chai ju lhacaticuru navilh talacmask'at'inti ni ts'a ma laich ca'ixmalactu'uni ju Jesús. Chai ju Jesús jantu vailh ju acs avilhchan tus acsni uctaxtulh ju t'up'uxam avilhchan. Chai astan na ixchavanita. ");
INSERT INTO teeNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Pus ju acsnich ju lhacaticuru junilh: ―Ni sala vasalh ists'alh Dios'at pus anauch ni chach junch xkapavati junima chiux. ");
INSERT INTO teeNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Para ju Jesús k'alhtailh. Junich: ―Jantu lai chun actinavi ni ts'okcanta la'ixchivinti Dios ni jantu va yuchi ju xkapavati ju canaviya' cuenta ju tam lapanac. Alai canaviya' cuenta tachi chun ju ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Chai astan ju lhacaticuru alhi'ananalh la'ix'ucxni lakatam talhpa ju na putank'ai ixjunita. Lhi'ancalh ju Jesús. Chai anch ju malacasunik'o va tam pants'iquis tachi chun ju xalacpu'ucxtin ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Chai ju lhacaticuru chani ju junilh ju Jesús: ―Uxint'ich ju acxtaknik'oyan chux ju ani tachaput chai vasalh xak'ai a'una'. Lai acxtakniyan ni quit'in ju icmak'axtaknik'ocanta chai va tichi chavaich ju icxtakniputun lai icxtaknich. ");
INSERT INTO teeNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Pus sich mi'anu' cajuna' va yuchi ni aq'uint'a'akts'ok'ot'aniya'ich ju laqui'ucxlacapu'. ");
INSERT INTO teeNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Para ju Jesús ak'alhtayanalh. Junich: ―Ap'inchich ji Satanás ni ts'okcanta la'ixchivinti Dios ni yuchi ju Dios ju calak'ayacalh chai va yuchi ju caquiclaca'icalh. ");
INSERT INTO teeNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Chai astan ju lhacaticuru alhi'anananchokolh. Lhi'alh ju Jesús ju lak'achak'an Jerusalén chai anch ju yajucalh ju Jesús junta palai aksti' putank'ai junita ju ixpujitat'an ju israelitanin. Chai junich: ―Ni sala vasalh ists'alh'at Dios pus amak'anlht'ujnuch ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Lai chunch alat'i ni chani ju ts'okcanta la'ixchivinti Dios: Ju Dios ma camap'aksiya' ju ix'anquilhnin ni catalhist'ac'an. ");
INSERT INTO teeNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Chai la'ixmaca'an ju catach'ixanch ni jantu cach'an'uyan ju tu'u' chiux. ");
INSERT INTO teeNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Para ju Jesús chani lhik'alhtayanalh: ―Vachu' ts'okcanta ju anch ni jantu alakts'int'anut'i ju Dios ni camuctaxtuya' ju ixchivinti u jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Pus acsni mask'atik'o tijpachux alactu'unti ju ixmanaviniputun ju Jesús pus ju lhacaticuru macoyaulh tus alakatam avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Pus ju Jesús anchokopa ju xa'estado Galilea chai la'ixtachaput ju Spiritu Santu ju xach'alhcatnan. Chai lacc'atsak'ocalh ixlacata yuchi tachi ixlhilacaputs'un ju lacat'un anch. ");
INSERT INTO teeNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Chai ix'amalanininch la'ixlacpujitat'an ju ist'a'israelitanin ju anch. Chai ixchux'an na ixtalak'ayai ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ju Jesús minchokopa ju lak'achak'an Nazaret junta ixtak'ayata. Chai acsni cha'alh ju avilhchan pa'astacni pus ju yuchi tanucha la'ixpujitat'an ju ist'a'israelitanin tachi ju ixlhilanitach. Chai taya ni catac'atsaya' ju lapanacni ni ix'amak'asmatniputun ju ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Chai xtaknicalh ju alhiqui ju ists'okta ju mak'aniya lapanac ju ixnajun ixchivinti Dios. Yuchi ju Isaías ixjuncan. Pus ju Jesús acsni puxk'otlh ju alhiqui lhitajulh junta chani ists'okcanta: ");
INSERT INTO teeNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ju Spiritu Santu t'ajun laqui'alhunut ni quilhisacxtuta ni ac'ajunach ju quilhpatinin ta yu laich cataputak'alhtaxtuya'. Chai quimacaminta ni ac'amak'ank'acha ju na ta'amak'aninin. Chai ni ac'ajunach ju tach'inin ni laich catataxtulh junta at'alhnucanta. Chai ni ac'amalac'avaniya' ju alak'ach'ixnin. Chai ni ac'axk'ot'ach ju va alhimakchapucan. ");
INSERT INTO teeNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Chai ni acnona' ni chilh ju avilhchan acsni ca'anaviniya' lamapainin ju Dios ju lapanacni. Pus chunch ju ajuni ju lapanacni ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Chai astan mapuxtokchokolh ju alhiqui. Chai xtaknichokolh ju alhistacna' chai tavi ni ca'amalaninina'. Chai tachi chun ju ixtavilanalh ju lacpujitat va task'otutulh. ");
INSERT INTO teeNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pus ju yuchi tsuculh ajunini': ―Chavai avilhchan uctaxtulh junima chivinti tachi ju ts'okcanta la'ixchivinti Dios. Uctaxtulh acsni xaquilak'asmatniyau ju chivinti ju xaclajunau. ―Chunch ju ajunilh ju lapanacni ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chai ixchux'an tanaulh ni vasalh na lai ix'amalaninin. Chai na ixtalhamak'aninin ni na k'ox ixjunita ju ixchivinti ju tuchi ix'ajuni. Para ixtanajun: ―Ja jantiyu' ju ani ists'alh ju José. ");
INSERT INTO teeNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Chai ju Jesús ajunchokopa: ―Ju uxijnan ca va quilajumputunau ju chivinti ju noncan: “Ac'uch'unu' ac'uch'uch'ok'oc'ach mi'akstu. Ju chunch puc'atsacan ni vasalh lai ac'uch'unun”. Chai ca va quilajumputunau ni vasalh Cristo icjunita pus tasq'uini ni p'ulhnan acnaviya' ju ani laquint'un'an ju tuchi ixnoncan ni xacnaviyacha ju lak'achak'an Capernaum chai ju chunch laich ap'uc'ats'aya'it'it ta yu aquilapulhilaksiyau. ");
INSERT INTO teeNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Chai tailhi'alh ixchivinti. Ajuni: ―Slivasalh ju iclajunau. Jantu xamati' ju najun ixchivinti Dios ju lai tu'u' calhiulacalh ju la'ixt'un. ");
INSERT INTO teeNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Alakts'int'it ta yu tapasalh la'is'atsucunti ju Elías. Acsni ixt'ajunca' ju yuchi pus jantu lalh ju xcan lakat'utu c'ata a lakachaxan malhquiyu'. Chai alilh ju k'ai chavan ixlhilacaputs'un ju lacamunutpa'. Chai slivasalh ni na lhu ixta'alin ju chakolun ju va ix'animacontilacanta ju sia ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Para jantu xamati' ju sia yu'unch ju malakachanicalh ju Elías. Alai malakachanicalh pumatam chako'ulh ju ixnimacontilacanta amachaka' Sarepta laxat'un Sidón. ");
INSERT INTO teeNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chai acsni ixt'ajun ju Eliseo ju ixnajun ixchivinti Dios pus na pumalhu ist'a'israelitanin ixtapacxanta ju na macxcai ts'its'i ju puch'i'an. Para jantu xamati' ju sia lhiyu'unch ju lai palai canavicalh. Va yuchi ju ixjuncan Naamán amachaka' xalacat'un Siria. Chunch ju ajuni ju lapanacni ju Jesús. Chai yuchi alhijunilh chunch ni va ix'amamachakxaniputun ni jantu tu'u' ixtalhiulai ju ixt'a'amachak'an ju mak'aniya lapanacni vachu'. Para ju amachak'an alacatam yu'unch ju talhilaksilh. ");
INSERT INTO teeNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Pus ju acsnich tachi chun ju ixtavilanancha lacpujitat lana na tatalhk'amalh acsni tak'asmatnilh ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Chai tataya. Tatixcoxtulh ju Jesús ju lak'achak'an. Chai talhi'alh akstijun junta va k'ank'apuk'aitajunta junta vanin ixt'avi ju ixlak'achak'an'an. Anchach ju ixtamaca'amputun ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Para ju Jesús tapasalh la'ixlacaitat junta ixtayanalh ju yu'unch. Chai alh. ");
INSERT INTO teeNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ju Jesús alh ju lak'achak'an Capernaum laxa'estado Galilea. Chai ju savat tsuculh amalaninin ju lapanacni ju lacpujitat. ");
INSERT INTO teeNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pus chux ju lapanacni na ixtalhamak'aninin ta yu ix'amalaninin ni istasui la'ixchivinti ni vasalh ismispai ju atalaninti. ");
INSERT INTO teeNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Chai ixtanumacha lacpujitat pumatam lapanac ju ixpacxanta ju lhacaticuru la'ixtanquilhacni. Chai ju anu' lhacaticuru lana ts'au t'asalh. Puchivinilh ixquilhni ju anu' lapanac. Junich ju Jesús: ");
INSERT INTO teeNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Ai. Tijuch ju quilamintau lhilakts'inin ji Jesús amachaka' Nazaret. Ja va quilamintau mamak'alhk'ajninin ju quijnan. Pus iclamispayau tichi chavaich'at. Pus ju uxint'i salaka ixlapanac Dios'at. ");
INSERT INTO teeNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Para ju Jesús k'ailh ju lhacaticuru. Junich: ―Va sekch. At'axt'uch ju la'ixlacatuna ju ani lapanac. Pus ju acsnich ju lhacaticuru tin samak'alh ju lapanac junta ixtayanalh ixtalhavat lapanacni. Chai lana taxtulh la'ixlacatuna. Para jantu xamac'atsani. ");
INSERT INTO teeNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Chai lana na talhamak'aninilh ju lapanacni. Chai ixtalaclajuni ju sia lhiyu'unch: ―Tis chivinti nu' ju ani. Pus ju yuchi slivasalh lai lhinajun chai lacatachaput ju ajuni ju lhacaticurulhni ni catataxtulh chai tataxtui. ");
INSERT INTO teeNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Pus ixtac'atsak'ojui ju ixlacata yuchi vanta lhi'anchach junta vanin ixlhi'alin ju lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Pus ju Jesús taxtulh ju lacpujitat chai alh la'ixchaka' ju Simón. Pus ju ixput'ichako'ulh ju Simón na ixch'apata ju iscacat. Pus tapaininicalh ju Jesús ixlacata ju anu' tak'ank'an. ");
INSERT INTO teeNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Pus ju yuchi taya vanin junta ixma ju tak'ank'an. Chai k'ailh ju scacat. Pus lana macaulh ju iscacat ju tak'ank'an. Chai k'ostavi chai tsuculh alacmavana' ju Jesús chai ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chai acsni anchalh ju avilhchan pus ix'alhiminicanch ju Jesús tachi chun ju tak'ank'anin ju na tijlhu tak'ank'at ixtach'apata. Chai ju Jesús ix'amokslanich ju ixmaca' la'ixlacatuna'an ju pumatamin tak'ank'anin chai palaich ix'anavi. ");
INSERT INTO teeNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Chai vachu' na lhu lhacaticurulhni ixtataxtui la'ixlacatuna'an ju lapanacni. Chai p'as ixtajuni ju Jesús: ―Vasalh ists'alh Dios'at. Para ju Jesús ix'alack'aji. Chai jantu ix'alacasq'uini ni catachivinilh ni ixtac'atsai ni yuchach ju Cristo ju ixnoncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Chai acsni tuncunchokolh pus ju Jesús lana taxtuchokochalhch. Alh junta va aseknic'a. Para ju lapanacni na ixtapuxcajui. Chai tachincha junta ixvilhcha. Chai na ixtach'apa'ulaputun ni jantu ca'alacmacaulh ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Para ju yuchi ajuni: ―Para tasq'uini ni vachu' ac'alh ju ali' lak'achak'anixni. Ac'alh ajunini' ju lapanacni ni Dios lhinomputun la'is'atsucunti'an. Tasq'uini ni chunch aclaya' ni yuchi iclhimalakachacantachilh. ");
INSERT INTO teeNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Pus ju Jesús ix'amalani ju lapanacni laxalacpujitat ju laxa'estado Judea. ");
INSERT INTO teeNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Pus ju Jesús ixyacha vanin la'ixquilhtu' ju atants'in Genesaret. Chai ju lapanacni ni na ilhu'an ixtajunita pus na istasamak'amputun ju Jesús ni vanin ixtatayaputun ni laich catak'asmatnilh ixchivinti Dios ju ix'ajuni. ");
INSERT INTO teeNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pus ju Jesús lakts'ilh lakat'ui barco ju vanin ixlacvi la'ixquilhtu' atants'in. Para ju ixch'apanin pamata ixtatacut'ach ni ixtat'ajun chak'anin ixch'okxni'an. ");
INSERT INTO teeNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Chai ju Jesús putaju lakatam barco ju anchach ixlacvi. Chai ju yuchi ix'anu' Simón ixjunita. Chai ju Jesús tapaininilh ju Simón ni cha taju lacats'unin ju lacxcan ju ixbarco. Chai acsni chunch ju navilh ju Simón pus ju Jesús tsuculh amalanini' ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Chai acsni chivink'olh pus junich ju Simón: ―Alhip'ich ju mimbarco junta palai talaclhman chai amu'ut'ich ju minch'okxni'an ni lai ach'ap'aya'it'it ju pamata. ");
INSERT INTO teeNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Para ju Simón ak'alhtayanalh chai juni: ―Amamaka'unu' tonta ts'isni ju xacmujuyau ju quinch'okxni quinc'an. Para jantu tu'u' icch'apatau. Para ni chunch ju na'un pus acmujuchokoyach ju quinch'okxni. ");
INSERT INTO teeNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Pus acsni tamujulh ju ixch'okxni'an ju Simón chai ixt'ach'alhcatna' pus na lhuch lana tanucha ju pamata. Chai ixtak'exputun ju ixch'okxni'an. ");
INSERT INTO teeNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Pus tatamacyonilh ju ixt'ach'alhcatnin ju ixtatajumanalh lacalakatam barco. Tajuni ni catamilh a'aktaijunin. Pus tamilh chai talaktsama chux lakat'ui barco. Chai ixtaquita'acnuputun ju lakat'ui barco. ");
INSERT INTO teeNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Pus ju Simón Pitalu' acsni lakts'ilh ni na lhu ixjunita ju pamata pus lana ta'aktsokotanilh la'ix'ucxlacapu' ju Jesús chai juni: ―Ak'ost'ich ju laqui'ucxlacapu' ji qui'ucxtin ni na ic'alactu'unu' lapanac ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Chunch ju naulh ju Pitalu' ni na ixlhamak'aninin ju yuchi chai tachi chun ju ix'alact'atajun lacabarco. Talhamak'aninilh ni na lhu ixtach'apata ju pamata. ");
INSERT INTO teeNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Chai vachu' na ixtalhamak'aninin ju Jacobo chai ju Xivan ists'alan ju Zebedeo. Pus ju yu'unch ixt'alamaktainin ju Simón ixtajunita. Pus ju Jesús junilh ju Simón: ―Jantu at'alhan. Tus chavai amak'aixt'ok'a'it'it ju lapanacni ju aquintalhilaca'ana' tachi acsni ixmak'aixt'ok'at'it ju pamata. ");
INSERT INTO teeNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Pus ju acsnich tamacutulh ju ixbarco'an. Tamaconk'olh chux chai tach'ak'ok'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Acsni ixvi ju Jesús lacalakatam lak'achak'an pus lakmilh pumatam lapanac ju ixpacxanta ju macxcai ists'its'i ju ixpuch'i'an. Chai ju yuchi lana taquilhputanilh ju lacat'un la'ix'ucxlacapu' ju Jesús. Chai tapaininilh. Junich: ―Qui'ucxtin ni va xaq'uinc'uch'up'ut'uch cava pus laich xaq'uinc'uch'ut'i. ");
INSERT INTO teeNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Pus ju acsnich ju Jesús mokslanilh ixmaca' la'ixlacatuna chai juni: ―Iclacasq'uin. Palaich'at. Chai acsni naulh ju chunch ju Jesús pus lana macaxnilh ju ists'its'i ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Chai ju Jesús lhimap'aksilh ju anu' lapanac ni jantu xamati' cajunilh tu'u'. Chani ju juni: ―A'inchich t'alac'asunini' ju pali. Axt'akchich ju milhak'ailakts'in ni cac'atsacana' ni salaka ju milacatuna tachi ju najun la'ixlhamap'aksin ju Moisés. ");
INSERT INTO teeNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Para jantu sek va ju anu' lapanac chai palai lhu tac'atsa ixlacata ju Jesús. Chai na lhu ju ixtalhitak'aixt'ok'a ni va ixtak'asmatniputun ju ixchivinti ju Jesús chai palaich ixtajumputun ju va ixtalactak'ank'aich. ");
INSERT INTO teeNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Para ju Jesús ix'an junta aseknic'a. Ix'an t'achivini' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Chai milh avilhchan acsni ixt'ajun amalanini' ju Jesús lacachaka'. Chai vachu' anch ixtavilanalh ju fariseonin chai ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Ju yu'unch ixtamintacha ixlhilacaputs'un ju xalak'achak'anixni ju xa'estado Galilea chai ju xa'estado Judea chai ju lak'achak'an Jerusalén. Chai ju Dios ixtaknita ju Jesús ixtachaput ni laich palai ca'anavi ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Chai ju ali'in lapanacni talhimincha pumatam lapanac lacalona. Ju yuchi va ixlacalhtuculunta. Chai ju yu'unch ixtapuxcajui ta anchach ju laich catapumanu lacachaka' ni laich catamamanilh la'ix'ucxlacapu' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Para jantu jinta' talhitaju junta laich catapumanu ni na is'aktsamcanta lacachaka'. Pus tamuc'alh la'ix'ucxni chaka'. Ta'ucxmak'alh chai anch ju tapumak'alhtaju lacalona ju anu' tak'ank'an. Tamama vanin junta ixvi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Chai ju Jesús acsni alakts'ilh ni na ixtalhilaca'an ju yuchi pus junich ju tak'ank'an: ―Ji lapanac ju mi'alactu'unti mac'acxanicanta. ");
INSERT INTO teeNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Pus ju acsnich ju fariseonin chai ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin tanaulh la'ix'alhunut'an: “Tis chavaich nu' ju ani lapanac ni va macxcai ju najun ni tachi ju Dios ju jumputun. Tis chavaich apumatam ju lai mac'acxai ju alactu'unti. Ni va yuchi jumpala' ju Dios”. ");
INSERT INTO teeNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Para ju acsnich ju Jesús amachakxanilh tuchi ixtapast'ac'ach ju yu'unch chai axak'ala. Ajunich: ―Tajuch ni va chunch ju p'ast'ac'at'it ju lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ni acjunilh ni mac'acxanicalh ju ix'alactu'unti pus jantu lai p'uc'ats'ayat'it ni vasalh alin ju quintachaput u jantu. Para ni acjunilh ni cak'ostavi chai ca'alhtanalh pus ju chunch lai ap'uc'ats'aya'it'it ni alin ju quintachaput u jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pus ju chavai aclamasuniyau ni alin ju quintachaput ju ani lacamunutpa' ni lai icmac'acxai ju alactu'unti. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Pus ju acsnich ju Jesús junilh ju anu' ju ixlacalhtuculunta: ―Uxint'i ju icjunan. Ak'ost'a'ulhch. Asact'ich ju mimputaman. A'inchich ju laminchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chai lana taya ju anu' lapanac la'ix'alac'avanti'an ju yu'unch. Chai saclh ju ixputaman. Chai alh la'ixchaka'. Chai na ixlak'aya'anta ju Dios ju lacati. ");
INSERT INTO teeNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Chai lana na talhamak'aninilh ixchux'an. Chai talak'aya ju Dios. Chai na tatalhanalh. Tanaulh: ―Iclakts'iu lakatam lhamak'an ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chai astan acsni tapasalh ju ani taxtokni pus ju Jesús taxtulh. Chai lakts'ilh pumatam ach'ini' ju Leví ixjuncan. Ju yuchi ixvi junta ix'ach'inin ixlacata ju tu'u' ju ixlhimincanta ju anu' lak'achak'an. Pus ju Jesús juni: ―Aq'uinch'ak'ok'ach. ");
INSERT INTO teeNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Pus ju anu' ach'ini' lana taya chai macaulh ju ixlhich'alhcat chai t'a'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chai astan ju Leví navinilh ju Jesús lakatam lacvaiti ju la'ixchaka'. Chai na lhu ixtamakvilanalh lacamixa ju ixt'a'ach'inin ju Leví chai vachu' na lhu ali'in lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Para ju fariseonin chai ju na ixtalhatalanininta ju lhamap'aksin ju vachu' fariseonin ixtajunita va ixta'alhichivinin ju ix'amamaka'ui ju Jesús. Talacjuni: ―T'as ni va alact'avainat'it chai alact'ak'ot'at'it ju vino ju ach'inin chai ju alactu'unin. ");
INSERT INTO teeNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Chai ak'alhtayanalh ju Jesús. Ajunich: ―Ju lactachapunin jantu tamaktasq'uini ju ac'uch'unu'. Va yu'unch ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jantiyu' iclhiminta ni ac'alact'asanilh ju tanajun ni na lack'oxin lapanacni tajunita. Alai icminta alact'asanini' ju alactu'unin ni catamacaulh ju ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Pus ju fariseonin chai ju na ixtalhatalanininta ju lhamap'aksin ju vachu' fariseonin ixtajunita tajunilh ju Jesús: ―Tajuch ni na paklhu ju tatascajai chai tat'achivinin ju Dios ju ixtamamaka'un ju Xivan. Chai ju quilapanacni quinc'an ju fariseonin icjuntau vachu' chunch talai. Para ju mintamamaka'un ju uxint'i jantu chunch talai. Ju yu'unch tavajin chai tak'ot'a ju vino. ");
INSERT INTO teeNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Chai ju Jesús ajunich: ―Jantu lai amat'asc'a'aya'it'it ju tamakvilanalh junta catamak'axtokcana' acsni makvilhca' ju anu' ts'alh ju catamak'axt'ok'a'. ");
INSERT INTO teeNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pus vana va chunch ju quintamamaka'un. Ju chavai jantu tatascajai ni ic'alact'avilhca'. Para cachina' avilhchan acsni acmak'osucana' ju ani lacamunutpa'. Chai acsnich ju catatascajaya' ni aquintalhamak'anininach. ");
INSERT INTO teeNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chai vachu' ajunilh lakatam chivinti ju ix'apumavasalaniputun tu'u'. Ajuni: ―Jantu lai xamati' k'ex'i ju lacasast'i ixcuju' chai calhilakyaulh ju lacak'at'ili ixcuju'. Ni va chunch calalh pus lak'alhi ju sast'i ixcuju' chai va na jantu k'ox jun ju k'at'ilh ni jantu ixt'achunch junita ju pumpu' ju xalhilakyajui. ");
INSERT INTO teeNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Chai jantu lai xamati' pumujui ju sast'i vino lacak'at'ili axt'ak'an ni na k'alhp'asnica'. Ni chunch canavi pus ju sast'i vino cak'exlh ju axt'ak'an chai ju vino capuk'ank'olh. Chai ju axt'ak'an cats'ank'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Alai pumucan ju sast'i vino lacasast'i axt'ak'an. Ju chunch lai pumak'acan ju sast'i vino ju axt'ak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Chai jantu xamati' ju k'ot'a ju mak'aniya vino ju lai cak'otputulh ju sast'i. Va najun ni palai can ju mak'aniya vino. Chunch ju ajuni ju lapanacni ju Jesús. Va ix'amamachakxaniputun ni jantu lai catilhiyaulh ju mak'aniya ixlhamap'aksin ju Moisés ju sast'i ixlhamap'aksin ju yuchi. Chai ju na lanita ju mak'aniya lhamap'aksin na xcai macomputun ni laich ca'amaklhtayanalh ju sast'i lhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Lakatam avilhchan pa'astacni ju Jesús ixt'ajun tapasana' junta ixch'ancanta ju trigo. Chai ju ix'amamaka'ui ju ixtat'a'anta ixta'ich ju xatrigo chai ixta'ui. Va ixtak'aip'as'ulhi'anta ju la'ixmaca'an. ");
INSERT INTO teeNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Para ju ali'in fariseonin chani tajuni: ―Tajuch ni va naviyat'it ju chunch ni jantu lai ch'alhcatnancan ju chavai ni avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Chai ju Jesús ak'alhtayanalh. Ajunich: ―Ja lana jantu p'ast'ac'at'it tuchi navilh ju David acsni chavanilh ju yuchi chai ju ixtat'a'anta. ");
INSERT INTO teeNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ja jantu p'ast'ac'at'it ni lai tanu junta ixlak'ayacan ju Dios chai ch'apalh ju xkapavati ju ismokslanicanta ju Dios. Chai ulh chai axtaknilh vachu' ju ixtat'a'anta. Chai ju anu' xkapavati jantu lai va k'aya ix'ucan. Va yu'unch ju palijni ju lai ixta'ui. ");
INSERT INTO teeNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Chai vachu' chani ajuni: ―Ju Dios quimalakachatachilh ni lapanac actsucuya' ju ani. Chai quit'in ju lai icnajun tuchi lai navican ju avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chai alakatam avilhchan pa'astacni ju Jesús tanulh la'ixpujitat'an ju ist'a'israelitanin chai tsuculh amalanini'. Chai ju anch ixtanumacha pumatam lapanac ju va ixixnita ju ixmaca' la'ixlhicana. ");
INSERT INTO teeNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Chai ju fariseonin chai ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin va ixtalhistact'ajun ju Jesús. Va ixtalakts'imputun ni lai ca'ac'uch'unulh ju avilhchan pa'astacni. Va ixtapuxconi ta yu laich catapumuc'anilh ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Para ju Jesús isc'atsai tuchi ixtapast'ac'a. Chai junich ju anu' lapanac ju ixixnita ju ixmaca': ―Ak'ost'a'ulh. At'aich ju ani junta laich catalakts'inan ju lapanacni. Pus ju yuchi k'ostaya chai tayalh ju anch. ");
INSERT INTO teeNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Pus ju acsnich ju Jesús ajunich ju lapanacni: ―T'as nonat'it. Ja lhijun ju lhamap'aksin ni canavicalh ju k'ox ju avilhchan pa'astacni u canavicalh ju talak'alhin ni jantu ca'aktaiju tam xamati'. Ja lhijun ni acmak'alhtaxtulh ju atsucunti ju avilhchan pa'astacni u aclakts'imakni. ");
INSERT INTO teeNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pus ju acsnich ju Jesús alakts'ink'o ju ixtayanalh ixlhitalakachoko chai chani ju juni ju anu' lapanac: ―Alhit'ach ju mimaca'. Chai chunch ju navilh ju lapanac chai lana tachapun va ju ixmaca'. ");
INSERT INTO teeNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Para ju fariseonin chai ju ali'in na k'ox talakachapulh la'ixtalhk'amti'an. Chai ixtalaclajunich ju sia lhiyu'unch ta yu catat'alaya' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Pus ju acsnich ju Jesús alh junta ixvilhcha lakatam akstijun. Alh t'achivini' ju Dios. Chai tontats'is ju t'achivinilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Chai acsni tuncunchokolh at'asanilh ju ix'amamaka'ui chai asacxtulh ixpumacaut'ui'an. Chai alaclhilhca'ula ixtamalakachan. ");
INSERT INTO teeNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Pus sacxtulh ju Simón ju lhimapaka'ulh vachu' Pitalu' chai ju Tilix ixlak'au. Chai ju Jacobo. Chai ju Xivan. Chai ju Pilipe. Chai ju Bartolomé. ");
INSERT INTO teeNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Chai ju Mateo. Chai ju Tumax. Chai apumatam Jacobo ju ists'alh Alfeo ixjunita. Chai apumatam Simón ju makyu'unch ixjunita ju cananistanin. ");
INSERT INTO teeNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Chai ju Judas ixlak'au ju Jacobo. Chai ju Judas Iscariote ju astan amak'axtaknalh. ");
INSERT INTO teeNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Chai ju Jesús alact'amilh ixpumacaut'ui'an chai alact'ataya junta na acpujun. Chai vachu' ixtayanalh anch na lhu ali'in ix'amamaka'ui chai na lhu amachak'an ju xa'estado Judea chai ju amachak'an lak'achak'an Jerusalén chai ju lak'achak'anixni Tiro chai Sidón ju ixvilhcha la'ixquilhtu' alama. Ju yu'unch va ixtaminta k'asmatnin ixchivinti ju Jesús. Vachu' palai ixtajumputun ju ixtalactak'ank'ai. ");
INSERT INTO teeNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Chai ju na ixtamak'alhk'ajnan ni ixtapacxanta ju lhacaticuru vachu' palai anavi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pus na lhu lana ixjunita ju tak'ank'anin chai tachi chun ju yu'unch ixtalacach'apaputun ju Jesús ni ix'alin ju ixtachaput chai palai ixtapujun ju chunch. ");
INSERT INTO teeNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Pus ju acsnich ju Jesús lakts'ilh ju ix'amamaka'ui chai ajuni: ―Va paxcat unt'at'it ju uxijnan acsni c'ats'ayat'it ni na makt'asq'uiniyat'it ju Dios. Pus ap'ina'it'it ju lact'iyan junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Va paxcat unt'at'it ju uxijnan ju na lac'asq'uinat'it ju soknic'a atsucunti. Pus chunch cajuna' ju mi'atsucunti'an. Va paxcat unt'at'it ju uxijnan ju na ta'amak'aninin. Pus ju Dios catamak'ank'achayan. ");
INSERT INTO teeNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Va paxcat unt'at'it ju uxijnan acsni cataxcayan ju lapanacni chai acsni jantu catat'a'alhtanamputunan chai acsni catajunan macxcai chivinti chai acsni catanona' ni jantu lack'oxin lapanacni unt'at'it va ixlaca'atalh ni quilalhilaksiyau ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Pus alhik'ach'ant'it acsni chunch cata'ulhtuyan. Slivasalh na k'ox alhiulat'it. Pus chunch alat'it ni slivasalh na k'ox ju axt'aknic'ana'it'it ju lact'iyan. Pus ju mak'aniya ixlacpa'itni'an ju lapanacni ju chunch ta'ulhtuyan vana va chun ixta'ulhtui ju mak'aniya ixlapanacni Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Para paini'itnich ju uxijnan ju nonat'it ni jantu makt'asq'uiniyat'it ju Dios. Pus va ani lacamunutpa' ju ca'alina' ju mink'achat'an. Ju astan jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Paini'itnich ju uxijnan ju nonat'it ni na k'ox ju chavai ju mi'atsucunti'an. Pus ju astan ac'ats'aya'it'it ni mak'anc'acxnitan ju ixtak'oxinti ju mi'atsucunti'an. Paini'itnich ju uxijnan ju na k'ach'anat'it ju chavai. Ju astan na ak'alhuna'it'it chai amak'aninina'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Paini'itnich ju uxijnan acsni chux ju lapanacni catanona' ni na lack'oxin lapanacni unt'at'it. Pus ju mak'aniya ixlacpa'itni'an ju lapanacni ju chunch tajunan vana va chun ixtajuni ju mak'aniya lapanacni ju ixtalhitalacasui tachi ju ixlapanacni Dios mas jantu. Pus ni vana va chun tajunan ju uxijnan pus tasui ni jantu slivasalh ixlapanacni Dios unt'at'it vachu'. ");
INSERT INTO teeNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Para ju uxijnan ju quilak'asmatniyau iclajunau ni amap'ainit'it ju mint'alaxcai'an. Chai anavinit'it k'ox ju na taxcayan. ");
INSERT INTO teeNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Asq'uint'it ju k'ox is'atsucunti'an ju macxcai tajunan. Chai at'ap'aininit'it ju Dios ixlacata'an ju talhimacchapuyan. ");
INSERT INTO teeNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Acsni xamati' cata'ulaniyan ju lamilakxtan'an axt'aknich'ok'ot'it ju mintalakxtantam'an. Chai ni xamati' catachivimak'anan chai catatai'iniyan ju mincutun'an pus vachu' jantu alhik'a'it'it ju mimpumpu'an. ");
INSERT INTO teeNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ni xamati' catasq'uiniyan ju tu'u' pus jantiyu' ju jantu axt'aknip'ut'ut'it ni va mak'ap'ut'unat'it mi'akstu'an. Chai ju catalhi'aniyan ju tu'u' ju mi'anu'an junita pus jantu va tachi asq'uinich'ok'ot'it. ");
INSERT INTO teeNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pus ni lac'asq'uinat'it ni k'ox cata'ulhtuyan ju mint'alapanacni pus vachu' k'ox a'ulht'ut'it ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Pus ni va yu'unch ju amap'ainiya'it'it ju tamapainiyan pus ja navit'at'it tu'u' ju k'ox. Pus mas yu'unch ju na ta'alactu'unun vachu' tamapaini ix'amigojni'an. ");
INSERT INTO teeNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Chai ni va yu'unch ju anavinit'it k'ox ju tanaviniyan k'ox pus ja navit'at'it tu'u' k'ox. Pus mas yu'unch ju alactu'unin vana va chun tanavi. ");
INSERT INTO teeNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Chai ni va yuchi ju alhimach'ixt'akt'it ju mintumin'an ni va ap'ulha'at'it pus ja k'ox calhiulaya' ju Dios ju chunch. Pus mas yu'unch ju alactu'unin tamach'ixtakni ju ixtumin'an ju ixt'a'alactu'unin ni va tapulhajaputun. ");
INSERT INTO teeNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Alai amap'ainit'it ju mint'alaxcai'an. Anavinit'it ju k'ox chai amach'ixt'aknit'it ju mintumin'an chai jantu alhamak'aninint'it u ni axt'aknich'ok'oc'ana'it'it u jantu. Chai ni chunch ju anaviya'it'it pus na lhu cajuna' ju mintalhaja'an chai catasuya' ni vasalh is'ask'at'an Dios unt'at'it. Pus ju yuchi anavini ju k'ox ju jantu tavanan tajuni lak'ailakts'iuch chai ju na k'ai tajunita. ");
INSERT INTO teeNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Pus anavit'it ju lamapainin tachi ju mimpai'an Dios ni vachu' navi ju lamapainin. ");
INSERT INTO teeNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jantu ana'unt'it ni talak'alhin ju xanavi ju ak'antam. Ni chunch ju alat'it pus ju Dios canona' ni vachu' navit'at'it talak'alhin ju uxijnan. Jantu a'ulanit'it ixtalak'alhin ju ak'antam chai ju chunch jantu vachu' a'ulanic'ana'it'it ju mintalak'alhin'an. Amac'acxanit'it ju ak'antam chai vachu' ju Dios catamac'acxaniyan ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Axt'aknit'it ju tamaktasq'uini ju tu'u' chai ju Dios vachu' cataxtakniyan ju uxijnan. Chai lacak'ox alhcanti ju axt'aknic'ana'it'it chai k'ox casajucana' chai cac'alhajucana' chai ca'alhpaxach. Pus tuch'i anaviya'it'it ju ak'antam pus vana va chun ju anavic'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Chai ju Jesús ajuni alakatam chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. Chani ju ajuni: ―Ju tam alak'ach'ix jantu lai catip'ulhni ju ixt'a'alak'ach'ix. Ni chunch canavi pus va k'aixtam catint'a'alh junta puculhucnic'a. ");
INSERT INTO teeNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ju tam amamaka'unti jantiyu' ju palai k'ai. Yuchi ju palai k'ai ju tam amamaka'unu'. Para va tichi chavaich ju na k'ox masunicanta pus va ixt'achunchach cajuna' tachi ju ix'amamaka'unu'. ");
INSERT INTO teeNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Tajuch ni na naviyat'it cuenta ju tu'u' lacat'icst'i talak'alhin ju navi pumatam milhilak'au para lana jantu naviyat'it cuenta ju k'ai talak'alhin ju naviyat'it mi'akstu'an. Ni chunch ju layat'it pus ixt'achunch unt'at'it tachi tam lapanac ju cajunilh ak'antam ni tanun ju lacat'icst'i amacxtalh la'ixlakchulh mas tanun ju palai k'ai amacxtalh la'ixlakchulh is'akstu. ");
INSERT INTO teeNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Chai tas laich a'unit'it ju tam milhilak'au: “Alak'a'it'ich ni ac'aktaijuyan ni amacona' ju talak'alhin ju navi”. Tas laich chunch a'unit'it ni jantu naviyat'it cuenta ju k'ai talak'alhin ju naviyat'it ju uxijnan. Pus acsni chunch ju layat'it pus ixt'achunch unt'at'it tachi tam lapanac ju cajunilh ak'antam: “Acmaxtuniyanch ju lacat'icst'i amacxtalh ju tanun lamilakchulh”. Laich chunch juni mas palai k'ai amacxtalh ju tanun la'ixlakchulh is'akstu. Para ju uxijnan acsni chunch ju layat'it pus va acxp'ut'iyununat'it. Pus p'ulhnan amac'a'unt'it ju k'ai talak'alhin ju naviyat'it. Chai ju chunch lai a'akt'ai'uya'it'it ju milak'au'an ni camacaulh ju lacat'icst'i talak'alhin ju navi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ju tu'u' k'oxi q'uiu jantu lai catixtaklh ju xalhi'ut ju jantu k'ox. Chai ju tu'u' q'uiu ju jantu k'ox jantu lai catixtaklh ju k'oxi xalhi'ut. ");
INSERT INTO teeNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pus tachi chun ju q'uiu lhimispacan ju xalhi'ut. Jantu lai toc'ai ju capen laca'alhtucunan. Nin lai catitoc'alh ju uvas laca'ach'itinan. ");
INSERT INTO teeNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Pus vana va chun tam lapanac. La'ixchivinti putasui tichi lapanac junita. Pus tam xamati' ju na k'ox lapanac junita na k'ox cachivina' ni yuchi ju k'ox ju alin la'ix'alhunut. Para tam lapanac ju na k'ai junita pus na macxcai cachivina' ni va yuchi ju jantu k'ox ju alin la'ix'alhunut. Pus tuchi alin la'ix'alhunut ju pumatamin pus chunchach ju chivinin. ");
INSERT INTO teeNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Tajuch ni va quilalhixak'alayau ucxtin para jantu naviyat'it tuchi iclalhijunau. ");
INSERT INTO teeNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Pus tachi chun ju quintalakmin chai quintak'asmatni ju quinchivinti chai tanavi tachi ju icnajun pus chani tajunita. ");
INSERT INTO teeNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Pus va ixt'achunchach tajunita tachi ju tam lapanac ju yaulh ixchaka'. Pus talhman lana ju pucutulh tus lhitajulh ju chiux chai la'ix'ucxni ju anu' chiux ju yaulh ju xatantun ixchaka'. Chai acsni navik'olh ju ixchaka' pus astan milh lakatam akmuxtut. Chai na p'as ju neklh ju ani chaka'. Para jantu lai lacchiquixlh ni la'ix'ucxni chiux ixch'antai. ");
INSERT INTO teeNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Para va tichi chavaich ju k'asmat'a ju quinchivinti para jantu muctaxtui pus ju yuchi chunch junita tachi ju apumatam lapanac ju vachu' yaulh ixchaka'. Para ju yuchi jantu talhman pucutulh junta xayajui ju xatantun ixchaka'. Pus acsni na p'as neklh ju xcan pus lana maktalh. Lana tak'alhik'o ju anu' chaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Chai acsni ajunk'o ju ixchivinti ju lapanacni pus ju Jesús tanulh ju lak'achak'an Capernaum. ");
INSERT INTO teeNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chai ju anch ixvi pumatam capitán ju romano ixjunita. Chai ju yuchi ix'alin pumatam ixlapanac ju na ixmapaini. Para na ixtak'ank'ai chai na ixniputun. ");
INSERT INTO teeNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Pus ju anu' capitán acsni k'asmatli ixlacata ju Jesús pus amalakachalh ju xapapanin israelitanin ni cata'alh tapaininin ju Jesús ni camilh c'uch'unu' ju ixlapanac. ");
INSERT INTO teeNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Pus ju yu'unch talak'alh ju Jesús chai slivasalh tatapaininilh. Tajunich: ―Ju yuchi na k'ox lapanac junita. Lhijunch ni anaviniya' ju ani lamapainin. ");
INSERT INTO teeNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ju yuchi na tu'u' quintalhiulayan ju quijnan'an ju israelitanin juntau. Chai vachu' is'akstu lhinaulh ixyajuca quimpujitat quinc'an. ");
INSERT INTO teeNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Pus ju Jesús alact'a'alh ju yu'unch. Para acsni vanin ix'alact'acha'amputun la'ixchaka' ju anu' capitán pus ju yuchi amalakachalh ju ix'amigojni. Chai acsni talakchilh ju Jesús chani tajuni: ―Ji ucxtin ma va jantu jeks mavaputunan ju yuchi ju quintamalakachatachin. Pus ju yuchi ma jantu tu'u' ixtapalhni ni ma laich at'it'anuchi' la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Pus ma yuchi jantu xalhimimputunan t'asaninin is'akstu ni ma va jantu tu'u' lhiulachokocan is'akstu. Para ma mas va anauch ju chivinti chai palai cajuna' ju ixlapanac. ");
INSERT INTO teeNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Pus ju yuchi ma c'atsai ni lai chunch catapasaya' ni vachu' alin ju talhijuni. Chai ma vachu' na lhu alin ju ixtaropajni ju alhijuni ju yuchi. Chai acsni ma junich ju pumatam: A'inchich. Pus ma an. Chai ni ma juni apumatam: At'at'i. Pus ma minch. Chai acsni ma juni ju ixlapanac: Anavit'ich ju ani. Pus ma navich. Pus ju anu' capitán ix'alhijunita ju ix'amigojni ni chunch ju catanaulh ni isc'atsai ni taquiclaca'ini ju Jesús tachi chun ju taxtokni ni yuchi ju xak'ai tucan junita. ");
INSERT INTO teeNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Chai ju Jesús acsni ak'asmatnilh ju ixchivinti'an na lhamak'aninilh. Chai alakts'ilh ju lapanacni ju ixtach'ak'ok'ata chai ajuni: ―Slivasalh ju iclajunau. Jantu iclhitajuta nin pumatam quint'a'israelita ju aquilhilakts'ilh tachi ju lai ju ani lapanac. ");
INSERT INTO teeNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Pus ju yu'unch ju ix'amalakachacanta ta'anchokolh la'ixchaka' ju capitán. Chai acsni tacha'anchokolh talakts'ilh ju tak'ank'an ni tachapunch junchokota. ");
INSERT INTO teeNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Chai acsni tapasalh lakatam lakat'ui avilhchan pus ju Jesús ix'amputun ju lak'achak'an Naín. Ixtat'a'anta na lhu ix'amamaka'ui chai na lhu ali'in lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Chai acsni ixcha'amputun vanin junta putanucanacha ju lak'achak'an pus apakxtoklh lhu lapanacni. Va ixlhi'ancanta campusantu pumatam alasanin. Yuchi ju lakatami ists'alh ixjunita ju ixnati chai ju yuchi ixnimacontilacanta. Pus na lhu ixtat'a'anta ju chako'ulh ju ixt'a'amachak'anch. ");
INSERT INTO teeNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Pus ju ucxtin Jesús acsni lakts'ilh ju anu' chako'ulh na mapaini chai junich: ―Jantu ak'alhu. ");
INSERT INTO teeNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Chai ju Jesús stalh lak'alh ju ixp'aklat ju ts'alh chai ucxch'apalh. Pus tamast'ac'a ju ix'akxk'ok'anin. Chai ju Jesús junilh ju alasanin: ―Ts'alh uxint'i ju icjunan. Ak'ost'a'ulh. ");
INSERT INTO teeNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Chai lana k'ostavilh ju anu' ixnita. Chai tsuculh chivini'. Pus ju Jesús xtaknichokolh ju ixnati. ");
INSERT INTO teeNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pus slivasalh na tatalhanalh ixchux'an ju lapanacni. Chai talak'ayalh ju Dios. Chai ixtanajun: ―Talacasulh laquilhiquijnan'an pumatam k'ai lapanac ju najun ixchivinti Dios. Vachu' ixtanajun ni Dios xalakmin ju ixlapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pus lacc'atsak'ocalh ixlhilacaputs'un ju xa'estado Judea chai ixlhilacaputs'un ju xalacat'un ju ixt'alach'apata. ");
INSERT INTO teeNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Chai junta ixt'alhnucanta ju Xivan pus ixtamamaka'un talhicha'anilh chivinti ixlacata tachi chun ju ani taxtokni ju ixnavi ju Jesús. Pus ju Xivan at'asanilh pumat'ui ixtamamaka'unti. ");
INSERT INTO teeNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Chai amalakachanilh ju Jesús. Chai ajuni: ―Chanich a'una'it'it: Ja ma uxint'i ju noncan ni camina'. U ma acpacxanchokoyau apumatam. ");
INSERT INTO teeNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Pus ju anu' lapanacni talakmilh ju Jesús chai tajunilh tachi ju ix'ajuncan. Tajunilh ju Jesús: ―Quintamalakachachin ju Xivan ju amakpaxana' ni ma aclamiu sacminin ju uxint'i. Ja ma uxint'i ju caminach noncan u ma acpacxanchokoyau apumatam. ");
INSERT INTO teeNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pus ju anuch pants'iquis na lhu ju palai anavi ju Jesús ju ixtalactak'ank'ai chai ju na ixtamak'alhk'ajnan. Chai axcoxtulh ju lhacaticurulhni ju ixtatanun la'ixlacatuna'an ju ali'in lapanacni. Chai alacmalac'avani na lhu ju alak'ach'ixnin ixtajunita. ");
INSERT INTO teeNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tus acsnica' ju ak'alhtayanalh ju Jesús. Ajunilh ju ixtamalakachan ju Xivan: ―A'inch'ok'ochit'itch juninin ju Xivan tuch'i ju xalakts'inat'it chai ju tuch'i xak'asmat'at'it. A'una'it'it ni ta'alac'avanan ju alak'ach'ixnin ixtajunita. Chai ju va ixtak'alhinita ixch'aja'an sok ta'alhtanan. Chai ju va ixtapacxanta ju ts'its'i ju na puch'i'an talaclacamacaxlich. Chai ju k'atapa ixtajunita laich tak'asmat'a. Chai ju tanita amalok'onichokocalh. Chai ju quilhpatinin ajunicalh ta yu laich cataputak'alhtaxtulh. ");
INSERT INTO teeNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Vachu' a'unit'it ni lhik'ach t'ajun ju tam lapanac ju jantu astan najun ni jantu quinch'ak'ok'aputun. ―Chunch ju ajunicalh ju ix'amamaka'ui ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Chai acsni ta'anchokolh ju ix'alhtanin ju Xivan pus ju Jesús lana tsuculh alacsacmini' ju lapanacni ixlacata ju Xivan. Ajunich: ―Tis chavaich ju ixlakts'imp'ut'unat'it junta q'uilat'it lacamacni. C'ats'ayat'it ni jantiyu' q'uilat'it ju anch ni va alakts'imp'ut'ut'it tam lapanac ju va tam tam najun tachi ju lai ju tu'u' xaxk'oi actiyac acsni lacatam lacatam sun lhi'an ju un. ");
INSERT INTO teeNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pus tis chavaich ju ixlakts'imp'ut'unat'it junta q'uilat'it. C'ats'ayat'it ni jantiyu' ju lhiq'uilat'it ju anch ni va alakts'imp'ut'ut'it tam lapanac ju na va k'ox camalakch'inilh. Pus ju na k'ox tamalakch'ininta chai ju jantu tu'u' c'acxni tatanumanalh la'ixchaka'an ju xalack'ajin ucxtinin. ");
INSERT INTO teeNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pus tis chavaich ju ixlakts'imp'ut'unat'it junta q'uilat'it. C'ats'ayat'it ni va ixlakts'imp'ut'unat'it ju lapanac ju najun ixchivinti Dios. Chai iclajunau ni vasalh chunch junita ju Xivan. Para palai k'ai lhich'alhcat ju xtaknicanta ju yuchi. Palai jantu va tichi lapanac ju najun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ju Xivan yuchi ju pastaccan acsni chani xats'ok'ulacan la'ixchivinti Dios junta chani najun: Acmalakachaya' ju quilapanac ju p'ulhnan ca'ana'. Astan ju uxint'i. Yuchach ju ca'alak'oxiniya' ix'alhunut'an ju lapanacni ni cata'amaklhtayananan acsni ach'ip'ina'. ");
INSERT INTO teeNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Para iclajunau ni tus chavai jantu alinta tam xamati' ju palai xak'ai cava. Va yuchi ju Xivan ju amakpaxana'. Para va tichi chavaich ju jantu tu'u' lhiulacan la'ixmacni'an ixt'alapanacni yuchach ju palai k'ai cajuna' ju lact'iyan junta lhinajun ju Dios. Palai jantu na chun junita ju Xivan ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Pus tachi chun ju lapanacni chai ju ach'inin acsni tak'asmatnilh ixchivinti ju Xivan ta'akpaxlh. Pus chunch ju taputalacasulh ni sok ixtalhiulai tachi ju ixnavi ju Dios acsni ixnajun ni catamacaulh ix'alactu'unti'an chai cata'akpaxlh. ");
INSERT INTO teeNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Para ju fariseonin chai ju na ixtalhatalaninin ju ixlhamap'aksin'an ju ist'a'israelitanin jantu ixtalacasq'uin ni ca'amakpaxalh ju Xivan. Pus ju chunch tasamak'alh tuchi ispastacta ju Dios ixlacata ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Pus ju Jesús ajuni ju lapanacni: ―Tis chavaich nu' ju va ixt'achunch lai aclanaviniyau ju uxijnan ju t'onat'it ju chavai. Tijuch nu' ju va mint'achunch cava. ");
INSERT INTO teeNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Pus ca laich acnaulh ni ixt'achunch unt'at'it tachi ju ask'at'an ju tak'amanan laclhitamau. Pus ju quilhmactam chani talajuni ju aquilhmactam: “Ju quijnan xacsk'olau para jantu xa'at'ininat'it ju uxijnan. Chai icmilhpauch ju amak'aniti para sin chunch jantu xak'ach'aniyat'it ni jantu xalack'alhunat'it”. Chunch talaclajuni ju ask'at'an. Chai vana va chun ju layat'it ju uxijnan ju t'onat'it ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pus acsni tavanan milh ju Xivan ju amakpaxana' pus ju yuchi jantu ixvajin tachi ju venat'it chai jantu ixk'ot'a ju vino. Chai ju uxijnan ixnonat'it ni va ixpacxanta ju lhacaticuru. ");
INSERT INTO teeNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Chai icminta ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Chai ju quit'in icvajin tachi ju venat'it chai ick'ot'a ju vino chai ju uxijnan nonat'it ni va chavani lapanac chai va ak'otnu lapanac icjunita. Nonat'it ni va ix'amigo ju ach'inin chai ju alactu'unin icjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Para ju vasalh ta'ac'atsananta tanajun ni akts'iya k'ox tuchi navi ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Pus pumatam fariseo tapaininilh ju Jesús ni cat'availh. Chai ju Jesús t'atanulh la'ixchaka' chai t'atapakstitama ni chunch ju ixtalhilanitach acsni ixtavajin. ");
INSERT INTO teeNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Chai ix'alin ju anu' lak'achak'an pumatam chako'ulh ju na ix'alactu'unun. Pus ju yuchi acsni c'atsa ni anchach ixtapakstitamai ju Jesús la'ixchaka' ju anu' fariseo pus vachu' tanucha lacachaka'. Chai lhimilh lakatam lumeti ju ixlhinavicanta chiux ju ixputajun ju c'uch'u ju na c'us acamin. ");
INSERT INTO teeNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Chai taya la'ixpulacan ju Jesús junta ixch'an'anta. Chai tsuculh k'alhunu'. Chai ju ixlakpuk'alhut ixtoc'aniyacha la'ixch'aja' ju Jesús. Chai ixpuch'anxacai ju ix'ai. Chai ixch'anch'uch'ui chai ixch'anmuc'ai ju ixc'uch'u ju na c'us acamin. ");
INSERT INTO teeNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Para acsni lakts'ilh ju anu' fariseo ju ixk'ailhiminta ju Jesús la'ixchaka' pus chani ju pastaclh la'ix'alhunut: “Ju ani ni vasalh cava ju lapanac ju najun ixchivinti Dios pus ca'ismispa tichi chavaich chai ta junita ju is'atsucunti ju anu' chako'ulh ju t'ajun lacach'apana'. Ca'isc'atsa ni va alactu'unu' junita”. ");
INSERT INTO teeNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Pus ju acsnich ju Jesús chani junilh ju anu' fariseo: ―Simón va icjumputunan lakatam chivinti. Chai ju anu' fariseo junich: ―Aq'uin'unch ji amamaka'unu'. ");
INSERT INTO teeNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Chai ju Jesús juni: ―Pumatam lapanac ju ixmach'ixt'ak'a tumin ix'amach'ixtaknita pumat'ui lapanacni. Ju pumatam ixlhi'ani lakaquis cientos. Chai ju pumatam ixlhi'ani cincuenta pexu. ");
INSERT INTO teeNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Para ni jantu tu'u' ixtamak'ata ju lai catalhimapalhnichokolh pus ju ix'amach'ixtaknita ju tumin va amac'acxanilh ju ixt'iyun'an. Pus aq'uin'unch. Tis chavaich ju palai camapainiya' ju ixt'iyun'an ju anu' xamach'ixtakni ixtumin. ");
INSERT INTO teeNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Chai ju Simón juni: ―Pus ca yuchi ju palai laklhu ixlhi'ani. Chai ju Jesús juni: ―Stavasalanti ju xak'alht'ayanan. ");
INSERT INTO teeNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ju acsnich ju Jesús lakts'ilh ju chako'ulh chai junich ju Simón: ―Alakts'ich ju ani chako'ulh. Uxint'i ju xaq'uink'ailhit'ant'a ju ani laminchaka' para jantu xaq'uixt'akni ju xcan ju xaclhich'anchak'alh. Para ju ani chako'ulh quinch'anchak'alh la'ixlakpuk'alhut chai quinch'anxacalh ju la'ix'ai. ");
INSERT INTO teeNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Chai ju uxint'i jantu xaq'uimacch'uch'ui. Para ju yuchi tus acsni xactanuyacha laminchaka' va tachi quinch'anch'uch'uich. ");
INSERT INTO teeNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ju uxint'i jantu xaq'uilacpamuc'ai ju aceite. Para ju yuchi quinch'anmuc'alh ju c'uch'u ju na c'us acamin. ");
INSERT INTO teeNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Pus yuchi iclhijunan ni slivasalh na quimapaini ju yuchi ni icmac'acxanilh ju ix'alactu'unti mas na lhu ixjunita. Para na lacats'unin amapaininin ju va lacats'unin mac'acxanicanta. ");
INSERT INTO teeNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Pus ju acsnich ju Jesús chani junilh ju chako'ulh: ―Icmac'acxanin ju mi'alactu'unti ju ixnavit'a. ");
INSERT INTO teeNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Pus ju acsnich ju va k'aixtam ix'alact'avajin ju Jesús tanaulh la'ix'alhunut'an: ―Tis chavaich nu' ju ani ni vachu' lai mac'acxai ju alactu'unti. ");
INSERT INTO teeNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Para ju Jesús junilh ju chako'ulh: ―Ni xaq'uilhilaksi pus chavai t'ak'alht'axt'ut'ach. Inchich chai lhik'ach ats'uc'u. ");
INSERT INTO teeNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Chai astan ju Jesús ucsuntsuculh chux ju k'ai lak'achak'anixni chai ju lact'icst'i lak'achak'anixni. Ix'amalaninin chai ix'ajuni ju lapanacni ni ixlhinomputun ju Dios la'ix'alhunut'an. Chai ju ixpumacaut'ui'an ix'amamaka'ui ixtat'a'anta. ");
INSERT INTO teeNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Chai vachu' ix'alact'a'anta ju ali'in chakolun ju ix'ac'uch'uta acsni ixtalactak'ank'ai chai ju ali'in axcoxtunicalh ju lhacaticurulhni ju ixtatanun la'ixlacatuna'an. Pus sia yu'unch ju ixtat'a'an ju Jesús yuchi ju Malia amachaka' Magdala. Yuchi ju maxtunicalh pumatujun lhacaticurulhni la'ixlacatuna. ");
INSERT INTO teeNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Vachu' ixt'a'anta ju Juana ix'amachaka' ju Chuza ju ixlapanac ixjunita ju Herodes ju gobernador ixjunita. Vachu' t'a'alh ju Susana chai na pumalhu ali'in chakolun ju ixtalhi'aktaijui ix'alinta'an la'ixmaktasq'uinit'an ju Jesús chai ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Pus na lhu lapanacni ixtalakmin ju Jesús ju ixtamintacha lakatamin lak'achak'an. Chai acsni na lhu ixtatak'aixtokta pus ju Jesús ajuni lakatam chivinti ju ix'alakts'ipaxcavaich ju tu'u'. Pus chani ju ajuni: ");
INSERT INTO teeNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Pumatam ach'anana' alh lhavana' ju ix'ach'ananti. Chai acsni lhavanalh ju ix'ach'ananti pus ju ali' ju xat'in va la'ixquilhtu' ti tama. Chai ju ali' putayacalh chai ju ali' tasac'ulh ju ts'ok'o. ");
INSERT INTO teeNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Chai ju ali' ju xat'in tamacha la'ix'ucxni chiux junta va lacats'unin ix'alin ju t'un. Pus acsni p'unlh pus lana xixlh ni jantu ixk'ajuta ju t'un ju anch. ");
INSERT INTO teeNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Chai ju ali' ju xat'in tamacha junta vachu' ixma ju xat'in alhtucunu'. Pus p'ulhnan tak'aya ju alhtucunu' chai akxtakma ju anu' ach'ananti. ");
INSERT INTO teeNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Chai ju ali' ju xat'in tamacha lacak'oxi t'un. P'unlh. Chai acsni tak'aya pus na k'oxich xtaklh ju xatoc'at. Chai tachi ju ch'ancalh pus talhava tam cientos. Pus acsni nonk'o ju ani chivinti pus ju Jesús na p'as chivinilh. Ajuni ju lapanacni: ―Tichi chavaich ju alin ixpak'asmatni cak'asmatlh. ");
INSERT INTO teeNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Pus ju acsnich ju ix'amamaka'ui tasacmilh ju Jesús. Tajuni: ―Tijuch ju nomputun ju chivinti ju xana'un. ");
INSERT INTO teeNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Chai ju Jesús alacjuni: ―Ju Dios lak'a'i ni amach'akxaya'it'it ju chivinti ju najun ni lhinomputun ju Dios la'is'atsucunti'an ju lapanacni. Para ju ali'in ic'alhixak'alai lacatu'u' chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. Chunch iclai ni jantu catitamispa tuchi nomputun mas talakts'in tuchi icnavi. Chai jantu catitamachakxa mas tak'asmat'a ju quinchivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Pus ju chivinti ju xacnajun chani ju nomputun. Ju xat'in yuchi ju ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Chai ju t'in ju tamacha lacati yu'unch ju tak'asmat'a ju ixchivinti Dios para lana min ju lhacaticuru chai amac'ap'ani ju chivinti ju ix'ach'ananicanta la'ix'alhunut'an ni jantu catalaca'iya' chai jantu catatak'alhtaxtuya'. ");
INSERT INTO teeNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Chai ju t'in ju tamacha la'ix'ucxni chiux yu'unch ju tak'asmat'a ixchivinti Dios chai lana soko tak'achani. Para chunch tajunita tachi ju anu' xap'un la'ix'ucxni chiux. Jantu la'ixlhichux ix'alhunut'an ju ta'amaklhtayanan. Va pants'iquis ju talaca'i. Para acsni tamak'alhk'ajnan ixlacata ju chivinti pus lana tamacajun ixti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Chai ju t'in ju tamacha junta ix'alin ju xat'in alhtucunu' pus yu'unch ju tak'asmat'a ju ixchivinti Dios. Para lacsni lacsni tac'ap'a va ixlaca'atalh ni na lhu alin ju xataxtokni ju ani lacamunutpa' ju talhamak'aninin. Chai na tak'achani ju ixmak'alit'an chai na k'ox talhiulai ju ixk'achat ju ani lacamunutpa'. Pus jantu tavanan vasalh tasui ixtachaput ju Dios la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Para ju t'in ju tamacha lacak'oxi t'un yu'unch ju tak'asmat'a ju ixchivinti Dios chai ixlhichux ix'alhunut'an talaca'ik'alhi. Chunch talai ni na k'ox ju ix'alhunut'an tachi ju k'achani ju Dios. Chai tach'ixa va tuchi min la'is'atsucunti'an chai slivasalh tasui ixtachaput ju Dios la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Acsni xamati' xavai ju ixmaclhcu jantu va pu'akxtak'ulai tu'u' xalu. Nin yuchi ni lai ca'ula la'ixtank'apu' putaman. Alai anch ju muc'ai junta akts'iya muc'acan ju maclhcu. Chai ju chunch tachi chun ju catatanuyach cata'alac'avanana'. ");
INSERT INTO teeNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Pus chunchach vachu' ju quinchivinti. Mas va mi'akstu'an xaclamavasalaniyau ju chivinti para astan amac'ats'aniya'it'it ju lapanacni. Chai ju tuchi chivinti ju jantu amamachakxanican ju ixtalhavat'an lapanacni pus uxijnan ju amac'ats'aniya'it'it chai catamachakxaya'. Chai ni chunch ju alaya'it'it pus tachi ju va calhcuya' ju maclhcu la'ix'alhunut'an ni laich catamachakxaya' ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Para ni lai chunch ju alaya'it'it astan pus tasq'uini ni p'ulhnan k'oxich ak'asmat'a'it'it. Pus va tichi chavaich ju k'asmat'a chai navi tachi ju najun la'ixchivinti Dios pus palai lhu camamachakxanicana'. Para va tichi chavaich ju cak'asmattsuculh para ni jantu canaviya' ju tuchi najun la'ixchivinti Dios pus camac'ap'anik'oyach tuchi na mispaich najun. ");
INSERT INTO teeNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Pus astan talakmilh ju Jesús ju ixnati chai ix'ap'isek'en. Para jantu lai stalh ixtalak'an ni na lhu ixjunita ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Chai pumatam chani juni ju Jesús: ―Ju minati chai ju mi'ap'isek'en tayanancha makspa'. Va talakts'imputunan. ");
INSERT INTO teeNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Para ju Jesús alacjuni: ―Ju vasalh quinati tajunita chai vasalh qui'ap'isek'en tajunita yu'unch ju tak'asmat'a ju ixchivinti Dios chai tamuctaxtui tachi ju najun ju anch. ");
INSERT INTO teeNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Chai milh avilhchan acsni tat'ataju ju Jesús ju ix'amamaka'ui lacabarco. Chai ju yuchi ajuni: ―Catapasauch ju lhimak'antacutni atants'in. Chai ta'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Para acsni ixta'antaca' ju lacxcan pus ju Jesús lana lhtatalh. Chai k'ostaya ju k'ai un chai na p'as tanek'alh ju xcan chai ixqui'akpaxputun ju barco. Chai na ixtamuxtuputunch. ");
INSERT INTO teeNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Pus ju ix'amamaka'ui talak'alh ju Jesús chai tamaklok'o. Tajunich: ―Amamaka'unu' na muxtuputunauch. Pus ju Jesús k'ostavi. K'ailh ju un chai ju xcan. Chai lana va sek tavi ju xcan chai na sekch avanalh. ");
INSERT INTO teeNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Chai ju Jesús ajunich ju ix'amamaka'ui: ―Tajuch ni jantu quilalhilaca'anau. Para ju yu'unch na ixtatalhanan chai na ixtalhamak'aninin. Chai talaclajunich ju sia yu'unch: ―Tis chavaich nu' ju ani. Mas yuchi ju un chai ju xcan ni ak'aji si taquiclaca'i. ");
INSERT INTO teeNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ju Jesús chai ix'amamaka'ui tatacutcha la'ixt'un'an ju amachak'an Gadara. Ju anch ixt'alalaca'anita ju xa'estado Galilea ju lhilak'antacutni laca'atants'in. ");
INSERT INTO teeNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Chai acsni tayacha ju lacat'un ju Jesús pus lana quipakxtokchilh pumatam amachaka' ju anu' lak'achak'an. Ju yuchi ixpacxanta ju lhacaticurulhni. Chai na mak'an jantu ixmalakch'ininta. Chai jantu ixvi la'ixchaka'. Va campusantu ix'ucxunt'ajun. ");
INSERT INTO teeNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Pus ju yuchi acsni lakts'ilh ju Jesús ts'au t'asalh. Chai lana taquilhputanilh ju la'ix'ucxlacapu'. Chai ju lhacaticurulhni na p'as tachivinilh la'ixquilhni ju anu' lapanac acsni chani tajuni ju Jesús: ―Tijuch ju quilamintau lhilakts'inin ju uxint'i ji Jesús. Ju uxint'i ists'alh'at Dios ju vilhcha lact'iyan. Iclatapaininiyau ni jantu aquilamamak'alhk'ajniu. ");
INSERT INTO teeNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Pus chunch ju tanaulh ju lhacaticurulhni ni ix'alack'aimatach ju Jesús. Ix'ajunita ju yu'unch ni catataxtulh la'ixlacatuna ju lapanac. Pus acsni tuca' ix'ak'ajita ju Jesús ju lhacaticurulhni pus na paklhu ixtach'apata ju anu' lapanac. Chai mas ixlacach'imacanta lacacadena chai ixch'ant'alhmacanta para acsni ixtatanui ju lhacaticurulhni la'ixlacatuna pus ixlack'ex'ulak'ojui ju ixpulacach'imacan. Chai ju lhacaticurulhni ixtak'ailhi'an junta va aseknic'a junita. ");
INSERT INTO teeNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Pus ju Jesús sacmilh ju anu' lapanac. Junich: ―T'is unc'anch. Chai ju yuchi juni: ―Legión icjuncan. Pus lhinaulh chunch ni na lhu ixpacxanta ju lhacaticurulhni chai ju Legión ixtapaka'ut junita lhu ju taropajni. ");
INSERT INTO teeNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Pus ju lhacaticurulhni tatapaininilh ju Jesús ni jantu ca'amaca'alh ju lacajipi. ");
INSERT INTO teeNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Pus ju anuch akstijun ixtayanalh ixtalhavat p'axnin ju ixtat'ajun k'exvenin. Chai ju lhacaticurulhni talhitapaininilh ju Jesús ni laich catatanu la'ixlacatuna'an ju p'axnin. Chai ju yuchi yauch ajunilh. ");
INSERT INTO teeNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Pus ju lhacaticurulhni tataxtulh la'ixlacatuna ju anu' lapanac chai lana tatanu la'ixlacatuna'an ju p'axnin. Chai ixtalhavat p'axnin p'as ta'ats'ala'alh junta vak anta. Chai tatajucha laca'atants'in. Chai anch ju tanitajuk'o. ");
INSERT INTO teeNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Pus ju xa'alhistacnin p'axnin acsni talakts'ilh tuchi tapasalh pus tatalhanalh chai ta'ats'ala'alh. Ta'alh nonin ju anu' lak'achak'an chai ju lacacuxtun tuchi ixtapasata. ");
INSERT INTO teeNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Pus ju lapanacni lana ta'ats'alamilh lakts'inin tuchi ixtapasata. Chai talakmilh ju Jesús chai talhitajulh ju anu' lapanac ju ixtaxtunitach ju lhacaticurulhni la'ixlacatuna. Pus ju yuchi vanin ixvi junta ixya ju Jesús chai ixmalakch'ininta chai ixtak'oxita ju is'aktsulh. Pus ju yu'unch acsni talakts'ilh na tatalhanalh. ");
INSERT INTO teeNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Chai tachi chun ju lapanacni ju ixtalakts'inta tuchi tapasalh tanonk'o ta yu palaich puva ju anu' lapanac ju ixpacxanta ju lhacaticurulhni. ");
INSERT INTO teeNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Pus ju acsnich tachi chun ju ixtalhavat lapanacni ju amachak'an xalacat'un ju ixtalakachoko ju lak'achak'an Gadara tatapaininilh ju Jesús ni cataxtulh la'ixt'un'an. Chunch ju tanavi ni na va ixtatalhananch. Pus ju Jesús tajuchokopa lacabarco. Chai minchokocha. ");
INSERT INTO teeNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Para acsni tuca' ixtaxtui ju Jesús pus ju anu' lapanac ju ix'amaxtunicanta ju lhacaticurulhni tapaininilh ju Jesús ni ca'ixt'a'alh ju yuchi. Para ju Jesús va malakacha la'ixchaka'. Junich: ");
INSERT INTO teeNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Ap'inch'ok'ochich ju laminchaka' chai a'unch ju lapanacni tuchi k'ai lhamak'an ju xanaviniyan ju Dios. Pus ju anu' lapanac alh chai quilhuntsuculh ixlhilacaputs'un ju lak'achak'an tuchi k'ai lhamak'an ju ixnavinita ju Jesús ju ixlacata. ");
INSERT INTO teeNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Pus acsni minchokolh ju Jesús junta ixtaxtutacha pus ju ixtalhavat lapanacni lhik'ach ta'amaklhtayanalh ni ixchux'an ixtapacxantaji. ");
INSERT INTO teeNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Chai lakmilh pumatam lapanac ju ixjuncan Jairo. Pus ju yuchi pumatam xak'ai ixjunita sia yu'unch ju ixtach'alhcatnan la'ixpujitat'an ju ist'a'israelitanin. Pus ju yuchi taquilhputanilh ju lacat'un vanin la'ixch'aja' ju Jesús. Tapaininilh ni cat'a'alh la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Pus ix'alin lakatami istsi' ju ixpacxanta tachi lakacaut'ui c'ata. Chai ju yuchi ixt'ajun nini'. Pus ju Jesús t'a'alh. Para acsni ix'anta ju lacati pus va ixtalatank'asi'anta ju ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chai vachu' ixmak'anta pumatam chako'ulh ju na mak'anch jantu ixlakxixta. Pus lakacaut'ui c'ata ju ixpacxanta ju ixtak'ank'at chai ix'axtaknik'ojutach ju ac'uch'unin chux ju ix'alinta para nin chun jantu xamati' lai palai xanavi. ");
INSERT INTO teeNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Pus ju yuchi chincha la'ixlhipulacan ju Jesús chai lakcha'anilh ixquilhtu' ixpumpu'. Chai lana astacnanilh ju ixtak'ank'at. ");
INSERT INTO teeNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Pus ju acsnich ju Jesús naulh: ―Tis chavaich ju xaquilakcha'an. Chai vaklhtam chun ixtanajun ju ixtalhavat'an ni jantu yu'unch. Pus ju acsnich ju Pitalu' chai ju ix'alact'a'anta tajunilh ju Jesús: ―Amamaka'unu' t'as laich sacmit'i tis chavaich ju xalakcha'anan ni na tatank'asiyan chai tapalhit'anch ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Para ju Jesús naulh: ―Akts'iya quilakcha'alh xamati' ni icc'atsalh ni icc'uch'ulh pumatam. ");
INSERT INTO teeNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Pus ju anu' chako'ulh acsni c'atsalh ni jantu lai va sek xanavi pus vanin lak'anchokolh ju Jesús. Na ix'axq'uip'ip'itninta. Chai taquilhputanilh ju lacat'un la'ix'ucxlacapu' chai junilh ju stavasalanti la'ix'ucxlacapu'an ju lapanacni tuchi ixlaca'atalh ju lhilakcha'alh chai ni vats'alhti palaich va. ");
INSERT INTO teeNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Pus ju Jesús junich: ―Quintsi' ni q'uilhilac'ap'inch pus yuchi palaich xalhi'un. A'inchich. Cak'achanach ju mi'alhunut. ");
INSERT INTO teeNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chai acsni ixt'ajunca' t'achivini' ju chako'ulh ju Jesús ju lacati pus minchalh pumatam lapanac ju ixtaxtutacha la'ixchaka' ju anu' xak'ai chai junicalh ju Jairo: ―Ju mintsi' nitach. Jantu palai jeks amavat'i ju amamaka'unu'. ");
INSERT INTO teeNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Para acsni k'asmatlh ju Jesús pus junilh ju lapanac: ―Jantu at'alhan. Va aq'uilhilac'ap'ich. Chai palaich cajuna' ju mintsi'. ");
INSERT INTO teeNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Chai acsni tanucha lacachaka' ju Jesús pus jantu lacasq'uinilh ni xamati' cat'atanu ju pulactam junta ixma ju lijunto ask'at'a. Va yuchi ju Pitalu' ju t'atanu chai ju Jacobo chai ju Xivan chai ju ixpaich chai ixnatich ju anu' atsi'. ");
INSERT INTO teeNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pus chux ju lapanacni na ixtalack'alhun chai na p'as ixtalact'asai. Para ju Jesús alacjunich: ―Jantu ak'alhunt'it. Jantu nita ju atsi'. Va lhtataich. ");
INSERT INTO teeNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Para ju yu'unch va talhits'i'ilh ju Jesús ni ixtac'atsaich ni vasalh ixnita ju atsi'. ");
INSERT INTO teeNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Para ju Jesús ch'apanilh ixmaca' ju atsi' chai p'as xak'alalh. Junich: ―Ak'ost'a'ulhch ji atsi'. ");
INSERT INTO teeNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Pus lana minchokolh ixtacuvin la'ixlacatuna chai lana k'ostavi. Chai ju Jesús naulh ni caxtaknicalh ju ixvaiti. ");
INSERT INTO teeNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Pus ju ixpai chai ixnati ju atsi' na talhamak'aninilh. Para ju Jesús alaclhimap'aksi ni jantu xamati' catajunilh tuchi ixtapasata. ");
INSERT INTO teeNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ju Jesús amak'aixtoklich ju ixpumacaut'ui'an ix'amamaka'ui chai axtaknilh ixtachaput'an chai ju ixpuk'ai'an ni laich cataxcoxtuya' ju lhacaticurulhni la'ixlacatuna'an ju lapanacni chai lai palaich catanaviya' tachi chun ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Chai amalakacha ni cata'alh ajuninin ju lapanacni ni lhinomputun ju Dios la'is'atsucunti'an chai ni palaich catanaviya' ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Chai ajuni: ―Jantu tu'u' alhip'it'it ju ixlacata ju lacati. Nin mimpalic'an nin mimpasti'an nin mini'an nin tumin nin yuchi ni lai alhip'it'it k'alht'ui ju mimpumpu'an. ");
INSERT INTO teeNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Chai va tuchi chakach junta ast'acnana'it'it pus anch ju at'olhk'alhiya'it'it tus acsni at'axt'uch'ok'oya'it'it ju anu' lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Chai va tuchi lak'achak'an ju jantu cata'amaklhtayananan pus acsni at'axt'uch'ok'oya'it'it ju anch ach'anc'alhap'uxc'ant'it ju pokxni laminch'anxt'ak'an'an ni catapuc'atsaya' ni jantu k'ox tanavita. ");
INSERT INTO teeNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Pus tataxtulh ju yu'unch chai ta'alh chux ju lak'achak'anixni. Chai ixlhilacaputs'un ju anu' lacat'un ixtajuni ju lapanacni ta yu laich catatak'alhtaxtulh. Chai palaich ixtanavi ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Pus ju gobernador Herodes k'asmatlh tachi chun ju taxtokni ju ixnavi ju Jesús. Chai ju yuchi na ixlhamak'aninin ni ixtanajun ju ali'in ni va lok'onchokolh ju Xivan la'ix'aninti. ");
INSERT INTO teeNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Chai ju ali' ixtanajun ni va minchokolh ju mak'aniya ixlapanac Dios ju Elías ixjuncan. Chai ju ali'in ixtanajun ni va lok'onchokolh apumatam mak'aniya lapanac ju ixnajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Para ju Herodes naulh: ―Quit'in qui'akstu iclhinaulh ix'acch'uc'uca ju Xivan. Pus ju ani tis chavaich nu' ju lhichivinincan na lhu taxtokni. Chai ju Herodes na ixlakts'imputun ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Pus acsni tatasp'itchokocha ju ix'alacmalakachata ju Jesús ni cata'alh pumat'iyun pumat'iyun amalaninin ju lapanacni pus talakminchokolh ju Jesús chai tajunk'o tachi chun ju taxtokni ju tanavichalhch. Chai ju Jesús ak'ailhi'alh alacatam junta aseknic'a ixjunita. Junta vanin ixjunita ju lak'achak'an Betsaida. ");
INSERT INTO teeNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Para acsni tac'atsa ju lapanacni pus lana ta'ach'ak'ok'analh. Chai ju Jesús lhik'ach amaklhtayanalh. Chai tsuculh alacjunini' ni lhinomputun ju Dios la'is'atsucunti'an. Vachu' ac'uch'u ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Chai acsni ixtok'oxaputun pus ju ixpumacaut'ui'an talak'alh ju Jesús chai tajuni: ―Amalak'ach'at'i ju lapanacni. Chach ta'ancha lak'achak'anixni junta vanin tasui chai chux ju lacchaka' ju lacacuxtu tasui. Chach ta'ancha sq'uininin ju chaka' junta laich catalakacujlh chai junta laich catavailh. Pus junta vilau ni mati' tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Para ju Jesús alacjuni: ―Amavat'itch ju uxijnan. Chai ju yu'unch tajuni: ―Para va akxquisich vati ju xaclhitajuyau chai lakat'ui lact'icst'i pamata. U ni jantu pus ca ac'anauch tamonin ju vaiti ixlacata chux ju ani lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Pus ixcha'anta tachi lakaquis milh jok'atni. Pus ju acsnich ju Jesús alacjunilh ju ix'amamaka'ui: ―Chach tatolhcha chai alhc'a'ulachich cincuenta ju quilhmaktamin. ");
INSERT INTO teeNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Pus chunch ju tanavi. Chai tatolhcha ixchux'an. ");
INSERT INTO teeNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Pus ju acsnich ju Jesús ch'apalh ju akxquis vati chai ju lakat'ui pamata chai talakst'alh ju lact'iyan. Xtaklh lhak'ailakts'in chai ch'ek'elh chai axtaknilh ju ix'amamaka'ui ni cataxtaknilh ju ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pus ta'ok'o ixchux'an chai talhilalh. Chai tasacchokolh ju tamaxajnicha chai talaktsama lakacaut'ui tank'alin. ");
INSERT INTO teeNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lakatam avilhchan acsni va is'akstu ixvi ju Jesús pus tsuculh t'achivini' ju Dios. Va yu'unch ju ix'amamaka'unti ju ix'alact'avi. Chai acsni t'achivink'o pus alacsacmilh ju ix'amamaka'ui. Ajunich: ―Tas tanajun ju lapanacni. Tis chavaich quintalhiulai ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Chai ju yu'unch tak'alhtayanalh. Tajuni: ―Ju ali'in tanajun ni ma Xivan'at ju amakpaxana'. Chai ju ali'in tanajun ni ma Elías'at. Chai ju ali'in tanajun ni ma uxint'ich pumatam mak'aniya lapanac ju ixnajun ixchivinti Dios. Ma va lok'onch'ok'och. ");
INSERT INTO teeNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Chai ju Jesús ajuni: ―Chai ju uxijnan tis chavaich quilalhiulayau ju quit'in. Chai ju Pitalu' junich: ―Uxint'ich ju Cristo'at ju ixnoncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pus ju Jesús slivasalh alhimap'aksi ju ix'amamaka'ui ni jantu xamati' catajunilh ni Cristo junita. ");
INSERT INTO teeNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Chai ajuni: ―Akts'iya tasq'uini ni aclhimak'alhk'ajnalh na lhu taxtokni ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Chai jantu tu'u' aquintalhiulaya' ju xapapanin ju quint'a'israelitanin'an chai ju xalack'ajin palijni chai ju yu'unch ju na talhatalanininta ju milhamap'aksin'an. Chai aquintamakniya'. Para aclok'onchokoya' ju ixlhilakat'utu avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Chai astan ju Jesús ajuni ixchux'an ju anch ixtavilanalh: ―Ni xamati' quilapanac jumputun pus jantu lai catinavi ixk'achat is'akstu. Chai chux tuncujun cach'ixlh ju mak'alhk'ajnat ju ca'alina' va ixlaca'atalh ni quilhilaca'anta ju quit'in. Chai va tachi aquinch'ak'ok'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Pus va tichi chavaich ju najun ni jantu quinch'ak'ok'aputun va ixlaca'atalh ni va lai maknicalh pus ju yuchi camak'ats'ank'aya' ju sa'atsucunti ju lact'iyan. Para va tichi chavaich ju camak'ats'ank'aya' ju is'atsucunti va ixlaca'atalh ni quinch'ak'ok'ai ju quit'in pus ca'alina' ju is'atsucunti ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Pus jantu tu'u' lhajai tam lapanac mas calhajak'o chux ju xataxtokni ju ani lacamunutpa' ni va calhimak'ats'ank'a ju is'atsucunti chai jantu lai cati'alh ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Pus va tichi chavaich ju aquint'amaxanana' ju quit'in chai cat'amaxanana' ju quinchivinti pus vachu' ju quit'in act'amaxanana' ju yuchi. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Act'amaxanana' ju yuchi acsni acminchokoya' chai k'ai ucxtin acjuna'. Acmina' la'ixtachaput ju quimpai chai la'ixtachaput'an ju anquilhnin ju tavilanancha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Chai iclajunau ju stavasalanti. Alin ju lamilhi'uxijnan ju vilat'it ju ani ju jantu cataniya' tus acsni catalakts'ina' ta yu tasui acsni vi ju Dios la'ixpu'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Pus tachi ixlhilakatsajin avilhchan ixtapasata acsni ix'ajunita ju lapanacni ju ani chivinti. Pus ju acsnich ju Jesús alact'asanilh ju Pitalu' chai ju Xivan chai ju Jacobo. Chai alact'a'alh' ju lakatam k'ai talhpa. Alh t'achivini' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Chai acsni ixt'ajun t'achivini' ju Dios pus lana tapaxalh ju ix'ucxpu' ju Jesús. Chai ju ixpumpu' lana na xlap'ap'a ixmaktajita chai na xnapapa ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Chai vachu' tatalacasucha ixpumat'ui'an lapanacni ju ixtat'achivinin ju Jesús. Yu'unch ju Moisés chai ju Elías ju mak'anch ixtat'ajun. ");
INSERT INTO teeNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Chai ju yu'unch vachu' tatalacasulh la'ix'amatuncunit ju Dios. Chai ixtalhichivinin ju ix'aninti ju Jesús ju catapasaya' ju lak'achak'an Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Para ju Pitalu' chai ju ix'alact'avi slivasalh na ixtalaclhtatai. Chai acsni xcaya tacujlh pus talakts'ilh ni xlap'ap'a ixmaktajita ju anch. Vachu' talakts'ilh ju ixt'iyun'an lapanacni ju ix'alact'aya ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Chai acsni tats'ank'a la'ix'alac'avanti'an ju anu' ixt'iyun'an pus ju Pitalu' junich ju Jesús: ―Amamaka'unu' na k'oxich iclhiulayau ni anich icvilau. Acnaviyauch ak'at'utu pac'ats'a. Ak'atamch ju mi'anu'. Chai ak'atamch ju ix'anu' ju Moisés. Chai ju ak'atamch ix'anu' ju Elías. Chunch ju naulh ju Pitalu' para jantu isc'atsai tuchi ixnajunch. ");
INSERT INTO teeNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pus acsni ixt'ajun nona' ju ani pus milh lakatam ataputs'i chai a'akxtakmak'o. Chai ju yu'unch lana na tatalhanalh acsni tatanulh ju laca'ataputs'i. ");
INSERT INTO teeNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chai tak'asmatlh lakatam chivinti ju xaminacha laca'ataputs'i chai ixnajun: ―Ju ani yuchi ju quints'alh chai na icmapaini. Yuchach ju ak'asmatnit'it. ");
INSERT INTO teeNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Chai acsni chivink'o pus ju ixtamamaka'un ju Jesús talakts'ilh ni va is'akstu ixya ju Jesús. Para astan jantu xamati' tu'u' tajuni tuchi ju ixtalakts'inta. ");
INSERT INTO teeNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Acsni tuncunchokopa pus ju Jesús chai ixpumat'utu'an ixtamamaka'ui taminchokocha ju anu' lactalhpa. Chai na lhu lapanacni ju taqui'apakxtoknulh. ");
INSERT INTO teeNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Chai pumatam lapanac ju ixmakminta lana xak'ala ju Jesús. Chai na p'as ju chivinilh acsni chani juni: ―Amamaka'unu' ictapaininiyan ni a'akt'ai'ut'ich ju quints'alh ni va lakatamch. ");
INSERT INTO teeNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Pus va tanui ju lhacaticuru la'ixlacatuna chai lana va tam pants'iquis ts'au t'asai. Chai tin lhinek chai na akpupui. Chai acsni xcaya macajunch pus na talacac'atsanita ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Chai ictapaininilh ju mintamamaka'un ni cataxcoxtulh ju lhacaticuru para jantu lai ixtaxcoxtui. ");
INSERT INTO teeNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Pus ju acsnich ju Jesús ajunich: ―Tis va yuchach ji lapanacni ni lana jantu lai lac'a'iyat'it. Ja tasq'uini ni lana na mak'an aclat'atolau chai aclach'ixniu tus acsni alac'a'iya'it'it. Alhit'ach ju mints'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Para acsni ixminta ju anu' ask'at'a pus ju lhacaticuru lana tin lhinekchokolh chai lhtucu lhtucu ucxuntama. Para ju Jesús k'ailh ju lhacaticuru chai junilh ni cataxtulh la'ixlacatuna ju anu' ask'at'a. Chai lana palaich va ju anu' ts'alh. Chai mak'axtaknichokolh ju ixpai. ");
INSERT INTO teeNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chai chux ju lapanacni na ixtalhamak'anininch ixtachaput ju Dios. Chai acsni ixtalhamak'aninin ixchux'an tachi chun ju taxtokni ju ixnavich ju Jesús pus ju yuchi ajunilh ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Anavit'it cuenta ju ani ju iclajunau chai jantu tavanan ac'ap'a'it'it. Ju quit'in acmak'axtakcana' la'ixmaca'an ju lapanacni. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ―Chunch ju ajunilh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Para ju ix'amamaka'ui jantu lai ixtamachakxai tuchi ixnomputun junima chivinti chai jantu ix'alak'a'inican ni laich catamachakxa ju acsnich. Chai ju yu'unch ni va ixtatalhoni ju Jesús pus jantu istasacmiputun tuchi ixnomputun. ");
INSERT INTO teeNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Pus ju ix'amamaka'ui ju Jesús tatsuculh lhilak'ainin tichi chavaich ju palai xak'ai ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Para ju Jesús acsni c'atsalh tuchi ixtapast'ac'a la'ix'alhunut'an pus xak'atailh pumatam ask'at'a chai yaulh vanin junta ixvi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Chai ajuni ju ix'amamaka'ui: ―Va tichi chavaich ju ca'amaklhtayanana' tam ask'at'a tachi ju ani ya va ixlacata ni quilhilaca'anta ju quit'in pus tachi ju va jun quit'in ju qui'amaklhtayanan. Chai va tichi chavaich ju qui'amaklhtayanan ju quit'in pus vachu' amaklhtayanan ju quimpai ju quimacaminta. Pus va tichi chavaich ju lamilhi'uxijnan ju jantu tu'u' calhitak'aya yuchach ju palai xak'ai. ");
INSERT INTO teeNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Pus ju acsnich ju Xivan junilh ju Jesús: ―Amamaka'unu' iclakts'iu pumatam ju ixcoxtui ju lhacaticuru la'ixlacatuna'an ju lapanacni lamintapaka'ut. Chai ick'ajiuch ni jantu ch'ak'ok'ayan tachi ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Para ju Jesús ajunilhch: ―Jantu ak'a'it'it. Pus ju jantu quint'alaxcai'an quilak'auch'an. ");
INSERT INTO teeNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Chai acsni ixchimputun ju avilhchan acsni ca'amaklhtayananchokocana' ju Jesús ju lact'iyan pus ju yuchi naulh ni jantu tu'u' catisastuclh ni ca'ana' ju Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pus acsni tuca' ixcha'an pus ju Jesús amalakacha ju ixlapanacni ni cata'alh ju alakatam lak'achak'an puxconin ju vaiti chai ju chaka' junta lai cata'astacnalh. Pus ju yu'unch ta'alh chai tatanuchalh la'ixlak'achak'an'an ju samaritanonin. ");
INSERT INTO teeNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Para ju amachak'an anch jantu ta'amaklhtayanamputulh ju Jesús ni ixtac'atsai ni ix'amputun ju lak'achak'an Jerusalén chai ju yu'unch lana jantu ixtalakts'imputun ju amachak'an Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Pus ixt'iyun'an ju ix'amamaka'ui ju Jesús yu'unch ju Jacobo chai ju Xivan acsni talakts'ilh ju ani pus tajunilh ju Jesús: ―Qui'ucxtin ja lac'asq'uin ni acsq'uinvich ju jipi ju camilh lact'iyan tachi ju navilh ju mak'aniya milapanac ju Elías ixjuncan. Chach lacxavak'o ju ani amachak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Para ju Jesús talakasp'itlh chai ak'ailh. Ajunich: ―Ju uxijnan lana jantu mach'akxayat'it ta yu junita ju ixlhamap'aksin ju Spiritu Santu ju t'ajun lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Pus ju quit'in jantiyu' ju iclhiminta ni va acmilh mak'ats'ank'ana' ju is'atsucunti'an ju lapanacni. Va icminta amak'alhtaxtunu'. Pus ju acsnich ta'alh alakatam lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Chai acsni ixta'anta ju lacati pus pumatam lapanac junilh ju Jesús: ―Qui'ucxtin acch'ak'ok'ayan vanta anchach ju ap'ina'. ");
INSERT INTO teeNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Para ju Jesús junich: ―Ju zorra alin junta tanui. Chai ju ts'ok'o alin junta tatoc'ai. Para ju quit'in mati' ju quinchaka' junta lai ac'astacnalh. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Chai ju Jesús junilh apumatam: ―Aq'uinch'ak'ok'ach. Para ju yuchi juni: ―Qui'ucxtin yauch aq'ui'un ni act'at'olaca' ju quimpai. Ni caniya' ju yuchi pus acmacnuya' chai acsnich ju acch'ak'ok'ayan. ");
INSERT INTO teeNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Para ju Jesús junich: ―Chach tamacnu ju mimpai ju yu'unch ju ta'amacnunun ju tanita. Para ju uxint'i a'inchich ajunini' ju lapanacni ni Dios lhinomputun la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Pus ju acsnich apumatam xak'alachokopa ju Jesús. Juni: ―Acch'ak'ok'ayan para chach ictiqui'amac'ami ju tavilanancha laquinchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Para ju Jesús junich: ―Tachi chun ju lapanacni ju catach'apaya' ju ixtiq'uiu ju pucuxtu para jantu vasalh catanaviya' cuenta para catalaca'anchokoya' la'ixlhipulacan'an pus jantu sok catalhoknuna'. Pus vana va chun ju lakat'ui junita ju ix'atalacpast'ac'at. Ju yuchi jantu lai k'ox ca'amalaniya' ju lapanacni ixlacata ju Dios ni jantu va yuchi ju navi cuenta. ");
INSERT INTO teeNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Astan ju Jesús asacxtulh setenta ix'amamaka'ui chai amalakachalh pumat'iyun pumat'iyun. Chai ju yu'unch ta'alh tachi chun ju lak'achak'anixni junta ca'anach is'akstu ju Jesús astan. ");
INSERT INTO teeNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Chai ajunich ju ix'amamaka'ui: ―Acsni na c'at'ata ju tu'u' xatoc'at slivasalh na lhu ch'alhcatnin ju maktasq'uinican ni laich soko camak'aixtokcalh. Pus vana va chun ju lapanacni. Slivasalh na lhu ju aquintalhilaksi ni xamati' ca'ajunilh. Para jantu lhu alin ju ta'amputun ajuninin. Pus yuchi alhit'ap'aininit'it ju Dios ju lhinajun la'ixlhich'alhcat ni camaca'alh ali' ju ixlapanacni la'ixlhich'alhcat. ");
INSERT INTO teeNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Pus a'inchit'it. Iclamalakachayau tachi ju va borregojni junta na alin ju maktilin. ");
INSERT INTO teeNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jantu alhi'it'it ju mintumin'an nin mimpasti'an nin alakatam ju minch'anxtak'an'an. Chai jantu xamati' panicni at'ach'ivinint'it acsni amac'amiya'it'it ju lacati. ");
INSERT INTO teeNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Chai va tuchi chaka' junta ast'acnana'it'it pus acsni at'anuya'it'it p'ulhnan ma chani ana'unt'it: “Lhik'ach ats'uc'uya'it'it ju uxijnan ju t'anuyat'it ju ani lacachaka'”. ");
INSERT INTO teeNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Chai ni t'ajun ju anch pumatam ju ca'amaklhtayanamputulh ju k'ox atsucunti ju xt'ak'a ju Dios pus vasalh chunch cajuna' tachi ju xasq'uin ixlacata. Para ni mati' xamati' ju chunch ju anch lacachaka' pus jantu tu'u' ixtapalhni cajuna' ju minchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Chai va lakatam chaka' ju at'ola'it'it. Chai a'uya'it'it va tuchi cataxtakniyanch. Chunch ju alat'it ni lhijunch ni caxtaknicalh ju ixtalhaja ju makch'alhcatna'. Jantu lakatam lakatam chaka' at'anuya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Chai va tuchi lak'achak'an junta ap'ina'it'it chai ni cata'amaklhtayananan pus a'uya'it'it va tuchi ju cataxtakniyan. ");
INSERT INTO teeNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ac'uch'ut'it ju tak'ank'anin ju anch tat'ajun. Chai a'una'it'it ni chavaich laich calhinaulh ju Dios la'is'atsucunti'an ni va catalacasq'uilh ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Para vanta lhi'anchach lak'achak'an junta at'anuya'it'it chai ni jantu cata'amaklhtayananan pus at'ayat'it ju lacati chai chanich ana'unt'it: ");
INSERT INTO teeNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mas yuchi ju xapokxni ju milak'achak'an'an ju quintach'anjucan laquinch'aja' quinc'an icch'anc'alhap'uxcanau ni jantu xaquila'amaklhtayananau. Chai ju chunch ap'uc'ats'aya'it'it ni talak'alhin ju xanaviyat'it. Chai mas jantu xaquila'amaklhtayananau para ac'ats'at'it ni chavai avilhchan laich ixlhinaulh ju Dios lami'atsucunti'an ni va ixlac'asq'uint'it cava”. Chunch ju a'una'it'it ju amachak'an anch. ");
INSERT INTO teeNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Pus iclajunau ni palai na ca'alina' ju ixmak'alhk'ajnat'an ju amachak'an ju anu' lak'achak'an ju anu' avilhchan acsni camak'osaspitcanach ju lapanacni. Palai jantu ju amachak'an Sodoma mas na alactu'unin ixtajunita ju yu'unch. Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju lapanacni: ");
INSERT INTO teeNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","―Paini'itnich ju uxijnan ji amachak'an Corazín. Paini'itnich ju uxijnan ji amachak'an Betsaida. Pus ni ca'ixnavicancha ju lak'achak'an Tiro chai ju lak'achak'an Sidón ju lhamak'an ju ixnavinic'ant'at'it pus mak'anch ixtamacaulh ix'alactu'unti'an chai ixtalakch'ilh ju smalaka ixpumpu'an chai ixtatavi lacalhc'ac'a ni cac'atsacalh ni vasalh ixtamacomputun ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pus ixlhiyuchach acsni camuc'anicana' ju ixtalak'alhin'an ju lapanacni pus ju amachak'an Tiro chai ju amachak'an Sidón palai jantu lhu ca'alina' ju ixmak'alhk'ajnat'an. Palai lhu ju amamak'alhk'ajnic'ana'it'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Chai ju uxijnan ji quint'a'amachak'an ju lak'achak'an Capernaum na va t'ak'ayayat'it. Para amamaxanic'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Chai tailhi'alh ju chivinti ju ixt'ajun ajunini' ju ix'amamaka'unti. Ajuni: ―Ju catak'asmatniyan ju uxijnan pus tachi ju va jun quit'in ju quintak'asmatni. Chai ju jantu tu'u' catalhiulayan ju uxijnan pus tachi ju va jun quit'in ju jantu tu'u' quintalhiulai. Chai ju jantu tu'u' quilhiulai pus va nomputun ni jantu tu'u' talhiulai ju quimpai ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Acsni tatasp'itcha ju isetenta'an ix'amamaka'ui ju Jesús pus na ixtak'achan. Tajunilh ju Jesús: ―Qui'ucxtin mas yu'unch ju lhacaticurulhni xaquintaquiclaca'iyan acsni xack'ayau lamintapaka'ut. ");
INSERT INTO teeNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Chai ju Jesús ajuni: ―Chunchach ni iclakts'ilh ju Satanás ni xacaxtucalh ju lact'iyan chai vats'alhti patajulh tus lacat'un tachi ju tu'u' mak'alipni'. ");
INSERT INTO teeNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Chai iclaxtaknitau ju tachaput ni laich ap'ut'ayaya'it'it ju lu chai ju statsucu chai laich at'alalha'aya'it'it tachi chun ju ixtachaput ju lhacaticuru chai jantu tu'u' catanaviniyan macxcai. ");
INSERT INTO teeNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Para jantiyu' ju alhik'ach'ant'it ni laich taquiclaca'iyan ju lhacaticuru. Alai yuchi ju alhik'ach'ant'it ni ts'ok'ulacantacha lact'iyan ju mintapaka'ut'an. ");
INSERT INTO teeNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Pus ju acsni pants'iquis ju Spiritu Santu xtaknilh ju Jesús lhu ju ixk'achat. Chai ju Jesús chani junilh ju ixpai: ―Ju uxint'i ji quimpai xa'ucxtin'at ju lact'iyan chai ju lacat'un. Chai icjunan lak'ailakts'iuch ni jantu amavasalanit'a ju ani taxtokni ju na talhilaksi ixtac'atsan'an chai ix'atalaninti'an is'akstu'an. Alai amavasalanit'a ju yu'unch ju talhilaksiyan tachi ju lai tam ask'at'a ju lhilaksi ix'amamaka'unu' ni yuchi ju camalaniya' tu'u'. Pus chunchach ji quimpai. Chunchach ju k'ox xalhiulai ju uxint'i. Chai ju acsnich ju Jesús chani ajuni ju lapanacni: ");
INSERT INTO teeNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","―Ju quimpai quixtaknik'ota tachi chun ju taxtokni. Chai jantu xamati' vasalh quimispai. Va yuchi ju quimpai. Chai jantu xamati' vasalh mispai ju quimpai. Va quit'in ju ists'alh icjunita chai tachi chun ju iclacasq'uin ni catamispa. ");
INSERT INTO teeNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Chai ju acsnich ju Jesús laca'anchokopa junta ixtavilanancha ju ix'amamaka'unti chai va yu'unchach ju axak'ala. Ajuni: ―Slivasalh na lhik'ach ju mi'atsucunti'an ju uxijnan ni lakts'inat'it tachi chun ju ani taxtokni ju t'ajun tapasana'. ");
INSERT INTO teeNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pus iclapujunau chunch ni na lhu ju lapanacni ju ixtanajun ixchivinti Dios chai ju ucxtinin ju mak'anchich ixtat'ajun na ixtalakts'imputun ju tuch'i lakts'inat'it ju uxijnan. Para jantu talakts'ilh. Chai na ixtak'asmatputun tuch'i k'asmat'at'it. Para jantu tavanan tak'asmatlh. ");
INSERT INTO teeNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Chai pumatam ju na ixlhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin taya. Va ixlakts'intanuputun ju Jesús. Chai chani ju junilh: ―Amamaka'unu' tijuch ju acnavilh ni laich ca'alilh ju qui'atsucunti ju cajonk'alhi. ");
INSERT INTO teeNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Chai ju Jesús juni: ―Pus tas ts'okcanta ju lamilhamap'aksin. Tas lhimach'akxaich. ");
INSERT INTO teeNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Chai ju yuchi ak'alhtayanalh. Junich: ―Pus ju lhamap'aksin najun ni ma acmapaini ju qui'ucxtin Dios ixlhichux qui'alhunut chai ixlhichux ju quintac'atsan chai ixlhichux ju quintachaput chai ixlhichux ju qui'atalacpast'ac'at. Chai vachu' najun ni ma acmapaini ju quint'alapanac tachi ju va jun qui'akstu. ");
INSERT INTO teeNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Pus ju acsnich ju Jesús junich: ―K'oxich ju xaq'uilhik'alht'aich. Anavit'i ju chunch chai ca'alina' ju mi'atsucunti ju conk'alhiya'. ");
INSERT INTO teeNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Para ju yuchi ni jantu ixlacasq'uin ni camuc'anicalh ixtalak'alhin pus junilh ju Jesús: ―Para tis quint'alapanac ju acmapainiya'. ");
INSERT INTO teeNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Pus ju acsnich ju Jesús chani juni: ―Pumatam israelita ixtaxtutacha ju lak'achak'an Jerusalén. Ix'amputun ju lak'achak'an Jericó. Para tach'apayaulh ju ak'alhonin. Chai ju yu'unch talhi'anilh ju ixpumpu' chai talakanekma. Chai paitat xanin tamacoma. Chai ta'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chai chanich ju tapasalh. Pus pumatam quimpali'an ju israelitanin juntau ix'anta ju anu' lacati. Chai acsni lakts'ilh ju anu' probe lapanac pus na makat pu'inilh. ");
INSERT INTO teeNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Chai vachu' pumatam lapanac ju ixch'alhcatnan lacpujitat ix'anta ju anu' lacati. Chai acsni ixcha'amputun vanin junta ixma ju anu' lapanac pus lakts'ilh para vachu' na makat ju pu'inilh. ");
INSERT INTO teeNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Para pumatam amachaka' ju xa'estado Samaria vachu' ix'anta ju lacati. Chai vanin milh junta ixma ju anu' lapanac. Chai acsni lakts'ilh pus na mapaini. ");
INSERT INTO teeNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Chai lak'alh. Chai tsuculh lacch'inini' junta ixlacac'atsani. Muc'anilh ju aceite chai ju vino. Chai ch'ixmuc'alh la'ixpuru. Chai lhi'alh junta mach'ixtakcan chaka'. Chai lhistaclh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chai acsni tuncunchokopa chai ix'anchokoputun ju lacati ju anu' amachaka' Samaria pus maxtulh lakat'ui denarius tumin. Chai xtaknilh ju amachaka' chai junilh: “Alhist'act'i ju anu' lapanac. Chai ni tu'u' ali' ju amac'ap'ina' ju mintumin pus acmapalhniyanch acsni actasp'itchokoyanta”. ");
INSERT INTO teeNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Pus t'as na'unch. Tis chavaich ju ixpumat'utu'an ju talacasulh ni vasalh mapainilh ju anu' tach'apayaulh ju ak'alhonin. ");
INSERT INTO teeNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Chai ju anu' ju na ixlhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin naulh: ―Pus yuchi ju navilh lamapainin. Pus ju acsnich ju Jesús junilh: ―A'inchich chai chunchach vachu' ju anavit'i. ");
INSERT INTO teeNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Pus ju Jesús alhtanampa ju lacati chai tanuchalh lakatam lak'achak'an. Chai pumatam chako'ulh ju Marta ixjuncan amaklhtayanalh la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Chai ix'alin pumatam isp'isek'e ju Marta ju Malia ixjuncan. Pus ju yuchi tavi vanin la'ixch'aja' ju Jesús ni va ixk'asmatniputun ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Para ju Marta na ixlhamak'aninin ju ixlhich'alhcat ni ixt'ajun lak'oxini' ju vaiti. Pus lak'alh ju Jesús chai juni: ―Amamaka'unu' ja va jantu q'uilakts'in ni va qui'akstu quimacaunuta ju quimp'isek'e ju lacalhich'alhcat. A'unch ni chach quimilh aktaijunu'. ");
INSERT INTO teeNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Para ju Jesús juni: ―Marta slivasalh na lhu alin ju mi'atalacpast'ac'at ju navip'ut'un. ");
INSERT INTO teeNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Para va lakatam taxtokni ju maktasq'uinican. Chai ju Malia sacxtuta ju taxtokni ju palai k'ox chai jantu lai xamati' catitai'inilh. ");
INSERT INTO teeNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Pus ju aktam ju Jesús ixt'ajun t'achivini' ju Dios. Chai acsni t'achivink'o pus pumatam ju ixtamamaka'un junich: ―Qui'ucxtin aquilamasuniuch ju ixt'achivininca ju Dios tachi ju lalh ju Xivan ni amasunilh ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Chai ju Jesús ajuni: ―Pus acsni at'ach'ivina'it'it ju Dios chanich anona'it'it: Quimpai ju vilhchi' lact'iyan Chach tac'atsa ju lapanacni ni na salaka'at. Chach chilh ju avilhchan acsni alhinona' ju uxint'i. Chach navicalh ju mink'achat ju ani lacat'un tachi ju navicantacha ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tuncujun tuncujun aquilaxtakniu ju quivaiti quinc'an. ");
INSERT INTO teeNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Aquilamac'acxaniuch ju qui'alactu'unti quinc'an. Pus vachu' ju quijnan ic'amac'acxaniyau ju quintanavitan tu'u' macxcai. Jantu aquilalhi'au junta acmapast'ac'anicau ju tu'u' macxcai. Alai aquilamak'osuniu ju macxcai. ");
INSERT INTO teeNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Pus ju Jesús tailhi'alh ixchivinti chai ajuni: ―Jantu xcai ni chani ju catapasalh la'is'atsucunti ju pumatam ju milhi'uxijnan. Jantu xcai ni ca'alilh ju mi'amigo ju alakp'it'i ju paitat ts'is chai a'una': “Qui'amigo q'uimach'ixt'aknin akxt'utu ju mini'. ");
INSERT INTO teeNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Pus chilh pumatam qui'amigo ju makat xaminacha para matich tu'u' ju lai acxtaknilh”. ");
INSERT INTO teeNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Chai jantu xcai ni tus pulacni ca'ak'alhtayanancha ju anu' amachaka' chai chani cajunin: “Jantu jeks aq'uimavat'i. Pus icmalacchajuta ju quimalhtich chai ic'alact'alhtataich ju qui'ask'at'an. Jantu lai actik'ostavi ni laich tu'u' acxtaknin”. ");
INSERT INTO teeNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pus mas jantu cak'ostola' chai caxtakniya' tu'u' va ixlaca'atalh ni ix'amigo junita para iclajunau ni akts'iya cak'ostola' chai caxtakniyach tachi tants'un ju maktasq'uini va ixlaca'atalh ni jantu lai maxanan ju anu' ju t'ajun jeks mavana'. ");
INSERT INTO teeNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Chai ju quit'in iclajunau: Asq'uinit'it ju Dios chai ju yuchi cataxtakniyan. Ap'uxc'a'ut'it la'ixmacni Dios ju tuch'i makt'asq'uiniyat'it chai alhit'a'uya'it'it. Va tsa tsa asq'uinit'it ju Dios tachi acsni va tsa tsa sacan lacatu'u' malhtich. Chai ju Dios cataxtakniyan. ");
INSERT INTO teeNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chunch ju alat'it ni amaklhtayanan ju lapanac ju sq'uin. Chai ju puxcajui tu'u' lhitajui. Chai ju sai ju malhtich malhtek'anican. ");
INSERT INTO teeNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Jantu xamati' ju milhi'uxijnan ju laich caxtaknilh tam is'ask'at'a lakatam chiux acsni casq'uinilh ju xkapavati. U ni casq'uinilh ju pamata jantu xamati' milhi'uxijnan ju laich caxtaknilh lakatam lu. ");
INSERT INTO teeNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","U ni casq'uinilh tu'u' ak'axvati jantu xamati' milhi'uxijnan ju laich caxtaknilh lakatam statsucu. ");
INSERT INTO teeNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Pus ju uxijnan mas na k'ai unt'at'it lai xt'akniyat'it ju k'ox ju mi'ask'at'an'an. Pus ja va a ti yuchach ju quimpai'an Dios ju vilhcha lact'iyan jantu cati'axtaknilh ju Spiritu Santu ju yu'unch ju catasq'uiniyach. ");
INSERT INTO teeNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Pus ju Jesús xcoxtulh ju lhacaticuru la'ixlacatuna pumatam lapanac. Pus ju anu' lapanac jantu lai ixchivinin acsni ixtanun ju lhacaticuru la'ixlacatuna. Para acsni taxtulh ju anu' lhacaticuru pus ju anu' ju va nunu' ixjunita chivinilh. Pus na talhamak'aninilh ju ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Para ju ali'in ju sia lhiyu'unch tanaulh: ―Ju ani ya lapanac va xcoxtui ju lhacaticuru la'ixlacatuna'an ju lapanacni la'ixtachaput ju Satanás. ");
INSERT INTO teeNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Chai ju ali'in ni va ixtalakts'intanuputun ju Jesús pus tasq'uinilh ni canavi tu'u' lhamak'an ju camincha lact'iyan ta yu laich catapuc'atsaya' ni vasalh Cristo junita. ");
INSERT INTO teeNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Para ju Jesús ni amispanilh ix'atalacpast'ac'at'an ju yu'unch pus ajunich: ―Tachi chun ju k'ai lacat'un junta lhinajun ju tam k'ai ucxtin ni quilhmaclhu cajuncalh chai catalaclasaya' ju sia is'akstu'an pus va ca'aclaya'. Chai ju tatanumanalh lacachaka' ni catalaclak'ailh ju sia is'akstu'an pus catatalhvaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Pus vana va chun ju lhacaticuru. Ni cat'alasachokolh ju ixt'alhacaticuru pus tas laich calhilhinonk'alhi la'ixpu'ucxtin. Pus iclajunau chunch ni va nonat'it ni la'ixtachaput ju Satanás ju ictixcoxtui ju lhacaticurulhni. ");
INSERT INTO teeNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ju uxijnan nonat'it ni ictixcoxtui ju lhacaticurulhni la'ixtachaput ju Satanás. Para ju mi'amamaka'unin vachu' tamaktasq'uini ni xamati' ca'axtaknilh ixtachaput'an ni laich catatixcoxtuya' ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. Pus yu'unch ju catajunan ni jantiyu' ixtachaput ju Satanás ju pumaxtucan ju lhacaticuru la'ixlacatuna tam xamati' tachi ju nonat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Alai la'ixtachaput ju Dios ju ictixcoxtui ju lhacaticurulhni chai yuchi lana lhitasui ni yuchi ju Dios ju lhinajun lamilhi'uxijnan ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ju tam jok'at ju na tachapun chai ju alin ju ixpat'alan chai lhist'ac'a ju la'ismakspa' ju ixchaka' pus jantu tu'u' lai ts'ank'ai ju ixtaxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Para acsni va camilh apumatam ju palai tachapun palai jantu ju yuchi pus cat'alalhajaya'. Catai'inik'oya' ju ixpat'alan ju na jok'at ixpunajun chai camakpitsik'oya' chux ju ixtaxtokni. Ju Jesús chunch ju ajuni ju lapanacni ni va ix'amamachakxaniputun ni yuchi ju t'alalhajalh ju lhacaticuru. Yuchi lai alhixcoxtui ju lhacaticurulhni la'ixlacatuna'an ju lapanacni. Pus tailhi'alh ixchivinti chai ajunilh ju lapanacni: ");
INSERT INTO teeNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","―Pus ju jantu quint'a'anta yuchi ju quint'alaxcai junita. Chai ju jantu quint'amak'aixt'ok'a ju lapanacni ju aquintalhilaca'anach pus va asastucnun. Ju Jesús tailhi'alh ixchivinti chai ajuni ju lapanacni: ");
INSERT INTO teeNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","―Ju lhacaticuru acsni taxtui la'ixlacatuna tam lapanac pus vaclhun ucxunt'ajun junta na axixnita. Va puxcolhit'ajun ta anchach ju lai catavi. Chai ni jantu lhitajui pus najun: “Ac'anchokoya' alai laquinchaka' junta xactaxtuyacha”. ");
INSERT INTO teeNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Chai acsni minchokoi pus lana tanuchokoi la'ixlacatuna ju anu' lapanac ni tachi lakatam chaka' junita ju pulacp'alhcanta chai maxantilacanta. ");
INSERT INTO teeNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Pus ju acsnich ju yuchi taxtuchokoi chai an ini' ali'in chai ak'ailhimin apumatujun lhacaticurulhni ju palai k'ai tajunita. Palai jantu na chun ixjunita ju yuchi ju p'ulhnan ixtanun. Pus ixchux'an tatanui la'ixlacatuna ju anu' lapanac chai tatsucui ju anch. Pus ju is'atsucunti ju anu' lapanac palai tak'alhilh ju acsni. Palai jantu na chun ixjunita ju p'ulhnan. ");
INSERT INTO teeNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Pus acsni ixt'ajun nona' ju ani chivinti ju Jesús pus pumatam chako'ulh ju ixmakya lacatalhavat lana chivincha. Junilh ju Jesús: ―Na lhik'ach ju is'atsucunti ju xamaklok'oyan chai ju xamats'iquiyan. ");
INSERT INTO teeNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Para ju Jesús juni: ―Alai palai tak'achan ju tak'asmat'a ju ixchivinti Dios chai tamuctaxtui. ");
INSERT INTO teeNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Pus slivasalh na lhu ju tatak'aixtoklh ju lapanacni junta ixvi ju Jesús. Chai ju yuchi tsuculh ajunini': ―Ju uxijnan ju chavai t'onat'it na k'ai unt'at'it. Va lac'asq'uinat'it ju tu'u' lhamak'an ju ap'uc'ats'aya'it'it ni vasalh Cristo icjunita. Yuchi ju ixnoncan camalakachatachilh ju Dios. Para jantu tu'u' atumpa ju amasunic'ana'it'it. Va yuchi ni amap'ast'ac'anic'ana'it'it tuchi ju tapasalh la'is'atsucunti ju mak'aniya lapanac ju Jonás ixjuncan. Yuchi ju ixnajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Pus alin tuchi tapasalh la'is'atsucunti chai ixlhiyuchi tac'atsa ju amachak'an Nínive ni vasalh Dios ju xamalakachai ju Jonás ju anch. Chai vana va chun ju quit'in. Ca'alina' ju tuchi catapasaya' laqui'atsucunti chai ixlhiyuchi laich ap'uc'ats'aya'it'it ju uxijnan ju chavai t'onat'it tichi chavaich ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Acsni camak'osaspitcana' ju lapanacni pus ju anu' mak'aniya chako'ulh ju xa'ucxtin ixjunita ju ixlhisur ju lacamunutpa' catayaya' chai va ixlacata yuchi pus a'ulanic'ana'it'it ju mi'alactu'unti'an ju uxijnan ju chavai t'onat'it. Pus chunch ju a'ulht'unic'ana'it'it ju uxijnan ni slivasalh na makat ju xaminacha ju yuchi ni ixk'asmatniputun ju ix'atalaninti ju Salomón. Chai ju ani icya ju palai xak'ai icjunita. Palai jantu ju Salomón. Para ju uxijnan jantu quilak'asmatniputunau ju quinchivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chai ju amachak'an ixtajunita ju Nínive catatayaya' acsni camak'osaspitcana' ju lapanacni. Chai ixlacata tuchi tanavilh ju yu'unch pus amuc'anic'ana'it'it ju mintalak'alhin'an ju uxijnan. Chai chunch ju a'ulht'unic'ana'it'it va ixlacata ni tamacaulh ix'alactu'unti'an ju yu'unch acsni tak'asmatnilh ixchivinti ju Jonás. Chai ani icya ju palai xak'ai icjunita. Palai jantu ju Jonás. Para ju uxijnan jantu mac'omp'ut'unat'it ju mi'alactu'unti'an mas k'asmat'at'it ju quinchivinti. Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju lapanacni: ");
INSERT INTO teeNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","―Jantu xamati' caxava ju ixmaclhcu chai astan va camatank'anu u ca'akxtak'ula lacacajon. Alai akts'iya ulai junta muc'acan ju maclhcu. Ju chunch va tichi chavaich ju catanuyach laich cata'alac'avanana'. ");
INSERT INTO teeNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Pus vana va chun ju milakchulh'an. Pus ni na k'ox ju milakchulh'an pus laich alac'avananat'it. Para ni jantu k'ox ju milakchulh'an pus tachi ju va t'onat'it laca'atats'isni. Chai vana va chun ju mi'atalacpast'ac'at'an. Ni alacp'ast'acnant'it k'ox pus laich amach'akxaya'it'it ixchivinti Dios. Para ni asamak'ana'it'it ixchivinti Dios pus jantu k'ox ju mi'atalacpast'ac'at'an. Chai va ixt'achunch jun ju mi'atsucunti'an tachi ju va t'onat'it laca'atats'isni. ");
INSERT INTO teeNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Pus alakts'int'it ta yu alacp'ast'acnant'it. Jantu xcai ni tachi ju va ts'ista cava lami'atsucunti'an ni va asamak'ana'it'it ju ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Pus ni alac'a'iya'it'it chux ixchivinti Dios chai jantu tu'u' asamak'anat'it pus na k'oxich lai amach'akxaya'it'it tachi acsni tamapulhcuniyan ju laminti'an ju tu'u' maclhcu. ");
INSERT INTO teeNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Pus acsni chivink'o ju Jesús pus pumatam fariseo k'ailhi'alh ju Jesús la'ixchaka' ni ca'alh t'avena'. Pus ju Jesús t'a'alh. Tanulh la'ixchaka' chai tapakstitama lacamixa ni chunch ju ixtalai. ");
INSERT INTO teeNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Para ju anu' fariseo na lhamak'aninilh acsni lakts'ilh ju Jesús ni jantu p'ulhnan na paklhu xamakchak'ai tachi ju akts'iya ixtalhilanita ju israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Para ju Jesús junich: ―Ju uxijnan ju fariseonin unt'at'it slivasalh na k'ox ch'ak'ayat'it mas va ixmacan ju tu'u' tasa chai ju tu'u' c'a'ulh tachi ju lhilanit'at'it. Para jantu navip'alat'it cuenta ixpulacni mi'alhunut'an junta na alin ju ak'alha'unti chai ju amacxcai. ");
INSERT INTO teeNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Va tontojni unt'at'it. Ju Dios ni navilh ixmacan ju tu'u' ja jantu yuchi ju vachu' navilh ju ixpulacni. ");
INSERT INTO teeNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Pus alhi'akt'ai'ut'it ju quilhpatinin ju tuch'i p'acxant'at'it. Ju chunch salaka cajuna' ju mi'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Paini'itnich ju uxijnan ju fariseonin unt'at'it. Ju uxijnan vasalh muct'axt'uyat'it ju lhamap'aksin acsni xt'akniyat'it ju palijni lacts'unin ju alhmujinu chai tachi chun ju ali' ach'itin ju pulak'oxiyat'it ju mivaiti'an chai ju ruda. Para jantu naviyat'it cuenta ni sok ju ts'uc'uyat'it u jantu. Chai jantu naviyat'it cuenta ni map'ainiyat'it ju Dios u jantu. Para palai tasq'uini ni anavit'it ju ani taxtokni mas at'ailhip'it'it ju ixtaknica lacts'unin ju ach'itin vachu'. ");
INSERT INTO teeNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Paini'itnich ju uxijnan ju fariseonin unt'at'it. Ju uxijnan k'ach'aniyat'it ju putolan ju alin ju lacpujitat junta tatolai ju xalack'ajin. Chai k'ach'aniyat'it ni catamac'amin ju lapanacni ju lacati tachi ju tamac'ami tam xak'ai. ");
INSERT INTO teeNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Paini'itnich ju uxijnan ju fariseonin unt'at'it. Ju uxijnan na acxp'ut'iyununat'it. Pus ju uxijnan chunch unt'at'it tachi ju tu'u' panteon ju jantu manicanta chai jantu lai c'atsacan ni yuchi cava. Chai ixlhiyuchi ju lapanacni taputayai ju anch. Pus vana va chun ju uxijnan. Ju lapanacni mas tat'a'ucxunt'onan chai talakts'inan ni tachi ju na va lack'oxin unt'at'it para jantu tac'atsai ni na lhquiliqui ju lamimpulacni'an. ");
INSERT INTO teeNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pus ju acsnich pumatam ju na ixlhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin xak'ala ju Jesús chai juni: ―Amamaka'unu' acsni na'un ju chunch pus vachu' macxcai quilalhichivinau ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Para ju Jesús junich: ―Paini'itnich vachu' ju uxijnan ju mavasalayat'it ju lhamap'aksin. Ju uxijnan naviyat'it tachi ju tam lapanac ju na ts'inq'ui mac'uc'ai ju ixpuru. Ju uxijnan na lhu chai na ts'inq'ui lhamap'aksin ju amuc'aniyat'it ju lapanacni tachi ju jantu lai catanavi. Para ju uxijnan nin lacats'unin jantu muct'axt'up'alat'it tachi ju najun ju anch. ");
INSERT INTO teeNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Paini'itnich ju uxijnan. Pus ju mak'aniya milacpa'itni'an tamaknilh ju lapanacni ju ixtanajun ixchivinti Dios. Chai ju uxijnan ju is'ask'at'an unt'at'it lak'oxiniyat'it ju ixpanteon'an ju xatamakni ju mimpai'an. ");
INSERT INTO teeNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Chai ni chunch ju naviyat'it pus va putasui ni c'ats'ayat'it tuchi tanavilh ju milacpa'itni'an chai k'oxich lhiulayat'it. Pus ju yu'unch ta'amakninilh chai ju uxijnan lak'oxiniyat'it ju ixpanteon'an ju amaknicanta. ");
INSERT INTO teeNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Chai ni chunch ju navip'alat'it pus yuchi chani lhinaulh ju Dios ju na k'ox ac'atsananta: “Ac'amalakachaniya' ju quilapanacni ju catanona' ju quinchivinti. Vachu' ac'amalakachaniya' ju qui'alhtanin. Chai sia yu'unch ju ac'amalakachaya' ju ali'in ca'amaknicana'. Chai ju ali'in ca'amamak'alhk'ajniya' ju anu' lapanacni”. Chunch ju ma naulh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Pus uxijnan ju t'onat'it ju chavai ju amap'ala'it'it ix'ac'alhni'an tachi chun ju lapanacni ju ixtanajun ixchivinti Dios ju amaknicalh tus la'ixputai'ulacan ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Chux ju yu'unch ju amaknicalh tus acsni tavanan maknicancha ju Abel ju p'ulhnan tucan ju maknicalh tus acsni maknicanchalh ju Zacarías ju tamakni la'ixputsin pujitat junta ixt'alakxtokya junta ixmaknican ju atapacxat ju ixlhak'ailakts'incan ju Dios. Yuchi ju sa'astan va tachi chun ju lhits'okcanta la'ixchivinti Dios mas na lhu ali'in ju amaknicalh ju palai astan. Pus uxijnan ju amap'ala'it'it ix'ac'alhni'an chux ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Paini'itnich ju uxijnan ju mavasalayat'it ju milhamap'aksin'an ju israelitanin unt'at'it. Ju uxijnan jantu sok xa'amavasalaniyat'it ju lapanacni ixchivinti Dios ni laich catac'atsaya' ta yu laich catatak'alhtaxtulh. Ju uxijnan mi'akstu'an jantu lac'a'iyat'it ju stavasalanti chai asast'uc'at'it ju talaca'iputun. ");
INSERT INTO teeNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Pus acsni ix'ajuni ju ani taxtokni ju Jesús pus ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin chai ju fariseonin slivasalh na tatalhk'amalh chai tatsuculh jeks amavanin. Chai ixtaquilhasacmich na lhu taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Va ixtalhist'ac'a chai ixtapuxconi tu'u' chivinti ju canaulh ta yu laich catapuchivimak'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Pus na lhu lana ixtatak'aixtokta ju lapanacni chai va ixtalaputayaich. Pus ju Jesús tsuculh ajunini' ju ix'amamaka'ui mas catak'asmatlh ju ali'in. Ajunich: ―Jantu alac'a'init'it ju ixchivinti'an ju fariseonin ni va ta'a'okxchok'onun ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Para mati' tu'u' ju matank'anucanta ju jantu cac'atsacalh. Nin yuchi ni lai sek acnavi ju tu'u' ju jantu cac'atsacana'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pus tachi chun ju xanonat'it laca'atats'isni cak'asmatcana' laca'atuncunu'. Chai ju tuchi va sekch xanonat'it laminchaka'an pus sich calacc'atsak'ocana'. Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","―Pus chani iclajunau ji qui'amigojni. Jantu at'alhonit'it ju mint'alapanacni'an ju lai catamaknin para astan jantuch lai tu'u' ali' catanaviyan. ");
INSERT INTO teeNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Para aclajunau tichi chavaich ju at'alhonit'it. Yuchi ju at'alhonit'it ju Dios ni yuchi ju lai catamakniyan chai alin ixtachaput ni lai catamaca'anan astan ju lacajipi. Pus iclajunau ni yuchach ju at'alhonit'it. ");
INSERT INTO teeNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Jantu tasq'uini ni at'alhonit'it ju tam mint'alapanac'an. Alakts'int'it ju lakaquis lact'icst'i ts'ok'o ni lhist'acan lakat'ui sentau. Para ju Dios jantu lai c'ap'a nin lakatam ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Chai mas va mi'ai'an ju uxijnan si putek'ek'ocanta. Pus yuchi iclalhijunau ni jantu at'alhanant'it. Palai laklhu ju mintapalhni'an ju uxijnan. Palai jantu ju va tu'u' ts'ok'o mas na lhuch catava ju yu'unch. Ju Jesús tailhi'alh ju ixchivinti chai ajuni ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","―Va tichi chavaich ju canona' la'ix'ucxlacapu'an ju lapanacni ni quilhilaksi ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani pus vachu' ju quit'in acnona' la'ix'ucxlacapu'an ju ix'anquilhnin ju Dios ni quilapanac junita ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Para va tichi chavaich ju canona' la'ix'ucxlacapu'an ju lapanacni ni jantu quilhilaksich pus vachu' acnona' la'ix'ucxlacapu'an ju ix'anquilhnin Dios ni jantu quilapanac junita. ");
INSERT INTO teeNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Chai tachi chun ju macxcai aquintalhichivina' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani pus ca'amac'acxanicana'. Para va tichi chavaich ju macxcai calhichivina' ju Spiritu Santu pus ju yuchi jantu catimac'acxanicalh. ");
INSERT INTO teeNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Acsni alhip'inc'ana'it'it la'ix'ucxlacapu'an ju xalack'ajin lacpujitat chai la'ix'ucxlacapu'an ju ucxtinin chai ju ali'in ju alin ixtachaput'an pus jantu alhamak'aninint'it ta yu laich alhak'alht'ayanana'it'it nin yuchi ju tuch'i laich anona'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Pus is'akstu ju Spiritu Santu ju catamapast'ac'aniyan ju acs pants'iquis tuch'i laich anona'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Chai pumatam lapanac ju ixmakminta lacatalhavat junilh ju Jesús: ―A'unch ju quilak'au ni chach quilhvaknilh ju icmacontilanicantauch. ");
INSERT INTO teeNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Para ju Jesús junich: ―Ji lapanac jantu xamati' qui'ulata lacat'icst'i mi'ucxtin'an. Nin ca'alilh ju quintachaput ni lai aclaclhvaka' ju tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Vachu' ajunilh ju lapanacni: ―Alakts'int'it chai jantu va yuchi ju anavit'it cuenta ju ixmak'aixt'ok'a lhu ju mi'alinta'an. Pus mas na lhu ca'alilh ju ix'alinta tam xamati' para jantu anch ju i ju is'atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Chai ajunilh ju lapanacni lakatam chivinti ju laich capumavasalaniya' tuchi ix'ajumputun. Ajunich: ―Ju ixlacat'un ju pumatam mak'ali' lapanac na lhu lana xaxt'ak'a ju xatoc'at. ");
INSERT INTO teeNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chai ju yuchi naulh la'ix'alhunut: “Tas aclayach ju chavai ni jantu jinta' alin junta lai acmak'a ju xatoc'at ju quilacat'un”. ");
INSERT INTO teeNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Chai astan naulh: “Icc'atsai tuchi acnaviya'. Aclaclhvakach ju quimpac'ats'a chai acyochokoya' ju palai k'ai. Chai anchach ju acmak'aya' ju xatoc'at ju quilacat'un chai ju quintaxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Chai chani acjunchokocana' qui'akstu: Ju uxint'i lapanac na lhuch mak'ata ju mi'alinta. Cach'ixach lakalhu c'ata. Pus ast'acnach. Avaich. Ak'otnuch. Ak'ach'ach”. Chunch ju naulh ju anu' mak'ali'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Para ju Dios ma junich: “Ju uxint'i va tonto'at. Lana chavai atats'isni aniya'. Chai tis ix'anuch c'u'u cajuna' ju anu' xamak'ai”. ");
INSERT INTO teeNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Pus chunch ju tapasai la'is'atsucunti tam lapanac ju lhilaksi ju ixtaxtokni ju mak'aixtokta ixlacata is'akstu para jantu lhilaksi ju mak'alit ju xt'ak'a ju Dios chai ju jonk'alhita lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Astan ju Jesús axak'alachokopa ju ix'amamaka'ui chai ajuni: ―Jantu alhamak'aninint'it ixlacata ju mi'atsucunti'an ju tuch'i a'uya'it'it. Nin ixlacata ju milacatuna'an ju tuch'i amalakch'inina'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Pus palai tu'u' ju mi'atsucunti'an ju uxijnan. Palai jantu ju va tu'u' vaiti. Chai palai tu'u' ju milacatuna'an. Palai jantu ju va tu'u' malakch'inti. ");
INSERT INTO teeNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Alakts'int'it ju tu'u' ch'ekni. Ju yu'unch jantu ta'ach'ananan chai jantu taxk'a'i ju catamak'aya' ju xatoc'at. Chai mati' junta lai catamak'a ju tu'u' nin ca'alilh ju ixpac'ats'a'an. Para Dios ju amavai. Chai ju yuchi palai tu'u' talhiulayan ju uxijnan. Palai jantu ju va tu'u' ts'ok'o. ");
INSERT INTO teeNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Chai jantu xamati' ju milhi'uxijnan ju lai palai putank'ai catijunlh mas na lhu capastaclh. ");
INSERT INTO teeNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Pus ni jantu lai naviyat'it mas va yuchach ju anu' pus tajuch ni na va lhamak'anininat'it ju tu'u' ali'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Pus alakts'int'it ju xanti. Ju yuchi tak'ayai para jantu ch'alhcatnan nin ca'asiunilh. Para iclajunau nin yuchi ju k'ai ucxtin Salomón jantu xamalakch'inin tachi ju tu'u' xanti mas na ix'alin ju ixmak'alit. ");
INSERT INTO teeNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Pus Dios ju na c'us malakch'ini ju ach'itin ju alin mas va lacaq'uivin. Chai ju yuchi jantu jonk'alhi. Ju chavai na stak'auca'. Para ju lhi calacxavacana'. Pus ja va a ti uxijnan jantu cataxtakniyan ju mimpumpu'an. Para ju uxijnan na lacats'unin lhilaksiyat'it ju Dios ni vasalh cataxtakniyan ju tuch'i makt'asq'uiniyat'it. ");
INSERT INTO teeNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pus ni yuchi ju Dios ju cataxtakniyan ju tuch'i makt'asq'uiniyat'it pus jantu alhamak'aninint'it tuch'i a'uya'it'it u tuch'i ak'ot'a'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jantu chun alat'it ju uxijnan ni yuchach ju talhamak'aninin ju lapanacni ju jantuca' talhilaksita ju Dios. Para alin ju mimpai'an Dios ju c'atsai ni makt'asq'uiniyat'it ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Alai yuchi ju anavit'it cuenta ta yu palai lai calhinona' ju Dios lami'atsucunti'an chai amaklht'ayanana'it'it tachi chun ju ani taxtokni ju makt'asq'uiniyat'it. Ju Jesús tailhi'alh ixchivinti chai chani ju ajuni ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","―Jantu at'alhanant'it ju uxijnan ju tachi quimborregojni unt'at'it mas jantu milhu'an. Pus ju quimpai na k'ox lhiulai ni at'at'a'ucxt'iniya'it'it ju yuchi astan. ");
INSERT INTO teeNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Jantu na va amak'at'it ju mi'alinta'an. Alai ap'u'akt'ai'ut'it ju quilhpatinin. Jantu amak'at'it ju mimak'alit'an ju ani lacat'un junta jantu jonk'alhi. Alai anch ju lact'iyan ju amak'aya'it'it. Pus ju anch ju mimak'alit'an jantu tavanan ca'ank'oya'. Chai jantu lai caticha'alh ju ak'alhona'. Chai mati' tu'u' ju sa'ats'acana' ju lai calak'alhiniyan. ");
INSERT INTO teeNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Iclajunau chunch ni tapastact'ajun ju ixtaxtokni ju lacamunutpa' ju tamak'ata ju ixmak'alit'an ju ani lacat'un. Para ju tamak'ai ju ixmak'alit'an ju lact'iyan pus anchach ju tapastact'ajun. Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","―Alak'asits'uc'ut'it chai chunch ju alat'it tachi ju lacan acsni pacxantaican xamati' ju ts'is. Va xavacan ju maclhcu ni lai lhik'ach ca'amaklhtayanancana' ju cachina'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Chai chunchach ju ap'acxant'aya'it'it ju mi'ucxtin'an Dios tachi ju talai ju ixlapanacni tam xak'ai ju ani lacamunutpa'. Pus ju yu'unch talakasivilanalh ni lana soko catamalhtek'aniya' ju malhtich acsni catasp'itchokoyanta ju ix'ucxtin'an junta tamak'axtokcan chai casayach ju malhtich. ");
INSERT INTO teeNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Pus lhik'ach cajuna' ju is'atsucunti'an ju anu' xalapanacni ju ca'alhitajucana' ni talak'asit'ajun acsni camina' ju ix'ucxtin'an. Pus islivasalh ju iclajunau. Ju ix'ucxtin'an ni lakch'ita ju ixcutun pus calhich'icana' iscinturon chai ca'alacjunach ni catatavi lacamixa chai is'akstu ju ca'alacxtakniyach ju ixvaiti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Pus na lhik'ach ju is'atsucunti'an ju anuch xalapanacni ju ca'alhitajucana' ni talak'asit'ajun mas camilh ju ix'ucxtin'an ju paitat ts'is u mas camilh acsni pakt'utu t'asata ju chila'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pus ac'ats'at'itch ju ani. Ju amachaka' ni isc'atsa cava tuchi hora ixmilh ju ak'alhona' pus ixlhistaclh chai jantu ixlacasq'uinilh ni ixtamalhtek'a chai ixtanu la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Pus vachu' alak'asits'uc'ut'it ju uxijnan ni acsnich ju acminchokoya' ju quit'in acsni nonat'it ni ca jantu lai actimilh ju acs pants'iquis. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pus ju acsnich ju Pitalu' junilh ju Jesús: ―Qui'ucxtin ja va quijnan ju quilajunau ju ani chivinti ju ixp'umavasalap'ut'un ju minchivinti u vachu' ixlacata'an chux ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Chai ju Jesús juni: ―Alin ju xak'ai xalapanac ju lai lhilaksican chai ju na ac'atsananta chai lai ca'amalhistacni ju ix'ucxtin ju ali'in ixt'axalapanacni ni laich ca'alhcaniya' ju ixvaiti'an acsni cachina' ju hora ni catavena'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Pus slivasalh lhik'ach ju is'atsucunti ju anu' xalapanac ju calhitajucana' ni chunchach ju t'ajun navini' acsni caminchokoya' ju ix'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pus slivasalh ju iclajunau. Ju ix'ucxtin camalhistacnik'oya' tachi chun ju ix'alinta. ");
INSERT INTO teeNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Para ju anu' xalapanac jantu xcai ni canaulh la'ix'alhunut ni ca jantu sai catiminchokolh ju ix'ucxtin chai catsucuya' a'ulanini' ju ixt'axalapanacni chai ju maksquitininch. Chai cavenach chai ca'ak'otnanach chai cat'ak'ap'ayach. ");
INSERT INTO teeNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Pus ni chunch ju canaviya' ju anu' xalapanac pus acsnich ju cachina' ju ix'ucxtin acsni jantu pacxantajita. Cachina' ju acs pants'iquis acsni jantu isc'atsai ni lai cachilh. Chai slivasalh camamak'alhk'ajniya' ju anu' xalapanac. Chunch ca'ulhtunicana' tachi ju ca'ulhtunicana' ju yu'unch ju jantu lai lhilaksican. ");
INSERT INTO teeNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Pus ju anu' xalapanac ju machakxanilh ixk'achat ju ix'ucxtin para jantu ixlakasivi ni xaminchokoi ju ix'ucxtin nin canavi ju ixk'achat pus ju yuchi na paklhu canekcana'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Para ju anu' xalapanac ju jantu xamachakxai ju ixk'achat ju ix'ucxtin chai navilh ju tu'u' ju lhijunch ni calhinekcalh pus na lacats'unin calakanekmacana'. Pus va tichi chavaich ju na lhu xtaknicanta pus na lhu casq'uinichokocana'. Chai ju na lhu xtaknicanta ni calhistaclh pus palai lhu casq'uinichokocana'. Palai jantu na chun ju jantu lhu ixtaknicanta ni calhistaclh. Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","―Tachi ju va icminta maquilhnunu' ju jipi ju ani lacat'un. Chai slivasalh na k'ox cava ni lana chavai ju catai'ulaya'. ");
INSERT INTO teeNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Na lhu lana acmak'alhk'ajnana' chai slivasalh na ic'amak'aninin tus acsni ca'uctaxtuyach. ");
INSERT INTO teeNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Jantu ana'unt'it ni va icminta navini' ju ak'oxamixnit ju ani lacat'un. Iclajunau ni jantu. Alai va ixlaca'atalh ni icminta ca'alina' ju lak'aiti. Caxcaicana' ju yu'unch ju quintalhilaksi. ");
INSERT INTO teeNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Pus ju chavai atipu'anta junta tat'ajun pumaquis lapanacni lacalakatam chaka' pus jantu k'ox catalalhi'ana'. Pus ixt'utun'an cataxcaya' ju pumat'ui'an. Chai ju ixt'iyun'an cataxcaya' ju ixt'utun'an va ixlacata ni quintalhilaksi ju quit'in ju ali'in chai ju ali'in jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ju tam xapai cat'alaxcaya' ju ists'alh. Chai ju tam ists'alh cat'alaxcaya' ju ixpai. Ju tam xanati cat'alaxcaya' ju istsi'. Chai ju tam istsi' cat'alaxcaya' ju ixnati. Chai ju tam xaput'ichako'ulh cat'alaxcaya' ju ixput'i. Chai ju tam xaput'i cat'alaxcaya' ju ixput'ichako'ulh ni quilhilaksi ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ju Jesús vachu' chani ajuni ju lapanacni: ―Ju uxijnan acsni lakts'inat'it ju ataputs'i acsni min ju lhits'ast'ai pus lana nonat'it ni caminach ju xcan ju ani laquint'un'an. Chai vasalh chunch ju tapasai. ");
INSERT INTO teeNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Chai acsni min ju un ju lhisur pus nonat'it ni lhi'ich cajuna' ju ani laquint'un'an. Chai vasalh chunch ju tapasai. ");
INSERT INTO teeNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Pus ju uxijnan lai mach'akxayat'it ta yu avanan ju lact'iyan chai ju lacat'un. Para va acxp'ut'iyununat'it acsni nonat'it ni jantu lai mach'akxayat'it tuchi t'ajun tapasana' ju chavai acsni t'onat'it. ");
INSERT INTO teeNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tajuch ni jantu lai sacxt'uyat'it mi'akstu'an ju k'ox. ");
INSERT INTO teeNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ni catachivimak'anan tam xamati' chai catak'ailhi'anan lacapu'ucxtin pus amask'at'it'itch ju lacati ixt'atak'oxica ju yuchi. U ni jantu pus jantu xcai ni catalhicha'anan laca'ucxtin. Chai ju ucxtin catamak'axtak'an la'ixmaca'an ju pulasiyajni. Chai ju pulasiyajni cata'anan t'alhnunun. ");
INSERT INTO teeNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Chai iclajunau ni jantu at'it'axt'ut'it ju anch tus acsni amap'ala'it'it chux lana ju mimulhta'an. ");
INSERT INTO teeNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Pus ju acs pants'iquis tachinchalh ju ali'in ju tamac'atsani ju Jesús ixlacata'an ju amachak'an ju xa'estado Galilea ju alhinaulh ix'amaknica'an ju gobernador Pilato. Tajuni ni anch ju amakni junta makninican ju atapacxat ju Dios. Pus ju ix'ac'alhni'an lhitayalh ju ix'ac'alhni ju atapacxat. ");
INSERT INTO teeNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Chai ju Jesús ajunich: ―Ja va nonat'it ni palai na alactu'unin ixtajunita ju anu' amachak'an Galilea. Palai jantu ju ali'in ixt'a'amachak'an. Chai yuchi alhimaknicalh. ");
INSERT INTO teeNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iclajunau ni jantu. Para ni jantu amac'ona'it'it ju mi'alactu'unti'an ju uxijnan pus vachu' ats'ank'aya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Chai ju anu' pumacautsajin amachaka'an Jerusalén ju atant'alhma ju putank'ai chaka' ju lacSiloé chai tanik'o ja va nonat'it ni palai na alactu'unin ixtajunita ju yu'unch. Palai jantu ju ali'in ixt'a'amachak'an. Chai yuchi alhimaknicalh. ");
INSERT INTO teeNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Iclajunau ni jantu. Para ni jantu amac'ona'it'it ju mi'alactu'unti'an ju uxijnan pus vachu' ats'ank'aya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ju Jesús ajuni ju lapanacni ju ani chivinti ju ixt'alakts'ipaxcavaich ju tu'u': ―Pumatam lapanac ch'anlh lakatam q'uiu ju higuera juncan. Anch ju xach'an la'ixpu'uvas. Chai astan ju yuchi milh puxconini' ju xalhi'ut. Para jantu lhitajunilh. ");
INSERT INTO teeNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Chai junilh ju ixlhistacna' ju pu'uvas: “Ju chavai ixlhilakat'utu c'ata icminta puxcona' ju xalhi'ut ju ani ya higuera chai jantu tu'u' iclhitajunita. At'ich'akxt'at'i. Va lak'aich atank'asinin ju ani lacat'un”. ");
INSERT INTO teeNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Para ju anu' alhistacna' junich ju ix'ucxtin: “Qui'ucxtin va yuchi ju chavai c'ata ju amac'oninch. Aclacpujniya' ju t'un ju ixtalakachoko chai acmamaya' ju ix'ilht'i borrego. ");
INSERT INTO teeNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Chai ni ca'alinach ju xalhi'ut pus k'oxich. Para ni jantu pus acsnich ju laich at'ich'akxt'aya'ich”. ");
INSERT INTO teeNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lakatam savat ju Jesús ix'amalanininch la'ixpujitat'an ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chai ju anch ixtanun pumatam chako'ulh ju ixpacxanta ju lhacaticuru la'ixlacatuna chai ixlhiyuchi va ixtak'ank'ai. Va ixlakatumich. Jantu tavanan lai sok ixtayai. Lakacautsajin c'ata ju ixtak'ank'ai. ");
INSERT INTO teeNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Chai ju Jesús acsni lakts'ilh t'asanilh chai junich: ―Chako'ulh macaxnitan ju mintak'ank'at. ");
INSERT INTO teeNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Chai mokslanilh ju ixmaca' la'ixlacatuna chai lana tasoknic'a ju ixlacatuna. Chai ju yuchi lak'ayalh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Para ju xa'ucxtin lacpujitat na lhitalhk'amalh ni ix'ac'uch'ununta ju Jesús ju avilhchan pa'astacni. Chai ajunich ju ixtalhavat lapanacni ju ixtamakvilanalh: ―Alin lakachaxan avilhchan acsni lai ch'alhcatnancan. Pus acsnich ju at'at'it t'ac'uch'unin. Para jantu ju avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pus ju acsnich ju Jesús junilh ju anu' xa'ucxtin lacpujitat: ―Ju uxint'i va acxp'ut'iyunun. Ju pumatamin ju milhi'uxijnan ja jantu xk'ot'at'it ju mivacax'an u mimpuru'an ju la'ixchaka' ju avilhchan pa'astacni chai p'inat'it mak'ot'unin ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pus ju ani chako'ulh ixpapanti Abraham junita. Chai lakacautsajin c'ata ju ixch'ita ju Satanás. Chai ja jantu lhijun ni acxk'otnilh ju yuchi ju avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Chai acsni naulh ju ani chivinti ju Jesús pus na tamaxanalh chux ju ixt'alaxcai. Chai tachi chun ju lapanacni na ixtalhik'achanch tachi chun ju k'oxi taxtokni ju ixt'ajun navini' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Pus ju acsnich ju Jesús ajuni ju lapanacni: ―Tamalhch nu' ju ixt'achunch jumputun tachi acsni lhinajun ju Dios la'is'atsucunti'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Acsni lhinajun ju Dios la'ix'alhunut'an ju lapanacni pus na lhu talhilaca'an ju Dios. Chunch ju tapasai tachi ju tapasai acsni ch'ancan ju xat'in mostaza. Pus tam lapanac ni cach'anlh ju yuchi la'ixlacat'un pus ju anu' ach'ananti tak'ayai chai tasui tachi ju lacat'icst'i q'uiu. Chai ju ts'ok'o tamuc'ai ixpamalhiqui'an la'ix'acatan. ");
INSERT INTO teeNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ju Jesús vachu' chani ajuni ju lapanacni: ―Tas malhch nu' ju va ixt'achunch acnaviya' tachi acsni lhinajun ju Dios la'is'atsucunti'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Pus ju anu' lapanacni chunch tajunita tachi ju tu'u' xat'in xkapavati ju calhiyaulh tam chako'ulh ju lakat'utu ach'apanta harina. Pus lhitayak'ojui chux. ");
INSERT INTO teeNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ju Jesús aktam ch'apachokopa ju xati ju Jerusalén. Chai acsni ixtapasatilai ju k'ai lak'achak'anixni u ju lact'icst'i lak'achak'anixni pus ix'amalani ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Chai pumatam junilh: ―Qui'ucxtin ja na lacats'unin ju tatak'alhtaxtui. Chai ju Jesús junich: ");
INSERT INTO teeNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","―La'ixlhichux mi'alhunut'an anavit'it cuenta ni at'anuya'it'it ju lact'iyan ni na acsat'icst'i ju xamalhtich. Iclajunauch chunch ni astan na pumalhu ju catatanuputunach ju anch para jantu lai catitanu. ");
INSERT INTO teeNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jantu lai ni cak'ostola' ju amachaka' chai camalacchoyach ju malhtich. Chai astan ju uxijnan at'ayaya'it'it makspa' chai ats'uc'uya'it'it sanin ju malhtich chai anona'it'it: “Ucxtin aquilamalhtek'aniuch”. Para ju yuchi catak'alhtayan chai catajunanch: “Jantu iclamispayau. Jantu icc'atsai ta anchach ju xat'anachit'it”. ");
INSERT INTO teeNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Chai ju acsnich ju uxijnan ats'uc'uya'it'it nonin: “Pus xaclat'avenau ju uxint'i chai xaclat'ak'ot'au. Chai laxalacti ju quilak'achak'an quinc'an ju ix'amalaninin ju uxint'i”. ");
INSERT INTO teeNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Para ju yuchi catajunanch: “Iclajunau ni jantu iclamispayau. Jantu icc'atsai ta anchach ju xat'anachit'it. Ak'ost'it ju laquimacni tachi chun ju uxijnan ju va alactu'unin unt'at'it”. ");
INSERT INTO teeNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Chai ju uxijnan ak'alhununa'it'it chai alamats'ac'aya'it'it ju mintatsalat'an acsni alakts'ina'it'it ju Abraham chai ju Isaac chai ju Jacob chai tachi chun ju lapanacni ju ixtanajun ixchivinti Dios ni tavilanalh junta lhinonk'ojui ju Dios ju lact'iyan. Para ju uxijnan va xc'oxt'uc'ant'at'it. ");
INSERT INTO teeNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Pus cataminanta ju lapanacni ju lhich'ato'anta chai ju lhits'ast'ai chai ju lhisur chai ju lhinorte chai catatolanta lacamixa junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chai ju acsnich cata'alinanta ju lapanacni ju mak'anch xaquintalhilaksi. Para jantu lai actinaulh ni va ixlhiyuchi palai k'ox ca'alhiulacana'. Chai vachu' cata'alinanta ju lapanacni ju jantuca' mak'an xaquintalhilaksi. Para jantu lai actinaulh ni va ixlhiyuchi palai jantu k'ox ca'alhiulacana'. ");
INSERT INTO teeNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Pus ju acsnich avilhchan tachincha ju ali'in fariseonin chai tajunich ju Jesús: ―At'axt'uch ju ani. A'inchich. Pus ju Herodes najun ni camakniyan. ");
INSERT INTO teeNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Para ju Jesús ajunich: ―A'inch'ok'ochit'it juninin ju anu' a'okxchok'onu lapanac ni actixcoxtuya' ju lhacaticuru la'ixlacatuna'an ju lapanacni chai palaich ac'anaviya' ju tak'ank'anin ju chavai chai ju lhi. Chai ju ixlhilakat'utu avilhchan acnavik'oyach ju quilhich'alhcat. Chunchach ju a'una'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Para mas jantu ictalhoni ju Herodes akts'iya tasq'uini ni ac'alhtanatsucuya' ju chavai chai ju lhi chai ju t'uxam. Tasq'uini ni chunch aclalh ni jantu lhijun ni jantu canichalh ju lak'achak'an Jerusalén tam lapanac ju najun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ji amachak'an Jerusalén ju uxijnan makniyat'it ju lapanacni ju tajunan ixchivinti Dios. Chai alac'at'alhmat'it ju yu'unch ju amalak'ach'anic'ant'achit'it. Pus na paklhu xaclamak'aixtokputunau ju uxijnan tachi ju navi is'ask'at'an ju tu'u' chila' acsni amakatai la'ixpak'achu ni laich ca'alhist'ac'a'. Vachu' xaclamak'aixtokputunau ju uxijnan tachi ju qui'ask'at'an ni laich xaclalhistacvi. Para ju uxijnan jantu xalac'asq'uinat'it. ");
INSERT INTO teeNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Pus ju chavai Dios maco'ulata ju milak'achak'an'an. Chai iclajunau ni jantu lai aquintilalakts'inchoko ju chavai. Va acsni ju aquilalakts'inchokoyau acsni cachina' ju avilhchan ni acminchokoya' chai chani anona'it'it ju quilacata: “Paxcat ju ani ju minta la'ixtapaka'ut ju Dios”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Pus lakatam avilhchan pa'astacni ju Jesús alh vena' la'ixchaka' pumatam xak'ai fariseo. Chai ju ali'in fariseonin na ixtalhistact'ajun ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Chai vachu' anch ixya pumatam lapanac la'ix'ucxlacapu' ju Jesús. Chai ju yuchi va ixlacac'unta. ");
INSERT INTO teeNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Pus ju acsnich ju Jesús axak'ala ju fariseonin chai ju ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Ajunich: ―Ja lhijunch ni ac'ac'uch'unulh ju avilhchan pa'astacni u jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Para ju yu'unch jantu tu'u' ta'ak'alhtayanalh. Pus ju acsnich ju Jesús macch'apalh ju anu' lapanac chai lana palaich va. Chai astan malakachachokolh la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Chai alacjuni ju fariseonin: ―Tis chavaich ju milhi'uxijnan ju jantu vats'alhti camacutulh mas avilhchan pa'astacni ju mimpuru u mivacax ni catin'alh junta puculhucnic'a. ");
INSERT INTO teeNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Pus ju yu'unch jantu lai tu'u' ixtamapusp'itni ju ani chivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Pus ju aktam acsni tatsuculh tolhnin lacamixa pus ju Jesús alakts'ilh ni ixchux'an ixtatolhputun lacatants'i junta ixtatolai ju xalack'ajin. Pus yuchi alhijunilh lakatam chivinti ju ix'apumavasalaniputun ta yu catalalh. Ajunich ju ixtamakvajin vachu' ju yuchi: ");
INSERT INTO teeNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Acsni xamati' ju catak'ailhi'anan junta alin ju tamak'axtoknut pus jantu anch ju at'olat'it junta tatolai ju xalack'ajin. Pus jantu xcai ni cak'ailhimincalh pumatam ju palai xak'ai. Palai jantu ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Chai ju xak'ailhiminan ju uxint'i cat'alakminan ju ak'antam chai cajunan: “Axt'akninch ju mimputolan ju ani ya lapanac”. Pus ju acsnich na amaxanana'ich chai ap'ina' tolhna' junta tatolai ju yu'unch ju palai jantu tu'u' ixtapalhni'an. ");
INSERT INTO teeNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Alai chani alat'it acsni jinta' k'ailhip'inc'ana'it'it. Pus anchach ju at'olat'it junta tatolai ju jantu tu'u' ixtapalhni'an. Chai ju chunch acsni catalakts'inan ju tak'ailhi'antan laich catajunan: “Qui'amigo anchach ju at'ola' junta tatolai ju xalack'ajin”. Pus ju acsnich na alak'ayac'ana' la'ix'ucxlacapu'an ju va k'aixtam tat'atolan lacamixa. ");
INSERT INTO teeNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pus chunchach ju alat'it ni calalacat'icst'icana' va tichi chavaich ju lak'ayachokocan is'akstu. Para ju tichi t'alacat'icst'i pus calak'ayacana'. ");
INSERT INTO teeNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Vachu' chani juni ju Jesús ju anu' ju xak'ailhi'an la'ixchaka': ―Ju uxint'i acsni anaviya' ju tu'u' k'ai lacvaiti pus jantu va yu'unch ju at'asani ju mi'amigojni u mi'alak'avin u yu'unch ju milhi'alak'avin u yu'unch ju na mak'alinin ju vanin alact'avilht'i. Pus ni chunch ju alat'i pus jantu xcai ni catak'ailhi'anchokoyan vachu' ju yu'unch chai ju chunch va catamapalhnichokoyan. ");
INSERT INTO teeNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Para acsni anaviya' ju tu'u' c'atan pus alai yu'unch ju at'asanit'i ju quilhpatinin chai ju macmututu chai ju ch'antak'alhita chai ju alak'ach'ixnin. ");
INSERT INTO teeNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Chai ju chunch lhik'ach ats'uc'uya' ni jantu lai catamapalhnichokoyan ju yu'unch. Para amap'alhc'ana' acsni catalok'onchokoyach ju yu'unch ju soknic'a alakts'in ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pus acsni k'asmatlh ju ani chivinti pumatam ju ixmakvi lacamixa pus junilh ju Jesús: ―Slivasalh lhik'ach ju is'atsucunti ju camakvena' acsni catai'ulaya' ixpu'ucxtin ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Pus ju acsnich ju Jesús juni: ―Pumatam lapanac navilh lakatam k'ai tok'oxayavaiti. Chai na pumalhu ju alact'asanilh. ");
INSERT INTO teeNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Chai acsni tucanch cavencana' pus malakachalh pumatam ixlapanac ni ca'alh at'asanini' ju catamakvena'. Cajunilh: “Ma inchit'it. Ma alinch ju chavai ju vaiti”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Para ixchux'an tatsuculh nonin ni jantu lai catita'alh. Pus ju xap'ulhnan junilh: “Ictamaulh lakatam k'ai lacat'un chai tasq'uini ni ac'alh lakts'ini'. Icsq'uiniyan lamapainin. Aq'uimac'acxanin ni jantu lai acti'ancha”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Chai ju apumatam junich: “Ictamaulh lakacau vacax chai ac'ana' alakts'intanunu'. Icsq'uiniyan lamapainin. Aq'uimac'acxaninch ni jantu lai acti'ancha”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Chai ju apumatam junich: “Ju quit'in va ictamak'axtoklica' chai yuchi jantu lai actilhi'alh”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Pus anchokolh ju anu' xalapanac. Alh junini' ju ix'ucxtin tuchi ixtanajunch ju lapanacni. Pus ju acsnich na talhk'amalh ju amachaka'. Chai junchokolh ju ixlapanac: “Vats'alhti a'inchich ju lacak'ai ti chai lacalact'icst'i ti ju lak'achak'an. Ak'ailhit'ana'ich ju quilhpatinin chai ju macmututu chai ju ch'antak'alhita chai ju alak'ach'ixnin”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Chai acsni navik'olh ju chunch ju xalapanac pus junchokopa ju ix'ucxtin: “Qui'ucxtin icnavita tachi ju xaq'ui'uni para ti'alinca' ju tants'i ju lacamixa”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Chai ix'ucxtin juni ju ixlapanac: “Ap'inchich ju k'ai ti ju lacamacni chai ju macat'icst'i ti ju lacacuxtu. K'asi ajuni ju lapanacni ni catamilh. Chach aktsamalh ju quinchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Chunch ju anaviya' ni icjunan ni jantu xamati' ju p'ulhnan ic'at'asanilh ju caquilhc'atsaya' ju quivaiti”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pus na lhu lapanacni ixtat'a'anta ju Jesús. Chai ju yuchi talakasp'itlh chai ajunich: ");
INSERT INTO teeNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Ni xamati' quilakmin chai ni cajumputulh quintamamaka'un tasq'uini ni palai tu'u' aquilhiulaya' ju quit'in. Palai jantu ju ixpai, ixnati, chai ix'amachaka' chai is'ask'at'an chai ix'alak'avin ts'alan chai ix'alak'avin atsi'in chai mas is'atsucunti is'akstu. Para ni jantu quimapaini ju chunch pus jantu lai cativa ju quintamamaka'un. ");
INSERT INTO teeNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Chai va tichi chavaich ju najun ni jantu quinch'ak'ok'aputun va ixlaca'atalh ni va lai mamak'alhk'ajnicalh pus jantu lai cativa ju quintamamaka'un. ");
INSERT INTO teeNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Pus pumatam ju milhi'uxijnan ni cayoputulh lakatam putank'ai chaka' akts'iya p'ulhnan calacalhcaxtulh tas chunchach calhi'ana' ju ixtapalh. U ni laich cha'an tachi ju maktasq'uinich ju capunavik'oyach u jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Pus ni jantu chun calalh pus jantu xcai ju astan ni tai'ulata jantu lai navik'ojui. Camak'anc'acxlh tu'u' chai jantu calhiva ju capunavik'o. Pus ju acsnich tachi chun ju lapanacni ju catalakts'inach catalhits'i'inach. ");
INSERT INTO teeNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Chai catanaulh: “Ju ani lapanac tai'ulalh ixnavica ixchaka' para jantu lai xanavik'ojui”. ");
INSERT INTO teeNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Chai ju tam k'ai ucxtin ni ca'amputunach t'alasana' ju ixt'ak'ai ucxtin akts'iya p'ulhnan capast'ac'a' u ni laich caput'alalhajalh ju lhiminta lakap'uxam milh taropajni u jantu. Ju yuchi ni va lakacau milh ju ixtaropajni. ");
INSERT INTO teeNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Chai ni najun ni jantu lai catit'alalhajalh pus camalakachanilh pumatam ixlapanac chai casacmiyach tas laich cat'atak'oxi ni jantu catalaclasa. Chunch ju canaviya' acsni na makatca' ju mintacha ju ixt'ak'ai ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Pus vana va chun ju uxijnan. K'oxich ap'ast'act'it u ni lai a'una'it'it ju quintamamaka'un u jantu. Pus va tichi chavaich ju milhi'uxijnan ju jantu lacasq'uin ni quit'in ju aclhinonk'oya' tachi chun ju ixtaxtokni ju pacxanta pus jantu lai cativa ju quintamamaka'un. ");
INSERT INTO teeNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Na k'ox ju matsat. Para ju matsat ni jantu sk'ok'o cava pus jantu lhitapalai. ");
INSERT INTO teeNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pus jantu k'ox junita ixlacata ju lacat'un nin lai abono acpu'ulhtulh. Alai va camak'ancanach. Pus ju alin ju ixpak'asmatni cak'asmatlich. ");
INSERT INTO teeNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Pus tachi chun ju ach'inin chai ju alactu'unin talakmilh ju Jesús ni va ixtak'asmatniputun ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Para ju fariseonin chai ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin ixtalhichivinin ju Jesús. Ixtanajun: ―Ju yuchi k'ox alact'alalhi'an ju alactu'unin chai alact'avajin ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Pus ju acsnich ju Jesús ajunich ju ani chivinti ju ix'apumavasalaniputun tuchi ix'amalaniputun. Ajunich: ");
INSERT INTO teeNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ju pumatam milhi'uxijnan ni capacxalh tam cientos ixborregojni chai ni camak'ats'ank'a lakatam ja jantu calacmacoyoya' ju noventa y nueve junta tat'ajun venin chai ca'alh puxcona' ju ists'ank'ata tus calhitajuya'. ");
INSERT INTO teeNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Chai acsni calhitajuyach pus camuc'aya' la'ix'akxp'un chai calhimina' chai na cak'achanach. ");
INSERT INTO teeNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Chai acsni cachinach la'ixchaka' pus ca'alact'asaniya' ju ix'amigojni chai ixt'atolhnin chai ca'alacjunach: “Quilat'ak'achauch ni iclhitajulh ju quimborrego ju xacmak'ats'ank'ata”. ");
INSERT INTO teeNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Pus iclajunau ni vana va chun ju lact'iyan. Palai calhik'achancana' ju tam alactu'unu' acsni macajun ju ix'alactu'unti. Palai jantu calhik'achancana' ju noventa y nueve lapanacni ju tanajun ni na soknic'a junita ju is'atsucunti'an chai ixlhiyuchi jantu tasq'uini ni catamacaulh ju ix'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Ju tam chako'ulh ju capacxalh lakacau tumin ni camak'ats'ank'a ju lakatam ja jantu caxavaya' ju ixmaclhcu chai ca'ap'alhnanach la'ixchaka'. Lacsni lacsni capuxcoya' tus calhitajuya'. ");
INSERT INTO teeNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Chai acsni calhitajuyach ca'alact'asaniya' ju ix'amigojni chai ju vanin alact'avi chai ca'alacjunach: “Aquilat'ak'achauch ni iclhitajulh ju quintumin ju xacmak'ats'ank'ata”. ");
INSERT INTO teeNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pus iclajunau ni vana va chun talhik'achan ju ix'anquilhnin ju Dios acsni camaconach ix'alactu'unti ju tam alactu'unu'. ");
INSERT INTO teeNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Chai ju Jesús axak'alachokopa ju lapanacni. Ajunich: ―Pumatam lapanac ix'alin ixt'iyun'an ists'alan. ");
INSERT INTO teeNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Chai ju salacat'icst'i ists'alh junilh ju ixpai: “Quimpai aq'uilhvakninch ju mi'alinta ju qui'anuch cajunach”. Pus ju ixpai alaclhvaknilh. ");
INSERT INTO teeNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Chai jantu mak'an va ju salacat'icst'i ists'alh mak'aixtoklich ju ix'alinta. Alh makat alacatam lacat'un. Chai ju anch quilhak'amanank'o laca'alactu'unti tachi chun ju ixtaknicanta. ");
INSERT INTO teeNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Chai acsni lhak'amanank'o pus milh lakatam k'ai chavan ju anu' lak'achak'an chai ju yuchi tsuculh mak'alhk'ajna'. ");
INSERT INTO teeNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Chai lakxcavatailich pumatam amachaka' anch. Chai ju yuchi malakacha la'ixpotrero ni va ca'alh alhistacna' ju ixp'axnin. ");
INSERT INTO teeNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Chai ju yuchi na ix'uputun mas yuchi ju ixta'ui ju p'axnin. Yuchi ju xatoc'at lakatam q'uiu. Para jantu xamati' xaxtakni tu'u' nin yuchi ju anu' xalhi'ut. ");
INSERT INTO teeNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Para acsni tak'oxinilh ju ix'atalacpast'ac'at pus naulh: “Na lhu alin ju makch'alhcatnin ju la'ixchaka' ju quimpai chai ju yu'unch slivasalh na k'ox tavajin. Chai ju quit'in na icmak'alhk'ajnan ju quinchavanti ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Alai actaxtuyach ju ani. Aclak'anchokoyach ju quimpai chai acjunach: Quimpai iclactu'u ju Dios chai iclactu'un ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Pus jantu lhijun ni vanach aq'uilhimisp'at'i ni mints'alh. Va aq'uilakts'ich tachi ju va milapanac”. ");
INSERT INTO teeNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Pus taxtucha chai lak'alh ju ixpai. Para acsni lakts'istucli ixlhimakat ju ixpai pus lana na mapaini. Pus ats'alalak'alh. Lakatanu chai puquilhch'uch'ulh. ");
INSERT INTO teeNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Para ju ists'alh junich: “Quimpai iclactu'u ju Dios chai iclactu'un ju uxint'i. Chai jantu lhijun ni vanach aq'uilhimisp'at'i ni mints'alh ju quit'in”. ");
INSERT INTO teeNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Para ju ixpai ajunilh ju ixlapanacni: “Vats'alhti amac'ut'uchit'it ju palai k'oxi pumpu' chai amalakch'init'it. Chai amamact'anut'it lakatam mactanut. Chai amach'ant'anut'it ju ixch'anxt'ak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Chai a'inchit'it inin ju ask'at'a vacax ju na k'onta. Amaknit'itch chai calac'uyau chai canaviyau ju c'atan. ");
INSERT INTO teeNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chunch canaviyau ni tachi ju va ixnita ju ani quints'alh para ju chavai tachi ju va lok'onchokolh. Ists'ank'ata para ju chavai lhitajuchokocalh”. Pus tatsuculh lhic'ataninin. ");
INSERT INTO teeNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Para ju xak'ai ists'alh ixt'onachalhca' ch'alhcatna' lacacuxtu. Chai acsni tasp'itcha chai chincha vanin la'ixchaka' pus k'asmatlich ni na asanancanch chai ni t'oncan lacat'ininca. ");
INSERT INTO teeNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Chai t'asanilh pumatam ixlapanac chai sacmi tuchi ju alin. ");
INSERT INTO teeNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Chai ju yuchi junich: “Pus minchokolhch ju mimp'isek'e chai ju mimpai lhinaulh ixmaknica ju ask'at'a vacax ju na ixk'onta. Chunch ju navilh ni xaminchokoi ju ists'alh chai jantu tu'u' xatapasayacha chai ni k'ox t'ajun”. ");
INSERT INTO teeNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pus ju acsnich lana na talhk'amalh ju xak'ai ists'alh chai jantu ixtanuputun la'ixchaka'. Pus taxtulh ju ixpai chai tapaininilh ni catanu. ");
INSERT INTO teeNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Para ju yuchi ak'alhtayanalh. Junich ju ixpai: “Ju quit'in va ta lakachux c'ata ict'onan aktaijunun. Chai jantu tavanan ju jantu acnavi tuch'i q'ui'uni. Para jantu tavanan q'uixt'aknit'a mas va minchivoch ni laich ac'at'ac'atanilh ju qui'amigojni. ");
INSERT INTO teeNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Para acsni xaminchokoich ju ani mints'alh ju xaquimaca'ank'ojui tuchi ju ixt'aknit'a va ixlacata ni ixt'a'ucxunt'ajun ju alactu'unin chakolun pus lana lhimakninin mi'ask'at'a vacax ju na ixk'onta”. ");
INSERT INTO teeNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Para ju ixpai junich: “Quints'alh ju uxint'i akts'iya t'a'un laquimacni chai tachi chun ju qui'alinta sich mi'anu'. ");
INSERT INTO teeNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Para akts'iya istasq'uini ni acmac'atanilh chai ca'alilh lack'achat. Pus ju ani mimp'isek'e tachi ju va ixnita chai tachi ju va lok'onchokolh. Va ists'ank'ata para lhitajuchokocalh”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Chai ju Jesús vachu' chani ajuni ju ix'amamaka'ui: ―Ix'alin pumatam lapanac ju na mak'ali' ixjunita. Chai ju yuchi ix'alin pumatam ju ixlhistacni ju ix'alinta ju ix'ucxtin. Chai ju ani chivimak'ancalh la'ix'ucxlacapu' ju ix'ucxtin. Va juni ni va ixlhak'amanani ju ixtumin ju ix'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Pus ju yuchi t'asanilh ju ixlapanac chai junich: “Tijuch ju ani ju ick'asmat'a ju milacata. Aq'ui'unch tas junitach ju chavai ju qui'alinta ni jantu vana lai at'ilhist'act'i”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Pus ju anu' alhistacna' chani pastaclh la'ix'alhunut. “Tas aclayach ju chavai ni va quintai'ini ju ixlhist'ac'a ju ixchaka' ju qui'ucxtin. Pus mati' ju quintachaput ni lai acti'alacpucutunulh. Chai na lhimaxan ni ac'alacapusacnalh. ");
INSERT INTO teeNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Icc'atsai tuchi aclaya' ni aquinta'amaklhtayanana' pants'iquis la'ixchaka'an ju lapanacni acsni actai'inicana' ju quilhich'alhcat”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Pus t'asanilh pumatamin ju ixtalhi'ani ju ix'ucxtin chai junilh ju xap'ulhnan: “Tas chunchach ju lhip'ini ju qui'ucxtin”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Chai ju yuchi junich: “Tam cientos alhcanti ju aceite”. Pus ju anu' alhistacna' ixjunita junilh: “Anich ma ju xa'alhiqui. Va ts'alhti at'a'ulhch chai ats'ok'ulat'i ju sast'i junta najun ni va t'up'uxamcau alhcanti ju lhip'ini”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Astan ju anu' alhistacna' junilh ju ak'antam: “Ju uxint'i tas chunchach ju lhip'ini”. Chai ju yuchi junilh: “Tam cientos alhcanti ju trigo iclhi'ani”. Chai ju xalapanac juni: “Anich ma ju xa'alhiqui. Anavit'i ju sast'i junta najun ni va ochenta alhcanti ju lhip'ini”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Pus ju xa'ucxtin naulh ni akts'iya na ix'ac'atsananta ju anu' a'okxchok'onu' xalapanac ni c'atsalh ta yu capu'aktaijucana' astan mas jantu sok tachi ju xanavi. Pus chunch ju xa'ajuni ju lapanacni ju Jesús chai astan nonchokopa: ―Ju lapanacni ju jantu quilhilaksi akts'iya palai tac'atsai ta yu lai tat'anavi tu'u' ju ixt'alapanacni. Palai jantu na chun talai ju yu'unch ju tamispai ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Pus ju quit'in iclajunau ni ap'u'akt'ai'ut'it ju ali'in ju mintumin'an. Pus ju chunch ca'alina' ju mi'amigojni'an va ixlacata ju xatumin ju ani lacamunutpa' ju xap'uch'alhc'atnanat'it ju uxijnan mas na tapu'alactu'unun ju ali'in. Ju chunch acsni tavanan aniya'it'it pus ju yu'unch lhik'ach cata'amaklhtayanananch lacachaka' lact'iyan junta jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Pus ju jantu a'okxchok'onun ixlacata ju tu'u' mas va lacats'unin pus vachu' jantu a'okxchok'onun ixlacata ju tu'u' lhu. Chai ju a'okxchok'onun ixlacata ju tu'u' lacats'unin pus vachu' a'okxchok'onun ixlacata ju na lhu. ");
INSERT INTO teeNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Pus ni na ix'a'okxch'ok'onun ixlacata ju xamak'alit ju ani lacamunutpa' pus tis chavaich ju catalhilaksiyan chai cataxtakniyan ju vasalh mak'alit. Yuchi ni lai anaviya'it'it ju ixlhich'alhcat ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Pus ju mintumin'an ju ani lacamunutpa' va tamach'ixtaknitan ju Dios. Jantu mi'anu'an. Chai ni ixp'u'a'okxch'ok'onunat'it ju anu' tumin mas jantu mi'anu'an pus ju Dios jantu catitaxtaknin ju palai k'ai ixmak'alit ju mi'anu'an ca'ixva ju ixjonk'alhi lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ju tam xalapanac jantu lai pumat'ui cativa ju ix'ucxtin ju vaktam. Pus akts'iya camapainiya' ju pumatam chai jantu tu'u' calhiulaya' ju ak'antam. U ni jantu para akts'iya calhilaksiya' ju pumatam chai jantu tu'u' canaviya' cuenta ju apumatam. Pus vana va chun ju uxijnan. Jantu lai at'imap'ainit'it ju Dios chai vana amap'ainit'it ju tumin. ");
INSERT INTO teeNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pus ju fariseonin na ixtamapaini ju tumin. Chai acsni tak'asmatlh tachi chun ju ani chivinti pus va ixtalhits'i'inch ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Para ju yuchi ajunich: ―Ju uxijnan t'alac'asuyat'it la'ix'ucxlacapu'an ju lapanacni tachi ju na va soknic'a unt'at'it. Para ju tu'u' lami'atsucunti'an ju k'ox talhiulai ju mint'alapanacni'an ju Dios va lhits'isi ni tamispaniyan ju mi'alhunut'an ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Acsni tuca' ixt'ajun ju Xivan ju ix'amakpaxana' pus ju lapanacni ixtaquiclaca'i ju ixlhamap'aksin ju Moisés chai ixchivinti'an ju lapanacni ju ixtanajun ixchivinti Dios. Para tus acsni milh ju Xivan tus chavai pus ju lapanacni ajuncan ni jantu anch lacalhamap'aksin ju alin ju atsucunti jonk'alhita. Alai va lhinomputun ju Dios la'is'atsucunti'an ju lapanacni. Chai ni tak'asmat'a ju chunch chivinti pus pumalhu slivasalh tanavi cuenta ixlhichux ix'alhunut'an ni calhinaulh ju Dios la'is'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Para mas tamch ju ajuncan ju lapanacni ju chavai para akts'iya jonk'alhita ju mak'aniya ixchivinti Dios. Pus palai jantu xcai ni cats'ank'a ju lact'iyan chai ju lacat'un. Palai xcai ni jantu lhitapalai cava ju tu'u' la'ixlhamap'aksin Dios mas va lacats'unin cava. ");
INSERT INTO teeNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Va tichi chavaich ju camacona' ju ix'amachaka' chai cat'atsucuchokoya' ak'antam pus alactu'ununta. Chai ju cat'atsucuchokoya' ju va maconcanta pus vachu' alactu'ununta. ");
INSERT INTO teeNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Pus ix'alin pumatam jok'at ju na mak'ali' ixjunita. Chai ju yuchi ixlakch'i ju smumu ixpumpu' tachi ixtalakch'i ju ucxtinin. Vachu' ixlakch'i ju lack'ox ixpumpu' ju lino ixjuncan. Chai chux avilhchan ixnavi ju k'ai lacvaiti. ");
INSERT INTO teeNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Chai vachu' ix'alin pumatam quilhpatini' ju Lázaro ixjuncan. Chai ju yuchi na ixlacats'its'ita. Pus ixmamacan vanin la'ixquilhtalacxtutu ju anu' mak'ali'. ");
INSERT INTO teeNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Chai na ix'uputun mas va yuchi ju xa'atanxajna' ju ixni' ju anu' mak'ali'. Chai vachu' ju xk'oyun ixtalakmin chai istasnaunich ju ixlacats'its'i. ");
INSERT INTO teeNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pus chilh avilhchan acsni nilh ju anu' quilhpatini' chai talhi'alh ju anquilhnin ju lact'iyan junta vachu' vilhcha ju Abraham. Chai vachu' nilh ju anu' mak'ali'. Chai macnucalh. ");
INSERT INTO teeNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Pus ju anu' mak'ali' na ixmak'alhk'ajnan junta ta'an ju tanita ju jantu talhilaca'anta ju Jesús. Chai alac'avanalh chai lakts'ilh ju Abraham ixlhimakat chai ju Lázaro ni anch ixvi vachu'. ");
INSERT INTO teeNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Pus ju acsnich ju yuchi p'as chivinilh. Junich ju Abraham: “Quimpai Abraham lamapainin aq'ui'akt'ai'ut'ich ju quit'in. Amalak'ach'achit'ich ju Lázaro. Chach quimilh k'avanini' lacaxcan ju quisimak'at mas va la'ixk'elili ixmaca' ni aquimats'uc'unc'ulhch ni na ict'ajun mak'alhk'ajnanch ju ani lacajipi”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Para ju Abraham junich: “Quints'alh ap'ast'act'ich ni amaklht'ayanant'a chux ju k'ox mintaxtokni acsni ixt'a'unca'. Para ju Lázaro na ixmak'alhk'ajnan. Para ju chavai ju yuchi alin ju ixk'achat ju ani chai ju uxint'i mak'alhk'ajnan. ");
INSERT INTO teeNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Chai jantu va yuchi. Para vachu' junta vilat'it ju uxijnan quilhpamacatutam junta pucutucanta. Ju chunch ju tataxtuputun ju ani ni va cata'amputulh ju anch jantu lai. Nin lai cataxtucha xamati' ju camimputunach ju ani”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Pus ju acsnich ju anu' mak'ali' junich: “Pus na ictapaininiyan ji quimpai. Amalak'ach'at'ich ju Lázaro la'ixchaka' ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tat'ajunca' ixpumaquisi'an ju qui'alak'avin. Chach ancha ju yuchi ajunini' ju ixchivinti Dios ni jantu catamilh ju yu'unch vachu' ju ani junta icmak'alhk'ajnan”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Para ju Abraham junich: “Ju yu'unch tapacxanta ju ixchivinti ju Moisés chai ixchivinti'an ju lapanacni ju ixtanajun ixchivinti Dios. Chach tak'asmatniyanta ju yu'unch”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Para ju mak'ali' junich: “Janti quimpai Abraham. Para ni xamati' ju nita calok'onchokolh chai ca'alak'alh pus catamacona' ju ix'alactu'unti'an”. ");
INSERT INTO teeNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Para ju Abraham junich: “Ni jantu tak'asmatputun ixchivinti ju Moisés chai ju lapanacni ju ixtanajun ixchivinti Dios pus vana jantu camalaca'inicalh mas va calok'onchokolh tam xamati' ju nita chai calak'alh”. ");
INSERT INTO teeNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ju Jesús ajunich ju ix'amamaka'ui: ―Jantu tavanan ju jantu ca'alilh ju puk'alhk'oscan. Para painich ju anu' lapanac ju amak'alhk'osnun. ");
INSERT INTO teeNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Palai k'ox ca'ixva ju ixlacata ni ca'ixpixtuch'imuc'acalh ju tsasnatpuch'ipi chai ca'ixmaca'ancalh laca'alama acsni tuca' ixmak'alhk'osui tam xamati'. Palai na macxcai cava ni camak'alhk'osu tam xamati' ju jantuca' k'ox quilhilaca'anta. ");
INSERT INTO teeNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Alhist'acch'ok'oc'ant'it mi'akstu'an. Chai ni calactu'uyan tam milak'au pus ak'aich. Chai ni lhilatolai ni alactu'unulh chai najun ni jantu catailhi'ana' pus amac'acxaninch. ");
INSERT INTO teeNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Mas paktujun calactu'un ju tam vilhchan chai paktujun ju calakmin ju tam vilhchan chai cajunin ni alactu'un chai catapaininiyan ni amac'acxaninch chai najun ni jantu canavichokoya' pus amac'acxaninch. ");
INSERT INTO teeNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Chai ju ixtamalakachan ju Jesús tajuni: ―Aquila'aktaijuyau ni lai palai aclalhilaksiyau. ");
INSERT INTO teeNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Para ju Jesús ajuni: ―Ju satalhts'i mostaza na lacat'icst'i para lak'ajunta chai astan k'ai q'uiu jun. Pus vana va chun ju uxijnan. Mas va lacats'uninca' ju quilalhilaksiyau para ni vasalh quilalhilaksiyau pus laich a'una'it'it ju ani makak'ai q'uiu ni catatip'ulhulhch. Ca'alh laca'alama. Chai catalaca'iniyanch. ");
INSERT INTO teeNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ju pumatam milhi'uxijnan laich ca'alilh ju ixlapanac ju ca'alhoknulh u camalhistacni ju ixborregojni. Pus ju yuchi acsni caminchalh la'ixlhich'alhcat ja laich a'un ni soko catavi lacamixa chai cavailh. ");
INSERT INTO teeNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ca jantu. Alai a'una'ich ni calak'oxiniyan ju mivaiti. Pus ju yuchi calak'oxiya' ju ixpumpu' chai ca'iniyanch ju mivaiti tus acsni alhilaya'ich. Tus acsnich a'una'ich ni cavena' ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Chai astan acsni navik'ota chux tuchi ixlhi'unich pus ju uxint'i jantu uni lak'ailakts'iuch. ");
INSERT INTO teeNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Pus vana va chun lami'atsucunti'an ju uxijnan. Acsni navik'ot'at'it tachi chun ju ixtalhijuntan ju Dios pus va ana'unt'it ni jantu k'ox xalapanacni unt'at'it ni jantu tu'u' atumpa ju xanaviyat'it. Va yuchi ju ixlhi'unc'ant'at'it ixnavica. ");
INSERT INTO teeNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Pus ju Jesús acsni ix'anta ju lak'achak'an Jerusalén pus pu'alh junta mactai ju xa'estado Samaria chai ju xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Pus acsni tanucha lakatam lak'achak'an pus tamilh pakxtoknin pumacau lapanacni ju na ixtalacats'its'ita chai ju ists'its'i'an va ixtapuch'i'an. Para ju yu'unch ixlhimakat tataya. ");
INSERT INTO teeNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Chai p'as tachivinilh. Tajuni ju Jesús: ―Jesús amamaka'unu'. Lamapainin aquila'aktaiju ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Chai ju Jesús acsni alakts'ilh pus ajunich: ―Ap'inchit'it talacasuninin ju palijni. Pus chunch ixtalhilanita ju lapanacni acsni ixtalacats'its'ita chai astan palaich ixtajun. Pus ju anu' ixpumacau'an ta'alh. Chai acsni ixta'anta pus lana palaich tava. ");
INSERT INTO teeNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Pus ju pumatam sia lhiyu'unch acsni lakts'ilh ni palaich ixjunita pus tasp'itchokolh. Minchokolh junta ixya ju Jesús. Chai na p'as ixchivinin acsni lak'ayalh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Chai lana taquilhputanilh ju lacat'un junta ixch'antaiti ju Jesús chai junilh lak'ailakts'iuch. Chai ju yuchi amachaka' ju xa'estado Samaria ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Pus ju acsnich ju Jesús naulh: ―Ja jantu pumacau ju palai xatajun. Tas anchach ju xata'an ju ixpumanajatsi'an. ");
INSERT INTO teeNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Ja jantu xamati' ju xatasp'itacha ni laich catalak'aya ju Dios. Ja va yuchi ju ani ju jantu quint'a'amachak'an junita. ");
INSERT INTO teeNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Pus ju acsnich ju Jesús chani xajuni ju anu' ju palaich xajun: ―At'aich. A'inchich. Palaich xa'un ni vasalh xaq'uilhilaksi. ");
INSERT INTO teeNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Chai ju fariseonin tasacmi tavananch ju cachina' ju avilhchan acsni calhinona' ju Dios. Chai ju Jesús ajunich: ―Jantu lai lakts'incan acsni chin ju avilhchan acsni calhinona' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nin yuchi ni lai catanaulh: “Alakts'ich. Ani ya”. U “Alakts'ich. Anu' vilhcha”. Jantu lai chun canoncalh ni la'is'atsucunti'an ju lapanacni ju lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Chai ajuni ju ix'amamaka'ui: ―Camina' avilhchan acsni alakts'imp'ut'una'it'it ju anu' pants'iquis acsni acminchokoya' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Para jantu acs ju alakts'ina'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pus ju ali'in catajunan: “Alakts'int'it ju ani. Ca va nomputun ni caminchokoya'”. U catajunan: “Alakts'int'it ju anu' ju t'ajun tapasana'”. Para jantu ap'it'it nin yuchi ni lai ach'ak'ok'at'it. ");
INSERT INTO teeNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Pus ju tu'u' mak'alipni' va tam pants'iquis mapulhcuk'ojui ju ixlhilacaputs'un ju lact'iyan chai makat lakts'incan. Pus vana va chun cajuna' acsni acminchokoya' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Va tam pants'iquis acchina' chai chux aquintalakts'ina'. ");
INSERT INTO teeNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Para jantu chavai lana ju catapasaya' ju chunch. Alai tasq'uini ni p'ulhnan aclhimak'alhk'ajnana' lhu taxtokni. Chai ju lapanacni ju tat'ajun ju chavai jantu aquintalhilaksiya'. ");
INSERT INTO teeNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Tachi ju ixtat'ajun ju lapanacni acsni ixt'ajun ju Noé pus vana va chunch catajuna' acsni acminchokoya' ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pus va chunch ju tatailhi'alh tachi akts'iya ixtalai. Ixtalacvajin. Ixta'ak'otnun. Ixtatamak'axt'ok'ach chai ju chakolun ix'a'ican. Chai chunch ju talalh tus acsni chilh ju avilhchan ni tanu ju Noé ju la'ixbarco. Chai milh ju akmuxtut chai amamuxtuk'o tachi chun ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chai chunch vachu' talalh ju lapanacni ju ixtat'ajun acsni ixt'ajun ju Lot. Tatailhi'alh is'atsucunti'an tachi akts'iya ixtalai. Ixtavajin chai ixta'ak'otnun chai ix'atamonan chai ista'ast'anan chai ixta'ach'ananan chai ixtayajui ixchaka'an. ");
INSERT INTO teeNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Para ju avilhchan acsni taxtucha ju Lot ju lak'achak'an Sodoma pus lana mintacha lact'iyan ju jipi chai ju azufre. Chai lana amaknik'o ixchux'an ju amachak'an anch. ");
INSERT INTO teeNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Pus vana va chun catapasaya' acsni actalacasuchokoyach ju quit'in ju quimalakachatachilh Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Pus ju acsnich ju vilhcha la'is'aksti' ixchaka' jantu catitak'alhtaju chai catanu la'ixchaka' ni va ca'iputulh ju ixtaxtokni. Vana va chun ju t'ajun ch'alhcatna' lacacuxtu. Jantu catiminchokolh la'ixchaka' ini' tu'u'. ");
INSERT INTO teeNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ap'ast'act'it ni matsat xatapalai ix'amachaka' ju Lot acsni talak'asp'itlh. ");
INSERT INTO teeNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pus va tichi chavaich ju va yuchi canavi cuenta ju ixmaktasq'uinit ju is'atsucunti pus jantu cati'alilh ju is'atsucunti jonk'alhita ju lact'iyan. Para va tichi chavaich ju jantu va yuchi canaviya' cuenta ju tuchi maktasq'uini la'is'atsucunti para alai canaviya' cuenta ixtaxtokni Dios pus ju yuchi ca'alina' is'atsucunti ju jonk'alhita ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Acsni acminchokoya' ju quit'in pus cata'alina' ixt'iyun'an ju k'aixtam tamanalh lacaputaman ju anu' atats'isni. Ju pumatam calhi'ancana' ju lact'iyan chai ju pumatam catamaconach. ");
INSERT INTO teeNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chai ixt'iyun'an t'acunin ixlhi'acsni catat'ona' squitinin. Ju pumatam calhi'ancana'. Ju pumatam catamaconach. ");
INSERT INTO teeNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ixt'iyun'an lapanacni catach'alhcatnana' ju lacacuxtu. Ju pumatam calhi'ancana'. Chai ju pumatam catamaconach. ");
INSERT INTO teeNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Pus ju ix'amamaka'ui tajunich: ―Tas anchach ji ucxtin ju catapasaya' ju chunch. Chai ju yuchi ajuni lakatam chivinti ju ixnoncan ju acsni: ―Vanta anchach ju catamayach ju lacatuna pus anchach ju catatak'aixt'ok'a' ju ch'unin. Ju chunch va nomputun ni akts'iya ca'amamak'alhk'ajnicana' ju tachi ju va tanita tajunita la'ixmacni Dios ni jantu talhilaksi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ju Jesús alacjuni ju ix'amamaka'ui lakatam chivinti ju apumavasalanilh ni va tachi catat'achivinilh ju Dios chai jantu tavanan catanaulh ni jantu lhitapalai ni catat'achivinilh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Pus ajunich: ―Ju lakatam lak'achak'an ix'alin pumatam lacat'icst'i ucxtin. Chai ju yuchi jantu ixtalhoni ju Dios chai jantu ix'atalhoni ju ixt'alapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Chai vachu' ix'alin ju anch pumatam chako'ulh ju va ixnimacontilacanta. Pus ju yuchi va tsa ixlak'an ju anu' ucxtin. Ixjuni: “Aq'uilak'oxininch ju quilhamak'an ixlacata ju quint'alasan”. ");
INSERT INTO teeNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pus ju anu' ucxtin na lakalhu avilhchan jantu ixnavini ju tuchi isq'uini ju anu' chako'ulh. Para astan pus naulh la'ix'alhunut: “Ju quit'in jantu ictalhoni ju Dios nin tu'u' iclhiulai ju quint'alapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Para va ixlaca'atalh ni na jeks quimavai ju ani chako'ulh yuchi aclhilak'oxiniya' ju ixlhamak'an. Ni jantu pus ca na jeks aquimavak'alhiya'”. ");
INSERT INTO teeNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Chai ju Jesús ajunich ju ix'amamaka'ui: ―Anavit'it cuenta tuchi naulh ju anu' lacat'icst'i ucxtin ju jantu sok ixlak'oxi ju tu'u' lhamak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Chai ja va a ti yuchach ju Dios jantu ca'alak'oxiniya' ju ixlhamak'an'an ju ixlapanacni ju asacxtuta ju yuchi acsni tatapainini chux tuncujun chai chux atats'isni. T'as anona'it'it. Ja jantu sai cati'alak'oxinilh ju ixlhamak'an'an. ");
INSERT INTO teeNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Iclajunau ni vats'alhti ca'a'aktaijuya'. Pus mas chunch ju canaviya' ju Dios para ja ac'alhitajuya' ju yu'unch ju vasalh quintalhilaksi acsni acminchokoya' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ju Jesús ajuni ju ani chivinti ixlacata ju yu'unch ju ixtanajun ni lack'oxin lapanacni ixtajunita chai jantu tu'u ixtalhiulai ju ali'in. Naulhch: ");
INSERT INTO teeNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Pumat'ui'an lapanacni ta'alh lacpujitat t'achivinin ju Dios. Ju pumatam fariseo ixjunita chai ju pumatam ach'ini' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Pus ju anu' fariseo taya chai tsuculh junini' ju Dios ta yu ixjunita. Naulh: “Icjunan lak'ailakts'iuch ji Dios ni jantu chun icjunita tachi ju ali'in lapanacni. Pus ju yu'unch va ak'alhonin tajunita chai a'okxchok'onin chai va tat'atsucui ju jantu ix'amachaka'an. Nin chunch icjunita tachi ju ani ya ach'ini'. ");
INSERT INTO teeNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ju quit'in ictascajai pakt'ui ju tamin semana. Chai icxt'ak'a ju lacpujitat lacts'unin tachi chun ju iclhajai”. ");
INSERT INTO teeNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Chunch ju naulh ju anu' fariseo. Para ju ach'ini' makat ixyacha. Chai ju yuchi jantu lana ixlaca'amputun ju lact'iyan. Va ixtanquilhacsacan ni chunch ju ixlacan ju acsni ni tu'u' ixlhixcani ix'alhunut'an. Chai ju yuchi ixnajun: “Ji Dios lamapainin aq'ui'akt'ai'ut'ich ni na ic'alactu'unu'”. ");
INSERT INTO teeNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Pus iclajunau ni Dios lakts'ilh ni soknic'a ju anu' ach'ini' acsni anchokolh la'ixchaka'. Ju fariseo jantu. Pus chunch ju pulakts'incalh ju anu' ach'ini' ni calalacat'icst'icana' va tichi chavaich ju lak'ayachokocan is'akstu. Para va tichi chavaich ju calalacat'icst'ichokocalh is'akstu pus ju yuchi calak'ayacana'. ");
INSERT INTO teeNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Chai alhiminicalh ju ask'at'an ju Jesús ni ca'amokslanilh ixmaca' la'ixlacatuna'an chai catapaininilh ju Dios ixlacata'an ni k'ox catatsuculh. Para acsni ta'alakts'inilh ju ix'amamaka'ui pus ta'alack'aima ju ixtalhicha'an ju is'ask'at'an. ");
INSERT INTO teeNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Para ju Jesús at'asanilh ju ask'at'an chai chani ajuni ju ix'amamaka'ui: ―Amac'a'unt'it ju ask'at'an. Chach quintalakmilh. Jantu asasp'it'it ni quintalhilaksich juyu'unch. Chai va tichi chavaich ju aquilhilaksiya' tachi ju quintalhilaksi ju ani tayanalh ask'at'an yuchi ju lai catanuyanta ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pus slivasalh ju iclajunau. Tachi chun ju lapanacni ju jantu quilhilaksi ju quit'in tachi ju tam ask'at'a lhilaksi ju ixpai pus jantu tavanan lai catitanu junta lhinajun ju Dios ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Chai pumatam xak'ai sacmilh ju Jesús. Junich: ―Amamaka'unu' ju uxint'i na k'ox lapanac'at. Tijuch ju lai acnavi ni ca'alilh ju qui'atsucunti ju jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Chai ju Jesús junich: ―Ju uxint'i ni na'un ni va iclapanac pus tajuch ni va q'ui'uni ni ick'ox. Jantu xamati' ju k'ox. Va yuchi ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ju uxint'i c'ats'aich tuchi najun lamilhamap'aksin'an. Najun ni jantu at'ats'uc'u ju jantu mi'amachaka'. Jantu amaknit'i xamati'. Jantu ak'alhonan. Jantu anauch ta'aklhtamat chivinti ixlacata ak'antam. At'alhoninch ju mimpai chai ju minatich. ");
INSERT INTO teeNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Pus ju anu' xak'ai junich: ―Tachi chun ju ani taxtokni icmuctaxtuk'ota tus quilhitalacat'icst'in. ");
INSERT INTO teeNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Pus ju Jesús acsni k'asmatnilh ju ixchivinti junich: ―Va lakatam taxtokni ju t'imak'anc'acxniyan. Ast'ak'ochi' chux ju mi'alinta chai ju tumin ju amaxt'uya' axt'aknin ju quilhpatinin. Ju chunch ni ca'alinach ju mimak'alit ju lact'iyan. Chai acsni anavik'oya' chux ju ani pus at'at'ich. Aq'uinch'ak'ok'ach. ");
INSERT INTO teeNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Para ju yuchi acsni k'asmatnilh ixchivinti Jesús pus slivasalh na amak'aninilh ni na k'ox mak'ali' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Chai acsni lakts'ilh ju Jesús ni na ix'amak'anininta pus naulh: ―Slivasalh na lhixcai ni lai catanu lact'iyan tam mak'ali'. ");
INSERT INTO teeNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tachi ju tu'u' camello ni jantu lai catitapasalh junta tilhucucu ju macscat pus vana va chun tam mak'ali'. Ju yuchi jantu lai cati'alh tus lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Pus ju ixtak'asmat'a ju ixchivinti tajunich: ―Ni na xcai tatak'alhtaxtui ju mak'alinin pus tis chavaich ju lai catak'alhtaxtulh. ");
INSERT INTO teeNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Para ju Jesús ajunich: ―Ju va lapanac akts'iya palai tu'u' lhiulai ju tu'u' mak'alit. Palai jantu ixtaxtokni Dios. Para ju Dios lai mapaxani ix'atalacpast'ac'at. ");
INSERT INTO teeNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pus ju acsnich ju Pitalu' junilh ju Jesús: ―Pus ju quijnan icmaconk'otauch chux quintaxtokni quinc'an chai iclach'ak'ok'atauch ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Chai ju Jesús ajuni: ―Pus slivasalh ju iclajunau. Va tichi chavaich ju tamacajunta ixchaka' u ixpai u ixnati u ix'alak'avin u ix'amachaka' u is'ask'at'an va ixlaca'atalh ni lhinajun ju Dios la'is'atsucunti chai chunch ju xalacasq'uin ju yuchi pus palai na lhu ju ca'amaklhtayanana' ju chavai acsni t'ajunca' ju ani chai ju astan ca'amaklhtayanana' ju is'atsucunti jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ju Jesús alacatam alhi'alh ju ixpumacaut'ui'an chai ajunich: ―Ju chavai ca'anauch ju lak'achak'an Jerusalén. Chai ca'uctaxtuyanta tachi chun ju taxtokni ju tats'ok'ula ju mak'aniya lapanacni ju ixtanajun ixchivinti Dios. Ca'uctaxtuya' tachi chun ju ta'ats'oknulh ju quilacata quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Pus acmak'axtakcananta la'ixmaca'an ju yu'unch ju jantu quint'a'israelitanin tajunita. Chai aquintalhits'i'inach. Chai aquintajunach macxcai chivinti. Chai aquintalakachujvayach. ");
INSERT INTO teeNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Chai astan acsni aquintalakanekmak'oyach pus aquintamakniyach. Para ju ixlhilakat'utu avilhchan aclok'onchokoya'. ");
INSERT INTO teeNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Para ju ix'amamaka'ui ju Jesús lana jantu ixtamachakxai ju ani chivinti. Lana jantu ixtac'atsai tuchi ixnajun ju Jesús. Jantu lai ixtapast'ac'a tuchi canomputulh ju chivinti ju xa'alacjuni ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Pus acsni vanin ixcha'amputun ju Jesús ju lak'achak'an Jericó pus pumatam alak'ach'ix ixvi la'ixquilhtu' ti. Isq'uinch ju tumin. ");
INSERT INTO teeNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Chai ju yuchi acsni k'asmatlich ni ixtat'ajun tapasanin na lhu lapanacni pus asacminilh tichi chavaich. ");
INSERT INTO teeNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Pus tajuni ni ixt'ajun tapasana' ju Jesús amachaka' Nazaret. ");
INSERT INTO teeNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Pus ju acsnich na p'as ju chivinilh ju anu' alak'ach'ix chai junilh ju Jesús: ―Jesús ists'alh'at ju k'ai ucxtin David. Lamapainin aq'ui'akt'ai'ut'ich. ");
INSERT INTO teeNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Para ju ixta'ap'ulananta tak'ailich. Tajuni ni va sek catavi. Para va apalai p'as ju ixchivinin. Ixnajun: ―Ji ists'alh David lamapainin aq'ui'akt'ai'ut'ich. ");
INSERT INTO teeNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Pus ju acsnich ju Jesús lana taya. Chai lhinaulh ix'ica. Chai acsni lakcha'alh pus sacmilh. Junich: ");
INSERT INTO teeNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―Tijuch ju acnaviniyan. Chai ju yuchi junich: ―Qui'ucxtin va ic'alac'avamputun. ");
INSERT INTO teeNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Chai ju Jesús junich: ―Alac'avanch. Pus laich alac'avanan va ixlaca'atalh ni xaq'uilhilaksich. ");
INSERT INTO teeNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pus lana alac'avanalh chai ch'ak'ok'alh ju Jesús. Ixlak'aya'anta ju Dios ju lacati. Chai chux ju lapanacni vachu' talak'ayalh ju Dios acsni talakts'ilh. ");
INSERT INTO teeNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ju Jesús tanucha ju lak'achak'an Jericó chai ixtapasatilaputun. ");
INSERT INTO teeNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Para ixvi ju anch pumatam lapanac ju Zaqueo ixjuncan. Ju yuchi xak'ai ach'ini' ixjunita chai slivasalh na mak'ali' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Chai ju yuchi ismispaputun ju Jesús tichi chavaich. Para jantu lai islakts'in va ixlaca'atalh ixtalhavat lapanacni ju ixtalak'anta ju Jesús chai na putant'icst'i ixjunita ju Zaqueo. ");
INSERT INTO teeNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Pus ats'ala'alh junta capu'anach ju Jesús. Chai toc'acha la'ix'acatan lakatam k'ai q'uiu ni laich calakts'ina' ju Jesús acsni catapasayach ju anch. ");
INSERT INTO teeNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Pus acsni cha'alh ju Jesús ju anch pus talakst'alh chai lakts'ilh chai junich: ―Zaqueo vats'alhtich at'ak'alht'a'ut'ich. Tasq'uini ni ac'astacnalh lacats'unin ju laminchaka' ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Pus ju Zaqueo vats'alhti tak'alhtajulh lacaq'uiu chai lhik'ach amaklhtayanalh ju Jesús la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Para acsni talakts'ilh ju lapanacni pus ixchux'an talhichivinilh ju Jesús. Tanaulh ni laich xatanuyacha la'ixchaka' ju anu' lapanac ju na alactu'unu' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Pus ju acsnich ju Zaqueo taya chai junilh ju Jesús: ―Ju chavai ji qui'ucxtin aclhtam ju quimak'alit ac'axtakniyach ju quilhpatinin. Chai ju iclhi'okxchok'omaxtulh tu'u' pus pakt'at'i ac'axtaknichokoyach ju ixtumin. ");
INSERT INTO teeNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Chai ju Jesús junich: ―Chavai xat'ak'alht'axt'uyat'it ju uxint'i chai tachi chun ju tatanumanalh laminchaka'. Ju chavai vasalh ixpapanti Abraham unt'at'it ni quilalhilaksiyauch tachi ju lalh ju Abraham. ");
INSERT INTO teeNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Pus yuchi iclhiminta ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Icmilh puxcona' ju ts'ank'ata ni laich ac'amak'alhtaxtuya'. ");
INSERT INTO teeNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ni ixtat'ajun k'asmatnin ju Jesús pus ju yuchi tailhi'alh ixchivinti chai ajunilh alakatam chivinti ju ca'apumavasalaniya' tuchi nomputun acsni najun ni calhinona' ju Dios. Chai apujunilh chunch ni vanin ixcha'amputun ju Jerusalén chai ju ixtat'a'anta lacati ixtalhiulai ni lana ucxtin cajuna' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Pus chani ajuni: ―Pumatam xak'ai lapanac taxtulh la'ixlak'achak'an chai alh makat. Va alh amaklhtayana' ju ixpu'ucxtin chai naulh ni caminchokoyach acsni ca'amaklhtayananach. ");
INSERT INTO teeNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Para acsni tuca' ix'an pus at'asanilh pumacau ixlapanacni chai axtaknilh lakcavin tumin chai ajunich: “Ap'uch'alhc'atnant'it tus acsni actasp'it'anta”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Para ju ixt'a'amachak'an talhixcailich chai amalakachacha ju alhtanin ni cata'alh taimayonin ju anu' lapanac. Chai acsni talakchilh tajunich: “Jantu iclacasq'uinau ni uxint'i ju qui'ucxtin quinc'an a'unt'i”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Para ju yuchi akts'iya amaklhtayanalh ju ixpu'ucxtin. Chai acsni tasp'itchokocha pus lhinaulh ix'at'asanica ju anu' ixlapanacni ju ix'axtaknita ixtumin. Va isc'atsaputun tijuch ju punavilh k'antam k'antam. ");
INSERT INTO teeNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Chai milh ju xap'ulhnan chai junich: “Qui'ucxtin ju mintumin lhajachokolh alakcau”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Chai ju ucxtin junich: “K'oxich. Na k'ox xalapanac'at. Pus ni laich xamuct'axt'ui ixlacata ju va lacats'unin pus alhinona'ich ju lakacau lak'achak'an”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Chai milh ju apumatam. Junich: “Qui'ucxtin ju mintumin lhajachokolh alakquis”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Chai vana va chunch ju junilh ju ix'ucxtin tachi ju junilh ju xap'ulhnan. Junich: “Ju uxint'i laich alhinona' lakaquis lak'achak'an”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Chai astan mimpa apumatam chai ju yuchi juni: “Qui'ucxtin anich iclhiminitan ju mintumin. Va xacpach'imak'ata lacapayu. ");
INSERT INTO teeNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Pus va xactalhoniyan ju uxint'i ni icc'atsaich ni na p'as ju mi'alhunut ju uxint'i. Pus alak'ach. Yu'unch ju milapanacni ju talacsununiyan ju micebada ni laich lhu amak'aixt'ok'a' ju uxint'i mas jantu tu'u' tapulhajai ju yu'unch. Pus yu'unch ju tach'alhcatnan ni laich na lhu cajuna' ju micebada ju uxint'i”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Pus ju acsnich ju ix'ucxtin junich: “Na k'ai unit'a ji xalapanac. Pus va ixlacata ju minchivinti mi'akstu ju acmuc'aniyan ju mintalak'alhin. Pus ju uxint'i nauch ni c'ats'aich ni na p'as ju qui'alhunut. Chai yu'unch ju quilapanacni ju tach'alhcatnan chai talacsunui ju quicebada ni lai na lhu acmak'aixt'ok'a' ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pus ni sala chunch icjunita pus tajuch ni jantu xamak'ai ju quintumin junta mak'acan ju tumin. Ju chunch acsni xacminchokota pus xac'amaklhtayananchokolh ju quintumin chai chux ju is'ask'at'a”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Pus ju acsnich ju xa'ucxtin ajunich ju vanin ixtayanalh: “At'ai'init'it ju tumin chai axt'aknit'it ju ixpacxanta ju lakcau”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Para ju yu'unch tajuni: “Para ji qui'ucxtin ju yuchi alin lakcau”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Para ju xa'ucxtin ajuni: “Pus islivasalh ju iclajunau. Va tichi chavaich ju pacxanta tu'u' pus palai lhu caxtaknicana'. Para ju matich tu'u' pus catai'inicana' ju tuchi lacats'unin ix'alinta. ");
INSERT INTO teeNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Chai ju anu' quint'alaxcainin ju jantu ixtalacasq'uin ni laich ac'alhijunilh pus aquilalhiminiuch ju ani chai amaknit'it laqui'ucxlacapu'”. ");
INSERT INTO teeNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Acsni nonk'o ju ani ju Jesús pus alhtananchokopa laxati ju Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Chai cha'alh ju akstijun junta na lhu ixya ju xaq'uiu ju olivo juncan. Vanin ju lak'achak'anixni Betfagé chai Betania. Pus ju acsnich ju Jesús amalakacha ixt'iyun'an ixtamamaka'un. ");
INSERT INTO teeNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ajunich: ―A'inchit'it ju anu' tasui lak'achak'an chai acsni at'anut'achit'it pus alhit'a'uya'it'it lakatam sast'i puru ch'iyocanta. Tuca' xamati' putoc'ata tavanan. Pus axk'ot'aya'it'it chai aquilalhiminiyau. ");
INSERT INTO teeNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Chai ni xamati' catasacmiyan tajuch ni va xk'ot'ayat'it pus va a'una'it'it ni maktasq'uini ju mi'ucxtin'an. ");
INSERT INTO teeNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Pus ta'alh ju anuch ix'amalakachacan chai chunch ju talhitajulh tachi ix'ajuncanta. ");
INSERT INTO teeNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Chai acsni ixtat'ajun xk'otainin ju puru pus ju amanavinin tajunich: ―Tajuch ni va xk'ot'ayat'it ju quimpuru quinc'an. ");
INSERT INTO teeNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Chai ju yu'unch tajunich: ―Ni va maktasq'uini ju qui'ucxtin quinc'an. ");
INSERT INTO teeNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pus yau ajunilh chai talhiminilh ju Jesús. Chai ta'akxch'amuc'alh ixcutun'an ju puru. Chai tamuc'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Chai acsni alhtanalh ju Jesús ju laxati Jerusalén pus ju ixtalhavat lapanacni ixtamamalhi'anta ixcutun'an ju lacati. ");
INSERT INTO teeNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Chai acsni vanin ixtacha'amputun junta lhi'atajuntinic'ach ju anu' akstijun junta lacya ju xaq'uiu olivo pus chux ju ixtalhavat ju ix'amamaka'ui na ixtak'achanch. Na p'as ixtachivinin acsni tatsuculh lak'ayanin ju Dios. Ixtalak'ayai ixlacata tachi chun ju lhamak'an ju ixtalakts'inta. ");
INSERT INTO teeNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ixtanajun: ―Paxcat ju ani xak'ai ucxtin ju minta la'ixtapaka'ut ju Dios. Ju chavai alin ju ak'oxamixnit ju lact'iyan. Chach lak'ayacalh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Para ju acsnich ju ali'in fariseonin ju ixtamakminta tajunich ju Jesús: ―Amamaka'unu' ak'aich ju mi'amamaka'unin. ");
INSERT INTO teeNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Para ju Jesús ajunich: ―Iclajunau ni va sek catalactavi ju ani minta lapanacni pus catalact'asalh ju chiux chai aquintalak'aya. ");
INSERT INTO teeNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Chai acsni vanin cha'alh ju Jesús chai lakts'ilh ju lak'achak'an Jerusalén pus na lhik'alhulh. ");
INSERT INTO teeNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Naulh: ―Na k'ox ixva ni ixmach'akxat'it ju chavai acsni iclat'avilau ni quilacata lai a'unch'ok'ot'it ix'amigojni ju Dios. Para ni jantu chun xalayat'it pus ju chavai jantu alak'a'inic'ana'it'it ni laich amach'akxaya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Na k'ox ixva ni ixmach'akxat'it ni cachina' ju avilhchan acsni k'alhtank'ai catamuc'aya' ju t'un ju mint'alaxcai'an la'ixtalakachoko ju milak'achak'an'an chai catalak'axk'avitnuyan chai jantu jinta' lai at'ip'ut'axt'ut'it. ");
INSERT INTO teeNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Chai catamaktak'oyach ju milak'achak'an'an. Chai catamaknik'oyan chux ju uxijnan ju t'onat'it anch. Jantu catamacona' ju tu'u' chiux ju va cala'ucxtoc'alh ju ixt'achiux ju lak'achak'an. Pus chunch catanaviniyan ni jantu quilamispayau ju quit'in ju icDios ju chavai avilhchan acsni iclalakmintauch. ");
INSERT INTO teeNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ju acsnich ju Jesús tanuchalh la'ixpujitat'an ju ist'a'israelitanin chai tsuculh alactixcoxtunu' tachi chun ju ixta'ulata ixlhist'at'an chai ju ixta'atamonanch ju anch. ");
INSERT INTO teeNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ix'ajuni: ―La'ixchivinti Dios ts'okcanta junta chani najun: “Ju quinchaka' xachaka' junita junta t'achivincan ju Dios”. Chunch ju najun laca'ats'oknut. Para ju uxijnan va tachi ixchaka' ju ak'alhaunin lhimalacxt'uyat'it. ");
INSERT INTO teeNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Pus chux avilhchan ix'amalaninin ju Jesús ju lacpujitat. Para ju xalack'ajin palijni chai ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin chai ju xalack'ajin ju lak'achak'an Jerusalén va ixtamakniputun. ");
INSERT INTO teeNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Para jantu lai ixtalhitajuni ta yu laich tu'u' catanavi ni chux ju lapanacni va tachi ixtalakmin ni ixtak'asmatniputun ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lakatam avilhchan ixt'ajun amalanini' ju lapanacni ju Jesús lacak'ai ixpujitat'an ju ist'a'israelitanin chai ajuni ta yu laich cataputak'alhtaxtulh. Pus tachincha ju xalack'ajin palijni chai ju papaninch chai ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Chai taxak'ala ju Jesús. Tajunich: ―Tis chavaich ju xajunan ni laich anaviya' tachi chun ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Chai ju Jesús ajunich: ―Vachu' aclasacmiyau lakatam chivinti. Aquilajunauch. ");
INSERT INTO teeNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tis chavaich ju xamalakachayachilh ju Xivan ni ca'amakpaxanalh. Ja yuchi ju Dios u va lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pus ju yu'unch talacchivinilh ixlhi'akstu'an. Ixtalaclajuni: ―Ni calhiquilh'aniu ni Dios ju xamalakachayachilh pus aquintajunin tajuch ni jantu xalaca'iniyau. ");
INSERT INTO teeNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Chai ni canaju ni va lapanacni ju xatamalakachayachilh pus chux ju lapanacni aquintalacat'alhman ni na talaca'ita ni ixlapanac Dios ixjunita ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Pus ta'ak'alhtayanalh ni jantu ixtac'atsai tichi chavaich ju xamalakachayachilh ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Pus ju acsnich ju Jesús ajunich: ―Pus nin quit'in jantu actilajuniu tichi chavaich ju xaquimalakachayachilh ni acnaviya' ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Pus ju acsnich ju Jesús tsuculh ajunini' ju lapanacni ju chivinti ju ixt'alakts'ipaxcavaich ju tu'u'. Ajuni: ―Pumatam lapanac ch'anlh ju xaq'uiu uvas la'ixlacat'un chai amach'ixtaknilh ju makch'alhcatnin. Chai ju yuchi na mak'an alh alacatam lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Chai acsni chilh ju avilhchan acsni alilh ju xa'uvas pus amalakachanichilh pumatam ixlapanac ju anu' ch'alhcatnin ni ca'ixtaxtaknilh ju xalhi'ut tachi ix'alhit'atak'oxitach. Para ju anu' makch'alhcatnin talhilakanekma. Va talhixcavats'ala. Chai jantu tu'u' taxtaknilh. ");
INSERT INTO teeNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Chai malakachachokochilh apumatam ixlapanac. Chai vana va chun tanavipa. Talhilakanekma chai tamamaxanilh. Va chunch taxcavats'alachokolh. Chai jantu tu'u' taxtaknilh. ");
INSERT INTO teeNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Chai ju amat'un malakachachokopa ixlhipumat'utu ixlapanac. Pus ju yu'unch vana va chun tanavichokopa. Tamac'atsani chai tamaxtulh lacapu'uvas. ");
INSERT INTO teeNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Pus ju acsnich ju amanavin ju anu' pu'uvas naulh: “Tas nu' aclayach ju chavai. Acmalakachayach ju quints'alh ju na icmapaini. Ca laich cava ni catatalhonilh ju yuchi acsni catalakts'ina'”. ");
INSERT INTO teeNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Chai chunch ju navi. Para ju anu' makch'alhcatnin acsni talakts'ilh talaclajunilh sia yu'unch: “Yuchach ju anu' ju amanavinch cajuna' acsni caniya' ju ixpai. Pus asok'ot'itch. Camakniuch. Chai qui'anuch'an cajuna' ju ani pu'ach'ananti”. ");
INSERT INTO teeNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Pus chunchach ju tanavi. Tatamacxtulh lacapu'uvas chai tamakni. Pus acsni nonk'o ju ani chivinti ju Jesús pus asacmilh ju lapanacni. Ajunich: ―T'as nonat'it. Tas ca'ulhtuyach ju amat'un ju anuch ch'alhcatnin. ");
INSERT INTO teeNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Pus caminach chai camaknik'oyach ju anu' ch'alhcatnin chai ali'in ju ca'amach'ixtaknichokoyach ju ixpu'uvas. Pus ju lapanacni acsni tak'asmatlh tuchi ixnajun ju Jesús tanaulh: ―Jantu calacasq'uina' ju Dios ni chunch ju catapasalh. ");
INSERT INTO teeNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Para ju Jesús alakts'ilh ju lapanacni chai alhik'alhtailh: ―Pus ni jantu chunch ju catapasaya' pus tijuch ju nomputun ju chivinti ju ts'okcanta la'ixchivinti Dios junta chani najun: Ju chiux ju tasacmak'alh ju anu' ixyonin chaka' yuchach ju valhch ju chiux ju mak'astumuc'acanta chaka' junta ts'okcanta tuchi c'ata ju yocanta. ");
INSERT INTO teeNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Pus acsni quintasamak'an ju lapanacni pus va ixt'achunch junita tachi acsni puk'alhk'oscan ju tu'u' chiux chai tac'atsanican. Chai acsni ic'a'ulani ju lapanacni ju ixtalak'alhin'an pus va ixt'achunch junita tachi acsni catant'alhma ju tu'u' k'ai chiux chai jantu tavanan lai k'ostolai. ");
INSERT INTO teeNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Pus ju xalack'ajin palijni chai ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin na ixtapuxcajui ta yu laich catapuch'apalh ju Jesús ju anu' pants'iquis. Para na ixtatalhonita ju lapanacni. Pus ni ixtamachakxata ixchivinti ju Jesús chai ixtac'atsai ni ixlhichivinin ju yu'unch acsni tavanan naulh ju chivinti ixlacata ju pu'uvas pus yuchi ixtalhich'apaputun. ");
INSERT INTO teeNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pus talhistacli chai amalakachacalh ju lapanacni ju catatank'ajlakts'ilh. Chai ju yu'unch talhitalacasulh tachi ju lapanacni ju soknic'a ixjunita ju ix'atalacpast'ac'at'an. Va ixtapuxcolakxtuniputun ju chivinti ni laich catalhimak'axtaknilh ju gobernador. ");
INSERT INTO teeNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Pus yuchi taquilhisacmi: ―Amamaka'unu' icc'atsayau ni na'un chai amalanininch ju stavasalanti. Chai vaklhtam chun alakts'in ju lapanacni. Chai sok amalaninin ixlhamap'aksin ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Pus t'as na'unch. Ja lhijun ni ac'amapalanauch ju la'ixpu'ucxtin ju romanonin u jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Para ju Jesús lana amachakxanilh ni va ixta'okxchok'oputun chai ajuni: ―Tajuch ni va quilapuxconiputunau ju quintalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Aquilamasuniuch ju tumin ju lhi'amap'alananat'it. Tis ix'ucxpu' ju ani okslai. Tis ixtapaka'ut ju ts'okcanta ju ani. Pus ta'ak'alhtayanalh. Tajunich: ―Ix'anu' ju César ix'ucxtin'an ju romanonin. ");
INSERT INTO teeNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Pus ju acsnich ju Jesús ajunich: ―Pus axt'aknit'it ju César ju ix'anuch. Chai axt'aknit'it ju Dios ju ix'anuch. ");
INSERT INTO teeNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Pus jantu lai talhitajunilh tu'u' talak'alhin la'ixchivinti ju xanajun la'ix'ucxlacapu' ju lapanacni. Alai va talhamak'aninilh ni na k'ox xalhak'alhtayanan. Chai va sek tataya. ");
INSERT INTO teeNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ju acsnich tachincha ju ali'in saduceonin ju jantu ixtalaca'i ni laich calok'onchokolh tam xamati' ju ixnita. Talakmilh ju Jesús chai tasacmi: ");
INSERT INTO teeNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Amamaka'unu' ju Moisés quinta'ats'oknunin la'ixlhamap'aksin ni canilh tam lapanac chai ma camacontilalh ix'amachaka' para jantu tu'u' cat'amacontilalh ju is'ask'at'an pus ju isp'isek'e calhitsucuchokolh ju ix'amachakach ixjunita ju xani. Chai cama'alini ju is'ask'at'a chai ju yuchi ni ts'alh pus ma casacnilh ixtapaka'ut ju lijunto ixlak'au. ");
INSERT INTO teeNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pus ix'alin pumatujun lhi'alak'avin. Chai ju xak'ai alilh ix'amachaka'. Para astan nilh chai jantu tu'u' macontilanilh ju is'ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Chai ju ixlhipumat'ui t'atsucuchokopa ju ix'amachakach ixjunita. Chai astan vachu' nipa. Jantu tu'u' macontilalh ju is'ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Chai ju ixlhipumat'utu t'atsucuchokopa. Chai vana va chun talak'o ixchux'an ixpumatujun'an. Tus tanik'o. Chai jantu xamati' macontilanilh ju is'ask'at'a. ");
INSERT INTO teeNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Chai ju astan pus vachu' nilh ju anu' chako'ulh. ");
INSERT INTO teeNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Pus acsni calok'onchokocana' pus tis ix'amachakach cajuna' ni tat'atsucuk'o ixpumatujun'an lhi'alak'avin. ");
INSERT INTO teeNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ju acsnich ju Jesús ak'alhtayanalh. Ajunich: ―Ju lapanacni ju ani lacamunutpa' tatamak'axt'ok'a chai tala'i. ");
INSERT INTO teeNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Para alin lapanacni ju k'ox alhiulai ju Dios ni catalok'onchokoyach chai cata'anach ju lact'iyan. Chai ju anch jantu tamak'axtokcan chai jantu la'ican. ");
INSERT INTO teeNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Jantu tasq'uini ni catamak'axtokcha ju anch ni jantu catitanichokolh ju anch. Alai va ixt'achunchach catatsucuyanta tachi ju anquilhnin. Chai is'ask'at'an Dios tajunita ni talok'onchokota. ");
INSERT INTO teeNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mas is'akstu ju Moisés mavasala ni catalok'onchokoyach ju tanita acsni atalacasunilh ju Dios ju laca'ach'itin ju jantu tavanan lai lhcuk'o. Pus ju Moisés acsni ts'ok'ula tuchi tapasalh ju anch pus naulh ni Dios juni ni isDios'an junita ju mak'aniya lapanacni ju Abraham chai ju Isaac chai ju Jacob ix'ajuncan. ");
INSERT INTO teeNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Pus ju Dios ni najun ni isDios junita ju anuch lapanacni pus va pumavasalai ni tat'ajun ju yu'unch. Pus mas nonau ni va nita tam xamati' para ju Dios alhilakts'in tachi ju tat'ajun. ");
INSERT INTO teeNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Pus ju acsnich ju ali'in sia yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin tajunich ju Jesús: ―Amamaka'unu' na k'ox xana'un. ");
INSERT INTO teeNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Pus tus acsnich jantu lai tu'u' ali' talhisacmichokoputulh. ");
INSERT INTO teeNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ju Jesús ajunich ju ali'in fariseonin: ―T'as nonat'it. Tas laich talhinajun ju lapanacni ni ists'alh David ju Cristo ju ixnoncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Pus is'akstu ju David chani naulh ju laxa'alhiqui ju Salmos juncan: Ju ucxtin Dios junilh ju qui'ucxtin: “Vanin at'a'ulh junta icvi. ");
INSERT INTO teeNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tus acsni act'alalhajaya' ju mint'alaxcai”. ");
INSERT INTO teeNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Pus ni is'akstu David naulh ni ix'ucxtin junita pus ju chunch va nomputun ni jantu va ists'alh junita. ");
INSERT INTO teeNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pus tachi chun ju lapanacni tak'asmatlh acsni chani ajuni ix'amamaka'ui ju Jesús: ");
INSERT INTO teeNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Alhist'acc'ant'it ni jantu cata'okxchok'on ju yu'unch ju na talhatalanininta ju milhamap'aksin'an. Pus ju yu'unch na tak'achani ju laclhman ixpumpu'an tachi ju tam xak'ai. Chai na k'ox talhiulai acsni amac'amican ju la'ixtalhavat lapanacni. Chai na tak'achani ni tatolai la'ixputolan'an ju xalack'ajin ju lacpujitat chai lacapuvai. ");
INSERT INTO teeNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Va ta'okxchok'otai'ini ixlacchaka'an ju chakolun ju va animacontilacanta. Chai astan talapalai tachi ju na va k'ox panicni ju tat'achivinin ju Dios ni lai catapu'okxchok'olh ju lapanacni ni catanaulh ni na tatalhoni ju Dios. Para ju yu'unch cata'amaklhtayanana' palai lhu ju ixmak'alhk'ajnat'an. Palai jantu ju ali'in lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Junta ixvi ju Jesús ju la'ixpujitat'an ju ist'a'israelitanin pus tasoknic'a taya chai alakts'ilh ju mak'alinin ni ixtamujui ixlhak'ailakts'in'an lacalact'icst'i p'aklat junta ixpumucan tumin ju la'ixpujitat'an. ");
INSERT INTO teeNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Chai vachu' lakts'ilh pumatam chako'ulh ju va ixnimacontilacanta chai na quilhpatini' ixjunita. Chai ju yuchi mujulh lakat'ui lact'icst'i tumin. ");
INSERT INTO teeNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Pus ju Jesús naulh: ―Slivasalh ju iclajunau. Palai lhu xaxt'ak'a ju ani quilhpatini' chako'ulh ju va nimacontilacanta. Palai jantu tachi chun ju ali'in. ");
INSERT INTO teeNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pus tachi chun ju yu'unch talhik'ailakts'inch ju Dios ju va xajnichokotachalhch. Para ju ani mas va quilhpatini' para xtakk'olh chux ju ixtimak'ata. ");
INSERT INTO teeNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Chai ju ali'in ju ixtavilanalh anch talhichivinilh ju pujitat. Ixtanajun ni na k'oxich ixmaxantilacanta lacac'usi chiux chai ju lapanacni ixtaxtakta na lhu taxtokni ju na lacc'us ixjunita ni na k'ox catasu ju pujitat. Para ju Jesús ajuni: ");
INSERT INTO teeNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Aclajunau ixlacata ju ani taxtokni ju lakts'inat'it ju chavai. Pus camina' avilhchan acsni jantu tu'u' catila'ucxtavi ju chiux ju ixt'achiux. Chux lana calak'alhik'ocana'. ");
INSERT INTO teeNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Chai tasacmich. Tajuni: ―Amamaka'unu' tas vananch ju ca'uctaxtuya' ju ani minchivinti. Tijuch ju catasuyach ju lai acpuc'atsayau ni jantu mak'an cativa tus catapasaya' ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Chai ju Jesús ajuni: ―Alakts'int'it ni jantu xamati' cata'okxchok'on. Pus na lhu lapanacni catamina' laquintapaka'ut. Chai chanich catanonach: “Quit'in ju icCristo”. Chai vachu' catanona' ni vaninch minta ju avilhchan acsni acminchokoya'. Para tun t'ich'ak'ok'at'it ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Chai acsni ak'asmat'a'it'it ni alin ju lhilucut chai ni tamacxtuputun ju ix'ucxtin'an ju ali'in lapanacni pus tun t'it'alhanant'it. Pus tasq'uini ni p'ulhnan catapasaya' ju ani taxtokni. Para jantu lana acsnich ju ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Pus tailhi'alh ixchivinti ju Jesús. Ajuni: ―Ju amachak'an ju lakatam k'ai lacat'un catat'alasaya' ju amachak'an alakatam k'ai lacat'un. Chai ju lapanacni ju tach'ak'ok'ai tam ucxtin catat'alasaya' ju ixlapanacni ju apumatam ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Chai na lacalhu ca'alinach junta catataclha' ju lacat'un chai junta ca'alinach ju chavanti chai junta lhu alin ju tak'ank'at. Chai catalacasuya' ju k'ai lhitalhan ju lact'iyan. Chai ju lapanacni acsni catalakts'ina' na catatalhanana' chai catapuc'atsaya' ni vanin ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Para p'ulhnan acsni tuca' tapasai ju ani taxtokni pus catach'apayan chai catamamak'alhk'ajniyan. Chai amak'axt'akc'ana'it'it la'ixmaca'an ju xalack'ajin lacpujitatnin. Chai at'alhnuc'ana'it'it. Chai alhip'inic'ana'it'it ju xalack'ajin chai ju ali'in ucxtinin. Chai chux ju ani cata'ulhtuyan va ixlaca'atalh ni quilach'ak'ok'ayau ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Para ni chunch ju cata'ulhtuyan pus laich a'una'it'it ju yu'unch ju quilacata. ");
INSERT INTO teeNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pus p'as ana'unt'it lami'alhunut'an ni jantu ap'ast'ac'a'it'it p'ulhnan ta yu laich ak'alht'ayanana'it'it acsni catamuc'aniyan ju mintalak'alhin'an. ");
INSERT INTO teeNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chunch ju alat'it ni quit'in qui'akstu ju aclaxtakniyau ju chivinti chai ju ac'atsanti. Chai tachi chun ju mint'alaxcai'an jantu lai ta catapuk'alhtayanananch nin lai catanaulh ni jantu slivasalh tuch'i nonat'it. ");
INSERT INTO teeNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Chai mas mimpai'an u minati'an catamak'axt'ak'an. Chai ju mi'alak'avin'an chai ju milhi'alak'avin'an chai ju mi'amigojni'an catamak'axt'ak'an. Chai ju ali'in lamilhi'uxijnan catamakniyan. ");
INSERT INTO teeNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Chai chux ju lapanacni catalhixcayan va ixlacata ni quilach'ak'ok'ayau ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Para mas va tuchi catapasaya' akts'iya talhist'ac'an ju Dios chai jantu catits'ank'a ju mi'atsucunti'an jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Pus ni va tachi aquilalhilaca'anau pus ca'alina' ju mi'atsucunti'an jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Acsni alakts'ina'it'it ju lak'achak'an Jerusalén ni catalakachokoputunach ju taropajni pus ju acsnich ap'uc'ats'aya'it'it ni cha'alh ju ixpumaclacan. ");
INSERT INTO teeNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ju acsnich ju tat'onacha ju xa'estado Judea chach ta'ats'ala'alh ju xalacatalhpan. Chai ju tavilanancha ju lak'achak'an Jerusalén chach tataxtulh. Chai ju va tat'onacha la'ixcuxtu'an chach ta'ats'alalh. Jantu catatanu ju lak'achak'an. ");
INSERT INTO teeNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Pus ju anuch avilhchan va ixpumapalhcan ju talak'alhin cajuna'. Chai acsni catapasaya' ju chunch pus capu'uctaxtuyach tachi chun ju taxtokni ju ts'okcanta la'ixchivinti Dios ixlacata yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Para paini'itnich ju ta'ak'ainanta chai ju alin lacat'icst'i is'ask'at'a ju acsni avilhchan. Pus slivasalh k'ai mak'alhk'ajnat ju ca'alina' la'ixlacat'un'an ju quint'a'israelitanin chai ju yu'unch catalakts'ina' ixtalhk'amti ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Pus ju ali'in camaknicana' lacalhilucut. Chai ju ali'in tach'inin canavicana' chai calhi'ancanach vanta lhi'anchach ju alin ju lak'achak'anixni. Chai ju jantu israelitanin tajunita yu'unch ju catatsucuya' ju lak'achak'an Jerusalén tus acsni cata'aktsayach ju avilhchan ju alhcanicanta ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Chai tamch catasuya' ju avilhchan chai ju malhquiyu' chai ju st'acu. Chai ju ani lacat'un na catamak'alhk'ajnana' ju lapanacni. Chai lana jantu catac'atsaya' tuchi catalaya' ni na cat'asaya' ju alama chai na calucununach ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Pus vak ca'ana' ju ix'alac'avanti'an ju lapanacni va ixlacata ixtalhantich'an acsni tapast'ac'a tuchi catapasaya' ju ani lacat'un. Pus mas yuchi ju avilhchan chai ju malhquiyu' chai ju st'acu catalucununach. ");
INSERT INTO teeNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Pus acsnich ju aquintalakts'ina' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Acmina' laca'ataputs'i chai catac'atsaya' ju lapanacni ni na alin ju quintachaput chai ni icxak'ai. ");
INSERT INTO teeNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Pus acsni catai'ulayach ju ani taxtokni pus asa'ulat'it ju mi'aktsulh'an chai ak'ach'ana'it'it ni vaninch minta ju avilhchan acsni amak'alht'axt'uc'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Vachu' ajunilh lakatam chivinti ju ix'apumavasalaniputun ju tuchi ix'amalaniputun. Pus ajuni: ―Alakts'int'it ju xaq'uiu higuera chai tachi chun ju ali' q'uiu. ");
INSERT INTO teeNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Acsni catsucutachilh xajnichini' ju sast'i xaxk'oi pus ju uxijnan p'uc'ats'ayat'it ni vaninch minta ju lacap'asni. ");
INSERT INTO teeNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Pus vana va chun ju ani. Acsni alakts'ina'it'it ni t'ajun uctaxtunu' ju ani taxtokni pus ac'ats'aya'it'it ni vaninch minta ju avilhchan acsni calhinonk'oya' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Slivasalh ju iclajunau. Jantu catitani ju chavai tat'ajun lapanacni tus acsni jantu uctaxtuk'ojui chux ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ju lact'iyan chai ju lacat'un calaclaya'. Para akts'iya ca'uctaxtuya' ju quinchivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Pus alakts'inch'ok'oc'ant'it mi'akstu'an ju uxijnan. Jantu xcai ni na lhu ca'alilh ju macxcai lami'alhunut'an chai at'ak'ap'aya'it'it u na lhu ju alhamak'aninit'it ju xataxtokni ju sa'atsucunti ju ani lacamunutpa'. Chai ni chunch ju alat'it pus laich cachilh ju anu' avilhchan acsni jantu c'ats'aya'it'it ni laich camilh. ");
INSERT INTO teeNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Pus ju anu' avilhchan acsni cachina' chunch catapasaya' tachi ju tapasai acsni tu'u' ch'apacanta lacask'apa. Pus va tam pants'iquis cachina' chai astan jantu xamati' ixlhilacaputs'un ju ani lacamunutpa' laich tamch catapast'ac'a'. ");
INSERT INTO teeNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pus va tachi sk'ala ats'uc'ut'it. Chai va tachi asq'uinit'it ju Dios ni k'ox catalhiulayan chai ixlhiyuchi lai ap'ut'ak'alht'axt'uya'it'it tachi chun ju ani taxtokni ju camina'. Chai vachu' lai at'ayaya'it'it laqui'ucxlacapu' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Laich at'ayaya'it'it laqui'ucxlacapu' ni mati' ju mi'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pus ju Jesús ix'amalaninin ju la'ixpujitat'an ju ist'a'israelitanin ju tuncuj. Para ju ts'is ixtaxtui ju lak'achak'an. Ix'an ju anu' akstijun junta pu'olivonin ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Chai tachi chun ju lapanacni na vats'isin ixtalak'an ju lacpujitat ni va ixtak'asmatniputun ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Pus vanin ixchimputun ju anu' c'atan acsni ixtanavi ju xkapavati ju jantu ixlhiyocan ju xat'in. Chai ju c'atan ju ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Chai ju xalack'ajin palijni chai ju yu'unch ju na ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin ixtapuxconi ta yu laich catapumakniya' ju Jesús. Para na xcai talhiula ni na ixtatalhoni ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Pus pumatam ju ixpumacaut'ui'an Judas Iscariote ixjuncan. Pus ju lhacaticuru ch'apanilh ix'atalacpast'ac'at. ");
INSERT INTO teeNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Chai ju yuchi alh alact'achivini' ju xalack'ajin palijni chai ju xa'ucxtinin ju taropajnich ju ixtavilanancha lacpujitat. Ju Judas va alh ajunini' ni laich ca'amak'axtakniyach ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Pus ju yu'unch na talhik'achalh chai tajunilh ni catamapala'. ");
INSERT INTO teeNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Pus ju Judas amach'anu chai puxcaulich ta yu laich capumak'axtakniyach ju yu'unch acsni mati' lhu cava ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pus chilh ju avilhchan acsni cata'uya' ju xkapavati ju jantu lhiyalh ju xat'in. Vachu' acsni istasq'uini ni catamakniya' ju ixborrego'an ixlacata ju anu' c'atan. ");
INSERT INTO teeNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pus ju Jesús amalakachalh ju Pitalu' chai ju Xivan. Ajunich: ―Inchit'it lak'oxinin ju vaiti ixlacata ju chavai c'atan ni laich ca'uyau. ");
INSERT INTO teeNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Chai ju yu'unch tajunich: ―Tas anchach ju lac'asq'uin ju aclak'oxiyau. ");
INSERT INTO teeNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Chai ju yuchi ajuni: ―Acsni ach'ip'ina'it'it ju lak'achak'an pus ap'akxt'ok'a'it'it pumatam lapanac ju lhi'anta xcan la'ixalu. Pus at'aimaya'it'it ju yuchi tus catanuyanta ju lacachaka'. ");
INSERT INTO teeNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chai a'una'it'it ju amachaka': “Ju amamaka'unu' macaminiyan chivinti. Tas ma anchach ju lai cat'avena' ju ix'amamaka'unin ju chavai c'atan”. ");
INSERT INTO teeNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Chunchach ju a'una'it'it. Chai ju yuchi catalhi'anan ju lhitantalact'ui ixchaka'. Chai catamasuniyan ju k'ai chaka' junta k'ox lak'oxicanta. Anchach ju alak'oxiya'it'it ju vaiti. ");
INSERT INTO teeNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pus ta'alh chai talhitajulh tachi ju ajunicalh. Chai anch ju talak'oxilh ju vaiti. ");
INSERT INTO teeNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pus astan tamilh ju Jesús chai ju ali'in. Chai acsni cha'alh ju hora pus ju Jesús tapakstit'atama ju ixpumacaut'ui'an ixtamalakachan'an. ");
INSERT INTO teeNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Chai ju Jesús ajuni: ―Slivasalh ixlhichux qui'alhunut na xaclacasq'uin ni laich aclat'avenau ju uxijnan ju xavaiti ju chavai c'atan acsni tuca' icmaknican. ");
INSERT INTO teeNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Pus jantu aktam acti'uchokolh ju xavaiti ju ani c'atan tus acsni ca'uctaxtuk'oya' chux tuchi nomputun ju ani c'atan. Tus ca'uctaxtuyanta ju lact'iyan junta lhinajun ju Dios. Tus acsnich ju lai ac'uchokoya' chai yuchi xaclhilacasq'uin ni aclat'a'uyau ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Pus ju acsnich ju Jesús ch'apalh ju vaso chai junilh lak'ailakts'iuch ju Dios chai naulh: ―Ach'ap'at'it ju ani vaso. Alat'ak'ot'it ju milhi'uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ak'ot'it ju uxijnan ni iclajunau ni jantuch actik'otchokolh ju vino tus acsni vasalh calhinonk'oya' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Astan ju Jesús ch'apalh ju xkapavati chai junilh lak'ailakts'iuch ju Dios. Chai ch'ek'elh. Chai axtaknilh ju yu'unch. Ajunich: ―Yuchach ju ani ju quilacatuna ju xtakcanta ju milacata'an. Va tsa chani alat'it ni laich ap'up'ast'ac'a'it'it ju qui'aninti ju milacata'an. ");
INSERT INTO teeNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chai acsni ixtavenk'ota pus vana va chun navichokopa. Ch'apachokolh ju vaso chai naulh: ―Ju ani lhik'ot'at yuchi ju pumavasalacan ju sast'i chivinti ju iclat'atak'oxitauch. Chai acpumavasalaya' ju anu' chivinti ju qui'ac'alhni ju cataxtuya' ju milacata'an. ");
INSERT INTO teeNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Para ju aquimak'axt'ak'ach quint'avi ju chavai lacamixa. ");
INSERT INTO teeNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Pus akts'iya acniya' tachi ju iclhilhcanicanta. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Para painich ju anu' lapanac ju aquimak'axt'ak'a'. ");
INSERT INTO teeNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Pus ju acsnich ju ix'amamaka'ui tatsuculh lasacminin sia lhiyu'unch tis nu' chavaich ju sia lhiyu'unch ju canaviya' ju chunch. ");
INSERT INTO teeNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pus ju acsnich alilh lakatam laklak'aiti ju sia lhiyu'unch ju ix'amamaka'ui ju Jesús. Va ixtalhilak'aji tichi chavaich ju sia yu'unch ju k'ox calhiulacalh ni yuchi ju xak'ai canavicalh. ");
INSERT INTO teeNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Para ju Jesús ajuni: ―Ju lapanacni ju jantu quint'a'israelitanin tajunita alin ix'ucxtin'an ju talhinajun. Chai yu'unch ju talhinajun na va talhitak'ayachokocan is'akstu'an tus talacasq'uin ni calhimispacalh ni yu'unch ju palai a'aktaijunun. Mas jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Para jantu chun anavit'it ju uxijnan. Alai yuchi ju tak'ayaputun lamilhi'uxijnan capumavasalaya' ni vasalh xak'ai acsni va lacat'icst'i catalacasu chai ni jantu lacasq'uin ni calak'ayacalh. Chai yuchi ju lhinajun lamilhi'uxijnan capumalacasuya' ni vasalh xak'ai acsni cach'alhcatnaniya' ju ali'in. Jantiyu' ni va cach'alhcatnanicalh. ");
INSERT INTO teeNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Pus t'as nonat'it ju uxijnan. Tis chavaich ju palai xak'ai. Ja yuchi ju tolai lacamixa chai vajin. U yuchi ju ini ju ixvaiti. Ja jantiyu' ju tolai lacamixa. Para ju quit'in chun icjunita tachi ju va milapanac'an. ");
INSERT INTO teeNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Uxijnan ju jantu quilamacaju acsni na xacmak'alhk'ajnan chai ixlacata ju quimak'alhk'ajnat chilh ju qui'atalacpast'ac'at ni xacmacaulh ju quilhich'alhcat. ");
INSERT INTO teeNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Chai ni jantu xaquilamaconau ju acsnich pus yuchi iclalhilhca'ulatau ni ucxtinin a'una'it'it tachi ju quimpai ni quilhca'ulanilh ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ju chunch lai a'uya'it'it chai ak'ot'a'it'it laquimixa acsni k'ai ucxtin acjunach. Chai alhinona'it'it chux ju ix'apapanatnich ju ixpumacaut'ui'an ists'alan ju Israel. ");
INSERT INTO teeNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Chai ju Jesús vachu' chani junilh ju Pitalu': ―Simón ju lhacaticuru tasq'uinitanch ni laich cata'ulhtuyan tachi ju ulhtucan ju tu'u' trigo acsni c'alhacan. Pus va yuchi ju xa'amacxtalh ju sun lhi'an ju un. Para ju xatrigo jantu. Pus ju lhacaticuru talakts'intanuputunan ni aquilac'ap'auch u aquilalhilaksik'alhiyau. ");
INSERT INTO teeNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Para ju quit'in ictapaininita ju Dios ju milacata'an ni jantu lana aquilac'ap'auch. Chai acsni aq'uinch'ak'ok'ach'ok'oya'ich ju uxint'i pus a'akt'ai'ut'ich ju milhi'alak'avin ni vachu' ixlhichux ix'alhunut'an aquintalhilaksichokoya'. ");
INSERT INTO teeNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Para ju Pitalu' junich: ―Qui'ucxtin ju quit'in aclhilak'a'iyach mas act'at'alhnucanch. U mas act'aniyanch. ");
INSERT INTO teeNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Para ju Jesús junich: ―Pitalu' icjunan ni chavai atats'isni acsni tuca' t'asai ju puyux pus pakt'utu ju na'unt'a ni jantu q'uimisp'ai. ");
INSERT INTO teeNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Chai ju Jesús ajunich ju ix'amamaka'ui: ―Acsni tavanan iclamalakachau chai jantu ixlhip'int'at'it ju mintumin'an nin mimpasti'an nin lakat'ui minch'anxt'ak'an'an ja tu'u' xatac'acxniyan. Chai ju yu'unch tajunilh ni jantu. ");
INSERT INTO teeNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Pus ju acsnich ju Jesús ajuni: ―K'oxich. Para ju chavai tasq'uini ni ats'uc'uya'it'it tachi tam taropa ju an junta alin ju ixt'alaxcai. Ju chavai ju alin ju ixtumin calhi'alh. Vachu' ju ispasti. Chai ju mati' ixmachita pus cast'alh ju ixpumpu' chai calhitamaulh lakatam. ");
INSERT INTO teeNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Pus chunch ju a'ulht'ut'it ni iclajunau ni tasq'uini ni ca'uctaxtuya' ju quilacata ju anu' ju ts'okcanta la'ixchivinti Dios junta chani najun: “Ju yuchi lakts'incalh tachi ju va alactu'unu'”. Chunch ju najun chai t'ajun uctaxtunu' ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Chai ju ix'amamaka'ui tajunich: ―Qui'ucxtin alin lakat'ui quimachita'an. Chai ju yuchi ajunich: ―Chach va anch lhitamactalh. Pus va naulh ju chunch ni jantu ixtamachakxani tuchi ju ix'ajumputun. ");
INSERT INTO teeNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ju Jesús taxtulh lacachaka' chai alh ju anu' akstijun junta pu'olivonin ixjuncan tachi ju akts'iya ixlai. Chai ju ix'amamaka'ui vachu' tach'ak'ok'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Chai acsni tacha'alh junta akts'iya ixta'astacnan pus ju Jesús ajuni ju ix'amamaka'ui: ―At'ach'ivinint'it ju Dios ni jantu cata'okxchok'oyan ju lhacaticuru. ");
INSERT INTO teeNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Chai ju yuchi alh ixlhimakat tachi ju laich maca'ancan ju chiux. Chai ju anch ju yuchi ta'aktsokotalh chai t'achivinilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Junich: ―Quimpai ni lac'asq'uinch aq'uimak'osunin ju ani mak'alhk'ajnat. Para jantu iclacasq'uin ni anavit'i ju quink'achat quit'in. Alai yuchi ju anavit'i ju mink'achat ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Chai talacasunilh pumatam anquilh ju mincha lact'iyan chai xtaknilh ju ixtachaput. ");
INSERT INTO teeNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Chai ni na ixmak'alhk'ajnan pus lana ixlhichux ix'alhunut ju tapaininilh ju Dios. Chai ju ixtalht'ajat valhch tachi ju tu'u' ac'alhni ju k'alhtank'ai lach'apata chai ixtamayacha ju lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Pus acsni t'achivink'o ju Dios pus taya chai alakminchokolh ju ix'amamaka'ui. Chai alhitajulh ni va ixtalhtatanan ni na ixta'amak'aninin. ");
INSERT INTO teeNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Chai ajunich: ―T'as ni va lht'at'ap'alat'it. Ak'ost'olat'it. At'ach'ivinint'it ju Dios ni jantu cata'okxchok'oyan ju lhacaticuru. ");
INSERT INTO teeNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Chai acsni ixt'ajunca' alact'achivini' ju ix'amamaka'ui ju Jesús pus tachincha ju ixtalhavat lapanacni. Chai ix'ap'ulhnita ju anu' ixlhipumacaut'ui'an ju Judas ixjuncan. Chai lakmilh ju Jesús ni camacch'uch'uyach. ");
INSERT INTO teeNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Para ju Jesús junich: ―Judas ja laca'amacch'uch'unti ju aq'uimak'axt'ak'a' ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Pus ju ix'amamaka'ui acsni talakts'ilh tuchi catapasayach pus tajunich: ―Qui'ucxtin ja acmakniyauch lacamachita. ");
INSERT INTO teeNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Chai pumatam sia lhiyu'unchach mac'atsani ju ixlapanac ju xak'ai pali. Chakxp'uxnilh ju ix'ak'axk'olh ju ixcatucana. ");
INSERT INTO teeNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Para ju Jesús juni: ―Chach va anch lhitamactalh. Chai ju Jesús ch'apalh ju ix'ak'axk'olh ju anu' lapanac chai lana catumuc'achokolh. ");
INSERT INTO teeNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Pus ju xalack'ajin palijni chai ju xataropajni lacpujitat chai ju papanin yu'unch ju ixtaminta inin ju Jesús. Chai ju Jesús ajunich: ―Tajuch ni va quilanaviyau tachi tam ak'alhona' ju ch'ap'ap'ut'unat'it ni lhit'ant'at'it ju mimachita'an chai ju minq'uiu'an. ");
INSERT INTO teeNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Pus chux tuncujun xaclat'avilhchau lamilacpujitat'an chai ju anch jantu quilach'apauch. Para ju chavai ju Dios talak'a'iniyan ni chunch ju aquila'ulhtuyau. Vachu' lak'a'inilh ju lhacaticuru ni chunch ju aqui'ulhtulh. ");
INSERT INTO teeNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Pus tach'apalh ju Jesús. Talhi'alh chai tamanucha la'ixchaka' ju xak'ai pali. Pus ju Pitalu' va ixlhimakat ch'ak'ok'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Pus ju ali'in ixtamalhculatach ixpulacni ta ixlakachak'axnucanta ju ixchaka' ju xak'ai pali. Chai ixtalacsk'onvilanalh. Chai vachu' ixmakvi ju Pitalu'. ");
INSERT INTO teeNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pus pumatam atsi' acsni lakts'ilh ni anchach vachu' ixmaksk'onvi ju Pitalu' pus lana sk'otutu chai naulh: ―Ju ani vachu' ixmak'anta ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Para ju yuchi naulh ni jantu. Junich: ―Chako'ulh jantu icmispai ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Chai ni pants'iquis jumpa pus lakts'inchokopa apumatam chai junich: ―Ju uxint'i vachu' makyu'unch. Para ju Pitalu' junich: ―Jantu quit'in. ");
INSERT INTO teeNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Chai ni tapasalh tachi tam hora pus apumatam p'as naulh: ―Slivasalh ni vachu' ixt'avilhcha ju yuchi ju ani ya ni vachuch amachaka' xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Para ju Pitalu' junich: ―Jantu icmachakxai tuch'i q'ui'uni. Chai acsni ixt'ajunca' chivini' pus lana t'asalh ju puyux. ");
INSERT INTO teeNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Pus ju Jesús talakasp'itlh chai lakts'ilh ju Pitalu'. Chai ju Pitalu' lana pastaclh ju ixchivinti tachi ju ixjunita ni pakt'utu canona' ni jantu mispai acsni tuca' t'asata ju puyux. ");
INSERT INTO teeNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pus taxtulh ju Pitalu' chai na p'as tsuculh k'alhunu'. ");
INSERT INTO teeNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Pus ju anuch lapanacni ju ixtalhist'ac'ach ju Jesús va ixtalhits'i'inch ju yuchi chai ixtalakanekmai. ");
INSERT INTO teeNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Chai acsni talakpuch'ilh pus talacpasa chai tajunilhch: ―Anauch tichi chavaich ju xa'ulaniyan. ");
INSERT INTO teeNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Chai ixtajuni na lhu macxcai chivinti. ");
INSERT INTO teeNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Chai acsni tunculh pus tatak'aixtoklh ju xapapanin sia yu'unch ju israelitanin chai ju xalack'ajin ixpalijni'an chai ju yu'unch ju na ixtalhatalanininta ixlhamap'aksin'an ju ist'a'israelitanin. Pus yu'unch ju ixtalhinajun sia yu'unch ju israelitanin chai anch ju lhimincalh ju Jesús. Chai tajunich: ");
INSERT INTO teeNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","―Ja uxint'ich ju Cristo'at. Yuchi ju ixnoncan camalakachatachilh ju Dios. Aquilajuniuch. Para ju Jesús ajunich: ―Mas aclajuniu jantu at'ilac'a'it'it. ");
INSERT INTO teeNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Chai mas aclasacmiu tu'u' ixlacata yuchi jantu tu'u' aquintilalhik'alhtajiu nin yuchi ni lai aquintilamacaju. ");
INSERT INTO teeNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Para tus chavai actolach vanin junta vi ju Dios ju na tachapun. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Pus ju acsnich ixchux'an tajuni: ―Pus ja uxint'i'as ju ists'alh Dios. Chai ju yuchi ajunilh: ―Chunch tachi ju nonat'it. ");
INSERT INTO teeNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Pus ju acsnich ju yu'unch talaclajunilh: ―Pus tis alich chivinti ju maktasq'uiniyau ni qui'akstuch'an ju xak'asmatniyau tuchi xanajun. ");
INSERT INTO teeNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Pus ju acsnich ixchux'an ju xalack'ajin sia yu'unch ju israelitanin talhi'alh ju Jesús la'ixpu'ucxtin ju Pilato. Pus ju yuchi ix'ucxtin'an ixjunita ju romanonin. ");
INSERT INTO teeNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chai ju lapanacni tatsuculh ulaninin ixtalak'alhin ju Jesús. Tajunich ju Pilato: ―Ju ani ya lapanac iclhitaju ni va lak'alhiputun ju lak'achak'an chai k'alhtsajui ni amapalanancan la'ixmacni ju César. Chai ixnajun ni is'akstu ju Cristo junita chai k'ai ucxtin junita. ");
INSERT INTO teeNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pus ju acsnich ju Pilato sacmilh ju Jesús. Junich: ―Ja uxint'ich ju ix'ucxtin'an ju israelitanin. Chai ju Jesús junich: ―Chunch tachi ju na'un. ");
INSERT INTO teeNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pus ju acsnich ju Pilato ajuni ju xalack'ajin palijni chai ju ixtalhavat lapanacni: ―Jantu tu'u' talak'alhin iclhitajuni ju ani lapanac. ");
INSERT INTO teeNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Para ju yu'unch va apalai p'as tajuni: ―Para ju yuchi va amalasani ju lapanacni chai amalani ju lapanacni ju ixlhamap'aksin tachi ixlhilacaputs'un ju xa'estado Judea. Pus tai'ulachalh tus ju xa'estado Galilea chai tailhi'alh tus chilh ju ani. ");
INSERT INTO teeNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pus ju Pilato acsni k'asmatlh ju ixchivinti'an pus sacmilh ni amachaka' junita ju xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Chai acsni c'atsa ju Pilato ni amachaka' anch ixjunita ju Jesús junta ixlhinajun ju gobernador Herodes pus lana malakachanilh ju yuchi. Chai ni c'atan ixjunita ju acsnich pus ju Herodes vachu' anch ixvilhcha ju lak'achak'an Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Chai ju Herodes acsni lakts'ilh ju Jesús pus na k'achalh ni na mak'an ju ixlakts'imputun. Pus na lhu taxtokni isk'asmat'a ixlacata yuchi chai na ixlakts'imputun ni tu'uch lhamak'an canavi. ");
INSERT INTO teeNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Pus na lhu chivinti ju xasacmi. Para ju Jesús jantu tu'u' xalhik'alhtaji. ");
INSERT INTO teeNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Chai vachu' ixtavilanalh ju xalack'ajin palijni chai ju ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin. Chai ju yu'unch tap'astu ixtachivimak'an ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Pus ju acsnich ju Herodes chai ju ixtaropajni tatalacasunilh ni jantu tu'u' ixtalhiulai ju Jesús. Chai talhimak'ak'amanalh. Tamalakch'inilh ju c'usi pumpu' tachi ju talakch'i ju xalack'ajin. Chai acsni talhimak'ak'amanank'o pus malakachanichokopa ju Pilato. ");
INSERT INTO teeNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Pus ju acsnich avilhchan talama'amigoxla ju Pilato chai ju Herodes. Pus ju p'ulhnan va ixtalaxcajich. ");
INSERT INTO teeNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pus ju acsnich ju Pilato at'asanichokolh ju xalack'ajin palijni chai ju xalack'ajin sia yu'unch ju israelitanin chai ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Chai ajunich: ―Ju uxijnan quilalhiminitauch ju ani lapanac ni va nonat'it ni amalasani lapanac junita. Para ju quit'in icquilhasacmita ju yuchi ju lami'ucxlacapu'an chai jantu tu'u' iclhitajuni talak'alhin tuch'i lhich'ivimak'anat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Chai nin yuchi ju Herodes jantu xalhitajuni ju ixtalak'alhin. Yuchi quilhimalakachanichokochilh. Pus ju ani lapanac jantu tu'u' talak'alhin navita ju lai calhimakni. ");
INSERT INTO teeNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Pus yuchi aclhinona' ju ix'ulanica chai acmaconach. ");
INSERT INTO teeNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pus ju anu' c'atan ju lapanacni akts'iya istasq'uini ju gobernador ni ca'amaconicalh pumatam tach'in ni chunch ixtalhilanita. ");
INSERT INTO teeNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pus ju ixtalhavat'an lapanacni va k'aixtam p'as tanaulh: ―Jantu amac'au ju ani ya lapanac. Alai yuchi ju alhinauch ixlhi'anca. Yuchi ju Barrabás ju iclacasq'uinau ni aquilamaconiuch. ");
INSERT INTO teeNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Pus ju anu' Barrabás ixlhit'alhnucanta ni va ix'amalasani ju amachak'an anch chai va ix'amakninin. ");
INSERT INTO teeNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Para ju Pilato ni va ixmacomputun ju Jesús pus aktam axak'alachokopa ju ixtalhavat'an lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Para ju yu'unch na p'as ixtanonchokopalai: ―Amaq'uilht'at'ich ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Chai ajunchokopa ju ixlhipakt'utu: ―Para tajuch. Tis talak'alhin ju navita ju yuchi. Ju quit'in jantu tu'u' talak'alhin ju iclhitajuni ju lai aclhinaulh ixmaknica. Alai va aclhinonach ix'ulanica chai acmaconach. ");
INSERT INTO teeNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Para ju yu'unch na p'as ixtanajun acsni istasq'uinch ni camaquilhtacalh ju lacacurus. Pus ju la'ixchivinti'an ju yu'unch chai la'ixchivinti'an ju xalack'ajin palijni tat'alalhajalh. ");
INSERT INTO teeNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Chai ju Pilato lhinaulh ni chach navicalh tachi istasq'uinta ju ixtalhavat'an lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Chai amaconilh ju anu' lapanac ju ixlhit'alhnucanta ni va ix'amalasani ju lapanacni chai ni va amaknini' ixjunita. Yuchach ju istasq'uinita ju lapanacni. Chai mak'axtaklich ju Jesús ju la'ixk'achat'an ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Chai acsni talhi'alh ju Jesús pus tach'apayaulh pumatam lapanac ju Simón ixjuncan. Amachaka' xalacat'un Cirene. Ju yuchi va ixmintacha lacacuxtu. Pus tamakxk'ok'alh ju curus chai ju yuchi tamalhi'anilh junta ixp'ulai ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Chai na lhu lapanacni ixtach'ak'ok'ata ju Jesús. Chai na lhu chakolun ixtamak'anta vachu' chai na ixtalack'alhun chai na p'as ixtalact'asai. ");
INSERT INTO teeNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Para ju Jesús atalakasp'itnilh chai alacjunich: ―Chakolun amachak'an Jerusalén jantu aquilalhik'alhu ju quit'in. Alai mi'akstu'an alhik'alhunch'ok'oc'ant'it. Chai alhik'alhunt'it ju mi'ask'at'an. ");
INSERT INTO teeNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Chunch ju alat'it ni camina' ju avilhchan acsni chani catanonach ju lapanacni: “Na k'ox ju is'atsucunti'an ju chakolun ju jantu lai ix'alin ju is'ask'at'a chai ju jantu tavanan ta'ak'ainalh chai ju jantu tavanan ta'amats'iquinilh ju tam ask'at'a”. ");
INSERT INTO teeNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Pus ju acsnich avilhchan ju lapanacni catanona' ni palai k'ox cava ni va capuk'aitajunulh ju tu'u' talhpa chai ca'amakni. U ni va ca'akxtakma ju tu'u' lacat'icst'i talhpa. ");
INSERT INTO teeNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Chunch catanona' ni ca'alina' ju k'ai mak'alhk'ajnat ju acsni. Pus ju tu'u' lhtacni q'uiu jantu xavacan. Pus vana va chun ju quit'in. Jantu lhijun ni acmaknicalh ni mati' ju quintalak'alhin ju quit'in. Para ju uxijnan chunch unt'at'it tachi ju tu'u' xaxixni q'uiu ju xavacan. Pus ju alin ixtalak'alhin mamak'alhk'ajnican. Chai ixlhiyuchi amamak'alhk'ajnic'ana'it'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Chai talhi'alh vachu' apumat'ui tach'inin ju cat'amaknicananta ju Jesús. Para ju yu'unch akts'iya ixtanavita tu'u' talak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Chai acsni tacha'alh ju anu' akstijun junta sa'aktsulh juncan pus anchach ju tamaquilhta ju Jesús chai ixt'iyun'an alactu'unin. Ju pumatam tamaquilhta la'ixlhicana iscurus ju Jesús. Chai ju ak'antam la'ixlhimacx. ");
INSERT INTO teeNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Chai ju Jesús naulh: ―Quimpai amac'acxaninch ju ani tayanalh lapanacni ni jantu tac'atsai tuchi tanavi. Chai talalhvaknilh ixpumpu' ju Jesús. Chai talhilaslajlich ni catac'atsaya' tis ix'anuch cajuna' ju lakatam c'us ixpumpu'. ");
INSERT INTO teeNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Chai ju ixtalhavat lapanacni va task'otutulh. Chai mas yu'unch ju xalack'ajin ixtalhits'i'inch ju Jesús. Ixtanajun: ―Ju yuchi amak'alhtaxtulh ju ali'in. Pus chach mak'alhtaxtucalh is'akstu ni sala yuchi ju Cristo ju sacxtuta ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Chai vachu' ju taropajni talhits'i'ilh. Talakcha'alh ni va ixtaxtakniputun ju pinquin ju jantu can ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Chai tajunich: ―Ni sala ix'ucxtin'at ju mint'a'israelitanin pus amak'alht'axt'uc'ach mi'akstu. ");
INSERT INTO teeNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chai ists'okcanta la'is'aktsulh iscurus ju chivinti ju chani ixnajun: “Ju ani yuchach ju ix'ucxtin'an ju israelitanin”. Chai ists'okcanta lacalhigriego chai lacalhilatin chai lacalhihebreo. ");
INSERT INTO teeNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Chai pumatam ju anu' alactu'unin ju ix'at'amaquilhtacanta ju Jesús ixlhits'i'in vachu'. Chai juni: ―Ju uxint'i ni sala Cristo'at pus amak'alht'axt'uch'ok'oc'ach ju mi'akstu chai vachu' ju quijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Para k'ailh ju ak'antam. Junich: ―Ja jantu lana t'alhoni ju Dios ni vana va chun ju mak'alhk'ajnan ju uxint'i tachi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Chai ju quijnan'an islivasalh lhijun ni camak'alhk'ajnanauch ni navitauch ju alactu'unti. Para ju ani jantu tu'u' alactu'unti ju navita. ");
INSERT INTO teeNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Pus ju acsnich ju yuchi junilh ju Jesús: ―Aq'uimp'ast'ac'a'ich ju quit'in acsni ucxtin at'anch'ok'oya'. ");
INSERT INTO teeNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Chai ju Jesús junich: ―Slivasalh ju icjunan. Chavai avilhchan ju aq'uint'at'ola' ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Acsni cha'alh tachi k'atuncu pus na ts'is va ixlhilacaputs'un ju anu' lacat'un. Chai chunchach va tus lakat'utu hora atok'oxana'. ");
INSERT INTO teeNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Va ts'ank'alh ju avilhchan. Chai ju lacpujitat ix'alin lakatam k'ai pumpu' ju ixyocanta ni pulact'ui ixpunavicanta. Pus ju acs pants'iquis pus lana lht'it tak'exlh ju anu' pumpu' la'ixlacaitat. ");
INSERT INTO teeNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Chai ju Jesús ts'au t'asalh. Chai naulh: ―Quimpai lamimaca' icmak'axtakniyan ju quintacuvin. Chai acsni naulh ju chunch pus lana nilh. ");
INSERT INTO teeNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Chai ju xacapitán ixtaropajni ju romanonin acsni lakts'ilh tuchi tapasalh pus lak'aya ju Dios acsni naulh: ―Ju ani lapanac slivasalh na soknic'a ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Pus na lhu lapanacni ixtayanalh ni va ixtalakts'imputun ju ani lhamak'an. Chai ixchux'an acsni talakts'ilh tuchi tapasalh pus alactanquilhacsacalh ni chunch ixtanavi ju acsnich ni na ixta'amak'aninin. Chai ta'anchokolh la'ixchaka'an. ");
INSERT INTO teeNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Para chux ju ixt'alamispan ju Jesús chai ju chakolun ju ixtach'ak'ok'ata ju ixtat'amintacha ju xa'estado Galilea pus va makat ixtayanalh. Ixtalakts'in tuchi tapasalh. ");
INSERT INTO teeNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Chai ix'alin pumatam lapanac ju José ixjuncan. Amachaka' Arimatea. Chai ju yuchi makyu'unch ixjunita ju xalack'ajin sia yu'unch ju israelitanin. Chai ju yuchi na k'ox lapanac ixjunita chai na soknic'a. ");
INSERT INTO teeNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ju yuchi vachu' ixpacxantaji ju avilhchan acsni k'ai ucxtin cajuna' ju Dios. Chai jantu k'ox xalhiulai ju yuchi tachi ixtalhichivinin ju Jesús ju ixt'axalack'ajin nin tachi ju xatanavi. ");
INSERT INTO teeNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pus ju yuchi lak'alh ju Pilato chai quisq'uinilh ju ixlacatuna ju lijunto Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Chai ni lak'a'inilh ju Pilato pus ju yuchi alh chai p'uxlich. Chai pach'i lacalhman pumpu'. Chai quimacnucalh ju lacalhucucu talhpa. Chai ju anch jantuca' xamati' ixmacnucanta. ");
INSERT INTO teeNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chai ju acsnich xamisparas ixjunita ju avilhchan pa'astacni acsni jantu lai ixtach'alhcatnan. ");
INSERT INTO teeNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Chai ju chakolun ju ixtat'amintacha ju Jesús ju xa'estado Galilea tach'ak'ok'alh ju José. Talakts'ilh junta macnucalh ju lijunto Jesús chai ta yu xamamacan ju ixlacatuna. ");
INSERT INTO teeNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Chai ju chakolun ta'anchokolh la'ixchaka'an. Talak'oxilh ju ach'itin chai ju c'uch'u ju na c'us acamin. Chai ta'astacnalh ju avilhchan pa'astacni tachi ju ixnajun lacalhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pus va spalala tsuculh atuncunu' ju lhitumincu acsni ta'alh ju chakolun junta ixmacnucanta ju lijunto Jesús. Talhi'alh ju ach'itin ju na c'us acamin ju ixtalak'oxita. Chai vachu' ixtamak'anta ju ali'in t'acunin. ");
INSERT INTO teeNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Chai talhitajulh ju chiux ni mak'osucanta. Yuchi ju xamalhtich ixjunita junta ixmacnucanta ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Chai acsni tatanu pus jantu talhitaju ju ixlacatuna ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Para acsni na ixtalhamak'aninin ni mati' tu'u' ixma ju anch pus lana anch tatayacha ixpumat'ui'an lapanacni ju ixtalakch'ita lakslipnic'a ixpumpu'an. ");
INSERT INTO teeNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Pus lana na tatalhanalh ju chakolun chai tatak'entalh. Para ju anuch lapanacni tajunich: ―Tajuch ni va p'uxc'oyat'it ju t'ajun junta amacnucan ju tanita. ");
INSERT INTO teeNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ju yuchi jantu ani ma. Lok'onchokota. Ap'ast'act'it tuchi xatajunan acsni ixvilhchalhca' ju xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Xatajunan ni akts'iya istasq'uini ni camak'axtakcana' la'ixmaca'an ju lapanacni ju na alactu'unin tajunita. Yuchi ju malakachatachilh ju Dios ni lapanac catsucuya' ju ani. Chai camaquilhtacana' para calok'onchokoyach ju ixlhilakat'utu avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Pus acsnica' ju tapastaclich ju ixchivinti ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Pus tatasp'itchokocha junta ixmacnucanta ju Jesús acsni tuca' ixlok'onchokota chai ta'amac'atsani tachi chun ju ani taxtokni ju ixpumacautam'an chaich ju ali'in. ");
INSERT INTO teeNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Pus yu'unch ju Malia amachaka' Magdala chai ju Xivana chai ju Malia ixnati ju Jacobo chai ju ali'in chakolun ju tajunilh ju ixtamalakachan ju Jesús tachi chun ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Para ju yu'unch ixtanajun ni va k'aya ixtanajun ju t'acunin. Lana jantu ta'alaca'inilh. ");
INSERT INTO teeNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Para ju Pitalu' lana taya. Ats'ala'alh junta ixmacnucanta ju Jesús acsni tuca' ixlok'onchokota. Chai acsni lhan quitalacnu pus lakts'ilh ni va yuchi ju ixma ju pumpu'. Pus anchokolh la'ixchaka'. Alhamak'anini'alh tuchi xatapasai. ");
INSERT INTO teeNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Pus ju acsnich avilhchan pumat'ui sia yu'unch ixta'anta ju lak'achak'an Emaús. Vanin ixt'avi ju lak'achak'an Jerusalén. Tachi ju xa'alhtanta lakat'ui hora. ");
INSERT INTO teeNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Chai ixtalhichivi'anta tachi chun ju taxtokni ju ixtapasata. ");
INSERT INTO teeNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Chai acsni ixtalacchivi'anta pus lana chincha is'akstu ju Jesús chai k'aixtam at'a'alh. ");
INSERT INTO teeNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Para ju ix'alac'avanti'an va lataminicalh ni jantuch catamispa ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Pus ju yuchi ajunich: ―Tijuch ju lacnonat'it ju uxijnan junta alht'ananat'it. Chai tajuch ni na va amak'anininat'it. ");
INSERT INTO teeNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Chai ak'alhtayanalh pumatam ju ixt'iyun'an ju Cleofas ixjuncan. Junich: ―Tachi chun ju lapanacni ju ixtat'onacha ju lak'achak'an Jerusalén ca va uxint'i ju jantu c'ats'ai tuchi xatapasai ju anch ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Chai ju yuchi ajunich: ―Tis talakxtuch. Chai ju yu'unch tajunich: ―Ixlacata ju Jesús amachaka' Nazaret. Pus la'ix'ucxlacapu' ju Dios chai la'ix'ucxlacapu'an ju lapanacni ju yuchi malacasulh ni vasalh ixlapanac Dios ixjunita. Chai na lai ixnavi ju tu'u' lhamak'an chai na lai ix'amalaninin ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Para ju xalack'ajin palijni chai ju xalack'ajin qui'ucxtin quinc'an tamak'axtaklh ju Jesús chai tamaknilh ju lacacurus. ");
INSERT INTO teeNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Para ju quijnan xacnonau ni yuchi ixjunita ju xaquintamak'alhtaxtun ju quijnan'an ju israelitanin juntau. Chai jantu va yuchi. Para chavai ixlhilakat'utu avilhchan ju xatapasai ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Chai vachu' na iclhamak'anininau tuchi talakts'ilh ju ali'in chakolun ju sia quijnan. Ju yu'unch ma na vats'isin taquilaca'alh junta ix'acnui ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Para ma jantu talhitajunilh ju ixlacatuna. Alai tatasp'itcha chai tanaulh ni ma ixtalakts'inta vachu' ju anquilhnin. Chai ju yu'unch ma tanaulh ni ma t'ajun ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Chai ju ali'inch sia quijnan vachu' taquilalh junta ix'acnui chai chunch ju talhitajulh tachi ju ixtanajunta ju chakolun. Para ju Jesús ma jantu talakts'ilh. ");
INSERT INTO teeNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Pus ju acsnich ju Jesús ajunich: ―Na ts'inq'ui ju mintac'atsan'an ju uxijnan. Na xcaich lac'a'iyat'it tachi chun ixchivinti ju lapanacni ju ixtanajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Na istasq'uini ni calhimak'alhk'ajnalh ju ani taxtokni ju Cristo. Ju chunch ni laich calak'ayacalh. ");
INSERT INTO teeNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Pus ju acsnich ju Jesús tsuculh amavasalanini' tachi chun ju chivinti ju ists'ok'ulacanta la'ixchivinti Dios junta ixlhichivinin ju yuchi. Pus tai'ula ta ists'okta ju Moisés chai tailhi'alh tus cha'alh ta istats'okta tachi chun ju mak'aniya lapanacni ju ixtanajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Pus acsni tacha'alh ju anu' lak'achak'an junta ixta'anta pus ju Jesús lalh tachi ju va ix'amputun palai makat. ");
INSERT INTO teeNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Para ju yu'unch tap'astu tach'apayaulh. Tajunich: ―Aquilat'atolauch ni na tok'oxalh. Anchalh ju avilhchan. Pus alact'atanu ju yu'unch ni ixnajun ni ca'alact'atola'. ");
INSERT INTO teeNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Chai acsni alact'atavi ju lacamixa pus ch'apalh ju xkapavati. Junilh lak'ailakts'iuch ju Dios chai ch'ek'elh chai axtaknilh. ");
INSERT INTO teeNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Pus lana tak'oxichokolh ju ixlakchulh'an ju yu'unch chai tamispalh. Para ju yuchi lana lakmixlh. Jantu talakts'ilh. ");
INSERT INTO teeNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Chai talajunilh sia yu'unch: ―Slivasalh na xack'achanau acsni xaquintat'achivimintan ju lacati. Chai acsni xaquintamavasalanitan tuchi nomputun ixchivinti Dios ju ts'okcanta. ");
INSERT INTO teeNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Pus lana talakasitaya ju acs pants'iquis. Ta'anchokolh ju lak'achak'an Jerusalén. Chai talhitajucha ju ixpumacautam'an chai ju ali'in ju ix'alact'avi. Va lakputam ixtavilanalh. ");
INSERT INTO teeNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Chai ju ixchux'an ju yu'unch tajunilh ixt'iyun'an: ―Slivasalh ni lok'onchokolh ju qui'ucxtin'an. Pus talacasunilh ju Simón. ");
INSERT INTO teeNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Chai vachu' ixt'iyun'an tajunilh ju ixtalhavat'an tuchi tapasalh ju lacati chai ni tamispalh ni yuchach acsni ch'ek'elh ju xkapavati. ");
INSERT INTO teeNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Chai acsni ixtat'ajun nonin ju ani taxtokni pus ju Jesús lana tayacha la'ixlacaitat'an chai ajunich: ―Ak'ach'ant'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Para ju yu'unch na tatalhanalh. Na amak'esvacalh. Va ixtanajun ni ca ixtalakts'in ju alasanin. ");
INSERT INTO teeNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Para ju yuchi ajunich: ―Tajuch ni va t'alhanant'it. Tajuch ni va chunch ju p'ast'ac'at'it lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Alakts'int'it ju quimaca' chai ju quinch'aja' ni quit'inch. Aquilalacach'apauch chai aquilalakalakts'iuch. Ni va alasanin xacva pus jantu ix'alilh ju qui'acanit nin qui'alucutni. Para ju uxijnan lakts'inat'it ni alin ju qui'acanit chai qui'alucutni. ");
INSERT INTO teeNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Chai acsni naulh ju chunch pus alacmalacasunilh ju ixmaca' chai ixch'aja'. ");
INSERT INTO teeNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Para ju yu'unch jantuca' lai ixtalaca'i ni va ixtalhik'achanch ni akts'iya talakts'inchokolh chai ni va ixtalhamak'anininta. Pus yuchi alhijunich: ―Ja alin lacats'unin ju mivaiti'an. ");
INSERT INTO teeNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Pus taxtaknilh lacats'unin axp'up'unti pamata chai lacats'unin t'axcat. ");
INSERT INTO teeNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Chai ju Jesús amaklhtayanalh chai tsuculh una' la'ix'alac'avanti'an ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Chai ajuni: ―Yuchach ju chivinti ju xaclajunau acsni xaclat'avilauca' ju uxijnan. Iclajuniu ni istasq'uini ni ca'uctaxtulh tachi chun ju ists'okcanta ju quilacata la'ixlhamap'aksin ju Moisés chai la'ixchivinti'an ju lapanacni ju ixtanajun ixchivinti Dios chai lacasalmos. ");
INSERT INTO teeNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Pus ju acsnich ju Jesús alak'oxinilh ixtac'atsan'an ni laich catamachakxaya' tuchi nomputun ixchivinti Dios ju ts'okcanta. ");
INSERT INTO teeNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Chai ajunich: ―Ts'okcanta la'ixchivinti Dios ni istasq'uini ni camak'alhk'ajnalh ju Cristo chai calok'onchokolh la'ix'aninti ixlhilakat'utu avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Vachu' ts'okcanta ni ca'ajunicalh ju lapanacni ni laich ca'amac'acxanicanach ju ix'alactu'unti'an va tichi chavaich ju calaca'ilh ni Cristo yuchi ju ixnoncan camalakachatachilh ju Dios chai camacaulich ix'alactu'unti'an. Ca'ajunicalh ju ani chivinti tachi chun ju amachak'an ju k'ai lak'achak'anixni. Chai catai'ulacanach ju ani lak'achak'an Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Chai uxijnan ju anona'it'it ni lakts'int'at'it ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chai aclamalakachanitachauch ju tuchi k'alhtasuta ju quimpai ni cataxtakniyan. Para at'olat'itca' ju ani lak'achak'an Jerusalén tus acsni axt'aknic'ana'it'it ju tachaput ju caminanta talaclhman. ");
INSERT INTO teeNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ju Jesús at'ataxtulh ju ix'amamaka'ui ju lak'achak'an Jerusalén. Chai ak'ailhi'alh ju lak'achak'an Betania. Chai ch'ixlh ju ixmaca' chai asq'uininilh ju Dios ju k'ox is'atsucunti'an ju yu'unch. ");
INSERT INTO teeNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chai acsni ixt'ajunca' sq'uininini' ju Dios ju k'ox is'atsucunti'an pus lana alacmacaulich. Lhi'ancalh ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Chai ju ix'amamaka'ui talak'ayalh. Chai astan ta'anchokolh ju lak'achak'an Jerusalén chai slivasalh na ixtak'achanch. ");
INSERT INTO teeNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Chai va tachi ixtatanumanalh ju lacpujitat. Ixtajuni lak'ailakts'iuch ju Dios chai ixtalak'ayai ju yuchi.");
INSERT INTO teeNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ju yuchi ju Chivinti juncan ixt'ajunch acsni matica' tu'u' ixjunita. Chai ju yuchi va lakputam ixt'at'ajun ju Dios. Chai is'akstu ju Dios ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ju Dios va lakputam ixt'at'ajun ju yuchi tus acsni matica' tu'u' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tachi chun ju taxtokni si la'ixmacni ju navik'ojuta. Ni jantu cava ju yuchi pus mati' cava ju lacamunutpa' nin yuchi ju taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ju atsucunti la'ixmacni yuchi ju ixt'ajun. Chai yuchi ju malacpucujui ju la'ixtac'atsan'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ju yuchi ju malacpucujui la'ixtac'atsan'an ju lapanacni chunch junita tachi ju tu'u' maclhcu ju mapulhcui junta na ts'ista. Para ju anu' ju alhtanan junta puts'ista jantu lai alhajanalh. ");
INSERT INTO teeNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Pus alilh pumatam lapanac ju malakachachilh ju Dios. Ju yuchi ixjuncan Xivan. ");
INSERT INTO teeNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Yuchi lhimilh ni canonach ju tuchi c'atsaich. Yuchi ju calhichivinach ju yuchi ju lai malacpucujui ju la'ixtac'atsan'an ju lapanacni. Ju chunch chux ju lapanacni laich catalhilaca'ana' tichi chavaich ju lhichivinin ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Para jantiyu' ixjunita ju Xivan ju anu' ju lai malacpucujui ju la'ixtac'atsan'an ju lapanacni. Ju yuchi va ixmalakachacantachilh ni caxt'ak'ach ju chivinti ixlacata ju anu' ju lai malacpucujui ju la'ixtac'atsan'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ju anu' ju istavasalanti amalacpucujunun quilachilh ju ani lacamunutpa'. Ju yuchi amalacpucujuni la'ixtac'atsan'an tachi chun ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ju yuchi ixt'ajun ju ani lacamunutpa'. Chai ju lacamunutpa' la'ixmacni ju alinta. Para ju amachak'an ju ani lacamunutpa' jantu tamispa. ");
INSERT INTO teeNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Quilakquilachilh ju ixlacat'un. Para ju ixt'a'amachivinti ixtajunita acsni ixt'ajun ju ani lacamunutpa' jantu tu'u' talhiula. ");
INSERT INTO teeNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Para ju yuchi axtaknilh ixtachaput'an ni catavalhch is'ask'at'an Dios tachi chun ju lhik'ach ta'amaklhtayanalh chai talhilaksi. ");
INSERT INTO teeNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ju is'ask'at'an Dios jantu tapujunita chun tachi ju tapujunita ju is'ask'at'an tam xamati' ju ani lacamunutpa'. Alai va si la'ixk'achat Dios tapujunita is'ask'at'an. ");
INSERT INTO teeNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Chai ju anu' ju Chivinti juncan lapanac quitsucuchilh ju ani. Chai quintaquit'a'alhtananchin pants'iquis. Chai ju yuchi na lhu ixnavi ju lamapainin. Chai stavasalanti ju ixnajun. Chai iclakts'iuch ni vasalh xak'ai junita tachi ju junita ju ixpai Dios. Chai ni lakatami ists'alh Dios junita pus yuchi xak'ai lhijunita. ");
INSERT INTO teeNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ju Xivan naulh tuchi isc'atsai ixlacata ju anu' ju chivinti juncan. Chai acsni tavanan ixlhakt'asajunun pus p'as ju ixchivinin. Chanich ixnajun: ―Ju mintacha astan yuchi ju xak'ai. Jantu quit'in. Yuchach ju xaclalhakt'asajuyau ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Chai ni na lhu ju ix'amapaininti pus yuchi ju pu'amaklhtayananauch quinchux'an na lhu lamapainin ju quintanavinitan. ");
INSERT INTO teeNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ju lhamap'aksin ixlacata ixtaxtokni Dios yuchi ju ixtakta ju ixjuncan Moisés. Para ju lamapainin ju quintanavinitan chai ju stavasalanti la'ixmacni Jesucristo ju tasuk'o. ");
INSERT INTO teeNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ju Dios jantu xamati' lakts'inta tavanan. Ju lakatami ists'alh Dios slivasalh ixmapaini. Yuchach ju putalacasulh ta junitach ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ju xalack'ajin israelitanin tamalakachalh ju xapalijni. Chai alact'amalakachacalh ju levitanin junta ixvilhcha ju Xivan. Lak'achak'an Jerusalén ju ixtamintacha. Chai k'alhtayanalh ju Xivan acsni sacmicalh tichi chavaich ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Pus ju yuchi lhilatavi ju stavasalanti. Lana amavasalanilh ni jantiyu' ju Cristo ju noncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Chai aktam tasacmichokopa: ―Pus tis chavaich'at. Ja uxint'i ju Elías'at. Pus naulh ju yuchi ni jantiyu'. ―Ja uxint'i ju anu' lapanac'at ju canonach ixchivinti Dios. Pus ak'alhtayanalh. Naulh ni jantiyu'. ");
INSERT INTO teeNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Pus aktam tasacmichokopa: ―Pus tis chavaich'at. Aquilajuniuch ni lai acmac'atsanitachau ju xaquintamalakachayachin tichi chavaich'at ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Pus naulh ju Xivan: ―Ju quit'in va yuchi ni na p'as ju icchivinin junta aseknic'a. Va iclajunau ni alak'oxinit'it ju mi'alhunut'an ju mi'ucxtin'an Cristo ni caminach. Tachi ju naulh ju anu' lapanac ju Isaías ixjuncan ju ixchivinin ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Pus ju anu' lapanacni ju ix'amalakachacanta sia lhifariseonin ixtajunita. ");
INSERT INTO teeNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Chai tajunich ni tasacmi ju Xivan: ―Tajuch ni amakp'axananch ni jantu uxint'i ju Cristo'at nin Elías'at nin uxint'i ju lapanac'at ju canonach ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Pus ju Xivan acsni alack'alhtailh alacjunich: ―Ju quit'in va lacaxcan ju ic'amakpaxanan. Para junta t'onat'it t'ajun pumatam ju jantu misp'ayat'it. ");
INSERT INTO teeNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ju yuchi astan camina'. Para yuchi ju xak'ai. Jantu quit'in. Pus ju quit'in jantu tu'u' ju quintapalhni. Jantu lai actich'anxk'otlh nin mas va yuchi ju samusni ixch'anxt'ak'an. ");
INSERT INTO teeNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lhimak'antacutni xak'ai xcan Jordán ix'alin ju lak'achak'an ju ixjuncan Betábara. Anchach ju tapasacha ju ani taxtokni. Anch ju ix'amakpaxanan ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ni tuncunchokopa acsnich ju lakts'ilhch ju Xivan ju Jesús ni ixlakmintach. Chai ajunich ju lapanacni: ―Alakts'int'itch ju anu' mintacha lapanac. Tachi ixborrego Dios cajuna'. Yuchach ju camapala' ju alactu'unti lhichux. ");
INSERT INTO teeNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Yuchach ju xaclhichivinin acsni xaclajunau ni astan camina' pumatam lapanac. Yuchach ju xak'ai. Jantu quit'in ni yuchi ju p'ulhnan ixt'ajun. Jantu quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Nin quit'in jantu xacmispai. Para yuchi iclhimilhch amakpaxana' ju lacaxcan ni chunchach ju catapumispayach ju quint'a'israelitanin ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Xivan ju xtaklh ju chivinti. Chanich ixnajun: ―Iclakts'ilh ju Spiritu Santu acsni mincha ju lact'iyan tachi ju tu'u' lak'axk'avan acsni tavi la'ixlacatuna ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Pus ju quit'in jantu xacmispai. Para xaquijunitach ju anu' quimalakachachilh ni ac'amakpaxanana' lacaxcan ni ma xamati' aclakts'ina' ni calak'ana' ju Spiritu Santu chai ni ma catoc'aniyach la'ixlacatuna ma yuchach ju ca'amakpaxanana' lacaSpiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Chai quit'in ju iclakts'ilh ju tuchi tapasalh. Chai iclajunauch ni yuchach ju ani ju ists'alh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Acsni tuncunchokopa pus aktamch ix'alact'ayapa ju ixt'iyun'an ixlapanacni ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Chai ju yuchi lakts'impa ju Jesús junta ix'anta. Chai ajunich ju ixlapanacni: ―Alakts'int'itch ju anu' lapanac ju tachi ixborrego Dios cajuna'. ");
INSERT INTO teeNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Chai ju anu' ixt'iyun'an ixlapanacni ju Xivan acsni tak'asmatlh ju tuchi ixnajunch pus lana tach'ak'ok'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Chai acsni talakasp'itlh ju Jesús alakts'ilh ju ixtach'ak'ok'ata. Ajunich: ―Tijuch ju p'uxc'oyat'it. Chai tajunilh: ―Amamaka'unu' tas anchach ju t'a'un. ");
INSERT INTO teeNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Pus ajunich: ―Asok'ot'itch. Alakts'ina'it'itch junta ict'ajun. Chai tat'a'alh. Talakts'ilh junta ixt'ajun. Pus ju acsni avilhchan tat'atolhcha ni tachi lakat'at'i hora atok'oxana' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Chai ju anu' ixt'iyun'an ju ixtak'asmat'ach ixchivinti ju Xivan ju tach'ak'ok'alh ju Jesús pus pumatam ixjuncan Tilix. Yuchi ju isp'isek'e Pitalu' Simón ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pus ju Tilix lana lhitaju ju ixlak'au tucan ju ixjuncan Simón. Chai junich ju ixlak'au: ―Iclhitajuch ju Mesías. Ju chunch va nomputun: “Iclhitajuch ju Cristo ju noncan ni camalakachatachilh ju Dios”. ");
INSERT INTO teeNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Chai ju Tilix lana lhi'alh ju Simón junta ixvi ju Jesús. Acsni alakts'ilh ju Jesús junich ju Simón: ―Ju uxint'i Simón'at. Ists'alh'at ju Jonás. Ju uxint'i a'unc'ana' Cefas. Pus ju alhimapaka'ucan Cefas va Pitalu' nomputun la'ixchivinti'an ju anuch lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chai ni tuncunchokopa ju Jesús naulica' ni ca'anach ju xa'estado Galilea. Chai anch ju lhitajucha ju ixjuncan Pilipe. Chai junich ni cach'ak'ok'alh. ");
INSERT INTO teeNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ju Pilipe amachaka' Betsaida ixjunita. La'ixt'un'an ju Tilix chaich ju Pitalu'. ");
INSERT INTO teeNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ju Pilipe acsni lhitaju ju ixjuncan Natanael chanich juni: ―Iclhitajuch ju Jesús. Ists'alh ju José. Amachaka' Nazaret. Yuchach ju ixlhats'oknunta ju Moisés acsni ats'oknulh ixchivinti Dios. Chai vana chun ixtalhats'oknunta ju anu' lapanacni ju ixtanajun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Chai chani naulh ju Natanael ni ak'alhtayanalh: ―Ja laich cataxtucha ju lak'achak'an Nazaret tu'u' k'ox. Pus ju Pilipe junich: ―Pus asok'och. Anchach ju alakts'int'achich. ");
INSERT INTO teeNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Chai ju Jesús chanich naulh acsni lakts'istuclh ju Natanael junta ixmintacha. Ajunich ju lapanacni: ―Alakts'int'itch. Ani minta pumatam ju vasalh israelita. Ju yuchi jantu lai a'okxchok'onun. ");
INSERT INTO teeNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Chai ju Natanael lana ak'alhtayanalh. Naulh: ―T'as q'uilhimisp'aich. Pus ju Jesús chani lhik'alhtailh. Junich: ―Iclakts'inch acsni ixyachi' ixtank'apu' k'ai q'uiu ju higuera juncan. Acsni tuca' ist'asaniyan ju Pilipe. ");
INSERT INTO teeNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Chai ak'alhtayanalh ju Natanael. Junich: ―Amamaka'unu' ju uxint'i ists'alh Dios'at. Uxint'i ju qui'ucxtin quinc'an a'una' ju quijnan'an ju israelitanin juntau. ");
INSERT INTO teeNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Chai acsni ak'alhtayanalh ju Jesús chanich juni: ―Ja yuchi xaq'uilhilhilaksich ni va xacjunanch ni iclakts'intanch acsni ixyachi' ixtank'apu' k'ai q'uiu ju higuera juncan. Pus palai k'ai lhamak'an ju alakts'ina' astan. ");
INSERT INTO teeNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Pus chanich ajuncan ju lapanacni: ―Slivasalh ju iclajunau. Ju ca'anach avilhchan alakts'ina'it'itch ju lact'iyan ni catalhtek'ayach. Chai alakts'ina'it'itch ju ix'anquilhnin Dios ni catata'akst'aya' chai catatak'alhtajuyach acsni aquintalakminach ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chai ixlhilakat'utu avilhchan ixtailhi'anta. Acsnich ju alilhch tamak'axt'ok'at ju lak'achak'an Caná laxa'estado Galilea. Anchach ju ixvilhcha ju ixnati ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Chai vachu' alact'at'asanicalh ju Jesús ju ix'amamaka'ui junta tamak'axtokcalhch. ");
INSERT INTO teeNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Acsni c'acxtaya ju vino pus ju ixnati ju Jesús chanich juni ju ists'alh: ―Matich ju vino. ");
INSERT INTO teeNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Chai ju Jesús chani lhik'alhtailh. Junich: ―Ap'acxaca' ji quinati. Icc'atsaich tuchi acnaviya'. Tuca' chin ju pants'iquis ni lai tu'u' acnavi. ");
INSERT INTO teeNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pus ju ixnati chanich ajuni ju ixtamakch'alhcatnan anch: ―Anaviniya'it'itch tachi chun ju catajunanch ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chai ixlacvi lakachaxan lack'ai akchoko lhinavicanta chiux. Anchach ju ixtamujuich ju xcan ju ixtalhilacch'ak'ai ixlacc'a'ulh'an chai ju ixtalhimacch'ak'aich ju israelitanin ni chunch ixtalhilanitach. Va ixtanajun ni salaka catajunlh ju chunch. Chai ju lakatamin akchoko ixmujui tam cientos litros. ");
INSERT INTO teeNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ju Jesús chanich alacjuni: ―Alakts'amat'itch ju xcan ju ani lacvi akchoko. Chai ju xalapanacni tanavilh ju alhijunicalh. ");
INSERT INTO teeNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Pus lana ajunchokolh ju Jesús: ―Amac'ut'uch'ok'ot'itch ju xcan. Alhip'inichit'itch ju t'ajun xtakna' ju vaiti. Chai taquixtaknilh. ");
INSERT INTO teeNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Pus ju anuch ixt'ajun xtakna' ju vaiti acsni quilhc'atsalh ju anu' xcan ju tapala vino canch lhiula. Para jantu isc'atsai ta'anchach ju lhimincancha. Va yu'unch ju ixtac'atsai ju ixtamakch'alhcatnanch anch ni yu'unchach ju ixtamacutui ju xcan. Pus ju anu' ixt'ajun xtakna' ju vaiti lhinaulh ist'asanica ju anu' ts'alh ju tamak'axtoklh. ");
INSERT INTO teeNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Chanich juni: ―Tachi chun ju jok'atni p'ulhnan cataxt'ak'a' ju k'ox vino. Chai acsni lhilacanch cataxt'ak'ach ju palai jantuch can. Para ju uxint'i mak'at'a ju k'ox vino tus chavai. ");
INSERT INTO teeNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ju ani lhamak'an navilh ju Jesús ju lak'achak'an Caná ju laxa'estado Galilea. Yuchach ju p'ulhnan lhamak'an ju navilh ju Jesús. Chunchach ju apumalacasunilh ju lapanacni ju ixtachaput. Pus acsnich ju palai talhilaca'alh ju Jesús ju anuch ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Chai ju Jesús astan alhch ju lak'achak'an Capernaum. Yuchach chai ju ixnati chai ju is'ap'isek'en chai ju ix'amamaka'ui. Chai ju anch tatolhcha lakatam lakat'ui avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Chai vanin ixjunita ju ixc'atan'an ju israelitanin acsni alh ju Jesús ju lak'achak'an Jerusalén. Yuchach ju anu' c'atan ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chai anchach ju ixya ju k'ai ixpujitat'an ju israelitanin. Chai anchach ju alhitajulhch ju Jesús ju lapanacni ju istast'ai vacax borrego chai lak'axk'avan. Chai ixtavilanalh vachu' ju ixmapaxanin tumin. ");
INSERT INTO teeNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Chai ju acsnich ju Jesús navilh lakatam ixpanekni lasu. Pus lana tsuculh alactixcoxtunu' tachi chun ju ista'ast'ananch ju anu' la'ixpujitat'an ju israelitanin. Chai tachi chun ju borregojni chai vacax atixcoxtuk'o. Vachu' alacpumak'anik'o ju ixtumin'an ju amapaxanin. Chai alacmaktak'o ju ixmixa'an. ");
INSERT INTO teeNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Chai alacjunich ju istast'aich lak'axk'avan: ―Alhip'inchit'itch ju ani lacvi. Ju ixchaka' quimpai jantu anavit'it va xachaka' pa'ast'an. ");
INSERT INTO teeNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Pus ju anuch ix'amamaka'ui acsnica' ju tapastacli ni chunchach vasalh ju ts'okcanta junta najun: “Lana na quixcani ji quimpai ni jantu k'ox tachi ju talai ni ani ju lak'ayac'an”. ");
INSERT INTO teeNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Pus ju acsnich ju israelitanin chanich tanaulh ni tasacmich ju Jesús: ―Tijuch ju aquilamasuniyau ju acpuc'atsayauch ni xak'aich'at ju uxint'i ni laich xanavi ju ani taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Pus ju Jesús chanich alaclhik'alhtailh. Ajunich: ―Amakt'at'it ju ani ya k'ai pujitat. Chai ju quit'in va lakat'utu avilhchan ju acpulak'oxichokoya'. ");
INSERT INTO teeNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ju acsnich ta'ak'alhtayanalh ju israelitanin. Chani tanaulh: ―Ju ani k'ai pujitat t'up'uxamchaxan c'ata ju punavik'ocalh. Chai ju uxint'i ja va lakat'utu avilhchan ju lai ap'unavich'ok'o. ");
INSERT INTO teeNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Para ju Cristo ixlhichivinchokoi ju ixlacatuna is'akstu ni pujitat ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Chai acsni tavanan ta'acxtuchokolh ju Jesús junta ixmacnucanta pus acsnich ju tapastaclich ju ix'amamaka'ui ni ixnajuntach ju ani chivinti. Pus acsnich ju talaca'inilh ju anu' ats'oknut chaich ju ixchivintich ju Jesús tuchi ixnajuntach. ");
INSERT INTO teeNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Na lhu ju talhilaca'alh la'ixtapaka'ut ju Jesús acsni ixvilhchalhch ju lak'achak'an Jerusalén ju anuch c'atan ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. Talhilaca'alh ju Jesús ni ixtalakts'inch ju lhamak'an ju ixnavich. ");
INSERT INTO teeNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Para ju Jesús jantu ix'alhilaksi ju lapanacni ni ix'amispanich ju ix'atalacpast'ac'at'an ju va lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ju va ixlacata apumatam jantu ixmaktasq'uini ni xamati' ca'alh chivintanunini' tu'u' ni is'akstu isc'atsai ta yu junita ix'alhunut'an ju pumatamin lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ju pumatam lapanac Nicodemo ixjuncan. Chai ju yuchi xa'ucxtin israelitanin ixjunita. Chai na ixlaca'i vachu' ju ixlhamap'aksin'an ju fariseonin. ");
INSERT INTO teeNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ju yuchi ts'is ju quilakts'ilh ju Jesús. Chaich chani juni acsni lakcha'alh: ―Amamaka'unu' icc'atsayauch ni la'ixmacni Dios ju t'ant'a amamaka'unu'. Va icpuc'atsayauch chunch ni jantu xamati' ju lai canavi ju ani lhamak'an ju tuch'i navich ju uxint'i ni jantu cava Dios ju aktaijuyan. ");
INSERT INTO teeNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Chai ak'alhtayanalh ju Jesús. Junich: ―Slivasalh ju icjunan. Ju jantu catsucuchokoya' aktam jantu lai cati'alh junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ju Nicodemo naulh: ―Tas calhitalacat'icst'ichokolh ju na papach chai catsucuchokolh. Ja laich catanuchokolh ju la'ixpulacni ixnati chai calok'onchokolhch. ");
INSERT INTO teeNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Pus ak'alhtayanalh ju Jesús. Junich: ―Slivasalh ju icjunan. Ju tam lapanac ju akpaxta va ixlaca'atalh ni tam xajun ju is'atsucunti pus tachi ju va tsucuchokolhca'. Chai acsni tanui ju Spiritu Santu la'is'atsucunti tam xamati' pus vana tachi ju va tsucuchokolhca'. Para ju lapanacni ju jantu tam junita ju is'atsucunti'an chai ju jantu tapacxanta ju Spiritu Santu la'ix'alhunut'an pus jantu lai catitatanu junta lhinajun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ju uxijnan maklok'onc'ant'at'it ju ani la'ixtachaput ju mimpai'an minati'an. Para pu'amaklhtayanancan ju sast'i mi'atsucunti'an la'ixtachaput ju Spiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Jantu alhamak'anin ni xacjunan ni akts'iya tasq'uini ni ats'uc'uch'ok'oya'. ");
INSERT INTO teeNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ju un vanta anchach ju lai. Chai k'asmatcan ju ist'asat. Para jantu c'atsacan ta anchach ju minacha nin lai cac'atsacalh ta anchach ju anta. Vana va chun ju tam lapanac ju alin sast'i is'atsucunti ju xaxtakni ju Spiritu Santu. Ju ak'antam ju jantuca' lhilaksi ju Dios jantuca' c'atsai tuchi ju xapu'alinch ju chunch sast'i atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ju Nicodemo chanich juni: ―Pus tas lhi'ucx'antach ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Chai chanich lhik'alhtailh ju Jesús ju Nicodemo. Junich: ―Ja jantu uxint'ich pumatam ju amamaka'ui ju mint'a'israelitanin chai ixlaquilhtu jantu lai mach'akxai ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Slivasalh ju icjunan. Ju tuchi icmispayauch icnonauch. Ju tuchi iclakts'intau icmavasalayauch. Para ju uxijnan jantu lai quilalaca'iniyau ju tuchi icnonauch. ");
INSERT INTO teeNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ni icjuntan ju va ixlacata sa'atsucunti ju ani lacamunutpa' chai jantu lac'a'i ju quinchivinti tas alhilac'a'iya'ich ni acjunin ixlacata ju atsucunti ju xt'ak'a ju Dios ju vilhcha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Jantu xamati' ju quilata ju lact'iyan ni laich cac'atsa ta yu junitach ju anch. Va quit'in ju icc'atsai ta yu junitach ju anch ni anch ju xacminacha ju lact'iyan. Chai anch ict'ajun ju lact'iyan. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tachi ju Moisés ni maquilhta ju lu junta aseknic'a pus chunchach vachu' tasq'uini ni aquimaquilhtacalh ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Acsni chunch acnavicanach pus tachi chun ju aquilhilaca'anach jantu cats'ank'aya'. Alinch is'atsucunti ju conk'alhiyanta ju lact'iyan. Ju Jesús tailhi'alh ju ixchivinti chai juni ju Nicodemo: ");
INSERT INTO teeNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","―Ju Dios chunchach ju apumapaini ju lapanacni ju ani lacamunutpa' ni quilhitap'uxlh ju quit'in ju lakatami ists'alh icjunita. Ju chunch tachi chun ju aquintalhilaca'anach jantu cats'ank'aya'. Alin is'atsucunti'an ju conk'alhiyanta lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ju Dios jantiyu' quilhimacamilh ju ani lacamunutpa' ni va ac'ulanilh ixtalak'alhin'an ju lapanacni. Para alai va quilhimacamilh ni laquimacni cataputak'alhtaxtuyach ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ju quilhilaca'an pus tus ani jantuch muc'anican ju ixtalak'alhin. Para ju jantu quilhilaca'an pus tus ani muc'anicanta ju ixtalak'alhin va ixlacata ni jantu quilhilaca'anta ju laquintapaka'ut ju lakatami ists'alh Dios icjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Icminta ju ani lacamunutpa' ju quit'in ju tachi maclhcu icjunita ni ic'amalacpucujunu'. Para ju lapanacni jantu tu'u' quintalhiula. Va palai k'ox talhiula ni tachi ju va laca'atats'isni catatsuculh mas tuncujuntach. Tachi ju va laca'atats'isni ju tat'ajun ni va tanaviputun ju macxcai. Chai yuchi alhimuc'anicanta ixtalak'alhin'an. ");
INSERT INTO teeNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chai tachi chun ju tanavit'ajun ju jantu k'ox pus jantu k'ox quintalhiulai ju quit'in ju tachi maclhcu icjunita ni ic'amalacpucujunu'. Chai jantu quintalakmin ju laquimacni va ixlacata ni jantu catasu tuchi tanavich. ");
INSERT INTO teeNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Para ju navi ju stavasalanti quilakmin ju quit'in ju tachi maclhcu icjunita ni ic'amalacpucujunu'. Ju chunch laich calakts'incana' tuchi navich ni la'ixtachaput Dios ju navi. ");
INSERT INTO teeNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Acsni tapasak'olhch ju ani taxtokni pus astan ju Jesús alact'amilh ju ix'amamaka'ui laxa'estado Judea. Chai acsni ix'alact'avilhcha ju anch pus ixta'amakpaxananch ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ju Xivan vachu' ix'amakpaxanan ju lak'achak'an Enón ju vanin ixt'avi ju lak'achak'an Salim. Chai ju ixtach'ak'ok'aich ju yuchi anch ju ix'amakpaxaich ni na lhu ix'alin ju xcan ju anch. ");
INSERT INTO teeNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ju Xivan tuca' ixt'alhnucanta. ");
INSERT INTO teeNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pus ju israelitanin ixtalhilanita ni na paklhu ixtalacch'ak'ai ixlacc'a'ulh'an chai na paklhu ixtak'aich'ak'ai ni ma chunch salaka ca'alakts'ilh ju Dios. Pus ju ix'amamaka'ui ju Xivan ni jantu chun ixtanavi tachi ju ixtalhilanitach ju ist'a'israelitanin pus at'alak'ajicalh ju ixlapanacni ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Chai ju ix'amamaka'ui ju Xivan talakmilh ju ix'amamaka'unu'an. Tajunich: ―Amamaka'unu' ju anu' lapanac ju ixt'avilhchan lhimak'antacutni xaxcan Jordán ju chavai amakpaxananch chai na lhu ju talakxcavataji ju yuchi. Yuchi ju anu' ju lhich'ivin. ");
INSERT INTO teeNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Chai ak'alhtayanalh ju Xivan. Ajunich: ―Jantu lai xamati' amaklhtayanan tu'u' tachaput ni jantu lact'iyan ju caxtaknicancha. ");
INSERT INTO teeNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mi'akstu'an uxijnan ju k'asmat'at'it acsni icnaulhch ni jantu quit'in ju icCristo ju noncan camalakachatachilh ju Dios. Ju quit'in va p'ulhnan icmalakachacantachilh. Astan mintacha ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Junta tamak'axt'ok'a tam ts'alh pus anchach vachu' ya ju ix'amigo chai ni k'asmat'a ixchivinti ju anu' ix'amigo acsni t'achivinin ju is'asq'uininti pus na k'achanch. Pus vana va chun ju quit'in. Na ick'achan acsni tak'asmatni ixchivinti ju Cristo ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tasq'uini ni cac'atsacalh ni yuchi ju xak'ai. Para tasq'uini ni jantu tu'u' quintapalhni cava ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ju lact'iyan mintachalh yuchach ju palai xak'ai. Ju va lhilapanac tsucuta pus va lhilapanac t'ajun chai va ixtaxtokni lacamunutpa' ju lhichivinin. Para ju lact'iyan mintacha yuchi ju palai xak'ai. ");
INSERT INTO teeNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ju tuchi lakts'inta ju yuchi chai k'asmat'ach pus yuchach ju najun. Para jantu xamati' laca'ini ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ju laca'ini ju ixchivinti mavasalai ni vas najun ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ju macaminta ju Dios pus chivinin ixchivinti Dios. Chunchach chivinin ni jantu va lhcaxt'ak'a ju Dios ju Spiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ju xapai Dios mapaini ju ists'alh. Chai xtaknik'ota ixtachaput ju ists'alh. ");
INSERT INTO teeNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ju lhilaca'anch ju ists'alh Dios alin is'atsucunti ju conk'alhiyanta tus lact'iyan. Ju jantu tu'u' lhiulani ju ists'alh Dios jantu cati'alilh ju is'atsucunti ju conk'alhiyanta lact'iyan ni va ulanich ixtalhk'amti ju Dios ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ju Jesús machakxa ni ixtamack'alhak'asmatnantach ju fariseonin ni ixlacnoncanch ni palai lhu ixlapanacni ju Jesús chai palai lhu ix'amakpaxanan ju yuchi. Palai jantu ju Xivan. ");
INSERT INTO teeNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Mas jantu xa'amakpaxanan ju Jesús. Va yu'unch ju ixta'amakpaxanan ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pus ju Jesús acsni c'atsalh ni chunch ixtak'asmat'a ju fariseonin pus taxtulh ju xa'estado Judea. Va ix'anchokoputun ju xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Chai yuchi lhitapasatilalh ju xa'estado Samaria. ");
INSERT INTO teeNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ju yuchi milh ju lak'achak'an junta ixjuncan Sicar laxa'estado Samaria. Vanin t'alach'apata ju ixt'un ju anu' mak'aniya israelita ju ixjuncan Jacob. Anch junta lhik'ailakts'inta ju ists'alh ju ixjuncan José. ");
INSERT INTO teeNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chai ju anch ixvi ju pos ju ix'anuch ixjunita ju Jacob ju mak'anchich. Pus anchach ju astacnalh ju Jesús ni na ixk'optach ni na makat ju ix'alhtananta. Chai ixt'ajunch k'atuncunu'. ");
INSERT INTO teeNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Chai cha'alh pumatam chako'ulh amachaka' Samaria. Va ix'iputun ju xcan. Pus ju Jesús junich: ―Aq'uint'ak'ot'ich lacats'unin ju mixcan. ");
INSERT INTO teeNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Pus ju ix'amamaka'ui ju Jesús ixta'anta ju lak'achak'an tamonin ju vaiti. ");
INSERT INTO teeNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pus ju anu' chako'ulh ju amachaka' Samaria ixjunita chanich lhik'alhtayanalh: ―Ju uxint'i ni va israelita'at tajuch ni va q'uisq'uinip'alai ju xcan. Ju quit'in ni ic'amachaka' Samaria. Ju israelitanin jantu lai tat'alaxak'alai ju amachak'an Samaria. ");
INSERT INTO teeNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Chai ak'alhtayanalh ju Jesús. Junich: ―Ju uxint'i jantu misp'ai ju ixlhak'ailakts'in Dios. Chai jantu q'uimisp'ai tichi chavaich ju quit'in ju icjunan ni aq'uint'ak'ot'ich ju mixcan. Ni xaq'uimisp'at'i cava pus alai uxint'i xaq'uisq'uinin chai xacxtaknin ju xcan ju xt'ak'a ju atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Pus ju chako'ulh chani lhik'alhtayanalh: ―Ji compari mati' ju ap'u'it'i ju xcan. Ju pos ni na putalhman. Tas anchach ju lai a'iya' ju mixcan ju xt'ak'a ju atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ju uxint'i ja xak'ai'at. Ja palai jantu ju mak'aniya quimpai'an Jacob ju quintaxtaknitan ju ani pos. Anich ju k'otlh ju yuchi chai ju is'ask'at'an chaich ju ix'atapacxat. ");
INSERT INTO teeNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ju Jesús chani lhik'alhtayanalh: ―Va tichi chavaich ju cak'ot'a' junima xcan caquicxixchokoya'. ");
INSERT INTO teeNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Para va tichi chavaich ju cak'ot'a' ju xcan ju acxtakniya' quit'in jantu tavanan catiquicxixchokolh. Ju anu' xcan ju acxtakniya' quit'in tachi k'ai pos cajuna' la'ix'alhunut ju jantu tavanan caxixa'. Chai yuchi ju capu'alinach is'atsucunti ju conk'alhiyanta tus lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Pus ju chako'ulh chanich juni: ―Pus ji compari aq'uixt'akninch ju anu' xcan. Ju chunch jantuch acquicxixchokoya'. Chai jantu acmina' ini' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Chai ju Jesús chanich juni ju anu' chako'ulh: ―A'inchich t'asanini' ju mimpapa. K'aixtamch at'at'ana'. ");
INSERT INTO teeNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Chai ju chako'ulh chani lhik'alhtayanalh: ―Mati' ju quimpapa ju quit'in. Chai ju Jesús chani juni: ―Stavasalantich ju na'un ni mati' ju mimpapa. ");
INSERT INTO teeNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Pumaquisich lapanacni ju t'ats'uc'umak'ant'a. Chai ju chavai t'at'a'un jantuch yu' ju mimpapa. Stavasalantich ju na'un. ");
INSERT INTO teeNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Pus ju chako'ulh chani lhik'alhtailh: ―Compari icc'atsaich ni laich vachu' na'un ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ju quilacpai quinc'an anch ju anu' lactalhpa ju ixta'an lak'ayanin ju Dios. Para ju uxijnan ju israelitanin unt'at'it nonat'it ni va anch ju lak'achak'an Jerusalén ju lai ac'alh lak'ayana' ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Pus ju Jesús chani lhik'alhtailh: ―Chako'ulh aq'uilac'a'ininch ju acjunan. Camina' avilhchan ni jantu at'ilak'ayat'it ju xapai Dios nin yuchi ju ani lactalhpa nin anch ju lak'achak'an Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ju uxijnan jantu c'ats'ayat'it tuch'i ju lak'ayayat'it. Ju quijnan icc'atsayau tuchi ju iclak'ayayau ni laquilhiquijnan ju israelitanin icjuntau ju ca'alina' ju amak'alhtaxtunu'. ");
INSERT INTO teeNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Cachinach ju avilhchan ju vasalh nomputun ni xak'ai ju xapai Dios catanonach la'ixlhichux ix'alhunut'an chai calak'ayaya' tachi ju k'achani ju yuchi. Chai mas chavaich chunch catalalh. Pus ju xapai Dios lacasq'uin ni cata'alilh ju lapanacni ju chunch catalak'aya. ");
INSERT INTO teeNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ju Dios mati' ixlacatuna. Ju talak'ayaich ju yuchi tasq'uini ni catalak'aya la'ix'alhunut'an chai tachi ju k'achani ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ju chako'ulh chani juni: ―Icc'atsaich ni camina' ju noncan camalakachatachilh ju Dios. Yuchi ju talhimapaka'ui Cristo. Chai acsni camina' ju yuchi aquintamavasalanik'oyan chux ju taxtokni. ");
INSERT INTO teeNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ak'alhtayanalh ju Jesús: ―Quit'inch ju icCristo ju ict'achivinan. ");
INSERT INTO teeNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Acsnich ju tachincha ju ix'amamaka'ui ju Jesús. Pus na talhamak'aninilh ni va ixt'ajunch t'achivini' ju anu' chako'ulh ju Jesús. Para jantu xamati' ju lai casacminilh ju laich cajunilh: “Tijuch ju sasacmi” U “Tijuch ju xalhit'ach'ivinin ju chako'ulh”. ");
INSERT INTO teeNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Pus ju chako'ulh macau'ula ju ix'akxau chai anchokolh ju lak'achak'an. Alh alacjunini' ju amachak'an anch. Ajunich: ");
INSERT INTO teeNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Ca'auch lakts'inin ju anu' lapanac ju xaquijuni tachi chun ju icnavitach. Ja jantiyu' nu' ju Cristo ju noncan camalakachatachilh ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Pus ju acsnich lana tataxtucha ju lapanacni ju lak'achak'an chai talakmilh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Acsni tuca' ixtacha'an ju lapanacni pus ju ix'amamaka'ui ju Jesús tak'asilhijunich ju vaiti. Tajuni: ―Amamaka'unu' avaich. ");
INSERT INTO teeNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Para ju yuchi chani alhik'alhtailh: ―Ju quit'in alin ju tuchi ic'ui. Para ju uxijnan jantu c'ats'ayat'it tis talakxtuch. ");
INSERT INTO teeNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ju acsnich ju ix'amamaka'ui ju Jesús talaxak'alalh ju ixlhi'akstu'an. Talajunich: ―Ja xamati' nu' ju xalhimini ju ixvaiti. ");
INSERT INTO teeNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ju Jesús ajunich: ―Tachi ju uxijnan ni tachapun jun ju milacatuna'an acsni venat'it pus vana va chun ju quit'in. Tachapun jun ju quintac'atsan acsni icnavini ju ixk'achat ju quimacaminta chai ni acnavinik'o ju ixlhich'alhcat. ");
INSERT INTO teeNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Chai jantu ana'unt'it ju uxijnan ni tic'acxaca' lakat'at'i malhquiyu' tus acsni cachina' ju pa'axk'an. Iclajunau: Alac'avanant'it. Alac'ap'it'it ju lacacuxtun. Na lacxixtach. Laich ac'axk'analh. Pus vana va chun ju ani taminta lapanacni. Na lhu ju tak'asmatputun ixchivinti Dios chai catalaca'iyach. ");
INSERT INTO teeNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pus ju camavasalayach ju quilacata alin ju ixtalhaja chai a'aktaijui lhu lapanacni ni laich catalaca'iyach chai ca'alina' is'atsucunti'an ju conk'alhiya' tus lact'iyan. Ju p'ulhnan canona' ju chivinti cak'achanach. Chai ju xamavasalana' ju tuchi catalaca'iya' vachu' cak'achana'. ");
INSERT INTO teeNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ju ani chivinti mavasalai ni stavasalanti tachi ju noncan: “Pumatam ju ach'ananan. Chai apumatam ju ca'axk'anana'”. ");
INSERT INTO teeNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Quit'in ju xaclamalakachayau ju axk'anti junta jantu uxijnan ch'ant'at'it. Ju chunch nomputun ni ali'in ju p'ulhnan tanajunta ju chivinti ju quilacata chai uxijnan ju xa'amavasalanin ju chivinti unt'at'it chai quintalhilaksilh lhu ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Na lhu ju amachak'an Samaria talhilaca'alh ju Jesús va ixlaca'atalh ju ixchivinti ju anu' chako'ulh acsni ajunilh: “Ju yuchi quijonk'och chux tuchi icnavitach”. ");
INSERT INTO teeNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Pus ju amachak'an Samaria acsni talak'alh junta ixvilhcha ju Jesús tatapaininilh ni ca'alh tsucunu' pants'iquis ju la'ixlak'achak'an'an. Pus ju Jesús anch tolhcha lakat'ui avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pus acsnich ju palai lhu talhilaca'alh ju Jesús ni tak'asmatnilh is'akstu'an ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Chanich tajuni ju chako'ulh: ―Ju chavai jantuch va laminchivinti ju iclaca'iyauch. Ju chavai qui'akstu quinc'an xack'asmat'au ju ixchivinti ju ani ya lapanac chai icc'atsayau ni slivasalh ni yuchach ju Cristo ju ani ya ju noncan ni camalakachatachilh ju Dios. Yuchi ju ca'amak'alhtaxtuya' ju lapanacni ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ju ixlhilakat'utu avilhchan taxtulh ju Jesús ju anch lak'achak'an. Alhch ju laxa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Va is'akstu ju Jesús chani ixnajunta: ―Ju tam lapanac ju najun ixchivinti Dios jantu tu'u' lhiulacan ju la'ixt'un. ");
INSERT INTO teeNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Acsni cha'alh ju xa'estado Galilea pus ju amachak'an anch va lhik'achach ta'amaklhtayanalh ju Jesús ni ixtalakts'intach tachi chun ju lhamak'an ju ixnavitacha ju lak'achak'an Jerusalén acsni c'atanicanchalh ju anch. Ju amachak'an Galilea vachuch ixtamakquilata junta alilh c'atan. ");
INSERT INTO teeNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Chai aktam anchokopa ju Jesús ju lak'achak'an Caná lhiGalilea junta ixlak'oxitacha ju xcan ju lapala vino. Chai ju ists'alh ju pumatam xak'ai ixmacha lak'achak'an Capernaum. Va ixtak'ank'ai. ");
INSERT INTO teeNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Pus ju anu' lapanac k'asmatlh ni taxtutachalh ju Jesús ju xa'estado Judea. Chai c'atsalh ni cachinach ju xa'estado Galilea. Pus ju anu' lapanac lak'alh ju Jesús. Tapaininilh ni ca'alh chai palaich canavi ju ists'alh ni va ixt'ajunch nini'. ");
INSERT INTO teeNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ju acsnich ju Jesús juni: ―Jantu tavanan lai lac'a'iyat'it ni jantu lakts'inat'it tu'u' ixpulaca'ican chai ju tu'u' lhamak'an. ");
INSERT INTO teeNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Chai ju anu' xak'ai junich ju Jesús: ―Qui'amigo ap'it'ich lakts'ini' ju quints'alh ni tuca' ni. ");
INSERT INTO teeNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Pus ju Jesús junich: ―A'inchich. Palaich junita ju mints'alh. Pus ju anu' lapanac laca'inilh ju ixchivinti ju Jesús ju tuchi junilh chai anchokolh la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Chai acsni ix'anta ju lacati pus taquipakxtokchilh ju ixlapanacni. Taquimac'atsanichilhch ni palaich ju ists'alh. ");
INSERT INTO teeNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Chai ju anu' xapai tak'ank'an asacmich ju ixlapanacni tuchi horach ju palai xajun ju ists'alh. Chai ju xalapanacni tajunich: ―Cutanch. Lakatam hora atok'oxana' ju macaulh ju scacat. ");
INSERT INTO teeNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Pus ju xapai tak'ank'an lana machakxa ni acsnich hora ju naulh ju Jesús ni palaich ju is'ask'at'a. Pus ju anu' lapanac chai chux ju ixtatanumanalh la'ixchaka' lana talhilaca'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Acsni taxtucha ju laxa'estado Judea ju Jesús pus cha'anchokolh ju laxa'estado Galilea. Chai yuchach ju ani ju ixlhilakat'uich ixpulaca'ican ju navi ju Jesús ju laxa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Acsni tapasalh ju ani taxtokni pus ju Jesús alh ju lak'achak'an Jerusalén chai ju acsni ixc'atan'an ixjunita ju israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ju lak'achak'an Jerusalén ix'alin lakatam malhtich junta ix'apumanucan ju borregojni. Chai anch ixvi lakatam tanque ju ixjuncan lacalhihebreo Betesda. Chai ix'alin lakaquis samakspa'. ");
INSERT INTO teeNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ju anch na lhu ix'amamacanta ju tak'ank'anin. Ju ali'in va alak'ach'ix ixtajunita. Ju ali'in va ixch'antak'alhita. Ju ali' va ixtaxixta la'ixlacatuna'an. Sich yu'unch ju ixtapacxanch ni calucunulh ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Aktamixnin pumatam anquilh ixmalucuni ju anu' xcan. Chai ju p'ulhnan catajuya' ju lacatanque acsni lucununtach ju xcan pus palai ixjun mas va tuchi tak'ank'at cach'apalh. ");
INSERT INTO teeNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chai ixma pumatam lapanac ju ixpacxanta ixtak'ank'at lakap'uxamcautsajin c'ata. ");
INSERT INTO teeNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ju Jesús lakts'ilh junta ixma. Chai c'atsalh ni na mak'aniya tak'ank'at ju ixch'apata. Pus junich: ―Ja lac'asq'uin ni palai a'unt'i. ");
INSERT INTO teeNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Pus ak'alhtayanalh ju anu' tak'ank'an. Junich: ―Qui'amigo mati' xamati' ju lai aquimuju ju lacxcan acsni t'ajun lucunu'. Acsni ictajuputun ju quit'in ak'antamch tajumapa. ");
INSERT INTO teeNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ju Jesús junich: ―Ak'ost'a'ulhch. Asact'ich ju mimputaman chai alht'anch. ");
INSERT INTO teeNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ju acsnich lana palai va ju lapanac. Saclh ju ixputaman chai alhtanalh. Ju acsnich avilhchan pa'astacni ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ju acsnich ju xalack'ajin israelitanin chani tajuni ju anu' tak'ank'an ixjunita: ―Ju chavai avilhchan pa'astacni junita. Jantu lhijun lacalhamap'aksin ni lai ac'uc'a ju mimputaman. ");
INSERT INTO teeNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pus ju tak'ank'an ixjunita alack'alhtailich. Ajunich: ―Ju palai xaquinavi is'akstu ju xaquijuni ni acsaclh ju quimputaman chai ac'alhtanalh. ");
INSERT INTO teeNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Pus palai taquilhasacmi. Tajuni: ―Tis chavaich ju xajunan ni asact'ich ju mimputaman chai alht'anch. ");
INSERT INTO teeNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pus ju anu' ju palai ixnavicanta jantu ismispai tichi chavaich ju palai ixnavita. Ju Jesús ixmakpulacnat'ajun la'ixtalhavat lapanacni ju ixtayanalh anch. ");
INSERT INTO teeNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Chai ju astan lacpujitat ju t'alapakxtoklh ju Jesús ju anu' ixc'uch'uta. Chai junich: ―Alakts'ich. Palaich unit'a. Tun alact'u'unump'alh. Tun palai macxcai camilh ju mimak'alhk'ajnat. ");
INSERT INTO teeNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ju anu' lapanac alh ajunini' ju xalack'ajin israelitanin ni yuchach ju Jesús ju palai ixnavita. ");
INSERT INTO teeNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Pus ixlhiyuchach talhixcailich ju Jesús ju xalack'ajin israelitanin. Chai ixtalhimakniputunch ni ixnavich ju ani taxtokni ju va avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ju Jesús ak'alhtayanalh: ―Ju quimpai tus chavai ju ch'alhcatnan. Chai vachu' ju quit'in icch'alhcatnan. ");
INSERT INTO teeNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Pus acsnich ju palai ixtalhimakniputun ju israelitanin ju Jesús. Para jantu va yuchi ju ixtalhimakniputun ni va ch'alhcatnalh ju anu' avilhchan pa'astacni para vachu' ixlaca'atalh ni va ixnajunch ni Dios ju ixpai. Ju chunch ixnomputun ni va ixt'achunchach ixjunita ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Chai ak'alhtayanalh ju Jesús. Ajunich: ―Slivasalh ju iclajunau. Ju quit'in ni va icsa'ask'at'a pus jantu lai icnavi tu'u' ju va laqui'akstu. Yuchi ju icnavich ju icmaklakts'inch ju quimpai. Ju chunch tachi chun ju navi ju quimpai vachuch yuchi ju icnavi ni ists'alh ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ju quimpai na quimapaini ni ists'alh ju quit'in. Chai quimalacasunik'ojuta tachi chun ju taxtokni ju navi ju yuchi. Chai aquimalacasuniya' palai k'ai lhamak'an ni laich alhamak'aninina'it'it. ");
INSERT INTO teeNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tachi ju quimpai ni lai malok'oni ju nitach chai xtaknichokoi ju is'atsucunti pus chunchach vachu' ju quit'in ni ists'alh icjunita. Vachu' lai acxtakniya' ju is'atsucunti va tichi chavaich ju acxtakniputunach. ");
INSERT INTO teeNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ju quimpai jantu lakts'intanui xamati'. Para quixtaknita quimpuxak'ai ni lai ac'alakts'intanu ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Pus yuchi aquintalhilak'ayayach tachi chun ju lapanacni tachi ju talak'ayaich ju quimpai. Ju jantu quilak'ayai ju quit'in ni ists'alh icjunita pus sin quimpai jantu lak'ayai ni yuchi ju quimalakachatachilh. ");
INSERT INTO teeNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Slivasalh ju iclajunau. Ju cak'asmat'a' ju quinchivinti chai ju calhilaca'anach tichi chavaich ju quimalakachatachilh pus alinch is'atsucunti jonk'alhita lact'iyan. Ju yuchi jantuch calakts'intanucana' ixlacata ixtalak'alhin. Chai jantu cati'alh junta jonk'alhita mak'alhk'ajnat. Alai tus chavai lana alinch is'atsucunti ju conk'alhiyanta tus lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Slivasalh ju iclajunau. Ju atipu'anta u mas chavai ju jantuca' talhilaksi ju Dios aquintak'asmatniyach ju quinchivinti ni ists'alh ju Dios ju quit'in. Chai tachi chun ju aquintak'asmatniyach catatsucuchokoyach. ");
INSERT INTO teeNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Tachi ju quimpai ni lai axtakni ju is'atsucunti'an ju lapanacni pus chunchach vachu' ju quit'in ni ists'alh icjunita. Ju yuchi quixtaknita ju quintachaput ni lai ac'axtakniya' is'atsucunti'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pus vachuch quixtaknilh ju quimpok'ai ni laich ic'alakts'intanui ju lapanacni ni quit'inch ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jantu alhamak'aninint'it ju ani. Camina' ju avilhchan acsni catak'asmat'ach ju quinchivinti tachi chun ju ta'acnununta. ");
INSERT INTO teeNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Chai catata'acxtuyach. Ju tanavita k'ox ca'axtaknicanach is'atsucunti'an jonk'alhita lact'iyan. Ju tanavita ju talak'alhin ca'axtaknicanach ixmak'alhk'ajnat'an junta jonk'alhita. Ju Jesús tailhi'alh ju ixchivinti chai chani ajunilh ju ist'a'israelitanin: ");
INSERT INTO teeNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","―Jantu lai icnavi tu'u' ju va qui'akstu. Tachi ju icjuncanch chunchach ju icmuc'ai ju talak'alhin. Chai mas icmuc'ai ju talak'alhin ju quit'in para soknic'a ju icnavi ni jantu va quink'achat qui'akstu icpuxcajui. Va yuchi ju quimpai icnaviniputun ju ixk'achat ni yuchi ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Pus ni va qui'akstu cava ju icnajun ni icxak'ai pus ju quinchivinti jantu ca'ixlhitapalalh. ");
INSERT INTO teeNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Para alin pumatam ju xt'ak'a ju chivinti ju quilacata. Chai icc'atsai ni stavasalanti ju tuchi najun. ");
INSERT INTO teeNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Chai uxijnan mi'akstu'an ju malak'ach'anit'it pumatam ju Xivan ju amakpaxana' ni caquilhasacmi ta lhijunitach. Chai ju yuchi tajunin ju istavasalanti. ");
INSERT INTO teeNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pus ju quit'in jantu tu'u' iclhiulai ju va ixchivinti lapanac. Ju iclapujunauch ju ani ts'a ma laich at'ak'alht'axt'ut'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ju Xivan tachi maclhcu ixjunita ju maktaji chai mapulhcui. Ju uxijnan lhik'ach'ant'it pants'iquis ni ixtamapulhcuniyan lamintac'atsan'an. ");
INSERT INTO teeNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Para ju lhamak'an ju icnavi putasui tichi chavaich ju quit'in. Ju yuchi palai lhitapalai. Palai jantu ju tuchi quilhichivinilh ju Xivan. Ju quimpai quixtaknilh ju ixlhich'alhcat ni acnavinik'o. Chai ju anu' lhich'alhcat ju icnavi yuchach ju putasui tichi chavaich ju quit'in ni quimpai ju quimalakachatachilh. ");
INSERT INTO teeNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Chai quimpai ju xaquimalakachayachilh yuchi ju xtakta ju chivinti ju quilacata. Ju uxijnan jantu tavanan k'asmat'at'it ju ixchivinti nin alakts'int'it ta yu junitach. ");
INSERT INTO teeNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ju uxijnan jantu p'acxant'at'it ju ixchivinti lami'alhunut'an va ixlacata ni jantu quilaquiclaca'iyau mas yuchi ju quimalakachatachilh. ");
INSERT INTO teeNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tasq'uini ni alhit'amak'a'ut'it k'ox ju ixchivinti Dios ni nonat'itch ni anch ju alhit'a'uya'it'it ju atsucunti ju conk'alhiyanta tus lact'iyan. Chai alhit'a'uya'it'it ni vana anch quilhichivinin quilacata. ");
INSERT INTO teeNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Para ju uxijnan jantu t'amp'ut'unat'it ju laquimacni ni laich ap'acxant'it ju mi'atsucunti'an ju jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ju quit'in jantu iclacasq'uin ni canaulh ju va tam lapanac ni icxak'ai. ");
INSERT INTO teeNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Icc'atsai ni jantu map'ainiyat'it ju Dios lami'alhunut'an ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ju quit'in la'ixtapaka'ut ju quimpai icminta. Chai jantu tu'u' quilalhiulayau. Para ni apumatam camilh la'ixtapaka'ut is'akstu pus ju yuchi na tu'u' alhiulaya'it'it. ");
INSERT INTO teeNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tas laich aquilalhilaca'iniyau ju quit'in ni va lamilhi'akstu'an ju la'unat'it ni na xalack'ajin unt'at'it. Jantu lac'asq'uinat'it ni Dios ju canaulh ni xalack'ajin unt'at'it. ");
INSERT INTO teeNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Tun va ana'unt'it ni quit'in ju iclachivimak'anau ju la'ix'ucxlacapu' ju quimpai. Alin tichi chavaich ju tachivimak'anan. Yuchi ju ixjuncan Moisés mas yuchi ju lhilac'ap'inat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ju uxijnan ni vasalh cava ixlac'a'init'it ju Moisés pus vachu' xaquilalaca'iniuch ju quit'in ni quilhi'ats'oknunta quilacata ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Para ni jantu lac'a'iyat'it ju is'ats'oknut ju Moisés tas alhilac'a'iya'it'itch ju quinchivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Astan ju Jesús alh ju lhimak'antacutni ju atants'in Galilea junta vachu' juncan Tiberias. ");
INSERT INTO teeNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Na lhu lapanacni tach'ak'ok'alh ju Jesús ni ixtalakts'inch ju lhamak'an ju ix'anavini ju tak'ank'anin. ");
INSERT INTO teeNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pus ju Jesús alh ju lactalhpa chai anch alact'atolhcha ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Quilhpaminta ixc'atan'an ixjunita ju ist'a'israelitanin acsni ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Acsni laca'anchokolh ju Jesús junta pumilh pus lakts'ilh ni na lhu ixtaminta ju lapanacni. Pus ju Jesús junich ju Pilipe: ―Tas anchach ju lai catama'u ju vaiti ni camavauch ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Para ju chunch punaulh ju Jesús va ixpulakts'intanuputun ju Pilipe. Ju Jesús is'akstu isc'atsai tuchi ju canaviya'. ");
INSERT INTO teeNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pus ak'alhtayanalh ju Pilipe. Najunch: ―Mas aclhitamaulh ju vaiti xatalhaja lakat'ui cientos avilhchan ca jantu catitalhilalh mas va lacts'unin ju ac'axtaknilh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Pus ju pumatam ixtamamaka'un isp'isek'e ju Simón Pitalu' ixjunita. Ju yuchi ixjuncan Tilix. Ju yuchi junilh ju Jesús: ");
INSERT INTO teeNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Ani ya pumatam ts'alh ju ch'apata aksquis xavati cebada chai lakat'ui pamata. Va yuchi ni va lacats'unin. Ju lapanacni na ilhu'an. ");
INSERT INTO teeNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ju acsnich ju Jesús ajunich ju ix'amamaka'ui: ―A'unit'itch ju lapanacni ni catatavilhch. Pus na ixma ats'in junta tatavilhch ju lapanacni. Ixtacha'anta lakaquis milh jok'atni. ");
INSERT INTO teeNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ju Jesús acsni ch'apalh ju anu' vati pus xtaknilh lhak'ailakts'iuch ju Dios. Astan ju axtaknilh ju ix'amamaka'ui. Pus ju anuch ix'amamaka'ui tamakpitsilh la'ixtalhavat lapanacni ju ixtavilanalhch lacats'inan. Vana va chun navicalh ju pamata. Chai ta'ulhch tachi ju talacasq'uilhch. ");
INSERT INTO teeNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Acsni talhilalhch pus ju Jesús ajunich ju ix'amamaka'ui: ―Asact'itch ju vaiti ju xajacha. Ju chunch jantu tu'u' cats'ank'aya'. ");
INSERT INTO teeNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Pus acsni tasaclh cha'alh lakacaut'ui tank'alin ju xajchalh ju anu' aksquis xavati cebada. Yuchi ju tamaxajnichalh ju ta'ulh ju ixtalhavat lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ju anuch lapanacni acsni talakts'ilh ju anu' lhamak'an ju navilh ju Jesús pus tanaulh: ―Ju ani slivasalh ca yuchach ju anu' lapanac ju caminach nona' ixchivinti Dios ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ju Jesús acsni machakxalh ni va tap'astu ixtanaviputun k'ai ucxtin pus alack'osmak'alh ju lapanacni. Alh tolhna' lactalhpa. ");
INSERT INTO teeNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Acsni ixt'ajunch tok'oxana' pus ta'alh ju laca'atants'in ju ix'amamaka'ui ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chai tataju ju lacabarco. Va ixta'amputunch lhimak'antacutni ju atants'in junta ixvilhcha ju lak'achak'an Capernaum. Pus tamaklhtats'islich ju laca'atants'in chai ju Jesús ju acsni tuca' sip ixlai. ");
INSERT INTO teeNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pus ju xcan na p'as ixt'ajun lucunu' ni na p'as ixlai ju k'ai un. ");
INSERT INTO teeNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Acsni ta'alhtanalh tachi lakaquis u lakachaxan kilometro pus talakts'istuclich ju Jesús ni ix'alhtanamintach la'ix'ucxni xcan. Vaninch ixminta ju lacabarco. Pus lana na tatalhanalh. ");
INSERT INTO teeNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Para ju Jesús ajunich: ―Quit'in. Jantu aquilatalhoniu. ");
INSERT INTO teeNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ju acsnich va lhik'ach ta'amaklhtayanalh ju lacabarco. Pus lana va ts'alhti tacutcha ju barco. Tacha'alh ju anu' lacat'un junta ixta'anta. ");
INSERT INTO teeNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ni tuncunchokopa ju anu' lapanacni ju tatamacontolhcha ixlhilak'antacutni ju atants'in tapastaclich ni va lakatam ixjunita ju barco. Chai ixtalakts'inch ju Jesús ni jantu alact'a'alh ju ix'amamaka'ui acsni ta'alh ju lacabarco. Para va is'akstu'an ju ta'alh. ");
INSERT INTO teeNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Para ju ali' barco tamincha ju lak'achak'an Tiberias. Ta'astacnalh vanin junta ixtakta lak'ailakts'iuch ju Dios ju Jesús junta amavalh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Pus ju lapanacni acsni talakts'ilh ni jantu anch ixvi ju Jesús nin yu'unch ju ix'amamaka'ui pus vachu' tatajulh ju yu'unch ju lacabarco. Taminchokolh ju lak'achak'an Capernaum. Va ixtapuxcajui ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Acsni talhitaju ju Jesús ju lhimak'antacutni ju atants'in tajuni: ―Amamaka'unu' tas vananch ju xach'it'an ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Chai ak'alhtayanalh ju Jesús. Ajunich: ―Slivasalh ju iclajunau. Ju uxijnan quilalhipuxcoyau ni ut'it ju vati chai lhilat'it. Jantiyu' quilalhich'ak'ok'ayau ni lakts'int'at'it ju lhamak'an. ");
INSERT INTO teeNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tun t'ich'alhc'atnant'it va ixlacata ju vaiti ju va tak'alhi. Para ach'alhc'atnant'it ixlacata ju tumpa vaiti ju xt'ak'a ju atsucunti jonk'alhi. Yuchach ju aclaxtakniyau ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Chai quimpai Dios ju xaquixtakni ju quintachaput ni laich acxtaklh ju anu' vaiti. ");
INSERT INTO teeNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Pus tajunich ju Jesús: ―Tijuch ju acnaviyau ni laich acnaviu ju ixlhich'alhcat ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ak'alhtayanalh ju Jesús. Ajunich: ―Yuchach ju ani ju ixlhich'alhcat ju Dios ni aquilalhilaca'au ju quit'in ju quimacaminta ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ju acsnich tajunich: ―Pus tijuch ju lai aquilamalacasuniyau chai laich aclakts'inau chai laich aclapulaca'iniyauch ju uxint'i. Tijuch ju lai navi ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ju quilacpai'an ju mak'anch ixtat'ajun ta'ulh ju anu' ju ixjuncan mana junta aseknic'a. Chunch ju tapasalh tachi ju ts'okcanta junta najun: “Lact'iyan ju amacaminicancha ju vati. Chai ta'ulh”. ");
INSERT INTO teeNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Pus ju Jesús ajunich: ―Slivasalh ju iclajunau. Jantiyu' ju Moisés ju xataxtakniyan ju xavati ju lact'iyan. Va yuchi ju quimpai ju taxtakniyan ju anu' tachi vati ju xaminacha lact'iyan ju xt'ak'a ju stavasalanti atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ju vati ju xt'ak'a ju Dios yuchi ju anu' ju mincha lact'iyan chai axtakni is'atsucunti'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tajunich: ―Qui'amigo pus va tachi aquilaxtakniyauch ju ani vati. ");
INSERT INTO teeNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Pus ju Jesús ajunich: ―Quit'inch ju xavati ju xt'ak'a atsucunti jonk'alhi. Ju minta laquimacni jantuch tavanan cachavana' la'ixtac'atsan. Ju quilhilaca'antach quit'in jantuch tavanan caquicxixchokoya' ju la'is'atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pus anich iclajunau. Mas quilalakts'inauch jantu lac'a'iyat'it. ");
INSERT INTO teeNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tachi chun ju lapanacni ju quixtaknita ju quimpai aquilakminach ju quit'in. Chai ju minta laquimacni jantu tavanan actixcomak'alh. ");
INSERT INTO teeNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yuchi iclhitaxtucha ju lact'iyan ni acnaviniyach ixk'achat ju quimacaminta. Jantiyu' ni acnavilh ju quink'achat qui'akstu. ");
INSERT INTO teeNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yuchach ju ani ju ixk'achat ju quimacaminta. Tachi chun ju lapanacni ju quixtaknita ju yuchi jantu actimak'ats'ank'a xamati'. Para ac'amalok'onichokoya' ju la'ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yuchach ju ani ju ixk'achat ju quimpai. Tachi chun ju quilakts'in ni ists'alh Dios ju quit'in chai quilhilaca'anch pus ca'alina' ju is'atsucunti jonk'alhita. Chai quit'inch ju acmacxtuchokoya' la'ix'aninti ju la'ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ju acsnich ju israelitanin macxcai chivinti talhichivinilh ju Jesús ixlacata tuchi ixnajun acsni tavanan naulh ni yuchach ju xavati ju xamincha lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ixtanajunch: ―Ju ani ja jantiyu' ju Jesús ju ists'alh José. Ju ixpai chai ixnati mispayau ju quijnan'an. Tas laich lhinajun: “Ju quit'in lact'iyan xacminacha”. ");
INSERT INTO teeNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pus ju Jesús ak'alhtayanalh. Ajunich: ―Jantu ana'unt'it macxcai chivinti ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Jantu xamati' lai quilakmin ju quit'in ni jantu cak'ailhimilh laquimacni ju quimpai ju quimacaminta. Chai acmalok'onichokoya' la'ix'aclanti ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Chani tats'ok'ula ju mak'aniya lapanacni ju ixtanajun ju ixchivinti Dios. Tanaulh: “Dios ju camalanik'oya' tachi chun ju lapanacni”. Pus ju quit'in icnajun ni tachi chun ju tak'asmatni ixchivinti ju quimpai chai talani tuchi malani ju yuchi pus cataminach laquimacni. ");
INSERT INTO teeNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Jantu icnomputun ni xamati' lakts'inta ju quimpai. Va quit'in ju iclakts'inta ni la'ixmacni yuchi ju xactaxtuyacha. Quit'inch ju iclakts'inta ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Slivasalh ju iclajunau. Ju quilhilaca'anch quit'in alinch is'atsucunti jonk'alhita lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Quit'inch ju xavati ju xt'ak'a ju atsucunti jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ju mak'aniya milacpai'an mas ta'ulh ju anu' ju mana ixjuncan junta aseknic'a para tanilh. ");
INSERT INTO teeNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Quit'inch ju icxavati ju xacminacha lact'iyan. Chai ni xamati' ca'amaklhtayanana' ju qui'acanit tachi acsni amaklhtayanancan ju tu'u' vaiti pus jantu cati'alh junta maktaik'alhita ju jipi. Yuchi iclhimilh ju quit'in ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Quit'in ju icxavati ju xt'ak'a atsucunti chai xacminacha lact'iyan. Ni xamati' ca'amaklhtayanana' ju qui'acanit tachi acsni amaklhtayanancan ju tu'u' vaiti pus ca'alinanta is'atsucunti jonk'alhita lact'iyan. Chai ju anu' vati ju acxt'ak'a' yuchi ju quilacatuna ju acxt'ak'a'. Yuchi ju laich capu'alina' is'atsucunti'an ju lapanacni ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Pus ju acsni ju israelitanin ixtalaclak'aji ju sia yu'unch. Ixtanajun: ―Tas laich aquintalhixtakniyan ju ix'acanit tachi acsni xtakcan tu'u' vaiti. ");
INSERT INTO teeNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pus ju Jesús ajunich: ―Slivasalh ju iclajunau. Ni jantu amaklht'ayanana'it'it ju qui'acanit tachi acsni amaklhtayanancan tu'u' vaiti chai ni jantu amaklht'ayanana'it'it ju qui'ac'alhni tachi acsni amaklhtayanancan tu'u' xcan pus jantu p'acxanat'it mi'atsucunti'an jonk'alhita ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pus ju amaklhtayanan ju qui'acanit tachi tu'u' vaiti chai ju amaklhtayanan ju qui'ac'alhni tachi ju tu'u' xcan pus alinch ju is'atsucunti jonk'alhita. Chai quit'inch ju acmacxtuchokoya' la'ix'aninti acsni ca'aclayach ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ju ca'amaklhtayanana' ju qui'acanit tachi ju tu'u' vaiti chai ca'amaklhtayanana' ju qui'ac'alhni tachi ju tu'u' xcan pus capu'alinach ju istavasalanti is'atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pus ju ca'amaklhtayanana' ju qui'acanit tachi ju tu'u' vaiti chai ca'amaklhtayanana' ju qui'ac'alhni tachi ju tu'u' xcan pus t'ajunch ju laquimacni. Chai ju quit'in la'ix'alhunut yuchi ju ict'ajunch. ");
INSERT INTO teeNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Tachi ju quimpai ju lak'ajunta ni quimacamilh chai yuchi ju quixtaknita ju qui'atsucunti pus vanach va ixt'achunch ju ani. Ju aqui'amaklhtayanana' tachi ju tu'u' vaiti pus pu'amaklhtayanan ju is'atsucunti ju jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Quit'in ju icxavati ju xacmincha lact'iyan. Jantu chun tachi ju anu' ju ta'ulh ju mak'aniya milacpai'an. Ju yu'unch mas ta'ulh ju anu' vati ju mana ixjuncan jantu anch ju tapulhitaju is'atsucunti'an ju jonk'alhita tus lact'iyan. Para ju aqui'amaklhtayanana' tachi ju amaklhtayanancan tu'u' vaiti pus ca'alina' is'atsucunti jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ju Jesús noncha ju ani taxtokni laxapujitat lak'achak'an Capernaum acsni ixt'ajun amalanini' ixlacata Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Pus ju ali'in ix'amamaka'ui ju Jesús acsni tak'asmatlh ju ani chivinti tanaulh: ―Na ts'inq'ui ju ani chivinti. Tis chavaich ju laich camuctaxtu ju chunch chivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pus ju Jesús ni c'atsa ju la'ix'alhunut ni jantu k'ox ixtalhiulai ju ani chivinti ju ix'amamaka'ui pus ajunich: ―Ja jantu lai ch'ixat'it ju ani chivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","T'as anona'it'it ni aquilalakts'inau ni acta'akst'achokoya' junta xacvilhcha p'ulhnan. ");
INSERT INTO teeNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Pus ju Spiritu Santu yuchi ju xt'ak'a ju atsucunti jonk'alhita. Ju tu'u' ixlacata ju quilacatuna'an jantu lai xt'ak'a ju atsucunti jonk'alhi tus lact'iyan. Ju chivinti ju iclamavasalaniyau pus ixlacata ju mi'alhunut'an junita chai yuchach ju xt'ak'a ju atsucunti jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Para alin ju milhi'uxijnan'an ju jantu talaca'i. Pus ju Jesús isc'atsai tus la'ixputai'ulacan tichi chavaich ju jantu catalaca'iya' chai tichi chavaich ju camak'axtaknana'. ");
INSERT INTO teeNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Pus najunch: ―Yuchi iclalhijunau ni jantu lai xamati' quilakmin ni jantu xtaknita ju chun atalacpast'ac'at ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ju acsnich na lhu ju ix'amamaka'ui ju Jesús jantu tach'ak'ok'ak'alhiputulh. Lana tamacoyaulh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ju acsnich ju Jesús alacjunich ju ixpumacaut'ui'an: ―Ja vachu' p'imp'ut'unat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ak'alhtayanalh ju Pitalu' ju ixjuncan Simón. Junich: ―Qui'ucxtin tis chavaich ju lai aclak'anauch ni uxint'i ju p'acxant'a ju chivinti ju xt'ak'a ju atsucunti jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ju quijnan iclaca'iyauch chai iclamispayauch ni uxint'ich ju Cristo'at. Ists'alh'at Dios ju lak'ajunta. ");
INSERT INTO teeNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Pus ju Jesús alack'alhtailh: ―Ja jantu quit'in ju iclalhca'ulatau ju mimpumacaut'ui'an. Chai pumatam ju milhi'uxijnan'an valhch ixlapanac ju lhacaticuru. ");
INSERT INTO teeNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yuchach ju ixlhichivincan ju Judas ists'alh ju Simón Iscariote ni yuchach ju camak'axtaknana'. Yuchi ju pumatam ju ixlhipumacaut'ui'an ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Acsni tapasalhch ju ani taxtokni pus ju Jesús lac'antsuculhch junta lacvi lak'achak'anixni ju laxa'estado Galilea. Jantu ix'amputun amalanini' ju laxa'estado Judea ni va ixtamakniputun ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chai vaninch ixjunita ju ixc'atan'an ju israelitanin acsni ixtat'ajun va la'ixpac'ats'a'an. ");
INSERT INTO teeNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Pus ju is'ap'isek'en ju Jesús chanich tajuni: ―At'axt'uch ju ani. Ap'inchich ju laxa'estado Judea. Ju chunch ni laich catalakts'inanta ju mi'amamaka'unti amachak'an anch ju tuch'i laich navi. ");
INSERT INTO teeNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ju tam lapanac ni jumputunch tachi tam xak'ai pus jantu va catatank'anu. Pus ni laich navi ju ani taxtokni amalac'asunik'och tachi chun ju lak'achak'anixni. ");
INSERT INTO teeNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nin yu'unch ju is'ap'isek'en jantu ixtalhilaca'an ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Pus ajunich ju Jesús: ―Tuca' chin ju avilhchan ju iclhcanicanta. Para ju uxijnan va tuchi horach lai naviyat'it ju p'ast'ac'at'it. ");
INSERT INTO teeNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ju lapanacni ju ani lacamunutpa' jantu lai talhits'i'inan ju uxijnan. Para ju quit'in yuchi jantu quintalhilakts'imputun ni ic'ajuni ni na macxcai ju tanavi. ");
INSERT INTO teeNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ju uxijnan ap'inchit'itch junta lai c'atan. Ju quit'in tuca' lai acti'alh ju anch ni jantuca' chin ju avilhchan ju iclhcanicanta. ");
INSERT INTO teeNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Acsni ajunilh ju ani chivinti pus tavilhca' ju Jesús ju xa'estado Galilea. ");
INSERT INTO teeNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Acsni ta'alh ju is'ap'isek'en pus astan alh ju Jesús junta lai c'atan. Jantu lacatalhavat ju alh. Tachi ju va jantu ixlacasq'uin ni xamati' cac'atsa. ");
INSERT INTO teeNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pus ju israelitanin ixtapuxcajuich ju Jesús junta lai c'atan. Ixtanajunch: ―Ta xa'anch nu' ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ju ixlacata ju Jesús na lhu ix'alin ju chivinti ju va sek ixtanajun ju lapanacni. Ju ali'in ixtanajunch ni na k'ox lapanac ju yuchi. Ju ali'in ixtanajun: ―Jantu vasalh k'ox lapanac. Va a'okxchok'oi ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pus ju anuch lapanacni ni va ixtatalhonich ju xa'ucxtinin ju israelitanin pus va sek ixtalhichivinin ixlacata ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Acsni cha'alh paitat c'atan ju Jesús alh ju la'ixpujitat'an ju ist'a'israelitanin chai tsuculh amalanini'. ");
INSERT INTO teeNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Pus va ixtalhamak'aninin ju ist'a'israelitanin. Ixtanajunch: ―Ju ani tas lhimispaich ju atalaninti ni jantu xamati' xamalani. ");
INSERT INTO teeNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Chai ak'alhtayanalh ju Jesús. Alacjuni: ―Ju tuchi ic'amalaninin jantu qui'anu'. Ix'anu' ju xaquimacamin. ");
INSERT INTO teeNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ni xamati' naviputun ixk'achat ju Dios pus cac'atsayach ta anchach ju xaminacha ju ani atalaninti. U Dios ju xaquixtakni u va laqui'akstu ju icnajun. ");
INSERT INTO teeNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ju va la'is'akstu najun ju tu'u' va lacasq'uin ni catanaulh ju lapanacni ni xak'ai ju yuchi. Para ju lacasq'uin ni catanaulh ju lapanacni ni yuchi ju xak'ai ju tichi macaminta pus yuchi ju najun ju stavasalanti. Matich ju a'okxchok'onti la'ixmacni ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Vasalh ni taxtaknitan ju lhamap'aksin ju Moisés. Para nin tachi pumatam ju milhi'uxijnan ju lai stunin camuctaxtuk'o ju anu' lhamap'aksin. Tajuch ni va quilamakniputunauch ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Chai ta'ak'alhtayanalh ju lapanacni. Tajunich: ―Va p'acxant'a lhacaticuru. Tis chavaich ju makniputunan. ");
INSERT INTO teeNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pus ju Jesús ak'alhtailh: ―Va lakatam lhamak'an xacnavi. Chai minchux'an va lhamak'anininat'it. ");
INSERT INTO teeNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Slivasalh ni Moisés ju xtakta ju lhamap'aksin ixlacata ju ach'uc'unti. Chai ju avilhchan pa'astacni vana acsni ju ch'uc'uniyat'it ix'axt'ak'a ju tam ts'alh. Jantiyu' ju Moisés ju p'ulhnan naulh ni cach'uc'ucalh ju tam ts'alh. Yu'unch ju mak'aniya lapanacni ju p'ulhnanch tanavilh ju chunch. ");
INSERT INTO teeNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mas avilhchan pa'astacni ch'uc'ucanch ju tam ts'alh va ixlacata ni acsni ju uctaxtui tachi ju lhca'ulai ju la'ixlhamap'aksin ju Moisés. Ni naviyat'it chunch tajuch ni va quilalhixcayauch ni palaich xacnavi ju anu' lapanac ju acs avilhchan pa'astacni. ");
INSERT INTO teeNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Jantu a'ulanit'it ixtalak'alhin tam xamati' ni jantu p'ulhnan k'ox c'ats'ayat'it tuchi navita. ");
INSERT INTO teeNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ju ali'in amachak'an Jerusalén ixtanajunch: ―Ja jantiyu' ju ani ju puxcocan ju tamakniputun. ");
INSERT INTO teeNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ju chavai ni t'ompalai chivini' la'ix'ucxlacapu'an ju lapanacni. Chai ju yu'unch ni jantu tu'u' tajumpalai. Ju ucxtinin ja tac'atsai nu' ni yuchi ju Cristo. ");
INSERT INTO teeNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Para ju ani mispayauch tas amachak'ach. Acsni camina' ju Cristo jantu xamati' catimispa ta anchach ju caminanta. ");
INSERT INTO teeNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Pus ju Jesús p'as chivinilh acsni ixt'ajun amalanini' la'ixpujitat'an ju ist'a'israelitanin. Ix'ajunich: ―Quilamispayau ju quit'in. Chai c'ats'ayat'it ta anchach ju icmintacha. Para jantu va laqui'akstu icminta. Ju quimacaminta yuchi ju najun ju stavasalanti chai ju yuchi jantu misp'ayat'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ju quit'in icmispai ju yuchi ni anch ju xacminacha. Chai yuchi ju xaquimacamin. ");
INSERT INTO teeNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ju acsnich lana tapastaclich ixch'apaca. Para jantu xamati' lai ch'apalh ni tuca' ixchin ju ix'avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na lhu lapanacni talhilaca'alh ju yuchi. Ixtanajunch: ―Ju Cristo acsni camina' ja palai lhu ixpulaca'ican canaviya'. Ja palai jantu ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ju fariseonin ixtak'asmat'ach ni na ixtalhilacchivininch ju Jesús ju lapanacni. Pus ju xalack'ajin palijni chai ju fariseonin tamalakachalh ju pulasiyajni ni cata'alh ch'apanin ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ju Jesús naulh: ―Va pants'iquis ju ictilat'a'ucxunt'onau. Ju astan aclak'anchokoyach ju quimalakachatachilh. ");
INSERT INTO teeNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ju uxijnan aquilapuxcoyau. Para jantu lai aquilalhitajuyau. Junta ac'ana' ju uxijnan jantu lai aquintilach'ak'ok'au. ");
INSERT INTO teeNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Pus ju ist'a'israelitanin tanaulh va la'is'akstu'an: ―Tas anchach ju cacha'ana' ju yuchi junta jantuch lai calhitajuyau. Ja va calak'anach ju ist'a'israelitanin ju amakpitsicanta la'ixt'un'an ju griegonin. Ja va ca'ana' amalanini' ju griegonin. ");
INSERT INTO teeNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Tijuch ju nomputun ju ixchivinti ni najun: “Ju uxijnan aquilapuxcoyau para jantu aquilalhitajuyau”. Ni va nompalai. Chai ni najun: “Junta ac'ana' ju uxijnan jantu lai aquintilach'ak'ok'au”. ");
INSERT INTO teeNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Acsni ixlak'oputunch ju c'atan chai acsni na k'ai c'atan ixjunita pus ju Jesús taya chai na p'as chivinilh. Naulh: ―Ni alin xamati' ju quicxixa la'ix'alhunut chach quilakmilh ju quit'in. Chach k'otlh ju xcan ju icxt'ak'a. ");
INSERT INTO teeNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ju quilhilaca'anta quit'in pus cataxtuya' ju la'ix'alhunut tachi k'ai xcan ju lak'ajunta. Tachi ju najunch laca'ats'oknut. ");
INSERT INTO teeNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ju Jesús ixlhichivinin ju Spiritu Santu. Yuchi ju cata'amaklhtayananach ju talhilaca'anta ju Jesús. Tuca' lai ixmin ju Spiritu Santu ni tuca' ix'anchokota ju lact'iyan ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Acsni tak'asmatlh ju ani chivinti pus ju ali'in la'ixtalhavat lapanacni ixtanajunch: ―Slivasalh ni yuchi ju ani ju lapanac ju najun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ju ali'in ixtanajun: ―Ju ani yuchi ju Cristo ju noncan camalakachatachilh Dios. Ju ali'in ixtanajun: ―Para ja laxa'estado Galilea ju caminanta ju Cristo. ");
INSERT INTO teeNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ja jantu najun laca'ats'oknut ni mak'aniya is'ask'at'a David cajuna' ju Cristo. Chai anch catsucuyanta ju lak'achak'an Belén la'ixt'un ju mak'aniya quimpai'an David. ");
INSERT INTO teeNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Pus chunchach quilhmact'ui va ixtalhavat lapanacni va ixlacata ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ju ali'in ixtach'apaputunch. Para jantu xamati' lai ch'apalh. ");
INSERT INTO teeNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Pus ju pulasiyajni ta'anchokolh juninin ju xalack'ajin palijni chai ju fariseonin. Chai ju yu'unch ta'asacminilh: ―Tajuch ni jantu xalhit'anat'it. ");
INSERT INTO teeNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pus ju pulasiyajni ta'ak'alhtayanalh: ―Jantu xamati' ju chunch chivinin tachi ju ani lapanac. ");
INSERT INTO teeNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ju acsnich ju fariseonin ta'ak'alhtayanalh: ―Ja vachu' va okxch'ok'oc'ant'at'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ju sia yu'unch ju xalack'ajin ja xamati' c'u'u laca'ita. U sia yu'unch ju fariseonin ja xamati' c'u'u ju laca'ita. ");
INSERT INTO teeNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Para ju ani tontojni lapanacni ju jantu tamispai ju ixlhamap'aksin ju Moisés catamak'alhk'ajnana'. ");
INSERT INTO teeNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pus ju Nicodemo ju quilalh ts'is junta ixvi ju Jesús vachu' makfariseo ixjunita. Ju yuchi ajunich: ");
INSERT INTO teeNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Ja lhijun ju quilhamap'aksin'an ni ac'ulanilh ju ixtalak'alhin tam xamati' ju jantuca' tu'u' k'asmatnican chai ju jantuca' c'atsanican ni ca'alilh ju ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ta'ak'alhtayanalh. Tajuni ju Nicodemo: ―Ja vachu'as amachaka'at Galilea. Alac'avanch. Alakts'ina' ni jantu xamati' t'ajun k'ostayana' ju laxa'estado Galilea ju najun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Pus tataxtulh ju lacapu'ucxtin chai pumatamin ta'alhch ju la'ixlacchaka'an. ");
INSERT INTO teeNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ju Jesús alh ju akstijun junta ixmacha ju lacapu'olivos. ");
INSERT INTO teeNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chai acsni tuncunchokopa vats'isin anchokolh ju Jesús ju la'ixpujitat'an ju ist'a'israelitanin. Chai chux ju lapanacni talak'alh ju Jesús. Chai ju yuchi tavi chai tsuculh amalanini'. ");
INSERT INTO teeNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ju acsnich ju ixtalhatalanininta ju ixlhamap'aksin'an ju ist'a'israelitanin chaich ju fariseonin talhiminilh pumatam chako'ulh ju lhitajucalh ni ixt'a'alactu'unun pumatam jok'at. Ta'ulalh la'ixlacaitat junta ixvi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tajunich: ―Amamaka'unu' ju ani chako'ulh lhitajucalh ni ixt'ajun t'a'alactu'unu' pumatam jok'at. ");
INSERT INTO teeNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Pus ju Moisés ju la'ixlhamap'aksin quintajunan ni aclacat'alhmauch ju chunchach talai. Para ju uxint'i t'as na'unch. ");
INSERT INTO teeNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ju tapusacmi chunch va ixtalakts'intanuputunch ju Jesús. Ts'a ma laich ixtalhitajunilh tu'u' ju laich catalhichivimak'alh. Para ju Jesús lana tak'entalh. Tsuculh ats'oknu' la'ixk'elilimaca' ju lacat'un. ");
INSERT INTO teeNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Para ni va k'asi k'asi tasacmich pus tak'oxitolhchokolh chai ajunich: ―Pus ni alin xamati' milhi'uxijnan ju jantu ca'alactu'unulh yuchach ju p'ulhnanch ca'alacat'alhmanalh. ");
INSERT INTO teeNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Aktam tak'entachokopa chai tsucuchokopa ats'oknu' ju lacat'un la'ixk'elilimaca'. ");
INSERT INTO teeNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Acsni tak'asmatlh ju naulh ju Jesús pus ju achivimak'anin taxcanilh ju ix'alhunut'an. Pumatamin pumatamin tatsuculh taxtunin. P'ulhnan tataxtulh ju xapapanin. Chai astan ta'alh ju paitat lapanacni. Pus va is'akstuch tavilh ju Jesús. T'atamacaulh ju chako'ulh ju ixya la'ixlacaitat junta ixvi ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Acsni tak'oxitolhchokolh ju Jesús jantu xamati' lakts'ilh ju achivimak'anin. Va is'akstu ju ixya ju chako'ulh. Pus junich: ―Chako'ulh tas xata'anch ju ixtachivimak'anan. Ja jantu xamati' xa'ulaniyan ju mintalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Pus ju chako'ulh ak'alhtayanalh. Naulh: ―Jantu xamati' ji qui'ucxtin. Pus ju Jesús junich: ―Nin quit'in jantu acti'ulanin ju mintalak'alhin. A'inchich chai jantuch ali' alact'u'unch'ok'o. ");
INSERT INTO teeNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ju Jesús aktam chivinchokopa. Chai ajunich ju lapanacni: ―Quit'in icjunita tachi ju tu'u' maclhcu ni icmalacpucujui la'ixtac'atsan'an ju lapanacni. Ju aquinch'ak'ok'aya' jantu ts'is cajuna' ixtac'atsan. Acmalacpucujuniya' ju ixtac'atsan ni laich ca'alilh ju is'atsucunti jonk'alhita. ");
INSERT INTO teeNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pus ju acsnich ju fariseonin tajunich: ―Va laminchivinti mi'akstu na'un ni xak'ai'at. Ju minchivinti jantu slivasalh. ");
INSERT INTO teeNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ak'alhtayanalh ju Jesús. Ajunich: ―Mas ca va laquinchivinti ju icnajun ni icxak'ai para ju quinchivinti stavasalanti ni icc'atsai ta anchach ju icmintacha chai ta anchach ju ac'anchokoya'. Para ju uxijnan jantu c'ats'ayat'it ta anchach ju icmintacha nin ta anchach ju ac'anchokoya'. ");
INSERT INTO teeNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ju uxijnan quila'ulaniyau ju quintalak'alhin tachi ju talai ju va lhilapanac. Ju quit'in jantu xamati' ic'ulani ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Chai mas ic'ulani ju ixtalak'alhin apumatam para stavasalanti ju tuchi acnona' ni jantu va qui'akstu quit'in ju ic'ulai talak'alhin. Yuchi ju ict'amuc'ai talak'alhin ju quimpai ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ju lamilhamap'aksin'an najun acsni va lakatamch chivinti catanaulh ixpumat'ui'an lapanacni pus soknic'ach ju tuchi tanajun. ");
INSERT INTO teeNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Pus quit'in qui'akstu icnajun tichi chavaich ju quit'in. Chai ju quimpai ju quimacaminta vachu' najun tichi chavaich ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Tajunich chavai: ―Tas anchach ju ya ju mimpai. Ak'alhtayanalh ju Jesús: ―Nin quit'in jantu quilamispayau. Ja va a ti quimpaich lai amisp'at'it. Pus ni xaquilamispau ju quit'in pus vachuch ju quimpai ca'ismisp'at'it. ");
INSERT INTO teeNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ju ani chivinti ju Jesús naulh acsni ixt'ajun amalanini' ju la'ixlacpujitat'an ju ist'a'israelitanin junta ixtaxt'ak'a ixtumin'an. Para jantu xamati' lai lacach'apalh ju acsnich ni jantuca' ixchin ju ix'avilhchan. ");
INSERT INTO teeNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ju Jesús ajunchokopa: ―Ju quit'in ac'anach. Chai aquilapuxcoyauch. Para junta ac'ana' ju uxijnan jantu lai at'ip'it'it. Ju uxijnan acsni aniya'it'it jantu mak'ot'inic'ant'at'it ju mi'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ju acsnich talaclajunich ju ist'a'israelitanin: ―Ja va is'akstu nu' ju maknichokoputuncan ni najunch ni jantu lai ca'anau junta ca'ana'. ");
INSERT INTO teeNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ju Jesús ajunich: ―Ju uxijnan xanavin unt'at'it ju ani lacamunutpa'. Ju quit'in lact'iyan icmintacha. Ju uxijnan va amachak'an lacamunutpa' unt'at'it. Ju quit'in jantu ic'amachaka' ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Pus iclajunauch ni aniya'it'it ju lami'alactu'unti'an. Pus ni jantu lac'a'iyat'it ni chun icjunita tachi ju iclajunau pus aniya'it'it ju lami'alactu'unti'an. ");
INSERT INTO teeNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Tajunich: ―Tis chavaich'at ju uxint'i. Pus ju acsnich ajunich ju Jesús: ―Acsni ictai'ula ju qui'amalaninti va tachi iclajuntauch tichi chavaich ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na lhu taxtokni ju iclhichivimputun ju milacata'an chai lai acla'ulaniyau ju mintalak'alhin'an. Para ju quimalakachatachilh yuchi ju najun ju stavasalanti. Chai tuchi ju ick'asmatnita la'ixmacni pus yuchach ju icnajun ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Para ju yu'unch jantu tamachakxanilh ni ixpai Dios ju ixlhichivinin. ");
INSERT INTO teeNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ajunich chavai ju Jesús: ―Acsni tavanan aquilaxtucmuc'ayau talaclhman ju quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani pus acsnich ju amach'akxaya'it'it tichi chavaich ju quit'in. Vachu' amach'akxaya'it'it ni jantu tu'u' icnavi ju va laqui'akstu. Yuchi ju icchivinin tachi ju quimasunitach ju quimpai Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Chai ju quimacaminta quint'a'alhtanan. Chai ni akts'iya icnavich tuchi ju k'oxich lhiulai ju yuchi pus yuchi jantu tavanan quilhimacajun. ");
INSERT INTO teeNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Acsni naulh ju chunch ju Jesús pus na lhu talhilaca'alh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ju Jesús ajunich ju anuch ist'a'israelitanin ju ixtalhilaca'antach ju yuchi: ―Pus ju uxijnan ni va tachi alac'a'it'it ju quinchivinti pus slivasalh ni qui'amamaka'unti a'una'it'it. ");
INSERT INTO teeNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Chai amisp'aya'it'itch ju istavasalanti. Chai acsni amisp'aya'it'it ju istavasalanti pus amaxt'uc'ana'it'it ju mimpuxalapanacni'an. ");
INSERT INTO teeNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ju acsni ta'ak'alhtayanalhch ju ali'in lapanacni: ―Ju quijnan mak'aniya ix'apapanatnich Abraham icjuntau. Chai jantu tavanan ju va xalapanacni quintanavitan xamati'. Tajuch ni va na'unch ju uxint'i ni acmaxtucanau ju quimpuxalapanacni quinc'an. ");
INSERT INTO teeNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ju Jesús ak'alhtailh: ―Slivasalh ju iclajunau. Tachi chun ju tanavi alactu'unti pus yuchi ju ix'ucxtin'an tanavita ju alactu'unti. ");
INSERT INTO teeNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ju va xalapanac jantu lai tsucuk'alhi ju la'ixchaka' ju tam ix'ucxtin. Para ju akts'iya ists'alh ju amachaka' catsucuk'alhiya' anch. ");
INSERT INTO teeNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Pus ju quit'in ju ists'alh Dios icjunita ni aclamaxtuyau ju lamimpuxalapanacni'an pus slivasalhch jantu va xalapanacni a'una'it'it. ");
INSERT INTO teeNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Icc'atsai ni is'ask'at'an ju mak'aniya Abraham unt'at'it. Para ni va quilamakniputumpalau ni jantu lac'a'ip'ut'unat'it ju quinchivinti ju iclajuntau. ");
INSERT INTO teeNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ju quit'in yuchi ju icnajun ju iclakts'intach la'ixmacni ju quimpai. Tachi ju uxijnan ni naviyat'itch ju k'asmat'at'it la'ixmacni ju mimpai'an. ");
INSERT INTO teeNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Chai ju lapanacni ta'ak'alhtayanalh. Tajunich: ―Pus ju mak'aniya quimpai quinc'an yuchi ju Abraham. Chai ajunich ju Jesús: ―Ni vasalh ix'apapanatnich ca'ix'unt'it ju Abraham ju mak'anch ixt'ajun pus ixnavit'it tachi ju navilh ju Abraham. ");
INSERT INTO teeNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Para ju chavai ni va quilamakniputumpalau. Ju quit'in ni va iclajumpalau ju stavasalanti ju ick'asmat'ach la'ixmacni ju quimpai Dios. Ju Abraham jantu chunch ixnavi. ");
INSERT INTO teeNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ju uxijnan va ixlhich'alhcat ju mimpai'an ju naviyat'it. Pus tajunich: ―Jantu akchunan icjuntau. Va pumatam ju quimpai quinc'an. Yuchi ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Pus ju Jesús ajunich: ―Ni mimpai'an cava ju Dios ca xaquilamapainiu ju quit'in ni la'ixmacni Dios ju icminta ju ani. Chai mas icminta ju ani jantu va laqui'akstu ju icminta. Is'akstu ju Dios ju xaquimacaminchokoi. ");
INSERT INTO teeNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Tajuch ni jantu lai mach'akxayat'it ju tuchi iclajunau. Ca ixlhiyuchi ni jantu quilak'asmatniputunau ju tuchi iclajunau. ");
INSERT INTO teeNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ju mimpai'an ju uxijnan yuchi ju lhacaticuru. Chai va ixk'achat yuchi ju navip'ut'unat'it. Ju yuchi amaknini' junita tus la'ixputai'ulacan ju lacamunutpa'. Jantu tavanan najunta ju stavasalanti ni lana jantu mispai tuchi ixtalakxtuch ju stavasalanti. Acsni najun ju ta'aklhtamat va najun tuchi alin ju la'ix'alhunut ni va ta'aklhtaman junita. Chai xapai ju ta'aklhtamat junita. ");
INSERT INTO teeNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yuchi jantu quilalhilaca'iniyau ju quit'in ni icnajun ju istavasalanti. ");
INSERT INTO teeNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tis chavaich ju milhi'uxijnan ju lai aqui'ulanilh ju quintalak'alhin. Ni icnajun ju stavasalanti pus tajuch ni jantu quilalaca'iniyau ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ju is'ask'at'a Dios k'asmatni ju ixchivinti. Ju uxijnan jantu k'asmatp'ut'unat'it ni jantu is'ask'at'an Dios unt'at'it. ");
INSERT INTO teeNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ju acsnich ju ist'a'israelitanin ta'ak'alhtayanalh. Tajuni ju Jesús: ―Ja jantu c'u'u slivasalh tachi ju iclajunau ni va amachaka'at Samaria chai va p'acxant'a ju lhacaticuru. ");
INSERT INTO teeNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Chai ak'alhtayanalh ju Jesús. Ajuni ju lapanacni: ―Ju quit'in jantu icpacxanta ju lhacaticuru. Alai va iclajumputunau ni yuchi ju xak'ai ju quimpai Dios. Chai ju uxijnan jantu tu'u' quilalhiulayau. ");
INSERT INTO teeNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Jantu va qui'akstu ju iclacasq'uin ni catanaulh ju lapanacni ni icxak'ai. Alin tichi chavaich ju lacasq'uin ni catanaulh ju lapanacni ni icxak'ai. Chai yuchi ju alakts'intanunu'. ");
INSERT INTO teeNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Slivasalh ju iclajunau. Ju camuctaxtuya' ju quinchivinti jantu catini. ");
INSERT INTO teeNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ju acsnich ju ist'a'israelitanin tajunich: ―Ju chavai icc'atsayauch ni va p'acxant'a ju lhacaticuru. Ju Abraham ni nipa. Chai ju lapanacni ju ixtanajun ju ixchivinti Dios vachu' tani. Chai ju uxint'i ni va nomp'alai ni jantu catini ju camuctaxtuya' ju minchivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ju uxint'i ja palai xak'ai'at. Ja palai jantu ju mak'aniya quimpai quinc'an Abraham. Ju yuchi ni nipa. Chai vachu' tanita ju lapanacni ju ixtanajunch ixchivinti Dios. Pus ju uxint'i tis chavaich'at navich'ok'oc'an mi'akstu. ");
INSERT INTO teeNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Chai ak'alhtayanalh ju Jesús. Ajunich ju lapanacni: ―Ni va qui'akstu cava ju iclacasq'uin ni catanaulh ju lapanacni ni icxak'ai pus jantu catilhitapalalh mas chunch catanaulh. Yuchi ju quimpai ju najun ni icxak'ai. Chai ju uxijnan ni va nomp'alat'it ni yuchi ju miDios'an. ");
INSERT INTO teeNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ju uxijnan jantu misp'ayat'it ju yuchi. Para ju quit'in icmispai ju yuchi. Ni acnaulh ni jantu icmispai ju yuchi pus vachu' va ixnona' ta'aklhtamat acva tachi ju uxijnan. Para ju quit'in icmispai ju yuchi. Chai icmuctaxtuich tuchi najuntach ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ju mak'aniya mimpai'an Abraham lhik'achalh ni ixlaca'ita ni calakts'ina' ni acmina'. Chai lakts'ilh. Chai lhik'achalh. ");
INSERT INTO teeNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Pus ju acsnich ju ist'a'israelitanin tajunich: ―Ju uxint'i jantuca' p'acxant'a cincuenta c'ata. T'as laich lhina'un ni lakts'inch ju Abraham. ");
INSERT INTO teeNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ajunich chavai ju lapanacni ju Jesús: ―Slivasalh ju iclajunau. Acsni tuca' istsucui ju Abraham xact'ajunch. ");
INSERT INTO teeNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Chai tasaclich chavai ju chiux ju ixtaput'alhputunch. Para ju Jesús lana apak'osnulh ju lapanacni chai taxtulh ju la'ixpujitat'an ju ist'a'israelitanin. La'ixlacaitat ixtalhavat lapanacni ju putapasatilalh acsni tavanan alh. ");
INSERT INTO teeNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ju Jesús acsni tapasalh ju lacati lakts'ilh pumatam lapanac. Alak'ach'ix ixjunita tus acsni tsuculh. ");
INSERT INTO teeNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Pus ju ix'amamaka'ui tasacmilh ju Jesús. Tajunich: ―Amamaka'unu' tis chavaich ju alactu'unulh ni laich xalak'ajun ju va alak'ach'ix. Ja yuchi is'akstu u ixpai u ixnati. ");
INSERT INTO teeNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Chai ak'alhtayanalh ju Jesús: ―Jantu alak'ach'ix xalak'ajun va ixlaca'atalh ni ca'alactu'unulh ju yuchi nin ixpai nin ixnati. Va alak'ach'ix xalak'ajun ni laich caputalacasuya' ju ixlhich'alhcat ju Dios la'is'atsucunti ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tasq'uini ni acnavi ju ixlhich'alhcat ju quimacaminta ni ictit'ajunca' tachi acsni vilhca' ju avilhchan. Cachina' avilhchan acsni acniya'. Ju acsnich tachi ju na va ts'ista cajuna' acsni jantu lai xamati' ch'alhcatnan. ");
INSERT INTO teeNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ni ictit'ajunca' ju ani lacamunutpa' pus tachi maclhcu icjunita ni icmapulhcui la'ixtac'atsan'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ju Jesús acsni naulh ju chunch pus akchujlh ju lacat'un. Navilh ju pulhk'om la'ixchu'ut. Pus lhquilin lacpumuc'alh ju la'ixlakchulh ju anu' alak'ach'ix. ");
INSERT INTO teeNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Junich: ―A'inchich lakp'uch'ak'ana' laxapos ju Siloé. Ju ixtapaka'ut ju anu' pos nomputun Malakachacanta. Pus ju anu' lapanac alh lakpuch'ak'ana'. Chai acsni tasp'itcha lai ix'alac'avanan. ");
INSERT INTO teeNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ju ixt'atolhnin chai ju ali'inch lapanacni akts'iya ixtalakts'intach ni va isq'uin tumin ju anu' lapanac. Pus acsni c'uch'ucalh tanaulich: ―Ja jantiyu' ju ani ju ixtolai lacati chai va isq'uin tumin. ");
INSERT INTO teeNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ju ali'in lapanacni ixtanajunch ni yuchi. Ju ali'in ixtanajun: ―Jantiyu'. Va ixt'achunch. Para ju alak'ach'ix ixjunita ixmavasalai ni yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tajunich chavai: ―Pus t'as xalhi'alac'avananch. ");
INSERT INTO teeNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ju alak'ach'ix ixjunita ak'alhtayanalh. Ajunich: ―Yuchi ju anu' jok'at ju juncan Jesús navilh pulhk'om. Quilacpumuc'alh laquilakchulh chai quijunilh: “Ap'inchich lakp'uch'ak'ana' ju lacaSiloé”. Pus ic'alh. Iclakpuch'ak'alh. Chai ic'alac'avanalh. ");
INSERT INTO teeNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Chai ju alak'ach'ix ixjunita talhisacmichokopa ju Jesús. Tajunich: ―Tas anchach ju xa'an ju anu' lapanac. Chai ju alak'ach'ix ixjunita lhak'alhtayanalh. Ajunich: ―Jantu icc'atsai. ");
INSERT INTO teeNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Chai alhi'anicalh ju fariseonin ju anu' alak'ach'ix ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pus avilhchan pa'astacni ixjunita acsni tavanan navilh ju pulhk'om ju Jesús chai acsni amalac'avanilh ju alak'ach'ix. ");
INSERT INTO teeNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Pus ju fariseonin aktam tasacmichokopa ju alak'ach'ix ixjunita. Tajunich: ―T'as xalhi'alac'avananch. Ju anu' alak'ach'ix ixjunita chani ajuni: ―Va quimuc'anilh pulhk'om ju laquilakchulh chai iclakpuch'ak'alh. Chai ic'alac'avanalhch. ");
INSERT INTO teeNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Pus ju acsnich ju ali'in fariseonin tanaulh: ―Ju ani lapanac jantu la'ixmacni Dios ju xaminacha ni jantu maklaca'ani ju avilhchan pa'astacni. Ju ali'in ixtanajunch: ―Para tas calhinavilhch ju ani lhamak'an ju va alactu'unu lapanac. Pus ju fariseonin jantu va lakatam ixtanavi ixchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Tasacmichokopa aktam ju anu' alak'ach'ix ixjunita. Tajunich: ―Ju uxint'i tis chavaich lhiulai ju xalakpulak'oxiyan lamilakchulh. Pus ju anu' alak'ach'ix ixjunita naulh: ―Yuchi ju lapanac ju najun ixchivinti Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pus ju xalack'ajin israelitanin jantuch ixtalaca'i ni yuchi cava ju alak'ach'ix ixjunita. Chai jantu ixtalaca'i ni va calak'oxinicalh ju ixlakchulh. Tus acsni ju talaca'i acsni at'asanicalh ju ixpai ixnati ju anu' alak'ach'ix ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Chai asacmicalh ju xapai xanati. Ajuncanch: ―Ju ani ja yuchi ju mints'alh'an ju nonat'it ni va alak'ach'ix ixjunita acsni lak'aulh. Pus ju chavai tas xalhi'alac'avananch. ");
INSERT INTO teeNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ta'ak'alhtayanalh ju ixpai chai ixnati. Tanaulh: ―Icc'atsayau ni yuchi ju ani ju quints'alh quinc'an. Yuchi ju alak'ach'ix ixjunita acsni tavanan tsuculh. ");
INSERT INTO teeNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Para jantu icc'atsayau ta xalhi'alac'avananch ju chavai. Chai jantu icc'atsayau tichi chavaich ju xalakpulak'oxi. Pus ju yuchi k'aich. Yuchi ju asacmit'itch. Is'akstuch canona'. ");
INSERT INTO teeNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Chunchach ju talhak'alhtayanalh ju ixpai chai ixnati ni va ixtatalhonich ju xalack'ajin ist'a'israelitanin. Ju yu'unch ixtanajuntach ni xamati' canona' ni yuchi ju Cristo ju Jesús ju anu' noncanch camalakachatachilh ju Dios pus jantu calacasq'uinicana' ni lai catanu ju la'ixpujitat'an ju israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Pus yuchach talhinaulh chunch ju ixpai chai ixnati acsni tavanan tanaulh ni k'aich ju ists'alh'an. Yuchach ju casacmicalh. ");
INSERT INTO teeNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Pus lhinonchokocalh ist'asanica ju anu' lapanac ju va alak'ach'ix ixjunita. Tajunich: ―Anauch ni va yuchi ju xak'ai ju Dios. Ju quijnan icc'atsayau ni va alactu'unu' ju anu' lapanac ju xalakpulak'oxiyan. ");
INSERT INTO teeNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ju acsnich ju anu' alak'ach'ix ixjunita ak'alhtayanalh. Najunch: ―Ni alactu'unu' u jantu ju quit'in jantu icc'atsai. Va lakatam taxtokni ju icc'atsai. Va alak'ach'ix xacjunita. Para ju chavai laich ic'alac'avanan. ");
INSERT INTO teeNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Chai tasacmichokopa ju anu' alak'ach'ix ixjunita. Tajunich: ―Tas xanaviyanch. Tas xalhimalac'avaniyanch. ");
INSERT INTO teeNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Chai ak'alhtayanalh ju anu' alak'ach'ix ixjunita. Ajuni: ―Ni iclajumpalauch chai jantu xaquilak'asmatnipalau. Tajuch ni va k'asmatch'ok'op'ut'unat'itch aktam. Ja vachu' va ump'ut'unat'it ju uxijnan ixtamamaka'unti. ");
INSERT INTO teeNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pus talhitalhk'amalh ju xalack'ajin israelitanin. Tajunich ju anu' alak'ach'ix ixjunita: ―Ju uxint'i ixtamamaka'unch'at. Para ju quijnan ixtamamaka'unti Moisés icjuntau. ");
INSERT INTO teeNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ju quijnan icc'atsayau ni Dios ju xak'ala ju Moisés. Para ju ani lapanac jantu icc'atsayau ta anchach ju xaminacha. ");
INSERT INTO teeNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Chai ak'alhtayanalh ju anu' alak'ach'ix ixjunita. Ajunich ju xalack'ajin ist'a'israelitanin: ―Slivasalh k'ai lhamak'an ju ani. Ju uxijnan jantu c'ats'ayat'it ta anchach ju mintacha ju yuchi para ju quit'in quimalac'avanilh. ");
INSERT INTO teeNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","C'atsayauch ni jantu k'asmatni ju va alactu'unu' ju Dios. Para ni alin xamati' ju talhoni ju Dios chai navini ju ixk'achat pus yuchi ju k'asmatni. ");
INSERT INTO teeNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tus la'ixputai'ulacan ju lacamunutpa' jantu tavanan k'asmatcanta ni ca'alilh xamati' ju lai camalac'avani ju va alak'ach'ix lak'ajunta. ");
INSERT INTO teeNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Pus ju anu' lapanac ni jantu cava la'ixmacni Dios ju minta ca jantu lai tu'u' catinavi. ");
INSERT INTO teeNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Chai ta'ak'alhtayanalh ju xalack'ajin israelitanin. Tajunich ju anu' alak'ach'ix ixjunita: ―Ju uxint'i ists'alh'at ju va alactu'unu lapanacni. Ja va quilamalaniputunauch ju quijnan. Pus lana xcoxtucalh junta ixtanun. ");
INSERT INTO teeNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Chai k'asmatlh ju Jesús ni tixcoxtucalh ju anu' alak'ach'ix ixjunita. Chai acsni pakxtokchokolh junich: ―Ju uxint'i ja lhilaksi ju ists'alh Dios. ―Juncanch ju alak'ach'ix ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Chai ju alak'ach'ix ixjunita k'alhtailh ju Jesús. Junich: ―Tis chavaich ju anu' lhich'ivinin ji qui'amigo. Aq'ui'unch ni laich aclhilaksi ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Chai ju Jesús acsni k'alhtailh ju anu' alak'ach'ix ixjunita junich: ―Lakts'int'ach. Chai yuchach ju t'onan t'achivinin. ");
INSERT INTO teeNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Chai ju anu' alak'ach'ix ixjunita junich ju Jesús: ―Iclhilaksiyanch ji qui'ucxtin. Chai lana ta'aktsokotanilh. Tsuculh nona' ni yuchach ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Chai naulh ju Jesús: ―Ju quit'in iclhiminta ju ani lacamunutpa' ni laich caputasuya' ixtalak'alhin'an ju lapanacni. Ju chunch ju tachi ju va alak'ach'ixnin tajunita ni va jantu amachakxanan catamachakxaya' ju stavasalanti. Chai ju tanajun ni tamachakxai ju stavasalanti pus tachi alak'ach'ixnin catajuna' ni jantu cata'amachakxanana'. ");
INSERT INTO teeNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ju ali'in fariseonin ju ixtamakvilanalh junta ixvi ju Jesús acsni tak'asmatnilh ju ani chivinti tajunich ju Jesús: ―Ja vachu'as tachi ju va alak'ach'ixnin icjuntau ni jantu lai ic'amachakxananau. ");
INSERT INTO teeNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Pus ju Jesús ajunich ju fariseonin: ―Ni tachi ju va alak'ach'ixnin cava unt'at'it ni va jantu amach'akxananat'it cava pus jantu ix'ulanic'ant'at'it ju mi'alactu'unti'an. Para ni nonat'it ni mach'akxayat'it ju stavasalanti pus yuchi na lhi'alin ju mi'alactu'unti'an ni jantu naviyat'it. ");
INSERT INTO teeNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ju Jesús tailhi'alh ju chivinti ju ixt'ajun ajunini' ju fariseonin chai naulh: ―Slivasalh ju iclajunau. Ju jantu caputanuya' laxamalhtich ju la'ixcorral ju borregojni ni va alacatam ju capu'ana' pus ju yuchi va ak'alhona' chai va lacatap'astu ju tai'i ju jantu ix'anu'. ");
INSERT INTO teeNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Para ju caputanuya' laxamalhtich yuchach ju ixlhistacna' borregojni. ");
INSERT INTO teeNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ju ixlhistacna' malhtich malhtek'ani ju vasalh ixlhitacna' borregojni. Ju ixborregojni tak'asmatni ju ixchivinti. Chai ju yuchi at'asani ju ixborregojni la'ixtapaka'ut'an chai alacmaxtui. ");
INSERT INTO teeNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Acsni amaxtuk'ojui ju ix'anuch pus ap'ulhnich. Chai ju ixborregojni tach'ak'ok'aich ni tamispanich ju ixchivinti ju ix'ucxtin'an. ");
INSERT INTO teeNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Para ju va ak'antam ni jantu tamispai pus jantu tach'ak'ok'ai. Alai va ta'ats'alhni va ixlacata ni tamispanich ju ixchivinti ni jantuch ix'ucxtin'an. ");
INSERT INTO teeNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Pus ju Jesús acsni naulh ju chunch chivinti va ix'apumavasalaniputun tu'u' ju fariseonin. Para ju yu'unch jantu lai tamachakxa tuchi ju ix'amalanicanch. ");
INSERT INTO teeNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Pus aktam ajunchokopa ju Jesús ju fariseonin: ―Slivasalh ju iclajunau. Ju quit'in chunch icjunita tachi ju xamalhtich ju ixcorral ju borregojni. ");
INSERT INTO teeNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tachi chun ju alhistacnin ju p'ulhnan ixtat'ajun acsni tuca' xacmin va ak'alhonin ixtajunita. Chai va lacatap'astu ixtatai'iputun ju jantu ix'anu'an. Para ju lapanacni ju tachi borregojni tajunita jantu tak'asmatnilh ju ixchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ju quit'in chunch icjunita tachi ju xamalhtich ju corral. Ju laquimacni catanuya' catak'alhtaxtuya'. Chai ju laquimacni ca'amaklhtayanank'oya' tachi chun ju ixmaktasq'uinit. ");
INSERT INTO teeNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ju ak'alhona' yuchi lhiminch ni va ak'alhonamputun chai lakmakniputun chai lak'alhiputun. Ju quit'in iclhiminta ni ca'alilh ju is'atsucunti'an ju lapanacni ju conk'alhiyanta lact'iyan. Chai slivasalh k'ox cajuna' ju anu' atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Quit'in ju k'ox xa'alhistacna' ju lapanacni ju tachi borregojni tajunita. Ju k'ox xa'alhistacna' borregojni lhitap'ux ju is'atsucunti va ixlaca'atalh ixborregojni. ");
INSERT INTO teeNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ju va xalapanac junita jantu chun navi ni jantiyu' ju amanavin. Pus ju yuchi acsni lakts'in ju maktili' ni mintach pus va lacmacoyojuich ju borregojni. Chai ats'alaich. Pus ju maktili' tap'astu alacch'apai chai amakpitsich ju borregojni. ");
INSERT INTO teeNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Pus ju jantu tucan yu' ju xa'alhistacna' yuchach lhi'ats'alai ni va xalapanac junita. Jantu tu'u' lhiulai ju borregojni. ");
INSERT INTO teeNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Quit'in ju k'ox ixlhistacna' ju lapanacni ju tachi borregojni tajunita. Ju quit'in ic'amispak'ojui ju quilapanacni. Chai ju qui'anu' quintamispai. ");
INSERT INTO teeNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Chunch vachu' ju quimpai quimispai. Pus vachu' ju quit'in icmispai ju quimpai. Chai ju quit'in acxt'ak'a' ju qui'atsucunti ni catatsuculh ju quilapanacni. Chun tachi tam alhistacna' ni lhixt'ak'a ju is'atsucunti ixlacata ixborregojni. ");
INSERT INTO teeNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Vachu' icpacxanta ali' lapanacni ju tachi borregojni tajunita ju jantuca' quintach'ak'ok'ai. Tasq'uini ni ac'alhimilh. Chai ju yu'unch catak'asmat'a' ju quinchivinti. Va ch'anxtamch catajuna'. Chai va pumatamch cajuna' ju alhistacna'. ");
INSERT INTO teeNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ju quit'in mas acxt'ak'ach ju qui'atsucunti laich ac'amaklhtayananchokoya'. Yuchi quilhimapaini ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jantu lai xamati' aquintitai'inilh ju qui'atsucunti ju va la'ixk'achat is'akstu. Qui'akstu ju acxt'ak'a'. Alin ju quintachaput ni lai acxt'ak'a'. Chai alin ju quintachaput ta yu lai acpu'amaklhtayananchokoya'. Junima lhamap'aksin quimpai ju quixtaknita. ");
INSERT INTO teeNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Aktam alinchokopa ju ixlaklak'aiti'an ju israelitanin va ixlaca'atalh junima chivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Na lhu ju israelitanin ju ixtanajun: ―Ju yuchi va pacxanta lhacaticuru. Jantu ac'atsananta. Tajuch ni k'asmatniyat'it ju ixchivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ju ali'in ixtanajun: ―Junima chivinti jantu ixchivinti ju tam xamati' ju va pacxanta lhacaticuru. Ju lhacaticuru ja lai camalac'avani ju tam alak'ach'ix. ");
INSERT INTO teeNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ju amachak'an Jerusalén ixtat'ajun mac'ataninin ju ixpujitat'an. Lacalhic'asnin ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ju Jesús ix'alhtanat'ajun la'ismakspa' la'ixpujitat'an ju ist'a'israelitanin junta juncan ix'anu' ju Salomón. ");
INSERT INTO teeNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Pus ju ist'a'israelitanin lana talacaxc'avitnu ju Jesús. Chai tajunich: ―Tas vananch ju aquilamavasalaniyau ju stavasalanti. Ni uxint'ich ju Cristo'at pus vasch aquilajuniu. ");
INSERT INTO teeNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Chai ak'alhtayanalh ju Jesús. Ajunich: ―Ni iclajumpalauch. Ni va jantu lac'a'ip'alat'it. Ju tuchi icnavi la'ixtapaka'ut ju quimpai Dios yuchach ju capuc'atsacana' tichi chavaich ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Para ju uxijnan jantu lac'a'iyat'it ni jantu quimborregojni unt'at'it tachi ju iclajuntauch. ");
INSERT INTO teeNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ju lapanacni ju tachi quimborregojni tajunita quintak'asmatnich ju quinchivinti. Chai ic'amispaich. Chai quintach'ak'ok'aich. ");
INSERT INTO teeNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Quit'in ju ic'axtakni ju is'atsucunti'an jonk'alhita. Chai jantu tavanan catanik'alhiya'. Nin xamati' lai ca'amak'osu ju laquimacni. ");
INSERT INTO teeNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yuchi ju quimpai ju xaqui'axtakni. Chai yuchi ju palai xak'ai tachi chun ju lapanacni. Jantu lai xamati' cati'amak'osu ju la'ixmacni ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ju quit'in chai ju quimpai va lakatamch icjuntau. ");
INSERT INTO teeNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Aktam tasacchokopa ju chiux ju ist'a'israelitanin. Va ixtaput'alhputunch ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pus ju Jesús ajunich: ―Na lhu lhamak'an ju xaclamalacasuniyau la'ixmacni ju quimpai. Tasmalhch ju quilalhilacat'alhmaputunau. ");
INSERT INTO teeNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ta'ak'alhtayanalh ju ist'a'israelitanin. Tajunich: ―Jantu iclalacat'alhmaputunau ixlacata ju k'oxi lhich'alhcat ju navit'a. Para va ixlaca'atalh ju macxcai chivinti ju na'un ni na'un ni Dios'at. Para ni va lapanac ump'alat'a. ");
INSERT INTO teeNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ak'alhtayanalh ju Jesús: ―Ja jantu p'ast'ac'at'it ni ts'okcanta ju lamilhamap'aksin'an ni ma chani naulh ju Dios: “Icnaulh ni diosnin unt'at'it ju uxijnan”. ");
INSERT INTO teeNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Pus diosnin alhixak'alacalh ju yu'unch ju axtaknicalh ixlhich'alhcat ju Dios. Chai ju tuchi ts'okcanta lacalhamap'aksin jantu lai catimapaxacalh. ");
INSERT INTO teeNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ja jantu vana va chun ju quit'in ni quisacxtutach ju quimpai Dios chai quimalakachachilh ju ani lacamunutpa'. Tajuch ni va quilajunau ni macxcai ju icchivinin acsni icnajun ni ists'alh Dios ju icjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Pus ni jantu ixlhich'alhcat ju quimpai ju icnavi pus jantu aquilalaca'iniu. ");
INSERT INTO teeNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Para ni icnavi ju ixlhich'alhcat ju Dios pus ap'ulac'a'it'itch ju icnavi mas jantu lai lac'a'iyat'it ju tuchi iclajunau. Ju chunch lai amisp'aya'it'itch ni va lakatam Dios icjuntau ju quimpai chai ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Aktam ixtach'apaputumpalai ju Jesús. Para lana taxtulh ju yuchi junta ixtavilanalhch ju fariseonin. ");
INSERT INTO teeNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Aktam anchokopa ju mak'antacutni lacxcan Jordán junta p'ulhnan ix'amakpaxanan ju Xivan. Anchach ju tolhcha. ");
INSERT INTO teeNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na lhu lapanacni ju ixtalakminch ju Jesús chai chani ixtanajunch: ―Ju Xivan jantu tu'u' lhamak'an navita. Para tachi chun ju naulh ju Xivan ixlacata ju ani lapanac islivasalh. ");
INSERT INTO teeNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Chai na lhu talhilaca'alh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ju acsnich ixtak'ank'ai pumatam lapanac ju ixjuncan Lázaro. Chai ju yuchi ix'alin ju ix'alak'avin. Ju pumatam ixjuncan Malia. Chai ju pumatam ixjuncan Marta. Va lakputam ixtat'ajun junta juncan Betania. ");
INSERT INTO teeNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ju Malia isp'isek'e ixjunita ju Lázaro ju anu' ixtak'ank'ai. Yuchach ju Malia ju lacamuc'alh ju ixc'uch'u ju qui'ucxtin'an Jesús. Chai ju anu' c'uch'u na saksi ix'acamin. Chai ju Malia ach'anxac'analh la'ix'ai. ");
INSERT INTO teeNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Pus ju anu' atsi'in ju ix'alak'avin ixtajunita ju Lázaro tamalakacha ju ixlapanacni'an junta ixvilhcha ju Jesús. Chai ju yu'unch tajunilh ju Jesús: ―Ucxtin ju lapanac ju na map'aini na tak'ank'ai. ");
INSERT INTO teeNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Acsni k'asmatlh ju Jesús ju chunch pus ajunilh ju anu' lapanacni: ―Jantiyu' xalhixtaknican ju ani tak'ank'at ni va caniya'. Yuchi xalhixtaknican ju ani tak'ank'at ni catanona' ju lapanacni ni na tachapun ju Dios. Chunch ju acpumispacana' ni icxak'aich ju quit'in ju ists'alh Dios icjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ju Jesús na ixt'alamapaini ju Marta chaich ju isp'isek'e chaich ju Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Para ju Jesús acsni k'asmatlh ni ixtak'ank'ai ju Lázaro pus titolhcha lakat'ui vilhchan junta ixvilhcha. ");
INSERT INTO teeNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ju astan ajunilh ju ix'amamaka'ui: ―Ca'anchokoch ju xa'estado Judea. ");
INSERT INTO teeNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ju ix'amamaka'ui tajunich: ―Amamaka'unu' tuca' mak'an ixtalacat'alhmaputumpalachan ju quint'a'israelitanin'an. Chai ja va p'inch'ok'op'ut'unch ju anch. ");
INSERT INTO teeNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ak'alhtayanalh ju Jesús: ―Ja jantu pacxanta lakacaut'ui hora ju tam avilhchan. Pus ju ca'alhtanana' ju tuncu jantu tu'u' puk'alhk'osa ni lakts'in ju xa'atuncunu' ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Para ju va ts'ista la'ixtac'atsan cak'alhk'osa' ni mati' ju atuncunu' ju la'ix'alhunut. ");
INSERT INTO teeNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Acsni naulh ju ani pus astan ajunich: ―Ju qui'amigo'an Lázaro lhtataich. Para ac'ana' macujunu' ju la'ilhtatat. ");
INSERT INTO teeNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ju acsnich ju ix'amamaka'ui tanaulhch: ―Qui'ucxtin ni va lhtatai pus palai cajuna'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ju Jesús va ix'ajumputunch ni nitach vasalh. Para ju yu'unch va ixtalhimachakxai ni ca vasalh va lhtatai ju Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lana acsnich ju vas ajunilh ju Jesús ni nilhch ju Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Chai ajunich: ―Na iclhik'achan ju milacata'an ni jantu anch xacvilhcha acsni tavanan xani ju Lázaro. Ju chunch ni laich palai aquilapulhilaksiyau. Para ju chavai ca'auch lakts'inin. ");
INSERT INTO teeNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ju acsnich ju Tumax ju ixjuncan Cuate ajunich ju ix'alact'atamaka'ui: ―Ca'auch vachu' ju quijnan'an ni laich k'aixtam cat'anitachau ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Acsni cha'alh ju Jesús ju la'ixchaka' ju lijunto mac'atsanicalh ni lakat'at'ich avilhchan ix'acnui ju Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ju lak'achak'an Betania vanin ixt'alach'apata ju lak'achak'an Jerusalén. Tachi lakat'utu kilómetro ixlhimakat. ");
INSERT INTO teeNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Pus yuchi lai ixtalhilakminta ju Marta chaich ju Maliach na lhu ju ist'a'israelitanin. Va ixtamatank'oxaxk'ayai ni jantu na cata'amak'aninilh ju ixlacata ju lijunto isp'isek'e'an Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ju Marta acsni k'asmatlh ni vaninch minta ju Jesús pus alh pakxtoknu'. Para ju Malia tavilhca' lacachaka'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Pus ju Marta junich ju Jesús: ―Qui'ucxtin ni c'a'ixvilht'i ju ani pus jantu ixtini ju quimp'isek'e. ");
INSERT INTO teeNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Para icc'atsai mas chavai tachi chun ju asq'uiniya' ju Dios caxtakniyan. ―Najunch ju Marta. ");
INSERT INTO teeNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ju Jesús junich ju Marta ni k'alhtailh: ―Calok'onchokoya' ju mimp'isek'e. ");
INSERT INTO teeNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Chai ju Marta junich ju Jesús: ―Icc'atsai ni calok'onchokoya' ju quimp'isek'e la'ix'aclanti ju lacamunutpa' acsni catalok'onchokoya' ju tanitach. ");
INSERT INTO teeNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Chai ju Jesús junich: ―Quit'in ju ic'amalok'onininchokoi. Chai quit'inch ju icxt'ak'a ju atsucunti jonk'alhita. Ju quilhilaca'anch mas caniya' ju ixlacatuna para catsucuyanta ju ixtacuvin ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Chai tachi chun ju alin is'atsucunti'an ju jonk'alhita va ixlaca'atalh ni quintalhilaca'anch pus catatsucuk'alhiyanta ju lact'iyan. Ja lac'a'i ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ju Marta junich: ―Chunch ji qui'ucxtin. Iclaca'ich ni uxint'i ju Cristo'at. Ists'alh'at Dios ju noncanch ni camina' ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Acsni naulh ju chunch ju Marta pus lana anchokolh la'ixchaka'. Chai lana va sek t'asanilh ju isp'isek'e ju Malia ixjuncan. Junich: ―Ju amamaka'unu' anu' yacha chai t'asaniyanch. ");
INSERT INTO teeNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Chai ju Malia acsni k'asmatlh ju anu' chivinti pus lana vats'alhti taya. Lak'alh junta ixvilhcha ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Pus tuca' ixcha'an ju Jesús ju lak'achak'an Betania. Va anchca' ixvi junta t'alapakxtoklh ju Marta. ");
INSERT INTO teeNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Pus ju Malia vats'alhti taya junta ixvi chai taxtulh. Pus ju ixtavilanalh la'ixchaka' ju Malia acsni talakts'ilh ni taxtulh pus tach'ak'ok'alh. Talaclajunich: ―Ca anch ju xa'an k'alhutolhna' junta mak'acanta ju ixlacatuna ju lijunto isp'isek'e. ");
INSERT INTO teeNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ju Malia acsni cha'alh junta ixvi ju Jesús pus lana ta'aktsokotalh vanin junta ixya. Junich: ―Qui'ucxtin ni c'a'ixvilht'i ju ani pus jantu ixtini ju quimp'isek'e. ");
INSERT INTO teeNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ju Jesús acsni lakts'ilh ju Malia ni na ixk'alhunch chaich ju ist'a'israelitanin ju ix'alact'amintach k'aixtam ni vachu' ixtalack'alhun pus xcanilhch ju ix'alhunut ju Jesús. Amak'aninilh. ");
INSERT INTO teeNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ajunich ju Malia chai Marta: ―Tas anchach ju mak'at'at'it ju ixlacatuna ju lijunto Lázaro. Tanajunch ju Malia chai ju Marta: ―Asok'och ji qui'ucxtin. Alakts'int'achich. ");
INSERT INTO teeNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ju Jesús lana tsuculh k'alhunu'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ju acsnich ju ist'a'israelitanin tanaulhch: ―Alakts'int'itch. Slivasalh na ixt'alamapaini ju Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Para ju ali'in tanaulh: ―Ju ani lapanac lai malac'avani ju alak'ach'ix. Tajuch ni jantu lai xac'uch'upalai ni jantu c'a'ixnilh ju Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ju Jesús aktam xcanichokopa ju ix'alhunut. Alh junta ixmak'acanta ju ixlacatuna ju lijunto Lázaro. Anch junta pulhucucu talhpa ixjunita. Chai ixyonicanta lht'ak'alh chiux ju laxamalhtich. ");
INSERT INTO teeNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ajunich ju Jesús ju lapanacni: ―Amak'osut'it ju chiux. Para ju Marta ju ixlak'auch ju lijunto naulhch: ―Qui'ucxtin para na ca acaminch ju chavai ni lakat'at'ich avilhchan ju xatamai ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ju Jesús junich: ―Ja jantu icjunan ni chavai ju alakts'ina' ju ixtachaput ju Dios ni vasalh alac'a'it'i. ");
INSERT INTO teeNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ju acsnich tamak'osulhch ju chiux. Chai ju Jesús talakst'alh ju lact'iyan. Naulh: ―Quimpai icxtakniyan lhak'ailakts'in ni quink'asmatnitach ju tuchi xacsq'uiniyan. ");
INSERT INTO teeNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ju quit'in icc'atsai ni akts'iya quink'asmatnich. Para va ixlaca'atalh'an ju ixtalhavat lapanacni ju ani tavilanalh icsq'uiniyanch chunch ni laich catalaca'iya' ni uxint'i ju q'uimac'at'ant'a ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Acsni nonk'o junima chivinti ju Jesús pus lana p'as chivinilh acsni junilh ju lijunto Lázaro: ―Lázaro at'axt'uch makspa'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Pus ju Lázaro taxtulh junta ixmacnucanta. Ixch'anch'icantaca' chai ixmakch'icantaca' lacapumpu' acsni taxtulh. Chai ju ix'ucxpu' ixlacapach'icantaca' lacapayu. Ajunich ju Jesús ju lapanacni: ―Alacxk'otnit'itch junta lacch'inicanta. Chach ancha la'ixchaka'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ju acsnich na lhu ju ist'a'israelitanin ju ixtalakminta ju Malia talhilaca'alh ju Jesús ni talakts'ilh tuchi navilhch ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Para ju ali'in ta'alh lakts'inin ju fariseonin. Ta'alh juninin tuchi navilhch ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ju acsnich ju xalack'ajin palijni chaich ju fariseonin tamak'aixtoklh ju ixt'axalack'ajin. Ixtalajunich: ―Tas calayauch ju chavai. Ju ani lapanac na lhu lhamak'an ju malacasui. ");
INSERT INTO teeNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ni va calhilak'a'iyau pus chux ju quint'a'israelitanin'an catalhilaca'ank'oyach ni ix'ucxtin'an junita. Chai cataminach ju romanonin ju talhinajun ju ani lacat'un chai catalak'alhiya' ju quimpujitat'an chai aquintamaknik'oyan. ");
INSERT INTO teeNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Para pumatam lhiyu'unch ixjuncan Caifás. Ju yuchi xak'ai pali ixjunita ju anu' c'ata. Ju yuchi ajunich ju ixt'axalack'ajin: ―Ju uxijnan jantu tu'u' misp'ayat'it. ");
INSERT INTO teeNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Jantu mach'akxayat'it ni palai k'ox ju quilacata'an ni canilh pumatam lapanac. Jantu camaknik'ocau ju quijnan'an ju israelitanin juntau. ");
INSERT INTO teeNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ju Caifás jantu va la'is'akstu pastaclh ju ani chivinti. Para ni xak'ai pali ixjunita ju anuch c'ata pus yuchi lhinaulh ni caniya' ju Jesús ix'okxtapalhni ju ist'a'israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Chai jantu va yuchi ni canilh ix'okxtapalhni ju ist'a'israelitanin. Para vachu' la'ix'aninti va lakatam ix'anavik'oputun ju is'ask'at'an Dios ju tat'ajun ixlhilacaputs'un ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Pus tus acsnich avilhchan ju tapastaclh ta yu laich catapumakniya' ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ixlhiyuchach ju Jesús jantu ix'alhtanamputun la'ix'ucxlacapu'an ju ist'a'israelitanin. Va alh laxalacat'un junta vanin ixt'alach'apata ju anu' xalacat'un junta mati' tu'u' ixjunita. Alh ju lak'achak'an ju ixjuncan Efraín. Anch ju alact'atolhcha ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ju ixc'atan'an ju israelitanin vanin ixjunita. Ju c'atan ju ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. Pus acsni tuca' ixchin ju anu' c'atan pus na lhu lapanacni ixtacha'anta ju lak'achak'an Jerusalén. Ixtataxtutacha la'ixt'un'an. Va ixta'an navinin tachi ju ixnajunch la'ixlhamap'aksin ju Moisés ni laich cata'ulh ju ixborrego'an. ");
INSERT INTO teeNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Chai ixtapuxcajuich ju Jesús. Chai ixtalajunich ju sia yu'unch acsni ixtayanalh lacak'ai ixpujitat'an: ―T'as nonat'it ju uxijnan. Ja camina' nu' ju chavai c'atan ju anuch ju juncan Cristo u jantu. ");
INSERT INTO teeNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ju xalack'ajin palijni chaich ju fariseonin ixtaxtaktach ju lhamap'aksin ni tam xamati' cac'atsaya' ta anchach ju catsucucha ju anuch Jesús pus lana canonach. Ju chunch laich cata'ana' ch'apanin. ");
INSERT INTO teeNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Acsni chinchokocha ju Jesús ju lak'achak'an Betania pus lakachaxanca' avilhchan ixtic'acxaca' acsni cajunach ju anu' c'atan ju lak'achak'an Jerusalén. Ju Betania ixlak'achak'an ixjunita ju anu' Lázaro ju ixnita chai ixlok'onchokota la'ixtachaput ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Anch ju tanavinilh lakatam lacvaiti ju Jesús. Chai ju Marta ixt'ak'a vaiti. Chai ju Lázaro ixmaktapakstitama junta ixta'akstitamanalh ju Jesús junta ixtat'ajun venin ni chunchach ixtalhilanita. ");
INSERT INTO teeNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ju acsnich ju Malia ch'apalh paitat kilo ju na saksi c'uch'u ju va ach'itin ixnavicanta chai na laklhu ixtapalh ixjunita. Chai ju yuchi ch'anmuc'alh la'ixch'anch'aja' ju Jesús chai lhich'anxaca la'ix'ai. Pus ju chaka' na c'us pulac'acamilh ju lacac'uch'u. ");
INSERT INTO teeNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Para pumatam ixtamamaka'un ju Jesús jantu k'ox lhiula. Ju yuchi Judas Iscariote ixjuncan. Ists'alh Simón. Yuchi ju anu' camak'axt'ak'a' ju Jesús. Pus ju yuchi naulh: ");
INSERT INTO teeNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","―Tajuch ni jantu lakat'utu cientos xalhist'ai ju ixc'uch'u chai ca'ix'axtaknilh ju quilhpatinin. ");
INSERT INTO teeNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mas chunch ju naulich para jantu slivasalh ni va camapaini ju quilhpatinin. Alai punaulh ni va ak'alhona' ixjunita. Chai yuchi ju ixmak'atach ju ixtumin ju Jesús chaich ixtumin'an ju ix'at'amamaka'uich. Chai anch ju ixk'alhomacutuich ju tumin. ");
INSERT INTO teeNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ju acsnich ju Jesús junich: ―Amac'auch. Ju yuchi ixmak'ata ju ani c'uch'u. Chai ju chavai quixt'ek'emuc'anilh ni camak'acana' ju quilacatuna. Chunch ju xanavich tachi ju lhilanitauch ni nican. ");
INSERT INTO teeNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ju quilhpatinin akts'iya catat'a'alhtananan. Para ju quit'in jantu lai actilat'a'alhtanank'alhiu. ");
INSERT INTO teeNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Na lhu ju israelitanin tac'atsa ni anch ixvi ju Jesús la'ixchaka' ju Malia. Para jantu va yuchi ixtalhiminta ni va ca'ixtalakts'imputulh ju Jesús. Para vachu' ixtalakts'imputunch ju Lázaro ju ixlok'onchokotach la'ixtachaput ju Cristo acsni ixnita. ");
INSERT INTO teeNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ju xalack'ajin palijni ixtalajunich ju sia yu'unch ni camaknicanach vachu' ju Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Pus va ixlaca'atalh ni malok'onichokocalh ju Lázaro na lhu ju israelitanin tapumacaulh ju ixpalijni'an chai talhilaca'alh ju Jesús. Yuchi ixtalhipast'ac'ach ni camaknicalh ju Lázaro. ");
INSERT INTO teeNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Acsni tuncunchokopa ju ixtalhavat lapanacni ju ixtachinta junta ixlai ju anu' c'atan tak'asmatlh ni mintach ju Jesús ju lak'achak'an Jerusalén. ");
INSERT INTO teeNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Pus tachakx'ilh ju ix'axtacna'an chai tach'apalhch chai ta'alh pakxtoknin ju Jesús. Ixtanajunch: ―Calak'ayacalh ju Dios. Paxcat ju ix'ucxtin'an ju israelitanin ju minta la'ixtapaka'ut ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ju Jesús lhitaju lakatam puru chai putoc'alh. Tachi ju ts'okcanta junta najun: ");
INSERT INTO teeNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jantu at'alhan ji amachak'an Jerusalén. Anich minta ju mi'ucxtin'an. Pujucalh ju puru. ");
INSERT INTO teeNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ju acsni jantu tamachakxa ju ani taxtokni ju ix'amamaka'ui ju Jesús. Para acsni anchokolh lact'iyan ju Jesús acsnica' ju tapastaclh ju ani taxtokni ni chunchach ists'okcanta ixlacata yuchi chai ni chunchach ju tamuctaxtulh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tachi chun ju lapanacni ju ixtalakts'inch ju Jesús acsni malok'onichokolh ju Lázaro acsni junilh ni cataxtulh junta ixmacnucanta pus yu'unch ju ixtanajunch ni vasalh chunch ju navilh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ju lapanacni ni ixtak'asmat'ach tuchi lhamak'an ixnavita pus yuchi taquilhipakxtoklh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pus ju fariseonin ixtalaclajunich ju sia yu'unch: ―Alakts'int'it. Ju quijnan'an jantu quiclaca'icanau. Chux ju lapanacni catach'ak'ok'ayach ju anu' lapanac ju Jesús juncan. ");
INSERT INTO teeNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Vachu na lhu ixtamak'anta ju griegonin junta ixta'anta ju israelitanin ju ixtamaknajun ni Cristo yuchi ju xak'ai. Chunch ixtanajun junta lai c'atan. ");
INSERT INTO teeNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ju yu'unch talak'alh ju Pilipe ju amachaka' Betsaida lhiGalilea. Tatapaininilh. Tajunich: ―Qui'amigo. Iclakts'imputunau ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pus ju Pilipe alhch junini' ju Tilix. Chai ju Tilix t'a'alhch ju Pilipe. Ta'alhch juninin ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ju acsnich ju Jesús alack'alhtailh. Ajunich: ―Vaninch chinch ju avilhchan acsni catac'atsayach ju lapanacni ni icxak'ai. Quit'inch ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. ");
INSERT INTO teeNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Slivasalh ju iclajunau. Ju satalhts'i trigo ni jantu capuch'ilh ju ix'axt'ak'a junta ch'ancanta lacat'un pus jantu lai tu'u' catixtaklh ju xalhi'ut. Para ni capuch'iya' pus cap'una' chai caxajtachilh chai na lhu caxt'ak'a' ju xalhi'ut. Pus tachi ju tapasai lasatalhts'i trigo pus chunchach vachu' ju catapasaya' ju laqui'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ju na mapaini is'atsucunti ju ani lacamunutpa' cats'ank'ayanta ju sa'atsucunti ju lact'iyan. Para ju jantu tu'u' lhiulai ju is'atsucunti ju ani lacamunutpa' pus pulhajai ju is'atsucunti jonk'alhita lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ni xamati' quinch'alhcatnaniputun pus aquinch'ak'ok'alh. Chai vanta anchach ju actsucuya' ju quit'in pus anchach vachu' catsucuya' ju quilapanac. Ni xamati' quinch'alhcatnaniputun pus camispacana' ni xak'ai la'ixmacni ju quimpai. Ju Jesús tailhi'alh ju ixchivinti chai chani naulh: ");
INSERT INTO teeNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","―Ju chavai quixcani ju qui'alhunut. Tijuch ju acnona'. Ja acnonach: “Quimpai aquimak'alht'axt'uch ju anu' minta pants'iquis”. Jantu lai actinaulh ju chunch ni yuchi iclhitsucuta ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Alai acnona': “Quimpai chach tac'atsa ju lapanacni ni xak'aich'at”. Chai acsni naulh ju chunch ju Jesús pus lana mincha lakatam chivinti ju lact'iyan ju naulh: ―Tac'atsalh ju lapanacni ni icxak'ai chai aktam camasunichokocana'. ");
INSERT INTO teeNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ju anu' lapanacni ju vanin ixtayanalh tak'asmatlich ju anu' chivinti. Chai ixtanajunch ni va t'asalh t'ajin. Chai ju ali'inch ixtanajunch ni anquilh ju xaxak'alai. ");
INSERT INTO teeNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ak'alhtayanalh ju Jesús. Ajunich: ―Jantu quilacata ju xalhimin junima chivinti. Para milacata'an. ");
INSERT INTO teeNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ju chavai amuc'anicalhch ixtalak'alhin'an ju lapanacni. Chai ju xa'ucxtin ju a'okxchok'oi chux ju lacamunutpa' jantuch lai catilhinonk'o. ");
INSERT INTO teeNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ju quit'in ni acxtucmuc'acana' ju lacacurus pus ac'at'asanik'oyach ju laquimacni tachi chun ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ju punaulich ju chunch ju Jesús va ix'amamachakxaninimputunch ta yu capuniyach. ");
INSERT INTO teeNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ta'ak'alhtayanalh ju ixtalhavat lapanacni: ―Ju quijnan ick'asmat'auch ni najun ju lacalhamap'aksin ni catsucuk'alhiya' ju Cristo ju noncan camalakachatachilh ju Dios. Para ju uxint'i na'un ni tasq'uini ni caxtucmuc'acalh lacacurus ju malakachatachilh ju Dios ni lapanac catsucuya' ju ani. Tis chavaich ju ani ju malakachatachilh ju Dios ni lapanac catsucuya' ju ani. Ja yuchi ju Cristo juncan. ");
INSERT INTO teeNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ju acsnich ju Jesús ajunich: ―Pus va pants'iquisch ju ti'alin ju atuncunu' ju lamilhi'uxijnan. Alac'asq'uint'it ni chach tamapulhcunin ju lami'alhunut'an ni alinca' ju tachi atuncunu' lamilhi'uxijnan. Ni jantu lak'a'iyat'it pus jantu xcai ni catak'alhi ju mi'atsucunti'an. Chunch a'una'it'it tachi tam xamati' ju alhtanan laca'atats'isni. Ju yuchi jantu c'atsai ta'anchach ju pu'an. ");
INSERT INTO teeNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ju quit'in tachi ju atuncunu' icjunita. Pus ni ictilat'avilau pus tus chavai aquilalhilaca'au. Ju chunch ats'uc'uya'it'it tachi ju lapanacni ju tat'ajun laqui'atuncunu'. Ju ani chivinti acsni naulh ju Jesús pus lana alh. Alack'osmak'alh ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ju Jesús mas navilhch ju la'ix'ucxlacapu'an ju lapanacni na lhu lhamak'an nin chunch jantu ixtalhilaca'an. ");
INSERT INTO teeNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ni chunchach talalh pus uctaxtulh ju ixchivinti ju mak'aniya lapanac ju Isaías ixjuncan. Ju yuchi ixnajun ixchivinti Dios chai chani ju junilh ju Dios: Tis chavaich ji qui'ucxtin ju laca'ita ju quinchivinti'an. Tis chavaich ju ismasunicanta ni na tachapun'at ji qui'ucxtin Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Chunch ju naulh ju Isaías. Chai ni jantu lai ixtalaca'i pus uctaxtulh ixchivinti ju Isaías junta chani nonchokoi laca'alacatam ats'oknut: ");
INSERT INTO teeNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Dios ju anavilh ni alak'ach'ixnin catava la'ixtac'atsan'an ju lapanacni. Chai na p'as anavinilh ix'alhunut'an. Ju chunch jantuch lai catapamachakxanana' ju ixtac'atsan'an. Chai jantu lai catalaca'iya' tu'u' la'ix'alhunut'an. Chai jantu lai tam catapast'ac'a' la'ix'alhunut'an ni laich tam ac'anavinilh ix'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yuchach ju ani ju naulh ju Isaías acsni masunilh ju Dios ni yuchach ju Dios ju xak'ai tucan. Chai chunch ju lhichivinilh. ");
INSERT INTO teeNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Akts'iya na lhu ju xalack'ajin talhilaca'alh ju Jesús. Para va ixlaca'atalh'an ju fariseonin jantu ixtapunomputun ju anuch xalack'ajin ni ixtalhilaca'anta ju Jesús. Va ixtanajunch ni jantu ca'axcoxtucalh la'ixpujitat'an ju ist'a'israelitanin ni jantu xamati' cac'atsa ni talhilaca'anta ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chunch ju talalh ni va palai k'ox ixtalhiulai ni catanaulhch ju ixt'alapanacni ni xalack'ajin tajunita. Palai jantu tu'u' talhiula ni Dios ju canaulh ni xalack'ajinch catava. ");
INSERT INTO teeNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ju Jesús p'as naulh: ―Ju quilhilaca'antach jantu va quit'in ju quilhilaca'anta. Para vachu' yuchi ju lhilaca'an ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Chai va tichi chavaich ju quilakts'in pus tachi ju va lakts'in ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ju quit'in icminta ju ani lacamunutpa' tachi ju tu'u' maclhcu ni laich ac'amalacpucujuya' ju lapanacni. Ju chunch tachi chun ju quintalhilaca'anch quit'in jantu va tachi ts'ista cajuna' ju la'ixtac'atsan'an. ");
INSERT INTO teeNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ju cak'asmat'a' ju quinchivinti para ni jantu tu'u' calhiulaya' pus jantu quit'in ju ic'ulani ixtalak'alhin. Jantiyu' iclhiminta ju quit'in ni va ac'a'ulanilh ixtalak'alhin'an ju lapanacni. Va icminta amak'alhtaxtunu' ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Alin tuchi ixtalakxtuch ju ulani ixtalak'alhin ju jantu tu'u' quilhiulai chai ju jantu laca'i ju quinchivinti. Ju chivinti ju icnajunta anch ju caputasuyach ixtalak'alhin'an acsni cachina' ju avilhchan ju ix'aclanti lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chai jantu va qui'akstu ju icchivinin. Para yuchi ju icnajun tuchi quijuni ju quimpai ju quimacaminta. Chai yuchi ju quimavasalanilh ta yu laich acnona'. ");
INSERT INTO teeNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Chai icc'atsaich ni alin ju atsucunti jonk'alhita acsni muctaxtucan ju la'ixlhamap'aksin ju quimpai Dios. Pus yuchi ju icnajunch tachi ju quijunitach ju quimpai Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tuca' c'atan ixjun. Ju anu' c'atan acsni ixpupastaccan ju anu' atats'isni acsni tatak'alhtaxtulh la'ix'aninti'an ju xalack'ajin ists'alan ju mak'aniya israelitanin. Pus ju Jesús c'atsalh ni chintach ju ix'avilhchan ni camaconach ju ani lacamunutpa'. Canach lact'iyan junta vi ju ixpai. Pus ju yuchi akts'iya ix'amapainich ju ixlapanacni acsni ix'alact'avi ju ani lacamunutpa'. Para ju chavai ni ca'anach pus amasunilh ni vasalh na amapaini. ");
INSERT INTO teeNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Acsni tapakstitama ju lacamixa pus ju lhacaticuru ixlhitanunch la'ix'alhunut ju Judas Iscariote ju ists'alh Simón. Yuchach ju mapast'ac'ani ni laich camak'axtaklh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ju Jesús akts'iya isc'atsaich ni ixtaknik'ojutach ju ixpai tachi chun ju taxtokni la'ixmaca'. Chai isc'atsaich ni la'ixmacni Dios ju taxtutacha chai la'ixmacni Dios ju ca'anchokoya'. ");
INSERT INTO teeNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Pus acsni tavenk'olh pus ju Jesús taya lacamixa. Chai maxtulh lakatam ixpumpu'. Ch'apalh alakatam pumpu' chai musatoc'alh. ");
INSERT INTO teeNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ju acsnich ju yuchi mujulh ju xcan lacak'ax chai tsuculh alakch'ak'anini' ixch'aja'an ju ix'amamaka'ui. Chai ix'ach'anxacaich lacapumpu' ju ismusajuc'alh. ");
INSERT INTO teeNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Para acsni lak'alh ju Simón Pitalu' pus ju yuchi junich: ―Qui'ucxtin ja aq'uinch'ak'aniya'i'an vachu' ju laquinch'aja' ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Chai ju Jesús junich: ―Ju tuchi icnavi ju uxint'i jantu mach'akxai ju chavai. Para amach'akxaya' astan. ");
INSERT INTO teeNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pus ju Pitalu' juni: ―Jantu tavanan aq'uint'ich'anch'ak'at'i. Chai ju Jesús junich: ―Ni jantu acch'anch'ak'ayan pus jantu quilak'au'at. ");
INSERT INTO teeNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Chai junich ju Simón Pitalu' ju Jesús: ―Qui'ucxtin pus jantu va yuchi ju quinch'aja' ju aq'uinch'ak'anin. Para vachu' ju quimaca' chaich ju qui'aktsulhch. ");
INSERT INTO teeNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Chai junich ju Jesús: ―Ni lhiyaxch ju xap'ax pus jantu tasq'uini ni acch'ak'anik'ojun ju milacatuna. Va minch'aja' ju acch'ak'aniyan. Ju ali' milacatuna ch'ak'ak'ocantach. Chai ju uxijnan ch'ak'anic'ant'at'itch ju lami'alhunut'an vachu'. Para jantu minchux'an. ");
INSERT INTO teeNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ju Jesús isc'atsaich tichi chavaich ju camak'axt'ak'a'. Yuchi lhinaulh ni jantu si ach'ak'anik'ocanta ju ix'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ju astan acsni ach'anch'ak'ak'olhch pus lakch'ichokolh ju ixpumpu'. Tapakstitamachokolh ju lacamixa. Ajunich ju ix'amamaka'ui: ―Ja mach'akxayat'it ju tuchi xaclanaviniyau. ");
INSERT INTO teeNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ju uxijnan acsni quilalhichivinau nonat'it ni ic'amamaka'unu' chai ic'ucxtin. Vas nonat'it ni chunch icjunita ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Pus ju quit'in ni mi'ucxtin'an chai mi'amamaka'unu'an icjunita ni iclach'ak'aniuch ju minch'aja'an pus tasq'uini ni alach'anch'ak'aya'it'itch vachu' ju milhi'uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Iclaxtakniuch ju lhilakts'intaiti. Ju uxijnan vachu' chunch anaviya'it'it tachi ju xaclanaviyauch. ");
INSERT INTO teeNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Slivasalh ju iclajunau. Ju va xalapanac jantiyu' ju xak'ai. Yuchi ju xak'ai ju xa'ucxtin. Nin yuchi ju va malakachacanta jantiyu' ju xak'ai. Yuchi ju xak'ai ju amalakachanan. Pus chunch ju quilat'ajuntau ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ni misp'ayat'it ju ani taxtokni lhik'ach ju ats'uc'uya'it'it acsni anaviya'it'it ju chunch. ");
INSERT INTO teeNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jantu iclhichivinin ju milhichux'an. Icc'atsai tichi chavaich ju icsacxtutach. Para chunchach ju capu'uctaxtuyach ju ats'oknut junta chani najun: “Ju k'aixtam xaquint'avajin va quint'alaxcai xajun”. ");
INSERT INTO teeNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Chavai ju iclajunau ni tuca' tapasai ju anu' lhamak'an ju iclajuntau. Ju chunch acsni ca'uctaxtuyach alac'a'iya'it'it ni chunch icjunita tachi ju iclajuntauch. ");
INSERT INTO teeNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Slivasalh ju iclajunau. Ju amaklhtayanan ju icmalakachatachilhch pus tachi ju va jun quit'in ju qui'amaklhtayanan. Chai ju qui'amaklhtayanan pus tachi ju va jun amaklhtayanan ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Acsni naulh ju Jesús ju chunch lana amak'aninilh la'ix'alhunut. Chai naulich: ―Slivasalh ju iclajunau. Pumatam milhi'uxijnan ju aquimak'axt'ak'a'. ");
INSERT INTO teeNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ju acsnich ju ix'amamaka'ui va k'antam k'antam talalakts'ilh. Jantu ixtac'atsai tichi chavaich ju ixlhichivincan. ");
INSERT INTO teeNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Pus vanin ixt'atapakstitama ju Jesús pumatam ixtamamaka'un ju na ixmapaini. ");
INSERT INTO teeNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Pus ju Simón Pitalu' tamacyonilh ju yuchi ni casacmilh tichi chavaich ju lhichivincan. ");
INSERT INTO teeNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pus ju yuchi vanin c'atu'anilh ju Jesús. Chai junilh: ―Qui'ucxtin tis chavaich ju camak'axt'ak'an. ");
INSERT INTO teeNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ju Jesús ak'alhtayanalh: ―Yuchach ju anu' ju acmatajuniya' ju ixni' laxaxcan quivaiti chai acxtakniyach. Chai acsni matajunilh pus xtaknicalh ju Judas Iscariote. Ists'alh ixjunita ju Simón. ");
INSERT INTO teeNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pus ju Judas acsni amaklhtayanalh ju vati akts'iya ixlhipastactach la'ix'alhunut tuchi ixnaviputunch. Pus ju acsnich pants'iquis lana tanulh ju lhacaticuru la'ix'alhunut ju Judas. Chai ju Jesús junich: ―Ju tuch'i navip'ut'un vats'alhch anavit'i. ");
INSERT INTO teeNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Para tachi chun ju ali'in ju ixtapakstitamai lacamixa jantu xamati' xamachakxai tajuch ni va chunch xajuncan ju Judas. ");
INSERT INTO teeNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ju Judas ni ixmamak'anicanta ju tumin pus ju ali'in va tamachakxa tachi ju va cajunilh ju Jesús: “At'amochich ju tuchi camaktasq'uiniyau ixlacata ju c'atan”. U tachi ju va cajunilhch: “Axt'akninch lacats'unin ju quilhpatinin”. ");
INSERT INTO teeNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Acsni amaklhtayanalh ju vati ju Judas ju xtaknilh ju Jesús pus lana taxtulh. Chai na ists'istach. ");
INSERT INTO teeNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Acsni taxtulh ju yuchi pus najunch ju Jesús: ―Ju chavai chinta ju avilhchan acsni aclak'ayacana'. Quit'in ju quimalakachatachilh ju Dios ni lapanac actsucuya' ju ani. Chai vachu' calak'ayacana' ju Dios ju quilacata quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Chai ni catac'atsaya' ju lapanacni ni yuchi ju xak'ai ju Dios ju va quilacata pus ju Dios camac'atsaniya' ju lapanacni ni icxak'ai vachu'. Chai vats'alhti canaviya' chunch. ");
INSERT INTO teeNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Qui'ask'at'an va pants'iquis ju iclat'avilau ju uxijnan. Aquilapuxcoyauch. Chai tachi ju ic'ajunilh ju quint'a'israelitanin'an pus vachu' chunch iclajunau ju uxijnan. Junta ac'ana' ju uxijnan jantu lai at'ip'it'it. ");
INSERT INTO teeNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Lakatam sast'i lhamap'aksin ju iclaxtakniyau. Yuchi ni alamap'ainit'it ju milhi'uxijnan'an. Tachi ju iclamapainiyauch pus vachu' chunch alamap'ainit'it ju milhi'uxijnan'an. ");
INSERT INTO teeNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ju chunch tachi chun ju lapanacni catapuc'atsaya' ni qui'amamaka'unti unt'at'it ni alamap'ainit'itch ju milhi'uxijnan'an. ");
INSERT INTO teeNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ju Simón Pitalu' junich: ―Qui'ucxtin ta anchach ju ap'ina'. Ak'alhtayanalh ju Jesús: ―Junta ac'ana' ju quit'in jantu lai aq'uint'ich'ak'ok'a ju chavai. Para astan aq'uinch'ak'ok'aya'. ");
INSERT INTO teeNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ju Pitalu' junich: ―Qui'ucxtin tajuch ni jantu lai actich'ak'ok'an ju chavai. Acxt'ak'ach ju qui'atsucunti ju milacata. ");
INSERT INTO teeNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ak'alhtayanalh ju Jesús: ―Ja vasalh lai axt'akt'i ju mi'atsucunti ju quilacata. Slivasalh ju icjunan. Acsni jantuca' t'asai ju puyux pus pakt'utuch ju na'unt'a ni jantu q'uimisp'ai. ");
INSERT INTO teeNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ju Jesús tailhi'alh ju ixchivinti ju ixt'ajun ajunini' ju ix'amamaka'ui chai naulh: ―Jantu ca'amak'aninilh ju mi'alhunut'an. Ju uxijnan ni lhilac'ap'inat'it ju Dios pus vachuch aquilalhilaca'anau ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Junta vilhcha ju quimpai na lhu alin ju chaka'. Ni jantu cava chunch ju lact'iyan pus xaclajuniuch ni jantu chun junita. Ac'anach lak'oxini' ju milacchaka'an cuna' ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chai ni ac'ana' lak'oxini' ju anu' lak'achak'an ju milacata'an pus acminchokopala' aktam. Chai quit'inch ju aclalhi'anau ju lact'iyan. Ju chunch junta actsucuyanta pus vachuch anch ju ats'uc'uya'it'it ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","C'ats'ayat'itch ta anchach ju ac'ana' chai misp'ayat'itch junta pu'ancan. ");
INSERT INTO teeNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ju Tumax junich ju Jesús: ―Qui'ucxtin jantu icc'atsayau ta anchach ju ap'ina'. Tas aclhimispayauch ju ti. ");
INSERT INTO teeNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ju Jesús junich ju Tumax: ―Quit'in ju icxati. Laquimacni ju puc'atsacan ju stavasalanti. Chai quit'in ju icxt'ak'a ju atsucunti jonk'alhi. Jantu lai xamati' lak'an ju quimpai ju jantu quilhilaksich. ");
INSERT INTO teeNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ni xaquilamispau tichi chavaich ju quit'in pus vachu' ismisp'at'it ju quimpai. Pus ju chavai ni quilamispayauch tichi chavaich ju quit'in pus tachi ju va misp'ayat'itch ju quimpai. Chai tachi ju va lakts'inat'it ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Chai ju Pilipe junich: ―Qui'ucxtin aquilamalacasuniuch ju mimpai. Aclhik'achanauch. ");
INSERT INTO teeNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Pus ju Jesús alack'alhtailh: ―Na mak'anchich ju xaclat'a'alhtanatsucuyau ju uxijnan. Ja vanach jantu q'uimisp'ai ji Pilipe. Ju quilakts'intach quit'in tachi ju va lakts'intach ju quimpai. T'as ni va nomp'alai ju uxint'i ni acmalacasuniyan ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ja jantu lac'a'i ni va lakatam Dios icjuntau ju quit'in chai ju quimpai. Ju chivinti ju tuchi iclajunau jantu va laqui'akstu ju icchivinin. Para ju quimpai ni va lakatam Dios quint'ajunita pus yuchach ju navi ju lhich'alhcat ju laquimacni. ");
INSERT INTO teeNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Alac'a'it'itch ni va lakatamch Dios ict'ajunita ju quimpai. U ni jantu lai p'ulac'a'iyat'it ju va quinchivinti pus aquilapulhilaca'auch ju tuchi icnavita. ");
INSERT INTO teeNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Slivasalh ju iclajunau. Ju lhich'alhcat ju icnavi quit'in pus vachu' chunch canaviya' ju quilhilaca'antach ju quit'in. Chai palai k'ai lhich'alhcat ju canaviya' ju yuchi va ixlaca'atalh ni aclak'anach ju quimpai junta vilhcha. ");
INSERT INTO teeNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tachi chun ju asq'uiniya'it'it ju quimpai ju laquintapaka'ut pus aclanaviniyauch. Chunch ju catapuc'atsayach ju lapanacni ni xak'ai ju quimpai ju va quilacata ni ists'alh icjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ni tu'u' asq'uina'it'it ju laquintapaka'ut pus quit'in ju aclanaviniyau. ");
INSERT INTO teeNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Ni quilamapainiyau ju quit'in pus amuct'axt'ut'it ju quilhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Quit'inch ju actapaininiya' ju quimpai chai cataxtakniyanch apumatam ju cata'aktaijuyan. Ju yuchi catat'atolhk'alhiyanch. ");
INSERT INTO teeNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Yuchi ju Spiritu Santu ju najun ju stavasalanti. Ju jantu quintalhilaca'an pus jantu lai cata'amaklhtayanana' ni va jantu talakts'in nin catamispa ju yuchi. Para ju uxijnan misp'ayat'it ni tat'avilanch. Chai catanuya' lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Jantu va mi'akstu'an ju actilamacaju. Aclalakminchokoyau ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jantuch mak'an aquintitalakts'ilh ju jantu quintalhilaca'anta. Ju yu'unch jantu aquintitalakts'inchokolh tavanan. Para ju uxijnan aquilalakts'inchokoyau. Chai ni ict'ajun ju quit'in pus vachu' ats'uc'ut'achit'it ju uxijnan ju lact'iyan. ");
INSERT INTO teeNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Acsnich avilhchan ju ac'ats'aya'it'it ni va lakatamch Dios ict'ajunita ju quimpai. Chai ac'ats'aya'it'it ni laquimacni ju t'onat'it ju uxijnan chai ju quit'in ict'ajun lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ju quilaca'inich ju quilhamap'aksin chai muctaxtuich tachi ju najunch ju laquilhamap'aksin pus yuchach ju quimapaini. Chai ju quimapaini pus vachu' camapainicana'. Yuchi ju quimpai ju camapainiya'. Chai ju quit'in vachu' acmapainiya' ju quilapanac. Chai cac'atsayach ni la'ix'alhunutch ju ict'ajun. ―Chunch ju ajunilh ju ix'amamaka'ui ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Pus pumatam ju ix'amamaka'ui ju Jesús ixjuncan Judas. Jantiyu' ju Judas Iscariote. Pus ju yuchi chani juni ju Jesús: ―Qui'ucxtin tas aquilapumalacasuniyau ju quijnan chai jantuch at'alac'asuniya' ju jantu talhilaca'antan. ");
INSERT INTO teeNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ak'alhtayanalh ju Jesús. Junich: ―Ni xamati' quimapaini pus camuctaxtuya' ju laquinchivinti. Chai ju quimpai camapainiya'. Chai ju quimpai chai ju quit'in aclakminauch ju quilaca'inich ju quinchivinti. Chai actsucuyauch la'ix'alhunut ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ju jantu quimapaini pus jantu tu'u' lhiulai ju quinchivinti. Ju chivinti ju k'asmat'at'it jantu qui'anu' para ix'anu' ju quimpai ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Pus iclajunau ju ani taxtokni ni iclat'avilauca' ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yuchi ju Spiritu Santu ju a'aktaijunu'. Chai yuchi ju camacaminiya' ju quimpai laquintapaka'ut. Yuchi ju catamasuniyan tachi chun ju taxtokni ju iclajuntau. ");
INSERT INTO teeNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ju quit'in acla'aktaijuyau ni jantu calac'ana' ju mi'alhunut'an. Tachi ju quit'in ni jantu lac'an ju qui'alhunut. Para ju a'aktaijunti ju aclanaviniyau jantu chun tachi ju va ix'a'aktaijunti tam lapanac. Jantu calac'alh ju mi'alhunut'an nin yuchi ni at'alhanant'it. ");
INSERT INTO teeNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","K'asmat'at'itch acsni xaclajunau ni ac'anach junta vilhcha ju quimpai chai aclalakminchokoyauch ju uxijnan. Pus ni xaquilamapainiu cava pus ixk'ach'ant'itch acsni iclajuniu ni aclak'anach ju quimpai ni yuchi ju palai xak'ai. Jantu quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ju chavai ictilajunau ni jantuca' ic'an ju lact'iyan. Ju chunch acsni ac'anach pus acsnich ju alac'a'iya'it'itch ju tuchi iclajuntauch. ");
INSERT INTO teeNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ju chavai jantuch mak'an ju actilat'achiviniu ju uxijnan ni caminach ju xak'ai ju okxchok'oi chux ju lacamunutpa'. Ju yuchi mati' ju ixtachaput ni lai tu'u' aquinavi. ");
INSERT INTO teeNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Para icnavi tachi ju quijuni ju quimpai ni laich catapumispaya' ju lapanacni ni icmapaini ju quimpai chai icnavi tachi ju quijuni ju yuchi. Ak'ost'olat'itch. Ca'auch. ");
INSERT INTO teeNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Vachu' chani ju ajuni ju ix'amamaka'ui ju Jesús: ―Ju quit'in chunch icjunita tachi ju tu'u' xaq'uiu uvas. Chai ju quimpai chunch junita tachi ju xa'alaxtunu'. ");
INSERT INTO teeNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tachi chun ju lapanacni ju quintalhilaca'anta pus chunch tajunita tachi ju xamack'atap'u. Pus ju jantu tasui ju quintachaput la'is'atsucunti tachi ju va jantu xt'ak'a ju xatoc'at. Pus amak'osucan ju yuchi tachi acsni achakxmak'an ju tu'u' xamack'atap'u ju jantuch xt'ak'a ju xatoc'at. Chai tachi chun ju lapanacni ju tasui ju quintachaput la'is'atsucunti pus tachi ju va taxt'ak'a ju xatoc'at. Pus tachi ju tu'u' q'uiu ni calakachakxtucanch ni laich palai lhu catoc'aya' ju xatoc'at pus vana va chun navican la'is'atsucunti ju anu' lapanac. Mak'osunik'ocan tachi chun ju alin la'is'atsucunti ju sast'uc'a ni jantu tasui ixtachaput ju Dios la'is'atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ju uxijnan ch'ak'anic'ant'at'itch ju lami'alhunut'an lacachivinti ju xaclajunau. ");
INSERT INTO teeNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ats'uc'ut'it ju laquimacni. Chai ju quit'in actsucuya' ju lami'alhunut'an. Ju tu'u' ixmakp'u ju xaq'uiu uvas jantu lai catitoc'alh ju xatoc'at ju va la'is'akstu. Tasq'uini ni anch ju camack'at'ap'unchokolh ju la'istisivic. Pus chunchach vachu' ju uxijnan. Jantu lai catitasu ixtachaput ju Dios ju lami'atsucunti'an ni jantu laquimacni ju ts'uc'uyat'it. ");
INSERT INTO teeNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ju quit'in icjunita tachi ju tu'u' xaq'uiu uvas. Ju uxijnan tachi ju xamack'atap'u unt'at'it. Chai ju t'ajunch laquimacni chai ni la'ix'alhunut ju ict'ajun pus yuchach ju xt'ak'a lhu xatoc'at ju la'is'atsucunti. Pus ni jantu t'onat'it ju laquimacni pus jantu tu'u' lai naviyat'it ju k'ox calhiula ju quimpai Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ju jantu laquimacni t'ajun camak'ancana' tachi ju tu'u' xamack'atap'u ju jantu k'ox. Ni chakxmak'ancanta pus caxixach. Chai camak'aixtokcana'. Chai lacxavacanch. ");
INSERT INTO teeNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ni t'onat'itch ju laquimacni chai ni lac'a'it'at'itch ju lami'alhunut'an ju quinchivinti pus laich aquilasq'uiniyau va tuch'i ju lac'asq'uinat'itch chai sich axt'aknik'oc'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Chai putasui ni yuchi ju xak'ai ju quimpai acsni salaka ju ats'uc'uya'it'it. Chai acsnich ju at'alac'asuya'it'it ni vasalhch quilapanacni unt'at'it. ");
INSERT INTO teeNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Tachi ju quimpai ni na quimapaini pus chunchach vachu' ju quit'in iclamapainiyau ju uxijnan. Pus va tachi ats'uc'ut'it ta yu laich aclapumasuniyau ni iclamapainiyau. ");
INSERT INTO teeNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Tachi ju quit'in ni icmuctaxtunilh ju ixlhamap'aksin ju quimpai chai quimapaini pus chunchach vachu' ju uxijnan. Va tachi aclamapainiyau ni amuct'axt'uya'it'it ju quilhamap'aksin. ");
INSERT INTO teeNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Iclapujunau ju ani taxtokni va ixlacata ni chach alilh ju quink'achat ju lami'alhunut'an. Chai chach vasalh ak'ach'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yuchi ju ani ju quilhamap'aksin ni alamap'ainit'it ju milhi'uxijnan'an tachi ju quit'in ni iclamapainiyau. ");
INSERT INTO teeNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ju palai k'ai amapaininti yuchi ju ani. Acsni tam xamati' ju calhitap'uxlh ju is'atsucunti ixlacata tam ix'amigo. ");
INSERT INTO teeNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ju uxijnan qui'amigojni a'una'it'it ni anaviya'it'it tuchi ju iclalhijunauch. ");
INSERT INTO teeNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ju chavai jantu va na va xalapanacni aclalhimispayau. Ju va xalapanac jantu lai mispak'ojui tuchi navich ju tam ix'ucxtin. Para ju quit'in iclamac'atsanik'otau ju uxijnan tachi chun ju ick'asmat'ach ju la'ixmacni ju quimpai. Yuchi iclalhijunau ju chavai ni qui'amigojni unt'at'it. ");
INSERT INTO teeNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Jantu uxijnan ju quilasacxtu. Para quit'in ju iclasacxtu ju uxijnan. Chai iclalhilhca'ulatau ni laich alhip'it'it ju ani chivinti chai catasu ju quintachaput ju lami'atsucunti'an chai lai va tachi chunchach catasu ju lami'atsucunti'an. Ju chunch tachi chun ju asq'uiniya'it'it ju quimpai ni laquintapaka'utch pus ju yuchi cataxtakniyan. ");
INSERT INTO teeNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Iclalhimap'aksiyau ni alamap'ainit'itch pumatamin ju milhi'uxijnan. Ju Jesús tailhi'alh ju ixchivinti chai chani ju ajuni ju ix'amamaka'ui: ");
INSERT INTO teeNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","―Ni va taxcayan ju jantu quintalhilaca'an pus ac'ats'at'it ni quit'in ju p'ulhnan xaquintaxcaji. ");
INSERT INTO teeNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ni ixt'at'ui cava unt'at'it ju jantu quintalhilaca'an pus ju jantu quintalhilaca'an ca catamapainin. Para ni quit'in ju iclasacxtutauch ju la'ixlhiyu'unch'an ju jantu quintalhilaca'an pus ixlhiyuchach jantu talhilakts'inan ni ixt'at'ui unt'at'it. Yuchi va talhixcayanch ju jantu quintalhilaca'anta. ");
INSERT INTO teeNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ap'ast'act'itch ni iclajuntau ni jantiyu' ju xak'ai ju va tam xalapanac. Para yuchi ju palai xak'ai ju ix'ucxtin. Pus ju quit'in ni quintamamak'alhk'ajni pus vachu' catamamak'alhk'ajniyan ju uxijnan. Ni quintalaca'inilhch ju quinchivinti pus vachu' catalaca'iniyan ju minchivinti'an. ");
INSERT INTO teeNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Chunch ju catapunaviyan va ixlaca'atalh ni quilalhilaca'anauch ju quit'in chai ju yu'unch jantu tamispai ju quimacaminta. ");
INSERT INTO teeNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ni jantu xacmilh chai jantu xac'amalani pus jantu ix'a'ulanicalh ju ixtalak'alhin'an. Para ju chavai jantu lai tanajun ni mati' ju ixtalak'alhin'an. ");
INSERT INTO teeNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ju quixcaji pus quimpai ju quint'axcaji. ");
INSERT INTO teeNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ni jantu cava xacnavi tu'u' lhich'alhcat ju la'ixlhiyu'unch'an tachi ju jantuch lai navi ju va tam xamati' pus jantu ix'a'ulanicalh ju ixtalak'alhin'an. Para ju chavai quintalakts'intach ju quit'in chai ju quimpai chai quintalhixcailich ju quit'in chai ju quimpai. Yuchi alhi'ulanicanta ju ixtalak'alhin'an. ");
INSERT INTO teeNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ni chunch talai pus uctaxtui ju chivinti ju ts'okcanta la'ixlhamap'aksin'an junta najun: “Quintalhixcailh mas jantu tu'u' talak'alhin xacnavi”. Chunch najun la'ixlhamap'aksin'an. ");
INSERT INTO teeNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pus ju quit'in aclamacaminiyauch ju cata'aktaijuyan. Ju yuchi cataxtuyanta la'ixmacni ju quimpai. Yuchi ju Spiritu Santu ju najun ju stavasalanti. Yuchach ju cataxtuyanta la'ixmacni ju quimpai. Chai acsni camina' ju yuchi pus caxt'ak'a' ju chivinti ju quilacata. ");
INSERT INTO teeNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Chai vachuch ju uxijnan anona'it'it ju tuch'i lakts'int'at'it ju icnavita ni quilach'ak'ok'atauch tus acsni ictai'ulacha ju amalaninti. ");
INSERT INTO teeNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Iclajuntauch junima taxtokni ni jantuch lai tam at'inomp'alat'it astan. ");
INSERT INTO teeNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Cataxcoxtuyan ju la'ixpujitat'an ju quint'a'israelitanin'an. Cachina' avilhchan va tichi chavaich ju catamakniyan catanonach ni chunchach ju na k'ox lhiulai ju Dios. ");
INSERT INTO teeNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Chux ju ani taxtokni chunch catanaviya' ni va jantu tamispai ju quimpai nin quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Yuchi iclalhijunauch ju ani taxtokni ni laich ap'ast'ac'a'it'it acsni tavanan chunch at'ap'asaya'it'it. Laich anona'it'it ni chunchach ju xaclajunau. Jantu xaclajuntau ju ani taxtokni ju p'ulhnan ni xaclat'avilauca'. Chai jantuca' lai tu'u' ixtapasai ju lami'atsucunti'an. ");
INSERT INTO teeNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Para ju chavai aclak'anchokoyach ju quimalakachatachilh. Para jantu xamati' ju milhi'uxijnan ju laich aquisacmiputulhch tas anchach ju ac'ana'. ");
INSERT INTO teeNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Va yuchi ni na alak'amak'anininat'itch ju ixlacata junima taxtokni ju iclajuntau. ");
INSERT INTO teeNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Para ju quit'in iclajunau ju stavasalanti. Akts'iya palai k'ox ju milacata'an ni ac'anchokolh ju lact'iyan. Acsni va jantu ac'anchokolh pus ju a'aktaijunu' jantu catitalakmin ju uxijnan. Para ni ac'ana' pus acmalakachatachilhch. ");
INSERT INTO teeNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Chai ju yuchi acsni camina' ca'amalacasuniya' ju lapanacni ixtalak'alhin'an. Chai ca'amalacasuniya' ju soknic'a atsucunti. Chai ca'amalacasuniya' ix'ulanica ixtalak'alhin'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ju yuchi ca'amalacasuniyach ju lapanacni ni alin ixtalak'alhin'an ni jantu quintalhilaca'an ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ju yuchi camalacasuya' ju soknic'a atsucunti. Chai putasui ni soknic'a ju qui'atsucunti ni aclak'anchokoyach ju quimpai chai jantuch vana aquintilalakts'iu. ");
INSERT INTO teeNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ju yuchi camalacasuniya' ju lapanacni ni ulai talak'alhin ju Dios ni muc'anicantach ju ixtalak'alhin ju anu' xak'ai ju a'okxchok'oi tachi chun ju lapanacni ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Na lhu taxtokni ju iclajumputunau. Para ju chavai jantuch lai at'it'ast'ucnit'it. ");
INSERT INTO teeNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Para acsni cachina' ju Spiritu Santu ju najun ju stavasalanti pus yuchi ju catamasuniyan tachi chun ju stavasalanti. Chunch ju canaviya' ni jantu va ixchivinti is'akstu ju canona'. Para tachi chun ju k'asmatni ju Dios yuchach ju canona'. Chai catamac'atsanik'oyanch tachi chun ju taxtokni ju camina'. ");
INSERT INTO teeNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ju yuchi ni ca'amalaninina' ju quinchivinti chai catamamachakxaniyanch ju lamintac'atsan'an pus capumalacasuya' ni icxak'ai. ");
INSERT INTO teeNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tachi chun ju ix'anu' junita ju quimpai sich qui'anu' vachu'. Yuchi iclhinajunch ju chavai ni ca'amalaninina' ju Spiritu Santu ju quinchivinti chai catamamachakxaniyan lamintac'atsan'an. Vachu' chani ju ajuni ju ix'amamaka'un ju Jesús: ");
INSERT INTO teeNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","―Vaninch minta ju avilhchan acsni jantuch aquilalakts'inau. Chai acsni catapasaya' lakatam lakat'ui avilhchanch aquilalakts'inchokoyauch. Chai astan aclak'anach ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ju acsnich ju ali'in ju ix'amamaka'ui ixtalajunich ju sia yu'unch: ―Tijuch nu' ju ani ju quintajumputunan ni najun: “Vaninch minta ju avilhchan acsni jantu aquilalakts'inau”. Chai ni nompalai: “Acsni catapasaya' lakatam lakat'ui avilhchan aquilalakts'inchokoyauch”. Chai ni najun: “Aclak'anach ju quimpai”. ");
INSERT INTO teeNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ixtanajunch: ―Tijuch nu' ju nomputun ni va najun ni vanin minta ju avilhchan. Jantu machakxayau tuchi ju najunch. ");
INSERT INTO teeNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Pus ju Jesús amachakxanilh ni va istasacmiputunch. Pus ajunich: ―Ja lasacmiyat'it ju va milhi'akstu'an ju tuchi xaclajunau acsni xacnajun ni vaninch minta ju avilhchan acsni jantu aquilalakts'inau. Chai ni xacnajun ni acsni catapasaya' lakatam lakat'ui avilhchan aquilalakts'inchokoyau. ");
INSERT INTO teeNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Slivasalh ju iclajunau. Ju uxijnan ak'alhununa'it'it. Chai amak'aninina'it'it. Para ju lapanacni ju jantu quintalhilaca'an catak'achanach. Ju uxijnan mas amak'aninina'it'it para ju astan ac'apk'oya'it'it ju mi'amak'anit'an. Ak'ach'ana'it'it. ");
INSERT INTO teeNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ju tam chako'ulh acsni calok'omputunach na mak'alhk'ajnan ni chintach ju ix'avilhchan. Para acsni catapasaniyach ju ix'amaklak'avanti pus jantuch pastacpalai ju ixmak'alhk'ajnat. Va lhik'achanch ni maklak'ajuntach pumatam lapanac. ");
INSERT INTO teeNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Pus chunchach vachu' ju uxijnan. Ju chavai slivasalh ni na amak'anininat'it. Para acsni aclalakts'inchokoyauch pus na ak'ach'anch'ok'oya'it'it ju lami'alhunut'an. Chai jantu lai xamati' catitatai'inin ju mink'achat'an. ");
INSERT INTO teeNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ju acsni avilhchan jantuch tu'u' aquilasq'uiniyau ju quit'in. Slivasalh ju iclajunau. Tachi chun ju asq'uiniya'it'it ju quimpai ju laquintapaka'utch cataxtakniyan. ");
INSERT INTO teeNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tus chavai jantu tu'u' sq'uint'at'it ju laquintapaka'ut. Asq'uint'it chai amaklht'ayanana'it'it. Ju chunch slivasalh alhik'ach'ana'it'it ju lami'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Junima taxtokni iclalhixak'alatau ju isp'umisp'at'it ju stavasalanti. Para jantu lai xaquilamachakxaniyau. Para cachina' ju avilhchan acsni jantuch aclalhixak'alayau ju va ap'umisp'aya'it'it ju stavasalanti. Ju acsnich lana vas aclajunau ixlacata ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ju acsni avilhchan asq'uina'it'it ju laquintapaka'ut chai jantu iclajunau ni quit'inch ju actapaininiya' ju quimpai ju milacata'an. ");
INSERT INTO teeNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Jantu tasq'uini ni chun aclalh ni is'akstu ju quimpai ju tamapainiyan va ixlaca'atalh ni quilamapainiyauch ju uxijnan chai lac'a'it'at'itch ni la'ixmacni Dios ju icmintacha. ");
INSERT INTO teeNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","La'ixmacni quimpai ju xactaxtuyacha. Icminta ju ani lacamunutpa'. Aktam acmaconchokopala' ju lacamunutpa' chai aclak'anchokoyach ju quimpai. ");
INSERT INTO teeNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ju ix'amamaka'ui ju Jesús tajunich: ―Ju chavai vasch quilajunau. Jantu va lacatu'u' ju quilapumamachakxaniyau ju stavasalanti. ");
INSERT INTO teeNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ju chavai icc'atsayauch ni misp'aich tachi chun ju taxtokni. Jantu tasq'uini ni xamati' casacmin tu'u' ni misp'ak'o'ui ju qui'atalacpast'ac'at quinc'an. Yuchi ju icpulaca'iyauch ni la'ixmacni Dios ju t'ant'a. ");
INSERT INTO teeNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ajunich ju Jesús: ―Ja lac'a'iyat'itch ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cachinach ju avilhchan chai mas chavaich acsni amakp'its'ic'ana'it'it. Ju pumatamin ca'ana' la'ixlakchaka'an. Aquilamacoyoyauch. Para jantu va qui'akstu ju actitamacaulh ni quimpai ju quint'avi. ");
INSERT INTO teeNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Chai iclajunauch ju ani taxtokni ni jantu calac'alh ju mi'alhunut'an. Jantu catilac'alh ju mi'alhunut'an ni quilalhilaca'anau ju quit'in. Ju ani lacamunutpa' na amak'alhk'ajnana'it'it. Para jantu at'alhanant'it. Ju quit'in ictai'initach ju ixtachaput ju lhinajun ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Acsni nonk'olhch ju Jesús ju ani taxtokni pus laca'alh ju lact'iyan chai naulh: ―Quimpai chilhch ju qui'avilhchan. Amalac'asuninch ju lapanacni ni icxak'aich ju quit'in ni mints'alh. Ju chunch laich vachu' ac'amalacasuniyach ju lapanacni ni xak'aich'at ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Chai uxint'i ju q'uixt'aknit'a ju quimpuxa'ucxtin ni laich ac'alhijuna' tachi chun ju lapanacni. Ju chunch lai ac'axtakniya' ju is'atsucunti'an jonk'alhita tachi chun ju q'uimak'axt'aknit'ach ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ca'alinach ju is'atsucunti'an jonk'alhita acsni catalhilaksiyanch ni va uxint'i ju istavasalanti Dios'at. Chai aquintalhilaksiyach ju quit'in ni icJesucristo chai ni uxint'i ju xaq'uimalak'ach'ayachit'a. ");
INSERT INTO teeNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ju quit'in ic'amalacasunilhch ju lapanacni ni xak'aich'at. Icnavik'olhch ju lhich'alhcat ju xaq'uilhi'unich ixnavica. ");
INSERT INTO teeNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Pus ju chavai ji quimpai aq'uixt'aknich'ok'och ju quimpuxak'ai ju lamimacni tachi ju xacjunita acsni vaninca' xact'avilhchan. Acsni tuca' ix'alin ju lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Uxint'i ju sa'asacxt'ui ju ani tavilanalh lapanacni ju quintat'a'alhtanan. Asacxt'uch la'ixlhiyu'unch ju jantuca' quintalhilaksi chai q'ui'amak'axt'aknit'ach. Pus ju quit'in ic'amamachakxanilh ta yu unit'a. Ju yu'unch mi'anu' ixtajunita chai q'ui'amak'axt'aknit'a. Chai ju yu'unch tamuctaxtulh ju ixlhina'unt'a ixnavica. ");
INSERT INTO teeNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ju chavai tamispaich ni sich mi'anu' junita tachi chun ju taxtokni ju xaq'uixt'akni. ");
INSERT INTO teeNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ju tuch'i xaq'ui'unich ic'ajunilh ju yu'unch. Chai ta'amaklhtayanalh. Talaca'ilhch ni vasalh lamimacni ju ictaxtuta. Chai talaca'itach ni uxint'i ju xaq'uimalak'ach'ayachit'a. ");
INSERT INTO teeNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iclhitapaininiyan ji quimpai ju ixlacata'an ju yu'unch. Jantiyu' ji quimpai ju iclhitapaininiyan ju ixlacata'an ju ali'in lapanacni ju jantu quintalhilaca'an. Para va yu'unch ju iclhitapaininiyan ju ani tavilanalh ju xaq'ui'axt'aknich ni mi'anu' tajunita vachu'. ");
INSERT INTO teeNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tachi chun ju quilapanacni sich mi'anu'. Chai ju milapanacni sich qui'anu'. Chai la'is'atsucunti'an ju yu'unch putasui ni icxak'ai. ");
INSERT INTO teeNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ju quit'in va lacats'unin c'acx tus actaxtuyach ju ani lacamunutpa'. Aclak'anchokoyan ji quimpai ju na salaka'at. Para ju yu'unch catitatsucuya' ju ani lacamunutpa'. Pus alhist'act'ich ji quimpai ju yu'unch ju xaq'uixt'akni ni na tachapun'at ju uxint'i. Alhist'act'ich ni va lakatamch catava tachi ju quijnanch'an ni va lakatamch juntau. ");
INSERT INTO teeNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Acsni xac'alact'avilhca' ju yu'unch ju ani lacamunutpa' pus quit'in ju xac'alhist'ac'a lamintachaput. Yu'unch ju xaq'ui'axt'akni quit'in ju xac'alhist'ac'a. Jantu xamati' xats'ank'ai sia yu'unch. Va yuchi ju anu' lapanac ju akts'iya ixlhilhca'ulacanta ni cats'ank'ayach. Yuchi ju xats'ank'ak'alhich. Va pu'uctaxtulh tachi ju ts'okcantach. ");
INSERT INTO teeNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Pus ju chavai ji quimpai iclakmintan ju uxint'i. Icnajun ju ani chivinti acsni icvilhca' ju ani lacamunutpa'. Ju chunch ju quilapanacni catak'asmat'a' ju tuchi ictapaininiyan ju ixlacata'an chai slivasalh capu'alina' ju ixk'achat'an la'ix'alhunut'an tachi ju ick'achanch ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ju quit'in ic'ajunita ju minchivinti ju quilapanacni. Chai ju ixt'alapanacni'an ju ani lacamunutpa' talhixcailh ju quilapanacni ni jantu amachak'an lacamunutpa' tajunita ju chavai. Tachi ju quit'in ni vachu' jantu ic'amachaka' ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Jantu iclhitapaininiyan ni va amak'osut'i ju ani lacamunutpa' ju quilapanacni. Va iclhitapaininiyan ni alhist'ac'a' ni jantuch ca'okxchok'oya' ju ixnavini macxcai. ");
INSERT INTO teeNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ju yu'unch jantu amachak'an lacamunutpa' tajunita ju chavai. Tachi ju quit'in ni vachu' jantu ic'amachaka' ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ju minchivinti stavasalanti. Pus salaka anavit'i ju yu'unch acsni catalhitamaka'uya' ju minchivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Tachi ju uxint'i ni q'uimalak'ach'achit'a ni acmilh nona' ju minchivinti ju ani lacamunutpa' pus vachu' ju quit'in ic'amalakachalh ju ani quilapanacni ni cata'alh nonin ju minchivinti ju ani lacamunutpa'. ");
INSERT INTO teeNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Chai ixlaca'atalh'an yu'unch ju icpumak'axtakchokocan qui'akstu. Ju chunch vachuch ju yu'unch aquintamak'axtakniyach ju is'atsucunti'an ni tamispai ju minchivinti. Chai yuchach ju stavasalanti. ");
INSERT INTO teeNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Jantu iclhitapaininiyan ju va ixlaca'atalh'an ju akts'iya quilapanacnich. Para vachu' iclhitapaininiyan ixlacata'an ju catalaca'iyach ixchivinti'an ju quilacata. ");
INSERT INTO teeNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ictapaininiyan ni va lakatamch catava ixchux'an. Tachi ju uxint'i chai ju quit'in ni va lakatam Dios juntau ji quimpai. Pus vachu' chunch ju yu'unch va lakatamch aquintat'ajunan ju laquimacni'an. Chai ju lapanacni ju jantu quintalhilaca'an acsni catalakts'ina' ni va lakatam junk'otauch pus catalaca'iyach ni uxint'ich ju q'uimalak'ach'at'achit'a. ");
INSERT INTO teeNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ju quit'in ic'alak'ayata ju yu'unch tachi ju uxint'i ni q'uilak'ayat'a. Chai ni vaklhtam chun alak'ayacanta pus va lakatamch catajuna' ju yu'unch tachi ju quijnan'an ni va lakatamch juntau. ");
INSERT INTO teeNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ju quit'in la'ix'alhunut'an ju yu'unch actsucuya'. Chai ju uxint'i ni va lakatam q'uint'a'unit'a pus va lakatamch cajunk'oyauch. Chai ju lapanacni ju jantu quintalhilaca'an acsni catalakts'ina' ni va lakatamch jonk'otauch pus catalaca'iya' ni uxint'i ju xaq'uimalak'ach'ayachit'a. Chai chunch ju catapuc'atsayach ni amap'ainit'ach ju quilapanacni tachi ju q'uimap'aini ju quit'in. ");
INSERT INTO teeNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Quimpai ju yu'unch ju qui'axt'aknit'a iclacasq'uinch ni vachuch anch catatsucuyanta junta actsucuya' ju quit'in. Ju chunch ni laich catalakts'ina' ju quimpuxak'aich ju xaq'uixt'aknich. Tus acsni matica' ixjunita ju lacamunutpa' xaq'uixt'aknit'ach ju quimpuxak'ai ni na q'uimap'aini. ");
INSERT INTO teeNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ji quimpai soknic'a ju navi ju uxint'i. Ju lapanacni ju jantu quintalhilaca'anta jantu tamispayan. Para ju quit'in icmispayan. Chai ju quilapanacni tamispaich ni uxint'i ju xaq'uimalak'ach'ayachit'a. ");
INSERT INTO teeNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ic'amamispanilhch ta yu unit'a. Chai ac'amamispanichokoyach ni iclacasq'uin ni catalamapaini tachi ju uxint'i ni q'uimap'ainich ju quit'in. Chai ju quit'in actsucuyach la'ix'alhunut'an ju quilapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ju Jesús acsni nonk'o ju ani chivinti alact'ataxtulh ju ix'amamaka'ui. Alact'a'alh ju lhimak'antacutni ju xaxk'ati Cedrón junta ixch'ancan xaq'uiu ju olivo. Anch ju alact'atanuchalhch ju Jesús ju ix'amamaka'ui. ");
INSERT INTO teeNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chai vachu' ju anu' lapanac ju Judas ixjuncan ismispaich ju anu' pu'olivos. Yuchi ju Judas ju camak'axt'ak'ach ju ix'ucxtin. Pus ni na paklhu ju ix'alact'aquilata ju anch ju Jesús ju ix'amamaka'ui pus yuchi ixlhimispaich ju Judas ju anu' pu'olivos. ");
INSERT INTO teeNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Judas ju ap'ulhnilh ju ixtaropajni ju k'ai ucxtin chai ixtaropajni ju xalack'ajinch palijnich chai ju fariseonin. Pus ju yu'unch ixtalhi'anta ixlacmaclhcu'an chai ixk'a'ichi'an chai ixmachita'an. ");
INSERT INTO teeNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ju Jesús ni isc'atsak'ojuich tachi chun ju taxtokni ju catapasayach la'is'atsucunti pus va k'oxiya qui'apakxtoklh. Ajunich: ―Tis chavaich ju p'uxc'oyat'it. ");
INSERT INTO teeNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Chai tajunich: ―Yuchi icpuxcoyau ju Jesús ju amachaka' Nazaret. Chai ju Jesús ajunich: ―Pus quit'inch ju quilapuxcoyau. Ju Judas ju xa'amak'axtakna' ix'alact'amintach. ");
INSERT INTO teeNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Chai acsni naulh ju Jesús ni yuchach pus lana tin tapu'alh ixpulacan'an chai lana tatamak'ocha. ");
INSERT INTO teeNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Aktam asacmichokopa ju Jesús. Ajunich: ―Tis chavaich ju p'uxc'oyat'it. Tanonchokopa ju taropajni: ―Yuchi ju Jesús amachaka' Nazaret. ");
INSERT INTO teeNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Chai aktam ajunchokopa ju Jesús: ―Ni iclajumpalauch ni quit'inch. Pus ni quit'inch ju quilapuxcoyau pus chach ta'ancha ju ani tayanalh. ");
INSERT INTO teeNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Chunch ju pu'uctaxtulh ju chivinti ju ixnajunta ju Jesús acsni chani naulh: “Ju yu'unch ju q'uixt'aknit'ach jantu xamati' icmak'ats'ank'ata”. ");
INSERT INTO teeNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ju acsnich ju Simón Pitalu' ni ixch'apata ju ixmachita pus lana xak'axtulh laxa'axt'ak'an. Lana catuchakxlh ju ixlapanac ju xak'ai pali. P'uxnilh ju ix'ak'axk'olh la'ixcatucana. Chai ju yuchi ixlapanac ixjunita ju xak'ai pali ju Malco ixjuncan. ");
INSERT INTO teeNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ju acsnich ju Jesús junilhch ju Pitalu': ―Amak'ach'ok'och ju mimachita laxa'axt'ak'an. Ju anu' na ts'inq'ui mak'alhk'ajnat ju quilhilhcatach ju quimpai ja va na'un ni jantu acmuctaxtuya'. ");
INSERT INTO teeNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ju acsnich ju taropajni chai ju xacomandante chai ju xataropajnich ju israelitanin lana tach'apalh ju Jesús. Tach'in tanavi. ");
INSERT INTO teeNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","P'ulhnan talhi'anilh la'ixpu'ucxtin ju Anás. Ju yuchi ixput'ijok'at ixjunita ju Caifás. Yuchi ju xak'ai pali ixjunita ju acsni c'ata. ");
INSERT INTO teeNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ju ixjuncan Caifás yuchi ju ix'amap'aksi ju ist'a'israelitanin. Ix'ajunich ni akts'iya istasq'uini ni canilh pumatam jok'at ixlacata'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ju Simón Pitalu' chai ju apumatamch ixt'atamaka'un yu'unchach ju ixtach'ak'ok'ata ju Jesús acsni lhi'ancalh tach'in. Chai ju xak'ai pali na ixt'alamispaich ju anu' pumatam chai yuchi lhit'amapasacalh ju Jesús ju yuchi la'ixpulacni junta ixlakachak'axnucanta ju ixchaka' ju xak'ai pali. ");
INSERT INTO teeNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Para ju Pitalu' va makspa' taya laxamalhtich. Pus taxtuchilh ju anu' ixt'atamamaka'un. Ju yuchi ni na ixt'alamispaich ju xak'ai pali pus tapaininilh ju anu' atsi' ju ixlhistacna' ju malhtich. Chai acsnica' ju tanulh ju Pitalu'. ");
INSERT INTO teeNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ju acsnich ju anu' atsi' ju ixlhistacna' ju malhtich junich ju Pitalu': ―Ju uxint'i ja jantu vachu' ixlapanac'at ju anu' jok'at. Pus ju Pitalu' naulh ni jantu. ");
INSERT INTO teeNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Chai ixtayanalh ju xalapanacnich anch chai ju ixtaropajni ju xalack'ajin palijni. Chai ixtamalhculata ni na lhic'asnin ixjunita. Va ixtalacsk'onvilanalh. Chai ju Pitalu' vachuch anch maktaya ni va isk'omputunch. ");
INSERT INTO teeNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ju xak'ai pali sacmilh ju Jesús ixlacata ju ix'amamaka'ui chai tuchi ju ix'alhimalanich ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ju Jesús ak'alhtayanalh: ―Ju quit'in xacchivinin la'ix'ucxlacapu'an ju ixtalhavat lapanacni. Chai lamilacpujitat'an chai lacak'ai mimpujitat'an xac'amalani ju ixchivinti Dios junta akts'iya ixtatak'aixt'ok'ach ju quint'a'israelitanin'an. Jantu tu'u' ju va sek xacnajun. ");
INSERT INTO teeNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Tajuch ni va q'uisacmip'alai. Asacmit'ich ju lapanacni ju tak'asmat'ach ju tuchi xac'ajunich. Ju yu'unch tac'atsaich tuchi ju xac'ajunich. ");
INSERT INTO teeNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Acsni naulh ju chunch ju Jesús pus ju pumatam taropa ju ixmakyalh anch lanach paknisalh ju Jesús. Junich: ―Ja chunchach ju alhik'alht'aya' ju xak'ai pali. ");
INSERT INTO teeNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Chai ak'alhtayanalh ju Jesús: ―Ni jantu sok ju xacnajun pus anauch tas anchach ju jantu soknic'a. Para ni soknic'a ju xacnajun t'as ni va xaq'ui'ulanich. ");
INSERT INTO teeNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ju acsnich ju Anás tach'in malakachachokopa ju Jesús junta ixvilhcha ju Caifás ju xak'ai pali. ");
INSERT INTO teeNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pus ju Simón Pitalu' anch ixyak'alhi junta ixt'ajun sk'onu'. Tajunich: ―Ja jantu vachu' uxint'i ju ixtamamaka'un'at ju anu' lapanac. Para ju Pitalu' naulh ni jantu. ");
INSERT INTO teeNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chai ju pumatam ixlapanac ju xak'ai pali ixlhilak'au ixjunita ju anuch ju catuchakxp'uxlh ju Pitalu'. Yuchach ju sacmichokopa ju Pitalu'. Junich: ―Ja jantu iclakts'inchan ju lacapu'olivos junta ixvilhcha ju anu' lapanac. ");
INSERT INTO teeNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pus ju Pitalu' aktam nonchokopa ni jantu mispai. Chai lanach t'asalh ju puyux. ");
INSERT INTO teeNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Chai lana maxtucalh ju Jesús ju la'ixchaka' ju Caifás. Talhi'alhch la'ixpu'ucxtin ju xagobernador Roma. Vats'isinca' ixjunita. Para ju israelitanin jantu tatanulh ju lacapu'ucxtin ni jantu ixlhijun ju la'ixlhamap'aksin'an ni lai catatanu ni jantu ixlak'oxicanta ju anu' pu'ucxtin. Ni jantu catatanuya' ju lacapu'ucxtin pus laich catalhic'ataniya' ju ixborrego'an ni catuncunchokoya' chai laich cata'uyach. ");
INSERT INTO teeNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pus ju gobernador Pilato acsni taxtuchilh ju la'ixpu'ucxtin ajunich ju lapanacni: ―Tijuch ju lhich'ivimak'anat'it ju ani ya jok'at. ");
INSERT INTO teeNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Chai ta'ak'alhtayanalh ju lapanacni. Tanajunch: ―Ni jantu cava alin ixtalak'alhin pus jantu cava xaclamak'axtakniu. ");
INSERT INTO teeNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pus ju Pilato chanich ajunich acsni ak'alhtailh ju lapanacni: ―Alaich alhip'inchit'it mi'akstu'an. Alakts'int'itch ta yu najunch lamilhamap'aksin'an. Para ju israelitanin tanaulh: ―Jantu lhijun ju lhamap'aksin ni acmakniu tam xamati' ju quijnan ju israelitanin icjuntau. ");
INSERT INTO teeNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Acsni naulh ju chunch pus uctaxtulh ju tuchi ixnajuntach ju Jesús ixlacata tuchi anintich ju capuniya'. ");
INSERT INTO teeNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ju acsnich ju gobernador Pilato tanuchokopa ju la'ixpu'ucxtin. T'asanilh ju Jesús. Junich: ―Ja uxint'ich ju xa'ucxtin'at ju israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ju acsnich ju Jesús k'alhtailh. Junilh ju Pilato: ―Ja va mi'akstu xap'ast'ac'a ju ani xaq'ui'uni u va xamati' juntan. ");
INSERT INTO teeNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ju Pilato lhik'alhtailh: ―Ja ic'israelita ni laich acnaulh ni xak'aich'at. Yu'unch ju mint'a'amachak'an chai ju xalack'ajin palijni ju xatamak'axt'ak'an ju laquimacni. Tijuch ju xa'anavini. ");
INSERT INTO teeNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ak'alhtayanalh ju Jesús: ―Ju quimpu'ucxtin jantu xanavin ju ani lacamunutpa'. Ni ani lacamunutpa' cava ju quimpu'ucxtin pus ca'ixtalasa ju quilapanacni. Ju chunch jantu lai ca'ixquintitach'apalh ju quint'a'israelitanin. Para jantu ani ju quimpu'ucxtin. ");
INSERT INTO teeNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ju acsnich ju Pilato junich: ―Ja vasalh'as ni ucxtin'at. Chai ak'alhtayanalh ju Jesús: ―Vas ju na'un ni ic'ucxtin. Yuchi xaclhilak'ajunch ju ani lacamunutpa'. Chai iclhimilhch ju ani lacamunutpa' ni laich ac'ajuna' ju lapanacni ju stavasalanti. Tachi chun ju tak'achani ju stavasalanti tak'asmat'a ju quinchivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Chai ju Pilato asacmininch: ―Tijuch ju stavasalanti. ―Juncanch ju Jesús. Acsni naulh ju ani pus alak'anchokopa ju israelitanin ju gobernador Pilato. Ajunich ju yu'unch: ―Jantu tu'u' iclhitajuni ixtalak'alhin ju ani lapanac. ");
INSERT INTO teeNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pus aquilajuniuch tichi tach'inch ju aclhinona' ixmaxtuca ju lacapulach'in tachi ju akts'iya lhilanit'at'it acsni uyat'it ju mimborrego'an tachi ju chavaich c'atan. Ja lac'asq'uinat'it ni yuchi ju acmaxtulh ju mi'ucxtin'an ju uxijnan ji israelitanin. ");
INSERT INTO teeNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ju acsnich ixchux'an p'as talacchivinchokopa. Tajunich ju k'ai ucxtin: ―Jantiyu' ju iclacasq'uinau. Yuchi ju calacamaconcana' ju Barrabás. Pus ju Barrabás va ak'alhona' ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ju acsnich ju gobernador Pilato lana lhinaulh ixmaxtuca ju Jesús chai lhinaulh ixlakanekmaca. ");
INSERT INTO teeNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ju ixtaropajni ju gobernador tanavinilh ixcorona ju Jesús si alhtucunu'. Chai tamalacpatanulhch. Chai tamalakch'inilhch smumu pumpu' tachi ixtalakch'i ju xalack'ajin ucxtinin. ");
INSERT INTO teeNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Lacats'i'it ixtajunich ju Jesús: ―Ats'uc'uk'alhit'i ji xa'ucxtin israelitanin. Chai slivasalh ixtalacasamai. ");
INSERT INTO teeNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ju acsnich ju gobernador Pilato taxtuchokopa ju makspa'. Ajunich ju lapanacni: ―Anich iclalhiminitau ni laich ap'uc'ats'aya'it'it ni jantu tu'u' talak'alhin xaclhitajuni ju ani ya lapanac. ");
INSERT INTO teeNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Pus ju Jesús lana taxtulh ju makspa'. Ixlacpatanunch ju ixcorona ju si alhtucunu'. Chai ixlakch'itach ju smumu pumpu'. Chai ju gobernador Pilato ajunich: ―Alakts'int'itch ju ani ya lapanac. ");
INSERT INTO teeNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Acsni talakts'ilh ju xalack'ajin palijni chai ju ixtaropajni pus p'as talacnaulh: ―Amaq'uilht'at'ich ju lacacurus ju anu' lapanac. Para ju Pilato ajuni: ―Alai uxijnan alhip'inchit'itch. Amaq'uilht'achit'itch uxijnan. Ju quit'in jantu tu'u' xaclhitajuni ju ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Chai ta'ak'alhtayanalh ju israelitanin: ―Ju quijnan alin ju quilhamap'aksin quinc'an. Chai ju laquilhamap'aksin quinc'an najun ni tasq'uini ni canilh ju ani ya ni va ixnajun ni ists'alh Dios junita. ");
INSERT INTO teeNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pus ju Pilato acsni k'asmatlh ju ani chivinti palai na talhanalh. ");
INSERT INTO teeNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Tanuchokopa aktam ju la'ixpu'ucxtin chai sacmichokopa ju Jesús ni ixtanumachokolhch ju yuchi: ―T'as anchach ju xat'anachi'. Para ju Jesús jantu tu'u' lhak'alhtayanalh. ");
INSERT INTO teeNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ju acsnich ju gobernador Pilato junich: ―Ja jantu tu'u' aq'uinlhik'alht'aya'. Ja jantu c'ats'ai ni alin ju quintachaput ni lai aclhinaulh ju mimaquilhtaca ju lacacurus. Chai alin ju quintachaput ni laich acmak'alhtaxtun. ");
INSERT INTO teeNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Chai ak'alhtayanalh ju Jesús: ―Jantu lai tu'u' xaq'uint'inavit'i ni jantu cava Dios ju xalak'a'i ni aq'uimamak'alhk'ajniya'ich. Chai ju quit'in yuchi iclhijunan ni palai k'ai talak'alhin ju lhi'an ju xaquimak'axt'ak'a ju lamimacni. Palai jantu ju uxint'i. ");
INSERT INTO teeNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pus ju acsnich ixnajunch ju gobernador Pilato ni lai ca'ixmak'alhtaxtulh ju Jesús. Para ju israelitanin p'as ixtajuni ju Pilato: ―Ni amak'alht'axt'uya' ju ani ya lapanac pus jantu ix'amigo'at ju César ju xak'ai tucan lamilhi'uxijnan ju romanonin unt'at'it. Ju va k'aya k'ostayai chai cajumputulh k'ai ucxtin chux ju lacat'un pus ixt'alaxcaich junita ju César. ");
INSERT INTO teeNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Chai ju gobernador Pilato acsni k'asmatlh junima chivinti pus maxtuchokopa makspa' ju Jesús. Tavi lacapu'ucxtin junta ixmamacanta cemento. Lacalhihebreo ju anch ixjuncan Gabata. ");
INSERT INTO teeNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pus ju ixlhicutanch ixtapasata ju ixlacc'atanit'an ju israelitanin acsni ta'ulh ju ixborrego'an. Chai acsni tuncunchokolh acsnich ju mak'osaspitlh ju Jesús ju Pilato. Chai ju israelitanin vachu' acsnich ju ixtalakasilak'oxi'ulai ju ixvaiti'an ni pa'astacni cajuna' ni catuncunchokoya'. Pus vats'isin tsucucalh mak'osaspitca ju Jesús. Chai ju Pilato chani ajuni ju israelitanin: ―Alakts'int'itch ju xak'ai mi'ucxtin'an. ");
INSERT INTO teeNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Para ju yu'unch p'as tanaulh: ―Amak'osut'ich. Amaq'uilht'at'ich ju lacacurus. Chai ju Pilato ajunich ju lapanacni: ―Ja acmaquilhtaya' ju mi'ucxtin'an ju lacacurus. Ta'ak'alhtayanalh ju xalack'ajin palijni: ―Mati' apumatam qui'ucxtin quinc'an. Va yuchi ju César. ");
INSERT INTO teeNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pus ju Pilato acsnich ju mak'axtaklh ju Jesús la'ixmaca'an ju lapanacni ni catamaknilh ju Jesús. Ta'amaklhtayanalh ju Jesús. Talhi'alhch. ");
INSERT INTO teeNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Chai tamakxk'ok'alh ju iscurus ju Jesús. Talhi'alhch junta ixjuncan Aktsulh. Ju lacalhihebreo ixjuncan Gólgota. ");
INSERT INTO teeNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Anchach ju tamaquilhtachalhch ju Jesús chai ju ali'inch ixt'iyun'an. Ju pumatam la'ixlhicana ju maquilhtacalh la'iscurus chai ju apumatam la'ixlhimacx ju maquilhtacalh ju la'iscurus. Chai ju Jesús tamaquilhta la'ixlacaitati. ");
INSERT INTO teeNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ju gobernador Pilato ts'oklh lakatam chivinti. Lhinaulh ixmuc'anica la'is'aktsulh ju iscurus ju Jesús. Ju anu' ats'oknut ixnajun: “Yuchi ju Jesús amachaka' Nazaret. Yuchi ju k'ai ix'ucxtin'an ju israelitanin”. ");
INSERT INTO teeNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Na lhu israelitanin ju ixtalakts'in junima chivinti ni vanin ixvi ju lak'achak'an junta ixquilhtai ju Jesús. Ju anu' chivinti ists'okcanta lacalhihebreo chai lacalhigriego chai lacalhilatin. ");
INSERT INTO teeNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ju xalack'ajin ixpalijni ju israelitanin tajunich ju gobernador Pilato: ―Jantu ats'okt'i ni yuchi ju ix'ucxtin'an ju israelitanin. Palai k'ox ni canaulh: “Ju ani ya ixnajun ni xa'ucxtin israelitanin ixjunita”. ");
INSERT INTO teeNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Chai ak'alhtayanalh ju Pilato. Ajunich: ―Ju tuchi xac'ats'oknun yuchach. ");
INSERT INTO teeNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ju taropajni acsni tamaquilhta ju la'iscurus ju Jesús tasacnilh ju ixlacpumpu' ju Jesús junta ixmamanicanta. Chai ni lakat'at'i ixjunita ju ixpumpu' pus lakatamin talhi'alh ju pumatamin taropajni. Chai vachu' ix'alin lakatam ju ixpumpu' ju Jesús ju jantu isputs'apancanta. Lana va chunch ixlhinavicanta. Tachi ju va ixmak'anch'ich. ");
INSERT INTO teeNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Chai talaclajunich ju sia yu'unch ju anuch taropajni: ―Jantu catipuk'exvi ju ani pumpu'. Alai va calhilaslajvi. Catasuyach tichi chavaich ix'anuch cajuna'. Ni chunch ju tanaulh pus uctaxtulh ju ats'oknut junta chani najun: “Pumatamin lhi'alh ju quimpumpu'. Chai ju lakatam quimpumpu' talhilaslajlh”. Pus chunchach talalh ju taropajni. ");
INSERT INTO teeNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ju ixnatich ju Jesús chai ju ixlak'auch ju ixnati ju ixtalakasilak'oxi'ulai ju ixvaiti'an ni pa'astacni cajuna' ni Cleofas chai ju Malia amachaka' Magdala vanin ixtayanalh junta ixmuc'acanta la'iscurus ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ju Jesús acsni lakts'ilh ju ixnati chai ju ixtamamaka'un ju na ixmapaini ni vanin ixtayanalh pus junich ju ixnati: ―Quinati yuchach ju ani ju mints'alh ju chavai. ");
INSERT INTO teeNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Astan junich ju ixtamamaka'un: ―Yuchach ju ani ju minati ju chavai. Pus tus acsni avilhchan ju anu' ixtamamaka'un ju Jesús malhistacnilh ju ixnati ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Chai acsnich ju c'atsalhch ju Jesús ni ixnavik'ota tachi chun ju lhich'alhcat ju ilhcanita ju ixpai pus naulh: ―Na icquicxixtach. Chunchach ju naulh ni capu'uctaxtulhch ju ats'oknut. ");
INSERT INTO teeNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Pus ju taropajni ixta'ulata tam xalu ju tu'u' tachi ju axvicnit. Pus ju acsnich lana tacatanch'imucalh la'ixquincati' ach'itin ju hisopo juncan ju tu'u' tachi p'ulhulh panimac. Chai tamalaktanunilh ju axvicnit. Chai talhi'anilh la'ixquilhni ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ju Jesús acsni quilhc'atsalhch ju anu' tachi axvicnit naulh: ―Uctaxtuk'olh ju chavai. Lana lilek navilh ju is'aktsulh chai acsnich ju nilh. ");
INSERT INTO teeNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ju acsnich ixlakasi'ulacan ju ixtaxtokni'an ju israelitanin ixlacata ju avilhchan pa'astacni. Pus ju yu'unch jantu talacasq'uilh ni va catamakatunculh ju lacacurus ju ixpumat'utu'an ni pa'astacni cajuna' ni catuncuna'. Chai ju anu' avilhchan pa'astacni k'ai c'atan cajuna'. Pus talhitapaininilh ju gobernador Pilato ni calaktek'enicalh ju ixch'aja'an ju anu' ixpumat'utu'an lapanacni ju ixtaquilhtananch ju lacacurus. Ju chunch lai palai vats'alhti k'ox cataniya' chai ni lai ca'ap'uxcalh. ");
INSERT INTO teeNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pus ju taropajni acsni tacha'alh junta taquilhtananch ju anu' lapanacni pus p'ulhnan tatek'enilh ju ixch'aja' ju pumatam. Vana chunch tanavipa ju apumatam ju anu' ju ix'at'amaquilhtacanta ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Para acsni talak'alh ju Jesús junta ixquilhtai talakts'ilh ni ixnitach ju yuchi. Pus jantu tach'antek'elh ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Para ju pumatam taropa lana lhtok'onilh la'ixpak'axti' ju Jesús la'islansa. Pus lana taxtunilh ju ix'ac'alhni. Va lhiya ju xcan. ");
INSERT INTO teeNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Pus ju quit'in iclakts'ilhch chai quit'in icnajun tuchi tapasalhch. Chai ju tuchi icnajun stavasalanti. Chai ju quit'in k'oxich icc'atsai. Chai iclajunau ju stavasalanti ni lai ap'ulac'a'iya'it'it vachu' ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Junima taxtokni chunchach ju navicalh ni chunchach ju capu'uctaxtuya' ju ats'oknut junta chani najun: “Ju yuchi jantu catitek'enicalh ju ix'alucutni”. ");
INSERT INTO teeNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Vachu' chani najun ju alakatam ats'oknut: “Catalakts'inach ju xatalhtok'oich”. ");
INSERT INTO teeNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pus ju José amachaka' Arimatea ixtamamaka'un ixjunita ju Jesús. Para va jantu ixlacasq'uin ni cac'atsacalh ni va ix'atalhoni ju xalack'ajin ist'a'israelitanin. Para acsni tapasak'olhch ju ani taxtokni pus ju yuchi alh tapaininini' ju gobernador Pilato ni laich cap'uxlh ju ixlacatuna ju lijunto Jesús. Chai ju Pilato lacasq'uinilh. Chai ju José lana alh p'uxnu' ju ixlacatuna ju lijunto Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Chai vachu' makach'ak'ok'analh ju Nicodemo. Yuchi ju quit'achivinilh ts'is ju Jesús. Ixlhi'antach ju pokxni ju na c'us ix'acamin. Ixlhinavicanta ju xaq'uiu mira chai ixlhiya ixk'alhchat ju xaq'uiu aloes. Tachi lakap'uxamcau kilo istats'inq'uita. ");
INSERT INTO teeNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Pus tap'uxlich ixlacatuna ju lijunto Jesús. Chai acsni ixtat'ajun lakapach'inin ju lacalhman pumpu' pus ixtalacamuc'a'antach ju anu' alak'oxinti pokxni ni chunchach ju ixtalhilanitach ju israelitanin acsni ixtalamacnuich. ");
INSERT INTO teeNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Junta ixmaquilhtacantach ju Jesús ix'alin lakatam pu'olivos. Chai ju anch lacapu'olivos ix'alin junta va lhucucu ixjunita lactalhpa. Ju anch jantuca' tavanan ixmamacanta ixlacatuna xamati'. ");
INSERT INTO teeNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Pus anch ju mak'acalh ixlacatuna ju lijunto Jesús ni vanin ixvi ju anu' junta lhucucu lactalhpa ixjunita. Va istasok'oi ni ixchimputun ju hora acsni jantu lai ixtach'alhcatnan ju israelitanin ni pa'astacni cajuna'. ");
INSERT INTO teeNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pus ju lacalhitumincu ju Malia amachaka' Magdala taxtulh ju lak'achak'an. Na vats'isin ixjunita. Ists'istaca' lacats'unin acsni cha'alh junta ixmamacanta ixlacatuna ju lijunto Jesús. Pus lakts'ilh ju chiux ni ixmak'osucantach. ");
INSERT INTO teeNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Pus ju yuchi lana ats'alaminchokolh lak'achak'an. Quilakts'ilh ju Simón Pitalu' chai ju ak'antam ixtamamaka'un ju Jesús ju na ixmapaini. Chai ajunich: ―Mak'osucantach ju ixlacatuna ju lijunto qui'ucxtin'an junta ixmak'acanta. Jantu icc'atsayau ta anchach ju xalhi'ancan. ");
INSERT INTO teeNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Chai lana t'ataxtulhch ju Pitalu' ju ixt'atamaka'un. Ta'alh lakts'inin junta ixmak'acanta ju ixlacatuna ju lijunto Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Chai lana p'as ixta'ats'ala'anta. Para ju anu' pumatam ixtamamaka'un ju Jesús palai vats'alhti cha'alh. Astan cha'alh ju Pitalu'. ");
INSERT INTO teeNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Pus ju p'ulhnan cha'alh ni lhan tantama talacnu pus va yuchi ju lakts'ilhch ju ixpulakapach'icanta ju Jesús ni va yuchi ju ixma. Para ju yuchi jantu tanulh. ");
INSERT INTO teeNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Chai chinchalh chavai ju Simón Pitalu' ni yuchi ju ixt'alataimatach ju p'ulhnan cha'alh. Pus ju yuchi lana tanu junta ixmamacanta ju ixlacatuna ju lijunto Jesús. Vana va yu' ju lakts'impa ju ixpulakapach'icanta ju Jesús ni va yuchi ju ixma. ");
INSERT INTO teeNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Vachu' lakts'ilh ju pumpu' ju ixpulakapach'inicanta is'aktsulh ju Jesús. Ju yuchi jantu vanin ixt'ama ju lhman pumpu'. Lacatam ixpach'i'ulacanta. ");
INSERT INTO teeNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Acsnica' ju tanulh ju anu' pumatam ixtamamaka'un ju Jesús ju p'ulhnan ixcha'anta. Chai acsni lakts'ilhch ju yuchi pus lana laca'i ni vasalh ixlok'onchokota ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Va jantuca' k'ox ixtamachakxai ju ats'oknut junta najunch ni tasq'uini ni cata'acxtuchokoya' ju Jesús junta ixmak'acanta ixlacatuna. ");
INSERT INTO teeNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ju acsnich ju ix'alacmamaka'ui ju Jesús lana ta'anchokolh la'ixlacchaka'an. ");
INSERT INTO teeNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pus ju yuchi ju Malia va makspa' ixya. Vanin junta ixmak'acanta ju ixlacatuna ju lijunto Jesús. Va ixk'alhuyalhch. Chai acsni ixt'ajun k'alhunu' pus talacnu ju pulacni junta lhucucu lactalhpa. ");
INSERT INTO teeNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Chai lakts'ilh pumat'ui anquilhnin ju ixtavilanalh. Ixtalakch'ita lacxnapapa ixpumpu'an. Ju pumatam ixvi junta ixlacpatai ju lijunto Jesús. Chai ju pumatam ixvi junta ixch'an'anta ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Tajunich ju Malia: ―Chako'ulh t'as ni va k'alhump'alai. Ju Malia ajunich acsni ak'alhtailh ju anquilhnin: ―Pus va talhi'alhch ju lijunto qui'ucxtin chai jantu icc'atsai ta anchach ju xatalhi'an. ");
INSERT INTO teeNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Acsni alact'achivink'olh ju anuch anquilhnin ju Malia pus talakasp'itlich chai lakts'ilh ni vanin ixya ju Jesús. Para jantu ismispai ni yuchi cava. ");
INSERT INTO teeNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ju Jesús junich ju Malia: ―Chako'ulh t'as ni va k'alhump'alai. Tis chavaich ju p'uxc'a'ui. Pus ju Malia va naulh la'ix'alhunut ni ca va islhistacna' ju anu' pu'olivos. Chai junich: ―Cumpari ni uxint'i ju xalhip'in aq'ui'unch tas anchach ju xalhich'ip'in ju ixlacatuna ju lijunto Jesús. Aclhi'anach. ");
INSERT INTO teeNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ju Jesús junich: ―Malia. Pus ju Malia ni talakasp'itchokolh xak'ala lacalhihebreo chai juni: ―Raboni. Ju chunch nomputunch: “Qui'amamaka'unu'”. ");
INSERT INTO teeNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ju Jesús junich: ―Tun aq'uilac'ach'ap'a ni jantuca' ic'an lakts'ini' ju quimpai. Para ap'inchich alakts'ini' ju quilhi'alak'avin. A'unchich ni ac'ana' lakts'ini' ju quimpai chai ju mimpai'an Dios. Ac'ana' lakts'ini' ju quiDios chaich ju miDios'an. ");
INSERT INTO teeNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Pus lana anchokolh ju lak'achak'an ju Malia amachaka' Magdala. Chai acsni cha'alh chani alacjunich ju ix'alact'atamaka'ui: ―Iclakts'ilhch ju qui'ucxtin'an. Chai yuchi ju xaquijuni ni aclajunau ju ani chivinti. ");
INSERT INTO teeNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ju acsnich lhitumincu ixjunita. Chai acsni tok'oxalhch ju anu' avilhchan pus ixtamalacchok'otach junta ixtatanumanalh ju ix'amamaka'ui ju Jesús ni va ixtatalhonich ju xalack'ajin ist'a'israelitanin. Chai acsni chincha ju Jesús jantu maklht'ek'a ju lacamalhtich. Para ni talhic'atsanalh yalhch la'ixlacaitat junta ixtavilanalhch ju ix'amamaka'ui. Chai ajunich: ―Jantu calac'alh ju mi'alhunut'an ju uxijnan. ");
INSERT INTO teeNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Acsni naulh ju ani pus alacmalacasunilh ju ixmaca' chai la'ixpak'axti' junta ixlacc'atsanich. Chai ju ix'amamaka'ui na talack'achalhch acsni talakts'inchokolh ju ix'ucxtin'an Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Aktam ajunchokopa ju Jesús: ―Jantuch calac'alh ju mi'alhunut'an. Tachi ni quimalakachachilh ju quimpai pus vachu' chunch ju quit'in iclamalakachayauch ju uxijnan ju laquilhich'alhcat. ");
INSERT INTO teeNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Acsni naulh ju chunch pus lana asunulh. Ajunich: ―Amaklht'ayanant'itch ju Spiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ni xamati' amac'acxaniya'it'it ju ixtalak'alhin pus mac'acxanicantach. Ju jantu amac'acxaniya'it'it uxijnan pus jonk'alhitach ju ixtalak'alhin. ");
INSERT INTO teeNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Para ju Tumax ju ixjuncan Cuate ju ixlhipumacaut'uich ixjunita jantu ixmakvi acsni quilalh ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ju ali'in ixtamamaka'unti ju Jesús tajunich ju Tumax: ―Iclakts'iuch ju qui'ucxtin'an. Para ju yuchi alhik'alhtailh: ―Ni jantu iclakts'ini ju la'ixlacmaca' junta ixlactanumanilh ju cravos chai ni jantu icmanuni ju quink'elilimaca' junta ixlactanumanilh ju cravos chai ni jantu laquimaca' qui'akstu ju acch'apanichokolh junta ilhtok'onicanta ju la'ixpak'axti' pus jantu iclaca'i. ");
INSERT INTO teeNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ju ixlhimixtujunch junchokolh aktam va lakputam ixtavilanampa ju lacachaka' ju ix'amamaka'uich ju Jesús. Chai ju Tumax ixvilhch vachu' anch. Chai ixtamalacchajuta. Chai chinchokopa ju Jesús chai vana va chun navichokopa. Jantu maklhteka ju lacamalhtich. Para ni talhic'atsanalh yachokopalhch la'ixlacaitat junta ixtavilanalh. Ajunich: ―Jantuch calac'alh ju mi'alhunut'an. ");
INSERT INTO teeNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Chai lanach juncan ju Tumax: ―Amanut'ich ju mink'elilimaca' ju laquilacmaca' junta ixtanun ju cravos. Alakts'ina'ich. Chai amakp'it'ich ju lhi'ani. At'amacnut'ich ju lhilaquimpak'axti' junta iclhtok'onicanta. Jantu na p'as anavit'i ju mi'alhunut. Alac'a'it'i ju tuch'i unc'an. ");
INSERT INTO teeNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ju acsnich ju Tumax ak'alhtayanalh. Junich ju Jesús: ―Qui'ucxtin'at chai quiDios'at. ");
INSERT INTO teeNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ju Jesús junich: ―Ju uxint'i ji Tumax va acsnica' ju lai lac'a'i ni xaq'uilak'alakts'inch. Para palai tak'achan ju yu'unch mas jantu quintalak'alakts'inta para talaca'ich. ―Juncanch ju Tumax. ");
INSERT INTO teeNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pus slivasalh na lhu ixpulaca'ican navilh ju Jesús la'ix'ucxlacapu'an ju ix'amamaka'ui. Para jantu si ts'okk'ocanta ju ani laca'alhiqui. ");
INSERT INTO teeNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Para icts'ok'ulata ju ani ni ap'ulac'a'iya'it'itch ni Jesús yuchi ju Cristo ju ixnoncan camalakachatachilh ju Dios. Chai ap'ulac'a'iya'it'it ni yuchi ists'alh Dios junita. Chai ca'alinach ju mi'atsucunti'an jonk'alhita ni alhilac'ap'ina'it'it ju yuchi. ");
INSERT INTO teeNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Astan acsni atalacasunichokolh ju Jesús ju ix'amamaka'ui ju laxa'atants'in Tiberias pus chanich lhi'ucx'alh. ");
INSERT INTO teeNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","K'aixtam ixtavilanank'o ju Simón Pitalu' chaich ju Tumax ju ixjuncan Cuate chaich ju Natanael amachaka' Caná lhiGalilea chai ixt'iyun'an ists'alan ju Zebedeo chaich ju ali'in ixt'iyun'an ix'amamaka'ui ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ju Simón ajunich: ―Ac'ana' ch'apana' ju pamata. Chai ju ali'in tanaulhch: ―Aclat'a'anau vachu' ju quijnan. Pus talat'a'ank'o. Tatajulh lacabarco. Para ju anu' atats'isni jantu tu'u' tach'apalh. ");
INSERT INTO teeNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Acsni ixt'ajun tuncuntilana' pus ju Jesús tayacha la'ixquilhtu' ju atants'in. Para ju ix'amamaka'ui jantu ixtamispai ni yuchi cava ju Jesús. ");
INSERT INTO teeNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ju Jesús ajunich: ―Ts'alan ja ch'ap'at'itch lacats'unin ju pamata. Ta'ak'alhtayanalh ni mati'. ");
INSERT INTO teeNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Pus ju yuchi ajunilh: ―Amac'ap'it'itch ju minch'okxni'an laxalhicana ju mimbarco'an. Anch ju lai alhit'a'uya'it'it ju pamata. Pus tamaca'alh ju ixch'okxni'an chai jantu lana lai ixtamacutui ju ch'okxni ju lacxcan ni na va ixtats'inq'uitach ju pamata. ");
INSERT INTO teeNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ju acsnich ju anu' ixtamamaka'un ju Jesús ju na ixmapaini junich ju Pitalu': ―Yuchi ju qui'ucxtin'an. Pus ju Simón Pitalu' acsni k'asmatlh ni najuncalh ni ix'ucxtin'an pus lana lakch'ichokolh ju ixpumpu' ni va ixmaxtutach ju lakatam ixpumpu'. Lana taju lacxcan. Mak'anxq'uivitnitacutlh. ");
INSERT INTO teeNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Junta mactai amacontilalh ju ixt'a'alhtanin jantuch makat ixjunita ju lak'akxixni. Va tachi tam cientos metro. Pus ju ali'in ixt'a'alhtanin ju Pitalu' tapumilh ju ixbarco'an ni va ixtapuxak'amalhimintach ju ixch'okxni'an ni na lhuch ixtanun ju pamata. ");
INSERT INTO teeNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Chai acsni tavanan tatacutcha ju la'ixquilhtu' atants'in pus talakts'ilhch ju laca'ayak'ana' ni tamp'ut'ach k'antam pamata. Vachu' talakts'ilh ju vati. ");
INSERT INTO teeNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Chai ju Jesús ajunich: ―Alhit'at'itch ju ali' pamata ju xach'ap'ayat'it chavai. ");
INSERT INTO teeNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Pus lana taju ju Simón Pitalu' ju lacabarco chai taxak'amacutulh ju ixch'okxni'an. Na lhu ixtanun ju lack'ai pamata. Ixcha'anta tam cientos a cincuenta y tres pamata. Para mas na lhu ju ixtanun ju pamata jantu talack'exlh ju ch'okxni. ");
INSERT INTO teeNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ju Jesús ajunich ju ix'amamaka'ui: ―Asok'ot'itch. Ca'uch. Pus jantu xamati' ju laich cajunilh: “Tis chavaich'at” ni ixtac'atsaich ni ix'ucxtin'an ixjunita. ");
INSERT INTO teeNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Chai ju Jesús milh junta t'amp'ucanta ju pamata. Macutulh ju vati chai axtaknilh. Vachu' axtaknilh ju pamata. ");
INSERT INTO teeNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Pus ju ani ixlhik'alhpakt'utuch ju atalacasunilh ju Jesús ju ix'amamaka'ui acsni ixta'acxtuchokotach junta ixmacnucanta. ");
INSERT INTO teeNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Acsni tavailh pus ju Jesús junich ju Simón Pitalu': ―Simón ists'alh Jonás ja palai q'uimap'aini ju uxint'i. Ja palai jantu ju ani tavilanalh. Ju Pitalu' junich ju ix'ucxtin: ―A. K'oxich c'ats'ai ni icmapainiyan ji qui'ucxtin. Chai juncanch ju Pitalu': ―Amalanit'ich ju quinchivinti ju lapanacni ju quintalhilaca'an. Ju yu'unch chunch tajunita tachi ju tu'u' ask'at'a borregojni. Na tamaktasq'uini ni xamati' ca'amasunilh ju k'ox atsucunti. ");
INSERT INTO teeNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Junchokopa ju ixlhipakt'uich: ―Simón ists'alh Jonás ja q'uimap'aini. Pus ju Pitalu' jumpa ju ix'ucxtin: ―Ju uxint'i k'oxich c'ats'ai ni icmapainiyan ji qui'ucxtin. Junchokopa: ―Pus alhist'act'ich ju lapanacni ju quintalhilaca'an. Ju yu'unch chunch tajunita tachi ju tu'u' borregojni ju tamaktasq'uini ni xamati' ca'alhistaclh. ");
INSERT INTO teeNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Junchokopa ju ixlhipakt'utu: ―Simón ists'alh Jonás ja q'uimap'aini. Pus ju acsnich na amak'aninilh ju Pitalu' ju ixlhipakt'utuch acsni quilhasacmi ju Jesús ni ixmapaini. Chai junich: ―Ju uxint'i ji qui'ucxtin c'ats'ak'o'ui tachi chun ju taxtokni. K'oxich c'ats'ai ni icmapainiyan. Pus junich ju Jesús: ―Amalanit'ich ju quinchivinti ju lapanacni ju quintalhilaca'an. Ju yu'unch tachi quimborregojni tajunita. ");
INSERT INTO teeNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Slivasalh ju icjunan. Acsni palaica' ask'at'a ix'unit'a pus va mi'akstu ixlakch'i ju mimpumpu'. Chai mas vanta anch ju ixp'imp'ut'unch ixp'inch. Para acsni papa' a'una' ach'ixa' ju mimaca' chai ak'antam camalakch'iniyan chai calhi'anan junta jantu p'imp'ut'un. ");
INSERT INTO teeNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Pujunicalh chunch ju Pitalu' ni va ixmamachakxanicanch tuchi aninti ju capumalacasuya' ju Pitalu' ni Dios ju xak'ai. Chai acsni nonk'o ju Jesús ju ani pus junich ju Pitalu': ―Aq'uinch'ak'ok'ach. ");
INSERT INTO teeNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ni talakasp'itlh ju Pitalu' lakts'ilhch ju ixt'atamamaka'un ju na ixmapainich ju Jesús ni ix'ach'ak'ok'anantach vachu'. Yuchi ju anu' ju vanin ixt'atapakstitama ju Jesús acsni tavailh. Chai yuchi ju quilhasacmi acsni tavanan junilh: “Qui'ucxtin tis chavaich ju camak'axt'ak'an”. ");
INSERT INTO teeNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ju Pitalu' acsni lakts'ilh ju ix'ach'ak'ok'anan pus junich ju Jesús: ―Qui'ucxtin ju ani minta tijuch ju canaviya'. ");
INSERT INTO teeNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ju Jesús lhak'alhtayanalh: ―Pus ni va aclacasq'uilh ni catamacaulh ju yuchi tus acsni acminchokoya' pus ju anch jantu mincuenta. Ju uxint'i va aq'uinch'ak'ok'ach. ");
INSERT INTO teeNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Yuchi lhi'alilh ju chivinti ju sia lhi'alak'avin ni ca jantu catini ju anu' pumatam ixt'atamamaka'un'an. Para ju Jesús jantu chun naulh ni va jantu catini. Va naulh: “Ni va aclacasq'uilh ni catamacaulh ju yuchi tus acsni acminchokoyach pus ju anch jantu mincuenta”. ");
INSERT INTO teeNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Quit'inch ju anu' amamaka'unti ju ixnoncanch tachi ju va jantu actini. Chai quit'in ju icnajun ni stavasalanti junima taxtokni. Chai quit'in ju ic'ats'oknunk'o tachi chun ju ani taxtokni. Chai icc'atsayauch ni stavasalanti tachi chun ju icnajunta. ");
INSERT INTO teeNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Na lhu alin ju ali' taxtokni ju navilh ju Jesús. Ni stunin xacts'ok'ulak'ota tachi chun ju taxtokni pus ca jantu lai ixtilhiva ju ani lacamunutpa' ju ats'oknut junta ixlha'ats'oknuncalhch ju tuchi navitach ju Jesús.");
INSERT INTO teeNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ju anu' alhiqui ju p'ulhnan ic'ats'oknulh ji Teófilo anch ju icnaulh tachi chun ju taxtokni ju ixnavich chai ju ix'amalaninin ju Jesús tus acsni tai'ulatacha ju ixlhich'alhcat. ");
INSERT INTO teeNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Chai chunch ju tailhi'alh tus acsnich avilhchan ju anchokolh ju lact'iyan. Ni tuca' ix'anchokoi ju lact'iyan axtaknilh ju ixlhamap'aksin la'ixtachaput ju Spiritu Santu ju ixtamalakachan ju ix'alacsacxtutach. ");
INSERT INTO teeNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Acsni nilh ju Jesús pus ju astan ju yuchi atalacasunichokolh xalak'ajun ju ixtamalakachan. T'up'uxam avilhchan na paklhu ju talakts'ilh. Chai chun ju aputalacasunilh ta yu laich catac'atsaya' istavasalanti ni ixt'ajun ju yuchi. Chai ix'ajunich ta yu lhinomputun ju Dios la'is'atsucunti'an ju lapanacni. ");
INSERT INTO teeNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Pus acsni va k'aixtam ix'alact'atavilhca' alacmap'aksi ni jantuch catataxtulh ju lak'achak'an Jerusalén para catapacxalh ju Spiritu Santu ju xanajun ju xapai ni ca'amacaminiyach. Chai vachu' is'akstu ju Jesús ix'alacjuni ni ca'axtaknicana' ju anu' Spiritu Santu. ");
INSERT INTO teeNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Amap'ast'ac'ani ju Jesús ni va lacaxcan xa'amakpaxanan ju Xivan. Chai ajuni ni jantu lhu avilhchan ju ixtic'acx tus cata'amaklhtayanana' ju yu'unch ju Spiritu Santu tachi ju ali'in lapanacni ixta'amaklhtayanan ju xcan acsni ixta'akpax. ");
INSERT INTO teeNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Pus ju yu'unch ju ix'alact'atak'aixtokta ju Jesús taquilhasacmich. Chanich tajuni: ―Qui'ucxtin ja aquila'aktaijuyau 