﻿USE sofia;
DROP TABLE IF EXISTS sofia.ted_vpl;
CREATE TABLE ted_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES ted_vpl WRITE;
INSERT INTO ted_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","'Crɩɩnɩɛ ‑gbo, ‑Yusu 'Klɩsʋ a ‑tɩ ɛɛ ꞊tu. ‑Yusu 'Klɩsʋ a ‑gbɛ, ɔ mɔ bodɩɔ Dafidɩ a 'yuo a 'yu a 'Yuu nɩ. Dafidɩ a ‑gbɛ, ɔ mɔ ‑wɛ Abrahamʋ a 'yuo a 'yu a 'yuu nɩ. ");
INSERT INTO ted_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamʋ a ‑gbɛ, ɔ kɔ Yisakɩ, ");
INSERT INTO ted_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda kɔ Tama 'hɛɛn, 'ʋ kɔ Falɛsɩ kɔ Sala, ");
INSERT INTO ted_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alamʋ 'ɔ kɔ Aminada, ");
INSERT INTO ted_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Sala kɔ Rahabʋ 'hɛɛn 'ʋ kɔ Bʋasɩ, ");
INSERT INTO ted_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yisai 'ɔ kɔ Dafidɩ, ");
INSERT INTO ted_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomɔ 'ɔ kɔ Rʋbʋamʋ, ");
INSERT INTO ted_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asafʋ 'ɔ kɔ Sosafatɩ, ");
INSERT INTO ted_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Osiasɩ 'ɔ kɔ Sʋatamʋ, ");
INSERT INTO ted_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiasɩ 'ɔ kɔ Manase, ");
INSERT INTO ted_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Sosiasɩ 'ɔ kɔ Yekonia kɔ 'a ‑dɩayuo 'hɛɛn. Ti a ‑gbɛ 'yri, tʋ klɩ la Yisraɛkʋɛ nɩ, 'ʋ gbʋ la 'le Babilɔnɩblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","‑Tɛ ʋ gbʋ la 'le, ");
INSERT INTO ted_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Solobabɛlɩ 'ɔ kɔ Abiudɩ, ");
INSERT INTO ted_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asɔ 'ɔ kɔ Sadɔkɩ, ");
INSERT INTO ted_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudɩ 'ɔ kɔ Ɛlɩasa, Ɛlɩasa 'ɔ kɔ Mata, Mata 'ɔ kɔ Sakɔbʋ, Sakɔbʋ 'ɔ kɔ Sosɛfʋ. Sosɛfʋ, nɔ‑ mɔ Mari a tɔ, ‑Yusu 'Klɩsʋ a 'dii. ");
INSERT INTO ted_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","‑Yusu a ‑gbɛ, nɔ‑ mɔ Waanyɔ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya. ");
INSERT INTO ted_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kʋɛ 'le Abrahamʋ ‑wɔn gbo, ‑bo yɛ bodɩɔ Dafidɩ ke, ‑tʋnahuin a ꞊hrɩn a gbleii ‑pu ꞊tu 'o ‑hɛn, nʋ‑ nɩ la 'o 'waa ‑gbahlɔn. Kʋɛ 'le Dafidɩ ‑wɔn gbo, ‑bo yɛ ti ꞊nʋ ‑kɔ 'yri ʋ gba la 'le Yisraɛkʋɛ Babilɔnɩblʋgba 'mʋ, ‑tʋnahuin a ꞊hrɩn a gbleii ‑pu ꞊tu 'o ‑hɛn, nʋ‑ nɩ la 'o 'waa ‑gbahlɔn. Kɔ, kʋɛ 'le ti a ‑gbɛ 'yri, ‑bo yɛ ‑Yusu, ‑ɔ mɔ Waanyɔ ꞊nʋ a kɔɔlɛ ke, ‑tʋnahuin a ꞊hrɩn a gbleii ‑pu ꞊tu 'o ‑hɛn, nʋ‑ nɩ la 'o 'waa ‑gbahlɔn. ");
INSERT INTO ted_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","‑Tɛ ʋ nu la ‑Yusu 'Klɩsʋ a kʋkɔ, ɛ nɛ‑ ‑gbo: 'A 'dii Mari a ‑gbɛ, Sosɛfʋ, nɔ‑ dio kɔ, kɛɛ, ʋ 'de la bʋɩ na ye po, 'ɔ nɩ la 'kwli 'mʋ, 'ke 'le Nyɩsʋa a ‑Hihiu a 'klɩ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Sosɛfʋ a ‑gbɛ, ‑ɔ dio la kɔ, 'a 'yrinaabʋɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye. Nɛ‑ nue, 'ɔ 'nɩnɩ ‑hʋa bɔ yɔɔ ‑tɩ, 'ke 'o nahuin ye, ‑ɛ die nu, Mari a 'dʋ 'nɩ ꞊han 'yi lɛ nyre. Ɛ nɛ‑ nue, 'ɔ pue 'le, 'ke nahuon ꞊de nɩ 'wɩn 'le, 'bɔɔ Mari gbo tɛ. ");
INSERT INTO ted_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Bɔɔ 'klɛɛ 'lu lɛ ‑hie, ‑ye Nyɩsʋa a lɛleenyɔ 'hrɩɩ ꞊nɔ ye, 'ke 'le yain 'kwli 'mʋ, ɔ nɔ: «Sosɛfʋ o, Dafidɩ a 'yu a 'Yu, ꞊nɩ pɩ 'le hʋannʋ, 'ke ‑bo kɔ Mari, ‑ɛ nue, Nyɩsʋa a ‑Hihiu a 'klɩ, nɩ‑ nue, 'ɔ nɩ 'kwli ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɔ di kɔ 'yu nyɩbɛyu. 'Yu a ‑gbɛ, ꞊tuo 'o ‑Yusudʋ, ‑ʋ ꞊hɛn 'nyrɛ Waanyɔ, ‑ɛ nue, nɔ‑ di Nyɩsʋa a dakʋ waa, 'ke 'o 'waa dɛ 'kuku ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","‑Tɩ ꞊nʋ, Nyɩsʋa ꞊tu la 'a winwlɔn‑hɛnyɔ wlɔn, ɩ nyre 'o ꞊o. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«Nyrʋgba ꞊nʋ, ‑ɔ 'de nyɩbɛdɛ yi, nɔ‑ di 'kwli 'mʋ nɩ, ɔ 'mʋ 'yu nyɩbɛyu kɔ. 'A 'dʋ di 'mʋ 'ya Emanuɛ, ‑ɛ ꞊hɛn 'nyrɛ, Nyɩsʋa nɩ 'o ‑a mʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","‑Tɛ Sosɛfʋ 'ba ye 'mʋ, ‑ye dɛ ꞊nʋ, Nyɩsʋa a lɛleenyɔ le ꞊nɔ, nɛ‑ ɔ ꞊tuu 'o, 'ɔ kɔ Mari. ");
INSERT INTO ted_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kɛɛ, ɔ kɔ ꞊nɔ 'hɛɛn, ʋ 'de la bʋɩ na ye po, Mari 'ɔ kɔ 'yu nyɩbɛyu a ‑gbɛ, Sosɛfʋ 'ɔ ꞊tuo ‑Yusudʋ. ");
INSERT INTO ted_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","‑Yusu a ‑gbɛ, 'ke ʋ kʋɔ 'le Betelɛmʋdɩɔ 'mʋ, 'ke 'le Sudeblʋgba 'kwli 'mʋ. Ti a ‑gbɛ 'yri, Helɔdɩ, nɔ‑ mɔ Sudeblʋgba a ‑gbɛ a 'kɩɩn gblaka. 'Ke ɔ nɩ 'le Jrusrɛdɩɔ 'mʋ. ‑Tɛ ʋ kɔ ‑Yusu, ɛ kɔ nahuin ꞊de, 'ke ʋ nɩ 'le 'yrʋ a 'hrɩɩlɛ a 'blʋgba 'mʋ. Ʋ mɔ yahroyɔyinyʋ gblakɩɩ nɩ. Nʋ‑ ‑hɔn 'le 'yrʋ a 'hrɩɩlɛ 'mʋ, 'ʋ nyre 'le Jrusrɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","‑Tɛ ʋ nyre 'le, ‑ye ʋ nɔ: «'Yu ‑gbo, ʋ kɔ lɛ kɛ, ‑ɔ di ‑Juukʋɛ a 'kɩɩn gblaka ‑hɛ, ‑be' ɔ nɩ ye 'le? ‑A 'ye 'a yahroyɛ nɩ, 'ɛ 'hrɩɩ 'le 'yrʋ a 'hrɩɩlɛ 'mʋ. Nɛ‑ nue, ꞊a di 'le, ‑a 'muo 'ye, ‑a 'muo ‑tɩ a 'yi'bʋaalɛ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","'Plɩɩ 'kɩɩn Helɔdɩ 'mʋ ‑tɩ ꞊nʋ mu 'wɔn, ‑ye hʋannʋ bio 'le 'kwli 'mʋ, ɔ kɔ Jrusrɛ a nahuin 'bii 'hɛɛn, ");
INSERT INTO ted_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","tii ‑do a ti 'yri 'ɔ 'kukue Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ lɛ, kɔ teteitɔɔnyʋ 'hɛɛn, 'ɔ ꞊gbʋ wlɔn, ɔ nɔ: «Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, 'dɩɔ tio‑ kɔ 'mʋ ʋ dio la 'le kɔ 'le?» ");
INSERT INTO ted_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «'Ke ʋ dio 'le Betelɛmʋ 'mʋ kɔ, 'ke 'le Sudeblʋgba 'kwli 'mʋ, ‑ɛ nue, dɛ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ ‑ye 'crɩɩ la, 'ke 'o Waanyɔ a ‑gbɛ ke, ɛ nɛ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nyɩsʋa nɔ 'nɩ: Betelɛmʋ, ꞊hapʋkɔ, 'ɔ mɔ 'dɩɔ 'cicrɛ, kɛɛ, sɛyɩ‑sɛyɩ, ɔ mɔ 'dɩɔ gblakaa nɩ, 'ke 'le Sudeblʋgba 'kwli 'mʋ, ‑ɛ nue, 'ke 'le ꞊nɔ 'kwli 'mʋ, 'ke 'kɩɩn gblaka di 'le kɔ. Nɔ‑ di 'na dakʋ Yisraɛkʋɛ naa.» ");
INSERT INTO ted_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","'Plɩɩ Helɔdɩ 'mʋ ‑tɩ a ‑gbɛ mu 'wɔn, ‑ye ɔ da yahroyɔyinyʋ gblakɩ ꞊nʋ ye, 'ɔ ꞊gbʋ wlɔn, ɔ 'mui yi ‑tɛɛ, ti ꞊nʋ ‑kɔ 'yri yahroyɛ a ‑gbɛ, ɛ 'hrɩɩ 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","‑Tɛ ʋ ‑hɩhɩɔ klɛ, ‑ye ɔ nɔ: «Ba mu 'le Betelɛmʋ 'mʋ, ba ꞊mɔ 'yu a ‑gbɛ lɛ ‑tɛɛ. 'Ba 'yo, ‑ye ba di 'mʋ le, 'na ‑gbɛ, 'mʋ 'le mu, 'muo ‑wɛ ‑tɩ a 'yi'bʋaalɛ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","'Plɩɩ ʋ 'mʋ 'kɩɩn a tiiwin mu 'wɔn, ‑ye ʋ bi wlɔn 'hru. ‑Tɛ ʋ nɩ 'hru wlɔn, ‑ye yahroyɛ ꞊nʋ, ʋ 'yee la 'le 'yrʋ a 'hrɩɩlɛ 'mʋ, nɛ‑ 'hrɩɩ 'le ꞊nʋ ye 'mʋ lele, 'ɛɛ ꞊nʋ ye 'mʋ naa, 'ʋ mu ‑mumu. Kɛɛ, ‑tɛ ꞊nʋ, 'yuplu a ‑gbɛ, ɔ nɩ 'o, ‑tɛ ɛ nyre 'o, ‑ye ɛ nyra gbo. ");
INSERT INTO ted_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","'Plɩɩ ʋ 'mue mu 'ye, ‑ye ʋʋ nu 'manʋ 'dɔ, ");
INSERT INTO ted_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","'ʋ pa kayu gbo, 'ʋ 'ye 'yu a ‑gbɛ, ɔ kɔ 'a 'dii Mari 'hɛɛn. ‑Ye ʋ bla gbo kwlɩ, 'ʋʋ 'yu a ‑gbɛ ‑tɩ a 'yi'bʋaalɛ ‑nyi. ‑Ye ʋ ꞊wlɛɛ 'waa blɛ nɩ, 'ʋ ‑nyi ꞊nɔ ‑gʋlʋ, kɔ hʋnhrʋnpo‑tɔplɩ, ʋʋ 'tɔ po, ‑ɛ die nu, 'a hʋnhrʋn 'mʋ gbo 'sɛɛ, kɔ hʋnhrʋnpo‑tɔplɩ ‑ye, ʋʋ milɩ daa. ");
INSERT INTO ted_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye Nyɩsʋa lu nɩ, 'ke 'le yain 'kwli 'mʋ, 'bʋʋ de ‑mɛ, ʋ nɩ naa 'le 'le 'kɩɩn Helɔdɩ ‑wɔn. Nɛ‑ nue, ‑tɛ ʋʋ 'waa 'bri mu, 'ʋ gba ke'bɛɛhru. ");
INSERT INTO ted_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","'Plɩɩ yahroyɔyinyʋ a ‑gbɛ, ʋ 'mʋ mu mu, ‑ye Nyɩsʋa a lɛleenyɔ ‑ye, nɔ‑ 'hrɩɩ Sosɛfʋ ye, 'ke 'le yain 'kwli 'mʋ, ɔ nɔ: «'Ba ye 'mʋ, ‑bo 'gbaa 'yu, ɔ kɔ 'a 'dii 'hɛɛn ci lɛ, 'ke 'le Esipʋblʋgba 'mʋ, 'ke ‑bo nɩ 'le, ɛ 'mue gba ‑gbagba, 'mʋ lele ‑mʋ le, ‑ɛ mɔ, ‑bo di 'bri, ‑ɛ nue, Helɔdɩ, ɔ di 'yu ‑gbo lɛ 'nɩ ꞊mɔ, ɔ 'muo 'la.» ");
INSERT INTO ted_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","'Plɩɩ Sosɛfʋ 'mʋ win a ‑gbɛ mu 'wɔn, ‑ye ɔ 'ba 'mʋ ye, ɔ kɔ 'yu, kɔ 'a 'dii 'hɛɛn, 'tɔyrʋwɔɔ ‑do a ‑gbɛ 'mʋ, 'ʋ mu 'le Esipʋblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","'Ke ʋ nɩ 'le ‑nɩnɩ, Helɔdɩ 'ɔ 'kʋ, Nyɩsʋa 'ɔ da Sosɛfʋ, 'ke bɔ ‑hɔn 'le Esipʋblʋgba 'mʋ, ɔ kɔ 'yu kɔ 'a 'dii 'hɛɛn. Dɛ a ‑gbɛ, ɛ nyre 'o ꞊o, ‑ɛ die nu, ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ ‑ye, ɔ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɩ 'mʋ nue. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: «Nyɩsʋa nɔ 'nɩ: 'N da 'na 'yu nɩ, 'ke bɔ ‑hɔn 'le Esipʋblʋgba 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","‑Tɛ dɛ a ‑gbɛ, ɛ 'de 'o a nyree, ‑tɛ 'kɩɩn Helɔdɩ yrie, ‑ɛ mɔ, yahroyɔyinyʋ ꞊nʋ, ʋ kaa ꞊nɔ nɩ, ‑ye ɔ bi 'mʋ yrʋ 'dɔ, 'ɔ le 'a 'sɔyuo, ɔ nɔ: «Ba bi Betelɛmʋ ke, kɔ 'dɩɛ ꞊nʋ, ‑ɛ ꞊glaa 'le ꞊nɔ, a 'mʋ 'yuo nyɩbɛpʋ 'bii 'la, ‑ʋ kɔ 'yrɩɩ 'hɔn, kɔ 'waa dɛ ꞊nʋ, ‑ʋ 'de wɛn 'yrɩɩ 'hɔn a kʋɛ,» ‑ɛ nue, yahroyɔyinyʋ ꞊nʋ, ʋ le la ꞊nɔ nɩ, ‑ɛ mɔ, ‑tɛ ʋ 'ye la yahroyɛ a ‑gbɛ, 'ke 'le yakɔ 'mʋ, ɛ ‑wɛ 'klɛɛ 'le 'yrɩɩ 'hɔn. 'Plɩɩ 'sɔyuo a ‑gbɛ, 'ʋ mu 'le Betelɛmʋ 'mʋ, 'ʋ 'lɩla 'yuo꞊pli a ‑gbɛ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","‑Tɛ ‑tɔplɩdʋ a ‑gbɛ, ɩɩ 'lu ‑wɔn mue, ‑ye ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Selemi ꞊tu la, ti ‑hi la a ti 'yri, ɩ nyre 'o ꞊o. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«Ʋ 'wɔn ꞊hienwewin, 'ke 'le Ramadɩɔ 'mʋ. Rasɛlɩ, nɔ‑ɔ wɔlɩ lɛ nu, 'ɔɔ 'a 'yuo a ꞊hien we. Ɔ 'nɩ ‑hʋa ꞊le bʋ ꞊gɔɔ, ‑ɛ nue, 'a 'yuo꞊pli 'kʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","'Ke ʋ nɩ 'o ‑nɩnɩ, ‑ye 'kɩɩn Helɔdɩ, ɔ 'kʋ nɩ. 'Plɩɩ ɔ 'mʋ mu 'kʋ, ‑ye Nyɩsʋa a lɛleenyɔ ‑ye, ɔ 'hrɩɩ Sosɛfʋ ye, 'ke 'le Esipʋblʋgba 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ɔ nɔ: «Sosɛfʋ o, 'ba ye 'mʋ, ‑n kɔ 'yu kɔ 'a 'dii 'hɛɛn, ba ꞊hɩan ‑wɔn, ba mu 'a nɩ 'bri Yisraɛ, ‑ɛ nue, nahuin ꞊nʋ, ‑ʋʋ 'yu ‑gbo a 'kʋkʋɛ lɛ ꞊mɔ, ʋ 'kʋ nɩ,» ");
INSERT INTO ted_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Sosɛfʋ 'ɔ 'ba ye 'mʋ, ɔ kɔ 'yu kɔ 'a 'dii 'hɛɛn, 'ʋ ꞊hɩan ‑wɔn, 'ʋ mu 'le 'waa 'bri Yisraɛ. ");
INSERT INTO ted_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kɛɛ, Sosɛfʋ, ɔ 'wɩn nɩ, ‑ɛ mɔ, Akolawusɩ, ‑ɔ mɔ 'kɩɩn Helɔdɩ a 'yu, nɔ‑ 'cɩcɩ 'a bu. Akolawusɩ, nɔ‑ mɔ 'klɛɛ Sudeblʋgba a 'kɩɩn. Nɛ‑ nue, Sosɛfʋ a ‑gbɛ, hʋannʋ 'ʋ nyo nu, 'ke bɔ 'ti 'le Sudeblʋgba 'mʋ. ‑Ye Nyɩsʋa lo nɩ, 'ke 'le yain 'kwli 'mʋ, 'ke ɔ nɩ mu 'le 'le Sudeblʋgba 'mʋ. Nɛ‑ nue, 'ɔ mu 'le Galileblʋgba 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","'ɔ 'ti 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Nasalɛtɩ. ‑Ye ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyʋ ꞊tu la, 'ke 'o Waanyɔ ꞊nʋ ke, Nyɩsʋa po la lɛ, ɔ di la 'le ya, ɩ nyre 'o ꞊o. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: «Ʋ dio daa Nasalɛtɩ 'mʋ a 'yu.» ");
INSERT INTO ted_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ti ꞊nʋ 'yri, ɛ kɔ nahuon ꞊de. 'A 'dʋ mɔ Saan Batisɩ. 'Ke ɔ 'ti 'le Sudeblʋgba 'mʋ. 'Blʋgba a ꞊tɩɔ ꞊nʋ, ‑ɔ kɔ 'mʋ ɔ 'ti 'le, nahuon ꞊de 'de 'le 'ti, kɛɛ, nahuin 'plɔplɔ, nʋ‑ʋ 'le ꞊nɔ ‑wɔn mu. 'Ke ɔ 'tatɩ 'le Nyɩsʋa a ‑tɩ a ꞊tutue gbo, 'ke 'o nahuin ꞊nʋ ‑wɔn, ‑ʋʋ 'le ꞊nɔ ‑wɔn di, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ba yree, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ɛ mɔ, aa nu ‑tɔplɩ, ‑ɩ nyre 'yi lɛ, 'ke 'o Nyɩsʋa ye. Ba hie 'o 'yilɛnyre‑tɔplɩ a ‑gbɛ gbo, ba ‑nyi 'a nɩ 'klɔ 'bii Nyɩsʋa, ‑ɛ nue, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'o nahuin 'bii win ke kɔɔ, ɩ 'mʋɛɛ yrɛ.» ");
INSERT INTO ted_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ti ꞊de a ti 'yri la, ‑tɛ ʋ 'de la ‑Yusu a kʋɛ, ɛ kɔ la Nyɩsʋa a winwlɔn‑hɛnyɔ ꞊de. 'A 'dʋ mɔ Esai. Saan, nɔ‑ mɔ nahuon ꞊nʋ, ‑ɔ kɔ ‑tɩ Esai a ‑gbɛ, ɔ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ, nɔ‑ di ‑Yusu a 'hru ye kla, 'plɩɩ ‑Yusu a ‑gbɛ, ɔ 'mʋ 'le di. ‑Tɩ a ‑gbɛ, ɔ 'crɩɩ la, ɩ nɩ‑ ‑gbo: «Nyɩsʋa nɔ 'nɩ: Nahuon ꞊de, ‑tɛ 'dʋ di 'le ye bii, 'kee nɩ, ɔ di 'le 'ti. 'Bɔɔ 'prɛ, ɔ 'mʋ 'le win 'yaa. Kɛ ɔ di po: Kʋkɔnyɔ a 'hru ꞊nʋ, ‑ʋ kɔ wlɔn ɔ di 'o na, ba 'siu 'o ye, 'plɩɩ Kʋkɔnyɔ a ‑gbɛ, ɔ 'mʋ 'le di. Ɛ 'we ꞊nɔ ye, 'a nɩ 'klɔ bɔ 'sii 'o ye, ‑ɛ die nu, a 'mʋ ‑wɔn ‑wɛ, 'plɩɩ Kʋkɔnyɔ 'mʋ 'le di ‑o.» ");
INSERT INTO ted_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Saan a ‑gbɛ, 'a wlawlʋ, ɔɔ pue, ʋ 'de dɛkɔnyɔ a wlawlʋ ye 'we. Ʋ nu ꞊gbuke‑so a ‑pupui, 'ʋ hrʋ, 'ɔ nyu dahʋakɔ a 'bɛtɩyɛ ke klɩɩ. 'A didi‑tɔplɩ, ɔɔ di, nɩ‑ mɔ 'kolio kɔ dʋnyra. (Ɛ 'we ꞊nɔ ye, Saan, ɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ. ‑Tɛ 'a 'bienʋ winwlɔn‑hɛnyʋ ‑ye ꞊nʋ, ʋ nɩ la 'mʋ, ti ‑hi la a ti 'yri, kɛ'ɛ nɩ, Saan, ɔ nɩ ‑wɛ 'mʋ.) ");
INSERT INTO ted_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Nahuin 'plɔplɔ, nʋ‑ nyo yrɛ mu. Nahuin a ‑gbɛ, 'ke ʋ 'ti 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Jrusrɛ, kɔ Sudeblʋgba 'bii 'kwli 'mʋ, kɔ 'blʋgba 'bii ꞊nʋ 'mʋ, ‑ɔ 'mʋɛɛ 'nɩgblaba ꞊nʋ ye, ‑ɔ kɔ 'dʋ mɔ Sudɛn. Nahuin 'bii a ‑gbɛ, kɛ ʋʋ nu, 'ʋ nyo yrɛ mu, ʋ 'mʋ 'a win 'wɔn, ");
INSERT INTO ted_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","'ʋʋ 'waa nɩ 'yilɛnyre‑tɔplɩ yrɛ wɔɔn, 'ke 'o nahuin ye, 'plɩɩ Saan, 'ɔ nyu 'nie 'lu lɛ po, 'ke 'le 'nɩgblaba ꞊nʋ ‑wɔn, ‑ɔ mɔ Sudɛn. ");
INSERT INTO ted_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Falisi꞊tumu kɔ Sadusɩ꞊tumu, 'waa nahuin 'plɔplɔ, nʋ‑ʋ ‑wɛ 'le Saan ‑wɔn mu, ɔ 'mu 'nie 'lu lɛ po. ‑Tɛ Saan 'yu, ‑ye ɔ nɔ: «'A mʋ ꞊nʋ, aa kaa nahuin, 'a nɩ nunuklɔ 'ɔ nyre 'yi lɛ, ‑ɛ 'we ꞊nɔ hrei ye. Nyɩsʋa a yrʋ ‑wɛ lɛ kɛ 'a nɩ kikle. A nɩ po 'le lɛ, ‑ɛ mɔ, a ‑wɛ 'le ba 'gbʋ ye 'mʋ ci lɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","'Plɩɩ 'mʋ 'a mʋ 'nie 'lu lɛ po, ba nu ꞊hapʋdɛ, ʋ 'mue 'ye, ‑ɛ mɔ, a hie 'o dɛ 'kuku, aa nu gbo, 'a ‑nyi 'a nɩ dɩɔnʋ Nyɩsʋa. ");
INSERT INTO ted_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","A nɩ po 'le lɛ, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ɛ mɔ, 'a mʋ mɔ ‑a nɩ bu gblaka Abrahamʋ a 'yuo, 'a ‑tɩ, Nyɩsʋa 'die 'le ‑wɛ bɔ poo 'a mʋ yrʋ lɛ. 'Nɩɩ 'a mʋ 'nɩ le, ‑ɛ mɔ, Nyɩsʋa ‑wɛ 'le bɔ nue nɩ, 'hɛ ‑gbo, bɛ ‑hɛ Abrahamʋ a 'yuo. ");
INSERT INTO ted_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ʋ ‑wɛ ‑wɔn, 'ke bʋ nu 'dugbi, bʋ hra 'ɛ nɩ tugbɛ ꞊de, ‑ɛ 'nɩnɩ tʋ 'kui, ʋ 'mue 'tɔ po. Ɛ ꞊hɛn 'nyrɛ, Nyɩsʋa ‑wɛ ‑wɔn, 'ke bɔ poo nahuin ꞊nʋ ‑bati lɛ, ‑ʋ 'nɩnɩ ꞊tuo 'o. ");
INSERT INTO ted_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","'Mɔ ‑gbo, 'nie, nɛ‑ 'nɩɩ 'a mʋ 'lu lɛ po, nahuin 'mue 'ye, ‑ɛ mɔ, a hie 'o dɛ 'kuku gbo, 'a ‑nyi 'a nɩ dɩɔnʋ Nyɩsʋa. Kɛɛ, nahuon ‑ye di 'le di. Nɔ‑ di 'o 'mʋ ke 'mʋ kʋɛ. Nɔ‑ di 'klɩ ke nɩ, ɔ 'mʋ 'o 'mʋ 'mʋ ‑hi, 'ke 'le Nyɩsʋa a 'dʋ 'kwli 'mʋ. 'Na ‑gbɛ, 'n 'de nyɔ ꞊de, 'ke ꞊bo dio 'mʋ ‑hɛ, 'ke 'o 'ɛ nɩ ‑kʋandɛ ꞊de a ‑ta 'mʋ. Nahuon ꞊nʋ, ‑ɔ di 'le di, Nyɩsʋa a ‑Hihiu, nʋ‑ ɔ di 'a mʋ ‑nyi, kɔ wʋnwlɩnna 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nahuon a ‑gbɛ, ɔ di ye 'we ꞊gbla'mʋlɛ꞊hloonnyɔ, ‑ɔ 'ble ‑ŋmahɛn kwa, ɔ di nu, ɔ 'mʋ ꞊gbla 'mʋ lɛ ꞊hloon, ɔ 'mʋ ꞊gbla ꞊nʋ gbo ꞊tu. Kɛɛ, 'a ‑pupui ꞊nʋ, ɔ di po 'tɔ, 'ke 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ di jre.» ");
INSERT INTO ted_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusu ‑hɔn 'le Galileblʋgba 'mʋ, 'ɔ mu 'le 'nie ꞊nʋ, ‑ɛ mɔ Sudɛn nʋa 'mʋ, 'ke 'le Saan 'hʋɩn 'mʋ, ‑ɛ die nu, Saan 'muo 'nie 'lu po. ");
INSERT INTO ted_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kɛɛ, Saan, ɔ blɛ ke, ɔ nɔ: «'Mɔɔ nɩ, ‑n blɛ ye ‑bo po wɛn 'nie 'lu, 'plɩɩ ‑ye, ‑mɔɔ nɩ, ‑ɔ di 'le, 'ke ꞊bo po ‑mʋ 'nie 'lu.» ");
INSERT INTO ted_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Kɛɛ ‑ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, ꞊nɩ blɛ 'le ke, ‑ɛ nue, dɛ Nyɩsʋaa ‑hʋa, ‑a blɛ ye ‑ba nue.» ‑Ye Saan wɔn nɩ, 'ɔ puo 'nie 'lu. ");
INSERT INTO ted_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","‑Tɛ ɔ puo 'nie 'lu, ‑Yusu bɔɔ 'le 'nie ‑wɔn 'hrɩ, ‑ye tii ‑do a ti 'yri, yakɔ ‑ki wlɔn, 'ɔ 'ye Nyɩsʋa a ‑Hihiu, 'ʋ ‑hɔn 'le yakɔ 'mʋ, 'ʋ ꞊tɩɩ 'o ꞊nɔ 'lu, ɛ 'we ꞊nɔ ye, ‑tɛ ‑plija bɔ 'nɩnɩ ꞊tɩɩ 'klɛɛ 'o ꞊nɔ 'lu, ");
INSERT INTO ted_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","kɔ, ʋ 'wɔn Nyɩsʋa a wintɛ. Kɛ ɛɛ po: «Nɔ‑ mɔ 'na 'Yuu ‑do, 'n nʋɛ 'mʋ ‑tɛɛ. ‑Nɩɩ 'mʋ nue 'manʋ.» ");
INSERT INTO ted_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, Nyɩsʋa a ‑Hihiu gba 'le ‑Yusu ‑tɛgbi ‑ye, 'dʋ bii 'le ye, ‑ɛ die nu, 'kuo ‑hʋɩn a nyɩgblaka Satan, ɔ 'muo 'mʋ lɛ ꞊tɔ. ");
INSERT INTO ted_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","'Ke 'le ‑tɛgbi a ‑gbɛ, 'ke ɔ ‑hi 'le ‑nyrɔwɩ a ‑wlɩɩ 'hɔn kɔ 'tɔyrʋwɩ a ‑wlɩɩ 'hɔn. Ti a ‑gbɛ 'yri, ɔ 'nɩ di ꞊le dɛ. ‑Nyrɔwɩ a ‑wlɩɩ 'hɔn a ‑gbɛ, bɩ ‑hi, ‑ye kanʋ nyo nu. ");
INSERT INTO ted_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","‑Ye 'kuo ‑hʋɩn a nyɩgblaka, nɔ‑ 'yɩya 'o ꞊nɔ 'hʋɩn 'mʋ gbo, ɔ nɔ: «'Bɩa ꞊nɩ 'ya Nyɩsʋa a 'Yu 'mʋ, le 'hɛ ‑gbo, bɛ ‑hɛ 'flɔɔ.» ");
INSERT INTO ted_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","‑Ye ‑Yusu nɔ: «Ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Ɛ 'de dididɛɛ ‑do, ɛ 'nɩ nue ꞊le, ‑tʋnahuon 'nɩ nɩ ꞊le 'klɔ, kɛɛ, win 'bii, ‑ɩɩ 'le Nyɩsʋa wlɔn 'mʋ ‑hɔn, nɩ‑ nye nu, 'plɩɩ ‑tʋnahuon 'ɔɔ 'klɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye 'kuo ‑hʋɩn a nyɩgblaka gbɔ 'le 'mʋ Jrusrɛdɩɔ, ‑ɔ mɔ Nyɩsʋa a dakʋ a 'dɩɔ gblaka, 'ɔ 'yɔɔ 'le Nyɩsʋa a 'kagblaka ke, ");
INSERT INTO ted_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ɔ nɔ: «'Bɩa ꞊nɩ 'ya Nyɩsʋa a 'Yu 'mʋ, ‑ye ‑bo ꞊pluu 'le ꞊hlɔn, ‑ɛ nue, ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: ‑Na ‑tɩ, Nyɩsʋa di 'a lɛleenyʋ 'nɩ le, ʋ 'mʋ ‑mʋ klɩ, ‑ɛ die nu, ‑na bʋ 'nɩ ꞊han 'hɩɔ ye bi.» ");
INSERT INTO ted_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","‑Ye ‑Yusu nɔ: «Ʋ 'crɩɛ ‑wɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: ꞊Nɩ ꞊tɔ 'le ‑na Kʋkɔnyɔ Nyɩsʋa 'mʋ lɛ.» ");
INSERT INTO ted_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","‑Ye 'kuo ‑hʋɩn a nyɩgblaka gbɔ 'le lele, 'ke 'le dʋgba ‑pɛtu 'lu, 'ɔ tɔɔ ꞊nɔ 'klɔ a 'blʋgbɩ 'bii ꞊nʋ kɔ 'waa ‑tɩ a 'yi'bʋbʋa, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","«'N di ‑mʋ ɩ 'bii 'nɩ ‑nyi, 'bɩa ꞊nɩ bla 'mʋ kwlɩ ye gbo, 'ke 'o 'na 'o꞊tuulɛ a ‑ta 'mʋ, kɔ, ꞊nɩ 'bʋaa 'na ‑tɩ 'yi.» ");
INSERT INTO ted_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","‑Ye ‑Yusu nɔ: «Mu, Satan, hren 'mʋ ‑wɔn, ‑ɛ nue, ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: ‑Na Kʋkɔnyɔ Nyɩsʋaa ‑do, nɔ‑ kɔ ye ‑bo bla 'o kwlɩ gbo, 'ke 'o 'a 'o꞊tuulɛ a ‑ta 'mʋ, ꞊mʋ 'a ‑tɩ 'yi 'bʋaa.» ");
INSERT INTO ted_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","'Plɩɩ ɔ 'mʋ mu ‑yrɛ, ‑ye 'kuo ‑hʋɩn a nyɩgblaka ‑hɩɔ 'klɛɛ lɛ mɛ. Tii ‑do a ‑gbɛ 'yri, ‑ye Nyɩsʋa a lɛleenyʋ, nʋ‑ nyre 'o ꞊nɔ 'hʋɩn 'mʋ, 'ʋ ‑tʋa 'a 'mʋ‑hɛɛlɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","13","‑Yusu 'wɩn nɩ, ‑ɛ mɔ, ʋ po Saan Batisɩ 'mʋ ꞊jɩ. Nɔ‑ kɔ ‑tɩ 'ɔ ‑hɔn 'le Sudeblʋgba 'mʋ, 'ɔ mu 'le 'a ‑gbɛ a 'dɩɔ 'mʋ, ‑ɔ mɔ Nasalɛtɩ, 'ke 'le Galileblʋgba 'mʋ. Kɛɛ, ɔ 'de 'le gbo nɩ, 'ɔ mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Kapɛnaɔ, ‑ɔ nɩ 'o Galile a 'yru nʋa 'mʋ, 'ke 'le Sabuloblʋgba 'mʋ kɔ Nɛfʋtaliblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɔ nue nɩ, ‑ɛ die nu, ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Esai ꞊tu la, ɩ 'mʋ 'o nyre. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«Ba po 'o nʋa gbo, 'a mʋ nahuin ꞊nʋ, ‑ʋ nɩ 'le Sabuloblʋgba 'mʋ kɔ Nɛfʋtaliblʋgba 'mʋ, 'ke 'le 'yru nʋa 'mʋ, kɔ 'a mʋ ꞊nʋ, ‑ʋ nɩ 'le Sudɛn a 'nike, kɔ 'a mʋ pʋpʋnahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, ‑ʋ nɩ 'le Galileblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","'Ke 'o 'a nɩ ‑ta 'mʋ, kɛ Nyɩsʋa po: Dakʋ ꞊nʋ, ‑ʋ nɩ 'le gbɩgbɩyrɩ ‑hɛyri, ʋ di 'ye ‑nyrɛ gblaka. ‑Nyrɛ a ‑gbɛ, ɛɛ 'nɩ wlɩn, 'ke 'o 'blʋgba ꞊nʋ a dakʋ a ‑gbɛ ‑wɔn, ‑ʋ nɩ 'le 'kʋkʋɛ a 'blʋgba 'mʋ, ‑ɔ kɔ 'mʋ ‑nyrɛ 'de 'le nɩ.» Kɛ Esai a 'pʋprɛwin po la. ");
INSERT INTO ted_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kʋɛ 'o ti a ‑gbɛ 'yri gbo, ‑Yusu ‑tʋa Nyɩsʋa a ‑tɩ a ꞊tutue gbo, ɔ nɔ: «Ba yree, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ɛ mɔ, aa nu ‑tɔplɩ, ‑ɩ nyre 'yi lɛ, 'ke 'o Nyɩsʋa ye. Ba hie 'o 'yilɛnyre‑tɔplɩ a ‑gbɛ gbo, ba ‑nyi 'a nɩ 'klɔ 'bii Nyɩsʋa, ‑ɛ nue, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'o nahuin 'bii win ke kɔɔ, ɩ 'mʋɛɛ yrɛ.» ");
INSERT INTO ted_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusu mu 'le Galileblʋgba a 'yru nʋa 'mʋ. Bɔɔ 'klɛɛ 'yru nʋa 'mʋ lɛ 'yraa, ‑ye ɔ yɛ 'o gbo ‑dɩayuoo 'hɔn. 'Waa 'dʋɩ mɔ Simɔ, ʋʋ Piɛlɩ daa, kɔ Adre. Ʋ mɔ 'pʋpanyʋ'ʋ nɩ. 'Ke ʋ nɩ 'le 'waa 'blagbe wlɔn, 'ʋʋ 'waa ‑tatɩ po. ");
INSERT INTO ted_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","‑Ye kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «Ba di 'le, ba kʋɛ 'mʋ ‑wɔn, a 'mʋ 'na ‑naagbopʋ ‑hɛ. 'N die 'nɩ nu, a 'mʋ ‑tʋnahuin lɛ 'kukue. Ɛ 'we ꞊nɔ ye, ‑tɛ aa nu, 'aa ‑tatɩ po, 'aa ‑hrin lɛ 'kukue, kɛ ba nu, ba 'kukue ‑tʋnahuin lɛ, ʋ 'mʋ ‑wɛ 'na ‑naagbopʋ ‑hɛ.» ");
INSERT INTO ted_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Bɔ ꞊tu 'klɛɛ ꞊nʋ ‑tɩ a ‑gbɛ ye, 'tata a ti 'yri, ‑ye ʋ hie 'o 'waa ‑tatɩ gbo, 'ʋ ‑tʋa 'a ‑wɔnnaalɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Bʋ 'yɩya 'o ye 'mʋ gbo, ‑ye ɔ yɛ 'o gbo ‑dɩayuoo 'hɔn ‑ye. 'Waa 'dʋɩ mɔ Sakɩ kɔ Saan. 'Waa bu a 'dʋ mɔ Sebede. Nʋ‑ nɩ 'le 'waa 'blagbe wlɔn, ʋ kɔ 'waa bu 'hɛɛn, 'ʋʋ 'waa ‑tatɩ ‑hlɛntie. ‑Tɛ ɔ yɛ 'o ‑dɩayuoo 'hɔn a ‑gbɛ gbo, ‑ye ɔ dʋ nɩ, 'ke bʋ 'ya 'a ‑naagbopʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tii ‑do a ti 'yri, ‑ye ʋ hie 'o 'waa 'blagbe kɔ 'waa bu 'hɛɛn gbo, 'ʋ ‑tʋa 'a ‑wɔnnaalɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu, ɔɔ Galileblʋgba 'bii ke 'nɩ na, 'ɔɔ Nyɩsʋa a ‑tɩ tɔɔ, 'ke 'le Nyɩsʋa a kayuo gbo, kɔ, 'ɔ nyi ꞊tu, ‑tɛ Nyɩsʋa di nahuin a win a kekɔɔlɛ nu, kɔ 'ɔɔ nahuin a 'kʋɛi 'bii ‑wɔ, kɔ 'ɛ nɩ kɩkladɛ ꞊de 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Nɛ‑ nue, 'a 'dʋ 'ʋ 'sɛɛ gbo, 'ke 'le Galileblʋgba 'bii 'mʋ. Ɛ nue, nahuin, ‑ʋ nɩ 'le Siliblʋgba 'mʋ, 'ʋ 'wɔn ‑wɛ 'a 'dʋ. Nɛ‑ kɔ ‑tɩ 'ʋ nyo 'le 'hʋɩnhrennyʋ 'plɔplɔ ‑wɔn gba, kɔ nahuin ꞊nʋ, 'ɛ nɩ kɩkladɛ ꞊dee nu. Nahuin a ‑gbɛ, 'waa dɛ ‑ye nɩ 'o, 'kuo ‑hʋɩn nɩ 'o ꞊nʋ ke 'mʋ, 'waa dɛ ‑ye ‑wʋwɔpipi 'ɛ nyu nu, 'waa dɛ ‑ye 'ʋ ‑yɩyrɛ lɛ. Ʋ 'bii a ‑gbɛ, ‑Yusu 'ɔ ‑wɔ 'waa 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nɛ‑ nue, nahuin 'plɔplɔ 'ʋ nyo ‑wɔn kʋɛ. 'Ke ʋʋ 'le Galileblʋgba 'mʋ ‑hɔn, kɔ Dekapɔblʋgba 'mʋ, kɔ Jrusrɛdɩɔ 'mʋ, kɔ Sudeblʋgba 'bii 'mʋ, kɔ 'blʋgba ꞊nʋ, ‑ɔ nɩ 'le Sudɛn a 'nike. ");
INSERT INTO ted_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","‑Tɛ ‑Yusu 'ye nahuin 'plɔplɔ ꞊nʋ, ‑ye 'ke ɔ 'ya 'le dʋgba 'lu, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ɔ nɩ gbo, ");
INSERT INTO ted_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","'ɔ ‑tʋa 'waa tɔɔlɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ɔ nɔ: «Nahuin ꞊nʋ, ‑ʋ yie, ‑ɛ mɔ, 'ke 'le 'waa ꞊wlɩ ke, ꞊hapʋdɛ 'de 'le nɩ, 'bɩa Nyɩsʋa a ‑Hihiu 'bʋ 'de 'o ꞊nʋ ke 'mʋ nɩ, nahuin a ‑gbɛ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nue, nʋ‑ʋ nɩ, ‑ʋ di 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ pa. ");
INSERT INTO ted_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nahuin ꞊nʋ, ‑ʋ kɔ ꞊wlɩ bi ꞊hlɔn, bʋ kɔ plɔ a bleelɛ, ‑ɛ nue, Nyɩsʋa a ‑gbɛ, nɔ‑ diu 'le ꞊wlʋ 'kwli 'mʋ gbo ꞊tu. ");
INSERT INTO ted_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nahuin ꞊nʋ, ‑ʋ kɔ ꞊wlɩ 'yɔpɔ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nue, nʋ‑ Nyɩsʋa di 'blʋgba ꞊nʋ ‑nyi, ɔ plɛ, ɔ di 'a nahuin ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nahuin ꞊nʋ, ‑ʋ nye lɛ ꞊mɔ 'dɔ, 'ke 'le waa ꞊wlɩ 'bii ke, 'waa 'yrinaabʋɩ bɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye, nahuin a ‑gbɛ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nue, dɛ ꞊nʋ, ʋʋ lɛ ꞊mɔ, Nyɩsʋa die ꞊nʋ 'nɩ ‑nyi 'bii. ");
INSERT INTO ted_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nahuin ꞊nʋ, ‑ʋ kɔ 'waa 'bienʋ ‑tʋnahuin a wɔlɩ, bʋ kɔ plɔ a bleelɛ, ‑ɛ nue, Nyɩsʋa di ‑wɛ kɔ 'waa wɔlɩ. ");
INSERT INTO ted_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nahuin ꞊nʋ, ‑ʋ kɔ ꞊wlɩ 'sii 'o ye, bʋ kɔ plɔ a bleelɛ, ‑ɛ nue, ʋ di Nyɩsʋa 'nɩ 'ye. ");
INSERT INTO ted_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nahuin ꞊nʋ, ‑ʋ nye lɛ ꞊mɔ, 'ke nahuin bʋ wɛɛn ke gbo, bʋ kɔ plɔ a bleelɛ, ‑ɛ nue, Nyɩsʋa diu daa 'a 'yuo. ");
INSERT INTO ted_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nahuin ꞊nʋ, ʋʋ ꞊sʋɛ ꞊tue, ‑ɛ nue, dɛ Nyɩsʋaa ‑hʋa, nɛ‑ ʋʋ nu, nahuin a ‑gbɛ bʋ kɔ plɔ a bleelɛ, ‑ɛ nue, nʋ‑ʋ nɩ, ‑ʋ di 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ pa. ");
INSERT INTO ted_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","'A mʋ ꞊nʋ, 'bʋʋ 'a mʋ tanɩ ꞊tu, 'bʋʋ 'a mʋ ꞊sʋɛ ꞊tue, 'bʋʋ 'a mʋ ‑tɩ yɛɛ, 'ke 'le hɩ 'kwli 'mʋ, ‑ɛ nue, 'a mʋ mɔ 'na ‑naagbopʋʋ nɩ, ba kɔ plɔ a bleelɛ. ");
INSERT INTO ted_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ba nu 'manʋ, ‑ɛ nue, Nyɩsʋa di 'a mʋ ‑nyi 'wio gblaka, 'ke 'le yakɔ 'mʋ. Nyɩsʋa a winwlɔn‑hɛnyʋ ꞊nʋ, ‑ʋ nɩ la 'klɔ, ti ‑hi la a ti 'yri, kɛ'ɛ nɩ, nahuiin la nu, 'ʋʋ la ‑wɛ ꞊nʋ ꞊sʋɛ ꞊tue.» ");
INSERT INTO ted_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po: «‑Tɛ 'ta nɩ 'mʋ, 'ke 'o dididɛ ‑wɔn, kɛ'ɛ nɩ, a nɩ ‑wɛ 'mʋ, 'ke 'o ‑tʋtʋ ke a nahuin ‑wɔn. Kɛɛ, 'ta a ‑gbɛ, 'bɔ 'waan 'a wlɔnnɩnɔ, ‑ye ʋ 'die 'le ‑wɛ bʋ ‑nyi lele ꞊nɔ 'a wlɔnnɩnɔ a ‑gbɛ. Ɔ 'de 'klɛɛ lele ‑kʋan ꞊de kɔ, 'bɛ 'de bʋ puo 'kwla 'mʋ, nahuin bʋ nɔɔ ke. ");
INSERT INTO ted_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","'A mʋ'ʋ nɩ, ‑ʋ mɔ 'klɔ ‑gbo a ‑nyrɛ. 'Dɩɔ ꞊nʋ, ‑ɔ nɩ 'o dʋgba 'lu, ɛ 'de ‑huhlidɩɔ. ");
INSERT INTO ted_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nahuon 'bɔ 'bɩa 'napɩ, ‑ye ɔ 'nɩ ꞊jre ꞊le kaka 'lu gbo, kɛɛ, 'ke ɔ nye 'o dɛ 'lu gbo ꞊tu, ‑ɛ die nu, nahuin ꞊nʋ, ‑ʋ nɩ 'le kayu gbo, ʋ 'mʋ lɛ yrii. ");
INSERT INTO ted_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","‑Tɛ 'napɩɩ nu, 'ɛɛ wlɩn, 'ke 'o nahuin ꞊nʋ ‑wɔn, ‑ʋ nɩ 'le gbɩgbɩyrɩ ‑hɛyri, kɛ 'a nɩ nunuklɔ bɔ nu wʋnwlɛn, 'ke 'o nahuin ye, ‑ɛ die nu, ꞊hapʋdɛ ꞊nʋ, aa nu, ʋ 'mue 'ye, 'plɩɩ ʋ 'mʋ 'a nɩ Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ baa.» ");
INSERT INTO ted_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«'A nɩ ꞊wlɩ nɩ 'ye 'le, ‑ɛ mɔ, 'n di 'le ꞊le, 'ke ꞊bo ‑ha 'o tetei ꞊nʋ, Nyɩsʋa ‑nyi la 'a winwlɔn‑hɛnyɔ Moise, ɩ kɔ ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyʋ ‑ye 'crɩɩ la. 'N 'de 'le di, 'ke ꞊bo ‑hɩ 'o, kɛɛ 'n di 'le ꞊le, 'mʋ 'a mʋ tɔɔ, dɛ tio‑ ɩ ꞊hɛn 'nyrɛ, kɔ, ‑tɩ ‑gbo, ɩɩ ꞊tu, 'mui nu. ");
INSERT INTO ted_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","'Nɩɩ 'a mʋ 'nɩ le, ɛ 'de Nyɩsʋa a tetebʋ gbi kɔ, ‑bʋ di gbo ‑wɛ, ɛ 'mue gba ‑gbagba, yakɔ kɔ ‑tʋtʋ 'hɛɛn, ɩ 'mʋ gbo ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Nɛ‑ nue, nahuon 'bɔ nɩ 'o, 'bɔɔ Nyɩsʋa a tetebʋ 'cicrɛ gbii ‑do 'hru wlɔn ‑ha, kɔ, 'bɔ nye ‑wɛ ꞊ʋ ‑ye tɔɔ, nɔ‑ ʋ di nyɩ'cicrɛ daa, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔɔ 'o tetei 'o ꞊tuu, kɔ, 'bɔ nyi ‑wɛ ꞊ʋ ‑ye tɔɔ ‑tɛɛ, nɔ‑ ʋ di nyɩgblaka daa, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","'Nɩɩ 'a mʋ 'nɩ le: Dɛ ꞊nʋ, Nyɩsʋaa ‑hʋa, teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ʋ 'nɩ nue ꞊le. A ‑mɛ ‑ye, 'ba 'nɩnɩ ꞊tuu 'o Nyɩsʋa, 'ba 'de 'o nahuin a ‑gbɛ 'mʋ ‑hi, a 'die 'le ‑wɛ ba pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«A yie nɩ, ‑ɛ mɔ, tete ‑ye, Nyɩsʋa ‑nyi la ‑a nɩ bunʋ, ɛ nɔ 'nɩ: ꞊Nɩ 'la 'le nahuon. Nahuon 'bɔ 'la 'a 'be ‑tʋnahuon, ʋ dio lɛ poo ‑bati. ");
INSERT INTO ted_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","'Mɛ ‑ye, kɛ 'nɩɩ po: 'Ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ 'a 'dɩayu yrʋ lɛ poo, ʋ blɛ ye bʋ gbɔ 'o ‑batiponyɔ ye. Nahuon 'bɔ po lɛ 'a 'dɩayu ye: ‑N bʋba nɩ, ʋ blɛ ye bʋ gbɔ 'o 'blʋ a nahuin ye, ʋ 'muo ‑bati lɛ poo. Nahuon 'bɔ po ‑wɛ lɛ 'a 'dɩayu ye: Hanhɩnnyɔ, ‑ye ɔ blɛ ye bɔ mu 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe. ");
INSERT INTO ted_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","'Bɩa ꞊nɩɩ ‑cɔhlʋn pi, 'ke 'o Nyɩsʋa ye, 'plɩɩ 'bɩ bi 'le ‑mʋ 'kwli 'mʋ, ‑ɛ mɔ, ‑na 'dɩayu ‑ye, ɔ 'de plɔ a bleelɛ kɔ ‑na ‑tɩ, ");
INSERT INTO ted_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","hie 'o ‑na ‑cɔhlʋn a ‑gbɛ gbo, ‑bo mu, ‑n kɔ ‑na 'dɩayu a ‑gbɛ 'hɛɛn, a 'mʋ ‑tɩ a ‑gbɛ ꞊tu, ɩ 'mʋ 'le ‑wɛ, 'plɩɩ ꞊mʋ ‑wɔn ꞊hɩan, ꞊mʋ ‑cɔhlʋn pi, 'ke 'o Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","'Bɩa nahuon 'bɔ yɛɛ ‑mʋ ‑tɩ, ‑ɛ nue, ‑n 'ble kwa 'a 'wliyɛ, 'plɩɩ ‑n kɔ ꞊nɔ 'hɛɛn, 'baa 'le ‑batipoolɛ 'mʋ mu, ꞊mʋɛ lɛ, 'ke ‑n kɔ ꞊nɔ 'hɛɛn, ba kɔ kegbowɛɛnlɛ, ‑tɛ ‑n kɔ ꞊nɔ 'hɛɛn, a 'kɩɛ nɩɛ 'hru wlɔn, ɔ 'nɩ ꞊han 'le ‑mʋ ‑batiponyɔ ye gba, ‑batiponyɔ 'nɩ ꞊han ‑mʋ ‑sadapʋ kwa po, ʋ 'nɩ ꞊han ‑mʋ ꞊jɩ 'mʋ po. ");
INSERT INTO ted_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","'Nɩɩ ‑mʋ 'nɩ le, 'bʋ po ‑mʋ ꞊jɩ 'mʋ, 'ke ‑n di 'le ꞊jɩ a ‑gbɛ 'mʋ nɩ, 'wliyɛ 'bii, ꞊mue 'pɛɛ, 'plɩɩ ꞊mʋ ꞊jɩ 'mʋ ‑hɔn.» ");
INSERT INTO ted_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«A yie nɩ, ‑ɛ mɔ, tete ‑ye, Nyɩsʋa ‑nyi la ‑a nɩ bunʋ, ɛ nɔ 'nɩ: ꞊Nɩ nu 'le ‑wlawli. ");
INSERT INTO ted_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kɛɛ, 'mɛ ‑ye, kɛ 'nɩɩ po, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ 'a 'be a nyrʋgba 'ye, 'bɔ plɛ, ɔ nyo 'nɩ ‑hʋa, nahuon a ‑gbɛ, ɔ nu ‑wlawli, 'ke 'le 'a ꞊wlʋ ke, ɔ kɔ nyrʋgba a ‑gbɛ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","'Bɛ 'ya ‑na 'yii a ‑tɩ, ꞊nɩɩ dɛ 'kuku nu, ‑ye ‑bo ‑hɩ 'le, ꞊mui 'kwla 'mʋ po. Ɛ nu ‑tɛɛ, 'ke ‑bo po ‑na 'hʋɩn a 'pɩa ‑ye 'kwla 'mʋ, 'ɛ ‑hi 'o bʋ po 'le ‑na ꞊gble na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe. ");
INSERT INTO ted_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","'Bɛ 'ya ‑na diidɛdabʋ a ‑tɩ, ꞊nɩɩ dɛ 'kuku nu, ‑ye ‑bo 'bɩʋ 'o, ꞊mu 'kwla 'mʋ po. Ɛ nu ‑tɛɛ, 'ke ‑bo po ‑na 'hʋɩn a 'pɩa ‑ye 'kwla 'mʋ, 'ɛ ‑hi 'o ‑na ꞊gble ‑bo mu 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe.» ");
INSERT INTO ted_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Tete ‑ye, Nyɩsʋa ‑nyi la ‑a nɩ bunʋ, ɛ nɔ 'nɩ: Nahuon 'bɔ tɛ 'a nyrʋgba gbo, ɔ kɔ bɔ ‑nyi nyrʋgba a ‑gbɛ 'crɩɩnɩɛ, ‑ɛ nyi ꞊tu, ‑ɛ mɔ, ɔ tɩɔ gbo. ");
INSERT INTO ted_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kɛɛ, 'mɛ ‑ye, kɛ 'nɩɩ po: 'Ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ tɛ 'a nyrʋgba gbo, 'bɛ 'de 'laludɛ a ‑tɩ, 'plɩɩ nyrʋgba a ‑gbɛ 'bɔ kɔ tɔ ‑ye, ‑ye ye‑hɛtɔ ꞊nʋ, nɔ‑ nye nu, nyrʋgba a ‑gbɛ, 'ɔɔ ‑wlawli nu. Nyrʋgba ꞊nʋ, ɔ tɛ gbo, nahuon 'bɔ kʋɔ, ‑ye nahuon a ‑gbɛ, ɔɔ ‑wɛ nu ‑wlawli.» ");
INSERT INTO ted_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«A yie nɩ, ‑ɛ mɔ, tete ‑ye, Nyɩsʋa ‑nyi la ‑a nɩ bunʋ, ɛ nɔ 'nɩ: 'Bɩa ꞊nɩ 'sʋʋ Nyɩsʋa, ‑ɛ mɔ, dɛ ‑gbo, nɛ‑ ‑n di nu, ‑ye ꞊nɩ po 'le lele lɛ, ‑ɛ mɔ, ꞊nɩ nue ꞊le. Kɛɛ, 'bɩa ꞊nɩ 'sʋʋ Nyɩsʋa, ‑ɛ mɔ, dɛ ꞊nʋ, ‑n die 'nɩ nu, ‑ye nɛ‑ ‑bo nu. ");
INSERT INTO ted_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kɛɛ, 'mɛ ‑ye, kɛ 'nɩɩ po: A nɩ 'sʋ 'le gbe. Mɔ, a nɩ 'sʋʋ 'le yakɔ, ‑ɛ nue, nɔ‑ mɔ Nyɩsʋa a kegbonɩdɛ. ");
INSERT INTO ted_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Mɔ, a nɩ 'sʋʋ 'le ‑wɛ ‑tʋtʋ, ‑ɛ nue, nʋ‑ mɔ 'a bʋɩ a kegbo꞊tudɛ. Mɔ, ꞊nɩ 'sʋʋ 'le Jrusrɛdɩɔ, ‑ɛ nue, nɔ‑ mɔ Nyɩsʋa a 'dɩɔ. ");
INSERT INTO ted_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Mɔ, ꞊nɩ 'sʋʋ 'le ‑wɛ ‑na 'lu, ‑ɛ nue, ‑n 'de 'klɩ ꞊de kɔ, 'ke ‑bo nue, ‑na 'lu‑pupuu ‑do bʋ 'plɛ, kɔ, bʋ jre ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","'Bɛ 'ya iin 'mʋ, kɛ ba po: Iin, kɔ, 'bɛ 'ya 'ʋʋn 'mʋ, kɛ ba po ‑wɛ: 'Ʋʋn, ‑ɛ nue, 'sʋʋlɛ ꞊nʋ, ‑nɩɩ 'o ꞊nɔ 'lu po, ɛ mɔ 'yilɛnyredɛ'ɛ nɩ. 'Ke ɛɛ 'le 'kuo ‑hʋɩn a nyɩgblaka 'mʋ ‑hɔn.» ");
INSERT INTO ted_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«A yie nɩ, ‑ɛ mɔ, tete ‑ye, Nyɩsʋa ‑nyi la ‑a nɩ bunʋ, ɛ nɔ 'nɩ: Nahuon 'bɔ wa 'a 'be a 'yie, 'a ‑gbɛ, ʋ kɔ bʋ wa ‑wɛ 'a 'yie. Nahuon 'bɔ ‑ha 'le 'a 'be a 'nyɛɛ, 'a ‑gbɛ, ʋ kɔ bʋ ‑ha ‑wɛ 'le 'a 'nyɛɛ. ");
INSERT INTO ted_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kɛɛ, 'mɛ ‑ye, kɛ 'nɩɩ po: Nahuon 'bɔ nu 'a mʋ 'yilɛnyredɛ 'mʋ, a nɩ 'we 'le 'a nɩ dɩɔnʋ klɛ. Nahuon 'bɔ po 'le ‑na diidɛnʋa 'ŋma 'mʋ, ‑hɩɔ mɛ lɛ, bɔ po 'le ‑na kamranʋa 'ŋma 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nahuon 'bɔɔ ‑hʋa bɔ yɛɛ ‑mʋ ‑tɩ, 'ke 'le ‑batiponyɔ ye, 'bɔɔ ‑na wlawlʋ ‑hʋa, ‑hɩɔ mɛ lɛ bɔ gba ‑wɛ ‑na 'kɔlɔ. ");
INSERT INTO ted_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nahuon 'bɔ nɩ 'o ‑mʋ ke 'mʋ, 'ke ‑bo 'ble 'a blɔ ‑kiloyɛɛ ‑do 'yri, ‑ye ‑bo po 'o 'a 'hɔn a nɛnɛ. ");
INSERT INTO ted_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nahuon 'bɔɔ ‑mʋ dɛ ‑hʋa, ‑ye ‑bo ‑nye ꞊nɔ. Nahuon 'bɔɔ ‑hʋa bɔ 'trɔsɩ ‑mʋ dɛ, ꞊nɩ blɛ 'le ke.» ");
INSERT INTO ted_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«A yie nɩ, ‑ɛ mɔ, tete ‑ye, Nyɩsʋa ‑nyi la ‑a nɩ bunʋ, ɛ nɔ 'nɩ: Nʋɛ ‑n 'be 'mʋ, kɛɛ, yraa ‑na yraanyɔ. ");
INSERT INTO ted_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kɛɛ, 'mɛ ‑ye, kɛ 'nɩɩ po: Ba nʋɛ 'a nɩ yraanyʋ 'mʋ, kɔ, ba da Nyɩsʋa, 'ke 'o nahuin ꞊nʋ a ‑ta 'mʋ, ‑ʋʋ 'a mʋ ꞊sʋɛ ꞊tue, ");
INSERT INTO ted_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","‑ɛ die nu, a 'mʋ 'a nɩ Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ a 'yuo ‑hɛ, ‑ɛ nue, 'crɛnyʋ kɔ ꞊hapʋnyʋ 'hɛɛn, ʋ 'bii a ‑gbɛ, Nyɩsʋaa ꞊nʋ ‑nyi 'yrʋ a pepe'. Nahuin ꞊nʋ, ‑ʋ 'sii 'o ye, kɔ nahuin ꞊nʋ, ‑ʋ 'de 'o ye 'sii, Nyɩsʋa nye 'nɩ nu, 'nu 'ʋʋ di, 'ke 'o nahuin 'bii a ‑gbɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","'Bɩa 'ba nʋɛ nahuiin ‑do ꞊nʋ 'mʋ, ‑ʋ nʋɛ 'a mʋ 'mʋ, 'a nɩ ꞊wlɩ nɩ 'ye 'le, ‑ɛ mɔ, 'a ‑tɩ Nyɩsʋa di 'a mʋ 'mʋ nu ꞊hapʋdɛ. Dɛɛ ‑do a ‑gbɛ, nɛ‑ 'crɛnyʋʋ ‑wɛ nu. ");
INSERT INTO ted_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","'Bɩa 'baa 'a nɩ 'dɩayuoo ‑do ꞊hapʋdɛ 'mʋ nu, 'a nɩ ꞊wlɩ nɩ 'ye 'le, ‑ɛ mɔ, aa nu dɛ gblaka. Dɛ a ‑gbɛ, nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, nɛ‑ ʋʋ ‑wɛ nu. ");
INSERT INTO ted_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ba 'sii 'o ye, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'a nɩ Bu Nyɩsʋa ꞊nʋ, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ nu, 'ɔ 'sii 'o ye.» ");
INSERT INTO ted_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«'Bɩa 'baa ꞊sʋɛnyʋ ꞊hapʋdɛ 'mʋ nu, a nɩ nue 'le, 'ke 'o nahuin 'yi ke, ‑ɛ die nu, nahuin a ‑gbɛ, ʋ 'mʋ 'a mʋ baa a ‑tɩ. 'Bɩa 'baa lɛ ꞊hapʋdɛ a ‑gbɛ a nunue nu, 'a nɩ Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ 'deɛ bɔ ‑nyi 'a mʋ 'a 'wio. ");
INSERT INTO ted_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","'Bɩa ꞊nɩɩ ꞊sʋɛnyʋ dɛ ‑nyi, 'ke 'o 'waa 'mʋ‑hɛɛlɛ a ‑ta 'mʋ, ꞊nɩ ꞊tui 'le nahuin 'bii ye, ‑ɛ 'we ꞊nɔ ye, nahuin ꞊nʋ, ‑ʋʋ 'lii 'hɔn naa, ‑tɛ ʋ nye nu. Nahuin a ‑gbɛ, 'bʋ nu ꞊sʋɛnyʋ ꞊hapʋdɛ 'mʋ, ‑ye ʋʋ 'a ‑tɩ ‑wɔn lɛ 'nɩ na, 'ke 'le Nyɩsʋa a kayuo gbo, kɔ, 'ke 'le 'dika. Ʋ nye 'nɩ nu, ‑ɛ die nu, nahuin 'mu baa. 'Nɩɩ 'a mʋ 'nɩ le, nahuin a ‑gbɛ, ‑ʋʋ lɛ nu, Nyɩsʋa 'deɛ bɔ ‑nyi ꞊nʋ 'a 'wio, ‑ɛ nue, ‑tʋnahuin po 'waa 'wio gbo nɩ ‑dodo. ");
INSERT INTO ted_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","‑Mɛ ‑ye, 'bɩa ꞊nɩɩ ꞊sʋɛnyʋ dɛ ‑nyi, nue, 'ke ꞊ɔ ꞊de nɩ 'wɩn 'le, mɔ ꞊betɩ ‑na ꞊wlʋ a nɩnatumu a ‑gbɛ, ɔ nɩ 'wɩn 'le, ");
INSERT INTO ted_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","‑ɛ die nu, 'mʋ‑hɛɛlɛ a ‑gbɛ a ‑tɩ 'mʋ ‑hli. 'Bɩa ꞊nɩɩ lɛ 'a nunue nu, ‑ye ‑na Bu Nyɩsʋa, ‑ɔɔ 'ɛ nɩ ‑huhlidɛ ‑nɩɩ nu 'ye, nɔ‑ di ‑mʋ 'a 'wio ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«'Bɩa 'baa Nyɩsʋa da, a nɩ dɔ 'le, ‑ɛ 'we ꞊nɔ ye, ‑tɛ nahuin ꞊nʋ, ‑ʋʋ 'lii 'hɔn naa, ʋʋ 'a dɩda nu. Nahuin a ‑gbɛ, 'bʋ nyo da, ʋ nʋɛ 'mʋ bʋ nyra gblɛ, 'ke 'le Nyɩsʋa a kayuo gbo, kɔ 'ke 'le 'dika. 'Bʋʋ lɛ nu, ɛ 'we ꞊nɔ ye, nahuin 'mu 'ye a ‑tɩɩ nɩ. 'Nɩɩ 'a mʋ 'nɩ le, nahuin a ‑gbɛ, ‑ʋʋ lɛ nu, Nyɩsʋa 'deɛ bɔ ‑nyi ꞊nʋ 'a 'wio, ‑ɛ nue, ‑tʋnahuin po 'waa 'wio gbo nɩ ‑dodo. ");
INSERT INTO ted_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kɛɛ, ‑mɛ ‑ye, 'bɩa ꞊nɩɩ ‑hʋa ‑bo da Nyɩsʋa, pa 'le ‑na ‑gblo 'mʋ, ‑bo po 'o 'maju. ꞊Nɩ pu 'klɛɛ 'o, ‑ye ‑bo da ‑na Bu Nyɩsʋa, ‑ɔ nɩ 'o ‑mʋ 'hʋɩn 'mʋ. ‑Ye ‑na Bu Nyɩsʋa a ‑gbɛ, ‑ɔɔ 'ɛ nɩ ‑huhlidɛ ‑nɩɩ nu 'ye, nɔ‑ di ‑mʋ 'a 'wio ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","'Bɩa 'baa Nyɩsʋa da, 'a nɩ 'pʋprɛwin nɩ ‑huo 'le, ‑ɛ 'we ꞊nɔ ye, ‑tɛ nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, ʋʋ 'a dɩda nu. Ʋ ‑mɛ ‑ye, ʋ nɔ 'nɩ, 'waa 'pʋprɛwin 'bɩ ‑huo, 'plɩɩ Nyɩsʋa 'mʋ 'waa win 'wɔn. ");
INSERT INTO ted_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dɛ ꞊nʋ, ʋʋ nu, a nɩ nue 'le ‑wɛ, ‑ɛ nue, 'a nɩ Bu Nyɩsʋa, 'plɩɩ a 'muo dɛ mu ‑hʋa, ɔ yi dɛ a ‑gbɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","‑Tɛ a di Nyɩsʋa a dɩda nu, nɛ‑ ‑gbo: ‑A nɩ Bu, ‑ɔ nɩ 'le yakɔ 'mʋ, nue, nahuin 'bii 'mue yi, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa. ");
INSERT INTO ted_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","‑Mɔɔ nɩ, ‑bɔ kɔɔ nahuin win ke. ‑Na kewɛɛnlɛ, nɛ‑ ‑bɛ nue, kɛ nɔ ‑tʋtʋ ke, kɔ 'ke 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","‑Nye kɛ ‑a mʋ ‑nyrɔwɔ ‑gbo a dididɛ. ");
INSERT INTO ted_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","‑A nɩ 'yilɛnyre‑tɔplɩ ‑gbo, ‑a nu, ‑hri 'a ‑tɩ ‑wɔn, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑aa nu, ꞊aa 'yilɛnyre‑tɔplɩ ꞊nʋ a ‑tɩ ‑wɔn ‑hri, nahuin nu ‑a mʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","꞊Nɩ wɛɛn 'le ke, 'kuo ‑hʋɩn a nyɩgblaka nɩ ꞊tɔ 'le ‑a mʋ 'mʋ lɛ, ‑ɛ die nu, ‑a 'nɩ ꞊han ‑tɩ 'wla, kɛɛ, ‑ha 'le ‑a mʋ 'kuo ‑hʋɩn a nyɩgblaka kwa 'mʋ, ‑ɛ nue, ‑mɔɔ nɩ, ‑ɔ blɛ ye ‑bɔ kɔɔ nahuin win ke, kɔ, ‑mɔɔ nɩ, ‑ɔ kɔ 'klɩ kɔ ‑tɩ a 'yi'bʋbʋa ‑tɛ 'klɔ tɛ ye gbo. Kɛ'ɛ nɩ, bɛ nɩ 'mʋ. Kɛ'ɛ nɩ, ba nu Nyɩsʋa a dɩda! ");
INSERT INTO ted_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","'Yilɛnyre‑tɔplɩ ꞊nʋ, nahuin nu 'a mʋ 'mʋ, 'bɩa 'baa 'a ‑tɩ ‑wɔn ‑hri, ‑ye 'a nɩ Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ di ‑wɛ 'a nɩ 'yilɛnyre‑tɔplɩ, a nu a ‑tɩ ‑wɔn 'nɩ ‑hri. ");
INSERT INTO ted_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kɛɛ, 'yilɛnyre‑tɔplɩ ꞊nʋ, nahuin nu 'a mʋ 'mʋ, 'ba 'nɩnɩ ‑hri 'a ‑tɩ ‑wɔn, ‑ye 'a nɩ Bu Nyɩsʋa, ɔ 'deɛ bɔ ‑hri ‑wɛ 'a nɩ 'yilɛnyre‑tɔplɩ, a nu a ‑tɩ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«'Bɩa 'baa ꞊ci, ('ke 'o Nyɩsʋa a dɩda a ‑ta 'mʋ,) a nɩ ꞊tɩɔ 'le 'o 'a nɩ yigbakla 'o, ‑ɛ 'we ꞊nɔ ye, ‑tɛ nahuin ꞊nʋ, ‑ʋʋ 'lii 'hɔn naa, ʋʋ nu. Nahuin a ‑gbɛ, 'bʋʋ ꞊ci, ‑ye ʋ kɔ bʋ ꞊tɩɔ 'o 'waa yigbaklɩ 'o, ‑ɛ die nu, nahuin 'bii, ʋ 'mue 'ye, ‑ɛ mɔ, ʋʋ 'nɩ ꞊ci. 'Nɩɩ 'a mʋ 'nɩ le, nahuin a ‑gbɛ, ‑ʋʋ lɛ nu, Nyɩsʋa 'deɛ bɔ ‑nyi ꞊nʋ 'a 'wio, ‑ɛ nue, ‑tʋnahuin po 'waa 'wio gbo nɩ ‑dodo. ");
INSERT INTO ted_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kɛɛ, ‑mɛ ‑ye, 'bɩa ꞊nɩɩ ꞊ci, ‑ye ‑bo yra 'yi ꞊hlɔn lɛ, ‑bo po ‑na 'lu ‑tɛɛ, ");
INSERT INTO ted_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","‑ɛ die nu, nahuin 'nɩ ꞊hien 'ye, ‑ɛ mɔ, ‑nɩɩ 'nɩ ꞊ci. Kɛɛ, ‑na Bu Nyɩsʋaa ‑do ꞊nʋ, ‑ɔɔ 'ɛ nɩ ‑huhlidɛ ‑nɩɩ nu 'ye, nɔ‑ di ‑mʋ 'a 'wio ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«A nɩ 'kukue 'le kʋkɔ‑tɔplɩ lɛ, kɛ nɔ 'klɔ ‑gbo ke, ‑tɛ 'hrɔ kɔ ꞊jawe 'hɛɛn, ɩɩ nɔ ‑tɔplɩ 'yi lɛ nyree, kɔ, ‑tɛ 'yrinyʋʋ nɔ kayuo waa. ");
INSERT INTO ted_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kɛɛ, ba 'kukue kʋkɔ‑tɔplɩ lɛ, 'ke 'o Nyɩsʋa 'hʋɩn 'mʋ, ‑tɛ 'hrɔ kɔ ꞊jawe 'hɛɛn, ɩ 'nɩnɩ nyree 'le ‑tɔplɩ 'yi lɛ, kɔ, ‑tɛ 'yrinyʋ 'nɩnɩ waa 'le kayuo, ");
INSERT INTO ted_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","‑ɛ nue, ‑tɛ ‑na kʋkɔ‑tɔplɩ nɩ 'o, 'ke ‑na ꞊wlʋ nɩ ‑wɛ 'o.» ");
INSERT INTO ted_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«‑Tʋnahuon a ꞊wlʋ, ʋ 'we ꞊nɔ 'a 'yii ye, ‑ɩ nyo ‑nyrɛ ‑nyi. ‑Na 'yii 'bɩ nu ‑tɛɛ, ‑ye ‑nɩɩ lɛ 'nɩ yrii ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Kɛɛ, ‑na 'yii 'bɩ kɔ kɩkla, ‑ye 'ke ‑n nɩ 'le gbɩgbɩyrɩ ‑hɛyri. ‑Ye ‑nyrɛ, ‑ɛ nɩ 'le ‑mʋ 'mʋ, 'bɛ 'ya gbɩgbɩyrɩ 'mʋ, ‑ye gbɩgbɩyrɩ a ‑gbɛ, ɩ di 'nɩ jre 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Nahuon ꞊de 'die 'le ‑wɛ, tii ‑do 'yri, bɔ nu 'masɛpʋʋ 'hɔn a ‑kʋan. Ɔ di yraa ꞊ɔ ‑ye, ɔ 'mʋ ꞊ɔ ‑ye 'mʋ nʋɛ. Ɛ 'die 'le ‑wɛ, tii ‑do 'yri, Nyɩsʋa bɔ kɔɔ ‑mʋ win ke, 'plɩɩ 'wliyɛ bɛ kɔɔ ‑wɛ ‑mʋ win ke.» ");
INSERT INTO ted_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Nɛ‑ nue, 'nɩɩ 'a mʋ le: Dɛ a di di, kɔ, dɛ a di 'na, kɔ, wlawlɩ a di 'hʋɩn 'mʋ lɛ pue, a nɩ hrɛti 'le, 'ke 'o ‑tɔplɩ a ‑gbɛ a ‑ta 'mʋ. ‑Hʋnhlʋn ‑gbo, aa po, ɛ mɔ dɛ gblakaa nɩ, 'ɛ ‑hi 'o dididɛ 'mʋ, kɔ, 'a nɩ ‑plahʋɩn, ɛ mɔ dɛ gblakaa nɩ, 'ɛ ‑hi 'o 'hʋɩn'mʋlɛpue‑tɔplɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ba 'ye kɛ nʋblɩ. Ɩ 'nɩ 'dɔ ꞊le 'ɛ nɩ dididɛ ꞊de, kɔ, ɩ 'nɩ 'cɛ ꞊le dɛ ꞊de, kɔ, ɩ 'nɩ po ꞊le 'le dɛ ꞊de 'kale. Kɛɛ, 'a nɩ Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, nɔ‑ nyi dididɛ ‑nyi. Kɛɛ, a ‑mɛ ‑ye, Nyɩsʋa, ɔ nʋɛ 'a mʋ 'mʋ nɩ, 'ɛ ‑hi 'o nʋblɩ 'mʋ. 'A ‑tɩ, ‑tɛ ɔɔ nu, 'ɔɔ nʋblɩ dididɛ ‑nyi, ɔ die ‑wɛ 'nɩ nu, ɔ 'mʋ 'a mʋ dididɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɛ 'de nahuon ꞊de kɔ, 'ke 'le 'a mʋ ‑hɛyri, 'a hrɛtilɛ a ‑tɩ, ‑bɔ kɔ 'klɩ, 'ke ‑bɔ po 'a ‑nyrɔwɩ a dɛ gbi ke, kɛ nɔ 'klɔ ‑gbo ke. ");
INSERT INTO ted_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Dɛ‑ kɔ hrɛtilɛ aa hrɛti 'le? ꞊Be 'hʋɩn'mʋlɛpue‑tɔplɩ a ‑tɩ? Ba 'ye kɛ ‑piti ꞊nʋ, ‑tɛ 'a ‑puii ꞊gɩga nu, 'plɩɩ, ‑tɛ ɩ nu 'yilɛnɩnɔ. ‑Piti a ‑pui a ‑gbɛ, ɩ 'we ꞊nɔ ‑tʋnahuon a wlawlɩ ye. Kɛɛ, ‑piti a ‑gbɛ, ɩ 'nɩ nu ꞊le ‑kʋan, kɔ, ɩ 'nɩ hra ꞊le wlawlɩ, 'ɩ nɔ 'yi lɛ. ");
INSERT INTO ted_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kɛɛ ‑ye 'nɩɩ 'a mʋ 'nɩ le, bodɩɔ Salomɔ, ꞊hapʋkɔ, 'ɔ kɔ la dɛ, kɛɛ, ‑tɛ ‑piti a ‑pui nu 'yilɛnɩnɔ, Salomɔ a ‑gbɛ, ɔ 'de la 'a wlawlʋ kɔ, ‑bʋ nu la lɛ 'yilɛnɩnɔ. ");
INSERT INTO ted_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nyɩsʋa 'bɔ kɔ bɔ nɔɔ kɛ ‑piti a ‑pui 'yi lɛ kɛkɛ ‑gbo, ʋ di ‑ŋa ‑ci, 'plɩɩ ʋ di ‑ŋa 'tɔ po, ꞊be 'a mʋ ꞊nʋ, ɔ nʋɛ 'mʋ, ɔ 'deɛ bɔ ‑nyi 'a mʋ 'hʋɩn'mʋlɛpue‑tɔplɩ? 'A mʋ ‑gbo, ‑ʋ 'de Nyɩsʋa ꞊wlʋ ye kuo ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","'A ‑tɩ, a nɩ 'wʋʋ 'le 'a nɩ 'kwli a ‑koto 'mʋ, kɔ, a nɩ hrɛti 'le, 'ke 'o 'hʋɩn'mʋlɛpue‑tɔplɩ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, nʋ‑ʋ ‑tɔplɩdʋ a ‑gbɛ 'lu ‑wɔn lɛ ‑hie 'ɛ nɩ ti. Kɛɛ, 'a nɩ Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ yi 'a nɩ ‑hʋhʋa‑tɔplɩ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Dɛ, ‑ɛ mɔ ye‑hɛdɛ, a blɛ ye ba ‑hie 'lu ‑wɔn lɛ 'ɛ nɩ ti, nɛ‑ mɔ Nyɩsʋa bɔ kɔɔ 'a mʋ win ke, kɔ, 'a nɩ 'klɔ bɔ 'sii 'o ye, 'ke 'o Nyɩsʋa ye, ‑ye ɔ di 'a mʋ 'a nɩ ‑hʋhʋa‑tɔplɩ a ‑gbɛ 'nɩ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","A nɩ hrɛti 'le, 'ke 'o ‑ŋaŋa a ‑nyrɔwɔ ‑wɔn, ‑ɛ nue, Nyɩsʋa a ‑gbɛ, ‑ɔ yi ‑nyrɔwɔ a ‑gbɛ a 'kla‑wliye'yɩya, nɔ‑ di ‑ŋa 'a mʋ 'mʋ ‑hɛ. ‑Tɛ ɔɔ nu, 'ɔɔ kɛ 'a mʋ 'mʋ ‑hɛ, kɛkɛ a ‑nyrɔwɔ ‑gbo 'kwli 'mʋ, kɛ ɔ di ‑ŋa nu, ɔ 'mʋ ‑ŋa 'a mʋ 'mʋ ‑hɛ, 'ke 'le ‑nyrɔwɔ yrayrʋ a ‑gbɛ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«A nɩ yɛɛ 'le 'a nɩ 'bienʋ ‑tɩ, ‑ɛ die nu, Nyɩsʋa 'nɩ ꞊han ‑wɛ 'a mʋ ‑tɩ yɛɛ, ");
INSERT INTO ted_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","‑ɛ nue, ‑tɛ aa 'a nɩ 'bienʋ a ‑tɩ a yɛɛlɛ nu, kɛ'ɛ nɩ, Nyɩsʋa di ‑wɛ 'a nɩ ‑tɩ a yɛɛlɛ nu, kɔ, ‑tɛ a di 'a nɩ 'bienʋ a 'yiye nu, kɛ Nyɩsʋa di ‑wɛ 'a nɩ 'yiye nu. ");
INSERT INTO ted_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Dɛ‑ kɔ ‑tɩ ꞊nɩɩ ‑n 'be a praprʋ ꞊nʋ 'ye, ‑ʋ nɩ 'le ꞊nɔ 'yi 'mʋ, 'plɩɩ ꞊nɩnɩ 'ye ‑wɛ ‑n nɛ tikla꞊tɩɔ ꞊nʋ, ‑ɔ nɩ 'le ‑mʋ 'yi 'mʋ? ");
INSERT INTO ted_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","‑N 'de ye blɛ ‑bo le ‑n 'be, ‑ɛ mɔ: Nɛ‑ ꞊bo ‑ha 'le ‑mʋ praprʋ 'yi 'mʋ, ‑mɔ ꞊nʋ, tikla꞊tɩɔ nɩ 'le 'yi 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","‑Mɔ ꞊nʋ, ‑ɔɔ 'lii 'hɔn naa, ye‑hɛdɛ ‑n kɔ ‑bo nu, ‑ha 'le ‑n nɛ tikla꞊tɩɔ ꞊nʋ 'yi 'mʋ, ‑ɛ die nu, ꞊mʋ lɛ yrii ‑tɛɛ, 'plɩɩ ꞊mʋ 'le ‑n 'be ꞊nʋ praprʋ 'yi 'mʋ ‑ha. ");
INSERT INTO ted_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Dɛ ‑gbo, Nyɩsʋa kɔ, a nɩ ‑nye 'le nahuin ꞊nʋ, ‑ʋ 'de 'o ye 'sii, ‑ʋ 'we ꞊nɔ bʋɩcɩ ye, kɔ, dɛ ‑gbo, ‑ɛ kɔ 'mini, 'ke 'o 'a mʋ ‑wɔn, a nɩ ‑nye 'le nahuin ꞊nʋ, ‑ʋ 'de 'a 'mini yi, ‑ʋ 'we ꞊nɔ ‑gbo ye, ‑ɛ nue, 'ba ‑nye ꞊nʋ, ʋ die klɛ 'nɩ na, 'plɩɩ ʋ 'mʋ ‑wɔn ꞊hɩan, ʋ 'mʋ 'a mʋ gbo di ‑wɔ.» ");
INSERT INTO ted_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«'Baa dɛ ‑hʋa, ba ‑hʋɛ Nyɩsʋa, ɔ 'mue 'a mʋ ‑nyi. 'Baa dɛ ‑hʋa, ba ꞊mʋɛ lɛ, a die 'nɩ 'ye. 'Baa ‑hʋa 'ke bʋ paa 'a mʋ kayu gbo, ‑ye ba bi gbɔgbɔ, ‑ye ʋ di 'a mʋ 'nɩ le: Ba di pa. ");
INSERT INTO ted_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","'Ɛ mɔ ‑tɛɛ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ Nyɩsʋa dɛ ‑hʋa, ‑ye ɔ die ꞊nɔ 'nɩ ‑nyi. Nahuon 'bɔɔ dɛ lɛ ꞊mɔ, ɔ die 'nɩ 'ye. Nahuon 'bɔ nyra 'o ꞊gbuhan.ye gbo, 'bɔɔ gbɔgbɔ po, ‑ye ʋ dio 'nɩ le, bɔ pa. ");
INSERT INTO ted_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‑Mɔ bu, ‑na 'yu 'bɔɔ ‑mʋ 'flɔɔ ‑hʋa, ꞊be ‑n dio ‑nyi 'hɩɔ? ");
INSERT INTO ted_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Kɔ, 'bɩa 'bɔɔ ‑mʋ ‑hrin.e ‑hʋa, ꞊be ‑n dio ‑nyi hre? ");
INSERT INTO ted_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","꞊Hapʋkɔ, 'a mʋ ‑tʋnahuin 'a 'de ꞊hapʋnahuin, kɛɛ, ꞊hapʋ‑tɔplɩ, nɩ‑ aa 'mʋ lɛ 'jra, 'a nyi 'a nɩ 'yuo꞊pli ‑nyi. 'Bɩa 'bɛ nɩ lɛ 'mʋ, 'ke 'o 'a mʋ ‑wɔn, ‑ʋ kɔ ꞊wlɩ nyre 'yi lɛ, ‑ye 'a nɩ Bu, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ di nahuin ꞊hapʋ‑tɔplɩ ꞊nʋ 'nɩ ‑nyi, ‑ʋ nyi ꞊nɔ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","꞊Hapʋdɛ 'bii ꞊nʋ, aa ‑hʋa nahuin ‑ye bʋ nu 'a mʋ 'mʋ, 'a nɩ ‑gbɛ, nɛ‑ ba nu ‑wɛ ꞊nʋ 'mʋ. Dɛɛ ‑do a ‑gbɛ, nɛ‑ Nyɩsʋa a teteii tɔɔ, ɛ kɔ Nyɩsʋa a winwlɔn‑hɛnyʋ 'hɛɛn.» ");
INSERT INTO ted_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Paalɛ ꞊nʋ, ‑ɛɛ 'le 'a mʋ Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ paa, ɛ 'cɩmɩ lɛ 'yri. 'Bɩa 'ba nye ‑hʋa, 'ke ba pa 'le Nyɩsʋa a 'klɔ yrayrʋ a ‑gbɛ 'kwli 'mʋ, ‑ye ba naa 'o paalɛ a ‑gbɛ 'yri, ‑ɛ nue, paalɛ ꞊nʋ, ɛ kɔ 'hru ꞊nʋ 'hɛɛn, ‑ɩɩ 'le 'a mʋ 'waanlɛ 'mʋ gba, ɩ 'bʋa lɛ 'yri, 'a wlɔnnaalɛ 'de wlɔn kla, 'plɩɩ nahuin ꞊nʋ, ‑ʋʋ 'le ꞊nɔ wlɔn naa, ʋ ‑huo nɩ. ");
INSERT INTO ted_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kɛɛ, paalɛ ꞊nʋ, ɛ kɔ 'hru ꞊nʋ 'hɛɛn, ‑ɩɩ 'le 'a mʋ Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ paa, ɩ 'cɩmɩ lɛ 'yri, 'a wlɔnnaalɛ kla wlɔn, 'plɩɩ nahuin ꞊nʋ, ‑ʋ nyu na, ʋ 'de ‑huo.» ");
INSERT INTO ted_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ba ‑gbɛ 'a nɩ dɩɔnʋ, 'ke 'o hɩtɔɔnyʋ a ‑ta 'mʋ. 'Bɩa 'ba nyu 'ye, ‑ye a nɔ 'nɩ, ʋ 'nɩ nu ꞊le dɛ 'klan ꞊de. Kɛɛ, sɛyɩ‑sɛyɩ, ʋʋ gbo ‑wɔ nahuin. Ʋ 'we ꞊nɔ ‑jio ye, ‑ɔ pue 'blakʋɛ. ");
INSERT INTO ted_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","'Waa nunuŋmli, ʋʋ nu, nɩ‑ die nu, a 'mu yrii. ꞊Bo pue lele tikui a dɛ ye. Nahuon ꞊de 'nɩ ‑ha ꞊le ‑gbʋgbɔnʋ, 'ke 'o dakawi 'yri. Mɔ, nahuon ꞊de 'nɩ ‑ha ꞊le ‑wɛ bubuokui, 'ke 'le hɩnhranwu 'klɔ. ");
INSERT INTO ted_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tugbɛ ꞊nʋ, ‑ɛɛ ꞊hapʋ'nie ‑jri, ɛɛ tʋ ꞊hapʋ'kui. Kɛɛ, tugbɛ ꞊nʋ, ‑ɛ 'nɩnɩ ‑jri ꞊hapʋ'nie, ɛ 'nɩ tʋ ꞊le ꞊hapʋ'kui. ");
INSERT INTO ted_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tugbɛ ꞊nʋ, ‑ɛɛ ꞊hapʋ'nie ‑jri, ɛ 'deɛ bɛ tʋ 'kui ‑hʋɩn. Mɔ, tugbɛ ꞊nʋ, ‑ɛ 'nɩnɩ ‑jri ꞊hapʋ'nie, ɛ 'deɛ bɛ tʋ ꞊hapʋ'kui. ");
INSERT INTO ted_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","'Ɛ nɩ tugbɛ, ‑ɛ 'nɩnɩ tʋ ꞊hapʋ'kui, ʋ nye 'nɩ hra, 'ʋ nye 'tɔ po. ");
INSERT INTO ted_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","'A ‑tɩ o, hɩtɔɔnyʋ ꞊nʋ, 'waa nunuŋmli, ʋʋ nu, nɩ‑ die nu, a 'mu yrii.» ");
INSERT INTO ted_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Ɛ 'de 'ɛ nɩ nahuon ꞊nʋ, ‑ɔɔ 'mʋ Kʋkɔnyɔ daa ti a pɛpɛ, ɔ 'deɛ bɔ pa 'le Nyɩsʋa a 'klɔ 'kwli 'mʋ. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔɔ dɛ ꞊nʋ nu, 'na Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔɔ ‑hʋa, nɔ‑ di 'le pa. ");
INSERT INTO ted_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","‑Nyrɔwɔ ꞊nʋ ‑kɔ 'mʋ 'n di 'o nahuin ‑bati lɛ poo, kɛ nahuin 'plɔplɔ di 'mʋ ye po: Kʋkɔnyɔ o, 'ke 'le ‑na 'dʋ 'kwli 'mʋ, ‑a ꞊tu Nyɩsʋa a ‑tɩ, kɔ, 'ke 'le ‑na 'dʋ 'kwli 'mʋ, ꞊a bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ, kɔ, 'ke 'le ‑na 'dʋ a ‑gbɛ 'kwli 'mʋ, ꞊a nu 'ŋmilɛka‑tɔplɩ 'plɔplɔ. ");
INSERT INTO ted_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","‑Ye kɛ 'n diu ye po: 'N 'de ‑hlɩn 'a mʋ a yie. Ba hren 'mʋ ‑wɔn, 'a mʋ ꞊nʋ, ‑ʋ 'nɩnɩ nu dɛ ꞊nʋ, Nyɩsʋaa ‑hʋa.» ");
INSERT INTO ted_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«'A ‑tɩ o, 'ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɩ ‑gbo, 'n ꞊tu wɛn, 'bɔ nyi nʋa ye gbo po, 'plɩɩ 'bɔ nyi nu, ‑ye ɔ 'we ꞊nɔ ꞊tɔkɔnyɔ ꞊nʋ ye, ‑ɔ po 'a kayu, 'ke 'o 'hɩɔ 'pa ke, ‑ɛ die nu, ʋ 'mʋ gbo ku ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","‑Tɛ ɔ pu 'klɛɛ, ‑ye 'nu bi 'o ꞊o, 'niei 'ɩ 'yi, pepe 'ɛɛ ‑hi 'dɔ, 'ɩ ‑wɔn kayu a ‑gbɛ ye, kɛɛ, ʋ 'de 'wlɛ, ‑ɛ nue, 'ke ɔ pu 'o 'hɩɔ ke. ");
INSERT INTO ted_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kɛɛ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɩ ‑gbo 'n ꞊tu wɛn, 'bɔ nyi nʋa ye gbo po, kɛɛ, 'bɔ 'nɩnɩ nui, ‑ye ɔ 'we ꞊nɔ nahuon ꞊nʋ ye, ‑ɔ 'de ꞊tɔ kɔ, ‑ɔ po 'a kayu, 'ke 'o 'pʋhʋɔn ke. ");
INSERT INTO ted_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","‑Tɛ ɔ pu 'klɛɛ, ‑ye 'nu bi 'o ꞊o, 'niei 'ɩ 'yi, pepe 'ɛɛ ‑hi 'dɔ, 'ɩ ‑wɔn kayu a ‑gbɛ ye, ‑ye kayu a ‑gbɛ, ʋ 'wlɛ nɩ, 'ʋ nyre 'yi lɛ 'bii.» ");
INSERT INTO ted_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","'Plɩɩ ‑Yusu 'mʋ tɔɔlɛ a ‑gbɛ 'lu mu ‑yra, ‑ye ‑tɛ ɔ nu tɔɔlɛ a ‑gbɛ, ɛ saka nahuin ꞊nʋ nɩ, ‑ʋ nɩ 'o, ");
INSERT INTO ted_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","‑ɛ nue, ‑tɛ Nyɩsʋa a teteitɔɔnyʋ, ʋʋ nahuin a tɔɔlɛ nu, ɔ 'nɩ nu ꞊le lɛ tɔɔlɛ, kɛɛ, 'ke 'le 'klɩ 'kwli 'mʋʋ nɩ, 'ke ɔɔ 'le tɔɔ. ");
INSERT INTO ted_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusuu ꞊tɩ dʋgba, nahuin a ꞊ju 'ʋ nyo ‑wɔn kʋɛ. ");
INSERT INTO ted_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bɔɔ 'klɛɛ 'le di, ‑ye ‑tɔplɩ‑jɔhʋɩnnunyɔ ꞊de, nɔ‑ mu 'o ‑Yusu ye, 'ɔ blɔ kwlɩ ye gbo, ɔ nɔ: «Kʋkɔnyɔ o, 'nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, nue, 'na 'kʋɛ bɛ ‑wɛ!» ");
INSERT INTO ted_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","‑Yusu 'ɔ 'tʋɔ lɛ, ɔ nɔ: «'N nye 'nɩ ‑hʋa, ‑na 'kʋɛ bɛ ‑wɛ.» Tii ‑do a ti 'yri, ‑ye 'a 'kʋɛ ‑wɛ nɩ, ");
INSERT INTO ted_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","'ɔ lo, ɔ nɔ: «꞊Nɩ ꞊tui 'le nahuon ꞊de ye gbe! Kɛɛ, mu ‑bo titie ‑n dɩɔnʋ Nyɩsʋa a ‑cɔhlʋnpinyɔ ye, ɔ 'mue 'ye, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ. 'A ‑tɩ, gba ‑tɔplɩ ꞊nʋ, ʋʋ nu, 'ʋʋ ‑cɔhlʋn pi, 'ke 'o Nyɩsʋa ye, ‑tɛ Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, ɔ nu la 'a ꞊tutue ye‑hɛ‑nyrɛ 'mʋ, ‑ɛ die nu, nahuin 'bii, ʋ 'mui yi, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ!» ");
INSERT INTO ted_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","‑Nyrɔwɔ ꞊de 'mʋ, ‑ye 'ke ‑Yusu mu 'le Kapɛnaɔdɩɔ 'mʋ. ‑Tɛ ɔ pa 'klɛɛ 'dɩɔ 'mʋ, ‑ye Romakʋɛ a 'sɔyuo a nyɩgblaka ꞊de, nɔ‑ muo 'o 'hʋɩn 'mʋ, 'ɔ nyo lɛ 'batɩ, ");
INSERT INTO ted_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ɔ nɔ: «Tɔɔnyɔ o, 'na ‑kʋannunyɔ pɛ gbo, 'ke 'le kayu gbo, ‑ɛ nue, ɔ ‑yɩyrɛ lɛ, 'ɔɔ ꞊sʋɛ 'ye 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «'N di 'le 'nɩ di, 'mue nu, 'a 'kʋɛ 'mʋ ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kɛɛ ‑ye 'sɔyuo a nyɩgblaka a ‑gbɛ, ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Tɔɔnyɔ o, 'mɔ ‑gbo, ‑ɔ 'de ‑Juukʋɛyu, 'n 'de ye blɛ ‑bo pa 'le 'na kayu gbo. Po wuun ‑do, 'na ‑kʋannunyɔ a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","'Na ‑gbɛ ‑gbo, 'n kɔ nyɩgblakɩ ‑ye, 'ʋ kɔɔ 'mʋ win ke. 'Mɛ ‑ye, 'n kɔ 'sɔyuo ‑ye, 'nɩ kɔɔ ꞊nʋ win ke. 'Bɩa 'nɩ po wun, 'nɩ le 'a nahuon, 'ke bɔ mu, ‑ye ɔɔ 'nɩ mu, kɔ, 'nɩ le ꞊ɔ ‑ye, 'ke bɔ di 'le, ‑ye ɔɔ 'le 'nɩ di. Kɔ, 'bɩa 'nɩ le 'na ‑kʋannunyɔ, 'ke bɔ nu dɛ, ‑ye ɔ nye 'nɩ nu.» ");
INSERT INTO ted_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","'Plɩɩ ‑Yusu 'mʋ win a ‑gbɛ mu 'wɔn, ‑ye ‑tɩ ꞊nʋ, 'sɔyuo a nyɩgblaka a ‑gbɛ, ɔ ꞊tu, ɩ saka ꞊nɔ nɩ, 'ɔɔ 'le nahuin ꞊nʋ ‑wɔn 'prɛɛ, ‑ʋ nyo ‑wɔn kʋɛ, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon, bɔ di lɛ 'na ꞊wlʋ a yekuolɛ nu, 'n 'de ‑hlɩn 'a nahuon a 'yee, ꞊betɩ bɛ 'ya nɔ Yisraɛkʋɛ a dakʋ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","'Nɩɩ 'a mʋ 'nɩ 'le, 'ke 'le 'yrʋ a 'hrɩɩlɛ 'mʋ, kɔ 'yrʋ a paalɛ 'mʋ, 'ke nahuin di 'le 'mʋ lɛ ‑hɔn, ʋ 'mʋ lɛ 'kukue, ʋ kɔ ‑a nɩ bunʋ Abrahamʋ, kɔ Yisakɩ, kɔ Sakɔbʋ 'hɛɛn, ʋ 'mʋ dɛ ‑wɔn didi, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kɛɛ, Yisraɛkʋɛ ‑ye ꞊nʋ, Nyɩsʋa da, 'ke bʋ pa 'le 'a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ, Nyɩsʋa diu 'le 'mʋ po ‑patʋ, 'ke 'le gbɩgbɩyrɩ ‑hɛyri. 'Ke ʋ di 'o ꞊hien wee, kɔ, 'ke ʋ di ‑wɛ 'o yrʋ poo.» ");
INSERT INTO ted_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","‑Yusu bɔ ‑yrɛ 'klɛɛ, ‑ye kɛ ɔɔ 'sɔyuo a nyɩgblaka a ‑gbɛ ye po, ɔ nɔ: «‑N kue ye ꞊wlʋ, ‑ɛ mɔ, Nyɩsʋa di ‑na ‑kʋannunyɔ a 'kʋɛ 'nɩ ‑wɔ. 'A ‑tɩ, ɔ di dɛ a ‑gbɛ 'nɩ nu. ‑N ‑wɛ 'le ‑bo mu 'le kayu gbo nɩ.» Tii ‑do ꞊nʋ ‑kɔ 'yri ‑Yusu ꞊tuu 'o ‑tɩ ꞊nʋ, 'kee nɩ, 'sɔyuo a nyɩgblaka a ‑kʋannunyɔ a ‑gbɛ a 'kʋɛ ‑wɛɛ 'o. ");
INSERT INTO ted_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","‑Nyrɔwɔ ‑ye 'mʋ, ‑ye 'ke ‑Yusu mu 'le Piɛlɩ a ‑tɛ. ‑Tɛ ɔ pa kayu gbo, ‑ye 'ke ɔ yɛ 'o Piɛlɩ a 'dɔɔ gbo. ‑Ye ɔ 'ye nɩ, ‑ɛ mɔ, 'a 'hʋɩn hren nɩ, 'ɔ pɛ gbo, ");
INSERT INTO ted_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","‑Yusu 'ɔ klɩ 'a dabʋ gbo. ‑Ye Piɛlɩ a 'dɔɔ a ‑gbɛ, 'a 'hʋɩn 'kee nɩ, 'ɔ 'ba ye 'mʋ, 'ɔ pi ‑Yusu a dididɛ. ");
INSERT INTO ted_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","‑Wisepepei 'mʋ, ‑tɛ ‑wuwle‑nyrɔwɔ ‑wɛ 'le, ‑ye nahuin 'plɔplɔ, 'kuo ‑hʋɩn nɩ 'o ke 'mʋ, nʋ‑ ʋ gba 'le ‑Yusu ‑wɔn, ‑Yusu 'ɔ bla 'kuo a ‑gbɛ lɛ, 'ɔ ‑wɔ nahuin 'bii a ‑gbɛ a 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ɔ nue nɩ, ‑ɛ die nu, ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Esai, ɔ 'crɩɩ la, ɩ 'mʋ 'lu ‑wɔn mue. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «Ɔ ꞊gbla ‑a mʋ nɩ, 'ke 'o ‑a nɩ 'kʋɛi ‑wɔn, 'plɩɩ 'ɔ gbɩ.» ");
INSERT INTO ted_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","‑Yusu 'ye nɩ, ‑ɛ mɔ, nahuin 'plɔplɔ, nʋ‑ ꞊glaa 'le ꞊nɔ. Nɛ‑ nue, 'ɔ le 'a ‑naagbopʋ, 'ke bʋ ꞊ta 'le 'yru a 'pɩa ꞊nʋ ke. ");
INSERT INTO ted_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bɔ po 'klɛɛ lɛ, ‑ye Nyɩsʋa a teteitɔɔnyɔ ꞊de, nɔ‑ 'yɩya 'o ꞊nɔ ye gbo, ɔ nɔ: «Tɔɔnyɔ o, 'ɛ nɩ ‑tɛgbi, ‑n di 'o muu, 'n di ‑mʋ ‑wɔn 'nɩ kʋɛ.» ");
INSERT INTO ted_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «'Kwlagbodɛhʋɛi, ɩ kɔ gbopɛɛlɛi, nʋblɩ 'ɩ kɔ 'lɛ, kɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n 'de gbopɛɛlɛ kɔ, ‑tɛ 'n di 'o ke lɛ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","‑Ye nahuon ‑ye, ‑ɔ mɔ ‑wɛ ‑Yusu a ‑naagbopʋyu, kɛ ɔɔ ‑Yusu ye po, ɔ nɔ: «Tɔɔnyɔ, 'plɩɩ 'mʋ ‑mʋ ‑wɔn kʋɛ, ‑ha 'mʋ mɛ lɛ, 'na bu, ‑ɔ 'kʋ, ꞊bo muo 'o ‑ha, 'plɩɩ 'mʋ 'le di, 'mʋ ‑mʋ ‑wɔn naa.» ");
INSERT INTO ted_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","‑Ye ‑Yusu nɔ: «Ɛ 'de ‑na ‑kʋan, 'ke ‑bo ‑ha 'o 'kʋkʋkui lɛ. Kɛɛ, ‑mɛ ‑ye, kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'mʋ ‑wɔn naa ‑tɛɛ!» ");
INSERT INTO ted_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Bɔ po 'klɛɛ lɛ, ‑ye 'ke ‑Yusu 'ya 'le 'blagbe wlɔn, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bʋ nɩ 'klɛɛ 'o 'nie ke, bʋʋ mu, tii ‑do a ti 'yri, ‑ye ‑hlonpʋ gblaka cɛ 'le ꞊le, 'yru 'ʋʋ 'dʋɩ po, 'a 'dʋɩ a ‑gbɛ 'ɩɩ 'le 'blagbe wlɔn lɛ 'wlɛɛ. Kɛɛ, ‑Yusu ‑mɛ ‑ye, ɔɔ 'nɩ ŋmo, ");
INSERT INTO ted_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","'a ‑naagbopʋ 'ʋ 'yɩyɔ 'o 'hʋɩn 'mʋ gbo, 'ʋ ‑hɩɔ ŋmla 'mʋ, ʋ nɔ: «Tɔɔnyɔ o, waa ‑a mʋ, ‑aa gbo mu 'nɩ ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «Dɛ tio‑ kɔ ‑tɩ 'aa hʋannʋ pɩ 'le? 'A mʋ ‑gbo, ‑ʋ 'de Nyɩsʋa ꞊wlʋ ye kuo ‑tɛɛ?» 'Plɩɩ 'ɔ 'ba ye 'mʋ, 'ɔ 'prɛɛ 'le ‑hlonpʋ kɔ 'yru 'hɛɛn ‑wɔn, 'ke 'le win 'yaklɩ 'kwli 'mʋ, ‑ɛ die nu, ɩ 'mʋ ke gbo ‑wan, ‑ye 'ɛ mɔ ‑tɛɛ, ‑hlonpʋ ꞊nʋ, ʋ nyra gbo. ");
INSERT INTO ted_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","‑Ye ʋ 'bii, ɩ saka ꞊nʋ nɩ, ʋ nɔ: «Ba 'ye kɛ nahuon ‑gbo, ‑hlonpʋ kɔ 'yru 'hɛɛn, ɩ nyo ‑wɛ 'o 'nɩ ꞊tuu.» ");
INSERT INTO ted_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ʋ nyre 'le Galileblʋgba a 'yru a 'pɩa ꞊nʋ ke nɩ, ‑ɔ mɔ Gadalakʋɛ a 'blʋgba. ‑Tɛ ʋ nyre 'le, ‑ye nyɩbɛpʋʋ 'hɔn ꞊de, nʋ‑ ‑hɔn 'le 'dɛɛi ke 'mʋ, 'ʋ mu ‑Yusu ye 'mʋ 'bɛ wɔn. Nahuiin 'hɔn a ‑gbɛ, 'kuo ‑hʋɩn nɩ 'o ꞊nʋ 'ke 'mʋ, 'ɔɔ ꞊nʋ ꞊sʋɛ ꞊tue. 'Waa ŋmli a 'yilɛnyinyre nue, nahuon ꞊de 'ɔ 'die 'le ‑wɛ bɔ na 'o 'hru ꞊nʋ wlɔn, ‑ʋ kɔ wlɔn ʋ nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Bʋ 'ye 'klɛɛ ‑Yusu, ‑ye ʋʋ 'le 'yaa win, ʋ nɔ: «Nyɩsʋa a 'Yu, dɛ tio‑ ‑n ‑hʋa ‑bo nu ‑a mʋ 'mʋ 'le? ꞊Be ‑n di 'le ꞊le, ꞊mʋ ‑a mʋ ꞊sʋɛ ꞊tue, 'plɩɩ Nyɩsʋa a ‑batipo‑nyrɔwɔ 'mʋ 'o nyre?» ");
INSERT INTO ted_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","'Ke 'o ‑tɛgbii ‑do a ‑gbɛ, bʋɩcɩ a ꞊ju gblaka, nʋ‑ nɩ 'le ꞊nʋ ye 'mʋ, 'ʋʋ lɛ wa. ");
INSERT INTO ted_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","‑Ye 'kuo ‑hʋɩn a ‑gbɛ, ɔɔ ‑Yusu lɛ 'nɩ 'batɩ, ɔ nɔ: «'Bɩa ꞊nɩɩ ‑hʋa ‑bo bla ‑a mʋ lɛ, wɛɛn ke, 'ke ‑ba bi 'o bʋɩcɩ a ꞊ju ꞊nʋ ke 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","‑Ye ‑Yusu nɔ: «Ba mu!» 'ɔ ‑hɔn 'o nahuiin 'hɔn a ‑gbɛ ke 'mʋ, 'ɔ bi 'o bʋɩcɩ ꞊nʋ ke 'mʋ, bʋɩcɩ 'bii a ‑gbɛ, 'ɩ 'gba ci lɛ, 'ɩ ꞊tɩ dʋgba, 'ɩ bi 'yru 'mʋ lɛ, 'ɩ 'kʋkʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nahuin ꞊nʋ, ‑ʋʋ bʋɩcɩ a ‑gbɛ naa, ʋ 'gba lɛ ci, 'ʋ 'ya 'dɩɔ 'mʋ, 'ʋ na ‑tɔplɩ 'bii ꞊nʋ ‑wɔn lɛ, ‑ɩ mue 'lu ‑wɔn, 'ke 'o nahuiin 'hɔn ꞊nʋ a ‑ta 'mʋ, 'kuo ‑hʋɩn nɩ wɛn 'o ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","'Plɩɩ 'dɩɔ a nahuin 'bii 'mui mu 'wɔn, ‑ye ʋ ꞊tɩ 'mʋ 'dɩɔ, 'ʋ mu ‑Yusu ye 'mʋ 'bɛ wɔn. ‑Tɛ ʋ 'yo, ‑ye ʋ nyo lɛ 'nɩ 'batɩ, 'ke bɔ ‑hɔn 'le 'waa 'blʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye 'ke ‑Yusu 'ya 'le 'blagbe wlɔn, 'ɔ ꞊ta lele 'yru ꞊nʋ ke, 'ɔ mu 'le 'dɩɔ ꞊nɔ 'mʋ, ‑ɔ kɔ 'mʋ ɔ 'ti 'le. ");
INSERT INTO ted_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","‑Tɛ ɔ nyre 'le, ‑ye nahuin ꞊de, nʋ‑ ya ꞊nɔ lɛ‑yɩyrɛnyɔ ꞊de ye. Lɛ‑yɩyrɛnyɔ a ‑gbɛ, 'ke ʋ puo 'le ‑hanmakɩ wlɔn. ‑Tɛ ‑Yusu 'ye, ‑ɛ mɔ, nahuin a ‑gbɛ, ʋ kuo ye ꞊wlʋ, ‑ɛ mɔ, ɔ ‑wɛ 'le bɔ nue nɩ, 'waa nɩ lɛ‑yɩyrɛnyɔ a ‑gbɛ, 'a 'kʋɛ bɛ ‑wɛ nɩ, ‑ye kɛ ɔɔ lɛ‑yɩyrɛnyɔ a ‑gbɛ ye po, ɔ nɔ: «'Na 'yu o, ‑na ꞊wlʋ nɩ bi 'le ꞊hlɔn, ‑tɔplɩ ‑gbo, ‑n nu, ‑ɩ nyre 'yi lɛ, 'ke 'o Nyɩsʋa ye, ɩ 'wʋwlɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","‑Ye Nyɩsʋa a teteitɔɔnyʋ ꞊nʋ, ‑ʋ nɩ 'o, kɛ ʋʋ 'waa dɩɔnʋ ye po, ʋ nɔ: «‑Tɩ ‑gbo, ‑Yusu ‑gbo, ɔɔ ꞊tu, ɛ 'we ꞊nɔ ye, Nyɩsʋa a ‑tɩ ɔɔ lɛ ‑haa.» ");
INSERT INTO ted_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kɛɛ, dɛ ꞊nʋ, ʋʋ ꞊wlɩ klɛ naa, ‑Yusu yie nɩ. Ɔ nɔ: «Dɛ tio‑ kɔ 'yilɛnyre꞊wlɩdʋ ꞊nʋ aa lɛ naa 'le? A 'de kɔ ba naa wɛn ꞊wlɩdʋ ꞊nʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","'A nɩ ꞊wlɩ nɔ 'nɩ, 'n 'die 'le ‑wɛ ꞊bo le lɛ‑yɩyrɛnyɔ ‑gbo, ‑ɛ mɔ, 'a dɛ 'kuku 'wʋwlɛ nɩ, kɔ, 'a nɩ ꞊wlɩ nɔ 'nɩ, 'n 'die ‑wɛ 'le ‑wɛ ꞊bo le ꞊nɔ, ‑ɛ mɔ, bɔ 'ba ye 'mʋ, bɔ na. ");
INSERT INTO ted_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Kɛɛ, ba yie, 'mɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mɔ mɔ Nyɩsʋa a 'Yu, 'ɔ lee nɔ 'mʋ. Nyɩsʋa a ‑gbɛ, nɔ‑ ‑nye 'mʋ 'klɩ, 'ke ꞊bo 'wʋwla ‑tʋnahuin a dɛ 'kuku, kɛ nɔ ‑tʋtʋ ke, 'ɔ ‑nye ‑wɛ 'mʋ 'klɩ, 'ke ꞊bo ‑wɔ ‑tʋnahuin a 'kʋɛi. 'A ‑tɩ o, nahuon ‑gbo, ʋ ya 'le, 'n die 'nɩ nu, 'a 'kʋɛ 'mʋ ‑wɛ, a 'mue yrii, ‑ɛ mɔ, ‑tɩ ‑gbo, 'n ꞊tu wɛn 'a mʋ ye, ɩ mɔ ꞊hapʋkɔɔ nɩ.» ‑Ye ɔ ꞊hɩan ‑wɔn, 'ɔɔ 'le lɛ‑yɩyrɛnyɔ ꞊nʋ ‑wɔn 'prɛɛ, ɔ nɔ: «'Ba ye 'mʋ, 'ba ‑na ‑hanmakɩ 'mʋ, ‑bo mu 'le ‑na kayu gbo, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tii ‑do a ti 'yri, ‑ye nahuon a ‑gbɛ, ɔ 'ba 'mʋ ye, 'ɔ mu 'le 'a kayu gbo. ");
INSERT INTO ted_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","‑Tɛ nahuin 'ye dɛ a ‑gbɛ, ʋ 'ta 'mʋ gblɛ, 'ʋʋ Nyɩsʋa 'nyrɛɛ lɛ pue, ‑tɛ ɔ nu, 'ɔ ‑nyi ‑tʋnahuin 'klɩdʋ ꞊nʋ. ");
INSERT INTO ted_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu ‑hɔn 'le ‑tɛgbi a ‑gbɛ 'mʋ nɩ. ‑Tɛ ɔɔ 'klɛɛ mu, ‑ye 'ke ɔ yɛ 'o nyɩbɛyu ꞊de gbo. 'A 'dʋ mɔ Matie. Matie a ‑gbɛ, ɔ mɔ 'blʋwli'tɛnyɔ'ɔ nɩ. 'Ke ɔ nɩ 'le 'blʋwli'tɛɛlɛ 'mʋ gbo. (Kɛɛ, nahuin 'nɩ ‑hʋa ꞊le 'blʋwli'tɛnyʋ, ‑ɛ nue, ʋʋ di 'yiyriwli.) ‑Ye kɛ ‑Yusu nyo ye po, ɔ nɔ: «Kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'na ‑naagbopʋyu ‑hɛ!» Matie a ‑gbɛ 'ɔ 'ba ye 'mʋ, 'ɔ kʋɔ ‑wɔn, 'ke ɔ 'muo ‑wɔn naa. ");
INSERT INTO ted_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","‑Ye Matie a ‑gbɛ, ɔ da ‑Yusu ‑wɔn dididɛ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, kɔ, 'ɔ da ‑wɛ 'a 'bienʋ 'blʋwli'tɛnyʋ ‑ye, kɔ pʋpʋnahuin ‑ye, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, 'ke ʋ 'bii, ʋ 'mʋ dɛ di. ");
INSERT INTO ted_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bʋ nɩ 'o dɛdiilɛ 'mʋ, ‑ye Falisi꞊tumu a nahuin, ʋ 'ye dɛ a ‑gbɛ nɩ. ‑Ye ʋ le ‑Yusu a ‑naagbopʋ nɩ, ʋ nɔ: «Dɛ‑ nue 'klɛɛ, 'a nɩ tɔɔnyɔ, ɔ kɔ 'blʋwli'tɛnyʋ kɔ nahuindʋ ‑gbo 'hɛɛn, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, 'ʋ nɩ 'o dɛdihuoo ‑do ke gbo 'le? Ɔ 'de wɛn ye blɛ bɔ nu wɛn dɛ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","‑Ye ‑Yusu 'wɔn ‑tɩ ꞊nʋ nɩ, nahuin a ‑gbɛ, ʋ ꞊tu. Bɔ 'wɩn 'klɛɛ, ‑ye ɔ nɔ: «Nahuon ‑gbo, ‑ɔ kɔ 'hʋɩn nu ‑tɛɛ, ɔ 'nɩ ꞊mɔ ꞊le ‑data a 'yiye lɛ, kɛɛ, nahuon ‑gbo, ‑ɔ kɔ 'hʋɩɩn‑ hren, nɔ‑ɔ ‑data a 'yiye lɛ ꞊mɔ. ");
INSERT INTO ted_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Nyɩsʋa nɔ 'nɩ: Dɛ ‑gbo, 'nɩɩ ‑hʋa, nɛ‑ mɔ, ba kɔ 'a nɩ 'bienʋ a wɔlɩ. Ɛ 'de ba pi 'wlugba‑tɔplɩ a ‑cɔhlɩɩn ‑do, 'ke 'o 'mʋ ‑wɔn.» ‑Ye kɛ ‑Yusuu lele po: «'N 'de 'le di, 'ke 'o nahuin ‑gbo a ‑ta 'mʋ, ‑ʋ plɛ, ‑ʋ kɔ 'klɔ 'sii 'o ye, kɛɛ, nahuin ‑gbo, ‑ʋ yie, ‑ɛ mɔ, 'waa 'klɔ 'de 'o ye 'sii, nʋ‑ kɔ ‑tɩ 'nɩ di 'le, 'mu le, ‑ɛ mɔ, bʋ hie 'o 'waa dɛ 'kuku, ʋʋ nu gbo, bʋ ‑nye 'waa 'klɔ 'bii Nyɩsʋa.» ");
INSERT INTO ted_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye Saan Batisɩ, ‑ɔɔ nahuin 'nie 'lu lɛ po, 'a ‑naagbopʋ, nʋ‑ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: «Dɛ‑ nue 'klɛɛ, ‑a mʋ ‑gbo, ‑ʋ mɔ Saan a ‑naagbopʋ, ‑a kɔ Falisi꞊tumu a nahuin 'hɛɛn ꞊aa ꞊ci, 'plɩɩ ‑mɛ ‑ye, ‑n nɛ ‑naagbopʋ 'ʋ 'nɩnɩ ꞊ci 'le?» ");
INSERT INTO ted_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «Nyɩbɛyu ‑gbo, ‑ɔɔ 'blɩ 'mʋ pa, 'bɔ da 'a 'bienʋ 'blɩ'mʋpʋpa a dididɛ ke, 'bʋ mu 'blɩ'mʋpʋpa a ‑gbɛ a dɛdi‑tuo ke, 'a 'bienʋ a ‑gbɛ, ʋ 'nɩ ꞊ci ꞊le. Ɛ 'we ꞊nɔ ye, 'blɩ'mʋpʋpa ꞊nʋ, ɛ mɔ 'manʋdɛ'ɛ nɩ. 'A ‑tɩ, ʋ 'de ꞊cicie kɔ. Dɛɛ ‑do a ‑gbɛ, nɛ‑ɛ nɩ. 'Manʋ a ‑tɩ 'na ‑naagbopʋ 'nɩ ꞊ci ꞊le nɩ, tii ‑tie ‑gbo 'n di mɔ ꞊nʋ 'hʋɩn 'mʋ ‑hi. Kɛɛ, ɛ di kɔ ti, ‑ɩ kɔ 'yri ʋ di ‑tado 'o 'mʋ 'na ‑naagbopʋ ‑hɛyri ‑ha. Ti a ‑gbɛ 'yri, 'ke ʋ di ‑tado 'o ꞊cii. ");
INSERT INTO ted_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‑A 'brikʋɛ nɔ 'nɩ: Nahuon ꞊de 'nɩ 'ba ꞊le dayrayrʋ a 'pɩa 'mʋ, ɔ 'nɩ ‑ma ꞊le da'ka a 'hʋɔ. 'Bɩa 'bɔ nu dayrayrʋ a 'pɩa, 'bɔ ‑ma da'ka a 'hʋɔ, ti ‑kɔ 'yri ɔ diu yra, ‑ye dayrayrʋ ꞊nʋ, ʋ 'yɩya 'mʋ nɩ. 'Bʋ 'yɩya 'mʋ, ‑ye dayrayrʋ a ‑gbɛ, ʋ cra da'ka ꞊nʋ nɩ. ‑Ye 'a 'hʋɔ 'ka ꞊nʋ, ɔ di lɛ 'bʋa 'yri ꞊hapʋkɔ. ");
INSERT INTO ted_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Mɔ, nahuon ꞊de 'nɩ 'ba ꞊le nɔ yrayrɩ 'mʋ, ‑ɔɔ 'plu, ɔ 'nɩ puo ꞊le 'le dahʋakɔ a buo 'ka wlɔn. 'Bɔ puo 'le buo 'ka ꞊nʋ wlɔn, 'bɔ kɔ ye, ti ‑kɔ ti 'yri ɔ di 'plu, 'bɔɔ 'ya, ‑ye ɔ cra dahʋakɔ a buo ꞊nʋ nɩ. ‑Ye nɔ 'wlɛ gbo. Nɛ‑ nue, 'ke 'le dahʋakɔ a buo yrayrʋ wlɔn, 'ke ʋʋ 'le nɔ yrayrɩ po. 'Bɔ nu lɛ, ‑ye dahʋakɔ a buo ꞊nʋ, ɔ kɔ nɔ ꞊nʋ 'hɛɛn, ɩ 'deɛ bɩ nyre 'yi lɛ. (Ɛ nɛ‑ nue o, nahuon ꞊de 'ɔ 'nɩnɩ 'ba ‑tɔplɩ 'kɩ 'mʋ, 'ɔ 'nɩnɩ pui ‑tɔplɩ yrayrɩ ke. Ɩ 'nɩ bibi ꞊le 'yi 'mʋ lɛ.)» ");
INSERT INTO ted_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","‑Yusu bɔɔ ꞊nʋ ‑tɩ ꞊nʋ ye ꞊tu, ‑ye ‑Juukʋɛ a nyɩgblaka ꞊de, nɔ‑ nyre 'o, 'ɔ blɔ kwlɩ ye gbo, ɔ nɔ: «'Na 'yu nyrɔyu gbi, nɔ‑ 'kʋ lɛ kɛ 'klɛɛ. 'Nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, di 'le ‑bo puo dabʋɩ 'lu gbo, ‑ɛ die nu, ɔ 'mʋ lele ‑hʋnhlʋn po.» ");
INSERT INTO ted_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","‑Ye ‑Yusu wɔn nɩ, 'ɔ 'ba ye 'mʋ, 'ɔ kʋɔ ‑wɔn, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","‑Ye 'klɛɛ, 'ke 'le nahuin ꞊nʋ ‑hɛyri, ‑ʋ nɩ 'o, 'ke nyrʋgba ꞊de nɩ 'le. Nɔ‑ 'kʋɛɛ nu. 'A 'kʋɛ a ‑gbɛ, nɛ‑ mɔ dablo bɔ nyo gbo ‑wɛ. ‑Tɛ 'kʋɛ a ‑gbɛ, ɛ 'tatɩ la 'a nunue, 'a 'yrʋ a ‑pu ꞊tu 'o 'hɔn a nʋnʋ nɩ kɛ gbo. Nɔ‑ mu 'o ‑Yusu ke 'mʋ, 'ɔ 'tʋ 'a wlawlʋ a bʋgbodɛ lɛ, ");
INSERT INTO ted_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","‑ɛ nue, kɛ ɔɔ po, 'ke 'le 'a ꞊wlʋ ke: «'Nɩ 'tʋ 'a wlawlʋ lɛɛ ‑do, 'na 'kʋɛ di 'nɩ ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","‑Ye ‑Yusu ꞊hɩan ‑wɔn, 'ɔ 'yo, ɔ nɔ: «'Na 'yu o, ‑na ꞊wlʋ nɩ bi 'le ꞊hlɔn. ‑Tɛ ‑n kuo 'mʋ ꞊wlʋ ye a ‑tɩ, 'nɩ ‑wɔ ‑na 'kʋɛ.» Tii ‑do a ‑gbɛ 'yri, ‑ye nyrʋgba a ‑gbɛ a 'kʋɛ ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu nyre 'le ‑Juukʋɛ a nyɩgblaka ‑nɩ wɛn a ‑tɛ nɩ, 'ɔ 'ye ‑tɔplɩbinyʋ kɔ nahuin 'plɔplɔ ꞊nʋ 'hɛɛn, 'ʋʋ popowli po, ‑ye ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","«Ba ꞊tɩɩ ke! 'Yu nyrɔyu ‑gbo, ɔ 'de 'kʋ. Ŋmla'a nɩ, ɔɔ ŋmo.» Bɔ po 'klɛɛ lɛ, ‑ye ʋ nyo 'nɩ 'caa. ");
INSERT INTO ted_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","‑Ye ʋ 'hrɔɔ nahuin 'bii nɩ, 'ɔ pa 'le ‑gblo ꞊nʋ 'mʋ, ‑tɛ 'yu pɛ 'le gbo, 'ɔ klɩ 'a dabʋ gbo. ‑Ye 'yu nyrɔyu a ‑gbɛ, ɔ 'hrɩ 'klɔ, 'ɔ 'ba ye 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dɛ a ‑gbɛ, ‑ɛ mue 'lu ‑wɔn, 'a ‑tɩ 'sɛɛ gbo, 'ke 'le 'blʋgba 'bii ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu ‑hɔn 'o ‑tɛgbi a ‑gbɛ 'mʋ nɩ, 'ɔɔ mu. ‑Tɛ ɔɔ 'klɛɛ mu, ‑ye 'yiisuanyʋʋ 'hɔn ꞊de, nʋ‑ bio 'o ke 'mʋ, 'ʋ nyo ‑wɔn kʋɛ, 'ʋʋ 'le win 'yaa, ʋ nɔ: «Dafidɩ a 'yuo a 'Yu o, yrii ‑a nɩ wɔlɩ!» ");
INSERT INTO ted_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","‑Tɛ ‑Yusu nyre 'le kayu gbo, ‑ye ʋ 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, 'ɔ ꞊gbʋ wlɔn: «꞊Be a kuo 'mʋ ye ꞊wlʋ, ‑ɛ mɔ, 'n ‑wɛ 'le ꞊bo ‑wɔ 'a nɩ 'kʋɛ nɩ?» ‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «Iin ‑o, Tɔɔnyɔ, ‑a kuo ‑mʋ ye ꞊wlʋ.» ");
INSERT INTO ted_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","‑Ye ‑Yusu 'tʋ 'waa 'yii lɛ, ɔ nɔ: «Dɛ ꞊nʋ, a kuo ꞊wlʋ ye, 'n ‑wɛ 'le ꞊bo nu 'a mʋ 'mʋ, nɛ‑ ‑bɛ mue 'lu ‑wɔn,» ");
INSERT INTO ted_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","'waa 'yii 'ɩ klɛ ke. ‑Ye ‑Yusu 'prʋʋ 'le ‑wɔn, 'ke 'le win 'yaklɩ 'kwli 'mʋ, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le, a nɩ le 'le nahuon ꞊de!» ");
INSERT INTO ted_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ʋ ‑mɛ ‑ye, ‑tɛ ʋ ‑hɔn 'o 'mʋ, ‑ye ʋ 'sɛɛ ‑Yusu a 'dʋ gbo, 'ke 'le 'blʋgba 'bii ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ti ꞊nʋ ‑kɔ 'yri nahuin a ‑gbɛ, ʋʋ mu, tii ‑do a ‑gbɛ 'yri, ‑ye ʋ ya ‑Yusu ye nahuon ꞊de, ‑ɔ 'de 'prɛlɛ yi, ‑ɛ nue, 'ku ‑hʋan nɩɔ 'o ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","‑Ye ‑Yusu bla 'ku ‑hʋan a ‑gbɛ lɛ, ‑ʋ nɩ 'o nahuon a ‑gbɛ ke 'mʋ. ‑Tɛ ɔ blʋ 'klɛɛ lɛ, ‑ye nahuon a ‑gbɛ, ɔ ‑tʋa 'pʋprɛ gbo. Nahuin ꞊nʋ, ‑ʋ nɩ 'o, ɩ saka ꞊nʋ nɩ 'dɔ, ʋ nɔ: «Dɛ ‑gbo, ‑ɛ mue 'lu ‑wɔn, ‑a 'die ‑hlɩn a 'yee, kɛ nɔ Yisraɛkʋɛ a 'bri.» ");
INSERT INTO ted_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kɛɛ ‑ye Falisi꞊tumu a nahuin ꞊nʋ, ‑ʋ nɩ ‑tuo ke, kɛ ʋʋ po, ʋ nɔ: «Satan, ‑ɔ mɔ 'kuo ‑hʋɩn a nyɩgblaka, nɔ‑ɔ ꞊nɔ 'klɩ ‑nyi, 'ke bɔ bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusuu ke na 'dɩɛ 'bii, 'ɔɔ Nyɩsʋa a ‑tɩ tɔɔ, 'ke 'le Nyɩsʋa a kayuo gbo, 'ɔɔ Nyɩsʋa a ꞊hapʋtitie ꞊nʋ po, ‑ɛ nyi ꞊tu, ‑tɛ Nyɩsʋa di nahuin a win a kekɔɔlɛ nu, kɔ, 'ɔɔ nahuin a 'kʋɛi 'bii ‑wɔ, ɩ kɔ 'ɛ nɩ kɩkladɛ ꞊de 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","‑Tɛ ɔɔ nahuin 'plɔplɔ ꞊nʋ 'ye, ‑ye 'waa wɔlɩ nyo nu, ‑ɛ nue, 'waa 'klɩ ‑wɛ 'le ꞊le, kɔ 'waa ꞊wlɩ 'ɩ bi ꞊hlɔn. Ʋ 'we ꞊nɔ blablɔ ye, ‑ɔ 'de kʋkɔnyɔ kɔ. ");
INSERT INTO ted_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","‑Ye kɛ ɔɔ 'a ‑naagbopʋ ye po, ɔ nɔ: «꞊Gbla, ‑ɔ ꞊hlu, ɔ ‑huo nɩ, kɛɛ, ꞊gbla'cɛnyʋ 'de ‑huo. ");
INSERT INTO ted_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","'A ‑tɩ, ba 'batɩ ‑cikɔnyɔ lɛ, bɔ le 'a ‑kʋannunyʋ ‑ye, ʋ 'mʋ 'a mʋ 'mʋ ‑hɛ, a 'mʋ ꞊gbla 'cɛ.» (Ɛ 'we ꞊nɔ ye, ba 'batɩ Nyɩsʋa lɛ, ɔ 'mʋ 'a nahuin ‑ye le, ʋ 'mʋ 'a mʋ 'mʋ ‑hɛ, a 'mʋ nahuin ‑ye lɛ 'kukue, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi.) ");
INSERT INTO ted_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","‑Ye ‑Yusu da 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ nɩ, 'ɔ ‑nyi ꞊nʋ 'klɩ, 'ke bʋ bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ, 'ɔ ‑nyu ‑wɛ 'klɩ, 'ke bʋ ‑wɔ nahuin a 'kʋɛi 'bii, kɔ 'ɛ nɩ kɩkladɛ ꞊de 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn a ‑gbɛ, ʋʋ ‑wɛ 'a ‑wɔnnaanyʋ daa, 'waa 'dʋɩ, nɩ‑ ‑gbo: Ye‑hɛnahuon, 'ke 'le ꞊nʋ ‑hɛyri, nɔ‑ mɔ Simɔ, ʋʋ ‑wɛ Piɛlɩ daa, ɔ kɔ 'a 'dɩayu Adre 'hɛɛn; kɔ Sakɩ, ɔ kɔ 'a 'dɩayu Saan 'hɛɛn; ʋ 'hɔn ‑wɛ a ‑gbɛ, nʋ‑ mɔ Sebede a 'yuo꞊pli; ");
INSERT INTO ted_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","'plɩɩ Filipʋ kɔ Batelemi; 'plɩɩ Toma kɔ Matie, ‑ɔ mɔ 'blʋwli'tɛnyɔ; 'plɩɩ Alʋfe a 'yu Sakɩ, ɔ kɔ Tade 'hɛɛn; ");
INSERT INTO ted_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","'plɩɩ Simɔ ꞊nʋ, ‑ɔ nɩ 'le nahuin ꞊nʋ ‑hɛyri, ‑ʋ 'nɩnɩ ‑hʋa Romakʋɛ; 'plɩɩ Judɩa Yisikalio. Nɔ‑ mɔ nahuon ꞊nʋ, ‑ɔ di ‑Yusu 'a yraanyʋ kwa po. ");
INSERT INTO ted_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn a ‑gbɛ, nʋ‑ ɔ tɛ gbo, 'ke bʋ gba Nyɩsʋa a ‑tɩ 'dɩɛ klɛ, 'ɔ tiu, ɔ nɔ: «A nɩ mu 'le 'le 'blʋgbɩ ꞊nʋ 'mʋ, ‑ɩ ‑kɔ 'mʋ ‑Juukʋɛ 'de 'le nɩ, kɔ, a nɩ mu 'le ‑wɛ Samaliblʋgba a 'dɩɔ ꞊de 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kɛɛ, ba mu 'le Yisraɛkʋɛ a nahuin ꞊nʋ ‑wɔn, ‑ʋ 'we ꞊nɔ blablɔ ye, ‑ɔ 'wan, ‑ɔ 'de kʋkɔnyɔ kɔ. ");
INSERT INTO ted_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","'Bɩa 'ba mu, ‑ye ba lu, ‑ɛ mɔ: Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'o nahuin win ke kɔɔ, ɩ 'mʋɛɛ yrɛ. ");
INSERT INTO ted_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ba ‑wɔ nahuin a 'kʋɛi, ba ‑ha 'kʋkʋnyʋ 'klɔ lɛ, ba ‑wɔ ‑wɛ ‑tɔplɩ‑jɔhʋɩnnunyʋ a 'kʋɛi, ba bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ. Nyɩsʋa nu 'a mʋ 'mʋ ꞊hapʋdɛ, 'ke 'le ‑gbʋgbɛkɔ 'kwli 'mʋ. 'A nɩ ‑gbɛ, ba nu nahuin ꞊hapʋdɛ 'mʋ, 'ke 'le ‑gbʋgbɛkɔ 'kwli 'mʋ! ");
INSERT INTO ted_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","'Bɩa 'baa mu, a nɩ gba 'le 'wliyɛ ꞊de. ");
INSERT INTO ted_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","A nɩ gba 'le blɔ gblaka ꞊de, kɔ wlawlʋ a 'hɔn a nʋnʋ, kɔ, a nɩ gba 'le ‑wɛ 'suei, kɔ kotu, ‑ɛ nue, nahuin ꞊nʋ, ‑ʋ kɔ ‑tɩ aa ‑kʋan nu, nʋ‑ blɛ ye ‑bʋ kikle 'a mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","'Bɩa 'ba nyre 'le 'dɩɔ ꞊de 'mʋ, ba ꞊mɔ nahuon lɛ, ‑ɔ ‑wɛ ‑wɔn, 'ke ‑bɔ 'ble 'a mʋ kwa. 'Bɩa 'bɔ 'ble 'a mʋ kwa, 'kee nɩ, ba nɩ 'le ‑nɩnɩ, a 'mʋ 'le ‑tɛgbi a ‑gbɛ 'mʋ ‑hɔn. ");
INSERT INTO ted_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","'Bɩa 'ba pa 'le kayu ‑ye gbo, ‑ye ba le nahuin ꞊nʋ, ‑ʋ nɩ 'le, kɛ ba po ꞊nʋ ye: Nyɩsʋa bɔ nɩ 'o 'a mʋ ‑wɔn! ");
INSERT INTO ted_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","'Bɩa kayu a ‑gbɛ a nahuin 'bʋ 'ble 'a mʋ kwa, ‑ye ba da Nyɩsʋa, 'ke bɔ nu ꞊nʋ ꞊hapʋdɛ 'mʋ, kɛɛ, 'bɩa 'bʋ 'de 'a mʋ kwa 'ble, ‑ye Nyɩsʋa nɩ nu 'le ꞊nʋ ꞊hapʋdɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","'Bɩa 'ba nɩ 'le 'dɩɔ ꞊de 'mʋ, ‑hee' kayu ‑ye gbo, 'bɩa 'bʋ blɛ ke, 'ke bʋ 'ble 'a mʋ kwa, kɔ, 'bʋ 'nɩnɩ po 'a mʋ nʋa ye gbo, ‑ye ba ‑hɔn 'le 'mʋ, ba mu. 'Baa mu, ‑ye ba bʋbla 'a nɩ bʋɩ, ‑ɛ die nu, 'pupu 'mʋ 'o 'a nɩ bʋɩ 'hʋɩn 'mʋ lɛ ‑hɔn, a 'mue nahuin tɔɔ, ‑ɛ mɔ, Nyɩsʋa a yrʋ 'bʋ yɛ ꞊nʋ, ‑ye nʋ‑ʋ nɩ, ‑ʋ nue. ");
INSERT INTO ted_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","'Nɩɩ 'a mʋ 'nɩ le, ‑nyrɔwɔ ‑kɔ 'mʋ Nyɩsʋa di 'o 'klɔ ke a nahuin ‑bati lɛ poo, ‑ye 'dɩɔ ꞊nʋ a nahuin, ‑ʋ 'de 'a mʋ kwa 'ble, 'waa ‑bati di 'nɩ 'yakla, ɩ 'mʋ 'o nahuin ꞊nʋ a nɩnɩ 'mʋ ‑hi, ‑ʋ mɔ Sodɔmʋdɩɔ kɔ Gomɔlɩdɩɔ a nahuin ꞊nʋ, ‑ʋʋ la 'yilɛnyre‑tɔplɩ nu 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","(‑Yusu 'kɩɛ 'prɛɛ 'le 'a ‑naagbopʋ ‑wɔn, ɔ nɔ:) «Ba po 'mʋ nʋa ye gbo. 'Nɩɩ 'a mʋ 'nɩ lee, ‑ɛ 'we ꞊nɔ 'blayuo ye, ʋʋ 'le ‑jio ‑hɛyri lee. 'A ‑tɩ, ba nɩ 'o ‑preelɛ 'mʋ, 'ke 'o nahuin ꞊nʋ a ‑ta 'mʋ, ‑ʋ di 'a mʋ ye ‑wɔn, kɛɛ, a nɩ ‑wʋn 'le ye. ");
INSERT INTO ted_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ba ꞊tu 'a nɩ dɩɔnʋ 'yie, 'ke 'o nahuin ꞊nʋ a ‑ta 'mʋ, ‑ɛ nue, ʋ kɔ bʋ gba 'le 'a mʋ ‑batipoolɛ 'mʋ, kɔ, ʋ di 'a mʋ bii lɔkʋɛ, 'ke 'le Nyɩsʋa a kayuo gbo. ");
INSERT INTO ted_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","‑Tɛ a 'ya 'na ‑naagbopʋ 'mʋ a ‑tɩ, ʋ di 'a mʋ yɛɛ ‑tɩ, 'ke 'o 'blʋgbanaanyʋ kɔ 'kɩɩnpʋ ye. Nɛ‑ die nu, a 'mʋ ꞊nʋ 'na ꞊hapʋtitie pue, a 'mue ‑wɛ nahuin ꞊nʋ ye po, ‑ʋ 'de ‑Juukʋɛ. ");
INSERT INTO ted_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","'Bʋ klɩ 'a mʋ, 'ke ʋ 'mʋ 'le 'a mʋ ‑batiponyʋ ye gba, 'kla nɩ 'ya 'le 'a mʋ ‑wliye, 'ke 'o ‑tɩ ꞊nʋ, a di ꞊tu, kɔ, ‑tɛ a di 'a ꞊tutue nu a ‑ta 'mʋ. Win ꞊nʋ, a di po, ti a ‑gbɛ 'yri, Nyɩsʋa'a nɩ, ‑ɔ di 'a mʋ wlɔn lɛ po. ");
INSERT INTO ted_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ɛ 'de 'a nɩ ‑gbɛgbɛ, a 'nɩ 'prɛ ꞊le nɩ. Kɛɛ, 'a nɩ Bu Nyɩsʋa a ‑Hihiu, ‑ʋ nɩ 'o 'a mʋ ke 'mʋ, nʋ‑ di 'prɛ. ");
INSERT INTO ted_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ti a ‑gbɛ 'yri, 'dɩayuopʋ di 'waa 'dɩayuo 'blʋgba a ye'mʋnaanyʋ kwa lɛ 'nɩ po, ‑ɛ die nu, ʋ 'mu lɛ 'lɩla. Dɛɛ ‑do a ‑gbɛ, nɛ‑ bunʋ di 'waa 'yuo ‑wɔn nu, 'yuo꞊pli 'mue ‑wɛ 'waa bunʋ kɔ 'waa 'diinʋ 'hɛɛn ‑wɔn nu. ");
INSERT INTO ted_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nahuin 'bii di 'a mʋ 'nɩ yraa, ‑ɛ nue, 'a mʋ mɔ 'na nahuiin nɩ. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ 'de sɩa, 'ke 'o Nyɩsʋa a ꞊wlʋ a yekuolɛ ‑wɔn, 'bɔ gbɛ ‑gbagba, 'klɔ a 'o'mʋ‑hɔnti 'bɩ nyre 'o, nɔ‑ Nyɩsʋa di waa. ");
INSERT INTO ted_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ti ꞊nʋ ‑kɔ 'yri ʋ di 'o 'a mʋ ꞊sʋɛ ꞊tue, 'ke 'le 'dɩɔ ‑ye 'mʋ, ‑ye ba 'gba ci lɛ, 'ke 'le 'dɩɔ ‑ye 'mʋ. 'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, a 'deɛ ba nu 'na ‑kʋan ‑nunu, ba ka 'le Yisraɛkʋɛ a 'dɩɛ 'bii, 'mʋ 'le lele di. ");
INSERT INTO ted_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Ɛ 'de 'nyɩnyɩnyɔ ꞊de kɔ, ‑bɔ di 'o 'a tɔɔnyɔ 'lu ye nɩ. Ɛ 'de ‑wɛ ‑kʋannunyɔ ꞊de kɔ, ‑bɔ di ‑wɛ 'o 'a 'masɛ 'lu ye nɩ. ");
INSERT INTO ted_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","'A ‑tɩ, 'nyɩnyɩnyɔ kɔ ‑kʋannunyɔ 'hɛɛn, ʋ 'deɛ bʋ plɛ, ꞊sʋɛdʋ ꞊nʋ, 'waa tɔɔnyɔ kɔ 'waa 'masɛ 'hɛɛn, ʋ di 'ye, ʋ die 'le wlɔn 'nɩ ꞊ta. 'Bɩa 'mɔ ‑gbo, ‑ɔ mɔ 'kabu, 'bʋʋ 'mʋ Bɛsebulɩ (‑ɔ mɔ Satan) daa, ‑ye 'dʋɩ ꞊nʋ, ʋ di 'a mʋ ꞊tue, 'a mʋ ꞊nʋ, ‑ʋ mɔ 'na kayugbokʋɛ, ɩ di lɛ nyre 'yi, ɩ 'mʋ 'o Bɛsebulɩdʋ a ‑gbɛ 'mʋ ‑hi.» ");
INSERT INTO ted_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","(Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ:) «'A ‑tɩ o, nahuin a ‑gbɛ, ‑ʋ di 'a mʋ ꞊sʋɛ ꞊tue, a nɩ pɩ 'le 'waa hʋannʋ, ‑ɛ nue, ti di 'o 'nɩ nyre, ‑ɩ kɔ 'yri ‑tɩ a ‑tɛɛ di 'o pepe' 'mʋ bi, kɔ, ‑tɔplɩ ꞊nʋ, ‑ɩ ‑hli kɛ, nahuin 'bii 'mui yi. ");
INSERT INTO ted_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","'Bɩa ꞊ba bii ye, ‑tɩ ꞊nʋ, 'nɩɩ 'a mʋ ye ꞊tu, ba ꞊tui 'o ‑tɛ ꞊nʋ, nahuin 'bii ‑wɛ 'le bʋ 'wɩɩn 'o. ‑Tɩ ꞊nʋ, 'nɩɩ 'le gbo blee, 'nɩɩ 'a mʋ ye ꞊tu, ba ꞊tui nahuin 'bii ye. ");
INSERT INTO ted_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","A nɩ pɩ 'le ‑tʋnahuin a hʋannʋ. 'A nɩ ‑plahʋɩɩn ‑do, nɩ‑ ʋ ‑wɛ 'le bʋ ‑wɔ gbo. Kɛɛ, ʋ 'die 'le ‑wɛ bʋ ‑wɔ 'a nɩ ‑hihiu gbo. Nyɩsʋa, nɔ‑ kɔ hʋannʋ ba pɩ, ‑ɛ nue, nɔ‑ ‑wɛ 'le ‑bɔ ‑wɔ ‑tʋnahuon a ‑plahʋɩn gbo, ɛ kɔ 'a ‑hihiu 'hɛɛn, 'ke 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe, ‑ɔɔ dɛ'klannunyʋ gbo ‑wɔ. ");
INSERT INTO ted_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","꞊Bo pue nʋblɩ 'cicrɛi a dɛ ye: 'Bɩa ꞊nɩ nyi ‑tɔ, ɩ 'nɩ po ꞊le ꞊die 'dɔ, kɛɛ, 'bɩa 'a nɩ Bu Nyɩsʋa 'bɔ 'die ke wɛɛn, 'a 'yɛɛ ‑do ꞊de 'nɩ 'kʋ ꞊le. ");
INSERT INTO ted_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kɛɛ, a ‑mɛ ‑ye, 'lu‑pupuii ‑tie a kɔ, 'a nɩ Bu Nyɩsʋa a ‑gbɛ, ɔ ‑hri nɩ. ");
INSERT INTO ted_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ɛ 'we ꞊nɔ ye, a kɔ 'mini 'dɔ, 'ke 'o Nyɩsʋa ye, 'ɛ ‑hi 'o nʋblɩ gbi 'plɔplɔ ꞊nʋ 'mʋ. 'A ‑tɩ o, a nɩ pɩ 'le ‑tʋnahuin a hʋannʋ!» ");
INSERT INTO ted_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«'Ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ ꞊tui, 'ke 'o nahuin ye, ‑ɛ mɔ, ɔ mɔ 'na nahuoon nɩ, ‑ye ‑batipo‑nyrɔwɔ 'mʋ, 'na ‑gbɛ, 'n di ‑wɛ 'nɩ ꞊tu, 'ke 'o 'na Bu Nyɩsʋa ye, ‑ɔ nɩ 'le yakɔ 'mʋ, ‑ɛ mɔ, nahuon a ‑gbɛ, ɔ mɔ 'na nahuoon nɩ. ");
INSERT INTO ted_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ ꞊tui, 'ke 'o nahuin ye, ‑ɛ mɔ, ɔ 'de 'mʋ yi, ‑ye ‑batipo‑nyrɔwɔ 'mʋ, 'na ‑gbɛ, 'n di ‑wɛ 'nɩ ꞊tu, 'ke 'o 'na Bu Nyɩsʋa ye, ‑ɔ nɩ 'le yakɔ 'mʋ, ‑ɛ mɔ, 'n 'dio yi.» ");
INSERT INTO ted_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«A nɩ 'ye 'le, ‑ɛ mɔ, 'n di nɔ ‑tʋtʋ ke nɩ, 'mʋ 'le kegbowɛɛnlɛ ya. 'N 'de 'le di, 'ke ꞊bo ya 'le kegbowɛɛnlɛ, kɛɛ, 'n di 'le ꞊le, 'mue nu, nahuin 'mʋ ye ‑wʋnwɔn. ");
INSERT INTO ted_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","'N di 'le ꞊le, 'mue nu, 'yu nyɩbɛyu 'mʋ 'a bu ye ‑wɔn, kɔ, 'yu nyrɔyu, ɔ 'mʋ 'a 'dii ye ‑wɔn, kɔ, 'yu a nyrɔ, ɔ 'mʋ 'a 'dɔɔ ye ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ɛ 'we ꞊nɔ ye, nahuon 'bɔ nɩ 'o, 'a yraanyʋ di 'mʋ 'ya 'a ‑gbɛ a kayugbokʋɛ. ");
INSERT INTO ted_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Nahuon 'bɔ nɩ 'o, 'bɔ nʋɛ 'a bu kɔ 'a 'dii 'hɛɛn 'mʋ, 'bɛ ‑hi 'o 'mʋ 'mʋ, ‑ye ɔ 'die 'le ‑wɛ bɔ 'ya 'na nahuon 'mʋ. Nahuon 'bɔ nɩ 'o, 'bɔ nʋɛ 'a 'yuo꞊pli 'mʋ, 'bɛ ‑hi 'o 'mʋ 'mʋ, ‑ye ɔ 'die 'le ‑wɛ bɔ 'ya 'na nahuon 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Nahuon 'bɔ nɩ 'o, 'bɔ 'nɩnɩ ꞊tuu 'o 'na wintɛ 'o, ꞊betɩ bʋ plɛ, ʋ 'muo 'la 'na ‑tɩ, ɔ 'die 'le ‑wɛ bɔ 'ya 'na nahuon 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nahuon 'bɔ nɩ 'o, 'bɔ plɛ, ɔ 'nɩ ‑hʋa ꞊le bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, 'ke 'o 'na ‑ta 'mʋ, ɔ di ‑hlɩn 'a 'klɔ yrayrʋ 'nɩ 'waan, 'ke 'o Nyɩsʋa ye. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ wɛɛn ke, 'ke bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, ‑tɛ ɔ nʋɛ 'mʋ 'mʋ a ‑tɩ, ‑ye nahuon a ‑gbɛ, 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'ke 'o Nyɩsʋa ye.» ");
INSERT INTO ted_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Nahuon 'bɔ nɩ 'o, 'bɔ 'ble 'a mʋ kwa, 'a mʋ ꞊nʋ, ‑ʋ mɔ 'na ‑naagbopʋ, ‑ye ɛ 'we ꞊nɔ ye, 'mɔɔ nɩ, ɔ 'ble kwa. 'Plɩɩ ‑ye nahuon 'bɔ 'ble 'mʋ kwa, ɛ 'we ꞊nɔ ye, 'na Bu Nyɩsʋa'a nɩ, ‑ɔ lee 'mʋ, nɔ‑ ɔ 'ble ‑wɛ kwa. ");
INSERT INTO ted_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","'Bɩa ꞊nɩ 'ble Nyɩsʋa a winwlɔn‑hɛnyɔ kwa, ‑ɛ nue, ɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ, ‑ye 'wio ꞊nʋ, Nyɩsʋa di wɛn 'a winwlɔn‑hɛnyɔ ‑nyi, nɔ‑ ɔ di ‑wɛ ‑mʋ ‑nyi. 'Bɩa ꞊nɩ 'ble nahuon kwa, ‑ɛ nue, ɔɔ nu dɛ ꞊nʋ, Nyɩsʋaa ‑hʋa, ‑ye 'wio ꞊nʋ, Nyɩsʋa di wɛn nahuon a ‑gbɛ ‑nyi, nɔ‑ ɔ di ‑wɛ ‑mʋ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","'Plɩɩ, 'na nahuoon ‑do ‑gbo, ‑ɔ 'de 'mini kɔ, ꞊nɩ ‑nyo 'nɩcɛ a ‑gaʋwɔɔ ‑do, ‑ɛ nue, ɔ mɔ 'na ‑naagbopʋyuu nɩ, 'ɛ mɔ ‑tɛɛ, Nyɩsʋa di ‑mʋ ‑nyi 'wio.» ");
INSERT INTO ted_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","‑Tɛ ‑Yusu ‑wɔ 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ a tɔɔlɛ ‑wɔn, ‑ye ɔ ‑hɔn 'o ‑tɛgbi a ‑gbɛ 'mʋ nɩ, 'ɔ mu 'le 'blʋgba ꞊nʋ a 'dɩɛ ‑ye 'mʋ, 'ke ɔ 'mʋ 'le Nyɩsʋa a ‑tɩ nahuin ye ꞊tu. ");
INSERT INTO ted_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ti a ‑gbɛ 'yri, Saan Batisɩ, ‑ɔɔ la nahuin 'nie 'lu lɛ po, 'ke ɔ nɩ 'le ꞊jɩ 'mʋ, 'ɔ 'wɔn ‑kʋan, ‑Yusuu nu a ‑tɩ. Nɛ‑ nue, 'ɔ le 'a ‑naagbopʋ ‑ye, ɔ nɔ: «Ba mu, ba ꞊gbɔ wlɔn, ");
INSERT INTO ted_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","꞊be nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, ‑hee' ‑a 'kɩɛ die Waanyɔ a ‑gbɛ ‑pre?» ");
INSERT INTO ted_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","‑Tɛ Saan a ‑naagbopʋ ꞊gbɔ wlɔn, ‑ye ‑Yusu nɔ: «Ba mu, ba le Saan dɛ aa 'wɔn, kɔ, aa 'ye. ");
INSERT INTO ted_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ba lo, ‑ɛ mɔ, 'yiisuanyʋ, ʋʋ lɛ 'nɩ yrii, lɛ‑yɩyrɛnyʋ, ʋʋ 'nɩ na, ‑tɔplɩ‑jɔhʋɩnnunyʋ, 'waa 'kʋɛi, ɩɩ 'nɩ ‑wɛ, 'kikenyʋ, ʋʋ 'wɔn ‑tɩ, 'kʋkʋnyʋ, ʋʋ lɛ 'hrɩ 'klɔ, kɔ ꞊sʋɛnyʋ, ʋʋ 'wɔn Nyɩsʋa a ꞊hapʋtitie, 'ʋ kɔ ꞊wlʋ a 'kwli'mʋgbo꞊tutue. ");
INSERT INTO ted_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Plɔ a bleelɛ 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ 'nɩnɩ blɛ ke, 'ke bɔ kuo 'mʋ ꞊wlʋ ye.» ");
INSERT INTO ted_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","'Plɩɩ Saan a ‑naagbopʋ 'mʋ ‑wɔn ꞊hɩan, ‑ye Saan a ‑tɩ, nɩ‑ ‑Yusuu ke 'prɛɛ, 'ke 'o nahuin ꞊nʋ ‑wɔn, ‑ʋ ꞊gbe 'o ꞊nɔ 'hʋɩn 'mʋ, ɔ nɔ: «Saan, ‑tɛ ɔɔ o Nyɩsʋa a ‑tɩ ꞊tu, 'ke 'le ‑tɛgbi ꞊nʋ, nahuin 'de 'le 'ti, ‑tɛ a mu o 'le ꞊nɔ ‑wɔn, nahuon tio‑ 'a nɩ ꞊wlɩ plɛ, a di o 'le gbo yɛ 'le? ꞊Be 'a nɩ ꞊wlɩ nɔ 'nɩ, a di o 'le gbo yɛ nahuon, ‑ɔɔ nahuin a hʋannʋ pɩ, 'ke bɔ ꞊tu ‑tɩ a ‑tɛɛ? 'Ʋʋn, ɛ 'de nahuondʋ a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","꞊Be 'a nɩ ꞊wlɩ nɔ 'nɩ, a di o 'le gbo yɛ nahuon, ‑ɔ pue 'yilɛnɔwlawlɩ? Kɛɛ, nahuin ꞊nʋ, ‑ʋʋ 'yilɛnɔwlawlɩ pue, 'ke ʋ nɩ 'le 'kɩɩnpʋ a kayuo gblɛ. ");
INSERT INTO ted_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","꞊Bo ꞊gba lele 'a mʋ wlɔn: Nyɔ tio‑ a mu o 'klɛɛ 'ye wɔn 'le? ꞊Be Nyɩsʋa a winwlɔn‑hɛnyɔ? Iin, 'nɩɩ 'a mʋ 'nɩ le, kɔ, 'nɩ nyi ꞊tu, Saan, ɔ ‑hi 'o Nyɩsʋa a winwlɔn‑hɛnyʋ ‑ye 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nɔ‑ mɔ nahuon ꞊nʋ, ‑ɔ kɔ ‑tɩ ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ, nɔ‑ di la 'na 'hru ye kla, 'plɩɩ 'mʋ la 'le di. ‑Tɩ a ‑gbɛ, ʋ 'crɩɩ la, ɩ nɩ‑ ‑gbo: Nyɩsʋa nɔ 'nɩ: 'Na 'yu o, 'n di ‑ha nahuon, 'ke 'o 'na ‑kʋan a ‑ta 'mʋ, ɔ 'mʋ mu, ɔ 'mʋ ‑na 'hru ye kla, 'plɩɩ ꞊mʋ 'le nyre. ");
INSERT INTO ted_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ke 'le ‑tʋnahuin 'bii ‑hɛyri, ɛ 'de ‑hlɩn nahuon ꞊de a kʋɛ, ‑ɔ nɩ 'o Saan Batisɩ 'lu ye. Kɛɛ ‑ye 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, nahuon ꞊nʋ, ʋʋ nahuon 'cicrɛ daa, nɔ‑ di 'o Saan Batisɩ 'lu ye nɩ. ");
INSERT INTO ted_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Kʋɛ la 'le ti ꞊nʋ 'yie 'mʋ gbo, ‑ɩ kɔ 'yri Saan Batisɩ ‑tʋa la 'o Nyɩsʋa a ‑tɩ a ꞊tutue gbo, 'kee nɩ, Nyɩsʋa ‑tʋa la 'o nahuin a win a kekɔɔlɛ gbo, kɛɛ, Nyɩsʋa a yraanyʋ, ʋʋ 'o ꞊tu 'klɩ, 'ke nahuin 'nɩ ꞊han 'o Nyɩsʋa 'o ꞊tuu. ");
INSERT INTO ted_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tetei ꞊nʋ, Nyɩsʋa ‑nyi la Moise, kɔ Nyɩsʋa a winwlɔn‑hɛnyʋ 'bii, kʋɛ la 'le gbo, ‑bo yɛ Saan a ti ke, ʋ nyi la 'nɩ ꞊tu, ‑ɛ mɔ, ɛ di kɔ ti, ‑ɩ kɔ 'yri Nyɩsʋa di la 'o nahuin win ke kɔɔ. ");
INSERT INTO ted_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nyɩsʋa a wintɛ, nɩ‑ nyi la ꞊tu, ‑ɛ mɔ, winwlɔn‑hɛnyɔ Eli di la 'le 'nɩ di. 'Ba 'di ꞊wlʋ ye kuo, ‑hee' 'ba kui ꞊wlʋ ye, 'nɩɩ 'a mʋ 'nɩ le, Saan, nɔ‑ mɔ Eli a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","'Ba kɔ ‑tɩ'wɔnnʋa, ‑ye ba 'wɔn ‑tɩ ‑dodo. ");
INSERT INTO ted_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‑Tɛ ti ‑gbo 'yri a nahuin nɩ 'mʋ, ɛ nɛ‑ ‑gbo: Ʋ 'we ꞊nɔ 'yuo꞊pli ye, ‑ʋʋ hru 'mre, 'ke 'o 'dika, ꞊ʋ ‑ye 'ʋʋ 'waa 'bienʋ ‑tɩ yɛɛ, ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‑Tɛ ‑aa 'blɩ 'ti, ‑aa 'blɩ'mʋpaalɛ a ‑wla bre, a 'de ‑wla di yi. 'Plɩɩ ‑tɛ ‑aa 'numu꞊hien we, a 'de wɔlɩ lɛ nu. ");
INSERT INTO ted_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ɛ 'we ꞊nɔ ye, Saan, ‑tɛ ɔ di la 'le, ɔɔ ꞊ke 'nɩ ꞊ci, 'ke 'o Nyɩsʋa a dɩda a ‑ta 'mʋ, 'ɔ 'nɩnɩ 'na nɔ, 'plɩɩ nahuin 'ʋʋ lɛ po: 'Ku ‑hʋan nɩɔ 'o ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","'Plɩɩ 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ‑tɛ 'n di 'le, 'nɩ ꞊ci ꞊le, 'nɩɩ nɔ 'na, 'plɩɩ nahuin 'ʋʋ lɛ po: Ba 'ye kɛ, nahuon ‑gbo, dididɛ kɔ nɔ a 'nɩnaa ‑do, nɛ‑ ɔɔ 'lu ‑wɔn lɛ ‑hie, 'plɩɩ 'blʋwli'tɛnyʋ kɔ nahuin ‑ye 'hɛɛn, ‑ʋ kɔ 'klɔ, ‑ʋ 'de 'o ye 'sii, nʋ‑ kɔ ꞊nɔ 'hɛɛn‑ nɩnatumudɛ nu.» ‑Ye kɛ ‑Yusuu lele po: «Nahuin ꞊nʋ, ‑ʋ kɔ Nyɩsʋa a ꞊tɔ, 'waa nunu‑tɔplɩ di nahuin 'nɩ tɔɔ, ‑ɛ mɔ, Nyɩsʋa a ꞊tɔ a ‑gbɛ, ɔ 'sii 'o ye.» ");
INSERT INTO ted_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","'Dɩɛ ꞊nʋ ‑kɔ 'kwli 'mʋ, ‑Yusu nuu 'le 'ŋmilɛka‑tɔplɩ 'plɔplɔ, ‑ɛ ‑hi 'o 'dɩɛ ‑ye 'mʋ, 'a nahuin 'de 'o dɛ 'kuku a nunue gbo hie. Nɛ‑ nue, 'ɔ ‑tʋa 'waa ‑tɩ a yɛɛlɛ gbo, 'ke 'o nahuin ꞊nʋ ye, ‑ʋ nɩ 'o, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«‑Juukʋɛ ꞊nʋ, ‑ʋ nɩ 'le Kolasɛdɩɔ 'mʋ, kɔ Bɛtɩsaidadɩɔ 'mʋ, 'jrɔ 'ke 'o ꞊nʋ ‑wɔn, ‑ɛ nue, 'ŋmilɛka‑tɔplɩ ꞊nʋ, 'n nuu 'le ꞊nʋ ‑wɔn, 'bɩa 'nɩ nui wɛn 'le nahuin ꞊nʋ ‑wɔn, ‑ʋ 'de ‑Juukʋɛ, ‑ʋ nɩ 'le Tilɩdɩɔ kɔ Sidɔdɩɔ 'hɛɛn 'mʋ, si la, nahuin a ‑gbɛ, ʋ 'mʋ la wɔlɩ lɛ nu, ʋ 'mʋ la ‑tɔplɩ ‑hʋɩn 'hʋɩn 'mʋ lɛ pue, ʋ 'mʋ la 'waa dɩɔnʋ 'tɔpupu 'ŋmlɛ, ‑ɛ die nu, ʋ 'mue nahuin tɔɔ, ‑ɛ mɔ, ʋʋ ‑hʋa bʋ hie 'o dɛ 'kuku a nunue gbo, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","'Nɩɩ 'a mʋ 'nɩ le, ‑nyrɔwɔ ‑kɔ 'mʋ Nyɩsʋa di 'o nahuin ‑bati lɛ poo, nahuin ꞊nʋ, ‑ʋ nɩ 'le Kolasɛdɩɔ kɔ Bɛtɩsaidadɩɔ a ‑gbɛ 'mʋ, 'waa ‑bati di ke nɩ 'klɩ, ɩ 'mʋ 'o Tilɩdɩɔ kɔ Sidɔdɩɔ a nahuin a nɩnɩ 'mʋ ‑hi. ");
INSERT INTO ted_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","'Plɩɩ nahuin ꞊nʋ, ‑ʋ nɩ 'le Kapɛnaɔdɩɔ 'mʋ, ʋ nɩ ‑hie 'le 'lu ‑wɔn lɛ, ‑ɛ mɔ, Nyɩsʋa diu 'le 'nɩ 'yaa ‑yaayaa, ʋ 'mʋ yakɔ ye kʋɛ. Kɛɛ, ɔ diu 'le 'nɩ ꞊tɩɔ ‑tɩɔtɩɔ, ʋ 'mʋ 'le ‑tʋtʋ a bʋgbo nyre. 'Ŋmilɛka‑tɔplɩ ꞊nʋ, 'n nuu 'le ꞊nʋ ‑wɔn, 'bɩa 'nɩ nui wɛn 'le Sodɔmʋdɩɔ a nahuin ‑hɛyri, ‑ʋ kɔ 'klɔ nyre 'yi lɛ, ‑ye nahuin a ‑gbɛ, ʋ di la 'o dɛ 'kuku a nunue gbo 'nɩ hie, 'plɩɩ Nyɩsʋa 'deɛ bɔ ‑wʋ wɛn gbo. ");
INSERT INTO ted_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","'Nɩɩ 'a mʋ 'nɩ le, ‑nyrɔwɔ ꞊nʋ ‑kɔ 'mʋ Nyɩsʋa di 'o nahuin ‑bati lɛ poo, ‑Juukʋɛ ꞊nʋ, ‑ʋ nɩ 'le Kolasɛdɩɔ 'mʋ, kɔ Bɛtɩsaidadɩɔ 'mʋ, Nyɩsʋa diu ꞊tue ꞊sʋɛ, ɛ 'mʋ 'o nahuin ꞊nʋ 'mʋ ‑hi, ‑ʋ mɔ Sodɔmʋkʋɛ, ‑ʋ kɔ nunuklɔ nyre la 'yi lɛ.» ");
INSERT INTO ted_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ti a ‑gbɛ 'yri, kɛ ‑Yusu po, ɔ nɔ: «'Na Bu o, ‑mɔ mɔ yakɔ kɔ ‑tʋtʋ 'hɛɛn a Kʋkɔnyɔ. 'Nɩɩ ‑mʋ 'nɩ baa, ‑tɛ ‑n nu, ꞊nɩ ‑hli ‑na nunu‑tɔplɩ ꞊tɔkɔnyʋ, kɔ 'crɩɩnɩɛiyinyʋ 'hɛɛn 'yi ke, 'plɩɩ nahuin ꞊nʋ, ‑ʋ 'de dɛ ꞊de yi, nʋ‑ ‑n tɔɔ ‑tɔplɩ a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","'Nɩɩ ‑mʋ 'nɩ baa, ‑ɛ nue, kɛ'ɛ nɩ, ‑n nu 'a ‑hʋhʋa. ");
INSERT INTO ted_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","'Na Bu, ɔ ‑nyi 'mʋ 'klɩ, 'ke 'o ‑tɔplɩ 'bii ke. Nahuin 'die yi, nahuon a gblo tio‑ ꞊bo 'ya 'mʋ, 'bɛ 'de 'n Buu ‑do. Ʋ 'die ‑wɛ yi, nahuon a gblo tio‑ 'n Bu 'ya 'mʋ, 'bɛ 'de 'mɔ, ‑ɔ mɔ 'a 'Yu. 'Plɩɩ 'ɛ nɩ nahuon, 'nɩɩ ‑hʋa ꞊bo le, ɔ yie ‑wɛ nɩ, nahuon a gblo tio‑ 'n Bu 'ya 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","'A mʋ ꞊nʋ, ‑ʋ kɔ 'klɩ ‑wɛ 'le, 'ke 'o blɛ a 'buble ‑wɔn, ba di nɔ 'mʋ ‑wɔn, 'mʋ 'a mʋ 'mʋ ‑hɛ, 'mue nu, a 'mʋ ‑wle. ");
INSERT INTO ted_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","'N 'deɛ ꞊bo ꞊tue 'a mʋ ꞊sʋɛ, kɔ, 'nɩ 'yaa ꞊le 'le 'n dɩɔnʋ. Ba wɛɛn ke, 'ke ꞊bo 'ya 'a nɩ naanyɔ 'mʋ, ‑ɛ die nu, 'mʋ 'a mʋ tɔɔ. 'Bɩa 'ba wɛɛn ke, 'n di 'a mʋ ‑nyi ꞊hapʋ'klɔ. ");
INSERT INTO ted_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","‑Tɩ ꞊nʋ, 'n di 'a mʋ tɔɔ, ɩ 'deɛ bɩ kla wlɔn, 'ke 'o 'a mʋ ‑wɔn, kɔ, blɔ ꞊nʋ, 'n di 'a mʋ hren, ɔ di 'nɩ 'huhue.» ");
INSERT INTO ted_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","‑Tɛ ti gbi ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ mu lɛ na wɔn ‑wuwle‑nyrɔwɔ ꞊de 'mʋ. 'A ‑naagbopʋ a ‑gbɛ, kanʋ nyu nu. Bʋʋ 'klɛɛ mu, ‑ye ʋʋ ꞊tɩɔ 'bɛ 'dɩdɔ‑tɔplɩ ꞊de a ‑ci, ‑ɩ 'we ꞊nɔ ꞊gbla ye. Nɔ‑ kɔ 'hlɛ gbi 'a ‑naagbopʋʋ 'cɛ, 'ʋ nye di. ");
INSERT INTO ted_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","'Ke Falisi꞊tumu a nahuin nɩ 'le ‑ci a ‑gbɛ 'mʋ. ‑Tɛ ʋ 'ye dɛ a ‑gbɛ, ‑ye ʋʋ ‑Yusu 'nɩ le, ʋ nɔ: «'Ye kɛ, dɛ ‑gbo, ‑na ‑naagbopʋ, ʋʋ nu, ɩ ꞊ŋa nɩ. Nyɩsʋa a tete nɔ 'nɩ: Nahuon nɩ nu 'le ‑kʋan ‑wuwle‑nyrɔwɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","‑Ye ɔ ꞊tu ꞊wɔn, ɔ nɔ: «‑Tɩ ‑gbo, ʋ 'crɩɩ la 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, 'ke 'o ‑a nɩ bu gblaka, ‑ɔ mɔ bodɩɔ Dafidɩ a ‑ta 'mʋ, 'n pui ‑tɛɛ, a ‑hri nɩ. ‑Tɩ a ‑gbɛ, ʋ 'crɩɩ la, nɩ‑ ‑gbo: ‑Nyrɔwɔ ꞊de 'mʋ bodɩɔ Dafidɩ, ‑tɛ kanʋ nyo la nu, ɔ kɔ 'a nahuin 'hɛɛn, ");
INSERT INTO ted_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","'ɔ pa la 'le Nyɩsʋa a kayu gbo, 'ʋ ‑ha la 'o 'flɔɔ, ‑ɔ pɛ la 'o 'teble ke gbo, 'ʋ dio la. 'Plɩɩ ‑ye tete nɔ 'nɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋʋ ‑do, nʋ‑ ‑wɛ 'le ‑bʋ di 'flɔɔdʋ a ‑gbɛ. 'Be 'flɔɔdʋ a ‑gbɛ, ‑ɔ nɩ 'le Nyɩsʋa a kayu a ‑gbɛ gbo, ʋ ‑hɩɔ la nɩ, 'ke 'o Nyɩsʋa a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","'Ya 'o lele 'lu, 'n pui ‑tɛɛ, a ‑hre dɛ ‑gbo nɩ, Moise 'crɩɩ la 'le Nyɩsʋa a teteicrɩɩnɩɛ 'kwli 'mʋ. Dɛ a ‑gbɛ, nɛ‑ ‑gbo: ‑Wuwle‑nyrɔwɔ 'mʋ, Nyɩsʋa a ‑cɔhlʋnpinyʋ, ʋʋ nu ‑kʋan, 'ke 'le Nyɩsʋa a 'kagblaka gbo. 'A ‑tɩ, ʋ 'nɩ ꞊tuu ꞊le 'o ‑wuwle‑nyrɔwɔ a tete. Kɛɛ, ꞊ɔ ꞊de 'nɩ yɛɛ ꞊le ꞊nʋ ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","'Nɩɩ 'a mʋ 'nɩ le, nahuon ‑gbo, ‑ɔ nɩ mɔ, ɔ 'bʋa nɩ, 'ɔ ‑hi 'o Nyɩsʋa a 'kagblaka 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kɛ Nyɩsʋaa po, 'ke 'le 'a 'crɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Dɛ 'nɩɩ 'a mʋ ‑hʋa, nɛ‑ mɔ, ba kɔ nahuin a wɔlɩ, 'ɛ ‑hi 'o ba pie 'mʋ 'wlugba‑tɔplɩ a ‑cɔhlɩn. Dɛ ꞊nʋ, ɛ ꞊hɛn 'nyrɛ, 'bɩa 'ba yrie wɛn 'mʋ lɛ, a 'deɛ ba po wɛn lɛ, ‑ɛ mɔ, nahuin ꞊nʋ, ‑ʋ 'de dɛ 'klan ꞊de nu, ʋ mɔ dɛ'kukununyʋ'ʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, Nyɩsʋa lee nɔ 'mʋ nɩ, 'ɔ ‑nye 'mʋ 'klɩ, 'ke ꞊bo le 'ɛ nɩ nahuon dɛ ɔ ‑wɛ 'le bɔ nu, 'ke 'le ‑wuwle‑nyrɔwɔ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","‑Tɛ ‑Yusu ‑yrɛ 'klɛɛ, ‑ye ɔ ‑hɔn 'o ‑tɛgbi a ‑gbɛ 'mʋ nɩ, 'ɔ mu 'le Nyɩsʋa a kayu gbo. ");
INSERT INTO ted_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","'Ke ɔ yɛ 'le nyɩbɛyu ꞊de gbo, ‑ɔ kɔ dabʋ 'kʋ. Falisi꞊tumu a nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ nye wɛn 'nɩ ‑hʋa, 'ke bʋ yɛɛ ‑Yusu ‑tɩ, 'bɩa 'bɔ kɔ bɔ ‑wɔ wɛn nyɩbɛyu a ‑gbɛ a 'kʋɛ ‑wuwle‑nyrɔwɔ 'mʋ. (Falisi꞊tumu a nahuin nɔ 'nɩ, nahuon a 'kʋɛ a ‑wʋwɔ, ɛ mɔ ‑kʋaan nɩ. 'Plɩɩ Nyɩsʋa a tete nɔ 'nɩ, nahuon nɩ nu 'le ‑kʋan ‑wuwle‑nyrɔwɔ 'mʋ.) Nɛ‑ nue, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: «‑Be' Nyɩsʋa a tetei po 'le? ꞊Be ɩ nyi 'nɩ ꞊tu, ‑ɛ mɔ, ‑wuwle‑nyrɔwɔ 'mʋ, nahuin ‑wɛ 'le bʋ pɩa 'hʋɩnhrennyʋ nɩ?» ");
INSERT INTO ted_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","‑Ye kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «꞊Be a ‑mɛ ‑ye, a 'nɩ nu ꞊le ‑kʋan, ‑wuwle‑nyrɔwɔ 'mʋ? 'Ke 'le 'a mʋ ‑hɛyri, nahuon 'bɔ kɔ blablɛ, blablɛ a ‑gbɛ 'bɛ bi 'le 'nɩhʋɔ wlɔn ‑wuwle‑nyrɔwɔ 'mʋ, ꞊be nahuon a ‑gbɛ, ɔ 'deɛ bɔ ‑hɩɛ 'le? ");
INSERT INTO ted_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","'Plɩɩ ‑ye ‑tʋnahuon ‑hi 'o blablɛ 'mʋ nɩ. 'A ‑tɩ o, Nyɩsʋa a tetei nyi 'nɩ ꞊tu, ‑ɛ mɔ, ɛ nɔɔ 'o lɛ, 'ke nahuon bɔ nu 'a 'be ꞊hapʋdɛ 'mʋ, 'ke 'le ‑wuwle‑nyrɔwɔ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","‑Ye kɛ ɔɔ 'klɛɛ nyɩbɛyu a ‑gbɛ ye po, ɔ nɔ: «Srʋʋ ‑na dabʋ ꞊nʋ, ‑ʋ 'kʋ!» ‑Ye ɔ srʋʋ nɩ. Bɔ srʋʋ 'klɛɛ 'a dabʋ a ‑gbɛ, ‑ye ʋ 'hrɩ 'klɔ, 'ʋ bi 'o 'a dɩɔnʋ ꞊pɩ 'mʋ, ʋ 'we ꞊nɔ 'a dabʋ ‑ye ꞊nʋ ye. ");
INSERT INTO ted_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","‑Tɛ ‑Yusu ‑wɔ 'klɛɛ nahuon a ‑gbɛ a 'kʋɛ, ‑ye Falisi꞊tumu a nahuin a ‑gbɛ, ʋ ‑hɔn 'o 'mʋ nɩ, 'ʋ mu ‑gboligbo 'mʋ, 'ʋ mu ꞊tɔ lɛ ꞊mɔ wɔn, ‑tɛ bʋ di nu, ʋ 'mʋ ‑Yusu 'la. ");
INSERT INTO ted_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","‑Yusu yi dɛ ꞊nʋ nɩ, ʋʋ ‑hʋa bʋ nuo 'mʋ. Nɛ‑ nue, 'ɔ ‑hɔn 'o ‑tɛgbi a ‑gbɛ 'mʋ. ‑Tɛ ɔɔ mu, ‑ye nahuin 'plɔplɔ kʋɔ ‑wɔn, nahuin 'bii ꞊nʋ, 'ke 'le ꞊nʋ ‑hɛyri, ‑ʋ kɔ 'hʋɩn a hinhren, 'ɔ ‑wɔ 'waa 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kɛɛ ‑ye ɔ nyu 'nɩ tii, 'ke ʋ nɩ ꞊tui 'le nahuon ꞊de ye, nahuon a gblo tio‑ bɔ 'ya 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɔ ꞊tui nɩ, ‑ɛ die nu, ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Esai 'crɩɩ la, ti ‑hi la a ti 'yri, ɩ 'mʋ nue. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«Nyɩsʋa nɔ 'nɩ: 'Ye kɛ, nahuon ‑gbo, nɔ‑ mɔ 'na ‑kʋannunyɔ. Nɔ‑ 'n ‑ha 'le du 'mʋ, 'ke bɔ nu 'na ‑kʋan. Nahuon a ‑gbɛ, 'n nʋɔ 'mʋ nɩ, 'ɔɔ 'mʋ nue 'manʋ. 'N die 'nɩ nu, 'na ‑Hihiu 'mʋ 'o ꞊nɔ ke 'mʋ bi. Nahuin ꞊nʋ, ‑ʋ 'de ‑Juukʋɛ, ɔ diu 'nɩ le, ‑ɛ mɔ, 'n diu 'nɩ waa. ");
INSERT INTO ted_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɔ 'deɛ bɔ ꞊mɔ ꞊yʋɛ lɛ, kɔ, 'bɔɔ 'prɛ, ɔ 'deɛ bɔ po ‑cici lɛ, kɔ, 'bɔɔ 'dɩɛ 'mʋ lɛ na, ɔ 'deɛ bɔ 'wɔɔn 'le gbo, ‑ɛ 'we ꞊nɔ 'dɩɔgbo‑wɔnyɔ ye. ");
INSERT INTO ted_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nahuin ꞊nʋ, ‑ʋ 'de 'klɩ kɔ, ɔ di yrii 'waa wɔlɩ, kɔ, nahuin ꞊nʋ, ‑ʋ 'de 'mʋ‑hɛnyɔ kɔ, ɔ 'mu 'mʋ ‑hɛ. Nɛ‑ ɔ di nu ‑nunu, nahuin 'mue ke wɛɛn, 'ke bɔ 'siu 'o ye, 'ke 'o 'mʋ ye, ");
INSERT INTO ted_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","kɔ, dakʋ a gblegblei 'bii, ‑ʋ nɩ nɔ 'klɔ ke, ʋ 'muo ꞊wlʋ ye kuo.» ");
INSERT INTO ted_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","'Hʋɩnhrennyʋ ꞊nʋ, ʋ gba 'o ‑Yusu ye, 'ke 'le ꞊nʋ ‑hɛyri, nahuon nɩ 'le, 'a 'yii 'ɩ sua, kɔ, 'ɔ 'de 'prɛlɛ yi, ‑ɛ nue, 'ku ‑hʋan nɩɔ 'o ke 'mʋ. ‑Tɛ ʋ nyroo 'o ꞊nɔ ye, ‑ye ‑Yusu a ‑gbɛ, ɔ ‑wɔ 'a 'kʋɛ nɩ, nahuon a ‑gbɛ 'ɔ ‑tʋa 'pʋprɛ gbo, kɔ, 'ɔ ‑tʋa lɛyriilɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'o, ɩ saka ꞊nʋ nɩ, ʋ nɔ: «꞊Be ‑Yusu ‑gbo, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, ‑ɔ mɔ bodɩɔ Dafidɩ a 'yuo a 'Yu?» ");
INSERT INTO ted_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kɛɛ, Falisi꞊tumu a nahuin, ‑ʋ nɩ 'o, ‑tɛ ʋ 'wɔn ‑tɩ a ‑gbɛ, ‑ye ʋ nɔ: «'Ʋʋn. Nahuon ‑gbo, ɔɔ lɛ bla 'kuo ‑hʋɩn ꞊nʋ, ‑ɔ nɩ 'o nahuin ke 'mʋ, ‑ɛ nue, Bɛsebulɩ, ‑ɔ mɔ 'kuo ‑hʋɩn a nyɩgblaka Satan, nɔ‑ɔ ‑Yusu 'klɩ ‑nyi, 'ke bɔ nue.» ");
INSERT INTO ted_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kɛɛ, ‑Yusu yi 'waa 'lu a lɛ‑hielɛ nɩ. Nɛ‑ nue, 'ɔ lu, ɔ nɔ: «꞊Bo pue dɛ ye: 'Ke 'le 'blʋgba 'kwli 'mʋ, nahuin 'bʋ 'bɛ ꞊tɩɔ lɛ, ‑ye 'blʋgba a ‑gbɛ, ɔɔ ꞊hlɔn 'nɩ bi. 'Ya 'o lele 'lu, 'dɩɔ a nahuin, ‑hee' kayugbokʋɛ, 'bʋ 'bɛ ꞊tɩɔ lɛ, ‑ye nahuin a ‑gbɛ, ʋʋ lɛ 'nɩ ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","‑Ye 'klɛɛ, Satan 'bɔɔ 'a dɩɔnʋ lɛ bla, ‑ye ɛ 'we ꞊nɔ ye, 'a dɩɔnʋ ɔɔ ye ‑wɔn. ‑Ye 'a 'blʋgba di bi ꞊hlɔn. ");
INSERT INTO ted_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","A nɔ 'nɩ, 'nɩɩ lɛ bla 'kuo ‑hʋɩn, ‑ɔ nɩ 'o nahuin ke 'mʋ, ‑ɛ nue, Bɛsebulɩ, nɔ‑ɔ 'mʋ 'klɩ ‑nyi. 'Bɩa 'bɛ 'ya wɛn ꞊hapʋkɔ 'mʋ, nyɔ‑ɔ 'klɛɛ 'a nɩ nahuin 'klɩ ‑nyi 'le, 'ke bʋ bla 'kuo ‑hʋɩn lɛ? Dɛ ‑gbo, 'a nɩ nahuiin nu, ɛ nye ‑a mʋ 'nɩ tɔɔ, ‑ɛ mɔ, ‑tɩ ꞊nʋ, aa 'mʋ yɛɛ, ɩ mɔ hɩ'ɩ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ɛ 'de Satan, kɛɛ, Nyɩsʋa a ‑Hihiuu nɩ, ‑ʋʋ 'mʋ 'klɩ ‑nyi, 'ke ꞊bo bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ. Dɛ a ‑gbɛ, ɛ nye 'a mʋ 'nɩ tɔɔ, ‑ɛ mɔ, Nyɩsʋa ‑tʋa nahuin a win a kekɔɔlɛ gbo, 'ke 'le 'a mʋ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ɛ 'we ꞊nɔ ye, nahuon ꞊de 'die 'le ‑wɛ bɔ pa 'le 'klɩnyɔ a kayu gbo, ɔ 'mʋ 'a ‑tɔplɩ 'yri, 'bɩa 'bɔ 'de 'klɩnyɔ a ‑gbɛ mʋa ‑tɩtɛ. 'Bɔ mʋɔ 'klɛɛ, ‑ye ɔ ‑wɛ 'le bɔ 'yri 'a kayu a ‑tɔplɩ 'bii nɩ. ");
INSERT INTO ted_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Nahuon 'bɔ nɩ 'o, ɔ kɔ 'mʋ 'hɛɛn, ꞊ba 'de pɛ, ‑ye ɛ 'we ꞊nɔ ye, ɔɔ 'mʋ ye 'nɩ ‑wɔn. 'Plɩɩ nahuon 'bɔ nɩ 'o, 'bɔ 'nɩnɩ ‑hɛ 'mʋ 'mʋ, 'ke ‑ba 'kukue nahuin lɛ, 'ke 'o Nyɩsʋa ‑wɔn, ‑ye nahuon a ‑gbɛ, ɔ nyu lɛ 'nɩ ‑gba, 'ʋʋ Nyɩsʋa ‑wɔn hren. ");
INSERT INTO ted_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nɛ‑ nue, 'nɩɩ 'a mʋ le, Nyɩsʋa ‑wɛ 'le bɔ 'wʋwla nahuin a dɛ 'kuku 'bii nɩ, ꞊betɩ bʋ poo Nyɩsʋa tanɩ lɛ. Kɛɛ, nahuon ꞊nʋ, ‑ɔ di Nyɩsʋa a ‑Hihiu tanɩ lɛ poo, Nyɩsʋa 'die 'le ‑wɛ bɔ 'wʋwla 'a dɛ 'kuku a ‑gbɛ gbe. ");
INSERT INTO ted_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","'Ya 'o lele 'lu, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, nahuon ꞊nʋ, ‑ɔ di 'mʋ ‑tɩ ‑hʋɩn yrɛ ꞊tu, Nyɩsʋa ‑wɛ 'le bɔ 'wʋwla 'a dɛ 'kuku a ‑gbɛ nɩ. Kɛɛ, nahuon ꞊nʋ, ‑ɔ di Nyɩsʋa a ‑Hihiu ‑tɩ ‑hʋɩn yrɛ ꞊tu, Nyɩsʋa 'die 'le ‑wɛ bɔ 'wʋwla 'a dɛ 'kuku a ‑gbɛ 'klɔ ‑gbo, ‑a nɩ nɔ ‑wɔn, kɔ 'klɔ ꞊nʋ, ‑ɔ di 'le di.» ");
INSERT INTO ted_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","(Kɛ ‑Yusuu lele po:) «Tugbɛ ꞊nʋ, ‑ɛɛ ꞊hapʋ'nie ‑jri, nɛ‑ɛ ꞊hapʋ'kui tʋ. Kɛɛ, tugbɛ ꞊nʋ, ‑ɛ 'nɩnɩ ‑jri ꞊hapʋ'nie, nɛ‑ɛ 'kui ‑hʋɩn tʋ. Tugbɛ a 'kuo, nɔ‑ ʋ nye yrii. ");
INSERT INTO ted_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","'A mʋ ꞊nʋ, aa kaa nahuin, 'a nɩ nunuklɔ 'ɔ nyre 'yi lɛ, ‑ɛ 'we ꞊nɔ hrei ye. Nɛ‑ nue, 'aa ꞊ke ‑tɩ ‑hʋɩn lɛ ꞊tu, ‑ɛ nue, ‑tɩ ꞊nʋ, ‑ɩ 'yii 'le nahuon a ꞊wlʋ ke, nɩ‑ ɔɔ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","꞊Hapʋnahuon a nunu‑tɔplɩ nɔ lɛ 'yi, ‑ɛ nue, 'a ꞊wlʋ nɔ lɛ 'yi. Mɔ, 'crɛnyɔ a nunu‑tɔplɩ nyre lɛ 'yi, ‑ɛ nue, 'a ꞊wlʋ nyre lɛ 'yi. ");
INSERT INTO ted_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","'Nɩɩ 'a mʋ 'nɩ le, ‑nyrɔwɔ ꞊nʋ ‑kɔ 'mʋ Nyɩsʋa di 'o nahuin 'bii ‑bati lɛ poo, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ ꞊tu nahuon ꞊de ‑tɩ ‑hʋɩn ꞊de yrɛ, kɛ nɔ 'klɔ ‑gbo ke, ɔ di Nyɩsʋa klɛ 'nɩ ‑hɩhɩa, ‑tɩ kɔ ‑tɩ 'ɔ ꞊tui. ");
INSERT INTO ted_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","'A ‑tɩ, Nyɩsʋa 'bɔ di ‑tado ‑na ‑bati 'bɛ, ‑tɩ ꞊nʋ, ‑n ꞊tu, kɛ nɔ 'klɔ ‑gbo ke, nɩ‑ die nu, ɔ 'mʋ lɛ po: ‑Bati 'de ‑mʋ klɩ, ‑hee' ‑bati klɩ ‑mʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye Nyɩsʋa a teteitɔɔnyʋ ‑ye, kɔ Falisi꞊tumu a nahuin ‑ye, ‑ʋ nɩ 'o, ʋ ꞊tuo ‑wɔn, ʋ nɔ: «Tɔɔnyɔ o, ‑aa ‑hʋa ‑ba 'ye, 'bɩa ꞊nɩ ‑wɛ 'le ‑bo nu 'ŋmilɛkadɛ, ‑ɛ nye ‑a mʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee nɔ ‑mʋ ‑tʋtʋ ke.» ");
INSERT INTO ted_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","‑Ye ‑Yusu nɔ: «Ti ‑gbo 'yri a nahuin ‑gbo, 'waa nunuklɔ nyre lɛ 'yi, 'ʋ plee 'le Nyɩsʋa ke, 'plɩɩ 'ʋʋ lele 'ŋmilɛkadɛ ‑hʋa, ‑ɛ die ꞊nʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee nɔ 'mʋ ‑tʋtʋ ke. Nyɩsʋa 'deɛ bɔ wɛɛn ke, 'ke ba 'ye 'ɛ nɩ 'ŋmilɛkadɛ ꞊de. 'Ŋmilɛkadɛɛ ‑do ꞊nʋ, Nyɩsʋa di nu, 'ke 'o 'a mʋ ‑wɔn, ɛ di ye 'we 'ŋmilɛkadɛ ꞊nʋ, ɔ nu la, 'ke 'o 'a winwlɔn‑hɛnyɔ Jona ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Dɛ ꞊nʋ, Jona a ‑gbɛ, ɔ nu, 'ɔ ‑hi 'le ‑nyrɔwɩɩ ta kɔ 'tɔyrʋwɩɩ ta ‑hrin.e gblaka ꞊nʋ 'kwli 'mʋ, kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'ke 'o 'mɔ ‑gbo ‑wɔn, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon. 'N di 'le ‑tʋtʋ gbo ‑hi ‑nyrɔwɩɩ ta kɔ 'tɔyrʋwɩɩ ta. ");
INSERT INTO ted_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","42","'Ɛ mɔ ‑tɛɛ, ‑tɛ Ninifʋdɩɔ 'mʋ a nahuin, ʋ 'wɔn la Jona a win, ‑ɔɔ la ꞊nʋ Nyɩsʋa a ‑tɩ ye ꞊tu, ‑ye ʋ hie la 'o 'waa dɛ 'kuku, ʋʋ la nu gbo, 'ʋ ‑nyi la 'waa 'klɔ 'bii Nyɩsʋa. ‑Ye 'klɛɛ, 'mɔ ‑gbo, ‑ɔ nɩ mɔ 'a mʋ ye gbo, 'n ‑hi 'o Jona a ‑gbɛ 'mʋ nɩ. Kɛɛ, a 'nɩ ꞊tuu ꞊le 'o 'na win. Nɛ‑ nue, ‑nyrɔwɔ ‑kɔ 'mʋ Nyɩsʋa di 'o nahuin ‑bati lɛ poo, Ninifʋdɩɔ 'mʋ a nahuin a ‑gbɛ 'ʋ di ye 'mʋ 'ba, ʋ 'mʋ lɛ po, ti ‑gbo 'yri a nahuin, ʋ mɔ ‑tɩ'wlanyʋ, 'ke 'o Nyɩsʋa ye. 'Ya 'o lele 'lu, ti ‑hi la a ti 'yri, bodɩɔ ꞊de, nɔ‑ ‑hɔn la 'le ‑tɛgbi ‑pɛtu 'mʋ, ‑ɛ mɔ Sabablʋgba. Bodɩɔ a ‑gbɛ, ɔ mɔ la nyrʋgbaa nɩ. Nɔ‑ di la Jrusrɛdɩɔ 'mʋ, ɔ 'mʋ la bodɩɔ Salomɔ, ‑ɔ mɔ la Nyɩsʋa a nahuon a ꞊tɔwin 'wɔn. ‑Ye 'klɛɛ, 'mɔ ‑gbo, ‑ɔ nɩ mɔ 'a mʋ ye gbo, 'n ‑hi 'o Salomɔ a ‑gbɛ 'mʋ nɩ. Kɛɛ, a 'nɩ ꞊tuu ꞊le 'o 'na win.» ");
INSERT INTO ted_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Kɛ ‑Yusuu lele po: «'Bɩa 'ku ‑hʋan, 'bʋ nɩ 'o nahuon ke 'mʋ, 'plɩɩ 'bʋ ‑hɔn 'o ꞊nɔ ke 'mʋ, ‑ye 'ke ʋʋ 'le 'kwlayre gbo mu, 'ʋʋ gbonɩɩlɛ yrayrʋ lɛ ꞊mɔ. Kɛɛ, ʋ 'nɩ 'ye ꞊le gbonɩɩlɛ. ");
INSERT INTO ted_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‑Ye kɛ ʋʋ 'a dɩɔnʋ ye po: 'N di de 'nɩ ‑mɛ, 'mʋ 'le gbonɩɩlɛ 'ka ꞊nʋ 'mʋ mu, 'n ‑hɔn o 'le 'mʋ. 'Bɩa 'bʋ ꞊hɩan ‑wɔn, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, gbonɩɩlɛ a ‑gbɛ, ɛ 'ya 'hʋhlʋ, 'ɛ 'hrɛn klɛ ‑tɛɛ, 'ɛ ‑hlɛntie. (Ɛ 'we ꞊nɔ ye, Nyɩsʋa a ‑Hihiu 'de 'o nahuon a ‑gbɛ ke 'mʋ nɩ.) ");
INSERT INTO ted_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","‑Ye 'ku ‑hʋan a ‑gbɛ, ʋ bla 'kuo ‑hʋɩɩn 'nɩpata ‑ye, ‑ɔ kɔ 'crɛ, 'ɔ ‑hi 'o ye‑hɛku a ‑gbɛ 'mʋ, ɔ 'bii a ‑gbɛ, 'ɔɔ ‑wɔn bibi, 'ɔɔ 'o nahuon a ‑gbɛ ke 'mʋ bi. ‑Ye 'klɛɛ, nahuon a ‑gbɛ, 'a 'klɔ nyre lɛ 'yi, 'ɛ ‑hi 'o 'a ye‑hɛklɔ 'mʋ. Kɛ ɛ di ‑wɛ 'mʋ ‑ti, 'ke 'o ti ‑gbo 'yri a nahuin ‑gbo ‑wɔn, ‑ʋ kɔ ꞊wlɩ nyre 'yi lɛ.» ");
INSERT INTO ted_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","'Ke ʋ nɩ 'le kayuu ‑do a ‑gbɛ gbo. ‑Yusuu wɛn 'le nahuin a ‑gbɛ ‑wɔn a 'prɛɛ, 'a 'dii kɔ 'a 'dɩayuo nyɩbɛpʋ 'hɛɛn 'ʋ nyre 'o. 'Ke ʋ hree 'o ‑patʋ 'mʋ, 'ʋ nye lɛ ꞊mɔ, 'ke bʋ 'prɛɛ wɛn 'le ‑Yusu a ‑gbɛ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","‑Ye nahuon ꞊de nyo 'nɩ le, ɔ nɔ: «'Ye kɛ, ‑na 'dii kɔ ‑na 'dɩayuo, 'ke ʋ nɩ 'le ‑patʋ 'mʋ, 'ʋʋ ‑hʋa bʋ 'prɛɛ 'le ‑mʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","‑Ye kɛ ɔɔ nahuon a ‑gbɛ ye po, ɔ nɔ: «꞊Ʋ ‑ye mɔ ‑wɛ 'na 'dii kɔ 'na ‑dɩayuo,» ");
INSERT INTO ted_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","'ɔ po 'a ‑naagbopʋ dabʋ ‑wɔn, ɔ nɔ: «Ba 'ye kɛ, nahuin ‑gbo, nʋ‑ mɔ ‑wɛ 'na 'dii kɔ 'na 'dɩayuo. ");
INSERT INTO ted_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","‑Ɛ nue, nahuin ꞊nʋ, ‑ʋʋ 'na Bu Nyɩsʋa a kewɛɛnlɛ nu, ‑ɔ nɩ 'le yakɔ 'mʋ, nʋ‑ mɔ ‑wɛ 'na 'dɩayuo kɔ 'na 'dii.» ");
INSERT INTO ted_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","‑Nyrɔwɔ a ‑gbɛ 'mʋ, ‑Yusu 'hrɩ 'le kayu gbo nɩ, 'ɔ mu 'le Galileblʋgba a 'yru nʋa 'mʋ, 'ɔ nɩ gbo, ‑ɛ die nu, ɔ 'mʋ nahuin Nyɩsʋa a ‑tɩ tɔɔ, ");
INSERT INTO ted_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","nahuin 'plɔplɔ 'ʋ ꞊glɔɔ 'le. Bɔ 'nɩnɩ 'ye 'hru, nɛ‑ nue, 'ɔ 'ya 'le 'blagbe wlɔn, 'ɔ nɩ gbo, nahuin a ‑gbɛ 'ʋ 'wlɛ 'o 'nie nʋa 'mʋ gbo, ");
INSERT INTO ted_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","'ɔ nyu ‑tɔplɩ 'plɔplɔ klɛ ‑hɩhɩa, 'ke 'le ‑talʋdʋɩ 'kwli 'mʋ. Kɛ ɔɔ 'klɛɛ po: «Ba po 'o nʋa gbo. Ɛ kɔ la ‑nyrɔwɔ ꞊de, nyɩbɛyu ꞊de 'ɔ mu la 'a ‑tɔplɩ 'dɔ wɔn. Ɔ nyi lɛ 'nɩ ‑gbla, 'ke 'le 'a ‑ci 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","‑Tɛ ɔ nyi lɛ ‑gbla, ‑ye 'ke ꞊ɩ ‑ye bi 'o 'hru wlɔn lɛ, nʋblɩ 'ɩ di 'le, 'ɩ di. ");
INSERT INTO ted_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Gblo a 'hɔn a nɔnɔ, ɔɔ lɛ ‑gbla, ‑ye 'ke ɔ bi 'o ‑tʋtʋtɩɔ ꞊nʋ ke, ‑ɔ kɔ gbo 'hɩɔ 'pa nɩ 'le, 'ɔ ‑hlɛntie ‑tɛɛ, 'ɔ ꞊ga ‑wɛ 'tata, ‑ɛ nue, ‑tʋtʋtɩɔ a ‑gbɛ, ɔ 'de la 'mʋ gbo hren. ");
INSERT INTO ted_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga 'klɛɛ, 'yrʋ bi 'le yrayrɩ, ‑ye 'a ꞊gagɛi 'yrɔ nɩ, ‑ɛ nue, 'a ‑wlubʋɩ kʋɛ 'hɩɔ a ‑gbɛ ye. ");
INSERT INTO ted_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Gblo a ta a nɔnɔ, ɔɔ lɛ ‑gbla, ‑ye 'ke ɔ bi 'le 'witi a ꞊gagɛi ‑gbahlɔn. ‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga, ‑ye 'witilili ꞊nʋ, ɩ 'ya 'o ꞊o, 'ɩ 'bui 'lu lɛ. ");
INSERT INTO ted_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gblo a ‑hɛn a nɔnɔ, ɔɔ lɛ ‑gbla, nɔ‑ bi 'o ꞊hapʋ‑tʋtʋ ke. ‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga, ‑ye ɩ ku nɩ ‑tɛɛ, 'ɩ po 'hlɛ. 'A 'hlɔɔ ‑do, ɔ po 'yɔ a (100) ‑wlɩɩ ꞊hun, ꞊ɔ ‑ye po 'yɔ a (60) ‑wlɩɩ ta, 'a 'be ‑ye po 'yɔ a (30) ‑wlʋ ꞊tu 'o ‑pu. ");
INSERT INTO ted_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","'Bɩa 'ba kɔ ‑tɩ'wɔnnʋa, ‑ye ba 'wɔn ‑tɩ ‑dodo.» ");
INSERT INTO ted_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","‑Tɛ ‑Yusu ‑yrɛ, ‑ye 'a ‑naagbopʋ 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, 'ʋ nyo wlɔn ꞊gba, ʋ nɔ: «꞊Be nahuin ‑gbo, ‑n nyu 'nɩ tɔɔ, 'ke 'le ‑talʋdʋɩ 'kwli 'mʋ?» ");
INSERT INTO ted_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","‑Ye ɔ ꞊tu ꞊wɔn: «'Nɩɩ nu ‑talʋdʋɩ, 'nɩ nyu tɔɔ, ‑ɛ nue, 'a mʋ ‑gbo, ‑ʋ mɔ 'na ‑naagbopʋ, Nyɩsʋa nye 'nɩ nu, 'aa Nyɩsʋa a ‑tɩ 'mʋ lɛ yrii, ‑tɛ ɔɔ nu, 'ɔ kɔɔ nahuin win ke. Nyɩsʋa a ‑tɩ a ‑gbɛ, ɩ ‑hli nahuin ke 'yi. Kɛɛ, nahuin ‑ye ꞊nʋ, Nyɩsʋa 'die nu, 'ke bʋ yrii 'mʋ lɛ, ");
INSERT INTO ted_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","‑ɛ nue, nahuon ꞊nʋ, ‑ɔɔ Nyɩsʋa a wintɛ nʋa ye gbo po, Nyɩsʋa die 'nɩ nu, ɔ 'mui 'mʋ lɛ yrii, ɛ 'mʋ 'o ‑tɛ ɔ nu o 'a 'wʋnwɔn 'mʋ ‑hi. Kɛɛ, nahuon ꞊nʋ, ‑ɔ 'nɩnɩ pui nʋa ye gbo, ɔ 'nɩ yrii ꞊le 'mʋ lɛ nɩ gbe. ");
INSERT INTO ted_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dɛ ‑kɔ ‑tɩ 'nɩɩ 'le ‑talʋdʋɩ 'kwli 'mʋ naa, 'nɩ nyu 'le ‑wɔn 'prɛɛ, nɛ‑ mɔ, nahuindʋ a ‑gbɛ, ʋ nyi 'nɩ 'ye ‑tɛɛ, kɛɛ, ʋ 'nɩ yrii ꞊le lɛ, 'ʋ nyi ‑wɛ 'wɔn ‑tɛɛ, kɛɛ, ʋ 'nɩ yrii ꞊le 'mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","‑Ye 'klɛɛ, ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Esai ꞊tu la, ɩɩ kɛ ‑wɔn mue 'lu, 'ke 'o ꞊nʋ ‑wɔn. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: Kɛ Nyɩsʋa po: ‑Tɩ ‑gbo, 'n di ꞊tu, a di 'nɩ 'wɔn ‑tɛɛ, kɛɛ, a 'deɛ ba yrii 'mʋ lɛ; dɛ ‑gbo, 'n di nu, a die 'nɩ 'ye ‑tɛɛ, kɛɛ, a 'deɛ ba yree lɛ, ");
INSERT INTO ted_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","‑ɛ nue, dakʋ ‑gbo, 'waa ꞊wlɩ 'gboklo 'mʋ nɩ, 'ʋ ka 'waa nʋɩ yrɛ, ‑ɛ die nu, 'waa nʋɩ 'nɩ ꞊han ‑tɩ 'wɔn, 'ʋ ka 'waa 'yii ke, ‑ɛ die nu, 'waa 'yii 'nɩ ꞊han dɛ 'ye, kɔ, 'waa ꞊wlɩ 'nɩ ꞊han ‑tɩ 'mʋ lɛ yrii. 'Bɩa 'bʋ 'nɩnɩ nu wɛn ‑tɔplɩ a ‑gbɛ, ʋ di wɛn 'mʋ ye 'nɩ ‑mɛ, 'mue wɛn nu, ʋ 'mʋ 'o ye 'sii, 'ke 'o 'mʋ ye. Kɛ Nyɩsʋa po.» ");
INSERT INTO ted_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‑Ye kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ: «A ‑mɛ ‑ye, ba kɔ plɔ a bleelɛ, ‑ɛ nue, 'a nɩ 'yii lɛ 'nɩ yrii, kɔ, 'a nɩ nʋɩ 'ɩɩ ‑tɩ 'wɔn. ");
INSERT INTO ted_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ti ‑hi la a ti 'yri a Nyɩsʋa a winwlɔn‑hɛnyʋ kɔ Nyɩsʋa a dakʋ a nahuin 'plɔplɔ ‑ye 'hɛɛn, ʋ nye la lɛ 'nɩ ꞊mɔ, 'ke bʋ 'ye la ‑tɔplɩ gblakɩ ‑gbo, aa kɛ 'ye, kɛɛ, ʋ 'nɩ 'yi ꞊le la, kɔ, ʋ nye la ‑wɛ lɛ 'nɩ ꞊mɔ, 'ke bʋ 'wɔn la ‑wɛ ‑tɔplɩ gblakɩ ‑gbo a ‑tɩ, aa kɛ 'wɔn, kɛɛ, ʋ 'nɩ 'wɩn ꞊le la.» ");
INSERT INTO ted_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‑Ye ɔ nyu lele 'nɩ le, ɔ nɔ: «Ba po 'mʋ nʋa ye gbo, dɛ ꞊nʋ, ‑talʋdʋ a ‑gbɛ, ɛ ꞊hɛn 'nyrɛ, 'mue 'a mʋ klɛ ‑hɩhɩa. ");
INSERT INTO ted_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nahuon 'bɔ nɩ 'o, 'bɔ nyi 'wɔn, ‑ɛ mɔ, Nyɩsʋaa ‑hʋa bɔ kɔɔ nahuin win ke, kɛɛ, 'bɔ 'nɩnɩ yrii 'mʋ lɛ, ‑ye nahuon a ‑gbɛ, ɔ 'we ꞊nɔ 'hru ꞊nʋ ye, ‑ʋ kɔ wlɔn 'dɩdɔ‑tɔplɩ bi 'o lɛ, 'plɩɩ nʋblɩ 'ɩ di 'le, 'ɩ di. 'Bɔɔ Nyɩsʋa a wintɛ 'wɔn, ‑ye 'kuo ‑hʋɩn a nyɩgblaka, ɔɔ 'le 'nɩ di, 'ɔɔ 'le ꞊nɔ Nyɩsʋa a wintɛ a ‑gbɛ ꞊wlʋ ke ‑ha. ");
INSERT INTO ted_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","‑Tʋtʋtɩɔ ꞊nʋ, ‑ɔ nɩ 'o 'hɩɔ 'pa ke, ‑ɔ kɔ ke 'dɩdɔ‑tɔplɩ ‑ye ꞊nʋ, ɩ bi ‑wɛ 'o, nɔ‑ mɔ nahuon ‑gbo, ‑ɔɔ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ ‑ɔ nyi ke wɛɛn, 'ke 'le plɔ a bleelɛ 'kwli 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","'plɩɩ ‑ɔ nyi ‑wɛ kwa 'ble, 'ke 'o ti 'cicrɛi gbi ‑wɔn. Kɛɛ, ɔ 'nɩ ‑hʋɛ ꞊le, 'ke bɛ po 'ma, 'ke 'le ꞊nɔ ꞊wlʋ ke. Nahuon a ‑gbɛ, 'waa 'bienʋ, ‑ʋ 'nɩnɩ ‑hʋa Nyɩsʋa a wintɛ, 'bʋ nyo ꞊sʋɛ ꞊tue, kɔ, 'bʋ yrɔɔ, nɛ‑ mɔ nahuin a ‑gbɛ, 'a nɩ Nyɩsʋa a ‑tɩ bɩ sɩa ꞊nɔ. ");
INSERT INTO ted_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","‑Ye ‑tʋtʋtɩɔ ꞊nʋ, 'witi a ꞊gagɛi nɩ 'o ke, ‑ɔ kɔ ke 'dɩdɔ‑tɔplɩ ꞊nʋ, ɩ bi ‑wɛ 'o, nɔ‑ mɔ nahuon ‑gbo, ‑ɔɔ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ nahuon a ‑gbɛ, 'ɔɔ 'klɔ ke a 'kla‑wliye'yɩya a hrɛtilɛ hrɛti, kɔ, 'ɔɔ kʋkɔ‑tɔplɩ ꞊wlɩ klɛ naa, ‑ɩ nyo 'le kɩka 'mʋ po. ‑Tɔplɩ 'bii a ‑gbɛ, ɩ nue, Nyɩsʋa a wintɛ 'ɛ 'nɩnɩ nu ‑kʋan, 'ke 'le ꞊nɔ ꞊wlʋ ke, 'plɩɩ 'ɛ hihre lɛ. ");
INSERT INTO ted_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","‑Ye ꞊hapʋ‑tʋtʋ ꞊nʋ, ‑ʋ kɔ ke 'dɩdɔ‑tɔplɩ ‑ye ꞊nʋ, ɩ bi ‑wɛ 'o, nʋ‑ mɔ nahuon ‑gbo, ‑ɔɔ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ 'ɔ nyi 'mʋ lɛ yrii, 'ɛɛ ‑kʋan nu, 'ke 'le ꞊nɔ ꞊wlʋ ke, gblei a (100) ‑wlɩɩ ꞊hun, kɔ (60) ‑wlɩɩ ta, 'ke 'o ꞊ɔ ‑ye ‑wɔn, kɔ (30) ‑wlʋ ꞊tu 'o ‑pu, 'ke 'o ꞊ɔ ‑ye ‑wɔn, 'ɛ ‑hi 'o ‑tɛ ɔ nu o 'a 'wʋnwɔn 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","‑Yusu po lele ꞊nʋ ye ‑talʋdʋ ‑ye, ɔ nɔ: «Nyɩsʋa 'bɔ kɔɔ nahuon win ke, dɛ, ɛ 'we ye, ɛ nɛ‑ ‑gbo: Nyɩbɛyu ꞊de, nɔ‑ 'dɔ ꞊hapʋ'dɩdɔ꞊gbla, 'ke 'le 'a ‑ci ke. ");
INSERT INTO ted_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","'Tɔyrʋwɔ ꞊de 'mʋ, ‑tɛ nahuin 'bii pɛ gblɛ, ‑ye 'a yraanyɔ ꞊de, nɔ‑ mu 'le ꞊gbla‑ci a ‑gbɛ ke, 'ɔ 'dɔ 'yilɛnyre‑piti, ‑ɩ 'we ꞊nɔ ꞊gbla ye, 'ke 'le 'a ‑ci a ꞊hapʋgbla ꞊nʋ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","‑Tɛ ꞊gbla a ‑gbɛ, ɔ ꞊ga, ɔ po 'hlɛ, ‑ye ‑piti ‑hʋɩn ‑nɩ wɛn, ɩ ꞊ga ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","‑Ye ‑cikɔnyɔ a ‑kʋannunyʋ, ʋ di 'le ꞊le, ʋ nɔ: Nyɩbɛyu o, ꞊be ‑n 'de ꞊hapʋgbla 'dɔ, 'ke 'le ‑na ‑ci ke? ‑Be' ‑piti ‑hʋɩn ‑hɔn 'mʋ 'le, 'ɩ ꞊ga 'le? ");
INSERT INTO ted_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: 'Na yraanyɔ'ɔ nɩ, ‑ɔ nue. ‑Ye ‑kʋannunyʋ nɔ: ꞊Be ‑n nye 'nɩ ‑hʋa, 'ke ‑ba ‑ha ‑piti ‑hʋɩn a ‑gbɛ? ");
INSERT INTO ted_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‑Ye ɔ nɔ: 'Ʋʋn, a nɩ ‑hɩ 'le, ‑ɛ nue, 'ba nyi ‑ha, 'ba 'bɛ ‑wɛ 'le gbo, ‑ye a 'hri ꞊gbla. ");
INSERT INTO ted_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ba ‑hɩ mɛ lɛ, bɩ kuu 'o ‑tɛgbii ‑do, ꞊gbla'cɛti bɩ nyre 'o. Ti a ‑gbɛ 'yri, 'ke 'n di 'o ꞊gbla'cɛnyʋ lee, ‑ɛ mɔ: Ye‑hɛdɛ, ba 'kukue 'yilɛnyre‑piti ꞊nʋ lɛ, ba nu 'a dui, a 'mui 'tɔ po. 'Ba pui 'tɔ, ‑ye ba 'kukue ꞊hapʋgbla lɛ, a 'muo 'le 'na 'kale po.» ");
INSERT INTO ted_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Bɔ po 'klɛɛ lɛ, ‑ye ɔ po ꞊nʋ ye ‑talʋdʋ ‑ye, ɔ nɔ: «꞊Bo tʋɛ 'a mʋ, ‑tɛ Nyɩsʋa, ɔɔ nu, 'ɛ kɔ nahuin ‑ye a ‑dodo, 'ɔ kʋʋ win ke, 'plɩɩ nahuin ‑ye 'ʋʋ klɛ bii. Dɛ a ‑gbɛ, ɛ 'we ꞊nɔ 'dɩdɔdɛ ꞊nʋ ye, ‑ɛ kɔ 'yɛɛ 'cɩmɩ 'dɔ, 'ɛ ‑hi 'o 'dɩdɔ‑tɔplɩ ‑ye a 'yɔ 'mʋ. 'Dɩdɔdɛ a 'yɛɛ a ‑gbɛ, nɛ‑ nahuon ꞊de gba, 'ɔ 'dʋɛ 'le 'a ‑ci ke. 'Bɛ ꞊ga, 'bɛ ku, ‑ye ɛ ‑hɛ tugbɛ gblaka, 'ɛɛ 'o ‑ci a 'dɩdɔ‑tɔplɩ ‑ye 'mʋ ‑hi, nʋblɩ 'ɩɩ 'le di, 'ɩɩ 'lɛ po, 'ke 'le 'a babʋɩ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Bɔ po 'klɛɛ lɛ, ‑ye ɔ po ꞊nʋ ye ‑talʋdʋ ‑ye, ɔ nɔ: «Nyɩsʋa 'bɔ kɔɔ nahuin win ke, 'plɩɩ nahuin ‑ye 'bʋʋ klɛ bii, dɛ a ‑gbɛ, ɛ 'we ꞊nɔ 'flɔɔ a 'yaadɛ ye, nyrʋgba, ɔ 'ba 'mʋ, ɔ po 'le 'flɔɔpupu ‑huohui ‑wɔn, 'ɔ nyʋɔ ‑nyʋanyʋa, 'flɔɔ 'bii 'ɔ 'ya.» ");
INSERT INTO ted_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","‑Tɔplɩ 'bii ꞊nʋ, 'ke ‑Yusu nyi 'le ‑talʋdʋɩ 'kwli 'mʋ naa, 'ʋ nyi nahuin ꞊nʋ tɔɔ. Ɔ 'die 'le ‑wɛ, 'ke bɔ 'de ‑talʋdʋ po, bɔ 'diu tɔɔ. ");
INSERT INTO ted_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Kɛ'ɛ nɩ, ɔ nu 'a nunue, ‑ɛ die nu, ‑tɩ ꞊nʋ Nyɩsʋa a winwlɔn‑hɛnyɔ ‑ye, ɔ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɛ 'mʋ nue. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «Nyɩsʋa nɔ 'nɩ: 'N di nu ‑talʋdʋɩ, 'mʋ 'le ꞊nʋ ‑wɔn 'prɛɛ. ‑Tɔplɩ ꞊nʋ, nahuin 'de la yi, kʋɛ la 'le 'klɔ a ‑wlu꞊tutue 'yie 'mʋ gbo, 'mui ꞊nʋ tɔɔ.» ");
INSERT INTO ted_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑Yusu hie 'o nahuin ꞊nʋ gbo, 'ɔ mu 'le kayu gbo, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'plɩɩ 'a ‑naagbopʋ 'ʋ muo 'o 'hʋɩn 'mʋ, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: «'Yilɛnyre‑piti ꞊nʋ, ʋ 'dɔɔ 'le ‑ci ke, 'a ‑talʋdʋ ꞊nʋ, ‑n po wɛn, ‑hɩhɩʋ ‑a mʋ klɛ.» ");
INSERT INTO ted_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Nahuon ꞊nʋ, ‑ɔɔ ꞊hapʋgbla ꞊nʋ 'dɔ, nɔ‑ mɔ 'mɔ, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon. ");
INSERT INTO ted_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","‑Ci ꞊nʋ, nɛ‑ mɔ 'klɔ ‑gbo, ‑a nɩ nɔ ‑wɔn. ꞊Hapʋgbla, nɔ‑ mɔ nahuin ꞊nʋ, Nyɩsʋa kɔɔ win ke. 'Yilɛnyre‑piti, nɩ‑ mɔ nahuin ꞊nʋ, 'kuo ‑hʋɩn a nyɩgblaka kɔɔ win ke. ");
INSERT INTO ted_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Yraanyɔ ꞊nʋ, ‑ɔɔ 'yilɛnyre‑piti ꞊nʋ 'dɔ, nɔ‑ mɔ 'kuo ‑hʋɩn a nyɩgblaka. ꞊Gbla'cɛti, nɩ‑ mɔ 'klɔ a 'o'mʋ‑hɔnti. ꞊Gbla'cɛnyʋ, nʋ‑ mɔ Nyɩsʋa a lɛleenyʋ. ");
INSERT INTO ted_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","‑Tɛ ʋʋ nu, 'ʋʋ 'yilɛnyre‑piti ꞊nʋ lɛ 'kukue, 'ʋ nyi 'tɔ po, kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'klɔ a 'o'mʋ‑hɔnti 'yri. ");
INSERT INTO ted_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ti a ‑gbɛ 'yri, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di gbo tɛ Nyɩsʋa a lɛleenyʋ, 'plɩɩ nahuin ꞊nʋ, ‑ʋ nye nu, 'waa 'bienʋ 'ʋʋ dɛ 'klan nu, kɔ nahuin ꞊nʋ, ‑ʋʋ dɛ 'klan nu, nʋ‑ʋ nɩ, Nyɩsʋa a lɛleenyʋ a ‑gbɛ, ʋ di lɛ 'kukue, 'ke 'le nahuin ꞊nʋ ‑hɛyri, Nyɩsʋa kɔɔ win ke, ");
INSERT INTO ted_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ʋ 'mu 'le na ꞊nʋ 'mʋ po, ‑ɔ 'nɩnɩ jre gbe. 'Ke ʋ di 'o ꞊hien wee, kɔ, 'ke ʋ di ‑wɛ 'o yrʋ poo. ");
INSERT INTO ted_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kɛɛ, nahuin ꞊nʋ, ‑ʋʋ 'o Nyɩsʋa 'o ꞊tuu, 'ɛ nɩ nahuon diu 'nɩ 'ye, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ɔɔ nu, 'ɔɔ 'yrʋ 'ye, ‑ʋʋ hʋan, 'ke 'le yakɔ 'mʋ. 'Ba kɔ ‑tɩ'wɔnnʋa, ‑ye ba 'wɔn ‑tɩ ‑dodo.» ");
INSERT INTO ted_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«‑Tɛ Nyɩsʋaa nahuon a win a kekɔɔlɛ nu, dɛ, ɛ 'we ye, nɛ‑ ‑gbo: Ɛ kɔ la ꞊hapʋdɛ gblaka ꞊de, ‑ɛɛ ꞊die po. Nɛ‑ ʋ ‑hlii 'le ‑ci ꞊de 'kwli 'mʋ. Nɛ‑ nahuon ꞊de 'hrɩɩ ke. ‑Tɛ ɔ 'hrɛɛ 'klɛɛ ke, ‑ye ɔ kɔ plɔ a bleelɛ 'dɔ, 'ɔ ‑hle lele, 'ɔ mu, 'a kʋkɔ‑tɔplɩ 'bii, 'ɔ pli, 'ɔ nu 'a kʋkɔ‑tɔplɩ a ‑gbɛ a 'wli, 'ɔ ‑tɔ ‑ci ꞊nʋ, ‑ɛ kɔ 'kwli 'mʋ ꞊hapʋdɛ gblaka a ‑gbɛ nɩ 'le.» ");
INSERT INTO ted_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«‑Tɛ Nyɩsʋaa nahuon a win a kekɔɔlɛ nu, ɛ 'we ‑wɛ ꞊nɔ puplonyɔ ꞊de ye, ‑ɔɔ 'dauma a 'yɔ a ‑tɩtɔ lɛ ꞊mɔ, ‑ɔɔ ꞊die po. ");
INSERT INTO ted_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","‑Tɛ ɔ yɛ 'a 'yɛɛ ‑do ke, ‑ɛ nɔ 'yi lɛ ‑tɛɛ, ‑ɛɛ ꞊die po, ‑ye ɔ mu nɩ, 'ɔ plo 'a kʋkɔ‑tɔplɩ 'bii, 'ɔ ‑tɔ 'dauma a 'yɛɛ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«‑Tɛ Nyɩsʋaa nahuin a win a kekɔɔlɛ nu, ɛ 'we ‑wɛ ꞊nɔ ‑tata ye, ʋ po 'le 'nie ‑wɔn, ‑ɔɔ ‑hrin a gblegblei klɩ. ");
INSERT INTO ted_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","'Bɔ 'yii 'le, ‑ye ‑hrin'panyʋ nyo 'nɩ ‑jri, 'ʋ nyo 'o 'nie nʋa 'mʋ gbo po, 'ʋʋ gblɛ nɩ, 'ʋʋ 'le ‑hrin 'mʋ 'tɩtɛ, 'a ꞊hapʋdɛ, 'ʋ nye 'le ‑tʋgbɩ wlɔn lɛ po, 'a dɛ ꞊nʋ, ‑ɛ 'de 'a ꞊hapʋdɛ, 'ʋ nye 'kwla 'mʋ lɛ po. ");
INSERT INTO ted_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kɛ'ɛ nɩ, ɛ di ‑hlɩn 'mʋ ‑ti, 'klɔ a 'o'mʋ‑hɔnti 'yri: Nyɩsʋa a lɛleenyʋ, ʋ di 'le 'nɩ di, nahuin ꞊nʋ, ‑ʋ 'de 'o Nyɩsʋa 'o ꞊tuu, kɔ nahuin ꞊nʋ, ‑ʋ ꞊tuu 'o Nyɩsʋa, ʋ 'mu 'yi 'mʋ lɛ ‑hɩhɩa, ");
INSERT INTO ted_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","nahuin ꞊nʋ, ‑ʋ 'de 'o Nyɩsʋa 'o ꞊tuu, ʋ 'mu 'le na ꞊nʋ 'mʋ po, ‑ɔ 'nɩnɩ jre gbe. 'Ke ʋ di 'o ꞊hien wee, kɔ, 'ke ʋ di ‑wɛ 'o yrʋ poo.» ");
INSERT INTO ted_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","‑Ye ‑Yusu ꞊gba 'a ‑naagbopʋ ‑nɩ wɛn wlɔn, ɔ nɔ: «‑Tɩ 'bii ‑gbo, 'n ꞊tu, ꞊be a yrii 'mʋ lɛ?» ‑Ye ʋ nɔ: «Iin, ‑a yrii 'mʋ lɛ.» ");
INSERT INTO ted_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","‑Ye kɛ ɔ nyu ye po, ɔ nɔ: «'Ɛ nɩ teteitɔɔnyɔ ꞊de, 'bɔ nɩ 'o, 'bɔ ‑hɛ 'na ‑naagbopʋyu, ‑ye ɔ 'we ꞊nɔ 'kabu ꞊nʋ ye, ‑ɔ kɔ ꞊tɔ, ‑ɔɔ 'a kʋkɔ‑tɔplɩ yrayrɩ kɔ ‑tɔplɩ 'kɩ ꞊nʋ 'mʋ 'ba, ‑ɔ nyi ‑kʋan 'yri nuu.» ");
INSERT INTO ted_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","‑Tɛ ‑Yusu ‑wɔ ‑talʋdʋɩ ꞊nʋ a pupue ‑wɔn, ‑ye ɔ ‑hɔn 'o ‑tɛgbi a ‑gbɛ 'mʋ nɩ, ");
INSERT INTO ted_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","'ɔ mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ kɔ 'mʋ ɔ kuu 'le. ‑Ye 'ke ɔ mu 'le Nyɩsʋa a kayu gbo, 'ɔ ‑tʋa Nyɩsʋa a ‑tɩ a tɔɔlɛ gbo. Nahuin 'plɔplɔ ꞊nʋ, ‑ʋ nɩ 'o, ɩ saka ꞊nʋ nɩ, ʋ nɔ: «Nyɔ‑ tɔɔ ꞊nɔ ꞊tɔwin ‑gbo, ɔɔ po? Kɔ, nyɔ‑ ‑nyi 'klɛɛ ꞊nɔ 'klɩ, 'ke bɔ nu 'ŋmilɛka‑tɔplɩ ‑gbo 'le? ");
INSERT INTO ted_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","‑A yie nɩ, ‑ɛ mɔ, nɔ‑ mɔ 'camʋdɛ ꞊nʋ a 'yu. 'A 'dii a 'dʋ mɔ Mari. 'A ‑dɩayuo nyɩbɛpʋ, nʋ‑ mɔ Sakɩ, kɔ Sosɛfʋ, kɔ Simɔ, kɔ Judɩ. ");
INSERT INTO ted_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","'A ‑dɩayuo nyrʋyuo 'bii nɩ ‑wɛ nɔ ‑a mʋ ‑hɛyri. 'A ‑tɩ, nyɔ‑ ‑nyi 'klɛɛ ꞊nɔ ꞊tɔdʋ ‑gbo, kɔ, nyɔ‑ ‑nyi ꞊nɔ 'klɩdʋ ꞊nʋ 'le?» ");
INSERT INTO ted_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","'Waa 'lu a lɛ‑hielɛdʋ a ‑gbɛ, nɛ‑ nue, 'ʋ 'dio ꞊wlʋ ye kuo. ‑Ye ‑Yusu nɔ: «Nyɩsʋa a winwlɔn‑hɛnyɔ, ʋ nyo 'o 'nɩ ꞊tuu, 'ke 'o 'ɛ nɩ ‑tɛgbi ꞊de. Kɛɛ, ʋ 'nɩ ꞊tuo ꞊le 'o, 'ke 'le 'a ‑gbɛ a 'dɩɔ 'mʋ, kɔ, 'ke 'le 'a kayu gbo.» ");
INSERT INTO ted_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","'Ke 'le ꞊nʋ ‑hɛyri, ‑Yusu 'de 'klɛɛ lele 'ŋmilɛka‑tɔplɩ 'plɔplɔ nu, ‑ɛ nue, ʋ 'dio ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ti a ‑gbɛ 'yri, Galileblʋgba a ‑gʋlʋnʋma, ‑ɔ kɔ 'dʋ mɔ Helɔdɩ, ɔ 'wɔn ‑Yusu a 'dʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","‑Ye kɛ ɔɔ 'a ‑kʋannunyʋ ye po, ɔ nɔ: «Saan Batisɩ, ‑ɔɔ o nahuin 'nie 'lu lɛ po, nɔ‑ɔ nɩ. ‑Tɛ ɔ 'kʋ la, ɔ 'hrɩ lele 'klɔ. Nɛ‑ nue, 'ɔ kɔ 'klɩ, 'ke bɔ nu 'ŋmilɛka‑tɔplɩ ꞊nʋ, ‑ɩ kɔ 'dʋ ‑aa 'wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","'Ɛ mɔ ‑tɛɛ, dɛ ꞊nʋ, Helɔdɩ a ‑gbɛ, ɔ nu la Saan 'mʋ, 'plɩɩ Saan a ‑gbɛ, ɔ 'mʋ la 'kʋ, ɛ nɛ‑ ‑gbo: Helɔdɩ a ‑dɩayu nyɩbɛyu Filipʋ, nɔ‑ kɔ la nyrʋgba. 'A 'dʋ mɔ Helɔdiadɩ. Helɔdiadɩ a ‑gbɛ, nɔ‑ Helɔdɩ ‑ha la Filipʋ kwa, 'ɔ kʋɔ la. ‑Tɛ Saan 'wɩn la, ‑ye ɔ nɔ: «Ɛ 'de 'o lɛ nɔɔ, 'ke ‑na ‑dɩayu Filipʋ ‑gbo, ‑ɔ 'kɩɛ nɩɛ 'klɔ, ‑bo di ꞊nɔ 'a nyrʋgba kwa ‑ha, ‑bo dio kɔ.» ‑Tɛ Saan ꞊tu ‑tɩ a ‑gbɛ, nɛ‑ nue Helɔdiadɩ a ‑gbɛ, 'ɔ ꞊tutuo Helɔdɩ, 'ke bɔ le 'a 'sɔyuo, bʋ klɩ Saan, bʋ mʋɔ, bʋ puo ꞊jɩ 'mʋ. ‑Tɛ ʋ puo 'klɛɛ ꞊jɩ 'mʋ, ‑ye Helɔdɩ a ‑gbɛ, ɔ nye 'nɩ ‑hʋa, bɔ le 'a 'sɔyuo, bʋ 'la Saan a ‑gbɛ. Kɛɛ, ɔ 'die la nu, ‑ɛ nue, ɔɔ la pɩ nahuin a hʋannʋ. Nahuin ‑mɛ ‑ye, ʋ nɔ 'nɩ, Saan a ‑gbɛ, ɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ. Ʋ 'de ye blɛ bʋ 'tʋɔ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","‑Ye 'klɛɛ, ‑nyrɔwɔ ꞊nʋ ‑kɔ 'mʋ ʋ kɔ la Helɔdɩ, ɔ nyre 'o ꞊o, Helɔdɩ 'ɔ nu 'a lɛ'mimre. 'Ke ʋ nɩ 'klɛɛ 'o gbo, ‑ye Helɔdiadɩ a 'yu nyrɔyu, nɔ‑ nyre 'o, 'ɔ ‑tʋa ‑wla a yiyie gbo, 'ke 'o nahuin 'bii ye, ʋ da lɛ'mimre ke. 'A yiyie a ‑gbɛ, ɛ klɩɩ Helɔdɩ ke 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Nɛ‑ nue, 'ɔ le ꞊nɔ, ɔ nɔ: «'N 'sʋɛ ke, 'ɛ nɩ dɛ ꞊de, ‑n di 'mʋ ‑hʋa, 'n die ‑mʋ 'nɩ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","‑Ye 'a 'dii, nɔ‑ le 'a 'yu nyrɔyu dɛ ꞊nʋ, ɔ kɔ bɔ nu, 'a 'yu nyrɔyu a ‑gbɛ, 'ɔ le Helɔdɩ, ɔ nɔ: «Dɛ 'nɩɩ ‑mʋ ‑hʋa, nɛ‑ mɔ Saan Batisɩ a 'kʋkʋɛ. 'Bɛ 'o 'a 'lu, ‑bo pu 'le huo wlɔn, ‑bo yʋ 'mʋ ye, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo.» ");
INSERT INTO ted_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","‑Tɛ Helɔdɩ 'wɩn, ‑ye 'a ꞊wlʋ bi ꞊hlɔn. Kɛɛ, ‑tɛ ɔ 'sʋɛ wɛn ke, 'ke 'o nahuin ꞊nʋ ye, ɔ da wɛn lɛ'mimre ke, nɛ‑ nue, 'ɔ le 'a nahuon ‑ye, 'ke bɔ ‑nye 'yu nyrɔyu dɛ ꞊nʋ, ɔɔ ‑hʋa, ");
INSERT INTO ted_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","bɔ mu 'le ꞊jɩkayu gbo, bɔ 'bɛ 'o Saan Batisɩ a 'lu, 'a nahuon a ‑gbɛ, 'ɔ nu dɛ a ‑gbɛ, ");
INSERT INTO ted_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","'ɔ po 'le Saan a 'lu huo wlɔn gbo, 'ɔ yʋ 'le, 'ɔ ‑nyu 'yu nyrɔyu a ‑gbɛ, 'yu nyrɔyu ‑mɛ ‑ye, 'ɔ gbʋ 'a 'dii ye. ");
INSERT INTO ted_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Saan a ‑naagbopʋ ‑mɛ ‑ye, ʋ di la 'le ꞊le, 'ʋ gba la 'a 'kʋkʋku, 'ʋ ‑hɩɔ la 'o. ‑Tɛ ʋ ‑hɩɔ 'o, 'ʋ mu, 'ʋ le ‑Yusu dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","‑Tɛ ‑Yusu 'wɔn ‑tɩ a ‑gbɛ, ‑ye ɔ 'ya 'le wlɔn 'blagbe, 'ɔ mu 'le ‑tɛgbi ‑ye, 'dʋ bii 'le ye. Kɛɛ, nahuin 'ye dɛ a ‑gbɛ nɩ, 'ʋ ‑hɔn 'dɩɛ 'mʋ lɛ, 'ʋ 'yraa 'yru nʋa 'mʋ lɛ, 'ʋ kʋɛ ‑Yusu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","‑Tɛ ‑Yusu 'hrɩ 'le 'blagbe wlɔn, ‑ye ɔ 'ye nahuin 'plɔplɔ ꞊nʋ nɩ, ‑ʋ di 'le. ‑Ye 'waa wɔlɩ nyo nu, nahuin 'bii ꞊nʋ, ‑ʋ kɔ 'hʋɩn a hinhren, 'ɔ ‑wɔ 'waa 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","‑Tɛ 'tɔɔ ‑wɔn, ‑ye ‑naagbopʋ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, 'ʋ lo, ʋ nɔ: «‑Tɛgbi ‑gbo, ‑a nɩ nɔ, 'dʋ bii nɔ ye, dididɛ 'de nɔ nɩ, 'plɩɩ, 'tɔɔ 'nɩ ‑wɔn. 'A ‑tɩ, le nahuin ‑gbo, bʋ mu 'le 'dɩɛ ꞊nʋ 'mʋ, ‑ɩ ꞊glaa 'le ‑a mʋ, bʋ mu 'waa dɩɔnʋ a dididɛ lɛ ꞊mɔ, ʋ 'mue ‑tɔ!» ");
INSERT INTO ted_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","‑Ye ‑Yusu nɔ: «Ʋ 'de ye blɛ bʋ ‑hɔn nɔ 'mʋ. 'A nɩ ‑gbɛ, ba ‑nyu dididɛ!» ");
INSERT INTO ted_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Kɛ ʋ nyo ye po, ʋ nɔ: «‑A 'de dɛ ꞊de kɔ, 'bɛ 'de 'flɔɔkuii ꞊huun ‑do, kɔ ‑hriin 'hɔn 'hɛɛn.» ");
INSERT INTO ted_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","‑Ye ɔ nɔ: «Ba yɩ 'mʋ ye!» 'ʋ yɩ ꞊nɔ ye, ");
INSERT INTO ted_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","'plɩɩ 'ɔ le nahuin ꞊nʋ, bʋ nɩ gblɛ, 'ke 'o ‑piti ke. ‑Tɛ ʋ nɩ 'klɛɛ gblɛ, ‑ye ‑Yusu 'ba 'flɔɔkuii ꞊hun a ‑gbɛ kɔ ‑hriin 'hɔn a ‑gbɛ 'mʋ nɩ, 'ɔ 'ba 'lu ye 'mʋ, 'ɔɔ 'le yrayrɩ lɛ ta, 'ɔ ‑nye Nyɩsʋa 'wio, 'ke 'o dididɛ a ‑gbɛ a ‑ta 'mʋ, 'plɩɩ 'ɔ 'bɩ ꞊tɩɔ lɛ, 'ɔ ‑nyi 'a ‑naagbopʋ, 'a ‑naagbopʋ a ‑gbɛ, 'ʋ nyi nahuin 'bii a ‑gbɛ 'mʋ lɛ woo. ");
INSERT INTO ted_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ʋ 'bii, ʋ di dɛ ‑didi, 'ʋ ꞊mra. ‑Tɛ ʋ ‑wɔ dɛ lɛ, ‑ye didi‑tɔplɩ ꞊nʋ, ‑ɩ hie gblɛ, ‑naagbopʋ, ʋ 'kukui lɛ, 'ʋ 'yie 'le ‑tʋgbɩwɩɩ ‑pu ꞊tu 'o 'hɔn. ");
INSERT INTO ted_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nahuin ꞊nʋ, ‑ʋ di dɛ, 'bʋ 'de 'yuo kɔ nyrʋ 'hɛɛn ‑hre, ‑ye ʋ ‑wɛ 'le bʋ 'ya nyɩbɛpʋ a (5'000) 'milowɩɩ ꞊hun nɩ. ");
INSERT INTO ted_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye tii ‑do a ti 'yri, ‑Yusu le 'a ‑naagbopʋ nɩ, 'ke bʋ 'ya 'le 'blagbe wlɔn, bʋ ꞊ta 'le 'yru a 'pɩa ꞊nʋ ke, 'plɩɩ ɔ 'mu ‑wɔn kʋɛ. Ti a ‑gbɛ 'yri, 'ke ɔ di 'o nahuin wlu gba. ");
INSERT INTO ted_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","‑Tɛ ɔ gbʋ 'klɛɛ wlu, ‑ye ɔ ‑do, 'ke ɔ 'ya 'le dʋgba 'lu, 'ɔ mu 'le Nyɩsʋa ‑wɔn 'prɛɛ wɔn. ‑Tɛ 'tɔ ‑wɔn, ‑ye ɔ ‑do, nɔ‑ 'kɩɛ nɩɛ 'le dʋgba ꞊nʋ 'lu. ");
INSERT INTO ted_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","'Blagbe ‑mɛ ‑ye, 'ke ɛ nɩ 'o 'nɩ‑hɛyri 'mʋ, 'yru a 'dʋɩ 'ɩɩ 'blagbe yrɛ wɛɛ, ‑ɛ nue, pepee 'nɩ ‑hi 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ye‑hɛhapɛ bɛ po wun a ti 'yri, ‑ye ɔ nyu 'o 'mʋ mu 'hʋɩn, 'ɔɔ 'nie ke na. ");
INSERT INTO ted_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","‑Tɛ ʋ 'yo, ɔɔ 'nie ke na, ‑ye ʋ 'ta 'mʋ gblɛ, hʋannʋ a ‑tɩ, ʋ nɔ: «'Kuu nɩ,» 'ʋ ‑tʋa ‑cici a wlɔn‑hɩhɩɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tii ‑do a ti 'yri, ‑ye kɛ ‑Yusu nyu ye po: «Ba 'kee 'mʋgblɛ'tɩta. 'Mɔɔ nɩ. A nɩ pɩ 'le hʋannʋ!» ");
INSERT INTO ted_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","‑Ye Piɛlɩ nɔ: «Sɛyɩ‑sɛyɩ, Kʋkɔnyɔ, 'bɩa 'bɛ 'ya ‑mʋ 'mʋ, ‑ye ‑bo le 'mʋ, ꞊bo na 'nie ke, ꞊bo di 'o ‑mʋ 'hʋɩn 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «Di 'le!» ‑Ye Piɛlɩ ꞊tɩɩ 'le 'blagbe wlɔn, 'ɔɔ 'nie ke na, 'ɔɔ 'le ‑Yusu 'hʋɩn 'mʋ mu. ");
INSERT INTO ted_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","‑Tɛ ɔ 'ye, ‑ɛ mɔ, pepee 'nɩ ‑hi 'dɔ, ‑ye hʋannʋ bio 'le 'kwli 'mʋ, 'ɔ ‑tʋa ꞊mɩɛlɛ gbo. Bɔɔ 'klɛɛ ꞊mɩɛ, ‑ye ɔ 'yaa 'le win, ɔ nɔ: «Kʋkɔnyɔ o, waa 'mʋ ‑o!» ");
INSERT INTO ted_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tii ‑do a ti 'yri, ‑ye ‑Yusu srʋʋ 'a dabʋ nɩ, 'ɔ klo, ɔ nɔ: «‑N 'de 'mʋ ꞊wlʋ ye kuo ‑tɛɛ, ‑ɛ mɔ, 'n ‑wɛ 'le ꞊bo nue nɩ, ‑bo na 'nie ke nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","‑Ye ʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ 'ya 'le 'blagbe wlɔn. ‑Tɛ ʋ 'ya 'klɛɛ, ‑ye pepe ‑wan gbo ke. ");
INSERT INTO ted_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","‑Ye 'a ‑naagbopʋ ꞊nʋ, ‑ʋ nɩ 'le 'blagbe wlɔn, ʋ blɔ ye gbo kwlɩ, ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, ‑mɔ mɔ Nyɩsʋa a 'Yuu nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","‑Tɛ ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ ꞊ta 'yru, ‑ye ʋ nyre 'le Senesalɛtɩdɩɔ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","‑Tɛ ʋ nyre 'klɛɛ 'le, ‑ye nahuin ꞊nʋ, ‑ʋ nɩ 'le 'dɩɔ a ‑gbɛ 'mʋ, ʋ yrii ‑Yusu nɩ, kɔ, 'ʋ 'sɛɛ 'a 'dʋ 'blʋgba 'bii 'mʋ gbo, ‑ɛ mɔ, ‑Yusu nyre 'le ꞊nʋ ‑wɔn nɩ. Nɛ‑ nue, nahuin 'ʋ ya ꞊nɔ kɩklanyʋ 'bii ye, ");
INSERT INTO ted_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","'ʋ nyo lɛ 'batɩ, 'ke bɔ wɛɛn ke, bʋ 'tʋ 'a wlawlʋ lɛ, mɔ ꞊betɩ bɛ 'ya 'a wlawlʋ a bʋgbodɛ 'mʋ. ‑Ye nahuin 'bii, ‑ʋ 'tʋɔ lɛ, 'waa 'kʋɛi ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ɛ kɔ ‑nyrɔwɔ ꞊de, Falisi꞊tumu a nahuin ꞊de, ʋ kɔ Nyɩsʋa a teteitɔɔnyʋ ꞊de 'hɛɛn, nʋ‑ ‑hɔn 'le Jrusrɛdɩɔ 'mʋ, 'ʋ mu 'le ‑Yusu ‑wɔn, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Dɛ tio‑ kɔ ‑tɩ ‑na ‑naagbopʋ 'ʋ 'nɩnɩ ꞊tuu 'o tetei ꞊nʋ 'o, ‑a nɩ bunʋ tɔɔ ‑a mʋ? 'Bɩa 'bʋ 'mʋ dɛ di, ʋ 'nɩ yra ꞊le kwa lɛ.» ");
INSERT INTO ted_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «A ‑mɛ ‑ye 'klɛɛ, dɛ tio‑ kɔ ‑tɩ 'a 'nɩnɩ ꞊tuu 'o Nyɩsʋa a tetei 'o, 'aa 'a nɩ ‑gbɛ a tɔɔwin ‑wɔn kʋɛ? ");
INSERT INTO ted_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","'Ɛ mɔ ‑tɛɛ, Nyɩsʋa ‑nyi ‑a mʋ tetei. Tetei a ‑gbɛ, ɩ nɔ 'nɩ: ꞊Tuu 'o ‑n bu kɔ ‑n dii 'hɛɛn, 'ke 'le 'waa 'mʋnʋɛlɛ 'kwli 'mʋ! ꞊Ɛ ‑ye nɔ 'nɩ: Nahuon 'bɔ ꞊tu 'a bu kɔ 'a 'dii 'hɛɛn a ‑tɩ 'klɩn, ʋ kɔ bʋ 'lɔ. ");
INSERT INTO ted_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kɛɛ, a ‑mɛ ‑ye, a nɔ 'nɩ: Nahuon ‑wɛ 'le bɔ le 'a bu kɔ 'a 'dii 'hɛɛn nɩ, ‑ɛ mɔ: 'N nɛ kʋkɔ‑tɔplɩ a ꞊tɩɔ ‑ye, 'n kɔ ꞊bo ‑nyi wɛn 'a mʋ, 'ke 'o 'a nɩ 'mʋ‑hɛɛlɛ a ‑ta 'mʋ, kɛɛ, 'n ‑hɩ nɩ, 'ke 'o Nyɩsʋa ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","‑Ye a nɔ 'nɩ: Nahuon a ‑gbɛ, 'bɔ ꞊tu ‑tɩ a ‑gbɛ, 'ke 'o 'a bu kɔ 'a 'dii 'hɛɛn ‑wɔn, ‑ye nahuon a ‑gbɛ, ɔ 'de ye blɛ bɔ ‑hɩʋ 'klɛɛ lele 'mʋ. Kɛ'ɛ nɩ, aa nu, 'aa 'o 'a nɩ ‑gbɛgbɛ a tetei 'o ꞊tuu, kɔ, 'aa Nyɩsʋa a ‑tɩ 'wla. ");
INSERT INTO ted_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","A kɔ 'lii 'hɔn. Ti ꞊de a ti 'yri la, winwlɔn‑hɛnyɔ Esai ꞊tu la ‑tɩ a ‑tɛɛ, 'ke 'o 'a mʋ ‑gbo ‑wɔn. Dɛ, ɔ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, nɛ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Kɛ Nyɩsʋa po: Dakʋ ‑gbo, ʋʋ 'mʋ ‑nyi ‑tɩ a 'yi'bʋaalɛ, 'ke 'o 'waa wuntɔ 'yri, kɛɛ, 'waa ꞊wlɩ hren 'mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ʋ nɔ 'nɩ, 'n kɔ ‑tɩ a 'yi'bʋaalɛ, kɛɛ, 'na ‑tɩ 'de 'le ꞊nʋ ꞊wlɩ ke nɩ, ‑ɛ nue, ʋʋ tɔɔ ‑tʋnahuin a tetei, 'ʋ nyi Nyɩsʋa a tetei daa.» ");
INSERT INTO ted_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","‑Ye ‑Yusu da nahuin ‑ye ꞊nʋ nɩ, ‑ʋ nɩ 'o ‑tuoo ‑do a ‑gbɛ ke, ‑ye kɛ ɔ nyu ye po: «Ba po 'mʋ nʋa ye gbo, ‑tɩ 'n di ꞊tu, a 'mui 'mʋ lɛ yrii ‑tɛɛ! ");
INSERT INTO ted_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ɛ 'de dididɛ ‑gbo, ‑ɛɛ 'le ‑tʋnahuon wlɔn naa, ɛ 'de ꞊nɛ, ɛ 'nɩ nue ꞊le, ɔ 'nɩ 'sii ꞊le 'o ye, 'ke 'o Nyɩsʋa ye. Kɛɛ, dɛ ‑gbo, ‑ɛɛ 'le ‑tʋnahuon a ꞊wlʋ ke 'mʋ ‑hɔn, ɛ nɛ‑ nye nu, 'ɔ 'nɩnɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye.» ");
INSERT INTO ted_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","‑Ye 'a ‑naagbopʋ 'yɩya 'o ꞊nɔ 'mʋ gbo 'hʋɩn, 'ʋ lo, ʋ nɔ: «꞊Be ‑n 'die 'ye, ‑ɛ mɔ, ‑tɛ ‑n nu 'pʋprɛ ꞊nʋ, ɛ po Falisi꞊tumu a nahuin 'mʋ lɛ yrʋ?» ");
INSERT INTO ted_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «'Ɛ nɩ 'dɩdɔdɛ 'bɛ nɩ 'o, 'na Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, 'bɛ 'de ꞊nɔ, 'bɔ 'die 'dɔ, ʋ die ‑ha ‑wlu.» (‑Tɛ ‑Yusuu ‑tɩ a ‑gbɛ ꞊tu, Falisi꞊tumu a nahuin ꞊nʋ, ‑ʋ 'de ‑tɛɛ a Nyɩsʋa a nahuin, nʋ‑ ɔ ꞊hɛn 'nyrɛ.) ");
INSERT INTO ted_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kɛ ‑Yusuu lele po, ɔ nɔ: «Ba ‑hɩʋ mɛ lɛ! Ʋ mɔ 'yiisuanyʋ'ʋ nɩ, ‑ʋʋ ‑hʋa ‑bʋ naa 'waa 'bienʋ 'yiisuanyʋ. ‑A 'brikʋɛ nɔ 'nɩ: 'Yiisuanyɔ 'bɔɔ 'a 'be 'yiisuanyɔ naa, ‑ye ʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ di 'le wlɔn bi 'hʋɔ.» ");
INSERT INTO ted_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","‑Ye kɛ Piɛlɩɩ 'klɛɛ po, ɔ nɔ: «‑Hɩhɩa ‑a mʋ ‑talʋdʋ ꞊nʋ klɛ, ‑n po wɛn!» ");
INSERT INTO ted_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","‑Ye ‑Yusu nɔ: «꞊Be 'a nɩ ‑gbɛ, a 'kɩɛ 'die wɛn 'le a ‑wɛɛ, 'ke ba kɔ ‑tɩ a 'mʋlɛyriilɛ? ");
INSERT INTO ted_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","꞊Be a 'nɩ yrie ꞊le 'mʋ lɛ, ‑ɛ mɔ, dididɛ ‑gbo, ‑ɛɛ 'le nahuon wlɔn naa, 'ke ɛɛ 'le ꞊nɔ 'kwli 'mʋ mu, 'ke ɛɛ 'le naa, 'ɛɛ 'le ‑patʋ 'mʋ bi. ");
INSERT INTO ted_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dɛ ‑gbo, ‑ɛɛ 'le nahuon wlɔn 'mʋ ‑hɔn, 'ke ɛɛ 'le nahuon ꞊wlʋ ke 'mʋ ‑hɔn. Ɛ nɛ‑ nye nu, 'ɔ 'nɩnɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye, ");
INSERT INTO ted_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","‑ɛ nue, 'ke 'le ‑tʋnahuon a ꞊wlʋ ke, 'ke 'lu a lɛ‑hielɛ 'klaan 'le 'mʋ ‑hɔn, 'ɛ nye nu, 'ɔɔ ‑tɔplɩ ‑hʋɩn nu: 'ɔɔ nahuin 'la, 'ɔɔ ‑wlawli nu, 'ɔɔ 'lalu nu, 'ɔɔ 'yri, 'ɔɔ 'a 'bienʋ hɩ klɛ po, 'ɔɔ nahuin a 'dʋɩ 'yi lɛ nyre. ");
INSERT INTO ted_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","‑Tɔplɩ 'bii a ‑gbɛ, ɩ nɩ‑ nye nu, nahuon 'ɔ 'nɩnɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye. Kɛɛ, nahuon 'bɔ 'nɩnɩ yra kwa lɛ, 'bɔ 'mʋ dɛ di, dɛ a ‑gbɛ, ɛ 'nɩ nue ꞊le, nahuon 'ɔ 'nɩnɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye.» Kɛ ‑Yusu po 'a ‑naagbopʋ ye. ");
INSERT INTO ted_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu ‑hɔn 'le ‑Juukʋɛ a 'blʋgba 'mʋ nɩ, 'ɔ mu 'le pʋpʋblʋgba ‑ye 'mʋ. 'Ke 'le 'blʋgba a ‑gbɛ 'mʋ, 'ke 'dɩɛ ꞊nʋ, ‑ɛ kɔ 'dʋɩ mɔ Tilɩ kɔ Sidɔ 'hɛɛn, ɛ nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","'Ke 'le ‑tɛgbi a ‑gbɛ, nyrʋgba ꞊de nɩ 'le. Nyrʋgba a ‑gbɛ, ɔ 'de ‑Juukʋɛyrɔwlʋ. Kanaakʋɛyrɔwlʋʋ nɩ. (‑Juukʋɛ ‑mɛ ‑ye, nahuin ꞊nʋ, ‑ʋ 'de ‑Juukʋɛ, nʋ‑ ʋʋ ‑gbo daa.) ‑Tɛ ‑Yusu nyre 'klɛɛ 'le, ‑ye nyrʋgba a ‑gbɛ, ɔ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, 'ɔɔ 'le win 'yaa, kɛ ɔɔ ꞊nɔ ye po, ɔ nɔ: «Dafidɩ a 'Yu! Yrii 'na wɔlɩ. 'Ku ‑hʋan nɩ 'o 'na 'yu nyrɔyu ke 'mʋ, 'ʋ nyo ꞊sʋɛ ꞊tue 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kɛɛ, ‑Yusu 'dio mɛ lɛ po, 'a ‑naagbopʋ 'ʋ 'yɩyɔ 'o 'hʋɩn 'mʋ gbo, 'ʋ nyo lɛ 'batɩ, ʋ nɔ: «Blɔ lɛ, ‑ɛ nue, ɔ 'nɩ nyra ꞊le lɛ'gbugbolɛ gbo, 'ɔɔ ‑a mʋ ‑wɔn kʋɛ.» ");
INSERT INTO ted_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","‑Ye kɛ ‑Yusuu nyrʋgba a ‑gbɛ ye po, ɔ nɔ: «Yisraɛkʋɛ, ‑ʋ mɔ Nyɩsʋa a dakʋ, ‑ʋ hren Nyɩsʋa ‑wɔn, ‑ʋ 'we ꞊nɔ blablɔ ye, ‑ɔ hren 'blakɔnyɔ ‑wɔn, ʋ ‑do, nʋ‑ kɔ ‑wɔn Nyɩsʋa lee nɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kɛɛ, nyrʋgba a ‑gbɛ, ɔ blɔ ye gbo kwlɩ, ɔ nɔ: «Tɔɔnyɔ o, ‑hɛ 'mʋ 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","‑Ye ‑Yusu nyo 'klɛɛ ‑wɔn 'nɩ ꞊tu, ɔ nɔ: «꞊Bo pue dɛ ye: Ɛ 'de 'o lɛ nɔɔ, 'yuo꞊pli, (‑ʋ mɔ ‑Juukʋɛ,) bʋ nɩ 'le dɛ a didie kwa 'mʋ, 'plɩɩ nahuon ꞊de bɔ ‑ha 'o ꞊nʋ 'waa dididɛ ye 'mʋ, 'plɩɩ bɔ 'wlɛ 'o ‑gbo ye gbo.» ");
INSERT INTO ted_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","‑Ye nyrʋgba nɔ: «Tɔɔnyɔ o, 'ɛ mɔ ‑tɛɛ. Kɛɛ 'klɛɛ, nahuin 'bʋʋ dɛ di, ‑tɔplɩ nyu kwa lɛ ble, 'waa ‑gbo 'ɔ nyi lɛ 'tɛ.» ");
INSERT INTO ted_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «Nyrʋgba o, ‑n kuo 'mʋ ye ꞊wlʋ ‑tɛɛ. Dɛ ꞊nʋ, ‑nɩɩ 'mʋ ‑hʋa, 'n kɔ ꞊bo nue.» ‑Ye tii ‑do a ti 'yri, 'yu nyrɔyu a ‑gbɛ a 'kʋɛ ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu ‑hɔn 'le ‑tɛgbi a ‑gbɛ 'mʋ nɩ, 'ɔ mu 'le Galileblʋgba a 'yru nʋa 'mʋ. ‑Tɛ ɔ nyre 'le, ‑ye 'ke ɔ 'ya 'le dʋgba ꞊de 'lu, 'ɔ nɩ gbo. ");
INSERT INTO ted_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bɔ nɩ 'klɛɛ gbo, ‑ye nahuin 'plɔplɔ, nʋ‑ ‑hɔn ‑tɔplɩ 'mʋ lɛ, 'ʋ dio 'o 'hʋɩn 'mʋ, 'ʋ nyo 'dai kɩklanyʋ ye ya: lɛ‑yɩyrɛnyʋ, 'yiisuanyʋ, kɔ nahuin, ‑ʋ 'de 'prɛlɛ yi, kɔ nɩanɩnyʋ, kɔ nahuin 'plɔplɔ ‑ye, 'kʋɛi ‑yee nu, kɩklanyʋ 'bii a ‑gbɛ, 'ʋ yʋ 'o ‑Yusu a bʋɩ ꞊hlɔn, ‑Yusu 'ɔ ‑wɔ 'waa 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ɩ saka nahuin nɩ, ‑tɛ ʋ 'ye nahuin ꞊nʋ, ‑ʋ 'de ꞊ke 'prɛlɛ yi, 'ʋʋ 'prɛ, kɔ, nɩanɩnyʋ 'ʋ 'de 'klɛɛ lele nɩa nɩ, kɔ, lɛ‑yɩyrɛnyʋ, 'ʋʋ na, kɔ, 'yiisuanyʋ, 'ʋʋ lɛ yrii. Dɛ a ‑gbɛ, ɛ nue, Nyɩsʋa ꞊nʋ, Yisraɛkʋɛɛ ꞊ke da, 'ʋ ‑tʋa 'a baalɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusu da 'a ‑naagbopʋ nɩ, ɔ nɔ: «Nahuin ‑gbo, 'waa wɔlɩ‑ɩ 'mʋ nu, ‑ɛ nue, ‑tɛ ʋ bi o mɔ 'mʋ 'hʋɩn 'mʋ, 'a ‑nyrɔwɔ a ta a nɔnɔ nɩ gbo, 'plɩɩ ʋ 'de dididɛ kɔ. 'Bʋ 'de dɛ di, 'nɩ ‑hʋa ꞊le ꞊bo plɛ, bʋ mu 'le 'waa 'dɩɛ klɛ, ‑ɛ die nu, kanʋ a ‑tɩ, 'waa 'klɩi 'nɩ ꞊han 'le ‑wɛ 'hru wlɔn.» ");
INSERT INTO ted_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","‑Ye 'a ‑naagbopʋ ꞊tuo ‑wɔn, ʋ nɔ: «‑Be' ‑a di 'klɛɛ nu 'le, 'plɩɩ ‑a 'mʋ nahuin 'plɔplɔ ‑gbo dididɛ ‑nyi, ‑ɛ di ꞊nʋ ꞊mraa. ‑Tɛgbi ‑gbo, ‑a nɩ nɔ, 'dʋ bii nɔ ye.» ");
INSERT INTO ted_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","‑Ye ‑Yusu ꞊gbʋ wlɔn, ɔ nɔ: «'Flɔɔkuii ‑tie nɩ 'o 'a mʋ ‑wɔn 'le?» ‑Ye ʋ nɔ: «Ɩ 'nɩpata, kɔ ‑hrin.yɔ gbi.» ");
INSERT INTO ted_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","‑Ye ɔ le nahuin ꞊nʋ nɩ, ‑ʋ nɩ 'o ꞊nɔ 'hʋɩn 'mʋ, 'ke bʋ waa gblɛ, ");
INSERT INTO ted_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","'ɔ 'ba 'flɔɔkuii 'nɩpata a ‑gbɛ 'mʋ, ɩ kɔ ‑hrin 'hɛɛn, 'ɔ ‑nyi Nyɩsʋa 'wio, 'ɔ 'bɩ ꞊tɩɔ lɛ, 'ɔ ‑nyi 'a ‑naagbopʋ, 'a ‑naagbopʋ 'ʋ wii nahuin 'mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","‑Ye nahuin 'bii, ʋ di dɛ ‑tɛɛ, 'ʋ ꞊mra. ‑Tɛ ʋ ꞊mra, 'flɔɔ, ‑ɔ hie gblɛ, ‑tɛ ‑naagbopʋ 'kukuo lɛ, ʋ 'yie 'le ‑tʋgbɩ gblakɩɩ 'nɩpata. ");
INSERT INTO ted_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nahuin, ‑ʋ di dɛ, 'bʋ 'de 'yuo kɔ nyrʋ 'hɛɛn ‑hre, ‑ye ʋ mɔ nyɩbɛpʋ a 'milowɩɩ ‑hɛn. ");
INSERT INTO ted_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","‑Tɛ ɛ ‑hi 'klɛɛ, ‑ye ‑Yusu tɩʋ gbo, 'ke bʋ mu 'le 'waa 'dɩɛ klɛ, ɔ ‑mɛ ‑ye, 'ɔ mu, 'ɔ 'ya 'le 'blagbe wlɔn, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ʋ mu 'le 'blʋgba꞊tɩɔ ‑ye 'mʋ. 'Blʋgba꞊tɩɔ a ‑gbɛ 'mʋ, 'ke 'dɩɔ ꞊nʋ, ‑ɔ mɔ Magada, ɔ nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye Falisi꞊tumu kɔ Sadusɩ꞊tumu a nahuin, nʋ‑ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, ‑ɛ die nu, ʋ 'muo 'mʋ lɛ ꞊tɔ. Nɛ‑ nue, 'ʋ le ꞊nɔ, 'ke bɔ nu 'ŋmilɛkadɛ, ‑ɛ nyi ꞊nʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ loo nɔ ‑tʋtʋ ke. ");
INSERT INTO ted_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kɛɛ ‑ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «‑Wisepepei 'mʋ, 'ba 'ye, ‑ɛ mɔ, 'nu 'de 'le yrayrɩ lɛ nɩ, ‑ye kɛ aa po: 'Yrʋ di ‑ŋa 'nɩ hʋan. ");
INSERT INTO ted_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","‑Nyrɛ 'bɛ cɛ lɛ, 'ba 'ye, ‑ɛ mɔ, 'nu nɩ 'le yakɔ 'mʋ lɛ, ‑ye kɛ aa po: 'Nu di kɛ 'nɩ di. ‑Tɔplɩ ꞊nʋ, ‑ɩɩ 'lu ‑wɔn mue, 'ke 'le yakɔ 'mʋ, a yi 'a klɛ‑hɩhɩalɛ, 'a nye 'ye, ‑tɛ ‑nyrɛ di 'mʋ nɩ. Kɛɛ, ‑tɔplɩ ‑gbo, Nyɩsʋaa nu, ‑ɩɩ kɛ 'lu ‑wɔn mue, a 'de 'a klɛ‑hɩhɩalɛ yi. ");
INSERT INTO ted_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ti ‑gbo 'yri a nahuin ‑gbo, 'waa nunuklɔ nyre lɛ 'yi, 'ʋ plee 'le Nyɩsʋa ke. Kɛɛ, ʋʋ ‑hʋa 'ŋmilɛkadɛ, ‑ɛ nyi ꞊nʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee nɔ 'mʋ 'klɔ ‑gbo ke. Kɛɛ, Nyɩsʋa 'deɛ bɔ wɛɛn ke, 'ke 'ŋmilɛkadɛ ꞊de bɛ mue 'lu ‑wɔn, 'bɛ 'de 'ŋmilɛkadɛdʋ ꞊nʋ, ‑ɛ 'we ꞊nɔ 'ŋmilɛkadɛ ꞊nʋ ye, Nyɩsʋa nu la, 'ke 'o 'a winwlɔn‑hɛnyɔ Jona a ‑ta 'mʋ.» Bɔ po 'klɛɛ lɛ, ‑ye ɔ ‑hɔn 'o ꞊nʋ 'hʋɩn 'mʋ nɩ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ʋ mu 'le Galileblʋgba a 'yru a 'pɩa ꞊nʋ ke. ");
INSERT INTO ted_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","‑Tɛ ‑Yusu a ‑naagbopʋʋ 'le 'blagbe wlɔn 'ya, ‑ye ɩ ‑hri ꞊nʋ ‑wɔn, 'ke bʋ gba 'flɔɔ, ʋ 'muo di, 'ʋ nyre 'le 'yru a 'pɩa ꞊nʋ ke. ");
INSERT INTO ted_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","‑Ye ‑Yusu nyu 'nɩ tii, ɔ nɔ: «Falisi꞊tumu a nahuin, kɔ Sadusɩ꞊tumu a nahuin 'hɛɛn, 'waa 'flɔɔ a 'yaadɛ a ‑tɩ, ba ꞊tu 'a nɩ dɩɔnʋ 'yie!» ");
INSERT INTO ted_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","‑Naagbopʋ, ʋ 'die yrii, ‑ɛ mɔ, 'yaadɛ ꞊nʋ, ‑ɛ kɔ ‑tɩ ‑Yusu ꞊tu, ɛ mɔ dɛ a yepoodɛ'ɛ nɩ, ‑ɛ ꞊hɛn 'nyrɛ nahuin a ‑gbɛ a 'lu a lɛ‑hielɛ 'klan. ‑Tɛ ʋ 'die yrii, nɛ‑ nue, 'ʋʋ wlɔn lɛ ꞊gbʋgba, ʋ nɔ: «꞊Be ‑tɛ ‑a 'de 'le 'flɔɔ ya, nɛ‑ nue, 'ɔɔ lɛ 'pʋprɛ nu?» ");
INSERT INTO ted_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","‑Tɩ ꞊nʋ, ‑naagbopʋ ꞊tu, ‑Yusu 'wɩn nɩ, ɔ nɔ: «'A mʋ ‑gbo, ‑ʋ 'de 'mʋ ꞊wlʋ ye kuo ‑tɛɛ, dɛ‑ kɔ 'kla, ɔɔ 'a mʋ ‑wliye 'ya 'le, ‑tɛ ‑a 'de kɛ dididɛ kɔ a ‑tɩ? ");
INSERT INTO ted_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","A 'kɩɛ 'dee wɛn ‑tɩ a 'mʋlɛyriilɛ a kʋɛ, 'plɩɩ, ‑tɩɩ 'a mʋ ‑wɔn ‑hri. ‑Tɛ 'n wloo o 'flɔɔkuii ꞊hun, 'ke ‑tʋnahuin a 'milowɩɩ ꞊hun bʋ di dɛ a ‑ta 'mʋ, ‑tɛ ʋ ‑wɔ o dɛ lɛ, 'flɔɔ ꞊nʋ, ‑ɔ hie o gblɛ, ‑tʋgbɩɩ ‑tie a 'yie o 'le? ꞊Be ɩ ‑hri 'a mʋ ‑wɔn? ");
INSERT INTO ted_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","'Plɩɩ, ‑tɛ 'n wloo o 'flɔɔkuii 'nɩpata, 'ke ‑tʋnahuin a 'milowɩɩ ‑hɛn bʋ di dɛ a ‑ta 'mʋ, ‑tɛ ʋ ‑wɔ o dɛ lɛ, 'flɔɔ ꞊nʋ, ‑ɔ hie o gblɛ, ‑tʋgbɩɩ ‑tie a 'yie o 'le? ꞊Be ɩ ‑hri ‑wɛ 'a mʋ ‑wɔn? ");
INSERT INTO ted_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","꞊Be a 'nɩ 'ye ꞊le, ‑ɛ mɔ, 'nɩ ꞊tu ꞊le 'flɔɔ a ‑tɩ? Kɛ 'nɩɩ po: Falisi꞊tumu a nahuin, kɔ Sadusɩ꞊tumu a nahuin 'hɛɛn, 'waa 'flɔɔ a 'yaadɛ a ‑tɩ, ba ꞊tu 'a nɩ dɩɔnʋ 'yie!» ");
INSERT INTO ted_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","‑Tɛ ‑Yusu po 'klɛɛ lɛ, ‑ye 'a ‑naagbopʋ yrie 'mʋ lɛ, ‑ɛ mɔ, ɔ 'nɩ le ꞊le ꞊nʋ, 'ke bʋ ꞊tu 'waa dɩɔnʋ 'yie, 'ke 'o 'flɔɔ a 'yaadɛ ꞊nʋ a ‑ta 'mʋ, ‑ɛɛ 'flɔɔ 'yaa, kɛɛ, bʋ ꞊tu 'waa dɩɔnʋ 'yie, 'ke 'o hɩtɔɔlɛ ꞊nʋ a ‑ta 'mʋ, Falisi꞊tumu kɔ Sadusɩ꞊tumu a nahuin 'hɛɛn, ʋʋ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, 'ke ʋʋ 'le 'blʋgba꞊tɩɔ ꞊nʋ 'mʋ mu, ‑ɔ 'mʋɛɛ 'blʋgba ꞊nʋ ye, ‑ɔ kɔ 'dʋ mɔ Filipʋ a Sesale. ‑Ye ɔ ꞊gbʋ wlɔn: «'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, nahuin nɔ dɛ‑, nahuon a gblo tio‑ 'n 'ya 'klɛɛ 'mʋ 'le?» ");
INSERT INTO ted_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","‑Ye ʋ ꞊tuo ꞊wɔn, ʋ nɔ: «꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Saan Batisɩ, ‑ɔɔ o nahuin 'nie 'lu lɛ po. ꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ Eli. ꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ Selemi. ꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ ‑yee nɩ, ‑ɔ 'kʋ la, ti ‑hi la a ti 'yri, 'plɩɩ ‑ɔ 'hrɩ lele 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","‑Ye ɔ nɔ: «A ‑mɛ ‑ye, a nɔ 'nɩ, nahuon a gblo tio‑ 'n 'ya 'klɛɛ 'mʋ 'le?» ");
INSERT INTO ted_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","‑Ye Simɔ Piɛlɩ nɔ: «‑Mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya. ‑Mɔ mɔ 'Klɔhienyɩsʋa a 'Yuu nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","‑Ye kɛ ‑Yusu nyo ye po, ɔ nɔ: «'Ɛ mɔ ‑tɛɛ, Simɔ Piɛlɩ, ‑ɔ mɔ Saan a 'yu. ‑Tɩ ꞊nʋ, ‑n ꞊tu, ɛ 'de ‑tʋnahuon, ɔ 'de ‑mʋ le. 'Na Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, nɔ‑ le ‑mʋ. ");
INSERT INTO ted_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","'Nɩɩ ‑mʋ 'nɩ le, ‑na 'dʋ mɔ Piɛlɩ, ‑ɛ ꞊hɛn 'nyrɛ 'hɩɔ. Nɔ‑ kɔ ke 'n di 'o 'na 'cʋɛ poo. Mɔ ꞊betɩ 'kʋkʋɛ, ɛ 'die 'le ‑wɛ bɛ ‑wɔ 'cʋɛ a ‑gbɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","'N di ‑mʋ Nyɩsʋa a 'klɔ yrayrʋ a 'maju a 'yɔ 'nɩ ‑nyi. ‑Tɔplɩ 'bii ꞊nʋ, ‑n di nahuin le, ʋ nɩ nu 'le, kɛ nɔ ‑tʋtʋ ke, Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ di ‑wɛ 'nɩ ꞊tu. Kɔ, ‑tɔplɩ 'bii ꞊nʋ, ‑n di ke wɛɛn, 'ke nahuin bʋ nu, Nyɩsʋa, ɔ di ‑wɛ ke 'nɩ wɛɛn.» ");
INSERT INTO ted_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","‑Ye ‑Yusu tii 'a ‑naagbopʋ nɩ ‑tɛɛ, ɔ nɔ: «A nɩ le 'le nahuon ꞊de, ‑ɛ mɔ, 'mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya.» ");
INSERT INTO ted_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kʋɛ 'o ti a ‑gbɛ 'yie 'mʋ gbo, ‑Yusu ‑tʋa 'a ‑naagbopʋ ‑tɔplɩ ꞊nʋ a klɛ‑hɩhɩalɛ gbo, ‑ɩ kɔ ‑bɩ nue ꞊nɔ, ɔ nɔ: «'N kɔ ꞊bo mu ‑tado 'le Jrusrɛdɩɔ 'mʋ. 'Blʋ a nahuin, kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ Nyɩsʋa a teteitɔɔnyʋ 'hɛɛn, ʋ kɔ bʋ ꞊tue ‑tado 'mʋ ꞊sʋɛ, kɔ, ʋ 'mʋ 'mʋ 'la. 'Bɩa 'nɩ 'kʋ, ‑nyrɔwɩɩ 'hɔn, ‑nyrɔwɔ a ta a nɔnɔ 'mʋ, Nyɩsʋa kɔ bɔ ‑ha 'mʋ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","‑Ye Piɛlɩ dɔɔ ye, 'ɔ nyo 'nyrɛ ꞊hɛn, ɔ nɔ: «‑Tɩ ꞊nʋ, ‑nɩɩ 'lu ‑wɔn lɛ ‑hie, 'nɩ ‑hʋa ꞊le, 'ke bɩ nue ‑mʋ, kɔ, Nyɩsʋa nɩ wɛɛn 'le ke, 'ke bɩ nue ‑mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","‑Ye ‑Yusu ꞊hɩan ‑wɔn, 'ɔɔ Piɛlɩ le, ɔ nɔ: «Hren 'mʋ ‑wɔn, Satan! ‑Nɩɩ 'mʋ ye 'nɩ ka, 'ke ꞊bo nu dɛ ꞊nʋ, Nyɩsʋaa ‑hʋa. Dɛ ꞊nʋ, ‑nɩɩ 'lu ‑wɔn lɛ ‑hie, Nyɩsʋa a 'lu a lɛ‑hielɛ 'nɩ po ꞊le lɛ, kɛɛ, ‑tʋnahuin a 'lu a lɛ‑hielɛ'ɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Bɔ po 'klɛɛ lɛ, ‑ye kɛ ɔɔ 'a ‑naagbopʋ ye po, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔ nye ‑hʋa, 'ke bɔ naa 'mʋ ‑wɔn, ‑ye ɔ nɩ kʋɛ 'le 'a ‑gbɛ a 'lu a lɛ‑hielɛ ‑wɔn, kɛɛ, ‑tɩ ꞊nʋ, 'nɩɩ ꞊nɔ ye ꞊tu, bɔ ꞊tui 'o, bɔ nui 'ɛ nɩ ti, ꞊betɩ nahuin bʋ plɛ, ʋ 'muo 'la, ‑tɛ ɔ nu, 'ɔ 'ya 'na nahuon 'mʋ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nahuon 'bɔ nɩ 'o, 'bɔ plɛ, ɔ 'nɩ ‑hʋa ꞊le bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, 'ke 'o 'na ‑ta 'mʋ, ‑ye nahuon a ‑gbɛ 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn 'a 'klɔ yrayrʋ 'nɩ 'waan, 'ke 'le Nyɩsʋa ye. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ wɛɛn ke, 'ke bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, ‑tɛ ɔ nʋɛ 'mʋ 'mʋ a ‑tɩ, ‑ye nahuon a ‑gbɛ, 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'ke 'le Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Nahuon 'bɔ kɔ 'klɔ ‑gbo ke a kʋkɔ‑tɔplɩ a pɛpɛ 'bii, 'plɩɩ 'bɔ 'waan 'a dɩɔnʋ a 'klɔ yrayrʋ, 'ke 'le Nyɩsʋa ye, ‑ye kʋkɔ‑tɔplɩ a ‑gbɛ, ɩ 'nɩ pue ꞊le 'o ꞊nɔ dɛ nɩ. Nahuon ꞊de 'die 'le ‑wɛ, bɔ po 'o dɛ ꞊de 'klɔ yrayrʋ a ‑gbɛ ꞊pɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","'Nɩɩ 'a mʋ ‑tɩ 'bii ‑gbo ye 'nɩ ꞊tu, ‑ɛ nue, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di ‑hlɩn 'le 'nɩ di, 'ke 'le 'na Bu Nyɩsʋa a ‑tɩ a 'yi'bʋaalɛ 'kwli 'mʋ, 'n kɔ 'a lɛleenyʋ 'hɛɛn. Ti a ‑gbɛ 'yri, 'na Bu di 'ɛ nɩ nahuon ‑nyi 'wio, ‑hee' ɔ dio lɛ poo yrʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'ɛ nɩ nahuon a nunuklɔ nɩ la 'mʋ, kɛ nɔ ‑tʋtʋ ke. ");
INSERT INTO ted_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ke 'le 'a mʋ ‑hɛyri, nahuin ‑ye nɩ 'le, ʋ 'mue ‑hlɩn 'ye, ‑tɛ 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'ledidie nu, 'mʋ nahuin win ke kɔɔ, 'plɩɩ ɛ 'mʋ ‑hlɩn nahuin a ‑gbɛ a 'kʋkʋɛ ke yɛ.» ");
INSERT INTO ted_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","‑Tɛ ‑nyrɔwɩɩ ‑huonnɔ ‑hi, ‑ye ‑Yusu gba Piɛlɩ, kɔ Sakɩ, kɔ Sakɩ a ‑gbɛ a ‑dɩayu Saan 'hɛɛn nɩ, 'ʋ mu 'le dʋgba ‑pɛtu ꞊de 'lu. ");
INSERT INTO ted_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","'Ke ʋ nɩ 'klɛɛ 'le, ‑ye ‑Yusu 'cɩcɩ nɩ, 'ke 'le ꞊nʋ 'yi 'mʋ, 'a yigbakla 'ɔɔ wlɩn, ‑ɛ 'we ꞊nɔ 'yrʋ ye, 'a 'hʋɩn'mʋlɛpue‑tɔplɩ 'ɩ 'plɛ, ‑ɛ 'we ꞊nɔ ‑nyrɛ ye. ");
INSERT INTO ted_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","‑Ye tii ‑do a ti 'yri, ʋ 'ye Nyɩsʋa a winwlɔn‑hɛnyʋ Moise kɔ Eli 'hɛɛn. Nahuiin 'hɔn a ‑gbɛ, ʋ 'kʋ la si la. Nʋ‑ 'hrɩɩ 'o ‑Yusu 'hʋɩn 'mʋ, ʋ kɔ ꞊nɔ 'hɛɛn, 'ʋ ‑tʋa toto a pupue gbo. ");
INSERT INTO ted_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","‑Ye kɛ Piɛlɩ, ɔɔ ‑Yusu ye po: «Kʋkɔnyɔ o, ɛ nu ‑tɛɛ, 'ke ‑ba nɩ nɔ ‑tɛgbi ‑gbo gbo. 'Bɩa ꞊nɩ nye ‑hʋa, 'n di po blɛɛ ta: ‑n nɔnɔ, Moise a nɔnɔ, kɔ Eli a nɔnɔ.» ");
INSERT INTO ted_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Win nɩ 'le ꞊nɔ wlɔn, tii ‑do a ti 'yri, ‑jrugba 'ɔɔ wlɩn, 'ɔ ꞊tɩɩ 'o ꞊nʋ 'lu, 'ɔ ‑hli ꞊nʋ. 'Ke 'le ‑jrugba a ‑gbɛ 'kwli 'mʋ, 'ke Nyɩsʋa a wiin 'le 'mʋ ‑hɔn, 'ɩɩ lɛ po: «Nahuon ‑gbo, nɔ‑ mɔ 'na 'mʋnʋɛyu. Ɔɔ 'mʋ ‑nyi plɔ a bleelɛ. Nɔ‑ ba po nʋa ye gbo.» ");
INSERT INTO ted_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","'Plɩɩ ‑naagbopʋ 'mʋ win a ‑gbɛ mu 'wɔn, ‑ye hʋannʋ biu 'le 'kwli 'mʋ, 'ʋ bla kwlɩ gbo, 'ʋ kɔ yigbaklɩ gblɛ, 'ke 'o Nyɩsʋa a 'o꞊tuulɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","‑Ye ‑Yusu 'yɩya 'o ꞊nʋ 'mʋ gbo 'hʋɩn, 'ɔ 'tʋ lɛ, ɔ nɔ: «Ba 'ba ye 'mʋ, a nɩ pɩ 'le hʋannʋ!» ");
INSERT INTO ted_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","‑Tɛ ʋ 'ba 'yii ye 'mʋ, ‑ye ʋ 'nɩ 'ye ꞊le nahuon ꞊de, 'bɩa 'bɛ 'de ‑Yusuu ‑do. ");
INSERT INTO ted_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Bʋʋ 'klɛɛ dʋgba ꞊tɩ, ‑Yusu tiu nɩ, ɔ nɔ: «Dɛ ‑gbo, a 'ye, a nɩ le 'le nahuon ꞊de, ɛ 'mue gba ‑gbagba, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mʋ 'kʋ, Nyɩsʋa 'mʋ 'le 'mʋ 'kʋkʋnyʋ ‑hɛyri ‑ha, ɔ 'mʋ 'mʋ 'klɔ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","‑Ye ‑naagbopʋ nyo wlɔn 'nɩ ꞊gba, ʋ nɔ: «Dɛ‑ nue, Nyɩsʋa a teteitɔɔnyʋ 'ʋʋ lɛ po, Nyɩsʋa a winwlɔn‑hɛnyɔ Eli, nɔ‑ kɔ ‑bɔ di 'le ‑tɩtɛ, 'plɩɩ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, ɔ 'mʋ 'le di 'le?» ");
INSERT INTO ted_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","‑Ye ɔ nɔ: «'Ɛ mɔ ‑tɛɛ, Eli kɔ bɔ di 'le, ɔ 'mʋ Nyɩsʋa a dakʋ 'mʋ ‑hɛ, ʋ 'mʋ 'waa 'klɔ ‑hlɛntie, ʋ 'mʋ ‑wɔn ‑wɛ, 'plɩɩ Waanyɔ a ‑gbɛ, ɔ 'mʋ 'le di. ");
INSERT INTO ted_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","'Nɩɩ 'a mʋ 'nɩ le: Nahuon, ‑ɔ 'we ꞊nɔ Eli ye, ɔ di 'le ꞊le, kɛɛ, ʋ 'dio yrii, 'plɩɩ 'yilɛnyredɛ ‑gbo, ‑tʋnahuiin ‑hʋa bʋ nu ꞊nɔ 'mʋ, 'ʋ nue ꞊nɔ 'mʋ. ‑Tɛ ʋ nu Eli ꞊sʋɛ a ꞊tuelɛ, kɛ'ɛ nɩ, ʋ di ‑wɛ 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ꞊sʋɛ a ꞊tuelɛ nu.» ");
INSERT INTO ted_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","‑Ye ‑naagbopʋ yrie nɩ, ‑ɛ mɔ, Eli ꞊nʋ, ‑ɔ kɔ ‑tɩ ɔ ꞊tu, Saan Batisɩɩ nɩ, ɔ ꞊hɛn 'nyrɛ. ");
INSERT INTO ted_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","‑Yusu kɔ 'a ‑naagbopʋʋ ta ‑nɩ wɛn 'hɛɛn, ‑tɛ ʋ ꞊tɩ 'klɛɛ dʋgba, ‑ye ʋ nyre 'o ‑tɛgbi ꞊nʋ nɩ, nahuin 'plɔplɔ nɩ 'o. ‑Ye nahuon ꞊de, nɔ‑ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, 'ɔ blɔ kwlɩ ye gbo, ");
INSERT INTO ted_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ɔ nɔ: «Tɔɔnyɔ, 'ye 'na 'yu nyɩbɛyu a wɔlɩ, ‑ɛ nue, ‑wʋwɔpipi nyo nu, 'ɔɔ ꞊sʋɛ 'ye 'dɔ. Ɛ kɔ ti, 'ɔɔ 'le 'tɔ lɛ bi, kɔ 'ke 'le 'nie ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","'N gbɔ 'le ‑na ‑naagbopʋ ye nɩ, kɛɛ, ʋ 'de 'le 'a 'kʋɛ a ‑wʋwɔ ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Kɛ ‑Yusuu 'klɛɛ 'a ‑naagbopʋ ye po, ɔ nɔ: «'A mʋ mɔ nahuiin nɩ, ‑ʋ 'de Nyɩsʋa ꞊wlʋ ye kuo, kɔ, ‑ʋ 'de ꞊hapʋdɛ kɔ dɛ 'klan a 'yi'mʋlɛ‑hɩhɩalɛ yi. Tii ‑tie 'n kɔ ꞊bo ‑hi nɔ 'a mʋ ‑hɛyri, 'plɩɩ a 'mʋ Nyɩsʋa ꞊wlʋ ye kuo 'le? ꞊Be 'n 'kɩɛ die ‑hlɩn 'a mʋ lɛ kikle? Ba ya 'mʋ 'yu a ‑gbɛ ye!» ");
INSERT INTO ted_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","‑Tɛ ʋ yɔ 'klɛɛ ꞊nɔ ye, ‑ye ‑Yusu 'prɛɛ 'le 'ku ‑hʋan ꞊nʋ ‑wɔn, ‑ʋ nɩ 'o 'yu a ‑gbɛ ke 'mʋ, 'ke 'le win 'yaklɩ 'kwli 'mʋ. ‑Ye 'ku ‑hʋan a ‑gbɛ, ʋ ‑hɔn 'o ꞊nɔ ke 'mʋ nɩ. ‑Ye tii ‑do a ti 'yri, 'yu a ‑gbɛ a 'kʋɛ ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","‑Tɛ ti gbi ‑hi, ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ‑tɛ ʋ ‑do, ʋ nɩ 'klɛɛ 'o gbo, ‑ye ʋ ꞊gbɔ wlɔn, ʋ nɔ: «Dɛ‑ nue 'klɛɛ, ꞊a 'die wɛn 'le ‑wɛ, 'ke ‑ba bla 'ku ‑hʋan ꞊nʋ lɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «A 'de Nyɩsʋa ꞊wlʋ ye kuo ‑tɛɛ, 'ke bɔ ‑wɔ 'yu a ‑gbɛ a 'kʋɛ. 'Nɩɩ 'a mʋ 'nɩ le, ꞊betɩ ba kuo Nyɩsʋa ꞊wlʋ ye dɛ gbi, ‑ye a ‑wɛ 'le ba le dʋgba ꞊nʋ nɩ: ‑Hɔn mɔ ‑tɛgbi ‑gbo 'mʋ, ‑bo mu 'le ‑tɛgbi ꞊nʋ, 'ɛ mɔ ‑tɛɛ, ɔ 'mʋ 'o ‑hɔn. ‑Ye a ‑wɛ 'le ba nu 'ɛ nɩ dɛ ꞊de nɩ.  ");
INSERT INTO ted_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","'Bɩa 'baa Nyɩsʋa da, 'ke 'le ꞊cicie 'kwli 'mʋʋ ‑do, 'plɩɩ a 'mʋ 'le ‑wɛ ba bla 'kuo ‑hʋɩndʋ a ‑gbɛ lɛ.» ");
INSERT INTO ted_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusu kɔ 'a ‑naagbopʋ 'bii 'hɛɛn, ʋ 'kukue lɛ, 'ke 'le Galileblʋgba 'mʋ. ‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ʋ kɔ bʋ po 'mʋ nahuin kwa, ");
INSERT INTO ted_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ʋ 'mʋ 'mʋ 'la. Kɛɛ, 'bɩa 'nɩ 'kʋ, ‑nyrɔwɩɩ 'hɔn 'bɩ ‑hi, ta a nɔnɔ 'mʋ, 'n kɔ ꞊bo ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, 'mʋ 'klɔ 'hrɩ.» ‑Tɛ ʋ 'wɔn ‑tɩ a ‑gbɛ, ‑ye 'waa ꞊wlɩ 'mʋɛ ‑gbo. ");
INSERT INTO ted_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye 'ke ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ nyre 'le Kapɛnaɔdɩɔ 'mʋ. ‑Ye 'klɛɛ, 'ke 'le ‑Juukʋɛ ‑hɛyri, ɛ kɔ la 'blʋwli'tɛnyʋ, 'ʋʋ 'wli 'tɛ, 'ke 'o Nyɩsʋa a 'kagblaka a ‑kʋan a ‑ta 'mʋ. 'Blʋwli'tɛnyʋ a ‑gbɛ, nʋ‑ 'yɩya 'o Piɛlɩ 'hʋɩn 'mʋ gbo, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: «꞊Be 'a nɩ tɔɔnyɔ ‑Yusu, ɔɔ Nyɩsʋa a 'kagblaka a 'blʋwli 'nɩ 'pɛɛ?» ");
INSERT INTO ted_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","‑Ye Piɛlɩ nɔ: «Iin, ɔ nyi 'nɩ 'pɛɛ.» ‑Ye ɔ mu 'le gbo kayu, ‑ɛ die nu, ɔ 'mui ‑Yusu ye ꞊tu. Bɔɔ 'klɛɛ kayu gbo pa, ‑ye ‑Yusu 'nyɛ 'hru, 'ɔ ꞊gbɔ wlɔn, ɔ nɔ: «Simɔ Piɛlɩ, dɛ ‑nɩɩ 'klɛɛ 'lu ‑wɔn lɛ ‑hie 'le, 'ke 'o 'blʋwli a 'pɛɛlɛ a ‑ta 'mʋ? 'Bɩa 'blʋgba a ye'mʋnaanyʋ 'bʋʋ 'blʋwli 'tɛ, nahuin tio‑ ʋʋ 'blʋwli ‑hʋa 'le? ꞊Be 'blʋgba a 'yuo, ‑hee' pʋpʋnahuin?» (Ti a ‑gbɛ 'yri, 'blʋgba a ye'mʋnaanyʋ, pʋpʋnahuin, nʋ‑ ʋʋ la 'blʋwli ‑hʋa, ɛ 'de 'blʋgba a 'yuo.) ");
INSERT INTO ted_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","‑Ye Piɛlɩ nɔ: «Pʋpʋnahuiin nɩ.» ‑Ye ‑Yusu nɔ: «'A ‑tɩ o, 'blʋgba a 'yuo 'de 'pɛɛlɛ kɔ. ");
INSERT INTO ted_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kɛɛ 'klɛɛ, 'blʋwli'tɛnyʋ ‑gbo, ‑ʋ 'de 'na ‑naagbopʋ, ‑a 'nɩ ‑hʋa ꞊le ‑ba pu yrʋ 'mʋ lɛ. 'A ‑tɩ, mu 'le 'yru wien, ‑bo ꞊gba ‑wedi. Ye‑hɛ‑hrin.e ꞊nʋ, ‑n di 'pa, kla 'a wuntɔ ye. 'Ke 'le ꞊nɔ wlɔn, ‑n di 'le 'yee 'wliyɔkɔ a 'yɛɛ ‑do, ‑ɛ ‑wɛ 'le ‑bɛ 'pɛɛ ‑a nɩ 'blʋwli, ‑n kɔ 'mʋ 'hɛɛn. Nɛ‑ ‑n di nu, ꞊mʋ ‑a nɩ 'blʋwli a ‑gbɛ 'pɛɛ.» ");
INSERT INTO ted_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ti a ‑gbɛ 'yri, ‑ye ‑Yusu a ‑naagbopʋ 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: «'Ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, nahuon tio‑ nɩ 'o 'a 'be 'lu ye 'le?» ");
INSERT INTO ted_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","‑Tɛ ʋ ꞊gbɔ 'klɛɛ wlɔn, ‑ye ɔ da 'yu gbi, 'ɔ ꞊tuo 'o ꞊nʋ ye gbo, ");
INSERT INTO ted_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le, 'bɩa 'ba 'de 'o dɛ 'kuku a nunue gbo hie, kɔ, 'bɩa 'ba 'nɩnɩ ꞊tɩɔ 'le 'a nɩ dɩɔnʋ, ‑ɛ 'we ꞊nɔ 'yuo꞊pli ye, ‑ye a 'deɛ ba pa 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nahuon 'bɔ nɩ 'o, 'bɔɔ 'le 'a dɩɔnʋ ꞊tɩɔ, ‑ɛ 'we ꞊nɔ 'yu gbi ‑gbo ye, nɔ‑ di 'a 'bienʋ 'lu ye nɩ, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","'Ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɛ 'yu gbi ‑gbo, ɔ nɩ 'mʋ, 'bɔ 'ble 'a nahuon kwa, 'ke 'o 'na 'dʋ a ‑ta 'mʋ, ‑ye 'na ‑gbɛɛ nɩ, ɔ 'ble kwa.» ");
INSERT INTO ted_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «Nahuon ꞊nʋ, ‑ɔ kuo 'mʋ ꞊wlʋ ye, ‑ɛ 'we ꞊nɔ 'yu gbidʋ ‑gbo ye, 'bɩa nahuon 'bɔ nue, nahuon a ‑gbɛ bɔ 'kee 'na ꞊wlʋ a yekuolɛ, ‑ye ɛ nɔɔ 'o lɛ, 'ke 'o nahuondʋ a ‑gbɛ ‑wɔn, ‑ɔ nu dɛ a ‑gbɛ, 'ke bʋ puo 'hɩɔ gbɛtɛɛ dɔ, 'plɩɩ bʋ puo 'yru 'mʋ, ɔ 'mʋ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","'Jrɔ 'ke 'o nahuin ꞊nʋ ‑wɔn, ‑ʋ 'de Nyɩsʋa yi, ‑ʋ nye nu, nahuin 'ʋʋ dɛ 'kuku nu. ‑Tɔplɩdʋ a ‑gbɛ, ɩ kɔ bɩ mue 'lu ‑wɔn. Kɛɛ, 'jrɔ 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ nye nu, 'ɩɩ 'lu ‑wɔn mue. ");
INSERT INTO ted_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","'Bɩa ‑na dabʋ ‑hee' ‑na bʋ 'bʋ nye nu, ꞊nɩɩ dɛ 'kuku nu, ‑ye ‑bo 'bɩʋ 'o, ‑bo pu 'kwla 'mʋ. Ɛ nu ‑tɛɛ, 'ke ‑bo nɩ dabʋ‑tɩɔ, ‑hee' bʋ‑tɩɔ, 'plɩɩ ‑bo pa 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'ɛ ‑hi 'o ‑na dabʋɩɩ 'hɔn ‑hee' ‑na bʋɩɩ 'hɔn bɩ ꞊cɛɛ 'o ye, 'plɩɩ ‑bo mu 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe. ");
INSERT INTO ted_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","'Bɩa ‑na 'yie 'bɛ nye nu, ꞊nɩɩ dɛ 'kuku nu, ‑ye ‑bo ‑hɩɛ 'le, ‑bo pue 'kwla 'mʋ. Ɛ nu ‑tɛɛ, 'ke ‑bo nɩ 'yie'kɛɛ, 'plɩɩ ‑bo pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, 'ɛ ‑hi 'o ‑na 'yii 'hɔn bɩ ꞊cɛɛ 'o ye, 'plɩɩ bʋ po 'le ‑mʋ na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe.» ");
INSERT INTO ted_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Kɛ ‑Yusuu lele po, ɔ nɔ: «Ba ꞊tu 'a nɩ dɩɔnʋ 'yie, 'ke a 'nɩ ꞊han 'na nahuon ꞊de yraa, ‑ɛ nue, ɔ 'de nahuon gblaka. 'Nɩɩ 'a mʋ 'nɩ le, nahuin ꞊nʋ, ‑ʋ 'de nahuin gblakɩ, Nyɩsʋa a lɛleenyʋ, nʋ‑ nyu 'yie ꞊tu, lɛleenyʋ a ‑gbɛ, 'ʋ kɔ 'hru, 'ke bʋ 'cipi 'o 'na Bu Nyɩsʋa 'hʋɩn 'mʋ, ‑ɔ nɩ 'le yakɔ 'mʋ.  ");
INSERT INTO ted_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mɔ Nyɩsʋa lee nɔ ‑tʋtʋ ke, 'mʋ nahuin ꞊nʋ lɛ ꞊mɔ, ‑ʋ 'wan, ‑ʋ hren Nyɩsʋa ‑wɔn, 'mu waa, 'ke 'o 'waa 'yilɛnyre‑tɔplɩ ꞊nʋ, ʋ nu a ‑ta 'mʋ, ʋ 'mʋ Nyɩsʋa ye 'mʋɛɛ.» ");
INSERT INTO ted_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‑Ye ɔ nye ye po dɛ, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔ kɔ blablɔ a (100) ‑wlɩɩ ꞊hun, 'bɔ gbɔ 'le 'cɛɛlɛ 'mʋ, 'plɩɩ blablɔ a ‑gbɛ, 'a 'yɛɛ ‑do 'bɛ 'wan, dɛ tio‑ ɔ di nu 'le? Ɔ kɔ bɔ hie 'o blablɔ a (99) ‑wlɩɩ ‑hɛn ꞊tu 'o ‑pu ꞊tu 'o seledo ꞊nʋ gbo, 'ke 'le 'cɛɛlɛ 'mʋ, bɔ mu blablɛ ꞊nʋ lɛ ꞊mɔ, ‑ɛ 'wan. ");
INSERT INTO ted_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","'Nɩɩ 'a mʋ 'nɩ le, 'bɔ yɛ ke, blablɛɛ ‑do ꞊nʋ a ‑tɩ, 'a plɔ di 'nɩ ble, ɛ 'mʋ 'o blablɔ a (99) ‑wlɩɩ ‑hɛn ꞊tu 'o ‑pu ꞊tu 'o seledo ꞊nʋ, ‑ɔ 'de 'wan 'mʋ ‑hi. ");
INSERT INTO ted_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Dɛɛ ‑do, nɛ‑ɛ nɩ, 'ke 'o 'a nɩ Bu Nyɩsʋa ‑wɔn, ‑ɔ nɩ 'le yakɔ 'mʋ, ‑ɛ nue, ɔ 'nɩ ‑hʋɛ ꞊le, 'a nahuin ꞊nʋ, ‑ʋ 'de nahuin gblakɩ, 'a nahuoon ‑do bɔ 'wan.» ");
INSERT INTO ted_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","(‑Ye kɛ ‑Yusuu lele po, ɔ nɔ:) «‑N 'be Nyɩsʋa a nahuon 'bɔ nu ‑mʋ dɛ 'klan 'mʋ, mu ‑bo lo, a 'mʋ ye bii, ꞊muo le, ‑ɛ mɔ, dɛ ꞊nʋ, ɔ nu, ɛ nyre lɛ 'yi. 'Bɩa 'bɔ wɛɛn ke, ‑ɛ mɔ, ɔ nu dɛ 'kuku, ‑ye ‑n nue nɩ, 'ɔ ‑hɛ lele ‑na 'dɩayu. ");
INSERT INTO ted_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kɛɛ, 'bɩa 'bɔ 'die ke wɛɛn, ‑ɛ mɔ, ɔ nu dɛ 'kuku, mu ‑bo da nahuoon ‑do, ‑hee' nahuiin 'hɔn, bʋ bi ‑mʋ ke. 'Ɛ mɔ ‑tɛɛ, Nyɩsʋacrɩɩnɩɛ, ɛ nyi 'nɩ ꞊tu, 'plɩɩ a 'mʋ nahuon ‑tɩ mu yɛɛ, ɛɛ ‑hʋa ‑hɛhɩpʋʋ 'hɔn, ta. ");
INSERT INTO ted_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kɛɛ, 'bɩa 'bɔ 'die lele ke wɛɛn, ‑ɛ mɔ, ɔ nu dɛ 'kuku, ‑ye ‑bo le 'cʋɛ a nahuin. 'Bɩa 'bɔ 'die lele ke wɛɛn, 'ke 'o 'cʋɛ a nahuin a ‑gbɛ ye, ‑ɛ mɔ, ɔ nu dɛ 'kuku, ‑ye 'ke 'le ‑mʋ 'yi 'mʋ, bɔ 'ya hɩnyɔ 'mʋ, ‑hee' nahuon ꞊nʋ, ‑ɔ 'de Nyɩsʋa yi.» ");
INSERT INTO ted_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","(‑Ye kɛ ‑Yusuu lele po, ɔ nɔ:) «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ‑tɔplɩ 'bii ꞊nʋ, a di nahuin le, ʋ nɩ nu 'le, Nyɩsʋa, ɔ di ‑wɛ 'nɩ ꞊tu. Kɔ, ‑tɔplɩ 'bii ꞊nʋ, a di ke wɛɛn, 'ke nahuin bʋ nu, Nyɩsʋa, ɔ di ‑wɛ ke 'nɩ wɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","'Nɩɩ 'a mʋ 'nɩ le, nahuiin 'hɔn, 'ke 'le 'a mʋ ‑hɛyri, 'bʋ wɛɛn ke, 'bʋ da Nyɩsʋa, 'bʋ ‑hʋɔ 'ɛ nɩ dɛ ꞊de, 'na Bu Nyɩsʋa a ‑gbɛ, ɔ die ꞊nʋ 'nɩ ‑nyi, ");
INSERT INTO ted_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","‑ɛ nue, nahuiin 'hɔn, ta, 'bʋ 'kukue lɛ, 'ke 'le 'na 'dʋ 'kwli 'mʋ, 'ke 'n nɩ 'le ꞊nʋ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye Piɛlɩ 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, 'ɔ ꞊gbɔ wlɔn, ɔ nɔ: «Kʋkɔnyɔ o, 'n 'be Nyɩsʋa a nahuon, 'bɔ 'cipi 'o, 'bɔɔ 'mʋ dɛ 'kuku 'mʋ nu, 'wɩɩ ‑tie ꞊bo ‑hri 'a dɛ 'kuku a ‑gbɛ a ‑tɩ ‑wɔn 'le? ꞊Be ꞊bo nu 'a dɛ 'kuku a ‑tɩ a ‑wɔn‑hriiwɩɩ 'nɩpata?» ");
INSERT INTO ted_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","‑Ye ɔ nɔ: «'Nɩ po ꞊le lɛ, ‑bo nu 'a dɛ 'kuku a ‑tɩ a ‑wɔn‑hriiwɩɩ 'nɩpata, kɛɛ, ɛ 'de gbopuelɛ kɔ. 'Ɛ nɩ ti, ‑hri 'a dɛ 'kuku a ‑tɩ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «‑Tɛ Nyɩsʋa nu nahuin a win a kekɔɔlɛ, dɛ, ɛ 'we ye, nɛ‑ ‑gbo: 'Blʋgba a 'kɩɩn ꞊de, nɔ‑ da 'a ‑kʋannunyʋ gblakɩ, ɔ 'mʋ 'wli ꞊nʋ ‑hre, ʋ kɔ bʋ 'pɛɛ ꞊nɔ. ");
INSERT INTO ted_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","‑Tɛ ɔ ꞊tu 'klɛɛ 'wli a ‑gbɛ a ‑hihre ‑wlu, ‑ye ʋ ya ꞊nɔ ye 'a ‑kʋannunyɔ ‑ye. 'Wli ꞊nʋ, ɔ 'ble kwa, ɩ ‑wɛ 'le 'wliblɛ 'plɔplɔ. ");
INSERT INTO ted_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kɛɛ, ɔ 'de 'le 'wlidʋ a ‑gbɛ a 'pɛɛlɛ ‑wɛ. ‑Ye 'kɩɩn a ‑gbɛ, ɔ le 'a nahuin ‑ye, ɔ nɔ: Ba gba nahuon ‑gbo, ɔ kɔ 'a nyrɔ, kɔ 'a 'yuo꞊pli 'hɛɛn, ba plu, ‑ɛ 'we ꞊nɔ ꞊go ye, kɔ, ba plo ‑wɛ 'a kʋkɔ‑tɔplɩ 'bii, ‑ɛ die nu, ɔ 'mʋ gba ꞊nʋ 'pɛɛ. ");
INSERT INTO ted_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","‑Ye ‑kʋannunyɔ a ‑gbɛ, ɔ blɔ ye gbo kwlɩ, ɔ nɔ: 'N 'ble ‑na bʋ kwa, 'nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, kɔ ꞊wlʋ a 'lɩla. 'N di ‑na gba 'bii 'nɩ 'pɛɛ. ");
INSERT INTO ted_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","‑Ye 'kɩɩn a ‑gbɛ, ɔ 'ye 'a wɔlɩ, ɔ nɔ: ꞊Betɩ ‑n 'dio 'pɛɛ, 'n tɛ ‑mʋ gbo, mu. ");
INSERT INTO ted_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‑Tɛ ɔ ‑hɔn 'o ꞊nɔ ye 'mʋ, ɔɔ mu, ‑ye ɔ yɛ 'o gbo 'a 'be ‑kʋannunyɔ ‑ye. 'A 'be a ‑gbɛ, ɔ yɛ 'o gbo, ɔ 'ble kwa 'a gba 'cicrɛ. Nɛ‑ mɔ, nahuon ꞊nʋ, 'kɩɩn tɛ gbo, bɔ klɩ 'a 'be a ‑gbɛ a mranɩ, 'ɔ nyi lɛ mɩa, ɔ nɔ: 'Na gba, 'n kɔ 'le ‑mʋ ‑wɔn, ‑nyo 'mʋ! ");
INSERT INTO ted_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","'a 'be ꞊nʋ, 'ɔ blɔ kwlɩ ye gbo, ɔ nɔ: 'N 'ble ‑na bʋ kwa, 'nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, kɔ ꞊wlʋ a 'lɩla. 'N di ‑na gba 'nɩ 'pɛɛ. ");
INSERT INTO ted_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kɛɛ ‑ye ɔ bla nɩ, 'ɔ nue, 'ʋ po 'a 'be a ‑gbɛ ꞊jɩ 'mʋ, ‑ɛ die nu, ɔ 'mʋ 'le nɩ, ɔ 'mʋ 'a gba ꞊nʋ 'pɛɛ, 'plɩɩ ʋ 'muo gbo tɛ. ");
INSERT INTO ted_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","‑Tɛ 'a 'bie ‑kʋannunyʋ ‑ye 'ye dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, ‑ye 'waa ꞊wlɩ 'mʋɛ gbo 'dɔ, 'ʋ mu, 'ʋ na 'kɩɩn a ‑gbɛ ‑tɔplɩ 'bii ꞊nʋ ‑wɔn lɛ, ‑ɩ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","‑Ye 'kɩɩn a ‑gbɛ, ɔ da nahuon a ‑gbɛ nɩ, ɔ nɔ: ‑Kʋannunyɔ o, ‑n kɔ 'crɛ, gba 'bii ꞊nʋ, 'n kɔ wɛn 'le ‑mʋ ‑wɔn, 'n nɔ 'nɩ, ꞊betɩ ‑n 'dio 'pɛɛ, 'nɩ tɛ ‑mʋ gbo, ‑ɛ nue, ‑n 'batɩ 'mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","‑Tɛ 'n nu, 'nɩ 'ye ‑na wɔlɩ, kɛ'ɛ nɩ, ‑n kɔ ‑bo nu wɛn ‑n 'be ꞊nʋ a wɔlɩ a 'yiye. ");
INSERT INTO ted_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɛ nue, 'kɩɩn a ‑gbɛ 'ɔ bi yrʋ 'mʋ 'dɔ, 'ɔ le 'a nahuin, ɔ nɔ: Ba puo ꞊jɩ 'mʋ, ʋ 'muo ꞊sʋɛ ꞊tue, ‑ɛ die nu, ɔ 'mʋ 'le nɩ, ɔ 'mʋ 'a gba 'bii ꞊nʋ 'pɛɛ, 'plɩɩ 'muo gbo tɛ.» ");
INSERT INTO ted_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «Kɛ'ɛ nɩ, 'na Bu ꞊nʋ, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ di 'a nɩ 'yiye nu. ‑Tɔplɩ ꞊nʋ, 'a nɩ 'bienʋ Nyɩsʋa a nahuin nu 'a mʋ 'mʋ, 'bɩa 'ba 'nɩnɩ ‑hri ‑tɔplɩ a ‑gbɛ a ‑tɩ ‑wɔn, 'ke 'le 'a nɩ ꞊wlɩ 'bii ke, ‑tɛ 'kɩɩn a ‑gbɛ, ɔ nu nahuon ꞊nʋ a ꞊tɔ, kɛ'ɛ nɩ, Nyɩsʋa di ‑wɛ 'a nɩ ꞊tɔ nu.» ");
INSERT INTO ted_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","‑Tɛ ‑Yusu ‑wɔ tɔɔlɛ a ‑gbɛ ‑wɔn, ‑ye ɔ ‑hɔn 'le Galileblʋgba 'mʋ nɩ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ʋ mu 'le Sudeblʋgba 'mʋ, 'ke 'le Sudɛn a 'nike, ");
INSERT INTO ted_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","nahuin 'plɔplɔ 'ʋʋ ‑Yusu ‑wɔn kʋɛ, kɩklanyʋ 'bʋ nɩ 'o, 'ɔɔ 'waa 'kʋɛi ‑wɔ. ");
INSERT INTO ted_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","‑Ye Falisi꞊tumu a nahuin, ‑ʋ nɩ 'o, nʋ‑ 'yɩya 'o ꞊nɔ ye gbo, ‑ɛ die nu, ʋ 'muo 'mʋ lɛ ꞊tɔ, 'ke ɔ 'mʋ ka, 'ke 'o Nyɩsʋa ye. Kɛ ʋʋ 'klɛɛ po, 'ʋ nyo wlɔn ꞊gba: «꞊Be Nyɩsʋa a tetei, ɩ nyi 'nɩ ꞊tu, ‑ɛ mɔ, nyɩbɛyu kɔ 'hru, 'ke bɔ po 'le 'a nyrʋgba ‑patʋ 'mʋ, 'ke 'o 'ɛ nɩ dɛ ꞊de a ‑ta 'mʋ?» ");
INSERT INTO ted_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'N pui ‑tɛɛ, a ‑hre nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ, 'klɔ a ‑wlu꞊tuulɛ 'mʋ, ‑tɛ Nyɩsʋaa ‑tʋnahuon nu, ‑ye ɔ nue nɩ, ‑tʋnahuon a ‑gbɛ 'ɔ 'ya nyɩbɛyu kɔ nyrɔ 'hɛɛn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ɛ nɛ‑ nue, nyɩbɛyu 'mʋ 'o 'a bu kɔ 'a 'dii 'hɛɛn gbo hie, ɔ 'mʋ nyrɔ kɔ, ɔ kɔ ꞊nɔ 'hɛɛn, ʋ 'mʋ 'hʋɩn 'mʋ nɩnɩ, ʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ 'mʋ ‑tʋnahuoon ‑do ‑hɛ. ");
INSERT INTO ted_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ɛ ꞊hɛn 'nyrɛ, ʋ 'de 'klɛɛ lele ‑tʋnahuiin 'hɔn, kɛɛ, ʋ mɔ ‑tʋnahuoon ‑doo nɩ. 'A ‑tɩ o, nyɩbɛyu kɔ 'a nyrɔ 'hɛɛn, Nyɩsʋa nu, 'ʋ ‑hɛ ‑tʋnahuoon ‑do, nahuon ꞊de 'de ye blɛ, bɔ ‑hɩhɩʋ yrɛ.» Kɛ'ɛ nɩ, ‑Yusu po ꞊nʋ ye. ");
INSERT INTO ted_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","‑Ye Falisi꞊tumu a nahuin ꞊tuo ‑wɔn, ʋ nɔ: «Dɛ‑ nue 'klɛɛ, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise 'ɔ ꞊tui la, 'ke 'le 'a tetei 'kwli 'mʋ, ‑ɛ mɔ, nyɩbɛyu 'bɔɔ ‑hʋa bɔ po 'le 'a nyrɔ ‑patʋ 'mʋ, ‑ye bɔ ‑nyo 'crɩɩnɩɛ, ‑ɛ nyi ꞊tu, ‑ɛ mɔ, ɔ puo 'le 'mʋ ‑patʋ?» ");
INSERT INTO ted_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","‑Ye ‑Yusu nɔ: «'A nɩ ꞊wlɩ a 'mʋ'gboklolɛ a ‑tɩɩ nɩ, Moise 'ɔ ‑nyi 'a mʋ 'hru, 'ke ba po 'le 'a nɩ nyrʋ ‑patʋ 'mʋ lɛ. Kɛɛ, 'klɔ a ‑wlu꞊tuulɛ 'mʋ, ɛ 'de la lɛ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","'Nɩɩ 'a mʋ 'nɩ le, nyrʋgba 'bɔ 'de 'o 'a tɔ gbo hie, 'plɩɩ 'a tɔ 'bɔ puo 'le ‑patʋ 'mʋ, 'plɩɩ 'bɔ kɔ nyrɔ ‑ye, ‑ye ɔ nu ‑wlawli, 'ke 'o 'a ye‑hɛnyrɔ ye.» ");
INSERT INTO ted_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","‑Ye 'a ‑naagbopʋ nyo 'klɛɛ 'nɩ le, ʋ nɔ: «'Bɩa 'bɛ nɩ lɛ 'mʋ, 'ke 'o nyɩbɛyu kɔ 'a nyrɔ 'hɛɛn ‑wɔn, ‑ye ɛ nu ‑tɛɛ, 'ke ʋ nɩ kʋkɔ 'le.» ");
INSERT INTO ted_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Ɛ 'de nahuin 'bii, ʋ 'deɛ bʋ 'ble ‑tɩ a ‑gbɛ kwa. Nahuiin ‑do ꞊nʋ, Nyɩsʋa ‑nyi 'klɩ, nʋ‑ʋ ‑tɩ a ‑gbɛ 'mʋ lɛ yrii. ");
INSERT INTO ted_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ɛ kɔ 'dai ‑tɔplɩ, 'ɩ nye nu, nyɩbɛpʋ 'ʋ 'nɩnɩ kɔ nyrʋ: ꞊ʋ ‑ye nɩ 'o, 'ʋ 'de 'yuokɔdɛ, ꞊ʋ ‑ye nɩ 'o, 'ʋ ‑hɩʋ bɔtɔ, ꞊ʋ ‑ye 'nɩ kɔ ꞊le nyrʋ, ‑ɛ die nu, ʋ 'mʋ Nyɩsʋa a ‑kʋaan ‑do nu, Nyɩsʋa a ‑gbɛ, ɔ 'mʋ nahuin win ke kɔɔ. 'A ‑tɩ, nahuon ‑gbo, ‑ɔ ‑wɛ 'le ‑tɩ a ‑gbɛ a kwa'buble, nɔ‑ ‑bɔ 'bli kwa!» ");
INSERT INTO ted_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","‑Nyrɔwɔ ꞊de 'mʋ, ʋ gba 'le ‑Yusu ye 'yuo꞊pli, ɔ 'mu dabʋɩ 'lu gblɛ po, ɔ 'mʋ Nyɩsʋa da, ‑ɛ die nu, Nyɩsʋa 'mʋ 'yuo꞊pli a ‑gbɛ ꞊hapʋdɛ 'mʋ nu. Kɛɛ ‑ye ‑naagbopʋ, ʋʋ nahuin ꞊nʋ ꞊hɛn 'nyrɛ, ‑ʋ ya 'le 'yuo꞊pli, ʋ nɔ: «A nɩ yʋ 'le ꞊nɔ ye!» ");
INSERT INTO ted_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kɛɛ ‑ye ‑Yusu nɔ: «Ba ‑ha 'yuo꞊pli mɛ lɛ, bʋ di nɔ 'mʋ ye. A nɩ kʋ 'le ye, ‑ɛ nue, nahuin ꞊nʋ, ‑ʋ 'we ꞊nɔ 'yuo꞊pli ‑gbo ye, nʋ‑ di 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ pa,» ");
INSERT INTO ted_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","'ɔ nyu dabʋɩ 'lu gblɛ po, 'ɔɔ Nyɩsʋa da, 'ke bɔ nu ꞊nʋ ꞊hapʋdɛ 'mʋ. Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ɔ ‑hɔn 'le ‑tɛgbi a ‑gbɛ 'mʋ nɩ, 'ɔ mu. ");
INSERT INTO ted_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","'Wɔ ꞊de 'mʋ, gblotayu ꞊de, nɔ‑ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, 'ɔ ꞊gbɔ wlɔn, ɔ nɔ: «Tɔɔnyɔ o, ꞊hapʋdɛ tio‑ 'n di nu 'le, 'plɩɩ 'mʋ Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le 'le?» ");
INSERT INTO ted_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","‑Ye ‑Yusu nɔ: «Dɛ‑ kɔ ‑tɩ ꞊nɩɩ 'mʋ wlɔn ꞊gba, 'ke 'o ꞊hapʋdɛ a ‑ta 'mʋ? Nyɩsʋaa ‑do, nɔ‑ mɔ ꞊hapʋnahuon. 'Bɩa ꞊nɩ nye ‑hʋa, 'ke Nyɩsʋa bɔ ‑nyi ‑mʋ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, ‑ye ‑bo ꞊tuu 'o Nyɩsʋa a tetei 'o!» ");
INSERT INTO ted_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","‑Ye ɔ ꞊gbɔ wlɔn, ɔ nɔ: «Tetei tio‑ 'n di 'o ꞊tuu 'le?» ‑Ye ‑Yusu nɔ: «꞊Nɩ 'la 'le nahuon, ꞊nɩ nu 'le ‑wlawli, ꞊nɩ 'yri 'le, ꞊nɩ po 'le nahuon hɩ ke, ");
INSERT INTO ted_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","꞊tuu 'o ‑n bu kɔ ‑n 'dii 'hɛɛn, 'ke 'le 'mʋnʋɛlɛ 'kwli 'mʋ, nʋɛ ‑n 'be ‑tʋnahuon 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n nu ‑n dɩɔnʋ a 'mʋnʋɛlɛ.» ");
INSERT INTO ted_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","‑Ye gblotayu a ‑gbɛ, ɔ ꞊tuo ‑wɔn, ɔ nɔ: «'N ꞊tuu 'o tetei 'bii a ‑gbɛ nɩ. Dɛ tio‑ ‑ɛ hie 'o lele 'mʋ?» ");
INSERT INTO ted_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","‑Ye kɛ ‑Yusuu ꞊nɔ ye po, ɔ nɔ: «'Bɩa ꞊nɩɩ ‑hʋa ‑bo ꞊cɛɛ 'o ye, mu ‑bo plo ‑na kʋkɔ‑tɔplɩ, ‑bo ‑nye 'a 'wliyɛ ꞊sʋɛnyʋ lɛ, ‑ye Nyɩsʋa, nɔ‑ di ‑mʋ ꞊hapʋdɛ gblaka 'mʋ nu, 'ke 'le yakɔ 'mʋ. ꞊Nɩ nue 'klɛɛ, ‑ye ‑bo kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'na ‑naagbopʋyu ‑hɛ.» ");
INSERT INTO ted_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Gblotayu ‑mɛ ‑ye, bɔ 'wɔn ‑tɩ ꞊nʋ ‑Yusu ꞊tu, ‑ye 'a ꞊wlʋ bi ꞊hlɔn, 'ɔ ‑hɔn 'o ꞊nɔ 'hʋɩn 'mʋ, ‑ɛ nue, 'a kʋkɔ‑tɔplɩ ‑huo 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","‑Tɛ ɔ mu 'klɛɛ, ‑ye kɛ ‑Yusuu 'a ‑naagbopʋ ye po, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le, ɛ kla wlɔn, 'ke 'o dɛkɔnyɔ ‑wɔn, 'ke bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","'Ɛ mɔ ‑tɛɛ, ɛ kla wlɔn, 'ke 'o dɛkɔnyɔ ‑wɔn, ‑ɔ kuo 'a kʋkɔ‑tɔplɩ ꞊wlʋ ye, 'ke bɔ kuo Nyɩsʋa ꞊wlʋ ye, 'ke bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, 'ɛ ‑hi 'o ꞊gbuke‑so 'mʋ, 'ke bɔ naa 'le 'die a 'hʋɔ wlɔn.» ");
INSERT INTO ted_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","‑Yusu a pupowin a ‑gbɛ, ɩ ma 'a ‑naagbopʋ lɛ wlɔn 'dɔ. ‑Ye ʋ nɔ: «'Bɛ kɔ bɛ ‑ti lɛ 'mʋ, nahuon ꞊de 'die 'le ‑wɛ bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","‑Ye ‑Yusu nyu 'nɩ 'ye, ɔ nɔ: «Ɛ 'die 'le ‑wɛ, 'ke 'le ‑tʋnahuon a 'klɩ 'kwli 'mʋ, bɔ kuo Nyɩsʋa ꞊wlʋ ye, ɔ 'mʋ 'le 'a 'klɔ yrayrʋ 'kwli 'mʋ pa. Kɛɛ, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ, 'ɛ nɩ dɛ, ɛ ‑wɛ 'le ꞊le.» ");
INSERT INTO ted_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","‑Ye kɛ Piɛlɩɩ ‑Yusu ye po: «‑A ‑mɛ ‑ye 'le? 'Ye kɛ, ‑a hie 'o ‑a nɩ nahuin gbo, ɛ kɔ ‑a nɩ ‑tɔplɩ 'bii 'hɛɛn, ꞊aa ‑mʋ ‑wɔn naa. 'A ‑tɩ, dɛ tio‑ Nyɩsʋa di ‑a mʋ ‑nyi 'le?» ");
INSERT INTO ted_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ti ꞊nʋ ‑kɔ 'yri, 'n di 'o 'na bodɩɔgbata ꞊nʋ ke gbo nɩ, 'ke 'le 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ, ti a ‑gbɛ 'yri, 'a mʋ ꞊nʋ, ‑ʋ mɔ 'na ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ, 'ke a di ‑wɛ 'o 'a nɩ gbatɩ ke gblɛ nɩ, ‑ɛ die nu, a 'mʋ Yisraɛkʋɛ a ꞊tugbɩ ‑pu ꞊tu 'o 'hɔn ꞊nʋ ‑bati lɛ poo. ");
INSERT INTO ted_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kɔ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ hie 'o 'a kayuo gbo, kɔ 'a ‑dɩayuo, kɔ 'a bu kɔ 'a 'dii, kɔ 'a nyrʋgba, kɔ 'a 'yuo꞊pli, kɔ 'a ‑cii 'hɛɛn, 'na 'mʋnʋɛlɛ a ‑tɩ, ‑ye nahuon a ‑gbɛ, ‑tɔplɩ, Nyɩsʋa di ꞊nɔ ‑nyi, ɩ di 'nɩ ‑huo bʋbakɔ, ɩ 'mʋ 'o dɛ ꞊nʋ, ɔ hie 'o gbo 'mʋ ‑hi, Nyɩsʋa 'muo ‑wɛ 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kɛɛ, nahuin ꞊nʋ, ‑ʋ nɩ 'o 'waa 'bienʋ 'lu ye, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'waa 'plɔplɔ, nʋ‑ di ‑tado 'le 'waa 'bienʋ bʋ gbo nɩ, kɔ, nahuin ꞊nʋ, ‑ʋ nɩ 'le 'waa 'bienʋ bʋ gbo, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'waa 'plɔplɔ, nʋ‑ di ‑tado 'o 'waa 'bienʋ 'lu ye nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","(‑Ye ‑Yusu po ‑talʋdʋ ‑ye, ɔ nɔ:) «Nyɩsʋa 'bɔ kɔɔ nahuin win ke, dɛ, ɛ 'we ye, ɛ nɛ‑ ‑gbo: 'Dɩdɔnyɔ gblaka ꞊de, nɔ‑ 'hrɩ ‑nyrajruwɔ ꞊de 'mʋ, 'ɔ mu ‑kʋannunyʋ lɛ ꞊mɔ wɔn, ‑ɛ die nu, ʋ 'mʋ 'a ‑kʋan nu, 'ke 'le 'a ‑ci ke. ");
INSERT INTO ted_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","‑Tɛ ɔ yɛ 'o ye‑hɛnahuin gbo, ‑ye ɔ kɔ ꞊nʋ 'hɛɛn, ʋ ‑yrɩ nɩ, 'ke bɔ 'pɛɛ ꞊nʋ ‑nyrɔwɔ꞊gble a 'wliyɛ, 'ɔ lu, 'ke bʋ mu 'a ‑kʋan nu, 'ke 'le 'a ‑ci ke. ");
INSERT INTO ted_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Muu 'o 'yrʋ a 'o'yaalɛ a ti 'yri, ‑ye ɔ 'hrɩ lele nɩ, 'ɔ mu 'le lele ‑tɛgbi ꞊nʋ, nahuin ꞊nʋ, ‑ʋʋ ‑kʋan lɛ ꞊mɔ, ʋʋ 'o gblɛ nɩ, 'ɔ yɛ 'o nahuin ‑ye gbo, ‑ʋ 'nɩnɩ nu ‑kʋan ꞊de. ");
INSERT INTO ted_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‑Ye ɔ nɔ: Ba mu ‑wɛ 'le 'na ‑ci ke, a 'mʋ 'na ‑kʋan nu. 'Wliyɛ ꞊nʋ, ‑ɛ blɛ 'a mʋ ye, 'n die 'a mʋ 'nɩ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","‑Ye ʋ mu 'le ꞊le. Muu 'o 'yrʋ a gbonyrati 'yri, ‑ye ɔ 'hrɩ lele nɩ, 'ɔ mu ‑kʋannunyʋ ‑ye lɛ ꞊mɔ wɔn. Dɛɛ ‑do a ‑gbɛ, nɛ‑ ɔ nu 'yrʋ‑hiilɛ a ti 'yri. ");
INSERT INTO ted_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","‑Tɛ ɛ hie 'klɛɛ 'le ‑hawɔɔ ‑do, 'plɩɩ nahuin 'mʋ ‑kʋan gbo nyra, ‑ye ɔ 'hrɩ lele nɩ, 'ɔ mu 'le ‑tɛgbi ꞊nʋ, nahuin ꞊nʋ, ‑ʋʋ ‑kʋan lɛ ꞊mɔ, ʋʋ 'o gblɛ nɩ, 'ɔ yɛ 'o lele nahuin ‑ye gbo. Ɔ nɔ: Dɛ‑ kɔ ‑nyrɔwɔ ꞊gbu ‑gbo, aa mɔ ‑hi, 'a 'nɩnɩ nu ‑kʋan ꞊de 'le? ");
INSERT INTO ted_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: ꞊Ɔ ꞊de 'de ‑a mʋ ‑kʋan ke po a ‑tɩɩ nɩ. ‑Ye ɔ nɔ: 'Bɛ nɩ lɛ 'mʋ, ba mu ‑wɛ 'le 'na ‑ci ke, a 'mʋ 'na ‑kʋan nu. ");
INSERT INTO ted_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","'Yrʋ bʋʋ 'le yakɔ 'mʋ lɛ ‑wɛ, ‑ye ‑cikɔnyɔ da 'a ‑kʋannunyʋ a nyɩgblaka nɩ, ɔ nɔ: Da ‑kʋannunyʋ 'bii, ꞊mu 'pɛɛ. Ye‑hɛnahuin, ‑bo 'pɛɛ, nʋ‑ mɔ nahuin ꞊nʋ, ‑ʋ 'bɔɔ 'le lɛ, 'n po ‑kʋan ke. Nɛ‑ ‑bo nu ‑nunu, ‑bo yɛ ye‑hɛnahuin ke, 'n po ‑kʋan ke. ");
INSERT INTO ted_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nahuin ꞊nʋ, ‑ʋ nu ‑hawɔɔ ‑do a ‑kʋan, ‑tɛ ʋ di 'le, ‑ye ʋ 'ye ‑nyrɔwɔ꞊gble a 'wliyɛ. ");
INSERT INTO ted_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","‑Tɛ nahuin ꞊nʋ, ‑ʋ mɔ ye‑hɛnahuin, ʋ po wɛn ‑kʋan ke, ʋ 'ye dɛ ꞊nʋ, ‑ɛɛ 'lu ‑wɔn mue, ‑ye ʋ ‑mɛ ‑ye, ʋ nɔ 'nɩ, 'waa 'wliyɛ di 'nɩ ‑huo, ɛ 'mʋ 'o 'waa 'bienʋ a nɛnɛ 'mʋ ‑hi. Kɛɛ, ʋ ‑nyi ‑wɛ ꞊nʋ ‑nyrɔwɔ꞊gble a 'wliyɛ. ");
INSERT INTO ted_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","‑Tɛ ʋ ‑nyi ꞊nʋ 'wliyɛ a ‑gbɛ, ‑ye ʋʋ ‑cikɔnyɔ lɛ poo yrʋ, ");
INSERT INTO ted_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ʋ nɔ: Nahuin ꞊nʋ, ‑ʋ 'bɔɔ 'le lɛ, ‑ʋ nu ‑hawɔɔ ‑do a ‑kʋan, kɔ ‑a mʋ ‑gbo, ‑ʋ 'ye ꞊sʋɛ, ‑nyrɔwɔ ꞊gbu ‑gbo 'mʋ, 'yrʋ nu kɛ lɛ, ʋ hʋan kɛ ye, ʋ kɔ ‑a mʋ 'hɛɛn, 'wliyɛɛ ‑do, nɛ‑ ‑n 'pɛɛ ‑a mʋ. ");
INSERT INTO ted_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Kɛɛ ‑ye ‑cikɔnyɔ ꞊tu 'a nahuoon ‑do ‑wɔn, ɔ nɔ: 'Mɛ o, 'n 'de ‑mʋ kaa. ꞊Be ‑n kɔ 'mʋ 'hɛɛn, ‑a 'di wɛn ‑yra, 'ke ꞊bo 'pɛɛ ‑mʋ ‑nyrɔwɔ꞊gble a 'wliyɛ. ");
INSERT INTO ted_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","'A ‑tɩ o, gba ‑na 'wliyɛ, ‑bo mu. Nahuin ‑gbo, ‑ʋ 'bɔɔ 'le lɛ, 'n po ‑kʋan ke, 'wliyɛɛ ‑do ꞊nʋ, 'n ‑hʋa ꞊bo ‑nyi ꞊nʋ, ɛ ‑do a ‑gbɛ, nɛ‑ 'n ‑hʋa ꞊bo ‑nyi ‑wɛ ‑mʋ. ");
INSERT INTO ted_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","‑Tɛ 'nɩɩ 'na kʋkɔ‑tɔplɩ a naalɛ nu, 'mɔ kʋɩ 'le ‑wɔn. ‑Hee', ꞊be ca ‑nɩɩ ꞊tu, ‑tɛ 'na ꞊wlʋ nɔ 'yi lɛ a ‑tɩ?» ");
INSERT INTO ted_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","‑Ye ‑Yusu nɔ lele: «'A ‑tɩ o, nahuin ꞊nʋ, ‑ʋ nɩ 'le 'waa 'bienʋ bʋ gbo, nʋ‑ di ‑tado 'o 'waa 'bienʋ 'lu ye nɩ, kɔ, nahuin ꞊nʋ, ‑ʋ nɩ 'o 'waa 'bienʋ 'lu ye, nʋ‑ di ‑tado 'le 'waa 'bienʋ bʋ gbo nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","‑Tɛ ‑Yusu ‑yrɛ, ‑ye ɔ 'kɩɛ gbɛɛ 'hru 'lu ‑wɔn, 'ɔɔ 'le Jrusrɛdɩɔ 'mʋ mu, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. Bʋʋ 'klɛɛ 'hru na, ‑Yusu 'ɔ 'ba 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ 'mʋ, 'ʋ bii ye. Kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ba po 'mʋ nʋa ye gbo. ‑Aa 'mʋ mu Jrusrɛdɩɔ. 'Ke ʋ di 'le 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kwa po, kɔ teteitɔɔnyʋ 'hɛɛn. Ʋ di 'mʋ lɛ poo ‑bati, ʋ 'mʋ lɛ po, 'n nɩ 'mʋ 'kʋkʋɛ. ");
INSERT INTO ted_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","'Bɛ ‑hi, ʋ 'mʋ 'mʋ nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi kwa po, nahuin a ‑gbɛ, ʋ 'mʋ 'mʋ 'caa, kɔ, ʋ 'mʋ 'mʋ lɔkɔ bii, kɔ, ʋ 'mʋ 'o 'mʋ tu 'yie 'mʋ kɔɔ, ‑ɛ die nu, ʋ 'mʋ 'mʋ 'la. ‑Nyrɔwɩɩ 'hɔn 'bɩ ‑hi, ‑nyrɔwɔ a ta a nɔnɔ 'mʋ, 'plɩɩ Nyɩsʋa 'mʋ 'le 'mʋ 'kʋkʋnyʋ ‑hɛyri ‑ha, ɔ 'mʋ 'mʋ 'klɔ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye Sebede a nyrʋgba, ɔ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, ɔ kɔ 'a 'yuoo 'hɔn ꞊nʋ 'hɛɛn, ‑ʋ mɔ ‑Yusu a ‑naagbopʋ Sakɩ kɔ Saan 'hɛɛn, 'ɔ blɔ kwlɩ ye gbo, ‑ɛ die nu, ɔ 'muo dɛ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","‑Ye kɛ ‑Yusuu ꞊nɔ ye po, ɔ nɔ: «Dɛ tio‑ ‑nɩɩ ‑hʋa ꞊bo nu, 'ke 'o ‑mʋ ‑wɔn 'le?» ‑Ye ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Ti ꞊nʋ ‑kɔ 'yri ‑n di nahuin win ke kɔɔ, 'ke 'le Nyɩsʋa a gbonɩɩlɛ 'mʋ, 'n nye 'nɩ ‑hʋa, 'ke ‑bo wɛɛn ke, 'na 'yuoo 'hɔn ‑gbo, bʋ nɩ 'o ‑mʋ 'hʋɩn 'mʋ gbo, ‑do 'ke 'le ‑na diidɛpɩa ke, ‑do ‑ye 'ke 'le ‑na kamrapɩa ke.» ");
INSERT INTO ted_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kɛɛ ‑ye ‑Yusu nɔ: «Dɛ aa ‑hʋa, dɛ bɛ ꞊hɛn 'nyrɛ, a 'die yi. ꞊Be a ‑wɛ 'le ba 'ye ꞊sʋɛdʋ ꞊nʋ nɩ, 'n di 'ye?» ‑Ye ʋ nɔ: «‑A ‑wɛ 'le ꞊le.» ");
INSERT INTO ted_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","‑Ye ɔ nɔ: «'Ɛ mɔ ‑tɛɛ, ꞊sʋɛdʋ ꞊nʋ, 'n di 'ye, a 'mue 'ye. Kɛɛ ‑ye ɛ 'de 'mɔ, 'n 'die 'le ‑wɔn kɔ, 'ke ꞊bo ꞊tui, nahuin tio‑ di 'le 'na diidɛpɩa kɔ 'na kamrapɩa 'hɛɛn ke gbo nɩ. 'N Bu Nyɩsʋa, nɔ‑ di nahuin a ‑gbɛ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","‑Tɛ ‑naagbopʋʋ ‑pu ‑ye ꞊nʋ, ʋ 'wɔn ‑tɩ ꞊nʋ, 'dɩayuoo 'hɔn ꞊nʋ, ʋ ꞊tu ‑Yusu ye, ‑ye ʋ nyu lɛ poo yrʋ. ");
INSERT INTO ted_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","‑Ye ‑Yusu da ʋ 'bii nɩ, ɔ nɔ: «A yie nɩ, ‑ɛ mɔ, 'klɔ ‑gbo a 'luyenɩnyʋ, ‑ʋʋ 'waa dakʋ naa, ʋ nyu ꞊tue ꞊sʋɛ, 'ʋ nyu 'mʋ 'plɔ. 'Waa 'kɩɩndɛ a ‑gbɛ, ʋ nye 'le 'kwli 'mʋ nuu 'crɛ. ");
INSERT INTO ted_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","A ‑mɛ ‑ye, 'ke 'le 'a mʋ ‑hɛyri, ɛ 'deɛ bɛ ‑ti lɛ 'mʋ. 'Ke 'le 'a mʋ ‑hɛyri, nahuon 'bɔɔ ‑hʋa bɔ 'ya 'a nɩ ye'mʋnaanyɔ 'mʋ, nahuon a ‑gbɛ, ɔ blɛ ye bɔ 'ya 'a nɩ 'mʋ‑hɛnyɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kɔ, 'ke 'le 'a mʋ ‑hɛyri, nahuon 'bɔɔ ‑hʋa bɔ 'ya 'a nɩ 'luyenɩnyɔ 'mʋ, nahuon a ‑gbɛ, ɔ blɛ ye bɔ ‑wɛ ‑wɔn, 'ke bɔ ‑hɛ 'a mʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","'Na ‑gbɛ, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n 'de 'le di, 'ke nahuin bʋ ‑hɛ 'mʋ 'mʋ, kɛɛ, 'n di 'le ꞊le, 'ke ꞊bo ‑hɛ nahuin 'mʋ, kɔ, ꞊bo ‑ha 'n dɩɔnʋ, 'mʋ 'kʋ, ‑ɛ die nu, 'na 'kʋkʋɛ a ‑gbɛ, ɛ 'mue nu, Nyɩsʋa 'mʋ nahuin 'plɔplɔ ꞊gbla, 'ke 'o 'waa dɛ 'kuku ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, 'ke ʋʋ 'le 'dɩɔ ꞊nʋ 'mʋ ‑hɔn, ‑ɔ mɔ Seliko. ‑Tɛ ʋʋ 'dɩɔ a ‑gbɛ 'mʋ ꞊tɩ, nahuin 'plɔplɔ, 'ʋ nyu ‑wɔn kʋɛ. ");
INSERT INTO ted_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","‑Ye 'ke 'o 'hru nʋa 'mʋ, 'ke 'yiisuanyʋʋ 'hɔn ꞊de nɩ 'o gbo. 'Yiisuanyʋ a ‑gbɛ, ʋ 'wɩn nɩ, ‑ɛ mɔ, ‑Yusu'u nɩ, ‑ɔɔ ‑hi. ‑Ye ʋ 'yaa 'le win, ʋ nɔ: «Tɔɔnyɔ o, Dafidɩ a 'Yu, yrii ‑a mʋ wɔlɩ ye ‑o!» ");
INSERT INTO ted_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","‑Ye nahuin, ‑ʋ nɩ 'o, ʋ nyu ꞊hɛn 'nyrɛ, ʋ nɔ: «Ba ma wien mɔ!» Kɛɛ ‑ye ʋ bla nɩ, 'ʋ 'yaa 'le lele win, ʋ nɔ: «Dafidɩ a 'Yu, yrii ‑a mʋ wɔlɩ ye ‑o!» ");
INSERT INTO ted_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","‑Tɛ ‑Yusu 'wɔn 'waa win, ‑ye ɔ nyra gbo, 'ɔ dʋ. ‑Tɛ ʋ nyre 'klɛɛ 'o, ‑ye ‑Yusu ꞊gbʋ wlɔn, ɔ nɔ: «Dɛ tio‑ aa ‑hʋa, ꞊bo nu, 'ke 'o 'a mʋ ‑wɔn 'le?» ");
INSERT INTO ted_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","‑Ye ʋ nɔ: «Tɔɔnyɔ o, ‑a nye 'nɩ ‑hʋa, ‑bo nue, ‑a nɩ 'yii ‑gbo, ‑ɩɩ kla, bɩ klɛ ke!» ");
INSERT INTO ted_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","‑Ye ‑Yusu 'ye 'waa wɔlɩ, 'ɔ 'tʋ 'waa 'yii lɛ. Tii ‑do a ti 'yri, ‑ye ʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ ‑tʋa lɛyriilɛ gbo, 'ʋ bi 'o ‑Yusu ke 'mʋ, 'ʋ nyo ‑wɔn kʋɛ. ");
INSERT INTO ted_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","‑Tɛ ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋʋ Jrusrɛdɩɔ 'mʋ mu, ‑ye 'ke ʋ nyre 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ kɔ 'dʋ mɔ Bɛtɩfase, 'ke 'o dʋgba ꞊nʋ ꞊hlɔn, ‑ɔ kɔ 'lu ti nɩ 'le, ʋʋ olifie daa, ‑Yusu 'ɔ le 'a ‑naagbopʋʋ 'hɔn. ");
INSERT INTO ted_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Kɛ ɔɔ ꞊nʋ ye po: «Ba mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ nɩ 'le 'a mʋ ye 'mʋ. 'Bɩa 'ba 'ya 'dɩɔ a ‑gbɛ 'mʋ, ‑ye a di 'o gbo yɛ 'kasra kɔ 'a 'yu 'hɛɛn, 'ʋ mʋɩ gbo. 'Bɩa 'ba yɩ 'o gbo, ‑ye ba ꞊wlɩɩ gbo, ba yɩ 'mʋ ye. ");
INSERT INTO ted_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nahuon ꞊de 'bɔ ꞊gba 'a mʋ wlɔn, ‑ye kɛ ba po: Kʋkɔnyɔ'ɔ nɩ, ‑ɔ nyi ‑hʋa. 'Bɩa 'ba ꞊tui, ‑ye tii ‑do a ti 'yri, ʋ di 'nɩ wɔn, a 'mui 'le ya.» ");
INSERT INTO ted_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dɛ a ‑gbɛ, ɛ mue ‑wɔn 'lu, ‑ɛ die nu, ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ ꞊tu la, ɩ 'mʋ nue. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«Kɛ ba po Siondɩɔ (‑ɔ mɔ Jrusrɛdɩɔ) a nahuin ye: Ba 'ye kɛ, 'a nɩ bodɩɔ, nɔ‑ɔ nɔ 'a mʋ ‑wɔn di. Ɔ ꞊tɩɔ 'le 'a dɩɔnʋ, 'ɔ 'ya 'o 'kasra ke, kɔ 'kasrayu 'hɛɛn.» ");
INSERT INTO ted_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","‑Tɛ ‑Yusu le 'a ‑naagbopʋʋ 'hɔn a ‑gbɛ, ‑ye ʋ mu nɩ, 'ʋ nu dɛ ꞊nʋ, ‑Yusu le ꞊nʋ, ");
INSERT INTO ted_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","'ʋ ya 'kasra kɔ 'a 'yu 'hɛɛn a ‑gbɛ ‑Yusu ye. ‑Tɛ ʋ yʋ 'le, 'ʋ po 'o 'waa danɩ kɔ wlawlɩ 'kasrɩ a ‑gbɛ ke gblɛ, ‑ɛ die nu, ‑Yusu 'bɔ 'yɩ 'o ke, ɔ 'mʋ danɩ a ‑gbɛ ke gbo nɩ. (‑Ɛ nue, ɔ nye nahuin 'nɩ tɔɔ, ‑ɛ mɔ, ɔ mɔ bodɩɔɔ nɩ, ‑ɔɔ 'le kegbowɛɛnlɛ ya, ɛ 'de tʋ, ɔ 'nɩ yʋ ꞊le 'le. Ɛ nɛ‑ kɔ ‑tɩ 'ɔ 'ya 'o 'kasrɩ a ‑gbɛ ke.) ");
INSERT INTO ted_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","‑Tɛ ʋʋ 'le di, nahuin 'plɔplɔ 'ʋ po 'o 'waa nɩ danɩ 'hru wlɔn gblɛ. ꞊Ʋ ‑ye nɩ 'o, 'ʋ 'bɛ 'kwla, 'ʋ puo 'o 'hru wlɔn gblɛ, ‑Yusu 'ɔ nyo ke na, ");
INSERT INTO ted_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","nahuin 'ʋ nyo ye 'mʋ naa, kɔ, ꞊ʋ ‑ye 'ʋ nyo ‑wɔn kʋɛ. Kɛ ʋʋ nu, 'ʋʋ 'le win 'yaa, ʋ nɔ: «‑Na 'wio, Dafidɩ a 'Yu, ‑mɔ ‑gbo, ‑ɔɔ 'le di, 'ke 'le Kʋkɔnyɔ Nyɩsʋa a 'dʋ 'kwli 'mʋ, Nyɩsʋa bɔ kɔ ‑tɩ a 'yi'bʋaalɛ, 'ke 'le yakɔ 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","‑Tɛ ‑Yusu 'ya 'klɛɛ Jrusrɛdɩɔ 'mʋ, ‑ye 'dɩɔɔ 'le 'nɩ mu, 'ɔɔ 'le di, 'ʋʋ wlɔn lɛ ꞊gbʋgba: «Nahuon tio‑ ɔ 'ya 'le?» ");
INSERT INTO ted_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","‑Ye nahuin nɔ: «Nɔ‑ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ ‑Yusu. 'Ke ɔ 'ti 'le Nasalɛtɩdɩɔ 'mʋ, 'ke 'le Galileblʋgba 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","‑Yusu ‑mɛ ‑ye, 'ke ɔ pa 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ. 'Ke 'le ‑yaa a ‑gbɛ 'mʋ, 'ke puplonyʋ nɩ 'le, 'ʋʋ 'wlugba‑tɔplɩ plo, 'ke 'o Nyɩsʋa a ‑cɔhlʋn a pipie ‑wɔn. 'Ke 'wli'cɩcɩnyʋ nɩ ‑wɛ 'o, 'ʋʋ pʋpʋwli 'cɩcɩ. ‑Tɛ ‑Yusu yɛ 'o puplonyʋ a ‑gbɛ gbo, ʋ kɔ nahuin ꞊nʋ 'hɛɛn, ‑ʋʋ ‑tɔplɩ ‑tɔ, ‑ye ɔ ‑tʋa 'waa lɛbʋbla gbo, 'ɔɔ 'wli'cɩcɩnyʋ a 'teblei ye gblɛ ꞊jri, kɔ, 'ɔɔ 'le ‑plijɩplonyʋ a gbatɩ yrɛ 'nyɩnyra. ");
INSERT INTO ted_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «Ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Nyɩsʋa nɔ 'nɩ: 'Na kayu nɩ 'o ꞊o, ‑ɛ die nu, nahuin, ʋ 'mʋ 'le 'mʋ daa.» Kɛ ‑Yusuu lele po, ɔ nɔ: «Kɛɛ ‑ye a ‑mɛ ‑ye, a nuu kayu a ‑gbɛ 'mʋ 'yrinyʋ a kayu.» ");
INSERT INTO ted_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tii ‑do a ‑gbɛ 'yri, ‑ye 'yiisuanyʋ, kɔ nɩanɩnyʋ 'hɛɛn, nʋ‑ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, ‑Yusu 'ɔ ‑wɔ 'waa 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ teteitɔɔnyʋ ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'ye 'ŋmilɛka‑tɔplɩ ꞊nʋ nɩ, ‑Yusu nu, 'ʋ 'wɔn ‑wɛ 'yuo꞊pli a win, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'yuo꞊pli a ‑gbɛ, 'ʋʋ 'le win 'yaa, 'ʋʋ lɛ po: «‑Na 'wio, Dafidɩ a 'Yu!» Nɛ‑ nue, nyɩgblakɩ a ‑gbɛ, 'ʋ bi yrʋ 'mʋ lɛ, ");
INSERT INTO ted_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","'ʋʋ ‑Yusu le, ʋ nɔ: «꞊Be ‑tɩ ꞊nʋ, ʋʋ ꞊tu, ‑n nyi 'nɩ 'wɔn?» ‑Ye ‑Yusu nɔ: «Iin, 'n nyi 'nɩ 'wɔn. 'N pui ‑tɛɛ, a ‑hre ‑tɩ ꞊nʋ nɩ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: Nyɩsʋa o, ‑n nue nɩ, 'yuo꞊pli, kɔ 'nyɩnyayuo, 'ʋʋ ‑wɛ ‑mʋ baa.» ");
INSERT INTO ted_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Bɔ po 'klɛɛ lɛ, ‑ye ɔ ‑hɔn 'o ꞊nʋ 'mʋ 'hʋɩn, 'ɔ mu 'le Betanidɩɔ 'mʋ. 'Kee nɩ, ɔ pɛɛ 'le. ");
INSERT INTO ted_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ‑Yusuu de 'nɩ ‑mɛ, 'ɔɔ Jrusrɛdɩɔ 'mʋ di, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. Bʋʋ 'klɛɛ 'le di, ‑ye kanʋ bi 'le ‑Yusu 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bɔ ta 'klɛɛ 'le ye 'mʋ lɛ, ‑ye ɔ 'ye tugbɛdʋ ‑ye, ʋʋ figie daa, 'ke 'o 'hru nʋa 'mʋ, 'ɔ mue 'o ꞊hlɔn, kɛɛ, haii ‑doo nɩ, ɔ 'yee 'le ꞊nɔ 'klɔ. ‑Ye kɛ ‑Yusuu tugbɛ a ‑gbɛ ye po: «Kʋɛ kɛ 'klɛɛ mɔ gbo, ꞊nɩ tʋ 'le 'klɛɛ lele 'kui ꞊de nɩ gbe!» Tii ‑do a ti 'yri, ‑ye tugbɛ a ‑gbɛ, ɛ 'kʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","‑Tɛ ‑Yusu a ‑naagbopʋ 'ye dɛ a ‑gbɛ, ‑ye ɩ saka ꞊nʋ nɩ 'dɔ, 'ʋ ꞊gba ‑Yusu wlɔn, ʋ nɔ: «Dɛ‑ nue 'klɛɛ, tii ‑do a ti 'yri, tugbɛ ‑gbo, 'ɛ 'kʋ 'le?» ");
INSERT INTO ted_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ: 'Bɩa 'ba kuo Nyɩsʋa ꞊wlʋ ye ‑tɛɛ, kɔ, 'ba 'nɩnɩ po gblɛ, ‑ye a ‑wɛ 'le ba nu dɛ ‑gbo nɩ, 'n nu tugbɛ ‑gbo 'mʋ. Ɛ 'de ɛ ‑do a ‑gbɛ. A ‑wɛ 'le ba le ‑wɛ dʋgba ‑gbo nɩ: ‑Hɔn mɔ ‑tɛgbi ‑gbo 'mʋ, bi 'le 'yru ‑wɔn! ‑ye dɛ a ‑gbɛ, ɛ di ‑wɔn mue 'lu. ");
INSERT INTO ted_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","'Bɩa 'baa Nyɩsʋa dɛ ‑hʋa, 'ba kue ꞊wlʋ ye, ‑ɛ mɔ, ɔ die 'a mʋ 'nɩ ‑nyi, ‑ye 'ɛ mɔ ‑tɛɛ, ɔ die 'a mʋ 'nɩ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye 'ke ‑Yusu mu 'le lele Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ɔ ‑tʋa nahuin Nyɩsʋa a ‑tɩ a tɔɔlɛ gbo. ‑Tɛ ɔɔ 'klɛɛ tɔɔ, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ ‑Juukʋɛ a 'blʋ a nahuin ‑ye 'hɛɛn, ʋ 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, ʋ nɔ: «Nyɔ‑ ‑nyi 'klɛɛ ‑mʋ 'klɩ, 'ke ‑bo bla ‑tɔplɩplonyʋ ‑gbo lɛ 'le? Nyɔ‑ le ‑mʋ, 'ke ‑bo nu ‑tɔplɩ 'bii ‑gbo, ‑nɩɩ nu 'le?» ");
INSERT INTO ted_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Na ‑gbɛ, 'n di ‑wɛ 'a mʋ wlɔn ꞊gba dɛ. 'Bɩa 'ba ‑hɩhɩɛ 'mʋ klɛ, ‑ye 'n di ‑wɛ 'a mʋ klɛ 'nɩ ‑hɩhɩa. ");
INSERT INTO ted_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","'A mʋ 'nɩɩ 'klɛɛ wlɔn ꞊gba: Nyɔ‑ le la Saan, 'ke bɔ po la nahuin 'nie 'lu lɛ 'le? ꞊Be Nyɩsʋa'a nɩ, ‑hee' ‑tʋnahuiin nɩ?» ‑Ye ʋʋ wlɔn lɛ 'nɩ ꞊gbʋgba: «‑Be' ‑a di 'klɛɛ po 'le? 'Bɩa ꞊ba plɛ: Nyɩsʋa'a nɩ, ‑ɔ lo la, ‑ye ɔ di ‑a mʋ wlɔn 'nɩ ꞊gba: ‑Tɩ ꞊nʋ, Saan, ɔɔ la ꞊tu, dɛ‑ nue, 'a 'di la ‑tɛɛ pue 'le? ");
INSERT INTO ted_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mɔ, 'bɩa ꞊ba plɛ, ‑tʋnahuiin nɩ, ‑ye nahuin di ‑a mʋ yɛɛ ‑tɩ, ‑ɛ nue, nahuin pui ‑tɛɛ, ‑ɛ mɔ, Saan, ɔ mɔ la Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Nɛ‑ nue, 'ʋ ꞊tu ‑Yusu ‑wɔn, ʋ nɔ: «‑A 'de 'a dɛ ꞊de yi.» ‑Ye kɛ ‑Yusuu ‑wɛ ꞊nʋ ye po, ɔ nɔ: «'Na ‑gbɛ, 'n 'deɛ ꞊bo le ‑wɛ 'a mʋ, nyɔ‑ ‑nyi 'mʋ 'klɩ, 'ke ꞊bo nu ‑tɔplɩ 'bii ‑gbo, 'nɩɩ nu.» ");
INSERT INTO ted_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","‑Ye kɛ ‑Yusuu lele ‑Juukʋɛ a ye'mʋnaanyʋ ye po, ɔ nɔ: «'N ‑hʋa ꞊bo po 'a mʋ ‑talʋdʋ ye, ‑ɛ die nu, dɛ a di 'lu ‑wɔn lɛ ‑hie, 'mue 'ye. Nyɩbɛyu ꞊de, nɔ‑ kɔ la 'yuo nyɩbɛpʋʋ 'hɔn, 'ɔ le 'a ye‑hɛyu, ɔ nɔ: 'Na 'yu o, mu kɛ 'le ‑ci ke, ꞊mʋ 'na ‑kʋan nu. ");
INSERT INTO ted_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‑Ye ɔ ꞊tu 'a bu ‑wɔn, ɔ nɔ: 'N bla nɩ. 'Nɩ mu ꞊le 'le. Kɛɛ, muu 'o ye 'mʋ, ɔ 'cɩcɩ 'a 'lu a lɛ‑hielɛ nɩ, 'ɔ mu 'le 'a bu a ‑ci ke, 'ɔ mu ‑kʋan nu wɔn. ");
INSERT INTO ted_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","‑Tɩ ꞊nʋ, nyɩbɛyu a ‑gbɛ, ɔ ꞊tu wɛn 'a ye‑hɛyu ye, nɩ‑ ɔ ꞊tu ‑wɛ 'a 'hɔn a nɔnɔ ye. Ɔ ‑mɛ ‑ye, ɔ nɔ: ‑Ɔɔ, 'n bu o, 'n di 'le 'nɩ mu. Kɛɛ ‑ye ɔ 'de 'le mu.» ");
INSERT INTO ted_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","‑Ye ‑Yusu ꞊gba ‑Juukʋɛ a ye'mʋnaanyʋ ‑nɩ wɛn wlɔn, ɔ nɔ: «'Ke 'le 'yuoo 'hɔn ꞊nʋ ‑gbahlɔn, nahuon tio‑ ꞊tuu 'o 'a bu 'le?» ‑Ye ʋ nɔ: «Ye‑hɛyuu nɩ.» ‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuin ꞊nʋ, ‑ʋ di 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ pa, nʋ‑ mɔ 'blʋwli'tɛnyʋ, kɔ 'lalunyrʋ. A ‑mɛ ‑ye, a 'deɛ ba pa 'le gbe. ");
INSERT INTO ted_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","'N nyi 'nɩ ꞊tu, ‑ɛ nue, 'a mʋ Yisraɛkʋɛ, Saan Batisɩ di nɔ 'a mʋ ‑hɛyri nɩ, 'ɔ tɔɔ 'a mʋ 'hru ꞊nʋ, ‑ʋ 'sii 'o ye, a di gba. Kɛɛ, ‑tɩ ꞊nʋ, ɔ ꞊tu, a 'di ‑tɛɛ pue. Kɛɛ, 'blʋwli'tɛnyʋ, kɔ 'lalunyrʋ ‑mɛ ‑ye, nʋ‑ pui ‑tɛɛ, 'ʋ 'cɩcɩ 'waa nunuklɔ. ‑Tɛ a 'ye ‑wɛ dɛ a ‑gbɛ, a 'de Saan a ‑gbɛ nʋa ye gbo po, 'a 'de 'a nɩ nunuklɔ 'cɩcɩ.» ");
INSERT INTO ted_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","(‑Yusu 'kɩɛ 'prɛɛ 'le Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ a ‑gbɛ ‑wɔn, kɔ ‑Juukʋɛ a ye'mʋnaanyʋ ‑ye 'hɛɛn, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ.) Ɔ nɔ: «Ba po 'mʋ nʋa ye gbo, 'mʋ lele 'a mʋ ‑talʋdʋ ‑ye ye po: Ɛ kɔ la ‑cikɔnyɔ ꞊de. Nɔ‑ nu la 'a ‑ci. ‑Ci a ‑gbɛ ke, ɔ 'dɔɔ 'le ti ꞊de. 'A 'yɔ, ɩɩ tʋ, ʋ nyo daa rɛsɛn. 'Dɩdɔnyɔ a ‑gbɛ, nɔ‑ ‑ha 'a ‑ci a ‑gbɛ ye, 'ɔ 'blu 'le 'hɩɔ gblaka ‑ye 'kwli 'mʋ lɛ, ‑ɛ die nu, 'bʋʋ 'a 'yɔ ꞊nʋ 'mʋ 'plɔ, 'a 'nie 'mʋ 'le 'hʋɔ a ‑gbɛ wlɔn bi, ʋ 'mue nɔ 'mʋ nuu. Ɔ nu ‑wɛ 'hɛ‑gbɔ, ‑ɔ kɔ ke ʋ di 'o ‑ci 'yie ꞊tuu, 'ke 'o 'yrinyʋ a ‑ta 'mʋ. ‑Tɛ ɔ ‑wɔ ‑kʋan 'bii ‑wɔn, ‑ye ɔ le ‑kʋannunyʋ ꞊de, 'ke bʋ nu ‑ci a ‑gbɛ a ‑kʋan, 'dɩdɔ‑tɔplɩ 'bɩ tʋ, ‑kʋannunyʋ a ‑gbɛ, ʋ 'mʋ ꞊nɔ 'a 'pɩa ‑nyi, 'waa ‑gbɛ, ʋ 'mʋ ‑wɛ 'o 'waa nɩ 'pɩa kɔ. ‑Cikɔnyɔ a ‑gbɛ, ‑tɛ ɔ ‑wɔ ‑kʋan a yegblɛ꞊tutulɛ ‑wɔn, ‑ye ɔ mu 'mʋ 'dagba ‑pɛtu. ");
INSERT INTO ted_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","‑Tɛ 'dɩdɔ‑tɔplɩ a 'cɩcɛti nyre 'o, ‑ye ‑cikɔnyɔ a ‑gbɛ, ɔ le 'a lɛleenyʋ ‑ye, 'ke bʋ mu 'le ‑ci'yie꞊tunyʋ ꞊nʋ ‑wɔn, ʋ 'mʋ ꞊nʋ 'cɩcɛ‑tɔplɩ ꞊nʋ ‑nyi, ‑ɩ blɛ ‑cikɔnyɔ ye, ʋ 'mui ꞊nɔ ye ya. ");
INSERT INTO ted_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","‑Tɛ lɛleenyʋ a ‑gbɛ, ʋ nyre 'klɛɛ 'le, ‑ci'yie꞊tunyʋ, 'ʋ bi ꞊ɔ ‑ye ‑tɛɛ, 'ʋ 'la ꞊ɔ ‑ye, kɔ, 'ʋ po ‑wɛ ta a nɔnɔ 'hɛ ‑wɔn lɛ, 'ʋ 'lɔ. ");
INSERT INTO ted_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","‑Tɛ ‑cikɔnyɔ 'wɔn dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, ‑ye ɔ lee lele 'a lɛleenyʋ ‑ye. Nahuin a ‑gbɛ, ʋ ‑huo nɩ, 'ʋ ‑hi 'o ye‑hɛnahuin ꞊nʋ 'mʋ, ɔ le o. Kɛɛ, ‑ci'yie꞊tunyʋ, dɛɛ ‑do ꞊nʋ, ʋ nu ye‑hɛnahuin 'mʋ, ɛ ‑do a ‑gbɛ, nɛ‑ ʋ nu ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‑Tɛ lɛleenyʋ a ‑gbɛ, ʋ ‑hi, ‑ye ɛ hie 'o 'a ‑gbɛ a 'yu. Nɔ‑ ɔ lee 'le ꞊nʋ ‑wɔn, ‑ɛ nue, 'a ꞊wlʋ nɔ 'nɩ: ‑Tɛ ɔ 'ya 'na 'yu 'mʋ, ʋ di kɔ 'a 'o꞊tuulɛ. ");
INSERT INTO ted_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Kɛɛ, ‑tɛ ‑ci'yie꞊tunyʋ 'ye 'yu ꞊nʋ, ‑ɔɔ 'le di, kɛ ʋʋ po, 'ke 'le 'waa dɩɔnʋ ‑gbahlɔn: Nahuon, ‑ɔ di ‑tado ‑ci ‑gbo kɔ, nɔ‑ɔ 'le di. Ba nɩ ‑ba 'lɔ, ‑a 'mʋ ‑ci ‑gbo kɔ, ");
INSERT INTO ted_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","'ʋ klo, 'ʋ 'hrɔɔ 'le ‑ci 'mʋ, 'ʋ 'lɔ.» ");
INSERT INTO ted_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","‑Ye ‑Yusu nɔ lele: «'A mʋ 'nɩɩ wlɔn ꞊gba, nahuon, ‑ɔ kɔ ‑ci a ‑gbɛ, 'bɔ di 'le, dɛ tio‑ ɔ di ‑ci'yie꞊tunyʋ a ‑gbɛ 'mʋ nu 'le?» ");
INSERT INTO ted_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «'Crɛnyʋ ꞊nʋ, ɔ 'deɛ bɔ 'ye 'waa wɔlɩ, ɔ 'mu 'la, 'plɩɩ ɔ 'mʋ 'le lele ‑ci a ‑gbɛ ‑ha, ɔ 'mue lele ‑ci'yie꞊tunyʋ ‑ye ‑nyi, 'dɩdɔ‑tɔplɩ a 'cɩcɛti 'bɩ nyre 'o, ʋ 'muo 'a 'pɩa ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «‑Tɩ ‑gbo, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, 'n pui ‑tɛɛ, a ‑hri nɩ. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: 'Katuo ꞊nʋ, kayuponyʋ 'de ‑hʋa bʋ nuu ‑kʋan 'yri, ʋ po 'pɩa ke, nɔ‑ ‑hɛ kayu a ‑gbɛ a 'katuo gblaka. Kʋkɔnyɔ Nyɩsʋa, nɔ‑ nue, 'ɔ ‑hɛ 'katuo gblaka, 'plɩɩ 'ɔ nɔ 'yie ke, 'ke 'o ‑a mʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le, 'a mʋ Nyɩsʋa a dakʋ ꞊nʋ, Nyɩsʋa kɔɔ win ke, ꞊hapʋdɛ ꞊nʋ, ɔɔ 'a mʋ 'mʋ nu, ‑ɛɛ 'le 'a nɩ win a kekɔɔlɛ 'mʋ ‑hɔn, ɔ die 'a mʋ kwa 'nɩ ‑ha, ɔ 'mue dakʋ ‑ye ꞊nʋ ‑nyi, ‑ʋ di 'o Nyɩsʋa 'o ꞊tuu.  ");
INSERT INTO ted_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nahuon 'bɔ nɩ 'o, 'bɔ bi 'o 'katuo a ‑gbɛ ke, ɔ di lɛ 'nɩ ‑yɩyrɛ, mɔ, 'katuo a ‑gbɛ, 'bɔ bi ꞊nɔ ke, ɔ dio lɛ 'nɩ waka.» ");
INSERT INTO ted_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ Falisi꞊tumu a nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'wɔn ‑talʋdʋɩ a ‑gbɛ nɩ, 'ʋ yree, ‑ɛ mɔ, nʋ‑ ‑Yusuu 'nyrɛ ꞊hɛn. ");
INSERT INTO ted_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","‑Tɛ ʋ yrii dɛ a ‑gbɛ, ‑ye ʋʋ lɛ ꞊mɔ 'hru, 'ke bʋ klo, ʋ 'muo 'la. Kɛɛ, ʋʋ pɩ hʋannʋ, 'ke bʋ klo, ‑ɛ nue, ʋ yie nɩ, ‑ɛ mɔ, nahuin, ʋʋ ‑Yusu daa Nyɩsʋa a winwlɔn‑hɛnyɔ. ");
INSERT INTO ted_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","‑Ye 'ke ‑Yusu naa 'le lele ‑talʋdʋɩ 'kwli 'mʋ, 'ɔɔ ‑Juukʋɛ a ye'mʋnaanyʋ klɛ ‑hɩhɩa, ‑ʋ ꞊gba wɛn ꞊nɔ wlɔn, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«‑Tɛ Nyɩsʋaa nahuin a win a kekɔɔlɛ nu, dɛ ꞊nʋ, ɛ 'we ye, ɛ nɛ‑ ‑gbo: Ɛ kɔ la bodɩɔ ꞊de. Nɔ‑ le 'a ‑kʋannunyʋ, 'ke bʋ pi 'a 'yu a 'blɩ'mʋpʋpa a dididɛ, ");
INSERT INTO ted_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","'ɔ da nahuin ‑ye dididɛ a ‑gbɛ ke. ‑Tɛ dɛditi nyre 'o, ‑ye ɔ le 'a ‑kʋannunyʋ nɩ, ɔ nɔ: Ba mu, ba da nahuin ‑nɩ wɛn. ‑Tɛ ʋ mu 'klɛɛ, ʋ yʋ 'o gbo, 'ʋ lu, ‑ye ʋ nɔ: ‑A bla nɩ, ‑a 'nɩ di ꞊le 'le. ");
INSERT INTO ted_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","‑Ye ɔ le lele 'a ‑kʋannunyʋ ‑ye, ɔ nɔ: Ba mu, ba le nahuin ꞊nʋ, 'n da wɛn, 'na dididɛ ‑wɛ ‑wɔn, 'na bro kɔ broyuo nʋanʋɩ ꞊nʋ, ʋ 'lɩ nɩ. ‑Tɔplɩ 'bii, ɩ ‑wɛ ‑wɔn. Bʋ di 'le, ʋ 'mʋ 'blɩ'mʋpʋpa a dididɛ ꞊nʋ di. ");
INSERT INTO ted_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kɛɛ, nahuin ꞊nʋ, ʋ da lɛ, ‑sɔgbɔlʋ a ‑tɩ 'ʋ 'de 'le di, 'ʋ mu 'waa ‑kʋɩn ‑wɔn lɛ, ꞊ɔ ‑ye 'ɔ mu 'le 'a ‑ci ke, ꞊ɔ ‑ye 'ɔ mu plo wɔn, ");
INSERT INTO ted_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","꞊ʋ ‑ye 'ʋ klɩ ‑kʋannunyʋ ꞊nʋ, ‑ʋ nyu wɛn lɛ da, 'ʋ biu ‑bibi, 'ʋ 'lʋlʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","‑Tɛ bodɩɔ a ‑gbɛ, ɔ 'wɔn ‑tɩ a ‑gbɛ, ‑ye ɔ bi 'mʋ yrʋ, 'ɔ le 'a 'sɔyuo, 'ke bʋ 'la 'crɛnyʋ a ‑gbɛ, kɔ bʋ po ‑wɛ 'waa 'dɩɔ 'tɔ. ");
INSERT INTO ted_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","‑Ye kɛ ɔ po lele 'a ‑kʋannunyʋ ye: 'Blɩ'mʋpʋpa a dididɛ ‑wɛ ‑wɔn. Kɛɛ, dididɛ ‑gbo, ɛ 'de nahuin ꞊nʋ ye blɛ, 'n da wɛn lɛ. ");
INSERT INTO ted_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ba mu 'le ‑tɛgbi ꞊nʋ, nahuin ‑huo 'le, kɔ, ba da nahuin 'bii ꞊nʋ, a di 'o gbo yɛ, 'ke bʋ di 'blɩ'mʋpʋpa a dɛdi‑tuo ke. ");
INSERT INTO ted_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","‑Ye 'a ‑kʋannunyʋ mu nɩ, 'ʋ 'kukue nahuin 'bii ꞊nʋ lɛ, ʋ yɛ 'o gbo, ‑ʋ mɔ nahuin ꞊nʋ, ‑ʋʋ 'o Nyɩsʋa ꞊tuu, kɔ nahuin ꞊nʋ, ‑ʋ 'nɩnɩ ꞊tuu 'o Nyɩsʋa. (Nahuin 'bii ꞊nʋ, ʋ da lɛ, ‑ʋ di 'le, ʋ ‑nyi ꞊nʋ 'blɩ'mʋpʋpa a wlawlʋ, ʋ 'mu pue.) Nahuindʋ a ‑gbɛ, nʋ‑ ‑wɛ ti ke. Ɛ nue, 'blɩ'mʋpakayu ꞊nʋ, 'ʋ 'yii 'le, 'ke 'o nahuin ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‑Ye bodɩɔ pa nɩ, ɔ 'mʋ nahuin ꞊nʋ 'ye, ɔ da. ‑Tɛ ɔ pa 'klɛɛ, ‑ye ɔ 'ye nɩ, ‑ɛ mɔ, 'ke 'le nahuin ꞊nʋ ‑hɛyri, nahuoon ‑do nɩ 'le, 'ɔ 'de 'blɩ'mʋpʋpa a wlawlʋ pue. ");
INSERT INTO ted_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‑Ye kɛ ɔɔ ꞊nɔ ye po, ɔ nɔ: 'Mɛ o, ‑mɔ ‑gbo, ‑ɔ 'de 'blɩ'mʋpʋpa a wlawlʋ pue, ‑n 'de ye blɛ ‑bo pa nɔ. Kɛɛ, ‑tɩ bɔ di ꞊nɔ ‑wɔn ꞊tu, ɔ 'di yi. ");
INSERT INTO ted_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nɛ‑ mɔ bodɩɔ bɔ le 'a ‑kʋannunyʋ, ɔ nɔ: Ba mʋa 'a bʋɩ kɔ 'a dabʋɩ. Ba puo 'le ‑patʋ 'mʋ, 'ke 'le gbɩgbɩyrɩ ‑hɛyri. 'Ke ɔ di 'o ꞊hien wee, kɔ, 'ke ɔ di ‑wɛ 'o yrʋ poo.» ");
INSERT INTO ted_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","‑Ye kɛ ‑Yusuu lele po: «Nyɩsʋa, ɔɔ da nahuin 'plɔplɔ, 'ke bʋ wɛɛn ke, bɔ kʋʋ win ke, kɛɛ, nahuiin ‑do ꞊nʋ, ‑ʋ wɛɛn ꞊nɔ ke, nʋ‑ ɔ ‑ha 'le du 'mʋ, 'ke bɔ kʋʋ win ke.» ");
INSERT INTO ted_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye Falisi꞊tumu a nahuin, ʋ mu 'mʋ ‑gboligbo, ‑ɛ die nu, ʋ 'mʋ 'hru lɛ ꞊mɔ, ‑tɛ ʋ di nu, ʋ 'muo wlɔn lɛ ꞊gba, 'a ‑wɔn꞊tutue 'kwli 'mʋ, ʋ 'mʋ 'le naa, ʋ 'muo ‑tɩ yɛɛ, ‑ɛ die nu, ʋ 'muo klɩ. ");
INSERT INTO ted_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","‑Tɛ ʋ ꞊tui 'klɛɛ, ‑ye ʋ tɛ gbo 'waa ‑naagbopʋ ‑ye, kɔ nahuin ‑ye 'hɛɛn, ‑ʋ mɔ 'kɩɩn Helɔdɩ a ꞊tumu a nahuin, 'ke bʋ mu 'le ‑Yusu 'hʋɩn 'mʋ. ‑Tɛ ʋ nyre 'le ꞊nɔ ‑wɔn, ‑ye ʋ nɔ: «Tɔɔnyɔ o, ‑a yie nɩ, ‑ɛ mɔ, ‑nɩɩ ꞊tu ‑tɩ a ‑tɛɛ, ꞊nɩɩ ‑tɩ a ‑tɛɛ tɔɔ, 'ke 'o dɛ ꞊nʋ, Nyɩsʋaa ‑a mʋ ‑hʋa a ‑ta 'mʋ. 'Bɩa ꞊nɩ nyi ꞊tu, ꞊nɩ pɩ ꞊le hʋannʋ, 'ke 'o ‑tʋnahuon a 'lu a lɛ‑hielɛ a ‑ta 'mʋ, mɔ ꞊betɩ bɔ 'ya nyɩgblaka 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Le 'klɛɛ ‑a mʋ dɛ ꞊nʋ, ‑nɩɩ 'lu ‑wɔn lɛ ‑hie, 'ke 'o ‑tɩ ꞊nʋ a ‑ta 'mʋ, ‑aa ‑mʋ wlɔn mu ꞊gba: ꞊Be Nyɩsʋa a tetei nɔ 'nɩ, ‑ba ‑ha 'blʋwli, ‑ba ‑nyi Romakʋɛ a 'kɩɩn gblaka, ‑hee' ‑a 'de ye blɛ ‑ba ‑nyi ꞊nɔ?» ");
INSERT INTO ted_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kɛɛ ‑ye ‑Yusu yie nɩ, dɛ‑ mɔ dɛ 'klan ꞊nʋ, ʋʋ 'lu ‑wɔn lɛ ‑hie, ɔ nɔ: «Dɛ‑ kɔ ‑tɩ ꞊nʋ, aa 'mʋ wlɔn ꞊gba, 'aa 'mʋ 'mʋ lɛ ꞊tɔ 'le, 'a mʋ nahuin ꞊nʋ, ‑ʋʋ 'lii 'hɔn naa? ꞊Be a 'mue 'ye, 'bɩa 'nɩ ‑haa Romakʋɛ a 'kɩɩn gblaka a ‑tɩ lɛ, kɔ Nyɩsʋa a ‑tɩ 'hɛɛn, a 'mʋ 'mʋ ‑tɩ yɛɛ? ");
INSERT INTO ted_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ba titie 'mʋ 'wliyɔkɔ a 'yɛɛ ‑do ꞊nʋ ye, aa 'mʋ 'ba, 'aa 'blʋwli 'pɛɛ,» 'ʋ ya ꞊nɔ 'wliyɔkɔ a 'yɛɛ ‑do ye. ");
INSERT INTO ted_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","‑Ye ɔ nɔ: «Nyɔ tio‑ kɔ 'lu꞊tɩɔ nɩ 'o 'le? Nyɔ tio‑ kɔ 'dʋ ʋ 'crɩɩ ‑wɛ 'o 'le?» ");
INSERT INTO ted_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","‑Ye ʋ nɔ: «Romakʋɛ a 'kɩɩn gblakaa nɩ.» ‑Ye kɛ ‑Yusuu 'klɛɛ ꞊nʋ ye po, ɔ nɔ: «'A ‑tɩ o, ba ‑nyi 'kɩɩn gblaka dɛ ꞊nʋ, ‑ɛ blɛ ꞊nɔ ye, kɔ, ba ‑nyi ‑wɛ Nyɩsʋa dɛ ꞊nʋ, ‑ɛ blɛ ꞊nɔ ye!» ");
INSERT INTO ted_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","‑Tɛ ʋ 'wɔn ‑tɩ ꞊nʋ, ‑Yusu ꞊tu ꞊nʋ ‑wɔn, ɩ saka ꞊nʋ nɩ. ‑Ye 'ke ʋ hio 'o gbo, 'ʋ mu. ");
INSERT INTO ted_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","'Ke 'le Jrusrɛdɩɔ 'mʋ, ɛ kɔ la ꞊tumu ꞊de. 'A 'dʋ mɔ Sadusɩ꞊tumu. Nʋ‑ʋ nɩ, ‑ʋ nyi ꞊tu, ‑ɛ mɔ, nahuin 'bʋ 'kʋ, ɛ 'die 'le ‑wɛ bʋ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, bʋ 'hrɩ 'klɔ, 'ke 'le Nyɩsʋa ye. Nʋ‑ kɔ nahuin mu 'o ‑Yusu 'hʋɩn 'mʋ, ‑nyrɔwɔɔ ‑do a ‑gbɛ 'mʋ, ‑ɛ die nu, ʋ 'muo wlɔn lɛ ꞊gba. ‑Tɛ ʋ nyre 'klɛɛ 'o ꞊nɔ 'hʋɩn 'mʋ, ‑ye ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Tɔɔnyɔ o, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, ɔ 'crɩɩ la tete ‑ye, 'ɔ hie la ‑a mʋ lɛ. Tete a ‑gbɛ, ɛ nɛ‑ ‑gbo: Nyɩbɛyu 'bɔ nɩ 'o, 'bɔ kɔ nyrɔ, 'plɩɩ nyɩbɛyu a ‑gbɛ, 'bɔ 'de 'yuo gbo hie, 'bɔ 'kʋ, ‑ye nyɩbɛyu ꞊nʋ, ‑ɔ 'kʋ, 'bɔ kɔ 'dɩayu nyɩbɛyu, nɔ‑ blɛ ye ‑bɔ kɔ 'a nyrʋgba a ‑gbɛ, ɔ kɔ ꞊nɔ 'hɛɛn, ʋ 'mʋ 'yuo kɔ, 'ke 'o 'a 'dɩayu, ‑ɔ 'kʋ a ‑ta 'mʋ. Kɛ Moise a tetee po.» ");
INSERT INTO ted_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","‑Ye kɛ ʋʋ lele po, ʋ nɔ: «Ɛ kɔ la ‑dɩayuo nyɩbɛpʋʋ 'nɩpata, kɛ nɔ ‑a mʋ ‑hɛyri, 'waa ye‑hɛnahuon 'ɔ kɔ nyrʋgba, nyɩbɛyu a ‑gbɛ, 'ɔ 'de 'yuo gbo hie, 'ɔ 'kʋ, 'ɔ hie 'a nyrʋgba a ‑gbɛ 'a ‑dɩayu a 'hɔn a nɔnɔ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dɛɛ ‑do a ‑gbɛ, nɛ‑ nue 'hɔn a nɔnɔ, kɔ ta a nɔnɔ. Nɛ‑ nue ‑nuenue, 'ɛ yɛ nahuon a 'nɩpata a nɔnɔ ke. ");
INSERT INTO ted_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","‑Tɛ ʋ 'bii, ʋ 'kʋ 'klɛɛ, ‑ye nyrʋgba a ‑gbɛ, ɔ 'kʋ la ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nɛ‑ mɔ ‑tɩ, ‑a di wɛn ‑mʋ wlɔn ꞊gba wɔn, ꞊mʋ ‑a mʋ klɛ ‑hɩhɩa. ‑Nyrɔwɔ ‑kɔ 'mʋ nahuin di 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, ʋ 'mʋ 'klɔ 'hrɩ, 'ke 'le Nyɩsʋa ye, nahuon tio‑ di 'klɛɛ nyrʋgba a ‑gbɛ kɔ 'le, 'ke 'le ʋ 'nɩpata ꞊nʋ ‑hɛyri, ‑ɛ nue, ‑tɛ ʋ nɩ la nɔ ‑tʋtʋ ke, nahuin 'bii a ‑gbɛ, ʋ kʋɔ la nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Aa 'nɩ ka, ‑ɛ nue, a 'de Nyɩsʋacrɩɩnɩɛ yi, 'a 'die ‑wɛ yi, ‑ɛ mɔ, Nyɩsʋa nɩ ke 'klɩ. ");
INSERT INTO ted_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ti ꞊nʋ ‑kɔ 'yri nahuin di 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, ʋ 'mʋ 'klɔ 'hrɩ, 'ke 'le Nyɩsʋa ye, nyɩbɛpʋ kɔ nyrʋgbapʋ 'hɛɛn, ʋ 'deɛ bʋ kʋkɔ. Kɛɛ, ‑tɛ Nyɩsʋa a lɛleenyʋ nɩ 'mʋ, kɛ'ɛ nɩ, ʋ di ‑wɛ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","'Ya 'o lele 'lu, dɛ ‑gbo, ‑ɛ mɔ nahuin bʋ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, bʋ 'hrɩ 'klɔ, 'n yie nɩ, ‑ɛ mɔ, a ‑hre ‑tɩ ꞊nʋ nɩ, Nyɩsʋa ꞊tu, 'ke 'le 'a 'crɩɩnɩɛ 'kwli 'mʋ. Kɛ Nyɩsʋaa la po: ");
INSERT INTO ted_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Mɔ mɔ Nyɩsʋa ꞊nʋ, Abrahamʋ, ɔɔ da, ɔ kɔ Yisakɩ, kɔ Sakɔbʋ 'hɛɛn. Kɛ'ɛ nɩ, Nyɩsʋa po. Ɛ 'we ꞊nɔ ye, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋaa 'le Moise ‑wɔn 'prɛɛ, Abrahamʋ kɔ Yisakɩ kɔ Sakɔbʋ 'hɛɛn, ʋ 'kʋ la nɩ. Kɛɛ, ‑a yie nɩ, ‑ɛ mɔ, ɛ 'de 'kʋkʋnyʋ, ʋ 'nɩ da ꞊le Nyɩsʋa, kɛɛ, 'klɔnɩnyʋ, nʋ‑ nyo da. ('A ‑tɩ, 'ba plɛ, nahuon 'bɔ 'kʋ, ɔ 'nɩ 'hrɩ ꞊le 'klɔ, 'ke 'le Nyɩsʋa ye, ‑ye ɛ 'de ꞊nɛ.)» Kɛ'ɛ nɩ, ‑Yusu po. ");
INSERT INTO ted_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nahuin 'bii ꞊nʋ, ‑ʋ po ‑Yusu nʋa ye gbo, ɩ saka ꞊nʋ nɩ, 'ke 'o tɔɔlɛdʋ ꞊nʋ, ɔ tɔɔ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Falisi꞊tumu a nahuin, ʋ 'wɩn nɩ, ‑ɛ mɔ, ‑Yusu ꞊tu Sadusɩ꞊tumu a nahuin ‑wɔn, 'ɔ nue, 'ʋ 'de 'klɛɛ lele ‑tɩ ꞊de kɔ, bʋ ꞊tu. Nɛ‑ mɔ bʋ 'kukue lɛ, bʋ mu 'o ‑Yusu 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","'Ke 'le ꞊nʋ ‑gbahlɔn, teteitɔɔnyɔ ꞊de nɩ 'o. Nɔ‑ ꞊gba ‑Yusu wlɔn, ‑ɛ die nu, ɔ 'muo 'mʋ lɛ ꞊tɔ, 'ke ɔ 'mʋ ka, 'ke 'o Nyɩsʋa ye, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Tɔɔnyɔ o, tetei 'bii ꞊nʋ, Nyɩsʋa ‑nyi ‑a mʋ, dɛ tio‑ mɔ tete gblaka 'le, 'ɛ ‑hi 'o ꞊ɩ ‑ye 'mʋ?» ");
INSERT INTO ted_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","«‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: ‑N blɛ ye ‑bo nʋɛ ‑na Kʋkɔnyɔ Nyɩsʋa 'mʋ, 'ke 'le ‑na ꞊wlʋ 'bii ke, kɔ, 'ke 'le ‑na 'lu a lɛ‑hielɛ 'bii 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nɛ‑ mɔ Nyɩsʋa a tete gblaka, 'ke 'le tetei 'bii ‑hɛyri. Nɛ‑ nɩ 'o tetei 'bii 'lu ye. ");
INSERT INTO ted_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nyɩsʋa a tete ‑ye, ‑ɛ kʋɛ 'o ꞊nɔ ‑wɔn, ‑ɛ mɔ ‑wɛ tete gblaka, ɛ nɛ‑ ‑gbo: ‑N blɛ ye ‑bo nʋɛ ‑n 'be ‑tʋnahuon 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n nu ‑n dɩɔnʋ a 'mʋnʋɛlɛ. ");
INSERT INTO ted_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Teteii 'hɔn a ‑gbɛ, nɩ‑ kɔ 'kwli 'mʋ Moise a tetei 'bii 'le 'mʋ ‑hɔn, ɩ kɔ Nyɩsʋa a winwlɔn‑hɛnyʋ a tɔɔlɛ 'hɛɛn.» ");
INSERT INTO ted_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye Falisi꞊tumu a nahuin, ʋ 'kukue lɛ, ‑Yusu 'ʋ ꞊gbʋ wlɔn, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Dɛ tio‑ aa 'lu ‑wɔn lɛ ‑hie, 'ke 'o Waanyɔ ꞊nʋ a ‑ta 'mʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya? Nyɔ‑ mɔ 'a bu gblaka?» ‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «Waanyɔ a ‑gbɛ, nɔ‑ mɔ bodɩɔ Dafidɩ a 'yuo a 'Yu.» ");
INSERT INTO ted_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","‑Ye ɔ ꞊gbʋ wlɔn, ɔ nɔ: «'Bɩa 'bɛ nɩ lɛ 'mʋ, ‑be' Nyɩsʋa a ‑Hihiu nu, Dafidɩ 'ɔ daa Waanyɔ a ‑gbɛ 'a Kʋkɔnyɔ, 'ɔ ꞊tui la, 'ʋ 'crɩɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: ");
INSERT INTO ted_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Kʋkɔnyɔ Nyɩsʋa, ɔ le 'na kʋkɔnyɔ nɩ, ‑ɛ mɔ: Nɩ mɔ 'na diidɛpɩa ke gbo, ‑n kɔ 'mʋ 'hɛɛn, ‑a 'mʋ nahuin win ke kɔɔ, ɛ 'mue gba ‑gbagba, 'mue nu, ꞊mʋ ‑na yraanyʋ bʋɩ 'lu gblɛ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","‑Ye ‑Yusu nɔ lele: «‑Tɛ Dafidɩ a ‑gbɛ, ɔɔ Waanyɔ a ‑gbɛ 'a Kʋkɔnyɔ daa, ‑be' Waanyɔ a ‑gbɛ, ɔ ‑wɛ 'le bɔ nu Dafidɩ a 'Yu a 'mʋ'yɩya 'le?» ");
INSERT INTO ted_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nahuin ꞊nʋ, ‑ʋ nɩ 'o, gbegbe 'a nahuon ꞊de 'die 'le ‑wɛ bɔ ‑hɩhɩa ‑Yusu klɛ. Kʋɛ 'o ‑nyrɔwɔ a ‑gbɛ 'yie 'mʋ gbo, nahuiin pɩ hʋannʋ, 'ke bʋ ꞊gbɔ lele dɛ ꞊de wlɔn. ");
INSERT INTO ted_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye kɛ ‑Yusuu nahuin ꞊nʋ, kɔ 'a ‑naagbopʋ 'hɛɛn ye po, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, 'waa ‑kʋan, nɔ‑ mɔ bʋ ‑hɩhɩa nahuin tetei ꞊nʋ klɛ, Nyɩsʋa ‑nyi la Moise. ");
INSERT INTO ted_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","'A ‑tɩ, ‑tɩ 'bii ꞊nʋ, ʋ di 'a mʋ ye ꞊tu, ba nui, kɔ, ba ꞊tui 'o. Kɛɛ, ‑tɔplɩ ꞊nʋ, ʋʋ nu, a nɩ nui 'le, ‑ɛ nue, ‑tɩ ꞊nʋ, ʋʋ nahuin tɔɔ, 'waa ‑gbɛ, ʋ 'nɩ nui ꞊le. ");
INSERT INTO ted_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ʋ nɩ 'o nahuin ke 'mʋ, 'ke bʋ ꞊tuu 'o tetei a gblegblei 'o, ‑ɩ kɔ 'o꞊tuulɛ kla wlɔn, ‑ɩ 'we ꞊nɔ kwakublɛ ye, kɛɛ, ʋ 'nɩ ‑hɛ ꞊le nahuin 'mʋ dɛ gbi, 'ke bʋ ꞊tuu 'o tetei a ‑gbɛ 'o. ");
INSERT INTO ted_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","'Waa ‑tɔplɩ 'bii, ʋʋ nu, ʋ nyi 'nɩ nu, ‑ɛ die nu, nahuin 'mu 'yie ke gbo 'nɛɛ, kɔ, ʋ 'mu baa. Ba 'ye kɛ 'waa dokwliyei gbi ꞊nʋ, ‑ɩ kɔ 'kwli 'mʋ ʋʋ 'le Nyɩsʋacrɩɩnɩɛi po, kɔ, ʋʋ ye gbo 'ma, kɔ, ʋʋ ‑wɛ 'le dabʋ 'mʋ po. Dokwliyei a ‑gbɛ, 'waa nɩnɩ 'bʋa nɩ 'dɔ. 'Plɩɩ, 'lili ꞊nʋ, ʋʋ 'waa wlawlɩ a ꞊hlɔnyedɛ gblɛ mʋa, ‑ɩ mɔ Nyɩsʋa a 'o꞊tuulɛ a yriilɛ, ʋ nye 'nɩ nu, 'waa nɩnɩ 'ɩ hren lɛ 'dɔ. ‑Tɔplɩ a ‑gbɛ, ʋ nyi 'nɩ nu, ‑ɛ die nu, ʋ 'mue nahuin tɔɔ, ‑ɛ mɔ, ʋ mɔ ‑tɛɛ a Nyɩsʋa a nahuiin nɩ. ");
INSERT INTO ted_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ʋ nʋɛ ‑wɛ 'mʋ nɩ, 'bɩa 'bʋ dʋ dididɛ ‑wɔn, 'ke bʋ nɩ 'le ye 'mʋ gbo, ‑ɛ die nu, nahuin 'mu 'ye. Dɛɛ ‑do a ‑gbɛ, nɛ‑ ʋʋ nu, 'bɩa 'bʋ mu 'le Nyɩsʋa a kayu gbo. ");
INSERT INTO ted_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","'Bɩa 'bʋʋ 'o 'ɛ nɩ ‑tɛgbi ꞊de mu, ‑tɛ nahuin ‑huo 'o, ʋ nʋɛ 'mʋ nɩ, 'ke nahuin bʋ pu 'wio gblɛ, 'ke 'o 'waa 'o꞊tuulɛ a ‑ta 'mʋ, 'ʋ nʋɛ ‑wɛ 'mʋ, 'ke nahuin bʋ dʋʋ Tɔɔnyʋ. ");
INSERT INTO ted_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Kɛɛ, a ‑mɛ ‑ye, a nɩ nue 'le, nahuin nɩ daa 'le 'a mʋ Tɔɔnyʋ, ‑ɛ nue, a kɔ Tɔɔnyɔɔ ‑do. A ‑mɛ ‑ye, a 'bii, 'a mʋ mɔ dɛɛ ‑do, ‑ɛ 'we ꞊nɔ 'dɩayuo ye. ");
INSERT INTO ted_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kɛ nɔ ‑tʋtʋ ke, a nɩ daa 'le nahuon ꞊de 'a nɩ Bu, ‑ɛ nue, a kɔ Buu ‑do, 'ɔ nɩ 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A nɩ nue 'le, ʋ nɩ daa 'le 'a mʋ Nyɩgblaka, ‑ɛ nue, a kɔ Nyɩgblakaa ‑do, ‑ɔɔ 'a mʋ naa. 'Mɔɔ nɩ, ‑ɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya. ");
INSERT INTO ted_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nɛ‑ nue, 'ke 'le 'a mʋ ‑hɛyri, nahuon ꞊nʋ, ‑ɔ mɔ 'a nɩ nyɩgblaka, ɔ blɛ ye bɔ 'ya 'a nɩ 'mʋ‑hɛnyɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Nahuon ꞊nʋ, ‑ɔɔ 'le 'a dɩɔnʋ 'yaa, Nyɩsʋa dio 'le 'nɩ ꞊tɩɔ, kɔ, nahuon ꞊nʋ, ‑ɔɔ 'le 'a dɩɔnʋ ꞊tɩɔ, Nyɩsʋa dio 'le 'nɩ 'yaa.» ");
INSERT INTO ted_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin, ‑ʋ nɩ 'o, nʋ‑ ‑Yusuu 'klɛɛ 'le ‑wɔn 'prɛɛ, ɔ nɔ: «'A mʋ Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋʋ 'lii 'hɔn naa, 'jrɔ 'ke 'o 'a mʋ ‑wɔn, ‑ɛ nue, aa 'hru ꞊nʋ ye 'nɩ ka, nahuin di wɛn na, ʋ 'mʋ 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ pa. 'A nɩ ‑gbɛ, a 'nɩ pa ꞊le 'le, 'aa nahuin ‑ye ye ka, 'ke bʋ pa 'le, ꞊betɩ bʋ nye wɛn ‑hʋa.  ");
INSERT INTO ted_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","'A mʋ Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋʋ 'lii 'hɔn naa, 'jrɔ 'ke 'o 'a mʋ ‑wɔn, ‑ɛ nue, aa kotianyrʋ 'waa kʋkɔ‑tɔplɩ 'bii kwa lɛ 'nɩ ‑ha. 'Plɩɩ 'baa Nyɩsʋa da, 'a nɩ Nyɩsʋa a dɩda hren gbo ye, ‑ɛ die nu, nahuin 'mʋ lɛ po, 'a mʋ mɔ ꞊hapʋnahuiin nɩ. Nɛ‑ die nu, ‑bati ꞊nʋ, Nyɩsʋa di 'a mʋ lɛ poo, 'ɩ di 'klɩ ke nɩ, ɩ 'mʋ 'o ꞊ʋ ‑ye a ‑bati 'mʋ ‑hi. ");
INSERT INTO ted_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","'A mʋ Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋʋ 'lii 'hɔn naa, 'jrɔ 'ke 'o 'a mʋ ‑wɔn. Aa ke na 'blʋgbɩ 'bii, 'yru kɔ ‑tʋtʋ ke, 'aa 'o 'klɩ ꞊tu, 'ke nahuoon ‑do bɔ wɛɛn 'a nɩ Nyɩsʋadɛ ke. 'Bɩa 'bɔ wɛɛn ke, ‑ye a nye 'nɩ nu, 'ɔɔ 'crɛnyɔ ‑hɛ, 'ɔɔ 'o 'a mʋ 'mʋ ‑hi, 'ɔɔ 'yilɛnyre꞊wlɩɩ 'hɔn kɔ. ‑Ye ɛ blɛ ye, Nyɩsʋa bɔ puo ‑tado 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe. ");
INSERT INTO ted_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","'A mʋ nahuinnaanyʋ ꞊nʋ, ‑ʋ 'we ꞊nɔ 'yiisuanyʋ ye, 'jrɔ 'ke 'o 'a mʋ ‑wɔn. A nye nahuin 'nɩ tɔɔ, ‑ɛ mɔ, nahuon 'bɔ nɩ 'o, 'bɔ 'sʋʋ Nyɩsʋa a 'kagblaka, ‑ye ɔ 'de ye blɛ bɔ nu dɛ ꞊nʋ, ɔ 'sʋʋ ke. Kɛɛ, 'bɔ 'sʋʋ ‑gʋlʋ ꞊nʋ, ‑ʋ nɩ 'le Nyɩsʋa a 'kagblaka a ‑gbɛ gbo, ‑ye ɔ blɛ ye bɔ nu dɛ ꞊nʋ, ɔ 'sʋʋ ke, (‑ɛ nue, a nɔ 'nɩ, ‑gʋlʋ a ‑gbɛ, ʋ mɔ dɛ gblakaa nɩ, 'ke 'o Nyɩsʋa ye, 'ɛ ‑hi 'o Nyɩsʋa a 'kagblaka 'mʋ.) ");
INSERT INTO ted_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","'A mʋ ꞊nʋ, ‑ʋ 'de 'lu a lɛ‑hielɛ kɔ, 'plɩɩ, ‑ʋ 'we ꞊nɔ 'yiisuanyʋ ye, a yie nɩ ‑tɛɛ, ‑ɛ mɔ, Nyɩsʋa a 'kagblaka, ɔ mɔ dɛ gblakaa nɩ, 'ke 'o Nyɩsʋa ye, 'ɔ ‑hi 'o ‑gʋlʋ ꞊nʋ 'mʋ, ‑ʋ nɩ 'le kayu a ‑gbɛ gbo, ‑ɛ nue, Nyɩsʋa a 'kagblaka, nɔ‑ nue, ‑gʋlʋ 'ʋ ‑hɛ dɛ gblaka, 'ke 'o Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kɛ aa ‑wɛ po, 'aa nahuin tɔɔ, ‑ɛ mɔ, nahuon 'bɔ nɩ 'o, 'bɔ 'sʋʋ Nyɩsʋa a ‑cɔhlʋnpiilɛ, ɔ 'de ye blɛ bɔ nu dɛ ꞊nʋ, ɔ 'sʋʋ ke. Kɛɛ, 'bɩa 'bɔ 'sʋʋ ‑cɔhlʋn ꞊nʋ, ‑ʋ nɩ 'o ‑cɔhlʋnpiilɛ ke, ‑ye ɔ blɛ ye bɔ nu dɛ ꞊nʋ, ɔ 'sʋʋ ke. ");
INSERT INTO ted_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","'A mʋ nahuin ꞊nʋ, ‑ʋ 'we ꞊nɔ 'yiisuanyʋ ye, a yie nɩ ‑tɛɛ, ‑ɛ mɔ, ‑cɔhlʋn, ʋ mɔ dɛ gblakaa nɩ, 'ke 'o Nyɩsʋa ye, 'ʋ ‑hi 'o ‑cɔhlʋnpiilɛ ꞊nʋ 'mʋ, ‑ɛ kɔ ke ‑cɔhlʋn a ‑gbɛ nɩ 'o, ‑ɛ nue, ‑cɔhlʋn, nʋ‑ nye nu, ‑cɔhlʋnpiilɛ 'ɛ 'ya dɛ gblaka 'mʋ, 'ke 'o Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","'A ‑tɩ o, nahuon 'bɔ nɩ 'o, 'bɔɔ ‑cɔhlʋnpiilɛ 'sʋʋ, ɔɔ 'sʋʋ ‑cɔhlʋnpiilɛ, kɔ ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ nɩɛ 'o ke. ");
INSERT INTO ted_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mɔ, nahuon 'bɔ nɩ 'o, 'bɔɔ Nyɩsʋa a 'kagblaka 'sʋʋ, ɔɔ 'sʋʋ Nyɩsʋa a 'kagblaka, kɔ, 'ɔɔ ‑wɛ Nyɩsʋa 'sʋʋ, ‑ɔ nɩ 'le kayu a ‑gbɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mɔ, nahuon 'bɔ nɩ 'o, 'bɔɔ yakɔ 'sʋʋ, ɔɔ 'sʋʋ yakɔ, ‑ɔ mɔ Nyɩsʋa a gbonɩɩlɛ, 'ɔɔ ‑wɛ Nyɩsʋa 'sʋʋ, ‑ɔ nɩ 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","'A mʋ Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋʋ 'lii 'hɔn naa, 'jrɔ 'ke 'o 'a mʋ ‑wɔn. 'Bɩa 'ba kɔ hai ꞊nʋ, aa 'le dididɛ ‑wɔn po, kɔ 'ɛ nɩ 'dɩdɔdɛ 'cicrɛ, aa 'le ‑sadɛ 'kwli 'mʋ ‑ha, nɩ‑ kɔ dɛ a ‑pu a nɛnɛ aa 'le ‑ha, 'a nye Nyɩsʋa ‑nyi. Kɛɛ, a 'nɩ ‑hie ꞊le 'lu ‑wɔn lɛ, 'ke ba nu ‑tɔplɩ gblakɩ ꞊nʋ, ʋ 'crɩɩ 'le Nyɩsʋa a teteicrɩɩnɩɛ 'kwli 'mʋ. A 'nɩ ‑hie ꞊le 'lu ‑wɔn lɛ, 'ke 'a nɩ nunuklɔ bɔ 'sii 'o ye, kɔ, ba kɔ nahuin a wɔlɩ, kɔ, ba kuo Nyɩsʋa ꞊wlʋ ye ‑tɛɛ. Kɛɛ ‑ye dɛ a ‑gbɛ, nɛ‑ɛ nɩ, a kɔ ba nu wɛn, 'plɩɩ a 'mʋ ‑wɛ 'le 'a nɩ 'dɩdɔ‑tɔplɩ 'cicrɛi a ‑pu a nɩnɩ ‑ha, a 'mui Nyɩsʋa ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","'A mʋ nahuinnaanyʋ ꞊nʋ, ‑ʋ 'we ꞊nɔ 'yiisuanyʋ ye, 'n nye ye poo dɛ: Aa 'a nɩ 'nɩnanie 'nɩ 'tite, ‑ɛ die nu, a 'nɩ ꞊han ‑tamrɩyɛɛ ꞊de mra, ‑ɛ nɩ 'le 'nie a ‑gbɛ ‑wɔn, kɛɛ, a 'nɩ 'ye ꞊le, 'aa bri mra. (Ɛ 'we ꞊nɔ ye, a nye 'yie 'nɩ ꞊tu, 'ke ba ꞊tuu 'o tetei 'cicrɛi ꞊nʋ, kɛɛ, tetei gblakɩ ꞊nʋ, a 'nɩ ꞊tui ꞊le 'o.) ");
INSERT INTO ted_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","'A mʋ Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋʋ 'lii 'hɔn naa, 'jrɔ 'ke 'o 'a mʋ ‑wɔn. 'A nɩ wlɔn'naapɔhlɩ kɔ dɛwlɔndiipɔhlɩ 'hɛɛn, nɩ‑ aa lɛ yra. Kɛɛ, 'ke 'le 'a nɩ ꞊wlɩ ke, 'yiyre kɔ ‑hʋhʋa‑tɔplɩ ‑hʋɩn 'hɛɛn, nɩ‑ 'yii 'le. ");
INSERT INTO ted_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","‑Mɔ Falisi꞊tumu a nahuon, ‑ɔ kɔ 'yii sua, yra 'le ‑na wlɔn'naapɔhlɩ wlɔn lɛ, ‑ye 'a ke di ‑wɛ 'le 'nɩ 'wʋ, ɛ 'mʋ 'o ye 'sii. (Ɛ ꞊hɛn 'nyrɛ, ꞊tu 'o 'klɩ, ‑ɛ die nu, ‑na ꞊wlʋ 'mʋ 'o ye 'sii, 'ke 'o Nyɩsʋa ye, ‑ye ‑tɔplɩ 'bii, 'ke 'le ‑na 'klɔ ‑hɛyri, ɩ di ‑wɛ 'o ye 'nɩ 'sii.) ");
INSERT INTO ted_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","'A mʋ Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋʋ 'lii 'hɔn naa, 'jrɔ 'ke 'o 'a mʋ ‑wɔn. A 'we ꞊nɔ 'dɛɛi ye, ʋ 'pɛnɩ. 'Dɛɛi a ‑gbɛ, ɩ nɔɔ 'le 'kwli 'mʋ lɛ 'yie, kɛɛ, ɩ 'yii 'le ꞊le, 'ke 'o 'kʋkʋkui a 'klɩ ‑wɔn, kɔ, 'ke 'o ꞊hʋnhɔn‑tɔplɩ a gblegblei ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Dɛɛ ‑do a ‑gbɛ, nɛ‑ɛ nɩ, 'ke 'o 'a mʋ ‑wɔn. A nɔɔ 'le nahuin klɛ 'yi, kɛɛ, sɛyɩ‑sɛyɩ, aa naa 'lii 'hɔn, dɛ 'kuku 'ɛ 'yii 'le 'a nɩ ꞊wlɩ ke.» ");
INSERT INTO ted_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«'A mʋ Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋʋ 'lii 'hɔn naa, 'jrɔ 'ke 'o 'a mʋ ‑wɔn, ‑ɛ nue, Nyɩsʋa a winwlɔn‑hɛnyʋ ꞊nʋ, kɔ nahuin ꞊nʋ, ‑ʋ kɔ 'klɔ 'sii la 'o ye, 'a nɩ bunʋ, ʋʋ la lɛ 'lɩla, nʋ‑ kɔ 'dɛɛi aa ‑hlɛntie ‑tɛɛ, ");
INSERT INTO ted_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","'plɩɩ 'aa lɛ po: 'Bɩa ꞊ba nɩ la 'klɔ, ‑a nɩ bunʋ a ti 'yri, ‑a 'deɛ ‑ba biu la ke, ‑ba 'la la Nyɩsʋa a winwlɔn‑hɛnyʋ a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","‑Tɛ aa lɛ 'pʋprɛ nu, ‑ye ɛ ꞊hɛn 'nyrɛ, a nye 'nɩ yrii, ‑ɛ mɔ, nahuin ꞊nʋ, ‑ʋʋ la Nyɩsʋa a winwlɔn‑hɛnyʋ lɛ 'lɩla, 'a mʋ mɔ 'waa 'yuoo nɩ. ");
INSERT INTO ted_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","'A ‑tɩ, ba gba dɛ ꞊nʋ 'lu ‑wɔn, 'a nɩ bunʋ ꞊tu la ‑wlu, ‑ɛ die nu, a 'mue 'lu ‑yra. ");
INSERT INTO ted_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","'A mʋ ꞊nʋ, aa kaa nahuin, 'a nɩ nunuklɔ 'ɔ nyre 'yi lɛ, ‑ɛ 'we ꞊nɔ hrei ye. Nyɩsʋa a ‑bati di 'a mʋ 'nɩ klɩ, ɔ 'mʋ 'le 'a mʋ na ꞊nʋ 'mʋ po, ‑ɔ 'nɩnɩ jre gbe. A nɩ ‑hie 'le 'lu ‑wɔn lɛ, ‑ɛ mɔ, a die 'le wlɔn 'nɩ ꞊ta. ");
INSERT INTO ted_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","'Nɩɩ 'a mʋ 'nɩ le, 'n di 'a mʋ ye ya Nyɩsʋa a winwlɔn‑hɛnyʋ, kɔ ꞊tɔkɔnyʋ, kɔ nahuin ꞊nʋ, ‑ʋʋ Nyɩsʋa a ‑tɩ tɔɔ. A di ꞊ʋ ‑ye 'nɩ 'la, a 'mʋ 'o ꞊ʋ ‑ye tu 'yie 'mʋ kɔɔ, ‑ɛ die nu, ʋ 'mʋ 'kʋ, a 'mʋ ꞊ʋ ‑ye lɔkʋɛ bii, 'ke 'le Nyɩsʋa a kayuo gbo, kɔ, a 'mu 'dɩɛ klɛ bla, ‑ɛ die nu, a 'mu ꞊sʋɛ ꞊tue. ");
INSERT INTO ted_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nɛ‑ die nu, Nyɩsʋa a yrʋ 'mʋ 'a mʋ yɛ, 'ke 'o nahuin 'bii ꞊nʋ, ‑ʋ 'sii la 'o ye a ‑ta 'mʋ, ‑ʋ kɔ dablo ʋʋ la gblɛ 'wʋwla, ɛ ꞊hɛn 'nyrɛ, kʋɛ la 'le Abɛlɩ, ‑ɔ 'sii la 'o ye a 'lɩla 'yie 'mʋ gbo, ‑bo yɛ Balasi a 'yu Sakali ke, 'a nɩ bunʋ 'la la, 'ke 'le Nyɩsʋa a kayu kɔ 'a ‑cɔhlʋnpiilɛ a ‑gbahlɔn. ");
INSERT INTO ted_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ti ‑gbo 'yri a nahuin, nʋ‑ Nyɩsʋa a yrʋ di yɛ, 'ke 'o ‑tɔplɩ 'bii a ‑gbɛ a ‑ta 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«'Nɩɩ Jrusrɛ 'mʋ a nahuin 'nɩ le: Nyɩsʋa 'bɔ lee nɔ 'a mʋ 'a winwlɔn‑hɛnyʋ ‑wɔn, a nyu ‑wɔn lɛ po 'hɛ, 'a nyu 'la. 'Ɛ nɩ ti, 'n nye o 'nɩ ‑hʋa, 'ke ꞊bo 'kukue o mɔ 'a mʋ lɛ, kɛ mɔ 'mʋ 'hʋɩn 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ hapɛ'gbaa nu, 'ɛɛ 'a 'yuo꞊pli lɛ 'kukue, 'plɩɩ 'ɛ nyi ke gbo ꞊jri, kɛɛ, a 'die ke wɛɛn. ");
INSERT INTO ted_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ɛ nɛ‑ kɔ ‑tɩ Nyɩsʋa 'mʋ 'o 'a nɩ 'dɩɔ gbo hie, a ‑do, a 'mʋ 'a nɩ dɩɔnʋ lɛ kikle. ");
INSERT INTO ted_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","'Nɩɩ 'a mʋ 'nɩ le, kʋɛ 'klɛɛ mɔ gbo, a 'deɛ ba 'ye 'klɛɛ lele 'mʋ, ɛ 'mue gba ‑gbagba, ‑nyrɔwɔ ꞊nʋ, ɔ 'mʋ 'o nyre, ‑ɔ kɔ 'mʋ a di 'o lɛ poo: ‑Na 'wio, ‑mɔ ‑gbo, ‑ɔɔ 'le di, ‑ɔ nyra 'o Kʋkɔnyɔ Nyɩsʋa a ‑ta 'mʋ gbo. Nyɩsʋa bɔ ‑nyi ‑mʋ ‑tɩ a 'yi'bʋaalɛ!» ");
INSERT INTO ted_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","‑Tɛ ‑Yusu ‑wɔ 'pʋprɛ ‑wɔn, ‑ye ɔɔ 'le Nyɩsʋa a 'kagblaka gbo 'nɩ 'hrɩ. Bɔɔ 'klɛɛ mu, ‑ye 'a ‑naagbopʋ 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, 'ʋ nyo le: «'Ye kɛ, ‑tɛ Nyɩsʋa a 'kagblaka nu 'yilɛnɩnɔ.» ");
INSERT INTO ted_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Aa kayu ‑gbo a 'yilɛnɩnɔ 'nɩ 'ye. Kɛɛ, 'nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'yilɛnɔkayu ‑gbo, aa 'klɛɛ 'ye, ʋ diu 'nɩ 'wla 'bii. 'A 'hɩɔ ꞊de 'deɛ bɔ nɩ 'o 'a 'be 'hɩɔ 'lu gbo.» ");
INSERT INTO ted_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ ꞊tɩ 'mʋ 'dɩɔ, 'ʋ mu 'le dʋgba ꞊nʋ 'lu, ‑ɔ kɔ 'lu ti nɩ 'le, ʋʋ olifie daa. ‑Tɛ ʋ nyre 'le, ‑ye ‑Yusu nɩ gbo, nahuoon ‑do ꞊de 'dio 'o 'hʋɩn 'mʋ nɩ, 'bɛ 'de 'a ‑naagbopʋʋ ‑do. Nɛ‑ mɔ 'a ‑naagbopʋ bʋ 'yɩyɔ 'o 'hʋɩn 'mʋ gbo, bʋ ꞊gbɔ wlɔn, ʋ nɔ: «Le ‑a mʋ, ti tio‑ kɔ 'yri ʋ di 'o Nyɩsʋa a 'kagblaka ꞊nʋ 'wlaa 'le, kɔ dɛ tio‑ ‑a di 'ye, ‑ɛ di 'lu ‑wɔn mue, 'plɩɩ ‑a 'mue yi, ‑ɛ mɔ, ‑na 'lediti kɔ 'klɔ a 'o'mʋ‑hɔnti nyre 'o ꞊o.» ");
INSERT INTO ted_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Ba nɩ 'o ‑preelɛ 'mʋ, ‑ɛ die nu, ꞊ɔ ꞊de 'nɩ ꞊han 'a mʋ kaa, ");
INSERT INTO ted_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","‑ɛ nue, nahuin 'plɔplɔ di 'le di, 'ke 'le 'na 'dʋ 'kwli 'mʋ, ʋ 'mʋ lɛ po, nʋ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, 'plɩɩ ʋ 'mʋ 'dai nahuin kaa. ");
INSERT INTO ted_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","'Ya 'o lele 'lu, a di 'nɩ 'wɔn, ‑ɛ mɔ, ʋʋ ‑wɔn tʋ, 'ke 'le 'blʋgbɩ ꞊nʋ 'mʋ, ‑ɩ 'mʋɛɛ 'a mʋ ye, kɔ, ‑ɩ hren 'a mʋ ‑wɔn. 'Ba nyi 'wɔn, a nɩ pɩ 'le hʋannʋ, ‑ɛ nue, ‑tɔplɩ a ‑gbɛ, ɩ kɔ bɩ mue 'lu ‑wɔn. Kɛɛ, 'bɩɩ 'lu ‑wɔn mue, ɛ 'de 'nyrɛ ꞊hɛn, ‑ɛ mɔ, 'klɔ a 'o'mʋ‑hɔnti nyre 'o ꞊o. ");
INSERT INTO ted_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","'Blʋgbɩ di ye 'nɩ ‑wʋnwɔn. 'Ke 'le 'dai 'blʋgbɩ 'mʋ, kanʋ di 'nɩ ꞊tɩ, kɔ, ‑tʋtʋ di 'nɩ 'hɩhrɔ. ");
INSERT INTO ted_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","'Kla‑wliye'yɩya a ‑gbɛ, ‑ɛ di 'le di, 'klɔ a 'o'mʋ‑hʋnhɔn, nɛ‑ kɔ ‑wlu꞊tutue'e nɩ. Kɛɛ ‑ye 'klɔ 'de wɛn 'o 'mʋ a ‑hʋɛn. Ɛ 'we ꞊nɔ nyrʋgba ye, ‑ɔ nɩ 'kwli 'mʋ, ‑tɛ 'kwli bɛ 'nɩnɩ ꞊tu wɛn 'a nunue ‑wlu, kɛɛ ‑ye 'a ‑ŋɩŋlati 'de wɛn 'o a nyree. ");
INSERT INTO ted_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ti a ‑gbɛ 'yri, 'a nɩ yraanyʋ kɔ bʋ po 'a mʋ 'blʋgbanaanyʋ kwa, ‑ɛ die nu, ʋ 'mʋ 'a mʋ ꞊sʋɛ ꞊tue, kɔ, ʋ 'mʋ ‑wɛ 'a mʋ 'la. Nahuin 'bii ꞊nʋ, ‑ʋ nɩ nɔ 'klɔ ‑gbo ke, ʋ di 'a mʋ 'nɩ yraa, ‑ɛ nue, 'a mʋ mɔ 'na nahuiin nɩ. ");
INSERT INTO ted_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ti a ‑gbɛ 'yri, nahuin 'plɔplɔ 'deɛ bʋ kuo 'klɛɛ lele 'mʋ ꞊wlʋ ye, ꞊ʋ ‑ye 'mʋ 'waa 'bienʋ ‑ye kaa, ʋ 'mu 'blʋnaanyʋ kwa lɛ po, ʋ 'mu ꞊sʋɛ ꞊tue, kɔ, nahuin 'mʋ yɩyraa, ");
INSERT INTO ted_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","hɩwinwlɔn‑hɛnyʋ 'plɔplɔ 'mʋ 'hrɩ, ʋ 'mʋ nahuin 'plɔplɔ kaa. ");
INSERT INTO ted_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","'Ɛ nɩ ‑tɛgbi ꞊de, kɛ nahuin di nu, ʋ 'mʋ 'yilɛnyre‑tɔplɩ nu, 'yilɛnyre‑tɔplɩ a ‑gbɛ, ɩ 'mʋ klɛ bii, ɩ 'mue nu, nahuin 'plɔplɔ 'mʋ 'waa 'bienʋ a 'mʋnʋɛlɛ 'kee. ");
INSERT INTO ted_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ 'de sɩa, 'ke 'o Nyɩsʋa a ꞊wlʋ a yekuolɛ ‑wɔn, 'bɔ gbɛ ‑gbagba, 'klɔ a 'o'mʋ‑hɔnti 'bɩ nyre 'o, nɔ‑ Nyɩsʋa di waa. ");
INSERT INTO ted_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kɛ nɔ 'klɔ 'bii ‑gbo ke, 'na nahuin di 'na ꞊hapʋtitie ꞊nʋ 'nɩ po, ‑ɛ nyi ꞊tu, ‑tɛ Nyɩsʋa nu nahuin a win a kekɔɔlɛ, ‑ɛ die nu, dakʋ 'bii a nahuin 'mue 'wɔn, ʋ 'mʋ 'hru kɔ, 'ke bʋ kuo ꞊hapʋtitie a ‑gbɛ ꞊wlʋ ye, 'plɩɩ 'klɔ ‑gbo a 'o'mʋ‑hɔnti 'mʋ 'o nyre.» ");
INSERT INTO ted_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Nahuon ‑gbo, ‑ɔɔ win ‑gbo ‑hre, ɔ blɛ ye bɔ kɔ ꞊tɔ, 'plɩɩ ɔ 'mui 'mʋ lɛ yrii. Win a ‑gbɛ, ɩ nɩ‑ ‑gbo: Ɛ di kɔ ti ‑ye, a 'mʋ 'yilɛnyredɛ ꞊de 'ye, 'ke 'le Nyɩsʋa a 'kagblaka gbo. 'Yilɛnyredɛ a ‑gbɛ, Nyɩsʋa a ꞊wlʋ yrɛɛ nɩ, 'plɩɩ dɛ a ‑gbɛ, ɛ nye 'nɩ nu, Nyɩsʋa 'ɔɔ 'a 'kagblaka ‑wɔn hren. 'Yilɛnyredɛ a ‑gbɛ, ‑tɛgbi ɛ 'de 'o kɔ, 'ke ɛ di 'o nɩ. Nyɩsʋa a winwlɔn‑hɛnyɔ Daniɛ, nɔ‑ ꞊tu la 'yilɛnyredɛ a ‑gbɛ a ‑tɩ. 'Bɩa 'baa dɛ a ‑gbɛ 'ye, ");
INSERT INTO ted_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","‑ye nahuin ꞊nʋ, ‑ʋ nɩ 'le Sudeblʋgba 'mʋ, bʋ 'gba ci lɛ, bʋ mu 'le dʋgbɩ 'lu, ʋ 'nɩ ꞊hiun lɛ 'lɩla. ");
INSERT INTO ted_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Nahuon 'bɔ nɩ 'le 'a kayu a ‑yaa 'mʋ, bɔ 'gba ci lɛ ‑dodo. Ɔ nɩ po 'le lɛ, bɔ pa 'le 'a kayu gbo, ɔ 'mʋ 'a kʋkɔ‑tɔplɩ bla, 'plɩɩ ɔ 'mʋ ci lɛ 'gba. ");
INSERT INTO ted_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nahuon 'bɔ nɩ 'le 'a ‑ci ke, bɔ 'gba ci lɛ ‑dodo. Ɔ nɩ po 'le ‑wɛ lɛ, bɔ ꞊hɩan ‑wɔn, bɔ bla 'a wlawlɩ, 'ke 'le 'dɩɔ 'mʋ, 'plɩɩ ɔ 'mʋ ci lɛ 'gba. ");
INSERT INTO ted_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ti a ‑gbɛ 'yri, nyrʋ ꞊nʋ, ‑ʋ di 'kwlii 'mʋ lɛ nɩ, kɔ, 'waa dɛ ‑gbo, ‑ɛ di 'yuo 'nya, ɛ di 'ye ꞊sʋɛ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ba da Nyɩsʋa, ‑tɔplɩ a ‑gbɛ, ɩ 'nɩ ꞊han 'lu ‑wɔn mue, a 'nɩ ꞊han ci lɛ 'gba, ti ꞊nʋ ‑kɔ 'yri cɛɛ 'o ꞊tɩɩ, ‑hee' ‑wuwle‑nyrɔwɔ 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","‑ɛ nue, ti a ‑gbɛ 'yri, nahuin di 'ye ꞊sʋɛ 'dɔ, ɛ 'mʋ 'o ꞊sʋɛ 'bii ꞊nʋ 'mʋ ‑hi, nahuin ‑tʋa la 'le 'yiye gbo, kʋɛ la 'le 'klɔ a ‑wlu꞊tuulɛ 'yie 'mʋ gbo, ‑bo yɛ ꞊sʋɛ gblaka a ti a ‑gbɛ ke, ɛ 'mʋ ‑wɛ 'o ꞊sʋɛ ꞊nʋ 'mʋ ‑hi, nahuin di 'ye, kʋɛ 'le ti a ‑gbɛ 'yri gbo, ‑bo yɛ 'klɔ a 'o'mʋ‑hɔnti ke. ");
INSERT INTO ted_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nyɩsʋa di ‑nyrɔwɩ a gbɛ ꞊tɩɔ 'lu, 'ke 'o nahuin ꞊nʋ a ‑ta 'mʋ, ɔ ‑ha 'le du 'mʋ, 'ke bʋ 'ya 'a nahuin 'mʋ. Nɛ‑ 'de wɛn ꞊nɛ, nahuon ꞊de 'deɛ bɔ nɩ wɛn 'klɔ, ti a ‑gbɛ 'yri. ");
INSERT INTO ted_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Tii ‑do a ‑gbɛ 'yri, nahuon 'bɔ le 'a mʋ, 'bɔ plɛ: Ba 'ye kɛ, Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, kɛ ɔ nɩ mɔ, ‑hee' 'ke ɔ nɩ 'le ‑tɛgbi ꞊nʋ, a nɩ puo 'le ‑tɛɛ gbe, ");
INSERT INTO ted_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","‑ɛ nue, hɩwaanyʋ, kɔ hɩwinwlɔn‑hɛnyʋ di 'hrɩ, ʋ 'mʋ 'ŋmilɛka‑tɔplɩ gblakɩ a gblegblei nu, ‑ɛ die nu, 'bɛ ‑wɛ 'le, ʋ 'mʋ ‑wɛ nahuin ꞊nʋ kaa, Nyɩsʋa ‑ha 'le du 'mʋ, 'ke bʋ ‑hɛ 'a nahuin. ");
INSERT INTO ted_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","'A ‑tɩ, ba po 'mʋ nʋa ye gbo, ‑ɛ nue, ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ di 'lu ‑wɔn mue, ɛ nɩ ke 'mʋ, 'nɩɩ 'a mʋ le. ");
INSERT INTO ted_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","'Bɩa 'bʋ le 'a mʋ, ‑ɛ mɔ: Ba di 'le, Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, 'ke ɔ nɩ 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti! a nɩ mu 'le 'le. Mɔ, 'bɩa 'bʋ le ‑wɛ 'a mʋ, ‑ɛ mɔ: Ba di 'le, kɛ ɔ ‑hli nɔ ‑tɛgbi ‑gbo! a nɩ pui 'le ‑tɛɛ, ");
INSERT INTO ted_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","‑ɛ nue, Waanyɔ a ‑gbɛ, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'a 'ledidie, ɛ di ye 'we ‑tɛ tɩatɩɛɛ nu, 'ɛɛ wlɩn, 'ke 'le yakɔ 'mʋ, kʋɛ 'le 'yrʋ a 'hrɩɩlɛ 'mʋ, ‑bo mu, ‑bo yɛ 'yrʋ a gbopɛɛlɛ ke. ");
INSERT INTO ted_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","‑A 'brikʋɛ nɔ 'nɩ: ‑Tɛ dɛhʋɛ 'kukuu 'o nɩ, 'ke keii 'o lɛ 'kukue.» ");
INSERT INTO ted_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«꞊Sʋɛ'yeti a ‑gbɛ 'bɩ ‑hi, ‑ye 'yrʋ kɔ ‑hɔpɔ 'hɛɛn, ɩ di 'nɩ jre, yahroyɔ di 'le yakɔ 'mʋ lɛ 'nɩ ble, kɔ ‑tɔplɩ 'bii, ‑ɩ nɩ 'le yakɔ 'mʋ, ɩ di 'mʋ lɛ ‑hɔn ‑ta. ");
INSERT INTO ted_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Tii ‑do a ‑gbɛ 'yri, nahuin di 'ye dɛ, 'ke 'le yakɔ 'mʋ, ‑ɛ nye ꞊nʋ tɔɔ, ‑ɛ mɔ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le 'nɩ di. ‑Ye 'klɔ 'bii a dakʋ, ʋ di lɛ nu wɔlɩ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ʋ 'mʋ 'mʋ 'ye. 'N di 'le 'nɩ di, 'ke 'le 'na 'klɩ a kenɩnɩɛ 'kwli 'mʋ, kɔ, 'ke 'le 'na ‑tɩ a 'yi'bʋaalɛ 'kwli 'mʋ. 'Bɩa 'nɩɩ 'le di, 'ke 'n di 'le 'nugbɩ ‑hɛyri nɩ. ");
INSERT INTO ted_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","‑Ŋamʋ gblaka ꞊nʋ, ʋ di po wun, 'mʋ Nyɩsʋa a lɛleenyʋ gbo tɛ, ʋ 'mʋ 'klɔ ‑gbo a ꞊gɛi 'bii ye na, ʋ 'mʋ nahuin ꞊nʋ lɛ 'kukue, Nyɩsʋa ‑ha 'le du 'mʋ, 'ke bʋ ‑hɛ 'a nahuin.» ");
INSERT INTO ted_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Ba 'ye kɛ tugbɛ ꞊nʋ, ʋʋ figie daa. 'Ke 'o tugbɛ a ‑gbɛ 'yie 'mʋ, tɔɔlɛ nɩ 'o. Ɛ nɛ‑ mɔ, ti ꞊nʋ ‑kɔ 'yri ɛɛ 'o babʋɩ yrayrɩ lɛ ꞊tuu, kɔ 'a hai 'bɩɩ ꞊ga, ‑ye ‑a yie nɩ, ‑ɛ mɔ, ‑cii‑ci‑nyrɛ 'mʋɛɛ yrɛ. Kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'ke 'o 'na 'ledidie a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","‑Tɔplɩ 'bii ‑gbo, ‑ɩ kɔ ‑tɩ 'n ꞊tu wɛn, 'bɩɩ 'lu ‑wɔn mue, ‑ye ba kɔ 'a yiyie, ‑ɛ mɔ, 'na 'lediti 'mʋɛɛ yrɛ. Ɛ 'we ꞊nɔ ye, 'ke 'n nɩ 'o 'maju 'yri. ");
INSERT INTO ted_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, dakʋ ‑gbo, ʋ 'deɛ bʋ 'kʋ, ‑tɔplɩ 'bii a ‑gbɛ, ɩ 'mʋ 'o nyre. ");
INSERT INTO ted_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Yakɔ kɔ ‑tʋtʋ 'hɛɛn, ɩ di gbo 'nɩ ‑wɛ, kɛɛ, 'na wintɛ, ɛ 'deɛ bɛ ‑wɛ gbo gbe.» ");
INSERT INTO ted_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «Ti ꞊nʋ ‑kɔ 'yri 'lelɛ'bɔɔ‑nyrɔwɔ di 'o nyre, ɛ 'de nahuon kɔ, ‑bɔ yi ti a ‑gbɛ. Mɔ, 'mɔ ‑gbo, ‑ɔ mɔ Nyɩsʋa a 'Yu, 'n kɔ Nyɩsʋa a lɛleenyʋ 'hɛɛn, ꞊ɔ ꞊de 'de 'o nɩ, ‑ɔ yi ‑nyrɔwɔ a ‑gbɛ, 'bɛ 'de ‑a nɩ Bu Nyɩsʋaa ‑do. ");
INSERT INTO ted_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Dɛ ꞊nʋ, ‑ɛɛ la 'lu ‑wɔn mue, nahuon ‑gbo, ‑ɔ mɔ Noe a ti 'yri, ɛ ‑do a ‑gbɛ, nɛ‑ di 'lu ‑wɔn mue, ti ꞊nʋ ‑kɔ 'yri 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le di. ");
INSERT INTO ted_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noe a ti 'yri, 'plɩɩ 'nie 'mʋ la 'o 'klɔ mu ‑ha, nahuiin la lɛ 'nɩ 'mre, ʋʋ wɛn ‑tɔplɩ a die, ʋʋ wɛn nɔ a 'nɛɛ, ʋʋ wɛn a kʋkʋɛ, ʋʋ wɛn 'waa 'yuo 'blɩ 'mʋ lɛ a pʋɛ. Nɛ‑ ʋ 'ble kwa ‑bleble, Noe 'ɔ pa la kɛ 'le 'a 'mɩɩ ꞊nʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ʋ 'nɩ ‑hie ꞊le la dɛ ꞊de 'lu ‑wɔn lɛ, 'ɛ gbɛ ‑gbagba, 'nu gblaka 'ʋ bi la ꞊hlɔn, 'a 'yiyinie 'ɛ gba la ʋ 'bii, 'ɛ 'lɩla la ꞊nʋ lɛ. Kɛ ɛ di ‑tado 'mʋ ‑ti, ti ꞊nʋ ‑kɔ 'yri 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di ‑tado 'le di. ");
INSERT INTO ted_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nahuiin 'hɔn, 'bʋʋ ‑kʋan nu, 'ke 'le ‑cii ‑do ke, 'n di 'o ‑ha nahuoon ‑do, 'mʋ ꞊ɔ ‑ye gbo hie. ");
INSERT INTO ted_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nyrʋʋ 'hɔn, 'bʋʋ ꞊gbla du, 'ke 'le ‑tʋɔɔ ‑do wlɔn, 'n di 'o ‑ha nahuoon ‑do, 'mʋ ꞊ɔ ‑ye gbo hie. ");
INSERT INTO ted_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","'A ‑tɩ, ba nɩ 'o ‑preelɛ 'mʋ, a nɩ ŋmo 'le, ‑ɛ nue, ‑nyrɔwɔ, 'a nɩ Kʋkɔnyɔ di 'le ya, a 'dio yi. ");
INSERT INTO ted_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ɛ 'we ꞊nɔ ye, kayukɔnyɔ 'bɔ yi wɛn 'tɔyrʋwɔ a ti ꞊nʋ ‑kɔ 'yri 'yrinyɔ di wɛn 'le di, ‑ye ɔ di wɛn 'nɩ ‑pre, ‑ɛ die nu, 'yrinyɔ a ‑gbɛ, ɔ 'nɩ ꞊han 'a kayu wa. ");
INSERT INTO ted_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nɛ‑ kɔ ‑tɩ, 'a nɩ ‑gbɛ, ba ‑wɛ ‑wɔn, ‑ɛ nue, ti ꞊nʋ, a 'nɩnɩ ‑hie 'lu ‑wɔn lɛ, nɩ‑ 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le ya.» ");
INSERT INTO ted_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‑Tɛ ‑Yusu ꞊tu ‑tɩ a ‑gbɛ, ‑ye ɔ po ‑talʋdʋ, ɔ nɔ: «Ba 'we ꞊nɔ ‑kʋannunyɔ ꞊nʋ ye, 'a 'masɛ ‑wɛ 'le bɔ kuo ꞊wlʋ ye, kɔ, ‑ɔ kɔ 'lu a lɛ‑hielɛ. Nahuondʋ a ‑gbɛ, 'a 'masɛ, 'bɔɔ 'dagba 'mʋ mu, nɔ‑ ɔ di 'a kayu 'bii lɛ hie, ‑ɛ die nu, dɛditi 'bɩ nyre 'o, ɔ 'mʋ 'a 'bie ‑kʋannunyʋ 'ɛ nɩ ‑nyrɔwɔ 'waa dididɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","'A 'masɛ 'bɔ ‑hɔn 'dagba 'mʋ, 'bɔ yɔ 'o ‑kʋan 'yie 'mʋ gbo, ‑ye ‑kʋannunyɔ a ‑gbɛ, bɔ kɔ plɔ a bleelɛ. ");
INSERT INTO ted_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","'Nɩɩ 'a mʋ 'nɩ le, 'a 'masɛ dio 'mʋ nuu 'a ‑tɔplɩ a 'yie꞊tunyɔ gblaka. ");
INSERT INTO ted_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kɛɛ, ‑kʋannunyɔ a ‑gbɛ, 'a 'klɔ 'bɔ nyre 'yi lɛ, 'bɔ plɛ, 'a 'masɛ a 'ledidie, ɛɛ gbo 'nɩ ‑wlɛn, ");
INSERT INTO ted_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","'bɔ ‑tʋa 'a 'bie ‑kʋannunyʋ a bibie gbo, kɔ, 'bɔɔ 'a dɩɔnʋ dididɛ kɔ nɔ 'hɛɛn wlɔn ‑hie, ɔ kɔ nɔ'nanyʋ 'hɛɛn, ");
INSERT INTO ted_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","‑ye 'a 'masɛ a ‑gbɛ, ɔ di 'le 'nɩ di, ‑nyrɔwɔ ‑kɔ 'mʋ ‑kʋannunyɔ a ‑gbɛ, ɔ 'nɩnɩ dio 'o ‑pree, kɔ ‑haawɔ ꞊nʋ, ɔ 'de yi. ");
INSERT INTO ted_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","'Bɔ di 'klɛɛ 'le, ‑ye ɔ dio ye gba ti 'yaklɩ, 'plɩɩ ɔ 'muo ꞊sʋɛ ꞊tue, ‑ɛ 'we ꞊nɔ nahuin ꞊nʋ ye, ‑ʋʋ 'lii 'hɔn naa. 'Ke ɔ di 'o ꞊hien wee, kɔ, 'ke ɔ di ‑wɛ 'o yrʋ poo.» ");
INSERT INTO ted_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","(‑Ye kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ:) «Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'o nahuin win ke kɔɔ 'bii, dɛ, ɛ di ye 'we, ɛ nɛ‑ ‑gbo: 'Yuo nyrʋyuoo ‑pu ꞊de, nʋ‑ ʋ da 'blɩ'mʋpaalɛ ke. ‑Tɛ 'tɔɔ ‑wɔn, ‑ye ʋ gba 'waa 'nyranapɩi, ʋ kɔ 'yu nyrɔyu ꞊nʋ 'hɛɛn, ‑ɔɔ 'blɩ 'mʋ mu pa, 'ʋ mu 'a tɔ ‑pre wɔn. ");
INSERT INTO ted_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","'Ke 'le 'yuo nyrʋyuoo ‑pu a ‑gbɛ ‑hɛyri, ʋ ꞊hun nɩ 'le, 'ʋ kɔ ꞊tɔ, ʋ ꞊hun ‑ye 'ʋ 'de ꞊tɔ kɔ. ");
INSERT INTO ted_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","'Yuo nyrʋyuo ꞊nʋ, ‑ʋ 'de ꞊tɔ kɔ, ‑tɛ ʋʋ 'waa nɩ 'napɩi gba, ʋ 'de 'nyrayrɩɛi gba, ‑ɛ die nu, 'nyra 'bɔ ‑wɛ 'le, ʋ 'mʋ 'le 'a dɛ ‑ye po. ");
INSERT INTO ted_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","'Waa dɛ ꞊nʋ, ‑ɛ kɔ ꞊tɔ, ʋ ‑mɛ ‑ye, ‑tɛ ʋʋ 'waa 'napɩi gba, ‑ye ʋ gba 'nyrayrɩɛi, ‑ɛ die nu, 'nyra 'bɔ ‑wɛ 'le, ʋ 'mʋ 'le 'a dɛ ‑ye po. ");
INSERT INTO ted_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kɛɛ 'klɛɛ, 'blɩ'mʋpanyɔ 'de 'le di 'tata. Bɔ 'nɩnɩ di 'klɛɛ 'le, nɛ‑ nue, 'yuo nyrʋyuoo ‑pu a ‑gbɛ, 'waa 'yii 'ɩɩ ye ‑wɔ, 'ʋ bi ŋmla 'mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","'Tɔ‑hɛyri 'mʋ 'klɛɛ, ‑ye ʋ 'wɔn ‑cici, nahuin 'ʋʋ lɛ po: Ba 'ye kɛ, 'blɩ'mʋpanyɔɔ 'le 'nɩ di, ba di 'le, ba muo ye 'mʋ 'bɛ! ");
INSERT INTO ted_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","‑Ye 'yuo nyrʋyuoo ‑pu a ‑gbɛ, ʋ 'ba 'mʋ ye, 'ʋ 'yaa 'waa 'napɩi 'lu lɛ. ");
INSERT INTO ted_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","‑Ye 'yuo nyrʋyuo ꞊nʋ, ‑ʋ 'de ꞊tɔ kɔ, kɛ ʋʋ 'yuo nyrʋyuo ꞊nʋ ye po, ‑ʋ kɔ ꞊tɔ, ʋ nɔ: Ba ‑nyi ‑a mʋ 'a nɩ 'nyra a dɛ, ‑ɛ nue, ‑a nɩ 'napɩi, ɩɩ ‑hʋa bɩ jre. ");
INSERT INTO ted_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kɛɛ ‑ye 'yuo nyrʋyuo ꞊nʋ, ‑ʋ kɔ ꞊tɔ, ʋ nɔ: ‑A nɩ 'nyra, ‑a kɔ, ɔ 'de ‑huo, 'ke 'o ‑a 'bii ‑wɔn. Dɛ a kɔ ba nu, nɛ‑ mɔ, ba mu 'le 'nyraplonyʋ ‑wɔn, a 'mʋ 'a nɩ nɔnɔ ‑tɔ! ");
INSERT INTO ted_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","‑Ye 'yuo nyrʋyuo ꞊nʋ, ‑ʋ 'de ꞊tɔ kɔ, ʋ mu nɩ, 'ʋ mu 'nyra ‑tɔ wɔn. 'Ke ʋ ‑mrɛ 'le, 'blɩ'mʋpanyɔ 'ɔ di 'le, 'yuo nyrʋyuo ꞊hun ꞊nʋ, ‑ʋ ‑wɛ ‑wɔn, ʋ kɔ ꞊nɔ 'hɛɛn, 'ʋ pa 'le 'blɩ'mʋpakayu gbo. ‑Tɛ ʋ pa 'klɛɛ, ‑ye ʋ po 'o 'maju nɩ. ");
INSERT INTO ted_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ti gbi bɩ ‑hi, ‑ye 'yuo nyrʋyuoo ꞊hun ꞊nʋ, ‑ʋ mu wɛn 'nyra ‑tɔ wɔn, ʋ nyre 'o ꞊o, 'ʋ da 'blɩ'mʋpanyɔ, ʋ nɔ: Nyɩbɛyu o, ‑ha ‑a mʋ 'maju ye! ");
INSERT INTO ted_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kɛɛ ‑ye ɔ ꞊tu ‑wɔn, ɔ nɔ: 'Nɩɩ 'a mʋ 'nɩ le, 'n 'de 'a mʋ yi.» ");
INSERT INTO ted_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «'A ‑tɩ, ba nɩ 'o ‑preelɛ 'mʋ, a nɩ ŋmo 'le, ‑ɛ nue, a 'de ‑nyrɔwɔ kɔ ‑haawɔ ꞊nʋ 'hɛɛn yi, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le ya.» ");
INSERT INTO ted_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di nahuin win ke kɔɔ 'bii, dɛ, ɛ di ye 'we, ɛ nɛ‑ ‑gbo: Ɛ kɔ la nyɩbɛyu ꞊de, nɔ‑ɔ la 'dagba ‑pɛtu 'mʋ mu, 'ɔ da 'a ‑kʋannunyʋ, 'ɔ hie ꞊nʋ 'a 'wli lɛ, ‑ɛ die nu, ʋ 'mui kʋɛsɛ 'yri hraa; ");
INSERT INTO ted_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","'ɔ ‑nyi 'a ye‑hɛnahuon 'wliblɛɛ ꞊hun, 'a 'hɔn a nɔnɔ, 'ɔ ‑nyo 'wliblɛɛ 'hɔn, kɔ, 'a ta a nɔnɔ, 'ɔ ‑nyo 'wliblɔɔ ‑do. 'Wliblɛɛ ‑tie ꞊nʋ, 'ɛ nɩ nahuon, ɔ ‑wɛ 'le ‑kʋan a 'yrinuulɛ, nɛ‑ ɔ ‑nyi ꞊nɔ. ‑Tɛ ɔ ‑wɔ ‑kʋɩn a yegblɛ꞊tutulɛ ‑wɔn, ‑ye ɔ mu 'mʋ 'dagba. ");
INSERT INTO ted_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nahuon ꞊nʋ, ‑ɔ 'ye 'wliblɛɛ ꞊hun ꞊nʋ, tii ‑do a ti 'yri, ɔ mu nɩ, 'ɔ hrɛɛ kʋɛsɛ 'yri, 'a kʋɛsɛ a ‑gbɛ, 'ɛ po 'o ꞊nɔ 'wliblɛɛ ꞊hun ‑ye. ");
INSERT INTO ted_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nahuon ꞊nʋ, ‑ɔ 'ye 'wliblɛɛ 'hɔn, kʋɛsɛɛ ‑do a ‑gbɛ, nɛ‑ ɔ hra, 'ɛ po ‑wɛ 'o ꞊nɔ 'wliblɛɛ 'hɔn ‑ye. ");
INSERT INTO ted_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kɛɛ, nahuon ꞊nʋ, ‑ɔ 'ye 'wliblɔɔ ‑do, ɔ ‑mɛ ‑ye, ɔ mu nɩ, 'ɔ 'blu ‑tʋtʋ, 'ɔ ‑hlii 'le 'a 'masɛ a 'wliblɔ a ‑gbɛ 'le. ");
INSERT INTO ted_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‑Tɛ ɛ ‑wlɛn gbo, ‑ye 'waa 'masɛ di 'le ꞊le, 'ɔ da 'a ‑kʋannunyʋ, ‑ɛ die nu, ‑tɛ ʋ nu 'a 'wli a kʋɛsɛ a 'yrihraalɛ, ɔ 'mue 'ye. ");
INSERT INTO ted_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","‑Ye nahuon ꞊nʋ, ‑ɔ 'ye o 'wliblɛɛ ꞊hun, ɔ 'yɩya 'o ꞊nɔ ye gbo, ɔ nɔ: 'Na 'masɛ o, ‑n ‑nyi o 'mʋ 'wliblɛɛ ꞊hun. 'Ye kɛ, 'n hrɛɛ 'yri kʋɛsɛ, 'ɛ po 'o 'wliblɛɛ ꞊hun ‑ye. Ɛ nɛ‑ ‑gbo. ");
INSERT INTO ted_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‑Ye 'a 'masɛ nɔ: Ɛ nu ‑tɛɛ. ‑Mɔ mɔ ꞊hapʋ‑kʋannunyɔɔ nɩ. Nahuon ‑wɛ 'le bɔ kuo ‑mʋ ꞊wlʋ ye nɩ. ‑Tɔplɩ ‑gbo, ‑ɩ 'de ‑huo, 'n ‑nyi ‑mʋ, ‑n nui 'yri ‑kʋan ‑tɛɛ. 'A ‑tɩ, 'n di ‑mʋ ‑nyi ‑tɔplɩ ‑huohui, ꞊mui ‑kʋan 'yri nuu. Di 'le, ‑n kɔ 'mʋ 'hɛɛn, ‑a 'mʋ lɛ 'mre. ");
INSERT INTO ted_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‑Ye nahuon ꞊nʋ, ‑ɔ 'ye o 'wliblɛɛ 'hɔn, ɔ 'yɩya 'o ꞊nɔ ye gbo, ɔ nɔ: 'Na 'masɛ o, ‑n ‑nyi o 'mʋ 'wliblɛɛ 'hɔn. 'Ye kɛ, 'n hrɛɛ 'yri kʋɛsɛ, 'ɛ po 'o 'wliblɛɛ 'hɔn ‑ye. Ɛ nɛ‑ ‑gbo. ");
INSERT INTO ted_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‑Ye 'a 'masɛ nɔ: Ɛ nu ‑tɛɛ. ‑Mɔ mɔ ꞊hapʋ‑kʋannunyɔɔ nɩ. Nahuon ‑wɛ 'le bɔ kuo ‑mʋ ꞊wlʋ ye nɩ. ‑Tɔplɩ ‑gbo, ‑ɩ 'de ‑huo, 'n ‑nyi ‑mʋ, ‑n nui 'yri ‑kʋan ‑tɛɛ. 'A ‑tɩ, 'n di ‑mʋ ‑nyi ‑tɔplɩ ‑huohui, ꞊mui ‑kʋan 'yri nuu. Di 'le, ‑n kɔ 'mʋ 'hɛɛn, ‑a 'mʋ lɛ 'mre. ");
INSERT INTO ted_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‑Ye nahuon ‑gbo, ‑ɔ 'ye o 'wliblɔɔ ‑do, ɔ 'yɩya ‑wɛ 'o ꞊nɔ ye gbo, ɔ nɔ: 'Na 'masɛ o, 'n yie nɩ, ‑ɛ mɔ, ‑na ŋmli 'yakla nɩ. 'Dɩdɔ‑tɔplɩ ꞊nʋ, ‑n 'de 'dɔ, nɩ‑ ‑n plɛ ‑bo 'cɛ. ");
INSERT INTO ted_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","'N pɩ o hʋannʋ. Nɛ‑ nue, 'nɩ 'blu o ‑tʋtʋ, 'nɩ ‑hlii o 'le ‑na 'wliblɔ. 'Ye kɛ, ‑na 'wliblɔ a ‑gbɛ, nɔ‑ ‑gbo. ");
INSERT INTO ted_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‑Ye 'a 'masɛ ꞊tuo ‑wɔn, ɔ nɔ: ‑Kʋannunyɔ ꞊nʋ, ‑ɔ kɔ 'klɔ nyre 'yi lɛ, kɔ, ‑ɔ hlɛkɛ, nɔ‑ ‑n 'ya 'mʋ. ‑N yie nɩ, ‑ɛ mɔ, 'dɩdɔ‑tɔplɩ ꞊nʋ, 'n 'de 'dɔ, nɩ‑ 'n plɛ ꞊bo 'cɛ. ");
INSERT INTO ted_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","'A ‑tɩ, ‑n kɔ ‑bo po wɛn 'le 'na 'wliblɔ ‑bakɩ 'mʋ, ‑ɛ die nu, 'ledidie ‑gbo, 'n di 'le, 'mʋ wɛn 'le 'na 'wliblɔ ꞊nʋ 'le ‑ha, ɛ kɔ dɛ ‑gbo 'hɛɛn, ‑ɛ di wɛn 'o ꞊nɔ 'lu 'mʋ bi. ");
INSERT INTO ted_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‑Ye 'masɛ a ‑gbɛ, ɔ le 'a nahuin ‑ye, ɔ nɔ: Ba ‑ha ꞊nɔ 'wliblɔ a ‑gbɛ kwa, ba ‑nyo nahuon ꞊nʋ, ‑ɔ kɔ 'wliblɛɛ ‑pu. ");
INSERT INTO ted_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","'Ɛ mɔ ‑tɛɛ, 'ɛ nɩ nahuon, ‑ɔ kɔ ‑tɔplɩ ‑huohui, ʋ di lele ꞊nɔ ‑nyi ‑tɔplɩ ‑ye, ‑ɛ die nu, 'a ‑tɔplɩ ꞊nʋ, ɔ kɔ, ɩ 'mʋ ‑huo, ɩ 'mʋ ꞊nɔ wlɔn ‑hi. Kɛɛ, nahuon ꞊nʋ, ‑ɔ kɔ ‑tɔplɩ 'de ‑huo, ʋ di ꞊nɔ kwa 'nɩ ‑ha. ");
INSERT INTO ted_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","‑Kʋannunyɔ ‑gbo, ‑ɔ 'de dɛ ꞊de a nulɛ yi, ba puo 'le ‑patʋ 'mʋ, 'ke 'le gbɩgbɩyrɩ ‑hɛyri. 'Ke ɔ di 'o ꞊hien wee, kɔ, 'ke ɔ di ‑wɛ 'o yrʋ poo.» ");
INSERT INTO ted_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","(Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ:) «Ti ‑kɔ ti 'yri 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le di, 'n di bodɩɔ ye 'we. 'N kɔ Nyɩsʋa a lɛleenyʋ 'hɛɛn, ‑a di 'le di. 'Ke 'n di 'o 'na bodɩɔgbata ke gbo nɩ. ");
INSERT INTO ted_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Dakʋ a pɛpɛ, ‑ʋ nɩ nɔ ‑tʋtʋ ke, ʋ di lɛ 'nɩ 'kukue, 'ke 'o 'mʋ ye, 'plɩɩ 'mu 'yi 'mʋ lɛ ‑hɩhɩa, ‑ɛ 'we ꞊nɔ ye, ‑tɛ blablɔ'yie꞊tunyɔɔ nu, 'ɔɔ blablɔ kɔ wlo 'hɛɛn 'yi 'mʋ lɛ ‑hɩhɩa. ");
INSERT INTO ted_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ɛ 'we ꞊nɔ ye, nahuin ‑gbo, ‑ʋʋ la Nyɩsʋa a ‑hʋhʋa‑tɔplɩ nu, 'ke 'n diu 'le 'na diidɛpɩa ke ‑hie, kɔ, nahuin ‑gbo, ‑ʋ 'nɩnɩ nu la Nyɩsʋa a ‑hʋhʋa‑tɔplɩ, 'ke 'n diu 'le 'na kamrapɩa ke ‑hie. ");
INSERT INTO ted_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","'Plɩɩ 'mɔ ‑gbo, ‑ɔ mɔ bodɩɔ, kɛ 'n di nahuin ‑gbo ye po, ‑ʋ nɩ nɔ 'na diidɛpɩa ke: Ba di 'le, 'a mʋ ꞊nʋ, 'na Bu Nyɩsʋa nu ꞊hapʋdɛ 'mʋ, ba kɔ Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ, ɔ po la lɛ, ɔ di la 'a mʋ ‑nyi, ti ꞊nʋ ‑kɔ 'yri ɔ nu la 'klɔ. ");
INSERT INTO ted_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","‑Ɛ nue, ‑tɛ kanʋʋ la 'mʋ nu, a ‑nyi 'mʋ dididɛ; kɔ, ‑tɛ 'nie'natʋʋ la 'mʋ nu, a ‑nyi 'mʋ 'nɩnanie; kɔ, ‑tɛ 'n 'ya la 'dagbatayu 'mʋ, a paa la 'mʋ gbo kayu; ");
INSERT INTO ted_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","kɔ, ‑tɛ 'n 'de la 'hʋɩn'mʋpuedɛ kɔ, a ‑nyi la 'mʋ 'hʋɩn'mʋpuedɛ; kɔ, ‑tɛ 'n kɔ la 'hʋɩn a hinhren, a pɩa la 'mʋ nɩ; kɔ, ‑tɛ 'n nɩ la ꞊jɩ 'mʋ, a di la 'mʋ ye ‑mrɛ wɔn. ");
INSERT INTO ted_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","‑Ye nahuin a ‑gbɛ, ‑ʋʋ la Nyɩsʋa a ‑hʋhʋa‑tɔplɩ nu, kɛ ʋ di 'mʋ ye po: Kʋkɔnyɔ, ti tio‑ kɔ 'yri ‑a 'ye ‑mʋ, kanʋ 'ʋʋ la ‑mʋ nu, ꞊a ‑nyi la ‑mʋ dididɛ 'le; kɔ, 'nie'natʋ 'ʋʋ la ‑mʋ nu, ꞊a ‑nyi la ‑mʋ 'nɩnanie 'le? ");
INSERT INTO ted_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ti tio‑ kɔ 'yri ‑n 'ya la 'dagbatayu 'mʋ, ꞊a paa la ‑mʋ kayu gbo 'le? Ti tio‑ kɔ 'yri, ‑n 'de la 'hʋɩn'mʋpuedɛ kɔ, ꞊a ‑nyi la ‑mʋ 'hʋɩn'mʋpuedɛ 'le? ");
INSERT INTO ted_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ti tio‑ kɔ 'yri ‑a 'ye ‑mʋ, ‑na 'hʋɩn 'ɩɩ la hren, kɔ, ꞊nɩ nɩ la 'le ꞊jɩ 'mʋ, ꞊a di la ‑mʋ ye ‑mrɛ wɔn 'le? ");
INSERT INTO ted_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‑Ye 'mɔ bodɩɔ, kɛ 'n di ꞊nʋ ye po: 'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ɛ nɩ ti, 'ba nu la ꞊hapʋdɛ ꞊nʋ 'na ‑dɩayu ‑ye ꞊nʋ 'yi ꞊hlɔn lɛ, ‑ɔ 'de 'mini kɔ, ‑ye ɛ 'we ꞊nɔ ye, 'mɔɔ nɩ, a nue la 'yi ꞊hlɔn lɛ. ");
INSERT INTO ted_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","'Bɛ ‑hi, ‑ye 'mɔ bodɩɔ, 'n di nahuin ꞊nʋ 'nɩ le, ‑ʋ nɩ nɔ 'na kamrapɩa ke: Ba hren 'mʋ ‑wɔn, 'a mʋ ꞊nʋ, Nyɩsʋa po 'jrɔ ‑wɔn. Ba mu 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe. Na a ‑gbɛ, Nyɩsʋa ‑wɔ ‑wɔn, 'ke 'o 'kuo ‑hʋɩn a nyɩgblaka, kɔ 'a 'mʋ‑hɛnyʋ 'hɛɛn ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","‑Ɛ nue, ‑tɛ kanʋʋ la 'mʋ nu, a 'de la 'mʋ dididɛ ‑nyi; kɔ, ‑tɛ 'nɩnatʋʋ la 'mʋ nu, a 'de la 'mʋ 'nɩnanie ‑nyi; ");
INSERT INTO ted_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","kɔ, ‑tɛ 'n 'ya la 'dagbatayu 'mʋ, a 'de la 'mʋ kayu gbo paa; kɔ, ‑tɛ 'n 'de la 'hʋɩn'mʋpuedɛ kɔ, a 'de la 'mʋ 'hʋɩn'mʋpuedɛ ‑nyi, kɔ, ‑tɛ 'na 'hʋɩɩn la hren, kɔ, ‑tɛ 'n nɩ la 'le ꞊jɩ 'mʋ, a 'de la 'mʋ ye di ‑mrɛ. ");
INSERT INTO ted_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‑Ye kɛ nahuin a ‑gbɛ, ʋ di 'mʋ ye po: Kʋkɔnyɔ, ti tio‑ kɔ 'yri ‑a 'ye la ‑mʋ, kanʋ 'ʋʋ la ‑mʋ nu, kɔ, 'nɩnatʋ 'ʋʋ la ‑mʋ nu, ꞊nɩ 'ya la 'dagbatayu 'mʋ, kɔ, ꞊nɩ 'de la 'hʋɩn'mʋpuedɛ kɔ, ‑na 'hʋɩn 'ɩɩ la hren, kɔ, ꞊nɩ nɩ la 'le ꞊jɩ 'mʋ, 'plɩɩ ꞊a 'de la ‑mʋ ke dii 'le? ");
INSERT INTO ted_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‑Ye 'mɔ bodɩɔ, kɛ 'n di ꞊nʋ ye po: 'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ɛ nɩ ti, 'ba 'de la ꞊hapʋdɛ ꞊nʋ 'na ‑dɩayu ‑ye ꞊nʋ 'yi ꞊hlɔn lɛ nu, ‑ɔ 'de 'mini kɔ, ɛ 'we ꞊nɔ ye, 'mɔɔ nɩ, a 'die la 'yi ꞊hlɔn lɛ nu. ");
INSERT INTO ted_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‑Tɔplɩ a ‑gbɛ a ‑tɩ, Nyɩsʋa diu 'le gba ‑tɛgbi ‑ye, ‑tɛ ʋ diu 'le ꞊sʋɛ ꞊tue, ‑ɛ 'nɩnɩ di 'le ‑wɛ gbe. Kɛɛ, nahuin ꞊nʋ, ‑ʋʋ la Nyɩsʋa a ‑hʋhʋa‑tɔplɩ nu, nʋ‑ di 'le 'klɔ yrayrʋ 'kwli 'mʋ pa, ‑ɔ 'nɩnɩ ‑wɛ 'le.» ");
INSERT INTO ted_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","‑Tɛ ‑Yusu ‑wɔ ‑tɔplɩ 'bii ꞊nʋ a tɔɔlɛ ‑wɔn, ‑ye kɛ ɔɔ 'a ‑naagbopʋ ye po, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«A yie nɩ, ‑ɛ mɔ, ɛ hie 'le ‑nyrɔwɩɩ 'hɔn, ‑a nɩ lɛ'mimre, ʋʋ Pakɩ daa, ɛ 'mʋ 'o nyre. 'Kee nɩ, ʋ di 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon 'na yraanyʋ kwa po, ‑ɛ die nu, ʋ 'mʋ 'o 'mʋ tu 'yie 'mʋ kɔɔ, ʋ 'mʋ 'mʋ 'la.» ");
INSERT INTO ted_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tii ‑do a ‑gbɛ 'yri, 'kee nɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ ‑Juukʋɛ a ye'mʋnaanyʋ, ʋ 'kukue lɛ, 'ke 'le ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑tɛ. Nahuon a ‑gbɛ a 'dʋ mɔ Kaifʋ; ");
INSERT INTO ted_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ʋ 'bii, 'ʋ ‑yrɩ, 'ke bʋ nu gblagblʋ, bʋ klɩ ‑Yusu, ‑ɛ die nu, ʋ 'muo 'la. ");
INSERT INTO ted_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Kɛ ʋʋ po, ʋ nɔ: «'Bɩa ꞊ba nyo klɩ, ‑a 'nɩ nue 'le lɛ'mimre a ti 'yri, ‑ɛ die nu, nahuin 'nɩ ꞊han ‑a mʋ ‑wɔn di ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ti a ‑gbɛ 'yri, 'ke ‑Yusu nɩ 'le Betanidɩɔ 'mʋ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. 'Ke ʋ nɩ 'le Simɔ a ‑tɛ. Simɔ a ‑gbɛ, ‑tɔplɩ ‑jɔhʋɩn nuo la. ");
INSERT INTO ted_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Bʋʋ 'klɛɛ dɛ di, ‑ye nyrʋgba ꞊de, nɔ‑ pa kayu gbo, 'ɔ 'ble ‑dawinniyrɩɛ kwa. ‑Dawinni a ‑gbɛ, ɩ kɔ 'a 'yrɩɛ 'hɛɛn, ɩɩ po ꞊die 'dɔ. ‑Tɛ ɔ pa 'klɛɛ, ‑ye ɔ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, 'ɔ 'wlaa 'o ‑Yusu ‑dawinni a ‑gbɛ 'lu. ");
INSERT INTO ted_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","‑Tɛ ‑Yusu a ‑naagbopʋ 'ye dɛ a ‑gbɛ, ‑ye ʋ bi 'mʋ lɛ yrʋ, ʋ nɔ: «Dɛ‑ kɔ ‑dawinni a ‑gbɛ a 'mʋlɛcɩcralɛ 'le? ");
INSERT INTO ted_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","'Bʋ pli wɛn, ɩ di wɛn 'ye 'wliyɛ 'dɔ, ʋ 'mue wɛn ꞊sʋɛnyʋ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","‑Tɛ ‑Yusu 'ye, ‑ɛ mɔ, ʋ bi 'mʋ lɛ yrʋ, ‑ye ɔ nɔ: «Ba ‑hɩɔ mɛ lɛ, ba 'kee 'a 'nyrɛ꞊hɩnhɩɛn! Dɛ ‑gbo, ɔ nu, 'ke 'o 'mʋ ‑wɔn, ɛ mɔ 'yilɛnɔdɛ'ɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ba kɔ 'a yiyie, ꞊sʋɛnyʋ 'kɩɛ die nɔ 'a mʋ ‑gbahlɔn nɩ, a 'mu ꞊hapʋdɛ 'mʋ nu. Kɛɛ, 'mɛ ‑ye, ti 'n di nɔ 'a mʋ ‑gbahlɔn ‑hi, ɩ 'de 'klɛɛ lele ‑huo. ");
INSERT INTO ted_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Dɛ ꞊nʋ, nyrʋgba ‑gbo, ɔ nu, nɛ‑ mɔ: ɔ 'wlaa 'na ‑plahʋɩn klɛ ‑dawinni ‑dodo, 'ke 'o 'na ‑plahʋɩn a ‑gbɛ a 'o‑hɩhɩa a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ɛ nɩ ‑tɛgbi, ʋ di 'o Nyɩsʋa a ꞊hapʋtitie 'o poo, kɛ nɔ ‑tʋtʋ ke, ꞊hapʋdɛ ‑gbo, nyrʋgba ‑gbo, ɔ nu, ʋ di 'a ‑tɩ ‑wɔn lɛ 'nɩ na, ‑ɛ die nu, ɩ 'nɩ ꞊han nahuin ‑wɔn ‑hri.» Kɛ ‑Yusu po. ");
INSERT INTO ted_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu a ‑naagbopʋyu ‑ye, 'ke 'le 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ ‑gbahlɔn, ‑ɔ kɔ 'dʋ mɔ Judɩa Yisikalio, nɔ‑ mu 'le Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ ‑wɔn, ");
INSERT INTO ted_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","‑ye ɔ nɔ: «'Bɩa 'nɩ po 'a mʋ ‑Yusu kwa, dɛ tio‑ a di 'mʋ ‑nyi 'le?» 'ʋ ‑nyi ꞊nɔ 'wliyɔ a (30) ‑wlʋ ꞊tu 'o ‑pu. ('Wliyɛ a ‑gbɛ, ɛ ‑huo 'dɔ.) ");
INSERT INTO ted_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kʋɛ 'o ti a ‑gbɛ 'yri gbo, Judɩa, ɔɔ lɛ ꞊mɔ ꞊hapʋ꞊tɔ, ‑tɛ ɔ di nu, ɔ 'mʋ ꞊nʋ ‑Yusu kwa po. ");
INSERT INTO ted_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lɛ'mimre ꞊nʋ, ‑ɛ mɔ Pakɩ, 'a ye‑hɛ‑nyrɔwɔ 'mʋ, 'ke ʋʋ 'o 'flɔɔdʋ ꞊nʋ dii, ‑ɔ kɔ ‑wɔn ʋ 'nɩnɩ po 'le 'yaadɛ. ‑Tɛ ‑nyrɔwɔ a ‑gbɛ, ɔ nyre 'o, ‑ye ‑Yusu a ‑naagbopʋ mu 'o ‑Yusu 'hʋɩn 'mʋ nɩ, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: «‑Be' ‑nɩɩ ‑hʋa ‑ba pii 'klɛɛ Pakɩ a dididɛ ye 'le?» ");
INSERT INTO ted_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «Ba mu 'le Jrusrɛdɩɔ 'mʋ, 'ke 'le nahuon ꞊nʋ ‑wɔn, ‑ɔ kɔ ‑tɩ 'n ꞊tu 'a mʋ ye, ba lo, ‑ɛ mɔ: ‑A nɩ tɔɔnyɔ nɔ 'nɩ, 'a ti ꞊nʋ, Nyɩsʋa wa 'dʋ, ɩ nyre 'o ꞊o. Kɛ nɔ ‑mʋ ‑wɔn, kɛ'ɛ nɩ, ɔ di nɔ Pakɩ a dididɛ dii, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn,» ");
INSERT INTO ted_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","'a ‑naagbopʋ 'ʋ nu dɛ ꞊nʋ, ‑Yusu le ꞊nʋ, 'ʋ pi Pakɩ a dididɛ a ‑gbɛ. ‑Tɛ ʋ ‑wɔ 'a pipie ‑wɔn, ‑ye ʋ ‑mɛ de. ");
INSERT INTO ted_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","‑Tɛ 'yrʋ ‑wɛ 'le yakɔ 'mʋ lɛ, ‑ye ‑Yusu kɔ 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ 'hɛɛn, ʋ nyre 'le kayu ꞊nʋ gbo nɩ, ‑ʋ kɔ gbo ʋ di 'le Pakɩ a dididɛ dii, 'ʋ nɩ gblɛ, 'ʋ ‑tʋa dɛ a didie gbo. ");
INSERT INTO ted_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Bʋʋ 'klɛɛ dɛ di, ‑ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon nɩ nɔ 'a mʋ ‑hɛyri. Nɔ‑ di 'mʋ 'na yraanyʋ kwa po, ‑ʋʋ 'na 'lɩla lɛ ꞊mɔ.» ");
INSERT INTO ted_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Bʋ 'wɔn ‑tɩ ꞊nʋ, ‑Yusu ꞊tu, ‑ye 'waa ꞊wlɩ 'mʋɛ gbo, 'ʋʋ ‑dodo po, 'ʋʋ ‑Yusu wlɔn lɛ ꞊gba: «Kʋkɔnyɔ o, ꞊be 'mɔɔ nɩ?» ");
INSERT INTO ted_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Ke 'le 'a mʋ ‑hɛyri, 'ke nahuon nɩ 'le, ‑ɔ kɔ 'mʋ 'hɛɛn‑ 'nyra 'le dɛdihuoo ‑do wlɔn dabʋ. Nɔ‑ɔ nɩ, ‑ɔ die nu. ");
INSERT INTO ted_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","'Ɛ mɔ ‑tɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n kɔ ꞊bo 'kʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ʋ nu la 'a 'crɩɩlɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, kɛɛ, 'jrɔ 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ di 'mʋ 'na yraanyʋ a ‑gbɛ kwa po. Ɛ nɔɔ 'o lɛ, 'ke ʋ nɩ kɔ 'le wɛn nahuon a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","‑Ye Judɩa ꞊nʋ, ‑ɔ di ‑Yusu 'a yraanyʋ kwa po, ɔ ꞊gbɔ ‑wɛ wlɔn, ɔ nɔ: «Tɔɔnyɔ o, ꞊be 'mɔɔ nɩ?» ‑Ye ‑Yusu nɔ: «Iin, ‑mɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Bʋ 'kɩɛ nɩɛ 'o dɛdihuo ke, ‑ye ‑Yusu 'ba 'mʋ 'flɔɔ, 'ɔ ‑nyi Nyɩsʋa 'wio, 'plɩɩ 'ɔ 'bɩɔ ꞊tɩɔ lɛ, 'ɔ ‑nyo 'a ‑naagbopʋ, ɔ nɔ: «Ba 'bɔ 'mʋ, ba dio. Nɔ‑ mɔ 'na 'hʋɩn.» ");
INSERT INTO ted_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","‑Ye ɔ 'ba lele 'mʋ ‑wiin‑gaʋwɔ, 'ɔ ‑nyi Nyɩsʋa 'wio, 'ɔ ‑nyo ꞊nʋ, ɔ nɔ: «A 'bii, ba 'na. ");
INSERT INTO ted_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nɩ‑ mɔ 'na dablo. Nɔ‑ 'n di gbo 'wla, 'ke 'o nahuin 'plɔplɔ a ‑ta 'mʋ, Nyɩsʋa 'muo nu, ɔ 'mʋ 'yrɩ yrayrɩ ꞊tue, ɔ kɔ ‑tʋnahuin 'hɛɛn, ‑ɛ die nu, ɔ 'mʋ 'waa dɛ 'kuku 'wʋwla. ");
INSERT INTO ted_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","'Nɩɩ 'a mʋ 'nɩ le, kʋɛ 'klɛɛ mɔ gbo, 'n 'deɛ ꞊bo 'na 'klɛɛ lele nɔdʋ ‑gbo, ɛ 'mue gba ‑gbagba, ‑nyrɔwɔ ꞊nʋ, ɔ 'mʋ 'o nyre, ‑ɔ kɔ 'kwli 'mʋ 'n di 'o lele nɔ yrayrɩdʋ ‑ye ꞊nʋ 'naa, 'n kɔ 'a mʋ 'hɛɛn, 'ke 'le 'na Bu Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ʋ bre ‑wla, 'plɩɩ 'ʋ 'ba ye 'mʋ, 'ʋ ꞊tɩ 'dɩɔ 'mʋ, 'ʋʋ 'le dʋgba ꞊nʋ 'lu mu, ‑tɛ ti nɩ 'le, ʋʋ olifie daa. ");
INSERT INTO ted_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","‑Tɛ ʋ nyre 'le, ‑ye kɛ ‑Yusuu 'a ‑naagbopʋ ye po, ɔ nɔ: «'Tɔyrʋwɔ ‑gbo 'kwli 'mʋ, ti di 'o 'nɩ nyre, a 'mʋ 'mʋ 'hʋɩn 'mʋ lɛ ‑gbɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ʋ nu la 'a 'crɩɩlɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Nyɩsʋa nɔ 'nɩ: 'N di 'blakɔnyɔ 'nɩ 'la, blablɔ a ꞊ju 'mʋ lɛ ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","‑Ye kɛ ‑Yusu nyu lele ye po, ɔ nɔ: «'Bɩa 'nɩ 'kʋ, 'nɩ 'hrɩ lele 'klɔ, 'ke 'n di 'le Galileblʋgba 'mʋ mu, 'mʋ 'le 'a mʋ ‑pree.» ");
INSERT INTO ted_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","‑Ye Piɛlɩɩ wun 'nɩ po, ɔ nɔ: «꞊Betɩ ʋ 'bii bʋ hie 'o ‑mʋ gbo, 'na ‑gbɛ, 'n 'die 'le ‑wɛ ꞊bo hie 'o ‑mʋ gbo gbe.» ");
INSERT INTO ted_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","‑Ye ‑Yusu nɔ: «'Nɩɩ ‑mʋ 'nɩ le ‑tɛɛ: 'Tɔyrʋwɔɔ ‑do ‑gbo 'kwli 'mʋ, 'plɩɩ hapɛ 'mʋ ‑nyrɛ mu da, ‑n di nu 'na ‑wɔn‑gaawɩɩ ta, ‑ɛ mɔ, ‑n 'de 'mʋ yi.» ");
INSERT INTO ted_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","‑Ye Piɛlɩ ꞊tuo ‑wɔn, ɔ nɔ: «'Ʋʋn, ꞊betɩ ꞊bo di 'kʋ, 'n kɔ ‑mʋ 'hɛɛn, 'n 'die 'le ‑wɛ ꞊bo ꞊tui, ‑ɛ mɔ, 'n 'de ‑mʋ yi.» ‑Ye ‑naagbopʋ 'bii, ‑tɩɩ ‑do ꞊nʋ, Piɛlɩ ꞊tu, nɩ‑ ʋ ꞊tu ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ nyre 'le 'dɩdɔti a ‑ci ꞊nʋ ke nɩ, ʋʋ Gɛsɩmanɩ daa. ‑Ye kɛ ɔɔ 'klɛɛ ꞊nʋ ye po, ɔ nɔ: «Ba nɩ mɔ gbo, ꞊bo mu 'le ye 'mʋ, 'mʋ 'le Nyɩsʋa ‑wɔn 'prɛɛ.» ");
INSERT INTO ted_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","‑Tɛ ɔɔ 'klɛɛ mu, ‑ye Piɛlɩ kɔ Sebede a 'yuo Sakɩ kɔ Saan 'hɛɛn, nʋ‑ ɔ da, ɔ kɔ ꞊nʋ 'hɛɛn 'ʋ mu. ‑Ye tii ‑do a ti 'yri, 'a ꞊wlʋ 'mʋɛ gbo, hʋannʋ 'ʋ nyo nu 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","‑Ye kɛ ɔɔ ꞊nʋ ye po: «'Na ꞊wlʋ 'mʋɛ gbo 'dɔ. 'Na ꞊wlʋ a gbo'mʋmʋɛ a ‑gbɛ, ɛɛ ‑hʋa bɛ 'la 'mʋ. A kɔ 'mʋ 'hɛɛn, ‑ba nɩ mɔ gbo, a nɩ ŋmo 'le,» ");
INSERT INTO ted_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","'ɔ hren ꞊nʋ ‑wɔn dɛ gbi, 'ɔ bla kwlɩ gbo, 'ɔ kɔ 'lu gbo, 'ɔɔ Nyɩsʋa lɛ 'batɩ, ɔ nɔ: «'Na Bu o, 'bɩa 'bɛ ‑wɛ 'le, nue, 'ke ꞊sʋɛ ‑gbo, 'n kɔ ꞊bo 'ye, bɛ hren 'mʋ ‑wɔn. Kɛɛ, ɛ 'de dɛ ‑gbo, 'nɩɩ ‑hʋa, kɛɛ, dɛ ꞊nʋ, ‑nɩɩ ‑hʋa, nɛ‑ bɛ 'ya.» ");
INSERT INTO ted_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bɔ nu lɛ 'pʋprɛ, ‑ye ɔ ꞊hɩan ‑wɔn, 'ɔ mu 'o 'a ‑naagbopʋʋ ta ꞊nʋ 'hʋɩn 'mʋ, 'ɔ yʋ 'o ŋmla a ŋmoolɛ 'mʋ gbo. ‑Ye kɛ ɔɔ Piɛlɩ ye po: «꞊Be a 'die 'le ‑wɛ ba nu ‑hawɔɔ ‑do, a kɔ 'mʋ 'hɛɛn, 'ke ba 'de ŋmo? ");
INSERT INTO ted_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","A nɩ ŋmo 'le, kɛɛ, ba da Nyɩsʋa, ‑ɛ die nu, dɛ 'bɛ nyre 'o, 'bɛɛ 'a mʋ 'mʋ lɛ ꞊tɔ, 'ke ba ‑haa Nyɩsʋa a ‑tɩ lɛ, a 'nɩ ꞊han 'a ‑tɩ lɛ ‑haa. 'N yie nɩ, ‑ɛ mɔ, 'a nɩ ꞊wlɩ nye 'nɩ ‑hʋa 'dɔ, 'ke a nɩ ŋmo 'le, a 'mʋ Nyɩsʋa da, kɛɛ, 'bɩa 'nɩnɩ ‑hɛ 'a mʋ 'mʋ, a 'de 'klɩ kɔ, 'ke ba nu dɛ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Bɔ po 'klɛɛ lɛ, ‑ye ɔ hren lele ꞊nʋ ‑wɔn, ‑do 'hɔn a kɔ, 'ɔɔ lele Nyɩsʋa lɛ 'batɩ, ɔ nɔ: «'Na Bu o, 'bɩa 'bɛ 'die 'le ‑wɛ, 'ke ꞊sʋɛ ‑gbo, 'n kɔ ꞊bo 'ye wɛn, bɛ hren 'mʋ ‑wɔn, ‑ye dɛ ‑gbo, ‑nɩɩ ‑hʋa, nɛ‑ bɛ 'ya.» ");
INSERT INTO ted_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","‑Tɛ ɔ ‑wɛ lele ‑wɔn, ‑ye 'ke ɔ mu 'o lele ꞊nʋ 'hʋɩn 'mʋ, 'ɔ yʋ 'o lele ŋmlaŋmoolɛ 'mʋ gbo, ‑ɛ nue, ʋ 'die 'le ‑wɛ, bʋ po 'yii lɛ. ");
INSERT INTO ted_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","‑Ye ɔ hren lele ꞊nʋ ‑wɔn, 'ɔɔ Nyɩsʋa lɛ 'batɩ, gblo a ta a nɔnɔ, 'ke 'le wiin ‑do ꞊nʋ 'kwli 'mʋ, ɔ po wɛn. ");
INSERT INTO ted_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","‑Ye ɔ ꞊hɩan lele ‑wɔn, 'ɔ mu 'o 'a ‑naagbopʋ 'hʋɩn 'mʋ, ɔ nɔ: «꞊Be aa lele 'nɩ ŋmo, 'aa 'le ke lɛ ‑ha? Ba 'ye kɛ, ti 'mʋɛɛ yrɛ, 'ke bʋ po 'mʋ dɛ'kukununyʋ kwa, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon. ");
INSERT INTO ted_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ba 'ba ye 'mʋ, ‑a 'mʋ mu, ‑ɛ nue, nahuon ꞊nʋ, ‑ɔ di 'mʋ 'na yraanyʋ kwa po, ɔɔ 'le 'nɩ di.» ");
INSERT INTO ted_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Win nɩ 'le ‑Yusu wlɔn, ‑ye Judɩa, ‑ɔ mɔ ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn a nahuon ‑ye, ɔ nyre 'o ꞊o, ɔ kɔ nahuin 'plɔplɔ 'hɛɛn. Nahuin a ‑gbɛ, ʋ 'ble kwa lɛ ta‑wɔnpliei kɔ ti 'hɛɛn. Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ ‑Juukʋɛ a ye'mʋnaanyʋ ‑ye 'hɛɛn, nʋ‑ le nahuin a ‑gbɛ, 'ke bʋ mu ‑Yusu klɩ. ");
INSERT INTO ted_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judɩa, ‑ɔ di ꞊nʋ ‑Yusu kwa po, 'plɩɩ ɔ kɔ ꞊nʋ 'hɛɛn, ʋ 'mʋ 'hru wlɔn mu bi, kɛ ɔ po ꞊nʋ ye: «Nahuon ꞊nʋ, 'n di 'mʋ 'wlɛɛ, 'ke 'o 'a 'wio a gbopupue ‑wɔn, nɔ‑ ba klɩ, ɔ 'nɩ ꞊han 'a mʋ kwa ꞊ta.» ");
INSERT INTO ted_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","‑Tɛ ʋ nyre 'klɛɛ 'o, ‑ye Judɩa a ‑gbɛ, ɔ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, ɔ nɔ: «Tɔɔnyɔ o, 'n yɛ ‑mʋ ke,» 'ɔ 'wlɔɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","‑Ye ‑Yusu nɔ: «'Mɛ o, dɛ ‑gbo, ‑n di nu wɔn, nue, ꞊nɩ ‑wlɛn 'le gbo.» ‑Ye tii ‑do a ti 'yri, nahuin ꞊nʋ, Judɩa gba, ʋ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, 'ʋ klo. ");
INSERT INTO ted_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑kʋannunyɔ ‑ye, nɔ‑ nɩ ‑wɛ 'o ‑tuo ke. ‑Ye ‑Yusu a ‑naagbopʋyu ‑ye, ‑ɔ nɩ 'o ꞊nɔ 'hʋɩn 'mʋ, nɔ‑ ‑ha 'le 'a 'plie bɔ wlɔn, 'ɔ 'bɛ ‑kʋannunyɔ a ‑gbɛ nʋa 'lu. ");
INSERT INTO ted_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","‑Ye kɛ ‑Yusuu ꞊nɔ ye po, ɔ nɔ: «Po 'le ‑na 'plie bɔ wlɔn, ‑ɛ nue, nahuin 'bii ꞊nʋ, ‑ʋʋ 'plie nu, ‑ʋʋ ‑wɔn, nahuin ‑ye di ‑wɛ nu 'plie, ʋ 'mu 'la. ");
INSERT INTO ted_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","‑N 'die yi, ‑ɛ mɔ, 'n ‑wɛ 'le ꞊bo le wɛn 'na Bu nɩ, 'ke bɔ ‑hɛ wɛn 'mʋ 'mʋ, ‑ye ɔ di wɛn 'mʋ ye ya 'a lɛleenyʋ a 'milowɩ a 'milowɩ, ‑ɛ die nu, ʋ 'mʋ wɛn 'mʋ ke dii. ");
INSERT INTO ted_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kɛɛ, 'bɩa 'bɛ nɩ wɛn lɛ 'mʋ, ‑ye dɛ ꞊nʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ kɔ ‑bɛ mue la 'lu ‑wɔn, dɛ a ‑gbɛ, ɛ 'deɛ bɛ mue wɛn 'lu ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","‑Ye kɛ ‑Yusuu nahuin ꞊nʋ ye po, ‑ʋ dio klɩ wɔn, ɔ nɔ: «Ta‑wɔnpliei kɔ ti 'hɛɛn, nɩ‑ a nu, 'a di 'mʋ klɩ wɔn, ‑tɛ ʋʋ nu, 'ʋʋ ‑balʋnyɔ klɩ. Kɛɛ, 'ɛ nɩ ti, 'n nɩ o gbo, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ke 'le 'a mʋ ‑hɛyri, 'nɩɩ o nahuin tɔɔ, kɛɛ, 'a 'de o 'mʋ a klee. ");
INSERT INTO ted_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kɛɛ, ‑tɔplɩ 'bii ‑gbo, ɩ mue ‑wɔn 'lu, ‑ɛ die nu, ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɩ 'mʋ nue.» ‑Tɛ ‑Yusu po 'klɛɛ lɛ, ‑ye 'a ‑naagbopʋ 'bii, ʋ ‑gbɛ ꞊nɔ 'mʋ lɛ 'hʋɩn, 'ʋ 'gba ci lɛ. ");
INSERT INTO ted_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye nahuin ꞊nʋ, ‑ʋ klɩ ‑Yusu, ʋ gbɔ nɩ, 'ke 'le Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka a kayu gbo. Nahuon a ‑gbɛ a 'dʋ mɔ Kaifʋ. 'Ke 'le kayu a ‑gbɛ gbo, 'ke Nyɩsʋa a teteitɔɔnyʋ, kɔ 'blʋgba a ye'mʋnaanyʋ 'hɛɛn, ʋ 'kukue 'le lɛ, 'ke 'o ‑gboligbo a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛlɩ ‑mɛ ‑ye, nɔ‑ɔ ‑Yusu ‑wɔn kʋɛ, 'ke 'le ‑wɔnhinhrenkɔ 'kwli 'mʋ, 'ʋ nyre 'le ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑yaa 'mʋ, 'ɔ pa ‑wɛ 'le. Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ nɩ ‑wɛ 'le. Nʋ‑ kɔ ‑hɛyri Piɛlɩ nɩ 'le gbo, ‑ɛ die nu, ɔ 'mue 'ye, ‑tɛ ‑tɩ a ‑gbɛ, ɩ di 'le‑wʋwɛ nu. ");
INSERT INTO ted_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","'Ke 'le kayu gbo, ‑cɔhlʋnpinyʋ gblakɩ kɔ ‑gboligbo a nahuin 'bii 'hɛɛn, ʋ nye lɛ 'nɩ ꞊mɔ, 'ke bʋ yɛɛ ‑Yusu ‑tɩ, mɔ ꞊betɩ bɛ 'ya hɩ 'mʋ, ‑ɛ die nu, ʋ 'muo 'la, ");
INSERT INTO ted_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kɛɛ, ʋ 'de 'le ꞊nɔ kɩkadɛ ꞊de 'mʋ 'yee, ꞊betɩ ‑hɛhɩpʋ 'plɔplɔ bʋ di 'le, bʋ 'ma ꞊nɔ hɩ 'lu gbo. Nɛ‑ ʋ nu ‑nunu, nahuiin 'hɔn 'ʋ ꞊plu 'o, ");
INSERT INTO ted_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ʋ nɔ: «Nahuon ‑gbo, kɛ ɔ po o, ɔ ‑wɛ 'le bɔ 'wla Nyɩsʋa a 'kagblaka nɩ, 'plɩɩ bɔ pu lele nɩ, 'ke 'le ‑nyrɔwɩɩ ta 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","‑Ye ‑cɔhlʋnpinyʋ a nyɩgblaka 'ba 'mʋ ye, 'ɔ ꞊gba ‑Yusu wlɔn, ɔ nɔ: «꞊Be ‑tɩ 'bii ‑gbo, nahuin ‑gbo, ʋʋ ‑mʋ yɛɛ, ‑n 'de ‑tɩ ꞊de kɔ, ‑bo di ‑wɔn ꞊tu?» ");
INSERT INTO ted_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kɛɛ ‑ye ‑Yusu 'de ꞊nɔ ‑tɩ ꞊de klɛ ‑hɩhɩa. ‑Ye ‑cɔhlʋnpinyʋ a nyɩgblaka ꞊gbɔ lele wlɔn, ɔ nɔ: «'N nye 'nɩ ‑hʋa, 'ke ‑bo 'sʋɛ ke, 'ke 'le 'Klɔhienyɩsʋa a 'dʋ 'kwli 'mʋ, 'bɩa ꞊nɩ 'ya Waanyɔ ꞊nʋ 'mʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, kɔ, 'bɩa ꞊nɩ 'ya ‑wɛ Nyɩsʋa a 'Yu 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","‑Ye ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Iin, 'mɔɔ nɩ. 'Nɩɩ 'a mʋ 'nɩ le, kʋɛ 'klɛɛ mɔ gbo, a di 'mʋ 'nɩ 'ye, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mʋ 'o 'Klɩkenɩnyɩsʋa a diidɛpɩa ke gbo nɩ, 'mʋ 'le yakɔ 'mʋ ‑hɔn, 'ke 'le 'nugbɩ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","‑Tɛ ‑Yusu po 'klɛɛ lɛ, ‑ye ‑cɔhlʋnpinyʋ a nyɩgblaka cɩcra 'a ‑gbɛ a wlawlʋ lɛ, ‑ɛ nue, ɔɔ po yrʋ 'dɔ, ɔ nɔ: «Ɔ ‑haa Nyɩsʋa a ‑tɩ lɛ. ‑A 'nɩ ꞊mɔ 'le 'klɛɛ lele ‑hɛhɩnyɔ ꞊de lɛ. 'A nɩ ‑gbɛ, a 'wɔn ‑tɩ ‑gbo, ɔ ꞊tu nɩ. A 'wɩn nɩ, ‑tɛ ɔ nu Nyɩsʋa a ‑tɩ a lɛ‑haalɛ. ");
INSERT INTO ted_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","‑Be' aa 'klɛɛ po 'le?» ‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, ɔ ‑haa Nyɩsʋa a ‑tɩ lɛ. 'A ‑tɩ, ɔ nɩ 'mʋ 'kʋkʋɛ.» ");
INSERT INTO ted_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","‑Ye ʋ ‑tʋa 'a hɩɔn a 'hinhren gbo, 'ke 'o 'a yigbakla ye, kɔ, 'ʋ nyo ŋmli bii, ꞊ʋ ‑ye 'ʋ nyo 'le 'ŋmɩ nʋɩ 'mʋ lɛ po, ");
INSERT INTO ted_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ʋ nɔ: «‑Mɔ ꞊nʋ, ‑ɔ mɔ Waanyɔ, ‑mɔ mɔ winwlɔn‑hɛnyɔ. 'A ‑tɩ, le ‑a mʋ, nahuon tio‑ ꞊tu ‑mʋ dɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","‑Tɛ ‑tɔplɩ a ‑gbɛ, ɩɩ 'lu ‑wɔn mue, ‑ye 'ke Piɛlɩ 'kɩɛ nɩɛ 'le ‑yaa 'mʋ. ‑Ye 'yu nyrɔyu ꞊de, ‑ɔ mɔ kayu ꞊nʋ a ‑kʋannunyrɔ, nɔ‑ 'yɩyɔ 'o 'hʋɩn 'mʋ gbo, ɔ nɔ: «‑Mɔ ‑gbo, ‑n kɔ ‑Yusu ꞊nʋ 'hɛɛn, ‑ɔ kɔ 'le Galileblʋgba 'mʋ, 'a mʋ‑ʋ o 'hʋɩn 'mʋ nɩna.» ");
INSERT INTO ted_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kɛɛ ‑ye Piɛlɩ ‑ga nɩ, 'ke 'o nahuin 'bii ꞊nʋ ye, ɔ nɔ: «‑Tɩ ‑nɩɩ ꞊tu, 'nɩ yrii ꞊le 'mʋ lɛ,» ");
INSERT INTO ted_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","'ɔ ‑hʋɔn 'o 'hʋɩn 'mʋ, 'ɔ mu 'le ‑yaa a ‑gbɛ a paalɛ 'mʋ. ‑Ye 'yu nyrɔyu ‑ye 'yo lele nɩ, 'ɔ le nahuin ꞊nʋ, ‑ʋ nɩ 'o, ɔ nɔ: «Nahuon ‑gbo, aa 'ye, ɔ kɔ Nasalɛtɩ 'mʋ a ‑Yusu 'hɛɛn, nʋ‑ʋ o 'hʋɩn 'mʋ nɩna.» ");
INSERT INTO ted_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","‑Ye Piɛlɩ ‑ga lele nɩ, ɔ nɔ: «'N 'sʋɛ ke, nahuon ‑gbo, ‑ɔ kɔ ‑tɩ aa ꞊tu, 'n 'dio yi.» ");
INSERT INTO ted_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ti gbi bɩ ‑hi, ‑ye nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'yɩya 'o Piɛlɩ 'mʋ gbo 'hʋɩn, ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, ‑mɔ mɔ ‑Yusu a ‑naagbopʋyu ‑yee nɩ, ‑ɛ nue, ‑tɛ ‑nɩɩ 'pʋprɛ nu, ɛ nye ‑a mʋ 'nɩ tɔɔ, ‑ɛ mɔ, 'ke ‑n kɔ ‑wɛ 'le Galileblʋgba 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","‑Ye ɔ nɔ: «Nyɩsʋa bɔ po 'mʋ 'jrɔ ‑wɔn, 'bɩa 'nɩ 'du hɩ lɛ. 'N 'sʋɛ ke, nahuon ‑gbo, ‑ɔ kɔ ‑tɩ aa ꞊tu, 'n 'dio yi.» Tii ‑do a ‑gbɛ 'yri, ‑ye hapɛ da ‑nyrɛ. ");
INSERT INTO ted_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","‑Ye ‑tɩ ꞊nʋ, ‑Yusu ꞊tu wɛn ꞊nɔ ye, ɩ bi 'le ꞊nɔ 'mʋ 'kwli, ‑ɩ mɔ: «'Plɩɩ hapɛ 'mʋ ‑nyrɛ mu da, ‑n di nu 'na ‑wɔn‑gaawɩɩ ta, ‑ɛ mɔ, ‑n 'de 'mʋ yi.» ‑Tɛ ɩ bi 'klɛɛ 'le ꞊nɔ 'kwli 'mʋ, ‑ye ɔ 'hrɩ 'le ‑yaa 'mʋ nɩ, 'ɔ ‑tʋa wuwe gbo, 'kla‑wliye'yɩya a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ 'bii, ʋ 'kukue lele lɛ, ʋ kɔ ‑Juukʋɛ a ye'mʋnaanyʋ 'hɛɛn, 'ʋ ‑yrɩ, 'ke bʋ 'la ‑Yusu. ");
INSERT INTO ted_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","‑Ye ʋ nɔ: «‑Ba le ‑a nɩ 'sɔyuo, bʋ mʋɔ, ʋ 'muo 'le ‑gʋlʋnʋma Pilatɩ ye gba.» (Pilatɩ a ‑gbɛ, Romakʋɛ a 'kɩɩn gblaka, nɔ‑ ꞊tuo la 'o gbata ke gbo.) ");
INSERT INTO ted_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","‑Tɛ Judɩa ꞊nʋ, ‑ɔ po ‑Yusu 'a yraanyʋ kwa, ɔ 'ye, ‑ɛ mɔ, ‑gboligbo a nahuin ‑yrɩ nɩ, 'ke bʋ 'la ‑Yusu, ‑ye ɔɔ lɛ po ꞊wlɩ, 'ke 'o dɛ ꞊nʋ, ɔ nu a ‑ta 'mʋ. Nɛ‑ nue, 'kla 'ɔ nyo ‑wliye 'ya. Nɛ‑ mɔ, 'wliyɔ (30) a ‑wlʋ ꞊tu 'o ‑pu ꞊nʋ, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ 'blʋgbaye'mʋnaanyʋ 'hɛɛn, ʋ ‑nyi o ꞊nɔ, bɔ gbɩ ꞊nʋ ye, 'ke 'le Nyɩsʋa a 'kagblaka gbo, ");
INSERT INTO ted_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","bɔ le ꞊nʋ, ‑ɛ mɔ: «'N nu dɛ 'kuku, 'ke ꞊bo po 'a mʋ nahuon ꞊nʋ kwa, ‑ɔ 'de dɛ ꞊de nu, ‑bɛ blɛ 'kʋkʋɛ ye.» Kɛɛ ‑ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «‑A mʋ ‑gbo, ‑a 'die 'le ‑wɔn kɔ. ‑Mɔɔ nɩ, ‑ɔ kʋɛ 'le ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Nɛ‑ mɔ Judɩa bɔ ‑gbla 'wliyɛ a ‑gbɛ lɛ, 'ke 'le Nyɩsʋa a 'kagblaka gbo, bɔ 'hrɩ, bɔ mu, bɔ 'ba 'a dɩɔnʋ gbo. ");
INSERT INTO ted_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","'Wliyɛ a ‑gbɛ, Judɩa ‑gbla lɛ, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ ‑mɛ ‑ye, ʋ 'tɩɛ lɛ, ʋ nɔ: «Ɛ mɔ dablowli'i nɩ. ‑A nɩ tetei nɔ 'nɩ, ‑a nɩ po 'le 'le 'wliyɛ a ‑gbɛ Nyɩsʋa a 'kagblaka a ‑drɔɔ wlɔn.» ");
INSERT INTO ted_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","‑Tɛ ʋ ꞊tu ‑tɩ a ‑gbɛ, ‑ye ʋ pue 'le ꞊le, 'ke bʋ nu 'wliyɛ a ‑gbɛ, bʋ ‑tɔ ‑ci ꞊nʋ, ʋʋ yɩnunyɔ a ‑ci daa, ‑ɛ die nu, ʋ 'mʋ ‑ci a ‑gbɛ 'dagbɩ a 'dɛɛi 'mʋ nuu. ");
INSERT INTO ted_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nɛ‑ nue, kʋɛ la 'le gbo, ‑bo yɛ ti ‑gbo ke, ‑ci a ‑gbɛ, 'ʋ nye dablo‑ci daa. ");
INSERT INTO ted_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","‑Tɛ dɛ a ‑gbɛ, ɛ mue 'lu ‑wɔn, ‑ye ‑tɩ ‑gbo, Nyɩsʋa a winwlɔn‑hɛnyɔ Selemi, ɔ 'crɩɩ la, ɩ nue kɛ nɩ. ‑Tɩ a ‑gbɛ, ɔ 'crɩɩ la, nɩ‑ ‑gbo: «Ʋ gba 'wliyɔ a ‑wlʋ ꞊tu 'o ‑pu ꞊nʋ nɩ, ‑ɛ mɔ 'wliyɛ ꞊nʋ, Yisraɛkʋɛ wɛɛn la ke, bʋ 'pɛɛ, 'ke 'o 'a ‑ta 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","'ʋ ‑tɔ yɩnunyɔ a ‑ci, ‑ɛ 'we ꞊nɔ ye, ‑tɛ Kʋkɔnyɔ Nyɩsʋa nu la 'a ꞊tutue.» ");
INSERT INTO ted_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","‑Yusu ‑mɛ ‑ye, 'ke ʋ gbɔ 'le ‑gʋlʋnʋma Pilatɩ ye, ‑gʋlʋnʋma a ‑gbɛ 'ɔ ꞊gbɔ wlɔn, ɔ nɔ: «꞊Be ‑mɔ mɔ ‑Juukʋɛ a bodɩɔ?» ‑Ye ɔ nɔ: «Iin, 'mɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","‑Ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ nyo yɛɛ 'dai ‑tɩ, kɛɛ, ‑Yusu 'de ‑tɩ ꞊de ‑wɔn ꞊tu. ");
INSERT INTO ted_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","‑Ye Pilatɩ ꞊gbɔ lele wlɔn, ɔ nɔ: «꞊Be ‑tɩ 'bii ‑gbo, ʋʋ ‑mʋ yɛɛ, ꞊be ꞊nɩ 'wɩn ꞊le?» ");
INSERT INTO ted_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kɛɛ, ‑Yusu 'de winbʋ ꞊de klɛ ‑hɩhɩa. Ɛ mɔ dɛ'ɛ nɩ, 'ɛ saka ‑gʋlʋnʋma Pilatɩ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","'Ɛ nɩ lɛ'mimre, ‑ɛ mɔ Pakɩ a ti 'yri, ‑gʋlʋnʋma Pilatɩ, ɔɔ ꞊ke gbo tɛ ꞊jɩnyɔɔ ‑do, ‑Juukʋɛɛ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","‑Ye 'klɛɛ, ti a ‑gbɛ 'yri, ɛ kɔ ꞊jɩnyɔ ꞊de. 'A 'dʋ mɔ Balabasɩ. Ɔ mɔ ‑balʋnyɔ'ɔ nɩ, nahuin 'ʋ yio ꞊ke. ");
INSERT INTO ted_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","‑Tɛ nahuin 'kukue 'klɛɛ lɛ, 'ke 'le Pilatɩ ‑wɔn, ‑ye Pilatɩ a ‑gbɛ, ɔ ꞊gbʋ wlɔn, ɔ nɔ: «Balabasɩ, kɔ ‑Yusu ‑gbo 'hɛɛn, ʋʋ Waanyɔ ꞊nʋ daa, Nyɩsʋa po la lɛ, ɔ di la 'le ya, nahuon tio‑ aa ‑hʋa ꞊bo tɛ gbo 'le?» ");
INSERT INTO ted_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kɛ ɔɔ 'pʋprɛ nu, ‑ɛ nue, Pilatɩ yie nɩ, ‑ɛ mɔ, 'ke 'le ca 'kwli 'mʋʋ nɩ, 'ke ‑Juukʋɛ a nyɩgblakɩ, ʋ poo 'o ꞊nɔ ‑Yusu kwa, ‑ɛ die nu, ɔ 'muo 'la. ");
INSERT INTO ted_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","‑Tɛ Pilatɩ a ‑gbɛ, ɔ nɩ 'o ‑batipoolɛ 'mʋ, 'a nyrʋgba 'ɔ yɔ win ye, ‑ɛ mɔ: «꞊Nɩ nu 'le nahuon ꞊nʋ dɛ ꞊de 'mʋ, ‑ɛ nue, ɔ 'de dɛ ꞊de nu, ‑ɛ nyre 'yi lɛ, ‑ɛ nue, 'tɔyrʋwɔ ‑gbo 'mʋ, 'ke 'le yain 'kwli 'mʋ, 'n 'ye ꞊sʋɛ 'dɔ, 'a ‑tɩ.» ");
INSERT INTO ted_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","‑Tɛ dɛ a ‑gbɛ, ɛɛ 'lu ‑wɔn mue, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ ‑Juukʋɛ a 'blʋ a nahuin 'hɛɛn, ʋ 'prɛɛ 'le nahuin ‑wɔn, 'ke bʋ le Pilatɩ, bɔ tɛ Balabasɩ gbo, bɔ 'la ‑Yusu. ");
INSERT INTO ted_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","‑Ye ‑gʋlʋnʋma Pilatɩ a ‑gbɛ, ɔ ꞊gbʋ lele wlɔn, ɔ nɔ: «Nahuiin 'hɔn ꞊nʋ ‑gbahlɔn, nahuon tio‑ aa ‑hʋa ꞊bo tɛ gbo 'le?» ‑Ye ʋ nɔ: «Balabasɩ!» ");
INSERT INTO ted_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","‑Ye Pilatɩ nɔ: «'Bɩa 'nɩ tɛ Balabasɩ gbo, dɛ tio‑ aa ‑hʋa ꞊bo nu ‑Yusu ‑gbo 'mʋ, ʋʋ Waanyɔ daa 'le?» ‑Ye ʋ 'bii, ʋ ꞊tuo ‑wɔn, ʋ nɔ: «Kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ!» ");
INSERT INTO ted_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","‑Ye Pilatɩ nɔ: «Dɛ 'klandʋ tio‑ ɔ nu 'le, ‑ɛ kɔ 'mɔ dio kɔɔ, 'ke 'o tu 'yie 'mʋ 'le?» Kɛɛ ‑ye ʋʋ 'le 'yaa win 'dɔ, ʋ nɔ: «Kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ!» ");
INSERT INTO ted_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","‑Ye Pilatɩ 'ye nɩ, ‑ɛ mɔ, ɔ 'die 'le ‑wɛ bɔ ꞊tu ‑wɔn, kɛɛ, 'waa ‑cici a lɛpupuee klɛ 'nɩ bii. Nɛ‑ nue, 'ɔ 'ba 'nie 'mʋ, 'ɔ yra kwa lɛ, 'ke 'o nahuin 'bii ꞊nʋ ye, 'ɔɔ ꞊nʋ le: «'Mɔ ‑gbo, 'n 'die ke wɛɛn, 'ke nahuon ‑gbo a dablo bɔ 'wlɛ gbo. 'A nɩ ‑gbɛ, 'a mʋ'ʋ nɩ, ‑ʋ ‑hʋɛ.» ");
INSERT INTO ted_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","‑Ye nahuin 'bii ꞊nʋ, ʋ ꞊tuo ‑wɔn, ʋ nɔ: «‑A nyra gbo, ‑a kɔ ‑a nɩ 'yuo꞊pli 'hɛɛn, 'ke 'o 'a 'kʋkʋɛ a ‑ta 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Bʋ po 'klɛɛ lɛ, ‑ye Pilatɩ tɛ Balabasɩ gbo, kɔ, 'ɔ le 'a 'sɔyuo, 'ke bʋ bii ‑Yusu lɔkʋɛ. ‑Tɛ ʋ bio 'klɛɛ, ‑ye kɛ ɔɔ 'a 'sɔyuo a ‑gbɛ ye po, ɔ nɔ: «Ba gbɔ, ba kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ!» ");
INSERT INTO ted_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilatɩ bɔ po 'klɛɛ lɛ, ‑ye 'a 'sɔyuo gba ‑Yusu nɩ, 'ke 'le Pilatɩ a ‑gbɛ a ‑yaa 'mʋ, ‑tɛ 'waa gbonɩɩlɛ nɩ 'o, 'ʋ da 'waa 'bienʋ 'sɔyuo 'bii. ");
INSERT INTO ted_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","‑Tɛ ʋ nyre 'klɛɛ 'o, ‑ye ʋ ‑hɛ ‑Yusu wlawlɩ, 'ʋ pue ꞊nɔ wlawlʋ ‑jɔhʋn, ");
INSERT INTO ted_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","kɔ, 'ʋ hraa ꞊nɔ 'witiklaʋn lɛ. 'Witiklaʋn a ‑gbɛ, nʋ‑ ʋ ꞊tu ꞊nɔ 'lu, kɔ, 'ʋ 'nyra ꞊nɔ kotu kwa 'mʋ, 'ke 'le 'a diidɛdabʋ 'mʋ, 'ʋ blɔ kwlɩ ye gbo, 'ʋ nyo 'caa, ʋ nɔ: «‑Na 'wio, ‑Juukʋɛ a bodɩɔ,» ");
INSERT INTO ted_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","'ʋ nyo hɩɔn 'hrin, kɔ, 'ʋ ‑ha ꞊nɔ kotu kwa, 'ʋ nyu ꞊nɔ 'lu lɛ waa. ");
INSERT INTO ted_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","‑Tɛ ʋ ‑wɔ 'klɛɛ 'a 'caalɛ ‑wɔn, ‑ye ʋ ‑hɛ ꞊nɔ wlawlʋ ‑jɔhʋn a ‑gbɛ nɩ, 'ʋ pue lele ꞊nɔ 'a ‑gbɛ a wlawlɩ, 'plɩɩ 'ʋ ꞊tɩɔ 'dɩɔ 'mʋ, 'ʋ nyo gba, 'ke 'le ‑tɛgbi ꞊nʋ, ʋ dio 'o tu 'yie 'mʋ kɔɔ. ");
INSERT INTO ted_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","‑Tɛ ʋʋ 'klɛɛ 'dɩɔ 'mʋ ꞊tɩ, ‑ye ʋ kɔ nyɩbɛyu ꞊de 'hɛɛn, nʋ‑ ꞊ŋmoo. Nyɩbɛyu a ‑gbɛ, 'a 'dʋ mɔ Simɔ. 'Ke ɔ kɔ 'le Silɛnɩdɩɔ 'mʋ. Nɔ‑ 'sɔyuo klɩ, 'ʋ nɩɔ 'o ke 'mʋ, 'ɔ 'ble tugbɛ ꞊nʋ, ‑ɛ kɔ 'yie 'mʋ ʋ di 'o ‑Yusu kɔɔ. ");
INSERT INTO ted_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","‑Ye 'ke ʋ nyre 'o ‑tɛgbi ꞊nʋ, ʋʋ Gɔlʋgɔta daa, ‑ɛ ꞊hɛn 'nyrɛ dʋgba ꞊nʋ, ʋʋ 'Lukla daa. ");
INSERT INTO ted_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","‑Tɛ ʋ nyre 'o, ‑ye ʋʋ ‑hʋa bʋ ‑nyi ꞊nɔ nɔ, ‑ɔ kɔ ‑wɔn ʋ po 'le ꞊wɛhɩ klaklɩ, 'ɔ ꞊tʋɔ wlɔn, kɛɛ, ɔ 'nɩ ‑hʋa ꞊le bɔ 'nɔ. ");
INSERT INTO ted_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","‑Tɛgbi a ‑gbɛ, 'ke ʋ kʋɔ 'o tu 'yie 'mʋ. ‑Ye ʋ po 'bla, ‑ɛ die nu, ‑Yusu a 'hʋɩn'mʋlɛpue‑tɔplɩ, ‑tɛ bʋ di 'a wuwe nu, ʋ 'mue yi. ");
INSERT INTO ted_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","'Kee nɩ, ʋ nɩ 'o gbo, ‑ɛ die nu, ʋ 'muo 'yie ꞊tu. ");
INSERT INTO ted_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","'Plɩɩ 'ʋ 'crɩɩ 'o 'plaɩnpɩa ke, ‑tɩ ‑kɔ ‑tɩ 'ʋ kʋɔ 'o tu 'yie 'mʋ. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «Nahuon ‑gbo, nɔ‑ mɔ ‑Yusu, ‑ɔ mɔ ‑Juukʋɛ a bodɩɔ.» Tu ꞊nʋ, ‑ʋ kɔ 'yie 'mʋ ʋ kɔɔ 'o ‑Yusu, nʋ‑ kɔ 'lu ye, 'ke ʋ 'maa 'o 'plaɩnpɩa a ‑gbɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tii ‑do a ‑gbɛ 'yri, 'ke 'o ‑Yusu 'hʋɩn 'mʋ, ʋ kɔɔ 'o ‑balʋnyʋʋ 'hɔn, 'ke 'o 'waa nɩ ti 'yie 'mʋ, ‑do ‑ye 'ke 'le 'a diidɛpɩa ke, ‑do ‑ye 'ke 'le 'a kamrapɩa ke. ");
INSERT INTO ted_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","‑Ye nahuin ꞊nʋ, ‑ʋʋ ‑hi, ʋ nyo ꞊tu tanɩ, 'plɩɩ 'ʋʋ 'o 'li lɛ ‑hie, ");
INSERT INTO ted_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ʋ nɔ: «‑Mɔ ꞊nʋ, ‑ɔ plɛ, ‑ɔ di o Nyɩsʋa a 'kagblaka 'wla, 'plɩɩ ‑ɔ diu o po, 'ke 'le ‑nyrɔwɩɩ ta 'kwli 'mʋ, 'bɩa ꞊nɩ 'ya Nyɩsʋa a 'Yu 'mʋ, waa ‑n dɩɔnʋ, ꞊mʋ 'o tu ꞊nʋ 'yie 'mʋ ‑hɔn, ꞊mʋ ꞊tɩ.» ");
INSERT INTO ted_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","‑Ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ teteitɔɔnyʋ, kɔ 'blʋ a nahuin ‑ye 'hɛɛn, ‑ʋ nɩ ‑wɛ 'o, ʋ nyo ‑wɛ ꞊tu tanɩ, ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Ɔ waa nahuin ‑ye nɩ, kɛɛ, ɔ 'de 'le 'a dɩɔnʋ a waalɛ ‑wɛ. 'Bɩa 'bɔ 'ya Yisraɛkʋɛ a bodɩɔ 'mʋ, bɔ ꞊tɩ 'o tu 'yie 'mʋ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo. 'Bɩa 'bɔ ꞊tɩ, ‑ye ‑a die pue ‑tɛɛ, ‑ɛ mɔ, nɔ‑ mɔ Waanyɔ. ");
INSERT INTO ted_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ɔ kuo Nyɩsʋa ye ꞊wlʋ. 'A ‑tɩ, Nyɩsʋa a ‑gbɛ, 'bɔ nʋɔ 'mʋ, ‑ye bɔ ‑hɩɔ 'mʋ. 'Be nahuon ‑gbo, ɔ ꞊tui nɩ, ‑ɛ mɔ, ɔ mɔ Nyɩsʋa a 'Yuu nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","‑Balʋnyʋʋ 'hɔn ꞊nʋ, ʋ kɔɔ 'o 'waa nɩ ti 'yie 'mʋ, 'ke 'o ‑Yusu 'hʋɩn 'mʋ, kɛ'ɛ nɩ, ʋ nu, 'ʋ nyo ‑wɛ tanɩ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","'Yrʋ bʋʋ 'o 'lu a ‑hɛyri 'mʋ mu nyre, ‑ye gbɩgbɩyrɩ ka ‑tʋtʋ 'bii ke. Gbɩgbɩyrɩ a ‑gbɛ, ɩ nɩ 'o ‑nɩnɩ, 'ɛ yɛ 'yrʋ‑hiilɛ a ti ke. ");
INSERT INTO ted_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","‑Tɛ 'yrʋ‑hiilɛ a ti a ‑gbɛ, ɩɩ 'o nyre, ‑ye ‑Yusu 'yaa 'le win, ɔ nɔ: «Eli, Eli, lama sabatani?» ‑ɛ ꞊hɛn 'nyrɛ: «Nyɩsʋa o, Nyɩsʋa o, dɛ‑ kɔ 'mɔ ‑n ‑ha 'yie ‑wɔn 'le?» ");
INSERT INTO ted_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nahuin ꞊nʋ, ‑ʋ nɩ ‑tuo ke, kɛ 'waa dɛ ‑yee po: «Nyɩsʋa a winwlɔn‑hɛnyɔ Eli, nɔ‑ ɔɔ da.» ");
INSERT INTO ted_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","'Ke 'le ꞊nʋ ‑hɛyri, ꞊ɔ ‑ye gba cigbɛi, tii ‑do a ti 'yri, 'ɔ 'ba ‑sapoo 'mʋ, 'ɔ 'nyrɔ 'lipanɔ ye, 'plɩɩ 'ɔ mʋɔ 'o tugbɛ ‑pɛtu 'lu lɛ, 'ɔ ‑nyo ‑Yusu, 'ke ɔ 'muo 'na. ");
INSERT INTO ted_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kɛ ꞊ʋ ‑yee po, ʋ nɔ: «‑Ba po 'o 'yie gbo, Eli 'bɔ di 'le di, 'bɔ dio 'mʋ ‑hɛ, ‑a 'mue 'ye.» ");
INSERT INTO ted_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","‑Ye ‑Yusu 'gbo lele nɩ, 'ɔ mra ‑hʋnhlʋn. ");
INSERT INTO ted_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ti a ‑gbɛ a ti 'yri, 'ke 'le Nyɩsʋa a 'kagblaka gbo, ‑ɔ nɩ 'le Jrusrɛdɩɔ 'mʋ, Nyɩsʋa nue nɩ, dagblaka ꞊nʋ, ‑ʋ 'bɛ kayu a ‑gbɛ ꞊tɩɔ, 'ʋ ‑ki wlɔn 'bii, kʋɛ 'le 'a 'lu ye gbo, ‑bo yɛ 'a bʋgbodɛ ke, ‑tʋtʋ 'ʋʋ 'hɩhrɔ, 'hɛ gblakɩ 'ɛɛ wlɔn lɛ ‑kiki, ");
INSERT INTO ted_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","'dɛɛi 'ɩɩ wlɔn lɛ ꞊gɩga, kɔ, Nyɩsʋa a nahuin 'plɔplɔ, ‑ʋ 'kʋ la, 'ʋ 'hrɩ 'klɔ, ");
INSERT INTO ted_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","'plɩɩ ‑nyrɔwɩɩ ta 'mʋ mu ‑hi, ‑ye ‑Yusu ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ 'hrɩ 'klɔ, nahuin a ‑gbɛ, 'ʋ ‑hɔn 'le 'dɛɛi wlɔn 'mʋ lɛ, 'ʋ pa 'le Jrusrɛdɩɔ 'mʋ, ‑ɔ mɔ Nyɩsʋa a 'dɩɔ, 'dai nahuin 'ʋ 'yu. ");
INSERT INTO ted_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","'Ke 'o ‑Yusu ꞊hlɔn, 'ke Romakʋɛ a 'sɔyuo a nyɩgblaka ‑ye nɩ 'o, ɔ kɔ 'a 'sɔyuo ꞊nʋ 'hɛɛn, ‑ʋ nyo 'yie ꞊tu. ‑Tɛ ʋ 'ye ‑tʋtʋ a 'hɩhrɔlɛ, kɔ ‑tɔplɩ 'bii ꞊nʋ, ‑ɩɩ 'lu ‑wɔn mue, ‑ye hʋannʋ biu 'le 'kwli 'mʋ, ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, nahuon ‑gbo, ɔ mɔ la Nyɩsʋa a 'Yuu nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nyrʋgbapʋ 'plɔplɔ nɩ 'o, 'ʋ hren ‑wɔn dɛ gbi, 'ʋʋ ‑tɔplɩ 'bii ꞊nʋ 'ye, ‑ɩɩ 'lu ‑wɔn mue. Nyrʋgbapʋ a ‑gbɛ, nʋ‑ʋ la ‑Yusu ‑wɔn naa, kʋɛ la 'le ti ꞊nʋ ‑kɔ 'yie 'mʋ gbo, ɔ nɩ la 'le Galileblʋgba 'mʋ, 'ʋ nyo la 'mʋ ‑hɛ. ");
INSERT INTO ted_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","'Ke 'le ꞊nʋ ‑hɛyri, 'ke Madala 'mʋ a Mari nɩ 'le, kɔ Mari ꞊nʋ, ‑ɔ mɔ Sakɩ kɔ Sosɩ a 'dii, kɔ Sebede a 'yuo a 'dii. ");
INSERT INTO ted_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","‑Tɛ 'tɔɔ ‑wɔn, ‑ye dɛkɔnyɔ ꞊de, nɔ‑ nyre 'o ‑tuo ke. 'A 'dʋ mɔ Sosɛfʋ. 'Ke ɔ kɔ 'le Alimatedɩɔ 'mʋ. Sosɛfʋ a ‑gbɛ, ɔ mɔ ‑wɛ ‑Yusu a ‑naagbopʋyuu nɩ. ");
INSERT INTO ted_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nɔ‑ mu 'le Pilatɩ ‑wɔn, 'ɔ lo, 'ke bɔ wɛɛn ke, bɔ ‑ha 'o ‑Yusu a ‑plahʋɩn tu 'yie 'mʋ, ɔ 'mui 'o ‑ha. ‑Ye Pilatɩ le 'a 'sɔyuo nɩ, 'ke bʋ ‑nyi ꞊nɔ ‑Yusu a ‑plahʋɩn, ‑ɛ die nu, ɔ 'mui 'o ‑ha. ");
INSERT INTO ted_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","‑Tɛ ʋ ‑nyi ꞊nɔ, ‑ye ɔ gbɩ nɩ, 'ɔ 'hɩnhɩʋɩn dayrayrʋ lɛ, ");
INSERT INTO ted_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","'plɩɩ 'ɔ gbɩ 'le ‑tɛgbi ꞊nʋ, ɔ di 'o ‑ha. ‑Tɛgbi a ‑gbɛ, 'hɩɔ gblaka nɩ 'o, 'ɔ hren 'klɔ, 'ɔ 'we ꞊nɔ dʋgba ye. 'Hɩɔ gblaka a ‑gbɛ 'kwli 'mʋ, 'ke ʋ 'bluu la 'le 'dɛɛ, (ti ꞊de a ti 'yri la, ‑ɛ 'we ꞊nɔ ‑wlukayu ye). 'Dɛɛ a ‑gbɛ wlɔn, 'ke ɔ po 'le ‑Yusu a ‑plahʋɩn, 'plɩɩ 'ɔ nu 'hɩɔ 'papa ꞊nʋ, ‑ɔ nɩ 'o, ‑ɔ ꞊hɩan 'le ‑wɔn lɛ, 'ɔ ka 'dɛɛ a ‑gbɛ ye. ‑Tɛ ɔ ‑wɛ ‑wɔn, ‑ye ɔ mu nɩ. ");
INSERT INTO ted_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Madala 'mʋ a Mari, kɔ Mari ‑ye ꞊nʋ 'hɛɛn, ʋ nɩ ‑wɛ ke ‑tuo, 'ʋ 'bɛ 'dɛɛ 'yi 'mʋ, 'ʋ nɩ gbo. ");
INSERT INTO ted_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","‑Nyrɔwɔ ꞊nʋ, ‑ɔ ‑hi, ‑wuwle‑nyrɔwɔ 'ɔɔ 'o nyre, nɔ‑ kɔ 'kwli 'mʋ, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ʋ 'kukue 'o lɛ, 'ʋ mu 'le Pilatɩ ye, ");
INSERT INTO ted_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ʋ nɔ: «Nyɩbɛyu o, ‑tɩ bi 'le ‑a mʋ 'kwli 'mʋ. Nɩ‑ mɔ, ‑tɛ hɩnyɔ ꞊nʋ, ɔ nɩ o 'klɔ, kɛ ɔɔ o po: 'Bɩa 'nɩ 'kʋ, ‑nyrɔwɩɩ 'hɔn, ‑nyrɔwɔ a ta a nɔnɔ 'mʋ, 'n kɔ ꞊bo 'hrɩ 'klɔ. ");
INSERT INTO ted_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","'A ‑tɩ, ‑a nye 'nɩ ‑hʋa, ‑bo le ‑na 'sɔyuo, bʋ ꞊tu 'a 'dɛɛ a ‑gbɛ 'yie ‑tutu, ‑nyrɔwɩɩ ta 'mʋ 'lu ‑yrɛ, ‑ɛ die nu, 'a ‑naagbopʋ 'nɩ ꞊han 'le di, ʋ 'nɩ ꞊han 'a ‑plahʋɩn 'yri, 'plɩɩ ʋ 'nɩ ꞊han nahuin le, ‑ɛ mɔ, ɔ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ 'hrɩ 'klɔ. Hɩdʋ a ‑gbɛ, ɩ di wɛn ke nɩ 'klɩ, ɩ 'mʋ wɛn 'o 'a ye‑hɛdɛ 'mʋ ‑hi.» ");
INSERT INTO ted_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","‑Ye Pilatɩ ꞊tu ‑wɔn, ɔ nɔ: «'Sɔyuo, nʋ‑ ‑gbo, ʋ 'mʋ 'dɛɛ a ‑gbɛ 'yie ꞊tu. Ba mu, ba le 'sɔyuo a ‑gbɛ, bʋ ꞊tu 'dɛɛ a ‑gbɛ 'yie, ‑tɛ aa 'a ‑hʋhʋa nu,» ");
INSERT INTO ted_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","'ʋ mu 'le 'dɛɛ ye, 'ʋ ꞊tue 'hɩɔ ꞊nʋ yriilɛ, ʋ nu wɛn, 'ʋ ka wɛn ‑Yusu a 'dɛɛ ye, kɔ, 'ʋ ꞊tu 'o 'sɔyuo ‑nɩ wɛn gbo, ‑ɛ die nu, ʋ 'mʋ 'dɛɛ 'yie ꞊tu. (Yriilɛ a ‑gbɛ, ʋ ꞊tue 'hɩɔ, ɛ die ꞊nʋ 'nɩ tɔɔ, 'bɩa nahuon 'bɔ kla 'dɛɛ a ‑gbɛ ye.) ");
INSERT INTO ted_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","‑Tɛ ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ a ‑gbɛ, ɔ ‑hi, 'a 'sɔɔdɩ a ‑nyrɛgblɩ 'mʋ, Madala 'mʋ a Mari, kɔ Mari ‑ye 'hɛɛn, nʋ‑ mu ‑Yusu a 'dɛɛ 'ye wɔn. ");
INSERT INTO ted_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tii ‑do a ti 'yri, ‑ye ‑tʋtʋ ‑tʋa 'hɩhrɔlɛ gbo, ‑ɛ nue, Nyɩsʋa a lɛleenyɔ, nɔ‑ ‑hɔn 'le yakɔ 'mʋ, 'ɔ brike kwakuhɩɔ ꞊nʋ lɛ, ʋ nu, 'ʋ ka o ‑Yusu a 'dɛɛ ye. ‑Tɛ ɔ briko 'klɛɛ lɛ, ‑ye ɔ nɩɔ gbo ke. ");
INSERT INTO ted_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nyɩsʋa a lɛleenyɔ a ‑gbɛ, ɔɔ 'nɩ wlɩn, 'ɛ 'we ꞊nɔ tɩatɩɛ ye, 'a 'hʋɩn'mʋlɛpue‑tɔplɩ 'ɩ 'plɛ 'dɔ, 'ɛ 'we ꞊nɔ ‑nyrɛ ye. ");
INSERT INTO ted_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","'Sɔyuo ꞊de, nʋ‑ nɩ ‑wɛ 'o, 'ʋʋ 'dɛɛ 'yie ꞊tu. ‑Tɛ dɛ a ‑gbɛ, ɛɛ 'lu ‑wɔn mue, ‑ye hʋannʋ nyu nu 'dɔ. Nɛ‑ nue, 'ʋ ‑tʋa 'hɩhrɔlɛ gbo, 'ʋ bibi ꞊hlɔn lɛ, 'ʋ pɛ 'o gblɛ, ‑ɛ 'we ꞊nɔ nahuin ye, ‑ʋ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","‑Ye kɛ Nyɩsʋa a lɛleenyɔ, ɔɔ nyrʋ ꞊nʋ ye po, ɔ nɔ: «'A mʋ ꞊nʋ, a nɩ pɩ 'le hʋannʋ! 'N yie nɩ, ‑ɛ mɔ, ‑Yusu ꞊nʋ, ʋ kɔɔ 'o tu 'yie 'mʋ, nɔ‑ aa lɛ ꞊mɔ. ");
INSERT INTO ted_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔ 'de nɔ nɩ, ‑ɛ nue, ‑tɛ 'a ‑gbɛ, ɔ nu o 'a ꞊tutue, Nyɩsʋa ‑hɩɔ 'le 'kʋkʋnyʋ ‑hɛyri nɩ, 'ɔ ‑hɩɔ 'klɔ. Ba di 'le, ba 'ye ‑tɛgbi ꞊nʋ, ʋ pɩɔ o 'o gbo. ");
INSERT INTO ted_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","'A ‑tɩ, ba 'kɩka, ba le 'a ‑naagbopʋ, ‑ɛ mɔ, Nyɩsʋa ‑hɩɔ 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ ‑hɩɔ 'klɔ. ‑Yusu a ‑gbɛ, nɔ‑ di 'hru 'nyɛ, ɔ 'mʋ 'a mʋ ‑pre, 'ke 'le Galileblʋgba 'mʋ. 'Kee nɩ, a dio 'le gbo yɛ. ‑Tɩ ‑gbo, 'n kɔ ꞊bo ꞊tu wɛn 'a mʋ ye, nɩ‑ɩ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","‑Tɛ ʋ 'wɩn 'klɛɛ, ‑ye 'tata a ti 'yri, ʋ ‑hɔn 'le 'dɛɛ ye 'mʋ nɩ. Hʋannʋ nyu wɛn a nue, kɔ, 'manʋ 'ʋ nyu ‑wɛ a nue, 'ʋ 'gba ci lɛ, ‑ɛ die nu, dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, ʋ 'mue ‑Yusu a ‑naagbopʋ ‑wɔn lɛ na. ");
INSERT INTO ted_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","‑Tɛ ʋʋ 'klɛɛ mu, ‑ye tii ‑do a ti 'yri, ‑Yusu 'ɔ diu ye 'mʋ 'bɛ wɔn, ɔ nɔ: «'A nɩ 'wio,» ʋ ‑mɛ ‑ye, 'ʋ 'yɩyɔ 'o 'hʋɩn 'mʋ gbo, 'ʋ blɔ kwlɩ ye gbo, 'ʋ klɩ 'a bʋɩ, 'ʋ nyo baa. ");
INSERT INTO ted_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «A nɩ pɩ 'le hʋannʋ! Ba mu, ba le 'na ‑naagbopʋ, bʋ mu 'le Galileblʋgba 'mʋ. 'Kee nɩ, ʋ di 'le 'mʋ gbo yɛ.» ");
INSERT INTO ted_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","‑Tɛ nyrʋgbapʋ a ‑gbɛ, ʋʋ 'klɛɛ 'le ‑Yusu a ‑naagbopʋ ‑wɔn mu, ‑ye 'sɔyuo ꞊nʋ, ‑ʋʋ ‑Yusu a 'dɛɛ 'yie ꞊tu, 'waa nahuin ‑ye, ʋ 'ya 'mʋ 'dɩɔ, 'ʋ le Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblakɩ ‑tɩ 'bii ꞊nʋ, ‑ɩ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","‑Tɛ ʋ 'wɩn 'klɛɛ, ‑ye ʋ kɔ 'blʋ a nahuin 'hɛɛn, ʋ 'kukue lɛ, ‑ɛ die nu, ʋ 'mʋ ‑tɩ a ‑gbɛ 'mʋ lɛ pupo. ‑Tɛ ʋ pupui 'klɛɛ 'mʋ lɛ, ‑ye ʋ wɛɛn ke, 'ke bʋ ‑ha 'le 'dai 'wliyɛ, bʋ ‑nye 'sɔyuo. ‑Tɛ ʋ ‑nye 'klɛɛ ꞊nʋ, ");
INSERT INTO ted_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","‑ye kɛ ʋʋ ꞊nʋ ye po, ʋ nɔ: «Kɛ ba po: ‑A nɩ 'le ŋmla 'mʋ, ‑Yusu a ‑naagbopʋ 'ʋ di 'le 'tɔ 'mʋ, 'ʋ 'yri 'a ‑plahʋɩn.» ");
INSERT INTO ted_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kɛ ʋʋ lele po: «'Bɩa ‑gʋlʋnʋma 'bɔ 'wɩn, ‑a di 'a klɛ‑hɩhɩalɛ 'nɩ yi, ‑ɛ die nu, a 'nɩ ꞊han 'kla‑wliye'yɩya 'ye,» ");
INSERT INTO ted_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","'sɔyuo 'ʋ gba 'wliyɛ ꞊nʋ, dɛ ‑gbo, 'blʋ a nahuin, ʋ plɛ bʋ nu, 'ʋ nue. Nɛ‑ nue, ‑hɔn 'o ‑nyrɔwɔ a ‑gbɛ 'yie 'mʋ, ‑bo yɛ ‑nyrɔwɔ ‑gbo ke, ‑tɩ a ‑gbɛ 'ɩ 'sɛɛ gbo, 'ke 'le ‑Juukʋɛ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o ‑do ꞊nʋ, ʋ mu nɩ, 'ke 'le Galileblʋgba 'mʋ, 'ʋ 'ya 'le dʋgba ꞊nʋ 'lu, ‑Yusu tɔɔ o ꞊nʋ. ");
INSERT INTO ted_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Dʋgba a ‑gbɛ 'lu, 'ke ɔ 'hrɩɩ 'o ꞊nʋ ye. ‑Tɛ ʋ 'yo 'klɛɛ, ‑ye ʋ blɔ ye gbo kwlɩ, 'ʋ nyo baa. Kɛɛ, 'ke nahuin ‑ye nɩ 'o, 'ʋ 'nɩnɩ pui ‑tɛɛ, ‑ɛ mɔ, ‑Yusu'u nɩ, ‑ɔ 'hrɩɩ 'o ꞊nʋ ye, ");
INSERT INTO ted_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","‑Yusu 'ɔ 'yɩya 'o ꞊nʋ ye gbo, ɔ nɔ: «Kʋɛ 'le yakɔ 'mʋ gbo, ‑bo yɛ ‑tʋtʋ ke, 'klɩ 'bii ꞊nʋ, 'nɩɩ nu, 'nɩɩ 'ɛ nɩ dɛ ꞊de win ke kɔɔ, Nyɩsʋa, nɔ‑ ‑nyi 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ba mu 'le dakʋ 'bii ‑wɔn, ‑ʋ nɩ nɔ 'klɔ ke, ba nue, ʋ 'mʋ 'na ‑naagbopʋ ‑hɛ. Ba pu 'nie 'lu lɛ, 'ke 'le ‑a nɩ Bu Nyɩsʋa, kɔ 'a 'Yu, kɔ 'a ‑Hihiu a 'dʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ba tɔɔ ꞊nʋ, 'ke bʋ ꞊tuu 'o ‑tɩ 'bii ꞊nʋ, 'n le 'a mʋ, ba nu. Ba kɔ 'a yiyie, 'ke 'n di 'o 'a mʋ 'hʋɩn 'mʋ nɩ, 'ɛ nɩ ‑nyrɔwɔ, ɛ 'mue gba ‑gbagba, 'klɔ 'mʋ 'o 'mʋ ‑hɔn.»");
INSERT INTO ted_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nyɩsʋa a ꞊hapʋwin, nɩ‑ 'crɛɛ nɔ 'crɩɩnɩɛ ‑gbo 'kwli 'mʋ. Nyɩsʋa a win a ‑gbɛ, 'a 'Yu a ‑tɩ, ɩɩ ‑wɔn lɛ na. 'A 'Yu a ‑gbɛ a 'dʋ mɔ ‑Yusu 'Klɩsʋ. ");
INSERT INTO ted_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ti ꞊de a ti 'yri la, (‑tɛ ʋ 'de la ‑Yusu a kʋɛ,) ɛ kɔ la Nyɩsʋa a winwlɔn‑hɛnyɔ ꞊de. 'A 'dʋ mɔ la Esai. ‑Yusu bi 'le ye, kɔ nahuon ‑ye 'hɛɛn, ‑ɔ mɔ Saan Batisɩ, nʋ‑ kɔ ‑tɩ Esai a ‑gbɛ, ɔ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «Nyɩsʋa nɔ 'nɩ: 'Na 'Yu o, 'n di ‑ha nahuon, 'ke 'o 'na ‑kʋan a ‑ta 'mʋ, ɔ 'mʋ mu, 'hru ꞊nʋ, ‑ʋ kɔ wlɔn ‑n di 'o na, ɔ 'mu ye kla, 'plɩɩ ꞊mʋ 'le nyre. Ɛ 'we ꞊nɔ ye, nahuon a ‑gbɛ, ɔ di ye kla ‑tʋnahuin a ꞊wlɩ, 'plɩɩ ꞊mʋ 'le nyre ‑o.» ");
INSERT INTO ted_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","'Ke 'le Nyɩsʋacrɩɩnɩɛ a ‑gbɛ 'kwli 'mʋ, ʋ 'crɩɩ la lele ‑tɩ ‑ye. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: «Nyɩsʋa nɔ 'nɩ: Nahuon a ‑gbɛ, ‑tɛ 'dʋ di 'le ye bii, 'kee nɩ, ɔ di 'le 'ti. 'Bɔɔ 'prɛ, ɔ 'mʋ 'le win 'yaa. Kɛ ɔ di po: Kʋkɔnyɔ a 'hru ꞊nʋ, ‑ʋ kɔ wlɔn ɔ di 'o na, ba 'siu 'o ye, 'plɩɩ Kʋkɔnyɔ a ‑gbɛ, ɔ 'mʋ 'le di. Ɛ 'we ꞊nɔ ye, 'a nɩ 'klɔ bɔ 'sii 'o ye, ‑ɛ die nu, a 'mʋ ‑wɔn ‑wɛ, 'plɩɩ Kʋkɔnyɔ 'mʋ 'le di ‑o.» ");
INSERT INTO ted_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","‑Tɛ Esai a ‑gbɛ, ɔ nu la 'a ꞊tutue, kɛ nahuon a ‑gbɛ, ɔ nu naalɛ. Ɔ nɔ‑ mɔ Saan Batisɩ. ‑Ye Saan a ‑gbɛ, ‑tɛ 'dʋ bii 'le ye, 'ke ɔ 'ti 'le, nahuin 'ʋʋ 'le ꞊nɔ ‑wɔn di. 'Bɔɔ 'prɛ, 'ɔɔ 'le win 'yaa, kɔ, 'ɔɔ win lɛ ‑gba, ɔ nɔ: «Ba yree, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ɛ mɔ, aa nu ‑tɔplɩ, ‑ɩ nyre 'yi lɛ, 'ke 'o Nyɩsʋa ye. Ba hie 'o 'yilɛnyre‑tɔplɩ a ‑gbɛ gbo, ba ‑nye 'a nɩ 'klɔ 'bii Nyɩsʋa, Nyɩsʋa 'mʋ 'a nɩ 'yilɛnyre‑tɔplɩ 'wʋwla, 'mʋ 'a mʋ 'nie 'lu lɛ po.» ");
INSERT INTO ted_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nahuin 'plɔplɔ, ‑ʋ 'ti 'le Sudeblʋgba 'kwli 'mʋ, kɔ 'dɩɔ ‑gbo, ‑ɔ mɔ Jrusrɛ 'mʋ, kɛ ʋʋ nu, 'ʋ nyo ye mu, ʋ 'mʋ 'a win 'wɔn, 'ʋʋ 'waa nɩ 'yilɛnyre‑tɔplɩ yrɛ wɔɔn, 'ke 'o nahuin ye, 'plɩɩ Saan, 'ɔ nyu 'nie 'lu lɛ po, 'ke 'le 'nɩgblaba ꞊nʋ ‑wɔn, ‑ɛ kɔ 'dʋ mɔ Sudɛn. ");
INSERT INTO ted_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Saan a ‑gbɛ, 'a wlawlʋ, ɔɔ pue, ʋ 'de dɛkɔnyɔ a wlawlʋ ye 'we. Ʋ nu ꞊gbuke‑so a ‑pupui, 'ʋ hrʋ, 'ɔ nyu dahʋakɔ a 'bɛtɩyɛ ke klɩɩ. 'A didi‑tɔplɩ, ɔɔ di, nɩ‑ mɔ 'kolio kɔ dʋnyra. (Ɛ 'we ꞊nɔ ye, Saan, ɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ. ‑Tɛ 'a 'bienʋ Nyɩsʋa a winwlɔn‑hɛnyʋ ‑ye ꞊nʋ, ʋ nɩ la 'mʋ, ti ‑hi la a ti 'yri, kɛ'ɛ nɩ, Saan, ɔ nɩ ‑wɛ 'mʋ.) ");
INSERT INTO ted_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nahuin ꞊nʋ, ‑ʋ nɩ 'o, kɛ ɔɔ ꞊nʋ ye po: «Ti gbi a ti 'yri, nahuon ꞊de di 'le di. Nɔ‑ di 'o 'mʋ ke 'mʋ kʋɛ. Nahuon a ‑gbɛ, ‑ɔ di 'le di, ɔ di ke nɩ 'klɩ, ɔ 'mʋ 'o 'mʋ 'mʋ ‑hi, 'ke 'le Nyɩsʋa a 'dʋ 'kwli 'mʋ. 'Na ‑gbɛ, 'n 'de nyɔ ꞊de, 'ke ꞊bo dio 'mʋ ‑hɛ, 'ke 'o 'ɛ nɩ ‑kʋandɛ ꞊de a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","'Mɛ ‑ye le, 'nie, nɛ‑ 'nɩɩ 'a mʋ 'lu lɛ po, kɛɛ, ɔ ‑mɛ ‑ye, Nyɩsʋa a ‑Hihiu, nʋ‑ ɔ di 'a mʋ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusu ‑hɔn 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Nasalɛtɩ, 'ke 'le Galileblʋgba 'kwli 'mʋ, 'ɔ mu 'le Saan ye, Saan 'ɔ puo 'nie 'lu, 'ke 'le 'nɩgblabaa ‑do ꞊nʋ ‑wɔn, ‑ɛ kɔ 'dʋ mɔ Sudɛn. ");
INSERT INTO ted_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","‑Tɛ ɔɔ la 'le 'nie ‑wɔn 'hrɩ, ‑ye ɔ 'ye yakɔ, 'ɔ ‑ki wlɔn, Nyɩsʋa a ‑Hihiu 'ʋ ꞊tɩɩ 'o ꞊nɔ 'lu, ɛ 'we ꞊nɔ ye, ‑tɛ ‑plija, ɔ 'nɩnɩ ꞊tɩɩ 'klɛɛ 'o ꞊nɔ 'lu, ");
INSERT INTO ted_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","'plɩɩ 'ʋ 'wɔn Nyɩsʋa a wintɛ, 'ɛ ‑hɔn 'le yakɔ 'mʋ, 'ɛɛ lɛ po: «‑Mɔ mɔ 'na 'Yuu ‑do, 'n nʋɛ 'mʋ ‑tɛɛ. ‑Nɩɩ 'mʋ nue 'manʋ.» ");
INSERT INTO ted_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","'Tata a ti 'yri, ‑tɛ dɛ a ‑gbɛ, ɛ ‑hi 'klɛɛ, ‑ye 'ke Nyɩsʋa a ‑Hihiu gbɔ 'le ‑tɛgbi ‑ye, 'dʋ bii 'le ye. ");
INSERT INTO ted_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","‑Tɛgbi a ‑gbɛ, ɔ ‑hi 'le ‑nyrɔwɩ a ‑wlɩɩ 'hɔn, 'ke 'le dɛhʋɛi ‑hɛyri. Ti ꞊nʋ 'yri, 'ke 'kuo ‑hʋɩn a nyɩgblaka, ‑ɔ mɔ Satan, ɔ muo 'mʋ lɛ ꞊tɔ wɔn, ‑ɛ die nu, ‑Yusu 'mʋ ‑tɩ 'wla, 'ke 'o 'a Bu Nyɩsʋa ye, kɛɛ, ɔ 'de ‑tɩ 'wla. ‑Ye Nyɩsʋa tɛ gbo 'a lɛleenyʋ. Nʋ‑ nyo 'mʋ ‑hɛ. ");
INSERT INTO ted_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ʋ nɩ 'o ‑nɩnɩ, ‑ye Saan Batisɩ ‑nɩ wɛn, ʋ puo 'mʋ ꞊jɩ. ‑Tɛ ʋ puo ꞊jɩ 'mʋ, ‑ye 'ke ‑Yusu mu 'le Galileblʋgba 'kwli 'mʋ, 'ɔɔ Nyɩsʋa a ꞊hapʋwin ‑wɔn lɛ na. ");
INSERT INTO ted_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kɛ ɔɔ po: «Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'o nahuin 'bii win ke kɔɔ, ɩ 'mʋɛɛ yrɛ. 'A ‑tɩ, ba yree, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ɛ mɔ, aa nu ‑tɔplɩ, ‑ɩ nyre 'yi lɛ, 'ke 'o Nyɩsʋa ye. Ba hie 'o 'yilɛnyre‑tɔplɩ a ‑gbɛ gbo, ba ‑nyi 'a nɩ 'klɔ 'bii Nyɩsʋa, kɔ, ba kuo Nyɩsʋa a ꞊hapʋwin ꞊wlʋ ye.» ");
INSERT INTO ted_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","‑Nyrɔwɔɔ ꞊de 'mʋ, ‑Yusu mu 'le Galileblʋgba a 'yru nʋa 'mʋ. Bɔɔ 'klɛɛ 'yru nʋa 'mʋ lɛ 'yraa, ‑ye ɔ yɛ 'o gbo nahuiin 'hɔn ꞊de. 'Waa 'dʋɩ mɔ Simɔ (Piɛlɩ) kɔ 'a ‑dɩayu Adre. Ʋ mɔ 'pʋpanyʋ'ʋ nɩ. 'Ke ʋ nɩ 'le 'waa 'blagbe wlɔn, 'ʋʋ 'waa ‑tatɩ po. ");
INSERT INTO ted_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","‑Ye kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «Ba di 'le, ba kʋɛ 'mʋ ‑wɔn, a 'mʋ 'na ‑naagbopʋ ‑hɛ. 'N die 'nɩ nu, a 'mʋ ‑tʋnahuin lɛ 'kukue. Ɛ 'we ꞊nɔ ye, ‑tɛ aa nu, 'aa ‑tata po, 'aa ‑hrin lɛ 'kukue, kɛ ba nu, ba 'kukue ‑tʋnahuin lɛ, ʋ 'mʋ ‑wɛ 'na ‑naagbopʋ ‑hɛ.» ");
INSERT INTO ted_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Bɔ ꞊tu 'klɛɛ ꞊nʋ ‑tɩ a ‑gbɛ ye, 'tata a ti 'yri, ‑ye ʋ hie 'o 'waa ‑tatɩ gbo, 'ʋ ‑tʋa 'a ‑wɔnnaalɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Bʋ 'yɩya 'o ye 'mʋ gbo dɛ gbi, ‑ye ɔ yɛ 'o gbo 'pʋpanyʋ ‑ye. 'Pʋpanyʋ a ‑gbɛ, nʋ‑ mɔ Sakɩ kɔ 'a ‑dɩayu Saan, kɔ 'waa bu Sebede, kɔ 'waa bu a ‑kʋannunyʋ, 'ʋ nɩ 'le 'waa 'blagbe wlɔn, 'ʋʋ 'waa ‑tatɩ ‑hlɛntie. ");
INSERT INTO ted_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","‑Tɛ ɔ yɛ 'o ‑dɩayuoo 'hɔn a ‑gbɛ gbo, ‑ye ɔ dʋ nɩ, 'ke bʋ 'ya 'a ‑naagbopʋ 'mʋ. Tii ‑do a ti 'yri, ‑ye ʋ hie 'o 'waa bu gbo, kɔ 'a ‑kʋannunyʋ 'hɛɛn, 'ʋ nyo ‑wɔn kʋɛ. ");
INSERT INTO ted_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye 'ke ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ kɔ 'dʋ mɔ Kapɛnaɔ. ‑Tɛ ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ nyre 'o, ‑ye 'ke ʋ pa 'le Nyɩsʋa a kayu gbo, ");
INSERT INTO ted_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","‑Yusu 'ɔ bi 'o, 'ɔɔ Nyɩsʋa a ‑tɩ tɔɔ. Nahuin ꞊nʋ, ‑ʋ nɩ 'o, ɩ ka ꞊nʋ lɛ 'ŋmi, ‑Yusu bɔ di lɛ tɔɔlɛ nu. Ɔ 'nɩ tɔɔ ꞊le, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑Juukʋɛ a teteitɔɔnyʋʋ nu, kɛɛ, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ, 'ke ɔɔ 'le tɔɔ. ");
INSERT INTO ted_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɛ kɔ nyɩbɛyu ꞊de. Nɔ‑ 'ku ‑hʋan nɩ 'o ke 'mʋ. 'Ke ɔ nɩ ‑wɛ 'le Nyɩsʋa a kayu gbo. Tii ‑do a ti 'yri, 'ɔ ‑tʋa win a 'le'yaalɛ gbo, ");
INSERT INTO ted_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ɔ nɔ: «Nasalɛtɩ 'mʋ a ‑Yusu, ‑ha ‑a mʋ mɛ lɛ, ꞊nɩ bi 'le 'le ‑a nɩ ‑tɩ ‑hɛyri. ‑N 'de ꞊le, ꞊mʋ ‑a mʋ gbo ‑wɔ. 'N yie nɩ, nahuon a gblo tio‑ ‑n 'ya. ‑Mɔ mɔ Nyɩsʋa a 'Yu, ‑mɔ ɔ lee nɔ.» ");
INSERT INTO ted_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Bɔ po 'klɛɛ lɛ, ‑ye ‑Yusu, ɔ 'prɛɛ 'le 'ku ‑hʋan a ‑gbɛ ‑wɔn nɩ, ɔ nɔ: «Ma wien, 'plɩɩ ‑hɔn 'o nahuon ꞊nʋ ke 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","'ku ‑hʋan a ‑gbɛ, 'ʋ bʋbla nahuon a ‑gbɛ, 'ʋ ‑hɛ ‑cici wlɔn, 'plɩɩ 'ʋ ‑hɔn 'o ꞊nɔ ke 'mʋ, 'ʋ mu. ");
INSERT INTO ted_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","‑Ye nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'o, ɩ ka ꞊nʋ lɛ 'ŋmi, 'ʋʋ 'mʋ lɛ 'pʋprɛ, dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, a ‑tɩ, ʋ nɔ: «Dɛ a ‑gbɛ, ɛ mɔ dɛ'ɛ nɩ. Tɔɔlɛ yrayrʋ ‑yee nɩ, ɔ ya 'le, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ. Ɔɔ wɛn 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ a tʋɛ, 'ɔ kɔɔ 'kuo ‑hʋɩn win ke, 'plɩɩ 'kuo ‑hʋɩn a ‑gbɛ, 'ɔ nyo 'o ꞊tuu.» ");
INSERT INTO ted_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","‑Ye ‑Yusu a 'dʋ 'sɛɛ gbo, 'ke 'le Galileblʋgba 'bii ꞊nʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","‑Tɛ ʋ ‑hɔn 'le Nyɩsʋa a kayu gbo 'mʋ, ‑ye 'ke ʋ mu 'le Simɔ kɔ Adre 'hɛɛn a ‑tɛ. Saan kɔ Sakɩ 'hɛɛn, nʋ‑ kʋɛ ꞊nʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simɔ a 'dɔɔ, nɔ‑ kɔ 'hʋɩn hren, 'ɔ pɛ gbo. ‑Tɛ ʋ nyre 'le kayu gbo, ‑ye ʋ le ‑Yusu nɩ, ‑ɛ mɔ, Simɔ a 'dɔɔ a 'hʋɩn hren nɩ, ");
INSERT INTO ted_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","‑Yusu 'ɔ 'yɩya 'o ꞊nɔ 'hʋɩn 'mʋ gbo, 'ɔ klɩ 'a dabʋ gbo, 'ɔ 'bɔ ye 'mʋ. ‑Ye Simɔ a 'dɔɔ a ‑gbɛ, 'a 'hʋɩn 'kee nɩ, 'ɔ bi 'o, 'ɔ pi 'waa dididɛ. ");
INSERT INTO ted_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","‑Wisepepei 'mʋ, ‑tɛ ‑wuwle‑nyrɔwɔ ‑wɛ 'le, ‑ye nahuin 'bii ꞊nʋ, ‑ʋ kɔ kɩklanyʋ, kɔ ꞊ʋ ‑ye, ‑ʋ kɔ nahuin, 'kuo ‑hʋɩn nɩ 'o ke 'mʋ, ‑ye 'ke ʋ gbʋ 'le ‑Yusu ‑wɔn, ");
INSERT INTO ted_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","'dɩɔ a nahuin 'plɔplɔ, 'ʋ ꞊gbee 'o kayu a ‑gbɛ a ꞊gbuhan.ye, ");
INSERT INTO ted_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","‑Yusu 'ɔ ‑wɔ 'kʋɛi a gblegblei, ‑ɩɩ nahuin nu, 'ɔ bla ‑wɛ 'kuo ‑hʋɩn 'plɔplɔ lɛ. Ɔ le 'kuo ‑hʋɩn a ‑gbɛ nɩ, ‑ɛ mɔ, ɔ nɩ po 'le wun, ‑ɛ nue, ɔ yi ‑Yusu nɩ. ");
INSERT INTO ted_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","‑Nyrɛgblɩ, gbɩgbɩyrɩ nɩ ‑tʋtʋ klɛ, ‑Yusu 'ɔ 'ba ye 'mʋ, 'ɔ mu 'le ‑tɛgbi, 'dʋ bii 'o ye, 'ɔɔ 'le Nyɩsʋa ‑wɔn 'prɛɛ. ");
INSERT INTO ted_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","‑Ye Simɔ kɔ 'a 'bienʋ 'hɛɛn, ʋ muo lɛ ꞊mɔ wɔn. ");
INSERT INTO ted_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","‑Tɛ ʋ yɔ 'klɛɛ ke, ‑ye ʋ nɔ: «‑Mɔ nahuiin 'bii lɛ ꞊mɔ.» ");
INSERT INTO ted_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","‑Ye ɔ nɔ: «‑Ba mu 'le ‑tɛgbi ‑ye, ‑ba mu 'le 'dɩɛ ‑ye ꞊nʋ klɛ, ‑ɩ ꞊glaa 'le ‑a mʋ, 'mʋ ‑wɛ 'le Nyɩsʋa a ‑tɩ 'le ꞊tuu. Ɩ nɩ‑ kɔ ‑tɩ Nyɩsʋa 'ɔ lee nɔ 'mʋ ‑tʋtʋ ke,» ");
INSERT INTO ted_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","‑Yusu 'ɔ bi Galileblʋgba 'bii ꞊nʋ ke, 'ɔɔ Nyɩsʋa a kayuo gblɛ na, 'ɔɔ Nyɩsʋa a ‑tɩ ꞊tu, kɔ, 'ɔɔ ‑wɛ 'kuo ‑hʋɩn lɛ bla. ");
INSERT INTO ted_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","‑Nyrɔwɔ ꞊de 'mʋ, ‑tɔplɩ‑jɔhʋɩnnunyɔ ꞊de, nɔ‑ mu 'o ‑Yusu ye, 'ɔ blɔ kwlɩ ye gbo, ɔ nɔ: «'Nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, nue, 'na 'kʋɛ bɛ ‑wɛ!» ");
INSERT INTO ted_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","‑Ye 'a wɔlɩɩ ‑Yusu nu, 'ɔ 'tʋɔ lɛ, ɔ nɔ: «'N nye 'nɩ ‑hʋa, ‑na 'kʋɛ bɛ ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tii ‑do a ti 'yri, ‑ye 'a 'kʋɛ ‑wɛ nɩ, ");
INSERT INTO ted_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","‑Yusu 'ɔ tio ‑tɛɛ, ɔ nɔ: «‑N ‑wɛ 'le ‑bo mu 'klɛɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Kɛɛ, ꞊nɩ ꞊tui 'le nahuon ꞊de ye gbe! Kɛɛ, mu ‑bo titie ‑n dɩɔnʋ Nyɩsʋa a ‑cɔhlʋnpinyɔ ye, ɔ 'mue 'ye, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ. 'A ‑tɩ, gba ‑tɔplɩ ꞊nʋ, ʋʋ nu, 'ʋʋ ‑cɔhlʋn pi, 'ke 'o Nyɩsʋa ye, ‑tɛ Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, ɔ nu la 'a ꞊tutue ye‑hɛ‑nyrɛ 'mʋ, ‑ɛ die nu, nahuin 'bii, ʋ 'mui yi, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ!» ‑Ye ɔ ‑hɔn 'o ꞊nɔ 'hʋɩn 'mʋ nɩ, 'ɔ mu. ");
INSERT INTO ted_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kɛɛ, ‑tɛ ɔ mu, ‑ye ɔ nyi lɛ na ‑wɔn, 'ke 'o nahuin ye, ‑tɛ 'a 'kʋɛ bɛ nu ‑wʋwɛ, 'ɔ 'sɛɛ ‑tɩ a ‑gbɛ 'blʋgba ke gbo. ‑Tɔplɩ a ‑gbɛ a ‑tɩ, ɛ nue, ‑Yusu 'die 'le ‑wɛ, bɔ 'ya 'klɛɛ lele 'dɩɔ ꞊de 'mʋ. Ɔɔ ye 'nɩ bii, nahuin 'ʋʋ ‑tɔplɩ 'mʋ lɛ ‑hɔn, 'ʋ nyo 'le ye mu. ");
INSERT INTO ted_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","‑Nyrɔwɩ gbi bɩ ‑hi la, ‑ye ‑Yusu ꞊hɩan la ‑wɔn, 'ɔ di la 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Kapɛnaɔ. ‑Tɛ nahuin 'wɩn, ‑ɛ mɔ, ‑Yusu ꞊hɩan ‑wɔn, ");
INSERT INTO ted_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","‑ye nahuin 'plɔplɔ, ʋ mu 'le ꞊nɔ ‑wɔn. 'Tata a ti 'yri, ‑ye kayu, ɔ nɩ 'le gbo, ʋ 'yii 'le ꞊le, 'ke 'o ‑tʋnahuin ‑wɔn, ‑ʋ muo 'ye wɔn, mɔ, 'hru 'de ‑wɛ 'o ꞊gbuhan.ye nɩ. 'Ke 'le nahuin a ‑gbɛ ‑hɛyri, 'ke ‑Juukʋɛ a teteitɔɔnyʋ ‑ye nɩ 'le. Nahuin a pɛpɛ 'bii, ‑ʋ di ‑tuo a ‑gbɛ ke, nʋ‑ ‑Yusu, ɔɔ Nyɩsʋa a ‑tɩ ye ꞊tu. ");
INSERT INTO ted_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","‑Ye nahuin ‑ye, nʋ‑ʋ 'le ‑Yusu ‑wɔn mu. 'Ke 'le nahuin a ‑gbɛ ‑hɛyri, 'ke nahuiin ‑hɛn nɩ 'le, 'ʋ 'ble ‑hanmakɩ. ‑Hanmakɩ a ‑gbɛ, nɛ‑ kɔ 'kwli 'mʋ, 'ke ʋ pɩa 'le lɛ‑yɩyrɛnyɔ gbo, 'ʋ nyo 'le ‑Yusu ‑wɔn gba. ");
INSERT INTO ted_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Bʋ nyre 'le kayu a ‑gbɛ ye, ‑ye 'hru 'de ‑tɛ nɩ, 'ke 'o ‑tʋnahuin a ‑huhue a ‑ta 'mʋ. ‑Tɛ bʋ di nu, ʋ 'mʋ 'o 'waa nɩ lɛ‑yɩyrɛnyɔ ‑Yusu 'hʋɩn 'mʋ nyree, ʋ 'die yi. Nɛ‑ mɔ bʋ 'ya 'le kayu ke, ‑tɛ ‑Yusu 'bɛ 'o 'yi 'mʋ, 'ke ʋ ‑haa 'o 'hʋɔ, 'ʋ ꞊tɩɔ 'o lɛ‑yɩyrɛnyɔ ꞊nʋ, ‑ɔ nɩ 'le ‑hanmakɩ wlɔn, ‑ɛ die nu, ‑Yusu 'mue nu, 'a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","‑Tɛ ‑Yusu 'ye, ‑ɛ mɔ, nahuin a ‑gbɛ, ʋ kuo ye ꞊wlʋ, ‑ɛ mɔ, ɔ ‑wɛ 'le bɔ nue nɩ, 'waa nɩ lɛ‑yɩyrɛnyɔ a ‑gbɛ, 'a 'kʋɛ 'mʋ ‑wɛ, ‑ye kɛ ɔɔ lɛ‑yɩyrɛnyɔ a ‑gbɛ ye po, ɔ nɔ: «'Na 'yu o, ‑tɔplɩ ‑gbo, ‑n nu, ‑ɩ nyre 'yi lɛ, 'ke 'o Nyɩsʋa ye, ɩ 'wʋwlɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","‑Ye teteitɔɔnyʋ, ‑ʋ nɩ 'o gbo, ʋʋ 'mʋ lɛ 'nɩ 'pʋprɛ, 'ke 'le 'waa dɩɔnʋ a ꞊wlɩ ke, ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Dɛ ‑gbo, ‑Yusu ‑gbo, ɔɔ nu, ɛ 'we ꞊nɔ ye, Nyɩsʋa a ‑tɩ ɔɔ lɛ ‑haa, 'ɔɔ lɛ 'pʋprɛ nu. 'Plɩɩ ɔ nɔ 'nɩ, ɔ mɔ Nyɩsʋa'a nɩ. Nyɩsʋaa ‑do, nɔ‑ ‑wɛ 'le ‑bɔ 'wʋwla ‑tʋnahuin a dɛ 'kuku.» ");
INSERT INTO ted_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Dɛ a ‑gbɛ, ʋʋ ꞊wlɩ klɛ naa, ‑Yusu yrie nɩ. Ɔ nɔ: «Dɛ tio‑ kɔ ꞊wlɩdʋ ꞊nʋ aa lɛ naa 'le? A 'de kɔ ba naa wɛn ꞊wlɩdʋ ꞊nʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","'A nɩ ꞊wlɩ nɔ 'nɩ, 'n 'die 'le ‑wɛ ꞊bo le lɛ‑yɩyrɛnyɔ ‑gbo, ‑ɛ mɔ, 'a dɛ 'kuku 'wʋwlɛ nɩ, kɔ, 'a nɩ ꞊wlɩ nɔ 'nɩ, 'n 'die ‑wɛ 'le ‑wɛ ꞊bo le ꞊nɔ, ‑ɛ mɔ, bɔ 'ba ye 'mʋ, bɔ 'ba 'a ‑hanmakɩ 'mʋ, bɔ na. ");
INSERT INTO ted_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Kɛɛ, 'mɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mɔ mɔ Nyɩsʋa a 'Yu, 'ɔ lee nɔ 'mʋ. Nyɩsʋa a ‑gbɛ, nɔ‑ ‑nye 'mʋ 'klɩ, 'ke ꞊bo 'wʋwla ‑tʋnahuin a dɛ 'kuku, kɛ nɔ ‑tʋtʋ ke, 'ɔ ‑nye ‑wɛ 'mʋ 'klɩ, 'ke ꞊bo ‑wɔ ‑tʋnahuin a 'kʋɛi. 'A ‑tɩ o, nahuon ‑gbo, ʋ ya 'le, 'n die 'nɩ nu, 'a 'kʋɛ 'mʋ ‑wɛ, a 'mue yrii, ‑ɛ mɔ, ‑tɩ ‑gbo, 'n ꞊tu wɛn 'a mʋ ye, ɩ mɔ ꞊hapʋkɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‑Ye ɔ ꞊hɩan ‑wɔn, 'ɔɔ 'le lɛ‑yɩyrɛnyɔ ꞊nʋ ‑wɔn 'prɛɛ, ɔ nɔ: «'Nɩɩ ‑mʋ 'nɩ le, 'ba ye 'mʋ, 'ba ‑na ‑hanmakɩ 'mʋ, ‑bo mu 'le ‑na kayu gbo, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tii ‑do a ti 'yri, ‑ye nahuon a ‑gbɛ, ɔ 'ba 'mʋ ye, 'ɔ 'ba 'a ‑hanmakɩ 'mʋ. Nahuin nyo ‑wɔn lɛ a tɛɛ, 'ɔ 'hrɩ, 'ɔ mu. ‑Ye nahuin, ‑ʋ nɩ 'o, ɩ ka ꞊nʋ lɛ 'ŋmi, 'ʋʋ Nyɩsʋa 'nyrɛɛ lɛ pue, ʋ nɔ: «‑A 'die ‑hlɩn a 'yee.» ");
INSERT INTO ted_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ti gbi bɩ ‑hi, ‑ye 'ke ‑Yusu mu 'le lele Galileblʋgba a 'yru nʋa 'mʋ, nahuin 'plɔplɔ 'ʋʋ 'le ꞊nɔ ye mu, 'ɔ nyu Nyɩsʋa a ‑tɩ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Bɔɔ 'yru a ‑gbɛ nʋa 'mʋ lɛ 'yraa, ‑ye 'ke ɔ yɛ 'o nyɩbɛyu ꞊de gbo. 'A 'dʋ mɔ Lefi, ‑ɔ mɔ Alʋfe a 'yu. Lefi a ‑gbɛ, ɔ mɔ la 'blʋwli'tɛnyɔ'ɔ nɩ. 'Ke ɔ nɩ 'le 'blʋwli'tɛɛlɛ 'mʋ gbo. Kɛɛ, nahuin 'nɩ ‑hʋa ꞊le la 'blʋwli'tɛnyʋ, ‑ɛ nue, ʋʋ di 'yiyriwli. ‑Ye kɛ ‑Yusu, ɔɔ Lefi a ‑gbɛ ye po: «Kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'na ‑naagbopʋyu ‑hɛ!» Lefi a ‑gbɛ 'ɔ 'ba ye 'mʋ, 'ɔ kʋɔ ‑wɔn, 'ke ɔ 'muo ‑wɔn naa. ");
INSERT INTO ted_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","‑Ye Lefi a ‑gbɛ, ɔ da ‑Yusu ‑wɔn dididɛ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, kɔ, 'ɔ da ‑wɛ 'a 'bienʋ 'blʋwli'tɛnyʋ ‑ye, kɔ pʋpʋnahuin ‑ye, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, 'ke ʋ 'bii ʋ 'mʋ dɛ di. ‑Ye nahuindʋ a ‑gbɛ, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, nʋ‑ ‑huo, nʋ‑ʋ ‑Yusu ‑wɔn kʋɛ. ");
INSERT INTO ted_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Bʋ nɩ 'o dɛdiilɛ 'mʋ, ‑ye ‑Juukʋɛ a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ʋ 'ye nɩ, ‑ɛ mɔ, ‑Yusu kɔ nahuindʋ a ‑gbɛ 'hɛɛn, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, nʋ‑ nɩ 'o dɛdi‑tuoo ‑do ke. ‑Ye ʋ le ‑Yusu a ‑naagbopʋ nɩ, ʋ nɔ: «Dɛ‑ nue 'klɛɛ, ‑Yusu kɔ 'blʋwli'tɛnyʋ kɔ nahuindʋ ‑gbo 'hɛɛn, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, 'ʋ nɩ 'o dɛdihuoo ‑do ke gbo 'le? Ɔ 'de wɛn ye blɛ bɔ nu wɛn dɛ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","‑Ye ‑Yusu 'wɔn ‑tɩ ꞊nʋ nɩ, nahuin ꞊nʋ, ʋʋ ꞊tu. Bɔ 'wɩn 'klɛɛ, ‑ye ɔ nɔ: «Nahuon ‑gbo, ‑ɔ kɔ 'hʋɩn nu ‑tɛɛ, ɔ 'nɩ ꞊mɔ ꞊le ‑data a 'yiye lɛ, kɛɛ, nahuon ‑gbo, ‑ɔ kɔ 'hʋɩɩn‑ hren, nɔ‑ɔ ‑data a 'yiye lɛ ꞊mɔ. 'N 'de 'le di, 'ke 'o nahuin ‑gbo a ‑ta 'mʋ, ‑ʋ plɛ, 'waa 'klɔ 'sii 'o ye, kɛɛ, nahuin ‑gbo, ‑ʋ yie, ‑ɛ mɔ, 'waa 'klɔ 'de 'o ye 'sii, nʋ‑ kɔ ‑tɩ 'nɩ di 'le, 'mu le, ‑ɛ mɔ, bʋ hie 'o 'waa dɛ 'kuku, ʋʋ nu gbo, bʋ ‑nye 'waa 'klɔ 'bii Nyɩsʋa.» ");
INSERT INTO ted_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","‑Nyrɔwɔ ꞊de 'mʋ, Saan Batisɩ, ‑ɔɔ nahuin 'nie 'lu lɛ po, 'a ‑naagbopʋ, ʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, nʋ‑ʋ ꞊ci, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'waa tetee 'a ꞊tutue nu, nahuin ꞊de 'ʋ mu 'le ‑Yusu ye, 'ʋ muo wlɔn ꞊gba wɔn, ʋ nɔ: «Dɛ‑ nue 'klɛɛ, Saan a ‑naagbopʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn 'ʋʋ ꞊ci, 'plɩɩ ‑mɛ ‑ye, ‑n nɛ ‑naagbopʋ 'ʋ 'nɩnɩ ꞊ci 'le?» ");
INSERT INTO ted_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «Nyɩbɛyu ‑gbo, ‑ɔɔ 'blɩ 'mʋ pa, 'bɔ da 'a 'bienʋ 'blɩ'mʋpʋpa a dididɛ ke, 'bʋ mu 'blɩ'mʋpʋpa a ‑gbɛ a dɛdi‑tuo ke, 'a 'bienʋ a ‑gbɛ, ʋ 'nɩ ꞊ci ꞊le. Ɛ 'we ꞊nɔ ye, 'blɩ'mʋpʋpa ꞊nʋ, ɛ mɔ 'manʋdɛ'ɛ nɩ. 'A ‑tɩ, ti 'bii ꞊nʋ, 'blɩ'mʋpanyɔ ꞊nʋ, ɔ di 'o ꞊nʋ 'hʋɩn 'mʋ ‑hi, ʋ 'de ꞊cicie kɔ. Dɛɛ ‑do a ‑gbɛ, nɛ‑ɛ nɩ. 'Manʋ a ‑tɩ 'na ‑naagbopʋ 'nɩ ꞊ci ꞊le nɩ, tii ‑tie ‑gbo 'n di mɔ ꞊nʋ 'hʋɩn 'mʋ ‑hi. ");
INSERT INTO ted_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kɛɛ, ɛ di kɔ ti, ‑ɩ kɔ 'yri ʋ di ‑tado 'o 'mʋ 'na ‑naagbopʋ ‑hɛyri ‑ha. Ti a ‑gbɛ 'yri, 'ke ʋ di ‑tado 'o ꞊cii. ");
INSERT INTO ted_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","‑A 'brikʋɛ nɔ 'nɩ: Nahuon ꞊de 'nɩ 'ba ꞊le dayrayrʋ a 'pɩa 'mʋ, ɔ 'nɩ ‑ma ꞊le da'ka a 'hʋɔ. 'Bɩa 'bɔ nu dayrayrʋ a 'pɩa, 'bɔ ‑ma da'ka a 'hʋɔ, ti ‑kɔ 'yri ɔ diu yra, ‑ye dayrayrʋ ꞊nʋ, ʋ 'yɩya 'mʋ nɩ. 'Bʋ 'yɩya 'mʋ, ‑ye dayrayrʋ a ‑gbɛ, ʋ cra da'ka ꞊nʋ nɩ, ‑ye 'a 'hʋɔ 'ka ꞊nʋ, ɔ di lɛ 'bʋa 'yri ꞊hapʋkɔ. ");
INSERT INTO ted_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mɔ, nahuon ꞊de 'nɩ 'ba ꞊le nɔ yrayrɩ 'mʋ, ‑ɔɔ 'plu, ɔ 'nɩ puo ꞊le 'le dahʋakɔ a buo 'ka wlɔn. 'Bɔ puo 'le buo 'ka ꞊nʋ wlɔn, 'bɔ kɔ ye, ti ‑kɔ ti 'yri ɔ di 'plu, 'bɔɔ 'ya, ‑ye ɔ cra dahʋakɔ a buo ꞊nʋ nɩ. ‑Ye nɔ 'wlɛ gbo. Nɛ‑ nue, 'ke 'le dahʋakɔ a buo yrayrʋ wlɔn, 'ke ʋʋ 'le nɔ yrayrɩ po. (Ɛ nɛ‑ nue o, nahuon ꞊de 'ɔ 'nɩnɩ 'ba ‑tɔplɩ 'kɩ 'mʋ, 'ɔ 'nɩnɩ pui ‑tɔplɩ yrayrɩ ke. Ɩ 'nɩ bibi ꞊le 'yi 'mʋ lɛ.)» ");
INSERT INTO ted_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","‑Wuwle‑nyrɔwɔ ꞊de 'mʋ, ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn 'ʋ mu lɛ na wɔn. Bʋʋ 'klɛɛ mu, ‑ye ʋʋ ꞊tɩɔ 'bɛ 'dɩdɔ‑tɔplɩ ꞊de a ‑ci, ‑ɩ 'we ꞊nɔ ꞊gbla ye. Nɔ‑ kɔ 'hlɛ gbi 'a ‑naagbopʋʋ 'cɛ, 'ʋ nye di. ");
INSERT INTO ted_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","'Ke Falisi꞊tumu a nahuin nɩ 'le ‑ci a ‑gbɛ 'mʋ. ‑Tɛ ‑Yusu a ‑naagbopʋ, ʋʋ 'dɩdɔ‑tɔplɩ ꞊nʋ a 'hlɛ gbi 'cɛ, ‑ye ʋʋ 'klɛɛ ‑Yusu 'nɩ le, ʋ nɔ: «'Ye kɛ, dɛ ‑gbo, ‑na ‑naagbopʋ, ʋʋ nu, ɩ ꞊ŋa nɩ. Nyɩsʋa a tete nɔ 'nɩ: Nahuon nɩ nu 'le ‑kʋan ‑wuwle‑nyrɔwɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","‑Ye ɔ nyu ꞊tu ꞊wɔn: «‑Tɩ ‑gbo, ʋ 'crɩɩ la 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, 'ke 'o ‑a nɩ bu gblaka, ‑ɔ mɔ bodɩɔ Dafidɩ a ‑ta 'mʋ, 'n pui ‑tɛɛ, a ‑hri nɩ. ‑Tɩ a ‑gbɛ, ʋ 'crɩɩ la, nɩ‑ ‑gbo: ‑Nyrɔwɔ ꞊de 'mʋ, bodɩɔ Dafidɩ, ‑tɛ kanʋ nyo la nu, ɔ kɔ 'a nahuin 'hɛɛn, ");
INSERT INTO ted_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","'ɔ pa la 'le Nyɩsʋa a kayu gbo, 'ɔ ‑ha la 'o 'flɔɔ, ‑ɔ pɛ la 'o 'teble ke gbo, 'ɔ dio la, 'ɔ ‑nye la 'a dɛ ‑ye 'a nahuin, 'ʋ dio la ‑wɛ. 'Plɩɩ ‑ye tete nɔ 'nɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋʋ ‑do, nʋ‑ ‑wɛ 'le ‑bʋ di 'flɔɔdʋ a ‑gbɛ. 'Be 'flɔɔdʋ a ‑gbɛ, ‑ɔ nɩ 'le Nyɩsʋa a kayu a ‑gbɛ gbo, ʋ ‑hɩɔ la nɩ, 'ke 'o Nyɩsʋa a ‑ta 'mʋ. Ti a ‑gbɛ 'yri, nyɩbɛyu ꞊nʋ, ‑ɔ mɔ Abiata, nɔ‑ mɔ la ‑cɔhlʋnpinyʋ a nyɩgblaka.» ");
INSERT INTO ted_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","‑Ye kɛ ɔ nyu lele ye po: «‑Tɛ Nyɩsʋa nu la 'klɔ, ‑ye ɔ nu la ‑tʋnahuon, 'plɩɩ 'ɔ ‑ha la 'le ‑nyrɔwɔɔ ‑do, ‑ɔ kɔ 'kwli 'mʋ ‑tʋnahuon di 'le ‑wlee, ɔ 'mʋ 'le 'hʋɩn lɛ ‑ha. Nyɩsʋa 'de 'le ‑wuwle‑nyrɔwɔ ‑ha, 'ke nahuon bɔ 'ye ꞊sʋɛ ‑nyrɔwɔ a ‑gbɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ɛ nɛ‑ nue, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, Nyɩsʋa 'ɔ lee nɔ 'mʋ, 'ɔ ‑nye 'mʋ 'klɩ, 'ke ꞊bo le 'ɛ nɩ nahuon dɛ, ɔ ‑wɛ 'le bɔ nu, 'ke 'le ‑wuwle‑nyrɔwɔ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","‑Wuwle‑nyrɔwɔ ‑ye 'mʋ, ‑Yusu 'ɔ mu 'le lele Nyɩsʋa a kayu gbo. 'Ke ɔ yɛ 'le nyɩbɛyu ꞊de gbo. Nyɩbɛyu a ‑gbɛ, 'a dabʋ 'kʋ la nɩ. ");
INSERT INTO ted_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bʋ nɩ 'klɛɛ 'o, ‑ye Falisi꞊tumu a nahuin, ‑ʋ nɩ 'o, ʋʋ ke gbaa 'yie, 'ʋʋ ‑Yusu 'ye, 'bɩa 'bɔ kɔ bɔ ‑wɔ nyɩbɛyu a ‑gbɛ a 'kʋɛ ‑wuwle‑nyrɔwɔ 'mʋ, ‑ɛ die nu, 'bɔ nue, ʋ 'muo ‑tɩ yɛɛ. (Falisi꞊tumu a nahuin nɔ 'nɩ, nahuon a 'kʋɛ a ‑wʋwɔ, ɛ mɔ ‑kʋaan nɩ. 'Plɩɩ Nyɩsʋa a tete nɔ 'nɩ, nahuon nɩ nu 'le ‑kʋan ‑wuwle‑nyrɔwɔ 'mʋ.) ");
INSERT INTO ted_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","‑Ye ‑Yusu le nyɩbɛyu a ‑gbɛ nɩ, ɔ nɔ: «'Ba ye 'mʋ, ‑bo nyra 'o nahuin ‑hɛyri 'mʋ gbo!» ");
INSERT INTO ted_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","‑Ye ‑Yusu, ɔɔ Falisi꞊tumu a nahuin wlɔn 'nɩ ꞊gba: «‑Be' Nyɩsʋa a tetee po 'le? Nahuon bɔ nu ꞊hapʋdɛ ‑wuwle‑nyrɔwɔ 'mʋ, kɔ, bɔ nu dɛ 'klan, dɛ tio‑ nu ‑tɛɛ 'le? Nahuon bɔ waa 'a 'be ‑wuwle‑nyrɔwɔ 'mʋ, ɔ 'nɩ ꞊han 'kʋ a ‑tɩ, kɔ, bɔ ‑ha 'a 'be a ‑hʋnhlʋn mɛ lɛ bʋ 'wan, dɛ tio‑ nu ‑tɛɛ 'le?» ‑Ye ʋ 'bii, ʋ nu ‑miaa. Ʋ 'die ‑hʋa, 'ke bʋ ꞊tuo ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","‑Yusu 'ye nɩ, ‑ɛ mɔ, nahuin ꞊nʋ, 'waa 'lu a lɛ‑hielɛ nyre lɛ 'yi, kɔ, ʋ 'de nahuon ꞊de a wɔlɩ kɔ. Nɛ‑ nue, ‑Yusu 'ɔ ‑ha 'le yrʋ yigbakla, 'ɔ nyu 'ye, kɔ, 'kla 'ɔ nyo ‑wɛ ‑wliye 'yaa. ‑Ye kɛ ɔ po nyɩbɛyu a ‑gbɛ ye: «Srʋʋ ‑na dabʋ ꞊nʋ, ‑ʋ 'kʋ!» ‑Ye ɔ srʋʋ nɩ. Bɔ srʋʋ 'klɛɛ 'a dabʋ a ‑gbɛ, ‑ye ʋ 'hrɩ 'klɔ, 'ʋ bi 'o 'a dɩɔnʋ ꞊pɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","‑Tɛ ‑Yusu ‑wɔ 'klɛɛ nahuon a ‑gbɛ a 'kʋɛ, ‑ye Falisi꞊tumu a nahuin a ‑gbɛ, ʋ ‑hɔn 'o 'mʋ nɩ, 'ʋ mu ‑gboligbo 'mʋ, ʋ kɔ 'kɩɩn Helɔdɩ a ꞊tumu a nahuin 'hɛɛn, 'ʋ mu ꞊tɔ lɛ ꞊mɔ wɔn, ‑tɛ bʋ di nu, ʋ 'mʋ ‑Yusu 'la. ");
INSERT INTO ted_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye 'ke ‑Yusu mu 'le Galileblʋgba a 'yru nʋa 'mʋ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, nahuin 'plɔplɔ 'ʋ nyo ‑wɔn kʋɛ. Nahuin a ‑gbɛ, ꞊ʋ ‑ye ‑hɔn 'le Galileblʋgba 'mʋ, kɔ ꞊ʋ ‑ye 'ʋ ‑hɔn 'le Sudeblʋgba 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","kɔ Jrusrɛ 'mʋ, kɔ Yidumeblʋgba 'mʋ, kɔ 'blʋgba ꞊nʋ, ‑ɔ nɩ 'le Sudɛn a 'nike, kɔ 'blʋgbɩ ꞊nʋ, ‑ɩ ꞊glaa 'le 'dɩɛ ꞊nʋ, ‑ɛ mɔ Tilɩ kɔ Sidɔ 'hɛɛn. Nahuin 'bii ꞊nʋ, ‑ʋʋ 'le 'waa 'dɩɛ klɛ 'mʋ lɛ ‑hɔn, ‑tɔplɩ 'bii ꞊nʋ, ‑Yusu nu, nɩ‑ kɔ ‑tɩ ʋ 'wɔn. Nɛ‑ nue, 'ʋ nyo ye di. ");
INSERT INTO ted_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","‑Ye ɔ le 'a ‑naagbopʋ nɩ, 'ke bʋ ꞊mɔɔ ꞊nɔ 'blagbe lɛ, ‑ɛ die nu, dakʋ 'bʋʋ ꞊nɔ ‑hʋnhlʋn 'mʋ lɛ kɩka, ɔ 'mue 'le wlɔn 'ya. ");
INSERT INTO ted_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","'Plɩɩ ɔ 'mʋ 'le 'yru nʋa 'mʋ mu, ɔ ‑wɔ nahuin 'plɔplɔ a 'kʋɛi. Nɛ‑ nue, nahuin 'bii, ‑ʋ kɔ 'hʋɩn a hinhren, 'ʋʋ 'kɩka, 'ʋ nyo 'o 'hʋɩn 'mʋ ꞊gbee, 'ɛ nɩ nahuon, ɔ 'mʋ ‑Yusu lɛ 'tʋ, 'a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","'Waa 'bie ꞊nʋ, ‑ʋ kɔ ke 'mʋ 'kuo ‑hʋɩn nɩ 'o, 'bʋ 'yo, ‑ye ʋ bla gbo kwlɩ, 'ke 'o ꞊nɔ ye, kɔ, 'ʋʋ 'le win 'le 'yaa 'dɔ, ʋ nɔ: «‑Mɔ mɔ Nyɩsʋa a 'Yuu nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kɛɛ ‑ye ‑Yusu nyu 'le ‑wɔn 'nɩ 'prɛɛ, 'ke 'le win 'yaklɩ 'kwli 'mʋ, 'ke ʋ nɩ ꞊tui 'le nahuon ꞊de ye, nahuon a gblo tio‑ bɔ 'ya 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye 'ke ‑Yusu 'ya 'le dʋgba ꞊de 'lu. ‑Ye nahuin ꞊nʋ, ɔɔ ‑hʋa ‑bʋ 'ya 'a ‑wɔnnaanyʋ 'mʋ, nʋ‑ ɔ da, 'ʋ mu 'o ꞊nɔ 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ʋ mɔ nahuiin ‑pu ꞊tu 'o 'hɔɔn nɩ. Nʋ‑ ɔ ‑ha 'le du 'mʋ, 'ɔ nuu ꞊nʋ 'a ‑wɔnnaanyʋ 'mʋ, ‑ɛ die nu, ʋ 'muo 'o 'hʋɩn 'mʋ nɩ ti a pɛpɛ, kɔ, ɔ 'mu le, 'ke bʋ pue nahuin 'a ꞊hapʋtitie, ");
INSERT INTO ted_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","kɔ, ɔ 'mʋ ꞊nʋ 'klɩ ‑nyi, 'ke bʋ bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","'A ‑wɔnnaanyʋʋ ‑pu ꞊tu 'o 'hɔn a ‑gbɛ, 'waa 'dʋɩ, ɩ nɩ‑ ‑gbo: Simɔ, ɔ ꞊tue Piɛlɩdʋ, ");
INSERT INTO ted_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","kɔ Sebede a 'yuo꞊pli, ‑ʋ mɔ Sakɩ, ɔ kɔ 'a 'dɩayu Saan 'hɛɛn. ‑Yusu ꞊tue ꞊nʋ Bʋanɩsɛsɩdʋ, ‑ɛ ꞊hɛn 'nyrɛ 'yuo꞊pli, ‑ʋ 'we ꞊nɔ ‑tɛ ye; ");
INSERT INTO ted_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","kɔ Adre, kɔ Filipʋ, kɔ Batelemi, kɔ Matie, kɔ Toma, kɔ Sakɩ, ‑ɔ mɔ Alʋfe a 'yu, kɔ Tade, kɔ Simɔ. Simɔ a ‑gbɛ, 'ke ɔ nɩ 'le nahuin ꞊nʋ ‑hɛyri, ‑ʋ 'nɩnɩ ‑hʋa Romakʋɛ; ");
INSERT INTO ted_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kɔ Judɩa Yisikalio. Nɔ‑ mɔ nahuon ꞊nʋ, ‑ɔ di ‑Yusu 'a yraanyʋ kwa po. ");
INSERT INTO ted_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye 'ke ‑Yusu mu 'le kayu gbo, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, kɛɛ, nahuin 'plɔplɔ 'ʋ ꞊glaa 'le lele ꞊nɔ. Ɛ nue, ʋ 'nɩ kɔ ꞊le 'hru, 'ke bʋ di dɛ. ");
INSERT INTO ted_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","‑Tɛ 'a 'dʋkʋɛ 'wɔn dɛ ꞊nʋ, ‑ɛɛ 'lu ‑wɔn mue, ‑ye ʋ ‑mɛ ‑ye, ʋ da, 'a 'lu ‑hɔn 'o wlɔn 'mʋ 'hru. Ɛ nɛ‑ nue, 'ʋ bi 'hru wlɔn, 'ke 'o 'a gbʋgba a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nyɩsʋa a teteitɔɔnyʋ ꞊de, nʋ‑ ‑hɔn la 'le Jrusrɛ 'mʋ, ʋ nɔ: «‑Yusu ‑gbo, Bɛsebulɩ, ‑ɔ mɔ 'kuo ‑hʋɩn a nyɩgblaka Satan, nɔ‑ nɩ 'o ꞊nɔ ke 'mʋ, nɔ‑ɔ ꞊nɔ 'klɩ ‑nyi, 'ke bɔ bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Bʋ po 'klɛɛ lɛ, ‑ye ‑Yusu dʋ nɩ, 'ɔɔ ‑talʋdʋɩ nu, 'ɔ nyu klɛ ‑hɩhɩa, ɔ nɔ: «꞊Be Satan, ɔ ‑wɛ 'le bɔ bla 'a dɩɔnʋ lɛ nɩ? ");
INSERT INTO ted_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","꞊Bo pue dɛ ye: 'Ke 'le 'blʋgba 'kwli 'mʋ, nahuin 'bʋ 'bɛ ꞊tɩɔ lɛ, ‑ye 'blʋgba a ‑gbɛ, ɔ bi ꞊hlɔn. ");
INSERT INTO ted_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","'Ya 'o lele 'lu, kayugbokʋɛ 'bʋ 'bɛ ꞊tɩɔ lɛ, ‑ye kayu a ‑gbɛ, ʋ ‑gbɛ lɛ. ");
INSERT INTO ted_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","‑Ye 'klɛɛ, Satan 'bɔɔ 'a dɩɔnʋ ye ‑wɔn, ‑ye ɔ 'die 'le ‑wɛ bɔ nu dɛ ꞊de, 'a 'klɩ di gbo 'nɩ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ɛ 'we ꞊nɔ ye, nahuon ꞊de 'die 'le ‑wɛ bɔ pa 'le 'klɩnyɔ a kayu gbo, ɔ 'mʋ 'a ‑tɔplɩ 'yri, 'bɩa 'bɔ 'de 'klɩnyɔ a ‑gbɛ mʋa ‑tɩtɛ. 'Bɔ mʋɔ 'klɛɛ, ‑ye ɔ ‑wɛ 'le bɔ 'yri 'a kayu a ‑tɔplɩ 'bii nɩ. ");
INSERT INTO ted_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, Nyɩsʋa ‑wɛ 'le bɔ 'wʋwla nahuin a dɛ 'kuku 'bii nɩ, ꞊betɩ bʋ poo Nyɩsʋa tanɩ lɛ. ");
INSERT INTO ted_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kɛɛ, nahuon ꞊nʋ, ‑ɔ di Nyɩsʋa a ‑Hihiu tanɩ lɛ poo, Nyɩsʋa 'die 'le ‑wɛ bɔ 'wʋwla 'a dɛ 'kuku a ‑gbɛ gbe, ‑ɛ nue, ɔ nu dɛ 'kuku, ‑ɛ hie 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Kɛ ‑Yusu nu la 'waa klɛ‑hɩhɩalɛ, ‑ɛ nue, ʋ nɔ 'nɩ, 'ku ‑hʋan nɩ 'o ꞊nɔ ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","'Ke ʋ nɩ 'le kayuu ‑do a ‑gbɛ gbo, 'a 'dii kɔ 'a 'dɩayuo nyɩbɛpʋ 'hɛɛn 'ʋ nyre 'o. 'Ke ʋ hree 'o ‑patʋ 'mʋ, 'ʋ le nahuon, 'ɔ mu ‑Yusu da wɔn. ");
INSERT INTO ted_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","'Dai nahuin nɩ gbo, 'ʋ ꞊glaa 'le ꞊nɔ. ‑Ye kɛ ʋ nyo ye po: «'Ye kɛ, ‑na 'dii kɔ ‑na 'dɩayuo, 'ke ʋ nɩ 'le ‑patʋ 'mʋ, ‑mɔ ʋʋ da.» ");
INSERT INTO ted_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","‑Ye ɔ nɔ: «꞊Ʋ ‑ye mɔ ‑wɛ 'na 'dii kɔ 'na 'dɩayuo,» ");
INSERT INTO ted_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","'ɔ 'ba 'yii ye 'mʋ, 'ɔ 'ye nahuin ꞊nʋ, ‑ʋ nɩ gblɛ, ‑ʋ ꞊glaa 'le ꞊nɔ, ‑ye ɔ nɔ: «Ba 'ye kɛ, nahuin ‑gbo, nʋ‑ mɔ ‑wɛ 'na 'dii kɔ 'na 'dɩayuo. ");
INSERT INTO ted_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nahuin ꞊nʋ, ‑ʋʋ Nyɩsʋa a kewɛɛnlɛ nu, nʋ‑ mɔ ‑wɛ 'na 'dɩayuo kɔ 'na 'dii.» ");
INSERT INTO ted_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusu 'ɔ mu 'le lele Galileblʋgba a 'yru nʋa 'mʋ, 'ɔɔ 'le Nyɩsʋa a ‑tɩ nahuin tɔɔ, nahuin 'plɔplɔ 'ʋ ꞊glɔɔ 'le. Bɔ 'nɩnɩ 'ye 'hru, nɛ‑ nue, 'ɔ 'ya 'le 'blagbe wlɔn, 'ɔ nɩ gbo, 'ɔ 'yɩya 'le 'nie ke gbo, nahuin a ‑gbɛ 'ʋ 'wlɛ 'o 'nie nʋa 'mʋ gbo, ");
INSERT INTO ted_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","'ɔ nyu ‑tɔplɩ 'plɔplɔ tɔɔ, 'ke 'le ‑talʋdʋɩ 'kwli 'mʋ. Kɛ ɔ nyu 'klɛɛ ye po: ");
INSERT INTO ted_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Ba po 'mʋ nʋa ye gbo. Ɛ kɔ la ‑nyrɔwɔ ꞊de, nyɩbɛyu ꞊de 'ɔ mu la 'a ‑tɔplɩ 'dɔ wɔn. Ɔ nyi lɛ 'nɩ ‑gbla, 'ke 'le 'a ‑ci 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","‑Tɛ ɔ nyi lɛ ‑gbla, ‑ye 'ke ꞊ɩ ‑ye bi 'o 'hru wlɔn lɛ, nʋblɩ 'ɩ di 'le, 'ɩ di. ");
INSERT INTO ted_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Gblo a 'hɔn a nɔnɔ, ɔɔ lɛ ‑gbla, ‑ye 'ke ɔ bi 'o ‑tʋtʋtɩɔ ꞊nʋ ke, ‑ɔ kɔ gbo 'hɩɔ 'pa nɩ 'le, 'ɔ ‑hlɛntie ‑tɛɛ, 'ɔ ꞊ga ‑wɛ 'tata, ‑ɛ nue, ‑tʋtʋtɩɔ a ‑gbɛ, ɔ 'de la 'mʋ gbo hren. ");
INSERT INTO ted_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga 'klɛɛ, 'yrʋ bi 'le yrayrɩ, ‑ye 'a ꞊gagɛi 'yrɔ nɩ, ‑ɛ nue, 'a ‑wlubʋɩ kʋɛ 'hɩɔ a ‑gbɛ ye. ");
INSERT INTO ted_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Gblo a ta a nɔnɔ, ɔɔ lɛ ‑gbla, ‑ye 'ke ɔ bi 'le 'witi a ꞊gagɛi ‑gbahlɔn. ‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga, ‑ye 'witilili ꞊nʋ, ɩ 'ya 'o ꞊o, 'ɩ 'bui 'lu lɛ. 'A ‑tɩ, ɩ 'de 'hlɛ po. ");
INSERT INTO ted_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gblo a ‑hɛn a nɔnɔ, ɔɔ lɛ ‑gbla, nɔ‑ bi 'o ꞊hapʋ‑tʋtʋ ke. ‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga, ‑ye ɩ ku nɩ ‑tɛɛ, 'ɩ po 'hlɛ. 'A 'hlɔɔ ‑do, ɔ po 'yɔ a (30) ‑wlʋ ꞊tu 'o ‑pu, ꞊ɔ ‑ye po 'yɔ a (60) ‑wlɩɩ ta, 'a 'be ‑ye po 'yɔ a (100) ‑wlɩɩ ꞊hun.» ");
INSERT INTO ted_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","‑Ye kɛ ‑Yusu nyu la 'klɛɛ ye po: «'Bɩa 'ba kɔ ‑tɩ'wɔnnʋa, ‑ye ba 'wɔn ‑tɩ ‑dodo.» ");
INSERT INTO ted_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ti gbi bɩ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn 'hɛɛn, kɔ pʋpʋ‑naagbopʋ ‑ye, ɔ kɔ ꞊nʋ 'hɛɛn, ʋ ‑do, nʋ‑ nɩ la 'o. ‑Ye ʋ ꞊gbɔ wlɔn: «‑Talʋdʋ ‑gbo, ‑n po, dɛ tio‑ ɛ ꞊hɛn 'nyrɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","‑Ye ɔ nɔ: «'A mʋ ‑gbo, ‑ʋ mɔ 'na ‑naagbopʋ, Nyɩsʋa nye 'nɩ nu, 'aa Nyɩsʋa a ‑tɩ 'mʋ lɛ yrii, ‑tɛ ɔɔ nu, 'ɔ kɔɔ nahuin win ke. Nyɩsʋa a ‑tɩ a ‑gbɛ, ɩ ‑hli nahuin ke 'yi. Nahuin ‑gbo, ‑ʋ 'nɩnɩ naa 'mʋ ‑wɔn, ʋ ‑mɛ ‑ye, 'ke ʋ nyi 'le ‑talʋdʋɩɩ ‑do 'kwli 'mʋ 'wɔɔn. ");
INSERT INTO ted_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ɩ ‑do a ‑gbɛ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Ʋ nyi 'nɩ 'ye ‑tɛɛ, kɛɛ, ʋ 'nɩ yrii ꞊le lɛ, 'ʋ nyi ‑wɛ 'wɔn ‑tɛɛ, kɛɛ, ʋ 'nɩ yrii ꞊le 'mʋ lɛ. 'Bɩa 'bʋ nyi wɛn 'mʋ lɛ yrii, ‑ye ʋ di wɛn ‑wɔn 'nɩ ꞊hɩan, ʋ 'mʋ wɛn 'waa nɩ 'klɔ Nyɩsʋa ‑nyi, ‑ye Nyɩsʋa di wɛn 'waa dɛ 'kuku 'nɩ 'wʋwla.» ");
INSERT INTO ted_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","‑Ye ɔ nyu lele 'nɩ le: «'Bɩa 'ba 'nɩnɩ yrii ‑talʋdʋ ‑gbo 'mʋ lɛ, ‑ye a 'die 'le ‑wɛ ba yrii ꞊ɩ ‑ye ꞊nʋ 'mʋ lɛ gbe.» ");
INSERT INTO ted_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kɛ ɔɔ 'klɛɛ po: «Ɛ 'we ꞊nɔ ye, 'dɩdɔnyɔ ꞊nʋ, nɔ‑ mɔ nahuon ‑gbo, ‑ɔɔ Nyɩsʋa a wintɛ ‑wɔn lɛ na. ‑Ye 'dɩdɔ‑tɔplɩ ꞊nʋ, nɩ‑ mɔ Nyɩsʋa a wintɛ. ");
INSERT INTO ted_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","‑Ye 'hru ꞊nʋ, ‑ʋ kɔ wlɔn ɩ bi 'o lɛ, 'plɩɩ nʋblɩ 'ɩ di 'le, 'ɩ di, nʋ‑ mɔ nahuin ‑gbo, ‑ʋʋ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ Satan, ‑ɔ mɔ 'kuo ‑hʋɩn a nyɩgblaka, 'ɔɔ 'le di, 'ɔɔ 'le ꞊nʋ Nyɩsʋa a wintɛ a ‑gbɛ ꞊wlʋ ke ‑ha. ");
INSERT INTO ted_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","‑Ye ‑tʋtʋtɩɔ ꞊nʋ, ‑ɔ nɩ 'o 'hɩɔ 'pa ke, ‑ɔ kɔ ke 'dɩdɔ‑tɔplɩ ‑ye ꞊nʋ, ɩ bi ‑wɛ 'o, nɔ‑ mɔ nahuin ‑gbo, ‑ʋʋ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ ‑ʋ nye ke wɛɛn, 'ke 'le plɔ a bleelɛ 'kwli 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","'plɩɩ ‑ʋ nye ‑wɛ kwa 'ble, 'ke 'o ti 'cicrɛi gbi ‑wɔn. Kɛɛ, ʋ 'nɩ ‑hʋɛ ꞊le, 'ke bɛ po 'ma, 'ke 'le ꞊nʋ ꞊wlʋ ke. Nahuin a ‑gbɛ, 'waa 'bienʋ, ‑ʋ 'nɩnɩ ‑hʋa Nyɩsʋa a wintɛ, 'bʋ nyu ꞊sʋɛ ꞊tue, kɔ 'bʋ yrʋʋ, nɛ‑ mɔ nahuin a ‑gbɛ, 'waa nɩ Nyɩsʋa a ‑tɩ bɩ sɩa ꞊nʋ. ");
INSERT INTO ted_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","‑Ye ‑tʋtʋtɩɔ ꞊nʋ, 'witi a ꞊gagɛi nɩ 'o ke, ‑ɔ kɔ ke 'dɩdɔ‑tɔplɩ ꞊nʋ, ɩ bi ‑wɛ 'o, ");
INSERT INTO ted_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nʋ‑ mɔ nahuin ‑gbo, ‑ʋʋ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ nahuin a ‑gbɛ 'ʋʋ 'klɔ ke a 'kla‑wliye'yɩya a hrɛtilɛ hrɛti, kɔ 'ʋʋ kʋkɔ‑tɔplɩ ꞊wlɩ klɛ naa, ‑ɩ nyu 'le kɩka 'mʋ po, 'plɩɩ 'waa ꞊wlɩ 'ɩɩ 'klɔ ‑gbo a ‑tɔplɩ ‑ye ‑wɔn lɛ kʋɛ, ʋ nʋɛ 'mʋ. ‑Tɔplɩ 'bii a ‑gbɛ, ɩ nue, Nyɩsʋa a wintɛ, 'ɛ 'nɩnɩ nu ‑kʋan, 'ke 'le ꞊nʋ ꞊wlɩ ke, 'plɩɩ 'ɛ hihre lɛ. ");
INSERT INTO ted_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","‑Ye ꞊hapʋ‑tʋtʋ ꞊nʋ, ‑ʋ kɔ ke 'dɩdɔ‑tɔplɩ ‑ye ꞊nʋ, ɩ bi ‑wɛ 'o, nʋ‑ mɔ nahuin ꞊nʋ, ‑ʋʋ Nyɩsʋa a wintɛ 'wɔn, ‑ʋ nye kwa 'ble, 'ɛɛ ‑kʋan nu, 'ke 'le ꞊nʋ ꞊wlʋ ke, gblei a (30) ‑wlʋ ꞊tu 'o ‑pu, kɔ (60) ‑wlɩɩ ta, kɔ (100) ‑wlɩɩ ꞊hun, 'ɛ ‑hi 'o ‑tɛ ʋ nu o 'a 'wʋnwɔn 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Kɛ ‑Yusu nyu lele ye po: «Nahuon 'bɔ 'bɩa 'napɩ, ɔ 'nɩ ꞊jre ꞊le kaka 'lu gbo, kɔ, nahuon 'bɔ 'bɩa 'napɩ, ɔ 'nɩ ꞊tue ꞊le 'le ‑bɛlɛ gbo. Kɛɛ, 'ke ɔ nye 'le dɛ 'klɔ gbo ꞊tu, ‑ɛ die nu, ɛ 'mʋ kayu gblɛ yri. ");
INSERT INTO ted_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","‑Tɔplɩ 'bii, ‑ɩ ‑hli, ɛ di kɔ ‑nyrɔwɔ, ɩ 'mʋ pepe' 'mʋ lɛ bi, kɔ, ‑tɔplɩ 'bii, nahuon ꞊de 'de o yi, ɛ di kɔ ‑nyrɔwɔ, ɩ 'mʋ 'mʋlɛyriilɛ kɔ. ");
INSERT INTO ted_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ba po 'mʋ nʋa ye gbo ‑tɛɛ: Nahuon 'bɔ nɩ 'o, 'bɔ kɔ ‑tɩ'wɔnnʋa, bɔ 'wɔn ‑tɩ ‑dodo.» ");
INSERT INTO ted_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","‑Ye kɛ ɔɔ lele ꞊nʋ ye po: «Nyɩsʋa a wintɛ ‑gbo, 'nɩɩ ‑wɔn lɛ na, ba ꞊tue 'yie. ‑Tɛ a di 'a 'wʋnwɔn nu, kɛ Nyɩsʋa di 'a mʋ 'a 'mʋlɛyriilɛ nu. ");
INSERT INTO ted_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Nahuon ꞊nʋ, ‑ɔɔ Nyɩsʋa a wintɛ nʋa ye gbo po, Nyɩsʋa die 'nɩ nu, ɔ 'mue 'mʋ lɛ yrii, ɛ 'mʋ 'o ‑tɛ ɔ nu o 'a 'wʋnwɔn 'mʋ ‑hi. Kɛɛ, nahuon ꞊nʋ, ‑ɔ 'nɩnɩ pue nʋa ye gbo, ɔ 'nɩ yrie ꞊le 'mʋ lɛ nɩ gbe.» ");
INSERT INTO ted_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Kɛ ‑Yusuu lele ꞊nʋ ye po, ɔ nɔ: «‑Tɛ Nyɩsʋaa nahuin a win a kekɔɔlɛ nu, ɛ 'we ꞊nɔ ye nahuon ‑gbo, ‑ɔ ‑gbla 'dɩdɔ‑tɔplɩ lɛ, 'ke 'le 'a ‑ci ke. ");
INSERT INTO ted_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","‑Tɛ ɔ ‑wɔ 'a lɛ‑gbʋgbla ‑wɔn, ‑ye ɔ mu 'mʋ 'dɩɔ. ‑Nyrɔwɩ 'bii, ɔɔ 'le 'dɩɔ 'mʋ ‑hi, ‑ye 'dɩdɔ‑tɔplɩ ꞊nʋ, ɔ ‑gbla o lɛ, 'ke 'le ‑ci ke, ɩ ‑do, ɩɩ 'nɩ ꞊ga, mɔ, ɔ 'nɩ ‑hi ꞊le 'le ‑ci a ‑gbɛ ke. ");
INSERT INTO ted_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","‑Tʋtʋʋ ‑do, nʋ‑ nye nu, 'ɩɩ ꞊ga. 'A ꞊gbaa ‑do, nɔ‑ ꞊ga ‑tɩtɛ, 'ɔ ku, 'ɔ po 'hlɛ, 'plɩɩ 'a 'yɔ ꞊nʋ, 'ɔ ku. ");
INSERT INTO ted_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊hlu, ‑ye ɔ mu nɩ, 'ɔ gba 'a ‑faka, 'ɔ 'cɩ, ‑ɛ nue, 'a 'cɩcɛti nyre 'o ꞊o.» ");
INSERT INTO ted_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Kɛ ‑Yusuu lele ꞊nʋ ye po, ɔ nɔ: «'N di po ‑talʋdʋ ‑ye, 'mue 'a mʋ tɔɔ, ‑tɛ Nyɩsʋaa nu, 'ɛ kɔ nahuin ‑ye a ‑dodo, 'ɔ kʋʋ win ke, 'plɩɩ nahuin ‑ye 'ʋʋ klɛ bii. ");
INSERT INTO ted_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dɛ a ‑gbɛ, ɛ 'we ꞊nɔ ye 'dɩdɔdɛ ꞊nʋ, ‑ɛ kɔ 'yɛɛ 'cɩmɩ 'dɔ, 'ɛ ‑hi 'o 'dɩdɔ‑tɔplɩ 'bii a 'yɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kɛɛ, 'bʋ 'dʋɛ, ‑ye ɛ ꞊ga nɩ. 'Bɛ ku, ‑ye ɛ 'bʋa nɩ, 'ɛɛ 'o 'dɩdɔ‑tɔplɩ 'bii 'mʋ ‑hi, kɔ, 'ɛɛ babʋɩ gblakɩ gblɛ po. 'A babʋɩ gblakɩ a ‑gbɛ 'kwli 'mʋ, ɛ ‑wɛ 'le nʋblɩ bɩ poo 'le 'lɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","‑Tɛ ‑talʋdʋɩ ‑gbo, ɩ nɩ 'mʋ, kɛ ꞊ɩ ‑ye nɩ ‑wɛ 'mʋ, ‑Yusu 'ɔ nyi po, 'ɔɔ nahuin Nyɩsʋa a wintɛ tɔɔ. ‑Ye dɛ ꞊nʋ, nahuin, ʋ ‑wɛ 'le bʋ yrii 'mʋ lɛ, nɛ‑ ɔɔ ꞊nʋ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","‑Ye ti a pɛpɛ, 'bɔɔ ꞊nʋ dɛ tɔɔ, 'ke 'le ‑talʋdʋɩ 'kwli 'mʋ, 'ke ɔ nyu 'le tɔɔ. Kɛɛ, ɔ kɔ 'a ‑naagbopʋʋ ‑do 'hɛɛn, 'bʋ nɩ 'o, 'plɩɩ ‑talʋdʋɩ 'bii ꞊nʋ, ɔɔ po, 'ɔ nyi ꞊nʋ klɛ ‑hɩhɩa. ");
INSERT INTO ted_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","‑Nyrɔwɔɔ ‑do ꞊nʋ a ‑wise, ‑ye ‑Yusu le 'a ‑naagbopʋ nɩ, ɔ nɔ: «‑Ba ꞊ta 'le 'yru a 'pɩa ‑ye ꞊nʋ ke!» ");
INSERT INTO ted_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","'a ‑naagbopʋ 'ʋ gbɔ, 'ʋ 'ya 'le 'blagbe ꞊nʋ wlɔn, ‑ɛ kɔ 'kwli 'mʋ ɔɔ wɛn 'le nahuin Nyɩsʋa a ‑tɩ tɔɔ, 'ʋ gba nahuin a ‑gbɛ wlu, 'ʋ mu. 'Ke 'o 'waa nɩ 'blagbe 'hʋɩn 'mʋ, 'blagbei ‑ye nɩ 'o. ");
INSERT INTO ted_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Bʋ nɩ 'klɛɛ 'o 'nie ke, bʋʋ mu, tii ‑do a ti 'yri, ‑ye ‑hlonpʋ gblaka cɛ 'le ꞊le, 'yru 'ʋʋ 'dʋɩ po, 'a 'dʋɩ a ‑gbɛ 'ɩɩ 'le 'blagbe wlɔn lɛ 'wlɛɛ, ‑ye 'blagbe a ‑gbɛ, ɛ 'tatɩ 'le'yiilɛ nɩ, 'ke 'o 'yru a 'dʋɩ ‑wɔn, ‑ɩɩ 'le ꞊nɔ wlɔn lɛ 'wlɛɛ. ");
INSERT INTO ted_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","‑Ye 'ke ‑Yusu ‑mɛ ‑ye, ɔ pɛ 'le 'blagbe a ‑hʋnma 'mʋ gbo, 'ɔ po 'o 'a 'lu 'pela ke gbo, 'ɔɔ ŋmo, 'a ‑naagbopʋ 'ʋ ‑hɩɔ ŋmla 'mʋ, ʋ nɔ: «Tɔɔnyɔ, ꞊be ɩ 'nɩ 'yaa ꞊le ‑mʋ 'kla ‑wliye, ‑ɛ mɔ, ‑aa gbo mu 'nɩ ‑wɛ?» ");
INSERT INTO ted_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","‑Yusu 'ɔ 'ba ye 'mʋ, 'ɔ 'prɛɛ 'le ‑hlonpʋ kɔ 'yru 'hɛɛn ‑wɔn, 'ke 'le win 'yaklɩ 'kwli 'mʋ, ɔ nɔ: «Ba ma wien, 'plɩɩ ba ‑wan ke gbo!» ‑ye 'ɛ mɔ ‑tɛɛ, ‑hlonpʋ ꞊nʋ, ʋ nyra gbo, 'yru 'bii ꞊nʋ, 'ʋ ‑wan ke gbo. ");
INSERT INTO ted_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","‑Tɛ ‑hlonpʋ kɔ 'yru 'hɛɛn, ɩ ‑wan ke gbo, ‑ye ‑Yusu ꞊hɩan ‑wɔn, 'ɔɔ 'le 'a ‑naagbopʋ ‑wɔn 'prɛɛ, ɔ nɔ: «Dɛ tio‑ kɔ ‑tɩ 'aa hʋannʋ pɩ 'le? A 'kɩɛ 'dee wɛn Nyɩsʋa ꞊wlʋ ye a kue.» ");
INSERT INTO ted_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","'A ‑naagbopʋ ‑mɛ ‑ye, ʋ 'ta 'mʋ gblɛ 'dɔ, 'ʋʋ 'mʋ lɛ 'pʋprɛ, ʋ nɔ: «Ba 'ye kɛ nahuon ‑gbo, ‑hlonpʋ kɔ 'yru 'hɛɛn, ɩ nyo ‑wɛ 'o 'nɩ ꞊tuu.» ");
INSERT INTO ted_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ʋ nyre 'le Galileblʋgba a 'yru a 'pɩa ꞊nʋ ke nɩ, ‑ɔ mɔ Gelasakʋɛ a 'blʋgba. ");
INSERT INTO ted_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","‑Yusu bɔ ꞊tɩ 'le 'blagbe wlɔn, tii ‑do a ti 'yri, ‑ye nyɩbɛyu ꞊de, nɔ‑ ‑hɔn 'le 'dɛɛi ke 'mʋ, 'ɔ muo ye 'mʋ 'bɛ wɔn. Nahuon a ‑gbɛ, 'ku ‑hʋan nɩ 'o ꞊nɔ 'ke 'mʋ, 'ʋʋ ꞊nɔ ꞊sʋɛ ꞊tue. ");
INSERT INTO ted_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","'Ke ɔ 'ti 'le 'dɛɛi ke, ‑ɩ nɩ 'le dʋgbɩ 'kwli 'mʋ. Nahuon ꞊de 'de 'le lele 'a mʋmʋa ‑wɛ, ꞊betɩ bʋ nu 'cɩɩn. ");
INSERT INTO ted_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ɛ kɔ ti, 'ʋ nyo la 'le kɩ dabʋɩ 'mʋ lɛ po, kɔ, 'ʋʋ la ‑wɛ 'cɩɩn nu, 'ʋʋ la 'a bʋɩ mʋa. Kɛɛ, ɩ 'bii ꞊nʋ, nahuon a ‑gbɛ, ɔ nyi la lɛ 'nɩ cɩcɛ. ꞊Ɔ ꞊de 'de 'klɛɛ lele 'klɩ kɔ, 'ke bɔ kiklo lɛ. ");
INSERT INTO ted_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ti a pɛpɛ, 'tɔ 'mʋ kɔ ‑nyrɛ 'mʋ, dʋgbɩ, nɩ‑ ɔɔ 'lu lɛ na, kɔ 'dɛɛi ꞊nʋ, ‑ɩ nɩ 'le dʋgbɩ ꞊nʋ 'kwli 'mʋ, nɩ‑ ɔɔ 'le ‑gbahlɔn lɛ na, 'ɔɔ lɛ 'gbugbo, kɔ, 'ɔɔ 'a dɩɔnʋ 'hɛ lɛ hra. ");
INSERT INTO ted_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Bɔ 'yee 'klɛɛ 'le ‑Yusu ye 'mʋ, ‑ye ɔ gbɔ 'le ye cigbɛi, 'ɔ blɔ kwlɩ ye gbo, ‑ɛ die nu, ‑Yusu 'muo 'mʋ ‑hɛ. ");
INSERT INTO ted_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","‑Ye kɛ ‑Yusuu 'ku ‑hʋan ꞊nʋ ye po, ‑ʋ nɩ 'o nahuon a ‑gbɛ ke 'mʋ, ɔ nɔ: «'Ku ‑hʋan, ‑hɔn 'o nahuon ‑gbo ke 'mʋ!» ‑Ye nahuon a ‑gbɛ, ɔɔ 'le 'yaa win, ɔ nɔ: «‑Yusu, Yrayrɩnyɩsʋa a 'Yu, dɛ tio‑ ‑n ‑hʋa ‑bo nu 'mʋ 'mʋ 'le? 'Nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, 'ke 'le Nyɩsʋa a 'dʋ 'kwli 'mʋ, ꞊nɩ ꞊tue 'le 'mʋ ꞊sʋɛ.» ");
INSERT INTO ted_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","‑Ye ‑Yusu nyo wlɔn 'nɩ ꞊gba, ɔ nɔ: «‑Na 'dʋ 'le?» ‑Ye ɔ ꞊tuo ‑wɔn, ɔ nɔ: «'Na 'dʋ mɔ dakʋ, ‑ɛ nue, ‑a ‑huo nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","‑Ye ɔɔ ‑Yusu lɛ 'nɩ 'batɩ 'dɔ, 'ke ɔ nɩ bla 'le 'kuo ‑hʋɩn lɛ, 'ke 'le 'blʋgba ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","'Ke 'o ‑tɛgbii ‑do a ‑gbɛ, dʋgba nɩ 'o. 'A ꞊tɩɔ ‑ye bi 'le 'yru ‑wɔn. 'Ke bʋɩcɩ a ꞊ju gblaka nɩ 'o, 'ʋʋ lɛ wa. ");
INSERT INTO ted_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","‑Ye 'kuo ‑hʋɩn a ‑gbɛ, ɔɔ ‑Yusu lɛ 'nɩ 'batɩ, ɔ nɔ: «Wɛɛn ke, 'ke ‑ba bi 'o bʋɩcɩ ꞊nʋ ke 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","‑Ye ‑Yusu wɔn nɩ, 'kuo ‑hʋɩn a ‑gbɛ 'ɔ ‑hɔn 'o nahuon a ‑gbɛ ke 'mʋ, 'plɩɩ 'ɔ bi 'o bʋɩcɩ ꞊nʋ ke 'mʋ, bʋɩcɩ 'bii a ‑gbɛ, 'ɩ 'gba ci lɛ, 'ɩ ꞊tɩ dʋgba, 'ɩ bi 'yru 'mʋ lɛ, 'ɩ 'kʋkʋ lɛ. Bʋɩcɩ a ‑gbɛ, ‑ɩ 'kʋkʋ lɛ, ɩ ‑wɛ 'le bʋɩcɩ a 'milowɩɩ 'hɔɔn nɩ. ");
INSERT INTO ted_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nahuin ꞊nʋ, ‑ʋʋ bʋɩcɩ a ‑gbɛ naa, ʋ 'gba lɛ ci, ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ mue 'lu ‑wɔn, 'ʋ nyi ‑wɔn lɛ na, 'ke 'le 'dɩɛ 'mʋ, kɔ ‑gligbɩ ke. 'Plɩɩ nahuin 'mui mu 'wɔn, ‑ye ʋ di 'le ꞊le, ʋ 'mʋ ‑tɔplɩ a ‑gbɛ 'ye, ‑ɩ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","‑Tɛ ʋ nyre 'klɛɛ 'o ‑Yusu 'hʋɩn 'mʋ, ‑ye 'ke ʋ yɛ 'o nahuon a ‑gbɛ gbo, 'kuo ‑hʋɩn ‑huohui nɩ wɛn 'o ke 'mʋ, 'ɔ nɩ gbo, 'ɔ pue wlawlʋ. Ɔ 'we ꞊nɔ nahuon ꞊nʋ ye, hanhɩn 'de ‑hlɩn a nue. Nahuin a ‑gbɛ bʋ 'yo 'klɛɛ, ‑ye hʋannʋ biu 'le 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Nahuin ꞊nʋ, ‑ʋ 'ye ‑tɔplɩ 'bii a ‑gbɛ, ‑ɩ mue 'lu ‑wɔn, 'ke 'o nahuon a ‑gbɛ kɔ bʋɩcɩ 'hɛɛn ‑wɔn, ʋ nɩ lɛ ‑wɔn, 'ke 'o nahuin ꞊nʋ ‑wɔn, ‑ʋ di ‑ta 'ye wɔn. ");
INSERT INTO ted_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","‑Ye ʋ ‑tʋa ‑Yusu a lɛ'batɩlɛ gbo, 'ke bɔ ‑hɔn 'le 'waa 'blʋgba ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","‑Ye ‑Yusu 'ya nɩ, 'ke 'le 'blagbe wlɔn. Nahuon ꞊nʋ, 'kuo ‑hʋɩn nɩ wɛn 'o ke 'mʋ, ɔɔ ‑Yusu lɛ 'nɩ 'batɩ, 'ke bɔ naa ꞊nɔ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kɛɛ ‑ye ‑Yusu 'die ke wɛɛn, ɔ nɔ: «Mu 'le ‑na 'dɩɔ 'mʋ, 'ke 'le ‑na 'dʋkʋɛ ‑wɔn, ‑bo na ‑tɔplɩ 'bii ꞊nʋ a ‑tɩ ‑wɔn lɛ, Kʋkɔnyɔ Nyɩsʋa nu ‑mʋ 'mʋ, kɔ, ‑tɛ ɔ nu ‑na wɔlɩ a 'yiye.» ");
INSERT INTO ted_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Bɔ po 'klɛɛ lɛ, ‑ye nahuon a ‑gbɛ, ɔ bi wlɔn 'hru, 'ɔ mu 'le Dekapɔblʋgba 'mʋ. ‑Ye ‑tɔplɩ gblakɩ 'bii ꞊nʋ, ‑Yusu nu ꞊nɔ 'mʋ, nɩ‑ kɔ ‑tɩ, ɔɔ ‑wɔn lɛ na. ‑Ye nahuin 'bii ꞊nʋ, ‑ʋ nyi 'wɔn, ɩ saka ꞊nʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","'Ke ‑Yusu nɩ 'le 'blagbee ‑do ‑nɩ wɛn wlɔn, 'ɔ mu 'le Galileblʋgba a 'yru a 'pɩa ꞊nʋ ke. ‑Tɛ ɔ ꞊tɩ, 'ɔ nɩ 'o 'yru a ‑gbɛ nʋa 'mʋ, ‑ye nahuin 'plɔplɔ, nʋ‑ ‑wɛ ti ke, 'ʋ ꞊glaa 'le ꞊nɔ. ");
INSERT INTO ted_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Bʋ nɩ 'klɛɛ 'o gbo, ‑ye Nyɩsʋa a kayu a nyɩgblaka ꞊de, nɔ‑ nyre 'o. 'A 'dʋ mɔ Sayilu. Bɔ 'ye 'klɛɛ ‑Yusu, ‑ye ɔ blɔ ye gbo kwlɩ, ");
INSERT INTO ted_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","'ɔ nyo lɛ 'batɩ, ɔ nɔ: «'Na 'yu nyrɔyu gbi, 'a 'hʋɩɩn 'nɩ hren, ɔɔ ‑hʋa bɔ 'kʋ. 'Nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, di 'le ‑bo puo dabʋɩ 'lu gbo, ‑ɛ die nu, 'a 'kʋɛ 'mʋ ‑wɛ, ɔ 'mʋ ‑hʋnhlʋn po.» ");
INSERT INTO ted_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","‑Ye ‑Yusu wɔn nɩ, ɔ kɔ nyɩbɛyu a ‑gbɛ 'hɛɛn 'ʋʋ mu, nahuin 'plɔplɔ 'ʋ nyo ‑wɔn kʋɛ, 'ʋ nyo 'le yrɛ 'nyɩnyraa. ");
INSERT INTO ted_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","‑Ye 'klɛɛ, 'ke 'le nahuin a ‑gbɛ ‑hɛyri, 'ke nyrʋgba ꞊de nɩ 'le. Nɔ‑ 'kʋɛɛ nu. 'A 'kʋɛ a ‑gbɛ, nɛ‑ mɔ dablo bɔ nyo gbo ‑wɛ. ‑Tɛ 'kʋɛ a ‑gbɛ, ɛ 'tatɩ la 'a nunue, 'a 'yrʋ a ‑pu ꞊tu 'o 'hɔn a nʋnʋ nɩ kɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","'A 'hʋɩn a ‑gbɛ a ‑tɩ, 'ɔ na la ‑datapʋ a gblegblei yrɛ, 'ɔɔ la ꞊sʋɛ 'ye, 'a 'wli 'bii 'ɩ ‑wɛ la ꞊nɔ kwa lɛ. Kɛɛ, 'a 'kʋɛ a ‑gbɛ, ɛ 'nɩ ‑wɛ ꞊le la, kɛɛ, ɛɛ la 'le lɛ 'nɩ 'yaa. ");
INSERT INTO ted_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","‑Tɛ ɔ 'wɔn 'klɛɛ ‑Yusu a 'dʋ, 'ɔ bi 'le nahuin 'plɔplɔ ꞊nʋ ‑hɛyri, 'ɔ nyre 'o ‑Yusu ke 'mʋ, 'ɔ 'tʋ 'a wlawlʋ lɛ, ");
INSERT INTO ted_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","‑ɛ nue, kɛ ɔɔ po, 'ke 'le 'a ꞊wlʋ ke: «'Nɩ 'tʋ 'a wlawlɩ lɛɛ ‑do, 'na 'kʋɛ di 'nɩ ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tii ‑do a ti 'yri, bɔ 'tʋ 'a wlawlʋ lɛ, ‑ye dablo 'kee 'a gbo‑wʋwɛ nɩ. ‑Ye ɔ yree nɩ, 'ke 'le 'a dɩɔnʋ 'hʋɩn ‑wɔn, ‑ɛ mɔ, 'a 'kʋɛ ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tii ‑do a ti 'yri, ‑ye ‑Yusu yree nɩ, ‑ɛ mɔ, 'klɩ ‑hɔn 'le ꞊nɔ 'mʋ, 'ɔ ꞊hɩan ‑wɔn, 'ke 'le nahuin ꞊nʋ ‑hɛyri, kɛ ɔɔ po: «Nyɔ‑ 'tʋ 'na wlawlɩ lɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","‑Ye 'a ‑naagbopʋ ꞊tuo ‑wɔn, ʋ nɔ: «'Be ‑na ‑gbɛ, ‑n nye 'nɩ 'ye, ‑ɛ mɔ, nahuin ‑huo nɩ, 'ʋʋ 'le ‑mʋ yrɛ 'nyɩnyraa. 'Plɩɩ ꞊nɩɩ wlɔn ꞊gba: Nyɔ‑ 'tʋ 'mʋ lɛ.» ");
INSERT INTO ted_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kɛɛ ‑ye ‑Yusu, ɔɔ nahuin ꞊nʋ ‑ŋɩŋɛɛ 'yii, ‑ɛ die nu, ɔ 'mui yi, nahuon tio‑ 'tʋɔ lɛ. ");
INSERT INTO ted_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nyrʋgba a ‑gbɛ, hʋannʋ a ‑tɩ, ɔ ‑tʋa 'hɩhrɔlɛ gbo, ‑ɛ nue, ɔ yie nɩ, ‑ɛ mɔ, 'a 'kʋɛ ‑wɛ nɩ, 'ɔ mu 'o ‑Yusu ye 'mʋ, 'ɔ blɔ kwlɩ ye gbo, ‑ye kɛ ɔɔ ꞊nɔ ye po: «'Mɔɔ nɩ, ‑ɔ 'tʋ ‑na wlawlʋ lɛ, ‑ɛ die nu, 'na 'kʋɛ 'mʋ ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","‑Tɛ ‑Yusu 'wɩn, ‑ye ɔ nɔ: «'Na 'yu o, ‑tɛ ‑n kuo 'mʋ ꞊wlʋ ye a ‑tɩ, nɛ‑ nue, 'nɩ ‑wɔ ‑na 'kʋɛ. Mu, 'ke 'le plɔ a bleelɛ 'kwli 'mʋ, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Win nɩ 'le ꞊nɔ wlɔn, nahuin 'ʋ ‑hɔn 'le nyɩgblaka Sayilu a ‑tɛ 'mʋ, ʋ nɔ: «Sayilu, ‑na 'yu nyrɔyu gbi ‑nɩ wɛn, ɔ 'kʋ nɩ. 'A ‑tɩ, ‑ha Tɔɔnyɔ ‑Yusu mɛ lɛ, ꞊betɩ ‑n dio 'ku 'mʋ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Kɛɛ, ‑tɩ 'bii ꞊nʋ, ʋ ꞊tu, ‑Yusu 'nɩ dɩɩ ꞊le dɛ. Kɛ ɔɔ 'klɛɛ Sayilu ye po, ɔ nɔ: «‑Na ꞊wlʋ nɩ bi 'le ꞊hlɔn, kuo 'mʋ ꞊wlʋ yee ‑do!» ");
INSERT INTO ted_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","'Plɩɩ ʋ 'mʋ mu mu, ‑Yusu 'die ke wɛɛn, 'ke nahuin ‑ye bʋ kʋɛ ꞊nɔ ‑wɔn, 'bɛ 'de 'a ‑naagbopʋ Piɛlɩ, kɔ Sakɩ, ɔ kɔ 'a 'dɩayu Saan ‑do. Nʋ‑ kɔ ꞊nɔ 'hɛɛn mu, 'ke 'le Sayilu a ‑tɛ. ");
INSERT INTO ted_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","‑Tɛ ʋ nyre 'klɛɛ 'le, ‑ye ‑Yusu 'ye nahuin 'plɔplɔ, 'ʋʋ lɛ 'gbugbo, 'ʋʋ popowli po, kɔ, 'ʋʋ wɔlɩ lɛ nu. ");
INSERT INTO ted_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","‑Tɛ ɔ pa 'le kayu a ‑gbɛ gbo, ‑ye ɔ nɔ: «Dɛ‑ kɔ ‑cici a lɛ po 'le? Dɛ‑ kɔ ‑wɛ wuwe 'le? 'Yu ‑gbo, ɔ 'de 'kʋ. Ŋmla'a nɩ, ɔɔ ŋmo.» ");
INSERT INTO ted_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Bɔ po 'klɛɛ lɛ, ‑ye ʋ nyo 'nɩ 'caa. ‑Ye ɔ 'hrɔɔ nahuin 'bii nɩ, 'ɔ da 'yu a bu, kɔ 'a 'dii, kɔ 'a ‑naagbopʋʋ ta a ‑gbɛ 'hɛɛn, 'ʋ pa 'le ‑gblo ꞊nʋ 'mʋ, ‑tɛ 'yu pɛ 'le gbo. ");
INSERT INTO ted_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","‑Tɛ ʋ pa 'klɛɛ 'le, ‑ye ‑Yusu klɩ 'yu a ‑gbɛ a dabʋ gbo, ‑ye ɔ nɔ: «Talita kumi!» ‑ɛ ꞊hɛn 'nyrɛ: «'Yu nyrɔyu, ‑mɔ 'nɩɩ le, 'ba ye 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tii ‑do a ti 'yri, 'ɔ 'ba ye 'mʋ, 'ɔ ‑tʋa nɩna gbo. 'Yu a ‑gbɛ, ɔ kɔ 'yrɩɩ ‑pu ꞊tu 'o 'hɔn. Bʋ 'ye 'klɛɛ dɛ a ‑gbɛ, ye ɛ saka ꞊nʋ nɩ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","‑Ye ‑Yusu tiu nɩ, 'ke 'le win 'yaklɩ 'kwli 'mʋ, ɔ nɔ: «Dɛ ‑gbo, 'n nu, nahuon ꞊de nɩ le 'le ꞊ɔ ꞊de!» ‑Ye kɛ ɔɔ lele po: «Ba ‑nyo dididɛ, ɔ 'mue di!» ");
INSERT INTO ted_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","‑Tɛ ‑tɔplɩ a ‑gbɛ, ɩ ‑hi, ‑ye ‑Yusu ‑hɔn 'le 'dɩɔ a ‑gbɛ 'mʋ nɩ, 'ɔ mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ kɔ 'mʋ ɔ kuu 'le. Ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, nʋ‑ mu 'le. ");
INSERT INTO ted_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","‑Tɛ ‑wuwle‑nyrɔwɔ nyre 'o, ‑ye 'ke ɔ mu 'le Nyɩsʋa a kayu gbo, 'ɔ ‑tʋa Nyɩsʋa a ‑tɩ a tɔɔlɛ gbo. Nahuin 'plɔplɔ ꞊nʋ, ‑ʋ nɩ 'o, ‑tɛ ʋ 'wɔn 'a tɔɔwin a ‑gbɛ, ‑ye ɩ saka ꞊nʋ nɩ, ʋ nɔ: «Nyɔ‑ tɔɔ ꞊nɔ ‑tɩ ‑gbo, ɔɔ ꞊tu 'le? Nyɔ‑ ‑nyi ꞊nɔ ꞊tɔdʋ ꞊nʋ 'le? Kɔ, nyɔ‑ ‑nyi 'klɛɛ ꞊nɔ 'klɩ, 'ke bɔ nu 'ŋmilɛka‑tɔplɩ ‑gbo 'le? ");
INSERT INTO ted_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","‑A yie nɩ, ‑ɛ mɔ, nɔ‑ mɔ 'camʋdɛ, 'ɔ mɔ Mari a 'yu. 'A ‑dɩayuo nyɩbɛpʋ, nʋ‑ mɔ Sakɩ, kɔ Sosɩ, kɔ Judɩ, kɔ Simɔ. 'A ‑dɩayuo nyrʋyuo nɩ ‑wɛ nɔ ‑a mʋ ‑hɛyri.» 'Waa 'lu a lɛ‑hielɛdʋ a ‑gbɛ, nɛ‑ nue, 'ʋ 'dio ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","‑Ye ‑Yusu nɔ: «Nyɩsʋa a winwlɔn‑hɛnyɔ, ʋ nyo 'o 'nɩ ꞊tuu, 'ke 'o 'ɛ nɩ ‑tɛgbi ꞊de. Kɛɛ, ʋ 'nɩ ꞊tuo ꞊le 'o, 'ke 'le 'a ‑gbɛ a 'dɩɔ 'mʋ, kɔ, 'ke 'le 'a 'dʋkʋɛ ‑hɛyri, kɔ, 'ke 'le 'a kayu gbo.» ");
INSERT INTO ted_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","'Ke 'le ꞊nʋ ‑hɛyri, ‑Yusu 'de 'klɛɛ lele 'ŋmilɛkadɛ ꞊de nu, 'bɛ 'de bɔ po 'hʋɩnhrennyʋ gbi ‑ye dabʋɩ 'lu gbo, 'waa 'kʋɛ 'mʋ ‑wɛ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ɛ saka ‑Yusu nɩ, ‑tɛ ʋ nu, 'ʋ 'dio ꞊wlʋ ye kuo. ‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusuu 'mʋ mu 'dɩɛ ꞊nʋ, ‑ɛ ꞊glaa 'le Nasalɛtɩ, 'ɔɔ nahuin Nyɩsʋa a ‑tɩ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","‑Ye ɔ da 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ nɩ, ‑ɛ die nu, ɔ 'mu le, 'ke bʋ nu 'hɔn ‑hɔn, bʋ na 'dɩɛ klɛ, 'ɔ ‑nyi ꞊nʋ 'klɩ, 'ke bʋ bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","‑ye ɔ nɔ: «'Bɩa 'baa 'dɩɛ klɛ na, a nɩ gba 'le dɛ ꞊de, 'bɛ 'de kotuu ‑do, mɔ, a nɩ gba 'le ‑wɛ dididɛ, kɔ blɔ, kɔ 'wliyɛ, ");
INSERT INTO ted_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","kɛɛ, ba gba 'sueii ‑do, kɔ wlawlɩ ꞊nʋ 'hɛɛn, aa pue.» ");
INSERT INTO ted_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","‑Ye kɛ ɔɔ lele po: «'Bɩa 'ba nyre 'le 'dɩɔ ꞊de 'mʋ, kayu ꞊nʋ, ‑ʋ kɔ gbo ʋ di 'le 'a mʋ paa, 'ke ba nɩ 'le ‑nɩnɩ, a 'mʋ 'le 'dɩɔ a ‑gbɛ 'mʋ ‑hɔn. ");
INSERT INTO ted_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","'Bɩa 'ba mu 'le 'dɩɔ ‑ye 'mʋ, 'bɩa 'bʋ 'de 'a mʋ kwa 'ble, kɔ, 'bʋ 'nɩnɩ po 'a nɩ win nʋa ye gbo, ‑ye ba ‑hɔn 'le 'dɩɔ a ‑gbɛ 'mʋ. 'Baa mu, ‑ye ba bʋbla 'a nɩ bʋɩ, ‑ɛ die nu, 'pupu 'mʋ 'o 'a nɩ bʋɩ 'hʋɩn 'mʋ lɛ ‑hɔn, a 'mue nahuin tɔɔ, ‑ɛ mɔ, Nyɩsʋa a yrʋ 'bʋ yɛ ꞊nʋ, ‑ye nʋ‑ʋ nɩ, ‑ʋ nue 'waa dɩɔnʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","‑Tɛ ɔ ‑wɔ 'klɛɛ 'waa tiilɛ ‑wɔn, ‑ye 'a ‑naagbopʋ bi 'klɛɛ klɛ 'dɩɛ, 'ʋ nyi nahuin yrɛ ꞊tu, ʋ nɔ: «Ba hie 'o 'a nɩ dɛ 'kuku gbo, ba ‑nyi 'a nɩ 'klɔ 'bii Nyɩsʋa!» ");
INSERT INTO ted_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","'ʋʋ 'kuo ‑hʋɩn lɛ bla, ‑ɔ nɩ 'o nahuin ke 'mʋ, kɔ, 'ʋʋ 'hʋɩnhrennyʋ 'plɔplɔ 'nyra 'lu lɛ po, 'ʋ ‑wɔ 'waa 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ti a ‑gbɛ 'yri, Galileblʋgba a 'kɩɩn, ‑ɔ kɔ 'dʋ mɔ Helɔdɩ, ɔ 'wɔn ‑Yusu a 'dʋ nɩ, ‑ɛ nue, 'a 'ŋmilɛka‑tɔplɩ ꞊nʋ, ɔ nu a ‑tɩ, 'a 'dʋ 'ʋ 'sɛɛ gbo, 'ke 'le 'blʋgba 'bii ꞊nʋ 'mʋ. Kɛ nahuin ‑yee po: «Saan Batisɩ, ‑ɔɔ o nahuin 'nie 'lu lɛ po, nɔ‑ɔ nɩ. ‑Tɛ ɔ 'kʋ la, ɔ 'hrɩ lele 'klɔ. Nɛ‑ nue, 'ɔ kɔ 'klɩ, 'ke bɔ nu 'ŋmilɛka‑tɔplɩ ‑gbo, ‑ɩ kɔ 'dʋ ‑aa 'wɔn.» ");
INSERT INTO ted_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","‑Ye kɛ ꞊ʋ ‑yee ‑wɛ po: «Eli, ‑ɔ mɔ la Nyɩsʋa a winwlɔn‑hɛnyɔ, nɔ‑ɔ nɩ, nɔ‑ 'hrɩ 'klɔ.» Kɛ ꞊ʋ ‑yee lele po: «Nyɩsʋa a winwlɔn‑hɛnyɔ ‑yee nɩ. ‑Tɛ 'a winwlɔn‑hɛnyʋ nɩ la 'mʋ, ti ‑hi la a ti 'yri, kɛ'ɛ nɩ, ɔ nɩ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Helɔdɩ ‑mɛ ‑ye, ‑tɛ ɔ 'wɩn, ‑ye ɔ nɔ: «Saan Batisɩɩ nɩ, ‑ɔ kɔ 'lu 'n le o nahuin bʋ 'bɛ o 'o, nɔ‑ɔ nɩ, ‑ɔ 'hrɩ lele 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","'Ɛ mɔ ‑tɛɛ, dɛ ꞊nʋ, Helɔdɩ nu la Saan 'mʋ, 'plɩɩ ɔ 'mʋ la 'kʋ, ɛ nɛ‑ ‑gbo: Helɔdɩ, 'a ‑dɩayu nyɩbɛyu Filipʋ, nɔ‑ kɔ la nyrʋgba. 'A 'dʋ mɔ la Helɔdiadɩ. Helɔdiadɩ a ‑gbɛ, nɔ‑ Helɔdɩ ‑ha la Filipʋ kwa, 'ɔ kʋɔ la. ‑Tɛ Saan 'wɩn la, ‑ye ɔ nɔ: «Ɛ 'de 'o lɛ nɔɔ, 'ke ‑na ‑dɩayu Filipʋ ‑gbo, ‑ɔ 'kɩɛ nɩɛ 'klɔ, ‑bo di ꞊nɔ 'a nyrʋgba kwa ‑ha, ‑bo dio kɔ.» ‑Tɛ Saan ꞊tu ‑tɩ a ‑gbɛ, nɛ‑ nue, Helɔdiadɩ a ‑gbɛ 'ɔ ꞊tutuo Helɔdɩ, 'ke bɔ le 'a 'sɔyuo, bʋ klɩ Saan, bʋ mʋɔ, 'plɩɩ bʋ puo ꞊jɩ 'mʋ. ‑Tɛ ʋ puo 'klɛɛ ꞊jɩ 'mʋ, ‑ye Helɔdiadɩ, ɔ nye lɛ 'nɩ ꞊mɔ, 'ke bʋ 'lɔ. Kɛɛ, ɔ 'die 'le ‑wɛ, ");
INSERT INTO ted_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","‑ɛ nue, Helɔdɩ, ɔɔ Saan 'nɩ pɩ, kɔ, 'ɔ nyo ‑wɛ 'o ꞊tuu. Ɔ yie nɩ, ‑ɛ mɔ, 'a 'klɔ 'sii 'o ye, 'plɩɩ 'ɔ mɔ Nyɩsʋa a nahuon. Nɛ‑ nue, 'ɔ nyo 'yie ꞊tu. 'Ɛ nɩ ti, ɔ kɔ ꞊nɔ 'hɛɛn, 'bʋʋ toto po, ‑ye Saan a totowin, ɩɩ Helɔdɩ 'mʋ ‑ha 'ku 'dɔ, kɛɛ ‑ye ɔ nʋɛ 'mʋ nɩ, 'ke bɔ 'wɔn 'a win. ");
INSERT INTO ted_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","‑Nyrɔwɔ ꞊de 'mʋ 'klɛɛ, ‑ye 'a nyrʋgba Helɔdiadɩ, ɔ 'ye la 'hru, 'ke bɔ nue, bʋ 'la Saan. ‑Nyrɔwɔ a ‑gbɛ, nɔ‑ mɔ la ‑nyrɔwɔ ꞊nʋ ‑kɔ 'mʋ, ʋ kɔ la 'o Helɔdɩ a lɛ'mimre. ‑Nyrɔwɔ a ‑gbɛ a ‑tɩ, 'ɔ da la nahuin, 'ke ʋ 'mʋ la lɛ 'mre, kɔ, ʋ 'mʋ la dɛ di. Nahuin ꞊nʋ, ɔ da la, nʋ‑ mɔ la 'a 'blʋgba, ‑ɔ mɔ Galileblʋgba a ye'mʋnaanyʋ, ʋ kɔ 'sɔyuo a nyɩgblakɩ, kɔ 'blʋgba a nyɩgblakɩ ‑ye 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","'Ke ʋ nɩ 'klɛɛ 'o gbo, ‑ye Helɔdiadɩ a 'yu nyrɔyu, nɔ‑ pa 'le ꞊nʋ ‑hɛyri, 'ɔ ‑tʋa ‑wla a yiyie gbo. 'A yiyie a ‑gbɛ, ɛ klɩɩ Helɔdɩ ke 'dɔ, ɔ kɔ nahuin ꞊nʋ, ɔ da wɛn lɛ'mimre ke 'hɛɛn. ‑Ye kɛ ɔ nyo 'klɛɛ ye po: «‑Hʋa 'ɛ nɩ dɛ, ‑na ꞊wlʋ nʋɛ 'mʋ. 'N die ‑mʋ 'nɩ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","‑Ye kɛ ɔɔ lele po: «'N 'sʋʋ nɩ, 'ɛ nɩ dɛ, ‑n di ‑hʋa, 'n die ‑mʋ 'nɩ ‑nyi, ꞊betɩ bɛ 'ya 'na 'blʋgba a ꞊tɩɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","‑Tɛ 'yunyrɔyu ꞊nʋ, ɔ 'wɩn, ‑ye ɔ 'hrɩ nɩ, 'ɔ mu 'a 'dii wlɔn ꞊gba wɔn, ɔ nɔ: «'Na 'dii, dɛ tio‑ ꞊bo ‑hʋa 'le?» ‑Ye 'a 'dii nɔ: «Dɛ ‑bo ‑hʋa, nɛ‑ mɔ Saan Batisɩ a 'kʋkʋɛ. Bʋ 'bɛ 'o 'a 'lu, bʋ yʋ 'le, ‑a 'mue 'ye, ‑ɛ mɔ, ɔ 'kʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","'Plɩɩ 'a 'dii 'mʋ mu ‑yrɛ, ‑ye 'yunyrɔyu a ‑gbɛ, ɔ 'kɩka nɩ, 'ɔ pa lele, 'ɔ mu 'o 'kɩɩn ye, ɔ nɔ: «Dɛ 'nɩɩ ‑mʋ ‑hʋa, nɛ‑ mɔ Saan Batisɩ a 'kʋkʋɛ. 'Bɛ 'o 'a 'lu, ‑bo pu 'le huo wlɔn, ‑bo yʋ 'mʋ ye, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo.» ");
INSERT INTO ted_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","‑Tɛ 'kɩɩn 'wɩn, ‑ye 'a ꞊wlʋ 'mʋɛ gbo. Kɛɛ, ‑tɛ ɔ 'sʋɛ wɛn ke, 'ke 'o nahuin ꞊nʋ ye, ɔ da wɛn lɛ'mimre ke, nɛ‑ nue, 'ɔ 'die ‑hʋa, 'ke bɔ blɛ ke. ");
INSERT INTO ted_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Tii ‑do a ti 'yri, 'ɔ le 'a 'sɔyuotayu ‑ye, 'ke bɔ mu 'le ꞊jɩkayu gbo, bɔ 'bɛ 'o Saan Batisɩ a 'lu, bɔ yʋ 'le, 'sɔyuotayu a ‑gbɛ 'ɔ mu 'le ꞊jɩkayu gbo, 'ɔ 'bɛ 'o Saan a 'lu, ");
INSERT INTO ted_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","'ɔ pu 'le huo wlɔn gbo, 'ɔ yʋ 'le, 'ɔ ‑nyu 'yu nyrɔyu a ‑gbɛ, 'yu nyrɔyu ‑mɛ ‑ye 'ɔ gbʋ 'a 'dii ye. ");
INSERT INTO ted_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","‑Tɛ Saan a ‑naagbopʋ 'wɔn 'a 'kʋkʋ‑tɩ, ‑ye ʋ di la 'le ꞊le, 'ʋ gba la 'a 'kʋkʋku, 'ʋ ‑hɩɔ la 'o. ");
INSERT INTO ted_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","‑Tɛ ‑Yusu le o 'a ‑wɔnnaanyʋ, 'ke bʋ na o 'dɩɛ klɛ, bʋ ꞊tu o Nyɩsʋa a ‑tɩ, ‑ye 'a ‑wɔnnaanyʋ a ‑gbɛ, ʋ ꞊hɩan ‑wɔn, 'ʋ 'kukue lɛ, 'ke 'o ꞊nɔ 'hʋɩn 'mʋ. ‑Tɔplɩ 'bii ꞊nʋ, ʋ nu, kɔ, ‑tɩ 'bii ꞊nʋ, ʋ tɔɔ nahuin, nɩ‑ ʋʋ 'klɛɛ ‑Yusu ‑wɔn yrɛ na. ");
INSERT INTO ted_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","‑Ye nahuin 'plɔplɔ nyu la 'o 'hʋɩn 'mʋ lɛ mu, ʋ 'mʋ toto po, 'plɩɩ 'ʋ nyu 'o 'hʋɩn 'mʋ ‑hɔn. Nɛ‑ nue, ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn 'ʋ 'nɩnɩ kɔ ti, 'ke bʋ di dɛ. Nɛ‑ kɔ ‑tɩ, ‑Yusu 'ɔ le 'a ‑naagbopʋ, ɔ nɔ: «Ba di 'le, ‑ba mu 'le ‑tɛgbi, 'dʋ bii 'le ye, ‑ɛ die nu, a 'mʋ 'le 'hʋɩn lɛ ‑ha dɛ gbi!» ");
INSERT INTO ted_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","‑Ye ʋ bi 'le wlɔn 'blagbe, 'ʋ mu 'le ‑tɛgbi, 'dʋ bii 'le ye, ");
INSERT INTO ted_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","nahuin 'plɔplɔ 'ʋ 'yu, ‑tɛ ʋʋ mu, 'ʋ yruu, 'dɩɛ pɛpɛ 'bii a nahuin 'ʋ 'bɛ ‑wlu, 'ʋ 'yraa 'yru nʋa 'mʋ lɛ, 'ʋ 'bɩʋ ye 'mʋ, 'ke 'le ‑tɛgbi ꞊nʋ, ʋ di 'o kwlɛɛ. ");
INSERT INTO ted_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","‑Tɛ ‑Yusu 'hrɩ 'le 'blagbe wlɔn, ‑ye ɔ 'ye nahuin 'plɔplɔ ꞊nʋ nɩ, ‑ʋ di 'le, ‑ye 'waa wɔlɩ nyo nu, ‑ɛ nue, ʋ 'we ꞊nɔ blablɔ ye, ‑ɔ 'de kʋkɔnyɔ kɔ, 'ɔ bi 'o, 'ɔ ‑tʋa 'waa ‑tɔplɩ 'plɔplɔ a tɔɔlɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","‑Tɛ 'tɔɔ ‑wɔn, ‑ye ‑naagbopʋ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, 'ʋ lo, ʋ nɔ: «‑Tɛgbi ‑gbo, ‑a nɩ nɔ, 'dʋ bii nɔ ye, dididɛ 'de nɔ nɩ, 'plɩɩ, 'tɔɔ 'nɩ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","'A ‑tɩ, le nahuin ‑gbo, bʋ mu 'le ‑gligbɩ kɔ 'dɩɛ ꞊nʋ 'mʋ, ‑ɩ ꞊glaa 'le ‑a mʋ, bʋ mu 'waa dɩɔnʋ a dididɛ lɛ ꞊mɔ, ʋ 'mue ‑tɔ!» ");
INSERT INTO ted_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","‑Ye ‑Yusu nɔ: «'A nɩ ‑gbɛ, ba ‑nyu dididɛ!» ‑Ye ʋ nɔ: «Dɛ tio‑ ‑a di gba, 'plɩɩ ‑a 'mʋ 'waa dididɛ ‑tɔ 'le? 'Be ‑ye, ɛ mɔ 'wliblɔ'ɔ nɩ, ‑a di gba, 'plɩɩ ‑a 'mʋ 'waa dididɛ 'ye.» ");
INSERT INTO ted_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","‑Ye ɔ nɔ: «'Flɔɔkuii ‑tie a kɔ 'le? Ba mu 'le 'a nɩ blɔ wlɔn lɛ ta!» ‑Tɛ ʋ ta 'le lɛ, ‑ye ʋ lo nɩ, ʋ nɔ: «‑A kɔ 'flɔɔkuii ꞊hun kɔ ‑hriin 'hɔn.» ");
INSERT INTO ted_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Bʋ po 'klɛɛ lɛ, ‑ye ‑Yusu le ꞊nʋ nɩ, ɔ nɔ: «Ba le nahuin ꞊nʋ, bʋ nu dui, bʋ nɩ gblɛ, 'ke 'o ‑piti ke!» Yakɔ a ‑gbɛ gbo, ‑piti 'de wɛn a 'kʋɛɛ, ");
INSERT INTO ted_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","'ʋ nu dui, 'ʋ nɩ gblɛ. Du ‑ye nɩ 'o, 'ʋ ‑wɛ 'le nahuin a (100) ‑wlɩɩ ꞊hun, du ‑ye nɩ 'o, 'ʋ ‑wɛ 'le nahuin a (50) ‑wlɩɩ 'hɔn ꞊tu 'o ‑pu. ");
INSERT INTO ted_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","‑Tɛ ʋ nɩ 'klɛɛ gblɛ, ‑ye ‑Yusu 'ba 'flɔɔkuii ꞊hun a ‑gbɛ kɔ ‑hriin 'hɔn a ‑gbɛ 'mʋ nɩ, 'ɔ 'ba 'lu ye 'mʋ, 'ɔɔ 'le yrayrɩ lɛ ta, 'ɔ ‑nye Nyɩsʋa 'wio, 'ke 'o dididɛ a ‑gbɛ a ‑ta 'mʋ, 'plɩɩ 'ɔ 'bɩ ꞊tɩɔ lɛ, 'ɔ ‑nyi 'a ‑naagbopʋ, ‑ɛ die nu, ʋ 'muo nahuin 'bii a ‑gbɛ 'mʋ lɛ woo, 'ɔ woo ‑wɛ ‑hriin 'hɔn a ‑gbɛ nahuin 'bii 'mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ʋ 'bii, ʋ di dɛ ‑didi, 'ʋ ꞊mra. ");
INSERT INTO ted_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","‑Tɛ ʋ ‑wɔ dɛ lɛ, ‑ye didi‑tɔplɩ ꞊nʋ, ‑ɩ hie gblɛ, ‑naagbopʋ 'ʋ 'kukui lɛ, 'ʋ 'yie 'le ‑tʋgbɩwɩɩ ‑pu ꞊tu 'o 'hɔn. ");
INSERT INTO ted_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","'Ke 'le nahuin ꞊nʋ ‑hɛyri, ‑ʋ di dɛ, nyɩbɛpʋ a 'milowɩɩ ꞊hun nɩ la 'le. ");
INSERT INTO ted_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye tii ‑do a ti 'yri, ‑Yusu le 'a ‑naagbopʋ nɩ, 'ke bʋ 'ya 'le 'blagbe wlɔn, bʋ ꞊ta 'le 'yru a 'pɩa ꞊nʋ ke, 'ke bʋ mue 'le 'dɩɔ ꞊nʋ ye, ‑ɔ mɔ Bɛtɩsaida, 'plɩɩ ɔ 'mu ‑wɔn kʋɛ. Ti a ‑gbɛ 'yri, 'ke ɔ di 'o nahuin wlu gba. ");
INSERT INTO ted_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","‑Tɛ ʋ ‑gbɛ 'klɛɛ lɛ, ‑ye 'ke ɔ mu 'le dʋgba 'lu, 'ɔ mu 'le Nyɩsʋa ‑wɔn 'prɛɛ wɔn. ");
INSERT INTO ted_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","‑Tɛ 'tɔ ‑wɔn, ‑ye 'ke 'blagbe nɩ 'o 'nɩ‑hɛyri 'mʋ, ‑Yusuu ‑do, nɔ‑ nɩ 'le gbogbo ye. ");
INSERT INTO ted_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","‑Ye ɔ 'ye nɩ, ‑ɛ mɔ, bibree ꞊nʋ lɛ 'nɩ pa, ‑ɛ nue, pepee ꞊nʋ ye 'nɩ ‑wɔn. Ye‑hɛhapɛ bɛ po wun a ti 'yri, ‑ye ɔ nyu 'o 'mʋ mu 'hʋɩn, 'ɔɔ 'nie ke na, 'ɔ nyu lɛ ‑hi. ");
INSERT INTO ted_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","‑Tɛ ʋ 'yo, ɔɔ 'nie ke na, ‑ye ʋ dɔɔ 'ku, 'ʋ 'ta 'mʋ gblɛ, hʋannʋ a ‑tɩ, 'ʋ ‑hɛ ‑cici wlɔn. Tii ‑do a ti 'yri, ‑ye kɛ ‑Yusu nyu ye po: «Ba 'kee 'mʋgblɛ'tɩta. 'Mɔɔ nɩ. A nɩ pɩ 'le hʋannʋ!» ");
INSERT INTO ted_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","'ɔ 'ya 'le ꞊nʋ ‑wɔn, 'ke 'le 'blagbe wlɔn. ‑Tɛ ɔ 'ya 'klɛɛ, ‑ye pepe ‑wan gbo ke. Ɩ saka ꞊nʋ nɩ 'dɔ, ");
INSERT INTO ted_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","‑ɛ nue, ‑tɛ ‑Yusu wloo 'flɔɔ, ʋ 'die wɛn a yree, ‑ɛ mɔ, ‑Yusu, nɔ‑ ‑wɛ 'le 'ɛ nɩ dɛ ꞊de. 'Waa ꞊wlɩ 'die 'le ‑wɛ bɩ yrii 'o dɛ lɛ. ");
INSERT INTO ted_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","‑Tɛ ‑Yusu, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ ꞊ta 'yru, ‑ye ʋ nyre 'le Senesalɛtɩdɩɔ 'mʋ nɩ, 'ʋ ꞊tɩ 'le 'blagbe wlɔn, 'ʋ mʋɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","‑Tɛ ʋ ꞊tɩ 'klɛɛ, ‑ye tii ‑do a ti 'yri, nahuin yrii ‑Yusu nɩ, ");
INSERT INTO ted_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","'ʋ bi 'blʋgba 'bii ꞊nʋ ke, 'ʋ bla 'waa kɩklanyʋ, 'ʋ pu ‑hanmakɩi wlɔn lɛ, 'ʋ 'tatɩ 'waa 'lelɛyɩya, 'ke 'o ‑tɛgbi ꞊nʋ, ʋ plɛ, ‑Yusu nɩ 'o, ɔ 'mʋ 'waa 'kʋɛi ‑wɔ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","'Ɛ nɩ ‑tɛgbi, ‑Yusuu 'o muu, 'dɩɛ 'mʋ kɔ ‑gligbɩ ke, kɛ ʋʋ nu, 'ʋʋ kɩklanyʋ ti ke ‑wɔ, 'ke 'o 'dika, 'plɩɩ 'ʋ nyo lɛ 'batɩ, 'ke bɔ wɛɛn ke, bʋ 'tʋ 'a wlawlʋ lɛ, mɔ ꞊betɩ bɛ 'ya 'a wlawlʋ a bʋgbodɛ 'mʋ. ‑Ye nahuin 'bii, ‑ʋ 'tʋɔ lɛ, 'waa 'kʋɛi ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ɛ kɔ ‑nyrɔwɔ ꞊de, Falisi꞊tumu a nahuin ꞊de, ʋ kɔ Nyɩsʋa a teteitɔɔnyʋ ꞊de 'hɛɛn, nʋ‑ ‑hɔn 'le Jrusrɛdɩɔ 'mʋ, 'ʋ 'kukue lɛ, 'ke 'o ‑Yusu 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","'Ke ʋ nɩ 'o, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, ‑Yusu a ‑naagbopʋ ‑ye, 'bɩa 'bʋ 'mʋ dɛ di, ʋ 'nɩ yra ꞊le kwa lɛ. ");
INSERT INTO ted_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","'Ɛ mɔ ‑tɛɛ, Falisi꞊tumu a nahuin bi 'le ye, kɔ ‑Juukʋɛ ‑ye 'hɛɛn, ʋʋ 'o 'waa bunʋ a tetei 'o 'nɩ ꞊tuu. Ɛ 'die 'le ‑wɛ, 'waa 'dɩanyɔ bɔ 'de kwa lɛ yra ‑tɛɛ, 'plɩɩ bɔ di dididɛ di. ");
INSERT INTO ted_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ɛ 'die 'le ‑wɛ, 'waa 'dɩanyɔ bɔ ‑hɔn 'le 'maɩ ye 'mʋ, bɔ 'de bʋɩ lɛ yra, 'plɩɩ bɔ di dididɛ di, 'ʋʋ 'o 'waa bunʋ a tetei 'plɔplɔ ‑ye 'o ꞊tuu, ʋ hie ꞊nʋ lɛ: ‑tɛ ʋ di nu, ʋ 'mʋ 'nie'mʋ'naapɔhlɩ lɛ yra, kɔ 'mlaa‑tɔplɩ, kɔ 'plɩyɩ 'hɛɛn. Ʋ nɔ 'nɩ, nɛ‑ nye nu, 'plɩɩ ʋ 'mʋ 'o ye 'sii, 'ke 'o Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","‑Ye ʋ ꞊gba 'klɛɛ ‑Yusu wlɔn: «Dɛ tio‑ kɔ ‑tɩ ‑na ‑naagbopʋ 'ʋ 'nɩnɩ ꞊tuu 'o tetei ꞊nʋ 'o, ‑a nɩ bunʋ tɔɔ ‑a mʋ? 'Bɩa 'bʋ 'mʋ dɛ di, ʋ 'nɩ yra ꞊le kwa lɛ.» ");
INSERT INTO ted_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","‑Ye ɔ ꞊tu ꞊wɔn, ɔ nɔ: «Aa naa 'lii 'hɔn. Ti ꞊de a ti 'yri la, winwlɔn‑hɛnyɔ Esai ꞊tu la ‑tɩ a ‑tɛɛ, 'ke 'o 'a mʋ ‑gbo ‑wɔn. Dɛ, ɔ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, nɛ‑ ‑gbo: Kɛ Nyɩsʋa po: Dakʋ ‑gbo, ʋʋ 'mʋ ‑nyi ‑tɩ a 'yi'bʋaalɛ, 'ke 'o 'waa wuntɔ 'yri, kɛɛ, 'waa ꞊wlɩ hren 'mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ʋ nɔ 'nɩ, 'n kɔ ‑tɩ a 'yi'bʋaalɛ, kɛɛ, 'na ‑tɩ 'de 'le ꞊nʋ ꞊wlɩ ke nɩ, ‑ɛ nue, ʋʋ tɔɔ ‑tʋnahuin a tetei, 'ʋ nyi Nyɩsʋa a tetei daa.» ");
INSERT INTO ted_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kɛ ‑Yusu nyu lele ye po: «A hie 'o Nyɩsʋa a tetei gbo, 'aa 'o ‑tʋnahuin a tetei 'o ꞊tuu.» ");
INSERT INTO ted_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","‑Ye ɔ 'prɛɛ 'le lele ꞊nʋ ‑wɔn, ɔ nɔ: «A nɔ 'nɩ, a kɔ ꞊tɔ, 'a po Nyɩsʋa a tetei 'pɩa ke, 'aa 'a nɩ tetei naa. ");
INSERT INTO ted_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","'Ɛ mɔ ‑tɛɛ, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise ꞊tui la nɩ, 'ke 'le Nyɩsʋa a tetei 'kwli 'mʋ, ɔ nɔ: ꞊Tuu 'o ‑n bu kɔ ‑n 'dii 'hɛɛn, 'ke 'le 'waa 'mʋnʋɛlɛ 'kwli 'mʋ! ꞊Ɛ ‑ye nɔ 'nɩ: Nahuon 'bɔ ꞊tu 'a bu kɔ 'a 'dii 'hɛɛn a ‑tɩ 'klɩn, ʋ kɔ bʋ 'lɔ. ");
INSERT INTO ted_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kɛɛ, a ‑mɛ ‑ye, a nɔ 'nɩ: Nahuon, ɔ ‑wɛ 'le bɔ le 'a bu kɔ 'a 'dii 'hɛɛn nɩ, ‑ɛ mɔ: 'N nɛ kʋkɔ‑tɔplɩ a ꞊tɩɔ ‑ye, 'n kɔ ꞊bo ‑nyo wɛn 'a mʋ, 'ke 'o 'a nɩ 'mʋ‑hɛɛlɛ a ‑ta 'mʋ, kɛɛ, 'n ‑hɩɔ nɩ, 'ke 'o Nyɩsʋa a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","‑Ye a nɔ 'nɩ: Nahuon a ‑gbɛ 'bɔ ꞊tu ‑tɩ a ‑gbɛ, 'ke 'o 'a bu kɔ 'a 'dii 'hɛɛn ‑wɔn, ‑ye nahuon a ‑gbɛ, ɔ nɩ ‑hɩʋ 'le lele 'mʋ. Ɛ 'we ꞊nɔ ye, ɩ ꞊ŋa nɩ, 'ke 'o nahuon a ‑gbɛ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Kɛ'ɛ nɩ, aa nu, 'aa 'o 'a nɩ ‑gbɛgbɛ a tetei 'o ꞊tuu, kɔ, 'aa Nyɩsʋa a ‑tɩ 'wla, kɔ, 'aa lele 'yilɛnyre‑tɔplɩ ‑ye nu, ‑ɩɩ Nyɩsʋa a tetei 'wla.» ");
INSERT INTO ted_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","‑Ye ‑Yusu da lele nahuin ‑ye ꞊nʋ nɩ, ‑ʋ nɩ 'o ‑tuoo ‑do a ‑gbɛ ke. ‑Ye kɛ ɔ nyu ye po: «A 'bii, ba po 'mʋ nʋa ye gbo, ‑tɩ, 'n di ꞊tu, a 'mui 'mʋ lɛ yrii ‑tɛɛ! ");
INSERT INTO ted_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ɛ 'de dididɛ ‑gbo, ‑ɛɛ 'le ‑tʋnahuon wlɔn naa, ɛ 'de ꞊nɛ, ɛ 'nɩ nue ꞊le, ɔ 'nɩ 'sii ꞊le 'o ye, 'ke 'o Nyɩsʋa ye. Kɛɛ, dɛ ‑gbo, ‑ɛɛ 'le ‑tʋnahuon a ꞊wlʋ ke 'mʋ ‑hɔn, ɛ nɛ‑ nye nu, 'ɔ 'nɩnɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ba 'nɛɛ 'o nʋa gbo ‑tɛɛ, nahuon 'bɔ kɔ ‑tɩ'wɔnnʋa, ɔ 'mui 'mʋ lɛ yrii!» ");
INSERT INTO ted_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","‑Tɛ ‑Yusu ‑wɔ 'klɛɛ 'le nahuin a ‑gbɛ a ‑wɔn'prɛɛlɛ ‑wɔn, ‑ye ɔ ‑hɔn 'o ꞊nʋ 'mʋ 'hʋɩn, 'ɔ mu 'le kayu gbo. ‑Tɛ ɔ nyre 'le, ‑ye 'a ‑naagbopʋ ꞊gbɔ wlɔn, 'ke 'o ‑talʋdʋ ꞊nʋ, ɔ po wɛn, a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Kɛ ɔ nyu ye po: «꞊Be 'a nɩ ‑gbɛ, a 'die ‑wɛ 'le ‑wɛ ba kɔ ‑tɩ a 'mʋlɛyriilɛ? ꞊Be a 'nɩ yrie ꞊le 'mʋ lɛ, ‑ɛ mɔ, ɛ 'de dididɛ ‑gbo, ‑ɛɛ 'le nahuon wlɔn naa, ɛ 'de ꞊nɛ, ɛ 'nɩ nue ꞊le, ɔ 'nɩ 'sii ꞊le 'o ye, 'ke 'o Nyɩsʋa ye? ");
INSERT INTO ted_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","‑Ɛ nue, dididɛ 'nɩ mu ꞊le 'le nahuon a ꞊wlʋ ke. Kɛɛ, 'ke ɛɛ 'le ꞊nɔ 'kwli 'mʋ mu, 'ke ɛɛ 'le naa, 'ɛɛ 'le ‑patʋ 'mʋ bi.» 'Ke 'le wintɛ a ‑gbɛ 'kwli 'mʋ, ‑Yusu nyu 'nɩ le, ‑ɛ mɔ, 'ɛ nɩ dididɛ nu ‑tɛɛ, 'ke ‑tʋnahuon bɔ die, ‑ɛ nue, ɛ 'de ꞊nɛ, ɛ 'nɩ nue ꞊le, ɔ 'nɩ 'sii ꞊le 'o ye, 'ke 'o Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Kɛ ɔ nyu lele ye po: «Dɛ ‑gbo, ‑ɛɛ 'le nahuon a ꞊wlʋ ke 'mʋ ‑hɔn, ɛ nɛ‑ nye nu, 'ɔ 'nɩnɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye, ");
INSERT INTO ted_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","‑ɛ nue, 'ke 'le ‑tʋnahuon a ꞊wlʋ ke, 'ke 'lu a lɛ‑hielɛ 'klaan 'le 'mʋ ‑hɔn, 'ɛ nye nu, 'ɔɔ ‑tɔplɩ ‑hʋɩn nu: 'ɔɔ 'lalu nu, 'ɔɔ 'yri, 'ɔɔ nahuin 'la, ");
INSERT INTO ted_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","'ɔɔ ‑wlawli nu, 'a 'bie a kʋkɔ‑tɔplɩ, nɩ‑ ɔɔ ‑hʋa bɔ kɔ ‑wɛ, 'ɔɔ 'crɛ nu, 'ɔɔ 'a 'bie gblagblʋ lɛ nu, 'ɔ 'de ‑tʋɩ kɔ, 'ɔ kɔ ca, 'ɔɔ nahuin a 'dʋɩ 'yi lɛ nyre, 'ɔɔ 'le 'a dɩɔnʋ 'yaa, 'ɔ 'nɩnɩ ‑hie 'lu lɛ. ");
INSERT INTO ted_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","'Yilɛnyre‑tɔplɩ 'bii a ‑gbɛ, 'ke ɩɩ 'le nahuon a ꞊wlʋ ke 'mʋ ‑hɔn. Ɩ nɩ‑ nye nu, 'ɔ 'nɩnɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye.» Kɛ ‑Yusu po 'a ‑naagbopʋ ye. ");
INSERT INTO ted_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu ‑hɔn 'le ‑Juukʋɛ a 'blʋgba 'mʋ nɩ, 'ɔ mu 'le pʋpʋblʋgba ‑ye 'mʋ. 'Ke 'le 'blʋgba a ‑gbɛ 'mʋ, 'ke 'dɩɔ ꞊nʋ, ‑ɔ kɔ 'dʋ mɔ Tilɩ, ɔ nɩ 'le. ‑Tɛ ɔ nyre 'le Tilɩ a ‑gbɛ 'mʋ, ‑ye 'ke ɔ pa 'le nahuon ꞊de a ‑tɛ, 'ɔɔ lɛ ‑huhli, ‑ɛ nue, ɔ 'die ‑hʋa, 'ke nahuon ꞊de bɔ yroo. Kɛɛ, nahuin yroo nɩ. ");
INSERT INTO ted_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","‑Ye 'klɛɛ, 'ke 'le nahuin a ‑gbɛ ‑hɛyri, 'ke nyrʋgba ꞊de nɩ 'le. Nyrʋgba a ‑gbɛ, ɔ 'de ‑Juukʋɛyrɔwlʋ. 'Ke ɔ kɔ 'le Fenisi, 'ke 'le Siliblʋgba 'mʋ. (‑Juukʋɛ ‑mɛ ‑ye, nahuin, ‑ʋ 'de ‑Juukʋɛ, nʋ‑ ʋʋ ‑gbo daa.) Nyrʋgba a ‑gbɛ, nɔ‑ kɔ 'yu nyrɔyu 'ku ‑hʋan nɩ 'o ke 'mʋ. ‑Tɛ nyrʋgba a ‑gbɛ, ɔ 'wɔn 'klɛɛ ‑Yusu a 'dʋ, ‑ye 'ke ɔ mu 'le ꞊nɔ ‑wɔn, 'ɔ blɔ kwlɩ ye gbo, ɔ nɔ: «'Nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, bla 'ku ‑hʋan ꞊nʋ lɛ, ‑ʋ nɩ 'o 'na 'yu ke 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","‑Ye ‑Yusu nyo 'klɛɛ ‑wɔn 'nɩ ꞊tu, ɔ nɔ: «꞊Bo pue dɛ ye: ‑N kɔ ‑bo ‑ha 'yuo꞊pli mɛ lɛ, bʋ ꞊mra, 'plɩɩdo. Ɛ 'de 'o lɛ nɔɔ, 'yuo꞊pli, ‑ʋ mɔ ‑Juukʋɛ, bʋ nɩ 'le dɛ a didie kwa 'mʋ, 'plɩɩ nahuon ꞊de bɔ ‑ha 'o ꞊nʋ 'waa dididɛ ye 'mʋ, 'plɩɩ bɔ 'wlɛ 'o ‑gbo ye gbo.» ");
INSERT INTO ted_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","‑Ye nyrʋgba a ‑gbɛ, ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Tɔɔnyɔ o, 'ɛ mɔ ‑tɛɛ. Kɛɛ 'klɛɛ, 'yuo꞊pli 'bʋʋ dɛ di, ‑tɔplɩ nyu kwa lɛ ble, ‑gbo 'ɔ nyi lɛ 'tɛ.» ");
INSERT INTO ted_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","‑Ye ‑Yusu nɔ: «‑Tɛ ‑n ꞊tu 'mʋ ‑wɔn, 'ke 'le ꞊hapʋwintɛ 'kwli 'mʋ, nɛ‑ nue, 'nɩ nue, 'ku ‑hʋan 'ʋ ‑hɔn 'o ‑na 'yu nyrɔyu ꞊nʋ ke 'mʋ. 'A ‑tɩ, ‑n ‑wɛ 'le ‑bo mu 'le kayu gbo nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","‑Tɛ nyrʋgba a ‑gbɛ, ɔ nyre 'le kayu gbo, 'ɛ mɔ ‑tɛɛ, 'ke ɔ yɛ 'o 'a 'yu gbo, 'ɔ pɛ gbo, gbee. 'Ku ‑hʋan ‑hɔn 'o ꞊nɔ ke 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu ‑hɔn 'le Tilɩdɩɔ 'mʋ nɩ, 'ɔ 'bɛ Sidɔdɩɔ ꞊tɩɔ, kɔ, 'ɔ naa ‑wɛ 'le Dekapɔblʋgba 'mʋ, 'plɩɩ, 'ɔ nyre 'le Galileblʋgba a 'yru nʋa 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Bɔ nyre 'klɛɛ, ‑ye ʋ ya 'o ꞊nɔ ye nahuon ꞊de, ‑ɔ 'ke, 'plɩɩ ‑ɔ 'de 'prɛlɛ yi. ‑Ye ʋʋ ‑Yusu lɛ 'nɩ 'batɩ, 'ke bɔ puo dabʋɩ 'lu gbo, ɔ 'mue nu, 'a 'kʋɛ 'mʋ ‑wɛ, ");
INSERT INTO ted_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","‑Yusu 'ɔ ‑hɩɔ 'le nahuin ‑hɛyri, 'ʋ bii ye, 'plɩɩ 'ɔ 'nyrɔ 'le ‑jio nʋɩ 'mʋ lɛ, 'plɩɩ 'ɔ po 'a ‑jio hɩɔn lɛ, 'ɔ puo 'o nahuon a ‑gbɛ a mɛ ke gbo, ");
INSERT INTO ted_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","'plɩɩ 'ɔ 'wla 'yii wla, 'ɔɔ 'le yakɔ 'mʋ lɛ ta, 'ɔ 'wla ‑hʋnhlʋn gbo, 'ɔ le nahuon a ‑gbɛ, ɔ nɔ: «Ɛfata!» ‑ɛ ꞊hɛn 'nyrɛ: «Bɩ klɛ ye.» ");
INSERT INTO ted_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Tii ‑do a ti 'yri, ‑ye 'a nʋɩ klɛ yrɛ, 'ɔ ‑tʋa ‑tɩ a 'wʋnwɔn gbo ‑tɛɛ, kɔ, 'a mɛ 'ɛ ꞊wlɛɛ ‑wɛ gbo, 'ɔ ‑tʋa ‑wɛ 'pʋprɛ gbo ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","‑Ye ‑Yusu tii nahuin ꞊nʋ nɩ, ‑ʋ ꞊gbee 'o, 'ke ‑tɔplɩ 'bii a ‑gbɛ, ‑ɩ mue 'lu ‑wɔn, ʋ nɩ nɩ 'le nahuon ꞊de ‑wɔn lɛ. Kɛɛ, ‑tɛ ɔɔ nu, 'ɔ nyu le, kɛ ʋʋ 'a ‑wɔnlɛnɩna nu. ");
INSERT INTO ted_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","‑Ye nahuin saka nɩ 'dɔ, 'ʋʋ lɛ po: «‑Tɔplɩ 'bii, ɔɔ nu, ɩ nɔ lɛ 'yi 'dɔ. Ba 'ye kɛ, ɔ nye ‑wɛ 'nɩ nu, 'kikenyʋ 'ʋʋ ‑tɩ 'wɔn, kɔ nahuin, ‑ʋ 'de 'prɛlɛ yi, 'ʋʋ ‑wɛ 'prɛ ‑tɛɛ.» ");
INSERT INTO ted_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ti ꞊nʋ 'yri, nahuin 'plɔplɔ ‑ye, nʋ‑ di 'le, 'ʋ ꞊gbee 'o ‑Yusu 'hʋɩn 'mʋ, ʋ 'mʋ 'a tɔɔwin 'wɔn. Ʋ 'de dididɛ kɔ. ‑Ye ɔ da 'a ‑naagbopʋ nɩ, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Nahuin ‑gbo, 'waa wɔlɩ‑ɩ 'mʋ nu, ‑ɛ nue, ‑tɛ ʋ bi o mɔ 'mʋ 'hʋɩn 'mʋ, 'a ‑nyrɔwɔ a ta a nɔnɔ nɩ gbo, 'plɩɩ ʋ 'de dididɛ kɔ. ");
INSERT INTO ted_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","'Bʋ 'de dɛ di, 'nɩ plɛ, bʋ mu 'le 'waa 'dɩɛ klɛ, ‑ye kanʋ a ‑tɩ 'waa 'klɩi di 'le 'nɩ ‑wɛ 'hru wlɔn, ‑ɛ nue, ꞊ʋ ‑ye, ‑tɛgbi ʋ ‑hɔn 'le 'mʋ, 'dʋ hren 'le ꞊le.» ");
INSERT INTO ted_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","‑Ye 'a ‑naagbopʋ ꞊tuo ‑wɔn, ʋ nɔ: «‑Be' ‑a di 'klɛɛ nu 'le, 'plɩɩ ‑a 'mʋ ꞊nʋ dididɛ ‑nyi, ‑ɛ di ꞊nʋ ꞊mraa. ‑Tɛgbi ‑gbo, ‑a nɩ mɔ, 'dʋ bii nɔ ye.» ");
INSERT INTO ted_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","‑Ye ‑Yusu ꞊gbʋ wlɔn, ɔ nɔ: «'Flɔɔkuii ‑tie nɩ 'o 'a mʋ ‑wɔn 'le?» ‑Ye ʋ nɔ: «Ɩ 'nɩpata.» ");
INSERT INTO ted_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","‑Ye ɔ le nahuin ꞊nʋ nɩ, ‑ʋ nɩ 'o ꞊nɔ 'hʋɩn 'mʋ, 'ke bʋ waa gblɛ, 'ɔ 'ba 'flɔɔkuii 'nɩpata a ‑gbɛ 'mʋ, 'ɔ ‑nyi Nyɩsʋa 'wio, 'ɔ 'bɩ ꞊tɩɔ lɛ, 'ɔ ‑nyi 'a ‑naagbopʋ, 'ke bʋ wii nahuin 'mʋ lɛ, 'ʋ wi. ");
INSERT INTO ted_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ʋ ‑do a ‑gbɛ lele, ʋ kɔ ‑wɛ ‑hrin.yɔ gbi, ‑Yusu 'ɔ ‑nyi lele Nyɩsʋa 'wio, 'ɔ le lele 'a ‑naagbopʋ, 'ke bʋ woo nahuin 'mʋ lɛ, 'ʋ wo. ");
INSERT INTO ted_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","‑Ye nahuin 'bii, ʋ di dɛ ‑tɛɛ, 'ʋ ꞊mra. ‑Tɛ ʋ ꞊mra, 'flɔɔ, ‑ɔ hie gblɛ, ‑tɛ ‑naagbopʋ 'kukuo lɛ, ʋ 'yie 'le ‑tʋgbɩ gblakɩɩ 'nɩpata. ");
INSERT INTO ted_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nahuin, ‑ʋ di dɛ, ʋ ‑wɛ 'le ‑tʋnahuin a 'milowɩɩ ‑hɛn. ‑Tɛ ɛ ‑hi 'klɛɛ, ‑ye ‑Yusu tɩʋ gbo, 'ke bʋ mu 'le 'waa 'dɩɛ klɛ. ");
INSERT INTO ted_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ɔ ‑mɛ ‑ye, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ 'ya 'le 'blagbe wlɔn, 'ʋ mu 'le 'blʋgba꞊tɩɔ ‑ye 'mʋ. 'Blʋgba꞊tɩɔ a ‑gbɛ 'mʋ, 'ke 'dɩɔ ꞊nʋ, ‑ɔ kɔ 'dʋ mɔ Damanuta, ɔ nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye Falisi꞊tumu a nahuin nyre 'o ꞊o, ʋ kɔ ‑Yusu 'hɛɛn, 'ʋ ‑tʋa 'pʋprɛ gbo, ‑ɛ die nu, ʋ 'muo 'mʋ lɛ ꞊tɔ. Ʋʋ ‑hʋa bʋ 'ye, 'bɩa 'bɔ ‑wɛ 'le bɔ nu 'ŋmilɛkadɛ, ‑ɛ nye ꞊nʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ loo nɔ ‑tʋtʋ ke. ");
INSERT INTO ted_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Bʋ po 'klɛɛ lɛ, ‑ye ɔ 'wla gbo ‑hʋnhlʋn, ɔ nɔ: «Dɛ‑ nue 'klɛɛ, ti ‑gbo 'yri a nahuin 'ʋʋ lele 'ŋmilɛkadɛ ‑hʋa, ‑ɛ die ꞊nʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee nɔ 'mʋ ‑tʋtʋ ke. 'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ: ‑Tɛ a nɩ 'mʋ a nahuin, Nyɩsʋa 'deɛ bɔ wɛɛn ke, 'ke ba 'ye 'ɛ nɩ 'ŋmilɛkadɛ ꞊de.» ");
INSERT INTO ted_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Bɔ po 'klɛɛ lɛ, ‑ye ɔ ‑hɔn 'o ꞊nʋ 'hʋɩn 'mʋ nɩ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ʋ 'ya 'le 'blagbe wlɔn, 'ʋ mu 'le Galileblʋgba a 'yru a 'pɩa ꞊nʋ ke. ");
INSERT INTO ted_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","‑Tɛ ‑Yusu a ‑naagbopʋʋ 'le 'blagbe wlɔn 'ya, ‑ye ɩ ‑hri ꞊nʋ ‑wɔn, 'ke bʋ gba dididɛ, 'bɛ 'de 'flɔɔkuoo ‑do, ‑ɔ nɩ 'le 'waa ‑tɔplɩ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","‑Ye ‑Yusu nyu 'nɩ tii, ɔ nɔ: «Falisi꞊tumu a nahuin, 'waa 'flɔɔ a 'yaadɛ a ‑tɩ, kɔ 'kɩɩn Helɔdɩ a 'flɔɔ a 'yaadɛ a ‑tɩ, ba ꞊tu 'a nɩ dɩɔnʋ 'yie!» ");
INSERT INTO ted_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","‑Naagbopʋ, ʋ 'die yrii, ‑ɛ mɔ, 'yaadɛ ꞊nʋ, ‑ɛ kɔ ‑tɩ ‑Yusu ꞊tu, ɛ mɔ dɛ a yepoodɛ'ɛ nɩ, ‑ɛ ꞊hɛn 'nyrɛ nahuin a ‑gbɛ a 'lu a lɛ‑hielɛ 'klan. ‑Tɛ ʋ 'die yrii, nɛ‑ nue, 'ʋʋ wlɔn lɛ ꞊gbʋgba, ʋ nɔ: «꞊Be ‑tɛ ‑a 'de 'le 'flɔɔ ya, nɛ‑ nue, 'ɔɔ lɛ 'pʋprɛ nu?» ");
INSERT INTO ted_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","‑Tɩ ꞊nʋ, ‑naagbopʋ ꞊tu, ‑Yusu 'wɩn nɩ, ɔ nɔ: «Dɛ‑ kɔ 'kla, ɔɔ 'a mʋ ‑wliye 'ya 'le, ‑tɛ ‑a 'de kɛ dididɛ kɔ a ‑tɩ? A 'kɩɛ 'dee wɛn ‑tɩ a 'mʋlɛyriilɛ a kʋɛ. 'A nɩ ꞊wlɩ 'gboklo 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","A kɔ 'yii, kɛɛ, a 'nɩ yrii ꞊le lɛ, 'a kɔ nʋɩ, kɛɛ, a 'nɩ yrii ꞊le ‑tɩ 'mʋ lɛ. 'Plɩɩ, ‑tɩɩ 'a mʋ ‑wɔn ‑hri. ");
INSERT INTO ted_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","‑Tɛ 'n wloo o 'flɔɔkuii ꞊hun, 'ke ‑tʋnahuin a 'milowɩɩ ꞊hun bʋ di dɛ a ‑ta 'mʋ, ‑tɛ ʋ ‑wɔ o dɛ lɛ, 'flɔɔ ꞊nʋ, ‑ɔ hie o gblɛ, ‑tʋgbɩɩ ‑tie a 'yie o 'le 'le?» ‑Ye ʋ nɔ: «Ɩ ‑pu ꞊tu 'o 'hɔn.» ");
INSERT INTO ted_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","‑Ye ɔ nɔ lele: «'Plɩɩ, ‑tɛ 'n wloo o 'flɔɔkuii 'nɩpata, 'ke ‑tʋnahuin a 'milowɩɩ ‑hɛn bʋ di dɛ a ‑ta 'mʋ, ‑tɛ ʋ ‑wɔ o dɛ lɛ, 'flɔɔ ꞊nʋ, ‑ɔ hie o gblɛ, ‑tʋgbɩɩ ‑tie a 'yie o 'le 'le?» ‑Ye ʋ nɔ: «Ɩ 'nɩpata.» ");
INSERT INTO ted_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","‑Ye ɔ nɔ: «A 'kɩɛ 'dee wɛn ‑tɩ a 'mʋlɛyriilɛ a kʋɛ.» ");
INSERT INTO ted_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","‑Tɛ ʋ nyre 'le Bɛtɩsaidadɩɔ 'mʋ, ‑ye ʋ ya ‑Yusu ye 'yiisuanyɔ, 'ʋ nyo lɛ 'batɩ, 'ke bɔ puo dabʋɩ 'lu gbo, 'a 'kʋɛ 'mʋ ‑wɛ, ");
INSERT INTO ted_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","'ɔ 'ble 'yiisuanyɔ a ‑gbɛ a dabʋ kwa, 'ɔ ꞊tɩɔ 'dɩɔ 'mʋ. ‑Tɛ ɔ ꞊tɩɔ 'klɛɛ 'dɩɔ 'mʋ, ‑ye ɔ plʋɔ 'yi klɛ hɩɔn, 'ɔ puo dabʋɩ 'lu gbo, 'ɔ ꞊gbɔ wlɔn, ɔ nɔ: «꞊Be ‑nɩɩ 'ye dɛ?» ");
INSERT INTO ted_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","‑Ye 'yiisuanyɔ a ‑gbɛ, ɔ ꞊wlɛɛ 'yii, ɔ nɔ: «'Nɩɩ 'ye ‑tʋnahuin, kɛɛ, ʋ 'we ꞊nɔ ti ye, ‑ɩɩ na,» ");
INSERT INTO ted_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","‑Yusu 'ɔ gbɔ 'o lele dabʋɩ 'yi ke. ‑Tɛ ɔ ‑ha 'o 'a dabʋɩ, ‑ye 'ke nahuon a ‑gbɛ, ɔɔ 'le ye 'mʋ lɛ ta. 'A 'kʋɛ ‑wɛ nɩ. Ɔɔ 'klɛɛ lɛ 'nɩ yrii ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","‑Ye ‑Yusu nɔ: «Mu 'le ‑na 'dɩɔ 'mʋ, kɛɛ, ꞊nɩ naa 'le 'le Bɛtɩsaida 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, 'ke ʋʋ 'le 'dɩɛ ꞊nʋ 'mʋ mu, ‑ɛ 'mʋɛɛ 'blʋgba ꞊nʋ ye, ‑ɔ kɔ 'dʋ mɔ Filipʋ a Sesale. Ʋ nɩ 'klɛɛ 'hru wlɔn, ‑ye ɔ ꞊gbʋ wlɔn: «Nahuin nɔ dɛ‑, nahuon a gblo tio‑ 'n 'ya 'klɛɛ 'mʋ 'le?» ");
INSERT INTO ted_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","‑Ye ʋ ꞊tuo ꞊wɔn, ʋ nɔ: «꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Saan Batisɩ, ‑ɔɔ o nahuin 'nie 'lu lɛ po. ꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ Eli. ꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ ‑yee nɩ, ‑ɔ 'kʋ la, ti ‑hi la a ti 'yri, 'plɩɩ ‑ɔ 'hrɩ lele 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","‑Ye ɔ ꞊gbʋ wlɔn, ɔ nɔ: «A ‑mɛ ‑ye, a nɔ 'nɩ, nahuon a gblo tio‑ 'n 'ya 'klɛɛ 'mʋ 'le?» ‑Ye Piɛlɩ nɔ: «‑Mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya.» ");
INSERT INTO ted_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","‑Ye ‑Yusu tiu nɩ ‑tɛɛ, ɔ nɔ: «A nɩ le 'le nahuon ꞊de, nahuon a gblo tio‑ 'n 'ya 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","‑Ye ‑Yusu bi 'o ꞊o, 'ɔɔ 'a ‑naagbopʋ le, 'ke 'o ‑tɔplɩ 'bii a ‑ta 'mʋ, ‑ɩ kɔ ‑bɩ nue ꞊nɔ, ɔ nɔ: «'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n kɔ ꞊bo 'ye ‑tado ꞊sʋɛ 'dɔ. 'Blʋ a nahuin, kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ Nyɩsʋa a teteitɔɔnyʋ 'hɛɛn, ʋ kɔ bʋ yraa ‑tado 'mʋ, kɔ, ʋ 'mʋ 'mʋ 'la. 'Bɩa 'nɩ 'kʋ, ‑nyrɔwɩɩ 'hɔn, ‑nyrɔwɔ a ta a nɔnɔ 'mʋ, 'n kɔ ꞊bo 'hrɩ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","‑Tɩ 'bii ꞊nʋ, ɔ tɔɔ ꞊nʋ, ɔ 'de ꞊nʋ dɛ ꞊de 'yi ke ‑hli. ‑Ye Piɛlɩ dɔɔ ye, 'ɔ nyo 'nyrɛ ꞊hɛn, ɔ nɔ: «‑Tɩ ꞊nʋ, ‑nɩɩ 'lu ‑wɔn lɛ ‑hie, 'nɩ ‑hʋa ꞊le, 'ke bɩ nue ‑mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","‑Ye ‑Yusu ꞊hɩan ‑wɔn, 'ɔ ta 'le 'a ‑naagbopʋ ‑ye ꞊nʋ ‑wɔn lɛ, 'plɩɩ 'ɔ ꞊hɛn Piɛlɩ 'nyrɛ, ɔ nɔ: «Hren 'mʋ ‑wɔn, Satan! Dɛ ꞊nʋ, ‑nɩɩ 'lu ‑wɔn lɛ ‑hie, Nyɩsʋa a 'lu a lɛ‑hielɛ 'nɩ po ꞊le lɛ, kɛɛ, ‑tʋnahuin a 'lu a lɛ‑hielɛ'ɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Bɔ po 'klɛɛ lɛ, ‑ye ɔ da nahuin ꞊nʋ nɩ, ‑ʋ nɩ 'o, kɔ 'a ‑naagbopʋ 'hɛɛn, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔ nye ‑hʋa, 'ke bɔ naa 'mʋ ‑wɔn, ‑ye ɔ nɩ kʋɛ 'le 'a ‑gbɛ a 'lu a lɛ‑hielɛ ‑wɔn, kɛɛ, ‑tɩ ꞊nʋ, 'nɩɩ ꞊nɔ ye ꞊tu, bɔ ꞊tui 'o, bɔ nui 'ɛ nɩ ti, ꞊betɩ nahuin bʋ plɛ, ʋ 'muo 'la, ‑tɛ ɔ nu, 'ɔ 'ya 'na nahuon 'mʋ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nahuon 'bɔ nɩ 'o, 'bɔ plɛ, ɔ 'nɩ ‑hʋa ꞊le bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, 'ke 'o 'na ‑ta 'mʋ, ‑ye nahuon a ‑gbɛ 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn 'a 'klɔ yrayrʋ 'nɩ 'waan, 'ke 'le Nyɩsʋa ye. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ wɛɛn ke, 'ke bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, ‑tɛ ɔ nʋɛ 'mʋ 'mʋ a ‑tɩ, kɔ, Nyɩsʋa a ꞊hapʋtitie a ‑tɩ, ‑ye nahuon a ‑gbɛ, 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'ke 'le Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Nahuon 'bɔ kɔ 'klɔ ‑gbo ke a kʋkɔ‑tɔplɩ a pɛpɛ 'bii, 'plɩɩ 'bɔ 'waan 'a dɩɔnʋ a 'klɔ yrayrʋ, 'ke 'le Nyɩsʋa ye, ‑ye kʋkɔ‑tɔplɩ a ‑gbɛ, ɩ 'nɩ pue ꞊le 'o ꞊nɔ dɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nahuon ꞊de 'die 'le ‑wɛ, bɔ po 'o dɛ ꞊de 'klɔ yrayrʋ a ‑gbɛ ꞊pɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","'Ke a nɩ 'le nahuin ‑gbo ‑hɛyri, ‑ʋ 'nɩnɩ ꞊tuu 'o Nyɩsʋa, ‑ʋ plee 'le Nyɩsʋa ke. 'Bɩa 'baa ‑tʋɩ pɩ, 'ke 'o nahuin a ‑gbɛ ye, 'ke ꞊bo di 'a nɩ Kʋkɔnyɔ 'mʋ 'ya, kɔ, 'ke ba di 'o 'na win 'o ꞊tuu, ‑ye 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ti ‑kɔ ti 'yri 'n di ‑hlɩn 'le di, 'ke 'le 'na Bu Nyɩsʋa a ‑tɩ a 'yi'bʋaalɛ 'kwli 'mʋ, 'n kɔ 'a lɛleenyʋ 'hɛɛn, ti a ‑gbɛ 'yri, 'n di ‑wɛ pɩ ‑tʋɩ, 'ke 'o Nyɩsʋa ye, 'ke ꞊bo ꞊tui, ‑ɛ mɔ, 'a mʋ mɔ 'na nahuin.» ");
INSERT INTO ted_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","‑Ye ‑Yusu nyu lele 'nɩ le, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ke 'le 'a mʋ ‑hɛyri, nahuin ‑ye nɩ 'le, ʋ 'mue ‑hlɩn 'ye, ‑tɛ Nyɩsʋa di nahuin a win a kekɔɔlɛ nu, 'ke 'le 'a 'klɩ 'kwli 'mʋ, 'plɩɩ ɛ 'mʋ ‑hlɩn nahuin a ‑gbɛ a 'kʋkʋɛ ke yɛ.» ");
INSERT INTO ted_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","‑Tɛ ‑nyrɔwɩɩ ‑huonnɔ ‑hi, ‑ye ‑Yusu gba Piɛlɩ kɔ Sakɩ kɔ Saan 'hɛɛn nɩ, 'ʋ mu 'le dʋgba ‑pɛtu ꞊de 'lu. Ʋ ‑do, 'ke ʋ nɩ 'klɛɛ 'le, ‑ye ‑Yusu 'cɩcɩ nɩ, 'ke 'le ꞊nʋ 'yi 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","'A 'hʋɩn'mʋlɛpue‑tɔplɩ 'plɛ nɩ 'dɔ, 'plɩɩ 'ɩɩ wlɩn. ‑Tɛ ɩ nu 'pʋplɛ, ꞊ɔ ꞊de 'de nɔ 'klɔ ‑gbo ke nɩ, ‑bɔ nu dɛ, ‑bɛ nu lɛ 'pʋplɛ. ");
INSERT INTO ted_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","‑Ye ʋ 'ye Nyɩsʋa a winwlɔn‑hɛnyʋ Eli, kɔ Moise, Nyɩsʋa ‑nye la 'a tetei. Nahuiin 'hɔn a ‑gbɛ, ʋ 'kʋ la si la. Nʋ‑ 'hrɩɩ 'o ‑Yusu 'hʋɩn 'mʋ, ʋ kɔ ꞊nɔ 'hɛɛn, 'ʋ ‑tʋa toto a pupue gbo. ");
INSERT INTO ted_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","‑Ye kɛ Piɛlɩ, ɔɔ ‑Yusu ye po, ɔ nɔ: «Tɔɔnyɔ o, ɛ nu ‑tɛɛ, 'ke ‑ba nɩ nɔ ‑tɛgbi ‑gbo gbo, ‑ba po blɛɛ ta, ‑n nɛ blɔ, Eli a nɔnɔ, kɔ Moise a nɔnɔ.» ");
INSERT INTO ted_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Piɛlɩ ꞊tu ‑tɩ a ‑gbɛ nɩ, ‑ɛ nue, ɔ kɔ 'a 'bienʋ 'hɛɛn, ʋ 'ta 'mʋ gblɛ, 'plɩɩ ‑tɩ bɔ di ꞊tu, ɔ 'di yi. ");
INSERT INTO ted_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","‑Ye tii ‑do a ti 'yri, ‑jrugba ꞊tɩɩ 'o ꞊nʋ 'lu, 'ɔ ‑hli ꞊nʋ. 'Ke 'le ‑jrugba a ‑gbɛ 'kwli 'mʋ, 'ke Nyɩsʋa a wiin 'le 'mʋ ‑hɔn, 'ɩɩ lɛ po: «Nahuon ‑gbo, nɔ‑ mɔ 'na 'mʋnʋɛyu. Nɔ‑ ba po nʋa ye gbo!» ");
INSERT INTO ted_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Tii ‑do a ti 'yri, bʋ ta 'o 'waa dɩɔnʋ 'hʋɩn 'mʋ lɛ, ‑ye ʋ 'nɩ 'ye ꞊le nahuon ꞊de, 'bɩa 'bɛ 'de ‑Yusuu ‑do. ");
INSERT INTO ted_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Bʋʋ 'klɛɛ dʋgba ꞊tɩ, ‑ye ‑Yusu tiu nɩ, ɔ nɔ: «Dɛ ‑gbo, a 'ye, a nɩ le 'le nahuon ꞊de, ɛ 'mue gba ‑gbagba, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mʋ 'kʋ, 'mʋ 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, 'mʋ 'klɔ 'hrɩ.» ");
INSERT INTO ted_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","‑Tɩ ꞊nʋ, ‑Yusu ꞊tu ꞊nʋ ye, ʋ ꞊tui 'o ꞊o. Kɛɛ, ʋʋ wlɔn lɛ 'nɩ ꞊gbʋgba: «Bɔ 'kʋ, bɔ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, bɔ 'hrɩ 'klɔ, dɛ tio‑ ɛ ꞊hɛn 'nyrɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","‑Ye ‑naagbopʋ nyo wlɔn 'nɩ ꞊gba, ʋ nɔ: «Dɛ‑ nue, Nyɩsʋa a teteitɔɔnyʋ 'ʋʋ lɛ po, Nyɩsʋa a winwlɔn‑hɛnyɔ Eli, nɔ‑ kɔ ‑bɔ di 'le ‑tɩtɛ, 'plɩɩ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, ɔ 'mʋ 'le di 'le?» ");
INSERT INTO ted_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","‑Ye ɔ nɔ: «'Ɛ mɔ ‑tɛɛ, Eli kɔ bɔ di 'le ‑tɩtɛ, ɔ 'mʋ Nyɩsʋa a dakʋ 'mʋ ‑hɛ, ʋ 'mʋ 'waa 'klɔ ‑hlɛntie, ʋ 'mʋ ‑wɔn ‑wɛ, 'plɩɩ Waanyɔ a ‑gbɛ, ɔ 'mʋ 'le di. 'Nɩɩ 'a mʋ 'nɩ le: Nahuon, ‑ɔ 'we ꞊nɔ Eli ye, ɔ di 'le ꞊le, 'plɩɩ 'yilɛnyredɛ ‑gbo, ‑tʋnahuin, ʋʋ ‑hʋa bʋ nu ꞊nɔ 'mʋ, 'ʋ nue ꞊nɔ 'mʋ, ‑tɛ ʋ nu la 'a 'crɩɩlɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ti ‑hi la ti 'yri. Ʋ 'crɩɛ ‑wɛ nɩ, 'ke 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n kɔ ꞊bo 'ye ꞊sʋɛ 'dɔ, 'plɩɩ nahuin, ʋ di ‑wɛ 'mʋ 'nɩ yraa. Dɛ ɛ ꞊hɛn 'nyrɛ, ꞊be a ‑hie ‑wɔn lɛ 'lu?» ");
INSERT INTO ted_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","‑Tɛ ʋ ꞊tɩ 'klɛɛ dʋgba, ‑naagbopʋ ꞊nʋ, ‑Yusu hie 'o gbo, 'plɩɩ ɔ 'mu 'o 'hʋɩn 'mʋ mu nyre, ɔ 'ye nahuin ‑huohui, 'ʋ ꞊glaa 'le ꞊nʋ, kɔ teteitɔɔnyʋ 'hɛɛn. Teteitɔɔnyʋ a ‑gbɛ, nʋ‑ʋ gblɛ po, ʋ kɔ ‑naagbopʋ a ‑gbɛ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","‑Tɛ nahuin 'ye 'klɛɛ ‑Yusu, ‑ɔɔ 'le di, ‑ye ʋ saka nɩ, 'ʋ muo ye 'mʋ 'bɛ wɔn, 'ke 'le cilɛ'gbakɔ 'kwli 'mʋ, ʋ 'muo 'wio ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","‑Tɛ ‑Yusu nyre 'o, ‑ye ɔ ꞊gba 'a ‑naagbopʋ wlɔn, ɔ yɛ 'o gbo, ɔ nɔ: «Dɛ‑ kɔ gblɛ aa po 'le, a kɔ teteitɔɔnyʋ 'hɛɛn?» ");
INSERT INTO ted_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","'Ke 'le nahuin ‑huohui a ‑gbɛ ‑hɛyri, 'ke nahuon ꞊de nɩ 'le. Nɔ‑ ꞊tuo ‑wɔn, ɔ nɔ: «Tɔɔnyɔ, 'n ya nɔ ‑mʋ ‑wɔn 'na 'yu, ꞊mʋ 'a 'kʋɛ ‑wɔ, ‑ɛ nue, 'ku ‑hʋan nɩ 'o ꞊nɔ ke 'mʋ. Nʋ‑ nye nu, 'ke ɔ 'de 'le 'pʋprɛ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","'Ɛ nɩ ti, 'ku ‑hʋan a ‑gbɛ 'bʋ 'hrɩ 'blo, ʋ kɔ bʋ puo ꞊hlɔn lɛ, 'plɩɩ 'yu a ‑gbɛ, hɩɔnpru 'ʋʋ ꞊nɔ wien gbo nyra, kɔ, 'ɔɔ 'nyɩ di, kɔ, 'a 'hʋɩn 'ɩ 'titio. 'N le ‑na ‑naagbopʋ nɩ, bʋ bla 'ku ‑hʋan a ‑gbɛ lɛ, kɛɛ, ʋ 'die 'le ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Kɛ ‑Yusuu 'klɛɛ 'a ‑naagbopʋ ye po, ɔ nɔ: «'A mʋ mɔ nahuiin nɩ, ‑ʋ 'de Nyɩsʋa ꞊wlʋ ye kuo. Tii ‑tie 'n kɔ ꞊bo ‑hi nɔ 'a mʋ ‑hɛyri, 'plɩɩ a 'mʋ Nyɩsʋa ꞊wlʋ ye kuo 'le? ꞊Be 'n 'kɩɛ die ‑hlɩn 'a mʋ lɛ kikle? Ba ya 'mʋ 'yu a ‑gbɛ ye!» ");
INSERT INTO ted_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","'ʋ yɔ ꞊nɔ ye. ‑Tɛ 'ku ‑hʋan 'ye ‑Yusu, ‑ye ʋ ‑tʋa 'yu a ‑gbɛ a gblɛ‑huhlilɛ gbo, 'ke 'le 'klɩ 'kwli 'mʋ, 'yu a ‑gbɛ 'ɔ bi ꞊hlɔn, 'ɔ ‑tʋa ‑tʋtʋ a klɛ'brikelɛ gbo, hɩɔnpru 'ʋ nyra ꞊nɔ wien gbo, ");
INSERT INTO ted_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","‑Yusu 'ɔ ꞊gba 'a bu wlɔn, ɔ nɔ: «Tii ‑tie ɛ nu 'o ꞊nɔ 'hʋɩn 'mʋ 'le?» ‑Ye 'a bu nɔ: «Kʋɛ 'le 'a 'yu‑nyrɛ 'yie 'mʋ gbo'o nɩ. ");
INSERT INTO ted_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ɛ kɔ ti, 'ku ‑hʋan a ‑gbɛ 'ʋ nyo 'le 'tɔ po, kɔ 'nie ‑wɔn 'hɛɛn, 'ke ʋ 'muo 'la a ‑tɩ. 'Ye ‑a nɩ wɔlɩ, ‑hɛ ‑a mʋ 'mʋ, ꞊nɩ ‑wɛ 'le.» ");
INSERT INTO ted_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","‑Ye ‑Yusu nɔ: «‑N nɔ 'nɩ: ꞊Nɩ ‑wɛ 'le. 'Ɛ nɩ dɛ, ɛ ‑wɛ 'le ꞊le, 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ kuo Nyɩsʋa ꞊wlʋ ye.» ");
INSERT INTO ted_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tii ‑do a ti 'yri, ‑ye 'yu a ‑gbɛ a bu nɔ: «Iin, 'n ‑hʋa ꞊bo kuo ꞊wlʋ ye, kɛɛ, ‑hɛ 'mʋ 'mʋ, 'ke ꞊bo kuo ꞊wlʋ ye ‑tɛɛ.» ");
INSERT INTO ted_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","‑Ye ‑Yusu 'ye nɩ, ‑ɛ mɔ, nahuiin klɛ 'nɩ bii 'dɔ, 'ɔ 'prɛɛ 'le 'ku ‑hʋan a ‑gbɛ ‑wɔn, 'ke 'le win 'yaklɩ 'kwli 'mʋ, ɔ nɔ: «'Ku ‑hʋan, ‑mɔ ꞊nʋ, ‑ʋ nye nu, 'yu ‑gbo 'ɔ 'ke, kɔ, 'ɔ 'nɩnɩ 'prɛ, 'nɩɩ ‑mʋ 'nɩ le, ‑hɔn 'o ꞊nɔ ke 'mʋ, ꞊nɩ bi 'le 'klɛɛ 'o lele ꞊nɔ ke 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye 'ku ‑hʋan ‑tʋa lɛ'gbugbolɛ gbo, kɔ, 'ʋ nyo gblɛ bʋbla 'dɔ. Ʋ nɩ 'le 'a gblɛbʋblalɛ 'kwli 'mʋ, 'ʋ ‑hɔn 'o ꞊nɔ ke 'mʋ. ‑Tɛ ʋ ‑hɔn 'o ꞊nɔ ke 'mʋ, ‑ye 'yu a ‑gbɛ, ɔ pɛ gbo gbee, ‑ɛ 'we ꞊nɔ ye, ‑tɛ bɔ 'nɩnɩ 'kʋ wɛn. Nɛ‑ nue, 'dai nahuin, ‑ʋ nɩ ‑tuo ke, 'ʋʋ lɛ po: «Ɔ 'kʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kɛɛ ‑ye ‑Yusu klɩ 'a dabʋ gbo, 'ɔ 'bɔ ye 'mʋ, 'yu a ‑gbɛ 'ɔ nyra gbo. ‑Ye nahuin pui ‑tɛɛ, ‑ɛ mɔ, ‑Yusu ‑wɔ 'a 'kʋɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ mu 'le gbo kayu. ‑Tɛ ʋ ‑do, ʋ nɩ 'klɛɛ 'o, ‑ye 'a ‑naagbopʋ ꞊gbɔ wlɔn: «Dɛ‑ nue 'klɛɛ, ꞊a 'die wɛn 'le ‑wɛ, 'ke ‑ba bla 'ku ‑hʋan ꞊nʋ lɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Bɩa 'baa Nyɩsʋa daa ‑do, 'plɩɩ 'a 'mʋ 'le ‑wɛ ba bla 'kuo‑hʋɩndʋ a ‑gbɛ lɛ.» ");
INSERT INTO ted_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ ‑hɔn 'o ‑tɛgbi a ‑gbɛ 'mʋ nɩ, 'ʋ mu, 'ʋ 'bɛ Galileblʋgba ꞊tɩɔ. Ɔ 'die ‑hʋa, nahuin ꞊de bʋ 'yo, ");
INSERT INTO ted_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","‑ɛ die nu, ɔ 'mʋ ti kɔ, 'ke bɔ tɔɔ 'a ‑naagbopʋ. ‑Ye kɛ ɔ nyu ye po: «'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ʋ kɔ bʋ po 'mʋ nahuin kwa, ʋ 'mʋ 'mʋ 'la. Kɛɛ, 'bɩa 'nɩ 'kʋ, ‑nyrɔwɩɩ 'hɔn 'bɩ ‑hi, ta a nɔnɔ 'mʋ, 'n kɔ ꞊bo ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, 'mʋ 'klɔ 'hrɩ.» ");
INSERT INTO ted_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","‑Tɩ ꞊nʋ, ‑Yusu ꞊tu, 'a ‑naagbopʋ 'nɩ yrii ꞊le 'mʋ lɛ. Kɛɛ, ʋʋ pɩ hʋannʋ, 'ke bʋ ꞊gbɔ wlɔn, dɛ tio‑ ɛ ꞊hɛn 'nyrɛ. ");
INSERT INTO ted_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ʋ nyre 'le Kapɛnaɔdɩɔ 'mʋ nɩ, 'ʋ mu 'le kayu gbo. ‑Tɛ ʋ nyre 'klɛɛ 'le kayu gbo, ‑ye ɔɔ 'a ‑naagbopʋ wlɔn 'nɩ ꞊gba, ɔ nɔ: «‑Tɩ tio‑ aa wɛn ꞊tu 'le, 'ke 'le 'hru wlɔn?» ");
INSERT INTO ted_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kɛɛ, ʋ 'bii, ʋ nu ‑brii, ‑tʋɩ a ‑tɩ, ‑ɛ nue, 'ke 'le 'hru wlɔn, ʋ nyi wɛn 'mʋ lɛ 'nɩ pupo, 'ke 'le ꞊nʋ ‑hɛyri, nahuon tio‑ ‑bɔ nɩ 'o 'a 'be 'lu ye. ");
INSERT INTO ted_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","‑Ye ‑Yusu nɩ gbo, 'ɔ da 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔɔ ‑hʋa bɔ nɩ 'o 'a 'bie 'lu ye, bɔ ꞊tɩɔ 'le 'a dɩɔnʋ, ɔ 'mʋ 'a 'bie a ‑gbɛ a 'mʋ‑hɛnyɔ ‑hɛ.» ");
INSERT INTO ted_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","‑Ye ɔ da 'le gbo 'yu gbi, 'ɔ ꞊tuo 'o ꞊nʋ ye gbo, 'ɔ 'blo kwa, 'ɔ ꞊jro dabʋɩ 'lu gbo, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«'Ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɛ 'yu gbi ‑gbo, ɔ nɩ 'mʋ, 'bɔ 'ble 'a nahuon kwa, 'ke 'o 'na 'dʋ a ‑ta 'mʋ, ‑ye 'na ‑gbɛɛ nɩ, ɔ 'ble kwa, kɔ, nahuon 'bɔ nɩ 'o, 'bɔ 'ble 'mʋ kwa, ɛ 'de 'n ‑do, ɔ 'de 'mʋ kwa 'ble, kɛɛ, ɔ 'ble ‑wɛ kwa Nyɩsʋa, ‑ɔ lee nɔ 'mʋ ‑tʋtʋ ke.» ");
INSERT INTO ted_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","‑Ye Saan, ‑ɔ mɔ ‑Yusu a ‑naagbopʋyu ‑ye, ɔ nɔ: «Tɔɔnyɔ, ‑a 'ye nahuon ꞊de, 'ɔɔ 'kuo ‑hʋɩn lɛ bla, 'ke 'le ‑na 'dʋ 'kwli 'mʋ. ‑A ‑mɛ ‑ye, ‑a lo nɩ, 'ke bɔ 'kee 'a nunue, ‑ɛ nue, ɔ 'nɩ naa ꞊le ‑a mʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","‑Ye ‑Yusu nɔ: «A nɩ lo 'le bɔ 'kee, ‑ɛ nue, ɛ 'die 'le ‑wɛ nahuon ꞊de bɔ gba 'na 'dʋ, bɔ nu 'ŋmilɛkadɛ, 'plɩɩ bɔ ‑hɔn 'o 'mʋ, bɔ nyre lele 'na 'dʋ a ‑gbɛ 'yi lɛ. ");
INSERT INTO ted_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nahuon 'bɔ nɩ 'o, 'bɔ 'nɩnɩ ‑wɔn ‑a mʋ ye, ‑ye ɛ ꞊hɛn 'nyrɛ, ɔ kɔ ‑a mʋ 'hɛɛn pɛ. ");
INSERT INTO ted_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Kɔ, nahuon 'bɔ nɩ 'o, 'bɔ ‑nyi 'a mʋ 'nɩ‑gaʋwɔ, a 'mʋ 'na a ‑tɩ, ‑ɛ nue, 'a mʋ mɔ 'na nahuiin nɩ, 'nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, Nyɩsʋa, nɔ‑ di nahuon a ‑gbɛ 'wio ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «Nahuon ꞊nʋ, ‑ɔ kuo 'mʋ ꞊wlʋ ye, ‑ɛ 'we ꞊nɔ 'yu gbidʋ ‑gbo ye, 'bɩa nahuon 'bɔ nue, nahuon a ‑gbɛ bɔ 'kee 'na ꞊wlʋ a yekuolɛ, ‑ye ɛ nɔɔ 'o lɛ, 'ke 'o nahuondʋ a ‑gbɛ ‑wɔn, ‑ɔ nu dɛ a ‑gbɛ, 'ke bʋ puo 'hɩɔ gbɛtɛɛ dɔ, 'plɩɩ bʋ puo 'yru 'mʋ, ɔ 'mʋ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","'Bɩa ‑na dabʋ 'bʋ nye nu, ꞊nɩɩ dɛ 'kuku nu, ‑ye ‑bo 'bɩʋ 'o. Ɛ nu ‑tɛɛ, 'ke ‑bo nɩ dabʋ‑tɩɔ, 'plɩɩ ‑bo pa 'le 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'ɛ ‑hi 'o ‑na dabʋɩɩ 'hɔn bɩ ꞊cɛɛ 'o ye, 'plɩɩ ‑bo mu 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe.  ");
INSERT INTO ted_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","‑Tɛgbi a ‑gbɛ, nyɩ ꞊nʋ, ‑ɩɩ 'hʋɩn di, ɩ 'nɩ 'kʋ ꞊le, 'plɩɩ na 'nɩ jre ꞊le ‑wɛ 'le gbe. ");
INSERT INTO ted_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","'Bɩa ‑na bʋ 'bʋ nye nu, ꞊nɩɩ dɛ 'kuku nu, ‑ye ‑bo 'bɩʋ 'o. Ɛ nu ‑tɛɛ, 'ke ‑bo nɩ bʋ‑tɩɔ, 'plɩɩ ‑bo pa 'le 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'ɛ ‑hie 'o ‑na bʋɩɩ 'hɔn, bɩ ꞊cɛɛ 'o ye, 'plɩɩ bʋ po 'le ‑mʋ na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe.  ");
INSERT INTO ted_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","‑Tɛgbi a ‑gbɛ, nyɩ ꞊nʋ, ‑ɩɩ 'hʋɩn di, ɩ 'nɩ 'kʋ ꞊le, 'plɩɩ na 'nɩ jre ꞊le ‑wɛ 'le gbe. ");
INSERT INTO ted_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","'Bɩa ‑na 'yie 'bɛ nye nu, ꞊nɩɩ dɛ 'kuku nu, ‑ye ‑bo ‑hɩɛ 'le. Ɛ nu ‑tɛɛ, 'ke ‑bo nɩ 'yie'kɛɛ, 'plɩɩ ‑bo nyre 'le Nyɩsʋa a gbonɩɩlɛ 'mʋ, 'ɛ ‑hi 'o ‑na 'yii 'hɔn bɩ ꞊cɛɛ 'o ye, 'plɩɩ bʋ po 'le ‑mʋ na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe. ");
INSERT INTO ted_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","‑Tɛgbi a ‑gbɛ, nyɩ ꞊nʋ, ‑ɩɩ 'hʋɩn di, ɩ 'nɩ 'kʋ ꞊le, 'plɩɩ na 'nɩ jre ꞊le ‑wɛ 'le gbe. ");
INSERT INTO ted_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","'Ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ 'mʋ ‑wɔn naa, ɔ kɔ bɔ ‑ha Nyɩsʋa mɛ lɛ, bɔ klɔ 'yi 'mʋ, ‑ɛ die nu, 'a nunuklɔ 'nɩ ꞊han 'yi lɛ nyre, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ʋʋ nu, 'bʋ po dɛhʋɛ 'ta, 'ʋ nye na 'mʋ po, ‑ɛ die nue, ɛ 'nɩ ꞊han 'yi lɛ nyre. ");
INSERT INTO ted_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","꞊Bo pue lele 'ta a dɛ ye. 'Ta mɔ ꞊hapʋdɛɛ nɩ. Kɛɛ, 'bɔ 'waan 'a wlɔnnɩnɔ, ʋ 'die 'klɛɛ 'le lele ‑wɛ bʋ nue, bɔ nɔ lele wlɔn. ‑Ye ɔ 'de 'klɛɛ lele ‑kʋan ꞊de kɔ. A nɩ 'we 'le ꞊nɔ 'tadʋ a ‑gbɛ ye, ‑ɔ 'waan 'a wlɔnnɩnɔ, kɛɛ, a kɔ 'a nɩ 'bie 'hɛɛn, ba kɔ kegbowɛɛnlɛ.» ");
INSERT INTO ted_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","‑Nyrɔwɩ gbi bɩ ‑hi, ‑ye ‑Yusu ‑hɔn 'le Kapɛnaɔdɩɔ 'mʋ nɩ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ʋ mu 'le Sudeblʋgba 'mʋ, 'ke 'le Sudɛn a 'nike. ‑Tɛgbi a ‑gbɛ, nahuin 'plɔplɔ, nʋ‑ ‑wɛ lele ti ke, 'ʋ ꞊glaa 'le ꞊nɔ, ‑ye ɔ nyu tɔɔ Nyɩsʋa a ‑tɩ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ɔ nye lɛ nu. ");
INSERT INTO ted_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","‑Ye Falisi꞊tumu a nahuin, nʋ‑ 'yɩya 'o ꞊nɔ ye gbo, ‑ɛ die nu, ʋ 'muo 'mʋ lɛ ꞊tɔ, 'ke ɔ 'mʋ ka, 'ke 'o Nyɩsʋa ye. Kɛ ʋʋ 'klɛɛ po, 'ʋ nyo wlɔn ꞊gba: «꞊Be ɛ kɔ 'o ꞊o, ‑tɛ ‑a nɩ teteii po, 'ke nyɩbɛyu bɔ po 'le 'a nyrɔ ‑patʋ 'mʋ?» ");
INSERT INTO ted_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Tetedʋ tio‑ Nyɩsʋa a winwlɔn‑hɛnyɔ Moise ‑nye la 'a mʋ 'le?» ");
INSERT INTO ted_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ʋ nɔ: «Moise, nɔ‑ ꞊tui, ‑ɛ mɔ, nyɩbɛyu 'bɔɔ ‑hʋa bɔ po 'le 'a nyrɔ ‑patʋ 'mʋ, ‑ye bɔ ‑nyo 'crɩɩnɩɛ, ‑ɛ nyi ꞊tu, ‑ɛ mɔ, ɔ puo 'le 'mʋ ‑patʋ.» ");
INSERT INTO ted_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","‑Ye ‑Yusu nɔ: «'A nɩ ꞊wlɩ a 'mʋ'gboklolɛ a ‑tɩɩ nɩ, Moise 'ɔ ‑nyi 'a mʋ tetedʋ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","‑Ye kɛ ɔ nyu lele ye po, ɔ nɔ: «Ye‑hɛ‑nyrɛ 'mʋ, ‑tɛ Nyɩsʋa nu la 'klɔ, ɔ nu ‑tʋnahuon, ‑tʋnahuon a ‑gbɛ 'ɔ 'ya nyɩbɛyu kɔ nyrɔ 'hɛɛn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ɛ nɛ‑ nue, nyɩbɛyu 'mʋ 'o 'a bu kɔ 'a 'dii 'hɛɛn gbo hie, ɔ 'mʋ nyrɔ kɔ, ɔ kɔ ꞊nɔ 'hɛɛn, ʋ 'mʋ 'hʋɩn 'mʋ nɩnɩ, ");
INSERT INTO ted_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ 'mʋ ‑tʋnahuoon ‑do ‑hɛ. Ɛ ꞊hɛn 'nyrɛ, ʋ 'de 'klɛɛ lele ‑tʋnahuiin 'hɔn, kɛɛ, ʋ mɔ ‑tʋnahuoon ‑doo nɩ. ");
INSERT INTO ted_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","'A ‑tɩ o, nyɩbɛyu kɔ 'a nyrɔ 'hɛɛn, Nyɩsʋa nu, 'ʋ ‑hɛ ‑tʋnahuoon ‑do, nahuon ꞊de 'de ye blɛ bɔ ‑hɩhɩʋ yrɛ.» Kɛ'ɛ nɩ, ‑Yusu po ꞊nʋ ye. ");
INSERT INTO ted_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","‑Tɛ ʋ ‑gbʋgbɛ yrɛ, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ mu 'le gbo kayu. ‑Ye 'a ‑naagbopʋ a ‑gbɛ, ʋ nyo lele wlɔn 'nɩ ꞊gba, 'ke 'o nyɩbɛyu kɔ nyrʋgba bʋ ‑gbʋgbɛ yrɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","‑Ye ɔ nɔ: «Nyɩbɛyu 'bɔ po 'le 'a nyrʋgba ‑patʋ 'mʋ, 'plɩɩ 'bɔ kɔ nyrɔ ‑ye, ‑ye ɔ nu ‑wlawli, 'ke 'o 'a ye‑hɛnyrɔ ye. ");
INSERT INTO ted_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kɛ'ɛ nɩ, ɛ ‑ti 'mʋ, 'ke 'o nyrʋgba ‑wɔn. Nyrʋgba 'bɔ hie 'o 'a tɔ gbo, 'bɔ kɔ tɔ ‑ye, ‑ye ɔ nu ‑wlawli.» ");
INSERT INTO ted_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","‑Nyrɔwɔ ꞊de 'mʋ, ʋ gba 'le ‑Yusu ye 'yuo꞊pli, ɔ 'mu lɛ 'tʋ, ɔ 'mʋ Nyɩsʋa da, ‑ɛ die nu, Nyɩsʋa 'mʋ 'yuo꞊pli a ‑gbɛ ꞊hapʋdɛ 'mʋ nu. Kɛɛ ‑ye ‑naagbopʋ, ʋʋ nahuin ꞊nʋ ꞊hɛn 'nyrɛ, ‑ʋ ya 'le 'yuo꞊pli, ʋ nɔ: «A nɩ yʋ 'le ꞊nɔ ye!» ");
INSERT INTO ted_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","‑Tɛ ‑Yusu 'ye dɛ a ‑gbɛ, 'a ‑naagbopʋ nu, ‑ye ɛ 'de 'a plɔ blee, ɔ nɔ: «Ba ‑ha 'yuo꞊pli mɛ lɛ, bʋ di nɔ 'mʋ ye. A nɩ kʋ 'le ye, ‑ɛ nue, nahuin ꞊nʋ, ‑ʋ 'we ꞊nɔ 'yuo꞊pli ‑gbo ye, nʋ‑ di 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ pa. ");
INSERT INTO ted_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon 'bɔ 'nɩnɩ ‑ha Nyɩsʋa mɛ lɛ, 'ke bɔ kʋɔ win ke, ‑tɛ 'yu gbi, ɔɔ nu, 'ɔɔ 'a bu mɛ lɛ ‑ha, 'ke bɔ kʋɔ win ke, ‑ye nahuon a ‑gbɛ, ɔ 'die 'le ‑wɛ bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","‑Tɛ ‑Yusu po 'klɛɛ lɛ, ‑ye ɔ ‑tʋa 'yuo꞊pli a kwalɛ'buble gbo, kɔ, 'ɔ nyu dabʋɩ 'lu gblɛ po, 'ɔ da Nyɩsʋa, 'ke bɔ nu ꞊nʋ ꞊hapʋdɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","‑Tɛ ɔ ‑wɛ ‑wɔn, 'ke bɔ bi lele 'hru wlɔn, ɛ kɔ nahuon ꞊de, 'ɔ ya 'o ‑Yusu cigbɛi ye, 'ɔ blɔ kwlɩ ye gbo, ɔ nɔ: «Tɔɔnyɔ o, ‑mɔ mɔ ꞊hapʋnahuon. Dɛ tio‑ 'n di nu, 'plɩɩ 'mʋ Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le 'le?» ");
INSERT INTO ted_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","‑Ye ‑Yusu nɔ: «Dɛ‑ kɔ 'mɔ ‑nɩɩ ꞊hapʋnahuon daa? Nahuon ꞊de 'de ꞊hapʋnahuon, 'bɛ 'de Nyɩsʋaa ‑do. ");
INSERT INTO ted_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","‑N yi Nyɩsʋa a tetei nɩ, ‑ɩ mɔ: ꞊Nɩ 'la 'le nahuon, ꞊nɩ nu 'le ‑wlawli, ꞊nɩ 'yri 'le, ꞊nɩ po 'le nahuon hɩ ke, ꞊nɩ kaa 'le nahuin, ꞊tuu 'o ‑n bu kɔ ‑n 'dii 'hɛɛn, 'ke 'le 'mʋnʋɛlɛ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","‑Ye ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Tɔɔnyɔ o, kʋɛ la 'le 'na 'yu‑nyrɛ a ti 'yie 'mʋ gbo, ‑bo yɛ ‑nyrɔwɔ ‑gbo ke, 'n ꞊tuu 'o tetei 'bii a ‑gbɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","‑Tɛ ɔ po 'klɛɛ lɛ, ‑ye ‑Yusu tɔ 'le 'mʋ lɛ 'yi, 'ke 'le 'mʋnʋɛlɛ 'kwli 'mʋ, ɔ nɔ: «Ɛ hie 'o ‑mʋ dɛɛ ‑do. Nɛ‑ mɔ, mu ‑bo plo ‑tɔplɩ 'bii ꞊nʋ, ‑n kɔ, ‑bo ‑nye 'a 'wliyɛ ꞊sʋɛnyʋ lɛ, ‑ye Nyɩsʋa, nɔ‑ di ‑mʋ ꞊hapʋdɛ gblaka 'mʋ nu, 'ke 'le yakɔ 'mʋ. ꞊Nɩ nue 'klɛɛ, ‑ye ‑bo kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'na ‑naagbopʋyu ‑hɛ.» ");
INSERT INTO ted_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Bɔ 'wɩn 'klɛɛ, ‑ye 'a ꞊wlʋ bi ꞊hlɔn, 'ɔ ‑hɔn 'o ꞊nɔ 'hʋɩn 'mʋ, 'ke 'le 'kla‑wliye'yɩya 'kwli 'mʋ, ‑ɛ nue, 'a kʋkɔ‑tɔplɩ ‑huo 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","‑Tɛ ɔ mu 'klɛɛ, ‑ye ‑Yusu naa 'a ‑naagbopʋ ke 'yie, ɔ nɔ: «Ɛ kla wlɔn, 'ke 'o dɛkɔnyʋ ‑wɔn, 'ke bʋ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","‑Tɛ ‑Yusu nu 'pʋprɛ, ɩ saka ꞊nʋ nɩ. Kɛ ‑Yusuu lele ꞊nʋ ye po: «'Na 'yuo꞊pli ‑a, dɛkɔnyʋ ꞊nʋ, ‑ʋ kuo 'waa kʋkɔ‑tɔplɩ ꞊wlʋ ye, ɛ kla wlɔn, 'ke 'o ꞊nʋ ‑wɔn, 'ke bʋ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ɛ kla wlɔn, 'ke 'o dɛkɔnyɔ ‑wɔn, ‑ɔ kuo 'a kʋkɔ‑tɔplɩ ꞊wlʋ ye, 'ke bɔ kuo Nyɩsʋa ꞊wlʋ ye, bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, 'ɛ ‑hi 'o ꞊gbuke‑so 'mʋ, bɔ naa 'le 'die a 'hʋɔ wlɔn.» ");
INSERT INTO ted_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","‑Yusu a pupowin a ‑gbɛ, ɩ ma 'a ‑naagbopʋ lɛ wlɔn 'dɔ. ‑Ye ʋ nɔ: «'Bɛ kɔ bɛ ‑ti lɛ 'mʋ, nahuon ꞊de 'die 'le ‑wɛ bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","‑Ye ‑Yusu nyu 'nɩ 'ye, ɔ nɔ: «Ɛ 'die 'le ‑wɛ, 'ke 'le ‑tʋnahuon a 'klɩ 'kwli 'mʋ, bɔ kuo Nyɩsʋa ꞊wlʋ ye, ɔ 'mʋ 'le 'a 'klɔ yrayrʋ 'kwli 'mʋ pa. Kɛɛ, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ, 'ɛ nɩ dɛ, ɛ ‑wɛ 'le ꞊le.» ");
INSERT INTO ted_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","‑Ye kɛ Piɛlɩɩ ‑Yusu ye po: «‑A ‑mɛ ‑ye 'le? 'Ye kɛ, ‑a hie 'o ‑a nɩ nahuin gbo, ɛ kɔ ‑a nɩ ‑tɔplɩ 'bii 'hɛɛn, ꞊aa ‑mʋ ‑wɔn naa.» ");
INSERT INTO ted_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ hie 'o 'a kayu gbo, kɔ 'a ‑dɩayuo, kɔ 'a 'dii kɔ 'a bu 'hɛɛn, kɔ 'a 'yuo꞊pli, kɔ 'a ‑cii 'hɛɛn, 'na 'mʋnʋɛlɛ a ‑tɩ, kɔ, ɔ 'mʋ 'na ꞊hapʋtitie nahuin pue a ‑tɩ, ");
INSERT INTO ted_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","‑ye nahuon a ‑gbɛ, 'klɔ ‑gbo, ‑a nɩ nɔ ‑wɔn, ‑tɔplɩ, Nyɩsʋa di ꞊nɔ ‑nyi, ɩ di 'nɩ ‑huo bʋbakɔ, ɩ 'mʋ 'o dɛ ꞊nʋ, ɔ hie 'o gbo 'mʋ ‑hi, ‑ɩ mɔ kayuo nʋ, ‑dɩayuo nʋ, 'diinʋ, 'yuo꞊pli nʋ, kɔ ‑cii 'hɛɛn, kɛɛ, ʋ dio ‑wɛ ꞊tue ꞊sʋɛ. 'Ya 'o lele 'lu, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'o 'klɔ ‑ye nuu, nahuon a ‑gbɛ, Nyɩsʋa di ꞊nɔ ‑nyi 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kɛɛ, nahuin ꞊nʋ, ‑ʋ nɩ 'o 'waa 'bienʋ 'lu ye, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'waa 'plɔplɔ, nʋ‑ di ‑tado 'le 'waa 'bienʋ bʋ gbo nɩ, kɔ, nahuin ꞊nʋ, ‑ʋ nɩ 'le 'waa 'bienʋ bʋ gbo, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'waa 'plɔplɔ, nʋ‑ di ‑tado 'o 'waa 'bienʋ 'lu ye nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","'Hru ꞊nʋ, ‑ʋʋ Jrusrɛdɩɔ 'mʋ mu, nʋ‑ kɔ wlɔn ʋ nɩ 'o, 'ʋʋ mu. ‑Yusu, nɔ‑ 'nyɛ 'hru, 'a ‑naagbopʋ, 'ʋ nɩ 'o ꞊nɔ ke 'mʋ. Hʋannʋ nyu nu. Tii ‑do a ti 'yri, ‑Yusu 'ɔ 'ba lele 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ 'mʋ, 'ʋ bii ye. ‑Tɛ ʋ bii 'klɛɛ ye, ‑ye ɔ nyu 'le ‑wɔn 'nɩ 'prɛɛ, 'ke 'o ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ ‑wɛ lɛ kɛ ꞊nɔ nuelɛ a ‑ta 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ɔ nɔ: «Ba po 'mʋ nʋa ye gbo. ‑Aa 'mʋ mu Jrusrɛdɩɔ. 'Ke ʋ di 'le 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kwa po, kɔ teteitɔɔnyʋ 'hɛɛn. Ʋ di 'mʋ lɛ poo ‑bati, ʋ 'mʋ lɛ po, 'n nɩ 'mʋ 'kʋkʋɛ. 'Bɛ ‑hi, ʋ 'mʋ 'mʋ nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi kwa po, ");
INSERT INTO ted_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","nahuin a ‑gbɛ, ʋ 'mʋ 'mʋ 'caa, kɔ, ʋ 'mʋ 'mʋ hɩɔn 'hrin, kɔ, ʋ 'mʋ 'mʋ lɔkɔ bii, 'plɩɩ ʋ 'mʋ 'mʋ 'la. ‑Nyrɔwɩɩ 'hɔn 'bɩ ‑hi, ‑nyrɔwɔ a ta a nɔnɔ 'mʋ, 'plɩɩ 'mʋ 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, 'mʋ 'klɔ 'hrɩ.» ");
INSERT INTO ted_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","‑Tɛ dɛ a ‑gbɛ ɛ ‑hi, ‑ye ‑Yusu a ‑naagbopʋʋ 'hɔn ‑ye, ‑ʋ mɔ Sakɩ kɔ Saan 'hɛɛn, ‑ʋ mɔ Sebede a 'yuo꞊pli, nʋ‑ mu 'o ꞊nɔ 'hʋɩn 'mʋ, ʋ nɔ: «Tɔɔnyɔ o, dɛ ‑gbo, ‑a di ‑mʋ ‑hʋa, ‑a nye 'nɩ ‑hʋa, 'ke ‑bo nue, 'ke 'o ‑a mʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","‑Ye ‑Yusu nɔ: «Dɛ tio‑ aa ‑hʋa ꞊bo nu, 'ke 'o 'a mʋ ‑wɔn 'le?» ");
INSERT INTO ted_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","‑Ye ʋ nɔ: «Ti ꞊nʋ ‑kɔ 'yri nahuin 'bii die 'ye, ‑ɛ mɔ, ‑n kɔɔ nahuin 'bii ke win, 'ke 'le Nyɩsʋa a gbonɩɩlɛ 'mʋ, ‑a nye 'nɩ ‑hʋa, 'ke ‑ba nɩ 'o ‑mʋ 'hʋɩn 'mʋ gbo, ‑do 'ke 'le ‑na diidɛpɩa ke, ‑do ‑ye 'ke 'le ‑na kamrapɩa ke.» ");
INSERT INTO ted_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kɛɛ ‑ye ‑Yusu nɔ: «Dɛ aa ‑hʋa, dɛ bɛ ꞊hɛn 'nyrɛ, a 'die yi. ꞊Be a ‑wɛ 'le ba 'ye ꞊sʋɛdʋ ꞊nʋ nɩ, 'n di 'ye? Kɔ, ꞊be a ‑wɛ 'le ba wɛɛn ke nɩ, ‑tɛ 'n di 'kʋkʋɛ nu, ba nu ‑wɛ lɛ 'kʋkʋɛ?» ");
INSERT INTO ted_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","‑Ye ʋ nɔ: «‑A ‑wɛ 'le ꞊le.» ‑Ye ɔ nɔ: «'Ɛ mɔ ‑tɛɛ, ꞊sʋɛdʋ ꞊nʋ, 'n di 'ye, a 'mue 'ye, kɔ, 'kʋkʋɛdʋ ꞊nʋ 'n di 'kʋ, a 'mʋ ‑wɛ lɛ 'kʋkʋɛ nu. ");
INSERT INTO ted_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kɛɛ ‑ye ɛ 'de 'mɔ, 'n 'die 'le ‑wɔn kɔ, 'ke ꞊bo ꞊tui, nahuin tio‑ di 'le 'na diidɛpɩa kɔ 'na kamrapɩa 'hɛɛn ke gbo nɩ. Nyɩsʋa, nɔ‑ di nahuin a ‑gbɛ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","‑Tɛ ‑naagbopʋʋ ‑pu ‑ye ꞊nʋ, ʋ 'wɔn ‑tɩ ꞊nʋ, Sakɩ kɔ Saan 'hɛɛn, ʋ ꞊tu ‑Yusu ye, ‑ye ʋ nyu lɛ poo yrʋ. ");
INSERT INTO ted_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","‑Ye ‑Yusu da ʋ 'bii nɩ, ɔ nɔ: «A yie nɩ, ‑ɛ mɔ, 'klɔ ‑gbo a 'luyenɩnyʋ, ‑ʋʋ 'waa dakʋ naa, ʋ nyu ꞊tue ꞊sʋɛ, 'ʋ nyu 'mʋ 'plɔ. 'Waa 'kɩɩndɛ a ‑gbɛ, ʋ nye 'le 'kwli 'mʋ nuu 'crɛ. ");
INSERT INTO ted_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","A ‑mɛ ‑ye, 'ke 'le 'a mʋ ‑hɛyri, ɛ 'de lɛ 'mʋ nɩ. 'Ke 'le 'a mʋ ‑hɛyri, nahuon 'bɔɔ ‑hʋa bɔ 'ya 'a nɩ ye'mʋnaanyɔ 'mʋ, nahuon a ‑gbɛ, ɔ blɛ ye bɔ 'ya 'a nɩ 'mʋ‑hɛnyɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kɔ, 'ke 'le 'a mʋ ‑hɛyri, nahuon 'bɔɔ ‑hʋa bɔ 'ya 'a nɩ 'luyenɩnyɔ 'mʋ, nahuon a ‑gbɛ, ɔ blɛ ye bɔ ‑wɛ ‑wɔn, 'ke bɔ ‑hɛ a 'bii 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","'Na ‑gbɛ, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n 'de 'le di, 'ke nahuin bʋ ‑hɛ 'mʋ 'mʋ, kɛɛ, 'n di 'le ꞊le, 'ke ꞊bo ‑hɛ nahuin 'mʋ, kɔ, ꞊bo ‑ha 'n dɩɔnʋ, 'mʋ 'kʋ, ‑ɛ die nu, 'na 'kʋkʋɛ a ‑gbɛ, ɛ 'mue nu, Nyɩsʋa 'mʋ nahuin 'plɔplɔ ꞊gbla, 'ke 'o 'waa dɛ 'kuku ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ nyre 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Seliko. ‑Tɛ ʋʋ 'dɩɔ a ‑gbɛ 'mʋ ꞊tɩ, ʋ kɔ nahuin 'plɔplɔ 'hɛɛn, ‑ye 'ke 'o 'hru nʋa 'mʋ, 'ke 'yiisuanyɔ ꞊de nɩ 'o gbo, 'ɔɔ nahuin 'wli lɛ ‑hʋa, ‑ɛ die nu, ɔ 'mʋ dɛ di. 'Yiisuanyɔ a ‑gbɛ, 'a 'dʋ mɔ Batime. Nɔ‑ mɔ Time a 'yu. ");
INSERT INTO ted_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","‑Tɛ ɔ 'wɩn, ‑ɛ mɔ, Nasalɛtɩ 'mʋ a ‑Yusu'u nɩ, ‑ɔɔ ‑hi, ‑ye ɔ 'yaa 'le win, ɔ nɔ: «‑Yusu o, Dafidɩ a 'Yu, yrii 'mʋ wɔlɩ ye ‑o!» ");
INSERT INTO ted_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nahuin, ‑ʋ nɩ 'o, ‑ye ʋ nyo ꞊hɛn 'nyrɛ, ʋ nɔ: «Ma wien mɔ!» Kɛɛ ‑ye ɔ bla nɩ, 'ɔ 'yaa 'le lele win 'dɔ, ɔ nɔ: «‑Yusu o, Dafidɩ a 'Yu, yrii 'mʋ wɔlɩ ye ‑o!» ");
INSERT INTO ted_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","‑Tɛ ‑Yusu 'wɔn 'a win, ‑ye ɔ nyra gbo, ɔ nɔ: «Ba dɔ, bɔ di 'le!» 'ʋ dɔ, ʋ nɔ: «‑Mɔ ɔɔ da. Po 'le 'klɩ, ‑bo 'ba ye 'mʋ, ‑bo mu 'le ꞊nɔ 'hʋɩn 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","‑Ye Batime a ‑gbɛ, ɔ ꞊hɩnhɩɛn 'o 'a 'kɔlɔ gbo, ‑ye ‑gbisa, tii ‑do a ti 'yri, ‑ye ɔ nyra gbo, 'ɔ mu 'o ‑Yusu 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","‑Tɛ ɔ nyre 'klɛɛ 'o, ‑ye ‑Yusu ꞊gbɔ wlɔn, ɔ nɔ: «Dɛ tio‑ ‑nɩɩ ‑hʋa ꞊bo nu, 'ke 'o ‑mʋ ‑wɔn 'le?» ‑Ye ɔ nɔ: «Tɔɔnyɔ o, 'n nye 'nɩ ‑hʋa, ‑bo nue, 'na 'yii ‑gbo, ‑ɩɩ kla, bɩ klɛ ke!» ");
INSERT INTO ted_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","‑Ye ɔ lo nɩ, ɔ nɔ: «‑Tɛ ‑n kuo 'mʋ ꞊wlʋ ye, nɛ‑ nue, 'nɩ nue, ‑na 'yii 'ɩ klɛ ke. 'A ‑tɩ, ‑n ‑wɛ 'le ‑bo mu 'le kayu gbo nɩ.» Tii ‑do a ti 'yri, ‑ye ɔ ‑tʋa lɛyriilɛ gbo, 'ɔ bi 'o ‑Yusu ke 'mʋ, 'ɔ nyo ‑wɔn kʋɛ. ");
INSERT INTO ted_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","‑Tɛ ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋʋ Jrusrɛdɩɔ 'mʋ mu, bʋ 'mʋɛɛ 'dɩɛ ꞊nʋ ye, ‑ɛ mɔ Bɛtɩfase kɔ Betani, ‑ye 'ke ʋ nyre 'o dʋgba ꞊nʋ ꞊hlɔn, ‑ɔ kɔ 'lu ti nɩ 'le, ʋʋ olifie daa, ‑Yusu 'ɔ le 'a ‑naagbopʋʋ 'hɔn. ");
INSERT INTO ted_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Kɛ ɔɔ ꞊nʋ ye po: «Ba mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ nɩ 'le 'a mʋ ye 'mʋ. 'Bɩa 'ba 'ya 'dɩɔ a ‑gbɛ 'mʋ, ‑ye a di 'o gbo yɛ 'kasrayu, 'ʋ mʋ gbo. Nahuon ꞊de 'diu ‑hlɩn 'o ke a 'yɛɛ. 'Bɩa 'ba yʋ 'o gbo, ‑ye ba ꞊wlʋʋ gbo, ba yʋ 'mʋ ye. ");
INSERT INTO ted_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nahuon ꞊de 'bɔ ꞊gba 'a mʋ wlɔn, 'bɔ plɛ: Dɛ tio‑ aa nu 'le? ‑ye kɛ ba po: Kʋkɔnyɔ'ɔ nɩ, ‑ɔ nyu ‑hʋa. Ɔ diu de 'nɩ ‑mɩa 'tata a ti 'yri.» ");
INSERT INTO ted_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","‑Tɛ ʋ mu, 'ʋ 'ya 'dɩɔ a ‑gbɛ 'mʋ, ‑ye 'ɛ mɔ ‑tɛɛ, 'ke ʋ yɛ 'o 'kasrayu a ‑gbɛ gbo, 'ʋ mʋ 'o ꞊gbuhan.ye gbo, ‑naagbopʋʋ 'hɔn ‑wɛ a ‑gbɛ, 'ʋ ꞊wlʋʋ gbo. ꞊Gbuhan.ye a ‑gbɛ, 'ke nahuin 'plɔplɔɔ 'o naa. ");
INSERT INTO ted_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","'Ke 'le nahuin ꞊nʋ ‑hɛyri, 'ke ꞊ʋ ‑ye nɩ 'le, 'ʋ nyu wlɔn ꞊gba: «Dɛ tio‑ aa nu 'le? Dɛ‑ kɔ 'kasrayu ꞊nʋ a gbo꞊wlɛɛlɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","‑naagbopʋ a ‑gbɛ 'ʋ le ꞊nʋ, ‑tɛ ‑Yusu po ꞊nʋ ye, ‑ye nahuin a ‑gbɛ, ʋ wɔn nɩ, 'ʋ ‑hɩʋ mɛ lɛ, ");
INSERT INTO ted_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","'ʋ ya 'kasrayu a ‑gbɛ ‑Yusu ye. ‑Tɛ ʋ yʋ 'le, 'ʋ po 'o 'waa danɩ kɔ wlawlɩ 'kasrayu a ‑gbɛ ke gblɛ, ‑ɛ die nu, ‑Yusu 'bɔ 'yʋ 'o ke, ɔ 'mʋ danɩ a ‑gbɛ ke gbo nɩ. (‑Ɛ nue, ɔ nye nahuin 'nɩ tɔɔ, ‑ɛ mɔ, ɔ mɔ bodɩɔɔ nɩ, ‑ɔɔ 'le kegbowɛɛnlɛ ya. Ɛ 'de tʋ, ɔ 'nɩ yʋ ꞊le 'le. Ɛ nɛ‑ kɔ ‑tɩ, 'ɔ 'ya 'o 'kasra a ‑gbɛ ke.) ");
INSERT INTO ted_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","‑Tɛ ʋʋ 'le di, nahuin 'plɔplɔ 'ʋ po 'o 'waa nɩ danɩ 'hru wlɔn gblɛ. ꞊Ʋ ‑ye nɩ 'o, 'ʋ 'bɛ 'kwla, 'ʋ puo 'o 'hru wlɔn gblɛ, ‑Yusu 'ɔ nyo ke na, ");
INSERT INTO ted_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","nahuin 'ʋ nyo ye 'mʋ na, kɔ ꞊ʋ ‑ye 'ʋ nyo ‑wɔn kʋɛ. Kɛ ʋʋ nu, 'ʋʋ 'le win 'yaa, ʋ nɔ: «‑Na 'wio, ‑mɔ ‑gbo, ‑ɔɔ 'le di, 'ke 'le Kʋkɔnyɔ Nyɩsʋa a 'dʋ 'kwli 'mʋ. Nyɩsʋa bɔ ‑nye ‑mʋ ‑tɩ a 'yi'bʋaalɛ! ");
INSERT INTO ted_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ba pue Nyɩsʋa 'nyrɛɛ lɛ, ‑ɛ nue, nɔ‑ di ‑a mʋ win ke kɔɔ wɔn, ‑tɛ ‑a nɩ bu gblaka bodɩɔ Dafidɩ nu la, 'ɔ kɔɔ la nahuin win ke. Nyɩsʋa bɔ kɔ ‑tɩ a 'yi'bʋaalɛ, 'ke 'le yakɔ 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","‑Tɛ ‑Yusu 'ya 'klɛɛ Jrusrɛdɩɔ 'mʋ, ‑ye 'ke ɔ mu 'le Nyɩsʋa a 'kagblaka gbo, 'ɔ 'ye ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ nɩ 'le. ‑Tɛ 'tɔɔ ‑wɔn, ‑ye ɔ kɔ 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn a ‑gbɛ 'hɛɛn, ʋ ꞊hɩan ‑wɔn, 'ʋ mu 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Betani. ");
INSERT INTO ted_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ‑Yusu, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋʋ 'le Betanidɩɔ 'mʋ 'nɩ ‑hɔn, 'ʋʋ mu. Bʋʋ 'klɛɛ 'dɩɔ 'mʋ ꞊tɩ, ‑ye kanʋ bi 'le ‑Yusu 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bɔ ta 'klɛɛ 'le ye 'mʋ lɛ, ‑ye ɔ 'ye tugbɛdʋ ‑ye, ʋʋ figie daa. Tugbɛ a ‑gbɛ, ɛ hren ꞊nʋ ‑wɔn, hai 'ɩ ‑huo 'le ꞊nɔ 'klɔ, 'ɔ mue 'o ꞊hlɔn, ‑ɛ die nu, ɔ 'mue 'ye, 'bɩa 'bɛ tʋ 'kui. Bɔ nyre 'klɛɛ 'o ꞊nɔ ꞊hlɔn, ‑ye haii ‑doo nɩ, ɔ 'yee 'le ꞊nɔ 'klɔ, ‑ɛ nue, ɛ 'de wɛn 'a tʋtʋti a nue. ");
INSERT INTO ted_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","‑Ye kɛ ‑Yusuu tugbɛ a ‑gbɛ ye po: «Kʋɛ kɛ 'klɛɛ mɔ gbo, ꞊nɩ tʋ 'le 'klɛɛ lele 'kui ꞊de nɩ gbe, nahuin 'nɩ ꞊hin di!» ‑Yusu a pupowin a ‑gbɛ, 'a ‑naagbopʋ 'wɩn nɩ. ");
INSERT INTO ted_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ʋ nyre 'le Jrusrɛdɩɔ 'mʋ nɩ, ‑Yusu 'ɔ pa 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ. 'Ke 'le ‑yaa a ‑gbɛ 'mʋ, 'ke puplonyʋ nɩ 'le, 'ʋʋ 'wlugba‑tɔplɩ plo, 'ke 'o Nyɩsʋa a ‑cɔhlʋn a pipie ‑wɔn. 'Ke 'wli'cɩcɩnyʋ nɩ ‑wɛ 'o, 'ʋʋ pʋpʋwli 'cɩcɩ. ‑Tɛ ‑Yusu yɛ 'o puplonyʋ a ‑gbɛ gbo, ʋ kɔ nahuin ꞊nʋ 'hɛɛn, ‑ʋʋ ‑tɔplɩ ‑tɔ, ‑ye ɔ ‑tʋa 'waa lɛbʋbla gbo, 'ɔɔ 'wli'cɩcɩnyʋ a 'teblei ye gblɛ ꞊jri, kɔ, 'ɔɔ 'le ‑plijɩplonyʋ a gbatɩ yrɛ 'nyraa, 'ɩɩ ꞊hlɔn lɛ bi, ");
INSERT INTO ted_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","kɔ, 'ɔ 'de 'a nahuon ꞊de mɛ lɛ ‑ha, 'ke bɔ 'ble dɛ, 'plɩɩ bɔ 'bɛ ‑yaa a ‑gbɛ ꞊tɩɔ. ");
INSERT INTO ted_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","‑Ye ɔ ‑tʋa 'waa tɔɔlɛ gbo, kɛ ɔɔ 'klɛɛ po: «Ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Nyɩsʋa nɔ 'nɩ: 'Na kayu nɩ 'o ꞊o, ‑ɛ die nu, 'klɔ ‑gbo a nahuin 'bii, ʋ 'mʋ 'le 'mʋ daa.» Kɛ ‑Yusuu lele po, ɔ nɔ: «Kɛɛ ‑ye a ‑mɛ ‑ye, a nuu kayu a ‑gbɛ 'mʋ 'yrinyʋ a kayu.» ");
INSERT INTO ted_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Dɛ a ‑gbɛ, ‑ɛ mue 'lu ‑wɔn, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ teteitɔɔnyʋ 'hɛɛn, ʋ 'wɩn nɩ. Nɛ‑ nue, 'ʋʋ 'hru lɛ ꞊mɔ, ‑ɛ die nu, ʋ 'mʋ ‑Yusu 'la, ‑ɛ nue, nahuinŋ, ʋ nʋɛ 'a tɔɔwin 'mʋ nɩ 'dɔ. Nɛ‑ nue, nyɩgblakɩ a ‑gbɛ 'ʋʋ ca ꞊tu. ");
INSERT INTO ted_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","‑Tɛ 'tɔɔ ‑wɔn, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ ꞊tɩ 'mʋ 'dɩɔ, 'ʋ mu 'le ‑tɛgbi ‑ye. ");
INSERT INTO ted_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","‑Nyrajru 'mʋ, bʋʋ 'klɛɛ de ‑mɛ, ‑ye tugbɛ, ‑ɛ mɔ figie, ‑Yusu po 'tʋ 'jrɔ ye, nɛ‑ kɔ 'hʋɩn 'mʋ ʋʋ 'o lele naa. ‑Tɛ ʋ nyre 'klɛɛ 'o 'hʋɩn 'mʋ, kʋɛ 'le 'a 'lu ye gbo, ‑bo yɛ 'a ‑wlubʋɩ ke, ɩ 'bii, ɩ 'kʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","‑Ye dɛ ꞊nʋ, ‑ɛ mue 'tʋ 'lu ‑wɔn, ɛ bi 'le Piɛlɩ 'mʋ 'kwli, ɔ nɔ: «Tɔɔnyɔ, 'ye tugbɛ ‑gbo, ‑n po 'tʋ 'jrɔ ‑wɔn, ɛ 'kʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ba kuo Nyɩsʋa ꞊wlʋ ye! ");
INSERT INTO ted_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","'Bɩa 'ba kuo ꞊wlʋ ye, ‑ye a ‑wɛ 'le ba le dʋgba ꞊nʋ nɩ: ‑Hɔn 'o ‑tɛgbi ꞊nʋ 'mʋ, bi 'le 'yru ‑wɔn! 'Ba 'nɩnɩ po gblɛ, 'ke 'le 'a nɩ ꞊wlɩ ke, kɛɛ, 'ba pue ‑tɛɛ, ‑ɛ mɔ, ‑tɩ ꞊nʋ, a ꞊tu, ɩ di ‑wɔn mue 'lu, ‑ye 'ɛ mɔ ‑tɛɛ, Nyɩsʋa die 'nɩ nu, ɩ 'mʋ 'lu ‑wɔn mue. ");
INSERT INTO ted_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nɛ‑ nue, 'nɩɩ 'a mʋ le, 'baa Nyɩsʋa dɛ ‑hʋa, ‑ye ba kue ꞊wlʋ ye, ‑ɛ mɔ, ɔ ‑nye 'a mʋ nɩ ‑dodo, ‑ye 'ɛ mɔ ‑tɛɛ, ɔ die 'a mʋ 'nɩ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kɛɛ, 'baa Nyɩsʋa da, nahuon 'bɔ nu 'a mʋ 'yilɛnyredɛ 'mʋ, ‑ye ba ‑hri 'a 'yilɛnyredɛ a ‑gbɛ a ‑tɩ ‑wɔn, ‑ɛ die nu, 'a nɩ Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ 'mʋ ‑wɛ 'a nɩ 'yilɛnyre‑tɔplɩ a ‑tɩ ‑wɔn ‑hri.  ");
INSERT INTO ted_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kɛɛ, 'yilɛnyre‑tɔplɩ ꞊nʋ, nahuin nu 'a mʋ 'mʋ, 'ba 'nɩnɩ ‑hri 'a ‑tɩ ‑wɔn, ‑ye 'a nɩ Bu Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, ɔ 'deɛ bɔ ‑hri ‑wɛ 'a nɩ 'yilɛnyre‑tɔplɩ, a nu a ‑tɩ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ 'kɩɛ gbɛɛ 'waa 'hru 'lu ‑wɔn, ‑ʋʋ Jrusrɛdɩɔ 'mʋ mu. ‑Tɛ ʋ nyre 'klɛɛ 'le, ‑ye 'ke ‑Yusu mu 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ. ‑Tɛ ɔɔ lɛ 'dɛɛ, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ Nyɩsʋa a teteitɔɔnyʋ, ʋ kɔ ‑Juukʋɛ a 'blʋ a nahuin ‑ye 'hɛɛn, ʋ nyro 'o 'mʋ 'hʋɩn, ");
INSERT INTO ted_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ʋ nɔ: «Nyɔ‑ ‑nyi 'klɛɛ ‑mʋ 'klɩ, 'ke ‑bo bla ‑tɔplɩplonyʋ ‑gbo lɛ 'le? Nyɔ‑ le ‑mʋ, 'ke ‑bo nu ‑tɔplɩ 'bii ‑gbo, ‑nɩɩ nu 'le?» ");
INSERT INTO ted_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","‑Ye ‑Yusu nɔ: «'N di ‑wɛ 'a mʋ wlɔn ꞊gba dɛ. 'Bɩa 'ba ‑hɩhɩɛ 'mʋ klɛ, ‑ye 'n di 'a mʋ klɛ 'nɩ ‑hɩhɩa. ");
INSERT INTO ted_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","'A mʋ 'nɩɩ 'klɛɛ wlɔn ꞊gba: Nyɔ‑ le la Saan, 'ke bɔ po la nahuin 'nie 'lu lɛ 'le? ꞊Be Nyɩsʋa'a nɩ, ‑hee' ‑tʋnahuiin nɩ? Ba ‑hɩhɩa 'mʋ klɛ!» ");
INSERT INTO ted_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","‑Ye ʋʋ wlɔn lɛ 'nɩ ꞊gbʋgba: «‑Be' ‑a di 'klɛɛ po 'le? 'Bɩa ꞊ba plɛ: Nyɩsʋa'a nɩ, ‑ɔ lo la, ‑ye ɔ di ‑a mʋ wlɔn 'nɩ ꞊gba: ‑Tɩ ꞊nʋ, Saan, ɔɔ la ꞊tu, dɛ‑ nue, 'a 'di la ‑tɛɛ pue 'le? ");
INSERT INTO ted_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mɔ, 'bɩa ꞊ba plɛ, ‑tʋnahuiin nɩ, ‑ye nahuin di ‑a mʋ yɛɛ ‑tɩ.» Kɛ'ɛ nɩ, ʋ po, ‑tɛ ʋʋ wlɔn lɛ ꞊gbʋgba, ‑ɛ nue, nahuin pui ‑tɛɛ, ‑ɛ mɔ, Saan, ɔ mɔ la Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Nɛ‑ nue, 'ʋ ꞊tu ‑Yusu ‑wɔn, ʋ nɔ: «‑A 'de 'a dɛ ꞊de yi.» ‑Ye ‑Yusu nɔ: «'Na ‑gbɛ, 'n 'deɛ ꞊bo le ‑wɛ 'a mʋ, nyɔ‑ ‑nyi 'mʋ 'klɩ, 'ke ꞊bo nu ‑tɔplɩ 'bii ‑gbo, 'nɩɩ nu.» ");
INSERT INTO ted_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","(‑Yusu 'kɩɛ 'prɛɛ 'le Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ a ‑gbɛ ‑wɔn, kɔ teteitɔɔnyʋ, kɔ ‑Juukʋɛ a ye'mʋnaanyʋ ‑ye 'hɛɛn, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ.) 'Ke ɔɔ 'le ‑talʋdʋɩ 'kwli 'mʋ naa, 'ɔɔ 'le ꞊nʋ ‑wɔn 'prɛɛ, ɔ nɔ: «Ɛ kɔ la 'dɩdɔnyɔ ꞊de. Nɔ‑ nu la 'a ‑ci. ‑Ci a ‑gbɛ ke, ɔ 'dɔɔ 'le ti ꞊de. 'A 'yɔ, ɩɩ tʋ, ʋ nyo daa rɛsɛn. 'Dɩdɔnyɔ a ‑gbɛ, nɔ‑ ‑ha 'a ‑ci a ‑gbɛ ye, 'ɔ 'blu 'le 'hɩɔ gblaka ‑ye 'kwli 'mʋ lɛ, ‑ɛ die nu, 'bʋʋ 'a 'yɔ ꞊nʋ 'mʋ 'plɔ, 'a 'nie 'mʋ 'le 'hʋɔ a ‑gbɛ wlɔn bi, ʋ 'mue nɔ 'mʋ nuu. Ɔ nu ‑wɛ 'hɛ‑gbɔ, ‑ɔ kɔ ke ʋ di 'o ‑ci 'yie ꞊tuu, 'ke 'o 'yrinyʋ a ‑ta 'mʋ. ‑Tɛ ɔ ‑wɔ ‑kʋan 'bii ‑wɔn, ‑ye ɔ le ‑kʋannunyʋ ꞊de, 'ke bʋ nu ‑ci a ‑gbɛ a ‑kʋan, 'dɩdɔ‑tɔplɩ 'bɩ tʋ, ‑kʋannunyʋ a ‑gbɛ, ʋ 'mʋ ꞊nɔ 'a 'pɩa ‑nyi, 'waa ‑gbɛ, ʋ 'mʋ ‑wɛ 'o 'waa nɩ 'pɩa kɔ. ‑Cikɔnyɔ a ‑gbɛ, ‑tɛ ɔ ‑wɔ ‑kʋan a yegblɛ꞊tutulɛ ‑wɔn, ‑ye ɔ mu 'mʋ 'dagba ‑pɛtu. ");
INSERT INTO ted_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","‑Tɛ 'dɩdɔ‑tɔplɩ a 'cɩcɛti nyre 'o, ‑ye ‑cikɔnyɔ a ‑gbɛ, ɔ le 'a lɛleenyɔ ‑ye, 'ke bɔ mu 'le ‑ci'yie꞊tunyʋ ꞊nʋ ‑wɔn, ʋ 'mʋ ꞊nɔ 'cɩcɛ‑tɔplɩ a 'pɩa ‑nyi, ɔ 'mui ‑cikɔnyɔ ye ya. ");
INSERT INTO ted_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","‑Tɛ lɛleenyɔ a ‑gbɛ, ɔ nyre 'klɛɛ 'le, ‑ye ‑ci'yie꞊tunyʋ, ʋ klo nɩ, 'ʋ bio ‑tɛɛ, 'plɩɩ, ʋ 'de ꞊nɔ dɛ ꞊de ‑nyi, 'ʋ ‑mɩɔ de. ");
INSERT INTO ted_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","‑Ye ‑cikɔnyɔ, ɔ lee lele 'a lɛleenyɔ ‑ye, 'ʋ klo lele, 'ʋ hra 'a 'lu dɛ, 'ʋ ꞊tuo tanɩ, 'ʋ ‑mɩɔ lele de, ");
INSERT INTO ted_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","‑cikɔnyɔ a ‑gbɛ, 'ɔ le lele ꞊ɔ ‑ye, 'ʋ klo, 'ʋ 'lɔ, 'ɔ le lele ꞊ʋ ‑ye, 'ʋ bi ꞊ʋ ‑ye, 'ʋ 'la ꞊ʋ ‑ye. ");
INSERT INTO ted_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nahuoon ‑do, nɔ‑ hie 'klɛɛ 'o ‑cikɔnyɔ a ‑gbɛ 'hʋɩn 'mʋ. Nahuon a ‑gbɛ, nɔ‑ mɔ 'a 'mʋnʋɛyu, 'ɔ loo 'le ꞊nʋ ‑wɔn, ‑ɛ nue, 'a ꞊wlʋ nɔ 'nɩ: ‑Tɛ ɔ 'ya 'na 'yu 'mʋ, ʋ di kɔ 'a 'o꞊tuulɛ. ");
INSERT INTO ted_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","‑Tɛ ɔ waan 'le ye, ‑ye kɛ ʋʋ po, 'ke 'le 'waa dɩɔnʋ ‑gbahlɔn: Nahuon, ‑ɔ di ‑tado ‑ci ‑gbo kɔ, nɔ‑ɔ 'le di. Ba nɩ ‑ba 'lɔ, ‑a 'mʋ ‑ci ‑gbo gba, ");
INSERT INTO ted_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","'ʋ klo, 'ʋ 'lɔ, 'ʋ 'bɔ ye 'mʋ, 'ʋ 'hrɔɔ 'le ‑ci 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","‑Ye ‑Yusu nɔ lele: «'A mʋ 'nɩɩ wlɔn ꞊gba, nahuon, ‑ɔ kɔ ‑ci a ‑gbɛ, 'bɔ 'wɔn ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ mue 'lu ‑wɔn, dɛ tio‑ ɔ di nu 'le? 'A ‑gbɛ, ɔ di 'le 'nɩ di, ɔ 'mʋ ‑ci'yie꞊tunyʋ a ‑gbɛ 'la, 'plɩɩ ɔ 'mʋ 'le lele ‑ci a ‑gbɛ ‑ha, ɔ 'mue lele ꞊ʋ ‑ye ‑nyi. ");
INSERT INTO ted_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","‑Tɩ ‑gbo, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, 'n pui ‑tɛɛ, a ‑hri nɩ. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: 'Katuo ꞊nʋ, kayuponyʋ 'de ‑hʋa bʋ nuu ‑kʋan 'yri, ʋ po 'pɩa ke, nɔ‑ ‑hɛ kayu a ‑gbɛ a 'katuo gblaka. ");
INSERT INTO ted_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kʋkɔnyɔ Nyɩsʋa, nɔ‑ nue, 'ɔ ‑hɛ 'katuo gblaka, 'plɩɩ 'ɔ nɔɔ 'yie ke, 'ke 'o ‑a mʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","'Plɩɩ ‑Yusu 'mʋ mu ‑yrɛ, ‑ye ‑Juukʋɛ a ye'mʋnaanyʋ, ‑ʋ nɩ 'o, ʋ yree nɩ, ‑ɛ mɔ, nʋ‑ ‑Yusu po ‑talʋdʋ a ‑gbɛ ye. ‑Tɛ ʋ yrii dɛ a ‑gbɛ, ‑ye ʋʋ lɛ ꞊mɔ 'hru, 'ke bʋ klo, ʋ 'muo 'la. Kɛɛ, ‑tɛ ʋʋ nahuin a hʋannʋ pɩ, nɛ‑ nue, 'ʋ ‑hɩɔ mɛ lɛ, 'ʋ mu. ");
INSERT INTO ted_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Juukʋɛ a ye'mʋnaanyʋ, ʋ tɛ gbo Falisi꞊tumu a nahuin ‑ye, kɔ nahuin ‑ye 'hɛɛn, ‑ʋ mɔ 'kɩɩn Helɔdɩ a ꞊tumu a nahuin. Nʋ‑ di 'o ‑Yusu 'hʋɩn 'mʋ, ʋ 'muo wlɔn lɛ ꞊gba, 'a ‑wɔn꞊tutue 'kwli 'mʋ, ʋ 'mʋ 'le naa, ʋ 'muo ‑tɩ yɛɛ, ‑ɛ die nu, ʋ 'muo klɩ. ");
INSERT INTO ted_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","‑Tɛ ʋ nyre 'klɛɛ 'o ꞊nɔ 'hʋɩn 'mʋ, ‑ye ʋ nɔ: «Tɔɔnyɔ o, ‑a yie nɩ, ‑ɛ mɔ, ‑nɩɩ ꞊tu ‑tɩ a ‑tɛɛ. 'Bɩa ꞊nɩ nyi ꞊tu, ꞊nɩ pɩ ꞊le hʋannʋ, 'ke 'o ‑tʋnahuon a 'lu a lɛ‑hielɛ a ‑ta 'mʋ, mɔ ꞊betɩ bɔ 'ya nyɩgblaka 'mʋ. Kɛɛ, ‑nɩɩ tɔɔ ‑tɩ a ‑tɛɛ, 'ke 'o dɛ ꞊nʋ, Nyɩsʋaa ‑a mʋ ‑hʋa a ‑ta 'mʋ. Le 'klɛɛ ‑a mʋ, ꞊be Nyɩsʋa a tetei nɔ 'nɩ, ‑ba ‑ha 'blʋwli, ‑ba ‑nyi Romakʋɛ a 'kɩɩn gblaka. ꞊Be ‑a blɛ ye ‑ba 'pɛɛ 'blʋwli a ‑gbɛ, ‑hee' ‑a 'de ye blɛ ‑ba 'pɩɩ?» ");
INSERT INTO ted_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Kɛɛ ‑ye ‑Yusu yie nɩ, dɛ‑ mɔ 'waa 'lu a lɛ‑hielɛ, 'ʋ nye ꞊nɔ 'yi ke ‑hli, ɔ nɔ: «Dɛ‑ kɔ ‑tɩ ꞊nʋ, aa 'mʋ wlɔn ꞊gba, 'aa 'mʋ 'mʋ lɛ ꞊tɔ 'le? ꞊Be a 'mue 'ye, 'bɩa 'nɩ ‑haa Romakʋɛ a 'kɩɩn gblaka a ‑tɩ lɛ, kɔ Nyɩsʋa a ‑tɩ 'hɛɛn, a 'mʋ 'mʋ ‑tɩ yɛɛ? Ba ya 'mʋ 'wliyɔkɔ a 'yɛɛ ‑do ye, 'mue 'ye,» ");
INSERT INTO ted_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","'ʋ yɛ ꞊nɔ ye. ‑Ye ɔ nɔ: «Nyɔ tio‑ kɔ 'lu꞊tɩɔ nɩ 'o 'le? Nyɔ tio‑ kɔ 'dʋ ʋ 'crɩɩ ‑wɛ 'o 'le?» ‑Ye ʋ nɔ: «Romakʋɛ a 'kɩɩn gblakaa nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","‑Ye kɛ ‑Yusuu 'klɛɛ ꞊nʋ ye po, ɔ nɔ: «'A ‑tɩ o, ba ‑nyi 'kɩɩn gblaka dɛ, ‑ɛ blɛ ꞊nɔ ye, kɔ, ba ‑nyi ‑wɛ Nyɩsʋa dɛ, ‑ɛ blɛ ꞊nɔ ye!» ‑Tɩ ‑Yusu ꞊tu ꞊nʋ ‑wɔn, ɩ saka ꞊nʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","'Ke 'le Jrusrɛdɩɔ 'mʋ, ɛ kɔ la ꞊tumu. 'A 'dʋ mɔ Sadusɩ꞊tumu. Nʋ‑ʋ nɩ, ‑ʋ nyi ꞊tu, ‑ɛ mɔ, nahuin 'bʋ 'kʋ, ɛ 'die 'le ‑wɛ bʋ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, bʋ 'hrɩ 'klɔ, 'ke 'le Nyɩsʋa ye. Nʋ‑ kɔ nahuin mu 'o ‑Yusu 'hʋɩn 'mʋ, ‑ɛ die nu, ʋ 'muo wlɔn lɛ ꞊gba. ‑Tɛ ʋ nyre 'klɛɛ 'o ꞊nɔ 'hʋɩn 'mʋ, ‑ye ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Tɔɔnyɔ o, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, ɔ 'crɩɩ la tete ‑ye, 'ɔ hie la ‑a mʋ lɛ. Tete a ‑gbɛ, ɛ nɛ‑ ‑gbo: Nyɩbɛyu 'bɔ nɩ 'o, 'bɔ kɔ nyrɔ, 'plɩɩ nyɩbɛyu a ‑gbɛ, 'bɔ 'de 'yuo gbo hie, 'bɔ 'kʋ, ‑ye nyɩbɛyu ꞊nʋ, ‑ɔ 'kʋ, 'bɔ kɔ 'dɩayu nyɩbɛyu, nɔ‑ blɛ ye ‑bɔ kɔ 'a nyrʋgba a ‑gbɛ, ɔ kɔ ꞊nɔ 'hɛɛn, ʋ 'mʋ 'yuo kɔ, 'ke 'o 'a 'dɩayu, ‑ɔ 'kʋ a ‑ta 'mʋ. Kɛ Moise a tetee po.» ");
INSERT INTO ted_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","‑Ye kɛ ʋʋ lele po, ʋ nɔ: «Ɛ kɔ la ‑dɩayuo nyɩbɛpʋʋ 'nɩpata, 'waa ye‑hɛnahuon 'ɔ kɔ nyrʋgba, nyɩbɛyu a ‑gbɛ 'ɔ 'de 'yuo gbo hie, 'ɔ 'kʋ, ");
INSERT INTO ted_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","'hɔn a nɔnɔ 'ɔ kʋɔ, 'ɔ 'de ‑wɛ 'yuo gbo hie, 'ɔ 'kʋ ‑wɛ. Dɛɛ ‑do a ‑gbɛ, nɛ‑ nue ta a nɔnɔ. ");
INSERT INTO ted_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nɛ‑ nue ‑nuenue, nahuon a 'nɩpata a nɔnɔ 'ɔ kʋɔ ‑wɛ, 'ɔ 'de ‑wɛ 'yuo gbo hie, 'ɔ 'kʋ. ‑Tɛ ʋ 'bii, ʋ 'kʋ 'klɛɛ, ‑ye nyrʋgba a ‑gbɛ, ɔ 'kʋ la ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nɛ‑ mɔ ‑tɩ, ‑a di wɛn ‑mʋ wlɔn ꞊gba wɔn, ꞊mʋ ‑a mʋ klɛ ‑hɩhɩa. ‑Nyrɔwɔ ‑kɔ 'mʋ nahuin di 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, ʋ 'mʋ 'klɔ 'hrɩ, 'ke 'le Nyɩsʋa ye, nahuon tio‑ di 'klɛɛ nyrʋgba a ‑gbɛ kɔ 'le, ‑ɛ nue, ‑tɛ ʋ nɩ la nɔ ‑tʋtʋ ke, nahuiin 'nɩpata a ‑gbɛ, ʋ kʋɔ la nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Aa 'nɩ ka, ‑ɛ nue, a 'de Nyɩsʋacrɩɩnɩɛ yi, 'a 'die ‑wɛ yi, ‑ɛ mɔ, Nyɩsʋa nɩ ke 'klɩ. ");
INSERT INTO ted_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ti ꞊nʋ ‑kɔ 'yri nahuin di 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, ʋ 'mʋ 'klɔ 'hrɩ, 'ke 'le Nyɩsʋa ye, nyɩbɛpʋ kɔ nyrʋgbapʋ 'hɛɛn, ʋ 'deɛ bʋ kʋkɔ. Kɛɛ, ‑tɛ Nyɩsʋa a lɛleenyʋ nɩ 'mʋ, kɛ'ɛ nɩ, ʋ di ‑wɛ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","'Ya 'o lele 'lu, dɛ ‑gbo, ‑ɛ mɔ nahuin bʋ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, bʋ 'hrɩ 'klɔ, 'n yie nɩ, ‑ɛ mɔ, a ‑hre Nyɩsʋacrɩɩnɩɛ ꞊nʋ nɩ, Moise 'crɩɩ la. Ɔ 'crɩɩ la dɛ ꞊nʋ nɩ, Nyɩsʋa le ꞊nɔ, ‑tɛ Nyɩsʋa a ‑gbɛ, ɔ nɩ la 'le ‑gbakuduo ꞊nʋ 'kwli 'mʋ, ‑ɔɔ wlɩn, 'plɩɩ ‑tɛ ɔ 'prɛɛ la 'le Moise a ‑gbɛ ‑wɔn. Kɛ Nyɩsʋaa la po: 'Mɔ mɔ Nyɩsʋa ꞊nʋ, Abrahamʋ, ɔɔ da, ɔ kɔ Yisakɩ, kɔ Sakɔbʋ 'hɛɛn. Kɛ'ɛ nɩ, Nyɩsʋa po. ");
INSERT INTO ted_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɛ 'we ꞊nɔ ye, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋaa 'le Moise ‑wɔn 'prɛɛ, Abrahamʋ kɔ Yisakɩ kɔ Sakɔbʋ 'hɛɛn, ʋ 'kʋ la nɩ. Kɛɛ, ‑a yie nɩ, ‑ɛ mɔ, ɛ 'de 'kʋkʋnyʋ, ʋ 'nɩ da ꞊le Nyɩsʋa, kɛɛ, 'klɔnɩnyʋ, nʋ‑ nyo da. 'A ‑tɩ, 'ba plɛ, nahuon 'bɔ 'kʋ, ɔ 'nɩ 'hrɩ ꞊le 'klɔ, 'ke 'le Nyɩsʋa ye, ‑ye ɛ 'de ꞊nɛ. A ka nɩ 'bii.» Kɛ'ɛ nɩ, ‑Yusu po. ");
INSERT INTO ted_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Teteitɔɔnyɔ ‑ye, ‑ɔ nɩ ‑tuo ke, ɔ 'wɔn ‑tɩ 'bii ꞊nʋ nɩ, ʋ ꞊tu. ‑Tɛ ɔ 'wɩn 'klɛɛ, ‑ɛ mɔ, ‑Yusu ꞊tu Sadusɩ꞊tumu a nahuin ‑wɔn ‑tɛɛ, ‑ye ɔ 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, 'ɔ ꞊gbɔ wlɔn, ɔ nɔ: «Tetei 'bii ꞊nʋ, Nyɩsʋa ‑nyi ‑a mʋ, tete tio‑ nɩ 'o tetei 'bii 'lu ye 'le?» ");
INSERT INTO ted_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «Nyɩsʋa a tete ꞊nʋ, ‑ɛ nɩ 'o tetei 'bii 'lu ye, ɛ nɛ‑ ‑gbo: Ba po 'o nʋa gbo, 'a mʋ Yisraɛkʋɛ: ‑A nɩ Kʋkɔnyɔ Nyɩsʋa, nɔ‑ mɔ Nyɩsʋaa ‑do. 'Bɛɛ 'o ke, nyɩsʋa ꞊de 'de 'klɛɛ 'o lele nɩ. ");
INSERT INTO ted_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","‑N blɛ ye ‑bo nʋɛ ‑na Kʋkɔnyɔ Nyɩsʋa 'mʋ, 'ke 'le ‑na ꞊wlʋ 'bii ke, kɔ 'ke 'le ‑na 'lu a lɛ‑hielɛ 'bii 'kwli 'mʋ, kɔ 'ke 'le ‑na 'klɩ 'bii 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nyɩsʋa a tete ‑ye, ‑ɛ kʋɛ 'o ꞊nɔ ‑wɔn, ɛ nɛ‑ ‑gbo: ‑N blɛ ye ‑bo nʋɛ ‑n 'be ‑tʋnahuon 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n nu ‑n dɩɔnʋ a 'mʋnʋɛlɛ. Ɛ 'de Nyɩsʋa a tete ꞊de kɔ, ‑bɛ nɩ 'o ɩ 'hɔn a ‑gbɛ 'lu ye.» ");
INSERT INTO ted_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","‑Ye teteitɔɔnyɔ a ‑gbɛ, ɔ nɔ: «꞊Hapʋkɔɔ nɩ, ‑tɩ ꞊nʋ, ‑n ꞊tu, 'a ‑tɛɛ, nɛ‑ɛ nɩ. ‑A nɩ Kʋkɔnyɔ Nyɩsʋa, nɔ‑ mɔ Nyɩsʋaa ‑do. 'Bɛɛ 'o ke, Nyɩsʋa ꞊de 'de 'klɛɛ 'o lele nɩ. ");
INSERT INTO ted_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","‑Tʋnahuon blɛ ye bɔ nʋɛ Nyɩsʋa 'mʋ, 'ke 'le 'a ꞊wlʋ 'bii ke, kɔ 'ke 'le 'a 'lu a lɛ‑hielɛ 'bii 'kwli 'mʋ, kɔ 'ke 'le 'a 'klɩ 'bii 'mʋ. Ɛ blɛ ‑wɛ ye bɔ nʋɛ 'a 'be ‑tʋnahuon 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ɔ nu 'a dɩɔnʋ a 'mʋnʋɛlɛ. Nɛ‑ mɔ dɛ gblaka, 'ɛ ‑hi 'o bɔ pi 'ɛ nɩ 'wlugba‑tɔplɩ a ‑cɔhlʋn a gblegblei ꞊de, 'ke 'o Nyɩsʋa ye.» ");
INSERT INTO ted_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","‑Yusu bɔ 'ye, ‑ɛ mɔ, teteitɔɔnyɔ a ‑gbɛ, ɔ ꞊tuo ‑wɔn, 'ke 'le ꞊tɔ 'kwli 'mʋ, ‑ye ɔ nɔ: «Ɛ hie 'o dɛ gbii ‑do, ꞊mʋ Nyɩsʋa ye 'mʋɛɛ, 'ke bɔ kɔɔ ‑mʋ win ke.» Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ꞊ɔ ꞊de 'dio 'klɛɛ lele dɛ wlɔn ꞊gba, ‑ɛ die nu, 'ke 'le 'a ‑wɔn꞊tuwin 'kwli 'mʋ, ʋ 'mʋ 'le naa, ʋ 'muo wɛn ‑tɩ yɛɛ. ");
INSERT INTO ted_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusuu nahuin tɔɔ Nyɩsʋa a ‑tɩ, 'ke 'le Nyɩsʋa a 'kagblaka gbo. ‑Tɛ ɔ nyu 'klɛɛ tɔɔ, ‑ye ɔ nɔ: «Teteitɔɔnyʋ nɔ 'nɩ: Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, Waanyɔ a ‑gbɛ, nɔ‑ mɔ bodɩɔ Dafidɩ a 'yuo a 'Yu. 'A mʋ 'nɩɩ 'klɛɛ wlɔn ꞊gba: Dɛ‑ kɔ ‑tɩ 'ʋ nyi ꞊tu 'le? ");
INSERT INTO ted_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","‑ɛ nue, Nyɩsʋa a ‑Hihiu nue nɩ, bodɩɔ Dafidɩ 'ɔ ꞊tui la, 'ʋ 'crɩɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Kʋkɔnyɔ Nyɩsʋa, ɔ le 'na Kʋkɔnyɔ nɩ, ‑ɛ mɔ: Nɩ mɔ 'na diidɛpɩa ke gbo, ‑n kɔ 'mʋ 'hɛɛn, ‑a 'mʋ nahuin win ke kɔɔ, ɛ 'mue gba ‑gbagba, 'mue nu, ꞊mʋ ‑na yraanyʋ bʋɩ 'lu gblɛ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","‑Ye ‑Yusu nɔ lele: «‑Tɛ Dafidɩ a ‑gbɛ, ɔɔ Waanyɔ a ‑gbɛ 'a Kʋkɔnyɔ daa, ‑be' Waanyɔ a ‑gbɛ, ɔ ‑wɛ 'le bɔ nu Dafidɩ a 'Yu a 'mʋ'yɩya 'le?» Nahuin ‑huohui ꞊nʋ, ‑ʋ nɩ ‑tuo ke, ‑tɩ ꞊nʋ, ‑Yusu ꞊tu, ɩ blee 'waa plɔ nɩ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kɛ ɔɔ ꞊nʋ ye po, 'ke 'le 'a tɔɔwin 'kwli 'mʋ: «Ba ꞊tu 'a nɩ dɩɔnʋ 'yie, 'ke 'o teteitɔɔnyʋ ‑wɔn, ʋ 'nɩ ꞊han 'a mʋ kaa. Ʋ nʋɛ 'mʋ nɩ, 'ke nahuin bʋ daa ꞊nʋ nyɩgblakɩ. 'Bʋʋ lɛ na, 'ʋʋ nyɩgblakɩ a wlawlɩ pue, ‑ɛ die nu, nahuin 'mu 'ye. 'Bʋʋ 'o 'ɛ nɩ ‑tɛgbi ꞊de mu, ‑tɛ nahuin ‑huo 'o, ‑ye ʋ nye 'nɩ ‑hʋa, nahuin bʋ pu 'wio gblɛ, 'ke 'o 'waa 'o꞊tuulɛ a ‑ta 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","'ʋ nʋɛ ‑wɛ 'mʋ, 'bʋ mu 'le Nyɩsʋa a kayu gbo, 'ke bʋ nɩ 'le ye 'mʋ gbo, ‑ɛ die nu, nahuin 'bii 'mu 'ye. Dɛɛ ‑do a ‑gbɛ, nɛ‑ ʋʋ nu, 'bʋ dʋ dididɛ ‑wɔn, ");
INSERT INTO ted_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","'plɩɩ, 'ʋʋ kotianyrʋ kʋkɔ‑tɔplɩ 'bii kwa lɛ ‑ha. 'Plɩɩ teteitɔɔnyʋ a ‑gbɛ, 'bʋʋ Nyɩsʋa da, 'waa Nyɩsʋa a dɩda hren gbo ye, ‑ɛ die nu, nahuin 'mʋ lɛ po, ʋ mɔ ꞊hapʋnahuiin nɩ. 'Nɩɩ 'a mʋ 'nɩ le, ‑bati ꞊nʋ Nyɩsʋa diu lɛ poo, ɩ di ke nɩ 'klɩ, ɩ 'mʋ 'o ꞊ʋ ‑ye a ‑bati 'mʋ ‑hi.» ");
INSERT INTO ted_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","‑Tɛ ‑Yusu ‑wɔ 'pʋprɛ ‑wɔn, 'ke 'le Nyɩsʋa a 'kagblaka gbo, ‑ye ɔ nɩ gbo, 'ke 'o dokwliye ꞊nʋ 'hʋɩn 'mʋ, ‑ɛ kɔ wlɔn nahuiin 'le 'wli lɛ po, 'ke 'o Nyɩsʋa a ‑kʋan a ‑ta 'mʋ. ‑Ye ‑Yusu, ɔ nye 'nɩ 'ye, ‑tɛ nahuiin 'le 'wli a lɛpupue nu. Dokwliye a ‑gbɛ wlɔn, 'dai dɛkɔnyʋ, 'ʋʋ 'le 'wli 'plɔplɔ lɛ po. ");
INSERT INTO ted_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ɛ kɔ ‑wɛ ꞊sʋɛnyrɔ ꞊de. 'A tɔ 'kʋ la nɩ. Nɔ‑ nyre 'o, 'ɔ po 'le 'wliyɔkɔ a 'yɔɔ 'hɔn, ‑ɔ 'de 'le dɛ ꞊de a ‑tɩtɔ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","‑Tɛ ‑Yusu 'yo, ‑ye ɔ da 'a ‑naagbopʋ nɩ, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ke 'le Nyɩsʋa 'yi 'mʋ, ꞊sʋɛnyrɔ ‑gbo, ɔ po 'le 'wliyɛ, 'ɛ ‑hi 'o nahuin 'bii ‑gbo 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","‑ɛ nue, nahuin 'bii ‑gbo, 'wliyɛ, ‑ɛ 'de ‑kʋan kɔ, 'ke 'o ꞊nʋ ‑wɔn, nɛ‑ ʋ po 'le. Nyrʋgba ‑gbo, ɔ ‑mɛ ‑ye, ꞊hapʋkɔ, ꞊sʋɛ 'ɛ nyo nu, kɛɛ, 'wliyɛ 'bii, ɔ di wɛn nu, ɔ 'mʋ wɛn 'a dɩɔ ye ‑wɔn, nɛ‑ ɔ po 'le.» ");
INSERT INTO ted_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","‑Tɛ ‑Yusu ‑yrɛ 'klɛɛ, ‑ye ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ 'ba 'mʋ ye, 'ʋʋ 'le Nyɩsʋa a 'kagblaka gbo 'hrɩ. ‑Tɛ ʋʋ 'klɛɛ mu, ‑ye ‑Yusu a ‑naagbopʋyu ‑ye nɔ: «Tɔɔnyɔ o, 'ye kɛ, 'hɛ gblakɩ ‑gbo, ʋ nu, 'ʋ po Nyɩsʋa a 'kagblaka ‑gbo, ‑tɛ kayu a ‑gbɛ, ʋ nu 'yilɛnɩnɔ.» ");
INSERT INTO ted_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","‑Ye ‑Yusu nɔ: «Baa kayu ‑gbo, 'a 'yilɛnɩnɔ a ‑tɩ. Kɛɛ, kɔ 'a yiyie, 'yilɛnɔkayu ‑gbo, ‑nɩɩ 'klɛɛ 'ye, ʋ diu 'nɩ 'wla 'bii. 'A 'hɩɔ ꞊de 'deɛ bɔ nɩ 'o 'a 'be 'hɩɔ 'lu gbo.» ");
INSERT INTO ted_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ ꞊tɩ 'mʋ 'dɩɔ, 'ʋ mu 'le dʋgba ꞊nʋ 'lu, ‑ɔ kɔ 'lu ti nɩ 'le, ʋʋ olifie daa. Dʋgba a ‑gbɛ, ɔ 'bɛ Nyɩsʋa a 'kagblaka 'mʋ 'yi. ‑Tɛ ʋ nyre 'le, ‑ye ‑Yusu nɩ gbo. Piɛlɩ, kɔ Sakɩ, kɔ Saan, kɔ Adre 'hɛɛn, nʋ‑ mu 'o ꞊nɔ 'hʋɩn 'mʋ, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Le ‑a mʋ, ti tio‑ kɔ 'yri ʋ di 'o Nyɩsʋa a 'kagblaka ꞊nʋ 'wlaa 'le, kɔ, dɛ tio‑ ‑a di 'ye, ‑ɛ di 'lu ‑wɔn mue, 'plɩɩ ‑a 'mue yi, ‑ɛ mɔ, ‑tɩ 'bii ‑gbo, ‑n ꞊tu wɛn, ɩ di 'nɩ nue?» ");
INSERT INTO ted_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","‑Ye kɛ ‑Yusu nyu ye po: «Ba nɩ 'o ‑preelɛ 'mʋ, ‑ɛ die nu, ꞊ɔ ꞊de 'nɩ ꞊han 'a mʋ kaa, ");
INSERT INTO ted_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","‑ɛ nue, nahuin 'plɔplɔ di 'le di, 'ke 'le 'na 'dʋ 'kwli 'mʋ, ʋ 'mʋ lɛ po, nʋ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, 'plɩɩ ʋ 'mʋ 'dai nahuin kaa. ");
INSERT INTO ted_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","'Ya 'o lele 'lu, a di 'nɩ 'wɔn, ‑ɛ mɔ, ʋʋ ‑wɔn tʋ, 'ke 'le 'blʋgbɩ ꞊nʋ 'mʋ, ‑ɩ 'mʋɛɛ 'a mʋ ye, kɔ, ‑ɩ hren 'a mʋ ‑wɔn. 'Ba nyi 'wɔn, a nɩ pɩ 'le hʋannʋ, ‑ɛ nue, ‑tɔplɩ a ‑gbɛ, ɩ kɔ bɩ mue 'lu ‑wɔn. Kɛɛ, 'bɩɩ 'lu ‑wɔn mue, ɛ 'de 'nyrɛ ꞊hɛn, 'klɔ a 'o'mʋ‑hɔnti nyre 'o ꞊o. ");
INSERT INTO ted_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","'Blʋgbɩ di ye 'nɩ ‑wʋnwɔn. 'Ke 'le 'dai 'blʋgbɩ 'mʋ, ‑tʋtʋ di 'nɩ 'hɩhrɔ, kɔ kanʋ di 'nɩ ꞊tɩ. 'Kla‑wliye'yɩya a ‑gbɛ, ‑ɛ di 'le di, 'klɔ a 'o'mʋ‑hʋnhɔn, nɛ‑ kɔ ‑wlu꞊tutue'e nɩ. Kɛɛ ‑ye 'klɔ 'de wɛn 'o 'mʋ a ‑hʋɛn. Ɛ 'we ꞊nɔ nyrʋgba ye, ‑ɔ nɩ 'kwli 'mʋ, ‑tɛ 'kwli bɛ 'nɩnɩ ꞊tu wɛn 'a nunue ‑wlu, kɛɛ ‑ye 'a ‑ŋɩŋlati 'de wɛn 'o a nyree. ");
INSERT INTO ted_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‑Tɔplɩ a ‑gbɛ, 'bɩɩ 'lu ‑wɔn mue, ba nɩ 'o ‑preelɛ 'mʋ. Ʋ kɔ bʋ gba 'le 'a mʋ ‑batipoolɛ 'mʋ, kɔ, ʋ di 'a mʋ 'nɩ bi, 'ke 'le Nyɩsʋa a kayuo gbo. ‑Tɛ a 'ya 'na ‑naagbopʋ 'mʋ a ‑tɩ, ʋ di 'a mʋ yɛɛ ‑tɩ, 'ke 'o 'blʋgbanaanyʋ kɔ 'kɩɩnpʋ ye. Nɛ‑ die nu, a 'mʋ ꞊nʋ 'na ꞊hapʋtitie pue. ");
INSERT INTO ted_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ɛ blɛ ye 'na ‑naagbopʋ bʋ po 'na ꞊hapʋtitie a ‑gbɛ, 'ke 'o 'klɔ ‑gbo a dakʋ 'bii ye, 'plɩɩ 'klɔ a 'o'mʋ‑hɔnti 'mʋ 'o nyre. ");
INSERT INTO ted_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","'Bʋ klɩ 'a mʋ, 'ke ʋ 'mʋ 'le 'a mʋ ‑batiponyʋ ye gba, 'kla nɩ 'ya 'le 'a mʋ ‑wliye, 'ke 'o ‑tɩ ꞊nʋ, a di ꞊tu a ‑ta 'mʋ. Win ꞊nʋ, a di po ti a ‑gbɛ 'yri, Nyɩsʋa'a nɩ, ‑ɔ di 'a mʋ wlɔn ꞊tu. Ɛ 'de 'a nɩ ‑gbɛgbɛ, a 'nɩ 'prɛ ꞊le nɩ, kɛɛ, Nyɩsʋa a ‑Hihiu, ‑ʋ nɩ 'o 'a mʋ ke 'mʋ, nʋ‑ di 'prɛ. ");
INSERT INTO ted_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ti a ‑gbɛ 'yri, 'dɩayuopʋ di 'waa 'dɩayuo 'blʋgba a ye'mʋnaanyʋ kwa lɛ 'nɩ po, ‑ɛ die nu, ʋ 'mu lɛ 'lɩla. Dɛɛ ‑do a ‑gbɛ, nɛ‑ bunʋ di 'waa 'yuo ‑wɔn nu, 'yuo꞊pli 'mue ‑wɛ 'waa bunʋ kɔ 'waa 'diinʋ 'hɛɛn ‑wɔn nu. ");
INSERT INTO ted_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nahuin 'bii di 'a mʋ 'nɩ yraa, ‑ɛ nue, 'a mʋ mɔ 'na nahuiin nɩ. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ 'de sɩa, 'ke 'o Nyɩsʋa a ꞊wlʋ a yekuolɛ ‑wɔn, 'bɔ gbɛ ‑gbagba, 'klɔ a 'o'mʋ‑hɔnti 'bɩ nyre 'o, nɔ‑ Nyɩsʋa di waa.» ");
INSERT INTO ted_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Nahuon ‑gbo, ‑ɔɔ win ‑gbo ‑hre, ɔ blɛ ye bɔ kɔ ꞊tɔ, 'plɩɩ ɔ 'mui 'mʋ lɛ yrii. Win a ‑gbɛ, ɩ nɩ‑ ‑gbo: Ɛ di kɔ ti ‑ye, a 'mʋ 'yilɛnyredɛ ꞊de 'ye, 'ke 'le Nyɩsʋa a 'kagblaka gbo. 'Yilɛnyredɛ a ‑gbɛ, Nyɩsʋa a ꞊wlʋ yrɛɛ nɩ, 'plɩɩ dɛ a ‑gbɛ, ɛ nye 'nɩ nu, Nyɩsʋa 'ɔɔ 'a 'kagblaka ‑wɔn hren. 'Yilɛnyredɛ a ‑gbɛ, ‑tɛgbi ɛ 'de 'o kɔ, 'ke ɛ di 'o nɩ. 'Baa dɛ a ‑gbɛ 'ye, ‑ye nahuin ꞊nʋ, ‑ʋ nɩ 'le Sudeblʋgba 'mʋ, bʋ 'gba ci lɛ, bʋ mu 'le dʋgbɩ 'lu, ʋ 'nɩ ꞊hiun lɛ 'lɩla. ");
INSERT INTO ted_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nahuon 'bɔ nɩ 'le 'a kayu a ‑yaa 'mʋ, bɔ 'gba ci lɛ ‑dodo. Ɔ nɩ po 'le lɛ, bɔ pa 'le 'a kayu gbo, ɔ 'mʋ 'a kʋkɔ‑tɔplɩ bla, 'plɩɩ ɔ 'mʋ ci lɛ 'gba. ");
INSERT INTO ted_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nahuon 'bɔ nɩ 'le 'a ‑ci ke, bɔ 'gba ci lɛ ‑dodo. Ɔ nɩ po 'le ‑wɛ lɛ, bɔ ꞊hɩan ‑wɔn, bɔ bla 'a wlawlɩ, 'ke 'le 'dɩɔ 'mʋ, 'plɩɩ ɔ 'mʋ ci lɛ 'gba. ");
INSERT INTO ted_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ti a ‑gbɛ 'yri, nyrʋ ꞊nʋ, ‑ʋ di 'kwlii 'mʋ lɛ nɩ, kɔ 'waa dɛ ‑gbo, ‑ɛ di 'yuo 'nya, ɛ di 'ye ꞊sʋɛ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ba da Nyɩsʋa, ‑tɔplɩ a ‑gbɛ, ɩ 'nɩ ꞊han 'lu ‑wɔn mue, a 'nɩ ꞊han ci lɛ 'gba, ti ꞊nʋ ‑kɔ 'yri cɛɛ 'o ꞊tɩɩ, ");
INSERT INTO ted_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","‑ɛ nue, ‑nyrɔwɩ a ‑gbɛ 'mʋ, nahuin di 'ye ꞊sʋɛ 'dɔ, ɛ 'mʋ 'o ꞊sʋɛ 'bii ꞊nʋ 'mʋ ‑hi, nahuin ‑tʋa la 'le 'yiye gbo, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa nu la 'klɔ, ‑bo yɛ ꞊sʋɛ gblaka a ti a ‑gbɛ ke, ɛ 'mʋ ‑wɛ 'o ꞊sʋɛ ꞊nʋ 'mʋ ‑hi, nahuin di 'ye, kʋɛ 'le ti a ‑gbɛ 'yri gbo, ‑bo yɛ 'klɔ a 'o'mʋ‑hɔnti ke. ");
INSERT INTO ted_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nyɩsʋa di ‑nyrɔwɩ a gbɛ ꞊tɩɔ 'lu, 'ke 'o nahuin ꞊nʋ a ‑ta 'mʋ, ɔ ‑ha 'le du 'mʋ, 'ke bʋ 'ya 'a nahuin 'mʋ. Nɛ‑ 'de wɛn ꞊nɛ, nahuon ꞊de 'deɛ bɔ nɩ wɛn 'klɔ ti a ‑gbɛ 'yri. ");
INSERT INTO ted_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tii ‑do a ‑gbɛ 'yri, nahuon 'bɔ le 'a mʋ, 'bɔ plɛ: Ba 'ye kɛ, Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, kɛ ɔ nɩ mɔ, ‑hee' 'ke ɔ nɩ 'le ‑tɛgbi ꞊nʋ, a nɩ puo 'le ‑tɛɛ gbe, ");
INSERT INTO ted_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","‑ɛ nue, hɩwaanyʋ, kɔ hɩwinwlɔn‑hɛnyʋ di 'hrɩ, ʋ 'mʋ 'ŋmilɛka‑tɔplɩ a gblegblei nu, ‑ɛ die nu, 'bɛ ‑wɛ 'le, ʋ 'mʋ nahuin ꞊nʋ kaa, Nyɩsʋa ‑ha 'le du 'mʋ, 'ke bʋ ‑hɛ 'a nahuin. ");
INSERT INTO ted_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","'A ‑tɩ, a ‑mɛ ‑ye o, ba nɩ 'o ‑preelɛ 'mʋ, ‑ɛ nue, ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ di 'lu ‑wɔn mue, 'n le 'a mʋ nɩ ‑dodo.» ");
INSERT INTO ted_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«꞊Sʋɛ'yeti a ‑gbɛ 'bɩ ‑hi, ‑ye 'yrʋ kɔ ‑hɔpɔ 'hɛɛn, ɩ di 'nɩ jre, ");
INSERT INTO ted_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","yahroyɔ di 'le yakɔ 'mʋ lɛ 'nɩ ble, kɔ ‑tɔplɩ 'bii, ‑ɩ nɩ 'le yakɔ 'mʋ, ɩ di 'mʋ lɛ ‑hɔn ‑ta. ");
INSERT INTO ted_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tii ‑do a ‑gbɛ 'yri, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, nahuin di 'mʋ 'nɩ 'ye. 'N di 'le 'nɩ di, 'ke 'le 'na 'klɩ a kenɩnɩɛ 'kwli 'mʋ, kɔ 'ke 'le 'na ‑tɩ a 'yi'bʋaalɛ 'kwli 'mʋ. 'Bɩa 'nɩɩ 'le di, 'ke 'n di 'le 'nugbɩ ‑hɛyri nɩ. ");
INSERT INTO ted_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","'N di gbo tɛ Nyɩsʋa a lɛleenyʋ, ʋ 'mʋ 'klɔ ‑gbo a ꞊gɛi 'bii ye na, ʋ 'mʋ nahuin ꞊nʋ lɛ 'kukue, Nyɩsʋa ‑ha 'le du 'mʋ, 'ke bʋ ‑hɛ 'a nahuin.» ");
INSERT INTO ted_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Ba 'ye kɛ tugbɛ ꞊nʋ, ʋʋ figie daa. 'Ke 'o tugbɛ a ‑gbɛ 'yie 'mʋ, tɔɔlɛ nɩ 'o. Ɛ nɛ‑ mɔ, ti ꞊nʋ ‑kɔ 'yri ɛɛ 'o babʋɩ yrayrɩ lɛ ꞊tuu, kɔ, 'a hai 'bɩɩ ꞊ga, ‑ye ‑a yie nɩ, ‑ɛ mɔ, ‑cii‑ci‑nyrɛ 'mʋɛɛ yrɛ. Kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'ke 'o 'na 'ledidie a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","‑Tɔplɩ 'bii ‑gbo, ‑ɩ kɔ ‑tɩ 'n ꞊tu wɛn, 'bɩɩ 'lu ‑wɔn mue, ‑ye ba kɔ 'a yiyie, ‑ɛ mɔ, 'na 'lediti 'mʋɛɛ yrɛ. Ɛ 'we ꞊nɔ ye, 'ke 'n nɩ 'o 'maju 'yri. ");
INSERT INTO ted_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, dakʋ ‑gbo, ʋ 'deɛ bʋ 'kʋ, ‑tɔplɩ 'bii a ‑gbɛ, ɩ 'mʋ 'o nyre. ");
INSERT INTO ted_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Yakɔ kɔ ‑tʋtʋ 'hɛɛn, ɩ di gbo 'nɩ ‑wɛ, kɛɛ, 'na wintɛ, ɛ 'deɛ bɛ ‑wɛ gbo gbe.» ");
INSERT INTO ted_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «Ti ꞊nʋ ‑kɔ 'yri 'lelɛ'bɔɔ‑nyrɔwɔ di 'o nyre, ɛ 'de nahuon kɔ, ‑bɔ yi ti a ‑gbɛ. Mɔ, 'mɔ, Nyɩsʋa a 'Yu, 'n kɔ Nyɩsʋa a lɛleenyʋ 'hɛɛn, ꞊ɔ ꞊de 'de 'o nɩ, ‑ɔ yi ‑nyrɔwɔ a ‑gbɛ, 'bɛ 'de ‑a nɩ Bu Nyɩsʋaa ‑do. ");
INSERT INTO ted_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ba nɩ 'o ‑preelɛ 'mʋ, a nɩ ŋmo 'le, ‑ɛ nue, a 'de 'lelɛ'bɔɔ‑nyrɔwɔ a ti yi. ");
INSERT INTO ted_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","'Na mumue kɔ 'na 'ledidie lele, ɩ di ye 'we nyɩbɛyu ꞊de, ‑ɔɔ la 'dagba 'mʋ mu. Nɔ‑ hie la 'a kayu 'a ‑kʋannunyʋ lɛ. 'Plɩɩ ɔ 'mʋ la mu mu, ɔ wo la ‑kʋan nɩ. 'Ɛ nɩ ‑kʋannunyɔ 'bɔ nɩ 'o, ɔ yi la 'a nɩ ‑kʋandɛ nɩ, ɔ di la nu. ‑Ye kɛ ɔɔ la 'a kayu'yie꞊tunyɔ ye po, ɔ nɔ: ꞊Tu kayu 'yie, ꞊nɩ ŋmo 'le. ");
INSERT INTO ted_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","'A ‑tɩ o, ba nɩ 'o ‑preelɛ 'mʋ, a nɩ ŋmo 'le, ‑ɛ nue, ti ‑kɔ 'yri kayukɔnyɔ di 'dagba 'mʋ ‑hɔn, a 'di yi. ‑Tado ‑wise'e nɩ, ‑hee' 'tɔ‑hɛyri 'mʋ, ‑hee' mu 'o ‑nyrɛ a 'yrilɛcɛti 'yri, ‑hee' ‑nyrajru 'mʋ, 'ke ɔ di nyre. A 'de 'a dɛ ꞊de yi. ");
INSERT INTO ted_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","'Bɔ ꞊hɩan ‑wɔn tii ‑do a ti 'yri, ɛ 'de ye blɛ, bɔ yɛ 'o 'a mʋ ŋmlaŋmoolɛ 'mʋ gbo. ");
INSERT INTO ted_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nɩ‑ mɔ ‑tɩ 'n ‑hʋa ꞊bo ꞊tu wɛn 'a mʋ ye, a kɔ nahuin 'bii 'hɛɛn: Ba nɩ 'o ‑preelɛ 'mʋ, a nɩ ŋmo 'le.» ");
INSERT INTO ted_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ɛ hie 'le ‑nyrɔwɩɩ 'hɔn, 'plɩɩ ‑Juukʋɛ a lɛ'mimre gblaka ‑ye 'mʋ 'o nyre. Lɛ'mimre a ‑gbɛ, 'a 'dʋ mɔ Pakɩ. Pakɩ a ‑gbɛ a ti 'yri, 'flɔɔdʋ ꞊nʋ, ‑ɔ kɔ ‑wɔn ʋ 'nɩnɩ po 'le 'yaadɛ, nʋ‑ ʋʋ la di. ‑Ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ teteitɔɔnyʋ 'hɛɛn, ʋʋ lɛ ꞊mɔ ꞊tɔ, ʋ 'mʋ ‑Yusu klɩ, 'ke 'le gblagblʋ 'kwli 'mʋ, ‑ɛ die nu, ʋ 'muo 'la. ");
INSERT INTO ted_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kɛ ʋʋ po, ʋ nɔ: «'Bɩa ꞊ba nyo klɩ, ‑a 'die 'le ‑wɛ ‑ba nue lɛ'mimre a ti 'yri, ‑ɛ die nu, nahuin 'nɩ ꞊han ‑a mʋ ‑wɔn di ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ti a ‑gbɛ 'yri, 'ke ‑Yusu nɩ 'le Betanidɩɔ 'mʋ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. 'Ke ʋ nɩ 'le Simɔ a ‑tɛ. Simɔ a ‑gbɛ, ‑tɔplɩ ‑jɔhʋɩn nuo la. Bʋʋ 'klɛɛ dɛ di, ‑ye nyrʋgba ꞊de, nɔ‑ pa kayu gbo, 'ɔ 'ble ‑dawinniyrɩɛ kwa. ‑Dawinni a ‑gbɛ, ɩ kɔ 'a 'yrɩɛ 'hɛɛn, ɩɩ po ꞊die 'dɔ. ‑Tɛ ɔ pa 'klɛɛ, ‑ye ɔ 'bɛ 'o 'yrɩɛ a 'lu nɩ, 'plɩɩ ‑dawinni a ‑gbɛ, 'ɔ 'wlɩɩ 'o ‑Yusu 'lu. ");
INSERT INTO ted_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nahuin ‑nɩ 'o, 'waa dɛ ‑ye, 'waa plɔ 'de ble, ʋ nɔ: «Dɛ‑ kɔ ‑dawinni a ‑gbɛ a 'mʋlɛcɩcralɛ 'le? ");
INSERT INTO ted_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","'Bʋ pli wɛn, ɩ di wɛn 'ye 'wliyɛ 'dɔ, ‑ɛ ‑wɛ 'le ‑kʋannunyɔ ‑ye a 'pɛɛwli, 'ke 'le 'yrʋ꞊gble 'kwli 'mʋ, ʋ 'mui wɛn ꞊sʋɛnyʋ ‑nyi.» Kɛ'ɛ nɩ, ɛ ‑ti 'mʋ, 'ʋʋ nyrʋgba a ‑gbɛ 'nyrɛ ꞊hɛn. ");
INSERT INTO ted_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Kɛɛ, ‑Yusu nɔ: «Ba ‑hɩɔ mɛ lɛ, ba 'kee 'a 'nyrɛ꞊hɩnhɩɛn! Dɛ ‑gbo, ɔ nu, 'ke 'o 'mʋ ‑wɔn, ɛ mɔ 'yilɛnɔdɛ'ɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ba kɔ 'a yiyie, ꞊sʋɛnyʋ 'kɩɛ die nɔ 'a mʋ ‑gbahlɔn nɩ. Ti ‑kɔ 'yri a die 'o ‑hʋa, a ‑wɛ 'le ba nu ꞊nʋ ꞊hapʋdɛ 'mʋ nɩ. Kɛɛ, 'mɛ ‑ye, ti 'n di nɔ 'a mʋ ‑gbahlɔn ‑hi, ɩ 'de 'klɛɛ lele ‑huo. ");
INSERT INTO ted_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dɛ nyrʋgba ‑gbo, ɔ ‑wɛ 'le, nɛ‑ ɔ nu: ɛ nɩ ke 'mʋ, 'ɔ 'wlaa 'na ‑plahʋɩn ‑dawinni klɛ, 'ke 'o 'na ‑plahʋɩn a ‑gbɛ a 'o‑hɩhɩa a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ɛ nɩ ‑tɛgbi, ʋ di 'o Nyɩsʋa a ꞊hapʋtitie 'o poo, kɛ nɔ ‑tʋtʋ ke, ꞊hapʋdɛ ‑gbo, nyrʋgba ‑gbo, ɔ nu, ʋ di 'a ‑tɩ ‑wɔn lɛ 'nɩ na, ‑ɛ die nu, ɩ 'nɩ ꞊han nahuin ‑wɔn ‑hri.» Kɛ ‑Yusu po. ");
INSERT INTO ted_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye Judɩa Yisikalio, ‑ɔ mɔ ‑Yusu a ‑naagbopʋyu ‑ye, 'ke 'le 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ ‑gbahlɔn, nɔ‑ mu 'le Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ ‑wɔn, 'ɔ mu la 'ye wɔn, ‑tɛ ɔ di ꞊nʋ ‑Yusu a kwapupue nu a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","‑Tɛ ɔ ‑ha 'le kuna, ‑ye ʋʋ nu 'manʋ 'dɔ, ʋ nɔ: «‑A di ‑mʋ ‑nyi 'wliyɛ.» Kʋɛ 'o ti a ‑gbɛ 'yri gbo, Judɩa, ɔɔ lɛ ꞊mɔ ꞊hapʋ꞊tɔ, ‑tɛ ɔ di nu, ɔ 'mʋ ꞊nʋ ‑Yusu kwa po. ");
INSERT INTO ted_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lɛ'mimre ꞊nʋ, ‑ɛ mɔ Pakɩ, 'a ye‑hɛ‑nyrɔwɔ 'mʋ, 'ke ʋʋ 'o 'flɔɔdʋ ꞊nʋ dii, ‑ɔ kɔ ‑wɔn ʋ 'nɩnɩ po 'le 'yaadɛ, 'ʋʋ ‑wɛ 'o 'blayuo 'laa, 'ke 'o dididɛ gblaka a ‑ta 'mʋ. ‑Tɛ ‑nyrɔwɔ a ‑gbɛ, ɔ nyre 'o, ‑ye ‑Yusu a ‑naagbopʋ ꞊gba ‑Yusu wlɔn, ʋ nɔ: «‑Be' ‑nɩɩ ‑hʋa ‑ba pii 'klɛɛ Pakɩ a dididɛ ye 'le?» ");
INSERT INTO ted_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","‑Ye ɔ le 'a ‑naagbopʋʋ 'hɔn ‑ye, ɔ nɔ: «Ba mu 'le Jrusrɛdɩɔ 'mʋ. A kɔ nahuon ꞊de 'hɛɛn, 'a mʋ di ꞊ŋmoo. Nahuon a ‑gbɛ, ɔ 'ble 'nɩya. Nɔ‑ ba kʋɛ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kayu ꞊nʋ, ‑ʋ kɔ gbo ɔ di 'le pa, ba le kayu a ‑gbɛ a kʋkɔnyɔ, ‑ɛ mɔ: ‑A nɩ Tɔɔnyɔɔ wlɔn 'nɩ ꞊gba: ‑Be' ‑gblo nɩ ye, ‑ɔ kɔ 'mʋ ɔ di 'le Pakɩ a dididɛ 'le dii, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn? ");
INSERT INTO ted_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","‑Ye ɔ di 'a mʋ tɔɔ ‑gblo gblaka, 'ke 'le 'a yrayrɩkayu a ‑gbɛ a ye‑hɛ‑gbɔ 'mʋ. 'Ke kayu a ‑tɔplɩ 'bii ꞊cɛɛ 'le. 'Kee nɩ, ba pii 'le ‑a nɩ dididɛ,» ");
INSERT INTO ted_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","‑naagbopʋʋ 'hɔn a ‑gbɛ 'ʋ mu 'le Jrusrɛ 'mʋ. 'Plɩɩ ʋ 'mʋ 'le mu nyre, ‑ye 'ɛ mɔ ‑tɛɛ, ‑tɛ ‑Yusu nu 'a ꞊tutue, kɛ'ɛ nɩ, ʋ nu 'o ‑tɔplɩ a ‑gbɛ a 'ogboyɩyɛ. ‑Ye ʋ pi Pakɩ a dididɛ a ‑gbɛ nɩ. ‑Tɛ ʋ ‑wɔ 'a pipie ‑wɔn, ‑ye ʋ ‑mɛ de. ");
INSERT INTO ted_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","‑Tɛ 'yrʋ ‑wɛ 'le yakɔ 'mʋ lɛ, ‑ye ‑Yusu kɔ 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ 'hɛɛn, ʋ nyre 'le kayu ꞊nʋ gbo nɩ, ‑ʋ kɔ gbo ʋ di 'le Pakɩ a dididɛ dii, 'ʋ ‑tʋa dɛ a didie gbo. ");
INSERT INTO ted_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Bʋʋ 'klɛɛ dɛ di, ‑ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon nɩ nɔ 'a mʋ ‑hɛyri, ‑ɔ kɔ 'mʋ 'hɛɛn‑ dɛ di. Nɔ‑ di 'mʋ 'na yraanyʋ kwa po, ‑ʋʋ 'na 'lɩla lɛ ꞊mɔ.» ");
INSERT INTO ted_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Bʋ 'wɔn ‑tɩ ꞊nʋ, ‑Yusu ꞊tu, ‑ye 'waa ꞊wlɩ 'mʋɛ gbo, 'ʋʋ ‑dodo po, 'ʋʋ ‑Yusu wlɔn lɛ ꞊gba: «꞊Be 'mɔɔ nɩ?» ");
INSERT INTO ted_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Ke 'le 'a mʋ ‑hɛyri, ‑ʋ mɔ 'na ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn, 'ke nahuon nɩ 'le, ‑ɔ kɔ 'mʋ 'hɛɛn‑ 'le dɛdihuoo ‑do wlɔn dabʋ 'nyra. Nɔ‑ɔ nɩ, ‑ɔ die nu. ");
INSERT INTO ted_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","'Ɛ mɔ ‑tɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n kɔ ꞊bo 'kʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ʋ nu la 'a 'crɩɩlɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, kɛɛ, 'jrɔ 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ di 'mʋ 'na yraanyʋ a ‑gbɛ kwa po. Ɛ nɔɔ 'o lɛ, 'ke ʋ nɩ kɔ 'le wɛn nahuon a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Bʋ 'kɩɛ nɩɛ 'o dɛdihuo ke, ‑ye ‑Yusu 'ba 'mʋ 'flɔɔ, 'ɔ ‑nyi Nyɩsʋa 'wio, 'plɩɩ 'ɔ 'bɩɔ ꞊tɩɔ lɛ, 'ɔ ‑nyo 'a ‑naagbopʋ, ɔ nɔ: «Ba 'bɔ 'mʋ, ba dio. Nɔ‑ mɔ 'na 'hʋɩn.» ");
INSERT INTO ted_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","‑Ye ɔ 'ba lele 'mʋ ‑wiin‑gaʋwɔ, 'ɔ ‑nyi Nyɩsʋa 'wio, 'ɔ ‑nyo ꞊nʋ, ʋ 'bii 'ʋ 'na. ");
INSERT INTO ted_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","‑Ye ɔ nɔ: «Nɩ‑ mɔ 'na dablo. Nɔ‑ 'n di gbo 'wla, 'ke 'o nahuin 'plɔplɔ a ‑ta 'mʋ, Nyɩsʋa 'muo nu, ɔ 'mʋ 'yrɩ yrayrɩ ꞊tue, ɔ kɔ ‑tʋnahuin 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, kʋɛ 'klɛɛ mɔ gbo, 'n 'deɛ ꞊bo 'na 'klɛɛ lele nɔdʋ ‑gbo, ɛ 'mue gba ‑gbagba, ‑nyrɔwɔ ꞊nʋ, ɔ 'mʋ 'o nyre, ‑ɔ kɔ 'kwli 'mʋ 'n di 'o lele nɔ yrayrɩdʋ ‑ye ꞊nʋ 'naa, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ʋ bre ‑wla, 'plɩɩ 'ʋ 'ba ye 'mʋ, 'ʋ ꞊tɩ 'dɩɔ 'mʋ, 'ʋʋ 'le dʋgba ꞊nʋ 'lu mu, ‑tɛ ti nɩ 'le, ʋʋ olifie daa. ");
INSERT INTO ted_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","‑Tɛ ʋ nyre 'le, ‑ye kɛ ‑Yusuu 'a ‑naagbopʋ ye po, ɔ nɔ: «Ti di 'o 'nɩ nyre, a 'mʋ 'mʋ 'hʋɩn 'mʋ lɛ ‑gbɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ʋ nu la 'a 'crɩɩlɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Nyɩsʋa nɔ 'nɩ: 'N di 'blakɔnyɔ 'nɩ 'la, blablɔ 'mʋ lɛ ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","‑Ye kɛ ‑Yusu nyu lele ye po, ɔ nɔ: «'Bɩa 'nɩ 'kʋ, 'nɩ 'hrɩ lele 'klɔ, 'ke 'n di 'le Galileblʋgba 'mʋ mu, 'mʋ 'le 'a mʋ ‑pree.» ");
INSERT INTO ted_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","‑Ye Piɛlɩ nɔ: «꞊Betɩ ʋ 'bii bʋ hie 'o ‑mʋ gbo, 'na ‑gbɛ, 'n 'die 'le ‑wɛ ꞊bo hie 'o ‑mʋ gbo gbe.» ");
INSERT INTO ted_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","‑Ye ‑Yusu nɔ: «'Nɩɩ ‑mʋ 'nɩ le ‑tɛɛ, 'tɔyrʋwɔɔ ‑do ‑gbo 'kwli 'mʋ, 'plɩɩ hapɛ 'mʋ ‑nyrɛ a dawɩɩ 'hɔn mu nu, ‑n di nu 'na ‑wɔn‑gaawɩɩ ta, ‑ɛ mɔ, ‑n 'de 'mʋ yi.» ");
INSERT INTO ted_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","‑Ye Piɛlɩ 'yaa 'le win, 'ɔ ꞊tuo ‑wɔn, ɔ nɔ: «'Ʋʋn, ꞊betɩ ꞊bo di 'kʋ, 'n kɔ ‑mʋ 'hɛɛn, 'n 'die 'le ‑wɛ ꞊bo ꞊tui, ‑ɛ mɔ, 'n 'de ‑mʋ yi.» ‑Ye ʋ 'bii, ‑tɩɩ ‑do ꞊nʋ, Piɛlɩ ꞊tu, nɩ‑ ʋ ꞊tu ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ʋ nyre 'le 'dɩdɔti a ‑ci ꞊nʋ ke nɩ, ʋʋ Gɛsɩmanɩ daa. ‑Ye kɛ ‑Yusuu 'klɛɛ 'a ‑naagbopʋ ye po, ɔ nɔ: «Ba nɩ mɔ gbo, ꞊bo mu 'le ye 'mʋ, 'mʋ 'le Nyɩsʋa ‑wɔn 'prɛɛ.» ");
INSERT INTO ted_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","‑Tɛ ɔɔ 'klɛɛ mu, ‑ye Piɛlɩ kɔ Sakɩ kɔ Saan 'hɛɛn, nʋ‑ ɔ da, ɔ kɔ ꞊nʋ 'hɛɛn 'ʋ mu. ‑Ye tii ‑do a ti 'yri, hʋannʋ nyo nu 'dɔ, 'a ꞊wlʋ 'ʋ 'mʋɛ gbo. ");
INSERT INTO ted_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","‑Ye kɛ ɔɔ ꞊nʋ ye po: «'Na ꞊wlʋ 'mʋɛ gbo 'dɔ. 'Na ꞊wlʋ a gbo'mʋmʋɛ a ‑gbɛ, ɛɛ ‑hʋa bɛ 'la 'mʋ. Ba nɩ mɔ gbo, a nɩ ŋmo 'le,» ");
INSERT INTO ted_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","'ɔ hren ꞊nʋ ‑wɔn dɛ gbi, 'ɔ bla kwlɩ gbo, 'ɔɔ Nyɩsʋa lɛ 'batɩ, 'bɩa 'bɛ ‑wɛ 'le, 'ke 'a ꞊sʋɛ'yeti ꞊nʋ, ‑ɩ di 'le di, bɩ hren ꞊nɔ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ɔ nɔ: «'Na Bu o, ‑n ‑wɛ 'le 'ɛ nɩ dɛ nɩ. Nue, 'ke ꞊sʋɛ ‑gbo, 'n kɔ ꞊bo 'ye, bɛ hren 'mʋ ‑wɔn. Kɛɛ, ɛ 'de dɛ ‑gbo, 'nɩɩ ‑hʋa, kɛɛ dɛ ꞊nʋ, ‑nɩɩ ‑hʋa, nɛ‑ bɛ 'ya.» ");
INSERT INTO ted_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bɔ nu lɛ 'pʋprɛ, ‑ye ɔ ꞊hɩan ‑wɔn, 'ɔ mu 'o 'a ‑naagbopʋʋ ta ꞊nʋ 'hʋɩn 'mʋ, 'ɔ yʋ 'o ŋmla a ŋmoolɛ 'mʋ gbo. ‑Ye kɛ ɔɔ Piɛlɩ ye po: «Simɔ, ‑nɩɩ 'nɩ ŋmo? ꞊Be ‑n 'die 'le ‑wɛ ‑bo nu ‑haawɔɔ ‑do, 'ke ‑bo 'de ŋmo? ");
INSERT INTO ted_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","A nɩ ŋmo 'le, kɛɛ, ba da Nyɩsʋa, ‑ɛ die nu, dɛ 'bɛ nyre 'o, 'bɛɛ 'a mʋ 'mʋ lɛ ꞊tɔ, 'ke ba ‑haa Nyɩsʋa a ‑tɩ lɛ, a 'nɩ ꞊han 'a ‑tɩ lɛ ‑haa. 'N yie nɩ, ‑ɛ mɔ, 'a nɩ ꞊wlɩ nye 'nɩ ‑hʋa 'dɔ, 'ke a nɩ ŋmo 'le, a 'mʋ Nyɩsʋa da, kɛɛ, 'bɩa 'nɩnɩ ‑hɛ 'a mʋ 'mʋ, a 'de 'klɩ kɔ, 'ke ba nu dɛ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Bɔ po 'klɛɛ lɛ, ‑ye ɔ hren lele ꞊nʋ ‑wɔn, 'ɔɔ lele Nyɩsʋa lɛ 'batɩ, 'ke 'le wiin ‑do ꞊nʋ 'kwli 'mʋ, ɔ po wɛn. ");
INSERT INTO ted_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","‑Tɛ ɔ ‑wɛ lele ‑wɔn, ‑ye 'ke ɔ mu 'o lele ꞊nʋ 'hʋɩn 'mʋ, 'ɔ yʋ 'o lele ŋmlaŋmoolɛ 'mʋ gbo, ‑ɛ nue, ʋ 'die 'le ‑wɛ, bʋ po 'yii lɛ. ‑Tɛ ʋ ꞊wlɛɛ 'yii, ‑ye ‑tɩ bʋ di ꞊nɔ 'yri ‑wɔn ꞊tuu, ʋ 'di yi. ");
INSERT INTO ted_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","‑Ye ɔ mu lele nɩ, 'plɩɩ 'ɔ ꞊hɩan lele ‑wɔn, gblo a ta a nɔnɔ, ɔ nɔ: «꞊Be aa lele 'nɩ ŋmo, 'aa 'le ke lɛ ‑ha? Ɛ 'de 'klɛɛ lele ŋmuŋmoti. Ba 'ye kɛ, ti nyre 'o ꞊o, 'ke bʋ po 'mʋ dɛ'kukununyʋ kwa, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon. ");
INSERT INTO ted_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ba 'ba ye 'mʋ, ‑a 'mʋ mu, ‑ɛ nue, nahuon ꞊nʋ, ‑ɔ di 'mʋ 'na yraanyʋ kwa po, ɔɔ 'le 'nɩ di.» ");
INSERT INTO ted_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Win nɩ 'le ‑Yusu wlɔn, ‑ye Judɩa, ‑ɔ mɔ ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn a nahuon ‑ye, ɔ nyre 'o ꞊o, ɔ kɔ nahuin 'plɔplɔ 'hɛɛn. Nahuin a ‑gbɛ, ʋ 'ble kwa lɛ ta‑wɔnpliei kɔ ti 'hɛɛn. Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ teteitɔɔnyʋ, kɔ ‑Juukʋɛ a ye'mʋnaanyʋ ‑ye 'hɛɛn, nʋ‑ le nahuin a ‑gbɛ, 'ke bʋ mu ‑Yusu klɩ. ");
INSERT INTO ted_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judɩa, ‑ɔ di ꞊nʋ ‑Yusu kwa po, 'plɩɩ ɔ kɔ ꞊nʋ 'hɛɛn, ʋ 'mʋ 'hru wlɔn mu bi, kɛ ɔ po ꞊nʋ ye: «Nahuon ꞊nʋ, 'n di 'mʋ 'wlɛɛ, 'ke 'o 'a 'wio a gbopupue ‑wɔn, nɔ‑ ba klɩ, ɔ 'nɩ ꞊han 'a mʋ kwa ꞊ta, a 'muo gba.» ");
INSERT INTO ted_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","‑Tɛ ʋ nyre 'klɛɛ 'o, ‑ye Judɩa a ‑gbɛ, ɔ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, ɔ nɔ: «Tɔɔnyɔ o,» 'ɔ 'wlɔɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","‑Ye tii ‑do a ti 'yri, nahuin ꞊nʋ, Judɩa gba, ʋ klɩ ‑Yusu nɩ. ");
INSERT INTO ted_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑kʋannunyɔ ‑ye, nɔ‑ nɩ ‑wɛ 'o ‑tuo ke. ‑Ye ‑Yusu a ‑naagbopʋyu ‑ye, nɔ‑ ‑ha 'le 'a 'plie bɔ wlɔn, 'ɔ 'bɛ ‑kʋannunyɔ a ‑gbɛ nʋa 'lu. ");
INSERT INTO ted_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","‑Ye kɛ ‑Yusuu ꞊nʋ ye po: «Ta‑wɔnpliei kɔ ti 'hɛɛn, nɩ‑ a nu, 'a di 'mʋ klɩ wɔn, ‑tɛ ʋʋ nu, 'ʋʋ ‑balʋnyɔ klɩ. ");
INSERT INTO ted_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","'Ɛ nɩ ti, 'ke 'n nɩ o 'le 'a mʋ ‑hɛyri, 'nɩɩ o 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ tɔɔ, kɛɛ, a 'de o 'mʋ a klee. Kɛɛ, dɛ ‑gbo, ɛɛ ‑wɔn mue 'lu, ‑ɛ die nu, ‑tɩ ꞊nʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɩ 'mʋ nue.» ");
INSERT INTO ted_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","‑Tɛ ‑Yusu po 'klɛɛ lɛ, ‑ye 'a ‑naagbopʋ 'bii, ʋ ‑gbɛ ꞊nɔ 'mʋ lɛ 'hʋɩn, 'ʋ 'gba ci lɛ. ");
INSERT INTO ted_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kɛɛ, ɛ kɔ gblotayu ꞊de, nɔ‑ɔ ‑Yusu ‑wɔn kʋɛ. Gblotayu a ‑gbɛ, ɔ 'wlɛɛ klɛ danʋʋ ‑do. ‑Ye ʋ klo nɩ. ");
INSERT INTO ted_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Kɛɛ ‑ye 'ke ɔ hie 'le ꞊nʋ danʋ a ‑gbɛ kwa 'mʋ gbo, 'ɔ ꞊ga 'hʋɩn wlɔn, 'ɔ 'gba ‑wɛ ci lɛ. ");
INSERT INTO ted_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ʋ gba ‑Yusu nɩ, 'ke 'le Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka a kayu gbo. 'Ke 'le kayu a ‑gbɛ gbo, 'ke ‑cɔhlʋnpinyʋ gblakɩ a pɛpɛ, kɔ Nyɩsʋa a teteitɔɔnyʋ, kɔ 'blʋgba a ye'mʋnaanyʋ ‑ye 'hɛɛn, 'ke ʋ 'bii, ʋ ‑wɛ 'le ti ke, 'ke 'o ‑gboligbo a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛlɩ ‑mɛ ‑ye, nɔ‑ɔ ‑Yusu ‑wɔn kʋɛ, 'ke 'le ‑wɔnhinhrenkɔ 'kwli 'mʋ, 'ɔ pa ‑wɛ 'le ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑yaa 'mʋ. Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ nɩ ‑wɛ 'le, 'ʋ 'tie na, 'ʋ nyo 'wɛn. Nʋ‑ kɔ ‑hɛyri Piɛlɩ nɩ 'le gbo, 'ɔɔ ‑wɛ na 'wɛn. ");
INSERT INTO ted_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","'Ke 'le kayu gbo, ‑cɔhlʋnpinyʋ gblakɩ kɔ ‑gboligbo a nahuin 'bii 'hɛɛn, ʋ nye lɛ 'nɩ ꞊mɔ, 'ke bʋ yɛɛ ‑Yusu ‑tɩ, ‑ɛ die nu, ʋ 'muo 'la, kɛɛ, ʋ 'de 'le ꞊nɔ kɩkadɛ ꞊de 'mʋ 'yee. ");
INSERT INTO ted_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Nahuin 'plɔplɔ, nʋ‑ʋ hɩ‑hɛhɩdɛ nu, 'ke 'o ꞊nɔ ke. Kɛɛ, 'waa 'pʋprɛwin 'de dɛɛ ‑do. ");
INSERT INTO ted_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kɛɛ ‑ye nahuin ‑ye 'ba 'mʋ ye, 'ʋ nyo ‑tɩ yɛɛ, 'ke 'le hɩkɔ 'kwli 'mʋ, ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«‑A nɩ ‑gbɛ, ‑a 'wɩn o nɩ, ‑tɛ ɔɔ o lɛ po, ‑ɛ mɔ, Nyɩsʋa a 'kagblaka ‑gbo, ‑tʋnahuin po, ɔ dio 'nɩ 'wla, 'plɩɩ, 'ke 'le ‑nyrɔwɩɩ ta 'kwli 'mʋ, ɔ di po 'a dɛ ‑ye, ‑tʋnahuin 'de 'o dabʋɩ 'hʋɩn 'mʋ gba.» ");
INSERT INTO ted_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kɛɛ, 'ke 'o ‑tɩ a ‑gbɛ a ‑ta 'mʋ, 'waa 'pʋprɛwin 'de lele dɛɛ ‑do. ");
INSERT INTO ted_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","‑Ye ‑cɔhlʋnpinyʋ a nyɩgblaka 'ba 'mʋ ye, 'ke 'o nahuin 'bii ye, 'ɔ ꞊gba ‑Yusu wlɔn, ɔ nɔ: «꞊Be ‑tɩ 'bii ‑gbo, nahuin ‑gbo, ʋʋ ‑mʋ yɛɛ, ‑n 'de ‑tɩ ꞊de kɔ, ‑bo di ‑wɔn ꞊tu?» ");
INSERT INTO ted_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kɛɛ ‑ye ‑Yusu 'de ꞊nɔ ‑tɩ ꞊de klɛ ‑hɩhɩa. ‑Ye ‑cɔhlʋnpinyʋ a nyɩgblaka ꞊gbɔ lele wlɔn, ɔ nɔ: «꞊Be ‑mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya? ꞊Be ‑mɔ mɔ ‑wɛ Nyɩsʋa a 'Yuu nɩ?» ");
INSERT INTO ted_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","‑Ye ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Iin, 'mɔɔ nɩ. A di 'mʋ 'nɩ 'ye, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mʋ 'o 'Klɩkenɩnyɩsʋa a diidɛpɩa ke gbo nɩ, 'mʋ 'le yakɔ 'mʋ ‑hɔn, 'ke 'le 'nugbɩ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","‑Tɛ ‑Yusu po 'klɛɛ lɛ, ‑ye ‑cɔhlʋnpinyʋ a nyɩgblaka cɩcra 'a ‑gbɛ a wlawlʋ lɛ, ‑ɛ nue, ɔɔ po yrʋ 'dɔ, ɔ nɔ: «‑A 'nɩ ꞊mɔ 'le 'klɛɛ lele ‑hɛhɩnyɔ ꞊de lɛ, ");
INSERT INTO ted_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","‑ɛ nue, 'a nɩ ‑gbɛ, a 'wɔn ‑tɩ ‑gbo, ɔ ꞊tu nɩ. A 'wɩn nɩ, ‑tɛ ɔ nu Nyɩsʋa a ‑tɩ a lɛ‑haalɛ. ‑Be' aa 'klɛɛ po 'le?» ‑Ye ʋ 'bii, ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, ɔ ‑haa Nyɩsʋa a ‑tɩ lɛ. 'A ‑tɩ, ɔ nɩ 'mʋ 'kʋkʋɛ.» ");
INSERT INTO ted_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","‑Ye ꞊ʋ ‑ye, ʋ ‑tʋa 'a hɩɔn a 'hinhren gbo, kɔ, 'ʋ mʋɔ 'yi klɛ, 'ʋ nyo ŋmli bii, ʋ nɔ: «Winwlɔn‑hɛnyɔ o, le ‑a mʋ, nahuon tio‑ ꞊tu ‑mʋ dɛ 'le?» kɔ, Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ ꞊nʋ, 'ʋ nyo ‑wɛ 'le 'ŋmɩ nʋɩ 'mʋ lɛ po. ");
INSERT INTO ted_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","‑Tɛ ‑tɔplɩ a ‑gbɛ, ɩɩ 'lu ‑wɔn mue, ‑ye 'ke Piɛlɩ 'kɩɛ nɩɛ 'le ‑yaa 'mʋ. ‑Ye 'yu nyrɔyu ꞊de, ‑ɔɔ 'le ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑tɛ ‑kʋan nuu, nɔ‑ nyre 'o, 'ɔ 'ye Piɛlɩ, ‑ɔɔ na 'wɛn. ");
INSERT INTO ted_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Bɔ 'yo 'klɛɛ, ‑ye ɔ nyo 'mʋ ‑hrʋ 'yie, ɔ nɔ: «‑Mɔ ‑gbo, ‑n kɔ Nasalɛtɩ 'mʋ a ‑Yusu 'hɛɛn, 'a mʋ‑ʋ o 'hʋɩn 'mʋ nɩna.» ");
INSERT INTO ted_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kɛɛ ‑ye Piɛlɩ ‑ga nɩ, ɔ nɔ: «‑Tɩ ‑nɩɩ ꞊tu, 'nɩ 'wɩn ꞊le, kɔ 'nɩ yrii ꞊le 'mʋ lɛ,» 'ɔ ‑hʋɔn 'o 'hʋɩn 'mʋ, 'ɔ mu 'le ‑yaa a ‑gbɛ a paalɛ 'mʋ. Tii ‑do a ‑gbɛ 'yri, ‑ye hapɛ da ‑nyrɛ. ");
INSERT INTO ted_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kɛɛ ‑ye 'yu nyrɔyuu ‑do a ‑gbɛ, ɔ 'yo lele nɩ, ‑ye kɛ ɔɔ nahuin ꞊nʋ ye po, ‑ʋ nɩ 'o, ɔ nɔ: «Nahuon ‑gbo, ɔ mɔ ‑Yusu a ‑naagbopʋyu ‑yee nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","‑Ye Piɛlɩ ‑ga lele nɩ. Ti gbi bɩ ‑hi, ‑ye nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, ‑mɔ mɔ ‑Yusu a ‑naagbopʋyu ‑yee nɩ, ‑ɛ nue, ‑na ‑gbɛ, 'ke ‑n kɔ ‑wɛ 'le Galileblʋgba 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","‑Ye ɔ nɔ: «Nyɩsʋa bɔ po 'mʋ 'jrɔ ‑wɔn, 'bɩa 'nɩ 'du hɩ lɛ. 'N 'sʋɛ ke, nahuon ‑gbo, ‑ɔ kɔ ‑tɩ aa ꞊tu, 'n 'dio yi.» ");
INSERT INTO ted_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tii ‑do a ‑gbɛ 'yri, ‑ye hapɛ da lele ‑nyrɛ ‑do 'hɔn a kɔ. ‑Ye ‑tɩ ꞊nʋ, ‑Yusu ꞊tu wɛn ꞊nɔ ye, ɩ bi 'le ꞊nɔ 'mʋ 'kwli, ‑ɩ mɔ: «'Plɩɩ hapɛ 'mʋ ‑nyrɛ a dawɩɩ 'hɔn mu nu, ‑n di nu 'na ‑wɔn‑gaawɩɩ ta, ‑ɛ mɔ, ‑n 'de 'mʋ yi.» ‑Tɛ ɩ bi 'klɛɛ 'le ꞊nɔ 'kwli 'mʋ, ‑ye ɔ ‑tʋa wuwe gbo. ");
INSERT INTO ted_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","‑Tɛ ‑nyrɛɛ lɛ mu cɛ, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ 'kukue lele lɛ, ʋ kɔ ‑Juukʋɛ a ye'mʋnaanyʋ, kɔ teteitɔɔnyʋ, kɔ ‑gboligbo a nahuin 'bii 'hɛɛn, 'ke ʋ 'mʋ ‑Yusu a ‑tɩ 'mʋ lɛ pupo. ‑Ye ʋ nɔ: «‑Ba le ‑a nɩ 'sɔyuo, bʋ mʋɔ, ʋ 'muo 'le Pilatɩ ye gba.» Pilatɩ a ‑gbɛ, nɔ‑ mɔ ‑gʋlʋnʋma. (Romakʋɛ a 'kɩɩn gblaka, nɔ‑ ꞊tuo la 'o gbata ke gbo.) ");
INSERT INTO ted_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bʋ gbɔ 'klɛɛ 'le Pilatɩ ye, ‑ye ɔ ꞊gbɔ wlɔn, ɔ nɔ: «꞊Be ‑mɔ mɔ ‑Juukʋɛ a bodɩɔ?» ‑Ye ɔ nɔ: «Iin, 'mɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","‑Ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ nyo yɛɛ 'dai ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","‑Ye Pilatɩ ꞊gba lele wlɔn, ɔ nɔ: «꞊Be ‑tɩ 'bii ‑gbo, ʋʋ ‑mʋ yɛɛ, ꞊nɩ ꞊tu ꞊le 'a ‑tɩ ꞊de ‑wɔn?» ");
INSERT INTO ted_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kɛɛ ‑ye ‑Yusu 'de ‑tɩ ꞊de ‑wɔn ꞊tu. Ɛ mɔ dɛ'ɛ nɩ, 'ɛ saka Pilatɩ. ");
INSERT INTO ted_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","'Ɛ nɩ lɛ'mimre, ‑ɛ mɔ Pakɩ a ti 'yri, Pilatɩ, ɔɔ gbo tɛ ꞊jɩnyɔɔ ‑do, ‑Juukʋɛɛ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","‑Ye 'klɛɛ, ti a ‑gbɛ 'yri, ɛ kɔ ꞊jɩnyɔ ꞊de. 'A 'dʋ mɔ Balabasɩ. Ɔ mɔ ‑balʋnyɔ'ɔ nɩ. Balabasɩ a ‑gbɛ, ʋ puo o 'mʋ ꞊jɩ, ɔ kɔ 'a 'bienʋ ‑balʋnyʋ ‑ye 'hɛɛn, ‑ɛ nue, 'blʋgba a ꞊gbʋgblɔlɛ 'kwli 'mʋ, 'ke ʋ 'laa o 'le nahuon. ");
INSERT INTO ted_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","‑Ye nahuin ‑huohui mu nɩ, 'ke 'le Pilatɩ ye, ʋ nɔ: «‑A nye 'nɩ ‑hʋa, 'ke ‑bo tɛ ꞊jɩnyɔɔ ‑do gbo, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n nye lɛ nu 'ɛ nɩ 'yrʋ, lɛ'mimre, ‑ɛ mɔ Pakɩ a ti 'yri.» ");
INSERT INTO ted_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","‑Ye Pilatɩ nɔ: «꞊Be a nye 'nɩ ‑hʋa, 'ke ꞊bo tɛ 'a nɩ bodɩɔ, ‑ɔ mɔ ‑Juukʋɛ a bodɩɔ gbo?» ");
INSERT INTO ted_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kɛ ɔɔ 'pʋprɛ nu, ‑ɛ nue, Pilatɩ yie nɩ, ‑ɛ mɔ, 'ke 'le ca 'kwli 'mʋʋ nɩ, 'ke Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ poo 'o ꞊nɔ ‑Yusu kwa, ‑ɛ die nu, ɔ 'muo 'la. ");
INSERT INTO ted_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","‑Tɛ Pilatɩ ꞊gbʋ 'klɛɛ wlɔn, ‑ye ‑cɔhlʋnpinyʋ gblakɩ ꞊tutuo nahuin, 'ke bʋ le Pilatɩ, bɔ tɛ Balabasɩ gbo, kɛɛ, ɔ nɩ tɛ 'le ‑Yusu gbo. ");
INSERT INTO ted_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","‑Ye Pilatɩ ꞊tu ‑wɔn, ɔ nɔ: «'Bɩa 'nɩ tɛ Balabasɩ gbo, dɛ tio‑ aa ‑hʋa ꞊bo nu nahuon ‑gbo 'mʋ, aa 'a nɩ bodɩɔ daa 'le?» ");
INSERT INTO ted_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","‑Ye ʋʋ 'le 'yaa win, ʋ nɔ: «Kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ!» ");
INSERT INTO ted_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","‑Ye Pilatɩ nɔ: «Dɛ 'klandʋ tio‑ ɔ nu 'le, ‑ɛ kɔ 'mɔ dio kɔɔ, 'ke 'o tu 'yie 'mʋ 'le?» Kɛɛ ‑ye ʋ 'yaa 'le lele win, 'ɛ ‑hi 'o 'a ye‑hɛdɛ 'mʋ, ʋ nɔ: «Kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ!» ");
INSERT INTO ted_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","‑Ye Pilatɩ ‑hʋa bɔ blee nahuin a plɔ. Nɛ‑ nue, 'ɔ tɛ Balabasɩ gbo, kɔ, 'ɔ le 'a 'sɔyuo, 'ke bʋ bii ‑Yusu lɔkʋɛ. ‑Tɛ ʋ bio 'klɛɛ, ‑ye kɛ ɔɔ 'a 'sɔyuo a ‑gbɛ ye po, ɔ nɔ: «Ba gbɔ, ba kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ!» ");
INSERT INTO ted_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pilatɩ bɔ po 'klɛɛ lɛ, ‑ye 'a 'sɔyuo gba ‑Yusu nɩ, 'ke 'le Pilatɩ a ‑gbɛ a ‑yaa 'mʋ, ‑tɛ 'waa gbonɩɩlɛ nɩ 'o, 'ʋ da 'waa 'bienʋ 'sɔyuo 'bii. ");
INSERT INTO ted_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","‑Tɛ ʋ nyre 'klɛɛ 'o, ‑ye ʋ pue ‑Yusu wlawlʋ ‑jɔhʋn, kɔ 'ʋ hraa ꞊nɔ 'witiklaʋn lɛ. 'Witiklaʋn a ‑gbɛ, nʋ‑ ʋ ꞊tu ꞊nɔ 'lu. ");
INSERT INTO ted_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","‑Ye ʋ nyo gblɛ po 'wio, ʋ nɔ: «‑Na 'wio, ‑Juukʋɛ a bodɩɔ,» ");
INSERT INTO ted_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","kɔ, 'ʋ nu kotu, 'ʋ nyu ꞊nɔ 'lu lɛ waa, 'ʋ nyo hɩɔn 'hrin, 'plɩɩ 'ʋ blɔ kwlɩ ye gbo, 'ʋ ꞊tɩɔ 'o 'li lɛ, 'ʋ nyo 'caa. ");
INSERT INTO ted_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","‑Tɛ ʋ ‑wɔ 'klɛɛ 'a 'caalɛ ‑wɔn, ‑ye ʋ ‑hɛ ꞊nɔ wlawlʋ ‑jɔhʋn a ‑gbɛ nɩ, 'ʋ pue lele ꞊nɔ 'a ‑gbɛ a wlawlɩ, 'plɩɩ 'ʋ ꞊tɩɔ 'dɩɔ 'mʋ, 'ʋ nyo gba, 'ke 'le ‑tɛgbi ꞊nʋ, ʋ dio 'o tu 'yie 'mʋ kɔɔ. ");
INSERT INTO ted_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","‑Tɛ ʋʋ 'klɛɛ mu, ‑ye ʋ kɔ nyɩbɛyu ꞊de 'hɛɛn, nʋ‑ ꞊ŋmoo. Nyɩbɛyu a ‑gbɛ, 'a 'dʋ mɔ Simɔ. 'Ke ɔ kɔ 'le Silɛnɩdɩɔ 'mʋ. Nɔ‑ mɔ Alɛsadrɩ kɔ Rufusɩ 'hɛɛn a bu. Nɔ‑ɔ 'daklɔ 'mʋ ‑hɔn. Bʋʋ 'klɛɛ lɛ ‑hihi, ‑ye 'sɔyuo klo nɩ, 'ʋ nɩɔ 'o ke 'mʋ, 'ɔ 'ble tugbɛ ꞊nʋ, ‑ɛ kɔ 'yie 'mʋ ʋ di 'o ‑Yusu kɔɔ. ");
INSERT INTO ted_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","‑Ye ʋ gba ‑Yusu nɩ, 'ke 'le ‑tɛgbi ꞊nʋ, ʋʋ Gɔlʋgɔta daa, ‑ɛ ꞊hɛn 'nyrɛ dʋgba ꞊nʋ, ʋʋ 'Lukla daa. ");
INSERT INTO ted_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","‑Tɛ ʋ nyre 'o, ‑ye ʋʋ ‑hʋa bʋ ‑nyi ꞊nɔ nɔ, ‑ɔ kɔ ‑wɔn ʋ po 'le ꞊wɛhɩ, ʋʋ milɩ daa, kɛɛ, ɔ 'dio 'na. ");
INSERT INTO ted_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","‑Tɛgbi a ‑gbɛ, 'ke ʋ kʋɔ 'o tu 'yie 'mʋ. ‑Ye ʋ po 'bla, ‑ɛ die nu, ‑Yusu a 'hʋɩn'mʋlɛpue‑tɔplɩ, ‑tɛ bʋ di 'a wuwe nu, ʋ 'mue yi. ");
INSERT INTO ted_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Muu 'o 'yrʋ a 'o'yaalɛ a ti 'yri, 'ke ʋ kʋɔ 'o tu 'yie 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","'Plɩɩ 'ʋ 'crɩɩ 'o 'plaɩnpɩa ke, ‑tɩ ‑kɔ ‑tɩ 'ʋ kʋɔ 'o tu 'yie 'mʋ. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «Nahuon ‑gbo, nɔ‑ mɔ ‑Juukʋɛ a bodɩɔ.» (Tu ꞊nʋ, ‑ʋ kɔ 'yie 'mʋ ʋ kɔɔ 'o ‑Yusu, nʋ‑ kɔ 'lu ye 'ke ʋ 'maa 'o 'plaɩnpɩa a ‑gbɛ gbo.) ");
INSERT INTO ted_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tii ‑do a ‑gbɛ 'yri, 'ke 'o ‑Yusu 'hʋɩn 'mʋ, ʋ kɔɔ 'o ‑balʋnyʋʋ 'hɔn, 'ke 'o 'waa nɩ ti 'yie 'mʋ, ‑do ‑ye 'ke 'le 'a diidɛpɩa ke, ‑do ‑ye 'ke 'le 'a kamrapɩa ke.  ");
INSERT INTO ted_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","‑Ye ‑tɩ ꞊nʋ, ʋ 'crɩɩ, la 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ ti ‑hi la a ti 'yri, ɩ mue kɛ ‑wɔn 'lu. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «'Ke ʋ ‑hroo 'le ‑balʋnyʋ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","‑Ye nahuin 'bii ꞊nʋ, ‑ʋʋ ‑hi, ʋ nyo ꞊tu tanɩ, 'plɩɩ 'ʋʋ 'o 'li lɛ ‑hie, ʋ nɔ: «‑Mɔ ꞊nʋ, ‑ɔ plɛ, ‑ɔ di o Nyɩsʋa a 'kagblaka 'wla, 'plɩɩ ‑ɔ diu o po, 'ke 'le ‑nyrɔwɩɩ ta 'kwli 'mʋ, ");
INSERT INTO ted_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","waa ‑n dɩɔnʋ, ꞊mʋ 'o tu ꞊nʋ 'yie 'mʋ ‑hɔn, ꞊mʋ ꞊tɩ.» ");
INSERT INTO ted_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","‑Ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ teteitɔɔnyʋ 'hɛɛn, ‑ʋ nɩ ‑wɛ 'o, ʋ nyo ‑wɛ ꞊tu tanɩ, ʋ nɔ: «Ɔ waa nahuin ‑ye nɩ, kɛɛ, ɔ 'de 'le 'a dɩɔnʋ a waalɛ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","'Bɩa 'bɔ 'ya Waanyɔ 'mʋ, ‑ɔ mɔ ‑wɛ Yisraɛkʋɛ a bodɩɔ, bɔ ꞊tɩ 'o tu 'yie 'mʋ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo. ꞊Ba 'ye dɛ a ‑gbɛ, ‑ye ‑a die pue ‑tɛɛ, ‑ɛ mɔ, nɔ‑ mɔ Waanyɔ.» Nahuiin 'hɔn ꞊nʋ, ʋ kɔɔ 'o 'waa nɩ ti 'yie 'mʋ, 'ke 'o ‑Yusu 'hʋɩn 'mʋ, ʋ nyo ‑wɛ 'nɩ 'caa. ");
INSERT INTO ted_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","'Yrʋ bʋʋ 'o 'lu a ‑hɛyri 'mʋ mu nyre, ‑ye gbɩgbɩyrɩ ka ‑tʋtʋ 'bii ke. Gbɩgbɩyrɩ a ‑gbɛ, ɩ nɩ 'o ‑nɩnɩ, 'ɛ yɛ 'yrʋ‑hiilɛ a ti ke. ");
INSERT INTO ted_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","‑Tɛ 'yrʋ‑hiilɛ a ti a ‑gbɛ, ɩ nyre 'o, ‑ye ‑Yusu 'yaa 'le win, ɔ nɔ: «Eloi, Eloi, lama sabatani?» ‑ɛ ꞊hɛn 'nyrɛ: «Nyɩsʋa o, Nyɩsʋa o, dɛ‑ kɔ 'mɔ ‑n ‑ha 'yie ‑wɔn 'le?» ");
INSERT INTO ted_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Nahuin ꞊nʋ, ‑ʋ nɩ ‑tuo ke, kɛ 'waa dɛ ‑yee po: «Ba 'ye kɛ, Nyɩsʋa a winwlɔn‑hɛnyɔ Eli, nɔ‑ ɔɔ da.» ");
INSERT INTO ted_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","'Ke 'le ꞊nʋ ‑hɛyri, ꞊ɔ ‑ye gba cigbɛi, 'ɔ 'ba ‑sapoo 'mʋ, 'ɔ 'nyrɔ 'lipanɔ ye, 'plɩɩ 'ɔ mʋɔ 'o tugbɛ ‑pɛtu 'lu lɛ, 'ɔ ‑nyo ‑Yusu, 'ke ɔ 'muo 'na. Ɔ nɔ: «‑Ba po 'o 'yie gbo, Eli 'bɔ di 'le di, 'bɔ dio 'o tugbɛ ꞊nʋ 'yie 'mʋ ‑ha, ‑a 'mue 'ye.» ");
INSERT INTO ted_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kɛɛ ‑ye ‑Yusu 'gbo nɩ, 'ɔ mra ‑hʋnhlʋn. ");
INSERT INTO ted_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ti a ‑gbɛ a ti 'yri, 'ke 'le Nyɩsʋa a 'kagblaka gbo, ‑ɔ nɩ 'le Jrusrɛdɩɔ 'mʋ, Nyɩsʋa nue nɩ, dagblaka ꞊nʋ, ‑ʋ 'bɛ kayu a ‑gbɛ ꞊tɩɔ, 'ʋ ‑ki wlɔn 'bii, kʋɛ 'le 'a 'lu ye gbo, ‑bo yɛ 'a bʋgbodɛ ke. ");
INSERT INTO ted_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","'Ke 'o ‑Yusu ꞊hlɔn, 'ke Romakʋɛ a 'sɔyuo a nyɩgblaka ‑ye nɩ 'o. Nɔ‑ 'bɩɔ 'yi 'mʋ. Bɔ 'ye 'klɛɛ, ‑tɛ ‑Yusu nu 'kʋkʋɛ, ‑ye ɔ nɔ: «'Ɛ mɔ ‑tɛɛ, nahuon ‑gbo, ɔ mɔ la Nyɩsʋa a 'Yuu nɩ.» ");
INSERT INTO ted_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nyrʋgbapʋ ‑ye nɩ 'o, 'ʋ hren ‑wɔn dɛ gbi, 'ʋʋ ‑tɔplɩ 'bii ꞊nʋ 'ye, ‑ɩɩ 'lu ‑wɔn mue. 'Ke 'le ꞊nʋ ‑hɛyri, 'ke Madala 'mʋ a Mari nɩ 'le, kɔ Mari ꞊nʋ, ‑ɔ mɔ Sakɩ 'cicrɛ kɔ Sosɩ a 'dii, ɔ kɔ Salome 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nyrʋgbapʋ a ‑gbɛ, nʋ‑ʋ la ‑Yusu ‑wɔn naa, ti ꞊nʋ ‑kɔ 'yri ɔ nɩ la 'le Galileblʋgba 'mʋ, 'ʋ nyo la 'mʋ ‑hɛ. Ʋ kɔ nyrʋgbapʋ 'plɔplɔ ‑ye, kɔ ‑Yusu a ‑gbɛ 'hɛɛn, nʋ‑ di o Jrusrɛdɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","‑Tɛ 'tɔɔ ‑wɔn, ‑ye ‑Juukʋɛ a ‑gboligbo a nahuon ‑ye, ʋʋ 'o ꞊tuu 'dɔ, nɔ‑ nyre 'o ‑tuo ke. 'A 'dʋ mɔ Sosɛfʋ. 'Ke ɔ kɔ 'le Alimatedɩɔ 'mʋ. Nahuon a ‑gbɛ, ɔɔ ‑wɛ ti ꞊nʋ 'nɩ ‑pre 'dɔ, ‑ɩ kɔ 'yri Nyɩsʋa di 'o nahuin win ke kɔɔ. ‑Tɛ Sosɛfʋ a ‑gbɛ, ɔ nyre 'o ‑tuo a ‑gbɛ ke, ‑Juukʋɛ a ‑wuwle‑nyrɔwɔɔ 'o 'nɩ nyre, 'yrʋ bʋ pa a ti 'yri. Ɛ nɛ‑ nue, 'ɔ ꞊tu 'o 'klɩ, 'ɔ 'de 'yie pɩ, 'ke bɔ mu 'le Pilatɩ ‑wɔn, 'ɔ lo, 'ke bɔ wɛɛn ke, bɔ ‑ha 'o ‑Yusu a ‑plahʋɩn tu 'yie 'mʋ, ɔ 'mui 'o ‑ha. ");
INSERT INTO ted_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","‑Tɛ ‑Yusu nu 'kʋkʋɛ 'tata a ti 'yri, ɛ saka Pilatɩ nɩ. Nɛ‑ nue, 'ɔ da 'a 'sɔyuo a nyɩgblaka ꞊nʋ, 'ɔ ꞊gbɔ wlɔn, 'bɩa ‑tɛ ‑Yusu 'kʋ, 'bɛ ‑wlɛn gbo. ");
INSERT INTO ted_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","‑Tɛ 'sɔyuo a nyɩgblaka a ‑gbɛ, ɔ ꞊tuo ‑wɔn, ‑ye Pilatɩ wɛɛn ke, 'ke Sosɛfʋ bɔ ‑hɩɔ 'o tu 'yie 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","‑Tɛ ɔ wɛɛn 'klɛɛ ke, ‑ye Sosɛfʋ mu ‑tɔ wɔn ‑jisɛ, 'ɔ ꞊hɩan ‑wɔn, 'ɔ ‑ha 'o ‑Yusu tu 'yie 'mʋ, 'ɔ mʋɔ 'le ‑jisɛ a ‑gbɛ wlɔn lɛ, 'plɩɩ 'ɔ gbɔ 'le ‑tɛgbi ꞊nʋ, ɔ dio 'o ‑ha. ‑Tɛgbi a ‑gbɛ, 'hɩɔ gblaka nɩ 'o, 'ɔ hren 'klɔ, 'ɔ 'we ꞊nɔ dʋgba ye. 'Hɩɔ gblaka a ‑gbɛ 'kwli 'mʋ, 'ke ʋ 'bluu la 'le 'dɛɛ, (ti ꞊de a ti 'yri la, ‑ɛ 'we ꞊nɔ ‑wlukayu ye). 'Dɛɛ a ‑gbɛ wlɔn, 'ke ɔ po 'le ‑Yusu a ‑plahʋɩn, 'plɩɩ 'ɔ nu 'hɩɔ 'papa ꞊nʋ, ‑ɔ nɩ 'o, ‑ɔ ꞊hɩan 'le ‑wɔn lɛ, 'ɔ ka 'dɛɛ a ‑gbɛ ye. ");
INSERT INTO ted_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","‑Tɛgbi ꞊nʋ, ʋ po 'o ‑Yusu gbo, Madala 'mʋ a Mari, kɔ Mari, ‑ɔ mɔ Sosɩ a 'dii, ʋ 'yee 'o ꞊o. ");
INSERT INTO ted_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","‑Wuwle‑nyrɔwɔ a ‑gbɛ bɔ ‑hi, 'yrʋ bʋ ‑wɛ 'le yakɔ 'mʋ lɛ a ti 'yri, ‑ye Madala 'mʋ a Mari, ɔ kɔ Mari, ‑ɔ mɔ Sakɩ a 'dii, ɔ kɔ nyrʋgba ‑ye 'hɛɛn, ‑ɔ mɔ Salome, nʋ‑ mu hʋnhrʋnpo‑tɔplɩ ‑tɔ wɔn, ʋ 'mui ‑Yusu a ‑plahʋɩn lɛ po. ");
INSERT INTO ted_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","'Sɔɔdɩ a ‑nyrajru 'mʋ 'klɛɛ, 'yrʋ a 'hrɩɩlɛ a ti 'yri, ‑ye nyrʋgbapʋ a ‑gbɛ, nʋ‑ ‑tuo 'le 'dɛɛ ye. ");
INSERT INTO ted_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","‑Tɛ ʋ nɩ 'hru wlɔn, 'ʋ nyi 'le 'mʋ lɛ pupo, ʋ nɔ: «Nyɔ‑ di 'o kwakuhɩɔ ꞊nʋ 'o ‑ha 'le, ʋ nu, 'ʋ ka 'dɛɛ ye?» ");
INSERT INTO ted_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kɛɛ, ‑tɛ ʋ nyre 'klɛɛ 'le, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, kwakuhɩɔ a ‑gbɛ, ʋ briko nɩ, 'ʋ puo 'pɩa ke. ");
INSERT INTO ted_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","‑Ye ʋ pa 'le 'dɛɛ wlɔn nɩ. 'Ke ʋ yɛ 'o gblotayu ꞊de gbo. Nɔ‑ nɩ 'o diidɛpɩa ke gbo, 'ɔ pue wlawlɩ pʋɔpʋɩ. Ɔ mɔ Nyɩsʋa a lɛleenyɔ'ɔ nɩ. Bʋ 'yo 'klɛɛ, ‑ye hʋannʋ nyu nu 'dɔ. ");
INSERT INTO ted_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kɛɛ ‑ye ɔ nɔ: «A nɩ pɩ 'le hʋannʋ! 'N yie nɩ, ‑ɛ mɔ, Nasalɛtɩ 'mʋ a ‑Yusu, ʋ kɔɔ 'o tu 'yie 'mʋ, nɔ‑ aa lɛ ꞊mɔ. Ba 'ye kɛ, ‑tɛgbi, ʋ puo o 'o gbo, nɛ‑ ‑gbo. Nyɩsʋa ‑hɩɔ 'le 'kʋkʋnyʋ ‑hɛyri nɩ, 'ɔ ‑hɩɔ 'klɔ. Ɔ 'de nɔ nɩ. ");
INSERT INTO ted_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","'A ‑tɩ, ba mu, ba le 'a ‑naagbopʋ, kɔ, ba le ‑wɛ Piɛlɩ, ‑ɛ mɔ, ɔ di 'nyɛ 'hru, ɔ 'mʋ 'a mʋ ‑pre, 'ke 'le Galileblʋgba 'mʋ. 'Kee nɩ, a dio 'le gbo yɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ɔ nu o 'a ꞊tutue.» ");
INSERT INTO ted_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","‑Tɛ gblotayu a ‑gbɛ, ɔ ‑wɔ 'klɛɛ 'pʋprɛ ‑wɔn, ‑ye ʋ 'hrɩ 'le 'dɛɛ wlɔn nɩ, 'ʋ 'gba ci lɛ, ‑ɛ nue, hʋannʋ ‑hi ꞊nʋ wlɔn 'dɔ. Hʋannʋ a ‑tɩ ʋ 'de ꞊ɔ ꞊de ‑tɩ ꞊de ‑wɔn yrɛ na.  ");
INSERT INTO ted_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","'Sɔɔdɩ a ‑nyrɛgblɩ, 'ke ‑Yusu ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, 'ɔ 'hrɩ 'klɔ. Ye‑hɛnahuon, ɔ 'hrɩɩ ye, nɔ‑ mɔ Madala 'mʋ a Mari. Nɔ‑ mɔ nyrʋgba ꞊nʋ, ‑ɔ kɔ ke 'mʋ ɔ bla 'o 'kuo ‑hʋɩɩn 'nɩpata lɛ. ");
INSERT INTO ted_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Nahuin ꞊nʋ, ‑ʋʋ la ‑Yusu ‑wɔn naa, nʋ‑ Mari a ‑gbɛ, ɔ mu le wɔn, ‑ɛ mɔ, ‑Yusu ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ 'hrɩ 'klɔ. ‑Tɛ ɔ nyre 'le ꞊nʋ ‑wɔn, 'ke ɔ yʋ 'le 'kla‑wliye'yɩya kɔ ꞊hien 'hɛɛn ‑gbahlɔn gbo. ");
INSERT INTO ted_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","‑Ye kɛ ɔ nyu ye po, ɔ nɔ: «‑Yusu 'hrɩ 'klɔ, 'na ‑gbɛ, 'n 'yo nɩ.» Kɛɛ, ʋ 'dio ‑tɛɛ pue. ");
INSERT INTO ted_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu a ‑naagbopʋʋ 'hɔn ‑ye, nʋ‑ ‑hɔn 'le Jrusrɛdɩɔ 'mʋ, 'ʋʋ 'le 'dɩɔ ‑ye ke mu. Nʋ‑ ‑Yusu 'hrɩɩ ‑wɛ ye, 'ke 'le 'tu ‑ye 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","‑Tɛ ʋ yroo, ‑ye ʋ ꞊hɩan ‑wɔn, 'ʋ di Jrusrɛ 'mʋ, 'ʋ le 'waa 'bienʋ ‑ye. Kɛɛ ‑ye ʋ 'diu ‑wɛ ‑tɛɛ pue. ");
INSERT INTO ted_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi ‑wɛ, ‑ye ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o ‑do ꞊nʋ, ʋʋ di dɛ. Bʋ nɩ 'le dɛ a didie kwa 'mʋ, ‑ye ‑Yusu, ɔ 'hrɩɩ ‑wɛ ꞊nʋ ye, 'ɔ ꞊hɩʋn 'nyrɛ, 'ke ‑tɛ ʋ nu, 'ʋ 'de ꞊wlʋ a yekuolɛ kɔ, 'plɩɩ 'waa ꞊wlɩ 'ɩ 'gboklo 'mʋ, ‑ɛ nue, ‑tɛ ɔ 'hrɩ 'klɔ, nahuin ꞊nʋ, ‑ʋ 'yo, 'a ‑naagbopʋ a ‑gbɛ, ʋ 'diu ‑tɛɛ pue. ");
INSERT INTO ted_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","‑Ye kɛ ɔ nyu 'klɛɛ lele ye po, ɔ nɔ: «Ba mu, ba na 'klɔ 'bii ‑gbo ke, ba pue 'na ꞊hapʋtitie nahuin 'bii. ");
INSERT INTO ted_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Nahuon 'bɔ nɩ 'o, 'bɔ 'wɔn ꞊hapʋtitie a ‑gbɛ, 'plɩɩ 'bɔ kuo 'mʋ ꞊wlʋ ye, kɔ, 'bʋ puo 'nie 'lu, nahuon a ‑gbɛ, nɔ‑ 'n di waa, 'ke 'o Nyɩsʋa a yrʋ ‑wɔn. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ 'de 'mʋ ꞊wlʋ ye kuo, nahuon a ‑gbɛ, nɔ‑ Nyɩsʋa a ‑bati di klɩ. ");
INSERT INTO ted_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nahuin ꞊nʋ, ‑ʋ di 'mʋ ꞊wlʋ ye kuo, 'ŋmilɛka‑tɔplɩ ꞊nʋ, 'n di 'le ꞊nʋ 'mʋ naa, 'n di nu, nɩ‑ ‑gbo: 'Ke 'le 'na 'dʋ 'kwli 'mʋ, ʋ di lɛ bla 'kuo ‑hʋɩn, ‑ɔ nɩ 'o nahuin ke 'mʋ, kɔ, ʋ di po win ꞊nʋ, ʋ 'de yi. ");
INSERT INTO ted_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","'Ya 'o lele 'lu, ꞊betɩ bʋʋ hrei klɩ, kɔ, bʋ 'na 'ɛ nɩ dɛ ꞊de, ‑ɛ kɔ ‑hɛyri 'kʋɛ nɩ 'le, ‑tɔplɩ a ‑gbɛ, ɩ 'deɛ bɩ nu ꞊nʋ dɛ 'klan ꞊de 'mʋ. 'Bʋʋ 'hʋɩnhrennyʋ dabʋɩ 'lu gbo po, ‑ye 'waa 'kʋɛi di 'nɩ ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","‑Tɛ Kʋkɔnyɔ ‑Yusu ‑wɔ 'klɛɛ 'le 'waa ‑wɔn'prɛɛlɛ ‑wɔn, ‑ye Nyɩsʋa nue nɩ, ‑Yusu 'ɔ 'ya 'le yakɔ 'mʋ, 'ɔ nɩ 'o 'a diidɛpɩa ke gbo. ");
INSERT INTO ted_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","'A ‑naagbopʋ ‑mɛ ‑ye, 'ʋ mu, 'ʋʋ 'a ꞊hapʋtitie ꞊nʋ nahuin pue, 'ke 'o 'ɛ nɩ ‑tɛgbi ꞊de. Kʋkɔnyɔ a ‑gbɛ, ɔ nyu 'mʋ 'nɩ ‑hɛ, 'ke 'le 'waa ‑kʋan a ‑gbɛ 'kwli 'mʋ. 'Ke ɔɔ 'le 'ŋmilɛka‑tɔplɩ 'mʋ naa, 'ɔ nye nahuin tɔɔ, ‑ɛ mɔ, ‑tɩ ꞊nʋ, 'a ‑naagbopʋ, ʋʋ ꞊tu, ɩ mɔ ‑tɩ a ‑tɛɛ nɩ.");
INSERT INTO ted_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","‑Na 'wio Teofilɩ. ‑N kɔ 'a yiyie, ‑ɛ mɔ, kɛ nɔ ‑a mʋ ‑hɛyri, ‑tɔplɩ 'plɔplɔ mue la 'lu ‑wɔn, 'ke 'o ‑Yusu 'Klɩsʋ a ‑ta 'mʋ. ‑Tɔplɩ a ‑gbɛ, ‑ɩ mue la 'lu ‑wɔn, 'dai nahuin pui 'yie lɛ, 'ʋ ‑hɛ la nahuin ꞊nʋ, ‑bʋ po Nyɩsʋa a ꞊hapʋtitie, 'ʋ nyi la nahuin ‑wɔn lɛ na. Ɛ kɔ ‑wɛ nahuin 'plɔplɔ ‑ye, 'ʋ nyi 'crɩɩ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ nahuin ꞊nʋ, ‑ʋ 'ye la ‑tɔplɩ a ‑gbɛ, ʋ nu la 'a ꞊tutue. ");
INSERT INTO ted_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","'A ‑tɩ, 'na ‑gbɛ, 'n ꞊gba lɛ wlɔn ‑tɛɛ, ‑tɛ ‑tɔplɩ a ‑gbɛ, ɩ nu la 'lu a ‑wɔnmumue, kʋɛ la 'o 'a ‑wlu꞊tutue 'yie 'mʋ gbo. ‑Tɛ 'n ꞊gba wlɔn lɛ, ‑ye 'n 'ye nɩ, ‑ɛ mɔ, ɛ nɔɔ 'o lɛ, ‑tɔplɩ a ‑gbɛ, ‑tɛ ɩ nu yrɛkʋkɔlɛ, 'ke ꞊bo 'crɩɩ, 'ke 'o ‑mʋ ‑wɔn, nyɩgblaka Teofilɩ. ");
INSERT INTO ted_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","'N nye 'nɩ nu, ‑ɛ die nu, tɔɔlɛ ꞊nʋ, ʋ tɔɔ ‑mʋ, ꞊mue yrii, ‑ɛ mɔ, ɛ mɔ ‑tɩ a ‑tɛɛ nɩ. ‑Ye 'klɛɛ, dɛ 'n 'crɩɩ, ɛ nɛ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ti ꞊nʋ ‑kɔ 'yri Helɔdɩ mɔ la Sudeblʋgba a 'kɩɩn, ɛ kɔ la Nyɩsʋa a ‑cɔhlʋnpinyɔ ꞊de. 'A 'dʋ mɔ la Sakali. 'Ke ɔ nɩ la 'le ‑cɔhlʋnpinyʋ a ꞊tumu ‑ye ‑hɛyri, ‑ʋʋ ꞊ke ‑kʋan lɛ nu, 'ke 'le Nyɩsʋa a 'kagblaka gbo, 'ke 'le Jrusrɛdɩɔ 'mʋ. ꞊Tumu a ‑gbɛ, nʋ‑ mɔ la ‑cɔhlʋnpinyɔ Abia a ꞊tumu. Sakali a nyrʋgba, 'a 'dʋ mɔ la Elisabɛtɩ. 'Ke ɔ kɔ la 'le ‑cɔhlʋnpinyɔ Ayrɔ a ꞊tugba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakali kɔ Elisabɛtɩ a ‑gbɛ, ʋ 'sii la 'o ye, 'ke 'le Nyɩsʋa 'yi 'mʋ, kɔ, 'ʋʋ la 'o Nyɩsʋa a tetei 'bii 'o ꞊tuu ‑tɛɛ, 'ke 'le 'waa ꞊wlɩ 'bii ke. ");
INSERT INTO ted_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kɛɛ, ʋ 'de la 'yu kɔ, ‑ɛ nue, Elisabɛtɩ 'de la 'yukɔdɛ, 'plɩɩ ʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ ku la 'dɔ. ");
INSERT INTO ted_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","‑Nyrɔwɔ ꞊de 'mʋ 'klɛɛ, ‑ye Abia a ꞊tumu a ti nyre 'o ꞊o, 'ke bʋ nu ‑cɔhlʋnpi‑kʋan, 'ke 'le Nyɩsʋa a 'kagblaka gbo. Nɛ‑ nue, Sakali 'ɔɔ ‑cɔhlʋn pi, 'ke 'o Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ɛ 'we ꞊nɔ ye, ‑tɛ ‑cɔhlʋnpinyʋ nye lɛ nu, ꞊tumu ‑ye a ti 'bɩ nyre 'o, 'ʋʋ 'bla po, ‑cɔhlʋnpinyɔ ꞊nʋ, 'blaa ‑ha, nɔ‑ɔ nɩ, ‑ɔɔ 'le Nyɩsʋa a 'kagblaka gbo pa, ‑ɛ die nu, ɔ 'mʋ hʋnhrʋnpo‑tɔplɩ nu, ɔ 'mʋ ‑cɔhlʋn pi, 'ke 'o Nyɩsʋa ye. Sakali a ‑gbɛ, nɔ‑ 'bla di, 'ke bɔ pa 'le Nyɩsʋa a 'kagblaka gbo, ɔ 'mʋ hʋnhrʋnpo‑tɔplɩ a ‑cɔhlʋn pi. ");
INSERT INTO ted_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","‑Ye 'klɛɛ, ti ꞊nʋ ‑kɔ 'yri ɔ ꞊tu ‑cɔhlʋn a pipie ‑wlu, ‑ye 'ke nahuin 'plɔplɔ 'wlɛ 'o ‑patʋ 'mʋ gbo, 'ʋʋ Nyɩsʋa da. ");
INSERT INTO ted_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Sakali bɔɔ 'klɛɛ ‑cɔhlʋn pi, 'ke 'le Nyɩsʋa a 'kagblaka gbo, ‑ye Nyɩsʋa a lɛleenyɔ 'hrɩɩ 'o ꞊nɔ ye. 'Ke ɔ nyra 'o ‑tɛgbi ꞊nʋ, Sakalii 'o ‑cɔhlʋn pii a diidɛpɩa ke gbo. ");
INSERT INTO ted_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","‑Tɛ Sakali a ‑gbɛ, ɔ 'yo, ‑ye ɔ ta 'mʋ gbo, hʋannʋ 'ʋ ‑tʋa 'a nunue gbo. ");
INSERT INTO ted_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kɛɛ ‑ye Nyɩsʋa a lɛleenyɔ nɔ: «Sakali, ꞊nɩ pɩ 'le hʋannʋ, ‑ɛ nue, Nyɩsʋa wɛɛn ‑na 'batɩwin ke. ‑Na nyrʋgba Elisabɛtɩ, ɔ di ‑mʋ lɛ kɔɔ 'yu nyɩbɛyu. 'Yu a ‑gbɛ, ꞊tue ꞊nɔ Saandʋ. ");
INSERT INTO ted_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","'Ba kɔ 'yu a ‑gbɛ, ‑n di kɔ plɔ a bleelɛ 'dɔ, kɔ, nahuin 'plɔplɔ, ʋ di ‑wɛ nu 'manʋ. ");
INSERT INTO ted_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ɔ di ‑hɛ nahuon gblaka, 'ke 'le Nyɩsʋa 'yi 'mʋ. Ɔ 'deɛ bɔ 'na nɔ, mɔ, ɔ 'deɛ bɔ 'na ‑wɛ 'ɛ nɩ kɩklanɔ ꞊de. Nyɩsʋa a ‑Hihiu di 'o ꞊nɔ ke 'mʋ 'nɩ nɩ, 'plɩɩ ʋ 'muo kɔ. ");
INSERT INTO ted_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɔ die 'nɩ nu, Yisraɛkʋɛ 'plɔplɔ, ʋ 'mʋ lele Kʋkɔnyɔ Nyɩsʋa ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","‑Tɛ Nyɩsʋa a winwlɔn‑hɛnyɔ Eli nu la 'klɩ a kenɩnɩɛ, kɔ, ‑tɛ 'a 'klɔ nɩ la 'mʋ, kɛ'ɛ nɩ, ɔ di 'mʋ nɩ, ɔ 'mʋ nahuin le, ‑ɛ mɔ, Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'a dakʋ ye ya, ɔ di 'le 'nɩ di, kɔ, ɔ die 'nɩ nu, Nyɩsʋa a dakʋ 'mʋ ‑wɔn ‑wɛ, 'plɩɩ Waanyɔ a ‑gbɛ, ɔ 'mʋ 'le di. Ɔ die 'nɩ nu, bunʋ kɔ 'waa 'yuo 'hɛɛn, ʋ 'mʋ win 'mʋ lɛ 'wʋnwɔn, ɔ 'mue ‑wɛ nu, nahuin ꞊nʋ, ‑ʋ 'nɩnɩ ꞊tuu 'o Nyɩsʋa 'o, ʋ 'mʋ ꞊tɔ kɔ, 'plɩɩ ʋ 'mʋ Nyɩsʋa ꞊wlʋ ye kuo.» ");
INSERT INTO ted_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","'Plɩɩ Nyɩsʋa a lɛleenyɔ a ‑gbɛ, ɔ 'mʋ mu ‑yrɛ, ‑ye kɛ Sakalii ꞊nɔ ye po: «‑Be' 'n di 'a yiyie nu, ‑ɛ mɔ, ‑tɩ ‑nɩɩ ꞊tu, ɩ mɔ ‑tɩ a ‑tɛɛ nɩ 'le? ‑Ɛ nue, 'n kɔ 'na nyrʋgba 'hɛɛn, ‑a ‑wɛ 'yi.» ");
INSERT INTO ted_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","‑Ye Nyɩsʋa a lɛleenyɔ ꞊tuo ‑wɔn, ɔ nɔ: «'Na 'dʋ mɔ Gabriɛ. 'Ke 'n 'cipi 'o Nyɩsʋa 'hʋɩn 'mʋ, 'nɩɩ 'a ‑kʋan nu. Nɔ‑ɔ nɩ, ‑ɔ le 'mʋ, kɛ nɔ ‑mʋ ‑wɔn, 'ke ꞊bo pue ‑mʋ ꞊hapʋtitie ‑gbo. ");
INSERT INTO ted_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kɛɛ, ‑n 'de 'na win ‑tɛɛ pue. Nɛ‑ die nu, ‑n 'deɛ ‑bo yi 'prɛlɛ, ɛ 'mue gba ‑gbagba, ‑tɩ ‑gbo 'n ꞊tu, ɩ 'mʋ nue, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa die 'o ‑hʋa.» ");
INSERT INTO ted_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tii ‑do ꞊nʋ ‑kɔ 'yri Nyɩsʋa a lɛleenyɔ kɔ Sakali 'hɛɛn, ʋʋ 'prɛ, nahuin ‑huohui ꞊nʋ, ‑ʋ 'wlɛ 'o ‑patʋ 'mʋ gbo, ʋʋ Sakali 'nɩ ‑pre, 'ɩ saka ꞊nʋ, ‑tɛ ɔ nu, 'ɔ ‑wlɛn 'le Nyɩsʋa a 'kagblaka gbo. ");
INSERT INTO ted_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","'Plɩɩ ɔ 'mʋ mu 'hrɩ, ɔ 'de 'le nahuin a ‑wɔn'prɛɛlɛ ‑wɛ. Ɔɔ po dabʋɩɩ ‑do. Nɛ‑ nue, nahuin 'ʋ yrie, ‑ɛ mɔ, ɔ 'ye dɛ ꞊de, ‑ɛ mue 'lu ‑wɔn, 'ke 'le Nyɩsʋa a 'kagblaka gbo. ");
INSERT INTO ted_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ɔ nu lele ‑nyrɔwɩ gbi, ɔ 'mʋ ‑kʋan ꞊nʋ ‑wɔn ‑wɔ, ɔ blɛ ye bɔ nu, 'ke 'le Nyɩsʋa a 'kagblaka gbo. ‑Tɛ 'a ‑nyrɔwɩ gbi a ‑gbɛ, ɩ ‑yrɛ 'lu, ‑ye ɔ mu 'mʋ 'waa 'dɩɔ. ");
INSERT INTO ted_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ti gbi bɩ ‑hi, ‑ye 'a nyrʋgba Elisabɛtɩ nɩ 'mʋ 'kwli. Ɔ 'nɩ 'hrɩ ꞊le, ‑ɛ die nu, nahuin 'nɩ ꞊hion 'ye, 'ɛ nu yakʋɛɛ ꞊hun. Kɛ ɔɔ po: ");
INSERT INTO ted_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Nyɩsʋa po 'na ‑tɩ ‑wɔn ꞊wlʋ, 'ɔ nue, nahuin 'ʋ 'nɩnɩ di 'klɛɛ lele 'mʋ 'caa, 'ke ꞊bo 'nɩnɩ di 'yu kɔ a ‑tɩ.» ");
INSERT INTO ted_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","‑Tɛ Elisabɛtɩ a ‑gbɛ a 'kwli kɔ yakʋɛɛ ‑huonnɔ, ‑ye Nyɩsʋa tɛ gbo 'a lɛleenyɔ Gabriɛ, 'ke bɔ mu la 'le Galileblʋgba a 'dɩɔ ꞊nʋ 'kwli 'mʋ, ‑ɔ kɔ 'dʋ mɔ Nasalɛtɩ. ");
INSERT INTO ted_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","'Dɩɔ a ‑gbɛ 'mʋ, 'ke 'yunyrɔyu ꞊de nɩ 'le. 'A 'dʋ mɔ Mari. Ɔ 'de nyɩbɛdɛ yi. Kɛɛ, nyɩbɛyu ꞊de nɩ 'o, 'ʋ nyo Sosɛfʋ daa. 'A bu gblaka, nɔ‑ mɔ la bodɩɔ Dafidɩ. Sosɛfʋ a ‑gbɛ, nɔ‑ dio kɔ. ‑Ye Mari a ‑gbɛ, nɔ‑ kɔ ‑wɔn Nyɩsʋa lee 'le 'a lɛleenyɔ. ");
INSERT INTO ted_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","‑Tɛ ɔ pa 'le Mari a ‑tɛ, ɔ nɔ: «Mari, ‑mɔ 'n yɛ. Kɔ plɔ a bleelɛ! ‑Mɔ ‑gbo Kʋkɔnyɔ Nyɩsʋa ‑ha 'le du 'mʋ, 'ke 'o 'a ‑kʋan a ‑ta 'mʋ. Ɔɔ ‑mʋ 'yie 'nɩ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","'Plɩɩ ɔ 'mʋ wintɛdʋ a ‑gbɛ mu 'wɔn, ‑ye ɔ 'ta 'mʋ gbo, 'ɔɔ 'lu lɛ ‑hie, dɛ tio‑ wintɛdʋ a ‑gbɛ bɛ ꞊hɛn 'nyrɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","‑Ye Nyɩsʋa a lɛleenyɔ ꞊nʋ, ɔ nyo 'nɩ le, ɔ nɔ: «Mari, ꞊nɩ pɩ 'le hʋannʋ! Nyɩsʋaa ‑mʋ ye tɔɔ 'a 'mʋnʋɛlɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ɛ nɛ‑ mɔ, ‑n di 'mʋ nɩ 'kwli, ꞊mʋ 'yu nyɩbɛyu kɔ. 'Yu a ‑gbɛ, ‑n di kɔ, ‑n dio daa ‑Yusu. ");
INSERT INTO ted_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɔ di kɔ ‑tɩ a 'yi'bʋbʋa, 'plɩɩ ɔ di 'ya Yrayrɩnyɩsʋa a 'Yu, 'plɩɩ Kʋkɔnyɔ Nyɩsʋa die 'nɩ nu, 'yu a ‑gbɛ, ɔ 'mʋ bodɩɔ ‑hɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'a bu gblaka bodɩɔ Dafidɩ nɩ la 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ɔ di 'ya Yisraɛkʋɛ a bodɩɔ, ‑tɛ ti tɛ ye gbo. 'A bodɩɔdɛ, ɛ 'deɛ bɛ kɔ 'lu‑yrɛɛlɛ.» ");
INSERT INTO ted_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","‑Ye ɔ nɔ: «‑Tɛ 'n 'de nyɩbɛyu ꞊de yi, ‑be' 'n ‑wɛ 'le ꞊bo nu 'klɛɛ 'kwli a 'mʋnɩnɩɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","‑Ye Nyɩsʋa a lɛleenyɔ nɔ: «Nyɩsʋa a ‑Hihiu di 'le ‑mʋ 'mʋ 'nɩ ꞊tɩɩ. Yrayrɩnyɩsʋa a ‑gbɛ, ɔ di ke nɩ ‑tuo, 'plɩɩ 'a 'klɩ 'mue nu, 'ke 'le 'ŋmilɛkadɛ 'kwli 'mʋ, ꞊mʋ 'kwli 'mʋ nɩ. Nɔ‑ kɔ 'yu a ‑gbɛ, ‑n di kɔ, Nyɩsʋa dio 'nɩ ‑ha, 'ke 'o 'a ‑kʋan a ‑ta 'mʋ, kɔ, ɔ di 'ya Nyɩsʋa a 'Yu. ");
INSERT INTO ted_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","'Ye kɛ, ‑na 'dɩayu nyrɔyu Elisabɛtɩ, ꞊hapʋkɔ, 'ɔ ‑wɛ 'yi, kɛɛ, ‑tɛ ɔ nɩ o 'kwli 'mʋ, 'a yakɔ a ‑huonnɔ a nɔnɔ nɩ gbo, 'plɩɩ ‑ye nahuin nɔ 'nɩ, ɔ 'de o 'yukɔdɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Kɛɛ, Nyɩsʋa, ɔ ‑wɛ 'le bɔ nu 'ɛ nɩ dɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","‑Ye Mari nɔ: «‑Ɔɔ, 'mɔ mɔ Kʋkɔnyɔ Nyɩsʋa a ‑kʋannunyɔɔ nɩ. Dɛ ‑gbo, ɔɔ ‑hʋa, 'na ‑gbɛ, 'n nye ‑wɛ 'nɩ ‑hʋa. ‑Tɛ ‑n nu 'pʋprɛ, kɛ bɛ nu 'lu a ‑wɔnmumue.» ‑Ye Nyɩsʋa a lɛleenyɔ ꞊nʋ, ɔ mu nɩ. ");
INSERT INTO ted_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tii ‑do a ‑gbɛ 'yri, ‑ye Mari bi wlɔn 'hru, 'ɔ 'kɩka, 'ɔ mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ kɔ 'mʋ Sakali kɔ Elisabɛtɩ 'hɛɛn, ʋ 'ti 'le. 'Dɩɔ a ‑gbɛ, 'ke ɔ nɩ 'le Sudeblʋgba a dʋgbɩ ‑gbahlɔn. ");
INSERT INTO ted_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","‑Tɛ ɔ nyre 'le, 'ke ɔ pa 'le Sakali a kayu gbo, 'ɔ po Elisabɛtɩ a 'wio gbo. ");
INSERT INTO ted_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tii ‑do a ti 'yri, 'plɩɩ Elisabɛtɩ 'mʋ Mari a win mu 'wɔn, ‑ye 'yu ꞊nʋ, ‑ɔ nɩ 'le Elisabɛtɩ 'kwli 'mʋ, ɔ ‑tʋa gblɛ‑jihielɛ gbo, Nyɩsʋa a ‑Hihiu 'ʋ bi 'o Elisabɛtɩ ke 'mʋ, 'ʋ nue, ");
INSERT INTO ted_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","'ɔ 'yaa 'le win, ɔ nɔ: «Nyɩsʋa nu ‑mʋ 'mʋ ꞊hapʋdɛ, 'ɛ ‑hi 'o nyrʋ 'bii 'mʋ, kɔ, 'yu ‑gbo, ‑n di kɔ, ɔ 'muo ‑wɛ ꞊hapʋdɛ 'mʋ nu. ");
INSERT INTO ted_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","'Mɔ ‑gbo, ‑ɔ 'de nahuon ꞊de, 'plɩɩ 'na Kʋkɔnyɔ a 'dii, bɔ di nɔ 'na kayu gbo di, ɛɛ 'mʋ 'nɩ saka. ");
INSERT INTO ted_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","'Ye kɛ, ‑tɛ ‑n pa kayu gbo, 'plɩɩ 'mʋ ‑na win mu 'wɔn, 'manʋ nue nɩ, 'yu ‑gbo, ‑ɔ nɩ 'le 'mʋ 'kwli 'mʋ, 'ɔ ‑tʋa gblɛ‑jihielɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dɛ ꞊nʋ, Nyɩsʋa po o lɛ, ɔ di o nu, ‑n kue ye ꞊wlʋ, ‑ɛ mɔ, ɔ die 'nɩ nu. Nɛ‑ nue, ꞊nɩ kɔ plɔ a bleelɛ.» ");
INSERT INTO ted_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","‑Ye Mari nɔ: «'Ke 'le 'na ꞊wlʋ 'bii ke, 'nɩɩ Kʋkɔnyɔ Nyɩsʋa 'nɩ baa. ");
INSERT INTO ted_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","'N kɔ plɔ a bleelɛ, 'ke 'o Nyɩsʋa a ‑ta 'mʋ, ‑ɔ mɔ 'na Waanyɔ, ");
INSERT INTO ted_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","‑ɛ nue, 'mɔ ‑gbo, ‑ɔ mɔ 'a ‑kʋannunyɔ, ꞊betɩ ꞊bo 'de nahuon ꞊de, ɔ po 'na ‑tɩ ‑wɔn ꞊wlʋ. 'Ɛ mɔ ‑tɛɛ, kʋɛ 'klɛɛ mɔ gbo, nahuin a ꞊hrɩn a ꞊hrɩn, ʋ di 'nɩ ꞊tu, ‑ɛ mɔ, 'mɔ mɔ nyrʋgba ꞊nʋ, ‑ɔ kɔ plɔ a bleelɛ, ");
INSERT INTO ted_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","‑ɛ nue, 'Klɩkenɩnyɩsʋa, ɔ nu 'mʋ 'mʋ ꞊hapʋdɛ gblaka. Nɔ‑ mɔ Nyɩsʋa. ");
INSERT INTO ted_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nahuin a ꞊hrɩn a ꞊hrɩn ꞊nʋ, ‑ʋ nyo pɩ, 'plɩɩ, ‑ʋ nyo 'o ꞊tuu, ɔ di yrii 'waa wɔlɩ. ");
INSERT INTO ted_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ɔ kɔ 'klɩ, 'ke bɔ nu ‑tɔplɩ gblakɩ: Nahuin ꞊nʋ, ‑ʋ 'yaa 'le 'waa dɩɔnʋ, Nyɩsʋa, ɔ ‑gbʋgbʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","'Kɩɩnpʋ kɔ bodɩɔpʋ 'hɛɛn, ɔ ‑hɩʋ klɛ gbatɩ, kɛɛ, nahuin ꞊nʋ, ‑ʋ 'de nahuin ꞊de, nʋ‑ ɔ po gbatɩ klɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nahuin ꞊nʋ, kanʋʋ nu, ɔ ‑ha 'le ꞊hapʋ‑tɔplɩ, 'ɔ ‑nyi ꞊nʋ. Dɛkɔnyʋ ‑mɛ ‑ye, ɔ 'diu dɛ ꞊de ‑nyi, 'ɔ blʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","'Plɩɩ, 'ɔ le la ‑a nɩ bunʋ, ‑ɛ mɔ, ɔ di la 'a dakʋ Yisraɛkʋɛ 'mʋ nu ꞊hapʋdɛ, ‑tɛ 'klɔ tɛ ye gbo. Kɛ'ɛ nɩ, ɔ nu la Abrahamʋ kɔ 'a 'yuo a 'yuo a leelɛ. 'Lepoodɛ a ‑gbɛ, ɛ 'de ꞊nɔ ‑wɔn ‑hri, 'ɔ dii 'a dakʋ ke.» Kɛ'ɛ nɩ, Mari nu Nyɩsʋa a baalɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, tii ‑tie Mari ‑hi 'le Elisabɛtɩ ‑wɔn, ɩ ‑wɛ 'le yakʋɛɛ ta, 'plɩɩ 'ɔ ꞊hɩan ‑wɔn, 'ɔ mu 'le 'a 'dɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ti ꞊nʋ ‑kɔ 'yri Elisabɛtɩ di 'o ‑ŋlaa, ɩ nyre 'o ꞊o, 'ɔ kɔ 'yu nyɩbɛyu. ");
INSERT INTO ted_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","'Waa 'dɩɔ a nahuin kɔ 'a ꞊tugba a nahuin, ʋ 'wɩn nɩ, ‑ɛ mɔ, Nyɩsʋa yrii 'a wɔlɩ, 'ɔ nu ꞊nɔ ꞊hapʋdɛ gblaka 'mʋ. Nɛ‑ nue, 'ʋʋ ‑wɛ 'manʋ nu. ");
INSERT INTO ted_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","‑Tɛ 'yu ꞊cɛɛ 'wee, ‑ye ʋ di 'le ꞊le, ‑ɛ die nu, ʋ 'muo ye 'bɛ. ‑Ye ʋʋ ‑hʋa bʋ ꞊tuo 'o 'a bu Sakali 'nyrɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kɛɛ ‑ye 'a 'dii nɔ: «'Ʋʋn, 'a 'dʋ di mɔ Saan.» ");
INSERT INTO ted_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","‑Ye nahuin, ‑ʋ nɩ ‑tuo ke, ʋ nɔ: «Dɛ‑ kɔ Saandʋ 'le, ‑ɛ nue, nahuon ꞊de 'de 'le ‑na ꞊tugba 'mʋ nɩ, bʋ ꞊tue 'dʋ a ‑gbɛ,» ");
INSERT INTO ted_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","'ʋ po dabʋɩ, 'ʋ ꞊gba 'a bu Sakali wlɔn, 'dʋ tio‑ ɔɔ ‑hʋa bɔ ꞊tue 'a 'yu. ");
INSERT INTO ted_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","‑Ye Sakali a ‑gbɛ, ɔ ‑hʋa ꞊nʋ 'plaɩnpɩa gbi, ‑ɔ kɔ ke ʋʋ 'o 'crɩɩ. ‑Tɛ ʋ ‑nye ꞊nɔ, ‑ye ɔ 'crɩɩ 'o: «'A 'dʋ mɔ Saan.» ");
INSERT INTO ted_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","‑Tɛ nahuin ‑hre dɛ ꞊nʋ, ɔ 'crɩɩ, ‑ye ʋ 'bii, ɛ saka ꞊nʋ nɩ. ‑Ye tii ‑do ꞊nʋ a ti 'yri, Sakali a mɛ ꞊wlɛɛ gbo, 'ɔ 'tatɩ lele 'pʋprɛ, 'ɔ 'yaa 'le win, 'ɔ ‑tʋa Nyɩsʋa a baalɛ. ");
INSERT INTO ted_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dɛ a ‑gbɛ, ‑ɛ mue 'lu ‑wɔn, ɛ saka 'waa 'dɩɔ a nahuin nɩ, kɔ, nahuin ꞊nʋ, ‑ʋ 'ti 'le Sudeblʋgba a dʋgbɩ ‑gbahlɔn, 'ʋ nyi ‑wɔn yrɛ nɩna. ");
INSERT INTO ted_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nahuin 'bii ꞊nʋ, ‑ʋ nyi 'wɔn, ʋ nyi ‑wɔn lɛ ‑hie 'lu, ʋ nɔ: «'Yu gbi ‑gbo le, ɔ di ‑hɛ nahuon gblaka.» 'Ɛ mɔ ‑tɛɛ, Nyɩsʋa a ‑gbɛ, nɔ‑ nyo 'yie ꞊tu. ");
INSERT INTO ted_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye 'yu a ‑gbɛ a bu Sakali, Nyɩsʋa a ‑Hihiu bi 'o ꞊nɔ ke 'mʋ nɩ, Sakali a ‑gbɛ 'ɔ ‑tʋa Nyɩsʋa a win a wlɔn‑hɩhɩɛ gbo, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Nahuin 'bii, bʋ baa ‑a nɩ Kʋkɔnyɔ, ‑ɔ mɔ Yisraɛkʋɛ a Nyɩsʋa, ‑ɛ nue, ‑a mʋ ‑gbo, ‑ʋ mɔ 'a dakʋ, ɔ kɔ 'le ‑a nɩ dɛ ‑wɔn. Nɛ‑ nue, 'ɔ di ‑a mʋ ꞊gbla wɔn. ");
INSERT INTO ted_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","'Ke 'le 'a ‑kʋannunyɔ bodɩɔ Dafidɩ a 'yuo a 'yuo ‑hɛyri, ɔ ‑ha 'le Waanyɔ, ‑ɔ nɩ 'klɩ ke, 'ɔ yɔ ‑a mʋ ye. ");
INSERT INTO ted_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","‑Tɩ a ‑gbɛ, 'a winwlɔn‑hɛnyʋ, ʋ ꞊tui la nɩ, ti ‑hi la a ti 'yri. ");
INSERT INTO ted_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Waanyɔ a ‑gbɛ, nɔ‑ɔ nɩ, ‑ɔ di ‑a mʋ nahuin ꞊nʋ kwa ‑ha, ‑ʋʋ ‑a mʋ ye ‑wɔn, kɔ, ‑ʋ yraa ‑a mʋ. ");
INSERT INTO ted_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɔ yrii ‑a nɩ bunʋ a wɔlɩ, kɔ, 'yrɩ ꞊nʋ, ɔ ꞊tue la, ɔ kɔ ‑a nɩ bunʋ 'hɛɛn, ɔ nyi 'o 'nɩ ꞊tuu. ");
INSERT INTO ted_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ɔ 'sʋɛ la nɩ, 'ke 'o ‑a nɩ bu Abrahamʋ ye, ");
INSERT INTO ted_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‑ɛ mɔ, ɔ di ‑a mʋ 'nɩ ꞊gbla, 'ke 'le ‑a nɩ yraanyʋ kwa 'mʋ, ‑ɛ die nu, ꞊baa 'a ‑kʋan nu, ‑a 'nɩ ꞊han hʋannʋ pɩ, ");
INSERT INTO ted_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","kɔ, ‑a 'mʋ 'a ‑kʋan nu ‑tɛɛ, ti 'bii ꞊nʋ, ‑a di nɔ 'klɔ ke ‑hi, ‑ɛ 'we ꞊nɔ nahuin ꞊nʋ ye, ɔ kɔɔ win ke. ");
INSERT INTO ted_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","'Na 'yu o, ‑mɛ ‑ye, ʋ di ‑mʋ daa Yrayrɩnyɩsʋa a winwlɔn‑hɛnyɔ, ‑ɛ nue, ‑mɔ di 'hru 'nyɛ, ꞊mʋ 'hru ye kla, ‑tʋnahuin a ꞊wlɩ 'mʋ ‑wɔn ‑wɛ, 'plɩɩ Kʋkɔnyɔ a ‑gbɛ, ɔ 'mʋ 'le di, ");
INSERT INTO ted_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","꞊mʋ Nyɩsʋa a dakʋ le, ‑ɛ mɔ, Nyɩsʋa a ‑gbɛ, ɔ di 'waa dɛ 'kuku 'nɩ 'wʋwla, ɔ 'mu waa, ");
INSERT INTO ted_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","‑ɛ nue, Nyɩsʋa a ꞊wlʋ nɔ lɛ 'yi, kɔ, 'ɔɔ nahuin a wɔlɩ yrii 'dɔ. Ɔɔ ‑a mʋ ‑nye ‑nyrɛ, ‑ɛ ‑hɔn 'le yakɔ 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","‑nyrɛ a ‑gbɛ, ɛ 'mue nu, nahuin ꞊nʋ, ‑ʋ nɩ 'le gbɩgbɩyrɩ ‑hɛyri, kɔ, ‑ʋʋ 'kʋkʋɛ a hʋannʋ pɩ, ʋ 'mʋ lɛ yrii, ɛ 'mue ‑wɛ nu, kegbowɛɛnlɛ, ɛ 'mʋ nɔ ‑a mʋ ‑gbahlɔn nɩ.» Nɛ‑ mɔ Sakali a ‑wla a win. ");
INSERT INTO ted_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","'Yu a ‑gbɛ, ‑ɔ mɔ Saan, ɔɔ 'nɩ ku, 'a ꞊wlʋʋ klɛ 'nɩ bii, 'ke 'o Nyɩsʋa a 'mʋnʋɛlɛ ‑wɔn. ‑Tɛ ɔ ku 'klɛɛ, 'ke ɔ 'ti 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti. 'Ke ɔ nɩ 'le ‑nɩnɩ, ti 'ɩ nyre 'o, 'ke bɔ ꞊tu 'a ‑kʋan ‑wlu, 'ke 'le Yisraɛkʋɛ ‑gbahlɔn. ");
INSERT INTO ted_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ti a ‑gbɛ 'yri, Romakʋɛ a 'kɩɩn gblaka ‑ye nɩ la 'le. 'A 'dʋ mɔ la Ogusɩ. 'Kɩɩn Ogusɩ a ‑gbɛ, nɔ‑ mɔ la Romakʋɛ a 'blʋgbɩ 'bii a 'kɩɩn gblaka. ‑Nyrɔwɔ ꞊de 'mʋ, 'ɔ le 'a ‑kʋannunyʋ, 'ke bʋ ‑hre 'a 'blʋgbɩ a ‑gbɛ a nahuin 'bii, ɔ nɔ: «'Ɛ nɩ nahuon 'bɔ nɩ 'o, 'ke bɔ mu 'le 'a 'dɩɔ 'mʋ, 'ke ʋ dio 'le ‑hree!» ");
INSERT INTO ted_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nahuin‑hredɛ a ‑gbɛ, ɛ mɔ la 'a ye‑hɛdɛɛ nɩ. Ti a ‑gbɛ 'yri, nahuon ‑gbo, ‑ɔ kɔ 'dʋ mɔ la Kiliniusɩ, nɔ‑ mɔ la Siliblʋgba a ‑gʋlʋnʋma. ");
INSERT INTO ted_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ɛ nɛ‑ nue, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'ɔɔ 'le 'a 'dɩɔ 'mʋ mu, ‑ɛ die nu, ʋ 'muo 'le ‑hree. ");
INSERT INTO ted_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ti a ‑gbɛ 'yri, nyɩbɛyu ꞊nʋ, ‑ɔ mɔ Sosɛfʋ, ɔ kɔ 'a 'bʋa Mari 'hɛɛn, 'ke ʋ 'ti 'le 'waa 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ kɔ 'dʋ mɔ Nasalɛtɩ, 'ke 'le Galileblʋgba 'mʋ. Mari a ‑gbɛ, ɔ nɩ la 'mʋ 'kwli, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ. Ɔ kɔ Sosɛfʋ 'hɛɛn, ʋ 'de bʋɩ na ye po. Kɛɛ, Sosɛfʋ, nɔ‑ dio kɔ. Sosɛfʋ a ‑gbɛ, 'ke ɔ kɔ 'le 'dɩɔ ꞊nʋ 'mʋ, ʋʋ Betelɛmʋ daa, 'ke 'le Sudeblʋgba 'mʋ. Betelɛmʋ a ‑gbɛ 'mʋ, Sosɛfʋ a bu gblaka, ‑ɔ mɔ la bodɩɔ Dafidɩ, 'ke ɔ kɔ la ‑wɛ 'le. Nɛ‑ nue, Sosɛfʋ kɔ Mari 'hɛɛn 'ʋ ‑hɔn 'le Nasalɛtɩ 'mʋ, 'ʋ mu 'le Sosɛfʋ a ‑gbɛgbɛ a 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Betelɛmʋ, ‑ɛ die nu, ʋ 'mu 'le ‑hree. ");
INSERT INTO ted_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","‑Tɛ ʋ nyre 'klɛɛ 'le Betelɛmʋ 'mʋ, ‑ye 'dɩɔ a kayuo 'bii 'yii 'le lɛ, 'ke 'o 'dagbɩ ‑wɔn. Nɛ‑ nue, 'ʋ mu 'le 'wlugba‑tɔplɩ a kayu ‑ye gbo. ‑Ye ti ꞊nʋ, Mari di 'yri ‑ŋlaa, ɩ nyre 'o ꞊o, 'ɔ kɔ 'a ye‑hɛyu. 'Yu a ‑gbɛ, ɔ mɔ 'yu nyɩbɛyu'u nɩ, 'ɔ 'hɩnhɩʋɔn danɩ lɛ, 'ɔ pɩɔ 'le 'wlugba‑tɔplɩ a ‑gbɛ a dɛdihuo wlɔn gbo. ");
INSERT INTO ted_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","'Tɔ 'mʋ, 'ke blablɔ'yie꞊tunyʋ nɩ la 'o Betelɛmʋ a ‑gbɛ ꞊hlɔn, 'ʋʋ la 'waa blablɔ 'yie ꞊tu. ");
INSERT INTO ted_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tii ‑do a ti 'yri, ‑ye Nyɩsʋa a lɛleenyɔ 'hrɩɩ ꞊nʋ ye, Nyɩsʋa a ‑nyrɛ 'ɛ ꞊glaa 'le ꞊nʋ, 'ɛɛ wlɩn. Nyɩsʋa a ‑nyrɛ a ‑gbɛ kɔ 'a lɛleenyɔ a ‑gbɛ 'hɛɛn, nɩ‑ po 'le ꞊nʋ hʋannʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Kɛɛ ‑ye Nyɩsʋa a lɛleenyɔ ꞊nʋ, kɛ ɔɔ ꞊nʋ ye po: «A nɩ pɩ 'le hʋannʋ. 'N ya 'a mʋ ye ꞊hapʋtitie. Ɛ mɔ 'manʋ gblaka, 'ke 'o 'a nɩ dakʋ 'bii ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","꞊Hapʋtitie a ‑gbɛ, nɛ‑ ‑gbo: Kɛkɛ a ‑nyrɔwɔ ‑gbo 'mʋ, 'ke ʋ kɔ kɛ 'a nɩ Waanyɔ. Kɛ ʋ kʋɔ kɛ nɔ Betelɛmʋ 'mʋ, ‑ɔ kɔ 'mʋ bodɩɔ Dafidɩ kɔ la ‑wɛ 'le. Nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'a mʋ ye ya. Waanyɔ a ‑gbɛ, nɔ‑ mɔ Kʋkɔnyɔ, ‑ɔ kɔɔ nahuin 'bii win ke. ");
INSERT INTO ted_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","‑Tɛ a di 'a yriilɛ nu, nɛ‑ ‑gbo: 'Bɩa 'ba mu 'dɩɔ 'mʋ, 'ba pa 'le 'wlugba‑tɔplɩ a kayu gbo, a di 'le gbo yɛ 'yuplu, ʋ 'muo danɩ lɛ 'hɩnhɩʋan, ʋ 'muo 'le 'wlugba‑tɔplɩ a ‑gbɛ a dɛdihuo wlɔn gbo pɩa. ‑Ye Waanyɔ a ‑gbɛ, nɔ‑ɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tii ‑do a ti 'yri, ‑ye Nyɩsʋa a lɛleenyʋ 'plɔplɔ ‑ye ꞊glaa 'le ye‑hɛlɛleenyɔ ꞊nʋ nɩ, 'ʋʋ Nyɩsʋa 'nyrɛɛ lɛ pue. Kɛ ʋʋ po: ");
INSERT INTO ted_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Yrayrɩnyɩsʋa kɔ ‑tɩ a 'yi'bʋbʋa, kɔ, 'ɔɔ nahuin ‑gbo kegbowɛɛnlɛ ‑nye, ‑ʋ nɩ nɔ ‑tʋtʋ ke, 'ke 'o 'waa 'mʋnʋɛlɛ a ‑ta 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","‑Ye Nyɩsʋa a lɛleenyʋ ꞊nʋ, ʋ ‑hɔn 'o blablɔ'yie꞊tunyʋ 'hʋɩn 'mʋ nɩ, 'ʋ mu 'le yakɔ 'mʋ. ‑Tɛ ʋ mu 'le yakɔ 'mʋ, ‑ye blablɔ'yie꞊tunyʋ ꞊nʋ, ʋ nɔ: «‑Ba mu 'le Betelɛmʋ 'mʋ, ‑a 'mʋ 'yuplu a ‑gbɛ 'ye, ‑ɔ kɔ ‑tɩ Kʋkɔnyɔ Nyɩsʋa ꞊tu ‑a mʋ ye.» ");
INSERT INTO ted_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tii ‑do a ti 'yri, ‑ye ʋ bi wlɔn 'hru. 'Plɩɩ ʋ 'mʋ 'le 'yuplu a ‑gbɛ a kɔɔlɛ 'mʋ mu nyre, 'ɛ mɔ ‑tɛɛ, 'ke ʋ yɛ 'o Mari kɔ Sosɛfʋ kɔ 'yuplu a ‑gbɛ 'hɛɛn gbo, 'yuplu a ‑gbɛ, 'ʋ 'hɩnhɩʋɔn danɩ lɛ, 'ʋ pɩɔ 'le 'wlugba‑tɔplɩ a dɛdihuo wlɔn gbo. ");
INSERT INTO ted_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","'Plɩɩ ʋ 'mʋ 'yuplu a ‑gbɛ mu 'ye, ‑ye ‑tɩ 'bii ꞊nʋ, Nyɩsʋa a lɛleenyɔ ꞊tu wɛn ꞊nʋ ye, 'ke 'o 'yuplu a ‑gbɛ a ‑ta 'mʋ, ‑ye ʋ nɩ lɛ ‑wɔn, 'ke 'o nahuin 'bii ꞊nʋ ye, ‑ʋ nɩ 'o. ");
INSERT INTO ted_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","‑Tɛ nahuin a ‑gbɛ, ʋ 'wɔn 'klɛɛ ‑tɩ a ‑gbɛ, blablɔ'yie꞊tunyʋ na ‑wɔn lɛ, ‑ye ʋ saka nɩ. ");
INSERT INTO ted_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","‑Tɩ 'bii ꞊nʋ, ɩ 'de Mari ‑wɔn ‑hri, 'plɩɩ ɔ nyi klɛ naa ꞊wlʋ ti a pɛpɛ 'bii ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","‑Ye blablɔ'yie꞊tunyʋ, ʋ ꞊hɩan la ‑wɔn, 'ʋʋ la Nyɩsʋa 'nyrɛɛ lɛ pue, ‑tɛ ɔ nu, 'ɔ ya ꞊nʋ 'a lɛleenyɔ ye, kɔ, 'ɔ nue, 'ʋ 'ye 'yuplu a ‑gbɛ. 'Plɩɩ ‑tɔplɩ 'bii ꞊nʋ, Nyɩsʋa a lɛleenyɔ ꞊tu ꞊nʋ ye, kɔ 'waa ‑gbɛ, ʋ 'ye, ɩ 'bii a ‑gbɛ, 'ɛ mɔ ‑tɛɛ, 'ɩ nue. ");
INSERT INTO ted_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","‑Nyrɔwɩɩ ‑yehɛn‑yehɛn bɩ ‑hi, ‑ye ti ꞊nʋ ‑kɔ 'yri ʋ di 'o 'yuplu ꞊nʋ ye 'bɛ, ɩ nyre 'o ꞊o, 'ʋ 'bɩɔ ye, ‑ɛ 'we ꞊nɔ ye, ‑tɛ Moise a tetee po, ‑ɛ mɔ, 'yu 'bɔ kɔ ‑nyrɔwɩɩ ‑yehɛn‑yehɛn, ‑ye bʋ 'bɩɔ ye. ‑Ye ʋ ꞊tue 'yu a ‑gbɛ ‑Yusudʋ, ‑ʋ mɔ 'dʋ ꞊nʋ, Nyɩsʋa a lɛleenyɔ tɔɔ la 'a 'dii, ‑tɛ ɔ 'de la 'kwli 'mʋ a nɩɛ. ");
INSERT INTO ted_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","‑Tɛ ‑nyrɔwɩ ꞊de ‑hi, ‑ye ti nyre 'o ꞊o, 'ke Sosɛfʋ kɔ Mari 'hɛɛn bʋ ‑ha ‑cɔhlʋn, ‑ɛ die nu, Nyɩsʋa a ‑cɔhlʋnpinyʋ 'mu pi, 'ke 'o Nyɩsʋa ye, 'ke 'o Mari a 'oye'siilɛ a ‑ta 'mʋ. Nɛ‑ mɔ tete ‑ye, Nyɩsʋa ‑nye la 'a winwlɔn‑hɛnyɔ Moise, ti ‑hi la a ti 'yri la, 'ke 'o 'ɛ nɩ nyrʋgba, ‑ɔ ‑ŋla, a 'oye'siilɛ a ‑ta 'mʋ. ‑Ye ʋ gba 'yu nɩ, 'ke 'le Nyɩsʋa a 'kagblaka gbo, ‑ʋ nɩ 'le Jrusrɛdɩɔ 'mʋ, ‑ɛ die nu, ʋ 'muo 'le ‑ha, ʋ 'muo Nyɩsʋa ‑nyi, 'ke 'o 'a ‑kʋan a ‑ta 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","‑ɛ 'we ꞊nɔ ye, ‑tɛ ʋ nu la 'a 'crɩɩlɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: «'Ɛ nɩ nyrʋgba a ye‑hɛyu, ‑ɔ mɔ 'yu nyɩbɛyu, ʋ dio 'nɩ ‑ha, ʋ 'muo Nyɩsʋa ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","'Plɩɩ ɛ 'mʋ mu ‑hi, ‑ye ʋ pi ‑cɔhlʋn ꞊nʋ nɩ, Nyɩsʋa a tetee ‑hʋa, 'ke 'o nyrʋgba, ‑ɔ ‑ŋla a 'oye'siilɛ a ‑ta 'mʋ. ‑Cɔhlʋndʋ a ‑gbɛ, ʋ mɔ la ‑plijɩɩ 'hɔn, ‑hee' ‑hungbeii 'hɔn. ");
INSERT INTO ted_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ɛ kɔ ‑wɛ nahuon ꞊de, 'ɔ 'ti 'le Jrusrɛdɩɔ 'mʋ. 'A 'dʋ mɔ Simeɔ. Simeɔ a ‑gbɛ, 'a 'klɔ 'sii 'o ye, 'ɔɔ 'o Nyɩsʋa 'o ꞊tuu. Waanyɔ ꞊nʋ, Kʋkɔnyɔ Nyɩsʋa po la lɛ, ɔ di la 'le ya, ɔ 'mʋ 'a dakʋ waa, nɔ‑ kɔ 'ledidie Simeɔ a ‑gbɛ, ɔɔ ‑pre. 'Ke Nyɩsʋa a ‑Hihiu nɩ 'o ꞊nɔ ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nyɩsʋa a ‑Hihiu a ‑gbɛ, ʋ le la ꞊nɔ nɩ, ‑ɛ mɔ, ɔ 'deɛ bɔ 'kʋ, 'bɩa 'bɔ 'de Waanyɔ a ‑gbɛ 'ye. ");
INSERT INTO ted_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nyɩsʋa a ‑Hihiuu ‑do a ‑gbɛ, nʋ‑ kɔ 'klɩ nue, 'ɔ mu 'le Nyɩsʋa a 'kagblaka gbo. Bɔ nɩ 'klɛɛ 'o gbo, ‑ye ‑Yusu a bu kɔ 'a 'dii 'hɛɛn, ʋ di 'le ꞊le, 'ʋ ya 'le ‑Yusu a ‑gbɛ 'le, ‑ɛ die nu, ‑tɩ ꞊nʋ, Nyɩsʋa a tetee ꞊tu, ʋ 'mue nu. ");
INSERT INTO ted_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Bɔ 'yu 'klɛɛ, ‑ye ɔ ‑ha ꞊nʋ 'yuplu a ‑gbɛ kwa, 'ɔ 'blo kwa, 'ɔ ‑nyi Nyɩsʋa 'wio, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Kʋkɔnyɔ o, ‑n ‑wɛ 'le ‑bo daa 'klɛɛ 'le 'mʋ gbo nɩ, ꞊bo 'kʋ, 'ke 'le plɔ a bleelɛ 'kwli 'mʋ, ‑ɛ nue, dɛ ‑n po la 'le 'mʋ, ɛ mue kɛ ‑wɔn 'lu. ");
INSERT INTO ted_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Waanyɔ ꞊nʋ, ‑n po la lɛ, ‑n di 'le ya, 'ke 'o dakʋ 'bii a waalɛ a ‑ta 'mʋ, 'na 'yie 'yo kɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Waanyɔ a ‑gbɛ, nɔ‑ mɔ ‑nyrɛ. Nɔ‑ die nu, dakʋ 'bii, ʋ 'mue lɛ yrii, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa. Ɔ die ‑wɛ 'nɩ nu, ‑na dakʋ Yisraɛkʋɛ, ʋ 'mʋ ‑tɩ a 'yi'bʋaalɛ kɔ.» ");
INSERT INTO ted_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","‑Tɩ 'bii ꞊nʋ, Simeɔ ꞊tu, 'ke 'o ‑Yusu a ‑ta 'mʋ, ɩ saka 'a 'dii kɔ 'a bu 'hɛɛn nɩ. ");
INSERT INTO ted_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeɔɔ ‑do a ‑gbɛ, ɔ ‑hʋa Nyɩsʋa 'klɩ, 'ke bɔ nu la ꞊nɔ ꞊hapʋdɛ 'mʋ. ‑Ye kɛ ɔɔ 'klɛɛ Mari ye po: «Nyɩsʋa, ɔ le 'yu ‑gbo nɩ, kɛ nɔ ‑tʋtʋ ke, ‑ɛ die nu, nahuin 'plɔplɔ, 'ke 'le Yisraɛkʋɛ ‑hɛyri, ‑ʋ dio nʋa ye gbo po, Nyɩsʋa 'mu waa, kɛɛ, nahuin ꞊nʋ, ‑ʋ 'nɩnɩ dio nʋa ye gbo po, Nyɩsʋa 'mu ‑bati lɛ poo. 'Yu a ‑gbɛ, nɔ‑ die nahuin tɔɔ, ‑ɛ mɔ, Nyɩsʋaa nu ‑kʋan, kɛɛ, nahuin 'plɔplɔ die ke 'nɩ bla, 'ke bʋ po Nyɩsʋa a 'Yu a ‑gbɛ nʋa ye gbo. ");
INSERT INTO ted_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Kɛ'ɛ nɩ, ɔ di 'a nunue nu, nahuin 'plɔplɔ a ‑huhli‑tɩ ꞊nʋ, ʋʋ 'lu ‑wɔn lɛ ‑hie, ɩ 'mʋ pepe' 'mʋ bi. ‑Mɛ ‑ye, 'kla ‑di ‑mʋ ‑wliye 'ya, ɛ di ye 'we ‑tɛ bʋ 'nɩnɩ 'nyra wɛn ‑mʋ ta‑wɔnplie 'mʋ.» Kɛ Simeɔ po. ");
INSERT INTO ted_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ɛ kɔ ‑wɛ nyrʋgba ꞊de. 'A 'dʋ mɔ Hana. Ɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ. 'A bu a 'dʋ mɔ Fanɩɛ. Ɔɔ po Asɛ꞊tugba. Hana a ‑gbɛ, ɔ ‑wɛ la 'yi 'dɔ. ‑Tɛ ɔ 'kɩɛ 'yɛɛ la nyrɔkʋɛ 'mʋ, ɔ kɔ la tɔ. Ɔ kɔ ꞊nɔ 'hɛɛn, ʋ nu 'yrɩɩ 'nɩpata, 'plɩɩ 'a tɔ a ‑gbɛ a ‑tɩ 'ɩ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ɔ 'de 'klɛɛ lele tɔ kɔ, 'ɔ nɩ 'klɔ ‑nɩnɩ, 'ɔ ꞊cɛɛ 'yrɩ a (84) ‑wlɩɩ ‑hɛn ꞊tu 'o ‑hɛn. 'Ɛ nɩ ti, 'tɔ 'mʋ kɔ ‑nyrɛ 'mʋ, ɔ 'cipi 'le Nyɩsʋa a 'kagblaka gbo nɩ. Nyɩsʋa a ‑kʋan, ɔɔ nu, nɔ‑ mɔ bɔ ꞊ci, kɔ bɔ da Nyɩsʋa a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ɔ kɔ Simeɔ 'hɛɛn, ʋ nyre 'o tii ‑do 'yri, 'ɔ ‑nyi Nyɩsʋa 'wio, 'ke 'o ‑Yusu a ‑ta 'mʋ, kɔ, Jrusrɛ 'mʋ a nahuin 'bii ꞊nʋ, ‑ʋʋ ‑pre, 'ke Nyɩsʋa bɔ waa 'a dakʋ, nʋ‑ ɔɔ ‑Yusu a ‑tɩ ‑wɔn yrɛ na. ");
INSERT INTO ted_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","‑Tɛ Mari kɔ Sosɛfʋ 'hɛɛn, ʋ ‑wɔ ‑tɔplɩ 'bii ꞊nʋ, Nyɩsʋa a tetee ‑hʋa a nunue ‑wɔn, ‑ye ʋ ꞊hɩan ‑wɔn, 'ʋ mu 'le Galileblʋgba a 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Nasalɛtɩ, ‑ɔ mɔ 'waa 'dɩɔ. ");
INSERT INTO ted_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","'Yu ꞊nʋ, ʋ kɔ, ɔɔ 'nɩ ku, kɔ, 'ɔ nɩ 'klɩ 'mʋ, Nyɩsʋa 'ɔ ‑nyo ꞊tɔ. Nahuin 'bii, ʋ nye 'nɩ 'ye, ‑ɛ mɔ, Nyɩsʋa nʋɔ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","'Ɛ nɩ 'yrʋ, ‑Yusu a 'dii kɔ 'a bu 'hɛɛn, ʋʋ la 'mʋ mu Jrusrɛdɩɔ, lɛ'mimre, ‑ɛ mɔ Pakɩ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","‑Tɛ ‑Yusu kɔ la 'yrɩɩ ‑pu ꞊tu 'o 'hɔn, nɛ‑ mɔ 'a ye‑hɛwɔ, 'ke bɔ mu lɛ'mimredʋ a ‑gbɛ ke, ɔ kɔ 'a 'dii kɔ 'a bu 'hɛɛn, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ʋ nye lɛ nu. ");
INSERT INTO ted_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","‑Tɛ lɛ'mimre ‑wɛ 'le, ‑ye ‑Yusu a 'dii kɔ 'a bu 'hɛɛn, ʋ ꞊hɩan ‑wɔn, 'ʋʋ 'waa 'dɩɔ 'mʋ mu. Kɛɛ, ‑Yusu ‑mɛ ‑ye, ɔ 'diu ‑wɔn kʋɛ. 'Ke ɔ 'kɩɛ nɩɛ 'le Jrusrɛ 'mʋ. Kɛɛ, 'a bu kɔ 'a 'dii 'hɛɛn, ʋ 'die 'o dɛ ꞊de 'hʋɩn 'mʋ yi. ");
INSERT INTO ted_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ʋ ‑mɛ ‑ye, ʋ da, ‑Yusu kɔ 'hrunanyʋ ‑ye 'hɛɛn, nʋ‑ʋ mu. Bʋ na ‑nyrɔwɔ꞊gble a 'hru, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, ‑Yusu 'de 'le ꞊nʋ ‑hɛyri nɩ, 'ʋ ‑tʋa 'a lɛ꞊mʋmɔ gbo, 'ke 'le 'waa 'dʋkʋɛ kɔ 'waa yiyinyʋ ‑gbahlɔn. ");
INSERT INTO ted_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","‑Tɛ ʋ 'dio 'klɛɛ 'ye, ‑ye ʋ ꞊hɩan ‑wɔn, 'ʋ mu Jrusrɛ 'mʋ, 'ʋ ꞊mʋɔ 'yie 'mʋ lɛ ‑mɔmɔ, 'ʋ 'dio 'ye. ");
INSERT INTO ted_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","‑Nyrɔwɔ a ta a nɔnɔ 'mʋ 'klɛɛ, ‑ye ʋ 'yo nɩ, 'ke 'le Nyɩsʋa a 'kagblaka gbo, 'ɔ nɩ gbo, 'ke 'le ‑Juukʋɛ a teteitɔɔnyʋ ‑hɛyri, 'ɔ nyu nʋa ye gbo po, 'ɔ nyu ‑wɛ wlɔn lɛ ꞊gba. ");
INSERT INTO ted_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nahuin 'bii ꞊nʋ, ‑ʋ nɩ ‑tuo ke, ɩ saka ꞊nʋ nɩ, 'yu bɔ di lɛ 'mʋ nɩ, bɔ di ꞊tɔdʋ ꞊nʋ kɔ, kɔ, 'bʋʋ ꞊nɔ 'ɛ nɩ dɛ wlɔn ꞊gba, ‑tɛ ɔɔ 'a klɛ‑hɩhɩalɛ nu. ");
INSERT INTO ted_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","‑Tɛ 'a 'dʋkʋɛ 'yo, ‑ye ɩ saka ꞊nʋ nɩ, ‑ye 'a 'dii nɔ: «'Na 'yu, dɛ‑ kɔ ‑mɔ nu lɛ 'a nunue, ꞊nɩ po 'le ‑a mʋ hʋannʋ 'kwli 'mʋ 'le? ‑N bu kɔ 'mʋ 'hɛɛn, hʋannʋ 'kwli 'mʋ, 'ke ‑aa 'le ‑mʋ lɛ ꞊mɔɔ.» ");
INSERT INTO ted_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «A 'deɛ ba ꞊mɔ wɛn 'mʋ lɛ. Bɩ bi 'le 'a mʋ 'kwli 'mʋ, kɛ 'n di wɛn nɔ 'na Bu Nyɩsʋa a 'kagblaka gbo nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kɛɛ, ‑tɩ ꞊nʋ, ɔɔ ꞊nʋ ye ꞊tu, ʋ 'nɩ yrii ꞊le 'mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu kɔ ꞊nʋ 'hɛɛn, ʋ ꞊hɩan ‑wɔn, 'ʋ mu Nasalɛtɩ 'mʋ, ‑ɛ mɔ 'waa 'dɩɔ, 'ɔ nyu 'o ꞊tuu 'ɛ nɩ ti. ‑Tɔplɩ 'bii ꞊nʋ, ‑ɩ mue 'lu ‑wɔn, ɩ 'de 'a 'dii ‑wɔn ‑hri. 'A ꞊wlʋ 'bli kwa. ");
INSERT INTO ted_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","‑Ye ‑Yusuu la 'nɩ ku, kɔ, 'a ꞊tɔ 'ɔɔ la klɛ bii, kɔ, Nyɩsʋa kɔ nahuin 'hɛɛn, 'ʋ nʋɔ la 'mʋ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","‑Tɛ 'dai 'yrɩ ‑hi, 'ke Saan, ‑ɔ mɔ Sakali a 'yu, ɔ 'kɩɛ nɩɛ 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti, Nyɩsʋa 'ɔ dɔ, 'ke bɔ ꞊tu 'a ‑tɩ, 'ke 'o nahuin ye. Ti a ‑gbɛ 'yri, Romakʋɛ a 'kɩɩn gblaka Tibɛlɩ, 'a 'yrʋ a ‑pu ꞊tu 'o ꞊hun a 'yrʋʋ nɩ, ‑tɛ ɔ bi la gbata ke. Pʋsɩ Pilatɩ, nɔ‑ mɔ Sudeblʋgba a ‑gʋlʋnʋma. Helɔdɩ, nɔ‑ kɔɔ Galileblʋgba win ke. 'A ‑dɩayu Filipʋ, nɔ‑ kɔɔ Yituleblʋgba win ke, kɔ Trakonitɩblʋgba 'hɛɛn. Lisaniasɩ, nɔ‑ kɔɔ Abilɛnɩblʋgba win ke. Hanɩ kɔ Kaifʋ 'hɛɛn, nʋ‑ mɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblakɩ. ");
INSERT INTO ted_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","‑Ye 'klɛɛ, Saan a ‑gbɛ, ɔ bi wlɔn 'hru, 'ɔ mu 'le 'nie ꞊nʋ, ʋʋ Sudɛn daa nʋa 'mʋ, 'ɔ ‑tʋa 'blʋgba꞊tɩɔ ꞊nʋ a kenaalɛ gbo, ‑ɔ nɩ 'o 'nie nʋa 'mʋ. 'Bɔɔ 'prɛ, 'ɔɔ 'le win 'yaa, 'ɔɔ nahuin le, ɔ nɔ: «Ba yree, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ɛ mɔ, aa nu ‑tɔplɩ, ‑ɩ nyre 'yi lɛ, 'ke 'o Nyɩsʋa ye. Ba hie 'o 'yilɛnyre‑tɔplɩ a ‑gbɛ gbo, ba ‑nyi 'a nɩ 'klɔ 'bii Nyɩsʋa, Nyɩsʋa 'mʋ 'a nɩ 'yilɛnyre‑tɔplɩ 'wʋwla, 'mʋ 'a mʋ 'nie 'lu lɛ po!» ");
INSERT INTO ted_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","‑Tɛ Saan, ɔɔ ‑tɩ a ‑gbɛ ꞊tu, ‑ye ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Esai 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ti ꞊de ‑hi la a ti 'yri, ɩ nyre 'o ꞊o. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: «Nyɩsʋa nɔ 'nɩ: Nahuon ꞊de, ‑tɛ 'dʋ di 'le ye bii, 'kee nɩ, ɔ di 'le 'ti. 'Bɔɔ 'prɛ, ɔ 'mʋ 'le win 'yaa. Kɛ ɔ di po: Kʋkɔnyɔ a 'hru ꞊nʋ, ‑ʋ kɔ wlɔn ɔ di 'o na, ba 'siu 'o ye, 'plɩɩ Kʋkɔnyɔ a ‑gbɛ, ɔ 'mʋ 'le di. Ɛ 'we ꞊nɔ ye, 'a nɩ 'klɔ bɔ 'sii 'o ye, ‑ɛ die nu, a 'mʋ ‑wɔn ‑wɛ, 'plɩɩ Kʋkɔnyɔ 'mʋ 'le di ‑o. ");
INSERT INTO ted_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ba 'yie 'le 'nɩhannɩ 'bii ꞊nʋ lɛ, kɔ, ba wa dʋgbɩ 'bii ꞊nʋ, ‑ɛ die nu, 'hri 'mʋ ke gbo wɛɛn. 'Hri ꞊nʋ, ‑ɩ 'de 'o ye 'sii, ba 'sii ‑wɛ 'o ye, 'a dɛ ꞊nʋ, ‑ɛ nyre 'yi lɛ, ba ‑hlɛntie. ");
INSERT INTO ted_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","‑Ye Waanyɔ ꞊nʋ, Nyɩsʋa di 'le ya, nahuin 'bii, ʋ dio 'nɩ 'ye.» ");
INSERT INTO ted_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nahuin ‑huohui, nʋ‑ʋ 'le Saan ‑wɔn mu, ‑ɛ die nu, ɔ 'mu 'nie 'lu lɛ po. Kɛ ɔɔ nahuin a ‑gbɛ ye po, ɔ nɔ: «'A mʋ ꞊nʋ, aa kaa nahuin, 'a nɩ nunuklɔ 'ɔ nyre 'yi lɛ, ‑ɛ 'we ꞊nɔ hrei ye. Nyɩsʋa a yrʋ ‑wɛ lɛ kɛ 'a nɩ kikle. A nɩ po 'le lɛ, ‑ɛ mɔ, a ‑wɛ 'le ba 'gbʋ ye 'mʋ ci lɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","'Plɩɩ 'mʋ 'a mʋ 'nie 'lu lɛ po, ba nu ꞊hapʋdɛ, ʋ 'mue 'ye, ‑ɛ mɔ, a hie 'o dɛ 'kuku, aa nu gbo, 'a ‑nyi 'a nɩ dɩɔnʋ Nyɩsʋa. A nɩ po 'le lɛ, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ɛ mɔ, 'a mʋ mɔ Abrahamʋ a 'yuo, 'a ‑tɩ, Nyɩsʋa 'die 'le ‑wɛ bɔ poo 'a mʋ yrʋ lɛ. 'Nɩɩ 'a mʋ 'nɩ le, ‑ɛ mɔ, Nyɩsʋa ‑wɛ 'le ꞊le bɔ nu 'hɛ ‑gbo, bɛ ‑hɛ Abrahamʋ a 'yuo. ");
INSERT INTO ted_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ʋ ‑wɛ ‑wɔn, 'ke bʋ nu 'dugbi, bʋ hra 'ɛ nɩ tugbɛ ꞊de, ‑ɛ 'nɩnɩ tʋ 'kui, ʋ 'mue 'tɔ po. Ɛ ꞊hɛn 'nyrɛ, Nyɩsʋa ‑wɛ ‑wɔn, 'ke bɔ poo nahuin ꞊nʋ ‑bati lɛ, ‑ʋ 'nɩnɩ ꞊tuo 'o.» ");
INSERT INTO ted_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","‑Ye nahuin ꞊nʋ, ‑ʋ nɩ ‑tuo ke, kɛ ʋʋ po, 'ʋ nyo wlɔn ꞊gba: «Dɛ tio‑ ‑a di nu 'le?» ");
INSERT INTO ted_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔ kɔ wlawlɩɩ 'hɔn, bɔ ‑ha 'le wlawlʋʋ ‑do, bɔ ‑nyu nahuon ꞊nʋ, ‑ɔ 'de 'a dɛ kɔ. Nahuon 'bɔ nɩ 'o, 'bɔ kɔ dididɛ, bɔ ‑nyi 'a 'be ꞊nʋ, ‑ɔ 'de 'a dɛ kɔ.» ");
INSERT INTO ted_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ɛ kɔ ‑wɛ 'blʋwli'tɛnyʋ. Nʋ‑ mu ‑wɛ 'le ꞊nɔ ‑wɔn, ‑ɛ die nu, ɔ 'mu 'nie 'lu lɛ po, ʋ nɔ: «Tɔɔnyɔ, dɛ tio‑ ‑a di nu 'le?» ");
INSERT INTO ted_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «‑Tie ꞊nʋ, Romakʋɛ a ye'mʋnaanyʋ plɛ, nahuin bʋ 'pɛɛ, a nɩ pue 'le dɛ 'lu. 'A ‑tɛɛ, nɛ‑ ba 'tɛ.» ");
INSERT INTO ted_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ɛ kɔ ‑wɛ 'sɔyuo. Nʋ‑ mu ‑wɛ 'le ꞊nɔ ‑wɔn, ʋ nɔ: «‑A nɩ ‑gbɛ, dɛ tio‑ ‑a kɔ ‑ba nu 'le?» ‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «A nɩ nu 'le 'klɩ, a nɩ ‑ha 'le nahuin 'wli kwa lɛ, A nɩ po 'le nahuin hɩ ke, 'ke 'o dɛ ꞊nʋ, ʋ 'de nu a ‑ta 'mʋ, 'ke ʋ 'mʋ 'a mʋ 'wli ‑nyi a ‑tɩ. Kɛɛ, 'a nɩ 'pɛɛwli, ɩ nu ‑tɛɛ. A nɩ pui 'le 'klɛɛ lele 'yiyriwli ꞊de ke.» ");
INSERT INTO ted_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nahuin 'bii, ʋʋ 'nɩ ‑pre. Ʋ ‑mɛ ‑ye, ʋ nɔ 'nɩ, ‑bakla ꞊de, Saan, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, 'ke 'o 'a dakʋ a waalɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kɛ Saan nyu ye po, ɔ nɔ: «'Mɔ ‑gbo, 'niee nɩ, 'nɩɩ 'a mʋ 'lu lɛ po. Kɛɛ nahuon ‑ye di 'le di. Nɔ‑ di 'o 'mʋ ke 'mʋ kʋɛ. Nɔ‑ di 'klɩ ke nɩ, ɔ 'mʋ 'o 'mʋ 'mʋ ‑hi, 'ke 'le Nyɩsʋa a 'dʋ 'kwli 'mʋ. 'Na ‑gbɛ, 'n 'de nyɔ ꞊de, 'ke ꞊bo dio 'mʋ ‑hɛ, 'ke 'o 'ɛ nɩ ‑kʋandɛ ꞊de a ‑ta 'mʋ. Nahuon ꞊nʋ, ‑ɔ di 'le di, Nyɩsʋa a ‑Hihiu, nʋ‑ ɔ di 'a mʋ ‑nyi kɔ wʋnwlɩnna 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nahuon a ‑gbɛ, ɔ di ye 'we ꞊gbla'mʋlɛ꞊hloonnyɔ, ‑ɔ 'ble ‑ŋmahɛn kwa, ɔ di nu, ɔ 'mʋ ꞊gbla 'mʋ lɛ ꞊hloon, ɔ 'mʋ ꞊gbla ꞊nʋ gbo ꞊tu. Kɛɛ, 'a ‑pupui ꞊nʋ, ɔ di po 'tɔ, 'ke 'le na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ di jre.» ");
INSERT INTO ted_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kɛ Saan nu, 'ɔɔ nahuin ꞊tɔ a gblegblei 'mʋ lɛ po. Nɩ‑ kɔ 'kwli 'mʋ ɔ naa 'le, 'ɔ nyu Nyɩsʋa a ꞊hapʋtitie pue. ");
INSERT INTO ted_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Kɛɛ ‑ye ‑gʋlʋnʋma Helɔdɩ, nɔ‑ Saan ꞊hɛn 'nyrɛ, ‑ɛ nue, Helɔdɩ a ‑gbɛ, nɔ‑ ‑ha 'a ‑dɩayu nyrɔ kwa, kɔ, 'ɔ nu 'yilɛnyre‑tɔplɩ 'plɔplɔ ‑ye. ");
INSERT INTO ted_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","‑Tɛ Saan ꞊hɩɔn 'nyrɛ, ‑ye Helɔdɩ a ‑gbɛ, ɔ nu 'yilɛnyredɛ ‑ye. Nɛ‑ mɔ bɔ po Saan a ‑gbɛ ꞊jɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","‑Tɛ ʋ 'de Saan ꞊jɩ 'mʋ a pue, 'plɩɩ Saan 'mʋ nahuin 'bii 'nie 'lu lɛ mu po, ‑ye ‑Yusu a ‑gbɛ, ɔ nyre 'o ꞊o, Saan 'ɔ puo 'nie 'lu, ‑Yusu 'ɔ ‑tʋa Nyɩsʋa a dɩda gbo. Ɔ nɩ 'le Nyɩsʋa a dɩda 'kwli 'mʋ, yakɔ 'ɔ ‑ki wlɔn, ");
INSERT INTO ted_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","‑ye Nyɩsʋa a ‑Hihiu ꞊tɩɩ 'o ꞊nɔ 'lu, nahuin 'bii 'ʋ 'yu. Ɛ 'we ꞊nɔ ye, ‑tɛ ‑plija 'nɩnɩ ꞊tɩɩ 'o ꞊nɔ 'lu, 'plɩɩ 'ʋ 'wɔn Nyɩsʋa a wintɛ, 'ɛ ‑hɔn 'le yakɔ 'mʋ, 'ɛɛ lɛ po: «‑Mɔ mɔ 'na 'Yuu ‑do, 'n nʋɛ 'mʋ ‑tɛɛ. ‑Nɩɩ 'mʋ nue 'manʋ.» ");
INSERT INTO ted_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Dɛ a ‑gbɛ bɛ ‑hi, ‑ye ‑Yusu ꞊tu ‑kʋan ‑wlu. Ti a ‑gbɛ 'yri, ɔ ‑wɛ 'le bɔ kɔ la 'yrɩ a (30) ‑wlʋ ꞊tu 'o ‑pu nɩ. Nahuin a ꞊wlɩ nɔ 'nɩ, Sosɛfʋ, nɔ‑ mɔ 'a bu. Sosɛfʋ a ‑gbɛ a bunʋ a 'dʋɩ, nɩ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nyɩsʋa a ‑Hihiu kɔɔ ‑Yusu ke win 'bii, ‑Yusu a ‑gbɛ, 'ɔ ‑hɔn 'o 'nie ꞊nʋ nʋa 'mʋ, ‑ɛ mɔ Sudɛn, Nyɩsʋa a ‑Hihiu a ‑gbɛ, 'ʋ gbɔ 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti. ");
INSERT INTO ted_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","‑Ye 'kuo ‑hʋɩn a nyɩgblaka, ‑ɔ mɔ Satan, 'ɔ plɛ, ɔ 'mʋ ‑Yusu 'mʋ lɛ ꞊tɔ, ‑ɛ die nu, ‑Yusu 'mʋ ‑tɩ 'wla, 'ke 'o 'a Bu Nyɩsʋa ye, 'ɔ ꞊tʋɔ 'mʋ lɛ, 'ke 'le ‑nyrɔwɩ a ‑wlɩɩ 'hɔn 'kwli 'mʋ. ‑Nyrɔwɩ a ‑gbɛ 'mʋ, ‑Yusu ꞊ci nɩ. ‑Tɛ ɩ ‑hi, ‑ye kanʋ nyo nu. ");
INSERT INTO ted_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","‑Ye 'kuo ‑hʋɩn a nyɩgblaka nɔ: «'Bɩa ꞊nɩ 'ya Nyɩsʋa a 'Yu 'mʋ, le 'hɩɔ ‑gbo, bɔ ‑hɛ 'flɔɔ.» ");
INSERT INTO ted_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «Ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Ɛ 'de dididɛɛ ‑do, ɛ 'nɩ nue ꞊le, ‑tʋnahuon 'nɩ nɩ ꞊le 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye 'ke 'kuo ‑hʋɩn a nyɩgblaka gba 'le ‑Yusu dʋgba ꞊de 'lu, 'ɔ titie ꞊nɔ tii ‑do a ti 'yri ‑tʋtʋ ke a 'blʋgbɩ 'bii ꞊nʋ ye, ");
INSERT INTO ted_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ʋ nɔ: «'Blʋgbɩ ‑gbo a 'klɩ, kɔ 'a ‑tɩ a 'yi'bʋbʋa, 'n di ‑mʋ 'nɩ ‑nyi. Ɩ 'bii ‑gbo, ʋ ‑nyi 'mʋ nɩ. 'Na ‑gbɛ, nahuon 'nɩɩ ‑hʋa, nɔ‑ 'n nyi ‑wɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","'A ‑tɩ, 'bɩa ꞊nɩ bla 'mʋ kwlɩ ye gbo, 'ke 'o 'na 'o꞊tuulɛ a ‑ta 'mʋ, ɩ 'bii ‑gbo, ‑mɔ di kɔ.» ");
INSERT INTO ted_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «Ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: ‑Na Kʋkɔnyɔ Nyɩsʋaa ‑do, nɔ‑ kɔ ye ‑bo bla 'o kwlɩ gbo, 'ke 'o 'a 'o꞊tuulɛ a ‑ta 'mʋ. Nɔ‑ blɛ ‑tɩ a 'yi'bʋaalɛ ye.» ");
INSERT INTO ted_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye 'kuo ‑hʋɩn a nyɩgblaka gbɔ 'le Jrusrɛdɩɔ 'mʋ, 'ʋ 'yɔɔ 'le Nyɩsʋa a 'kagblaka ke, ʋ nɔ: «'Bɩa ꞊nɩ 'ya Nyɩsʋa a 'Yu 'mʋ, ‑ye ‑bo ꞊pluu 'le ꞊hlɔn, ");
INSERT INTO ted_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","‑ɛ nue, ʋ 'crɩɛ nɩ, ‑ɛ mɔ: ‑Na ‑tɩ, Nyɩsʋa di 'a lɛleenyʋ 'nɩ le, ʋ 'mʋ ‑mʋ 'yie ꞊tu, ");
INSERT INTO ted_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ʋ 'mʋ ‑mʋ klɩ, ‑ɛ die nu, ‑na bʋ 'nɩ ꞊han 'hɩɔ ye bi.» ");
INSERT INTO ted_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: ꞊Nɩ ꞊tɔ 'le ‑na Kʋkɔnyɔ Nyɩsʋa 'mʋ lɛ.» ");
INSERT INTO ted_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","‑Tɛ 'kuo ‑hʋɩn a nyɩgblaka ‑wɔ 'klɛɛ ‑Yusu a 'mʋlɛ꞊tɩtɔ ‑wɔn, 'ke 'le 'pɩ a gblegblei 'kwli 'mʋ, ‑ye ɔ ‑hɩɔ lɛ mɛ, 'ɔ mu 'o ti 'mʋ lɛ ‑pre wɔn, ‑ɩ kɔ 'yri ɔ dio 'o lele 'mʋ lɛ ꞊tɔ. ");
INSERT INTO ted_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu ꞊hɩan ‑wɔn, 'ɔ mu 'le Galileblʋgba 'mʋ. Nyɩsʋa a ‑Hihiu kʋɔ ke win 'bii, 'ʋ ‑nyi ꞊nɔ 'klɩ. 'A 'dʋ 'sɛɛ 'blʋgba 'bii ke gbo, ");
INSERT INTO ted_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","'ɔɔ Nyɩsʋa a ‑tɩ tɔɔ, 'ke 'le Nyɩsʋa a kayuo gbo, nahuin 'bii 'ʋʋ 'a ‑tɩ 'yi 'bʋaa. ");
INSERT INTO ted_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","‑Nyrɔwɔ ꞊de 'mʋ, 'ke ‑Yusu mu 'le Nasalɛtɩdɩɔ 'mʋ, ‑ɔ kɔ 'mʋ ɔ kuu 'le. ‑Wuwle‑nyrɔwɔ 'mʋ, 'ɔ pa 'le Nyɩsʋa a kayu gbo, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ɔ nye lɛ nu, 'ɔ 'ba ye 'mʋ, ‑ɛ die nu, ɔ 'mʋ Nyɩsʋacrɩɩnɩɛ ‑hre, ");
INSERT INTO ted_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","'ʋ ‑nyi ꞊nɔ 'crɩɩnɩɛ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Esai 'crɩɩ la, 'ɔ ꞊wlɛɛ, 'ɔ yɛ 'crɩɩnɩɛ꞊tɩɔ ꞊nʋ ke, ɔɔ wɛn lɛ ꞊mɔ. 'Crɩɩnɩɛ꞊tɩɔ a ‑gbɛ, 'a win, ɩ nɩ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«Nyɩsʋa a ‑Hihiu, nʋ‑ nɩ 'o 'mʋ ke 'mʋ, Nyɩsʋa 'ɔ ‑ha 'le 'mʋ du 'mʋ, 'ke ꞊bo pue 'a ꞊hapʋtitie nahuin ꞊nʋ, ‑ʋ nɩ wɔlɩ lɛ. Nyɩsʋa, ɔ le 'mʋ nɩ, 'ke ꞊bo le ꞊go, ‑ɛ mɔ, ɔ diu 'nɩ ꞊gbla. ꞊Bo le ‑wɛ 'yiisuanyʋ, ‑ɛ mɔ, ɔ die 'nɩ nu, ʋ 'mʋ lɛ yrii. ꞊Bo le ‑wɛ nahuin ꞊nʋ, ʋʋ ꞊sʋɛ ꞊tue, ‑ɛ mɔ, ɔ diu ‑wɛ 'nɩ ꞊gbla. ");
INSERT INTO ted_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","꞊Bo le ʋ 'bii, ‑ɛ mɔ, ti nyre 'o ꞊o, ‑ɩ kɔ 'yri Kʋkɔnyɔ di 'o ꞊nʋ tɔɔ, ‑ɛ mɔ, ɔ nʋʋ 'mʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","‑Tɛ ‑Yusu ‑wɛ ‑wɔn, ‑ye ɔ 'pla 'crɩɩnɩɛ nɩ, 'ɔ ‑nye Nyɩsʋa a kayu a ‑kʋannunyɔ, 'ɔ nɩ gbo. Nahuin 'bii, ‑ʋ nɩ 'le Nyɩsʋa a kayu gbo, ʋ 'wlaa 'le ꞊nɔ 'yii 'klɔ gbo. ");
INSERT INTO ted_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","‑Ye kɛ ɔ nyu lele ye po, ɔ nɔ: «'Crɩɩnɩɛ꞊tɩɔ ꞊nʋ, 'n ‑hre, a 'wɔn, ‑tɩ ‑gbo, ɔɔ ꞊tu, kɛkɛ ‑gbo, 'ke ɩ mue kɛ 'lu ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nahuin 'bii, ‑ʋ nɩ 'o, ʋ nɔ 'nɩ: «Ɔɔ 'nɩ 'prɛ ‑tɛɛ.» Ɩ saka ꞊nʋ nɩ, 'ke 'o 'yilɛnɔwintɛ, ɔɔ po a ‑ta 'mʋ, ʋ nɔ: «꞊Be nahuon ‑gbo, ɔ 'de Sosɛfʋ a 'yu?» ");
INSERT INTO ted_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","‑Ye ‑Yusu nɔ: «'N yie nɩ, ‑ɛ mɔ, a di 'mʋ ‑talʋdʋ ‑gbo ye 'nɩ po, ‑ʋ mɔ: ‑Data, pɩa ‑n dɩɔnʋ. Kɛ a di lele 'mʋ ye po: 'Ŋmilɛka‑tɔplɩ 'bii ꞊nʋ, ‑n nu 'le Kapɛnaɔdɩɔ 'mʋ, ‑a 'wɔn 'a ‑tɩ nɩ. Ɩ ‑do a ‑gbɛ, nui ‑wɛ, kɛ nɔ ‑na ‑gbɛ a 'dɩɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ɔ nɔ lele: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ɛ 'de Nyɩsʋa a winwlɔn‑hɛnyɔ ꞊de kɔ, ʋ kuo ꞊wlʋ ye, 'ke 'le 'a ‑gbɛ a 'dɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","'Nɩɩ lele 'a mʋ 'nɩ le, 'ŋmilɛka‑tɔplɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Elii la nu, bɩ bi 'le 'a mʋ 'kwli 'mʋ, ti ꞊nʋ ‑kɔ 'yri 'nu 'kee la didie, 'ɛ gba 'yrɩɩ ta, nɩ lɛ yakʋɛɛ ‑huonnɔ, kɔ, ‑tɛ kanʋʋ la ꞊tɩ, kɛ nɔ ‑tʋtʋ ke. Ti a ‑gbɛ 'yri, kotianyrʋ ‑huo la nɔ Yisraɛkʋɛ a 'blʋgba 'mʋ nɩ, 'ʋʋ la 'mʋ‑hɛɛlɛ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kɛɛ, ɛ 'de la 'a nahuon ꞊de kɔ, Nyɩsʋa bɔ lee la 'le Eli ‑wɔn, 'bɛ 'de kotianyrɔɔ ‑do ꞊nʋ ‑wɔn, ‑ɔ 'de Yisraɛkʋɛyrɔwlʋ. Nyrʋgba a ‑gbɛ, 'ke ɔ 'ti la 'le pʋpʋdakʋ ‑hɛyri, 'ke 'le Salɛtadɩɔ 'mʋ, ‑ɔ nɩ 'le Sidɔblʋgba 'mʋ, Eli a ‑gbɛ 'ɔ ‑hɩɔ 'mʋ, 'ke 'le 'ŋmilɛkadɛ 'kwli 'mʋ, ‑ɛ nue, kotianyrɔ, a ‑gbɛ, ɔ kuo la Nyɩsʋa ye ꞊wlʋ. ");
INSERT INTO ted_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","'Ya 'o lele 'lu, Nyɩsʋa a winwlɔn‑hɛnyɔ Elise a ti 'yri, ‑tɔplɩ‑jɔhʋɩnnunyʋ ‑huo la nɔ Yisraɛkʋɛ a 'blʋgba 'mʋ nɩ. Kɛɛ, Elise a ‑gbɛ, ɔ 'die la 'le ‑wɛ, bɔ ‑wɔ la nahuon ꞊de a 'kʋɛ, 'bɛ 'de nahuon ‑gbo, ‑ɔ mɔ Naama, ‑ɔ 'de Yisraɛkʋɛyu, ‑ɔ kɔ 'le Siliblʋgba 'mʋ. Nɔ‑ kɔ 'kʋɛ ɔ ‑wɔ la, ‑ɛ nue, ɔ kuo la Nyɩsʋa ye ꞊wlʋ.» ");
INSERT INTO ted_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'le Nyɩsʋa a kayu gbo, ‑tɛ ʋ 'wɔn ‑tɩ a ‑gbɛ, ‑Yusu ꞊tu, ‑ye ʋ bi 'mʋ lɛ yrʋ, ");
INSERT INTO ted_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","'ʋ 'ba ye 'mʋ, 'ʋ klo, 'ʋ ꞊tɩɔ 'dɩɔ 'mʋ, 'ʋ gbɔ 'le dʋgba ꞊nʋ 'lu, ‑ɔ kɔ 'lu 'waa 'dɩɔ nɩ 'o, ‑ɛ die nu, ʋ 'muo 'le ye 'nyraa, ɔ 'mʋ 'le ꞊hlɔn bii, ɔ 'mʋ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kɛɛ, 'ke ɔ naa 'le ꞊nʋ ‑gbahlɔn, 'ɔ mu. ");
INSERT INTO ted_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye 'ke ‑Yusu mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ kɔ 'dʋ mɔ Kapɛnaɔ, 'ke 'le Galileblʋgba 'mʋ. ‑Tɛ ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ nyre 'o, ‑ye 'ke ‑Yusu mu 'le Nyɩsʋa a kayu gbo, 'ɔ bi 'o, 'ɔɔ nahuin Nyɩsʋa a ‑tɩ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nahuin ꞊nʋ, ‑ʋ nɩ 'o, ɩ ka ꞊nʋ lɛ 'ŋmi, ‑Yusu bɔ di lɛ tɔɔlɛ nu, ‑ɛ nue, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ, 'ke ɔɔ 'le tɔɔ. ");
INSERT INTO ted_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ɛ kɔ nyɩbɛyu ꞊de. Nɔ‑ 'ku ‑hʋan nɩ 'o ke 'mʋ. 'Ke ɔ nɩ 'le Nyɩsʋa a kayu a ‑gbɛ gbo, 'ɔ ‑tʋa win a 'le'yaalɛ gbo, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Nasalɛtɩ 'mʋ a ‑Yusu, ‑ha ‑a mʋ mɛ lɛ, ꞊nɩ bi 'le 'le ‑a nɩ ‑tɩ ‑hɛyri. ‑N 'de ꞊le, ꞊mʋ ‑a mʋ gbo ‑wɔ. 'N yie nɩ, nahuon a gblo tio‑ ‑n 'ya. ‑Mɔ mɔ Nyɩsʋa a 'Yu, ‑mɔ ɔ lee nɔ.» ");
INSERT INTO ted_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Bɔ po 'klɛɛ lɛ, ‑ye ‑Yusu 'prɛɛ 'le 'ku ‑hʋan a ‑gbɛ ‑wɔn nɩ, ɔ nɔ: «Ma wien, 'plɩɩ ‑hɔn 'o nahuon ꞊nʋ ke 'mʋ!» 'ku ‑hʋan a ‑gbɛ, 'ʋ ‑hli nahuon a ‑gbɛ gbo, 'ke 'o nahuin 'bii ye, 'plɩɩ 'ʋ ‑hɔn 'o ꞊nɔ ke 'mʋ, 'ʋ mu, kɛɛ, ʋ 'de nahuon a ‑gbɛ dɛ 'klan ꞊de 'mʋ nu. ");
INSERT INTO ted_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","‑Ye nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'o, ɩ ka ꞊nʋ lɛ 'ŋmi. Kɛ ʋʋ yrɛ pupo, ʋ nɔ: «Dɛ a ‑gbɛ, ɛ mɔ dɛ'ɛ nɩ. Nahuon ‑gbo, 'a pupowin nɩ ke 'klɩ, 'plɩɩ, 'ɔ kɔɔ 'kuo ‑hʋɩn win ke. 'Bɔ lo, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ, bɔ ‑hɔn 'o nahuon ke 'mʋ, 'ɔɔ 'o 'mʋ ‑hɔn.» ");
INSERT INTO ted_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Dɛ a ‑gbɛ, nɛ‑ nue, ‑Yusu a 'dʋ 'ʋ 'sɛɛ gbo, 'ke 'le 'blʋgba 'bii ꞊nʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","‑Tɛ ‑Yusu ‑hɔn 'le Nyɩsʋa a kayu gbo 'mʋ, ‑ye 'ke ɔ mu 'le Simɔ (Piɛlɩ) a ‑tɛ. 'Ke ɔ yɛ 'le Simɔ a 'dɔɔ gbo, Simɔ a 'dɔɔ a ‑gbɛ, nɔ‑ kɔ 'hʋɩn hren 'dɔ. ‑Ye nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'o, ʋʋ ‑Yusu lɛ 'nɩ 'batɩ, 'ke bɔ nue, 'a 'hʋɩn bɩ 'kee, ");
INSERT INTO ted_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","‑Yusu 'ɔ ꞊jro 'lu 'mʋ gbo, 'plɩɩ, 'ke 'le win 'yaklɩ 'kwli 'mʋ, 'ɔ 'prɛɛ 'le 'hʋɩnhinhren a ‑gbɛ ‑wɔn, 'ke bɛ hren nyrʋgba a ‑gbɛ ‑wɔn. ‑Ye tii ‑do a ti 'yri, 'a 'hʋɩn 'kee nɩ, 'ɔ 'ba ye 'mʋ, 'ɔ pi 'waa dididɛ. ");
INSERT INTO ted_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","‑Tɛ 'yrʋ ‑wɛ 'le yakɔ 'mʋ lɛ, ‑tɛ ‑wuwle‑nyrɔwɔ ‑wɛ 'le, ‑ye nahuin 'bii ꞊nʋ, ‑ʋ kɔ kɩklanyʋ, 'kʋɛi a gblegbleii nu, 'ke ʋ gbʋ 'le ‑Yusu ‑wɔn, ‑Yusu 'ɔ po ʋ 'bii dabʋɩ 'lu gblɛ, 'ɔ ‑wɔ 'waa 'kʋɛi a ‑gbɛ, ");
INSERT INTO ted_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","'kuo ‑hʋɩn 'ɔ ‑hɔn 'o 'hʋɩnhrennyʋ 'plɔplɔ ke 'mʋ lɛ, 'kuo ‑hʋɩn a ‑gbɛ 'ɔɔ 'le win 'yaa, ɔ nɔ: «‑Mɔ mɔ Nyɩsʋa a 'Yu!» Kɛɛ ‑ye ‑Yusu 'prɔɔ 'le ‑wɔn, 'ke 'le win 'yaklɩkɔ 'kwli 'mʋ, 'ɔ lo, 'ke ɔ nɩ po 'le wun, ‑ɛ nue, 'kuo ‑hʋɩn a ‑gbɛ, ɔ yie nɩ, ‑ɛ mɔ, ‑Yusu, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'a dakʋ ye ya. ");
INSERT INTO ted_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ‑Yusu 'ba 'mʋ ye, 'ɔ mu 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti, nahuin a ꞊ji 'ʋ muo 'yie 'mʋ lɛ ꞊mɔ wɔn. ‑Tɛ ʋ yɔ 'klɛɛ ke, ‑ye ʋʋ ‑hʋa bʋ kɔ ye, ʋ nɔ: «꞊Nɩ ‑hɔn 'le nɔ ‑a mʋ 'hʋɩn 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ɔ ‑mɛ ‑ye, kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «꞊Hapʋtitie ꞊nʋ, ‑ɛ nyi ꞊tu, ‑tɛ Nyɩsʋaa nahuin a win a kekɔɔlɛ nu, 'n kɔ ꞊bo pue ‑wɛ 'dɩɛ ‑ye a nahuin; ɩ nɩ‑ kɔ ‑tɩ Nysɩʋa 'ɔ lee nɔ 'mʋ ‑tʋtʋ ke,» ");
INSERT INTO ted_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","‑Yusu 'ɔ bi ‑Juukʋɛ a 'blʋgba 'bii ꞊nʋ ke, 'ɔɔ Nyɩsʋa a kayuo gbo na, 'ɔɔ Nyɩsʋa a ‑tɩ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","‑Nyrɔwɔ ꞊de 'mʋ, 'ke ‑Yusu nɩ la 'le Galileblʋgba a 'yru nʋa 'mʋ, nahuin 'plɔplɔ 'ʋ ꞊gboo 'hʋɩn 'mʋ, ‑ɛ die nu, ʋ 'mʋ Nyɩsʋa a ‑tɩ 'wɔn. ");
INSERT INTO ted_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","'Ke ɔ nɩ 'klɛɛ 'o gbo, ‑ye ɔ 'ye 'blagbeii 'hɔn, 'ɩ nɩ 'le gbogbo ye. 'Blagbei a ‑gbɛ wlɔn, 'ke 'pʋpanyʋ ‑hɔn 'le 'mʋ, 'ʋʋ 'waa ‑tatɩ lɛ yra. ");
INSERT INTO ted_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","'Blagbei ‑a gbɛ, nɩ‑ kɔ 'yɛɛ ‑ye wlɔn ‑Yusu 'ya 'le, nahuin a ‑huhuo‑tɩ. 'Blagbe a ‑gbɛ, Simɔ, nɔ‑ kʋɛ, ‑Yusu 'ɔ 'bɔtɩɔ lɛ, 'ke bɔ 'yɩya 'le 'nie ke gbo dɛ gbi. ‑Tɛ ʋ 'yɩya 'le 'nie ke gbo, ‑ye ɔ nɩ gbo, 'ɔ ‑tʋa nahuin a ‑gbɛ Nyɩsʋa a ‑tɩ a tɔɔlɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","‑Tɛ ɔ ‑wɔ nahuin a tɔɔlɛ ‑wɔn, ‑ye ɔ le Simɔ nɩ, ɔ nɔ: «Bri, ‑ba mu 'le 'wlo ke, 'plɩɩ ‑n kɔ ‑n 'bienʋ 'hɛɛn, ba po 'a nɩ ‑tatɩ.» ");
INSERT INTO ted_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","‑Ye Simɔ ꞊tuo ‑wɔn, ɔ nɔ: «Tɔɔnyɔ o, 'tɔyrʋwɔ 'bii ‑gbo 'mʋ, ‑a 'ye ꞊sʋɛ, ‑a 'de dɛ ꞊de 'pa. Kɛɛ, ‑tɛ ‑n plɛ ꞊bo nue, 'n die 'nɩ nu,» ");
INSERT INTO ted_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","'ʋ po 'waa ‑tatɩ, 'ʋ klɩ ‑hrin. ‑Hrin ꞊nʋ, ʋ klɩ, 'a ‑huhuo‑tɩ, 'waa ‑tatɩ 'ɩ ‑tʋa lɛcɩcrɛlɛ gbo, ");
INSERT INTO ted_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","'ʋ po dabʋ, 'ʋ da 'waa 'bienʋ, ‑ʋ nɩ 'le 'blagbe ‑ye wlɔn, 'ke bʋ di ꞊nʋ 'mʋ ‑hɛ, 'ʋ di 'le, 'ʋ 'yie 'le 'blagbeii 'hɔn ‑wɛ a ‑gbɛ, 'ke 'o ‑hrin ‑wɔn. ‑Hrin a kwakukue a ‑tɩ, 'blagbei a ‑gbɛ, ɩɩ ‑hʋa bɩ pa. ");
INSERT INTO ted_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","‑Tɛ Simɔ, ʋʋ Piɛlɩ daa, ɔ 'ye dɛ a ‑gbɛ, ‑ye ɔ bla ‑Yusu ye gbo kwlɩ, ɔ nɔ: «Kʋkɔnyɔ, hren 'mʋ ‑wɔn, 'mɔ mɔ dɛ'kukununyɔ'ɔ nɩ!» ");
INSERT INTO ted_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kɛ'ɛ nɩ Simɔ po, ‑ɛ nue, ɔ 'ta 'mʋ gbo, ɔ kɔ 'a 'bienʋ 'pʋpanyʋ 'hɛɛn, 'ke 'o ‑hrin 'plɔplɔ ꞊nʋ, ʋ klɩ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Dɛɛ ‑do a ‑gbɛ, nɛ‑ mue 'lu ‑wɔn, 'ke 'o Sakɩ kɔ Saan 'hɛɛn ‑wɔn, ‑ʋ mɔ Sebede a 'yuo, ‑ʋ kɔ Simɔ 'hɛɛn, ‑ʋʋ ‑kʋan nu. Kɛɛ ‑ye ‑Yusu le Simɔ, ɔ nɔ: «꞊Nɩ pɩ 'le hʋannʋ. Kʋɛ kɛ 'klɛɛ mɔ gbo, ɛ 'de 'klɛɛ lele ‑hrin, ‑n 'deɛ ‑bo 'kukui lɛ, kɛɛ, ‑tʋnahuin, nʋ‑ ‑n di lɛ 'kukue, ‑ɛ die nu, ʋ 'mʋ 'na ‑naagbopʋ ‑hɛ.» ");
INSERT INTO ted_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","‑Tɛ ‑Yusu ‑yrɛ, ‑ye ʋ kwlɛɛ 'waa 'blagbei nɩ, 'ʋ hie 'o 'waa ‑tɔplɩ 'bii gbo, 'ʋ ‑tʋa 'a ‑wɔnnaalɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","‑Nyrɔwɔ ꞊de 'mʋ, 'ke ‑Yusu nɩ la 'le 'dɩɔ ꞊de 'mʋ. 'Ke 'le 'dɩɔ a ‑gbɛ 'mʋ, 'ke ‑tɔplɩ‑jɔhʋɩnnunyɔ nɩ 'le. 'A 'hʋɩn mɔ ꞊ji ‑gbʋgbɛ. ‑Tɛ ɔ 'ye ‑Yusu, ‑ye ɔ blɔ ye gbo kwlɩ, ɔ nɔ: «Kʋkɔnyɔ, 'nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, nue, 'na 'kʋɛ bɛ ‑wɛ!» ");
INSERT INTO ted_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","‑Yusu 'ɔ 'tʋɔ lɛ, ɔ nɔ: «'N nye 'nɩ ‑hʋa, ‑na 'kʋɛ bɛ ‑wɛ.» Tii ‑do a ti 'yri, ‑ye 'a 'kʋɛ ‑wɛ nɩ, ");
INSERT INTO ted_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","‑Yusu 'ɔ lo, ɔ nɔ: «꞊Nɩ ꞊tui 'le nahuon ꞊de ye gbe! Kɛɛ, mu ‑bo titie ‑n dɩɔnʋ Nyɩsʋa a ‑cɔhlʋnpinyɔ ye, ɔ 'mue 'ye, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ. 'A ‑tɩ, gba ‑tɔplɩ ꞊nʋ, ʋʋ nu, 'ʋʋ ‑cɔhlʋn pi, 'ke 'o Nyɩsʋa ye, ‑tɛ ‑a nɩ bu gblaka, ‑ɔ mɔ Moise, ɔ nu la 'a ꞊tutue ye‑hɛ‑nyrɛ 'mʋ, ‑ɛ die nu, nahuin 'bii, ʋ 'mui yi, ‑ɛ mɔ, ‑na 'kʋɛ ‑wɛ nɩ!» ");
INSERT INTO ted_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","꞊Hapʋkɔ, 'ɔ nu lɛ 'pʋprɛ, kɛɛ, ‑Yusu a 'dʋ a gbo'sɛɛlɛ bii ke, 'ke 'le 'blʋgba ꞊nʋ 'mʋ. Dɛ a ‑gbɛ a ‑tɩ, nahuin 'plɔplɔ 'ʋʋ ‑tɔplɩ 'mʋ lɛ ‑hɔn, 'ʋ nyo ye mu, ‑ɛ die nu, ʋ 'mʋ 'a win 'wɔn, kɔ, ‑Yusu 'mʋ 'waa 'kʋɛi ‑wɔ. ");
INSERT INTO ted_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kɛɛ, ɔ ‑mɛ ‑ye, ɔ ‑hɔn 'le 'mʋ nɩ, 'ɔ mu 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti, ‑ɛ die nu, ɔ 'mʋ Nyɩsʋa da. ");
INSERT INTO ted_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","‑Nyrɔwɔ ꞊de 'mʋ, 'ke ‑Yusu nɩ la 'le kayu ꞊de gbo, 'ɔɔ nahuin Nyɩsʋa a ‑tɩ tɔɔ. Falisi꞊tumu a nahuin, kɔ Nyɩsʋa a teteitɔɔnyʋ ꞊de 'hɛɛn, nʋ‑ nɩ 'le ꞊nʋ ‑gbahlɔn gbo. 'Ke ʋ ‑hɔn 'le Galileblʋgba kɔ Sudeblʋgba a 'dɩɛ 'bii 'mʋ, kɔ Jrusrɛdɩɔ 'mʋ, 'ʋ di 'le. Kʋkɔnyɔ Nyɩsʋa, ɔɔ ‑Yusu ‑nyi 'klɩ, 'ke bɔ ‑wɔ nahuin a 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Bʋ nɩ 'klɛɛ 'o gbo, ‑ye nahuin ꞊de, nʋ‑ nyre 'o, 'ʋ 'ble ‑hanmakɩ. ‑Hanmakɩ a ‑gbɛ, nɛ‑ kɔ 'kwli 'mʋ, 'ke ʋ pɩa 'le lɛ‑yɩyrɛnyɔ gbo, 'ʋ nye lɛ ꞊mɔ, 'ke bʋ pɔɔ 'le kayu gbo, ‑ɛ die nu, ʋ 'muo 'o ‑Yusu ye 'mʋ gbo ꞊tu. ");
INSERT INTO ted_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bʋ nyre 'le kayu a ‑gbɛ ye, nahuin a ‑huhue a ‑tɩ, ʋ 'nɩ 'ye ꞊le 'hru, 'ke bʋ paa 'waa nɩ lɛ‑yɩyrɛnyɔ kayu gbo. Nɛ‑ mɔ bʋ 'ya 'le kayu ke, bʋ ‑ha 'o 'hʋɔ. 'Ke ʋ naa 'o lɛ‑yɩyrɛnyɔ ꞊nʋ, ‑ɔ nɩ 'le ‑hanmakɩ wlɔn, 'ʋ ꞊tɩɔ 'o ‑Yusu ye, 'ke 'le nahuin ꞊nʋ ‑gbahlɔn, ‑ɛ die nu, ‑Yusu 'mue nu, 'a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","‑Tɛ ‑Yusu 'ye, ‑ɛ mɔ, nahuin a ‑gbɛ, ʋ kuo ye ꞊wlʋ, ‑ɛ mɔ, ɔ ‑wɛ 'le bɔ nue nɩ, 'waa nɩ lɛ‑yɩyrɛnyɔ a ‑gbɛ, 'a 'kʋɛ bɛ ‑wɛ nɩ, ‑ye ɔ lo nɩ, ɔ nɔ: «Nyɩbɛyu o, ‑tɔplɩ ‑gbo, ‑n nu, ‑ɩ nyre 'yi lɛ, 'ke 'o Nyɩsʋa ye, ɩ 'wʋwlɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","‑Ye teteitɔɔnyʋ, ‑ʋ nɩ 'o, ʋʋ 'mʋ lɛ 'nɩ 'pʋprɛ, ʋ nɔ: «‑Yusu ‑gbo, ɔɔ Nyɩsʋa a ‑tɩ lɛ 'nɩ ‑haa. Nahuon a gblo tio‑ ɔ 'ya 'klɛɛ 'mʋ? 'Plɩɩ ɔ nɔ 'nɩ, ɔ mɔ Nyɩsʋa'a nɩ. Nyɩsʋaa ‑do, nɔ‑ ‑wɛ 'le ‑bɔ 'wʋwla ‑tʋnahuin a dɛ 'kuku.» ");
INSERT INTO ted_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Dɛ ꞊nʋ, ʋʋ ꞊wlɩ klɛ naa, ‑Yusu yrie nɩ. Ɔ nɔ: «Dɛ tio‑ kɔ ꞊wlɩdʋ ꞊nʋ aa lɛ naa 'le? A 'de kɔ ba naa wɛn ꞊wlɩdʋ ꞊nʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","'A nɩ ꞊wlɩ nɔ 'nɩ, 'n 'die 'le ‑wɛ ꞊bo le nahuon ‑gbo, ‑ɛ mɔ, 'a dɛ 'kuku 'wʋwlɛ nɩ, kɔ, 'a nɩ ꞊wlɩ nɔ 'nɩ, 'n 'die ‑wɛ 'le ‑wɛ ꞊bo le ꞊nɔ, ‑ɛ mɔ, bɔ 'ba ye 'mʋ, bɔ na. ");
INSERT INTO ted_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Kɛɛ, 'mɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mɔ mɔ Nyɩsʋa a 'Yu, 'ɔ lee nɔ 'mʋ. Nyɩsʋa a ‑gbɛ, nɔ‑ ‑nye 'mʋ 'klɩ, 'ke ꞊bo 'wʋwla ‑tʋnahuin a dɛ 'kuku, kɛ nɔ ‑tʋtʋ ke, 'ɔ ‑nye ‑wɛ 'mʋ 'klɩ, 'ke ꞊bo ‑wɔ ‑tʋnahuin a 'kʋɛi. 'A ‑tɩ o, nahuon ‑gbo, ʋ ya 'le, 'n die 'nɩ nu, 'a 'kʋɛ 'mʋ ‑wɛ, a 'mue yrii, ‑ɛ mɔ, ‑tɩ ‑gbo, 'n ꞊tu wɛn 'a mʋ ye, ɩ mɔ ꞊hapʋkɔɔ nɩ.» ‑Ye ɔ ꞊hɩan ‑wɔn, 'ɔɔ 'le lɛ‑yɩyrɛnyɔ ꞊nʋ ‑wɔn 'prɛɛ, ɔ nɔ: «'Nɩɩ ‑mʋ 'nɩ le, 'ba ye 'mʋ, 'ba ‑na ‑hanmakɩ 'mʋ, ‑bo mu 'le ‑na kayu gbo, ‑na 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Tii ‑do a ti 'yri, nahuin nyo 'o ‑wɔn lɛ a tɛɛ, 'ɔ 'ba ye 'mʋ, 'ɔ 'ba 'a ‑hanmakɩ 'mʋ, 'ɔ 'hrɩ, 'ɔ mu 'le 'a kayu gbo, 'ɔɔ Nyɩsʋa 'nyrɛɛ lɛ pue. ");
INSERT INTO ted_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","‑Ye nahuin ꞊nʋ, ‑ʋ nɩ 'o, ɩ ka ꞊nʋ lɛ 'ŋmi, 'ʋ 'ta 'o 'mʋ gblɛ, 'ʋʋ Nyɩsʋa 'nyrɛɛ lɛ pue, ʋ nɔ: «‑A 'ye kɛ 'ŋmilɛka‑tɔplɩ gblakɩ.» ");
INSERT INTO ted_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusuu 'mʋ ꞊tɩ 'dɩɔ. Bɔɔ 'klɛɛ mu, ‑ye 'ke ɔ yɛ 'o 'blʋwli'tɛnyɔ ꞊de gbo. 'A 'dʋ mɔ Lefi, 'ɔ nɩ 'le 'blʋwli'tɛɛlɛ 'mʋ gbo. (Kɛɛ, nahuin 'nɩ ‑hʋa ꞊le 'blʋwli'tɛnyʋ, ‑ɛ nue, ʋʋ di 'yiyriwli.) ‑Ye kɛ ‑Yusu nyo ye po, ɔ nɔ: «Kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'na ‑naagbopʋyu ‑hɛ!» ");
INSERT INTO ted_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lefi a ‑gbɛ 'ɔ 'ba ye 'mʋ, 'ɔ hie 'o ‑kʋan 'bii gbo, ‑ɛ die nu, ɔ 'muo ‑wɔn naa. ");
INSERT INTO ted_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","‑Ye ɔ da ‑Yusu ‑wɔn dididɛ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ɔ da ‑wɛ 'a 'bienʋ 'blʋwli'tɛnyʋ 'plɔplɔ, kɔ pʋpʋnahuin ‑ye 'hɛɛn, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii. ");
INSERT INTO ted_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","‑Ye 'klɛɛ, Falisi꞊tumu a nahuin, ʋ kɔ Nyɩsʋa a teteitɔɔnyʋ 'hɛɛn, ‑ʋ mɔ ‑wɛ Falisi꞊tumu a nahuin, ʋ 'ye dɛ a ‑gbɛ, 'ʋʋ wlɔn lɛ 'pʋprɛ, 'ʋ le ‑Yusu a ‑naagbopʋ, ʋ nɔ: «Dɛ‑ nue 'klɛɛ, a kɔ 'blʋwli'tɛnyʋ kɔ nahuindʋ ‑ye ‑gbo 'hɛɛn, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, 'a nɩ 'o dɛdihuoo ‑do ke gbo 'le? A 'de wɛn ye blɛ ba nu wɛn dɛ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","‑Yusu bɔ 'wɔn ‑tɩ a ‑gbɛ, nɛ‑ mɔ bɔ po lɛ: «Nahuon ‑gbo, ‑ɔ kɔ 'hʋɩn nu ‑tɛɛ, ɔ 'nɩ ‑hʋa ꞊le ‑data a 'yiye, kɛɛ, nahuon ‑gbo, ‑ɔ kɔ 'hʋɩɩn‑ hren, nɔ‑ɔ ‑data a 'yiye ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","'N 'de 'le di, 'ke 'o nahuin ‑gbo a ‑ta 'mʋ, ‑ʋ plɛ, 'waa 'klɔ 'sii 'o ye, kɛɛ, nahuin ‑gbo, ‑ʋ yie, ‑ɛ mɔ, 'waa 'klɔ 'de 'o ye 'sii, nʋ‑ kɔ ‑tɩ, 'nɩ di 'le, 'mu le, ‑ɛ mɔ, bʋ hie 'o 'waa dɛ 'kuku, ʋʋ nu gbo, bʋ ‑nye 'waa 'klɔ 'bii Nyɩsʋa.» ");
INSERT INTO ted_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kɛ nahuin ‑ye, ʋʋ ‑Yusu ye po, ʋ nɔ: «Saan, ‑ɔɔ nahuin 'nie 'lu lɛ po, 'a ‑naagbopʋ, ʋʋ lɛ 'nɩ ꞊ci 'ɛ nɩ ti, 'ʋʋ Nyɩsʋa da. Dɛɛ ‑do a ‑gbɛ, nɛ‑ Falisi꞊tumu a nahuiin nu, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'waa tetee 'a ꞊tutue nu. Kɛɛ, ‑mɛ ‑ye, ‑n nɛ ‑naagbopʋ, ʋ 'nɩ ꞊ci ꞊le.» ");
INSERT INTO ted_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «Nyɩbɛyu ‑gbo, ‑ɔɔ 'blɩ 'mʋ pa, 'bɔ da 'a 'bienʋ 'blɩ'mʋpʋpa a dididɛ ke, 'bʋ mu 'blɩ'mʋpʋpa a ‑gbɛ a dɛdi‑tuo ke, 'a 'bienʋ a ‑gbɛ, nyɔ ꞊de 'nɩ lu ꞊le bʋ ꞊ci. Ɛ 'we ꞊nɔ ye, 'blɩ'mʋpʋpa ꞊nʋ, ɛ mɔ 'manʋdɛ'ɛ nɩ. 'A ‑tɩ, ʋ 'de ꞊cicie kɔ. Dɛɛ ‑do a ‑gbɛ, nɛ‑ɛ nɩ. 'Manʋ a ‑tɩ 'na ‑naagbopʋ 'nɩ ꞊ci ꞊le nɩ, tii ‑tie ‑gbo 'n di mɔ ꞊nʋ 'hʋɩn 'mʋ ‑hi. ");
INSERT INTO ted_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kɛɛ, ɛ di kɔ ti, ‑ɩ kɔ 'yri ʋ di 'o 'mʋ 'na ‑naagbopʋ ‑hɛyri ‑ha. Ti a ‑gbɛ 'yri, 'ke ʋ di ‑tado 'o ꞊cii.» ");
INSERT INTO ted_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","‑Ye ɔɔ lele ꞊nʋ ye po ‑talʋdʋ ‑ye, ɔ nɔ: «Nahuon ꞊de 'nɩ cra ꞊le wlawlʋ yrayrʋ, ɔ 'nɩ ‑ha ꞊le 'o 'a 'pɩa, ɔ 'nɩ ‑ma ꞊le da'ka a 'hʋɔ. 'Bɩa 'bɔ nue, ‑ye wlawlʋ yrayrʋ nyre lɛ 'yi, kɔ, 'a 'pɩa ꞊nʋ, ɔ nu, 'ɔ ‑ma wlawlʋ 'ka, ɔ kɔ ꞊nɔ 'hɛɛn, ɩ 'deɛ bɩ ‑mʋɛ. ");
INSERT INTO ted_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Mɔ, nahuon ꞊de 'nɩ 'ba ꞊le nɔ yrayrɩ 'mʋ, ‑ɔɔ 'plu, ɔ 'nɩ puo ꞊le 'le dahʋakɔ a buo 'ka wlɔn. 'Bɔ puo 'le buo 'ka ꞊nʋ wlɔn, 'bɔ kɔ ye, ti ‑kɔ ti 'yri ɔ di 'plu, 'bɔɔ 'ya, ‑ye ɔ cra dahʋakɔ a buo ꞊nʋ nɩ, ‑ye nɔ 'wlɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nɛ‑ nue, 'ke 'le dahʋakɔ a buo yrayrʋ wlɔn, 'ke ʋʋ 'le nɔ yrayrɩ po. ");
INSERT INTO ted_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Nahuon 'bɔ nɩ 'o, 'bɔ nʋɛ 'mʋ bɔ 'na nɔ 'kɩ, ɔ 'nɩ ‑hʋa ꞊le bɔ 'na nɔ yrayrɩ. Kɛ ɔ di po: Nɔ 'kɩ ꞊nʋ, nɔ‑ nɔ wlɔn, ‑ɔ ‑hi 'o nɔ yrayrɩ 'mʋ. (Ɛ nɛ‑ nue o, nahuon ꞊de 'nɩnɩ 'ba ‑tɔplɩ 'kɩ 'mʋ, 'ɔ 'nɩnɩ pui ‑tɔplɩ yrayrɩ ke. Ɩ 'nɩ bibi ꞊le 'yi 'mʋ lɛ.)» ");
INSERT INTO ted_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","‑Wuwle‑nyrɔwɔ ꞊de 'mʋ, ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn 'ʋ mu lɛ na wɔn. Bʋʋ 'klɛɛ mu, ‑ye ʋʋ ꞊tɩɔ 'bɛ 'dɩdɔ‑tɔplɩ ꞊de a ‑ci, ‑ɩ 'we ꞊nɔ ꞊gbla ye. Nɔ‑ kɔ 'hlɛ gbi 'a ‑naagbopʋʋ 'cɛ, 'ʋ nyi kwa 'mʋ gbo hunka, 'ʋ nyi di. ");
INSERT INTO ted_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","'Ke Falisi꞊tumu a nahuin ‑ye nɩ 'le ‑ci a ‑gbɛ 'mʋ. ‑Tɛ ‑Yusu a ‑naagbopʋ, ʋʋ 'dɩdɔ‑tɔplɩ ꞊nʋ a 'hlɛ gbi 'cɛ, ‑ye ʋ nyu 'klɛɛ 'nɩ le, ʋ nɔ: «Dɛ ‑gbo, aa nu, ɩ ꞊ŋa nɩ. Nyɩsʋa a tete nɔ 'nɩ, nahuon nɩ nu 'le ‑kʋan ‑wuwle‑nyrɔwɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","‑Ye ‑Yusu ꞊tu ꞊wɔn, ɔ nɔ: «‑Tɩ ‑gbo, ʋ 'crɩɩ la 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, 'ke 'o ‑a nɩ bu gblaka, ‑ɔ mɔ bodɩɔ Dafidɩ a ‑ta 'mʋ, 'n pui ‑tɛɛ, a ‑hri nɩ. ‑Tɩ a ‑gbɛ, ʋ 'crɩɩ la, nɩ‑ ‑gbo: ‑Nyrɔwɔ ꞊de 'mʋ, bodɩɔ Dafidɩ, ‑tɛ kanʋ nyo la nu, ɔ kɔ 'a nahuin 'hɛɛn, ");
INSERT INTO ted_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","'ɔ pa la 'le Nyɩsʋa a kayu gbo, 'ɔ ‑ha la 'o 'flɔɔ, ‑ɔ pɛ la 'o 'teble ke gbo, 'ɔ dio la, 'ɔ ‑nye la 'a dɛ ‑ye 'a nahuin, 'ʋ dio la ‑wɛ. 'Plɩɩ ‑ye tete nɔ 'nɩ, Nyɩsʋa a ‑cɔhlʋnpinyʋʋ ‑do, nʋ‑ ‑wɛ 'le ‑bʋ di 'flɔɔdʋ a ‑gbɛ. 'Be 'flɔɔdʋ a ‑gbɛ, ‑ɔ nɩ 'le Nyɩsʋa a kayu a ‑gbɛ gbo, ʋ ‑hɩɔ la nɩ, 'ke 'o Nyɩsʋa a ‑ta 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","‑Ye kɛ ɔ nyu lele ye po: «'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, Nyɩsʋa lee nɔ 'mʋ nɩ, 'ɔ ‑nye 'mʋ 'klɩ, 'ke ꞊bo le 'ɛ nɩ nahuon dɛ, ɔ ‑wɛ 'le bɔ nu, 'ke 'le ‑wuwle‑nyrɔwɔ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","‑Wuwle‑nyrɔwɔ ‑ye 'mʋ, ‑Yusu 'ɔ mu 'le lele Nyɩsʋa a kayu gbo, 'ɔɔ nahuin Nyɩsʋa a ‑tɩ tɔɔ. 'Ke ɔ yɛ 'le nyɩbɛyu ꞊de gbo, ‑ɔ kɔ diidɛdabʋ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Bʋ nɩ 'klɛɛ 'o, ‑ye Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋ nɩ 'o, ʋʋ ke gbaa 'yie, 'ʋʋ ‑Yusu 'ye, 'bɩa 'bɔ kɔ bɔ ‑wɔ nyɩbɛyu a ‑gbɛ a 'kʋɛ ‑wuwle‑nyrɔwɔ 'mʋ, ‑ɛ die nu, 'bɔ nue, ʋ 'muo ‑tɩ yɛɛ. (Falisi꞊tumu a nahuin nɔ 'nɩ, nahuon a 'kʋɛ a ‑wʋwɔ, ɛ mɔ ‑kʋaan nɩ. 'Plɩɩ Nyɩsʋa a tete nɔ 'nɩ, nahuon nɩ nu 'le ‑kʋan ‑wuwle‑nyrɔwɔ 'mʋ.) ");
INSERT INTO ted_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kɛɛ ‑ye ‑Yusu yrii 'waa 'lu a lɛ‑hielɛ nɩ. Nɛ‑ nue, 'ɔ le nyɩbɛyu a ‑gbɛ, ɔ nɔ: «'Ba ye 'mʋ, ‑bo nyra 'o nahuin ‑hɛyri 'mʋ gbo!» nyɩbɛyu a ‑gbɛ, 'ɔ 'ba ye 'mʋ, 'ɔ nyra 'o ꞊nʋ ‑hɛyri 'mʋ gbo. ");
INSERT INTO ted_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","‑Ye kɛ ‑Yusuu teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn ye po, ɔ nɔ: «'A mʋ 'nɩɩ wlɔn ꞊gba: ‑Be' Nyɩsʋa a tetee po 'le? Nahuon bɔ nu ꞊hapʋdɛ ‑wuwle‑nyrɔwɔ 'mʋ, kɔ, bɔ nu dɛ 'klan, dɛ tio‑ nu ‑tɛɛ 'le? Nahuon bɔ waa 'a 'be ‑wuwle‑nyrɔwɔ 'mʋ, ɔ 'nɩ ꞊han 'kʋ a ‑tɩ, kɔ, bɔ ‑ha 'a 'be a ‑hʋnhlʋn mɛ lɛ bʋ 'wan, dɛ tio‑ nu ‑tɛɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","'plɩɩ 'ɔɔ 'le ʋ 'bii 'yii 'mʋ lɛ ta. ‑Ye kɛ ɔɔ nyɩbɛyu a ‑gbɛ ye po, ɔ nɔ: «Srʋʋ ‑na dabʋ ꞊nʋ, ‑ʋ 'kʋ!» ‑Ye ɔ nue nɩ. Bɔ srʋʋ 'klɛɛ 'a dabʋ a ‑gbɛ, ‑ye ʋ 'hrɩ 'klɔ, 'ʋ bi 'o 'a dɩɔnʋ ꞊pɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","‑Tɛ ‑Yusu ‑wɔ 'klɛɛ nahuon a ‑gbɛ a 'kʋɛ, ‑ye Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin a ‑gbɛ 'hɛɛn, ʋ bi 'mʋ lɛ yrʋ 'dɔ, 'ʋ ‑tʋa ꞊tɔ a lɛ꞊mʋmɔ gbo, ‑tɛ ʋ di nu, ʋ 'mʋ ‑Yusu ‑balʋ 'mʋ nu. ");
INSERT INTO ted_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ti a ‑gbɛ 'yri, 'ke ɔ 'ya 'le dʋgba ꞊de 'lu, ‑ɛ die nu, ɔ 'mʋ Nyɩsʋa da. 'Ke ɔ ‑hi 'le 'tɔyrʋwɔ 'bii ꞊nʋ 'le, 'ke 'o Nyɩsʋa a dɩda a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ɔ da 'a ‑naagbopʋ nɩ, 'ke 'le ꞊nʋ ‑hɛyri, 'ɔ ‑ha 'le nahuiin ‑pu ꞊tu 'o 'hɔn, 'ɔ nyu 'a ‑wɔnnaanyʋ daa. ");
INSERT INTO ted_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nahuin a ‑gbɛ, nʋ‑ mɔ: Simɔ, ɔ ꞊tue Piɛlɩdʋ, ɔ kɔ Simɔ a ‑gbɛ a ‑dɩayu Adre 'hɛɛn, kɔ Sakɩ, kɔ Saan, kɔ Filipʋ, kɔ Batelemi, ");
INSERT INTO ted_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","kɔ Matie, kɔ Toma, kɔ Alʋfe a 'yu Sakɩ, kɔ Simɔ. Simɔ a ‑gbɛ, 'ke ɔ nɩ la 'le nahuin ꞊nʋ ‑hɛyri, ‑ʋ 'nɩnɩ ‑hʋa Romakʋɛ; ");
INSERT INTO ted_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","kɔ Sakɩ a 'yu Judɩ, kɔ Judɩa Yisikalio. Nɔ‑ mɔ nahuon ꞊nʋ, ‑ɔ di ‑Yusu ‑Juukʋɛ a ye'mʋnaanyʋ kwa po. ");
INSERT INTO ted_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusu ꞊tɩ 'le dʋgba 'lu nɩ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ʋ nyra 'o ‑tɛgbi ꞊nʋ gbo, ‑tɛ 'dʋ 'wlɛɛ 'o gbo. 'Ke 'o ‑tɛgbii ‑do a ‑gbɛ, 'ke ‑Yusu a ‑naagbopʋ 'plɔplɔ ‑ye, ʋ 'kukue wɛn 'o lɛ, ʋ kɔ nahuin 'plɔplɔ ‑ye 'hɛɛn. 'Ke ꞊ʋ ‑ye ‑hɔn 'le Jrusrɛdɩɔ 'mʋ, kɔ ‑Juukʋɛ a 'blʋgba 'bii ꞊nʋ ke, kɔ 'dɩɛ ‑ye ꞊nʋ, ‑ɛ nɩ 'le 'yru nʋa 'mʋ, ‑ɛ mɔ Tilɩdɩɔ kɔ Sidɔdɩɔ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ʋ di 'le ꞊le, ‑ɛ die nu, ʋ 'mʋ 'a win 'wɔn, kɔ, ɔ 'mʋ 'waa 'kʋɛi ‑wɔ, kɔ, nahuin ꞊nʋ, 'kuo ‑hʋɩn nɩ 'o ke 'mʋ, ɔ 'mʋ ‑wɛ 'waa 'kʋɛi ‑wɔ. ");
INSERT INTO ted_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nahuin 'bii, ʋ nye lɛ 'nɩ ꞊mɔ, 'ke bʋ 'tʋɔ lɛ, ‑ɛ nue, 'klɩ‑ɩ 'le ꞊nɔ 'mʋ ‑hɔn, 'ɩɩ 'waa 'kʋɛi 'bii ‑wɔ. ");
INSERT INTO ted_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑Yusu 'ɔ 'ba 'lu ye 'mʋ, 'ɔ ta 'le 'a ‑naagbopʋ ‑wɔn lɛ, ɔ nɔ: «'A mʋ ‑gbo, ‑ʋ mɔ ꞊sʋɛnyʋ, ‑ʋ mɔ 'na ‑naagbopʋ, ba kɔ plɔ a bleelɛ, ‑ɛ nue, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'o 'klɔ yrayrʋ nuu, a kɔ 'mʋ 'hɛɛn‑ di 'le 'klɔ yrayrʋ a ‑gbɛ 'kwli 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","'A mʋ ‑gbo, kanʋʋ nu, kɛ nɔ 'klɔ ke, ba kɔ plɔ a bleelɛ, ‑ɛ nue, kanʋ 'deɛ bʋ nu lele 'a mʋ. 'A mʋ ‑gbo, ‑ʋʋ we, kɛ nɔ 'klɔ ke, ba kɔ plɔ a bleelɛ, ‑ɛ nue, a di 'nɩ 'ca. ");
INSERT INTO ted_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","'Bɩa nahuin 'bʋ yraa 'a mʋ, kɔ, 'bʋ po 'le 'a mʋ ‑patʋ 'mʋ, kɔ, 'bʋʋ 'a mʋ tanɩ ꞊tu, kɔ, 'bʋʋ 'a nɩ 'dʋ 'yi lɛ nyre, ‑ɛ nue, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, a ‑hɛ 'na ‑naagbopʋ, 'bɩa 'baa ꞊sʋɛdʋ a ‑gbɛ 'ye, ‑ye ba kɔ plɔ a bleelɛ. ");
INSERT INTO ted_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ti ꞊nʋ ‑kɔ 'yri 'kla‑wliye'yɩya a ‑gbɛ, ɛ di 'o nyre, 'ke 'o 'a mʋ ‑wɔn, ‑ye ba nu 'manʋ, ba yi ‑wla, ‑ɛ nue, 'ke 'le yakɔ 'mʋ, Nyɩsʋa di 'a mʋ ‑nyi 'wio gblaka. 'Ɛ mɔ ‑tɛɛ, kɛ'ɛ nɩ, nahuin ꞊nʋ, ‑ʋ yraa 'a mʋ, 'waa bunʋ, ʋʋ la ‑wɛ Nyɩsʋa a winwlɔn‑hɛnyʋ a ꞊sʋɛ a ꞊tuelɛ nu.» ");
INSERT INTO ted_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kɛɛ ‑ye kɛ ‑Yusuu nahuin ꞊nʋ ye po, ‑ʋ 'nɩnɩ ꞊tuu 'o Nyɩsʋa, ɔ nɔ: «A ‑mɛ ‑ye, 'jrɔ 'ke 'o 'a mʋ ‑wɔn, ‑ʋ mɔ dɛkɔnyʋ, ‑ɛ nue, a 'ye 'a nɩ plɔ a bleelɛ nɩ ‑dodo. ");
INSERT INTO ted_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","'Jrɔ 'ke 'o 'a mʋ ‑wɔn, ‑ʋ kɔ kɛ didi‑tɔplɩ 'bii ꞊nʋ, aa ‑hʋa, kɛ nɔ 'klɔ ‑gbo ke, ‑ɛ nue, kanʋ di 'a mʋ 'nɩ nu. 'Jrɔ 'ke 'o 'a mʋ ‑wɔn, ‑ʋʋ kɛ 'ca, kɛ nɔ 'klɔ ‑gbo ke, ‑ɛ nue, a di lɛ nu wɔlɩ, a 'mʋ we. ");
INSERT INTO ted_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","'Jrɔ 'ke 'o 'a mʋ ‑wɔn, 'bɩa nahuin 'bii 'bʋʋ 'a nɩ ꞊hapʋ‑tɩ ꞊tu, ‑ɛ nue, nahuin ꞊nʋ, ‑ʋ yraa 'na ‑naagbopʋ, dɛɛ ‑do a ‑gbɛ, nɛ‑ 'waa bunʋʋ la ‑wɛ 'waa hɩwinwlɔn‑hɛnyʋ ‑wɔn nu, 'ʋʋ la ‑wɛ 'waa ꞊hapʋ‑tɩ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‑Ye kɛ ‑Yusuu lele po: «Ba po 'o nʋa gbo, a 'bii. 'Nɩɩ 'a mʋ 'nɩ le: Ba nʋɛ 'a nɩ yraanyʋ 'mʋ. Nahuin 'bʋ yraa 'a mʋ, ba nu ꞊nʋ ꞊hapʋdɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nahuin 'bʋ po 'a mʋ 'jrɔ ‑wɔn, nahuin 'bʋʋ 'a mʋ ꞊sʋɛ ꞊tue, ba da Nyɩsʋa, 'ke bɔ nu ꞊nʋ ꞊hapʋdɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nahuon 'bɔ po 'le ‑mʋ 'ŋma nʋa 'mʋ, titie 'o nʋa ‑ye 'o, ɔ 'mʋ ꞊ɔ ‑ye po. Nahuon 'bɔ ‑ha 'o ‑na 'kɔlɔ, ‑hɩɔ mɛ lɛ, bɔ gba ‑wɛ ‑na wlawlʋ ‑ye. ");
INSERT INTO ted_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nahuon 'bɔɔ ‑mʋ dɛ ‑hʋa, ‑nye ꞊nɔ. Nahuon 'bɔ ‑ha ‑mʋ ‑na dɛ kwa, ꞊nɩ ꞊gba 'le dɛ a ‑gbɛ a ‑tɩ wlɔn. ");
INSERT INTO ted_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","꞊Hapʋdɛ ꞊nʋ, aa ‑hʋa ‑tʋnahuin bʋ nu 'a mʋ 'mʋ, 'a nɩ ‑gbɛ, nɛ‑ ba nu ‑wɛ ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","'Bɩa 'ba nʋɛ nahuiin ‑do ꞊nʋ 'mʋ, ‑ʋ nʋɛ 'a mʋ 'mʋ, a nɩ po 'le lɛ, Nyɩsʋa di 'a mʋ 'nɩ baa. Mɔ, nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, ʋ nʋɛ ‑wɛ nahuin ꞊nʋ 'mʋ nɩ, ‑ʋ nʋɛ ‑wɛ ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nahuiin ‑do ꞊nʋ, ‑ʋʋ 'a mʋ ꞊hapʋdɛ 'mʋ nu, 'bɩa 'ba nyu ‑wɛ ꞊hapʋdɛ 'mʋ nu, a nɩ po 'le lɛ, ‑ɛ mɔ, Nyɩsʋa di 'a mʋ 'nɩ baa. Dɛɛ ‑do a ‑gbɛ, nɛ‑ nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, ʋʋ ‑wɛ nu. ");
INSERT INTO ted_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","'Bɩa 'baa nahuiin ‑do ꞊nʋ 'a nɩ 'wliyɛ ‑nyi, a yrii ti lɛ, ‑ʋ die de ‑mɩa, ʋ 'mue 'a mʋ ‑nyi, a nɩ po 'le lɛ, ‑ɛ mɔ, Nyɩsʋa di 'a mʋ 'nɩ baa. Nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, ʋ nyi ‑wɛ 'nɩ nu, 'ke 'le 'waa dɩɔnʋ ‑gbahlɔn, ‑ɛ nue, ʋ yie nɩ, ‑ɛ mɔ, 'waa 'bienʋ ꞊nʋ, ʋ di 'wliyɛ a ‑gbɛ de 'nɩ ‑mɩa, ʋ 'mue ꞊nʋ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Dɛ ba nu, nɛ‑ mɔ, ba nʋɛ 'a nɩ yraanyʋ 'mʋ, ba nu ꞊nʋ ꞊hapʋdɛ 'mʋ. 'Bɩa 'ba ‑nyi nahuin dɛ, a nɩ ꞊mʋɛ 'le lɛ, 'ke bʋ ‑mɩɛ de. 'Bɩa 'baa lɛ nu, Nyɩsʋa di 'a mʋ 'mʋ nu ꞊hapʋdɛ gblaka, kɔ, a di ‑hɛ Yrayrɩnyɩsʋa a ‑gbɛ a 'yuo, ‑ɛ nue, 'kuepanyʋ kɔ 'crɛnyʋ 'hɛɛn, ɔ nyu ‑wɛ 'mʋ nu ꞊hapʋdɛ. ");
INSERT INTO ted_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ba kɔ nahuin a wɔlɩ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'a nɩ Bu Nyɩsʋa nu, 'ɔ kɔ nahuin a wɔlɩ 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«A nɩ yɛɛ 'le 'a nɩ 'bienʋ ‑tɩ, ‑ɛ die nu, Nyɩsʋa 'nɩ ꞊han ‑wɛ 'a mʋ ‑tɩ yɛɛ. A nɩ ꞊hɛn 'le 'a nɩ 'bienʋ 'nyrɛ, ‑ɛ die nu, Nyɩsʋa 'nɩ ꞊han ‑wɛ 'a mʋ 'nyrɛ ꞊hɛn. 'Yilɛnyre‑tɔplɩ ꞊nʋ, nahuin, ʋʋ 'a mʋ 'mʋ nu, ba ‑hri 'a ‑tɩ ‑wɔn, ‑ɛ die nu, 'yilɛnyre‑tɔplɩ ꞊nʋ, aa nu, Nyɩsʋa 'mʋ ‑wɛ 'a ‑tɩ ‑wɔn ‑hri. ");
INSERT INTO ted_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","‑Tɔplɩ ꞊nʋ, 'a nɩ 'bienʋʋ ‑hʋa, ba ‑nyi ꞊nʋ, ‑ɛ die nu, Nyɩsʋa 'mʋ ‑wɛ 'a mʋ ‑tɔplɩ ꞊nʋ ‑nyi, aa ‑hʋa. 'Bɩa 'baa lɛ nu, ‑ye ɛ 'we ꞊nɔ ye, ‑tɛ nyɔ bɔ 'nɩnɩ sra wɛn ꞊gbla, ɔ 'muo 'a mʋ ‑nyi. ꞊Gbla'mʋsraapɔhlʋ ꞊nʋ, ɔɔ nu, 'ɔɔ ꞊gbla sra, ɔ diu 'le 'nɩ 'yie ‑tɛɛ, ʋ 'mʋ 'le ꞊gbla a ‑gbɛ 'a nɩ blɔ wlɔn po, ʋ 'muo 'le kɔɔ, kɔ ɔ 'mʋ blɔ gbo bla, ‑ɛ die nu, ʋ 'mʋ 'le 'a dɛ ‑ye po, blɔ 'mʋ 'le 'yii ‑tɛɛ. ‑Tɛ a di 'a nɩ 'bienʋ a 'yiye nu, kɛ Nyɩsʋa di ‑wɛ 'a nɩ 'yiye nu.» ");
INSERT INTO ted_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","‑Ye ‑Yusu po ꞊nʋ ye ‑talʋdʋ, ɔ nɔ: «'Yiisuanyɔ 'die 'le ‑wɛ bɔ 'ble 'a 'be 'yiisuanyɔ a dabʋ kwa, bʋ na 'hru. 'Bɩa 'bʋ nye nu, ‑ye ʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ di 'le wlɔn bi 'hʋɔ. ");
INSERT INTO ted_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ɛ 'de 'nyɩnyɩnyɔ ꞊de kɔ, ‑bɔ di 'o 'a tɔɔnyɔ 'lu ye nɩ. Kɛɛ, 'nyɩnyɩnyɔ ꞊nʋ, ‑ɔ 'nyɩ ‑tɛɛ, ‑tɛ 'a tɔɔnyɔ nɩ 'mʋ, kɛ ɔ di ‑wɛ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Dɛ‑ kɔ ‑tɩ, ꞊nɩɩ ‑n 'be a praprʋ ꞊nʋ 'ye, ‑ʋ nɩ 'le ꞊nɔ 'yi 'mʋ, 'plɩɩ ꞊nɩnɩ 'ye ‑wɛ ‑n nɛ tikla꞊tɩɔ ꞊nʋ, ‑ɔ nɩ 'le ‑mʋ 'yi 'mʋ? ");
INSERT INTO ted_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","‑N 'de ye blɛ ‑bo le ‑n 'be, ‑ɛ mɔ: Nɛ‑ ꞊bo ‑ha 'le praprʋ ꞊nʋ, ‑ʋ nɩ 'le ‑mʋ 'yi 'mʋ, ‑mɔ ꞊nʋ, ‑ɔ 'nɩnɩ 'ye tikla꞊tɩɔ ꞊nʋ, ‑ɔ nɩ 'le ‑mʋ 'yi 'mʋ? ‑Mɔ ꞊nʋ, ‑ɔɔ 'lii 'hɔn naa, ye‑hɛdɛ, ‑n kɔ ‑bo nu, ‑ha 'le ‑n nɛ tikla꞊tɩɔ ꞊nʋ 'yi 'mʋ, ‑ɛ die nu, ꞊mʋ lɛ yrii ‑tɛɛ, 'plɩɩ ꞊mʋ 'le praprʋ ꞊nʋ, ‑ʋ nɩ ‑n 'be ꞊nʋ 'yi 'mʋ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Kɛ ‑Yusuu lele po: «Tugbɛ ꞊nʋ, ‑ɛɛ ꞊hapʋ'nie ‑jri, ɛ 'deɛ bɛ tʋ 'kui ‑hʋɩn. Kɛɛ, tugbɛ ꞊nʋ, ‑ɛ 'nɩnɩ ‑jri ꞊hapʋ'nie, ɛ 'deɛ bɛ tʋ ꞊hapʋ'kui. ");
INSERT INTO ted_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tugbɛ a 'kuo, nɔ‑ ʋ nye yrii. Nahuon ꞊de 'nɩ ‑ha ꞊le bubuokui, 'ke 'le hɩnhranwu 'klɔ. Mɔ, nahuon ꞊de 'nɩ ‑ha ꞊le ‑wɛ ‑gbʋgbɔnʋ, 'ke 'o dakawi 'yri. ");
INSERT INTO ted_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","꞊Hapʋnahuon a nunu‑tɔplɩ nɔ lɛ 'yi, ‑ɛ nue, 'a ꞊wlʋ nɔ lɛ 'yi. Dɛɛ ‑do a ‑gbɛ, nɛ‑ɛ nɩ, 'ke 'o 'crɛnyɔ ‑wɔn. 'A nunu‑tɔplɩ nyre lɛ 'yi, ‑ɛ nue, 'a ꞊wlʋ nyre lɛ 'yi. ‑Tɩ ꞊nʋ, ‑ɩ 'yii 'le nahuon a ꞊wlʋ ke, nɩ‑ ɔɔ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «Dɛ‑ kɔ ‑tɩ, 'aa 'mʋ Kʋkɔnyɔ daa ti a pɛpɛ, 'plɩɩ ‑tɩ ꞊nʋ, 'nɩɩ ꞊tu, 'a 'nɩnɩ nui 'le? ");
INSERT INTO ted_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","'Ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɩ ‑gbo, 'nɩɩ ꞊tu, 'bɔ nyi nʋa ye gbo po, 'plɩɩ 'bɔ nyi nu, 'n di 'a mʋ 'nɩ le, nahuon, ɔ 'we ye. ");
INSERT INTO ted_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ɔ 'we ꞊nɔ nahuon ꞊nʋ ye, ‑ɔ ‑tʋa kayu a pupue gbo. Ɔ 'blu ‑tʋtʋ ‑blublu, 'ɔ yɛ 'hɩɔ 'pa ke. 'Ke ɔ po 'o kayu a ‑gbɛ, ‑ɛ die nu, ʋ 'mʋ gbo ku ‑tɛɛ. ‑Tɛ ɔ pu 'klɛɛ, ‑ye 'nie a 'yiyiti nyre 'o ꞊o, 'nie a ‑gbɛ 'ɛ ‑wɔn kayu a ‑gbɛ ye. Kɛɛ, ɛ 'de 'le 'a 'wʋwla ‑wɛ, ‑ɛ nue, ʋ ku gbo ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kɛɛ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɩ ‑gbo, 'nɩɩ ꞊tu, 'bɔ nyi nʋa ye gbo po, kɛɛ, 'bɔ 'nɩnɩ nui, ‑ye ɔ 'we ꞊nɔ nahuon ꞊nʋ ye, ‑ɔ 'de ‑tʋtʋ 'blu, ‑ɔ po 'a kayu. ‑Tɛ ɔ pu 'klɛɛ, ‑ye 'nie 'yi nɩ, 'ɛ ‑wɔn kayu a ‑gbɛ ye. ‑Ye tii ‑do a ti 'yri, kayu a ‑gbɛ, ʋ 'wlɛ nɩ, 'ʋ nyre 'yi lɛ 'bii.» ");
INSERT INTO ted_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","‑Tɛ ‑Yusu ‑wɔ 'le nahuin a ‑wɔn'prɛɛlɛ ‑wɔn, ‑ye ɔ mu 'le Kapɛnaɔdɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","'Ke 'le 'dɩɔ a ‑gbɛ 'mʋ, Romakʋɛ a 'sɔyuo a nyɩgblaka ꞊de nɩ 'le. Nɔ‑ kɔ ꞊wlʋ ‑ha 'le 'a ‑kʋannunyɔ ꞊de 'dɔ. ‑Kʋannunyɔ a ‑gbɛ, nɔ‑ kɔ 'hʋɩɩn‑ hren, ɔɔ mu 'nɩ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","‑Tɛ 'sɔyuo a nyɩgblaka a ‑gbɛ, ɔ 'wɔn ‑Yusu a 'ledi‑tɩ, ‑ye ɔ lee 'le ꞊nɔ ‑wɔn ‑Juukʋɛ a 'blʋ a nahuin ꞊de, 'ke bʋ lo, bɔ di 'le ꞊nɔ ‑wɔn, ɔ 'mʋ 'a ‑kʋannunyɔ a ‑gbɛ a 'kʋɛ ‑wɔ. ");
INSERT INTO ted_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","‑Juukʋɛ a 'blʋ a nahuin a ‑gbɛ, ‑tɛ ʋ nyre 'o ‑Yusu 'hʋɩn 'mʋ, ‑ye ʋ ‑tʋa 'a lɛ'batɩlɛ gbo 'dɔ, ʋ nɔ: «'Sɔyuo a nyɩgblaka ꞊nʋ, ɔ blɛ ye, 'ke ‑bo ‑hɩɔ 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","‑ɛ nue, ɔ nʋɛ ‑a nɩ dakʋ 'mʋ nɩ, kɔ, nɔ‑ ‑hɛ ‑a mʋ 'mʋ, 'ke ‑ba po Nyɩsʋa a kayu, kɛ nɔ ‑a nɩ 'dɩɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","‑Tɛ ʋ po 'klɛɛ lɛ, ‑ye ‑Yusu kɔ ꞊nʋ 'hɛɛn, ʋ mu nɩ. ‑Tɛ ʋ 'mʋɛɛ 'sɔyuo a nyɩgblaka a kayu yrɛ, ‑ye nyɩgblaka a ‑gbɛ, ɔ le 'a 'bie ‑ye, 'ke bʋ le ‑Yusu, ‑ɛ mɔ: «Tɔɔnyɔ o, 'nɩ ‑hʋa ꞊le ꞊bo ‑ha ‑mʋ 'ku 'mʋ. 'Mɔ ‑gbo, ‑ɔ 'de ‑Juukʋɛyu, 'n 'de ye blɛ ‑bo pa 'le 'na kayu gbo. ");
INSERT INTO ted_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Nɛ‑ nue, 'nɩ plɛ, ‑ɛ mɔ, ɛ 'de 'o lɛ nɔɔ, 'ke 'na ‑gbɛgbɛ ꞊bo mu wɛn 'le ‑mʋ ye. Kɛɛ, po wuun ‑do, 'na ‑kʋannunyɔ a 'kʋɛ 'mʋ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","'Na ‑gbɛ ‑gbo, 'n kɔ nyɩgblakɩ ‑ye, 'ʋ kɔɔ 'mʋ win ke. 'Mɛ ‑ye, 'n kɔ 'sɔyuo ‑ye, 'nɩ kɔɔ ꞊nʋ win ke. 'Bɩa 'nɩ po wun, 'nɩ le 'a nahuon, 'ke bɔ mu, ‑ye ɔɔ 'nɩ mu. 'Bɩa 'nɩ le ꞊ɔ ‑ye, 'ke bɔ di 'le, ‑ye ɔɔ 'le 'nɩ di. Kɔ, 'bɩa 'nɩ le 'na ‑kʋannunyɔ, 'ke bɔ nu dɛ, ‑ye ɔ nye 'nɩ nu.» ");
INSERT INTO ted_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","'Plɩɩ ‑Yusu 'mʋ win a ‑gbɛ mu 'wɔn, ‑ye ‑tɩ ꞊nʋ, 'sɔyuo a nyɩgblaka a ‑gbɛ, ɔ ꞊tu, ɩ saka ꞊nɔ nɩ, 'ɔ ꞊hɩan ‑wɔn, 'ɔ 'prɛɛ 'le nahuin ꞊nʋ ‑wɔn, ‑ʋ nyo ‑wɔn kʋɛ, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le: Nahuon, bɔ di lɛ 'na ꞊wlʋ a yekuolɛ nu, 'n 'de ‑hlɩn 'a nahuon a 'yee, ꞊betɩ bɛ 'ya nɔ Yisraɛkʋɛ a dakʋ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","‑Yusu bɔ ‑yrɛ, ‑ye 'sɔyuo a nyɩgblaka a leenyʋ ‑nɩ wɛn, ʋ ‑mɛ de. ‑Tɛ ʋ nyre 'le 'sɔyuo a nyɩgblaka a ‑gbɛ a kayu gbo, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, 'a ‑kʋannunyɔ ‑nɩ wɛn, 'a 'hʋɩn 'kee nɩ. ");
INSERT INTO ted_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ti gbi bɩ ‑hi, ‑ye 'ke ‑Yusuu 'le 'dɩɔ ꞊de 'mʋ mu. 'Dɩɔ a ‑gbɛ a 'dʋ mɔ Naɛ. Ɔ kɔ 'a ‑naagbopʋ kɔ nahuin ‑huohui ‑ye 'hɛɛn, nʋ‑ʋ 'hruu ‑do na, nʋ‑ʋ 'le 'dɩɔ a ‑gbɛ 'mʋ mu. ");
INSERT INTO ted_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","‑Tɛ ʋʋ 'o 'dɩɔ a ‑gbɛ a 'dɩmɩa 'yri mu nyre, ‑ye nahuin ‑hɔn 'le 'dɩɔ a ‑gbɛ 'kwli 'mʋ, 'ʋ 'ble 'kʋkʋku. 'Kʋkʋku a ‑gbɛ, ɔ mɔ 'a 'dii a 'yu nyɩbɛyuu ‑doo nɩ. 'A 'dii a ‑gbɛ, ɔ mɔ kotianyrɔɔ nɩ; 'dɩɔ a ‑gbɛ a nahuin ‑huohui 'ʋ ꞊glaa 'le nyrʋgba a ‑gbɛ 'le. ");
INSERT INTO ted_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","‑Tɛ Kʋkɔnyɔ ‑Yusu 'ye nyrʋgba a ‑gbɛ, ‑ye 'a wɔlɩ nyo nu. ‑Ye kɛ ɔ nyo ye po: «Po nʋa gbo ‑o!» ");
INSERT INTO ted_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","‑Ye ɔ 'yɩya 'o 'kɔfɩ a ‑gbɛ 'mʋ gbo 'hʋɩn, nahuin 'ble, 'ɔ 'tʋɛ lɛ, ‑ɛ die nu, ʋ 'mʋ gbo nyra. 'Kɔfɩ a ‑gbɛ, ɛ 'de ꞊ju kɔ. 'Plɩɩ ʋ 'mʋ gbo mu nyra, ‑ye kɛ ‑Yusuu 'kʋkʋku a ‑gbɛ ye po: «Gblotayu, 'nɩɩ ‑mʋ 'nɩ le, 'ba ye 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Tii ‑do a ti 'yri, ‑ye gblotayu a ‑gbɛ, ɔ ꞊wlɛɛ 'yii, 'ɔ 'ba ye 'mʋ, 'ɔ nɩ gbo, 'ɔ ‑tʋa 'pʋprɛ gbo. ‑Ye ‑Yusu 'ba 'a dabʋ 'mʋ nɩ, 'ɔ ꞊tuo 'le 'a 'dii kwa 'mʋ gbo. ");
INSERT INTO ted_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","'A ‑tɩ, nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'o, ɛ po 'le ꞊nʋ 'kwli 'mʋ hʋannʋ, 'plɩɩ 'ʋʋ Nyɩsʋa 'nyrɛɛ lɛ pue, kɛ ʋʋ po: «Nyɩsʋa a winwlɔn‑hɛnyɔ gblaka 'hrɩɩ nɔ ‑a mʋ ‑hɛyri, 'plɩɩ Nyɩsʋa a ‑gbɛgbɛ 'ɔ di 'a dakʋ 'mʋ ‑hɛ wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ɛ ‑do ꞊nʋ a ‑tɩ, ‑Yusu a 'dʋ ka 'le ‑Juukʋɛ a 'blʋgba 'bii ꞊nʋ nɩ, kɔ, 'ʋ ka ‑wɛ 'le 'blʋgbɩ a ꞊tɩɛ ‑ye ꞊nʋ, ‑ɩ ꞊glaa 'le ꞊nʋ. ");
INSERT INTO ted_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ti a ‑gbɛ 'yri, Saan, ‑ɔɔ la nahuin 'nie 'lu lɛ po, ('ke ɔ nɩ la 'le ꞊jɩ 'mʋ.) ‑Tɔplɩ 'bii a ‑gbɛ, ‑Yusuu nu, ɔɔ 'a ‑tɩ 'nɩ 'wɔn, ‑ɛ nue, Saan a ‑naagbopʋ, ʋ nyi ꞊nɔ ‑wɔn yrɛ 'nɩ na. Nɛ‑ nue, Saan a ‑gbɛ, 'ɔ da 'a ‑naagbopʋʋ 'hɔn ꞊de, ");
INSERT INTO ted_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","'ɔ luu 'le Kʋkɔnyɔ ‑Yusu ‑wɔn, ɔ nɔ: «Ba mu, ba ꞊gbɔ wlɔn, 'bɩa 'bɔ 'ya Waanyɔ ꞊nʋ 'mʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, ‑hee', ‑a 'kɩɛ die Waanyɔ a ‑gbɛ ‑pre?» ");
INSERT INTO ted_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","‑Tɛ ʋ nyre 'o ‑Yusu 'hʋɩn 'mʋ, ‑ye ʋ nɔ: «Saan Batisɩ lee ‑a mʋ nɩ, kɛ nɔ ‑mʋ ‑wɔn, ‑ɛ die nu, ‑a 'mʋ ‑mʋ wlɔn ꞊gba, 'bɩa ꞊nɩ 'ya Waanyɔ ꞊nʋ 'mʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, ‑hee', ꞊ba 'kɩɛ die Waanyɔ a ‑gbɛ ‑pre?» ");
INSERT INTO ted_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","‑Tɛ ʋ nyre 'o, ‑ye ʋ nye ‑wɛ 'nɩ 'ye, ‑ɛ mɔ, ‑Yusu, ɔɔ ‑wɔ nahuin 'plɔplɔ a 'kʋɛi, kɔ, 'ɔɔ 'kuo ‑hʋɩn 'plɔplɔ lɛ bla, ‑ɔ nɩ 'o nahuin ke 'mʋ, kɔ, 'ɔɔ 'yiisuanyʋ 'plɔplɔ a 'yii ke kla. ");
INSERT INTO ted_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","‑Ye kɛ ‑Yusu Saan a nahuin a ‑gbɛ ye po, ɔ nɔ: «Ba mu, ba le Saan dɛ ꞊nʋ, a 'ye, kɔ ‑tɩ ꞊nʋ, a 'wɔn. Ba lo, ‑ɛ mɔ, 'yiisuanyʋʋ lɛ 'nɩ yrii, kɔ, lɛ‑yɩyrɛnyʋʋ 'nɩ na, kɔ, ‑tɔplɩ‑jɔhʋɩnnunyʋ a 'kʋɛi, ɩɩ 'nɩ ‑wɛ, kɔ, 'kikenyʋʋ 'wɔn ‑tɩ, kɔ, 'kʋkʋnyʋ, ʋʋ lɛ 'hrɩ 'klɔ, kɔ, ꞊sʋɛnyʋ, ʋʋ Nyɩsʋa a ꞊hapʋtitie 'nɩ 'wɔn. ");
INSERT INTO ted_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Plɔ a bleelɛ 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ 'nɩnɩ blɛ ke, 'ke bɔ kuo 'mʋ ꞊wlʋ ye.» ");
INSERT INTO ted_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","'Plɩɩ Saan a leenyʋ 'mʋ ‑wɔn mu ꞊hɩan, ‑ye Saan a ‑tɩ, nɩ‑ ‑Yusuu ke 'prɛɛ, 'ke 'o nahuin ꞊nʋ ‑wɔn, ‑ʋ ꞊gbe 'o ꞊nɔ 'hʋɩn 'mʋ, ɔ nɔ: «Saan, ‑tɛ ɔɔ o Nyɩsʋa a ‑tɩ ꞊tu, 'ke 'le ‑tɛgbi ꞊nʋ, nahuin 'de 'le 'ti, ‑tɛ a mu o 'le ꞊nɔ ‑wɔn, nahuon tio‑ 'a nɩ ꞊wlɩ plɛ, a di o 'le gbo yɛ 'le? ꞊Be 'a nɩ ꞊wlɩ nɔ 'nɩ, a di o 'le gbo yɛ nahuon, ‑ɔɔ ‑tʋnahuin a hʋannʋ pɩ, 'ke bɔ ꞊tu ‑tɩ a ‑tɛɛ? 'Ʋʋn, ɛ 'de nahuondʋ a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","꞊Be 'a nɩ ꞊wlɩ nɔ 'nɩ, a di o 'le gbo yɛ nahuon, ‑ɔ pue 'yilɛnɔwlawlɩ? Kɛɛ, nahuin ꞊nʋ, ‑ʋʋ 'yilɛnɔwlawlɩ pue, kɔ, ‑ʋ kɔ 'ɛ nɩ dɛ, 'waa ꞊wlɩɩ ‑hʋa, 'ke ʋ nɩ 'le 'kɩɩnpʋ a kayuo gblɛ. ");
INSERT INTO ted_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","꞊Bo ꞊gba 'a mʋ wlɔn lele: Nyɔ tio‑ a mu o 'klɛɛ 'ye wɔn 'le? ꞊Be Nyɩsʋa a winwlɔn‑hɛnyɔ? Iin, 'nɩɩ 'a mʋ 'nɩ le, kɔ, 'nɩ nyi ꞊tu, Saan, ɔ ‑hi 'o Nyɩsʋa a winwlɔn‑hɛnyʋ ‑ye 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nɔ‑ mɔ nahuon ꞊nʋ, ‑ɔ kɔ ‑tɩ ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ, nɔ‑ di la 'na 'hru ye kla, 'plɩɩ 'mʋ la 'le di. ‑Tɩ a ‑gbɛ, ʋ 'crɩɩ la, ɩ nɩ‑ ‑gbo: Nyɩsʋa nɔ 'nɩ: 'Na 'yu o, 'n di ‑ha nahuon, 'ke 'o 'na ‑kʋan a ‑ta 'mʋ, ɔ 'mʋ mu, ɔ 'mʋ ‑na 'hru ye kla, 'plɩɩ ꞊mʋ 'le nyre. ");
INSERT INTO ted_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","'Nɩɩ 'a mʋ 'nɩ le, 'ke 'le ‑tʋnahuin 'bii ‑hɛyri, ɛ 'de ‑hlɩn nahuon ꞊de a kʋɛ, ‑ɔ nɩ 'o Saan 'lu ye. Kɛɛ ‑ye 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, nahuon ꞊nʋ, ʋʋ nahuon 'cicrɛ daa, nɔ‑ di 'o Saan 'lu ye nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «Nahuin 'bii, ʋ nyo la ye gbo po nʋa, ʋ kɔ 'blʋwli'tɛnyʋ 'hɛɛn, 'ʋʋ la Nyɩsʋa ꞊wɔn ‑nyi, kɔ, 'ʋ nye la ‑hʋa, 'ke Saan bɔ pu 'nie 'lu lɛ. ");
INSERT INTO ted_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kɛɛ, Falisi꞊tumu a nahuin, kɔ Nyɩsʋa a teteitɔɔnyʋ 'hɛɛn, dɛ ꞊nʋ, Nyɩsʋa ‑hʋa, 'ke 'o ꞊nʋ ‑wɔn, ʋ blɛ la ke, nɛ‑ nue, 'ʋ blɛ la ‑wɛ ke, 'ke Saan bɔ pu 'nie 'lu lɛ.» ");
INSERT INTO ted_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «‑Tɛ ti ‑gbo 'yri a nahuin nɩ 'mʋ, ɛ nɛ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ʋ 'we ꞊nɔ 'yuo꞊pli ye, ‑ʋʋ hru 'mre, 'ke 'o 'dika, ꞊ʋ ‑yee 'ʋʋ 'waa 'bienʋ ‑tɩ yɛɛ, ʋ nɔ: ‑Tɛ ‑aa 'blɩ 'ti, ‑aa 'blɩ'mʋpaalɛ a ‑wla bre, a 'de ‑wla di yi. 'Plɩɩ ‑tɛ ‑aa 'numu꞊hien we, a 'de we. ");
INSERT INTO ted_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ɛ 'we ꞊nɔ ye, Saan Batisɩ, ‑tɛ ɔ di la 'le, ɔɔ ꞊ke 'nɩ ꞊ci, 'ke 'o Nyɩsʋa a dɩda a ‑ta 'mʋ, 'ɔ 'nɩnɩ 'na nɔ, 'plɩɩ 'aa lɛ po: 'Ku ‑hʋan nɩɔ 'o ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","'Plɩɩ 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ‑tɛ 'n di 'le, 'nɩ ꞊ci ꞊le, 'nɩɩ nɔ 'na, 'plɩɩ 'aa lɛ po: Ba 'ye kɛ, nahuon ‑gbo, dididɛ kɔ nɔ a 'nɩnaa ‑do, nɛ‑ ɔɔ 'lu ‑wɔn lɛ ‑hie, 'plɩɩ ‑ye 'blʋwli'tɛnyʋ kɔ nahuin ‑ye 'hɛɛn, ‑ʋ kɔ 'klɔ, ‑ʋ 'de 'o ye 'sii, nʋ‑ kɔ ꞊nɔ 'hɛɛn‑ nɩnatumudɛ nu.» ");
INSERT INTO ted_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","‑Ye kɛ ‑Yusuu lele po: «Nahuin 'bii ꞊nʋ, ‑ʋ wɛɛn Nyɩsʋa a ꞊tɔ ke, ʋ nye 'nɩ yrii, ‑ɛ mɔ, Nyɩsʋa a ꞊tɔ a ‑gbɛ, ɔ 'sii 'o ye.» ");
INSERT INTO ted_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ɛ kɔ la Falisi꞊tumu a nahuon ꞊de. 'A 'dʋ mɔ la Simɔ. Nɔ‑ da ‑Yusu dɛ di wɔn. ‑Tɛ ʋ nɩ 'klɛɛ 'le kayu gbo, ‑ye ʋ nɩ gbo, 'ʋ ‑tʋa dɛ a didie gbo. ");
INSERT INTO ted_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","'Ke 'le 'dɩɔ a ‑gbɛ 'kwli 'mʋ, ɛ kɔ ‑wɛ nyrʋgba ꞊de, 'ɔ mɔ 'lalunyrɔ. ‑Tɛ ɔ 'wɩn, ‑ɛ mɔ, ‑Yusu mu di wɔn dɛ, 'ke 'le Simɔ ‑wɔn, ‑ye ɔ ya 'le 'yrɩɛ, ʋ nuu 'yilɛnɔhɩɔ 'mʋ. 'Ke 'le 'yrɩɛ a ‑gbɛ 'kwli 'mʋ, hʋnhrʋnponyra nɩ 'le; ");
INSERT INTO ted_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","'ɔ mu 'o ‑Yusu a bʋɩ ꞊hlɔn, 'ɔɔ we, 'a 'yii a mɩ 'ɩɩ 'o ‑Yusu a bʋɩ klɛ bi, 'ɔ nu 'a 'lu‑pupui, 'ɔɔ ‑Yusu bʋɩ lɛ 'hran, 'ɔ 'ble 'a bʋɩ kwa, 'ɔ nyi hʋnhrʋnponyra ‑nɩ wɛn lɛ 'wlaa. ");
INSERT INTO ted_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","‑Tɛ Simɔ ‑nɩ wɛn, ɔ 'ye dɛ a ‑gbɛ, ‑ye ɔɔ 'le 'a dɩɔnʋ a ꞊wlʋ ke 'nɩ 'prɛɛ, ɔ nɔ: «'Bɩa nahuon ‑gbo 'bɔ 'ya wɛn Nyɩsʋa a ‑tɛɛ a winwlɔn‑hɛnyɔ 'mʋ, ɔ di wɛn 'nɩ yi, ‑ɛ mɔ, nyrʋgba ‑gbo, ‑ɔ nyo lɛ 'tʋ, nahuon a gblo tio‑ bɔ 'ya 'mʋ. Ɔ di wɛn 'nɩ yi, ‑ɛ mɔ, 'lalunyrɔ'ɔ nɩ, ɔ 'de ye blɛ bɔ ‑hɩɔ mɛ lɛ, 'ke bɔ 'mʋɔɔ ye.» ");
INSERT INTO ted_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","‑Ye kɛ ‑Yusuu 'klɛɛ ꞊nɔ ye po, ɔ nɔ: «Simɔ, 'n kɔ ‑tɩ ꞊bo ꞊tu ‑mʋ ye.» ‑Ye ɔ nɔ: «Tɔɔnyɔ, po wun.» ");
INSERT INTO ted_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","‑Ye ‑Yusu nɔ: «Ɛ kɔ la dɛkɔnyɔ ꞊de. Nɔ‑ nahuiin 'hɔn 'trɔsɩ 'wliyɛ. Ye‑hɛnahuon a gba, ɔ mɔ 'wliyɛ ꞊nʋ, ‑kʋannunyɔɔ ‑do, ɔ ‑wɛ 'le bɔ 'ye, 'ke 'le ‑nyrɔwɩ a (500) ‑hɔtrʋwɩɩ ꞊hun 'kwli 'mʋ. Nahuon a 'hɔn a nɔnɔ a nɩ gba, ɔ mɔ 'wliyɛ ꞊nʋ, ‑kʋannunyɔɔ ‑do, ɔ ‑wɛ 'le bɔ 'ye, 'ke 'le ‑nyrɔwɩ a (50) ‑wlɩɩ 'hɔn ꞊tuo 'o ‑pu 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","‑Tɛ ʋ 'de 'wliyɛ kɔ, 'ke bʋ 'pɛɛ nyɩbɛyu ‑nɩ wɛn a gba, ‑ye nyɩbɛyu a ‑gbɛ, ɔ lu nɩ, ɔ nɔ: 'Na gba ‑nɩ o, ꞊betɩ ba 'dio 'pɛɛ, bɛ nɩ lɛ 'mʋ, 'n ‑hri 'a ‑tɩ ‑wɔn.» ‑Ye ‑Yusu ꞊gba 'klɛɛ Simɔ wlɔn, ɔ nɔ: «Ʋ 'hɔn ꞊nʋ ‑gbahlɔn, sɛyɩ‑sɛyɩ, nahuon tio‑ di nyɩbɛyu ꞊nʋ 'mʋ nʋɛ, ɔ 'mʋ 'o 'a 'be 'mʋ ‑hi 'le?» ");
INSERT INTO ted_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","‑Ye Simɔ nɔ: «'N pue ‑tɛɛ, nahuon ꞊nʋ, ‑ɔ kɔ gba gblaka a ‑tɩ ɔ ‑hri ‑wɔn, nɔ‑ɔ nɩ.» ‑Ye ‑Yusu nɔ: «'A ‑tɛɛ, nɛ‑ɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","‑Ye ɔ ꞊hɩan ‑wɔn, 'ɔɔ 'o nyrʋgba ‑nɩ wɛn ‑wɔn lɛ ta, ‑ye kɛ ɔɔ 'klɛɛ Simɔ ye po, ɔ nɔ: «'Ye kɛ nyrʋgba ‑gbo. ‑Tɛ 'n pa nɔ ‑na ‑tɛ, ‑n 'de ‑na ‑kʋannunyɔ le, 'ke bɔ yra 'na bʋɩ lɛ, ‑tɛ ʋ nye lɛ nu, kɛ nɔ ‑a 'bri. Kɛɛ, nyrʋgba ‑gbo, ɔ ‑mɛ ‑ye, ɔ nu 'a 'yii a mɩ, 'ɔ yra 'mʋ bʋɩ lɛ, kɔ 'ɔ nu 'a 'lu‑pupui, 'ɔ 'hrɩn lɛ. ");
INSERT INTO ted_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","'Ya 'o lele 'lu, ‑tɛ 'n pa nɔ ‑na ‑tɛ, ‑n 'de 'mʋ 'mʋ 'wlɛɛ, 'ke 'o 'na 'wio a gbopupue a ‑ta 'mʋ, ‑ɛ mɔ ‑a nɩ 'bridɛ. Kɛɛ, ‑tɛ 'n pa nɔ ‑mʋ ‑wɔn, nyrʋgba ‑gbo, ɔ ‑mɛ ‑ye, ɔ 'kɩɛ 'wlɛɛ kɛ 'na bʋɩ 'mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","‑N 'de 'mʋ 'nyra 'lu pue, ‑ɛ mɔ ‑a nɩ 'bridɛ, kɛɛ, ɔ ‑mɛ ‑ye, ɔ 'wlaa 'na bʋɩ lɛ hʋnhrʋnponyra. ");
INSERT INTO ted_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","'A ‑tɩ, 'nɩɩ ‑mʋ 'nɩ le, 'yilɛnyre‑tɔplɩ 'plɔplɔ ꞊nʋ, nyrʋgba ‑gbo, ɔ nu, Nyɩsʋa ‑hri 'a ‑tɩ ‑wɔn. Nɛ‑ nue, 'ɔ kɔ 'mʋnʋɛlɛ gblaka, 'ke 'o 'mʋ ‑wɔn. Kɛɛ, nahuon 'bɔ nɩ 'o, 'a 'yilɛnyre‑tɔplɩ ꞊nʋ, ‑ɩ kɔ ‑tɩ Nyɩsʋa ‑hri ‑wɔn, 'bɩ 'de ‑huo, ‑ye nahuon a ‑gbɛ a 'mʋnʋɛlɛ 'de ‑wɛ 'bʋa, 'ke 'o 'mʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","‑Ye kɛ ‑Yusu, ɔɔ nyrʋgba a ‑gbɛ ye po, ɔ nɔ: «Nyɩsʋa ‑hri ‑na dɛ 'kuku a ‑tɩ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye nahuin ꞊nʋ, ‑ʋ kɔ ‑Yusu 'hɛɛn ‑nɩ 'o dɛdihuo ke, ʋʋ 'mʋ lɛ 'nɩ 'pʋprɛ, 'ke 'le 'waa ꞊wlɩ ke, ʋ nɔ: «Nahuon a gblo tio‑ nahuon ‑gbo, ɔ 'ya 'mʋ 'le, 'ɔɔ lɛ po: Nyɩsʋa ‑hri ‑na dɛ 'kuku a ‑tɩ ‑wɔn?» ");
INSERT INTO ted_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","‑Ye kɛ ‑Yusuu lele nyrʋgba a ‑gbɛ ye po, ɔ nɔ: «‑N ‑wɛ 'le ‑bo mu nɩ, 'ke 'le plɔ a bleelɛ 'kwli 'mʋ, ‑ɛ nue, ‑tɛ ‑n kuo 'mʋ ꞊wlʋ ye, Nyɩsʋa ꞊gbla ‑mʋ nɩ, 'ke 'le dɛ 'kuku a 'klɩ gbo.» ");
INSERT INTO ted_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ti gbi bɩ ‑hi, ‑ye ‑Yusuu la klɛ na 'dɩɛ, 'ɔɔ la Nyɩsʋa a ꞊hapʋtitie po, ‑ɛ nyi ꞊tu, ‑ɛ mɔ, Nyɩsʋa di nahuin ke kɔɔ win. 'A ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ, ");
INSERT INTO ted_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ʋ kɔ nyrʋgbapʋ ꞊de 'hɛɛn, nʋ‑ nyo ‑wɔn naa. Nyrʋgbapʋ a ‑gbɛ, nʋ‑ kɔ ke 'mʋ ɔ bla la 'o 'kuo ‑hʋɩn lɛ, kɔ, 'ɔ ‑wɔ la 'waa 'kʋɛi. Nyrʋgbapʋ a ‑gbɛ, 'waa 'dʋɩ, nɩ‑ ‑gbo: Mari, ʋʋ Madala 'mʋ a Mari daa; nɔ‑ kɔ ke 'mʋ ‑Yusu bla la 'o 'kuo ‑hʋɩɩn 'nɩpata lɛ; ");
INSERT INTO ted_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","kɔ 'kɩɩn Helɔdɩ a kayu'yie꞊tunyɔ Kusa a nyrɔ, ‑ɔ mɔ Sanɩ, kɔ Sisanɩ, kɔ nyrʋgbapʋ 'plɔplɔ ‑ye 'hɛɛn. Nyrʋgbapʋ 'bii a ‑gbɛ, ʋ mɔ dɛkɔnyrʋ'ʋ nɩ, 'ʋʋ 'waa kʋkɔ‑tɔplɩ nu, 'ʋʋ ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn 'mʋ ‑hɛ. ");
INSERT INTO ted_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","'Ɛ nɩ 'dɩɔ 'bɔ nɩ 'o, 'ke nahuiin 'le 'mʋ ‑hɔn, 'ʋʋ ‑Yusu ye mu, nahuin 'plɔplɔ 'ʋ ꞊glaa 'le ꞊nɔ. ‑Ye ɔ nyu ye po ‑talʋdʋ, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Ɛ kɔ la ‑nyrɔwɔ ꞊de, nyɩbɛyu ꞊de, 'ɔ mu la 'a ‑tɔplɩ 'dɔ wɔn. Ɔ nyi lɛ 'nɩ ‑gbla, 'ke 'le 'a ‑ci 'kwli 'mʋ. ‑Tɛ ɔ nyi lɛ ‑gbla, ‑ye 'ke ꞊ɩ ‑ye bi 'o 'hru wlɔn lɛ, nahuin 'ʋ nyi klɛ na, nʋblɩ 'ɩ di 'le, 'ɩ di. ");
INSERT INTO ted_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Gblo a 'hɔn a nɔnɔ, ɔɔ lɛ ‑gbla, ‑ye 'ke ɔ bi 'o ‑tʋtʋtɩɔ ꞊nʋ ke, ‑ɔ kɔ gbo 'hɩɔ 'pa nɩ 'le, 'ɔ ‑hlɛntie ‑tɛɛ, 'ɔ ꞊ga ‑wɛ. Kɛɛ, ‑tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga, ‑ye ɩ 'yrɔ nɩ, ‑ɛ nue, ‑tʋtʋtɩɔ a ‑gbɛ, ɔ 'de 'nie kɔ. ");
INSERT INTO ted_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Gblo a ta a nɔnɔ, ɔɔ lɛ ‑gbla, ‑ye 'ke ɔ bi 'le 'witi a ꞊gagɛi ‑gbahlɔn. ‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga, ‑ye 'witilili ꞊nʋ, ɩ 'ya 'o ꞊o, 'ɩ 'bui 'lu lɛ. ");
INSERT INTO ted_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Gblo a ‑hɛn a nɔnɔ, ɔɔ lɛ ‑gbla, nɔ‑ bi 'o ꞊hapʋ‑tʋtʋ ke. ‑Tɛ 'dɩdɔ‑tɔplɩ a ‑gbɛ, ɩ ꞊ga, ‑ye ɩ ku nɩ ‑tɛɛ, 'ɩ po 'hlɛ. 'A 'hlɔɔ ‑do, ɔ po 'yɔ a (100) ‑wlɩɩ ꞊hun.» ‑Ye kɛ ‑Yusu nyu 'klɛɛ ye po: «'Bɩa 'ba kɔ ‑tɩ'wɔnnʋa, ‑ye ba 'wɔn ‑tɩ ‑dodo.» ");
INSERT INTO ted_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","‑Ye ‑Yusu a ‑naagbopʋ nyo wlɔn 'nɩ ꞊gba, ʋ nɔ: «‑Talʋdʋ ‑gbo, ‑n po 'klɛɛ, dɛ tio‑ ʋ ꞊hɛn 'nyrɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","‑Ye ɔ nɔ: «'A mʋ ‑gbo, ‑ʋ mɔ 'na ‑naagbopʋ, Nyɩsʋa nye 'nɩ nu, 'aa Nyɩsʋa a ‑tɩ 'mʋ lɛ yrii, ‑tɛ ɔɔ nu, 'ɔ kɔɔ nahuin win ke. Nyɩsʋa a ‑tɩ a ‑gbɛ, ɩ ‑hli nahuin ke 'yi. Nahuin ‑gbo, ‑ʋ 'nɩnɩ naa 'mʋ ‑wɔn, ʋ ‑mɛ ‑ye, 'ke ʋ nyi 'le ‑talʋdʋɩɩ ‑do 'kwli 'mʋ 'wɔɔn. Ɩ ‑do a ‑gbɛ, nɩ‑ ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Ʋ nyi 'nɩ 'ye ‑tɛɛ, kɛɛ, ʋ 'nɩ yrii ꞊le lɛ, 'ʋ nyi ‑wɛ 'wɔn ‑tɛɛ, kɛɛ, ʋ 'nɩ yrii ꞊le 'mʋ lɛ.» ");
INSERT INTO ted_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","‑Ye ɔ nyu lele 'nɩ le, ɔ nɔ: «Dɛ ꞊nʋ, ‑talʋdʋ a ‑gbɛ, ʋ ꞊hɛn 'nyrɛ, nɛ‑ ‑gbo: 'Dɩdɔ‑tɔplɩ ꞊nʋ, nɩ‑ mɔ Nyɩsʋa a wintɛ. 'Dɩdɔnyɔ ꞊nʋ, nɔ‑ mɔ nahuon ‑gbo, ‑ɔɔ Nyɩsʋa a wintɛ ‑wɔn lɛ na. ");
INSERT INTO ted_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","‑Ye 'hru ꞊nʋ, ‑ʋ kɔ wlɔn ɩ bi 'o lɛ, 'plɩɩ nʋblɩ 'ɩ di 'le, 'ɩ di, nʋ‑ mɔ nahuin ‑gbo, ‑ʋʋ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ 'kuo ‑hʋɩn a nyɩgblaka, 'ɔɔ 'le di, 'ɔɔ 'le ꞊nʋ Nyɩsʋa a wintɛ a ‑gbɛ ꞊wlʋ ke ‑ha, ‑ɛ die nu, ʋ 'nɩ ꞊han Nyɩsʋa a wintɛ a ‑gbɛ ꞊wlʋ ye kuo, Nyɩsʋa 'nɩ ꞊hiun waa. ");
INSERT INTO ted_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","‑Ye ‑tʋtʋtɩɔ ꞊nʋ, ‑ɔ nɩ 'o 'hɩɔ 'pa ke, ‑ɔ kɔ ke 'dɩdɔ‑tɔplɩ ‑ye ꞊nʋ, ɩ bi ‑wɛ 'o, nɔ‑ mɔ nahuin ‑gbo, ‑ʋʋ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ ‑ʋ nye ke wɛɛn, 'ke 'le plɔ a bleelɛ 'kwli 'mʋ, 'plɩɩ ‑ʋ nye ‑wɛ ꞊wlʋ ye kuo, 'ke 'o ti 'cicrɛi gbi ‑wɔn. Kɛɛ, ʋ 'nɩ ‑hʋɛ ꞊le, 'ke bɛ po 'ma, 'ke 'le ꞊nʋ ꞊wlʋ ke. Nahuin a ‑gbɛ, ti ꞊nʋ ‑kɔ 'yri 'kuo ‑hʋɩn a nyɩgblaka nyu 'mʋ lɛ ꞊tɔ, 'ke bʋ nu dɛ 'kuku, ‑ye ʋ 'kee Nyɩsʋa a wintɛ a ꞊wlʋ a yekuolɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","‑Ye ‑tʋtʋtɩɔ ꞊nʋ, 'witi a ꞊gagɛi nɩ 'o ke, ‑ɔ kɔ ke 'dɩdɔ‑tɔplɩ ꞊nʋ, ɩ bi ‑wɛ 'o, nɔ‑ mɔ nahuin ‑gbo, ‑ʋʋ Nyɩsʋa a wintɛ 'wɔn, 'plɩɩ nahuin a ‑gbɛ 'ʋʋ 'klɔ ke a 'kla‑wliye'yɩya a hrɛtilɛ hrɛti, kɔ 'ʋʋ kʋkɔ‑tɔplɩ ꞊wlɩ klɛ naa, ‑ɩ nyu 'le kɩka 'mʋ po, 'plɩɩ 'waa ꞊wlɩ 'ɩɩ 'klɔ ‑gbo a ‑tɔplɩ ‑ye ‑wɔn lɛ kʋɛ, ‑ɩ kɔ 'tʋ nyu nu. ‑Tɔplɩ 'bii a ‑gbɛ, ɩ nue, Nyɩsʋa a wintɛ, 'ɛ 'nɩnɩ nu ‑kʋan, 'ke 'le ꞊nʋ ꞊wlʋ ke, 'plɩɩ 'ɛ hihre lɛ. ");
INSERT INTO ted_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","‑Ye ꞊hapʋ‑tʋtʋ ꞊nʋ, ‑ʋ kɔ ke 'dɩdɔ‑tɔplɩ ‑ye ꞊nʋ, ɩ bi ‑wɛ 'o, nʋ‑ mɔ nahuin ꞊nʋ, ‑ʋʋ Nyɩsʋa a wintɛ 'wɔn, kɔ, ‑ʋ nye gbo ꞊tu, 'ke 'le ꞊hapʋ꞊wlʋ ke, 'plɩɩ 'ʋ nye mɛ lɛ ‑ha, 'ke bɛ nu ‑kʋan 'ɛ nɩ ti, 'ke 'le ꞊nʋ ꞊wlʋ ke.» ");
INSERT INTO ted_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Kɛ ‑Yusu nyu lele ye po: «Nahuon 'bɔ 'bɩa 'napɩ, ɔ 'nɩ ꞊jre ꞊le kaka 'lu gbo, kɔ, nahuon 'bɔ 'bɩa 'napɩ, ɔ 'nɩ ꞊tue ꞊le 'le ‑bɛlɛ gbo. Kɛɛ, 'ke ɔ nye 'le dɛ 'klɔ gbo ꞊tu, ‑ɛ die nu, nahuin ꞊nʋ, ‑ʋʋ 'le kayu gbo pa, ʋ 'mʋ lɛ yrii. ");
INSERT INTO ted_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","‑Tɔplɩ 'bii, ‑ɩ ‑hli, ɛ di kɔ ‑nyrɔwɔ, ɩ 'mʋ pepe' 'mʋ lɛ bi, kɔ, ‑tɔplɩ 'bii, nahuon ꞊de 'de o yi, ɛ di kɔ ‑nyrɔwɔ, ɩ 'mʋ 'mʋlɛyriilɛ kɔ, 'plɩɩ ɩ 'mʋ ‑wɛ pepe' 'mʋ lɛ bi. ");
INSERT INTO ted_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Nyɩsʋa a wintɛ, 'nɩɩ ‑wɔn lɛ na, ba ꞊tue 'yie. ‑Tɛ a di 'a 'wʋnwɔn nu, kɛ Nyɩsʋa di 'a mʋ 'a 'mʋlɛyriilɛ nu. Nahuon ꞊nʋ, ‑ɔɔ Nyɩsʋa a wintɛ nʋa ye gbo po, Nyɩsʋa die 'nɩ nu, ɔ 'mue 'mʋ lɛ yrii, ɛ 'mʋ 'o ‑tɛ ɔ nu o 'a 'wʋnwɔn 'mʋ ‑hi. Kɛɛ, nahuon ꞊nʋ, ‑ɔ 'nɩnɩ pue nʋa ye gbo, ɔ 'nɩ yrie ꞊le 'mʋ lɛ nɩ gbe, ꞊betɩ bɔ plɛ, ɔ nye 'mʋ lɛ 'nɩ yrii.» ");
INSERT INTO ted_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","'Ke ʋ nɩ 'le kayuu ‑do a ‑gbɛ gbo, ‑Yusu a 'dii kɔ 'a 'dɩayuo nyɩbɛpʋ 'hɛɛn 'ʋ nyre 'o, ‑ɛ die nu, ʋ 'muo 'ye. Kɛɛ, nahuin a ‑huhuo‑tɩ, ʋ 'die 'le ‑wɛ bʋ nyre 'o ꞊nɔ 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","‑Ye nahuin lo nɩ, ʋ nɔ: «'Ye kɛ, ‑na 'dii kɔ ‑na 'dɩayuo, 'ke ʋ nɩ 'le ‑patʋ 'mʋ, 'ʋʋ ‑hʋa bʋ 'ye ‑mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","‑Ye ɔ nɔ: «Nahuin ꞊nʋ, ‑ʋʋ Nyɩsʋa a wintɛ nʋa ye gbo po, 'plɩɩ ‑ʋ nye nu, nʋ‑ mɔ ‑wɛ 'na 'dii kɔ 'na 'dɩayuo.» ");
INSERT INTO ted_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusu 'ya 'le 'blagbe wlɔn, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. Kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «‑Ba ꞊ta 'le 'yru a 'pɩa ‑ye ꞊nʋ ke!» 'ʋ mu. ");
INSERT INTO ted_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","‑Tɛ ʋʋ 'klɛɛ mu, ‑ye ‑Yusu bi 'mʋ ŋmla. Tii ‑do a ti 'yri, 'ke 'le 'yru a ‑gbɛ ke, ‑ye ‑hlonpʋ cɛ 'le ꞊le. ‑Ye 'blagbee 'le 'nɩ 'yii, 'ke 'o 'yru a 'dʋɩ ‑wɔn, ɛɛ ‑hʋa bɛ ꞊mɩɛ, ");
INSERT INTO ted_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","'a ‑naagbopʋ 'ʋ 'yɩyɔ 'o 'hʋɩn 'mʋ gbo, 'ʋ ‑hɩɔ ŋmla 'mʋ, ʋ nɔ: «Tɔɔnyɔ o, ‑aa gbo mu 'nɩ ‑wɛ,» ‑Yusu 'ɔ 'ba ye 'mʋ, 'ɔ 'prɛɛ 'le ‑hlonpʋ kɔ 'yru a 'dʋɩ 'hɛɛn ‑wɔn, 'ke 'le win 'yaklɩkɔ 'kwli 'mʋ. Bɔ po 'klɛɛ wun, ‑ye 'ɛ mɔ ‑tɛɛ, ɩ ‑wan gbo ke, pepe 'ɛ nyra gbo. ");
INSERT INTO ted_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","‑Ye kɛ ‑Yusuu 'a ‑naagbopʋ ye po: «'Bɩa 'nɩɩ 'a mʋ 'ye, ɛ 'we ꞊nɔ ye, a 'de Nyɩsʋa ꞊wlʋ ye kuo.» 'A ‑naagbopʋ ‑mɛ ‑ye, ʋ 'ta 'mʋ gblɛ, 'ɩ saka ꞊nʋ, 'ʋʋ 'mʋ lɛ 'pʋprɛ, ʋ nɔ: «Ba 'ye kɛ nahuon ‑gbo. Ɔɔ 'le ‑hlonpʋ kɔ 'yru 'hɛɛn ‑wɔn 'nɩ 'prɛɛ, 'ɩ nyo ‑wɛ 'o ꞊tuu.» ");
INSERT INTO ted_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ʋ nyre 'le Galileblʋgba a 'yru a 'pɩa ꞊nʋ ke nɩ, ‑ɔ mɔ Gelasakʋɛ a 'blʋgba. 'Blʋgba a ‑gbɛ, ɔ 'bɛ Galileblʋgba 'mʋ 'yi. ");
INSERT INTO ted_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","‑Yusu bɔ ꞊tɩ 'klɛɛ 'le 'blagbe wlɔn, ‑ye nyɩbɛyu ꞊de, nɔ‑ ‑hɔn 'le 'dɩɔ ꞊nʋ 'mʋ, 'ɔ muo ye 'mʋ 'bɛ wɔn. Nahuon a ‑gbɛ, 'kuo ‑hʋɩn nɩɔ 'o ke 'mʋ, 'ɔɔ ꞊nɔ ꞊sʋɛ ꞊tue. Kʋɛ la 'le gbo, ɔ 'nɩ pue ꞊le wlawlʋ, kɔ, ɔ 'de ‑wɛ 'le kayu ꞊de gbo 'ti, kɛɛ, 'ke ɔ 'ti 'le 'dɛɛi ‑gbahlɔn, ‑ɩ nɩ 'le dʋgbɩ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","‑Nyrɔwɩ ‑ye 'kwli 'mʋ, 'ku ‑hʋan 'ʋ nyo 'yi klɛ 'ya, nahuin 'ʋʋ la 'cɩɩn nu, 'ʋʋ la 'a bʋɩ mʋa, kɔ, 'ʋ nyo la ‑wɛ 'le kɩ dabʋɩ 'mʋ lɛ po. Kɛɛ, ɩ 'bii ꞊nʋ, nahuon a ‑gbɛ, ɔ nyi la lɛ 'nɩ cɩcɛ, 'ku ‑hʋan 'ʋ nyo 'le ‑tɛgbi ꞊nʋ gba, ‑tɛ nahuin ꞊de 'de 'le 'ti. ‑Tɛ ɔ 'ye 'klɛɛ ‑Yusu, ‑ye ɔ 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, 'ɔ blɔ kwlɩ ye gbo, ‑ɛ die nu, ‑Yusu 'muo 'mʋ ‑hɛ, ‑Yusu 'ɔ le 'ku ‑hʋan a ‑gbɛ, 'ke bʋ ‑hɔn 'o nahuon a ‑gbɛ 'ke 'mʋ, nahuon a ‑gbɛ, 'ɔɔ 'le win 'yaa, ɔ nɔ: «‑Yusu, Yrayrɩnyɩsʋa a 'Yu, dɛ tio‑ ‑n ‑hʋa ‑bo nu 'mʋ 'mʋ 'le? 'Nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, ꞊nɩ ꞊tue 'le 'mʋ ꞊sʋɛ.» ");
INSERT INTO ted_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","‑Ye ‑Yusu nyo wlɔn 'nɩ ꞊gba, ɔ nɔ: «‑Na 'dʋ 'le?» ‑Ye ɔ ꞊tuo ‑wɔn, ɔ nɔ: «'Na 'dʋ mɔ dakʋ.» Kɛ ɔ po, ‑ɛ nue, 'kuo ‑hʋɩn 'plɔplɔ, nɔ‑ bi 'o ꞊nɔ ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","‑Ye 'kuo ‑hʋɩn a ‑gbɛ, ɔɔ ‑Yusu lɛ 'nɩ 'batɩ, ɔ nɩ lo 'le, 'ke bɔ mu 'le 'hʋɔ ꞊nʋ wlɔn, ‑tɛ ꞊sʋɛ a 'yiye nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","'Ke 'o ‑tɛgbii ‑do a ‑gbɛ, dʋgba nɩ 'o, 'a ꞊tɩɔ ‑ye 'ɔ bi 'le 'yru ‑wɔn. 'Ke bʋɩcɩ a ꞊ju gblaka nɩ 'o, 'ʋʋ lɛ wa. ‑Ye 'kuo ‑hʋɩn a ‑gbɛ, ɔɔ ‑Yusu lɛ 'nɩ 'batɩ, ɔ nɔ: «Wɛɛn ke, 'ke ‑ba bi 'o bʋɩcɩ ꞊nʋ ke 'mʋ!» ‑Ye ‑Yusu wɔn nɩ, ");
INSERT INTO ted_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","'kuo ‑hʋɩn a ‑gbɛ 'ɔ ‑hɔn 'o nahuon a ‑gbɛ ke 'mʋ, 'plɩɩ 'ɔ bi 'o bʋɩcɩ ꞊nʋ ke 'mʋ, bʋɩcɩ a ꞊ju 'bii a ‑gbɛ, 'ʋ 'gba ci lɛ, 'ʋ ꞊tɩ dʋgba, 'ʋ bi 'yru 'mʋ lɛ, 'ʋ 'kʋkʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nahuin ꞊nʋ, ‑ʋʋ bʋɩcɩ a ‑gbɛ naa, ‑tɛ ʋ 'ye ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ mue 'lu ‑wɔn, ‑ye ʋ 'gba lɛ ci, 'ʋ nyi ‑wɔn lɛ na, 'ke 'le 'dɩɛ 'mʋ, kɔ ‑gligbɩ ke. ");
INSERT INTO ted_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","'Plɩɩ nahuin 'mui mu 'wɔn, ‑ye ʋ di 'le ꞊le, ʋ 'mʋ ‑tɔplɩ a ‑gbɛ 'ye, ‑ɩ mue 'lu ‑wɔn. ‑Tɛ ʋ nyre 'klɛɛ 'o ‑Yusu 'hʋɩn 'mʋ, ‑ye 'ke ʋ yɛ 'o nahuon a ‑gbɛ gbo, ‑ɔ kɔ ke 'mʋ 'kuo ‑hʋɩn ‑hɔn wɛn 'o 'mʋ, 'ɔ nɩ 'o ‑Yusu a bʋɩ ꞊hlɔn gbo, 'ɔ pue wlawlʋ. Ɔ 'we ꞊nɔ nahuon ꞊nʋ ye, hanhɩn 'de ‑hlɩn a nue. Nahuin a ‑gbɛ bʋ 'yo 'klɛɛ, ‑ye hʋannʋ biu 'le 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nahuin ꞊nʋ, ‑ʋ 'ye ‑tɔplɩ 'bii a ‑gbɛ, ‑ɩ mue 'lu ‑wɔn, ʋ nyi nahuin ꞊nʋ ‑wɔn yrɛ 'nɩ na, ‑ʋ di ‑ta 'ye wɔn, ‑tɛ ‑Yusu nu, 'ɔ bla 'kuo ‑hʋɩn ꞊nʋ lɛ, ‑ɔ nɩ 'o nahuon a ‑gbɛ ke 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","‑Ye nahuin 'bii ꞊nʋ, ‑ʋ 'ti 'le 'blʋgba a ‑gbɛ 'mʋ, ‑ɔ mɔ Gelasakʋɛ a 'blʋgba, ʋʋ ‑Yusu lɛ 'nɩ 'batɩ, 'ke bɔ ‑hɔn 'le 'waa 'blʋgba ꞊nʋ 'mʋ, ‑ɛ nue, hʋannʋ biu 'le 'kwli 'mʋ. ‑Ye ‑Yusu 'ya 'le 'blagbe wlɔn, ‑ɛ die nu, ɔ 'mʋ mu. ");
INSERT INTO ted_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Kɛɛ, nahuon ꞊nʋ, 'kuo ‑hʋɩn ‑hɔn wɛn 'o ke 'mʋ, ɔɔ ‑Yusu lɛ 'nɩ 'batɩ, 'ke bɔ naa ꞊nɔ ‑wɔn. Kɛɛ, ‑Yusu 'die ke wɛɛn, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«꞊Hɩan ‑wɔn, ‑bo mu 'le ‑na 'dɩɔ 'mʋ, 'ke 'le ‑na 'dʋkʋɛ ‑wɔn, ‑bo na ‑tɔplɩ gblakɩ 'bii ꞊nʋ a ‑tɩ ‑wɔn lɛ, Nyɩsʋa nu ‑mʋ 'mʋ.» Bɔ po 'klɛɛ lɛ, ‑ye nahuon a ‑gbɛ, ɔ bi wlɔn 'hru, 'ɔ mu 'le 'a 'dɩɔ 'mʋ. ‑Ye ‑tɔplɩ gblakɩ 'bii ꞊nʋ, ‑Yusu nu ꞊nɔ 'mʋ, nɩ‑ kɔ ‑tɩ, ɔɔ ‑wɔn lɛ na. ");
INSERT INTO ted_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ti ꞊nʋ ‑kɔ 'yri ‑Yusu ‑hɔn 'le 'yru a 'pɩa ‑ye ꞊nʋ ke 'mʋ, nahuin 'plɔplɔ, nʋ‑ 'bɩɔ ye 'mʋ, ‑ɛ nue, ʋ 'bii, ʋ nyo 'nɩ ‑pre. ");
INSERT INTO ted_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Bʋ nɩ 'klɛɛ 'o gbo, ‑ye nyɩbɛyu ꞊de, nɔ‑ nyre 'o. 'A 'dʋ mɔ Sayilu. Ɔ mɔ Nyɩsʋa a kayu a nyɩgblakaa nɩ. ‑Tɛ ɔ nyre 'klɛɛ 'o, ‑ye ɔ bla gbo kwlɩ, 'ke 'o ‑Yusu ye, 'ɔ nyo lɛ 'batɩ, 'ke bɔ di 'le 'a ‑tɛ. ");
INSERT INTO ted_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nyɩbɛyu a ‑gbɛ, ɔ kɔ 'yu nyrɔyuu ‑do. Ɔ ‑wɛ 'le bɔ kɔ 'yrɩɩ ‑pu ꞊tu 'o 'hɔn nɩ. Nɔ‑ɔ ‑hʋa ‑bɔ 'kʋ. ‑Ye ‑Yusu wɔn nɩ, ɔ kɔ nyɩbɛyu a ‑gbɛ 'hɛɛn 'ʋʋ mu, nahuin 'plɔplɔ 'ʋ nyo 'le yrɛ 'nyɩnyraa. ");
INSERT INTO ted_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","‑Ye 'klɛɛ, 'ke 'le nahuin a ‑gbɛ ‑hɛyri, 'ke nyrʋgba ꞊de nɩ 'le. Nɔ‑ 'kʋɛɛ nu. 'A 'kʋɛ a ‑gbɛ, nɛ‑ mɔ dablo bɔ nyo gbo ‑wɛ. ‑Tɛ 'kʋɛ a ‑gbɛ, ɛ 'tatɩ la 'a nunue, 'a 'yrʋ a ‑pu ꞊tu 'o 'hɔn a nʋnʋ nɩ kɛ gbo. 'A 'hʋɩn a ‑gbɛ a ‑tɩ, 'ɔ na la ‑datapʋ a gblegblei yrɛ, 'a 'wli 'bii 'ɩ ‑wɛ la ꞊nɔ kwa lɛ. Kɛɛ, nahuon ꞊de 'de la 'le 'a pɩalɛ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nyrʋgba a ‑gbɛ, nɔ‑ mu 'o ‑Yusu ke 'mʋ, 'ɔ 'tʋ 'a wlawlʋ a bʋgbodɛ lɛ. ‑Ye tii ‑do a ti 'yri, dablo 'kee 'a gbo‑wʋwɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","‑Ye ‑Yusu ꞊gba wlɔn, ɔ nɔ: «Nyɔ‑ 'tʋ 'mʋ lɛ 'le?» Nahuin 'bii 'nɩ ꞊ga, ‑ye Piɛlɩ nɔ: «Tɔɔnyɔ o, nahuin ꞊nʋ, ‑ʋ ꞊glaa 'le ‑mʋ, ʋ ‑huo nɩ, 'plɩɩ 'ʋʋ 'le ‑mʋ yrɛ 'nyɩnyraa.» ");
INSERT INTO ted_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","‑Ye ‑Yusu nɔ: «Nahuon 'tʋ 'mʋ lɛ, ‑ɛ nue, 'n yree nɩ, ‑ɛ mɔ, 'klɩ ‑hɔn 'le 'mʋ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nyrʋgba a ‑gbɛ, ɔ 'ye nɩ, ‑ɛ mɔ, ɔ bi 'mʋ pepe', hʋannʋ 'ʋ bio 'le 'kwli 'mʋ, 'ɔ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, 'ɔ blɔ kwlɩ ye gbo, 'ɔ le ꞊nɔ, 'ke 'o nahuin 'bii ye, ‑tɩ ‑kɔ ‑tɩ 'ɔ 'tʋɔ lɛ, kɔ, ‑tɛ 'a kʋɛ nu ‑wʋwɛ tii ‑do a ti 'yri, 'ɔ nɩ ‑wɔn lɛ. ");
INSERT INTO ted_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","‑Tɛ ‑Yusu 'wɩn 'klɛɛ, ‑ye ɔ nɔ: «'Na 'yu o, ‑tɛ ‑n kuo 'mʋ ꞊wlʋ ye a ‑tɩ, 'nɩ ‑wɔ ‑na 'kʋɛ. ‑N ‑wɛ 'le ‑bo mu nɩ, 'ke 'le plɔ a bleelɛ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Win nɩ 'le ꞊nɔ wlɔn, nahuon ꞊de 'ɔ ‑hɔn 'le nyɩgblaka Sayilu a ‑tɛ 'mʋ, ɔ nɔ: «Sayilu, ‑na 'yu nyrɔyu gbi ‑nɩ wɛn, ɔ 'kʋ nɩ. 'A ‑tɩ, ‑ha Tɔɔnyɔ ‑Yusu mɛ lɛ, ꞊betɩ ‑n dio 'ku 'mʋ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","'Plɩɩ ‑Yusu 'mʋ ‑tɩ a ‑gbɛ mu 'wɔn, ‑ye ɔ le Sayilu, ɔ nɔ: «‑Na ꞊wlʋ nɩ bi 'le ꞊hlɔn, kuo 'mʋ ꞊wlʋ yee ‑do, ɔ di 'hrɩ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","‑Tɛ ʋ nyre 'le Sayilu a ‑tɛ, ‑ye ‑Yusu 'die ke wɛɛn, 'ke nahuin ‑ye kɔ ꞊nɔ 'hɛɛn, bʋ pa 'le, 'bɛ 'de 'a ‑naagbopʋ Piɛlɩ, kɔ Saan, kɔ Sakɩ, kɔ 'yu a ‑gbɛ a bu kɔ 'a 'dii 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nahuin 'bii po popowlii, 'ʋʋ wɔlɩ lɛ nu, 'yu a ‑tɩ. ‑Ye ‑Yusu nɔ: «A nɩ we 'le! Ɔ 'de 'kʋ. Ŋmla'a nɩ, ɔɔ ŋmo.» ");
INSERT INTO ted_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Bɔ po 'klɛɛ lɛ, ‑ye ʋ nyo 'nɩ 'caa, ‑ɛ nue, ʋ yie nɩ, ‑ɛ mɔ, 'yu 'kʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","‑Yusu ‑mɛ ‑ye, ɔ klɩ 'yu a ‑gbɛ a dabʋ gbo, 'ɔ 'yaa 'le win, ɔ nɔ: «'Yu o, 'ba ye 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","'a ‑hihiu 'ʋ bi 'o lele ꞊nɔ ke 'mʋ, tii ‑do a ti 'yri, 'ɔ 'ba ye 'mʋ, ‑Yusu 'ɔ le 'a 'dʋkʋɛ, ɔ nɔ: «Ba ‑nyo dididɛ, ɔ 'mue di.» ");
INSERT INTO ted_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","‑Ye 'a bu kɔ 'a 'dii 'hɛɛn, ɩ saka ꞊nʋ nɩ. Kɛɛ ‑ye ‑Yusu tiu nɩ, ɔ nɔ: «Dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, a nɩ le 'le nahuon ꞊de.» ");
INSERT INTO ted_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu 'kukue 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ lɛ, 'ɔ ‑nyi ꞊nʋ 'klɩ, 'ke bʋ bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ, kɔ, 'ke bʋ ‑wɔ nahuin a 'kʋɛi, ");
INSERT INTO ted_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","'ɔ lu, 'ke bʋ na 'dɩɛ klɛ, bʋ ꞊tui nahuin ye, ‑tɛ Nyɩsʋa di nahuin a win a kekɔɔlɛ nu, kɔ, bʋ ‑wɔ nahuin a 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «'Bɩa 'baa 'dɩɛ klɛ na, a nɩ gba 'le dɛ ꞊de, mɔ, a nɩ gba 'le kotu, kɔ blɔ, kɔ dididɛ, kɔ 'wliyɛ, kɔ, a nɩ gba 'le wlawlʋ a 'hɔn a nʋnʋ. ");
INSERT INTO ted_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","'Bɩa 'ba nyre 'le 'dɩɔ ꞊de 'mʋ, kayu ꞊nʋ, ‑ʋ kɔ gbo ʋ di 'le 'a mʋ paa, 'ke ba nɩ 'le ‑nɩnɩ, a 'mʋ 'le 'dɩɔ a ‑gbɛ 'mʋ ‑hɔn. ");
INSERT INTO ted_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","'Bɩa 'ba mu 'le 'dɩɔ ‑ye 'mʋ, 'bɩa 'bʋ 'de 'a mʋ kwa 'ble, ‑ye ba ‑hɔn 'le 'dɩɔ a ‑gbɛ 'mʋ. 'Baa mu, ‑ye ba bʋbla 'a nɩ bʋɩ, ‑ɛ die nu, 'pupu 'mʋ 'o 'a nɩ bʋɩ 'hʋɩn 'mʋ lɛ ‑hɔn, a 'mue nahuin tɔɔ, ‑ɛ mɔ, Nyɩsʋa a yrʋ 'bʋ yɛ ꞊nʋ, ‑ye nʋ‑ʋ nɩ, ‑ʋ nue 'waa dɩɔnʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","‑Tɛ ɔ ‑wɔ 'klɛɛ 'waa tiilɛ ‑wɔn, ‑ye 'a ‑naagbopʋ bi 'klɛɛ wlɔn 'hru, 'ʋʋ 'dɩɛ 'bii klɛ na, 'ʋʋ nahuin Nyɩsʋa a ꞊hapʋtitie ꞊nʋ pue, 'plɩɩ 'ɛ nɩ ‑tɛgbi ꞊de, 'ʋʋ 'hʋɩnhrennyʋ a 'kʋɛi ‑wɔ. ");
INSERT INTO ted_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ti a ‑gbɛ 'yri, Galileblʋgba a ‑gʋlʋnʋma, ‑ɔ kɔ 'dʋ mɔ Helɔdɩ, ɔ 'wɔn ‑tɔplɩ 'bii ꞊nʋ nɩ, ‑Yusu nu, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. Dɛ bɔ di 'lu ‑wɔn lɛ ‑hie, 'ke 'o ‑Yusu a ‑ta 'mʋ, ɔ 'die yi, ‑ɛ nue, kɛ nahuin ‑yee po: «Saan Batisɩɩ nɩ. ‑Tɛ ɔ 'kʋ la, ɔ 'hrɩ lele 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","‑Ye kɛ ꞊ʋ ‑ye ‑wɛ po: «Eli, ‑ɔ mɔ la Nyɩsʋa a winwlɔn‑hɛnyɔ, nɔ‑ 'hrɩ lele 'klɔ.» Kɛ ꞊ʋ ‑yee lele po: «Nyɩsʋa a winwlɔn‑hɛnyɔ ‑ye, ‑ɔ 'kʋ la, nɔ‑ 'hrɩ lele 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Helɔdɩ ‑mɛ ‑ye, kɛ ɔɔ po: «Saan, 'n le o nahuin, bʋ 'bɛ o 'o 'a 'lu. 'A ‑tɩ, nahuon ‑gbo, ‑ɔ kɔ 'dʋ 'nɩɩ 'wɔn, ‑ɔɔ ‑tɔplɩ 'bii ‑gbo nu, nahuon a gblo tio‑ ɔ 'ya lele 'mʋ?» Nɛ‑ nue, 'ɔɔ ‑Yusu a 'yiye lɛ ꞊mɔ. ");
INSERT INTO ted_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","‑Tɛ ‑Yusu le o 'a ‑wɔnnaanyʋ, 'ke bʋ na o 'dɩɛ klɛ, ʋ ꞊hɩan ‑wɔn, 'ʋ le ‑Yusu ‑tɔplɩ 'bii ꞊nʋ, ʋ nu, 'ɔ gbʋ, 'ʋ mu 'le ‑tɛgbi, 'dʋ bii 'le ye, 'ke 'o 'dɩɔ ꞊nʋ ꞊hlɔn, ʋʋ Bɛtɩsaida daa. ");
INSERT INTO ted_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kɛɛ, nahuin ꞊nʋ, ʋ hie wɛn 'o gbo, ʋ 'wɩn nɩ, ‑tɛgbi ꞊nʋ, ‑Yusu mu 'o, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ʋ kʋ ‑wɔn. Nahuin 'bii a ‑gbɛ, ‑ʋʋ 'le lɛ di, ‑Yusu 'blu kwa ‑tɛɛ, kɔ, 'ɔ tʋɛ ꞊nʋ, ‑tɛ Nyɩsʋa di nahuon a win a kekɔɔlɛ nu, kɔ, nahuin, ‑ʋ kɔ kɩkla, 'ɔ ‑wɔ 'waa 'kʋɛi. ");
INSERT INTO ted_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","‑Tɛ 'tɔɔ ‑wɔn, ‑ye ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ, ʋ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, ʋ nɔ: «Le nahuin ‑gbo, 'ke bʋ mu 'le 'dɩɛ kɔ ‑gligbɩ 'hɛɛn klɛ, ‑ɛ die nu, ʋ 'mʋ 'le gbopɛɛlɛ kɔ dididɛ 'hɛɛn lɛ ꞊mɔ, ‑ɛ nue, ‑tɛgbi ‑gbo, ‑a nɩ nɔ, 'dʋ bii nɔ ye.» ");
INSERT INTO ted_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kɛɛ ‑ye ‑Yusu nɔ: «'A nɩ ‑gbɛ, ba ‑nyu dididɛ!» Ʋ nɔ: «'Flɔɔkuii ꞊hun kɔ ‑hriin 'hɔn gbii ‑do, nɩ‑ nɩ mɔ. 'Bɩa ꞊ba 'de didi‑tɔplɩ mu ‑tɔ, 'ke 'o nahuin 'bii ‑gbo ‑wɔn, ‑a 'die 'le ‑wɛ ‑ba ‑nyu dididɛ.» ");
INSERT INTO ted_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","'Ke 'le nahuin ꞊nʋ ‑hɛyri, nyɩbɛpʋ a (5'000) 'milowɩɩ ꞊hun nɩ 'le. ‑Ye kɛ ‑Yusuu 'klɛɛ 'a ‑naagbopʋ ye po, ɔ nɔ: «Ba le ꞊nʋ, bʋ nu dui, bʋ nɩ gblɛ, duu ‑do, bʋ ‑wɛ 'le ‑wlɩɩ 'hɔn ꞊tu 'o ‑pu (50).» ");
INSERT INTO ted_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Dɛ ꞊nʋ, ‑Yusu le ꞊nʋ, nɛ‑ ʋ nu, 'ʋ le nahuin, 'ke bʋ nɩ gblɛ. ");
INSERT INTO ted_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","‑Tɛ ʋ nɩ 'klɛɛ gblɛ, ‑ye ‑Yusu 'ba 'flɔɔkui ꞊hun kɔ ‑hriin 'hɔn a ‑gbɛ 'mʋ nɩ, 'ɔ 'ba 'lu ye 'mʋ, 'ɔɔ 'le yrayrɩ lɛ ta, 'ɔ ‑nye Nyɩsʋa 'wio, 'ke 'o dididɛ a ‑gbɛ a ‑ta 'mʋ, 'ɔ 'bɩ ꞊tɩɔ lɛ, 'ɔ ‑nyi 'a ‑naagbopʋ, 'ke bʋ wii nahuin a ‑gbɛ 'mʋ lɛ, ");
INSERT INTO ted_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","nahuin a ‑gbɛ, 'ʋ di dɛ ‑didi, ʋ 'bii, 'ʋ ꞊mra. ‑Tɛ ʋ ‑wɔ dɛ lɛ, ‑ye didi‑tɔplɩ ꞊nʋ, ‑ɩ hie gblɛ, ‑naagbopʋ 'ʋ 'kukui lɛ, 'ʋ 'yie 'le ‑tʋgbɩwɩɩ ‑pu ꞊tu 'o 'hɔn. ");
INSERT INTO ted_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusu bii ye, 'ɔɔ Nyɩsʋa da, 'a ‑naagbopʋ 'ʋ mu 'o ꞊nɔ 'hʋɩn 'mʋ, 'ɔ ꞊gbʋ wlɔn, ɔ nɔ: «Nahuin nɔ dɛ‑, nahuon a gblo tio‑ 'n 'ya 'klɛɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","‑Ye ʋ ꞊tuo ꞊wɔn, ʋ nɔ: «꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Saan Batisɩ, ‑ɔɔ o nahuin 'nie 'lu lɛ po. ꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ Eli. ꞊Ʋ ‑ye nɔ 'nɩ, ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ ‑yee nɩ, ‑ɔ 'kʋ la, ti ‑hi la a ti 'yri, 'plɩɩ ‑ɔ 'hrɩ lele 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","‑Ye ɔ ꞊gbʋ wlɔn, ɔ nɔ: «A ‑mɛ ‑ye, a nɔ 'nɩ, nahuon a gblo tio‑ 'n 'ya 'klɛɛ 'le?» ‑Ye Piɛlɩ nɔ: «‑Mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya.» ");
INSERT INTO ted_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","‑Ye ‑Yusu, ɔ tiu nɩ ‑tɛɛ, ɔ nɔ: «A nɩ le 'le nahuon ꞊de, nahuon a gblo tio‑ 'n 'ya 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","‑Ye kɛ ɔɔ lele ꞊nʋ ye po: «'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n kɔ ꞊bo 'ye ‑tado ꞊sʋɛ 'dɔ. 'Blʋ a nahuin, kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ Nyɩsʋa a teteitɔɔnyʋ 'hɛɛn, ʋ kɔ bʋ yraa ‑tado 'mʋ, kɔ, ʋ 'mʋ 'mʋ 'la. 'Bɩa 'nɩ 'kʋ, ‑nyrɔwɩɩ 'hɔn, ‑nyrɔwɔ a ta a nɔnɔ 'mʋ, Nyɩsʋa kɔ bɔ ‑ha 'mʋ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","‑Ye nahuin 'bii, ‑ʋ nɩ 'o, kɛ ɔ nyu ye po: «Nahuon 'bɔ nɩ 'o, 'bɔ nye ‑hʋa, 'ke bɔ naa 'mʋ ‑wɔn, ‑ye ɔ nɩ kʋɛ 'le 'a ‑gbɛ a 'lu a lɛ‑hielɛ ‑wɔn, kɛɛ, ‑tɩ ꞊nʋ, 'nɩɩ ꞊nɔ ye ꞊tu, bɔ ꞊tui 'o, bɔ nui 'ɛ nɩ ‑nyrɔwɔ, ꞊betɩ nahuin bʋ plɛ, ʋ 'muo 'la, ‑tɛ ɔ nu, 'ɔ 'ya 'na nahuon 'mʋ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nahuon 'bɔ nɩ 'o, 'bɔ plɛ, ɔ 'nɩ ‑hʋa ꞊le bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, 'ke 'o 'na ‑ta 'mʋ, ‑ye nahuon a ‑gbɛ 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn 'a 'klɔ yrayrʋ 'nɩ 'waan, 'ke 'le Nyɩsʋa ye. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ wɛɛn ke, 'ke bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, ‑tɛ ɔ nʋɛ 'mʋ 'mʋ a ‑tɩ, ‑ye nahuon a ‑gbɛ, 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn kɔ 'klɔ yrayrʋ ꞊nʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'ke 'le Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Nahuon 'bɔ kɔ 'klɔ ke a kʋkɔ‑tɔplɩ a pɛpɛ 'bii, 'bɔ 'waan 'a dɩɔnʋ a 'klɔ yrayrʋ, 'ke 'le Nyɩsʋa ye, kɔ, Nyɩsʋa a ‑bati 'bɩ klɩ ꞊nɔ, ‑ye kʋkɔ‑tɔplɩ a ‑gbɛ, ɩ 'nɩ pue ꞊le 'o ꞊nɔ dɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","'Bɩa 'baa ‑tʋɩ pɩ, 'ke 'o nahuin a ‑gbɛ ye, 'ke ꞊bo di 'a nɩ Kʋkɔnyɔ 'mʋ 'ya, kɔ, 'ke ba di 'o 'na win 'o ꞊tuu, ‑ye 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ti ‑kɔ ti 'yri 'n di ‑hlɩn 'le di, 'ke 'le 'na Bu Nyɩsʋa a ‑tɩ a 'yi'bʋaalɛ 'kwli 'mʋ, 'n kɔ 'a lɛleenyʋ 'hɛɛn, ti a ‑gbɛ 'yri, 'n di ‑wɛ pɩ ‑tʋɩ, 'ke 'o Nyɩsʋa ye, 'ke ꞊bo ꞊tui, ‑ɛ mɔ, 'a mʋ mɔ 'na nahuin. ");
INSERT INTO ted_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","'Nɩɩ 'a mʋ 'nɩ le, 'ke 'le 'a mʋ ‑hɛyri, nahuin ‑ye nɩ 'le, ʋ 'mue ‑hlɩn 'ye, ‑tɛ Nyɩsʋa di nahuin a win a kekɔɔlɛ nu, 'plɩɩ ɛ 'mʋ ‑hlɩn nahuin a ‑gbɛ 'waa 'kʋkʋɛ ke yɛ.» ");
INSERT INTO ted_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","‑Tɛ ‑Yusu nu lɛ 'pʋprɛ, 'wee ‑do bɛ ‑hi, ‑ye ɔ gba Piɛlɩ kɔ Saan kɔ Sakɩ 'hɛɛn, 'ʋ 'ya 'le dʋgba ꞊de 'lu, ʋ 'mʋ Nyɩsʋa da. ");
INSERT INTO ted_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ʋ nɩ 'le Nyɩsʋa a dɩda 'kwli 'mʋ, ‑ye ‑Yusu a yigbakla 'cɩcɩ nɩ, kɔ, 'a wlawlɩ 'ɩ ‑tʋa 'pʋplɛ gbo, 'plɩɩ 'ɩɩ wlɩn bʋbakɔ. ");
INSERT INTO ted_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Tii ‑do a ti 'yri, ʋ 'ye nahuiin 'hɔn, ʋ kɔ ‑Yusu 'hɛɛn 'ʋʋ toto po. Nahuin a ‑gbɛ, nʋ‑ mɔ Moise, Nyɩsʋa ‑nye la tetei, 'hɔn a nɔnɔ, nɔ‑ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ Eli, ti ꞊de ‑hi la a ti 'yri. Nahuiin 'hɔn a ‑gbɛ, ʋ 'kʋ la nɩ, ");
INSERT INTO ted_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","'ʋ 'hrɩɩ 'klɛɛ 'o ‑Yusu 'hʋɩn 'mʋ, 'ke 'le ‑tɩ a 'yi'bʋaalɛ ꞊nʋ 'kwli 'mʋ, Nyɩsʋa ‑nyi ꞊nʋ. ‑Tɛ Nyɩsʋa ‑hʋa ‑Yusu bɔ nu 'kʋkʋɛ, 'ke 'le Jrusrɛdɩɔ 'mʋ, nɛ‑ kɔ ‑tɩ ʋʋ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","‑Tɛ dɛ a ‑gbɛ, ɛɛ 'lu ‑wɔn mue, ‑ye Piɛlɩ kɔ 'a 'bienʋ 'hɛɛn, ʋ bi 'mʋ ŋmla ‑pɛtu. Kɛɛ, ‑tɛ ʋ ꞊wlɛɛ 'yii, ‑ye ʋ 'ye ‑tɩ a 'yi'bʋaalɛ ꞊nʋ nɩ, 'ɛ ꞊glaa 'le ‑Yusu kɔ nahuiin 'hɔn ‑nɩ wɛn 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","‑Tɛ Moise kɔ Eli 'hɛɛn, ʋʋ 'o ‑Yusu 'hʋɩn 'mʋ mu ‑hɔn, ‑ye Piɛlɩ le ‑Yusu nɩ, ɔ nɔ: «Tɔɔnyɔ, ɛ nu ‑tɛɛ, 'ke ‑ba nɩ nɔ ‑tɛgbi ‑gbo gbo. ‑Ba po blɛɛ ta, ‑n nɛ blɔ, Moise a nɔnɔ, kɔ Eli a nɔnɔ.» ‑Tɩ bɔ di ꞊tu, ɔ 'di yi. Nɛ‑ nue, 'ɔɔ lɛ 'pʋprɛ nu. ");
INSERT INTO ted_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piɛlɩ nɩ 'le 'pʋprɛ kwa 'mʋ, ‑jrugba 'ɔ 'hrɩɩ 'o, 'ɔ ‑hli ‑Yusu kɔ Moise kɔ Eli 'hɛɛn. ‑Tɛ Piɛlɩ kɔ 'a 'bienʋ 'hɛɛn, ʋ 'ye dɛ a ‑gbɛ, ‑ye hʋannʋ biu 'le 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","'Ke 'le ‑jrugba a ‑gbɛ 'kwli 'mʋ, 'ke Nyɩsʋa a wiin 'le 'mʋ ‑hɔn, 'ɩɩ lɛ po: «Nahuon ‑gbo le, nɔ‑ mɔ 'na 'Yu. Nɔ‑ 'n ‑ha 'le, 'ke 'o 'na ‑kʋan a ‑ta 'mʋ. Ba puo nʋa ye gbo!» ");
INSERT INTO ted_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","‑Tɛ ʋ 'wɔn win a ‑gbɛ, ‑ye ‑Yusuu ‑do, nɔ‑ ‑naagbopʋ, ʋʋ 'o 'yee. ‑Tɛ ʋ ꞊tɩ 'le dʋgba 'lu, dɛ ꞊nʋ, ‑Yusu a ‑naagbopʋ 'ye, ʋ 'di ꞊ɔ ꞊de ye ꞊tu, 'ɛ gba 'dai ti. ");
INSERT INTO ted_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ‑Yusu kɔ 'a ‑naagbopʋʋ ta ꞊nʋ 'hɛɛn, ʋ ꞊tɩ dʋgba. Bʋ ꞊tɩ 'klɛɛ dʋgba, ‑ye nahuin ‑huohui di ‑Yusu ye 'mʋ 'bɛ wɔn. ");
INSERT INTO ted_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","'Ke 'le nahuin 'plɔplɔ a ‑gbɛ ‑hɛyri, 'ke nahuon ꞊de nɩ 'le, 'ɔɔ 'le win 'yaa, ɔ nɔ: «Tɔɔnyɔ, 'nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, 'ye kɛ 'na 'yu nyɩbɛyu. Nɔ‑ mɔ 'na 'yuu ‑do. ");
INSERT INTO ted_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ɛ kɔ ti, 'ku ‑hʋan 'ʋ nyo 'yi klɛ 'ya, 'ʋ nye nu, 'ɔɔ lɛ 'gbugbo, 'ʋ nyo bʋbla 'dɔ, 'ʋ nye nu, hɩɔnpru 'ʋʋ ꞊nɔ wien gbo nyra, 'ʋ nyo ꞊sʋɛ ꞊tue. 'Plɩɩ ʋ 'mʋ 'o ꞊nɔ ke 'mʋ mu ‑hɔn, ɛɛ gba 'dai ti. ");
INSERT INTO ted_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","'N 'batɩ ‑na ‑naagbopʋ lɛ, 'ke bʋ bla 'ku ‑hʋan a ‑gbɛ lɛ, kɛɛ, ʋ 'die 'le ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Kɛ ‑Yusuu 'klɛɛ 'a ‑naagbopʋ ye po, ɔ nɔ: «'A mʋ mɔ nahuiin nɩ, ‑ʋ 'de Nyɩsʋa ꞊wlʋ ye kuo, kɔ, ‑ʋ 'de ꞊hapʋdɛ kɔ dɛ 'klan a 'yi'mʋlɛ‑hɩhɩalɛ yi. Tii ‑tie 'n kɔ ꞊bo ‑hi nɔ 'a mʋ ‑hɛyri, 'plɩɩ a 'mʋ Nyɩsʋa ꞊wlʋ ye kuo 'le? ꞊Be 'n 'kɩɛ die ‑hlɩn 'a mʋ lɛ kikle? Ya 'mʋ ‑na 'yu a ‑gbɛ ye!» ");
INSERT INTO ted_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","‑Tɛ 'yu ꞊nʋ, ɔɔ 'o ‑Yusu 'hʋɩn 'mʋ gbo 'yɩya, ‑ye 'ku ‑hʋan a ‑gbɛ, ʋ puo ꞊hlɔn, 'ʋ ‑tʋa 'a gblɛ‑huhlilɛ gbo, ‑Yusu 'ɔ 'prɛɛ 'le 'ku ‑hʋan a ‑gbɛ ‑wɔn, 'ke 'le win 'yaklɩkɔ 'kwli 'mʋ. ‑Ye 'ku ‑hʋan a ‑gbɛ, ʋ ‑hɔn 'o 'yu a ‑gbɛ ke 'mʋ nɩ. Kɛ'ɛ nɩ, ‑Yusu nu 'yu a ‑gbɛ a 'kʋɛ a ‑wʋwɔ. ");
INSERT INTO ted_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nahuin 'bii, ‑ʋ nɩ 'o, ɩ saka ꞊nʋ nɩ, 'ke 'o Nyɩsʋa a 'klɩkenɩnɩɛ a ‑ta 'mʋ. ‑Tɔplɩ ꞊nʋ, ‑Yusu nu, ɩ 'kɩɛ sɛkɛɛ 'ɛ nɩ nahuon. ‑Ye kɛ ɔɔ 'a ‑naagbopʋ ye po, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Ba po 'mʋ nʋa ye gbo ‑tɛɛ, ‑tɩ ꞊nʋ, 'nɩɩ 'klɛɛ 'a mʋ ye mu ꞊tu, a 'mui kwa 'ble: 'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ʋ kɔ bʋ po 'mʋ nahuin kwa.» ");
INSERT INTO ted_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","‑Tɩ ꞊nʋ, ‑Yusu ꞊tu, 'a ‑naagbopʋ 'nɩ yrii ꞊le 'mʋ lɛ. Kɛɛ, ʋʋ pɩ hʋannʋ, 'ke bʋ ꞊gbɔ wlɔn, dɛ tio‑ ɛ ꞊hɛn 'nyrɛ. ");
INSERT INTO ted_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusu a ‑naagbopʋ, ʋ nyi wɛn 'mʋ lɛ 'nɩ pupo, 'ke 'le ꞊nʋ ‑hɛyri, nahuon tio‑ ‑bɔ nɩ 'o 'a 'be 'lu ye. ");
INSERT INTO ted_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","‑Yusu ‑mɛ ‑ye, dɛ ꞊nʋ, ʋʋ 'lu ‑wɔn lɛ ‑hie, ɔ yrie nɩ. ‑Ye ɔ da 'le gbo 'yu gbi, 'ɔ ꞊tuo 'o 'a dɩɔnʋ 'hʋɩn 'mʋ gbo, ");
INSERT INTO ted_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ɔ nɔ: «'Ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɛ 'yu gbi ‑gbo, ɔ nɩ 'mʋ, 'bɔ 'ble 'a nahuon kwa, 'ke 'o 'na 'dʋ a ‑ta 'mʋ, ‑ye 'na ‑gbɛɛ nɩ, ɔ 'ble kwa. Kɔ, nahuon 'bɔ nɩ 'o lele, 'bɔ 'ble 'mʋ kwa, ɔ 'ble ‑wɛ kwa Nyɩsʋa, ‑ɔ lee nɔ 'mʋ ‑tʋtʋ ke. Nahuon ‑gbo, ‑ɔ 'de nahuon ꞊de, 'ke 'le 'a mʋ ‑hɛyri, sɛyɩ‑sɛyɩ, nɔ‑ mɔ nahuon ꞊nʋ, ‑ɔ nɩ 'o 'a 'bienʋ 'lu ye.» ");
INSERT INTO ted_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","‑Ye Saan, ‑ɔ mɔ ‑Yusu a ‑naagbopʋyu ‑ye, ɔ nɔ: «Tɔɔnyɔ, ‑a 'ye nahuon ꞊de, 'ɔɔ 'kuo ‑hʋɩn lɛ bla, 'ke 'le ‑na 'dʋ 'kwli 'mʋ. ‑A ‑mɛ ‑ye, ‑a lo nɩ, 'ke bɔ 'kee 'a nunue, ‑ɛ nue, ɔ 'nɩ naa ꞊le ‑a mʋ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","‑Ye ‑Yusu nɔ: «A nɩ lo 'le bɔ 'kee, ‑ɛ nue, nahuon 'bɔ nɩ 'o, 'bɔ 'nɩnɩ ‑wɔn 'a mʋ ye, ‑ye ɛ ꞊hɛn 'nyrɛ, ɔ kɔ 'a mʋ 'hɛɛn pɛ.» ");
INSERT INTO ted_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa die nu, ‑Yusu 'mʋ 'le yakɔ 'mʋ mu, ti a ‑gbɛ, ɩ 'mʋɛɛ yrɛ. Nɛ‑ kɔ ‑tɩ 'ɔ ‑yrɩ, 'ke bɔ mu 'le Jrusrɛdɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","‑Ye ɔ le nahuin, 'ke bʋ 'nyɛ 'hru, nahuin a ‑gbɛ 'ʋ mu, 'ʋ nyre 'le Samaliblʋgba a 'dɩɔ ‑ye 'mʋ, ‑ɛ die nu, ʋ 'mʋ kayu lɛ ꞊mɔ, ‑ʋ kɔ gbo ‑Yusu di 'le pa. ");
INSERT INTO ted_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kɛɛ ‑ye 'dɩɔ a nahuin blɛ ke, 'ke bʋ 'ble ‑Yusu kwa, ‑ɛ nue, ɔɔ 'mʋ mu Jrusrɛdɩɔ. ");
INSERT INTO ted_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","‑Tɛ ‑Yusu a ‑naagbopʋ Sakɩ kɔ Saan 'hɛɛn, ʋ 'wɩn, ‑ye ʋ nɔ: «Kʋkɔnyɔ, ꞊be ‑n nye 'nɩ ‑hʋa, 'ke ‑ba nue, ‑tɛ bɛ ‑hɔn 'le yakɔ 'mʋ, ɛ 'mʋ ꞊tɩ, ɛ 'mʋ nahuin ‑gbo gbo ‑wɔ?» ");
INSERT INTO ted_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","‑Yusu ‑mɛ ‑ye, ɔ ꞊hɩan ‑wɔn, 'ɔ ꞊hɩʋn 'nyrɛ, 'ke 'o ‑tɩ ꞊nʋ, ʋ ꞊tu, a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye 'ke ʋ mu 'le 'dɩɔ ‑ye 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","‑Tɛ ʋ nɩ 'le 'hru wlɔn, ‑ye nahuon ꞊de le ‑Yusu, ɔ nɔ: «'Ɛ nɩ ‑tɛgbi, ‑n di 'o muu, 'n di ‑mʋ ‑wɔn 'nɩ kʋɛ.» ");
INSERT INTO ted_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «'Kwlagbodɛhʋɛi, ɩ kɔ gbopɛɛlɛi, nʋblɩ 'ɩ kɔ 'lɛ, kɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n 'de gbopɛɛlɛ kɔ, ‑tɛ 'n di 'o ke lɛ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","‑Ye kɛ ‑Yusuu nahuon ‑ye ye po, ɔ nɔ: «Kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'na ‑naagbopʋyu ‑hɛ!» ‑Ye nahuon a ‑gbɛ, ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Tɔɔnyɔ, ‑ha 'mʋ mɛ lɛ, 'na bu, ‑ɔ 'kʋ, ꞊bo muo 'o ‑ha, 'plɩɩ 'mʋ 'le di, 'mʋ ‑mʋ ‑wɔn naa.» ");
INSERT INTO ted_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","‑Ye ‑Yusu nɔ: «Ɛ 'de ‑na ‑kʋan, 'ke ‑bo ‑ha 'o 'kʋkʋkui lɛ. Mu, ‑bo le nahuin, ‑ɛ mɔ, Nyɩsʋa, ɔɔ ‑hʋa bɔ kɔɔ ꞊nʋ win ke.» ");
INSERT INTO ted_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","‑Ye kɛ nahuon ‑yee po: «Tɔɔnyɔ, 'n di ‑mʋ ‑wɔn 'nɩ kʋɛ, 'mʋ ‑na ‑naagbopʋyu ‑hɛ. Kɛɛ, ‑ha 'mʋ mɛ lɛ, ꞊bo mu 'na 'dʋkʋɛ wlu gba, 'plɩɩ 'mʋ 'le di, 'mʋ ‑mʋ ‑wɔn naa.» ");
INSERT INTO ted_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","‑Ye kɛ ‑Yusu nyo ye po: «‑N 'we ꞊nɔ nahuon ꞊nʋ ye, ‑ɔ klɩ ‑ci, 'plɩɩ ‑ɔ 'kee 'a ‑cicie. Nahuon 'bɔ nɩ 'o, 'bɔɔ lɛ ‑kʋan a nunue nu, ‑ye Nyɩsʋa 'die 'le ‑wɛ bɔ nuo 'a ‑kʋannunyɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye Kʋkɔnyɔ ‑Yusu ‑ha 'le du 'mʋ nahuin a (72) ‑wlɩɩ ta ꞊tu 'o ‑pu ꞊tu 'o 'hɔn ‑ye, 'ɔ le 'waa 'hɔn ‑hɔn, 'ke bʋ 'nyɛ 'hru, bʋ mu 'le 'dɩɛ 'bii ꞊nʋ 'mʋ, kɔ ‑tɛgbi ꞊nʋ, ‑ɛ kɔ 'mʋ 'a ‑gbɛ, ɔ di ‑wɛ 'le mu. ");
INSERT INTO ted_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kɛ ɔ nyu ye po, ɔ nɔ: «꞊Gbla, ‑ɔ ꞊hlu, ɔ ‑huo nɩ, kɛɛ ꞊gbla'cɛnyʋ 'de ‑huo. 'A ‑tɩ, ba 'batɩ ‑cikɔnyɔ lɛ, bɔ le 'a ‑kʋannunyʋ ‑ye, ʋ 'mʋ 'a mʋ 'mʋ ‑hɛ, a 'mʋ ꞊gbla 'cɛ. (Ɛ 'we ꞊nɔ ye, ba 'batɩ Nyɩsʋa lɛ, ɔ 'mʋ 'a nahuin ‑ye le, ʋ 'mʋ 'a mʋ 'mʋ ‑hɛ, a 'mʋ nahuin ‑ye lɛ 'kukue, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi.) ");
INSERT INTO ted_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ba mu 'klɛɛ. 'Nɩɩ 'a mʋ 'nɩ lee, ‑ɛ 'we ꞊nɔ 'blayuo ye, ʋʋ 'le ‑jio ‑hɛyri lee. ");
INSERT INTO ted_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","'Baa mu, a nɩ gba 'le 'wliyɛ, a nɩ gba 'le ‑wɛ blɔ, kɔ 'suei 'hɛɛn. Kɔ, a nɩ ‑wlɛn 'le 'hru wlɔn, nahuin a 'wiogblɛpo‑tɩ. ");
INSERT INTO ted_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","'Ba pa 'le kayu ꞊de gbo, ye‑hɛdɛ, kɛ ba po: Nyɩsʋa bɔ nɩ 'o 'a mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nahuon 'bɔ nɩ 'le kayu a ‑gbɛ gbo, 'bɔ nye ‑hʋa, 'ke Nyɩsʋa bɔ nɩ 'o ꞊nɔ ‑wɔn, bɔ nuo ꞊hapʋdɛ 'mʋ, ‑ye Nyɩsʋa dio 'o ‑wɔn 'nɩ nɩ. Kɛɛ, 'bɩa 'bɔ 'nɩnɩ ‑hʋɛ, ‑ye Nyɩsʋa 'deɛ bɔ nɩ 'o ꞊nɔ ‑wɔn, ‑ye ɔ 'deɛ bɔ nuo ꞊hapʋdɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kayu ꞊nʋ, ‑ʋ kɔ gbo ʋ di 'le 'a mʋ kwa 'blee, 'kee nɩ, ba nɩ 'le gbo. A nɩ na 'le kayuo gblɛ. Dididɛ ʋ di 'a mʋ ‑nyi, nɛ‑ ba di, kɔ, 'nie ʋ di 'a mʋ ‑nyi, nɛ‑ ba 'na, ‑ɛ nue, nahuon ‑gbo, ‑ɔɔ ‑kʋan nu, ɔ blɛ ye 'pɛɛlɛ. ");
INSERT INTO ted_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","'Ba 'ya 'dɩɔ ꞊de 'mʋ, 'bʋ 'ble 'a mʋ kwa, ba di dididɛ ꞊nʋ, ʋ di 'a mʋ ‑nyi, ");
INSERT INTO ted_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","kɔ, ba da Nyɩsʋa, 'ke bɔ ‑wɔ 'dɩɔ a ‑gbɛ a nahuin a 'kʋɛi, kɔ, ba le ꞊nʋ, ‑ɛ mɔ: Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'a mʋ win ke kɔɔ, ɩ 'mʋɛɛ yrɛ. ");
INSERT INTO ted_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kɛɛ, 'ba pa 'le 'dɩɔ ꞊de 'mʋ, 'bʋ 'de 'a mʋ kwa 'ble, ba mu 'le 'dɩɔ a ‑gbɛ a 'dika. Kɛ ba po: ");
INSERT INTO ted_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'A nɩ 'dɩɔ a 'pupu ꞊nʋ, ‑ʋ nɩ ‑a mʋ bʋɩ lɛ, ‑a di ‑a nɩ bʋɩ 'nɩ bʋbla, ‑ɛ die nu, ‑a 'mue 'a mʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa a yrʋ 'bʋ yɛ 'a mʋ, ‑ye 'a mʋ'ʋ nɩ, ‑ʋ nue 'a nɩ dɩɔnʋ ‑wɔn. Kɛɛ, ba kɔ 'a yiyie: Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di nahuin win ke kɔɔ, ɩ 'mʋɛɛ yrɛ. ");
INSERT INTO ted_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","'Nɩɩ 'a mʋ 'nɩ le, ‑nyrɔwɔ ꞊nʋ ‑kɔ 'mʋ Nyɩsʋa di 'o nahuin ‑bati lɛ poo, 'dɩɔ a ‑gbɛ a nahuin, Nyɩsʋa diu ꞊tue ꞊sʋɛ, ɛ 'mʋ 'o nahuin ꞊nʋ 'mʋ ‑hi, ‑ʋ mɔ Sodɔmʋkʋɛ, ‑ʋ kɔ nunuklɔ nyre la 'yi lɛ.» ");
INSERT INTO ted_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","(Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ:) «‑Juukʋɛ ꞊nʋ, ‑ʋ nɩ 'le Kolasɛdɩɔ 'mʋ, kɔ Bɛtɩsaidadɩɔ 'mʋ, 'jrɔ 'ke 'o ꞊nʋ ‑wɔn, ‑ɛ nue, 'ŋmilɛka‑tɔplɩ ꞊nʋ, 'n nuu 'le ꞊nʋ ‑wɔn, 'bɩa 'nɩ nui wɛn 'le nahuin ꞊nʋ ‑wɔn, ‑ʋ 'de ‑Juukʋɛ, ‑ʋ nɩ 'le Tilɩdɩɔ kɔ Sidɔdɩɔ 'hɛɛn 'mʋ, si la, nahuin a ‑gbɛ, ʋ 'mʋ la wɔlɩ lɛ nu, ʋ 'mʋ la ‑tɔplɩ ‑hʋɩn 'hʋɩn 'mʋ lɛ pue, ʋ 'mʋ la 'waa dɩɔnʋ 'tɔpupu 'ŋmlɛ, ‑ɛ die nu, ʋ 'mue nahuin tɔɔ, ‑ɛ mɔ, ʋʋ ‑hʋa bʋ hie 'o dɛ 'kuku a nunue gbo, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","'Ɛ mɔ ‑tɛɛ, ‑nyrɔwɔ ‑kɔ 'mʋ Nyɩsʋa di 'o nahuin ‑bati lɛ poo, nahuin ꞊nʋ, ‑ʋ nɩ 'le Kolasɛdɩɔ kɔ Bɛtɩsaidadɩɔ a ‑gbɛ 'mʋ, 'waa ‑bati di ke nɩ 'klɩ, ɩ 'mʋ 'o Tilɩdɩɔ kɔ Sidɔdɩɔ a nahuin a nɩnɩ 'mʋ ‑hi. ");
INSERT INTO ted_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","'Plɩɩ nahuin ꞊nʋ, ‑ʋ nɩ 'le Kapɛnaɔdɩɔ 'mʋ, ʋ nɩ ‑hie 'le 'lu ‑wɔn lɛ, ‑ɛ mɔ, Nyɩsʋa diu 'le 'nɩ 'yaa ‑yaayaa, ʋ 'mʋ yakɔ ye kʋɛ. Kɛɛ, ɔ diu 'le 'nɩ ꞊tɩɔ ‑tɩɔtɩɔ, ʋ 'mʋ 'le ‑tʋtʋ a bʋgbo nyre.» ");
INSERT INTO ted_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Kɛ ɔɔ lele 'a ‑naagbopʋ ye po, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔɔ 'a mʋ nʋa ye gbo po, ‑ye ɛ 'we ꞊nɔ ye, 'mɔɔ nɩ, ɔɔ nʋa ye gbo po, kɔ, nahuon 'bɔ bla 'a mʋ ye, ‑ye ɛ 'we ꞊nɔ ye, 'mɔɔ nɩ, ɔ bla ye. 'Plɩɩ ‑ye nahuon, 'bɔ bla 'mʋ ye, ‑ye ɛ 'we ꞊nɔ ye, Nyɩsʋa, ‑ɔɔ lee nɔ 'mʋ 'klɔ ke, nɔ‑ɔ nɩ, ɔ bla ye.» ");
INSERT INTO ted_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","‑Tɛ ti gbi ‑hi, ‑ye ‑naagbopʋ a (72) ‑wlɩɩ ta ꞊tu 'o ‑pu ꞊tu 'o 'hɔn ꞊nʋ, ‑Yusu le o, 'ke bʋ mu Nyɩsʋa a ꞊hapʋtitie po, ʋ ꞊hɩan ‑wɔn, 'manʋ nyu nu 'dɔ, ʋ nɔ: «Kʋkɔnyɔ, 'ye kɛ, 'kuo ‑hʋɩn, 'bɩa ꞊baa ‑na 'dʋ da, ꞊ba nyo 'le ‑wɔn 'prɛɛ, ɔɔ ‑wɛ 'o ‑a mʋ 'nɩ ꞊tuu, 'ɔɔ 'o nahuin ke 'mʋ ‑hɔn.» ");
INSERT INTO ted_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","‑Ye ‑Yusu nɔ: «‑Tɛ 'nɩɩ 'le yakɔ 'mʋ lɛ ta, ‑ye 'n 'ye Satan nɩ, ‑ɔ mɔ 'kuo ‑hʋɩn a nyɩgblaka, 'ɔ ble 'le yakɔ 'mʋ, ‑ɛ 'we ꞊nɔ ‑tɛ ye, ‑tɛ bɛ 'nɩnɩ ꞊tɩ wɛn. ");
INSERT INTO ted_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ba 'ye kɛ, 'n ‑nyi 'a mʋ 'klɩ, 'ke ba na hrei kɔ ‑gayɩ 'hɛɛn ke, kɔ, 'ke ba ‑wɔ Nyɩsʋa a yraanyɔ Satan a 'klɩ gbo. Dɛ ꞊de 'deɛ bɛ nu 'a mʋ dɛ 'klan 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kɛɛ, a nɩ nu 'le 'manʋ, ‑tɛ 'kuo ‑hʋɩn, ɔɔ 'o 'a mʋ ꞊tuu. Kɛɛ, dɛ ‑kɔ 'manʋ ba nu, nɛ‑ mɔ ‑tɛ Nyɩsʋa nu, 'ɔ 'crɩɩ 'a nɩ 'dʋɩ, 'ke 'le yakɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tii ‑do a ‑gbɛ a ti 'yri, ‑ye Nyɩsʋa a ‑Hihiu nue nɩ, 'manʋ 'ʋ ‑hi ‑Yusu wlɔn. Kɛ ɔɔ Nyɩsʋa ye po, ɔ nɔ: «'Na Bu o, ‑mɔ mɔ yakɔ kɔ ‑tʋtʋ 'hɛɛn a Kʋkɔnyɔ. 'Nɩɩ ‑mʋ 'nɩ baa, ‑tɛ ‑n nu, ꞊nɩ ‑hli ‑na nunu‑tɔplɩ nahuin ꞊nʋ 'yi ke, ‑ʋ plɛ, ‑ʋ mɔ ꞊tɔkɔnyʋ, kɔ 'crɩɩnɩɛiyinyʋ, 'plɩɩ, nahuin ꞊nʋ, ‑ʋ plɛ, ‑ʋ 'de dɛ ꞊de yi, nʋ‑ ‑n tɔɔ ‑tɔplɩ a ‑gbɛ. 'Nɩɩ ‑mʋ 'nɩ baa, ‑ɛ nue, kɛ'ɛ nɩ, ‑n nu 'a ‑hʋhʋa. ");
INSERT INTO ted_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","'Na Bu, ɔ ‑nyi 'mʋ 'klɩ, 'ke 'o ‑tɔplɩ 'bii ke. Nahuin 'die yi, nahuon a gblo tio‑ ꞊bo 'ya 'mʋ, 'bɛ 'de 'n Buu ‑do. Ʋ 'die ‑wɛ yi, nahuon a gblo tio‑ 'n Bu 'ya 'mʋ, 'bɛ 'de 'mɔ, ‑ɔ mɔ 'a 'Yu. 'Plɩɩ, 'ɛ nɩ nahuon, 'nɩɩ ‑hʋa ꞊bo ꞊tui ye, ɔ yie ‑wɛ nɩ, nahuon a gblo tio‑ 'n Bu 'ya 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","‑Tɛ ‑Yusu kɔ 'a ‑naagbopʋʋ ‑do 'hɛɛn, ʋ nɩ 'o, kɛ ɔ nyu ye po, ɔ nɔ: «'A mʋ ꞊nʋ, ‑ʋʋ ‑tɔplɩ 'bii ‑gbo 'ye, ba kɔ plɔ a bleelɛ! ");
INSERT INTO ted_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","'Nɩɩ 'a mʋ 'nɩ le, ti ‑hi la a ti 'yri a Nyɩsʋa a winwlɔn‑hɛnyʋ kɔ bodɩɔpʋ 'plɔplɔ 'hɛɛn, ʋ nye la lɛ 'nɩ ꞊mɔ, 'ke bʋ 'ye la ‑tɔplɩ gblakɩ ‑gbo, aa kɛ 'ye, kɛɛ, ʋ 'nɩ 'yi ꞊le la, kɔ, ʋ nye la ‑wɛ lɛ 'nɩ ꞊mɔ, 'ke bʋ 'wɔn la ‑wɛ ‑tɔplɩ gblakɩ ‑gbo, aa kɛ 'wɔn, kɛɛ, ʋ 'nɩ 'wɩn ꞊le la.» ");
INSERT INTO ted_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye Nyɩsʋa a teteitɔɔnyɔ ‑ye, ‑ɔ nɩ 'o, nɔ‑ 'ba ye 'mʋ, ɔ 'mʋ ‑Yusu 'mʋ lɛ ꞊tɔ, ‑ɛ die nu, ʋ 'mue 'ye, 'bɩa 'bɔ di ‑tɩ ꞊de ꞊tu, ‑ɩ 'de 'o ye 'sii, 'ɔ ꞊gbɔ wlɔn, ɔ nɔ: «Tɔɔnyɔ, dɛ tio‑ 'n kɔ ꞊bo nu 'le, ‑ɛ die nu, 'mʋ Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","‑Ye ‑Yusu nɔ: «Dɛ tio‑ ʋ 'crɩɩ 'le Nyɩsʋa a teteicrɩɩnɩɛ 'kwli 'mʋ? Dɛ ‑gbo, ʋ 'crɩɩ, ꞊nɩ nye ‑hre, ‑be' ‑nɩɩ 'a 'wʋnwɔn nu 'le?» ");
INSERT INTO ted_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","‑Ye ɔ nɔ: «‑N blɛ ye ‑bo nʋɛ ‑na Kʋkɔnyɔ Nyɩsʋa 'mʋ, 'ke 'le ‑na ꞊wlʋ 'bii ke, kɔ, 'ke 'le ‑na 'klɩ 'bii 'mʋ, kɔ, 'ke 'le ‑na 'lu a lɛ‑hielɛ 'bii 'kwli 'mʋ, kɔ, ‑n blɛ ye ‑bo nʋɛ ‑n 'be ‑tʋnahuon 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n nu ‑n dɩɔnʋ a 'mʋnʋɛlɛ.» ");
INSERT INTO ted_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","‑Ye ‑Yusu nɔ: «'A ‑tɛɛ, nɛ‑ɛ nɩ. Nu dɛ a ‑gbɛ, 'plɩɩ ꞊mʋ 'klɔ yrayrʋ a ‑gbɛ kɔ.» ");
INSERT INTO ted_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kɛɛ ‑ye teteitɔɔnyɔ a ‑gbɛ, ɔɔ ‑hʋa bɔ ‑nyi 'a dɩɔnʋ ꞊wɔn. Nɛ‑ mɔ bɔ ꞊gba ‑Yusu wlɔn, ɔ nɔ: «Nyɔ‑ mɔ 'klɛɛ 'n 'be ‑tʋnahuon 'le?» ");
INSERT INTO ted_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","‑Ye ‑Yusu nɔ: «Ɛ kɔ la nyɩbɛyu ꞊de. Nɔ‑ ‑hɔn 'le Jrusrɛdɩɔ 'mʋ, 'ɔɔ 'le Selikodɩɔ 'mʋ mu. ‑Tɛ ɔɔ 'klɛɛ mu, ‑ye ɔ bi 'le ‑balʋnyʋ ‑hɛyri, 'ʋ ‑hɩɔ wlawlɩ, ‑ɛ die nu, ʋ 'mʋ 'a ‑tɔplɩ 'yri, 'ʋ bio ‑bibi, 'ʋ dʋɔ 'lɩla, 'plɩɩ, 'ʋ hio 'o gbo, 'ʋ mu. ");
INSERT INTO ted_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bɔ pɛ 'klɛɛ 'o gbo, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyɔ ꞊de, nɔ‑ɔ 'le di. ‑Tɛ ɔ 'yo, ‑ye 'ke ɔ na 'le 'hru a 'pɩa ‑ye ke, 'ɔ ‑hi. ");
INSERT INTO ted_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","‑Tɛ ɔ mu 'klɛɛ, ‑ye Lefipʋyu ꞊de, ‑ɔ mɔ Nyɩsʋa a ‑cɔhlʋnpinyɔ a 'mʋ‑hɛnyɔ, nɔ‑ nyre 'o ‑tɛgbi a ‑gbɛ. ‑Tɛ ɔ nyre 'klɛɛ 'o, ɔ 'yo, ‑ye 'ke ɔ na 'le 'hru a 'pɩa ‑ye ke, 'ɔ ‑hi. ");
INSERT INTO ted_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","‑Tɛ ɔ mu 'klɛɛ, ‑ye Samalikʋɛyu ꞊de, ‑ɔ mɔ pʋpʋdakʋ a nahuon, nɔ‑ɔ 'le di. ('Ke ɔ nɩ 'o 'kasra ke gbo. 'Plɩɩ, ti a ‑gbɛ 'yri, Samalikʋɛ kɔ ‑Juukʋɛ 'hɛɛn, ʋ nyinyre la lɛ.) Samalikʋɛyu ‑mɛ ‑ye, ‑tɛ ɔ nyre 'o nahuon a ‑gbɛ 'hʋɩn 'mʋ, ɔ 'yo, ‑ye 'a wɔlɩ nyo nu 'dɔ, ");
INSERT INTO ted_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","'ɔ 'yɩyɔ 'o 'hʋɩn 'mʋ gbo ‑tɛɛ, 'ɔ nu 'nyra kɔ ‑wiin, 'ɔ nu 'a ꞊ji a ‑kʋan, kɔ, 'ɔ mʋɩ lɛ. ‑Tɛ ɔ ‑wɔ 'a ꞊ji a ‑kʋan a nunue ‑wɔn, 'ɔ 'yɔɔ 'o 'a 'kasra ke, 'ʋ mu 'le Selikodɩɔ 'mʋ, 'ke 'le 'dagbɩ a kayu ‑ye gbo, 'ɔ po 'a ꞊tɔ. ");
INSERT INTO ted_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","‑Tɛ ‑nyrɛ ‑nyɛ, ‑ye ɔ ‑ha 'le 'wliyɛ, 'ɔ ‑nye kayukɔnyɔ, ɔ nɔ: Nu 'wliyɛ ‑gbo, ‑bo kikle 'na nahuon ‑gbo lɛ. 'Bɩa 'wliyɛ a ‑gbɛ, 'bɛ 'de ‑huo, ꞊nɩ nu ‑n dɩɔnʋ a 'wliyɛ, ti ꞊nʋ ‑kɔ 'yri 'n di 'o ‑wɔn ꞊hɩaan, 'nɩ di 'le, 'n die ‑mʋ 'nɩ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","'Plɩɩ ‑Yusu 'mʋ mu ‑yrɛ, ‑ye kɛ ɔɔ lele teteitɔɔnyɔ ‑nɩ wɛn ye po, ɔ nɔ: «'Ke 'le ‑mʋ 'yi 'mʋ, nahuiin ta ꞊nʋ ‑hɛyri, nahuon tio‑ nu dɛ, ‑ɛ nyi ‑a mʋ tɔɔ, ‑ɛ mɔ, nyɩbɛyu ꞊nʋ, ‑balʋnyʋ bi, 'a 'be ‑tʋnahuoon nɩ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","‑Ye teteitɔɔnyɔ nɔ: «Nahuon ꞊nʋ, ‑ɔ nuo ꞊hapʋdɛ 'yi ꞊hlɔn lɛ, nɔ‑ɔ nɩ.» ‑Ye ‑Yusu nɔ: «‑Na ‑gbɛ, ꞊nɩ mu, dɛ a ‑gbɛ, nɛ‑ ‑bo nu.» ");
INSERT INTO ted_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ bi lele wlɔn 'hru, 'ʋ pa 'le 'dɩɔ ‑ye 'mʋ. 'Ke 'le 'dɩɔ a ‑gbɛ 'mʋ, 'ke nyrʋgba ꞊de nɩ 'le. 'A 'dʋ mɔ la Matɩ. Nɔ‑ 'ble ‑Yusu kwa, 'ke 'le 'a kayu gbo. ");
INSERT INTO ted_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","‑Tɛ ‑Yusu nɩ gbo, ‑ye ɔ ‑tʋa Nyɩsʋa a ‑tɩ a tɔɔlɛ gbo. 'Ke Matɩ a ‑gbɛ a ‑dɩayu nyrɔyu nɩ ‑wɛ 'o. 'A 'dʋ mɔ Mari. Nɔ‑ nɩ 'o ‑Yusu 'hʋɩn 'mʋ gbo, ‑ɛ die nu, ɔ 'mʋ 'a tɔɔwin nʋa ye gbo po. ");
INSERT INTO ted_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matɩ ‑mɛ ‑ye, kayu a ‑kʋan a gblegblei ꞊nʋ, nɩ‑ kɔ ‑tɩɩ ꞊nɔ 'kla ‑wliye 'yaa. Nɛ‑ mɔ bɔ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, ɔ nɔ: «Kʋkɔnyɔ, ꞊be ɛ 'nɩ 'yaa ꞊le ‑mʋ 'kla ‑wliye, 'ke 'n ‑dɩayu bɔ ‑ha 'mʋ mɛ lɛ, 'n ‑do ꞊bo nu ‑kʋan 'bii? 'A ‑tɩ, lo, bɔ ‑hɛ 'mʋ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","‑Ye Kʋkɔnyɔ ꞊tuo ‑wɔn, ɔ nɔ: «Matɩ o, ‑nɩɩ ‑n dɩɔnʋ ‑wliye 'yaa 'kla, kɔ, ꞊nɩɩ ꞊wlɩ lɛ naa, 'ke 'o ‑tɔplɩ 'plɔplɔ ke. ");
INSERT INTO ted_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kɛɛ, dɛɛ ‑do nɩ 'o, 'ɛ mɔ 'yilɛnɔdɛ. Dɛ a ‑gbɛ, nɛ‑ Mari ‑ha 'le. 'Plɩɩ nahuon ꞊de 'deɛ bɔ ‑hɩɛ ꞊nɔ kwa.» ");
INSERT INTO ted_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","‑Nyrɔwɔ ꞊de 'mʋ, 'ke ‑Yusu mu 'o ‑tɛgbi ‑ye, 'ɔɔ Nyɩsʋa da. ‑Tɛ ɔ ‑wɛ ‑wɔn, ‑ye 'a ‑naagbopʋyu ‑ye 'yɩyɔ 'o 'mʋ gbo 'hʋɩn, ɔ nɔ: «Tɔɔnyɔ o, Saan Batisɩ tɔɔ 'a ‑naagbopʋ nɩ, ‑tɛ ʋ di Nyɩsʋa a dɩda nu. ‑Na ‑gbɛ, tʋɛ ‑wɛ ‑a mʋ, ‑tɛ ‑a di Nyɩsʋa a dɩda nu.» ");
INSERT INTO ted_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","‑Ye kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «'Bɩa 'baa Nyɩsʋa da, kɛ ba po: ‑A nɩ Bu, nue, nahuin 'bii 'mue yi, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa. ‑Mɔɔ nɩ, ‑bɔ kɔɔ nahuin win ke. ");
INSERT INTO ted_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","‑Nye ‑a mʋ 'ɛ nɩ ‑nyrɔwɔ a dididɛ. ");
INSERT INTO ted_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","‑A nɩ dɛ 'kuku ‑gbo, ‑a nu, ‑hri 'a ‑tɩ ‑wɔn, ‑ɛ nue, dɛ 'kuku ‑gbo, nahuin nu ‑a mʋ 'mʋ, ‑aa ‑wɛ 'a ‑tɩ ‑wɔn 'nɩ ‑hri. ꞊Nɩ wɛɛn 'le ke, 'kuo ‑hʋɩn a nyɩgblaka nɩ ꞊tɔ 'le ‑a mʋ 'mʋ lɛ, ‑ɛ die nu, ‑a 'nɩ ꞊han ‑tɩ 'wla.» ");
INSERT INTO ted_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Kɛ ‑Yusuu lele ꞊nʋ ye po, ɔ nɔ: «꞊Bo pue nɩnatumupʋʋ 'hɔn a dɛ ye: 'Bɩa ꞊nɩ kɔ nɩnatumu, 'plɩɩ 'bɩa ꞊nɩ mu 'le ꞊nɔ ‑wɔn, 'tɔ‑hɛyri 'mʋ, ꞊nɩ lo, ‑ɛ mɔ: 'N kɔ 'dagbatayu. Nɔ‑ pa 'mʋ ye. 'Nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, ‑nye 'mʋ dididɛ. 'N 'de dididɛ kɔ, ꞊bo di ꞊se ꞊nɔ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","‑Tado, ‑na nɩnatumu a ‑gbɛ, ‑ɔ nɩ 'le 'a kayu gbo, kɛ ɔ di ‑mʋ ye po: ‑Nɩɩ 'mʋ 'mʋ ‑ha 'ku. 'N po 'o 'na 'maju nɩ ‑dodo. 'N kɔ 'na 'yuo꞊pli 'hɛɛn, ‑a pɛ gbo. 'N 'die 'le ‑wɛ ꞊bo di ye 'mʋ 'ba, 'mʋ ‑mʋ dididɛ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","‑Ye ‑Yusu nɔ lele: «'Nɩɩ 'a mʋ 'nɩ le, ꞊betɩ bɔ di ye 'mʋ 'ba, ɛ 'de bɔ 'ya ‑na nɩnatumu 'mʋ a ‑tɩ. Kɛɛ, ‑tɛ ‑n 'de 'yie a pɩpɩɛ kɔ, ‑n 'kɩɛ ‑hʋɔ, nɛ‑ die nu, 'ɔ 'mʋ ye 'mʋ 'ba, ɔ 'mʋ ‑mʋ ‑tɔplɩ 'bii ꞊nʋ ‑nyi, ‑nɩɩ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","'Nɩɩ 'a mʋ 'nɩ le, 'baa dɛ ‑hʋa, ba ‑hʋɛ Nyɩsʋa, ɔ 'mue 'a mʋ ‑nyi. 'Baa dɛ ‑hʋa, ba ꞊mʋɛ lɛ, a die 'nɩ 'ye. 'Baa ‑hʋa 'ke bʋ paa 'a mʋ kayu gbo, ‑ye ba bi gbɔgbɔ, ‑ye ʋ di 'a mʋ 'nɩ le: Ba di pa. ");
INSERT INTO ted_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","'Ɛ mɔ ‑tɛɛ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ Nyɩsʋa dɛ ‑hʋa, ‑ye ɔ die ꞊nɔ 'nɩ ‑nyi. Nahuon 'bɔɔ dɛ lɛ ꞊mɔ, ‑ye ɔ die 'nɩ 'ye. Nahuon 'bɔ nyra 'o ꞊gbuhan.ye gbo, 'bɔɔ gbɔgbɔ po, ʋ dio 'nɩ le, bɔ pa. ");
INSERT INTO ted_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‑Mɔ bu, ‑na 'yu 'bɔɔ ‑mʋ ‑hrin.e ‑hʋa, ꞊be ‑n dio ‑nyi hre, ");
INSERT INTO ted_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","kɔ, 'bɩa 'bɔɔ ‑mʋ hapɛ'yi‑ŋɔ ‑hʋa, ꞊be ‑n dio ‑nyi ‑gaya. ");
INSERT INTO ted_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","꞊Hapʋkɔ, 'a mʋ ‑tʋnahuin, 'a 'de ꞊hapʋnahuin, kɛɛ, ꞊hapʋ‑tɔplɩ, nɩ‑ aa 'mʋ lɛ 'jra, 'a nyi 'a nɩ 'yuo꞊pli ‑nyi. 'Bɩa 'bɛ nɩ lɛ 'mʋ, 'ke 'o 'a mʋ ‑wɔn, ‑ʋ kɔ ꞊wlɩ nyre 'yi lɛ, ‑ye 'a nɩ Bu, ‑ɔ nɩ 'le yakɔ 'mʋ, ‑ɔ kɔ ꞊wlʋ nɔ 'yi lɛ, 'ɛ mɔ ‑tɛɛ, ɔ di 'a ‑Hihiu nahuin ꞊nʋ 'nɩ ‑nyi, ‑ʋ nyu ꞊nɔ ‑hʋa.» ");
INSERT INTO ted_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusu bla la 'ku ‑hʋan lɛ, ‑ʋ nɩ 'o nahuon ꞊de ke 'mʋ. 'Ku ‑hʋan a ‑gbɛ, ʋ nue nɩ, nahuon a ‑gbɛ 'ɔ 'de 'prɛlɛ yi. ‑Tɛ 'ku ‑hʋan a ‑gbɛ, ʋ ‑hɔn 'o nahuon a ‑gbɛ ke 'mʋ, ‑ye nahuon a ‑gbɛ, ɔ ‑tʋa 'pʋprɛ gbo. ‑Ye nahuin ꞊nʋ, ‑ʋ nɩ 'o, ɩ saka ꞊nʋ nɩ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kɛɛ, kɛ ꞊ʋ ‑yee po, ʋ nɔ: «Bɛsebulɩ, ‑ɔ mɔ 'kuo ‑hʋɩn a nyɩgblaka Satan, nɔ‑ nyo 'klɩ ‑nyi, 'ke bɔ bla 'kuo ‑hʋɩn ꞊nʋ lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Nahuin ‑ye, ‑ʋ nɩ 'o, ʋʋ ‑hʋa bʋ ꞊tʋɔ 'mʋ lɛ, 'ʋ ꞊gbɔ wlɔn, 'ke bɔ nu 'ŋmilɛkadɛ, ɔ 'mue ꞊nʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa'a nɩ, ‑ɔɔ ꞊nɔ 'klɩ ‑nyi, 'ke bɔ bla 'kuo ‑hʋɩn lɛ. ");
INSERT INTO ted_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kɛɛ, ‑Yusu yi 'waa 'lu a lɛ‑hielɛ nɩ. Nɛ‑ nue, 'ɔ lu, ɔ nɔ: «꞊Bo pue dɛ ye: 'Ke 'le 'blʋgba 'kwli 'mʋ, nahuin 'bʋ 'bɛ ꞊tɩɔ lɛ, ‑ye 'blʋgba a ‑gbɛ, ɔ bi ꞊hlɔn, kayuo 'ɔɔ lɛ 'wʋwlɛ. ");
INSERT INTO ted_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","'A ‑tɩ, Satan 'bɔɔ 'a dɩɔnʋ ye ‑wɔn, ‑ye 'a 'blʋgba di bi ꞊hlɔn. A nɔ 'nɩ, 'nɩɩ lɛ bla 'kuo ‑hʋɩn, ‑ɔ nɩ 'o nahuin ke 'mʋ, ‑ɛ nue, Bɛsebulɩ, nɔ‑ɔ 'mʋ 'klɩ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","'Bɩa 'bɛ 'ya wɛn ꞊hapʋkɔ 'mʋ, nyɔ‑ɔ 'klɛɛ 'a nɩ nahuin 'klɩ ‑nyi 'le, 'ke bʋ bla 'kuo ‑hʋɩn lɛ? Dɛ ‑gbo, 'a nɩ nahuiin nu, ɛ nye ‑a mʋ 'nɩ tɔɔ, ‑ɛ mɔ, ‑tɩ ꞊nʋ, aa 'mʋ yɛɛ, ɩ mɔ hɩ'ɩ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ɛ 'de Satan, kɛɛ, Nyɩsʋa'a nɩ, ‑ɔɔ 'mʋ 'klɩ ‑nyi, 'ke ꞊bo bla 'kuo ‑hʋɩn lɛ, ‑ɔ nɩ 'o nahuin ke 'mʋ. Dɛ a ‑gbɛ, ɛ nye 'a mʋ 'nɩ tɔɔ, ‑ɛ mɔ, Nyɩsʋa ‑tʋa nahuin a win a kekɔɔlɛ gbo, 'ke 'le 'a mʋ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ɛ 'we ꞊nɔ ye, 'bɩa 'klɩnyɔ, 'bɔ kɔ ta‑wɔn‑tɔplɩ, 'ke 'le 'a kayu gbo, kɔ, 'bɔɔ 'a kayu a ‑gbɛ 'yie ꞊tu, nahuon ꞊de 'die 'le ‑wɛ bɔ pa 'le 'a kayu a ‑gbɛ gbo, bɔ 'yri 'a kʋkɔ‑tɔplɩ. ");
INSERT INTO ted_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kɛɛ, 'klɩnyɔ ‑ye, ‑ɔ nɩ 'klɩ ke, ‑ɔ ‑hi 'o ye‑hɛnahuon ꞊nʋ 'mʋ, 'bɔ nyre 'o, ‑ye ɔ ‑hɩɔ 'o wlɔn 'hru, 'ɔɔ ꞊nɔ 'a ta‑wɔn‑tɔplɩ kwa lɛ ‑ha, ɔ kuo ꞊wlʋ ye, 'ɔɔ 'a kʋkɔ‑tɔplɩ 'bii gba, 'plɩɩ 'ɔ nyi nahuin 'mʋ lɛ woo. ");
INSERT INTO ted_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nahuon 'bɔ nɩ 'o, ɔ kɔ 'mʋ 'hɛɛn, ꞊ba 'de pɛ, ‑ye ɛ 'we ꞊nɔ ye, ɔɔ 'mʋ ye 'nɩ ‑wɔn. 'Plɩɩ nahuon 'bɔ nɩ 'o, 'bɔ 'nɩnɩ ‑hɛ 'mʋ 'mʋ, 'ke ‑ba 'kukue nahuin lɛ, 'ke 'o Nyɩsʋa ‑wɔn, ‑ye nahuon a ‑gbɛ, ɔ nyu lɛ 'nɩ ‑gba, 'ʋʋ Nyɩsʋa ‑wɔn hren.» ");
INSERT INTO ted_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kɛ ‑Yusuu lele po: «'Bɩa 'ku ‑hʋan, 'bʋ nɩ 'o nahuon ke 'mʋ, 'plɩɩ 'bʋ ‑hɔn 'o ꞊nɔ ke 'mʋ, ‑ye 'ke ʋʋ 'le 'kwlayre gbo mu, 'ʋʋ gbonɩɩlɛ yrayrʋ lɛ ꞊mɔ. 'Bʋ 'de gbonɩɩlɛ 'ye, ‑ye kɛ ʋʋ 'a dɩɔnʋ ye po: 'N di de 'nɩ ‑mɛ, 'mʋ 'le gbonɩɩlɛ 'ka ꞊nʋ 'mʋ mu, 'n ‑hɔn o 'le 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","'Bɩa 'bʋ ꞊hɩan ‑wɔn, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, gbonɩɩlɛ a ‑gbɛ, ɛ 'hrɛn klɛ ‑tɛɛ, 'ɛ ‑hlɛntie. (Ɛ 'we ꞊nɔ ye, Nyɩsʋa a ‑Hihiu 'de 'o nahuon a ‑gbɛ ke 'mʋ nɩ.) ");
INSERT INTO ted_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","‑Ye 'ku ‑hʋan a ‑gbɛ, ʋ bla 'kuo ‑hʋɩɩn 'nɩpata ‑ye, ‑ɔ kɔ 'crɛ, 'ɔ ‑hi 'o ye‑hɛku a ‑gbɛ 'mʋ, ɔ 'bii a ‑gbɛ, 'ɔɔ ‑wɔn bibi, 'ɔɔ 'o nahuon a ‑gbɛ ke 'mʋ bi. ‑Ye 'klɛɛ, nahuon a ‑gbɛ, 'a 'klɔ nyre lɛ 'yi, 'ɛ ‑hi 'o 'a ye‑hɛklɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","‑Yusu nɩ 'le 'pʋprɛ kwa 'mʋ, ‑ye nyrʋgba ꞊de, ‑ɔ nɩ 'le nahuin ‑huohui ꞊nʋ ‑hɛyri, ɔ 'yaa 'le win, ɔ nɔ: «Plɔ a bleelɛ 'ke 'o nyrɔ ꞊nʋ ‑wɔn, ‑ɔ kɔ ‑mʋ, kɔ, ‑ɔ 'nya ‑mʋ!» ");
INSERT INTO ted_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «Nahuin ꞊nʋ, ‑ʋʋ Nyɩsʋa a wintɛ nʋa ye gbo po, 'plɩɩ ‑ʋ nye 'o ꞊tuu, sɛyɩ‑sɛyɩ, nʋ‑ kɔ plɔ a bleelɛ.» ");
INSERT INTO ted_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","‑Ye nahuin ‑huohui, ʋʋ lɛ 'nɩ 'kukue, 'ke 'o ‑Yusu 'hʋɩn 'mʋ. Kɛ ɔ nyu ye po, ɔ nɔ: «Ti ‑gbo 'yri a nahuin ‑gbo, 'waa nunuklɔ nyre lɛ 'yi. Ʋʋ ‑hʋa 'ŋmilɛkadɛ, ‑ɛ nye ꞊nʋ tɔɔ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee nɔ 'mʋ 'klɔ ‑gbo ke. Kɛɛ, Nyɩsʋa 'deɛ bɔ wɛɛn ke, 'ke bʋ 'ye 'ŋmilɛkadɛ ꞊de. 'Ŋmilɛkadɛɛ ‑do ꞊nʋ, Nyɩsʋa di nu, 'ke 'o ꞊nʋ ‑wɔn, ɛ di ye 'we 'ŋmilɛkadɛ ꞊nʋ, ɔ nu la, 'ke 'o 'a winwlɔn‑hɛnyɔ Jona ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","'Ŋmilɛkadɛ ꞊nʋ, Nyɩsʋa nu la, 'ke 'le Jona a 'klɔ ‑hɛyri, 'plɩɩ Ninifʋdɩɔ a nahuin 'ye la, kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'ke 'o 'mʋ ‑wɔn, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon. Nyɩsʋa di ‑wɛ nu 'ŋmilɛkadɛ, 'ke 'le 'na 'klɔ ‑hɛyri, ti ‑gbo 'yri a nahuin 'mue 'ye. ");
INSERT INTO ted_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","'Ɛ mɔ ‑tɛɛ, ‑tɛ Ninifʋdɩɔ 'mʋ a nahuin, ʋ 'wɔn la Jona a win, ‑ɔɔ la ꞊nʋ Nyɩsʋa a ‑tɩ ye ꞊tu, ‑ye ʋ hie la 'o 'waa dɛ 'kuku, ʋʋ la nu gbo, 'ʋ ‑nyi la 'waa 'klɔ 'bii Nyɩsʋa. ‑Ye 'klɛɛ, 'mɔ ‑gbo, ‑ɔ nɩ mɔ 'a mʋ ye gbo, 'n ‑hi 'o Jona a ‑gbɛ 'mʋ nɩ, kɛɛ, a 'nɩ ꞊tuu ꞊le 'o 'na win. Nɛ‑ nue, ‑nyrɔwɔ ‑kɔ 'mʋ Nyɩsʋa di 'o nahuin ‑bati lɛ poo, Ninifʋdɩɔ 'mʋ a nahuin a ‑gbɛ 'ʋ di ye 'mʋ 'ba, ʋ 'mʋ lɛ po, ti ‑gbo 'yri a nahuin, ʋ mɔ ‑tɩ'wlanyʋ, 'ke 'o Nyɩsʋa ye. 'Ya 'o lele 'lu, ti ‑hi la a ti 'yri, bodɩɔ ꞊de, nɔ‑ ‑hɔn la 'le ‑tɛgbi ‑pɛtu 'mʋ, ‑ɛ mɔ Sabablʋgba. Bodɩɔ a ‑gbɛ, ɔ mɔ la nyrʋgbaa nɩ. Nɔ‑ di la Jrusrɛdɩɔ 'mʋ, ɔ 'mʋ la bodɩɔ Salomɔ, ‑ɔ mɔ la Nyɩsʋa a nahuon a ꞊tɔwin 'wɔn. ‑Ye 'klɛɛ, 'mɔ ‑gbo, ‑ɔ nɩ mɔ 'a mʋ ye gbo, 'n ‑hi 'o Salomɔ a ‑gbɛ 'mʋ nɩ. Kɛɛ, a 'nɩ ꞊tuu ꞊le 'o 'na win. ");
INSERT INTO ted_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nahuon 'bɔ 'bɩa 'napɩ, ‑ye ɔ 'nɩ ‑hle ꞊le, mɔ, ɔ 'nɩ ꞊jre ꞊le kaka 'lu gbo, kɛɛ, 'ke ɔ nye 'o dɛ 'lu gbo ꞊tu, ‑ɛ die nu, nahuin ‑gbo, ‑ʋʋ 'le kayu gbo pa, ʋ 'mʋ lɛ yrii. ");
INSERT INTO ted_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","‑Tʋnahuon a ꞊wlʋ, ʋ 'we ꞊nɔ 'a 'yii ye, ‑ɩ nyo pepe' ‑nyi. ‑Na 'yii 'bɩ nu ‑tɛɛ, ‑ye ‑nɩɩ lɛ 'nɩ yrii ‑tɛɛ. Kɛɛ, ‑na 'yii 'bɩ kɔ kɩkla, ‑ye 'ke ‑n nɩ 'le gbɩgbɩyrɩ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","'A ‑tɩ, ꞊tu ‑n dɩɔnʋ 'yie, pepe' ꞊nʋ, ‑ɛ nɩ 'le ‑mʋ 'mʋ, ɛ 'nɩ ꞊han gbɩgbɩyrɩ ‑hɛ. ");
INSERT INTO ted_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","'Bɩa ‑na ꞊wlʋ 'bʋ nɩ 'le pepe' ‑hɛyri, gbɩgbɩyrɩ a dɛ ꞊de 'bɛ 'de 'le ‑na ꞊wlʋ ke nɩ, ‑ye ‑na ꞊wlʋ 'bii a ‑gbɛ, 'ke ʋ di 'le pepe' 'mʋ nɩ 'bii, ‑ɛ 'we ꞊nɔ 'napɩ ye, ‑ɛ nye nu, ꞊nɩɩ lɛ yrii.» ");
INSERT INTO ted_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","‑Tɛ ‑Yusu ‑wɔ 'pʋprɛ ‑wɔn, ‑ye Falisi꞊tumu a nahuon ꞊de, nɔ‑ dɔ dididɛ ‑wɔn. ‑Tɛ ‑Yusu pa 'le 'a ‑tɛ, 'ʋ nɩ 'o dɛdihuo ke gbo. ");
INSERT INTO ted_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","‑Ye 'klɛɛ, ‑tɛ ‑Juukʋɛ a teteii 'a ꞊tutue nu, ‑ɛ mɔ, nahuon bɔ yra kwa lɛ, 'plɩɩ ɔ 'mʋ dɛ di, ‑Yusu 'de lɛ nu. ‑Tɛ Falisi꞊tumu a nahuon a ‑gbɛ, ɔ 'ye, ‑ɛ mɔ, ‑Yusu 'de kwa lɛ yra, ‑ye ɛ saka ꞊nɔ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","‑Ye kɛ Kʋkɔnyɔ nyo ye po, ɔ nɔ: «'A mʋ Falisi꞊tumu a nahuin, 'a nɩ wlɔn'naapɔhlɩ kɔ dɛwlɔndiipɔhlɩ 'hɛɛn, nɩ‑ aa lɛ yra. Kɛɛ, 'ke 'le 'a nɩ ꞊wlɩ ke, 'yiyre kɔ 'crɛ 'hɛɛn, nɩ‑ 'yii 'le. ");
INSERT INTO ted_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","A bʋba nɩ ‑tɛɛ. 'Be a yie nɩ, ‑ɛ mɔ, Nyɩsʋa nu ‑tɔplɩ ꞊nʋ nɩ, ‑tʋnahuon a 'yie, ɛɛ 'ye, 'ɔ nu ‑wɛ ‑tɔplɩ ꞊nʋ, ‑tʋnahuon a 'yie 'nɩnɩ 'ye. 'Be a pui ‑tɛɛ, ‑tʋnahuon a ꞊wlʋ ꞊nʋ, 'yie 'nɩnɩ 'ye, Nyɩsʋa 'nɩ 'yu ꞊le ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Dɛ a kɔ ba nu, nɛ‑ mɔ, ‑tɔplɩ ꞊nʋ, ‑ɩ nɩ 'le 'a nɩ wlɔn'naapɔhlʋ 'kwli 'mʋ, kɔ 'a nɩ dɛwlɔndiipɔhlɩ 'kwli 'mʋ, ba ‑hɩ 'le, ba ‑nyi ꞊sʋɛnyʋ. 'Bɩa 'baa lɛ nu, ‑ye ‑tɔplɩ 'bii di 'o ye 'nɩ 'sii, 'ke 'o Nyɩsʋa ye, a 'mui ‑kʋan 'yri nuu. ");
INSERT INTO ted_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","'A mʋ Falisi꞊tumu a nahuin, 'jrɔ 'ke 'o 'a mʋ ‑wɔn! 'Bɩa 'ba kɔ hai ꞊nʋ, aa 'le dididɛ ‑wɔn po, kɔ 'ɛ nɩ 'dɩdɔdɛ 'cicrɛ, aa 'le ‑sadɛ 'kwli 'mʋ ‑ha, nɩ‑ kɔ dɛ a ‑pu a nɛnɛ aa 'le ‑ha, 'a nye Nyɩsʋa ‑nyi. Kɛɛ, a 'nɩ ‑hie ꞊le 'lu ‑wɔn lɛ, 'ke 'a nɩ nunuklɔ bɔ 'sii 'o ye, kɔ, ba nʋɛ Nyɩsʋa 'mʋ. Kɛɛ ‑ye dɛ a ‑gbɛ, nɛ‑ɛ nɩ, a kɔ ba nu wɛn, 'plɩɩ a 'mʋ ‑wɛ 'le 'a nɩ 'dɩdɔ‑tɔplɩ 'cicrɛi a ‑pu a nɩnɩ ‑ha, a 'mui Nyɩsʋa ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","'A mʋ Falisi꞊tumu a nahuin, 'jrɔ 'ke 'o 'a mʋ ‑wɔn! 'Bɩa 'ba mu 'le Nyɩsʋa a kayuo gbo, a nʋɛ 'mʋ nɩ, 'ke ba nɩ 'le ye 'mʋ gbo, ‑ɛ die nu, nahuin 'mʋ 'a mʋ 'ye ‑tɛɛ. Kɔ, 'bɩa 'ba mu 'le 'dika, a nʋɛ 'mʋ nɩ, 'ke nahuin bʋ po 'a mʋ 'wio gbo, 'ke 'le 'a nɩ 'o꞊tuulɛ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","'Jrɔ 'ke 'o 'a mʋ ‑wɔn, ‑ʋ 'de 'o ye 'sii, 'ke 'o Nyɩsʋa ye! A 'we ꞊nɔ 'dɛɛi ye, ‑ɩ 'de 'o ye 'sii, 'ke 'o Nyɩsʋa ye. ‑Tʋnahuin 'bʋ 'nɩnɩ yrii 'dɛɛi a ‑gbɛ, 'bʋ nyi klɛ na, ‑ye 'dɛɛi a ‑gbɛ, ɩ nye 'nɩ nu, 'ke ʋ 'de 'o ye 'sii, 'ke 'o Nyɩsʋa ye.» ");
INSERT INTO ted_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","‑Ye teteitɔɔnyʋ, ‑ʋ nɩ 'o, kɛ 'waa nahuon ‑ye ‑Yusu ye po, ɔ nɔ: «Tɔɔnyɔ, 'bɩa ꞊nɩɩ lɛ 'pʋprɛ nu, ‑ye ɛ ꞊hɛn 'nyrɛ, ‑a nɩ ‑gbɛ, ‑nɩɩ ‑wɛ ‑a mʋ ꞊tu tanɩ.» ");
INSERT INTO ted_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «'Jrɔ ‑wɛ 'ke 'o 'a mʋ teteitɔɔnyʋ ‑wɔn, ‑ɛ nue, aa nahuin hren tetei a gblegblei, ‑ɩ 'we ꞊nɔ bɛnɩ ye, ʋ 'de 'le 'buble ‑wɛ. 'Plɩɩ a 'nɩ ‑hɩʋ ꞊le 'mʋ, 'ke bʋ ꞊tuu 'o tetei a ‑gbɛ 'o. ");
INSERT INTO ted_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","'Jrɔ 'ke 'o 'a mʋ ‑wɔn, ‑ɛ nue, Nyɩsʋa a winwlɔn‑hɛnyʋ ꞊nʋ, 'a nɩ bunʋ, ʋʋ la lɛ 'lɩla, nʋ‑ kɔ 'dɛɛi aa ‑hlɛntie ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","‑Tɛ aa lɛ 'a nunue nu, a nye nahuin 'nɩ tɔɔ, ‑ɛ mɔ, dɛ ꞊nʋ, 'a nɩ bunʋʋ la nu, a wɛɛn ke, ‑ɛ nue, ʋ ‑mɛ ‑ye, ʋ 'la Nyɩsʋa a winwlɔn‑hɛnyʋ nɩ, a ‑mɛ ‑ye, 'aa 'waa 'dɛɛi ‑hlɛntie. ");
INSERT INTO ted_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","'Ɛ mɔ ‑tɛɛ, Nyɩsʋa ꞊nʋ, ‑ɔ kɔ ꞊tɔ, kɛ ɔ po la, 'ke 'o 'a mʋ ke, ɔ nɔ: 'N di ꞊nʋ ye ya winwlɔn‑hɛnyʋ, kɔ titieponyʋ 'hɛɛn, kɛɛ, ʋ di 'la ꞊ʋ ‑ye, ʋ 'mʋ ꞊ʋ ‑ye ꞊sʋɛ ꞊tue. ");
INSERT INTO ted_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","'A mʋ ꞊nʋ, Nyɩsʋa a yrʋ di 'a mʋ 'nɩ yɛ, 'ke 'o winwlɔn‑hɛnyʋ 'bii ꞊nʋ a ‑ta 'mʋ, ‑ʋ kɔ dablo ʋʋ la gblɛ 'wʋwla, kʋɛ la 'le ti ꞊nʋ 'yie 'mʋ gbo, ‑ɩ kɔ 'yri Nyɩsʋa nu la 'klɔ, ‑bo yɛ ti ‑gbo ke, ");
INSERT INTO ted_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","‑ɛ ꞊hɛn 'nyrɛ, kʋɛ la 'le Abɛlɩ a 'lɩla 'yie 'mʋ gbo, ‑bo yɛ Sakali ke, ‑ɔ mɔ Sakali ꞊nʋ, ʋ 'la la, 'ke 'le Nyɩsʋa a ‑cɔhlʋnpiilɛ kɔ 'a kayu a ‑gbahlɔn. 'Nɩɩ 'a mʋ 'nɩ le, ti ‑gbo 'yri a nahuin, nʋ‑ Nyɩsʋa a yrʋ di yɛ, 'ke 'o ‑tɔplɩ a ‑gbɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","'Jrɔ 'ke 'o 'a mʋ Nyɩsʋa a teteitɔɔnyʋ ‑wɔn. 'A nɩ tɔɔlɛ, ɛ ka 'hru ꞊nʋ ye, nahuin di gba, ʋ 'mue yi, ‑tɛ Nyɩsʋa, ɔɔ ‑tʋnahuin a waalɛ nu. 'A nɩ ‑gbɛ, a 'nɩ gba ꞊le 'hru a ‑gbɛ, 'plɩɩ 'a ka nahuin ꞊nʋ ye, ‑ʋʋ ‑hʋa ‑bʋ gbʋ wɛn.» ");
INSERT INTO ted_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","‑Tɛ ‑Yusu ‑wɔ 'pʋprɛ ‑wɔn, ‑ye ɔ ‑hɔn 'o ‑tɛgbi a ‑gbɛ 'mʋ nɩ. Nyɩsʋa a teteitɔɔnyʋ, ʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ʋ ‑mɛ ‑ye, kʋɛ 'le ti a ‑gbɛ 'yie 'mʋ gbo, ʋ ‑tʋa 'a yrʋ a lɛpupue gbo 'dɔ, 'ʋ nyo wlɔn lɛ ꞊gba 'ɛ nɩ ti, 'ke 'o ‑tɔplɩ 'plɔplɔ ke. ");
INSERT INTO ted_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Wlɔnlɛ꞊gbʋgba a ‑gbɛ 'kwli 'mʋ, 'kee nɩ, ʋʋ 'le naa, 'ʋ nyo 'mʋ lɛ ꞊tɔ, ‑ɛ die nu, 'bɔ ka, ʋ 'muo ‑tɩ yɛɛ. ");
INSERT INTO ted_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","‑Tɛ ‑Yusuu nahuin tɔɔ, ‑ye nahuin 'plɔplɔ ‑ye 'kukue lɛ. Nahuon ꞊de 'de 'le 'waa ‑hihre ‑wɛ. 'Waa ‑huhue a ‑tɩ 'ʋʋ klɛ nɩna. Ye‑hɛnahuin, ‑Yusuu 'le ‑wɔn 'prɛɛ, nʋ‑ mɔ 'a ‑naagbopʋ. Kɛ ɔɔ ꞊nʋ ye po: «Ba ꞊tu 'a nɩ dɩɔnʋ 'yie, 'ke 'o Falisi꞊tumu a nahuin ‑wɔn, ‑ʋʋ 'lii 'hɔn naa. 'Waa 'lii 'hɔn a naalɛ a ‑gbɛ, ɛ 'we ꞊nɔ ‑weyɛ ꞊nʋ ye, ‑ɛ pa, 'plɩɩ ‑ɛ nye nu, 'a 'bienʋ ‑wo 'ɔɔ ‑wɛ pa. ");
INSERT INTO ted_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ti di 'o 'nɩ nyre, ‑ɩ kɔ 'yri ‑tɩ a ‑tɛɛ di 'o pepe' 'mʋ bi, kɔ, ‑tɔplɩ ꞊nʋ, ‑ɩ ‑hli kɛ, nahuin 'bii 'mui yi. ");
INSERT INTO ted_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","'Bɩa 'ba bii ye, ‑tɩ ꞊nʋ, aa ꞊tu, ʋ di 'o ‑tɛ ꞊nʋ 'nɩ ꞊tuu, nahuin 'bii ‑wɛ 'le bʋ 'wɩɩn 'o. ‑Tɩ ꞊nʋ, a blee 'le gbo, aa ꞊tu, ‑tɛgbi ꞊nʋ, 'dʋ bii 'o ye, ʋ di 'nɩ ꞊tu, 'ke 'o nahuin 'bii ye.» ");
INSERT INTO ted_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","(Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ:) «'A mʋ ꞊nʋ, ‑ʋ mɔ 'na nɩnatumupʋ, 'nɩɩ 'a mʋ 'nɩ le: A nɩ pɩ 'le ‑tʋnahuin a hʋannʋ. 'A nɩ ‑plahʋɩɩn ‑do, nɩ‑ ʋ ‑wɛ 'le bʋ ‑wɔ gbo. Kɛɛ, ʋ 'de 'klɛɛ lele 'klɩ kɔ, 'ke bʋ nuu 'o 'a mʋ dɛ ꞊de 'yie 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kɛɛ, Nyɩsʋa, nɔ‑ kɔ hʋannʋ ba pɩ, ‑ɛ nue, nɔ‑ kɔ 'klɩ, 'ke bɔ ‑wɔ ‑tʋnahuon gbo, 'ɔ kɔ ‑wɛ 'klɩ, 'ke bɔ po 'le nahuon na ꞊nʋ 'mʋ, ‑ɔ 'nɩnɩ jre gbe. Iin, Nyɩsʋa, nɔ‑ kɔ hʋannʋ ba pɩ. ");
INSERT INTO ted_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","꞊Bo pue nʋblɩ 'cicrɛi a dɛ ye. 'Bɩa ꞊nɩ nyi ‑tɔ, ɩ 'nɩ po ꞊le ꞊die 'dɔ. Kɛɛ, nʋblɩ gbi a ‑gbɛ, 'a dɛ 'bɛ nɩ 'o, Nyɩsʋa yie nɩ. ");
INSERT INTO ted_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kɛɛ, a ‑mɛ ‑ye, 'lu‑pupuii ‑tie a kɔ, 'a nɩ Bu Nyɩsʋa a ‑gbɛ, ɔ ‑hri nɩ. Ɛ 'we ꞊nɔ ye, a kɔ 'mini 'dɔ, 'ke 'o Nyɩsʋa ye, 'ɛ ‑hi 'o nʋblɩ gbi 'plɔplɔ ꞊nʋ 'mʋ. 'A ‑tɩ o, a nɩ pɩ 'le ‑tʋnahuin a hʋannʋ!» ");
INSERT INTO ted_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«'Nɩɩ 'a mʋ 'nɩ le, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ ꞊tui, 'ke 'o nahuin ye, ‑ɛ mɔ, ɔ mɔ 'na nahuoon nɩ, ‑ye ‑batipo‑nyrɔwɔ 'mʋ, 'na ‑gbɛ, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di ‑wɛ 'nɩ ꞊tu, 'ke 'o Nyɩsʋa a lɛleenyʋ ye, ‑ɛ mɔ, nahuon a ‑gbɛ, ɔ mɔ 'na nahuoon nɩ. ");
INSERT INTO ted_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ ꞊tui, 'ke 'o nahuin ye, ‑ɛ mɔ, ɔ 'de 'mʋ yi, ‑ye ‑batipo‑nyrɔwɔ 'mʋ, 'na ‑gbɛ, 'n di ‑wɛ 'nɩ ꞊tu, 'ke 'o Nyɩsʋa a lɛleenyʋ ye, ‑ɛ mɔ, 'n 'dio yi. ");
INSERT INTO ted_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","'Ya 'o lele 'lu, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, nahuon ꞊nʋ, ‑ɔ di 'mʋ ‑tɩ ‑hʋɩn yrɛ ꞊tu, Nyɩsʋa ‑wɛ 'le bɔ 'wʋwla 'a dɛ 'kuku a ‑gbɛ nɩ. Kɛɛ, nahuon ꞊nʋ, ‑ɔ di Nyɩsʋa a ‑Hihiu ‑tɩ ‑hʋɩn yrɛ ꞊tu, Nyɩsʋa 'die 'le ‑wɛ bɔ 'wʋwla 'a dɛ 'kuku a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","'Bʋ klɩ 'a mʋ, 'ke ʋ 'mʋ 'le 'a mʋ ‑batipoolɛ 'mʋ gba, 'ke 'o Nyɩsʋa a kayuo a nyɩgblakɩ ye, kɔ 'ke 'o 'blʋgba a ye'mʋnaanyʋ ye, 'kla nɩ 'ya 'le 'a mʋ ‑wliye, 'ke 'o ‑tɛ a di 'waa klɛ‑hɩhɩalɛ nu a ‑ta 'mʋ, kɔ 'ke 'o ‑tɩ ꞊nʋ, a di ꞊tu a ‑ta 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","‑ɛ nue, ti a ‑gbɛ 'yri, ‑tɩ ꞊nʋ, a di ꞊tu, Nyɩsʋa a ‑Hihiu, nʋ‑ di 'a mʋ tɔɔ.» ");
INSERT INTO ted_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","‑Yusu bɔ nɩ 'le 'pʋprɛ kwa 'mʋ, ‑ye nahuon ‑ye, ‑ɔ nɩ 'le nahuin ‑hɛyri, kɛ ɔɔ ‑Yusu ye po, ɔ nɔ: «Tɔɔnyɔ, le 'na ‑dɩayu, 'ke ‑tɔplɩ ꞊nʋ, ‑a nɩ bu hie ‑a mʋ lɛ, ɔ kɔ 'mʋ 'hɛɛn ‑ba wi.» ");
INSERT INTO ted_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","‑Ye kɛ ‑Yusuu ꞊nɔ ye po, ɔ nɔ: «Nyɩbɛyu o, nyɔ ꞊de 'de 'mʋ 'a nɩ ‑batiponyɔ 'mʋ nuu, kɔ 'a nɩ ‑tɔplɩwonyɔ 'hɛɛn.» ");
INSERT INTO ted_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","‑Ye kɛ ɔɔ 'klɛɛ nahuin 'bii ꞊nʋ ye po, ɔ nɔ: «Ba ꞊tu 'a nɩ dɩɔnʋ 'yie, 'ke 'o kʋkɔ‑tɔplɩ 'plɔplɔ a 'mʋnʋɛlɛ a ‑ta 'mʋ. ꞊Betɩ nahuon bɔ 'ble 'dai kʋkɔ‑tɔplɩ kwa, ɔ 'de 'a ‑hʋnhlʋn kwa 'ble.» ");
INSERT INTO ted_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","‑Ye ɔ nyu ye po ‑talʋdʋ, ɔ nɔ: «Ɛ kɔ la dɛkɔnyɔ ꞊de. Nɔ‑ kɔ la ‑cii 'plɔplɔ, 'a 'dɩdɔ‑tɔplɩ 'ɩ 'wʋʋ la ꞊nɔ lɛ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kɛ ɔɔ 'klɛɛ 'a dɩɔnʋ ye po, ɔ nɔ: ‑Be' 'n di 'klɛɛ 'na 'dɩdɔ‑tɔplɩ ‑gbo a gbo꞊tutue nu 'le, ‑ɛ nue, 'n 'de 'a gbopoolɛ kɔ. ");
INSERT INTO ted_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","‑Ye ɔ nɔ: Dɛ 'n di nu, nɛ‑ ‑gbo: Kayuo 'bii, ‑ɔ kɔ gbo 'nɩɩ 'le 'na 'dɩdɔ‑tɔplɩ lɛ poo, 'n dio 'nɩ 'wla, 'mʋ 'a yrayrɩ po, ‑ɔ kɔ 'bʋbʋa di 'o 'a 'kɩ 'mʋ ‑hi. Nɩ‑ kɔ 'kwli 'mʋ 'n di 'le 'na ꞊gbla kɔ 'na kʋkɔ‑tɔplɩ 'bii po. ");
INSERT INTO ted_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","'Nɩ ‑wɛ ‑wɔn, kɛ 'n di 'n dɩɔnʋ ye po: 'N ꞊tu gbo kʋkɔ‑tɔplɩ 'plɔplɔ, ‑ɩ di 'mʋ 'mʋ ‑hɛ, 'ke 'le 'dai 'yrɩ 'kwli 'mʋ. 'A ‑tɩ o, ꞊bo nɩ gbo, 'mʋ ‑wle, 'mʋ dɛ di ‑tɛɛ, 'mʋ lɛ 'mre. ");
INSERT INTO ted_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kɛɛ ‑ye kɛ Nyɩsʋa nyo 'klɛɛ ye po, ɔ nɔ: ‑N bʋba nɩ ‑tɛɛ. 'Tɔyrʋwɔɔ ‑do ‑gbo 'mʋ, ‑n di 'nɩ 'kʋ. ꞊Nɩ 'kʋ 'klɛɛ, ‑tɔplɩ 'bii ‑gbo, ‑n ꞊tu gbo, dɛ tio‑ ɩ di 'o ‑mʋ pue 'le?» ");
INSERT INTO ted_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","‑Ye ‑Yusu nɔ lele: «Kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔɔ kʋkɔ‑tɔplɩ lɛ 'kukue, 'ke 'o 'a dɩɔnʋ ‑wɔn, kɛɛ, ‑ɔ 'de dɛ ꞊de kɔ, 'ke 'o Nyɩsʋa 'yi ke.» ");
INSERT INTO ted_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","‑Ye kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ: «Nɛ‑ nue, 'nɩɩ 'a mʋ le: Dɛ a di di, kɔ wlawlɩ a di 'hʋɩn 'mʋ lɛ pue, a nɩ hrɛti 'le, 'ke 'o ‑tɔplɩ a ‑gbɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","‑Hʋnhlʋn ‑gbo, aa po, ʋ mɔ dɛ gblakaa nɩ, 'ʋ ‑hi 'o dididɛ 'mʋ, kɔ, 'a nɩ ‑plahʋɩn, ɩ mɔ dɛ gblakaa nɩ, 'ɩ ‑hi 'o 'hʋɩn'mʋlɛpue‑tɔplɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ba 'ye kɛ 'mamʋɩ. Ɩ 'nɩ 'dɔ ꞊le 'ɛ nɩ dididɛ ꞊de, kɔ, ɩ 'nɩ 'cɛ ꞊le dɛ ꞊de, mɔ, ɩ 'de ‑wɛ 'kale kɔ, ‑ɛ kɔ 'mʋ ɩ di 'le dididɛ po. Kɛɛ, Nyɩsʋa, nɔ‑ nyi dididɛ ‑nyi. Kɛɛ, a ‑mɛ ‑ye, Nyɩsʋa, ɔ nʋɛ 'a mʋ 'mʋ nɩ, 'ɛ ‑hi 'o nʋblɩ 'mʋ. 'A ‑tɩ, ‑tɛ ɔɔ nu, 'ɔɔ nʋblɩ dididɛ ‑nyi, ɔ die ‑wɛ 'nɩ nu, ɔ 'mʋ 'a mʋ dididɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɛ 'de nahuon ꞊de kɔ, 'ke 'le 'a mʋ ‑hɛyri, 'a hrɛtilɛ a ‑tɩ, ‑bɔ kɔ 'klɩ, ‑bɔ po 'a ‑nyrɔwɩ a dɛ gbi ke, kɛ nɔ 'klɔ ‑gbo ke. ");
INSERT INTO ted_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","'A ‑tɩ, ‑tɛ a 'de 'klɛɛ 'klɩ kɔ, 'ke ba po 'a nɩ ‑nyrɔwɩ ke, a 'de 'klɛɛ lele hrɛtilɛ kɔ, 'ke 'o 'klɔ ‑gbo a ‑tɔplɩ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ba 'ye kɛ ‑piti ꞊nʋ, ‑tɛ 'a ‑pui nu 'yilɛnɩnɔ. ‑Piti a ‑pui a ‑gbɛ, ɩ 'we ꞊nɔ ‑tʋnahuon a wlawlɩ ye. Kɛɛ, ‑piti a ‑gbɛ, ɩ 'nɩ nu ꞊le ‑kʋan, kɔ, ɩ 'nɩ hra ꞊le wlawlɩ, 'plɩɩ ‑piti a ‑gbɛ 'ɩ nɔ 'yi lɛ. Kɛɛ ‑ye 'nɩɩ 'a mʋ 'nɩ le, bodɩɔ Salomɔ, ꞊hapʋkɔ, 'ɔ kɔ la dɛ, kɛɛ, ‑tɛ ‑piti a ‑pui nu 'yilɛnɩnɔ, Salomɔ a ‑gbɛ, ɔ 'de la 'a wlawlʋ kɔ, ‑bʋ nu la lɛ 'yilɛnɩnɔ. ");
INSERT INTO ted_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","'Bɩa Nyɩsʋa 'bɔ kɔ bɔ nɔɔ kɛ ‑piti a ‑pui 'yi lɛ, ʋ di ‑ŋa ‑ci, 'plɩɩ ʋ di ‑ŋa 'tɔ po, ꞊be 'a mʋ ꞊nʋ, ɔ nʋɛ 'mʋ, ɔ 'deɛ bɔ ‑nyi 'a mʋ 'hʋɩn'mʋlɛpue‑tɔplɩ? 'A mʋ ‑gbo, ‑ʋ 'de Nyɩsʋa ꞊wlʋ ye kuo ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","'A ‑tɩ, a nɩ 'wʋʋ 'le 'a nɩ 'kwli a ‑koto 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, nʋ‑ʋ ‑tɔplɩdʋ a ‑gbɛ 'lu ‑wɔn lɛ ‑hie 'ɛ nɩ ti. Kɛɛ, 'a nɩ Bu Nyɩsʋa, ɔ yi 'a nɩ ‑hʋhʋa‑tɔplɩ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Dɛ a blɛ ye ba ‑hie 'lu ‑wɔn lɛ 'ɛ nɩ ti, nɛ‑ mɔ, Nyɩsʋa bɔ kɔɔ 'a mʋ win ke, ‑ye ɔ di 'a mʋ 'a nɩ ‑hʋhʋa‑tɔplɩ a ‑gbɛ 'nɩ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","(Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ:) «'A mʋ ꞊nʋ, ‑ʋʋ 'mʋ ‑wɔn naa, ‑ʋ mɔ 'na nahuin, a 'de ‑huo, kɛɛ, a nɩ pɩ 'le hʋannʋ. 'A nɩ Bu Nyɩsʋa, ɔ ‑ha 'le 'a mʋ 'mʋ du, ɔ 'mʋ 'a mʋ 'a 'klɔ yrayrʋ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ba plo 'a nɩ kʋkɔ‑tɔplɩ, ba ‑ha 'le 'a 'wli ꞊nʋ, ba ‑nyi ꞊sʋɛnyʋ. Ɛ 'we ꞊nɔ ye, ba ꞊mɔ 'wli a wlɔnpoodɛ ꞊nʋ lɛ, ‑ɛ 'nɩnɩ di lɛ cɩcrɛ. Ba 'kukue kʋkɔ‑tɔplɩ lɛ, 'ke 'le yakɔ 'mʋ, ‑tɛ ɩ 'nɩnɩ di 'le gbo ‑wɛɛ, kɔ, ‑tɛ 'yrinyʋ 'de 'le nyinyre ‑wɛ, kɔ, ‑tɛ 'hrɔ 'de 'le ‑wɛ bɔ nyree 'le ‑tɔplɩ 'yi lɛ. ");
INSERT INTO ted_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","'Nɩɩ lɛ 'pʋprɛ nu, ɛ 'we ꞊nɔ ye, ‑tɛ 'a nɩ kʋkɔ‑tɔplɩ nɩ 'o, 'ke 'a nɩ ꞊wlʋ nɩ ‑wɛ 'o.» ");
INSERT INTO ted_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","(Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ:) «Ba ‑wɛ ‑wɔn, a 'mʋ ‑kʋan nu. Ba 'we ꞊nɔ ‑kʋannunyʋ ꞊nʋ ye, ‑ʋʋ 'waa 'masɛ ꞊nʋ a 'lediti ‑pre, ‑ɔ mu 'blɩ'mʋpaalɛ ke. ‑Tɛ 'a ‑kʋannunyʋ, ʋʋ nu, kɛ'ɛ nɩ, ba nu ‑wɛ. 'Tɔ 'mʋ, 'plɩɩ ɔ 'mʋ 'le di, ʋ ‑wɛ ‑wɔn, 'ke bʋ nu ‑kʋan, 'waa 'napɩi 'nɩ jre ꞊le gbe. 'Bɩa 'bɔ di 'klɛɛ 'le, 'bɔ bibie 'maju, ‑ye ʋ ‑hɩʋ ꞊nɔ ye. ");
INSERT INTO ted_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","‑Kʋannunyʋ a ‑gbɛ, 'bɩa 'waa 'masɛ 'bɔ di 'le, 'bɔ yʋ 'o ‑preelɛ 'mʋ gbo, 'bʋ 'nɩnɩ ŋmo, ‑ye bʋ kɔ plɔ a bleelɛ. 'Nɩɩ 'a mʋ 'nɩ le, ɔ di ‑wɔn 'nɩ ‑wɛ, ɔ 'mu le, bʋ nɩ gbo, ʋ 'mʋ dɛ di, 'a ‑gbɛ, ɔ 'mʋ 'o bi, ɔ 'mʋ didi‑tɔplɩ ‑hie. ");
INSERT INTO ted_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","'Bɩa 'bɔ di 'le 'tɔ‑hɛyri 'mʋ, ‑hee' 'tɔ‑hɛyri 'bɛ ‑hi, 'bɔ yʋ 'o ‑preelɛ 'mʋ gbo, 'bʋ 'nɩnɩ ŋmo, ‑ye bʋ kɔ plɔ a bleelɛ. ");
INSERT INTO ted_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ba kɔ 'a 'mʋlɛyriilɛ: 'bɩa kayukɔnyɔ 'bɔ yi wɛn ti ꞊nʋ ‑kɔ 'yri 'yrinyɔ di wɛn 'le di, ɔ dio wɛn 'nɩ ‑pre, ‑ɛ die nu, 'yrinyɔ a ‑gbɛ, ɔ 'nɩ ꞊han wɛn 'a kayu wa. ");
INSERT INTO ted_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Nɛ‑ nue, 'a nɩ ‑gbɛ, ba nɩ 'o ‑preelɛ 'mʋ, a nɩ ŋmo 'le, ‑ɛ nue, ti ꞊nʋ kɔ 'yri a 'nɩnɩ di 'o 'mʋ ‑pree, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'ke 'n di 'le di.» ");
INSERT INTO ted_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","‑Yusu bɔ po ‑talʋdʋ a ‑gbɛ, ‑ye Piɛlɩ nɔ: «Kʋkɔnyɔ o, ꞊be ‑a ‑do a ‑tɩɩ nɩ, ꞊nɩ po ‑talʋdʋ ‑gbo, ‑hee', nahuin 'bii a ‑tɩɩ nɩ?» ");
INSERT INTO ted_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","‑Ye Kʋkɔnyɔ nɔ: «Ba 'we ꞊nɔ ‑kʋannunyɔ ꞊nʋ ye, ‑ɔ kɔ 'lu a lɛ‑hielɛ, kɔ, 'a 'masɛ ‑wɛ 'le bɔ kuo ꞊wlʋ ye. Nahuondʋ a ‑gbɛ, 'a 'masɛ, 'bɔɔ 'dagba 'mʋ mu, nɔ‑ ɔ di 'a kayu 'bii lɛ hie, ‑ɛ die nu, dɛditi 'bɩ nyre 'o, ɔ 'mʋ 'a 'bie ‑kʋannunyʋ 'ɛ nɩ ‑nyrɔwɔ a dididɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","'A 'masɛ 'bɔ ‑hɔn 'le 'dagba 'mʋ, 'bɔ yɔ 'o ‑kʋan 'yie 'mʋ gbo, ‑ye ‑kʋannunyɔ a ‑gbɛ, bɔ kɔ plɔ a bleelɛ. ");
INSERT INTO ted_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","'Nɩɩ 'a mʋ 'nɩ le, 'a 'masɛ dio 'mʋ nuu 'a ‑tɔplɩ a 'yie꞊tunyɔ gblaka. ");
INSERT INTO ted_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kɛɛ, ‑kʋannunyɔ a ‑gbɛ 'bɔ plɛ, 'a 'masɛ a 'lediti, ɩɩ gbo 'nɩ ‑wlɛn, 'bɔ ‑tʋa 'a 'bie ‑kʋannunyʋ a bibie gbo, kɔ, 'bɔɔ 'a dɩɔnʋ dididɛ kɔ nɔ 'hɛɛn wlɔn ‑hie, ");
INSERT INTO ted_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","‑ye 'a 'masɛ a ‑gbɛ, ɔ di 'le 'nɩ di, ‑nyrɔwɔ ‑kɔ 'mʋ ‑kʋannunyɔ a ‑gbɛ, ɔ 'nɩnɩ dio 'o ‑pree, kɔ ‑haawɔ ꞊nʋ, ɔ 'de yi. 'Bɔ di 'klɛɛ 'le, ‑ye ɔ dio ye gba ti 'yaklɩ, 'plɩɩ ɔ 'muo ꞊sʋɛ ꞊tue, ‑ɛ 'we ꞊nɔ nahuin ꞊nʋ ye, ‑ʋ 'de Nyɩsʋa ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‑Kʋannunyɔ 'bɔ nɩ 'o, dɛ ꞊nʋ, 'a 'masɛɛ ‑hʋa, 'bɔ yie, 'plɩɩ 'bɔ 'nɩnɩ ‑hʋa bɔ nue, ‑ye ʋ dio ꞊tue ꞊sʋɛ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kɛɛ, ‑kʋannunyɔ 'bɔ nɩ 'o, dɛ ꞊nʋ, 'a 'masɛɛ ‑hʋa, 'bɔ 'die yi, 'plɩɩ 'bɔɔ ‑tɔplɩ ꞊nʋ nu, ‑ɩ blɛ ꞊sʋɛ a ꞊tuelɛ ye, ꞊sʋɛ ꞊nʋ, ʋ dio ꞊tue, ɛ 'deɛ bɛ ‑huo. Nyɩsʋa 'bɔ ‑nyi nahuon ‑tɔplɩ 'plɔplɔ, ‑ye ɔ di ꞊nɔ ‑hʋa ‑tɔplɩ 'plɔplɔ, kɔ, 'bɔ hie nahuon ‑tɔplɩ 'plɔplɔ lɛ, ‑ye ɔ di ꞊nɔ ‑hʋa ‑tɔplɩ 'plɔplɔ, ɩ 'mʋ 'o 'a dɛ ꞊nʋ 'mʋ ‑hi, ɔ hie o ꞊nɔ lɛ.» ");
INSERT INTO ted_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Kɛ ‑Yusuu lele po, ɔ nɔ: «'N di 'le ꞊le, 'mue nu, na 'mʋ wlɩn, kɛ nɔ ‑tʋtʋ ke. 'N nye wɛn 'nɩ ‑hʋa 'dɔ, 'ke na a ‑gbɛ bɔ wlɩn wɛn ‑dodo. ");
INSERT INTO ted_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Kɛɛ, 'plɩɩ na a ‑gbɛ, ɔ 'mʋ wlɩn, 'n kɔ ꞊bo 'ye ‑tado ꞊sʋɛ. 'Plɩɩ ꞊sʋɛ a 'yiye a ‑gbɛ, ɛ 'mʋ 'o nyre, 'na ꞊wlʋ 'mʋɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","A nɩ 'ye 'le, ‑ɛ mɔ 'n di nɔ ‑tʋtʋ ke nɩ, 'mue nu, nahuin 'mʋ kegbowɛɛnlɛ kɔ. Kɛɛ, 'n di 'le ꞊le, 'mue nu, nahuin 'mʋ wo. ");
INSERT INTO ted_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ɛ 'we ꞊nɔ ye, kʋɛ 'klɛɛ mɔ gbo, kayugbokʋɛɛ ꞊hun 'bʋ nɩ 'o, ʋ di 'nɩ wo, nahuiin ta, ʋ 'mʋ nahuiin 'hɔn ye ‑wɔn. kɔ, nahuiin 'hɔn, ʋ 'mʋ nahuiin ta ye ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Bu di 'a 'yu nyɩbɛyu ye 'nɩ ‑wɔn, 'yu nyɩbɛyu ‑mɛ ‑ye, ɔ 'mʋ 'a bu ye ‑wɔn; 'dii 'mʋ ‑wɛ 'a 'yu nyrɔyu ye ‑wɔn, 'yu nyrɔyu ‑mɛ ‑ye, ɔ 'mʋ ‑wɛ 'a 'dii ye ‑wɔn; 'yu a nyrɔ 'mʋ 'a 'dɔɔ ye ‑wɔn, 'dɔɔ ‑mɛ ‑ye, ɔ 'mʋ ‑wɛ 'a 'yu a nyrɔ ye ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Kɛ ‑Yusuu lele nahuin ꞊nʋ ye po, ɔ nɔ: «'Bɩa 'ba 'ye, ‑ɛ mɔ 'nu nɩ 'le yrayrɩ, kɛ aa po: 'Nu di 'nɩ di. 'Ɛ mɔ ‑tɛɛ, 'nu a ‑gbɛ 'ʋʋ di. ");
INSERT INTO ted_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kɔ, 'ba 'ye, ‑ɛ mɔ 'nu 'de 'le yrayrɩ lɛ nɩ, kɛ aa po: 'Yrʋ di 'nɩ hʋan. 'Ɛ mɔ ‑tɛɛ, 'yrʋ a ‑gbɛ 'ʋʋ hʋan. ");
INSERT INTO ted_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","'A mʋ nahuin ꞊nʋ, ‑ʋʋ 'lii 'hɔn naa, aa yakɔ kɔ ‑tʋtʋ 'hɛɛn a ‑tɔplɩ 'mʋ lɛ 'nɩ yrii, 'a nye 'ye, ‑tɛ ‑nyrɛ di 'mʋ nɩ. Kɛɛ, ‑tɔplɩ ‑gbo, Nyɩsʋaa nu, ‑ɩɩ kɛ 'lu ‑wɔn mue, ti ‑gbo 'yri, a 'nɩ ‑hʋa ꞊le ba yrii 'mʋ lɛ, dɛ tio‑ bɩ ꞊hɛn 'nyrɛ. ");
INSERT INTO ted_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Dɛ‑ kɔ ‑tɩ 'a nɩ ‑gbɛ 'a 'nɩnɩ 'ye, ‑tɛ a kɔ ba nu 'a nɩ dɩɔnʋ a naalɛ ‑tɛɛ? ");
INSERT INTO ted_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ɛ 'we ꞊nɔ ye, 'bɩa nahuon 'bɔɔ ‑mʋ ‑tɩ yɛɛ, ‑ɛ nue, ‑n 'ble kwa 'a 'wliyɛ, 'plɩɩ ɔ kɔ ‑mʋ 'hɛɛn, 'baa 'le ‑batipoolɛ 'mʋ mu, ꞊tu 'o 'klɩ, ‑ɛ die nu, ‑tɛ a 'kɩɛ nɩɛ 'hru wlɔn, a 'mʋ ke gbo wɛɛn, ɔ 'nɩ ꞊han 'le ‑mʋ ‑batiponyɔ ye gba, ‑batiponyɔ 'nɩ ꞊han ‑mʋ ‑sadapʋ kwa po, ʋ 'nɩ ꞊han ‑mʋ ꞊jɩ 'mʋ po. ");
INSERT INTO ted_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","'Nɩɩ ‑mʋ 'nɩ le, 'bʋ po ‑mʋ ꞊jɩ 'mʋ, 'ke ‑n di 'le ꞊jɩ a ‑gbɛ 'mʋ nɩ, 'wliyɛ 'bii ꞊nʋ, ‑n 'ble kwa, ꞊mue 'pɛɛ, 'plɩɩ ꞊mʋ ꞊jɩ 'mʋ ‑hɔn.» ");
INSERT INTO ted_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ti a ‑gbɛ 'yri, nahuin ꞊de, nʋ‑ mu 'le ‑Yusu ‑wɔn, 'ʋ lo dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, 'ke 'le Galileblʋgba 'mʋ, 'ke 'o nahuin ‑ye a ‑ta 'mʋ. Nahuin a ‑gbɛ, ti ꞊nʋ kɔ 'yri ʋʋ o 'o ‑cɔhlʋn pii, 'ke 'o Nyɩsʋa ye, 'ke ‑gʋlʋnʋma Pilatɩ le o 'a 'sɔyuo, bʋ 'lʋ o, 'waa dablo ꞊nʋ, ‑ɔ 'wlɛ gbo, 'ɔ bi 'le ‑cɔhlʋndɛhʋɛ a dablo ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Bʋ ꞊gba 'klɛɛ ‑Yusu wlɔn, ‑ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «꞊Be a pui ‑tɛɛ, ‑ɛ mɔ, Galilekʋɛ a ‑gbɛ, ‑tɛ ʋ nu lɛ 'waa 'lɩla, ꞊be ɛ ꞊hɛn 'nyrɛ, 'waa dɛ 'kuku, ɛ ‑huo nɩ 'dɔ, 'ɛ ‑hi 'o 'waa 'bienʋ Galilekʋɛ a nɛnɛ 'mʋ? ");
INSERT INTO ted_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","'Ʋʋn, kɛ 'nɩɩ 'a mʋ ye po, 'ba 'de 'o 'a nɩ dɛ 'kuku gbo hie, 'ba 'de 'a nɩ 'klɔ 'bii Nyɩsʋa ‑nyi, kɛ'ɛ nɩ, a di ‑wɛ lɛ'kʋkʋlɛ nu. ");
INSERT INTO ted_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","'Ya 'o lele 'lu, nahuiin ‑pu ꞊tu 'o ‑yehɛn‑yehɛn, ‑ʋ 'kʋ, 'ke 'le Jrusrɛdɩɔ 'mʋ, 'waa ‑tɩ bɩ bi 'le 'a mʋ 'kwli 'mʋ. Yrayrɩkayudʋ ꞊nʋ, ‑ʋ ꞊hɩan 'le ‑wɔn lɛ, ‑ʋ nɩ 'le Jrusrɛ a 'dɩ꞊tɩɔ ꞊nʋ 'mʋ, ʋʋ Siloe daa, nʋ‑ bi ꞊nʋ ke, 'ʋ 'kʋ. ꞊Be a pui lele ‑tɛɛ, ‑ɛ mɔ, ɛ ꞊hɛn 'nyrɛ, 'waa dɛ 'kuku, ɛ ‑huo nɩ 'dɔ, 'ɛ ‑hi 'o 'waa 'bienʋ Jrusrɛkʋɛ a nɛnɛ 'mʋ? ");
INSERT INTO ted_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","'Ʋʋn, kɛ 'nɩɩ 'a mʋ ye po, 'ba 'de 'o 'a nɩ dɛ 'kuku gbo hie, 'ba 'de 'a nɩ 'klɔ 'bii Nyɩsʋa ‑nyi, kɛ'ɛ nɩ, a di ‑wɛ lɛ'kʋkʋlɛ nu.» ");
INSERT INTO ted_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","‑Ye ‑Yusu po lele ꞊nʋ ye ‑talʋdʋ, ɔ nɔ: «Nyɩbɛyu ꞊de, nɔ‑ 'dɔ figietu, ‑ɛ mɔ, tugbɛ, ‑ɛɛ 'kui tʋ, 'ke 'le 'a ‑ci 'kwli 'mʋ. 'Dai ti bɩ ‑hi, ‑ye ‑cikɔnyɔ a ‑gbɛ, ɔ di 'le ꞊le, ɔ 'mʋ tugbɛ a ‑gbɛ a 'kui ‑ha, kɛɛ, ɔ 'de 'le ꞊nɔ 'kuoo ‑do 'klɔ 'yee. ");
INSERT INTO ted_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","‑Ye kɛ ɔɔ ‑ci'yie꞊tunyɔ ye po, ɔ nɔ: Ta 'o lɛ, ɛ mɔ 'klɛɛ 'yrɩɩ ta, 'ɛ nɩ ti, kɛ 'nɩɩ nu, 'nɩɩ nɔ di, 'mʋ tugbɛ ‑gbo a 'kui ‑ha. Kɛɛ, 'bɩa 'nɩ di 'le, 'nɩ 'yee ꞊le 'le ꞊nɔ 'kuoo ‑do 'klɔ gbo. 'A ‑tɩ, hrɛ! ‑Ɛ nue, ɛ nɩ mɔ ‑tʋtʋtɩɔ ‑gbo ke ‑gbʋgbɛ. ");
INSERT INTO ted_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kɛɛ ‑ye ‑ci'yie꞊tunyɔ ꞊tuo ‑wɔn, ɔ nɔ: ‑Hɩɛ mɛ lɛ, 'yrʋ ‑gbo bʋ ‑hi. 'N kɔ ꞊bo 'ble 'hʋɩn 'mʋ lɛ, 'mʋ 'le ‑tʋtʋ yrayrʋ po. ");
INSERT INTO ted_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","'Nɩ nue 'klɛɛ, 'n pue ‑tɛɛ, 'yrʋ ‑de' di, ɛ di tʋ 'kui. 'Bɩa 'bɛ 'de ꞊nɛ, ‑ye ‑n ‑wɛ 'le ‑bo hrɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","‑Wuwle‑nyrɔwɔ ꞊de 'mʋ, ‑Yusu 'ɔɔ nahuin Nyɩsʋa a ‑tɩ tɔɔ, 'ke 'le Nyɩsʋa a kayu gbo. ");
INSERT INTO ted_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nyrʋgba ꞊de nɩ 'o. Nɔ‑ 'ku ‑hʋan nɩ 'o ke 'mʋ. 'Ku ‑hʋan a ‑gbɛ, nʋ‑ puo 'kʋɛ ye. 'A 'kʋɛ a ‑gbɛ, 'a 'yrʋ a ‑pu ꞊tu 'o ‑yehɛn‑yehɛn a nʋnʋ nɩ gbo. Ɔ 'klii ye. Ɔ 'die 'le ‑wɛ bɔ 'wʋ 'le lɛ. ");
INSERT INTO ted_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","‑Tɛ ‑Yusu 'yo, ‑ye ɔ dɔ nɩ, ɔ nɔ: «Nyrʋgba o, ‑na 'kʋɛ ‑wɛ nɩ,» ");
INSERT INTO ted_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","'ɔ puo dabʋɩ 'lu gbo. Tii ‑do a ti 'yri, ‑ye ɔ 'wʋ 'le lɛ, 'ɔ ‑tʋa Nyɩsʋa a baalɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kɛɛ ‑ye Nyɩsʋa a kayu a nyɩgblaka, ‑ɔ nɩ 'o, ‑tɛ ɔ 'ye dɛ a ‑gbɛ, ‑Yusu nu, ‑ye ɔ bi 'mʋ yrʋ, ‑ɛ nue, ‑wuwle‑nyrɔwɔ 'mʋ, 'ke ‑Yusu ‑wɔɔ 'o nahuon a 'kʋɛ. ‑Ye kɛ nyɩgblaka a ‑gbɛ, ɔɔ nahuin ‑huohui ꞊nʋ ye po, ɔ nɔ: «'Ke 'le 'wee 'kwli 'mʋ, ‑nyrɔwɩɩ ‑huonnɔ nɩ 'le, ‑ɩ kɔ 'kwli 'mʋ ‑a blɛ ye ‑ba nuu 'o ‑kʋan. 'A ‑tɩ, ‑nyrɔwɩ a ‑gbɛ 'kwli 'mʋ, 'kee nɩ, ba di 'le, ɔ 'mʋ 'a nɩ 'kʋɛi ‑wɔ. A nɩ di 'le 'le ‑wuwle‑nyrɔwɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","‑Ye kɛ Kʋkɔnyɔ nyo ye po, ɔ nɔ: «'A mʋ ‑gbo, ‑ʋʋ 'lii 'hɔn naa. 'Ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ kɔ bri kɔ 'ɛ nɩ 'wlugbadɛ, ꞊be ɔ 'nɩ ꞊wlɩɩ ꞊le gbo, ‑wuwle‑nyrɔwɔ 'mʋ, ‑ɛ die nu, ɔ 'mui 'le 'naalɛ 'mʋ gba? ");
INSERT INTO ted_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","'Plɩɩ nyrʋgba ‑gbo, ‑ɔ mɔ ‑a nɩ bu gblaka Abrahamʋ a 'yuo a 'yu ‑ye, Satan mʋa, 'ke 'le 'yrɩɩ ‑pu ꞊tu 'o ‑yehɛn‑yehɛn 'kwli 'mʋ, ꞊be ɛ 'de 'o lɛ nɔɔ, 'ke ꞊bo ‑wɔ 'a 'kʋɛ ‑wuwle‑nyrɔwɔ 'mʋ?» ");
INSERT INTO ted_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye 'a yraanyʋ ꞊nʋ, ‑tʋɩ nyu nu 'dɔ. Kɛɛ, nahuin ‑ye ꞊nʋ, ‑ʋ nɩ 'o, ʋ kɔ plɔ a bleelɛ, 'ke 'o 'yilɛnɔ‑tɔplɩ 'bii ꞊nʋ, ‑Yusuu nu a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «'N di po ‑talʋdʋ, 'mue 'a mʋ tɔɔ, ‑tɛ Nyɩsʋaa nu, 'ɛ kɔ nahuin a ‑dodo, 'ɔ kʋʋ win ke, 'plɩɩ nahuin ‑ye 'ʋʋ klɛ bii. ");
INSERT INTO ted_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Dɛ a ‑gbɛ, ɛ 'we ꞊nɔ 'dɩdɔdɛ ꞊nʋ ye, ‑ɛ kɔ 'yɛɛ 'cɩmɩ 'dɔ, 'ɛ ‑hi 'o 'dɩdɔ‑tɔplɩ ‑ye a 'yɔ 'mʋ. 'Dɩdɔdɛ a 'yɛɛ a ‑gbɛ, nɛ‑ nahuon ꞊de gba, 'ɔ 'dʋɛ 'le 'a ‑ci ke, 'ɛ ꞊ga, 'ɛ ‑hɛ tugbɛ gblaka, 'a babʋɩ ‑hɛyri, nʋblɩ 'ɩɩ 'le 'lɛ poo.» ");
INSERT INTO ted_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","‑Ye kɛ ‑Yusuu lele ꞊nʋ ye po ɔ nɔ: «꞊Bo po ‑talʋdʋ ‑ye, 'mue 'a mʋ tɔɔ, ‑tɛ Nyɩsʋaa nu, 'ɛ kɔ nahuin a ‑dodo, 'ɔ kʋʋ win ke, 'plɩɩ nahuin ‑ye 'ʋʋ klɛ bii. ");
INSERT INTO ted_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Dɛ a ‑gbɛ, ɛ 'we ꞊nɔ 'flɔɔ a 'yaadɛ ye, nyrʋgba po 'le 'flɔɔpupu ‑huohui ‑wɔn, 'ɔ nyʋɔ ‑nyʋanyʋa, 'flɔɔ 'bii 'ɔ 'ya.» ");
INSERT INTO ted_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","‑Yusu 'kɩɛ nɩɛ 'le Jrusrɛdɩɔ 'mʋ a 'hru wlɔn, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. ‑Tɛ ɔɔ nu, 'ɔɔ 'dɩɛ ꞊tɩɔ lɛ 'bɛ, kɛ ɔɔ nu, 'ɔɔ Nyɩsʋa a ‑tɩ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","A 'wɔ ꞊de 'mʋ, nahuon ꞊de, nɔ‑ ꞊gbɔ wlɔn, ɔ nɔ: «Nahuin ꞊nʋ, Nyɩsʋa di waa, 'ke 'o 'a ‑bati a lɛpupue ‑wɔn, ꞊be ʋ 'deɛ bʋ ‑huo?» ‑Ye nahuin ꞊nʋ, ‑ʋ nɩ 'o, ɔ ꞊tu ‑wɔn, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Paalɛ ꞊nʋ, ‑ɛɛ 'a mʋ Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ paa, ɛ 'cɩmɩ lɛ 'yri. 'Bɩa 'ba nye ‑hʋa, ba pa 'le Nyɩsʋa a 'klɔ yrayrʋ a ‑gbɛ 'kwli 'mʋ, ‑ye ba ꞊tu 'o 'klɩ, a 'mʋ 'o paalɛ a ‑gbɛ 'yri naa. 'Nɩɩ 'a mʋ 'nɩ le, nahuin 'plɔplɔ, ʋ die lɛ 'nɩ ꞊mɔ, 'ke bʋ pa 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ. Kɛɛ, ʋ 'deɛ bʋ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dɛ ɛ di ye 'we, nɛ‑ ‑gbo: Kayukɔnyɔ, 'ke ɔ di 'le dɛdiilɛ 'mʋ ye 'mʋ 'baa, ɔ 'mʋ 'maju ꞊gba. A ‑mɛ ‑ye, 'ke a di 'le ‑patʋ 'mʋ nɩ, a 'mʋ 'maju bibie, a 'mʋ ‑wɛ lɛ po: Kʋkɔnyɔ o, ‑ha ‑a mʋ 'maju ye. Kɛ ɔ di po, ɔ 'mʋ 'a mʋ ‑wɔn ꞊tu: 'N 'de 'a mʋ yi. ");
INSERT INTO ted_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","‑Ye kɛ a dio ye po: ‑N kɔ ‑a mʋ 'hɛɛn, ‑a mʋʋ o 'o ‑tɛgbii ‑do dɛ dii, kɔ, ꞊nɩɩ o Nyɩsʋa a ‑tɩ tɔɔ, 'ke 'le ‑a nɩ 'dɩɛ a 'dika. ");
INSERT INTO ted_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kɛ ɔ di lele 'a mʋ ye po: 'N 'de 'a mʋ yi. Ba hren 'mʋ ‑wɔn, ‑ɛ nue, a 'bii ꞊nʋ, 'yilɛnyre‑tɔplɩ ꞊nʋ, Nyɩsʋa 'nɩnɩ ‑hʋa ba nu, nɩ‑ aa nu. ");
INSERT INTO ted_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ti a ‑gbɛ 'yri, a di 'ye 'a nɩ bunʋ Abrahamʋ, Yisakɩ kɔ Sakɔbʋ 'hɛɛn, kɔ Nyɩsʋa a winwlɔn‑hɛnyʋ 'bii, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ. A ‑mɛ ‑ye, ʋ di 'le 'a mʋ 'mʋ po ‑patʋ. 'Ke a di 'o ꞊hien wee, kɔ, 'ke a di ‑wɛ 'o yrʋ poo. ");
INSERT INTO ted_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ti a ‑gbɛ 'yri, 'klɔ a ꞊gɛii ‑hɛn ‑gbo 'yri, 'ke nahuin di 'le 'mʋ lɛ ‑hɔn, ʋ 'mʋ lɛ 'kukue, ʋ 'mʋ dɛ ‑wɔn didi, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","‑Ye 'klɛɛ, nahuin ‑ye, ‑ʋ nɩ 'le 'waa 'bienʋ bʋ gbo, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, nʋ‑ di ‑tado 'o 'waa 'bienʋ 'lu ye nɩ, kɔ, nahuin ‑ye, ‑ʋ nɩ 'o 'waa 'bienʋ 'lu ye, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, nʋ‑ di ‑tado 'le 'waa 'bienʋ bʋ gbo nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tii ‑do a ‑gbɛ 'yri, Falisi꞊tumu a nahuin ꞊de, nʋ‑ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, 'ʋ lo, ʋ nɔ: «‑Tɛgbi ‑gbo, ‑n nɩ mɔ, ‑hɔn nɔ 'mʋ, ‑bo mu 'le ‑tɛgbi ‑ye, ‑ɛ nue, 'kɩɩn Helɔdɩ, ɔɔ ‑na 'lɩla lɛ 'nɩ ꞊mɔ.» ");
INSERT INTO ted_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","‑Ye kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «Ba mu, ba le Helɔdɩ a ‑gbɛ, ‑ɔ kɔ gblagblʋ, ‑nɔ 'gbekle, ‑ɛ mɔ: Kɛkɛ ‑gbo, kɔ ‑ŋaŋa 'hɛɛn, 'nɩɩ lɛ bla 'kuo ‑hʋɩn ꞊nʋ, ‑ɔ nɩ 'o nahuin ke 'mʋ, kɔ, 'nɩɩ nahuin a 'kʋɛi ‑wɔ, ‑ye ꞊nyrɛɛ, 'n ‑yra 'na ‑kʋan 'lu. ");
INSERT INTO ted_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Kɛɛ, kɛkɛ ‑gbo, kɔ ‑ŋaŋa, kɔ ꞊nyrɛɛ 'hɛɛn, 'n kɔ ꞊bo gba 'na 'hru 'lu ‑wɔn, 'mʋ 'le Jrusrɛdɩɔ 'mʋ nyre, ‑ɛ nue, ɛ 'de 'o lɛ nɔɔ, 'ke bʋ 'la Nyɩsʋa a winwlɔn‑hɛnyɔ, 'ke 'le ‑tɛgbi ‑ye, 'bɛ 'de 'le Jrusrɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","'Nɩɩ Jrusrɛ 'mʋ a nahuin 'nɩ le: Nyɩsʋa 'bɔ lee nɔ 'a mʋ 'a winwlɔn‑hɛnyʋ ‑wɔn, a nyu ‑wɔn lɛ po 'hɛ, 'a nyu 'la. 'Ɛ nɩ ti, 'n nye o 'nɩ ‑hʋa, 'ke ꞊bo 'kukue o mɔ 'a mʋ lɛ, kɛ mɔ 'mʋ 'hʋɩn 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ hapɛ'gbaa nu, 'ɔɔ 'a 'yuo꞊pli lɛ 'kukue, 'plɩɩ, 'ɔ nyi ke gbo ꞊jri, kɛɛ, a 'die ke wɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ɛ nɛ‑ kɔ ‑tɩ Nyɩsʋa 'mʋ 'o 'a nɩ 'dɩɔ gbo hie, a ‑do, a 'mʋ 'a nɩ dɩɔnʋ lɛ kikle. 'Nɩɩ 'a mʋ 'nɩ le, kʋɛ 'klɛɛ mɔ gbo, a 'deɛ ba 'ye 'klɛɛ lele 'mʋ, ɛ 'mue gba ‑gbagba, ti ꞊nʋ, ɩ 'mʋ 'o nyre, ‑ɩ kɔ 'yri a di 'o lɛ poo: ‑Na 'wio, ‑mɔ ‑gbo, ‑ɔɔ 'le di, 'ke 'le Kʋkɔnyɔ Nyɩsʋa a 'dʋ 'kwli 'mʋ. Nyɩsʋa bɔ ‑nyi ‑mʋ ‑tɩ a 'yi'bʋaalɛ!» ");
INSERT INTO ted_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","‑Wuwle‑nyrɔwɔ ꞊de 'mʋ, Falisi꞊tumu a nyɩgblaka ꞊de, nɔ‑ da ‑Yusu dɛ di wɔn. ‑Tɛ ‑Yusu pa 'klɛɛ 'le 'a kayu gbo, ‑ye Falisi꞊tumu a nahuin, ‑ʋ nɩ 'o, ʋ nyo 'nɩ ‑gbɛɛ. ");
INSERT INTO ted_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","‑Ye 'klɛɛ, 'ke nyɩbɛyu ꞊de nyra 'o ꞊nɔ ye gbo. 'Kʋɛ nyo nu. Ɔ 'yii 'le lɛ. ");
INSERT INTO ted_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nyɩsʋa a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋ nɩ 'o, kɛ ‑Yusu nyu ye po: «‑A nɩ tetei, ɩ nyi 'nɩ ꞊tu, ꞊be ɛ nɔɔ 'o lɛ, ‑hee', ɛ 'de 'o lɛ nɔɔ, 'ke nahuon bɔ ‑wɔ 'hʋɩnhrennyɔ a 'kʋɛ ‑wuwle‑nyrɔwɔ 'mʋ?» ");
INSERT INTO ted_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kɛɛ, ʋ 'nɩ ‑hʋa ꞊le bʋ ꞊tuo ‑wɔn. Nɛ‑ mɔ ‑Yusu bɔ 'tʋ 'hʋɩnhrennyɔ lɛ, bɔ ‑wɔ 'a 'kʋɛ, bɔ lo: «‑Na 'kʋɛ ‑wɛ nɩ. ‑N ‑wɛ 'le ‑bo mu 'le kayu gbo nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","‑Ye kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «'Ke 'le 'a mʋ ‑hɛyri, nahuon a 'yu 'bɔ bi 'le 'nɩhʋɔ wlɔn, ɔ kɔ bɔ ‑hɩɔ 'le tii ‑do a ti 'yri, ‑hee' 'a bri 'bɛ bi ‑wɛ 'le 'nɩhʋɔ wlɔn, ɔ kɔ bɔ ‑hɩɛ 'le tii ‑do a ti 'yri, ꞊betɩ bɛ 'ya ‑wuwle‑nyrɔwɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye ʋ 'nɩ 'ye ꞊le ‑tɩ ꞊de, bʋ di ꞊nɔ ‑wɔn 'yri ꞊tu. ");
INSERT INTO ted_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","‑Tɛ ʋ nɩ 'klɛɛ 'o dɛdihuo ke, ‑ye ‑Yusu nye 'nɩ ‑gbɛɛ, ‑ɛ mɔ, nahuin 'bii ꞊nʋ, 'kabu da wɛn, 'ke ʋʋ 'o ꞊nɔ 'hʋɩn 'mʋ gblɛ nɩ. ‑Ye ɔ nyu 'mʋ po ꞊tɔ, 'ɔ pue 'blɩ'mʋpʋpa a dididɛ a dɛ ye, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«'Bɩa nahuon 'bɔ da ‑mʋ 'blɩ'mʋpʋpa a dididɛ ke, ꞊nɩ ꞊mʋɛ 'le lɛ, 'ke ‑bo nɩ 'o nahuon ꞊nʋ 'hʋɩn 'mʋ gbo, ‑ɔ da ‑mʋ, ‑ɛ nue, ɔ ‑wɛ 'le bɔ da nahuon ‑ye nɩ, ‑ɔ nɩ 'o ‑mʋ 'lu ye, ");
INSERT INTO ted_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","'plɩɩ nahuon a ‑gbɛ, ‑ɔ da a 'hɔn ‑wɛ a ‑gbɛ, bɔ le ‑mʋ: 'Ba ye 'mʋ, nahuon ‑gbo, ɔ 'mʋ nɔ 'mʋ 'hʋɩn 'mʋ gbo nɩ. ꞊Nɩ kɔ ‑bo ‑hɔn ‑ta 'mʋ, ‑ye ‑tʋɩ di ‑mʋ nu. ");
INSERT INTO ted_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ɛ nɩ nɩ 'le lɛ 'mʋ, kɛɛ, 'bʋ da ‑mʋ, ꞊nɩɩ gbo nɩ, hren nahuon ꞊nʋ ‑wɔn, ‑ɔ da ‑mʋ, ‑ɛ die nu, ti ꞊nʋ ‑kɔ 'yri ɔ di 'le di, ɔ 'mʋ ‑mʋ le: 'Mɛ o, 'ya 'lu, ‑bo di mɔ 'mʋ 'hʋɩn 'mʋ, ꞊mʋ gbo nɩ. Dɛ a ‑gbɛ, nɛ‑ die nu, ꞊mʋ yrɛ 'bʋa, 'ke 'o nahuin 'bii ꞊nʋ ye, ‑ʋ kɔ ‑mʋ 'hɛɛn ‑nɩ 'o dɛdihuo ke, ");
INSERT INTO ted_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","‑ɛ nue, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ 'le 'a dɩɔnʋ 'yaa, ʋ dio 'le 'nɩ ꞊tɩɔ, 'plɩɩ nahuon 'bɔ nɩ 'o, 'bɔɔ 'le 'a dɩɔnʋ ꞊tɩɔ, ʋ dio 'le 'nɩ 'yaa.» ");
INSERT INTO ted_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye kɛ ɔɔ 'kabu ye po, ‑ɔ da ꞊nɔ dɛ di wɔn, ɔ nɔ: «'Bɩa ꞊nɩɩ nahuin lɛ'mimre a dididɛ ‑wɔn da, ꞊nɩ da 'le ‑na nɩnatumupʋʋ ‑do, kɔ ‑na 'dɩayuo, kɔ ‑na ꞊tugba a nahuin, kɔ 'dɩɔ a nahuin, ‑ʋ mɔ dɛkɔnyʋ, ‑ɛ nue, dɛ ꞊nʋ, ‑nɩɩ ꞊nʋ ‑wɔn nu, ʋ ‑wɛ 'le bʋ nue ‑wɛ ‑mʋ ‑wɔn nɩ. ");
INSERT INTO ted_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","'Bɩa ꞊nɩɩ nahuin lɛ'mimre a dididɛ ke da, ‑ye ‑bo da ꞊sʋɛnyʋ, kɔ nɩanɩnyʋ, kɔ bʋɩlɛ‑yɩyrɛnyʋ, kɔ 'yiisuanyʋ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","'Bɩa ꞊nɩ nye nu, ‑ye ‑n di kɔ plɔ a bleelɛ, ‑ɛ nue, dɛ ꞊nʋ, ‑nɩɩ ꞊nʋ ‑wɔn nu, ʋ 'die 'le ‑wɛ bʋ nue ‑wɛ ‑mʋ ‑wɔn. Kɛɛ, Nyɩsʋa, nɔ‑ di ‑mʋ 'a 'wio ‑nyi, ‑nyrɔwɔ ‑kɔ 'mʋ ɔ di 'le nahuin ꞊nʋ, ‑ʋ 'sii 'o ye, 'kʋkʋnyʋ ‑hɛyri ‑ha, ɔ 'mu 'klɔ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","‑Tɛ ‑Yusu ꞊tu ‑tɩ a ‑gbɛ, ‑ye nahuon ꞊de, 'ke 'le nahuin ꞊nʋ ‑hɛyri, ‑ʋ nɩ 'o dɛdihuo ke, ɔ le ‑Yusu nɩ, ɔ nɔ: «Plɔ a bleelɛ 'ke 'o nahuin ꞊nʋ ‑wɔn, Nyɩsʋa di ‑tado 'a ‑dina ke da, 'ke 'le 'a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ, ɔ di nu.» ");
INSERT INTO ted_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","‑Ye ‑Yusuu nahuon a ‑gbɛ ye po ‑talʋdʋ, ɔ nɔ: «Ɛ kɔ la nahuon ꞊de. Nɔ‑ le nahuin 'plɔplɔ, ‑ɛ mɔ, ɔ diu ke da ‑dina. ");
INSERT INTO ted_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","‑Tɛ dɛditi nyre 'o, 'ɔ le 'a ‑kʋannunyɔ, 'ke bɔ le nahuin ꞊nʋ, ɔ da wɛn, ‑ɛ mɔ, dididɛ ‑wɛ ‑wɔn, bʋ di 'le. ");
INSERT INTO ted_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kɛɛ, nahuin 'bii a ‑gbɛ, ʋ 'bɔtɩɔ lɛ, ʋ nɔ: Ɛ 'de 'hru kɔ, ‑a 'deɛ ‑ba di 'le. Ye‑hɛnahuon, ɔ le ‑kʋannunyɔ a ‑gbɛ nɩ, ɔ nɔ: 'N ‑tɔ 'na ‑ci. 'N kɔ ꞊bo mue 'ye. 'A ‑tɩ, ‑n kɔ 'o ꞊wɔn, 'n 'deɛ ꞊bo di 'le. ");
INSERT INTO ted_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‑Ye nahuon a 'hɔn a nɔnɔ, ɔ nɔ: 'N ‑tɔ 'na broo ‑pu. 'N kɔ ꞊bo muo 'ye. 'A ‑tɩ, ‑n kɔ 'o ꞊wɔn, 'n 'deɛ ꞊bo di 'le. ");
INSERT INTO ted_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","‑Ye nahuon a ta nɔnɔ, ɔ nɔ: 'Mɔ pa lɛ kɛ 'blɩ 'mʋ. Nɛ‑ nue, 'nɩnɩ di 'le di. ");
INSERT INTO ted_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","‑Ye ‑kʋannunyɔ a ‑gbɛ, ɔ mu nɩ, 'ɔ le 'a 'masɛ ‑tɩ 'bii ꞊nʋ, nahuin ꞊nʋ, ʋ ꞊tu ꞊nɔ ‑wɔn. 'Plɩɩ 'masɛ 'mʋ ‑tɩ a ‑gbɛ mu 'wɔn, ‑ye ɔ bi 'mʋ yrʋ, 'ɔ le 'a ‑kʋannunyɔ, ɔ nɔ: 'Kɩka, ‑bo mu 'o 'dika, kɔ ‑bo ꞊glaa 'le 'dɩɔ, ‑bo ‑wɔ ꞊sʋɛnyʋ ti ke, kɔ nɩanɩnyʋ, kɔ 'yiisuanyʋ, kɔ bʋɩlɛ‑yɩyrɛnyʋ, bʋ di 'le, ");
INSERT INTO ted_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","‑kʋannunyɔ a ‑gbɛ 'ɔ mu, 'ɔ dʋ lɛ, 'ɔ ꞊hɩan ‑wɔn, 'ɔ le 'a 'masɛ, ɔ nɔ: ‑Tɩ 'bii ꞊nʋ, ‑n le 'mʋ, 'n nui nɩ. Kɛɛ, kegbonɩ‑tɔplɩ 'kɩɛ hihie gblɛ. ");
INSERT INTO ted_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","‑Ye kayukɔnyɔ ꞊tuo ‑wɔn, ɔ nɔ: ꞊Tɩ 'dɩɔ 'mʋ, ‑bo pa 'hri wlɔn lɛ, 'ɛ nɩ nahuon, ‑n di 'o gbo yɛ, nɩ 'o ꞊nɔ ke 'mʋ, bɔ di 'le!» ");
INSERT INTO ted_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","'Plɩɩ ‑Yusu 'mʋ mu ‑yrɛ, ‑ye ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le, 'ke 'le ye‑hɛnahuin 'bii ꞊nʋ ‑hɛyri, 'n da, 'waa nahuon ꞊de 'deɛ bɔ di ‑tado 'na ‑dina a ‑gbɛ ke, 'ke 'le 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ, Nyɩsʋa di nu.» ");
INSERT INTO ted_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","‑Nyrɔwɔ ‑ye 'mʋ, nahuin ‑huohui, ʋ kɔ ‑Yusu 'hɛɛn, nʋ‑ʋ 'hru na. ‑Ye ‑Yusu ꞊hɩan ‑wɔn, 'ɔ nyu le, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Nahuon 'bɔ nɩ 'o, 'bɩa 'bɔ di nɔ 'mʋ 'hʋɩn 'mʋ, ‑ɛ die nu, ɔ 'mʋ 'na ‑naagbopʋyu 'mʋ 'ya, ɔ kɔ bɔ nʋɛ 'mʋ 'mʋ, bɛ ‑hi 'o 'a bu kɔ 'a 'dii 'hɛɛn 'mʋ, kɔ 'a nyrɔ, kɔ 'a 'yuo, kɔ 'a ‑dɩayuo, kɔ 'a dɩɔnʋ 'hɛɛn. 'Bɩa 'bɛ 'de ꞊nɛ, ‑ye ɔ 'deɛ bɔ 'ya 'na ‑naagbopʋyu 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Nahuon 'bɔ nɩ 'o, 'bɔ 'nɩnɩ ꞊tuu 'o 'na wintɛ 'o, ꞊betɩ bʋ plɛ, ʋ 'muo 'la 'na ‑tɩ, ɔ 'die 'le ‑wɛ bɔ 'ya 'na ‑naagbopʋyu 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","꞊Bo pue kayuponyɔ a dɛ ye. ꞊Nɩ 'mʋ kayu gblaka po, 'plɩɩ ꞊mʋ ‑kʋan ‑wlu ꞊tu, ‑nɩɩ gbo 'nɩ nɩ, ꞊nɩɩ 'lu lɛ ‑hie ‑tɩtɛ, ꞊nɩɩ 'wliyɛ ꞊nʋ ‑wɔn lɛ gbʋgba, ‑n di 'mʋ 'ba, ꞊mʋ kayu a ‑gbɛ po, ‑ɛ die nu, ꞊mue yi, 'bɩa 'dai 'wliyɛ, 'bɛ nɩ 'le ‑mʋ kwa 'mʋ, ‑n di 'mʋ 'ba, ꞊mʋ kayu a ‑gbɛ ‑wɔn ‑wɔ. ");
INSERT INTO ted_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","'Bɩa ꞊nɩ 'die nu, ꞊nɩ ꞊tu ‑kʋan a ‑gbɛ ‑wlu, 'plɩɩ, ꞊nɩ 'die 'le ‑wɛ ‑bo ‑wɔ kayu a ‑gbɛ ‑wɔn, ‑ye nahuin 'bii, ‑ʋ di dɛ a ‑gbɛ 'ye, ʋ di ‑mʋ 'nɩ 'caa, ");
INSERT INTO ted_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ʋ 'mʋ lɛ po: Nahuon ‑gbo, ɔ ꞊tu 'a kayu a pupue ‑wlu, kɛɛ, ɔ 'die 'le ‑wɛ bɔ ‑yra ‑kʋan a ‑gbɛ 'lu. ");
INSERT INTO ted_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","꞊Bo pue lele bodɩɔ a dɛ ye. Bodɩɔ ꞊de 'bɔ 'mʋ tʋ ke mu, 'bɔ 'mʋ 'a 'be bodɩɔ ‑ye ‑wɔn mu ‑wɔn, ‑ye ɔɔ gbo 'nɩ nɩ ‑tɩtɛ, 'ɔɔ 'lu lɛ ‑hie, 'bɩa 'bɔ gba 'a 'sɔyuo a (10'000) 'milowɩɩ ‑pu, 'bɔ ‑wɛ 'le bɔ nyra 'a 'be bodɩɔ ye gbo, ‑ɔ gba 'a 'sɔyuo a (20'000) 'milowɩ a ‑wlʋ. ");
INSERT INTO ted_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","'Bɔ 'die 'le ‑wɛ, 'a 'be bodɩɔ 'bɔ 'kɩɛ hreen 'le ‑wɔn, tʋ 'bʋ 'de wɛn a 'bɩɛ, ‑ye ɔ tɛ gbo 'a lɛleenyʋ, 'ke bʋ ꞊gba 'a 'be bodɩɔ a ‑gbɛ wlɔn: Dɛ tio‑ ‑a di nu, tʋ 'nɩ ꞊han gbo bi 'le?» ");
INSERT INTO ted_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","'Plɩɩ ‑Yusu 'mʋ mu ‑yrɛ, ‑ye ɔ nɔ: «'A ‑tɩ o, 'ke 'le 'a mʋ ‑hɛyri, nahuon ꞊de 'die 'le ‑wɛ bɔ 'ya 'na ‑naagbopʋyu 'mʋ, 'bɩa 'bɔ 'de ‑wɔn ‑wɛ, 'ke bɔ hie 'o 'a kʋkɔ‑tɔplɩ 'bii gbo. ");
INSERT INTO ted_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","A yie nɩ, ‑ɛ mɔ, 'ta mɔ ꞊hapʋdɛɛ nɩ. Kɛɛ, 'bɔ 'waan 'a wlɔnnɩnɔ, ʋ 'die 'klɛɛ 'le lele ‑wɛ bʋ nue, bɔ nɔ lele wlɔn. ");
INSERT INTO ted_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɔ 'de 'klɛɛ lele ‑kʋan ꞊de kɔ. ‑Ye ʋ nyo 'mʋ po 'kwla. 'Ba kɔ ‑tɩ'wɔnnʋa, ‑ye ba po 'mʋ nʋa ye gbo ‑dodo.» ");
INSERT INTO ted_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","‑Nyrɔwɔ ꞊de 'mʋ, 'blʋwli'tɛnyʋ, kɔ pʋpʋnahuin, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, nʋ‑ mu 'o ‑Yusu 'hʋɩn 'mʋ, ‑ɛ die nu, 'bɔɔ 'prɛ, ʋ 'muo nʋa ye gbo po, ʋ 'mʋ 'a tɔɔwin 'wɔn. ");
INSERT INTO ted_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Falisi꞊tumu a nahuin kɔ teteitɔɔnyʋ 'hɛɛn, ‑ʋ nɩ 'o, ‑tɛ ʋ 'ye dɛ a ‑gbɛ, ‑ye ʋ bi 'mʋ yrʋ, 'ʋʋ wlɔn lɛ 'pʋprɛ, ʋ nɔ: «Nahuon ‑gbo, nahuin, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, nʋ‑ ɔɔ 'o 'hʋɩn 'mʋ ‑wlɛn, ɔ kɔ ꞊nʋ 'hɛɛn 'ʋʋ ‑wɛ dɛ di.» ");
INSERT INTO ted_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","‑Tɛ ‑Yusu 'wɩn, ‑ye ɔ pue ye dɛ, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«'Ke 'le 'a mʋ ‑hɛyri, nahuon 'bɔ nɩ 'o, 'bɔ kɔ blablɔ a (100) ‑wlɩɩ ꞊hun, 'bɔ gbɔ 'le 'cɛɛlɛ 'mʋ, 'plɩɩ blablɔ a ‑gbɛ, 'a 'yɛɛ ‑do 'bɛ 'wan, dɛ tio‑ ɔ di nu 'le? Ɔ kɔ bɔ hie 'o blablɔ a (99) ‑wlɩɩ ‑hɛn ꞊tu 'o ‑pu ꞊tu 'o seledo ꞊nʋ gbo, 'ke 'le 'cɛɛlɛ 'mʋ, bɔ mu blablɛ ꞊nʋ lɛ ꞊mɔ, ‑ɛ 'wan, ɔ 'mue 'yie 'mʋ lɛ ꞊mʋɛ, ɔ 'mue ke yɛ. ");
INSERT INTO ted_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","'Bɔ yɛ ke, 'a plɔ di 'nɩ ble, ɔ 'mue ‑plɩ 'mʋ gbo pue, ");
INSERT INTO ted_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ɔ 'mʋ 'le kayu gbo mu, ɔ 'mʋ 'a 'bienʋ da, ʋ kɔ nahuin ꞊nʋ 'hɛɛn, ‑ʋ ꞊glaa 'le ꞊nɔ, ɔ 'mʋ lɛ po: Ba bi 'mʋ ke, ‑ba nu 'manʋ, 'na blablɛ, ‑ɛ 'wan, 'n 'ye nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le, kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'ke 'le yakɔ 'mʋ. Ʋ 'deɛ bʋ nu 'manʋ, 'ke 'le yakɔ 'mʋ, nahuin a (99) ‑wlɩɩ ‑hɛn ꞊tu 'o ‑pu ꞊tu 'o seledo ꞊nʋ a ‑tɩ, ‑ʋ plɛ, ‑ʋ 'sii 'o ye, ‑ʋ 'deɛ ‑bʋ ‑nye 'waa 'klɔ Nyɩsʋa. Kɛɛ, dɛ'kukununyɔɔ ‑do 'bɔ hie 'o 'a dɛ 'kuku gbo, 'bɔ ‑ha 'le 'a dɩɔnʋ a 'klɔ, 'bɔ ‑nyo Nyɩsʋa, ɛ nɛ‑ kɔ ‑tɩ, ʋ 'mʋ 'manʋ nu, 'ke 'le yakɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Kɛ ‑Yusuu lele po, ɔ nɔ: «꞊Bo pue lele 'wliyɛ a dɛ ye: 'Bɩa nyrʋgba 'bɔ kɔ 'wliyɔɔ ‑pu, 'plɩɩ 'bɔ 'waan 'a 'yɛɛ ‑do, ɔ kɔ bɔ 'bɩa 'napɩ, bɔ ‑ha kayu ꞊nʋ kʋɛtɩ gblɛ, 'plɩɩ ɔ 'mʋ 'wliyɛ ꞊nʋ 'yie 'mʋ lɛ ꞊mʋɛ. ");
INSERT INTO ted_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","'Bɔ 'ye, ɔ 'mʋ 'a 'bienʋ da, ʋ kɔ nahuin ꞊nʋ 'hɛɛn, ‑ʋ ꞊glaa 'le ꞊nɔ, ɔ 'mʋ lɛ po: Ba bi 'mʋ ke, ‑ba nu 'manʋ, ‑ɛ nue 'na 'wliyɛ, ‑ɛ 'wan, 'n 'ye nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le, kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'ke 'le Nyɩsʋa a lɛleenyʋ ‑hɛyri, ‑ʋ nɩ 'le yakɔ 'mʋ. Dɛ'kukununyɔɔ ‑do 'bɔ hie 'o 'a dɛ 'kuku gbo, 'bɔ ‑ha 'le 'a dɩɔnʋ a 'klɔ, 'bɔ ‑nyo Nyɩsʋa, nɛ‑ kɔ ‑tɩ Nyɩsʋa a lɛleenyʋ 'mʋ 'manʋ nu, 'ke 'le yakɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","‑Ye ‑Yusu po lele ‑talʋdʋ, ɔ nɔ: «Nyɩbɛyu ꞊de, nɔ‑ kɔ la 'yuo nyɩbɛpʋʋ 'hɔn. ");
INSERT INTO ted_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","‑Nyrɔwɔ ꞊de 'mʋ, ‑ye 'yu 'cicrɛ le 'a bu nɩ, ɔ nɔ: 'N bu o, ‑na 'wliyɛ ‑gbo, ‑ɛ blɛ 'mʋ ye, ꞊nɩ 'kʋ, 'n di wɛn gba, ‑nyi 'mʋ ‑dodo. Bɔ ꞊tui, ‑ye 'waa bu woo ꞊nʋ 'a 'wliyɛ 'mʋ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","‑Nyrɔwɩ gbi bɩ ‑hi, ‑ye 'yu 'cicrɛ a ‑gbɛ, 'wliyɛ 'bii ꞊nʋ, 'a bu ‑nyi ꞊nɔ, ɔ 'bʋɛ 'mʋ nɩ, 'ɔ mu 'le 'blʋgba ‑ye 'mʋ, ‑ɔ hren 'a 'bri ‑wɔn 'dɔ. ‑Tɛ ɔ nyre 'le 'blʋgba a ‑gbɛ 'mʋ, ‑ye ɔ ‑tʋa 'a 'wliyɛ a 'mʋlɛcɩcralɛ gbo. 'Klɔ a ‑gbɛ, nɔ‑ nue, 'a 'wliyɛ 'bii 'ɛ ‑wɛ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","‑Tɛ ɔ ‑wɔ 'klɛɛ 'wliyɛ a 'mʋlɛcɩcralɛ ‑wɔn, ‑ye kanʋ gbɛtɛɛ bi 'le 'blʋgba a ‑gbɛ 'mʋ, 'yu a ‑gbɛ 'ɔ ‑tʋa ꞊sʋɛ a 'yiye gbo, kanʋ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nɛ‑ nue, 'ɔ mu ‑kʋan lɛ ꞊mɔ wɔn, 'ke 'le nyɩbɛyu ꞊de ‑wɔn, ‑ɔ kɔ 'le 'blʋgba a ‑gbɛ 'mʋ. Nyɩbɛyu a ‑gbɛ, nɔ‑ kɔ bʋɩcɩ, 'ke 'le 'a ‑gligba ke, 'ɩ nɩ 'le ‑gblo 'kwli 'mʋ; 'ɔ le ꞊nɔ, bɔ ꞊tui 'yie. ");
INSERT INTO ted_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","‑Tɛ ɔ nyi 'klɛɛ 'yie ꞊tu, ‑ye ɔ nye 'nɩ ‑hʋa 'dɔ, bʋɩcɩ a didi‑tɔplɩ ꞊nʋ, ʋʋ 'le ya, kanʋ a ‑tɩ, bɔ di ‑wɛ 'a dɛ, kɛɛ, nahuon ꞊de 'nɩ ‑nyi ꞊le ꞊nɔ 'a dɛ ꞊de. ");
INSERT INTO ted_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","‑Ye ꞊wlʋ di ꞊nɔ ‑wɔn, ɔ nɔ: 'Na bu a ‑kʋannunyʋ 'bii, ʋʋ di dɛ, 'ʋʋ ꞊mra, didi‑tɔplɩ 'ɩɩ gblɛ hihie. 'Mɛ ‑ye, kɛ 'n nɩ nɔ kanʋ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","'N di 'mʋ 'ba ye, 'mʋ ‑wɔn ꞊hɩan, 'mʋ 'le 'n bu ‑wɔn mu, 'muo le, ‑ɛ mɔ: 'N bu o, 'n ‑haa Nyɩsʋa a ‑tɩ lɛ, 'nɩ ‑haa ‑wɛ ‑na ‑tɩ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","'A ‑tɩ, 'n 'de ye blɛ ‑bo daa 'klɛɛ lele 'mʋ ‑na 'yu. Daa 'mʋ ‑na ‑kʋannunyɔ, ");
INSERT INTO ted_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","'ɔ 'ba ye 'mʋ, 'ɔ bi 'hru wlɔn, 'ɔ mu 'le 'a bu ‑wɔn. Ɔ nɩ 'le ye 'mʋ, 'a bu 'ɔ yroo, 'ɔ 'ye 'a 'yu a ‑gbɛ a wɔlɩ 'dɔ, 'ɔ gba cigbɛi, 'ɔ muo ye 'mʋ 'bɛ wɔn. ‑Tɛ ɔ nyro 'o 'hʋɩn 'mʋ, ‑ye ɔ 'wlɔɔ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","'A 'yu nɔ: 'N bu o, 'n ‑haa Nyɩsʋa a ‑tɩ lɛ, 'nɩ ‑haa ‑wɛ ‑na ‑tɩ lɛ. 'A ‑tɩ, 'n 'de ye blɛ ‑bo daa 'klɛɛ lele 'mʋ ‑na 'yu. ");
INSERT INTO ted_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kɛɛ, 'a bu le 'a ‑kʋannunyʋ nɩ, ɔ nɔ: Ba po 'le 'klɩ lɛ, ba ya 'le wlawlʋ ꞊nʋ, ‑ʋ nɔ 'yi lɛ, 'ke 'le wlawlɩ 'bii ‑hɛyri, ‑ɩ nɩ nɔ kayu gbo. Ba pu ꞊nɔ. Ba po ‑wɛ 'le ꞊nɔ ‑jie 'mʋ 'bɔyɛ, (ɔ 'mue yi, ‑ɛ mɔ, 'n nyo daa 'na 'yu.) Ba puo ‑wɛ 'suei. ");
INSERT INTO ted_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ba ya 'le briyu ‑tutu ꞊nʋ, ‑a po 'pɩa ke, a 'mu 'la, ‑ɛ die nu, ‑a 'mʋ dɛ di, ‑a 'mʋ lɛ 'mre ‑tɛɛ, ");
INSERT INTO ted_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","‑ɛ nue, 'na 'yu ‑gbo, ɛ 'we ꞊nɔ ye, ɔ 'kʋ o nɩ, 'ɔ 'hrɩ lele 'klɔ. Ɔ 'wan o nɩ, 'nɩ 'yo kɛ. ‑Ye ʋ ‑tʋa lɛ'mimre gbo. ");
INSERT INTO ted_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ti a ‑gbɛ 'yri, 'ke 'a 'yu kuku nɩ 'le 'daklɔ. ‑Tɛ ɔɔ 'klɛɛ 'daklɔ 'mʋ ‑hɔn, ɔɔ kayu yrɛ 'mʋɛɛ, ‑ye ɔ 'wɔn bibi‑tɔplɩ kɔ ‑wla a win, ");
INSERT INTO ted_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","'ɔ da ‑kʋannunyɔ ‑ye, 'ɔ ꞊gbɔ wlɔn: Dɛ tio‑o 'lu ‑wɔn mue, ‑ɛ kɔ ‑wla nahuiin yi 'le? ");
INSERT INTO ted_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‑Ye ɔ ꞊tuo ‑wɔn, ɔ nɔ: ‑N ‑dɩayu, ‑ɔ mu la, ɔ di 'le ꞊le. Ɛ mɔ ‑n bu a 'manʋ'ʋ nɩ, 'a 'yu, ‑ɔ 'wan la, bɔ dio 'ye, 'a 'hʋɩn bɩ di ‑tɛɛ nu. Nɛ‑ nue, 'ɔ 'la briyu ‑tutu ꞊nʋ, ɔ po 'pɩa ke. ");
INSERT INTO ted_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","‑Tɛ 'yu kuku a ‑gbɛ, ɔ 'wɩn, ‑ye ɔ bi 'mʋ yrʋ. Yrʋ a ‑tɩ, ɔ 'nɩ ‑hʋa ꞊le bɔ pa kayu gbo. Nɛ‑ mɔ 'a bu bɔ 'hrɩ 'le kayu gbo, 'ɔ 'bɔtɩɔ lɛ, ɔ nɔ: Pa kayu gbo. ");
INSERT INTO ted_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kɛɛ ‑ye ɔ nɔ: 'Ye kɛ, kɛ 'n nɩ mɔ ‑mʋ 'hʋɩn 'mʋ 'ɛ nɩ ti, 'nɩɩ ‑mʋ 'mʋ ‑hɛ. 'N 'de ‑hlɩn ‑na ‑tɩ lɛ a ‑hɛɛ, 'a 'yrɩ ꞊gbʋgbɛ 'mʋ nɩ. Kɛɛ, ‑n 'de ‑hlɩn 'mʋ wliyu a ‑nyee, 'ke 'mu 'la, 'n kɔ 'n 'bienʋ 'hɛɛn, ‑a 'mʋ lɛ 'mre. ");
INSERT INTO ted_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Kɛɛ, ‑na 'yu ꞊nʋ, ‑ɔ gba ‑na 'wliyɛ, ‑ɔ ‑nyi 'lalunyrʋ lɛ, ‑tɛ ɔ ꞊hɩan 'klɛɛ ‑wɔn, ‑ye nɔ‑ kɔ ‑tɩ, ꞊nɩ 'la briyu ‑tutu, ‑a po 'pɩa ke. ");
INSERT INTO ted_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‑Ye 'a bu nɔ: 'Na 'yu o, kɛ ‑n nɩ mɔ 'mʋ 'hʋɩn 'mʋ 'ɛ nɩ ti. 'Ɛ nɩ dɛ 'n kɔ, ‑mɔ kʋɛ. ");
INSERT INTO ted_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kɛɛ, ɛ blɛ ye ‑ba 'mre lɛ, ‑ɛ nue, ‑n ‑dɩayu ‑gbo, ɛ 'we ꞊nɔ ye, ɔ 'kʋ o nɩ, 'ɔ 'hrɩ lele 'klɔ. Ɔ 'wan o nɩ, 'nɩ 'yo kɛ.» ");
INSERT INTO ted_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","‑Nyrɔwɔ ‑ye 'mʋ, ‑Yusu po ‑talʋdʋ, 'ke 'o 'a ‑naagbopʋ ‑wɔn, ɔ nɔ: «Ɛ kɔ la dɛkɔnyɔ ꞊de. Nɔ‑ kɔ la 'wli'yie꞊tunyɔ. ‑Nyrɔwɔ ꞊de 'mʋ, ‑ye nahuin di 'le ꞊le, 'ʋ le dɛkɔnyɔ a ‑gbɛ, ʋ nɔ: 'Ye kɛ, ‑na 'wli'yie꞊tunyɔ ‑gbo, ɔɔ ‑na kʋkɔ‑tɔplɩ 'mʋ lɛ 'nɩ cɩcra. ");
INSERT INTO ted_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","‑Ye dɛkɔnyɔ a ‑gbɛ, ɔ dɔ nɩ, ɔ nɔ: 'Nɩɩ 'wɔn ‑na 'yilɛnyredʋ. 'A ‑tɩ, le 'mʋ, ‑tɛ ‑nɩɩ 'na kʋkɔ‑tɔplɩ a ꞊tɔ nu. 'N pui ‑tɛɛ, ‑n 'die 'le ‑wɛ ‑bo 'ya 'klɛɛ lele 'na 'wli'yie꞊tunyɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","‑Ye kɛ 'wli'yie꞊tunyɔ a ‑gbɛ, ɔɔ 'a dɩɔnʋ ye po, ɔ nɔ: 'Na 'masɛ di 'mʋ ke ‑ha ‑kʋan. ‑Be' 'n di nu 'le? 'N 'de 'klɩ kɔ, 'ke ꞊bo ‑mɛ ‑tʋtʋ ye, kɔ, ɛ di 'mʋ nue ‑tʋɩ, ꞊bo di lɛ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","‑Ɩn'hɩɩn, dɛ 'n di nu, 'n yie nɩ. 'Nɩ nu dɛ a ‑gbɛ, 'bɔ ‑ha 'mʋ ‑kʋan ke, ‑ye nahuin di 'mʋ kwa 'nɩ 'ble, 'ke 'le 'waa kayuo gbo. ");
INSERT INTO ted_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Bɔ po 'klɛɛ lɛ, nahuin, ‑ʋ kɔ gba a 'pɛɛlɛ, 'ke 'o 'a 'masɛ ‑wɔn, ‑ye ɔ da 'waa ‑dodo. ‑Tɛ 'a ye‑hɛnahuon nyre 'o, ‑ye ɔ ꞊gbɔ wlɔn, ɔ nɔ: 'Na 'masɛ a gba ꞊nʋ, ‑n 'ble kwa, ‑tie 'le? ");
INSERT INTO ted_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‑Ye ɔ nɔ: 'Nyratɛɛi a (100) ‑wlɩɩ ꞊hun a 'wliyɛ a gba, nɔ‑ nɩ nɔ 'mʋ ‑wɔn. ‑Ye 'wli'yie꞊tunyɔ nɔ: 'Ye kɛ, ‑na 'crɩɩnɩɛ, ‑ɛ kɔ ke ʋ 'crɩɩ 'o ‑na gba, ɛ nɛ‑ ‑gbo. 'Kɩka, ‑bo nɩ gbo, ‑bo 'crɩɩ 'nyratɛɛi a (50) ‑wlɩɩ 'hɔn ꞊tu 'o ‑pu a 'wliyɛ a gba, nɔ‑ nɩ nɔ 'mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","‑Ye kɛ ɔɔ ꞊ɔ ‑ye ye po, ɔ nɔ: ‑Mɛ ‑ye, ‑tie ‑n 'ble kwa 'le? ‑Ye ɔ nɔ: ꞊Gblablɛ a (500) ‑hɔtrʋwɩɩ ꞊hun a 'wliyɛ a gba, nɔ‑ nɩ nɔ 'mʋ ‑wɔn. ‑Ye 'wli'yie꞊tunyɔ nɔ: 'Ye kɛ, ‑na 'crɩɩnɩɛ, ‑ɛ kɔ ke ʋ 'crɩɩ 'o ‑na gba, ɛ nɛ‑ ‑gbo. 'Kɩka, ‑bo nɩ gbo, ‑bo 'crɩɩ ꞊gblablɛ a (400) ‑hɔtrʋwɩɩ ‑hɛn a 'wliyɛ a gba. ");
INSERT INTO ted_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","'Wli'yie꞊tunyɔ ꞊nʋ, ‑ɔ 'de 'o ye 'sii, ‑tɛ 'a 'masɛ 'ye dɛ ꞊nʋ, ɔ nu, ‑ye ɔ nyo lɛ po 'nyrɛɛ, ‑ɛ nue, ɔ ‑hie lɛ 'lu ‑tɛɛ, 'ke 'o dɛ ꞊nʋ, ɔ di ‑ŋa ‑hɛ a ‑ta 'mʋ. 'Ɛ mɔ ‑tɛɛ, nahuin ꞊nʋ, ‑ʋ 'nɩnɩ ꞊tuu 'o Nyɩsʋa, ‑ʋʋ 'klɔ ‑gbo a ‑hʋhʋa‑tɔplɩ lɛ ꞊mɔ, ʋ kɔ ꞊tɔ, 'ke 'o gblagblʋ a nunue a ‑ta 'mʋ. 'Waa ꞊tɔ a ‑gbɛ, ɔ ‑hi 'o Nyɩsʋa a nahuin a ꞊tɔ 'mʋ nɩ, ʋ kɔ, 'ke 'o 'oye'siidɛ a nunue a ‑ta 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Kɛ ‑Yusuu lele po, ɔ nɔ: «꞊Tɔ 'nɩɩ 'a mʋ 'mʋ po, nɔ‑ mɔ: 'Nɩɩ 'a mʋ 'nɩ le, 'klɔ ‑gbo a kʋkɔ‑tɔplɩ ꞊nʋ, ‑ɩɩ nahuin kaa, ba 'bʋɩ 'mʋ, ba ‑nyi nahuin lɛ, nahuin a ‑gbɛ, ʋ 'mʋ 'a nɩ nɩnatumupʋ ‑hɛ, ‑ɛ die nu, kʋkɔ‑tɔplɩdʋ a ‑gbɛ, ti ꞊nʋ ‑kɔ 'yri ɩ di 'a mʋ kwa lɛ ‑wɛ, ʋ 'mʋ 'a mʋ kwa 'ble, 'ke 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nahuon ‑gbo, ‑ɔ 'sii 'o ye, 'ke 'o ‑tɔplɩ 'cicrɛi a yegblɛ꞊tutulɛ a ‑ta 'mʋ, ɔ di ‑wɛ 'o ye 'nɩ 'sii, 'ke 'o ‑tɔplɩ gblakɩ a yegblɛ꞊tutulɛ a ‑ta 'mʋ. Kɛɛ, nahuon ‑gbo, ‑ɔ 'de 'o ye 'sii, 'ke 'o ‑tɔplɩ 'cicrɛi a yegblɛ꞊tutulɛ a ‑ta 'mʋ, ɔ 'deɛ bɔ 'sii ‑wɛ 'o ye, 'ke 'o ‑tɔplɩ gblakɩ a yegblɛ꞊tutulɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","'A ‑tɩ o, 'ba 'de 'o ye 'sii, 'ke 'o 'klɔ ‑gbo a kʋkɔ‑tɔplɩ a yegblɛ꞊tutulɛ a ‑ta 'mʋ, ‑ɩɩ nahuin kaa, Nyɩsʋa 'deɛ bɔ kuo 'a mʋ ꞊wlʋ ye, 'ke bɔ ‑nyi 'a mʋ ‑tɛɛ a kʋkɔ‑tɔplɩ. ");
INSERT INTO ted_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","'Ya 'o lele 'lu, 'bɩa 'ba 'de 'o ye 'sii, 'ke ba ꞊tutu nahuin ‑ye a kʋkɔ‑tɔplɩ ye gblɛ ‑tɛɛ, Nyɩsʋa 'deɛ bɔ ‑nyi 'a mʋ kʋkɔ‑tɔplɩ, ‑ɩ blɛ 'a mʋ ye. ");
INSERT INTO ted_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‑Kʋannunyɔ ꞊de 'die 'le ‑wɛ, tii ‑do 'yri, bɔ nu 'masɛpʋʋ 'hɔn a ‑kʋan. Ɔ di yraa ꞊ɔ ‑ye, ɔ 'mʋ ꞊ɔ ‑ye 'mʋ nʋɛ. Ɛ 'die 'le ‑wɛ, tii ‑do 'yri, Nyɩsʋa bɔ kɔɔ 'a mʋ win ke, 'plɩɩ 'wliyɛ bɛ kɔɔ ‑wɛ 'a mʋ win ke.» ");
INSERT INTO ted_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","‑Ye Falisi꞊tumu a nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'wɔn ‑Yusu a pupowin 'bii ꞊nʋ nɩ, 'ʋ ‑tʋa 'a 'caalɛ gbo, ‑ɛ nue, ʋ nʋɛ 'mʋ 'wliyɛ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «Aa nu ‑tɔplɩ, ‑ɛ die nu, nahuin 'mʋ lɛ po: A 'sii 'o ye. Kɛɛ, Nyɩsʋa yi 'a nɩ ꞊wlɩ nɩ. 'Ɛ mɔ ‑tɛɛ, ‑tɔplɩ ꞊nʋ, nahuin, ʋʋ ‑tɔplɩ gblakɩ daa, Nyɩsʋa yrɩɩ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‑Tɔplɩ ꞊nʋ, ʋ 'crɩɩ la, 'ke 'le Moise a teteicrɩɩnɩɛi kɔ Nyɩsʋa a winwlɔn‑hɛnyʋ a 'crɩɩnɩɛi 'hɛɛn 'kwli 'mʋ, nɩ‑ ʋ tɔɔ ‑tɔɔtɔɔ, Saan Batisɩ 'ɔ di 'le. Kʋɛ 'le ti a ‑gbɛ 'yie 'mʋ gbo, 'nɩɩ Nyɩsʋa a ꞊hapʋtitie 'nɩ po, ‑ɛ nyi ꞊tu, ‑ɛ mɔ, Nyɩsʋa kɔɔ nahuin ke win, 'ɛ nɩ nahuon 'ɔɔ 'o 'klɩ ꞊tu, ‑ɛ die nu, Nyɩsʋa 'muo win ke kɔɔ. ");
INSERT INTO ted_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Yakɔ kɔ ‑tʋtʋ 'hɛɛn, ɩ ‑wɛ 'le bɩ ‑wɛ gbo nɩ, kɛɛ, ɛ 'die 'le ‑wɛ, Nyɩsʋa a tetebʋ ꞊de a ꞊tɩɔ gbi bɔ ‑wɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","'Ɛ nɩ nyɩbɛyu 'bɔ nɩ 'o, 'bɔ po 'le 'a nyrɔ ‑patʋ 'mʋ, 'bɔ kɔ nyrɔ ‑ye, ‑ye nyɩbɛyu a ‑gbɛ, ɔ nu ‑wlawli. Kɔ, nyrʋgba ꞊nʋ, ɔ po 'le ‑patʋ 'mʋ, nyɩbɛyu ‑ye 'bɔ kʋɔ, ‑ye nyɩbɛyu a ‑gbɛ, ɔ nu ‑wɛ ‑wlawli.» ");
INSERT INTO ted_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Kɛ ‑Yusuu lele po: «Ɛ kɔ la dɛkɔnyɔ ꞊de. 'A 'hʋɩn'mʋlɛpue‑tɔplɩ, ɔɔ la pue, ɩ nɔ la lɛ 'yi 'dɔ, 'plɩɩ 'ɩɩ la ꞊die po. 'Ɛ nɩ ‑nyrɔwɔ, ɔɔ la lɛ 'nɩ 'mre, 'ɔɔ la ꞊hapʋdidi‑tɔplɩ a gblegblei pi, ɔ kɔ 'a 'bienʋ 'hɛɛn, 'ʋ nyi la di. ");
INSERT INTO ted_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ɛ kɔ la ‑wɛ nahuon ‑ye. 'A 'dʋ mɔ Lasa. ꞊Sʋɛ nyo la nu, 'a 'hʋɩn 'bii 'ɩ mɔ la ꞊ji ‑gbʋgbɛ. ‑Nyrɔwɔ ꞊de 'mʋ, nɔ‑ pɛ 'o dɛkɔnyɔ a ‑gbɛ a 'maju 'yri gbo. ");
INSERT INTO ted_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ɔ nye 'nɩ ‑hʋa, kɛɛ, ɔ 'die 'le ‑wɛ, didi‑tɔplɩ ꞊nʋ, ‑ɩɩ dɛkɔnyɔ kɔ 'a nɩnatumupʋ 'hɛɛn kwa lɛ ble, 'ke bɔ 'tɩ lɛ, bɔ di. 'Ke ɔɔ 'o gbo pɛ, ‑gbo 'ɔɔ 'le 'a ꞊ji 'yi 'mʋ lɛ bɛ. ");
INSERT INTO ted_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","'Ke ʋ nɩ 'o ‑nɩnɩ, ‑ye ꞊sʋɛnyɔ a ‑gbɛ, ɔ 'kʋ nɩ, Nyɩsʋa a lɛleenyʋ 'ʋ gbɔ 'le ‑a nɩ bu Abrahamʋ 'hʋɩn 'mʋ, ('ke 'o Nyɩsʋa ye). ‑Ye dɛkɔnyɔ ‑mɛ ‑ye, ɔ 'kʋ ‑wɛ nɩ, 'ʋ ‑hɩɔ 'o. ");
INSERT INTO ted_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","‑Tɛ ɔ mu 'yii ꞊wlɛɛ wɔn, ‑ye 'ke ɔ 'hrɩɩ ‑wɛ 'le 'kuopʋ a 'bri, 'ɔɔ ꞊sʋɛ 'ye 'dɔ. Bɔ 'ba 'klɛɛ 'lu ye 'mʋ, ‑ye 'ke 'le ‑tɛgbi ‑pɛtu 'mʋ, 'ke ɔɔ 'le Abrahamʋ 'yee, Lasa 'ɔ nɩɔ 'o 'hʋɩn 'mʋ gbo. ");
INSERT INTO ted_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‑Ye ɔɔ 'le 'yaa win, ɔ nɔ: ‑A nɩ bu Abrahamʋ, 'nɩɩ 'ye ꞊sʋɛ 'dɔ, kɛ nɔ na 'mʋ. 'Ye 'na wɔlɩ, ‑bo le Lasa, bɔ 'nyra 'a ‑jie 'nie ye, ɔ 'mue 'o 'na mɛ ke 'tee, 'na mɛ a ‑gbɛ, ɛ 'mʋ pʋpɛ. ");
INSERT INTO ted_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‑Ye Abrahamʋ nɔ: 'Na 'yu o, bɩ bi 'le ‑mʋ 'kwli 'mʋ, ‑tɛ ‑n nɩ la 'klɔ, 'ɛ nɩ dɛ, ‑nɩɩ la ‑hʋa, ‑n kʋɛ la nɩ. Kɛɛ, Lasa ‑mɛ ‑ye, ɔ 'de la dɛ ꞊de kɔ. ‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, ɔ kɔ nɔ plɔ a bleelɛ, ‑mɛ ‑ye, ‑nɩɩ 'le 'ye ꞊sʋɛ. ");
INSERT INTO ted_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Dɛ 'n kɔ ꞊bo le ‑mʋ, nɛ‑ mɔ, a kɔ ‑a mʋ 'hɛɛn ‑gbahlɔn 'hʋɔ nɩ 'o, 'ɔ hren 'mʋ gbo 'dɔ. Ɛ nue, nyɔ ꞊de 'die ‑wɛ 'le ‑wɛ bɔ ‑hɔn nɔ ‑a mʋ ‑wɔn 'mʋ, bɔ mu 'le 'a mʋ ‑wɔn, mɔ, nyɔ ꞊de 'die ‑wɛ 'le ‑wɛ bɔ ‑hɔn ‑wɛ 'le 'a mʋ ‑wɔn 'mʋ, bɔ di nɔ ‑a mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","‑Ye dɛkɔnyɔ nɔ: ‑A nɩ bu Abrahamʋ, 'nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, le Lasa, bɔ mu 'le 'na bu a kayu gbo, ");
INSERT INTO ted_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","‑tɛ 'n 'dɩayuoo ꞊hun nɩ 'le, ɔ 'mu le, ‑tɛ 'n nu naalɛ, ʋ 'nɩ ꞊han lɛ naalɛ nu, ‑ɛ die nu, 'bʋ 'kʋ, ʋ 'nɩ ꞊han ‑wɛ nɔ ꞊sʋɛ a 'yeelɛ ‑gbo 'mʋ di. ");
INSERT INTO ted_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","‑Ye Abrahamʋ ꞊tuo lele ‑wɔn, ɔ nɔ: ‑N ‑dɩayuo ꞊nʋ, ʋ kɔ Nyɩsʋa a tetei ꞊nʋ nɩ, Moise 'crɩɩ la, kɔ, 'ʋ kɔ ‑wɛ Nyɩsʋa a winwlɔn‑hɛnyʋ a 'crɩɩnɩɛi. Nyɩsʋa a nahuin a ‑gbɛ, nʋ‑ bʋ po nʋa ye gbo, ʋ 'mʋ Nyɩsʋa a 'hru a nalɛ yi. ");
INSERT INTO ted_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‑Ye dɛkɔnyɔ nɔ: 'Ʋʋn, ‑a nɩ bu Abrahamʋ, ɛ 'de a ꞊cɛɛ. Kɛɛ, nahuon 'bɔ ‑hɔn nɔ 'kʋkʋnyʋ ‑wɔn 'mʋ, 'bɔ nyu 'le ‑wɔn 'prɛɛ, ʋ di 'waa dɛ 'kuku 'nɩ yrii, ʋ 'mue 'o gbo hie, ʋ 'mʋ 'waa 'klɔ Nyɩsʋa ‑nyi. ");
INSERT INTO ted_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‑Ye Abrahamʋ ꞊tuo lele ‑wɔn, ɔ nɔ: 'Bɩa 'bʋ 'de Moise kɔ Nyɩsʋa a winwlɔn‑hɛnyʋ nʋa ye gbo po, ʋ 'deɛ bʋ po nahuon ꞊de nʋa ye gbo, kɔ, bʋ kuo ‑wɛ Nyɩsʋa ꞊wlʋ ye, ꞊betɩ nahuon a ‑gbɛ, bɔ ‑hɔn nɔ 'kʋkʋnyʋ ‑wɔn 'mʋ, bɔ 'hrɩ 'klɔ, bɔ nyu 'le ‑wɔn 'prɛɛ.» Kɛ ‑Yusu po nahuin ye. ");
INSERT INTO ted_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kɛ ‑Yusuu 'a ‑naagbopʋ ye po, ɔ nɔ: «'Ɛ nɩ ti, ɛ di kɔ ‑tɔplɩ ‑ye, ‑ɩ di nahuin 'tu, ʋ 'mʋ Nyɩsʋa a ꞊wlʋ a yekuolɛ 'kee. Kɛɛ, 'jrɔ 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ nye nu, 'a 'be ꞊nʋ 'ɔɔ Nyɩsʋa a ꞊wlʋ a yekuolɛ 'kee. ");
INSERT INTO ted_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","'Bɩa 'bʋ po wɛn nahuondʋ a ‑gbɛ 'hɩɔ gbɛtɛɛ dɔ, 'bʋ puo wɛn 'yru 'mʋ, ɔ 'mʋ 'kʋ, ɛ di wɛn nu ‑tɛɛ, 'ɛ ‑hi 'o bɔ nue wɛn, nahuon ꞊de, ‑ɔ kuo 'mʋ ꞊wlʋ ye, ‑ɛ 'we ꞊nɔ 'yu gbi ye, bɔ 'kee wɛn Nyɩsʋa a ꞊wlʋ a yekuolɛ. ");
INSERT INTO ted_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ba ꞊tu 'a nɩ dɩɔnʋ 'yie ‑tɛɛ. ‑N 'be Nyɩsʋa a nahuon 'bɔ nu ‑mʋ dɛ 'klan 'mʋ, le ꞊nɔ, ‑ɛ mɔ, dɛ ꞊nʋ, ɔ nu, ɛ nyre lɛ 'yi. 'Bɩa 'bɔ 'wɩn, 'bɔ 'cɩcɩ 'a nunuklɔ, ‑ye ‑bo ‑hri 'a dɛ 'kuku a ‑tɩ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","'Bɩa 'bɔ nu ‑mʋ dɛ 'kuku 'mʋ, 'wɩɩ 'nɩpata, 'ke 'le ‑nyrɔwɔɔ ‑do 'kwli 'mʋ, kɔ, 'ɛ nɩ ti, 'bɔɔ 'le ‑mʋ ye di, 'bɔ yrie, ‑ɛ mɔ, dɛ ꞊nʋ, ɔ nu ‑mʋ ‑wɔn, ɛ nyre lɛ 'yi, ‑ye ‑bo ‑hri 'a dɛ 'kuku a ‑tɩ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kɛ ‑wɔnnaanyʋʋ Kʋkɔnyɔ ‑Yusu ye po, ʋ nɔ: «‑Hɛ ‑a mʋ 'mʋ, 'ke ‑ba kuo Nyɩsʋa ꞊wlʋ ye ‑tɛɛ, ‑a nɩ ꞊wlʋ a yekuolɛ a ‑gbɛ, ɛ 'mʋ klɛ bii.» ");
INSERT INTO ted_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","‑Ye Kʋkɔnyɔ ꞊tu ‑wɔn, ɔ nɔ: «꞊Betɩ ba kuo wɛn Nyɩsʋa ꞊wlʋ ye dɛ gbi, a ‑wɛ 'le ba le wɛn tugbɛ ꞊nʋ nɩ: ‑Hɔn ‑wlu 'mʋ, ‑bo mu ‑n dɩɔnʋ 'dɔ, 'ke 'le 'yru ‑wɔn! 'ɛ mɔ ‑tɛɛ, ɛ 'mʋ wɛn 'o 'a mʋ 'o ꞊tuu.» ");
INSERT INTO ted_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ: «꞊Bo pue ‑kʋannunyɔ a dɛ ye: 'Ke 'le 'a mʋ ‑hɛyri, nahuon 'bɔ nɩ 'o, 'bɔ kɔ ‑kʋannunyɔ, ‑kʋannunyɔ a ‑gbɛ, 'bɔɔ nahuon a ‑gbɛ a ‑ci a ‑kʋan nu, kɔ, 'bɔɔ 'a 'wlugba‑tɔplɩ naa, 'plɩɩ 'bɔɔ 'le ‑ci ke 'mʋ ‑hɔn, ‑cikɔnyɔ 'bɔ 'yoo 'le ye 'mʋ, ꞊be kɛ ɔ dio ye po: 'Kɩka, ‑bo di 'le, ꞊mʋ dɛ di? ");
INSERT INTO ted_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","'Ʋʋn, ɔ 'deɛ bɔ po lɛ, kɛɛ, kɛ ɔ dio ye po: Mu ‑na wlawlɩ 'cɩcɩ, ꞊mʋ 'na dididɛ pi, ꞊mue 'le ya, 'mʋ dɛ di. 'Nɩ ‑wɔ 'klɛɛ dɛ lɛ, ‑ye ‑na ‑gbɛ, ‑n ‑wɛ 'le ‑bo di dɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","‑Kʋannunyɔ a ‑gbɛ, 'bɔ nu ‑kʋan ꞊nʋ, 'a 'masɛ plɛ bɔ nu, ꞊be a pui ‑tɛɛ, ‑ɛ mɔ, 'a 'masɛ a ‑gbɛ, ɔ dio ‑nyi 'wio? 'Ʋʋn, ɔ 'deɛ bɔ ‑nyo 'wio. ");
INSERT INTO ted_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kɛ'ɛ nɩ, ɛ ‑ti 'mʋ, 'ke 'o 'a mʋ ‑wɔn: 'Bɩa 'ba nu ‑tɔplɩ 'bii ꞊nʋ, Nyɩsʋa plɛ ba nu, kɛ ba po: ‑A mʋ mɔ ‑na ‑kʋannunyʋʋ nɩ ‑do. ‑A 'de 'wio kɔ, ‑ɛ nue, ‑kʋan, ‑a kɔ ‑ba nu wɛn, nɔ‑ ‑a nu.» ");
INSERT INTO ted_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋʋ 'lu ‑wɔn gba 'hru ꞊nʋ, ‑ʋʋ Jrusrɛdɩɔ 'mʋ mu. 'Ke ʋ naa 'le Samaliblʋgba kɔ Galileblʋgba a 'blɩ‑pamʋɩ 'yri. ");
INSERT INTO ted_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Bʋʋ 'klɛɛ 'le 'dɩɔ ‑ye 'mʋ mu pa, ‑ye ‑tɔplɩ‑jɔhʋɩnnunyʋʋ ‑pu, nʋ‑ di ‑Yusu ye 'mʋ 'bɛ wɔn. ‑Tɛ ʋ 'mʋɔɔ 'klɛɛ ye dɛ gbi, ‑ye ʋ nyra gbo, ");
INSERT INTO ted_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","'ʋ 'yaa 'le win, 'ʋʋ ‑Yusu da, ʋ nɔ: «Tɔɔnyɔ, 'ye ‑a nɩ wɔlɩ!» ");
INSERT INTO ted_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","‑Tɛ ɔ 'yu, ‑ye ɔ nɔ: «Ba mu, ba titie 'a nɩ dɩɔnʋ Nyɩsʋa a ‑cɔhlʋnpinyʋ ye, ‑ɛ die nu, ʋ 'mue 'ye, ‑ɛ mɔ, 'a nɩ 'kʋɛ ‑wɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","‑Tɛ ʋʋ mu, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, 'waa 'kʋɛ ‑wɛ nɩ. Nahuoon ‑do, 'ke 'le ꞊nʋ ‑hɛyri, nɔ‑ ꞊hɩan ‑wɔn, 'ɔɔ 'le win 'yaa, 'ɔɔ Nyɩsʋa 'nyrɛɛ lɛ pue. ");
INSERT INTO ted_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","‑Tɛ ɔ nyre 'o ‑Yusu 'hʋɩn 'mʋ, ‑ye ɔ blɔ ye gbo kwlɩ, 'ɔ ‑nyo 'wio. 'Plɩɩ ‑ye nahuon a ‑gbɛ, ɔ mɔ Samalikʋɛyu'u nɩ. (Samalikʋɛ a ‑gbɛ, ‑Juukʋɛ nɔ 'nɩ, ʋ 'de ꞊hapʋdakʋ.) ");
INSERT INTO ted_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kɛ ‑Yusuu lele po, ɔ nɔ: «'Be nahuiin ‑pu ꞊nʋ, ‑ʋ kɔ 'kʋɛ 'n ‑wɔ, ʋ seledo ‑ye ꞊nʋ, ‑be' ʋ nɩ 'klɛɛ ye 'le? ");
INSERT INTO ted_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Dɛ‑ nue, nahuon ꞊de 'ke 'le ꞊nʋ ‑hɛyri, ɔ 'die 'lu ‑wɔn lɛ ‑hie, 'ke bɔ di nɔ 'mʋ ye, ɔ 'mʋ Nyɩsʋa 'wio ‑nyi, 'bɛ 'de pʋpʋdakʋ a nahuon ‑gbo?» ");
INSERT INTO ted_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","‑Ye kɛ ‑Yusuu 'klɛɛ nahuon a ‑gbɛ ye po, ɔ nɔ: «'Ba ye 'mʋ, ‑bo mu. ‑N kuo 'mʋ ye ꞊wlʋ, nɛ‑ nue, Nyɩsʋa 'ɔ waa ‑mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","‑Nyrɔwɔ ꞊de 'mʋ, Falisi꞊tumu a nahuin ꞊de, nʋ‑ ꞊gba ‑Yusu wlɔn, ʋ nɔ: «Ti tio‑ kɔ 'yri Nyɩsʋa di 'o nahuin a win a kekɔɔlɛ ‑wlu ꞊tuu, ɔ 'mʋ 'a ‑kʋan 'lu ‑yra 'le?» ‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «Nyɩsʋa 'bɔ ꞊tu nahuin a win a kekɔɔlɛ ‑wlu, nahuon ꞊de 'deɛ bɔ 'ye ‑tɔplɩ, ‑ɩ di 'lu ‑wɔn mue, ‑ɩ die nahuin tɔɔ, ‑ɛ mɔ, Nyɩsʋa ꞊tu 'a nunue ‑wlu. ");
INSERT INTO ted_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ʋ 'die ‑wɛ 'le ‑wɛ bʋ plɛ: Ba ta nɔ lɛ, ‑hee', ba ta 'le ‑tɛ ꞊nʋ lɛ. Ba kɔ 'a yiyie, Nyɩsʋa ꞊tu nahuin a win a kekɔɔlɛ ‑wlu nɩ ‑dodo, 'ke 'le 'a mʋ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","‑Ye kɛ ɔɔ 'klɛɛ 'a ‑naagbopʋ ye po, ɔ nɔ: «Ɛ di kɔ ti, ‑ɩ kɔ 'yri a die 'o ‑hʋa 'dɔ, 'ke 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ꞊bo nɩ 'o 'a mʋ 'hʋɩn 'mʋ, 'ke 'le ‑nyrɔwɔ꞊gble 'kwli 'mʋ, kɛɛ, ɛ 'nɩ ‑wɛ ꞊le 'le ꞊le. ");
INSERT INTO ted_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ti a ‑gbɛ 'yri, kɛ nahuin di 'a mʋ ye po: Ba 'ye kɛ, kɛ ɔ nɩ mɔ, ‑hee', 'ke ɔ nɩ 'le ‑tɛgbi ꞊nʋ, kɛɛ, a nɩ mu 'le 'le, kɔ, a nɩ gba 'le 'le cigbɛi. ");
INSERT INTO ted_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","‑Nyrɔwɔ ꞊nʋ ‑kɔ 'mʋ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le lele di, 'na 'ledidie di ye 'we ‑tɛ tɩatɩɛɛ nu, 'ɛɛ wlɩn, kʋɛ 'le 'yrʋ a 'hrɩɩlɛ 'mʋ gbo, ‑bo mu, ‑bo yɛ 'yrʋ a gbopɛɛlɛ ke. ");
INSERT INTO ted_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kɛɛ, 'plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ 'lu ‑wɔn mue, 'n kɔ ꞊bo 'ye ꞊sʋɛ 'dɔ, kɔ, ti ‑gbo 'yri a nahuin kɔ bʋ yraa 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Dɛ ꞊nʋ, ‑ɛɛ la 'lu ‑wɔn mue, nahuon ‑gbo, ‑ɔ mɔ Noe a ti 'yri, ɛ ‑do a ‑gbɛ, nɛ‑ di 'lu ‑wɔn mue, ti ꞊nʋ ‑kɔ 'yri 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le di. ");
INSERT INTO ted_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noe a ti 'yri, nahuiin wɛn ‑tɔplɩ a die, ʋʋ wɛn nɔ a 'nɛɛ, ʋʋ wɛn a kʋkʋɛ, ʋʋ wɛn 'waa 'yuo 'blɩ 'mʋ lɛ a pʋɛ. Nɛ‑ ʋ 'ble kwa ‑bleble, Noe 'ɔ pa la kɛ 'le 'a 'mɩɩ ꞊nʋ 'kwli 'mʋ, 'nu gblaka 'ʋ bi la ꞊hlɔn, 'a 'yiyinie 'ɛ gba la ʋ 'bii, 'ɛ ‑wʋ la gbo. ");
INSERT INTO ted_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","‑Tɔplɩɩ ‑do ꞊nʋ, ‑ɩ mue la 'lu ‑wɔn, nahuon ‑gbo, ‑ɔ mɔ Lɔtɩ a ti 'yri, nɩ‑ di ‑wɛ 'lu ‑wɔn mue, 'na 'lediti 'yri. Lɔtɩ a ti 'yri, nahuiin wɛn ‑tɔplɩ a die, ʋʋ wɛn nɔ a 'nɛɛ, kɔ, ʋʋ wɛn ‑tɔplɩ a ‑tʋɛ, ʋʋ wɛn ‑tɔplɩ a plee, kɔ, ʋʋ wɛn ‑tɔplɩ a 'dʋɛ, ʋʋ wɛn kayuo a pue. ");
INSERT INTO ted_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kɛɛ, ‑nyrɔwɔ ꞊nʋ ‑kɔ 'mʋ Lɔtɩ ‑hɔn la 'le Sodɔmʋdɩɔ 'mʋ, ‑ye na kɔ 'nʋ ꞊nʋ 'hɛɛn, ‑ʋʋ nahuin lɛ 'lɩla, nɩ‑ ble la 'le yakɔ 'mʋ, 'ɩ ‑wɔ la nahuin 'bii gbo. ");
INSERT INTO ted_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ti ꞊nʋ ‑kɔ 'yri, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le lele di, ‑tɔplɩɩ ‑do a ‑gbɛ, ɩ kɔ bɩ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‑Nyrɔwɔ a ‑gbɛ 'mʋ, nahuon 'bɔ nɩ 'le 'a kayu a ‑yaa 'mʋ, bɔ 'gba ci lɛ ‑dodo. Ɔ nɩ po 'le lɛ, bɔ pa 'le 'a kayu gbo, ɔ 'mʋ 'a kʋkɔ‑tɔplɩ bla, 'plɩɩ ɔ 'mʋ ci lɛ 'gba. Nahuon 'bɔ nɩ 'le 'a ‑ci ke, bɔ 'gba ci lɛ ‑dodo. Ɔ nɩ po 'le ‑wɛ lɛ, bɔ ꞊hɩan ‑wɔn, bɔ mu 'le 'dɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dɛ ꞊nʋ, ‑ɛ nyre la 'o, 'ke 'o Lɔtɩ a nyrʋgba ‑wɔn, 'a ‑tɩ bɩ bi 'le 'a mʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nahuon 'bɔ nɩ 'o, 'bɔ plɛ, ɔ 'nɩ ‑hʋa ꞊le bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, 'ke 'o 'na ‑ta 'mʋ, ‑ye nahuon a ‑gbɛ, 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn 'a 'klɔ yrayrʋ 'nɩ 'waan, 'ke 'le Nyɩsʋa ye. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ wɛɛn ke, 'ke bɔ 'waan 'a dɩɔnʋ a ‑hʋnhlʋn, kɛ nɔ ‑tʋtʋ ke, ‑tɛ ɔ nʋɛ 'mʋ 'mʋ a ‑tɩ, ‑ye nahuon a ‑gbɛ, 'bɩa 'bɔ 'kʋ, ɔ di ‑hlɩn kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'ke 'le Nyɩsʋa ye. ");
INSERT INTO ted_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","'Nɩɩ 'a mʋ 'nɩ le, ti a ‑gbɛ 'yri, nahuiin 'hɔn 'bʋ pɛ 'o gbopɛdɛɛ ‑do ke, 'n di gba nahuoon ‑do, 'mʋ ꞊ɔ ‑ye gbo hie. ");
INSERT INTO ted_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nyrʋʋ 'hɔn 'bʋʋ ꞊gbla du, 'ke 'le ‑tʋɔɔ ‑do wlɔn, 'n di gba nahuoon ‑do, 'mʋ ꞊ɔ ‑ye gbo hie.  ");
INSERT INTO ted_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Nahuiin 'hɔn, 'bʋʋ ‑kʋan nu, 'ke 'le ‑cii ‑do ke, 'n di gba nahuoon ‑do, 'mʋ ꞊ɔ ‑ye gbo hie.» ");
INSERT INTO ted_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","‑Tɛ ‑Yusu po 'klɛɛ lɛ, ‑ye 'a ‑naagbopʋ ꞊gbɔ wlɔn, ʋ nɔ: «‑Be' ‑tɔplɩ a ‑gbɛ, ɩ di 'lu ‑wɔn ye mue 'le?» ‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «‑A 'brikʋɛ nɔ 'nɩ: ‑Tɛ dɛhʋɛ 'kukuu 'o nɩ, 'ke keii 'o lɛ 'kukue.» ");
INSERT INTO ted_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Yusu, ɔɔ Falisi꞊tumu a nahuin ye po ‑talʋdʋ ‑ye, ɔ 'mue ꞊nʋ tɔɔ, 'ke bʋ 'cipi 'o Nyɩsʋa a dɩda, ʋ nɩ sɩa 'le. Kɛ ɔɔ po: ");
INSERT INTO ted_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","«'Ke 'le 'dɩɔ ꞊de 'mʋ, ɛ kɔ la ‑batiponyɔ ꞊de. ‑Batiponyɔ a ‑gbɛ, ɔ 'nɩ pɩ ꞊le la Nyɩsʋa, kɔ, ɔ 'de la 'o nahuon ꞊de a 'o꞊tuulɛ kɔ. ");
INSERT INTO ted_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","'Ke 'le 'dɩɔɔ ‑do a ‑gbɛ 'mʋ, kotianyrɔ ꞊de nɩ ‑wɛ 'le. Kotianyrɔ a ‑gbɛ, nɔ‑ 'cipi la 'le ‑batiponyɔ a ‑gbɛ ‑wɔn, ɔ nɔ: Ɛ kɔ nahuon ꞊de. Nɔ‑ kɔ 'mʋ 'hɛɛn‑ kɔ ‑tɩ. 'N nye 'nɩ ‑hʋa, ‑bo nue, 'ke ꞊bo kɔ 'o ꞊wɔn. ");
INSERT INTO ted_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","'Ke 'le ti 'plɔplɔ 'kwli 'mʋ, ‑batiponyɔ, ɔ 'nɩ ‑hʋa ꞊le bɔ ‑nye la nyrʋgba a ‑gbɛ ꞊wɔn. Nɛ‑ ɔ nu la ‑nunu, ‑batiponyɔ a ‑gbɛ 'ɔɔ 'le 'a dɩɔnʋ ‑wɔn 'prɛɛ, ɔ nɔ: 'Ɛ mɔ ‑tɛɛ, 'nɩ pɩ ꞊le Nyɩsʋa, kɔ, 'nɩ 'de nahuon ꞊de a 'o꞊tuulɛ kɔ. ");
INSERT INTO ted_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Kɛɛ, ‑tɛ nyrʋgba ‑gbo, ɔɔ 'klɛɛ 'mʋ 'ku 'mʋ ‑ha, 'n die 'nɩ nu, ɔ 'mʋ 'o ꞊wɔn kɔ. Nɛ‑ 'de ꞊nɛ, ɔ 'kɩɛ die 'mʋ 'ku 'mʋ ‑ha, ɔ 'mue nu ‑nunu, 'na 'klɩ 'mʋ 'le ‑wɛ 'bii.» ");
INSERT INTO ted_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Kɛ ‑Yusuu lele po, ɔ nɔ: «Hɩ‑batiponyɔ ꞊nʋ, ‑tɩ ꞊nʋ, ɔ ꞊tu, a 'wɩn nɩ. ");
INSERT INTO ted_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","‑Ye 'klɛɛ, Nyɩsʋa ‑mɛ ‑ye, nahuin ꞊nʋ, ɔ ‑ha 'le du 'mʋ, 'ke ‑bʋ 'ya 'a nahuin 'mʋ, ‑ʋ nyo da, 'tɔ 'mʋ kɔ ‑nyrɛ 'mʋ, ꞊be ɔ 'deɛ bɔ nue, ʋ 'mʋ 'o ꞊wɔn kɔ, kɔ, ꞊be ɛ di 'o gbo 'nɩ ‑wlɛn, 'ke bɔ ‑hɩʋ 'mʋ? ");
INSERT INTO ted_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","'Nɩɩ 'a mʋ 'nɩ le, ɔ diu ‑nyi ꞊wɔn, ɔ 'mu 'mʋ ‑hɛ, tii ‑do a ti 'yri. Kɛɛ, ꞊bo ꞊gba 'a mʋ wlɔn: ti ꞊nʋ ‑kɔ 'yri 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n di 'le di, ꞊be 'n di nɔ gbo yɛ nahuin, ‑ʋ nu lɛ Nyɩsʋa a ꞊wlʋ a yekuolɛ?» ");
INSERT INTO ted_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu po ‑talʋdʋ ‑ye, 'ke 'o nahuin ꞊nʋ a ‑ta 'mʋ, ‑ʋ plɛ, 'waa 'yrinaabʋɩ 'sii 'o ye, 'ke 'o Nyɩsʋa ye, 'plɩɩ ‑ʋ plɛ, ʋ nɩ 'o 'waa 'bienʋ ‑tʋnahuin ye 'lu, ‑ʋʋ 'yilɛnyre‑tɔplɩ nu. Kɛ ‑Yusuu po, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Nahuiin 'hɔn, nʋ‑ʋ Nyɩsʋa mu da, 'ke 'le Nyɩsʋa a 'kagblaka gbo. ꞊Ɔ ‑ye mɔ Falisi꞊tumu a nahuon, (‑ɔ plɛ, 'a 'yrinaabʋɩ 'sii 'o ye.) ꞊Ɔ ‑ye mɔ ‑wɛ 'blʋwli'tɛnyɔ. (Ɛ kɔ ‑nyrɔwɩ ‑ye, 'ɔɔ 'yiyriwli 'tɛ.) ");
INSERT INTO ted_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","‑Tɛ ʋ nyre 'klɛɛ 'le Nyɩsʋa a 'kagblaka gbo, ‑ye Falisi꞊tumu a nahuon ꞊nʋ, 'ke ɔ mu 'o ye 'mʋ gbo nyra wɔn, 'ɔ ‑tʋa Nyɩsʋa a dɩda gbo, ɔ nɔ: Nyɩsʋa o, 'n ‑nyi ‑mʋ 'wio, ‑tɛ ‑n nu, ꞊nɩ nue, 'nɩ 'de nahuindʋ ‑gbo ye 'we, ‑ʋ mɔ 'yrinyʋ, kɔ 'crɛnyʋ, kɔ ‑wlawlinyʋ. 'N ‑nyi lele ‑mʋ 'wio, ‑tɛ ‑n nu, ꞊nɩ nue, 'nɩ 'de 'blʋwli'tɛnyɔ ꞊nʋ ye 'we. ");
INSERT INTO ted_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","'Nɩɩ nu ꞊ciiwɩɩ 'hɔn, 'ke 'le 'wee 'kwli 'mʋ, ɛ kɔ, 'bɩa 'nɩ kɔ ‑tɔplɩɩ ‑pu, 'nɩɩ ‑mʋ 'a ‑pu a nɛnɛ 'nɩ ‑nyi. Kɛ Falisi꞊tumu a nahuon po. ");
INSERT INTO ted_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","'Blʋwli'tɛnyɔ ‑mɛ ‑ye, ɔ bii ye, mɔ, ɔ 'de ‑wɛ 'yii ye 'mʋ 'ba, kɛɛ, ɔ 'ma 'a dɩɔnʋ ‑wliye gbo dabʋ, ɔ nɔ: Nyɩsʋa o, 'mɔ ‑gbo, ‑ɔ mɔ dɛ'kukununyɔ, 'ye 'na wɔlɩ.» ");
INSERT INTO ted_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le, 'blʋwli'tɛnyɔ ‑gbo, ‑tɛ ɔ ꞊hɩan ‑wɔn, ɔ mu 'le kayu gbo, ‑ye Nyɩsʋa 'sio 'o ye, 'ke 'o 'a dɩɔnʋ ye. Kɛɛ, ɔ 'de 'o Falisi꞊tumu a nahuon ye 'sii. 'Ɛ mɔ ‑tɛɛ, nahuon ꞊nʋ, ‑ɔɔ 'le 'a dɩɔnʋ 'yaa, Nyɩsʋa dio 'le 'nɩ ꞊tɩɔ, kɔ, nahuon ꞊nʋ, ‑ɔɔ 'le 'a dɩɔnʋ ꞊tɩɔ, Nyɩsʋa dio 'le 'nɩ 'yaa.» ");
INSERT INTO ted_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","‑Nyrɔwɔ ꞊de 'mʋ, 'ʋ gba 'le 'yuo꞊pli ‑Yusu ye, ɔ 'mu dabʋɩ 'lu gbo po, ‑ɛ die nu, ɔ 'mʋ Nyɩsʋa da, Nyɩsʋa 'mʋ 'yuo꞊pli a ‑gbɛ ꞊hapʋdɛ 'mʋ nu. Kɛɛ, ‑tɛ ‑naagbopʋ 'ye dɛ a ‑gbɛ, ‑ye ʋ nyu ꞊hɛn 'nyrɛ, ʋ nɔ: «A nɩ yʋ 'le ꞊nɔ ye!» ");
INSERT INTO ted_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kɛɛ ‑ye ‑Yusu da 'a ‑naagbopʋ nɩ, ɔ nɔ: «Ba ‑ha 'yuo꞊pli mɛ lɛ, bʋ di nɔ 'mʋ ye. A nɩ kʋ 'le ye, ‑ɛ nue, nahuin ꞊nʋ, ‑ʋ 'we ꞊nɔ 'yuo꞊pli ‑gbo ye, nʋ‑ di 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ pa. ");
INSERT INTO ted_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon 'bɔ 'nɩnɩ ‑ha Nyɩsʋa mɛ lɛ, 'ke bɔ kʋɔ win ke, ‑tɛ 'yu gbi, ɔɔ nu, 'ɔɔ 'a bu mɛ lɛ ‑ha, 'a bu 'ɔ nyo win ke kɔɔ, ‑ye nahuon a ‑gbɛ, ɔ 'die 'le ‑wɛ bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","‑Juukʋɛ a nyɩgblaka ꞊de, ‑ɔ nɩ 'o, nɔ‑ ꞊gba ‑Yusu wlɔn, ɔ nɔ: «Tɔɔnyɔ o, ‑mɔ mɔ ꞊hapʋnahuon. Dɛ tio‑ 'n di nu, 'plɩɩ 'mʋ Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le 'le?» ");
INSERT INTO ted_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","‑Ye ‑Yusu nɔ: «Dɛ‑ kɔ 'mɔ ‑nɩɩ ꞊hapʋnahuon daa? Nahuon ꞊de 'de ꞊hapʋnahuon, 'bɛ 'de Nyɩsʋaa ‑do. ");
INSERT INTO ted_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","‑N yi Nyɩsʋa a tetei nɩ, ‑ɩ mɔ: ꞊Nɩ nu 'le ‑wlawli, ꞊nɩ 'la 'le nahuon, ꞊nɩ 'yri 'le, ꞊nɩ po 'le nahuon hɩ ke, ꞊tuu 'o ‑n bu kɔ ‑n 'dii 'hɛɛn, 'ke 'le 'mʋnʋɛlɛ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","‑Ye ɔ nɔ: «Kʋɛ la 'le 'na 'yu‑nyrɛ a ti 'yie 'mʋ gbo, ‑bo yɛ ‑nyrɔwɔ ‑gbo ke, 'n ꞊tuu 'o tetei 'bii a ‑gbɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","‑Tɛ ‑Yusu 'wɩn, ‑ye kɛ ɔɔ ꞊nɔ ye po, ɔ nɔ: «Ɛ hie 'o ‑mʋ dɛɛ ‑do. Nɛ‑ mɔ, mu ‑bo plo ‑tɔplɩ 'bii ꞊nʋ, ‑n kɔ, ‑bo woo 'a 'wliyɛ ꞊sʋɛnyʋ 'mʋ lɛ, ‑ye Nyɩsʋa, nɔ‑ di ‑mʋ ꞊hapʋdɛ gblaka 'mʋ nu, 'ke 'le yakɔ 'mʋ. ꞊Nɩ nue 'klɛɛ, ‑ye ‑bo kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'na ‑naagbopʋyu ‑hɛ.» ");
INSERT INTO ted_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Bɔ 'wɩn 'klɛɛ, ‑ye 'a ꞊wlʋ bi ꞊hlɔn 'dɔ, ‑ɛ nue, ɔ mɔ dɛkɔnyɔ'ɔ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","‑Tɛ ‑Yusu 'ye, ‑ɛ mɔ, nahuon a ‑gbɛ a ꞊wlʋ bi ꞊hlɔn, ‑ye ɔ nɔ: «Ɛ kla wlɔn, 'ke 'o dɛkɔnyʋ ‑wɔn, 'ke bʋ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ɛ kla wlɔn, 'ke 'o dɛkɔnyɔ ‑wɔn, ‑ɔ kuo 'a kʋkɔ‑tɔplɩ ꞊wlʋ ye, 'ke bɔ kuo Nyɩsʋa ꞊wlʋ ye, bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, 'ɛ ‑hi 'o ꞊gbuke‑so bɔ naa 'le 'die a 'hʋɔ wlɔn.» ");
INSERT INTO ted_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","‑Tɛ nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'wɔn ‑Yusu a pupowin a ‑gbɛ, ‑ye ʋ nɔ: «'Bɛ kɔ bɛ ‑ti lɛ 'mʋ, nahuon ꞊de 'die 'le ‑wɛ bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","‑Ye ‑Yusu nɔ: «Ɛ 'die 'le ‑wɛ, 'ke 'le ‑tʋnahuon a 'klɩ 'kwli 'mʋ, bɔ kuo Nyɩsʋa ꞊wlʋ ye, ɔ 'mʋ 'le 'a 'klɔ yrayrʋ 'kwli 'mʋ pa. Kɛɛ, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ, ɛ ‑wɛ 'le ꞊le.» ");
INSERT INTO ted_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","‑Ye kɛ Piɛlɩɩ ‑Yusu ye po: «‑A ‑mɛ ‑ye 'le? 'Ye kɛ, ‑a hie 'o ‑a nɩ nahuin gbo, ɛ kɔ ‑a nɩ ‑tɔplɩ 'bii 'hɛɛn, ꞊aa ‑mʋ ‑wɔn naa.» ");
INSERT INTO ted_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ hie 'o 'a kayu gbo, kɔ 'a nyrʋgba, kɔ 'a ‑dɩayuo, kɔ 'a dii kɔ 'a bu 'hɛɛn, kɔ 'a 'yuo꞊pli, ‑tɛ Nyɩsʋa kʋɔ win ke a ‑tɩ, ");
INSERT INTO ted_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","‑ye nahuon a ‑gbɛ, 'klɔ ‑gbo, ‑a nɩ nɔ ‑wɔn, ‑tɔplɩ, Nyɩsʋa di ꞊nɔ ‑nyi, ɩ di 'nɩ ‑huo bʋbakɔ, ɩ 'mʋ 'o dɛ ꞊nʋ, ɔ hie 'o gbo 'mʋ ‑hi. 'Ya 'o lele 'lu, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'o 'klɔ ‑ye nuu, nahuon a ‑gbɛ, Nyɩsʋa di ꞊nɔ ‑nyi 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le.» ");
INSERT INTO ted_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusu 'ba 'a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn 'mʋ nɩ, 'ʋ bii ye. Kɛ ɔɔ 'klɛɛ ꞊nʋ ye po, ɔ nɔ: «Ba po 'mʋ nʋa ye gbo. ‑Aa 'mʋ mu Jrusrɛdɩɔ. 'Bɩa ꞊ba nyre 'le, ‑ye ‑tɔplɩ 'bii ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ ‑ye, ɔ 'crɩɩ la, 'ke 'o 'mʋ ke, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ‑tɔplɩ 'bii a ‑gbɛ, ɩ di ‑wɔn mue 'lu. ");
INSERT INTO ted_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nahuin ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, nʋ‑ ʋ di 'mʋ kwa po, nahuin a ‑gbɛ, ʋ 'mʋ 'mʋ 'caa, kɔ, ʋ 'mʋ 'mʋ ꞊sʋɛ ꞊tue, kɔ, ʋ 'mʋ 'mʋ hɩɔn 'hrin, ");
INSERT INTO ted_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kɔ, ʋ 'mʋ 'mʋ lɔkɔ bii, 'plɩɩ ʋ 'mʋ 'mʋ 'la. ‑Nyrɔwɩɩ 'hɔn 'bɩ ‑hi, ‑nyrɔwɔ a ta a nɔnɔ 'mʋ, 'plɩɩ 'mʋ 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, 'mʋ 'klɔ 'hrɩ.» ");
INSERT INTO ted_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","‑Tɩ a ‑gbɛ, ‑Yusu ꞊tu, 'a ‑naagbopʋ 'di 'mʋ lɛ yrii. Dɛ ꞊nʋ, 'a pupowin ꞊hɛn 'nyrɛ, ɩ ‑hli ꞊nʋ ke 'yi. Dɛ ‑kɔ ‑tɩ ɔ ꞊tu, ʋ 'di yi. ");
INSERT INTO ted_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","‑Tɛ dɛ a ‑gbɛ ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ 'mʋɛɛ 'dɩɔ ꞊nʋ ye, ‑ɔ mɔ Seliko, nahuin 'plɔplɔ 'ʋ nyu ‑wɔn kʋɛ. ‑Ye 'ke 'yiisuanyɔ ꞊de nɩ 'o 'hru nʋa 'mʋ gbo, 'ɔɔ nahuin 'wli lɛ ‑hʋa, ‑ɛ die nu, ɔ 'mʋ dɛ di. ");
INSERT INTO ted_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","‑Tɛ ɔ 'wɔn nahuin ꞊nʋ, ‑ʋʋ 'le di a win, ‑ye ɔ ꞊gba wlɔn, ɔ nɔ: «Dɛ tio‑o 'lu ‑wɔn mue 'le?» ");
INSERT INTO ted_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","‑Ye ʋ lo nɩ, ‑ɛ mɔ, Nasalɛtɩ 'mʋ a ‑Yusu'u nɩ, ‑ɔɔ ‑hi. ");
INSERT INTO ted_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","‑Ye ɔ 'yaa 'le win, ɔ nɔ: «‑Yusu o, Dafidɩ a 'Yu, yrii 'mʋ wɔlɩ ye ‑o!» ");
INSERT INTO ted_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","‑Ye nahuin ꞊nʋ, ‑ʋʋ ‑hi, ʋ nyo ꞊hɛn 'nyrɛ, ʋ nɔ: «Ma wien mɔ!» Kɛɛ ‑ye ɔ bla nɩ, 'ɔ 'yaa 'le lele win 'dɔ, ɔ nɔ: «‑Yusu o, Dafidɩ a 'Yu, yrii 'mʋ wɔlɩ ye ‑o!» ");
INSERT INTO ted_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","‑Tɛ ‑Yusu 'wɔn 'a win, ‑ye ɔ nyra gbo, 'ɔ le nahuin, bʋ yɔ 'o ꞊nɔ 'hʋɩn 'mʋ. ‑Tɛ 'yiisuanyɔ a ‑gbɛ, ɔ 'yɩyɔ 'o 'hʋɩn 'mʋ gbo, ‑ye ‑Yusu ꞊gbɔ wlɔn, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Dɛ tio‑ ‑nɩɩ ‑hʋa, ꞊bo nu, 'ke 'o ‑mʋ ‑wɔn 'le?» ‑Ye ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Kʋkɔnyɔ o, 'n nye 'nɩ ‑hʋa, ‑bo nue, 'na 'yii ‑gbo, ‑ɩɩ kla, bɩ klɛ ke!» ");
INSERT INTO ted_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","‑Ye ɔ lo nɩ, ɔ nɔ: «‑Na 'yii bɩ klɛ ke. ‑Tɛ ‑n kuo 'mʋ ꞊wlʋ ye, nɛ‑ nue, 'nɩ nue, ‑na 'yii 'ɩ klɛ ke.» ");
INSERT INTO ted_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tii ‑do a ti 'yri, ‑ye ɔ ‑tʋa lɛyriilɛ gbo, 'ɔ bi 'o ‑Yusu ke 'mʋ, 'ɔ nyo ‑wɔn kʋɛ, 'ɔɔ Nyɩsʋa 'nyrɛɛ lɛ pue. ‑Ye nahuin 'bii ꞊nʋ, ‑ʋ 'ye dɛ a ‑gbɛ, ʋʋ Nyɩsʋa ‑nyi ‑tɩ a 'yi'bʋaalɛ. ");
INSERT INTO ted_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu 'ya 'mʋ 'dɩɔ ‑ye ꞊nʋ, ‑ɔ mɔ Seliko, 'ɔɔ 'dɩɔ a ‑gbɛ ꞊tɩɔ 'bɛ. ");
INSERT INTO ted_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","'Ke 'le 'dɩɔ a ‑gbɛ 'kwli 'mʋ, 'ke nyɩbɛyu ꞊de nɩ 'le. 'A 'dʋ mɔ Sase. Ɔ mɔ 'blʋwli'tɛnyʋ a nyɩgblakaa nɩ, 'ɔ mɔ dɛkɔnyɔ. (‑Ye nahuin, ʋ 'nɩ ‑hʋa ꞊le la 'blʋwli'tɛnyʋ, ‑ɛ nue, ʋʋ la 'tɛ 'yiyriwli. ‑Tɛ 'a 'bienʋ 'blʋwli'tɛnyʋʋ nu, kɛ ɔɔ ‑wɛ nu, 'ɔɔ nahuin a 'wli ‑hʋa 'dɔ.) ");
INSERT INTO ted_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nɔ‑ ‑hʋa ‑bɔ 'ye, nahuon a gblo tio‑ ‑Yusu bɔ 'ya 'mʋ. Kɛɛ, 'a 'gbugbelɛ a ‑tɩ, ɔ 'de 'le 'a 'yiye ‑wɛ, ‑ɛ nue, ‑tʋnahuin ‑huohui ‑gbahlɔn 'ke ‑Yusu nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","‑Ye ɔ 'gba lɛ ci, 'ɔ mu 'le ye 'mʋ, ‑tɛgbi ꞊nʋ, ‑Yusu kɔ bɔ naa 'o. 'Ke pepetu ꞊de nyra 'o gbo, 'ʋ nye sikomɔ daa. Ɛ nɛ‑ kɔ 'klɔ ɔ 'ya 'le, ɔ 'mʋ ‑Yusu 'ye. ");
INSERT INTO ted_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","'Ke ɔ nɩ 'klɛɛ 'o, ‑ye ‑Yusu nyre 'o ‑tɛgbi a ‑gbɛ nɩ, 'ɔ 'wla pepetu a ‑gbɛ 'yii wla, ‑ye ɔ 'ye Sase nɩ, ɔ nɔ: «Sase, po 'le 'klɩ lɛ, ‑bo ꞊tɩ, ‑ɛ nue, kɛkɛ ‑gbo, 'ke 'n di kɛ 'le ‑mʋ ‑wɔn pa.» ");
INSERT INTO ted_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","'Tata a ti 'yri, Sase 'ɔ ꞊tɩ, 'ɔ gba 'le ‑Yusu kayu gbo, 'ɔ 'blo kwa, 'ke 'le plɔ a bleelɛ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'ye nɩ, ‑ɛ mɔ, ‑Yusu pa ye Sase. ‑Tɛ ʋ 'ye, ‑ye ʋʋ 'mʋ lɛ 'nɩ 'pʋprɛ, ʋ nɔ: «'Ke ɔ pa 'le dɛ'kukununyɔ a ‑tɛ.» ");
INSERT INTO ted_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","'Ke 'le kayu gbo, Sase a ‑gbɛ, ɔ 'ba 'mʋ ye, 'ɔ nyra 'o ‑Yusu ye 'mʋ gbo, ‑ye kɛ ɔ nyo 'klɛɛ ye po, ɔ nɔ: «Kʋkɔnyɔ o, 'n nɛ kʋkɔ‑tɔplɩ ‑gbo, 'n di 'bɛ ꞊tɩɔ, 'mʋ 'a ꞊tɩɔ ‑ye ꞊nʋ ꞊sʋɛnyʋ ‑nyi. 'Bɩa 'nɩ kaa o nahuon, ‑tie ‑gbo, 'n ‑ha 'o ꞊nɔ kwa, 'a gbleii ‑hɛn, 'mue 'le po, 'mue ꞊nɔ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","‑Ye kɛ ɔɔ Sase ye po: «Kɛkɛ ‑gbo, ‑n kɔ ‑na kayugbokʋɛ 'hɛɛn, Nyɩsʋa waa kɛ 'a mʋ nɩ. Abrahamʋ, ‑ɔ mɔ Nyɩsʋa a dakʋ ‑gbo a bu gblaka, ‑mɔ mɔ ‑wɛ 'a 'yuo a 'yu ‑yee nɩ. ");
INSERT INTO ted_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mɔ Nyɩsʋa lee nɔ ‑tʋtʋ ke, 'mʋ nahuin ꞊nʋ lɛ ꞊mɔ, ‑ʋ 'wan, ‑ʋ hren Nyɩsʋa ‑wɔn, 'mu waa, 'ke 'o 'waa 'yilɛnyre‑tɔplɩ ꞊nʋ, ʋ nu a ‑ta 'mʋ, ʋ 'mʋ Nyɩsʋa ye 'mʋɛɛ.» ");
INSERT INTO ted_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nahuin ꞊nʋ, ‑ʋ nɩ 'o, ‑ʋ po wɛn ‑Yusu nʋa ye gbo, ‑Yusu pu lele ye ‑talʋdʋ. ‑Tɛ ‑Yusu a ‑gbɛ, ɔɔ la Jrusrɛdɩɔ yrɛ 'mʋɛɛ, nahuin a ‑gbɛ, 'waa ꞊wlɩ nɔ 'nɩ, Nyɩsʋa ‑wɛ lɛ kɛ 'klɔ yrayrʋ a ‑wlu꞊tutue. ");
INSERT INTO ted_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","‑Yusu 'mue ꞊nʋ tɔɔ, ‑ɛ mɔ, ɛ 'de ꞊nɛ, nɛ‑ nue, 'ɔ po ꞊nʋ ‑talʋdʋ ye, ɔ nɔ: «꞊Tugba gblaka ꞊de a nahuon, nɔ‑ɔ la 'dagba ‑pɛtu 'mʋ mu, 'ke 'le 'kɩɩnpʋ ‑wɔn, ‑ɛ die nu, 'kɩɩnpʋ a ‑gbɛ, ʋ 'muo 'a 'blʋgba꞊tɩɔ ‑ye a 'kɩɩn 'mʋ nuu. ");
INSERT INTO ted_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","'Plɩɩ ɔ 'mʋ mu mu, ‑ye ɔ da 'a ‑kʋannunyʋʋ ‑pu ꞊nʋ nɩ, 'ɔ hie ꞊nʋ 'wliblɛɛ ‑pu lɛ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, ɔ kɔ 'a 'wliblɔɔ ‑do, 'ɔ le ꞊nʋ, ɔ nɔ: Tii ‑tie 'n di 'le ‑hi, 'plɩɩ 'mʋ 'le di, ba hraa 'wli ‑gbo kʋɛsɛ 'yri. ");
INSERT INTO ted_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kɛɛ ‑ye nyɩgblaka a ‑gbɛ, nahuin yrɔɔ nɩ, 'ʋ le nahuin, 'ke bʋ le 'blʋgba a 'kɩɩnpʋ, ‑ɛ mɔ, ʋ 'nɩ ‑hʋa ꞊le, 'ke nahuon a ‑gbɛ, bɔ ‑hɛ 'waa 'kɩɩn. ");
INSERT INTO ted_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Kɛɛ, kɛ ɛ nɩ 'mʋ, 'ʋ ‑nyo 'kɩɩndɛ, 'ɔ di 'bri. ‑Tɛ ɔ di 'klɛɛ 'le, ‑ye nahuin ꞊nʋ, ɔ hie 'wliblɛ lɛ, ɔ dʋ nɩ, ‑ɛ die nu, 'wlii ‑tie 'ɛ nɩ nahuon 'ye, 'ke 'le kʋɛsɛ a hɩhra 'kwli 'mʋ, ɔ 'mue yi. ");
INSERT INTO ted_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","‑Tɛ ye‑hɛnahuon nyre 'o, ‑ye ɔ nɔ: 'Na 'masɛ o, 'wliblɔ ꞊nʋ, ‑n ‑nyi o 'mʋ, 'n hrɔɔ 'yri kʋɛsɛ, 'ɔ po 'o 'wliblɛɛ ‑pu ‑ye. ");
INSERT INTO ted_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‑Ye 'a 'masɛ nɔ: Ɛ nu ‑tɛɛ. ‑Mɔ mɔ ꞊hapʋ‑kʋannunyɔɔ nɩ. ‑Tɔplɩ ‑gbo, ‑ɩ 'de ‑huo, 'n ‑nyi ‑mʋ, ‑n nui 'yri ‑kʋan ‑tɛɛ. 'A ‑tɩ, 'n di ‑mʋ ‑nyi 'klɩ, 'ke ‑bo kɔɔ 'dɩɛɛ ‑pu win ke. ");
INSERT INTO ted_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‑Tɛ ye‑hɛnahuon ‑hi, ‑ye nahuon a 'hɔn a nɔnɔ, nɔ‑ nyre 'o, ɔ nɔ: 'Na 'masɛ o, 'wliblɔ ꞊nʋ, ‑n ‑nyi o 'mʋ, 'n hrɔɔ 'yri kʋɛsɛ, 'ɔ po 'o 'wliblɛɛ ꞊hun ‑ye. ");
INSERT INTO ted_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‑Ye 'a 'masɛ nɔ: 'N di ‑mʋ ‑nyi 'klɩ, 'ke ‑bo kɔɔ 'dɩɛɛ ꞊hun win ke. ");
INSERT INTO ted_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‑Tɛ nahuon a 'hɔn a nɔnɔ ‑hi, ‑ye nahuon a ta a nɔnɔ, nɔ‑ nyre 'o, ɔ nɔ: 'Na 'masɛ o, 'wliblɔ ꞊nʋ, ‑n ‑nyi o 'mʋ, ɔ nɔ‑ ‑gbo. 'N mʋa o 'wliblɔ a ‑gbɛ lɛ, 'ke 'le danʋ wlɔn, 'nɩ ‑hlo o ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","'Nɩɩ o pɩ ‑na hʋannʋ, ‑ɛ nue, ‑na ŋmli 'yakla nɩ. Dɛ ꞊nʋ, ‑n 'de gbo ꞊tu, nɛ‑ ‑n plɛ ‑bo gba, kɔ, 'dɩdɔ‑tɔplɩ ꞊nʋ, ‑n 'de 'dɔ, nɩ‑ ‑n plɛ ‑bo 'cɛ. ");
INSERT INTO ted_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‑Ye 'a 'masɛ nɔ: ‑Kʋannunyɔ ꞊nʋ, ‑ɔ kɔ 'klɔ nyre 'yi lɛ, nɔ‑ ‑n 'ya 'mʋ. ‑Na pupowin, nɩ‑ 'n di nu, 'mʋ ‑na ‑bati 'bɛ. ‑N yie nɩ, ‑ɛ mɔ, 'na ŋmli 'yakla nɩ, kɔ, 'dɩdɔ‑tɔplɩ ꞊nʋ, 'n 'de 'dɔ, nɩ‑ 'n plɛ ꞊bo 'cɛ. ");
INSERT INTO ted_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","'A ‑tɩ, ‑n kɔ ‑bo po wɛn 'le 'na 'wliblɔ ‑bakɩ 'mʋ, ‑ɛ die nu, 'ledidie ‑gbo, 'n di 'le, 'mʋ wɛn 'na 'wliblɔ ꞊nʋ ‑hʋa, ɛ kɔ dɛ ‑gbo 'hɛɛn, ‑ɛ di wɛn 'o ꞊nɔ 'lu 'mʋ bi. ");
INSERT INTO ted_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","‑Ye 'masɛ a ‑gbɛ, ɔ le nahuin ꞊nʋ, ‑ʋ nɩ 'o, ɔ nɔ: Ba ‑ha ꞊nɔ 'wliblɔ a ‑gbɛ kwa, ba ‑nyo nahuon ꞊nʋ, ‑ɔ kɔ 'wliblɛɛ ‑pu. ");
INSERT INTO ted_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‑Ye kɛ ʋʋ ꞊nɔ ye po, ʋ nɔ: 'Masɛ o, ɔ kɔ 'wliblɛɛ ‑pu. ");
INSERT INTO ted_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: 'Nɩɩ 'a mʋ 'nɩ le, 'ɛ nɩ nahuon, ‑ɔ kɔ ‑tɔplɩ ‑huohui, ʋ di lele ꞊nɔ ‑nyi ‑tɔplɩ ‑ye. Kɛɛ, nahuon ꞊nʋ, ‑ɔ kɔ ‑tɔplɩ 'de ‑huo, ʋ di ꞊nɔ kwa 'nɩ ‑ha. ");
INSERT INTO ted_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","'Ya 'o lele 'lu, 'na yraanyʋ ꞊nʋ, ‑ʋ 'die ‑hʋa, 'ke ꞊bo ‑hɛ 'waa 'kɩɩn, ba yʋ 'mʋ ye, a 'mu 'la.» ");
INSERT INTO ted_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye ɔ po nahuin ꞊nʋ 'mʋ ye, 'ʋʋ Jrusrɛdɩɔ 'mʋ mu. ");
INSERT INTO ted_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Bʋ 'mʋɛɛ 'klɛɛ 'dɩɛ ꞊nʋ ye, ‑ɛ mɔ, Bɛtɩfase kɔ Betani, ‑ye 'ke ʋ nyre 'o dʋgba ꞊nʋ ꞊hlɔn, ‑ɔ kɔ 'lu ti nɩ 'le, ʋʋ olifie daa, 'ɔ le 'a ‑naagbopʋʋ 'hɔn, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","«Ba mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ nɩ 'le 'a mʋ ye 'mʋ. 'Bɩa 'ba 'ya 'dɩɔ a ‑gbɛ 'mʋ, ‑ye a di 'o gbo yɛ 'kasrayu, 'ʋ mʋ gbo. Nahuon ꞊de 'diu ‑hlɩn 'o ke a 'yɛɛ. Nʋ‑ ba ꞊wlɛɛ gbo, ba yʋ 'mʋ ye. ");
INSERT INTO ted_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","'Bɩa nahuon ꞊de 'bɔ ꞊gba 'a mʋ wlɔn, 'bɔ plɛ: Dɛ‑ kɔ 'a gbo꞊wlɛɛlɛ 'le? ‑ye kɛ ba po: ‑A nɩ Kʋkɔnyɔ'ɔ nɩ, ‑ɔ nyu ‑hʋa.» ");
INSERT INTO ted_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","‑Tɛ ʋ mu, ʋ 'ya 'dɩɔ a ‑gbɛ 'mʋ, ‑ye 'ɛ mɔ ‑tɛɛ, 'ke ʋ yɛ 'o 'kasrayu a ‑gbɛ gbo, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑Yusu nu wɛn 'a ꞊tutue, ");
INSERT INTO ted_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","'ʋ ‑tʋa 'a gbo꞊wlɛɛlɛ gbo. ‑Ye kɛ 'kasrayu a ‑gbɛ a kʋkɔnyʋ, ʋʋ ꞊nʋ ye po, ʋ nɔ: «Dɛ‑ kɔ 'kasrayu ‑gbo a gbo꞊wlɛɛlɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","‑Ye ʋ ꞊tu ‑wɔn, ʋ nɔ: «‑A nɩ Kʋkɔnyɔ'ɔ nɩ, ‑ɔ nyu ‑hʋa,» ");
INSERT INTO ted_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","'ʋ yʋ ‑Yusu ye. ‑Tɛ ʋ yʋ 'le, 'ʋ po 'o 'waa danɩ kɔ wlawlɩ 'kasrayu a ‑gbɛ ke gblɛ, 'ʋ ‑hɩɔ 'mʋ, 'ɔ 'ya 'o 'kasrayu a ‑gbɛ ke. (‑Ɛ nue, ɔ nye nahuin 'nɩ tɔɔ, ‑ɛ mɔ, ɔ mɔ bodɩɔɔ nɩ, ‑ɔɔ 'le kegbowɛɛnlɛ ya, ɛ 'de tʋ, ɔ 'nɩ yʋ ꞊le 'le. Ɛ nɛ‑ kɔ ‑tɩ 'ɔ 'ya 'o 'kasra a ‑gbɛ ke.) ");
INSERT INTO ted_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Bɔɔ 'klɛɛ mu, ‑ye nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ po 'o 'waa nɩ danɩ wlɔn gblɛ 'hru, 'ke 'o ‑Yusu a ‑tɩ a 'yi'bʋaalɛ a ‑ta 'mʋ, ‑Yusu 'ɔ nyi ke na. ");
INSERT INTO ted_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","‑Tɛ ɔɔ Jrusrɛ yrɛ 'mʋɛɛ, ‑ye 'ke ʋ nyre 'o 'hru꞊tɩɔ ꞊nʋ wlɔn, ‑ɔ ‑hɔn 'le olifiedʋgba 'lu 'mʋ, ‑ɔɔ Jrusrɛ 'mʋ mu. ‑Ye nahuin 'bii ꞊nʋ, ‑ʋʋ ‑Yusu ‑wɔn naa, ʋ ‑tʋa 'manʋ a nunue gbo, 'ʋʋ 'le win 'yaa, 'ʋʋ Nyɩsʋa 'nyrɛɛ lɛ pue, 'ke 'o 'ŋmilɛka‑tɔplɩ 'bii ꞊nʋ, ‑Yusu nu a ‑ta 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ʋ nɔ: «‑Na 'wio, ‑mɔ bodɩɔ ‑gbo, ‑ɔɔ 'le di, 'ke 'le Kʋkɔnyɔ Nyɩsʋa a 'dʋ 'kwli 'mʋ, Nyɩsʋa bɔ ‑nyi ‑mʋ ‑tɩ a 'yi'bʋaalɛ. Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, nɔ‑ɔ ‑a mʋ kegbowɛɛnlɛ ‑nyi. ‑Tɩ a 'yi'bʋaalɛ, 'ke 'o ꞊nɔ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","'Ke 'le nahuin a ‑gbɛ ‑hɛyri, Falisi꞊tumu a nahuin ‑ye nɩ 'le. Kɛ ʋʋ ‑Yusu ye po: «Tɔɔnyɔ o, le ‑na ‑naagbopʋ ‑gbo, bʋ 'kee ‑cici a wlɔnlɛpupue!» ");
INSERT INTO ted_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le, 'bɩa 'bʋ 'kee ‑cici a wlɔnlɛpupue, ‑ye 'hɛ ‑gbo, ‑ɛ 'wlɛ 'hru wlɔn gblɛ, nɛ‑ di ‑cici wlɔn lɛ po, ɛ 'mʋ 'mʋ 'nyrɛɛ lɛ pue.» ");
INSERT INTO ted_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","‑Tɛ ‑Yusu 'mʋɛɛ 'klɛɛ Jrusrɛdɩɔ ye, ɔ 'yo, ‑ye ɔ ‑tʋa wuwe gbo, 'ke 'o ‑tɔplɩ ꞊nʋ a ‑ta 'mʋ, ‑ɩ di 'o nyre, 'ke 'o 'dɩɔ a ‑gbɛ a nahuin ‑wɔn, ");
INSERT INTO ted_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ɔ nɔ: «'N nye wɛn 'nɩ ‑hʋa 'dɔ, ‑nyrɔwɔ ‑gbo 'kwli 'mʋ, 'a mʋ Jrusrɛ 'mʋ a nahuin, 'ke ba yrii wɛn ‑wɛ ‑tɔplɩ ꞊nʋ 'mʋ lɛ, ‑ɩɩ kɛ 'lu ‑wɔn mue, ‑ɩ ‑wɛ 'le ‑bɩ nue wɛn, a 'mʋ wɛn kegbowɛɛnlɛ kɔ, a kɔ Nyɩsʋa 'hɛɛn. Kɛɛ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, ‑tɔplɩ a ‑gbɛ, ɩ ‑hli 'a mʋ ke 'yi. ");
INSERT INTO ted_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","'Ɛ mɔ ‑tɛɛ, ti di 'o 'nɩ nyre, ‑ɩ kɔ 'yri dakʋ ‑ye a nahuin, ‑ʋ mɔ 'a nɩ yraanyʋ, ʋ di 'le di, ʋ 'mʋ 'le 'dɩɔ ‑gbo 'le ꞊glaa, ‑ɛ die nu, nahuon ꞊de 'nɩ ꞊han 'hrɩ, ʋ 'mʋ 'a mʋ ‑wɔn di ‑wɔn, ");
INSERT INTO ted_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ʋ 'mʋ 'a mʋ gbo ‑wɔ 'bii, a kɔ 'a nɩ 'dɩɔ a ‑tɔplɩ 'bii 'hɛɛn, kɔ, ʋ 'mʋ ‑wɛ 'a nɩ 'dɩɔ a kayuo 'bii 'wla, ‑ɛ nue, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa dii 'a mʋ ke, a 'de ti a ‑gbɛ yrii.» ");
INSERT INTO ted_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","‑Tɛ ʋ nyre 'klɛɛ 'le Jrusrɛdɩɔ 'mʋ, ‑ye 'ke ‑Yusu pa 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ. 'Ke 'le ‑yaa a ‑gbɛ 'mʋ, 'ke puplonyʋ nɩ 'le, 'ʋʋ 'wlugba‑tɔplɩ plo, 'ke 'o Nyɩsʋa a ‑cɔhlʋn a pipie ‑wɔn. ‑Tɛ ɔ yʋ 'o gbo, ‑ye ɔ ‑tʋa 'waa lɛbʋbla gbo. ");
INSERT INTO ted_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «Ʋ 'crɩɛ nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Nyɩsʋa nɔ 'nɩ: 'Na kayu nɩ 'o ꞊o, ‑ɛ die nu, nahuin 'mʋ 'le 'mʋ daa.» Kɛ ‑Yusuu lele po, ɔ nɔ: «Kɛɛ ‑ye a ‑mɛ ‑ye, a nuu kayu a ‑gbɛ 'mʋ 'yrinyʋ a kayu.» ");
INSERT INTO ted_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kʋɛ 'le ‑nyrɔwɔ a ‑gbɛ 'yie 'mʋ gbo, ɔɔ nahuin tɔɔ Nyɩsʋa a ‑tɩ 'ɛ nɩ ‑nyrɔwɔ, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ. Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ ‑mɛ ‑ye, ʋ kɔ Nyɩsʋa teteitɔɔnyʋ, kɔ 'blʋ a nyɩgblakɩ 'hɛɛn, ʋʋ lɛ ꞊mɔ 'hru, 'ke bʋ 'la ‑Yusu. ");
INSERT INTO ted_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kɛɛ, ‑tɛ bʋ di 'a 'lɩla nu, ʋ 'die yi, ‑ɛ nue, 'ɛ nɩ ‑nyrɔwɔ, nahuin 'bii, ʋ nyo 'le 'nɩ ꞊glaa, ‑ɛ die nu, ʋ 'mʋ 'a tɔɔwin 'wɔn. ");
INSERT INTO ted_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","‑Nyrɔwɔ ꞊de 'mʋ, ‑Yusuu lele tɔɔ nahuin, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ɔ nyu Nyɩsʋa a ꞊hapʋtitie pue. ‑Tɛ ɔ nɩ 'klɛɛ 'o, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ Nyɩsʋa a teteitɔɔnyʋ, kɔ ‑Juukʋɛ a 'blʋ a nahuin ‑ye 'hɛɛn, nʋ‑ nyro 'o 'hʋɩn 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ʋ nɔ: «Nyɔ‑ ‑nyi 'klɛɛ ‑mʋ 'klɩ, 'ke ‑bo bla ‑tɔplɩplonyʋ ‑gbo lɛ 'le? Nyɔ‑ le ‑mʋ, 'ke ‑bo nu ‑tɔplɩ 'bii ‑gbo, ‑nɩɩ nu 'le?» ");
INSERT INTO ted_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Na ‑gbɛ, 'n di ‑wɛ 'a mʋ wlɔn ꞊gba dɛ. Ba le 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nyɔ‑ le la Saan, 'ke bɔ po la nahuin 'nie 'lu lɛ 'le? ꞊Be Nyɩsʋa'a nɩ, ‑hee' ‑tʋnahuiin nɩ?» ");
INSERT INTO ted_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","‑Ye ʋʋ wlɔn lɛ 'nɩ ꞊gbʋgba: «‑Be' ‑a di 'klɛɛ po 'le? 'Bɩa ꞊ba plɛ: Nyɩsʋa'a nɩ, ‑ɔ lo la, ‑ye ɔ di ‑a mʋ wlɔn 'nɩ ꞊gba: ‑Tɩ ꞊nʋ, Saan, ɔɔ la ꞊tu, dɛ‑ nue, 'a 'di la ‑tɛɛ pue 'le? ");
INSERT INTO ted_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mɔ, 'bɩa ꞊ba plɛ, ‑tʋnahuiin nɩ, ‑ye nahuin 'bii, ʋ di ‑a mʋ ‑wɔn lɛ poo 'hɛ, ʋ 'mʋ ‑a mʋ 'la, ‑ɛ nue, ʋ pui ‑tɛɛ, ‑ɛ mɔ, Saan, ɔ mɔ la Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nɛ‑ nue, 'ʋ ꞊tu ‑Yusu ‑wɔn, ʋ nɔ: «‑A 'de nahuon ꞊nʋ yi, ‑ɔ lo, 'ke bɔ po nahuin 'nie 'lu lɛ.» ");
INSERT INTO ted_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","‑Ye ‑Yusu nɔ: «'Na ‑gbɛ, 'n 'deɛ ꞊bo le ‑wɛ 'a mʋ, nyɔ‑ ‑nyi 'mʋ 'klɩ, 'ke ꞊bo nu ‑tɔplɩ 'bii ‑gbo, 'nɩɩ nu.» ");
INSERT INTO ted_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","(‑Yusu 'kɩɛ 'prɛɛ 'le nahuin ꞊nʋ ‑wɔn, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ,) ɔ nɔ: «Ɛ kɔ la 'dɩdɔnyɔ ꞊de. Nɔ‑ nu la 'a ‑ci. ‑Ci a ‑gbɛ ke, ɔ 'dɔɔ 'le ti ꞊de. 'A 'yɔ, ɩɩ tʋ, ʋ nyo daa rɛsɛn. ‑Tɛ ɔ ‑wɔ 'a 'dɩdɔ ‑wɔn, ‑ye ɔ le ‑kʋannunyʋ ꞊de, 'ke bʋ nu ‑ci a ‑gbɛ a ‑kʋan, 'dɩdɔ‑tɔplɩ 'bɩ tʋ, ‑kʋannunyʋ a ‑gbɛ, ʋ 'mʋ ꞊nɔ 'a 'pɩa ‑nyi, 'waa ‑gbɛ, ʋ 'mʋ ‑wɛ 'o 'waa nɩ 'pɩa kɔ. ‑Cikɔnyɔ a ‑gbɛ, ‑tɛ ɔ ‑wɔ ‑kʋan a yegblɛ꞊tutulɛ ‑wɔn, ‑ye ɔ mu 'mʋ 'dagba, ɔ 'mʋ 'le 'dai ti ‑hi. ");
INSERT INTO ted_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","‑Tɛ 'dɩdɔ‑tɔplɩ a 'cɩcɛti nyre 'o, ‑ye ‑cikɔnyɔ a ‑gbɛ, ɔ le 'a lɛleenyɔ ‑ye, 'ke bɔ mu 'le ‑ci'yie꞊tunyʋ ꞊nʋ ‑wɔn, ʋ 'mʋ ꞊nɔ 'cɩcɛ‑tɔplɩ a 'pɩa ‑nyi, ɔ 'mui ‑cikɔnyɔ ye ya. ‑Tɛ lɛleenyɔ a ‑gbɛ, ɔ nyre 'klɛɛ 'le, ‑ye ‑ci'yie꞊tunyʋ, ʋ bio nɩ ‑tɛɛ, 'plɩɩ, ʋ 'de ꞊nɔ dɛ ꞊de ‑nyi, 'ʋ ‑mɩɔ de. ");
INSERT INTO ted_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","‑Ye ‑cikɔnyɔ lee lele 'a lɛleenyɔ ‑ye, 'ʋ bio lele, 'ʋ ꞊tuo tanɩ, 'plɩɩ, ʋ 'de ꞊nɔ dɛ ꞊de ‑nyi, 'ʋ ‑mɩɔ lele de, ");
INSERT INTO ted_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","‑cikɔnyɔ a ‑gbɛ, 'ɔ le 'a lɛleenyɔ a ta a nɔnɔ, 'ʋ klo, 'ʋ hrɔɔ ‑wɛ dɛ, 'plɩɩ 'ʋ ꞊hunhuon 'le ‑patʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‑Ye kɛ ‑cikɔnyɔɔ 'a dɩɔnʋ ye po, ɔ nɔ: ‑Be' 'n di nu 'le? 'Na 'mʋnʋɛyu, nɔ‑ ꞊bo lee 'le ꞊nʋ ‑wɔn. 'N pue ‑tɛɛ, ʋ di kɔ 'a 'o꞊tuulɛ. ");
INSERT INTO ted_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","‑Tɛ ɔ waan 'le ye, ‑ye kɛ ʋʋ yrɛ pupo, ʋ nɔ: Nahuon, ‑ɔ di ‑tado ‑ci ‑gbo kɔ, nɔ‑ɔ 'le di. Ba nɩ ‑ba 'lɔ, ‑a 'mʋ ‑ci ‑gbo kɔ, ");
INSERT INTO ted_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","'ʋ klo, 'ʋ 'hrɔɔ 'le ‑ci 'mʋ, 'ʋ 'lɔ.» ‑Ye ‑Yusu nɔ lele: «'A mʋ 'nɩɩ wlɔn ꞊gba, nahuon, ‑ɔ kɔ ‑ci a ‑gbɛ, 'bɔ 'wɔn ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ mue 'lu ‑wɔn, dɛ tio‑ ɔ diu 'mʋ nu 'le? ");
INSERT INTO ted_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","'A ‑gbɛ, ɔ di 'le 'nɩ di, ɔ 'mʋ ‑ci'yie꞊tunyʋ a ‑gbɛ 'la, 'plɩɩ ɔ 'mʋ 'le lele ‑ci a ‑gbɛ ‑ha, ɔ 'mue lele ꞊ʋ ‑ye ‑nyi.» Nahuin ꞊nʋ, ‑ʋʋ ‑Yusu nʋa ye gbo po, ‑tɛ ʋ 'wɔn ‑tɩ a ‑gbɛ, ‑ye ʋ nɔ: «Gbegbe, ɛ 'deɛ bɛ mue 'lu ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kɛɛ ‑ye ‑Yusu nyu 'nɩ 'ye, ɔ nɔ: «'A ‑tɩ, ba ‑hie 'lu ‑wɔn lɛ, dɛ tio‑ ‑tɩ ꞊nʋ, ɩ ꞊hɛn 'nyrɛ, ʋ 'crɩɩ la 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: 'Katuo ꞊nʋ, kayuponyʋ 'de ‑hʋa bʋ nuu ‑kʋan 'yri, ʋ po 'pɩa ke, nɔ‑ ‑hɛ kayu a ‑gbɛ a 'katuo gblaka.» ");
INSERT INTO ted_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","‑Ye kɛ ɔɔ lele po, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔ bi 'o 'katuo a ‑gbɛ ke, ɔ di lɛ 'nɩ ‑yɩyrɛ, mɔ, 'katuo a ‑gbɛ, 'bɔ bi 'o ꞊nɔ ke, ɔ dio lɛ 'nɩ waka.» ");
INSERT INTO ted_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","'Plɩɩ ‑Yusu 'mʋ mu ‑yrɛ, ‑ye Nyɩsʋa a teteitɔɔnyʋ, kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ 'hɛɛn, ‑ʋ nɩ 'o, ʋ yree nɩ, ‑ɛ mɔ, nʋ‑ ‑Yusu po ‑talʋdʋ a ‑gbɛ ye. ‑Tɛ ʋ yrii dɛ a ‑gbɛ, ‑ye tii ‑do a ‑gbɛ 'yri, ʋʋ lɛ ꞊mɔ 'hru, 'ke bʋ klo, ʋ 'muo 'la. Kɛɛ, ʋʋ pɩ nahuin a hʋannʋ, 'ʋ ‑hɩɔ mɛ lɛ. ");
INSERT INTO ted_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Kɛɛ ‑ye ʋ ‑tʋa ‑Yusu a ‑gbɛɛlɛ gbo. Nɛ‑ nue, 'ʋ lee 'le ꞊nɔ nahuin ‑wɔn, ʋ 'mʋ 'o 'klɩ ꞊tu, ʋ 'mʋ o nahuin ꞊nʋ, ‑ʋ kɔ 'o꞊tuulɛ a ŋmli lɛ nu, ʋ 'muo wlɔn lɛ ꞊gba, 'a ‑wɔn꞊tutue 'kwli 'mʋ, ʋ 'mʋ 'le naa, ʋ 'muo ‑tɩ yɛɛ, ‑ɛ die nu, ʋ 'muo klɩ, ʋ 'muo 'le Romakʋɛ a ‑gʋlʋnʋma kwa 'mʋ po, ɔ 'muo ‑bati lɛ poo. ");
INSERT INTO ted_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","‑Tɛ ʋ nyre 'klɛɛ 'o ꞊nɔ 'hʋɩn 'mʋ, ‑ye ʋ nɔ: «Tɔɔnyɔ o, ‑a yie nɩ, ‑ɛ mɔ, ‑nɩɩ ꞊tu ‑tɩ a ‑tɛɛ, ꞊nɩ nyi nahuin tɔɔ. 'Bɩa ꞊nɩ nyi ꞊tu, ꞊nɩ pɩ ꞊le hʋannʋ, 'ke 'o ‑tʋnahuon a 'lu a lɛ‑hielɛ a ‑ta 'mʋ, mɔ ꞊betɩ bɔ 'ya nyɩgblaka 'mʋ. Kɛɛ, ‑nɩɩ tɔɔ ‑tɩ a ‑tɛɛ, 'ke 'o dɛ ꞊nʋ, Nyɩsʋaa ‑a mʋ ‑hʋa a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Le 'klɛɛ ‑a mʋ, ꞊be Nyɩsʋa a tetei nɔ 'nɩ, ‑ba ‑ha 'blʋwli, ‑ba ‑nyi Romakʋɛ a 'kɩɩn gblaka, ‑hee', ‑a 'de ye blɛ ‑ba ‑nyi ꞊nɔ?» ");
INSERT INTO ted_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kɛɛ ‑ye ‑Yusu yrii 'waa gblagblʋ nɩ, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Ba titie 'mʋ 'wliyɔkɔ a 'yɛɛ ‑do ye.» ‑Tɛ ʋ yɛ ꞊nɔ ye, ‑ye ɔ nɔ: «Nyɔ tio‑ kɔ 'lu꞊tɩɔ nɩ 'o 'le? Nyɔ tio‑ kɔ 'dʋ ʋ 'crɩɩ ‑wɛ 'o 'le?» ‑Ye ʋ nɔ: «Romakʋɛ a 'kɩɩn gblakaa nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","‑Ye kɛ ‑Yusu 'klɛɛ ꞊nʋ ye po, ɔ nɔ: «'A ‑tɩ o, ba ‑nyi 'kɩɩn gblaka dɛ, ‑ɛ blɛ ꞊nɔ ye, kɔ, ba ‑nyi ‑wɛ Nyɩsʋa dɛ, ‑ɛ blɛ ꞊nɔ ye!» ");
INSERT INTO ted_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ɛ 'we ꞊nɔ ye, ‑Yusu 'de dɛ ꞊de ‑wɔn ꞊tu, 'ke 'o nahuin ye, ‑ɛ kɔ 'kwli 'mʋ 'a yraanyʋ, ʋ ‑wɛ 'le bʋ naa 'le, bʋ yɔɔ ‑tɩ. Kɛɛ, ‑tɩ ꞊nʋ, ‑Yusu ꞊tu ꞊nʋ ‑wɔn, ɩ saka ꞊nʋ nɩ, 'ʋ 'de 'klɛɛ lele ‑tɩ ꞊de ꞊tu. ");
INSERT INTO ted_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","'Ke 'le Jrusrɛdɩɔ 'mʋ, ɛ kɔ la ꞊tumu. 'A 'dʋ mɔ Sadusɩ꞊tumu. Nʋ‑ʋ nɩ, ‑ʋ nyi ꞊tu, ‑ɛ mɔ, nahuin 'bʋ 'kʋ, ɛ 'die 'le ‑wɛ bʋ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, bʋ 'hrɩ 'klɔ, 'ke 'le Nyɩsʋa ye. Nʋ‑ kɔ nahuin mu 'o ‑Yusu 'hʋɩn 'mʋ, ‑ɛ die nu, ʋ 'muo wlɔn lɛ ꞊gba. ‑Tɛ ʋ nyre 'klɛɛ 'o ꞊nɔ 'hʋɩn 'mʋ, ‑ye kɛ ʋʋ ꞊nɔ ye po, ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Tɔɔnyɔ o, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, ɔ 'crɩɩ la tete ‑ye, 'ɔ hie la ‑a mʋ lɛ. Tete a ‑gbɛ, ɛ nɛ‑ ‑gbo: Nyɩbɛyu 'bɔ nɩ 'o, 'bɔ kɔ nyrɔ, 'plɩɩ nyɩbɛyu a ‑gbɛ, 'bɔ 'de 'yuo gbo hie, 'bɔ 'kʋ, ‑ye nyɩbɛyu ꞊nʋ, ‑ɔ 'kʋ, 'bɔ kɔ 'dɩayu nyɩbɛyu, nɔ‑ blɛ ye ‑bɔ kɔ nyrʋgba a ‑gbɛ, ɔ kɔ ꞊nɔ 'hɛɛn, ʋ 'mʋ 'yuo kɔ, 'ke 'o 'a 'dɩayu, ‑ɔ 'kʋ a ‑ta 'mʋ. Kɛ Moise a tetee po.» ");
INSERT INTO ted_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","‑Ye ʋ nɔ lele: «Ɛ kɔ la ‑dɩayuo nyɩbɛpʋʋ 'nɩpata, 'waa ye‑hɛnahuon 'ɔ kɔ nyrʋgba, nyɩbɛyu a ‑gbɛ 'ɔ 'de 'yuo gbo hie, 'ɔ 'kʋ, ");
INSERT INTO ted_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","'hɔn a nɔnɔ 'ɔ kʋɔ, 'ɔ 'de ‑wɛ 'yuo gbo hie, 'ɔ 'kʋ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Dɛɛ ‑do a ‑gbɛ, nɛ‑ nue ‑wɛ nahuon a ta a nɔnɔ. Nɛ‑ nue ‑nuenue, nahuon a 'nɩpata a nɔnɔ 'ɔ kʋɔ ‑wɛ, 'ɔ 'de ‑wɛ 'yuo gbo hie, 'ɔ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","‑Tɛ ʋ 'bii, ʋ 'kʋ 'klɛɛ, ‑ye nyrʋgba a ‑gbɛ, ɔ 'kʋ la ‑wɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nɛ‑ mɔ ‑tɩ ‑a di wɛn ‑mʋ wlɔn ꞊gba wɔn, ꞊mʋ ‑a mʋ klɛ ‑hɩhɩa. ‑Nyrɔwɔ ‑kɔ 'mʋ nahuin di 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, ʋ 'mʋ 'klɔ 'hrɩ, 'ke 'le Nyɩsʋa ye, nahuon tio‑ di 'klɛɛ nyrʋgba a ‑gbɛ kɔ 'le, ‑ɛ nue, ‑tɛ ʋ nɩ la nɔ ‑tʋtʋ ke, nahuiin 'nɩpata a ‑gbɛ, ʋ kʋɔ la nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Nyrʋ kɔ nyɩbɛpʋ 'hɛɛn, ‑ʋ 'kɩɛ nɩɛ 'klɔ, nʋ‑ʋ kʋkɔ. ");
INSERT INTO ted_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kɛɛ, nyrʋ kɔ nyɩbɛpʋ 'hɛɛn, ‑ʋ 'kʋ, Nyɩsʋa plɛ, ‑bʋ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, ‑bʋ 'hrɩ 'klɔ, 'ke 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'mʋ, nahuin a ‑gbɛ, ʋ 'nɩ kʋkɔ ꞊le. ");
INSERT INTO ted_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ʋ 'deɛ bʋ 'kʋ 'klɛɛ lele. Ʋ 'we ꞊nɔ Nyɩsʋa a lɛleenyʋ ye. Ʋ mɔ Nyɩsʋa a 'yuoo nɩ, ‑ɛ nue, 'ke ʋ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, 'ʋ 'hrɩ 'klɔ. ");
INSERT INTO ted_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Dɛ ‑gbo, ‑ɛ mɔ nahuin bʋ di 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, bʋ di 'klɔ 'hrɩ, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, nɔ‑ 'crɩɩ la 'a ‑tɩ. Ɔ 'crɩɩ la dɛ ꞊nʋ nɩ, Nyɩsʋa le ꞊nɔ, ‑tɛ Nyɩsʋa a ‑gbɛ, ɔ nɩ la 'le ‑gbakuduo ꞊nʋ 'kwli 'mʋ, ‑ɔɔ wlɩn, 'ɔ 'prɛɛ la 'le Moise a ‑gbɛ ‑wɔn. 'Ke 'le 'crɩɩnɩɛ꞊tɩɔ a ‑gbɛ 'kwli 'mʋ, ‑tɛ Moisee la Kʋkɔnyɔ da, ‑ye ɔ nyo daa Nyɩsʋa ꞊nʋ, Abrahamʋ, ɔɔ da, ɔ kɔ Yisakɩ, kɔ Sakɔbʋ 'hɛɛn.» ");
INSERT INTO ted_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kɛ ‑Yusuu lele po: «Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋaa 'le Moise ‑wɔn 'prɛɛ, Abrahamʋ kɔ Yisakɩ kɔ Sakɔbʋ 'hɛɛn, ʋ 'kʋ la nɩ. Kɛɛ, ‑a yie nɩ, ‑ɛ mɔ, ɛ 'de 'kʋkʋnyʋ, ʋ 'nɩ da ꞊le Nyɩsʋa, kɛɛ, 'klɔnɩnyʋ, nʋ‑ nyo da. Nahuin ꞊nʋ, ‑ʋ nɩ 'le Nyɩsʋa a 'klɔ yrayrʋ 'kwli 'mʋ, ʋ 'de 'kʋ, kɛɛ, ʋ nɩ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","‑Ye teteitɔɔnyʋ ‑ye, ‑ʋ nɩ 'o, ʋ nɔ: «Tɔɔnyɔ, ‑tɩ ꞊nʋ, ‑n ꞊tu, 'a ‑tɛɛ, nɛ‑ɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bʋ po 'klɛɛ lɛ, ‑ye nahuin ꞊nʋ, ʋʋ pɩ hʋannʋ, 'ke bʋ ꞊gbɔ lele wlɔn lɛ. ");
INSERT INTO ted_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «Ɛ kɔ nahuin, 'ʋʋ lɛ po: Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, Waanyɔ a ‑gbɛ, nɔ‑ mɔ bodɩɔ Dafidɩ a 'yuo a 'Yu. 'A mʋ 'nɩɩ 'klɛɛ wlɔn ꞊gba: Dɛ‑ kɔ ‑tɩ 'ʋ nyi ꞊tu 'le? ");
INSERT INTO ted_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","‑Ɛ nue, bodɩɔ Dafidɩ a ‑gbɛ, ɔ ꞊tui la nɩ, 'ke 'le Nyɩsʋa a ‑wlabrecrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Kʋkɔnyɔ Nyɩsʋa, ɔ le 'na Kʋkɔnyɔ nɩ, ‑ɛ mɔ: Nɩ mɔ 'na diidɛpɩa ke gbo, ‑n kɔ 'mʋ 'hɛɛn, ");
INSERT INTO ted_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","‑a 'mʋ nahuin win ke kɔɔ, ɛ 'mue gba ‑gbagba, 'mue nu, ꞊mʋ ‑na yraanyʋ bʋɩ 'lu gblɛ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","‑Ye ‑Yusu nɔ lele: «‑Tɛ Dafidɩ a ‑gbɛ, ɔɔ Waanyɔ a ‑gbɛ 'a Kʋkɔnyɔ daa, ‑be' Waanyɔ a ‑gbɛ, ɔ ‑wɛ 'le bɔ nu Dafidɩ a 'Yu a 'mʋ'yɩya 'le?» ");
INSERT INTO ted_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nahuin ‑huohui ꞊nʋ, ‑ʋ nɩ ‑tuo ke, ‑tɩ ꞊nʋ, ‑Yusu ꞊tu, ʋ pui ye gbo nʋa, ‑Yusu 'ɔɔ 'a ‑naagbopʋ le, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ba ꞊tu 'a nɩ dɩɔnʋ 'yie, 'ke 'o teteitɔɔnyʋ ‑wɔn, ʋ 'nɩ ꞊han 'a mʋ kaa. Ʋ nʋɛ 'mʋ nɩ, 'ke nahuin bʋ daa ꞊nʋ nyɩgblakɩ. 'Bʋʋ lɛ na, 'ʋʋ nyɩgblakɩ a wlawlɩ pue, ‑ɛ die nu, nahuin 'mu 'ye. 'Bʋʋ 'o 'ɛ nɩ ‑tɛgbi ꞊de mu, ‑tɛ nahuin ‑huo 'o, ‑ye ʋ nye 'nɩ ‑hʋa, nahuin bʋ pu 'wio gblɛ, 'ke 'o 'waa 'o꞊tuulɛ a ‑ta 'mʋ, 'ʋ nʋɛ ‑wɛ 'mʋ, 'bʋ mu 'le Nyɩsʋa a kayu gbo, 'ke bʋ nɩ 'le ye 'mʋ gbo, ‑ɛ die nu, nahuin 'bii 'mu 'ye. Dɛɛ ‑do a ‑gbɛ, nɛ‑ ʋʋ nu, 'bʋ dʋ dididɛ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","'Plɩɩ, 'ʋʋ kotianyrʋ kʋkɔ‑tɔplɩ 'bii ꞊nʋ kwa lɛ ‑ha. 'Plɩɩ, teteitɔɔnyʋ a ‑gbɛ, 'bʋʋ Nyɩsʋa da, 'waa Nyɩsʋa a dɩda hren gbo ye, ‑ɛ die nu, nahuin 'mʋ lɛ po, ʋ mɔ ꞊hapʋnahuiin nɩ. 'Nɩɩ 'a mʋ 'nɩ le, ‑bati ꞊nʋ, Nyɩsʋa diu lɛ poo, ɩ di ke nɩ 'klɩ, ɩ 'mʋ 'o ꞊ʋ ‑ye a ‑bati 'mʋ ‑hi.» ");
INSERT INTO ted_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","‑Yusu, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ 'kɩɛ nɩɛ 'le Nyɩsʋa a 'kagblaka gbo. 'Ke ʋ nɩ 'o dokwliye ꞊nʋ 'hʋɩn 'mʋ, ‑ɛ kɔ wlɔn nahuiin 'le 'wli lɛ po, 'ke 'o Nyɩsʋa a ‑kʋan a ‑ta 'mʋ. ‑Ye ‑Yusu 'ye nɩ, ‑tɛ dɛkɔnyʋ, ʋʋ 'le 'wli a lɛpupue nu. ");
INSERT INTO ted_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","‑Ye ɔ 'ye ‑wɛ ꞊sʋɛnyrɔ ꞊de. 'A tɔ 'kʋ la nɩ. Nɔ‑ nyre 'o, 'ɔ po 'le 'wliyɔkɔ a 'yɔɔ 'hɔn, ‑ɔ 'de 'le dɛ ꞊de a ‑tɩtɔ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","‑Tɛ ‑Yusu 'yo, ‑ye ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ke 'le Nyɩsʋa 'yi 'mʋ, ꞊sʋɛnyrɔ ‑gbo, ɔ po 'le 'wliyɛ, 'ɛ ‑hi 'o nahuin 'bii ‑ye ‑gbo 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","‑ɛ nue, nahuin 'bii ‑ye ꞊nʋ, 'wliyɛ, ‑ɛ 'de ‑kʋan kɔ, 'ke 'o ꞊nʋ ‑wɔn, nɛ‑ ʋ po 'le. Nyrʋgba ‑gbo, ɔ ‑mɛ ‑ye, ꞊hapʋkɔ, ꞊sʋɛ 'ɛ nyo nu, kɛɛ, 'wliyɛ 'bii, ɔ di wɛn nu, ɔ 'mʋ wɛn 'a dɩɔ ye ‑wɔn, nɛ‑ ɔ po 'le.» ");
INSERT INTO ted_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nahuin ‑ye, ʋʋ ꞊tu Nyɩsʋa a 'kagblaka ꞊nʋ a ‑tɩ. Kɛ ʋʋ po, ‑ɛ mɔ: «Ʋ nɔ lɛ 'yi 'dɔ. 'Ye kɛ, 'yilɛnɔhɛ ꞊nʋ, ʋ nu, 'ʋ pu, kɔ 'yilɛnɔ‑tɔplɩ a gblegblei, ʋ ‑ha, ʋ ꞊tu 'le kayu a ‑gbɛ gbo, Nyɩsʋa a ‑tɩ a 'yi'bʋaalɛ a ‑ta 'mʋ.» ‑Ye ‑Yusu nɔ: ");
INSERT INTO ted_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Kayu ‑gbo, aa 'klɛɛ 'ye, ‑nyrɔwɩ di 'o 'nɩ nyre, ‑ɩ kɔ 'mʋ ʋ diu 'o 'wlaa 'bii. 'A 'hɩɔ ꞊de 'deɛ bɔ nɩ 'o 'a 'be 'hɩɔ 'lu gbo.» ");
INSERT INTO ted_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","‑Ye ʋ ꞊gbɔ wlɔn, ʋ nɔ: «Tɔɔnyɔ, le ‑a mʋ, ti tio‑ kɔ 'yri ʋ di 'o Nyɩsʋa a 'kagblaka ꞊nʋ 'wlaa, kɔ dɛ tio‑ ‑a di 'ye, ‑ɛ di 'lu ‑wɔn mue, 'plɩɩ ‑a 'mue yi, ‑ɛ mɔ, ‑tɩ 'bii ‑gbo, ‑n ꞊tu wɛn, ɩ di 'nɩ nue?» ");
INSERT INTO ted_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «Ba ꞊tu 'a nɩ dɩɔnʋ 'yie, ꞊ɔ ꞊de 'nɩ ꞊han 'a mʋ kaa, ‑ɛ nue, nahuin 'plɔplɔ di 'le di, ʋ 'mʋ lɛ po, nʋ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, ʋ 'mʋ ‑wɛ lɛ po, ti ꞊nʋ ‑kɔ 'yri Waanyɔ a ‑gbɛ, ɔ kɔ bɔ di 'le, ɩ 'mʋɛɛ yrɛ. Kɛɛ, a nɩ kʋʋ 'le ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","'Ya 'o lele 'lu, a di 'nɩ 'wɔn, ‑ɛ mɔ, ʋʋ ‑wɔn tʋ, 'ke 'le 'blʋgbɩ ‑ye 'mʋ, kɔ, a 'mui ‑wɛ 'wɔn, ‑ɛ mɔ, ɛ kɔ nahuin, ‑ʋʋ 'blʋgbɩ ‑ye ꞊gbʋgblɔ. 'Ba nyi 'wɔn, a nɩ pɩ 'le hʋannʋ, ‑ɛ nue, ‑tɔplɩ a ‑gbɛ, ɩ kɔ bɩ mue 'lu ‑wɔn. Kɛɛ, 'bɩɩ 'lu ‑wɔn mue, ɛ 'de 'nyrɛ ꞊hɛn, tii ‑do a ‑gbɛ 'yri, 'ke 'klɔ a 'o'mʋ‑hɔnti di 'o nyre.» ");
INSERT INTO ted_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Kɛ ɔɔ lele po: «'Blʋgbɩ di ye 'nɩ ‑wʋnwɔn. ");
INSERT INTO ted_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","'Ke 'le 'dai 'blʋgbɩ 'mʋ, ‑tʋtʋ di 'nɩ 'hɩhrɔ 'dɔ, kanʋ 'mʋ ꞊tɩ, ꞊tɩtakʋɛi 'mʋ nahuin nu. 'Plɩɩ, ɛ di kɔ hʋannʋ‑tɔplɩ, ɩ 'mʋ 'le yakɔ 'mʋ 'hrɩɩ. ");
INSERT INTO ted_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kɛɛ, 'plɩɩ ‑tɔplɩ 'bii a ‑gbɛ, ɩ 'mʋ 'o nyre, ʋ di 'a mʋ 'nɩ klɩ, ‑tɛ a 'ya 'na nahuin 'mʋ a ‑tɩ, ʋ 'mʋ 'a mʋ ꞊sʋɛ ꞊tue, kɔ, ʋ 'mʋ ‑wɛ 'le 'a mʋ Nyɩsʋa a kayuo a nyɩgblakɩ ‑wɔn gba, ‑ɛ die nu, ʋ 'mʋ 'a mʋ ‑bati lɛ poo, kɔ, ʋ 'mʋ ‑wɛ 'a mʋ ꞊jɩ 'mʋ lɛ pupo, kɔ, ʋ 'mʋ ‑wɛ 'a mʋ ‑tɩ yɛɛ, 'ke 'o 'blʋgbɩ a bodɩɔpʋ kɔ 'a ‑gʋlʋnʋmapʋ ye. ");
INSERT INTO ted_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","'Bɩa 'bɛ nyre 'o 'a mʋ ‑wɔn, ‑ye a di kɔ 'hru, 'ke ba ꞊tui, ‑ɛ mɔ, a kuo 'mʋ ye ꞊wlʋ. ");
INSERT INTO ted_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","'A ‑tɩ, 'bɩa 'bʋ yɛɛ 'a mʋ ‑tɩ, ‑tɩ a di ꞊tu, a nɩ ‑hii 'le 'lu ‑wɔn lɛ, 'plɩɩ ‑tɔplɩ a ‑gbɛ 'mʋ 'o nyre. ");
INSERT INTO ted_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","'Na ‑gbɛ, 'mɔ die nu, a 'mʋ ꞊tɔwin po. Nahuin ꞊nʋ, ‑ʋʋ 'a mʋ ‑tɩ yɛɛ, ʋ 'die 'le ‑wɛ bʋ nyra 'a mʋ ye gbo, kɔ, bʋ ꞊tu ‑wɛ 'a mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","'A nɩ bunʋ, 'a nɩ 'diinʋ, 'a nɩ ‑dɩayuo, kɔ 'a nɩ ꞊tugba a nahuin, kɔ 'a nɩ nɩnatumupʋ, ʋ di 'a mʋ kwa po 'blʋgba a ye'mʋnaanyʋ, ʋ 'mʋ ꞊ʋ ‑ye lɛ 'lɩla, 'ke 'le 'a mʋ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nahuin 'bii, ʋ di 'a mʋ 'nɩ yraa, ‑ɛ nue, 'a mʋ mɔ 'na nahuiin nɩ. ");
INSERT INTO ted_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Kɛɛ, dɛ ꞊de 'deɛ bɛ nyre 'o 'a mʋ ‑wɔn, mɔ, a 'deɛ ba 'waan ‑wɛ 'a nɩ 'lu‑pupuu ‑do. ");
INSERT INTO ted_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","A nɩ sɩa 'le. Nɛ‑ die nu, Nyɩsʋa 'mʋ 'a mʋ 'a 'klɔ yrayrʋ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ: «'Bɩa 'ba 'ye Jrusrɛdɩɔ, pʋpʋdakʋ ‑ye a 'sɔyuo 'bʋ ꞊glɔɔ 'le, ‑ye ba yie, ‑ɛ mɔ, ʋ ‑wɛ lɛ kɛ Jrusrɛ a ‑gbɛ a 'wʋwla. ");
INSERT INTO ted_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","'Baa dɛ a ‑gbɛ 'ye, ‑ye nahuin ꞊nʋ, ‑ʋ nɩ 'le Sudeblʋgba 'mʋ, bʋ 'gba ci lɛ, bʋ mu 'le dʋgbɩ 'lu, kɔ, nahuin ꞊nʋ, ‑ʋ nɩ 'le Jrusrɛdɩɔ 'mʋ, ʋ kɔ bʋ hren ‑wɔn, kɔ, nahuin ꞊nʋ, ‑ʋ nɩ 'le 'daklɔ, ʋ nɩ 'di 'le 'dɩɔ 'mʋ, ʋ 'nɩ ꞊hiun lɛ 'lɩla, ");
INSERT INTO ted_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","‑ɛ nue, ‑nyrɔwɔ a ‑gbɛ 'mʋ, Nyɩsʋa di 'a dakʋ ꞊tue ꞊sʋɛ. Kɛ'ɛ nɩ, ‑tɩ 'bii ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyʋ ꞊tu la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɩ di 'lu a ‑wɔnmumue nu. ");
INSERT INTO ted_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ti a ‑gbɛ 'yri, nyrʋ ꞊nʋ, ‑ʋ di 'kwlii 'mʋ lɛ nɩ, kɔ, 'waa dɛ ‑gbo, ‑ɛ di 'yuo 'nya, ɛ di 'ye ꞊sʋɛ 'dɔ, kɔ, dakʋ 'mʋ ‑wɛ ꞊sʋɛ 'ye 'dɔ, kɔ, Nyɩsʋa 'mʋ 'a dakʋ ꞊nʋ yrʋ lɛ poo. ");
INSERT INTO ted_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ʋ di nu ‑hɔtɩplie, ʋ 'mʋ ꞊ʋ ‑ye lɛ 'lɩla, ʋ 'mʋ 'le ꞊ʋ ‑ye dakʋ ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi a 'bri lɛ gbʋgba, ʋ 'mʋ 'le ꞊godɛ nu, dakʋ ꞊nʋ, ‑ʋ 'de Nyɩsʋa yi, ʋ 'mʋ Jrusrɛdɩɔ 'bii ꞊nʋ 'wla, ɛ 'mue gba ‑gbagba, 'waa nɩ ti 'mʋ 'le ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kɛ ‑Yusuu lele po: «꞊Sʋɛ'yeti a ‑gbɛ 'yri, hʋannʋ‑tɔplɩ di ‑wɔn mue 'lu, 'ke 'le 'yrʋ 'yi 'mʋ, kɔ ‑hɔpɔ, kɔ yahroyɔ. Kɛ nɔ ‑tʋtʋ ke, dakʋ di 'mʋ gbo nɩ hʋannʋkɔ, 'ke 'o 'yru kɔ 'a 'dʋɩ 'hɛɛn a ‑cici a ‑ta 'mʋ. Dɛ bʋ di 'lu ‑wɔn lɛ ‑hie, ʋ 'deɛ bʋ yie. ");
INSERT INTO ted_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","‑Tɔplɩ, ‑ɩ di 'lu ‑wɔn mue, kɛ nɔ ‑tʋtʋ ke, nahuin 'bʋ nyi 'lu ‑wɔn lɛ ‑hie, 'a hʋannʋ diu lɛ 'nɩ 'lɩla. ‑Tɔplɩ 'bii, ‑ɩ nɩ 'le yakɔ 'mʋ, ɩ di 'mʋ lɛ ‑hɔn ‑ta. ");
INSERT INTO ted_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tii ‑do a ‑gbɛ 'yri, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, ʋ di 'mʋ 'nɩ 'ye. 'N di 'le 'nɩ di, 'ke 'le 'na 'klɩ a kenɩnɩɛ 'kwli 'mʋ, kɔ 'ke 'le 'na ‑tɩ a 'yi'bʋaalɛ 'kwli 'mʋ. 'Bɩa 'nɩɩ 'le di, 'ke 'n di 'le 'nugbɩ ‑hɛyri nɩ. ");
INSERT INTO ted_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ti ꞊nʋ ‑kɔ 'yri ‑tɔplɩ a ‑gbɛ a nunue di 'o ‑wlu ꞊tuu, ba 'wʋ 'le lɛ, kɔ ba ‑ha 'le 'lu ‑wlu lɛ, ‑ɛ nue, ‑nyrɔwɔ ‑kɔ 'mʋ Nyɩsʋa di 'a mʋ ꞊gbla, ɔ 'mʋɛɛ ye.» ");
INSERT INTO ted_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","'Plɩɩ, ‑Yusu 'ɔ po ꞊nʋ ‑talʋdʋ ye, ɔ nɔ: «Ba 'ye kɛ tugbɛ ꞊nʋ, ʋʋ figietu daa, kɔ ti ‑ye. ");
INSERT INTO ted_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","'Bɩa 'ba nyi 'ye, 'bɩɩ hai yrayrɩɩ ꞊gaa, ‑ye a yie nɩ, ‑ɛ mɔ, ‑cii‑ci‑nyrɛ 'mʋɛɛ ye. ");
INSERT INTO ted_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","‑Tɔplɩ 'bii ‑gbo, ‑ɩ kɔ ‑tɩ 'n ꞊tu wɛn, 'bɩɩ 'lu ‑wɔn mue, ‑ye ba kɔ 'a yiyie, ‑ɛ mɔ, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di nahuin win ke kɔɔ 'bii, ɩ 'mʋɛɛ yrɛ. ");
INSERT INTO ted_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, dakʋ ‑gbo, ʋ 'deɛ bʋ ‑wɛ gbo, ‑tɔplɩ 'bii a ‑gbɛ, ɩ 'mʋ 'o nyre. ");
INSERT INTO ted_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Yakɔ kɔ ‑tʋtʋ 'hɛɛn, ɩ di gbo 'nɩ ‑wɛ, Kɛɛ, 'na wintɛ, ɛ 'deɛ bɛ ‑wɛ gbo gbe.» ");
INSERT INTO ted_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «Ba ꞊tu 'a nɩ dɩɔnʋ 'yie, 'a nɩ 'lu a lɛ‑hielɛ nɩ nɩ 'le 'o lɛ'mimree ‑do ke, kɔ, a nɩ 'na 'le nɔ 'dɔ, kɔ, a nɩ hrɛti 'le, 'ke 'o ‑tɔplɩ ‑gbo ‑wɔn, nahuon blɛ ye bɔ kɔ. ‑Tɔplɩ 'bii a ‑gbɛ, ɩ nye 'nɩ nu, 'a nɩ 'lu a lɛ‑hielɛ 'ɛɛ 'le 'mʋ lɛ bibi. 'Baa ‑tɔplɩ a ‑gbɛ nu, ‑ye ‑nyrɔwɔ ‑kɔ 'mʋ 'n di 'le lele di, ɔ di 'a mʋ 'mʋ gbo 'nɩ ꞊huo, ");
INSERT INTO ted_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","‑ɛ 'we ꞊nɔ ye, ‑tɛ tutuu nu, 'ʋʋ dɛhʋɛ klɩ. ‑Nyrɔwɔ a ‑gbɛ, ɔ kɔ bɔ yɛ 'o nahuin 'bii gbo, ‑ʋ nɩ nɔ ‑tʋtʋ ke. ");
INSERT INTO ted_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ba nɩ 'o ‑preelɛ 'mʋ, a nɩ ŋmo 'le, ba 'cipi 'o Nyɩsʋa a dɩda, ‑ɛ die nu, ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ di 'o nyre, a 'mui 'le wlɔn ꞊tɩɔ 'bɛɛ, 'plɩɩ, 'bɩa 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'nɩ di 'le, a 'nɩ ꞊han hʋannʋ pɩ.» Kɛ ‑Yusuu nahuin ye po. ");
INSERT INTO ted_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","‑Nyrɛ 'mʋ, 'ke ‑Yusuu 'le Nyɩsʋa a 'kagblaka gbo tɔɔ. 'Tɔ 'bɔ ‑wɔn, ‑ye ɔɔ 'mʋ ꞊tɩ 'dɩɔ, 'ɔɔ 'le dʋgba ꞊nʋ 'lu mu pɛɛ, ‑ɔ kɔ 'lu olifieti nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","‑Nyrɛ 'bɛ cɛ lɛ, nahuin 'bii ke ‑wɛ ti, 'ke 'le Nyɩsʋa a 'kagblaka gbo, ʋ 'mʋ 'a win 'wɔn. ");
INSERT INTO ted_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Juukʋɛ a lɛ'mimre gblaka, ɛɛ 'o mu 'nɩ nyre. Lɛ'mimre a ‑gbɛ, 'a 'dʋ mɔ Pakɩ. Pakɩ a ‑gbɛ a ti 'yri, 'flɔɔdʋ ꞊nʋ, ‑ɔ kɔ ‑wɔn ʋ 'nɩnɩ po 'le 'yaadɛ, nɔ‑ ʋʋ la di. ‑Tɛ ‑nyrɔwɔdʋ a ‑gbɛ, ɔɔ yrɛ 'mʋɛɛ, ");
INSERT INTO ted_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ teteitɔɔnyʋ 'hɛɛn, ʋʋ lɛ ꞊mɔ ‑Yusu a 'lɩla. Kɛɛ, ʋʋ pɩ nahuin a hʋannʋ. Ɛ nɛ‑ nue, 'ʋʋ ꞊tɔ lɛ ꞊mɔ, ‑tɛ ʋ di 'a 'lɩla nu. ");
INSERT INTO ted_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","'Ke 'le ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ ‑gbahlɔn, ɛ kɔ la ‑naagbopʋyu ‑ye. 'A 'dʋ mɔ Judɩa. 'A kegbohraadʋ mɔ Yisikalio. Nɔ‑ kɔ ke 'mʋ 'kuo ‑hʋɩn a nyɩgblaka, ‑ɔ mɔ Satan, ɔ bi 'o, ");
INSERT INTO ted_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judɩa a ‑gbɛ 'ɔ 'ba ye 'mʋ, 'ɔ mu 'le ‑cɔhlʋnpinyʋ gblakɩ ‑wɔn, kɔ Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ gblakɩ 'hɛɛn, 'ɔ mu 'ye wɔn, ‑tɛ ɔ di ꞊nʋ ‑Yusu a kwapupue nu. ");
INSERT INTO ted_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","'Plɩɩ ʋ 'mui 'mʋ lɛ mu pupo, ‑ye 'waa plɔ ble nɩ. ‑Ye ʋ pue 'le ꞊le, ‑ɛ mɔ, ʋ di ꞊nɔ ‑nye 'wliyɛ, 'bɩa ‑tɔplɩ 'bii a ‑gbɛ 'bɩ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","‑Ye Judɩa wɛɛn ke. Kʋɛ 'o ti a ‑gbɛ 'yie 'mʋ gbo, ɔɔ lɛ ꞊mɔ ꞊hapʋ꞊tɔ, ‑tɛ ɔ di nu, ɔ 'mʋ ꞊nʋ ‑Yusu kwa po, 'ke nahuin ꞊nʋ, ʋ 'nɩnɩ die 'o dɛ ꞊de 'hʋɩn 'mʋ yi. ");
INSERT INTO ted_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lɛ'mimre ꞊nʋ, ‑ɛ mɔ Pakɩ, 'a ye‑hɛ‑nyrɔwɔ 'mʋ, 'ke ʋʋ 'o 'flɔɔdʋ ꞊nʋ dii, ‑ɔ kɔ ‑wɔn ʋ 'nɩnɩ po 'le 'yaadɛ, kɔ, 'ʋʋ ‑wɛ 'o 'blayuo ‑tutui 'laa, 'ke 'o dididɛ gblaka a ‑ta 'mʋ. ‑Tɛ ‑nyrɔwɔ a ‑gbɛ, ɔ nyre 'o, ");
INSERT INTO ted_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","‑ye ‑Yusu, ɔɔ Piɛlɩ kɔ Saan 'hɛɛn 'nɩ le, ɔ nɔ: «Ba mu Pakɩ a dididɛ ‑wɔn ‑wɔ.» ");
INSERT INTO ted_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","‑Ye ʋ ꞊gbɔ wlɔn: «‑Be' ‑nɩɩ ‑hʋa ‑ba pii 'klɛɛ dididɛ a ‑gbɛ ye 'le?» ");
INSERT INTO ted_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","‑Ye ɔ ꞊tu ꞊wɔn, ɔ nɔ: «Ba po 'o nʋa gbo: Ba mu 'le Jrusrɛdɩɔ 'mʋ. A kɔ nyɩbɛyu ‑ye 'hɛɛn, 'a mʋ di ꞊ŋmoo. Nahuon a ‑gbɛ, ɔ 'ble 'nɩya. Kayu ‑kɔ gbo ɔ di 'le pa, 'ke ba pa 'le. ");
INSERT INTO ted_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Ba le kayu a ‑gbɛ a kʋkɔnyɔ, a nɔ: ‑A nɩ tɔɔnyɔɔ wlɔn 'nɩ ꞊gba: ‑Be' ‑gblo nɩ ye, ‑ɔ kɔ 'mʋ ɔ di 'le Pakɩ a dididɛ 'le dii, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn? ");
INSERT INTO ted_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","‑Ye ɔ di 'a mʋ tɔɔ ‑gblo gblaka, 'ke 'le yrayrɩkayu a ‑gbɛ a ye‑hɛ‑gbɔ 'mʋ. 'Ke kayu a ‑tɔplɩ 'bii ꞊cɛɛ 'le. 'Kee nɩ, ba pii 'le dididɛ a ‑gbɛ!» ");
INSERT INTO ted_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","‑Tɛ ʋ mu, ʋ nyre 'le, 'ɛ mɔ ‑tɛɛ, ‑tɛ ‑Yusu nu 'a ꞊tutue, kɛ'ɛ nɩ, ʋ nu 'o ‑tɔplɩ a ‑gbɛ a 'ogboyɩyɛ. ‑Ye ʋ pi Pakɩ a dididɛ a ‑gbɛ nɩ. ‑Tɛ ʋ ‑wɔ 'a pipie ‑wɔn, ‑ye ʋ ‑mɛ de. ");
INSERT INTO ted_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","‑Wise, ‑tɛ dɛditi nyre 'o, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ 'kukue lɛ, ʋ 'mʋ dɛ di. ");
INSERT INTO ted_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «'Na ꞊wlʋ nye o lɛ 'nɩ ꞊mɔ 'dɔ, 'ke a kɔ 'mʋ 'hɛɛn ‑ba di Pakɩ a dididɛ ‑gbo, 'plɩɩ ɛ 'mʋ 'na ꞊sʋɛ a 'yiye a ti ke yɛ. ");
INSERT INTO ted_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kɛɛ ꞊be 'nɩɩ 'a mʋ 'nɩ le: 'N 'deɛ ꞊bo di lele dididɛdʋ ‑gbo, ɛ 'mʋ ‑hlɩn ti ꞊nʋ ke yɛ, ‑ɩ kɔ 'yri Nyɩsʋa di ‑tado 'a dakʋ a waalɛ ‑wɔn ‑wɔ, 'ke 'le 'a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Bɔ po 'klɛɛ lɛ, ‑ye ɔ 'ba 'mʋ ‑wiin‑gaʋwɔ, 'ɔ po Nyɩsʋa a 'wio gbo, ɔ nɔ: «Ba klɩ ‑wiin‑gaʋwɔ ‑gbo gbo, a 'muo ‑hie. ");
INSERT INTO ted_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","'Nɩɩ 'a mʋ 'nɩ le: Kʋɛ 'klɛɛ mɔ gbo, 'n 'deɛ ꞊bo 'na lele nɔdʋ ‑gbo, ɛ 'mʋ ‑hlɩn ti ꞊nʋ ke yɛ, ‑ɩ kɔ 'yri Nyɩsʋa di ‑tado 'a dakʋ a waalɛ ‑wɔn ‑wɔ,» ");
INSERT INTO ted_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","'plɩɩ, 'ɔ 'ba 'flɔɔ 'mʋ, 'ɔ po Nyɩsʋa a 'wio gbo, 'ɔ 'bɛ 'flɔɔ a ‑gbɛ ꞊tɩɔ lɛ, 'ɔ ‑nyo 'a ‑naagbopʋ lɛ. ‑Ye kɛ ɔɔ po: «'Flɔɔ ‑gbo, nɔ‑ mɔ 'na 'hʋɩn, 'n di ‑ha, 'ke 'o 'a nɩ ‑ta 'mʋ. Kʋɛ 'klɛɛ mɔ gbo, 'flɔɔ꞊tɩɔlɛ'bɛdɛ a ‑gbɛ, kɔ 'a didie 'hɛɛn, nɛ‑ ba gba 'lu ‑wɔn, ‑ɛ die nu, a 'mʋ 'na ‑tɩ 'lu ‑wɔn lɛ ‑hie 'ɛ nɩ ti.» ");
INSERT INTO ted_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","‑Tɛ ʋ ‑wɔ dɛ lɛ, ‑ye ɔ 'ba 'mʋ ‑wiin‑gaʋwɔ, 'ɔ po Nyɩsʋa a 'wio gbo, 'ɔ ‑nyo 'a ‑naagbopʋ, ʋ 'muo ‑hie. ‑Ye kɛ ɔɔ po: «‑Wiin ‑gbo, ɩ ꞊hɛn 'nyrɛ Nyɩsʋa a 'yrɩ yrayrɩ a ꞊tuelɛ. Nyɩsʋa a ‑gbɛ, ɔ di nu 'na dablo, ɔ 'mʋ 'yrɩ yrayrɩ a ‑gbɛ ꞊tue, ɔ kɔ 'a mʋ 'hɛɛn. 'Na dablo a ‑gbɛ, 'n dio gbo 'nɩ 'wla, 'ke 'o 'a nɩ ‑ta 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‑Ye kɛ ɔɔ lele po: «Ba po 'o nʋa gbo ‑tɛɛ: Nahuon ꞊de nɩ mɔ dɛdi‑tuo ‑gbo ke. Nɔ‑ di 'mʋ 'na yraanyʋ kwa po, ‑ʋʋ 'na 'lɩla lɛ ꞊mɔ. ");
INSERT INTO ted_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","'Ɛ mɔ ‑tɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'n kɔ ꞊bo 'kʋ, ‑tɛ Nyɩsʋa nu 'a ‑hʋhʋa. Kɛɛ, 'jrɔ 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ di 'mʋ 'na yraanyʋ a ‑gbɛ kwa po.» ");
INSERT INTO ted_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","‑Tɛ ‑Yusu ‑yrɛ, ‑ye 'a ‑naagbopʋ, ʋ ‑tʋa wlɔnlɛ꞊gbʋgbalɛ gbo, ‑ye kɛ ʋʋ po: «Nahuon tio‑, ‑ɔ nɩ nɔ ‑a mʋ 'nyɩ 'mʋ, ‑ɔ dio 'a yraanyʋ kwa po.» ");
INSERT INTO ted_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑naagbopʋ ‑tʋa wlɔnlɛ꞊gbʋgbalɛ gbo, 'ke 'le gblɛ a pupue 'kwli 'mʋ, ‑ɛ mɔ, nahuon tio‑, 'ke 'le ꞊nʋ ‑gbahlɔn, nahuin di lɛ po, nɔ‑ nɩ 'o 'a 'bienʋ 'lu ye. ");
INSERT INTO ted_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Bʋʋ lɛ 'pʋprɛ nu, ‑ye ‑Yusu le ꞊nʋ nɩ, ɔ nɔ: «Kɛ nɔ ‑tʋtʋ ‑gbo ke, 'kɩɩnpʋ kɔ bodɩɔpʋ 'hɛɛn, ʋ nye 'waa nahuin 'nɩ tɔɔ, ‑ɛ mɔ, ʋ nɩ ke 'klɩ, 'plɩɩ, 'ʋ nye ‑hʋa, 'ke nahuin a ‑gbɛ, bʋ ꞊tui, ‑ɛ mɔ 'waa ye'mʋnaanyʋ a ‑gbɛ, ʋʋ nahuin 'yi ꞊hlɔn lɛ nu ꞊hapʋdɛ. ");
INSERT INTO ted_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kɛɛ, 'ke 'o 'a mʋ ‑wɔn, ɛ 'de ye blɛ bɛ nɩ lɛ 'mʋ. Nahuon ꞊nʋ, ‑ɔ mɔ nyɩgblaka, ɔ blɛ ye bɔ 'ya 'a nɩ 'mʋ‑hɛnyɔ 'mʋ, 'plɩɩ, nahuon ꞊nʋ, ‑ɔ kɔ 'a mʋ win ke, ɔ blɛ ye bɔ 'we ꞊nɔ nahuon ꞊nʋ ye, ‑ɔɔ 'o 'a 'mʋ ꞊tuu. ");
INSERT INTO ted_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","꞊Bo pue dɛ ye: Nahuon ꞊nʋ, ‑ɔ nɩ 'o dɛdihuo ke, kɔ nahuon ꞊nʋ, ‑ɔ mɔ 'mʋ‑hɛnyɔ, ‑ɔɔ didi‑tɔplɩ ‑hie, nyɔ‑ nɩ 'o 'a 'be 'lu ye 'le? ꞊Be ɛ 'de nahuon ꞊nʋ, ‑ɔ nɩ 'o dɛdihuo ke? Kɛ'ɛ nɩ, ɛ nɩ 'mʋ, 'ke 'le ‑tʋnahuin ‑hɛyri. Kɛɛ, 'mɛ ‑ye, kɛ nɔ 'a mʋ ‑hɛyri, 'n 'we ꞊nɔ 'mʋ‑hɛnyɔ ye. ");
INSERT INTO ted_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‑Tɛ ʋʋ o 'mʋ lɛ ꞊tɔ, a 'de o 'mʋ gbo hie, kɛɛ, a 'cipi o 'o 'mʋ 'hʋɩn 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Nɛ‑ nue, 'nɩɩ 'a mʋ le, ti ꞊nʋ ‑kɔ 'yri 'n di nahuin win ke kɔɔ, 'n di 'a mʋ ‑nyi 'klɩ, a kɔ 'mʋ 'hɛɛn, ‑a 'mʋ ‑kʋan a ‑gbɛ nu, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'n Bu Nyɩsʋa nu, 'ɔ ‑nyi 'mʋ 'klɩ, 'ke ɔ kɔ 'mʋ 'hɛɛn, ‑ba kɔɔ nahuin win ke. ");
INSERT INTO ted_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","'Nɩ di ‑tado nahuin win ke kɔɔ, 'ke a di 'o ‑tɛgbii ‑do dɛ dii, a kɔ 'mʋ 'hɛɛn, kɔ, 'ke a di 'o ‑batipogbatɩ ke gblɛ nɩ, a 'mʋ Yisraɛkʋɛ a ꞊tugbɩɩ ‑pu ꞊tu 'o 'hɔn ꞊nʋ ‑bati lɛ poo.» ");
INSERT INTO ted_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","‑Ye ‑Yusu, ɔɔ 'le Simɔ Piɛlɩ ‑wɔn 'nɩ 'prɛɛ, ɔ nɔ: «Simɔ o, po 'mʋ nʋa ye gbo. Satan, ‑ɔ mɔ 'kuo ‑hʋɩn a nyɩgblaka, nɔ‑ ‑hʋa Nyɩsʋa 'klɩ, 'ke bɔ ꞊tɔ 'a mʋ 'mʋ lɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ nyrʋgbaa nu, 'ɔɔ ꞊gbla 'mʋ lɛ ꞊hloon, 'ɔɔ 'le ‑pupui 'le ‑ha, ꞊hapʋgbla 'ɔɔ 'le ‑ŋmahɛn wlɔn hie. ");
INSERT INTO ted_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kɛɛ, 'mɔ ‑gbo, 'n 'batɩ Nyɩsʋa lɛ, 'ke 'o ‑na ‑ta 'mʋ, 'ke ‑bo 'cipi 'o 'na ꞊wlʋ a yekuolɛ. Ti ꞊nʋ ‑kɔ 'yri ‑n die yrii, ‑ɛ mɔ, ‑n nu 'yilɛnyredɛ, ‑ye ‑bo ‑nyi ‑n ‑dɩayuo 'klɩ, 'ke bʋ kuo 'mʋ ꞊wlʋ ye.» ");
INSERT INTO ted_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","‑Ye kɛ Simɔ Piɛlɩ, ɔɔ ꞊nɔ ye po: «Kʋkɔnyɔ, 'bɩa 'bʋ po ‑mʋ ꞊jɩ 'mʋ, 'n nye 'nɩ ‑hʋa, bʋ po ‑wɛ 'mʋ ꞊jɩ 'mʋ. Mɔ, 'bɩa 'bʋ 'la ‑mʋ, 'na ‑gbɛ, 'n nye ‑wɛ 'nɩ ‑hʋa, bʋ 'la ‑wɛ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","‑Ye kɛ ‑Yusu nyo ye po, ɔ nɔ: «Piɛlɩ, 'nɩɩ ‑mʋ 'nɩ le: 'Ke 'le 'tɔyrʋwɔɔ ‑do ‑gbo 'kwli 'mʋ, hapɛbɩʋ 'deɛ bʋ da ‑nyrɛ, ꞊mʋ kɛ 'na ‑wɔn‑gaawɩɩ ta nu, ꞊mʋ kɛ lɛ po, ‑n 'de 'mʋ yi.» ");
INSERT INTO ted_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","‑Ye kɛ ‑Yusuu lele ꞊nʋ ye po, ɔ nɔ: «'N le o 'a mʋ nɩ, 'ke ba na o 'dɩɛ 'mʋ lɛ, ba pue o nahuin 'na ꞊hapʋtitie, 'nɩ le o 'a mʋ, 'baa o mu, a nɩ gba 'le o 'wliyɛ, kɔ blɔ, kɔ 'suei 'hɛɛn. ‑Tɛ a 'de o ‑tɔplɩ a ‑gbɛ gba, ꞊be dɛ ꞊de nɩ 'o, aa o ‑hʋa, a 'de o kɔ?» ‑Ye ʋ nɔ: «'Ʋʋn, ɛ 'de o dɛ ꞊de kɔ, ‑aa o ‑hʋa, ‑a 'de o kɔ.» ");
INSERT INTO ted_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","‑Ye kɛ ɔɔ lele po: «Kɛɛ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, ɛ 'de lɛ 'mʋ nɩ. Nahuon 'bɔ kɔ 'wliyɛ, 'bɔ kɔ blɔ, bɔ 'bʋɩ 'mʋ. Kɔ, nahuon 'bɔ 'de ‑hɔtɩplie kɔ, bɔ plo 'a wlawlʋ ‑ye, ɔ 'mʋ ‑hɔtɩplie ‑tɔ. ");
INSERT INTO ted_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","'Ɛ mɔ ‑tɛɛ, 'nɩɩ 'a mʋ 'nɩ le, ‑tɩ ꞊nʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɩ kɔ bɩ mue 'lu ‑wɔn, 'ke 'o 'mʋ ‑wɔn. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: 'Ke ʋ ‑hroo 'le 'crɛnyʋ ‑hɛyri. 'Ɛ mɔ ‑tɛɛ, ‑tɩ a ‑gbɛ, ʋ 'crɩɩ la, 'ke 'o 'mʋ ke, ɩ ‑wɛ lɛ kɛ 'onyinyre.» ");
INSERT INTO ted_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","‑Ye ʋ nɔ: «Kʋkɔnyɔ, 'ye kɛ, ‑a kɔ ‑hɔtɩplieii 'hɔn.» ‑Ye ɔ nɔ: «Ɩ nu ‑tɛɛ.» ");
INSERT INTO ted_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ ꞊tɩ 'mʋ 'dɩɔ, 'ʋ mu 'le dʋgba ꞊nʋ 'lu, ‑ɔ kɔ 'lu ti nɩ 'le, ʋʋ olifie daa. 'Ke ‑Yusu 'cipi 'le. ");
INSERT INTO ted_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","‑Tɛ ʋ nyre 'o ‑tuo a ‑gbɛ ke, ‑ye kɛ ɔɔ po: «Ba da Nyɩsʋa, ‑ɛ die nu, 'kuo ‑hʋɩn a nyɩgblaka, 'bɔɔ 'a mʋ 'mʋ lɛ ꞊tɔ, a 'nɩ ꞊han dɛ 'kuku nu.» ");
INSERT INTO ted_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Bɔ po 'klɛɛ lɛ, ‑ye ɔ ‑hɔn 'o ꞊nʋ 'mʋ 'hʋɩn, 'ɔ 'yɩya 'o ye 'mʋ gbo dɛ gbi. ‑Ye ɔ bla gbo kwlɩ, 'ɔ ‑tʋa Nyɩsʋa a dɩda gbo, ");
INSERT INTO ted_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ɔ nɔ: «'Na Bu, 'bɩa ꞊nɩ nye ‑hʋa, ‑ye ‑bo hren 'mʋ ꞊sʋɛ ‑gbo ‑wɔn, 'n kɔ ꞊bo 'ye. Kɛɛ, bɛ 'ya ‑na kewɛɛnlɛ 'mʋ, bɛ nue, ɛ nɩ 'ya 'le 'na kewɛɛnlɛ 'mʋ.»  ");
INSERT INTO ted_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","‑Ye Nyɩsʋa a lɛleenyɔ 'hrɩɩ ꞊nɔ ye, 'ɔ ‑nye ꞊nɔ 'klɩ. ");
INSERT INTO ted_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye hʋannʋ bio 'le 'kwli 'mʋ, 'ɔɔ 'o lele 'klɩ ꞊tu, 'ɔɔ Nyɩsʋa da. Hinhiun ‑gbo, ‑ʋʋ 'le ꞊nɔ 'mʋ ble, ʋ 'we ꞊nɔ dablo a tapʋɩ ye. ");
INSERT INTO ted_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","‑Tɛ ɔ da 'klɛɛ Nyɩsʋa, ‑ye ɔ 'ba 'mʋ ye, 'ɔ mu 'o 'a ‑naagbopʋ 'hʋɩn 'mʋ. ‑Tɛ ɔ nyru 'o 'hʋɩn 'mʋ, ‑ye ʋʋ 'nɩ ŋmo, 'kla‑wliye'yɩya a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","‑Ye kɛ ɔɔ ꞊nʋ ye po: «Dɛ‑ kɔ ŋmla aa ŋmo 'le? Ba 'ba ye 'mʋ, ba da Nyɩsʋa, ‑ɛ die nu, 'kuo ‑hʋɩn a nyɩgblaka 'bɔɔ 'a mʋ 'mʋ lɛ ꞊tɔ, a 'nɩ ꞊han dɛ 'kuku nu.» ");
INSERT INTO ted_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Win nɩ 'le ‑Yusu wlɔn, nahuin ‑huohui 'ʋ waan 'le ye. ‑Ye Judɩa, ‑ɔ mɔ ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn a nahuon ‑ye, nɔ‑ po nahuin ‑huohui a ‑gbɛ ye 'mʋ. ‑Ye ɔ 'yɩya 'o ‑Yusu 'mʋ gbo 'hʋɩn, 'ɔ 'wlɔɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","‑Ye kɛ ‑Yusu nyo ye po: «Judɩa, ꞊be 'ke 'le 'na 'mʋ'wlɛɛlɛ 'kwli 'mʋ, 'ke ‑n ‑hʋa ‑bo naa 'le, ‑bo po 'mʋ 'na yraanyʋ kwa, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon?» ");
INSERT INTO ted_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","‑Yusu a ‑naagbopʋ, ‑ʋ nɩ 'o ‑Yusu 'hʋɩn 'mʋ, ʋ yrii dɛ ꞊nʋ nɩ, ‑ɛɛ 'o mu nyre, 'ʋ ꞊gbɔ wlɔn, ʋ nɔ: «Kʋkɔnyɔ, ꞊be ‑ba nu ‑hɔtɩpliei, ‑ba ‑wʋnwɔn ye?» ");
INSERT INTO ted_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","'Ke Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑kʋannunyɔ nɩ ‑wɛ 'o ‑tuo a ‑gbɛ ke. ‑Ye 'klɛɛ, ‑Yusu a ‑naagbopʋyu ‑ye, nɔ‑ nu 'a ‑hɔtɩplie, 'ɔ 'bɛ 'o ‑kʋannunyɔ a ‑gbɛ a diidɛnʋa 'o. ");
INSERT INTO ted_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","‑Ye ‑Yusuu wun 'nɩ po, ɔ nɔ: «Ɛ ‑wɛ ‑wɔn,» 'ɔ 'tʋ nyɩbɛyu a ‑gbɛ a nʋa lɛ, 'ɔ ‑wɔ 'a nʋa a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","‑Tɛ ɔ ‑wɔ 'klɛɛ 'a nʋa, ‑ye ɔ ꞊hɩan ‑wɔn, 'ɔɔ 'le nahuin ꞊nʋ ‑wɔn 'prɛɛ, ‑ʋ mɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ gblakɩ, kɔ ‑Juukʋɛ a 'blʋ a nahuin, ‑ʋ dio klɩ wɔn. Kɛ ɔɔ po: «A 'ble kwa lɛ ‑hɔtɩpliei kɔ ti 'hɛɛn, 'a di 'mʋ klɩ wɔn, ‑ɛ 'we ꞊nɔ nyɔ mu 'yrinyɔ klɩ wɔn. ");
INSERT INTO ted_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","'Plɩɩ ‑ye ti a pɛpɛ, 'ke a kɔ 'mʋ 'hɛɛn, ‑a nɩ o 'le Nyɩsʋa a 'kagblaka gbo, 'ke a 'de o 'na kikle lɛ ꞊mɔ. Kɛɛ ꞊be ti ꞊nʋ, Nyɩsʋa ‑nye 'a mʋ, a kɔ 'kuo ‑hʋɩn a nyɩgblaka 'hɛɛn, ‑ɔ mɔ gbɩgbɩyrɩ a nyɩgblaka, ti a ‑gbɛ, nɩ‑ nyre 'o. Nɛ‑ nue, 'a kɔ 'klɩ, 'ke ba nu 'a nɩ ‑kʋan.» ");
INSERT INTO ted_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","'Plɩɩ ‑Yusu 'mʋ 'pʋprɛ ‑wɔn mu ‑wɔ, ‑ye ʋ klo nɩ, 'ʋ gbɔ 'le ‑cɔhlʋnpinyʋ a nyɩgblaka a kayu gbo. Piɛlɩ ‑mɛ ‑ye, ɔ nyu ‑wɔn 'nɩ kʋɛ, 'ke 'le 'waa ‑wɔnhinhrenkɔ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","'Ke 'o ‑patʋ 'mʋ, 'ke ʋ 'tie 'o na, 'ʋ ꞊glɔɔ 'le lɛ. Nahuin ꞊nʋ, ‑ʋ ꞊glaa 'le na a ‑gbɛ lɛ, nʋ‑ kɔ ‑hɛyri Piɛlɩ nɩ 'le gbo. ");
INSERT INTO ted_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","'Ke ɔ nɩ 'o ‑gbo, ‑ye ‑kʋannunyrɔyu ꞊de, ɔ 'yo nɩ, 'ɔ ‑tʋa 'a 'yie a 'mʋ‑hrʋʋlɛ gbo, ‑ye kɛ ɔɔ po: «Nahuon ‑gbo, ɔ mɔ ‑wɛ ‑Yusu a ‑naagbopʋyuu nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kɛɛ ‑ye Piɛlɩ ‑ga nɩ, ɔ nɔ: «Nyrʋgba o, 'n 'dio yi mɔ.» ");
INSERT INTO ted_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Bɛ ‑hi 'klɛɛ, ‑ye nyɩbɛyu ‑ye 'ye Piɛlɩ nɩ. Kɛ ɔ nyo ye po: «‑Na ‑gbɛ ‑gbo, 'ke ‑n nɩ o 'le 'a nahuin ꞊nʋ ‑hɛyri.» ‑Ye Piɛlɩ nɔ: «Nyɩbɛyu o, ɛ 'de 'mɔ mɔ.» ");
INSERT INTO ted_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","‑Haawɔɔ ‑do bɔ ‑hi, ‑ye nyɩbɛyu ‑ye nɩ 'o. Kɛ ɔɔ ꞊nɔ ye po, 'ke 'le win 'yaklɩkɔ 'kwli 'mʋ: «꞊Hapʋkɔɔ nɩ, nyɩbɛhɩan ‑gbo, ɔ mɔ ‑wɛ ‑Yusu a ‑naagbopʋyuu nɩ, ‑ɛ nue, ʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ mɔ Galilekʋɛ'ɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","‑Ye kɛ Piɛlɩɩ nyɩbɛyu a ‑gbɛ ye po, ɔ nɔ: «Nyɩbɛyu o, ‑tɩ ‑gbo ‑nɩɩ ꞊tu, 'nɩ yrii ꞊le 'mʋ lɛ.» Ɔ nɩ 'le 'pʋprɛ 'kwli 'mʋ, ‑ye hapɛ da ‑nyrɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hapɛ bɛ da 'klɛɛ ‑nyrɛ, ‑ye Kʋkɔnyɔ ‑Yusu ꞊hɩan ‑wɔn, 'ɔɔ Piɛlɩ 'ye. Tii ‑do a ti 'yri, ‑ye ‑tɩ ꞊nʋ, Kʋkɔnyɔ ꞊tu wɛn ꞊nɔ ye, ‑ɛ mɔ: «'Plɩɩ hapɛ 'mʋ kɛ ‑nyrɛ mu da le, ‑n di kɛ nu 'na ‑wɔn‑gaawɩɩ ta, ‑ɛ mɔ, ‑n 'de 'mʋ yi ‑o,» ‑ye ‑tɩ a ‑gbɛ, ɩ bi 'le ꞊nɔ 'mʋ 'kwli. ");
INSERT INTO ted_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","‑Ye ɔ 'hrɩ 'le ‑yaa 'mʋ nɩ, 'ɔ ‑tʋa wuwe gbo, 'kla‑wliye'yɩya a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","64","‑Ye nahuin ꞊nʋ, ‑ʋʋ ‑Yusu 'yie ꞊tu, ʋ nyo 'nɩ 'caa, 'ʋ mʋɔ dapɩa 'yi klɛ, 'plɩɩ 'ʋ nyo bi. 'Ke 'le 'a bibie 'kwli 'mʋ, ‑ye ʋ nyo wlɔn 'nɩ ꞊gba, ʋ nɔ: «Nyɩsʋa a winwlɔn‑hɛnyɔ o, le ‑a mʋ, nahuon tio‑ ꞊tu ‑mʋ dɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ʋ 'mʋ mu ‑yrɛ, ‑ye ʋ 'ŋmlɛ lele ꞊nɔ 'dai tanɩ. ");
INSERT INTO ted_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ‑Juukʋɛ a 'blʋ a nahuin, kɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ teteitɔɔnyʋ 'hɛɛn, ʋ 'kukue lɛ, 'ke 'o ‑Yusu a ‑bati a ‑ta 'mʋ. ‑Ye ʋ le 'waa 'mʋ‑hɛnyʋ, 'ke bʋ ya ‑Yusu 'waa ‑gboligbo gblaka ye. ");
INSERT INTO ted_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","‑Tɛ ʋ yɔ ꞊nʋ ye, ‑ye ʋ ꞊gbɔ wlɔn, ʋ nɔ: «꞊Be ‑mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, 'ke 'o 'a dakʋ a waalɛ a ‑ta 'mʋ? 'Bɛ 'ya ‑mɔ 'mʋ, le ‑a mʋ!» ‑Ye kɛ ɔɔ ꞊nʋ ye po: «'Bɩa 'nɩ plɛ: Iin, 'mɔɔ nɩ, a 'nɩ pui ꞊le ‑tɛɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","'Plɩɩ, 'nɩ ꞊gba 'a mʋ dɛ wlɔn, a 'nɩ ‑hɩhɩa ꞊le 'mʋ klɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kɛɛ, kʋɛ 'klɛɛ mɔ gbo, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'ke 'n di 'o 'Klɩkenɩnyɩsʋa a diidɛpɩa ke gbo nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","‑Ye ʋ 'bii, ʋ nɔ: «꞊Be ‑mɔ mɔ 'klɛɛ Nyɩsʋa a 'Yuu nɩ?» ‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «'Ɛ mɔ ‑tɛɛ, 'mɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","‑Ye ʋ nɔ: «‑A 'nɩ ‑hʋa ꞊le 'klɛɛ lele ‑hɛhɩnyʋ ‑ye. ‑A nɩ ‑gbɛ, ‑a 'wɔn 'a ‑gbɛ a win nɩ. ‑Tɛ ɔ plɛ, ɔ mɔ Nyɩsʋa a 'Yuu nɩ, ɔ poo Nyɩsʋa lɛ tanɩ. 'A ‑tɩ 'klɛɛ o, ɔ nɩ 'mʋ 'kʋkʋɛ.» ");
INSERT INTO ted_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Bʋ ‑yrɛ 'klɛɛ, ‑ye ʋ 'ba 'mʋ ye, 'ʋ gbɔ 'le Romakʋɛ a ‑gʋlʋnʋma ‑wɔn. 'A 'dʋ mɔ Pilatɩ. (Romakʋɛ, nʋ‑ kɔɔ ‑Juukʋɛ win ke. ‑Juukʋɛ, ʋ 'die 'le ‑wɛ bʋ 'la nahuon ꞊de, 'bɩa Romakʋɛ 'bʋ 'die ke wɛɛn. Nɛ‑ nue, ‑Juukʋɛ 'ʋ gba 'le ‑Yusu Pilatɩ ‑wɔn,) ");
INSERT INTO ted_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","'ʋ ‑tʋa 'a ‑tɩ a yɛɛlɛ gbo, ʋ nɔ: «‑A 'nɛɛ nahuon ‑gbo ke gbo 'yie, ‑ɛ mɔ, nɔ‑ɔ ‑a nɩ 'blʋgba yra 'mʋ bla. Nɔ‑ɔ nahuin le, ‑ɛ mɔ, ‑a 'nɩ 'pɛɛ 'le 'blʋwli ꞊nʋ, Romakʋɛ a 'kɩɩn gblaka plɛ, ‑ba 'pɛɛ. 'Ya 'o lele 'lu, 'ɔɔ lɛ po, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, ɛ ꞊hɛn 'nyrɛ, ɔ nɔ 'nɩ, ɔ mɔ bodɩɔ ‑yee nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","‑Ye Pilatɩ nyo wlɔn 'nɩ ꞊gba, ɔ nɔ: «꞊Be ‑mɔ mɔ ‑Juukʋɛ a bodɩɔ?» ‑Ye kɛ ‑Yusuu po: «Iin, nɛ‑ɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","‑Ye Pilatɩ, ɔɔ 'le Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ ꞊nʋ kɔ nahuin ‑huohui ꞊nʋ 'hɛɛn ‑wɔn 'nɩ 'prɛɛ, ɔ nɔ: «'Nɩ 'yee ꞊le 'le nahuon ‑gbo dɛ 'klan ꞊de 'mʋ, bɔ nu.» ");
INSERT INTO ted_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","‑Ye ʋ 'de Pilatɩ ke wɛɛn, 'ʋʋ 'le win 'yaa, ʋ nɔ: «Nahuon ‑gbo, 'a tɔɔwin ꞊gbʋgblɔ 'blʋgba 'bii nɩ, kʋɛ 'le Galileblʋgba 'mʋ gbo, ‑bo nyre nɔ Jrusrɛdɩɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","‑Tɛ Pilatɩ 'wɔn 'waa win a ‑gbɛ, ‑ye ɔɔ wlɔn 'nɩ ꞊gba, ɔ nɔ: «꞊Be nahuon ‑gbo, ɔ mɔ Galilekʋɛyu'u nɩ?» ");
INSERT INTO ted_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","‑Ye ʋ nɔ: «Iin.» ‑Ye 'klɛɛ, 'kɩɩn ‑gbo, ‑ɔ mɔ Helɔdɩ, nɔ‑ kɔɔ Galileblʋgba win ke. ‑Tɛ Pilatɩ 'wɩn 'klɛɛ, ‑ɛ mɔ, 'ke ‑Yusu ‑hɔn 'le Galileblʋgba 'mʋ, 'kɩɩn Helɔdɩ a ‑gbɛ, ɔ kɔɔ win ke, ‑ye ɔ le 'a nahuin nɩ, 'ke bʋ gbɔ 'le ꞊nɔ ye. Ti a ‑gbɛ 'yri, 'ke 'kɩɩn Helɔdɩ a ‑gbɛ, ɔ nɩ 'le Jrusrɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","‑Tɛ Helɔdɩ 'ye ‑Yusu, ‑ye ɔ kɔ plɔ a bleelɛ, ‑ɛ nue, ɔɔ 'a 'dʋ lɛ 'nɩ 'wɔn, si la, 'ɔɔ ‑wɛ 'a 'yiye lɛ ꞊mɔ, 'plɩɩ ɔ 'mʋ ‑wɛ 'ŋmilɛkadɛ 'ye, ‑Yusu di nu. ");
INSERT INTO ted_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","‑Yusu bɔ nɩ 'o ꞊nɔ ye, ‑ye ɔ ꞊gbɔ wlɔn lɛ 'dai ‑tɔplɩ. Kɛɛ, ‑Yusu 'de ꞊nɔ dɛ ꞊de klɛ ‑hɩhɩa. ");
INSERT INTO ted_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","'Ke Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ teteitɔɔnyʋ 'hɛɛn, ʋ nɩ 'o. Nʋ‑ʋ ‑Yusu ‑tɩ yɛɛ, 'ke 'le win 'yaklɩkɔ 'kwli 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Helɔdɩ kɔ 'a nahuin 'hɛɛn, 'ʋʋ ‑Yusu 'caa, kɔ, 'ʋʋ 'a ‑tɩ lɛ ‑haa, 'plɩɩ 'ʋ puo bodɩɔwlawlʋ, 'ʋ gbɔ 'le lele Pilatɩ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Helɔdɩ kɔ Pilatɩ 'hɛɛn, ʋ mɔ ‑gbo, ʋ nyinyre la lɛ, kɛɛ, ‑nyrɔwɔ a ‑gbɛ 'mʋ, ʋ ‑hɛ la nɩnatumupʋ. ");
INSERT INTO ted_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","‑Ye Pilatɩ da Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, kɔ ‑Juukʋɛ a ye'mʋnaanyʋ kɔ nahuin ‑ye 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","‑Ye kɛ ɔ nyu ye po, ɔ nɔ: «A nɔ 'nɩ, nahuon ‑gbo, nɔ‑ɔ 'blʋgba yra 'mʋ bla. Ɛ nɛ‑ nue, 'a yɔ 'mʋ ye. Ba po 'mʋ nʋa ye gbo ‑tɛɛ: 'Na ‑gbɛgbɛ, 'n ꞊gbɔ lɛ wlɔn ‑tɛɛ, kɛ mɔ 'a mʋ ye. 'Yilɛnyre‑tɔplɩ 'bii ‑gbo, ‑ɩ kɔ ‑tɩ aa ꞊nɔ yɛɛ, 'n 'ye nɩ, ‑ɛ mɔ, ɛ 'de 'a nunu‑tɩ. ");
INSERT INTO ted_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Mɔ, Helɔdɩ 'ye ‑wɛ nɩ, ‑ɛ mɔ, 'yilɛnyre‑tɔplɩ 'bii ꞊nʋ, ‑ɩ kɔ ‑tɩ aa ꞊nɔ yɛɛ, ɛ 'de 'a nunu‑tɩ. Ɛ nɛ‑ nue, 'ɔ ‑mɩɔ de. 'A ‑tɩ 'klɛɛ o, nahuon ‑gbo, ɔ 'de 'yilɛnyredɛ ꞊de nu, ‑bɛ blɛ 'kʋkʋɛ ye. ");
INSERT INTO ted_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","'A ‑tɩ, 'na 'sɔyuo bʋ nu lɔkɔ, bʋ bio, 'plɩɩ 'muo gbo tɛ.»  ");
INSERT INTO ted_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","'Be 'ɛ nɩ ‑Juukʋɛ a lɛ'mimre ꞊nʋ, ‑ɔ mɔ Pakɩ a ti 'yri, Pilatɩ kɔ bɔ ‑ha nahuoon ‑do ꞊jɩ 'mʋ, 'ke 'o ‑Juukʋɛ a plɔ a bleelɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Kɛɛ ‑ye ʋ 'bii a ‑gbɛ, ʋ ‑tʋa Pilatɩ a 'yi'mʋlɛ꞊mʋmalɛ gbo, ʋ nɔ: «Nue, nahuon ‑gbo bɔ 'kʋ, ‑bo ‑ha Balabasɩ ꞊jɩ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","'Plɩɩ ‑ye ʋ po o Balabasɩ 'mʋ ꞊jɩ, ‑ɛ nue, ɔ kɔ nahuin ‑ye 'hɛɛn, ʋʋ o Romakʋɛ a ye'mʋnaanyʋ ye 'nɩ ‑wɔn, 'ke 'le Jrusrɛ 'mʋ, 'plɩɩ, 'ke 'le ye‑wʋnwɔnlɛ a ‑gbɛ 'kwli 'mʋ, ʋ 'laa o 'le nahuon. ");
INSERT INTO ted_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatɩ nye 'nɩ ‑hʋa, bɔ tɛ ‑Yusu gbo. Ɛ nɛ‑ nue, 'ɔ ‑tʋa 'le lele nahuin ꞊nʋ a ‑wɔn'prɛɛlɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kɛɛ, 'plɩɩ ʋ 'mʋ 'a wintɛ mu 'wɔn, ‑ye ʋ 'bii a ‑gbɛ, ʋ ‑tʋa lele Pilatɩ a 'yi'mʋlɛ꞊mʋmalɛ gbo. Kɛ ʋʋ po: «Kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ; kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ.» ");
INSERT INTO ted_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","‑Ye kɛ Pilatɩɩ lele ꞊nʋ ye po, 'ke 'le gblo a ta a nɔnɔ 'kwli 'mʋ: «'Yilɛnyredɛ tio‑ ɔ nu 'klɛɛ 'le? 'N 'de 'le ꞊nɔ dɛ 'klan ꞊de 'mʋ 'yee, ‑bɛ blɛ 'kʋkʋɛ ye. 'A ‑tɩ o, 'n di le 'na 'sɔyuo, bʋ bio lɔkɔ. 'Bɩa 'bʋ bio, ‑ye 'n tɩɔ gbo.» ");
INSERT INTO ted_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kɛɛ ‑ye ʋ 'kɩɛ gbɛɛ 'a 'yi'mʋlɛ꞊mʋmalɛ a ‑gbɛ 'lu ‑wɔn. Kɛ ʋʋ po: «Kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ.» ‑Ye 'waa win nɩ 'o Pilatɩ ye 'lu. ");
INSERT INTO ted_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bʋ 'nɩnɩ wɛɛn 'klɛɛ ꞊nɔ, ‑ye Pilatɩ ‑yrɩ nɩ, 'ke bɔ wɛɛn dɛ ꞊nʋ ke, ʋʋ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","‑Ye ɔ tɛ nahuon ꞊nʋ gbo, ‑Juukʋɛɛ ‑hʋa, ‑ɔ mɔ Balabasɩ, ʋ po o ꞊jɩ 'mʋ, 'ke 'o 'blʋgba a ꞊gbʋgblɔlɛ a ‑ta 'mʋ, kɔ, 'ke 'o nahuon a 'lɩla a ‑ta 'mʋ. ‑Yusu ‑mɛ ‑ye, nɔ‑ ɔ ‑nye 'a 'sɔyuo, 'ke bʋ gbɔ, bʋ 'lɔ, ‑tɛ ‑Juukʋɛɛ 'a ‑hʋhʋa nu. ");
INSERT INTO ted_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","‑Ye Pilatɩ a 'sɔyuoo ‑Yusu 'nɩ gba, 'ʋ nyo 'dɩɔ 'mʋ ꞊tɩɔ, ʋ 'muo 'la. Bʋ nɩ 'le mumue 'kwli 'mʋ, ‑ye ʋ kɔ nyɩbɛyu ꞊de 'hɛɛn, nʋ‑ ꞊ŋmoo. Nyɩbɛyu a ‑gbɛ, 'a 'dʋ mɔ Simɔ. 'Ke ɔ kɔ 'le Silɛnɩdɩɔ 'mʋ, 'ɔ ‑hɔn 'le ‑ci ke 'mʋ. Nɔ‑ 'sɔyuo klɩ, 'ʋ hren ꞊nɔ ‑Yusu a tu, 'ke bɔ kʋɔ ‑wɔn, ");
INSERT INTO ted_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","nahuin ‑huohui 'ʋʋ ‑Yusu ‑wɔn kʋɛ, nyrʋgbapʋ ‑ye 'ʋ nyo ‑wɛ ‑wɔn kʋɛ, 'ʋʋ we, 'ke 'o ‑Yusu a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Bʋ nyo ‑wɔn wee, ‑ye ‑Yusu ꞊hɩan ‑wɔn, 'ɔ nyu 'le ‑wɔn 'prɛɛ, ɔ nɔ: «Jrusrɛ 'mʋ a nyrʋgbapʋ, a nɩ we 'le ꞊hien, 'ke 'o 'na ‑ta 'mʋ, kɛɛ, ba we, 'ke 'o 'a nɩ dɩɔnʋ kɔ 'a nɩ 'yuo꞊pli a ‑ta 'mʋ, ");
INSERT INTO ted_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","‑ɛ nue, ꞊sʋɛ'yeti di 'o 'nɩ nyre. Ti a ‑gbɛ 'yri, kɛ ʋ di po: Plɔ a bleelɛ 'ke 'o nyrʋgbapʋ ‑gbo ‑wɔn, ‑ʋ 'de 'yukɔdɛ, kɔ ꞊ʋ ‑ye, ‑ʋ 'de ‑hlɩn 'yuo a kʋɛ, kɔ ꞊ʋ ‑ye, ‑ʋ 'de ‑hlɩn 'yuo a 'nyɛɛ. ");
INSERT INTO ted_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ti a ‑gbɛ 'yri, ‑ye kɛ ‑tʋnahuin di po, dʋgbɩ bɩ bi ꞊nʋ klɛ, ʋ 'mʋ lɛ 'kʋkʋ. ");
INSERT INTO ted_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","'Mɔ ‑gbo, ‑ɔ kɔ 'klɔ 'sii 'o ye, ‑ɔ 'we ꞊nɔ tugbɛ yrayrʋ ye, ʋʋ lɛ nu, ʋʋ ꞊sʋɛ ꞊tue, 'plɩɩ 'a mʋ ‑gbo, ‑ʋ kɔ 'klɔ 'de 'o ye 'sii, ‑ʋ 'we ꞊nɔ ti 'kʋkʋɩ ye, ‑be' 'a nɛnɛ di ‑hlɩn 'mʋ nɩ 'le?» ");
INSERT INTO ted_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","'Sɔyuo, ʋʋ ‑wɛ gba 'crɛnyʋʋ 'hɔn, ʋ 'mu 'la, ʋ kɔ ‑Yusu 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","'Ke ʋ nyre 'klɛɛ 'o ‑tuo ꞊nʋ ke, ‑ɔ kɔ 'dʋ mɔ 'Lukla. ‑Ye 'ke 'sɔyuo kɔɔ 'o ‑Yusu tu 'yie 'mʋ, 'ke 'o ‑tuoo ‑do a ‑gbɛ ke. ‑Ye 'ke ʋ kɔɔ ‑wɛ 'o 'crɛnyʋʋ 'hɔn a ‑gbɛ 'waa nɩ ti 'yie 'mʋ, ‑do 'ke 'le 'a diidɛpɩa ke, ‑do ‑ye 'ke 'le 'a kamrapɩa ke. ");
INSERT INTO ted_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","‑Yusu 'mʋ 'o tu 'yie 'mʋ nɩ, ‑ye kɛ ɔɔ po: «'Na Bu o, dɛ 'kuku ‑gbo, ʋʋ nu, ‑hri 'a ‑tɩ ‑wɔn, ‑ɛ nue, ‑tɔplɩ ‑gbo, ʋʋ nu, ʋ 'di yi.» 'Sɔyuo ‑mɛ ‑ye, ʋ po 'bla, ‑Yusu a 'hʋɩn'mʋlɛpue‑tɔplɩ a ‑tɩ, ‑tɛ bʋ di 'a wuwe nu, ʋ 'mue yi. ");
INSERT INTO ted_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Pʋpʋnahuin ‑ye, ‑ʋ nɩ 'o ‑tuo a ‑gbɛ ke, 'ke ʋ po 'o 'yie gbo, 'ʋʋ ‑tɔplɩ 'bii ꞊nʋ 'ye, ‑ɩɩ 'lu ‑wɔn mue. ‑Ye ‑Juukʋɛ a 'blʋ a nahuin, ʋ nyo 'nɩ 'caa, ʋ nɔ: «Ɔ waa nahuin ‑ye nɩ, 'ɔ ‑ha 'o 'waa ‑hʋnhlʋn wlɔn, 'ʋ 'de 'kʋ. 'A ‑tɩ 'klɛɛ o, 'bɩa 'bɔ 'ya Waanyɔ ꞊nʋ 'mʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, bɔ waa 'klɛɛ 'a dɩɔnʋ!» ");
INSERT INTO ted_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","‑Ye 'sɔyuo ‑mɛ ‑ye, ʋ nyo ‑wɛ 'nɩ 'caa. ‑Ye ʋ 'yɩya 'o ꞊nɔ 'mʋ gbo 'hʋɩn, 'ʋʋ ꞊nɔ 'lipanɔ ‑nye. ");
INSERT INTO ted_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","‑Ye kɛ ʋ nyo ye po: «'Bɩa ꞊nɩ 'ya ‑Juukʋɛ a bodɩɔ 'mʋ, ‑ye ‑bo waa ‑n dɩɔnʋ!» ");
INSERT INTO ted_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","'Ke 'o 'a tu a ‑gbɛ 'yie 'mʋ, 'ke ʋ 'crɩɩ 'o 'plaɩnpɩa ke, ‑ɛ mɔ: «Nahuon ‑gbo, nɔ‑ mɔ ‑Juukʋɛ a bodɩɔ.» ");
INSERT INTO ted_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","‑Ye 'crɛnyʋʋ 'hɔn ꞊nʋ, ‑ʋ kʋɛ 'o ti ꞊nʋ 'yie 'mʋ lɛ, nahuoon ‑do nɩ 'le, 'ɔɔ ‑Yusu tanɩ ꞊tu, ɔ nɔ: «‑N 'de lɛ po, ‑mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya. Waa 'klɛɛ ‑n dɩɔnʋ, ꞊mʋ ‑wɛ ‑a mʋ waa.» ");
INSERT INTO ted_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kɛɛ ‑ye 'a 'be ‑ye ꞊nʋ, ‑ɔ nɩ 'o, ɔ ‑tʋa 'a 'be a 'nyrɛ a ꞊hɩnhɩɛn gbo, ɔ nɔ: «‑Mɔ ‑gbo, ꞊nɩ pɩ ꞊le Nyɩsʋa mɔ. ꞊Sʋɛɛ ‑do, ‑nɩɩ 'ye, nɛ‑ nyɩbɛyu ‑gbo, ɔɔ ‑wɛ 'ye. ");
INSERT INTO ted_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","‑A ‑mɛ ‑ye, ‑a nɩ ꞊sʋɛ ‑gbo, ɛ kɔ 'o ꞊o, ‑ɛ nue, 'yilɛnyre‑tɔplɩ ꞊nʋ, ‑a nu, nɩ‑ kɔ ‑bati klɩ ‑a mʋ. Kɛɛ ‑ye ɔ ‑mɛ ‑ye, ɔ 'de dɛ 'klan ꞊de nu.» ");
INSERT INTO ted_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Bɔ po 'klɛɛ lɛ, ‑ye kɛ ɔɔ ‑Yusu ye po, ɔ nɔ: «‑Yusu o, 'nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, 'na ‑tɩ nɩ ‑hri 'le ‑mʋ ‑wɔn, ti ‑kɔ 'yri ‑n di 'le di, 'ke 'le 'klɩkɔ 'kwli 'mʋ, ꞊mʋ nahuin win ke kɔɔ 'bii.» ");
INSERT INTO ted_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","‑Ye kɛ ‑Yusuu ꞊nɔ ye po: «'Nɩɩ ‑mʋ 'nɩ le, kɛkɛ ‑gbo, ‑n kɔ 'mʋ 'hɛɛn, 'ke ‑a di kɛ 'le 'n Bu Nyɩsʋa a ꞊hapʋ'dɩɔ 'mʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Muu 'o 'yrʋ a gbonyrati 'yri, ‑ye 'yrʋ 'kee hʋnhʋan nɩ. ‑Ye gbɩgbɩyrɩ ka 'blʋgba 'bii ke. Gbɩgbɩyrɩ a ‑gbɛ, ɩ nɩ 'o ‑nɩnɩ, 'ɛ yɛ 'yrʋ‑hiilɛ a ti ke. Tii ‑do a ti 'yri, 'ke 'le Nyɩsʋa a 'kagblaka gbo, ‑ɔ nɩ 'le Jrusrɛdɩɔ 'mʋ, Nyɩsʋa nue nɩ, dagblaka ꞊nʋ, ‑ɔ 'bɛ kayu a ‑gbɛ ꞊tɩɔ, 'ɔ ‑ki wlɔn 'bii. ");
INSERT INTO ted_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","‑Ye ‑Yusu ‑hɛ wlɔn ‑cici, ɔ nɔ: «'Na Bu, ‑mɔ 'n po 'le 'na ‑hihiu kwa 'mʋ.» Bɔ ‑yrɛ 'klɛɛ, ‑ye ɔ mra ‑hʋnhlʋn nɩ. ");
INSERT INTO ted_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Romakʋɛ a 'sɔyuo a nyɩgblaka ꞊nʋ, ‑ɔ nɩ 'o, ɔ 'ye ‑tɔplɩ 'bii ꞊nʋ nɩ, ‑ɩ mue 'lu ‑wɔn, 'ɔ ‑tʋa Nyɩsʋa a 'nyrɛɛlɛpupue gbo, 'plɩɩ 'ɔɔ lele wun po, ɔ nɔ: «'Ɛ mɔ ‑tɛɛ, nahuon ‑gbo, ɔ 'de dɛ 'klan ꞊de nu.» ");
INSERT INTO ted_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nahuin 'bii ꞊nʋ, ‑ʋ di ‑ta 'ye wɔn, ʋ 'ye ‑tɔplɩ ꞊nʋ nɩ, ‑ɩ mue 'lu ‑wɔn. 'Waa plɔɔ 'le gbo a 'nɛɛ, 'ʋ ‑mɛ de. ");
INSERT INTO ted_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","‑Yusu a nɩnatumupʋ 'bii ꞊nʋ, kɔ nyrʋgbapʋ ‑ye, ‑ʋ nyo la ‑wɔn kʋɛ, ‑ʋ ‑hɔn 'le Galileblʋgba 'mʋ, ʋ ꞊gbɛ ‑wɔn, 'ʋ 'ye ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ɛ kɔ ‑wɛ nyɩbɛyu ꞊de. 'A 'dʋ mɔ Sosɛfʋ. 'Ke ɔ kɔ 'le ‑Juukʋɛ a 'dɩɔ ‑ye ꞊nʋ 'mʋ, ‑ɔ kɔ 'dʋ mɔ Alimate. Nyɩbɛyu a ‑gbɛ, 'a ꞊wlʋ nɔ lɛ 'yi, kɔ, 'a 'klɔ 'ɔ 'sii 'o ye, 'ɔɔ ti ꞊nʋ ‑pre 'dɔ, ‑ɩ kɔ 'yri Nyɩsʋa di 'o nahuin win ke kɔɔ. Ɔ mɔ ‑Juukʋɛ a ‑gboligbo gblaka a nahuoon ‑yee nɩ. Kɛɛ, ‑tɔplɩ ꞊nʋ, 'a 'bienʋ ꞊tu, kɔ, ʋ nu, 'ke 'o ‑Yusu ‑wɔn, ɔ 'di ke wɛɛn. ");
INSERT INTO ted_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Sosɛfʋ a ‑gbɛ, nɔ‑ mu 'le Pilatɩ ‑wɔn, 'ɔ lo, 'ke bɔ wɛɛn ke, bɔ ‑ha 'o ‑Yusu a ‑plahʋɩn tu 'yie 'mʋ, ɔ 'mui 'o ‑ha, Pilatɩ a ‑gbɛ 'ɔ wɛɛn ke, ");
INSERT INTO ted_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Sosɛfʋ a ‑gbɛ 'ɔ mu, 'ɔ ꞊tɩɔ 'o ‑Yusu a ‑plahʋɩn tu 'yie 'mʋ, 'ɔ 'hɩnhɩʋɔn ‑jisɛ lɛ, 'plɩɩ 'ɔ gbɔ 'le ‑tɛgbi ꞊nʋ, ɔ dio 'o ‑ha. ‑Tɛgbi a ‑gbɛ, 'hɩɔ gblaka nɩ 'o, 'ɔ hren 'klɔ, 'ɔ 'we ꞊nɔ dʋgba ye. 'Hɩɔ gblaka a ‑gbɛ 'kwli 'mʋ, 'ke ʋ 'bluu la 'le 'dɛɛ, (ti ꞊de a ti 'yri la, ‑ɛ 'we ꞊nɔ ‑wlukayu ye). 'Dɛɛ a ‑gbɛ wlɔn, ʋ 'de ‑hlɩn 'le 'kʋkʋku a pue. Nɛ‑ kɔ wlɔn, 'ke ɔ po 'le ‑Yusu a ‑plahʋɩn. ");
INSERT INTO ted_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ɛ mɔ 'wee a 'wɩɩ ꞊hun a 'yrʋ‑hiilɛ 'mʋʋ nɩ, ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ, ‑ɔ mɔ 'sɛɛdɩ, 'ɔɔ 'o mu nyre, 'yrʋ bʋ pa a ti 'yri. ");
INSERT INTO ted_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nyrʋgbapʋ ꞊nʋ, ‑ʋʋ o ‑Yusu ‑wɔn kʋɛ, ‑ʋ ‑hɔn o 'le Galileblʋgba 'mʋ, nʋ‑ mu 'le 'dɛɛ ye, ʋ kɔ Sosɛfʋ 'hɛɛn, nyrʋgbapʋ a ‑gbɛ 'ʋ tɛ 'le wlɔn lɛ, 'ʋ 'ye, ‑tɛ ʋ nu 'le ‑Yusu a 'dɛɛ a wlɔnpupue. ");
INSERT INTO ted_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Bʋ ‑gbɛ ‑tɔplɩ 'bii ꞊nʋ, ‑ye ʋ ‑mɛ de, 'ʋ 'ya 'dɩɔ 'mʋ, 'ʋ ‑wɔ hʋnhrʋnpo‑tɔplɩ ‑wɔn, kɔ ‑dawinninyra 'hɛɛn, 'ke 'o ‑Yusu a 'hʋɩn a lɛplʋʋlɛ a ‑ta 'mʋ. 'Plɩɩ ‑wuwle‑nyrɔwɔ 'mʋ 'o mu nyre, ‑ye ʋ ‑wle nɩ, ‑tɛ Nyɩsʋa a tetee 'a ꞊tutue nu. ");
INSERT INTO ted_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","‑Wuwle‑nyrɔwɔ bɔ ‑hi a 'sɔɔdɩ a ‑nyrɛgblɩ, ‑ye nyrʋgbapʋ a ‑gbɛ, ʋ 'ba 'mʋ ye, ‑dawinninyra ꞊nʋ, ʋ ‑wɔ o ‑wɔn, 'ʋ gbɔ 'le ‑Yusu a 'dɛɛ ye. ");
INSERT INTO ted_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","‑Tɛ ʋ nyre 'le, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, gbɛtɛɛ 'mʋ a 'hɩɔ ꞊nʋ, nahuin nu o, 'ʋ ka o 'dɛɛ ye, ʋ briko lɛ, 'ʋ ‑hɩɔ 'o 'dɛɛ ye. ");
INSERT INTO ted_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","‑Ye ʋ pa 'le 'dɛɛ a ‑gbɛ wlɔn nɩ, kɛɛ, ʋ 'de 'le Kʋkɔnyɔ ‑Yusu a ‑plahʋɩn gbo yɛ. ");
INSERT INTO ted_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Bʋ 'di 'klɛɛ 'le gbo yɛ, ‑ye ʋ saka nɩ. Dɛ bʋ di 'lu ‑wɔn lɛ ‑hie, ʋ 'die yi. Bʋ nɩ 'klɛɛ 'o gbo, ‑ye nyɩbɛpʋʋ 'hɔn ꞊de 'hrɩɩ ꞊nʋ ye. Nyɩbɛpʋʋ 'hɔn a ‑gbɛ, ʋ pue wlawlɩ pʋɔpʋɩ, 'ɩɩ wlɩn. Nyɩsʋa a lɛleenyʋ'ʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","'Plɩɩ ʋ 'mʋ nahuiin 'hɔn a ‑gbɛ mu 'ye, ‑ye hʋannʋ biu 'le 'kwli 'mʋ, 'ʋ po 'li ‑wlu lɛ. ‑Ye kɛ nahuiin 'hɔn a ‑gbɛ, ʋ nyu ye po: «A nɩ ꞊mʋɔ 'le nɔ 'kʋkʋnyʋ ‑hɛyri lɛ. Ɔ nɩ 'klɔ. ");
INSERT INTO ted_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɔ 'de nɔ nɩ. Nyɩsʋa ‑hɩɔ 'le 'kʋkʋnyʋ ‑hɛyri nɩ, 'ɔ ‑hɩɔ 'klɔ. ‑Tɛ ɔ 'kɩɛ nɩɛ o 'le Galileblʋgba 'mʋ, ‑tɩ ‑gbo, ɔ ꞊tu o 'a mʋ ye, 'ke 'o 'a ‑ta 'mʋ, bɩ bi 'le 'a mʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kɛ ɔɔ o 'a mʋ ye po: ‑Tʋnahuin 'bii a Nahuon, ʋ kɔ bʋ puo dɛ'klannunyʋ kwa, ʋ 'muo 'o tu 'yie 'mʋ kɔɔ, ɔ 'mʋ 'kʋ. 'Plɩɩ 'bɔ 'kʋ, ‑nyrɔwɩɩ 'hɔn, ta a nɔnɔ 'mʋ, ɔ 'mʋ 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ ‑hɔn, ɔ 'mʋ 'klɔ 'hrɩ.» ");
INSERT INTO ted_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ʋ 'mʋ 'klɛɛ ‑tɩ a ‑gbɛ mu 'wɔn, ‑ye ‑tɩ ꞊nʋ, ‑Yusu ꞊tu o ꞊nʋ ye, ɩ bi 'le ꞊nʋ 'mʋ 'kwli. ");
INSERT INTO ted_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","'Plɩɩ ɩ 'mʋ 'le ꞊nʋ 'kwli 'mʋ mu bi, ‑ye ʋ ꞊hɩan ‑wɔn, 'ʋ mu 'le ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o ‑do ꞊nʋ ‑wɔn, kɔ nahuin 'bii ‑ye ꞊nʋ 'hɛɛn, ‑ʋʋ ‑wɛ ‑Yusu ‑wɔn naa, 'ʋ na ꞊nʋ ‑tɔplɩ 'bii ꞊nʋ ‑wɔn yrɛ, ‑ɩ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nyrʋgbapʋ a ‑gbɛ, ‑ʋʋ ‑tɔplɩ a ‑gbɛ ‑wɔn lɛ na, 'waa 'dʋɩ mɔ Madala 'mʋ a Mari, kɔ Sanɩ, kɔ Mari ‑ye, ‑ɔ mɔ Sakɩ a 'dii. Nyrʋgbapʋ ‑ye, ‑ʋ kɔ ꞊nʋ 'hɛɛn, ‑ʋ mu 'le 'dɛɛ ye, ‑tɔplɩɩ ‑do a ‑gbɛ, nɩ‑ ʋ na ‑wɛ ‑Yusu a ‑wɔnnaanyʋ a ‑gbɛ yrɛ. ");
INSERT INTO ted_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kɛɛ ‑ye ‑Yusu a ‑wɔnnaanyʋ nye ‑wɔn lɛ ‑hie 'lu, ‑ɛ mɔ, ‑tɩ ꞊nʋ, nyrʋgbapʋ a ‑gbɛ, ʋ na ꞊nʋ ‑wɔn yrɛ, ɩ 'de 'lukɔtu kɔ, 'ʋ 'diu ‑tɛɛ pue. ");
INSERT INTO ted_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kɛɛ ‑ye Piɛlɩ 'ba 'mʋ ye, 'ɔ gba 'le 'dɛɛ ye cigbɛi, 'ɔ ꞊tɩtɩ 'mʋ, 'ɔ tɛ 'le wlɔn lɛ, 'ɔ 'de 'le dɛ ꞊de 'ye, 'bɛ 'de ‑jisɛii ‑do ꞊nʋ, ʋ 'hɩnhɩʋan o ꞊nɔ lɛ, 'ɔ ꞊hɩan ‑wɔn, 'ɔ mu 'le kayu gbo. 'A ‑gbɛ, ɩ saka ꞊nɔ nɩ 'dɔ, 'ke 'o ‑tɔplɩ ꞊nʋ, ‑ɩ mue 'lu ‑wɔn a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","‑Nyrɔwɔɔ ‑do a ‑gbɛ 'mʋ, ‑Yusu a ‑naagbopʋʋ 'hɔn ‑ye, nɔ‑ ‑hɔn 'le Jrusrɛdɩɔ 'mʋ, 'ʋʋ 'le 'dɩɔ ꞊nʋ 'mʋ mu, ʋʋ Emausɩ daa. ‑Hɔn 'le Jrusrɛ 'mʋ, ‑bo mu 'le Emausɩ 'mʋ, ɛ ‑wɛ 'le ‑kilowɩɩ ‑pu ꞊tu 'o ‑do nɩ. ");
INSERT INTO ted_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","‑Tɛ ʋ nɩ 'klɛɛ 'hru wlɔn, ‑ye ‑tɔplɩ 'bii ꞊nʋ, ‑ɩ mue 'lu ‑wɔn, nɩ‑ kɔ ‑tɩ ʋʋ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Bʋʋ 'klɛɛ ‑tɩ a ‑gbɛ 'mʋ lɛ pupo, ‑ye ‑Yusu a ‑gbɛ, ɔ 'yɩya 'o ꞊nʋ 'mʋ gbo 'hʋɩn, ɔ kɔ ꞊nʋ 'hɛɛn 'ʋʋ mu. ");
INSERT INTO ted_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Kɛɛ, ꞊nɩ nyu 'ye, ɛ 'we ꞊nɔ ye, dɛ ꞊de ka 'waa 'yii ke. Nɛ‑ nue, 'ʋ 'nɩnɩ yroo. ");
INSERT INTO ted_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","‑Ye ‑Yusu ꞊gbʋ wlɔn, ɔ nɔ: «‑Tɩ tio‑ aa 'mʋ lɛ pupo 'le?» ‑Tɛ ɔ ꞊gbʋ wlɔn, ‑ye nahuiin 'hɔn a ‑gbɛ, ʋ nyra gbo, ‑ɛ nue, 'waa ꞊wlɩ 'mʋɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","‑Ye nahuon ꞊nʋ, ‑ɔ mɔ Klopasɩ, ɔ ꞊tuo ‑wɔn, ɔ nɔ: «'N pue ‑tɛɛ, 'ke 'le Jrusrɛ 'mʋ a nahuin ‑hɛyri, ‑n ‑do, ‑mɔɔ nɩ, ‑ɔ 'de ‑tɩ ꞊nʋ 'wɔn, ‑ɩ mue 'lu ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","‑Ye ɔ nɔ: «‑Tɩ tio‑ 'le?» ‑Ye ʋ nɔ: «‑Tɩ ꞊nʋ, ‑ɩ mue 'lu ‑wɔn, 'ke 'o Nasalɛtɩ 'mʋ a ‑Yusu ‑wɔn. Ɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ. 'Ke 'o Nyɩsʋa kɔ nahuin 'bii ye, 'a 'ŋmilɛka‑tɔplɩ, ɔɔ o nu, ɩ kɔ 'a tɔɔwin 'hɛɛn, ɩ tʋɛ o ‑a mʋ nɩ, ‑ɛ mɔ, ɔ nɩ o ke 'klɩ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kɛɛ, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ ‑a nɩ ye'mʋnaanyʋ 'hɛɛn, nʋ‑ puo Romakʋɛ a 'kɩɩnpʋ kwa, ‑ɛ die nu, ʋ 'muo ‑bati lɛ poo. 'Ɛ mɔ ‑tɛɛ, ‑tɛ ʋ puo ‑bati lɛ, 'ʋ kʋɔ tu 'yie 'mʋ, 'ɔ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","‑A ‑mɛ ‑ye, ‑a kue o ye ꞊wlʋ, ‑ɛ mɔ, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa ya o 'le, ‑ɔ di ‑a mʋ Yisraɛkʋɛ ꞊gbla, 'ke 'le Romakʋɛ kwa 'mʋ. ‑Tɛ ‑tɔplɩ 'bii a ‑gbɛ, ɩ mue 'lu ‑wɔn, 'a ‑nyrɔwɔ a ta nɔnɔ nɩ kɛ gbo. ");
INSERT INTO ted_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","'Ɛ mɔ ‑tɛɛ, nyrʋ ‑ye kɛ nɔ ‑a mʋ ‑hɛyri, ‑tɩ ‑gbo, ʋ ꞊tu, ɩ saka ‑a mʋ nɩ. ‑Nyrɛgblɩ wɛn, nyrʋ a ‑gbɛ, nʋ‑ ‑tuo wɛn 'le 'dɛɛ ye, ");
INSERT INTO ted_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","kɛɛ, ʋ 'de 'le ‑Yusu a ‑plahʋɩn 'dɛɛ wlɔn gbo yɛ, 'ʋ di wɛn ‑a mʋ le wɔn, ‑ɛ mɔ, Nyɩsʋa a lɛleenyʋ 'hrɩɩ ꞊nʋ ye, 'ʋ le ꞊nʋ, ‑ɛ mɔ, ‑Yusu ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ 'hrɩ 'klɔ. ");
INSERT INTO ted_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nahuin ‑ye 'ke 'le ‑a mʋ ‑hɛyri, ‑tɛ ʋ 'wɔn ‑tɩ a ‑gbɛ, 'ʋ mu 'le 'dɛɛ a ‑gbɛ ye. 'Ɛ mɔ ‑tɛɛ, ‑tɩ ꞊nʋ, nyrʋgbapʋ ꞊tu ꞊nʋ ye, kɛ'ɛ nɩ, ɩ nu naalɛ, kɛɛ, ʋ 'de 'le ‑Yusu a ‑gbɛ gbo yɛ.» ");
INSERT INTO ted_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «'Oo‑, a 'de 'lu a lɛ‑hielɛ kɔ. ‑Tɩ 'bii ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyʋ ꞊tu la, ti ‑hi la a ti 'yri, 'a nɩ ꞊wlɩ 'nɩ kli ꞊le 'tata, kɔ, 'a 'di ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Winwlɔn‑hɛnyʋ a ‑gbɛ, ʋ ꞊tui la nɩ, ‑ɛ mɔ, Waanyɔ ꞊nʋ, Nyɩsʋa di la 'le ya, ɔ blɛ ye bɔ 'ye ꞊sʋɛ, 'plɩɩ Nyɩsʋa 'muo ‑tɩ a 'yi'bʋaalɛ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","‑Ye ‑tɔplɩ 'bii ꞊nʋ, ʋ 'crɩɩ la, 'ke 'o ꞊nɔ ke, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɔ ‑hɩhɩ ꞊nʋ klɛ, kʋɛ 'le Moise a 'crɩɩnɩɛi 'yie 'mʋ gbo, ‑bo yɛ Nyɩsʋa a winwlɔn‑hɛnyʋ ‑ye a 'crɩɩnɩɛi ke. ");
INSERT INTO ted_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","‑Tɛ ʋʋ 'le Emausɩdɩɔ 'mʋ mu nyre, ‑ɔ kɔ 'mʋ ʋʋ 'le mu, ‑ye ɛ 'we ꞊nɔ ye, ‑Yusuu ‑hʋa bɔ gba 'hru 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kɛɛ, ʋ nyo lɛ 'nɩ 'batɩ, ʋ nɔ: «Pɛɛ nɔ ‑a mʋ ‑wɔn, 'tɔɔ 'nɩ ‑wɔn,» ɔ kɔ ꞊nʋ 'hɛɛn 'ʋ 'ya 'dɩɔ 'mʋ, 'ɔ pa 'le ꞊nʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","‑Tɛ ʋ pa, 'ʋ ꞊glaa 'le dɛdihuo 'le, 'ɔ 'ba 'flɔɔ 'mʋ, 'ɔ ‑nyi Nyɩsʋa 'wio, 'plɩɩ 'ɔ 'bɩɔ ꞊tɩɔ lɛ, 'ɔ ‑nyo ꞊nʋ. ");
INSERT INTO ted_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","‑Tɛ ɔ ‑nyo 'klɛɛ ꞊nʋ, ‑ye 'waa 'yii klɛ ke, 'ʋ yroo. Kɛɛ ‑ye tii ‑do a ti 'yri, ɔ 'wan ꞊nʋ ke 'yi. ");
INSERT INTO ted_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kɛ ʋʋ yrɛ pupo, ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, ‑tɛ ɔɔ wɛn 'prɛ, 'ke 'le 'hru wlɔn, ɔɔ wɛn ‑a mʋ Nyɩsʋacrɩɩnɩɛ klɛ ‑hɩhɩa, 'manʋ nɩ wɛn 'le ‑a nɩ ꞊wlɩ ke 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","‑Ye tii ‑do a ti 'yri, ʋ 'ba 'mʋ ye, 'ʋ bi lele 'hru wlɔn, 'ʋ mu 'le Jrusrɛ 'mʋ. 'Ke ʋ yɛ 'o ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o ‑do ꞊nʋ gbo, ʋ kɔ 'waa 'bienʋ 'hɛɛn. Nahuin a ‑gbɛ, ʋ 'kukue lɛ, 'ke 'le kayuu ‑do gbo, ");
INSERT INTO ted_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","'ʋ le nahuiin 'hɔn ꞊nʋ, ‑ʋ di 'le, ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, ‑a nɩ Kʋkɔnyɔ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ 'hrɩɩ Simɔ Piɛlɩ ye.» ");
INSERT INTO ted_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ʋ 'hɔn ꞊nʋ, ‑ʋ di 'le, dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, 'ke 'le 'hru wlɔn, ʋ 'ye, nɩ‑ ʋ na ‑wɔn lɛ, ɛ kɔ ‑tɛ ʋ nu 'a yriilɛ, ti ꞊nʋ ‑kɔ 'yri ɔɔ 'o 'flɔɔ ꞊tɩɔ lɛ 'bɛɛ. ");
INSERT INTO ted_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Bʋ nɩ 'klɛɛ 'le ‑tɩ a ‑gbɛ a ꞊tutue 'kwli 'mʋ, ‑ye 'ke ‑Yusu 'hrɩɩ 'le ꞊nʋ ‑hɛyri, 'ɔ po 'waa 'wio gbo, ɔ nɔ: «Nyɩsʋa bɔ nɩ 'o 'a mʋ ‑wɔn!» ");
INSERT INTO ted_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","‑Tɛ ʋ 'yo, ‑ye hʋannʋ biu 'le 'kwli 'mʋ. Ʋ ‑mɛ ‑ye, ʋ nɔ 'nɩ, 'kuu nɩ, ‑ʋ 'hrɩɩ 'le ꞊nʋ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","‑Ye ɔ nɔ: «Dɛ tio‑ kɔ hʋannʋ aa 'klɛɛ pɩ 'le? Dɛ‑ nue 'klɛɛ, 'a 'nɩnɩ pue ‑tɛɛ, ‑ɛ mɔ, 'mɔɔ nɩ 'le? ");
INSERT INTO ted_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ba 'ye 'na kwatɩ kɔ 'na bʋɩ. 'Mɔ ‑Yusu'u nɩ. Ba 'tʋ 'na 'hʋɩn lɛ. A die 'nɩ 'ye, ‑ɛ mɔ, 'n 'de 'ku. 'Kuo 'de 'hʋɩn kɔ, ɔ 'de ‑wɛ 'kla kɔ, 'plɩɩ ‑ye, a nye 'nɩ 'ye ‑tɛɛ, ‑ɛ mɔ, 'n kɔ 'hʋɩn.» ");
INSERT INTO ted_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","‑Tɛ ɔ ‑wɔ ‑tɩ ꞊nʋ a ꞊tutue ‑wɔn, ‑ye ɔ titie ꞊nʋ 'a kwatɩ kɔ 'a bʋɩ 'hɛɛn ye, (ʋ 'mʋ kɔkʋɛi a 'hʋɛ 'ye, ‑tɛ 'sɔyuo nu, 'ʋ kʋɔ o 'o tu 'yie 'mʋ.) ");
INSERT INTO ted_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","'Manʋ nyu wɛn a nue, 'ɩ saka ꞊nʋ. Nɛ‑ nue, 'ʋ 'kɩɛ 'dio wɛn ꞊wlʋ ye a kue, ‑ɛ mɔ, ɔ 'hrɩ 'klɔ. Nɛ‑ mɔ, bɔ po lɛ: «'Bɩa 'ba kɔɔ nɔ dididɛ ꞊de, ba ‑nye 'mʋ, 'mue di!» ");
INSERT INTO ted_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","'ʋ ‑ha 'le 'tɔpo‑hrin.e a ꞊tɩɔ, 'ʋ ‑nyo ꞊nɔ, ");
INSERT INTO ted_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","'ɔ klo gbo, 'ɔ dio, 'ke 'o ꞊nʋ ye. ");
INSERT INTO ted_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","‑Ye kɛ ɔɔ ꞊nʋ ye po: «‑Tɛ 'n 'kɩɛ nɩɛ o nɔ 'a mʋ ‑hɛyri, ‑tɩ ‑gbo, 'n ꞊tu o 'a mʋ ye, bɩ bi 'le 'a mʋ 'kwli 'mʋ. Kɛ 'n po o 'a mʋ ye: ‑Tɔplɩ 'bii ꞊nʋ, ʋ 'crɩɩ la 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, 'ke 'o 'na ‑ta 'mʋ, ɩ kɔ bɩ nue. 'Ɛ mɔ ‑tɛɛ, 'ɩ nue o. ‑Tɔplɩ a ‑gbɛ, 'ke ꞊ɩ ‑ye nɩ 'le Moise a teteicrɩɩnɩɛ 'kwli 'mʋ, kɔ, ꞊ɩ ‑ye 'ɩ nɩ ‑wɛ 'le winwlɔn‑hɛnyʋ ‑ye a 'crɩɩnɩɛi 'kwli 'mʋ, kɔ, ꞊ɩ ‑ye 'ɩ nɩ ‑wɛ 'le ‑wlabrecrɩɩnɩɛ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","‑Ye ɔ nue nɩ, 'ʋ yrii Nyɩsʋa a ‑tɩ a ‑gbɛ 'mʋ lɛ, ‑ɩ nɩ 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","‑Ye ɔ nɔ: «Kɛ Nyɩsʋa a wintɛɛ po: Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'a dakʋ ye ya, ɔ kɔ bɔ 'ye ꞊sʋɛ, kɔ, ɔ kɔ bɔ 'kʋ. 'Bɔ 'kʋ, 'a ‑nyrɔwɔ a ta a nɔnɔ 'mʋ, ɔ kɔ bɔ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, ɔ 'mʋ 'klɔ 'hrɩ. ");
INSERT INTO ted_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","'Plɩɩ Waanyɔ a ‑gbɛ a 'dʋ 'kwli 'mʋ, 'ke a di 'le Nyɩsʋa a ‑tɩ ꞊tuu. Nyɩsʋa a ‑tɩ a gbɛ, a di nahuin ye ꞊tu, ɩ nɩ‑ ‑gbo: Bʋ hie 'o 'waa dɛ 'kuku gbo, bʋ ‑nyi 'waa 'klɔ 'bii Nyɩsʋa, ‑ɛ die nu, ɔ 'mʋ 'waa dɛ 'kuku 'wʋwla. 'Bɩa 'baa Nyɩsʋa a ‑tɩ a ‑gbɛ ꞊tu, kɛ ba kʋɛ nɔ Jrusrɛdɩɔ 'mʋ gbo, kɔ, ba ꞊tui ‑wɛ dakʋ a gblegblei 'bii a nahuin ye, ‑ʋ nɩ nɔ 'klɔ ke. ");
INSERT INTO ted_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","'Be a 'ye o ‑tɔplɩ 'bii ꞊nʋ nɩ, ‑ɩ mue o 'lu ‑wɔn. 'A ‑tɩ 'klɛɛ, ba mu, ba ꞊tu 'na ‑tɩ nahuin 'bii ye. ");
INSERT INTO ted_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","'Na Bu Nyɩsʋa pui la 'le ꞊le, ‑ɛ mɔ, ɔ di 'a mʋ ‑nyi 'a ‑Hihiu. 'Na ‑gbɛ, 'mɔ di 'a mʋ ‑Hihiu a ‑gbɛ ye ya. Kɛɛ ‑ye a ‑mɛ ‑ye, kɛ ba nɩ nɔ 'dɩɔ ‑gbo 'mʋ gbo, ‑Hihiu a ‑gbɛ, ʋ 'mʋ 'le yrayrɩ 'mʋ ‑hɔn, ʋ 'mʋ 'o 'a mʋ ke 'mʋ bi, ʋ 'mʋ 'a mʋ 'klɩ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Dɛ a ‑gbɛ bɛ ‑hi, ‑ye ‑Yusu gba 'a ‑naagbopʋ nɩ, 'ʋ ꞊tɩ Jrusrɛ 'mʋ, 'ʋ mu 'le 'dɩɔ ꞊nʋ ꞊hlɔn, ʋʋ Betani daa. ‑Tɛ ʋ nyre 'klɛɛ 'o 'hru a ‑hɛyri 'mʋ, ‑ye ɔ po dabʋɩ yrayrɩ, 'ɔ nyu wa ‑wɔn po. ");
INSERT INTO ted_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɔ nɩ 'le 'pʋprɛ 'kwli 'mʋ, 'ɔ ‑hɔn 'o ꞊nʋ 'hʋɩn 'mʋ, 'ɔ mu 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","'A ‑naagbopʋ ‑mɛ ‑ye, ʋ bla gbo kwlɩ, 'ke 'o 'a ‑tɩ a 'yi'bʋaalɛ a ‑ta 'mʋ. 'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ʋ ꞊hɩan ‑wɔn, 'ʋʋ 'le Jrusrɛ 'mʋ mu, 'ke 'le 'manʋkɔ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","'Ke 'le Jrusrɛ 'mʋ, ʋ 'cipi 'le Nyɩsʋa a 'kagblaka gbo nɩ, 'ʋʋ Nyɩsʋa 'nyrɛɛ lɛ pue.");
INSERT INTO ted_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","2","Ye‑hɛ‑nyrɛ 'mʋ, 'plɩɩ Nyɩsʋa 'mʋ la 'ɛ nɩ dɛ mu nu, nahuon ‑gbo, ‑ɔ mɔ Nyɩsʋa a Wintɛ, ɔ nɩ la 'klɔ. 'Ke ɔ nɩ la 'o Nyɩsʋa 'hʋɩn 'mʋ. 'A ‑gbɛ, ɔ mɔ ‑wɛ Nyɩsʋa'a nɩ. ");
INSERT INTO ted_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nɔ‑ kɔ 'mʋ Nyɩsʋa naa 'le, 'ɔ nu 'ɛ nɩ dɛ. Ɛ 'de dɛ ꞊de kɔ, Nyɩsʋa bɔ nu, bɔ 'de 'le ꞊nɔ 'mʋ naa. ");
INSERT INTO ted_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nahuon a ‑gbɛ, nɔ‑ɔ nahuin 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. 'Klɔ yrayrʋ a ‑gbɛ, nɔ‑ɔ nahuin ‑nyrɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","‑Nyrɛ a ‑gbɛ, ɛɛ 'nɩ wlɩn, 'ke 'le gbɩgbɩyrɩ ‑hɛyri, ‑ye gbɩgbɩyrɩ 'de 'klɩ kɔ, 'ke bɩ jre ‑nyrɛ a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Ɛ kɔ la nahuon ꞊de. 'A 'dʋ mɔ Saan Batisɩ. Nɔ‑ Nyɩsʋa lee la, ");
INSERT INTO ted_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","'ke bɔ ꞊tu ‑nyrɛ a ‑gbɛ a ‑tɩ nahuin ye, nahuin 'mʋ Nyɩsʋa a Wintɛ ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Saan a ‑gbɛ, ɔ 'de la ‑nyrɛ a ‑gbɛ, kɛɛ, ɔ di la 'le ꞊le, 'ke bɔ ꞊tu la ‑nyrɛ a ‑gbɛ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","‑Nyrɛ a ‑gbɛ, nɛ‑ mɔ la ‑tɛɛ a ‑nyrɛ, ‑ɛ di la nɔ 'klɔ ke, ‑ɛ die nu, nahuin 'bii 'mʋ lɛ yrii. ");
INSERT INTO ted_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nahuon a ‑gbɛ, ‑ɔ mɔ Nyɩsʋa a Wintɛ, 'ɛ mɔ ‑tɛɛ, nɔ‑ kɔ 'mʋ Nyɩsʋa naa 'le, 'ɔ nu 'klɔ, kɛɛ, ‑tɛ ɔ di la nɔ 'klɔ ke, 'klɔ ke a nahuin 'dio la yrii. ");
INSERT INTO ted_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔ di la nɔ 'a ‑gbɛ a dakʋ ‑wɔn, ‑ʋ mɔ ‑Juukʋɛ, kɛɛ, ʋ 'dio la kwa 'ble. ");
INSERT INTO ted_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kɛɛ, 'ke 'le ꞊nʋ ‑hɛyri, nahuin ‑ye 'blo kwa, 'plɩɩ 'ʋ kuo ꞊wlʋ ye. Nahuin a ‑gbɛ, ‑ʋ kuo ꞊wlʋ ye, ɔ ‑nyi ꞊nʋ 'hru, 'ke bʋ ‑hɛ Nyɩsʋa a 'yuo. ");
INSERT INTO ted_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ʋ 'de Nyɩsʋa a 'yuo ‑hɛ, ‑tɛ ‑tʋnahuon, ɔɔ nu, 'ɔɔ 'a bu a 'yu 'mʋ 'ya. Kɛɛ, Nyɩsʋa a ‑gbɛ, nɔ‑ɔ nɩ, ‑ɔ ‑nyi ꞊nʋ 'klɔ yrayrʋ. ");
INSERT INTO ted_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nahuon a ‑gbɛ, ‑ɔ mɔ Nyɩsʋa a Wintɛ, ɔ ‑hɛ ‑tʋnahuon, 'ɔ 'ti la nɔ ‑a mʋ ‑gbahlɔn, ꞊a 'ye 'a ‑tɩ a 'yi'bʋbʋa, ‑ɛ mɔ ‑tɩ a 'yi'bʋbʋa ꞊nʋ, Nyɩsʋa ‑nyi 'a 'Yuu ‑do. 'Mʋnʋɛlɛ kɔ wɔlɩ a yeyriilɛ, kɔ ‑tɩ a ‑tɛɛ, nɩ‑ 'yii la 'le ꞊nɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nahuon a ‑gbɛ, nɔ‑ kɔ ‑tɩ Saan ꞊tu la 'ke 'o nahuin ye. Kɛ ɔɔ la po: «Nɔ‑ di 'o 'mʋ ke 'mʋ kʋɛ, kɛɛ, nɔ‑ nɩ 'o 'mʋ 'lu ye, ‑ɛ nue, 'plɩɩ ʋ 'mʋ 'mʋ kɔ, ɔ nɩ la 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nahuon a ‑gbɛ, ɔ 'cipi 'o, 'ɔɔ ‑a mʋ ꞊hapʋ‑tɔplɩ 'mʋ nu, 'ke 'le ‑gbʋgbɛkɔ 'kwli 'mʋ. ꞊Hapʋ‑tɔplɩ, ɔ nu ‑a mʋ 'mʋ, ɩ ‑huo 'dɔ. ");
INSERT INTO ted_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nahuon a ‑gbɛ, nɔ‑ mɔ ‑Yusu 'Klɩsʋ. 'Ke 'le Nyɩsʋa a winwlɔn‑hɛnyɔ Moise 'mʋ, 'ke Nyɩsʋa naa 'le, 'ɔ ‑nyi ‑a mʋ 'a tetei, kɛɛ, 'ke 'le ‑Yusu 'Klɩsʋ 'mʋ, 'ke ɔ naa 'le, 'ɔ nu ‑a mʋ ꞊hapʋdɛ 'mʋ, 'ke 'le ‑gbʋgbɛkɔ 'kwli 'mʋ, 'ɔ tɔɔ ‑a mʋ ‑tɩ a ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","꞊Ɔ ꞊de 'de ‑hlɩn Nyɩsʋa a 'yee. Kɛɛ, 'a 'Yuu ‑do ꞊nʋ, ‑ɔ mɔ ‑wɛ Nyɩsʋa, 'plɩɩ ‑ɔ nɩ 'o ‑a nɩ Bu Nyɩsʋa 'hʋɩn 'mʋ, nɔ‑ tɔɔ ‑a mʋ Nyɩsʋa a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","‑Nyrɔwɔ ꞊de 'mʋ, ‑Juukʋɛ a 'blʋ a nahuin, ‑ʋ nɩ 'le Jrusrɛdɩɔ 'mʋ, nʋ‑ le Nyɩsʋa a ‑cɔhlʋnpinyʋ kɔ Lefipʋ a ꞊tugba a nahuin, 'ke bʋ mu 'le Betanidɩɔ 'mʋ, 'ke bʋ ꞊gba Saan wlɔn, nahuon tio‑ ɔ 'ya 'mʋ. ‑Tɛ ʋ nyre 'le Saan ‑wɔn, ʋ nɔ: «꞊Be ‑mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya?» ");
INSERT INTO ted_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","‑Ye ɔ ‑hɩhɩʋ klɛ, 'ke 'le ‑tɛɛkɔ 'kwli 'mʋ, ɔ nɔ: «'Ʋʋn, 'n 'de Waanyɔ a ‑gbɛ, ‑ɔ kɔ ‑tɩ aa ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Kɛ ʋʋ lele po, ʋ nɔ: «꞊Be ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ Eli'i nɩ?» Ɔ nɔ: «'Ʋʋn, ɛ 'de ‑wɛ 'mɔ.» ‑Ye ʋ ꞊gbɔ lele wlɔn, ʋ nɔ: «'A ‑tɩ, ꞊be ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ gblaka ꞊nʋ, Moise po la lɛ, Nyɩsʋa di la 'le ya?» ‑Ye ɔ nɔ: «'Ʋʋn, 'n 'de winwlɔn‑hɛnyɔ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","‑Ye ʋ 'kɩɛ ꞊gbɔɔ wlɔn lɛ: «Nahuon tio‑ ‑n 'ya 'klɛɛ 'mʋ 'le? ‑Hɩhɩa ‑a mʋ klɛ, ‑ɛ die nu, nahuin ‑gbo, ‑ʋ lee ‑a mʋ, ‑a 'mʋ 'waa klɛ‑hɩhɩalɛ yi, nahuon tio‑ ‑n 'ya 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","‑Ye kɛ ɔɔ po: «Nyɩsʋa a winwlɔn‑hɛnyɔ Esai, ɔ 'crɩɛ la nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Nyɩsʋa nɔ 'nɩ: Nahuon ꞊de, 'ke ɔ di 'le ‑tɛgbi ꞊nʋ 'ti, nahuin ꞊de 'de 'le 'ti. Nahuon a ‑gbɛ, 'bɔɔ 'prɛ, ɔ 'mʋ 'le win 'yaa. Kɛ ɔ di nahuin ꞊nʋ ye po, ‑ʋ dio nʋa ye gbo po: Ba 'sii 'o Kʋkɔnyɔ a 'hru ye, 'plɩɩ Kʋkɔnyɔ a ‑gbɛ, ɔ 'mʋ 'le di. Ɛ 'we ꞊nɔ ye, 'a nɩ 'klɔ bɔ 'sii 'o ye, ‑ɛ die nu, a 'mʋ ‑wɔn ‑wɛ, 'plɩɩ Kʋkɔnyɔ 'mʋ 'le di ‑o.» Kɛ Saan, ɔɔ lele leenyʋ a ‑gbɛ ye po: «Nahuon ꞊nʋ, ‑ɔ kɔ ‑tɩ Nyɩsʋa ꞊tu la, 'mɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Leenyʋ ꞊nʋ, ‑ʋ di 'le Saan ‑wɔn, 'ke 'le ꞊nʋ ‑hɛyri Falisi꞊tumu a nahuin nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Kɛ ʋʋ 'klɛɛ po, 'ʋʋ Saan wlɔn ꞊gba, ʋ nɔ: «‑N nɔ 'nɩ, ‑n 'de Waanyɔ ꞊nʋ, Nyɩsʋa plɛ, ɔ di la 'le ya, kɔ, ‑n 'de Eli, kɔ, ‑n nɔ 'nɩ, ‑n 'de ‑wɛ Nyɩsʋa a winwlɔn‑hɛnyɔ ꞊nʋ, ‑ɔ kɔ ‑tɩ Moise ꞊tu la. 'A ‑tɩ, nyɔ‑ ‑nyi 'klɛɛ ‑mʋ 'klɩ, 'ke ‑bo po nahuin 'nie 'lu lɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","‑Ye ɔ nɔ: «'Mɛ ‑ye, 'nie, nɛ‑ 'nɩɩ nahuin 'lu lɛ po, kɛɛ, 'ke 'le 'a mʋ ‑hɛyri, nahuon nɩ 'le. Nahuon a ‑gbɛ, a 'dio a yie. ");
INSERT INTO ted_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ti ꞊nʋ ‑kɔ 'yri 'n di 'o ‑kʋan 'lu ‑yra, 'ke nahuon a ‑gbɛ, ɔ di 'a ‑kʋan ‑wlu ꞊tu, kɛ nɔ 'a mʋ ‑hɛyri. 'Na ‑gbɛ, 'n 'de nyɔ ꞊de, ꞊bo dio 'mʋ ‑hɛ, 'ke 'o 'ɛ nɩ ‑kʋandɛ ꞊de a ‑ta 'mʋ.» Kɛ Saan po leenyʋ a ‑gbɛ ye. ");
INSERT INTO ted_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","‑Tɔplɩ 'bii a ‑gbɛ, 'ke 'le 'dɩɔ ꞊nʋ, ‑ɔ mɔ Betani 'mʋ, 'ke ɩ mue 'le 'lu ‑wɔn. 'Dɩɔ a ‑gbɛ, 'ke ɔ nɩ 'le 'nie ꞊nʋ, ‑ɛ mɔ Sudɛn a 'nike. 'Ke Saan, ɔɔ 'le nahuin 'nie 'lu lɛ po. ");
INSERT INTO ted_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","‑Tɛ ‑nyrɔwɔɔ ‑do ‑hi, ‑ye Saan 'ye ‑Yusu nɩ, ‑Yusu a ‑gbɛ 'ɔɔ 'le ꞊nɔ ‑wɔn mu. ‑Ye Saan nɔ: «Ba 'ye kɛ, nahuon ‑gbo, ‑ɔɔ 'le di, nɔ‑ mɔ ‑cɔhlʋn ꞊nʋ, Nyɩsʋa ‑ha, ‑ʋ 'we ꞊nɔ 'blayu ye, ʋʋ Nyɩsʋa pie. ‑Cɔhlʋn a ‑gbɛ, nʋ‑ di 'klɔ ke a nahuin a dɛ 'kuku 'wʋwla. ");
INSERT INTO ted_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nɔ‑ kɔ ‑tɩ 'n ꞊tu o, ‑ɛ mɔ: Nahuon di 'o 'mʋ ke 'mʋ kʋɛ, kɛɛ, nɔ‑ nɩ 'o 'mʋ 'lu ye, ‑ɛ nue, 'plɩɩ ʋ 'mʋ 'mʋ kɔ, ɔ nɩ la 'klɔ. ");
INSERT INTO ted_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","‑Tɛ 'n nyi o ꞊tu, nahuon bɔ di o 'mʋ 'ya, 'n 'dio o yi. Kɛɛ, 'n di 'le ꞊le, 'mʋ nahuin 'nie 'lu lɛ po, ‑ɛ die nu, nahuon bɔ 'ya, dakʋ, ‑ʋ mɔ Yisraɛkʋɛ, ʋ 'mue yi.» ");
INSERT INTO ted_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","‑Ye kɛ Saan, ɔɔ lele po: «Nahuon bɔ di o 'mʋ 'ya, ‑tɛ 'n 'dio o a yie, ‑ye Nyɩsʋa ꞊nʋ, ‑ɔ lee 'mʋ, 'ke ꞊bo di nahuin 'nie 'lu lɛ po, ɔ nɔ: ‑N di 'ye 'na ‑Hihiu, ʋ 'mʋ 'o nahuon ꞊de 'lu ꞊tɩɩ, ʋ 'mʋ 'o ꞊nɔ ke 'mʋ nɩ. Nahuon a ‑gbɛ, nɔ‑ di nahuin 'na ‑Hihiu ‑nyi. ‑Ye 'ɛ mɔ ‑tɛɛ, 'n 'ye o Nyɩsʋa a ‑Hihiu a ‑gbɛ nɩ, 'ʋ ꞊tɩɩ o 'o nahuon a ‑gbɛ 'lu, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑plija, bɔ 'nɩnɩ ꞊tɩɩ o 'o ꞊nɔ 'lu, ʋ 'mʋ o 'o ꞊nɔ ke 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","'N 'ye dɛ a ‑gbɛ nɩ, nɛ‑ nue, 'nɩ nyi ꞊tu, ‑ɛ mɔ, nahuon a ‑gbɛ, nɔ‑ mɔ Nyɩsʋa a 'Yu.» ");
INSERT INTO ted_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ‑tɛgbii ‑do a ‑gbɛ, 'ke Saan Batisɩ di 'o lele, ɔ kɔ 'a ‑naagbopʋʋ 'hɔn ‑ye 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","'Ke ɔ nɩ 'o, ‑ye ɔ 'ye ‑Yusu nɩ, 'ɔɔ ‑hi. ‑Tɛ ɔ 'yo 'klɛɛ, ‑ye ɔ nɔ: «Ba 'ye kɛ, nahuon ‑gbo, ‑ɔɔ 'le di, nɔ‑ mɔ ‑cɔhlʋn ꞊nʋ, Nyɩsʋa ‑ha, ‑ʋ 'we ꞊nɔ 'blayu ye, ʋʋ Nyɩsʋa pie.» ");
INSERT INTO ted_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","‑Tɩ a ‑gbɛ, Saan ꞊tu, 'a ‑naagbopʋʋ 'hɔn ‑ye, ‑ʋ nɩ ‑tuo ke, ʋ 'wɩn nɩ. ‑Tɛ ʋ 'wɩn 'klɛɛ, ‑ye ʋ 'ba 'mʋ ye, 'ʋ kʋɛ ‑Yusu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","‑Ye ‑Yusu a ‑gbɛ, ɔ ꞊hɩan ‑wɔn. Bɔ 'ye 'klɛɛ, ‑ɛ mɔ, ʋ nyo ‑wɔn 'nɩ kʋɛ, ‑ye ɔ nɔ: «꞊Be ɩ kla nɩ, ‑ɛ kɔ 'mɔ aa ‑wɔn kʋɛ 'le?» ‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «‑Be' ‑n 'tii ye 'le, Rabi?» ‑ɛ ꞊hɛn 'nyrɛ Tɔɔnyɔ, 'ke 'le ‑Juukʋɛ a 'briwin 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","‑Ye ɔ nɔ: «Ba kʋɛ 'mʋ ‑wɔn, a di dɛ 'nɩ 'ye,» 'ʋ kʋɔ ‑wɔn, ‑tɛgbi ɔ nɩ 'o, 'ʋ 'yee 'o. Ʋ nyre 'o 'yrʋ‑hiilɛ a ti 'yri. 'Ke ʋ nɩ 'o ꞊nɔ 'hʋɩn 'mʋ ‑nɩnɩ, 'tɔ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","‑Naagbopʋʋ 'hɔn a ‑gbɛ, ‑ʋ 'wɔn Saan a ‑gbɛ a win, 'plɩɩ ‑ʋ kʋɛ ‑Yusu ‑wɔn, ꞊ɔ ‑ye a 'dʋ mɔ Adre. Adre a ‑gbɛ, ɔ mɔ Simɔ Piɛlɩ a ‑dɩayuu nɩ. ");
INSERT INTO ted_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, Adre a ‑gbɛ 'ɔ mu 'le, 'ke 'le 'a ‑dɩayu Simɔ Piɛlɩ ‑wɔn, ɔ nɔ: «‑A 'ye Waanyɔ ꞊nʋ nɩ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, 'ke 'o 'a dakʋ a waalɛ a ‑ta 'mʋ,» ");
INSERT INTO ted_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","'ɔ gbɔ 'le ‑Yusu 'hʋɩn 'mʋ. ‑Yusu bɔ 'yo 'klɛɛ, ‑ye ɔ nɔ: «‑Mɔ mɔ Simɔ, Saan a 'yu. Kʋɛ 'klɛɛ mɔ gbo, 'bʋʋ ‑mʋ da, kɛ ʋ di po: Sefasɩ.» Sefasɩdʋ a ‑gbɛ, nʋ‑ mɔ Piɛlɩ, ‑ɛ ꞊hɛn 'nyrɛ 'hɩɔ. ");
INSERT INTO ted_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ‑Yusu pue 'le ꞊le, 'ke bɔ mu 'le Galileblʋgba 'mʋ. ‑Tɛ ɔɔ mu, ‑ye ɔ kɔ nahuon ꞊de 'hɛɛn, ʋ ꞊ŋmoo nɩ. Nahuon a ‑gbɛ, 'a 'dʋ mɔ Filipʋ. ‑Yusu nɔ: «Kʋɛ 'mʋ ‑wɔn, ꞊mʋ 'na ‑naagbopʋyu ‑hɛ,» 'ɔ kʋɛ ꞊nɔ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipʋ a ‑gbɛ, 'ke ɔ kɔ 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Bɛtɩsaida, ɔ kɔ Adre kɔ Piɛlɩ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye 'ke Filipʋ mu 'le nahuon ‑ye ‑wɔn. Nahuon a ‑gbɛ, 'a 'dʋ mɔ Natanaɛlɩ. ‑Ye Filipʋ nɔ: «‑A 'ye Waanyɔ ꞊nʋ nɩ, ‑ɔ kɔ ‑tɩ Moise kɔ Nyɩsʋa a winwlɔn‑hɛnyʋ ‑ye, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ. Waanyɔ a ‑gbɛ, 'a 'dʋ mɔ ‑Yusu. 'A bu, nɔ‑ mɔ Sosɛfʋ, ‑ɔ nɩ 'le Nasalɛtɩdɩɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaɛlɩ nɔ: «Nasalɛtɩdɩɔ 'mʋ, ꞊hapʋnahuon ꞊de 'die 'le ‑wɛ bɔ ‑hɔn 'le 'mʋ.» Filipʋ nɔ: «Di 'le ‑ba mu, ‑na ‑gbɛ, ꞊muo 'ye.» ");
INSERT INTO ted_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Bʋ nyo 'klɛɛ yrɛ 'mʋɛɛ, ‑Yusu bɔ 'yo 'klɛɛ, ‑ye ɔ nɔ: «Nahuon ‑gbo, ‑ɔɔ 'le di, ɔ 'sii 'o ye. Ɔ mɔ ‑tɛɛ a Yisraɛkʋɛyuu nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","‑Ye Natanaɛlɩ nɔ: «‑Be' ‑n nu 'na yiyie 'le?» ‑Ye ɔ nɔ: «‑Tɛ ‑n nɩ wɛn 'o pepetu ꞊nʋ gbo, ʋʋ figie daa, 'plɩɩ Filipʋ 'mʋ wɛn ‑mʋ da, 'ke 'n 'yee wɛn 'o ‑mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","‑Ye Natanaɛlɩ nɔ: «Tɔɔnyɔ o, 'ɛ mɔ ‑tɛɛ, ‑mɔ mɔ Nyɩsʋa a 'Yuu nɩ, ꞊nɩ mɔ ‑wɛ Yisraɛkʋɛ a bodɩɔ.» ");
INSERT INTO ted_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","‑Ye ɔ nɔ: «꞊Be ‑tɛ 'n po lɛ, 'n 'ye wɛn ‑mʋ nɩ, 'ke 'le pepetu gbo, nɛ‑ kɔ ‑tɩ ꞊nɩ plɛ, ‑n kuo 'mʋ ye ꞊wlʋ? Nu gbe, ‑n di 'ye ‑tɔplɩ gblakɩ ‑ye, ɩ 'mʋ 'o dɛ ‑gbo 'mʋ ‑hi, ‑n 'ye kɛ.» ");
INSERT INTO ted_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","‑Ye ɔ nɔ lele: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, a di yakɔ 'nɩ 'ye, ɔ 'mʋ wlɔn ‑ki, Nyɩsʋa a lɛleenyʋ 'mʋ 'le ꞊nɔ ‑wɔn 'mʋ ‑hɔn, ʋ 'mʋ 'ya, ʋ 'mʋ ꞊tɩ 'ke 'o 'mʋ 'lu ye, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon.» ");
INSERT INTO ted_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","‑Nyrɔwɩɩ 'hɔn bɩ ‑hi, ‑ye 'blɩ a 'mʋpʋpa a lɛ'mimre, nɛ‑ɛ 'le 'lu ‑wɔn mue, 'ke 'le Galileblʋgba a 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Kana. 'Ke ʋ da 'le ‑Yusu a 'dii, ");
INSERT INTO ted_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","'ʋ da ‑wɛ ‑Yusu, 'ke 'le 'blɩ'mʋpʋpa a ‑gbɛ ke. ");
INSERT INTO ted_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tii ‑do a ti 'yri, ‑ye 'nɩnanɔ, ʋʋ 'na, ɔ ‑wɛ nɩ. ‑Ye kɛ ‑Yusu a 'dii nyo ye po, ɔ nɔ: «Nɔ 'bii, ɔ ‑wɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kɛ ‑Yusu nyo 'klɛɛ ye po, ɔ nɔ: «'Na 'dii o, ‑ha 'mʋ mɛ lɛ, ɛ 'de ‑mɔ, ‑n 'de ye blɛ ‑bo le 'mʋ, ‑kʋan tio‑ 'n kɔ ꞊bo nu. Ti ꞊nʋ ‑kɔ 'yri 'n kɔ ꞊bo nuu 'o 'ŋmilɛkadɛ, ɩ 'de wɛn 'o a nyree.» ");
INSERT INTO ted_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Bɔ po 'klɛɛ lɛ, ‑ye ‑tɔplɩwonyʋ, ‑ʋ nɩ 'o, ‑Yusu a 'dii, ɔ nyu 'nɩ le, ɔ nɔ: «‑Tɩ 'bii ‑gbo, ɔ di ꞊tu, nɩ‑ ba nu ‑o!» ");
INSERT INTO ted_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kɛɛ ‑ye yɩ gblakɩɩ ‑huonnɔ ꞊de nɩ 'o, ʋ nuu 'hɛ 'mʋ, ‑ɩ kɔ wlɔn ʋʋ 'le 'nie lɛ po, 'ke 'o bʋɩ a lɛyɩyra a ‑ta 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑Juukʋɛ a teteii 'a ‑hʋhʋa nu. Yɩ a ‑gbɛ, 'a yaa ‑do, ɔɔ gba 'litayrɩɛi a ꞊wlɩɩ ꞊hun. ");
INSERT INTO ted_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Kɛ ‑Yusuu ‑tɔplɩwonyʋ a ‑gbɛ ye po, ɔ nɔ: «Ba 'yie 'le yɩ ꞊nʋ lɛ, 'ke 'o 'nie ‑wɔn!» 'ʋ 'yii 'le lɛ ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","‑Ye ɔ nɔ: «Ba 'pi 'klɛɛ 'a dɛ gbi, ba gbɛ ‑tɔplɩwonyʋ a nyɩgblaka ye!» 'ʋ gbɛ 'le, 'ɔ ꞊tʋɛ wlɔn. ");
INSERT INTO ted_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Bɔ ꞊tʋɛ 'klɛɛ wlɔn, ‑ye ɛ ‑hɛ nɔ. Ɔ 'de 'o yii, ‑tɛ nɔ a ‑gbɛ bɔ ‑hɔn 'o 'mʋ. ‑Tɔplɩwonyʋ ‑mɛ ‑ye, nʋ‑ yi. ‑Ye nyɩgblaka a ‑gbɛ, ɔ da 'blɩ'mʋpanyɔ nɩ, ");
INSERT INTO ted_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ɔ nɔ: «'Ɛ nɩ nahuon 'bɔ da lɛ'mimre, ꞊hapʋnɔ, nɔ‑ ʋʋ po ‑tɩtɛ. Nahuin 'bʋ 'na 'klɛɛ ‑tɛɛ, 'plɩɩ nɔ ꞊nʋ, ‑ɔ 'de ‑tɛɛ a nɔ, 'ʋ nyo ‑wɛ po. Kɛɛ, ‑mɛ ‑ye, kʋɛ wɛn 'le gbo, ꞊hapʋnɔ, nɔ‑ ‑n ꞊tu gbo.» ");
INSERT INTO ted_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kɛ'ɛ nɩ, ‑Yusu nu 'a ye‑hɛŋmilɛkadɛ a nunue, 'ke 'le Galileblʋgba a 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Kana. Kɛ ɔ nu, 'ɔ tɔɔ 'a ‑naagbopʋ 'klɩ ꞊nʋ, Nyɩsʋa ‑nyi ꞊nɔ. Dɛ a ‑gbɛ, nɛ‑ nue, 'a ‑naagbopʋ a ‑gbɛ 'ʋ kuo ꞊wlʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ɔ mu 'le Kapɛnaɔdɩɔ 'mʋ, ɔ kɔ 'a 'dii kɔ 'a ‑dɩayuo, kɔ 'a ‑naagbopʋ 'hɛɛn ‑wɛ, ‑ɛ die nu, ʋ 'mʋ 'le ‑nyrɔwɩ gbi ‑hi. ");
INSERT INTO ted_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Juukʋɛ a lɛ'mimre gblaka, ʋʋ Pakɩ daa, ɛ 'mʋɛɛ ye. Nɛ‑ nue, ‑Yusu 'ɔ mu 'le Jrusrɛdɩɔ 'mʋ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","‑Tɛ ʋ nyre 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ke ɔ yɛ 'o puplonyʋ gbo, 'ʋʋ bro plo, kɔ blablɔ, kɔ ‑plijɩ 'hɛɛn, 'ke ‑tʋnahuin 'mui ‑tɔ, ‑cɔhlʋn a ‑tɩ. 'Ke ɔ yɛ ‑wɛ 'o 'wli'cɩcɩnyʋ gbo, 'ʋʋ pʋpʋwli 'cɩcɩ, 'ʋ nɩ 'le 'waa 'teblei ke 'mʋ gblɛ. ");
INSERT INTO ted_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","‑Tɛ ‑Yusu 'yu, nɛ‑ mɔ bɔ nu lɔkɔ, bɔ blʋ lɛ 'bii, 'ʋ ‑hɔn 'le Nyɩsʋa a 'kagblaka a ‑yaa a ‑gbɛ 'mʋ, ʋ kɔ 'waa 'wlugba‑tɔplɩ a ‑gbɛ 'hɛɛn, 'plɩɩ, 'wli'cɩcɩnyʋ a 'wli, 'ɔ 'wlɩ gbo, 'ke 'o ‑tʋtʋ ke, 'ɔ ꞊jri 'waa 'teblei ye gblɛ. ");
INSERT INTO ted_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","‑Ye kɛ ɔɔ ‑plijɩplonyʋ ꞊nʋ ye po: «Ba ‑ha nɔ ‑tɔplɩ ‑gbo! A nɩ nuu 'le 'na Bu Nyɩsʋa a kayu puplokayu 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","‑Yusu a ‑naagbopʋ, ‑ʋ nɩ 'o, ‑tɩ ꞊nʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ye ɩ bi 'le ꞊nʋ 'mʋ 'kwli. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «Nyɩsʋa o, 'n nʋɛ ‑na kayu 'mʋ nɩ 'dɔ. ‑Tɛ 'n nu 'a 'mʋnʋɛlɛ, ɛ 'we ꞊nɔ na ye, ‑ɔɔ wlɩn, 'ke 'le 'mʋ 'mʋ, ‑ɔɔ 'mʋ lɛ hien.» ");
INSERT INTO ted_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","‑Ye ‑Juukʋɛ a nyɩgblakɩ, ‑ʋ nɩ ‑tuo ke, ʋ ꞊gbɔ wlɔn, ʋ nɔ: «Nahuon a gblo tio‑ ‑n 'ya 'le, ꞊nɩ nyu lɛ bla? Nu 'ŋmilɛkadɛ, ɛ 'mue ‑a mʋ tɔɔ, ‑ɛ mɔ, 'klɩ ꞊nʋ, ‑ɩ kɔ 'kwli 'mʋ ‑n nyu 'le lɛ blaa, 'ke ɩ kʋɛ 'le Nyɩsʋa 'mʋ gbo.» ");
INSERT INTO ted_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Dɛ 'n di nu, nɛ‑ ‑gbo: Ba 'wla Nyɩsʋa a 'kagblaka ‑gbo, 'n diu lele ye 'mʋ 'nɩ 'ba, 'ke 'le ‑nyrɔwɩɩ ta 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","‑Ye ʋ nɔ: «꞊Be kayu ‑gbo, ʋ po, 'ke 'le 'yrɩ a (46) ‑wlɩɩ 'hɔn ꞊tu 'o ‑huonnɔ 'kwli 'mʋ, nʋ‑ ‑n plɛ, ‑n di ye 'mʋ 'ba, 'ke 'le ‑nyrɔwɩɩ ta 'kwli 'mʋ?» ");
INSERT INTO ted_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kɛɛ ‑ye Nyɩsʋa a 'kagblaka ꞊nʋ, dɛ ɔ ꞊hɛn 'nyrɛ, ɛ nɛ‑ mɔ 'a ‑plahʋɩn. ");
INSERT INTO ted_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","‑Tɛ 'dai ti ‑hi, ‑tɛ ɔ 'kʋ, ti ꞊nʋ ‑kɔ 'yri ɔ 'hrɩ 'klɔ, ti a ‑gbɛ 'yri, 'kee nɩ, ɩ bi 'le 'a ‑naagbopʋ 'kwli 'mʋ, ‑ɛ mɔ, 'a ‑plahʋɩn a ‑tɩ ɔɔ la ꞊tu, ɛ 'de Nyɩsʋa a 'kagblaka, ɔ 'dio la 'nyrɛ ꞊hɛn. ‑Ye ‑tɩ ꞊nʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ye‑hɛ‑nyrɛ 'mʋ, ʋ kui 'klɛɛ ye ꞊wlʋ, ɩ kɔ ‑tɩ 'bii ꞊nʋ 'hɛɛn, ‑Yusu ꞊tu la ꞊nʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ti ꞊nʋ ‑kɔ 'yri ‑Yusu 'kɩɛ nɩɛ 'le lɛ'mimre ꞊nʋ ke, ‑ɛ mɔ Pakɩ, 'ke 'le Jrusrɛdɩɔ 'mʋ, ɔɔ nu 'ŋmilɛka‑tɔplɩ ‑huohui. Nahuin 'plɔplɔ bʋ 'ye 'ŋmilɛka‑tɔplɩ a ‑gbɛ, ɛ nɛ‑ nue, 'ʋ pui ‑tɛɛ, ‑ɛ mɔ, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya. ");
INSERT INTO ted_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kɛɛ, ‑Yusu 'diu ꞊wlʋ ye kuo, ‑ɛ nue, ‑tɛ 'waa ꞊wlɩ nɩ 'mʋ, ɔ yie nɩ ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","‑Yusu 'nɩ ‑hʋɛ ꞊le, 'ke nahuon ꞊de bɔ lo, ‑tɛ ‑tʋnahuin a ꞊wlɩ nɩ 'mʋ, ‑ɛ nue, 'a ‑gbɛ, ɔ yi ‑tɔplɩ 'bii ꞊nʋ nɩ, ‑ɩ nɩ 'le ‑tʋnahuin a ꞊wlɩ ke. ");
INSERT INTO ted_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Ɛ kɔ la nahuon ꞊de. 'A 'dʋ mɔ la Nikodɛmʋ. Ɔ mɔ la Falisi꞊tumu a nahuoon nɩ. Ɔ mɔ ‑wɛ ‑Juukʋɛ a ye'mʋnaanyɔ ‑yee nɩ. ");
INSERT INTO ted_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","'Tɔyrʋwɔ ꞊de 'mʋ, nɔ‑ mu 'le ‑Yusu ‑wɔn, ɔ nɔ: «Tɔɔnyɔ, ‑a yie nɩ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ lee nɔ ‑mʋ ‑a mʋ ‑hɛyri, ꞊mʋ ‑a mʋ tɔɔ, ‑ɛ nue, 'ŋmilɛka‑tɔplɩ ꞊nʋ, ‑nɩɩ nu, ꞊ɔ ꞊de 'de 'le 'a nunue 'le ‑wɛ, 'bɩa Nyɩsʋa 'bɔ 'de 'o ꞊nɔ ‑wɔn nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","‑Ye ‑Yusu nɔ: «'Nɩɩ ‑mʋ 'nɩ le ‑tɛɛ, nahuon ꞊de 'die 'le ‑wɛ bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ, 'bɔ 'de kʋɛwɩɩ 'hɔn nu.» ");
INSERT INTO ted_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","‑Ye Nikodɛmʋ nɔ: «‑Tʋnahuon 'bɔ ku, ‑be' ɔ ‑wɛ 'le bɔ nu 'a kʋɛwɩɩ 'hɔn a nunue 'le? Ɛ 'die 'le ‑wɛ bɔ bi 'le lele 'a 'dii 'kwli 'mʋ, ʋ 'muo lele kɔ.» ");
INSERT INTO ted_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","‑Ye ɔ nɔ: «'Nɩɩ ‑mʋ 'nɩ le ‑tɛɛ, nahuon 'bɔ nu kʋɛwɔɔ ‑do, ɔ 'die 'le ‑wɛ bɔ pa 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ. Kɛɛ, ɛ nye 'nɩ ‑hʋa, 'ke Nyɩsʋa a ‑Hihiu bʋ ‑nyi ꞊nɔ 'klɔ yrayrʋ, 'plɩɩ ɔ 'mʋ 'le Nyɩsʋa a 'klɔ yrayrʋ ꞊nʋ 'kwli 'mʋ pa. ");
INSERT INTO ted_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","‑Tʋnahuin, nʋ‑ nye nu, 'ʋʋ ‑tʋnahuon yrayrʋ kɔ, kɛɛ, Nyɩsʋa a ‑Hihiu, nʋ‑ nye nu, ‑tʋnahuon 'ɔɔ 'klɔ yrayrʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ɩ nɩ saka 'le ‑mʋ, 'bɩa 'nɩ po lɛ, a kɔ ba nu kʋɛwɩɩ 'hɔn. ");
INSERT INTO ted_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","‑Tɛ pepee 'o ‑hʋa, 'ke ɛɛ 'o ‑hii, ꞊nɩɩ 'a ‑hihiwin 'wɔn, kɛɛ, ‑tɛgbi bɛɛ 'o 'mʋ ‑hɔn, kɔ, ‑tɛgbi bɛɛ 'o muu, ‑n 'de 'a dɛ ꞊de yi. Kɛ'ɛ nɩ, Nyɩsʋa a ‑Hihiu nɩ 'mʋ. Nahuon ꞊nʋ, ‑Hihiu a ‑gbɛ, ʋ di 'klɔ yrayrʋ ‑nyi, ‑n 'dio yi.» ");
INSERT INTO ted_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","‑Ye Nikodɛmʋ nɔ: «‑Be' ɛ ‑wɛ 'le bɛ nu 'klɛɛ 'lu a ‑wɔnmumue 'le?» ");
INSERT INTO ted_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","‑Ye ɔ nɔ: «‑Mɔ mɔ tɔɔnyɔ gblaka, kɛ nɔ ‑Juukʋɛ a 'bri, ‑mɔ 'de ‑tɔplɩ a ‑gbɛ yi. ");
INSERT INTO ted_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Dɛ ‑gbo, 'n 'ye, ɛ kɔ dɛ ‑gbo, 'n yi, nɩ‑ kɔ ‑tɩ 'nɩɩ ꞊tu. Kɛɛ ‑ye a 'nɩ pue ꞊le 'mʋ ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","‑Tɔplɩ ‑gbo, ‑ɩɩ 'lu ‑wɔn mue, kɛ nɔ ‑tʋtʋ ke, 'bɩa 'nɩɩ 'a ‑tɩ ꞊tu, a 'nɩ pui ꞊le ‑tɛɛ. 'A ‑tɩ, ‑tɔplɩ ꞊nʋ, ‑ɩɩ 'lu ‑wɔn mue, 'ke 'le yakɔ 'mʋ, 'bɩa 'nɩɩ 'a ‑tɩ ꞊tu, a 'die 'le ‑wɛ ba pui ‑wɛ ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‑Tʋnahuon ꞊de 'de ‑hlɩn 'le yakɔ 'mʋ a mue, 'bɛ 'de 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon. 'Mɔɔ nɩ, ‑ɔ ‑hɔn 'le yakɔ a ‑gbɛ 'mʋ. 'A ‑tɩ, 'hru pɛ 'o gbo, 'ke ꞊bo na yakɔ 'mʋ a ‑tɩ ‑wɔn lɛ. ");
INSERT INTO ted_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bɩ bi 'le ‑mʋ 'kwli 'mʋ, ti ꞊nʋ ‑kɔ 'yri Yisraɛkʋɛ nɩ la 'hru wlɔn, 'ke 'le 'pʋhʋɔnblʋgba 'mʋ, ti ‑hi la a ti 'yri, 'ke Moise 'ba la 'o 'plʋdɛ 'mʋ, 'ɔ nu la hre, 'plɩɩ 'ɔ 'bɛ la tugbɛ. Nɛ‑ kɔ 'lu ɔ 'ba la 'o hre a ‑gbɛ gbo, ‑ɛ die nu, 'ɛ nɩ nahuon, 'bɔ 'wla la 'yii wla, 'bɔ ta la 'le hre a ‑gbɛ ‑wɔn lɛ, 'ke 'le ꞊wlʋ a yekuolɛ 'kwli 'mʋ, ɔ 'nɩ ꞊han la 'kʋ. Kɛ'ɛ nɩ, ɛ di 'mʋ ‑ti, 'ke 'o 'mɔ ‑gbo ‑wɔn, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon. Ʋ di ‑wɛ 'mʋ gbo 'nɩ 'ba, 'ke 'o tu 'yie 'mʋ, ");
INSERT INTO ted_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","‑ɛ die nu, 'ɛ nɩ nahuon, 'bɔ ta 'le 'mʋ ‑wɔn lɛ, 'ke 'le 'na ꞊wlʋ a yekuolɛ 'kwli 'mʋ, Nyɩsʋa 'muo 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","'Ɛ mɔ ‑tɛɛ, Nyɩsʋa nʋɛ ‑tʋnahuin 'mʋ nɩ 'dɔ. Nɛ‑ nue, 'ɔ ‑ha 'a 'Yuu ‑do, ‑ɛ die nu, 'ɛ nɩ nahuon, 'bɔ kuo ꞊wlʋ ye, ɔ 'nɩ ꞊han 'wan, kɛɛ, Nyɩsʋa a ‑gbɛ, ɔ 'muo 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Nyɩsʋa 'de nɔ 'a 'Yu ‑tʋtʋ ke lee, 'ke bɔ poo ‑tʋnahuin ‑bati lɛ, kɛɛ, 'ke bɔ waa ꞊nʋ, ʋ 'nɩ ꞊han 'wan. ");
INSERT INTO ted_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nahuon 'bɔ nɩ 'o, 'bɔ kuo Nyɩsʋa a 'Yu ꞊wlʋ ye, Nyɩsʋa a ‑bati 'die 'le ‑wɛ bɩ klɩ ꞊nɔ. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ 'dio ꞊wlʋ ye kuo, ‑ye Nyɩsʋa a ‑bati klo nɩ ‑dodo, ‑ɛ nue, ɔ 'de Nyɩsʋa a 'Yuu ‑do a ‑gbɛ ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","‑Tɛ Nyɩsʋaa nahuin a ‑bati a lɛpupue nu, nɛ‑ ‑gbo: ꞊Hapʋkɔ, ‑nyrɛ, ‑ɛ mɔ Nyɩsʋa a 'Yu, 'ɛ di nɔ ‑tʋtʋ ke, kɛɛ, nahuin 'de ‑nyrɛ a ‑gbɛ ‑hʋa. Gbɩgbɩyrɩ, nɩ‑ ʋʋ ‑hʋa, ‑ɛ nue, 'waa nunu‑tɔplɩ nyre lɛ 'yi. ");
INSERT INTO ted_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Nahuon 'bɔ nɩ 'o, 'bɔɔ dɛ 'klan nu, 'a ꞊wlʋ yraa ‑nyrɛ nɩ. Gbɩgbɩyrɩ ‑hɛyri, 'ke ɔɔ 'le gbo nɩ, ‑ɛ nue, ɔɔ pɩ hʋannʋ, 'ke 'a nunu‑tɔplɩ ‑hʋɩn bɩ bi pepe' 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kɛɛ, nahuon 'bɔɔ ꞊hapʋdɛ nu, ɔɔ ye 'mʋɛɛ ‑nyrɛ, ‑ɛ die nu, nahuin 'mue 'ye, ‑ɛ mɔ, 'a nunu‑tɔplɩ, ɔɔ nu, Nyɩsʋa nyi 'nɩ ‑hʋa.» ");
INSERT INTO ted_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, 'ke ʋ mu 'le Sudeblʋgba 'mʋ. ‑Tɛgbi a ‑gbɛ, ɔ ‑hi 'le ti gbi, 'ɔɔ nahuin 'nie 'lu lɛ po. ");
INSERT INTO ted_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Saan, ɔɔ ‑wɛ nahuin 'lu lɛ po 'nie. Ɔ ‑mɛ ‑ye, 'ke ɔ nɩ 'le Enɔdɩɔ 'mʋ, 'ke 'le Salimʋdɩɔ 'hʋɩn 'mʋ, ‑ɛ nue, ‑tɛgbi a ‑gbɛ 'nie ‑huo 'o, nahuin 'ʋʋ 'le ꞊nɔ ‑wɔn mu, 'ɔ nyu 'nie 'lu lɛ po. ");
INSERT INTO ted_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ti a ‑gbɛ 'yri, ʋ 'dio ꞊jɩ 'mʋ a pue. ");
INSERT INTO ted_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","‑Ye 'klɛɛ, Saan a ‑naagbopʋ ‑ye, ʋ kɔ ‑Juukʋɛ a ye'mʋnaanyɔ ‑ye 'hɛɛn, nʋ‑ʋ toto po, 'ke 'o nahuon a bʋɩ a lɛyɩyra a ‑ta 'mʋ, ");
INSERT INTO ted_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","'ʋ mu 'le Saan 'hʋɩn 'mʋ, ʋ nɔ: «Tɔɔnyɔ, ꞊be ɩ bi 'le ‑mʋ 'mʋ 'kwli, nahuon ꞊nʋ, ‑ɔ kɔ ‑mʋ 'hɛɛn ‑nɩ o 'le 'nie, ‑ɛ mɔ Sudɛn a 'nike, ‑ɔ kɔ ‑tɩ ‑n ꞊tu o ‑a mʋ ye, ‑ɛ mɔ, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya? ‑Ye 'klɛɛ, nahuon a ‑gbɛ, ɔɔ ‑wɛ nahuin 'lu lɛ po 'nie, 'plɩɩ nahuin 'bii, ‑ʋ di wɛn nɔ ‑mʋ ‑wɔn di, 'ke ʋʋ 'le ꞊nɔ ‑wɔn mu, 'ɔ nyu 'nie 'lu lɛ po.» ");
INSERT INTO ted_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Saan ꞊tu ‑wɔn, ɔ nɔ: «Nyɩsʋa, ‑ɔ nɩ 'le yakɔ 'mʋ, nɔ‑ɔ ‑a mʋ 'ɛ nɩ ‑kʋandɛ ‑nyi, ‑a di nu. ");
INSERT INTO ted_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","'Mɔ Saan, 'na ‑kʋan, nɔ‑ mɔ ꞊bo tɔɔ nahuin Waanyɔ a ‑gbɛ, ‑ɛ die nu, ʋ 'muo 'le ‑wɔn mu. 'A nɩ ‑gbɛ, a yie nɩ, ‑ɛ mɔ, 'n le o 'a mʋ nɩ, 'n 'de Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya. 'Mɛ ‑ye, 'n 'nyɛ 'hru, ‑ɛ die nu, 'mʋ 'a mʋ le, ‑ɛ mɔ, Waanyɔ a ‑gbɛ, ɔɔ 'le 'nɩ di. ");
INSERT INTO ted_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","꞊Bo pue 'blɩ'mʋpaalɛ a dɛ ye. Nyɩbɛyu ꞊nʋ, ‑ɔɔ 'blɩ 'mʋ pa, nyrʋgba ꞊nʋ, ‑ɔ kɔ ꞊nɔ 'hɛɛn 'blɩ 'mʋ pa, nɔ‑ kʋɔ. Ɛ 'de 'blɩ'mʋpanyɔ a ‑gbɛ a nɩnatumu, ɔ 'de nyrɔ a ‑gbɛ kɔ. Kɛɛ, 'ke ɔɔ 'o 'blɩ'mʋpanyɔ 'hʋɩn 'mʋ nɩ, 'ɔ nyo nʋa ye gbo po, kɔ, 'ɔɔ 'manʋ nu, 'bɔɔ 'a win 'wɔn. ‑Yusu 'we ꞊nɔ 'blɩ'mʋpanyɔ ye, 'mɔ 'we ꞊nɔ 'a nɩnatumu ye, 'a 'manʋ mɔ 'na 'manʋ'ʋ nɩ. Ʋ nʋ‑ 'yie 'le 'mʋ. Nahuin, ʋ 'we ꞊nɔ 'blɩ'mʋpanyrɔ ye. Nɛ‑ nue, 'ʋʋ 'le ‑Yusu ‑wɔn mu. Ɛ 'de 'mɔ, ʋ 'deɛ bʋ di nɔ 'mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ɛ nɔɔ 'o lɛ, 'ke ‑Yusu a 'dʋ bʋ 'bʋa, 'mɛ ‑ye, 'na 'dʋ bʋ ꞊tɩɩ 'le.» ");
INSERT INTO ted_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","'Ke ‑Yusu ‑hɔn 'le yakɔ 'mʋ. Nɛ‑ nue, 'ɔ nɩ 'o nahuin 'bii 'lu ye. ‑A ‑mɛ ‑ye, kɛ ‑a kɔ nɔ ‑tʋtʋ ke. Nɛ‑ nue, ꞊aa ‑tʋtʋ ke a ‑tɔplɩ ke 'prɛɛ. Ɔ ‑mɛ ‑ye, 'ke ɔ ‑hɔn 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","‑Tɔplɩ ꞊nʋ, ɔ 'ye, kɔ, ɔ 'wɔn, nɩ‑ kɔ ‑tɩ ɔɔ ‑wɔn lɛ na. Kɛɛ ‑ye nahuin ꞊nʋ, ‑ʋ kuo ꞊wlʋ ye, ʋ 'de ‑huo. ");
INSERT INTO ted_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kɛɛ, nahuin ꞊nʋ, ‑ʋ kuo ꞊wlʋ ye, ʋ nyi 'nɩ ꞊tu, ‑ɛ mɔ, ‑tɩ 'bii ꞊nʋ, Nyɩsʋaa ꞊tu, ɩ mɔ ‑tɩ a ‑tɛɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","‑Yusu 'Klɩsʋ a ‑gbɛ, Nyɩsʋa lee nɔ ‑a mʋ ‑wɔn, Nyɩsʋa a win, nɩ‑ ɔɔ ‑wɔn lɛ na, ‑ɛ nue, Nyɩsʋa a ‑gbɛ, ɔ ‑nyi ꞊nɔ 'a ‑Hihiu 'bii nɩ. ");
INSERT INTO ted_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nyɩsʋa nʋɛ 'a 'Yu a ‑gbɛ 'mʋ nɩ. Nɛ‑ nue, 'ɔ ‑nyi ꞊nɔ ‑tɔplɩ 'bii, ɔ 'mui win ke kɔɔ. ");
INSERT INTO ted_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nahuon 'bɔ nɩ 'o, 'bɔ kuo Nyɩsʋa a 'Yu a ‑gbɛ ꞊wlʋ ye, ‑ye ɔ kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. Kɛɛ ‑ye nahuon 'bɔ nɩ 'o, 'bɔ 'dio ꞊wlʋ ye kuo, 'plɩɩ 'bɔ 'nɩnɩ ꞊tuu 'o ꞊nɔ, ‑ye ɔ 'de 'klɔ yrayrʋ a ‑gbɛ kɔ, kɛɛ, Nyɩsʋa a yrʋ, nʋ‑ dio yɛ, ‑tɛ 'klɔ tɛ ye gbo. ");
INSERT INTO ted_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Falisi꞊tumu a nahuin, ʋ 'wɩn nɩ, ‑ɛ mɔ, ‑Yusu nue nɩ, nahuin 'ʋ nyo ‑wɔn naa, kɔ, 'ɔ nyu 'nie 'lu lɛ po, 'plɩɩ nahuin a ‑gbɛ, ʋ ‑huo nɩ, 'ʋ ‑hi 'o Saan a nahuin 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Kɛɛ, 'ke 'le ‑tɛɛkɔ 'kwli 'mʋ, ‑Yusu a ‑gbɛ, ɔ 'nɩ po ꞊le nahuin 'nie 'lu lɛ, kɛɛ, 'a ‑naagbopʋʋ nɩ, ‑ʋʋ nahuin 'nie 'lu lɛ po. ");
INSERT INTO ted_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","‑Tɩ ꞊nʋ, nahuin ꞊tu, ‑tɛ ‑Yusu 'wɩn, ‑ye ɔ ‑hɔn 'le Sudeblʋgba 'mʋ nɩ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ 'mʋ 'le Galileblʋgba 'mʋ mu. ");
INSERT INTO ted_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaliblʋgba, nɔ‑ ʋ kɔ bʋ 'bɛ ꞊tɩɔ, 'plɩɩ ʋ 'mʋ 'le Galileblʋgba 'mʋ nyre. ");
INSERT INTO ted_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","‑Tɛ ʋʋ 'klɛɛ Samaliblʋgba ꞊tɩɔ 'bɛ, ‑ye 'ke ʋ nyre 'o 'dɩɔ ꞊de ꞊hlɔn. 'Dɩɔ a ‑gbɛ, 'a 'dʋ mɔ Sika. 'Ke 'o ‑tɛgbi a ‑gbɛ, 'ke ‑Juukʋɛ a bu gblaka Sakɔbʋ a ‑ci nɩ 'o, ɔ ‑nyi la 'a 'yu Sosɛfʋ. ");
INSERT INTO ted_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","'Ke 'le ‑ci a ‑gbɛ 'kwli 'mʋ, 'ke Sakɔbʋ 'bluu la 'o 'nɩhʋɔ. ‑Tɛ ʋ nyre 'klɛɛ 'o 'nɩhʋɔ a ‑gbɛ wien, 'ke ‑Yusu a ‑naagbopʋ hio 'o gbo, 'ʋ mu 'le 'dɩɔ 'mʋ, ‑ɛ die nu, ʋ 'mʋ didi‑tɔplɩ ‑tɔ. ‑Yusu ‑mɛ ‑ye, 'a 'klɩ ‑wɛ 'le ꞊le, 'ke 'o 'hru ꞊nʋ, ʋʋ na a ‑ta 'mʋ. Nɛ‑ nue, 'ɔ nɩ 'o 'nɩhʋɔ a ‑gbɛ nʋa 'mʋ gbo. Ti a ‑gbɛ 'yri, 'yrʋ nyra gbo. Ɔ ‑do bɔ nɩ 'klɛɛ 'o gbo, ‑ye Samalikʋɛyrɔwlʋ ꞊de, nɔ‑ di 'nie 'pi wɔn. ‑Ye kɛ ‑Yusu nyo ye po, ɔ nɔ: «‑Nye 'mʋ 'nie, ꞊bo 'na!» ");
INSERT INTO ted_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","‑Ye nyrʋgba a ‑gbɛ, ɔ ꞊tuo ‑wɔn, ɔ nɔ: «‑Mbe', ‑mɔ mɔ ‑Juukʋɛyu, 'plɩɩ ꞊nɩɩ 'mɔ ‑gbo, ‑ɔ mɔ Samalikʋɛyrɔwlʋ 'nie ‑hʋa.» 'Ɛ mɔ ‑tɛɛ, ‑Juukʋɛ, ʋ kɔ Samalikʋɛ 'hɛɛn, ʋ nyinyre lɛ. ");
INSERT INTO ted_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Kɛ ‑Yusuu 'klɛɛ ꞊nɔ ye po: «'Bɩa ꞊nɩ yi wɛn dɛ ꞊nʋ, Nyɩsʋaa nahuin ‑nyi, kɔ, ꞊nɩ yi wɛn ‑wɛ 'mɔ ‑gbo, ‑ɔɔ ‑mʋ 'nie ‑hʋa, ‑ye ‑mɔɔ nɩ, ‑ɔ di wɛn 'mʋ 'nie ‑hʋa. 'Mɛ ‑ye, 'niedʋ ꞊nʋ, ‑ɛɛ nahuon 'klɔ yrayrʋ ‑nyi, nɛ‑ 'n di wɛn ‑mʋ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","‑Ye nyrʋgba a ‑gbɛ, ɔ nɔ: «Nyɩbɛyu o, ‑n 'de 'nie'piidɛ ꞊de kɔ, 'plɩɩ ‑ye 'hʋɔ ‑gbo, ɔ hren 'mʋ gbo. ‑Be' ‑n ‑wɛ 'le ‑bo nu 'nie a ‑gbɛ a 'pipie 'le? ");
INSERT INTO ted_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","‑A nɩ bu gblaka Sakɔbʋ, nɔ‑ hie ‑a mʋ 'nɩhʋɔ ‑gbo lɛ. 'A ‑gbɛ, ɔ 'na 'a 'nie nɩ, ɔ kɔ 'a 'yuo꞊pli 'hɛɛn, 'a 'wlugba‑tɔplɩ 'ɩ 'na ‑wɛ 'nie a ‑gbɛ. ꞊Be ‑n pui ‑tɛɛ, ‑mɔ nɩɔ 'o 'lu ye?» ");
INSERT INTO ted_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","‑Ye ‑Yusu nɔ: «Nahuon ꞊nʋ, ‑ɔ di 'nɩhʋɔ ‑gbo a 'nie 'na, 'nie'natʋ dio lele 'nɩ nu. ");
INSERT INTO ted_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔɔ 'niedʋ ꞊nʋ 'na, 'n di ꞊nɔ ‑nyi, gbegbe, 'nie'natʋ 'deɛ bʋ nuo 'klɛɛ lele. ‑Ɛ nue, 'niedʋ ꞊nʋ, 'n di ꞊nɔ ‑nyi, ɛ di ye 'we 'nie ꞊nʋ, ‑ɛɛ 'le ‑tʋtʋ gbo 'mʋ ‑hɔn ti a pɛpɛ, ‑ɛɛ nahuon a ‑gbɛ 'klɔ yrayrʋ ꞊nʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le.» ");
INSERT INTO ted_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","‑Ye nyrʋgba a ‑gbɛ, ɔ nɔ: «‑Nye 'mʋ 'niedʋ a ‑gbɛ, ‑ɛ die nu, 'nie'natʋ 'nɩ ꞊han 'klɛɛ lele 'mʋ nu, kɔ, 'nɩ ꞊han 'klɛɛ lele nɔ 'nɩhʋɔ ‑gbo wien di, 'nie'pi‑tɩ.» ");
INSERT INTO ted_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","‑Ye ‑Yusu nɔ: «Mu ‑bo da ‑na tɔ, ɔ kɔ ‑mʋ 'hɛɛn ba di 'le!» ");
INSERT INTO ted_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","‑Ye nyrʋgba nɔ: «'N 'de tɔ kɔ.» ‑Ye ‑Yusu nɔ: «'A ‑tɛɛ, nɛ‑ɛ nɩ. ‑N 'de tɔ kɔ, ");
INSERT INTO ted_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","‑ɛ nue, ‑bo kɔ tɔ, ‑bo kɔ tɔ, ɛ ‑wɛ 'klɛɛ 'le tɔnʋʋ ꞊hun, 'plɩɩ ‑ye, nahuon ꞊nʋ, ‑ɔ kɔ ‑mʋ 'hɛɛn‑ nye 'mʋ na, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, ɔ 'de ‑na tɔ.» ");
INSERT INTO ted_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","‑Ye nyrʋgba ꞊nʋ, ɔ nɔ: «'N nye 'nɩ 'ye, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","‑A mʋ Samalikʋɛ a bunʋ, 'ke 'le dʋgba ꞊nʋ 'lu, 'ke ʋʋ 'le Nyɩsʋa daa, kɛɛ, 'a mʋ ‑Juukʋɛ, a nɔ 'nɩ, Nyɩsʋa a daalɛɛ ‑do, nɛ‑ mɔ Jrusrɛdɩɔ.» ");
INSERT INTO ted_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","‑Ye ‑Yusu nɔ: «Nyrʋgba o, ‑tɩ ‑gbo, 'nɩɩ ꞊tu, pui ‑tɛɛ. Ti di 'o 'nɩ nyre, ‑ɩ kɔ 'yri a 'nɩnɩ di 'o lele dʋgba ꞊nʋ 'lu ‑a nɩ Bu Nyɩsʋa daa, kɔ Jrusrɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","'A mʋ Samalikʋɛ, Nyɩsʋa ꞊nʋ, aa da, a 'dio yi. Kɛɛ, ‑a mʋ ‑gbo, ‑ʋ mɔ ‑Juukʋɛ, Nyɩsʋa ꞊nʋ, ‑aa da, ‑a yio nɩ, ‑ɛ nue, 'ke Nyɩsʋaa 'le ‑Juukʋɛ 'mʋ naa, 'ɔɔ nahuin waa. ");
INSERT INTO ted_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Ti di 'o 'nɩ nyre, 'plɩɩ ti a ‑gbɛ 'ɩ nyre 'o ‑dodo, ‑ɩ kɔ 'yri Nyɩsʋa a ‑Hihiu di 'o nahuin 'klɩ ‑nyii, 'ke bʋ da ‑a nɩ Bu Nyɩsʋa, 'ke 'o 'ɛ nɩ ‑tɛgbi ꞊de, ‑ʋ mɔ Nyɩsʋa a ‑Hihiu ꞊nʋ, ‑ʋʋ ‑tʋnahuin ‑tɩ a ‑tɛɛ tɔɔ. ‑Tɛ ‑a nɩ Bu Nyɩsʋaa ‑hʋa nahuin bʋ nu 'a dɩda, kɛ'ɛ nɩ, ɛ nɩ 'mʋ. Nyɩsʋa mɔ ‑Hihiu. Nahuin ꞊nʋ, ‑ʋ nye ‑hʋa, ‑bʋ da Nyɩsʋa, 'a ‑Hihiu kɔ bʋ nɩ 'o ꞊nʋ ke 'mʋ. 'A ‑Hihiu a ‑gbɛ, ʋ nye ‑tʋnahuin 'nɩ tɔɔ, ‑tɛ Nyɩsʋa a ‑gbɛ, ɔ nɩ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","‑Ye nyrʋgba ꞊nʋ, ɔ nɔ: «'N yie nɩ, ‑ɛ mɔ, Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, ɔ kɔ bɔ di 'le. 'Bɔ di 'le, ‑ye ɔ di ‑a mʋ ‑tɔplɩ 'bii klɛ 'nɩ ‑hɩhɩa.» ");
INSERT INTO ted_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","‑Ye ‑Yusu nɔ: «'Mɔ nɩ gbo mɔ, ‑ɔ kɔ ‑mʋ 'hɛɛn‑ 'prɛ.» ");
INSERT INTO ted_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Tii ‑do a ti 'yri, ‑ye ‑Yusu a ‑naagbopʋ ‑nɩ wɛn, ‑ʋ mu wɛn 'dɩɔ 'mʋ, ʋ nyre 'o ꞊o. Ɩ saka ꞊nʋ nɩ, ‑tɛ ‑Yusu kɔ nyrʋgba 'hɛɛn, ʋʋ toto po. Kɛɛ, 'waa nahuon ꞊de 'de wlɔn ꞊gba, ‑ɛ mɔ: «‑Tɩ tio‑ ‑n nyo wlɔn ꞊gba 'le?» kɔ, «‑Tɩ tio‑ ɔ kɔ ‑mʋ 'hɛɛn, aa ꞊tu 'le?» ");
INSERT INTO ted_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nyrʋgba ‑mɛ ‑ye, ɔ hie 'o 'a 'nɩya gbo, 'ɔ gba cigbɛi, 'ɔ mu 'dɩɔ 'mʋ, 'ɔ le nahuin, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Ba di 'le, a 'mʋ nahuon ꞊de 'ye. Nɔ‑ le 'mʋ ‑tɔplɩ 'bii ꞊nʋ, 'n nu lɛ. ꞊Be ɛ ‑wɛ 'le bɛ 'ya Waanyɔ ꞊nʋ 'mʋ nɩ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya?» ");
INSERT INTO ted_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","‑Ye nahuin a ‑gbɛ, ʋ ‑hɔn 'le 'dɩɔ 'mʋ nɩ, 'ʋ muo 'le 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","‑Tɛ nahuin a ‑gbɛ, ʋ 'de wɛn 'le a die, ‑ye ‑Yusu a ‑naagbopʋ, ʋ nyo lɛ 'nɩ 'batɩ, ʋ nɔ: «Tɔɔnyɔ o, di dɛ 'plɩɩ.» ");
INSERT INTO ted_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kɛɛ ‑ye ɔ nɔ: «'N kɔ dididɛ ꞊de, a 'de yi.» ");
INSERT INTO ted_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","‑Ye 'a ‑naagbopʋ wlɔn lɛ 'nɩ ꞊gbʋgba, ʋ nɔ: «꞊Be ꞊ɔ ꞊de yɔ dididɛ ye ‑le?» ");
INSERT INTO ted_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","‑Ye ɔ nɔ: «'Na dididɛ, nɛ‑ mɔ ꞊bo nu Nyɩsʋa, ‑ɔ lee nɔ 'mʋ 'klɔ ‑gbo ke a kewɛɛnlɛ, ɛ ꞊hɛn 'nyrɛ ꞊bo ‑yra ‑kʋan ꞊nʋ 'lu, ɔ ‑nyi 'mʋ, ꞊bo nu. ");
INSERT INTO ted_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","‑A 'brikʋɛ nɔ 'nɩ: ꞊Nɩ 'dɔ ꞊gbla, yakʋɛɛ ‑hɛn 'bɛ ꞊cɛ, ‑ye ‑n nyo 'nɩ 'cɛ. Kɛɛ, 'mɛ ‑ye, 'nɩɩ 'a mʋ 'nɩ le: Ba 'ba 'yii 'mʋ, ba ta 'le ‑ci klɛ. ꞊Gbla ꞊hlu nɩ ‑dodo. Ɔ ‑wɛ 'le 'cɩcɛ.» (Ɛ 'we ꞊nɔ ye, nahuin ‑gbo, ‑ʋ nyo 'le 'hʋɩn 'mʋ di, ‑ʋ ‑wɛ ‑wɔn, 'ke ‑bʋ kɔ 'klɔ yrayrʋ ꞊nʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, nʋ‑ kɔ ‑tɩ ɔɔ ꞊tu.) ");
INSERT INTO ted_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","«‑Kʋannunyɔ ꞊nʋ, ‑ɔɔ ꞊gbla 'cɛ, ɔ kɔ 'a nɩ 'pɛɛlɛ nɩ. 'A ‑kʋan a ‑gbɛ, nɔ‑ nye nu, nahuin 'ʋʋ 'klɔ yrayrʋ ꞊nʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ‑Ye 'klɛɛ, nahuon ꞊nʋ, ‑ɔɔ ꞊gbla 'dɔ, kɔ nahuon ꞊nʋ, ‑ɔ nyo 'cɛ, ʋ di 'mʋ lɛ bibi 'yi, ʋ 'mʋ 'manʋ nu. ");
INSERT INTO ted_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","‑Talʋdʋ ꞊nʋ, ‑ʋʋ lɛ po: ꞊Ʋ ‑yee 'dɔ ꞊gbla, ꞊ʋ ‑ye 'ʋ nyo 'cɛ, ʋ mɔ ‑tɩ a ‑tɛɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","'N lee 'le 'a mʋ ke ‑ci ‑ye, ‑ɛ kɔ ‑kʋan a 'de o nu, kɛɛ, ‑ɛ kɔ ꞊gbla aa 'klɛɛ 'cɛ. ꞊Ʋ ‑ye, nʋ‑ nu o ‑ci a ‑gbɛ a ‑kʋan, a ‑mɛ ‑ye, 'aa 'klɛɛ 'a ꞊gbla 'cɛ.» ");
INSERT INTO ted_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samalikʋɛ ‑nɩ wɛn, ‑ʋ nɩ 'le 'dɩɔ ‑nɩ wɛn 'mʋ, 'waa nahuin 'plɔplɔ kuo ‑Yusu ye ꞊wlʋ, ‑ɛ nue, kɛ nyrʋgba ꞊nʋ, ɔ po ꞊nʋ ye: «Nahuon ‑gbo, nɔ‑ le 'mʋ ‑tɔplɩ 'bii ꞊nʋ, 'n nu lɛ.» ");
INSERT INTO ted_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nɛ‑ kɔ ‑tɩ, ‑tɛ Samalikʋɛ a ‑gbɛ, ʋ nyre 'klɛɛ 'o ‑Yusu 'hʋɩn 'mʋ, 'ʋ nyo lɛ 'batɩ, 'ke bɔ nɩ 'le ꞊nʋ ‑wɔn, 'ɛ mɔ ‑tɛɛ, 'ɔ wɛɛn ke, 'ɔ ‑hi 'le ‑nyrɔwɩɩ 'hɔn. ");
INSERT INTO ted_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nahuin 'plɔplɔ ‑ye kuo ꞊wlʋ ye, 'ke 'o ‑tɩ ꞊nʋ, ɔ ꞊tu a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Kɛ ʋʋ 'klɛɛ nyrʋgba ꞊nʋ ye po, ʋ nɔ: «‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, ɛ 'de ‑tɩɩ ‑do ‑gbo, ‑n ꞊tu ‑a mʋ ye a ‑tɩ, ‑a 'dio ꞊wlʋ ye kuo, kɛɛ, ‑a kuo ye ꞊wlʋ, ‑ɛ nue, ‑a nɩ ‑gbɛ, ‑a 'wɔn 'a win nɩ, kɔ, ‑a kɔ 'a yiyie, ‑ɛ mɔ, 'ɛ mɔ ‑tɛɛ, nɔ‑ mɔ Waanyɔ ꞊nʋ, ‑ɔɔ 'klɔ ‑gbo a nahuin waa.» ");
INSERT INTO ted_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","'Plɩɩ ɔ 'mʋ 'o ‑nyrɔwɩɩ 'hɔn mu ‑hi, 'ke 'o ‑tɛgbi a ‑gbɛ, ‑ye 'ke ɔ mu 'le Galileblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","'A ‑gbɛ, ɔ ꞊tui o nɩ, ‑ɛ mɔ: «Nyɩsʋa a winwlɔn‑hɛnyɔ 'bɔ nɩ 'le 'a 'brikʋɛ ‑hɛyri, ‑ye ʋ 'nɩ ꞊tuo ꞊le 'o.» ");
INSERT INTO ted_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Kɛɛ, Galileblʋgba a nahuin a ‑gbɛ, ʋ mu o ke lɛ'mimre ꞊nʋ, ‑ɛ mɔ Pakɩ, 'ke 'le Jrusrɛdɩɔ 'mʋ, 'ʋ 'ye o ‑tɔplɩ 'bii ꞊nʋ, ‑Yusu nu o. Nɛ‑ nue, ‑tɛ ‑Yusu nyre 'klɛɛ 'le Galileblʋgba 'mʋ, nahuin 'ʋ 'blo kwa ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","‑Ye 'ke ɔ mu 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Kana. 'Ke 'le 'dɩɔ a ‑gbɛ 'mʋ, 'ke ɔ nuu la 'o 'ŋmilɛkadɛ, 'nie 'ɛ ‑hɛ la ‑wiin. ‑Ye 'klɛɛ, ɛ kɔ la nyɩbɛyu ꞊de. Ɔ mɔ 'blʋgba a 'kɩɩn a ‑kʋannunyɔ gblakaa nɩ, 'ɔ nɩ la 'le Kapɛnaɔdɩɔ 'mʋ, 'ke 'le Galileblʋgba 'mʋ. Ɔ kɔ la 'yu nyɩbɛyu. Nɔ‑ kɔ 'hʋɩɩn‑ hren. ");
INSERT INTO ted_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","‑Tɛ nyɩgblaka a ‑gbɛ, ɔ 'wɩn, ‑ɛ mɔ, 'ke ‑Yusu ‑hɔn 'le Sudeblʋgba 'mʋ, 'ɔ mu 'le Galileblʋgba 'mʋ, ‑ye ɔ ‑hɔn 'le 'a 'dɩɔ 'mʋ nɩ, 'ɔ mu 'le ‑Yusu ‑wɔn, 'ɔ 'bɔtɩɔ lɛ, ɔ nɔ: «Di 'le 'na 'dɩɔ Kapɛnaɔ 'mʋ, ꞊mʋ 'na 'yu a 'kʋɛ ‑wɔ. Ɔɔ ‑hʋa bɔ 'kʋ.» ");
INSERT INTO ted_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","‑Ye kɛ ‑Yusuu ꞊nɔ ye po: «Ɛ 'we ꞊nɔ ye, a 'kɩɛ 'die 'le a ‑wɛɛ ba kuo 'mʋ ꞊wlʋ ye, 'bɩa 'ba 'nɩnɩ 'ye 'ŋmilɛka‑tɔplɩ gblakɩ ꞊nʋ, 'nɩɩ nu.» ");
INSERT INTO ted_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","‑Ye nyɩgblaka a ‑gbɛ, ɔ ꞊tuo ‑wɔn, ɔ nɔ: «Tɔɔnyɔ o, di 'le 'na 'dɩɔ 'mʋ, 'na 'yu 'nɩ ꞊han 'kʋ.» ");
INSERT INTO ted_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","‑Ye kɛ ‑Yusuu ꞊nɔ ye po: «‑N ‑wɛ 'le ‑bo mu nɩ. ‑Na 'yu 'kɩɛ die 'klɔ nɩ.» ‑Tɩ ꞊nʋ, ‑Yusu ꞊tu ꞊nɔ ye, ɔ kui ye ꞊wlʋ, 'ɔ mu. ");
INSERT INTO ted_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɔ nɩ 'hru wlɔn, 'a ‑kʋannunyʋ 'ʋ dio ye 'mʋ 'bɛ wɔn, ʋ nɔ: «‑Na 'yu nɩ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","‑Ye ɔ ꞊gbʋ wlɔn, ɔ nɔ: «Ti tio‑ kɔ 'yri 'a 'hʋɩn 'kee 'le?» ‑Ye ʋ nɔ: «‑Dina bɔ bi 'tʋ 'le, 'a ‑haawɔɔ ‑do bɔ ‑hi 'tʋ, ‑ye 'a 'hʋɩn 'kee 'tʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","‑Ye ɔ 'ye nɩ, ‑ɛ mɔ, ti ꞊nʋ ‑kɔ 'yri ‑Yusu lee 'tʋ 'o ꞊nɔ, ‑ɛ mɔ, 'a 'yu 'kɩɛ die 'klɔ nɩ, 'kee nɩ, 'a 'yu a ‑gbɛ a 'hʋɩn 'kee 'tʋ 'o. ‑Ye ɔ bi 'le ye, ɔ kɔ 'a kayugbokʋɛ 'hɛɛn, ʋ kuo ‑Yusu ye ꞊wlʋ. ");
INSERT INTO ted_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","‑Yusu bɔ ‑hɔn 'le Sudeblʋgba 'mʋ, bɔ mu 'le Galileblʋgba 'mʋ, bɔ nu 'ŋmilɛkadɛ, 'a 'wɩɩ 'hɔn a dɛ'ɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye ‑Juukʋɛ, ʋʋ ke mu lɛ'mimre, 'ke 'le Jrusrɛdɩɔ 'mʋ. 'Ke ‑Yusu mu ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Paalɛ ꞊de nɩ 'o, ‑ɛ kɔ 'yri ʋʋ 'o naa, 'ʋʋ 'le Jrusrɛdɩɔ 'mʋ pa. Ʋ nye daa Blablɔ a Paalɛ. 'Ke 'o paalɛ a ‑gbɛ 'hʋɩn 'mʋ, 'ke 'wlo ꞊de nɩ 'o, nahuin 'blu la. 'Wlo a ‑gbɛ, 'a 'dʋ mɔ Betesada, 'ke 'le ‑Juukʋɛwin 'kwli 'mʋ. Nɛ‑ kɔ nʋa 'mʋ, ʋ poo 'o papʋɛii ꞊hun. ");
INSERT INTO ted_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","'Ke 'le papʋɛi a ‑gbɛ gbo, 'hʋɩnhrennyʋ 'plɔplɔ pɛ 'le gblɛ, 'yiisuanyʋ, bʋɩklanyʋ, kɔ lɛ‑yɩyrɛnyʋ. Ʋ nye 'nɩ ‑pre, 'ke 'nie bɛ po ꞊tablɔ, ");
INSERT INTO ted_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","‑ɛ nue, ɛ kɔ ti, Nyɩsʋa a lɛleenyɔ ꞊de, 'ɔɔ 'le ꞊tɩ, 'ɔ nye ꞊gbɔti, ‑ɛ die nu, ɛ 'mʋ ꞊tablɔ po. 'Ɛ nɩ ti, Nyɩsʋa a lɛleenyɔ 'bɔ ꞊gbɔtie, 'bɛɛ 'klɛɛ ꞊tablɔ po, ye‑hɛhʋɩnhrennyɔ, ‑ɔ di 'le ꞊tɩ, ‑tɛ 'a 'kʋɛ bɛ nɩ 'mʋ, ɛ kɔ bɛ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ti a ‑gbɛ 'yri, ɛ kɔ ‑wɛ 'hʋɩnhrennyɔ ꞊de, 'ɔ nɩ 'le 'a 'bienʋ ‑hɛyri. ‑Tɛ 'a 'hʋɩn ‑tʋa la 'le hinhren gbo, ɛ ‑wɛ 'klɛɛ 'le 'yrɩ a (38) ꞊wlʋ ꞊tu 'o ‑pu ꞊tu 'o ‑yehɛn‑yehɛn. ");
INSERT INTO ted_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","‑Tɛ ‑Yusu nyre 'o, ‑ye ɔ 'ye nahuon a ‑gbɛ nɩ, ‑ɔ pɛ gbo. Ɔ yie nɩ, ‑ɛ mɔ, ‑tɛ 'a 'hʋɩn ‑tʋa la 'le hinhren gbo, ɛ ‑wlɛn gbo. ‑Ye ɔ ꞊gbɔ wlɔn, ɔ nɔ: «꞊Be ‑n nye 'nɩ ‑hʋa, 'ke ‑na 'kʋɛ bɛ ‑wɛ?» ");
INSERT INTO ted_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","‑Ye 'hʋɩnhrennyɔ nɔ: «Tɔɔnyɔ o, 'n 'de nahuon ꞊de kɔ, ‑bɔ ꞊tɩɔ 'le 'mʋ 'nie ‑wɔn, ti ꞊nʋ ‑kɔ 'yri ɛɛ 'o ꞊tablɔ po. 'Bɩa 'nɩ ‑hʋa ꞊bo ꞊tɩ wɛn 'le, ‑ye ꞊ɔ ‑ye ‑hi 'mʋ ye.» ");
INSERT INTO ted_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","‑Ye kɛ ‑Yusuu ꞊nɔ ye po, ɔ nɔ: «'Ba ye 'mʋ, ‑bo 'ba ‑na 'craka 'mʋ, ‑bo na!» ");
INSERT INTO ted_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Tii ‑do a ti 'yri, ‑ye 'a 'kʋɛ ‑wɛ nɩ, 'ɔ 'ba 'a 'craka 'mʋ, 'ɔ ‑tʋa nɩna gbo. Kɛɛ ‑ye dɛ a ‑gbɛ, ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ 'mʋʋ nɩ, 'ke ɛ mue 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","‑Juukʋɛ a ye'mʋnaanyʋ, ʋ 'ye nahuon a ‑gbɛ nɩ, ‑ɔ kɔ 'kʋɛ ‑wɛ, 'ʋ lo, ʋ nɔ: «Kɛkɛ a ‑nyrɔwɔ ‑gbo, ɔ mɔ kɛ ‑wuwle‑nyrɔwɔ'ɔ nɩ. 'A ‑tɩ, ‑n 'de ye blɛ ‑bo 'ble ‑na 'craka ‑wuwle‑nyrɔwɔ a ‑gbɛ 'mʋ. Ɛ mɔ ‑kʋaan nɩ, 'plɩɩ ‑ye ɩ ꞊ŋa nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","‑Ye ɔ nɔ: «Nahuon ꞊nʋ, ‑ɔ ‑wɔ 'na 'kʋɛ, nɔ‑ le 'mʋ, ꞊bo 'ba 'na 'craka 'mʋ, ꞊bo na.» ");
INSERT INTO ted_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","‑Ye ʋ nɔ: «Nahuon tio‑ le ‑mʋ, ‑bo 'ba ‑na 'craka 'mʋ, ‑bo na?» ");
INSERT INTO ted_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Nahuon ꞊nʋ, ‑ɔ kɔ 'kʋɛ ‑wɛ, ɔ 'de ‑Yusu yi, ‑ɛ nue, ‑Yusu mu nɩ 'tata a ti 'yri, nahuin ‑huohui ꞊nʋ, ‑ʋ nɩ 'o a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","‑Tɛ ɛ gba ti gbi, ‑ye 'ke ‑Yusu yɔ 'le Nyɩsʋa a 'kagblaka gbo. Kɛ ɔɔ ꞊nɔ ye po, ɔ nɔ: «'Ye kɛ, ‑na 'kʋɛ ‑wɛ nɩ. ꞊Nɩ nu 'le 'klɛɛ lele dɛ 'kuku, ‑ɛ die nu, ꞊sʋɛ a 'yiye ꞊nʋ, ‑ɛ ‑hi 'a dɛ ‑gbo wlɔn, ‑n 'ye, ɛ 'nɩ ꞊han ‑mʋ yɛ.» ");
INSERT INTO ted_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","‑Ye nahuon a ‑gbɛ, ɔ mu nɩ, 'ɔ le ‑Juukʋɛ a ye'mʋnaanyʋ, ‑ɛ mɔ, ‑Yusu'u nɩ, ‑ɔ ‑wɔ 'a 'kʋɛ. ");
INSERT INTO ted_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kʋɛ 'o ti a ‑gbɛ 'yie 'mʋ gbo, ‑ye ʋ ‑tʋa ‑Yusu a bʋɩ a lɛ꞊mʋmɔ gbo, ‑ɛ nue, ‑Yusu ‑wɔ nahuon a 'kʋɛ, ‑wuwle‑nyrɔwɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Kɛɛ ‑ye ‑Yusu ‑hɩhɩʋ klɛ, ɔ nɔ: «'Na Bu, ɔɔ nu ‑kʋan 'ɛ nɩ ti. 'Na ‑gbɛ, dɛɛ ‑do, nɛ‑ɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","‑Tɛ ‑Yusu po 'klɛɛ lɛ, ‑ye ‑Juukʋɛ a ye'mʋnaanyʋ a ‑gbɛ, ʋʋ lele lɛ ꞊mɔ 'hru, 'ke bʋ 'lɔ, ‑ɛ nue, ɔ ꞊tui nɩ, ‑ɛ mɔ, Nyɩsʋa, nɔ‑ mɔ 'a Bu, ɛ ꞊hɛn 'nyrɛ, ɔ nɔ 'nɩ, ɔ kɔ Nyɩsʋa 'hɛɛn, ʋ wɛɛn nɩ. Ɛ 'de bɔ 'wla ‑wuwle‑nyrɔwɔ a tetee ‑do a ‑tɩ, ʋ 'nɩ ꞊mɔ ꞊le 'a 'lɩla lɛ. ");
INSERT INTO ted_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","‑Tɩ ꞊nʋ, ‑Juukʋɛ a ye'mʋnaanyʋ, ʋʋ ‑Yusu yɛɛ, 'ɔ nyu klɛ ‑hɩhɩa, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ Nyɩsʋa a 'Yu, 'n ‑do, 'n 'de 'le dɛ ꞊de a nunue 'le ‑wɛ. Dɛ 'nɩɩ 'ye, 'na Buu nu, ɛ ‑do a ‑gbɛ, nɛ‑ 'nɩɩ nu. ‑Tɔplɩ 'bii, 'na Buu nu, 'n nyi ‑wɛ 'nɩ nu. ");
INSERT INTO ted_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","'Ɛ mɔ ‑tɛɛ, 'na Bu nʋɛ 'mʋ 'mʋ nɩ, 'ɔɔ 'mʋ ‑tɔplɩ 'bii ꞊nʋ tɔɔ, 'a ‑gbɛ, ɔɔ nu. Ɔ di lele 'mʋ 'nɩ le, ꞊bo nu 'ŋmilɛka‑tɔplɩ ‑ye, ‑ɩ ‑hi 'o 'a dɛ ‑gbo 'mʋ, 'n nu, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, ɩ 'mʋ 'a mʋ saka. ");
INSERT INTO ted_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ɛ 'we ꞊nɔ ye, ‑tɛ 'na Buu nu, 'ɔɔ 'le nahuin 'kʋkʋnyʋ ‑hɛyri ‑ha, 'ɔ nyu 'klɔ ‑ha, kɛ 'nɩɩ nu, 'nɩɩ nahuin ꞊nʋ 'klɔ yrayrʋ ‑nyi, 'nɩɩ ‑hʋa ꞊bo ‑nyo. ");
INSERT INTO ted_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","'Ya 'o lele 'lu, 'na Bu 'nɩ poo ꞊le nahuon ꞊de ‑bati lɛ, kɛɛ, ɔ ‑nyi 'mʋ 'klɩ 'bii nɩ, 'ke ꞊bo poo nahuin ‑bati lɛ, ");
INSERT INTO ted_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","‑ɛ die nu, nahuin 'bii, ʋ 'mʋ 'mʋ 'o ꞊tuu, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ʋʋ 'na Bu a 'o꞊tuulɛ nu. Nahuon ‑gbo, ‑ɔ 'nɩnɩ ꞊tuu 'o 'mʋ, ɛ 'we ‑wɛ ꞊nɔ ye, 'na Bu, ‑ɔ lee nɔ 'mʋ 'klɔ ‑gbo ke, nɔ‑ ɔ 'nɩnɩ ꞊tuu 'o. ");
INSERT INTO ted_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","'Nɩɩ 'a mʋ 'nɩ le, nahuon 'bɔ nɩ 'o, 'bɔɔ 'na win nʋa ye gbo po, kɔ, 'bɔ kuo 'na Bu ꞊wlʋ ye, ‑ɔ lee nɔ 'mʋ ‑tʋtʋ ke, nahuon a ‑gbɛ, nɔ‑ kɔ 'klɔ yrayrʋ ꞊nʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ‑Bati 'deɛ bɩ klo, kɛɛ, ɔ ‑hɔn 'le 'kʋkʋɛ wlɔn 'mʋ nɩ, 'ɔ pa 'le 'klɔ yrayrʋ ꞊nʋ ‑hɛyri, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ti di 'o 'nɩ nyre, 'plɩɩ ti a ‑gbɛ 'ɩ nyre 'o ‑dodo, ‑ɩ kɔ 'yri 'kʋkʋnyʋ di 'o 'mɔ ‑gbo, ‑ɔ mɔ Nyɩsʋa a 'Yu a win 'wɔɔn, kɔ, nahuin ꞊nʋ, ‑ʋ di 'na win 'wɔn, ʋ di kɔ 'klɔ yrayrʋ ꞊nʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","'Na Bu kɔ 'klɩ, 'ke bɔ nue, nahuin 'mʋ 'klɔ nɩ. 'Klɩɩ ‑do a ‑gbɛ, nɩ‑ ɔ ‑nyi 'mʋ, 'ke ꞊bo ‑nyi nahuin 'klɔ yrayrʋ ꞊nʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, ");
INSERT INTO ted_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","'ɔ ‑nyi ‑wɛ 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon 'klɩ, 'ke ꞊bo poo nahuin ‑bati lɛ. ");
INSERT INTO ted_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ɛ nɩ saka 'le 'a mʋ, ti di 'o 'nɩ nyre, ‑ɩ kɔ 'yri nahuin 'bii ‑gbo, ʋ ‑ha 'o lɛ, ʋ 'mʋ 'na win 'wɔn. ");
INSERT INTO ted_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","'Bʋ 'wɔn 'na win a ‑gbɛ, ‑ye ʋ di 'le 'dɛɛi wlɔn 'mʋ lɛ 'nɩ ‑hɔn. Nahuin ꞊nʋ, ‑ʋ nu ꞊hapʋdɛ, ʋ di kɔ 'klɔ yrayrʋ ꞊nʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, kɛɛ, nahuin ꞊nʋ, ‑ʋ nu dɛ 'klan, ‑bati diu 'nɩ klɩ. ");
INSERT INTO ted_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","'N ‑do, 'n 'de 'le dɛ ꞊de a nunue 'le ‑wɛ, Nyɩsʋa 'bɔ 'de 'mʋ 'a 'klɩ ‑nyi. 'Bɩa 'nɩɩ nahuon ꞊de a ‑bati 'bɛ, ‑tɛ Nyɩsʋa 'na leelɛ nu, kɛ 'nɩɩ 'a nunue nu. 'Nɩɩ po ‑tɛɛ a ‑bati, ‑ɛ nue, Nyɩsʋa, ‑ɔ lee nɔ 'mʋ ‑tʋtʋ ke, dɛ ꞊nʋ, ɔɔ ‑hʋa ꞊bo nu, nɛ‑ 'nɩɩ nu ‑tɛɛ. Ɛ 'de dɛ ‑gbo, 'na ‑gbɛ, 'nɩɩ ‑hʋa, 'nɩ nue ꞊le.» ");
INSERT INTO ted_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Kɛ ‑Yusuu lele po, ɔ nɔ: «'Bɩa 'n ‑do, 'nɩ nyi wɛn ꞊tu, nahuon a gblo tio‑ 'n 'ya 'mʋ, ‑ye nahuin, ʋ 'deɛ bʋ yrie wɛn, ‑ɛ mɔ, 'nɩɩ ꞊tu ‑tɩ a ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kɛɛ, Nyɩsʋa, nɔ‑ nyi ꞊tu, nahuon a gblo tio‑ 'n 'ya 'mʋ, 'plɩɩ 'n yie nɩ, ‑tɩ ꞊nʋ, ɔɔ ꞊tu, 'ke 'o 'mʋ ke, ɩ mɔ ‑tɩ a ‑tɛɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","A ‑mɛ ‑ye, a tɛ gbo nahuin, 'ke 'le Saan Batisɩ ‑wɔn, 'ɔ ꞊tui ‑wɛ 'a mʋ ye, nahuon a gblo tio‑ 'n 'ya 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ɛ 'die 'nyrɛ ꞊hɛn, ‑ɛ mɔ, 'nɩɩ lɛ ꞊mɔ nahuon, ‑ɔ nyi ꞊tu, nahuon a gblo tio‑ 'n 'ya 'mʋ. Kɛɛ, 'n nye 'nɩ nu, 'ke ba ‑hie Saan a dɛ 'lu ‑wɔn lɛ, ‑ɛ die nu, a 'mue 'mʋ lɛ yrii, ‑ɛ mɔ, Nyɩsʋa, ɔɔ ‑hʋa bɔ waa 'a mʋ. ");
INSERT INTO ted_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Saan a ‑gbɛ, ɔ 'we la ꞊nɔ 'napɩ ye, ‑ɛ nye la nu, nahuin 'ʋʋ lɛ yrii. 'Ke 'le ti gbi 'kwli 'mʋ, aa la nu 'manʋ, 'ke 'o dɛ a ‑gbɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Ɛ kɔ ‑wɛ ‑tɔplɩ ‑ye, 'ɩ nɩ 'o, 'ɩ ‑hi Saan a pupowin wlɔn. Nɩ‑ mɔ 'ŋmilɛka‑tɔplɩ ꞊nʋ, 'nɩɩ nu, 'ke 'le 'na Bu a 'klɩ 'kwli 'mʋ. 'Ŋmilɛka‑tɔplɩ a ‑gbɛ, ɩ nye nahuin 'nɩ tɔɔ ‑tɛɛ, ‑ɛ mɔ, 'na Bu, nɔ‑ lee nɔ 'mʋ 'klɔ ‑gbo ke. ");
INSERT INTO ted_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","'Plɩɩ 'na Bu ꞊nʋ, ‑ɔɔ lee nɔ 'mʋ, ɔ nyi ‑wɛ 'nɩ ꞊tu, nahuon a gblo tio‑ 'n 'ya 'mʋ. A 'de ‑hlɩn 'a win a 'wɛɛn, kɔ, a 'dio ‑hlɩn ‑wɛ a 'yee. ");
INSERT INTO ted_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","A 'nɩ ꞊tu ꞊le 'a win gbo, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ɛ nue, a 'de 'mʋ ꞊wlʋ ye kuo, 'mɔ ‑gbo, ɔ lee nɔ 'klɔ ‑gbo ke. ");
INSERT INTO ted_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aa Nyɩsʋacrɩɩnɩɛi 'nɩ 'nyɩ, ‑ɛ nue, a yie nɩ, ‑ɛ mɔ, nɩ‑ɩ 'a mʋ 'klɔ yrayrʋ ꞊nʋ tɔɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le. 'Ɛ mɔ ‑tɛɛ, Nyɩsʋacrɩɩnɩɛi a ‑gbɛ, nɩ‑ɩ 'na ‑tɩ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Kɛɛ ‑ye a 'nɩ ‑hʋa ꞊le ba di nɔ 'mʋ ‑wɔn, ‑ɛ die nu, 'mʋ 'a mʋ 'klɔ yrayrʋ a ‑gbɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","A nɔ 'nɩ, ‑ɛ mɔ, 'n nye lɛ 'nɩ ꞊mɔ, 'ke nahuin bʋ baa 'mʋ. Kɛɛ, ɛ 'de lɛ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","A ‑mɛ ‑ye, a nɩ 'dɔ. 'N yie nɩ, ‑ɛ mɔ, 'ke 'le 'a nɩ ꞊wlɩ ke, a 'de Nyɩsʋa 'mʋ nʋɛ. ");
INSERT INTO ted_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","'Na Bu lee nɔ 'mʋ 'a mʋ ‑hɛyri, kɛɛ, a 'nɩ ‑hʋa ꞊le ba 'ble 'mʋ kwa. Kɛɛ, nahuon 'bɔ di 'le, 'ke 'le 'a ‑gbɛ a 'klɩ 'kwli 'mʋ, ‑ye a 'blo kwa. ");
INSERT INTO ted_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","A nʋɛ 'mʋ nɩ, 'ke 'a nɩ 'bienʋ bʋ baa 'a mʋ. Kɛɛ, a 'nɩ ꞊mʋɛ ꞊le lɛ, 'ke Nyɩsʋa ꞊nʋ, ‑ɔ mɔ Nyɩsʋaa ‑do, bɔ baa 'a mʋ. 'Bɩa 'ba nɩ lɛ 'mʋ, ‑ye a 'die 'le ‑wɛ ba kuo 'mʋ ꞊wlʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Kɛɛ, a nɩ 'ye 'le, ‑ɛ mɔ, 'n di 'a mʋ yɛɛ ‑tɩ, 'ke 'o 'na Bu ye. 'A winwlɔn‑hɛnyɔ Moise ꞊nʋ, a kuo ꞊wlʋ ye, nɔ‑ di 'a mʋ ‑tɩ yɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","'Bɩa 'bɛ mɔ wɛn ‑tɛɛ, 'ba kuo wɛn Moise ꞊wlʋ ye, 'na ‑gbɛ, a di wɛn ‑wɛ 'mʋ ye kuo ꞊wlʋ, ‑ɛ nue, Moise, ɔ 'crɩɩ 'na ‑tɩ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kɛɛ, ‑tɩ ꞊nʋ, ɔ 'crɩɩ, ‑tɛ a 'di ‑tɛɛ pue, a 'die ‑wɛ 'le ‑wɛ, ba pue 'na win a ‑tɩ ‑tɛɛ.» ");
INSERT INTO ted_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ ꞊ta nɩ, 'ke 'le Galileblʋgba a 'yru a 'pɩa ꞊nʋ ke. 'Yru a ‑gbɛ, ʋ nyu ‑wɛ daa Tibeliadɩ a 'yru; ");
INSERT INTO ted_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","nahuin 'plɔplɔ 'ʋʋ ‑Yusu ‑wɔn kʋɛ, ‑ɛ nue, 'ŋmilɛka‑tɔplɩ ꞊nʋ, ɔɔ o nu, 'ɔɔ nahuin a 'kʋɛi ‑wɔ, ʋ 'yi o nɩ. ");
INSERT INTO ted_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","‑Tɛ ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ nyre 'le, ‑ye 'ke ʋ 'ya 'le dʋgba 'lu, 'ʋ nɩ gbo. ");
INSERT INTO ted_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ti ꞊nʋ 'yri, ‑Juukʋɛ a lɛ'mimre, ʋʋ Pakɩ daa, 'a ti 'mʋɛɛ yrɛ. Nɛ‑ nue, nahuin 'plɔplɔ 'ʋ nɩ ‑tuo ke. ");
INSERT INTO ted_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","‑Yusu bɔ 'ba 'lu ye 'mʋ, ‑ye ɔ 'ye nahuin ‑huohui, 'ʋʋ 'o ꞊nɔ 'hʋɩn 'mʋ di. ‑Tɛ ɔ 'yu 'klɛɛ, ‑ye ɔ ꞊gba 'a ‑naagbopʋyu Filipʋ wlɔn, ɔ nɔ: «‑Be' ‑a di 'klɛɛ dididɛ ye 'yee, ‑a 'mue ‑tɔ, nahuin 'bii ‑gbo, ‑ʋ di 'le, ʋ 'mʋ dɛ di?» ");
INSERT INTO ted_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ɔ ꞊gbɔ wlɔn, ‑ɛ die nu, ɔ 'mue yi, 'bɩa Filipʋ 'bɔ kuo ꞊wlʋ ye, ‑ɛ nue, 'plɩɩ ɔ 'muo wlɔn mu ꞊gba, dɛ ɔ di nu, ɔ yie nɩ ‑dodo. ");
INSERT INTO ted_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","‑Ye Filipʋ ꞊tuo ‑wɔn, ɔ nɔ: «Mɔ ꞊betɩ ‑ba kɔ wɛn 'wliblɔ, ‑a 'die 'le ‑wɛ ‑ba ‑tɔ 'flɔɔ, 'ɛ nɩ nahuon bɔ di 'a ꞊tɩɔ 'cicrɛ di.» ");
INSERT INTO ted_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","‑Ye ‑Yusu a ‑naagbopʋyu Adre, ‑ɔ mɔ Simɔ Piɛlɩ a ‑dɩayu, kɛ ɔɔ 'klɛɛ ‑Yusu ye po, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«'Yu nyɩbɛyu ꞊de nɩ mɔ, 'ɔ kɔ 'flɔɔkuii ꞊hun kɔ ‑hriin 'hɔn. Kɛɛ, ɩ 'die 'le ‑wɛ bɩ nu dɛ ꞊de, 'ke 'o nahuin ‑huohui ‑gbo ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","‑Ye ‑Yusu nɔ: «Ba le nahuin 'bii ‑gbo, bʋ nɩ gblɛ.» ‑Tɛgbi a ‑gbɛ, ‑piti 'plɔplɔ nɩ 'o. 'Ke 'le nahuin 'bii ꞊nʋ ‑hɛyri, nyɩbɛpʋ, ‑ʋ nɩ ‑tuo ke, ʋ ‑wɛ 'le 'milowɩɩ ꞊hun nɩ. ");
INSERT INTO ted_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","‑Tɛ ʋ nɩ 'klɛɛ 'o ‑piti ke gblɛ, ‑ye ‑Yusu 'ba 'flɔɔ a ‑gbɛ 'mʋ nɩ, 'ɔ ‑nyi Nyɩsʋa 'wio, 'ɔ woo nahuin 'mʋ lɛ, 'ɔ 'ba ‑wɛ ‑hrin 'mʋ, 'ɔ wii ‑wɛ ꞊nʋ 'mʋ lɛ, nahuin 'bii, 'ʋ di 'waa ꞊wlɩ a dɛ, 'ʋ ꞊mra. ");
INSERT INTO ted_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","‑Tɛ ʋ ꞊mra 'klɛɛ, ‑ye kɛ ‑Yusuu 'a ‑naagbopʋ ye po: «Ba 'tɛ 'flɔɔ꞊tɩɛ 'bii ꞊nʋ lɛ, ‑ɛ hie gbo, 'a dɛ ꞊de 'nɩ ꞊han 'wan.» ");
INSERT INTO ted_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","'Flɔɔkuii ꞊hun ꞊nʋ, ‑Yusu wloo, nahuin di, 'a dɛ, ‑ɛ hie gbo, nɛ‑ ʋ 'tɛ lɛ, 'ʋ 'yie 'le ‑tʋgbɩɩ ‑pu ꞊tu 'o 'hɔn. ");
INSERT INTO ted_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","'Ŋmilɛkadɛ ꞊nʋ, ‑Yusu nu, ‑tɛ nahuin 'ye, ‑ye ʋ nɔ: «'Ɛ mɔ ‑tɛɛ, nahuon ‑gbo, nɔ‑ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ‑ɔ di la nɔ 'klɔ ke di.» ");
INSERT INTO ted_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Kɛɛ, ‑Yusu yrie nɩ, ‑ɛ mɔ, ʋ dio 'nɩ klɩ, 'ke 'le 'klɩkɔ 'kwli 'mʋ, ɔ 'muo bodɩɔdɛ ‑nyi. Dɛ a ‑gbɛ, ɛ 'de ‑Yusu a kewɛɛnlɛ. Nɛ‑ nue, 'ɔ hren ꞊nʋ ‑wɔn, ɔ ‑do, 'ɔ mu 'le lele dʋgba 'lu. ");
INSERT INTO ted_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","‑Wisepepei 'mʋ, ‑Yusu a ‑naagbopʋ 'ʋ mu 'le 'yru nʋa 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","'Tɔɔ 'nɩ ‑wɔn, ‑Yusu 'de wɛn 'le ꞊nʋ ‑hɛyri a mue. Nɛ‑ nue, 'ʋ 'ya 'le 'blagbe wlɔn, 'ʋʋ bri, 'ʋʋ 'yru ꞊nʋ ꞊ta, 'ʋʋ 'le 'dɩɔ ꞊nʋ 'mʋ mu, ‑ɔ mɔ Kapɛnaɔ. ");
INSERT INTO ted_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","‑Tɛ ʋ nɩ 'klɛɛ 'le 'yru ke, ‑ye pepe gblaka, ɛɛ 'nɩ ‑hi, 'yru 'ʋʋ 'dʋɩ gblakɩ po, ");
INSERT INTO ted_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","'ʋ bri ‑bribri, 'ʋ nu ‑kilowɩɩ ꞊hun ‑hoo' ‑huonnɔ. ‑Ye tii ‑do a ti 'yri, ʋ 'ye ‑Yusu nɩ, 'ɔɔ 'yru ke na, 'ɔɔ 'blagbe ye 'mʋɛɛ. Bʋ 'yo 'klɛɛ, hʋannʋ biu 'le 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Kɛɛ ‑ye ‑Yusu nyu 'nɩ le, ɔ nɔ: «'Mɔɔ nɩ, a nɩ pɩ 'le hʋannʋ!» ");
INSERT INTO ted_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ʋʋ ‑hʋa ‑Yusu bɔ 'ya 'le ꞊nʋ ‑wɔn. ‑Ye tii ‑do a ti 'yri, ‑tɛgbi ʋʋ 'le mu, 'blagbe nyre 'o ꞊o, 'ʋ kwlɛ. ");
INSERT INTO ted_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","‑Tɛ ‑nyrɛ cɛ lɛ, nahuin 'plɔplɔ ꞊nʋ, ‑ʋ hie 'le 'yru a 'pɩa ꞊nʋ ke, ‑tɛgbii ‑do ꞊nʋ, ‑Yusu wloo 'tʋ 'o 'flɔɔ, nahuin a ‑gbɛ, nʋ‑ʋ ‑Yusu lɛ ꞊mɔ. Ʋ yie nɩ, ‑ɛ mɔ, 'blagbee ‑do, nɛ‑ nɩ 'tʋ 'o 'nʋhʋɔn 'mʋ, 'ʋ yie ‑wɛ, ‑ɛ mɔ, ‑Yusu 'de 'tʋ 'le 'blagbe a ‑gbɛ wlɔn 'ya. 'A ‑naagbopʋʋ ‑do, nʋ‑ 'ya 'tʋ 'le, 'ʋ mu 'tʋ. ");
INSERT INTO ted_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","'Ke 'le 'dɩɔ ꞊nʋ 'mʋ, ‑ɔ mɔ Tibeliadɩ, nahuin ‑ye ya 'le 'blagbei, 'ʋ di 'o ‑tɛgbi ꞊nʋ, ‑Yusu ‑nyii 'tʋ 'o Nyɩsʋa 'wio, 'ɔ wloo 'tʋ 'o 'flɔɔ, 'ʋ dio 'tʋ. ");
INSERT INTO ted_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","‑Tɛ nahuin a ‑gbɛ, ʋ 'ye, ‑ɛ mɔ, ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, 'waa nahuon ꞊de 'de 'o nɩ, ʋ 'ya 'le 'waa 'blagbei wlɔn, 'ʋ mu 'le Kapɛnaɔ 'mʋ, 'ʋ mu ‑Yusu lɛ ꞊mɔ wɔn. ");
INSERT INTO ted_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","'Ke ʋ yɛ 'le ‑Yusu 'yru a 'pɩa ꞊nʋ ke gbo, ʋ nɔ: «Tɔɔnyɔ, ti tio‑ kɔ 'yri ‑n nyre nɔ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ: 'Ŋmilɛka‑tɔplɩ ꞊nʋ, 'nɩɩ nu, Nyɩsʋa, nɔ‑ ‑nyi 'mʋ 'klɩ, 'nɩ nyi nu. Kɛɛ, ɛ 'de ba yrii dɛ a ‑gbɛ 'mʋ lɛ a ‑tɩ, a 'nɩ ꞊mɔ ꞊le 'mʋ lɛ. Kɛɛ ‑ye dididɛ, a di 'tʋ, 'a ꞊mra 'tʋ, nɛ‑ kɔ ‑tɩ 'aa 'mʋ lɛ ꞊mɔ. ");
INSERT INTO ted_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","A nɩ ‑hie 'le dididɛɛ ‑do a ‑tɩ 'lu ‑wɔn lɛ, ‑ɛ 'nɩnɩ ‑wlɛn 'o, ‑ɛɛ pɔ, kɛɛ, dididɛ ꞊nʋ, ‑ɛɛ 'a mʋ 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le, nɛ‑ kɔ ‑tɩ ba ‑hie 'lu ‑wɔn lɛ. 'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'mɔ di 'a mʋ dididɛ a ‑gbɛ ‑nyi, ‑ɛ nue, 'na Bu Nyɩsʋa, nɔ‑ lee nɔ 'mʋ 'klɔ ‑gbo ke, 'ke ꞊bo ‑nyi 'a mʋ dididɛ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","‑Ye ʋ nɔ: «Dɛ tio‑ ‑a di nu 'le, 'plɩɩ Nyɩsʋa 'mʋ ‑a mʋ ke wɛɛn?» ");
INSERT INTO ted_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Dɛ Nyɩsʋaa ‑hʋa ba nu, nɛ‑ mɔ ba kuo 'mɔ ‑gbo ꞊wlʋ ye, ɔ lee nɔ 'klɔ ‑gbo ke.» ");
INSERT INTO ted_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","‑Ye ʋ nɔ: «꞊Nɩ nye ‑hʋa, ‑ba pue ‑na pupowin ‑tɛɛ, ‑ye ‑bo nu 'ŋmilɛkadɛ ‑ye, ‑ɛ 'we ꞊nɔ 'a dɛ ꞊nʋ ye, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, ɔɔ la nu. 'Ɛ nɩ ‑nyrɔwɔ, ‑nyi ‑a mʋ dididɛ, ‑a 'mue di, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑a nɩ bunʋʋ la nu, ti ꞊nʋ ‑kɔ 'yri ʋ nɩ la 'le 'pʋhʋɔnblʋgba 'mʋ, 'ʋʋ la dididɛ ꞊nʋ di, ʋʋ manɩ daa, ‑ɛɛ la 'le yakɔ 'mʋ ‑hɔn. Dɛɛ ‑do a ‑gbɛ, nɛ‑ ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Ɔ ‑nyi ꞊nʋ didiflɔɔ, ‑ɔ ‑hɔn 'le yakɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ‑tɛɛ a dididɛ, ‑ɛ kɔ ‑tɩ 'n ꞊tu wɛn, ɛ 'de Moise, ɔ 'die 'a mʋ ‑nyi. Kɛɛ, ‑tɛɛ a dididɛ, ‑ɛ ‑hɔn 'le yakɔ 'mʋ, 'na Bu Nyɩsʋa, nɔ‑ nye 'a mʋ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","‑Tɛɛ a dididɛ, Nyɩsʋaa nahuin ‑nyi, nɛ‑ mɔ dididɛdʋ ꞊nʋ, ‑ɛ ‑hɔn 'le yakɔ 'mʋ, 'plɩɩ ‑ɛ di 'klɔ ke a nahuin 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le.» ");
INSERT INTO ted_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","‑Ye ʋ nɔ: «Tɔɔnyɔ, ‑nyi ‑a mʋ dididɛdʋ a ‑gbɛ 'ɛ nɩ ti!» ");
INSERT INTO ted_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","‑Ye kɛ ɔɔ 'klɛɛ ꞊nʋ ye po, ɔ nɔ: «'Mɔ 'we ꞊nɔ dididɛdʋ ꞊nʋ ye, ‑ɛɛ nahuin 'klɔ yrayrʋ ‑nyi. Nahuon 'bɔ nɩ 'o, 'bɔ kuo 'mʋ ꞊wlʋ ye, 'bɔ ‑hɛ 'na ‑naagbopʋyu, ɔ 'we ꞊nɔ nahuon ꞊nʋ ye, kanʋ 'nɩnɩ nu, kɔ 'nie'natʋ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","'N ꞊tui 'a mʋ ye, ‑ɛ mɔ, a 'ye 'mʋ nɩ, kɛɛ, a 'de 'mʋ ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Nahuin 'bii ꞊nʋ, 'na Buu 'mʋ ‑nyi, ʋ di ‑hɛ 'na ‑naagbopʋ. Gbegbe, 'n 'deɛ ꞊bo bla 'waa nahuoon ‑do ꞊de ke. ");
INSERT INTO ted_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","'N 'de 'le yakɔ 'mʋ ‑hɔn, 'ke ꞊bo nu 'na ‑gbɛ a kewɛɛnlɛ, kɛɛ, Nyɩsʋa, ‑ɔ lee nɔ 'mʋ ‑tʋtʋ ke, nɔ‑ kɔ kewɛɛnlɛ 'n kɔ ꞊bo nu. ");
INSERT INTO ted_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Dɛ Nyɩsʋaa ‑hʋa, nɛ‑ mɔ, nahuin 'bii ‑gbo, ɔ ‑nyi 'mʋ, 'nɩ 'waan 'le 'a nahuoon ‑do, kɛɛ, 'lelɛ'bɔɔ‑nyrɔwɔ 'mʋ, 'n kɔ ꞊bo ‑hɩʋ 'le 'kʋkʋnyʋ ‑hɛyri, 'mu 'klɔ ‑ha. ");
INSERT INTO ted_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","'Ɛ mɔ ‑tɛɛ, dɛ 'na Buu ‑hʋa, nɛ‑ mɔ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ yrie, ‑ɛ mɔ, 'mɔ mɔ Nyɩsʋa a 'Yu, kɔ, 'bɔ kuo 'mʋ ꞊wlʋ ye, nahuon a ‑gbɛ bɔ kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'plɩɩ 'lelɛ'bɔɔ‑nyrɔwɔ 'mʋ, 'n kɔ ꞊bo ‑hɩɔ 'le 'kʋkʋnyʋ ‑hɛyri, 'muo 'klɔ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","‑Juukʋɛ a nyɩgblakɩ bʋ 'wɔn dɛ a ‑gbɛ, ‑ye ʋʋ ‑Yusu lɛ poo yrʋ, ‑ɛ nue, ɔ nɔ 'nɩ, nɔ‑ 'we ꞊nɔ dididɛdʋ ꞊nʋ ye, ‑ɛ ‑hɔn 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Kɛ ʋʋ po: «꞊Be nahuon ‑gbo, ɔ 'de Sosɛfʋ a 'yu ‑Yusu? ‑A yi 'a bu kɔ 'a 'dii 'hɛɛn nɩ. ‑Be' ɔ ‑wɛ 'le bɔ nu 'klɛɛ 'a ꞊tutue, ‑ɛ mɔ, 'ke ɔ ‑hɔn 'le yakɔ 'mʋ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «Dɛ‑ kɔ 'mɔ aa yrʋ lɛ poo 'le? ");
INSERT INTO ted_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Nahuon ꞊de 'die 'le ‑wɛ bɔ kuo 'mʋ ꞊wlʋ ye, 'ke bɔ ‑hɛ 'na ‑naagbopʋyu, 'bɩa 'na Bu, ‑ɔ lee 'mʋ, 'bɔ 'dio 'le ‑jri. 'Na ‑gbɛ ‑gbo, 'lelɛ'bɔɔ‑nyrɔwɔ 'mʋ, 'ɛ nɩ nahuon, ‑ɔ kuo 'mʋ ꞊wlʋ ye, 'mɔ dio 'le 'kʋkʋnyɔ ‑hɛyri ‑ha, 'muo 'klɔ ‑ha. ");
INSERT INTO ted_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nyɩsʋa a winwlɔn‑hɛnyʋ 'crɛɛ la nɩ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ: Nahuin 'bii, Nyɩsʋa, nɔ‑ diu tɔɔ. 'Ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ 'na Bu Nyɩsʋa nʋa ye gbo po, 'plɩɩ 'bɔɔ 'a tɔɔwin kwa 'ble, nɔ‑ di 'na ‑naagbopʋyu ‑hɛ. ");
INSERT INTO ted_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ɛ 'de 'nyrɛ ꞊hɛn, ‑ɛ mɔ, nahuon ꞊de 'ye 'na Bu Nyɩsʋa, 'bɛ 'de 'n ‑do, ‑ɔ ‑hɔn 'le ꞊nɔ ‑wɔn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ kuo 'mʋ ꞊wlʋ ye, nɔ‑ kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","'Mɔ 'we ꞊nɔ dididɛdʋ ꞊nʋ ye, ‑ɛɛ nahuon 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","'A nɩ bunʋ, ‑ʋ nɩ la 'le 'pʋhʋɔnblʋgba 'mʋ, ꞊betɩ bʋʋ la dididɛdʋ ꞊nʋ di, ʋʋ manɩ daa, ‑ɛɛ la 'le yakɔ 'mʋ ‑hɔn, ʋʋ la lɛ 'nɩ 'kʋkʋ. ");
INSERT INTO ted_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Kɛɛ, ‑tɛɛ a dididɛ, ‑ɛɛ 'le yakɔ 'mʋ ‑hɔn, nahuon ꞊nʋ, ‑ɔ die di, ɔ 'deɛ bɔ 'kʋ, ‑ɛ ꞊hɛn 'nyrɛ, ɔ di kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","'Mɔ mɔ dididɛdʋ ꞊nʋ, ‑ɛ ‑hɔn 'le yakɔ 'mʋ, ‑ɛɛ nahuin 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. 'Ɛ nɩ nahuon, ‑ɔ di dididɛ a ‑gbɛ di, 'a 'klɔ yrayrʋ, ɔ di kɔ, ɔ 'die 'le ‑wɛ bɔ kɔ 'lu‑yɩyrɛ. Dididɛ ‑gbo, 'n di ‑ha, nɛ‑ mɔ 'na 'hʋɩn. 'Nɩɩ 'na 'hʋɩn a ‑gbɛ 'nɩ ‑ha, ‑ɛ die nu, 'klɔ ke a nahuin, ʋ 'mʋ 'klɔ yrayrʋ kɔ.» ");
INSERT INTO ted_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","‑Juukʋɛ a ye'mʋnaanyʋ, ‑tɩ ꞊nʋ, ‑Yusu ꞊tu, ɩ po ꞊nʋ 'mʋ yrʋ, 'ʋʋ wlɔn lɛ ꞊gbʋgba, ʋ nɔ: «‑Be' nahuon ‑gbo, ɔ ‑wɛ 'le bɔ nu ‑a mʋ 'a 'hʋɩn a ‑nyinyie, 'plɩɩ ‑a 'mui di 'le?» ");
INSERT INTO ted_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'bɩa 'ba 'nɩnɩ di 'na 'hʋɩn, kɔ, 'bɩa 'ba 'nɩnɩ 'na 'na dablo, a 'deɛ ba kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le gbe. ");
INSERT INTO ted_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nahuon 'bɔ nɩ 'o, 'bɔɔ 'na 'hʋɩn di, kɔ, 'bɔɔ 'na dablo 'na, nahuon a ‑gbɛ, ɔ kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le, 'plɩɩ 'lelɛ'bɔɔ‑nyrɔwɔ 'mʋ, 'n dio 'le 'kʋkʋnyʋ ‑hɛyri 'nɩ ‑ha, 'muo 'klɔ ‑ha. ");
INSERT INTO ted_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","'Na 'hʋɩn mɔ ‑tɛɛ a dididɛ'ɛ nɩ, 'na dablo, ɔ mɔ ‑tɛɛ a 'nɩnadɛ'ɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Nahuon ‑gbo, ‑ɔɔ 'na 'hʋɩn di, kɔ, ‑ɔɔ 'na dablo 'na, ɔ kɔ 'mʋ 'hɛɛn, ‑a ‑mʋɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","'Na Bu ꞊nʋ, ‑ɔ lee nɔ 'mʋ 'klɔ ‑gbo ke, nɔ‑ nye nu, 'plɩɩ nahuin 'ʋ nɩ 'klɔ. Nɔ‑ nue, 'plɩɩ 'na ‑gbɛ, 'nɩ nɩ 'klɔ. Kɛ'ɛ nɩ, ɛ ‑ti 'mʋ, 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔɔ 'na 'hʋɩn di. 'Mɔ nye nu, 'plɩɩ nahuon a ‑gbɛ 'ɔ nɩ 'klɔ. ");
INSERT INTO ted_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","'Mɔ mɔ ‑tɛɛ a dididɛ, ‑ɛ ‑hɔn 'le yakɔ 'mʋ. Ɛ 'de dididɛ ꞊nʋ ye 'we, ‑ɛɛ la 'le yakɔ 'mʋ ‑hɔn, ʋʋ manɩ daa, 'a nɩ bunʋʋ la di, 'ke 'le 'pʋhʋɔnblʋgba 'mʋ. ꞊Betɩ bʋʋ la dididɛdʋ a ‑gbɛ di, ʋʋ la lɛ 'nɩ 'kʋkʋ. Nahuon ꞊nʋ, ‑ɔ di ‑tɛɛ a dididɛ ꞊nʋ di, 'n 'ya 'mʋ, ɔ di kɔ 'klɔ yrayrʋ ꞊nʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le.» ");
INSERT INTO ted_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Tɔɔwin 'bii ‑gbo, ‑Yusu tɔɔ, 'ke ɔ tʋɩ 'le Nyɩsʋa a kayu ꞊nʋ gbo, ‑ʋ nɩ 'le Kapɛnaɔdɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Nahuin ꞊nʋ, ‑ʋʋ ‑Yusu ‑wɔn kʋɛ, 'plɩɩ 'waa 'plɔplɔ, ʋ 'mʋ 'a tɔɔwin ꞊nʋ mu 'wɔn, ‑ye ʋ nɔ: «Tɔɔwin ‑gbo, ɩ nɩ ke 'klɩ. Nahuon ꞊de 'die 'le ‑wɛ bɔ wɩɩn ke.» ");
INSERT INTO ted_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","‑Yusu yree nɩ, ‑ɛ mɔ, nahuin ꞊nʋ, ʋʋ 'mʋ lɛ 'nɩ 'pʋprɛ. Nɛ‑ nue, 'ɔ nyu le, ɔ nɔ: «꞊Be ‑tɩ ‑gbo, 'n ꞊tu, ɩɩ 'a mʋ 'nɩ 'hran? ");
INSERT INTO ted_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","'Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'bɩa 'ba 'ye 'mʋ, 'nɩɩ yakɔ 'mʋ mu, ‑tɛgbi ꞊nʋ, 'n ‑hɔn 'le 'mʋ, ‑be' a di 'klɛɛ po 'le? ");
INSERT INTO ted_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nyɩsʋa a ‑Hihiuu ‑do, nʋ‑ʋ nahuin 'klɔ yrayrʋ ‑nyi. ‑Tʋnahuon a 'klɩ 'de 'le dɛ ꞊de 'le ‑wɛ. Win ‑gbo, 'n tɔɔ 'a mʋ, nɩ‑ nye nu, 'plɩɩ Nyɩsʋa 'ɔɔ 'a mʋ 'a ‑Hihiu ‑nyi, 'plɩɩ ‑Hihiu a ‑gbɛ, ʋ 'mʋ 'a mʋ 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kɛɛ, 'ke 'le 'a mʋ ‑hɛyri, nahuin nɩ 'le, 'ʋ 'de 'mʋ ꞊wlʋ ye kuo.» Kʋɛ la 'le gbo, ‑Yusu yi nahuin ꞊nʋ nɩ, ‑ʋ 'dio ꞊wlʋ ye kuo, kɔ, 'ɔ yi nahuon ꞊nʋ, ‑ɔ dio 'a yraanyʋ kwa po. ");
INSERT INTO ted_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","‑Ye kɛ ɔɔ lele po, ɔ nɔ: «Nɛ‑ nue, 'nɩ le 'a mʋ, ‑ɛ mɔ, nahuon ꞊de 'die 'le ‑wɛ bɔ kuo 'mʋ ꞊wlʋ ye, 'ke bɔ ‑hɛ 'na ‑naagbopʋyu, 'bɩa Nyɩsʋa 'bɔ 'dio 'le ‑jri.» ");
INSERT INTO ted_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nahuin 'plɔplɔ, ‑ʋ nyo o ‑wɔn kʋɛ, kʋɛ 'o ti a ‑gbɛ 'yie 'mʋ gbo, ‑ye ʋ 'kee 'a ‑wɔnkʋkʋɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","'A ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ, kɛ ‑Yusu nyu ye po: «'A nɩ ‑gbɛ, ꞊be aa ‑hʋa ba hie ‑wɛ 'o 'mʋ gbo, ba 'kee 'na ‑wɔnkʋkʋɛ?» ");
INSERT INTO ted_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","‑Ye Simɔ Piɛlɩ ꞊tuo ‑wɔn, ɔ nɔ: «Kʋkɔnyɔ, nyɔ‑ kɔ ‑wɔn ‑a di 'klɛɛ 'le mu 'le? ‑N ‑do, ‑mɔ kɔ win, ‑ɩɩ nahuon 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, ‑a kuo ‑mʋ ye ꞊wlʋ, 'plɩɩ ‑a yie nɩ, ‑ɛ mɔ, ‑mɔ mɔ Nyɩsʋa a 'Yu ‑Yusu 'Klɩsʋ, ɔ lee nɔ 'klɔ ke.» ");
INSERT INTO ted_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'A mʋ ‑pu ꞊tu 'o 'hɔn ‑gbo, 'mɔɔ nɩ, ‑ɔ ‑ha 'le 'a mʋ du 'mʋ, 'ke a 'mʋ 'na ‑naagbopʋ ‑hɛ. Kɛɛ, 'ke 'le 'a mʋ ‑hɛyri, nahuon nɩ 'le, 'ɔ mɔ 'ku ‑hʋan.» ");
INSERT INTO ted_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Judɩa, ‑ɔ mɔ Simɔ Yisikalio a 'yu, nɔ‑ ɔ ꞊hɛn 'nyrɛ. Ɔ mɔ ‑Yusu a ‑naagbopʋʋ ‑pu ꞊tu 'o 'hɔn a nahuon ‑yee nɩ. Kɛɛ, nɔ‑ di ‑Yusu 'a yraanyʋ kwa po. ");
INSERT INTO ted_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Dɛ a ‑gbɛ, ‑tɛ ɛ ‑hi, ‑ye ‑Yusu, ɔɔ Galileblʋgba ke 'nɩ na; ɔ 'nɩ ‑hʋa ꞊le bɔ mu 'le Sudeblʋgba 'mʋ, ‑ɛ nue, ‑Juukʋɛ a ye'mʋnaanyʋ, ʋʋ lɛ ꞊mɔ 'a 'lɩla. ");
INSERT INTO ted_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ti a ‑gbɛ 'yri, ‑Juukʋɛ a lɛ'mimre ꞊nʋ, ʋʋ Papʋɛi a lɛ'mimre daa, 'a ti 'mʋɛɛ yrɛ. ");
INSERT INTO ted_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nɛ‑ nue, ‑Yusu a ‑dɩayuo 'ʋ lo, ʋ nɔ: «‑Hɔn nɔ Galileblʋgba 'mʋ, ‑bo mu 'le Sudeblʋgba 'mʋ, ‑ɛ die nu, ‑na ‑naagbopʋ, ‑ʋ nɩ 'le, ʋ 'mʋ ‑wɛ 'ŋmilɛka‑tɔplɩ ꞊nʋ 'ye, ‑nɩɩ nu. ");
INSERT INTO ted_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nahuon ꞊nʋ, ‑ɔɔ ‑hʋa, 'ke nahuin 'bii bʋ yio, ɔ 'nɩ nu ꞊le ‑tɔplɩ, 'ke 'le ‑huhlikɔ 'kwli 'mʋ. 'A ‑tɩ, ‑tɛ ‑nɩɩ 'ŋmilɛka‑tɔplɩ nu, nui 'ke 'o nahuin 'bii ye, ʋ 'mʋ ‑mʋ yi.» ");
INSERT INTO ted_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","'A ‑dɩayuo a ‑gbɛ, ʋ 'de 'ɛ ‑mɔ ‑Yusu ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","‑Ye kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «Ti 'de wɛn 'o a nyree, 'ke ꞊bo mu 'le. 'Ɛ nɩ ti mɔ ꞊hapʋtii nɩ, 'ke 'o 'a mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","'Klɔ ‑gbo ke a nahuin, ʋ 'deɛ bʋ yraa 'a mʋ, kɛɛ, 'mɛ ‑ye, ʋ yraa 'mʋ nɩ, ‑ɛ nue, 'n nyi 'nɩ ꞊tu, ‑ɛ mɔ, 'waa nunu‑tɔplɩ nyre lɛ 'yi. ");
INSERT INTO ted_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","A ‑mɛ ‑ye, ba mu 'le lɛ'mimre ke. 'Mɛ ‑ye, 'nɩ mu ꞊le 'le, ‑ɛ nue, ti 'de wɛn 'o a nyree, 'ke ꞊bo mu 'le.» ");
INSERT INTO ted_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kɛ ɔ po ꞊nʋ ye, 'ɔ 'de ‑ta 'mʋ ‑hɔn. 'Ke ɔ 'kɩɛ nɩɛ 'le Galileblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","‑Tɛ ‑Yusu a ‑dɩayuo ‑nɩ wɛn, ʋ mu 'klɛɛ lɛ'mimre ke, 'ke 'le Jrusrɛdɩɔ 'mʋ, ‑ye ‑Yusu a ‑gbɛ, ɔ mu ‑wɛ 'le ꞊le, 'ke 'le ‑huhlikɔ 'kwli 'mʋ, ‑ɛ die nu, nahuin 'nɩ ꞊hion 'ye. ");
INSERT INTO ted_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Lɛ'mimre a ti 'yri, ‑Juukʋɛ a ye'mʋnaanyʋ, ʋ nyo lɛ 'nɩ ꞊mɔ, 'ʋʋ wlɔn lɛ ꞊gbʋgba: «‑Be' ‑Yusu nɩ ye 'le?» ");
INSERT INTO ted_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","'ke 'le nahuin ꞊nʋ ‑hɛyri, 'ʋʋ 'a ‑tɩ ꞊tu. ꞊Ʋ ‑ye nɔ: «Ɔ mɔ ꞊hapʋnahuoon nɩ.» ꞊Ʋ ‑ye nɔ: «'Ʋʋn, ɔ 'de ꞊hapʋnahuon, ɔɔ kaa nahuin.» ");
INSERT INTO ted_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Kɛɛ, nahuon ꞊de 'die 'le ‑wɛ bɔ ꞊tui, 'ke 'o nahuin 'bii ye, 'bɛ 'de bʋ bii yee ‑do, ‑ɛ nue, ʋʋ pɩ 'waa ye'mʋnaanyʋ a hʋannʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","‑Tɛ ʋ ‑wle 'klɛɛ lɛ'mimre 'mʋ gbo, ‑ye 'ke ‑Yusu mu 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ɔ ‑tʋa nahuin a tɔɔlɛ gbo. ");
INSERT INTO ted_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","‑Tɛ ‑Juukʋɛ, ʋʋ 'a win 'wɔn, ‑ye ɩ saka ꞊nʋ nɩ, ʋ nɔ: «Nahuon ‑gbo, teteitɔɔnyɔ ꞊de 'dio ‑hlɩn tetei a tʋɛ. ‑Be' ɔ ‑wɛ 'le bɔ nu ‑tɔplɩ 'plɔplɔdʋ ‑gbo a yiyie 'le?» ");
INSERT INTO ted_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","‑Ye kɛ ɔ nyu ye po, ɔ nɔ: «‑Tɔplɩ ‑gbo, 'nɩɩ 'a mʋ tɔɔ, Nyɩsʋa, ‑ɔ lee nɔ 'mʋ, nɔ‑ɔ 'mʋ 'a ꞊tɔ ‑nyi. Ɛ 'de 'na ‑gbɛ a ꞊tɔ. ");
INSERT INTO ted_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nahuon 'bɔ nɩ 'o, 'bɔɔ ‑hʋa bɔ nu dɛ ꞊nʋ, ‑ɛɛ Nyɩsʋa a plɔ blee, ‑ye ɔ die 'mʋ lɛ 'nɩ yrii, 'bɩa tɔɔlɛ ‑gbo, 'nɩɩ tɔɔ, 'bɛ 'ya Nyɩsʋa a 'lu a lɛ‑hielɛ 'mʋ, ‑hee' 'bɩa 'nɩɩ tɔɔ, 'ke 'le 'na ‑gbɛ a 'klɩ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nahuon ꞊nʋ, ‑ɔɔ tɔɔ, 'ke 'le 'a ‑gbɛ a 'klɩ 'kwli 'mʋ, ɔ nye 'nɩ ‑hʋa, 'ke nahuin bʋ bɔɔ. Kɛɛ, nahuon ꞊nʋ, ‑ɔɔ tɔɔ, 'ke nahuin bʋ baa nahuon ꞊nʋ, ‑ɔ lee ꞊nɔ, nɔ‑ɔ ‑tɩ a ‑tɛɛ ꞊tu. Hɩ 'de 'le 'a pupowin ‑hɛyri nɩ. ");
INSERT INTO ted_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moise, ɔ ‑nye 'a nɩ bunʋ tetei nɩ. Kɛɛ, 'ke 'le 'a mʋ ‑hɛyri, nahuon ꞊de 'nɩ ꞊tui ꞊le 'o. Dɛ 'klan tio‑ 'n nu, ‑ɛ kɔ 'mɔ aa ‑hʋa ba 'la?» ");
INSERT INTO ted_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","‑Ye nahuin ꞊tuo ‑wɔn, ʋ nɔ: «‑Mɔ nyɔ ‑gbo, 'ku ‑hʋan nɩ 'o ‑mʋ ke 'mʋ. Nahuon tio‑o ‑na 'lɩla lɛ ꞊mɔ?» ");
INSERT INTO ted_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","‑Ye ‑Yusu nɔ: «Dɛɛ ‑do, 'n nu, nɛ‑ mɔ, 'n ‑wɔ o nahuon ꞊de a 'kʋɛ ‑wuwle‑nyrɔwɔ 'mʋ. 'Plɩɩ ‑ye, a 'bii, ɩ saka o 'a mʋ nɩ, 'ke ꞊bo di o dɛ a ‑gbɛ nu ‑wuwle‑nyrɔwɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kɛɛ, a ‑mɛ ‑ye, aa ‑wɛ nu ‑kʋan ‑wuwle‑nyrɔwɔ 'mʋ, ‑ɛ nue, Moise le la 'a nɩ bunʋ nɩ, 'ke ba 'bɛ 'a nɩ 'yuo nyɩbɛpʋ yrɛ, 'yu 'bɔ kɔ ‑nyrɔwɩɩ ‑yehɛn‑yehɛn. ‑Ye 'klɛɛ, ꞊betɩ ‑wuwle‑nyrɔwɔ 'mʋ, aa 'a nɩ 'yuo nyɩbɛpʋ yrɛ 'nɩ 'bɛ. 'Ɛ mɔ ‑tɛɛ, 'a nɩ bunʋ, ‑ʋ nɩ la 'klɔ, 'plɩɩ Moise 'mʋ la 'klɔ nɩ, nʋ‑ ꞊tue ‑wlu, ɛ 'de Moise. ");
INSERT INTO ted_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","‑Tɛ aa 'a nɩ 'yuo nyɩbɛpʋ yrɛ 'bɛ ‑wuwle‑nyrɔwɔ 'mʋ, ‑ɛ die nu, a 'nɩ ꞊han Moise a tete 'wla, ꞊be nahuon ‑gbo, 'kʋɛɛ nu, ‑bo ‑wɔ 'a 'kʋɛ a ‑gbɛ, ɛ 'de 'o ye'bɩbɛ 'mʋ ‑hi? ‑Tɛ 'n ‑wɔ o nahuon a 'kʋɛ ‑wuwle‑nyrɔwɔ 'mʋ, dɛ‑ kɔ 'mɔ aa yrʋ lɛ poo 'le? ");
INSERT INTO ted_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","‑Tɔplɩɩ ‑do ‑gbo, 'a nɩ 'yii 'ye, ɩ nɩ nue 'le, a nɩ yɛɛ 'le nahuon ‑tɩ. Kɛɛ, 'plɩɩ a 'mʋ ‑tɩ mu ꞊tu, ba ‑hie 'lu lɛ ‑tɛɛ, 'plɩɩ a 'mui ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jrusrɛ 'mʋ a nahuin ‑ye, kɛ ʋʋ po: «꞊Be ɛ 'de nahuon ‑gbo, ‑ɔ kɔ 'lɩla ʋʋ lɛ ꞊mɔ? ");
INSERT INTO ted_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ba 'ye kɛ, nɔ‑ɔ 'prɛ, 'ke 'le nahuin 'bii ye, 'plɩɩ ‑a nɩ ye'mʋnaanyʋ, ʋ 'nɩ puo ꞊le mɛ lɛ. ꞊Be ʋ yrie nɩ, ‑ɛ mɔ, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya? ");
INSERT INTO ted_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kɛɛ, 'ke 'le 'pɩa ‑ye ke, Waanyɔ a ‑gbɛ 'bɔ di 'le, ‑tɛgbi ɔ ‑hɔn 'o 'mʋ, nahuon ꞊de 'deɛ bɔ yii 'o. Kɛɛ ‑ye nahuon ‑gbo, ‑tɛgbi ɔ ‑hɔn 'o 'mʋ, ‑a yii 'o ꞊o.» ");
INSERT INTO ted_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Tii ‑do a ‑gbɛ 'yri, ‑Yusuu 'nɩ tɔɔ, 'ke 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ɔɔ 'le win 'yaa, ɔ nɔ: «꞊Be sɛyɩ‑sɛyɩ, nahuon a gblo tio‑ 'n 'ya 'mʋ, a yio nɩ? Kɔ, ‑tɛgbi 'n ‑hɔn 'o 'mʋ, a yii ‑wɛ 'o ꞊o? Ɛ 'de 'na ‑gbɛ a 'klɩ 'kwli 'mʋ, 'n 'de 'le di. Nahuon ‑ye, nɔ‑ lee nɔ 'mʋ. Nahuon a ‑gbɛ, ɔ mɔ ꞊wlʋyekuonyɔ'ɔ nɩ. A ‑mɛ ‑ye, a 'dio yi. ");
INSERT INTO ted_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Kɛɛ, 'mɛ ‑ye, 'n yio nɩ, ‑ɛ nue, 'ke 'n ‑hɔn 'le ꞊nɔ ‑wɔn 'mʋ, kɔ, nɔ‑ lee nɔ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","‑Tɛ nahuin ꞊nʋ, ʋ 'wɩn, ‑ye ʋʋ ‑hʋa bʋ klo, kɛɛ, nahuon ꞊de 'die 'le ‑wɛ bɔ gbɔ 'o dabʋ 'hʋɩn 'mʋ, ‑ɛ nue, ti 'de wɛn 'o a nyree, 'ke bʋ klo. ");
INSERT INTO ted_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Kɛɛ ‑ye 'ke 'le nahuin ꞊nʋ ‑hɛyri, 'waa 'plɔplɔ kuo ꞊wlʋ ye. Kɛ ʋʋ po: «‑Tado, nahuon ‑gbo, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya. ꞊Be ɛ di kɔ nahuon ‑ye, ‑ɔ di 'ŋmilɛka‑tɔplɩ 'plɔplɔ nu, ɔ 'mʋ 'o nahuon ‑gbo 'mʋ ‑hi?» ");
INSERT INTO ted_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","‑Ye Falisi꞊tumu a nahuin, ʋ 'wɔn ‑tɩ ꞊nʋ nɩ, nahuiin 'le gbo ble, ʋʋ ꞊tu, 'ke 'o ‑Yusu ke. Nɛ‑ mɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ Falisi꞊tumu a nahuin 'hɛɛn, bʋ le 'sɔyuo, 'ke bʋ klɩ ‑Yusu. ");
INSERT INTO ted_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","‑Tɛ ‑Yusu 'ye dɛ a ‑gbɛ, ‑ye kɛ ɔɔ po: «'Ke 'le ti gbi 'kwli 'mʋ, 'n 'kɩɛ die nɔ 'a mʋ ‑hɛyri nɩ, 'plɩɩ 'mʋ 'le nahuon ꞊nʋ ‑wɔn mu, ‑ɔ lee nɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","A di 'mʋ lɛ 'nɩ ꞊mɔ, kɛɛ, a 'deɛ ba 'ye 'mʋ, ‑ɛ nue, ‑tɛgbi ꞊nʋ, 'nɩɩ 'le mu, a 'die 'le ‑wɛ ba mu 'le.» ");
INSERT INTO ted_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","‑Ye ‑Juukʋɛ, ʋʋ wlɔn lɛ 'nɩ ꞊gbʋgba, ʋ nɔ: «‑Be' ɔ di 'klɛɛ ye mue 'le, 'ke ‑a 'nɩnɩ dio 'ye? ꞊Be 'ke ɔ di 'le ‑a nɩ 'bienʋ ‑Juukʋɛ ꞊nʋ ‑wɔn mu, ‑ʋ nɩ 'le dakʋ a nahuin ‑hɛyri, ‑ʋ 'de ‑Juukʋɛ, ɔ 'mʋ ‑wɛ dakʋ a nahuin a ‑gbɛ tɔɔ? ");
INSERT INTO ted_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","‑Tɩ ‑gbo, ɔ ꞊tu, dɛ tio‑ ɛ ꞊hɛn 'nyrɛ 'le, ‑tɛ ɔ plɛ, ‑ɛ mɔ: A di 'mʋ lɛ 'nɩ ꞊mɔ, kɛɛ, a 'deɛ ba 'ye 'mʋ, ‑ɛ nue, ‑tɛgbi ꞊nʋ, 'nɩɩ 'le mu, a 'die 'le ‑wɛ ba mu 'le.» ");
INSERT INTO ted_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lɛ'mimre ꞊nʋ, 'a 'lelɛ'bɔɔ‑nyrɔwɔ, nɔ‑ mɔ ‑nyrɔwɔ gblaka. ‑Nyrɔwɔ a ‑gbɛ 'mʋ, ‑ye ‑Yusu 'ba 'mʋ ye, 'ke 'o nahuin ‑huohui ꞊nʋ ye, 'ɔɔ 'le win 'yaa, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'nie'natʋ 'bʋ nyo nu, ‑ye kɛ bɔ di nɔ 'mʋ ‑wɔn, ɔ 'mʋ 'na. ");
INSERT INTO ted_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nahuon ꞊nʋ, ‑ɔ kuo 'mʋ ꞊wlʋ ye, ɛ 'we ꞊nɔ ye, 'nɩlu nɩ 'le 'a ꞊wlʋ ke, 'plɩɩ 'niedʋ ꞊nʋ, ‑ɛɛ ‑tʋnahuin 'klɔ yrayrʋ ‑nyi, nɛ‑ di 'le 'a ꞊wlʋ ke 'mʋ ‑hɔn. Kɛ'ɛ nɩ, ʋ nu la 'a 'crɩɩlɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Dɛ ꞊nʋ ‑kɔ ‑tɩ ‑Yusu ꞊tu, nɛ‑ mɔ Nyɩsʋa a ‑Hihiu ꞊nʋ, Nyɩsʋa di nahuin ꞊nʋ ‑nyi, ‑ʋ kuo ‑Yusu ꞊wlʋ ye. Ti a ‑gbɛ 'yri, Nyɩsʋa 'de wɛn 'a ‑Hihiu nahuin a ‑nyee, ‑ɛ nue, ‑Yusu 'de wɛn 'le yrayrɩ a mue, 'ke 'le 'a ‑tɩ a 'yi'bʋaalɛ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nahuin ꞊nʋ, ‑tɛ ʋ 'wɔn ‑Yusu a win, 'waa dɛ ‑ye, kɛ ʋʋ po: «'Ɛ mɔ ‑tɛɛ, nahuon ‑gbo, nɔ‑ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔ ꞊nʋ, ʋ po la lɛ, ‑ɔ kɔ ‑bɔ di la 'le.» ");
INSERT INTO ted_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Kɛ ꞊ʋ ‑yee po: «Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, nɔ‑ɔ nɩ.» Kɛ ꞊ʋ ‑yee po: «Waanyɔ a ‑gbɛ, ɔ 'deɛ bɔ kɔ 'le Galileblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kɛ Nyɩsʋacrɩɩnɩɛɛ po: Waanyɔ a ‑gbɛ, 'ke ɔ di 'le bodɩɔ Dafidɩ a ꞊tugba ‑hɛyri kɔ, kɔ, 'ɔ di 'le Betelɛmʋdɩɔ 'mʋ kɔ, ‑ɔ mɔ Dafidɩ a ‑gbɛ a 'dɩɔ.» ");
INSERT INTO ted_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ɛ 'we ꞊nɔ ye, nahuin ꞊nʋ, ʋ 'bɛ lɛ ꞊tɩɔ, ‑Yusu a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","꞊Ʋ ‑yee ‑hʋa bʋ klo, kɛɛ, nahuon ꞊de 'die 'le ‑wɛ bɔ gbɔ 'o dabʋ 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","‑Ye 'sɔyuo ‑nɩ wɛn, ʋ ꞊hɩan ‑wɔn, 'ʋ mu 'le Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ Falisi꞊tumu a nahuin 'hɛɛn ‑wɔn. ‑Ye nyɩgblakɩ a ‑gbɛ, ʋ ꞊gbʋ wlɔn: «Dɛ‑ kɔ ‑Yusu a 'de 'le ya 'le?» ");
INSERT INTO ted_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","‑Ye 'sɔyuo a ‑gbɛ, ʋ ꞊tu ‑wɔn, ʋ nɔ: «‑A 'de ‑hlɩn nahuon ꞊de a 'yee, ‑bɔ 'prɛ, ‑ɛ 'we ꞊nɔ nahuon ‑gbo ye.» ");
INSERT INTO ted_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nɛ‑ mɔ Falisi꞊tumu a nahuin bʋ ꞊gbʋ wlɔn: «꞊Be 'a nɩ ‑gbɛ, a wɛɛn ‑wɛ ke, 'ke nahuon ꞊nʋ bɔ kaa 'a mʋ. ");
INSERT INTO ted_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","‑A mʋ Falisi꞊tumu a nahuoon ‑do ꞊de 'dio ꞊wlʋ ye kuo, 'plɩɩ ɛ 'de ‑wɛ 'blʋgba a ye'mʋnaanyɔ ꞊de kɔ, ‑bɔ kuo ꞊wlʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kɛɛ, dakʋ a dɛ ꞊nʋ, ‑ʋ kuo ꞊wlʋ ye, ʋ 'de Moise a tetei yi. 'A ‑tɩ, Nyɩsʋa a ‑bati diu 'nɩ klɩ.» ");
INSERT INTO ted_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Falisi꞊tumu a nahuon ꞊nʋ, ‑ɔ mɔ Nikodɛmʋ, ɔ nɩ la ‑wɛ ke ‑tuo. Nɔ‑ɔ nɩ, ‑ɔ mu la ‑Yusu 'ye wɔn, ti ꞊de a ti 'yri la. Kɛ ɔɔ 'klɛɛ 'a 'bienʋ ye po, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«‑A nɩ tetei nɔ 'nɩ: 'Plɩɩ ‑a 'mʋ nahuon ‑tɩ yɛɛ, ‑a kɔ ‑ba puo nʋa ye gbo. ꞊Ba 'ye, ‑ɛ mɔ, ɔ nu dɛ 'klan, ‑ye ‑bati dio 'nɩ klɩ.» ");
INSERT INTO ted_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «꞊Be ‑na ‑gbɛ, 'ke ‑n kɔ ‑wɛ 'le Galileblʋgba 'mʋ? ‑Hre Nyɩsʋacrɩɩnɩɛi ‑tɛɛ. ‑N die 'nɩ 'ye, ‑ɛ mɔ, Nyɩsʋa a winwlɔn‑hɛnyɔ ꞊de 'die 'le ‑wɛ bɔ kɔ 'le Galileblʋgba 'mʋ.»  ");
INSERT INTO ted_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ʋ ‑gbɛ lɛ. Nahuon 'bɔ nɩ 'o, 'ke ɔ mu 'le 'a kayu gbo. ");
INSERT INTO ted_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","‑Ye 'ke ‑Yusu mu 'le dʋgba ꞊nʋ 'lu, ‑ɔ kɔ 'lu ti ꞊de nɩ 'le, ʋʋ olifie daa. ");
INSERT INTO ted_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ɔ ꞊hɩan ‑wɔn, 'ɔ mu 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, nahuin 'plɔplɔ 'ʋ 'yɩya 'o ꞊nɔ 'hʋɩn 'mʋ gbo, 'ɔ nɩ gbo, 'ɔ ‑tʋa 'waa tɔɔlɛ gbo. ");
INSERT INTO ted_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","‑Tɛ ɔ nɩ 'klɛɛ 'le nahuin a tɔɔlɛ 'kwli 'mʋ, ‑ye ‑Juukʋɛ a teteitɔɔnyʋ kɔ Falisi꞊tumu a nahuin 'hɛɛn, nʋ‑ gba 'o ꞊nɔ nyrʋgba ꞊de 'hʋɩn 'mʋ. Nyrʋgba a ‑gbɛ, ɔ nɩ 'le ‑wlawli a nunue 'kwli 'mʋ, 'ʋ klo, 'ʋ yɔ 'le, 'ʋ ꞊tuo 'o nahuin 'bii ye gbo. ");
INSERT INTO ted_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","‑Ye ʋʋ 'klɛɛ ‑Yusu 'nɩ le, ʋ nɔ: «Tɔɔnyɔ, nyrʋgba ‑gbo, ɔ nɩ 'le ‑wlawli a nunue 'kwli 'mʋ, ꞊a klo, ꞊a yɔ 'le. ");
INSERT INTO ted_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","'Ɛ mɔ ‑tɛɛ, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, 'a tete ‑ye nye ‑a mʋ 'nɩ tɔɔ, ‑ɛ mɔ, nyrʋgbapʋ, ‑ʋʋ dɛ a ‑gbɛ nu, ‑ba pu 'hɛ ‑wɔn lɛ, ‑ba 'lʋ. ‑Mɛ ‑ye, ‑be' ‑nɩɩ po 'le?» ");
INSERT INTO ted_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ʋ nyi 'nɩ ꞊tu, ‑ɛ die nu, ʋ 'muo 'mʋ lɛ ꞊tɔ, ʋ 'mue 'ye, 'bɩa 'bɔ di Nyɩsʋa a tete 'wla, ‑ɛ die nu, ʋ 'muo ‑tɩ yɛɛ. Kɛɛ ‑ye ‑Yusu ꞊tɩtɩ 'mʋ nɩ, 'ɔɔ ‑jie nu, 'ɔɔ 'o ‑tʋtʋ ke 'crɩɩ. ");
INSERT INTO ted_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","‑Tɛ ʋ 'kɩɛ ꞊gbɔɔ wlɔn lɛ, nɛ‑ mɔ bɔ 'wɔɔ 'le ke lɛ, ɔ nɔ: «'Ke 'le 'a mʋ ‑hɛyri, nahuon ꞊nʋ, ‑ɔ 'de ‑hlɩn dɛ 'kuku a nue, nɔ‑ ‑bɔ 'ya ye‑hɛnahuon 'mʋ, ‑bɔ puo 'hɩɔ ‑wɔn.» ");
INSERT INTO ted_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","‑Ye ɔ ꞊tɩtɩ lele 'mʋ nɩ, 'ɔɔ 'o lele ‑tʋtʋ ke 'crɩɩ. ");
INSERT INTO ted_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","'Plɩɩ ʋ 'mʋ ‑Yusu a pupowin a ‑gbɛ mu 'wɔn, ‑ye ʋ po ‑dodo, 'ʋʋ lɛ mumu. Nyɩgblakɩ, nʋ‑ mɔ ye‑hɛnahuin, ‑ʋ ‑tʋa lɛmumulɛ gbo. ‑Ye ‑Yusu kɔ nyrʋgba a ‑gbɛ 'hɛɛn, ʋ ‑do, nʋ‑ hie 'o, 'ke 'o nahuin ye. Nyrʋgba a ‑gbɛ, ɔ 'kɩɛ nyrɛɛ 'o ꞊nɔ ye gbo. ");
INSERT INTO ted_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","‑Ye ɔ 'wɔɔ 'le lele lɛ ke, ɔ nɔ: «Nyrʋgba o, nahuin ‑gbo, ‑ʋʋ wɛn ‑mʋ ‑tɩ yɛɛ, ‑be' ʋ nɩ ye 'le? ꞊Be ꞊ɔ ꞊de 'de 'o hie, ‑bɔ plɛ, ‑n nɩ 'mʋ 'kʋkʋɛ?» ");
INSERT INTO ted_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","‑Ye ɔ nɔ: «Iin ‑o, Kʋkɔnyɔ o. 'A nahuon ꞊de 'de 'o hie.» ‑Ye ‑Yusu nɔ: «'Na ‑gbɛ, 'nɩ po ꞊le ‑wɛ lɛ, ‑ɛ mɔ, ‑n nɩ 'mʋ 'kʋkʋɛ. ‑N ‑wɛ 'le ‑bo mu nɩ. Kɛɛ, ꞊nɩ nu 'le 'klɛɛ lele dɛ 'kuku.» ");
INSERT INTO ted_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kɛ ‑Yusu, ɔɔ lele nahuin ꞊nʋ ye po, ɔ nɔ: «'Mɔɔ nɩ, ‑ɔɔ 'klɔ ‑gbo a nahuin ‑nyrɛ ‑nyi, ‑ɛ die nu, ʋ 'mʋ ‑tɩ a ‑tɛɛ 'mʋ lɛ yrii. Nahuon 'bɔ nɩ 'o, 'bɔ kuo 'mʋ ꞊wlʋ ye, ‑ye ɔ di ‑nyrɛdʋ ꞊nʋ 'nɩ kɔ, ‑ɛɛ nahuon 'klɔ yrayrʋ ‑nyi. Ɔ 'deɛ bɔ na 'klɛɛ lele gbɩgbɩyrɩ 'mʋ lɛ.» ");
INSERT INTO ted_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","‑Ye Falisi꞊tumu a nahuin ꞊tuo ‑wɔn, ʋ nɔ: «‑Na ‑gbɛ, ‑mɔɔ ‑n dɩɔnʋ a ‑tɩ ꞊tu. 'A ‑tɩ, ‑tɩ ‑nɩɩ ꞊tu, ɩ 'de ‑tɩ a ‑tɛɛ.» ");
INSERT INTO ted_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","‑Ye ‑Yusu nɔ: «Mɔ ꞊betɩ 'n ‑do, ꞊boo 'n dɩɔnʋ a ‑tɩ ꞊tu, ‑tɩ 'nɩɩ ꞊tu, ɩ mɔ ‑tɩ a ‑tɛɛ nɩ, ‑ɛ nue, ‑tɛgbi 'n ‑hɔn 'o 'mʋ, kɔ, 'n di 'le lele mu, 'n yii 'o ꞊o. Kɛɛ, a ‑mɛ ‑ye, a 'de 'o yii. ");
INSERT INTO ted_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","‑Tɛ ‑tʋnahuiin 'waa 'bienʋ ‑tʋnahuin a ‑tɩ a yɛɛlɛ nu, kɛ'ɛ nɩ, aa nahuin a ‑tɩ a yɛɛlɛ nu. 'Mɛ ‑ye, 'nɩ yɛɛ ꞊le nahuon ꞊de ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Kɛɛ, 'bɩa 'nɩ kɔ ꞊bo yɛɛ nahuin ‑tɩ, ‑ye ‑tɩ ꞊nʋ, 'nɩɩ ꞊tu, ɩ mɔ ‑tɩ a ‑tɛɛ nɩ, ‑ɛ nue, ɛ 'de 'n ‑do, 'nɩ yɛɛ ꞊le nahuin ‑tɩ, kɛɛ, 'na Bu ‑gbo, ‑ɔ lee nɔ 'mʋ, ɔ kɔ 'mʋ 'hɛɛn, ‑a mʋ pɛ. ");
INSERT INTO ted_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ʋ 'crɩɛ la nɩ, 'ke 'le Nyɩsʋa a teteicrɩɩnɩɛ 'kwli 'mʋ, ‑hɛhɩpʋʋ 'hɔn, 'bʋ ꞊tu ‑tɩɩ ‑do, ‑ye ‑tɩ a ‑gbɛ, ʋ ꞊tu, ɩ mɔ ‑tɩ a ‑tɛɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","'Nɩɩ ꞊tu 'n dɩɔnʋ a ‑tɩ, kɔ, 'na Bu, ‑ɔ lee nɔ 'mʋ, 'ɔɔ ‑wɛ 'na ‑tɩ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","‑Ye ʋ ꞊gbɔ wlɔn, ʋ nɔ: «‑Be' ‑na Bu nɩ ye 'le?» ‑Ye ‑Yusu nɔ: «Mɔ, a 'de 'mʋ yi, kɔ, 'a 'de ‑wɛ 'na Bu yi. 'Bɩa 'ba yi wɛn 'mʋ, ‑ye a di wɛn ‑wɛ 'na Bu 'nɩ yi.» ");
INSERT INTO ted_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","‑Tɛ ‑Yusu, ɔɔ nahuin ‑tɔplɩ ꞊nʋ tɔɔ, 'ke ɔ nɩ 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ gbo, 'ke 'o dokwliye ꞊nʋ 'hʋɩn 'mʋ, ‑ɛ kɔ wlɔn ʋʋ 'le 'wli lɛ po. Kɛɛ, ꞊ɔ ꞊de 'die 'le ‑wɛ bɔ klo, ‑ɛ nue, ti 'de wɛn 'o a nyree, 'ke bʋ klo. ");
INSERT INTO ted_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","‑Ye kɛ ‑Yusuu lele ꞊nʋ ye po: «'N di 'nɩ mu, a 'mʋ 'na 'yiye lɛ ꞊mɔ, kɛɛ, a 'deɛ ba 'ye 'mʋ. A di lɛ 'nɩ 'kʋkʋ, 'ke 'le 'a nɩ dɛ 'kuku ‑hɛyri. ‑Tɛgbi 'nɩɩ 'le mu, a 'de 'le mumue ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","‑Ye kɛ ‑Juukʋɛ a ye'mʋnaanyʋʋ po: «꞊Be ɔ di 'a dɩɔnʋ 'nɩ 'la, ‑ɛ nue, ɔ nɔ 'nɩ, ‑tɛgbi ꞊nʋ, ɔɔ 'le mu, ‑a 'de 'le mumue ‑wɛ?» ");
INSERT INTO ted_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","‑Ye ‑Yusu nɔ: «'A mʋ mɔ 'klɔ ‑gbo a nahuiin nɩ. Kɛɛ, 'mɛ ‑ye, 'n 'de nɔ 'klɔ ‑gbo ke 'mʋ ‑hɔn. 'Ke 'n ‑hɔn 'le yakɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","'N le 'a mʋ nɩ, ‑ɛ mɔ, a di lɛ 'nɩ 'kʋkʋ, 'ke 'le 'a nɩ dɛ 'kuku ‑hɛyri. A kɔ ba kɔ 'a yiyie, ‑ɛ mɔ, 'mɔ mɔ nahuon ꞊nʋ, 'n plɛ, 'n 'ya 'mʋ. 'Bɩa 'ba 'die ‑tɛɛ pue, ‑ye a di lɛ 'nɩ 'kʋkʋ, 'ke 'le 'a nɩ dɛ 'kuku ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","‑Ye ʋ ꞊gbɔ wlɔn, ʋ nɔ: «Nahuon a gblo tio‑ ‑n 'ya 'klɛɛ 'le?» ‑Ye ɔ nɔ: «꞊Be a nye 'nɩ ‑hʋa, 'ke ꞊bo ꞊tui lele? 'Mɔ mɔ nahuon ꞊nʋ, ‑ɔ kɔ ‑tɩ 'nɩɩ ꞊tu, kʋɛ la 'le gbo. ");
INSERT INTO ted_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","'N kɔ wɛn ‑tɩ 'plɔplɔ a ꞊tutue, 'ke 'o 'a mʋ ke, kɔ, 'nɩ kɔ wɛn 'hru, 'ke ꞊bo yɛɛ wɛn 'a mʋ ‑tɩ. Kɛɛ, 'nɩ ꞊tu ꞊le 'klɛɛ ‑tɩ 'bii. Nahuon ꞊nʋ, ‑ɔ lee nɔ 'mʋ, ‑tɩɩ ‑do ꞊nʋ, 'n 'wɔɔn 'o ꞊nɔ wien, nɩ‑ 'nɩɩ ꞊tu, 'plɩɩ nahuon a ‑gbɛ, ɔɔ ꞊tu ‑tɩ a ‑tɛɛ.» ");
INSERT INTO ted_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ʋ 'nɩ yrii ꞊le 'mʋ lɛ, ‑ɛ mɔ, 'a Bu a ‑tɩɩ nɩ, ɔɔ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","‑Ye kɛ ɔɔ lele ꞊nʋ ye po, ɔ nɔ: «Ti ꞊nʋ ‑kɔ 'yri 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, a di 'o 'mʋ ye 'mʋ 'baa, 'ke 'o tu 'yie 'mʋ, 'mʋ ‑tʋtʋ ‑wɔn hren, a die 'nɩ yrii, ‑ɛ mɔ, 'mɔ mɔ nahuon ꞊nʋ, 'n plɛ, 'n 'ya 'mʋ. A die ‑wɛ 'mʋ lɛ 'nɩ yrii, ‑ɛ mɔ, 'nɩ nu ꞊le dɛ ꞊de, 'ke 'le 'na ‑gbɛ a 'klɩ 'kwli 'mʋ. ‑Tɩɩ ‑do ꞊nʋ, 'na Bu tɔɔ 'mʋ, nɩ‑ 'nɩɩ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nahuon ꞊nʋ, ‑ɔ lee nɔ 'mʋ, 'ke ɔ nɩ 'o 'mʋ 'hʋɩn 'mʋ. Ɔ 'de 'o 'n ‑do gbo hie, ‑ɛ nue, 'ɛ nɩ ti, dɛ ꞊nʋ, ‑ɛɛ 'a plɔ blee, nɛ‑ 'nɩɩ nu.» ");
INSERT INTO ted_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","‑Yusu bɔ po 'klɛɛ lɛ, ‑ye nahuin 'plɔplɔ kuo ye ꞊wlʋ. ");
INSERT INTO ted_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","‑Ye kɛ ‑Yusuu nahuin ꞊nʋ ye po, ‑ʋ kuo ꞊wlʋ ye, ɔ nɔ: «'Na tɔɔwin ꞊nʋ, 'ba nyi 'o ꞊tuu, ‑ye 'a mʋ mɔ 'na ‑tɛɛ a ‑naagbopʋʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","'Na tɔɔwin a ‑gbɛ a 'o꞊tuulɛ, ɛ die 'nɩ nu, 'plɩɩ a 'mʋ ‑tɩ a ‑tɛɛ yi. ‑Tɩ a ‑tɛɛ a ‑gbɛ, ɩ di 'a mʋ 'nɩ ꞊gbla, 'ke 'le ꞊godɛ ꞊nʋ wlɔn.» ");
INSERT INTO ted_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","‑Ye ‑Juukʋɛ a ye'mʋnaanyʋ, ʋ nɔ: «‑A mʋ mɔ Abrahamʋ a 'yuo a 'yuoo nɩ. ‑A 'de ‑hlɩn ꞊ɔ ꞊de a ꞊go 'mʋ a 'yɛɛ. Dɛ‑ kɔ ‑tɩ ꞊nɩɩ lɛ ‑a mʋ yrɛ poo, ‑ɛ mɔ, ‑tɩ a ‑tɛɛ di ‑a mʋ 'nɩ ꞊gbla, 'ke 'le ꞊godɛ ꞊nʋ wlɔn.» ");
INSERT INTO ted_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ dɛ 'kuku nu, ‑ye ɔ mɔ dɛ 'kuku a ꞊ge'e nɩ. ");
INSERT INTO ted_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","꞊Ge 'de ye blɛ bɔ 'cipi 'le kayuu ‑do gbo. Kɛɛ, 'kabu a 'yu, nɔ‑ 'cipi 'le kayu gbo. ");
INSERT INTO ted_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","'Mɔ ‑gbo, ‑ɔ mɔ Nyɩsʋa a 'Yu, 'bɩa 'nɩ ꞊gbla 'a mʋ, ‑ye 'ɛ mɔ ‑tɛɛ, a 'deɛ ba 'ya lele ꞊go 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","'N yie nɩ, ‑ɛ mɔ, 'a mʋ mɔ Abrahamʋ a 'yuo a 'yuoo nɩ. Kɛɛ, aa lɛ ꞊mɔ 'na 'lɩla, ‑ɛ nue, a 'nɩ wɛɛn ꞊le 'na tɔɔwin ke. ");
INSERT INTO ted_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Dɛ ꞊nʋ, 'na Bu tɔɔ 'mʋ, nɛ‑ 'nɩɩ 'a mʋ le. Kɛɛ, a ‑mɛ ‑ye, dɛ ꞊nʋ, 'a nɩ bu le 'a mʋ, nɛ‑ aa nu.» ");
INSERT INTO ted_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","‑Ye ʋ nɔ: «‑A nɩ bu, nɔ‑ mɔ Abrahamʋ.» ‑Ye ‑Yusu nɔ: «'Bɩa 'ba 'ya wɛn Abrahamʋ a 'yuo 'mʋ, ‑ye ‑tɔplɩ ꞊nʋ, ɔɔ la nu, nɩ‑ a di wɛn ‑wɛ nu. ");
INSERT INTO ted_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Kɛɛ, ꞊betɩ ꞊bo ꞊tu 'a mʋ ‑tɩ a ‑tɛɛ ꞊nʋ ye, Nyɩsʋa le 'mʋ, aa lɛ ꞊mɔ 'na 'lɩla. Dɛdʋ a ‑gbɛ, Abrahamʋ, ɔ 'nɩ nue ꞊le la. ");
INSERT INTO ted_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Kɛɛ, ‑tɔplɩɩ ‑do ꞊nʋ, 'a nɩ bu, ɔɔ nu, nɩ‑ aa ‑wɛ nu.» ‑Ye ʋ nɔ: «‑A nɩ 'dii 'de 'lalunyrɔ. ‑A nɩ buu ‑do, ‑a yi, nɔ‑ mɔ Nyɩsʋa.» ");
INSERT INTO ted_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","‑Ye ‑Yusu nɔ: «'Bɩa Nyɩsʋa 'bɔ 'ya wɛn 'a nɩ Bu 'mʋ, ‑ye a di wɛn 'mʋ 'mʋ 'nɩ nʋɛ, ‑ɛ nue, 'ke 'n ‑hɔn 'le Nyɩsʋa ‑wɔn 'mʋ. 'N 'de 'le di, 'ke 'le 'na ‑gbɛ a 'klɩ 'kwli 'mʋ, kɛɛ, nɔ‑ɔ nɩ, ‑ɔ lee nɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Dɛ‑ nue, ‑tɩ ‑gbo, 'nɩɩ ꞊tu, 'a 'nɩnɩ yrii 'mʋ lɛ 'le? ‑Tɩ kɔ ‑tɩ 'a 'nɩnɩ yrii 'mʋ lɛ, nɛ‑ mɔ, a 'die 'le ‑wɛ ba po 'mʋ nʋa ye gbo. ");
INSERT INTO ted_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","'A nɩ bu, nɔ‑ mɔ Satan, ‑ɔ mɔ 'kuo ‑hʋɩn a nyɩgblaka. 'A mʋ mɔ 'a 'yuo꞊pli. ‑Ye ‑tɔplɩ ꞊nʋ, ‑ɩɩ 'a nɩ bu a plɔ blee, nɩ‑ a nʋɛ 'mʋ ba nu. Kʋɛ la 'le gbo, ɔɔ ꞊ke 'la nahuin. Ɔ yraa ‑tɩ a ‑tɛɛ nɩ, ‑ɛ nue, ‑tɩ a ‑tɛɛ 'de 'le 'a ꞊wlʋ ke nɩ. Hɩ a lɛ'dudue, nɛ‑ mɔ 'a ‑kʋan, ‑ɛ nue, ɔ mɔ hɩnyɔ'ɔ nɩ, 'plɩɩ hɩ a gblegblei 'bii, 'ke ɩɩ 'le ꞊nɔ ‑wɔn 'mʋ ‑hɔn. ");
INSERT INTO ted_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Kɛɛ, 'mɛ ‑ye, 'nɩɩ ꞊tu ‑tɩ a ‑tɛɛ. Nɛ‑ nue, 'a 'de 'mʋ ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","'Ke 'le 'a mʋ ‑hɛyri, ꞊be ɛ kɔ nahuon, ‑ɔ ‑wɛ 'le ‑bɔ tʋɛ 'mʋ, ‑ɛ mɔ, 'n nu dɛ 'kuku? Ɛ 'de 'a nahuon ꞊de kɔ. ‑Tɛ 'nɩɩ ‑tɩ a ‑tɛɛ ꞊tu, dɛ‑ kɔ 'mɔ a 'nɩnɩ pue ‑tɛɛ 'le? ");
INSERT INTO ted_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Nahuon ꞊nʋ, ‑ɔ mɔ Nyɩsʋa a nahuon, ɔɔ Nyɩsʋa a ‑gbɛ a win ye gbo po nʋa. Kɛɛ, a ‑mɛ ‑ye, a 'de Nyɩsʋa a nahuin, nɛ‑ nue, 'a 'nɩnɩ puo nʋa ye gbo.» ");
INSERT INTO ted_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","‑Ye ‑Juukʋɛ a ye'mʋnaanyʋ ꞊tuo ‑wɔn, ʋ nɔ: «'A ‑tɩ, ‑tɛ ‑a le wɛn ‑mʋ, ‑ɛ mɔ, ‑n 'de Nyɩsʋa yi, kɔ, 'ku ‑hʋan nɩ 'o ‑mʋ ke 'mʋ, ‑a kɔ wɛn 'o ꞊wɔn.» ");
INSERT INTO ted_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","‑Ye ‑Yusu nɔ: «'Ku ‑hʋan 'de 'o 'mʋ ke 'mʋ nɩ. Kɛɛ, 'na Bu, nɔ‑ 'nɩɩ ‑tɩ a 'yi'bʋaalɛ ‑nyi. A ‑mɛ ‑ye, a blɛ ke, 'ke ba ‑nye 'mʋ ‑tɩ a 'yi'bʋaalɛ. ");
INSERT INTO ted_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","'Mɛ ‑ye, 'nɩ ꞊mʋɛ ꞊le lɛ, 'ke nahuin bʋ ‑nye 'mʋ ‑tɩ a 'yi'bʋaalɛ, kɛɛ ‑ye Nyɩsʋa, nɔ‑ nye lɛ ꞊mɔ. Nɔ‑ɔ nɩ, ‑ɔ di ‑bati 'bɛ. ");
INSERT INTO ted_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","'Nɩɩ 'a mʋ 'nɩ le, nahuon 'bɔ nɩ 'o, 'bɔɔ 'o 'na wintɛ 'o ꞊tuu, ɔ 'deɛ bɔ 'kʋ gbe.» ");
INSERT INTO ted_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","‑Ye ʋ nɔ: «‑A yie 'klɛɛ nɩ, ‑ɛ mɔ, 'ku ‑hʋan nɩ 'o ‑mʋ ke 'mʋ. ‑A nɩ bu gblaka Abrahamʋ 'kʋ nɩ, Nyɩsʋa a winwlɔn‑hɛnyʋ 'ʋ 'kʋ ‑wɛ. ‑Mɛ ‑ye, kɛ ‑nɩɩ po, nahuon 'bɔ nɩ 'o, 'bɔɔ 'o ‑na wintɛ 'o ꞊tuu, ɔ 'deɛ bɔ 'kʋ gbe. ");
INSERT INTO ted_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","‑A nɩ bu Abrahamʋ, ɔ 'kʋ nɩ. ꞊Be ‑n pue ‑tɛɛ, ‑mɔ nɩɔ 'o 'lu ye? Nyɩsʋa a winwlɔn‑hɛnyʋ, ʋ 'kʋ ‑wɛ nɩ. Nahuon a gblo tio‑ ‑nɩɩ 'klɛɛ ‑n dɩɔnʋ daa 'le?» ");
INSERT INTO ted_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","‑Ye ‑Yusu nɔ: «'Bɩa 'nɩɩ wɛn 'n dɩɔnʋ baa, ‑ye 'na baalɛ a ‑gbɛ, ɛ 'deɛ bɛ da wɛn dɛ ꞊de. Nahuon ‑gbo, ‑ɔɔ 'mʋ baa, nɔ‑ mɔ 'na Bu. A nɔ 'nɩ, nɔ‑ mɔ Nyɩsʋa ꞊nʋ, aa da. ");
INSERT INTO ted_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kɛɛ, a 'dio yi. 'Mɛ ‑ye, 'n yio nɩ. 'Bɩa 'nɩ po wɛn lɛ, 'n 'dio yi, ‑ye 'n 'ya wɛn hɩnyɔ, ‑ɛ 'we ꞊nɔ 'a mʋ ye. Kɛɛ, 'n yio nɩ, 'nɩɩ ‑wɛ 'o 'a win 'o ꞊tuu. ");
INSERT INTO ted_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","'A nɩ bu gblaka Abrahamʋ, ɔ nye la ‑wɔn lɛ ‑hie 'lu, ‑ɛ mɔ, ɔ di la ‑nyrɔwɔ ꞊nʋ 'nɩ 'ye, ‑ɔ kɔ 'mʋ ʋ di la 'o 'mʋ kɔɔ. Nɛ‑ nue, 'ɔɔ la 'manʋ nu. ‑Tɛ ɔ 'ye la 'klɛɛ ‑nyrɔwɔ a ‑gbɛ, ‑ye ɔɔ la nu 'manʋ 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","‑Ye ʋ nɔ: «‑N 'de 'yrɩ a (50) ‑wlɩɩ 'hɔn ꞊tu 'o ‑pu a kʋɛ, ꞊nɩɩ lɛ po, ‑n 'ye Abrahamʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","‑Ye ‑Yusu nɔ: «'Nɩɩ 'a mʋ 'nɩ le, 'plɩɩ ʋ 'mʋ la Abrahamʋ kɔ, 'n nɩ la 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Bɔ po 'klɛɛ lɛ, ‑ye ʋ 'ba 'mʋ lɛ 'hɛ, 'ke ʋ 'mue ꞊nɔ ‑wɔn lɛ poo a ‑tɩ, ʋ 'muo 'la. Kɛɛ ‑ye ‑Yusu ‑hli ꞊nʋ ke 'yi, 'ɔ 'hrɩ 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, bʋ nɩ 'hru wlɔn, ‑ye ɔ yɛ 'o gbo nyɩbɛyu ꞊de. Nyɩbɛyu a ‑gbɛ, kʋɛ la 'le 'a kɔɔlɛ 'yie 'mʋ gbo, 'a 'yii sua nɩ. ");
INSERT INTO ted_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","‑Ye 'a ‑naagbopʋ ꞊gbɔ wlɔn, ʋ nɔ: «Tɔɔnyɔ o, nahuon tio‑ nu la dɛ 'kuku? ꞊Be nahuon a ‑gbɛɛ nɩ, ‑hee' 'a 'dii kɔ 'a bu 'hɛɛn‑ nɩ, ‑ʋ nu dɛ 'kuku, ‑ɛ kɔ ‑tɩ 'a 'yii 'ɩ sua?» ");
INSERT INTO ted_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Ɛ 'de 'a ‑gbɛ a dɛ 'kuku a ‑tɩ, mɔ, ɛ 'de ‑wɛ 'a 'dii kɔ 'a bu 'hɛɛn a dɛ 'kuku a ‑tɩ, 'a 'yii 'de sua. 'A 'yii sua nɩ, ‑ɛ die nu, nahuin 'mue 'ye, ‑ɛ mɔ, Nyɩsʋa kɔ 'klɩ, 'ke bɔ nu ‑kʋan, 'ke 'o ꞊nɔ 'yie 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","‑Tɛ ‑nyrɛ 'kɩɛ nɩɛ 'le, ‑a kɔ ‑ba nu ‑kʋan ꞊nʋ, Nyɩsʋa, ‑ɔ lee nɔ 'mʋ, ɔ plɛ ‑ba nu. 'Tɔɔ mu 'nɩ ‑wɔn. 'Tɔ 'bɔ ‑wɔn, nahuon ꞊de 'de 'le ‑kʋan a nunue ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","‑Tɛ 'n 'kɩɛ nɩɛ nɔ 'klɔ ke, 'mɔɔ nɩ, ‑ɔɔ 'klɔ ‑gbo ke a nahuin ‑nyrɛ ‑nyi. ‑ɛ die nu, ʋ 'mʋ ‑tɩ a ‑tɛɛ 'mʋ lɛ yrii.» ");
INSERT INTO ted_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","'Plɩɩ ɔ 'mʋ la 'klɛɛ mu ‑yrɛ, ‑ye ɔ po gbo hɩɔn, 'ɔ nyʋa hɩɔn a ‑gbɛ ‑tʋtʋ ke, 'ɔ nuo 'bru 'mʋ, 'ɔ 'bɔ 'mʋ, 'ɔ hruu 'o 'yiisuanyɔ a ‑gbɛ a 'yii klɛ, ");
INSERT INTO ted_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ɔ nɔ: «Mu 'le 'wlo ꞊nʋ ‑wɔn, ʋ 'blu, ʋʋ Siloe daa, ꞊mʋ 'le 'yi ꞊hlɔn lɛ yra.» Siloedʋ a ‑gbɛ, ɛ ꞊hɛn 'nyrɛ leenyɔ; 'yiisuanyɔ a ‑gbɛ 'ɔ mu, 'ɔ yra 'yi ꞊hlɔn lɛ. ‑Tɛ ɔ ꞊hɩan ‑wɔn, ‑ye ɔ ‑tʋa lɛyriilɛ gbo. ");
INSERT INTO ted_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","'A 'bienʋ, kɔ nahuin ꞊nʋ 'hɛɛn, ‑ʋ nyo o lɛ 'ye, ‑tɛ ɔɔ o 'wli lɛ ‑hʋa, ‑ɛ die nu, ɔ 'mʋ dɛ di, nahuin a ‑gbɛ, kɛ ʋʋ 'klɛɛ po, 'ʋʋ wlɔn lɛ ꞊gbʋgba: «꞊Be ɛ 'de nahuon ‑gbo, ‑ɔɔ o gbo nɩ, ‑ɔɔ o 'wli lɛ ‑hʋa?» ");
INSERT INTO ted_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","꞊Ʋ ‑ye nɔ: «Nɔ‑ɔ nɩ.» ꞊Ʋ ‑ye nɔ: «'Ʋʋn, ɛ 'de ꞊nɔ, kɛɛ, ɔ 'we ꞊nɔ ꞊nɔ ye.» Kɛɛ, nahuon a ‑gbɛ, kɛ ɔɔ po, ɔ nɔ: «'Mɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","‑Ye ʋ nyo 'klɛɛ wlɔn 'nɩ ꞊gba: «‑Be' ‑na 'yii nu kekɩklɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","‑Ye ɔ nɔ: «Nahuon ‑gbo, ʋʋ ‑Yusu daa, nɔ‑ po hɩɔn gbo, 'ɔ nyʋa hɩɔn a ‑gbɛ ‑tʋtʋ ke, 'ɔ nuo 'bru 'mʋ. Nʋ‑ ɔ hrii 'mʋ 'yi klɛ, 'ɔ le 'mʋ, 'ke ꞊bo mu 'le 'wlo ꞊nʋ ‑wɔn, ʋʋ Siloe daa, ‑ɛ die nu, 'mʋ 'yi ꞊hlɔn lɛ yra, 'nɩ mu, 'nɩ yra 'yi ꞊hlɔn lɛ. ‑Tɛ 'n yra 'klɛɛ 'yi ꞊hlɔn lɛ, ‑ye 'n ‑tʋa lɛyriilɛ gbo.» ");
INSERT INTO ted_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","‑Ye ʋ ꞊gbɔ wlɔn: «‑Be' nahuon a ‑gbɛ nɩ ye 'le?» ‑Ye ɔ nɔ: «'N 'de 'a dɛ ꞊de yi.» ");
INSERT INTO ted_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nahuon a ‑gbɛ, ‑ɔ kɔ 'yii sua o, 'ke ʋ gbɔ 'le Falisi꞊tumu a nahuin ye. ");
INSERT INTO ted_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","'Plɩɩ ‑ye, ‑nyrɔwɔ ‑kɔ 'mʋ ‑Yusu nu 'bru, 'ɔ kla 'a 'yii ke, ‑nyrɔwɔ a ‑gbɛ, ɔ mɔ ‑wuwle‑nyrɔwɔ'ɔ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nɛ‑ nue, Falisi꞊tumu a nahuin 'ʋʋ nahuon a ‑gbɛ wlɔn ꞊gba: «Dɛ‑ nue, ꞊nɩɩ lɛ yrii 'le?» ‑Ye ɔ nɔ: «Ɔ nu 'bru, 'ɔ hruu 'o 'na 'yii klɛ, 'nɩ yra 'yi ꞊hlɔn lɛ. ‑Tɛ 'n yra 'klɛɛ 'yi ꞊hlɔn lɛ, ‑ye 'n ‑tʋa lɛyriilɛ gbo.» ");
INSERT INTO ted_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","‑Ye kɛ Falisi꞊tumu a nahuin ‑yee po: «Nahuon ꞊nʋ, ‑ɔ mɔ ‑Yusu, ɔ 'de 'le Nyɩsʋa ‑wɔn 'mʋ ‑hɔn, ‑ɛ nue, ɔ 'nɩ ꞊tuu ꞊le 'o tete ꞊nʋ 'o, ‑ɛ nyi ꞊tu, ‑ɛ mɔ, ‑wuwle‑nyrɔwɔ 'mʋ, nahuon nɩ nu 'le ‑kʋan.» ꞊Ʋ ‑ye nɔ: «'Bɩa 'bɔ 'ya wɛn ‑tʋnahuon, ‑ɔɔ dɛ 'kuku nu, ‑ye ɔ 'de wɛn 'le 'ŋmilɛka‑tɔplɩ ‑gbo, ɔɔ nu a nunue ‑wɛ.» Nɛ‑ nue, 'ʋ 'bɛ ꞊tɩɔ. ");
INSERT INTO ted_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","‑Ye nahuon a ‑gbɛ, ‑ɔ kɔ 'yii sua o, ʋ nyo lele wlɔn 'nɩ ꞊gba: «Nahuon ꞊nʋ, ‑ɔ kla ‑na 'yii ke, ‑mɛ ‑ye, ‑n nɔ 'nɩ, nahuon tio‑ ɔ 'ya 'le?» ‑Ye ɔ nɔ: «'Mɛ ‑ye, 'n nɔ 'nɩ, ɔ mɔ Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kɛɛ ‑ye ‑Juukʋɛ a ye'mʋnaanyʋ a ‑gbɛ, ‑ʋ mɔ Falisi꞊tumu a nahuin, ʋ 'nɩ ‑hʋɛ ꞊le bʋ pui ‑tɛɛ, ‑ɛ mɔ, nahuon a ‑gbɛ a 'yii sua o nɩ, 'ɔɔ kɛ lɛ yrii. Nɛ‑ nue, 'ʋ da 'a 'dii kɔ 'a bu 'hɛɛn, ");
INSERT INTO ted_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","'ʋ ꞊gbʋ wlɔn, ʋ nɔ: «꞊Be sɛyɩ‑sɛyɩ, nahuon ‑gbo, 'a nɩ 'yuu nɩ? ꞊Be a nɔ 'nɩ, ‑tɛ a kʋɔ la, 'a 'yii sua la nɩ? 'Bɛ mɔ ‑tɛɛ, ‑ɛ mɔ, 'a 'yii sua la nɩ, dɛ‑ nue, 'ɔɔ kɛ lɛ yrii 'le?» ");
INSERT INTO ted_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","‑Ye 'a 'dii kɔ 'a bu 'hɛɛn, ʋ nɔ: «‑A yie nɩ, ‑ɛ mɔ, ‑a nɩ 'yuu nɩ. ‑A yie ‑wɛ nɩ, ‑ɛ mɔ, ‑tɛ ‑a kʋɔ la, 'a 'yii sua la nɩ. ");
INSERT INTO ted_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Kɛɛ, dɛ‑ nue, 'plɩɩ 'ɔɔ lɛ yrii, kɔ, nahuon tio‑ kla 'a 'yii ke, dɛ a ‑gbɛ, nɛ‑ ‑a 'de yi. 'A ‑gbɛ, ba ꞊gbɔ wlɔn, ‑ɛ nue, ɔ 'de 'yu. Ɔ ‑wɛ 'le bɔ ‑hɩhɩa 'a mʋ klɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kɛ 'a 'dii kɔ 'a bu 'hɛɛn, ʋʋ po, ‑ɛ nue, ʋʋ pɩ ‑Juukʋɛ a ye'mʋnaanyʋ a ‑gbɛ a hʋannʋ. 'Ɛ mɔ ‑tɛɛ, ‑Juukʋɛ a ye'mʋnaanyʋ a ‑gbɛ, ʋ pue 'le ꞊le, ‑ɛ mɔ, nahuon 'bɔ nɩ 'o, 'bɔ plɛ, ‑Yusu mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, ‑ye nahuon a ‑gbɛ, ɔ 'die 'le ‑wɛ bɔ pa 'klɛɛ lele Nyɩsʋa a kayu ꞊nʋ gbo. ");
INSERT INTO ted_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nɛ‑ kɔ ‑tɩ 'a 'dii kɔ 'a bu 'hɛɛn, 'ʋ po lɛ: «Ɔ 'de 'yu. 'A ‑gbɛ, ba ꞊gbɔ wlɔn.» ");
INSERT INTO ted_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","‑Tɛ 'a 'dii kɔ 'a bu 'hɛɛn, ʋ ‑yrɛ, ‑ye ‑Juukʋɛ a ye'mʋnaanyʋ, ‑ʋ mɔ 'klɛɛ Falisi꞊tumu a nahuin, ʋ dɔ lele nɩ, ʋ nɔ: «Kɛ mɔ Nyɩsʋa ye 'mʋʋ nɩ, ‑a nɩ mɔ. 'A ‑tɩ, ꞊tu ‑tɩ a ‑tɛɛ, ‑nyi Nyɩsʋa ‑tɩ a 'yi'bʋaalɛ. ‑A ‑mɛ ‑ye, ‑a yie nɩ, ‑ɛ mɔ, ‑Yusu a ‑gbɛ, ɔ mɔ dɛ'kukununyɔ'ɔ nɩ. Ɔ 'de 'le Nyɩsʋa ‑wɔn 'mʋ ‑hɔn.» ");
INSERT INTO ted_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","‑Ye ɔ ꞊tu ‑wɔn, ɔ nɔ: «꞊Be ɔ mɔ dɛ'kukununyɔ'ɔ nɩ, ‑hee' ɔ 'de dɛ'kukununyɔ, 'n 'de 'a dɛ ꞊de yi. 'Mɛ ‑ye, dɛ ‑gbo, 'n yi, nɛ‑ mɔ, 'na 'yii sua la nɩ, kɛɛ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'nɩɩ lɛ 'nɩ yrii.» ");
INSERT INTO ted_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","‑Ye ʋ nɔ: «Dɛ tio‑ ɔ nu ‑mʋ 'mʋ 'le? ‑Be' ɔ nu, 'plɩɩ ꞊nɩɩ lɛ yrii 'le?» ");
INSERT INTO ted_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","‑Ye ɔ ꞊tu lele ‑wɔn, ɔ nɔ: «'Be 'n le wɛn 'a mʋ nɩ. Kɛɛ, a 'de 'mʋ nʋa ye gbo po. Dɛ‑ kɔ ‑tɩ 'a nye ‑hʋa, ꞊bo ꞊tui lele 'le? 'N nye 'nɩ 'ye, ‑ɛ mɔ, aa ‑hʋa ba ‑hɛ ‑wɛ ‑Yusu a ‑gbɛ a ‑naagbopʋ.» ");
INSERT INTO ted_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Bɔ po 'klɛɛ lɛ, ‑ye ʋ ‑tʋa 'a tanɩ a ꞊tutue gbo, ʋ nɔ: «‑Mɔɔ nɩ, ‑ɔ mɔ 'a ‑naagbopʋyu. ‑A ‑mɛ ‑ye, Nyɩsʋa a winwlɔn‑hɛnyɔ Moise, nɔ‑ kɔ ‑naagbopʋ ‑a 'ya 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","‑A yie nɩ, ‑ɛ mɔ, Moisee nɩ, Nyɩsʋa 'prɛɛ 'le ‑wɔn. Kɛɛ, ‑Yusu ‑mɛ ‑ye, ‑tɛ bɔ ‑hɔn 'o 'mʋ, ‑a 'de 'o yii.» ");
INSERT INTO ted_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","‑Ye ɔ nɔ: «‑Yusu ‑gbo, ‑ɔ nue, 'nɩɩ lɛ yrii, 'bɩa 'baa lɛ po, ‑tɛgbi ɔ ‑hɔn 'o 'mʋ, a 'de 'o yii, ‑ye dɛ a ‑gbɛ, ɛ saka 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","‑A yie nɩ, ‑ɛ mɔ, nahuon 'bɔ 'ya dɛ'kukununyɔ 'mʋ, 'bɔɔ Nyɩsʋa da, Nyɩsʋa 'nɩ 'wɔn ꞊le 'a win nɩ. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ nyo 'o ꞊tuu, dɛ ꞊nʋ, Nyɩsʋaa ‑hʋa, 'bɔ nye nu, ‑ye nahuon a ‑gbɛ, nɔ‑ kɔ win Nyɩsʋa, ɔɔ nʋa ye gbo po. ");
INSERT INTO ted_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Gbegbe, ꞊ɔ ꞊de 'di ‑hlɩn a 'wɛɛn, ‑tʋnahuon ‑gbo, ‑ɔ kɔ 'yii sua, kʋɛ 'le 'a kɔɔlɛ 'yie 'mʋ gbo, nahuon ‑ye bɔ die nu, 'yiisuanyɔ a ‑gbɛ bɔ ‑tʋa lɛyriilɛ gbo. ");
INSERT INTO ted_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","‑Yusu a ‑gbɛ 'bɔ 'de wɛn 'le Nyɩsʋa ‑wɔn 'mʋ ‑hɔn, ɔ 'die wɛn 'le ‑wɛ, bɔ nu wɛn 'ŋmilɛkadɛdʋ a ‑gbɛ.» ");
INSERT INTO ted_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","‑Tɛ ʋ 'wɔn 'klɛɛ 'a pupowin, ‑ye ʋ nɔ: «‑Mɔ ‑gbo, kʋɛ 'le ‑na kɔɔlɛ 'yie 'mʋ gbo, dɛ 'kukuu ‑do, nɛ‑ ‑nɩɩ nu, 'plɩɩ ‑mɔ plɛ, ‑ɔɔ ‑a mʋ tɔɔ,» 'ʋ puo 'le ‑patʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","‑Ye ‑Yusu 'wɩn nɩ, ‑ɛ mɔ, ʋ puo 'le 'mʋ ‑patʋ. ‑Tɛ ɔ kɔ ꞊nɔ 'hɛɛn, ʋ ꞊ŋmoo, ‑ye ‑Yusu nɔ: «‑Tʋnahuin 'bii a Nahuon, ‑ɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, ꞊be ‑n kuo ye ꞊wlʋ?» ");
INSERT INTO ted_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","‑Ye nahuon ꞊nʋ, ‑ɔ kɔ 'yii sua o, ɔ nɔ: «Le 'mʋ, nahuon a gblo tio‑ bɔ 'ya 'mʋ, ‑ɛ die nu, 'muo ꞊wlʋ ye kuo.» ");
INSERT INTO ted_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","‑Ye ‑Yusu nɔ: «‑N 'yo nɩ ‑dodo. 'Mɔɔ nɩ, ‑ɔɔ 'klɛɛ 'le ‑mʋ ‑wɔn 'prɛɛ.» ");
INSERT INTO ted_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","‑Ye ɔ nɔ: «Kʋkɔnyɔ, 'n kuo ‑mʋ ye ꞊wlʋ,» 'ɔ blɔ kwlɩ ye gbo, 'ke 'o 'a baalɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","‑Ye ‑Yusu nɔ: «'N di 'le ꞊le, kɛ nɔ ‑tʋtʋ ke, ‑ɛ die nu, 'mue nu, nahuin ‑gbo, ‑ʋ kuo Nyɩsʋa ꞊wlʋ ye, kɔ nahuin ‑gbo, ‑ʋ 'dio ꞊wlʋ ye kuo, ʋ 'mʋ 'yi 'mʋ lɛ ‑hʋnhɔn. Ɛ 'we ꞊nɔ ye, nahuin ꞊nʋ, ‑ʋ kɔ 'yii sua, ʋ di lɛ 'nɩ yrii, kɛɛ, nahuin ꞊nʋ, ‑ʋ plɛ, ‑ʋʋ lɛ yrii, 'n die ꞊nʋ 'nɩ tɔɔ, ‑ɛ mɔ, 'waa 'yii sua nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Falisi꞊tumu a nahuin ‑ye ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'wɔn wintɛ a ‑gbɛ nɩ. ‑Ye kɛ ʋʋ 'klɛɛ ꞊nɔ ye po, ʋ nɔ: «꞊Be ɛ ꞊hɛn 'nyrɛ, ‑a nɩ ‑gbɛ, ‑a nɩ 'yii sua ‑wɛ nɩ 'a?» ");
INSERT INTO ted_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «'A nɩ 'yii, 'bɩ sua wɛn, ‑ɛ ꞊hɛn 'nyrɛ, 'ba 'nɩnɩ yrii wɛn Nyɩsʋa a ‑tɩ 'mʋ lɛ, ‑ye Nyɩsʋa a ‑bati 'die wɛn 'le ‑wɛ bɩ klɩ wɛn 'a mʋ. Kɛɛ, ‑tɛ aa lɛ po, aa lɛ 'nɩ yrii, ‑ɛ ꞊hɛn 'nyrɛ, aa Nyɩsʋa a ‑tɩ 'mʋ lɛ 'nɩ yrii, nɛ‑ die nu, Nyɩsʋa a ‑bati 'mʋ 'a mʋ klɩ.» ");
INSERT INTO ted_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","(‑Juukʋɛ a ye'mʋnaanyʋ, nʋ‑ ‑Yusu 'kɩɛ 'prɛɛ 'le ‑wɔn.) Kɛ ɔɔ ꞊nʋ ye po: «꞊Bo pue blablɔ a dɛ ye, ɔ kɔ blablɔkɔnyɔ 'hɛɛn, ‑ɔ mɔ ‑wɛ blablɔ'yie꞊tunyɔ. 'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, blablɔ ꞊nʋ, ‑ɔ nɩ 'le ‑gblo 'mʋ, nahuon 'bɔ nɩ 'o, 'bɔɔ 'le ꞊nɔ ‑wɔn pa, 'bɔ 'nɩnɩ naa 'o ‑gblo a ‑gbɛ a paalɛ 'yri, kɛɛ, 'bɔɔ ‑gblo 'ya, ‑ye nahuon a ‑gbɛ, ɔ mɔ 'yrinyɔ'ɔ nɩ, kɔ ‑balʋnyɔ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kɛɛ, 'bɔɔ 'o ‑gblo a ‑gbɛ a paalɛ 'mʋ naa, ‑ye ɔ mɔ blablɔ a ‑gbɛ a kʋkɔnyɔ'ɔ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","‑Ye ‑gblo'yie꞊tunyɔ ꞊nʋ, ‑ɔ nɩ 'o ‑gblo a paalɛ 'mʋ, ɔɔ blablɔkɔnyɔ lɛ ‑ha mɛ, 'ɔɔ 'le 'a blablɔ ‑wɔn pa. Blablɔkɔnyɔ a ‑gbɛ, 'bɔɔ 'a blablɔ da, ‑ye 'a blablɔ nyo ye gbo po nʋa. ‑Ye blablɔkɔnyɔ, ɔɔ 'ɛ nɩ blablɛ a 'dʋ 'nɩ da, 'plɩɩ 'ɔ nyo 'le ‑gblo 'mʋ 'hrɔɔ. ");
INSERT INTO ted_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","'Bɔ 'hrɔɔ 'klɛɛ 'a blablɔ 'bii, ‑ye ɔ nyo 'mʋ naa ye, blablɔ a ‑gbɛ 'ɔ nyo ‑wɔn kʋɛ, ‑ɛ nue, ɔ yi 'a win nɩ. ");
INSERT INTO ted_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Kɛɛ ‑ye nahuon 'bɔ nɩ 'o, blablɔ a ‑gbɛ 'bɔ 'dio yi, ‑ye ɔ 'deɛ bɔ kʋɛ ꞊nɔ ‑wɔn, kɛɛ, ɔ di lɛ 'gba ci, ‑ɛ nue, ɔ 'de 'a win yi.» ");
INSERT INTO ted_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","‑Talʋdʋ a ‑gbɛ, ‑Yusu po ‑Juukʋɛ a ye'mʋnaanyʋ a ‑gbɛ ye, ʋ 'de 'a 'mʋlɛyriilɛ kɔ. ");
INSERT INTO ted_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","‑Ye kɛ ‑Yusuu lele po, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, 'mɔ ‑gbo, 'n 'we ꞊nɔ blablɔ a ‑gblo a paalɛ ye. ");
INSERT INTO ted_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Nahuin 'bii ꞊nʋ, ‑ʋ plɛ, ‑ʋ mɔ ‑tɛɛ a blablɔkɔnyʋ, ‑ʋ ‑hi, 'plɩɩ 'nɩ di 'le, nahuin a ‑gbɛ, nʋ‑ mɔ 'yrinyʋ kɔ ‑balʋnyʋ 'hɛɛn. Kɛɛ, ‑tɛɛ a blablɔ 'diu nʋa ye gbo po. ");
INSERT INTO ted_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","'Mɔ mɔ blablɔ a ‑gblo a paalɛ a ‑gbɛ. Paalɛ ‑gbo, 'n 'ya 'mʋ, nahuon ꞊nʋ, ‑ɔ di 'o naa, nɔ‑ Nyɩsʋa di waa. Ɔ di 'nɩ pa, ɔ 'mʋ 'hrɩ, ɔ 'mʋ dididɛ 'ye. ");
INSERT INTO ted_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","'Yrinyɔɔ 'le 'nɩ di, ɔ 'mʋ 'na blablɔ, ‑ɔ mɔ 'na nahuin 'yri, ɔ 'mu lɛ 'lɩla, kɔ, ɔ 'mu gbo ‑wɔ a ‑tɩ. 'Mɛ ‑ye, 'n di 'le ꞊le, ‑ɛ die nu, 'mʋ nahuin 'klɔ yrayrʋ ‑nyi, 'mʋ ꞊nʋ ꞊hapʋ‑tɩ 'plɔplɔ 'yi ꞊hlɔn lɛ nu. ");
INSERT INTO ted_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","'Mɔ ‑gbo, 'mɔ mɔ ‑tɛɛ a blablɔkɔnyɔ, 'nɩ 'ya ‑wɛ 'a 'yie꞊tunyɔ 'mʋ. ‑Tɛɛ a blablɔkɔnyɔ, ɔɔ 'a ‑hʋnhlʋn 'nɩ ‑ha, 'ke 'o 'a blablɔ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Kɛɛ, ‑kʋannunyɔ ꞊nʋ, ‑ɔ 'de blablɔ a kʋkɔnyɔ, ɔɔ 'yie ꞊tu blablɔ, 'wliyɛ a ‑tɩ. 'Bɩa nahuon a ‑gbɛ 'bɔ 'ye ‑ji, 'bɛɛ 'le di, ‑ye ɔ hie 'o blablɔ gbo, 'ɔɔ ci lɛ 'gba, ‑ɛ nue, ɛ 'de ꞊nɔ, ɔ 'de blablɔ a ‑gbɛ a kʋkɔnyɔ. ‑Ji 'bɛ nyre 'klɛɛ 'o, ‑ye ɛ klɩ blablɔ ‑ye nɩ, 'a dɛ ‑ye ꞊nʋ, 'ɛ nyo ‑tɔplɩ 'nyɩ 'mʋ lɛ ‑gbʋgba. ");
INSERT INTO ted_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","‑Kʋannunyɔ 'bɔ 'ye ‑ji, ‑ye ɔɔ lɛ 'gba ci, ‑ɛ nue, 'wliyɛ a ‑tɩɩ nɩ, 'ɔɔ ‑kʋan nu. Nɛ‑ nue, blablɔ a ‑gbɛ a ‑tɩ 'ɩ 'nɩnɩ 'yaa ꞊nɔ 'kla ‑wliye. ");
INSERT INTO ted_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","'Mɔ ‑gbo, 'mɔ mɔ ‑tɛɛ a blablɔkɔnyɔ. ‑Tɛ 'na Bu Nyɩsʋa nu, 'ɔ yi 'mʋ, 'na ‑gbɛ 'nɩ yio, kɛ'ɛ nɩ, 'n nu 'na blablɔ, ‑ɔ mɔ 'na nahuin a yiyie, 'na nahuin a ‑gbɛ, 'ʋ yi ‑wɛ 'mʋ. 'Nɩɩ ‑ha 'na ‑hʋnhlʋn, 'ke 'o 'waa ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","'N kɔ blablɔ ‑ye, ‑ɔ 'de nɔ 'bla‑gblo ‑gbo 'kwli 'mʋ nɩ, (ɛ ꞊hɛn 'nyrɛ, 'na nahuin ‑ye, ‑ʋ 'de ‑Juukʋɛ). 'N kɔ ꞊bo naa ‑wɛ ꞊nʋ, ɔ 'mʋ 'na win 'wɔn, ɔ 'mʋ 'mʋ nʋa ye gbo po, ɔ kɔ 'a 'bienʋ 'hɛɛn, ɔ 'mʋ 'yi 'mʋ lɛ bibi, ɔ 'mʋ 'bla꞊juu ‑do ‑hɛ, ‑ɛ ꞊hɛn 'nyrɛ Nyɩsʋa a dakʋʋ ‑do, ‑ʋ kɔ blablɔkɔnyɔɔ ‑do. ");
INSERT INTO ted_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","'Na Bu Nyɩsʋa nʋɛ 'mʋ 'mʋ nɩ, ‑ɛ nue, 'n di 'na ‑hʋnhlʋn 'nɩ ‑ha, 'mʋ 'kʋ, ‑ɛ die nu, 'mʋ ‑tado lele ‑hʋnhlʋn a ‑gbɛ 'mʋ 'ba, 'mʋ 'klɔ 'hrɩ. ");
INSERT INTO ted_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nahuon ꞊de 'die 'le ‑wɛ bɔ 'la 'mʋ, 'bɩa 'nɩ 'die ke wɛɛn. 'Na ‑gbɛ, 'n nye 'nɩ ‑hʋa, ꞊bo ‑ha 'na ‑hʋnhlʋn, 'mʋ 'kʋ. 'N kɔ 'klɩ, 'ke ꞊bo ‑ha 'na ‑hʋnhlʋn, 'nɩ kɔ ‑wɛ 'klɩ, 'ke ꞊bo 'ba lele ‑hʋnhlʋn a ‑gbɛ 'mʋ. Nɛ‑ mɔ dɛ ꞊nʋ, 'na Bu Nyɩsʋa le 'mʋ, ꞊bo nu.» ");
INSERT INTO ted_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","‑Tɩ ꞊nʋ ‑Yusu ꞊tu, ɩ nue, ‑Juukʋɛ a ye'mʋnaanyʋ, ‑ʋ nɩ 'o, 'ʋ wo lele. ");
INSERT INTO ted_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","'Waa 'plɔplɔ nɔ: «'Ku ‑hʋan, nʋ‑ nɩ 'o ꞊nɔ ke 'mʋ. 'A 'lu ‑hɔn 'o wlɔn 'hru. A nɩ puo 'le nʋa ye gbo!» ");
INSERT INTO ted_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","꞊Ʋ ‑ye nɔ: «Nahuon ꞊nʋ, 'ku ‑hʋan nɩ 'o ke 'mʋ, ɔ 'die 'le ‑wɛ bɔ nu lɛ 'pʋprɛ. 'Ku ‑hʋan 'die 'le ‑wɛ bʋ nue, 'yiisuanyɔ bɔ yrii lɛ.» ");
INSERT INTO ted_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","‑Tɛ 'dai ti ‑hi, ‑ye cɛ a ti nyre 'o ꞊o. Ti a ‑gbɛ 'yri, lɛ'mimre nɩ 'le Jrusrɛ 'mʋ, 'ke 'o Nyɩsʋa a 'kagblaka a ‑ta 'mʋ. ‑Nyrɔwɔ ꞊nʋ, ʋ ꞊tu la 'le lele 'kagblaka a ‑gbɛ Nyɩsʋa kwa 'mʋ gbo, ti ‑hi la a ti 'yri, nɛ‑ kɔ lɛ'mreti nyre 'o. ");
INSERT INTO ted_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","'Ke ‑Yusu nɩ 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ɔɔ 'le papʋɛ ꞊nʋ gblɛ ‑hihie, ʋʋ Salomɔ a papʋɛ daa; ");
INSERT INTO ted_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","‑Juukʋɛ a ye'mʋnaanyʋ 'ʋ 'kukue 'o ꞊nɔ 'hʋɩn 'mʋ lɛ. Kɛ ʋʋ ꞊nɔ ye po, ʋ nɔ: «Tii ‑tie ‑a di ‑pre, 'plɩɩ ꞊mʋ ‑a mʋ le, nahuon a gblo tio‑ ‑n 'ya 'mʋ? ꞊Nɩ 'ya Waanyɔ ꞊nʋ 'mʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, ‑ye ‑bo le ‑a mʋ ‑dodo.» ");
INSERT INTO ted_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","‑Ye ‑Yusu nɔ: «'N le o 'a mʋ nɩ, kɛɛ, ‑tɩ ‑gbo, 'nɩɩ ꞊tu, a 'nɩ pui ꞊le ‑tɛɛ. 'Ŋmilɛka‑tɔplɩ ‑gbo, 'nɩɩ nu, 'ke 'le Nyɩsʋa a 'dʋ 'kwli 'mʋ, ɩ nyi 'a mʋ 'nɩ tɔɔ, nahuon a gblo tio‑ 'n 'ya 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Kɛɛ, ‑tɩ ‑gbo, 'nɩɩ ꞊tu, a 'nɩ pui ꞊le ‑tɛɛ, ‑ɛ nue, a 'de 'na nahuin. ");
INSERT INTO ted_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","'Bɩa 'nɩɩ wun po, 'na nahuiin 'mʋ ye gbo po nʋa, ‑ɛ 'we ꞊nɔ ye, ‑tɛ blablɔɔ nu, 'ɔɔ 'a kʋkɔnyɔ nʋa ye gbo po, 'nɩ yiu ‑wɛ, 'ʋʋ 'mʋ ‑wɔn kʋɛ. ");
INSERT INTO ted_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","'Na nahuin a ‑gbɛ, 'n nyu ‑nyi 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. Gbegbe, ʋ 'deɛ bʋ ‑wɛ gbo. Nahuon ꞊de 'de 'klɩ kɔ, 'ke bɔ ‑hɩʋ 'mʋ kwa. ");
INSERT INTO ted_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","'Na Bu Nyɩsʋa, nɔ‑ ‑nyu 'mʋ, 'plɩɩ 'a 'klɩ nɩ 'o 'klɩi 'bii ye 'lu. Ɛ 'de nahuon ꞊de kɔ, ‑bɔ kɔ 'klɩ, ‑bɔ ‑ha 'a nahuon ꞊de 'na Bu Nyɩsʋa kwa. ");
INSERT INTO ted_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","'N Bu Nyɩsʋa kɔ 'mʋ 'hɛɛn, ‑a mʋ mɔ ‑tʋnahuoon ‑doo nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","‑Tɛ ‑Juukʋɛ a ye'mʋnaanyʋ ‑nɩ wɛn, ʋ 'wɔn 'klɛɛ ‑tɩ ꞊nʋ, ɔ ꞊tu, ‑ye ʋ 'ba lele 'mʋ lɛ 'hɛ, ʋ 'mue ꞊nɔ ‑wɔn lɛ po, ʋ 'muo 'la. ");
INSERT INTO ted_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","‑Ye kɛ ɔ nyu ye po, ɔ nɔ: «'Ke 'le 'na Bu Nyɩsʋa a 'klɩ 'kwli 'mʋ, 'n nu ꞊hapʋ‑tɔplɩ 'plɔplɔ, 'ke 'o 'a mʋ ye. ꞊Hapʋdɛ tio‑ kɔ ‑tɩ 'aa ‑hʋa ba 'la 'mʋ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","‑Ye ʋ ꞊tuo ‑wɔn, ʋ nɔ: «Ɛ 'de ‑bo nu ꞊hapʋdɛ ꞊de a ‑tɩ, ‑ba ‑hʋa ‑ba 'la ‑mʋ, kɛɛ, ‑aa ‑hʋa ‑ba 'la ‑mʋ, ‑ɛ nue, ‑nɩɩ Nyɩsʋa a ‑tɩ lɛ 'nɩ ‑haa. ‑Mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuon, ‑mɔ plɛ, ‑ɔ mɔ ‑wɛ Nyɩsʋa.» ");
INSERT INTO ted_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","‑Ye ‑Yusu ꞊tu ‑wɔn, ɔ nɔ: «Ʋ 'crɩɛ la nɩ, 'ke 'le 'a nɩ teteicrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ Nyɩsʋacrɩɩnɩɛ: Nyɩsʋa nɔ 'nɩ: 'A mʋ mɔ nyɩsʋapʋʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","‑Tɩ ꞊nʋ, Nyɩsʋa ꞊tu, 'ke 'le 'a 'crɩɩnɩɛ 'kwli 'mʋ, nahuon ꞊de 'die 'le ‑wɛ bɔ ꞊tui, ‑ɛ mɔ, ɩ 'de ‑tɩ a ‑tɛɛ. Nahuin ꞊nʋ, ɔ ꞊tu wintɛdʋ a ‑gbɛ ye, nʋ‑ʋ nɩ, ɔɔ nyɩsʋapʋ daa. ");
INSERT INTO ted_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","'Mɛ ‑ye, Nyɩsʋa po 'mʋ ke 'pɩa, 'ke ꞊bo nu 'a ‑kʋan. Nɔ‑ lee ‑wɛ nɔ 'mʋ 'klɔ ‑gbo ke. A ‑mɛ ‑ye, a nɔ 'nɩ, 'nɩɩ Nyɩsʋa a ‑tɩ lɛ 'nɩ ‑haa, ‑ɛ nue, 'n ꞊tui nɩ, ‑ɛ mɔ, 'mɔ mɔ Nyɩsʋa a 'Yuu nɩ. ");
INSERT INTO ted_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","'Bɩa ‑kʋan ‑gbo, 'nɩɩ nu, 'bɔ 'de Nyɩsʋa a kewɛɛnlɛ, ‑ye a nɩ kuo 'le 'mʋ ꞊wlʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kɛɛ, 'bɩa 'nɩɩ ‑kʋan ‑gbo nu, ‑ɔ mɔ Nyɩsʋa a kewɛɛnlɛ, 'bɩa 'ba 'nɩnɩ ‑hʋa ba kuo 'mʋ ꞊wlʋ ye, ‑ye ‑kʋan a ‑gbɛ, nɔ‑ ba kuo ꞊wlʋ ye, ‑ɛ die nu, a 'mue 'mʋ lɛ yrii ‑tɛɛ, ‑ɛ mɔ, 'n Bu kɔ 'mʋ 'hɛɛn, ‑a mʋ mɔ ‑tʋnahuoon ‑doo nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Bɔ po 'klɛɛ lɛ, ‑ye ‑Juukʋɛ a ye'mʋnaanyʋ ‑nɩ wɛn, ʋʋ lele lɛ ꞊mɔ 'hru, 'ke bʋ klo, kɛɛ, ɔ ꞊ta ꞊nʋ kwa, 'ɔ mu. ");
INSERT INTO ted_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, ‑ye 'ke ɔ mu 'le lele Sudɛn a 'nike, ‑tɛgbii ‑do ꞊nʋ, Saan la 'o nahuin 'nie 'lu lɛ poo, ti ‑hi la a ti 'yri. 'Ke ‑Yusu a ‑gbɛ, ɔ ‑hi 'le 'dai ti, ");
INSERT INTO ted_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","nahuin 'plɔplɔ 'ʋʋ 'le ꞊nɔ ye mu, ʋ nɔ: «Saan 'de 'ŋmilɛkadɛ ꞊de nu, kɛɛ, ‑tɩ 'bii ꞊nʋ, ɔ ꞊tu la, 'ke 'o ‑Yusu a ‑ta 'mʋ, ɩ mɔ ‑tɩ a ‑tɛɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","‑Ye 'ke 'o ‑tuoo ‑do a ‑gbɛ ke, nahuin ꞊nʋ, ‑ʋ nɩ 'o, 'waa 'dai dɛ kuo ‑Yusu ye ꞊wlʋ. ");
INSERT INTO ted_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ɛ kɔ la ‑Yusu a nɩnatumu ꞊de. 'A 'dʋ mɔ Lasa. 'Ke ɔ nɩ 'le Betanidɩɔ 'mʋ, 'ke 'le Sudeblʋgba 'mʋ, ɔ kɔ 'a ‑dɩayuo nyrʋyuoo 'hɔn 'hɛɛn, ‑ʋ kɔ 'dʋɩ mɔ Mari kɔ Matɩ. ");
INSERT INTO ted_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mari, nɔ‑ mɔ nyrʋgba ꞊nʋ, ‑ɔ 'ba la hʋnhrʋnponyra 'mʋ, ‑ɔ 'wlɔ la ‑Yusu bʋɩ lɛ, 'plɩɩ 'ɔ nu la 'a dɩɔnʋ a 'lu‑pupui, 'ɔ 'hran ‑Yusu a bʋɩ lɛ. 'Waa ‑dɩayu Lasa, nɔ‑ 'kʋɛ klɩ. ");
INSERT INTO ted_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","‑Ye ‑dɩayuo nyrʋyuo a ‑gbɛ, ʋ le nahuon, 'ke 'le ‑Yusu ‑wɔn, 'ke bɔ lo, ‑ɛ mɔ: «‑Na nɩnatumu Lasa, 'a 'hʋɩɩn 'nɩ hren.» ");
INSERT INTO ted_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","'Plɩɩ ‑Yusu 'mʋ titie a ‑gbɛ mu 'wɔn, ɔ nɔ: «Lasa a 'hʋɩn a hinhren, ɛ 'deɛ bɛ 'la ꞊nɔ. Kɛɛ, ɛ die nahuin 'nɩ tɔɔ, ‑ɛ mɔ, Nyɩsʋa kɔ 'klɩ kɔ ‑tɩ a 'yi'bʋbʋa. 'Hʋɩn a hinhren a ‑gbɛ, 'ke Nyɩsʋa di 'o naa, ɔ 'mue nahuin tɔɔ, ‑ɛ mɔ, 'mɔ ‑gbo, ‑ɔ mɔ Nyɩsʋa a 'Yu, 'n kɔ ‑wɛ ‑tɩ a 'yi'bʋbʋa.» ");
INSERT INTO ted_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","‑Dɩayuoo ta a ‑gbɛ, Matɩ kɔ Mari kɔ Lasa 'hɛɛn, ‑Yusu nʋʋ 'mʋ nɩ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","꞊Hapʋkɔ, 'ɔ nʋʋ 'mʋ 'dɔ, kɛɛ, ‑tɛ ɔ 'wɔn Lasa a 'hʋɩnhren‑tɩ, ‑tɛgbi ꞊nʋ, ɔ nɩ 'o, ɔ ‑hi 'o lele ‑nyrɔwɩɩ 'hɔn, ");
INSERT INTO ted_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","'plɩɩ 'ɔ le 'a ‑naagbopʋ, ɔ nɔ: «‑Ba 'ba ye 'mʋ, ‑ba mu lele Sudeblʋgba 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","‑Ye 'a ‑naagbopʋ nɔ: «Tɔɔnyɔ o, ‑tɛgbi ꞊nʋ, ‑n plɛ, ‑ba mu 'le, ‑tɛ ʋʋ ‑hʋa bʋ nu o 'hɛ, bʋ 'la o ‑mʋ, 'a ti 'de wɛn ke gbo a hreen, 'ke ‑n ‑hʋa ‑bo mu 'le lele?» ");
INSERT INTO ted_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","‑Ye ‑Yusu nɔ: «‑Nyrɔwɔ kɔ 'a nɩ ti, gbɩgbɩyrɩ kɔ 'a nɩ ti. Nahuon 'bɔɔ ‑nyrɛ 'mʋ na, 'a bʋɩ 'nɩ bibi ꞊le lɛ, ‑ɛ nue, ɔɔ nahuon ꞊nʋ 'nɩ 'ye, ‑ɔɔ 'klɔ ‑gbo a nahuin ‑nyrɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kɛɛ, nahuon 'bɔɔ 'tɔ 'mʋ na, ‑ye 'a bʋɩɩ lɛ 'nɩ bibi, ‑ɛ nue, 'ke ɔ nɩ 'le gbɩgbɩyrɩ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","‑Ye kɛ ɔɔ lele po, ɔ nɔ: «‑A nɩ nɩnatumu, ɔɔ 'nɩ ŋmo, kɛɛ, 'nɩɩ 'nɩ mu, 'muo ŋmla 'mʋ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","‑Ye ‑naagbopʋ ꞊tuo ‑wɔn, ʋ nɔ: «Kʋkɔnyɔ o, 'bɩa 'bɔɔ ŋmo, ‑ye ɛ 'we ꞊nɔ ye, 'a 'hʋɩn di 'nɩ 'kee.» ");
INSERT INTO ted_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Kɛɛ, ‑tɛ ‑Yusu plɛ, Lasaa 'nɩ ŋmo, ‑ye 'kʋkʋɛɛ nɩ, ɔ ꞊hɛn 'nyrɛ. Kɛɛ ‑ye ‑naagbopʋ ‑mɛ ‑ye, ʋ nɔ 'nɩ, ŋmla a ŋmuŋme a ‑tɩ ‑Yusu ꞊tu. ");
INSERT INTO ted_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","‑Ye ‑Yusu 'de 'klɛɛ lele ꞊nʋ ‑tɩ ꞊de 'yi ke ‑hli, ɔ nɔ: «Lasa 'kʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","'A nɩ ‑tɩ, 'n kɔ plɔ a bleelɛ, 'ke ꞊bo 'de 'le Lasa 'hʋɩn 'mʋ nɩ, ‑ɛ nue, dɛ a ‑gbɛ, ɛ di 'a mʋ 'mʋ 'nɩ ‑hɛ, 'ke ba kuo 'mʋ ꞊wlʋ ye. 'A ‑tɩ, ‑ba mu 'o ꞊nɔ 'hʋɩn 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","‑Ye Toma, ʋʋ ꞊Yrupoyu daa, kɛ ɔɔ 'a 'bienʋ ‑naagbopʋ ye po: «‑Ba kʋɛ ‑wɛ ‑Yusu ‑wɔn, ɔ kɔ ‑a mʋ 'hɛɛn, ‑a 'mʋ 'o ‑tɛgbii ‑do 'kʋʋ.» ");
INSERT INTO ted_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","‑Tɛ ‑Yusuu 'le 'dɩɔ ꞊nʋ 'mʋ mu nyre, ‑ye ɔ 'wɩn nɩ, ‑ɛ mɔ, ‑tɛ ʋ ‑ha o 'o Lasa, ɛ kɔ 'klɛɛ ‑nyrɔwɩɩ ‑hɛn. ");
INSERT INTO ted_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betanidɩɔ 'mʋɛɛ Jrusrɛdɩɔ ye. 'A ‑wɔnlɛhinhrenlɛ 'de 'le ‑kilowɩɩ ta ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Nɛ‑ nue, ‑Juukʋɛ 'plɔplɔ 'ʋ ‑hɔn 'le Jrusrɛ 'mʋ, 'ʋ di Matɩ kɔ Mari 'hɛɛn yrɛ 'ye wɔn, ʋ 'mu 'le ꞊wlʋ 'kwli 'mʋ gbo ꞊tu, 'waa ‑dɩayu Lasa a 'kʋkʋ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","‑Tɛ Matɩ 'wɩn, ‑ɛ mɔ, ‑Yusuu 'le 'nɩ di, ‑ye ɔ muo ye 'mʋ 'bɛ wɔn, kɛɛ, Mari ‑mɛ ‑ye, 'ke ɔ nɩ 'le kayu gbo. ");
INSERT INTO ted_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","‑Tɛ Matɩ nyre 'o ‑Yusu 'hʋɩn 'mʋ, ɔ nɔ: «Kʋkɔnyɔ o, 'bɩa ꞊nɩ nɩ o nɔ, 'n ‑dɩayu 'deɛ bɔ 'kʋ o. ");
INSERT INTO ted_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kɛɛ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'n yie nɩ, ‑ɛ mɔ, 'ɛ nɩ dɛ, ‑n di Nyɩsʋa ‑hʋa, ɔ die 'nɩ nu.» ");
INSERT INTO ted_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","‑Ye ‑Yusu nɔ: «‑Na ‑dɩayu di 'hrɩ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","‑Ye Matɩ nɔ: «Iin, 'n yie nɩ, ‑ɛ mɔ, 'lelɛ'bɔɔ‑nyrɔwɔ 'mʋ, ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa di 'le nahuin 'kʋkʋnyʋ ‑hɛyri lɛ ‑ha, 'kee nɩ, ɔ di 'o 'klɔ 'hrɩɩ.» ");
INSERT INTO ted_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","‑Ye ‑Yusu nɔ: «'Mɔɔ nɩ, ‑ɔɔ 'le nahuin 'kʋkʋnyʋ ‑hɛyri lɛ ‑ha, ‑ɔ nyu 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. Nahuon 'bɔ nɩ 'o, 'bɩa 'bɔ kuo 'mʋ ꞊wlʋ ye, ‑ye 'n ‑nyi ꞊nɔ 'klɔ yrayrʋ a ‑gbɛ. ꞊Betɩ bɔ 'kʋ, ɔ 'kɩɛ kʋɛ 'klɔ a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Nahuon ‑gbo, ‑ɔɔ ‑hʋnhlʋn po, 'bɩa 'bɔ kuo 'mʋ ꞊wlʋ ye, ‑ye sɛyɩ‑sɛyɩ ɔ 'deɛ bɔ 'kʋ gbe. ꞊Be dɛ a ‑gbɛ, ‑n pui ‑tɛɛ?» ");
INSERT INTO ted_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","‑Ye ɔ nɔ: «Iin, Kʋkɔnyɔ, 'n pui ‑tɛɛ, ‑ɛ mɔ, ‑mɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'a dakʋ ye ya. ‑Mɔ mɔ Nyɩsʋa a 'Yu, ‑ɔ di la nɔ 'klɔ ‑gbo ke di.» ");
INSERT INTO ted_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Bɔ po 'klɛɛ lɛ, ‑ye Matɩ mu 'a ‑dɩayu Mari da wɔn, 'ɔ dɔ ye, ɔ nɔ: «Tɔɔnyɔ di 'le ꞊le, ‑mɔ ɔɔ da.» ");
INSERT INTO ted_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","'Plɩɩ Mari 'mʋ dɩdawin a ‑gbɛ mu 'wɔn, ‑ye tii ‑do a ti 'yri, ɔ 'ba 'mʋ ye, 'ɔ mu 'le ‑Yusu 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","‑Yusu a ‑gbɛ, ɔ 'de wɛn 'dɩɔ 'mʋ a 'yɛɛ. ‑Tɛgbii ‑do ꞊nʋ, Matɩ yɔ wɛn 'o gbo, 'ke ɔ 'kɩɛ nɩɛ 'o. ");
INSERT INTO ted_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","‑Juukʋɛ ꞊nʋ, ‑ʋ dio 'le ꞊wlʋ 'kwli 'mʋ gbo ꞊tu wɔn, ‑tɛ ʋ 'ye, ‑ɛ mɔ, Mari a ‑gbɛ, ɔ 'kɩka nɩ, 'ɔ 'hrɩ, ‑ye 'waa ‑gbɛ, ʋ 'ba 'mʋ lɛ ye, 'ʋ kʋɔ ‑wɔn. Ʋ ‑mɛ ‑ye, ʋ nɔ 'nɩ, 'ke ɔɔ 'le 'dɛɛ ye mu, ɔ 'mʋ we. ");
INSERT INTO ted_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","‑Tɛ Mari nyre 'o ‑tɛgbi, ‑Yusu nɩ 'o, 'plɩɩ ɔ 'muo mu 'ye, ‑ye ɔ 'wlɛ kwlɩ, 'ke 'o ‑Yusu a bʋɩ ꞊hlɔn, ɔ nɔ: «Kʋkɔnyɔ o, 'bɩa ꞊nɩ nɩ o mɔ, 'na ‑dɩayu 'deɛ bɔ 'kʋ o.» ");
INSERT INTO ted_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","‑Yusu nye 'nɩ 'ye, ‑ɛ mɔ, ɔɔ 'nɩ we, kɔ, nahuin ꞊nʋ, ‑ʋ kʋɔ ‑wɔn, 'ʋʋ ‑wɛ we. Dɛ a ‑gbɛ, ɛ bʋbla ꞊nʋ gbo 'dɔ, kɔ, 'ɛɛ ‑wɛ ꞊nɔ wɔlɩ nue, ");
INSERT INTO ted_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","‑ye ɔ nɔ: «‑Tɛ a ‑hɩɔ 'o, ‑be' a puo gbo 'le?» Ʋ nɔ: «Kʋkɔnyɔ, di 'le, ꞊mʋ 'o ‑tɛgbi a ‑gbɛ 'yee.» ");
INSERT INTO ted_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","‑Ye ‑Yusu ‑tʋa wuwe gbo. ");
INSERT INTO ted_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","‑Ye nahuin nɔ: «Ba 'ye kɛ, ɔ nʋɔ 'mʋ nɩ 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","'Ke 'le nahuiin ‑do ꞊nʋ ‑gbahlɔn, kɛ ꞊ʋ ‑yee po: «'Be nɔ‑ kla o 'yiisuanyɔ a 'yii ke. Ɔ kɔ bɔ nue wɛn, Lasa 'nɩ ꞊han wɛn 'kʋ.» ");
INSERT INTO ted_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","‑Ye ‑Yusu bʋblɛ lele gbo, 'ɔ mu 'le 'dɛɛ ye. 'Dɛɛ a ‑gbɛ, ɛ mɔ 'hɩɔ a 'hʋɔɔ nɩ, 'ɔ nɩ 'le dʋgba 'kwli 'mʋ, 'ʋ nu o 'hɩɔ gbɛtɛɛ ‑ye, 'ʋ kɛ o ye. ");
INSERT INTO ted_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","‑Ye ‑Yusu nɔ: «Ba ‑ha 'o 'hɩɔ ‑gbo 'o, ʋ nu, 'ʋ ka 'dɛɛ ‑gbo ye.» Kɛɛ ‑ye kɛ Lasa a ‑dɩayu nyrɔyu Matɩɩ po: «Kʋkɔnyɔ o, ɔ di po 'nʋ, ‑ɛ nue, ɔ ‑hi 'le 'dɛɛ wlɔn ‑nyrɔwɩɩ ‑hɛn.» ");
INSERT INTO ted_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «'N le wɛn ‑mʋ nɩ, ‑ɛ mɔ, 'bɩa ꞊nɩ kuo 'mʋ ꞊wlʋ ye, ‑ye ‑n di Nyɩsʋa a ‑tɩ a 'yi'bʋbʋa 'nɩ 'ye.» ");
INSERT INTO ted_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","‑Ye ʋ ‑ha 'o 'hɩɔ a ‑gbɛ nɩ, ‑Yusu 'ɔ 'ba 'lu ye 'mʋ, 'ɔɔ 'le yakɔ 'mʋ lɛ ta, ɔ nɔ: «'Na Bu o, 'nɩɩ ‑mʋ ‑nyi 'wio, ‑ɛ nue, ‑n wɛɛn 'na 'batɩwin ke. ");
INSERT INTO ted_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","'N yie nɩ, ‑ɛ mɔ, 'ɛ nɩ ti, ‑nɩɩ 'na 'batɩwin ke 'nɩ wɛɛn. Kɛɛ, ‑tɩ ‑gbo, 'n ꞊tu wɛn, 'n ꞊tui nɩ, nahuin ‑gbo, ‑ʋ ꞊glaa 'le 'mʋ a ‑tɩ, ‑ɛ die nu, ʋ 'mue ‑tɛɛ pue, ‑ɛ mɔ, ‑mɔɔ nɩ, ‑ɔ lee nɔ 'mʋ 'klɔ ‑gbo ke.» ");
INSERT INTO ted_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","'Plɩɩ ɔ 'mʋ 'klɛɛ lɛ mu po, ‑ye ɔ 'yaa 'le win, ɔ nɔ: «Lasa, 'hrɩ 'le 'dɛɛ wlɔn!» ");
INSERT INTO ted_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lasa 'ɔ 'hrɩ, 'a bʋɩ kɔ 'a dabʋɩ 'ʋ 'hɩnhɩʋɩn ‑jisɛi lɛ, 'ʋ mʋa ‑wɛ 'a 'lu dapɩa lɛ. ‑Ye ‑Yusu nɔ: «Ba ꞊wlɔɔ lɛ, kɔ, ba ‑hɩɔ mɛ lɛ, bɔ na!» ");
INSERT INTO ted_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","'Ke 'le ‑Juukʋɛ ꞊nʋ ‑hɛyri, ‑ʋ di 'le Mari ‑wɔn, kɔ, ‑ʋ 'ye dɛ ꞊nʋ, ‑Yusu nu, 'waa 'plɔplɔ kuo ‑Yusu ꞊wlʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kɛɛ, 'ke 'le ꞊nʋ ‑hɛyri, ꞊ʋ ‑ye mu 'le Falisi꞊tumu a nahuin ‑wɔn, dɛ ꞊nʋ, ‑Yusu nu, 'ʋ ꞊tui ꞊nʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","‑Tɛ ʋ 'wɩn, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ, ʋ kɔ Falisi꞊tumu a nahuin a ‑gbɛ 'hɛɛn, ʋ kɔ 'waa 'bie nyɩgblakɩ 'hɛɛn, 'ʋ da ‑gboligbo, ʋ nɔ: «‑Be' ‑a di 'klɛɛ nu 'le? ‑Ɛ nue, nahuon ‑gbo, ɔɔ nu 'ŋmilɛka‑tɔplɩ 'plɔplɔ. ");
INSERT INTO ted_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","'Bɩa ꞊ba ‑hɩɔ mɛ lɛ, bɔ 'kɩɛ gbɛɛ 'lu ‑wɔn, nahuin 'bii dio ye kuo ꞊wlʋ, 'plɩɩ Romakʋɛ a nyɩgblakɩ, ʋ 'mʋ 'le di, ʋ 'mʋ ‑a mʋ gbatɩ klɛ ‑ha, ‑a mʋ ‑gbo, ‑ʋ mɔ Nyɩsʋa a 'kagblaka ‑gbo kɔ ‑a nɩ dakʋ 'bii a nyɩgblakɩ.» ");
INSERT INTO ted_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","'Ke 'le ꞊nʋ ‑hɛyri, nahuon ꞊nʋ, ‑ɔ mɔ Kaifʋ, ‑ɔ mɔ la 'yrʋ ꞊nʋ gbo a ‑cɔhlʋnpinyʋ a nyɩgblaka, ɔ nɔ: «꞊Be a 'nɩ yrii ꞊le 'mʋ lɛ, ");
INSERT INTO ted_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ɛ nu ‑tɛɛ, 'ke nahuoon ‑do bɔ 'kʋ, 'ke 'o ‑a nɩ dakʋ 'bii a ‑ta 'mʋ, 'ɛ ‑hi 'o ‑a nɩ dakʋ 'bii a ‑gbɛ bʋ ‑wɛ gbo.» ");
INSERT INTO ted_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sɛyɩ‑sɛyɩ, win ꞊nʋ, ɔ po, ɛ 'de 'a ‑gbɛ a 'lu a lɛ‑hielɛ. Kɛɛ, ‑tɛ ɔ 'ya 'yrʋ ꞊nʋ a ‑cɔhlʋnpinyʋ a nyɩgblaka 'mʋ, nɛ‑ nue, Nyɩsʋa 'ɔ ꞊tu ꞊nɔ win a ‑gbɛ wlɔn, 'ɔ nyi ꞊tu, ‑ɛ mɔ, ‑Yusu di 'nɩ 'kʋ, 'ke 'o ‑Juukʋɛ a dakʋ 'bii a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ɛ 'de ‑Juukʋɛɛ ‑do a ‑ta 'mʋ, ɔ 'deɛ bɔ 'kʋ. Kɛɛ, ɔ di 'nɩ 'kʋ, 'ke 'o Nyɩsʋa a 'yuo꞊pli 'bii a ‑ta 'mʋ, ‑ʋ 'sɛɛ 'klɔ 'bii ‑gbo ke gbo, ‑Yusu a ‑gbɛ, ɔ 'mu lɛ 'kukue, ʋ 'mʋ dɛɛ ‑do 'mʋ 'ya. ");
INSERT INTO ted_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kʋɛ 'o ‑nyrɔwɔ a ‑gbɛ 'yie 'mʋ gbo, ‑Juukʋɛ a ye'mʋnaanyʋ ‑yrɩ nɩ, 'ke bʋ 'la ‑Yusu. ");
INSERT INTO ted_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Dɛ a ‑gbɛ a ‑tɩ ‑Yusu 'ɔ 'nɩnɩ pa 'klɛɛ lele nahuin ‑hɛyri, 'ke 'le ‑Juukʋɛ a 'blʋgba 'mʋ. ‑Ye ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, 'ke ʋ mu 'le 'dɩɔ ꞊nʋ 'mʋ, ʋʋ Eflaimʋ daa, 'ʋ ‑hi 'le 'dai ti. 'Ke 'le Eflaimʋ a ‑gbɛ ke 'mʋ, ‑tʋtʋtɩɔ ꞊nʋ, ‑ɔ nɩ 'le, nahuon ꞊de 'de 'le 'ti. ");
INSERT INTO ted_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","‑Juukʋɛ a lɛ'mimre ꞊nʋ, ʋʋ Pakɩ daa, 'a ti 'mʋɛɛ yrɛ. 'Plɩɩ lɛ'mimre a ‑gbɛ, ɛ 'mʋ 'o nyre, 'blʋgba ꞊nʋ a nahuin 'plɔplɔ mu 'le Jrusrɛ 'mʋ, ‑ɛ die nu, dɛ ꞊nʋ, ʋ kɔ bʋ nu, 'plɩɩ ʋ 'mʋ 'o ye 'sii, 'ke 'o Nyɩsʋa ye, ʋ 'mue nu, 'plɩɩ ʋ 'mʋ lɛ'mimre a ‑gbɛ ke mu. ");
INSERT INTO ted_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nahuin a ‑gbɛ, ʋʋ lɛ ꞊mɔ ‑Yusu. ‑Tɛ ʋ nɩ 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, ‑ye ʋʋ wlɔn lɛ 'nɩ ꞊gbʋgba, ʋ nɔ: «꞊Be 'a nɩ ꞊wlʋ nɔ 'nɩ, ɔ di lɛ'mimre ke 'nɩ di?» ");
INSERT INTO ted_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ʋ ꞊tui o nɩ, ‑ɛ mɔ, 'bɩa nahuon ꞊de 'bɔ yii 'o ‑tɛgbi ꞊nʋ, ‑Yusu nɩ 'o, ‑ye bɔ lee ꞊nʋ, ‑ɛ die nu, ʋ 'muo klɩ. ");
INSERT INTO ted_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","‑Nyrɔwɩɩ ‑huonnɔ hie 'le, 'plɩɩ ‑Juukʋɛ a lɛ'mimre, ‑ɛ mɔ Pakɩ, ɛ 'mʋ 'o nyre, 'ke ‑Yusu mu 'le Betanidɩɔ 'mʋ, ɔ kɔ 'a ‑naagbopʋ 'hɛɛn. 'Dɩɔ a ‑gbɛ 'mʋ, 'ke nahuon ‑gbo, ‑ɔ mɔ Lasa nɩ 'le. Lasa a ‑gbɛ, nɔ‑ ‑Yusu ‑ha o 'le 'kʋkʋnyʋ ‑hɛyri, ɔ ‑ha o 'klɔ. 'Ke ɔ mu 'le Lasa a ‑gbɛ ‑wɔn, ɔ kɔ Lasa a ‑dɩayuo nyrʋyuoo 'hɔn ꞊nʋ 'hɛɛn, ‑ʋ mɔ Mari kɔ Matɩ. ");
INSERT INTO ted_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","‑Tɛ ɔ nyre 'le, 'ʋ pie ꞊nɔ, Matɩ 'ɔ po 'le ‑Yusu a dididɛ. Lasa bi 'le ye, ɔ kɔ nahuin ‑ye, nʋ‑ʋ dɛ di, ʋ kɔ ‑Yusu 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Bʋʋ 'klɛɛ dɛ di, ‑ye Mari 'ba 'mʋ ‑dawinniyrɩɛ. ‑Dawinni a ‑gbɛ, ɩɩ po ꞊die 'dɔ. ‑Tɛ ɔ 'bʋɩ 'mʋ, ‑ye ɔ plɩɩ ‑Yusu a bʋɩ lɛ, 'ɔ nu 'a dɩɔnʋ a 'lu‑pupui, 'ɔ 'hran ‑Yusu a bʋɩ lɛ, ‑dawinni a hʋnhrʋn 'ʋ 'sɛɛ kayu gbo. ");
INSERT INTO ted_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","'Plɩɩ Mari 'mʋ dɛ a ‑gbɛ mu nu, ‑ye ‑Yusu a ‑naagbopʋyu ‑ye, ‑ɔ kɔ 'dʋ mɔ Judɩa Yisikalio, ‑ɔ di ‑Yusu 'a yraanyʋ kwa po, kɛ ɔ po: ");
INSERT INTO ted_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«'Aa. Dɛ‑ kɔ ‑dawinni a ‑gbɛ, ʋ 'de plo? ‑Dawinni a ‑gbɛ a 'wliyɛ, ɛ ‑wɛ 'le bɛ 'ya wɛn ‑kʋannunyɔɔ ‑do a 'pɛɛwli nɩ, 'ke 'le yakʋɛɛ ‑pu 'kwli 'mʋ. 'Bɩa 'bʋ pli wɛn, ‑ye ‑a ‑wɛ 'le ‑ba ‑nyi wɛn 'a 'wliyɛ a ‑gbɛ ꞊sʋɛnyʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ɛ 'de bɔ kɔ ꞊sʋɛnyʋ a wɔlɩ a ‑tɩ, bɔ nu lɛ 'pʋprɛ. Kɛɛ, ɛ 'we ꞊nɔ ye, ɔ mɔ 'yrinyɔ'ɔ nɩ. Nɛ‑ nue, 'ɔ nu lɛ 'pʋprɛ. 'Ɛ mɔ ‑tɛɛ, nɔ‑ mɔ ꞊ke 'waa 'wligbo꞊tunyɔ, 'plɩɩ 'wli a ‑gbɛ, ɔɔ gblɛ ꞊tu, 'ɔ nyi ꞊ke lɛ 'yri. ");
INSERT INTO ted_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Kɛɛ ‑ye ‑Yusu nɔ: «‑Hɩɔ mɛ lɛ! Dɛ ʋ kɔ bʋ nu wɛn ti ‑kɔ 'yri 'n di wɛn 'o 'kʋʋ, ɔ nue kɛ nɩ ‑dodo. ");
INSERT INTO ted_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ba kɔ 'a yiyie, ꞊sʋɛnyʋ 'kɩɛ die nɔ 'a mʋ ‑gbahlɔn nɩ. 'Mɛ ‑ye, ti 'n di nɔ 'a mʋ ‑gbahlɔn ‑hi, ɩ 'de 'klɛɛ lele ‑huo.» ");
INSERT INTO ted_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tii ‑do a ‑gbɛ 'yri, ‑Juukʋɛ 'plɔplɔ 'wɩn nɩ, 'ke ‑Yusu nɩ 'le Betanidɩɔ 'mʋ, 'ʋ mu 'le. Ɛ 'de ‑Yusu a 'yiye‑tɩɩ ‑do, ʋ 'de 'le mu. Kɛɛ, ʋ mu ‑wɛ 'le ꞊le, ‑ɛ die nu, ʋ 'mʋ ‑wɛ Lasa 'ye, ‑Yusu ‑ha o 'le 'kʋkʋnyʋ ‑hɛyri, ɔ ‑ha o 'klɔ. ");
INSERT INTO ted_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","‑Ye Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ ‑yrɩ nɩ, 'ke bʋ 'la ‑wɛ Lasa, ");
INSERT INTO ted_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","‑ɛ nue, nɔ‑ kɔ ‑tɩɩ nɩ, ‑Juukʋɛ 'plɔplɔ 'ʋ kuo ‑Yusu ꞊wlʋ ye, 'ʋ 'kee nyɩgblakɩ a ‑gbɛ a ‑wɔnnaalɛ. ");
INSERT INTO ted_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye nahuin ꞊nʋ, ‑ʋ di Pakɩ a lɛ'mimre ke, ʋ 'wɩn nɩ, ‑ɛ mɔ, ‑Yusu di 'mʋ di Jrusrɛdɩɔ. ");
INSERT INTO ted_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","‑Ye ʋ 'bɛ yuohran, 'ʋ 'blo kwa lɛ, 'ʋ ꞊tɩ 'dɩɔ 'mʋ, 'ʋ mu ‑Yusu ye 'mʋ 'bɛ wɔn, 'ʋʋ 'le win 'yaa, ʋ nɔ: «‑Na 'wio, ‑mɔ ꞊nʋ, ‑ɔɔ 'le di, 'ke 'le Kʋkɔnyɔ a 'dʋ 'kwli 'mʋ. Nyɩsʋa bɔ nu ‑mʋ ꞊hapʋdɛ 'mʋ. Ba 'ye kɛ, Yisraɛkʋɛ a bodɩɔ, nɔ‑ɔ 'le di. Ba nɩ ‑ba bɔɔ.» ");
INSERT INTO ted_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","'Ke 'kasrayu ꞊de nɩ 'o. Nʋ‑ kɔ ke ‑Yusu 'ya 'o, ‑ɛ 'we ꞊nɔ ye, ‑tɛ Nyɩsʋacrɩɩnɩɛ, ɛɛ la 'a ꞊tutue nu, ‑ɛ mɔ: ");
INSERT INTO ted_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«Sion (Jrusrɛ) 'mʋ a nahuin, a nɩ pɩ 'le hʋannʋ. Ba 'ye kɛ, 'a nɩ bodɩɔ, nɔ‑ɔ 'le di. Nɔ‑ nɩ 'o 'kasrayu ke gbo.» ");
INSERT INTO ted_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","‑Ye ti a ‑gbɛ 'yri, ‑tɔplɩ ꞊nʋ, ‑Yusu, ɔ kɔ nahuin 'hɛɛn, ʋʋ nu, 'a ‑naagbopʋ 'nɩ yrii ꞊le 'mʋ lɛ. Kɛɛ, ti ꞊nʋ ‑kɔ 'yri ‑Yusu mu 'le yakɔ 'mʋ, 'ke 'le ‑tɩ a 'yi'bʋaalɛ 'kwli 'mʋ, ɩ bi 'le ꞊nʋ 'mʋ 'kwli, ‑ɛ mɔ, 'ɛ mɔ ‑tɛɛ, ‑tɛ Nyɩsʋacrɩɩnɩɛ, ɛ nu la 'a ꞊tutue, kɛ'ɛ nɩ, nahuin ꞊nʋ, ʋʋ o 'a nunue nu. ");
INSERT INTO ted_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","‑Tɛ ‑Yusu le o Lasa, 'ke bɔ 'hrɩ 'klɔ, bɔ ‑hɔn 'le 'dɛɛ wlɔn 'mʋ, nahuin 'plɔplɔ 'ye o dɛ a ‑gbɛ, 'ʋ mu o, 'ʋ le o nahuin ‑ye dɛ ꞊nʋ, ‑Yusu nu. ");
INSERT INTO ted_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nɛ‑ nue, nahuin ‑nɩ wɛn 'ʋ dio 'klɛɛ ye 'mʋ 'bɛ wɔn, ‑ɛ nue, ʋ 'wɩn o nɩ, ‑ɛ mɔ, ‑Yusu nu o 'ŋmilɛkadɛ a ‑gbɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","‑Ye Falisi꞊tumu a nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ ‑mɛ ‑ye, kɛ ʋʋ yrɛ pupo, ʋ nɔ: «A nye 'nɩ 'ye, nahuon ‑gbo, ɔ ‑hi ‑a mʋ wlɔn. Nahuin 'bii nyo ‑wɔn 'nɩ kʋɛ.» ");
INSERT INTO ted_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","‑Juukʋɛ a lɛ'mimre a ‑gbɛ a ti 'yri, ‑tɛ nahuin mu 'le Jrusrɛdɩɔ 'mʋ, 'ke bʋ da Nyɩsʋa, 'ke 'le nahuin a ‑gbɛ ‑hɛyri, 'ke Glɛkɩkʋɛ nɩ 'le. ");
INSERT INTO ted_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nahuin a ‑gbɛ, nʋ‑ mu 'o Filipʋ 'hʋɩn 'mʋ, ‑ɔ mɔ ‑Yusu a ‑naagbopʋyu ‑ye, ‑ɔ kɔ 'le Bɛtɩsaidadɩɔ 'mʋ, 'ke 'le Galileblʋgba 'mʋ, ʋ nɔ: «Nyɩbɛyu, ‑aa ‑hʋa ‑ba yi wɛn ‑Yusu.» ");
INSERT INTO ted_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","‑Ye Filipʋ a ‑gbɛ, ɔ mu nɩ, 'ɔ ꞊tui 'a 'be Adre ye, ʋ 'hɔn a ‑gbɛ 'ʋ bibi ke, 'ʋ mu, 'ʋ ꞊tui ‑Yusu ye. ");
INSERT INTO ted_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","‑Ye ‑Yusu nɔ: «Ti nyre 'o ꞊o, ‑ɩ kɔ 'yri 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, Nyɩsʋa di 'o 'mʋ ‑tɩ a 'yi'bʋaalɛ ‑nyee. ");
INSERT INTO ted_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","꞊Bo pue ꞊gblayɛ a dɛ ye. ꞊Gblayɛ a ‑gbɛ 'bɛ 'de ‑tʋtʋ lɛ 'tʋ, ɛ 'nɩ ꞊ga ꞊le nɩ, ‑ye ɛ 'die 'le ‑wɛ bɛ po 'hlɛ, kɛɛ, ɛ ‑do, nɛ‑ di 'o nɩ. Kɛɛ, 'bɩa 'bɛ 'tʋ ‑tʋtʋ lɛ, ɛ di 'nɩ ꞊ga, ɛ 'mʋ 'hlɛ po. ꞊Gblayɛ a ‑gbɛ a ꞊gɩga, ɛ 'we ꞊nɔ 'kʋkʋɛ ye. 'Na ‑gbɛ, 'n 'we ꞊nɔ ꞊gblayɛ ye. 'N kɔ ꞊bo 'kʋ, 'dai nahuin 'mʋ 'klɔ yrayrʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","‑Ye 'klɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ 'de ‑wɔn ‑wɛ, 'ke bɔ 'kʋ, 'na ꞊wlʋ a yekuolɛ a ‑tɩ, ɔ 'deɛ bɔ kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. Kɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ ‑wɛ ‑wɔn, 'ke bɔ 'kʋ, ‑ɛ nue, ɔ mɔ 'na nahuoon nɩ, ɔ di kɔ 'klɔ yrayrʋ, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","'Bɩa nahuon 'bɔɔ ‑hʋa bɔ nu 'na ‑kʋan, ‑ye ɔ blɛ ye bɔ naa 'mʋ ‑wɔn, ‑tɛgbi 'nɩɩ 'o muu, ɔ kɔ bɔ muu ‑wɛ 'o, ꞊betɩ bɔ di 'kʋ. 'Ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔɔ 'na ‑kʋan nu, 'na Bu Nyɩsʋa, nɔ‑ dio ‑tɩ a 'yi'bʋaalɛ ‑nyi.» ");
INSERT INTO ted_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, 'na ‑hihiu hren 'mʋ ‑wɔn. ‑Be' 'n di 'klɛɛ 'na Bu ye po 'le? ꞊Be kɛ ꞊bo po: 'Na Bu Nyɩsʋa o, nue, ꞊sʋɛ'yeti, ‑ɩ di 'le di, bɩ hren 'mʋ ‑wɔn. 'Ʋʋn, 'nɩ po ꞊le lɛ, ‑ɛ nue, ꞊sʋɛ'yeti ꞊nʋ, nɩ‑ 'mʋ 'le wlɔn naa. Nɛ‑ kɔ ‑tɩ 'nɩ di nɔ 'klɔ ‑gbo ke. ");
INSERT INTO ted_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kɛ 'n di po: 'Na Bu o, nue, ꞊mʋ ‑tɩ a 'yi'bʋaalɛ kɔ.» Bɔ po 'klɛɛ lɛ, ‑ye Nyɩsʋa a win ‑hɔn 'le yakɔ 'mʋ, 'ɩɩ lɛ po: «'N nue nɩ ‑dodo, 'na ‑tɩ 'ɩ kɔ ‑tɩ a 'yi'bʋaalɛ, 'plɩɩ 'mue lele nu.» ");
INSERT INTO ted_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nahuin ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'wɔn win a ‑gbɛ nɩ, ʋ nɔ: «‑Tɛɛ nɩ, ‑ɛ ma.» ꞊Ʋ ‑ye nɔ: «Nyɩsʋa a lɛleenyɔ ‑yee nɩ, ‑ɔ 'prɛ.» ");
INSERT INTO ted_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Kɛɛ ‑ye ‑Yusu nɔ: «Ɛ 'de 'na ‑tɩ, win ꞊nʋ, ɩ 'de pue, kɛɛ, 'a mʋ kɔ ‑tɩɩ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ti nyre 'o ꞊o, ‑ɩ kɔ 'yri Nyɩsʋa di 'o 'klɔ ‑gbo ke a nahuin ‑bati lɛ poo. ‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, Nyɩsʋa di 'klɔ ‑gbo a nyɩgblaka Satan gbata ke 'nɩ ‑ha. ");
INSERT INTO ted_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","'Mɛ ‑ye, ti ꞊nʋ ‑kɔ 'yri ʋ di 'o 'mʋ ye 'mʋ 'baa, 'ke 'o tu 'yie 'mʋ, 'mʋ ‑tʋtʋ ‑wɔn hren, 'n die 'nɩ nu, nahuin 'bii, ʋ 'mʋ 'mʋ ye 'mʋɛɛ.» ");
INSERT INTO ted_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","'Kʋkʋɛdʋ ꞊nʋ, ɔ di 'kʋ, nɛ‑ ɔ ꞊hɛn 'nyrɛ, 'ɔ nu lɛ 'pʋprɛ. ");
INSERT INTO ted_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","‑Ye kɛ nahuin ꞊nʋ, ʋ nyo ye po, ʋ nɔ: «'Ke 'le Nyɩsʋa a teteicrɩɩnɩɛi 'kwli 'mʋ, ʋ 'crɩɛ la nɩ, ‑ɛ mɔ, Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, ɔ di hie 'klɔ. Dɛ‑ kɔ ‑tɩ, ‑mɛ ‑ye, ꞊nɩɩ lɛ po, ‑ɛ mɔ, ʋ di nahuon ꞊nʋ, ‑ɔ mɔ ‑tʋnahuin 'bii Nahuon 'mʋ 'ba ye, 'ke 'o tu 'yie 'mʋ, ɔ 'mʋ ‑tʋtʋ ‑wɔn hren? Nahuon tio‑ mɔ 'klɛɛ ‑tʋnahuin 'bii a Nahuon a ‑gbɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «Kɛ ‑nyrɛ 'kɩɛ nɩɛ nɔ 'a mʋ ‑gbahlɔn, 'ke 'le ti gbi 'kwli 'mʋ. Ba na ‑nyrɛ a ‑gbɛ 'mʋ, ‑tɛ ɛ 'kɩɛ nɩɛ nɔ 'a mʋ ‑gbahlɔn, ‑ɛ die nu, gbɩgbɩyrɩ 'nɩ ꞊han 'a mʋ 'mʋ gbo 'ta, ‑ɛ nue, nahuon ꞊nʋ, ‑ɔɔ gbɩgbɩyrɩ ‑hɛyri na, ‑tɛgbi ɔɔ 'o muu, ɔ 'de 'o yii. ");
INSERT INTO ted_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","'A ‑tɩ, ba kuo ‑nyrɛ ꞊nʋ ꞊wlʋ ye, ‑tɛ ɛ 'kɩɛ nɩɛ nɔ 'a mʋ ‑gbahlɔn, ‑ɛ die nu, a 'mʋ nahuin ꞊nʋ 'mʋ 'ya, ‑ʋʋ ‑nyrɛ 'mʋ na.» ‑Tɛ ‑Yusu ‑wɔ ‑tɩ ꞊nʋ a ꞊tutue ‑wɔn, ‑ye ɔ hren ꞊nʋ ‑wɔn, 'ɔ ‑hlu 'yi ke. ");
INSERT INTO ted_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","꞊Hapʋkɔ, 'ɔ nu 'ŋmilɛka‑tɔplɩ, 'ɩ ‑huo, kɛɛ, nahuin, ʋ 'dio ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Dɛ a ‑gbɛ, ɛ mue ‑wɔn 'lu, ‑ɛ die nu, ‑tɩ ꞊nʋ, Nyɩsʋa a winwlɔn‑hɛnyɔ Esai ꞊tu la, ɩ 'mʋ nue. ‑Tɩ a ‑gbɛ, Esai ꞊tu la, nɩ‑ ‑gbo: «Nyɩsʋa o, ‑tɩ ‑gbo, ‑aa ꞊tu, nahuon tio‑ pui ‑tɛɛ? Nahuon tio‑ yrii ‑na 'klɩkenɩnɩɛ 'le? Ɛ 'de 'a nahuon ꞊de kɔ.» ");
INSERT INTO ted_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Esai a ‑gbɛ, ɔ ꞊tui la ‑wɛ nɩ, ‑tɩ kɔ ‑tɩ 'ʋ 'die 'le ‑wɛ bʋ kuo ‑Yusu ꞊wlʋ ye. Kɛ ɔ po: ");
INSERT INTO ted_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«Nyɩsʋa sua 'waa 'yii nɩ, ‑ɛ die nu, ʋ 'nɩ ꞊han dɛ lɛ yrii, kɔ, 'ɔ nue, 'waa ꞊wlɩ 'ɩ 'gboklo 'mʋ, ‑ɛ die nu, ʋ 'nɩ ꞊han ‑tɩ 'mʋ lɛ yrii. 'Ɛ mɔ ‑tɛɛ, 'bɩa 'bʋʋ wɛn ‑tɩ 'mʋ lɛ yrii, ʋ dio wɛn ye 'nɩ 'mʋɛɛ, ‑ɛ die nu, ɔ 'mu wɛn waa.» ");
INSERT INTO ted_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esai a ‑gbɛ, ɔ ꞊tui la nɩ, ‑ɛ nue, ɔ 'ye la ‑Yusu a ‑tɩ a 'yi'bʋaalɛ nɩ, 'ɔ ꞊tu la ‑Yusu a ‑gbɛ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Mɔ ꞊betɩ Esai bɔ nu lɛ 'pʋprɛ, ‑Juukʋɛ a ye'mʋnaanyʋ 'plɔplɔ, ʋ kuo ‑wɛ ‑Yusu ye ꞊wlʋ. Kɛɛ, ʋ 'di ꞊tu, 'ke 'o nahuin ye, ‑ɛ nue, ʋʋ pɩ Falisi꞊tumu a nahuin a hʋannʋ, 'ke bʋ blʋ lɛ, 'ke 'le Nyɩsʋa a kayuo gbo. ");
INSERT INTO ted_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ʋ nye 'nɩ ‑hʋa, 'ke nahuin bʋ baa ꞊nʋ, 'ɛ ‑hi 'o 'ke Nyɩsʋa bɔ baa ꞊nʋ. ");
INSERT INTO ted_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","‑Ye ‑Yusuu 'le win 'nɩ 'yaa, kɛ ɔɔ nahuin ye po, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔ kuo 'mʋ ꞊wlʋ ye, ɛ 'de 'n ‑do, ɔ 'de 'mʋ ꞊wlʋ ye kuo, kɛɛ, ɔ kuo ‑wɛ 'na Bu ye ꞊wlʋ, ‑ɔ lee nɔ 'mʋ 'klɔ ‑gbo ke. ");
INSERT INTO ted_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Nahuon 'bɔɔ 'mʋ 'ye, ‑ye ɔɔ ‑wɛ 'na Bu 'nɩ 'ye, ‑ɔɔ lee nɔ 'mʋ 'klɔ ‑gbo ke. ");
INSERT INTO ted_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","'N di nɔ 'klɔ ‑gbo ke nɩ, ‑ɛ 'we ꞊nɔ ‑nyrɛ ye, ‑ɛ die nu, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ kuo 'mʋ ꞊wlʋ ye, ɔ 'nɩ ꞊han 'le gbɩgbɩyrɩ ‑hɛyri nɩ. ");
INSERT INTO ted_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Nahuon 'bɔɔ 'na wintɛ 'wɔn, 'bɔ 'nɩnɩ ꞊tui 'o, ɛ 'de 'mɔ, 'n 'deɛ ꞊bo puo ‑bati lɛ, ‑ɛ nue, 'n di 'le ꞊le, 'ke ꞊bo waa nahuin. 'N 'de 'le di, 'ke ꞊bo puu ‑bati lɛ. ");
INSERT INTO ted_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nahuon 'bɔ nɩ 'o, 'bɔ bla 'mʋ ye, kɔ, 'bɔ 'nɩnɩ po 'mʋ nʋa ye gbo, ‑ye 'lelɛ'bɔɔ‑nyrɔwɔ 'mʋ, ‑bati dio 'nɩ klɩ, ‑ɛ nue, ɔ 'de 'na wintɛ nʋa ye gbo po. ");
INSERT INTO ted_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","'Ɛ mɔ ‑tɛɛ, ɛ 'de 'le 'na 'klɩɩ ‑do 'kwli 'mʋ, 'n 'de 'le nahuin tɔɔ, kɛɛ, 'na Bu ꞊nʋ, ‑ɔ lee nɔ 'mʋ 'klɔ ke, nɔ‑ le 'mʋ ‑tɩ ꞊nʋ, 'n kɔ ꞊bo tɔɔ. ");
INSERT INTO ted_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","'N yie nɩ, ‑ɛ mɔ, ‑tɩ ꞊nʋ, ɔɔ ‑hʋa ꞊bo tɔɔ nahuin, nɩ‑ nye nu, nahuin 'ʋʋ 'klɔ yrayrʋ ꞊nʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le. Nɛ‑ nue, ‑tɩ ꞊nʋ, 'na Bu le 'mʋ, 'ke ꞊bo tɔɔ nahuin, ɩ ‑do, nɩ‑ 'nɩɩ ꞊nʋ tɔɔ.» ");
INSERT INTO ted_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ɛ hie 'le ‑nyrɔwɔɔ ‑do, 'plɩɩ ‑Juukʋɛ a lɛ'mimre, ‑ɛ mɔ Pakɩ, ɛ 'mʋ 'o nyre. ‑Yusu yie nɩ, ‑ɛ mɔ, ti nyre 'o ꞊o, 'ke bɔ ‑hɔn nɔ 'klɔ ‑gbo ke 'mʋ, bɔ mu 'le 'a Bu Nyɩsʋa ‑wɔn. Nahuin ꞊nʋ, ‑ʋ mɔ 'a nahuin, kɛ nɔ 'klɔ ‑gbo ke, ɔ nʋʋ 'mʋ nɩ ti a pɛpɛ, kɔ, ɔ 'cipi 'o 'waa 'mʋnʋɛlɛ. ");
INSERT INTO ted_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","‑Wise, ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, 'ke ʋ nɩ 'o dɛdiilɛ 'mʋ. 'Plɩɩ ʋ 'mʋ dɛ mu di, ɛ 'de kayu a 'mʋ‑hɛnyɔ kɔ, ‑bɔ yra 'waa bʋɩ lɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑Juukʋɛɛ 'a nunue nu. 'Plɩɩ ʋ 'mʋ dɛ mu di, ‑ye 'kuo ‑hʋɩn a nyɩgblaka Satan, ɔ 'prɛɛ 'le Judɩa Yisikalio ‑wɔn, ‑ɔ mɔ Simɔ a 'yu, 'ke bɔ po ‑Yusu 'a yraanyʋ kwa. ");
INSERT INTO ted_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","‑Yusu a ‑gbɛ, ɔ yie nɩ, ‑ɛ mɔ, Nyɩsʋa ‑nyi ꞊nɔ 'klɩ, 'ke bɔ kɔɔ ‑tɔplɩ 'bii win ke, 'ɔ yie ‑wɛ, ‑ɛ mɔ, 'ke ɔ ‑hɔn 'le Nyɩsʋa ‑wɔn 'mʋ, kɔ, 'ɔ kɔ bɔ ꞊hɩan ‑wɔn, ɔ 'mʋ 'le ꞊nɔ ‑wɔn mu. ");
INSERT INTO ted_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","꞊Hapʋkɔ, 'ɔ yi ‑tɔplɩ 'bii a ‑gbɛ, kɛɛ, ɔ 'ba 'mʋ ye, 'ɔ ‑hɛ 'a 'luyewlawlʋ, 'ɔ 'ba ‑ploodanʋ 'mʋ, 'ɔ kluu ‑bubui ke, ");
INSERT INTO ted_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","'ɔ po 'le 'nie 'pɔhlʋ wlɔn, 'ɔ ‑tʋa 'a ‑naagbopʋ a bʋɩ a lɛyɩyra gbo. 'Bɔ yra nahuoon ‑do a bʋɩ lɛ, ‑ye ɔ nu ‑ploodanʋ ꞊nʋ, ɔ klɩɩ wɛn ‑bubui ke, 'ɔ nyo bʋɩ lɛ 'hran. ");
INSERT INTO ted_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Nɛ‑ ɔ nu ‑nunu, 'ɔ nyre 'o Simɔ Piɛlɩ 'hʋɩn 'mʋ. ‑Tɛ ɔ nyro 'klɛɛ 'o 'hʋɩn 'mʋ, ‑ye Simɔ Piɛlɩ nɔ: «Kʋkɔnyɔ, ꞊be ‑mɔɔ 'na bʋɩ lɛ mu yra?» ");
INSERT INTO ted_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","‑Ye ‑Yusu nɔ: «Dɛ ‑gbo, 'nɩɩ nu, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, ꞊nɩ yrie ꞊le 'mʋ lɛ, kɛɛ, 'ke 'le ye 'mʋ, ‑n die 'mʋ lɛ 'nɩ yrii.» ");
INSERT INTO ted_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","‑Ye Piɛlɩ nɔ: «Gbegbe, ‑n 'deɛ ‑bo yra 'na bʋɩ lɛ.» ‑Ye ‑Yusu nɔ: «'Bɩa 'nɩ 'de ‑na bʋɩ ‑gbo lɛ yra, ‑n 'deɛ ‑bo 'ya 'klɛɛ lele 'na nahuon 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","‑Ye Simɔ Piɛlɩ nɔ: «'Bɩa 'bɛ nɩ lɛ 'mʋ, ɛ nɩ 'ya 'le 'na bʋɩɩ ‑do 'mʋ, kɛɛ, yra ‑wɛ 'mʋ kwa lɛ, kɔ, yra ‑wɛ 'na 'lu lɛ.» ");
INSERT INTO ted_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","‑Ye ‑Yusu nɔ: «Nahuon 'bɔ ‑plo, 'bɔ na lɛ dɛ gbi, ɔ 'de kɔ bɔ ‑plo lele, 'bɛ 'de bɔ yra 'a bʋɩ lɛɛ ‑do, ‑ɛ nue, ɔ 'wʋ 'le ꞊le 'bii. A ‑mɛ ‑ye, a 'wʋ 'le ꞊le. Kɛɛ ‑ye ɛ 'de a 'bii, a 'de 'le 'wʋ.» Ɛ 'we ꞊nɔ ye, 'waa 'oye'siilɛ, 'ke 'o Nyɩsʋa ye, nɛ‑ kɔ ‑tɩ ‑Yusu ꞊hɛn 'nyrɛ. ");
INSERT INTO ted_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ɔ yi nahuon ꞊nʋ nɩ, 'ke 'le ꞊nʋ ‑gbahlɔn, ‑ɔ di ꞊nɔ 'a yraanyʋ kwa po. Nɛ‑ nue, 'ɔ po wɛn lɛ: «Ɛ 'de ʋ 'bii, ʋ 'de 'le 'wʋ.» ");
INSERT INTO ted_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","‑Tɛ ɔ ‑wɔ 'waa bʋɩ a lɛyɩyra ‑wɔn, ‑ye ɔ pue lele 'a 'luyewlawlʋ nɩ, 'ɔ nɩ lele gbo, 'ke 'o dɛdi‑tuoo ‑do ꞊nʋ ke, ɔ nɔ: «Dɛ ‑gbo, 'n nu 'a mʋ 'mʋ, ꞊be dɛ ‑gbo, ɛ ꞊hɛn 'nyrɛ, a yree 'mʋ lɛ? ");
INSERT INTO ted_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","'Baa 'mʋ da, kɛ aa po: Tɔɔnyɔ kɔ Kʋkɔnyɔ 'hɛɛn. 'Plɩɩ ‑ye, ‑tɩ a ‑tɛɛ aa ꞊tu, ‑ɛ nue, 'ɛ mɔ ‑tɛɛ, 'mɔ mɔ Tɔɔnyɔ, kɔ Kʋkɔnyɔ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","'A ‑tɩ o, ‑tɛ 'mɔ ‑gbo, ‑ɔ mɔ 'a nɩ Kʋkɔnyɔ kɔ 'a nɩ Tɔɔnyɔ 'hɛɛn, 'n nu, 'nɩ ꞊tɩɔ 'le 'n dɩɔnʋ, 'nɩ yra 'a mʋ bʋɩ lɛ, 'a nɩ ‑gbɛ, kɛ ba nu, ba ꞊tɩɔ ‑wɛ 'le 'a nɩ dɩɔnʋ, a 'mʋ ‑wɛ bʋɩ lɛ yɩyra. ");
INSERT INTO ted_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","'N tʋɛ 'a mʋ nɩ, ‑ɛ mɔ, 'n ꞊tɩɔ 'le 'n dɩɔnʋ nɩ, 'nɩ ‑hɛ 'a nɩ 'mʋ‑hɛnyɔ, ‑ɛ die nu, dɛ ‑gbo, 'n nu 'a mʋ 'mʋ, a 'mue ‑wɛ 'mʋ nunu. ");
INSERT INTO ted_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ɛ 'de ‑kʋannunyɔ ꞊de kɔ, ‑bɔ di 'o 'a 'masɛ 'lu ye nɩ. Ɛ 'de ‑wɛ lɛleenyɔ ꞊de kɔ, ‑bɔ di ‑wɛ 'o nahuon ‑gbo, ‑ɔ lee ꞊nɔ 'lu ye nɩ. ");
INSERT INTO ted_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","'A ‑tɩ o, a yie 'klɛɛ nɩ. 'Bɩa 'baa lɛ 'a nunue nu, ‑ye a di kɔ plɔ a bleelɛ. ");
INSERT INTO ted_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ɛ 'de a 'bii, 'n 'de 'a mʋ 'nyrɛ ꞊hɛn. Nahuin ꞊nʋ, 'n ‑ha 'le du 'mʋ, 'ke bʋ 'ya 'na nahuin 'mʋ, 'n yiu nɩ. Kɛɛ, ‑tɩ ꞊nʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɛ blɛ ye bɩ mue 'lu ‑wɔn. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: Nahuon ‑gbo, ‑ɔ kɔ 'mʋ 'hɛɛn, ‑ʋ 'nyra 'le dabʋ dɛdihuoo ‑do wlɔn, nɔ‑ ‑hɛ 'na yraanyɔ. ");
INSERT INTO ted_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","'N nyi 'a mʋ ye 'nɩ ꞊tu ‑dodo, 'plɩɩ ɛ 'mʋ 'o nyre, ‑ɛ die nu, ti ‑kɔ 'yri ɛ di 'o nyre, a 'mʋ 'mʋ ꞊wlʋ ye kuo, ‑ɛ mɔ, 'mɔ mɔ nahuon ‑gbo, Nyɩsʋa lee nɔ ‑tʋtʋ ke. ");
INSERT INTO ted_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon 'bɔ nɩ 'o, 'bɔ 'ble 'na lɛleenyɔ kwa, ɛ 'we ꞊nɔ ye, 'mɔɔ nɩ, ɔ 'ble kwa. Kɔ, nahuon 'bɔ 'ble 'mʋ kwa, ɛ 'we ꞊nɔ ye, 'na Bu Nyɩsʋa'a nɩ, ‑ɔ lee 'mʋ, nɔ‑ ɔ 'ble kwa.» ");
INSERT INTO ted_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","'Plɩɩ ‑Yusu 'mʋ win a ‑gbɛ mu po, ‑ye 'a ꞊wlʋ 'mʋɛ gbo 'dɔ. Kɛ ɔɔ 'a ‑naagbopʋ ye po, ɔ 'de ꞊nʋ dɛ ꞊de 'yi ke ‑hli, ɔ nɔ: «'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, nahuon nɩ nɔ 'a mʋ ‑hɛyri. Nɔ‑ di 'mʋ 'na yraanyʋ kwa po.» ");
INSERT INTO ted_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","‑Ye ʋʋ 'nɩ 'yiye. Nahuon tio‑ ‑Yusu ꞊hɛn 'nyrɛ, 'ke 'le ꞊nʋ ‑hɛyri, ʋ 'dio yi. ");
INSERT INTO ted_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","‑Naagbopʋyu ‑ye nɩ 'o, ‑Yusu nʋɛ 'mʋ ‑tɛɛ, nɔ‑ nɩ 'o ‑Yusu 'hʋɩn 'mʋ gbo. ");
INSERT INTO ted_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nɔ‑ Simɔ Piɛlɩ nu ‑jie, ɔ le, bɔ ꞊gba ‑Yusu wlɔn, nahuon tio‑ ‑Yusu ꞊hɛn 'nyrɛ, ");
INSERT INTO ted_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","‑naagbopʋyu a ‑gbɛ 'ɔ 'prɛɛ 'le ‑Yusu nʋa 'mʋ, 'ɔ ꞊gbɔ wlɔn, ɔ nɔ: «Kʋkɔnyɔ, nahuon tio‑ ‑n ꞊hɛn 'nyrɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «'Flɔɔ꞊tɩɔ ‑gbo, 'n di 'le 'yanu ‑wɔn 'nyra, nahuon, 'n dio ‑nyi, nɔ‑ɔ nɩ,» 'ɔ 'ba 'flɔɔ꞊tɩɔ 'mʋ, 'ɔ 'nyrɔ 'le 'yanu ‑wɔn, 'ɔ ‑nyo Judɩa, ‑ɔ mɔ Simɔ Yisikalio a 'yu. ");
INSERT INTO ted_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","'Plɩɩ Judɩa 'mʋ 'flɔɔ꞊tɩɔ a ‑gbɛ mu di, ‑ye Satan kʋɔ ke win 'bii. Kɛ ‑Yusu nyo 'klɛɛ ye po, ɔ nɔ: «Po 'le 'klɩ lɛ, dɛ ‑n kɔ ‑bo nu, ꞊mue nu!» ");
INSERT INTO ted_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nahuin 'bii, ‑ʋ nɩ 'o dɛdi‑tuoo ‑do a ‑gbɛ ke, ꞊ɔ ꞊de 'di 'mʋ lɛ yrii, ‑tɩ kɔ ‑tɩ ‑Yusu 'ɔ nu lɛ 'pʋprɛ. ");
INSERT INTO ted_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","‑Tɛ Judɩa 'ya la 'wligbo꞊tunyɔ 'mʋ a ‑tɩ, ꞊ʋ ‑ye nɔ 'nɩ, ‑Yusu lo nɩ, 'ke bɔ mu lɛ'mimre a dididɛ ꞊nʋ ‑tɔ, ꞊ʋ ‑ye nɔ 'nɩ, ‑Yusu lo nɩ, 'ke bɔ ‑ha 'le 'wli, bɔ ‑nyi ꞊sʋɛnyʋ. ");
INSERT INTO ted_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","‑Tɛ Judɩa ‑wɔ 'klɛɛ 'flɔɔ꞊tɩɔ a ‑gbɛ lɛ, ‑ye tii ‑do a ti 'yri, ɔ bi 'le 'mʋ ‑patʋ, 'ke 'le gbɩgbɩyrɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","‑Tɛ Judɩa bi 'klɛɛ 'le ‑patʋ 'mʋ, ‑ye kɛ ‑Yusuu 'a ‑naagbopʋ ye po, ɔ nɔ: «‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, 'mɔ ‑gbo, ‑ɔ mɔ ‑tʋnahuin 'bii a Nahuon, 'na ‑tɩ a 'yi'bʋaalɛ di 'mʋ bi pepe'. ‑Ye 'n die 'nɩ nu, nahuin 'mʋ ‑wɛ Nyɩsʋa a ‑tɩ a 'yi'bʋaalɛ 'ye. ");
INSERT INTO ted_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","'Bɩa 'nɩ nu dɛ a ‑gbɛ, ‑ye Nyɩsʋa die lele 'nɩ nu, nahuin 'mʋ 'na ‑tɩ a 'yi'bʋaalɛ 'ye. Ɔ ‑wɛ lɛ kɛ 'a nunue. Ɔ di 'mʋ ‑nyi ꞊hapʋgbonɩɩlɛ, 'ke 'le ꞊nɔ 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","'Na 'yuo o, ti ꞊nʋ, 'n 'kɩɛ die 'o 'a mʋ 'hʋɩn 'mʋ ‑hi, ɩ 'de 'klɛɛ lele ‑huo. A di 'mʋ lɛ 'nɩ ꞊mɔ. Kɛɛ, ‑tɩ ꞊nʋ, 'n ꞊tu o ‑Juukʋɛ a ye'mʋnaanyʋ ye, nɩ‑ 'nɩɩ ‑wɛ 'a mʋ ye mu ꞊tu. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: ‑Tɛgbi 'nɩɩ 'le mu, a 'de 'le mumue ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","'Nɩɩ 'a mʋ ‑nye tetebʋ yrayrʋ. Tetebʋ a ‑gbɛ, nʋ‑ ‑gbo: Ba nʋnʋɛ 'mʋ. ‑Tɛ 'n nu 'a nɩ 'mʋnʋɛlɛ, kɛ'ɛ nɩ, a kɔ ba nu ‑wɛ 'mʋnʋnʋɛlɛ. ");
INSERT INTO ted_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","'Bɩa 'ba nʋnʋɛ 'mʋ, ‑ye nahuin 'bii, ʋ die 'nɩ yrii, ‑ɛ mɔ, 'a mʋ mɔ 'na ‑naagbopʋʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","‑Ye Simɔ Piɛlɩ ꞊gbɔ wlɔn, ɔ nɔ: «Kʋkɔnyɔ, ‑be' ‑nɩɩ ye mue 'le?» ‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, ‑tɛgbi 'nɩɩ 'le mu, ‑n 'de 'le 'na ‑wɔnkʋkʋɛ ‑wɛ. Kɛɛ, ti di 'o 'nɩ nyre, ‑ɩ kɔ 'yri ‑n di 'o 'mʋ ‑wɔn kʋɛɛ.» ");
INSERT INTO ted_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","‑Ye Piɛlɩ nɔ: «Kʋkɔnyɔ, 'n ‑wɛ ‑wɔn, 'ke ꞊bo ‑ha 'na ‑hʋnhlʋn, 'ke 'o ‑na ‑ta 'mʋ. Dɛ‑ nue, ꞊nɩ plɛ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'n 'de 'le ‑na ‑wɔnkʋkʋɛ ‑wɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","‑Ye ‑Yusu nɔ: «꞊Be 'ɛ mɔ ‑tɛɛ, ‑n ‑wɛ ‑wɔn, 'ke ‑bo ‑ha ‑na ‑hʋnhlʋn, 'ke 'o 'na ‑ta 'mʋ? 'Nɩɩ ‑mʋ 'nɩ le, 'plɩɩ hapɛ 'mʋ kɛ ‑nyrɛ mu da, ‑n di nu 'a ꞊tuuwɩɩ ta, ‑ɛ mɔ, ‑n 'de 'mʋ yi.» ");
INSERT INTO ted_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","‑Ye kɛ ‑Yusuu ꞊nʋ ye po, ɔ nɔ: «'A nɩ ꞊wlʋ nɩ bi 'le ꞊hlɔn. Ba kuo Nyɩsʋa ꞊wlʋ ye, a 'mʋ ‑wɛ 'mʋ ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Gbonɩɩlɛi ‑huo 'le 'na Bu ‑wɔn. 'Nɩɩ 'nɩ mu, 'mʋ 'a nɩ gbonɩɩlɛ ‑wɔn ‑wɔ. 'Bɩa 'bɛ 'de wɛn ‑tɩ a ‑tɛɛ, 'n 'deɛ ꞊bo ꞊tui wɛn 'a mʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","'Bɩa 'nɩ mu, 'nɩ ‑wɔ 'a nɩ gbonɩɩlɛ ‑wɔn, ‑ye 'n di 'le lele 'nɩ di, 'mʋ 'a mʋ gba, ‑ɛ die nu, ‑tɛgbi ꞊nʋ, 'n nɩ 'o, a 'mʋ ‑wɛ 'o nɩ. ");
INSERT INTO ted_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","A yi 'hru ꞊nʋ nɩ, nahuon di na, ‑tɛgbi ꞊nʋ, 'n nɩ 'le, ɔ 'mʋ 'le nyre.» ");
INSERT INTO ted_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","‑Ye kɛ Toma, ɔɔ ꞊nɔ ye po, ɔ nɔ: «Kʋkɔnyɔ o, ‑tɛgbi ꞊nʋ, ‑nɩɩ 'le mu, ‑a 'de 'le yii. ‑Be' ‑a ‑wɛ 'le ‑ba nu 'klɛɛ 'a 'hru a yiyie 'le?» ");
INSERT INTO ted_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «'Na ‑gbɛ, 'mɔ mɔ 'hru ꞊nʋ, 'mɔ mɔ ‑wɛ ‑tɩ a ‑tɛɛ, kɔ, 'mɔ mɔ ‑wɛ 'klɔ yrayrʋ. Ɛ 'de nahuon ꞊de kɔ, ‑bɔ mu 'le 'n Bu ‑wɔn, ‑bɔ 'de 'le 'mʋ naa. ");
INSERT INTO ted_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","'Bɩa 'ba yi 'mʋ, ‑ye a yi ‑wɛ 'n Bu nɩ. Kʋɛ 'klɛɛ mɔ gbo, a yio nɩ, 'a 'yo ‑wɛ.» ");
INSERT INTO ted_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","‑Ye Filipʋ nɔ: «Kʋkɔnyɔ o, tɔɔ ‑a mʋ ‑na Bu. ꞊Nɩ tʋɔ ‑a mʋ, ‑ye ‑a di kɔ plɔ a bleelɛ.» ");
INSERT INTO ted_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","‑Ye ‑Yusu ꞊tuo lele ‑wɔn, ɔ nɔ: «Filipʋ o, ‑tɛ a kɔ 'mʋ 'hɛɛn, ‑a bibi la 'hʋɩn 'mʋ, ɛ ‑wlɛn gbo, 'plɩɩ ‑n 'kɩɛ 'dee 'mʋ a yie. Nahuon 'bɔ 'ye 'mʋ, ‑ye ɔ 'ye 'na Bu nɩ. Dɛ‑ kɔ ‑tɩ ꞊nɩɩ 'klɛɛ lɛ po, ꞊bo tɔɔ 'a mʋ 'na Bu? ");
INSERT INTO ted_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","꞊Be ꞊nɩ pui ꞊le ‑tɛɛ, ‑ɛ mɔ, 'n kɔ 'na Bu 'hɛɛn, ‑a ‑mʋɛ nɩ, ‑a 'we ꞊nɔ nahuoon ‑do ye? ‑Tɩ ꞊nʋ, 'nɩɩ a 'bii ye ꞊tu, ɩ 'de 'na ‑gbɛ a 'lu a lɛ‑hielɛ, kɛɛ, 'na Bu a 'lu a lɛ‑hielɛ'ɛ nɩ. Nɔ‑ nɩ 'le 'mʋ ke 'mʋ, 'ɔɔ 'le 'mʋ 'mʋ naa, 'ɔɔ ‑kʋan nu. ");
INSERT INTO ted_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","‑Tɩ ‑gbo, 'nɩɩ ꞊tu, ‑ɛ mɔ, 'n kɔ 'na Bu 'hɛɛn, ‑a ‑mʋɛ nɩ, ‑a 'we ꞊nɔ nahuoon ‑do ye, ba pui ‑tɛɛ. 'Na pupowin, 'bɩ 'die 'le ‑wɛ bɩ nue, ba po ‑tɩ a ‑gbɛ ‑tɛɛ, ‑ye 'na nunu‑tɔplɩ, nɩ‑ ‑bɩ nue, ba pui ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","'Nɩɩ 'a mʋ 'nɩ le, nahuon 'bɔ nɩ 'o, 'bɔ kuo 'mʋ ꞊wlʋ ye, ‑ye nunu‑tɔplɩ ‑gbo, 'nɩɩ nu, ɔ di ‑wɛ 'nɩ nu. 'Plɩɩ ‑ye, nunu‑tɔplɩ ꞊nʋ, ɔ di nu, ɩ di 'o 'n nɩnɩ 'mʋ 'nɩ ‑hi 'dɔ, ‑ɛ nue, 'ke 'nɩɩ 'le 'na Bu ‑wɔn mu, ‑ɛ die nu, ɔ 'mʋ 'na nahuin ꞊nʋ 'klɩ ‑nyi, 'ke bʋ nu 'a ‑kʋan. ");
INSERT INTO ted_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","‑Tɔplɩ 'bii ꞊nʋ, a di ‑hʋa, 'ke 'le 'na 'dʋ 'kwli 'mʋ, 'n di 'nɩ nu, ‑ɛ die nu, 'mɔ ‑gbo, ‑ɔ mɔ Nyɩsʋa a 'Yu, 'mʋ nahuin 'na Bu a ‑tɩ a 'yi'bʋbʋa tɔɔ. ");
INSERT INTO ted_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","'Bɩa 'baa dɛ ‑hʋa, 'ke 'le 'na 'dʋ 'kwli 'mʋ, 'n die 'nɩ nu.» ");
INSERT INTO ted_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‑Ye kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ: «'Bɩa 'ba nʋɛ 'mʋ 'mʋ, a di 'o 'na tetei 'nɩ ꞊tuu. ");
INSERT INTO ted_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ti ꞊nʋ ‑kɔ 'yri 'n di 'le 'n Bu Nyɩsʋa ‑wɔn mu, 'n dio lɛ 'nɩ 'batɩ, 'ke bɔ ya 'a mʋ nahuon ‑ye ye, 'ke 'o 'na ‑ta 'mʋ. Nahuon a ‑gbɛ, nɔ‑ mɔ Nyɩsʋa a ‑Hihiu, ‑ʋʋ ‑tɩ a ‑tɛɛ ꞊tu. Nʋ‑ di 'a mʋ 'mʋ ‑hɛ, ʋ 'mʋ 'o 'a mʋ ke 'mʋ nɩ ti a pɛpɛ. ");
INSERT INTO ted_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","'Klɔ ke a nahuin, ‑ʋ 'de Nyɩsʋa yi, ‑Hihiu a ‑gbɛ, ʋ 'deɛ bʋ nɩ 'o ꞊nʋ ke 'mʋ, ‑ɛ nue, nahuin a ‑gbɛ, ʋ 'dɩɛ bʋ yruu, 'plɩɩ ʋ 'nɩ ꞊mʋɛ ꞊le lɛ, 'ke bʋ yiu. A ‑mɛ ‑ye, a yi Nyɩsʋa a ‑Hihiu a ‑gbɛ nɩ, ‑ɛ nue, Nyɩsʋa a ‑Hihiu a ‑gbɛ, 'ke ʋ nɩ 'le 'a mʋ ‑gbahlɔn, kɔ, ʋ 'mʋ 'o ‑tado 'a mʋ ke 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","'N 'deɛ ꞊bo hie 'o 'a mʋ gbo, ba 'ya ‑do 'mʋ. Kɛɛ, 'nɩ mu, 'n di 'le lele 'nɩ di, kɛ nɔ 'a mʋ ‑gbahlɔn. ");
INSERT INTO ted_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ti ꞊de 'de 'le hie, 'klɔ ke a nahuin 'mʋ 'na 'yiye 'kee. Kɛɛ, a ‑mɛ ‑ye, a di 'mʋ 'nɩ 'ye, ‑ɛ nue, 'n nɩ 'klɔ, 'a nɩ ‑gbɛ, 'a di ‑wɛ 'klɔ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","‑Nyrɔwɔ a ‑gbɛ 'bɔ nyre 'o, ‑ye a die 'mʋ lɛ 'nɩ yrii, ‑ɛ mɔ, 'n kɔ 'na Bu 'hɛɛn, ‑a ‑mʋɛ nɩ, ‑a mʋ mɔ ‑tʋnahuoon ‑do, kɔ, a kɔ 'mʋ 'hɛɛn, ‑a ‑mʋɛ ‑wɛ nɩ, ‑a mʋ mɔ ‑tʋnahuoon ‑do. ");
INSERT INTO ted_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Nahuon 'bɔ nɩ 'o, 'bɔ 'ble 'na tetei kwa, kɔ, 'bɔ nyi 'o ꞊tuu, nahuon a ‑gbɛ, nɔ‑ɔ nɩ, ‑ɔ nʋɛ 'mʋ 'mʋ. Nahuon ꞊nʋ, ‑ɔ nʋɛ 'mʋ 'mʋ, 'na Bu dio ‑wɛ 'mʋ 'nɩ nʋɛ. 'Na ‑gbɛ, 'n dio ‑wɛ 'mʋ 'nɩ nʋɛ, 'plɩɩ 'mue nu, ɔ 'mʋ 'mʋ yrii.» ");
INSERT INTO ted_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","‑Ye Judɩa, kɛɛ, ɛ 'de Judɩa Yisikalio, kɛ ɔɔ ꞊nɔ ye po, ɔ nɔ: «Kʋkɔnyɔ o, ‑be' ‑n nu 'klɛɛ, ꞊nɩɩ lɛ po, ‑ɛ mɔ, ꞊mue nu, ‑a 'mʋ ‑mʋ yrii, kɛɛ, ‑n 'deɛ ‑bo nue, 'ke 'klɔ ke a nahuin bʋ yrii ‑mʋ?» ");
INSERT INTO ted_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","‑Ye ‑Yusu ꞊tuo ‑wɔn, ɔ nɔ: «Nahuon 'bɔ nɩ 'o, 'bɔ nʋɛ 'mʋ 'mʋ, kɔ, ‑tɩ ꞊nʋ, 'n di ꞊nɔ ye ꞊tu, 'bɔ nyi 'o ꞊tuu, 'n die 'nɩ nu, nahuon a ‑gbɛ, ɔ 'mʋ 'mʋ yrii. ‑Ye 'na Bu dio 'mʋ 'nɩ nʋɛ, 'plɩɩ 'na Bu a ‑gbɛ, ɔ kɔ 'mʋ 'hɛɛn, ‑a 'mʋ 'le ꞊nɔ ‑wɔn mu, ‑a 'muo 'le ‑wɔn nɩ. ");
INSERT INTO ted_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Nahuon, 'bɔ nɩ 'o, 'bɔ 'de 'mʋ 'mʋ nʋɛ, ɔ 'nɩ ꞊tuu ꞊le 'o 'na wintɛ nɩ. ‑Tɩ ‑gbo, 'nɩɩ 'klɛɛ 'a mʋ ye ꞊tu, aa 'wɔn, ɛ 'de 'na ‑gbɛgbɛ a wlɔn a win, kɛɛ, 'na Bu Nyɩsʋa, nɔ‑ le 'mʋ, ꞊bo ꞊tui 'a mʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‑Tɛ 'n 'kɩɛ nɩɛ mɔ 'a mʋ 'hʋɩn 'mʋ, 'n nyi 'a mʋ ye 'nɩ ꞊tu ‑dodo. ");
INSERT INTO ted_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","'Na Bu Nyɩsʋa, nɔ‑ di 'a mʋ 'a ‑Hihiu ye ya, 'ke 'le 'na 'dʋ 'kwli 'mʋ. 'A ‑Hihiu a ‑gbɛ, nʋ‑ di 'a mʋ ‑tɔplɩ 'bii tɔɔ, kɔ, ‑tɩ 'bii ꞊nʋ, 'n ꞊tu 'a mʋ ye, ʋ 'mui 'le 'a mʋ 'kwli 'mʋ lɛ po. ");
INSERT INTO ted_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","'N die 'nɩ nu, a 'mʋ plɔ a bleelɛ kɔ. Plɔ a bleelɛdʋ ꞊nʋ, 'n kɔ, nɛ‑ 'n di 'a mʋ ‑nyi. Plɔ a bleelɛdʋ ꞊nʋ, 'klɔ ke a nahuin, ʋʋ 'waa 'bienʋ ‑nyi, ɛ 'de ꞊nɛ, 'nɩ ‑nye ꞊le 'a mʋ. 'A ‑tɩ o, a nɩ pɩ 'le hʋannʋ, kɔ, 'a nɩ ꞊wlɩ nɩ bi 'le ꞊hlɔn. ");
INSERT INTO ted_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","A 'wɩn nɩ, ‑tɛ 'n ꞊tui 'a mʋ ye, ‑ɛ mɔ: 'Nɩɩ 'klɛɛ 'nɩ mu, kɛɛ, 'n di 'le lele 'nɩ di, kɛ nɔ 'a mʋ ‑gbahlɔn. 'Bɩa 'ba nʋɛ wɛn 'mʋ 'mʋ, ‑ye a di wɛn nu 'manʋ, ‑ɛ nue, 'ke 'nɩɩ 'le 'na Bu ‑wɔn mu. 'Na Bu, nɔ‑ nɩ 'o 'mʋ 'lu ye. ");
INSERT INTO ted_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","‑Tɔplɩ 'bii ‑gbo, 'n nyi 'a mʋ ye 'nɩ ꞊tu ‑dodo, 'plɩɩ ɩ 'mʋ 'lu ‑wɔn mue. 'Bɩa 'bɩɩ 'lu ‑wɔn mue, ‑ye ɩ di 'le 'a mʋ 'mʋ bi 'kwli, a 'mʋ 'mʋ ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","'Dai ti ꞊de 'de 'le hie, 'ke ꞊bo 'prɛɛ 'le 'a mʋ ‑wɔn, ‑ɛ nue, 'klɔ ‑gbo a nyɩgblaka Satan, ɔɔ 'le 'nɩ di. ꞊Hapʋkɔ, 'ɔ 'de 'klɩ kɔ, 'ke 'o 'mʋ ke, ");
INSERT INTO ted_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kɛɛ, 'klɔ ke a nahuin blɛ ye bʋ yree, ‑ɛ mɔ, 'n nʋɛ 'n Bu Nyɩsʋa 'mʋ nɩ. Nɛ‑ nue, dɛ ꞊nʋ, 'n Bu le 'mʋ, ꞊bo nu, 'nɩ die nu. 'A ‑tɩ o, ba 'ba ye 'mʋ, ‑a 'mʋ mu.» ");
INSERT INTO ted_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Kɛ ‑Yusuu lele 'a ‑naagbopʋ ye po, ɔ nɔ: «'Mɔ ‑gbo, 'n 'we ꞊nɔ ꞊hapʋ'dɩdɔtugbɛ ye, 'a mʋ ꞊nʋ, ‑ʋ mɔ 'na nahuin, 'a 'we ꞊nɔ 'dɩdɔtugbɛ a babʋɩ ye, 'na Bu Nyɩsʋa, nɔ‑ mɔ tugbɛ a 'dɩdɔnyɔ. ");
INSERT INTO ted_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","'Ɛ nɩ babʋ ꞊de 'bʋ nɩ 'o, 'bʋ 'nɩnɩ tʋ 'yɔ, ‑ye 'dɩdɔnyɔ a ‑gbɛ, ɔ nyu 'o 'nɩ 'bɛ, kɔ, 'ɛ nɩ babʋ ꞊de 'bʋ nɩ ‑wɛ 'o, 'bʋʋ 'yɔ tʋ, ɔ nyu 'le lɛ 'nɩ 'bɛ, ‑ɛ die nu, ʋ 'mʋ 'o ye 'sii, ʋ 'mʋ lele 'yɔ 'plɔplɔ ‑ye tʋ. ");
INSERT INTO ted_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","A ‑mɛ ‑ye, ‑tɩ ꞊nʋ, 'n tɔɔ 'a mʋ, ɩ nue nɩ, 'a 'sii 'o ye. ");
INSERT INTO ted_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ba 'kɩɛ kʋɛɛ 'le 'mʋ 'mʋ gbo, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'n nu, 'n kɔ 'a mʋ 'hɛɛn, ꞊a ‑mʋɛ. Babʋ ꞊nʋ, 'bʋ 'de 'le tugbɛ 'mʋ gbo kʋɛ, ʋ 'die 'le ‑wɛ bʋ tʋ 'yɔ. Kɛ'ɛ nɩ, ɛ ‑ti 'mʋ, 'ke 'o 'a mʋ ‑wɔn. 'Bɩa 'ba 'de 'le 'mʋ 'mʋ gbo kʋɛ, a 'die 'le ‑wɛ ba nu 'na ‑kʋan. ");
INSERT INTO ted_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","'Mɔ mɔ tugbɛ, 'a mʋ mɔ 'a babʋɩ. Nahuon 'bɔ nɩ 'o, 'bɔ kʋɛ 'le 'mʋ 'mʋ gbo, 'plɩɩ ɔ kɔ 'mʋ 'hɛɛn, ꞊ba ‑mʋɛ, ‑ye ɔ 'we ꞊nɔ babʋ ꞊nʋ ye, ‑ʋʋ 'yɔ 'plɔplɔ tʋ, ‑ɛ ꞊hɛn 'nyrɛ, nahuon ꞊nʋ, ‑ɔɔ 'na ‑kʋan nu ‑tɛɛ. 'Bɩa 'ba 'de 'le 'mʋ 'mʋ gbo kʋɛ, ‑ye a 'die 'le ‑wɛ ba nu dɛ ꞊de. ");
INSERT INTO ted_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nahuon 'bɔ nɩ 'o, 'bɔ 'de 'le 'mʋ 'mʋ gbo kʋɛ, ‑ye Nyɩsʋa dio 'mʋ po 'kwla, ‑ɛ 'we ꞊nɔ tibabʋɩ ꞊nʋ ye, ʋ 'bɛ 'o lɛ, 'plɩɩ ʋ po 'kwla 'mʋ. 'Bɩ ma, ‑ye ʋ nye lɛ 'nɩ 'kukue, ʋ 'mui 'tɔ lɛ po. ");
INSERT INTO ted_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","'Bɩa 'ba kʋɛ 'le 'mʋ 'mʋ gbo, kɔ, 'ba 'ble 'na tɔɔwin kwa, 'ke 'le 'a nɩ ꞊wlɩ ke, ‑ye ba ‑hʋa Nyɩsʋa 'ɛ nɩ dɛ ꞊de, ɔ die 'a mʋ 'nɩ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","'Bɩa 'ba 'cipi 'o 'na ‑kʋan a nunue ‑tɛɛ, ‑ye a die nahuin 'nɩ tɔɔ, ‑ɛ mɔ, 'a mʋ mɔ 'na ‑naagbopʋʋ nɩ. Dɛ a ‑gbɛ, nɛ‑ die nu, nahuin, ʋ 'mʋ 'na Bu Nyɩsʋa ‑tɩ a 'yi'bʋaalɛ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","'N nʋɛ 'a mʋ 'mʋ nɩ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'na Bu Nyɩsʋa nu, 'ɔ nʋɛ 'mʋ 'mʋ. Ba 'kɩɛ kʋɛɛ 'le 'mʋ 'mʋ gbo, ‑ɛ die nu, a 'mue yi, ‑ɛ mɔ, 'n nʋɛ 'a mʋ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","'Bɩa 'baa 'o 'na tetei 'o ꞊tuu, ‑ye a die 'nɩ yi 'ɛ nɩ ti, ‑ɛ mɔ, 'n nʋɛ 'a mʋ 'mʋ nɩ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'n nu, 'nɩ ꞊tuu 'o 'na Bu Nyɩsʋa a tetei 'o, 'nɩ yie 'ɛ nɩ ti, ‑ɛ mɔ, ɔ nʋɛ 'mʋ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‑Tɩ 'bii ‑gbo, 'n nyi 'a mʋ ye 'nɩ ꞊tu, ‑ɛ die nu, ‑tɛ 'nɩɩ 'manʋ a nunue nu, a 'mʋ ‑wɛ lɛ nu, kɔ, 'a nɩ 'manʋ a ‑gbɛ, ʋ 'mʋ 'o ye ꞊cɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ba 'ye kɛ, ‑tɩ ꞊nʋ, 'nɩɩ 'a mʋ ye ꞊tu, nɩ‑ ‑gbo: Ba nʋnʋɛ 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'n nu, 'nɩ nʋɛ 'a mʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","'Mʋnʋɛlɛ gblaka, ‑ɛ ‑hi 'o 'mʋnʋɛlɛi 'bii 'mʋ, nɛ‑ mɔ, nahuon 'bɔ ‑ha 'a ‑hʋnhlʋn, 'ke 'o 'a 'bienʋ a waalɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","‑Tɩ ꞊nʋ, 'nɩɩ 'a mʋ ye ꞊tu, 'ba nyi nu, ‑ye 'a mʋ mɔ 'na nɩnatumupʋʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","'Nɩ daa ꞊le 'klɛɛ lele 'a mʋ ‑kʋannunyʋ, ‑ɛ nue, dɛ ꞊nʋ, ‑kʋannunyɔ a 'masɛ, ɔɔ nu, ‑kʋannunyɔ a ‑gbɛ, ɔ 'die yi. 'Nɩɩ 'a mʋ daa 'na nɩnatumupʋ. A yi dɛ a ‑gbɛ nɩ, ‑ɛ nue, ‑tɩ 'bii ꞊nʋ, 'na Bu Nyɩsʋa tɔɔ 'mʋ, 'n tʋɩ ‑wɛ 'a mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ɛ 'de 'a mʋ, a 'de 'le 'mʋ du 'mʋ ‑ha, 'ke ꞊bo 'ya 'a nɩ Kʋkɔnyɔ 'mʋ. Kɛɛ, 'mɔɔ nɩ, ‑ɔ ‑ha 'le 'a mʋ du 'mʋ, 'ke ba kʋɛ 'mʋ ‑wɔn, 'nɩ le ‑wɛ 'a mʋ, 'ke ba mu 'na ‑kʋan nu. ‑Kʋan ꞊nʋ, a di nu, ɔ 'deɛ bɔ 'ya ‑gbʋgbɛ 'mʋ. 'Ɛ nɩ dɛ, a di 'na Bu Nyɩsʋa ‑hʋa, 'ke 'le 'na 'dʋ 'kwli 'mʋ, ɔ die 'a mʋ 'nɩ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","'A ‑tɩ o, dɛ ꞊nʋ, 'nɩɩ 'a mʋ ‑hʋa, nɛ‑ mɔ: Ba nʋnʋɛ 'mʋ!» ");
INSERT INTO ted_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Kɛ ‑Yusuu lele po, ɔ nɔ: «'Klɔ ke a nahuin 'bʋ yraa 'a mʋ, ba kɔ 'a yiyie, ‑ɛ mɔ, 'mɔ mɔ ye‑hɛnahuon, ʋ yraa, 'plɩɩ 'ʋ yraa 'a mʋ. ");
INSERT INTO ted_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","'Bɩa 'ba 'ya wɛn 'klɔ ke a nahuin 'mʋ, ‑ye 'klɔ ke a nahuin, ʋ di wɛn 'a mʋ 'mʋ 'nɩ nʋɛ, ‑ɛ nue, 'ke a di wɛn 'le ꞊nʋ ‑hɛyri nɩ. Kɛɛ, ɛ 'de lɛ 'mʋ nɩ. 'Na ‑gbɛ, 'mɔ ‑ha 'le 'a mʋ 'klɔ ke a nahuin ‑hɛyri, 'nɩ po 'a mʋ 'pɩa ke. A 'de 'klɛɛ lele 'le ꞊nʋ ‑hɛyri nɩ. Nɛ‑ nue, 'ʋ yraa 'a mʋ. ");
INSERT INTO ted_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","‑Tɩ ‑gbo, 'n ꞊tu o 'a mʋ ye, ɩ nɩ ‑hri 'le 'a mʋ ‑wɔn, ‑ɛ mɔ: ‑Kʋannunyɔ ꞊de 'de 'o 'a 'masɛ 'lu ye nɩ. Ɛ ꞊hɛn 'nyrɛ, nahuin ꞊nʋ, ‑ʋ ꞊tue 'mʋ ꞊sʋɛ, ʋ di ‑wɛ 'a mʋ ꞊tue ꞊sʋɛ. Nahuin ꞊nʋ, ‑ʋʋ 'o 'na tɔɔwin 'o ꞊tuu, ʋ di ‑wɛ 'o 'a nɩ tɔɔwin 'o 'nɩ ꞊tuu. ");
INSERT INTO ted_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","꞊Sʋɛ 'bii ꞊nʋ, ʋ di 'a mʋ ꞊tue, ʋ die 'a mʋ 'nɩ ꞊tue, ‑ɛ nue, 'a mʋ mɔ 'na ‑naagbopʋʋ nɩ, 'plɩɩ 'na Bu, ‑ɔ lee nɔ 'mʋ 'klɔ ke, ʋ 'dio yi. ");
INSERT INTO ted_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","'Bɩa 'nɩ 'de wɛn 'le di, kɔ, 'nɩ 'de wɛn ꞊nʋ Nyɩsʋa a ‑tɩ ye ꞊tu, Nyɩsʋa 'deɛ bɔ yɛɛ wɛn ꞊nʋ ‑tɩ, 'ke 'o 'waa dɛ 'kuku ꞊nʋ, ʋ nu a ‑ta 'mʋ. Kɛɛ, ‑tɛ 'n di 'klɛɛ 'le, 'n ꞊tu ꞊nʋ Nyɩsʋa a ‑tɩ ye, 'bɩa 'bʋ 'kɩɛ nue dɛ 'kuku, ‑ye ʋ 'deɛ bʋ kɔ 'hru, 'ke bʋ ꞊ta 'le Nyɩsʋa kwa 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nahuon ‑gbo, ‑ɔ yraa 'mʋ, ɔ yraa ‑wɛ 'na Bu nɩ. ");
INSERT INTO ted_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","'Bɩa 'nɩ 'de wɛn 'le ꞊nʋ ‑hɛyri 'ŋmilɛka‑tɔplɩ nuu, nahuon ꞊de 'de ‑hlɩn a nue, ‑ye Nyɩsʋa 'deɛ bɔ yɛɛ wɛn ꞊nʋ ‑tɩ, 'ke 'o 'waa dɛ 'kuku ꞊nʋ, ʋ nu a ‑ta 'mʋ. Kɛɛ 'klɛɛ, ʋ 'ye 'ŋmilɛka‑tɔplɩ ꞊nʋ nɩ, 'n nu, 'plɩɩ 'n kɔ 'na Bu 'hɛɛn, 'ʋ yraa ‑a mʋ. ");
INSERT INTO ted_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kɛɛ, ‑tɔplɩ a ‑gbɛ, ɩɩ ‑wɔn mue 'lu, ‑ɛ die nu, dɛ ꞊nʋ, 'waa bunʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ɛ 'mʋ nue. Dɛ a ‑gbɛ, nɛ‑ ‑gbo: ꞊Betɩ ꞊bo 'de dɛ ꞊de nu, ʋ yraa 'mʋ nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kɛ ‑Yusuu lele ꞊nʋ ye po, ɔ nɔ: «Nahuon ꞊nʋ, ‑ɔ di 'a mʋ 'mʋ ‑hɛ, ɔ di 'le 'nɩ di. 'Ke ɔ di 'le 'na Bu ‑wɔn 'mʋ ‑hɔn. 'Bɩa 'nɩ mu 'le 'na Bu ‑wɔn, 'n di 'a mʋ nahuon a ‑gbɛ ye 'nɩ ya. Nahuon a ‑gbɛ, nɔ‑ mɔ Nyɩsʋa a ‑Hihiu. Nʋ‑ di nahuin ‑tɩ a ‑tɛɛ tɔɔ. 'Bɩa 'bʋ di 'le, ʋ di 'nɩ ꞊tu, nahuon a gblo tio‑ 'n 'ya 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","A ‑mɛ ‑ye, a di ‑wɛ 'nɩ ꞊tu, nahuon a gblo tio‑ 'n 'ya 'mʋ, ‑ɛ nue, kʋɛ la 'le 'na ‑kʋan a ‑wlu꞊tuulɛ 'yie 'mʋ gbo, a kɔ 'mʋ 'hɛɛn, ‑a 'kɩɛ nɩnɩɛ 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‑Tɩ a ‑gbɛ, 'n nyi 'a mʋ ye 'nɩ ꞊tu, ‑ɛ die nu, ꞊sʋɛ a 'yiyeti a ‑gbɛ 'bɩ nyre 'o, a 'nɩ ꞊han 'na ꞊wlʋ a yekuolɛ 'kee. ");
INSERT INTO ted_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ʋ di 'a mʋ lɛ 'nɩ bla, 'ke 'le Nyɩsʋa a kayuo gbo. Ti di ‑wɛ 'o 'nɩ nyre, ‑ɩ kɔ 'yri nahuin ꞊nʋ, ‑ʋ di 'a mʋ lɛ 'lɩla, ʋ 'mui ꞊tu, ‑ɛ mɔ, Nyɩsʋa a ‑kʋaan nɩ, ʋʋ nu. ");
INSERT INTO ted_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kɛ'ɛ nɩ, ʋ di 'a nunue nu, ‑ɛ nue, ʋ 'de 'na Bu yi, 'ʋ 'de ‑wɛ 'mʋ yi. ");
INSERT INTO ted_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kɛɛ, ‑tɩ a ‑gbɛ, 'n nyi 'a mʋ ye 'nɩ ꞊tu, ‑ɛ die nu, ti ꞊nʋ ‑kɔ 'yri ʋ di ‑tɔplɩ a ‑gbɛ nu, ɩ 'mʋ 'le 'a mʋ 'kwli 'mʋ bi, ‑ɛ mɔ, 'n ꞊tui 'a mʋ ye nɩ.» «Kʋɛ la 'le gbo, 'n 'de la 'a mʋ ‑tɩ a ‑gbɛ le, ‑ɛ nue, 'ke 'n nɩ la 'le 'a mʋ ‑gbahlɔn. ");
INSERT INTO ted_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, 'nɩɩ 'nɩ mu, 'ke 'o nahuon ꞊nʋ 'hʋɩn 'mʋ, ‑ɔ lee nɔ 'mʋ ‑tʋtʋ ke, 'plɩɩ ‑ye 'ke 'le 'a mʋ ‑hɛyri, ꞊ɔ ꞊de 'nɩ ꞊gba ꞊le 'mʋ wlɔn, ‑ɛ mɔ: ‑Be' ‑nɩɩ ye mue 'le? ");
INSERT INTO ted_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","'A nɩ ꞊wlɩ 'mʋɛ gbo, ‑ɛ nue, 'n le 'a mʋ nɩ, ‑ɛ mɔ, 'n di 'nɩ mu. ");
INSERT INTO ted_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kɛɛ, ba pui ‑tɛɛ, ɛ nɔɔ 'o lɛ, 'ke 'o 'a mʋ ‑wɔn, 'ke ꞊bo mu, ‑ɛ nue, 'bɩa 'nɩ 'de mu, ‑ye nahuon ꞊nʋ, ‑ɔ di 'a mʋ 'mʋ ‑hɛ, ‑ɔ mɔ Nyɩsʋa a ‑Hihiu, ɔ 'deɛ bɔ di nɔ 'a mʋ ‑wɔn. Kɛɛ, 'bɩa 'nɩ mu, 'n dio 'a mʋ ye 'nɩ ya. ");
INSERT INTO ted_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","'Bɩa 'bɔ di 'le, ɔ die 'klɔ ke a nahuin 'nɩ tɔɔ, ‑ɛ mɔ, ʋʋ nu dɛ 'kuku, 'plɩɩ ɔ 'mʋ ‑wɛ ꞊nʋ 'hru ꞊nʋ tɔɔ, ‑ʋ 'sii 'o ye, kɔ ‑bati ꞊nʋ, Nyɩsʋa di po. ");
INSERT INTO ted_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Dɛ 'kuku ꞊nʋ, ɔ di nahuin tɔɔ, nɛ‑ mɔ bʋ 'de 'mʋ ꞊wlʋ ye kuo. ");
INSERT INTO ted_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ʋ die 'nɩ 'ye, ‑ɛ mɔ, 'na 'hru, nʋ‑ 'sii 'o ye, ‑ɛ nue, 'ke 'nɩɩ 'le 'na Bu ‑wɔn mu, 'plɩɩ a 'deɛ ba 'ye 'klɛɛ lele 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","'Ya 'o lele 'lu, ‑bati ꞊nʋ, Nyɩsʋa di ꞊nʋ lɛ poo, nɩ‑ mɔ ‑bati ꞊nʋ, ‑ɩ klɩ 'klɔ ‑gbo a nyɩgblaka, ‑ɔ mɔ Satan. ");
INSERT INTO ted_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","'N kɔ lele ‑tɩ 'plɔplɔ ꞊bo ꞊tu wɛn 'a mʋ ye, kɛɛ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, a 'deɛ ba kɔ 'a 'mʋlɛyriilɛ, ‑ɛ nue, ɩ ‑hi 'a nɩ 'lu a lɛ‑hielɛ wlɔn. ");
INSERT INTO ted_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Nyɩsʋa a ‑Hihiu, ‑ʋʋ nahuin ‑tɩ a ‑tɛɛ ye ꞊tu, 'bʋ di 'le, ‑ye ʋ die 'nɩ nu, a 'mʋ ‑tɩ a ‑tɛɛ 'mʋ lɛ yrii 'bii. ‑Tɩ ꞊nʋ, ʋ di 'a mʋ ye ꞊tu, ɛ 'de 'a ‑gbɛgbɛ a wlɔn a win, kɛɛ, ‑tɩ 'bii ꞊nʋ, ʋ di 'wɔn, nɩ‑ ʋ di 'a mʋ ye ꞊tu, kɔ, ‑tɔplɩ ꞊nʋ, ‑ɩ di ‑hlɩn 'lu ‑wɔn mue, nɩ‑ ʋ di 'a mʋ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ʋ di nahuin 'na ‑tɩ a 'yi'bʋaalɛ 'nɩ tɔɔ, ‑ɛ nue, ‑tɩ ꞊nʋ, 'n di Nyɩsʋa a ‑Hihiu ye ꞊tu, nɩ‑ ʋ di 'wɔn, 'plɩɩ ʋ 'mui 'a mʋ ye ꞊tu. ");
INSERT INTO ted_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","‑Tɔplɩ 'bii, 'n Bu kɔ, 'mɔ kʋɩ ‑wɛ. Nɛ‑ kɔ ‑tɩ, 'nɩ ꞊tui, ‑tɩ ꞊nʋ, 'n di Nyɩsʋa a ‑Hihiu ye ꞊tu, nɩ‑ ʋ di 'wɔn, 'plɩɩ ʋ 'mui 'a mʋ ye ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«'Ke 'le ti gbi 'kwli 'mʋ, a 'deɛ ba 'ye 'klɛɛ lele 'mʋ, 'plɩɩ 'ke 'le ti gbi ‑ye 'kwli 'mʋ, a 'mʋ lele 'mʋ 'ye.» ");
INSERT INTO ted_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","‑Ye 'a ‑naagbopʋ ‑ye, 'ke 'le 'waa dɩɔnʋ ‑gbahlɔn, kɛ ʋʋ po, 'ʋʋ wlɔn lɛ ꞊gbʋgba: «Dɛ tio‑ dɛ a ‑gbɛ, ɛ ꞊hɛn 'nyrɛ 'le? Kɛ ɔ po ‑a mʋ ye: 'Ke 'le ti gbi 'kwli 'mʋ, a 'deɛ ba 'ye 'klɛɛ lele 'mʋ, 'plɩɩ 'ke 'le ti gbi ‑ye 'kwli 'mʋ, a 'mʋ lele 'mʋ 'ye. Dɛ‑ kɔ ‑tɩ 'ɔ po ‑wɛ lɛ, ‑ɛ mɔ: A 'deɛ ba 'ye 'mʋ, ‑ɛ nue, 'ke 'nɩɩ 'le 'n Bu ‑wɔn mu. ");
INSERT INTO ted_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ti gbi ꞊nʋ, ‑ɛ kɔ ‑tɩ ɔɔ ꞊tu, dɛ tio‑ ɛ ꞊hɛn 'nyrɛ 'le? ‑Tɩ ꞊nʋ, ɔɔ ꞊tu, ‑a 'nɩ yrii ꞊le 'mʋ lɛ.» ");
INSERT INTO ted_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","‑Ye ‑Yusu yree nɩ, ‑ɛ mɔ, ʋʋ ‑hʋa bʋ ꞊gbɔ wlɔn. Nɛ‑ mɔ bɔ lu, ɔ nɔ: «'N le 'a mʋ nɩ, ‑ɛ mɔ: 'Ke 'le ti gbi 'kwli 'mʋ, a 'deɛ ba 'ye 'klɛɛ lele 'mʋ, 'plɩɩ 'ke 'le ti gbi ‑ye 'kwli 'mʋ, a 'mʋ lele 'mʋ 'ye. ꞊Be dɛ a ‑gbɛ, nɛ‑ kɔ ke aa 'o wlɔn lɛ ꞊gbʋgbaa? ");
INSERT INTO ted_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","'Nɩɩ 'a mʋ 'nɩ le: A di 'nɩ we, kɔ, a 'mʋ wɔlɩ lɛ nu, kɛɛ, 'klɔ ke a nahuin, ʋ di nu 'manʋ. A ‑mɛ ‑ye, 'a nɩ ꞊wlɩ di gbo 'nɩ 'mʋɛ, kɛɛ, ti gbi 'bɩ muu 'o ye 'mʋ, ‑ye a di lele nu 'manʋ. ");
INSERT INTO ted_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","꞊Bo pue ‑ŋlanyrɔ a dɛ ye: ‑Ŋlanyrɔ 'bɔɔ mu ‑ŋla, ‑ye 'a ꞊wlʋ 'mʋɛ gbo, 'ke 'o ꞊sʋɛ ꞊nʋ, ɔ di 'ye a ‑ta 'mʋ. Kɛɛ, 'bɔ ‑ŋla, ‑ye 'a ꞊sʋɛ a 'yiye‑tɩ ꞊nʋ, ɩ ‑hri ꞊nɔ ‑wɔn. ‑Ye ɔɔ nu 'manʋ, ‑tɛ 'yu yrayrʋ nu, 'ɔ di nɔ 'klɔ ke. ");
INSERT INTO ted_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kɛ'ɛ nɩ, ɛ nɩ ‑wɛ 'mʋ, 'ke 'o 'a mʋ ‑wɔn. ‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, 'a nɩ ꞊wlɩ 'mʋɛ gbo, ꞊sʋɛ a 'yiye‑tɩ. Kɛɛ, 'n kɔ 'a mʋ 'hɛɛn, ‑a di lele 'nɩ 'yiye. 'Bɩa ꞊ba 'yiye, ‑ye a di nu 'manʋ, 'plɩɩ nahuon ꞊de 'deɛ bɔ nue, ba 'kee 'manʋ a ‑gbɛ a nunue. ");
INSERT INTO ted_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Ti a ‑gbɛ 'bɩ nyre 'o, ‑ye a 'deɛ ba ꞊gba 'klɛɛ lele 'mʋ wlɔn, ‑ɛ nue, a di ‑tɔplɩ 'bii a ‑gbɛ 'mʋ lɛ 'nɩ yrii. 'Nɩɩ 'a mʋ 'nɩ le ‑tɛɛ, ‑tɔplɩ 'bii ꞊nʋ, a di 'na Bu ‑hʋa, 'ke 'le 'na 'dʋ 'kwli 'mʋ, ɔ di 'a mʋ 'nɩ ‑nyi. ");
INSERT INTO ted_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kʋɛ la 'le gbo, ‑bo yɛ ti ‑gbo ke, a 'de wɛn 'na Bu dɛ ꞊de a ‑hʋɛ, 'ke 'le 'na 'dʋ 'kwli 'mʋ. 'Bɩa 'baa dɛ ‑hʋa, ‑ye ba ‑hʋɛ 'na Bu. Ɔ die 'a mʋ 'nɩ ‑nyi, ‑ɛ die nu, 'a nɩ 'manʋ 'mʋ 'o ye ꞊cɛɛ.» ");
INSERT INTO ted_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«‑Talʋdʋɩ 'kwli 'mʋ, 'n naa 'le, 'nɩ ꞊tu 'a mʋ ‑tɩ 'bii a ‑gbɛ ye. Ti di 'o 'nɩ nyre, ‑ɩ kɔ 'yri 'nɩnɩ di 'le 'a mʋ ‑wɔn 'prɛɛ, 'ke 'le ‑talʋdʋɩ 'kwli 'mʋ, kɛɛ, ‑tɔplɩ ꞊nʋ, ‑ɩ kʋɛ 'o 'na Bu ke gbo, 'n di 'a mʋ 'mʋ lɛ 'nɩ yrii ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ti a ‑gbɛ 'bɩ nyre 'o, a di 'na Bu ‑hʋa ‑tɔplɩ, 'ke 'le 'na 'dʋ 'kwli 'mʋ. 'Na ‑gbɛ, 'n 'deɛ ꞊bo ‑hʋɔ dɛ ꞊de, 'ke 'o 'a nɩ ‑ta 'mʋ, 'a nɩ ‑gbɛ, 'a mʋ die ꞊nɔ ‑hʋa, ");
INSERT INTO ted_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","‑ɛ nue, 'na Bu a ‑gbɛ, ɔ nʋɛ 'a mʋ 'mʋ nɩ. Ɔ nʋɛ 'a mʋ 'mʋ nɩ, ‑ɛ nue, a nʋɛ ‑wɛ 'mʋ 'mʋ nɩ, 'plɩɩ 'a kuo 'mʋ ꞊wlʋ ye, ‑ɛ mɔ, 'ke 'n ‑hɔn 'le Nyɩsʋa ‑wɔn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","'Ke 'n ‑hɔn 'le 'n Bu ‑wɔn 'mʋ, 'nɩ di nɔ 'klɔ ke. ‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, 'nɩɩ nɔ 'klɔ ke 'mʋ 'nɩ ‑hɔn, 'mʋ 'le 'na Bu ‑wɔn mu.» ");
INSERT INTO ted_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","‑Ye 'a ‑naagbopʋ ꞊tuo ‑wɔn, ʋ nɔ: «'Ye kɛ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'bɩa ꞊nɩɩ 'prɛ, ꞊nɩ nu ꞊le ‑talʋdʋɩ, ‑ye ‑a nyi 'mʋ lɛ 'nɩ yrii ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","‑A yie 'klɛɛ nɩ, ‑ɛ mɔ, ‑n yi ‑tɔplɩ 'bii nɩ. ꞊Betɩ nahuin bʋ 'de ‑mʋ wlɔn ꞊gba, dɛ ʋ di ‑mʋ wlɔn ꞊gba, ‑n yie nɩ ‑dodo. Nɛ‑ kɔ ‑tɩ, ꞊a yie, ‑ɛ mɔ, 'ke ‑n ‑hɔn 'le Nyɩsʋa ‑wɔn 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","‑Ye ‑Yusu ꞊tu ‑wɔn: «꞊Be a yie 'klɛɛ nɩ, ‑ɛ mɔ, 'ke 'n ‑hɔn 'le Nyɩsʋa ‑wɔn 'mʋ? ");
INSERT INTO ted_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","'A ‑tɩ 'klɛɛ, ti di 'o 'nɩ nyre, 'plɩɩ ti a ‑gbɛ 'ɩ nyre 'o ‑dodo, ‑ɩ kɔ 'yri a 'bii, a di lɛ ‑gbɛ, 'ɛ nɩ nahuon 'bɔ nɩ 'o, ɔ 'mʋ 'le 'a kayu gbo mu, a 'mʋ mɔ 'n ‑do gbo hie. Kɛɛ, 'n 'deɛ ꞊bo 'ya ‑do 'mʋ, ‑ɛ nue, kɛ 'n Bu nɩ mɔ 'mʋ 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","'N ꞊tu 'a mʋ ‑tɩ 'bii a ‑gbɛ ye nɩ, ‑ɛ die nu, 'a mʋ ꞊nʋ, ‑ʋ kɔ 'mʋ 'hɛɛn‑ ‑mʋɛ, a 'mʋ kegbowɛɛnlɛ kɔ. Kɛ nɔ 'klɔ ‑gbo ke, a di 'ye ꞊sʋɛ. Kɛɛ, 'a nɩ ꞊wlɩ nɩ bi 'le ꞊hlɔn, ‑ɛ nue, 'klɔ ‑gbo a 'klɩ, 'n ‑wɩ gbo.» ");
INSERT INTO ted_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","'Plɩɩ ‑Yusu 'mʋ 'klɛɛ mu ‑yrɛ, ‑ye ɔ 'ba 'mʋ ye 'a 'lu, 'ɔ ta 'le yakɔ 'mʋ lɛ, ɔ nɔ: «'Na Bu o, ti nyre 'o ꞊o. 'Mɔ ‑gbo, ‑ɔ mɔ ‑na 'Yu, nue, nahuin, ʋ 'mʋ 'na ‑tɩ a 'yi'bʋaalɛ 'ye, ‑ɛ die nu, 'mʋ ‑wɛ ꞊nʋ ‑na ‑tɩ a 'yi'bʋaalɛ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","‑N ‑nyi 'mʋ 'klɩ, 'ke 'o nahuin 'bii ke, ‑ɛ die nu, nahuin 'bii, ‑n ‑nyi 'mʋ, 'mʋ ꞊nʋ 'klɔ yrayrʋ ‑nyi, ‑ɔ 'nɩnɩ ‑wɛ 'le. ");
INSERT INTO ted_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","'Klɔ yrayrʋ a ‑gbɛ, nɔ‑ mɔ bʋ yi ‑mʋ, ‑mɔ ꞊nʋ, ‑ɔ mɔ ‑tɛɛ a Nyɩsʋaa ‑do, kɔ, bʋ yi ‑wɛ 'mʋ, ‑ɔ mɔ ‑Yusu 'Klɩsʋ, ‑n lee nɔ 'klɔ ke. ");
INSERT INTO ted_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","‑Tɛ 'n nɩ nɔ 'klɔ ke, 'n tɔɔ nahuin ‑na ‑tɩ a 'yi'bʋaalɛ nɩ. ‑Kʋan ꞊nʋ, ‑n ‑nyi o 'mʋ, ꞊bo nu, 'n ‑yrɔ 'lu. ");
INSERT INTO ted_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","‑Ye 'klɛɛ, 'na Bu o, wɛɛn ke, 'ke ꞊bo 'di 'le lele ‑mʋ 'hʋɩn 'mʋ, 'mʋ ‑tɩ a 'yi'bʋaalɛ kɔ. ‑Nye lele 'mʋ ‑tɩ a 'yi'bʋaalɛɛ ‑do ꞊nʋ, 'n kɔ la, ti ꞊nʋ ‑kɔ 'yri 'n nɩ la 'o ‑mʋ 'hʋɩn 'mʋ, 'plɩɩ 'klɔ 'mʋ mu nue. ");
INSERT INTO ted_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nahuin ꞊nʋ, ‑ʋ nɩ la 'le 'klɔ 'ka ‑hɛyri, ‑n ‑hɩʋ 'le ꞊le, ꞊nɩ ‑nyu 'mʋ, 'nɩ nue, nahuin a ‑gbɛ, 'ʋ yi ‑mʋ. ‑Mɔ kɔ nahuin a ‑gbɛ, ꞊nɩ ‑hɩʋ 'le, ꞊nɩ ‑nyu 'mʋ, 'ʋʋ 'o ‑na wintɛ 'o ꞊tuu. ");
INSERT INTO ted_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ʋ yie 'klɛɛ nɩ, ‑ɛ mɔ, 'ɛ nɩ dɛ, ‑n ‑nyi 'mʋ, 'ke ɛ ‑hɔn 'le ‑mʋ ‑wɔn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Win ‑gbo, ‑n ꞊tu 'mʋ wlɔn, nɩ‑ 'n tɔɔ ꞊nʋ, 'ʋ 'bli kwa ‑tɛɛ. Ʋ yrie nɩ, ‑ɛ mɔ, 'ke 'n ‑hɔn 'le ‑mʋ ‑wɔn 'mʋ, kɔ, 'ʋ yie ‑tɛɛ, ‑ɛ mɔ, ‑mɔɔ nɩ, ‑ɔ lee nɔ 'mʋ 'klɔ ke. ");
INSERT INTO ted_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nahuin a ‑gbɛ, nʋ‑ kɔ ‑tɩ 'nɩɩ ‑mʋ da. 'Nɩ da ꞊le ‑mʋ, 'ke 'o 'klɔ ke a nahuin ꞊nʋ, ‑ʋ 'de ‑mʋ yi a ‑ta 'mʋ. Kɛɛ, nahuin ‑gbo, ‑n ‑nyi 'mʋ, nʋ‑ kɔ ‑tɩ 'nɩɩ ‑mʋ da, ‑ɛ nue, ‑mɔ kʋ. ");
INSERT INTO ted_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","'Ɛ nɩ dɛ, 'n kɔ, ‑mɔ kʋɛ, mɔ, 'ɛ nɩ dɛ, ‑n kɔ, 'mɔ kʋɛ ‑wɛ, kɔ, 'ɛ nɩ nahuon, 'n kɔ, ‑mɔ kʋɔ, mɔ, 'ɛ nɩ nahuon, ‑n kɔ, 'mɔ kʋɔ ‑wɛ. Nʋ‑ nye nu, nahuin 'mʋ 'na ‑tɩ a 'yi'bʋaalɛ 'ye. ");
INSERT INTO ted_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ti ꞊de 'de 'le hie, 'mʋ nɔ 'klɔ ‑gbo ke 'mʋ ‑hɔn, 'mʋ 'le ‑mʋ ‑wɔn di. Kɛɛ, ʋ ‑mɛ ‑ye, kɛ ʋ 'kɩɛ die nɔ 'klɔ ‑gbo ke nɩ. 'Na Bu Nyɩsʋa, nu 'klɩ ꞊nʋ, ‑n ‑nyi 'mʋ, ꞊mu 'yie ꞊tu, ‑ɛ die nu, ʋ 'mʋ ‑mʋɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n kɔ 'mʋ 'hɛɛn ‑a nu, ꞊a ‑mʋɛ. ");
INSERT INTO ted_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ti 'bii ‑gbo, 'n ‑hi nɔ ꞊nʋ ‑hɛyri, 'n nyu o ꞊tu 'yie, 'ke 'le ‑na 'klɩ ꞊nʋ 'kwli 'mʋ, ‑n ‑nyi 'mʋ. 'N ꞊tu 'yie ‑tɛɛ, 'waa nahuoon ‑do ꞊de 'ɔ 'de 'wan, 'bɛ 'de nahuoon ‑do ꞊nʋ, ‑ɔ kɔ ‑tɩ ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ, ɔ di 'nɩ 'wan. ‑Ye ‑tɩ a ‑gbɛ, ʋ 'crɩɩ la, ɩ nue nɩ. ");
INSERT INTO ted_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Kɛɛ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'ke 'nɩɩ 'le ‑mʋ ‑wɔn di. ‑Tɩ 'bii ‑gbo, 'n nyi ꞊nʋ ye 'nɩ ꞊tu, ‑tɛ 'n 'kɩɛ nɩɛ nɔ ꞊nʋ ‑hɛyri, kɛ nɔ 'klɔ ‑gbo ke, ‑ɛ die nu, ‑tɛ 'nɩɩ 'manʋ a nunue nu, ʋ 'mʋ ‑wɛ lɛ 'manʋ a nunue nu, 'plɩɩ 'manʋ a ‑gbɛ, ʋ 'mʋ 'o ye ꞊cɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","'N tɔɔ ꞊nʋ ‑na win nɩ, kɛɛ, 'klɔ ke a nahuin yraa ꞊nʋ nɩ, ‑ɛ nue, 'na nahuin, ʋ 'de 'klɔ ke a nahuin, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'n nu, 'nɩ 'de 'klɔ ke a nahuon. ");
INSERT INTO ted_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","'Nɩ 'batɩ ꞊le ‑mʋ lɛ, 'ke ‑bo ‑hɩʋ nɔ 'klɔ ‑gbo ke, kɛɛ, 'nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, 'ke ‑bo ꞊tu 'yie, 'ke 'o 'kuo ‑hʋɩn a nyɩgblaka a ‑ta 'mʋ, ɔ 'nɩ ꞊hiun lɛ 'tʋ. ");
INSERT INTO ted_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ʋ 'de 'klɔ ke a nahuin, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'n nu, 'nɩ 'de 'klɔ ke a nahuon. ");
INSERT INTO ted_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Tɔɔ ꞊nʋ ‑tɩ a ‑tɛɛ, ‑ɛ die nu, ʋ 'mʋ ‑na nahuin 'mʋ 'ya 'bii. ‑Tɩ a ‑tɛɛ a ‑gbɛ, nɛ‑ mɔ ‑na wintɛ. ");
INSERT INTO ted_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","‑Tɛ ‑n nu, ꞊nɩ lee nɔ 'mʋ 'klɔ ‑gbo ke, kɛ'ɛ nɩ, 'n nu, 'nɩ lu ‑wɛ, 'ke bʋ bi 'klɔ ‑gbo ke, ʋ 'mʋ nahuin ‑na ꞊hapʋtitie pue. ");
INSERT INTO ted_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","'Nɩɩ 'n dɩɔnʋ 'nɩ ‑ha 'bii, 'mʋ ‑mʋ 'n dɩɔnʋ ‑nyi, 'ke 'o 'waa ‑ta 'mʋ, ‑ɛ die nu, 'waa ‑gbɛ, ʋ 'mʋ ‑na nahuin 'mʋ 'ya ‑tɛɛ. ");
INSERT INTO ted_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","'Nɩ da ꞊le ‑mʋʋ ‑do, 'ke 'o 'na nahuin ‑gbo a ‑ta 'mʋ. Kɛɛ, 'na nahuin ‑gbo, 'bʋ ꞊tu 'na ‑tɩ, nahuin ‑ye 'bʋ kuo ‑wɛ 'mʋ ꞊wlʋ ye, nʋ‑ kɔ ‑tɩ 'nɩɩ ‑wɛ ‑mʋ da. ");
INSERT INTO ted_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","'Nɩɩ ‑mʋ lɛ 'nɩ 'batɩ, 'ke ʋ 'bii bʋ ‑mʋɛ. 'Na Bu o, ‑tɛ ‑n kɔ 'mʋ 'hɛɛn, ‑a nu, ꞊a 'we ꞊nɔ nahuoon ‑do ye, nue, ʋ kɔ ‑a mʋ 'hɛɛn, ‑ba ‑mʋɛ ‑wɛ. Nue, bʋ ‑mʋɛ, ‑ɛ die nu, 'klɔ ke a nahuin ꞊nʋ, ‑ʋ 'de ‑mʋ yi, ʋ 'mui ‑tɛɛ pue, ‑ɛ mɔ, ‑mɔɔ nɩ, ‑ɔ lee nɔ 'mʋ 'klɔ ke. ");
INSERT INTO ted_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","‑Tɩ a 'yi'bʋaalɛ ꞊nʋ, ‑n ‑nyi 'mʋ, 'n ‑nye ꞊nʋ nɩ, ‑ɛ die nu, ʋ 'mʋ ‑mʋɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n kɔ 'mʋ 'hɛɛn, ‑a nu, ꞊a ‑mʋɛ, ");
INSERT INTO ted_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ɛ ꞊hɛn 'nyrɛ, ʋ kɔ 'mʋ 'hɛɛn, ‑a 'we ꞊nɔ nahuoon ‑do ye, 'plɩɩ ‑n kɔ 'mʋ 'hɛɛn, ‑a 'we ꞊nɔ nahuoon ‑do ye, ‑ɛ die nu, ʋ 'mʋ ‑mʋɛ 'bii, kɔ, 'klɔ ke a nahuin, ʋ 'mue yrii, ‑ɛ mɔ, ‑mɔɔ nɩ, ‑ɔ lee nɔ 'mʋ, 'plɩɩ ʋ 'mue ‑wɛ yrii, ‑ɛ mɔ, ‑n nʋʋ 'mʋ nɩ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n nu, ꞊nɩ nʋɛ 'mʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","'Na Bu o, ‑n ‑nyu 'mʋ nɩ. 'A ‑tɩ, 'n nye 'nɩ ‑hʋa, ‑tɛgbi 'n di 'o nɩ, ʋ kɔ 'mʋ 'hɛɛn, ‑ba nɩ ‑wɛ 'o, ‑ɛ die nu, ʋ 'mʋ 'na ‑tɩ a 'yi'bʋaalɛ 'ye. ‑Tɩ a 'yi'bʋaalɛ a ‑gbɛ, ‑n ‑nye la 'mʋ nɩ, ‑ɛ nue, 'plɩɩ 'klɔ, ɔ 'mʋ mu nue, ‑n nʋɛ la 'mʋ 'mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","'Na Bu o, ‑mɔ ꞊nʋ, ‑ɔ 'sii 'o ye, nahuin 'plɔplɔ, ‑ʋ nɩ nɔ 'klɔ ke, ʋ 'de ‑mʋ yi. Kɛɛ, 'mɛ ‑ye, 'n yi ‑mʋ nɩ, kɔ, nahuin ꞊nʋ, ‑ʋ yie, ‑ɛ mɔ, ‑mɔ lee nɔ 'mʋ 'klɔ ke, nahuin a ‑gbɛ, ʋ yi ‑wɛ ‑mʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","'N nue nɩ, 'ʋ yi ‑mʋ, kɔ, 'mue 'lu ‑wɔn gba, ʋ 'mʋ ‑mʋ yi ‑tɛɛ, ‑ɛ die nu, ʋ 'mʋ 'waa 'bienʋ 'mʋ nʋɛ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑n nu, ꞊nɩ nʋɛ 'mʋ 'mʋ, 'plɩɩ 'n kɔ ꞊nʋ 'hɛɛn, ‑a 'mʋ nahuoon ‑do ye 'we.» ");
INSERT INTO ted_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","‑Tɛ ‑Yusu ‑wɔ 'klɛɛ 'le Nyɩsʋa a ‑wɔn'prɛɛlɛ ‑wɔn, ‑ye ɔ kɔ 'a ‑naagbopʋ 'hɛɛn, ʋ 'ba 'mʋ ye, 'ʋ ꞊tɩ Jrusrɛdɩɔ 'mʋ. Kɛɛ, Judɩa, ‑ɔ mɔ ‑Yusu a ‑naagbopʋyu ‑ye, ɔ ‑do, nɔ‑ kɔ ꞊nʋ 'hɛɛn‑ 'de mu. 'Nɩhannʋ ꞊de nɩ 'o, 'a 'dʋ mɔ Sedrɔ. Nʋ‑ kɔ 'nike 'dɩdɔti a ‑ci ꞊de nɩ 'o. Nɛ‑ kɔ ke ʋ mu 'le. ");
INSERT INTO ted_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ʋ 'bii, 'ke ʋʋ o 'le lɛ 'ya. Nɛ‑ nue, Judɩa a ‑gbɛ 'ɔ yii 'o ‑tɛgbi a ‑gbɛ, ‑ye ɔ kɔ 'hru, 'ke bɔ po ‑Yusu 'a yraanyʋ kwa. ");
INSERT INTO ted_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","'Ke 'le 'dɩɔ 'mʋ, 'ke Romakʋɛ a tayie nɩ 'le, ɛ kɔ Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ 'hɛɛn. Nʋ‑ Judɩa po ye 'mʋ, 'ʋʋ ‑Yusu mu klɩ, 'ke 'le 'dɩdɔti a ‑ci a ‑gbɛ ke. Nahuin a ‑gbɛ, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ Falisi꞊tumu a nahuin 'hɛɛn, ‑ʋ mɔ ‑Juukʋɛ a 'blʋ a nahuin, nʋ‑ lu, 'plɩɩ 'blʋ a nahuin a ‑gbɛ, ‑ʋ luu 'le, ʋ kɔ ꞊nʋ 'hɛɛn, ʋ 'bii, nʋ‑ mu 'le ‑tɛgbi a ‑gbɛ. 'Sɔyuo a ‑gbɛ, ʋ 'ble kwa lɛ 'napɩi, kɔ ‑hrɩ kɔ ta‑wɔn‑tɔplɩ, 'ʋ mu. ");
INSERT INTO ted_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","‑Yusu, ɔ yi ‑tɔplɩ 'bii ꞊nʋ nɩ, ‑ɩ kɔ ‑bɩ nue ꞊nɔ. Nɛ‑ nue, 'ɔ 'yɩya 'o ꞊nʋ ye gbo, ɔ nɔ: «Nyɔ tio‑ aa lɛ ꞊mɔ 'le?» ");
INSERT INTO ted_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","‑Ye ʋ nɔ: «‑Aa lɛ ꞊mɔ Nasalɛtɩ 'mʋ a ‑Yusu.» ‑Ye ɔ nɔ: «'Mɔ nɩ gbo.» ‑Ye 'ke Judɩa 'kɩɛ nɩɛ 'le ‑Yusu a yraanyʋ ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","‑Yusu bɔ po 'klɛɛ lɛ: «'Mɔ nɩ gbo,» ‑ye tii ‑do a ti 'yri, ʋ duu ke ‑duuduu, 'ʋ bi ꞊hlɔn lɛ. ");
INSERT INTO ted_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","‑Ye ɔ ꞊gbʋ lele wlɔn, ɔ nɔ: «Nyɔ tio‑ aa 'klɛɛ lɛ ꞊mɔ 'le?» ‑Ye ʋ nɔ: «Nasalɛtɩ 'mʋ a ‑Yusu.» ");
INSERT INTO ted_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","‑Ye ɔ nɔ: «'Be 'n le wɛn 'a mʋ nɩ, ‑ɛ mɔ: 'Mɔ nɩ gbo mɔ. ‑Tɛ ɛ 'ya 'mɔ 'mʋ o, aa ‑hʋa ba klɩ o, a nɩ klɩ 'le 'na ‑naagbopʋ, ba ‑hɩʋ mɛ lɛ bʋ mu.» ‑Ye 'sɔyuo, ʋ ‑ha ‑Yusu a ‑naagbopʋ a ‑gbɛ lɛ mɛ. ");
INSERT INTO ted_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","‑Tɛ ɔ po lɛ, ‑ye dɛ ‑gbo, ɔ ꞊tu o ti ꞊de 'yri o, ɛ nue kɛ nɩ. Dɛ a ‑gbɛ, nɛ‑ ‑gbo: «'Na Bu Nyɩsʋa o, nahuin, ‑n nyi 'mʋ, 'n 'de 'a nahuoon ‑do ꞊de 'wan.» ");
INSERT INTO ted_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","'Ke 'le ‑Yusu a yraanyʋ ‑hɛyri, 'ke nahuon ꞊de nɩ 'le. 'A 'dʋ mɔ Malikusɩ. Ɔ mɔ Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑kʋannunyɔɔ nɩ. ‑Ye Simɔ Piɛlɩ, ‑ɔ mɔ ‑Yusu a ‑naagbopʋyu ‑ye, ‑ɔ nɩ 'o ‑Yusu 'hʋɩn 'mʋ, ɔ nu 'a ‑hɔtɩplie, 'ɔ 'bɛ 'o Malikusɩ a ‑gbɛ a diidɛnʋa. ");
INSERT INTO ted_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","‑Ye ‑Yusu nɔ: «Piɛlɩ o, po 'le ‑na ‑hɔtɩplie bɔ wlɔn. ꞊Be ‑n 'di yi, 'ke 'n kɔ ꞊bo ‑yra ꞊sʋɛ ‑gbo 'lu, Nyɩsʋaa ‑hʋa, ꞊bo 'ye?» ");
INSERT INTO ted_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","‑Ye tii ‑do a ti 'yri, nahuin ꞊nʋ, Judɩa gba, kɔ 'waa nyɩgblakɩ 'hɛɛn, ʋ klɩ ‑Yusu nɩ, 'ʋ mʋɔ, ");
INSERT INTO ted_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","'ʋ gbɔ 'dɩɔ 'mʋ. Ye‑hɛnahuon, ʋ gbɔ 'le ye, nɔ‑ mɔ ‑cɔhlʋnpinyʋ a nyɩgblaka. Nyɩbɛyu a ‑gbɛ, 'a 'dʋ mɔ Hanɩ. Nɔ‑ mɔ Kaifʋ a 'tɔ. Kaifʋ a ‑gbɛ, nɔ‑ mɔ 'yrʋ ꞊nʋ gbo ‑cɔhlʋnpinyʋ 'bii a nyɩgblaka. ");
INSERT INTO ted_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaifʋʋ ‑do a ‑gbɛ, nɔ‑ɔ nɩ, ‑ɔ po o ‑Juukʋɛ ꞊tɔ 'mʋ, 'ke 'o ti ꞊de ‑hi o a ti 'yri, ‑ɛ mɔ: «Ɛ nu ‑tɛɛ, 'ke nahuoon ‑do bɔ 'kʋ, 'ke 'o ‑a nɩ dakʋ 'bii a ‑ta 'mʋ, 'ɛ ‑hi 'o ‑a nɩ dakʋ 'bii a ‑gbɛ, bʋ 'kʋ.» ");
INSERT INTO ted_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Bʋʋ 'klɛɛ ‑Yusu gba, ‑ye Simɔ Piɛlɩ kɔ ‑Yusu a ‑naagbopʋyu ‑ye 'hɛɛn, ʋʋ ꞊nɔ ‑wɔn 'nɩ kʋɛ. ‑Naagbopʋyu ‑ye a ‑gbɛ, ‑cɔhlʋnpinyʋ a nyɩgblaka, ‑ɔ mɔ Hanɩ, ɔ yio nɩ. Nɛ‑ nue, ɔ kɔ ‑Yusu 'hɛɛn 'ʋ pa 'o ‑tɛgbii ‑do, 'ke 'le nyɩbɛyu a ‑gbɛ, ‑ɔ mɔ Hanɩ a ‑yaa 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kɛɛ, Piɛlɩ ‑mɛ ‑ye, 'ke ɔ hree 'o ‑yaa a ‑gbɛ a 'maju 'yri. ‑Naagbopʋyu ꞊nʋ, ‑cɔhlʋnpinyʋ a nyɩgblaka yi, nɔ‑ 'prɛɛ 'le 'yu nyrɔyu ꞊nʋ ‑wɔn, ‑ɔɔ 'maju 'yie ꞊tu, 'ɔ paa Piɛlɩ. ");
INSERT INTO ted_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Bɔ pa 'klɛɛ, ‑ye 'yu nyrɔyu a ‑gbɛ, ɔ le Piɛlɩ nɩ, ɔ nɔ: «'Be ‑mɔ mɔ ‑wɛ ‑Yusu a ‑naagbopʋyu ‑yee nɩ 'a.» ‑Ye ɔ nɔ: «Gbe, 'n 'diu 'le ‑hɛyri nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Cɛ bɛɛ 'klɛɛ ꞊tɩ, ‑ye ‑kʋannunyʋ ꞊nʋ, ʋ kɔ Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ 'hɛɛn, ‑ʋ nɩ 'o, ʋ 'tie na, 'ʋ nyo 'wɛn. 'Ke Piɛlɩ nɩ ‑wɛ 'le ꞊nʋ ‑hɛyri, 'ɔɔ ‑wɛ na 'wɛn. ");
INSERT INTO ted_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ti a ‑gbɛ 'yri, ‑ye ‑cɔhlʋnpinyʋ a nyɩgblaka Hanɩ ‑nɩ wɛn, ɔ ‑tʋa ‑Yusu a tetei a wlɔnlɛ꞊gbʋgba gbo, ɔ nɔ: «Nahuin tio‑ mɔ ‑na ‑naagbopʋ, kɔ, dɛ tio‑ mɔ ‑na tɔɔwin 'le?» ");
INSERT INTO ted_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","‑Ye ɔ ꞊tuo ꞊wɔn, ɔ nɔ: «Nahuin 'bii yie nɩ, ‑tɩ 'nɩɩ tɔɔ. 'N 'de ‑tɩ ꞊de ‑hli. 'Ɛ nɩ ti, 'ke 'nɩɩ o 'le Nyɩsʋa a kayuo gbo tɔɔ, kɔ Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, ‑tɛ ‑Juukʋɛ 'bii, ʋʋ 'le 'ya, kɔ 'waa nyɩgblakɩ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","'A ‑tɩ, ꞊nɩ ꞊gba 'le 'mʋ wlɔn! ꞊Gba nahuin ꞊nʋ wlɔn, ‑ʋ nɩ o ‑tuo ke. Ʋ yi nɩ, ‑tɩ 'nɩɩ o tɔɔ. 'Waa 'dai dɛ nɩ nɔ ‑a mʋ ‑hɛyri.» ");
INSERT INTO ted_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Bɔ po 'klɛɛ lɛ, ‑ye Nyɩsʋa a 'kagblaka a 'yie꞊tunyɔ ‑ye, ‑ɔ nɩ 'o, nɔ‑ mɔ bɔ puo 'le 'ŋma nʋa 'mʋ, ɔ nɔ: «꞊Be kɛ ‑nɩɩ ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑wɔn꞊tutue nu?» ");
INSERT INTO ted_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","‑Ye ‑Yusu nɔ: «'Bɩa 'nɩ ꞊tu ‑tɩ, 'bɩ nyre 'yi lɛ, tʋɛ 'mʋ, kɛɛ, 'bɩa 'nɩ ꞊tu ‑tɩ, 'bɩ nɔ 'yi lɛ, dɛ‑ kɔ 'mɔ ‑nɩɩ bi?» ");
INSERT INTO ted_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ti a ‑gbɛ 'yri, ‑ye Hanɩ le 'a 'sɔyuo, 'ʋ gbɔ 'le ‑cɔhlʋnpinyʋ a nyɩgblaka Kaifʋ ye. ‑Ye 'ke ‑Yusu 'kɩɛ nɩɛ 'le 'kʋɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ti ꞊nʋ 'yri, ‑ye 'ke Simɔ Piɛlɩ 'kɩɛ nɩɛ 'le na'wɛnnyʋ ‑hɛyri, 'ke 'le ‑yaa 'mʋ. ‑Ye kɛ nahuon ‑ye nyo lele ye po, ɔ nɔ: «‑Mɔ ‑gbo, ‑mɔ mɔ ‑Yusu a ‑naagbopʋyu ‑yee nɩ.» Kɛɛ, ‑ye ɔ nɔ: «'Mm, 'n 'diu 'le ‑hɛyri nɩ mɔ.» ");
INSERT INTO ted_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kɛɛ, ‑cɔhlʋnpinyʋ a nyɩgblaka a ‑kʋannunyɔ ꞊de nɩ ‑wɛ 'o. Nahuon ꞊nʋ, ‑ɔ kɔ nʋa Piɛlɩ 'bɛ wɛn 'o, nɔ‑ kɔ 'dɩayuu nɩ. Nɔ‑ɔ ‑wɛ Piɛlɩ le, ɔ nɔ: «‑Mɔ ‑gbo, ‑mɔ mɔ ‑Yusu a ‑naagbopʋyuu nɩ, ‑ɛ nue, 'n 'ye wɛn ‑mʋ nɩ, ɔ kɔ ‑mʋ 'hɛɛn, 'ke 'le ti gbo.» ");
INSERT INTO ted_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kɛɛ ‑ye Piɛlɩ ‑ga lele nɩ. Tii ‑do a ti 'yri, ‑ye hapɛ da ‑nyrɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","‑Tɛ ‑nyrɛɛ 'klɛɛ lɛ cɛ, ‑ye ‑Juukʋɛ ‑ha 'le ‑Yusu Kaifʋ a ‑yaa 'mʋ nɩ, 'ʋ gbɔ 'le Romakʋɛ a ‑gʋlʋnʋma a 'kagblaka gbo. ‑Gʋlʋnʋma a ‑gbɛ, 'a 'dʋ mɔ Pilatɩ. ‑Juukʋɛ ‑mɛ ‑ye, 'waa nahuon ꞊de 'de 'le ‑yaa 'mʋ pa. Ʋ nɔ 'nɩ, 'bʋ pa 'le ‑gʋlʋnʋma a ‑tɛ, ‑ɔ 'de ‑Juukʋɛyu, ‑ye ʋ 'de 'o ye 'sii, 'ke 'o Nyɩsʋa ye. 'A ‑tɩ, ʋ 'nɩ di ꞊le lɛ'mimre, ‑ɛ mɔ Pakɩ a dididɛ nɩ. Nɛ‑ nue, 'ʋ hree 'o ‑patʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bʋ 'wlɛ 'klɛɛ 'o ‑patʋ 'mʋ gbo, nɛ‑ nue, Pilatɩ 'ɔ 'hrɩ 'o, ɔ nɔ: «Ba le 'mʋ, dɛ tio‑ nahuon ‑gbo, ɔ nu, ‑ɛ kɔ ‑tɩ a nyo yɛɛ.» ");
INSERT INTO ted_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","‑Ye ʋ nɔ: «'Bɔ 'de wɛn dɛ'klannunyɔ, ‑a 'deɛ ‑ba yɔ wɛn ‑mʋ ye.» ");
INSERT INTO ted_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bʋ po 'klɛɛ lɛ, ‑ye Pilatɩ nɔ: «Ba gbɔ, ba puo ‑bati lɛ 'a nɩ ‑gbɛ. Dɛ a 'ye, ba nue ꞊nɔ 'mʋ, ‑tɛ 'a nɩ tetei, ɩɩ 'a 'yiye nu!» ‑Ye ʋ nɔ: «'A mʋ Romakʋɛ, a pue 'mʋ tete, 'ke ‑a mʋ ‑Juukʋɛ ‑a nɩ 'la 'le nahuon. ‑Aa ‑hʋa 'ke ba kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ.» ");
INSERT INTO ted_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","‑Tɛ ʋ po 'klɛɛ lɛ, ‑ye dɛ ‑gbo, ‑Yusu ꞊tu o, 'ke 'o 'a 'kʋkʋɛdʋ a ‑ta 'mʋ, ti ꞊de ‑hi o a ti 'yri o, ‑ye dɛ a ‑gbɛ, nɛ‑ kɔ ‑bɛ mue kɛ 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","‑Ye Pilatɩ pa lele nɩ, 'ɔ le 'a 'sɔyuo, bʋ 'yɩya 'o ꞊nɔ ‑Yusu ye gbo, ɔ nɔ: «꞊Be ‑mɔɔ nɩ, ‑ɔ mɔ ‑Juukʋɛ a bodɩɔ?» ");
INSERT INTO ted_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","‑Ye ɔ nɔ: «꞊Be ‑tɩ ‑gbo, ‑nɩɩ 'mʋ wlɔn ꞊gba, ‑na ‑gbɛ, ‑mɔ ‑hii 'lu ‑wɔn lɛ, 'ke 'o 'mʋ ‑wɔn, ‑hee' ꞊be nahuin ꞊de le ‑mʋ?» ");
INSERT INTO ted_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","‑Ye Pilatɩ nɔ: «'Mɔ ‑gbo, 'n 'de ‑Juukʋɛyu. ‑Na ‑gbɛ a dakʋ kɔ ‑cɔhlʋnpinyʋ gblakɩ 'hɛɛn, nʋ‑ ya ‑mʋ 'mʋ ye.» ");
INSERT INTO ted_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","‑Ye ‑Yusu nɔ: «'Na bodɩɔdɛ, ɛ 'de 'klɔ ‑gbo ke a nahuin a bodɩɔdɛ ye 'we, 'plɩɩ ɛ 'de nahuin, ʋ 'de 'mʋ bodɩɔdɛ ‑nyi, Nyɩsʋa a ‑gbɛgbɛ, nɔ‑ ‑nye 'mʋ. 'Bɩa 'nɩ 'we wɛn ꞊nɔ 'klɔ ‑gbo ke a bodɩɔ ye, 'na ‑naagbopʋ, ʋ kɔ bʋ ‑wɔn wɛn 'mʋ ke, 'ke 'le 'dɩdɔti gbo, ʋ 'nɩ ꞊han wɛn 'mʋ ‑Juukʋɛ kwa po.» ");
INSERT INTO ted_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","‑Ye Pilatɩ nɔ: «Ɛ 'we ꞊nɔ ye, ‑mɔ mɔ 'klɛɛ bodɩɔɔ nɩ 'a.» ‑Ye ‑Yusu nɔ: «‑N nyi wɛn a ꞊tue, 'mɔ mɔ bodɩɔ. Nɛ‑ nue, 'nɩ ‑hɔn 'le Nyɩsʋa ‑wɔn 'mʋ, 'ʋ kɔ 'mʋ, 'mʋ nahuin ‑tɩ a ‑tɛɛ tɔɔ. 'A ‑tɩ, 'bɩa nahuon 'bɔ nʋɛ ‑tɩ a ‑tɛɛ 'mʋ, ɔɔ 'mʋ ye gbo po nʋa, 'plɩɩ 'ɔɔ 'na ‑tɩ ‑tɛɛ pue.» ");
INSERT INTO ted_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","‑Ye Pilatɩ nɔ: «Dɛ‑ mɔ ‑tɩ a ‑tɛɛ 'le?» Bɔ po 'klɛɛ lɛ, ‑ye ɔ 'hrɩ 'o lele ꞊o, 'ɔ mu 'le ‑Juukʋɛ ye, ɔ nɔ: «'Mɛ ‑ye o, 'nɩ 'yee ꞊le 'le ꞊nɔ dɛ 'klan ꞊de 'mʋ, bɔ nu, ‑bɛ blɛ 'kʋkʋɛ ye. ");
INSERT INTO ted_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Kɛɛ, ɛ mɔ ‑a nɩ dɛ'ɛ nɩ, ꞊a nye lɛ nu, 'ke 'o lɛ'mimre ꞊nʋ, ‑ɛ mɔ Pakɩ a ti 'yri, 'n kɔ ꞊bo tɛ ꞊jɩnyɔɔ ‑do gbo, aa ‑hʋa. 'A ‑tɩ, ꞊be a nye 'nɩ ‑hʋa, 'ke ꞊bo tɛ wɛn 'a nɩ bodɩɔ gbo?» ");
INSERT INTO ted_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","‑Ye tii ‑do a ti 'yri, ‑ye ʋʋ lɛ 'nɩ ꞊mʋma: «Gbegbe, ɛ 'de ꞊nɔ, Balabasɩ ‑aa ‑hʋa.» 'Plɩɩ ‑ye Balabasɩ a ‑gbɛ, ɔ mɔ ‑balʋnyɔ. ");
INSERT INTO ted_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","‑Ye Pilatɩ le 'sɔyuo nɩ, ɔ nɔ: «Ba gbɔ, ba bio lɔkʋɛ!» 'ʋ bio. ");
INSERT INTO ted_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","‑Tɛ ʋ ‑wɔ 'a bibie ‑wɔn, ‑ye ʋ hra ꞊nɔ lɛ 'witiklaʋn, 'ʋ ꞊tu ꞊nɔ 'lu, kɔ, 'ʋ puo ‑wɛ wlawlʋ ‑jɔhʋn. Wlawlʋdʋ a ‑gbɛ, bodɩɔpʋʋ ‑do, nʋ‑ nyu pue. ");
INSERT INTO ted_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","‑Ye ʋ 'yɩya 'o ꞊nɔ 'mʋ gbo 'hʋɩn, 'ʋ nyo 'caa, ʋ nɔ: «‑Na 'wio mɔ, ‑Juukʋɛ a bodɩɔ,» 'ʋ nyo ‑wɛ 'le 'ŋmɩ nʋɩ 'mʋ lɛ po. ");
INSERT INTO ted_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","‑Ye Pilatɩ 'hrɩ 'o lele ꞊o, ɔ nɔ: «'N nyo nɔ 'a mʋ ye 'nɩ ya, kɛ nɔ ‑patʋ 'mʋ, a 'mue yi, ‑ɛ mɔ, 'nɩ 'yee ꞊le 'le ꞊nɔ dɛ 'klan ꞊de 'mʋ, bɔ nu, ‑bɛ blɛ 'kʋkʋɛ ye.» ");
INSERT INTO ted_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","‑Ye ‑Yusu 'hrɩ 'o ꞊o, 'a 'witiklaʋn nɩ 'o ꞊nɔ 'lu, kɔ, 'a wlawlʋ ‑jɔhʋn 'ʋ nɩ 'le ꞊nɔ 'mʋ. ‑Ye Pilatɩ nɔ: «'A nɩ nahuon, nɔ‑ ‑gbo.» ");
INSERT INTO ted_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","‑Tɛ Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ 'hɛɛn, ʋ po 'le ‑Yusu 'yie 'mʋ, ‑ye ʋʋ lɛ 'nɩ ꞊mʋma, ʋ nɔ: «Kʋɔ 'o tu 'yie 'mʋ, kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ!» ‑Ye Pilatɩ nɔ: «Ba gbɔ, ba kʋɔ 'o tu 'yie 'mʋ 'a nɩ ‑gbɛ, ‑ɛ nue, 'mɛ ‑ye, 'nɩ 'yee ꞊le 'le ꞊nɔ dɛ 'klan ꞊de 'mʋ, ‑bɛ blɛ 'kʋkʋɛ ye.» ");
INSERT INTO ted_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","‑Ye ‑Juukʋɛ nɔ: «Pilatɩ, ‑a kɔ tete. Tete a ‑gbɛ, ɛ nɔ 'nɩ, nahuon, ‑ɔ di Nyɩsʋa a 'dʋ ‑wɔn ‑ha, ɔ nɩ 'mʋ 'kʋkʋɛ. 'A ‑tɩ, ‑tɛ ɔ plɛ, ɔ mɔ Nyɩsʋa a 'Yuu nɩ, ɔ nɩ 'mʋ 'kʋkʋɛ.» ");
INSERT INTO ted_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","‑Tɛ Pilatɩ 'wɔn 'klɛɛ ‑Juukʋɛ a pupowin, ‑ye 'a hʋannʋ bii ke, ");
INSERT INTO ted_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","'ɔ pa 'le lele 'a 'kagblaka gbo, 'ɔɔ ‑Yusu wlɔn ꞊gba, ɔ nɔ: «꞊Be Nyɩsʋa ‑wɔn, ‑n ‑hɔn 'le 'mʋ?» Kɛɛ, ‑Yusu 'de ꞊nɔ dɛ ꞊de klɛ ‑hɩhɩa. ");
INSERT INTO ted_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nɛ‑ nue, Pilatɩ 'ɔ nyo le, ɔ nɔ: «꞊Be 'mɔ Pilatɩ, 'mɔɔ ‑mʋ wlɔn ꞊gba, ꞊nɩnɩ ‑hɩhɩa 'mʋ klɛ? ‑N 'di yi, ‑ɛ mɔ, 'mɔ ‑gbo, ‑ɔ mɔ 'blʋgba ‑gbo a ‑gʋlʋnʋma, 'n kɔ 'klɩ, 'ke ꞊bo tɛ ‑mʋ gbo, 'nɩ kɔ ‑wɛ 'klɩ, 'ke ꞊bo kɔɔ 'o ‑mʋ tu 'yie 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","‑Ye ‑Yusu nɔ: «‑N 'deɛ ‑bo kɔ wɛn 'klɩ ꞊de, 'ke 'o 'mʋ ke, 'bɩa Nyɩsʋa 'bɔ 'de wɛn ‑mʋ 'klɩ ‑nyi. Nɛ‑ nue o, nahuon ‑gbo, ‑ɔ po 'mʋ ‑mʋ kwa, ɔ nu dɛ 'klan, 'ɔ ‑hi 'o ‑mʋ 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kʋɛ 'klɛɛ 'o ti ꞊nʋ 'yri gbo, ‑ye Pilatɩɩ 'o lele ꞊tu 'klɩ, ‑ɛ die nu, ɔ 'mʋ ‑Yusu gbo tɛ. ‑Ye ‑Juukʋɛɛ 'nɩ ꞊ma, ʋ nɔ: «'Bɩa ꞊nɩ tɛ nahuon ꞊nʋ gbo, ‑ye ‑n kɔ Romakʋɛ a 'kɩɩn gblaka 'hɛɛn, a 'de pɛ. Kɔ, 'bɩa nahuon 'bɔɔ 'a dɩɔnʋ bodɩɔ daa, ‑ye ɔ kɔ 'kɩɩn gblaka a ‑gbɛ 'hɛɛn, ʋ 'de pɛ.» ");
INSERT INTO ted_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatɩ bɔ 'wɔn 'klɛɛ ‑tɩ ꞊nʋ, ʋ ꞊tu, nɛ‑ mɔ bɔ 'hrɔɔ 'o ‑Yusu ‑patʋ 'mʋ, ‑ye ɔ nɩ gbo, 'ke 'le 'a ‑batipogbata wlɔn. ‑Tɛgbi, ɔ nɩ 'o gbo, ʋ po la 'o gblɛ 'hɛ papʋɩ. ‑Tɛgbi a ‑gbɛ, ʋ nye daa Gabata, 'ke 'le ‑Juukʋɛwin 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ɛ mɔ Pakɩ a 'wee a 'wɩɩ ꞊hun 'mʋ a ‑nyrɛgblɩ, 'ke Pilatɩ poo ‑Yusu ‑bati lɛ. ‑Ye Pilatɩ nɔ: «‑Juukʋɛ ‑a, 'a nɩ bodɩɔ, nɔ‑ ‑gbo.» ");
INSERT INTO ted_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","‑Ye ʋ ‑tʋa lele lɛ꞊mʋmalɛ gbo, ʋ nɔ: «Bɔ 'kʋ, bɔ 'kʋ, kʋɔ 'o tu 'yie 'mʋ!» ‑Ye Pilatɩ nɔ: «꞊Be 'a nɩ bodɩɔ, nɔ‑ ꞊bo kɔɔ 'o tu 'yie 'mʋ?» ‑Ye ‑cɔhlʋnpinyʋ gblakɩ nɔ: «‑A 'de bodɩɔ ꞊de yi, 'bɩa 'bɛ 'de Romakʋɛ a 'kɩɩn gblaka.» ");
INSERT INTO ted_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","‑Ye Pilatɩ le 'a 'sɔyuo nɩ, ɔ nɔ: «Ba gbɔ, ba kʋɔ 'o tu 'yie 'mʋ, ɔ 'mʋ 'kʋ, ‑tɛ ‑Juukʋɛ, ʋʋ 'a ‑hʋhʋa nu!» 'ʋ klo, 'ʋ nyo gba. ");
INSERT INTO ted_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","‑Ye ʋ hren ‑Yusu nɩ, 'ɔ 'ble 'a ‑gbɛ a tu ꞊nʋ, ‑ʋ kɔ 'yie 'mʋ ʋ dio 'o kɔɔ, 'ʋ ꞊tɩɔ Jrusrɛdɩɔ 'mʋ. ‑Tɛgbi a ‑gbɛ, ʋ gbɔ 'le, 'a 'dʋ mɔ 'Lukla, ‑ɛ mɔ Gɔlʋgɔta, 'ke 'le ‑Juukʋɛwin 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","'Ke ʋ kʋɔ 'o tu 'yie 'mʋ. Ʋ kɔɔ ‑wɛ 'o dɛ'klannunyʋʋ 'hɔn 'waa nɩ ti 'yie 'mʋ, ‑do 'ke 'le ‑Yusu a diidɛpɩa ke, ‑do ‑ye 'ke 'le 'a kamrapɩa ke. ");
INSERT INTO ted_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","‑Ye Pilatɩ le 'a nahuin, 'ʋ 'crɩɩ wintɛ, 'ke 'o 'plaɩn.yɛ ke, 'ʋ 'mʋɛ 'o ‑Yusu a tu 'lu 'mʋ gbo. Wintɛ a ‑gbɛ, kɛ ɛɛ po: «Nahuon ‑gbo, nɔ‑ mɔ Nasalɛtɩ 'mʋ a ‑Yusu, ‑ɔ mɔ ‑Juukʋɛ a bodɩɔ.» ");
INSERT INTO ted_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Wintɛ a ‑gbɛ, 'ke ʋ 'crɛɛ 'le wingbleii ta 'kwli 'mʋ, ‑ɩ mɔ ‑Juukʋɛwin, kɔ Romakʋɛwin, kɔ Glɛkɩkʋɛwin. ‑Tɛgbi ꞊nʋ, ʋ kɔɔ 'o ‑Yusu tu 'yie 'mʋ, ɛ 'mʋɛɛ 'dɩɔ a ‑gbɛ ye. Nɛ‑ kɔ ‑tɩ, ‑Juukʋɛ 'plɔplɔ 'ʋʋ 'crɩɩwintɛ a ‑gbɛ ‑hre. ");
INSERT INTO ted_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","‑Tɛ ‑Juukʋɛ a ‑cɔhlʋnpinyʋ gblakɩ ‑hre wintɛ a ‑gbɛ, ‑ye ʋ mu 'le Pilatɩ ye, ʋ nɔ: «Pilatɩ, ‑n 'deɛ ‑bo 'crɩɩ wɛn: ‑Yusu, ‑ɔ mɔ ‑Juukʋɛ a bodɩɔ, kɛ ‑n di wɛn po: Nahuon ‑gbo, ɔ nɔ 'nɩ, nɔ‑ mɔ ‑Juukʋɛ a bodɩɔ.» ");
INSERT INTO ted_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Kɛɛ, ‑ye Pilatɩ nɔ: «Dɛ ‑gbo, 'n 'crɩɩ, 'n 'crɛɛ nɩ. Gbe 'n 'deɛ ꞊bo 'cɩcɩɛ.» ");
INSERT INTO ted_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","‑Tɛ 'sɔyuo ‑wɔ 'klɛɛ ‑Yusu a kʋkʋɛ ‑wɔn, 'ke 'o tu 'yie 'mʋ, ‑ye ʋ 'ba 'a 'hʋɩn'mʋlɛpue‑tɔplɩ 'mʋ nɩ, 'ʋ po 'a duii ‑hɛn, 'ʋ wi, nahuon 'bɔ nɩ 'o, 'a nɩ du. Kɛɛ, ‑ye wlawlʋʋ ‑do nɩ 'o, ɛ mɔ danʋʋ ‑do a wlawlʋ ‑pɛtu'u nɩ. ‑Ye ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","«‑A nɩ cɩcrʋ 'le lɛ. 'A ‑ta 'mʋ, ‑ba po 'bla, nahuon, ‑ɔ die di, nɔ‑ diu gba.» Dɛ a ‑gbɛ, 'sɔyuo nue nɩ. ‑Ye ɛ 'we ꞊nɔ ye, ‑tɩ ‑gbo, Nyɩsʋa a winwlɔn‑hɛnyɔ ‑ye, ɔ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ti ꞊de ‑hi la a ti 'yri la, ‑tɩ a ‑gbɛ, ɩ nue kɛ nɩ. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «Ʋ wo 'na 'hʋɩn'mʋlɛpue‑tɔplɩ, 'plɩɩ 'ʋ po 'bla, 'na wlawlʋ a ‑tɩ.» ");
INSERT INTO ted_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","‑Tɛ ‑Yusu nɩ 'o tu 'yie 'mʋ, nyrʋgbapʋʋ ‑tie, ‑ʋ nɩɔ 'o ꞊hlɔn, nʋ‑ kɔ 'dʋɩ nɩ gbo: 'a 'dii, kɔ 'a 'dii a ‑dɩayu, kɔ Mari ‑ye, ‑ɔ mɔ Klopasɩ a nyrɔ, kɔ Mari, ‑ɔ kɔ 'le Madala 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","'Ke ‑naagbopʋyu ꞊nʋ, ‑Yusu nʋɛ 'mʋ ‑tɛɛ, ɔ nɩ ‑wɛ 'o. ‑Ye ‑Yusu bɔ 'ye 'klɛɛ 'a 'dii, 'ke 'o ꞊nɔ ꞊hlɔn, 'ke 'o 'a ‑naagbopʋyu a ‑gbɛ 'hʋɩn 'mʋ, ‑ye ɔ nɔ: «'Na 'dii o, ‑n nɛ 'yu, nɔ‑ ‑gbo kɛ.» ");
INSERT INTO ted_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","‑Ye ɔ le 'a ‑naagbopʋyu ꞊nʋ nɩ, ɔ nɔ: «‑Mɛ ‑ye, ‑n nɛ 'dii, nɔ‑ ‑gbo kɛ.» Kʋɛ 'o ti a ‑gbɛ 'yri gbo, ‑ye ‑naagbopʋyu a ‑gbɛ, ɔ gba ‑Yusu a 'dii nɩ, 'ke 'le 'a dɩɔnʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi 'klɛɛ, ‑ye ‑Yusu yie nɩ, ‑ɛ mɔ, 'a ‑kʋan ‑yrɛ 'lu, ‑ye ɔ nɔ: «'Na plɔ ma ye.» Kɛ ɔ po, ‑ɛ die nu, ‑tɩ ‑gbo, ‑ɩ 'crɛɛ la 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑tɩ a ‑gbɛ, ɩ 'mʋ kɛ nue. ");
INSERT INTO ted_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","'Ke 'o tu a ‑gbɛ 'hʋɩn 'mʋ, 'ke 'lipanɔ a 'pɔhlʋwɔ nɩ 'o. Nʋ‑ kɔ ‑wɔn 'sɔyuo 'nyra 'le dɛ, ‑ɛ 'we dakuo ye, 'ʋ mʋɛ 'o tugbayɛ 'yri lɛ, 'ʋ ‑nyo ‑Yusu, 'ɔ 'nɔ. ");
INSERT INTO ted_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","‑Tɛ ɔ 'nɔ 'klɛɛ, ‑ye ɔ nɔ: «‑Kʋan 'bii ‑yrɛ 'lu.» ‑Ye ɔ ꞊tɩɔ 'o 'lu nɩ, 'ɔ mra ‑hʋnhlʋn. ");
INSERT INTO ted_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","‑Ye ti, ‑ɩ hie 'le, ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ 'mʋ ‑wlu ꞊tue, ɩ 'de ‑huo. ‑Nyrɔwɔdʋ a ‑gbɛ, ɔ nɩ 'dɔ, 'ke 'le ‑nyrɔwɩ 'bii ‑hɛyri, ‑ɩ mɔ Pakɩ a 'wee. 'A ‑ta 'mʋ, ʋ 'die ‑hʋa, 'ke 'kʋkʋkui bɩ 'kɩɛ nɩɛ 'o ti 'yie 'mʋ ‑wuwle‑nyrɔwɔ a ‑gbɛ 'mʋ. Nɛ‑ nue, 'ʋ le Pilatɩ, bɔ le 'a 'sɔyuo, 'ke bʋ nu 'plʋdɛ, bʋ ‑yɩyra ‑Yusu kɔ ‑balʋnyʋʋ 'hɔn ꞊nʋ 'hɛɛn a bʋɩ lɛ, ‑ɛ die nu, ʋ 'mʋ 'kʋ 'tata, ɛ 'mʋ ꞊nʋ 'hru ‑nye, ʋ 'mu 'o ti 'yie 'mʋ ‑ha. ");
INSERT INTO ted_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","'Sɔyuo bʋ nyre 'klɛɛ 'o, ‑ye ʋ ‑yɩyra nahuiin 'hɔn ꞊nʋ a bʋɩ lɛ, ‑ʋ kɔ ‑Yusu 'hɛɛn ʋ kɔɔ 'o ti 'yie 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Bʋ 'yɩya 'o ‑Yusu 'hʋɩn 'mʋ gbo, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, ɔ 'kʋ nɩ. 'A ‑tɩ, ʋ 'de 'a bʋɩ lɛ ‑yɩyra. ");
INSERT INTO ted_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kɛɛ ‑ye 'sɔyuotayu ‑ye nu 'di, 'ɔ waa 'a ꞊mʋɛi ke. Tii ‑do a ti 'yri, ‑ye dablo kɔ 'nie 'hɛɛn, nɩ‑ ‑hɔn 'le ꞊nɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Nahuon, ‑ɔ 'ye ‑tɔplɩ 'bii ꞊nʋ, nɔ‑ɔ nɩ, ‑ɔ nyi ‑wɔn lɛ na, 'plɩɩ 'a ‑wɔnlɛnawin, ɩ mɔ ‑tɩ a ‑tɛɛ. Ɔ yrii lɛ ti, ɔ ꞊tu ‑tɩ a ‑tɛɛ, ‑ɛ die nu, 'a nɩ ‑gbɛ, a 'mui ‑wɛ ‑tɛɛ pue. ");
INSERT INTO ted_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","‑Tɛ 'sɔyuo nu ‑tɔplɩ a ‑gbɛ, 'ke 'o ‑Yusu ‑wɔn, ‑ye ‑tɩ ꞊nʋ, ‑ɩ 'crɛɛ la 'le Nyɩsʋacrɩɩnɩɛ ‑ye 'kwli 'mʋ, ‑tɩ a ‑gbɛ, ɩ nue kɛ nɩ. ‑Tɩ a ‑gbɛ, nɩ‑ ‑gbo: «Ʋ 'deɛ bʋ ‑yra 'a 'klaa ‑do.» ");
INSERT INTO ted_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","‑Ye 'ke 'le Nyɩsʋacrɩɩnɩɛ ‑ye 'kwli 'mʋ, ʋ 'crɩɩ la 'le lele: «Nahuon ‑gbo, ʋ waa ke, ʋ dio 'nɩ 'ye.» ");
INSERT INTO ted_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","‑Ye ‑Yusu a ‑naagbopʋyu ꞊de nɩ 'o. 'A 'dʋ mɔ Sosɛfʋ. 'Ke ɔ kɔ 'le Alimatedɩɔ 'mʋ. Kɛɛ, ɔ 'nɩ le ꞊le nahuon ꞊de, ‑ɛ mɔ, ɔ mɔ ‑Yusu a ‑naagbopʋyuu nɩ, ‑ɛ nue, ɔɔ pɩ ‑Juukʋɛ a 'blʋ a nahuin a hʋannʋ. ‑Yusu bɔ 'kʋ 'klɛɛ, ‑ye Sosɛfʋ a ‑gbɛ, nɔ‑ mu 'le Pilatɩ ye, 'ɔ ‑hʋa ‑hala, ɔ 'mʋ 'o ‑Yusu a 'hʋɩn tu 'yie 'mʋ ‑ha, ɔ 'muo 'o ‑ha. ‑Ye Pilatɩ wɔn nɩ. Pilatɩ bɔ wɔn 'klɛɛ, ‑ye Sosɛfʋ mu nɩ, 'ɔ ‑ha 'o ‑Yusu a 'hʋɩn tu 'yie 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ti a ‑gbɛ 'yri, ‑ye Nikodɛmʋ nyre 'o ꞊o. Nikodɛmʋʋ ‑do a ‑gbɛ, nɔ‑ mu la 'le ‑Yusu ‑wɔn 'tɔ 'mʋ, ti ꞊de a ti 'yri la; 'ɔ ya 'le hʋnhrʋnpo‑tɔplɩ, ‑ɩ ‑wɛ 'le ‑bɩ 'wɛɛ ‑kilowɩ a (30) ‑wlʋ ꞊tu 'o ‑pu. Hʋnhrʋnpo‑tɔplɩ a ‑gbɛ a 'dʋɩ mɔ milɩ kɔ alowɛsɩ. ");
INSERT INTO ted_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","‑Ye nahuiin 'hɔn ‑wɛ a ‑gbɛ, ʋ 'ba ‑Yusu a 'hʋɩn 'mʋ nɩ, 'ʋ nu hʋnhrʋnpo‑tɔplɩ a ‑gbɛ kɔ ‑jisɛi 'hɛɛn, 'ʋ 'hɩnhɩʋɩn ꞊nɔ lɛ, ‑tɛ ‑Juukʋɛ, ʋʋ 'o 'waa 'kʋkʋkui a 'o‑hɩhɩa nu. ");
INSERT INTO ted_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","‑Tɛgbi a ‑gbɛ, ʋ kɔɔ 'o ‑Yusu tu 'yie 'mʋ, 'dɩdɔti a ‑ci ‑ye nɩ 'le. ‑Ci a ‑gbɛ 'mʋ, 'hɩɔ gblaka nɩ 'le, 'ɔ hren 'klɔ, 'ɔ 'we ꞊nɔ dʋgba ye. Nɔ‑ kɔ 'kwli 'mʋ, 'ke ʋ 'bluu la 'le 'dɛɛ, (ti ꞊de a ti 'yri la, ‑ɛ 'we ꞊nɔ ‑wlukayu ye). 'Dɛɛ a ‑gbɛ wlɔn, ʋ 'de ‑hlɩn 'le 'kʋkʋku a pue. ");
INSERT INTO ted_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","‑Ye ‑Juukʋɛ a ‑wuwle‑nyrɔwɔ gblaka, ɔɔ ‑wlu mu 'nɩ ꞊tue. Nɔ‑ kɔ ‑tɩ 'ʋʋ 'kɩka, 'ʋ po 'le ‑Yusu a 'hʋɩn 'dɛɛdʋ a ‑gbɛ wlɔn, ‑ɛ nue, ɛ 'mʋɛɛ 'o ‑tɛgbi, ‑Yusu 'kʋʋ 'o ye. ");
INSERT INTO ted_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","‑Juukʋɛ a ‑wuwle‑nyrɔwɔ, ‑ɔ mɔ 'sɛɛdɩ, bɔ ‑hi, a 'sɔɔdɩ a ‑nyrɛgblɩ, gbɩgbɩyrɩ bɩ 'kɩɛ nɩɛ ‑tʋtʋ klɛ, Mari, ‑ɔ kɔ 'le Madala 'mʋ, kɔ 'a 'bienʋ ‑ye 'hɛɛn, ‑ye ʋ ‑tuo 'le 'dɛɛ ye nɩ, ‑ɛ kɔ wlɔn ʋ po 'le ‑Yusu a 'hʋɩn. ‑Ye ʋ 'ye nɩ, ‑ɛ mɔ, 'dɛɛ ꞊nʋ a ꞊ju, ‑ʋ mɔ 'hɩɔ, ʋ briku lɛ, 'ʋ ‑hɩʋ 'o 'dɛɛ a ‑gbɛ wien. ");
INSERT INTO ted_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Bʋ 'ye 'klɛɛ, ‑ɛ mɔ, ʋ briku lɛ, ‑ye Mari 'gba lɛ ci, 'ɔ mu 'le Simɔ Piɛlɩ kɔ ‑naagbopʋyu ‑ye ꞊nʋ ‑wɔn, ‑Yusu nʋɛ 'mʋ ‑tɛɛ, ɔ nɔ: «Ʋ ‑ha 'le ‑a nɩ Kʋkɔnyɔ ‑Yusu a 'hʋɩn 'dɛɛ wlɔn nɩ, 'plɩɩ ‑tɛ ʋ pui 'o gbo, ‑a 'de 'o yii.» ");
INSERT INTO ted_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","'Tata a ti 'yri, Simɔ Piɛlɩ kɔ ‑naagbopʋyu ‑ye ꞊nʋ 'hɛɛn, ʋ 'hrɩ nɩ, 'ʋ gba 'le 'dɛɛ ye cigbɛi. ");
INSERT INTO ted_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Bʋʋ 'klɛɛ mu, ‑ye ‑naagbopʋyu ‑ye ꞊nʋ, ɔ ‑hi Piɛlɩ lɛ, 'ɔ nyre 'le 'dɛɛ ye ‑tɩtɛ. ");
INSERT INTO ted_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","‑Ye ɔ ꞊tɩtɩ 'mʋ nɩ, 'ɔ ta 'le 'dɛɛ wlɔn lɛ, 'ɔ 'ye ‑jisɛi ꞊nʋ, ‑ɩ pɛ 'o gbo, kɛɛ, ɔ 'de 'le 'dɛɛ wlɔn pa. ");
INSERT INTO ted_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simɔ Piɛlɩ ‑mɛ ‑ye, bɔ nyre 'o, ‑ye ɔ pa 'le ꞊le, 'ɔ 'ye ‑wɛ ‑jisɛi ꞊nʋ, ʋ 'hɩnhɩʋan ‑Yusu a 'hʋɩn lɛ, ");
INSERT INTO ted_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","kɔ danʋ ꞊nʋ, ʋ mʋa ꞊nɔ 'lu lɛ. ‑Jisɛi kɔ danʋ a ‑gbɛ, ɩ pɛ gbo 'dɔ. Ɛ 'we ꞊nɔ ye, ‑tɛ ɩ nɩ o 'mʋ, 'ʋ 'hɩnhɩʋɩn o ‑Yusu lɛ, kɛ ɩ nɩ 'mʋ, 'ɩ pɛ 'o gbo. ");
INSERT INTO ted_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","‑Ye ‑naagbopʋyu ꞊nʋ, ‑ɔ kɔ ‑tɩtɛ nyre 'o, ɔ pa ‑wɛ 'le 'dɛɛ wlɔn nɩ, 'ɔ 'ye, ‑ɛ mɔ, ‑Yusu 'de 'le 'dɛɛ wlɔn nɩ. Nɛ‑ mɔ bɔ pui 'klɛɛ ‑tɛɛ, ‑ɛ mɔ, ‑Yusu ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ 'hrɩ 'klɔ, ");
INSERT INTO ted_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","‑ɛ nue, kʋɛ la 'le gbo, ʋ 'die 'mʋ lɛ a yree, ‑tɛ Nyɩsʋa a winwlɔn‑hɛnyʋ nu la 'a 'crɩɩlɛ, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ‑ɛ mɔ, ‑Yusu kɔ bɔ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, bɔ 'hrɩ 'klɔ. ");
INSERT INTO ted_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","‑Ye ‑naagbopʋʋ 'hɔn ‑wɛ a ‑gbɛ, ʋ ꞊hɩan ‑wɔn, 'ʋ mu lele Jrusrɛdɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","‑Ye Mari ‑mɛ lele de, 'ɔ nɩ 'o ‑Yusu a 'dɛɛ nʋa 'mʋ gbo, 'ɔɔ we. Ɔɔ wɛn a wee, 'ɔ ꞊tɩtɩ 'mʋ, 'ɔ ta 'le 'dɛɛ wlɔn lɛ. ");
INSERT INTO ted_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bɔɔ 'klɛɛ 'le lɛ ta, ‑ye ɔ 'ye 'le Nyɩsʋa a lɛleenyʋʋ 'hɔn, 'ʋ po ‑tɔplɩ pʋɔpʋɩ, 'ʋ nɩ 'o ‑tɛgbi ꞊nʋ gbo, ʋ pɩa 'o ‑Yusu a ‑plahʋɩn gbo, ‑do ‑tɛ ‑Yusu a 'lu ꞊gbɛɛ 'o, ‑do ‑ye ‑tɛ 'a bʋɩ ꞊gbɛɛ 'o. ");
INSERT INTO ted_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","‑Ye ʋ nɔ: «Nyrʋgba o, ɩ kla 'klɛɛ nɩ, ‑ɛ kɔ ꞊hien ‑nɩɩ we 'le?» ‑Ye Mari nɔ: «Ʋ ‑ha nɔ 'na Tɔɔnyɔ nɩ. 'N 'de 'o yii, ‑tɛ bʋ puo 'o gbo.» ");
INSERT INTO ted_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɔ nɩ 'klɛɛ 'le 'a ꞊tutue kwa 'mʋ, ‑ye ɔ ꞊hɩan ‑wɔn. Bɔ ꞊hɩan 'klɛɛ ‑wɔn, ‑ye ɔ 'ye ‑Yusu nɩ, kɛɛ, ɔ 'nɩ yroo ꞊le lɛ. ");
INSERT INTO ted_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","‑Ye ‑Yusu nyo wlɔn 'nɩ ꞊gba, ɔ nɔ: «Nyrʋgba o, dɛ‑ kɔ ꞊hien ‑nɩɩ we 'le? Nyɔ‑ ‑nɩɩ lɛ ꞊mɔ 'le?» ‑Ye Mari ‑mɛ ‑ye, ‑tɛ ɔ 'ye ‑Yusu, 'a ꞊wlʋ ke, ɔ nɔ 'nɩ, 'dɩdɔti a ‑ci ꞊nʋ, nɔ‑ kɔ 'yie꞊tunyɔ'ɔ nɩ. 'A ‑tɩ, ‑ye ɔ nɔ: «Nyɩbɛyu o, 'bɛ 'ya ‑mɔ 'mʋ o, ꞊nɩ gbɔ, le 'mʋ, ‑tɛ ‑n puo 'o gbo, ‑ɛ die nu, 'muo bla.» ");
INSERT INTO ted_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Kɛɛ ‑ye ‑Yusu dɔ nɩ, ɔ nɔ: «Mari!» ‑Ye Mari ꞊hɩan ‑wɔn, ɔ nɔ: «Rabuni,» ‑ɛ mɔ Tɔɔnyɔ, 'ke 'le ‑Juukʋɛwin 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Kɛɛ ‑ye ‑Yusu nɔ: «꞊Nɩ ka 'le 'mʋ ye, ‑ɛ nue, 'n 'de wɛn 'le 'na Bu ‑wɔn a mue, 'ke 'le yrayrɩ. Kɛɛ, mu 'le 'na ‑dɩayuo ‑wɔn, ‑ʋ mɔ 'na ‑naagbopʋ, ‑bo lu, ‑ɛ mɔ, 'ke 'nɩɩ 'le 'na Bu ‑wɔn mu, ‑ɔ mɔ ‑wɛ 'a nɩ Bu, 'ke 'le 'na Nyɩsʋa ‑wɔn, ‑ɔ mɔ ‑wɛ 'a nɩ Nyɩsʋa.» ");
INSERT INTO ted_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","‑Ye Mari mu ‑naagbopʋ le wɔn, ‑ɛ mɔ, ɔ 'ye Tɔɔnyɔ nɩ. Nɔ‑ɔ nɩ, ‑ɔ le ꞊nɔ ‑tɔplɩ 'bii ꞊nʋ, ɔɔ ꞊nʋ le. ");
INSERT INTO ted_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","‑Nyrɔwɔ a ‑gbɛ 'mʋ, ‑ɔ mɔ 'sɔɔdɩ a ‑wise, 'ke ‑Yusu a ‑naagbopʋ 'kukue lɛ, 'ke 'le kayu ‑ye gbo. ‑Tɛ ʋʋ ‑Juukʋɛ a 'blʋ a nahuin a hʋannʋ pɩ, nɛ‑ nue, 'ʋ ꞊gba 'maji 'bii. 'Ke ʋ nɩ 'klɛɛ 'o, ‑ye tii ‑do a ti 'yri, 'ke ‑Yusu 'hrɩɩ 'le ꞊nʋ ‑hɛyri, ɔ nɔ: «Ba kɔ plɔ a bleelɛ!» ");
INSERT INTO ted_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Bɔ po 'klɛɛ lɛ, ‑ye ɔ titie ꞊nʋ 'a kwatɩ kɔ 'a ꞊mʋɛi 'hɛɛn ye. ‑Naagbopʋ bʋ 'ye Kʋkɔnyɔ ‑Yusu, ‑ye ʋʋ nu 'manʋ. ");
INSERT INTO ted_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","‑Ye kɛ ɔɔ lele po, ɔ nɔ: «Ba kɔ plɔ a bleelɛ! ‑Tɛ 'na Bu nu, 'ɔ lee nɔ 'mʋ 'klɔ ke, 'mʋ 'a ‑tɩ ꞊tu, 'na ‑gbɛ o, 'nɩɩ 'a mʋ 'nɩ le, ba na 'klɔ ke, ba ꞊tu 'na ‑tɩ.» ");
INSERT INTO ted_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi 'klɛɛ, ‑ye ɔ ꞊hloon ꞊nʋ 'lu pepe, ɔ nɔ: «Nyɩsʋa a ‑Hihiu bʋ nɩ 'o 'a mʋ ke 'mʋ! ");
INSERT INTO ted_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Nahuon 'bɔ nɩ 'o, 'ba lo, 'ke 'le Nyɩsʋa a ‑Hihiu a 'klɩ 'kwli 'mʋ, ‑ɛ mɔ: ‑Na dɛ 'kuku 'wʋwlɛ nɩ, 'ɛ mɔ ‑tɛɛ, 'a dɛ 'kuku 'wʋwlɛ nɩ 'bii. Kɛɛ, nahuon 'bɔ nɩ 'o, 'ba 'dio le, ‑ɛ mɔ: ‑Na dɛ 'kuku 'wʋwlɛ nɩ, ‑ye 'ɛ mɔ ‑tɛɛ, 'a dɛ 'kuku 'de 'wʋwlɛ.» ");
INSERT INTO ted_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","‑Tɛ ‑Yusu 'hrɩɩ ꞊nʋ ye ‑tɩtɛ, Toma, ‑ɔ mɔ ‑Yusu a ‑naagbopʋyu ‑ye ꞊nʋ, ʋʋ ꞊Yrupoyu daa, ɔ 'de 'le 'a 'bienʋ ‑hɛyri nɩ. ");
INSERT INTO ted_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","‑Tɛ 'a 'bienʋ 'yo 'klɛɛ, ‑ye kɛ ʋʋ ꞊nɔ ye po, ʋ nɔ: «Toma, ‑a 'ye Kʋkɔnyɔ nɩ.» ‑Ye ɔ nɔ: «'Bɩa 'nɩ 'de kʋɛkʋɛi ꞊nʋ a ꞊pɩ 'ye, ʋ kɔɔ 'le ꞊nɔ kwa 'mʋ, 'na ‑jie 'bɛ 'di lɛ 'tʋ, kɔ, 'nɩ 'de 'le 'na dabʋ 'a ꞊mʋɛi ꞊nʋ, ʋ waa ke a 'hʋɔ wlɔn 'nyra, 'n 'deɛ ꞊bo pue ‑tɛɛ gbe, ‑ɛ mɔ, Kʋkɔnyɔ 'hrɩ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","'Wee ‑do bɛ ‑hi, ‑ye ‑Yusu a ‑naagbopʋ 'kukue lele lɛ. 'Ke Toma nɩ 'klɛɛ 'le ꞊nʋ ‑hɛyri. ‑Ye ʋ ꞊gba lele kayu ‑kɔ gbo ʋ nɩ 'le a 'maji 'bii nɩ. Tii ‑do a ti 'yri, ‑ye ‑Yusu 'hrɩɩ 'le lele ꞊nʋ ‑hɛyri nɩ, ɔ nɔ: «Ba kɔ plɔ a bleelɛ!» ");
INSERT INTO ted_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","‑Ye ɔ nɔ: «Toma, 'yɩya mɔ ‑na ‑jie gbo, kɔ, 'ye 'na kwatɩ, 'yɩya ‑wɛ mɔ ‑na dabʋ gbo, ‑bo 'nyra 'le ‑na ‑jiomɩ 'na ꞊mʋɛi, ʋ waa o ke a 'hʋɔ wlɔn! 'N 'hrɩ 'klɔ, ꞊nɩ pui 'le lele gblɛ, pui ‑tɛɛ!» ");
INSERT INTO ted_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","‑Ye Toma nɔ: «'Na Kʋkɔnyɔ, kɔ 'na Nyɩsʋa.» ‑Ye ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","«꞊Be ‑tɛ ‑n 'ye 'mʋ, nɔ‑ kɔ ‑tɩ ꞊nɩ nye ‑tɛɛ pue, ‑ɛ mɔ, 'n 'hrɩ 'klɔ. 'Manʋ 'ke 'o nahuon ꞊nʋ ‑wɔn, ‑ɔ 'de 'mʋ 'ye, 'plɩɩ ‑ɔ pue ‑tɛɛ, ‑ɛ mɔ, 'n 'hrɩ 'klɔ, 'plɩɩ ‑ɔ kuo 'mʋ ꞊wlʋ ye.» ");
INSERT INTO ted_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","‑Yusu nu 'ŋmilɛka‑tɔplɩ ‑ye, 'ke 'o 'a ‑naagbopʋ ye. ‑Tɔplɩ a ‑gbɛ, ɩ 'de 'crɛɛ, kɛ nɔ 'crɩɩnɩɛ ‑gbo 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kɛɛ, 'a dɛ ‑gbo, ‑ɛ 'crɛɛ, ɛ 'crɛɛ nɩ, ‑ɛ die nu, a 'mue ꞊wlʋ ye kuo, ‑ɛ mɔ, ‑Yusu, nɔ‑ mɔ Waanyɔ, Nyɩsʋa po la lɛ, ɔ di la 'le ya, ɔ 'mʋ 'a dakʋ waa, kɔ, 'ɔ mɔ Nyɩsʋa a 'Yu. 'Bɩa 'ba pue Waanyɔ a ‑gbɛ a ‑tɩ ‑tɛɛ, 'ba kuo ꞊wlʋ ye, kɔ, 'ba nyo ‑wɔn kʋɛ, ɔ di 'a mʋ ‑nye 'klɔ yrayrʋ. ");
INSERT INTO ted_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","2","‑Tɛ ‑tɔplɩ 'bii a ‑gbɛ, ɩ ‑hi, ‑ye ‑Yusu 'hrɩɩ lele 'a ‑naagbopʋ ye, 'ke 'le Galileblʋgba a 'yru nʋa 'mʋ. ‑Yusu a ‑naagbopʋ ꞊nʋ, ‑ʋ nɩ 'o, 'waa 'dʋɩ, nɩ‑ ‑gbo: Simɔ Piɛlɩ, kɔ Toma, ʋʋ ꞊Yrupoyu daa, kɔ Natanaɛlɩ, ‑ɔ kɔ 'le Kanadɩɔ 'mʋ, 'ke 'le Galileblʋgba 'mʋ, kɔ Sebede a 'yuoo 'hɔn, kɔ ‑naagbopʋʋ 'hɔn ‑ye 'hɛɛn. Nʋ‑ ‑Yusu 'hrɩɩ ye. ‑Tɛ ɔ nu 'waa ye'hrɩɩlɛ, nɛ‑ ‑gbo: ");
INSERT INTO ted_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","‑Nyrɔwɔ ꞊de 'mʋ, Simɔ Piɛlɩ nɔ: «‑A 'bi ‑a o, 'nɩɩ mu 'nɩ 'pa.» ‑Ye ʋ nɔ: «‑N kɔ ‑a mʋ 'hɛɛn‑ mu.» ‑Ye ʋ 'ba 'mʋ ye, 'ʋ mu 'le 'yru nʋa 'mʋ. 'Ke ʋ 'ya 'le 'blagbe wlɔn, 'ʋ mu 'pa wɔn. Kɛɛ, ʋ 'de ‑hrin.ee ‑do 'pa, 'tɔyrʋwɔ 'bii ꞊nʋ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","‑Nyrɛ bɛ cɛ 'klɛɛ lɛ, ‑ye ʋ 'ye ‑Yusu nɩ, 'ke 'o 'yru nʋa 'mʋ, kɛɛ, ʋ 'dio yrii. ");
INSERT INTO ted_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","‑Ye ɔ nɔ: «'Hɩanpli ‑a, ꞊be a 'pa dɛ?» Ʋ nɔ: «Gbe ‑o, ‑a 'de dɛ 'ye.» ");
INSERT INTO ted_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","‑Ye ɔ nɔ: «Ba po 'le 'a nɩ ‑tata 'blagbe a diidɛpɩa ke. A di 'ye dɛ,» 'ʋ puo 'le diidɛpɩa ke. Bʋ puo 'klɛɛ 'le, ‑ye ɔ po 'le ‑hrin 'plɔplɔ. 'A ‑tɩ, ʋ 'die 'le ‑wɛ, 'ke bʋ ‑hɩɔ 'nie 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","‑Naagbopʋyu ꞊nʋ, ‑Yusu nʋɛ 'mʋ ‑tɛɛ, bɔ 'ye 'klɛɛ 'ŋmilɛkadɛ ꞊nʋ, ‑ye ɔ nɔ: «Simɔ Piɛlɩ, ‑a nɩ Tɔɔnyɔ'ɔ nɩ.» Tii ‑do a ti 'yri, ‑tɛ ɔ 'wɩn 'klɛɛ, ‑ɛ mɔ, 'waa Tɔɔnyɔ'ɔ nɩ, ‑ye ɔ pue 'a wlawlʋ nɩ, 'ɔ mʋ gbo, ‑ɛ nue, ɔ ꞊ga wɛn wlɔn 'hʋɩn, 'plɩɩ 'ɔ bi 'nie 'mʋ, 'ɔ mu 'le ‑Yusu 'hʋɩn 'mʋ. ");
INSERT INTO ted_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","‑Naagbopʋ ‑ye ꞊nʋ, 'blagbe, nɛ‑ ʋ gba, 'ʋʋ ‑wɛ 'le ‑Yusu ye mu. Bʋʋ 'klɛɛ mu, ‑ye ʋʋ 'waa ‑tata ‑wɔn lɛ ‑jri 'nie, ‑hrin a kwaku‑tɩ. Ʋ 'de gbogbo ‑wɔn hren. ");
INSERT INTO ted_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","‑Tɛ ʋ kwlɛɛ 'klɛɛ 'blagbe, 'ʋ ꞊tɩ. ‑Ye ʋ 'ye 'o ꞊nɔ 'hʋɩn 'mʋ wʋnwlɩnna, ‑hrin pɛ 'o 'lu gblɛ kɔ 'flɔɔ, 'ke 'o ꞊nɔ mamɔ lɛ. ");
INSERT INTO ted_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","‑Ye ɔ nɔ: «‑Hrin, 'a nɩ ‑tata po 'le, ba ya 'le 'a dɛ!» ");
INSERT INTO ted_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simɔ Piɛlɩ 'ɔ 'ya 'le 'blagbe wlɔn, 'ɔ ‑jri 'le ‑tata, 'ɔ puo ‑tʋtʋ 'mʋ gbo, 'ke 'le ꞊nɔ wlɔn 'ʋ ‑ha 'le ‑hrin gblakɩ a (153) ‑wlɩɩ 'nɩpata ꞊tu 'o ‑pu ꞊tu 'o ta. ꞊Hapʋkɔ, ‑hrin a ‑gbɛ 'ɩ ‑huo, kɛɛ, ‑tata 'de lɛ cɩcrɛ. ");
INSERT INTO ted_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","‑Ye ‑Yusu nɔ: «Ba 'de, a 'mʋ dɛ di!» Ʋ ‑hʋa bʋ ꞊gbɔ wlɔn, ‑ɛ mɔ: «Nyɔ tio‑ ‑n 'ya 'klɛɛ 'le?» kɛɛ, ʋ 'die nu, ‑tʋɩ a ‑tɩ, ‑ɛ nue, ʋ yie nɩ, ‑ɛ mɔ, Kʋkɔnyɔ'ɔ nɩ, ");
INSERT INTO ted_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","'ɔ 'yɩya 'o ꞊nʋ 'hʋɩn 'mʋ gbo, 'ɔ ‑nyi ꞊nʋ 'flɔɔ, kɔ, 'ɔ ‑nyi ‑wɛ ꞊nʋ ‑hrin. ");
INSERT INTO ted_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","‑Tɛ ɔ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, 'a gblo a ta a nɔnɔ'ɔ nɩ, 'ke bɔ 'hrɩɩ 'a ‑naagbopʋ ye. ");
INSERT INTO ted_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","‑Tɛ ʋ ‑wɔ dɛ lɛ, ‑ye ‑Yusu ‑tʋa 'le Simɔ Piɛlɩ a 'le‑wɔn'prɛɛlɛ gbo, ɔ nɔ: «Simɔ, Saan a 'yu, ꞊be ‑n nʋɛ 'mʋ 'mʋ nɩ, 'ɛ ‑hi 'o nahuin ‑ye ‑gbo 'mʋ?» ‑Ye Piɛlɩ nɔ: «Iin, Kʋkɔnyɔ, ‑n yie nɩ, ‑ɛ mɔ, 'n nʋɛ ‑mʋ 'mʋ nɩ.» ‑Ye ‑Yusu nɔ: «Naa 'na ‑naagbopʋ. ‑Tɛ blablɔkɔnyɔ, ɔɔ 'a blablɔ a naalɛ nu, kɛ ‑bo nu 'na ‑naagbopʋ a naalɛ.» ");
INSERT INTO ted_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","‑Ye ‑Yusu ꞊gbɔ lele wlɔn, ɔ nɔ: «Simɔ, Saan a 'yu, ꞊be ‑n nʋɛ 'mʋ 'mʋ nɩ?» ‑Ye ɔ nɔ: «Iin, Kʋkɔnyɔ o, ‑n yie nɩ, ‑ɛ mɔ, 'n nʋɛ ‑mʋ 'mʋ nɩ.» ‑Ye ‑Yusu nɔ: «Naa 'na ‑naagbopʋ!» ");
INSERT INTO ted_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","‑Ye ‑Yusu ꞊gbɔ lele wlɔn: «Simɔ, Saan a 'yu, ꞊be ‑n nʋɛ 'mʋ 'mʋ nɩ?» ‑Tɛ ‑Yusu ꞊gba 'klɛɛ ꞊nɔ dɛ ꞊nʋ wlɔn, gblo a ta a nɔnɔ, ‑ye Piɛlɩ a ꞊wlʋ 'mʋɛ gbo, ‑ye ɔ nɔ: «Kʋkɔnyɔ o, ‑n yi 'ɛ nɩ dɛ nɩ. ‑N yie nɩ, 'n nʋɛ ‑mʋ 'mʋ nɩ.» ‑Ye ‑Yusu nɔ: «Naa 'na ‑naagbopʋ! ");
INSERT INTO ted_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","'Nɩɩ ‑mʋ 'nɩ le ‑tɛɛ, ‑tɛ ‑n 'ya la gblotayu 'mʋ, ‑tɛ ‑na ꞊wlʋʋ la 'le 'yee, 'ke ‑nɩɩ la 'le mu, kɛɛ, ꞊nɩ ‑wɛ ‑hlɩn 'yi, ‑n di ‑hlɩn 'mʋ lɛ ꞊gblɛ dabʋɩ, ꞊ɔ ‑ye 'mʋ ‑hlɩn 'le ‑mʋ ‑tɛgbi ‑ye gba, ‑tɛ ‑na ꞊wlʋ 'de 'le nɩ.» ");
INSERT INTO ted_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ɛ 'we ꞊nɔ ye, ꞊sʋɛ'kʋkʋɛdʋ ꞊nʋ, Piɛlɩ di 'kʋ, ‑ɛ di Nyɩsʋa ‑tɩ a 'yi'bʋaalɛ ‑nye, nɛ‑ ‑Yusu 'muo tɔɔ. Nɛ‑ kɔ ‑tɩ, 'ɔ 'prɛɛ dɛ ꞊nʋ ke. Bɔ po 'klɛɛ lɛ, ‑ye ʋ 'ba 'mʋ ye, ɔ nɔ: «Piɛlɩ, kʋɛ 'mʋ ‑wɔn!» ");
INSERT INTO ted_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","‑Ye Piɛlɩ ꞊hɩan ‑wɔn. ‑Tɛ ɔ ꞊hɩan 'klɛɛ ‑wɔn, ‑ye ɔ 'ye ‑naagbopʋyu ꞊nʋ nɩ, ‑Yusu nʋɛ 'mʋ ‑tɛɛ, 'ɔ nyu ‑wɛ ‑wɔn kʋɛ. ‑Tɛ ‑Yusu kɔ 'a ‑naagbopʋ 'hɛɛn, ʋʋ o 'waa 'lelɛ'bɔɔdididɛ di, ‑tɛ ɔ 'de o a 'kʋɛ, ‑naagbopʋyuu ‑do a ‑gbɛ, nɔ‑ɔ nɩ, ‑ɔ 'ma o 'o 'a 'lu ‑Yusu ‑wliye gbo, 'ɔ ꞊gbɔ o wlɔn, ɔ nɔ: «Kʋkɔnyɔ, nahuon tio‑, ‑ɔ di 'klɛɛ ‑mʋ ‑na yraanyʋ kwa po 'le?» ");
INSERT INTO ted_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","‑Tɛ Piɛlɩ 'ye 'klɛɛ ‑naagbopʋyu a ‑gbɛ, ‑ye ɔ nɔ: «Kʋkɔnyɔ, ꞊ɔ ‑ye ‑gbo 'le? Dɛ tio‑ di ‑hlɩn ꞊nɔ nue 'le?» ");
INSERT INTO ted_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","‑Ye ‑Yusu nɔ: «꞊Be 'nɩ nye ‑hʋa, bɔ hie 'klɔ, ꞊bo 'ya 'le yrayrɩ, ꞊bo ꞊hɩan ‑wɔn, ꞊bo yɔ mɔ gbo, ꞊be ‑n kʋɛ 'le ‑wɔn? ‑Mɛ ‑ye o, kʋɛ 'mʋ ‑wɔn!» ");
INSERT INTO ted_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","‑Tɩ ꞊nʋ, ‑Yusu ꞊tu, ɩ nue, Nyɩsʋa a nahuin 'ʋʋ lɛ po, ‑naagbopʋyu a ‑gbɛ, ɔ 'deɛ bɔ 'kʋ. Kɛɛ, 'ke 'le ‑tɛɛkɔ 'kwli 'mʋ, ‑Yusu 'de lɛ po, ‑ɛ mɔ: «Ɔ 'deɛ bɔ 'kʋ,» kɛɛ, ɔ nɔ 'nɩ: «'Bɩa 'nɩ nye ‑hʋa, bɔ hie 'klɔ, ꞊bo 'ya 'le yrayrɩ, ꞊bo ꞊hɩan ‑wɔn, ꞊bo yɔ mɔ gbo, ꞊be ‑n kʋɛ 'le ‑wɔn?» ");
INSERT INTO ted_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","‑Naagbopʋyuu ‑do a ‑gbɛ, ‑ɔ kɔ ‑tɩ ‑Yusu ꞊tu, nɔ‑ɔ nɩ, ‑ɔɔ ‑tɔplɩ ‑gbo ‑wɔn lɛ na. Ɔ 'yi nɩ, ‑ɛ nue, ɔ nɩ la ke ‑tuo, 'ɔ pui nɔ 'crɩɩnɩɛ ‑gbo 'kwli 'mʋ. 'Ɛ nɩ nahuon, kɛ nɔ ‑a mʋ ‑hɛyri, ɔ yie nɩ, ‑ɛ mɔ, ‑tɩ a ‑tɛɛ nɩ, ɔɔ ꞊tu. ");
INSERT INTO ted_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","‑Tɔplɩ ‑ye, ‑Yusu nu, ɩ ‑huo nɩ. 'Bɩa ꞊ba kɔ ‑ba 'crɩɩ wɛn ɩ 'bii, 'n yie nɩ, 'a 'crɩɩnɩɛi 'deɛ bɩ wɛɛn wɛn nɔ 'klɔ ‑gbo ke.");
INSERT INTO ted_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","‑Na 'wio Teofilɩ. 'Ke 'le 'na ye‑hɛcrɩɩnɩɛ 'kwli 'mʋ, 'n le ‑mʋ ‑tɔplɩ 'bii ꞊nʋ nɩ, ‑Yusu 'Klɩsʋʋ la nu, kɔ, ɔɔ la nahuin tɔɔ, kʋɛ la 'le gbo, ");
INSERT INTO ted_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","‑bo mu ‑mumu, ‑bo yɛ ‑nyrɔwɔ ꞊nʋ ke, ‑ɔ kɔ 'mʋ Nyɩsʋa nue la, ‑Yusu a ‑gbɛ 'ɔ mu la yakɔ 'mʋ. 'Plɩɩ ɔ 'mʋ la mu mu, nahuin ꞊nʋ, ɔ ‑ha la 'le du 'mʋ, 'ke bʋ ‑hɛ la 'a ‑wɔnnaanyʋ, 'ɔ le la ꞊nʋ 'lelɛ'bɔɔwintɛ, 'ke 'le Nyɩsʋa a ‑Hihiu a 'klɩ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","‑Tɛ ɔ 'kʋ, ‑tɛ ɔ 'hrɩ 'klɔ, 'ke 'le ‑nyrɔwɩ a ‑wlɩɩ 'hɔn 'kwli 'mʋ, 'ke ɔ 'hrɩɩ ꞊nʋ yrɛ, 'ɔ tʋɛ ꞊nʋ, ‑ɛ mɔ, ɔ 'hrɩ 'klɔ, 'plɩɩ ‑tɛ Nyɩsʋa, ɔɔ nahuin a win a kekɔɔlɛ nu. Nɛ‑ kɔ ‑tɩ ɔ tɔɔ ꞊nʋ. ");
INSERT INTO ted_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","‑Nyrɔwɔ ꞊de 'mʋ, ‑tɛ ‑Yusu nɩ 'klɛɛ 'le lele 'a ‑wɔnnaanyʋ ‑hɛyri, ‑ye ɔ nyu 'nɩ le, ɔ nɔ: «A nɩ hren 'le 'dɩɔ ‑gbo ‑wɔn, ‑ɔ mɔ Jrusrɛ, kɛɛ, ba ‑pre Nyɩsʋa a ‑Hihiu ꞊nʋ, Nyɩsʋa a ‑gbɛ, ɔ plɛ, ɔ di la 'a mʋ ‑nyi, ‑ɛ 'we ꞊nɔ ye, ‑tɛ 'n nu la 'a mʋ 'a ye꞊tutue. ");
INSERT INTO ted_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Saan ‑mɛ ‑ye, 'niee nɩ, ɔ po 'a mʋ 'lu lɛ, kɛɛ, 'ke 'le ‑nyrɔwɩ gbi 'kwli 'mʋ, Nyɩsʋa di 'a mʋ ‑nyi 'a ‑Hihiu.» ");
INSERT INTO ted_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nahuin ꞊nʋ, ‑ʋ ꞊gbee 'o ‑Yusu 'hʋɩn 'mʋ, ‑ye ʋ ꞊gbɔ wlɔn, ʋ nɔ: «Kʋkɔnyɔ o, ‑a mʋ Yisraɛkʋɛ, ꞊be ti ‑gbo 'yrii nɩ, ‑n di 'le ‑a mʋ Romakʋɛ a 'klɩ gbo ‑ha, ‑ɛ die nu, ‑a ‑do, ‑a 'mʋ ‑a nɩ 'blʋgba naa,» ");
INSERT INTO ted_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","‑Yusu 'ɔ ꞊tu ꞊nʋ ‑wɔn, ɔ nɔ: «Ti ꞊nʋ, ‑ɩ kɔ 'yri ‑tɔplɩ a ‑gbɛ, ɩ di 'lu ‑wɔn mue, a 'de ye blɛ ba yi, ‑ɛ nue, ‑a nɩ Bu Nyɩsʋa'a nɩ, ‑ɔ wa ti a ‑gbɛ 'dʋ, ‑tɛ ɔ nu 'a ‑hʋhʋa. ");
INSERT INTO ted_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa a ‑Hihiu di 'o 'a mʋ ke 'mʋ bi, a di kɔ 'klɩ, 'ke ba le nahuin ‑tɔplɩ 'bii ꞊nʋ, a 'ye, 'ke 'o 'na ‑ta 'mʋ. Ba ꞊tu 'na ‑tɩ, kɛ nɔ Jrusrɛ 'mʋ, ba mu ‑wɛ 'le Sudeblʋgba kɔ Samaliblʋgba 'bii 'mʋ, kɔ, ba bi 'klɔ 'bii ‑gbo ke, a 'mʋ 'na ‑tɩ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Bɔ ‑yrɛ 'klɛɛ, ‑ye ɔ ‑tʋa yakɔ a 'mʋmumue gbo. 'A ‑wɔnnaanyʋ nyo wɛn 'o ‑wɔn lɛ a tɛɛ, 'nugba 'ɔ ‑hlo ꞊nʋ 'yi ke, 'ʋ 'kee 'a 'yiye. ");
INSERT INTO ted_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ʋ nɩ 'le yrayrɩ a lɛtɩta 'kwli 'mʋ, tii ‑do a ti 'yri, nahuiin 'hɔn, ‑ʋ pue ‑tɔplɩ pʋɔpʋɩ 'hʋɩn 'mʋ lɛ, 'ʋ 'hrɩɩ 'o ꞊nʋ 'hʋɩn 'mʋ. Nyɩsʋa a lɛleenyʋ'ʋ nɩ. ");
INSERT INTO ted_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Kɛ ʋʋ ꞊nʋ ye po: «Galilekʋɛ ‑a, dɛ‑ kɔ ‑tɩ 'a nɩ mɔ gbo, 'aa 'le yrayrɩ lɛ ta 'le? ‑Yusu mu 'le yakɔ 'mʋ nɩ. ‑Tɛ a nu 'a 'yiye, ɔ nu mumue, kɛ ɔ di 'le lele didie nu.» ");
INSERT INTO ted_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","‑Tɛ dɛ a ‑gbɛ, ɛ ‑hi, ‑ye ‑Yusu a ‑wɔnnaanyʋ a ‑gbɛ, ʋ ꞊tɩ 'le dʋgba ꞊nʋ 'lu nɩ, ‑ɔ kɔ 'lu ti nɩ 'le, ʋʋ olifie daa, 'ʋ mu 'le Jrusrɛ 'mʋ. ‑Hɔn 'le Jrusrɛ 'mʋ, ‑bo mu 'le dʋgba a ‑gbɛ 'lu, ɛ ‑wɛ 'le bɛ 'ya ‑kiloyɛ nɩ. ");
INSERT INTO ted_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","‑Tɛ ʋ nyre 'le, ‑ye 'ke ʋ 'ya 'le yrayrɩkayu ꞊nʋ 'klɔ, 'ʋ mu 'le ‑gblo ꞊nʋ ‑kɔ 'mʋ, ʋʋ ꞊ke 'le lɛ 'kukue. Nahuin, ‑ʋ nɩ ‑tuo ke, 'waa 'dʋɩ, ɩ nɩ‑ ‑gbo: Piɛlɩ, kɔ Saan, kɔ Sakɩ, kɔ Adre, kɔ Filipʋ, kɔ Toma, kɔ Batelemi, kɔ Matie, kɔ Alʋfe a 'yu Sakɩ, kɔ Simɔ, ‑ɔ nɩ la 'le nahuin ꞊nʋ ‑hɛyri, ‑ʋ 'nɩnɩ ‑hʋa Romakʋɛ, kɔ Sakɩ a 'yu Judɩ. ");
INSERT INTO ted_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nyrʋgbapʋ nɩ ‑wɛ 'le ꞊nʋ ‑hɛyri, ʋ kɔ Mari 'hɛɛn, ‑ɔ mɔ ‑Yusu a 'dii, ʋ kɔ ‑Yusu a 'dɩayuo nyɩbɛpʋ 'hɛɛn. Ʋ 'bii a ‑gbɛ, nʋ‑ʋ ꞊ke 'le ‑gblo a ‑gbɛ 'mʋ lɛ 'kukue, 'ʋʋ Nyɩsʋa da. ");
INSERT INTO ted_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","‑Nyrɔwɔ ꞊de 'mʋ, nahuin a ‑wlɩɩ ‑huonnɔ, nʋ‑ 'kukue lele lɛ, 'ke 'o Nyɩsʋa a dɩda ‑wɔn. ‑Tɛ ʋ nɩ 'klɛɛ 'o, ‑ye Piɛlɩ 'ba 'mʋ ye, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«‑Dɩayuo ‑a, ‑tɩ ꞊nʋ, ʋ 'crɩɩ la, 'ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ('ke 'o Judɩa a ‑ta 'mʋ,) ɩ kɔ bɩ mue 'lu ‑wɔn. 'Ɛ mɔ ‑tɛɛ, Nyɩsʋa a ‑Hihiu, 'ke ʋ naa la 'le bodɩɔ Dafidɩ 'mʋ, 'ɔ 'crɩɛ la, ‑ɛ mɔ, Judɩa, nɔ‑ di la ‑Yusu 'a yraanyʋ ye ya, ʋ 'muo la klɩ. ");
INSERT INTO ted_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judɩa a ‑gbɛ, ‑ɔ nu la 'yilɛnyredɛ, nɔ‑ ‑Yusu ‑ha 'le du 'mʋ, 'ke bɔ nu Nyɩsʋa a ‑kʋan, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ‑Yusu a ‑gbɛ, ɔ nu, 'ɔ ‑ha ‑wɛ 'le ‑a mʋ du 'mʋ, 'ke ‑ba nu Nyɩsʋa a ‑kʋan. ");
INSERT INTO ted_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","‑Tɛ Judɩa a ‑gbɛ, ɔ po ‑Yusu 'crɛnyʋ kwa, 'wliyɛ ꞊nʋ, ʋ 'pɛɛ o ꞊nɔ, nɛ‑ ɔ gba, 'ɔ ‑tɔ ‑ci, 'ke 'le ‑ci a ‑gbɛ 'kwli 'mʋ, 'ɔ ble 'le yrayrɩ, 'ɔ bi ꞊hlɔn, 'a 'kwli 'ɛ crɛ, 'a 'ŋmi 'ɩ ‑gblɛ lɛ. ");
INSERT INTO ted_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nahuin 'bii, ‑ʋ nɩ nɔ Jrusrɛ 'mʋ, dɛ a ‑gbɛ, ‑ɛ mue 'lu ‑wɔn, ʋ 'wɛn nɩ. Nɛ‑ nue, ‑ci a ‑gbɛ, 'ʋ nye Hakɛdama daa, 'ke 'le ‑Juukʋɛwin 'kwli 'mʋ, ‑ɛ ꞊hɛn 'nyrɛ dablo a ‑ci. ");
INSERT INTO ted_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","'Ɛ mɔ ‑tɛɛ, dɛ ʋ 'crɩɩ la, 'ke 'le Nyɩsʋa a ‑wlabrecrɩɩnɩɛ 'kwli 'mʋ, ɛ nɛ‑ ‑gbo: Nahuin bʋ hie 'o 'a kayu gbo, ꞊ɔ ꞊de nɩ nɩʋ 'le 'le gbo. 'Ya 'o lele 'lu, dɛ ‑ye, ʋ 'crɩɩ la, ɛ nɛ‑ ‑gbo: 'A ‑kʋan ꞊nʋ, ɔɔ la nu, ꞊ɔ ‑ye bɔ nuo! ");
INSERT INTO ted_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","'A ‑tɩ o, ‑a blɛ ye ‑ba ꞊mɔ nahuon lɛ, ‑ɔ di 'o Judɩa a ‑ta 'mʋ bi. Nahuon a ‑gbɛ, ɔ blɛ ye bɔ 'ya nahuon ꞊nʋ 'mʋ, ‑ɔ kɔ ‑a mʋ 'hɛɛn ꞊ke Kʋkɔnyɔ ‑Yusu ‑wɔn naa, kʋɛ la 'le ti ꞊nʋ 'yie 'mʋ gbo, ‑ɩ kɔ 'yri Saan po la 'o ‑Yusu 'nie 'lu, ‑bo yɛ ‑nyrɔwɔ ꞊nʋ ke, ‑ɔ kɔ 'mʋ Nyɩsʋa nue, ‑Yusu 'ɔ mu o yakɔ 'mʋ. Nahuon a ‑gbɛ, ɔ kɔ ‑a mʋ 'hɛɛn, ‑a 'mʋ ke bibi, ‑a 'mʋ nahuin le, ‑ɛ mɔ, ‑a yie nɩ, 'ke ‑Yusu ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, 'ɔ 'hrɩ 'klɔ.» ");
INSERT INTO ted_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","'Plɩɩ Piɛlɩ 'mʋ 'klɛɛ mu ‑yrɛ, ‑ye ʋ wa 'dʋ nahuiin 'hɔn. ꞊Ɔ ‑ye a 'dʋ mɔ Sosɛfʋ, ʋʋ Basabasɩ daa, 'ʋ nyo la lele Jutusɩ daa. ꞊Ɔ ‑ye a 'dʋ mɔ Matiasɩ. ");
INSERT INTO ted_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","‑Tɛ ʋ wʋ 'klɛɛ 'dʋ, ‑ye ʋ da Nyɩsʋa nɩ, ʋ nɔ: «Kʋkɔnyɔ o, ‑mɔ yi nahuin 'bii a ꞊wlɩ, tɔɔ ‑a mʋ nahuon ꞊nʋ, ‑n ‑ha 'le du 'mʋ, kɛ nɔ nahuiin 'hɔn ‑gbo ‑hɛyri, ");
INSERT INTO ted_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","'ke bɔ nu ‑Yusu a ‑wɔnnaanyɔ a ‑kʋan ꞊nʋ, Judɩa hie 'o gbo, 'ɔ mu 'le ‑tɛgbi ꞊nʋ, ɔ kɔ bɔ mu 'le.» ");
INSERT INTO ted_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","‑Tɛ ʋ ‑wɔ Nyɩsʋa a dɩda ‑wɔn, ‑ye ʋ po 'bla, 'bla a ‑gbɛ 'ɔ ‑ha Matiasɩ. Nɔ‑ɔ nɩ, ʋ po 'klɛɛ ‑Yusu a ‑wɔnnaanyʋʋ ‑pu ꞊tu 'o ‑do ꞊nʋ ke. ");
INSERT INTO ted_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Ɛ kɔ la ‑Juukʋɛ a lɛ'mimre ‑ye, 'ʋ nye Patɩkɔtɩ daa. ‑Tɛ lɛ'mimre a ‑nyrɔwɔ a ‑gbɛ, ɔ nyre 'o, ‑ye ‑Yusu a nahuin, ʋ 'kukue lɛ, 'ke 'o ‑tɛgbii ‑do, 'ke 'le Jrusrɛdɩɔ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","‑Tɛ ʋ nɩ 'klɛɛ 'o, ‑ye tii ‑do a ti 'yri, ʋ 'wɔn wintɛ, 'ɛ ‑hɔn 'le yakɔ 'mʋ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ pepe gblaka bɛ 'nɩnɩ ‑hi wɛn. Win a ‑gbɛ, ɩ 'yie 'le kayu 'bii ꞊nʋ nɩ, ‑ʋ kɔ gbo ʋ 'kukue 'le lɛ. ");
INSERT INTO ted_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","‑Ye ʋ 'ye ‑tɔplɩ ꞊nʋ, ‑ɩ 'we ꞊nɔ nahri ye, 'ɩ po ‑dodo, 'ɩ ꞊tɩɩ 'o ꞊nʋ 'lu lɛ. ");
INSERT INTO ted_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kɛ'ɛ nɩ, ɛ ‑ti 'mʋ, Nyɩsʋa a ‑Hihiu 'ʋ bi 'o nahuin 'bii a ‑gbɛ ke 'mʋ, nahuin a ‑gbɛ 'ʋ ‑tʋa dakʋ a win a gblegblei a pupue gbo, 'waa ‑gbɛ, ʋ 'de yi. Nyɩsʋa a ‑Hihiu a ‑gbɛ, nʋ‑ nue, 'ʋ po win a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","‑Ye 'klɛɛ, 'ke 'le Jrusrɛ 'mʋ, ɛ kɔ la ‑Juukʋɛ ꞊de, ‑ʋʋ Nyɩsʋa ‑wɔn kʋɛ. ‑Juukʋɛ a ‑gbɛ, nʋ‑ ‑hɔn la 'le 'blʋgbɩ a gblegblei 'kwli 'mʋ, ‑ɩ nɩ nɔ 'klɔ ke, 'ʋ di la Jrusrɛ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nahuin a ‑gbɛ, 'plɩɩ ʋ 'mʋ win a ‑gbɛ mu 'wɔn, 'waa 'dai dɛ 'ʋ ya 'le cigbɛi, 'ʋ 'kukue lɛ, 'ke 'o ‑tuo a ‑gbɛ ke. ‑Ye ʋ 'bii, ʋ saka nɩ, ‑ɛ nue, ʋʋ ‑Yusu a nahuin 'nɩ 'ye, 'ʋʋ 'briwiin a gblegblei po, 'plɩɩ 'ɛ nɩ nahuon, ‑ɔ di ‑tuo ke, 'ɔɔ 'a ‑gbɛ a 'briwin 'wɔn. ");
INSERT INTO ted_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɩ ka ꞊nʋ lɛ 'ŋmi 'dɔ, ʋ nɔ: «Nahuin ‑gbo, ‑ʋʋ 'prɛ, ʋ 'bii, 'ke ʋ kɔ 'le Galileblʋgba 'mʋ. 'Waa 'briwin mɔ ‑Juukʋɛwin. ");
INSERT INTO ted_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Dɛ‑ nye 'klɛɛ nu, 'ʋʋ ‑a nɩ 'briwiin po, ꞊a nyi 'wɔn 'le? ");
INSERT INTO ted_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","'Ke 'le ‑a mʋ ‑hɛyri nahuin nɩ nɔ, 'ʋ ‑hɔn 'le Patɩblʋgba 'mʋ, ꞊ʋ ‑ye 'ʋ ‑hɔn 'le Mɛdɩblʋgba 'mʋ, kɔ Elamʋ, kɔ Mesopotami, kɔ Sude, kɔ Kapadɔsɩ, kɔ Pɔn, kɔ Asi, ");
INSERT INTO ted_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","11","kɔ Flisi, kɔ Pafili, kɔ Esipʋblʋgba 'mʋ, kɔ Libi a 'blʋgba꞊tɩɔ ꞊nʋ 'mʋ, ‑ɔ 'mʋɛɛ Silɛnɩdɩɔ ye, kɔ Klɛtɩblʋgba kɔ Arabiblʋgba 'mʋ, ꞊ʋ ye 'ʋ ‑hɔn 'le Rɔmʋdɩɔ 'mʋ. ꞊Ʋ ‑ye nɩ nɔ ‑a mʋ ‑hɛyri, 'ʋ mɔ ‑Juukʋɛ. ꞊Ʋ ‑ye 'de ‑Juukʋɛ, kɛɛ ʋ ‑hɛ ‑Juukʋɛ. Kɛɛ, ‑a 'bii, ‑a nyi 'nɩ 'wɔn, ‑tɛ ʋʋ ‑a nɩ 'briwiin po, 'ʋʋ Nyɩsʋa a nunu‑tɔplɩ gblakɩ a ‑tɩ ‑wɔn lɛ na.» ");
INSERT INTO ted_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ʋ 'bii, ʋ saka nɩ 'dɔ, 'plɩɩ, dɛ bʋ di 'lu ‑wɔn lɛ ‑hie, ʋ 'nɩ 'ye ꞊le. Kɛ ʋʋ yrɛ pupo: «Dɛ tio‑ dɛ a ‑gbɛ, ɛ ꞊hɛn 'nyrɛ 'le?» ");
INSERT INTO ted_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kɛɛ, ꞊ʋ ‑ye nɩ 'o, 'ʋʋ ‑Yusu a nahuin 'caa, ʋ nɔ: «Nɔ'ɔ nɩ, ‑ɔ nyu nu.» ");
INSERT INTO ted_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Piɛlɩ kɔ 'a 'bienʋ ‑Yusu a ‑wɔnnaanyʋʋ ‑pu ꞊tu 'o ‑do ꞊nʋ, 'plɩɩ ʋ 'mʋ ‑tɩ a ‑gbɛ mu 'wɔn, ‑ye ʋ 'ba 'mʋ ye, Piɛlɩ 'ɔ 'yaa 'le win, 'ɔ 'tatɩ 'le nahuin ‑huohui ꞊nʋ, ‑ʋ nɩ 'o, a ‑wɔn'prɛɛlɛ gbo, ɔ nɔ: «'A mʋ ‑Juukʋɛ, 'dagbɩ kɔ Jrusrɛ 'mʋ a nahuin 'hɛɛn, ba po 'mʋ nʋa ye gbo, ‑tɩ 'n di ꞊tu, a 'mui 'wɔn. ");
INSERT INTO ted_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","'Ke 'le 'a mʋ ‑hɛyri, ꞊ʋ ‑ye nɔ 'nɩ, nahuin ‑gbo, nɔ nyu nu. Kɛɛ, ɛ 'de nɔ, ɔ 'nɩ nu ꞊le ꞊nʋ, ‑ɛ nue, 'yrʋ, nʋ‑ 'ya lɛ kɛ 'o. ");
INSERT INTO ted_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kɛɛ, ‑tɔplɩ ‑gbo, ‑ɩɩ 'klɛɛ 'lu ‑wɔn mue, Nyɩsʋa a winwlɔn‑hɛnyɔ Sʋɛlɩ ꞊tui la nɩ, 'a 'yrɩ ꞊gbʋgbɛ 'mʋ nɩ, ‑ɛ mɔ: ");
INSERT INTO ted_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nyɩsʋa nɔ 'nɩ, 'lelɛ'bɔɔti 'yri, ‑tɔplɩ ‑gbo, ‑ɩ di 'lu ‑wɔn mue, ɩ nɩ‑ ‑gbo: 'N di 'na ‑Hihiu dakʋ 'bii 'nɩ ‑nyi. 'A nɩ 'yuo꞊pli, ʋ di wlɔn ‑hɛ 'na win, ʋ 'mʋ ‑tɔplɩ 'ye, 'a nɩ kukunyʋ bi 'le ye, ʋ di po yain, 'ke 'o Nyɩsʋa a ‑tɔplɩ ke. ");
INSERT INTO ted_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","'Na ‑Hihiu di 'o 'na 'mʋ‑hɛnyʋ 'mʋ bi ke, nyɩbɛpʋ kɔ nyrʋ 'hɛɛn, ʋ 'mʋ 'na win wlɔn ‑hɛ. ");
INSERT INTO ted_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","'N die 'nɩ nu, 'ke 'le yrayrɩ kɔ kɛ nɔ ‑tʋtʋ ke, a 'mʋ ‑tɔplɩ 'ye, ‑ɩ di 'a mʋ saka. A di 'ye dablo, kɔ nahru, kɔ 'nyanyʋ 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","'Yrʋ di 'nɩ jre, ‑hɔpɔ di 'nɩ ꞊hlu, ‑ɛ 'we ꞊nɔ dablo ye, 'plɩɩ Kʋkɔnyɔ a ‑nyrɔwɔ 'mʋ 'o nyre, ‑ɔ mɔ ‑nyrɔwɔ gblaka ꞊nʋ, ‑ɔ kɔ 'mʋ ɔ di 'o 'a ‑tɩ 'yi 'bʋaa. ");
INSERT INTO ted_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ti a ‑gbɛ 'yri, nahuon 'bɔ nɩ 'o, 'bɔ di Kʋkɔnyɔ a ‑gbɛ da, ‑ye Kʋkɔnyɔ, ɔ dio 'nɩ waa.» ");
INSERT INTO ted_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Kɛ Piɛlɩɩ lele po: «Yisraɛkʋɛ ‑a, ba po 'mʋ nʋa ye gbo: Nasalɛtɩ 'mʋ a ‑Yusu, Nyɩsʋa, nɔ‑ loo nɔ 'a mʋ ‑hɛyri, 'ɔ nɔɔ 'le 'mʋ, 'ɔ nu 'ŋmilɛka‑tɔplɩ a gblegblei, 'ke 'le 'a mʋ ‑hɛyri, ‑ɛ die nu, a 'mui yi, ‑ɛ mɔ Nyɩsʋa, nɔ‑ loo nɔ 'a mʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kɛɛ, ‑Yusu a ‑gbɛ, ʋ puo 'a mʋ kwa, 'a naa 'le Romakʋɛ 'mʋ, ‑ʋ 'de Nyɩsʋa yi, 'a kʋɔ 'o tu 'yie 'mʋ, ‑ɛ die nu, a 'muo 'la. Kɛɛ, ‑tɔplɩ a ‑gbɛ, Nyɩsʋa, nɔ‑ ‑hʋɩ la, nɔ‑ ‑hii la 'lu ‑wɔn lɛ, ti ‑hi la a ti 'yri, 'plɩɩ, 'ɩ mue o 'lu ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","‑Tɛ ‑Yusu 'kʋ, Nyɩsʋa ‑hɩɔ 'le 'kʋkʋɛ a 'klɩ gbo nɩ, 'ɔ ‑hɩɔ 'klɔ, ‑ɛ nue, ɛ 'die 'le ‑wɛ, 'kʋkʋɛ bɛ kʋɔ 'klɩ ke. ");
INSERT INTO ted_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","'Ɛ mɔ ‑tɛɛ, kɛ ‑a nɩ bu gblaka bodɩɔ Dafidɩ po la, 'ke 'o ‑Yusu a ‑ta 'mʋ, ɔ nɔ: Kʋkɔnyɔ Nyɩsʋa, 'n nyo 'nɩ 'ye 'ɛ nɩ ti. 'Ke ɔ nɩ 'o 'mʋ 'hʋɩn 'mʋ, ‑ɛ die nu, 'nɩ ꞊han hʋannʋ pɩ. ");
INSERT INTO ted_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nɛ‑ nue, 'nɩ kɔ plɔ a bleelɛ, kɔ, 'na wintɛ 'ɛ mɔ 'manʋwin. ꞊Betɩ ꞊bo di 'kʋ, 'nɩ pɩ ꞊le 'kʋkʋɛ a hʋannʋ, ‑ɛ nue, 'n yie nɩ, ‑ɛ mɔ, Nyɩsʋa di 'mʋ 'mʋ nu ꞊hapʋdɛ, ");
INSERT INTO ted_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","'nɩ yie ‑wɛ, ‑ɛ mɔ, ‑mɔ Nyɩsʋa, ‑n 'deɛ ‑bo hie 'le 'mʋ 'kuopʋ a 'bri gbo, kɔ, ‑n 'deɛ ‑bo wɛɛn ke, 'ke 'na ‑plahʋɩn bɩ ꞊hɔɔn 'le 'dɛɛ wlɔn, 'mɔ ‑gbo, ‑ɔ mɔ ‑na nahuon. ");
INSERT INTO ted_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","‑N tɔɔ 'mʋ 'hru nɩ, 'n kɔ ꞊bo na, 'plɩɩ 'mʋ ꞊hapʋ'klɔ kɔ. 'Ke ‑n di 'o 'mʋ 'hʋɩn 'mʋ nɩ. Nɛ‑ die nu, 'mʋ 'manʋ nu 'dɔ.» ");
INSERT INTO ted_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","‑Ye Piɛlɩ nɔ lele: «'Na ‑dɩayuo ‑a, ba kɔ 'a yiyie, ‑tɩ ꞊nʋ, ‑a nɩ bu gblaka bodɩɔ Dafidɩ ꞊tu la, ɔ 'de la 'a dɩɔnʋ 'nyrɛ ꞊hɛn, ‑ɛ nue, ɔ 'kʋ la nɩ, 'ʋ ‑hɩɔ la 'o. 'A 'dɛɛ 'kɩɛ nɩɛ nɔ ‑a 'bri. ");
INSERT INTO ted_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kɛɛ, Dafidɩ a ‑gbɛ, ɔ mɔ la Nyɩsʋa a winwlɔn‑hɛnyɔɔ nɩ, 'plɩɩ 'ɔ yie la, ‑ɛ mɔ, Nyɩsʋa 'sʋɛ la ke, 'ke Dafidɩ a ‑gbɛ a 'yuo a 'yu ‑ye di la ‑hɛ bodɩɔ gblaka, ‑ɔ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'a dakʋ ye ya. ");
INSERT INTO ted_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","‑Tɛ Dafidɩ ꞊tui la, ‑ɛ mɔ: Nyɩsʋa, ‑n 'deɛ ‑bo hie 'le 'mʋ 'kuopʋ a 'bri gbo, kɔ, ‑n 'deɛ ‑bo wɛɛn ke, 'na ‑plahʋɩn bɩ ꞊hɔɔn 'le 'dɛɛ wlɔn, ‑tɛ Dafidɩ ꞊tu la ‑tɩ a ‑gbɛ, ‑Yusu 'Klɩsʋ bɔ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ, bɔ 'hrɩ 'klɔ, nɛ‑ ɔ 'ye la, 'ɔ nɩ la ‑wɔn lɛ. ");
INSERT INTO ted_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","‑Yusu ‑gbo, ‑ɔ kɔ ‑tɩ 'nɩɩ ꞊tu, Nyɩsʋa ‑hɩɔ 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ ‑hɩɔ 'klɔ. Dɛ a ‑gbɛ, ‑a 'bii ‑gbo, ‑ʋ nɩ mɔ, ‑a 'ye nɩ, ꞊a nyi ꞊tu. ");
INSERT INTO ted_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","'Plɩɩ dɛ a ‑gbɛ, ɛ 'mʋ mu ‑hi, Nyɩsʋa nue nɩ, ‑Yusu 'ɔ mu yakɔ 'mʋ, 'ɔ nɩ 'o ꞊nɔ 'hʋɩn 'mʋ, Nyɩsʋa a ‑gbɛ 'ɔ ‑nyi ꞊nɔ 'klɩ, 'ke bɔ ya ‑a mʋ Nyɩsʋa a ‑Hihiu ye, Nyɩsʋa po la lɛ, ɔ di la ‑a mʋ ye ya, 'ɛ mɔ ‑tɛɛ, ‑Hihiu a ‑gbɛ, 'ɔ yʋ ‑a mʋ ye, ‑ɛ 'we ꞊nɔ ye, ‑tɛ aa 'a 'yiye nu, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo. ");
INSERT INTO ted_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","‑Tɛ ‑Yusu nu, 'ɔ 'hrɩ 'klɔ, 'ɔ mu yakɔ 'mʋ, Dafidɩ a ‑gbɛ, ɔ 'de la lɛ nu. Kɛɛ, ‑Yusu'u nɩ, Dafidɩ ꞊hɛn 'nyrɛ, 'ɔ po la lɛ: Kʋkɔnyɔ Nyɩsʋa, ɔ le 'na Kʋkɔnyɔ nɩ, ‑ɛ mɔ: Nɩ mɔ 'na diidɛpɩa ke gbo, ‑n kɔ 'mʋ 'hɛɛn, ‑a 'mʋ nahuin win ke kɔɔ, ɛ 'mue gba ‑gbagba, ");
INSERT INTO ted_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","'mue nu, ꞊mʋ ‑na yraanyʋ bʋɩ 'lu gblɛ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Kɛ Piɛlɩɩ lele po: «'A mʋ Yisraɛkʋɛ 'bii, 'nɩɩ 'a mʋ 'nɩ le: ‑Yusu ‑gbo, a kɔɔ o 'o tu 'yie 'mʋ, nɔ‑ Nyɩsʋa nuu ‑a nɩ Kʋkɔnyɔ kɔ ‑a nɩ Waanyɔ 'hɛɛn 'mʋ.» ");
INSERT INTO ted_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nahuin ꞊nʋ, ‑ʋ nɩ 'o, bʋ 'wɔn win a ‑gbɛ, ‑ye ɩ 'tʋ 'waa ꞊wlɩ lɛ 'dɔ, 'ʋʋ Piɛlɩ kɔ ‑Yusu a ‑wɔnnaanyʋ ‑ye ꞊nʋ 'hɛɛn wlɔn ꞊gba, ʋ nɔ: «'Dɩayuo ‑a, dɛ tio‑ ‑a di 'klɛɛ nu 'le?» ");
INSERT INTO ted_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","‑Ye Piɛlɩ ꞊tu ‑wɔn, ɔ nɔ: «'Ɛ nɩ nahuon 'bɔ nɩ 'o, bɔ hie 'o 'a dɛ 'kuku gbo, bɔ ‑nyi 'a 'klɔ 'bii Nyɩsʋa, bɔ ‑hʋɛ, 'ke bʋ puo 'nie 'lu, 'ke 'le ‑Yusu 'Klɩsʋ a 'dʋ 'kwli 'mʋ, ‑ɛ die nu, Nyɩsʋa 'mʋ 'a dɛ 'kuku a ‑gbɛ 'wʋwla, 'plɩɩ ɔ 'muo 'a ‑Hihiu ‑nyi. ");
INSERT INTO ted_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nɛ‑ mɔ dɛ, Nyɩsʋa po la lɛ, ɔ di la nu, 'ke 'o 'a mʋ ‑wɔn, kɔ 'ke 'o 'a nɩ 'yuo꞊pli ‑wɔn, kɔ 'ke 'o nahuin ꞊nʋ ‑wɔn, ‑ʋ nɩ nɔ 'klɔ 'bii ‑gbo ke, ‑ɛ ꞊hɛn 'nyrɛ, nahuin 'bii ꞊nʋ, Nyɩsʋa di da, ʋ 'mʋ 'a nahuin ‑hɛ.» ");
INSERT INTO ted_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piɛlɩ ꞊tu ‑tɩ 'plɔplɔ ‑ye, ‑ɛ die nu, ʋ 'muo ‑tɛɛ pue, ɔ nɔ: «Ba wɛɛn ke, 'ke Nyɩsʋa bɔ waa 'a mʋ, 'a ‑bati 'nɩ ꞊han 'a mʋ klɩ, ‑ɛ 'we ꞊nɔ ye, ‑tɛ ɩ di nu, ɩ 'mʋ nahuin ꞊nʋ klɩ, ‑ʋʋ dɛ 'kuku nu.» ");
INSERT INTO ted_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nahuin 'plɔplɔ 'ke 'le ꞊nʋ ‑gbahlɔn, ʋ po Piɛlɩ a win ‑tɛɛ, 'plɩɩ nahuin a ‑gbɛ, 'ʋ pu 'nie 'lu lɛ. ‑Nyrɔwɔ a ‑gbɛ 'kwli 'mʋ, nahuin, ‑ʋ bi ‑Yusu a nahuin ke, ʋ ‑wɛ 'le nahuin a 'milowɩɩ ta nɩ. ");
INSERT INTO ted_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","'Ɛ nɩ ti, nahuin a ‑gbɛ, ʋ nye lɛ 'nɩ ꞊mɔ, 'ke ‑Yusu a ‑wɔnnaanyʋ bʋ tɔɔ ꞊nʋ Nyɩsʋa a ‑tɩ, 'ʋʋ dɛ ‑wɔn didi, 'ʋʋ ‑wɛ ‑Yusu a 'lelɛ'bɔɔdididɛ di, 'ʋʋ Nyɩsʋa da. ");
INSERT INTO ted_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","'Ɛ nɩ nahuon 'bɔ nɩ 'o, ɔɔ pɩ Nyɩsʋa, ‑ɛ nue, 'ke Nyɩsʋaa 'le ‑Yusu a ‑wɔnnaanyʋ 'mʋ naa, 'ɔɔ 'ŋmilɛka‑tɔplɩ 'plɔplɔ nu. ");
INSERT INTO ted_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nahuin 'bii, ‑ʋ kuo ‑Yusu ꞊wlʋ ye, ʋ ‑mʋɛ nɩ, ‑tɔplɩ 'bii, ʋ kɔ, 'ʋ nyi 'mʋ lɛ wuwoo, ");
INSERT INTO ted_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","'ʋʋ 'waa kʋkɔ‑tɔplɩ plo, 'ʋʋ 'le 'a 'wliyɛ ꞊nʋ ‑ha, 'ʋ nye nahuin 'mʋ lɛ woo, 'ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɛ 'a 'kla‑wliye'yɩya ‑ti 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","'Ɛ nɩ ‑nyrɔwɔ, 'ke ʋʋ 'le Nyɩsʋa a 'kagblaka gblɛ 'kukue, 'ke 'o 'a dɩda ‑wɔn, 'ʋʋ ye gblɛ bibi, 'ke 'le 'waa kayuo gbo, 'ʋʋ ‑Yusu a 'lelɛ'bɔɔdididɛ di, kɔ, 'ʋʋ didi‑tɔplɩ ‑wɔn didi, 'ke 'le ꞊wlʋ a 'ogbo'wlɛɛlɛ 'kwli 'mʋ, ");
INSERT INTO ted_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","'ʋʋ Nyɩsʋa baa, dakʋ 'bii 'ʋ nʋɛ 'waa dɛ 'mʋ, kɔ, 'ɛ nɩ ‑nyrɔwɔ, Nyɩsʋa 'ɔ nye nu, nahuin ‑ye 'ʋʋ ‑Yusu ꞊wlʋ ye kuo, nahuin a ‑gbɛ 'ʋʋ ‑Yusu a nahuin ke bi. ");
INSERT INTO ted_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","‑Nyrɔwɔ ꞊de 'mʋ, 'yrʋ‑hiilɛ a ti 'yri, ‑tɛ Nyɩsʋa a dɩdati nyre 'o, Piɛlɩ kɔ Saan 'hɛɛn, 'ʋʋ 'le Nyɩsʋa a 'kagblaka gbo mu, ʋ 'muo da. ");
INSERT INTO ted_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nyɩsʋa a 'kagblaka a ‑gbɛ a ‑yaa, ɔ kɔ 'maju ‑ye, 'ʋ nyu 'Yilɛnɔmaju daa. 'Ke lɛ‑yɩyrɛnyɔ ꞊de nɩ 'o gbo. Kʋɛ la 'le 'a kʋɛlɛ 'yie 'mʋ gbo, ɔ 'de ‑hlɩn a nɛɛ. 'Ɛ nɩ ‑nyrɔwɔ, ʋ nyo 'le 'nɩ ya, 'ʋ nyo 'o ‑tɛgbi a ‑gbɛ gbo ꞊tu, ‑ɛ die nu, nahuin ꞊nʋ, ‑ʋʋ 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ pa, ɔ 'mʋ ꞊nʋ 'wli lɛ ‑hʋa. ");
INSERT INTO ted_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","'Ke ɔ nɩ 'klɛɛ 'o gbo, Piɛlɩ kɔ Saan 'hɛɛn, 'ʋʋ 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ mu pa. Bɔ 'yu 'klɛɛ, ‑ye ɔ nyu ‑hʋa 'wliyɛ, ");
INSERT INTO ted_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piɛlɩ kɔ Saan 'hɛɛn, 'ʋ nyo 'ye, ‑ye Piɛlɩ nɔ: «Ta nɔ ‑a mʋ ‑wɔn lɛ!» ");
INSERT INTO ted_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","lɛ‑yɩyrɛnyɔ a ‑gbɛ 'ɔ ‑tʋa 'waa 'yiye gbo. Ɔ ‑mɛ ‑ye, 'a ꞊wlʋ nɔ 'nɩ, Piɛlɩ nʋ dio ‑nye dɛ ꞊de. ");
INSERT INTO ted_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","‑Ye kɛ Piɛlɩ nyo 'klɛɛ lele ye po, ɔ nɔ: «'N 'de 'wli kɔ. Kɛɛ, dɛ 'n kɔ, 'n die ‑mʋ 'nɩ ‑nye: 'Ke 'le Nasalɛtɩ 'mʋ a ‑Yusu 'Klɩsʋ a 'dʋ 'kwli 'mʋ, 'nɩɩ ‑mʋ 'nɩ le, 'ba ye 'mʋ, ‑bo na!» ");
INSERT INTO ted_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piɛlɩ 'ɔ 'ble 'a diidɛdabʋ kwa, 'ɔ 'bɔ ye 'mʋ. Tii ‑do a ti 'yri, 'a bʋɩ kɔ 'a ‑hɛkɛi 'hɛɛn, ‑ɩ 'kʋ o, ɩ kɔ 'klɛɛ 'klɩ, ");
INSERT INTO ted_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","'ɔ 'ya yrayrɩ, 'ɔ nyra gbo, 'plɩɩ 'ɔ ‑tʋa nɩna gbo, ɔ kɔ Piɛlɩ kɔ Saan 'hɛɛn, 'ʋ pa 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ɔɔ na, 'ɔɔ ꞊plu, kɔ, 'ɔɔ Nyɩsʋa baa. ");
INSERT INTO ted_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'yo nɩ, ‑tɛ ɔɔ na, kɔ, ‑tɛ ɔɔ Nyɩsʋa baa. ");
INSERT INTO ted_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","‑Tɛ ʋ yroo 'klɛɛ, ‑ɛ mɔ, nɔ‑ɔ nɩ, ‑ɔɔ o 'o Nyɩsʋa a 'kagblaka a 'maju 'yri gbo nɩ, ‑ɔɔ nahuin 'wli lɛ ‑hʋa, ‑ye ʋ 'bii, ʋ ta 'mʋ gblɛ, 'ɩ saka ꞊nʋ, 'ke 'o dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, 'ke 'o ꞊nɔ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nahuon a ‑gbɛ, ‑ɔ kɔ 'kʋɛ ‑wɛ, ɔ 'nɩ ‑hɔn ꞊le 'o Piɛlɩ kɔ Saan 'hɛɛn 'hʋɩn 'mʋ. 'Ke ʋ nɩ 'le Nyɩsʋa a 'kagblaka a papʋɛ ꞊nʋ gbo, ʋʋ Salomɔ a papʋɛ daa. ‑Ye nahuin 'bii ꞊nʋ, ‑ʋ 'wɔn ‑tɩ a ‑gbɛ, ɩ saka ꞊nʋ nɩ, 'ʋ gba 'le cigbɛi. ");
INSERT INTO ted_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","'Plɩɩ Piɛlɩ 'mʋ dakʋ ꞊nʋ mu 'ye, ‑ʋ di 'le, ‑ye kɛ ɔɔ ꞊nʋ ye po, ɔ nɔ: «'A mʋ Yisraɛkʋɛ, ɩ nɩ saka 'le 'a mʋ, ‑tɛ nahuon ‑gbo a 'kʋɛ ‑wɛ a ‑tɩ. ꞊Be a nye ‑wɔn lɛ ‑hie 'lu, ‑ɛ mɔ, ‑a nɩ 'klɩɩ nɩ, kɔ, ‑ba 'ya ‑tɛɛ a Nyɩsʋa a nahuin 'mʋ, nɛ‑ nue, nahuon ‑gbo, ‑ɔ 'de ꞊ke nalɛ yi, 'ɔ yi nalɛ? ");
INSERT INTO ted_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","'Ʋʋn, ɛ 'de lɛ 'mʋ nɩ. Kɛɛ, Nyɩsʋa ꞊nʋ, ‑a nɩ bunʋ Abrahamʋ, kɔ Yisakɩ, kɔ Sakɔbʋ 'hɛɛn, ʋʋ la da, ʋ kɔ ‑a nɩ bunʋ ‑ye 'hɛɛn, Nyɩsʋaa ‑do a ‑gbɛ, nɔ‑ ‑nyi 'a ‑kʋannunyɔ ‑Yusu ‑tɩ a 'yi'bʋaalɛ. Ɛ nɛ‑ nue, nahuon ‑gbo a 'kʋɛ 'ɛ ‑wɛ. ‑Yusu a ‑gbɛ, 'a mʋ puo o Romakʋɛ kwa, 'plɩɩ, 'waa ‑gʋlʋnʋma Pilatɩ 'ɔ puo o ‑bati lɛ, 'ɔ plɛ, ɔ 'muo o gbo tɛ, kɛɛ, a ‑mɛ ‑ye, 'a puo ‑tɩ 'lu lɛ, 'a plɛ, ‑Yusu mɔ ‑balʋnyɔ'ɔ nɩ, Pilatɩ nɩ tɩɔ 'le gbo, bɔ 'lɔ. ");
INSERT INTO ted_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kɛɛ, ‑Yusu a ‑gbɛ, ɔ ‑nyi 'a dɩɔnʋ 'bii Nyɩsʋa, 'ɔ 'sii 'o ye, 'ke 'o Nyɩsʋa ye. Kɛɛ, a ‑mɛ ‑ye, a 'nɩ ‑hʋa ꞊le o, 'ke Pilatɩ bɔ tɩɔ o gbo, kɛɛ, ‑balʋnyɔ ꞊de, ‑ɔ nɩ o 'le ꞊jɩ 'mʋ, nɔ‑ a ‑hʋa o Pilatɩ a ‑gbɛ, bɔ tɛ o gbo, ‑Yusu 'mʋ o 'o ‑balʋnyɔ a ‑gbɛ a ꞊pɩ 'mʋ bi. ");
INSERT INTO ted_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kɛ'ɛ nɩ, a nu, 'a 'la o ‑Yusu ꞊nʋ, ‑ɔ nye nu, nahuin 'ʋʋ 'klɔ yrayrʋ kɔ, ‑ɔ 'nɩnɩ ‑wɛ 'le. Kɛɛ, Nyɩsʋa ‑hɩɔ o 'le 'kʋkʋnyʋ ‑hɛyri nɩ, 'ɔ ‑hɩɔ o 'klɔ. ‑Tɛ ‑Yusu 'hrɩ o 'klɔ, ‑a nɩ ‑gbɛ, ‑a 'yo o nɩ. ");
INSERT INTO ted_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nahuon ‑gbo, a yi, 'plɩɩ ‑ɔ nyra nɔ 'a mʋ ye gbo, ‑tɛ ‑a kuo ‑Yusu a ‑gbɛ ꞊wlʋ ye, nɛ‑ nue, ‑Yusu a ‑gbɛ 'ɔ nue, 'ɔ yi 'klɛɛ nalɛ. ‑Yusu a ‑gbɛ, nɔ‑ nue, 'plɩɩ nahuon ‑gbo, 'ɔ kuo ꞊wlʋ ye, ‑Yusu 'ɔ ‑wɔ 'a 'kʋɛ. Nɛ‑ aa 'klɛɛ 'ye. ");
INSERT INTO ted_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‑Ye 'klɛɛ, ‑dɩayuo ‑a, 'n yie nɩ, ‑ɛ mɔ, a bi 'le ye, a kɔ 'a nɩ nyɩgblakɩ 'hɛɛn, dɛ ꞊nʋ, a nu ‑Yusu 'mʋ, a 'die yi. ");
INSERT INTO ted_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kɛɛ, ‑tɛ a 'la ‑Yusu, dɛ ꞊nʋ, Nyɩsʋa naa la 'le 'a winwlɔn‑hɛnyʋ 'bii wlɔn, ʋ na la ‑wɔn lɛ, dɛ a ‑gbɛ, Nyɩsʋa nue nɩ, 'ɛ nyre 'o. Ɛ nɛ‑ mɔ: Waanyɔ ꞊nʋ, ɔ po la lɛ, ɔ di la 'a dakʋ ye ya, Waanyɔ a ‑gbɛ, ɔ kɔ bɔ 'ye ꞊sʋɛ, 'plɩɩ ɔ 'mʋ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","'A ‑tɩ o, ba hie 'o 'a nɩ dɛ 'kuku gbo, ba ‑nyi 'a nɩ 'klɔ 'bii Nyɩsʋa, ‑ɛ die nu, ɔ 'mʋ 'a nɩ dɛ 'kuku a ‑gbɛ 'wʋwla, ");
INSERT INTO ted_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","'plɩɩ Kʋkɔnyɔ Nyɩsʋa a ‑gbɛ, ɔ 'mue nu, a 'mʋ plɔ a bleelɛ kɔ, kɔ, ɔ 'mʋ 'a mʋ ‑Yusu ye ya, ‑ɔ mɔ Waanyʋ ꞊nʋ, ɔ ‑ha la 'le du 'mʋ, si la a ti 'yri, 'ke 'o 'a nɩ ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, ‑Yusu 'kɩɛ die 'le yrayrɩ nɩ, ɛ 'mue gba ‑gbagba, ti ꞊nʋ 'mʋ 'o nyre, ‑ɩ kɔ 'yri Nyɩsʋa di 'o ‑tɔplɩ yrayrɩ nuu. ‑Tɩ a ‑gbɛ, Nyɩsʋa ꞊tui la 'a winwlɔn‑hɛnyʋ wlɔn, 'ʋ ꞊tui la, ti ꞊de ‑hi la a ti 'yri. ");
INSERT INTO ted_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","'Ɛ mɔ ‑tɛɛ, kɛ Nyɩsʋa a winwlɔn‑hɛnyɔ Moise po la, ɔ nɔ: Kʋkɔnyɔ Nyɩsʋa di ‑ha winwlɔn‑hɛnyɔ, 'ke 'le ‑a nɩ dakʋ ‑hɛyri, ɔ 'mʋ 'mʋ ye 'we. ‑Tɩ 'bii ꞊nʋ, ɔ di ꞊tu, ba pui nʋa ye gbo. ");
INSERT INTO ted_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Nahuon 'bɔ nɩ 'o, 'bɔ 'nɩnɩ di winwlɔn‑hɛnyɔ a ‑gbɛ nʋa ye gbo po, ʋ blɛ ye bʋ ‑hɩɔ 'le dakʋ ‑hɛyri, ʋ 'muo 'la. ");
INSERT INTO ted_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kʋɛ la 'le Nyɩsʋa a winwlɔn‑hɛnyɔ Samuɛlɩ ‑wɔn gbo, kɔ winwlɔn‑hɛnyʋ ‑ye, ‑ʋ kʋɛ 'o ꞊nɔ ‑wɔn, ‑tɩ ‑gbo, ‑ɩɩ kɛ 'lu ‑wɔn mue, ʋ 'bii, ʋ ꞊tui la nɩ. ");
INSERT INTO ted_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","‑Tɩ ꞊nʋ, Nyɩsʋa naa la 'le 'a winwlɔn‑hɛnyʋ wlɔn, ʋ ꞊tu la, 'a mʋ kɔ ‑tɩɩ nɩ, 'ʋ ꞊tui la. 'Yrɩ ꞊nʋ, Nyɩsʋa ꞊tue la, ɔ kɔ 'a nɩ bunʋ 'hɛɛn, 'a mʋ kɔ ‑tɩɩ nɩ ‑wɛ, 'ɔ ꞊tue la 'yrɩ a ‑gbɛ. 'Ɛ mɔ ‑tɛɛ, kɛ ɔɔ la Abrahamʋ ye po, ɔ nɔ: 'Ke 'n di 'le ‑na 'yuo a 'yuo 'mʋ naa, 'mʋ 'klɔ ‑gbo a dakʋ 'bii ꞊hapʋdɛ 'mʋ nu. ");
INSERT INTO ted_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","'A mʋ mɔ ye‑hɛnahuin, 'a mʋ kɔ ‑tɩ Nyɩsʋa 'ɔ ‑ha 'le 'a 'mʋ‑hɛnyɔ ‑Yusu 'kʋkʋnyʋ ‑hɛyri, 'ɔ ‑hɩɔ 'klɔ, ‑ɛ die nu, ɔ 'mʋ 'a mʋ ꞊hapʋdɛ 'mʋ nu. ꞊Hapʋdɛ a ‑gbɛ, nɛ‑ mɔ, bɔ ‑hɛ 'a mʋ 'mʋ, ba hie 'o 'a nɩ dɛ 'kuku gbo.» ");
INSERT INTO ted_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piɛlɩ kɔ Saan 'hɛɛn, ‑ʋ mɔ 'klɛɛ ‑Yusu a ‑wɔnnaanyʋ, bʋ nɩ 'le dakʋ a 'le‑wɔn'prɛɛlɛ 'kwli 'mʋ, ‑ye Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblakɩ, nʋ‑ nyre 'o, ʋ kɔ Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ a nyɩgblakɩ, ʋ kɔ Sadusɩ꞊tumu a nahuin ‑ye 'hɛɛn. (Sadusɩ꞊tumu a nahuin a ‑gbɛ, nʋ‑ nyi ꞊tu, ‑ɛ mɔ, ɛ 'die 'le ‑wɛ, ‑tʋnahuon 'bɔ 'kʋ, 'plɩɩ Nyɩsʋa bɔ ‑hɩɔ 'le 'kʋkʋnyʋ ‑hɛyri, bɔ ‑hɩɔ 'klɔ.) ");
INSERT INTO ted_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","‑Juukʋɛ a nyɩgblakɩ a ‑gbɛ, ‑ʋ di 'le, ʋ 'de plɔ a bleelɛ kɔ, ‑ɛ nue, ‑Yusu a ‑wɔnnaanyʋ a ‑gbɛ, ʋ nye dakʋ 'nɩ tɔɔ, ‑ɛ mɔ, Nyɩsʋa, ɔ ‑ha 'le ‑Yusu 'kʋkʋnyʋ ‑hɛyri nɩ, 'ɔ ‑hɩɔ 'klɔ, ɛ ꞊hɛn 'nyrɛ, ɛ ‑wɛ 'le ꞊le, ‑tʋnahuon 'bɔ 'kʋ, Nyɩsʋa bɔ ‑hɩɔ 'le 'kʋkʋnyʋ ‑hɛyri, ɔ 'muo 'klɔ ‑ha. ");
INSERT INTO ted_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","‑Tɛ ‑Juukʋɛ a nyɩgblakɩ a ‑gbɛ, ʋ nyre 'klɛɛ 'o, tii ‑do a ti 'yri, ‑ye ʋ klɩ ‑Yusu a ‑wɔnnaanyʋʋ 'hɔn a ‑gbɛ nɩ. 'Tɔ bɔ ‑wɔn a ‑tɩ, 'ʋ 'diu ‑bati lɛ poo, 'ʋ pu ꞊jɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Kɛɛ ‑ye nahuin 'plɔplɔ ꞊nʋ, ‑ʋ 'wɔn ‑Yusu a ‑tɩ, 'waa 'dai dɛ kuo ‑Yusu ye ꞊wlʋ, 'ʋ bi ‑Yusu a nahuin ke. Nɛ‑ nue, 'ke 'le ‑Yusu a nahuin 'bii ‑hɛyri, 'ʋ ‑wɛ kɛ 'le nyɩbɛpʋ a 'milowɩɩ ꞊hun. ");
INSERT INTO ted_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","‑Tɛ ‑nyrɛ cɛ lɛ, ‑ye ‑Juukʋɛ a nyɩgblakɩ, kɔ Nyɩsʋa a teteitɔɔnyʋ 'hɛɛn, ‑ʋ nɩ 'le Jrusrɛdɩɔ 'mʋ, nʋ‑ 'kukue lɛ, ʋ 'mʋ ‑Yusu a ‑wɔnnaanyʋ a ‑gbɛ ‑bati lɛ poo. ");
INSERT INTO ted_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka, ‑ɔ kɔ 'dʋ mɔ Hanɩ, ɔ nɩ ‑wɛ ke ‑tuo, ɔ kɔ Kaifʋ, kɔ Saan, kɔ Alɛsadrɩ, kɔ Hanɩ a ‑gbɛ a ꞊tugba a nahuin ‑ye 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","‑Tɛ ʋ 'bii a ‑gbɛ, ʋ ‑wɛ 'klɛɛ ti ke, ‑ye ʋ le nahuin, 'ke bʋ ya ꞊nʋ ‑Yusu a ‑wɔnnaanyʋʋ 'hɔn ꞊nʋ ye. ‑Tɛ ʋ nyre 'klɛɛ 'le ꞊nʋ ‑hɛyri, ‑ye nyɩgblakɩ a ‑gbɛ, ʋ nyu wlɔn 'nɩ ꞊gba: «Nahuon tio‑ ‑nye 'a mʋ 'klɩ, kɔ, nahuon tio‑ le 'a mʋ, 'ke ba nue, lɛ‑yɩyrɛnyɔ ꞊nʋ bɔ na 'le?» ");
INSERT INTO ted_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","‑Ye Piɛlɩ a ‑gbɛ, Nyɩsʋa a ‑Hihiu kɔɔ win ke 'bii, kɛ ɔɔ 'klɛɛ po, ɔ nɔ: «'A mʋ dakʋ a ye'mʋnaanyʋ, 'a mʋ nyɩgblakɩ, ");
INSERT INTO ted_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","aa kɛ ‑a mʋ lɛ poo ‑bati, 'aa kɛ ‑a mʋ wlɔn ꞊gba, 'ke 'o ꞊hapʋdɛ ꞊nʋ, ‑a nu a ‑ta 'mʋ, 'ke 'o lɛ‑yɩyrɛnyɔ ‑gbo ‑wɔn. ‑Tɛ aa ‑a mʋ wlɔn ꞊gba, ");
INSERT INTO ted_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","'a mʋ ‑gbo, a kɔ dakʋ 'bii, ‑ʋ mɔ Yisraɛkʋɛ 'hɛɛn, ba kɔ 'a yiyie: Nahuon ‑gbo, ‑ɔ nɩ mɔ 'a mʋ ye, ‑ɔ kɔ 'kʋɛ ‑wɛ, Nasalɛtɩ 'mʋ a ‑Yusu 'Klɩsʋ, nɔ‑ kɔ 'klɩ nue, 'a 'kʋɛ a ‑gbɛ 'ɛ ‑wɛ. ‑Yusu a ‑gbɛ, nɔ‑ɔ nɩ, a kɔɔ 'o tu 'yie 'mʋ, a 'la. Nɔ‑ɔ nɩ, Nyɩsʋa ‑ha 'le 'kʋkʋnyʋ ‑hɛyri, ɔ ‑ha 'klɔ. ");
INSERT INTO ted_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","'Ke 'le Nyɩsʋacrɩɩnɩɛ 'kwli 'mʋ, ʋ 'crɩɩ la ‑tɩ, 'ke 'o ‑Yusu a ‑ta 'mʋ. ‑Tɩ ꞊nʋ, ʋ 'crɩɩ la, ɩ nɩ‑ ‑gbo: 'Katuo ꞊nʋ, 'a mʋ kayuponyʋ, a 'de ‑hʋa ba nuu ‑kʋan 'yri, a po gbo, nɔ‑ ‑hɛ 'katuo gblaka. Nɔ‑ nye nu, 'plɩɩ kayu a ‑gbɛ, 'ʋ kuku 'mʋ lɛ. Kɛ Nyɩsʋa a wintɛ po. 'Katuo a ‑gbɛ, nɔ‑ mɔ ‑Yusu. (Kayuponyʋ ‑mɛ ‑ye, 'a mʋ'ʋ nɩ.)» ");
INSERT INTO ted_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kɛ Piɛlɩɩ lele po: «‑Yusuu ‑do, nɔ‑ɔ nɩ, ‑ɔ ‑wɛ 'le ‑bɔ waa nahuin, 'ke 'o Nyɩsʋa a ‑bati a ‑ta 'mʋ. Kɛ nɔ 'klɔ 'bii ‑gbo ke, Nyɩsʋa 'de nahuon ‑ye ‑ha, ‑ɔ ‑wɛ 'le ‑bɔ waa ‑a mʋ.» ");
INSERT INTO ted_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","‑Gboligbo a nahuin, ʋ nye 'nɩ 'ye, ‑ɛ mɔ, Piɛlɩ kɔ Saan 'hɛɛn, ʋ 'nɩ pɩ ꞊le hʋannʋ, 'bʋʋ ‑tɩ ꞊tu, 'plɩɩ ‑ye, ʋ yie nɩ, ‑ɛ mɔ, ʋ 'de 'crɩɩnɩɛ gblaka yi, kɔ, ʋ 'de nyɩgblakɩ. Dɛ a ‑gbɛ, ɛ saka ꞊nʋ nɩ. Kɛɛ, ʋ yruu nɩ, 'ʋ yie, ‑ɛ mɔ, ʋʋ o ‑wɔn naa ‑Yusu. ");
INSERT INTO ted_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kɛɛ ‑ye ʋ 'die 'le ‑wɛ bʋ ꞊tui, ‑ɛ mɔ, lɛ‑yɩyrɛnyɔ a 'kʋɛ 'de ‑wɛ, ‑ɛ nue, 'ke ɔ nɩ 'o ꞊nʋ ye gbo. ");
INSERT INTO ted_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","'A ‑tɩ, 'ʋ le Piɛlɩ kɔ Saan 'hɛɛn, 'ke bʋ 'hrɩɩ 'le ꞊nʋ ‑gbahlɔn, ‑ye ʋ ‑tʋa wlɔnlɛ꞊gbʋgbalɛ gbo, ");
INSERT INTO ted_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ʋ nɔ: «Dɛ tio‑ ‑a di nahuin ‑gbo 'mʋ nu 'le, ‑ɛ nue, nahuin 'bii, ‑ʋ 'ti nɔ Jrusrɛ 'mʋ, ʋ yie nɩ, ‑ɛ mɔ, Piɛlɩ kɔ Saan 'hɛɛn, ʋ nu 'ŋmilɛkadɛ gblaka. 'Plɩɩ, ‑a 'die 'le ‑wɛ ‑ba ꞊tui, ‑ɛ mɔ, hɩ'ɩ nɩ, ʋ 'die nu. ");
INSERT INTO ted_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","‑Ba ‑ha 'le 'yii a hɩhɩʋ, ‑ba tiu, 'ke ʋ nɩ ꞊tu 'le 'klɛɛ lele ‑Yusu a ‑tɩ nahuon ꞊de ye gbe, ‑ɛ die nu, dɛ ‑gbo, ‑ɛ mue 'lu ‑wɔn, 'a ‑tɩ 'nɩ ꞊han 'blʋgba 'bii ke gbo 'sɛɛ.» ");
INSERT INTO ted_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","'Plɩɩ ʋ 'mʋ mu ‑yrɛ, ‑ye ʋ da lele Piɛlɩ kɔ Saan 'hɛɛn nɩ, ʋ nɔ: «A nɩ ꞊tu 'le lele ‑Yusu a ‑tɩ nahuon ꞊de ye gbe!» ");
INSERT INTO ted_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kɛɛ ‑ye Piɛlɩ kɔ Saan 'hɛɛn, ʋ ꞊tu ‑wɔn, ʋ nɔ: «'A nɩ ‑gbɛ, ba 'ye, 'bɩa 'bɛ nɔɔ 'o lɛ, 'ke 'o Nyɩsʋa ye, 'ke ‑ba ꞊tuu 'o 'a mʋ, 'ɛ ‑hi 'o ‑ba ꞊tuu 'o Nyɩsʋa. ");
INSERT INTO ted_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","‑A ‑mɛ ‑ye, dɛ ‑gbo, ‑a 'ye, kɔ ‑tɩ ‑gbo, ‑a 'wɔn, ‑a 'die 'le ‑wɛ, ‑ba ma wien, ‑ba 'die ke 'prɛɛ.» ");
INSERT INTO ted_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","‑Ye ‑Juukʋɛ a nyɩgblakɩ, ‑ʋ nɩ 'o, ʋ 'nɩ 'ye ꞊le 'hru, bʋ di gba, ʋ 'mʋ Piɛlɩ kɔ Saan 'hɛɛn ꞊sʋɛ ꞊tue, ‑ɛ nue, nahuin 'bii, ʋʋ baa Nyɩsʋa, 'ke 'o dɛ, ‑ɛ mue 'lu ‑wɔn a ‑ta 'mʋ. Nɛ‑ nue, nyɩgblakɩ a ‑gbɛ 'ʋʋ nahuin a hʋannʋ pɩ, 'ʋʋ Piɛlɩ kɔ Saan 'hɛɛn le, ʋ nɔ: «'Bɩa 'ba 'kɩɛ gbɛɛ 'a nɩ nunuŋmli 'lu ‑wɔn, ‑a di 'a mʋ ꞊tue ꞊sʋɛ,» 'plɩɩ, 'ʋ tɩʋ gbo. ");
INSERT INTO ted_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nahuon a ‑gbɛ, ‑ɔ kɔ 'kʋɛ ‑wɛ, 'ke 'le 'ŋmilɛkadɛ 'kwli 'mʋ, ɔ kɔ 'yrɩɩ a ‑wlɩɩ 'hɔn, 'ɩ nɩ lɛ. ");
INSERT INTO ted_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","‑Tɛ ʋ tɛ 'klɛɛ Piɛlɩ kɔ Saan 'hɛɛn gbo, ‑ye 'ke ʋ mu 'le 'waa 'bienʋ ‑wɔn, 'ʋ na ꞊nʋ ‑tɔplɩ 'bii ꞊nʋ ‑wɔn lɛ, Nyɩsʋa a ‑cɔhlʋnpinyʋ gblakɩ kɔ nyɩgblakɩ ‑ye 'hɛɛn, ʋ ꞊tu ꞊nʋ ye. ");
INSERT INTO ted_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","‑Tɛ ʋ 'wɔn ‑tɩ a ‑gbɛ, ‑ye ‑Yusu a nahuin, ʋ po 'o 'waa ꞊wlɩ ‑tɛɛ ‑do, 'ʋ ‑tʋa Nyɩsʋa a dɩda gbo, ʋ nɔ: «Kʋkɔnyɔ, ‑mɔɔ nɩ, ‑ɔ nu yakɔ, kɔ ‑tʋtʋ, kɔ 'yru 'hɛɛn, kɔ 'ɛ nɩ dɛ ꞊de, ‑ɛ nɩ nɔ 'klɔ ke. ");
INSERT INTO ted_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","‑A nɩ bu gblaka bodɩɔ Dafidɩ, ‑ɔ mɔ ‑na ‑kʋannunyɔ, ‑na ‑Hihiu nue la nɩ, Dafidɩ a ‑gbɛ 'ɔ ꞊tui la, ‑ɛ mɔ: Dɛ‑ kɔ ‑tɩ dakʋ a gblegblei ꞊nʋ, ‑ʋ 'de ‑Juukʋɛ, 'ʋ 'yaa 'le 'waa dɩɔnʋ, 'plɩɩ 'ʋʋ yrʋ po, 'ʋʋ ‑tɔplɩ ‑hʋɩn 'lu ‑wɔn lɛ ‑hie, 'ke 'o Kʋkɔnyɔ ‑wɔn. Kɛɛ, ‑tɔplɩ a ‑gbɛ, ʋ 'die 'le ‑wɛ bʋ nui. ");
INSERT INTO ted_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","‑Tʋtʋ ‑gbo a 'blʋgbɩnaanyʋ, ʋ bibi 'mʋ lɛ 'yi, ʋ 'mʋ Kʋkɔnyɔ Nyɩsʋa ye ‑wɔn, ɔ kɔ Waanyɔ ꞊nʋ 'hɛɛn, ɔ po la lɛ, ɔ di la 'le ya. Kɛ Dafidɩ po la. ");
INSERT INTO ted_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","'Ɛ mɔ ‑tɛɛ, kɛ nɔ 'dɩɔ ‑gbo 'mʋ, 'kɩɩn Helɔdɩ kɔ ‑gʋlʋnʋma Pʋsɩ Pilatɩ 'hɛɛn, ʋ bibi 'mʋ lɛ 'yi, ʋ kɔ dakʋ a nahuin ꞊nʋ, ‑ʋ 'de ‑Juukʋɛ, ʋ kɔ Yisraɛkʋɛ a ꞊tugbɩ 'hɛɛn, 'ke bʋ ‑wɔn ‑na ‑kʋannunyɔ ‑Yusu ye. Nɔ‑ ‑n ‑ha 'le du 'mʋ, 'ke bɔ 'ya Waanyɔ ꞊nʋ 'mʋ, ‑n po la lɛ, ‑n di la 'le ya. ");
INSERT INTO ted_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kɛɛ, ‑tɔplɩɩ ‑do ꞊nʋ, ‑mɔ 'Klɩkenɩnyɩsʋa, ‑n ‑hie la 'lu ‑wɔn lɛ, kɔ ‑n ‑yra la, si la a ti 'yri, ɩ ‑do, nɩ‑ ʋ ‑wɛ 'le bʋ nu. ");
INSERT INTO ted_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","‑Tɛ ti nɩ lɛ 'mʋ ‑gbo, Kʋkɔnyɔ o, 'ye kɛ ‑tɩ ʋ ꞊tu, ʋ nɔ 'nɩ, ʋ di ‑a mʋ ꞊tue ꞊sʋɛ. 'A ‑tɩ o, ‑a mʋ ‑gbo, ‑ʋ mɔ ‑na ‑kʋannunyʋ, ‑nyi ‑a mʋ 'klɩ, ‑ɛ die nu, ‑a 'nɩ ꞊han hʋannʋ pɩ, 'ke ‑ba ꞊tu ‑na ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nue, nahuin bʋ 'ye, ‑ɛ mɔ, ‑n nɩ ke 'klɩ. Kɔ, nue ‑wɛ, nahuin a 'kʋɛi bɩ ‑wɛ, ‑bo nu ‑wɛ 'ŋmilɛka‑tɔplɩ ‑ye, 'ke 'le ‑na 'Yu ‑Yusu a 'dʋ 'kwli 'mʋ, ‑n ‑nyi 'klɩ.» ");
INSERT INTO ted_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","‑Tɛ ʋ ‑wɔ 'klɛɛ Nyɩsʋa a dɩda ‑wɔn, ‑ye 'ke 'o ‑tɛgbi ꞊nʋ, ʋ 'kukue 'o lɛ, ‑tʋtʋ ‑tʋa 'hɩhrɔlɛ gbo. ‑Ye Nyɩsʋa a ‑Hihiu ꞊nʋ, ‑ʋ nɩ 'o ꞊nʋ ke 'mʋ, ʋ kʋʋ ke win 'bii, ‑Yusu a nahuin a ‑gbɛ, ʋ 'nɩ pɩ ꞊le hʋannʋ, 'ʋʋ Nyɩsʋa a ‑tɩ nahuin ye ꞊tu. ");
INSERT INTO ted_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Nahuin 'bii ꞊nʋ, ‑ʋ kuo ‑Yusu ꞊wlʋ ye, ꞊hapʋkɔ, 'ʋ ‑huo, kɛɛ, ʋ kɔ 'lu a lɛ‑hielɛɛ ‑do kɔ ꞊wlʋʋ ‑do. 'Ke 'le ꞊nʋ ‑hɛyri, ꞊ɔ ꞊de 'nɩ po ꞊le lɛ, ‑ɛ mɔ, 'a kʋkɔ‑tɔplɩ, ɔ ‑do, nɔ‑ kʋɩ, kɛɛ, 'ɛ nɩ nahuon, 'bɔ nɩ 'o, ‑tɔplɩ 'bii ‑gbo, ɔ kɔ, ɔ nyi 'nɩ wo, ɔ kɔ nahuin 'bii 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","‑Yusu a ‑wɔnnaanyʋ, ʋ kɔ 'klɩ 'dɔ, 'ke bʋ ꞊tui nahuin yrɛ, ‑ɛ mɔ, Kʋkɔnyɔ ‑Yusu 'Klɩsʋ, ‑tɛ ɔ 'kʋ, ɔ ‑hɔn 'le 'kʋkʋnyʋ ‑hɛyri 'mʋ nɩ, 'ɔ 'hrɩ 'klɔ. ‑Yusu a nahuin a ‑gbɛ, Nyɩsʋa nyu 'mʋ nu ꞊hapʋdɛ 'dɔ. ");
INSERT INTO ted_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","'Ke 'le ꞊nʋ ‑hɛyri, nahuon ꞊de 'nɩ 'ye ꞊le ꞊sʋɛ, ‑ɛ nue, 'ɛ nɩ nahuon 'bɔ nɩ 'o, 'bɔ kɔ ‑cii kɔ kayuo, ɔ nyi 'nɩ plo, ");
INSERT INTO ted_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","'ɔɔ 'le 'a 'wliyɛ a ‑gbɛ ‑Yusu a ‑wɔnnaanyʋ ‑wɔn gba, 'ʋ nye nahuin 'mʋ lɛ woo, 'ɛ nɩ nahuon 'bɔ nɩ 'o, ‑tɛ 'a 'kla‑wliye'yɩya ‑ti 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ɛ kɔ ‑wɛ nahuon ꞊de. 'A 'dʋ mɔ Sosɛfʋ. Lefi꞊tugba a nahuoon nɩ. 'Ke ɔ kɔ 'le Sipreblʋgba 'mʋ, ‑Yusu a ‑wɔnnaanyʋ 'ʋ ꞊tuo la Banabasɩdʋ, ‑ɛ ꞊hɛn 'nyrɛ, ‑ɔɔ 'le nahuin ꞊wlʋ 'kwli 'mʋ gbo ꞊tu. ");
INSERT INTO ted_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Sosɛfʋ a ‑gbɛ, ɔ plo 'a ‑ci ‑ye, ɔ kɔ, 'plɩɩ, 'ɔ gba 'le 'a 'wliyɛ ‑Yusu a ‑wɔnnaanyʋ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ɛ kɔ la nyɩbɛyu ꞊de. 'A 'dʋ mɔ Ananiasɩ. 'A nyrʋgba a 'dʋ mɔ Safila. Nʋ‑ plo 'waa ‑ci ‑ye, ");
INSERT INTO ted_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananiasɩ 'ɔ ꞊tu 'wliyɛ a ‑gbɛ a ꞊tɩɔ ‑ye gbo, 'ɔ gba 'a dɛ ‑ye ꞊nʋ ‑Yusu a ‑wɔnnaanyʋ ye. 'A nyrʋgba yie nɩ, ‑ɛ mɔ, 'a tɔ ꞊tu 'wliyɛ a ꞊tɩɔ ‑ye gbo. ");
INSERT INTO ted_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","‑Tɛ Ananiasɩ a ‑gbɛ nyre 'klɛɛ 'o, ‑ye Piɛlɩ nɔ: «Ananiasɩ, dɛ‑ kɔ ꞊nɩ ‑ha 'kuo ‑hʋɩn a nyɩgblaka Satan mɛ lɛ, 'ɔ kɔɔ ‑mʋ win ke, 'ɛ nue, ꞊nɩ 'du hɩ, 'ke 'o Nyɩsʋa a ‑Hihiu ye, ‑ɛ mɔ, 'a nɩ ‑ci, a plo wɛn, 'a 'wliyɛ 'bii, nɛ‑ ‑gbo? Kɛɛ ‑ye ‑n ꞊tu 'a ꞊tɩɔ ‑ye gbo. ");
INSERT INTO ted_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","'Plɩɩ ꞊mʋ ‑ci a ‑gbɛ mu plo, ꞊be ɛ 'de ‑mɔ, ‑n 'die kɔ ‑le? ‑Mɔɔ nɩ, ‑ɔ kʋɛ. ‑Tɛ ‑n plo ‑ci a ‑gbɛ, ‑mɔ kɔ ‑wɛ 'a 'wliyɛ. ꞊Be ɛ 'de ꞊nɛ? Dɛ‑ nue, ꞊nɩ ‑yrɩ, 'ke 'le ‑na ꞊wlʋ ke, 'ke ‑bo 'du hɩdʋ ‑gbo 'le? Ɛ 'de ‑tʋnahuin, ‑n 'diu hɩ lɛ nu, kɛɛ ‑ye Nyɩsʋa'a nɩ, ‑n nuu hɩ lɛ.» ");
INSERT INTO ted_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","'Plɩɩ Ananiasɩ 'mʋ wintɛdʋ a ‑gbɛ mu 'wɔn, tii ‑do a ti 'yri, ‑ye ɔ bi ꞊hlɔn, 'ɔ 'kʋ. Ɛ nue, nahuin 'bii ꞊nʋ, ‑ʋ 'wɔn ‑tɩ a ‑gbɛ, hʋannʋ 'ʋ nyu nu 'dɔ. ");
INSERT INTO ted_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","‑Ye gblotayuo ꞊nʋ, ‑ʋ nɩ 'o, ʋ 'hɩnhɩʋɔn lɛ danʋ, 'ʋ gbɔ, 'ʋ ‑hɩɔ 'o. ");
INSERT INTO ted_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","‑Hawɩɩ ta bɩ ‑hi, ‑ye Ananiasɩ a nyrʋgba Safila, ɔ nyre 'le 'a 'bienʋ ‑hɛyri nɩ. Dɛ ꞊nʋ, ‑ɛ mue 'lu ‑wɔn, ɔ 'die 'o dɛ ꞊de 'hʋɩn 'mʋ yi. ");
INSERT INTO ted_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","‑Ye Piɛlɩ ꞊gbɔ wlɔn, ɔ nɔ: «꞊Be sɛyɩ‑sɛyɩ, ‑tɛ a plo 'a nɩ ‑ci, 'a 'wliyɛ 'bii, nɛ‑ ‑gbo?» ‑Ye ɔ nɔ: «Iin, 'wliyɛ 'bii, nɛ‑ɛ nɩ.» ");
INSERT INTO ted_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","‑Ye Piɛlɩ nɔ lele: «‑Be' a nu 'klɛɛ 'le, ‑n kɔ ‑n tɔ 'hɛɛn, 'a ‑yra hɩdʋ ꞊nʋ, 'ke ba ꞊tɔ Nyɩsʋa a ‑Hihiu 'mʋ lɛ 'le? 'Ye kɛ, nahuin ꞊nʋ, ‑tɛ ‑n tɔ 'kʋ, ‑ʋ ‑hɩɔ 'o, 'ke ʋ nɩ 'o 'maju 'yri. ‑Na ‑gbɛ o, ‑n di ‑wɛ 'nɩ 'kʋ, ʋ 'mʋ ‑wɛ 'o ‑mʋ ‑ha.» ");
INSERT INTO ted_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tii ‑do a ti 'yri, ‑ye ɔ bi ꞊hlɔn, 'ke 'o Piɛlɩ a ‑gbɛ ꞊hlɔn, 'ɔ 'kʋ. Gblotayuo ‑nɩ wɛn, ʋ pa nɩ, 'ʋ 'ye, ‑ɛ mɔ, nyrʋgba a ‑gbɛ, ɔ 'kʋ nɩ, 'ʋ gbɔ, 'ʋ ‑hɩɔ 'o, 'ke 'o 'a tɔ 'hʋɩn 'mʋ, ");
INSERT INTO ted_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","'cʋɛ a nahuin 'bii, kɔ nahuin ‑ye ꞊nʋ, ‑ʋ 'wɩn, hʋannʋ 'ʋ nyu nu 'dɔ. ");
INSERT INTO ted_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","‑Yusu a ‑wɔnnaanyʋ, ʋʋ nu 'ŋmilɛka‑tɔplɩ 'plɔplɔ, 'ke 'le Nyɩsʋa a 'klɩ 'kwli 'mʋ. 'Ke ‑Yusu a nahuin 'bii, ʋ 'kukue 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ lɛ, 'ke 'le papʋɛ ꞊nʋ gbo, ʋʋ Salomɔ a papʋɛ daa. ");
INSERT INTO ted_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nahuin ꞊nʋ, ‑ʋ 'de ‑Yusu ꞊wlʋ ye kuo, ʋʋ la pɩ hʋannʋ, 'ke bʋ biu ke. Kɛɛ, kɛ ɛ nɩ 'mʋ, 'ʋ 'bʋaa la 'waa ‑tɩ 'yi 'dɔ, ");
INSERT INTO ted_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","nahuin 'plɔplɔ, nyɩbɛpʋ kɔ nyrʋ, 'ʋʋ Kʋkɔnyɔ ‑Yusu ꞊wlʋ ye kuo, 'ʋʋ ‑Yusu a nahuin ke bi. ");
INSERT INTO ted_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","‑Ye nahuin, ʋʋ gba 'hʋɩnhrennyʋ 'ke 'le 'hri wlɔn, 'ʋ pɩʋ 'o 'sapʋɩ kɔ 'crakɩ 'hɛɛn ke gblɛ, ‑ɛ die nu, ti ꞊nʋ ‑kɔ 'yri Piɛlɩ di 'o ‑hii, 'a ‑gbɛ 'bɔ 'de ꞊ʋ ‑ye lɛ 'tʋ, 'a ‑hikɔɔ ‑do 'mu lɛ 'tʋ. ");
INSERT INTO ted_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","'Dɩɛ ꞊nʋ, ‑ɛ ꞊glaa 'le Jrusrɛ, nahuin nye 'le klɛ 'mʋ ‑hɔn, 'ʋʋ 'le 'hʋɩnhrennyʋ lɛ ya, kɔ nahuin ꞊nʋ, 'kuo ‑hʋɩn nɩ 'o ke 'mʋ lɛ, ʋ 'bii a ‑gbɛ, 'waa 'kʋɛi 'ɩɩ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","‑Ye Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka, kɔ nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'o ꞊nɔ 'hʋɩn 'mʋ, ‑ʋ mɔ ꞊tumu ꞊nʋ, ʋʋ Sadusɩ꞊tumu a nahuin daa, ca ‑huo 'le ꞊nʋ 'mʋ, 'ke 'o ‑tɔplɩ ꞊nʋ, ‑Yusu a ‑wɔnnaanyʋʋ nu a ‑ta 'mʋ. ‑Ye ʋ ‑yrɩ nɩ, 'ke bʋ nyra ‑tɔplɩ a ‑gbɛ gbo, ");
INSERT INTO ted_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","'ʋ klɩ ‑Yusu a ‑wɔnnaanyʋ a ‑gbɛ, 'ʋ pu ꞊jɩ 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kɛɛ, 'tɔ 'mʋ, Nyɩsʋa a lɛleenyɔ ꞊de, 'ɔ ‑ha 'o ꞊jɩkayu a ‑gbɛ a 'maji lɛ, 'ɔ 'hrʋʋ, 'ɔ lu, ɔ nɔ: ");
INSERT INTO ted_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ba mu 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, ‑ɛ die nu, 'klɔ yrayrʋ ꞊nʋ, ‑Yusu ya 'le, a 'mʋ 'a ‑tɩ nahuin ye ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","‑Tɩ ꞊nʋ, Nyɩsʋa a lɛleenyɔ ꞊tu, ‑Yusu a ‑wɔnnaanyʋ ꞊tui 'o ꞊o. ‑Nyrɛgblɩ, 'ʋ mu 'le Nyɩsʋa a 'kagblaka a ‑yaa 'mʋ, 'ʋ ‑tʋa nahuin a tɔɔlɛ gbo. ‑Ye Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka, kɔ nahuin ꞊nʋ, ‑ʋ nɩ 'o ꞊nɔ 'hʋɩn 'mʋ, ʋ ‑mɛ ‑ye, ʋ 'kukue ‑Juukʋɛ a 'blʋ a nahuin lɛ, 'ke 'o 'waa ‑gboligbo gblaka a ‑ta 'mʋ. ‑Tɛ ʋ 'kukue 'klɛɛ lɛ, ‑ye ʋ le Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ, 'ke bʋ bla ‑Yusu a ‑wɔnnaanyʋ, 'ke 'le ꞊jɩkayu gbo. ");
INSERT INTO ted_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kɛɛ, ‑tɛ ʋ nyre 'le ꞊jɩkayu gbo, ʋ 'diu 'le gbo yɛ. ‑Ye ʋ ꞊hɩan ‑wɔn, 'ʋ mu, 'ʋ le ‑gboligbo a nahuin, ʋ nɔ: ");
INSERT INTO ted_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«‑Tɛ ‑a nyre 'le, ꞊jɩkayu a 'maji ‑hlɛntie, 'ɩ pue 'o lɛ ‑tɛɛ, ꞊jɩkayu a 'yie꞊tunyʋ 'ʋ nɩ 'o 'waa ‑tui ke gblɛ, 'ke 'o 'maji 'yri. Kɛɛ, ‑tɛ ‑a ‑ha 'o 'maji lɛ, ‑a 'de 'le ꞊ɔ ꞊de gbo yɛ.» ");
INSERT INTO ted_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ a nyɩgblaka, kɔ ‑cɔhlʋnpinyʋ gblakɩ 'hɛɛn, ‑tɛ ʋ 'wɔn ‑tɩ a ‑gbɛ, ‑Yusu a ‑wɔnnaanyʋ bʋ 'de 'le ꞊jɩkayu gbo nɩ a ‑tɩ, dɛ bʋ di 'lu ‑wɔn lɛ ‑hie, kɔ dɛ, ‑ɛ di 'lu ‑wɔn mue, ʋ 'die yi. ");
INSERT INTO ted_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","‑Ye tii ‑do a ti 'yri, nahuon ꞊de nyre 'o ꞊o, ɔ nɔ: «Ba 'ye kɛ, nahuin ꞊nʋ, a po ꞊jɩ 'mʋ, ‑tɛ ti nɩ lɛ 'mʋ ‑gbo, 'ke ʋ nɩ 'le Nyɩsʋa a 'kagblaka gbo, 'ʋʋ nahuin tɔɔ.» ");
INSERT INTO ted_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Bʋ 'wɩn 'klɛɛ, ‑ye Nyɩsʋa a 'kagblaka a 'yie꞊tunyʋ a nyɩgblaka, kɔ 'a nahuin 'hɛɛn, ʋ mu nɩ, 'ʋ ‑mɩa ‑Yusu a ‑wɔnnaanyʋ de. Kɛɛ, ʋ 'die 'le 'klɩ 'kwli 'mʋ nuu, ‑ɛ nue, ʋʋ pɩ nahuin a hʋannʋ, ʋ 'nɩ ꞊han ꞊nʋ 'hɩɛ ‑wɔn lɛ po, 'ke bʋ 'lʋ. ");
INSERT INTO ted_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","‑Tɛ ʋ ‑mɩʋ 'klɛɛ de, ‑ye 'ke ʋ gbʋ 'le ‑gboligbo gblaka ye, Nyɩsʋa a ‑cɔhlʋnpinyʋ a nyɩgblaka 'ɔ ‑tʋa 'waa wlɔnlɛ꞊gbʋgba gbo, ");
INSERT INTO ted_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","ɔ nɔ: «꞊Be ‑a 'de o 'a mʋ le ‑tɛɛ, 'ke a nɩ ꞊tu 'le o nahuon ꞊de ‑Yusu a ‑tɩ ye. Ba 'ye kɛ dɛ, a nu. 'A nɩ tɔɔlɛ ka 'le Jrusrɛdɩɔ 'bii nɩ, 'plɩɩ, 'aa ‑hʋa ba po ‑a mʋ ‑Yusu a 'kʋkʋ‑tɩ 'lu lɛ.» ");
INSERT INTO ted_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kɛɛ ‑ye Piɛlɩ kɔ ‑Yusu a ‑wɔnnaanyʋ ‑ye 'hɛɛn, ʋ ꞊tuo ‑wɔn, ʋ nɔ: «Ye‑hɛnahuon, ‑a blɛ ye ‑ba ꞊tuu 'o, nɔ‑ mɔ Nyɩsʋa, ɛ 'de ‑tʋnahuin. ");
INSERT INTO ted_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","‑Yusu ‑gbo, a kɔɔ o 'o tu 'yie 'mʋ, 'ke ɔ 'mʋ o 'kʋ, Nyɩsʋa, ‑a nɩ bunʋʋ la da, nɔ‑ ‑hɩɔ o 'le 'kʋkʋnyʋ ‑hɛyri, 'ɔ ‑hɩɔ o 'klɔ, ");
INSERT INTO ted_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","'ɔ nue, ‑Yusu a ‑gbɛ 'ɔ mu 'o ꞊nɔ 'hʋɩn 'mʋ, 'ke 'le yakɔ 'mʋ, Nyɩsʋa 'ɔ ‑nyi ꞊nɔ 'klɩ, 'ke bɔ 'ya 'luyenɩnyɔ 'mʋ kɔ Waanyɔ 'hɛɛn. Dɛ a ‑gbɛ, Nyɩsʋa nue nɩ, ‑ɛ die nu, ɔ 'mʋ Yisraɛkʋɛ 'klɩ ‑nyi, 'ke bʋ hie 'o 'waa dɛ 'kuku gbo, ʋ 'mʋ 'waa 'klɔ 'bii Nyɩsʋa ‑nyi, Nyɩsʋa, ɔ 'mʋ 'waa dɛ 'kuku a ‑gbɛ 'wʋwla. ");
INSERT INTO ted_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","‑A 'ye ‑tɔplɩ 'bii ꞊nʋ nɩ, ‑ɩ mue 'lu ‑wɔn, ꞊a nyi ꞊tu, ‑a kɔ Nyɩsʋa a ‑Hihiu 'hɛɛn. ‑Hihiu a ‑gbɛ, Nyɩsʋa nyu nahuin ꞊nʋ 'nɩ ‑nyi, ‑ʋ nyo 'o ꞊tuu.» ");
INSERT INTO ted_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","‑Tɛ ‑gboligbo a nahuin 'wɔn win a ‑gbɛ, ‑ye ʋ bi 'mʋ lɛ yrʋ bʋbakɔ, 'ʋʋ ‑hʋa bʋ 'la ‑Yusu a ‑wɔnnaanyʋ. ");
INSERT INTO ted_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kɛɛ, 'ke 'le ꞊nʋ ‑hɛyri, ɛ kɔ Falisi꞊tumu a nahuon ‑ye. 'A 'dʋ mɔ Gamaliɛlɩ. Ɔ mɔ Nyɩsʋa a teteitɔɔnyɔ'ɔ nɩ. Nahuin nyo 'o 'nɩ ꞊tuu 'dɔ. Nɔ‑ 'ba ye 'mʋ, 'ke 'le ‑gboligbo a nahuin ‑hɛyri, 'ɔ le nahuin, bʋ 'hrɔɔ ‑Yusu a ‑wɔnnaanyʋ, 'ke 'le ti gbi 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","‑Tɛ ʋ 'hrʋʋ 'klɛɛ, ‑ye kɛ ɔɔ ‑gboligbo a nahuin ye po, ɔ nɔ: «Yisraɛkʋɛ, dɛ a di nahuin ‑gbo 'mʋ nu, ba ‑hie 'lu ‑wɔn lɛ ‑tɛɛ.» ");
INSERT INTO ted_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ɔ nɔ lele: «'A ti 'de wɛn ke gbo a hreen, nyɩbɛyu ꞊de, nɔ‑ 'hrɩ o. 'A 'dʋ mɔ Tedasɩ. Ɔ nɔ 'nɩ, ɔ mɔ o nyɩgblakaa nɩ, nahuin, ‑ʋ ‑wɛ 'le ‑hɔtrʋwɩɩ ‑hɛn (400) 'ʋ nyo o ‑wɔn kʋɛ. Kɛɛ, nahuon ꞊de 'lɔ o, nahuin 'bii, ‑ʋ nyo o ‑wɔn kʋɛ, 'ʋ ‑gbɛ o 'kwla 'nyɩ 'mʋ lɛ, ꞊tumu a ‑gbɛ 'ʋ ‑wɛ gbo. ");
INSERT INTO ted_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","‑Tɛ Tedasɩ a dɛ ‑hi, ti ꞊nʋ ‑kɔ 'yri ʋʋ o 'o nahuin ‑hree, nyɩbɛyu ꞊de 'hrɩ o ‑wɛ. 'A 'dʋ mɔ Judɩa. 'Ke ɔ kɔ 'le Galileblʋgba 'mʋ; 'ɔ nue, nahuin 'plɔplɔ 'ʋ kʋɔ ‑wɔn. Kɛɛ, nahuon ꞊de 'lɔ o ‑wɛ, nahuin 'bii, ‑ʋ nyo o ‑wɔn kʋɛ, 'ʋ ‑gbɛ lɛ. ");
INSERT INTO ted_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","'A ‑tɩ o, 'nɩɩ 'a mʋ 'nɩ le, nahuin ‑gbo, ‑aa 'klɛɛ ‑bati lɛ poo, a nɩ nu 'le ꞊nʋ dɛ ꞊de 'mʋ! Kɛɛ, ba ‑hɩʋ mɛ lɛ, bʋ mu. 'Bɩa 'waa tɔɔlɛ kɔ 'waa nunu‑tɔplɩ 'hɛɛn, 'bɩ 'ya ‑tʋnahuin a 'lu a lɛ‑hielɛ 'mʋ, ɩ di gbo 'nɩ ‑wɛ. ");
INSERT INTO ted_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Kɛɛ, 'bɩa 'bɛ 'ya Nyɩsʋa 'mʋ, ‑ɔ nyu 'klɩ ‑nyi, ‑ye a 'die 'le ‑wɛ ba ‑wʋ gbo. 'Bɩa 'ba nyu ye ‑wɔn, ‑ye ɛ 'we ꞊nɔ ye, Nyɩsʋa aa ye ‑wɔn.» ‑Ye ‑tɩ ꞊nʋ, Gamaliɛlɩ ꞊tu, ‑gboligbo a nahuin wɩɩn ke, ");
INSERT INTO ted_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","'ʋ da lele ‑Yusu a ‑wɔnnaanyʋ ‑nɩ wɛn, 'ʋ le 'sɔyuo, 'ke bʋ biu lɔkʋɛ. ‑Tɛ ʋ ‑wɔ 'klɛɛ 'waa bibie ‑wɔn, ‑ye ʋ ‑nyu lele tete, ʋ nɔ: «A nɩ tɔɔ 'le lele ‑Yusu a ‑tɩ,» 'plɩɩ 'ʋ tɩʋ gbo. ");
INSERT INTO ted_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","‑Tɛ ‑Yusu a ‑wɔnnaanyʋ, ʋʋ 'le ‑gboligbo a nahuin ‑hɛyri 'mʋ ‑hɔn, ‑ye ʋʋ nu 'manʋ, ‑ɛ nue, Nyɩsʋa nu ꞊nʋ 'mʋ ꞊hapʋdɛ. ꞊Hapʋdɛ a ‑gbɛ, nɛ‑ mɔ bʋ 'ye ꞊sʋɛ, 'ke 'o ‑Yusu a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","‑Ye 'ɛ nɩ ‑nyrɔwɔ, 'ke 'le Nyɩsʋa a 'kagblaka gbo, kɔ 'ke 'le 'waa ‑gbɛ a kayuo gblɛ, ʋ 'cipi 'o, 'ʋ nyi nahuin ye ꞊tu, ‑ɛ mɔ, ‑Yusu, nɔ‑ mɔ Waanyɔ ꞊nʋ, Nyɩsʋa po la lɛ, ɔ di la 'le ya. ");
INSERT INTO ted_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ti a ‑gbɛ 'yri, ‑Yusu a nahuin, ʋʋ klɛ 'nɩ bii 'dɔ. ‑Yusu a nahuin a ‑gbɛ, ʋ mɔ la ‑Juukʋɛ. ꞊Ʋ ‑ye, ʋʋ po Glɛkɩkʋɛwin. 'Ke ʋ kuu 'le 'blʋgbɩ ‑ye 'mʋ, 'plɩɩ 'ʋ ‑hɔn 'le 'mʋ, 'ʋ mu 'bri; ꞊ʋ ‑ye ꞊nʋ, ‑ʋʋ ‑Juukʋɛwin po, 'ke ʋ nɩ ꞊ke 'le 'bri. Nahuin ꞊nʋ, ‑ʋʋ Glɛkɩkʋɛwin po, ʋʋ 'mʋ lɛ 'nɩ 'pʋprɛ, 'ke 'o 'waa 'bienʋ ꞊nʋ ke, ‑ʋʋ ‑Juukʋɛwin po, ‑ɛ nue, ʋ nɔ 'nɩ, 'ɛ nɩ ‑nyrɔwɔ, ti ꞊nʋ ‑kɔ 'yri ʋʋ 'o didi‑tɔplɩ 'o woo, 'waa kotianyrʋ, nahuin 'nɩ kɔ ꞊le 'le 'waa dɛ ‑wɔn. ");
INSERT INTO ted_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nɛ‑ kɔ ‑tɩ ‑Yusu a ‑wɔnnaanyʋʋ ‑pu ꞊tu 'o 'hɔn ꞊nʋ, 'ʋ da ‑Yusu a nahuin 'bii, 'ʋ 'kukue lɛ, ʋ nɔ: «Ɛ 'de 'o lɛ nɔɔ, 'ke ‑a mʋ ‑Yusu a ‑wɔnnaanyʋ ‑ba hie 'o Nyɩsʋa a ‑tɩ a ꞊tutue gbo, ‑ba wo didi‑tɔplɩ. ");
INSERT INTO ted_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nɛ‑ nue, ‑dɩayuo ‑a, ba ta 'le 'a nɩ dɩɔnʋ ‑hɛyri lɛ, ba ‑ha 'le nahuiin 'nɩpata, ‑ʋ kɔ ‑pli nahuiin po, ‑ɛ mɔ, 'waa 'klɔ nɔ lɛ 'yi, kɔ, Nyɩsʋa a ‑Hihiu kɔɔ win ke 'bii, 'plɩɩ, ‑ʋ kɔ ꞊tɔ. Nahuin a ‑gbɛ, nʋ‑ʋ nɩ, ‑a di didi‑tɔplɩ a wuwe a ‑kʋan a ‑gbɛ ‑nyi, ");
INSERT INTO ted_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","‑a ‑mɛ ‑ye, ‑a 'mʋ ti kɔ, 'ke ‑ba da Nyɩsʋa, kɔ, ‑ba ꞊tu Nyɩsʋa a ‑tɩ nahuin ye.» ");
INSERT INTO ted_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","‑Tɩ ꞊nʋ, ‑Yusu a ‑wɔnnaanyʋ ꞊tu, ɩ klɩɩ nahuin 'bii ke. Nɛ‑ nue, 'ʋ ta 'le 'waa dɩɔnʋ ‑hɛyri lɛ, 'ʋ ‑ha 'le nahuiin 'nɩpata a ‑gbɛ. Ye‑hɛnahuon, ʋ ‑ha 'le, nɔ‑ mɔ Etiɛnɩ. Ɔ kuo ‑Yusu ye ꞊wlʋ 'dɔ, Nyɩsʋa a ‑Hihiu 'ʋ kʋɔ win ke 'bii, kɔ, 'ʋ ‑ha ‑wɛ 'le Filipʋ, kɔ Plʋkɔɔlʋ, kɔ Nikanɔlɩ, kɔ Timɔ, kɔ Pamɩnasɩ, kɔ Nikola, ‑ɔ kɔ 'le Atiɔsɩdɩɔ 'mʋ. Nikola a ‑gbɛ, ɔ 'de la ‑Juukʋɛyu, kɛɛ, ɔ ‑hɛ ‑Juukʋɛyu. ");
INSERT INTO ted_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","‑Tɛ ʋ wʋ 'klɛɛ 'dʋ, ‑ye ʋ gbʋ nɩ, 'ʋ titiu ‑Yusu a ‑wɔnnaanyʋ ye, ‑Yusu a ‑wɔnnaanyʋ a ‑gbɛ 'ʋ da Nyɩsʋa, 'ke 'o 'waa ‑ta 'mʋ, 'ʋ pu dabʋɩ 'lu gblɛ, ‑ɛ die nu, Nyɩsʋa 'mu ꞊hapʋdɛ 'mʋ nu. ");
INSERT INTO ted_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ti a ‑gbɛ 'yri, Nyɩsʋa a wintɛ 'sɛɛ gbo, 'ke 'le 'blʋgba 'bii ꞊nʋ 'mʋ. Dɛ a ‑gbɛ, nɛ‑ nue, ‑Yusu a nahuin 'ʋ bii ke 'dɔ, 'ke 'le Jrusrɛdɩɔ 'mʋ, kɔ, Nyɩsʋa a ‑cɔhlʋnpinyʋ 'plɔplɔ 'ʋ kuo ‑wɛ ‑Yusu ꞊wlʋ ye. ");
INSERT INTO ted_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nyɩsʋa, ɔɔ Etiɛnɩ 'mʋ nu ꞊hapʋdɛ gblaka, kɔ, 'ɔ ‑nyi ꞊nɔ 'klɩ, Etiɛnɩ a ‑gbɛ 'ɔɔ 'ŋmilɛka‑tɔplɩ gblakɩ nu, 'ke 'le nahuin ‑hɛyri. ");
INSERT INTO ted_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","‑Nyrɔwɔ ꞊de 'mʋ, nahuin ꞊de, nʋ‑ di 'le, 'ʋʋ Etiɛnɩ ꞊yʋɛ 'mʋ lɛ ꞊mʋɛ. Nahuin a ‑gbɛ, 'waa dɛ ‑ye, ɛɛ lɛ 'nɩ 'kukue, 'ke 'le Nyɩsʋa a kayu ꞊de gbo. Nahuindʋ a ‑gbɛ, ʋ nyu daa gbotɛ꞊go. 'Waa dɛ ‑ye, ‑ʋ ya 'le ꞊yʋɛ, 'ke ʋ ‑hɔn 'le Silɛnɩdɩɔ 'mʋ, kɔ Alɛsadrɩdɩɔ, 'ke ꞊ʋ ‑ye ‑hɔn 'le Silisiblʋgba kɔ Asiblʋgba 'mʋ. Nʋ‑ kɔ Etiɛnɩ 'hɛɛn‑ gblɛ po. ");
INSERT INTO ted_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kɛɛ, ‑tɛ bʋ di 'a ‑wɔn꞊tutue nu, ʋ 'die yi, ‑ɛ nue, ꞊tɔ ꞊nʋ, Nyɩsʋa a ‑Hihiuu ꞊nɔ ‑nyi, nɔ‑ kɔ 'kwli 'mʋ ɔɔ 'le naa, 'ɔɔ 'prɛ. ");
INSERT INTO ted_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","‑Ye nahuin ꞊nʋ, ‑ʋ ya 'le ꞊yʋɛ, ʋ 'pɛɛ nahuin, 'ʋ lu, ʋ nɔ: «Kɛ ba po nahuin ye, ‑ɛ mɔ, Etiɛnɩ ‑gbo, a 'wɩn nɩ, ‑ɛ mɔ, Nyɩsʋa kɔ 'a winwlɔn‑hɛnyɔ Moise 'hɛɛn, nʋ‑ ɔɔ ‑tɩ 'hʋɩn 'mʋ lɛ ꞊tu.» ");
INSERT INTO ted_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nɛ‑ ɛ kʋɛ ye, 'ʋ ꞊tutuo nahuin kɔ 'blʋgba a ye'mʋnaanyʋ, kɔ Nyɩsʋa a teteitɔɔnyʋ 'hɛɛn, 'ʋ 'yɩya 'o Etiɛnɩ 'hʋɩn 'mʋ gbo, 'ʋ klo, 'ʋ gbɔ 'le ‑Juukʋɛ a ‑gboligbo a nahuin ye, ‑ɛ die nu, ʋ 'muo ‑bati lɛ poo, ");
INSERT INTO ted_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","'ʋ lee nahuin ‑ye, 'ke bʋ po Etiɛnɩ hɩ ke, ʋ nɔ: «Nahuon ‑gbo, Nyɩsʋa a 'kagblaka kɔ tetei ꞊nʋ, Nyɩsʋa ‑nyi la Moise, nɩ‑ ɔɔ ‑tɩ ‑hʋɩn 'hʋɩn 'mʋ lɛ ꞊tu. Nɛ‑ ɔ 'cipi 'o nunue. ");
INSERT INTO ted_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","‑A 'wɩn nɩ, ‑tɛ ɔ nyi ꞊tu, ‑ɛ mɔ, Nasalɛtɩ 'mʋ a ‑Yusu ‑gbo, ɔ di Nyɩsʋa a 'kagblaka 'nɩ 'wla, kɔ, ‑a nɩ nunuklɔ, Moise tɔɔ la ‑a nɩ bunʋ, ‑ba 'cɩcɩɔ.» ");
INSERT INTO ted_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nahuin 'bii ꞊nʋ, ‑ʋ nɩ 'le ‑gboligbokayu gbo, ʋʋ Etiɛnɩ 'mʋ ‑hrʋʋ 'yie, ‑ye ʋ 'ye nɩ, ‑ɛ mɔ, 'a yigbaklaa 'nɩ wlɩn, ‑ɛ 'we ꞊nɔ Nyɩsʋa a lɛleenyɔ a yigbakla ye. ");
INSERT INTO ted_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","‑Ye Nyɩsʋa a ‑cɔhlʋnpinyɔ gblaka ꞊gba Etiɛnɩ wlɔn, ɔ nɔ: «꞊Be ‑tɩ 'bii ‑gbo, ʋʋ ‑mʋ yɛɛ, ꞊hapʋkɔɔ nɩ?» ");
INSERT INTO ted_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","‑Ye Etiɛnɩ nɔ: «Bunʋ ‑a, kɔ 'dɩayuo ‑a, ba po 'mʋ nʋa ye gbo. Ti ‑hi la a ti 'yri, Nyɩsʋa, ‑ɔ kɔ ‑tɩ a 'yi'bʋbʋa, nɔ‑ 'hrɩɩ la ‑a nɩ bu gblaka Abrahamʋ ye, ‑tɛ ɔ nɩ la 'le 'a 'blʋgba ꞊nʋ 'mʋ, ʋʋ Mesopotami daa, 'plɩɩ ɔ 'mʋ la 'le Haladɩɔ 'mʋ mu. ");
INSERT INTO ted_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‑Ye kɛ Nyɩsʋaa ꞊nɔ ye po, ɔ nɔ: Abrahamʋ, ‑hɔn nɔ ‑na 'blʋgba ‑gbo 'mʋ, kɔ, hie nɔ ‑na ꞊tugba gbo, ‑bo mu 'le 'blʋgba ꞊nʋ 'mʋ, 'n di ‑mʋ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","‑Ye Abrahamʋ ‑hɔn 'le 'a 'blʋgba 'mʋ nɩ, ‑ɔ mɔ Kalɩdɩkʋɛ a 'blʋgba, ɔ kɔ 'a 'dʋkʋɛ 'hɛɛn, 'ɔ mu 'le Haladɩɔ 'mʋ 'ti wɔn. 'Ke ɔ nɩ 'le ‑nɩnɩ, 'a bu 'ɔ 'kʋ. ‑Tɛ 'a bu 'kʋ 'klɛɛ, ‑ye Nyɩsʋa nue nɩ, 'ɔ di nɔ Kanaablʋgba ‑gbo 'mʋ, ‑ɔ kɔ ke a 'ti kɛ nɔ. ");
INSERT INTO ted_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kɛɛ, Nyɩsʋa 'dio nɔ 'tiilɛ ‑nyi, mɔ, ɔ 'dio ‑wɛ ‑tʋtʋtɩɔ gbi ꞊de ‑nyi. Kɛɛ ‑ye ɔ pue 'le ꞊le, 'ke 'o ꞊nɔ ‑wɔn, ‑ɛ mɔ, ti 'bɩ nyre 'o, ɔ di ꞊nɔ 'blʋgba ‑gbo 'nɩ ‑nyi, ‑ɔ kɔ ke a nɩ nɔ; 'plɩɩ 'bɔ 'kʋ, 'a 'yuo a 'yuo 'mʋ 'blʋgba a ‑gbɛ win ke kɔɔ. Ti a ‑gbɛ 'yri, Abrahamʋ a ‑gbɛ, ɔ 'de la 'yu a kʋɛ. ");
INSERT INTO ted_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","‑Tɩ ꞊nʋ, Nyɩsʋa ꞊tu ꞊nɔ ye, ɩ nɩ‑ ‑gbo: 'Ke ‑na 'yuo di 'le pʋpʋblʋgba ꞊de 'mʋ 'ti, ‑ɔ 'de 'waa 'blʋgba. 'Ke 'le 'blʋgba a ‑gbɛ 'mʋ, ʋ di ‑hɛ ꞊go, ʋ 'mu ꞊sʋɛ ꞊tue, 'ke 'le 'yrɩ a ‑hɔtrʋwɩɩ ‑hɛn (400) 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kɛɛ, dakʋ ꞊nʋ, ‑ʋ kɔ ꞊godɛ ʋ di nu, 'n diu lɛ poo ‑bati. 'Nɩ puu ‑bati lɛ, ‑ye ‑na 'yuo a ‑gbɛ, ʋ di 'le 'blʋgba a ‑gbɛ 'mʋ 'nɩ ‑hɔn, ʋ 'mʋ nɔ di, ʋ 'mʋ nɔ 'na dɩda 'cipi. ");
INSERT INTO ted_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","‑Ye Nyɩsʋa ꞊tue 'yrɩ, ɔ kɔ Abrahamʋ 'hɛɛn. 'Yrɩ a ‑gbɛ, 'a yriilɛ, nɛ‑ mɔ nyɩbɛyu a ye'bɩbɛ. Nɛ‑ kɔ ‑tɩ, ‑tɛ Abrahamʋ a 'yu Yisakɩ kɔ 'wee, 'ɔ 'bɩɔ ye, Yisakɩ ‑mɛ ‑ye 'ɔ 'bɛ 'a 'yu Sakɔbʋ ye, Sakɔbʋ ‑mɛ ‑ye 'ɔ 'bɛ 'a 'yuo꞊plii ‑pu 'tu 'o 'hɔn ye, ‑ʋ mɔ ‑a nɩ dakʋ a ꞊tugbɩ a bunʋ gblakɩ. ");
INSERT INTO ted_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‑A nɩ bunʋ a ‑gbɛ, ʋʋ la ꞊tu ca, 'ke 'o 'waa ‑dɩayu Sosɛfʋ ‑wɔn, 'ʋ plo la, ‑ɛ die nu, ɔ 'mʋ ꞊godɛ nu, 'ke 'le Esipʋblʋgba 'mʋ. Kɛɛ, Nyɩsʋa, nɔ‑ ‑hɩɔ 'mʋ, ");
INSERT INTO ted_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","'ɔ ‑hɩɔ 'le 'a 'kla‑wliye'yɩya 'bii wlɔn. ‑Tɛ Sosɛfʋ a ‑gbɛ, ɔ nɩ la 'o 'blʋgba a ‑gbɛ a bodɩɔ ye, ‑ye Nyɩsʋa nue nɩ, bodɩɔ a ‑gbɛ 'ɔ nʋɛ Sosɛfʋ 'mʋ, 'ɔ 'ye, ‑ɛ mɔ, Sosɛfʋ mɔ ꞊tɔkɔnyɔ'ɔ nɩ, 'ɔ nue, Sosɛfʋ 'ɔ ‑hɛ Esipʋblʋgba 'bii a ‑gʋlʋnʋma, 'ɔ ‑hɛ ‑wɛ bodɩɔ a kayuo 'bii a 'yie꞊tunyɔ. ");
INSERT INTO ted_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","'Ke ʋ nɩ 'o ‑nɩnɩ, ‑ye kanʋ bi la 'le Esipʋblʋgba 'bii 'mʋ nɩ, kɔ Kanaablʋgba 'hɛɛn, ‑tɛ ‑a nɩ bunʋ nɩ la 'le. ‑A nɩ bunʋ a ‑gbɛ, ʋ 'nɩ 'ye ꞊le la dididɛ, 'ʋʋ la ꞊sʋɛ 'ye 'dɔ, kanʋ a ‑tɩ. ");
INSERT INTO ted_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","‑Ye ‑a nɩ bu gblaka Sakɔbʋ 'wɩn nɩ, ‑ɛ mɔ, dididɛ nɩ 'le Esipʋblʋgba 'mʋ, 'ɔ lee 'le ‑a nɩ bunʋ. Nɛ‑ mɔ 'waa ye‑hɛdɛ, 'ke bʋ bla dididɛ. ");
INSERT INTO ted_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","‑Tɛ ʋ kʋɛ 'o gbo, ʋ mu 'le lele ‑do 'hɔn a kɔ, ‑ye Sosɛfʋ titie 'a dɩɔnʋ 'a 'dɩayuo ye, 'ʋ yroo. Kɛ'ɛ nɩ, Esipʋblʋgba a bodɩɔ nu Sosɛfʋ a 'dʋkʋɛ a yiyie. ");
INSERT INTO ted_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","‑Ye Sosɛfʋ le 'a 'dɩayuo nɩ, 'ke bʋ bla 'waa bu Sakɔbʋ, kɔ 'a ꞊tugba a nahuin 'bii 'hɛɛn, ‑ʋ ‑wɛ 'le nahuin a (75) ‑wlɩɩ ta ꞊tu 'o ‑pu ꞊tu 'o ꞊hun. ");
INSERT INTO ted_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kɛ'ɛ nɩ, Sakɔbʋ nu Esipʋblʋgba a 'mʋmumue. 'Kee nɩ, ɔ 'kʋʋ 'le, ɔ kɔ ‑a nɩ bunʋ ‑ye 'hɛɛn. ");
INSERT INTO ted_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","‑Tɛ ʋ 'kʋ, 'ʋ gba 'waa 'kʋkʋkui, 'ke 'le Sisɛmʋdɩɔ 'mʋ, ‑ɔ nɩ nɔ Kanaablʋgba 'mʋ, 'ʋ ‑hɩʋ 'o. 'Dɛɛ ꞊nʋ, Abrahamʋ ‑tɔ la nahuon ‑gbo, ‑ɔ mɔ Hemɔ a 'yuo kwa 'mʋ, nɛ‑ kɔ wlɔn ʋ pu 'le. ");
INSERT INTO ted_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","'Ke ʋ nɩ 'o ‑nɩnɩ, ‑ye Sakɔbʋ, ‑ɔ kɔ 'dʋ mɔ ‑wɛ Yisraɛ, 'a 'yuo, ʋʋ 'nɩ wlo, 'ke 'le Esipʋblʋgba 'mʋ, Yisraɛkʋɛ a ‑gbɛ 'ʋ ‑hɛ dakʋ gblaka. ‑Ye ti ꞊nʋ ‑kɔ 'yri Nyɩsʋa kɔ bɔ nu dɛ ꞊nʋ, ɔ pue la 'le Abrahamʋ, ɩ 'mʋɛɛ yrɛ, ‑ɛ mɔ, bɔ ‑ha 'le ‑a nɩ dakʋ, 'ke 'le ꞊godɛ wlɔn. ");
INSERT INTO ted_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ti a ‑gbɛ 'yri, bodɩɔ yrayrʋ bi gbata ke. Bodɩɔ yrayrʋ a ‑gbɛ, ɔ 'de la Sosɛfʋ yi, ");
INSERT INTO ted_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","'ɔ nu gblagblʋ, 'ɔ kaa ‑a nɩ dakʋ, 'ɔ ꞊tue ‑a nɩ bunʋ ꞊sʋɛ, kɔ, 'ɔ nɩ 'o ꞊nʋ ke 'mʋ, 'ke bʋ hie 'o 'waa 'hɩanpli gblɛ, ʋ kɔ lɛ kɛ, ‑ɛ die nu, ʋ 'mʋ 'kʋ. ");
INSERT INTO ted_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ti a ‑gbɛ 'yri, 'ke ʋ kɔ Moise. Ɔ mɔ 'yuu nɩ, Nyɩsʋa a ꞊wlʋ nʋɛ 'mʋ. 'Ke 'le yakʋɛɛ ta 'kwli 'mʋ, 'a bu kɔ 'a 'dii 'hɛɛn, ʋ ‑hlo nɩ, 'ke 'le 'waa kayu gbo. ");
INSERT INTO ted_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","‑Tɛ ʋ kɔ bʋ hio 'o gbo, ‑ye Esipʋblʋgba a bodɩɔ a 'yu nyrɔyu, nɔ‑ 'yo, 'ɔ 'blo kwa, 'ɔ nyo naa, ‑ɛ 'we ꞊nɔ 'a ‑gbɛ a 'yu ye. ");
INSERT INTO ted_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Nɛ‑ nue, ‑tɛ Moise a ‑gbɛ, ɔɔ 'klɛɛ ku, ‑ye ɔɔ 'nyɩ Esipʋkʋɛ a 'crɩɩnɩɛi kɔ 'waa lɛnu‑tɔplɩ 'bii 'hɛɛn, 'a 'pʋprɛwin 'ɩ nɩ 'klɩ ke. ");
INSERT INTO ted_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","'Ke ɔ nɩ 'o ‑nɩnɩ, 'ɔ ꞊cɛɛ 'yrɩ a ‑wlɩɩ 'hɔn. ‑Tɛ ɔ kɔ 'klɛɛ 'yrɩ a ‑wlɩɩ 'hɔn, ‑ye 'a ꞊wlʋ pue 'le ꞊le, 'ke bɔ 'ye 'a 'dɩayuo Yisraɛkʋɛ. ");
INSERT INTO ted_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","‑Tɛ ɔ mu 'klɛɛ, ‑ye ɔ 'ye Esipʋkʋɛyu ꞊de. Nɔ‑ɔ Yisraɛkʋɛyu ꞊de 'crɛ 'mʋ nu, Moise 'ɔ ‑hɩhɩʋ yrɛ, 'ɔ po 'a 'dɩayu a 'lu 'mʋ a yrʋ, 'ɔ 'la Esipʋkʋɛyu a ‑gbɛ. ");
INSERT INTO ted_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moise ‑mɛ ‑ye, 'a ꞊wlʋ nɔ 'nɩ, 'a 'dɩayuo Yisraɛkʋɛ die 'mʋ lɛ 'nɩ yrii, ‑ɛ mɔ, nɔ‑ kɔ 'mʋ Nyɩsʋa di 'le naa, ɔ 'mu ꞊gbla. Kɛɛ, ʋ 'die 'mʋ lɛ yrii. ");
INSERT INTO ted_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","‑Nyrɛ bɛ cɛ lɛ, ‑ye Moise 'ye Yisraɛkʋɛɛ 'hɔn, 'ʋʋ ‑wɔn. ‑Ye ɔɔ ‑hʋa bɔ nue, bʋ yiyrii win 'mʋ lɛ, ɔ nɔ: ‑A 'bi ‑a, 'a mʋ mɔ ‑dɩayuoo nɩ. Dɛ‑ kɔ ‑gbete aa ‑wɔn 'le? ");
INSERT INTO ted_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kɛɛ, nahuon ꞊nʋ, ‑ɔɔ 'a 'be dɛ 'klan 'mʋ nu, ‑ye ɔ 'nyraa 'le Moise ye, ɔ nɔ: Nyɔ‑ nuu ‑mʋ ‑a nɩ ye'mʋnaanyɔ kɔ ‑a nɩ ‑batiponyɔ 'mʋ 'le? ");
INSERT INTO ted_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","꞊Be ‑n ‑hʋa ‑bo 'la 'mʋ, ‑tɛ ‑n nu 'tʋ, ꞊nɩ 'la 'tʋ Esipʋkʋɛyu ꞊nʋ? ");
INSERT INTO ted_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","'Plɩɩ Moise 'mʋ win a ‑gbɛ mu 'wɔn, nɛ‑ mɔ bɔ 'gba ci lɛ, bɔ ‑hɔn 'blʋ ke 'mʋ, bɔ mu 'le Madiablʋgba 'mʋ. 'Ke ɔ 'ti 'le, 'ɔ kɔ 'le 'yuo꞊plii 'hɔn. ");
INSERT INTO ted_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","'Ke ɔ nɩ 'le ‑nɩnɩ, 'ɛ gba 'yrɩ a ‑wlɩɩ 'hɔn. ‑Nyrɔwɔ ꞊de 'mʋ 'klɛɛ, 'ke ɔ nɩ la 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti, 'ke 'o dʋgba ꞊nʋ 'hʋɩn 'mʋ, ʋʋ Sinai daa. 'Ke 'o ‑tɛgbi a ‑gbɛ, 'ke Nyɩsʋa a lɛleenyɔ 'hrɩɩ 'o ꞊nɔ ye, 'ɔ nɩ 'le ‑gbakuduo 'kwli 'mʋ, ‑gbakuduo a ‑gbɛ 'ɔɔ wlɩn. ");
INSERT INTO ted_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","‑Tɛ Moise 'ye dɛ a ‑gbɛ, ‑ye ɔ ta 'mʋ gbo, 'ɔɔ 'o gbo 'yɩya, ‑ɛ die nu, ɔ 'mʋ 'le lɛ ta. ‑Ye ɔ 'wɔn Kʋkɔnyɔ Nyɩsʋa a wintɛ, 'ɛɛ lɛ po: ");
INSERT INTO ted_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Mɔ mɔ Nyɩsʋa ꞊nʋ, ‑na bunʋʋ la da, ‑ʋ mɔ Abrahamʋ, kɔ Yisakɩ, kɔ Sakɔbʋ. 'Plɩɩ ɔ 'mʋ win a ‑gbɛ mu 'wɔn, ‑ye hʋannʋ bio 'le 'kwli 'mʋ, 'ɔ 'deɛ bɔ ta 'klɛɛ 'le lele lɛ. ");
INSERT INTO ted_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","‑Ye kɛ Nyɩsʋaa ꞊nɔ ye po, ɔ nɔ: ‑Hɛ ‑na 'suei, ‑ɛ nue, ‑tʋtʋtɩɔ, ‑n nɩ 'o ke, ɔ nɩ ye ‑ŋma, 'n ‑do, 'mɔ kʋɔ. ");
INSERT INTO ted_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","꞊Sʋɛ ꞊nʋ, 'na dakʋ Yisraɛkʋɛ, ʋʋ 'ye, 'ke 'le Esipʋblʋgba 'mʋ, 'n ye nɩ, 'nɩ 'wɔn ‑wɛ 'waa ꞊hienwewin, 'plɩɩ 'nɩ di 'le, ‑ɛ die nu, 'mu ꞊gbla. Po 'o nʋa gbo. 'N ‑hʋa ꞊bo lee ‑mʋ, 'ke 'le Esipʋblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‑Ye 'klɛɛ, Moisee ‑do a ‑gbɛ, Yisraɛkʋɛ bla la ye, ‑ɔ kɔ ‑tɩ 'ʋ po la lɛ: Nyɔ‑ nuu ‑mʋ ‑a nɩ ye'mʋnaanyɔ kɔ ‑a nɩ ‑batiponyɔ 'mʋ 'le? ɔ ‑do a ‑gbɛ, nɔ‑ Nyɩsʋa le, 'ke bɔ 'ya 'a dakʋ a ye'mʋnaanyɔ 'mʋ, kɔ 'a ꞊gbʋgblanyɔ 'hɛɛn. ‑Tɛ ɔ 'muo le, 'ke ɔ naa 'le 'a lɛleenyɔ 'mʋ, ‑ɔ nɩ 'le ‑gbakuduo ꞊nʋ 'kwli 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moisee ‑do a ‑gbɛ, nɔ‑ naa 'le 'ŋmilɛka‑tɔplɩ 'mʋ, 'ɔ 'hrɔɔ 'le Yisraɛkʋɛ 'blʋgba ꞊nʋ 'mʋ, ‑ɔ mɔ Esipʋblʋgba, 'ɔ nue, 'ʋ ꞊ta 'Yru ‑Jɔhʋn, 'plɩɩ, 'ke 'le 'yrɩ a ‑wlɩɩ 'hɔn 'kwli 'mʋ, ‑tɛ ʋ nɩ 'le ‑tɛgbi ꞊nʋ, nahuin 'de 'le 'ti, 'ɔ nu lele 'ŋmilɛka‑tɔplɩ ‑ye. ");
INSERT INTO ted_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moisee ‑do a ‑gbɛ, nɔ‑ le Yisraɛkʋɛ, ɔ nɔ: Nyɩsʋa di 'a mʋ ye ya winwlɔn‑hɛnyɔ ‑ye. Nɔ‑ di 'mʋ ye 'we. Ɔ di 'mʋ 'ya ‑a nɩ dakʋ a nahuon. ");
INSERT INTO ted_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moisee ‑do a ‑gbɛ lele, nɔ‑ nɩ la 'o ‑a nɩ dakʋ Yisraɛkʋɛ 'hʋɩn 'mʋ, ti ꞊nʋ ‑kɔ 'yri ʋ 'kukue la lɛ, 'ke 'o ‑tɛgbi ꞊nʋ, nahuin 'de 'le 'ti. 'Ke ‑a nɩ bunʋ a ‑gbɛ, ʋ nɩ la 'le 'pɩa ‑ye ke, Nyɩsʋa a lɛleenyɔ 'ɔ nɩ la ‑wɛ 'le 'pɩa ‑ye ke, 'ke 'le Sinaidʋgba 'lu, Moise 'ɔ nɩ la 'o 'waa ‑hɛyri 'mʋ, Nyɩsʋa a lɛleenyɔ 'ɔ 'prɛɛ 'le Moise ‑wɔn, 'ɔ ‑nyo Nyɩsʋa a wintɛ, ‑ɛ die nu, ɔ 'mue ‑a mʋ tɔɔ. ");
INSERT INTO ted_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Kɛɛ, ‑a nɩ bunʋ 'die ‑hʋa bʋ puo nʋa ye gbo, 'ʋ nyo ye ‑wɔn. 'Waa ꞊wlɩ nye 'nɩ ‑hʋa, 'ke bʋ ꞊hɩan ‑wɔn, bʋ mu 'le Esipʋblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A 'wɔ ꞊de 'mʋ, ‑tɛ Moise 'de la 'le ꞊nʋ ‑hɛyri nɩ, 'ʋ le Moise a 'dɩayu Ayrɔ, ʋ nɔ: Nuu ‑a mʋ tuyuo lɛ, ɔ 'mʋ ‑a nɩ nyɩsʋapʋ 'mʋ 'ya, nahuin di 'ble, ɔ 'mʋ ‑a mʋ 'hru tɔɔ, ‑ɛ nue, Moise ꞊nʋ, ‑ɔ ‑ha 'le ‑a mʋ Esipʋblʋgba 'mʋ, dɛ, ‑ɛ mue 'lu ‑wɔn, 'ke 'o ꞊nɔ ‑wɔn, ‑a 'die yi. ");
INSERT INTO ted_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kɛ'ɛ nɩ, ʋ nu, 'ʋ nu tuyu, ‑ʋ 'we ꞊nɔ briyu ye, 'ʋ pi ‑cɔhlʋn, 'ke 'o tuyu a ‑gbɛ ye, 'ʋ nu lɛ'mimre, 'ke 'o tuyu ꞊nʋ, 'waa ‑gbɛ, ʋ nu a 'yi'bʋaalɛ a ‑ta 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kɛɛ, ‑tɛ ʋ nu dɛ a ‑gbɛ, Nyɩsʋa ‑hɩʋ ‑wɔn 'yie, kɔ, 'ɔ ‑hɩʋ mɛ lɛ, 'ke bʋ ‑tʋa 'yrʋ a dɩda gbo, ʋ kɔ ‑hɔpɔ kɔ yahroyɔ 'hɛɛn. ‑Tɩ a ‑gbɛ, ʋ 'crɩɩ la nɩ, 'ke 'le Nyɩsʋa a winwlɔn‑hɛnyʋ a 'crɩɩnɩɛ ‑ye 'kwli 'mʋ. ‑Tɩ a ‑gbɛ, ɩ nɩ‑ ‑gbo: Nyɩsʋa nɔ 'nɩ: 'A mʋ Yisraɛkʋɛ, ‑tɛ a nu la 'yrɩ a ‑wlɩɩ 'hɔn, 'ke 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti, 'aa la 'wlugba‑tɔplɩ a ‑cɔhlɩn pi, kɛɛ, ɛ 'de 'mɔ Nyɩsʋa, a 'nɩ pie ꞊le la 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","'Baa la ‑ta 'mʋ ‑hɔn, dokwliye ꞊nʋ, ‑ɛ kɔ wlɔn a po 'le tuyu ꞊nʋ, ‑ʋ 'we ꞊nɔ pʋpʋnyɩsʋa Molokɩ ye, dokwliye a ‑gbɛ, nɛ‑ a 'ble, ɛ kɔ ye'wedɛ ꞊nʋ 'hɛɛn, ‑ɛ 'we ꞊nɔ yahroyɛ ꞊nʋ ye, ‑ɛ mɔ pʋpʋnyɩsʋa Yrefan. Tuyuo a ‑gbɛ, a nuo nɩ, ‑ɛ die nu, a 'muo kwlɩ ye gblɛ bla, 'ke 'o 'a 'o꞊tuulɛ a ‑ta 'mʋ. Nɛ‑ nue, 'nɩ die nu, ʋ 'mʋ 'le 'a mʋ pʋpʋblʋgba ‑ye 'mʋ gba, ‑ɔ hren ‑wɔn, 'ɛ ‑hi 'o Babilɔnɩblʋgba 'mʋ. ");
INSERT INTO ted_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","‑Tɛ ‑a nɩ bunʋ nɩ la 'le ‑tɛgbi ꞊nʋ, nahuin ꞊de 'de 'le 'ti, ʋ kɔ la ‑wɛ 'taapɔkayu ꞊nʋ, ‑ʋ mɔ Nyɩsʋa a kayu, ‑ʋ kɔ gbo ʋ po 'le 'hɛ ꞊nʋ, ‑ɛ kɔ ke ʋ 'crɩɩ 'o Nyɩsʋa a tetei. 'Taapɔkayu a ‑gbɛ, ‑tɛ Nyɩsʋa nu 'a gblɛpupue, 'ke 'o Moise ye, kɛ'ɛ nɩ, ʋ nu 'a pupue. ");
INSERT INTO ted_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","'Ta