﻿USE sofia;
DROP TABLE IF EXISTS sofia.tdx_vpl;
CREATE TABLE tdx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tdx_vpl WRITE;
INSERT INTO tdx_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tam-pifotorañ’ añe, namboaren’ Añahare o likerañeo naho ty tane toy, ");
INSERT INTO tdx_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ie amy zay tsy amam‑bintañe naho kòake ty tane toy naho nimoro­­­moro­ñe ty an-tarehe’ i lalekey, vaho nihelahela ambone’ o ranoo t’i Arofon’ Añahare. ");
INSERT INTO tdx_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hoe t’i ­Andrianañahare: Ampiloneahan-kazavàñe; le nisodehan-kazavàñe. ");
INSERT INTO tdx_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Nivazohon’ Añahare i hazavañey te nisoa, le navahen’ Añahare amy ieñey i hazavàñey, ");
INSERT INTO tdx_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","nataon’ Añahare ty hoe Andro i hazavàñey vaho nanoe’e ty hoe Haleñe i ieñey. I haleñey vaho i antoandroy—ty andro valoha’e. ");
INSERT INTO tdx_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Le hoe t’i Andrianañahare: Ampiboahan-dañelañe añivo’ o ranoo hisitaha’ ty rano ami’ty rano. ");
INSERT INTO tdx_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Aa le namboaren’ Añahare i lañelañey vaho navì’e amy rano ambone’ i lañelañey ty rano ambane’ i lañelañey. Le izay ty ie. ");
INSERT INTO tdx_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nataon’ Añahare ty hoe like­rañe i lañelañey. I haleñey vaho i antoandroy—ty andro faharoe. ");
INSERT INTO tdx_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Le hoe t’i Andrianañahare: Hatontoñe antoetse raike o rano ambane’ i likera­ñeio hiboaha’ ty tane maike. Le iizay ty ie. ");
INSERT INTO tdx_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Nataon’Añahare ty hoe Tane i maikey, naho ty hoe Riake o rano nifanontoñeo, le nivazohon’Añahare te soa. ");
INSERT INTO tdx_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Aa le hoe t’i Andrianañahare: Ampitiriañ’ ahetse i taney, rongoñe mamoa voa naho hatae mamoa voa rekets’ àta’e ty amy karaza’ey. Le izay ty ie. ");
INSERT INTO tdx_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Aa le nitirian’ ahetse ty tane toy, rongoñe mamoa voa ty amy karaza’ey, vaho hatae mamoa voa rekets’ àta’e, ty amy karaza’ey. Le nivazohon’ Añahare te soa. ");
INSERT INTO tdx_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","I haleñey vaho i antoandroy—ty andro fahatelo. ");
INSERT INTO tdx_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Le hoe t’i Andrianañahare: Ampiboaheñe failo i lañelañen-dike­rañey hañavake ty antoandro ami’ty haleñe ho vintañe naho famotoañañe naho andro vaho taoñe; ");
INSERT INTO tdx_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ho jiro amy lañelañen-dikerañey hañilo ty tane toy. Le iizay ty ie. ");
INSERT INTO tdx_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Le namboa­ren’ Añahare ty jiro roe jabajaba—hifehe ty andro ty jiro bey naho hifehe ty haleñe ty jiro zai’e—vaho o vasiañeo. ");
INSERT INTO tdx_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Aa le napon’Añahare amy lañelañen-dikera­ñey iereo hañilo ty tane toy ");
INSERT INTO tdx_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","hame­he ty andro naho ty haleñe vaho hañavake i ieñey amy hazavàñey. Ni­vazohon’ Añahare te soa. ");
INSERT INTO tdx_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","I haleñey vaho i antoandroy—ty andro fah’ efatse. ");
INSERT INTO tdx_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Le hoe t’i Andrianañahare: Ampifamorohoteñe raha veloñe hangetseke­tseke o ranoo, naho ampitiliñem-boroñe ty ambone’ tane toy an-tarehe’ i lañelañen-dindìñ’ey. ");
INSERT INTO tdx_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Le namboaren’ Añahare o fañanen-driakeo naho ze hene raha veloñe mihetseke, mifamorohotse amo ranoo, ty amy karaza’ey, naho ze hene voroñe reketse elatse ty amy karaza’ey. Le nivazohon’ Añahare te soa. ");
INSERT INTO tdx_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Nitatan’ Añahare iereo ami’ ty hoe : Manaranàha le mangetseketseha, atsafo o ranon-driakeo, vaho ampangorokitsiheñe voroñe ty an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","I haleñey vaho i antoandroy —ty andro faha-lime. ");
INSERT INTO tdx_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Le hoe t’i Andrianañahare: Hampanaranàheñe an-tane atoy ze raha veloñe iaby ty amy karaza’ey: o hareo, naho o raha milalio naho ze hene bibi’ ty tane toy, ty amo karaza’eo. Vaho iizay ty ie. ");
INSERT INTO tdx_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Le namboaren’ Añahare o bibi’ ty tane toio amo karaza’eo, naho ze karazan’ añombe iaby vaho ze hene karaza-biby misitsitse an-tane atoy. Le nivazohon’ Añahare te soa. ");
INSERT INTO tdx_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Le hoe t’i Andrianañahare: Antao hamboatse ondaty hambam-­bintañ’ aman-tikañe, hifañoronkoroñe aman-tika, hifehe o fian-driakeo naho o voron-tiokeo naho o bibio naho ty tane toy iaby vaho ze biby misitsi­tse an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Aa le namboaren’ Añahare mirai-bintañe ama’e t’indaty, hambam-bintañe aman’ Añahare ty nam­boare’e aze, lahilahy naho ampela ty ni­tsene’e iareo. ");
INSERT INTO tdx_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Nitataen’ Añahare iereo, le hoe t’i Andrianañahare ama’e: Manara­nàha le mangetseke­tseha naho atsefo ty tane toy vaho feleho; le feheo o fian-driakeo naho o voron-tiokeo vaho ze biby misitsitse an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Le hoe t’i Andrianañahare, Heheke te natoloko anahareo ze hene ahetse mamoa ambone’ ty tane toy, naho ze fonga hatae mamoa rekets’ àta’e ty am-po’e ao, ho fikama’areo. ");
INSERT INTO tdx_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Aa ty amo hene bibi’ ty tane toio naho ze fonga voron-tioke vaho ze raha misitsi­tse an-tane atoy, ze kila raha veloñe, le nimeako ze hene ahets’antsetra ho haneñe. Le izay ty ie. ");
INSERT INTO tdx_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Nivazohon’ Añahare o raha namboare’e iabio le hehe te soa. I haleñey vaho i antoandroy—ty andro fah’ eneñe. ");
INSERT INTO tdx_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Aa le nifonitse ty tane toy naho o likerañeo naho ty fitozantoza’ iareo. ");
INSERT INTO tdx_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Nifoniren’ Añahare ami’ty andro faha-fito i fitoloña’ey, le nitroatse ami’ty andro faha-fito amo hene tolon-draha nanoe’eo; ");
INSERT INTO tdx_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Le nitahien’ Añahare ty andro faha-fito vaho nimasiñe’e, amy te ama’e ro nitroara’e amy ze nitsenèn’ Añahare iaby, hamokara’e ka. ");
INSERT INTO tdx_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Inay ty fanoñonañe o like­rañeo naho ty tane toy amy fañamboarañe iareoy. Tamy sa namboare’ Iehovà Andria­ñahare ty tane toy naho o likerañeoy ");
INSERT INTO tdx_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","naho mbe tsy tan-tane ao ze hataen-kivoke naho taolo’ ty nitiria’ ze ahetse am-patrañe ao, vaho mboe tsy nampahavie’ Iehovà Andria­ñahare orañe ty tane, fa tsy teo ty ondaty hahava i taney; ");
INSERT INTO tdx_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","fe niboahan-jono ty tane ze nahatondra-drano ty ambone’ ty tane toy iaby; ");
INSERT INTO tdx_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","le namboare’ Iehovà Andrianañahare ami’ty lembon-tane t’indaty naho nikofo­ha’e tion-kaveloñe o lalam-pian­tsona’eo vaho ninjare fañova veloñe indatiy. ");
INSERT INTO tdx_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Le nañalahala goloboñe maniñanañe e Edene ao t’Iehovà Andrianañahare, vaho navotra’e ao indaty namboare’ey. ");
INSERT INTO tdx_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Le nampitirie’ Iehovà Andrianañahare boak’ an-tane ao ze karazan-katae soa am-pivazohoañe naho mafiry am-pikamañe, le añivo’ i goloboñey ao ty hataen-kaveloñe naho ty hataem-paharendrehañe ty soa naho ty raty. ");
INSERT INTO tdx_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Nikavavàke boak’ Edene ao ty oñe handeñe i goloboñey, ie boak’ ao le nivaky efatse. ");
INSERT INTO tdx_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Pisone ty añara’ ty valoha’e, mañariari’ i hene tane’ Kavilày, ie amam-bolamena; ");
INSERT INTO tdx_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","soa ty volamena’ i taney; añe ty bedo­lake naho ty vato antsetra. ");
INSERT INTO tdx_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Gihone ty añara’ i oñe faharoe mitsikarioke era’ i tane Kosiy. ");
INSERT INTO tdx_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Hidiklà ty añara’ i fahateloy ze miary atiñana’ i Asore; vaho i Perate t’y oñe fah’efatse. ");
INSERT INTO tdx_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Navotra’ Iehovà Andrianañahare an-Golobo’ i Edene ao indatiy hañalahala naho hañambeñ’ aze. ");
INSERT INTO tdx_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Le hoe ty linili’ Iehovà Andrianañahare am’indatiy, Azo’o ikamañe ze hene hatae amy goloboñey ao; ");
INSERT INTO tdx_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","fe ko ikamà’o ty hataem-paharendrehañe ty soa naho ty raty, fa toe hivetrake irehe ami’ty andro ikama’o aze. ");
INSERT INTO tdx_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Le hoe t’Iehovà Andrianañahare, Tsy mahasoa indatiy te ho tokañe, hamboarako mpañimba mañeva. ");
INSERT INTO tdx_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Aa le boak’ amo taneo ty namboare’ Iehovà Andrianañahare ze kila bibin-kivoke, naho ze hene voron-tioke vaho nen­dese’e am’ indatiy hivazoho ze sindre ho tokava’ indatiy aze; aa le ze nitokava’ indatiy ty raha veloñe, le izay ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Nimea’ indatiy añarañe ze hene hare naho voron-tioke, vaho ze biby am-patrañe añe iaby; fa naho indatiy, tsy nioniñe ty mpañolotse mañeva aze. ");
INSERT INTO tdx_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Aa le nampifetsaha’ Iehovà Andria­nañahare am’indatiy ty rotse miheotse, naho ie nirotse le nafaha’e ty pa’e raike vaho nakite’e amy toe’ey ty nofotse. ");
INSERT INTO tdx_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Nitsene ampela t’Iehovà Andrianañahare amy rinambe’e añ’ila’ indatiy vaho nasese’e am’indatiy. ");
INSERT INTO tdx_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Le hoe indatiy, Itoy henaneo ty taola’ o taolakoo naho ty nofo’ o nofokoo; le hatao Rakemba re amy te lahilahy ro nañakarañe aze. ");
INSERT INTO tdx_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Aa le mienga ty rae’e naho i rene’e t’indaty le mipitek’ ami’ty vali’e vaho nofotse raike iereo. ");
INSERT INTO tdx_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ie amy zay, songa nitanjaka indatiy naho i vali’ey fe tsy nimeñatse. ");
INSERT INTO tdx_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Nahay fañahy mandikoatse ze kila karaza-biby namboare’ Iehovà Andria­nañahare an-kivok’ ao ty mereñe. Hoe re amy rakembay: Toe nanao ty hoe hao t’i Andrianañahare: Tsy ikama’ areo ze hatae amy goloboñey ao? ");
INSERT INTO tdx_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Hoe ty natoi’ i rakembay amy mereñey: Azo’ay haneñe o voan-katae amy goloboñeio. ");
INSERT INTO tdx_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Fe hoe ty nitsaraen’ Añahare i hatae raik’ anteñateña’ i goloboñey: Tsy ihihinana’ areo vaho tsy ho tsapae’ areo, tsy mone hivetrake. ");
INSERT INTO tdx_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Le hoe ty asa’ i mereñey amy rakembay, Toe tsy hihomake nahareo, ");
INSERT INTO tdx_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","fa arofoanan’ Añahare te hibolanake ty fiha­ino’ areo amy andro ikama’ areo aze le ho hambañ’ aman’ Añahare mahafohiñe ty soa naho ty raty. ");
INSERT INTO tdx_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Aa naho nioni’ i rakembay te soa kama­eñe i hatae zay, naho naha­sinda am-pihaino naho hatae ­sala­laeñe kanao mampahilala, le ­nampi­pototse ty voa’e naho ­nikama le nanjo­tsoa’e ka t’i vali’e nindre ama’e, vaho nikama re. ");
INSERT INTO tdx_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nibeak’ amy zao ty fihaino’ iareo roroe naho naharen­dreke te sambe niboridañe le navitra’ iareo an-­jaitse ty raven-tsakoa vaho nanoa’ iareo kitambe. ");
INSERT INTO tdx_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Jinanji’ iareo ty fiara­ñanaña’ Iehovà Andria­nañahare, ie nidraidraitse an-goloboñ’ ao naho nitio­tio-drikoñe i àndroy, le nipalitse amo hatae an-goloboñeo indatiy naho i tañanjomba’ey tsy hiatreke am’Iehovà Andrianañahare. ");
INSERT INTO tdx_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Le kinanji’ Iehovà Andrianañahare indatiy amy ty hoe: Aia v’iheo? ");
INSERT INTO tdx_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tinoi’e ty hoe: Tsinanoko amy goloboñey irehe, le nihemban-draho fa nibongy vaho nietake. ");
INSERT INTO tdx_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Le hoe Re: Nivolaña’ ia te ihe ni­halo? Nihinana’o hao i hatae nandra­rako azo tsy ihinanañey? ");
INSERT INTO tdx_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","I rakemba natolo’o ho mpiamakoy, hoe indatiy, ie ty nanjotso amako boak’amy hataey vaho nihaneko. ");
INSERT INTO tdx_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Aa le hoe t’Iehovà Andrianañahare amy rakembay: Inoñ’ o nanoe’oo? Kinalita’ i mereñey, hoe i rakembay, le nihinan-draho. ");
INSERT INTO tdx_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hoe t’Iehovà Andrianañahare amy mereñey : Amy te ihe nanao zao, le fàtse irehe amy ze kila hare naho ze hene bibin-kivoke. Hilalilaly an-tro’o irehe, le deboke ty ho filintse’o amy ze fonga andro hiveloma’o. ");
INSERT INTO tdx_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Le hampirafelahieko amy rakembay, naho o tarira’oo amy tarira’ey. Ho demohe’e ty loha’o vaho ho vonotrobohe’o i tomi’ey. ");
INSERT INTO tdx_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Hoe Re amy rakembay : Ho silofeko ty fioremeña’o, le hanivontivoñe ty fitsongoa’o, t’ie misamak’ anake. Ho fañiriña’o ty vali’o, vaho ie ty hifehe azo. ");
INSERT INTO tdx_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Le hoe ka Re tamy Dame : Amy te nihaoñe’o i vali’oy vaho nikama’o i hatae nandraràko azoy ami’ty hoe : Ko ikama’o; le ho hotohotoeko ty ama’o o taneo. Le an-kamokorañe ty hikama’o ama’e ze hene andro hiveloma’o. ");
INSERT INTO tdx_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Hitiria’e fatike naho hisatse, le hikamae’o ze tirin-traka am-patrañe ao. ");
INSERT INTO tdx_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ami’ty liñe’ o lahara’oo ro hikama’o mahakama ampara’ t’ie himpoly an-debok’ ao; fa tama’e ty nandrambesañ’ azo, lemboke irehe; le mb’an-deboke ty himpolia’o. ");
INSERT INTO tdx_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Natao’ indatiy Haova ty añara’ i vali’ey, amy t’ie ro rene’ ze hene veloñe. ");
INSERT INTO tdx_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Namboara’ Iehovà Andria­nañahare saron-kolitse indatiy naho i vali’ey le naombe’e am’iareo. ");
INSERT INTO tdx_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Le hoe t’Iehovà Andrianañahare, Ingo te ninjare hoe raik’ aman-tika indatiy, maharendreke ty soa naho ty raty. Aa tsy mone hahiti’e ty taña’e hampipototse amy hataen-kaveloñey ka, hikama’e ho veloñe nainai’e; ");
INSERT INTO tdx_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","le nampiavote’ Iehovà Andriañahare amy goloboñe Edeney re handrokake i tane nandrambesañ’ azey. ");
INSERT INTO tdx_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Aa le sinoi’e añe indatiy vaho nampijadoñe’e ke­robe reke-pibara nibela niviombioñe ami’ty atiñana’ i goloboñe Edeney higari­tse ty lala’ i hataen-kaveloñey. ");
INSERT INTO tdx_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nandrèndreke i Haova, vali’e t’i Dame, le nivesatse naho nisamake i Kàine vaho nanao ty hoe: Nahazoako lahilahy t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Nisamake indraike re, le i Hèbele zai’e. Nimpihare añondry t’i Hèbele le nimpiava tane t’i Kàine. ");
INSERT INTO tdx_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ie te indraike, nibanabana ty lengom-boñe’ i taney am’ Iehovà t’i Kàine, ");
INSERT INTO tdx_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","le ninday ty valohan’ ana’ o hare’eo naho ty sabora’e t’i Hèbele. Aa le nitoliha’ Iehovà t’i Hèbele naho i banabana’ey, ");
INSERT INTO tdx_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","fe tsy hinao’e t’i Kàine naho i enga’ey. Niforoforo ami’ty habose’e amy zao t’i Kàine vaho nilonjom-bintañe ");
INSERT INTO tdx_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Inoñe ty iviñera’o hoe t’Iehovà amy Kàine vaho ino ty mahalonjets’ azo? ");
INSERT INTO tdx_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Tsy hiampokòfañe hao irehe naho toloñe’o ty hiti’e? Aa naho tsy soa ty anoe’o le mangonònoke anjili-dalañe ao ty hakeo milelalela te hahazo azo, f’ie feheo. ");
INSERT INTO tdx_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nifanaontsy amy Hèbele rahalahi’e t’i Kàine, aa ie nimb’an-teteke mb’ eo, niambotraha’ i Kàine t’i Hèbele naho nañohofa’e loza. ");
INSERT INTO tdx_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Aa le hoe t’Iehovà amy Kàine, Aia t’i Hèbele rahalahi’o? Tsy fantako, hoe re, mpiambeñ’ an-drahalahiko hao iraho? ");
INSERT INTO tdx_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Hoe re: Ino o nanoe’oo? Inao! mitoreo amako boak’ an-tane ao ty feon-dion-drahalahi’o; ");
INSERT INTO tdx_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","le fa nafà’ i taney irehe henane zao, ie nanoka-bava handrambe an-taña’o i lion-drahalahi’oy. ");
INSERT INTO tdx_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Aa ie miava tane henane zao le tsy hafoe’e ama’o ty haozara’e; ie ho mpirererere naho mpitralantralañe an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Hoe t’i Kàine am’ Iehovà, Tsy leoko babeñe o fandilovañe ahio; ");
INSERT INTO tdx_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","anindroany irehe nanao soik’ ahy amo tarehe’ ty tane toio, naho hampietaheñe amy lahara’oy iraho, le ho mpiriorio naho mpirererere an-tane atoy, vaho songa hañoho-doza amako ze mifanojeha amako. ");
INSERT INTO tdx_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Le hoe t’Iehovà ama’e, Aiy! ho valeñe im-pito ze mamono i Kàine; vaho namiloñe i Kàine t’i Andrianañahare tsy ho vonoe’ ze hifanalaka ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Aa le nienga boak’ añatrefa’ Iehovà t’i Kàine, noly an-tane Rererere, atiñana’ i Edene añe. ");
INSERT INTO tdx_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Nifohi’ i Kàine ty vali’e, le niareñe, nisamake i Kanòke; ie nañoren-drova vaho nitokave’e ami’ty añara’ i Kanoke ana’e. ");
INSERT INTO tdx_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Nisamake Irade t’i Kanoke; le nisamak’ i Mehojaèle t’Irade le nisamak’ i Metosaele t’i Mehojaèle vaho nisamake i Lemeke t’i Metosaele. ");
INSERT INTO tdx_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Nampirafe roe t’i Lemeke; le natao ty hoe Adae ty raike naho i Zilae ty raike. ");
INSERT INTO tdx_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Nisamake Iabale t’i Adae; ie ty raem-pimoneñe an-kibohotse naho mpihare. ");
INSERT INTO tdx_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Natao Iobale ty rahalahi’e, ie ty rae’ o mpititike kararàke naho solio. ");
INSERT INTO tdx_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Nisamake i Tobale-kaine t’i Zilae, ie ty nitsene ze hene haraotse torisìke naho viñe. I Naamae ty rahavave’ i Tobale-kaine. ");
INSERT INTO tdx_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Hoe t’i Lemek’ amo vali’eo: Tsanoño ty feoko ry Adae naho Zilae; Ry vali’ i Lemekeo: mitsendreña o entakoo: Vinonoko t’indaty nandratse ahy, naho ty ajalahy nandafa ahiko. ");
INSERT INTO tdx_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Aa naho i Kàine ro valeañe im-pito, Le toe impitompolo fito amby ka t’i Lemeke. ");
INSERT INTO tdx_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nifohi’ i Dame indraike i vali’ey, le nisamak’ ana-dahy vaho natao’e Sete ty añara’e, fa hoe i rakembay: Fa nanendre anake ho ahy t’i Andrianañahare handimbe i Hèbele vinono’ i Kàine. ");
INSERT INTO tdx_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Nahatoly anake ka t’i Sete, le natao’e Enose ty añara’e. Nifototse amy zay te nikanjy ty tahina’ Iehovà ondatio. izay ty takelam-piantoño’ i Dame. ");
INSERT INTO tdx_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Amy andro namboaren’ ­Añahare ondatioy le nihambam-bintañe aman’ Añahare ty namboare’e iareo. ");
INSERT INTO tdx_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Lahi­lahy naho ampela ty namboare’e iareo naho nitahie’e vaho natao’e ty hoe Ondaty amy andro namboareñe iareoy. ");
INSERT INTO tdx_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ie zato-tsi-telopolo tao t’i Dame, le nahatoly anake hambam-bintañe ama’e vaho natao’e Sete ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Aa ie nisamake i Sete le mbe niveloñe valon-jato taoñe t’i Dame naho nahatoly lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Aa le sivan-jato tsy telopolo taoñe o hene andro’ i Dame te nivilasy. ");
INSERT INTO tdx_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ie niveloñe zato taoñe lim’ amby t’i Sete le nisamake i Enose. ");
INSERT INTO tdx_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Mbe niveloñe valon-jato taoñe fito amby t’i Sete mifototse amy Enose le nisamake lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Aa le sivan-jato tsy folo-ro’amby taoñe o hene andro’ i Sete te nivilasy. ");
INSERT INTO tdx_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ie niveloñe 90 taoñe t’i Enose le nisamake i Kanàne. ");
INSERT INTO tdx_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Mifototse amy nisamahe’e i Kanàney le mbe niveloñe 815 taoñe t’i Enose vaho nisamake lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Aa le 905 taoñe o hene andro’ i Enose te nivilasy. ");
INSERT INTO tdx_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ie niveloñe 70 taoñe t’i Kanàne le nisamake i Mahalalila. ");
INSERT INTO tdx_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mifototse amy nisamahe’e i Mahalalilay le mbe niveloñe 840 taoñe t’i Kanàne vaho nisamake lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Aa le 910 taoñe o hene andro’ i Kanàne te nivilasy. ");
INSERT INTO tdx_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ie niveloñe 65 taoñe t’i Mahalalila le nisamake Ierede. ");
INSERT INTO tdx_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Mifototse amy nisamahe’e Ieredey le mbe niveloñe 830 taoñe t’i Mahalalila le nisamake lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Aa le 895 taoñe o hene andro’ i Mahalalila, vaho nivilasy. ");
INSERT INTO tdx_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ie niveloñe 162 taoñe t’Ierede le nisamake i Kanoke. ");
INSERT INTO tdx_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Mifototse amy nisamahe’e i Kanokey le mbe niveloñe 800 taoñe t’Ierede vaho nisamake lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Aa le 962 taoñe o hene andro’ i Ierede te nivilasy. ");
INSERT INTO tdx_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ie niveloñe 65 taoñe t’i Kanoke le nisamake i Metoselake. ");
INSERT INTO tdx_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mifototse amy nisamahe’e i Metoselakey le mbe nindre fañavelo aman’ Añahare 300 taoñe t’i Kanoke vaho nisamake lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Aa le 365 taoñe o hene andro’ i Kanoke. ");
INSERT INTO tdx_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Nindre fañavelo aman’ Andrianañahare t’i Kanoke, le lia’e tsy teo, amy te rinamben’ Añahare. ");
INSERT INTO tdx_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ie niveloñe 187 taoñe t’i Metoselake le nisamake i Lemeke. ");
INSERT INTO tdx_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Mifototse amy nisamahe’e i Lemekey le mbe niveloñe 782 taoñe t’i Metoselake vaho nisamake lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Aa le 969 taoñe o hene andro’ i Metoselake vaho nivilasy. ");
INSERT INTO tdx_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ie niveloñe 182 taoñe t’i Lemeke le nisamake lahilahy. ");
INSERT INTO tdx_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Natao’e Nòake ty añara’e le nanao ty hoe: Hañohò antika re ami’ty fifanehafantika naho ami’ty fitromaham-pitàn-tika boak’ an-tane’ nafà’ Iehovà toy. ");
INSERT INTO tdx_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Mifototse amy nisamaha’ i Nòakey le mbe niveloñe 595 taoñe t’i Lemeke vaho nisamake lahilahy naho ampela. ");
INSERT INTO tdx_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Aa le 777 taoñe o hene andro’ i Lemeke te nivilasy. ");
INSERT INTO tdx_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Lim’anjato taoñe t’i Nòake, le nisamake i Seme naho i Kame vaho Ièfete t’i Nòake. ");
INSERT INTO tdx_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Nangetseketseke ty ia’ ondaty an-tane atoy vaho nisamak’ ampela ");
INSERT INTO tdx_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","le nioni’ o anan’ Añahareo te montramontra o anak’ ampela’ ondatio naho nañenga ze nitea’e. ");
INSERT INTO tdx_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Aa le hoe t’Iehovà, Tsy hifanjomotse am’ ondatio nainai’e ty Troko, amy t’ie nofotse, le ho zato-tsi-roapolo taoñe ty andro’e. ");
INSERT INTO tdx_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ambone’ tane atoy tañ’andro iizay o Nefalèo naho mbe tafara ka, le vinonje’ o anan’ Añahareo o anak’ ampela’ ondatio vaho nanaranake. Toe nifanalolahy haehae iereo, nilahitsiay. ");
INSERT INTO tdx_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nivazoho’ Iehovà ty halosoran-katse­reha’ ty tane toy naho te nitolon-kara­tiañe avao ty fivetsevetsen-tro’ iareo. ");
INSERT INTO tdx_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Le naneñena’ Iehovà te namboatse ondaty an-tane atoy vaho nanahelo añ’ arofo’e ao. ");
INSERT INTO tdx_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Aa le hoe t’Iehovà, Ho faopaoheko ami’ty tane toy ondaty nitsenèkoo, fonga ondaty naho biby naho o raha misitsi­tseo vaho o voron-tiokeo fa aneñenako t’ie namboareñe. ");
INSERT INTO tdx_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Fe nahaoni-pañisohañe am-pihaino’ Iehovà t’i Nòake. ");
INSERT INTO tdx_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","izay ty fanoñona’ i Nòake. Vantañe t’i Nòake, tsy nanan-tahiñe amo foko’eo, vaho nindre fañavelo aman’ Añahare t’i Noake. ");
INSERT INTO tdx_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nisamake telo t’i Nòake: i Seme, i Kame vaho Ièfete. ");
INSERT INTO tdx_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Ie amy zay nilo-tserek’ añatrefan’ Añahare naho nilifotse ty hapia­rote­ñe ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Nivazoho i Andrianañahare ty tane toy le naheo’e te lò-tsereke naho songa nimontamontan-tsata ondatio. ");
INSERT INTO tdx_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Aa le hoe t’i Andria­nañahare amy Nòake, Fa miatrek’ ahy ty figadoña’ ze atao nofotse, amy te lifo-kapiaroteñe ty tane toy ty am’ iereo, Inao, t’ie hatraoko ro­tsake an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Aa le mandranjia lakam-poloay ami’ty mendoraveñe, le mandranjia efetsefetse amy lakañey vaho hosoro harahake naho solike ty alafe’e vaho ty añate’e. ");
INSERT INTO tdx_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Zao ty hamboare’o aze. Ho kiho telon-jato ty an-dava’ i lakam-poloaiy naho kiho limampolo ty am-pohe’e vaho kiho telo-polo ty haabo’e. ");
INSERT INTO tdx_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Andranjio tafo i lakam-poloaiy vaho ampijebaño kiho raike ty ambone’e; le ano lalambey añ’ila’ i lakam-poloaiy; le andranjio vatsa ambane naho añivo vaho ambone. ");
INSERT INTO tdx_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Toe Izaho le izaho ty hinday fisorotombahan-drano an-tane atoy han­dro­tsake ze nofotse mikofò-beloñe ambane’ i likerañey; kila ho mongotse ze an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Fe ihe ty hañorizako fañina, le himoaha’o i lakam-poloaiy rekets’ o ana-dahi’oo naho i vali’oy vaho o valin’ ana-dahi’oo. ");
INSERT INTO tdx_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Hendese’o mb’an-dakam-poloay ao ty kiroe kiroe amy ze hene raha veloñe, amy ze kila nofotse; le ho velome’o mindre ama’areo, ty lahi’e naho ty vave’e. ");
INSERT INTO tdx_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Amo voroñeo ty amo karaza’eo, naho o hareo ty amo karaza’eo, naho ze fonga biby misitsitsy an-tane atoy ty amo karaza’eo, songa roe ama’e ty hiheo mb’ama’o mb’eo hameloma’o. ");
INSERT INTO tdx_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Fonga añandeso ze karaza-mahakama le atontono ho azo, ho kamae’ areo vaho ho hàne’ iareo. ");
INSERT INTO tdx_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nanoe’ i Nòake. I nandilian’ Añaharey ty nanoe’e. ");
INSERT INTO tdx_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hoe t’Iehovà amy Nòake, Miziliha an-dakam-polo’ay ao, ihe naho o keleia’o iabio, amy te ihe avao ty nitreako vantañe ami’ty tariratse toy. ");
INSERT INTO tdx_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Ampin­drezo ama’o ki-fito-fito amy ze hene karazam-biby malio, ty lahy naho vave, le roe amy ze karazam-biby faly, ty lahy naho i vave’ey ");
INSERT INTO tdx_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","naho sindre fito kiroe-roe amy ze karazam-boron-dikerañe, lahy naho vave, hameloma’e tiry ambone’ ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ie mongotse ty fito andro garagadìñe le hampiaviako orañe efa-polo andro naho efa-polo haleñe ty an-tane-bey atoy; vaho ho faopaoheko ami’ty tarehe’ ty tane toy ze fonga raha veloñe namboareko. ");
INSERT INTO tdx_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nihenefe’ i Nòake ze hene nandilia’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nienen-jato taoñe t’i Nòake te nisorotombak’ ambone’ ty tane toy o ranoo; ");
INSERT INTO tdx_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","le nizilik’ am-po’ i lakam-polo-aiy t’i Nòake rekets’ o ana-dahi’eo naho i vali’e vaho o valin’ ana’iareoo ty amy fiempoempoan-dranoy. ");
INSERT INTO tdx_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Le amo biby malioo naho amo biby fàlio naho amo voroñeo vaho amo raha mi­sitsitse an-tane atoio, ");
INSERT INTO tdx_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kiroekiroe, lahy naho vave, songa nizilik’ an-dakam-poloay mindre amy Nòake, amy nandilian’Añahare i Nòakey. ");
INSERT INTO tdx_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Ie modo ty fito andro le fa an-tane atoy o rano fiempoempoañeo. ");
INSERT INTO tdx_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Amy taom-pah’ enen-jato niveloma’ i Nòake, am-bola’e faharoe, amy andro faha folo-fito-ambi’ i volañeiy, amy an­dro zay le hene nitorotositse ze fihanañan-dranon-tsikeokeoke vaho nisokake o lalan-dikerañe iabio. ");
INSERT INTO tdx_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","An-tane atoy efa-polo andro naho efa-polo haleñe i orañey. ");
INSERT INTO tdx_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Amy andro zay ty nimoaha’ i Nòake naho i Seme, i Kàme naho Ièfete, ana-dahi’ i Nòake rey, naho i vali’ i Nòake vaho ty vali’ i ana’e telo rey amy lakam-poloaiy ao; ");
INSERT INTO tdx_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","ie naho ze hene bibi-ly amy karaza’ey, naho ze fonga hare amy karaza’ey, naho ze mpisi­tsitse misitsitse an-tane atoy iaby amy karaza’ey, vaho ze hene voroñe amy karaza’ey, toe ze kila aman’ elatse. ");
INSERT INTO tdx_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Nizilike mb’amy Nòak’ amy lakam-poloaiy ao, kiroekiroe boak’ amy ze nofotse aman-kofò-beloñe iaby; ");
INSERT INTO tdx_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","le nizilike, lahy naho vave amy ze hene nofotse ty nimoak’ ao, ami’ty nandilian’Añahare aze vaho narindri’ Iehovà ao. ");
INSERT INTO tdx_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Efapolo andro tambone’ ty tane toy i fisorotombahañey; nihamaro o ranoo le nonjone’e i lakam-poloaiy vaho nitoabotse an-tiotio’ ty tane toy eñe i lakam-poloaiy. ");
INSERT INTO tdx_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nitolom-pionjoñe naho nienène ambone’ ty tane toy i ranoy vaho nihafoñ’ ambone’ rano ey i lakam-poloaiy. ");
INSERT INTO tdx_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Akore ty fionjona’ o rano ambone’ ty tane toio kanao nahalipotse ze atao vohitse abo ambanen-dikerañe ey; ");
INSERT INTO tdx_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","toe nilikoare’ i ranoy kiho folo-lim’ amby o vohitseo. ");
INSERT INTO tdx_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Le fonga niopo ze nofotse nisitsitse an-tane atoy ndra voroñe ndra hare ndra biby ly, naho ze fifamorohotam-biby mifamorohotse an-tane atoy, vaho ze fonga ondaty; ");
INSERT INTO tdx_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","le kila nimongotse ze tambone’ i tane nimaikey, ze aman-kofòn-kaveloñe am-piantsona’e ao. ");
INSERT INTO tdx_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Fonga finaopao’e ze raha namboareñe ambone’ ty tane toy, naho ondaty, naho hare, naho ze raha misitsitse, vaho o voron-tiokeo; toe finao’e an-tane atoy. I Nòak’ avao ty nihonka’e miharo amo nindre ama’e an-dakam-poloaio. ");
INSERT INTO tdx_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tambatse ambone’ ty tane toy zato-tsi-limampolo andro o ranoo. ");
INSERT INTO tdx_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Nitiahin’Andrianañahare t’i Nòake naho ze raha veloñe iaby naho ze hene biby nindre ama’e an-dakam‑polo-ay ao. Le nampitiofen’ Añahare ambone’ ty tane toy ty tioke vaho nipendreñe i ranoy; ");
INSERT INTO tdx_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","najihetse iaby ze nitorotositse boak’ an-tsikeokeok’ ao naho o lalan-dikerañeo, naho nisebañeñe ty rano boak’an-dindiñe eñe; ");
INSERT INTO tdx_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","vaho nitolom-pike­trak’ an-tane atoy i ranoy. Ie modo ty zato tsy limampolo andro le fa nizetse i ranoy; ");
INSERT INTO tdx_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","le ami’ty volam-paha-fito, ami’ty andro faha folo-fito’ ambi’ i volañey le nisampe ambone’ ty vohits’ Ararate eo i lakam-poloaiy. ");
INSERT INTO tdx_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nitolom-pizetse avao i ranoy am-para’ ty volam-paha-folo; ie am-baloha’ i volam-pahafoloy le niboake o lengom-bohitseo. ");
INSERT INTO tdx_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ie nimodo ka ty efa-polo andro le sinoka’ i Nòake i lalan-kede namboare’e amy lakam-poloaiiy ");
INSERT INTO tdx_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","vaho nañirake koàke; nihelahela avao re ampara’ te nimaike ty rano ambone’ tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Nampandenà’e boak’ama’e ka ty deho ho mb’eo hahaoniñe hera nizetse an-tane atoy i ranoy; ");
INSERT INTO tdx_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","fe tsy nahatrea ty hipetahan-tombo’e i dehoy, le nimpoly mb’an-dakam-poloay ao fa mboe nihanañe ambone’ ty tane toy iaby i ranoy. Aa le nahiti’e ty fità’e naho rinambe’e vaho nazili’e ho ama’e an-dakañe ao. ");
INSERT INTO tdx_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Mbe nandiñe fito andro ka le nampisangitrife’e mb’eo boak’ amy lakañey indraike i dehoy; ");
INSERT INTO tdx_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ie amy harivay, nimpoly ama’e i dehoy, am-bava’e ao ty raven-olive nipotore’e anianike; aa le nirendre’ i Nòake te nita­ke­trak’ an-tane atoy o ranoo. ");
INSERT INTO tdx_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ie nandiñe fito andro ka le nirahe’e mb’eo i dehoy f’ie tsy nimpoly. ");
INSERT INTO tdx_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Ie amy taom-pahaenen-jato-raik’ ambiy, amy volam-baloha’ey, amy andro valoha’ i volañeiy, le nima­ike o rano ambone’ tane atoio; le nakatra’ i Nòake ty lombo’ i lakam-poloaiy naho nisary, vaho niisa’e te nimaike ty ambone’ i taney. ");
INSERT INTO tdx_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Amy volam-paha-roey, amy andro faha roa-polo-fito-ambi’ i volañeiy le nimaike ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Aa hoe t’i Andrianañahare amy Nòake, ");
INSERT INTO tdx_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Iengao o lakam-poloaio, ihe naho ty vali’o naho o ana’oo vaho o valin’ ana’oo. ");
INSERT INTO tdx_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Akaro mindre ama’o ze fonga raha veloñe ama’ nofotse, o voroñeo naho o hareo naho ze hene mpisitsitse misariosario an-tane atoy, hibodobodo an-tane atoy naho hitomambao vaho hanarànake an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Aa le niavotse t’i Nòake rekets’ o ana-dahi’eo naho i vali’ey naho o valin’ ana’eo. ");
INSERT INTO tdx_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Le sambe niakatse i lakañey ze biby naho raha milaly, naho o voroñeo naho ze misitsitse ambone’ ty tane toy amo karaza’eo. ");
INSERT INTO tdx_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Aa le nañoreñe kitrely ho am’ Iehovà t’i Nòake vaho sindre nandrambesa’e ze biby malio naho ze voroñe malio vaho nañenga soroñe amy kitreliy. ");
INSERT INTO tdx_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ie naha’antsoñe i harifondrifoñañey t’Iehovà le hoe t’Iehovà añ’arofo’e ao, Tsy hafàko ka o taneo ty am’ondatio, fa raty boak’ami’ty faha-ajaja’e ty fisafirin’ arofo’ ondatio; vaho tsy ho rotsaheko ka ze kila raha veloñe manahake i nanoekoy. ");
INSERT INTO tdx_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Aa naho mbe eo ty tane toy, le tsy ho modo ka ty sam-pitongisañe naho fitatahañe, ty hanintsiñe naho hatrovohañe, ty asara naho asotry, ty handro vaho haleñe. ");
INSERT INTO tdx_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Nitatan’Añahare t’i Nòake naho o ana-dahi’eo ami’ty hoe: Mitomboa naho mangetse­ke­tse­ha vaho liforo ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Le amy ze kila biby ambone’ ty tane toy naho amy ze voron-tioke naho amy ze mpisi­tsitse an-tane atoy, vaho amy ze fiañe an-driak’ ao ty fihembañañe naho ty firevendreveñañe ama’ nahareo, fa natolotse am-pità’ areo. ");
INSERT INTO tdx_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ho fikama’ areo ze hene raha veloñe; manahake ty nanolo­rako anahareo o ahetse maindoñindoñeo ty anolorako ze satan’ Añahare. ");
INSERT INTO tdx_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Fe tsy ho kamae’ areo ze nofotse reketse ty havelo’e—i lio’ey. ");
INSERT INTO tdx_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Toe ho paiaeko an-taña’ ze fonga biby naho am-pità’ondaty naho am-pitàn-drahalahi’ ondaty ty lio’areo, ty havelo’areo. Ho paiako ty fiai’indatiy. ");
INSERT INTO tdx_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ze mampiori-dio ondaty, Le hampiorihe’ondaty ka ty lio’e. Fa ami’ty vintan’Añahare ty nitseneañe ondatio. ");
INSERT INTO tdx_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Aa le mahavokara vaho mangetse­ketseha, miraoraòa an-tane atoy vaho mihamaroa ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Le hoe t’i Andrianañahare amy Nòake naho amo ana-dahi’e nindre ama’eo: ");
INSERT INTO tdx_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","Ingo te mañori-pañina ama’areo naho amo tarira’areo hanonjohio iraho, ");
INSERT INTO tdx_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","naho amy ze kila raha veloñe mindre ama’areo, o voroñeo, o hareo, naho ze fonga bibi’ ty tane toy, ze niakatse i lakam-poloaiy, ze kila’ bibi’ ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Horizako ama’areo ty fañinako te tsy hampaitoeñe an-drano fiempoempoañe ka ze kila nofotse, vaho tsy ho rots­ahe’ ty fiempoempoan-drano ka ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Hoe t’i Andrianañahare, Zao ty vilo’ ty fañina ifañinàko ama’areo naho amo kila raha veloñe mindre ama’ areoo pak’amy ze hene tariratse añe: ");
INSERT INTO tdx_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ho reketeko amo rahoñeo ty àvako ho vilo’ ty fañinako ami’ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ie ampandrahoñeko ty ambone’ ty tane toy, le hiboak’ amo rahoñeo i avañey ");
INSERT INTO tdx_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","le ho tiahiko i fañinako ama’ areo naho amo raha veloñe ama’ ­nofotse iabioy; vaho tsy ho empoempoe’ o ranoo ka ze hene nofotse handrotsake aze. ");
INSERT INTO tdx_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Ie amo rahoñeo i avañey, le ho treako vaho ho tiahiko i fañina tsy ho modo añivon’ Añahare naho ze hene raha veloñe ama’ nofotse an-tane atoiy. ");
INSERT INTO tdx_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Hoe t’i Andrianañahare amy Nòake, izay ty ho vilo’ i fañina norizeko añivo’ Ahy naho ze kila nofotse an-tane atoiy. ");
INSERT INTO tdx_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","O ana’ i Nòake niakatse i lakam-poloaio, le i Seme naho i Kame vaho Ièfete. Rae’ i Kanàne t’i Kame. ");
INSERT INTO tdx_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","I telo rey ro ana-dahi’ i Nòake; le boak’ am’ iereo ty nanitsihañe ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Niorotse niava tane t’i Nòake vaho nambole valoboke. ");
INSERT INTO tdx_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ie nikama ty divai’e le nimamo vaho tsy aman-tsaroñe t’ie an-kiboho’e ao. ");
INSERT INTO tdx_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Nizoe’ i Kame, rae’ i Kanàne, ty fiha­lon-drae’e le vinola’e ty rahalahi’e roe alafe ao. ");
INSERT INTO tdx_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Aa le rinambe’ i Seme naho Ièfete ty lamba, le nasampe an-tsoro’ iareo roe le nidisa-voly nanaroñe ty fihalon-drae’e; nitolike ty lahara’iareo tsy nahatrea i fihaloa’ey. ");
INSERT INTO tdx_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Ie nivañoñe amy divai’ey t’i Nòake naho nahafohiñe i nanoa’ i ana-tsitso’ey, ");
INSERT INTO tdx_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","le hoe re, Afàtse t’i Kanàne fa ho mpitorom-pitoroñe amo roahalahi’eo. Hoe ka re, ");
INSERT INTO tdx_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Rengèñe t’Iehovà, Andrianañahare’ i Seme, fa ho mpitoro’e t’i Kanàne. ");
INSERT INTO tdx_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Hampientaren’Añahare t’Ièfete, ie himoneñe an-kiboho’ i Seme, vaho ho mpitoro’e t’i Kanàne. ");
INSERT INTO tdx_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Niveloñe telon-jato tsy limampolo taoñe tafara’ i fiempoempoañey t’i Nòake. ");
INSERT INTO tdx_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nañeneke sivan-jato-tsi-limampolo taoñe ty hene andro’ i Nòake, vaho nihomake. Izay ty fanoñona’ o ana’ i Nòakeo ");
INSERT INTO tdx_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Naho fa añe i fiempoempoañey le nahatoly anake t’i Seme naho i Kame vaho Ièfete; ");
INSERT INTO tdx_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","O tarira’ Ièfeteo le i Gomere, i Magoge, i Madae, Iavane, i Tobale, i Meseke, vaho i Tirase. ");
INSERT INTO tdx_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","O tarira’ i Gomereo le i Askenaze, i Rifate, vaho i Togarmà. ");
INSERT INTO tdx_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","O tarira’ Iavaneo le i Elisà, i Tarsise, i Kitime vaho i Dodanime. ");
INSERT INTO tdx_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Boak’am’iereo ty nampifañavakavaheñe o kilakila’ndatio hifanjarà’ iareo o taneo; songa amam-pisaontsi’e naho hasavereña’e vaho fifehea’e. ");
INSERT INTO tdx_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","O tarira’ i Kameo: i Kose, i Mitsra­ime, i Pota vaho i Kanàne. ");
INSERT INTO tdx_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","O tarira’ i Koseo: i Sebà, i Havilà, i Sabtà, i Ramà, vaho i Sabtekà. O tarira’ i Ramào: i Sebà naho i Dedane. ");
INSERT INTO tdx_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Nisamake i Nimrode t’i Kose; ie niha­lahitsiay an-tane atoy, ");
INSERT INTO tdx_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","nim­pi­tsatsa ra’elahy añatrefa’ Iehovà ami’ty saontsy ty hoe: Manahake i Nimrode, mpangoroñe lahitsiay añatrefa’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nifototse e Bavele ty fifehea’e, le nitakats’ i Sinare naho i Ereke naho i Akade vaho i Kalnè. ");
INSERT INTO tdx_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Niavotse amy taney t’i Asore naho nañoreñe i Ninevè naho i rova atao Rehobotey, i Kèlake vaho ");
INSERT INTO tdx_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","i Resene añivo’ i Ninevè naho i Kèlake—rova jabajaba. ");
INSERT INTO tdx_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","I Mitsraime nisamake i Lody naho i Anamy, naho i Lehaby, i Naftohy, i ");
INSERT INTO tdx_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrosy, i Kaslohy (i niboaha’ o nte-Pilistioy), vaho i Kaftore. ");
INSERT INTO tdx_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Nisamake i Tsidone tañoloñoloña’e t’i Kanàne, naho i Khete ");
INSERT INTO tdx_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","naho i nte-Je­bosey, i nte-Emorey, i nte-Girgasey, ");
INSERT INTO tdx_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","i nte-Khivey, i nte-Arkey, i nte-Siney, ");
INSERT INTO tdx_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","i nte-Arvadey, i nte-Tsemarey vaho i nte-Khamatey. Ie añe le niparaitake alafe’e añe o nte-Kanàneo. ");
INSERT INTO tdx_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Nifototse e Tsidone ty efeefe’ o nte-Kanàneo mioza amy Gerare mb’e Azà, naho mb’e Sedome naho Amorà naho Adamà naho Tseboime am-para’ i Lesà añe. ");
INSERT INTO tdx_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ie ro tarira’ i Kame amo hasavereña’eo naho o fisaontsi’eo amo tane’eo vaho amo fifehea’eo. ");
INSERT INTO tdx_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Amy Seme, rae’o nte-Evre iabio naho rahalahi’ Ièfete zoke’e, ro nisamahañe : ");
INSERT INTO tdx_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Inao o tarira’ i Semeo: i Elame, i Asore, i Arpaksade, i Lode vaho i Arame. ");
INSERT INTO tdx_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","O tarira’ i Arameo, i Oze, i Kole, i ­Getere, vaho i Mase. ");
INSERT INTO tdx_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Nisamake i Selake t’i Arpaksade le nisamake i Evre t’i Selake. ");
INSERT INTO tdx_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Nisamak’ ana-dahy roe t’i Evre, i Pèlege ty tahina’ ty raike, ty amy fizarazaran-tane tañ’andro’e; Iok­tane ty tahinan-drahalahi’e. ");
INSERT INTO tdx_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ioktane nisamake i Almodade naho i Sèlefe, i Khazaremavete, Ierake, ");
INSERT INTO tdx_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","i Hadorame, i Ozale, i Diklà, ");
INSERT INTO tdx_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","i Obale, i Abimaele, i Sebà, ");
INSERT INTO tdx_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","i Ofire, i Khavilà, vaho Iobabe; songa tarira’ Ioktane. ");
INSERT INTO tdx_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Mifototse e Mesà eo ty tane nimoneña’ iareo le miranga mb’e Sefare mb’eo, i vohitse atiñanañey. ");
INSERT INTO tdx_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ie ro tarira’ i Seme amo hasavereña’eo naho o fisaontsi’eo, o tane’eo vaho o fifehea’eo. ");
INSERT INTO tdx_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Ie iaby ro tarira’ o ana-dahi’ i Nòakeo, amo fanoñona’eo, naho amo fifehea’eo; ie ro nipa­raitaha’ ze kila’ondaty an-tane atoy, naho fa añe i fiempoempoañeio. ");
INSERT INTO tdx_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ie henane zay, raike ty fivimby naho fisaontsi’ ze kila ondaty. ");
INSERT INTO tdx_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Aa ie niombotse boak’ atiñanañe le nandoak’ an-tane atao Sinare naho nanjo motombey vaho nañialo eo. ");
INSERT INTO tdx_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Le nifanaontsy ty hoe: Antao hamboatse birìke oroañe soa. Nisolo vato ty birike’ iareo vaho solin-tane ty fanosoha’e. ");
INSERT INTO tdx_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Le hoe iereo: Antao hañoren-drova naho fitilik’ abo aman-dengo mitio­tiotse an-dikerañe añe vaho hanoeñe tahinañe tika, tsy mone hivarakaike an-tarehe’ ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Nizotso mb’eo t’Iehovà hivazoho i rovay naho i fitilik’abo ranjie’ o ana’ ondatioo. ");
INSERT INTO tdx_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Le hoe t’Iehovà, Hehe t’ie ondaty mitokañe, songa aman-tsaontsy raike, le ingo ty fifotoran-draha’e, ie henaneo tsy eo ty hahasebañe ze safirie’ iereo hanoeñe. ");
INSERT INTO tdx_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Aa le antao hizo­tso mb’eo hañalikàlike ty fivimbi’ iareo tsy hifan­ka­hazo saontsy ");
INSERT INTO tdx_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","aa le nampiparatsiahe’ Iehovà ambone’ ty tane toy iereo vaho nijihetse ty fañoreñañe i rovay. ");
INSERT INTO tdx_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ie nanoeñe: Bavèle, amy te navali­tsikota’ Iehovà ze hene saontsi’ ty tane toy vaho nampiparaitahe’ Iehovà ambone’ ty tane bey toy iereo. ");
INSERT INTO tdx_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Izay ty fanoñona’ i Seme. Ie roe taoñe añe i fiempoempoañey, le ni-zato taoñe t’i Seme naho nisamake i Arpaksade. ");
INSERT INTO tdx_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ie nahatoly i Arpaksade t’i Seme le mbe niveloñe 500 taoñe nisamak’ ana-dahy naho anak’ampela. ");
INSERT INTO tdx_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ie niveloñe 35 taoñe t’i Arpaksade le nisamake i Selake, ");
INSERT INTO tdx_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","ie nahatoly i Selake le mbe niveloñe 403 taoñe nisamak’ ana-dahy naho anak’ampela. ");
INSERT INTO tdx_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ie niveloñe 30 taoñe t’i Selake le nisamake i Evre, ");
INSERT INTO tdx_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ie nahatoly i Evre t’i Selake, le mbe niveloñe 403 taoñe nisamak’ ana-dahy naho anak’ampela. ");
INSERT INTO tdx_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Niveloñe 34 taoñe t’i Evre vaho nisamake i Pelege, ");
INSERT INTO tdx_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ie ­nahatoly i Pelege t’i Evre le mbe nive­loñe 430 taoñe nisa­mak’ ana-dahy naho anak’ ampela. ");
INSERT INTO tdx_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Niveloñe 30 taoñe t’i Pelege vaho nisamake i Rehò, ");
INSERT INTO tdx_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ie nahatoly i Rehò t’i Pelege le mbe niveloñe 209 taoñe nisamak’ ana-dahy naho anak’ ampela. ");
INSERT INTO tdx_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Niveloñe 32 taoñe t’i Rehò vaho nisamake i Seroge, ");
INSERT INTO tdx_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ie nahatoly i Seroge t’i Rehò le niveloñe 207 taoñe nisamak’ ana-dahy naho anak’ampela. ");
INSERT INTO tdx_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Niveloñe 30 taoñe t’i Seroge vaho nisamake i Nakhore, ");
INSERT INTO tdx_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","aa naho nahatoly i Nakhore t’i Seroge le niveloñe 200 taoñe nisamak’ ana-dahy naho anak’ ampela. ");
INSERT INTO tdx_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Niveloñe 29 taoñe t’i Nakore te nisamake i Tèrake, ");
INSERT INTO tdx_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","aa naho nahatoly i Terake t’i Nakore le niveloñe 119 taoñe nisamak’ ana-dahy naho anak’ ampela. ");
INSERT INTO tdx_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ie niveloñe 70 taoñe t’i Teràhke le nisamake i Avrame, naho i Nakhore, vaho i Kharane. ");
INSERT INTO tdx_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Izay ty famoliliañe i Teràke. Nisamake i Avrame naho i Nakhore naho i Kharane t’i Terahke. Le nisamake i Lote t’i Kharane. ");
INSERT INTO tdx_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ie mbe veloñe i Teràhke Rae’ey le nihomake e Ore’ o nte-Kasdio t’i Kharane, an-tane nisamaha’e ao. ");
INSERT INTO tdx_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Songa nañenga valy t’i Avrame naho i Nakhore. Sarae ty tahina’ ty vali’ i Avrame, vaho Milkae, ana’ i Kharane ty tahina’ ty vali’ i Nakhore. Rae’ i Milkae naho Iskà t’i Kharane. ");
INSERT INTO tdx_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Betsi­terake t’i Sarae, tsy aman’ anake. ");
INSERT INTO tdx_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Ninday i Avrame ana’e naho i Lote ana’ i Kharane, anan’ana’e, vaho i Sarae vinanto’e ampela, vali’ i Avrame ana’e, t’i Terake, vaho nienga i Ore’ o nte-Kasdìo hionjom-b’e Kanàne fe nivotrake e Kharane, vaho nimoneñe ao. ");
INSERT INTO tdx_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ty andro niveloma’ i Terahke le 205 taoñe. Nihomake e Kharane ao t’i Terahke. ");
INSERT INTO tdx_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Hoe t’Iehovà amy Avrame, Mañaveloa mb’eo; iengao ty tane’o, boak’ amo rolongo’oo naho isitaho ty anjomban-drae’o, vaho mionjona mb’an-tane hatoroko azo añe; ");
INSERT INTO tdx_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","le hanoeko tariratse ra’elahy, naho ho tahieko, le ho bangoeko ty tahina’o, vaho ho fañanintsin-drehe. ");
INSERT INTO tdx_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ho tahieko ze mitat’azo naho hafàko ze mamatse azo; vaho ama’o ro hitahiañe ze hene hasavereña’ ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Aa le nienga amy nitsarà’ Iehovà t’i Avrame, vaho nindreza’ i Lote. Nifitompolo taoñe lim’amby t’i Avrame te niakatse i Kharane. ");
INSERT INTO tdx_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Nente’ i Avrame t’i Sarae vali’e naho ty ana-drahalahi’e Lote, naho ze vara natonto’e vaho ondaty niazo’e e Kharane iabio, le nionjoñe mb’e Kanàne mb’ eo vaho nandoak’ an-tane Kanàne ao. ");
INSERT INTO tdx_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Niranga i taney t’i Avrame am-para’ te nitoetse e Sikeme amo hatae bei’ i Morèo. An-tane eo henane zay ty nte-Kanàne. ");
INSERT INTO tdx_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Nisodeha amy Avrame t’Iehovà nanao ty hoe: Hatoloko amo tarira’oo ty tane toy, le teo ty nañoreña’e kitrely am’Iehovà niheo ama’ey. ");
INSERT INTO tdx_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Nienga re nionjomb’am-bohitse atiñana’ i Betele añe le nañoren-kiboho, ahandrefa’e ty Betele, atiñana’e ty Aý. Teo ty nañoreña’e kitrely am’ Iehovà vaho nikanjy ty tahina’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Le mbe nionjoñe mb’amy fañaveloa’e mb’e Nègeve mb’eoy t’i Avrame. ");
INSERT INTO tdx_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Nimosare i taney, le nizotso mb’e Mits­raime mb’eo hey t’i Avrame nitaveañe añe ty amy fanindria’ i hasalikoañey. ");
INSERT INTO tdx_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Ie fa himoak’e Mitsraime ao, le hoe re amy Sarae vali’e: Inao, apotako ty hasoa vinta’o te isaheñe. ");
INSERT INTO tdx_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Aa naho mahaisak’ azo o nte-Mitsraimeo le, inao: Vali’e iroa, ty ho asa’iareo, naho hañe-doza amako naho hahaen-ko velon-drehe. ");
INSERT INTO tdx_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Ehe, ano ty hoe rahavaveko, hanintsiñako ty ama’o hameloma’o ty fiaiko. ");
INSERT INTO tdx_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ie niavy e Mitsraime añe t’i Avrame le nioni’ o nte-Mitsraimeo ty hamozohozo’ i rakembay. ");
INSERT INTO tdx_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ie niisa’ o menafoe’ i Paròo, le nitsiririe’ iareo amy Parò, vaho nasese añ’anjomba’ i Parò ao. ");
INSERT INTO tdx_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nirambese’e an-talatalasaba ty ama’e t’i Avrame, vaho nanontoñe añondry naho añombe t’i Avrame naho borìke lahi’e, naho mpitoron-dahy naho ampela, naho borìke vave vaho rameva. ");
INSERT INTO tdx_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Fe nampivolevolè’ Iehovà añ’ angorosy t’i Parò naho ze añ’anjomba’e ao iaby ty amy Sarae, vali’ i Avrame. ");
INSERT INTO tdx_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Aa le kinanji’ i Parò t’i Avrame, le hoe ty asa’e: Ino o nanoa’o ahio. Manakore te tsy natao’o amako t’ie vali’o? ");
INSERT INTO tdx_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ino ty nanoa’o ty hoe, Rahavaveko? hera ho rinambeko ho valiko? Ie amy zao, ingo i vali’oy rambeso vaho akia! ");
INSERT INTO tdx_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Aa le nafanto’ i Parò amo mpitoro’eo ty Avrame, naho nampionjone’ iereo mb’eo rekets’ i vali’ey vaho ze hene fanaña’e. ");
INSERT INTO tdx_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Aa le nionjoñe boake Mitsraime ao t’i Avrame naho i vali’ey naho ze vara’e iaby, mb’ atimoy añe, vaho nindre ama’e t’i Lote. ");
INSERT INTO tdx_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Fa nimpañarivo an-kare naho volafoty vaho volamena t’i Avrame. ");
INSERT INTO tdx_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Ie boak’ amy atimoy añe le nionjoñe sikal’ amy Betele, amy namboare’e kibohotse añivo’ i Betele naho i Aý am-pifotora’ey, ");
INSERT INTO tdx_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","amy nañoreña’e kitrely valoha’ey. Teo ty nikanjia’ i Avrame ty tahina’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Nanam-pirai-troke naho mpirai-lia naho kibohotse ka t’i Lote mpindre fañavelo ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Fe tsy nahatsapake iareo roe i taney, hitraofa’ iareo, fa loho bey ty vara’ iareo kanao tsy nahafiharo toboke. ");
INSERT INTO tdx_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Nifampibozizy amy zao o mpiara-lia-rai’ i Avrameo naho o mpiara’ i Loteo. Nimo­neñe amy taney henane zay o nte-Kanàneo naho o nte-Perizeo. ");
INSERT INTO tdx_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Aa le hoe t’i Avrame amy Lote, Ee te tsy hifañolañe tika naho o mpiara’oo naho o ahikoo, amy te mpirahalahy tika. ");
INSERT INTO tdx_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Aa vaho tsy hene miatrek’ azo o taneo? Misitaha amako arè, aa ihe homb’ am-pitàn-kavia mb’eo, le ho mb’an-kavana iraho; ke ihe mb’ am-pitàn-kavana, le izaho mb’ an-kavia. ");
INSERT INTO tdx_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Nampiandra-pihaino t’i Lote, nahatalake te soa fitondrake iaby ty vavatane’ Iordaney eñe manahake ty golobo’ Iehovà, hambañe an-tane Mitsraime amy figodañañe mb’e Tsoare mb’eoy, (taolo’ ty nandrotsaha’ Iehovà i Sedome naho i Amorà). ");
INSERT INTO tdx_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Jinobo’ i Lote i vavatane’ Iordaney iabiy naho nañavelo mb’atiña­nañe mb’eo t’i Lote, ie nifampiria. ");
INSERT INTO tdx_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Nimoneñe an-tane Kanàney t’i Avrame vaho nimoneñe amo rova’ i vavataneio t’i Lote vaho nañoren-kiboho mb’e Sedome añe. ");
INSERT INTO tdx_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ni‑lo tsereke o nte-Sedomeo, vata’e bei-hakeo am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Hoe t’Iehovà amy Avrame, naho fa nisitaha’ i Lote. Ampiandrao fihaino henaneo vaho mitalakesa boak’ amo iambesara’oo mañavaratse naho mañatimo naho maniñana vaho mañandrefa; ");
INSERT INTO tdx_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","amy te hatoloko azo naho amo tarira’o kitro-añ’ afe’eo ze hene tane isa’o. ");
INSERT INTO tdx_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Hampiraeko ami’ty lembo’ ty tane toy o tarira’oo; aa naho mahaiake ty debo’ ty tane toy t’indaty le mete hiaheñe ka o tarira’oo. ");
INSERT INTO tdx_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Miongaha arè le rangao ty andàva’ o taneo naho ty am-pohe’e, fa hene hatoloko azo. ");
INSERT INTO tdx_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Aa le nasi’ i Avrame ty kijà’e le nimb’eo naho nitobe amo hatae jabajaba’ i Mamrè e Khebroneo vaho nañoreñe kitrely am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Tañ’andro’i Amrafele, mpanjaka’ i Sinare, naho i Arioke mpanjaka’ i Elasare, naho i Kedorelaomere mpanjaka’ i Elame, vaho i Tidale mpanjaka’ o Goio; ");
INSERT INTO tdx_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","t’ie nifañotake amy Bera mpanjaka’ i Sedome iereo naho amy Birsà mpanjaka’ i Amorà naho amy Sinabe mpanjaka’ i Admà naho amy Sem’­evere mpanjaka’ o nte-Tsebio vaho amy mpanjaka’ i Bela (toe Tsoare). ");
INSERT INTO tdx_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Fonga nifanontoñe am-bavatane’ i Sidime (i Oñe-Siray) ao i mpanjaka rey. ");
INSERT INTO tdx_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ie fa nitoroñe i Kedorelaomere folo taoñe ro’amby, le niola amy taom-paha-folo-telo ambiy. ");
INSERT INTO tdx_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Ie tan-taom-paha folo‑efats’ ambi’ i Kedorelaomere, ie reketse i mpanjaka mitraok’ ama’e rey ro namo­tsake o nte-Rafào e Asterote-karnaime ao naho o nte-Zòzeo e Hame ao, naho o nte‑Emeo e Save-kiriataime ao ");
INSERT INTO tdx_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","naho o nte-Khoreo am-bohibohi’ i Seire pak’ Eilparane añ’ olo’ i fatrambeiy ao, ");
INSERT INTO tdx_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","vaho nibalike nandoake e Ein-mispàte, (i Kadese izay) le fonga linafa’ iareo ty tane’ o nte-Amalekeo naho ty a o nte-Emore nimoneñe e Khatsatsone-tamareo. ");
INSERT INTO tdx_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Nionjoñe mb’eo amy zao ty mpanjaka’ i Sedome, naho ty mpanjaka’ i Amorà, naho ty mpanjaka’ i Admà, naho ty mpanjaka’ i Tseboime, naho ty mpanjaka’ i Belà (toe i Tsoare), nilahatse hihotakotake am-bavatane’ i Sidime ao ");
INSERT INTO tdx_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","amy Kedoreaomere mpanjaka’ i Elame naho amy Tidale mpanjaka’ o Goio naho amy Amrafele mpanjaka’ i Sinare vaho amy Ariokhe mpanjaka’ i Elsara, ty mpanjaka efatse miatreke lime. ");
INSERT INTO tdx_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ie amy zao nitsitsike kadahan-tsolike mainte ty vava-tane’ i Sidime; aa naho nitrimban-day ty mpanjaka’ i Sedome naho i Amorà le nikorovok’ ao vaho nivongaritse mb’am-bohibohitse mb’eo o nisisao. ");
INSERT INTO tdx_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Aa le fonga finao’ o naha-reketseo ze vara’ i Sedome naho i Amorà naho ty mahakama’ iareo vaho nienga; ");
INSERT INTO tdx_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","aa ie niavotse le tinava’ iareo ka t’i Lote, ana-drahalahi’ i Avrame, nimoneñe e Sedome ao, naho o vara’eo. ");
INSERT INTO tdx_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Teo ty niponiotse mb’ amy Avrame nte-Evre mb’eo nitalily; ie nimoneñe amo hatae ra’elahi’ i Mamrè nte-Amore, rahalahi’ i Eskole naho rahalahi’ i Anereo. Ie songa mpirimboñe amy Av­rame. ");
INSERT INTO tdx_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Aa naho jinanji’ i Avrame te tsinepake i rahalahi’ey le kinoi’e o ajalahi’e 318 voa-oke, sinamake añ’akiba’eo vaho hinorìda’e pake Dane añe. ");
INSERT INTO tdx_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Zinara’ i Avrame amy haleñey ondati’eo le zinevo’e vaho hinorìda’e pak’e Khobà an-kavia’ i Damesèk’ añe, ");
INSERT INTO tdx_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","naho nahere’e iaby i varay le nendese’e moly t’i Lote longo’e naho o vara’eo, naho o rakembao vaho ondatio. ");
INSERT INTO tdx_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ie nimpoly amy fanjamana’e i Kedoreaomere naho o mpanjaka mpiama’eoy t’i Avrame, le niakatse hifanalaka ama’e am-bava­tane’ i Save, toe Vavatanem-Panjaka, ty mpanjaka’ i Sedome. ");
INSERT INTO tdx_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Le nañakatse mofo naho divay t’i Melkitsedeke, mpanjaka’ i Salème, Mpisoron’ Añahare Andin­di­mo­neñey, ");
INSERT INTO tdx_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","le nitat’ aze ami’ty hoe: Ho tahien’ Añahare Abo-Tia, Andrianamboatse o likerañeo naho ty tane toy t’i Avrame. ");
INSERT INTO tdx_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Andriañeñe t’i Andrianañahare Mitiotiotse nanjotso o rafelahi’oo am-pità’oy. Le natolo’ i Avrame aze ty fahafolo’ ze he’e. ");
INSERT INTO tdx_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Nanao ty hoe amy zao ty mpanjaka’ i Sedome, Atoloro ahiko ondatio, le tano ho azo o varao. ");
INSERT INTO tdx_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Fa hoe t’i Avrame amy mpanjaka’ i Sedomey, fa nonjoneko am-panta am’ Iehovà, Andrianañahare Andindimoneñey ty sirako, ");
INSERT INTO tdx_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","t’ie tsy handrambe ndra fole ndra talin-kana ndra inoñ’ inoñ’ amo azoo, tsy mone hanoa’o ty hoe: Izaho ty naha-mpañarivo i Avrame, ");
INSERT INTO tdx_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","naho tsy ze nikama’ o lahilahikoo naho ty anjara’ ondaty nindre lia amakoo—i Anere, naho i Eskole, naho i Mamrè; apoho sindre hangalake ty anjara’e irezay. ");
INSERT INTO tdx_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Modo izay le nañento an’ aro­ñaroñe amy Avrame ty tsara’ Iehovà: Ko hemban-drehe, Avrame. Izaho ro fikalan-defo’o naho tambe’o ra’elahy. ");
INSERT INTO tdx_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Le hoe t’i Avrame, Ry Talè Iehovà, ino ty ho mea’o ahiko kanao betsiterake, vaho i Elièzere nte-Damaskose ro mpamandroñe ty akibako. ");
INSERT INTO tdx_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Le tinovo’ i Avrame ty hoe: Tsy nimea’o tiry iraho; aa le mpandovako i nitoly an-kibohokoy. ");
INSERT INTO tdx_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Le hoe ty tsara’ Iehovà ama’e: Tsy ie ty ho mpandova’o, fa ty hiboake am-bania’o ao ty ho mpandova’o. ");
INSERT INTO tdx_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Nendese’e alafe ao le nanoa’e ty hoe: Miandrandrà mb’ andikerañ’ eñe vaho iaho o vasiañeo naho lefe’o iaheñe. Le hoe re tama’e, Mira amy zay ty ho tarira’o. ");
INSERT INTO tdx_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Niantofa’e t’Iehovà, le vinolili’e ho havantañañe ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Hoe ka Re tama’e: Izaho Iehovà ty nañakatse azo amy Ora’ o nte-Kasdìo hanolorako azo ty tane toa han­dram­besa’o aze. ");
INSERT INTO tdx_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Fa hoe t’i Avrame, Ry Talè Iehovà, aia ty haharendrehako ty hatò t’ie ho fanañako? ");
INSERT INTO tdx_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Aa le hoe re tama’e: Añendeso ty kiloa telo-ay, naho ty ose-vave telo-taoñe, vaho ty añondri­lahy telo-taoñe, naho ty deho vaho ty ana-boromahilala. ");
INSERT INTO tdx_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Aa le nandesa’ i Avrame naho nisalàhe’e vaho nalaha’e hifañatreke i tampa’e rey fe tsy nisalahe’e o voroñeo. ");
INSERT INTO tdx_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ie nivotrak’ amy henay o koàkeo le sinoi’ i Avrame añe. ");
INSERT INTO tdx_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nitsofotse i àndroy, le nilampon-drotse t’i Avrame, vaho ingo nandrongoñe aze ty hamoromoroñañe nampangebahebake. ");
INSERT INTO tdx_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Le hoe Re amy Avrame, Mahafohina an-katò te ho ambahiny an-tane tsy a’ iareo o tarira’oo naho hitoroñe iareo vaho hampisotrieñe efa-jato taoñe. ");
INSERT INTO tdx_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Le ho zakàko i tane mañondevo iareoy vaho hinday vara tsifotofoto t’ie hiakatse boak’ ao. ");
INSERT INTO tdx_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Fa homb’ aman-droae’o mb’eo am-pierañeràñan-drehe vaho haleveñe ami’ty taoñe soa haantetse. ");
INSERT INTO tdx_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Hitampoly atoy iereo ami’ty tariratse fah’ efatse, amy te mbe tsy heneke ty hakeo’ o nte-Emoreo. ");
INSERT INTO tdx_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ie nimotake i àndroy vaho nimaìeñe, le niheo mb’eo ty valàñe nahatoeñe naho ty foroha nibela niranga añivo o linili’eo. ");
INSERT INTO tdx_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Amy andro zay ty nanoa’ Iehovà fañina amy Avrame ami’ty hoe, Atoloko amo tarira’oo ty tane hirik’amy saka’ i Mitsraimey pak’ amy oñe jabajabay, i oñe Eofratay; ");
INSERT INTO tdx_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","naho o nte-Keneo, o nte-Kenizeo, o nte-Kadmoneo, ");
INSERT INTO tdx_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","o nte-Kheteo, o nte-Perizeo, o nte-Rafào, ");
INSERT INTO tdx_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","o nte-Emoreo, o nte-Kanàneo, o nte-Girgaseo, vaho o nte-Ieboseo. ");
INSERT INTO tdx_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ie amy zao, mbe tsy nahatoly anake ho aze t’i Sarae, vali’ i Avrame, f’ie aman’ ondevo nte-Mitsraime atao Khagare, ");
INSERT INTO tdx_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","aa le hoe t’i Sarae amy Avrame, Heheke henaneo te kinala’ Iehovà Iraho tsy hiterake. Ehe, mimoaha amy fetrek’ orokoy, kera hahasavereña’e. Niantofa’ i Avrame ty enta’ i Sarae. ");
INSERT INTO tdx_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Aa naho fa nimoneñe e Kanàne folo taoñe t’i Avrame, le nala’ i Sarae vali’e t’i Khagare mpitoro’e vaho natolo’e amy vali’ey hialoza’e. ");
INSERT INTO tdx_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Le nimoaha’e t’i Khagare, vaho niareñe. Aa ie nahafohiñe te nivesatse le nisirikae’ o maso’eo i tompo’ey. ");
INSERT INTO tdx_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Le hoe t’i Sarae amy Avrame, Boak’ ama’o ty fisotriako. Napoko am-pità’o i mpitorokoy, aa kanao apota’e te mivesatse, le sirikaeñe a-maso’eo iraho. Ee te hizaka añivon-tika t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","An-taña’o i mpitoro’oy, hoe t’i Avrame. Ano ama’e ze no’ ty tro’o. Aa le nampisoañe’ i Sarae t’i Khagare vaho nibotatsake amy fiatrefa’ey re. ");
INSERT INTO tdx_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tendrek’amy Khagare t’i anjeli’ Iehovà marine ty rano migoangoañe an-dratraratra añe, ty figoangoan-drano an-dalañe mb’e Sore mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Le hoe re, O Khagare, mpitoro’ i Sarae, boak’ aia v’iheo vaho homb’aia? Hoe re, Milay an‑da­hara’ i tompoko Saraey iraho. ");
INSERT INTO tdx_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Aa hoe ty anjeli’ Iehovà ama’e, Mim­polia mb’amy tompo’oy vaho miam­banea am-pità’eo. ");
INSERT INTO tdx_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Hoe ka ty anjeli’ Iehovà ama’e, Toe hampi­tom­­boako o tarira’oo kanao tsy ho hay iaheñe ami’ty fangitsikitsiha’e. ");
INSERT INTO tdx_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Le hoe ty anjeli’ Iehovà ama’e, Fa miareñe irehe vaho hisamak’ anadahy; hatao’o Iesmaèle ty añara’e, amy te nihaoñe’ Iehovà ty fisotria’o. ");
INSERT INTO tdx_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ho borìke hako indatiy hañonjoñe sirañe amy ze hene ondaty, le ondaty iabio ty hañonjon-tsirañe ama’e; vaho himoneñe añatrefa’ o longo’e iabio re. ");
INSERT INTO tdx_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Aa le kinanji’e ty hoe Elroy t’Iehovà nitsara ama’ey: fa hoe re, Ihe ro Andrianañahare mahavazoho ahy, le hoe re: Aa vaho toe nitreako hao i Mahavazoho ahy? ");
INSERT INTO tdx_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Le natao ty hoe Bire-lakhai-roy i vovoñe añivo’ i Kadese naho i Beredey. ");
INSERT INTO tdx_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Nisamak’ ana-dahy ho a i Avrame t’i Khagare vaho nimea’ i Avrame añarañe ty hoe Iesmaèle i ana-dahi’e nasama’ i Kagarey. ");
INSERT INTO tdx_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Valompolo taoñe eneñ’ amby t’i Avrame te nisamake Iesmaèle t’i Khagare. ");
INSERT INTO tdx_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Naho ni-sivampolo taoñe sive’ amby t’i Avrame le niboak’ amy Avrame t’Iehovà nanao ama’e ty hoe, Izaho i El-Saday; mañaveloa añatrefako an-kalio-tahiñe, ");
INSERT INTO tdx_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","le hifanao fañina, ihe naho Izaho, hampahatsifotofoto azo. ");
INSERT INTO tdx_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Nibabok’ an-dahara’e t’i Avrame; naho nifanaontsy ama’e t’i Andrianañahare, ");
INSERT INTO tdx_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Naho izaho, inao, ty ifañinako ama’o: Ho rae’ ty foko maro irehe. ");
INSERT INTO tdx_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Le tsy hatao Avrame ka ty añara’o, fa Avrahame ty ho tahina’o amy te hanoeko raem-poko tsiefa. ");
INSERT INTO tdx_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Hampibodobodoeko naho hanoeko rofoko maro, vaho mpanjaka maro ty hiboak’ ama’o. ");
INSERT INTO tdx_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Le hajadoko añivoko naho ihe naho ze hene tiry manonjohy azo, tariratse an-tariratse, ty fañinako, ho fañina nai­nai’e, le ho Andrianañahare’o naho amo tarira’o manonjohy azoo. ");
INSERT INTO tdx_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Le hatoloko azo naho o tariratse manonjohio ty tane ambahinie’o henaneo, naho ty tane Kanàne iaby ho fanaña’o nainai’e vaho ho Andrianañahare’ iareo iraho. ");
INSERT INTO tdx_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Hoe t’i Andrianañahare amy Avrahame, Aa le hitañe ty fañinako irehe, ihe naho o tarira’oo naho ze hene hanonjohio. ");
INSERT INTO tdx_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Intoy ty fañinako ho vonti­tire’areo añivoko naho ihe vaho o tariratse hanonjohy azoo te songa ho savareñe ze lahilahy ama’areo. ");
INSERT INTO tdx_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ho tampahe’ areo ty ofo’areo; izay ty ho vilo’ i fañina añivo anahareo naho izahoy. ");
INSERT INTO tdx_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Ho savareñe ami’ty andro fahavalo’ ze lahilahy amo tarira’o iabio, ty nisamak’ añ’ anjomba’ areo ao, naho ty vinily drala amo ambahiny tsy tiri’oo. ");
INSERT INTO tdx_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Tsy mete tsy songa savareñe ze nitoly añ’ anjomba’o ao ndra vinilin-drala’o; fa ho vilom-pañinako nainai’e ami’ty nofo’ areo. ");
INSERT INTO tdx_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ze lahilahy tsy afa-boy, tsy tinampak’ofoke, le haitoañe amo longo’eo indatiy, amy te nivalik’ amy fañinakoy. ");
INSERT INTO tdx_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Hoe t’i Andrianañahare amy Avrahame, Aa naho i Sarae vali’o, tsy hatao’o Sarae ka ty añara’e fa Sarà ty ho tahina’e. ");
INSERT INTO tdx_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Hampanintsiñeko re naho ho meako anadahy ama’e irehe. Toe ho tahieko, le hahatoly foko maro re, vaho mpanjakam-poko maro ro hiboak’ ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Nibabok’ an-dahara’e amy zao t’i Avrahame naho nian­kahake, nanao ty hoe an-tro’e ao, Hisamak’ anake hao ty fa zato taoñe? Hahatoly anake hao t’i Sarà, ie sivam­­polo taoñe? ");
INSERT INTO tdx_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Le hoe t’i Avrahame amy Andrianañahare, Ee te ho veloñe añatrefa’o t’Iesmaèle. ");
INSERT INTO tdx_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Hoe t’i Andrianañahare, Aiy! toe hisamak’ anake ho azo t’i Sarà vali’o naho hatao’o Ietsàke ty añara’e, vaho horizako ama’e i fañinakoy ho fañina nainai’e tsy modo ho aze naho o tarira’e hanonjohy azeo. ");
INSERT INTO tdx_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Le ty am’ Iesmaèle, fa tsinanoko irehe; ho tahieko naho hampirao­raoeko ho tsifotofoto o tarira’eo; hisamak’ ana-donake folo ro’ amby re vaho hanoeko foko ra’elahy. ");
INSERT INTO tdx_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Fe Ietsàke ty hañorizako i fañinakoy, ie ho samahe’ i Sarà ami’ty andro nifantañeñe toy ami’ty taoñe manonjohy. ");
INSERT INTO tdx_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ie nagado’e i nitsara’ey, le nienga i Avrahame t’i Andrianañahare. ");
INSERT INTO tdx_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Aa le rinambe’ i Avrahame ty ana­dahi’e Iesmaèle rekets’ o naterak’ añ’an­jom­ba’eo naho o vinili’e an-drala’eo naho ze lahilahy añ’ anjomba’ i Avrahame ao vaho tinampa’e amy andro ni­tsaraen’ Añaharey ty ofo’iareo. ");
INSERT INTO tdx_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ni-sivampolo sive-amby taoñe t’i Avrahame te sinavatse ty nofo’ i ofo’ey. ");
INSERT INTO tdx_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ni-folo telo-amby taoñe ka t’Iesmaèle te tinampake ty nofo’ i ofo’ey. ");
INSERT INTO tdx_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Sambe sinavatse amy àndroy avao t’i Avrahame naho Iesmaèle ana’e, ");
INSERT INTO tdx_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","songa nindre sinavatse ama’e ze lahilahy añ’ anjomba’e naho ze nitoly añ’ anjomba’e ao vaho ze vinili-drala ami’ty ambahiny. ");
INSERT INTO tdx_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Niheo ama’e marine o hatae jabajaba’ i Mamrèo t’Iehovà, ie niambesatse an-dalambein-kiboho’e eo an-kavotrohañ’ andro. ");
INSERT INTO tdx_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Nampiandra fihaino re nahaoniñe ondaty telo nijohañe ey. Ie niisa’e, le nihitrike boak’ an-dala’ i kiboho’ey nifanalaka am’iereo vaho niondrek’an-tane, ");
INSERT INTO tdx_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","le nanao ty hoe: Naho nanjo fañisohañe am-pihaino’o Iraho henaneo ry Talè, ko rioñe’o ty mpitoro’o. ");
INSERT INTO tdx_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Angao hanesean-drano kedekede hanasà’areo fandia, ie mitofà ambane’ o hatae eio, ");
INSERT INTO tdx_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","le hanjotsoako mahakama minjilite’e hampanintsiñe ty arofo’o, heneke izay t’ie hañavelo, fa izay ty niaria’ areo mb’ami’ty mpitoro’o toy. Le hoe iereo, Ano i sinaontsi’oy. ");
INSERT INTO tdx_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Aa le nihitrike mb’amy Sarà an-kiboho’e ao: Masikà hoe re, halankaño mona telo fañaranañe: kobao le anoñafo mofo. ");
INSERT INTO tdx_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nilay mb’an-troke raike mb’eo amy zao t’i Avrahame nijoboñe dronga maleme hena vaho natolo’e ami’ty ajalahy hañalankaña’e masika. ");
INSERT INTO tdx_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Nendese’e amy zao ty venten-kabobo naho ronono naho i dronga nihalankañeñey, vaho nazotso’e am’ iereo, le nijohañe marine’ iereo añ’ alo’ i hatae’ey t’ie nikama. ");
INSERT INTO tdx_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Hoe iereo tama’e. Aia ty vali’o Sarà? Le hoe re, Indroañe amo kibohotseo. ");
INSERT INTO tdx_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Le hoe re, Toe hibalihako, homb’ etoan-draho ami’ty sa-mañeva vaho Inao! hisamake ana-dahy t’i Sarà tañanjomba’o. Nahajanjiñe izay t’i Sarà an-dala’ i kiboho­tsey, toe amboho’e ao. ");
INSERT INTO tdx_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nibey t’i Avrahame naho i Sarà henane zay, nigain-kantetse vaho tsy ni-ampela ka t’i Sarà. ");
INSERT INTO tdx_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Aa le nisomobohe’ i Sarà añ’arofo ao ty hoe: Izaho fa bey hao ro mbe hinembanembañe, naho fa bey ka i talèkoy? ");
INSERT INTO tdx_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Le hoe t’Iehovà amy Avrahame, Inoñe ty nampitohake i Sarà t’ie nanao ty hoe, Toe hahatoly anake hao, izaho fa bey? ");
INSERT INTO tdx_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Eo hao ty tsy lefe’ Iehovà? Hibalike mb’ama’o Iraho amy andro nifantañañey, an-tsa mañeva vaho hitendreke ana-dahy amy Sarà. ");
INSERT INTO tdx_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Niliere’ i Sarà ami’ty hoe, Izaho tsy nihehe! ie nihembañe. Aiy, hoe re, toe nitohàke. ");
INSERT INTO tdx_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nienga amy zao indaty rey, nitalake ty tarehe’ i Sedome; le nindreza’ i Avrahame hasese’e mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Aa hoe t’Iehovà, Haètako amy Avrahame hao ty hanoeko, ");
INSERT INTO tdx_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","fa toe ho foko ra’elahy naho maozatse t’i Avrahame, vaho ie ty hahasoa-tata ze kila foko’ ty tane toy? ");
INSERT INTO tdx_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Apotako te hitoroa’e o ana’eo naho i hasavereña’e hanonjohy azey ty hifahatse amo sata’ Iehovào hañorike ty hiti’e naho ty hatò; vaho ho henefe’ Iehovà i nitsarae’e amy Avrahamey. ");
INSERT INTO tdx_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Le hoe t’Iehovà, Mireoreo ty fitoreova’ i Sedome naho i Amorà, vaho loho mampioje o hakeo’eo! ");
INSERT INTO tdx_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Tsy mete tsy hizotsoako handrendreke hera toe nanoeñe o hene toreo nahatakatse ahikoo; fa naho tsie le ho fantako. ");
INSERT INTO tdx_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Aa le nitolike mb’eo indaty rey nimb’e Sedome añe, fe mbe nijohañe añatrefa’ Iehovà eo t’i Avrahame. ");
INSERT INTO tdx_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Niharinea’ i Avrahame le nanoa’e ty hoe, Haitoa’o mindre amo tsereheñeo hao ty vantañe? ");
INSERT INTO tdx_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","He te limam-polo ma­hity ro amy rovay ao, haitoa’o hao vaho tsy hapo’o i toetsey ty amy vantañe limampolo ama’e rey? ");
INSERT INTO tdx_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Lavits’ azo ty hanao izay, ty ham­pi­traofe’o fanjamanañe amo lo tsere­keo o vañoñeo, hampa­mirañe amo ratio ty toli’ o mahitio! Tsy marine azo izay! Tsy hanao ty hatò hao ty Mpizaka’ ty tane bey toy? ");
INSERT INTO tdx_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Le hoe t’Iehovà, Naho hanjo ondaty ma­hity limampolo amy rovay, le hene hiheveako ty am’iereo i rovay. ");
INSERT INTO tdx_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tinoi’ i Avrahame ty hoe: Ie zao, fa rinambeko ty hitaroñe entam-bolañe amy Talè, izaho deboke naho lavenoke. ");
INSERT INTO tdx_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Hera ho po-lime i limampolo vantañe rey, ho fonga rotsahe’o hao i rovay ty amy limey? Le hoe Re, Naho manjo efapolo lim’ amby ao le tsy ho rotsaheko. ");
INSERT INTO tdx_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Nindrae’e ty hoe, Ke te ho efapolo ty zoeñe ao? Tinoi’e ty hoe: Ty amy efapoloy tsy hanoeko. ");
INSERT INTO tdx_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Le hoe re, Ee te tsy ho viñera’ i Talè t’ie mivolañe. Hera telo-polo ty ho zoeñe ao? Tinoi’e ty hoe, Tsy hanoeko ka te tendrek’ ahy ty telopolo. ");
INSERT INTO tdx_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Hoe re, Kanao rinambeko ty hinday entañe amy Talè; atao t’ie roapolo ty ho oniñe ao? Tinoi’e ty hoe, Ty amy roapolo rezay, tsy harotsako. ");
INSERT INTO tdx_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Le hoe re. Ee any te tsy ho viñetse amako t’i Talè ami’ty entako honka’e toy; atao t’ie folo ty ho zoeñe ao. Tinoi’e ty hoe, Tsy ho rotsaheko ty amy folo rey. ");
INSERT INTO tdx_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Ie niheneke i tsara’e amy Avrahamey, le nienga t’Iehovà; vaho nimpoly mb’an-toe’e mb’eo t’i Avrahame. ");
INSERT INTO tdx_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nandoake e Sedome amy harivay i anjely roe rey, naho niambesatse an-dalam-bei’ i Sedome ey t’i Lote. Niisa’ i Lote, le niongake hifanalaka am’iereo vaho naboko’e an-tane ty lahara’e. ");
INSERT INTO tdx_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Hoe re: Eo hey, ry roandriañeo, Ehe, mivevea mb’ an-traño’ o mpitoro’oo mb’eo hia­leñe ao naho hanasa fandia; le mañaleñaleña hanonjohy ty lia’ areo. Hoe iereo, Aiy, apoho hialeñe an-kiririsa atoy. ");
INSERT INTO tdx_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Fe nimanea’e fiboliboly le nitolike iareo nimoak’ añ’anjomba’e ao; le naña­lankaña’e sabadidake naho nitono mofo po-dalivay vaho nikama iereo. ");
INSERT INTO tdx_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Aa ie mbe tsy nàndre, inao o lahilahi’ i rovaio, ondati’ i Sedomeo, ty ajalahy naho ty bey, ze kila lahilahy pak’am-pifaritsoha’e ro niarikoboñe amy anjombay, ");
INSERT INTO tdx_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","nikaike ty hoe amy Lote, Aia i lahilahy niheo mb’ama’o hariva zao rey? Akaro ama’ay haharendreha’ay. ");
INSERT INTO tdx_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Niakatse an-tsarirañe t’i Lote le narindri’e amboho’ey i lalañe ");
INSERT INTO tdx_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","vaho nanao ty hoe, O ry rahalahikoo, ko anoe’ areo o halò-tsereke zao. ");
INSERT INTO tdx_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ingo hey, aman’ anak’ ampela roe mbe tsy mahavany lahy iraho; ehe angao hakareko mb’ama’areo atoy vaho ano am’iereo ze atao soa am-pihaino’ areo; fe ko anoa’ areo ndra inoñ’ inoñe amy lahilahy rey kanao mipalitse ambane tafo-trañoko ao. ");
INSERT INTO tdx_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Fa hoe ka iereo, Misitaha! le tinovo’ iareo ty hoe, Niambahiny atoy itia te niavy, aa vaho mipay ho mpizaka! Aa le ihe ty ho silofe’ay hisolo iareo. Le zineha’ iereo mafe t’i Lote vaho didy tsy nampipoñake i lalambeiy. ");
INSERT INTO tdx_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Aa le nahiti’ i lahilahy rey o fità’eo le tinari’iareo hizilike mb’am’iereo añ’anjomba ao t’i Lote, naho narindri’ iereo i lalañey, ");
INSERT INTO tdx_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","vaho zinevo’ iareo an-kagoàñe o lahilahy an-dala’ i anjombaio, ty kede naho ty bey, vaho nimokots’ avao iereo nipay i lalañey. ");
INSERT INTO tdx_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Le hoe i lahilahy rey amy Lote, Ia ka ty ama’o atoañe? He vinanto’o ke ana-dahi’o, ke anak’ ampela’o, ndra iaia ama’o an-drova atoa—akaro boak’ an-toetse atoy ");
INSERT INTO tdx_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","fa harotsa’ay ty rova toy, amy te nionjoñ’ añatrefa’ Iehovà ty fikointsa’ ondati’eo, vaho nirahe’ Iehovà zahay handro­tsak’ aze. ");
INSERT INTO tdx_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Aa le niavotse t’i Lote nanao ty hoe amo vinanto nañenga o anak’ ampela’eoo, Miongaha le iakaro ty toetse toy, fa ho ro­tsa­he’ Iehovà ty rova toy. Fe natao’ o vinanto’eo t’ie nisole. ");
INSERT INTO tdx_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Ie nanjirike ty maraindray, nanaeñe i Lote i anjely rey ami’ty hoe: Mitroara, taono t’i vali’o naho o anak’ ampela’o roe toañe, tsy mone ho mongoreñe ami’ty halo-tsere’ ty rova toy. ");
INSERT INTO tdx_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","F’ie nihenekenek’ avao, le rinambe’ o lahilahio ty fita’e naho ty fita’ i vali’ey vaho ty taña’ i anak’ ampela’e roe rey, ie niferenaiña’ Iehovà, le nendese’ iereo vaho napok’ alafe’ i rovay. ");
INSERT INTO tdx_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ie fa nasese alafe ao le hoe re, Mirombaha fiay, le ko mitoli-boho vaho ko tambatse am-bavatane atoa; mihere­reaha mb’am-bohi­tse mb’eo tsy mone ho faopaoheñe. ");
INSERT INTO tdx_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Le hoe t’i Lote am’ iereo: Ehe! tsie, ry talèko; ");
INSERT INTO tdx_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ingo te nisohe’o ty mpitoro’o, naho nonjone’o ty fitretreza’o ahy amy te rinomba’o ty haveloko; f’ie tsy hahafilay mb’ am-bohitse mb’eo, tsy mone hizo hankàñe vaho hikenkañe. ");
INSERT INTO tdx_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Hehe ty marine naho mete rifiteñe o rova ey hoek’ eo, fa kede ‘nio. Angao hihitrifako, tsy raha kede hao, soa te ho veloñe ty fiaiko? ");
INSERT INTO tdx_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Aa le hoe re tama’e, Ingo, fa nandraeko ty lahara’o amo raha zao, fa tsy ho rotsaheñe i rovay ty amy saontsi’oy. ");
INSERT INTO tdx_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Masikà, itribaho an-day, fa tsy hahapi-draha Iraho ampara’ t’ie mandoak’ ey. Aa le natao ty hoe Tsoare i rovay. ");
INSERT INTO tdx_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Fa nanjirik’ an-tane atoy i àndroy te niavy e Tsoare ao t’i Lote. ");
INSERT INTO tdx_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Heneke izay, le nañiliña’ ­Iehovà solifara naho afo boak’ am’ Iehovà andike­rañe ao ty Sedome naho i Amorà, ");
INSERT INTO tdx_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","vaho narotsa’e i rova rey, naho i vava-tane iabiy naho ze mpimoneñe amy rova rey vaho ze nitiry amy taney. ");
INSERT INTO tdx_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Fe nitoli-boho ty vali’e, vaho ninjare vongan-tsira. ");
INSERT INTO tdx_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Nañaleñale mb’amy toetse nijo­haña’e añatrefa’ Iehovày mb’eo t’i Avrahame ");
INSERT INTO tdx_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","vaho nitalake mañambane eñe mb’amy Sedome naho i Amorà naho i vavatane iabiy le nahaoniñe ty hatoe’ i taney nionjoñe manahake ty fifororoaha’ ty hatoem-pitranahañe. ");
INSERT INTO tdx_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Aa ie narotsan’ Añahare o rova amy vavataneio, le nitiahin’ Añahare t’i Avrahame vaho nirahe’e hiakatse boak’ añivo’ i fandro­tsahañey t’i Lote, ie finongo’e o rova nimoneña’ i Loteo. ");
INSERT INTO tdx_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ie amy zao, niavotse boak’e Tsoare t’i Lote vaho nitobe ambo­hitse ey, ie naho i anak’ ampela’e roe ama’e rey, amy te nanembañe aze ty himoneñe e Tsoare; aa le nimo­neñe am-po lakato ao, ie naho i anak’ ampela’e roe rey. ");
INSERT INTO tdx_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Le hoe ty tañoloñoloña’e aman-jai’e, Fa bey ‘nio ty raentika, vaho tsy eo t’indaty an-tane atoy ty himoak’ aman-tika an-tsata’ ty tane bey toy. ");
INSERT INTO tdx_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Aa le antao hampikamaen-tika divay ty raentika vaho hiolots’ ama’e, hañajàn-tika tariratse ty raentika. ");
INSERT INTO tdx_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Nampi­kamae’ iereo divay ty rae’e amy haleñey; le nimoak’ aman-drae’e ao ty taño­lo­ñoloña’e nifandia-tihy ama’e, f’ie tsy nahafohiñe ty nandrea’e ndra ty nitroara’e. ");
INSERT INTO tdx_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ie niloak’andro, le hoe i tañoloñoloña’ey aman-jai’e, Niolotse aman-draeko iraho; antao hampikamaentika divay indrai­ke te hariva; le ihe ka ro hizilik’ ao hifandia’o tihy, hañajañe tariratse ho aman-draen-tika. ");
INSERT INTO tdx_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Aa le nampikamae’ iereo divay indra­ike ty rae’ iareo amy haleñey; le niongake ty zai’e naho niolora’e; fe na­moea’e ty fandrea’e naho ty fitroara’e. ");
INSERT INTO tdx_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Aa le sindre nampiareñe’ i Lote rae’e i anak’ampela’e roe rey. ");
INSERT INTO tdx_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Nisamake ana-dahy i tañoloñoloña’ey le natao Mòabe ty añara’e; Ie ty rae’ o nte-Mòabeo pak’ henaneo. ");
INSERT INTO tdx_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Nahatoly ana-dahy ka ty zai’e vaho natao’e Benamý ty añara’e; ie ty rae’ o anak’Amoneo pak’androany. ");
INSERT INTO tdx_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Nañavelo boak’ao t’i Avrahame mb’an-tane atao Nègeve, le nitobe añivo’ i Kadèse naho i Sore vaho nañi­alo e Gerare ao, ");
INSERT INTO tdx_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","vaho hoe ty nanoe’ Avrahame i Sarà vali’e, Rahavaveko re. Aa le nampañitrike t’i Abimeleke mpanjaka’ i Gerare vaho rinambe’e t’i Sarà. ");
INSERT INTO tdx_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Le niheo amy Abimelek’ ama’ nofy te haleñe t’i Andrianañahare nanao ty hoe ama’e. Inao! ondaty vetrake irehe, ty amy rakemba nalae’oy, amy t’ie vali’ ondaty. ");
INSERT INTO tdx_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ie amy zao tsy nañarine aze t’i Abimeleke; le hoe re, Ry Talè, ho vetrahe’o ka hao ty fifeheañe vantañe? ");
INSERT INTO tdx_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Tsy ie hao ty nanao amako ty hoe, Rahavaveko re, vaho ie ka ty hoe Rahalahiko. Nanoeko an-katsòn-troke naho an-kahitin-tañako. ");
INSERT INTO tdx_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Aa le hoe t’i Andria­nañahare ama’e ama’ nofy, Eka, apotako te nanoe’o an-kavantañan’ arofo; mbore kinalako irehe tsy handilara’o, le tsy nimeteko t’ie hitsapa aze. ");
INSERT INTO tdx_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ie amy zao, ampolio am’ indatiy ty vali’e; mpitoky re, le hihalalia’e t’ie ho veloñe. Fe naho tsy hampoli’o, le mahafohina te toe havetrake, ihe naho o ao iabio. ");
INSERT INTO tdx_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Aa le nañaleñale t’i Abimeleke nikanjy ze hene mpitoro’e naho nitalilie’e an-dravembia’ iereo; vaho fonga nangebahebake o lahilahio. ");
INSERT INTO tdx_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kinanji’ i Abimeleke t’i Avrahame le nanoa’e ty hoe, Inon-koahe ty nanoa’o ama’ay? Ino ty hakeoko ama’o te nendesa’o amako naho amo fehekoo ty tahiñe jabajaba toy? Toe tsy fanao o raha nanoa’ o ahikoo. ");
INSERT INTO tdx_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Hoe ka t’i Abimelek’ amy Avrahame, Ino ty nisafiri’o t’ie nanao o raha zao? ");
INSERT INTO tdx_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Hoe t’i Avrahame, Foto’e, nataoko tsy ho ami’ty toetse toy ty fañeveñañe aman’ Añahare vaho ho nañe-doza amako iereo ty amy valikoy. ");
INSERT INTO tdx_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Mbore toe rahavaveko re, anak’ am­pelan-draeko fa tsy anan-dreneko, vaho nivalieko. ");
INSERT INTO tdx_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Aa ie nampandifik’ ahy añ’ anjomban-draeko t’i Andrianañahare, le hoe ty nanoako, Inao ty hasoa hanoa’o ahy amy ze toetse ivotrahan-tika, te hatao’o ty amako : Raha­lahiko re. ");
INSERT INTO tdx_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Nangalak’ añondry naho añombe, naho ondevo-lahy naho ampela t’i Abimeleke vaho natolo’e amy Avrahame le nampoli’e ama’e t’i Sarà vali’e. ");
INSERT INTO tdx_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Hoe t’i Abimeleke, Heheke, añatrefa’o o tanekoo; mimo­neña amy ze satri’o. ");
INSERT INTO tdx_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Hoe re amy Sarà, Ingo, te nimeako volafoty arivo ty rahalahi’o ho tako-maso amo hene mindre ama’oo; nahazo to re añatrefa ondaty iabio. ");
INSERT INTO tdx_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Nihalaly aman’ Añahare t’i Avrahame le nampi­jangañen’ Añahare t’i Abime­leke naho ty vali’e vaho ondevo am­pela’eo, t’ie hahasamake, ");
INSERT INTO tdx_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","amy te fonga nakite’ Iehovà heike ze hoviñe añ’anjomba’ i Abimeleke ty amy Sarà vali’ i Avrahame. ");
INSERT INTO tdx_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Aa le nitilike i Sarà t’Iehovà amy nitsara’ey, le nanoe’ Iehovà amy Sarà i nitsarae’ey. ");
INSERT INTO tdx_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Niareñe t’i Sarà vaho nahatoly ana-dahy ho a i Avrahame amy haantera’ey amy andro namantañañ’ aze amy tsinaran’ Añaharey. ");
INSERT INTO tdx_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Nimea’ i Avrahame añarañe ty hoe Ietsàke i ana-dahy nitoly ama’ey, i nasama’ i Sarà ho azey. ");
INSERT INTO tdx_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Nisavare’ i Avrahame t’Ietsàk’ ana’e ami’ty andro’e fahavalo amy nandi­lian’ Añahare azey. ");
INSERT INTO tdx_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Zato taoñe t’i Avrahame te nahatoly Ietsake ana’e. ");
INSERT INTO tdx_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Hoe t’i Sarà, Nampihehen’ Añahare iraho, vaho mitrao-piankahak’ amako ze hene mahajanjiñe ty amako. ");
INSERT INTO tdx_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Tinovo’e ty hoe, Ia ty ho nanao ty hoe amy Avrahame te hampinono ajaja t’i Sarà? Ie nahatoly anake amy haantera’ey. ");
INSERT INTO tdx_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Nitombo i ajajay vaho niotàñe, le nanao takataka t’i Avrahame amy andro nañota’e azey, ");
INSERT INTO tdx_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","fe niisa’ i Sarà te ninje’ Iesmaèle ana’ i Khagare nte-Mitsraime nisamahe’e ho a i Avrahamey, ");
INSERT INTO tdx_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","le hoe re amy Avrahame, Soiho añe i ondevo-ampelay naho i ana’ey, fa le lia’e tsy hitrao-dova am’ Ietsàk’ anako ty ana’ i ondevo-ampelay. ");
INSERT INTO tdx_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Haloviloviañe am-pahaoniña’ i Avrahame i hoe zay ty amy ana-dahi’ey. ");
INSERT INTO tdx_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Fa hoe t’i Andrianañahare ama’e, Ko apo’o hampioremeñ’ azo i jolingay naho i ampela mpitoro’oy. Janjiño ze saontsie’ i Sarà, ze feo’e iaby ama’o, amy te Ietsàke ty hikanjiañe o tarira’oo. ");
INSERT INTO tdx_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Hanoeko fifeheañe ka ty ana’ i mpitoro’o ampelay amy te tiri’o. ");
INSERT INTO tdx_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ie nañampitso amy loak’ àndroy, le nandrambe mofo t’i Avrahame naho rano an-kolitsena naho natolo’e amy Khagare, nasampe’e an-tsoro’e; le natolo’e aze ka i jolingay vaho nirahe’e mb’eo. Nienga re vaho nirere­rere am-patrambei’ i Beersevà añe. ");
INSERT INTO tdx_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ie nikapaike i rano an-kolitsenay le nakafi’e ambane rongoñe ao i kimosoy. ");
INSERT INTO tdx_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Le nisitsitse, niambesatse tandrife aze amy ze ho taka-pilereñe ey fa hoe re: Lonike te tsy hahatrea ty fivetrahan’ anakoo. Aa le nitobòke marine eo re vaho nañonjo-peo nangololoike. ");
INSERT INTO tdx_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Jinanjin’ Añahare ty feo’ i jolingay, le kinanji’ ty anjelin’ Añahare boak’ andikerañe ao t’i Khagare vaho nanoa’e ty hoe, O Khagare, ino o mañore azoo? Ko hemban-drehe, fa jinanjin’ Añahare ty feo’ i jolinga eiy. ");
INSERT INTO tdx_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Miongaha, atroaro i jolingay le rambeso am-pità’o, amy te hanoeko foko ra’elahy. ");
INSERT INTO tdx_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Aa le sinokan’ Añahare o fihaino’eo vaho nioni’e ty vovoñe aman-drano. Aa le nimb’ eo re, nampipea rano amy holitsènay vaho nampinoñe i jolingay. ");
INSERT INTO tdx_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Taman’ Añahare i jolingay, le nihabey naho nimoneñe andratraratra añe vaho ninjare mpitàm-pale. ");
INSERT INTO tdx_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Ie nitobok’ am-patrambei’ i Parane ao, le nangala’ i rene’e valy boak’e Mitsraime añe. ");
INSERT INTO tdx_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ie henane zay nanao ty hoe amy Avrahame t’i Abimeleke naho i Pikole mpifehe o lahindefo’eo, Ama’o t’i Andrianañahare amy ze fanoe’o iaby. ");
INSERT INTO tdx_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Aa le mifantà amako etoañe aman’ Añahare te tsy ho fañahie’o Iraho naho i anakoy naho ty anan’ anako; fa i fitretrezako ama’oy naho i tane nañialoa’oy ty anoa’o amako. ");
INSERT INTO tdx_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Le hoe t’i Avrahame: Ifantàko! ");
INSERT INTO tdx_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Le nendaha’ i Avrahame t’i Abimeleke ty amy vovon-drano tinava’ o mpitoro’eoy, ");
INSERT INTO tdx_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","le hoe t’i Abimeleke, amoeako ze nanao izay, tsy sinaontsi’o amako ‘nio, fa androany te tsinanoko. ");
INSERT INTO tdx_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Aa le nandrambe añondry naho añombe t’i Avrahame vaho natolo’e amy Abimeleke le nifañina ie roe. ");
INSERT INTO tdx_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Navì’ i Avrahame amo añondri’eo ty vi’e vave fito. ");
INSERT INTO tdx_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Le hoe t’i Abimelek’ amy Avrahame, Ino o vi’e vave fito navi’oo? ");
INSERT INTO tdx_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Hoe re, Rambeso an-tañako o vik’ añondry vave fito retiañe ho valolombeloñe amako te izaho ro nihaly ty vovoñe toy. ");
INSERT INTO tdx_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Aa le natao ty hoe Beersevà i toetse zay; amy te nifañina eo iereo roe. ");
INSERT INTO tdx_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Aa ie fa nifañina e Beersevà ao, le nimpoly mb’an-tane’ o nte-Pilistio mb’eo t’i Abimeleke naho i Pikole mpifehen-dahin-defo’e. ");
INSERT INTO tdx_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Nambole kile raike e Beersevà ao t’i Avrahame vaho eo ro nikanjia’e ty tahina’ Iehovà Andria­nañahare nainay donia. ");
INSERT INTO tdx_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Le nañialo an-tane nte-Pilisty añe andro maro t’i Avrahame. ");
INSERT INTO tdx_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Añe irezay, le nitsohen’ Andria­nañahare t’i Avrahame, le nanoa’e ty hoe, O Avrahame! Itoan-draho, hoe re. ");
INSERT INTO tdx_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Le hoe re: Endeso henaneo i ana’o Ietsàke bako toka’o kokoa’oy, le mañaveloa mb’ an-tane Morià añe vaho iengao ho soron-koroañe ami’ty vohitse hivolañako. ");
INSERT INTO tdx_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Nañaleñaleñe amy loak’àndroy t’i Avrahame le nanampeza’e fitobohañe amy borìke’ey. Nindese’e mindre ama’e ty roe amo mpitoro’eo naho Ietsàk’ ana’e, le tsinera’e ty hatae’ i soroñey, le niongake vaho nionjoñe mb’amy toetse nitsaraen’ Añahare mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ie amy andro faha-teloy, niandra t’i Avrahame nahatalake i vohitsey eñe. ");
INSERT INTO tdx_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Hoe re amo mpitoro’eo, Etoañe hey nahareo naho i borìkey; homb’ eroan-draho naho i ajalahiy, hitalaho vaho hibalike. ");
INSERT INTO tdx_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Rinambe’ i Avrahame ty hatae hañoroañe i soroñey naho nasampe’e amy Ietsàk’ ana’e, vaho ninday afo naho mesolava am-pita’e, le niharo lia mb’eo iereo roe, ");
INSERT INTO tdx_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","le hoe ty asa’ Ietsàke aman-drae’e: O aba? hoe t’i Avrahame, Eñ’ anako intoy iraho? Etia ty afo naho ty hatae fa aia ka ty vik’añondry hisoro­ñañe? ");
INSERT INTO tdx_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Hoe t’i Avrahame, I Andrianañahare, anako, ro hanolotse ty vi’e hisoroñañe. Aa le niharo-lia iereo roe, ");
INSERT INTO tdx_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","naho nandoak’ amy toetse natoron’ Añaharey, naho nitsene kitrely eo t’i Avrahame naho nalaha’e ama’e ty hatae, naho narohi’e i ana’e Ietsàkey vaho nasampe’e amy kitreliy, amo hataeo. ");
INSERT INTO tdx_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Nahiti’ i Avrahame amy zao ty fità’e nandrambe i fibaray handenta i ana’ey. ");
INSERT INTO tdx_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","F’ie kinanji’ ty anjeli’ Iehovà boak’ andikerañe ao ami’ty hoe, O Avrahame, Avrahame! Le hoe re, Intoy iraho. ");
INSERT INTO tdx_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Hoe re, Ko apao’o amo ajalahio ty fità’o hanoa’o inoñ’ inoñe, amy te apotako henaneo t’ie mpirevendreveñ’ aman’ Añahare amy te tsy nazi’o amako ty anadahy bako-toka’oy. ");
INSERT INTO tdx_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Nam­piandrae’ i Avrahame amy zao o fihaino’eo nañisake, le hehe amboho’e ao ty añondrilahy nivaho­ran-drongoñe an-tsifa’e. Nimb’eo t’i Avrahame nandrambe i añondrilahiy le nengae’e ho soroñe hisolo i anadahi’ey. ");
INSERT INTO tdx_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Aa le natao i Avrahame ty hoe, Iehovà Mahavazoho, vaho ie i tsaraeñe henaneo ami’ty hoe, Ambohi’ ­Iehovà ao ty hahaoniñañe aze. ");
INSERT INTO tdx_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nikanjy boak’amo likerañeo fañin-droe’e amy Avrahame ty anjeli’ Iehovà, ");
INSERT INTO tdx_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","nanao ty hoe, Nifanta ami’ty vatako iraho, hoe t’Iehovà: Kanao nanoe’o o raha zao naho tsy nitana’o amako i ana-dahi’oy, i bako-lahi-toka’oy, ");
INSERT INTO tdx_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","le am-pitahiañe ty hitahiako azo vaho am-pitomboeñe ty hampitomboeko o tarira’oo ho mira amo vasian-dikerañeo naho mira amo faseñe añ’olon-driakeo, naho ho fanaña’ o tarira’oo o lalambein-drafelahi’eo, ");
INSERT INTO tdx_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","vaho i tarira’oy ty hañanintsiñe ze kila foko’ ty tane toy, amy te norihe’o ty feoko. ");
INSERT INTO tdx_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Aa le nimpoly mb’amo ajalahio t’i Avrahame le niongake iereo nitrao-dia mb’e Beersevà mb’eo; vaho nimo­neñe e Beerseva añe t’i Avrahame. ");
INSERT INTO tdx_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Ie nimodo, le natalily amy Avrahame ty hoe, Nahatoly anak’ añamy Nakore rahalahi’o ka t’i Milkae: ");
INSERT INTO tdx_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","i Otse ty tañoloñoloña’e naho rahalahi’e t’i Boze vaho i Kemoele rae’ i Arame, ");
INSERT INTO tdx_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","naho i Kesede, i Kazò, i Pildase, Iedlafe, vaho i Betoele. ");
INSERT INTO tdx_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Nisamake i Ribkae t’i Betoele. I valo rey ty nasama’ i Milkae amy Nakore, rahalahi’ i Avrahame. ");
INSERT INTO tdx_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Mbore nahatoly ka i sakeza’e atao Reomàey le i Tèbake, i Gàkame, i Tàkase, vaho i Maakà. ");
INSERT INTO tdx_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Zato tsi-roapolo fito’amby taoñe ty haantera’ i Sarà, ty taon-kavelo’ i Sarà, ");
INSERT INTO tdx_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ie nivilasy e Kiriàte-arbà (toe i Kebròne) an-tane’ Kanàne ao; le nimbeo t’i Avrahame handala i Sarà vaho hirovetse aze. ");
INSERT INTO tdx_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Niongak’ amy vilasi’ey t’i Avrahame vaho nisaontsy amo nte-Kheteo, ami’ty hoe, ");
INSERT INTO tdx_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","Renetane naho mpañialo ama’ areo iraho; anoloro hanañañe ama’ areo handentehako i vilasikoy tsy ho aolom-pihaino. ");
INSERT INTO tdx_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Le hoe ty natoi’ o nte-Kheteo amy Avrahame, ");
INSERT INTO tdx_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Ijanjiño roandriako; Mpifeleke ama’ay irehe. Alenteho an-kibory lengo’e ama’ay i vilasi’oy, tsy ia ama’ay ty hitañe azo amy lona’ey tsy handeveña’o i vilasi’oy. ");
INSERT INTO tdx_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Niongake t’i Avrahame vaho nibokok’ am’ ondati’ i taneio, amo ana’ i Kheteo, ");
INSERT INTO tdx_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","le nisaon­tsia’e ty hoe, Naho no’areo ty handentehako tsy ho aolom-pihainoko i vilasikoy, le janjiño, vaho halalio t’i Efrone ana’ i Tsokare ");
INSERT INTO tdx_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ty hanolora’e ahiko i lakato’ i Makpelà ama’ey; i añ’ ila’ i tete’eiy. Ami’ty vola-foty do’e ty hanolora’e ahy ho fanañako añivo’ areo ao ho fandentehako. ");
INSERT INTO tdx_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Niam­besatse añivo’ o nte-Kheteo t’i Efrone; vaho hoe ty natoi’ i Efrone nte-Khete amy Avrahame am-pijanjiña’ ze hene nte-Khete mpiheo mb’an-dalam-bei’ i rovaio: ");
INSERT INTO tdx_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Aiy! ry Androanavio: Janjiño iraho, fa omeiko azo i tonday, naho atoloko azo i lakato ama’ey. Añatrefa’ o ana’ ondatiko etoañe ty anolorako azo; aleveño i vilasi’o. ");
INSERT INTO tdx_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Aa le nibokok’ añatrefa’ ondati’ i taneio t’i Avrahame, ");
INSERT INTO tdx_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","vaho nanao ty hoe amy Efrone am-pijanjiña’ ondati’ i taneio, Aa naho mete le janjiño o ahikoo! Hitolo­rako drala amy tetekey; andrambeso amako le haleveko ao i vilasikoy. ");
INSERT INTO tdx_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Nanoiñe i Avrahame t’i Efrone ami’ty hoe, ");
INSERT INTO tdx_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","O talèko, Inao ; mañeva 400 sekelem-bolafoty i taney, fa inon-jay añivon-tika? Aleveño i vilasi’oy. ");
INSERT INTO tdx_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Niantofa’ i Avrahame t’i Efrone le linanja’e amy Efrone i volafoty tsinara’e am-pijanjiña’ o nte-Kheteoy, i sekele volafoty 400 an-danjam-pandetake rey. ");
INSERT INTO tdx_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Aa le tsitsike voalily ty tonda’ i Efrone e Makpelà ao atiñana’ i Mamrè añe, i tetekey reketse ty lakato’e ao, naho ze hatae amy tetekey naho ze mifahetse amy taney, ");
INSERT INTO tdx_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","amy Avrahame ho fanaña’e añatrefa’ o ana’ i Kheteo, aolo’ ze mpimoak’ an-dalambei’ i rovay. ");
INSERT INTO tdx_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Añe izay le naleve’ i Avrahame amy lakato an-tete’ i Makpelày miatreke i Mamrè (toe i Khebrone) an-tane Kanàne ao t’i Sarà. ");
INSERT INTO tdx_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Songa pinate’ o ana’ i Kheteo ho a i Avrahame i tonday rekets’ i lakato ama’e ao ho fandetehañe. ");
INSERT INTO tdx_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ie amy zao, nigain-kantetse t’i Avrahame, lifots’ andro; vaho nitahie’ Iehovà amy ze he’e t’i Avrahame. ");
INSERT INTO tdx_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Hoe t’i Avrahame amy zokem-pitoro’e añ’ anjomba’ey, ie mpamandroñe ze hene vara’e, Ano ambane feko atoa ty fità’o, ");
INSERT INTO tdx_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","fa hampifantako añam’ Iehovà, Andrianañaharen-di­ke­rañe naho Andrianamboatse ty tane toiy irehe te tsy hangala-baly ho a i anakoy amo anak’ampela nte-Kanàne itraofako fimoneñeo ");
INSERT INTO tdx_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","fe mañaveloa mb’an-taneko naho mb’aman-dongoko mb’eo hangala-baly ho a’ Ietsàk’ anako. ");
INSERT INTO tdx_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Aa hoe i mpitoro’ey ama’e, Hera tsy mete hañorik’ ahy mb’an-tane atoy i ampelay; ie amy zao hendeseko mimpoly mb’amy tane nihirifa’o añey hao i ana’oy? ");
INSERT INTO tdx_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Hoe t’i Avrahame tama’e, Mitaoa tsy hampoli’o añe i anadahikoy. ");
INSERT INTO tdx_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Iehovà Andrianañaharen-dikerañe ninday ahy niakatse ty anjomban-draeko naho i tanen-dongokoy vaho nifanta ty hoe amako, Hatoloko amo tarira’oo o tane toio, ie ty hañitrike i anjeli’ey aolo’o hangalà’o valy añe ho amy ana-dahikoy. ");
INSERT INTO tdx_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Aa naho tsy mete hañorik’ azo i ampelay, le ho afak’ amo nampifantàkoo; fe tsy hampipolie’o añe i ana-dahikoy. ");
INSERT INTO tdx_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Aa le nanoe’ i mpitoroñey ambanen-tso’ i Avrahame talè’ey ty fità’e vaho nitsokòse ama’e i hoe zay. ");
INSERT INTO tdx_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nalae’ i mpitoro’ey amy zao ty rameva folo amo ramevan-talè’eo le niavotse, naho hene am-pita’e ao ze varan-talè’e, ie niongake nionjoñe mb’e Ara­me-naharaime, mb’an-drova’ i Nakore añe. ");
INSERT INTO tdx_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Nam­pitongalefe’e alafe’ i rovay marine ty vovoñe ey o ramevao, naho fa hiroñe i àndroy, ami’ty fiavota’ o ampela hitarikeo. ");
INSERT INTO tdx_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Le hoe re, Ry Iehovà, Andrianañahare’ i Avrahame talèkoy, miambane ama’o, anoloro fahatafe­terañe te anito vaho ferenaiño t’i Avrahame talèko. ");
INSERT INTO tdx_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Vazohò t’ie mijohañe marine rano migoangoañ’ atoy vaho fa mitoha rano mb’etoa o anak’ ampela’ ondati’ i rovaio, ");
INSERT INTO tdx_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","le ehe te ty ampela hataoko ty hoe, Ehe azotso amo kiboloha’oo hinomako, vaho hanoe’e ty hoe, Mikamà le hampinomeko ka o rameva’oo, le toe ie ty nedre’o ho a i mpitoro’o Ietsàkey, haharendrehako te niferenaiñe’o i talèkoy. ");
INSERT INTO tdx_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Mbe tsy nigadoñe i saontsi’ey, te ingo nitoha mb’eo t’i Ribkae, nasama’ i Betoele ana’ i Milkae, vali’ i Nakore rahalahi’ i Avrahame, ninday ty amboara’e an-tsoro’e. ");
INSERT INTO tdx_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Somon­drara trenotreno’e am-pahoniñan-dre, ampela miehañe mbe tsy nahavany lahy, nizotso mb’an-drano mb’eo, le nipeae’e i amboara’ey vaho niañambone mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Nihitrihitry hifanalaka ama’e i mpitoroñey, nanao ty hoe, Ehe anjotsò, hitsopeke rano amo kiboloha’oo. ");
INSERT INTO tdx_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Mikamà, roandria hoe re, le nazè’e aniany an-taña’e i kiboloha’ey le nanjotsoa’e. ");
INSERT INTO tdx_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ie niheneke ty nampikama’e aze, le hoe re, Ho tarihako ka o rameva’oo ampara’ te etsa-drano. ");
INSERT INTO tdx_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Aa le nalonga’e amy zao an-dabaoga ao i amboara’ey naho nilay mb’am-bovom-b’eo indraike hitarike le songa nitariha’e o rameva’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Nilatsa’ indatiy, nianjiñe avao haharendreke ke nampihenefa’ Iehovà i lia’ey he tsie. ");
INSERT INTO tdx_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ie hene enen-drano o ramevao, le rinambe’ indatiy ty bangen-oroñe vola­mena nilanja vakin-tsekele naho ­ty ravake roe ho an-tsira’e nilanja volamena folo ");
INSERT INTO tdx_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","vaho nanao ty hoe, Toñono amako, ana’ia irehe. Ehe mete tsahatse anay hialeñe hao ty añ’akiban-drae’o? ");
INSERT INTO tdx_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Hoe re tama’e, Ana’ i Betoele, ana’ i Milkae iraho, nasama’e amy Nakore. ");
INSERT INTO tdx_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nitovoña’e ty hoe, Amañ’ ahetse naho hanen-kare mahaheneke zahay vaho traño ialeñañe. ");
INSERT INTO tdx_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Nabotre’ indatiy ty añambone’e nitalaho am’ ­Iehovà, ");
INSERT INTO tdx_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ami’ty hoe, Andriañeñe abey t’Iehovà Andrianañahare’ i Avrahame talèko, te tsy nitana’e amy talèkoy ty fiferenaiña’e naho ty figahiña’e, naho niaolo ahiko mb’añ’anjomban-dongo’ i talèkoy t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Nilay mb’añ’anjomban-drene’e mb’eo amy zao i somondraray nita­lily irezay. ");
INSERT INTO tdx_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Aman’ drahalahy atao Labàne t’i Ribkae, le nihitrike ty lay mb’ am’ indaty am-bovoñey t’i Labàne, ");
INSERT INTO tdx_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","ie nioni’e i bangen-oroñey, naho o ravak’ an-tsiran-drahavave’eo, naho nitalilia’e ty hoe: Inao ty nisaontsia’ indatiy, le nimb’ am’ indatiy mb’eo vaho naheo’e t’ie nijohañe marine o rameva’eo amy vovoñey. ");
INSERT INTO tdx_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Hoe re, Miheova, ry tahie’ Iehovà. Ino ty ijohaña’o alafe atoy? fa nihajarieko traño naho toetse o ramevao. ");
INSERT INTO tdx_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Aa le nimoak’ añ’ anjomba ao indatiy naho nafaha’ i Labàne amo ramevao i kilankañey, naho tinolo’e ahetse naho haneñe o rameva’eo, naho rano hanasañe ty fandia’e naho o fandia’ ondaty nindre ama’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Nanjotsoañe hika­ma, fa hoe ka re, Tsy hihinañe naho tsy taroñeko hey i namantohañ’ ahiy. Hoe ty natoi’e, Itaroño. ");
INSERT INTO tdx_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Aa le hoe re, Mpitoro’ i Avrahame iraho. ");
INSERT INTO tdx_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Fa ra’elahy ty fitahia’ Iehovà i talèkoy, vaho mpañaleale re henaneo; ie nitolora’e añondry naho añombe naho volafoty naho vola­mena, ondevo lahy naho ampela, rameva naho borìke, ");
INSERT INTO tdx_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","mbore nisamak’ ana-dahy añamy talèkoy t’i Sarà vali’e ie fa bey, vaho natolo’e aze ze he’e ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Nampifantan-talèko ahy ty hoe, Ko angala’o valy amo anak’ ampela nte-Kanàne, tompo’ ty tane imoneñako atoio i anakoy; ");
INSERT INTO tdx_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","fa ty anjomban-draeko ty homba’o; amo rolongokoo ty hangala’o valy ho a i anakoy. ");
INSERT INTO tdx_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Le hoe Iraho amy talèkoy, Kera tsy hañorik’ ahy i ampela zay. ");
INSERT INTO tdx_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Fa hoe re amako, Iehovà iatrefako lia ro hañitrike ty anjeli’e ama’o hampitafetetse ty lia’o, hangala’o valy aman-dongoko añe, añ’ anjomban-draeko ao, i anakoy. ");
INSERT INTO tdx_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Le ho afak’ amy nifantàkoy irehe lehe mivotrak’ aman-drolongoko ao fe tsy hitolora’ iareo, vaho toe ho haha amy nifantàkoy. ");
INSERT INTO tdx_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Niheo mb’amy vovoñey Iraho anindro­a­ny, nanao ty hoe, Ry Iehovà, Andria­na­ñahare’ i Avrahame talèkoy, ee te ho tafetere’o henanekeo ty liako! ");
INSERT INTO tdx_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Hehe te mijohañe am-bovon-drano atoy iraho; le ze somondra­ra miakatse hitari-drano volañeko ty hoe, Anjotsò rano hitsopehako amo dabakera’oo; ");
INSERT INTO tdx_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","le ie hanao amako ty hoe, Mikamà vaho hitarihako ka o rameva’oo, ehe t’ie i somon­drara nitendre’ Iehovà ho amy ana’ i talèkoiy. ");
INSERT INTO tdx_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Aa mbe tsy nimodo i entako an-trokoy, hehe te pok’eo t’i Ribkae, i favinta’ey an-tsoro’e eo naho nizotso mb’ an-drano mb’eo hitarike, le hoe ty nanoako, Ehe, ampinomo; ");
INSERT INTO tdx_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","nalisa re nampizotso i kiboloha’ey le nanao ty hoe, Mikamà, vaho hampinomeko ka o rameva’oo. Aa le ninoñe Iraho vaho nanesea’e iaby o ramevao. ");
INSERT INTO tdx_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Le hoe ty ontaneko ama’e, Ana’ ia v’iheo? Hoe re, Ana’ i Betoele, ana’ i Nakore nisamaha’ i Milkae. Aa le nanoeko añ’oro’e eo i bangey naho amo sira’eo o ravakeo. ");
INSERT INTO tdx_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Le nabotreko ty lohako nitalaho am’ Iehovà vaho nandriañeko t’Iehovà Andria­nañahare’ i Avrahame talèkoy, i nanehak’ ahy andalam-bantañe hangalako ty ana-dongo’ i talèkoy ho a i ana’eiy. ");
INSERT INTO tdx_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ie amy zao, naho mete hifandahatse an-kavañonañe naho an-kahiti’e amy talèkoy le isaontsio, fa naho tsy izay, isaontsio, hivihako mb’an-tañan-kavana ndra mb’an-kavia. ");
INSERT INTO tdx_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Le hoe ty natoi’ i Labàne naho i Betoele, Toe boak’ am’ Iehovà o raha zao; tsy mete ivolaña’ay ndra ty soa ndra ty raty. ");
INSERT INTO tdx_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ingo, añatrefa’o t’i Ribkae, rambeso; mañaveloa vaho ampañengao i anan-talè’oy ty amy tsara’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ie nahajanjiñe i enta’ iareoy i mpitoro’ i Avrahamey, le niankohoke an-tane am’ Iehovà; ");
INSERT INTO tdx_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","vaho naaka’ i mpito­roñey amy zao ty bije volafoty naho ty voatsiriry volamena naho saroñe, le nato­lo’e amy Ribkae; nomei’e raha sarobily ka i rahalahi’ey naho i rene’e. ");
INSERT INTO tdx_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nikama naho ninoñe amy zao re naho ondaty nitraok’ ama’eo, vaho nialeñe ao. Ie nitroatse maraindray le hoe re, Ampionjono mb’ amy talèkoy mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Hoe ka ty rahalahi’e naho i rene’e, Angao hitobok’ ama’ay atoy hey re, va’e folo andro vaho hienga. ");
INSERT INTO tdx_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Fa hoe re tam’iereo, Ko ampiroñonen-draho; kanao nampihenefe’ Iehovà ty liako, iraho mb’eo himpoly mb’an-talèko mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Hoe iereo, Ho tokave’ay i ampelay, hañontane am-bava’e. ");
INSERT INTO tdx_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Aa le kinanji’iareo t’i Ribkae, vaho nanoa’e ty hoe, No’o hao ty hindre lia am’ ondatio? Handeha iraho, hoe re. ");
INSERT INTO tdx_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Aa le nampionjone’ iereo mb’eo t’i Ribkae, rahavave’ iareo naho i mpiatra’ey, naho i mpitoro’ i Avrahamey naho ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Le tinata’ iareo t’i Ribkae naho nanoa’ iareo ty hoe, Ee te ihe, rahavave’ay ro hitombo añ’arivo naho añ’ale; naho ho fanaña’ o tarira’oo o lalam-beim-palaiñ’ azoo. ");
INSERT INTO tdx_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Niongak’ amy zao t’i Ribkae naho o mpiatra’eo, nijoñe an-drameva nañorike indatiy; aa le nendese’ i mpitoroñey t’i Ribkae vaho nañavelo mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ie henane zay niakatse amy lala’ i Vovon-Daka’iroiy t’Ietsàke, ie fa nimo­neñe an-tane’ Nègeve ao. ");
INSERT INTO tdx_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Niavotse amy harivay t’Ietsàke hitalaho an-kivok’ ao, aa ie niandra, le naheo’e te rameva ty nimb’ama’e mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Niandra ka t’i Ribkae nahaoniñe Ietsàke le nizotso amy ramevay, ");
INSERT INTO tdx_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","nañontane amy mpitoroñey ty hoe, Iam-bao ondaty midrai­draitse an-kivoke ey hifanalaka aman-tikañeo? Hoe i mpitoroñey, Ty talèko ‘nio. Rinambe’e amy zao i sarimbo’e mangarakarakey le nisaroñe. ");
INSERT INTO tdx_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hene natalili’ i mpitoroñey am’ Ietsàke o nanoe’eo. ");
INSERT INTO tdx_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Le nendese’ Ietsàke nizilik’ an-kibohon-drene’e ao naho nengae’e ho vali’e t’i Ribkae; naho nikokoa’e vaho nitendreke hanintsiñe amy havilasin-drene’ey t’Ietsàke. ");
INSERT INTO tdx_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nangala-baly indraike t’i Avrahame, i Ketoràe ty tahina’e. ");
INSERT INTO tdx_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Le nisamaha’e t’i Zimràne naho Ioksane naho i Me­dane naho i Mi­diane naho Isbake vaho i Sòahke. ");
INSERT INTO tdx_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Nisamake i Sebà naho i Dedane t’i Joksane. I Asorý ty ana-dahi’ i Dedane, le i Letosý vaho i Leomý. ");
INSERT INTO tdx_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","O ana-dahi’ i Midianeo le i Efà naho i Èfere naho i Kanòke naho i Abidà vaho i Eldaa, songa ana’ i Ketorà. ");
INSERT INTO tdx_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Natolo’ i Avrahame am’ Ietsàke iaby ze vara’e. ");
INSERT INTO tdx_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Le tinolo’e ravo­ravo o anan’ tsakeza’eo, ie mbe nive­lo­ñe, le nampifokofokoe’e maniñanañe mb’an-tane atiñanañe añe hisitake am’Ietsàke. ");
INSERT INTO tdx_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Aa le zao o andron-taon-kavelo’ i Avrahame, o niveloma’eo: zato-tsi-fitompolo lim’ amby taoñe. ");
INSERT INTO tdx_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Nipetroke fara’e t’i Avrahame vaho nivilasy an-kasoan-kantera’e, bey naho lifo­tse andro, vaho natontoñe am’ ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Naleve’ Ietsàke naho Iesmaèle ana’e amy lakato’ i Makpelày re, amy tonda’ i Efrone, ana’ i Tsò­khare nte-Kheteiy, aolo’ i Mamrè ao, ");
INSERT INTO tdx_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","i teteke vinili’ i Avrahame amo nte-Kheteoy. Naleveñe ao t’i Avrahame naho i Sarà vali’ey. ");
INSERT INTO tdx_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ie añe ty fihomaha’ i Avrahame, le nitahien’ Añahare t’Ietsàk’ ana’e; vaho nimoneñe marine ty vovo’ i Laka’iroý eo t’Ietsake. ");
INSERT INTO tdx_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Intoy o tarira’Iesmaèle, ana’ i Avrahame nasama’ i Khagare nte-Mitsraime, fetrek’ oro’ i Sarà amy Avrahameo. ");
INSERT INTO tdx_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Zao ty tahina’ o ana’ Iesmaèleo, amo tahina’eo, ie toñoneñe amo tarira’eo : le i Nebaote tañoloñolo’ Iesmaèle naho i Kedare, i Adbeèle, i Mibsame, ");
INSERT INTO tdx_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","i Mismà, i Domà, i Masà, ");
INSERT INTO tdx_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","i Khadade, i Temà, Ietore, i Nafìse, vaho i Kedemà. ");
INSERT INTO tdx_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Izay o ana’ Iesmaèleo naho o tahina’ iareoo amo rova’eo, naho amo kialo’eo, roandriañe folo-ro’ amby o fifokoa’eo. ");
INSERT INTO tdx_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Zato tsy telopolo fito amby taoñe ty halava-havelo’ Iesmaèle, te nikofòke ty fara-pipetro’e naho nivilasy vaho natontoñe am’ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Nitoetse boak’e Havilà pak’e Sòre tandrife’ i Mitsraime añe iereo amy fombañe mb’e Asòre mb’eoy. Nidoñe tandrife’ o rahalahi’e iabio re. ");
INSERT INTO tdx_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Izay ty fanoñona’ Ietsàk’ ana’ i Avrahame. Nisamake Ietsàke t’i Avrahame; le ");
INSERT INTO tdx_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","efa-polo taoñe t’Ietsàke te nañenga i Ribkae ana’ i Betoele nte-Arame boake Padan’ arame, raha­vave’ i Labàne nte-Arame. ");
INSERT INTO tdx_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Nihalaly am’ Iehovà t’Ietsàke ty amy vali’e, ie betsiterake. Tinoi’ Iehovà i halali’ey vaho niareñe t’i Ribkae. ");
INSERT INTO tdx_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Nifaniotsiotse an-kovi’e ao o ajajao, le hoe re: Aa naho zao ty ie, ino ty hanoeko? Aa le nimb’eo re nañontane Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Le hoe t’Iehovà ama’e: Foko roe ty an-kovi’o ao, hiambake ondaty ho samahe’oo; Haozatse te ami’ty raike ty raike, Vaho hitoroñ’an-jai’e ty zoke’e. ");
INSERT INTO tdx_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ie tondroke ty andro nisamaha’e, le ajaja hambañe ty an-kovi’e ao. ");
INSERT INTO tdx_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ni­mena iaby ty zoke te niakatse, hoe nisarom-bolovoloeñe ty sandri’e; le natao’ iereo Esave ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Nanonjohy aze i rahalahi’ey; nivontititse an-tomi’ i Esave ty taña’e le natao Iakòbe ty añara’e. Enempolo taoñe t’Ietsàke te nahatoly iareo t’i Ribkàe. ");
INSERT INTO tdx_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nitombo i lahilahy rey, le nimpitsindroke am-bantam-pitañe t’i Esave, mpian-kivoke; fe ondaty saoneñe t’Iakòbe, mpimo­neñe an-kibohotse. ");
INSERT INTO tdx_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Nikokoa’ Ietsàke t’i Esave, amy t’ie nikama o tsindro’eo; fe nikokoa’ i Ribkae t’Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Teo te nahandro antake t’Ia­kòbe, le nilimpoañe t’i Esave te boak’ an-kivok’ añe. ");
INSERT INTO tdx_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Aa hoe t’i Esave am’ Iakòbe, Anjotso o raha menao, fa midaliendalieñe. (Aa le natao Edome ty tahi­na’e.) ");
INSERT INTO tdx_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Hoe t’Iakòbe, Aletaho amako henane ty hataño­loñoloña’o, ");
INSERT INTO tdx_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Hoe t’i Esave, toe hikenkan-draho, inoñe amako ze o hatañoloñoloñañe zao? ");
INSERT INTO tdx_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Hoe t’Iakòbe, Mifantà amako heike. Aa le nifanta ama’e vaho naleta’e am’ Iakòbe i hataño­lo­ñoloña’ey. ");
INSERT INTO tdx_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Le nazotso’ Iakòbe amy Esave ty mofo naho i ahandro antakey; ie nikama naho ninoñe le niongake vaho niribotse mb’eo. Toe nañonjitse i hatañoloñoloña’ey t’i Esave. ");
INSERT INTO tdx_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ie amy zao nikerè ty tane, nandimbe i hasalikoañe nifetsake tañandro’ i Avrahamey. Le noly mb’e Gerare mb’ amy Abimèleke nte-Pilisty mb’eo t’Ietsàke. ");
INSERT INTO tdx_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Ie amy zao, nisodehañe am’ Ietsàke t’Iehovà nanao ty hoe, Ko mitaveam-b’e Mitsraime añe; fa mitobea an-tane hatoroko azo. ");
INSERT INTO tdx_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Mimo­neña an-tane atoy, le himbaeko vaho ho tahieko; amy te hatoloko azo naho amo tarira’o iabio o tane retoañe; le ho henefeko ty fanta nifantàko amy Avrahame rae’o. ");
INSERT INTO tdx_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Hampiraeko amo vasian-dikerañeo o tarira’oo naho hatoloko amo tarira’oo o hene tane toañeo vaho amo tarira’oo ty hitahiañe ze hene foko an-tane atoy ");
INSERT INTO tdx_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","amy te nihaoñe’ i Avrahame ty feoko le nitambozore’e i namantohakoy, o fepèkoo, o fañekoo vaho o Fanoroakoo. ");
INSERT INTO tdx_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Aa le nitoetse e Gerare ao t’Ietsàke. ");
INSERT INTO tdx_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ie nañontane i vali’ey ondati’ i rovaio, le hoe re, Rahavaveko toke, amy t’ie nihembañe tsy te hanao ty hoe, Valiko, fa natao’e te hañe-doza ama’e ondatio, ty amy hamontramontra’ i Ribkae. ");
INSERT INTO tdx_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ie tambatse ela ao t’Ietsàke le nitilihitse ami’ty lalan-kede t’i Abimeleke mpanjaka’ o nte-Pelistio: niisa’e te heheke nitsapa­tsapa i Ribkae vali’e t’Ietsàke. ");
INSERT INTO tdx_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Aa le nampikanjie’ i Abimeleke t’Ietsàke vaho nanoa’e ty hoe, Toe vali’o re! Ino ty nanoe’o ty hoe Rahavaveko? Hoe t’Ietsàke tama’e, Nataoko hera hikenkañe ty ama’e iraho. ");
INSERT INTO tdx_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Hoe ty Abimeleke, Inoñe arè ty nanoe’o ama’ay? Kera niolots’ amy vali’oy t’indaty le ho nañakeo anay irehe. ");
INSERT INTO tdx_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Aa le hinatahata’ i Abimeleke ondati’e iabio ami’ty hoe, Toe havetrake ze mitsapa t’indaty toy ndra i vali’ey. ");
INSERT INTO tdx_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nitongy amy taney t’Ietsàke le nanatake in-jato amy taoñey avao, amy te nitahie’ Iehovà, ");
INSERT INTO tdx_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","vaho niha-mpañarivo indatiy le mbe nionjoñe avao ty firaoraoa’e ampara’ te nimpañaleale. ");
INSERT INTO tdx_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ie amam-pirai-lia naho mpirai-troke vaho tsiefa o pitoro’eo, le nikirañe aze o nte-Pilistio. ");
INSERT INTO tdx_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Aa le finempe’ o nte-Pilistio naho linembeke tane o vovoñe hinali’ o mpitoron-drae’eo tañandro’ i Avrahameo. ");
INSERT INTO tdx_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Le hoe t’i Abimelek’ am’Ietsàke, Misi­taha, fa loho maozatse te ama’ay irehe. ");
INSERT INTO tdx_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Aa le nienga boak’ao t’Ietsàke naho nitobe am-bavatane’ i Gerare vaho nitoetse eo; ");
INSERT INTO tdx_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","le sino­ka’ Ietsàke indraike o vovon-drano niha­li­eñe tañandro’ i Avrahame rae’eo, o linembe’ o nte-Pilisty iabio naho fa nihomake t’i Avrahame; vaho nitokave’e amo añarañe nitokavan-drae’e. ");
INSERT INTO tdx_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Le nihaly amy vavataney o mpitoro’ Ietsàkeo le nanjo vovoñe nigoangoan-drano. ");
INSERT INTO tdx_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Fe nifandietse amo mpiara’ Ietsàkeo o mpiarake nte-Gerareo ami’ty hoe, Anay o ranoo, le natao’e ty hoe Eseke i vovoñey kanao nifandiera’ iereo. ");
INSERT INTO tdx_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Nihaly vovoñe ­indraike iereo vaho nifanjomorañe ka, aa le nitokave’e Sitnà. ");
INSERT INTO tdx_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ie niveve mb’eo le nihaly vovoñe indraike, f’ie tsy am-pifanoiñe, le natao’e ty hoe Rehobota ami’ty hoe, Fa nañivake ho anay t’Iehovà le hiraorao an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Boak’ ao re nionjoñe mb’e Beersevà mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Le nisodehañe ama’e amy haleñey t’Iehovà nanao ty hoe, Izaho ro Andrianañahare’ i Avrahame rae’o; ko hemban-drehe fa ama’o Iraho le ho tahieko vaho hampitozantozañeko o tarira’oo ty amy Avrahame mpitorokoy. ");
INSERT INTO tdx_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aa le nandrafetse kitrely eo naho nikanjy ty tahina’ Iehovà naho naore’e eo ty kiboho’e vaho nihaly vovoñe eo o mpitoro’ Ietsàkeo. ");
INSERT INTO tdx_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nomb’ ama’e mb’eo amy zao t’i Abi­mèleke boake Gerare, miharo amy Ako­zàte mpanolo-keve’e naho i Pikole, mpifehe o lahindefo’eo. ");
INSERT INTO tdx_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Hoe t’Ietsak’ am’iereo, Inom-bao ty nomba’areo mb’ amako mb’etoa kanao malaiñe ahy, toe natao’ areo soike? ");
INSERT INTO tdx_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Hoe iereo, Trea’ay malange te ama’o t’Iehovà, le hoe zahay, Antao hifanitike, añivo’ay naho ihe, aa le iantofo te hifañina, ");
INSERT INTO tdx_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","soa te ihe tsy hijoy anay, hambañe amy te zahay tsy nitsapa azo, fa tsy ino ty nanoe’ay naho tsy ty soa, naho nampañaveloe’ay am-panintsiñañe; toe tahie’ Iehovà irehe henaneo. ");
INSERT INTO tdx_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Aa le nañalankaña’e sabadidake, le nikama naho ninoñe. ");
INSERT INTO tdx_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Nitroatse marain-tsikiake iereo le nifañina am-panta, naho na­sese’ Ietsàke mb’eo vaho nienga aze an-kanintsiñe. ");
INSERT INTO tdx_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Nitotsak’ ama’e amy àndroy ka ty mpitoro’ Iets­ake nita­lily i vovoñe hinali’ iereo anianiy, ty hoe, Nahatrea rano zahay! ");
INSERT INTO tdx_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Natao’e Sivà ty añara’e; aa le Beer-Sevà ty añara’ i rovay henaneo. ");
INSERT INTO tdx_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ie niefapolo taoñe t’i Esave, le nañenga Iehoditè ana’ i Bierý nte-Khete, naho i Basmàte ana’ i Elòne nte-Khete; ");
INSERT INTO tdx_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","f’ie nampioremeñe ty arofo’ Ietsàke naho i Ribkae. ");
INSERT INTO tdx_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ie roñoñe añe, naho fa bey t’Ietsàke naho nitalo fihaino vaho tsy nahavazoho soa, le kinanji’e t’i Esave zoken’ ana’e ami’ty ty hoe, O anako, le tinoi’e ty hoe, Intoy iraho. ");
INSERT INTO tdx_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Hoe re, Hehe te bey Iraho henaneo; naho amoeako ty andro hikenkañako, ");
INSERT INTO tdx_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","aa ehe rambeso o harao’oo: ty kotra’o naho fale’o le akia mb’an-kivok’ añe hitsindroke hena ho ahiko. ");
INSERT INTO tdx_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Le anokono mahakama mafiry, amy teakoy, le anjotso ho haneko, hitatàko azo an-troko aolo’ ty hivetrahako. ");
INSERT INTO tdx_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Jinanji’ i Ribkae ty nataon-drae’e amy ana’e Esave. Aa naho niavotse mb’ am-patrañe añe t’i Esave hitsindroke hanesea’e. ");
INSERT INTO tdx_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","le hoe t’i Ribkae am’ Iakòbe ana’e, Inao, tsinanoko amy saontsin-drae’o aman-drahalahi’o Esavey, ty hoe, ");
INSERT INTO tdx_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Añendeso tsindroke, le anokono haneñe mafiry hihinanako hitatàko azo añatrefa’ Iehovà aolo’ ty hikenkañako. ");
INSERT INTO tdx_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Inao arè, anako, haoño o volam-pamantohako azoo. ");
INSERT INTO tdx_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Akia mb’amy lia raikey le andeso vik’ ose roe hañalankañako mahakama mafiry ho an-drae’o, amy tea’ey; ");
INSERT INTO tdx_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","le ihe ty hanjotso aze aman-drae’o hikama’e, hitata’e aolo’ ty hiho­maha’e. ");
INSERT INTO tdx_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Fa hoe ka t’Iakòbe amy Ribkae rene’e, Oniño te ondaty volovoloeñe t’i Esave rahalahiko; izaho lahilahy pando; ");
INSERT INTO tdx_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","hera hitsapa ahy t’i raeko le hatao’e te nirabioñeko, le mone fatse ty hanoa’e fa tsy tata. ");
INSERT INTO tdx_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hoe t’i rene’e ama’e, Ee te ho amako ze o fatse’o zao, anako; fe oriho avao i volakoy, akia, angalao ho ahy. ");
INSERT INTO tdx_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Aa le nimb’eo re nangalake naho nendese’e aman-drene’e; vaho nihalankañen-drene’e ty mahakama mafiry manahake ty teàn-drae’e. ");
INSERT INTO tdx_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Na­lae’ i Ribkae amy zao ty sarimbo fanjaka’ i Esave zoke’ey ze tama’e añ’ an­jomba’e ao vaho nampiombea’e amy Iakòbe, ana-tsitso’e ");
INSERT INTO tdx_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","le napeta’e an-tsira’e ty holi’ i vik’ osey naho ami’ty malama am-pititia’e eo. ");
INSERT INTO tdx_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tinolo’e am-pità’ Iakòbe ana’e i mahakama mafiriy naho ty mofo hinalanka’e. ");
INSERT INTO tdx_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Le nizilik’ aman-drae’e ao re nanao ty hoe, O aba, le tinoi’e ty hoe, Intoy iraho; Ia irehe, anako? ");
INSERT INTO tdx_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Hoe t’Iakòbe aman-drae’e, Izaho i Esave Ta­ñolo­ñoloña’o. Fa nanoeko iaby i nañiraha’o ahi­y, mitroara arè, miambesara vaho ikamao o tsindrokoo, hitatà’ ty arofo’o. ");
INSERT INTO tdx_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Aa hoe t’Ietsàk’ amy ana’ey, Akore anako, t’ie nahatrea anianik’ avao? Hoe ty natoi’e: Nampitotohe’ ­Iehovà Andrianañahare’o amako. ");
INSERT INTO tdx_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Le hoe t’Ietsàk’ am’Iakòbe, Harineo, hitsapako azo, anako, haha­ren­drehako te toe i Esave anako ke tsie. ");
INSERT INTO tdx_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Aa le nitotok’ aman-drae’e Ietsàke t’Iakòbe, le nitsa­pae’e vaho hoe ty asa’e, Feo’ Iakòbe o feo zao, fe taña’ i Esave o taña’eo. ");
INSERT INTO tdx_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Le tsy nifohi’e amy te nivolovolo­eñe manahake o fitàn-joke’e Esaveo o taña’eo, aa le tinata’e. ");
INSERT INTO tdx_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Hoe re, Toe anako Esave v’i-heo? Le tinoi’e ty hoe: Izaho. ");
INSERT INTO tdx_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Aa hoe re, Anjotso hihinanako i tsindron’ anakoy vaho hitat’ azo ty troko. Aa le nazotso’e naho nikamae’e naho nanjo­tsoa’e divay vaho ninoma’e. ");
INSERT INTO tdx_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Le hoe ty rae’e Ietsàk’ ama’e, Mañarinea ahy anako vaho orofo. ");
INSERT INTO tdx_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Aa le niharinea’e naho norofa’e, le nantsoñe’e ty hañi’ o lamba’eo vaho nitata’e ami’ty hoe, Inao ty hañin’ anako manahake ty harifondrifon-kivoke nitahie’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ee te hanoloran’ Añahare azo ty zonon-dikerañe, naho ty havondra’ ty tane toy vaho ampemba naho-divay vao maha-eneñe. ");
INSERT INTO tdx_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Lonike te hitoroñe azo ondatio, vaho hibokoboko ama’o o rofokoo. Feleho o rahalahi’oo, le hiondrek’ ama’o o anan-drene’oo. Fonga afàtse ze mamatse azo, Hene tahieñe ze mitat’ azo! ");
INSERT INTO tdx_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ie nifonire’Ietsàke i fitata’e Iakòbey, vaho didy tsy tafakatse boak’ añatrefan-drae’e t’Iakòbe, te pok’eo t’i Esave amy tsindro’ey. ");
INSERT INTO tdx_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ie ka ro naña­lankañe mahakama mafiry vaho nazo­tso’e aman-drae’e ami’ty hoe, Mitroara ry Raeko, ikamao ty tsindron’ ana’o, hitata’ ty arofo’o. ");
INSERT INTO tdx_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ia v’iheo, hoe t’Ietsàke rae’e ama’e. Tinoi’e ty hoe, Ana’o iraho, i Esave tañoloñoloña’oy. ");
INSERT INTO tdx_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nihobitse an-gebahebake t’Ietsàke, nanao ty hoe: Ia arè i nitsindroke hena naho nanjotso amakoy, ie fonga nihaneko aolo’ ty niavia’o etoañe vaho fa nitataeko?—eka ho soa tata re! ");
INSERT INTO tdx_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ie nahajanjiñe i saontsin-drae’ey t’i Esave, le nampipoñake fañgoihoy añ’ afero naho nanao ty hoe aman-drae’e, Tatao iraho, izaho ka, ry Raeko! ");
INSERT INTO tdx_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Fa hoe re, Niavy etoa am-pamañahiañe ty zai’o, vaho tinava’e i tata’oy. ");
INSERT INTO tdx_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Hoe re, Tsy to hao i añara’e, Iakobey, kanao indroe ty nañaramamoa’e an-tomitse. Sininto’e amako ty hatañoloñoloñako, le hehe te tinava’e aniany ka i tatakoy. Le hoe re, Tsy nañaja’o tata hao iraho? ");
INSERT INTO tdx_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Hoe ty natoi’ Ietsàk’ amy Esave, Ingo te nanoeko talè’o re vaho hene natoloko ama’e o rahalahi’eo ho mpitoro’e, le ampemba naho divay vao ty namaha­nako aze. Inoñe ka ty hanoeko ama’o, anako? ");
INSERT INTO tdx_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Hoe t’i Esave aman-drae’e, Tsy aman-tata raik’ avao hao irehe, ry Aba? Tatao iraho, izaho ka, ry raeko! Naonjo’ i Esave amy zao ty fiarañanaña’e le nangololoike ty rovetse. ");
INSERT INTO tdx_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Le hoe ty nitoiña’ Ietsàke rae’e: Ingo, hihànkañe ami’ty havondra’ ty tane toy ty akiba’o, naho amo zonon-dikerañe añ’ abo eñe. ");
INSERT INTO tdx_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ty fibara’o ro hiveloma’o, le ho toroñe’o ty zai’o, fe añe irehe ho tsitoboboly, vaho hapoza’o ty joka an-kàto’o eo. ");
INSERT INTO tdx_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Nalaim-bintañ’amy Iakòbe amy zao t’i Esave ty amy tata nitatàn-drae’e azey, le hoe ty natao’ i Esave an-tro’e ao, Mito­toke ty andro fandalàñe an-draeko; le ho vonoeko t’Iakòbe zaiko. ");
INSERT INTO tdx_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","F’ie natalily amy Ribkae i volan-joken’ ana’ey; le nirahe’e ty hitoka Iakòbe tsitson’ ana’e, le hoe re tama’e, Inao mameren-troke t’i Esave zoke’o ty ama’o ami’ty fikililia’e hañè-doza ama’o. ");
INSERT INTO tdx_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Ie amy zao ry anako, oriho o volakoo, le miongaha, mibioña mb’ amy Labàne rahalahiko e Kharane añe, ");
INSERT INTO tdx_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","le molia ama’e ao heike, ampara’ te mitolike ty fitrotrofiahan-joke’o, ");
INSERT INTO tdx_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ampara’ te hiesoñe ama’o ty haviñeran-joke’o vaho handikofa’e i nanoe’o ama’ey; le mbe hampihitri­feko irehe, hampolieko boak’ añe. Ataoko akore te ho nirerek’ amako ami’ty andro raike nahareo roroe? ");
INSERT INTO tdx_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Le hoe t’i Ribkae am’ Ietsàke, Mañalike ty haveloko o anak’ampela Kheteo. Aa naho mañenga amo anak’ ampela Kheteo t’Iakòbe, manahake o anak’ampela an-tane atoio le ho inoñ’amako ty fiaiko? ");
INSERT INTO tdx_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tinoka’ Ietsàk’ amy zao t’Iakòbe naho tinata’e vaho nafanto’e ami’ty hoe, Ko mañenga valy amo anak’ ampela nte-Kanàneo. ");
INSERT INTO tdx_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Mionjona mb’e Padan’ arame, mb’añ’ anjomba’ i Betoele, raen-drene’o añe, vaho mañengà amo anak’ampela’ i Labàne, rahalahin-drene’oo. ");
INSERT INTO tdx_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ehe te hitahy azo t’i El-Sadai, hampibodobodo naho hañamaro azo, soa te ho firimboñam-pifokoañe. ");
INSERT INTO tdx_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Le hatolo’e azo naho amo tarira’o mindre ama’oo o fitahiañe i Avrahameo, handovà’o i tane maha-renetane azoy, i natolon’ Añahare amy Avrahamey. ");
INSERT INTO tdx_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aa le nirahe’ Ietsàke mb’ eo t’Iakòbe, hañavelo mb’e Padan’ arame, mb’ amy Labàne ana’ i Betoele nte-Arame, rahalahi’ i ­Ribkae rene’ i Esave naho Iakòbe añe. ");
INSERT INTO tdx_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Ie nirendre’ i Esave te nitatae’ Ietsake t’Iakòbe naho nirahe’e mb’e Padan’ ara­me mb’eo hañenga valy boak’añe, ie nitata aze ro namantoke ty hoe, Ko mañenga amo anak’ am­pela’ i Kanàneo, ");
INSERT INTO tdx_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","le nihao­ñe’ Iakòbe i nafanton-drae’e naho i rene’ey vaho nitaveañe mb’e Padan’ Arame añe, ");
INSERT INTO tdx_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","le napota’ i Esave te tsy nòn-drae’e Ietsake o anak’ ampela’ i Kanàneo; ");
INSERT INTO tdx_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","aa le nimb’ am’ Iesmaèle mb’eo re nañenga i Makalate, rahavave’ i Nebaiote, ana’ Iesmaèle ana’ i Avrahame, ho tovo’ o vali’eo. ");
INSERT INTO tdx_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Nienga i Beersevà t’Iakòbe naho nionjo mb’e Kharane añe. ");
INSERT INTO tdx_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ie nahaisake toetse, le nialeñe ao fa nimotake i àndroy. Nangalak’ amo vato eio re naho napo’e ho ankala’ ty añambone’e vaho nandre niròtse amy toetsey. ");
INSERT INTO tdx_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Nañinofy re, le ingo ty fanongà nitroatse an-tane eo, ty ambone’e naha-takatse an-digiligin-dike­rañe eñe vaho inge, niañambone naho nizotsoa’ o anjelin’Añahareo. ");
INSERT INTO tdx_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Naheo’e te nijohañe ambone’e ey t’Iehovà, nanao ty hoe: Izaho Iehovà Andrianañaharen-drae’o Avrahame naho Andrianañahare’ Iets’ake. Hatoloko azo naho amo tarira’oo o tane andrea’o henaneo. ");
INSERT INTO tdx_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ho mira ami’ty debo’ ty tane toy o tarira’oo, ie hangetseketseke mañandrefa naho maniñana naho mañavaratse vaho mañatimo, le ihe naho o tarira’oo ro hitahiañe ze hene hasavereña’ ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Inao, mpindre ama’o iraho, hañambeñe azo ndra aia’aia ty hañaveloa’o, vaho hampoliko an-tane atoy, le tsy hieng’ azo naho tsy henefeko o vinolako ama’oo. ");
INSERT INTO tdx_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ie nivañoñe amy firota’ey t’Iakobe le hoe re, Toe an-toetse atoy t’Iehovà fe tsy napotako. ");
INSERT INTO tdx_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Nihemban-dre le nanao ty hoe, Akore ty harevendreveñañe etoañe! Ts’inoñe naho tsy anjomban’ Añahare ty etoa vaho itoy i lalambein-dikerañey. ");
INSERT INTO tdx_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Nitroatse marain-tsikiake t’Iakòbe le rinambe’e i vato napo’e ho ankala’ ty añambone’ey naho natroa’e ho ajiba, vaho nañiliña’e solike ambone’e eo. ");
INSERT INTO tdx_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Natao’e ty hoe Betele ty añara’ i toetsey, fa nitokaveñe ty hoe Loze i tanàñey taolo. ");
INSERT INTO tdx_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nifanta amy zao t’Iakòbe ami’ty hoe, Naho hañimbañ’ ahiko t’i Andrianañahare, hañaro ahy ami’ty liako toy naho hamahañe ahy hànen-ko haneñe naho lamba hisikinañe, ");
INSERT INTO tdx_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","hibalihako an-kanintsi­ñe mb’añ’ anjomban-draeko añe, le ho Andrianañahareko t’Iehovà, ");
INSERT INTO tdx_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","naho ho anjomban’ Añahare ty vato natroako ho ajiba toy, vaho toe homeako Azo ty faha-folo’ ze hene hatolo’o ahiko. ");
INSERT INTO tdx_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Niongake am-pandia amy zao t’Ia­kòbe nimb’ an-tane’ o anan-tatiñanañeo. ");
INSERT INTO tdx_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Tinalake’e te heheke ty vovoñe an-kivoke ey aman’ añondry telo troke mandre marine aze, amy te fampinomañe o mpirai-liao i vovoñey; le vato jabajaba ty nikapeke i vovoñey. ");
INSERT INTO tdx_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ie hene vory o mpirai-liao le adariso’ o mpiarakeo i vato fikape’ i vovoñeiy, vaho ampinomeñe o añondrio; heneke izay vaho ampolie’ iareo am-bava’ i vovoñey i vatoy. ");
INSERT INTO tdx_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Hoe t’Iakòbe am’iereo, O rahalahikoo, boak’ aia nahareo? Hoe iereo, Hirik’e Kharane añe. ");
INSERT INTO tdx_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Hoe re tam’ iereo, Fohi’ areo hao t’i Labàne ana’ i Nakore? Hoe iereo, Eka apota’ay. ");
INSERT INTO tdx_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Hoe re tam’iereo, Jangam-bao? Janga, hoe iereo, le ingo t’i Rahkele, anak’ ampela’e minday o añondrio. ");
INSERT INTO tdx_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Hoe re, Hehe, mbe tsingilingilieñe ty àndro, tsy fanontoñañe añondry hey henaneo. Ampinomo o añondrio vaho akia andrazo. ");
INSERT INTO tdx_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Fa hoe ka iereo, Tsy mete zahay naho tsy fa vory iaby o mpirai-liao naho avarimbari’ iareo boak’ am-bava’ o vovoñeo o vatoo; izay vaho ampinome’ay o añondrio. ");
INSERT INTO tdx_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ie mbe nifanaontsy, pok’ eo t’i Rahkele ninday o añondrin-drae’eo, amy t’ie mpiarake. ");
INSERT INTO tdx_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ie nahaoniñe i Rahkele, ana’ i Labàne renelahi’e, naho o añondri’ i Labàne rene­lahi’eo t’Iakòbe le niharinea’e naho navari’e boak’ am-bava’ i vovoñey i vatoy vaho nampinome’e i lia-rai’ i Labàne renelahi’eoy. ");
INSERT INTO tdx_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Le norofa’ Ia­kòbe t’i Rahkele vaho nipoña-peo an-drovetse, ");
INSERT INTO tdx_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","naho nitoñone’ Iakòbe amy Rahkele t’ie longon-drae’e naho ana’ i Ribkae; le nilay re hitalily aman-drae’e. ");
INSERT INTO tdx_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ie jinanji’ i Labàne ty talili’ Iakòbe ana-drahavave’e, le nihitrihitry hifañaoñe ama’e; finorokoko’e naho norofa’e vaho nendese’e mb’ añ’ an­jom­ba’e ao vaho hene natalili’e amy Labàne i nife­tsake rezay, ");
INSERT INTO tdx_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","le hoe t’i Labàne ama’e, Toe taolako naho nofoko irehe! Aa le niam­be­sara’e volañe raike. ");
INSERT INTO tdx_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Le hoe t’i Labàne am’ Iakòbe, Aa ndra t’ie longoko, hifanehake ho ahy tsy aman-tambe hao? Volaño arè, ino ty ho tambe’o. ");
INSERT INTO tdx_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Ie amy zao, roe ty anak’ ampela’ i Labàne; Leae ty añara’ ty zoke’e naho i Rahkele ty añaran-jai’e. ");
INSERT INTO tdx_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Naleme ty maso’ i Leae, le nimontramontra naho soa vintañe t’i Rahkele. ");
INSERT INTO tdx_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Nikokoa’ Iakòbe t’i Rahkele, le hoe re, Ho toroñeko fito taon-drehe ho a i Rahkele, anak’ ampela’o zai’e. ");
INSERT INTO tdx_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Hoe t’i Labàne, Hamake hato­loko azo ta te hatoloko amy ze ondaty ila’e; mimoneña amako. ");
INSERT INTO tdx_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Aa le nito­roñe fito taoñe t’Iakòbe haha­zoa’e i Rahkele, le nihoe andro tsy ampe-ampe am-pihaino’eo ty amy fikokoa’e azey. ");
INSERT INTO tdx_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Le hoe t’Iakòbe amy Labàne, Ato­loro ahy i valikoy hiharoako fa heneke o androkoo. ");
INSERT INTO tdx_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Aa le natonto’ i Labàne ze hene ondati’ i tanañey vaho nañalankañe takataka. ");
INSERT INTO tdx_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ie hariva i àndroy le nasese’ i Labàne am’Iakòbe t’i Leae vaho niolore’e. ");
INSERT INTO tdx_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Le natolo’ i Labàne amy Leae ty mpitoro-ampela’e Zilpae ho mpiatrak’ aze. ");
INSERT INTO tdx_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Aa ie nanjirike ty hamaray, hehe te i Leae! le hoe t’Iakòbe amy Labàne: Ino o nanoe’o amakoo? Tsy i Rahkele hao ty nitoroñako azo? Akore arè ty namitaha’o ahy? ");
INSERT INTO tdx_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Hoe t’i Labàne, Tsy sata an-tane atoy ty anolorañe ty zai’e aolo’ ty tañoloñoloñan-ampela’e. ");
INSERT INTO tdx_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Foniro i hafitoa’ey, le hatolo’ay azo ka i raikey, ho ami’ty fito taoñe tovo’e hitoroña’o ahy. ");
INSERT INTO tdx_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Aa le nanoe’ Iakòbe. Nihenefe’e i hereñandroy, vaho natolo’e aze ty anak’ampela’e Rahkele ho vali’e. ");
INSERT INTO tdx_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Natolo’ i Labàne amy Rahkele ana’e t’i Bilhae mpiatra’ey ho mpiatrak’ aze. ");
INSERT INTO tdx_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Niolotse amy Rahkele ka t’Iakòbe le ie ty nikokoa’e te amy Leae, vaho nitoroñe i Labàne fito taoñe indraike. ");
INSERT INTO tdx_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ie nivazoho’ Iehovà te tsy nikokoañe t’i Leae, le sinoka’e ty trañon’ ana’e, fe betsiterake t’i Rahkele. ");
INSERT INTO tdx_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Niareñe t’i Leae vaho nahatoly ana-dahy. Natao’e Reòbene ty añara’e fa hoe ty asa’e, amy te nivazoho’ Iehovà ty haferenaiñako. Aa le hikoko ahy ty valiko henanekeo. ");
INSERT INTO tdx_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Niareñe indraike re nisamak’ ana-dahy, vaho hoe re, Jinanji’ Iehovà t’ie firihia’e le nomei’e itoañe ka, le natao’e Simòne ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Mbe niareñe indraike re, nahatoly ana-dahy, le hoe ty asa’e, Sandrake henane zao te hipiteham-baliko, izaho nisamake telo ho aze. Aa le natao’e Levy ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Mbe niareñe indraike re, le nisamak’ ana-dahy vaho nanao ty hoe, Handrenge Iehovà Iraho henane zao. Le natao’e Iehodà ty ­añara’e vaho nitampets’ anake. ");
INSERT INTO tdx_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ie nioni’ i Rahkele t’ie tsy nahatoly ho a Iakòbe, le nikirañe an-joke’e, naho hoe re am’ Iakòbe. Ehe meo anake Iraho tsy mone hikenkañe! ");
INSERT INTO tdx_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Nisolebotse amy Rahkele ty haboseha’ Iakòbe le hoe ty asa’e, Izaho hao ty hisolo an’ Andrianañahare nitañe ama’o ty vokan-koviñe? ");
INSERT INTO tdx_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Le hoe re, Intoy t’i Bilhae mpitoroko, imoaho hisamaha’e amo ongokoo soa t’ie ty hampionjoñeñe ahy. ");
INSERT INTO tdx_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Aa le natolo’e aze t’i Bilhae mpitoro’e hialoza’e, naho niziliha’ Iakòbe ");
INSERT INTO tdx_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","vaho niaren-dre, nahatoly anadahy ho a Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Le hoe t’i Rahkele, Nañomey to ahiko t’i Andrianañahare; toe jinanji’e i fitoreokoy naho nitolora’e ana-dahy. Aa le natao’e Dane ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Niareñe indraike t’i Bilhae mpitoro’ i Rahkele, naho nahatoly ana-dahy faha roe ho a Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Le hoe t’i Rahkele, Am-pifangatorañe mafe ty nifangatòrako aman-jokeko le nahalefe, vaho natao’e Naftalý ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Ie rendre’ i Leae te nijihetse ty fisamaha’e, le rinambe’e t’i Zilpae mpitoroñ’ ampela’e vaho natolo’e am’ Iakòbe hialoza’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Nisamak’ ana-dahy ho a Iakòbe t’i Zilpae mpitoro’ i Leae. ");
INSERT INTO tdx_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Le hoe t’i Leae, Hasoa tata! Aa le natao’e Gade ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Mbe nisamak’ ana-dahy fañindroe’e ho a Iakòbe t’i Zilpae mpitoro’ i Leae. ");
INSERT INTO tdx_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Le hoe t’i Leae, Hete! ty haehako! Hatao’ o anak’ ampelao haha iraho. Aa le natao’e Asere ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ie an-tsam-pitatahañe vare-bolè, nomb’an-tetek’ ao t’i Reòbene le nahatendreke fañanintsiñe vaho nañandesa’e t’i Leae, rene’e. Le hoe t’i Rahkele amy Leae, Añomezo amo fañanintsin’ ana’oo. ");
INSERT INTO tdx_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Fe hoe re ama’e, Raha kede ama’o hao te nasinta’o amako i valikoy, te hitavaña’o ty fañanintsin’ anako ka? Le hoe t’i Rahkele, Aa le ho meako azo hiolora’o te anito ty amo fañanintsin’ ana’oo. ");
INSERT INTO tdx_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ie boak’ an-teteke ey t’Iakòbe amy harivay, le niakatse hanalaka aze t’i Leae nanao ty hoe, Ahiko irehe te anito fa fifofoañe ty nifofoako azo amo fañanintsin’ anakoo. Aa le niolora’e amy haleñey. ");
INSERT INTO tdx_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Nihaoñen’ Añahare t’i Leae vaho niaren-dre, le nahatoly ana-dahy faha-lime ho a Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Hoe t’i Leae, Nitambezan’ Añahare Iraho ty amy nanolorako i mpitoro-ampelakoiy amy valeko. Le natao’e Iisakare ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Niareñe indraike t’i Leae le nisamake ty ana-dahi’e fah’ eneñe ho a Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Le hoe t’i Leae, Nitoloran’ Añahare ravoravo fanjàka iraho. Tsy mahay tsy himoneñe amako ty valiko henane zao, amy te nahatoly ana-dahy eneñe ho aze. Le natao’e Zebolòne ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ie añe le nahatoly anak’ ampela re vaho natao’e Dinae ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nitiahien’Añahare amy zao t’i Rahkele le nahajanjiñe aze t’i Andrianañahare vaho sinoka’e ty hovi’e. ");
INSERT INTO tdx_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Niaren-dre le nahatoly ana-dahy vaho nanao ty hoe, Fa nafahan’ Añahare amako ty ìnje. ");
INSERT INTO tdx_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Natao’e Iosefe ty añara’e ami’ty hoe: Ehe t’ie ho tovoña’ Iehovà ana-dahy. ");
INSERT INTO tdx_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Ie nasama’ i Rahkele t’Iosefe, le hoe t’Iakòbe amy Labàne. Ampionjono mb’eo Iraho himpoliako mb’an-toeko naho mb’an-taneko añe. ");
INSERT INTO tdx_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Meo ahiko o valiko naho anako nitoroñako azoo, vaho ampionjono. Fohi’o i fifanehafako nitoroñako azoy. ");
INSERT INTO tdx_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Aa hoe t’i Labàne ama’e, Naho nahatendreke fañisohañe a’ maso’o iraho, le mitoboha hey. Fa am-pitsikarahañe ty naharen­drehako te nitahie’ Iehovà Iraho ty ama’o. ");
INSERT INTO tdx_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Tinovo’e ty hoe, Ano ty ho tambe’o le hatoloko. ");
INSERT INTO tdx_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Hoe t’Iakòbe ama’e, Fohi’o ty nifa­nehafako ho azo naho ty hasoa’ o hare’oo t’ie amako. ");
INSERT INTO tdx_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ty kedekede tama’o taolo’ i fiavikoy le fa nitombo ho maro, vaho nitahy azo t’Iehovà ndra aia aia ty nombako. Aa ie henaneo, ombia ty hanoeko ho a i trañokoy, izaho ka? ");
INSERT INTO tdx_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Aa hoe re: Ino ty homeako azo? Le hoe ty natoi’ Iakòbe, Ko añomeza’o ndra inoñ’ inoñe, fa naho o raha zao ty hanoe’o amako, le handrazeko vaho hambenako indraike o mpirai-lia’oo. ");
INSERT INTO tdx_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Angao ho tsitsifeko o mpirai-lia’oo te anito le fonga haviko ze añondry merembitike naho voanato, naho ze vik’ añondry mainteinte, vaho ze ose poapoake ndra varevare; irezay ty ho tambeko. ");
INSERT INTO tdx_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Hitalily ahy ty havantañako te añe, naho hiatreke o lahara’oo o tambekoo. Ze ose tsy varevare ndra poapoake oniñe amako, ndra ze vik’añondry tsy mainte le hatao kinametse. ");
INSERT INTO tdx_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Noko izay, hoe t’i Labàne. Ie i vinola’oy. ");
INSERT INTO tdx_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Fe amy àndroy avao le naveve’ i Labàne ze hene ose­lahy varevare ndra poapoake naho ze ose-vave varevare ndra poake (naho ze aman-kafotiañe) naho ze vik’ añondry mainte vaho natolo’e an-taña’ o ana’eo; ");
INSERT INTO tdx_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","le nasitake lia telo andro amy Iakòbe, naho nandraze’ Iakòbe ty ila’ o mpirai-lia’ i Labàneo. ");
INSERT INTO tdx_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Nangalake ran-talý naho sohihy naho hatae tsotra t’Iakobe vaho niholire’e o ran-kataeo hampiboake ty foty amo ran-kataeo. ");
INSERT INTO tdx_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Le napo’e aolo’ o mpirai-liao o ran-kataeo añ’ila’ o dabaoga finoma’ o mpirai-liaoo t’ie avy hinon-drano, ie toe mitongoa naho minon-drano. ");
INSERT INTO tdx_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Aa ie nisahe añ’ atrefa’ o ran-kataeo o mpirai-liao le nampipoke anake tanteharañe ndra varevare, ndra poapoake. ");
INSERT INTO tdx_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Navi’ Iakòbe o ana’eo, le nampisahe’e amo misoritsori­tseo naho amy ze mainte amo lia’rai’ i Labaneo, toe naveve’e o mpirai-lia’eo, tsy naharo’e amo mpirai-lia’ i Labaneo. ");
INSERT INTO tdx_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ie te hisahe o hare maoza­tseo, le nasampe’e ey o ran-kataeo ho trea’ o hàreo amo dabaogao, soa te hisahe aolo’ o ran-kataeo, ");
INSERT INTO tdx_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","fa naho naleme o hareo, tsy nampipoha’e ao izay. Aa le ninjare maleme ty fanaña’ i Labàne vaho naozatse o a Iakòbeo. ");
INSERT INTO tdx_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Aa le vata’e niraorao indatiy, nihatsifotofoto o mpirai’ lia’eo, ie amam-pitoro lahy naho ampela, rameva vaho borike. ");
INSERT INTO tdx_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jinanji’e ty enta’ o ana-dahi’ i Labaneo, nanao ty hoe, Finao’ Iakòbe ze fonga fanañan-drae’ay; le ty varan-drae’ay ty nampañefoefo aze. ");
INSERT INTO tdx_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ie niisa’ Iakòbe ty vinta’ i Labàne le naheo’e te tsy niatrefa’e manahake te taolo. ");
INSERT INTO tdx_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Aa le hoe t’Iehovà am’ Iakòbe, Mibaliha mb’an-tanen-droae’o mb’aman-drolongo’o mb’eo fa indrezako. ");
INSERT INTO tdx_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Aa le nampihitrife’e an-koike t’i Rahkele naho i Leae t’ie homb’ am-piandrazañe mb’am-pirai-lia’e mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Le nanoa’e ty hoe, Treako ty vintan-drae’areo te tsy iatrefa’e manahake taolo, fe mañimb’ ahy t’i Andrianañaharen-draeko. ");
INSERT INTO tdx_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Fohi’areo t’ie nitoroñ’ an-drae’areo an-kaozarako iaby, ");
INSERT INTO tdx_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","fe nifañahian-drae’areo naho novae’e im-polo o tam­be­koo, f’ie tsy nimetean’ Añahare hijoy ahy. ");
INSERT INTO tdx_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ie nanao ty hoe: O varevareo ro tambe’o, le songa niterake varevare o hare’eo, aa ie nanao ty hoe, O tanteharañeo ro tambe’o. Le hene nampipoke tanteharañe o hareo. ");
INSERT INTO tdx_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Aa le sininton’ Añahare aman-drae’areo o hare’eo vaho natolo’e ahy. ");
INSERT INTO tdx_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Teo te indraik’ amy sam-pisaheañey le nañinofy Iraho naho niandra vaho nahatrea te hene tanteharañe ndra varevare ndra poake o oselahy nitongoa amo mpirai-liao. ");
INSERT INTO tdx_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Le hoe t’i anjelin’ Añahare amako ama’ nofy, O Iakòbe, vaho natoiko ty hoe, Intoy iraho. ");
INSERT INTO tdx_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Le hoe re, Ampiandrao fihaino vaho mahaoniña te songa tanteharañe ndra varevare ndra poake ty ose­lahy misahe o hareo, amy te nitreako iaby ze nanoe’ i Labàne ama’o. ");
INSERT INTO tdx_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Izaho i Andrianañahare’ i Beteley, i nañoriza’o i vatolahiy naho nifanta’oy. Miongaha arè, engao ty toetse toy vaho mimpolia mb’an-tanen-dongo’o añe. ");
INSERT INTO tdx_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Aa le hoe ty natoi’ i Rahkele naho i Leae, Mbe aman’ anjara ndra lova añ’anjom­ban-drae’ay hao zahay? ");
INSERT INTO tdx_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Tsy mone atao’e te ambahiny kanao naleta’e? mbore nabotse’e iaby o lafitihi’aio. ");
INSERT INTO tdx_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Toe anay naho a o keleia’aio ze fonga hanaña’e nasintan’ Añahare aman-drae’ay; aa le ano ze tsinaran’ Añahare ama’o. ");
INSERT INTO tdx_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Niongak’ amy zao t’Iakòbe naho nampiningire’e an-drameva o vali’eo naho o ana’eo, ");
INSERT INTO tdx_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","vaho niroahe’e mb’eo ze hene hare’e naho o vara fa natonto’eo, o hanaña’e naho hare niazo’e e Padan’ arameo, vaho nitehafe’e mb’aman-drae’e Ietsake an-tane Kanàne añe. ");
INSERT INTO tdx_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Aa ie fa nimb’am-pañitsifan’ añondri’e mb’eo t’i Labàne, le kinizo’ i Rahkele o ndraharen’ anjomba an-drae’eo. ");
INSERT INTO tdx_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Toe nifañahie’ Iakòbe t’i Labàne t’ie tsy nitalily ama’e te nienga, ");
INSERT INTO tdx_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","ie nimotiotse mb’eo naho ze ama’e iaby. Niongake re nits­ake i sakay, le nitandrifie’e mb’am-bohibohi’ i Gilade mb’eo ty lahara’e. ");
INSERT INTO tdx_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Natalily amy Labàne amy andro fahateloy te nibioñe t’Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Aa le nendese’e o longo’eo naho nihoridañe’e fito andro vaho nahatratse aze am-bohibohi’ i Gilade eo. ");
INSERT INTO tdx_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Le niheo amy Labàne nte-Arame ami’ty nofy t’i Andrianañahare nanao ama’e ty hoe, Mitomira, tsy hisaon­tsy am’ Iakòbe ndra ty soa ndra ty raty. ");
INSERT INTO tdx_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Aa le nitra’ i Labàne t’Iakòbe. Fa nañoren-kibohotse am-bohitse ey t’Iakòbe, le nitobe am-bohibohi’ i Gilade ao t’i Labàne mirolongo. ");
INSERT INTO tdx_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Hoe t’i Labàne am’ Iakòbe, Ino o nanoe’oo? Ie niponiora’o am-pamañahiañe vaho namaoke o anak’ ampelakoo hoe mpirohy ni­tsepahem-pibara. ");
INSERT INTO tdx_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ino ty nibioña’o am-pañahy naho nivokake amako tsy nitalily, ie ho nampionjoneko an-drebeke naho sabo vaho kantsàñe miharo kararàke. ");
INSERT INTO tdx_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tsy nimea’o ty hañondrohako o ana-dahiko naho anak’ ampelakoo? Toe nanao hagegean-drehe te nanoa’o. ");
INSERT INTO tdx_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","An-tañako ty haozarañe hañoho-doza ama’ areo fe nitsara amako ami’ty nofy aniankale t’i Andrianañaharen-drae’o, ty hoe, Mitomira tsy hivolañe ndra soa ndra raty am’ Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ie amy zao, ndra te tsy nete tsy nionjom-b’eo irehe ami’ty hamaniña’o ty anjomban-drae’o, manao akore te nikamere’o o ndraharekoo? ");
INSERT INTO tdx_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Le hoe ty natoi’ Iakobe amy Labane, Toe nihemban-draho, nataoko ho nitavane’o amako o anak’ ampela’oo. ");
INSERT INTO tdx_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Fe tsy ho veloñe ze isa’o mitañe o ndrahare’oo. Itsikaraho añatrefa’ o longon-tikañeo le endeso ze fanaña’o amako. Toe tsy nifohi’ Iakòbe t’ie kinizo’ i Rahkele. ");
INSERT INTO tdx_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Aa le nimoake an-kiboho’ Iakòbe ao t’i Labàne, naho an-kiboho’ i Leae, vaho an-kiboho’ i mpitoro-ampela roe rey fe tsy nahaisake. Niakatse an-kiboho’ i Leae naho nizilik’ an-kiboho’ i Rahkele. ");
INSERT INTO tdx_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Ie amy zao fa rinambe’ i Rahkele o ndrahareo naho napo’e ambanen-pitobohañe an-drameva ao vaho nitoboha’e. Nitsi­tsife’ i Labàne kodaba i kibohotsey fe tsy nahaoniñe. ");
INSERT INTO tdx_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Le hoe re aman-drae’e, Ehe tsy ho viñera’ ty talèko te tsy imeteako ongake añatrefa’o, fa miampela. Aa le nikodebe re fe tsy nitendreke o sampo­sampon-drahao. ");
INSERT INTO tdx_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Niviñetse amy zao t’Iakòbe le nendaha’e t’i Labàne; hoe t’Iakòbe amy Labàne. Ino o fiolàko? Ino o hakeoko nañoridaña’o ahy an-kelokeo? ");
INSERT INTO tdx_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Aa ndra te nitsitsife’o tsoeke o haraokoo, ino amo haraon’ anjomba’oo ty niisa’o? Apoho añatrefa’ o longokoo naho o longo’oo etoañe, hizaka’ iareo añivon-tika roe. ");
INSERT INTO tdx_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Fa roapolo taoñe henanekeo ty nitraofako ama’o, le lia’e tsy nañary anake o añondri-vave’o naho o ose-vave’oo vaho tsy nihinanako o añondri-lahin-dia-rai’oo. ");
INSERT INTO tdx_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Tsy nendeseko ama’o ze nirimitem-biby fa nivavèko i hamotsoañey; pinai’o an-tañako ndra ty kinametse antoandro ndra ty kinizo haleñe. ");
INSERT INTO tdx_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ie nabotse’ ty fipisañañe te handro, nangora­tsake te haleñe vaho nibiòña’ ty roro o masokoo. ");
INSERT INTO tdx_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Inay i roapolo taoñe naha-mpiàmañ’ anjomba’o ahy rezay; nitoroñe azo folo-tao-efats’ amby hahazoako i anak’ ampela’o roe rey, vaho enen-taoñe o hare’oo, mbore novae’o im-polo i tambekoy. ");
INSERT INTO tdx_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Aa naho tsy nimpiamako t’i Andrianañaharen-draeko, t’i Andrianañahare’ i Avrahame, naho i nampañeveñe Ietsàkey le toe ho nampolie’o mañomaño. Nahavazoho o hasotriakoo naho o fitoloñan-­tañakoo t’i Andrianañahare vaho nañendak’ azo aniankale. ");
INSERT INTO tdx_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Aa le hoe ty natoi’ i Labàne am’ Iakòbe: Anak’ ampelako o anak’ ampelao, anadahiko o anadahio, hàreko o hareo vaho hene ahiko naho a i anakampelako rey ze isa’o. Fe ino ty hanoeko anito amo anak’ampelakoo, naho amo ana-dahy nisamahe’eo? ");
INSERT INTO tdx_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Mbetoa arè hifañina, izaho naho ihe; le ie ty ho valolombeloñe añivon-tikañe. ");
INSERT INTO tdx_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Aa le nandrambe vato t’Iakòbe vaho natroa’e ho ajiba. ");
INSERT INTO tdx_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Le hoe t’Iakòbe aman-drolongo’e, Amorio vato, le nandrambe vato iereo naho navotre, vaho nikama amy votrem-batoy. ");
INSERT INTO tdx_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Nanoe’ i Labàne ty hoe Iegare-Sahadotà, f’ie natao Iakòbe Galede. ");
INSERT INTO tdx_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Hoe t’i Labàne, Valolombeloñe añivoko naho ihe androany ty votre toy. Aa le natao Galede ty añara’e, ");
INSERT INTO tdx_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","naho Mizpa, fa hoe re, Hivazoho añivo’o naho izaho t’Iehovà naho tsy amy ila’ey ty raike. ");
INSERT INTO tdx_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Naho sarerahe’o o anak’ ampelakoo, ndra mañenga valy mandikoatse o anakoo, itika tsy amam-pañalañalañe, tiahio te valolombeloñe añivon-tika t’i Andrianañahare. ");
INSERT INTO tdx_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Le hoe t’i Labàne am’Iakòbe, Hehe ty votre tia naho ty ajiba najadoko añivo’o naho izaho. ");
INSERT INTO tdx_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Valolombeloñe ty votre tia, naho valolombeloñe ty ajiba toy te tsy handilarako mb’ ama’o mb’eo, vaho tsy ho lika’o ty votre toy ndra ty ajiba toy homb’amako, hañeloke. ");
INSERT INTO tdx_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","T’i Andrianañahare’ i Avrahame, naho t’i Andrianañahare’ i Nakore, t’i Andrianañaharen-droae’ iareo ty hizaka añivon-tika. Aa le nifanta amy Fañeveñan-drae’e Ietsàke t’Iakòbe, ");
INSERT INTO tdx_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","le nañenga soroñe ambohitse eo t’Iakòbe naho kinoi’e o longo’eo hikama, le nikama vaho nialeñe amy vohitsey. ");
INSERT INTO tdx_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Nañaleñaleñe t’i Labàne t’ie nitroatse naho norofa’e o ana’eo naho o anak’ampela’eo vaho nitata’e. Niavotse amy zao t’i Labane nimpoly mb’ama’e añe. ");
INSERT INTO tdx_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Nanonjohy i lia’ey t’Iakòbe le nifanalaka ama’e o anjelin’ Añahareo; ");
INSERT INTO tdx_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","aa ie niisa’ Iakòbe le nanao ty hoe, Toben’Añahare itoy, le natao’e ty hoe Makanaime i toetse zay. ");
INSERT INTO tdx_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Nirahe’ Iakòbe ty hiaolo aze mb’ amy Esave rahalahi’e mb’an-tane Seira, tane’ i Edome añe, ");
INSERT INTO tdx_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","le nafanto’e ami’ty hoe, Endeso mb’amy talèko Esa­ve añe o entañe zao, Hoe ty enta’ Iakòbe mpi­toro’o, Nañialo amy Labàne ao iraho, le nitambatse añe ampara’ henane; ");
INSERT INTO tdx_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Amañ’ añombe naho borìke, mpirai-lia naho ondevo ampela naho lahy; le nampihitrifeko mb’ amy talèkoy mb’eo ty saontsy hahatreavako fañisohañe am-pahaisaha’o. ");
INSERT INTO tdx_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Nibalike mb’am’Iakòbe i ìrake rey nitalily ty hoe, Nivo­trak’ amy Esave rahalahi’o zahay, le mb’etoan-dre hifana­laka ama’o rekets’ondaty efa-jato. ");
INSERT INTO tdx_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Nirevendreveñe naho nangebahebak’ amy zao t’Iakòbe; le zinara’e ho lia roe ze hene ondaty ama’eo naho o mpirai-liao naho o mpirai-trokeo vaho o rame­vao ");
INSERT INTO tdx_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","fa hoe re, Aa naho pok’ami’ty lia-raike t’i Esave vaho horidañe’e, le hifiora’ i sehanga’ey. ");
INSERT INTO tdx_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Le hoe t’Iakòbe, O ry Andria­nañahare’ i Avrahame raeko naho Andrianañahare’ Ietsàke raeko, ry Iehovà nanao tamako ty hoe, Mimpolia mb’ an-tane’o mb’amo longo’oo mb’eo vaho hanoako soa. ");
INSERT INTO tdx_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tsy mañeva ahiko ty piliti’e amo fiferenaiña’oo naho amo figahiña’o amo mpitoro’oo, kanao reketse kobaiñe Iraho te nits­a­ke ty Iordane toy vaho fa aman-dia’e roe henaneo. ");
INSERT INTO tdx_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Mihalaly ama’o, hahao am-pitàn-drahalahiko, am-pità’ i Esa­ve, fa ihembañako, hera homb’eto re handafa ahy naho rakemba reketse keleiañe. ");
INSERT INTO tdx_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ihe fa nitsara ty hoe, Toe hañasoa azo iraho, vaho hampiraeko amo fasen-driakeo o tarira’oo, ze tsy mete iaheñe ty amo fifamorohota’eo. ");
INSERT INTO tdx_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Aa le nitobe eo re amy haleñey, vaho nilivae’e amo raha rinambem-pità’eo ty ho ravoravo amy Esave zoke’e: ");
INSERT INTO tdx_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ose-vave roanjato, naho ose­lahy roa-polo, añondri-vave roanjato naho añondri-lahy roapolo, ");
INSERT INTO tdx_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","rameva minono rekets’ ana’e telopolo, añombe-vave efapolo, añombe-lahy folo, borìke vave roapolo, vaho ana-borìke folo. ");
INSERT INTO tdx_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Natolo’e an-taña’ o mpitoro’eo irezay, sindre lia’e, vaho hoe re amo mpitoro’eo, Iaolò Iraho naho adaradiso ami’ty lia-raike ty lia-raike. ");
INSERT INTO tdx_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Le hoe re amy aoloy, Ie mifanampe ama’o t’i Esave zokeko, manao ty hoe, Ama’ia irehe? Homb’aia v’iheo? vaho ho ama’ ia o aolo’oo? ");
INSERT INTO tdx_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","le hoe ty hatoi’o: A i Iakòbe mpitoro’oy, ravoravo nampisangitrife’e amy Esave talekoy; Indroy ie! manonjohy anay. ");
INSERT INTO tdx_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Izay ty nafanto’e amy faharoey naho amy fahateloy, vaho amo nanonjohy i mpirai-lia rey iabio, ami’ty hoe: Ty hoe zao ty ho saontsie’ areo amy Esave te mizo aze ");
INSERT INTO tdx_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","le tovoño ty hoe, Ingo, manonjohy anay t’Iakòbe mpitoro’o; ty amy asa’e ty hoe, Hampanintsiñeko amo ravoravo miaolo ahio ty haviñera’e; ie añe le ho treako ty lahara’e, ke ho no’e. ");
INSERT INTO tdx_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Aa le nitsake aolo’ aze i banabana’ey, ie nialeñe an-kialo atoy. ");
INSERT INTO tdx_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Nitroatse amy haleñey re, ninday i vali’e roe rey naho i mpitoro’e roe rey, vaho i ana-dahy folo-raik’ amby rey nitsake ami’ty fitsaha’ Iabòke. ");
INSERT INTO tdx_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Nasese’e mb’eo naho nampitsahe’e i torahañey vaho nampitsahe’e ze tama’e. ");
INSERT INTO tdx_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Aa le nidoke ho vahiny t’Iakòbe vaho niga­rabiñe ama’e ty lahilahy ampara’ te niporea’ ty maraindray. ");
INSERT INTO tdx_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ie nioni’e te tsy hahagiok’ aze, le pi­nao’e ty fikatsoha’ ty moja’e, vaho nikatsoke ty moja’ Iakòbe amy fifan­dra­paha’ey. ");
INSERT INTO tdx_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Le hoe re, Avotsoro fa hanjirike i àndroy. Fe hoe re, Tsy havo­tsoko naho tsy itata’o hey. ");
INSERT INTO tdx_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Aa le nanoa’e ty hoe, Ia ty añara’o? Iakòbe, hoe re. ");
INSERT INTO tdx_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Le hoe re, Tsy hatao Iakòbe ka ty tahi­na’o, fa Israele, amy t’ie nifanehak’ aman’ Andrianañahare naho am’ondatio vaho nahatañe. ");
INSERT INTO tdx_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Hoe ty nañontanea’ Iakòbe, Ehe, itsarao ty tahina’o. Fa hoe re, Ino ty añontanea’o ty añarako? Le nitata’e eo. ");
INSERT INTO tdx_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Aa le natao’ Iakòbe ty hoe Penoele i toetsey, ami’ty hoe, Nifañatre-daharañe aman’ Añahare iraho, fe narova’e ty fiaiko. ");
INSERT INTO tdx_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Nanjirike i àndroy t’ie nitsake e Penoele ty amy moja’ey. ");
INSERT INTO tdx_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Aa le tsy fikamà’ o nte-Israeleo pake henane ty oza’ i moja mipitek’ am-pikatsohañey, amy te nipaohe’e ty oza’ i fikatsoha’ i moja’ Iakòbey ami’ty lahin-oza’ i tohakeiy. ");
INSERT INTO tdx_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Le nampiandrà’ Iakòbe o fihaino’eo naho niisa’e te nimb’ ama’e mb’eo t’i Esa­ve reketse ty lahilahy efa-jato. Aa le zinara’e amy Leae naho amy Rahkele vaho amy mpitoro’e ampela roe rey o ajajao. ");
INSERT INTO tdx_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Na­noe’e aolo’e ey o mpitoroñeo rekets’ o ana’eo, le nanonjohy iereo t’i Leae naho o ana’eo vaho amboly ao t’i Rahkele naho Iosefe. ");
INSERT INTO tdx_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Niary mb’aolo’ iereo mb’eo re nibokok’ an-tane im-pito am-pañarineañe i zoke’ey ");
INSERT INTO tdx_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Aa le nilay mb’ama’e mb’eo t’i Esave niambotrak’ amy fititia’ey le norofa’e vaho sambe nangoihoy. ");
INSERT INTO tdx_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Niandra t’i Esave nahaoniñe o rakemba reketse keleiañeo, le hoe re, Ia o mindre lia ama’oo? Hoe re: O anake natolon’Añahare am-patarihañe amo mpitoro’oo. ");
INSERT INTO tdx_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Nitotoke mb’eo amy zao o mpitoroñ’ ampela rekets’ anakeo, le nibokok’ ambane; ");
INSERT INTO tdx_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","nimb’eo ka t’i Leae rekets’ anake naho nibokoke; nañarine amy zao t’Iosefe naho i Rahkele sindre niondreke. ");
INSERT INTO tdx_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Hoe t’i Esave, Ino ty dika’ i lia’e maro nikovovoke nifanalaka amakoy? Tinoi’ Iakòbe ty hoe, Ty hahatendrehañe fañisohañe am-pivazohoa’ i talèkoy. ");
INSERT INTO tdx_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Fa hoe t’i Esave, Mahàtsek’ ahy o ahikoo, ry rahalahiko, tano ho azo o azoo. ");
INSERT INTO tdx_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Hoe t’Iakòbe, Aiy, ie nahatrea ìsok’ am-pahaisaha’o, le rambeso an-tañako o ravoravoo; amy te izaho mahaisake o lahara’oo, le hoe mahatrea ty laharan’ Añahare, vaho t’ie nino’o. ");
INSERT INTO tdx_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ehe rambeso i ravoravo binanabanako, fa niferenaiñan’ Añahare, naho maro o amakoo. Le nosihe’e vaho rinambe’e. ");
INSERT INTO tdx_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Le hoe re, Antao hitrao-dia, le hiaolo anahareo iraho. ");
INSERT INTO tdx_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Fe hoe ty natoi’e, Fohi’ ty talèko te kamba o ajajao, vaho amako o rene’e naho añombe-vave rohy, aa naho ilosoran-tehake ndra andro raike le fonga ho mate o hareo. ");
INSERT INTO tdx_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ehe te hañavelo aolo’ i mpitoro’ey mb’eo ty talèko, hisitsirako mora mb’eo ty amo hare mangovovok’ aolo ahio naho ty amy filesalesa’ o ajajao, ampara’ te pok’ amy talèko e Seire añe. ");
INSERT INTO tdx_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Aa le hoe t’i Esave, Angao han­divako ama’o ondaty amakoo. Fa hoe re, Fa akore? Ee t’ie hahatrea fañisohañe am-pahaisaha’ i talèkoy. ");
INSERT INTO tdx_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Aa le nimpoly mb’e Seire añe amy àndro zay t’i Esave. ");
INSERT INTO tdx_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Le nimb’e Sokote añe t’Iakòbe le nañoren-kivoho, naho nam­boa­ra’e fialofañe o añombe’eo, vaho natao Sokote i toetsey. ");
INSERT INTO tdx_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Niavy tsy añolañe an-drova’ i Sikeme an-tane Kanàne eo t’Iakòbe boake Padan’ arama añe, vaho nañoren-kivoho aolo’ i rovay ey. ");
INSERT INTO tdx_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Le vinili’e bogady zato amo ana’ i Khamòre rae’ i Sikemeo ty ila’ i teteke nampipoha’e i kivoho’eiy. ");
INSERT INTO tdx_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Le nañoren-kitrely eo ze natao’e El-Elohe-Israele. ");
INSERT INTO tdx_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Niakatse hitilike o ampela’ i taneio t’i Dinae, anak’ampela’ i Leae, nisamake ama’ Iakòbey. ");
INSERT INTO tdx_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ie nahaisak’ aze t’i Sikeme, ana’ i Khamòre nte-Khive, mpifehe’ i taney, le rinambe’e naho vinaho’e vaho nanimba aze. ");
INSERT INTO tdx_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Fe nipitek’ amy Dinae ana’ Iakòbe ty tro’e; nitea’e i ampelay, toe nihonkoñe’e an-drehake i somondraray. ");
INSERT INTO tdx_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Aa le hoe t’i Sikeme amy Khamòre rae’e, Alao ho ahiko i ampelay ho valiko. ");
INSERT INTO tdx_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Jinanji’ Iakòbe te nitivae’e t’i Dinae anak’ampela’e fe niarak’ añombe am-piandrazañe añe o ana-dahi’eo le nianjiñe hey t’Iakòbe ampara’ t’ie nimpoly. ");
INSERT INTO tdx_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Niavotse mb’am’ Iakòbe mb’eo t’i Khamòre hifanaontsy, ");
INSERT INTO tdx_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","le boak’ an-kivok’añe o ana’ Iakòbeo te nahatsanoñe, ie niompo’ ty fombo amy hagegeam-bey nanoe’e am’ Israeley, t’ie namahotse i ana’ Iakòbey, fa vata’e tsy fanao. ");
INSERT INTO tdx_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Aa hoe ty enta’ i Khamòre am’ iereo, Mifamitran-trok’ amy anak’ampela’ areoy t’i Sikeme anako; ehe, atoloro’ aze ho vali’e. ");
INSERT INTO tdx_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Mifanambalia ama’ay; meo anay o anak’ ampela’ areoo le engao ho anahareo o anak’ am­pela’aio, ");
INSERT INTO tdx_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","le mitraofa fimoneñe, fa añatrefa’ areo o taneo; imoneño le mikaloa ao vaho manontona vara ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Hoe ka t’i Sikeme aman-drae’e naho amo rahalahi’eo, Ehe t’ie hahatrea fañisohañe am-pihaino’areo, ze saontsie’ areo le homeako. ");
INSERT INTO tdx_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Aonjono naho alosoro amako ty lafitihy naho ty ravoravo le ho tolorako ze hampanoe’ areo, fa, ehe, meo ahiko i somondraray ho valy. ");
INSERT INTO tdx_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Fe vinale’ o ana’Iakòbeo am-pamañahiañe t’i Sikeme naho i Khamòre (ie nameta i Dinae, zai’ iareo.) ");
INSERT INTO tdx_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Hoe ty asa’ iareo tama’e, Tsy mete’ay o raha zao, ty manolotse ty zai’ay ampela ami’ ty tsy afa-boy fa fañinjeañe ama’ay. ");
INSERT INTO tdx_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Aa kanao hiantofa’ay, le hifa­nahake ama’ay nahareo, te songa hafahañ’ ofoke ze atao lahilahy ama’ areo; ");
INSERT INTO tdx_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","vaho hitolora’ay o anak’ ampela’aio, naho hangala’ay o anak’ ampela’ areoo naho hiharoa’ay fimoneñañe vaho ho ondaty raike tika. ");
INSERT INTO tdx_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Fa naho tsy mete mañaoñe anay tsy hisavatse, le hendese’ay ty anak’ampela’ay, hienga. ");
INSERT INTO tdx_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ninò’ i Khamòre naho i Sikeme ana’ i Khamòre i saontsy zay; ");
INSERT INTO tdx_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","le tsy nihenekenek’ amy rahay i ajalahiy, amy te nampinembanembañ’ aze i anak’ ampela’ Iakòbey. Toe ie ty nanañ’ asy amo hene añ’an­jomban-drae’eo. ");
INSERT INTO tdx_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Aa le nivotrak’ an-dalambein-drova’ iareo t’i Khamòre naho i Sikeme ana’e le nilañoñe am’ ondati’ i rova’ iare­oio ami’ty hoe, ");
INSERT INTO tdx_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Ondaty mora aman-tika iereo; angao himoneñe an-tane atoy, hihezeñe ama’e, fa heheke, tsahatse iareo ty habei’ o taneo; hengaen-tika ho valy o anak’ ampela’ iareoo vaho hitoloran-tika o anak’ ampelan-tikañeo. ");
INSERT INTO tdx_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Fe ami’ty fetse toy avao ty hitrao­fa’ iareo fimoneñe aman-tika h’ondaty raike: te songa hisavatse ze lahilahy amantika amy t’ie ro afa-boy. ");
INSERT INTO tdx_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tsy ho antika hao o añombe’ iareoo naho o vara’ iareoo naho ze hene hare’iareo? Aa le antao hiantoke, hitraofa’iareo fimoneñe aman-tika. ");
INSERT INTO tdx_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Jinanji’ ze mpienga an-dalambei’ i rovay ty saontsi’ i Khamòre naho i Sikeme ana’e; le songa sinavatse o lahilahio, ze hene mpienga an-dalambei’ i rovay. ");
INSERT INTO tdx_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Aa ie amy andro fahateloy, naho mbe niti­von­tivoñe iereo, le sindre nandrambe ty fibara’e ty ana’ Iakòbe roe, i Simone naho i Levy, rahalahi’ i Dinae, naho nitoañe mb’amy rovay mb’eo, vaho fonga zinamañe ze atao lahilahy. ");
INSERT INTO tdx_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Zinevo’ iareo am-pibara t’i Khamòre naho i Sikeme naho rinambe’iereo boak’añ’anjomba’ i Sikeme ao t’i Dinae vaho niavotse. ");
INSERT INTO tdx_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Nitendreke o loloo i ana’ Iakòbe ila’e rey vaho kinopa’iereo i rovay ty amy zai’e ampela vinètay. ");
INSERT INTO tdx_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Fonga finao’ iereo o mpirai-lia’ iareoo naho o tro-rai’ iareoo, o borìke’ iareoo, ze an-drova ao naho ze an-kivoke ey; ");
INSERT INTO tdx_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","naho ze hene vara’iareo naho o keleia’ iareoo naho o vali’ iareoo vaho fonga nikopahe’ iereo ze añ’anjomba ao. ");
INSERT INTO tdx_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Le hoe t’Iakòbe amy Simone naho i Levy, Nanolo-tsotry ahiko nahareo le mitròtrotse amo mpimone’ ty tane toio iraho, amo nte-Kanàneo, amo nte-Perè­zeo; aa kanao tsy ampeampe ondatikoo, hifanontoñe iereo, hamono ahy, le ho rotsake reketse hasavereñañe. ");
INSERT INTO tdx_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Fa hoe ka iereo, Aa vaho ho nanoe’e tsimirirañe hao i zai’aiy? ");
INSERT INTO tdx_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Le hoe t’i Andrianañahare am’Iakòbe, Miongaha, le mionjona mb’e Betele mb’eo vaho imoneño. Mandranjia kitrely aman’ Añahare nisodehàñe ama’o ie nibioñe an-daharan-joke’o Esave. ");
INSERT INTO tdx_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Aa le hoe t’Iakòbe amy hasavereña’ey naho amo mpiama’e iabio, Apoho ze fonga ndrahare ambahiny ama’ areo, miliova, naho mañova saroñe; ");
INSERT INTO tdx_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","vaho antao hionjoñe mb’e Betele mb’eo handranjiako kitrely amy Andrianañahare nanoiñe ahiko an-tsan-kaloviloviako vaho nindre amako amy ze lala-nombàko. ");
INSERT INTO tdx_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Aa le fonga natolo’ iareo am’ Iakòbe o samposampon-draha an-taña’ iereoo naho o kiviro an-dravembia’ iareoo vaho nakafi’ Iakòbe ambane’ ty kile marine’ i Sikeme ao. ");
INSERT INTO tdx_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ie nañavelo, le fa amo rova mañohoke iareoo ty firevendreveñañe aman’ Añahare, vaho tsy nihoridañe’ iareo o ana Iakòbeo. ");
INSERT INTO tdx_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Nandoake e Loze an-tane-Kanàne ao, toe i Betele, t’Iakòbe, ie naho ondaty nindre ama’e iabio, ");
INSERT INTO tdx_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","le nandranjy kitrely eo vaho natao’e ty hoe El-Betele i toetsey amy te teo ty niboahan’ Añahare ama’e amy fibioña’e an-drahalahi’ey. ");
INSERT INTO tdx_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nihomake eo t’i Deborae, mpiatra’ i Ribkae, vaho naleveñe ambane’ ty kile ambane’ i Betele ao; le nanoe’e Alòne-Bakòte. ");
INSERT INTO tdx_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Niboak’ am’ Iakòbe indraike t’i Andrianañahare amy nienga’e i Padan’ arame naho nitata azey, ");
INSERT INTO tdx_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","le nanao ty hoe ama’e t’i Andrianañahare: Iakòbe ty añara’o, le tsy hatao Iakòbe ka, fa Israele ty ho tahina’o; aa le natao’e Israele ty tahina’e. ");
INSERT INTO tdx_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Le hoe t’i Andrianañahare ama’e, Izaho ro El-Sadai; mirao­raòa naho mamorohota; hiboak’ ama’o ty foko naho firimboñam-poko, vaho mpanjaka maro ro hiboak’ an-tsandri’o. ");
INSERT INTO tdx_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Le hatoloko azo i tane’ natoloko i Avrahame naho Ietsàke vaho hatoloko amo tarira’o hanonjohy azoo i taney. ");
INSERT INTO tdx_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Aa le nienga aze t’i Andrianañahare, amy toetse nitsara’e ama’ey. ");
INSERT INTO tdx_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Nampitroara’ Iakòbe ajiba i toetse nitsara’e ama’ey, ajiba vato, naho nampidoaña’e enga-rano vaho nañiliña’e solike. ");
INSERT INTO tdx_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Aa le natao Iakòbe ty hoe Betele i toetse nitsaran’ Añahare ama’ey. ");
INSERT INTO tdx_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Nañavelo boak’e Betele iereo, naho didý tsy nipotìtse Efrata te nitsongo t’i Rahkele vaho nisilofe’ ty fañeña’e. ");
INSERT INTO tdx_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ie añate’ i fitsongoa’ey le hoe i mpiatra’ey ama’e, ko hembañe fa ana-dahy tovo’e toy. ");
INSERT INTO tdx_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ie ho nirofotse ty arofo’e (toe nihomake), le natao’e Benoný ty añara’e, f’ie nitokaven-drae’e Beniamine. ");
INSERT INTO tdx_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Aa le nihomake t’i Rahkele le naleveñe an-dalañe mb’e Efrata (i Betlèkheme) ao, ");
INSERT INTO tdx_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","vaho nampijadoña’ Iakòbe vatolahy an-kibori’e eo; i vatolahin-kiborin-dRahkele henaney. ");
INSERT INTO tdx_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Nionjom’beo t’Iakòbe vaho nañoreñe ty kiboho’e ambali’ ty fitala­kesañ’ abo’ i Edère ey. ");
INSERT INTO tdx_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ie nimoneñe amy taney t’Israele, le niheo amy Bilhae, sakezan-drae’e ao t’i Reòbene le niolora’e vaho jinanji’ Israele. Ie amy zao, folo-ro’amby ty ana-dahi’ Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","O ana’ i Leaeo: i Reòbene (tañoloñoloña’ Iakòbe), i Simone, i Levy, Iehodà, Isakare, vaho i Zebolone. ");
INSERT INTO tdx_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","O ana’ i Rahkeleo: Iosefe naho i Beniamine. ");
INSERT INTO tdx_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","O ana’ i Bilhae, mpitoro’ i Rahkeleo: i Dane naho i Naftalý. ");
INSERT INTO tdx_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","O ana’ i Zilpahe, mpitoro’ i Leaeo: i Gade naho i Asère. Irezay ro ana’ Iakòbe nitoly e Padan’ arame añe. ");
INSERT INTO tdx_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Niheo mb’ aman-drae’e Ietsàke e Mamrè añe t’Iakòbe, an-drova’ i Harbà atao Khebroney, i nañialoa’ i Avrahame naho Ietsàkey. ");
INSERT INTO tdx_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ie amy zao, zato-tsi-valom-polo taoñe ty ian’ andro’ Ietsàke. ");
INSERT INTO tdx_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Nigadoñe ty fipetro’ Ietsàke le nivilasy vaho natontoñe am’ ondati’eo, androanavy henek’ andro; nandentek’ aze t’i Esave naho Iakòbe ana’e. ");
INSERT INTO tdx_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iretoy ro tarira’ i Esave (i Edòme). ");
INSERT INTO tdx_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Nangala-baly amo anak’ampela nte-Kanàneo t’i Esave: i Adàe ana’ i Elòne nte-Kìte, i Oholibamà ana’ i Anà ana’ i Tsibòne nte-Kive, ");
INSERT INTO tdx_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","naho i Bosemàte ana’ Ies­maèle, rahavave’ i Nebaiòte. ");
INSERT INTO tdx_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Nisamake i Elifàze amy Esave t’i Adàe; nisamake i Reoèle t’i Bosemate; ");
INSERT INTO tdx_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","le nisamake i Elifaze, Ieìse, Ialàme, naho i ­Kòrahke t’i Oholibamà. Ie ro ana’ i Esave nasama’e an-tane Kanàne ao. ");
INSERT INTO tdx_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Nendese’ i Esave o vali’eo, o ana-dahi’eo, o anak’ ampela’eo, naho ze hene añ’anjomba’e, naho o añombe’eo, o hare fiandraze’e iabio naho ze fonga vara natonto’e an-tane Kanàne ao vaho nisese mb’an-tane hisitaha’e an-daharan-drahalahi’e Iakòbe añe, ");
INSERT INTO tdx_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","amy te loho maro ty fanaña’ iareo roe, tsy haha-fiharo-pimoneñañe; tsy nitsahatse iareo i tane nañialoa’iareoy ty amo hare’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Aa le nitoetse am-bohi’ Seire ao t’i Esave; Edome ‘nio t’i Esave. ");
INSERT INTO tdx_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iretoañe ro tarira’ i Esave, rae’ o nte-Edomeo, am-bohi’ Seire ao. ");
INSERT INTO tdx_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Ty tahina’ o ana’ i Esaveo le: i Elifaze ana’ i Adàe, vali’ i Esave; i Reoèle, ana’ i Bosmate vali’ i Esave. ");
INSERT INTO tdx_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","O ana’ i Elifazeo: i Temane, i Omare, i Tsefò, naho i Gatame, vaho i Kenaze. ");
INSERT INTO tdx_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","(Sakeza’ i Elifaze, ana’ i Esave t’i Timnàe nisamake i Amalek’ amy Elifaze.) Iereo ro ana’ i Adae, vali’ i Esave. ");
INSERT INTO tdx_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Iretoy ro ana’ i Reoele: i Nàkate, naho i Zèrake, i Samà, vaho i Mizà. Iereo ro ana’ i Bosemate, vali’ i Esave. ");
INSERT INTO tdx_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iretoy ro ana’ i Oholibamàe, ana’ i Anà, ana’ i Tsibone, vali’ i Esave: nisamahe’e amy Esave t’Ieose naho Ialame vaho i Korake. ");
INSERT INTO tdx_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iretoy ro fifokoa’ o ana’ i Esaveo. O ana’ i Elifaze, tañoloñoloña’ i Esaveo: i Temane talè, i Omare talè, i Zefò talè, i Kenaze talè, ");
INSERT INTO tdx_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","i Korake talè, i Gatame talè, i Amaleke talè; ie o talè boak’amy Elifaze ana’ i Adae an-tane Edomeo. ");
INSERT INTO tdx_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iretoy ro ana’ i Reoèle ana’ Esave: i Nakàte talè, i Zeràke talè, i Samà talè, vaho i Mizà talè; ie ro talè boak’ i Reoèle an-tane Edome ao, ana’ i Basemate vali’ i Esave. ");
INSERT INTO tdx_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Intoy o ana’ i Oholibamàe, vali’ i Esaveo: t’Ieòse talè, Ialame talè, vaho i Kòrake talè; ie ro talè nasama’ i Oholibamàe, vali’ i Esave naho ana’ i Anà. ");
INSERT INTO tdx_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ie ro ana’ i Esave (i Edome), naho o talè’eo. ");
INSERT INTO tdx_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Intoy o ana’ i Seire nte-Khorý mpimo­neñe amy taneio: i Lotane naho i Sòbale naho i Tsibòne naho i Anà, ");
INSERT INTO tdx_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","naho i Disone, naho i E’tsere, vaho i Disane; ie ro talè’ o nte-Khorio, ana’ i Seire an-tane’ Edome ao. ");
INSERT INTO tdx_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Le o ana’ i Lotàneo: i Khorý, naho i Hemame vaho i Timnae rahavave’ i Lotane. ");
INSERT INTO tdx_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","O ana’ i Sòbaleo : i Alvane naho i Manakate, naho i Ebale, i Sefò vaho i Oname. ");
INSERT INTO tdx_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","O ana’ i Tsiboneo: i Aià naho i Anà ie roe; i Anà ty nahatendreke o rano mae am-patrañeo ie niarake o borìke’ i Tsibone rae’eo. ");
INSERT INTO tdx_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","O ana’ i Anào: i Disone naho i Oholi­bamàe anak’ ampela’ i Anà. ");
INSERT INTO tdx_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","O ana’ i Disoneo: i Kemdane, naho i Esbane, naho Iit’rane, vaho i Kerane. ");
INSERT INTO tdx_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","O ana’ i E’tsereo: i Bilhane, naho i Zaavane, vaho i Akane. ");
INSERT INTO tdx_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","O ana’ i Disaneo: i Otse naho i Arane. ");
INSERT INTO tdx_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","O talè’ o nte-Khorio: i Lotane talè, i Sobale talè, i Tsibone talè, i Anà talè, ");
INSERT INTO tdx_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","i Disone talè, i Etsere talè, i Disane talè; ie ro talè’ o nte-Kkorio; o mpiaolon-tane Seireo. ");
INSERT INTO tdx_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Intoy o mpanjaka nifehe an-tane’ Edome ao aolo’ te amam-panjaka ni­fehe o ana’ Israeleoo. ");
INSERT INTO tdx_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Nifehe ty rova atao Dinhabà e Edome ao t’i Belà ana’ i Beore. ");
INSERT INTO tdx_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Nivilasy t’i Belà le nandimbe aze ho mpanjaka t’Iobabe ana’ i Zeràke nte-Botsrà. ");
INSERT INTO tdx_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Nivilasy t’Iobabe le nan­dimbe aze ho mpanjaka t’i Khosàme tan-tane’ o Temanio. ");
INSERT INTO tdx_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Nivilasy t’i Khosàme, le nandimbe aze ho mpanjaka t’i Hadade ana’ i Bedade, i nahagioke i Midiane a monto’ i Moabey; atao Avite i rova’ey. ");
INSERT INTO tdx_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Nivilasy t’i Hadade, le nandimbe aze ho mpanjaka t’i Samlà nte-Masrekà. ");
INSERT INTO tdx_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Nivilasy t’i Samlà, le nandimbe aze ho mpanjaka t’i Saòle nte-Rekhobòte boak’ amy sakay añe. ");
INSERT INTO tdx_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Nivilasy t’i Saole, le nandimbe aze ho mpanjaka t’i Baal-kanàne ana’ i Akbore. ");
INSERT INTO tdx_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Nivilasy t’i Baal-kanàne ana’ i Akbore, le nandimbe aze ho mpanjaka t’i Hadare; natao Paò i rova’ey; Mehetabèle anak’ ampela i Matrède, anak’ ampela’ i Mezahabe ty vali’e. ");
INSERT INTO tdx_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Zao o tahina’ o talè’ i Esave amo hasavereña’eo naho o rova’eoo; ty tahina’ iareo: i Timnà talè, i Alvà talè, Ietète talè, ");
INSERT INTO tdx_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","i Aholibamae talè, i Elà talè, i Pinone talè, ");
INSERT INTO tdx_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","i Kenaze talè, i Temane talè, i Mibtsare talè, ");
INSERT INTO tdx_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","i Magdiele talè, Irame talè; ie ro mpiaolo’ i Edome ty amo akiba’ iareo an-tane fanaña’ iareoo. (rae’ o nte-Edomeo t’i Esave) ");
INSERT INTO tdx_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Nitoetse an-tane Kanàne nañialoan-drae’e ao t’Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ie ty talili’ ty hasavereña’ Iakòbe. Ie nifolo-tao-fito-amby t’Iosefe le niarake añondry mindre amo raha­lahi’eo, ie mbe niajalahy naho nindre amo ana’ i Bilhae naho amo ana’ i Zilpae, valin-drae’eo, vaho ninday talily raty iareo aman-drae’e añe t’Iosefe. ");
INSERT INTO tdx_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Nikokoa’ Israele mandikoatse o ana’e iabio t’Iosefe, amy t’ie ty ana’ i haantera’ey vaho namboara’e saroñe lava soa vahotse. ");
INSERT INTO tdx_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ie nioni’ o rahalahi’eo te nisohen-drae’e mandikoatse iareo le nalaim-bintañe aze vaho tsy nahafirehak’ am-panintsiñañe ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Teo te nañinofy t’Iosefe, le natalili’e amo rahalahi’eo, f’ie nañìndra ty falai’ iareo aze. ");
INSERT INTO tdx_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Hoe ty asa’e ama’e, Ehe janjiño ty nofy ninofiseko toy. ");
INSERT INTO tdx_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Teo tika namehe taho an-tetek’ ao. Nitroatse amy zao i fehekoy le niadaoro eo, le ingo niariseho ahy ey ty fehe’ areo nibokok’ amy fehe-tahokoy. ");
INSERT INTO tdx_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Hoe o rahalahi’eo ama’e, Toe ihe hao ty hame­lek’ anay? Vata’e hifehe anay v’iheo? Aa le niindra ty falaim-binta’ iareo ty amo nofi’eo naho o asa’eo. ");
INSERT INTO tdx_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nañinofy indraike, vaho natalili’e amo rahalahi’eo. Inao ty nofiko tovo’e: naheoko te nibotrek’ amako i àndroy, i volañey vaho ty vasiañe folo raik’amby. ");
INSERT INTO tdx_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Aa ie natalili’e aman-drae’e naho amo rahalahi’eo le nañendak’ aze ty rae’e ami’ty hoe: Nofy manao akore o nofise’oo? Toe hene hidrakadrakak’ an-tane ama’o hao zahay naho i rene’o vaho o rahalahi’oo? ");
INSERT INTO tdx_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Aa le nitsikirìk’ aze o rahalahi’eo, fe nitsakorèn-drae’e i asa’ey. ");
INSERT INTO tdx_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Nañavelo mb’e Sikeme añe o raha­lahi’eo hampiandrazeñe i lia-rain-drae’ey. ");
INSERT INTO tdx_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Le hoe t’Israele am’Iosefe, Tsy miarake i lia-raikey e Sikeme añe hao o rahalahi’oo? Antao arè, hiraheko mb’am’iereo mb’eo. Tinoi’e ty hoe, Intoy iraho. ");
INSERT INTO tdx_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Aa le hoe re ama’e, Akia, sario ke mbe soa avao iereo naho mbe soa ka o mpirai-liao; le mibaliha mb’amako mb’etoa aman-talily. Aa le nampihitrife’e mb’eo boak’ am-bavatane’ i Khebrone ao mb’e Sikeme mb’eo, ");
INSERT INTO tdx_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","le teo ty ondaty nanjo aze nirererere an-kivok’ ey, vaho nañontanea’ indatiy, Ino ty paia’o. ");
INSERT INTO tdx_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Mipay o rahalahikoo ‘ni-raho, hoe re, Ehe, ampahafohino ahy ty fian­draza’ iareo añondry. ");
INSERT INTO tdx_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Hoe indatiy, Fa nienga iereo, Inao ty tsinanoko am’ iereo, Antao ho mb’e Dotane mb’eo. Aa le nihitrike mb’ amo rahalahi’eo re vaho tendrek’ am’iereo e ­Dotane añe. ");
INSERT INTO tdx_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Nitalakese’ iereo, le ie mbe tsy marine ro nikilily hañohofan-doza ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Hoe ty vesoveso’ iareo, Hehe, mb’etoa i mpañinofiy, ");
INSERT INTO tdx_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","antao arè hamono aze naho hagodon-tika an-kadaha ao; naho hatalilin-tika te nabotse’ ty biby romotse, vaho ho onin-tika ty figadoña’ o nofi’eo. ");
INSERT INTO tdx_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","F’ie jinanji’ i Reòbene, le navotso’e am-pità’ iareo ami’ty hoe, Tsy hamitak’ ate aze tika. ");
INSERT INTO tdx_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tinovo’ i Reòbene am’iereo ty hoe, Ko mampiori-dio; afetsaho an-kadaha an-jerezere tane atoy, fa ko mipao-tañañe ama’e—ie te hamotso­tse aze am-pità’ iareo hampolia’e aman-drae’e. ");
INSERT INTO tdx_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Aa naho pok’ amo rahalahi’eo t’Iosefe, le hinalo’ iareo am’ Iosefe i saro’ey, i saroñe lava ama’ey, ");
INSERT INTO tdx_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","le rinambe’ iereo vaho nafetsa’ iereo an-kadaha ao. Nikapaike i kadahay, tsy aman-drano. ");
INSERT INTO tdx_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Niambesatse amy zao iereo nikama; fa ie nampiandra fihaino le nahaisake lia-rain-te-Iesmaèle nan­govo­vòke boak’ e Gileade añe an-drameva ninday fisoman­tsaike naho fihosotse vaho lite, nizotso mb’e Mitsraime mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Le hoe t’Ièhodà amo rahalahi’eo, Ino ty tombo’e ho an-tika te vonoeñe i rahalahin-tikañey naho etaheñe i lio’ey? ");
INSERT INTO tdx_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Antao handetak’ aze amo nte-Iesmaèleo le tsy hampidoñan-tañantika, amy te rahalahintika, toe nofon-tikañe. Le nihaoñe’ o rahalahi’eo. ");
INSERT INTO tdx_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ie nim-beo o mpanao takinake nte-Midianeo le tinari’ iereo, nañakatse Iosefe amy kadahay vaho naleta’ iereo volafoty roapolo amo nte-Iesmaèleo vaho nendese’ iareo mb’e Mitsraime añe t’Iosefe. ");
INSERT INTO tdx_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Nibalike mb’amy kadahay mb’eo t’i Reòbene naho naheo’e te tsy an-kadaha ao t’Iosefe, vaho rinia’e o saro’eo. ");
INSERT INTO tdx_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nivalike mb’amo rahalahi’eo re nanao ty hoe, Tsy eo i ajalahiy, le izaho! aia ty hombako? ");
INSERT INTO tdx_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Aa le rinambe’ iareo i saro’ey, le nandenta vik’ose, vaho nalo’ iareo ami’ty lio’e ao i saroñey. ");
INSERT INTO tdx_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nahitrik’ añe i saro-vinahotsey, naho nendese’ iareo aman-drae’e ami’ty hoe, Ingo ty nizoe’ay, ehe vazoho ke ie i saron’ ana’oy, ke tsie. ");
INSERT INTO tdx_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Napota’e, le nanao ty hoe, Saron’ anako toy! Navorembore’ ty biby hako, tsy mikalafo te rinomidromitse t’Iosefe. ");
INSERT INTO tdx_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Rinia’ Iakòbe amy zao o saro’eo naho nisadia gony vaho nandala i ana-dahi’ey andro maro. ");
INSERT INTO tdx_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Hene niongake hañohoñe aze o ana-dahi’eo naho o anak’ ampela’e iabio, f’ie nifoneñe tsy hohoñeñe, ami’ty hoe, Aiy, hizotso mb’an-tsikeo­keoke mb’ aman’ ana-dahiko iraho an-kontoke. Izay ty fangoihoian-drae’e aze; ");
INSERT INTO tdx_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Toe naleta’ o nte-Midi­aneo e Mitsraime añe re, amy Potifare, roandria’ i Parò, talèm-pigaritse. ");
INSERT INTO tdx_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ie henane zay, nienga amo rahalahi’eo t’Iehodà nitsile mb’ ami’ty nte-Adolame atao Hirà. ");
INSERT INTO tdx_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Le nitendreke anak’ampela nte-Kanàne atao Soae t’Iehodà; le nengae’e vaho nimoak’ ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Niaren-dre, nisamak’ anadahy; le natao’e Ere ty aña­ra’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Niareñe indrai­ke re nahatoly ana-dahy, le natao’e Onane ty aña­ra’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Mbe nahatoly ana-dahy in­draike re le natao’e Selà ty añara’e. Te Kezibe añe t’ie nahatoly aze. ");
INSERT INTO tdx_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Nangala-baly ho a i Ere, tañoloñoloña’ey t’Iehodà; Tamare ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Fe nilo-tserek’ am-pivazohoa’ Iehovà t’i Ere, tañolo­ñoloña’ Iehodày, vaho navetra’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Le hoe t’Iehodà amy Onane, Mimoaha amy valin-joke’oy vaho rañaoto, hampitroara’o tariratse ho a i rahalahi’oy. ");
INSERT INTO tdx_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Aa kanao napota’ i Onane te tsy ho aze i tiry zay, le ie nizilik’ amy valin-joke’ey ao, naria’e an-tane ty rompilahia’e, tsy mone hanolo-tariratse aman-drahalahi’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Tsy ninò’ Iehovà i sata’ey, le navetra’e ka. ");
INSERT INTO tdx_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Aa hoe t’Iehodà amy Tamare vinanto’e, Mitoboha ho ramavoiñe añ’anjomban-drae’o ao ampara’ te añoñ’ay t’i Selà, ie niereñere’e ty hoe: Hera ho simba ka re manahake i zoke’ey. Aa le nimb’eo t’i Tamare nimo­neñe añ’anjomban-drae’e añe. ");
INSERT INTO tdx_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Ie roñoñe añe, le nihomake ka ty vali’ Iehodà, anak’ ampela’ i Soae; aa ie nanintsiñe t’Iehodà, le nionjoñe mb’e Timnà mb’amo mpañitsi-bolon’ añondri’eo mb’eo rekets’ i Hirà nte-Adolame rañe’ey. ");
INSERT INTO tdx_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Le nitalilieñ’ amy Tamare ty hoe, Inao, mionjomb’e Timnà ty rae’o hañitsike o añondri’eo. ");
INSERT INTO tdx_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Aa le nafaha’e o lamban-dramavoi’eo, naho nanakon-daharañe an-damba marerarera, naho nifolonkoñe, vaho nitobok’ an-dalam-bei’ i Enaime, amy lala-mb’e Timnày. Toe niisa’e fa ajalahy t’i Selà f’ie tsy nampañengaeñe aze ho vali’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Tendrek’ aze t’Iehodà, le natao’e ho tsimirirañe amy t’ie nisaron-doha. ");
INSERT INTO tdx_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nivike mb’ama’e añ’olo’ i lalañe mb’eo re, nanao ty hoe, Mimetea hiolorako, fe ninofi’e t’ie vinanto ampela’e. Hoe re, Ino ty anangea’o ahy, hiharoa’o? ");
INSERT INTO tdx_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Hoe ty natoi’e, Hampisangitrifeko vi’e boak’ amy lia-raikey. Le hoe re, Tsy ho mea’o tsoake hey hao ampara’ te hahitri’o? ");
INSERT INTO tdx_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Hoe re, Tsoake manao akore ty hatoloko azo? Natoi’e ty hoe, O bangem-pitombo’oo naho i tali’oy vaho o kobaiñe am-pità’oo. Aa le natolo’e aze, naho niolots’ ama’e; vaho nampiareñe’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Niongake re, nienga; le nafaha’e i marerareray, vaho naombe’e indraike o lamban-dramavoi’eo. ");
INSERT INTO tdx_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Nampihitrife’ Iehodà am-pità’ i nte-Ado­lame rañe’ey ty vi’e, hañavake i tsoak’ an-taña’ i rakembaiy, f’ie tsy nirendreke. ");
INSERT INTO tdx_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Aa le nañontanea’e ondaty amy toetseio ty hoe, Aia i tsimiriran-kazomanga te Enaime tañ’ olon-dalañey? le hoe iereo, Tsy aman-tsimiriran-kazomanga ty atoy. ");
INSERT INTO tdx_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Aa le nibalike mb’ am’ Iehodà añe re nita­lily ty hoe: Tsy nirendreko, vaho nanao ty hoe amako ondaty an-drova ao, Tsy aman-tsimiriran-kazomanga ty atoy. ");
INSERT INTO tdx_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Hoe ty natoi’ Iehodà, Angao rambese’e ho ama’e i raha rezay tsy mone hiankahafañe; hehe te nampihitrifeko mb’ama’e ty vi’e f’ie tsy nioni’o. ");
INSERT INTO tdx_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ie añe ty telo volañe, le natalily am’ Iehodà ty hoe, Nañarapilo­ t’i Tamare vinanto’oy, ie mivesa­tse ty amy hatsimirira’ey. Le hoe t’Iehodà, Akaro re ho forototoeñe. ");
INSERT INTO tdx_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Ie nakareñe, le nañitrifa’e saontsy i rafoza’ey, ami’ty hoe, Ty tompo’ o raha rezao ro nampive­satse ahiko. Natovo’e ty hoe, Ehe hotsohotso hey, ia ty tompo’ o bange-pitombokeo, o talio, vaho o kobaiñeo? ");
INSERT INTO tdx_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Niantofa’ Iehodà i raha rey vaho nanao ty hoe, Mahity te amako re amy te tsy natoloko aze i Selà anakoy. Fe tsy niolora’e ka. ");
INSERT INTO tdx_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tondroke amy fisamaha’e te inay, hambañe ty an-kovi’e ao. ");
INSERT INTO tdx_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Aa ie nitsongo, nakare’ ty raike ty taña’e vaho finehe’ i mpanahay fole mena i taña­ñey le nanao ty hoe, Itoy ty niakatse valoha’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Aa ie nanintoñe i taña’ey, le hehe te nipotitse eo ty zai’e, vaho hoe re, Akore ty niboroboñafa’o? ho ama’o o jebañe zao. Aa le natao ty hoe ­Perètse ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Niboake nandimbe aze i rahalahi’ey ninday i fole menay an-taña’ey, le natao Zeràke ty añara’e. ");
INSERT INTO tdx_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ie amy zao, fa nendeseñe nizotso mb’e Mitsraime añe t’Iosefe, vaho vinili’ i Potifare nte-Mitsraime, roandria’ i Parò, talè o mpigaritseo, amo nte-Iesmaèle ninday aze nizotso mb’eoo. ");
INSERT INTO tdx_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Nindre am’ Iosefe t’Iehovà, le nirao­rao indatiy, ie nimoneñe añ’ anjom­ban-tompo’e nte-Mitsraime ao. ");
INSERT INTO tdx_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Ie nioni’ i tompo’ey te nitahy aze t’i Iehovà naho nampihenefe’ Iehovà ze hene nanoen-taña’e, ");
INSERT INTO tdx_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","le nisoheñe am-pihaino’e t’Iosefe amy fitoroña’e naho nanoe’e mpamandroñe i anjomba’ey vaho hene napo’e an-taña’e ao ze fanaña’e. ");
INSERT INTO tdx_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Mifototse amy nampifeheañe aze i anjomba’ey naho ze hene vara’ey, le nitahie’ Iehovà ty anjom­ba’ i nte-Mitsraimey ty am’ Iosefe. Le tamo fanaña’e iabio naho añ’anjomba ao vaho an-tetek’ ey ty hanintsi’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Aa le nado’e an-taña’ Iosefey ze hanaña’e iaby, le tsy eo ty nidarè’e naho tsy ty mahakama nikamae’e avao. Nimontsotsòre naho naram-bin­­tañe t’Iosefe. ");
INSERT INTO tdx_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Aa ie roñoñe añe, nikiroke Iosefe ty vali’ i tompo’ey vaho nanoa’e ty hoe, Miharoa tihy amako. ");
INSERT INTO tdx_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","F’ie nifoneñe, naho nanao ty hoe amy vali’ i tompo’eiy, Inao! kanao etoan-draho, tsy añ’ an­jomba’e ao ty idarea’ i tompokoy, vaho napo’e an-tañako ze hene hanaña’e. ");
INSERT INTO tdx_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Tsy aman-joke iraho añ’ anjomba atoy, vaho tsy eo ty nazi’e amako naho tsy ihe, kanao vali’e. Aa le akore ty hanoako o halò-tsereke zao, hampanan-kakeo ahy aman’ Añahare? ");
INSERT INTO tdx_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Aa ndra t’ie nañedre Iosefe boak’ andro, tsy nihaoñe’e, tsy niolora’e, tsy nindreza’e. ");
INSERT INTO tdx_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Aa teo te indraike, ie nizilik’ añ’ anjomba ao hitoloñe, naho tsy ama’ ondaty i anjombay ");
INSERT INTO tdx_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","le vinontiti’ i rakembay i saro’ey, nanao ama’e ty hoe, Miolora amako! F’ie nado’e am-pità’e i saro’ ey vaho nipoliotse mb’alafe’e ao. ");
INSERT INTO tdx_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ie nanjo’ i saro’ey an-taña’e amy nipo­litira’e mb’alafe’aoy ");
INSERT INTO tdx_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","le kinaikai’e o mpiañ’ anjomba’eo vaho nanoa’e ty hoe, Hehe, ninday nte-Evre aman-tika atoy i valikoy hañonjitse an-tika. Nimoak’ amako ao re hamahotse ahiko, le nikaike iraho; ");
INSERT INTO tdx_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ie tsinano’e i koiakoy, le nado’e amako i saro’ey vaho nibotitsike mb’alafe ao. ");
INSERT INTO tdx_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Nahaja’e ama’e ao i saro’ey ampara’ te nimpoly i vali’ey, ");
INSERT INTO tdx_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","le nindrai’e i talili’ey, ami’ty hoe, Nizilik’ amako ao hanìtse ahiko i ondevo nte-Evre nendese’o ama’ay atoiy; ");
INSERT INTO tdx_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","fe nampipoña-peo iraho le nikoiake, naho napo’e amako i saro’ey vaho nibioñe alafe ao. ");
INSERT INTO tdx_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ie jinanji’ i tompo’ey ty enta’ i vali’ey nanao ty hoe: Zao ty nanoa’ i mpitoro’oy ahiko; le niforoforo ty haviñera’e, ");
INSERT INTO tdx_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","naho rinambe’ i tompo’ Iosefey re vaho najo’e am-porozò ao, an-toem-pijoñam-pirohim-panjaka ao; aa le tam-balabey ao re, ");
INSERT INTO tdx_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","fe nindre am’ Iosefe t’Iehovà vaho niferenaiña’e; nisohe’e añatrefa’ ty mpifehe’ i kijam-pigari­tañey. ");
INSERT INTO tdx_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Aa le napo’ i mpifehey am-pità’ Iosefe ze hene mpirohy am-balabey ao, le ndra inoñ’ ino ty nanoeñe ao, ie ty nitoloñe. ");
INSERT INTO tdx_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Tsy nidarè’ i mpi­gari-beiy ze nado’e am-pità’ Iosefe, amy te nindreza’ Iehovà; vaho nampibodobodoe’ Iehovà ze hene nanoe’e. ");
INSERT INTO tdx_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Ie roñoñe añe, le nandilatse amy tale’ey, amy mpanjaka’ i Mitsraimey ty mpanjotso fitovy naho ty mpanoña’ i mpanjaka’ i Mitsarimeiy. ");
INSERT INTO tdx_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Nibo­sek’ amy mpitoro’e roe rey t’i Parò, toe amy beim-panjotso fitoviy naho amy beim-panoñakey, ");
INSERT INTO tdx_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","le najo’e am-porozò añ’ anjomba’ i mpifehem-pigaritsey amy vala­bey nandrohizañe Iosefey. ");
INSERT INTO tdx_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Nampifeheze’ i mpifehey amy Iosefe iereo vaho niatrahe’e, ie nitam­batse andro maro am-pandrohizañe ao. ");
INSERT INTO tdx_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Teo te nañinofy i mpanjotso fitoviy naho i mpanoñam-panjaka’ i Mitsarimey, i sindre nidoñe am-po’ valabey rey, ie roe—sambe nañinofy amy haleñey, songa aman-dika’e i nofi’ey. ");
INSERT INTO tdx_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Niheo mb’am’iereo mb’eo t’Iosefe te maraindray hisary le naheo’e te nimonjetse. ");
INSERT INTO tdx_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Aa le nañontanea’e i mpitoro’ i Parò nitrao-pirohy ama’e am-po’ ty anjomba’ i talè’ey rey, Ino ty mampihoho­kòhoke ty lahara’ areo henaneo? ");
INSERT INTO tdx_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Aa hoe ty asa’ iareo tama’e, Songa nañinofy, vaho tsy eo ty mahavaky aze. Le hoe t’Iosefe am’ iereo, Tsy an’ Andrianañahare hao ty vaki-nofy? Ehe, atalilio ahy. ");
INSERT INTO tdx_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Aa le natalili’ i beim-panjotso fitoviy am’ Iosefe ty nofi’e, ami’ty hoe, Amy nofikoy ao: Inao! tañatrefako ty vahe, ");
INSERT INTO tdx_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","telo ty tsampañe amy vahey; le hoe te nibotiboty naho nandriake o voñe’eo naho nampiboake valòboke matoe o nivorovoroo, ");
INSERT INTO tdx_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","vaho an-tañako ty fitovi’ i Parò; aa le rinambeko o valobokeo naho pininepineko am-pitovi’ i Parò ao vaho nazotsoko am-pità’ i Parò i fitoviy. ");
INSERT INTO tdx_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Le hoe t’Iosefe ama’e, Intoy ty vaki’e, i tsempa’e telo rey ro telo andro, ");
INSERT INTO tdx_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ie modo ty telo andro, le hampiandrà’ i Parò ty añambone’o naho hampolie’e amy fitoloña’oy, vaho hazotso’o am-pità’ i Parò ty fitovi’e, manahake i lili’o taolo ihe ni-mpanjotso fitovy ama’e. ");
INSERT INTO tdx_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ehe tiahio iraho t’ie manintsiñe; tretrezo vaho misaontsia amy Parò ty hañakarañe ahy ami’ ty valabey toañe. ");
INSERT INTO tdx_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Fa toe tinavañe an-tane’ nte-Evre añe iraho; le ndra atoa, tsy nanao ze ho nampijoñe ahiko am-porozò atoa. ");
INSERT INTO tdx_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ie nioni’ i beim-panoñakey te nisoa i vaki-nofiy, le hoe re am’ Iosefe, Ama’ ­nofy ka iraho, naho nahatrea tsikelo telo an-dohako eo, ");
INSERT INTO tdx_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","amo sikelo amboneo ty karaza-mahakama maro natoñake ho a i Parò fe tsinimo’ o voroñeo o an-tsikelo an-dohakoo. ");
INSERT INTO tdx_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Hoe ty natoi’ Iosefe, Intoy ty vaki’e: telo andro i tsikelo telo rey, ");
INSERT INTO tdx_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","añate’ ty telo andro le hampionjone’ i Parò ama’o ty añambone’o vaho haradorado’ i Parò an-katae mija­doñe ey vaho ho ­tsimohe’ o voroñeo ama’o ty nofo’o. ");
INSERT INTO tdx_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ie amy andro fahateloy, tondroke ty andro fitiahiam-pisamahañe i Paròy, le nanao sabadidake ho a o mpitoro’e iabio t’i Parò vaho naonjo’e amo mpitoro’eo ty añambone’ i beim­-panjotso fitoviy naho i beim-panoñakey. ");
INSERT INTO tdx_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Nampoli’e amy maha beim-panjotso fitovi’ey i mpanjotso fitoviy, vaho nazotso’e am-pità’ i Parò ao i fitoviy; ");
INSERT INTO tdx_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","le narado­rado’e i beim-panoñakey, ty amy vinaki’ Iosefe am’ iereoy. ");
INSERT INTO tdx_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Fe tsy nahatiahy aze i beim-panjotso fitoviy, toe nihaliño’e. ");
INSERT INTO tdx_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Ie peake ty taoñe roe, le nañi­nofy t’i Parò, inao! ie nijohañe marine i saka Nailey, ");
INSERT INTO tdx_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","le inge nitroatse amy Nailey ty añombe rene’e fito mendo naho niogoògo vaho nihinañe amo vondroñeo. ");
INSERT INTO tdx_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ni­troatse nanonjohy irezay ty tamanañe fito niriverive naho boroka nijagaro­doñe marine i fito ila’e añ’olo’ i Nailey rey. ");
INSERT INTO tdx_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nabotse’ i añombe rene’e fito molonko naho boroka rey i añombe rene’e fito mendo naho vondrake rey, le nivañoñe t’i Parò. ");
INSERT INTO tdx_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Nirotse indraike re nañinofy fañindroe’e: Hehe te sambe aman-taho’e raike ty voto tsako fito vañoñe toe daoza’e. ");
INSERT INTO tdx_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Inge ka ty voto-tsako lolondo’e fito, manifitse, finorototo’ ty tiok’ atiñana nitiry afara. ");
INSERT INTO tdx_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Nagodra’ i voto manifitse rey i voto fito daoza’e vokatse rey. Nivañoñe amy zao t’i Parò le nizoe’e te nofy. ");
INSERT INTO tdx_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ie nimaraiñe le niembetse ty arofo’e; aa le nirahe’e ty hikoike ze fonga tsimaito’ i Mitsraime naho ze hene mahihitse ama’e ao. Natalili’ i Parò ama’e o nofi’eo fe leo raike tsy nahavaky irezay amy Parò. ");
INSERT INTO tdx_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Aa le hoe ty asa’ i beim-panjotso fitoviy amy Parò, Nampitiahie’ ty andro toy ahiko o tahikoo. ");
INSERT INTO tdx_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Teo te niviñera’ i Parò o mpitoro’eo vaho sindre najo’e am-balabey añ’anjomba’ i beim-pigaritsey, izaho naho i beim-panoñakey. ");
INSERT INTO tdx_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Songa nañinofy amy haleñey, ie naho izaho, sindre aman-dika’e i ninofise’ey. ");
INSERT INTO tdx_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Nitrao­k’ ama’ay ty ajalahy nte-Evre, mpitoro’ i beim-pigaritsey. Natalili’ay ama’e, le nadika’e ama’ay o nofi’aio, sambe nadika’e ama’e i ninofise’ey. ");
INSERT INTO tdx_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ie amy zay, i nandika’e ama’aiy ty nefetsake: nahereñe amy tolon-drahakoy iraho vaho nanoan-tsingere mañaty i mpanoñakey. ");
INSERT INTO tdx_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Aa le nampañitrife’ i Parò t’Iosefe, le navota’ iareo masìka am-balabey ao; nihitsike re naho nañova saroñe vaho niheo mb’amy Parò mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Aa hoe t’i Parò am’ Iosefe, Nañinofy iraho, vaho tsy eo ty mahafandika aze. Fe tsinanoko ty ama’o te ihe ty mahavaky nofy naho maha-dika aze. ");
INSERT INTO tdx_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tinoi’ Iosefe t’i Parò ami’ty hoe, Tsy amako fa i Andrianañahare ty hanoiñe i Parò an-kanintsiñe. ");
INSERT INTO tdx_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Aa hoe t’i Parò am’ Iosefe, Ie nijohañe añ’ olo’ i Nailey amy nofikoy le ");
INSERT INTO tdx_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","naheoko te niakatse i Nailey ty añombe rene’e fito mendo naho vondrake nihinañe amo vondroñeo. ");
INSERT INTO tdx_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Inge amy zao te nitroatse boak’ ao nanonjohy iareo ty añombe fito raty, loho molonko, naho boròka. Mbe liako tsy nahatrea i haraty zay an-tane Mitsraime atoy. ");
INSERT INTO tdx_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nagodra’ i añombe rene’e molonko naho boroka rey i añombe rene’e vondrake rey, ");
INSERT INTO tdx_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","fe ndra t’ie nampibotseke tsy ho naharendre’ ondaty te nahabeake kanao mbe nihambañe amy teoy ty harati’ iereo. Le nitsekake iraho. ");
INSERT INTO tdx_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ie amy nofikoy le mbore nahatrea voto tsako fito vañoñe naho soa, sambe niboak’ ami’ty taho’e raike. ");
INSERT INTO tdx_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Indrok’ amy zao te niboake manonjohy iereo ty voto-tsako fito jiba, kifo’e, finorototo’ ty tiok’ atiñanañe, ");
INSERT INTO tdx_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","le nabotse’ i voto beikolopoke rey i voto fito soa rey. Aa ie nataliliko amo ambiasao, leo raike tsy nahabejañ’aze amako. ");
INSERT INTO tdx_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Aa hoe t’Iosefe amy Parò, Raike ty nofi’ i Parò; fa nabentan’ ­Añahare amy Parò ty hanoe’e aniany. ");
INSERT INTO tdx_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","I añombe fito soa rey ro fito taoñe; vaho fito taoñe ka i voto tsako fito soa rey; hambañe i nofy rey. ");
INSERT INTO tdx_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","I añombe fito boroka naho molònko rey ro fito taoñe, manahake izay i kifo’e fito jinoi’ i tiok’ atiñanañey rey. San-tsalikoañe fito taoñe izay. ");
INSERT INTO tdx_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Ie i vinolako amy Paròy, te nabentan’ Aña­hare amy Parò i hanoe’ey. ");
INSERT INTO tdx_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Inao! handrambañe an-tane Mitsraime atoy fito taoñe ty san-kavokaram-bey. ");
INSERT INTO tdx_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Hanonjohy izay te hitroatse ty san-kasalikoañe fito taoñe; le fonga ho haliño an-tane Mitsraime atoy i havokarañey; vaho habotse’ ty san-kerè i taney. ");
INSERT INTO tdx_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Tsy ho tiahy an-tane atoy ka i havokarañey amy hasalikoañe hanonjohy azey ami’ty hamafe’ i haoreañey. ");
INSERT INTO tdx_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Aa kanao nifañin-droe’e i nofi’ i Paròy le fa natsaton’ Añahare i rahay vaho antitotse ty andro hametsahan’Añahare aze. ");
INSERT INTO tdx_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Aa soa re te ho joboñe’ i Parò t’indaty mahatsikarake naho mahihitse hampifehea’e ty tane Mitsraime, ");
INSERT INTO tdx_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","vaho hamototse higene mpisary amy taney t’i Parò handrambe ty faha-lime’ i taney amy fito taoñe vokatse rey. ");
INSERT INTO tdx_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Le hatonto’ iareo ze hene mahakama amy taon-joba hitotsake rey, naho hahaja ambanem-pità’ i Parò i tsakoy hañajàñe mahakama amo rovao. ");
INSERT INTO tdx_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ahaja ho a i taney i mahakamay, ho amy taon-kerè fito hifetsak’ an-tane Mitsraime atoy rey tsy haitoa’ ty san-kasalikoañe ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Ni-no’ i Parò naho ze hene mpi­toro’e i saontsy zay. ");
INSERT INTO tdx_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Le hoe t’i Parò amo mpitoro’eo, Hahaoniñe ondaty mañirin­kiriñe itoy hao tika—ie aman’ Arofon’ Añahare? ");
INSERT INTO tdx_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Aa hoe t’i Parò am’Iosefe, Kanao nabentan’ Añahare ama’o i he’e zay, tsy eo ty mahatsikarake naho mahihitse te ama’o. ");
INSERT INTO tdx_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Feheo ty trañoko, ihe ‘nio, vaho ty falie’o ro hampitsaoke ondatiko iabio; i fiambesam-panjakañey avao ty mahabey ahy te ama’o. ");
INSERT INTO tdx_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Le hoe t’i Parò am’Iosefe, Hehe, fonga nampifeheko azo ty tane Mitsraime; ");
INSERT INTO tdx_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","le nafaha’ i Parò am-pità’e i bange-fitombo’ey naho naombe’e am-pità’ Iosefe naho sinaro’e siki-leny naho niravahe’e tohi-rozañe volamena ty fititia’e ");
INSERT INTO tdx_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","vaho nampijoñe’e amy sareten-tsorotà’ey le nikoikoiheñe aolo’e mb’eo ty hoe: Mitongalefa! Le nampandilie’e iaby i tane Mitsraimey. ");
INSERT INTO tdx_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Nanao ty hoe am’ Iosefe t’i Parò, Izaho o Parò zao, fe naho tsy ihe, le tsy eo ty hañonjo fitàñe ndra fandia an-tane Mitsraime atoy iaby. ");
INSERT INTO tdx_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Nomei’ i Parò ty tahina Tsofnate-paneàke t’Iosefe le natolots’ aze ho vali’e t’i Asenate, ana’ i Potifera, mpisoro’ i One; vaho nionjom-beo nanitsike i tane Mitsraimey t’Iosefe. ");
INSERT INTO tdx_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ni-telopolo taoñe t’Iosefe te nijo­hañe aolo’ i Parò mpanjaka’ i Mits­ra­ime. Niavotse añ’atrefa’ i Parò t’Iosefe vaho nitsitsihe’e ty tane Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Namokatse am-botri’e i taney amy taoñe fito vañoñe rey. ");
INSERT INTO tdx_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Aa le hene natonto’e ze mahakama an-tane Mitsraime ao amy fito taoñe rey vaho nahaja’e amo rovao o mahakamao; songa rova ro nañajañe ty mahakama boak’ amo teteke mañohok’ azeo. ");
INSERT INTO tdx_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Nañaja tsako mira amo fasen-driakeo t’Iosefe, tsifotofoto kanao tsy nahafañiak’ aze, amy te loho bey tsy nilefe volily. ");
INSERT INTO tdx_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Nahatoly ana-dahy roe t’Iosefe aolo’ o taom-polakeo, toe nisamaha’ i Asenate, ana’ i Potifera mpisoro’ i One. ");
INSERT INTO tdx_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Natao’ Iosefe Menasè ty añara’ i tañoloñoloña’ey, fa hoe re, Nampandikofen’ Añahare ahy i hene fisotriakoy naho ty anjomban-draeko iaby. ");
INSERT INTO tdx_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Natao’e Efraime ty faharoe, amy te: Nampiraorao ahy an-tane nampiore ahy ao t’i Andrianañahare. ");
INSERT INTO tdx_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Nimodo amy zao i taoñe fito vokatse an-tane Mitsraimey rey; ");
INSERT INTO tdx_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","le niorotse nitsatoke i fito taon-tsan-kerè rey ty amy saontsi’ Iosefey. Hene nikerè ze tane añe fe hene ama’ mahakama o an-tane Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ie fonga nisalikoeñe ty antane Mitsraime, le nitoreo maha­kama amy Parò ondatio. Aa hoe t’i Parò amo nte-Mitsraime iabio, Akia mb’am’ Iosefe mb’eo le ze taroñe’e ama’ areo ty hanoe’ areo. ");
INSERT INTO tdx_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Aa naho nandrambañe ty tane toy i san-kerèy, le sinoka’ Iosefe o riha iabio vaho naleta’e amo nte-Mitsraimeo, amy te nimafe ty kerè an-tane Mitsraime ao. ");
INSERT INTO tdx_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Niheo am’Iosefe e Mitsraime ao iaby ty tane toy hivily tsako, amy te nanitsike ty tane bey toy ty hamafe’ i hasalikoañey. ");
INSERT INTO tdx_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Naho nioni’ Iakòbe te e Mitsraime añe ty mahakama, le hoe t’Iakòbe amo ana’eo, Ino ty ifangarefa’ areo? ");
INSERT INTO tdx_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Inao, hoe re, tsinanoko te aman-tsako ty Mits­raime; akia mizo­tsoa mb’eo vaho iviliaño ho an-tika, hiveloman-tika fa tsy hivetrake. ");
INSERT INTO tdx_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Aa le nizotso mb’e Mitsraime mb’eo ty rahalahi’ Iosefe folo hikalo mahakama añe. ");
INSERT INTO tdx_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Fe tsy nampindreze’ Iakòbe amo zoke’eo t’i Beniamine zai’ Iosefe fa hoe re, ke ho zoem-boiñe. ");
INSERT INTO tdx_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Aa le nindre amo nañavelo mb’eo hikaloo, o ana’Israeleo, amy te an-tane’ Kanàne ao ka i san-kèrey. ");
INSERT INTO tdx_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Toe nimpifehe i taney t’Iosefe, mpandetak’ amy ze fonga ondati’ i taney. Le nimb’eo o rahalahi’ Iose­feo nibaboke an-tane aolo’e eo. ");
INSERT INTO tdx_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Aa naho nahaisake o rahalahi’eo t’Iosefe, le nifohi’e, fe nimintse ho ambahiny am’iereo, vaho nendakendaha’e, Boak’aia v’inahareoo? hoe re. Hoe iereo, Hirik’an-tane Kanàne añe hikalo mahakama. ");
INSERT INTO tdx_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Toe nirendre’ Iosefe o rahalahi’eo, f’ie tsy naharendreke aze. ");
INSERT INTO tdx_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Nitiahi’ Iosefe o ninofise’e iareoo, le hoe re am’ iereo, Mpifilo nahareo, ­nivotrak’ atoy hahaisake ty fihaloa’ o taneo! ");
INSERT INTO tdx_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Le hoe iereo tama’e, Aiy, ry talèko, ty hikalo mahakama ty nitsatoha’ o mpitoro’oo atoy. ");
INSERT INTO tdx_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Songa ana’ t’indaty raike zahay; ondaty vantañe, fa tsy mpisary tane o mpitoro’oo. ");
INSERT INTO tdx_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Hoe re am’ iereo: Aiy, toe nimb’atoy nahareo handrendreke ty fiboridaña’ o taneo! ");
INSERT INTO tdx_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Hoe iereo, Mpitoro’o zahay, roahalahy folo-ro’ amby, ana’ t’indaty e Kanàne ao, fe an-drae’ay añe ty tsitso’e vaho tsy eo ty raike. ");
INSERT INTO tdx_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Aa hoe t’Iosefe am’ iereo: Ie i vinolako ama’areoy, toe mpisary nahareo. ");
INSERT INTO tdx_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Inao t’ie tsoheko: kanao veloñe t’i Parò, tsy hiavotse atoy nahareo naho tsy pok’ atoy heik’ i tsitso’areoy! ");
INSERT INTO tdx_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ampihitrifo ami’ty raik’ ama’ areo i zai’ areoy le hambenañe an-drohy ao nahareo, hitsohañe ty enta’ areo ke ama’areo ty hato, fa naho tsie, kanao veloñe t’i Parò, le mpipiapia. ");
INSERT INTO tdx_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Aa le fonga natonto’e am-balabey ao telo andro. ");
INSERT INTO tdx_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ie amy andro fahateloy, le ty hoe ty nanoa’ Iosefe, Ano zao soa te ho veloñe, amy te mpañeveñ’ aman’ Añahare iraho: ");
INSERT INTO tdx_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","aa naho ondaty vañoñe nahareo, angao an-traño nandrohizañe anahareo atoy ty rahalahi’ areo raike. Le akia, añendeso mahakama ty amy hasalikoañey o keleia’ areoo, ");
INSERT INTO tdx_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","vaho endeso mb’etoa i tsitso’ areoy, hañato o enta’ areoo, le tsy hikoromake. Aa le nanoe’ iereo. ");
INSERT INTO tdx_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Hoe ty vesoveso’ iareo, Inao, toly aman-tika ty nanoen-tika amy raha­lahin-tikañey, nionin-tika i halovilovim-piai’ey, ie nitoreo aman-tikañe, ie tsy nete nitsanoñe. Toly ndra hehe ty fangovitañe mife­tsak’ aman-tikañe. ");
INSERT INTO tdx_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Natoi’ i Reòbene ty hoe, Tsy vinolako hao te tsy hanoan-draty i ajalahiy? F’ie tsy nañaoñe vaho hehe te paiaeñe i lio’ey. ");
INSERT INTO tdx_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Namoea’ iareo te nirendre’ Iosefe iaby i hoe zay fa ampañivoa’ iareo ty mpandika. ");
INSERT INTO tdx_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Nivìk’ am’iareo hey re nirovetse, naho nibalike le nisaontsy, naho jinobo’e am’ iereo t’i Simone vaho rinohi’e aolom-pihaino’ iareo. ");
INSERT INTO tdx_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nandily t’Iosefe le natsafeñe tsako o goni’ iareoo naho songa nahereñe am’ondatio an-goni’e ao ty drala’e vaho nivatieñe amy liay. Nanoeñe ho a’ iareo izay. ");
INSERT INTO tdx_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Nalogologo’ iereo ambone’ o borìke’eo o mahakamao vaho nienga. ");
INSERT INTO tdx_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Aa teo ty nanokak’ i goni’ey hivaty i borìke’ey t’ie nitobe, nizoe’e i drala’ey, inge t’ie am-bava’ i goniy eo. ");
INSERT INTO tdx_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Hoe re amo rahalahi’eo, Nabalik’ amako i dralakoy, ie o an-gonikoo. Ho namoe’ay iereo fa nirevendreveñe, le nifanao ty hoe, Ino ty nanoan’ Añahare aman-tikañe? ");
INSERT INTO tdx_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Ie pok’ aman-drae’e an-tane’ Kanàne añe, le natalily ama’e ze hene nife­tsak’ am’iereo, ami’ty hoe, ");
INSERT INTO tdx_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Nañomey tsipeha anay indatiy, ty talè’ i taney nanisy anay te inao mpijekejeke amy taney. ");
INSERT INTO tdx_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Fe hoe ty natoi’ay ama’e, Ondaty mahity zahay fa tsy mpitingañe. ");
INSERT INTO tdx_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Mpirahalahy folo ro’ amby zahay, foetse raik’ aman-drae’ay; tsy eo ty raike, vaho aman-drae’e an-tane’ Kanàne añe ty tsitso’e henaneo. ");
INSERT INTO tdx_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Le hoe indatiy, i mpifehe’ i taney ama’aiy, amy hoe zao ty haharendrehako te ondaty vantañe nahareo: angao amako atoy ty raik’ amo rahalahi’ areoo, indeso mahakama ty amo hasalikoañeo o añ’anjomba’ areoo, vaho mañaveloa; ");
INSERT INTO tdx_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","fe hitrifo mb’atoy i tsitso’ areoy haharendrehako te tsy mpifilo nahareo fa ondaty vañoñe. Ie amy zay, havotsoko ama’areo i rahala­hi’oy vaho hikalo an-tane atoy nahareo. ");
INSERT INTO tdx_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ie sambe nampidoañe ty goni’e, le hehe te amy goni’ey ty kotran-drala’e. Aa naho niisa’ iereo naho i rae’ iareo o kotran-drala’ iareoo, le nangebahebake. ");
INSERT INTO tdx_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Le hoe ty nanoa’ Iakòbe rae’ iareo, Toe nampihontoha’ areo ahy o anakoo, tsy eo t’Iosefe, tsy eo t’i Simone vaho te hampisintone’ areo ka t’i Beniamine. Fonga nidoñ’ amako! ");
INSERT INTO tdx_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Aa hoe ty asa’ i Reòbene aman-drae’e, Vonò i ana-dahiko roe rey naho tsy hendeseko mimpoly ama’o atoy. Apoho an-tañako ato le izaho ty hampipoly aze ama’o. ");
INSERT INTO tdx_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Fe hoe re, Tsy hizotso mb’eo i anakoy, mate i rahalahi’ey le ie ty honka’e. Aa ie mizo voiñe amy lia handena’ areoy le hazotso’areo an-kontoke mb’ antsikeokeok’ao o volo-fotikoo. ");
INSERT INTO tdx_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Mbe nizeke mafe amy taney ty san-kerè. ");
INSERT INTO tdx_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Aa naho fa nikamae’ iereo i mahakama nendese’ iereo boake Mitsraimey, le hoe ty rae’ iareo ama’e, Akia ihereño, mikaloa mahakama tsy ampeampe ho antika. ");
INSERT INTO tdx_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Aa hoe t’Iehodà ama’e, Nañatahata anay aman-titike indatiy, ami’ty hoe, Tsy ho oni’ areo ka ty tareheko naho tsy indreza’ i zai’ areoy. ");
INSERT INTO tdx_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Aa naho ampihitrife’o hindre ama’ay ty zai’ay, le hizotso mb’eo zahay hivily mahakama ho azo; ");
INSERT INTO tdx_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","fa naho tsy haha’o handeha re, le tsy hizotso mb’eo zahay, amy nihatahata’ indatiy, ty hoe, Tsy ho isa’areo ty tareheko naho tsy ama’ areo ty zai’ areo. ");
INSERT INTO tdx_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Hoe t’Israele, Ino ty nijoia’ areo ahiko ami’ty fivola’ areo am’indatiy t’ie mbe aman-drahalahy? ");
INSERT INTO tdx_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Hoe ty natoi’ iareo, Nandohy anay ty ama’ay naho o longo’aio indatiy, nanao ty hoe, Mbe velom-bao ty Rae’ areo? Manañe ana-dahy ila’e hao? Aa kanao nañontane re, vinale’ay. Ho nihai’ay aia te ho nisaontsie’e ty hoe, Ampizotsò mb’ atoy i rahalahi’oy? ");
INSERT INTO tdx_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Le hoe t’Iehodà am’ Israele rae’e, Ampindrezo amako i ajalahiy, le hionjon-jahay, soa te ho veloñe tika fa tsy hivetrake—Ihe naho zahay vaho o keleian-tikañeo. ");
INSERT INTO tdx_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Izaho avao ty ho tsoake ho aze; hamolilie’o an-tañako. Aa naho tsy habaliko ama’o atoy, havotrako añatrefa’o, le ee ty ho amako nainai’e i hakeo zay. ");
INSERT INTO tdx_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Aa naho tsy nihenekenek’ avao tika le fa ho n’indroe nimpoly. ");
INSERT INTO tdx_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Aa le hoe ty nanoa’ Israele rae’ iareo, Naho izay, le ano zao, Añendeso amo goni’ areoo o ­vokatse soa’ ty tane toio, vaho ahitrifo amy ‘ndatiy ho ravoravo ty aoly fihosotse tsy ampeampe naho tantele kede naho fisìke naho fampafirañe naho rame naho katra vaho sakoañe. ");
INSERT INTO tdx_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Endeso an-taña’ areo in-droe’ o dralao. Tintino hibalike mb’eo an-taña’areo i drala nabalik’ amo goni’ areooy; kera nilosoreñe. ");
INSERT INTO tdx_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Endeso ka ty zai’areo le miongaha, mibaliha mb’am’ indatiy; ");
INSERT INTO tdx_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","lonike te ho tretreze’ i El-Sadai abey nahareo añatrefa’ indatiy, hamotsora’e i rahalahi’areoy naho i Beniamine. Aa naho izaho, lehe ampihontohañe le hihontoke. ");
INSERT INTO tdx_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Aa le nendese’ o lahilahio i ravoravoy naho indroe’ ty drala’e am-pità’iareo vaho i Beniamine le niongake naho nizotso mb’e Mitsraime añe vaho nijohañe añatrefa’ Iosefe eo. ");
INSERT INTO tdx_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Ie niisa’ Iosefe te am’iereo t’i Beniamine, le hoe re ami’ty mpitoro’ i anjomba’ey, andentao hare le halankaño sabadidake, fa hitrao-pikama amako ondati-­reo te tsipindemena. ");
INSERT INTO tdx_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nanoe’ indatiy i nafanto’ Iosefe ama’ey, le nampihovae’e añ’anjomba’ Iosefe ao indaty rey. ");
INSERT INTO tdx_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Nihembañe amy zao i lahilahy rey kanao nendeseñe mb’añ’anjomba’ Iosefe ao, le nanao ty hoe, Hera i dralay, i nampoly an-goni’ay am-baloha’eiy ro nampizilihañe anay, hikaboha’e raha, hiambotraha’e, naho hondevoze’e rekets’ o borìken-tikañeo. ");
INSERT INTO tdx_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Aa le niheo amy mpitoroñ’ anjomba’ Iosefey mb’eo iereo nisaontsy ama’e an-tsa­rira’ i anjombay eo, ");
INSERT INTO tdx_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","ami’ty hoe, Ry Taleko, toe nizotso mb’atoa hikalo mahakama zahay tam-baloha’ey; ");
INSERT INTO tdx_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","f’ie nandoak’ amy nitofà’aiy añe, nanokake o goni’aio le songa nanjo ty drala’e ambava’ i goni’ey t’indaty, ty drala’ay ami’ty lanja’e. Aa le nendese’ay mb’atoy an-taña’ay, ");
INSERT INTO tdx_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","mbore nandesa’ay drala fañampe’e an-tañañe hikaloa’ay maha­kama. Nofi’ay ty nampizilike i dralay an-goni’ay ao. ");
INSERT INTO tdx_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Hoe ty natoi’e, Manintsiña, ko hembañe; i Andria­nañahare’ areo naho Andrianañaharen-drae’ areoy ty nampipoke ty vara’ areo amo goni’ areoo; fa nasese amako i drala’areoy. Le na­aka’e mb’am’iereo t’i Simone. ");
INSERT INTO tdx_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Aa le nampihove’ i mpitoroñey añ’ anjom­ba’ Iosefe ao indaty rey le nan­jo­tsoa’e rano, hanasa’e fandia, vaho nifa­hana’e o borìke’eo, ");
INSERT INTO tdx_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","le nampihen­tseñe’ iereo ho amy fiavi’ Iosefe amy tsipinde-menaiy i ravoravoy, fa jinanji’ iareo te hikama ao. ");
INSERT INTO tdx_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ie nimpoly añ’anjomba’e ao t’Iosefe le nibanabanae’ iereo ama’e añ’anjomba ao o ravoravo am-pità’iareoo vaho ni­boko­boko an-tane añ’atrefa’e eo. ");
INSERT INTO tdx_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Na­ñon­­tanea’e ty hajangaña’ iareo, naho ty hoe, Jangam-bao ty rae’areo, i androanavy bey tinoño’ areoy? Mbe veloñe hao? ");
INSERT INTO tdx_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Soa avao i mpitoro’oy, ty rae’ay, mbe velon-dre. Le niondreke iereo, niambane. ");
INSERT INTO tdx_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Niandra amy zao re vaho nahaoniñe i Beniamine rahalahi’e, i anan-drene’ey, le hoe re, Rahalahy tsi­tso’ areo hao itia-hoekey? i natalili’areo amakoy? Ama’o abey anako, ty fatarihan’ Añahare! ");
INSERT INTO tdx_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Le nibioñe añe t’Iosefe ty amy hamaniña’e an-jai’e, nipay hirovetse. Nizilik’ an-traño’e ao re niharovetse. ");
INSERT INTO tdx_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Nanasa laharan-dre naho nilie-batañe vaho niakatse, le nanao ty hoe: Azotsò i mahakamay. ");
INSERT INTO tdx_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Nanjotsoa’ iareo hey re, ie raike, naho natokañe am’ iereo ka, le nanjotsoañe manokañe o nte-Mitsraime mpitrao-pikama ama’eo, amy te tsy mete miharo-fikama amo nte-Evreo o nte-Mitsraimeo fa faly e Mitsra­ime ao. ");
INSERT INTO tdx_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Le nampiambesareñe añatrefa’e, ty tañoloñoloña’e aolo ty amy zo’ey pak’an-jai’e ty amy hatsitso’ey, le nifampijilojilo an-kalatsañe o mpi­rahalahio. ");
INSERT INTO tdx_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Nanjotsoañe boak’ am-pandambaña’ Iosefe iereo, fe indime’ ty mahakama niazo’ ty raike ty nazotso amy Beniamine. Aa le nitrao-pikama naho finoñe ama’e iereo. ");
INSERT INTO tdx_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Linili’e amy zao i mpamandro’ i anjomba’eiy ami’ty hoe, Atsefo maha­kama o goni’ ondatio, ze leo’e logologoeñe, le songa apoho am-bava’ ty goni’e ao i drala’ indaty reiy; ");
INSERT INTO tdx_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","le apoho amy goni’ i Beniamine ao i fitoviko volafotiy rekets’ ty drala’ i tsako’ey. Aa le nanoe’e i sinaontsi’ Iosefey. ");
INSERT INTO tdx_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Ie nazava amy loak’ àndroy le nampionjonem-b’eo i lahilahy rey rekets’ o borìke’eo. ");
INSERT INTO tdx_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Aa ie vaho nienga i rovay, mb’e tsy nañavelo lavitse, le hoe t’Iosefe amy mpamandro’ i anjomba’eiy, Miongaha, horidaño ondatio, le ie ifanampea’o, ano ty hoe, Akore ty namalea’ areo raty ty soa? ");
INSERT INTO tdx_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tsy atoy hao ty finoma’ i talèkoy, toe i fisikilia’ey? Ie nanao hakelohañe amy nanoe’areoy. ");
INSERT INTO tdx_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ie nitra’e iereo, le tinaro’e am’iereo i entañe zay. ");
INSERT INTO tdx_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Le vinale’ iareo ty hoe: Ino ty isaontsian-talèko o entañe zao? Tsy marine’ o mpitoro’oo ty manao i tsaraeñey. ");
INSERT INTO tdx_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Heheke te nahere’ay ama’o boak’ an-tane Kanàne añe o drala nizoe’ay am-po’o goni’aio; inoñe arè ty hikizoa’ay volafoty ndra vo­la­mena añ’anjomba’ i talè’oy? ");
INSERT INTO tdx_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ie zoeñe ami’ty raik’ amo mpitoro’o retoy i raha zay le ie ty hikenkañe, vaho ho ondevo’ i talè’aiy ka zahay. ");
INSERT INTO tdx_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Hoe re, Ie izay, amy fivola’ areoy, fe ze anjoàñe i rahay ro hondevoko vaho hidada nahareo. ");
INSERT INTO tdx_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Aa le nalisa iareo songa nanjotso ty goni’e an-tane, vaho sindre nanokake i goni’ey. ");
INSERT INTO tdx_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kinodebe’e, nifototse aman-joke’e pak’an-tsitso’e; le nioniñe an-goni’ i Beniamine ao i fitoviy. ");
INSERT INTO tdx_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Songa nandria-tsaroñe amy zao, sambe nampijiny ty borìke’e indraike vaho nimpoly mb’an-drova mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Pok’ añ’anjomba’ Iosefe t’Iehodà naho o rahalahi’eo ie mbe tao, le nibaboke an-tane añatrefa’e. ");
INSERT INTO tdx_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Hoe t’Iosefe am’iereo, Ino o nanoe’ areo zao? Amoea’ areo te toe mpisikily ondaty manahak’ ahikoo? ");
INSERT INTO tdx_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Le hoe t’Iehodà, Ino ty ho volañe’ay aman-talè’ay? Ino ty ho talilie’ay? Akore ty hiveroha’ay? Fa naboan’ Añahare ty hamengoha’ o mpitoro’oo; intoy arè zahay ondevo’ ty talè’ay, Izahay mitraok’ amy nanjoàñe i fitoviy. ");
INSERT INTO tdx_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Fa hoe re, Tsy marine’ ahy ty hanao izay. I naha­isahañe i fitoviy, ie ty hondevoko; f’inahareo ka, mañaveloa am-panin­tsiñañe mb’ aman-drae’areo añe. ");
INSERT INTO tdx_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Nitotok’ aze t’Iehodà nanao ty hoe, O talèko, angao hivolañe kede an-dravembian-talèko ao ty mpitoro’o, le ehe tsy hiforoforo ty haviñera’o amo mpitoro’oo kanao mira amy Parò irehe. ");
INSERT INTO tdx_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nañontanea’ ty talè’ay o mpitoro’eo ty hoe, Aman-drae ndra rahalahy hao nahareo? ");
INSERT INTO tdx_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Le hoe zahay amy talè’aiy, Manan-drae zahay, androanavy bey, vaho ty raha­lahy tora’ i haantera’ey. Nivetrake i rahalahi’ey, le ie ty honka’e amo anan-drene’eo vaho ikokoan-drae’e. ");
INSERT INTO tdx_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Le nanoe’o ty hoe o mpitoro’oo, Ampizotsò mb’etoan-dre ho trea’ o masokoo. ");
INSERT INTO tdx_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Le hoe zahay amy talèkoy, Tsy mete mienga an-drae’e i ajalahiy, tsy mone hihomake t’i rae’e. ");
INSERT INTO tdx_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Le nanoe’o ty hoe o mpitoro’oo, Naho tsy mindre mizotso ama’ areo mb’etoa i tsi­tson-drahalahi’ areoy le tsy ho oni’ areo ka ty tareheko. ");
INSERT INTO tdx_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ie nimpoly aman-drae’ay mpitoro’oy añe vaho natalili’ay i saontsin-talèkoy, ");
INSERT INTO tdx_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","le nanao ty hoe ty rae’ay, Mibaliha, ikalò mahakama tsy ampeampe tika. ");
INSERT INTO tdx_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Aa hoe zahay, Tsy mete ty hizotsoa’ay; f’ie ama’ay i zai’aiy, le hizotso mb’eo. Fa tsy hahaoniñe ty lahara’ indatiy zahay naho tsy rekets’ama’ay i tsitso’aiy. ");
INSERT INTO tdx_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Le hoe ty rae’ay mpitoro’o ama’ay, Fohi’ areo te nahatoly ana-dahy roe ho ahiko i valikoy; ");
INSERT INTO tdx_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","nieng’ ahy ty raike, le hoe iraho, Toe nirimitem-biby, vaho tsy treako ka. ");
INSERT INTO tdx_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Aa naho endese’ areo añe boak’ amako ka itoy, vaho manjo-voiñe le hampidrodrète’ areo an-kòntoke mb’an-tsikeokeok’ ao o volo-fotikoo. ");
INSERT INTO tdx_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Aa naho himpoly mb’aman-draeko mpitoro’o mb’eo iraho tsy reketse i tsitso’ey, kanao mifandrohy ami’ty havelo’ i ajalahiy ty arofo’e, ");
INSERT INTO tdx_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","ie mahaoniñe te tsy ama’ay i ajalahiy vaho hihomake; le hampidrodrète’ o mpitoro’oo mb’an-tsikeokeok’ ao o maròy fotin-drae’ay mpitoro’oo, ");
INSERT INTO tdx_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","fa nitsoake i ajalahiy aman-drae’e o mpitoro’oo, ie nanoako ty hoe, Naho tsy hampoliko ama’o i ajalahiy—le izaho ty hivave i hakeo zay añatrefan-draeko kitro katroke. ");
INSERT INTO tdx_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ie amy zao, ehe meteo ho ondevo’ i talèko iraho hisolo i ajalahiy; vaho angao hionjomb’eo mindre amo rahalahi’eo i ajalahiy. ");
INSERT INTO tdx_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Fa aia ty himpoliako aman-draeko añe naho tsy mindre amako i ajalahiy? Irevendreveñako ty hahatrea o haloviloviañe hifetsak’ aman-draekoo. ");
INSERT INTO tdx_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Tsy naha-lie-batañe amy maro niarikoboñe azey t’Iosefe, le pinaza’e ty hoe, Ampisitaho amako ondaty iabio. Aa ie tsy ama’ ondaty le nibenta-batañe aman-drahalahi’e t’Iosefe. ");
INSERT INTO tdx_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Le akore ty fangololoiha’e kanao tsinano’ o nte-Mitsraimeo naho ty anjomba’ i Parò. ");
INSERT INTO tdx_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Hoe t’Iose­fe aman-drahalahi’e, Izaho ‘n-o Iosefeo. Mbe velom-bao ty raeko? Fa tsy nahatoiñ’ aze o rahalahi’eo ami’ty fangovita’ iareo amy fiatrefa’ey. ");
INSERT INTO tdx_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Aa hoe t’Iosefe aman-drahalahi’e, Ehe, harivò! Le niharivoa’ iareo. Hoe re, Izaho nio Iosefe rahalahi’areo, naleta’ areo mb’e Mitsraimey. ");
INSERT INTO tdx_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Aa le ko mañore ndra mañìnje vatañe ty amy nandetaha’ areo ahy atoy, amy te i Andrianañahare ty nañirak’ ahy hiaolo anahareo handrombak’ aiñe; ");
INSERT INTO tdx_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","fa nisaliko roe taoñe ty tane toy vaho mbe hanonjohy izay ty lime taoñe tsy aman’ ava tsy amam-bokatse. ");
INSERT INTO tdx_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Nirahen’ Añahare hiaoloako hañajañe tariratse ho anahareo an-tane atoy vaho hampitambeloñe anahareo an-drombake ra’elahy. ");
INSERT INTO tdx_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Aa le tsy inahareo ty nañitrik’ ahy mb’etoa fa i Andrianañahare, ie ty nanao ahy ho rae’ i Parò naho talè’ i anjomba’e iabiy vaho mpifehe i hene tane Mitsraimey. ");
INSERT INTO tdx_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Misangitrifa mb’ aman-draeko mb’eo arè vaho ano ama’e ty hoe, Hoe ty ana’o Iosefe, Nanoen’ Añahare talè’ i Mitsraime iaby iraho; mizo­tsoa mb’ amako mb’etoy le ko mihenekeneke. ");
INSERT INTO tdx_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Hitoetse marine ahy an-tane’ Gosena añe irehe, ihe naho o keleia’oo naho o anan’ ana’oo, naho o mpirai-lia’oo naho o mpirai-tro’oo vaho ze hene hanaña’o. ");
INSERT INTO tdx_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ho fahanako ey nahareo amy te mbe hitovoñe lime taoñe i hasalikoañey, tsy mone hifo­tsak’ an-kararahan-drehe naho o añ’ anjomba’oo. ");
INSERT INTO tdx_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ie amy zao, Hehe te o fihaino’ areoo naho ty mason-jaiko Beniamine ro mahaisake te ty vavako ro mivolañe ama’ areo henaneo. ");
INSERT INTO tdx_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Saon­tsio aman-draeko ty hara’ elahim-piasiañe ahiko e Mitsraime atoa, le ze hene nioni’areo. Malisà hampizotso an-draeko mb’etoy. ");
INSERT INTO tdx_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Niforokokoe’e amy zao ty hàto’ i Beniamine rahalahi’e le nangoihoy vaho nirovetse am-pititia’eo t’i Beniamine. ");
INSERT INTO tdx_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Hene norofa’e o rahalahi’eo naho niroveta’e; vaho nahafisaontsy ama’e amy zao o rahalahi’eo. ");
INSERT INTO tdx_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ie jinanjiñe añ’anjomba’ i Parò ao ty talily te fa totsake o rahalahi’ Iosefeo, le niehake t’i Parò naho o mpitoro’eo. ");
INSERT INTO tdx_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Le hoe t’i Parò am’ Iosefe, Saontsio ty hoe o rahalahi’oo: Ano zao: ampilogologò o bibi’ areoo vaho miziliha an-tàne Kanàne. ");
INSERT INTO tdx_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Indeso mb’amako mb’etoa ty rae’ areo naho o keleia’ areoo naho hatoloko ty tane soa e Mitsraime atoa vaho hikama’ areo ty havondra’ o taneo. ");
INSERT INTO tdx_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Amantohañe amy zao nahareo: le ano zao: Añandeso sarete boak’ an-tane Mitsraime atoy o keleia’areoo naho o vali’areoo naho rambeso ty rae’ areo vaho mb’etoa. ");
INSERT INTO tdx_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ko itsakorea’ areo o fanaña’ areoo, fa anahareo ty soa amy ze hene tane e Mitsraime ao. ");
INSERT INTO tdx_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Aa le nanoe’ o ana’ Israeleo. Nitolora’ Iosefe sarete ty amy saontsi’ i Paròy vaho nivatia’e ho amy liay. ");
INSERT INTO tdx_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Songa tinolo’e sikiñe vao t’indaty; fe tinolo’e bogady volafoty telon-jato naho sikim-bao lime t’i Beniamine. ");
INSERT INTO tdx_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Nampihitrife’e mb’ aman-drae’e mb’eo o retoañe: borìke folo nilogologo kilan­kañe soa’ i Mitsraime, borìke-vave’e folo ninday tsako, mofo vaho fivatiañe ho an-drae’e amy fañaveloa’ey. ");
INSERT INTO tdx_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Le nampi­onjone’e mb’eo o rahalahi’eo, naho nañavelo, vaho hoe re tam’iareo, Ko mifandietse an-dalañe mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Aa le nienga i Mitsraime iereo vaho nitotsak’ aman-drae’e an-tane’ Kanàne añe. ");
INSERT INTO tdx_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Le hoe iereo tama’e, Mbe veloñe t’Iosefe. Hene fehe’e ty tane Mitsraime. Nitoirañe ty arofo’e, le tsy niantofa’e. ");
INSERT INTO tdx_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Fe natalily ama’e ty hene enta’ Iosefe nisaontsia’e, naho ie nahaisake o sarete nahitri’ Iosefe hinday azeo, le nisotrake ty arofo’ Iakòbe rae’ iareo. ");
INSERT INTO tdx_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Hoe t’Israele, Heneke! Kanao mbe veloñe t’Iosefe anako, le tsy mete tsy handeha mb’eo iraho hahatreavako aze aolo’ ty fivetrahako. ");
INSERT INTO tdx_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Ie nionjoñe amy fañaveloa’ey t’Israele ninday o fanaña’e iabio naho nandoake e Beersevà ao, le nañenga soroñe aman’ Añahare’ Ietsàke rae’e. ");
INSERT INTO tdx_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Nitsara am’ Israele añ’ aroñaron-kaleñe t’i Andrianañahare nanao ty hoe, O Iakòbe, Iakòbe. Intoy iraho, hoe re. ");
INSERT INTO tdx_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Le hoe Re, Izaho o Andrianañahareo, t’i Andrianañaharen-drae’o; ko hembañe ami’ty fañaveloa’o mb’e Mitsraime mb’eo amy t’ie hanoeko foko ra’elahy te añe. ");
INSERT INTO tdx_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Hindre lia ama’o mb’e Mitsraime mb’eo iraho vaho toe hampoliko indraike, le ty tañan’ Ana’o, Iosefe, ro hampirompo o fihaino’oo. ");
INSERT INTO tdx_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Aa le nienga i Beersevà t’Iakòbe, vaho nendese’ o ana-dahi’ Israeleo t’i rae’e Iakòbe rekets’ o keleia’eo naho o vali’eo amo sarete nahitri’ i Parò hindesañe azeo. ");
INSERT INTO tdx_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Nendese’ iereo o hare’ iareoo naho ty vara’iareo, o niazo’ iareo an-tane Kanàneo, vaho nandoak’e Mitsraime ao: t’Iakòbe rekets’ i hasavereña’e iabiy; ");
INSERT INTO tdx_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","nendese’e mb’e Mitsraime mb’eo ze hene ana-dahi’e naho anan’ana’e lahy naho anak’ampela’e naho anak’ampelan’ ana-dahi’e vaho o tarira’e iabio. ");
INSERT INTO tdx_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Aa le zao o tahinan’ ana’ Israele nandoak’e Mitsraimeo: Iakòbe naho o ana-dahi’eo. I Reòbene tañoloñoloña’ Iakòbe, ");
INSERT INTO tdx_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","le o ana’ i Reòbeneo: i Kanòke naho i Palò naho i Ketsrone vaho i Karmý. ");
INSERT INTO tdx_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","O ana’ i Simoneo: Iemoèle naho Iamìne naho i Ohade naho Iakìne naho i Tsòkare vaho i Saòle ana’ty rakemba nte-Kanàne. ");
INSERT INTO tdx_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","O ana’ i Levio: i Gersòne, i Kehàte naho i Merarý. ");
INSERT INTO tdx_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","O ana’ Iehodào: I Ere naho i Onane naho i Selà naho i Perètse vaho i Zèrake (fe nivetrak’ an-tane Kanàne añe t’i Ere naho i Onane;) vaho ty ana’ i Perètse: i Ketsrone naho i Kamòle. ");
INSERT INTO tdx_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","O ana’ Isakareo: i Tolà, naho i Povà, naho Iòbe vaho i Simròne. ");
INSERT INTO tdx_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","O ana’ i Zebolone: i Sèrede, naho i Elòne vaho Iak’ leèle ");
INSERT INTO tdx_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","(ana’ i Leae iaby irezay, o nasama’e ho a Iakòbe e Padan’ arameo rekets’ i Dinae anak’ ampela’ey, le ni-telo-polo telo amby ty ana-dahi’e miharo anak’ ampela.) ");
INSERT INTO tdx_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","O ana’ i Gadeo: i Tsifiòne, naho i Kagý, i Soný, naho i Etsbòne, i Erý, naho i Arodý vaho i Arelý. ");
INSERT INTO tdx_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","O ana’ i Asereo: Iimnà, naho Iisvà, naho Iisvý, naho i Berìa vaho i Sèrake rahavave’ iareo. O ana’ i Berìao: i Kebère naho i Malkièle; ");
INSERT INTO tdx_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","(irezay ro ana’ i Zilpae, i nomei’ i Labàne amy ana’e Leae vaho nasama’e ho a’ Iakòbe—ondaty folo eneñ’ amby.) ");
INSERT INTO tdx_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","O ana’ i Rahkele vali’ Iakòbeo: I Iosefe naho i Beniamine. ");
INSERT INTO tdx_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Nahatoly i Menasè naho i Efraime an-tane Mitsraime ao t’Iosefe, i nasama’ i Asenate ana’ i Potifera, mpisoro’ i Oney, ho aze rey. ");
INSERT INTO tdx_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","O ana’ i Beniamineo: i Bèla, naho i Bèkere, naho i Asbèle, i Gerà, naho i Naamàne, i Eký, naho i Ròse, i Mopìme, naho i Khopìme vaho i Arde, ");
INSERT INTO tdx_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","(nasama’ i Rahkele am’ Iakòbe i ana’e rey: ondaty folo efats’amby.) ");
INSERT INTO tdx_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ty ana’ i Dane: i Kosìme. ");
INSERT INTO tdx_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","O ana’ i Naftalio: Iaktseèle, naho i Goný, naho Ietsère vaho i Sileme, ");
INSERT INTO tdx_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","(i Bilhae, natolo’ i Labàne amy ana’e Rahkele ty nahatoly irezay ho am’ Iakobe—nitontañe h’ondaty fito). ");
INSERT INTO tdx_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ze hene ondati’ Iakòbe nitotsa­ke Mitsraime añe, o boak’am-bania’e ao naho tsy o valin’ ana’eo, le ondaty enem-polo eneñ’ amby. ");
INSERT INTO tdx_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Roe ty ana’ Iosefe nisamake e Mitsraime ao; aa le fitompolo ty an-kasavereña’ Iakòbe nandoake e Mitsraime añe. ");
INSERT INTO tdx_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Nirahe’e aolo mb’am’Iosefe mb’eo t’Ie­hodà hatoro’e aze hey ty lalañe mb’e Gose­na mb’eo, vaho nimoak’ an-tane Gosena ao iereo. ");
INSERT INTO tdx_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Nampihentseñe’ Iosefe ty sarete’e le nionjom-b’eo hifanalaka am’ Israele rae’e e Gosena ao. Niheo ama’e mb’eo re, le namorokoko am-pititia’e vaho nangololoike ela am-pititia’e eo. ");
INSERT INTO tdx_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Hoe t’Israele am’ Iosefe, Apoho hikenkañe henaneo, fa nitreako ty tare­he’o t’ie mbe veloñe. ");
INSERT INTO tdx_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hoe t’Iosefe aman-drahalahi’e naho añ’anjomban-drae’e, Hiavotse mb’eo iraho hitalily ty hoe amy Parò: Fa to­tsa­k’ amako atoy o rahalahikoo naho ty anjomban-draeko boak’ an-tane Kanàne añe. ");
INSERT INTO tdx_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Mpiarak’ añondry o lahilahio, fa mpihare, le hene nen­dese’ iereo o mpirai-lia’eo naho o mpirai-tro’eo vaho ze he’e am’iareoo. ");
INSERT INTO tdx_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Ie koiha’ i Parò manao ty hoe, Inom-bao ty tolon-draha’ areo? ");
INSERT INTO tdx_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","le hanoa’areo ty hoe, Fa mpihare boak’ amy te niajalahy pake henane o mpitoro’oo, zahay naho o roae’aio—soa t’ie hitoetse an-tane Gosena, amy te mampangorý o nte-Mitsraimeo ze atao mpiarak’ añondry. ");
INSERT INTO tdx_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Aa le nimb’amy Parò ao t’Iosefe le nanoa’e ty hoe: Fa totsak’ atoy boak’an-tane’ Kanàne añe ty raeko naho o rahalahikoo, rekets’ o mpirai-lia’eo naho o mpirai-tro’eo vaho o fanaña’ iareo iabio; oniño t’ie fa mitoetse an-tane Gosena añe. ");
INSERT INTO tdx_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Nendese’e t’indaty lime amo rahalahi’eo vaho nampiatrefe’e amy Parò. ");
INSERT INTO tdx_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Hoe t’i Parò amy rahalahi’e rey, Ino ty fitoloña’ areo? Le hoe iereo amy Parò, Mpiarak’ añondry o mpitoro’oo, zahay naho o roae’aio. ");
INSERT INTO tdx_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Hoe iereo amy Parò, Pok’etoan-jahay hañialo an-tane atoy; amy te tsy aman-tane hiandraza’e o mpirai-liam-pitoro’oo ami’ty hamafe’ i hasalikoañe an-tane Kanàney. Aa ehe, angao hitoetse an-tane Gose­na añe o mpitoro’oo. ");
INSERT INTO tdx_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Le hoe t’i Parò am’ Iosefe, Fa totsak’ ama’o ty rae’o naho o rahalahi’oo. ");
INSERT INTO tdx_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Aña­trefa’o ty tane Mitsraime, ampañialo an-tane kobokara iereo; angao hitoetse an-tane Gosena añe; aa naho rendre’o ze mahatafetetse am’iereo, le ampamandroñeñe iareo o harekoo. ");
INSERT INTO tdx_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Nampihovae’ Iosefe amy zao ty rae’e vaho nampiatrefe’e amy Parò, le nitata i Parò t’Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Hoe t’i Parò am’ Iakòbe, Fire ty taoñe niveloma’o? ");
INSERT INTO tdx_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Hoe t’Iakòbe amy Parò, Zato-tsi-telo-polo ty andro’ o taoñe nañialoako an-tane atoy; tsy ampeampe vaho nampifeak’ ahy ty andro’ o taoñe nivelomakoo fa tsy nahatàkatse ty andro’ o taon-droaeko amo andro nañialoa’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Tinata’ Iakòbe t’i Parò vaho nienga boak’ añatrefa’ i Parò. ");
INSERT INTO tdx_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Aa le nampimoneña’ Iosefe t’i rae’e naho o rahalahi’eo vaho tinolo’e fanañañe an-tane Mitsraime ao, ty tane hoba amy taney, an-tane Ramsese ao ty amy saontsi’ i Paròy. ");
INSERT INTO tdx_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Le nifahana’ Iosefe ty rae’e naho o rahalahi’eo, naho ty añ’anjomban-drae’e iaby ami’ty mahakama ho am-bava’ o keleia’eo. ");
INSERT INTO tdx_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ie amy zay tsy ama’ mahakama i tane iabiy, amy te nimafe i san-kerey. Nikantañe ty an-tane Mitsraime ao naho an tane’ Kanàne añe ty amy hasalikoañey. ");
INSERT INTO tdx_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Natonto’ Iosefe ze hene drala nioniñe an-tane Mitsraime ao naho an-tane Kanàne ao, ampitsa­lohañe ty mahakama nikaloa’ iareo vaho nase­se’ Iosefe añ’anjomba’ i Parò ao o dralao. ");
INSERT INTO tdx_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ie nikapaike ze hene drala an-tane Mitsraime naho an-tane Kanàne añe, le nivotrak’ am’ Iosefe o hene nte-Mitsraimeo nanao ty hoe, Añomezo mahakama! Hatao akore ty hivetraha’ay añatrefa’o? Fa kòake o dralao. ");
INSERT INTO tdx_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Le hoe ty natoi’ Iosefe, Meo ahiko ty hare’ areo, le ho tolorako mahakama ampi­tsalohañe hare kanao kapai-drala. ");
INSERT INTO tdx_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Aa le nendese’ iareo am’ Iosefe ty hare’ iareo vaho tinolo’ Iosefe maha­kama ampikaloañe soavala naho o añondri’ iareo naho o añombe’ iareo naho o birikeo, le finaha’e mahakama amy taoñey o hare’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ie nimodo i taoñey le niheo ama’e mb’eo amy taoñe nanonjohiy iereo, nanao ty hoe, Tsy hai’ay aetak’ amy talè’aiy te fa ka­pio­ke o drala’aio naho fa amy talè’ay ze troke añombe. Le tsy eo ty añatre­fam-pihaino’ o talè’aio naho tsy o sandri’aio naho o tane’aio. ");
INSERT INTO tdx_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Inoñe ty hikoromaha’ay naho o tane’aio añatre­fam-pihaino’o? Vilio zahay naho o tane’aio hata­kalo i mahakamay. Ho ondevo’ i Parò zahay naho o tane’ay iabio; fe meo tabiry tsy hivetraha’ay vaho te tsy hangoakoake i taney. ");
INSERT INTO tdx_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Aa le hene kinalo’ Iosefe ty tane Mitsraime ho a i Parò. Fa songa nandetake i tete’ey o nte-Mitsraimeo ami’ty hamafe’ i san-kerey ama’e; aa le niazo’ i Parò i taney. ");
INSERT INTO tdx_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Le ty am’ ondatio, naveve’e mb’an-drova ao, sikal’ ami’ty efe’ i Mitsraime añe pak’ añ’efe’e ila’e ka. ");
INSERT INTO tdx_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ty tane’ o mpisoroñeo avao ty tsy vinili’e; amy te nahazo vati-jadoñe erik’ amy Parò naho nikama i vaty namahana’ i Parò iareoy vaho tsy naleta’ iareo o taneo. ");
INSERT INTO tdx_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Le hoe t’Iosefe am’ondatio, Kanao nikaloeko ama’areo anindro­any ho a i Parò o sandri’ areoo naho ty tane’areo, intoy ty tabiry ho anahareo; tongiso i taney. ");
INSERT INTO tdx_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Le hatolo’ areo amy Parò am-pitatahañe añe ty faha-lime’e naho ho tana’areo ty faha-lime’e efatse ho tabiry amo tonda’ areoo, le ho mahakama’ areo naho ho a o añ’anjomba’ areoo vaho ho a o keleia’ areoo. ");
INSERT INTO tdx_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Hoe iereo, Fa rinomba’o ty fiai’ay, aa ehe te hahatendrek’ isoke am-pahaoniñan-talekoy, le ho mpitoro’ i Parò zahay. ");
INSERT INTO tdx_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Aa le nanoe’ Iosefe fañè an-tane Mitsraime pak’ androany te a i Parò ty faha-lime’e naho tsy ty tane’ o mpisoroñeo avao, ie tsy nivalike ho amy Parò. ");
INSERT INTO tdx_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Aa le nitoetse an-tane Mitsraime, an-tane Gosena añe t’Israele vaho nanontoñe vara ao, le namokatse vaho nangetseketseke. ");
INSERT INTO tdx_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ni­mo­­ne­ñe an-tane Mitsraime ao folo-tao-fito’amby t’Iakòbe. Aa le zato-tsi-efapolo-fito’ amby taoñe ty andro niveloma’ Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ie nitotoke ty fañitoza’ Israele, le kinan­ji’e t’Iosefe ana-dahi’e le hoe ty nafè’e: Ie nahaonim-pañisohañe am-pahaisaha’o, le ehe aziliho ambane’ foto-peko ao ty fità’o havana vaho atraho am-patarihañe naho havantañañe. Ko mandeveñe ahy e Mitsraime atoy; ");
INSERT INTO tdx_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","aa kanao hindre hitsalalampatse aman-droaeko ao, le takono hiakatse i Mitsraime vaho alenteho an-kibori’ iareo ao. Hoe ty natoi’e, Hene hanoeko o nisaontsie’oo, ");
INSERT INTO tdx_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","le hoe re, Mifantà amako, le nifanta’e, vaho nibokok’ antondohàm-pandrea’e eo t’Israele. ");
INSERT INTO tdx_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ie roñoñe añe, le nisaontsieñe am’ Iosefe ty hoe, Fa deme’e ty rae’o. Aa le nente’e mindre ama’e ty ana-dahi’e roe, i Menasè naho i Efraime, ");
INSERT INTO tdx_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","le nisaon­tsieñe am’ Iakòbe ty hoe, Ingo fa pok’ etoa t’Iosefe ana’o, le nañaly haozaran-dre nitroatse amy fandrea’ey, ");
INSERT INTO tdx_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","vaho nanao ty hoe am’ Iosefe, Nañento amako t’i El-Sadai e Loze, an-tane Kanàne añe, ie nitata ahy ");
INSERT INTO tdx_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ami’ty hoe, Inao, hampiraoraoeko irehe vaho hampitom­boeko. Hanoeko foko am-poko, vaho hatoloko amo tarira’oo ty tane toy ho fanañañe tsy ho modo nainai’e. ");
INSERT INTO tdx_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ie amy zay, ho ahiko t’i Efraime naho i Menasè, i ana’o roe nitoly ama’o an-tane Mitsraime atoy aolo’ ty nimbako mb’ama’o mb’e Mitsraime atoy rey; hambañe ami’ty maha-ahiko i Reòbene naho i Simone; ");
INSERT INTO tdx_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","le ho azo ze samahe’o manonjohy iareo, vaho ho volili­eñe ambane’ ty tahina’ o rahalahi’eo iereo amo lova’iareoo. ");
INSERT INTO tdx_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Aa izaho nimpoly boak’e Padana añe, le nihomak’ amako an-tane Kanàne añe t’i Rahkele, an-dalañe eo ie didý tsy nimoake Efràta ao; aa le naleveko añ’olon-dala’ i Efràta eo. (e Betlèkheme izay.) ");
INSERT INTO tdx_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Ie nioni’ Iakòbe i ana’ Iosefe rey, le hoe re, Ia o retiañeo? ");
INSERT INTO tdx_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Hoe t’Iosefe aman-drae’e, Ie o anako natolon’ Aña­hare ahy atoio. Le hoe re, Ehe endeso mb’etoa ho tataeko. ");
INSERT INTO tdx_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ie amy zao, nitàlo am-pihaino t’Iakòbe ami’ty fahantera’e, tsy nahaisake soa. Aa le navi’ Iosefe marine aze eo iereo le norofa’e vaho niforokokoe’e. ");
INSERT INTO tdx_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Hoe t’Israele am’Iosefe, Tsy nitamako ty hahatrea o tarehe’oo; fa hehe, nampañisahen’ Añahare ahy ka o ana’oo. ");
INSERT INTO tdx_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Le na­kare’ Iosefe añ’ongo’e iereo vaho nampiondrehe’e mb’an-tane ty lahara’e. ");
INSERT INTO tdx_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Rinambe’ Iosefe i roroey, i Efraime am-pità’e havana ho mb’an-kavia’ Israele, le i Menasè am-pità’e havia mb’an-kavana’ Israele vaho nampañarinea’e. ");
INSERT INTO tdx_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Fe nahiti’ Israele ty fità’e havana naho nasampe’e an-doha i Efraime zai’e vaho ty fità’e havia an-doha’ i Menasè, toe nampitivalañe’e o fità’eo ndra te i Menasè ty tañoloñoloña’e. ");
INSERT INTO tdx_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Nitatae’e t’Iosefe, ami’ty hoe: Ry Andrianañahare niatrefan-droaeko Avrahame naho Ietsàke am-pañaveloañe, Ry Andrianañahare namahañe ahy ami’ty fiaiko iaby pak’ androany, ");
INSERT INTO tdx_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ry anjely namotsots’ ahy amy ze fonga haratiañe, tahio o ajalahy retoañe, le ampitokavo ami’ty añarako, naho ami’ty tahina’ i Avrahame naho Ietsàke roaeko; vaho ampivasiaño an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ie nioni’ Iosefe te an-doha’ i Efraime ty nampitongoàn-drae’e i fità’e havanay, le tsy ninò’e vaho rinambe’e ty fitàn-drae’e hampi­pitsok’ aze an-doha’ i Efraime ho amy loha’ i Menasèy. ");
INSERT INTO tdx_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Hoe t’Iosefe aman-drae’e, Tsy izay ry raeko! Ano ami’ty raike toy ty fità’o, ie ty tañoloñoloñako. ");
INSERT INTO tdx_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Fe nifoneñe ty rae’e nanao ty hoe, Fantako ry anako, apotako t’ie ho fifokoañe ka, mbore ho ra’elahy. Fe handikoatse aze ty zai’e, fa ho halifora’ o fifeheañeo o tarira’eo. ");
INSERT INTO tdx_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Aa le nitatae’e iereo amy andro zay ami’ty hoe: Ihe ty hitatà’ Israele, ami’ty hoe, Ehe t’ie hampanahafen’Añahare amy Efraime naho amy Menasè. Aa le najado’e ho lohà’ i Menasè t’i Efraime. ");
INSERT INTO tdx_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Le hoe t’Israele am’ Iosefe, Inao te hikenkan-draho, fe hindre ama’ areo t’i Andrianañahare vaho hampoli’e mb’an-tanen-droae’ areo mb’eo. ");
INSERT INTO tdx_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tovo’ izay, fa natoloko anjara raik’ ambone’ o rahalahi’oo irehe, i tinavako am-pibarako naho faleko am-pità’ o nte-Emoreoy. ");
INSERT INTO tdx_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Le kinanji’ Iakòbe o ana’eo, vaho nanao ty hoe, Miropaha amako etoy, ho talilieko ze hife­tsak’ ama’ areo amo andro añeo. ");
INSERT INTO tdx_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Mivoria vaho mitsanoña, ry ana’ Iakòbe; tsendreño Israele rae’areo. ");
INSERT INTO tdx_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","O Reòbene, tañoloñoloñako irehe, ty haozarako naho ty loha-voan-kafatrarako, mininginingy an-dohàñe, miligiligy am-panjofahañe. ");
INSERT INTO tdx_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","mihalingaliñe hoe rano, tsy hionjoñe ka, amy te nanganiha’o ty fandrean-drae’o; nitivàeñe—ie nijoñe an-tihiko eo! ");
INSERT INTO tdx_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Miharo-foetse t’i Simone naho i Levy; haraom-piaroteñe o fialia’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ee te tsy hitrao-pikinia’ am’iareo ty troko, Lonike te tsy hirekets’ am-pivori’iareo ty asiko, Fa an-kabosehañe ty namonoa’iareo ondaty, Naho an-tsatri’ iareo ro namirasintake añombe, ");
INSERT INTO tdx_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Hafàtse ty haboseha’iareo, amy te mandoviake, naho ty fiforoforoa’iareo, amy te manitra! Ho zaraeko am’ Iakòbe ao iereo, vaho hampiparaitaheko e Israele ao. ");
INSERT INTO tdx_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","O Iehodà, mandrenge azo o rahalahi’oo; An-trehon-drafelahi’o ty fità’o; Milokoloko ama’o o ana-dahin-drae’oo. ");
INSERT INTO tdx_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ana-diona t’Iehodà; Nitsàtsa irehe le nitroatse. Mitsakononoke eo re, mangolotoke hoe liona, hoe liona-vave, ia ty hampitsekak’ aze? ");
INSERT INTO tdx_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Tsy hipitsok’ am’ Iehodà ty kobain-drazañe, ndra ty fitoñom-panjaka añivo’ o fandia’eo, ampara’ ty fitotsaha’ i Talè’ey vaho ie ty hivohora’ o kilakila’ndatio. ");
INSERT INTO tdx_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Vahora’e am-bahe ty borìke’e tarabao, naho ty ana-borìke’e am-bahe miloeloe, le sinasa’e an-divay o siki’eo, naho o saro’eo an-diom-balobok’ ao; ");
INSERT INTO tdx_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Menae’ ty divay o maso’eo, vaho hafotin-dronono ty nife’e. ");
INSERT INTO tdx_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Hitoetse añolon-driake t’i Zebolone ho fitolian-dakañe, hiefetse amy Tsidòne añe. ");
INSERT INTO tdx_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Borìke maozatse t’Isakare miondrek’ añivon-kilankañe roe, ");
INSERT INTO tdx_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Naheo’e te soa i fitofàñey naho te naindoñindoñe i taney, aa le nabokoboko’e o soro’eo hinday vaho ninjare nitoroñe haba. ");
INSERT INTO tdx_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Hizaka ondati’eo t’i Dane, Kanao mpiamo foko Israeleo. ");
INSERT INTO tdx_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Ho mereñe an-dalañe eo t’i Dane, menarà mandiñe an-dalan-tsileke eo, Mpihehetse tomin-tsovala Hampitafatsilañelañe i piningi’ey. ");
INSERT INTO tdx_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Mandiñe ty fandrombaha’o raho ry Iehovà. ");
INSERT INTO tdx_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Haname i Gade ty fifañosoñañe, Fa hihoridaña’e an-tomi’e. ");
INSERT INTO tdx_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Boak’amy Asere ty mahakama matave, hazotso’e ty hafiriam-panjakay. ");
INSERT INTO tdx_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Renem-panaloke nampidadañe t’i Naftaly, mitaroñe razan-tsaontsy. ");
INSERT INTO tdx_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Tirin-katae mamoa t’Iosefe, toran-katae miregorego añ’olon-drano manganahana; mamokon-kijoly o tora’eo. ");
INSERT INTO tdx_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Nampioje aze an-kafairañe o mpitàm-paleo; Hiniriri’iareo ana-pale fa nalaiñe aze. ");
INSERT INTO tdx_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Fe nitan-kaozarañe i fale’ey vaho nampigañe’ o fitàn-Tsitongerè’ Iakòbeo, o siram-pità’eo, Boak’ ao ty Mpiarake, i Lamilami’ Israeley, ");
INSERT INTO tdx_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","hirik’ aman’ Añaharen-drae’o mpañimb’azoy, naho amy El-Sadai mpitahy azo, amo fitahia’ i andikerañe amboneio, amo fitahia’ i laleke mandre ambane aoio, amo fitahiam-patroa naho hoviñeo. ");
INSERT INTO tdx_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Maozatse te ami’ty tata’ o vohitse tsy modoo o tatan-drae’oo, Pak’ añ’efe’ o haboañe nainai’eo ty ho an-kevo’ Iosefe, naho añambone’ i naambake amo rahalahi’eoy ");
INSERT INTO tdx_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Farasy romotse t’i Beniamine, maraiñe re mampibo­tseke ty nitsatsà’e, haleñe re mandiva o kinopa’eo. ");
INSERT INTO tdx_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","I tsaraeñe rezay ro fifokoa folo-ro’ ambi’ Israele, le i saontsieñey ro nafèn-drae’ iareo t’ie nitata; toe songa nitatae’e an-tata mañeva. ");
INSERT INTO tdx_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Le hoe ty nafè’e am’iereo: Fa antitotse te hifanontoñe am’ ondati­koo iraho. Aleveño aman-droaeko an-dakato an-tete’ i Efrone nte-Khete ao ");
INSERT INTO tdx_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","amy lakato an-tonda’ i Makpelà, aolo’ i Mamrè, an-tane Kanàne añe, vinili’ i Avrahame reketse tonda amy Efrone nte-Khete ho tanen-donake ho azey. ");
INSERT INTO tdx_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tao ty nandentehañe i Avrahame naho i Sarà vali’e le ty nandentehañe Ietsàke naho i vali’e Ribkae, vaho tao ty nandeveñako i Leae ");
INSERT INTO tdx_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","I tetekey naho i lakato ama’ey ty vinily amo ana’ i Kheteo. ");
INSERT INTO tdx_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ie nagado’ Iakòbe i nafè’e amo ana’eoy, le naonjo’e am-pandrea’e o fandia’eo le nikofòke fara’e vaho natontoñe am’ ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nihotrak’ an-daharan-drae’eo t’Iosefe le nangoihoy ama’e vaho nañorok’ aze. ");
INSERT INTO tdx_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Linili’ Iosefe o mpanaha mpitoro’eo hañoloñe an-drae’e. Le hinolonkolo’ o mpanahao t’Israele; ");
INSERT INTO tdx_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","efa-polo andro ty nirì’ iereo ama’e, amy te izay o andro mahafonitse ty fañolonkoloñan-jañahareo. Nandala fitom-polo andro ho aze o nte-Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Ie niheneke o androm-pandalàñe azeo le hoe ty lañona’ Iosefe amo añ’anjomba’ i Paròo, Aa naho nahatendreke isoke am-pahaisaha’areo iraho le saontsio an-dravembia’ i Parò ty hoe: ");
INSERT INTO tdx_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Nampifantàn-draeko ahy ty hoe: Ingo fa hikenkan-draho. Le aleveño an-kibory hinaliko ho am-batako an-tane Kanàne ao. Aa le angao iraho hionjom-b’eo handeveñe an-draeko vaho himpoly. ");
INSERT INTO tdx_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Hoe ty natoi’ i Parò, Mionjona, aleveño ty rae’o amy nampifantà’e azoy. ");
INSERT INTO tdx_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Aa le nionjoñe t’Iosefe handeveñe an-drae’e. Fonga nindre ama’e ze mpitoro’ i Parò naho o roandria añ’ anjomba’e ao naho o roandria’ ty tane Mitsraime iabio, ");
INSERT INTO tdx_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","naho ty añ’anjomba’ Iosefe iaby, o rahalahi’eo vaho ty añ’ anjomban-drae’e. Fe napok’ an-tane Gosena ao o ana’iareoo naho o mpirai-trokeo naho o lia-raikeo. ");
INSERT INTO tdx_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Nindre-lia ama’e o sarete reketse mpindaio. Nivalobohòke jabajaba. ");
INSERT INTO tdx_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ie nivo­trak’ an-toem-pamofoha’ i Atade, alafe’ Iordaney, le nanao fandalàñe jabajaba nampioremeñe; fito andro ty nandalà’e an-drae’e. ");
INSERT INTO tdx_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ie niisa’ o nte-Kanàne mpimoneñe amy taneio i fandalàñe an-tanem-pamofoha’ i Atadey le hoe iereo. Fandalàñe mam­pioje o anoe’ o nte-Mitsraimeo. Aa le natao Abele Mitsraime i tane andafe’ Iordaney zay, ");
INSERT INTO tdx_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","naho nihenefe’ o ana-dahi’eo i nafè’ey: ");
INSERT INTO tdx_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Nitakone’ iereo mb’ an-tane Kanàne mb’eo vaho naleve’ iareo an-dakato an-tete’ i Makpelà ao, i vinili’ i Avrahame rekets’ i tonday marine i Mamrè amy Efrone nte-Khete ho tanen-dona’ey. ");
INSERT INTO tdx_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ie nande­veñe an-drae’e t’Iosefe le nimpoly mb’e Mitsraime añe rekets’ o rahalahi’eo naho i maro nindre nionjoñe ama’e mb’eo nandeveñe an-drae’ey. ");
INSERT INTO tdx_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Aa ie nioni’ o rahalahi’ Iosefeo te nivilasy ty rae’ iareo le hoe ty fitsakorea’ iareo: Hera mitan-kabò aman-tika t’Iosefe hañondroha’e aman-tikañe ze fonga raty nanoan-tika? ");
INSERT INTO tdx_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Aa le nañitrik’ am’Iosefe iereo nanao ty hoe, Hoe ty nafèn-drae’o aolo’ t’ie nihomake, ");
INSERT INTO tdx_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Zao ty ho enta’ areo am’ Iosefe: Ehe apoho ty tahiñe nanoa’ o rahalahi’oo naho i hakeo nanoe’ iereo nijoy azoy. Aa ie henaneo, ehe apoho ty hakeo’ o mpitoron’ Añaharen-drae’oo. Naharovetse t’Iosefe i enta’ iareo ama’ey. ");
INSERT INTO tdx_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Nimb’eo amy zao o rahalahi’eo, nibabok’ añ’atrefa’eo, nanao ty hoe, Intoan-jahay fa ondevo’o. ");
INSERT INTO tdx_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Aa hoe t’Iosefe am’ iereo, Ko hembañe, mpisolo an’ Andrianañahare v’o ahoo? ");
INSERT INTO tdx_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Inahareo ka, toe nikinia raty amako fe sinafirin’ Añahare ho soa, hiboaha’ o oniñe henaneo, hampitambeloma’e ondaty mitozantoza. ");
INSERT INTO tdx_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Aa le ko mahimahiñe, fa ho fahanako nahareo naho o keleia’ areoo. Amy hoe zay ty nampanin­tsiña’e, ie nisaontsy añ’arofo’ iareo ao. ");
INSERT INTO tdx_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nimoneñe e Mitsraime ao t’Iosefe, ie naho ty hasavereñan-drae’e; vaho niveloñe zato-tsi-folo taoñe. ");
INSERT INTO tdx_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Niisa’ Iosefe o ana’ i Efraimeo pak’ ami’ty tariratse faha telo; nibeizeñe añ’ ongo’ Iosefe ka o ana’ i Makire, ana’ i Menasèo. ");
INSERT INTO tdx_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Le hoe t’Iosefe aman-drahalahi’e, fa hikenkan-draho; le toe hito­tsak’ ama’areo t’i Andrianañahare hinday anahareo hienga an-tane atoy homb’an-tane nifantà’e amy Avrahame, am’ Ietsàke naho am’Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Aa le nampifantà’ Iosefe amo ana’ Israeleo ty hoe, Toe hañimba anahareo t’i Andrianañahare, vaho hakare’ areo an-tane atoy o taolakoo. ");
INSERT INTO tdx_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nihomake t’Io­sefe, ie ni-zato-tsi-folo taoñe, le naholon­koloñe naho napololòtse an-tsandòke e Mitsraime ao. ");
INSERT INTO tdx_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Iretoañe ty tahina’ o ana’ Israele nivotrake e Mitsraime ao nindre amy Iakòbeo songa an-kasavereña’e: ");
INSERT INTO tdx_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","i Reòbene, i Simone, i Levy naho Iehodà, ");
INSERT INTO tdx_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Isakare, i Zebolone naho i Beniamene, ");
INSERT INTO tdx_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","i Dane naho i Naftalý, i Gade naho i Asere. ");
INSERT INTO tdx_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Fitom-polo ty ia’ ondaty nasama’ Iakòbeo. Fa te Mitsraime añe ka t’Iosefe. ");
INSERT INTO tdx_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Ie nivilasy t’Iosefe naho i rahalahi’e rey iaby naho ze hene nimpirai-nono ama’e, ");
INSERT INTO tdx_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","le niraorao o ana’ Israeleo, nanarànake naho nitombo ho maro naho toe niha-ra’elahy vaho nahatsitsike i taney. ");
INSERT INTO tdx_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ie amy zao, nitroatse hifehe i Mitsraime ty mpanjaka tsy naha­fohiñe Iosefe. ");
INSERT INTO tdx_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Hoe re am’ondati’eo. Heheke, mandikoatse naho maozatse te aman-tika o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Antao arè hinday iareo an-kihitse ke hitombo, hera mifetsak’ atoy ty aly le mete hirekets’ amo rafelahintikañeo iereo hialy aman-tika hienga an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Aa le nampijadoña’ iareo mpifelek’ ondevo, hamorekeke iareo an-kilankañe, le namboara’ iereo rova famandroñañe t’i Parò: i Pitòme naho i Raamèse. ");
INSERT INTO tdx_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Aa ndra te nañindra i fampisilofañey, mbe nitombo naho nange­tse­ketseke avao ondatio; toly ndra nampangebahebake iareo o ana’ Israeleo, ");
INSERT INTO tdx_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","le nampitoroñe’ o nte-Mitsraimeo an-kabodongero’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Naho nanoeñe afero ty fiai’iareo, am-pifanehafañe mafe ami’ty birìke naho làlotse vaho amy ze hene fitoloñañe an-kivoke ey, le fonga an-tsenge-hery ty fampitromahañe nampanoeñe iareo. ");
INSERT INTO tdx_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Le hoe ty mpanjaka’ i Mitsraime amo mpanaha-mampiterake o nte-Evreoo (i Siprahae ty añara’ ty raike naho i Poahae ty añara’ ty raike): ");
INSERT INTO tdx_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Hoe re: Ie mampite­rake ty rakemba nte-Evre naho mahaisak’ aze am-pitoboham-pisamahañe, ie lahilahy, vonò; fa naho ampela, apoho ho veloñe. ");
INSERT INTO tdx_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Fe nimpañeveñe aman’ Añahare o mpanàhao, le tsy nanoe’ iareo i nandilia’ i mpanjaka’ i Mitsraimeiy, fa nenga’ iareo veloñe o lahilahio. ");
INSERT INTO tdx_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Aa le kinoi’ i mpanjaka’ i Mitsraimey i mpanaha rey naho nanoa’e ty hoe, Akore ty anoa’ areo zao, te apo’ areo veloñe o lahilahio? ");
INSERT INTO tdx_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Hoe i mpanaha rey amy Parò, Toe tsy hambañe amo rakemba nte-Mitsraimeo o rakemba ana’ Israeleo fa mavitrike mahatoly aolo’ ty ivotraha’ ty mpanaha. ");
INSERT INTO tdx_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Aa le nanoan’ Añahare soa o mpanahao; vaho niha-tsiefa naho nitombo an-kaozarañe ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Aa kanao nañeveñe aman’ Añahare o mpanahao le nampisavereñe’e. ");
INSERT INTO tdx_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Le hoe ty nafanto’ i Parò am’ondati’e iabio: Afetsaho amy Nailey ze hene anadahy samake, fa tano ho veloñe o anak’ampelao. ");
INSERT INTO tdx_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ie amy zao, nañenga ty anak’ ampela’ i Levy t’indaty boak’ añ’ anjomba’ i Levy. ");
INSERT INTO tdx_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Niareñe i rakembay, nitoly ana-dahy, le nioni’e te soa i ajajamenay vaho naeta’e telo volañe. ");
INSERT INTO tdx_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Aa ie tsy nahafañetak’ aze ka, le nangala’e vakoa-vinda naho nipakora’e mozòtse naho lite-laka vaho najo’e ao i anak’ ajajay vaho natsorofo’e am-binda añolon-drano ey. ");
INSERT INTO tdx_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Nijohañe ey ty zoke’e ampela nisamba ze hanoañe aze. ");
INSERT INTO tdx_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Nizotso mb’an-tsaka mb’eo amy zao ty anak’ ampela’ i Parò hiandro, le nijelanjelañe añ’olotse ey o somondrara’eo. Aa naho nitrea’e añate-vinda ao i vakoay le nirahe’e hangalak’ aze ty mpitoro’e ampela, ");
INSERT INTO tdx_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","vaho sinoka’e le nahaisake i anak’ ajajay. Nitañy i ajajamenay vaho niferenaiña’e, ami’ty hoe: Toe anan-te-Evre toke. ");
INSERT INTO tdx_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Le hoe i rahavave’ey amy ana’ i Paròy, Akore t’ie añitrifako mpampinono amo rakemba nte-Evreo ham­pinono i ajajay? ");
INSERT INTO tdx_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Akia, hoe i anak’ ampela’ i Paròy; aa le nimb’eo i ajajampelay nitoka ty rene’ i ajajay. ");
INSERT INTO tdx_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Hoe i ana’ i Paròy ama’e, Endeso ty ajaja toy le ampinonò ho ahiko vaho ho tambezeko irehe. Aa le nendese’ i rakembay i anak’ ajajay vaho nampinonoe’e. ");
INSERT INTO tdx_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","itombo i ajajay le nendese’e mb’amy anak’ampela’ i Paròy añe vaho rinambe’e ho ana-dahi’e. Natao’e Mosè ty añara’e amy ty hoe, Tinariko boak’an-drano. ");
INSERT INTO tdx_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ie te indraik’ andro naho fa niañoñ’ ay t’i Mosè, le niakatse mb’ am’ ondati’eo nahaoniñe ty nijinia’iareo naho nioni’e ty nte-Mitsraime namofoke ty nte-Evre, raik’ amo longo’eo. ");
INSERT INTO tdx_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Nijilojilo mb’ etia mb’ eroy, aa ie tsy nahatrea ondaty, le nañohofa’e loza i nte-Mitsraimey vaho naeta’e am-paseñe ao. ");
INSERT INTO tdx_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ie niakatse mb’eo naho loak’ andro le nanjo ty nte-Evre roe nifandrapake ty aly, le hoe re ami’ty aman-kakeo, Ino ty andafà’o o longo’oo? ");
INSERT INTO tdx_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Le hoe re. Ia ty nañoriñ’ azo ho mpifehe naho mpizaka anay? Hañe-doza amako ka hao irehe manahake i namonoa’o i nte-Mitsraimeiy? Nihembañ’ amy zao t’i Mosè nitsa­kore ty hoe, Toe nirendreke i rahay. ");
INSERT INTO tdx_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Jinanji’ i Parò, le nipay ty hañe-doza amy Mosè. Le nibioñe ami’ty tarehe’ i Parò t’i Mosè, noly mb’an-tane Midiane añe vaho niambesatse am-bovoñe eo. ");
INSERT INTO tdx_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Aman-anak’ ampela fito ty mpisoro’ i Midiane. Nimb’ eo iereo nitari-drano naña­tsake o dabaogao hampinomeñe ty lia-rain-drae’e. ");
INSERT INTO tdx_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Pok’eo amy zao o mpiarak’ añondrio nanao soike iareo. Niongake t’i Mosè le rinomba’e le nampinome’e i lia-rai’iareoy. ");
INSERT INTO tdx_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Ie nimpoly mb’an-drae’e Reoele mb’eo le hoe re, Ino ty nampasika ty fimpoli’ areo androany? ");
INSERT INTO tdx_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Hoe iereo, Nañolots’ anay amo mpiarak’ añondrio ty nte-Mitsraime vaho nitariha’e rano mbore nampinome’e i lia-raikey. ");
INSERT INTO tdx_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Hoe re amo anak’ ampela’eo, Aia re? Ino ty nienga’ areo indatiy? Ambarao hikama. ");
INSERT INTO tdx_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Niantofa’ i Mosè t’ie holy amy ‘ndatiy vaho natolo’e amy Mosè t’i Tsiporàe anak’ ampela’e ho vali’e. ");
INSERT INTO tdx_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Nahatoly ana-dahy ho aze re vaho natao’e Geresòme, ami’ty hoe, Renetane iraho mañialo an-tanen’ ambahiny. ");
INSERT INTO tdx_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Ie roñoñe añe, nihomake i mpanjaka’ i Mitsraimey naho nampiselekaiñe o ana’ Israeleo i fandrohizañey, le nirohadrohake vaho nionjoñe mb’ aman’ Añahare boak’ amy fitromahañey ty fitoreo’ iareo. ");
INSERT INTO tdx_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Jinanjin’ Añahare ty toreo’ iareo vaho nitiahin’ Añahare i fañìna’e amy Avrahame naho am’ Ietsàke vaho am’ Iakòbey. ");
INSERT INTO tdx_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Nivazohon’ Añahare o ana’ Israeleo vaho nihaoñen’ Andrianañahare. ");
INSERT INTO tdx_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ie niarake ty lia-rai’ Iit’rò, rafoza’e, mpisoro’ i Midiane, t’i Mosè, le niaoloe’e mb’an-kalo’ i ratraratray mb’eo i lia-raikey vaho pok’ e Korèbe vohin’ Añahare eo. ");
INSERT INTO tdx_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Nisodehañe ama’e an-delan’afo an-drongoñe ao ty anjeli’ Iehovà; nisaria’e, le ndra te nirebarebaen’ afo i rongoñey tsy naha­tomontoñe aze. ");
INSERT INTO tdx_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Le hoe t’i Mosè, Het! hitsile iraho hisamba o raha fanjaka eroan-koekeo, handrendreke ty tsy mahamae o rongoñeo. ");
INSERT INTO tdx_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Nivazoho’ Iehovà t’ie nitsile mb’eo hisamba, le nikanjien’ Añahare boak’ amy rongoñey, ami’ty hoe: O Mosè, Mosè! Hoe re, Intoy iraho, ");
INSERT INTO tdx_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Le hoe re, Ko mañarivo mb’etoañe, afaho hey o hana am-pandia’oo amy te masiñe o tane ijohaña’oo. ");
INSERT INTO tdx_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Tinovo’e ty hoe, Izaho t’i Andrianañaharen-droae’o, t’i Andrianañahare’ i Avrahame naho t’i Andrianañahare’ Ietsàke vaho t’i Andrianañahare’ Iakòbe. Le nanakon-daharañe t’i Mosè fa nihembañe tsy te hahaisak’ an’ Andrianañahare. ");
INSERT INTO tdx_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Le hoe t’Iehovà, Toe nisarieko ty hasotria’ ondatiko e Mitsraimeo; le tsinanoko ty fitoreo’ iareo ty amo mpanao bozizy iareoo; toe apotako ty halovilovia’ iareo, ");
INSERT INTO tdx_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","le nizotsoako handrombak’ iareo amo nte-Mitsraimeo, hañakatse iereo amy taney naho hendeseko mb’ am-patram-bey soa, mb’ an-tane orikorihen-dronono naho tantele, mb’ an-tane’ o nte-Kanàneo naho o nte-Kheteo naho o nte-Emoreo naho o nte-Peri­zeo naho o nte-Kiveo vaho o nte-Iebosìo. ");
INSERT INTO tdx_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ie amy zao, inao! fa pok’ amako ty fibabababa’ o ana’ Israeleo; vaho nitreako ty famorekekea’ o nte-Mitsraime manindry iareoo. ");
INSERT INTO tdx_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Akia, mamantok’ azo iraho homb’ amy Parò mb’eo hañavotse o ana’ Israele ondatikoo amy Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Aa hoe t’i Mosè aman’ Añahare, Ia v-iraho te homb’ amy Parò hañakatse o ana’ Israeleo boake Mitsraime ao? ");
INSERT INTO tdx_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Hoe re, Toe hindrezako; vaho zao ty haha­rendreha’o an-kató te Izaho ty nañirak’ azo: naho navota’o boake Mitsraime ao ondatio, le hitalaho aman’ Añahare ami’ty vohitse toy nahareo. ");
INSERT INTO tdx_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Aa hoe t’i Mosè aman’ Añahare, Ingo, homb’ amo ana’ Israeleo mb’eo iraho hanao ty hoe, Nirahen’ Añaharen-droae’ areo homb’ ama’ areo mb’ etoan-draho, vaho hañontanea’ iereo ty hoe, Ia ty tahina’e? aa le inoñe ty havaleko? ");
INSERT INTO tdx_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Hoe t’i Andrianañahare amy Mosè, Ehiè ze Ehiè, Le tinovo’e ty hoe, Hoe ty ho saontsie’o amo ana’ Israeleo, Ehiè, ty nañitrik’ ahy homb’ama’ areo mb’etoa. ");
INSERT INTO tdx_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Hoe ka t’i Andrianañahare amy Mosè, Hoe ty hatao’o amo ana’ Israeleo, Iehovà, Andrianañaharen-droae’ areo, t’i Andrianañahare’ i Avrahame, i Andrianañahare’ Ietsàke naho i Andrianañahare’ Iakòbe ro nañirak’ ahy homb’ama’ areo mb’etoa. Izay ty añarako nainai’e, vaho izay ty fanoñonañe ahy nainai’e an-tsà an-tsà. ");
INSERT INTO tdx_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Akia, atontono o androanavi’ Israeleo vaho ano ty hoe, Nisodehañe’ amako t’Iehovà Andrianañaharen-droae’ areo, t’i Andrianañahare’ i Avrahame naho Ietsàke vaho Iakòbey, nanao ty hoe: Toe nitilik’ anahareo iraho naho nitreako o anoañe e Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Le hoe iraho: havotako ami’ty halovilovia’ i Mitsraime nahareo, homb’ an-tane’ i nte-Kanàney naho i nte-Khetey naho i nte-Emorey naho i nte-Periziy naho i nte-Kivey vaho i nte-Iebosìy, mb’tane orikorihen-dronono naho tantele añe. ");
INSERT INTO tdx_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ho haoñe’ iareo ty fiarañanaña’o le hiheo mb’amy mpanjaka’ i Mitsraimey irehe rekets’ o androanavi’ Israeleo hanao ty hoe, Fa nifañaoñe ama’ay t’Iehovà Andrianañahare’ o nte-Evreo, aa le angao hañavelo lia telo andro am-patram­bey añe hañenga soroñe am’ Iehovà Andria­nañahare’ay. ");
INSERT INTO tdx_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Toe fantako t’ie tsy hapo’ ty mpanjaka’ i Mitsraime hañavelo naho tsy am-pitàñe maozatse. ");
INSERT INTO tdx_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Aa le hahitiko ty tañako hipaoke i Mitsraime amy ze hene fitoloñañe mahalatsa hanoeko ao. Mandimbe izay t’ie hapo’e hienga. ");
INSERT INTO tdx_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Toe hampañisohako am-pihaino’ o nte-Mitsraimeo ondatio, aa ie mienga, le tsy hañavelo an-tañam-polo; ");
INSERT INTO tdx_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","fa songa hihalaly fanake volafoty naho volamena naho saroñe amo mpiharo tanàñe ama’eo naho amy ze ambahiny añ’ anjomba’e ao ze rakemba vaho haombe’ areo amo ana-dahy naho anakampela’ areoo vaho ho volose’ areo o nte-Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Le hoe ty natoi’ i Mosè, Aa naho tsy miantok’ ahy iereo, tsy mijanjiñe ty feoko, fe hanao ty hoe, Tsy niheo ama’o t’Iehovà? ");
INSERT INTO tdx_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Hoe t’Iehovà ama’e, Ino o am-pità’oo? Hoe re, Kobaiñe. ");
INSERT INTO tdx_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Le hoe re, Afetsaho an-tane eo. Aa le nafetsa’e an-tane naho ninjare mereñe vaho nidisaha’ i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Le hoe t’Iehovà amy Mosè, Ampitakaro ty fità’o, tsepaho añ’ohi’e—aa le nahiti’e ty fità’e nitsi­paok’ aze vaho niheren-ko kobaiñe am-pità’e ao— ");
INSERT INTO tdx_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","hiantofa’ iareo te niheo ama’o t’Iehovà, Andrianañaharen-droae’ iareo, t’i Andrianañahare’ i Avrahame, i Andrianañahare’ Ietsàke vaho i Andrianañahare’ Iakòbe. ");
INSERT INTO tdx_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Natovo’ Iehovà ama’e ty hoe, Azi­liho añ-araña’o ao ty fità’o, le nazili’e añ-araña’e ao ty fità’e le ie nakare’e; hehe te angamae i fità’ey, hafotim-bolovaso. ");
INSERT INTO tdx_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Le hoe re, Ampolio añ-araña’o ao o fità’oo; aa le nazili’e añ-araña’e ao in­draike i fità’ey naho nakare’e boak’ añ-araña’e ao, ie fa nibali-ko hambañe ami-ty sandri’e. ");
INSERT INTO tdx_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Aa naho tsy miantok’ azo ndra mijanjiñe ty feo’ i viloñe valoha’ey le hiantofe’iereo ty feo’ i viloñe faharoey. ");
INSERT INTO tdx_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ie mboe tsy miantoke i viloñe roe rey naho tsy mañaoñe ty feo’o le anovizo rano boak’ amy Nailey naho adoaño an-tane maike eo, fa hinjare lio an-tane maike eo i rano rinambe’o amy sakaiy. ");
INSERT INTO tdx_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Aa hoe t’i Mosè amy Iehovà, Ry Talèko, tsy mahafilañon-draho; ndra taolo ndra hirik’ amy nitsara’o amo mpitoro’oo, te mone midàm-bolañe vaho bedo-lela. ");
INSERT INTO tdx_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Aa le hoe t’Iehovà ama’e, Ia ro namboatse ty falie’ ondaty? Ia ro mamboatse ty bobo, ty giñe, ty mahaisake, vaho ty fey? Tsy Izaho Iehovà hao? ");
INSERT INTO tdx_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Akia arè; himbaeko ty falie’o vaho hanareko azo ze ho saon­tsie’o. ");
INSERT INTO tdx_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Fe hoe re, Ry Talèko, ehe iraho am-pità’ i hirahe’oy. ");
INSERT INTO tdx_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Niviañe amy Mosè amy zao ty haviñera’ Iehovà, le hoe re, Tsy apotako hao i rahalahi’o Aharone nte-Leviy, t’ie mahafirehake? Inao, mionjomb’ ama’o mb’etoa re hifañaoñe ama’o vaho hifale añ’arofo’e te mahaoniñe azo. ");
INSERT INTO tdx_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Hisaontsy ama’e irehe vaho hajo’o am-palie’e o tsarao. Himbaeko ty falie’o naho i falie’ey vaho hañohako ama’ areo ze hanoe’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ie ty hisolo-falie azo am’ ondatio; ie ty ho falie ama’o vaho ho fanalolahy ama’e irehe. ");
INSERT INTO tdx_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Rambeso am-pità’o o kobaiñeo, fa ama’e ty hanoe’o o viloñeo. ");
INSERT INTO tdx_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Nienga t’i Mosè naho nibalike mb’ aman-dra­foza’e Iitrò mb’eo nanao ty hoe, Ehe angao himpoly mb’amo rolongoko e Mitsraimeo handrèndreke hera mbe veloñe. Le hoe t’i Iitrò amy Mosè, Akia am-panintsiñañe, ");
INSERT INTO tdx_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Hoe t’Iehovà amy Mosè e Midiane ao, Akia, mimpolia mb’e Mitsraime mb’eo fa fonga nihomake ondaty nipay ty fiai’oo. ");
INSERT INTO tdx_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Aa le nendese’ i Mosè i vali’ey naho o ana-dahi’eo naho nampiningire’e ami’ty borìke, le nimpoly mb’ an-tane Mitsraime mb’eo; le nitintiñe’ i Mosè am-pità’e i kobain’Añaharey. ");
INSERT INTO tdx_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Aa hoe t’Iehovà amy Mosè, Ie miheo mb’e Mitsraime añe, asoao te hanoe’o añ’atrefa’ i Parò ze hene viloñe napoko am-pita’o, fa hampandiereko ty arofo’e tsy hapo’e hañavelo ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Le hoe ty hanoa’o amy Parò, Hoe t’Iehovà: Anako naho tañoloñoloñako t’Israele; ");
INSERT INTO tdx_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","le hoe iraho ama’o, Angao hañavelo i anakoy hitoroñe ahy. F’ie mifoneñe tsy hampañavelo aze, inao arè: havetrako ty ana-dahi’o, i tañoloñoloña’oy. ");
INSERT INTO tdx_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ie amy liay, amy nialeña’ iareoy, le nifanampe ama’e t’Iehovà, ho nañè-doza ama’e. ");
INSERT INTO tdx_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Le rinambe’ i Tsiporàe ty vato masioñe le tinampa’e ty ofon’ ana-dahi’e naho nahifi’e am-pandia’eo vaho hoe re, Toe mpañenga-an-dio amako irehe! ");
INSERT INTO tdx_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Aa le na­votso’e vaho nanao ty hoe i rakembay, Ty valiko an-dio ty amy savatsey. ");
INSERT INTO tdx_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Hoe t’Iehovà amy Aharone, Akia mb’ am-patram­bey añe hifanalaka amy Mosè. Aa le nimb’eo re nifanalaka ama’e am-bohin’ Añahare eo vaho norofa’e. ");
INSERT INTO tdx_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Nita­roñe’ i Mosè amy Aharone ze hene nitsarae’ Iehovà nañirak’ azey vaho i viloñe iaby nafanto’e ama’e rezay. ");
INSERT INTO tdx_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Nimb’ eo amy zao t’i Mosè naho i Aharone nanontoñe ze hene androanavi’ o ana’ Israeleo; ");
INSERT INTO tdx_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","le nisaontsie’ i Aharone o nitsa­rae’ Iehovà amy Mosè iabio vaho nanoe’e am-pahaisaha’ ondatio o viloñeo. ");
INSERT INTO tdx_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Niantoke ondatio, aa naho jinanji’ o ana’ Israeleo te nisary iareo t’Iehovà naho nivazohoe’e ty fisotria’ iareo, le niondreke vaho nitalaho. ");
INSERT INTO tdx_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Tampetse izay le niheo mb’amy Parò mb’eo t’i Mosè naho i Aharone, nanao ty hoe, Hoe t’Iehovà Andrianañahare’ Israele: Angao haña­velo mb’eo ondatikoo hanoe’ iereo sabadidak’ amako am-patrambey añe. ");
INSERT INTO tdx_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Aa hoe t’i Parò, Ia ze o Iehovà zao te ho haoñeko ty feo’e hampiavotako Israele. Amoeako ze o Iehovà zao vaho tsy hapoko hionjoñe ka t’Israele. ");
INSERT INTO tdx_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Le hoe iereo, Nifañaoñe ama’ay t’i Andrianañahare’ o nte-Evreo; aa le hañavelo lia telo andro mb’ ampatrañe añe zahay hisoroñe am’ Iehovà Andria­nañahare’ay, tsy mone hampiambotraha’e am’ angorosy ndra fibara. ");
INSERT INTO tdx_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Fe hoe ty mpanjaka’ i Mitsraime am’ iereo. O Mosè naho Aharone, inom-bao ty ham­pi­sitahañe ondatio amo fitoloña’eo? Mimpolia amo fijinia’areoo! ");
INSERT INTO tdx_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Tinovo’ i Parò ty hoe, Ingo te maro t’indaty an-tane ao henaneo vaho ipaia’ areo hitroatse tsy hitoloñe! ");
INSERT INTO tdx_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Aa le linili’ i Parò amy andro zay amo mpanao bozizi’ iareoo naho amo mpisari’ iareoo, ty hoe: ");
INSERT INTO tdx_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Tsy hatolotse ahetse ka ondatio fe hamboatse birike mira amy teoy; angao hatonto’ iareo ze ahetse paiaeñe. ");
INSERT INTO tdx_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Le ­ampano’ areo birike mira amy nanoeñe taoloy, tsy haketrake, amy t’ie votro, izay ty mampitoreo iareo ami’ty hoe: Apoho hiavotse añe hisoroñe aman’ Añahare’ay. ");
INSERT INTO tdx_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Anovoño asa ondatio, hifanehafa’ iareo tsy hi­tsa­nom-bolam-bande. ");
INSERT INTO tdx_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Aa le niakatse mb’eo o mpanao bozizio naho o mpisari’ ondatioo, nanao ty hoe am’ondatio, Hoe t’i Parò, Tsy hitolorako ahetse. ");
INSERT INTO tdx_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Akia, atontono ahetse amy ze hahatendreha’ areo, fe tsy haketrake ty fitoloña’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Aa le fonga niparaitak’ an-tane Mitsraime ao ondatio nanontone tain-ava hasolo i bokay. ");
INSERT INTO tdx_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Tinaentae’ o mpanao bozizio ka ami’ty hoe, Henefo ty fitoloña’ areo lomoñandro ho mira amy fasiañ’ ahetse teoy. ");
INSERT INTO tdx_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Finofoke ka o talèm-pitoloña’ o ana’ Israele najado’ o mpanao bozizi’ i Paròo am’ iareoo, ami’ty hoe, Akore te tsy nihenefa’ areo anindroany naho omale ty lili’areo amo birike manahake te taoloo? ");
INSERT INTO tdx_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Aa le niheo mb’amy Parò mb’eo o talè ana’ Israeleo nitoreo ty hoe, Ino ty anoa’o hoe zao o mpitoro’oo? ");
INSERT INTO tdx_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tsy ho tolorañe boka o mpitoro’oo, fa hoe iereo ama’ay, Mañamboara birike! Hehe te finofoke zahay vaho manao hakeo ondati’oo. ");
INSERT INTO tdx_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Hoe re, Mikopiso avao ty tembo retia, izay ty atao’ areo ty hoe, Angao hisoroñe amy Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Akia, arè, mitromaha fe tsy homeañe ahetse vaho mbe hasese’ areo ty anjara’ birike. ");
INSERT INTO tdx_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nirendre’ o talè, ana’ Israeleo, t’ie am-poheke amy saontsi’ey, ty hoe, Tsy haketra’ areo ty anjara birike lomoñandro. ");
INSERT INTO tdx_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ie nienga i Parò, le nifanjò amy Mosè naho i Aharone nijohañe ey hifanalaka am’iereo, ");
INSERT INTO tdx_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","vaho hoe ty nanoa’ iareo, Ee t’ie ho vazohoe’ Iehovà naho hizaka! Akore ty nañaimboa’ areo anay am-pihaino’ i Parò naho am-pihaino o mpitoro’eo, hanolorañe fibara am-pità’ iareo hañohofa’e loza. ");
INSERT INTO tdx_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Nitolik’ am’ Iehovà indraike t’i Mosè nanao ty hoe, Ry Talè, akore ty fanilofañe ondaty retoañe? Ino o namantoha’o ahio? ");
INSERT INTO tdx_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Fa boak’ ami’ty niheovako amy Parò hivolañe amy tahina’oy, le nanoe’e samporerake ondaty retoa vaho tsy rinomba’o ondati’oo. ");
INSERT INTO tdx_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Aa le hoe t’Iehovà amy Mosè, Mahaoniña henaneo ty hanoako amy Parò. Eka, fitàñe maozatse ty hampienga’e iareo, sirañe ­fatratse ty handroaha’e an-tane’e. ");
INSERT INTO tdx_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mbe nitsara amy Mosè t’i Andria­nañahare nanao ty hoe: Izaho Iehovà, ");
INSERT INTO tdx_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ty niboak’ amy Avrahame naho am’ Ietsàke naho amy Iakòbe ami’ty hoe El-Sadai, fe tsy nitoñom-batañe am’iareo ami’ty hoe: Iehovà’. ");
INSERT INTO tdx_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Toe norizako am’ iereo ty fañinako, hano­lorako ty tane Kanàne, i tane fañaveloa’ iareo toe nañialoa’ iareo. ");
INSERT INTO tdx_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Fe tsinanoko ty fiñeoñeo’ o ana’ Israeleo ty amy fañondevoza’ o nte-Mitsraimeoy vaho nitiahiko i fañinakoy. ");
INSERT INTO tdx_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Anò ty hoe arè amo ana’ Israeleo: Izaho Iehovà, le havotsoko boak’ ambane’ ty fampijinia’ o nte-Mitsraimeo naho habalako o fandrohizañeo vaho ho jebañeko an-tsira natora-kitsy, an-jaka ra’elahy. ");
INSERT INTO tdx_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ho rambeseko h’ondatiko vaho ho Andrianañahare’ areo iraho. Ho fohi’ areo te izaho Iehovà Andrianañahare’ areo, ty mampienga anahareo ami’ty fampijinia’ o nte Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Le hendeseko mb’ an-tane nañonjonako sirañe hanolorako aze amy Avrahame naho am’ Ietsàke vaho am’ Iakòbe añe; le hatoloko anahareo ho fanañañe, Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Le nisaontsy amo ana’ Israeleo t’i Mosè, fa tsy nihaoñe’ iareo t’i Mosè, ty amy fikoretan’ arofo naho i fampisoañam-pañondevozañey. ");
INSERT INTO tdx_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Aa hoe t’Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Akia, saontsio amy Parò, mpanjaka’ i Mitsraime, ty hampiavota’e an-tane’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Aa hoe ty asa’ i Mosè am’ Iehovà, Kanas tsy nañaoñe ahiko o ana’ Israeleo, akore ty hijanjiña’ i Parò, izaho aman-tsoñy tsy nisavareñe? ");
INSERT INTO tdx_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Aa le nitsara amy Mosè naho i Aharone t’Iehovà, nanolotse lily ho amo Ana’ Israeleo naho ho amy Parò mpanjaka’ i Mitsraime, hampiavotañe an-tane Mitsraime ao o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Inao o talèn’ anjomban-droaeo: o ana’ i Reòbene, tañoloñoloña’ Isra­eleo: i Kanòke naho i Palò naho i Ketsròne vaho i Karemý; irezay ro fifokoa’ i Reòbene. ");
INSERT INTO tdx_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","O ana’ i Simoneo: Iemoèle naho Iamìne naho i Ohade naho Iakìne naho i Tsòkare vaho i Saòle ana’ ty rakemba nte-Kanàne; ie ro fifokoa’ i Simone. ");
INSERT INTO tdx_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Irezao ka o tahinan’ ana’ i Levio ty amo fifokoa’eo: i Geresòne naho i Kehàte vaho i Merarý; le ni-zato tsy telopolo fito amby taoñe ty halava havelo’ i Levy. ");
INSERT INTO tdx_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","O ana’ i Geresoneo: i Libný naho i Semý, amo fifokoa’eo. ");
INSERT INTO tdx_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","O ana’ i Kehàteo: i Amràme naho Iitshàre naho i Kebrone vaho i Ozièle le ni-zato-tsi-telopolo-telo amby ty taon-kavelo’ i Kehàte. ");
INSERT INTO tdx_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","O ana’ i Merarìo: i Maklý naho i Mosý, ie ro fifokoa’ i Merarý hasavereña’ i Levý. ");
INSERT INTO tdx_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Nañenga’ Iokèbede rahavaven-drae’e t’i Amrame vaho nahatoly i Aharone naho i Mosè, le niveloñe zato-tsi-telopolo taoñe fito amby t’i Amrame. ");
INSERT INTO tdx_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","O ana’ Iitshàreo: i Koràke, i Nèfege vaho i Zikrý. ");
INSERT INTO tdx_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","O ana’ i Ozièleo, i Misaèle naho i Elitsafàne vaho i Sitrý. ");
INSERT INTO tdx_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Nañenga i Elisèbae ana’ i Aminadabe, rahavave’ i Naksòne t’i Aharone le nisamaha’e i Na­dabe naho i Abihò, i Elazare vaho Itamare. ");
INSERT INTO tdx_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","O ana’ i Korakeo: i Asire naho i Elkanà vaho i Abiasàfe; ie ro hasavereña’ o nte-Koràkeo. ");
INSERT INTO tdx_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Nañenga amo ana’ i Potièleo t’i Elazare ana’ i Aharone, le nisamaha’e t’i Pinekase. Ie ro anjomban-droae’ o nte-Levio amo fifokoa’eo. ");
INSERT INTO tdx_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ie i Aharone naho i Mosè nitsa­rà’ Iehovà ty hoe, Ampiengao an-tane Mitsraime ampoko-ampoko o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ie ro nisaontsy amy Parò mpanjaka’ i Mitsraime hampiavotse o ana’ Israeleo an-tane Mitsraime, toe i Mosè naho i Aharone izay. ");
INSERT INTO tdx_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Ie amy andro nitsarà’ Iehovà amy Mosè an-tane Mitsraimey, ");
INSERT INTO tdx_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","le nanao ty hoe amy Mosè t’Iehovà: Izaho Iehovà, hene saontsio amy Parò mpanjaka’ i Mitsraime ze taroñeko ama’o. ");
INSERT INTO tdx_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Aa hoe t’i Mosè añatrefa’ Iehovà, Ino ty hijanjiña’ i Parò ahiko, izaho aman-tsoñy tsy afa-boiñeo? ");
INSERT INTO tdx_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Hoe t’Iehovà amy Mosè, Hehe t’ie najadoko ho fanalolahy amy Parò, vaho ho mpitoki’o t’i Aharone rahalahi’o. ");
INSERT INTO tdx_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Hene isaontsio ze taroñeko ama’o, le i Aharone rahalahi’o ty hisaontsy amy Parò hampiavote’e an-tane’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Fe ho gàñeko hey ty arofo’ i Parò hampitomboako an-tane Mitsraime ao o vilokoo naho o hala­tsàko. ");
INSERT INTO tdx_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Toe tsy hañaoñe anahareo t’i Parò, le hapaoko amy Mitsraime ty tañako vaho hampiavoteko an-tane Mitsraime an-jaka ra’elahy o valobohòkoo, ondatikoo, o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ho fohi’ o nte-Mitsraimeo te Izaho Iehovà, naho ahitiko amy Mitsraime ty sirako hampiavoteko boak’ am’ iereo ao o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Aa le nanoe’ i Mosè naho i Aharone; ze nandilia’ Iehovà iareo ty nanoe’ iereo. ");
INSERT INTO tdx_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ni-valom-polo taoñe t’i Mosè naho aman-taoñe valom-polo-telo’ amby t’i Aharone t’ie nisaontsy amy Parò. ");
INSERT INTO tdx_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Hoe ty tsara’ Iehovà amy Mosè naho i Aharone, ");
INSERT INTO tdx_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Ie anoa’ i Parò ty hoe, Ampiboaho raha tsitantane, le hoe ty ho asa’o amy Aharone, Rambeso ty kobai’o vaho afetsaho añatrefa’ i Parò hinjarea’e fañaneñe. ");
INSERT INTO tdx_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Aa le nimb’ amy Parò mb’eo t’i Mosè naho i Aharone, le nanoe’ iereo i nandilia’ Iehovày; nafetsa’ i Aharone añatrefa’ i Parò naho aolo’ o mpitoro’eo i kobai’ey vaho ninjare bajy. ");
INSERT INTO tdx_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kinai’ i Parò amy zao ondaty mahihitseo naho o mpamorekeo vaho nitoloñe an-tsahàtse o ambiasa’ i Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Songa nañifi-kobaiñe ambane eo vaho ninjare mereñe, le sindre natele’ ty kobai’ i Aharone o kobai’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Fe niha­gàñe avao ty arofo’ i Parò, tsy hinao’e iareo, amy nitsarae’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Le hoe t’Iehovà amy Mosè, gañe ty arofo’ i Parò; ie mifoneñe tsy hampienga ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Aa le akia, mb’ amy Parò mb’eo maraindray t’ie miavotse mb’an-drano mb’eo, le tintino am-pità’o i kobaiñe nampanjarieñe fañaneñey, ");
INSERT INTO tdx_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","le isaontsio ty hoe, Nañirak’ ahy homb’ ama’o mb’ etoa t’Iehovà, Andrianañahare’ o nte-Evreo hinday o entañe zao: Apoho hañavelo ondatikoo, hitoroñe ahy am-patrambey añe. Inao t’ie mbe tsy nañaoñe pake henane. ");
INSERT INTO tdx_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Aa hoe ty nitsarae’ Iehovà, Zao ty hahafohina’o te izaho Iehovà. Inao, havangoko amo rano amy sàkaio ty kobaiñe an-tañako toy, hiova’e ho lio. ");
INSERT INTO tdx_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ho mate ze fiañe amo sàkao le hitrotròtse i sàkay vaho hampangorý o nte-Mitsraimeo ty hinon-drano amy sàkay. ");
INSERT INTO tdx_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Aa hoe t’Iehovà amy Mosè, Saontsio t’i Aharone, Rambeso o kobai’oo le ahitio ambone’ o rano’ i Mitsraimeo ty fità’o, ambone’ o saka’eo naho o talaha’eo naho o sihana’eo vaho ze hene kiantara-antaran-drano’e, hiova’e ho lio, le lio avao ty hanitsike ty tane Mitsraime, ndra an-tsajoa hatae ndra am-bato. ");
INSERT INTO tdx_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Nanoe’ i Mosè naho i Aharone hambañe amy nandilia’ Iehovày. Naon­jo’e am-pahaisaha’ i Parò naho o mpi­toro’eo i kobai’ey vaho trinàbo’e ty rano amy sakay, le niova ho lio ze hene rano amy sakay; ");
INSERT INTO tdx_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","nimate o fiañe amy sakaio, le nañantifofotse i sakay naho tsy nahay nikama ty rano’ i sàkay o nte-Mitsraimeo fa nitsitsike lio ty tane Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Fe tsinikombe’ o ambiasa’ i Mitsraimeo an-tsahàtse, le nihagàñe ty arofo’ i Parò naho nihiritsirita’e, amy ni­tsarae’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Te mone nitolike t’i Parò, nimoak’ añ’anjomba’e ao, tsy nihaoñe’ ty arofo’e i raha zay. ");
INSERT INTO tdx_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Aa le fonga nihaly vovoñe añ’olo’ i sàkay o nte-Mitsraimeo, fa tsy nimete nòmeñe ty rano’ i sàkay. ");
INSERT INTO tdx_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Ie nimodo ty fito andro le nipaoha’ Iehovà i sàkay, ");
INSERT INTO tdx_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","le ni­tsara amy Mosè t’Iehovà, Akia miheova mb’ amy Parò mb’eo vaho ano ty hoe ama’e, Hoe ty tsinara’ Iehovà: Ampiavoto ondatikoo, hitoroñe ahiko. ");
INSERT INTO tdx_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Aa ie mitoky, tsy hampienga, le inao, ho tsitsifeko sahoñe o tane’oo. ");
INSERT INTO tdx_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Hifamorohotse amy Nailey o sahoñeo. Hiakatse boak’ao hizilik’ añ’ anjomba’o ao naho an-traño firota’o ao naho am-pandrea’o ao naho añ’ anjomba’ o mpitoro’oo naho amo ondati’oo naho amo fanokona’oo vaho amo finga fitroboan-kobao. ");
INSERT INTO tdx_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Hanganik’ ama’o naho am’ondati’oo vaho amo mpitoro’oo o sahoñeo. ");
INSERT INTO tdx_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Le hoe t’Iehovà amy Mosè, Saon­tsio t’i Aharone, Ahitio ambone’ o torahañeo naho o talahao vaho o antarao ty fità’o rekets’ i kobai’oy hampiakatse o sahoñeo mb’an-tane Mitsraime mb’eo. ");
INSERT INTO tdx_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Aa le natora-kitsi’ i Aharone ambone’ o rano’ i Mitsraimeo ty fità’e vaho nitroatse mb’an-tamboho mb’eo o sahoñeo nanafotse ty tane Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Fe tsinikombe’ o ambiasao amo sahà’ iareoo, le nañakatse sahoñe an-tane Mitsraime ka. ");
INSERT INTO tdx_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Nikanjie’ i Parò t’i Mosè naho i Aharone le nanao ty hoe: Mihalalia am’Iehovà te hakareñe amako naho am’ ondatikoo o sahoñeo vaho hengako homb’eo ondatio hisoroñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Hoe ty Mosè amy Parò, Inao ty engeñe atoloko azo: Ombia ty hihalaliako ho azo naho o mpitoro’oo naho ondati’oo te hasoike ama’ areo vaho añ’ anjomba’ areo o sahoñeo, hampipoke iareo amy sàkay avao? ");
INSERT INTO tdx_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Le hoe re, Hamaray. Hoe t’i Mosè, Ie o sinaontsi’oo! Hahafohina’o te tsy amam-pañirinkiriñe aze t’Iehovà Andria­nañahare’ay. ");
INSERT INTO tdx_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ie misitak’azo naho o anjomba’oo naho o mpitoro’oo naho ondati’oo, le hidok’ amy sàkay avao. ");
INSERT INTO tdx_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Nienga i Parò amy zao t’i Mosè naho i Aharone vaho nikaike Iehovà t’i Mosè ty amo sahoñe nitsobore’ i Paròo. ");
INSERT INTO tdx_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Le nanoe’ Iehovà i nihalalie’ i Mosèy, nimate añ’ anjomba ao o sahoñeo naho an-kiririsa ey naho an-tetek’ ao. ");
INSERT INTO tdx_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Aa le natonto’ iareo an-kivotri-kivotry ampara’ te nitrotròtse i taney. ");
INSERT INTO tdx_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Aa naho nioni’ i Parò t’ie nikepake le nampientetse arofo, nihiri­tsiritse am’ iereo, amy nitsara’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Le hoe t’Iehovà amy Mosè, Anò ty hoe amy Aharone, Ahitio o kobai’oo vaho paoho ty lembo’ o taneo, hanjaria’e boròm-pìhetse hanitsike ty tane’ i Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Nanoe’ iereo; nahiti’ i Aharone ty fità’e reke-kobaiñe vaho pinao’e ty debo’ i taney, le nirodañe am’ ondatio naho amo hàreo ty boròm-pìhetse, ze atao debok’ an-tane eo fonga ninjare boròm-pìhetse nanitsike ty tane Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Nimanea’ o ambiasao ty hañakatse boròm-pìhetse amo sahà’ iareoo fe tsy nahalefe. Nipetak’ am’ondatio naho amo hareo o boròm-pìhetseo. ");
INSERT INTO tdx_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Le hoe o ambiasao amy Parò, Rambom-pitàn’ Añahare toy! fe nihagàñe avao ty arofo’ i Parò le tsy nihaoña’e, izay ty nitsara’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Le hoe t’Iehovà amy Mosè, Maña­leñaleña le mijohaña añatrefa’ i Parò, t’ie miavotse mb’an-drano mb’eo vaho ano ty hoe, Hoe ty tsi­nara’ Iehovà: Angao hiavotse mb’eo ondatikoo hitalaho amako. ");
INSERT INTO tdx_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Aa hera tsy hengà’o homb’eo ondatikoo, le haropako ama’o ty laletse mifamorohotse naho amo mpitoro’oo naho am’ondati’oo naho añ’anjomba’ areo ao, le hifamorohotse añ’ anjomba’ o nte-Mitsraimeo o laletseo vaho an-tane ijohaña’ iareo. ");
INSERT INTO tdx_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Fe haviko amy andro zay ty tane Gosena imoneña’ ondatikoo, tsy hiropahan-daletse, hahafohina’o te añivo ty tane atoy iraho, Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Eka, hampijadoñako jebañe añivo’ ondatikoo naho on­dati’oo. Hipoteake maray i viloñe zay. ");
INSERT INTO tdx_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Nanoe’ Iehovà, le havasiañan-dale-dero ty nifoak’ añ’ anjomba’ i Parò naho añ’ an­jomba’ o mpitoro’e iabio; vaho hene nampiantoe’ i fifamorohotan-daletsey ty tane Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kinoi’ i Parò amy zao t’i Mosè naho i Aharone le nanao ty hoe, Akia, misoroña aman’ Añahare’ areo an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Aa hoe t’i Mosè, Tsy mete t’ie hanoe’ay fa sirika amo nte-Mitsraimeo o fisoroña’ay am’ Iehovà Andrianañahare’aio. Aa naho isoroña’ay am-pahaisaha’ o nte-Mitsraimeo ty raha tiva, tsy ho fetsahe’ iareo vato hao? ");
INSERT INTO tdx_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Hañavelo telo andro mb’ am-patrambey añe zahay, hisoroñe am’ Iehovà Andria­nañahare’ay, amy ze hitsarae’e ama’ay. ");
INSERT INTO tdx_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Aa le hoe t’i Parò, Hengako hiavotse mb’ am-patram­bey ao nahareo hisoroñe am’ Iehovà Andrianañahare’ areo naho tsy loho lavitse ty añaveloa’ areo. Mihalalia ho ahiko. ");
INSERT INTO tdx_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Le hoe t’i Mosè, Vata’e mienga azo iraho le hihalaly am’ Iehovà te hasitake amy Parò naho amo mpitoro’eo vaho am’ondati’eo hamaray o laletse mifamoroho­tseo le asoao tsy ho fañahie’ i Parò avao, tsy hampienga’e hisoroñe am’ Iehovà ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Aa le nienga i Parò t’i Mosè vaho nihalaly am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Le nanoe’ Iehovà i nihalalie’ey: nafaha’e amy Parò naho amo mpitoro’eo naho am’ on­dati’eo o laletse nifamoroho­tseo, leo raike tsy napoke. ");
INSERT INTO tdx_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Le mbe nampientere’ i Parò ty arofo’e henane zay, tsy nenga’e hiavotse ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Le hoe t’Iehovà amy Mosè, Miziliha amy Parò ao le ano ty hoe, Hoe t’Iehovà Andrianañahare’ o nte-Evreo: Ampiengao ondatikoo hitoroñe ahy. ");
INSERT INTO tdx_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Aa naho tsy apo’o hañavelo, fa mbe itambozore’o, ");
INSERT INTO tdx_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","le ingo ho amo hare’oo ty fità’ Iehovà, amo an-kivokeo, amo soavalao, amo borìkeo, amo ramevao, amo lia-raikeo naho amo añombeo ty kolàñe mandrokènkañe. ");
INSERT INTO tdx_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Fe hampi­am­bahe’ Iehovà o hare’ Isra­eleo, amo hare’ i Mitsraimeo, le ndra inoñ’ inoñ tsy ho mate amo ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Nifotoañe’ Iehovà ami’ty hoe, Hamaray te hanoe’ Iehovà i hoe zay an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Aa le nanoe’ Iehovà amy loak’androy; fonga niatantiry ty hare’ i Mitsraime, fe leo raik’ amo hare’ o ana’ Israeleo tsy nimate. ");
INSERT INTO tdx_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nampañontane t’i Parò le nirendre’e te ndra raik’ amo haren’ ana’ Israeleo tsy nimate; fe nientetse ty arofo’ i Parò vaho tsy nampiengae’e mb’eo ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Le hoe t’Iehovà amy Mosè naho amy Aharone, Songa mangalà lavenoke mahapea fitàñe boak’ an-toñak’ ao le habobò’ i Mosè mb’ andikeram-beo am-pahaisaha’ i Parò; ");
INSERT INTO tdx_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","le hinjare deboke era’ i tane Mitsraimey, le hampitovoañe bae mangorakorake amy ze ondaty naho biby hanitsike an-tane Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Aa le nandrambe lavenok’ an-toñak’ ao iareo naho nijohañe añatrefa’ i Parò naho nadoveve’ i Mosè an-tioke izay vaho nampitovoañe bae am’ondatio naho amo bibio. ");
INSERT INTO tdx_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Tsy nahafijohañe añatrefa’ i Mosè o ambiasao ty amo baeo, fa nipetak’ amo ambiasao naho amo nte-Mitsraime ila’eo ka o baeo. ");
INSERT INTO tdx_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Fe nampijadiriñe’ Iehovà ty arofo’ i Parò vaho tsy nihaoña’e, amy tsinara’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Le hoe t’Iehovà amy Mosè, Mañaleñalèña, le mijohàña añatrefa’ i Parò vaho anò ty hoe, Hoe t’Iehovà, Andrianañahare’ o nte-Evreo: Ampiengao ondatikoo, hitalaho amako. ");
INSERT INTO tdx_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Aa ie henane zao, hahitriko an-tro’o ao naho amo roan­dria’oo vaho amo on­dati’oo ze hene tolom-boiñe amako, haha­fohina’o te tsy eo ty mañirin­kiriñe ahy an-tane-bey atoy. ");
INSERT INTO tdx_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Aa naho nahitiko henaneo ty tañako, hipaok’ azo naho ondati’oo ami’ty angorosy le ho naito an-tane atoy, ");
INSERT INTO tdx_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","fe toe nadoko, soa te ihe ty hampiboahañe ty haozarako le hanitsike ty tane toy ty fitaroñañe ty añarako. ");
INSERT INTO tdx_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ie amy zao, hiebotsebotse am’ ondatikoo hao? tsy hampiengà’o. ");
INSERT INTO tdx_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Aa ie hamaray hoe zao, le hampigada­boñeko havandra jabajaba te amy ze mbe lia’e tsy nizoeñe e Mitsraime ao mifototse ami’ty andro nañorizañe aze pake henaneo ");
INSERT INTO tdx_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Mampihitrifa arè, le ampipaliro ze hare’o naho ze raha’o an-kivok’ ao, fa hivalenkañe ze ondaty ndra biby zoeñe an-diolio ey tsy nampolieñe, t’ie idoindoiña’ i havandray. ");
INSERT INTO tdx_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ze mpitoro’ i Parò nihembañe amy tsara’ Iehovày, songa nihenekeneke nampipalitse o mpitoro’eo naho o hàre’eo. ");
INSERT INTO tdx_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Fe ze tsy nañaoñe ty tsara’ Iehovà ka, le nado’e an-kivok’ añe avao o mpitoro’eo naho o hàre’eo. ");
INSERT INTO tdx_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Hoe t’Iehovà amy Mosè, Ahitio mb’ an­dikerañe ey ty fità’o hampiponake havandra era’ ty tane Mitsraime, amy ze ondaty naho biby vaho ze hene hatae an-kivok’ ey, an-tane Mitsraime ao. ");
INSERT INTO tdx_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Aa le nampitakare’ i Mosè mb’ andikerañey ty kobai’e le nampidoindoiñe’ Iehovà ty àmpiñe naho havandra vaho nirifatse mb’an-tane mb’eo ty afo. Le nampigadabòñe’ Iehovà havandra an-tane Mitsraime ao; ");
INSERT INTO tdx_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","havandra nibilobiloen-kelatse añivo’e ao, figada­bon-kavandra mbe lia’e tsy nideboñe an-tane Mitsraime ao sikal’ amy te nififeheañe. ");
INSERT INTO tdx_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Zinama’ i havandray ze hene an-tameañe an-tane Mitsraime ao ndra ondaty ndra hare; fonga navita­vita’e ze rongoñe a montoñe ao vaho fonga pinozapoza’e o hatae an-kivokeo. ");
INSERT INTO tdx_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Fe tsy nipaohen-ka­vandra o Ana’ Israeleo an-tane Gosenao. ");
INSERT INTO tdx_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Aa le kinoi’ i Parò t’i Mosè naho i Aharone le nanoa’e ty hoe, Toe nandilatse iraho henaneo; Iehovà ro vantañe vaho aman-tahin-draho naho ondatikoo. ");
INSERT INTO tdx_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Mihalalia am’ Iehovà! Ampihankaño o hotroke naho havandran’ Añahareo! Le hampiengako, le tsy hampitam­batse anahareo ka. ");
INSERT INTO tdx_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Hoe t’i Mosè ama’e, Ie vata’e miakatse ty rova toy le hahitiko mb’ am’ Iehovà o tañakoo vaho hijihetse i àmpiñey le tsy ho eo i havandray, haharendreha’o te a Iehovà ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Fa ihe naho o mpitoro’oo, apotako te mboe tsy mañeveñe am’ Iehovà Andrianañahare avao. ");
INSERT INTO tdx_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","(Ie amy zao, fa nianto iaby ty vare-leny naho ty vare-hordea, fa niregorego i hordeay vaho namòñe i vare-leniy. ");
INSERT INTO tdx_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Fe tsy nijoieñe ty vare-bolè naho ty bolè-lahi’e fa malaom-pitovoañe.) ");
INSERT INTO tdx_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Aa le niavotse boak’ amy Parò t’i Mosè, niakatse i rovay. Nahiti’e mb’ amy Iehovà o fità’eo le songa nijihetse i àmpiñey naho i havandray vaho tsy nampikojojoahañe an-tane i orañey. ");
INSERT INTO tdx_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Aa vata’e nioni’ i Parò te nijihetse i orañey naho i havandray naho i àmpiñey le mbe nanovon-kakeo; nampigañe’e ty arofo’e, ie naho o mpitoro’eo. ");
INSERT INTO tdx_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Aa le niha-jadiriñe ty arofo’ i Parò le tsy nampiengae’e o ana’ Israeleo, amy tsinara’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Le hoe t’Iehovà amy Mosè, Akia mb’ amy Parò mb’eo, amy te nampigañeko ty arofo’e naho ty tro’ o mpitoro’eo, hampipohako añivo’ iareo ao o viloko retoañe, ");
INSERT INTO tdx_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","haha­fitalilia’o amo ana’oo naho amo àfe’oo o raha nanoeko e Mitsraimeo naho o viloñe nitoloñeko añivo’ iereoo, hahafohina’ areo te izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Aa le niheo mb’amy Parò mb’eo t’i Mosè naho i Aharone, le nanao ty hoe ama’e, Hoe ty tsara’ Iehovà, Andria­nañahare’ o nte-Evreo, Pak’ ombia ty mbe hitokia’o tsy hirèke añatrefako? Ampiengao ondatikoo hitoroñe ahiko. ");
INSERT INTO tdx_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Fa naho mifonen-drehe tsy hampiavotse ondatikoo, le hampi­votrahako valala an-tane’ areo etoy te maray. ");
INSERT INTO tdx_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ho kopofe’e ty maso’ i taney tsy hahaisaha’ iaia o taneo, le habotse’e ty sisa nahafipoliotse, o nasisa’ i havandraio vaho havorembore’e ze hatae’areo mamoa an-kivoke ey. ");
INSERT INTO tdx_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Hatsefe’e amo anjomba’oo naho o anjom­bam-pitoro’e naho ty amo hene nte-Mitsraimeo, ie mboe tsy niisan-droae’o ndra o roaen-droae’oo mifototse ami’ty andro naha-tan-tane atoy iareo pake henaneo. Nitolik’ amy zao re nienga i Parò. ");
INSERT INTO tdx_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Hoe o mpitoro’’ i Paròo ama’e, Pak’ ombia t’ie mbe ho fandrik’ aman­tika? Ampiengao ondatio hitoroñe Iehovà Andrianañahare’e; mbe tsy rendre’o hao te mianto t’i Mitsraime? ");
INSERT INTO tdx_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Aa le nampibaliheñe mb’amy Parò mb’eo t’i Mosè naho i Aharone vaho hoe re tama’e, Akia, toroño t’Iehovà Andria­nañahare’ areo! Le ia naho ia ty homb’eo? ");
INSERT INTO tdx_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Hoe t’i Mosè, Hindre lia ama’ay o keleia’aio naho o bei’aio; rekets’ o ana-dahi’aio naho o anak’ampela’aio vaho hitraok’ ama’ay o mpirai-lia’aio naho o añombe’aio, hanoe’ay sabadidak’ am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Hoe re tam’ iereo, Toe hitahy anahareo t’Iehovà naho hengako hindre lia ama’ areo o keleia’ areoo! Hehe ty fikitrohan-draty aolon-dahara’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Aiy avao! O lahilahio avao ty hañavelo mb’eo henaneo hitoroñe Iehovà, fa izay ty nipaia’ areo. Le sinoike mb’eo iereo hidisak’ ami’ty fiatrefañe i Parò. ");
INSERT INTO tdx_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Le hoe t’Iehovà amy Mosè, Ahitio ambone’ o tane Mitsraimeo ty fità’o, hivotraha’ o valalao, hipetaha’ iareo an-tane Mitsraime, hampibotseke ze he’e mitiry an-tane eo, ze nisisa’ i havandray. ");
INSERT INTO tdx_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Aa le nahiti’ i Mosè ambone’ tane Mitsraime i kobai’ey vaho ninday tiok’ atiñanañe amy taney amy lomoñàndroy naho amy haleñe iabiy t’Iehovà; ie nanjirike i àndroy le fa nonjone’ i tiok’ ati­ñanañey mb’eo o valalao. ");
INSERT INTO tdx_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Le nionjoñe nanitsike ty tane Mitsraime o valalao, nandrambañe ty fifaritsoha’ i Mitsraime ty nipetaha’ iareo, nitozantozañe; mboe lia’e tsy nizoem-pifamorohotam-balala hoe zay vaho tsy ho zoeñe ka. ");
INSERT INTO tdx_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Natsahe’e ty maso’ i taney, le nikò-maieñe i taney; naho fonga nabotse’e ze niniñaniña amy taney naho ze voan-katae nisisa’ i havandray vaho tsy nanisa raha antsetra an-katae ndra an-drongoñe an-kivoke ndra aia’aia an-tane Mitsraime ao iaby. ");
INSERT INTO tdx_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kinoi’ i Parò amy zao t’i Mosè naho i Aharone le nanao ty hoe, Toe nanao hakeo amy Iehovà Andrianañahare’ areo naho ama’ areo iraho. ");
INSERT INTO tdx_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Aa le miambane ama’o ty hiheve ami’ty henane toy i hakeokoy vaho halalio am’ Iehovà Andrianañahare’ areo te ha­fahañe amako ty fihomahañe toy avao. ");
INSERT INTO tdx_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Nienga i Parò re, nihalaly am’ Iehovà; ");
INSERT INTO tdx_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Nafote’ Iehovà i tiokey ho tio-bey hirik’ ahandrefañe; nongaha’ i tiokey o valalao vaho sinoi’e mb’amy Riam-Binday añe; leo raike amo valalao tsy napoke an-tane Mitsraime ao iaby. ");
INSERT INTO tdx_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Fe nampi­entere’ Iehovà ty arofo’ i Parò, le tsy nampi­engae’e mb’eo o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Aa le hoe t’Iehovà amy Mosè, Ahitio mb’andikeram-b’eo ty fità’o hañatseke ty hamoromoroñe an-tane Mitsraime ao, ieñe mete tsapaeñe. ");
INSERT INTO tdx_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Aa le nahiti’ i Mosè mb’andindìñey ty fità’e, le nandrambañe ty tane Mitsraime telo andro ty hamoromoroñe. ");
INSERT INTO tdx_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Songa tsy nahay nifañisake, naho sindre tsy naha-ongake telo andro amy nidona’ey; fe amo hene ana’ Israeleo le nazava amo kiboho’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Aa le kinoi’ i Parò t’i Mosè nanao ty hoe, Akia, toroño t’Iehovà. Fe apoho atoy o lia-rai’ areoo naho o mpirai-tro areoo. Mete hindre ama’o o keleia’ areoo. ");
INSERT INTO tdx_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Aa hoe t’i Mosè, Tsi-mete tsy hatolo’o ty hisoroñañe naho ty ho èngan-koroañe, hañalankaña’ay ho am’ Iehovà Andrianañahare’ay. ");
INSERT INTO tdx_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Aa le hindre lia ama’ay o hare’aio; leo tombo’e raike tsy hapo’ay, fa hendese’ay hitoroñe Iehovà Andrianañahare’ay, tsy apota’ay te inoñe ty hitoroña’ay Iehovà naho tsy fa pok’añe. ");
INSERT INTO tdx_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Fe nampigañe’ Iehovà ty arofo’ i Parò vaho tsy nisatrie’e ty hampienga iareo. ");
INSERT INTO tdx_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Le hoe ty Parò tama’e, Soik’ añe! Misitaha amako! Mitaoa tsy ho isa’o ka ty tareheko, fa amy andro hahaisaha’o azey ty hihomaha’o. ");
INSERT INTO tdx_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Hoe ty Mosè, Soa i saontsi’oy! Tsy ho treako ka o lahara’oo. ");
INSERT INTO tdx_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Hoe t’Iehovà amy Mosè, Ho tovoñako feh’ohatse raike amy Parò naho i Mitsraime, izay vaho hapo’e hienga nahareo, eka, hampiavote’e vaho vata’e hatao’e soike. ");
INSERT INTO tdx_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Saontsio an-dravembia ondatio te songa hihalaly, sindre ondaty amo mpirai-tanañe ama’eo, fanake volafoty naho fanake volamena. ");
INSERT INTO tdx_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Toe nampañisohe’ Iehovà ampahaisaha’ o nte Mitsraimeo ondatio. Mbore nilahitsiay an-tane Mitsraime ao t’i ondaty Mosè am-pihaino’ o mpitoro’ i Paròo naho ampahaisaha’ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Hoe t’i Mosè, Inao ty tsara’ Iehovà, Hiakatse petsakalen-dRaho haneña­teña i Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Le fonga hivetrake ze hene valohan’ anak’ an-tane Mitsraime ao, boak’ amy tañoloñoloña’ i Parò mpiambesatse am-piambesam-panjaka’ey, pak’ ami’ ty tañoloñoloñan’ ondevo ampela amboho’ i fandisanañey vaho ty valohan’ anan-kare. ");
INSERT INTO tdx_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Hanitsike ty tane Mitsraime ty fikoaihañe mbe lia’e tsy ni-añ’ ohatse vaho le lia’e tsy hanahafañe ka. ");
INSERT INTO tdx_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Fe amo ana’ Israeleo, le tsy hihiake ama’ondaty ndra aman-kare ty amboa, hahafohina’ areo te ampiambahe’ Iehovà amy Mitsraime t’Israele. ");
INSERT INTO tdx_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ie amy zay hizotso mb’amako o mpitoro’o retoañe hibokoboko amako hanao ty hoe, Miengà anay, ihe naho ze hene ondaty am-pandia’o. Izay iraho vaho hiavotse, le nienga i Parò am-piforoforoan-keloke. ");
INSERT INTO tdx_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Hoe t’Iehovà amy Mosè, Tsy hañaoñe azo t’i Parò soa te hampitomboañe an-tane Mitsraime ao o halatsàñe hanoekoo. ");
INSERT INTO tdx_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Nanoe’ i Mosè naho i Aharone añ’ atrefa’ i Parò i hene raha tsitantane rezay; fe nampientere’ Iahoé ty arofo’ i Parò vaho tsy nampiengae’e an-tane’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Hoe ty tsara’ Iehovà amy Mosè naho Aharone an-tane Mitsraime ao: ");
INSERT INTO tdx_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","Hatao’ areo fifotoram-bolañe ty volañe toy; ie ty hatao’ areo valoham-bolan-taoñe. ");
INSERT INTO tdx_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Aa le tseizo amy valobohò’ Israeley te, amy fahafolo’ ty volañe toy, songa handrambe ty vi’e ho añ’anjomban-drae’e ze lahilahy, ty vi’e ze hasavereñañe. ");
INSERT INTO tdx_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Aa naho loho kede te ami’ty vi’e raike ty hasavereñañe, le hangala’e raike hatraok’ amo marine’ i anjomba’eio ty ami’ty ia’ ondaty, ze hahafikamà’ ondatio ty hamolilia’o ty vi’e. ");
INSERT INTO tdx_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Tsy hanan-kandra i vi’ey; lahi’e an-tao’e valoha’e ty ho rambeseñe ke amo añondrio he amo oseo. ");
INSERT INTO tdx_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Ho tana’o pak’ ami’ty andro fahafolo-efats’ ambi’ i volañey; le songa hamono ty aze amy folak’ àndroy ze amy valobohò’ Israele. ");
INSERT INTO tdx_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Handrambesa’ iareo ty lio’e vaho hafitse ami’ty lahindalañe roe naho ami’ty ambone’e amy ze anjomba ikamañe azey. ");
INSERT INTO tdx_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ho kamae’ iereo amy haleñey i hena natono añ’afoy naho ty mofo po-dalivay, le ampitraofo àña-mafaitse t’ie kamaeñe. ");
INSERT INTO tdx_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Tsy ho kamaeñe manta, tsy ho sambaiheñe, fa atono añ’ afo ty loha’e naho o tombo’eo vaho o aova’eo. ");
INSERT INTO tdx_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tsy ho sisaeñe ami’ty maraiñe; fa fonga horoañe amy maraiñey ze sisa. ");
INSERT INTO tdx_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Zao ty hikama’o aze: misikiñe ty vania’o, mihana o fandia’oo, naho am-pità’o ty kobaiñe; le ikamañe masika. I Fihelañ’Ambone’ Iehovà izay. ");
INSERT INTO tdx_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Fa hiranga an-tane Mitsraime iraho te haleñe, le ho lihiñeko kàboke ze valohan’ anak’ an-tane Mitsraime ao ndra ondaty ndra hare vaho hametsa­ke zaka amo ndrahare’ i Mitsraimeo: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Viloñe ho anahareo amo anjomba’ imoneña’ areoo i lioy; aa naho treako ty lio, le hiary ambone’ areo iraho vaho tsy ho zevoñe’ ty angorosy te lihiñeko ty an-tane Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ho andro faniahiañe anahareo ty andro toy. Hambena’ areo ho sabadidak’ am’ Iehovà; amo hene tarira’ areoo ty hañambena’ areo aze ho fañè tsy modo nainai’e. ");
INSERT INTO tdx_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Fito andro ty hikamà’ areo mofo po-dalivay; le fonga hafaha’ areo añ’ anjomba’ areo ze atao lalivay aolo’ i andro valoha’ey; amy t’ie mikama lalivay amy andro valoha’ey pak’ami’ty andro faha-fito, le haitoañe am’ Israele indatiy. ");
INSERT INTO tdx_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Amantaño fivory miavake i andro valoha’ey, naho fivory miavake ho anahareo ka i andro fahafitoy, le tsy mitoloñe ndra inoñ’inoñe amy andro rey naho tsy amy ho kamaeñe: izay avao ty ho fitoloña’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ambeno i sabadidake mofo po-dalivaiy amy t’ie ty andro nampiengàko amy Mitsraime i valobohò’ areoy: aa le hambena’ areo amo hene tarira’ areoo ty andro toy ho fañè tsy modo kitro añ’afe’e. ");
INSERT INTO tdx_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Amy volam-baloha’ey, amy andro faha folo-efats’ambi’ i volañeiy naho hariva, ty hikama’ areo mofo po-dalivay pak’ ami’ty hariva’ i andro faha-roapolo-raik’ ambiy. ");
INSERT INTO tdx_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Fito andro te tsy hanjoan-dalivay ty añ’ anjomba’ areo ao, amy t’ie mikama raha nanoen-dalivay ro haitoañe amy valobohò’ Israeley indatiy, ndra t’ie mpañialo ndra te nitoly amy taney. ");
INSERT INTO tdx_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Tsy hikama raha aman-dalivay fa mofo po-dalivay ty ho kamae’ areo amo hene akiba’ areoo. ");
INSERT INTO tdx_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Aa le fonga kinoi’ i Mosè o roandria’ Israeleo, nanoa’e ty hoe, Añakaro vi’e le andrambeso ty amo hasavereña’ areoo vaho lentao i Fihelañ’ amboney. ");
INSERT INTO tdx_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Rambeso ty tsampan-tseva, le aloño amy lio am-panakey; naho afitsezo an-dahin-dalañe roe eo naho an-tokonañe ambone eo i lio am-panakey vaho tsy ia ty hiakatse an-dalañ’ anjomba’e ampara’ te maray. ");
INSERT INTO tdx_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Amy te hitoañe mb’eo t’Iehovà hanjevoñe o nte-Mitsraimeo; aa ie mahavazoho ty lio amy tokonañe amboney naho amy lahindalañe roe rey, le hiary ambone’ i lalañey t’Iehovà vaho tsy henga’e hizilik’ an-kiboho’ areo ao i mpandro­tsakey hanjevoñe. ");
INSERT INTO tdx_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Hambena’ areo nainai’e izay, ho fañè tsy modo ama’o naho amo tarira’oo. ");
INSERT INTO tdx_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ie mivotrake an-tane hatolo’ Iehovà anahareo ty amy tsara’ey le ho henefe’ areo ty fitoroñañe toy. ");
INSERT INTO tdx_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Aa naho añontanea’ o ana’ areoo ty hoe: Ino ty fitoroñ’areo toy? ");
INSERT INTO tdx_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Le hanoa’ areo ty hoe, Ie ty fisoroñañe i Fiariañ’ Ambone’ Iehovày, amy t’ie niary ambone’ o kibohon’ ana’ Israele e Mitsraimeo naho zinevo’e o nte-Mitsraimeo vaho nado’e o kibohon-tikañeo. Aa le niondreke ondatio, nitalaho. ");
INSERT INTO tdx_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Nimb’eo o ana’ Israeleo nanao hambañe amy nandilia’ Iehovà i Mosè naho i Aharoney; izay ty nanoe’ iareo. ");
INSERT INTO tdx_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ie petsakaleñe, le linihi’ Iehovà ze hene valohan’ anak’ an-tane Mitsraime ao, mifototse amy tañolo­ñoloña’ i Parò niambesatse amy fiambesam-pifehea’ey pak’ami’ty mpirohy amy nampigabeñañe azey naho ze valohan’ anan-kàre iaby. ");
INSERT INTO tdx_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Nitroatse haleñe t’i Parò, ie naho ze hene mpitoro’e naho o nte-Mitsraime iabio vaho akore ty fangololoihañe e Mitsraime ao, kanao tsy eo ty anjomba tsy aman-dolo. ");
INSERT INTO tdx_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Aa le kinoi’e t’i Mosè naho i Aharone amy haleñey le nanao ty hoe, Miongaha, Iengao ondatikoo, inahareo naho o ana’Israeleo! Akia, toroño t’Iehovà, amy nisaontsie’ areoy. ");
INSERT INTO tdx_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Endeso o mpirai-lia’ areoo naho o añombe’ areoo, amy nisaontsie’ areoy vaho mañaveloa. Le tatao ka iraho! ");
INSERT INTO tdx_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Tinaentae’ o nte-Mitsraimeo ondatio hampalisa ty hampiakarañe iareo amy taney, fa hoe iereo, Fonga mate zahay. ");
INSERT INTO tdx_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Aa le rinambe’ ondatio o koba’ iareo po-dalivaio, ie nikolopofeñe saroñe an-tsoro’e ao miharo amo fanake fampikobàñeo. ");
INSERT INTO tdx_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Norihe’ o ana’ Israeleo ty saontsi’ i Mosè le nihalaly bange volafoty naho volamena vaho sikiñe amo nte-Mitsraimeo, ");
INSERT INTO tdx_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","le nosihe’ Iehovà o nte-Mitsraimeo t’ie hatarike am’ iereo, le nomei’ iareo ze hene nihalalieñe. Aa le nifongane’ iareo o nte-Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Nañavelo boak’ e Ramesèse pak’ e Sokòte o ana’ Israeleo, ondaty enen-ketse am-pandia fa tsy niaheñe o keleiañeo. ");
INSERT INTO tdx_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Valobohòke mifangaro ty nitrao-pienga am’ iereo naho o lia-raikeo naho o mpirai-trokeo naho ty hanañañe tsy fotofoto. ");
INSERT INTO tdx_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Natoña’ iareo i mofo po-dalivay amy koba nen­dese’ iereo boake Mitsraimey, Tsy nian-dalivay i kobay amy t’ie natao’ o nte-Mitsraimeo soike le nihepakepake fa tsy eo ty hañalankaña’ iareo vaty. ");
INSERT INTO tdx_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Ty fitaveaña’ o ana’ Israele nimoneñe e Mitsraimeo le efa-jato-tsi-telopolo taoñe. ");
INSERT INTO tdx_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Ie nimodo i 430 taoñe rezay amy andro zay, le hene nienga an-tane Mitsraime o lahiale’ Iehovà o. ");
INSERT INTO tdx_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Halem-pijilova’ Iehovà toy, i nampiengà’e iareo an-tane Mitsraimey, aa le ho fijilova’ o ana’ Israele iabio naho ze hene tarira’ iareo, am’ Iehovà ami’ ty haleñe toy. ");
INSERT INTO tdx_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Hoe t’Iehovà amy Mosè naho i Aharone: Zao ty fañè’ i Fiariañ’ Amboney: Tsy ho kamae’ ty ambahiny, ");
INSERT INTO tdx_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","fe azo kamae’ ze ondevo vinily; o nisavare’oo ty hihinañe aze. ");
INSERT INTO tdx_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Tsy ho kamae’ ty mpañialo ndra ty mpikarama. ");
INSERT INTO tdx_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Añ’ anjomba raike ty ikamañe aze, tsy añakarañe amy anjombay i henay vaho tsy hapènkañe o taola’eo. ");
INSERT INTO tdx_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Hambena’ ty valobohò’ Israele izay. ");
INSERT INTO tdx_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Aa naho te hitraok’ amy sabadi­dam-Pihelaña’ Iehovày ka ty renetane ama’ areo, le tsy mahay tsy ho savareñe hey ze fonga lahilahi’e; ie amy zay ro mete mitotoke mb’eo hañambeñe aze; hanahake t’ie nisamak’ amy taney. Fe tsy mete ikama ze ondaty tsy votso-boiñe; ");
INSERT INTO tdx_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","raike ty fetse amo renetane mañialo ama’ areoo naho amo nisamak’ amy taneio. ");
INSERT INTO tdx_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Le nanoe’ o ana’ Israeleo, nihenefa’ o ana’Israeleo ze nandilia’ Iehovà i Mosè naho i Aharoney. ");
INSERT INTO tdx_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","I àndroy avao ty nampiengà’ Iehovà an-tane Mitsraime ao o ana’ Israeleo am-poko am-poko. ");
INSERT INTO tdx_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Nitsara ty hoe amy Mosè t’Iehovà: ");
INSERT INTO tdx_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Avaho ho ahy ze hene lahilahy valohan’ anake. I manoka-koviñe amo ana’ Israeleo, ke ondaty he hare, ahiko irezay. ");
INSERT INTO tdx_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Hoe t’i Mosè am’ondatio, Tiahio ty andro toy, ty niavota’ areo i Mitsraime, boak’ an-trañom-pañondevozañe ao; amy t’ie nampiengà’ Iehovà atoy an-kaozaram-pità’e; le tsy ho kamaeñe ty mofo aman-dalivay. ");
INSERT INTO tdx_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Androany ami’ty volan-kofahofa, ty niavota’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Aa naho minday azo mb’an-tane’ o nte-Kanàneo naho o nte-Kheteo naho o nte-Emòreo naho o nte-Kiveo vaho mb’amo nte-Iebosìo añe t’Iehovà, ie nampitamae’e an-droae’o am-pànta hatolots’ azo; tane orikorihen-dronono naho tantele, le hambena’o ami’ty volañe toy o fitalahoañe zao. ");
INSERT INTO tdx_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Fito andro ty hikama’o mofo po-dalivay vaho ano Sabadidake.am’ Iehovà amy andro faha-fitoy. ");
INSERT INTO tdx_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ho kamaeñe fito andro ty mofo po-dalivay, le tsy ho tendrek’ ama’o ty mofo aman-dalivay vaho tsy ho zoeñe ama’o, an-toe’o iaby ty lalivay. ");
INSERT INTO tdx_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ty hoe ty hatoro’o ami’ty ana-dahi’o amy andro zay, Ie i nanoe’ Iehovà ho ahikoy, t’ie niavotse i Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ho viloñe ama’o am-pità’o naho tiahy añivom-pihaino’o eo soa te ho am-palie’o ty Ha’ Iehovày, amy te am-pitàñe maozatse ty nampiavota’ Iehovà azo amy Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Aa le hambena’o amy namotoaña’e azey boa-taoñe o fañè zao. ");
INSERT INTO tdx_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Naho ninday azo an-tane’ o nte-Kanàneo t’Iehovà, ie nifañina ama’o naho an-droae’o vaho fa natolo’e azo, ");
INSERT INTO tdx_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","le havì’o ho a Iehovà ze hene manoka-koviñe naho ze fonga valohan’ anan-kare’o, a Iehovà o lahi’eo. ");
INSERT INTO tdx_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Fa ho jebañe’o ami’ty añondry ka ty valohan’ ana-borìke, aa naho tsy lefe’o jebañeñe, le tsi-mete tsy kitsihe’o ty loha’e. Aa le ho jebañe’o ty tañoloñoloñan-anadahi’o. ");
INSERT INTO tdx_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ie añe naho mañontane azo ty ana’o ami’ty hoe: Ino zao. Le hatoi’o ty hoe, An-kaozaram-pità’e ro nampiengà’ Iehovà anay i Mitsraime, boak’ an-trañom-pañondevozañe ao. ");
INSERT INTO tdx_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Ie nifoneñe tsy hampienga anay t’i Parò, le vinono’ Iehovà ze fonga valohan’ anake an-tane Mitsraime ao, ty tañoloñoloña’ ondaty naho ty valohan’ anan-kare. Aa le soroñeko am’ Iehovà ze lahi’e manokake ty hoviñe, fe ho jebañeko ze tañoloñoloñan’ anadahiko. ");
INSERT INTO tdx_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Le ho sokitse am-pità’o eo zay vaho alama aolo’ o maso’oo te ninday antika niavotse e Mitsraime am-pità’e maozatse t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Naho nampienga’ i Parò ondatio, le tsy niaoloan’ Añahare mb’an-tane o nte-Pilistio mb’eo ndra t’ie narine. Fa hoe t’i Andrianañahare, hera hibalintoa ondatio te miatrek’ aly naho hibalike mb’e Mitsraime añe. ");
INSERT INTO tdx_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Te mone nampiarien’ Añahare mb’ an-dalan-diolio’ i Riake Menay ondatio. Le nangovovoke boake Mitsraime o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Le nendese’ i Mosè mindre ama’e ty taola’ Iosefe amy nampifantà’e o ana’ Israeleo ty hoe: Toe hitilik’ anahareo t’i Andria­nañahare vaho hampindreze’ areo ama’areo boak’ atoa o taolakoo. ");
INSERT INTO tdx_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ie niavotse i Sokote iereo le nitobe Etame añ’olo’ i ratraratray. ");
INSERT INTO tdx_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Niaoloa’ Iehovà an-drahoñe mitiotiotse te antoandro nitarike i liay vaho an’afo mijoala te haleñe hañomea’e hazavàñe hañaveloañe handro naho haleñe. ");
INSERT INTO tdx_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Tsy nisitak’ ami’ty fiaoloa’e ondatio i rahoñe nitiotiotsey te antoandro, ndra i afo nijoalay te haleñe. ");
INSERT INTO tdx_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Hoe ty nitsarae’ Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Misaontsia amo ana’ Israeleo ty hiba­like naho hitobe aolo’ i Pi-Hakiròte; añivo’ i Migdòle naho i riakey, tandrife i Baal’ Tsefone; eo ty hitobea’ areo marine i riakey. ");
INSERT INTO tdx_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Le hatao’ i Parò te mikariokariok’ an-tamberen-tane ey avao ana’ Israeleo fa arikatoha’ i ratraratray. ");
INSERT INTO tdx_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Aa le ho gañeko ty arofo’ i Parò vaho hihoridaña’e. Fe hahazo engeñe amy Parò naho amo fonga lahindefo’eo iraho, le ho fohi’ o nte-Mitsraimeo te Izaho Iehovà. Aa le nanoe’ iereo izay. ");
INSERT INTO tdx_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Ie nampandrendreheñe i mpanjaka’ i Mitsraimey te nibotatsak’ añe ondatio, le nibalintoa am’ ondatio ty five­tsevetse’ i Parò naho o mpitoro’eo vaho hoe iereo, Inoñe i nanoentika namotsotse o ana’ Israeleo tsy hitoroñ’ antikañey? ");
INSERT INTO tdx_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Aa le nampihentseñe’e i sarete’ey vaho nampindreza’e ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Ninday sarete enen-jato nijoboñen-dre vaho ze kila sarete’ i Mitsraime rekets’ o mpifehe’eo iaby. ");
INSERT INTO tdx_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Le nampientere’ Iehovà ty arofo’ i Parò mpanjaka’ i Mitsraime vaho nihoridañe’e o ana’ Israeleo, ie fa nienga am-pitañ’ abo o ana’Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Nihoridañe’ o nte-Mitsraimeo amy ze hene soavala naho sarete’ i Parò, o mpiningi-tsoavalao naho o lahindefo’e iabio vaho nitrà’iareo nitobe marine’ i riakey iereo marine i Pi-Hakiròte tandrife i Baal’ Tsefone. ");
INSERT INTO tdx_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Ie nañarivo mb’eo t’i Parò, le nampiandra fihaino o ana’ Israeleo, le indroy, nionjoñe mb’am’ iereo o nte-Mitsraimeo. Vata’e nirevendreveñe iereo vaho nikoiak’ am’ Iehovà o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Le nanao ty hoe amy Mosè, Ie tsy aman-kibory e Mitsraime ao hao ty nanesea’o anay mb’etoa hikoromak’ am-patrambey atoy? Ino o nanoa’o anaio, ihe nampiakatse anay amy Mitsraime! ");
INSERT INTO tdx_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Tsy zao hao ty vinola’ay ama’o e Mitsraime añe t’ie apoke hitoroñe o nte-Mitsraimeo? fe hàmake mitoroñe o nte-Mitsraimeo ta t’ie hivetrak’ an-jerezere tane atoy. ");
INSERT INTO tdx_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Aa hoe t’i Mosè am’ondatio, Ko hembañe, mijadoña vaho isaho ty fandrombaha’ Iehovà hatoro’e anahareo anito, fa o nte-Mitsraime isa’ areo androany tsy ho isa’ areo kitro-katroke ka. ");
INSERT INTO tdx_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hialy ho anahareo t’Iehovà, aa le mianjiña. ");
INSERT INTO tdx_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Le hoe t’Iehovà amy Mosè, Ino ty ikoiha’o ahy? Misaontsia amo ana’ Israeleo ty hionjom-b’eo. ");
INSERT INTO tdx_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Le aonjono o kobai’oo vaho ahitio ambone’ o riakeo ty fità’o, le isalahao, hitsaha’ o ana’ Israeleo añivo’ o riakeo an-tane maike. ");
INSERT INTO tdx_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Inao, hampigañeko ty tro’ o nte-Mitsraimeo, ie hañorike, hahazoako engeñe amy Parò naho i valobohò’ey naho amo sarete’eo naho amo mpiningi-tsoavala’eo. ");
INSERT INTO tdx_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Ho fohi’ o nte-Mitsraimeo te izaho Iehovà, naho ahazoako engeñe amy t’i Parò naho o sarete’eo vaho o mpiningi-tsoavala’eo. ");
INSERT INTO tdx_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ie amy zao, nisitake i anjelin’ Añahare niaolo’ i tobe’ Israeleiy, nivike mb’ am-boli’ iareo ao. Toe nisitsitse boak’ aolo’ iareo i rahoñe nijoalay le nijohañe am-boho’e ao ");
INSERT INTO tdx_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","nitsatoke añivo’ o lahindefo’ i Mitsraimeo naho i tobe’ Israeley; naho ninday ieñe mb’aroa i rahoñey fe nihazavae’e atoa i haleñey, soa tsy nifankarine amy haleñe iabiy ty raike mb’ami’ty ila’e. ");
INSERT INTO tdx_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Aa le nahiti’ i Mosè ambone’ i riakey ty fità’e, le nampivevè’ Iehovà amy haleñe iabiy an-tiobey atiña­nañe i riakey naho navali’e ho tane maike i riakey vaho nizara o ranoo, ");
INSERT INTO tdx_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","le nijoñe amy riakey an-tane maike o ana’ Israeleo, ty rindrin-drano an-kavana’ iereo naho an-kavia’e. ");
INSERT INTO tdx_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Hinorida’ o nte-Mitsraimeo iereo, mb’an-teñateña’ i riakey, o soavala’ i Parò iabio, ze hene sarete’e naho o mpi­ningi-tsoavala’eo. ");
INSERT INTO tdx_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ie amy fijilovañe marain-draiñey, le nijilove’ Iehovà boak’ amy afo nijoalay naho amy rahoñey ty valobohò’ i Mitsraime vaho navalitsikota’e i valobohò’ i Mitsraimey. ");
INSERT INTO tdx_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Nakatra’e o laron-tsarete’eo nanebatsebañe ty fionjona’ iareo vaho hoe ty asa’ o nte-Mitsraimeo, Antao hibioñe ami’ty lahara’ Israele! amy te mialy amy Mitsraime ho a iareo t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Le hoe t’Iehovà amy Mosè, Ahitio ambone’ i riakey ty fità’o hibaliha’ o ranoo amo nte-Mitsraimeo, amo sarete’eo vaho amo mpiningi-tsoavala’eo. ");
INSERT INTO tdx_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Nahiti’ i Mosè ambone’ i riakey amy zao ty fità’e le nimpoly amy fikararaha’e taoloy i riakey te nanjirike i àndroy. Nitriban-day ama’e o nte-Mitsraimeo fe navalitaboa’ Iehovà añivo’ i riakey. ");
INSERT INTO tdx_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nitaba­troake mb’eo i ranoy nañàmpo o sareteo naho o mpiningitseo naho i valobohò’ i Parò nañorike o ana’ Israeleo mb’an-driake mb’eo iabiy, ie tsy nengan-tsehanga’e. ");
INSERT INTO tdx_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Fe nitsake i riakey an-tane maike ka o ana’ Israeleo añivo i riakey amy te nirindriñe am’iereo i ranoy, ankavana’e naho ankavia’e eo. ");
INSERT INTO tdx_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Izay ty nandrombaha’ Iehovà am-pità’ o nte-Mitsraimeo t’Israele amy andro zay vaho niisa’ Israele nifitak’ añ’ olon-drano ey o fàten-te Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Nahaisake i hara’ elahin-kaozara’ Iehovà naboa’e amo nte-Mitsraimeoy t’Israele, le nañeveñe am’ Iehovà ondatio vaho niantoke amy Iehovà naho i Mosè mpitoro’ey. ");
INSERT INTO tdx_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Le nisabo ty takasy toy am’ Iehovà t’i Mosè naho o ana’ Israeleo, nipoña-peo ami’ty hoe: Ho saboeko t’Iehovà, onjono an-tiotiotse ey, Nafetsa’e an-driak’ ao ty soavala reke-mpiningi’e. ");
INSERT INTO tdx_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Haozarako naho saboko t’Iehovà, Ie fandrombahañe ahiko henaneo. Andrianañahareko re, le ho rengeko, Andrianañaharen-draeko, vaho honjoñeko. ");
INSERT INTO tdx_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Fanalolahy añ’ aly t’Iehovà, Iehovà ty Tahina’e. ");
INSERT INTO tdx_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Navokovoko’e an-driak’ ao o sarete’ i Paròo naho i valobohò’ey. Nampiopoe’e an-dRia-Binda ao o roandria jinobo’eo. ");
INSERT INTO tdx_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Manafots’iareo i lalekey, nilempotse an-dalek’ ao hoe vato. ");
INSERT INTO tdx_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Toe engeñe an-kaozarañe o fità’o havanao, ry Iehovà. Fa dinorodemom-pitàn-kavana’o i rafelahiy, ry Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ami’ty hajabahinam-bolonahe’o ty anjevoña’o ambane o mivoala ama’oo. Ampihitrife’o mb’eo ty haviñera’o mahatomonto iareo hoe tain’ ava. ");
INSERT INTO tdx_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ami’ty fikofòm-piantsona’o ty nivotria’ i ranoy. Nitroatse hoe rindriñe i sorotombahañey; Nizitse an-tro’ i riakey o lalekeo. ");
INSERT INTO tdx_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Hoe ty asa’ i rafelahiy: Ho horidañeko, ho trako, Ho zaraeko o dinohitseo; ie hañeneke ty haveloko. Hapontsoako ty fibarako, handrotsaha’ ty tañako. ");
INSERT INTO tdx_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Fe nitiofe’o an-kofò’o Le nandipotse iareo i riakey. Nilempotse hoe firake An-drano nitabohazake ao. ");
INSERT INTO tdx_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Ia amo ndrahareo ty mañirinkiriñe Azo ry Iehovà? Ia ty hambañe ama’o? Tsomerentsereñe an-kamasiñañe, mampañeveñe an-drenge, ry mpitolon-kalatsàñeo! ");
INSERT INTO tdx_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nahiti’o ty fità’o havana vaho nabea’ i taney iereo. ");
INSERT INTO tdx_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Am-pikokoa-migahiñe ty niaoloa’o ondaty nijebañe’oo. An-kafatrara’o ty nitehafa’o mb’añ’akiban-kamasiña’o mb’eo. ");
INSERT INTO tdx_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Nahajanjiñe o kilakila ondatio vaho nititititike; Fineveneverañe ty nametreke o nte-Pilistio ");
INSERT INTO tdx_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Nirevendreveñe o mpifehe’ i Edomeo nihondrahondra o roandria’ i Moabeo, fonga nitranake o nte-Kanàneo; ");
INSERT INTO tdx_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","nivotraha’ ty havorombeloñe naho ty hetraketrake, ami’ty haozaram-pità’o nizitse hoe vato iereo— Ampara’ te nitsake ondati’oo ry Iehovà, ampara’ te nitsake ondaty vinili’oo. ");
INSERT INTO tdx_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Hampimoahe’o ao iereo vaho haore’o am-bohi’ i lova’oy— i toem-pimoneña’o hinalanka’oy, ry Iehovà, i fipalirañe naorem-pità’oy ry Talè. ");
INSERT INTO tdx_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mifehe nainai’e donia t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Fa nisorogodañ’ an-driak’ ao o soavala i Paròo rekets’ o sarete’eo naho o mpiningi’eo, le nampoli’ Iehovà am’ iereo o ranon-driakeo, vaho nitsake añivo’ i riakey an-tane maike o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Nandrambe kantsàñe amy zao t’i Miriamae mpitoky, rahavave’ i Aharone, le nañorik’ aze an-kantsàñe naho tsinjake o rakemba iabio ");
INSERT INTO tdx_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","vaho nitakasie’ i Miriamae: Misaboa am’ Iehovà fa nandreketse am-pandreketam-bolonahetse. Navokovoko’e an-driak’ ao ty soavala reke-piningi’e. ");
INSERT INTO tdx_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Aa le nendese’ i Mosè nienga i Ria-Binday t’Israele naho nionjomb’ an-dRatraratra’ i Sore. Nañavelo telo andro am-patrambey ao iereo fe tsy nahatendreke rano. ");
INSERT INTO tdx_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ie pok’e Marà ao, le tsy nihay kamaeñe i rano’ i Marày fa nafaitse. (Izay ty nanoañe ty hoe Marà i aoy.) ");
INSERT INTO tdx_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Aa le niñeoñeo amy Mosè ondatio ami’ty hoe: Ino ty hinome’ay? ");
INSERT INTO tdx_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Le nitoreo am’Iehovà re naho nitoroa’ Iehovà ty hatae, ze nahifi’e an-drano ao nahamamy i ranoy. Teo ty nanoa’ Iehovà fañè naho zaka vaho teo ty nitsoha’e iareo. ");
INSERT INTO tdx_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Hoe re: Naho imanea’o haoñe ty fiarañanaña’ Iehovà Andria­nañahare’o naho manao ty hahiti’e am-pivazohoa’e naho mijanjiñe o fandilia’eo vaho miambeñe o fañè’e iabio, le tsy hapoko ama’o o areteñe nafetsako amo nte-Mitsraimeoo, fa Izaho Iehovà Mpampijangañe azo. ");
INSERT INTO tdx_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Le nitotsake Elìme ao iereo, toetse an-dohan-drano manganahana folo ro’ amby naho satrañe fitom-polo; vaho nañialo marine’ o ranoo eo. ");
INSERT INTO tdx_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Ami’ty andro fahafolo lime ambi’ i volam-paha-roe niavota’ iareo an-tane Mitsraimey, le nañavelo boak’ Elime ty valobohò’ Israele vaho nivo­trak’ am-patrambei’ i Sine añivo’ i Elime naho i Sinày. ");
INSERT INTO tdx_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Nitoreo amy Mosè naho i Aharone am-patrambey ao i valobohò’ Israeley; ");
INSERT INTO tdx_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","le nanoa’ o ana’ Israeleo ty hoe, Hamake te nave­tram-pità’ Iehovà an-tane Mitsraime ao, ie nitoboke marine’ o valañen-kenao vaho nikama mahakama ampara’ te nietsake; fe nasese’o ampatrambey atoy ty fivoribey toy ho zamane’o an-kasalikoañe. ");
INSERT INTO tdx_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Le hoe t’Iehovà amy Mosè, Ingo, hampikojojoahako mahakama boak’ andikerañe añe vaho hiavotse mb’eo boak’ andro ondatio hanontoñe i tsaraeñey, ze mahatsàke i àndroy, hitsohako iareo, ke hañaveloa’ iareo i Hake natolokoy ke ts’ie. ");
INSERT INTO tdx_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ie amy andro fah’ eneñey le halankañe’ iereo o natonto’eo, fa ho indroe’ty famoria’ iareo boak’ andro. ");
INSERT INTO tdx_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Aa le hoe t’i Mosè naho i Aharone amo hene ana’ Israeleo, Ho fohi’ areo hariva te Iehovà ty nañavotse anahareo an-tane Mitsraimey, ");
INSERT INTO tdx_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","le ie maraindray ho isa’ areo ty enge’ Iehovà, fa jinanji’e ty fitoreo’ areo am’ Iehovà. Aa inon-jahay te itoreova’ areo? ");
INSERT INTO tdx_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Le hoe t’i Mosè, hanjotsoa’ Iehovà hena ho kamae’ areo te hariva naho mahakama mahaanjañe te maraindraiñe, amy te janji’ Iehovà ty fimenomeno’ areo te miñeoñeoñe—fa inon-jahay? Tsy ama’ay ty fiñeoñeo’ areo fa am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Le hoe t’i Mosè amy Aharone, Saon­tsio o valobohò’ Israeleo, Miharinea am’ Iehovà, fa jinanji’e ty fitoreo’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aa naho nilañoñe amy valobohò’ Israeley t’i Aharone, ie nitolike mb’ ampatrambey eñe, ingo, niboak’ amy rahoñey ty enge’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Nitsara amy Mosè t’Iehovà nanao ty hoe, ");
INSERT INTO tdx_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Fa tsinanoko ty fitoreova’ o ana’ Israeleo; aa le taroño am’ iereo ty hoe, hikama hena iereo te hariva, naho ho ànja-mahakama iereo te maraindray vaho hapota’ areo te Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ie amy harivay, nionjom-b’eo o hatra­katrakeo nañatseke i tobey; le ie maraindraiñe hoe nizotsoan-jono ty añ’ariari’ i tobey. ");
INSERT INTO tdx_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Ie nionjoñe i zonoy, le ingo ty raha bory nilamak’ am-patrambey ey, hoe sisi’e, matify hoe tihin-tà an-tane eo. ");
INSERT INTO tdx_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ie niisa’ o ana’ Israeleo i raha zay, le hoe ty nifanoiña’ iereo, Ino zao? Amy t’ie nahaalik’ iareo. Le hoe t’i Mosè am’ iereo, Ie ty mahakama nazotso’ Iehovà ama’ areo ho kamaeñe. ");
INSERT INTO tdx_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Inao ty nandilia’ Iehovà: Atontono ty hikama’areo, sindre omere raike, ty ami’ty ia’ ondati’o, sindre hangalake ty mahaeneñe. ");
INSERT INTO tdx_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Nanoe’ o ana’ Israeleo izay, le namory, teo ty nanontoñe maro, teo ty nanontoñe kede. ");
INSERT INTO tdx_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Aa ie nikapoahe’ iareo ami’ty omere, le tsy nanisa ty nanontoñe maro vaho tsy niereñe ty nanontoñe potrapotra’e, songa nanontoñe ty naha­eneñe aze. ");
INSERT INTO tdx_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Le hoe ty nanoa’ i Mosè, Asoao tsy hanisaeñe ty maraiñe. ");
INSERT INTO tdx_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Fe tsy hinao’ iareo t’i Mosè, teo ty nanisa ami’ty maraiñe, le nipoahan’ oletse vaho nitrotròtse. Aa le niviñera’ i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Boa-maraiñe ty natonto’ iareo, ty amo falie mikamao; ie nipisañe ty àndro le nimosaoñe. ");
INSERT INTO tdx_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Fa ami’ty andro fah’ eneñe, songa nitoha indroe’ ty mahakama’e, sindre omere roe vaho hene niheo mb’eo o androanavi’ i fivoribeiio nitalily amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","le hoe re am’ iereo, Hoe ty nitsarae’ Iehovà: Fitofàñe ty hamaray, Sabata masiñe am’ Iehovà; atoñaho ze hatoña’ areo naho ahandrò ze ahandroeñe te anito, le amiho ho ami’ty maraiñe. ");
INSERT INTO tdx_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Aa le namike ho ami’ty maraiñe, amy nitoroa’ i Mosèy fa tsy nimantiñe vaho tsy aman-oletse. ");
INSERT INTO tdx_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Hoe t’i Mosè, Mikama anito, fa Fitofañe am’ Iehovà ty androany vaho tsy ho zoeñe an-kivok’ añe izay te anito. ");
INSERT INTO tdx_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Eneñ’ andro ty hanontona’ areo, f’ie tsy ho tendreke ami’ty andro fahafito, ie Sabata. ");
INSERT INTO tdx_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Ie amy andro fahafitoy, teo t’in­daty nitoha fe tsy naharendreke. ");
INSERT INTO tdx_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Hoe t’Iehovà amy Mosè, Pak’ ombia ty mbe hifoneña’ areo tsy hañorike o lilikoo naho i Fetsekoy? ");
INSERT INTO tdx_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Inao, te natolo’ Iehovà anahareo ty Sabotse; izay ty anjotsoa’e amy andro fahaeneñey ty mofo mahatsàk’ andro roe. Songa midok’ an-toe’e, Ko apo’o ndra iaia hiavotse amy toe’e ami’ty andro faha-fito. ");
INSERT INTO tdx_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Aa le songa nitofa ami’ty andro faha-fito ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Natao’ o ana’ Israeleo màne i mofoy. Nifoty hoe kabaro maike naho hoe mofo pisake nanoeñe an-tantele. ");
INSERT INTO tdx_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Hoe t’i Mosè, Zao ty linili’ Iehovà, Añatsafo omere raik’ ama’e, hahaja ho amo tarira’areo mifandimbeo, hahaoniña’ iereo i mahakama namahanako anahareo am-patrambey ao t’ie nampiengàko an-tane Mitsraimey. ");
INSERT INTO tdx_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Le hoe t’i Mosè amy Aharone, Andrambeso korojy le agodoño ao ty màne mahatsàke ty omere vaho ahajao añatrefa’ Iehovà ho fihaja amo tarira’areoo. ");
INSERT INTO tdx_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Amy nandilia’ Iehovà i Mosèy, ty nampipoha’ i Aharone aze aolo’ i fañinay ho fihaja. ");
INSERT INTO tdx_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Nikama màne efapolo taoñe o ana’ Israeleo, ampara’ te nivotrak’ an-tane fimoneñañe añe; nikama màne ampara’ t’ie nitotsake añ’efetane Kanàne ao. ");
INSERT INTO tdx_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Toe fahafolo ty efà ty omere. ");
INSERT INTO tdx_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Nienga i fatrambey Siney mb’ ami’ty lia’ iareo ty valobohò’ o ana’ Israeleo ty ami’ty falie’ Iehovà vaho nañialo e Refidìme fe tsy aman-drano ho kamae’ ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Le nidoha raha amy Mosè ondatio nanao ty hoe, Meo rano hinome’ay. Hoe t’i Mosè am’ iereo, Ino ty idabasidà’ areo amako? Ino ty itsoha’ areo t’Iehovà? ");
INSERT INTO tdx_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Fe nifeake hataliñiereñe ondatio vaho nitoreo amy Mosè ami’ty hoe, Ino ty nampiavota’o anay amy Mitsraime hamonoa’o anay naho o keleia’aio naho o hare’aio an-karan-dranoañe? ");
INSERT INTO tdx_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Aa le nitoreo am’ Iehovà t’i Mosè, ami’ty hoe: Ino ty hanoeko am’ondaty retoañe? Didý tsy ametsaha’ iareo vato. ");
INSERT INTO tdx_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Hoe t’Iehovà amy Mosè, Miaria aolo’ ondatio, le ampindrezo o androanavi’ Israeleo; tintino am-pitañe i kobay napao’o i Naileiy, le akia. ");
INSERT INTO tdx_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Inao, hijohañe añatrefa’o ambone’ i vato’ i Korèbey iraho. Paoho i vatoy, le hiakaran-drano, hikamà’ ondatio. Nanoe’ i Mosè izay, ampahaisaha’ o androanavi’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Natao’e Masà naho Meribà i toetsey amy te nidoha raha naho nitsoke Iehovà o ana’Israeleo ami’ ty hoe, Amantika hao t’Iehovà ke ts’ie? ");
INSERT INTO tdx_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Niheo mb’eo amy zao t’i Amalèke nifañotak’ am’Israele e Refidime eo. ");
INSERT INTO tdx_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Hoe t’i Mosè am’ Iehosoa, Joboño ondaty ho antika, le mionjona hialy amy Amalèke. Hijohañe ambone’ o vohitseo iraho te hamaray le ho an-tañako i kobain’ Añaharey. ");
INSERT INTO tdx_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Le nanoe’ Iehosoa i nampanoe’ i Mosèy vaho nialy amy Amalèke, le nañambone’ i vohitsey t’i Mosè naho i Aharone vaho i Khòre. ");
INSERT INTO tdx_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Aa ndra mbiambia te nahafañonga-pitàñe t’i Mosè le nahagioke t’Israele, fa ie nazè’e i fitàñey le nahareketse ka t’i Amalèke. ");
INSERT INTO tdx_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Nihamokotse amy zao o fità’ i Mosèo le nandrambe vato naho napo’ iereo ambane’e hiambesara’e, naho nongahe’ i Aharone naho i Khòre o fità’eo, ty raik’ añ’ ila’e etia le ty raik’ atia vaho tsy nitroetroe o fità’eo ampara’ te ni­tsofotse i àndroy. ");
INSERT INTO tdx_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Le ginio’ Iehosoa am-bavam-pibara t’i Amalèke naho ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Le hoe t’Iehovà amy Mosè, Sokiro am-boke ao izay ho tiahy vaho apoho an-dravembia’ Iehosoa te ho faoheko ambanen-dikerañe ty fitiahiañe i Amalèke. ");
INSERT INTO tdx_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Le nandrafitse kitrely t’i Mosè vaho natao’e ty hoe, Iehovà Nissy, ");
INSERT INTO tdx_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","le hoe re, Aa kanao nañonjom-pitàñe amy fiambesa’ Iehovày t’i Amalèke, le hifañotak’ ama’e t’Iehovà, tarirats’ an-tariratse. ");
INSERT INTO tdx_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Aa naho jinanji’ i Iitrò mpisoro’ i Midiane, rafoza’ i Mosè, ze hene nanoen’ Añahare ho a i Mosè naho ho a ondati’e Israeleo vaho ty nampiengà’ Iehovà boake Mitsraime ao t’Israele, ");
INSERT INTO tdx_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","le rinambe’ Iitrò t’i Tsiporàe, vali’ i Mosè, ie fa nampolie’e, ");
INSERT INTO tdx_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","naho i ana’e roe rey. I Geresòme ty añara’ ty raike (amy asa’e ty hoe: Fa niambahiny an-tanen’ ambahiny raho), ");
INSERT INTO tdx_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","le natao’e Elièzere ka ty añara’ ty raike (fa hoe re, Nañimb’ahy t’i Andrianañaharen-draeko vaho rinomba’e ami’ty fibara’ i Parò.) ");
INSERT INTO tdx_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Nimb’am-patrambey nitobea’ i Mosè marine’ i vohin’ Añaharey mb’eo t’Iitrò rafoza’ i Mosè naho i ana’ i Mosè rey vaho i vali’ey. ");
INSERT INTO tdx_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Nampañitrife’e amy Mosè ty hoe, Fa tsatok’ama’o iraho, Iitrò, rafoza’o, rekets’ i vali’oy naho i ana’o roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Nimb’eo amy zao t’i Mosè nifanalaka amy rafoza’ey le nibokobokoa’e naho norofa’e naho nifañontane fanintsiñañe vaho nimoak’ an-kibohots’ ao. ");
INSERT INTO tdx_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Aa le hene natalili’ i Mosè aman-drafoza’e ty nanoe’ Iehovà amy Parò naho amo nte-Mitsraimeo ty amo ana’ Israeleo, le o fonga hao­reañe nizo’ iareo amy lalañeio naho ty nandrombaha’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Nahafale’ Iitrò ze hene hasoa nanoe’ Iehovà am’ Israele ie nihaha’e am-pita’ i Mitsraimeoy. ");
INSERT INTO tdx_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Hoe t’Iitrò, Andriañeñe t’Iehovà nañaha anahareo am-pità’ i Mitsraime naho am-pità’ i Parò, ie namotsotse ondatio ambanem-pità’ i Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Apotako to henaneo te lombolombo ze atao ‘ndrahare iaby t’Iehovà, ami’ty nandrombaha’e amo nanotra­tsotrake iareoo. ");
INSERT INTO tdx_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Aa le nañenga horoañe naho soroñe aman’ Añahare t’Iitrò rafoza’ i Mosè, le niheo mb’eo t’i Aharone reketse ze hene roandria’ Israele nitrao-pikama amy rafoza’ i Mosèy aolon’ Añahare. ");
INSERT INTO tdx_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ie loakandro, le niambesatse nizaka añivo’ ondatio t’i Mosè, le nijohañe aolo’ i Mosè ey ondaty iabio ami’ty maraindray pak’ amy harivay. ");
INSERT INTO tdx_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ie hene niisa’ i rafoza’ i Mosèy o nanoe’e am’ ondatioo le hoe ty asa’e, Inoñe ze o anoe’o am’ondatio? Inoñe ty iambesara’o, ihe avao, vaho mizorazora aolo’o ey ondaty iabio boak’ andro ampara’ te hariva? ");
INSERT INTO tdx_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Hoe t’i Mosè aman-drafoza’e, Amy te miheo mb’ amako mb’ etoa ondatio hañontane aman’ Añahare. ");
INSERT INTO tdx_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Naho ie mifandietse le mb’ amako mb’etoy, hizakako añivo’ ty raike naho ty ila’e, le ampandrendrehako o fañèn’ Añahareo naho o Nafe’eo. ");
INSERT INTO tdx_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Hoe ty rafoza’ i Mosè ama’e, Tsy mete o anoe’oo. ");
INSERT INTO tdx_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Toe mamoza-batan-drehe, ihe naho ondaty ama’o retoañe, amy t’ie loho mavesatse ama’o, le tsy lefe’o toloñeñe, ihe raike. ");
INSERT INTO tdx_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Aa le haoño ty feoko, fa ho toroako, le hañimb’ azo t’i Andrianañahare! Solò añ’ atrefan’ Añahare ondatio, hanolora’o aman’ Añahare o fitoreo’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ianaro o fañèo naho i Hake vaho ampahafohino iareo ty lalan-kombàñe naho ze fitoroñañe hanoeñe. ");
INSERT INTO tdx_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Le paiao ondaty mahimbañe añivo’ ondatio, mpañeveñe aman’ Añahare, ondaty vantañe, malaimbokañe; ajadoño hifehe indaty rezay ho mpamelek’ arivo naho mpin­day zato naho mpiaolo limampolo vaho mpifehe-folo. ");
INSERT INTO tdx_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Le adono iareo hizaka ondatio nainai’e, ie amy zao hasese’ iareo mb’ama’o ze enta-mavesatse le o maivañivañeo ro ho tampahe’ iareo. Haivañe ama’o henane izay ie hindre hivave ama’o. ");
INSERT INTO tdx_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Naho anoe’o izay, vaho andilian’ Añahare azo, le ho lefe’o vaho himpoly mb’an-kiboho’ iareo am-panintsiñañe ondaty retoa. ");
INSERT INTO tdx_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Nihaoñe’ i Mosè i rafoza’ey vaho hene nihenefe’e i natoro’ey. ");
INSERT INTO tdx_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Jinobo’ i Mosè amo ana’ Israele iabio ty ondaty mahimbañe le nampifehe’e ondatio, ho mpamelek’ arivo naho mpifehe zato naho mpifehe limam­polo vaho mpifehe folo. ");
INSERT INTO tdx_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Le nizaka ondatio boak’ andro amy zao iereo naho nasese’ iareo amy Mosè ze zaka tsy nileo vaho nitampa’ iereo o raha maivañeo. ");
INSERT INTO tdx_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Aa le tinata’ i Mosè i rafoza’ey ie nienga mb’an-tane’e añe. ");
INSERT INTO tdx_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Amy volam-paha-telo niengà’ o ana’ Israeleo an-tane Mits­raimey, le tsatok’ amy àndro zay t’ie nivotrake am-patrambei’ i Sinay eo. ");
INSERT INTO tdx_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Fa niakara’ iareo ty Refidime le nipok’ am-patrambei’ i Sinay vaho nitobe an-dratraratra ey. Aa le nañialo aolo’ i vohitsey t’Israele. ");
INSERT INTO tdx_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Niañambone mb’ aman’ Añahare mb’eo amy zao t’i Mosè, le nikanjy aze boak’ am-bohitsey t’Iehovà ami’ty hoe, Ty hoe ty ho saon­tsie’o amy hasavereña’ Iakòbey vaho ty hatao’o amo ana’ Israeleo: ");
INSERT INTO tdx_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Fa niisa’ areo ty nanoeko amy Mitsraime naho nibabeako añ’elam-bantio ninday anahareo mb’amako mb’atoy. ");
INSERT INTO tdx_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ie amy zao naho toe janjiñe’ areo ty feoko naho mañambeñe i fañinakoy, le ho vàrako miambake te amy ze hene ondaty. Fonga ahiko ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Le ho fifeheam-pisoroñe amako naho fifelehañe miavake nahareo. Izay ty entañe ho saontsie’o amo ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Aa le nimb’eo t’i Mosè nikoike o androanavi’ ondatio vaho natrefe’e am’ iereo i nampitsara’ Iehovà azey. ");
INSERT INTO tdx_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Le fonga nanoiñe an-kapindre ondatio, ty hoe, Ho henefa’ay ze tsinara’ Iehovà. Aa le nabali’ i Mosè am’ Iehovà i saontsi’ ondatioy. ");
INSERT INTO tdx_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Le hoe t’Iehovà amy Mosè, Hehe, te miheo mb’ama’o an-drahoñe milodolodo ao iraho, soa t’ie mivolañe, le ho janjiñe’ ondatio irehe vaho hatokisa’ iareo nainai’e. Ie tinaro’ i Mosè am’ Iehovà i saontsi’ ondatioy, ");
INSERT INTO tdx_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","le hoe t’Iehovà amy Mosè, Akia mb’ am’ ondatio mb’eo naho ampiavaho te anito naho hamaray vaho ampanasao iareo o lamba’eo. ");
INSERT INTO tdx_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Le ampihentseño ho ami’ty andro faha-telo fa herone ty hizo­tsoa’ Iehovà am-Bohi-Sinay am-pahaisaha’ ze hene ondaty. ");
INSERT INTO tdx_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ampiarikoboño efetsefetse ty am’ondatio ty vohitse toy vaho ano ty hoe, Mitaoa tsy hiañambone mb’ambohitsey le ko tsapaeñe ty indra’e, fa havetrake ze mitsapa o vohi­tseo. ");
INSERT INTO tdx_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tsy ho tsapaem-pitàñe, fa ho fetsaham-bato ndra tomboheñe ndra t’ie ondaty ndra biby, fa tsy ho veloñe. Naho mivolañe i antsivay le hitotoke amy vohitsey iereo. ");
INSERT INTO tdx_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Aa le nizotso i vohitsey mb’ am’ ondatio t’i Mosè naho nampiavahe’e ondatio vaho nanasa lamba iereo. ");
INSERT INTO tdx_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Le hoe re am’ ondatio, Mihentseña ho ami’ ty herone, le ko mitotoke ami’ty valy. ");
INSERT INTO tdx_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ie maraindrai’ i andro faha­teloy, le niparapapiake ty àmpiñe miharo helatse vaho ty rahoñe jabajaba amy vohitsey, le akore ty fipoñafa’ i antsivay kanao hene nihondrahondra ondaty an-tobeo. ");
INSERT INTO tdx_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Nendese’ i Mosè niakatse i tobey ondatio hifañaoñ’ aman’ Añahare le nijohañe ambane’ i vohitsey. ");
INSERT INTO tdx_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Kinolopon-katoeñe amy zao i vohi­tsey amy te nizotso ama’e ami’ty afo t’Iehovà; le nifororoake nañambone manahake ty hatoe’ o votrim-birìke sodorañeo ty hatoeñe vaho niozoñozoñe mafe i vohitsey. ");
INSERT INTO tdx_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ie nitolom-pipopo ty feo i antsivay, nihamatsiañe, le nisaontsy t’i Mosè vaho nanoiñe an-kotroke t’i Andria­nañahare. ");
INSERT INTO tdx_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ie nizotso mb’amy Vohi-Sinaiy mb’eo t’Iehovà, ambone’ i vohitsey eo, le kinanji’ Iehovà t’i Mosè hiañambone’ i vohitsey vaho niañambone mb’eo t’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Le hoe t’Iehovà amy Mosè, Mizotsoa mb’eo le hatahatao ondatio tsy mone hisosoke mb’eo hisamba Iehovà; vaho hifitafita eo ty maro. ");
INSERT INTO tdx_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Le tsi-mete tsy mañefe-batañe hey o mpisoroñeo te hañarine Iehovà hera hiboroboñak’ ama’e t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Hoe t’i Mosè amy Iehovà, Tsy mete ondatio ty homb’ am-Bohi-Sinay mb’ atoy; amy te Ihe ro nañatahata anay ami’ty hoe, Ampijadoño efetse hañarikatoke i vohi­tsey vaho ampiambaho. ");
INSERT INTO tdx_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Hoe t’Iehovà ama’e, Akia, mizotsoa, le mañambonea mb’ etoy, ihe mindre amy Aharone; le ko ado’o hiboroboñake hiañambone mb’am’ Iehovà o mpiaoloo ndra ondatio; tsy mone hitorotosira’e. ");
INSERT INTO tdx_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Aa le nizotso mb’am’ ondatio mb’eo t’i Mosè ninday i tsaray. ");
INSERT INTO tdx_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Le nanao o hene tsara zao t’i Andrianañahare: ");
INSERT INTO tdx_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Izaho Iehovà Andrianañahare’o nampieng’ azo an-tane Mitsraime boak’ an-trañom-pandrohizañe ao. ");
INSERT INTO tdx_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ko ho aman-drahare hatovoñ’ ahy irehe. ");
INSERT INTO tdx_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ko mandranjy raham-pahasive, ndra saren’ inoñ’ inoñe andikerañe ambone eñe, ndra an-tane ambane atoy, ndra an-drano ambane tane ao. ");
INSERT INTO tdx_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Ko ibokobokoa’o ndra itoroña’o; fa Andrianañahare mpamarahy iraho Iehovà Andrianañahare’o, mpandilo anake ty amo hakeon-drae’eo pak’ an-tarira’e fahefatse naho faha­telo’ o tsy mañaoñe Ahikoo, ");
INSERT INTO tdx_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","vaho mampiboake fikokoa-migahiñe ami’ ty tariratse fah’ arivo’ o mpikoko ahiko naho mañàmbeñe o lilikoo. ");
INSERT INTO tdx_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ko vavè’o tsy vente’e ty tahina’ Iehovà Andrianañahare’o, amy te tsy hihevea’ Iehovà ze mivave i tahina’ey ami’ty tsy fanjofaha’e. ");
INSERT INTO tdx_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Tiahio ty andro Sabotse hañavaheñe aze. ");
INSERT INTO tdx_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Eneñ’ andro ty hitoloña’o hanao ze hene tolon-draha’o. ");
INSERT INTO tdx_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Fe Fitofàñe am’ Iehovà Andrianañahare’o ty andro fahafito; ko mitoloñ’ ama’e irehe; ihe, ndra ty ana-dahi’o ndra ty anak’ampela’o ndra ty ondevo’o lahy naho ampela, ndra o hare’oo ndra o renetane mpimoneñe an-dalambei’oo. ");
INSERT INTO tdx_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Amy te eneñ’ andro ty namboare’ Iehovà o like­rañeo naho ty tane toy naho i riakey naho ze hene am’ iereo ao vaho nitroatse ami’ty andro faha-fito; le nitahie’ Iehovà ty andro Sabotse vaho nimasiñe’e. ");
INSERT INTO tdx_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Miasia an-drae’o naho an-drene’o soa t’ie ho lava ohatse an-tane hatolo’ Iehovà Andrianañahare’o azo. ");
INSERT INTO tdx_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ko mañe-doza. ");
INSERT INTO tdx_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ko mañarapilo. ");
INSERT INTO tdx_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ko mampikametse. ");
INSERT INTO tdx_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ko mitalily vilañe ondaty. ");
INSERT INTO tdx_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ko mihàñe ty anjomba’ ondaty; ko mikiroke ty vali’ondaty, ndra ty mpitoro’e lahilahy ndra ampela, ndra ty añombe’e ndra ty birike’e ndra inoñ’inoñe amo fanaña’ ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Niisa’ ondatio o fipazakeo naho o helatseo naho ty hamatsiaña’ i an­tsivay naho i vohitse nañatoeñey, toe nahaisake ondatio le nititititike naho nijohañe ey avao, ");
INSERT INTO tdx_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","vaho nanao ty hoe amy Mosè, Misaontsia ama’ay, le ho janjiñe’ay, fe ko ampitsarae’o ama’ay t’i Andrianañahare tsy mone hikoromake. ");
INSERT INTO tdx_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Aa hoe t’i Mosè am’ondatio, Ko hembañe; ie hitsok’ anahareo ty nivo­trahan’ Añahare, hañeveña’ areo, tsy handilara’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Fe nijohañe ey avao ondatio vaho nitotoke mb’amy filodolodoan-drahoñe nitoeran’ Anaharey ao t’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Hoe t’Iehovà amy Mosè: Ty hoe ty hatao’o amo ana’ Israeleo, Toe nioni’ areo ty nivolañako boak’ amo likerañeo: ");
INSERT INTO tdx_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ko mamboatse saren-drahare volafoty hatovoñ’ ahy ndra mitsene saresaren-drahare volamena ho anahareo. ");
INSERT INTO tdx_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Kitrely tane ty hamboara’o ahy, le ama’e ty hisoroña’o o enga horoa’o naho o sorom-panintsiña’oo, o añondri’oo naho o añombe’oo; amy ze tane ampitiahiako ty añarako, le homb’ ama’o mb’eo iraho hitahy azo. ");
INSERT INTO tdx_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Aa naho amboara’o kitrelim-bato le ko anoe’o am-bato finandrake; amy te mahativa aze te añoharam-pàndrake. ");
INSERT INTO tdx_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Vaho ko mitroatse am-panongañe tsy mone hiboake ty heña’o. ");
INSERT INTO tdx_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Iretoañ’ o fètse ho taroñe’o am’ iereoo: ");
INSERT INTO tdx_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ie mivily ondevo lahilahy nte-Evre le enen-taoñe ty hitoroña’e, f’ie hiavotse hidada ami’ty fahafito, afa-tsongo. ");
INSERT INTO tdx_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ie dogalahy te mizilik’ ao le i hadogà’ey ty hiakara’e; ie manam-baly te mizilike le amam-bali’e ka te hiavotse. ");
INSERT INTO tdx_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ie tolora’ ty talè’e valy vaho mahatoly ana-dahy ndra anak’ ampela ama’e le ho a i talè’ey i vali’ey naho o ana’eo, le doga re te hiakatse ao. ");
INSERT INTO tdx_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Fe naho mitsey ty hoe i mpitoro’ey, Koko­ako ty talèko naho ty valiko vaho o anakoo; tsy te hiakatse ampidadàn-draho, ");
INSERT INTO tdx_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","le hasese’ i talè’ey añatrefan’ Añahare. Hendeseñe mb’an-tsarirañe mb’eo ndra am-pikalan-dalañe eo le ho trofahe’ ty talè’e fañity ty ravembia’e vaho ho toroñe’e kitro añ’afe’e. ");
INSERT INTO tdx_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ie aleta’ t’in­daty ho ondevo ty anak’ ampela’e, le tsy hanahake ondevo lahi­lahy ty hiakara’e. ");
INSERT INTO tdx_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Naho heje’ ty talè’e, ie jinobo’e ho am-bata’e, le azo jebañeñe; fe tsy hanan-jo handetak’ aze ami’ty ambahiny naho heje’e, ie nifañahia’e. ");
INSERT INTO tdx_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Aa naho fofoe’e ho a i ana-dahi’ey le hampanahafe’e amo anak’ ampelao. ");
INSERT INTO tdx_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ie mañenga valy tovo’e le tsy aketrake ty mahakama’e ndra ty lamba’e ndra ty fialoza’e. ");
INSERT INTO tdx_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","F’ie tsy hañeneke i telo rezay le hiakatse ampidadàñe re tsy an-tsongo, tsy mandoa vola-foty. ");
INSERT INTO tdx_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Tsi-mete tsy havetrake ty namofoke ondaty nampikoromak’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Aa naho tsy nikililieñe, fe nasesen’ Añahare am-pità’e, le ho toroako toetse hirombaha’e. ");
INSERT INTO tdx_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Fe naho iambotraha’ t’in­daty am-pamañahiañe t’in­daty hamonoa’e am-pitak’ate, le hasita’ areo amy kitrelikoy re hivetrake. ");
INSERT INTO tdx_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Tsi-mete tsy havetrake ze mandafa rae ndra rene. ");
INSERT INTO tdx_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Tsi-mete tsy havetrake ze mampikametse ondaty, he t’ie naleta’e ke te zoeñe am-pità’eo. ");
INSERT INTO tdx_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Tsi-mete tsy havetrake ze mamàtse rae ndra rene. ");
INSERT INTO tdx_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Naho mifañotake t’in­daty vaho dasire’ ty raike am-bato ty raike ndra lihiñe’e an-toto-fetreke, f’ie tsy mivetrake, fa mikopake an-tihy, ");
INSERT INTO tdx_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","aa naho mitroatse indatiy naho midraidraitse alafe’e ao am-pitoñoñe, le avotsotse i nandafay, fe havaha’e i fitoboha’ey vaho tsi-mete tsy hatrafe’e ampara’ t’ie jangañe. ");
INSERT INTO tdx_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Naho fofohe’ ondaty an-kobaiñe ty ondevo’e lahilahy ndra ampela, ie mikoromak’ am-pità’eo, le toe ho lilovañe. ");
INSERT INTO tdx_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Fa naho mbe mitam­beloñe andro roe ndra raike re le tsy ho liloveñe ka, kanao fanaña’e. ");
INSERT INTO tdx_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Naho mijoy ty ampela mivesatse t’in­daty mifandrapake vaho mahaboloañe ty ana’e tsy añom-bolañe, fe tsy orihem-boy, le toe ho liloveñe re ami’ty hampanoa’ ty vali’ i rakembay vaho hampañondrohe’ o mpizakao. ");
INSERT INTO tdx_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","F’ie orihem-boy le soloam-piay ty fiay, ");
INSERT INTO tdx_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","fihaino ty fihaino, famotsy ty famotsy, fitàñe ty fitàñe, fandia ty fandia, ");
INSERT INTO tdx_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","soba ty soba, fere ty fere, fofoke ty fofoke. ");
INSERT INTO tdx_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Aa naho trofahe’ ty talè’e ty maso’ ondevo’e lahilahy ndra ampela vaho mijoy aze, le havotso’ i talè’ey hidada i ondevoy, ho solo’ i masoy. ");
INSERT INTO tdx_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Naho apiro’ ty talè ty nife’ ondevo’e ke lahi­lahy he ampela, le havotsotse i ondevoy; hasolo i nifey ty fihahà’e. ");
INSERT INTO tdx_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Naho mitomboke ondaty ty añombe naho mampihomak’ aze le tsi-mete tsy ho retsahem-bato i añombey vaho tsy ho kamaeñe ty nofo’e; fa votsotse ty tompo’ i añom­bey. ");
INSERT INTO tdx_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Aa naho nilili’ i añombey omale ndra fak’omale ty mandronjeronje amo tsifa’eo ie nampandrendreheñe i tompo’ey, fe tsy kinala’ i tompo’ey am-pahetse vaho mañe-doza amy t’in­daty ndra rakemba i añombey, le ho fetsahem-bato i añombey vaho havetrake i tom­po’ey. ");
INSERT INTO tdx_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Fa naho ampañondroheñe drala ka i tompo’ey, le havaha’ i tompo’ey ho fijebañam-piai’e i ampañavahañ’azey iaby. ");
INSERT INTO tdx_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ie mitombok’ ajalahy ndra ampela, le hampañavaheñe an-jaka. ");
INSERT INTO tdx_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Naho mitomboke ondevo lahilahy ndra ampela ka i añombey le ampañavaheñe volafoty sekele 30 i tompo’ey vaho retsahem-bato i añombey. ");
INSERT INTO tdx_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Naho sokafe’ t’in­daty ty koboñe, he mihaly kadaha fa tsy kapefa’e vaho mikorovok’ ao ty añombe ndra birìke, ");
INSERT INTO tdx_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","le ty tompo’ i haliy ro hañavake vaho hañondroke drala ami’ ty tompo’ i harey, fe aze i matey. ");
INSERT INTO tdx_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Naho joie’ ty añombe’ ondaty ty aze, le haleta’ iareo i veloñey naho ho zarae’ iereo roe i vili’ey vaho ifanjarañe i matey. ");
INSERT INTO tdx_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Fe naho nifohiñe te lili’ i añombey ty mandronje, fe tsy kinala’ i tompo’ey am-pahetse, le havaha’ i tompo’ey añombe i añombey vaho aze i matey. ");
INSERT INTO tdx_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Naho mampikametse añombe ndra ose t’in­daty he alèta’e ke lentae’e, le hampañavaheñe añombe lime ty añombe raike naho ose efatse ty ose raike. ");
INSERT INTO tdx_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Naho zoeñe te mampipoñake ty mpampikametse ie trinabotraboke vaho navetrake, le tsy havahan-dio. ");
INSERT INTO tdx_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","F’ie nanjiriha’ i àndroy le ho valeam-pate ty lio. Tsi-mete tsy avahañe, aa ie poi’e, le haletake hasolo i finao’ey. ");
INSERT INTO tdx_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Aa naho tendrek’ am-pità’e ty nikamere’e, ke te añombe, ke borìke, he añondry: le havaha’e roe. ");
INSERT INTO tdx_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ie iandraza’ ondaty ty teteke ndra ty tanem-bahe naho adare’e ama’e o hare’eo vaho iandraza’e ty tonda’ondaty, le tsi-mete tsy avaha’e boak’an-tete’e ami’ty soa an-tete’e ao naho an-tanem-bahe’e ao. ");
INSERT INTO tdx_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Naho mirehetse naho mandakak’ an-drongoñe ty afo vaho mamorototo tsako navotry ndra mizorazora ke mampianto teteke, le toe havaha’ i namiañe i afoiy. ");
INSERT INTO tdx_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Naho andivà’ t’indaty an-drañetse ty drala ndra vara hahaja’e; aa ie kamereñe amy anjomba’ey, le havaha’ i nampikametsey roe t’ie oniñe. ");
INSERT INTO tdx_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Naho tsy oniñe ka i nampikametsey le hasese mb’an-jaka i tompo-trañoy handohiañe, hera ie ty nampijom-pitàñe am-baran-drañe’e ao. ");
INSERT INTO tdx_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Naho eo ty mifandietse ty ami’ ty añombe, he borìke, ke añondry, ke lamba, he inoñ’ inoñe nimotso, ie atao ty raike te aze, le songa hiatreke mpizaka; vaho hañavake in-droe amy rañe’ey i nafàm-pizakay. ");
INSERT INTO tdx_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Aa naho atolo’ ondaty an-drañetse hambena’e ty borìke ndra añombe, ke añondry he ze hare, le ie mate, he fere, ke rinoak’ añe tsy nioni’ ondaty, ");
INSERT INTO tdx_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","le hanoeñe fanta am’ Iehovà, añivo iereo roe, te tsy nikamere’ i rañetsey ty hare’ indatiy naho ho no’ ty tompo’e i fantay vaho tsy hañavake re. ");
INSERT INTO tdx_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Fe naho nikamerañe i rahay le havaha’e amy tompo’ey. ");
INSERT INTO tdx_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Naho nirimitem-biby, le tsi-mete tsy hendese’e i matey ho rendreke, fa tsy havaha’e i nijoy. ");
INSERT INTO tdx_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Naho mìndran-draha an-drañetse t’in­daty, he mianto ke te mate, ie tsi-ao-tompo, le havaha’ i mpìndrañey. ");
INSERT INTO tdx_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Fa naho eo tompo’e le tsy havahañe; naho nifondroeñe le avaha’ i fondroy. ");
INSERT INTO tdx_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Naho mañedre somondrara mboe tsy nifofoeñe t’in­daty, ie miolots’ ama’e, le tsy mahay tsy engae’e ho valie’e. ");
INSERT INTO tdx_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Aa naho ifoneñan-drae’e tsy hanolotse aze, le tsi-mete tsy hondrohe’e ty fañengan-tsomondrara. ");
INSERT INTO tdx_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ko adoke ho veloñe ty mpamòreke. ");
INSERT INTO tdx_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Ho vonoeñe ze misàhe biby. ");
INSERT INTO tdx_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Havetrake ze manao soroñe amy ze atao ndrahare naho tsy am’ Iehovà avao. ");
INSERT INTO tdx_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ko mamorefore ty renetane ndra mamorekeke aze, amy te niambahiny an-tane Mitsraime añe ka nahareo. ");
INSERT INTO tdx_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ko silofe’ areo ze atao vantotse ndra bode. ");
INSERT INTO tdx_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Aa ie helofe’o vaho mitoreo amako, le toe ho tsanoñeko ty fitoreo’ iareo; ");
INSERT INTO tdx_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","hisolebotse ty haboseko le ho zevoñeko fibara, le ho remavoiñe o vali’ areoo vaho ho bode o ana’ areoo. ");
INSERT INTO tdx_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Naho ampisongoe’o ondatikoo ndra ami’ty rarake ama’o ao, ko manao mpampisongo ama’e, le ko angala’o ana’e. ");
INSERT INTO tdx_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ndra mbia ty andrambesa’o ho tsoake ty saro’ ondaty le abaliho aolo’ ty tsofots’ andro, ");
INSERT INTO tdx_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","hera izay avao ty fisafora’e naho ty filafin-tsandri’e te mirotse. Le ie mitoreo amako, hitsanon-dRaho fa mpiferenaiñe. ");
INSERT INTO tdx_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ko onjirañe o mpizakao, le ko mamàtse ty mpifehe’ ondati’oo. ");
INSERT INTO tdx_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ko mihenekeneke tsy hibanabana ty lengom-boan-kavokaran-tete’o naho ty lengom-pipineha’o. Atoloro ahiko ty tañoloñoloña’o. ");
INSERT INTO tdx_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Ano izay ka o añombe’oo naho o añondri’oo: ho fito andro an-drene’e re vaho atoloro ahiko ami’ty andro faha-valo. ");
INSERT INTO tdx_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Hondaty miavake amako nahareo; aa le ko kamae’ areo ze nofotse rinimitem-biby an-kivoke ey, fa ahifiho amo amboao. ");
INSERT INTO tdx_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ko minday tolom-boetse, ko manò-pitàñe ami’ty tsereheñe hitaroña’o entam-bìlañe. ");
INSERT INTO tdx_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ko orihe’o ty maro hikabo-draha; naho ko mireketse amy màroy handesa’o talily mampiolake ty hato; ");
INSERT INTO tdx_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","vaho ko osihe’o ami’ty kabò’e ty rarake. ");
INSERT INTO tdx_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ihe mifanojeha ami’ty añomben-drafe­lahi’o, ndra ami’ty borìke’e nandifike, le tsi-mete tsy hampolia’o. ");
INSERT INTO tdx_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Naho mifanjò ami’ty borì’ i mpalaiñ’ azoy tafahohok’ ambane’ o kilanka’eo, ko rioñeñe, fa tsi-mahay tsy holora’o hampibalak’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ko mengohe’o ty fizakañe i rarake ama’oy amy naneseha’ey. ");
INSERT INTO tdx_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Mihankaña ami’ty raha tsy to; ko mañoho-doza amo vantañeo naho amo vañoñeo. Fe tsy ho meako to i tsereheñey. ");
INSERT INTO tdx_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Ko mandrambe vokañe, fa mahagoa ty mahavazoho ty ravoravo, naho mañamengoke ty saontsi’ o mahitio. ");
INSERT INTO tdx_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ko forekeke’o ty renetane amy te fohi’ areo ty tron-drenetane, fa ni-renetane an-tane Mitsraime añe ka nahareo. ");
INSERT INTO tdx_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Enen-taoñe ty hambolea’o ty tane’o hanontoñe ty voka’e, ");
INSERT INTO tdx_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","fe ko irangàm-pangaly amy faha-fitoy, hitofà’e, hikamà’ ondaty rarake ama’oo; le ho hane’ o bibin-kivokeo ty nasisa. Ampanahafo amy zay ty tanem-balobo’o naho ty golobon-olive’o. ");
INSERT INTO tdx_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Eneñ’ andro ty hitoloña’o, le hitofa ami’ty andro fahafito, soa te hitofa ka ty añombe’o naho ty borìke’o vaho ho haha ka ty anam-pitoro’o ampela naho ty renetane. ");
INSERT INTO tdx_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ambeno i vinolako rezay, le ko toñone’ areo ty añara’ ze o ndrahare ila’e zao vaho ko apo’o ho janjiñeñe am-palie’o. ");
INSERT INTO tdx_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","In-telo ami’ty taoñe ty hanoa’o takataka amako: ");
INSERT INTO tdx_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Hambena’o ty Sabadidake Mofo po-Dalivay; fito andro ty hikama’o mofo po-dalivay, amy nandiliako azoy, amy namantañako aze am-bolan-Kofahofay, fa ama’e ty nienga’o i Mitsraime: vaho tsy hatrefeñe an-tañam-polo iraho; ");
INSERT INTO tdx_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","le i Sabadidam-pitatahañey, ty lengom-boa’ o fitoloña’oo, o nambole’o antetekeo; vaho i Takataka-Panontonañey, amy figadoñan-taoñe anontona’o sabo an-tete’o ao. ");
INSERT INTO tdx_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Homb’ añatrefa’ Iehovà Talè in-telo ami’ty taoñe ze hene lahilahy. ");
INSERT INTO tdx_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ko atraok’ an-dio soroñeñe amako ty mofo aman-dalivay le tsy hampialeñeñe ho sisaeñe hamaray ty havondra’ o famantañakoo. ");
INSERT INTO tdx_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Aseseo mb’añ’anjomba’ ­Iehovà An­dria­nañahare’o ty loha’e, toe ty lengom-boan-tane’o. Ko ahandroeñe an-drononon-drene’e ty anak’ose. ");
INSERT INTO tdx_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ingo, hampiaolòeko ty anjely hañimb’ azo amy lalañey, hanese azo mb’ amy tane nihalankañekoy. ");
INSERT INTO tdx_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Itaò vaho oriho ty fiarañanaña’e, le ko iolañe, toe tsy hapo’e o fandilara’ areoo fa ama’e ty añarako. ");
INSERT INTO tdx_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Aa naho toe ambena’o i fiarañanaña’ey naho anoe’o o itaroñako iabio, le ho rafelahiko o rafelahi’oo vaho hifankalaiñe amo mpifankalaiñe ama’o iraho. ");
INSERT INTO tdx_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Le hiaolo azo i Sorotàkoy hanese azo mb’ amo nte-Emoreo naho amo nte-Kheteo naho amo nte-Perizeo naho amo nte-Kanàneo naho amo nte-Kiveo vaho amo nte-Iebòseo mb’eo, fa haitoako. ");
INSERT INTO tdx_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ko milokoloko amo ‘ndrahare’eo, le ko itoroña’o, ndra mitsikombe o sata’eo; fa toe ho fonga rotsahe’o vaho ho firae’o o hazomanga’eo. ");
INSERT INTO tdx_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Toroño t’Iehovà Andrianañahare’ areo, le ho tahie’e ty mahakama’o naho ty rano’o vaho hampihankàñeko ze atao hasilofañe añivo’o ao, ");
INSERT INTO tdx_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","le tsy ho aman-drakemba hañafake ndra ty ho betsite­rak’ an-tane’o ao; vaho ho henefeko o andro’oo. ");
INSERT INTO tdx_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ham­pi­hitrifeko hiaolo azo ty fihembañañe ahy, le hampitsamborohotaheko iaby t’in­daty hivotraha’o vaho fonga hampiambohoeko azo o rafelahi’oo. ");
INSERT INTO tdx_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Hiraheko fanene-bola hiaolo azo hampibaibay o nte-Kiveo naho o nte-Kanàneo naho o nte-Kheteo aolo’o ey. ");
INSERT INTO tdx_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","F’ie tsy hataoko soik’ ami’ty taoñe raike tsy mone hangoakoake i taney vaho hifamorohotse ama’o o biby hakoo. ");
INSERT INTO tdx_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ho roaheko boak’ ama’o erike ampara’ te nihamaro irehe hahalova i taney. ");
INSERT INTO tdx_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Hajadoko boak’ amy Riake Menay pak’ an-dRia’ o nte-Pilistio ty efe-tane’o naho boak’ amy fatrambeiy pak’amy sakay; le ha­seseko am-pità’ areo ty mpimoneñe amy taney haronje’o mb’aolo’o mb’eo. ");
INSERT INTO tdx_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Tsy hifañina ama’e ndra amo ndrahare’eo irehe. ");
INSERT INTO tdx_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Tsy himoneña’e ty tane’o, hera hampanan-kakeo azo amako, fa naho toroñe’o o ‘ndrahare’eo, le toe ho fandrik’ ama’o. ");
INSERT INTO tdx_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Le hoe re amy Mosè, Mionjona mb’ am’ Iehovà mb’etoy, ihe naho i Aharone, i Nadabe naho i Abiho naho ty fitompolo amo androanavi’ Israeleo vaho mitalahoa ey nahareo. ");
INSERT INTO tdx_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","I Mosè avao ty hañarivo Iehovà, le tsy hañarine ey iereo vaho tsy hindre ama’e hañambone mb’eo ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Nomb’eo amy zao t’i Mosè nita­lily am’ondatio ze hene tsara’ Iehovà naho o fañè’eo; le songa nanoiñe am-piarañanañañe raike ondatio, ty hoe, Ho henefa’ay ty tsara iaby nanoe’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Aa le sinoki’ i Mosè o hene tsara’ Iehovào naho nañaleñaleñe namboatse kitrely am-poto’ i vohitsey vaho nampitroatse anakòreñe folo-ro’amby ty ami’ty ia’ o rofoko folo-roe-ambi’ Israeleo, ");
INSERT INTO tdx_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","le nañiraha’e ajalahy ana’ Israele hibanabana enga horoañe naho añombe ho sorom-panintsiñañe am’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Navì’ i Mosè am-pinga ao ty vaki’ i lioy vaho naretsa’e amy kitreliy ty ila’e. ");
INSERT INTO tdx_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Rinambe’e amy zao i bokem-pañinay le vinaki’e am-pijanjiña’ ondatio; le hoe iereo, Hanoe’ay ze hene tsara’ Iehovào vaho ho haoñe’ay. ");
INSERT INTO tdx_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Le rinambe’ i Mosè i lioy naho nafitse’e am’ondatio vaho nanao ty hoe, Ingo ty liom-pañina nanoe’ Iehovà ama’ areo amy hene tsara rezay. ");
INSERT INTO tdx_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Niañambone amy zao t’i Mosè naho i Aharone, i Nadabe naho i Abiho vaho ty androanavy fitompolo’ Israele; ");
INSERT INTO tdx_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","le niisa’ iereo t’i Andrianañahare’ Israele; le hoe linamike safira ty ambane’ o fandia’eo vaho nanahake o likerañeo ami’ ty fikantsokantsoña’e. ");
INSERT INTO tdx_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Le ie tsy napao-pitàñe amo androanavi’ Israeleo, f’ie nahaisake i Andrianañahare naho nikama vaho ninoñe. ");
INSERT INTO tdx_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Hoe t’Iehovà amy Mosè, Miañambonea mb’amako mb’etoa, le mitambara atoy, fa ho tolo­rako ravem-bato reketse Hake naho lily sinokiko hañòhañe iareo. ");
INSERT INTO tdx_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Aa le niongake t’i Mosè naho Iehosoa mpitoro’e vaho nionjoñe mb’ amy vohin’ Añahare amboney mb’eo t’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Le hoe re amy androanavy rey, Liñiso etoan-jahay, ampara’ ty impolia’ay; ama’ areo t’i Aharone naho i Khòre, hiheova’ ze aman-kalahatse. ");
INSERT INTO tdx_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Aa le niañambone’ i vohi­tsey t’i Mosè vaho kinolopo’ ty rahoñe i vohi­tsey. ");
INSERT INTO tdx_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Nivotrak’ ambohi-Sinay eo ty enge’ Iehovà, le nanaroñe aze eneñ’ andro i rahoñey; ie ami’ty andro fahafito, nikanjie’e boak’amy rahoñey t’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Le nihoe afo nisolebotse ambone’ i vohitsey ty Enge’ Iehovà am-pihaino’ o ana’Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Nizilik’ amy rahoñey t’i Mosè, niañambone i vohitsey. Le tambatse am-bohitse ao efapolo andro naho efapolo haleñe t’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Nitsara amy Mosè t’Iehovà nanao ty hoe, ");
INSERT INTO tdx_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Misaontsia amo ana’ Israeleo, ty hañenga raha amako. Toe ze ondaty manolotse an-tsatri’e ro andrambesañe enga ho amakoy. ");
INSERT INTO tdx_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Zao ty enga ho rambese’o am’iareo : volamena naho volafoty vaho torosìke; ");
INSERT INTO tdx_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","le manga naho malòmavo naho mena mañabarà naho leny marerarera vaho volon-ose; ");
INSERT INTO tdx_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","le holin’ añondri-lahy linoko mena naho holin-trozofisoitse vaho mendoraveñe; ");
INSERT INTO tdx_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","solike ho amy jiroy, emboke ho amy menake fañorizañey naho ho amy fañembohañe mandrifondrifoñey; ");
INSERT INTO tdx_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","vato sohàme naho vato soa hapetake ami’ty kitambe naho ami’ty takon’ araña. ");
INSERT INTO tdx_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Le ampandranjio kivoho himoneñako am’ iereo ao, ");
INSERT INTO tdx_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","hilahatse amy ze he’e hatoroko azo, le ty sare’ i kivohoy naho ty sare’ o harao’e iabio ty handranjia’o aze. ");
INSERT INTO tdx_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ho tsenè’ iereo ami’ty mendoraveñe ty vata; kiho roe naho tampa’e ty ho andava’e le kiho raike naho tampa’e ty ho ampohe’e vaho kiho raike naho tampa’e ty haabo’e. ");
INSERT INTO tdx_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ipakoro volamena ki’e, ao naho eo ty ampipakora’o aze, le ampiarikoboño soñi’e volamena ty andrira’e. ");
INSERT INTO tdx_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Iramerameo ravake volamena efatse, le ampireketo an-kotso’e efatse; ravake roe etia vaho ravake roe atia. ");
INSERT INTO tdx_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Le andranjio baoñe mendoraveñe vaho ipakoro volamena. ");
INSERT INTO tdx_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Atsorofoto amy ravake añ’ ila’ i vatay rey i baoñe rey hitarazoañe i vatay. ");
INSERT INTO tdx_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Hadoñe amo ravakeo avao i baoñe rey le tsy hafahañe. ");
INSERT INTO tdx_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Hajo’o amy vatay i Fañinay, i hatoloko azoy. ");
INSERT INTO tdx_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Itseneo toem-pijebañañe volamena ki’e; kiho roe naho tampa’e ty andava’e vaho kiho raike naho tampa’e ty ampohe’e. ");
INSERT INTO tdx_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Le andranjio kerobe volamena roe, am-pipepehañe añ’ ila roe i toem-pijebañañey; ");
INSERT INTO tdx_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","kerobe raike etoañe naho kerobe raike eroañe. Tseneo am-bongam-bolamena raike i toem-pijebañañey naho i kerobe rey. ");
INSERT INTO tdx_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Hamelatse elatse ambone’e i kero­be rey, hanakoñe i toem-pijebañañey an-elatse, sindre hifañatre-daharañe naho hitolike amy toem-pijebañañey ty lahara’ i kerobe rey. ");
INSERT INTO tdx_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Apoho ambone’ i vatay boak’ ambone i toem-pijebañañey, le ajoño amy vatay i Fañinay, i hatoloko azoy, ");
INSERT INTO tdx_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","le hihaoñe ama’o iraho ambone’ i toem-pijebañañey, boak’ añivo’ i kerobe roe ambone’ i vatam-pañinay rey naho ho taroneko ze hene ho lilieko amo ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Mandranjia rairay ami’ty roy, kiho roe ty andava’e naho kiho raike ty ampohe’e vaho kiho raike naho tampa’e ty haabo’e. ");
INSERT INTO tdx_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Ipakoro volamena ki’e vaho itseneo soñy ty andrira’e hañarikatok’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Le andranjio rira’e mizehe treham-pitàñe hañarikatofa’e fehe, vaho tseneo soñy andrira’e hañariary aze. ");
INSERT INTO tdx_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Itseneo ravake volamena efatse, le areketo an-ko­tso’e efatse, toe an-tombo’e efa­tse i ravake rey, ");
INSERT INTO tdx_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ho marine i rira’ey o ravake fitana’ o bao-pitakonañe i rairaiio. ");
INSERT INTO tdx_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ranjio ami’ty mendoraveñe i baoñe rey vaho ipakoro volamena ho fitakonañe i rairaiy. ");
INSERT INTO tdx_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Le itseneo fanake volamena ki’e: fioke, endraendra naho fitovy. ");
INSERT INTO tdx_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Le hapoke ambone’ i rairay añatrefako nainai’ey i mofo miatrekey. ");
INSERT INTO tdx_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Tseneo am-bolamena ki’e ty fitàn-jiro; pepeheñe i fitàn-jiroy; ho raik’ ama’e ty foto’e rekets’ i taho’ey, o korobo’eo, o rava-drave’eo vaho o voñe’eo; ");
INSERT INTO tdx_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ho eneñe ty tsampa miakatse amo ila’eo, ty tsampa telo’ i fitàn-jiroy ty hilosìtse ami’ty ila’e raike naho ty tsampa telo’ i fitàn-jiroy ty hilosìtse añ’ila’e ka; ");
INSERT INTO tdx_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","korobo telo hoe boti-mahabibo ty an-tsampa’e raike songa aman-drava-draveñe naho ravem-boñe, le korobo telo hoe boti-mahabibo sindre aman-drava-draveñe naho ravem-boñe amy tsampa tandrife azey; sambe hoe izay i tsampa’e eneñe miakatse ami’ty taho’ i fitàn-jiroy rey. ");
INSERT INTO tdx_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Amy taho’ i fitàn-jiroiy ty ho korobo efatse nitsenen-ko sarem-boti-mahabibo rekets’ o rava-drave’eo naho o ravem-boñe’eo. ");
INSERT INTO tdx_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Ami’ty fireketa’ ty tsempa’e ki-roe-roe amy taho’ey ty ho rava-draveñe miray ami’ty tsampa’e roe, ho amy tsampa’e eneñe rey. ");
INSERT INTO tdx_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ho raik’ amy taho’ey o rava-drave’eo naho o tsampa’eo, aa le ho vongam-bolamena ki’e raike nipepeheñe i fitàn-jiro fonitsey. ");
INSERT INTO tdx_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Itseneo jiro fito, le hatsatoke hipasàk’ aolo’e mb’eo i jiro rey. ");
INSERT INTO tdx_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ho volamena ki’e o fiharata’eo naho o sadrò’eo. ");
INSERT INTO tdx_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Talènta volamena ki’e raike ty itseneañe aze naho i harao’e iaby rezay. ");
INSERT INTO tdx_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Henteo arè, le itseneao hambañe amy sare’e natoro azo ambohitsey. ");
INSERT INTO tdx_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Tovo’e izay le hanoa’o lamba fañefetse folo i kivohoy, am-pole leny rinorotse matify naho manga malòmavo naho mena mañabasà; vaho kerobe satam-pamahotse. ");
INSERT INTO tdx_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Sindre ho kiho roapolo-valo’ amby ty halava’ ty lamba-fañefetse le songa kiho efatse ty ampohe’e; hamban-jehe’e iaby o fañefe’eo. ");
INSERT INTO tdx_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Lamba-firindry lime ty hifamitrañe naho lamba-firindry lime ka ty hifamitrañe. ");
INSERT INTO tdx_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Tseneo ravake manga ty andrira fara’ ty namitrañeñe valoha’e naho ravake manga ty andrira fara’ ty namitrañeñe faharoe. ");
INSERT INTO tdx_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Tseneo ravake limampolo ty lamba-firindriy raike vaho tseneo ravake limampolo andrira fara’ i fiharoa’e faharoey, ampanandrifeo o ravakeo. ");
INSERT INTO tdx_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Itseneo famitrañe volamena limampolo, le ampivitraño amy ravake rey i lamba-firindry rey le hifampikatoke ho raike i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Anjairo lamba-fikopoke am-bolon-ose ho kibohotse hakopoke i kivohoy; ano lamba-fikopoke folo raik’ amby. ");
INSERT INTO tdx_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Sindre telopolo kiho ty halava’ ty lamba-fikopoke vaho songa efatse kiho ty ampohe’e; hindray habey i lamba-fikopoke folo-ro’amby rey. ");
INSERT INTO tdx_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Ampivitraño ty lamba-fikopoke lime naho ampivitrañeñe ty lamba-fikòpoke eneñe vaho avaloño mira i fah’ eneñey an-tsarira’ i kiboho­tsey. ");
INSERT INTO tdx_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Itse­neo ravake limampolo ty andrira’ i lamba-fikopoke fara’e amy fifamitrañañe raikey vaho ravake limam­polo andrira’ i lamba-fañefetse fara’ i faharoey. ");
INSERT INTO tdx_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Tseneo famitrañe torisìke limampolo le areketo amy ravake rey i famitrañe rey vaho hikatoke ho raike i kibohotsey. ");
INSERT INTO tdx_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ty ila’ i fikopa’ i kibohotsey milapiy, ty vaki’ i lamba-fikopoke sisay, le haraviravy amboho’ i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ty kiho’e etoy naho ty kiho’e eroy, ty sisa’ amy halava’ o lamba-fakopa’ i kibohotseio ro haraviravy andrindri’ i kivohoy etia naho aroa hañalok’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tseneo rakok’ an-kolits’ añondrilahy linoko mena i kibohotsey le ano holin-trozofisoitse handrakoke ambone’e ka. ");
INSERT INTO tdx_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Mandranjia varambañe ami’ty mendo­raveñe hitroatse amy kivohoy. ");
INSERT INTO tdx_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Folo kiho ty halava’ ty varambañe vaho kiho raike naho tampa’e ty ampohe’ ty varambañe. ");
INSERT INTO tdx_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Songa aman-tsatoke roe ty varambañe hamitrañe aze amy rahavave’ey, izay ty anoañe ze hene varamba’ i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Aa le andranjio varambañe i kivohoy: varambañe roapolo ami’ty atimo mañatimo; ");
INSERT INTO tdx_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","le tseneo vave’e efapolo volafoty ho ambane’ i varambañe roapolo rey; vave’e roe ty ambane’ ty varambañe ho amy tsato’e roe rey vaho vave’e roe ambane’ ty varambañe ila’e ho amy tsato’e roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ami’ty ila faharoe i kivohoy, i avara’ey, le ty varambañe roapolo, ");
INSERT INTO tdx_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","naho ty vave’e volafoty efapolo; vave’e roe ambane’ ty varambañe raike naho vave’e roe ambane’ ty varambañe ila’e. ");
INSERT INTO tdx_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Le tseneo varambañe eneñe ty añ’ ila’ i kivoho ahandrefañey. ");
INSERT INTO tdx_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ranjio varambañe roe an-kotso’ i kivoho ila’e roe rey; ");
INSERT INTO tdx_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","le ifandreketo boak’ ambane pak’ ambone, fa hifampipiteke ami’ty ravake raike; songa anoeñe hoe izay iereo roroe; izay ty ho rafi’ i kotso’e roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Aa le valo ty varambañe naho o vave’e volafotio, vave’e folo eneñ’ amby; vave’e roe ambane’ ty varambañe valoha’e vaho vave’e roe ami’ty varambañe manonjohy. ");
INSERT INTO tdx_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Ranjio saka’e mendoraveñe lime ho amo varambañe añ’ila raike i kivohoio, ");
INSERT INTO tdx_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","naho saka’e lime ty varambañe añ’ila faharoe’ i kivohoy vaho saka’e lime o varambañe amboho’ i kivohoy ahandrefañeo. ");
INSERT INTO tdx_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Haneñateña boak’ ami’ty ila’e pak’ ami’ty ila’e ty saka’e añivo’e ao, añivo’ o varambañeo. ");
INSERT INTO tdx_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Pakoro volamena o varambañeo, le itseneo ravake volamena hiziliha’ o saka’eo vaho pakoro volamena o saka’eo. ");
INSERT INTO tdx_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Aa le hatroa’o amy lili’e nanoroañe azo ambohitse eiy i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Le trebeho lamba fañefetse am-pole leny niroroteñe matify: manga naho malòmavo naho mena mañabarà; vaho kerobe an-tsatam-pamahotse. ");
INSERT INTO tdx_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Iradora­dò ami’ty anakòreñe mendorave efatse pinakotse volamena; volamena o porengo’eo, mitsatoke am-bave’e volafoty efatse. ");
INSERT INTO tdx_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Aradoradò amo porengo’eo i lamba fañefetsey naho aziliho an-kalo’ i lambay i vatam-pañinay, le ho fahera’ i lambay ho anahareo i toe-miavakey amy masi-do’ey. ");
INSERT INTO tdx_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Le hakape’o amy vatam-pañinay i toem-pijebañañey amy masi-do’ey. ");
INSERT INTO tdx_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Apoho alafe’ i lambay i rairaiy vaho tandrife i rairaiy i fitàn-jiroy ami’ty ila atimo’ i kivohoy le hapo’o ami’ty ila’e avaratse i rairaiy. ");
INSERT INTO tdx_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Le tseneo lala-miradorado i kiboho­tsey ami’ty manga naho malòmavo naho mena mañabasà am-pole leny rinorotse matify nivahorem-pitrebeke. ");
INSERT INTO tdx_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Le ranjio anakòreñe mendoraveñe lime i miradoradoy, ipakoro volamena, ho volamena ka o fiporengo’eo; vaho ampitranaho vave’e lime torisìke. ");
INSERT INTO tdx_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Tseneo kitrely am-barama mendoraveñe, lime kiho ty halava’e naho lime kiho ty ampohe’e; hatao efa-mira i kitreliy vaho telo kiho ty haabo’e. ");
INSERT INTO tdx_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Le itseneo tsifa i hotso’e efatse rey; ho raik’ ama’e i tsifa’e rey vaho ipakoro torisìke­. ");
INSERT INTO tdx_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Le andranjio ty fana’e fañafahan-davenoke naho o sadròm-poroha’eo naho o antova’eo, o firango’eo naho o finga’eo; ano torisìke o harao’e iabio. ");
INSERT INTO tdx_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Le andranjio harato torisike tsingarakarake; le tseneo ravake torisìke efatse i tsingarakarakey ankotso’e efatse. ");
INSERT INTO tdx_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Reketo ambane’ ty soñi’ i kitreliy i tsingarakarakey hahatakara’e ty havaki-miran-kaabo’ i kitreliy mañambane. ");
INSERT INTO tdx_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Andranjio baoñe i kitreliy, baoñe ami’ty mendoraveñe, le ipakoro torisìke. ");
INSERT INTO tdx_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Aziliho amo ravakeo i bao’e rey le songa hifamalahañe añ’ila’ roe’ i kitreliy i bao rey hitarazo­añe aze. ");
INSERT INTO tdx_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Itseneo koake am-barambañe, amy nanoroañ’ azo ambohitse eiy ty handranjiañ’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Itseneo kiririsa i kivohoy: mb’amy Negeve mañatimo le lamba tinenon-kèreñe am-pole leny matify ty hiradorado amy kiririsay; zato kiho ty halava’e ami’ty lafe’e raike; ");
INSERT INTO tdx_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ty anakòre’e roapolo naho ty vave’e torisìke roapolo; ty porengo volafoty amo anakòreñe naho bandi’eo. ");
INSERT INTO tdx_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Ie ka ty avaratse ami’ty andava’e: ty firadoradoa’e zato kiho, ty anakòre’e roapolo naho ty vave’e torisìke roapolo vaho o fiporengon’ anakòreñeo naho o bandi’eo am-bolafoty. ");
INSERT INTO tdx_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Le ty ampohe’ i kiririsay ahandrefañey, limampolo kiho ty firadorado’e, folo ty anakòre’e naho folo ty vave’e. ");
INSERT INTO tdx_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Le ty andava’ i kiririsay, limampolo kiho ty añ’ila’ i fanjirihañey mianiñànañe. ");
INSERT INTO tdx_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Ty firadoradoa’e ami’ty ila’ i lalambeiy, folo-lime amby kiho, ty anakòre’e telo vaho ty vave’e telo. ");
INSERT INTO tdx_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Le ty firadorado’e añ’ ila’e ka, folo-lime amby naho ty anakòre’e telo vaho ty vave’e telo. ");
INSERT INTO tdx_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ty lalambei’ i kiririsay, firadoradoañe roapolo kiho: ami’ty manga, malòmavo naho mena mañabasà vaho leny rinorotse am-pole matify nivahorem-pitrebeke; ty anakòre’e efatse naho ty vave’e efatse. ");
INSERT INTO tdx_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Songa bandieñe volafoty o anakòre’e mañohoke i kiririsaio, volafoty o porengo’eo vaho tori­sìke o vave’eo. ");
INSERT INTO tdx_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kiho zato ty andava’ i kiririsay naho limampolo ty ampohe’e etoa naho eroa naho kiho lime ty haabo’ o aman-deny rinorotse matifio, vaho o vave’e torisìkeo. ");
INSERT INTO tdx_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Hene torisìke o fana’ i kivohoio amy ze fitoloñañe aze naho o tsato’eo vaho o tsato’ i kiririsaio. ");
INSERT INTO tdx_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Amantoho amo ana’Israeleo ty hinday menak’olive ki’e finofoke hireheta’ i jiroy nainai’e ");
INSERT INTO tdx_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","amy kibohom-pamantañañey alafe’ i lamba-fañefetse aolo’ i fañinaiy, le ho hajarie’ i Aharone naho o ana’eo ty hireheta’e añatrefa’ Iehovà boa-kariva ampara’ te porea’ ty maraindray: ho fañè amo hene’ tariran’ ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Le ampiharineo ama’o t’i Aharone rahalahi’o rekets’ o ana’eo boak’ amo ana’ Israeleo hitoroñe amako ho mpisoroñe: i Aharone, i Na­dabe naho i Abiho, i Elazare naho Itamare—i ana’ i Aharone rey. ");
INSERT INTO tdx_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Anjairo saroñe miavake aman’ engeñe naho volonahetse t’i Aharone rahalahi’o. ");
INSERT INTO tdx_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Le misaontsia amo mahimbañeo, o nikofohako haliforan-kihitseo, hitsene o saro’ i Aharoneo hañorizañe aze hitoroñe ahy ho mpisoroko. ");
INSERT INTO tdx_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Le o saroñe hanoe’ iereoo: ty takon’ araña, ty kitambe naho ty saroñ’ alafe, ty saroñ’ añate vinahotse naho ty sabaka vaho ty koloty; le hitsenea’ iareo saroñe miavake t’i Aharone rahalahi’o naho i ana’e rey hitoroñ’ ahy ho mpisoroñe. ");
INSERT INTO tdx_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ho rambese’ iereo ty volamena naho ty fole manga naho ty malòmavo naho ty mena mañabarà vaho ty leny matify, ");
INSERT INTO tdx_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","le ho tsenè’ iareo am-bolamena naho fole manga naho malòmavo naho mena mañabarà vaho leny rinorotse matify an-tsatam-pamahotse i kitambey. ");
INSERT INTO tdx_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Le hanoeñe sazoke ty an-tsoro’e roe mirekets’ ankotso’e roe, hampipitehañe aze. ");
INSERT INTO tdx_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Le ty fiè’ i kitambe soa vahotsey ro hindray sata ama’e : volamena naho manga naho malòmavo naho mena mañabasà vaho fole leny rinorotse matify. ");
INSERT INTO tdx_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Le angalao vato sohàme roe naho anokiro ty tahina’ i ana’ Israele rey; ");
INSERT INTO tdx_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","ty tahina’ iareo eneñe ami’ty raike le ty tahinañe eneñe sisa ami’ty ila’e, ty amo hazoke’eo, ");
INSERT INTO tdx_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","le sokireñe amy vato roe rey an-tsatam-panoki-bato manahake ty fanokirañe voli-fitomboke, ty tahina’ i ana’ Israele rey vaho ampivontitiram-bolamena. ");
INSERT INTO tdx_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Le apiteho amy sazo’ i kitambeiy i vato roe rey ho vato faniahiañe o ana’ Israeleo, le hanoe’ i Aharone ega an-tsoro’e roe añatrefa’ Iehovà o tahina’ iareoo ho tiahy. ");
INSERT INTO tdx_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Le itseneo fampireketañe volamena an-tsata vanditse, ");
INSERT INTO tdx_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","naho anan-tsilisily volamena ki’e roe an-tsata vanditse ty itsenea’o iareo vaho hareketse amo famon­titira’eo i silisili’ vinanditse rey. ");
INSERT INTO tdx_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Itseneo takon’ arañam-pizakàñe; manahake ty nanoeñe i kitambey ty anoeñ’ aze: le volamena naho fole manga naho malòmavo naho mena mañabaràñe vaho leny rinorotse matify ty itenoñañ’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Efa-mira t’ie avaloñe; zehe raike ty andava’e naho zehe raike ty ampohe’e; ");
INSERT INTO tdx_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","le itsitsiho firiritam-bato efatse; ahiriritse ami’ty fidadaña’e valoha’e ty odème, ty pitedà naho ty barèkete; ");
INSERT INTO tdx_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","le ty fidadaña’e faharoe: ty nòfeke, ty safìra naho ty iàhalòme; ");
INSERT INTO tdx_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","le ty fidadaña’e faha-telo: ty lèseme, ty sebò naho ty aklàma; ");
INSERT INTO tdx_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","le ty fidadaña’e fahefatse: ty tarsìse ty sòhame vaho ty iasefà: le ampireketañe am-bolamena hampi­vontititse irezay. ");
INSERT INTO tdx_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Le i tahinan’ ana’ Israele folo-ro’ amby rey ro amy vato rey; an-tsatan-tsòki-bangem-pitomboke, songa milahatse ami’ty tahina’ ondaty amy rofoko folo-ro’ amby rey. ");
INSERT INTO tdx_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Le tseneo añ’ila’ i takon’ arañañey ty silisily volamena hiringiri’e mifamandibanditse. ");
INSERT INTO tdx_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Anefeo ravake volamena roe i takon’ arañañey vaho apiteho añ’ ila’e roe’ i takon’arañañey i ravake roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Le aziliho amy ravake roe rey i silisily roe rey añ’ ila’ roe’ i takon’ arañañey; ");
INSERT INTO tdx_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","le areketo ami’ty fiatrefa’ i kitambey, an-tsazo’e, ty ila’e roe’ i silisily roe nivandireñe rey. ");
INSERT INTO tdx_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Anefeo ravake volamena roe vaho areketo añ’ila roe’ i takon’ arañañey, an-drira’e, añ’indra’e miatreke i kitambey. ");
INSERT INTO tdx_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Anefeo ravake volamena roe le areketo ambane’ i sazoke roe’ i kitambe rey amy fiatrefa’ey tandrife ty fivitraña’e, ambone’ ty fiè’ i kitambey. ");
INSERT INTO tdx_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Le rohizo ami’ty fole manga amo rava’eo amy rava’ i kitambey rey i takon’ arañañey, hipiteha’e amy fièn-kitambey soa tsy haba­lak’ amy kitambey i takon’ arañañey. ");
INSERT INTO tdx_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Aa le hendese’ i Aharone ty tahina’ i ana’ Israele rey amy takon’ arañam-pizakàñey ambone’ ty arofo’e, ie mizilik’ amy toe-miavakey, ho faniahiañe nainai’e añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ajò amy takon’ arañam-pizakañey ty Orimae naho ty Tomimae; le ho añ’ arofo’ i Aharone izay ie mizilik’ añatrefa’ Iehovà: le ho vavè’ i Aharone añ’arofo’e añatrefa’ Iehovà nainai’e ty fizakàñe o ana’Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Hanoe’o ami’ty manga avao ty saro’ i kitambey; ");
INSERT INTO tdx_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","añivo’e ty loa’ i añamboney; le ho fahareñe am-pitenoñe miariari’ i loakey ty lifi’e manahake ty loake an-tsarom-piaro, soa tsy ho riatse. ");
INSERT INTO tdx_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Le itseneo sare-voan-dagoa manga naho malòmavo naho mena mañabarà hiariary an-drira’e ambane isabadidahañe fikorìñe volamena. ");
INSERT INTO tdx_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Fikoriñe volamena naho ty dagoa vaho ty fikoriñe volamena naho ty dagoa; izay ty fiariaria’e amy lifin-tsaroñey, ");
INSERT INTO tdx_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","le haombea’ i Aharone izay naho mitoroñe vaho ho janjiñeñe ty fikoriña’e ami’ty fiziliha’e an-toe-miavake ao añ’ atrefa’ Iehovà naho amo fiakara’eo tsy mone hivetrake. ");
INSERT INTO tdx_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Le itseneo takelake volamena ki’e vaho isokiro an-tsatan-tsokim-pitomboke, ty hoe: Miavake am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Ampi­reketo amy sabakay an-taly manga; am-piatrefa’ i sabakay ty andreketañ’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Ie ho an-dahara’ i Aharone, le hivave ze hakeo’ o raha miavake havì’ o ana’ Israeleo ho enga masi’ iareoo t’i Aharone vaho ho nainai’e an-dahara’e izay soa t’ie ho fankatoavañe iareo añatrefa’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Tenoño an-deny marerarera vinahotse i saroñe añate’ey, le tenoño an-deny maeratseratse i sabakay vaho an-tsatam-pitenoñe ty fiè’e. ");
INSERT INTO tdx_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Amboara’o saroñe ka o ana’ i Aharoneo, le hamboara’o fiètse naho itsenea’o satro-bory ho amam-bolonahetse naho hatso­meren­tsereñe. ");
INSERT INTO tdx_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Le aombeo amy Aharone rahalahi’o naho amo ana’eo; le orizo naho atokaño vaho ambaho, hitoroñe ahiko ho mpisoroñe. ");
INSERT INTO tdx_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Le amboaro koloty leny hanaroñe ty fimeñara’ iareo boak’ an-tohake pak’ am-pè. ");
INSERT INTO tdx_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ie ho sikine’ i Aharone naho o ana’eo naho mimoak’ an-kibohom-pamantañañe ao naho miharine i kitreliy hitoroñe amy miavakey, soa tsy hivave ty fandilovañe mahavetrake: fañè tsy ho modo ama’e izay naho amo tarira’e mandimbe azeo. ");
INSERT INTO tdx_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Le zao ty hanoe’o hañeferañe iareo hitoroñe ahy ho mpisoroñe. Andrambeso bania naho añondrilahy roe tsy aman-kandra; ");
INSERT INTO tdx_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","le mofo po-dalivay naho mofo vonga’e po-dalivay nilaroañe menake vaho mofo pisake po-dalivay hinosotse menake: nanoeñe ami’ty monam-bare-bolè. ");
INSERT INTO tdx_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Ajoñe ami’ty hàroñe irezay le aseseo mb’etoa an-karoñe naho i baniay vaho i añondrilahy roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Endeso mb’ an-dalan-kibohom-pamantañam-b’ etoy t’i Aharone naho o ana’eo vaho isasao an-drano. ");
INSERT INTO tdx_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Le rambeso i saroñe rey vaho aombeo amy Aharone i sikiñey naho ty saro’ i kitam­bey naho i kitambey naho i takon’ arañañey vaho aombeo ama’e i fièn-kitambe vinahotsey; ");
INSERT INTO tdx_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","le aombeo añ’ ambone’e i sabakay vaho asampezo amy sabakay i viloñe miavakey. ");
INSERT INTO tdx_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Rambeso i mena-pañorizañey le adoaño añ’ambone’e vaho orizo. ");
INSERT INTO tdx_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Aseseo mb’eo ka i ana’e rey le aombeo am’ iereo o saro’iareoo; ");
INSERT INTO tdx_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","le ampidiaño fiètse t’i Aharone naho o ana’eo, le feheo am’ iereo o sabakao; ie fañe nainai’e tsy modo ho a iareo i fisoroñañey. Le orizo t’i Aharone naho o ana’eo. ");
INSERT INTO tdx_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Aseseo aolo’ i kibohom-pamantañañey i baniay le hanampe fitàñe andoha’ i baniay t’i Aharone naho o ana’eo. ");
INSERT INTO tdx_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Le lentao añatrefa’ Iehovà i baniay, an-dalan-kibohom-pamantañañe eo. ");
INSERT INTO tdx_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Andrambeso ty lio’ i baniay le apetaho an-drambo-pità’o amo tsifan-kitrelio vaho adoaño am-poto’ i kitreliy iaby ze lio sisa. ");
INSERT INTO tdx_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Le rambeso o safo’e mañohoñe o aova’eoo naho ty ova mipetak’ ambone’ i ate’ey, ty tsapavoa’e roe reke-tsafo’e vaho orò amy kitreliy. ");
INSERT INTO tdx_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Le sodoro añ’afo alafe’ i tobey ty vata’ i baniay naho ty holi’e vaho ty tai’e. Soron-kakeo izay. ");
INSERT INTO tdx_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Rambeso amy zao ty añondri­lahy, le hampitongoa fitàñe ami’ty loha’ i añondrilahiy t’i Aharone naho o ana’eo; ");
INSERT INTO tdx_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Le lentao i añondrilahiy naho rambeso ty lio’e vaho afitsezo amy kitreliy añariary aze. ");
INSERT INTO tdx_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Lilio i añondrilahiy, sasao o aova’eo naho o tombo’eo le asampezo amo linilio naho amy loha’ey, ");
INSERT INTO tdx_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","fonga soroño amy kitreliy i añondrilahiy, ho enga horoañe am’ Iehovà; hàñitse mandrifondrifoñe, nisoroñañe añ’afo am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Rambeso ka i añondrilahy raikey, le hanampe-pità’ amy añondrilahiy t’i Aharone naho o ana’eo. ");
INSERT INTO tdx_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Lentao amy zao i añondrilahiy; le andrambeso ty lio’e naho atenteno andengon-dravembia havana’ i Aharone naho andengon-dravembia havana’ o ana’eo naho an-tondrobeim-pitàn-kavana naho an-tondrobeim-pandia havana’ iareo vaho afitsezo añ’ariari’ i kitreliy i lio’ey. ");
INSERT INTO tdx_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Andrambeso ty lio amy kitreliy naho i menake fañorizañey, le afi­tsezo amy Aharone naho an-tsaro’e naho amo ana’eo naho an-tsaro’ o ana’e mindre ama’eo; le hiavake re naho o saro’eo naho o ana’e mindre ama’eo vaho o saron’ ana’eo. ");
INSERT INTO tdx_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Rambeso ka ty safo’ i añondrilahiy naho ty hofa’e naho ty safo’e mañohok’ o ova’eo naho ty lengon’ ate’e, ty voa’e roe reketse ty solik’ ama’e vaho ty tso’e havana, ie añondrilahy fitokanañe; ");
INSERT INTO tdx_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","le ty mofo vonga’e naho ty mofomamy nihosorañe menake vaho ty mofo pisake boak’ an-karo’ o mofo po-dalivay añatrefa’ Iehovào; ");
INSERT INTO tdx_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","le apoho am-pità’ i Aharone naho an-tañan’ ana’e irezay vaho ahelakelaño ho engan-kelahela añ’ atrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Rambeso am-pità’ iareo izay vaho orò amy kitreliy ambone’ i enga horoañey ho hàñitse mandrifondrifoñe añ’atrefa’ Iehovà ho soroñe añ’afo amy Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Le rambeso ty tratra’ i añondrilahim-pitokana’ i Aharoney vaho ahelakelaño ho engan-kelahela añ’atrefa’ Iehovà, ie o anjara’oo. ");
INSERT INTO tdx_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Aa le aviho ty tratra’ i engan-kelahelay naho i feim-pitokanañey, i nahelahelay vaho i navoañe boak’ amy añondrilahim-pitokanañeiy, ho anjara’ i Aharone naho o ana’eo; ");
INSERT INTO tdx_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ie ty anjara’ i Aharone naho o ana’eo, ho fañè nainai’e boak’ amo ana’ Israeleo, izay ty fanolora’ o ana’ Israeleo boak’ amo engam-panintsiña’ iareoo, toe o engan-kavoa’ iareo am’ Iehovào. ");
INSERT INTO tdx_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Le ho limbezañe amo ana’e manonjohy azeo o saro-masi’ i Aharoneo, horizañ’ ama’e iereo vaho ho tokanañ’ ama’e. ");
INSERT INTO tdx_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ho sikina’ i anadahy mandimbe aze ho mpisoroñe fito àndroy izay, ie mimoak’ amy kibohom-pamantañañey hitoroñe amy miavakey. ");
INSERT INTO tdx_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Rambeso i añondrilahim-pitokanañey le ahandrò an-toe-miavake ao o hena’eo; ");
INSERT INTO tdx_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","vaho ho kamae’ i Aharone naho o ana’eo ty hena’ i añondrilahiy naho i mofo an-karoñey, an-dalan-kibohom-pamantañañe ao. ");
INSERT INTO tdx_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ho kamae’ iereo o raha nanoeñe ho fijebańañe, hanokanañe naho hampiavahañe iareo; fe tsy hikama’ ze alafe’e ao amy te miavake. ");
INSERT INTO tdx_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Aa naho eo ty tsy ri’e amy henam-pañorizañey, ndra amy mofoy, ie miporea’ ty maraindray, le horoa’o añ’afo ao i sisay; tsy ho kamaeñe fa miavake. ");
INSERT INTO tdx_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Izay ty hanoe’o amy Aharone naho amo ana’eo, i hene nandiliako azoy. Fito andro ty hanokanañe iareo. ");
INSERT INTO tdx_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Le hentseño boak’ andro ty bania ho soron-kakeo fijebańañe. Ho lioveñe i kitreliy, le ijebaño vaho orizo hampiavahañe aze. ");
INSERT INTO tdx_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Fito andro ty hijebaña’o i kitreliy hañavak’ aze vaho hiava-do’e i kitreliy. Hiavake ze hene mitsapa i kit relit. ");
INSERT INTO tdx_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Zao ty hisoroña’o amy kitreliy: vik’añondry roe boak’ andro nainai’e. ");
INSERT INTO tdx_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Hengae’o maraindraiñe ty vi’e, le hisoroñañe folakandro ka ty vi’e. ");
INSERT INTO tdx_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Hampindreze’o soroñe amy vi’e valoha’ey ty mona’e faha-folo ty efà linaro menake linisañe fahefa’ ty hine vaho divay fahefa’ ty hine ho enga-rano. ");
INSERT INTO tdx_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Le hisoroña’o folakandro ka ty vi’e raike; le ampanahafo amy enga-mahakama naho amy enga-rano’ i marain­draiñeiy, ho hàñitse mandrifondrifoñe, enga horoañe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ho enga horoañe nainai’e izay amo hene tarira’ areo mifandimbeo, amy lalan-kibohom-pamantañañey, añatrefa’ Iehovà, amy hifañaoñan-tikañe naho fitaroñako ama’oy. ");
INSERT INTO tdx_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Eo ty hifañaoñako amo ana’ Israeleo le hampiavahe’ ty engeko i toetsey. ");
INSERT INTO tdx_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Ho tokaneko i kibohom-pamantañañey naho i kitreliy vaho horizako ka t’i Aharone naho o ana’eo hitoroñ’ ahy ho mpisoroñe. ");
INSERT INTO tdx_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Le himoneñe amo ana’Israeleo iraho vaho ho Andrianañahare’ iareo. ");
INSERT INTO tdx_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Le ho fohi’ iareo te Izaho Iehovà Andrianañahare’ iareo ro nañavotse iareo an-tane Mitsraime añe himoneñako am’ iereo ao. Izaho Iehovà Andrianañahare’ iareo. ");
INSERT INTO tdx_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Andrafito kitrely, toem-pañembohañe; mendoraveñe ty itsenea’o aze. ");
INSERT INTO tdx_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ho kiho raike ty andava’e naho kiho raike ty ampohe’e, ho efa-mira, kiho roe ty haabo’e vaho raik’ ama’e o tsifa’eo. ");
INSERT INTO tdx_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ipakoro am-bolamena ki’e: ty ambone’e naho o ila’e mañarikatok’ azeo naho o tsifa’eo vaho itefeo soñi’e volamena hamahetse aze. ");
INSERT INTO tdx_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Anefeo ravake volamena roe ambane’ i soñi’ey, le añ’ila’e roe ty itsenea’o iareo ho fitanañe o bao-pitakonañeo. ");
INSERT INTO tdx_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Rafito ami’ty mendoraveñe o bao’eo le ipakoro volamena; ");
INSERT INTO tdx_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","le apoho aolo’ i lamba-fañefe’ i vatam-pañinay aolo’ i toem-pijebañañe fikape’ i fañinay, amy hifañaoñako ama’oiy. ");
INSERT INTO tdx_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Hañoro emboke mañitse ama’e boa-maraindray t’i Aharone; ie mañalahala jiro ro hañemboke ama’e. ");
INSERT INTO tdx_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Hañembok’ ama’e ka t’i Aharone amy fameloman-jiro harivay, le ho nainai’e añatrefa’ Iehovà amo hene tarira’ areo mifandimbeo i embokey. ");
INSERT INTO tdx_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ko mañenga emboke ila’e ama’e, ndra enga horoañe, he mahakama, le ko añiliña’o engan-drano. ");
INSERT INTO tdx_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Le hanao fijebańañe amo tsifa’eo boa-taoñe t’i Aharone ami’ty lion-tsoron-kakeo-pijebañañe, indraike boa-taoñe amo tarira’ areo mifandimbe iabio, t’ie ijebañañe. Miava-do’e amy Iehovà izay. ");
INSERT INTO tdx_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Le nanao ty hoe amy Mosè t’Iehovà: ");
INSERT INTO tdx_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Ihe mamolily o ana-dahi’ Israeleo ami’ty ia’ iareo, le songa hanolotse ty vilin’ai’e amy Iehovà amy fañiahañey, tsy mone hisilofañ’ angorosy ty amy famoliliañey. ");
INSERT INTO tdx_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Sindre hanolotse zao te iaheñe: ty vakin-tsekele amy sekelen-toe-mivakeiy (roapolo gerà ty sekele raike). Ho banabana am’ Iehovà i vakin-tsekeley. ");
INSERT INTO tdx_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Ze hene niaheñe roapolo taoñe mañambone ro hañenga am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ie mañenga i vilin’ aiñey am’ Iehovà, le tsy hanolotse maro ty mpañaleale vaho tsy hanolotse ambane’ i vakin-tsekeley ty rarake. ");
INSERT INTO tdx_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ho rambese’o amo ana’ Israeleo i bogadim-bilin’ aiñey vaho havì’o ho fitoroñañe i kibohom-pamantañañey; le ho tiahy amo ana’ Israeleo añatrefa’ Iehovà, hijebañañe anahareo. ");
INSERT INTO tdx_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Le nanao ty hoe amy Mosè t’Iehovà, ");
INSERT INTO tdx_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Anefeo fanasàñe torisìke reke-poto’e torisìke, ho fisasàñe, le apoho añivo’ i kibohom-pamantañañey naho i kitreliy izay vaho añiliño rano, ");
INSERT INTO tdx_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","le boak’ ama’e ty hanasà’ i Aharone miroanake fitàñe naho fandia. ");
INSERT INTO tdx_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Ie mimoak’ amy kibohom-pamantañañey ndra mañarine i kitreliy hitoroñe, hañoro enga am’ Iehovà, ro hisasa an-drano hey tsy mone hikenkañe; ");
INSERT INTO tdx_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","hanasa fitàñe naho fandia tsy mone hivetrake. Ho fañè tsy modo ho a iareo—ho aze naho o hene tarira’e mifandimbeo. ");
INSERT INTO tdx_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Nitsara amy Mosè t’Iehovà, nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Rambeso ty emboke soa jinoboñe: ty ron-drame limanjato naho ty kanely mañitse vaki’ izay: roan-jato tsy limampolo, le varemañitse roan-jato tsy limampolo, ");
INSERT INTO tdx_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","le ty roi-mañitse limanjato amy sekelen-toe-miavakey vaho menak’ olive hine raike. ");
INSERT INTO tdx_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Le ano menake fañorizañe miavake i raha rey, raha mañitse aharo an-tsata’ o mpanao tsòtseo, ho mena-pañorizañe miavake. ");
INSERT INTO tdx_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ie ty hañoriza’o i kibohom-pamantañañey naho i vatam-pañinay, ");
INSERT INTO tdx_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","i rairaiy naho ze hene fanake naho i fitàn-jiroy naho o harao’eo vaho i kitrelim-pañoroañ’ embokey, ");
INSERT INTO tdx_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ty kitrelim-pisoroñañe naho o harao’e iabio vaho i fanasàñey rekets’ i foto’ey. ");
INSERT INTO tdx_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Atokano ho loho masiñ’ irezay; miavake ze mitsapa aze. ");
INSERT INTO tdx_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Le horiza’o ty Aharone naho o ana’eo hamìha’o hitoroñe ahy ho mpisoroko. ");
INSERT INTO tdx_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Le ty hoe ty hatao’o amo ana’ Israeleo: Itoy ty mena-pañorizañe miavake amako amo hene tarira’ areo mifandimbeo. ");
INSERT INTO tdx_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Tsy ailiñe an-tsandri’ ondaty, le tsy tsikombeñe ty fampitraofañe aze, fa miavake, vaho havahe’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ze mampilaro mana­hak’ aze, ndra mañiliñ’ aze am’ondaty ila’e, ro haitoañe am’ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Aa hoe t’Iehovà amy Mosè: Rambeso o emboke mañitse zao: sike-mañitse naho sabiba naho taven-tsike; naho tsotse-foty ki’e, i raha mañitse rezay; le ampimirao lanja. ");
INSERT INTO tdx_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Le mitsenea emboke, am-pilaroañe, satam-panao emboke, siraeñe, malio naho miavake. ");
INSERT INTO tdx_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Lisano ho bo’e ty ila’e, le ano aolo’ i fañinay an-kibohom-pamantañañ’ ao ty ila’e, amy hifañaoñako ama’oy, loho miavake ama’ areo izay. ");
INSERT INTO tdx_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Le i emboke tsenè’oy, tsy hanoe’ areo ho am-batañe amy filaroa’ey, fa miavake am’ Iehovà ho anahareo izay. ");
INSERT INTO tdx_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Haitoañe am’ondati’eo ze mitsene ty hambañ’ ama’e hañantsoña’e. ");
INSERT INTO tdx_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Le nanao ty hoe amy Mosè t’Iehovà: ");
INSERT INTO tdx_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Ingo, fa kinoiko amy tahina’ey ty Betsalale ana’ i Ory, ana’ i Kore, fifokoa’ Iehodà; ");
INSERT INTO tdx_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","le niliforako amy Arofon’ Añaharey, aman-kihitse naho hilala hahafohina’e ze hene satam-pitoloñañe, ");
INSERT INTO tdx_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ie hamoroñe sarem-pitoloñañe naho hitoloñe ami’ty volamena naho volafoty vaho torisìke; ");
INSERT INTO tdx_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","le hampireketse vato vinàñe naho handranjy an-katae vaho hifa­nehake amy ze hene tolon-draha. ");
INSERT INTO tdx_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Inao te izaho, le izaho ty nanolotse aze ho mpiama’e t’i Oholiabe ana’ i Akisamake, fifokoa’ i Dane; le songa tinoloko hihitse an-troke ze mahihi-tro, hitsene i nandiliako azo rezao: ");
INSERT INTO tdx_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","i kibohom-pamantañañey, i vatam-pañinay rekets’ i toem-pijebañañe mitakoñe azey naho o harao’ i kivohoio ");
INSERT INTO tdx_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","le i rairaiy rekets’ o fanakeo, i fitàn-jiro ki’ey rekets’ o harao’e iabio vaho i kitrelim-pañembohañey; ");
INSERT INTO tdx_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","naho i kitrelim-pisoroñañey reketse ze hene harao’e naho i fanasàñe reke-poto’ey, ");
INSERT INTO tdx_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","le o fisikiñe vinahotseo; o saro-miava’ i Aharone mpisoroñeo naho o saro’ o ana’eo hitoloña’ iareo ho mpisoroñeo, ");
INSERT INTO tdx_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","le i mena-pañorizañey vaho i emboke mandrifondrifoñe ho a i miavakeiy vaho hanoe’ iareo ze hene nandiliako azo. ");
INSERT INTO tdx_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Hoe ty natovo’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Saontsio amo ana’ Israeleo ty hoe: Toe hambena’areo o Sabata­koo, amy te ie ty viloñe añivontika amy ze hene sa’ areo. hahafohina’ areo te Izaho, Iehovà ro Mpamike anahareo ho ahiko. ");
INSERT INTO tdx_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Aa le tambozoro o Sabatao amy t’ie miavake ama’ areo. Havetrake ze manivativa aze, haitoañe am’ondatio ze mitolon-draha ama’e. ");
INSERT INTO tdx_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Eneñ’ andro ty fitoloñañe fa masiñe am’ Iehovà ty andro fahafito, ty Sabotsem-pitofàñe; toe havetrake ze manao tolon-draha ami’ty andro Sabotse. ");
INSERT INTO tdx_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Aa le hitàñe o Sabatao o ana’ Israeleo; hambena’ iareo o Sabotseo amo hene tarira’ iareo mifandimbeo ho fañina nainai’e tsy modo. ");
INSERT INTO tdx_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Viloñe nainai’e añivoko naho o ana’ Israeleo izay amy te eneñ’ andro ty nitsene’ Iehovà o like­rañeo naho ty tane toy naho nitroatse amy andro fahafitoy naho nitofa vaho nitomambao. ");
INSERT INTO tdx_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Aa ie nagado’e i nitsara’ey le natolo’e amy Mosè ambohi-Sinay i rave’ i Fañinay roe rey, ravem-bato sinoki’ ty rambom-pitàn’Añahare. ");
INSERT INTO tdx_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Aa naho nirendre’ ondatio te nalaom-pizotso boak’ ambohitse añe t’i Mosè, le niropak’ amy Aharone ondatio nanao ty hoe, Miongaha, andranjio ndrahare zahay, hiaolo anay; fa i Mosè zay, indaty ninday antika niavotse an-tane Mitsraimey, nofi’ay ty nizò aze. ");
INSERT INTO tdx_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aa hoe t’i Aharone am’ iereo, Apitsoho an-tsofim-bali’ areo naho amo ana-dahy naho anak’ ampela’ areoo o bange volamenao, le endeso amako. ");
INSERT INTO tdx_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Aa le napitso’ ondaty iabio o bange volamena an-dravembia’ iareoo vaho nendese’ iereo mb’ amy Aharone mb’eo. ");
INSERT INTO tdx_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Rinambe’e am-pità’ iareo naho nitsene’e amam-pisokirañe naho namboare’e bania nitranaheñe, vaho hoe iereo, Intoy o ndrahare’oo, ry Israele, i ninday azo niakatse an-tane Mitsraimey. ");
INSERT INTO tdx_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aa naho nioni’ i Aharone, le nan­dranjy kitrely aolo’eo vaho nikoike ty hoe: Hamaray ty ho takataka am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Le nitroatse maraindrain-tsikiake iereo te loak’ andro nisoroñe naho nanese engam-panintsiñañe; le niambesatse ondatio nikama naho ninoñe vaho niongake le nihisa. ");
INSERT INTO tdx_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Le hoe t’Iehovà amy Mosè, Akia mizotsoa! Fa naniva vatañe ondaty nendese’o niavotse an-tane Mitsraimeo ");
INSERT INTO tdx_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","fa nivike aniany amy làlañe linilikoy; ie nampitranake sare bania naho nitalahoa’e naho nisoroña’e vaho nanao ty hoe, Intoy o ndrahare’oo, ry Israele, i ninday azo nienga an-tane Mitsraimey! ");
INSERT INTO tdx_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Hoe t’Iehovà amy Mosè, Fa nitreako ondatio; inao! toe ondaty gam-pititia! ");
INSERT INTO tdx_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ie amy zao, angao iraho, hiforoforoa’ ty haboseko, ho forototoeko, vaho ihe ty hanoeko foko ra’elahy. ");
INSERT INTO tdx_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Fe niambane am’ Iehovà Andria­nañahare’e t’i Mosè nanao ty hoe: Ry Iehovà, ino ty isolebora’ ty fifombo’o am’ondati’o nindese’o niakatse an-tane Mitsraime añe an-kaozaran-dra’elahy vaho an-kafatraram-pitàñeo. ");
INSERT INTO tdx_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Aa vaho tsy hatao’ o nte-Mitsraimeo ty hoe te Nakare’e hijoia’e, hañohofa’e loza ambohitseo vaho ho mongore’e an-tane atoy? Iambohò o fifombo’o miloroloroo vaho ferenaiño tsy hampianto ondati’oo. ");
INSERT INTO tdx_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Tiahio i Avrahame, Ietsàke vaho Israele mpitoro’o nifantà’o am-pañova’o naho nitsara’o ty hoe: Hampitomboeko ho mira amo vasian-dikerañeo ty ia’ o tarira’ areoo naho ze hene tane nivolañeko te hatoloko an-tarira’ areo vaho ho lovae’ iareo nainai’ey. ");
INSERT INTO tdx_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Aa le niheve’ Iehovà ty fandrotsahañe nisafirie’e hanoeñe am’ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Nitolik’ amy zao t’i Mosè nizotso amy vohitsey, am-pità’eo i ravem-bato roe’ i fañinay rey, rave’e sinokitse ami’ty lafe’e roe, aolo’e vaho amboho’e. ");
INSERT INTO tdx_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Sàtan’ Añahare i rave’e rey vaho sokin’ Añahare i sokitse finandrak’ amo rave’eoy. ");
INSERT INTO tdx_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ie jinanji’ Iehosoa ty korà’ ondatio ami’ty fikontsiaña’e le hoe re amy Mosè: Hoe fikorahan’aly ty an-tobe ao. ");
INSERT INTO tdx_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Fa hoe re, Tsy ty fitreñam-pandrebake naho tsy ty fangoihoia’ o giokeo, fa ty fivolam-pihisa ty tsanoñeko. ");
INSERT INTO tdx_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Aa ie narine i tobey naho naha­isake i baniay naho i tsinjakey, le niforoforo ty haviñera’ i Mosè naho navokovokom-pità’e i rave’e rey le nivolentsa am-poto’ i vohitsey. ");
INSERT INTO tdx_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Rinambe’e i bania tsinène’ iereoy le tineno’e añ’afo ao naho nilisane’e ho deboke naho nafitse’e an-tarehe’ i ranoy vaho nampinome’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Le hoe t’i Mosè amy Aharone, Ino ty nanoa’ ondaty retia te nampanoe’o hakeo jabajaba hoe zao. ");
INSERT INTO tdx_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aa hoe t’i Aharone, Ko anga’o hangosasàke ty fifombo’ i talèkoy; fohi’o ondatio, te raty tsereke. ");
INSERT INTO tdx_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Ie nanao ty hoe amako, Itseneo ndrahare hiaolo anay; fa i Mosè zay, indaty ninday anay niavotse an-tane Mitsraimey, nofi’ay ty nizo aze. ");
INSERT INTO tdx_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Le nanoako ty hoe, Ze am-bolamena, afaho; natolo’ iereo le nafetsako añate-afo ao vaho niboake ty bania tia. ");
INSERT INTO tdx_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Aa naho nioni’ i Mosè te nitsam­boro­­hotake ondatio (amy t’ie nampidadae’ i Aharone hitsikiha’ o rafelahi’ iareoo), ");
INSERT INTO tdx_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","le nijohañe am-pizi­lihañe an-tobe ao t’i Mosè nanao ty hoe, Ze mpiam’ Iehovà, mb’ amako mb’ etoa! Le hene nifanontoñe ama’e o ana’ i Levio. ");
INSERT INTO tdx_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Le hoe re am’ iereo, Hoe t’Iehovà Andrianañahare’ Israele: Songa mañombea fibara añ’ila’e, le mibelobeloa boak’ an-dalambey pak’ an-dalambei’ ty tobe toy le manjevoña: sindre an-drahalahi’e, songa an-drañe’e vaho fonga an-dongo’e. ");
INSERT INTO tdx_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Aa le nanoe’ o ana’ i Levio i nisaontsia’ i Mosèy vaho miha-telo arivo t’in­daty nikoromak’ amy andro zay. ");
INSERT INTO tdx_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Aa hoe t’i Mosè, Fa nanokam-batañe am’ Iehovà nahareo anindraoany, amy te fonga niatreatre anadahy naho rahalahy, hanoloram-pitahiañe ama’ areo anito. ");
INSERT INTO tdx_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Ie amy loak’ àndroy, hoe t’i Mosè am’ ondatio, Inao! Inahareo ’nio, fa nandilatse an-kakeo jabajaba! aa le hiañambone mb’ am’ Iehovà mb’eo hey iraho; hera hahafijebañe i tahi’ areoy. ");
INSERT INTO tdx_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Aa le nibalike mb’am’ Iehovà mb’eo t’i Mosè nanao ty hoe, Hoy Aba! ty habey hakeo’ ondatio te namboatse ndrahare volamena. ");
INSERT INTO tdx_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Aa ie henane zao naho mete, apoho ty tahi’ iareo, fa naho tsie, faopaoho amy boke sinoki’oy ty añarako. ");
INSERT INTO tdx_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Le hoe t’Iehovà amy Mosè, Ze nandilatse amako, ie ty ho faoheko amy bokekoy. ");
INSERT INTO tdx_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Aa le akia hey, Iaolò mb’ amy toetse natoroko azoy mb’eo ondatio; hehe, hiaolo azo i irakoy vaho amy andro fitilihañey ty hampitilihako i tahi’ iareoy. ");
INSERT INTO tdx_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Aa le nahitri’ Iehovà am’ondatio ty angorosy ty amy bania namboare’ iereoy, i tsinene’ i Aharoney. ");
INSERT INTO tdx_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Le hoe t’Iehovà amy Mosè, Mionjona, angao ty atoy, ihe naho ondaty nampiavote’o an-tane Mitsraimeo, homb’ an-tane nifantàko amy Avrahame, am’ Ietsàke naho am’ Iakòbe ami’ty hoe: Hatoloko amo tarira’oo izay. ");
INSERT INTO tdx_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Le hahitriko hiaolo anahareo t’i Sorotàko, handroahako i nte-Kanàney, i nte-Amòrey naho i nte-Kìtey naho i nte-Perìzey, i nte-Kìvey vaho i nte-Iebòsey, ");
INSERT INTO tdx_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","mb’an-tane kararahen-dronono naho tantele añe; fa tsy hionjom-beo añivo’o ao iraho kera habotseko an-dalambey, ie ondaty gan-katoke. ");
INSERT INTO tdx_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ie nahajanjiñe i tsara maràñe zay ondatio le nangoihoy vaho tsy ama’e ty niravake, ");
INSERT INTO tdx_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","amy natao’ Iehovà amy Mosè ty hoe, Ano ty hoe o ana’ Israeleo: Ondaty gam-pititia nahareo; aa naho nihelatse añivo’ areo ao iraho tsy ho nagodrako aniany hao? Ko miravak’ arè, hisafiriako ty hanoako. ");
INSERT INTO tdx_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Aa le hinalo’ o ana’ Israeleo am’iereo ze ravake naho bange ambohi-Koreba. ");
INSERT INTO tdx_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ie amy zay, nendese’ i Mosè i kibohoy vaho naore’e alafe’ i tobey, lavitse i tobey eñe, le nitokave’e ty hoe kibohom-pamantañañe. Aa le songa niavotse mb’ amy kivohom-pamantañañe alafe’ i tobey eiy ze nipay Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Aa naho nienga mb’amy kibohotsey mb’ eo t’i Mosè, le hene niongake ondatio sambe nijohañe an-dala’ i kiboho’ey nandrèndreke i Mose ampara-piziliha’e an-kibohotse ao. ");
INSERT INTO tdx_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Aa naho nizilik’ an-kibohotse ao t’i Mosè, le nizotso mb’eo i rahoñe nijoalay nijohañe an-dala’ i kibohotsey, le nifanaontsy amy Mosè t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ie hene nahaisake i rahoñe nijoalay nijohañe an-dala’ i kibohotsey ondatio le sindre niongake ondatio vaho songa niambane an-dalan-kiboho’e. ");
INSERT INTO tdx_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Vaho nifanaontsy am-piatrefan-daharañe t’Iehovà naho i Mosè, manahake ty fifañòhahohàm-pirañetse. Aa ie nimpoly mb’an-tobe mb’eo, tsy nienga i kibohoy ty ajalahy atao Iehosoa ana’ i None mpitoro’e. ");
INSERT INTO tdx_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Hoe t’i Mosè am’ Iehovà: Ingo, i tsinara’o amako ty hoe: Ampionjono ondaty retoa; fa tsy nampandrendrehe’o ahy o hampindreze’o amakoo. Fa nanao ty hoe irehe, Fantako ami’ty tahina’o irehe vaho isoheñe am-piva­zohoako. ");
INSERT INTO tdx_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Aa naho nitendreke fañisohañe am-pihaino’o iraho le mihalaly ama’o, Atorò ahy o lala’oo, haharendrehako Azo, hahazoako falalàñe am-pihaino’o vaho ereñerèño te ondati’o ty fifeheañe toy. ");
INSERT INTO tdx_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Le hoe re: Hindre lia ama’o ty fiatrefako vaho hampitofàko. ");
INSERT INTO tdx_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Aa le hoe ty navale’e: Naho tsy hiaolo anay ty fiatrefa’o le ko ampi­onjone’o boak’ etoa. ");
INSERT INTO tdx_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Aa ino ty hahafohinako henaneo t’ie nitendreke fañisohañe am-pihaino’o, izaho naho ondati’oo, lehe tsy mindre ama’ay irehe? ie hampiavaheñe amy ze hene ondaty ambone’ ty tane atoy, izaho naho ondati’oo? ");
INSERT INTO tdx_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Hoe t’Iehovà amy Mosè, Toe hanoeko ka o sinaontsi’o anianio; amy te ihe nahaisa-pañosihañe am-pañenteako, toe fantako ami’ty añara’o. ");
INSERT INTO tdx_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Le hoe re, Mihalaly ama’o, Ehe aboaho amako ty asi’o. ");
INSERT INTO tdx_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Le hoe re: Hene hampiarieko aña­trefa’o ty hasoako naho ho taroñeko aolo’o eo ty tahinañe ty hoe Iehovà; le hisoheko ze hisoheko vaho ho tretrezeko ze ho tretrezeko. ");
INSERT INTO tdx_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Hoe ka re: Tsy mete hañisake ty tareheko irehe; amy te tsy ho veloñe t’in­daty mahaisak’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Aa hoe t’Iehovà, Ingo ty toetse marine’ ahy etia, mijohaña amo vatoo; ");
INSERT INTO tdx_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","vaho ie miary eo ty engeko le hifireko an-tsifitsifi’ o vatoo irehe naho ho lombofa’ ty tañako t’ie miary; ");
INSERT INTO tdx_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","le hasintako amy zao ty tañako vaho ho isa’o ty vòhoko fe tsy isaheñe ty tareheko. ");
INSERT INTO tdx_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Hoe t’Iehovà amy Mosè, Amakio ravem-bato roe hambañe amy teo rey, le ho sokireko amy rave’e rey i tsara sinokitse amy rave’e valoha’e nifoie’o rey. ");
INSERT INTO tdx_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Aa le mihentseña ho ami’ty maraindray naho mañambonea mb’ambohi’ Sinay mb’etoa te maray vaho miatrefa amako andengo’ i vohi­tsey. ");
INSERT INTO tdx_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Le tsy hindreze’ on­daty t’ie miañambone, le ko anga’o ho isake ndra aia’ aia ambohitse ey t’indaty, le ko ampiandrazeñe aolo’ i vohi­tsey o mpirai-liao naho o añombeo. ");
INSERT INTO tdx_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Aa le nampitsilake ravem-bato roe hambañe amy teo rey vaho nitroatse maraindrai-tsikiake t’i Mosè niañambone’ i Vohi-Sinay mb’eo, amy nandilia’ Iehovà azey le notroñe’e am-pità’e ao i ravem-bato roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Nizotso an-drahoñ’ ao t’Iehovà vaho nitrao-pijohañe ama’e nikoike ty tahina’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Le niary aolo’e t’Iehovà nikoike ty hoe: Iehovà, Iehovà, Andrianañahare, mpiferenaiñe naho matarike, malaon-kaboseke, miotrotro an-kasoa naho hatò, ");
INSERT INTO tdx_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","mitan-kafatraram-pikokoañe ami’ty arivo’e, le mampipoke hila naho tahiñe vaho fiolàñe, f’ie tsy hadoko tsy ho liloveñe, fa hafetsako amo anakeo naho amo ana’ o anakeoo ty hakeon-droae pak’ ami’ty faha telo naho fahefatse. ");
INSERT INTO tdx_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Aa le nalisa nibokok’ an-tane t’i Mosè niambane. ");
INSERT INTO tdx_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Le hoe re: Naho nahatendreke hasoa am-pivazohoa’o, ry Talè, le mihalaly aman-Talèko t’ie hañavelo añivo’ay ao. Toe gam-pititia ondaty retiañe, fe apoho o hakeo’aio naho o tahi’aio vaho rambeso ho hanaña’o. ");
INSERT INTO tdx_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Le hoe re, Ingo, te manao fañina añ’atrefa’ ondati’o iabio iraho; Hanoako raha tsitantane mboe lia’e tsy nanoeñe an-tane atoy ndra am-pifeheañe aia; le songa hahaisake ty fitoloña’ Iehovà ama’ areo ondaty mañohok’ azoo, fa ho raha mampañeveñe ty hanoeko añama’o. ");
INSERT INTO tdx_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ambeno koahe o andiliako azo anitoo. Inao! ho roaheko añatrefa’o i nte-Emorey naho i nte-Kanàney naho i nte-Khetey naho i nte-Perizey naho i nte-Kivey vaho i nte-Iebosey. ");
INSERT INTO tdx_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Mitomira, tsy mone hanao fañina amo mpimone’ i tane añaveloa’oio kera ho fandrik’ añivo’o ao. ");
INSERT INTO tdx_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Fe rotsaho ty kitreli’ iareo, le pozaho o hazomanga’eo vaho firao o Aserà’ iareoo ");
INSERT INTO tdx_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","le ko mitalaho aman-drahare ila’e, amy te Andrianañahare mpamarahy t’Iehovà, toe Mpamarahy ty tahina’e. ");
INSERT INTO tdx_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Kera hifañina amo mpimone’ i taneio irehe, le hañara­pilo amo ndrahare’eo iereo naho hisoroñe amo ndrahare’ iareoo naho hañambara azo hikama’o i nisoroñañey, ");
INSERT INTO tdx_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","naho hangala’o amo anak’ ampela’ iareoo ho amo anadahi’oo naho hañarapilo amo ndrahare’ iareoo o anak’ ampela’ iareoo, hampañarapilo o anadahi’oo amo ndrahare’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ko ampitranaha’o saren-drahare, ");
INSERT INTO tdx_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ambeno ty Sabadidake Mofo Po-dalivay: Fito andro ty hikama’o mofo tsy aman-dalivay; i nandili­ako azoy, amy namantañañe aze am-bolan-kofahofay; fa amy volan-kofay ty nia­kara’o i Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Hene ahiko ze manoka-koviñe naho ze valohan-dahin’ anan-kare’o, amo añombeo naho amo añondrio. ");
INSERT INTO tdx_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ho so­loa’o fiay ami’ty vik’ añondry ty valohan’ anam-borìke. Aa naho tsy soloa’o fiaiñe le folaho ty hàto’e. Ho hene soloam-piay o ana’oo. Vaho tsy hatrefeñe an-tañam-polo iraho. ");
INSERT INTO tdx_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Eneñ’ andro ty hitoloña’o naho hitofa ami’ty andro faha-fito, ndra t’ie sam-pitrobahan-tane ndra te san-kavokarañe le hitofa irehe. ");
INSERT INTO tdx_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Le hambena’o ty Sabadi­dan-kereñandro ie manese lengom-boam-bare-bolè, vaho ty sabadida-panontonan-tsabo ami’ty fivariña’ i taoñey. ");
INSERT INTO tdx_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","In-telo ami’ty taoñe ty hiatrefa’ o lahilahi’oo am’ Iehovà Talè, Andrianañahare’ Israele. ");
INSERT INTO tdx_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Le ho roaheko añ’ atrefa’o o kilakila ondatio; naho hitàreko ty faritso’o; vaho tsy eo ty hikirañe ty tane’o te ionjona’o hiatreke Iehovà Andria­nañahare’o in-telo ami’ty taoñe. ");
INSERT INTO tdx_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ko alaro lalivay ty liom-pisoroñañe amako, le ko sisañe ami’ ty maraiñe i soron-tSabadidam-Pihelañey. ");
INSERT INTO tdx_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ho banabanae’o mb’añ’anjomba’ Iehovà Andrianañahare’o ao ze lengom-boa’ ty tane’o. Ko ahandroeñe an-drononon-drene’e ty anak’ose. ");
INSERT INTO tdx_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Hoe t’Iehovà amy Mosè: Sokiro i tsara zay, fa ami’ty fanoñonañe i tsaray ty nifañinàko ama’o naho am’ Israele. ");
INSERT INTO tdx_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Efapolo andro naho efapolo haleñe ty nitraofa’e am’ Iehovà; tsy nikama mofo tsy nikama rano; vaho sinoki’e amy ravem-bato rey o tsara’ i fañinaio: i Tsara Folo rey. ");
INSERT INTO tdx_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Aa naho nizotso boak’ambohi-Sinay t’i Mosè, (ie tam-pità’ i Mosè i fañina an-dravem-bato roe rey t’ie nizotso amy vohitsey), le tsy nifohi’e te nireandreañe ty holin-dahara’e amy nifanaontsia’ey. ");
INSERT INTO tdx_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aa naho nahaoniñe i Mosè t’i Aharone naho o hene ana’ Israeleo, hehe te nireandreañe ty holin-dahara’e le nihembañe iereo tsy nahasibeke hañarivo aze. ");
INSERT INTO tdx_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Kinoi’ i Mosè amy zao iereo, le nibalike mb’ama’e mb’eo t’i Aharone naho o mpiaolo’ i valobohòkeio vaho nifanaontsy am’iereo t’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Niharine mb’eo amy zao o ana’ Israele iabio vaho hene nandilia’e i nitsa­rae’ Iehovà ama’e ambohi-Sinaiy. ");
INSERT INTO tdx_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ampara’ te heneke ty nilañonaña’ i Mosè le kinolopo’e ty lahara’e. ");
INSERT INTO tdx_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Fa naho nizilik’ añatrefa’ Iehovà ao t’i Mosè hifanaontsy, le nafaha’e i lamba marerareray ampara’ te niakatse; ie niakatse le nilañoñe amo ana’ Israeleo o raha nafantok’ ama’eo. ");
INSERT INTO tdx_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Aa naho niisa’ o ana’ Israeleo ty lahara’ i Mosè, te ni­tso­pelatse i holin-dahara’ey le kinolopo’ i Mosè indraike ty lahara’e ampara’ t’ie nizilik’ ao hifanaontsy ama’e. ");
INSERT INTO tdx_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Natonto’ i Mosè i valobohò’ Israele iabiy vaho nanoa’e ty hoe, Hoe ty tsara linili’ Iehovà hanoe’ areo. ");
INSERT INTO tdx_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Eneñ’ andro ty fitoloñan-draha, fe andro havahe’ areo ty andro fahafito, i Sabatam-pitofà am’ Iehovày. Hakoromake ze ondaty mifanehak’ ama’e. ");
INSERT INTO tdx_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Ko mamiañe afo ndra aia’aia amo kivoho’ areoo ami’ty andro Sabotse. ");
INSERT INTO tdx_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Le nisaontsie’ i Mosè i hene valobohò’ Israeley: Inao ty nandilia’ Iehovà: ");
INSERT INTO tdx_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Aneseo boak’ ama’ areo ao, le ibanabanao am’ Iehovà; ze mirearea an-troke ro hañenga am’ Iehovà: ty volamena naho volafoty vaho torisìke; ");
INSERT INTO tdx_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","naho manga naho malòmavo naho mena mañabarà naho leny marerarera vaho volon’ ose; ");
INSERT INTO tdx_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","le holi’ añondrilahy linoko mena naho holin-trozofisoitse naho mendorave; ");
INSERT INTO tdx_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","naho solike ho ami’ty hazavañe naho hafiriañe ho ami’ty menake fañorizañe naho ho ami’ ty emboke mandrifondrifoñe; ");
INSERT INTO tdx_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","naho vato sohàme naho vatosoa ho reketeñe amy kitam­bey naho amy takon’ arañañey. ");
INSERT INTO tdx_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Le homb’etoañ’ iaby ze mahihi-tro hi­tsene o raha linili’ Iehovà iabio: ");
INSERT INTO tdx_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","i kivohoy, i kibohotsey naho i rako’ey, o vitra’eo naho o varambañeo, o saka’eo, o ana-kòre’eo naho o vave’eo; ");
INSERT INTO tdx_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","i vatam-pañinay naho o bao-pitakona’eo, i toem-pijebañañey naho i lamba fañefetsey; ");
INSERT INTO tdx_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","i rairaiy naho o bao’eo naho o harao’eo naho o mofo-miatrekeo; ");
INSERT INTO tdx_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","le i fitàn-jiroy ho amy hazavàñey naho o harao’eo naho o jiro’eo naho ty mena’ i hazavàñey; ");
INSERT INTO tdx_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","naho i kitrelim-pañembohañey naho o bao’eo naho i mena-pañorizañey naho i menake mañitsey naho i lamba fañefe’ i lala-pizilihañe amy kivohoiy; ");
INSERT INTO tdx_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ty kitrely fisoroñañe rekets’ i tsingarakara’e torisìkey, o bao’eo naho o hene fanakeo, i fanasàñey rekets’ i foto’ey; ");
INSERT INTO tdx_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","o firadoradoañe an-kiririsao, o anakòre’eo naho o vave’eo naho ty lamba fañefe’ i lalambein-kiririsay; ");
INSERT INTO tdx_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","o tsato’ i kivohoio naho o tsato’ i kiririsaio vaho o tali’ iareoo; ");
INSERT INTO tdx_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","o fisiky hitoloñañe amy toe-miavakeio: o saro-miava’ i Aharone mpisoroñeo; ty fisaro’ o ana’eo hitoloña’ iareo ho mpisoroñeo. ");
INSERT INTO tdx_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Aa le nienga boak’ aolo’ i Mosè o ana’ Israele iabio. ");
INSERT INTO tdx_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Le nimb’eo ze hene niroroten-troke naho ze nampirea­rean-arofo, nanese banabana am’ Iehovà ho ami’ty fitoloñañe i kibo­hom-pamantañañey naho ho amy ze hene fitoroñañe ama’e vaho amo saro-miavakeo. ");
INSERT INTO tdx_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Songa nimb’eo an-joton-troke ty lahilahy naho ampela, ninday ravake naho kiviron-oroñe naho kiviron-tsofy, bange fitomboke naho hareañe, ze bijim-bolamena iaby; vaho ze nanokañe engam-bolamena am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ze ondaty amam-pole manga ndra malòmavo ndra mena mañabarà ndra fole leny matify ndra volon’ ose ndra holin’ añondrilahy linoko mena ndra holin-trozofisoitse, le sambe ninday. ");
INSERT INTO tdx_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ze ondaty nañenga volafoty ndra torisìke songa nibanabana aze am’ Iehovà; naho ze nahatendrehañe mendoraveñe ho amy fitoloñañe i asaiy, sindre ninday. ");
INSERT INTO tdx_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Nandrorotse fole am-pità’e ze rakemba nahihi-tro, le nendese’e i nirorote’ey, ty manga naho ty malòmavo naho ty mena mañabarà vaho ty leny matify. ");
INSERT INTO tdx_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Le nandrorotse volon-ose ze rakemba nonjone’ ty tro’e an-kihitse. ");
INSERT INTO tdx_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","O mpifeheo ninday vato sohàme naho vato soa harekets’ amy kitam­bey naho amy kalan’ arañañey; ");
INSERT INTO tdx_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","ty emboke; naho ty menake ho amy hazavàñey, ho amy mena-pañorizañey vaho ho amy emboke mañitsey. ");
INSERT INTO tdx_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Nibanabana enga an-tsatrin’ arofo am’ Iehovà ze hene ana’ Israele ndra lahi­lahy ndra rakemba nihavàtse añ’ arofo, hanolora’e amo tolon-draha linili’ Iehovà hanoeñe am-pità’ i Mosèo. ");
INSERT INTO tdx_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Le hoe t’i Mosè amo ana’ Israeleo: Ingo te kinanji’ Iehovà ami’ty tahina’e t’i Betsalale, ana’i Orý, ana’ i Kore, fifokoa’ Iehodà; ");
INSERT INTO tdx_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","naho nilifore’e ami’ty Arofon’ Añahare an-kihitse naho faharendrehañe, an-kilala naho amy ze satam-pitoloñañe iaby, ");
INSERT INTO tdx_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","hisafiry naho hamoroñe, hitoloñe am-bolamena naho volafoty vaho torisìke ");
INSERT INTO tdx_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","naho hampisilake vatosoa ho reketeñe naho hanokitse an-katae vaho hitoloñe amy ze hene karaza satam-pitàñe. ");
INSERT INTO tdx_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Le napo’e añ’arofo’e ao ty hañòke, ie naho i Oholiabe ana’ i Ahisamake, fifokoa’ i Dane. ");
INSERT INTO tdx_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Ie songa lilifore’e hihitse añ’arofo hanoa’e ze satam-panokitse naho mpamoroñe, le hamahotse am-pole manga naho malò mavo naho mena mañabarà naho leny matify hitoloñe am-panenoñañe; hitoloñe amy ze hene tolon-draha vaho hamoroñe o nisafirieñeo. ");
INSERT INTO tdx_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Aa le nitoloñe amo he’e linili’ Iehovào t’i Betsalale naho i Oholiabe naho ze ondaty nahihi-troke tinolo’ Iehovà hilala naho faharendrehañe hahafitoloña’e ze fonga karaza fitse­neañe am-pitoroñañe amy toe-miavakeiy. ");
INSERT INTO tdx_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Aa le kinai’ i Mosè t’i Betsalale naho i Oholiabe naho ze ondaty mahihits’ arofo nitolora’ Iehovà hilala naho ze nentoe’e añ’arofo’e ty homb’eo hifanehake, ");
INSERT INTO tdx_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","vaho rinambe’ iareo añatrefa’ i Mosè ze fonga raha binanabana’ o ana’ Israeleo hitoloña’ iareo ami’ty fandranjiañe i toe-miavakey. Mbe nitolom-panese banabana ama’e boa-maraiñe ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Aa akore ty hamaro’e kanao nijohañe hey o mahihitse nifanehak’ amo tolon-draha’ i toe-miavake nitoloñe’e iabiio, ");
INSERT INTO tdx_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","le ninday o saontsy zao amy Mosè, Fa ninday loho mandikoatse ze hahatsake i fitoloñañe o tolon-draha’ linili’ Iehovà anay hanoeñeoy ondatio. ");
INSERT INTO tdx_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Aa le nandily t’i Mosè naho nikoiheñe amy tobey ty hoe, Ehe te tsy hitsene raha hengaeñe amy toe-miavakey ka t’in­daty ndra rakemba. Aa le nisebañeñe ondatio tsy hanese ka; ");
INSERT INTO tdx_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","fa nahaheneke vaho nandikoatse ty hahafonirañe ze hene fitoloñañe o raha tam’ iereoo. ");
INSERT INTO tdx_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Ie amy zao, tsinene’ o mahihitse amo mpifanehak’ amy kivohoioo i lamba folo fañefetse am-pole leny rinorotse ma­tify rey ami’ty manga naho malòmavo naho mena mañabarà, vinahotse an-tsare kerobe; ");
INSERT INTO tdx_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","songa kiho roapolo-valo’ amby ty andava’ i lamba rey, sindre kiho efatse ty ampohe’e, mira habey i lamba rey. ");
INSERT INTO tdx_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Nifampivitrañe’e ho raike ty lamba lime le nifampivitrañe’e i lime ila’e rey. ");
INSERT INTO tdx_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Nitsene’e ravake manga añ’ indra’ ty lamba fañefetse añ’ila’ i tolà’e valoha’ey; mindray amy zay ty nitsene’e añ’indra’ i lamba añ’ila’ i tolà’e faharoey; ");
INSERT INTO tdx_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","ravake limampolo ty nanoe’e amy lamba fañefetse raikey, le ravake limampolo ty nanoe’e añ’ indra’ i lamba fañefetse añ’ila’ i tolà’e faharoey; nifañatreke i ravake rey. ");
INSERT INTO tdx_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Tsinene’e ty fikavitse volamena limampolo, le nampirekete’e amy fikavitse rey i lamba fañefetse rey, hampikatohañe i kivohoy ho raike. ");
INSERT INTO tdx_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Nitsenè’e lamba-lava ambolon’ ose ho fandombohañe i kivohoy; folo-raik’amby ty lamba-lava nanoe’e. ");
INSERT INTO tdx_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kiho telo-polo ty andava’ i lambalava rey, kiho efatse ty ampohe’e; le mira i lambalava folo-raik’ amby rey. ");
INSERT INTO tdx_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Navitra’e ho raike ty lambalava lime naho ho raike ty lambalava eneñe. ");
INSERT INTO tdx_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Nitsene’e ravake limampolo ho añ’indra’ ty lamba-lava añ’ ila’ i valoha’ey; le ravake limam-polo añ’indra’ i lambalava añ’ila’ i tolà’e faharoey. ");
INSERT INTO tdx_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Nitsenè’e fikavitse torisìke limampolo hifampi­reketañe i kibohotsey ho raike. ");
INSERT INTO tdx_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Le nitsenea’e rakoke an-kolin’ añondrilahy linoko mena i kibohotsey vaho holin-trozofisoitse ty ambone’e. ");
INSERT INTO tdx_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Nandranjia’e rafi-tolàñe i kivohoy, varambañe mendoraveñe mitroatse. ");
INSERT INTO tdx_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Folo kiho ty andava’ o varambañeo naho kiho raike naho tampa’e ty ampohe’e. ");
INSERT INTO tdx_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Songa aman-dahi’e roe o varambañeo hifamitrañe. Hene nanoe’e hoe izay ty rafi’ i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Le nitsenea’e rafi-tolàñ’ i kivohoy: roapolo ty varambañe atimo, miatrek’ atimo, ");
INSERT INTO tdx_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","le nitsene’e vave’e volafoty efapolo ho ambane’ i varambañe roapolo rey; vave’e roe ambane’ ty varambañe raike ho ami’ty lahi’e roe vaho vave’e roe ambane’ ty varambañe raike ka ho a ty lahi’e roe. ");
INSERT INTO tdx_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Nandranjia’e rafi-tolàñe roapolo añ’ila’ i kivohoy avaratse. ");
INSERT INTO tdx_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","naho ty vave’e volafoty efa-polo: vave’e roe ambane’ ty varambañe le vave’e roe ami’ty varambañe ila’e. ");
INSERT INTO tdx_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Niranjie’e varambañe eneñe ho añ’ila’ i kivohoy ahandrefañe. ");
INSERT INTO tdx_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Nandranjia’e varambañe roe an-kotsoke roe amboho’ i kivohoy, ");
INSERT INTO tdx_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","le nifampireketse pak’ ambone iereo vaho nampivitrañe’ ty ravake raike; izay ty nanoe’e ty roe amy hotso’e roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Nivalo ty varambañe, naho folo-eneñ’amby ty vave’e volafoty— sindre amam-bave’e roe ambane’e ty varambañe. ");
INSERT INTO tdx_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Niranjie’e saka ami’ty mendoraveñe: lime ho amo varambañe añ’ila’ i kivohoy etoa, ");
INSERT INTO tdx_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","naho saka lime ho amo varambañe añ’ ila’ i kivohoy eroa vaho saka lime ho amo varambañe amboho ahandrefa’ i kivohoio. ");
INSERT INTO tdx_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Nanoe’e saka raike hi­tsorofotse añivo’ o varambañeo boak’ añ’ ila’e pak’ añ’ ila’e. ");
INSERT INTO tdx_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Le ni­pa­kora’e volamena o varambañeo, naho nitsene’e ravake volamena hitañe o sakao vaho nipakora’e volamena o saka’eo. ");
INSERT INTO tdx_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Le manga naho malò­mavo naho mena mañabarà vaho leny rinorotse matify ty nanoe’e i lam­ba-lavay; naho nanoa’e sare kerobe an-tsatam-pamahotse; ");
INSERT INTO tdx_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","le nan­dranjie’e anakòreñe efatse ami’ty ­mendoraveñe naho nipakora’e volamena; le vola­mena o porengo’eo; vaho nam­pi­tra­naha’e foto­tse volafoty efatse. ");
INSERT INTO tdx_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Mbore fole manga naho malòmavo naho mena mañabarà naho leny rinorotse matify, an-tsatam-panenoñe mahay, maro-volo ty nanoe’e ty lamba fañefe’ i lalam-bein-kibohotsey, ");
INSERT INTO tdx_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","miharo ami’ty anakòre’e lime rekets’ o po­ren­go’eo. Nipakora’e volamena o to­ko­na’e ambone naho o ana-tolà’eo le nanoeñe torisìke i vave’e lime rey. ");
INSERT INTO tdx_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Rinanji’ i Betsalale ami’ty mendoraveñe i vatam-pañinay: kiho roe naho tampa’e ty andava’e le kiho raike naho tampa’e ty ampohe’e vaho kiho raike naho tampa’e ty haabo’e. ");
INSERT INTO tdx_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Pinako’e volamena ki’e, añate’e naho alafe’e vaho nitsenea’e soñy volamena nañarikatok’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Nampi­tra­naha’e ravake volamena efatse, harekets’ an-kotso’e efatse: ravake roe etoa vaho ravake roe eroa. ");
INSERT INTO tdx_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Nandranjia’e bao-pitakonañe ami’ty mendoraveñe vaho pinako’e volamena, ");
INSERT INTO tdx_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","le natsorofo’e amo ravake añ’ ila’ i vatam-pañinaio i baoñe rey hitakonañe i vatam-pañinay. ");
INSERT INTO tdx_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Tsinene’e volamena ki’e i toem-pijebañañey; kiho roe naho tampa’e ty andava’e naho kiho raike naho tampa’e ty ampohe’e. ");
INSERT INTO tdx_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Niranjie’e kerobe volamena roe; pinepè’e ami’ty vonga’e raike, ho añ’ ila roe’ i toem-pijebañañeio: ");
INSERT INTO tdx_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","ty kerobe etoa, le ty ke­ro­be eroa; rinanji’e ho raik’ amy toem-pijebañañey i kerobe rey songa añ’ila’e. ");
INSERT INTO tdx_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Navela’ i kerobe rey mañambone o ela’eo; nañaloke i toem-pijebañañey o ela’eo; nifañatre-daharañe iereo, nitolike mb’ amy toem-pijebañañey ty tarehe’ i kerobe rey. ");
INSERT INTO tdx_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Rinanji’e ami’ty mendoraveñe i rairaiy: kiho roe ty andava’e, kiho raike ty ampohe’e naho kiho raike naho tampa’e ty haabo’e. ");
INSERT INTO tdx_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Nipakora’e volamena ki’e vaho nandrafeta’e fiètse vola-mena hañarikoboñe aze. ");
INSERT INTO tdx_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Mbore nitsenea’e rira ampohe-pitàñe hañarikatok’ aze vaho nanoa’e indram-bolamena añ’olo’e hañariary aze. ");
INSERT INTO tdx_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Le nampitranaha’e ravake volamena efatse vaho nampirekete’e ankotso’e efatse tandrife i tombo’e efatse rey. ");
INSERT INTO tdx_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Nanoeñe marine i rira’ey i ravake rey hitàñe i bao-pitakonan-drairay rey. ");
INSERT INTO tdx_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Rinanji’e ami’ty mendoraveñe i bao-pitakonan-drairay rey le pinako’e volamena. ");
INSERT INTO tdx_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Volamena ki’e ty nitsenea’e o fanak’ ambone’ i rairaiio: o fingao, o fitovio, o soakazoo vaho o tako’eo hanakonañe irezay. ");
INSERT INTO tdx_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Le tsinene’e i fitàn-jiro volamena ki’ey; am-pipepe­hañe ty nanoa’e i fitàn-jiroy. Songa nanoen-ko raik’ ama’e ty taho’e, o tsampa’eo, o vatavo’eo, o rava-drave’eo naho o voñe’eo. ");
INSERT INTO tdx_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Eneñe ty tsampa’e niakatse amo ila’eo: tsampa’e telo ty niakatse am-pitàn-jiro etia naho tsampa’e telo ty niakatse am-pitàn-jiro atia. ");
INSERT INTO tdx_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Le an-tsampa’e etia ty vatavo telo sarem-boti-mahabibo, ty rava-draveñe naho ty ravem-boñe vaho an-tsampa’e tandrife atia ty vatavo telo sarem-boti-mahabibo sindre aman-drava-draveñe naho ravem-boñe’e; irezay ty ho a’ i tsampa’e eneñe miakatse ty taho’ i fitàn-jiroy rey. ");
INSERT INTO tdx_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Le nanoeñe vatavo efatse misare boti-mahabibo, sindre reketse rava-draveñe naho ravam-boti’e, an-taho’ i fitàn-jiroy; ");
INSERT INTO tdx_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","le ty rava-draveñe miray ami’ty fireketa’ ty tsempa’e roe amy tahoy, ie ho amy tsampa’e eneñe miakatse ama’e rey. ");
INSERT INTO tdx_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Raik’ amy taho’ey o rava-drave’eo naho o tsampa’eo, hene pinepèke am-bongam-bola­mena ki’e raike. ");
INSERT INTO tdx_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Le tsinene’e volamena ki’e ty jiro’e fito naho o fiharatan-tsokotsoko’eo vaho o sadròm-baen’ afo’eo. ");
INSERT INTO tdx_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Nanoe’e am-bongam-bolamena ki’e ­talenta raike, ie naho o fana’e iabio. ");
INSERT INTO tdx_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Rinanji’e ami’ty mendoraveñe ty kitrelim-pañembohañe: kiho raike ty andava’e, kiho raike ty ampohe’e, efa-mira, vaho kiho roe ty haabo’e. Raik’ ama’e o tsifa’eo. ");
INSERT INTO tdx_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Nipakora’e volamena ki’e, ty tako’e naho o ila’e niarifehe azeo vaho o tsifa’e miariary azeo. Le nitsenea’e soñy volamena nañarikatok’ aze. ");
INSERT INTO tdx_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Nitsene’e ravake volamena roe ho ambane’ i soñi’ey, an-kotso’e roe atoy naho ami’ty roe aroy, hitañe o bao-pitakonañ’azeo. ");
INSERT INTO tdx_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Rinanji’e ami’ty mendoraveñe o bao’eo le nipakora’e volamena. ");
INSERT INTO tdx_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Nanoe’e i mena-pañorizañe miavakey naho i emboke ki’e marifondrifoñe an-kafiriañe an-tsatam-panao embokey. ");
INSERT INTO tdx_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Rinanji’e ami’ty mendoraveñe i kitrelim-pisoroñañey: kiho lime ty andava’e; naho kiho lime ty ampohe’e, efa-mira; vaho telo kiho ty haabo’e. ");
INSERT INTO tdx_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Tsinene’e ankotso’e efatse o tsifa’eo; raik’ ama’e i tsifa’e rey, le nipakora’e torisìke. ");
INSERT INTO tdx_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Tsinene’e iaby ty fana’ i kitreliy: o valàñe’eo naho o sadrò’eo naho o koveta’eo naho o firango’eo vaho o endra­endra’eo; hene nanoeñe torisike o fana’eo. ");
INSERT INTO tdx_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Le nanoa’e tsikarakarake torisìke i kitreliy, mifototse ambane’ i soñi’ey miefetse ami’ty fivaki-mirà’ ty haabo’e. ");
INSERT INTO tdx_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Nampitranaha’e ravake efatse ho an-kotso’e efa’ i tsikarakarake torisìkey hitañe o bao’eo. ");
INSERT INTO tdx_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Le rinanji’e ami’ty mendoraveñe o bao’eo vaho nipakora’e torisìke. ");
INSERT INTO tdx_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Le nazili’e amo ravake añ’ ila’ i kitreliio o bao-pitakonaño. Nanoe’e koake am-barambañe. ");
INSERT INTO tdx_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Tsinene’e an-torisìke i fanasàñey naho torisìke i foto’ey, boak’ amo hetsoro natolo’ o rakemba mpitoroñe an-dalan-kibohom-pamantañañeo. ");
INSERT INTO tdx_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Le nihajarie’e ty kiririsa; naradorado’e añ’ ila’e atimo ty lamba leny rinorotse marerarera; zato kiho. ");
INSERT INTO tdx_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Roapolo ty anakòre’e naho roapolo ty foto’e torisìke. Volafoty ty porengo’ o ana-koreñeo naho o bandi’eo. ");
INSERT INTO tdx_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Zato kiho ka ty avaratse; ty anakòre’e roapolo naho ty tombo’e torisìke roapolo vaho volafoty ty porengo’ o anakòreñeo naho o bandi’eo. ");
INSERT INTO tdx_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Limampolo kiho ty firadoradoañe ahandrefañey; folo ty anakòre’e naho folo ty tombo’e. Volafoty ty porengo’ i anakòre’e rey naho o bandi’eo. ");
INSERT INTO tdx_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Le atiñana miatrek’ atiñanañe: limampolo kiho. ");
INSERT INTO tdx_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Folo lime-amby kiho ty andava’ ty firadoradoañe etoa, telo ty anakòre’e naho telo ty foto’e. ");
INSERT INTO tdx_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Añ’ila’ i lalan-kiririsay eroa ty firadoradoañe folo lime amby kiho, etoa naho eroa naho ty anakore’e telo naho tombo’e telo. ");
INSERT INTO tdx_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Sindre aman-deny rinorotse matify o firadoradoan-dambalava nañarikatoke i kiririsaio. ");
INSERT INTO tdx_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","An-torisìke ty vave’ o anakòre’eo; volafoty ty porengo’ o anakòreñeo naho o bande’eo, pinakotse volafoty ka o honko’eo; songa amam-bandy volafoty o anakòre’ i kiririsaio. ");
INSERT INTO tdx_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Satam-pamahotse i lambalamba fañefetse an-dalambein-kiririsay: am-pole manga naho malòmavo naho mena mañabarà vaho leny rinorotse marerarera; roapolo kiho ty andava’e naho lime kiho ty haabo’e manahake ty am-pohe’ o firadoradoañe an-kiririsao. ");
INSERT INTO tdx_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Efatse ty anakòre’e reketse ty vave’e torisìke efatse; volafoty o porengo’eo, naho nipakorañe volafoty o honko’eo naho o bandi’eo. ");
INSERT INTO tdx_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Songa torisìke ty tsato’ i kivohoy naho i kiririsa mañarikatok’ azey. ");
INSERT INTO tdx_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Intoy ty famolilañe’ i kivohoy, i kivohom-pañinay, amy namantoha’ i Mosèy, nisokire o nte-Levio, ambanem-pità’ Itamare ana’ i Aharone mpisoroñe. ");
INSERT INTO tdx_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Namboare’ i Betsalale ana’ i Ory, ana’ i Kore, fifokoa’ Iehodà, ze hene nandilia’ Iehovà amy Mosè hamboareñe. ");
INSERT INTO tdx_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Nañolotse aze t’i Oholiabe ana’ i Ahisamake, fifokoa’ i Dane, mpandranjy naho mpanao sare naho mpanenoñe mahay volo: ami’ty manga naho ty malòmavo naho ty fole mena mañabarà vaho ty leny matify. ");
INSERT INTO tdx_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Nahatakatse talenta roapolo-sive’ amby naho sekele fitonjato-tsi-telopolo, toe sekele’ i toe-miavakey, ty volamena nitseneñe ze hene raha amy toe-miavakey, amy volamena binanabanay. ");
INSERT INTO tdx_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Le talenta zato naho sekele arivo-tsi-fitonjato-tsi-fitompolo lime amby, toe sekele’ i toe-miavakey, ty volafoty amo niaheñe amy fivoribeiio; ");
INSERT INTO tdx_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","bèka raike ty vili-loha’ (toe vakin-tsekele’ i toe-miavakey raike), ze hene on­daty nitsake mb’amo niaheñeo amo niroapolo taoñe mañamboneo, aa le enen-ketse-tsi-telo-arivo-tsi-limanjato-tsi-limam­polo. ");
INSERT INTO tdx_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Volafoty zato talenta ty natranake ho a o vave’ i toe-miavakeio naho o vave’ i lamba fañefetse reio: talenta zato ty vave’e zato, talenta raike ty vave’e raike. ");
INSERT INTO tdx_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Le amy sekele arivo-tsi-fiton-jato-tsi-fitompolo lime amby rey ty nitsenea’e ty porengo’ o anakòreñeo naho nipakora’e o honko’eo vaho nanoe’e o bandi’eo. ");
INSERT INTO tdx_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Fitompolo talenta naho ro-arivo-tsi-efajato sekele ty torisìke nengaeñe; ");
INSERT INTO tdx_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","ama’e ty nitsenea’e o vave’ i lalan-kibohom-pamantañañeio, i kitrely torisìkey, i tsikarakara’e torisìkey naho o fana’ i kitreliy iabio, ");
INSERT INTO tdx_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","naho ty vave’ i kiririsa miarikatokey, o foto’ i lalambein-kiririsaio, ze hene tsato’ i kivohoy vaho ze fonga tsatoke amy kiririsa miarifehe azey. ");
INSERT INTO tdx_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Nanao sarom-pitoroñañe am-pole manga naho malòmavo naho mena mañabarà ho ami’ty fitoloñañe amy toe-miavakey, izay ty nanjairañe o saroñe miava’ i Aharoneo ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Tineno’e am-pole volamena naho manga naho malòmavo naho mena mañabasà vaho leny rinorotse matify i kitambey. ");
INSERT INTO tdx_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Pinepè’ iereo i volamenay ho endraendra matify le linily ho fole hitraoke amy fole mangay naho i malòmavoy naho i mena mañabaràñey vaho i leny matifiy; an-tsatam-pamahotse. ");
INSERT INTO tdx_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Tsinene’ iareo i an-tsoro’e rey hifampireketse: ami’ty indra’e roe t’ie nampireketañe. ");
INSERT INTO tdx_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Le nindray fitenoñe amy kitambey i sadia ama’ey, am-bolamena naho fole manga naho malòmavo naho mena mañabarà vaho leny rinorotse matify, ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Tsinene’ iareo o vato sohàmeo, nireketañe am-bolamena vinanditse vaho nisokirañe i tahinan’ ana’ Israele rey manahake ty fisokiram-boli-pitomboke. ");
INSERT INTO tdx_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Napeta’e an-tsoro’ i kitambey irezay ho vato faniahiañe o ana’ Israeleo, amy nandilia’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Le tsinene’e an-tsatam-pamahotse i takon’ arañañey hambañe ami’ty sata’ i kitambey ami’ty fole volamena naho manga naho malòmavo naho mena mañabarà vaho leny rinorotse matify. ");
INSERT INTO tdx_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Efa-mira izay, le nanoe’ iereo roe mikopoke i takon’ arañañey, zehe raike ty andava’e naho zehe raike ty ampohe’e t’ie akopake. ");
INSERT INTO tdx_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Napeta’ iereo ama’e am-piriritañe efatse o vatoo: ty firirita’e valoha’e, le ty òdeme, ty pitdà vaho ty barèkete. ");
INSERT INTO tdx_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Ty firirita’e faharoe: ty nofèke, ty safira vaho ty iahalòme. ");
INSERT INTO tdx_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Ty firirita’e fahatelo: ty lèseme, ty sebò vaho ty aklàma; ");
INSERT INTO tdx_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","le ty firirita’e fah’efatse: ty tarsise, ty sohàme vaho ty iasefày; sindre nivontitire’ ty volim-boñe volamena tsingarakarake. ");
INSERT INTO tdx_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Nilahatse ami’ty tahina’ o ana’ Israeleo i vato rey, folo-ro’amby ty amo tahina’eo; nisokireñe an-tsatan-tsokim-pitom­boke, songa ninday ty tahinañe raik’ amy fifokoa folo-ro’ambi’ Israele rey. ");
INSERT INTO tdx_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Nitsenea’ iereo silisily volamena ki’e vinandivanditse ty añ’ ila’ i takon’ arañañey. ");
INSERT INTO tdx_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Le tsinene’ iareo ty volim-boñe volamena roe naho bange volamena roe vaho napite’ iareo ami’ty ila’ i takon’ arañañe roey i bange roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Le nazili’ iareo amy bange añ’ ila’ i takon’ arañañeiy i silisily volamena vinanditse roe rey. ");
INSERT INTO tdx_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Nampirekete’ iareo amy volim-boñe roe rey ty ila’ i silisily vinanditse roe rey vaho napeta’ iareo an-tsoro’ i kitambey, aolo’e eo. ");
INSERT INTO tdx_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Le nitsene’ iereo bange volamena roe vaho napetak’ ami’ty ila’e roe’ i takon’ arañañey, andrira’e ambane’ i kitambey. ");
INSERT INTO tdx_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Le nitsene’ iareo bange volamena roe napetak’ ambane’ i talin-tsoro’ey aolo i ki­tambey, an-difi’e ambone’ ty fireketañe i fièn-kitambe vinahotsey. ");
INSERT INTO tdx_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Aa le finehe’ iereo i takon’ arañañey amy bange’ rey amy bange’ i kitambey rey ami’ty fole manga, soa t’ie ho ambone’ i fièn-kitambey vaho tsy hibalak’ amy kitambey i takon’ arañañey; amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Le tsinene’e an-tsatan-tenoñe ty saro’ i kitambey, fonga manga, ");
INSERT INTO tdx_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","le añi­vo’e ty fisokafañe i saroñey, manahake ty loak’ an-tsarom-pikalañe, nifahareñe am-pitrebeke ty lifi’e añ’ariary aze tsy ho riatse. ");
INSERT INTO tdx_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Le vinaho’ iereo an-difi’ i saroñey ty sarem-boan-dagoa ami’ty manga naho malòmavo naho mena mañabarà vaho leny rinorotse. ");
INSERT INTO tdx_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Le nitsene’ iereo fikorin­tsañe volamena ki’e nasabadiga amo dagoao an-difi’ i sarom-pitoro­ñañey miariary aze, añivo’ o voan-dagoao. ");
INSERT INTO tdx_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Fikorintsañe naho voan-dagoa, fikorintsañe naho voan-dagoa añariary ty lifi’ i saroñey, ho amy fitoroñañey, amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Le trinebe’ iareo o saron-deny tinenoñe matify ho a i Aharone naho o ana’eoo ");
INSERT INTO tdx_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","naho i sabaka leny marerareray naho i fikolopoke leny matifiy vaho o kiloty leny rinorotse matifio, ");
INSERT INTO tdx_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","le i fiè­tsey leny rinorotse matify am-pole manga naho malòmavo vaho mena mañabarà nivahorem-pitrebeke; ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Le nitsenè’ iereo i vilon-daharañe volamena ki’e miavakey vaho nisokirañe an-tsatan-tsokim-pitomboke ty hoe: ­Miavak’ am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Le name­taha’ iareo talimanga handreketse aze amy sabakay, ambone’e; amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Aa le hene nifonitse i fitoloñañe amy kivohoiy, amy kibohom-pamantañañey; ie nanoe’ o ana’ Israeleo hambañe amy nandilia’ Iehovà i Mosèy, izay ty nanoe’ iareo. ");
INSERT INTO tdx_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Le nendese’ iareo mb’amy Mosè mb’eo i kivohoy, i kibohotsey rekets’ o harao’e iabio: o fikavitseo, o varambañeo, o saka’eo, o anakòre’eo naho o vave’eo; ");
INSERT INTO tdx_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","i rakoke holits’ añondrilahy linoko menay naho i fikopo’e holin-trozofisoitsey naho i lamba marerarera fañefetsey; ");
INSERT INTO tdx_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","i vatam-pañinay rekets’ o bao’eo naho i toem-pijebañañey; ");
INSERT INTO tdx_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","i rairaiy naho o fana’e iabio naho i mofo-piatrefañe rey; ");
INSERT INTO tdx_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","i fitàn-jiro ki’ey rekets’ o jiro’eo, i jiro’e ho hajarieñe rey, o harao’e iabio naho ty mena’ o jiroo; ");
INSERT INTO tdx_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","i kitrely volamenay, i mena-pañorizañey, i emboke mañitsey, i lamba fañefe’ ty lalambein-kibohotsey; ");
INSERT INTO tdx_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","i kitrely torisìkey, i tsingarakara’e torisìkey, i bao’e rey, o harao’e iabio, i fana­sàñey naho i tombo’ey; ");
INSERT INTO tdx_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","o lamba firadorado an-kiririsa eio, o anakòre’eo naho o vave’eo; i lamba fañefe’ i lalambein-kiririsaiy; o tali’eo, o tsato’eo, o haraotse iaby fitoroñañe amy kivohoy, amy kibohom-pamantañañeio; ");
INSERT INTO tdx_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","le o saroñe tinenoñeo, hitoroñañe amy toe-miavakeio: o saroñe miava’ i Aharone mpisoroñe naho o saron’ anadahi’eo hitoroñe ho mpisoroñeo. ");
INSERT INTO tdx_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Nanoe’ o ana’ Israeleo iaby i fitoloñañey hambañe amy ze hene linili’ Iehovà amy Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Fonga nisarie’ i Mosè i fitoloñañey, le ingo nifonire’ iereo hambañe amy nandilia’ Iehovày, ie i nanoañey. Le nandriaña’ i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Nitsara amy Mosè t’Iehovà nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Atroaro ami’ty andro valoha’ i volam-baloha’ey i kivohon-kibohom-pamantañañey. ");
INSERT INTO tdx_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Apoho ao i vatam-pañinay vaho ampiavaho amy lamba fañefetsey i vatay. ");
INSERT INTO tdx_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Aziliho ao i rairaiy le hajario ama’e o harao’eo naho endeso ao i fitàn-jiroy vaho areheto i jiro’e rey. ");
INSERT INTO tdx_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Apoho aolo’ i vatam-pañinay i kitreli-pañembohañe volamenay vaho apetaho ami’ty lala’ i kivohoy i lamba-fañefe’ey. ");
INSERT INTO tdx_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Le apoho aolo’ ty lala’ i kivohon-kibohom-pamantañañey i kitrely fisoroñañey. ");
INSERT INTO tdx_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Le apoho añivo’ i kibohom-pamantañañey naho i kitreliy i fanasàñey vaho ampidoaño rano; ");
INSERT INTO tdx_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","hajario ty añ’ariari’ i kiririsay vaho aradoradò amy lalan-kiririsay i lamba fañefe’ey. ");
INSERT INTO tdx_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Rambeso amy zao i mena-pañorizañey naho hene orizo i kivohoy naho ze ama’e ao vaho tokano rekets’ o fana’e iabio hiavake; ");
INSERT INTO tdx_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","le orizo i kitrely fisoroñañey naho ze hene harao’e vaho tokano i kitreliy, hiavahe’ i kitreliy do’e. ");
INSERT INTO tdx_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Le orizo ka i fanasàñey naho o tombo’eo vaho ampiavaho. ");
INSERT INTO tdx_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Endeso mb’amy lalan-kibohom-pamantañañey mb’eo t’i Aharone naho o anadahi’eo vaho ampandrò an-drano; ");
INSERT INTO tdx_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","le aombeo amy Aharone o saro miavakeo naho orizo vaho ampiavaho hitoroñ’ ahy ho mpisoroñe. ");
INSERT INTO tdx_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ampombao mb’eo o ana’eo vaho añombeo saroñe. ");
INSERT INTO tdx_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Orizo mana­hake i nañoriza’o an-drae’ iareoy hitoroñ’ ahy ho mpisoroñe; fa ho fisoroñañe tsy modo amo fifokoa’ iareo mifandimbeo ty fañorizañe iareo. ");
INSERT INTO tdx_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Nanoe’ i Mosè irezay hambañe amy nandilia’ Iehovà azey. ");
INSERT INTO tdx_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Aa le natroatse ami’ty andro valoha’ i volam-baloha’ i taoñe faha-roey i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Natroa’ i Mosè i kivohoy naho najado’e an-toe’e o tombo’eo, hinalanka’e o varambañeo, nazili’e o saka’eo vaho natroa’e o anakòre’eo. ");
INSERT INTO tdx_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Le vinela’e ambone’ i kivohoy i kibohotsey naho nalafi’e ambone’ izay i rakokey, amy nandilia’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Rinambe’e i fañinay le najo’e amy vatay, le nazili’e amo ravake amy vataio i baoñe rey vaho napo’e ambone’ i vatay i toem-pijebañañey; ");
INSERT INTO tdx_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","le nendese’e amy kivohoy i vatay, nahanto’e i lamba fañefetsey vaho nefera’e i vatam-pañinay amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Napo’e amy kibohom-pamantañañeio i rairaiy, avara’ i kivohoy, alafe’ i lamba fañefetsey, ");
INSERT INTO tdx_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","le hinajari’e hiriritse ama’e ty mofo añatrefa’ Iehovà, amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Napo’e amy kibohom-pamantañañeio i fitàn-jiroy, tandrife i rairaiy, añ’ila atimo’ i kivohoy, ");
INSERT INTO tdx_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","le narehe’e i jiro rey añatrefa’ Iehovà ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Napo’e aolo’ i lamba fañefetsey amy kibohom-pamantañañeio i kitrely volamenay ");
INSERT INTO tdx_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","le na­tsotse ama’e i emboke aman-kafiriañe mañitsey, amy nandilia’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Natroa’e an-dalambei’ i kivohoy i lamba fañefetsey. ");
INSERT INTO tdx_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Napo’e an-dalam-pimoahañe amy kivohoy—i kibohom-pamantañañey—i kitreli-pisoroñañey, le nañenga soroñe naho enga-mahakama ama’e, amy nandilia’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Napo’e añivo’ i kibohom-pamantañañey naho i kitreliy i fanasàñey vaho nañiliña’e rano fanasàñe; ");
INSERT INTO tdx_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","hanasa’ i Mosè naho i Aharone vaho o ana’eo fitàñe naho fandia; ");
INSERT INTO tdx_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","hisasa’ iareo naho hizilike amy kibohom-pamantañañeio ndra hañarine i kitreliy, amy nandilia’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Vaho, natroa’e ty fahe’ i kiririsa añariari’ i kivohoy naho i kitreliy vaho naradorado’e i lamba fañefetse an-dalambein-kiririsaiy. Aa le nifonira’ i Mosè i fitoloñañey. ");
INSERT INTO tdx_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Nakopo’ i rahoñey amy zao i kibohom-pamantañañey vaho nandifotse i kivohoy ty enge’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Aa le tsy nimete nizilik’ amy kibohom-pamantañañeio t’i Mosè amy te nivotrak’ ama’e i rahoñey vaho nandifotse i kivohoy ty enge’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Ndra mbia’mbia nionjoñe ambone’ i kivohoy i rahoñey, le nionjoñe mb’amo hene fañaveloa’ iareoo mb’eo o nte’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Fa naho tsy nionjoñe i rahoñey le tsy nionjon-dia ka iereo ampara’ ty andro ionjona’e. ");
INSERT INTO tdx_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Tambone’ i kivohoy ty raho’ Iehovà naho antoandro, le afo ty tama’e naho haleñe aolom-pihaino ze hene anjomba’ Israele amo fiavota’ iareo iabio. ");
INSERT INTO tdx_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Aa le kinanji’Iehovà t’i Mosè vaho nisaontsia’e boak’ amy kibohom-pamantañañey ty hoe: ");
INSERT INTO tdx_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Misaontsia amo ana’ Israeleo le ano ty hoe: Naho ama’ areo ty hañenga soroñe am’ Iehovà, le añandeso amo hare’ areoo: he amo lia-raikeo ke amo añombeo. ");
INSERT INTO tdx_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Aa ie hañenga soroñe boak’ am-pirai-trokey, le lahi’e tsy aman-kandra, an-tsatrin-tro’e t’ie hañenga añatrefa’Iehovà an-dalan-kibohom-pamantañañe eo. ");
INSERT INTO tdx_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Hasampe’e an-doha’ i hisoroñañey o fità’eo, soa te ho rambeseñe ama’e ho fijebańañe aze. ");
INSERT INTO tdx_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Ho lentae’e añatrefa’Iehovà i baniay; le hendese’ o ana’ i Aharone mpisoroñeo ty lio’e vaho hada­si’ iareo añariary i kitrely an-dalan-kibohom-pamantañañey ty lio’e. ");
INSERT INTO tdx_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Le ho holire’e i hisoroñañey vaho ho patepatere’e. ");
INSERT INTO tdx_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Le hampipok’ afo amy kitreliy o ana’i Aharone, Mpisoroñeo, vaho handahatse ty hatae amy afoy. ");
INSERT INTO tdx_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ho hajarie’ o mpisoroñe, ana’ i Aharoneo, amo hatae añ’ afo ambone’ i kitreliio o tori-henao naho i lohay vaho i safots-ènay; ");
INSERT INTO tdx_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","le ho sasà’e an-drano o aova’eo naho o tombo’eo, naho ho forototoe’ i mpisoroñey irezay ho hatoeñe ambone’ i kitreliy, ho soroñe, enga oroañe añ’ afo, ­hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Aa naho boak’ amo mpirai-liao—ke añondry he ose—ty hisoroñañe, le ho lahi’e tsy aman-kandra ty hengae’e. ");
INSERT INTO tdx_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Ho lentà’e avara’ i kitrely añatrefa’ Iehovày, vaho hadàsi’ o ana’ i Aharone mpisoroñeo añ’ariari’ i kitreliy ty lio’e. ");
INSERT INTO tdx_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Ho lilie’e i henay; vaho halaha’ i mpisoroñey ami’ty hatae amy afo ambone’ i kitreliiy ty loha’e naho ty safo’e, ");
INSERT INTO tdx_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","le ho sasà’e rano o ova’eo naho o tombo’eo naho ho fonga engae’ i mpisoroñey, hengae’e an-katoeñe amy kitreliy ho soroñe, enga oroañe añ’ afo, hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Aa naho voroñe ty hengae’e ho soroñañe am’ Iehovà; he deho ke ana-boromahilala ty ho banabanae’e. ");
INSERT INTO tdx_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Hendese’ i mpisoroñey mb’ amy kitreliy mb’eo, le haola’e i lohay, naho hengae’e an-katoeñe amy kitreliy; vaho hampiorihe’e añ’ila’ i kitreliy o lio’eo. ");
INSERT INTO tdx_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Hafaha’e ty tsibokò’e naho o volo’eo vaho hahi­fi’e ami’ty ila atiñana’ i kitreliy mb’amy toen-davenokey. ");
INSERT INTO tdx_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Ho vorahe’e amo ela’eo fe tsy ho riate’e roe, le hengae’ i mpisoroñey ho hatoeñe amy kitreliy amy hatae ambone’ i afoiy; ho soroñe, enga oroañe añ’afo, hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Aa naho eo ty mibanabana enga-mahakama am’ Iehovà, le mona-disañe ty hengae’e, naho hañiliña’e menake, vaho hampipoha’e emboke; ");
INSERT INTO tdx_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","hendese’e amo ana’ i Aharone mpisoroñeo, le hañakatse ty mahàtsa-pitàñe amo monao naho amo mena’eo mitraok’ amy ze hene embo’e, le hengae’ i mpisoroñey ho tiahy, hatoeñe amy kitreliy, enga oroañe an’ afo, hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ho a i Aharone naho o ana’eo ty tsy ri’ i mona nengaeñey; ie miava-do’e amo soroñañe am’Iehovào. ");
INSERT INTO tdx_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Aa ihe mibanabana enga-mahakama nimasaheñe an-toñake, le mofo tsy aman-dalivay ama’ mona linaro menake; ndra mofo tseake matify po-dalivay hinoso-menake. ");
INSERT INTO tdx_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Aa naho banabanae’o ty enga-mahakama nimasaheñe am-pinga, le ho mona tsy aman-dalivay linaro menake. ");
INSERT INTO tdx_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Peñapeñafo vaho añiliño menake: enga-mahakama izay. ");
INSERT INTO tdx_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Aa naho banabanae’o ty enga-mahakama nimasaheñe am-balàñe, le hanoeñe ami’ty mona linaro menake. ");
INSERT INTO tdx_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ie banabanae’o ho enga-mahakama am’ Iehovà, amy nanoeñe rezay, le hatolotse amy mpisoroñey le ie ty hanese aze mb’amy kitreliy mb’eo, ");
INSERT INTO tdx_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","le hangalà’ i mpisoroñey tiahy i enga mahakamay vaho hengae’e an-katoeñe amy kitreliy; ho enga oroañe añ’afo, hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Le ho a i Aharone naho o ana’eo ty tsy ri’ i enga-mahakamay, ie miava-do’e amo soroñañe am’Iehovào. ");
INSERT INTO tdx_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Tsy anoeñe aman-dalivay ze mahakama engaeñe am’ Iehovà; toe tsy hengaeñe an-katoeñe ho enga oroañe añ’afo am’Iehovà ty lalivay ndra tantele. ");
INSERT INTO tdx_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Mete engaeñe ho lengom-boa am’ Iehovà, f’ie tsy hengaeñe ho hàñim-pañanintsiñe an-kitrely. ");
INSERT INTO tdx_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Mbore ho sirae’o aman-tsira ze hene maha­kama engae’o, tsy hado’o tsy ho amy ze enga mahakama’o iaby ty siram-pañinan’ Añahare’o. Engao aman-tsira ze hene engae’o. ");
INSERT INTO tdx_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ie banabanae’o am’Iehovà ty enga-mahakama anoeñe loha-voñe, le ampemba vao natono an’ afo, voam-bora’e vao nilisaneñe ro hengaeñe ho enga-mahakaman-dengo’e. ");
INSERT INTO tdx_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Hosoro menake le ampipoho emboke, enga-mahakama izay. ");
INSERT INTO tdx_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Hengae’ i mpisoroñey an-katoeñe ty tiahy amy ampemba-lisañey naho ty tampa’ i menakey vaho ty embo’e iaby ho enga oroañ’ an’ afo am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Aa ie mañenga sorom-pañanin­tsiñe, le boak’ ampirai-trok’ ao, ke vave he lahy, ie tsy aman-kandra ty hampiatrefa’e am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Hasampe’e an-doha’ i enga’ey ty fità’e vaho ho lentà’e an-dalan-kibohom-pamantañañe ey; le hadasi’ o ana’ i Aharoneo añariari’ i kitreliy ty lio’e; ");
INSERT INTO tdx_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","vaho ho soroña’e am’Iehovà ty tsila’ i engam-pañanintsiñey: Ty safo’e manaroñe o ova’eo, toe ze hene safo’e amo ova’eo; ");
INSERT INTO tdx_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","naho ty voa’e roe mitraok’ amo safo’eo, o an-deme’eo, naho i kambinate’ey ze hafaha’e rekets’ i voa’e rey, ");
INSERT INTO tdx_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ro hengae’ o ana’ i Aharoneo an-katoeñe amy kitreliy, ambone i soroñañe an-katae añ’afoy, toe enga-koroañe an’ afo ho hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Aa naho boak’amo lia-raikeo ty engam-pañanintsiñe ho soroña’e am’Iehovà ke t’ie lahy he vave, le ty tsy aman-kandra ty hengae’e. ");
INSERT INTO tdx_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ie mibanabana ty vi’e hisoroña’e, le hengae’e añatrefa’ Iehovà, ");
INSERT INTO tdx_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","naho hampitongoae’e an-doha’ i banabanay ty fità’e le ho lentae’e aolo’ i kibohom-pamantañañey; vaho hadasi’ o ana’ i Aharoneo añariari’ i kitreliy ty lio’e. ");
INSERT INTO tdx_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Ho banabanae’e boak’ amy engam-pañanin­tsiñey ty ho soroñañe am’ Iehovà: o safo’eo, i hofa’e vondrakey ie hafahañe reketse ty lambosim-pohe’e naho ty sabora manaroñe o ova’eo, toe ze hene sabora amo ova’eo, ");
INSERT INTO tdx_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","naho ty voa’e roe mitraok’ amo safo’eo, o an-demeo, naho i kambinatey ie hafaha’e rekets’ o voa’eo ");
INSERT INTO tdx_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","vaho hengae’ i mpisoroñey an-katoeñe amy kitreliy, fa maha­kama, enga oroañe añ’afo am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Aa naho ose ty hisoroña’e, le ho banabanae’e añatrefa’ Iehovà; ");
INSERT INTO tdx_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ha­nampeza’e fitàñe i loha’ey, le ho len­tae’e aolo’ i kibohom-pamantañañey eo, vaho hadasi’ o ana’ i Aharoneo añariari’ i kitreliy ty lio. ");
INSERT INTO tdx_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Le ho soroña’e ho enga oroañe an’ afo am’ Iehovà: ty safo’e manaroñe o ova’eo, toe ze hene safo’e amo ova’eo; ");
INSERT INTO tdx_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","naho ty voa’e roe mitraok’ amo safo’e an-demeo, naho hafaha’e i kambinatey rekets’ i voa’e rey, ");
INSERT INTO tdx_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","vaho hengae’ i mpisoroñey amy kitreliy ho mahakama, enga oroañe añ’afo, hàñim-pañanin­tsiñe; aIehovà ty safo’e iaby. ");
INSERT INTO tdx_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Ho fañè tsy modo amo hene tarira’ areo mifandimbeo, am-pitobea’ areo iaby, te tsy ho kamae’ areo ty safo’e ndra ty lio. ");
INSERT INTO tdx_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Hoe ty nitsara’Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Misaontsia amo ana’ Israeleo ty hoe, Naho eo t’indaty manao hakeo tsy nisatrie’e amo hene raha linili’Iehovà tsy ano­eñeo, vaho anoe’e ty raike; ");
INSERT INTO tdx_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","aa naho manao hakeo ty norizan-ko mpisoroñe, ie mañakeo ondatio, le bania tsy aman-kandra ty hengae’e ty amy tahiñe nanoe’ey, ho engan-kakeo am’ Iehovà, ty amy hakeo’ey. ");
INSERT INTO tdx_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Hendese’e mb’an-dalan-kibohom-pamantañañe mb’añatrefa’Iehovà mb’eo i baniay le hanampeza’e fitàñe ty loha’ i baniay; vaho ho lentae’e aolo’Iehovà i baniay. ");
INSERT INTO tdx_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Hangalà’ i mpisoroñe norizañey ty lio’ i baniay vaho hendese’e mb’amy kibohom-pamantañañey mb’eo. ");
INSERT INTO tdx_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Le halò’ i mpisoroñey amy lioy ty rambo-pità’e naho hafitse’e im-pito añatrefa’Iehovà aolo’ i lamba fañefe’ i toe-miavakeiy i lioy ");
INSERT INTO tdx_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","naho ha­ten­te’ i mpisoroñey amo tsifa’ i kitrelin-emboke mañitse amy kibohom-pamantañañey añatrefa’ Iehovàio ty ila’ i lioy; le hadoa’e am-poto’ i kitrelim-pisoroñañe an-dalan-kibohom-pamantañañey ty tsy ri’ i lio’ i baniaiy. ");
INSERT INTO tdx_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Hafaha’e ze hene safo’ i banian-engan-kakeoy: ty safo’e misaroñe o ova’eo naho ze safo’e iaby amo ova’eo; ");
INSERT INTO tdx_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","naho ty voa’e roe mitraok’ amo safo’e an-demeo, naho i kambinatey ze hafaha’e rekets’ i voa’e rey, ");
INSERT INTO tdx_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","hambañe amy nañafahañ’ aze amy banian-tsorom-pañanintsiñey, vaho hengae’ i mpisoroñey an-katoeñe amy kitrelim-pisoroñañey. ");
INSERT INTO tdx_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Le ty amy holi’ i baniay naho o hena’e iabio mitraok’ ami’ty loha’e, miharo amo tombo’eo naho o ova’eo vaho ty tai’e, ");
INSERT INTO tdx_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","toe i tsi-ri’ i baniay iabiy, ro hendese’e mb’an-diolio alafe’ i tobey, mb’amy fañarian-davenokey mb’eo ho forototoeñe añ’afo an-katae; amy fañarian-davenokey ty hañoroañ’ aze. ");
INSERT INTO tdx_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Aa naho manao hakeo tsy nisatrie’e ty valobohò’ Israele, ie nietak’ am-pihaino’ i fivoribeiy, ie nandilatse aman-dra’ inoñ’ inoñe linili’ Iehovà tsy hanoeñe vaho voa hakeo ");
INSERT INTO tdx_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","aa naho rendreke i tahiñe nanoe’ iereoy, le hañenga bania ho soron-kakeo i fivoribeiy vaho hendesa’ iereo aolo’ i kibohom-pamantañañey eo. ");
INSERT INTO tdx_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Hanampeza’ o roandria’ i tobeio fitàñe añatrefa’Iehovà ty loha’ i baniay, le ho lentaeñe añatrefa’Iehovà i baniay. ");
INSERT INTO tdx_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Hañandesa’ i mpisoroñe norizañey mb’amy kibohom-pamantañañey mb’eo ty lio’ i baniay, ");
INSERT INTO tdx_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","le handò i mpisoroñey amy lioy ty rambo-pità’e vaho ha­mitse aze im-pito añatrefa’Iehovà aolo’ i lamba fañefetsey. ");
INSERT INTO tdx_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Le hatente’e amo tsifa’ i kitreliio amy kibohom-pamantañañey añatrefa’Iehovà ty ila’ i lioy vaho hadoa’e ampoto’ i kitrelim-pisoroñañe an-dalambem-kibohom-pamantañañey ty sisa’ i lioy. ");
INSERT INTO tdx_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Hafaha’e iaby ty safo’e naho hengae’e an-katoeñe amy kitreliy; ");
INSERT INTO tdx_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","le hanoe’e hambañe amy nanoe’e i bania soron-kakeoiy i baniay, izay ty hanoe’e ty bania toy. Izay ty hijebaña’ i mpisoroñey vaho ho votsotse amy hakeoy iereo. ");
INSERT INTO tdx_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Hendese’e alafe’ i tobey i baniay vaho ho forototoe’e manahake ty nañoroa’e i bania valo­ha’ey, soron-kakeo’ i valobohòkey izay. ");
INSERT INTO tdx_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Ie manao hakeo ty mpifehe’ ondaty, vaho mandilatse tsy satrie’e aman-dra’ inoñ’ inoñe linili’Iehovà Andria­nañahare’e tsy hanoeñe naho voa-tahiñe, ");
INSERT INTO tdx_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","ie ampandrendreheñe i hakeo nililare’ey, le hendese’e ho enga ty vik’oselahy tsy aman-kandra. ");
INSERT INTO tdx_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Le hanampeza’e fitàñe i ose-lahiy vaho ho lentae’e amy toem-pandentàn-tsoroñey am’ Iehovày, soron-kakeo izay. ");
INSERT INTO tdx_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Handrambesa’ i mpisoroñey an-drambom-pità’e ty lio’ i soron-kakeoy naho hatente’e amo tsifa’ i kitrelim-pisoroñañeio vaho hadoa’e am-poto’ i kitrelim-pisoroñañey ty lio’e sisa. ");
INSERT INTO tdx_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Hengae’e an-katoeñe amy kitreliy ze hene safo’e manahake ty safo’ i engam-pañanintsiñey; le hijebaña’ i mpisoroñey ty amy tahi’ey vaho hapoke i tahi’ey. ");
INSERT INTO tdx_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Aa naho mandilatse tsy satrie’e ty ndaty amy taney, ndra inoñ’ inoñe linili’Iehovà tsy hanoeñeo vaho voa hakeo, ");
INSERT INTO tdx_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","aa naho fohi’e i hakeo nanoe’ey, le hinday ose ho enga’e, ty vave’e tsy aman-kandra ty amy tahiñe nanoe’ey. ");
INSERT INTO tdx_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Hampitongoà’e fitàñe ty loha’ i engan-kakeoy vaho ho lentae’e amy toem-pisoroñañey i engan-kakeoy. ");
INSERT INTO tdx_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Handrambesa’ i mpisoroñey an-drambom-pità’e ty lio’e naho hatente’e amo tsifa’ i kitrelim-pisoroñañeio vaho hadoa’e am-poto’ i kitreliy ty sisa’ i lio’ey. ");
INSERT INTO tdx_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Hafaha’e iaby ty safo’e, hambañe amy fañafahañe i safon’ engam-pañanintsiñey, vaho hengae’ i mpisoroñey an-katoeñe amy kitreliy ho hàñim-pañanintsiñe am’ Iehovà. Izay ty hijebaña’ i mpisoroñey aze hañahà’e i tahi’ey. ");
INSERT INTO tdx_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Aa naho vik’ añondry ty hendese’e ho engan-kakeo, le ho vàve’e tsy aman-kandra ty hendese’e. ");
INSERT INTO tdx_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Hanampeza’e fitàñe ty loha’ i engan-kakeoy, vaho ho lentae’e ho soron-kakeo amy toem-pandentà’ iareo o isoroñañeoy. ");
INSERT INTO tdx_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Handrambesa’ i mpisoroñey an-drambom-pità’e ty lio’ i engan-kakeoy le hatente’e amo tsifa’ i kitrelim-pisoroñañeio, vaho hadoa’e am-poto’ i kitreliy ty sisa’ i lio’ey. ");
INSERT INTO tdx_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Hafaha’e iaby ty safo’e, hambañe ami’ty nañafahañe ty safo’ i vik’ añondry amy engam-pañanintsiñeiy; le hengae’ i mpisoroñey amy kitreliy amo hisoroñañe am’ Iehovào, izay ty hijebaña’ i mpisoroñey aze ty amy hakeo nanoe’ey vaho ho hahàñe i tahi’ey. ");
INSERT INTO tdx_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Aa naho eo ty manao hakeo amy te jinanji’e ty koim-pitaroñe, ie nivalolombeloñe ke te nahaoniñe he nahafohiñe, fe tsy nabora’e, le ho vavè’e i tahiñey. ");
INSERT INTO tdx_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","He eo ty mi­tsapa raha faly, ke te fatem-biby faly, he faten’ añombe tsy malio, ke fatem-biby faly mifamorohotse, ie nietak’ ama’e, vaho maleotse re, aman-tahiñe. ");
INSERT INTO tdx_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Ke tsapae’e ty haleora’ ondaty, ndra ino ty tsy falio’e mahaleotse aze, naho tsy fohi’e, fe amy andrendreha’e aze ro voa hakeo. ");
INSERT INTO tdx_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","He eo ty mifanta tsy nisatrie’e, mivolañe tsi-nahi’e an-tsoñi’e ke hanao raty he hanao soa, ze halosorañe mete hifantà’ ondatio, fe mietak’ama’e, le ie maharen­dreke ro voa hakeo ami’ty raik’ ama’e. ");
INSERT INTO tdx_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Aa ie voa hakeo amy raik’ amy rezay le hiantofa’e i nandilara’ey. ");
INSERT INTO tdx_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Hendese’e mb’ am’ Iehovà mb’eo ty engan-kakeo’e ty amy tahiñe nanoe’ey, ty vave’e boak’ amy mpirai-liay, ke vik’ añondry ke ose, ho engan-dilatse, vaho hijebaña’ i mpisoroñey ty amy hakeo’ey. ");
INSERT INTO tdx_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Aa naho tsy lefe’e ty minday vik’añondry, le hengae’e am’ Iehovà ho engan-kakeo’e ty amy lilatse nanoe’ey, ty deho roe, he ty voromahilala tora’e roe; ty raike ho engan-kakeo, le ty raike ho soroñe. ");
INSERT INTO tdx_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Hasese’e mb’ amy mpisoroñey mb’ eo, le hengae’e heike i engan-kakeoy; ho lentae’e am-bozo’e fa tsy salàhañe. ");
INSERT INTO tdx_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Hafitse’e añ’ila’ i kitreliy ty ila’ i lio’ i engan-kakeoiy vaho hampiorihe’e am-poto’ i kitreliy ty ila’e. Soron-kakeo izay. ");
INSERT INTO tdx_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hengae’e ho soroñe ka i faharoey amy fañè’ey. Aa le hijebañ’ aze i mpisoroñey ty amy hakeo nanoe’ey vaho ho hahañ’ ama’e. ");
INSERT INTO tdx_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Aa naho tsy lefe’e ty deho roe ndra ana-boromahilala roe, le hengae’e ty amy hakeo nanoe’ey ty mona fahafolo’ ty efà ho engan-kakeo. Tsy hasia’e menake ndra emboke fa engan-tahiñe. ");
INSERT INTO tdx_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Hen­dese’e mb’amy mpisoroñey mb’eo i bana­banay, le handrambesa’ i mpisoroñey ty mahàtsam-pità’e ho tiahy vaho hengae’e an-katoeñe amy kitreliy, ambone’ o hisoroñañe am’ Iehovào; soron-kakeo izay. ");
INSERT INTO tdx_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Inay ty hijebaña’ i mpisoroñey aze ty amy tahiñe nanoe’ey amy rezay, vaho hahàñe ama’e. A’ i mpisoroñey ty sisa’e manahake i enga-mahakamay. ");
INSERT INTO tdx_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Naho mandilatse t’indaty, manao hakeo tsy nisatrie’e amo raha miava’ Iehovào, le ho banabanae’e am’ Iehovà ho engan-kakeo’e ty añondrilahy tsy aman-kandra boak’ amy mpirai-liay mindre ami’ty anjoanjo’o an-tsekele volafoty amy sekele’ i toe-miavakeiy ho engan-dilatse. ");
INSERT INTO tdx_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Havaha’e i nijoia’e amy raha niavakeiy, naho ho tovoña’e am-paha-lime’e vaho hatolo’e amy mpisoroñey. Aa le hijebaña’ i mpisoroñey re amy añondri­lahin-engan-dilatsey, le ho hahañe ama’e. ");
INSERT INTO tdx_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Naho eo ty manao hakeo aman-dra inoñ’ inoñ’ amo nandrarà’ ­Iehovà tsy hanoeñeo, ndra te tsy nifohi’e le voa tahiñe vaho ho vavè’e i hakeo’ey. ");
INSERT INTO tdx_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Hendese’e mb’amy mpisoroñey mb’eo ty añondrilahy tsy aman-kandra boak’ amy mpirai-liay naho ty anjoanjoe’o ho engan-kakeo, le hijebañ‘ aze ty amy lilatse tsy ni-satrie’e ndra tsy nifohi’ey, i mpisoroñey vaho ho hahañe ama’e. ");
INSERT INTO tdx_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Engan-kakeo izay, ie nandilatse am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","Aa naho eo ty mandilatse am’ Iehovà amy te nifañahie’e ty mpiama’e ami’te nahaja, ke nampitsoaheñe, he nikizoeñe; ke nidramoteñe i mpiama’ey, ");
INSERT INTO tdx_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","hera nirendreke ty nimotso fe mamañahy ty ama’e, naho nandañitse aman-titike, hanaña’e hakeo aman-dra’ inoñ’ inoñe mete hanoe’ ondaty amy rezay, ");
INSERT INTO tdx_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","le ie nandilatse naho voa-zaka, le havaha’e i nikamere’ey, ndra i nidramote’ey, ndra i nahaja’ey, ndra i nimotso nioni’ey ");
INSERT INTO tdx_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ndra inoñ’ ino nifantà’e vìlañe. Le havaha’e mira naho hitompea’e ty faha-lime’e, vaho hatolo’e amy tompo’ey amy andro banabanae’e i engan-dila’ey. ");
INSERT INTO tdx_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Hendese’e amy Iehovà ty engan-kakeo’e, ty añondrilahy tsy aman-kandra boak’ am-pirai-lia, naho ty hanjoanjoe’o ho engan-dilatse, mb’amy mpisoroñey. ");
INSERT INTO tdx_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Le hañefetse aze añatrefa’ Iehovà i mpisoroñey ty amy tahiñe nanoe’e naha-voa-zaka azey, vaho ho hahañe. ");
INSERT INTO tdx_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Lilio t’i Aharone naho o ana’eo ami’ty hoe: Zao ty fepè’ o fisoroñañeo: hapok’ amo hatae amy kitreliio i engaeñe harivay hialeñe ampara’ te porea’ ty maraindray vaho hirehetse nainai’e i afo ambone’ i kitreliiy. ");
INSERT INTO tdx_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Ie fa niforototoeñe an’ afo amy kitreliiy i soroñey, le haombe’ i mpisoroñey i saro’e leniy, ie fa nisikina’e i kiloti’e mana­roñe i sandri’eiy, le ho rambese’e ty laveno’e vaho hapo’e añ’ ila’ i kitreliy. ");
INSERT INTO tdx_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Hafaha’e hey o saro’eo, hisi­kiñe ty ila’e, vaho hendese’e alafe’ i tobey an-toetse malio añe i lavenokey. ");
INSERT INTO tdx_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Izay ty hampi­tolom-pirehetse ty afo amy kitreliy, tsy hikipeke. Hanoron-katae ama’e boak’ andro i mpisoroñey, halaha’e ama’e ze hisoroñañe vaho hengae’e an-katoeñe ama’e ty safo’ o engam-pañanintsiñeo. ");
INSERT INTO tdx_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Tanan-kirehetse nainai’e amy kitreliy ty afo, vaho tsy hakipeke. ");
INSERT INTO tdx_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Zao ty fetse’ o enga-mahakamao: ho banabanae’ o ana’ i Aharoneo añatrefa’ Iehovà aolo’ i kitreliy. ");
INSERT INTO tdx_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Handrambesa’e ty mona’ i enga-mahakama mahàtsa-pitañey miharo amy mena’ey naho ze hene embok’ amy enga-mahakamay, le hengae’e an-katoeñe amy kitreliy ho tiahy, ho hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Ho kamae’ i Aharone naho o ana’eo ty tsi-rì’e; ho kamaeñe tsy aman-dalivay an-toe-miavake ao; an-kiririsan-kibohom-pamantañañe eo ty hikama’ iareo aze. ");
INSERT INTO tdx_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Tsy hatoñak’ aman-da­livay re. Fa nandivako am’ iareo boak’ amo nisoroñañ’ amakoo; ie miava-do’e, manahake i engan-kakeoy naho i engan-dilatsey. ");
INSERT INTO tdx_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ie ho fikama’ ze hene ana-dahi’ i Aharone, ho fañè nainai’e amo tariratse mifandimbeo, amo fisoroñañe am’ Iehovào; fonga hiavake ze mitsapa aze. ");
INSERT INTO tdx_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Zao ty ho enga’ i Aharone naho o ana’eo, ty hengae’e am’ Iehovà amy andro fañorizañe azey: mona fahafolo’ ty efà ho enga-mahakama nainai’e donia, ty vaki’e maraindraiñe vaho ty vaki’e hariva. ");
INSERT INTO tdx_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Hanoeñe ami’ty kapeke miharo menake ie fa nigoñahe’ ty menake, le hendese’o ao, ho banabanae’o am-pìla’e natoñake ho enga-mahakama, hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","I mpisoroñe norizañe han­dimbe aze boak’ amo ana’eoy ty hañenga i rahay; fañè nainai’e izay, le hene hengaeñe an-katoeñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Fonga ho forototoeñe ze enga-mahakama’ o mpisoroñeo, fa tsy ho kamaeñe. ");
INSERT INTO tdx_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Saontsio amy Aharone naho o ana’eo, ty hoe: Zao ty fetse’ i engan-kakeoy: amy fandentañe o hisoroñañeoy ty handentañe o engan-kakeoo añatrefa’ Iehovà; ie miava-do’e. ");
INSERT INTO tdx_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ty mpisoroñe misoroñe aze ty amo hakeoo ty hikama aze. An-toe-miavake ty fikamà’e aze, an-kiririsan-kibohom-pamantañañe ao. ");
INSERT INTO tdx_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Hiavake ze mitsapa ty nofo’e. Naho mipitsik’ an-tsaroñe ty lio’e le ho sasà’o amy toe-miavakey i nipitsiha’ey. ");
INSERT INTO tdx_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Ho foieñe ka ze valàñe-tane nahandroañ’ aze; fa naho valàñe torisìke ty nahandroañ’ aze le ho kotriñeñe vaho kintsa­ñen-drano. ");
INSERT INTO tdx_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Songa mete mikama ama’e ze lahilahy amo mpisoroñeo. Miavake izay. ");
INSERT INTO tdx_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Fe tsy azo kamaeñe ze soron-kakeo nangalan-dio, nendeseñe amy kibohom-pamantañañey hanoem-pijebañañe amy toe-miavakey, ie tsy mete tsy forototoeñe añ’afo. ");
INSERT INTO tdx_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Intoy ty fetse o engan-dilatseo, ie miava-do’e; ");
INSERT INTO tdx_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","amy fandentañe o hisoroñañeoy ty fandentañe ty engan-dilatse; le hadasi’e añariari’ i kitreliy ty lio. ");
INSERT INTO tdx_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Ty hengae’e, le ty safo’e iaby: i hofa’e vondrakey naho ze safo’e mañohoñe o ova’eo, ");
INSERT INTO tdx_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","naho ty voa roe mitraok’ amo safo’e an-demeo, vaho hafaha’e rekets’ i voa rey i kambinatey; ");
INSERT INTO tdx_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","le hengae’ i mpisoroñey an-katoeñe amy kitreliy, hisoroñañe am’ Iehovà, soron-dilatse izay. ");
INSERT INTO tdx_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ho fikamà’ ze hene lahilahy amo mpisoroñeo; ho kamaeñe amy toe-miavakey ao; ie miava-do’e. ");
INSERT INTO tdx_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Tsy mifañova amy engan-kakeoy ty engan-dilatse; fetse raike ty a’ i roroey; a i mpisoroñe nanao fijebañañe ama’ey izay. ");
INSERT INTO tdx_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Ty mpisoroñe mañenga ty fisoroña’ ondaty, le a i mpisoroñey ty holi’ i nisoroñañey. ");
INSERT INTO tdx_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Le ze hene enga-mahakama atoñak’ an-toñak’ ao naho ze hene endazeñe am-balàñe ndra an-kapeke, le a i mpisoroñe mañenga azey. ");
INSERT INTO tdx_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Ze enga-mahakama ila’e, ke linaro menake ke maike, le ho zaraeñe mira amo ana’ i Aharoneo. ");
INSERT INTO tdx_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Intoy ty fetsem-pisoroñañe o engam-pañanintsiñe banabanaeñe am’ Iehovào: ");
INSERT INTO tdx_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","naho engae’e ho fañandriañañe, le hatrao’e amy engam-pañandriañañey ty mofo po-dalivay linaro menake naho mofo pisake po-dalivay nihosorañe menake, ndra mofo ami’ty mona nigoñahe’ ty menake. ");
INSERT INTO tdx_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Le vonga-mofo aman-dalivay ty ho banabanae’e miharo amy engam-pañanintsiñe ho fañandriañañey. ");
INSERT INTO tdx_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Boak’ amy ze hengae’e iaby sindre andivà’e raike ho banabanae’e am’ Iehovà. A i mpisoroñe nametsake ty lio’ i engam-pañanintsiñey amy kitreliiy izay. ");
INSERT INTO tdx_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Ho kamaeñe amy andro añengañ’ azey ty hena’ i soron-kanintsiñe ho fañandriañañey; tsy ho sisàñe ami’ty loak’ andro. ");
INSERT INTO tdx_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Fe naho engam-panta he engan-tsatrin’ arofo i soroñey le ho kamaeñe amy andro nisoroñañe azey, mbore mete kamaeñe ami’ ty loak’ andro ze nisisa; ");
INSERT INTO tdx_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","fe horoañe añ’afo ami’ty andro fahatelo ze tsy ri’e amy hena’ i soroñey. ");
INSERT INTO tdx_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Aa naho eo ty hena nisoroñañe amy engam-pañanintsiñey ze kamaeñe amy andro fahateloy, tsy ho no’e, vaho tsy ho volilieñe ama’e; toe tiva izay; le ho vavè’ ze ondaty mikama ama’ey i tahi’ey. ");
INSERT INTO tdx_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Tsy ho kamaeñe ze nofotse nioza ami’ty raha tsy malio, fa ho forototoeñe añ’afo. Fa naho o nofotseo, ho kamae’ ze malio. ");
INSERT INTO tdx_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Fe haitoeñe am’ondati’eo t’indaty mikama amy hena engam-pañanintsi’ Iehovày ie ama’e ty tsy falio’e. ");
INSERT INTO tdx_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Ze ondaty mi­tsapa raha maloto: ke haleora’ ondaty, ke biby maloto, ke inoñ’ inoñe amo raha mampangorìñeo, naho ikama’e ty hena’ i engam-pañanintsi’ ­Iehovày, le haitoañe am’ondati’eo indatiy. ");
INSERT INTO tdx_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Le hoe ty nitsarae’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Misaontsia amo ana’ Israeleo ty hoe: Tsy ho kamae’ areo ty safon’ añombe ndra añondry ndra ose. ");
INSERT INTO tdx_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Le ty amo safom-biby mate bo­bokeo ndra t’ie nirimitem-biby le azo anoan-draha, fe tsy ho kamae’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Ze ondaty mikama ty safom-biby, amo fañenga’ ondaty ho soroñañe am’ Iehovà ro haitoañe am’ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Tsy ho kamae’ areo ty liom-boroñe ndra biby, ndra aia’aia amo fitobea’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Ze ondaty mihinan-dio, le haitoañe am’ondati’eo indatiy. ");
INSERT INTO tdx_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Hoe ty nitsara’ Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Misaontsia amo ana’ Israeleo ty hoe: Ty minday ty isoroña’e ho engam-pañanintsiñe am’ Iehovà, le amy engam-pañanintsi’ey ty ho banabanae’e am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","O fità’eo ty hanese ze hisoroña’e am’ Iehovà. Hasese’e ty safo’e rekets’ i tratra’ey le hahelahela’e i tratra’ey ho engan-kelahela añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Le hisoroña’ i mpisoroñey ho hatoeñe amy kitreliy ty safo’e fa a i Aharone naho o ana’eo i tratra’ey. ");
INSERT INTO tdx_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Le hanoe’o engan-kelahela amy mpisoroñey ty tso’e havàna boak’amo engam-pañanintsiñe fisoroña’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Anjara ty ana’ i Aharone mañenga ty lio’ i engam-pañanintsiñey naho o safo’ey i tso’e. ");
INSERT INTO tdx_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Fa rinambeko amo engam-pañanintsi’ o ana’ Israeleoo ty tratran-kelahela naho ty tsom-pañè vaho natoloko amy Aharone mpisoroñe naho amo ana’eo ho anjara’ iareo boak’ amo ana’ Israeleo nainai’e donia. ");
INSERT INTO tdx_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Amy andro naneseañe iareo hitoroñe Iehovà ho mpisoroñey, ty nañambahañe i anjara zay ho a i Aharone naho ho a o ana’eo amo fisoroñañe am’ Iehovào; ");
INSERT INTO tdx_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","inay i nandilia’ Iehovà te hatolo’ o ana’Israeleo am’ iareo amy andro naño­rizañe iareoiy ho fañè tsy modo amo tarira’ iareo mifandimbe nainai’eo. ");
INSERT INTO tdx_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Izay ty fetse’ o soroñeo, naho o enga-mahakamao, o engan-kakeoo, o engan-dilatseo, o engam-pañorizañeo, vaho o engam-pañanintsiñe ");
INSERT INTO tdx_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","nandilia’ Iehovà amy Mosè am-bohi-Sinay amy andro linili’e o ana’Israeleo ty hanese enga am’ ­Iehovà am-patrambey Sinaiio. ");
INSERT INTO tdx_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Rambeso t’i Aharone naho o ana’e ama’eo, o saro’eo, i mena-pañorizañey, i banian-engan-kakeoy, i añondrilahy roe rey vaho i hàroñe ama’ mofo po-dalivaiy, ");
INSERT INTO tdx_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","le atontoño an-dalam-bein-kibohom-pamantañañe eo i fivoribeiy. ");
INSERT INTO tdx_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Aa le nanoe’ i Mosè i nandilia’ Iehovày, naho nifanontoñe an-dalan-kibohom-pamantañañe eo i fivori-beiy; ");
INSERT INTO tdx_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","le hoe t’i Mosè amy fivori-beiy, Inao ty nandilia’ Iehovà hanoeñe. ");
INSERT INTO tdx_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Nendese’ i Mosè mb’eo t’i Aharone naho o ana’eo vaho nampandroa’e an-drano. ");
INSERT INTO tdx_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Naombe’e ama’e i sikiñey, naho nidiaña’e i sadiay, nanikina’e i saroñey, naombe’e i ki­tam­bey, le nadia’e i fièn-kitambe soa-vahotsey vaho nifeheza’e. ");
INSERT INTO tdx_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Le napeta’e ama’e i takon’ arañañey vaho nazili’e amy takon’ arañañey ty Orimae naho i Tomimae; ");
INSERT INTO tdx_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","naho nasabaka’e añ’ ambone’e i sabakay vaho napeta’e amy sabakay, aolo’e eo, i bogady volamenay; i ravan-daharañe miavake linili’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Rinambe’ i Mosè amy zao i mena-pa­ño­rizañey le noriza’e i kivohoy naho ze he’e ama’e ao vaho nefera’e. ");
INSERT INTO tdx_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Nafitse’e amy kitreliy im-pito ty ila’e, le noriza’e i kitreliy naho ze hene harao’e vaho i fanasàñey rekets’ i foto’ey, hañefera’e. ");
INSERT INTO tdx_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Nañiliña’e menake ty añambone’ i Aharone le noriza’e hampiavahañ’ aze. ");
INSERT INTO tdx_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Nendese’ i Mosè mb’eo ka o ana’ i Aharoneo vaho naombe’e o sikiñeo le nadia’e sadia, le nifehe’e o sabaka’ iareoo amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Nitantalie’e mb’eo i banian-engan-kakeoy, le nanampeza’ i Aharone naho o ana’eo fitàñe ty loha’ i banian-engan-kakeoy, ");
INSERT INTO tdx_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ie linenta, le nandrambesa’ i Mosè i lioy naho natente’e amy tsifa’ i kitreliy rey añ’ariary aze an-drambom-pità’e vaho nefera’e i kitreliy; nadoa’e am-poto’ i kitreliy i lioy, le nefera’e, hanoe’e fijebańañe. ");
INSERT INTO tdx_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Le fonga rinambe’e ty safotsena amo ova’eo, i kambinatey, ty voa roe reke-tsafo’e naho nengae’ i Mosè an-katoeñe amy kitreliy, ");
INSERT INTO tdx_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","naho noroa’e alafe’ i tobey i baniay, ty holi’e, ty nofo’e, vaho ty tai’e; ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Nampitotoheñe amy zao i añondri­lahy hisoroñañey vaho nanampeza’ i Aharone naho o ana’eo fitàñe ty loha’ i añondrilahiy, ");
INSERT INTO tdx_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","le linenta, naho nafetsa’ i Mosè amy kitreliy añ’ariariy aze i lioy; ");
INSERT INTO tdx_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","le nifatepatere’e i añondrilahiy, naho nengae’ i Mosè an-katoeñe ty loha’e, naho o fatets’enao, vaho o safo’eo. ");
INSERT INTO tdx_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Le nisasae’e aman-drano o ova’eo naho o tombo’eo, vaho nengae’ i Mosè an-katoeñe ambone’ i kitreliy i añondrilahy iabiy, fa soroñe, hàñim-pañanintsiñe, nisoroñañe am’ Iehovà, amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Nasese’e ka i añondrilahy faharoey, i añondrilahim-panokanañey, le nampitongoà’ i Aharone naho o ana’eo fitàñe ty loha’ i añondrilahiy. ");
INSERT INTO tdx_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Le linenta naho nandrambesa’ i Mosè ty lio’e naho natente’e an-dengon-dravembia’ havana’ i Aharone naho an-tondrobeim-pità’e havana vaho an-tondrobeim-pandia’e havana. ");
INSERT INTO tdx_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Nampomba’e mb’eo o ana’ i Aharoneo le natente’ i Mosè an-dengon-dravembia-havana’ iareo ty ila’ i lioy, naho ami’ty tondrobeim-pitàn-kavana’ iareo, naho an-tondrobeim-pandia havana’ iareo; vaho nafetsa’ i Mosè añariariy i kitreliy i lioy. ");
INSERT INTO tdx_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Le rinambe’e i safots­enay naho i hofake vondrakey, naho ze safotsena amo ovao naho i kambinatey naho i voa roe rey reke-tsafo’e vaho ty tso’e havana. ");
INSERT INTO tdx_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Le nandrambe mofo po-dalivay raik’ amy haroñe po-dalivay aolo’ Iehovày, rinambe’e ty mofo nañiliñañe menake naho ty mofo pisake, vaho napo’e amy safo’ey naho amy tso’e havanay. ");
INSERT INTO tdx_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Napo’e am-pità’ i Aharone naho am-pità’ o ana’eo i he’e rezay, vaho nahelahela ho engan-kelahela am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Le rinam­be’ i Mosè am-pità’ iareo irezay vaho nengae’e an-katoeñe amy kitreliy mitraok’ amy soroñey, ho sorom-panokanañe mañonjoñe hàñim-pañanintsiñe, nengaeñe añ’afo am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Le rinambe’ i Mosè i tratra’ey vaho nahelahela’e ho engan-kelahela am’ Iehovà. Anjara’ i Mosè amy añondrilahi-panokanañey izay ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Nandrambesa’ i Mosè i mena-paño­rizañey naho ty lio amy kitreliy le nafitse’e amy Aharone naho amo saro’eo naho amo ana’eo naho amo saro’ iareoo. Le noriza’e t’i Aharone rekets’ o saro’eo naho o ana’eo rekets’ o saro’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Le hoe t’i Mosè amy Aharone naho amo ana’eo, Ahandrò an-dalan-kibohom-pamantañañe eo i henay vaho ikamao ey naho ty mofo amy harom-pañengam-panokanañey, ami’ty nandiliako ty hoe, Ho kamae’ i Aharone naho o ana’eo; ");
INSERT INTO tdx_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","le ho forototoe’ areo an’ afo ao ze tsi-ri’ i henay naho i mofoy. ");
INSERT INTO tdx_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Le tsy hiakatse i lalan-kibohom-pamantañañey nahareo naho tsy modo ty fito andro, am-para’ te heneke o androm-pañorizañe anahareoo. Fito andro ty añoriza’e anahareo. ");
INSERT INTO tdx_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","I nanoeñe anindroaniy, ty nandilia’ Iehovà hanoeñe; hijebañañe anahareo. ");
INSERT INTO tdx_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Aa le hidoñe an-dalan-kitrelin-kibohom-pamantañañe eo handro an-kaleñe fito andro nahareo, hitañe ty namantoha’ Iehovà, tsy hivetrake; fa izay ty nandiliañe ahy. ");
INSERT INTO tdx_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Le nanoe’ i Aharone naho o ana’eo ze hene nandilia’ ­Iehovà am-pità’ i Mosèo. ");
INSERT INTO tdx_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Ie tsatoke ty andro fahavalo, le kinoi’ i Mosè t’i Aharone naho o ana’eo vaho o androanavi’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Le hoe re amy Aharone, Angalao bania raike ho engan-kakeo naho ty añondrilahy hisoroña­ñe, tsy aman-kandra, le aseseo añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Le misaontsia ty hoe amo ana’ Israeleo, Andrambeso vik’ose­ ho engan-kakeo naho ty dronga naho ty vik’ añondry tsy aman-kandra, songa rai-taoñe, hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","naho ty bania vaho ty añondrilahy ho engam-pañanintsiñe, hengaeñe añatrefa’ Iehovà; naho ty enga-mahakama linaro menake. Amy te ho isake anito t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Aa le nandese’ iereo aolo’ i kibohom-pamantañañey i nandilia’ i Mosè rezay. Le nitotoke mb’eo i valobohòkey nijohañe añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Le hoe t’i Mosè, Zao ty nandilia’ Iehovà hanoe’ areo, hitotsaha’ ty volonahe’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Le hoe ty Mosè amy Aharone, Harineo i kitreliy naho soroño i engan-kakeo’oy naho i hisoroña’oy, hijebañañe azo naho ondatio. Le soroño i nengae’ ondatio hijebañañe iareo, amy nandilia’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aa le niharinea’ i Aharone i kitreliy vaho linenta’e i drongan’ engan-kakeo ho azey. ");
INSERT INTO tdx_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Le nandesa’ o ana’ i Aharoneo ama’e ty lio. Nalo’e amy lioy ty rambo-pità’e, le natente’e amo tsifa’ i kitreliio vaho nadoa’e am-poto’ i kitreliy i lioy. ");
INSERT INTO tdx_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Nengae’e an-katoeñe amy kitreliy i safo­tsenay naho o voa’eo vaho i kambinate’ i engan-kakeoiy, amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Finorototo an’ afo alafe’ i tobey i henay naho i holitsey. ");
INSERT INTO tdx_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Linenta’e amy zao i hisoroñañey; le nasese’ o ana’ i Aharoneo ama’e i lioy, vaho nadasi’e añariary i kitreliy. ");
INSERT INTO tdx_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Le nasese’ iareo ama’e i hisoroñañey: o fatets-enao naho i lohay vaho nengae’e an-katoeñe amy kitreliy. ");
INSERT INTO tdx_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Sinasa’e o ovao naho o tombokeo vaho nengae’e an-katoeñe ambone’ i soroñe amy kitreliiy. ");
INSERT INTO tdx_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Le nasese mb’eo ty nengae’ ondatio. Rinambe’e i osen’ engan-kakeo’ ondatioy le linenta’e vaho nanoe’e soron-kakeo manahake i valoha’ey. ");
INSERT INTO tdx_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Nasese ka i engan-koroañey vaho nisoroña’e ty amy fepè’ey. ");
INSERT INTO tdx_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Nendese’e i enga-mahakamay le nandrambesa’e ty nahàtsa-pità’e vaho finorototo’e amy kitreliy, tovo’ i nisoroñañe animaraiñey. ");
INSERT INTO tdx_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Le linenta’e i baniay naho i añondrilahiy, engam-pañanintsiñe ho a ondatio. Nasese’ o ana’ i Aharoneo ama’e ty lio’e vaho nafetsa’e añariariy i kitreliy i lioy; ");
INSERT INTO tdx_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","le ty safo’ i baniay naho i añondrilahiy: i hofa’ey, ty safo’e mañohoñe o aova’eo, ty voa’e roe rekets’ i kambin’atey, ");
INSERT INTO tdx_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","napo’ iareo an-tratra’e eo o safo’eo le nengae’e an-katoeñe amy kitreliy ty safo’e; ");
INSERT INTO tdx_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","naho nahelahela’ i Aharone o tratra’eo naho ty tso’e havana ho engan-kelahela añatrefa’ Iehovà amy nandilia’ i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Nañonjom-pitàñe am’ondatio amy zao t’i Aharone, nitata, vaho nizo­tso amy nanoe’e i engan-kakeoy naho i soroñey vaho i engam-pañanintsiñey. ");
INSERT INTO tdx_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Nizilik’ amy kibohom-pamantañañey t’i Mosè naho i Aharone, le niavotse vaho nitata ondatio le nisodeha am’ ondaty iabio ty enge’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Niforoake boak’ añatrefa’ Iehovà ty afo namorototo i soroñey naho ty safo’e an-kitrely eo, le fonga nahaoniñe izay ondatio naho nikoiake vaho nibabok’ an-daharañe. ");
INSERT INTO tdx_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Songa nandrambe ty sadron’ afo’e t’i Nadabe naho i Abiho, ana’ i Aharone, naho nasia’ iareo afo, naho nampipohañ’ emboke vaho ninday afo tsie añatrefa’ Iehovà, ie tsy nandilia’e. ");
INSERT INTO tdx_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Aa le niforoake boak’ am’ Iehovà ty afo namorototo iareo, vaho nikoromak’ añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Le hoe t’i Mosè amy Aharone, Izay ty talin-tsara’ Iehovà, ie nanao ty hoe: Hampiavahe’ o mpañarine ahikoo iraho, vaho ho rengèñe añatrefa’ ondaty iabio. Fe nianjiñe t’i Aharone. ");
INSERT INTO tdx_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Kinanji’ i Mosè t’i Misaele naho i Eltsafane, ana’ i Oziele, rahalahin-drae’ i Aharone, le natao’e ty hoe: Mb’ etoa, takono boak’ aolo’ i toetse miavakey mb’ alafen-tobe añe o longo’oo. ");
INSERT INTO tdx_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Aa le nimb’eo iereo nitakoñe aze aman-tsikiñe mb’ alafe’ i tobey mb’eo, amy nitsarae’ i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Le hoe t’i Mosè amy Aharone naho amy Elazare naho Itamare, ana’e, Ko añafahan-tsabaka ty añambone’ areo, naho ko mandria-tsaroñe tsy mone hihomake vaho hifetsak’ am’ondaty iabio ty haviñerañe. Fe o longo’ areoo, i anjomba’ Israele iabiy ty handala i famorototoañe niviañe’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Le ko mienga ty lalan-kibohom-pamantañañe tsy mone hihomake, amy te ama’ areo ty mena-pañoriza’ Iehovà. Le nanoe’ iareo ty nitsarae’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Le hoe ty nitsarae’ Iehovà amy Aharone, ");
INSERT INTO tdx_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Ko mikama divay ndra toake, ihe naho o ana’o miharo ama’oo, t’ie mizilik’ amy kibohom-pamantañañey ao, tsy mone hikoromake. Fañè nainaie amo tarira’ areo mifandimbeo izay, ");
INSERT INTO tdx_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","hampiavahañe ty masiñe ami’ty tsotra naho ty maleotse ami’ty malio, ");
INSERT INTO tdx_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","naho hañanarañe o ana’ Israeleo ze hene fañè nitsarae’ Iehovà am’ iereo am-pità’ i Mosè. ");
INSERT INTO tdx_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Le hoe t’i Mosè amy Aharone naho amy Elazare vaho Itamare, sehangan’ ana’e rey: Rambeso ty enga-mahakama nisisa amy nisoroñañe am’ Iehovày, vaho ikamao po-dalivay marine’ i kitreliy fa miava-do’e. ");
INSERT INTO tdx_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Ho kamae’ areo amy toe-miavakey amy t’ie anjara’o naho anjara’ o ana’oo boak’ amy soroñañe am’ Iehovày, amy nandiliañ’ ahikoy. ");
INSERT INTO tdx_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Ho kamae’o ami’ty malio ka ty tratra’ i engan-kelahelay naho ty tso’ i enga-kavoañey, ihe naho o ana-dahi’oo naho o anak-ampela’o miharo ama’oo, amy t’ie natolotse ho zo’o naho zo’ o keleia’oo boak’ amo engam-pañanintsiñe fisoroña’ o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Hasese’ iareo mindre amo safo’e hisoroñañeo ty tson’ engan-kavoañe naho ty tratra’ i engan-kelahelay, hahelahela ho engan-kelahela añatrefa’ Iehovà. Le ho azo naho o ana’ areo mindre ama’oo ho fañè tsy modo ami’ty nandilia’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Nitsoehe’ i Mosè amy zao i osen’ engan-kakeoy; inao finorototo! Niviñera’e t’i Elazare naho Itamare, ana’ i Aharone honka’e rey, ami’ty hoe: ");
INSERT INTO tdx_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Ino ty tsy nihinana’ areo i engan-kakeoy amy toe-miavakey ao? Miavake izay vaho natolon’ Añahare anaha­reo hivave ty hìla’ i màroy hijebañañe iareo añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Inao, tsy nasese amy toe-miavakey ty lio’e, aa le ho nihinana’ areo amy toe-miavakey ao, amy nandiliakoy. ");
INSERT INTO tdx_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Le hoe t’i Aharone amy Mosè: Ingo te binanabana’ iareo anindroany i engan-kakeo’ iareoy naho o fisoroña’ iareo añatrefa’ Iehovào; aa i hene nizo ahiko anianiy, naho nihinanako i engan-kakeoy anindroany ampiva­zohoa’ Iehovà, ho ni-nò’e hao? ");
INSERT INTO tdx_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Ie jinanji’ i Mosè izay le nisoa am-pihaino’e ao. ");
INSERT INTO tdx_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Hoe ty nitsara’ Iehovà amy Mosè naho amy Aharone: ");
INSERT INTO tdx_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Saontsio amo ana’ Israeleo ty hoe: Iretoañe o raha veloñe ho fikama’ areo amy ze hene bibi’ ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Ze vaki-hotro, ie misarake do’e o hotro’eo, naho mihota haneñe (amo bibio) le maha­kama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Fe tsy ho kamae’ areo o mpihota naho o vaki-hotro retoañe: o ramevao, amy te tsy vaki-hotro ndra t’ie mihota, aa le faly ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","O trandrakeo, amy te tsy vaki-hotro ndra t’ie mihota le faly ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","O bitroo, amy te tsy vaki-hotro ndra t’ie mihota, le faly ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","O lamboo, toe misarake o hotro’eo naho vaki-hotro f’ie tsy mihota, le faly ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Tsy ho kamae’ areo o nofo’eo le tsy ho tsapae’ areo o fate’eo, faly ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Iretoy ty ho fikama’ areo amy ze he’e an-drano ao. Ndra inoñ’ inoñe aman’ elatse naho sisy, he andrano he an-driake ke an-tsaka ao—le azo’ areo kamaeñe. ");
INSERT INTO tdx_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Fe ze raha iaby an-driake ndra an-tsaka ao tsy aman’ elatse ndra sisi’e amo fonga raha mifamorohotse an-dranoo naho amy ze hene raha veloñe an-drano, le tiva ama’ areo; ");
INSERT INTO tdx_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","veta ama’ areo irezay. Tsy ho kamae’ areo ty nofo’e, fa tiva ama’ areo ty fate’e. ");
INSERT INTO tdx_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Ze raha an-drano ao tsy aman’ elatse ndra sisy le tiva ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Intoy ty tiva ama’ areo amo voro­ñeo. O tsy ho kamaeñeo, o atao tivao: ty tratràke, ty bevorotse naho ty salale; ");
INSERT INTO tdx_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ty fañaoke, naho ze atao vantio; ");
INSERT INTO tdx_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","ze hene koàke naho o rahamba’eo; ");
INSERT INTO tdx_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ty voron-tsatra, ty langopake, ty vorom-potsy, naho ze hene karazan-kitikitike; ");
INSERT INTO tdx_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ty voron-dolo kede; ty voron-dolo mpañao-piañe naho ty voron-dolo mpikodrìtse; ");
INSERT INTO tdx_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ty vorondolo foty, ty voron-dolon-tane maike, ty hondria; ");
INSERT INTO tdx_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ty sama naho ze karaza-dangoro, ty kotrohake vaho ty kananavy. ");
INSERT INTO tdx_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Tiva ama’ areo ze hene bibi-kede aman’ elatse, misitse aman-tombo’e efatse. ");
INSERT INTO tdx_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Fe o bibi-kede aman’ elatse, mpisi­tsitse aman-tomboke efatseo le azo kama­eñe o amam-pange’e ambone’ o piko’eo naho mitsindrèko an-taneo. ");
INSERT INTO tdx_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Iretoañe o azo kamaeñe ama’eo: ty beitratra ty amo karaza’eo, ty andrombile ty amo karaza’eo, ty antsìñe ty amo karaza’eo, naho ty valala ty amo karaza’eo. ");
INSERT INTO tdx_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Fe tiva ama’ areo ze hene biby ila’e mifamorohotse naho mitiliñe, aman-tomboke efatse. ");
INSERT INTO tdx_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Inay o mahaleotse anahareo; ze mitsapa ty fate’e le maleotse pak’ amy harivay, ");
INSERT INTO tdx_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","le ze mañongake ty fate am’ irezay ro hanasa o siki’eo vaho haleotse pak’ amy harivay. ");
INSERT INTO tdx_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Ze hene biby vaky hotro naho tsy mizara, ndra o tsy mihotao, le faly ama’ areo, fonga maleotse ty mitsapa irezay. ");
INSERT INTO tdx_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Faly ama’ areo ze biby mandia an-delatomboke maleme amo mpandeha an-tomboke efatseo. Haleotse pak’ amy harivay ze mitsa­pa ty fate’ irezay. ");
INSERT INTO tdx_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Hanasa o siki’eo ze mandrambe ty fate’e vaho haleotse pak’ amy harivay; ie faly ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Intoy ka o raha faly amo biby milaly an-tane atoio: ty fanaloke, ty kotìka, ze karazan-droso, ");
INSERT INTO tdx_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ty tràtrake, ty jiri­fòñe, ty voae, ty roson’ añombelahy vaho ty tañe. ");
INSERT INTO tdx_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Songa faly ama’ areo i raha milaly zay. Maleotse pak’ amy harivay ze mitsapa ty fate’e. ");
INSERT INTO tdx_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Le fonga haleotse ze raha ipaoha’ ty mate amy rezay, ke hatae, ke lamba, ke holitse, he haroñe—ze raha manañ’ asa, le tsy mahay tsy ajorobo an-drano ao, naho haleotse pak’ amy harivay, vaho halio; ");
INSERT INTO tdx_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Ho foieñe ze valàñe tane ijoña’ ty raik’ am’ iereo; fonga haloto ze ama’e ao. ");
INSERT INTO tdx_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Haloto ze hene maha­kama mete ho nikamaeñe te ipaoha’ i rano’ey, vaho haloto ka ze rano ho ninomeñe boak’ amy fanakey. ");
INSERT INTO tdx_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Fonga maloto ze ipoha’ ty fate’e, ndra te toñake, ndra valàñe, le tsy mete tsy koromaheñe fa maleotse. Songa maloto ama’ areo irezay. ");
INSERT INTO tdx_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Ndra te izay, halio ty vovoñe ndra ty kadaha ivorian-drano, fe haloto ze mitsapa ty fate’e. ");
INSERT INTO tdx_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Aa naho mipok’ ami’ty tabiry hamboleñe ze ho tongiseñe, ty ila’ i fate’ey, malio i tabiriy. ");
INSERT INTO tdx_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Fa naho nañiliñan-drano i tabiriy vaho mipok’ ama’e ty ila’ i fatey, le maleotse ama’o. ");
INSERT INTO tdx_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Haleotse pak’amy harivay ka ze mitsapa ty fatem-biby fihinañe, mate boboke. ");
INSERT INTO tdx_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Tsy mete tsy manasa o lamba’eo ze mikama amy fatey vaho haleotse pak’ amy harivay; mbore hanasa ty lamba’e ze mañongake i fatey vaho haleotse pak’ amy harivay. ");
INSERT INTO tdx_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Tiva iaby ze biby mifamorohotse ambone’ ty tane toy—tsy ho kamaeñe. ");
INSERT INTO tdx_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ze milaly an-tro’e, ke misitsitse an-tombo’e efatse, he maro tomboke, amo biby mangetseke­tsek’ an-tane atoio, tsy ho kamae’ areo, fa tiva. ");
INSERT INTO tdx_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Ko mandeo-batañe amo biby mifamorohotseo nahareo le ko andotoa’areo vatañe vaho ko mileotse ama’e. ");
INSERT INTO tdx_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Izaho Iehovà Andrianañahare’ areo. Aa le, miefera vaho miavaha, amy te masin-dRaho. Ko mandeo-batañe amy ze mifamorohotse an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Izaho Iehovà nañavotse anahareo an-tane Mitsraime añe ho Andrianañahare’ areo. Aa le miavaha amy te masin-dRaho. ");
INSERT INTO tdx_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Izay o fetse amo biby ndra voroñe ndra ze raha veloñe mpan­deha amo ranoo ndra mifamorohotse ambone’ ty tane toio, ");
INSERT INTO tdx_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","hañavahañe ty maleotse ami’ty malio, naho hamìhañe o biby tsy kamaeñeo amo mete kamaeñeo. ");
INSERT INTO tdx_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Hoe ty nitsara’ Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Misaontsia amo ana’Israeleo, ty hoe: Ie miareñe ty ampela naho misamak’ ana-dahy, le haleotse re am-para’ ty andro faha-fito, manahake o androm-piambola’eo ty ho faleora’e. ");
INSERT INTO tdx_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Le ho tampaheñe ami’ty andro fahavalo ty ofo’e. ");
INSERT INTO tdx_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Hidoñe am-pitaià’e ao re hiefetse ami’ty lio’e telopolo andro telo amby, le tsy hitsapa raha miavake naho tsy hizilik’ amy toe-miavakey ampara’ te heneke o andro fitaià’eo. ");
INSERT INTO tdx_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Aa naho mone misamak’ ampela re le haleotse hereñandro roe manahake i fiambola’ey, le hiefe-batañe andro enempolo-eneñ’amby ty amy lio’ey. ");
INSERT INTO tdx_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Ie heneke ty androm-piefera’e, ke te lahilahy ke te anak’ampela, le hengae’e amy mpisoroñe an-dalan-kibohom-pamantañañey ty vik’ añondry, lahi’e taoñe raike, hisoroñañe, naho ana-boromahilala ndra deho ho engan-kakeo. ");
INSERT INTO tdx_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Le hengae’e añatrefa’ Iehovà, naho hijebañe aze, vaho halio re amy fiorihan-dio’ey. Izay ty fetse ami’ ty rakemba nisamake lahilahy ndra ampela. ");
INSERT INTO tdx_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Aa naho tsy lefe’e ty añondry le hindesa’e ana-boromahilala roe he deho roe; ty raike hisoroñañe vaho ty raike ho engan-kakeo; le hijebañe aze i mpisoroñey vaho halio re. ");
INSERT INTO tdx_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Hoe ty nitsara’ Iehovà amy Mosè naho i Aharone: ");
INSERT INTO tdx_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Ie mibotan-kolitse ke te olatse amy t’indaty, he pepo maviake, ie hoe angamae amy holi’ey, le ha­sese mb’amy Aharone mpisoroñe ndra mb’ami’ty raik’ amo ana’e mpisoroñeo mb’eo. ");
INSERT INTO tdx_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Ho biribirie’ i mpisoroñey ty handra ami’ty holi’ i sandri’eiy; aa naho foty ty maròy miakatse amy handray vaho oni’e laleke te amy holi’ i san­dri’ey i handray le angamae izay; ie savae’ i mpisoroñey le ho tseize’e te maleotse. ");
INSERT INTO tdx_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Aa naho foty i pepo maviak’ amy holin-tsandri’eoiy naho isake t’ie tsy laleke te amy holitsey naho tsy nikò-foty ty maroi’e, le hampiambahe’ i mpisoroñey fito andro indaty voa’ i handray. ");
INSERT INTO tdx_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Ho savae’ i mpisoroñey re amy andro fahafitoy, aa ie tsy niova am­paha­isaha’e aze i handray naho tsy nandakak’ amy holi’ey i handray, le havi’ i mpisoroñey fito andro in­draike. ");
INSERT INTO tdx_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Mbe ho savae’ i mpisoroñey indraike amy andro fahafitoy; aa naho toe nikepake i handray vaho tsy nandakak’ amy holi’ey i handray, le ho tseize’ i mpisoroñey t’ie malio. Heza’e avao izay le ho sasà’e o siki’eo vaho halio. ");
INSERT INTO tdx_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Aa naho mone nandakak’ amy holitsey i baey, ie fa nioni’ i mpisoroñey amy faña­liova’ey le hiheo mb’amy mpisoroñey mb’eo in­draike re. ");
INSERT INTO tdx_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Ie isa’ i mpisoroñey te toe nandakake i bae amy holi’eiy, le ho tseize’e t’ie maleotse; angamae izay. ");
INSERT INTO tdx_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Ie silofe’ ty handra t’indaty le ha­sese mb’amy mpisoroñey mb’eo, ");
INSERT INTO tdx_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","le hisava aze i mpisoroñey; aa naho isa’e te mibontam-poty i holi’ey naho nampifotie’e ty maròy ama’e, mbore ama’e ty nofotse veloñe miboak’ amy nienatsey, ");
INSERT INTO tdx_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","le fa lili’e i angamae an-koli-tsandri’e; ho tseize’ i mpisoroñey t’ie maleotse, fe tsy hagabeñe ao, toe faleora’e. ");
INSERT INTO tdx_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Aa ie mandakak’ amy holi­tsey i angamaey, naho mipàtsake boak’ añ’ambone pak’ am-pandia an-koli’ i aman-kandray ndra aia’aia isahe’ i mpisoroñey i angamaey, ");
INSERT INTO tdx_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","le ho savae’ i mpisoroñey hey, aa ie isake te nahatsitsike i sandri’ey i angamaey, le ho tseize’e te malio i aman-kandray; kanao nikò-foty iaby le malio. ");
INSERT INTO tdx_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Fe ndra mbia’mbia te miboak’ ama’e ty nofotse veloñe, le haleotse re. ");
INSERT INTO tdx_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Ho savae’ i mpisoroñey i nofo-beloñey vaho ho tseize’e t’ie maleotse; amy te maloto i nofo-beloñey. Angamae re. ");
INSERT INTO tdx_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Ie mivalike in­draike i nofo-beloñey, miova ho foty, le homb’ amy mpisoroñey mb’eo re. ");
INSERT INTO tdx_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Ho savae’ i mpisoroñey, ie toe nikò-foty i handray, le ho tseize’ i mpisoroñey te malio i aman-kandray. Malio re. ");
INSERT INTO tdx_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Ie teo ty nitovoañe an-koli’ i sandriñey, fe nimelañe ");
INSERT INTO tdx_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","naho mandimbe i baey ty fivontoañe foty ndra ty pepo maviake, mena minday foty, le haboak’ amy mpisoroñey; ");
INSERT INTO tdx_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","aa ie isa’ i mpisoroñey te laleke ta’ i holitsey izay, vaho fa foty o maroi’eo, le ho tseize’ i mpisoroñey te maleotse. Angamae ty nirofotse amy baey. ");
INSERT INTO tdx_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","F’ie misava aze i mpisoroñey naho isa’e te tsy ama’e ao i maròy fotiy naho tsy laleke te amy holi­tsey mbore nitsiteke, le hazoizoi’ i mpisoroñey fito andro. ");
INSERT INTO tdx_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Aa naho mandakak’ amy holitsey, le ho tseize’ i mpisoroñey t’ie maleotse. Angorosy izay. ");
INSERT INTO tdx_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Aa naho tambatse eo i pepo maviakey, tsy mandakake; le heza’ i baey avao Izay vaho ho tseize’ i mpisoroñey t’ie malio. ");
INSERT INTO tdx_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Naho amy holin-tsandriñe eo t‘ie mae hoe afo vaho miboak’ amy nimelañe amy nimae’eiy ty pepo maviake, foty minday mena, ndra foty; ");
INSERT INTO tdx_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","le ho savae’ i mpisoroñey, ie isa’e te foty ty maròy miakatse amy pepo maviakey naho hoe laleke te amy holitsey, le angamae izay, fa nirofotse boak’ amy nimaey; vaho ho tseize’ i mpisoroñey t’ie maleotse, angamae izay. ");
INSERT INTO tdx_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","F’ie isa’ i mpisoroñey te tsy a’ maròy foty i pepo maviakey naho tsy laleke te amy holi­tsey vaho niko-mavo; le havi’ i mpisoroñey fito andro. ");
INSERT INTO tdx_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Hisava aze amy andro faha-fitoy i mpisoroñey, le ie nandakak’ amy holitsey, ho tseize’ i mpisoroñey t’ie maleotse, angamae izay. ");
INSERT INTO tdx_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Aa naho tambatse amy toe’ey i pepo maviakey fa tsy nandakak’ amy holitsey, naho niko-mavo, le nitombolatse i hamaey; ho tseize’ i mpisoroñey te malio indatiy, fa heza’ i hamaey avao. ");
INSERT INTO tdx_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Naho eo ty lahilahy ndra ampela aman-kandra añambone’e ndra an-tanteahe’e, ");
INSERT INTO tdx_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","le ho savae’ i mpisoroñey i handray; aa naho isake t’ie laleke te amy holitsey, naho a’ maròy matify maviake ty ao le ho tseize’ i mpisoroñey te maleotse. Angamae mirofotse izay, añambone ndra an-tsomotse ao. ");
INSERT INTO tdx_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Aa naho savae’ i mpisoroñey i handra mañezañey, le isa’e t’ie tsy laleke te amy holitsey naho tsy ama’e ty volo mainte, fe havi’ i mpisoroñey fito andro i aman-kandra mañezañey. ");
INSERT INTO tdx_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Ie amy andro faha­fitoy le ho savae’ i mpisoroñey i handray; aa naho tsy nandakake o hezao, naho tsy ama’e ty volo mavoñe, vaho tsy laleke te amy holitsey i mañezañey, ");
INSERT INTO tdx_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","le hiharatse re fe tsy harate’e o hezao. Le havi’ i mpisoroñey fito andro indraike i aman-kezay. ");
INSERT INTO tdx_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Ho savae’ i mpisoroñey amy andro fahafitoy o hezao; ie onin-te tsy nandakak’ amy holi’ey o mañezañeo, naho tsy laleke te amy holi’ey le ho tseize’ i mpisoroñey t’ie malio. Ho sasà’e o siki’eo le halio re. ");
INSERT INTO tdx_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Fa naho toe mandakak’ amy holitsey o hezao ie fa nalio, ");
INSERT INTO tdx_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","le ho savae’ i mpisoroñey; aa naho toe nandakak’ amy holitsey o hezao le tsy hipay maròy mavoñe ka. Tsy malio re. ");
INSERT INTO tdx_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Fe naho isake te mizitse eo avao o heza’eo naho mitiry ama’e ty maròy mainte, le fa melañe o hezao. Malio le ho tseize’ i mpisoroñey t’ie malio. ");
INSERT INTO tdx_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Naho pepo maviake ty an-koli’ ondaty ndra ampela, toe pepo foty maviake, ");
INSERT INTO tdx_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","le ho savae’ i mpisoroñey; aa ie mavomavo ty hamendo’ o pepo amy holi’ i sandriñeio, le akiry avao izay. Malio indatiy. ");
INSERT INTO tdx_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Naho nihintsa-maròy t’indaty, ie tsiamaroy añambone, le malio. ");
INSERT INTO tdx_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Naho mihintsañe ty maroin-dahara’ ondaty, tsiamaroin-daharan-dre, fe malio. ");
INSERT INTO tdx_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Aa naho miboak’ añambone ndra an-daharañe tsiamaròy ty handra foty minday mena, le angamae ty mirofotse amy añambone’e bodoy ndra amy lahara’e solay. ");
INSERT INTO tdx_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ho savae’ i mpisoroñey, aa naho toe foty mikò-mena ty fibontaña’ i handra añambone’e tsiamaròy ndra an-dahara’e tsiamaròiy, hambañe ami’ty fiboaha’ ty angamae an-koli-tsandriñe, ");
INSERT INTO tdx_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","le voa’ ty angamae indatiy, tsy malio. Tsy mete tsy hitsey ty haleora’e i mpisoroñey; añambone’e i hasilofa’ey. ");
INSERT INTO tdx_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Aa ie angamae aman-kandra, le hisikin-drota, hapoke hiniñaniña o maroi’eo, naho ho rakofe’e ty fivimbi’e ambone vaho hikoikoike ty hoe: Tsy malio, Tsy malio. ");
INSERT INTO tdx_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Haleotse re amo hene andron-kasilofa’eo; tsy malio. Am-bangiñe ao ty himoneña’e; vaho ho alafe’ i tobey ty akiba’e. ");
INSERT INTO tdx_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ty amo sikiñeo: naho ama’e ty handran’ angamae ke an-damba volon’ añ´ondry he an-tsiky leny; ");
INSERT INTO tdx_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ke an-tenoñe, he añ’isañe, an-deny ndra am-bolon’ añondry, ke an’ angozy hera an-tsatan-koli­tsena inoñe, ");
INSERT INTO tdx_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","aa naho miboake amy handray ty antsetra ndra mena an-tsikiñe ndra an-kolitse, ke an-tenoñe, he añ’ isañe, ke añ’ angozy, he an-koli­tsena inoñe, le angamae izay vaho hatoro amy mpisoroñey. ");
INSERT INTO tdx_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Ho savae’ i mpisoroñey i handray vaho hakafi’e ao fito andro i aman-kandray. ");
INSERT INTO tdx_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ho sarie’e ami’ty andro faha-fito i handray. Aa naho nandakak’ amy lambay i handray hera an-tenoñe, ke añ’isañe, he añ’ angozy ke an-kolits-ena inoñe, le angamae mifindra i handray, maleotse izay. ");
INSERT INTO tdx_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ho forototoe’e i sikiñey ; aa ke te an-tenoñe, he añ’isañe, ke am-bolon’ añondry he an-deny, hera an-kolitsena inoñe ty angamae mifindra, le ho hotomomoheñe añ’afo. ");
INSERT INTO tdx_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Aa ie savae’ i mpisoroñey naho isa’e te tsy nandakak’ amy sikiñey i handray, ke an-tenoñe, he añ’ isañe, he an-kolits-ena inoñe, ");
INSERT INTO tdx_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","le ho lilie’ i mpisoroñey te ho sasaeñe i sikiñe niboaha’ i handray, vaho hakafi’e ao fito andro ka. ");
INSERT INTO tdx_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Ie fa sinasa i aman-kandray le ho savae’ i mpisoroñey. Aa ie tsy niova ty volo’ i handray ndra te tsy nandakake i handray, le maleotse; ho forototoe’o añ’afo, ke te ambone’e i fisolañey he am-panda’e. ");
INSERT INTO tdx_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Aa naho sarie’ i mpisoroñey le zoe’e te nikepake i handray, ie sinasay, le ho riate’e amy sikiñey ndra amy angoziy, ndra an-tenoñe, ndra añ’isañe. ");
INSERT INTO tdx_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Aa ie miboake indraik’ amy sikiñey ke an-tenoñe ke añ’isañe he aman-kolitse inoñe o firofotañeo, le ho forototoe’o añ’afo i aman-kandray. ");
INSERT INTO tdx_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Aa naho sasaeñe i sikiñey le nimosaoñe i handra an-tenoñe he añ’isañe, he añ’ inoñe holits-ena, le ho sasañe fañindroe’e vaho halio. ");
INSERT INTO tdx_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Izay ty Fetse’ o handran’ angamae an-tsikiñeo ke te an-tenoñe he añ’isañe, hera inoñe añ’angozy, ty handrendrehañe t’ie malio he t’ie maleotse. ");
INSERT INTO tdx_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Zao ty ho fetsen’ angamae amy andro añeferañe azey, t’ie hasese mb’amy mpisoroñey mb’eo; ");
INSERT INTO tdx_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","hiavotse i tobey i mpisoroñey, le hisava aze ey i mpisoroñey, aa ie isa’e te melañe ty handran’ angamae amy ‘ndatiy, ");
INSERT INTO tdx_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","le ho lilie’ i mpisoroñey ty haneseañe voroñe roe malio naho ty mendoraveñe naho ty fole mena vaho ty seva ho amy hefera­ñey. ");
INSERT INTO tdx_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Ho lilie’ i mpisoroñey ty handentàñe am-balàñe tane ao ambone rano mikararake ty voroñe raike. ");
INSERT INTO tdx_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Ho rambese’e ty voroñe veloñe naho i mendoraveñey naho i fole menay naho i sevay vaho halò’e mindre amy voroñe veloñey ami’ty lio’ i voroñe linenta ambone’ i rano veloñeiy. ");
INSERT INTO tdx_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Le ho fitseza’e im-pito i heferañe amy angamaeiy, naho hitsey t’ie malio, vaho havotso’e an-kivoke malalake ey i voroñe veloñey. ");
INSERT INTO tdx_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Ho sasà’ i heferañey o siki’eo, le hitsifa’e iaby o maroi’eo, naho hiandro an-drano, vaho halio. Añe izay, le mete mimoak’ an-tobe re, fe hitoetse alafe’ i kiboho’ey fito andro. ");
INSERT INTO tdx_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ie amy andro faha-fitoy ro hañitsike o maroi’e iabio, naho ty tanteahe’e, naho o hie’eo; fonga ho harate’e ze atao volo ama’e. Ho sasà’e o saro’eo naho hampiandroe’e ty sandri’e vaho halio. ");
INSERT INTO tdx_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Amy andro fahavaloy ty handram­besa’e vik’añondrilahy roe tsy aman-kandra, naho añondri-vave vanto’e tsy aman-kandra naho mona telo ampaha-folo’ ty famarañe ho ravoravo, linaro menake, vaho menake loge raike. ");
INSERT INTO tdx_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Sindre hijadoñe añatrefa’ Iehovà an-dala’ i kibohom-pamantañañey i mpisoroñe mañefetse azey naho indaty heferañey vaho i raha rezay. ");
INSERT INTO tdx_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Handrambe raik’ amy vik’ añondri­lahy rey i mpisoroñey le hampañarinea’e, naho hengae’e ho engan-dilatse, naho i menake loge raikey, vaho hahelahela’e ho engan-kelahela añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Le ho lenta’e i anak’ añondrilahiy ami’ty fandentañe o engan-kakeo naho enga-oroañe amy toe-miavakeio, fa a i mpisoroñey i engan-dilatsey manahake o engan-kakeoo; ie miava-do’e. ");
INSERT INTO tdx_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Le handrambesa’ i mpisoroñey ty lio’ i engan-dilatsey naho hatente’e an-dengon-dravembia havana’ i heferañey naho an-tondro-beim-pità’e havana vaho an-tondro-beim-pandia’e havana. ");
INSERT INTO tdx_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Handrambesa’ i mpisoroñey i menake loge raikey vaho añaliña’e an-dela-pità’e havia. ");
INSERT INTO tdx_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Le halò’ i mpisoroñey amy menake am-pità’e haviay i rambo-pità’e havanay vaho hapitsi­pitsin-drambo-pità’e im-pito añatrefa’ Iehovà i menakey. ");
INSERT INTO tdx_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Hangala’ i mpisoroñey i menak’ am-pità’e haviay le hatente’e an-dengon-dravembia’e havana’ i heferañey naho an-tondro-beim-pità’e havana naho an-tondro-beim-pandia’e havana amy lion-engan-dilatsey. ");
INSERT INTO tdx_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Hapeta’ i mpisoroñey amy añambone’ i hijebañañey ty menake sisa am-pità’e ao; le hefera’ i mpisoroñey añatrefa’ Iehovà: ");
INSERT INTO tdx_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Hengae’ i mpisoroñey i engan-kakeoy hijebañañe ty haleora’ i heferañey. Heneke Izay le ho lentae’e i hisoroñañey; ");
INSERT INTO tdx_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Hengae’ i mpisoroñey amy kitreliy i soroñañey naho i enga-mahakamay, izay ty hijebaña’ i mpisoroñey aze, vaho halio. ");
INSERT INTO tdx_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Aa ie rarake, tsy taka’ o fana­ña’eo, le handrambesa’e añondri­lahy vi’e raike ho engan-dilatse h­ahelahela, hijebañañe aze, naho mona fahafolo’ ty efà linaro menake ho enga-mahakama, naho ty menake loge raike, ");
INSERT INTO tdx_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","vaho deho roe ndra ana-boromahilala roe—ze takam-pita’e: ty raike ho engan-kakeo le ty raike hisoroñañe. ");
INSERT INTO tdx_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Ie amy andro fahavaloy ro hinday irezay mb’amy mpisoroñey hañeferañe aze, an-dalan-kibohom-pamantañañe eo, añatrefa’ Iehovà; ");
INSERT INTO tdx_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ho rambese’ i mpisoroñey i vik’añondrin’ engan-dilatsey naho i loge menakey vaho hahelahela’ i mpisoroñey añatrefa’ Iehovà ho engan-kelahela. ");
INSERT INTO tdx_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Ho lentae’e amy zao i vik’ añondrin’ engan-dilatsey le hangala’ i mpisoroñey amy lion’ engan-dilatsey ty hatente’e an-dengon-dravembia havana’ i heferañey, naho an-tondro-beim-pità’e havana vaho an-tondro-beim-pandia’e. ");
INSERT INTO tdx_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Le hañiliña’ i mpisoroñey an-dela-pità’e havia i menakey, ");
INSERT INTO tdx_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","le hafitse’ i mpisoroñey an-drambo-pità’e havana im-pito añatrefa’ Iehovà ty ila’ i menake am-pità’e haviay. ");
INSERT INTO tdx_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Le i menak’ am-pità’ey ty hatente’ i mpisoroñey an-dengon-dravembia havana’ i heferañey, naho amy tondro-beim-pità’e havanay naho amy tondro-beim-pandia’e havanay amy nanenteña’e i lion-engan-dilatseiy. ");
INSERT INTO tdx_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Hapeta’ i mpisoroñey ami’ty añambone’ i heferañey ty sisa’ i menak’ am-pità’e haviay, hijebañañe aze añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Le ho banabanae’e ty raik’ amy deho rey ndra amy ana-boromahilala rey, ze lefe’e, ");
INSERT INTO tdx_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","ze takam-pita’e, engan-kakeo ty raike le soroñe ty raike, tovo’ i enga-mahakamay; vaho hijebaña’ i mpisoroñey añatrefa’ Iehovà i eferañey. ");
INSERT INTO tdx_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Izay ty fetse amy handran’ angamae naho tsy lefem-pità’e ty hañenga ho amy fañeferañe azeiy. ");
INSERT INTO tdx_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Le hoe ty tsara’ Iehovà amy Mosè naho Aharone: ");
INSERT INTO tdx_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Ie mizilik’ an-tane Kanàne añe, i hatoloko ho fanañañey naho hapoko an-kiboho’ areo an-tane-panaña’ areo ao ty handran’ angamae, ");
INSERT INTO tdx_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","le hiheo mb’ amy mpisoroñey mb’eo ty tompo’ i anjombay hanao ty hoe, Naho amako, le hoe angorosy ty an-trañoko ao. ");
INSERT INTO tdx_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Aa le ho lilie’ i mpisoroñey ty hampikoahañe i anjombay aolo’ ty iziliha’ i mpisoroñey hibiribiry i handray, soa tsy ho leoreñe iaby ze amy anjombay ao; ie heneke izay le hizilik’ amy anjombay i mpisoroñey hisava aze. ");
INSERT INTO tdx_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Le ho biribirie’e i handray; aa naho tendreke te toe andrindri’ i trañoy ty handra an-toe’e mikafokafoke mena­mena ndra antsetra, naho hoe laleke te amy tarehe’ i rindriñey, ");
INSERT INTO tdx_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","le hiavotse amy lala’ i anjombay i mpisoroñey vaho harindri’e fito andro i anjombay. ");
INSERT INTO tdx_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Homb’eo indraike i mpisoroñey amy andro faha-fitoy hisava; aa naho nandakak’ amo rindri’ i akibaio i handray, ");
INSERT INTO tdx_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","le ho lilie’ i mpisoroñey te hakareñe o vato nanjoàñe i handraio vaho hariañe an-tane tiva alafe’ i rovay añe. ");
INSERT INTO tdx_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Le fonga hampikiahe’ i mpisoro­ñey ty añariari’ ty am-po’ i anjombay vaho hariañe an-deotse alafe’ i rovay añe i deboke nikiaheñey. ");
INSERT INTO tdx_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Hampijòña’ iereo vato hafa hasolo o vato teoo, vaho hangalà’ iereo pakotse hapakotse i anjombay. ");
INSERT INTO tdx_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Aa naho mirofotse amy anjombay indraike i handray, ie fa nakatra’e o vatoo, naho nikiahe’e i trañoy vaho nipakora’e, ");
INSERT INTO tdx_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","le hizilik’ ao i mpisoroñey hisava; ie oni’e te nandakak’ amy anjombay i handray, le angamae mipatsake amy anjombay ao izay, maleotse. ");
INSERT INTO tdx_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Le ho ro­bahe’e i anjombay, o vato’eo, o hatae’eo, naho ze pakotse ama’e iaby, vaho hendese’e mb’ an-deotse alafe’ i rovay añe; ");
INSERT INTO tdx_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","vaho haleotse pak’ amy harivay ze ondaty nizilik’ amy akiba maleo­tsey amy ze andro naha-katoke aze. ");
INSERT INTO tdx_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Hanasa o siki’eo ze nandre amy anjombay vaho hanasa o siki’eo ka ze nikama amy anjombay ao. ");
INSERT INTO tdx_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Fe naho mizilik’ ao i mpisoroñey misava aze vaho toe tsy nandakak’ amy anjombay i handray naho fa nipakorañe i anjombay, le ho tseize’ i mpisoroñey te malio i anjombay, amy te melañe i handra’ey. ");
INSERT INTO tdx_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Le ty hañeferañe i anjombay, handrambe voroñe roe re naho mendoraveñe naho mena vaho seva. ");
INSERT INTO tdx_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Ho lentae’e am-balañe tane ambone’ rano mikararake ty voroñe raike, ");
INSERT INTO tdx_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","le ho rambese’e i mendoraveñey, naho i sevay naho i fole menay rekets’ i voroñe veloñey naho halò’e amy lio’ i voroñe linentay naho amy rano mikararakey, vaho hafitsi’e im-pito amy anjombay. ");
INSERT INTO tdx_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Izay ty hañaliova’e i anjombay ami’ty lio’ i voroñey naho amy rano mikararakey naho amy mendoraveñey naho amy sevay vaho amy menay. ");
INSERT INTO tdx_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Havotso’e alafe’ i rovay an-kivoke malalake ey ka i voroñe veloñey, izay ty hijebaña’e i anjombay, le halio. ");
INSERT INTO tdx_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Izay ro fetse amy ze hene handran’ angamae naho o mandrekedreketseo, ");
INSERT INTO tdx_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","naho ami’ty angamae an-tsikiñe naho añ’akiba ");
INSERT INTO tdx_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","naho ami’ty tombolatse ndra ty firofotse ndra ty pepo mendo, ");
INSERT INTO tdx_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","hañohañe ty haleora’e naho ty haliova’e. Izay o fetsen’ angamaeo. ");
INSERT INTO tdx_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Hoe ty nitsara’ Iehovà amy Mosè naho Aharone: ­ ");
INSERT INTO tdx_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Saontsio amo ana’ Israeleo ty hoe: Ie mandranoke ty sandrin-dahilahy le maleotse i fandranohañey. ");
INSERT INTO tdx_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Hoe zao ty fandeora’ i fioriha’ey: ke ampiorihe’ i sandri’ey, ke jenjeñe’ i sandriñey tsy handrano, fa songa haleora’e. ");
INSERT INTO tdx_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Fonga haleotse ze fandrea andrea’ i mandranoy, sindre haleotse ze iambesara’e. ");
INSERT INTO tdx_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Hanasa o siki’eo ze mitsapa i tihi’ey, naho hiandro an-drano, le ie tsy halio ampara’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Hanasa o siki’eo ka ze miambesatse amy niambesara’ i mandranoiy, vaho hiandro an-drano, le tsy halio ampara’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Hanasa o siki’eo naho hiandro an-drano ka ze mitsapa ty sandri’ i mandranoy vaho tsy halio am-para’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Aa naho androrà’ i mandranoy ami’ty malio, le hanasa o siki’eo naho hiandro an-drano re vaho tsy halio ampara’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Haleotse ka ze sarete ijoña’ i mandranoy. ");
INSERT INTO tdx_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Tsy halio am-para’ te hariva ty mitsapa ze raha tambane’e ao, hanasa o siki’eo re; le hiandro an-drano ze minday i rahay vaho haleotse ampara’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Hanasa o siki’eo, naho hiandro an-drano, le tsy halio ampara’ te hariva ze hene tsapae’ i mandranoy naho tsy sasà’e an-drano hey o fità’eo. ");
INSERT INTO tdx_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Ho foieñe ze valàñe-tane nitsapae’ i mandranoy, le hene ho popohen-drano ze finga hatae. ");
INSERT INTO tdx_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Ie nilioveñe amy fandranoa’ey indaty nandranoy, le hañiake fito andro ho amy fañaliova’ey; ho sasà’e o siki’eo naho hampiandroe’e an-drano mikararake i sandri’ey, vaho halio. ");
INSERT INTO tdx_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Ie amy andro fahavaloy, le handrambe deho roe ndra ana-boromahilala roe re naho hiheo mb’ añatrefa’ Iehovà mb’an-dalan-kibohom-pamantañañe mb’eo, vaho hatolo’e amy mpisoroñey. ");
INSERT INTO tdx_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Le hengae’ i mpisoroñey, ty raike ho engan-kakeo, ty raike hisoroñañe, vaho hijebañe aze añatrefa’ Iehovà i mpisoroñey amy fandranoa’ey. ");
INSERT INTO tdx_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Aa naho iakaran-­drom-pilahiañe t’indaty, le hampiandroe’e an-drano i sandri’e iabiy, vaho haleotse am-para’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Fonga ho sasañe an-drano ze lamba ndra holitse nipoha’ i rompilahiañey, vaho tsy halio am-para’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Ie miolotse ami’ty ampela ty lahilahy naho miakatse ty rom-pilahiañe, le hiandro an-drano iereo roroe vaho tsy halio am-para’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Naho mañaka-ranoke ty ampela, le lio ty miakatse i sandri’ey le ho tambatse amy haleoram-piambola’ey fito andro re, vaho haleotse ze mitsapa aze ampara’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Sindre haleotse ze andrea’e amy fiambaha’ey; songa haleotse ka ze iambesara’e. ");
INSERT INTO tdx_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Hanasa o siki’eo naho hiandro an-drano ze mitsapa ty fandrea’e vaho tsy halio am-para’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Hanasa o siki’eo naho hiandro an-drano ka ze mitsapa ty niambesara’e, vaho tsy halio am-para’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Vata’e tsapae’e ty fandrea’e ndra ze niambesara’e le maleotse ampara’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Naho mitrao-sarimbo ama’e ty lahilahy, le midoñe ama’e i haleora’ey le haleotse fito andro, vaho haloto ka ze andrea’e. ");
INSERT INTO tdx_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Naho miaka-dio andro maro tsy amy fiambola’ey ty ampela, he andro mandikoatse i fiambola’ey, le ampanahafeñe amy haleoram-piambola’ey ze hene andro iakaran-deotse ama’e. Tsy halio re. ");
INSERT INTO tdx_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Hanahake ty fandream-piambola’e ze fandreañe andrea’e amy fiakaran-dio’ey; vaho haleotse ka ze iambesara’e, manahake i haleoram-piambola’ey. ");
INSERT INTO tdx_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Songa haleotse ze mitsapa irezay; ho sasa’e ty siki’e le hiandro an-drano, vaho tsy halio ampara’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Ie malio amy fiakaran-dio’ey, le hañiake fito andro, tampetse izay vaho halio. ");
INSERT INTO tdx_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Ie amy andro fahavaloy, hangalake deho roe ndra ana-boromahilala roe ho am­bata’e, le hasese’e amy mpisoroñe an-dalan-kibohom-pamantañañey. ");
INSERT INTO tdx_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Le hengae’ i mpisoroñey ho engan-kakeo ty raike le hisoroñañe ty raike, izay ty hijebaña’ i mpisoroñey aze añatrefa’ Iehovà amy fiakaran-kaleora’ey. ");
INSERT INTO tdx_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Izay ty hampiambaha’ areo o ana’ Israeleo amo haleora’eo, tsy mone hikoromak’ amo haleora’eo ie mandeotse i kivohoko añivo’ iereoy. ");
INSERT INTO tdx_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Izay ty fetse i mandranokey, naho indaty iakaran-drom-pilahiañe mampaleotse azey, ");
INSERT INTO tdx_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","naho i rakemba silofe’ ty haleoram-piambola’ey, naho i iakaran-dranokey ke lahy he ampela, vaho indaty mifandia-tihy ami’ty ampela amy haleora’eiy. ");
INSERT INTO tdx_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Hoe ty nitsara’ Iehovà amy Mosè naho fa nikoromake i ana-dahi’ i Aharone roe rey, ie nañarine am’ Iehovà vaho nivetrake; ");
INSERT INTO tdx_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","aa hoe t’Iehovà amy Mosè: Saontsio aman-drahalahi’o Aharone ty tsy himoake tsi-nahy amy toe-miavake añate’ i lamba-fañefetsey ao, hiatrek’ am’ i toem-pijebañañe ambone’ i vatam-pañinaiy, tsy mone hihomake, fa miboak’ amy rahoñe ambone’ i toem-pijebañañeiy iraho. ");
INSERT INTO tdx_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Zao ty hiziliha’ i Aharone amy Toe-miavakey ao: reketse ty bania ho engan-kakeo, naho ty añon­drilahy hisoroñañe. ");
INSERT INTO tdx_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Hiombea’e i saroñe leny miavakey naho o saroñe leny manaroñe i sandri’eio; ho diañe’e i fiètse leniy, vaho hiombea’e i sabaka leniy; ie sindre sikiñe miavake; ho sasà’e an-drano hey i sandri’ey, vaho hañombe irezay. ");
INSERT INTO tdx_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Le hangalake vik’oselahy roe amy fivori’ bein’ ana’ Israeley re ho engan-kakeo, naho ty añondrilahy hisoroñañe. ");
INSERT INTO tdx_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Le hasese’ i Aharone i banian’ engan-kakeo ho am-bata’ey, hijebaña’e ty vata’e naho i anjomba’ey. ");
INSERT INTO tdx_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ho rambese’e i ose roe rey, vaho hampijohaña’e aolo’ Iehovà an-dalan-kibohom-pamantañañe eo. ");
INSERT INTO tdx_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Le hanao kitsapake amy ose roe rey t’i Aharone; ty tsapake raike ho a Iehovà vaho ty tsapake raike ho a i Azazele. ");
INSERT INTO tdx_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Ho banabanae’ i Aharone i ose niazo an-tsapake ho a’ Iehovà le hengae’e ho engan-kakeo, ");
INSERT INTO tdx_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","fe hampijohañañe veloñe aolo’ Iehovà i ose niazo an-tsapake ho a i Azazeley, hanoañe fijebañañe vaho hampihitrifeñe mb’am-patrambey mb’amy Azazele añe. ");
INSERT INTO tdx_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Hengae’ i Aharone amy zao i banian’ engan-kakeo ho am-bata’ey, hijebañe ty vata’e naho o añ’anjomba’eo, vaho ho lenta’e i banian’ engan-kakeo ho am-bata’ey. ");
INSERT INTO tdx_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Ho rambese’e ty sadro pea vae mirekake boak’ amy kitrely añatrefa’ Iehovày, naho ty emboke mañitse dinemoke mahaatsa-pitàn-droe vaho hasese’e mb’amy lamba-fañefetsey ao, ");
INSERT INTO tdx_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","hapo’e ambone’ i afo añatrefa’ Iehovày i embokey, hañàmpoa’e i toem-pijebañañe ambone’ i fañinaiy i hatoen-embokey, tsy mone hivetrake re. ");
INSERT INTO tdx_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Handrambesa’e ty lio’ i baniay le hafitsen-drambo-pità’e añ’ila atiñana’ i toem-pijebañañey, vaho hafitsen-drambo-pità’e im-pito aolo’ i toem-pijebañañey i lioy. ");
INSERT INTO tdx_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Ho lentae’e amy zao i osen-engan-kakeo ho a ondatioy vaho hendese’e mb’am-po i lamba fañefe­tsey ao ty lio’e, le hambañe amy nanoa’e amy liom-baniaiy ty hanoa’e amy lioy: hafitse’e amy kapekey naho aolo’ i kapekey, ");
INSERT INTO tdx_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","le hijebañe i toe-miavakey re ty amo haleora’ o ana’Israeleoo, naho ty amo fiolàñe nampanan-tahiñe iareo iabio; izay ka ty hanoe’e amy kibohom-pamantañañe mitoboke añivo’ ty haleora’ iareoy. ");
INSERT INTO tdx_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Ko apoke te ho ama’ ondaty ty an-kibohom-pamantañañe ao ie mimoak’ ao hijebañe amy toe-miavakey ampara’ te miavotse, ie fa nanao hijebañañe ho amy vata’ey naho i anjomba’ey vaho i valobohò’ Israele iabiy. ");
INSERT INTO tdx_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Hiavotse mb’amy kitreliy añatrefa’ Iehovà mb’eo re hijebañañe aze, naho hangalak’ ami’ ty lio’ i baniay naho ami’ty lio’ i osey, vaho hatente’e amo tsifa miariari’ i kitreliio. ");
INSERT INTO tdx_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Le hamitseza’e lio im-pito an-drambo-pità’e, hañaliova’e hiavake ami’ty haleora’ o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Ie heneke ty fañefera’e i toe-miavakey naho i kibohom-pamantañañey naho i kitreliy, le hampiatrefe’e i ose veloñey. ");
INSERT INTO tdx_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Hasampe’ i Aharone an-doha’ i ose’ veloñey ty fità’e roe le hiantofa’e ama’e ze hene hìla’ o ana’ Israeleo, naho o fiodiañe nampanan-kakeo iareo iabio le hapo’e an-doha’ i osey, vaho hampanesefeñe mb’am-patrambey añe, am-pità’ t’indaty nihentseñeñe. ");
INSERT INTO tdx_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Fonga ho vavè’ i osey am-bata’e mb’ am-bangìñe añe o hakeo’ iareoo; le hampidada’e an-dratraratra añe i osey. ");
INSERT INTO tdx_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Ie añe, le hizilik’ an-kibohom-pamantañañe ao t’i Aharone hañafake o siki-leny nisaroña’e amy fiziliha’e amy toe-miavakeiio vaho hapo’e ao; ");
INSERT INTO tdx_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","le hanasa sandriñe an-drano amy toe-miavakey re, le hañombe saroñe ila’e naho hiavotse vaho hañenga i soroñe ho am-bata’ey naho i soroñe ho a ondatioy hijebaña’e ty vata’e naho ondatio, ");
INSERT INTO tdx_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","hengae’e an-katoeñe amy kitreliy ty safo’ i engan-kakeoy. ");
INSERT INTO tdx_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Le ho sasà’ i nanese i ose mb’amy Azazeley o saro’eo vaho hiandro an-drano, heneke izay le himoak’ an-tobe ao. ");
INSERT INTO tdx_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Ho jinieñe alafe’ i tobey i banian-engan-kakeoy naho i osen-engan-kakeoy; i nañandesan-dio hijebañañe i toe-miavakey rey, le fonga horoañe ty holi’iareo, ty nofo’iareo vaho ty tai’ iareo. ");
INSERT INTO tdx_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Ho sasà’ i mpañoro’ irezaiy o siki’eo, naho hampandroa’e an-drano i sandri’ey; izay re vaho hizilik’ an-tobe ao. ");
INSERT INTO tdx_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Hambena’ areo ho fañè nainai’e zao: ami’ty volam-paha fito, ami’ty andro faha folo’ i volañey, le hilie-batañe nahareo tsy hitoloñe aman-dra inoñ’inoñe, ke t’ie samak’ an-tane, he t’ie renetane mimoneñe ama’ areo ao. ");
INSERT INTO tdx_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Fijebańañe anahareo i andro zay, fañaliovañe; soa t’ie halio añatrefa’ Iehovà amo fonga hakeo’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Ho Sabatam-pitofàñe do’e ho anahareo izay, hi­liera’ areo vatañe; ie fañè nainai’e tsy modo. ");
INSERT INTO tdx_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","I mpisoroñe norizañe naho natokañe hitoloñe ho mpisoroñe handimbe an-drae’ey ty hanao i fijebañañey, ie hañombe o saroñe lenio, o saro-miavakeo, ");
INSERT INTO tdx_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","naho hijebaña’e i toe-miavakey, naho hijebañe i kibohom-pamantañañey naho i kitreliy, eka naho o mpisoroñeo naho ondaty amy valobohòkey iabio. ");
INSERT INTO tdx_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Ho fañè nainai’e tsy modo ho anahareo izay, hijebañañe o ana’ Israeleo amo tahi’ iareo iabio boa-taoñe. Le nanoe’ i Mosè i nandilia’ Iehovày ");
INSERT INTO tdx_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Saontsio amy Aharone naho amo ana’eo naho amo ana’ Israele iabio ty hoe: Hoe ty nandilia’ Iehovà: ");
INSERT INTO tdx_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Ze ondaty boak’ añ’ anjomba’ Israele mandenta añombe ndra vik’ añondry ndra ose an-tobe ao, he te lentae’e alafe’ i tobey ey, ");
INSERT INTO tdx_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","naho tsy nendese’e an-dalan-kibohom-pamantañañe eo hañeng’aze am’ Iehovà, aolo’ i kivoho’ Iehovày le hanan-tahin-dio indaty nampiori-dioy vaho haito­añe am’ondati’eo, ");
INSERT INTO tdx_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","soa te hasese’ o ana’ Israeleo o soroñe ho nisoroña’ iareo an-dio­lioo, mb’am’ Iehovà an-dalan-kibohom-pamantañañe mb’eo, mb’ amy mpisoroñey, hisoroñe irezay ho engam-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Le hafitse’ i mpisoroñey amy kitreli’ Iehovà an-dalan-kibohom-pamantañañey i lioy, vaho hengae’e an-katoeñe i safo’ey ho hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Tsy hañenga soroñe amo koko­lampao ka iereo, o nanoa’ iereo hakarapiloañeo. Ho fañè nainai’e am’ iareo amo hene tariratse mifandimbeo. ");
INSERT INTO tdx_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Tovoño ty hoe am’ iereo: Ze ondaty, ke boak’ añ’anjomba’ Israele ao, he renetane mimoneñe ama’ areo ao, misoroñe ndra mañenga, ");
INSERT INTO tdx_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","naho tsy endese’e mb’an-dalan-kibohom-pamantañañe mb’eo, hañenga aze am’ Iehovà le ho sasàñe am’ondatio indatiy. ");
INSERT INTO tdx_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Le ze ondaty, ke boak’ añ’ anjomba’ Israele ao he hirik’ amo renetane mañialo am’iareoo, ty mikama lioñ-inoñ’ inoñe, le hiatreatre am’ indaty mikama lioy ty laharako vaho haitoako am’ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Toe lio ty havelo’ o nofo­tseo; ie ty natoroko anahareo amy kitreliy ho fijebañañe ty fiai’ areo; toe lio ro mañefetse ho an-kaveloñe. ");
INSERT INTO tdx_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Izay ty talim-panoako amo ana’ Israeleo ty hoe: Leo ondaty raik’ ama’ areo tsy hikama lio, vaho tsy hikama lio ka ze renetane mañialo ama’ areo ao. ");
INSERT INTO tdx_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Aa ndra iaia t’indaty amo ana’ Israeleo, ke amo renetane mimo­neñe ama’eo ze mitsindroke naho mitse­pake biby ndra voroñe azo kamaeñe, le tsy mete tsy hampi­orihe’e ty lio’e vaho lembefañe amo debokeo, ");
INSERT INTO tdx_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","fa ie ty fiai’ ze kila nofotse, naho raik’ amy havelo’ey ty lio’e; izay ty nitaroñeko amo ana’ Israeleo ty hoe: Tsy ho kamaeñe ty lio’ ze atao nofotse, fa ty lio ro fiai’ ze hene nofotse, fonga haitoañe ze mikama aze. ");
INSERT INTO tdx_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Le ze ondaty mikama ty mate bo­boke ndra ty nirimitem-biby, ke t’ie foko he renetane, ho sasà’e ty siki’e naho hiandro an-drano, le tsy halio ampara’ te hariva; izay vaho halio. ");
INSERT INTO tdx_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Fa naho tsy isasà’e ndra tsy manasa sandriñe le ho vavè’e ty tahi’e. ");
INSERT INTO tdx_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Misaontsia amo ana’ Israeleo, taroño ty hoe: Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Ko anoe’ areo o satan-tane Mitsraime nimoneña’ areoo; le tsy hanoe’ areo ka o satan-tane Kanàne aneseako anahareoo, tsy hañaveloa’ areo o fañè’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Hanoe’ areo o fepè­koo vaho hambena’ areo o fañèkoo, hañaveloa’ areo: Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Aa le ambeno o fañèkoo naho o fepè­koo, kanao mahaveloñe ondaty t’ie anoe’e: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Tsy ama’ areo ty hitotoke an-dongo’e marine, hañafa-tsaron-kameñarañe: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Tsy hafaha’o ty heñan-drae’o ndra ty heñan-drene’o. Rene’o re, tsy haboa’o ty heña’e. ");
INSERT INTO tdx_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Ko aboa’o ty heñam-balin-drae’o, fa heñan-drae’o. ");
INSERT INTO tdx_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Le ty heñan-drahavave’o, he anak’ ampelan-drae’o ke anak’ ampelan-drene’o, he t’ie te­ra­k’ añ’ anjomba ke te terak’ amontoñe, tsy haboa’o ty heña’e. ");
INSERT INTO tdx_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ty heñan’ anak’ ampelan’ anadahi’o ke anak’ ampelan’ anak’ ampela’o, le tsy haboa’o amy te heña’o ty a’ iareo. ");
INSERT INTO tdx_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Ty heñan’ anak’ ampelam-balin-drae’o, i nasaman-drae’oy, tsy haboa’o fa rahavave’o. ");
INSERT INTO tdx_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Tsy haboa’o ty heñan-dra­havaven-drae’o, amy t’ie longon-drae’o. ");
INSERT INTO tdx_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Tsy haboa’o ty heñan-drahavaven-drene’o, amy te longon-drene’o. ");
INSERT INTO tdx_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Tsy haboa’o ty heñan-drahalahin-drae’o. Ko vonje’o i vali’ey, fa rahavaven-drae’o. ");
INSERT INTO tdx_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Tsy haboa’o ty heñam-binanto’o, fa valin’ana-dahi’o; tsy haboa’o ty heña’e. ");
INSERT INTO tdx_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Tsy haboa’o ty heñam-balin-drahalahi’o, fa heñan-drahalahi’o. ");
INSERT INTO tdx_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Tsy songa haboa’o ty fimeñaran-drakemba naho ty anak’ ampela’e, tsy ho rambese’o ty anak’ ampelan’ anadahi’e ndra ty anak’ ampelan’ anak’ ampela’e hañafahañe ty heña’e; longo’o iereo, hativàñe izay. ");
INSERT INTO tdx_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Tsy halae’o ka ty ampela hampirafese’o aman-draha­vave’e, hampiboake ty heña’e naho mbe veloñe i raha­vave’ey. ");
INSERT INTO tdx_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Tsy hiharinea’o ka ty ampela haña­faha’o ty heña’e amy faleoram-piam­bola’ey; ");
INSERT INTO tdx_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","vaho tsy rantove’o ty vali’ ondaty, hanivà’o vatañe. ");
INSERT INTO tdx_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ko mañenga ho soroheñe amy Moleka o tarira’oo, hanivà’o ty tahinan’ Añahare’o: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Tsy hiolotse ami’ty lahilahy irehe, manahake te aman’ ampela. Tiva izay. ");
INSERT INTO tdx_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Tsy hisahe biby irehe hanivà’o vatañe. Le tsy hijohañe añatrefa’ ty biby ty ampela hisahe ama’e; fa ota-faly. ");
INSERT INTO tdx_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Ko maniva-vatañe an-dra’ inoñ’ inoñe amy rezay, fa ie ty nahativa o hene foko roàheko aolo’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Izay ty nahaveta i taney; aa le name­tsahako fandilovañe, vaho naboloa’ i taney o mpi­moneñe ama’eo. ");
INSERT INTO tdx_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Inahareo arè, tambozoro o fañèkoo naho o fepèkoo, ko manao i hativàñe rezay, ndra t’ie foko ndra renetane mañialo ama’ areo ao, ");
INSERT INTO tdx_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","(amy te ni-fanoe’ ondati’ i taneio, o taolo’ areoo, i hativàñe rezay: vaho nihaveta i taney) ");
INSERT INTO tdx_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","tsy mone haboloa’ i taney ka nahareo naho itivà’ areo, manahake ty nampi­boloaña’e i foko limbeze’ areoy? ");
INSERT INTO tdx_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Aa ndra ia’ ia manao ndra inoñ’ inoñe amy raha tiva rezay, le haitoañe am’ondati’eo indaty manao izay. ");
INSERT INTO tdx_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Aa le ambeno o fañèkoo, tsy mone hanoe’ areo o sata’ tiva nanoeñe aolo’ areoo, tsy hanivà’ areo vatañe; Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Misaontsia amy valobohòn’ ana’ Israeley, le ano ty hoe: Miavaha, amy te masin-dRaho, Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Songa miasia rene naho rae, naho ambeno o Sabotsekoo: Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Ko mitolike mb’amo samposampon-drahao ndra mampitranake saren-drahare; Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Ie mañenga soron-kanintsiñe am’ Iehovà, le engao an-tsata no’e. ");
INSERT INTO tdx_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ho kamaeñe amy andro añenga’ areo azey naho an-doak’andro’e le ho forototoeñe an’ afo ze sisa’e te he­rone. ");
INSERT INTO tdx_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ho tiva re te kamaeñe amy andro fahateloy; tsy ho no’e. ");
INSERT INTO tdx_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Songa hivave i tahi’ey ze mikama ama’e, amy te nitivàe’e ty raha miava’ Iehovà, vaho haitoañe am’ ondati’eo indatiy. ");
INSERT INTO tdx_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Ie manatake ty havokaran-tane’ areo, tsy ho tatahe’o ty añ’ olon-tete’o, tsy hatonto’o ze nipopok’ amo tinata’oo. ");
INSERT INTO tdx_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Tsy ho rofota’o ze sisan-tondam-balòbo’o; ndra timponeñe o voan-tanem-bahe’o nipopokeo, fa hado’o ho a o rarakeo naho o renetaneo: Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Ko mikametse nahareo, ndra mikatramo, ndra mifandañitse. ");
INSERT INTO tdx_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Ko manao fanta vìlañe ami’ty añarako, hanivà’o ty tahinan’ Añahare’o. Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Ko katramoe’o ondatio; ndra mikizo ama’e; le ko tana’o an-kiboho’o ao ampara’ te maraiñe ty tambem-pièke. ");
INSERT INTO tdx_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ko manimbo ty moañe ndra mampipoke fitsikapiañe aolo’ ty fey. Mañeveña aman’ Añahare’o: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Ko manao zaka vilañe; tsy honjone’o ty lahara’ ty rarake, vaho tsy hiasia’o ty fanalolahy, fa an-kavantañañe ty hizaka’o ondatio. ");
INSERT INTO tdx_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Ko mangarèdake mb’eo mb’eo am’ ondati’oo; le ko mijohanjohañe marine’ ty lio’ ondatio, Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Ko malain-dongo an-tro’o ao. Toe hendaha’o an-kahiti’e ondatio, tsy hivavea’o hakeo. ");
INSERT INTO tdx_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ko mamale-fate, le ko mitan-kabò amo ana-dongo’oo; fe kokò ondatio manahake ty vata’o; Izaho Iehovà ");
INSERT INTO tdx_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Oriho’ areo o fañèkoo. Ko ampisahè’o an-karazan-kare ila’e ty hare’ area. Ko mitongy doria roe karaza’e an-tete’o ao; vaho ko misikin-tsaroñe tinenoñe am-pole roe. ");
INSERT INTO tdx_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Ze mañarapilo ami’ty ampela, ie ondevo nifofoe’ t’ indaty, fa tsy nijebañene naho tsy nihahañe. Hanoeñe balie, fe tsy havetrake iereo amy t’ie tsy nidada. ");
INSERT INTO tdx_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Hasese’ indatiy mb’am’ Iehovà ty engan-dila’e mb’ an-dalan-kibohom-pamantañañe mb’eo; añondrilahy ty ho engan-dilatse. ");
INSERT INTO tdx_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Hijebañe aze amy añondrilahin-engan-dilatsey añatrefa’ Iehovà i mpisoroñey ty amy tahiñe nanoe’ey, vaho hapoke i hakeo nanoe’ey. ");
INSERT INTO tdx_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Ie mimoak’ amy taney naha­reo vaho fa nambole hatae maro karaza’e ho haneñe, le ho savare’ areo o hataeo. Ho falie’ areo telo taoñe, tsy ho kamaeñe. ");
INSERT INTO tdx_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Ie amy taom-paha-efatsey le hiavake iaby o voa’eo, handrengeañe Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Amy taom-paha-lime’ey ty hikama’ areo o voa’eo, hiregoregoa’ ty havokara’e: Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Tsy ho kamae’ areo ze aman-dio’e; le tsy hanikily nahareo ndra hamoreke. ");
INSERT INTO tdx_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Tsy haratañe ty maròy miroroñe am-panda, vaho ko kovoheñe ty morare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Ko lilie’ areo ty holi’ areo ty amo vilasio vaho ko anokirañe o sandri’ areoo; Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Ko maniva ty anak’ampela’o an-katsimirirañe, tsy mone hikapotrake an-karapiloañe ty tane, vaho ho tsi­tsike halò-tsereke i taney. ");
INSERT INTO tdx_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Hambena’ areo o Sabata­koo vaho hiasia’ areo i toeko miavakey: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Ko mitolik’ amo mpamorekeo ndra mitsoeke jiny hanivàñ’ azo; Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Miongaha añatrefa’ ty a-maròy foty, le iasio ty laharan’ androa­navy, vaho mañeveña aman’ Añahare’ areo; Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Aa naho mitrao-pimoneñe ama’ areo an-tane’ areo ao ty renetane le ko foreforèñe. ");
INSERT INTO tdx_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Hatao’ areo hambañe amy te nisamak’ ama’ areo ao o renetaneo, le ikoko manahake ty vata’o, fa niambahiny an-tane Mitsraime añe nahareo; Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Tsy hanao zaka-vilañe nahareo, ke ami’ty zehe, ke ami’ty lanja, he ami’ ty kapoake. ");
INSERT INTO tdx_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Manaña balàntsy to naho vato’e to naho kapoake to naho litatse to; Izaho Iehovà Andria­nañahare’ areo nañavotse anahareo an-tane Mitsraime. ");
INSERT INTO tdx_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Aa le ambeno iaby o fañèkoo naho ze hene fepèko vaho oriho; Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Saontsio ty hoe ka o ana’ Israeleo: Ndra iaia amo ana’ Israeleo ke amo renetane mimoneñe e Israeleo ze manolotse ty raik’ amo tarira’eo amy Moleka ro havetrake; le ondati’ i taneio ro handre­tsa-bato ama’e. ");
INSERT INTO tdx_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Hatreatrèn-tareheko indatiy le haitoako am’ ondati’eo, amy nanolora’e anake amy Molekay, hanivà’e i toeko miavakey vaho hanimbo ty añarako miavake. ");
INSERT INTO tdx_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Aa naho akipe’ ondati’ i taneio am’ indatiy ty fihaino’ iareo ie manolo-tiry amy Moleka, vaho tsy navetrake, ");
INSERT INTO tdx_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","le hatreatrén-tareheko indatiy naho i hasavereña’ey, le haitoako am’ on­dati’eo rekets’ o nindre nañarapilo ama’e vaho nitsinginiotse amy Molekao. ");
INSERT INTO tdx_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Le hatreatrèn-tareheko ty mpitolik’ amo mpamorekeo naho amo jinio hañarapilo vatañe, hatreatrén-tareheko indatiy, vaho haitoako am’ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Miefera arè, naho miavaha, fa Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Mifahara amo fañèkoo vaho oriho: amy te Izaho i Iehovà mampiambak’ anahareo. ");
INSERT INTO tdx_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Tsy mahay tsy havetrake ze mamàtse rae ndra rene; ie nañozon-drae ndra rene, le ho ama’e ty lio’e. ");
INSERT INTO tdx_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","T’indaty miharo sarimbo ami’ty vali’ ondaty, ie miolotse amy tañanjomban-drañe’ey, le sindre havetrake i namonjey naho i vinonjey. ");
INSERT INTO tdx_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Ze lahilahy mifandia-tihy ami’ty tañanjomban-drae’e le fa nañàlo ty heñan-drae’e; songa havetrake ie­reon-droroe; am’ iereo ty lio’ iareo. ");
INSERT INTO tdx_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Naho miharo sarimbo ami’ty vinanto’e ampela t’indaty le havetrake ie roe. Nanao hativàñe le am’ iereo ty lio’ iareo. ");
INSERT INTO tdx_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Naho iharoa’ ty lahilahy ty lahilahy manahake ty fiolorañe ami’ty ampela, songa nanao hativàñe. Sindre havetrake, songa ama’e ty lio’e. ");
INSERT INTO tdx_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Naho valie’ ondaty ty ampela naho ty rene’ i ampelay, haloloañe izay, songa ho forototoeñ-añ’afo, ie naho iereo, tsy mone hanjilihan-katserehañe ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Naho misahe hare t’indaty le toe hañohofan-doza, le ho lentañe i bibiy. ");
INSERT INTO tdx_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Naho miharine ami’ty hare ty ampela hisahe le ho vonoe’o i ampelay naho i bibiy. Tsy mete tsy havetrake; songa ho ama’e ty lio’e. ");
INSERT INTO tdx_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Naho rambese’ondaty ty raha­vave’e ke ty anak’ ampelan-drae’e he ty anan-drene’e vaho isa’e ty heña’e le mahaisake i heña’ey ka i ampelay, le haloloañe izay. Vonoeñe añatrefa’ o ana’ ondati’eo ie roe, amy te hinalo’e ty heñan-drahavave’e. Ho vavè’e i hakeo’ey. ");
INSERT INTO tdx_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Ie miharo sarimbo ami’ty ampela miambolañe t’indaty naho mampiboake ty heña’e—ie nampiboake i fioriha’ey, vaho niborahe’ i ampelay ty fiorihan-dio’e, le haitoañe am’ondati’eo i roroey. ");
INSERT INTO tdx_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Tsy haboa’o ty heñan-drahavaven-drene’o, ndra ty rahavaven-drae’o; ie mañalo longo marine. Songa hivave ty tahi’e. ");
INSERT INTO tdx_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Naho mifandia-tihy ami’ty valin-drahalahin-drae’e t’indaty, le fa nafaha’e ty heñan-drahalahin-drae’e; sindre hivave ty hakeo’e, songa hikoromake betsiterake. ");
INSERT INTO tdx_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Naho tsindrohe’ ondaty ty valin-drahalahi’e, hativàñe izay. Fa nampikorendahe’e ty heñan-drahalahi’e; ho betsiterake iereo. ");
INSERT INTO tdx_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Aa le hene ambeno o fañèkoo, naho o fepèko iabio, vaho anò, tsy mone ha­bo­loa’ i tane aneseako anahareo himo­neñañey. ");
INSERT INTO tdx_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Le tsy hañaveloa’ areo o sata’ i foko soiheko aolo’ areoio; amy te lili’ iareo irezay vaho mampangorìñ’ ahy. ");
INSERT INTO tdx_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Toe nitaroñeko ama’ areo te ho lovae’ areo ty tane’ iareo, le hatoloko ho tavane’ areo i tane orikorihen-dronono naho tanteley. Izaho Iehovà Andrianañahare’ areo ty nañavak’ anahareo amo kilakila ondatio. ");
INSERT INTO tdx_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Aa le ampiavaho ami’ty biby faly ty malio naho ty vorom-paly ami’ty malio, vaho ko maniva vatañe amo bibio ke amo voroñeo he amy ze karazan-draha veloñe misitsitse an-tane atoy, ie nambahako ama’ areo hambena’ areo ho faly. ");
INSERT INTO tdx_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Aa le hiavake ho ahy nahareo, amy te masiñe Raho Iehovà vaho navaheko amo kilakila ondatio ho ahiko. ");
INSERT INTO tdx_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Tsy mete tsy havetrake ty jiny naho ty doany, ke t’ie lahilahy he rakem­ba, ho retsahem-bato, sindre ho ama’e ty lio’e. ");
INSERT INTO tdx_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Hoe ty nitsara’ Iehovà amy Mosè: Misaontsia amo mpisoroñeo, o ana’ i Aharoneo, le itaroño ty hoe: Asoao tsy ho am’iereo ty haniva vatañe ami’ty lolo am’ondati’eo, ");
INSERT INTO tdx_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","naho tsy t’ie longo marine: ty rene’e ndra i rae’e, ty anadahi’e ndra ty anak’ ampela’e ndra ty rahalahi’e ");
INSERT INTO tdx_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ndra ty rahavave’e somondrara marine aze tsy amam-baly; ie ro azo anivam-batañe. ");
INSERT INTO tdx_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Tsy handeo-batañe re, ie talè añivo’ ondati’eo, haniva’e vatañe. ");
INSERT INTO tdx_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Tsy hanoe’ iareo peake ty añambone’ iareo le tsy ho harateñe ty indran-tanteahe’ iareo ndra hanoritory sandriñe. ");
INSERT INTO tdx_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Ie hiavake ho aman’ Añahare’e, naho tsy hiteratera ty tahinan’ Añahare’ iareo; f’ie ro mpañenga an’ afo am’ Iehovà ty mahakaman’ Añahare’ iareo, toe miavake iereo. ");
INSERT INTO tdx_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Tsy hangala-baly ami’ty kàrapilo ndra ami’ty maleotse iereo, le tsy hañenga rakemba narian-dahy; amy t’ie miavake aman’Añahare’e. ");
INSERT INTO tdx_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Aa le atokano, fa ie ty mpanjotso mahakama aman’ Añahare’o. Hiavake ama’o re, amy te masin-dRaho Iehovà, mpampiavake anahareo. ");
INSERT INTO tdx_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Ie manao hatsimirirañe ty anak’ ampelam-pisoroñe ro maniva an-drae’e, ho forototoeñe añ’afo. ");
INSERT INTO tdx_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","I mpisoroñe zoke’ o rahalahi’eoy, i nañiliñañe mena-pañorizañe añam­bone’e eo naho naambake hisikiñe o saroñeoy ro tsy handoly sabaka vaho tsy handriatse ty saro’e. ");
INSERT INTO tdx_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Tsy hiziliha’e ty aman-dolo, tsy hanivà’e sandriñe ndra t’ie rae’e ndra te rene’e; ");
INSERT INTO tdx_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","vaho tsy hienga i miavakey ndra haniva i toe-miava’ Nañahare’ey; fa ama’e i mena-pañorizañe nañavahañe aze aman’ Añahare’ey: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Somondrara ty hengae’e ho vali’e, ");
INSERT INTO tdx_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","tsy hengae’e ty vantotse ndra ty nitseizeñe ndra ty ampela nileoreñe, ndra ty tsimirirañe; fa ty ampela tsy nahavanilahy boak’ amo longo’eo ty hengae’e ");
INSERT INTO tdx_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","tsy mone haniva o tarira’eo amo longo’eo; Izaho Iehovà Mpampiavak’ aze. ");
INSERT INTO tdx_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Le hoe ty nitsarae’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Saontsio amy Aharone ty hoe: Tsy mahazo miharine hañenga ty maha­kaman’ Añahare’e ty tiri’o aman-kandra amo tarira’o mifandimbeo. ");
INSERT INTO tdx_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Le tsy mahazo mitotoke mb’eo t’indaty aman-kandra: ke te fey, he te kepeke, he aman-kandran-tarehe, ke kombimba, ");
INSERT INTO tdx_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ke te ondaty fola-pandia, he fola-pitàñe, ");
INSERT INTO tdx_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ke langa, he kana, ke aman-kandram-pihaino, he aman-kàteñe, ke hezam-bae, hera aman-tabiry dinemoke. ");
INSERT INTO tdx_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Aa le tsy hiharivo hañenga soroñe am’ Iehovà ze ondaty aman-kandra amo tarira’ i Aharone mpisoroñeo. Ie aman-kandra, ro tsy hañarine hañenga o mahakaman’ Añahare’eo. ");
INSERT INTO tdx_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Mete ikama’e ty mahakaman’ Añahare’e: o miava-do’eo naho o miavakeo. ");
INSERT INTO tdx_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","F’ie tsy hizilik’ amy lamba fañefe­tsey ndra hiharine i kitreliy, ty amy hàndra’ey; tsy mone ho tivae’e i toeko miavakey; amy te Izaho Iehovà Mpampiavak’ iareo. ");
INSERT INTO tdx_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Aa le nitaroñe’ i Mosè amy Aharone naho amo ana’eo vaho amo hene ana’ Israeleo izay. ");
INSERT INTO tdx_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Saontsio amy Aharone naho amo ana’eo ty hidare soa o enga avì’ o ana’ Israeleo tsy mone ho tivae’ iereo ty añarako masiñe amo raha avì’ iareo ho amakoo; Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ano ty hoe am’ iereo: Naho amy ze hene tarira’areo mifandimbe ty mitotok’ ami’ty enga miavake navì’ o ana’ Israeleo am’ Iehovà ie mbe aman-kaleorañe, le haitoañe tsy hiatrek’ ahiko indatiy: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Tsy hikama amo enga miavakeo ze tarira’ i Aharone voa’ ty angamae ndra miori-tsiranoke ampara’ t’ie malio. Ze mitsapa ndra iaia nileore’ ty lolo, ndra t’indaty iakaran-drom-pilahia, ");
INSERT INTO tdx_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ndra ze ‘ndaty mitsapa raha mifamorohotse mete handeotse aze ndra ze ondaty mete handeotse aze, amy ze haleorañe ama’e, ");
INSERT INTO tdx_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","le haleotse ampara’ te hariva indaty nitsapa zaiy le tsy ho kamae’e o raha miavakeo naho tsy miandro aman-drano hey. ");
INSERT INTO tdx_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ie tsofots’ àndro le halio re vaho azo’e kamaeñe o enga miavakeo, fa toe mahakama’e. ");
INSERT INTO tdx_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Tsy ho kamae’e ty raha mate a montoñe añe ndra ty nirimitem-biby amy te maleotse: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Aa le hambena’ iareo o nafantokoo tsy mone hivave hakeo vaho hikoromake kanao nitivañe: Izaho i Iehovà mpampiavak’ iareo. ");
INSERT INTO tdx_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Tsy hikama amo miavakeo o bori­zàñeo; le sambe tsy hikama amo miavakeo ty mpifondro amy mpisoroñey, naho ty mpitoroñe tambezañe. ");
INSERT INTO tdx_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Fe mete mikama ao t’indaty vinili’ i mpisoroñey an-drala, vaho mahazo mikama amy mahakama’ey o nasamak’ añ’anjomba’eo. ");
INSERT INTO tdx_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Naho tañanjomba’ t’indaty tsotra ty anak’ ampelam-pisoroñe le tsy hikama’e o navik’ amo raha miavakeoo. ");
INSERT INTO tdx_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Fe naho ramavoiñe ndra narian-dahy i anak’ ampelam-pisoroñey naho tsy manañ’ anake vaho mimpoly añ’ anjomban-drae’e ao manahake t’ie nitora’e, le hikama amy maha­kaman-drae’ey. Fe tsy ho kamae’ ty tsotra. ");
INSERT INTO tdx_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Aa naho ikama’ t’indaty tsy satrie’e o enga miavakeo, le hitovoña’e ty ampaha-lime’e vaho hatolo’e amy mpisoroñey rekets’ i raha miavakey. ");
INSERT INTO tdx_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Asoao tsy ho tivà’ iareo ze enga’ miava’ o ana’ Israeleo engae’ iareo am’ Iehovà ");
INSERT INTO tdx_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","tsy mone hivave hakeo hampañengañe engan-dilatse amy fikama’ iareo o raha miava’ iareoo: amy te Izaho Iehovà Mpampiavak’ iareo. ");
INSERT INTO tdx_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Le hoe ty nitsarae’Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Saontsio amy Aharone naho amo ana’eo naho amy ze hene ana’ Israele ty hoe: Ze ondaty amy anjomba’ Israeley ndra amo renetane mpimoneñe e Israeleo minday ty hengae’e, ke amo nifantà’eo, he amo engan-tsatrin’ trokeo ty ho banabanae’ iereo am’ Iehovà hisoroñañe, ");
INSERT INTO tdx_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","soa t’ie ho no’e, le lahi’e tsy aman-kandra, ke amo añombeo ke amo añondrio he amo oseo. ");
INSERT INTO tdx_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Le tsy hengae’ areo ndra inoñ’ inoñe aman-kandra; fa tsy ho no’e ho anahareo. ");
INSERT INTO tdx_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Aa naho mañenga engam-pañanintsiñe am’Iehovà t’indaty, ke hibanabana ava-panta ke engan-tsatrie’e, he boak’ amo mpirai-trokeo ke amo mpirai-liao, le tsy ho aman-kandra t’ie ho no’e, vaho tsy ho aman-kila. ");
INSERT INTO tdx_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Aa ke te goa, he folake, ke mikotraitse, he ampàre, ke mandramboñe, hera aman-kezam-bae—le tsy hengaeñe am’ Iehovà vaho tsy ho soroñañe am’ Iehovà amy kitreliy. ");
INSERT INTO tdx_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Ke aman-kamba, he aman-tsihotse ty añombe ndra ty añondry le mete engaeñe ho engan-tsatrin’ arofo, fe tsy ho no’e t’ie am-panta. ");
INSERT INTO tdx_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Tsy hengaeñe am’ Iehovà ka ze vondròkoke ndra demoke ndra riatse ndra linily; tsy hanoe’ areo an-tane’ areo ka izay. ");
INSERT INTO tdx_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Le ko apo’ areo t’ie ho banabanaem-pità’ o anan-drenetaneo ho mahakaman’ Añahare’ areo, kanao ama’e ty hìla’e, ndra ama’e ty handra’e, fa tsy ho no’e ho anahareo. ");
INSERT INTO tdx_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Le hoe ty nitsarae’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Ie terake ty añombe ndra añondry ndra ose le ho fito andro amy rene’ey hey, ie mifototse amy andro faha­valoy ro mete engaeñe hisoroñañe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Aa naho añombe vave ndra añondry vave, le ko songa lentaeñe ami’ty andro raike, ie naho ty ana’e. ");
INSERT INTO tdx_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Ie misoroñe engam-pañandriañañe am’ Iehovà, mañengà ty ho no’e, ");
INSERT INTO tdx_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","le ikamao amy àndro zay, vaho tsy anisañe ho ami’ty maraiñe: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Asoao hambena’ areo o lili­koo, vaho anoeñe; Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Tsy ho tivae’ areo i añarako masiñey, fa havahe’ o ana’ Israeleo: Izaho Iehovà Mpampiavak’ anahareo, ");
INSERT INTO tdx_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","nañakatse anahareo an-tane Mitsraimey, ho Andrianañahare’ areo: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Hoe ty nitsara’Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","misaontsia amo ana’ Israeleo naho itaroño ty hoe: Ho koihe’ areo o fañoharañe miava’ Iehovào, famantañañe miavake, Inao o andro namotoañakoo. ");
INSERT INTO tdx_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Eneñ’ andro ty fitoloñan-draha; le Sabotse fitofàñe ty andro fahafito, fitontoñañe miavake. Tsy hitoloña’ areo, fa Sabata am’ Iehovà amo fitobea’ areo iabio. ");
INSERT INTO tdx_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Inao o famantàña’ Iehovào, fañoharañe miavake ho koihe’ areo an-tsa’e tinendre. ");
INSERT INTO tdx_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Ami’ty andro faha folo-efats’ ambi’ i volam-baloha’ey, ie miroñe ty andro le engam-pihelañ’ ambone’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Amy andro faha folo-lime-ambi’ i volañeiy ty sabadidak’ i mofo tsi-aman-dalivay am’ Iehovày; fito andro ty hikama’ areo mofo po-dalivay. ");
INSERT INTO tdx_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Hanoe’ areo fañoharañe miavake amy andro valoha’ey; le tsy hitolon-draha. ");
INSERT INTO tdx_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Fito andro ty hañenga’ areo soroñe am’ Iehovà. Le Fañòharañe Miavake ty andro faha-fito, tsy itoloñan-draha. ");
INSERT INTO tdx_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Saontsio amo ana’ Israeleo ty hoe: Ie mizilik’ an-tane hitolorako, vaho manonton-tsabo, le hindesa’ areo mb’ amy mpisoroñey mb’eo ty lengom-bora’ i fanataha’ areoy. ");
INSERT INTO tdx_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Le hahela­hela’e añatrefa’ Iehovà i lohavoay soa te ho no’e; amy loak’ andro’ i Sabataiy ty añelahelà’ i mpisoroñey aze. ");
INSERT INTO tdx_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Le hengae’o amy andro añelahelà’o i bora’eiy ty vik’ añondrilahy tsy aman-kandra, ho soroñañe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Zao ty ho enga-maha­kama’e: ty mona fahafolo’ ty efà roe linaro menake, ho soroñañe am’ Iehovà ho hàñim-pañanintsiñe; divay ty ho enga-rano mpindre ama’e, fahèfa’ ty hine. ");
INSERT INTO tdx_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Tsy hikama mofo ndra tsako natono ndra tsako-le nahareo ampara’ i andro zay, ampara’ ty añenga’ areo aman’ Añahare’ areo i engay; ho fañè nainai’e amo tarira’ areoo amo hene fitobea’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Mifototse amy loak’andro’ i Sabotsey, i andro nindesa’ areo i loha-voan’ engan-kelahelaiy ty hañiaha’ areo Sabotse fonitse fito. ");
INSERT INTO tdx_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Añiaho andro limampolo pak’amy loak’andro’ i Sabata fahafitoy; le añengao lengom-boa am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Hendeseñe boak’ añ’ akiba’ areo ao ty mofon-kelahela roe songa nanoeñe ami’ty mona fahafolo’ ty efà roe; natoñak’ an-dalivay ho engam-boa am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Le tovo’ i mofoy añengao vik’ añondry fito tsy aman-kandra, ty bania, naho ty añondri­lahy roe, ho enga soroñeñe am’ Iehovà rekets’ o enga-mahakama’ iareoo naho o enga rano’ iareoo, hisoroñañe ho hàñim-pañanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Le hengae’ areo ty vik’ oselahy ho engan-kakeo naho ty vik’ añondry roe hisoroñañe ho engam-pañanintsiñe. ");
INSERT INTO tdx_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Hahelahela’ i mpisoroñey, ie naho i mofo lengom-boay ho engan-kelahela añatrefa’ Iehovà, vaho i vik’ añondry roe rey; hene avahe’ Iehovà ho a i mpisoroñey. ");
INSERT INTO tdx_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Le ho koihe’areo amy andro izay ty fifanontoñañe miavake, tsy itoloñan-draha. Ho fañè nainai’e amo fitobea’ areo iabio izay amo hene tarira’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Aa ie manonton-tsabo an-tane’ areo ao, ko mitatake pak’ añ’ olo-teteke ey, le ko manontoñe ze nipopok’ amy fitatahañey; apoho ho a o rarakeo naho o ambahinio; Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Saontsio ty hoe amo ana’Israeleo: I volam-pahafitoy, i androm-baloha’ i volañeiy, le ho Fitofàm-bey ho anahareo, fampitiahiañe am-pitiofan-kankàñe naho fifanontoñañe miavake. ");
INSERT INTO tdx_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Tsy hitolon-draha ama’e nahareo; fe hañenga soroñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Ho tondrok’ amy andro fahafolo’ i volam-paha-fitoy ty androm-pijebañañe, fifanontoñañe miavake ho anahareo: mili­era vatañe vaho mañengà soroñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Ko mitoloñe amy andro zay, amy te androm-pijebañañe, hijebañe anahareo añatrefa’ Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Haitoañe am’ondati’eo ze tsy milie-batañe amy andro zay. ");
INSERT INTO tdx_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Aa ndra iaia t’indaty mitoloñe ndra inoñ’ino amy andro zay le Izaho ty handrotsake indatiy am’ ondati’eo. ");
INSERT INTO tdx_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Toe tsy hanao ndra inoñe atao fitoloñañe amy andro zay nahareo, ie fañè tsy ho modo amo tarira’ areoo, amo hene fitobea’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Ho Sabata fitofàñe añoñe ama’ areo izay le hilie-batañe ama’e nahareo—ty hariva’ i andro fahasive’ i volañeiy; i harivay pak’ ami’ty hariva ty hañambena’ areo i Fitofà’ areoy. ");
INSERT INTO tdx_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Le hoe ty nitsarae’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Saontsio amo ana’ Israeleo ty hoe: Amy andro fahafolo-lime ambi’ i volam-paha­fitoiy ty sabadida-kibohotse am’ Iehovà, ho fito andro. ");
INSERT INTO tdx_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Fitontoñañe miavake i andro valoha’ey. Tsy hitoloñe ndra inoñ’ inoñe atao asa nahareo. ");
INSERT INTO tdx_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Fito andro t’ie hañenga soroñe am’ Iehovà. Amy andro fahavaloy ty hanoa’ areo fitontoñañe miavake vaho hañenga soroñe am’ Iehovà. Sabadidake bey izay le tsy hitoloñ’ ama’e nahareo. ");
INSERT INTO tdx_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Famantaña’ Iehovà irezay, ikoiha’ areo ho fitontoñañe miavake, hañengañe soroñe am’ Iehovà: enga oroañe naho enga mahakama, soroñe naho enga rano, songa ami’ty andro’e, ");
INSERT INTO tdx_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ho tovo’ o Sabotse’ Iehovào, naho o fañenga’ areoo, naho ze hene enga’ areo am-panta naho an-tsatrin’ arofo ho banabanae’ areo am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Aa ie amy andro fahafolo-lime ambi’ i volam-pahafitoy, ie fa natonto’ areo ty voka’ i taney, le hambena’areo i sabadidak’ Iehovày fito andro; fitofàñe ty andro valoha’e vaho fitofàñe ty andro faha-valo. ");
INSERT INTO tdx_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Ie amy andro valoha’ey ro hitoha ran-katae reke-boa’e amo hatae fanjakao naho ran-tsatrañe naho iratse mandrevake naho ran-tsohihy añ’ olon-drano ey; vaho hirebeke añatrefa’ Iehovà Andria­nañahare’ areo fito andro. ");
INSERT INTO tdx_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Hambena’ areo i Sabadidake am’ Iehovày fito andro boa-taoñe, ho fañè nainai’e amo tarira’ areoo, hitsinjaha’ areo amy volam-pahafitoy. ");
INSERT INTO tdx_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Hitobe an-kibohotse fito andro naha­reo; ze nisamaheñe e Israele ao iaby ty hañialo an-tsokemitrahañ’ ao, ");
INSERT INTO tdx_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","hahafohina’ o tarira’ areoo te nampitobèko an-kibohotse ao o ana’ Israeleo ie nampiavoteko an-tane Mitsraime añe: Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Aa le tinaro’ i Mosè amo ana’ Israeleo o famantaña’ Iehovào. ");
INSERT INTO tdx_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Hoe ty nitsara’Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Lilio amo ana’ Israeleo ty hindesa’iareo ama’o ty menake olive ki’e nipineheñe ho amo jiroo hireheta’ i jiro rey nainai’e. ");
INSERT INTO tdx_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Hajarie’ i Aharone amy kibohom-pamantañañey alafe’ i lamba fañefe’ i fañinaiy izay te hariva ampara’ te porea’ ty maraindray añatrefa’ Iehovà nainai’e; fañè tsy ho modo ama’ areo izay amo hene tarira’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Hampiririte’e amy fitàn-jiro volamena ki’ey boak’ andro o jiro añatrefa’ Iehovào. ");
INSERT INTO tdx_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Le hangala’o mona hanoñafa’o vonga-mofo folo ro’ amby; songa fahafolo’ ty efà roe i mofo rey. ");
INSERT INTO tdx_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Hampi­famala­ha­ñe’o roe, eneñe naho eneñe ty firirita’e, amy rairay malio añatrefa’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Le hasia’o emboke ki’e o firirita’eo ho tiahy hasolo o mofoo, enga horoañe añ’ afo am’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Boak’andro Sabotse ro fandaharañe irezay añatrefa’ Iehovà ho fañè nainai’e amo ana’Israeleo. ");
INSERT INTO tdx_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Ho a i Aharone naho o tarira’eo, ho kamae’ iareo an-toetse miavake ao; fa miava-do’e ama’e amo fisoroñañe am’ ­Iehovào; ie aze am-pañè tsy ho modo. ");
INSERT INTO tdx_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Ie henane zay niakatse mb’amo ana’ Israeleo mb’eo ty lahilahy; ana’ Israele ty rene’e naho nte-Mitsraime ty rae’e, nifandrapak’ ami’ty ana’ Israele an-tobe ao. ");
INSERT INTO tdx_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Niteratera i Tahinañey ty ana’ i rakemba ana’ Israeley, naho namàtse, vaho nasese mb’amy Mosè mb’eo; Selomite, ana’ i Dibry, fifokoa’ i Dane, ty tahinan-drene’e; ");
INSERT INTO tdx_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","aa le najo am-pandrohizañe ao hey re handrendreha’ iareo ty safiri’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Le hoe ty nitsarae’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Aseseo alafe’ i tobey re; le manampe fitàñe ama’e ze hene nahajanjiñe aze vaho ho retsahe’ i valobohòkey vato. ");
INSERT INTO tdx_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Aa le saon­tsio ty hoe o ana’ Israeleo: Ze mitera­tera an’ Andrianañahare’e ro hivave i tahi’ey. ");
INSERT INTO tdx_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Toe havetrake ze miteratera ty tahina’ Iehovà. Ho retsahe’ i valobohòke iabiy vato i niterateray, ke te renetane he fokontokoñe, ho vonoeñe re kanao niteratera i tahinañey. ");
INSERT INTO tdx_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Havetrake ka ze mañe-doza ama’ ondaty. ");
INSERT INTO tdx_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Hañavake ze mamono hare, fiaiñe ty hasolo fiaiñe. ");
INSERT INTO tdx_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Ze mampanan-kandra t’indaty le i nanoe’ey ty hanoeñe ama’e; ");
INSERT INTO tdx_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","folake ty hasolo folake, fihaino ty fihaino, fihitsike ty fihitsike; hambañe ami’ty nijoia’e t’indaty ty hijoiañe aze. ");
INSERT INTO tdx_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Hañavake ty mamono hare, fe havetrake ty mamono ondaty. ");
INSERT INTO tdx_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Raike ty lili’ areo: hambañe ty a i renetaney naho ty a i fokontokoñey, amy te Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Aa le nisaontsie’ i Mosè amo ana’ Israeleo, le nasese’ iereo alafe’ i tobey i niterateray, vaho rinetsa’ iareo vato. Nanoe’ o ana’ Israeleo i nandilia’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Hoe ty nitsara’ Iehovà amy Mosè ambohi-Sinay añe: ");
INSERT INTO tdx_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Misaontsia amo ana’ Israeleo, le ano ty hoe: Ie mimoak’ an-tane hatoloko anahareo ao le hambena’ i taney ty fitofàñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Enen-taoñe ty hiton­gisa’o ami’ty tete’o, naho enen-taoñe ty hañetefa’o o valobo’oo vaho ty hanon­toña’o ty voka’e, ");
INSERT INTO tdx_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","fe ho Sabata àñom-pitofà’ i taney i taom-paha­fitoy, Sabata am’ Iehovà. Tsy hiton­gisa’o ty tete’o ndra hetefa’o o valobo’oo. ");
INSERT INTO tdx_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Tsy ho tataheñe o misonjoñeo naho fa afake ty fitataha’o, le tsy hatontoñe ze valoboke mitiry amo vahe tsy nañetefañeo, amy t’ie taom-pitofàñe heneke ho a i taney. ");
INSERT INTO tdx_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Fe ho fikama’ areo ty voka’ i fitofà’ i taneiy, ihe naho ty mpitoro’o lahy naho ty mpitoro’o ampela, naho ty mpièke, naho ty renetane mañialo ama’o, ");
INSERT INTO tdx_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","vaho hihinana’ o hare’oo naho ze biby lý an-tane’o ao ze hene voka’e. ");
INSERT INTO tdx_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Mañiaha taom-pitofàñe fito ho azo, fito taoñe atombo fito; le ty fitontoña’ i taom-pitofàñe fito rey ro mañomey efa-polo siv’amby taoñe. ");
INSERT INTO tdx_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Ie amy zay, ampipopoeñe antsiva-paniahiañe ty andro faha-folo’ i volam-pahafitoy, i andro fijebañañey, le ho tsitsihe’ areo fipopòn’ antsiva ty tane’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Le ampiambaho i taom-paha limampoloy naho tsitsiho koim-pidadàñe i taney, amo mpimoneñe ama’e iabio. Ho Jobily ama’ areo, sindre himpoly amo fanaña’eo, songa himpoly aman-dongo’e. ");
INSERT INTO tdx_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Jobily ho anahareo i taom-paha-limampoloy: tsy hitongy ama’e, le tsy ho tatahe’ areo ze sonjo’e vaho tsy hatonto’o ze am-bahe tsy hineteke, ");
INSERT INTO tdx_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","amy te Jobily, le hiavake ho anahareo izay; ho kamae’ areo ze mipike an-tetek’ ao. ");
INSERT INTO tdx_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Songa hibalik’ amy lova’ey amy taon-Jobiliy nahareo. ");
INSERT INTO tdx_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Aa ie mandetake inoñ’inoñe am’ on­datio ndra mikalo am-pità’ ondaty, le asoao tsy hifampikatramo. ");
INSERT INTO tdx_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ty ami’ ty ia’ o taoñe manonjohy i Jobilio ty ho vilie’o am’ondatio le ty ami’ty ia’ o taom-pamokarañe sisao ty handetaha’e. ");
INSERT INTO tdx_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Ty ami’ty hamaro’ o taoñeo ty hañonjona’o ty vili’e vaho ami’ty hatsiampe’ o taoñeo ty hampiketraha’o ty vili’e; ty ia’ o fitatahañeo ro haleta’e ama’o. ");
INSERT INTO tdx_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Aa le ko mifamorekeke, fa i Andria­nañahare’o ro hañeveña’o; Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Aa le ambeno o fañèkoo naho oriho aman-dili-po o fepèkoo, vaho hiaiñ’ añoleñañe amy taney nahareo, ");
INSERT INTO tdx_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","le ho toly ty sabo’ i taney naho ho anjam-pikamañe nahareo vaho himoneñe ao tsy aman’ ore. ");
INSERT INTO tdx_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Aa naho hanoa’areo ty hoe, Ino ty ho hane’ay amy taom-pahafitoy, zahay tsy hitongy, tsy hanontoñe an-driha? ");
INSERT INTO tdx_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Fa ho lilieko ho anahareo ty fanintsiñako amy taom-paha-eneñey, hanataha’ areo ty mahakama tsahatse telo taoñe. ");
INSERT INTO tdx_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Ie hitongy ami’ty taom-paha-valo, le ho kamae’ areo ty voka’e nivokats’ ela; pak’ amy taom-pahasivey, ampara’ i fitatahañe ama’ey, ty hikama’ areo i elay. ");
INSERT INTO tdx_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Tsy haletake ho nainai’e i taney amy te ahiko o taneo; mpañialo naho renetane amako nahareo. ");
INSERT INTO tdx_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Aa ty amo hene tanem-panaña’ areoo, añajào ty hijebañañe aze. ");
INSERT INTO tdx_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Ie mifotsak’ an-kararahañe ty longo’o naho mandetake i hanaña’ey, le homb’eo ty longo’e marine aze, hijebañe i tane na­letan-dongo’ey. ");
INSERT INTO tdx_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Aa naho tsy amam-pijebañe t’indaty, fe am-pahim­bañam-pità’e ro mahatontoñe ty hijebaña’e, ");
INSERT INTO tdx_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","le hiahe’e o taoñe mifototse amy nandetaha’e azeio, le havaha’e amy nivily azey ty tsi’ri’e amo tao’eo vaho hibalik’ amy fanaña’ey re. ");
INSERT INTO tdx_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Aa naho tsy lefe’e ty hañitia’e fitàñe hahaeneñe ty hampibalihañe aze le hidok’ am-pità’ i nikalo azey i naletakey ampara’ ty Taon-Jobily; havotsotse amy Jobiliy izay le himpolia’e i fanaña’ey. ");
INSERT INTO tdx_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Aa naho aleta’ t’indaty ty anjomba-pimoneñañe an-drova finahetse ao le azo’e jebañeñe i anjombay añate’ ty taoñe mifototse amy nandetahañe azey; taoñe raike do’e ty mete hijebañañe aze. ");
INSERT INTO tdx_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","F’ie tsy jebañe’e añate’ ty taoñe raike le mijadoñe ho fanaña’ i nikalo azey nainai’e pak’ añ’ afeafe’e i anjomba an-drova mifahetsey. Ie tsy havotsotse amo Jobilio. ");
INSERT INTO tdx_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Fe ty anjomba tsy mifahetse ro voli­li­eñe manahake o tetekeo: azo jebañeñe izay vaho havotsotse ami’ty Jobily. ");
INSERT INTO tdx_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Fe ty amo rova’ o nte-Levio, toe manan-jo nainai’e o nte-Levio hijebañe o anjomba an-drovam-panaña’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Aa naho mivily anjomba amo nte-Levio t’indaty, le i anjomba naletak’ an-drova ao ho vara’ey ro havotso’e amy Jobiliy; amy te fanaña’ i nte-Leviý añivo’ o ana’ Israeleo ze anjomba’e an-drova’ o nte-Levio. ");
INSERT INTO tdx_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Fe tsy azo aletake o tanem-piandrazañe mañohoke o rova’ iareoo, amy t’ie fanaña’ iareo nainai’e. ");
INSERT INTO tdx_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Aa naho mivariñ’ an-tsotry ty longo’o vaho moly ama’o, rambeso himoneñe ama’o manahake t’ie renetane ndra mpañialo. ");
INSERT INTO tdx_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ko angala’o anan-tsongo ndra ampandivà’o, fe añeveño t’i Andrianañahare’o, le angao himo­neña’e. ");
INSERT INTO tdx_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ko am­pi­songoen-drala hangala’o ana’e vaho ko ampanovoñe’o aze ze hanton-karo’e. ");
INSERT INTO tdx_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Izaho Iehovà Andrianañahare’ areo nañavotse anahareo an-tane Mitsraime añe hitolorako i tane Kanàney, vaho ho Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Aa naho mifotsak’ an-kasotriañe ty longo’o ama’o, hera havili’e ama’o ty fiai’e, ko ampitoroñe’o hoe ondevo. ");
INSERT INTO tdx_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Hoe mpikarama naho mpañialo ty hitraofa’e, hitoroñe ampara’ ty taon-Jobily; ");
INSERT INTO tdx_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ie amy zay ro hieng’ azo rekets’ o keleia’eo, him­poly mb’ aman-drolongo’e mb’eo, mb’am-pa­nañan-droae’e añe. ");
INSERT INTO tdx_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ahiko iereo, mpitoroko nampiavoteko an-tane Mitsraime añe; tsy haletake ho ondevo. ");
INSERT INTO tdx_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Ko silofe’o ami’ty famehea’o aze, fe añeveño t’i Andrianañahare’o. ");
INSERT INTO tdx_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Aa ty am’ ondevo lahilahy ndra ampela fanaña’oo; le boak’ amo fifeheañe mañohokeo ty ivilia’ areo ondevo. ");
INSERT INTO tdx_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Azo’ areo vilieñe ka ty anan-drenetane mañialo ama’ areo, naho amo hasavereña’ iareo nisamak’ an-tane’ areoo; mete ho fanaña’ areo ka iereo. ");
INSERT INTO tdx_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Azo’ areo ampandovaeñe amo ana’ areo mandimbeo ho fanaña’e, ho ondevo’ areo nainai’e. Fe o longo’ areo ana’ Israeleo, le tsy ho fehe’ ty raike ty raike am-pisengean-kery. ");
INSERT INTO tdx_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Aa naho miraorao ty renetane ndra ty mpañialo ama’o, le ie mivariñ’ an-tsotry ty longo’o marine aze vaho mandeta vatañe ke amy renetaney he amy mpañialo ama’oy, hera ami’ty tarira’ i ambahiniy, ");
INSERT INTO tdx_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","ie naletake ro mete jebañeñe. Hijebañe aze ty raik’ amo rahalahi’eo; ");
INSERT INTO tdx_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","mete hijebañ’aze ka i rahalahin-drae’ey ndra i ana-drahalahin-drae’ey; ndra ze amy fifokoa’ey ty hijebañe aze; he ie miraorao ro hahaava-piaiñe. ");
INSERT INTO tdx_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ty hifamolilia’e amy nivily azey, le boak’ amy taoñe nandetaha’e vatañey pak’amy Jobiliy; ty amo taoñeo ty vilin’ aim-pijebañañe aze; ampiraeñe ami’ty taom-pikarama i nitraofa’ey. ");
INSERT INTO tdx_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Ie mbe maro taoñe ty añe, le izay ty añavaha’e ty vilin’ ai’e amy drala nikaloañe azey; ");
INSERT INTO tdx_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ie tsy ampe ty taoñe pak’ amy taon-Jobiliy le inao ty hamoliliañe iareo roe: ty amo tao’eo ty añavahañe ty vilin’ai’e. ");
INSERT INTO tdx_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ho ama’e re manahake ty mpikarama mpitoloñe taoñ’ an-taoñe; tsy hisengean-kery am-pahaisaha’o. ");
INSERT INTO tdx_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Aa naho tsy jebañeñe amy hoe zay, mbe hienga avao amy taon-Jobiliy, ie rekets’ o keleia’eo. ");
INSERT INTO tdx_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ahiko o ana’ Israeleo; mpitoroko naka­reko an-tane Mitsraime añe: Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Ko mamboatse saren-drahare, ndra mampitroatse sare-sokitse ndra hazomanga, ndra mampipoke vato-lahy hiambaneañe an-tane’ areo; amy te Izaho ­Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ambeno o Sabatakoo le añeveño i toeko miavakey: Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Aa naho orihe’ areo o fañèkoo naho ambena’ areo o lilikoo, t’ie anoeñe, ");
INSERT INTO tdx_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","le hampahaviako orañe an-tsa’e le hampibodobodoe’ i taney ty voka’e vaho hiegoego o voan-katae an-kivokeo. ");
INSERT INTO tdx_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Hitakatse ty sam-panontoña’ areo ty sam-pamofohañe, naho ho ta­kare’ i fanontoñañey ty sam-pitongisañe; ho ànjañe mahakama nahareo vaho hiaiñañoleñañe an-tane’ areo ao. ");
INSERT INTO tdx_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Hampanintsiñeko i taney, ie handre tsy eo ty hañembañe; hafahako amy taney ze biby mpijoy, vaho tsy ho rangàem-pibara ty tane’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Ho horidañe’ areo o rafelahi’ areoo, le hampitsingoritrirem-pibara añatrefa’ areo eo. ");
INSERT INTO tdx_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Hañinjake zato ty lime ama’ areo naho haño­ridañe ty alen-dahy ty zato ama’ areo; hampitsingorom-pibara aolo’ areo o rafelahi’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ho toliheko, le hampibodobodoeko naho hañaretaheko; vaho hajadoko ama’ areo ty fañinako. ");
INSERT INTO tdx_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Ho kamae’ areo i nahaja elay le hakare’ areo i elay aolo’ i vaoy. ");
INSERT INTO tdx_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Hapoko añivo’ areo ao i kivohokoy le tsy ho falain-troko. ");
INSERT INTO tdx_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Hijelanjelañe ama’ areo ao iraho le ho Andrianañahare’ areo vaho hondatiko nahareo. ");
INSERT INTO tdx_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Izaho i Iehovà Andrianañahare’ areo ninday anahareo nienga an-tane Mitsraime añe tsy ho ondevo’ iareo; fa nipozaheko ty baon-joka’ areo vaho nampijaradoñeko. ");
INSERT INTO tdx_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","F’ie manjehatse ahiko, tsy miambeñe o hene liliko retoañe, ");
INSERT INTO tdx_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","naho sirikàe’ areo o fañèkoo, naho heje’ ty tro’ areo o fepèkoo, tsy ho henefe’ areo o fandiliakoo, fe mivalik’ amy fañinakoy, ");
INSERT INTO tdx_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","le inao ka ty hanoeko ama’ areo: Hanendreako feh’ ohatse; hike naho angorosy ty hampandò o fihaino’ areoo vaho hampitìke ty sandriñe. Tsy hanjofake ty tabiry ho tongise’ areo, fa habotse’ o rafelahi’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Hatreatrèn-daharako, ie ho zevoñeñe aolo’ o rafelahi’ areoo. Hifehea’ ty malaiñe anaha­reo naho hivoratsake ty lay ndra te tsy horidañeñe. ");
INSERT INTO tdx_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Ie amy zay, naho mbe tsy mañaoñe ahy ty am’irezay, le hatomboko im-pito ty fandilovako ty amo hakeo’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ho pozaheko ty engen-kaozara’ areo; le hanoeko viñe ty likera’ areo naho torisìke ty tane’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Le ho mokoreñe tsy vente’e ty hafatrara’ areo; naho tsy hahatoly sabo ty tane’ areo, vaho tsy hamoa o hatae an-taneo. ");
INSERT INTO tdx_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ie amy zay, naho mifandietse amako, tsy mete mijanjiñe, le hatomboko ama’ areo im-pito ty lafa ty amo tahi’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Hahitriko ama’ areo o bibin-kivokeo hitavañe amo ana’ areoo, naho hamono o hare’ areoo naho hadoñe tsy ampeampe nahareo vaho ho­ bangìñe o lalan-damo’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Aa ie mbe tsy mañaom-panoroañe amako amy rezay vaho mbe manjehatse ahy, ");
INSERT INTO tdx_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","le ho zehareko ka, naho ho fofoheko im-pito indraike ty amo fandilara’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Le hindesako fibaram-pamaleañe, hamaleako ty amy fañinay; ie mihipok’ an-drova’ areo ao, le hañirahako angorosy, vaho hasese am-pitàn-drafelahy. ");
INSERT INTO tdx_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Ie pozaheko ty mahakama fitoño’ areo le rakemba folo ty hanoñake ty mofo’ areo an-toñake raike, vaho hazotso’e an-danja’e i mahakay; hikama nahareo fa tsy ho anjañe. ");
INSERT INTO tdx_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Ie amy zay, naho mboe tsy hañaoñ’ ahy fe manjehatse avao, ");
INSERT INTO tdx_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","le izaho ka ty hanjehatse am-poroforo; Izaho, eka izaho, ty handilo anahareo im-pito ty amo sata-rati’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Ho kamae’ areo ty nofon’ ana-dahi’ areo, eka, ty nofon’ anak’ ampela’ areo ty ho hane’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Haro­tsako o toets’ abo’ areoo, ho firaeko o ajiba’ i àndroio, le havokovokoko amo lolo niatoa’areoo ty lolo’ areo, vaho halaim-bintañe anahareo ty troko. ");
INSERT INTO tdx_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Ho koàheko o rova’ areoo, le hampangoakoaheko o toe-miava’ areoo vaho tsy hantso­ñeko ty hamañi’ o embo-areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Hampanjarieko bangý i taney vaho ho latsa ty rafelahi’ areo mivotrak’ ao, ");
INSERT INTO tdx_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ie ampivarakaiheko amo fifeheañeo, naho hapontso­ako ama’ areo ty fibara; ho bangý ty tane’ areo vaho ho kòake o rova’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Izay vaho havahañe amy taney o fitofà’eo amo hene andro idoña’e ho kòakeo, ie an-tanen-drafelahy añe; eka hitofa i taney vaho havahañe ama’e o Sabata’eo. ");
INSERT INTO tdx_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Ie midòñe amy habangì’ey ro hitofa, i fitofañe tsy niazo’e amo Sabata’ iareooy, ie nimoneñe ama’e ao nahareo. ");
INSERT INTO tdx_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Aa ty amo sehanga’ areoo, le hañitrifako havakà ty añ’arofo’ iareo an-tanen-drafelahy añe kanao higoridañe anahareo ty feon-draven-katae mikatsa­katsàñe; ie hirimatse mb’eo hoe hinjahem-pibara le hikatràboke eo f’ie tsy amam-pañorìdañe. ");
INSERT INTO tdx_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Hifampihotrake iereo hoe aolom-pibara, t’ie tsy eo mpañoridañe, le ho po-kaozarañe tsy hahafijohañe añatrefa’ o rafelahi’ areoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Hikoromak’ amo kilakila ondatio añe nahareo vaho hagodra’ ty tanen-drafe­lahi’ areo. ");
INSERT INTO tdx_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Aa le hitìke an-tanen-drafelahi’ areo añe o hongaha’ areoo ty amo hakeo’ areoo; vaho o tahin-droae’ iareoo ty hitraofa’ iareo fimomoke. ");
INSERT INTO tdx_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Naho isolohoa’ iareo o hakeo’eo naho o tahin-droae’eo ty amo fandilara’ iareo nandilarañe amakoo naho ty fanjehara’ iareo; ");
INSERT INTO tdx_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ie nifankalaiñe am’iereo, nanese iareo an-tanen-drafelahy añe; fa naho hirèke o arofo’ iareo tsy sinava­tseo naho miantoke lilo ty amo hakeo’ iareoo, ");
INSERT INTO tdx_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","le ho tiahiko ty fañinako am’ Iakòbe naho i fañinako am’ Ietsàkey naho i fañinako amy Avrahamey vaho ho tiahiko i taney, ");
INSERT INTO tdx_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","i tane nifarie’ iareo ho bangiñey, hañavahañe o Sabata’eo ie màndre kòake ty am’iereo tsy ao, vaho hondrohañe am’iereo ty valen-kakeo, ty amy nanjehara’ iareo o lilikoo, naho nisirikae’ iareo o fepèkoo naho nihejen-tro’ iareo o fañèkoo. ");
INSERT INTO tdx_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Ndra te eo iaby izay, ie an-tanen-drafelahy ao, le tsy haforintseko tsy ho hejeko t’ie handrotsahako ho mongotse, hivalihako amy fañinako am’ iereoy, amy te Izaho Iehovà Andrianañahare’ iareo. ");
INSERT INTO tdx_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Le ho tiahiko ty ama’ iareo i fañinako aman-droae’ iareo t’ie nakareko an-tane Mitsraime añe am-pahaisaha’ o kilakila ondatioy, le ho Andrianañahare’ iareo; Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Ie o fañè naho fepètse naho fetse nanoe’ Iehovà añivo’e naho o ana’ Israeleo ambohi-Sinay añe am-pità’ i Mosèo. ");
INSERT INTO tdx_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Saontsio amo ana’ Israeleo ty hoe, Naho mitangèñe am’ Iehovà t’indaty, ty ami’ty fisafiria’o ho vilin’ai’ ondaty: ");
INSERT INTO tdx_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","le zao ty hamolilia’o ty lahilahy roapolo taoñe pak’ amy faha’ enem-polo taoñey, ho sekele limampolo volafoty amy sekelen-toe-miavakey ty hamolilia’o aze. ");
INSERT INTO tdx_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Naho rakemba, le ho telopolo sekele ty hamolilia’o aze; ");
INSERT INTO tdx_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","aa ie lime taoñe pake roapolo taoñe le sekele roapolo ty hamoliliañe ty lahilahy vaho sekele folo ty ampela; ");
INSERT INTO tdx_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ie vola’e raike pak’ami’ty halime tao’e, le amolilio sekele volafoty lime ty lahilahy vaho amolilio sekele volafoty telo ty ampela; ");
INSERT INTO tdx_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ie enem-polo taoñe mañambone, naho ondaty, le amolilio sekele folo-lim’ amby, vaho folo sekele ty rakemba. ");
INSERT INTO tdx_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ie rarake te amy namolilia’o azey, le hampiatrefeñe amy mpisoroñey, vaho hampitsatohe’ i mpisoroñey ty ava’e; ty fahahenefa’ i nifantày ty hamolilia’ i mpisoroñey. ");
INSERT INTO tdx_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Aa naho biby fañengà’ ondaty am’ Iehovà ty hengaeñe, le hiavake ze hene hare engae’ ondaty am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Tsy hovae’e, tsy hatsalo’e ty raty hasolo ty soa ndra ty soa ty raty; aa naho toe ampitsalohe’e biby ty biby le songa hiavake i raikey naho i solo’ey. ");
INSERT INTO tdx_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Aa naho biby tsy malio, ie tsy fisoroñañe am’ Iehovà, le hasese’e aolo’ i mpisoroñey; ");
INSERT INTO tdx_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","le ho volilie’ i mpisoroñey ty vili’e: ke t’ie soa he raty; ze amolilia’ i mpisoroñey aze, le izay ty ie. ");
INSERT INTO tdx_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","F’ie te hijebañe aze, le hatovo’e amy anjoanjo’e ty ampaha-lime’e. ");
INSERT INTO tdx_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Aa naho havahe’ t’indaty ty anjomba’e hampiavaha’e am’ Iehovà, le hampitsatohe’ i mpisoroñey ty vili’e, ke t’ie soa ke raty, ze amolilia’ i mpisoroñey aze ty hijadoñe. ");
INSERT INTO tdx_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Aa ie te hijebañe i anjomba navahe’ey, le tsy mahay tsy anovoña’e ty ampaha-lime’ i namoliliañe azey, vaho himpolia’e. ");
INSERT INTO tdx_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Aa naho añenga’ ondaty am’ Iehovà o tane fanaña’eo, le ho volilie’o amy tabiri’ey: hatao sekele volafoty limampolo ty homere’ tabirim-bare hordea. ");
INSERT INTO tdx_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Aa naho boak’ an-taon-Jobily ty añenga’ ondaty ty tane’e, le ty amolilia’o aze ty mijadoñe. ");
INSERT INTO tdx_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Aa ie añe i Jobiliy te añenga’ ondaty i tete’ey, le ho volilie’ i mpisoroñey ty vili’e amo taoñe tsy ri’e am-para’ i taon-Jobiliio le haketrake amy amolilia’oy. ");
INSERT INTO tdx_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Aa naho te hañavake i tane’ey i nañenga azey, le tsy mete tsy tovoña’e ty ampaha-limem-bili’e vaho hibalik’ ama’e. ");
INSERT INTO tdx_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Fa naho tsy hijebañe i tane’ey re, ke t’ie naletak’ ama’ ondaty, le tsy ho mete jebañeñe ka, ");
INSERT INTO tdx_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","f’ie votso­tse amy Jobiliy i tetekey, hiavake ho am’ Iehovà i taney ho tane miavake; le a’ i mpisoroñey izay ho fanaña’e. ");
INSERT INTO tdx_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Aa ie avi’e am’ Iehovà ty teteke vinili’e fa tsy ty tane linova’e, ");
INSERT INTO tdx_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","le ho volilie’ i mpisoroñey o taoñe tsy ri’e ampara’ ty Jobilio, ho vili’e, le hatolo’e amy àndro zay i vinolili’oy ho enga miavake am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Himpoly amy nikaloañ’ azey, toe amy mpandova i taneiy, i tetekey ami’ty taon-Jobily. ");
INSERT INTO tdx_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Fonga an-tsekele’ i toe-miavakey o famolilia’oo: gerà roapolo ty ho sekele raike. ");
INSERT INTO tdx_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Aa ty amo valohan’ anan-kàreo, a Iehovà izay kanao terake valohan’ anake, le tsy hengae’ ondaty; ke t’ie añombe hera añondry, a Iehovà. ");
INSERT INTO tdx_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Aa naho biby tsy malio, le ho jebañe’e amy namo­lilia’oy, vaho hitovoña’e ty ampaha-lime’e; naho tsy jebañeñe izay le haletak’ amy namolilia’oy. ");
INSERT INTO tdx_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Ie amy zao, tsy azo aletake o raha navìkeo, ze havì’ ondaty ho am’ Iehovà boak’ amy ze hene vara’e; ke ondaty he biby, ke tetek’ an-tane’e ao, le tsy mete aletake tsy mete jebañeñe; fa miava-do’e am’ Iehovà ze hene raha navìke. ");
INSERT INTO tdx_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Tsy mete jebañeñe t’indaty navaheñe, fa nafatse ho vonoeñe, le toe havetrake. ");
INSERT INTO tdx_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","A Iehovà ze hene faha-folo’ i taney, ke ty tabiri’ i taney, ke ty voan-­katae; miavake ho am’ Iehovà izay; ");
INSERT INTO tdx_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","aa naho te hijebañe i faha-folo’ey t’indaty, le hatovo’e ama’e ty ampaha-lime’e. ");
INSERT INTO tdx_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Ze fahafolo’ o añombeo ndra o mpirai-liao, ze miranga ambane’ i kobaiy, le songa miavake ho am’ Iehovà i faha-folo’ey. ");
INSERT INTO tdx_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Tsy ho darè’e ke soa he raty, tsy ho soloa’e; ie soloa’e le songa hiavake i solo’ey naho i sinoloy fa tsy mete jebañeñe. ");
INSERT INTO tdx_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","I lily rezay ro nandilia’ ­Iehovà amy Mosè ambohi-Sinay añe ho a o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ty tsara’ Iehovà amy Mosè an-dratraratra’ i Sinay añe, amy kibohom-pamantañañey ao, am-baloham-bolam-paharoe’ i taom-paharoe niavota’ iareo an-tane Mitsraimey, ami’ty hoe, ");
INSERT INTO tdx_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Tsitsiho vali-boke i valobohòn’ ana’ Israeley, amo fifokoa’ iareoo, naho amo anjomban-droae’eo hamoliliañe o tahina’eo, ze hene lahilahy ki-loha’e ki-loha’e, ");
INSERT INTO tdx_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","roapolo taoñe mañambone mahafionjo hialy ho a Israele. Ihe naho i Aharone ty hañiake iareo ty amo mpirai-lian-defo’eo. ");
INSERT INTO tdx_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Le hindre ama’ areo t’indaty boak’ amy ze hene fifokoa’e, songa talèn’ anjom­ban-droae’e. ");
INSERT INTO tdx_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Le zao ty tahina’ ondaty hifanehak’ ama’ areo: amy Reòbene: i Elitsore ana’ i Sedeore; ");
INSERT INTO tdx_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","amy Simone, i Selomiele ana’ i Tsorisaday; ");
INSERT INTO tdx_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","am’ Iehodà: i Nakesone ana’ i Aminadabe; ");
INSERT INTO tdx_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","am’ Isakàre: i Netanale ana’ i Tsoare; ");
INSERT INTO tdx_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","amy Zebolone: i Eliabe ana’ i Kelone; ");
INSERT INTO tdx_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","amy ana’ Iosefe rey: amy Efraime, i Elisama ana’ i Amihode; amy Menasè, i Gamaliele ana’ i Pedatsore; ");
INSERT INTO tdx_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","amy Beniamène, i Abidane ana’ i Gedoný; ");
INSERT INTO tdx_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","amy Dane: i Akièzere, ana’ i Amisedahy; ");
INSERT INTO tdx_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","amy Asere: i Pejiele ana’i Okrane; ");
INSERT INTO tdx_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","amy Gade: i Eliasafe ana’ i Dehoele; ");
INSERT INTO tdx_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","amy Naftaly, i Akirà ana’ i Ainane; ");
INSERT INTO tdx_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Ie ro jinoboñe amy valobohòkey, ie mpiaolo o fifokoan-droae’eo, mpifelek’ arivo’ Israele. ");
INSERT INTO tdx_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Aa le rinambe’ i Mosè naho i Aharone indaty tinoñon-tahinañe rey, ");
INSERT INTO tdx_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","naho natonto’ iareo i hene valobohòkey ami’ty andro valoha’ i volam-paharoey vaho niantoñoñe an-tariratse añ’ anjomban-droae’e, naho nisokiran-tahinañe vaho nivolileñe mifototse ami’ty roapolo taoñe mañambone, ki-loha ki-loha, ");
INSERT INTO tdx_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","ami’ty nandilia’ Iehovà amy Mosè ty nanoe’e valiboke an-dratraratra’ i Sinay añe. ");
INSERT INTO tdx_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Le amo tarira’ i Reòbene tañolo­ño­loña’ Israeleo, ty fiantoño’e, amo fifokoa’eo, amo anjomban-droae’eo, ty ia’ o tahina’eo, ze lahilahy ki-loha ki-loha, niaheñe roapolo taoñe mañambone, ze hene nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ty vinolily am-pifokoa’ i Reòbene, efats’ ale tsi-eneñ’ arivo-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Amo tarira’ i Simoneo, ty fiantoño’e amo fifokoa’eo, amo anjomban-droae’eo, ze niaheñe ama’e ty ia’ o tahina’eo, ze lahilahy ami’ty añambone’e roapolo taoñe mañambone, ze nahafionjom-bañ’ aly iaby; ");
INSERT INTO tdx_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ty vinolily am-pifokoa’ i Simone: lime ale-tsi-sive-arivo-tsi-telon-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Amo tarira’ i Gadeo, ty fiantoño’e amo fifokoa’eo amo anjomban-droae’eo ty ia’ o tahina’eo, ze lahilahy ami’ty añambone’e roapolo taoñe mañambone, ze hene nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ty vinolily am-pifokoa’ i Gade, efats’ ale-tsi-lime-arivo-tsi-enen-jato-tsi-limampolo. ");
INSERT INTO tdx_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Amo tarira’ Iehodào, ty fiantoño’e, amo fifokoa’eo amo anjom­ban-droae’eo ty ia’ o tahina’eo, ze roapolo taoñe mañambone, ze hene nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ty vinolily am-pifokoa’ Iehodà, fito-ale-tsi-efats’ arivo-tsi-enen-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Amo tarira’ Isakàreo, ty fiantoño’e, amo fifokoa’eo amo anjom­ban-droae’eo ty ia’ o tahina’eo, ze roapolo taoñe mañambone, ze hene nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ty vinolily am-pifokoa’ Isakhare, le lime-ale-tsi-efats’ arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Amo tarira’ i Zeboloneo ty fian­toño’e, am-pifokoa’e, amo anjom­ban-droae’eo, ty ia’ o tahina’eo, ze roapolo taoñe mañambone, ze hene nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ty vinolily am-pifokoa’i Zebolone, lime-ale-tsi-fito-arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Amo tarira’ Iosefeo, amo ana’ i Efraimeo, ty fiantoño’e, amo fifokoa’eo, amo anjomban-droae’eo ty ia’ o tahina’eo, ze roapolo taoñe mañambone nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ty vinolily am-pifokoa’ i Efraime le efats’ ale-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Amo tarira’i Menaseo, ty fiantoño’e, amo fifokoa’eo amo anjomban-droae’eo ty ia’ o tahina’eo, ze roapolo taoñe mañambone, ze nahafionjom-bañ’ aly iaby; ");
INSERT INTO tdx_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ty vinolily am-pifokoa’i Menasè, telo-ale-tsi-ro-arivo-tsi-roan-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Amo tarira’i Beniamèneo, ty fiantoño’e, am-pifokoa’e, amo anjomban-droae’eo, ty ia’ o tahina’eo, ze roapolo taoñe mañambone, ze hene nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ty vinolily am-pifokoa’ i Beniamène, telo-ale-tsi-lime-arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Amo tarira’ i Daneo, ty fian­toño’e, am-pifokoa’e amo anjom­ban-droae’eo ty ia’ o tahina’eo, ze roapolo taoñe mañambone, ze hene nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ze vinolily am-pifokoa’ i Dane ao le eneñ’ ale-tsi-ro-arivo-tsi-fiton-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Amo tarira’ i Asereo, ty fian­toño’e, am-pifokoa’e amo an­jom­ban-droae’eo ty ia’ o tahina’eo, ze roapolo taoñe mañambone, ze hene nahafionjom-bañ’ aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ze vinolily am-pifokoa’ i Asere, efats’ale-tsi-arivo-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Amo tarira’ i Naftalio, ty fiantoño’e, ampifokoa’e amo anjomban-droae’eo ty ia’ o tahina’eo, ze roapolo taoñe mañambone, ze hene nahafionjom-bañ’aly; ");
INSERT INTO tdx_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ze vinolily am-pifokoa’ i Naftaly, lime-ale-tsi-telo-arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Ie o vinolilio, o niahe’ i Mosè naho i Aharone, naho o mpiaolo’ Israeleoo, ondaty folo ro’ amby, songa sorotàn’ anjomban-droae’e. ");
INSERT INTO tdx_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Aa le ze niaheñe amo ana’ Israeleo, amo anjomban-droae’eo, ie niroapolo taoñe mañambone, o nahafionjom-bañ’aly ho a Israeleo; ");
INSERT INTO tdx_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ze hene vinolily, le enen-ketse-tsi-telo arivo-tsi-liman-jato-tsi-limampolo. ");
INSERT INTO tdx_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Tsy niaheñe am’ iereo ami’ty fifokoan-droae’ iareo o nte-Levio. ");
INSERT INTO tdx_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Fa hoe ty nitsarae’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Ko iahe’o ty fifokoa’ i Levy, le tsy ho volilie’o amo ana’ Israeleo, ");
INSERT INTO tdx_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","f’ie ho tendrè’o amy kibohom-pañinay, amo harao’e iabio naho amy ze he’e ama’e, hitarazo i kivohoy naho o harao’e iabio; ho vandroñe’ iereo vaho hitobe hiarikoboñe aze. ");
INSERT INTO tdx_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Aa ie hionjom-beo i kivohoy le o nte-Levio ro hampikatrak’ aze; ie haoreñe ka i kivohoy le o nte-Levio ty hampitroatse aze. Havetrake t’indaty ila’e mañarivo ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Hañoreñe o kiboho’ iareoo o ana’ Israeleo songa an-kitòbe’e; sindre aman-tsai’e, amo mpirai-lia’eo; ");
INSERT INTO tdx_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","fe hitobe añariari’ i kibohom-pañinay o nte-Levio, tsy hifetsahan-kaviñerañe i valobohò’ Israeley; le ho mpamandroñe i kibohom-pañinay o nte-Levio. ");
INSERT INTO tdx_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Nanoe’ o ana’ Israeleo izay; ze hene nandilia’ Iehovà i Mosè ty nanoe’ iereo. ");
INSERT INTO tdx_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Hoe ty nitsara’ Iehovà amy Mosè naho i Aharone: ");
INSERT INTO tdx_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","songa hitobe am-pijadoña’ i sai’ey marine’ ty vilon-droae’e o ana’ Israeleo. Añ’ariari’ i kibohom-pamantañañey ty hitobea’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Atiñana’e, mb’ am-panjiriha’ i àndroy, ty hitobea’ o mpañonjoñe ty sai’ Iehodào amo mpirai-lia’eo; i Naksone, ana’i Aminadabe ty mpiaolo’ o ana’ Iehodao. ");
INSERT INTO tdx_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Ty mpirai-lia’e, o niaheñe ama’eo, le fito-ale-tsi-efats’ arivo-tsi-enen-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Hanonjohy toetse ama’e ty fifokoa’ Isakhare; i Netanela ana’ i Tsoare ty mpiaolo’ o ana’ Isakhareo. ");
INSERT INTO tdx_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Ty mpirai-lia’e, o niaheñe ama’eo, le lime ale-tsi-efats’ arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Le ty fifokoa’ i Zebolone; Eliabe ana’ i Kelone ty mpiaolo’ o ana’ i Zeboloneo; ");
INSERT INTO tdx_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ty mpirai-lia’e, o niaheñe ama’eo, le lime-ale-tsi-fito-arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","O vinolily an-tobe’ Iehodao nitontoñe ho rai-hetse-tsi-valo-ale-tsi-eneñ’ arivo-tsi-efa-jato amo mpirai-lia’eo; hionjoñe valoha’e iereo. ");
INSERT INTO tdx_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Ami’ty ila’e atimo ty hijadoña’ ty sain-tobe’ i Reòbene ty amo mpirai-lia’eo; i Elitsore ana’ i Sedeore ty mpiaolo’ o ana’ i Reòbeneo. ");
INSERT INTO tdx_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ty mpirai-lia’e, o niaheñe ama’eo, le efats’ ale-tsi-eneñ’ arivo-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Ty fifokoa’i Simone ty hitobe marine iareo; i Semoliale ana’ i Tsorisadahy ty mpiaolo’ o ana’ i Simoneo. ");
INSERT INTO tdx_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Ty mpirai-lia’e, o niaheñe ama’eo, le lime-ale-tsi-sive-arivo-tsi-telon-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Manonjohy iereo ty fifokoa’ i Gade, i Eliasafe ana’ i Rehoele ty mpiaolo’ o ana’ i Gadeo. ");
INSERT INTO tdx_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ty mpirai-lia’e, o niaheñe ama’eo le efats’ ale-tsi-lime-arivo-tsi-enen-jato-tsi-limampolo. ");
INSERT INTO tdx_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","O vinolily an-tobe’ i Reòbeneio le rai-hetse-tsi-lime-ale-tsi-arivo-tsi-efa-jato-tsi-limampolo amo mpirai-lia’eo; faharoe te mienga iereo. ");
INSERT INTO tdx_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Hionjoñe amy zao i kibohom-pamantañañey mindre amo kitoben-te-Levio, añivo’ o kitobeo; le amo fitobea’eo ty hiavota’ iareo, songa ondaty ami’ty filahara’e ty amo sai’eo. ");
INSERT INTO tdx_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Añ’ila’e ahandrefañe ty hijadoña’ ty sain-tobe’ i Efraime ty amo mpirai-lia’eo, i Elisama ana’ i Amihode ty mpiaolo’ o ana’ i Efraimeo, ");
INSERT INTO tdx_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","naho i mpirai-lia’ey, o niaheñe ama’eo le efats’ ale-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Marine aze ty fifokoa’ i Menasè le i Gamliele ana’ i Pedatsore ty mpiaolo’ o ana’ i Menaseo; ");
INSERT INTO tdx_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ty mpirai-lia’e, o niaheñe ama’eo, telo ale-tsi-ro’ arivo-tsi-roan-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Le ty fifokoa’ i Beniamène; i Abidane ana’ i Gedoný ty ho mpiaolo’ o ana’i Beniamèneo; ");
INSERT INTO tdx_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ty mpirai-lia’e, o niaheñe ama’eo, telo-ale-tsi-lime-arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","O vinolily an-tobe’ i Efraimeo amo mpirai-lia’eo le rai-hetse-tsi-valo-arivo-tsi-zato; fahatelo te mienga iereo. ");
INSERT INTO tdx_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Añ’ila’e avaratse ty hijadoña’ ty sain-tobe’ i Dane ty amo mpirai-lia’eo, le i Akièzere, ana’ i Amisedahy ty mpiaolo’e; ");
INSERT INTO tdx_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ty mpirai-lia’e, o niaheñe ama’eo, eneñ’ ale-tsi-ro’ arivo-tsi-fiton-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Ty fifokoa’ i Asere ty hitobe marine aze, le i Pejiele ana’ i Okrane ty mpiaolo’ o ana’ i Asereo; ");
INSERT INTO tdx_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ty mpirai-lia’e, o niaheñe ama’eo, efats’ ale-tsi-arivo-tsi-liman-jato o lahindefo’eo. ");
INSERT INTO tdx_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Le ty fifokoa’ i Naftaly, i Akirà ana’ i Ainane ty mpiaolo’ o ana’ i Naftalio; ");
INSERT INTO tdx_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ty mpirai-lia’e, o niaheñe ama’eo, lime-ale-tsi-telo-arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","O vinolily an-tobe’ i Daneo le rai-hetse-tsi-lime-ale-tsi-fito-arivo-tsi-enen-jato; miavotse am-boli’e iereo, am-pañoriheñe ty sai’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","O niaheñe amo ana’ Israeleo ty amo anjomban-droae’eo, ze vinolily kitobe-kitobeo ty amo mpirai-lia’eo, enen-ketse-tsi-telo-arivo-tsi-liman-jato-tsi-limampolo. ");
INSERT INTO tdx_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Tsy niaheñe amo ana’ Israeleo o nte-Levio, ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Nanoe’ o ana’ Israeleo ze hene nandilia’ Iehovà i Mosè; ie ty nitobea’ iareo amo sai’eo le ie ty nionjona’ iareo, songa am-pifokoa’e añ’anjomban-droae’e. ");
INSERT INTO tdx_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Zao o tarira’ i Aharone naho i Mosè tamy andro nitsarae’ Iehovà amy Mosè am-bohi-Sinaiy. ");
INSERT INTO tdx_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Iretoy o tahinan’ ana’ i Aharoneo: Tañoloñoloña’e t’i Nadabe naho i Abiho, i Elazare, vaho Itamare. ");
INSERT INTO tdx_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Ie ro tahina’ i ana’ i Aharone rey, o mpisoroñe norizañeo, i noriza’e hitoroñe ho mpisoroñe rey. ");
INSERT INTO tdx_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Fe nihomak’ añatrefa’ Iehovà t’i Nadabe naho i Abiho, ie nañenga afo tsie aolo’ Iehovà ampatram-bei’ i Sinay añe, ie tsy nanañ’ anake. Aa le nitoroñe ho mpisoroñe añatrefa’ i Aharone rae’e t’i Elazare naho Itamare. ");
INSERT INTO tdx_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Le nanao ty hoe amy Mosè t’Iehovà: ");
INSERT INTO tdx_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Ampañarineo ty fifokoa’ i Levy, vaho ampiatrefo i Aharone mpisoroñe, hitoroña’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Ho henefe’ iareo o fitoloña’eo naho ty fitoloña’ i valobohòke aolo’ i kibohom-pamantañañey hitoloñe amy kivohoy. ");
INSERT INTO tdx_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Ho vandroñe’ iereo ty harao’ i kibohom-pamantañañey le ho henefe’ iareo ty fiatrahañe o ana’ Israele mioza amy fitoroñañe i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Le tendreo ho amy Aharone naho o ana’eo o nte-Levio; ie hene nitolorañe boak’ amo ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aa le tendreo t’i Aharone naho o ana’eo hitolon-ko mpisoroñe; fe havetrake ze ondaty ila’e miharine eo. ");
INSERT INTO tdx_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Le hoe t’Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Ingo, izaho ty nandrambe o nte-Levio amo ana’ Israeleo hisolo ze tañoloñoloña’ o ana’ Israele manoka-koviñeo. Aa le ahiko o nte-Levio, ");
INSERT INTO tdx_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","amy te fonga ahiko ze valohan’ anake: Mifototse amy andro nipaohako ze hene valohan’ anak’ an-tane Mitsraimey le songa navìko ho ahiko ze valohan’ ana’ o ana’ Israeleo, ke ondaty he hare. Ahy iereo, Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Le nanao ty hoe amy Mosè an-dratraratra’ i Sinay añe t’Iehovà, ");
INSERT INTO tdx_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Volilio o ana’ i Levio, amo anjomban-droae’eo, naho amo hasavereña’eo; fonga iaho ze lahilahy vola’e raike mañambone. ");
INSERT INTO tdx_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Aa le niahe’ i Mosè amy tsara’ Iehovày, amy nandiliañe azey. ");
INSERT INTO tdx_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Intoañe o ana’ i Levio ty amo tahina’eo: i Geresone naho i Kehàte vaho i Merarý. ");
INSERT INTO tdx_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Intoañe o tahinan’ ana’ i Geresone amo hasavereña’eoo: i Libný naho i Simý. ");
INSERT INTO tdx_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Naho o ana’ i Kehàteo amo hasavereña’eo: i Amrame, naho Izehare, i Khebrone vaho i Oziele. ");
INSERT INTO tdx_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Naho o ana’ i Merario amo hasa­ve­re­ña’eo: i Maklý naho i Mosý. Ie ro hasavereña’ i Levy amo anjomban-droae’eo. ");
INSERT INTO tdx_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","I Geresone ty niboaha’ o hasavereña’ i Libnio naho o hasavereña’ i Simio; Ie o amori’ i Geresoneo. ");
INSERT INTO tdx_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Ty niaheñe am’ iereo, ami’ty ia’ ze hene lahilahy vola’e raike mañambone le fito-arivo-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Natobe amboho’ i kivohoy ahan­drefañe ey o amori’ o nte-Geresoneo. ");
INSERT INTO tdx_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","I Elisafe ana’ i Laede ty mpiaolo’ ty an­jom­ban-droae’ o amori’ i Geresoneo. ");
INSERT INTO tdx_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ty fitoloña’ o amori’ i Geresoneo le amy kibohom-pamantañañey, le i kivohoy naho i kibohotsey, i tako’ey naho i lamba-pañefe’ i lalan-kibohom-pamantañañeiy, ");
INSERT INTO tdx_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","naho o lamba miradorado an-kiririsa eio, naho o lamba fañefe’ i lalam-bein-kiririsaio, i miarikatoke i kivohoiy naho i kitreliy naho o tali’eo: vaho ze fitoloñañe amy rezay. ");
INSERT INTO tdx_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","I Kehàte ty niboaha’ o hasavereña’ i Amrameo, naho o hasavereña’ Izehareo, naho o hasavereña’ i Khebroneo vaho o hasavereña’ i Ozieleo: ie o amori’ i Kehàteo; ");
INSERT INTO tdx_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","am’ iereo ty niaheñe ze fonga lahi­lahy vola’e raike mañambone, aa le valo-arivo-tsi-enen-jato ty mpitoloñe amy famandroñañe i efe-miavakeiy. ");
INSERT INTO tdx_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Atimo’ i kivohoy ty fitobea’ o amori’ i Kehàteo, ");
INSERT INTO tdx_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","i Elitsafane ana’ i Oziele ty mpiaolo’ ty anjomban-droae’ o amori’ i Kehàteo. ");
INSERT INTO tdx_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Ty lili’ iareo, le i vatay, naho i rairaiy, naho i fitàn-jiroy, naho o kitrelio, naho o fanake itoroñañe amy efe-miavakeo, naho i lamba fañefetsey vaho ze fampikasokasohañe irezay. ");
INSERT INTO tdx_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","I Elazare ana’ i Aharone mpisoroñe, ro talè’ o mpi­aolo nte-Levio, ie ty mpi­sari’ o mpamandroñe amy efe-miavakeio. ");
INSERT INTO tdx_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","I Merarý ty niboaha’ ty hasavereña’ i Makly naho ty hasavereña’ i Mosy: ie o amori’i Merario. ");
INSERT INTO tdx_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Ty ia’ iareo, ie niaheñe ze hene lahilahy vola’e raike mañambone le eneñ’ arivo-tsi-roan-jato. ");
INSERT INTO tdx_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","I Tsoriele ana’ i Abikaile ty talèn’ anjomban-droae’ o amori’ i Merario; avara’ i kivohoy ty fitobea’ iereo. ");
INSERT INTO tdx_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Zao ty fitoroñañe nafantok’ amo amori’ i Merario: o varamba i kivohoio, o sàka’eo, o anakòre’eo, o tombo’eo, o harao’eo, naho ze hene fitoloñañe amy rezay, ");
INSERT INTO tdx_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","naho o ana-kòreñe miarikatoke i kiririsaio rekets’ o tombo’eo naho o tsato’eo vaho o tali’eo. ");
INSERT INTO tdx_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Aolo’ i kivohoy atiñanañe ey, aolo’ i kibohom-pamantañañey mb’amy fanjirihan’androy—ty fitobea’ i Mosè naho i Aharone naho o ana’ i Aharoneo, hañambeñe i toetse miavakey, vaho ty fiatrafañe o ana’ Israeleo, le havetrake ze ila’e miharine eo. ");
INSERT INTO tdx_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Ty ia’ o niaheñe amo nte-Levio; o niahe’ i Mosè naho i Aharone ami’ty lili’ Iehovà amo hasavereña’eoo, ze lahilahy vola’e raike mañambone, le ro’ale-tsi-ro’arivo. ");
INSERT INTO tdx_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Le hoe t’Iehovà amy Mosè: Volilio ze hene tañoloñoloña’ o ana’ Israele vola’e raike mañamboneo, songa iaheñe ami’ty tahina’e. ");
INSERT INTO tdx_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Le rambeso ho ahy, Iehovà, o nte-Levio hasolo ze hene tañoloñoloña’ o ana’Israeleo; le ty hare’ o nte-Levio ty hasolo ze hene valohan’ anan-kare’ o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Aa le fonga niahe’ i Mosè o ana’ Israeleo ami’ty nandilia’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Ty nañiahañe o hene tañoloñoloñan-dahilahy vola’e raike mañamboneo, am-pañiahañe o tahina’eo, le niro’ ale-tsi-ro’ arivo-tsi-roan-jato-tsi-fitompolo-telo’ amby. ");
INSERT INTO tdx_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Le hoe ty tsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Rambeso ho ahiko o nte-Levio hasolo ze hene tañoloñoloña’ o ana’ Israeleo naho ty hare’ o nte-Levio hasolo ty hare’ iareo. Ho ahiko o nte-Levio, Izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Aa ty hijebañañe i roan-jato-tsi-fitompolo-telo-ambi’ o tañoloñoloñan’ ana’ Israele nandikoatse ty ia’ o nte-Levioo rey, ");
INSERT INTO tdx_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","le songa handrambesa’o sekele lime ho vili-loha’e; ami’ty vili’ i sekelen’ efe-miavakey, roapolo gerà ty sekele raike. ");
INSERT INTO tdx_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Le hatolo’o amy Aharone naho amo ana’eo i drala nijebañañe o ila’e nandikoatseoy. ");
INSERT INTO tdx_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Aa le rinambe’ i Mosè i dralam-pijebañañey amo nandikoatse ze nijebañe’ o nte-Levio; ");
INSERT INTO tdx_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","amo tañoloñoloña’ o ana’ Israeleo ty nandrambesa’e ty drala arivo-tsi-telon-jato-tsi-enempolo-lime amby amo sekelen-toe-miavakeo; ");
INSERT INTO tdx_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","vaho natolo’ i Mosè amy Aharone naho amo ana’eo i dralay, amy nitsara’ Iehovày, amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Hoe ty nitsara’ Iehovà amy Mosè naho i Aharone: ");
INSERT INTO tdx_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Volilio o ana’ i Kehàte boak’ amo nte-Levioo, amo hasavereña’eo naho amo anjomban-droae’eo, ");
INSERT INTO tdx_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ze telopolo taoñe pake limampolo taoñe; ze hene hizilik’ amy firimboñañey, hitoloñe amy kibohom-pamantañañey. ");
INSERT INTO tdx_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Zao ty ho fitoloña’ o ana’ i Kehàteo amy kibohom-pamantañañeio amo miava-do’eo: ");
INSERT INTO tdx_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Naho hionjoñe i tobey, le homb’eo t’i Aharone naho o ana’eo hanjetse i lamba fañefe­tsey, hanaroña’e i vatam-pañinay ");
INSERT INTO tdx_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","naho ho rakofa’ iareo holin-trozofisoitse naho ho lamahe’ iereo lamba manga ki’e ty ambone’e vaho hatsorofo’ iareo ama’e o bao’eo. ");
INSERT INTO tdx_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Ho lamahe’ iereo lamba manga i rairai’ i mofom-piatrefañey, le hapoke ama’e o fanakeo naho o sadròo naho o soakazoo, o fitovy fañiliñañeo; hidoñe ama’e avao i mofo tsi-modoy. ");
INSERT INTO tdx_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Hilafiha’ iareo lamba mena mañabara vaho hirakofa’ iareo holin-trozofisoitse; le hatsorofo’ iareo ama’e o bao’eo. ");
INSERT INTO tdx_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Ho rambese’ iareo ty lamba manga hanaroñañe i fitàn-jiron-kazavàñey, naho i jiro’e rey, o fiharatan-tsokotsoko’eo, o sadrom-baen’ afo’eo, naho o fitavona-menake famahanañ’ azeo. ");
INSERT INTO tdx_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Le haholonkolo’ iereo an-kolin-trozofisoitse ie naho o harao’e iabio, vaho hasampe ambone o bao-pitarazoañeo. ");
INSERT INTO tdx_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Ho lamahe’ iareo lamba manga ka i kitrely volamenay naho ho rakofañe holin-trozofisoitse vaho hatsorofotse ama’e o bao’eo. ");
INSERT INTO tdx_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Ho rambese’ iareo ze hene harao-pitoloñañe, o fitoloña’ iareo amy miavakeio, le ho kolopofañe añate lamba manga naho ho rakofañe holi-trozofisoitse vaho hajò ambone’ o bao fitarazoañeo. ");
INSERT INTO tdx_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Haveve’ iareo añe o lavenok’ amy kitreliio vaho handamiha’ iareo lamba malo-mavo. ");
INSERT INTO tdx_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Hapo’ iereo ambone’e ze hene haraotse fitoloña’ iareo ama’e: o endraendrao, o fitsipokeo, o sadròo, o fitovio, naho o hene harao’ i kitreliio: le ho rakofa’ iareo holi-trozofisoitse, vaho hatso­rofotse ama’e o bao’eo. ");
INSERT INTO tdx_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Aa ie nihenefa’ i Aharone naho o ana’eo ty fandrakofañe o fanake miavakeo naho o finga miavake iabio, naho fa hionjoñe mb’eo i tobey le homb’eo o ana-dahi’ i Kehàteo hitarazo o rahao; fe tsy ho tsapae’ iereo o raha miavakeo tsy mone hivetrake. Irezay ro enta’ o ana’ i Kehàteo an-kibohom-pamantañañe ao. ");
INSERT INTO tdx_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Nafantok’ amy Elazare ana’ i Aharone mpisoroñe ty mena’ i jiroy, naho i emboke mañitsey, naho i enga-mahakama boak’ àndroy, naho i mena-pañorizañey; aze ka ty lily amy kivohoy, ze am-po’e ao iaby, naho amy toe-miavakey rekets’ o hene fana’eo. ");
INSERT INTO tdx_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Le hoe ty nitsara’ Iehovà amy Mosè naho i Aharone, ");
INSERT INTO tdx_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Asoao tsy haitoañe amo nte-Levio ty fifokoa’ o hasavereña’ o nte-Kehàteoo. ");
INSERT INTO tdx_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Zao ty hanoe’ areo ty am’ iereo soa te ho veloñe fa tsy hivetrake naho harinea’ iareo o raha miavakeo: Homb’eo t’i Aharone naho o ana’eo vaho ho tendrè’ iareo songa ami’ty fitoroña’e naho ty kilanka’e. ");
INSERT INTO tdx_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Fe tsy hizilik’ ao o nte-Kehàteo hisamba ty fandrakofañe o raha miavakeo tsy mone hihomake. ");
INSERT INTO tdx_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","volilio ka o ana’ i Geresoneo ami’ty anjomban-droae’e naho o hasavereña’eo; ");
INSERT INTO tdx_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ie telopolo taoñe mañambone pake limampolo taoñe ty añiaha’o, ze hizilike hitoroñe, hitoloñe amy kibohom-pamantañañey ao. ");
INSERT INTO tdx_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Zao ty fitoloña’ o hasavereña’ i Geresoneo ami’ty fitoroñañe naho fijinian-kilankañe. ");
INSERT INTO tdx_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Hendese’ iereo o lamba fañefe’ i kibohom-pamantañañeio rekets’ i rako’ey, naho i rako’e holin-trozofisoitse ambone’ey, naho ty lamba fañefe’ i lalan-kibohom-pamantañañey, ");
INSERT INTO tdx_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","le o lamba miradorado an-kiririsao naho o lamba fañefe’ i lalam-bein-kiririsaio, i miarikatoke i kivohoy naho i kitreliiy naho o tali’eo naho ze hene haraom-pitoloña’ iareo vaho ze raha mioza amy rezay; izay ty ho fitoroña’e. ");
INSERT INTO tdx_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Am-palie’ i Aharone naho o ana’eo ze hene fitoroña’ o ana’ i Geresoneo, amy kilanka’ iareo iabiy naho amo fitoloña’ iareo iabio, vaho hene hitendrea’ areo o fitoloña’iareoo naho o kilanka’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Ie ro fitoroña’ o nte-Geresoneo amy kibohom-pamantañañey, le ambanem-pità’ Itamare ana’ i Aharone mpisoroñe ty fitoloña’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Aa ty amo ana-dahi’ i Merario, le ho volilie’o iereo amo hasavereña’eo naho o anjomban-droae’eo; ");
INSERT INTO tdx_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ze telopolo taoñe mañambone pake limampolo taoñe ty hañiaha’o, ze hizilike amy fitoroñañey hifanehak’ amy kibohom-pamantañañey. ");
INSERT INTO tdx_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Le inao ty hafantok’ am’ iereo ho kilanka’ iareo amy fitoroña’ iareo i kibohom-pamantañañeiy: o varamba i kivohoio naho o saka’eo, o anakòre’eo naho o vave’eo ");
INSERT INTO tdx_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","naho o anakòreñe miarikatoke i kiririsaio rekets’ o vave’eo, o tsato’eo naho o tali’eo naho o hene harao’eo vaho ze harao-pitoloña’e iaby, le ho tolora’o ami’ty tahina’ ondaty ty anjara kilanka’e. ");
INSERT INTO tdx_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Ie ro fitoroña’ o nte-Merario amy kibohom-pamantañañey; ambanem-pità’ Itamare ana’ i Aharone mpisoroñey ty fitoloña’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Aa le vinolili’ i Mosè naho i Aharone vaho o talèm-balobohòkeo o nte-Kehàteo, an-kasavereñañe naho añ’anjomban-droae, ");
INSERT INTO tdx_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","mifototse amo telopolo taoñeo pak’ amo limam-polo taoñeo, ze mizilik’ am-pitoroñañe ao, am-pitoloñañe amy kibohom-pamantañañey, ");
INSERT INTO tdx_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","le ro’arivo-tsi-fiton-jato-tsi-limampolo o niaheñe amo hasavereña’eoo. ");
INSERT INTO tdx_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Ie ro niaheñe amo hasavereña’ o nte-Kehàteo, o mpitoroñe amy kibohom-pamantañañeio ze nivolilie’ i Mosè naho i Aharone ami’ty lili’ Iehovà am-pità’ i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Aa ty nivolilieñe o nte-Geresoneo, amo hasavereña’e naho anjomban-droae’eo, ");
INSERT INTO tdx_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","mifototse amy ze telopolo taoñe mañambone pak’ amy ze limampolo taoñe, o hizilik’ am-pitoroñañe i kibohom-pamantañañeio— ");
INSERT INTO tdx_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","o niaheñe amo hasavereña’eo naho amo anjomban-droae’eoo le ro’arivo-tsi-enen-jato-tsi-telopolo. ");
INSERT INTO tdx_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Ie ro niaheñe amo nte-Geresoneo amo hasavereña’eo, ze mitoroñe an-kibohom-pamantañañe ao; o nivolilie’ i Mosè naho i Aharone ami’ty lili’ Iehovào. ");
INSERT INTO tdx_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Le o nivolilieñe an-kasavereña’ o nte-Merario ty amo hasavereña’eo naho o anjomban-droae’eo, ");
INSERT INTO tdx_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ie telopolo taoñe am-para’ te limampolo taoñe ze mizilik’ am-pitoroñañe hitoloñe an-kibohom-pamantañañe ao— ");
INSERT INTO tdx_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","o niaheñe amo hasavereña’eoo le ni-telo-arivo-tsi-roan-jato. ");
INSERT INTO tdx_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Ie ro niaheñe amo hasavereña’ o nte-Merario, ze nivolilie’ i Mosè naho i Aharone ami’ty lili’ Iehovà am-pità’ i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Ze niaheñe amo nte-Levio, o nivolilie’ i Mosè naho i Aharone naho o talè’ Israeleo amo hasavereña’eo naho o anjomban-droae’eo, ");
INSERT INTO tdx_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","amo telopolo taoñeo pak’ amo limampolo taoñeo, ze mizilik’ ao mifanehak’ am-pitoloñañe naho am-pitarazoañe kilankañe amy kibohom-pamantañañey ao; ");
INSERT INTO tdx_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","valo-arivo-tsi-liman-jato-tsi-valompolo ty niaheñe ");
INSERT INTO tdx_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","ami’ty lili’ Iehovà am-pità’ i Mosè ty nanendreañe iareo, songa am-pitoroña’e naho an-kilanka’e; vinolily ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Lilio o ana’ Israeleo te hasese alafe’ i tobey ze angamae, naho ze mañaka-dranoke vaho ze nileora’ ty havilasy; ");
INSERT INTO tdx_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","sambe hasese ze lahilahy ndra ampela; alafe’ i tobey ty hampipohañe iareo, tsy handeotse ty tobe’ iareo, izaho mpimo­neñe añivo’e ao. ");
INSERT INTO tdx_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Aa le nanoe’ o ana’ Israeleo izay, ie nasese alafe’ i tobey ey; amy nandilia’ Iehovà amy Mosèy ty nanoe’ o ana’Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Le hoe ty nitsara’ Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Misaontsia amo ana’ Israeleo: Naho eo ty lahilahy ndra ampela manao ze atao fandilara’ ondaty, am-pijeharañe am’ Iehovà, mampanan-tahiñe indatiy; ");
INSERT INTO tdx_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","le hisolohoa’e i hakeo nanoe’e, naho ho henefa’e avake i tahi’ey naho ho tovoña’e ty ampaha-lime’e vaho hatolo’e amy nandilara’ey. ");
INSERT INTO tdx_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Aa naho tsy aman-dongo hañavahañe i sata ratiy indatiy, le hengae’e am’ Iehovà ho a i mpisoroñey ty ava’ i hakeoy ho tovo’ i añondrilahi-pijebañañe hijebañe aze. ");
INSERT INTO tdx_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Ho aze ka o engan-kavoañe atoka’ o ana’ Israeleoo, ze atolo’ iareo amy mpisoroñey. ");
INSERT INTO tdx_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Aze ze hene engae’ ondatio, ze atolo’ ondaty amy mpisoroñey ro aze. ");
INSERT INTO tdx_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Saontsio amo ana’ Israeleo ty hoe: ie mandifike ty tañanjomba’ ondaty naho mitomaly ama’e, ");
INSERT INTO tdx_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","naho iolora’ ondaty, ie nietak’ am-pihaino’ i vali’ey, naho tsy nionin-dre ke te nandeo-batañ’ an-kafitse, vaho tsy vinamba, tsy tsinepake te nanoe’e; ");
INSERT INTO tdx_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","f’ie angara’ ty famarahiañe, naho farahie’e i vali’e nandeo-batañey, he t’ie nangara’ ty famarahiañe, le fara­hie’e ty tañan­jomba’e tsy nandeo-batañe; ");
INSERT INTO tdx_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","le hasese’ indatiy mb’ amy mpisoroñey mb’eo i tañan­jomba’ey. Hendese’e ka ty enga ty ama’e: ty bom-bare hordea fahafolo’ ty efà; tsy hañiliña’e menake ndra hamitseza’e emboke amy t’ie enga-mahakamam-pama­rahiañe, enga-paniahiañe, fampatiahian-kamengohañe. ");
INSERT INTO tdx_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Le hampiharinè’ i mpisoroñey i rakembay vaho hampiatrefe’e am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Hendese’ i mpisoroñey ty rano miavake am-pitovi-tane, le han­dram­besa’e debok’ an-tane’ i kibohotsey vaho hafitse’e amy ranoy. ");
INSERT INTO tdx_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Le hajoha’ i mpisoroney añatrefa’ Iehovà i rakembay, le habala’e ty maroi’e, le hapo’e an-taña’ i rakembay i engam-pitiahiañey, i enga-mahakama-pamarahiañey, ie am-pità’ i mpisoroñey i rano mafaitse minday fàtsey. ");
INSERT INTO tdx_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Le hampifantà’ i mpisoroñey i rakembay, ami’ty hoe, Naho tsy niharo tihy ama’ ondaty irehe, naho tsy nivio mb’an-kaleorañe, ie fehè’ i vali’oy, le mihahà ami’ty rano mafaitse minday fatse toy. ");
INSERT INTO tdx_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","F’ie mone nandrike ambane’ ty lilim-bali’o, nandeo-batañe, amy te nahazoan-dro-pilahiañe ty ‘ndaty tsy vali’o. ");
INSERT INTO tdx_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Ie amy zao hampititihe’ i mpisoroñey am-patse i rakembay: Le hanao ty hoe amy rakembay i mpisoroñey: Hanoe’ Iehovà titse naho fatse am’ ondati’oo, le ampivorohe’ Iehovà ty vania’o vaho hampientare’e ty tro’o, ");
INSERT INTO tdx_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","ami’ty rano minday i fatsey toy, ie hijoñe an-kovi’o ao hampivoroke ty vania naho hampienatse ty troke. Le hanao ty hoe i rakembay: Amena, Ie izay. ");
INSERT INTO tdx_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Le ho sokire’ i mpisoroñey am-boke peleke ao i fatsey vaho ho fao­paohe’e amy rano mafaitsey ao. ");
INSERT INTO tdx_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Le hampinome’e i rakembay i rano mafaitse minday fatsey le hafaitse ama’e i rano minday fatse migologodrañ’ aoy. ");
INSERT INTO tdx_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Le ho rambese’ i mpi­soroñey am-pità’e amy zao i engam-pamarahiañey, naho hahela­hela’e añatrefa’ Iehovà, vaho hasese’e mb’amy kitreliy mb’eo; ");
INSERT INTO tdx_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","le handrambesa’ i mpisoroñey ty mahàtsa-pitàñe ho enga-tiahy, le hampañatoe’e amy kitreliy, heneke izay le hampikamae’e i rakembay i ranoy. ");
INSERT INTO tdx_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ie nampikamaeñe i ranoy, le ho tendreke, naho toe nandeo-batañe naho nivalik’ amy vali’ey, te hafaitse i rano minday fatse nigodrañe ama’ey, naho hienatse i fisafoa’ey naho ho voroke i vania’ey vaho ho injè’ ondati’eo i rakembay. ");
INSERT INTO tdx_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Fe naho tsy nandeo-batañe i rakembay naho malio, le ho votsotse vaho hiaren-tiry. ");
INSERT INTO tdx_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Izay ty fetsem-pamarahiañe, ie zehare’ ty tañanjomba’e ty lilim-bali’e vaho mivio mb’am-pandeorañe, ");
INSERT INTO tdx_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","hera añangara’ ty famarahiañe t’indaty naho farahie’e ty tañanjomba’e; le hampijohañe’e añatrefa’ Iehovà vaho hanoe’ i mpisoroñey ama’e o hene Hake zao. ");
INSERT INTO tdx_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Le halio tahiñe indatiy, fe hivave hakeo i rakembay. ");
INSERT INTO tdx_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Misaontsia amo ana’Israeleo le ano ty hoe: Naho mitangèñe, manao ty fanta’ o Nazireo, ndra ty lahilahy ndra ampela, hiambake ho am’ Iehovà, ");
INSERT INTO tdx_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","le hifoneña’e ty divay naho ze rano mahery; tsy hikama vinegran-divay ndra vinegran-toake, vaho tsy ho kamae’e ty ranom-baloboke, ndra ty voam-baloboke ke te mandrano he maike. ");
INSERT INTO tdx_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Tsy ho kamae’e ndra inoñe boak’ ami’ty vahem-baloboke ndra o àta’eo ndra o holi’eo amo hene andro maha Nazire azeo. ");
INSERT INTO tdx_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Amo hene andro maha Nazire azeo, tsy hiozam-piharatse i añambone’ey; ampara’ te heneke o andro niambaha’e ho a Iehovào; hiavake re; le henga’e hitombo avao o ori-maroin’añambone’eo. ");
INSERT INTO tdx_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Tsy hiharine lolo re amy ze hene ­andro hiambaha’e ho a’ ­Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Tsy handeo-batan-dre ndra aman-drae’e ndra rene’e, ndra aman-drahalahi’e ndra rahavave’e t’ie mihomake, amy te añam­bone’e eo ty fiambaha’e ho aman’ Añahare. ");
INSERT INTO tdx_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Hiavake am’ Iehovà re amo hene andro fiambaha’eo. ");
INSERT INTO tdx_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Ie mitojeha te mihomake marine aze t’indaty, naho leore’e i añambone’e norizañey, le ho harate’e i añambone’ey ami’ty andro fañeferañe aze; hiharata’e ami’ty andro fahafito’e. ");
INSERT INTO tdx_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Amy andro fahavaloy re ro handay deho roe ndra ana-boromahilala roe mb’amy mpisoroñe an-dalan-kibohom-pamantañañey mb’eo, ");
INSERT INTO tdx_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","le ho hentseñe’ i mpisoroñey ty raike ho engan-kakeo, le hisoroña’e ty raike hijebañañe i nandilatse amy fateiy, vaho havahe’e amy àndroy ty añambone’e. ");
INSERT INTO tdx_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Havì’e am’ Iehovà o andro fiambaha’eo vaho ho banabanae’e ty vik’ añondrilahy engan-dilatse; fe ho modo o andro taoloo kanao nileoreñe i fiambaha’ey. ");
INSERT INTO tdx_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Inao ty fetse’ o Nazireo: Ie heneke o andro fiambaha’eo le hasese mb’an-dalan-kibohom-pamantañam-beo, ");
INSERT INTO tdx_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","le ho banabanae’e am’ Iehovà o enga’eo: ty vik’ añondrilahy tsy aman-kandra hisoroñañe naho ty vik’ añondri-vave tsy aman-kila ho engan-kakeo, naho ty añondrilahy tsy aman-kandra ho engan-kanintsiñe, ");
INSERT INTO tdx_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","naho mofo po-dalivay an-karoñe, mofo vonga’e ami’ty mona linaro menake, naho mofo pisake nihosorañe menake, naho o enga-maha­kama’eo vaho o enga-rano’eo. ");
INSERT INTO tdx_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Le hasese’ i mpisoroñey añatrefa’ Iehovà izay vaho hengae’e i engan-kakeoy naho i enga hisoroñañey, ");
INSERT INTO tdx_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","le hengae’e ho engam-pañanintsiñe am’ Iehovà i añondrilahiy miharo amy haro-mofo po-dalivaiy; hengae’ i mpisoroñey ka i enga-maha­kama’ey naho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Le ho harate’ i Nazirey an-dalan-kibohom-pamantañañ’ ao i añambone’e norizañey le ho rambese’e o maroi’eo vaho hapo’e amy afo ambane’ i soron-kanintsiñeiy. ");
INSERT INTO tdx_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Le ho rambese’ i mpisoroñey ty soro’ i añondrilahy nahandroeñey naho ty vonga mofo po-dalivay raike naho ty mofo pisake po-dalivay boak’ amy haroñey vaho hatolo’e am-pità’ i Nazirey, ie fa niharate’e i añambone’e norizañey, ");
INSERT INTO tdx_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","le hahelahela’ i mpisoroñey irezay ho enga-kelahela añatrefa’ Iehovà; ie avaheñe ho a i mpisoroñey, mitraok’ ami’ty tratra’ i engan-kelahelay naho ty tso’ i engan-kavoañey. Heneke izay le mete mikama divay i Nazirey. ");
INSERT INTO tdx_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Izay ty fetse’ ty Nazire mifanta, ie mañenga am’ Iehovào amy ha-Nazire’ey, ambone’ ze satrie’e amy hanaña’ey; i nifanta’ey ro hanoe’e i lilim-piambaha’ey. ");
INSERT INTO tdx_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Misaontsia amy Aharone naho o ana’eo le ano ty hoe: Zao ty fitatà’ areo o ana’ Israeleo. Ano ty hoe am’ iereo: ");
INSERT INTO tdx_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Hitahy azo t’Iehovà, naho hañaro azo; ");
INSERT INTO tdx_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Hampireandreàñe’ Iehovà ama’o ty vinta’e, naho hatarik’ ama’o; ");
INSERT INTO tdx_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Hampiandrà’ Iehovà ama’o ty lahara’e vaho hampanintsiñe azo. ");
INSERT INTO tdx_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Izay ty hampipetaha’e amo ana’ Israeleo ty añarako hitahiako iareo. ");
INSERT INTO tdx_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Tamy andro nahafonira’ i Mosè ty fampitroarañe i kivohoy, le noriza’e naho nefera’e rekets’ o harao’e iabio, naho i kitreliy vaho o harao’e iabio; ie fa noriza’e naho neferañe ");
INSERT INTO tdx_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","le nañenga ka o mpiaolo’ Israeleo, o talèn’ anjomban-droae’eo, o mpiaolom-pifokoa’eo, o nijohañ’ ambone’ o niaheñeoo; ");
INSERT INTO tdx_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","binanabana’ iereo añatrefa’ Iehovà o enga’ iareoo, ty sarete milomboke eneñe naho katràka folo-ro’ amby, ty sarete raike boak’ am-piaolo roe, naho songa ninday ty añombe vaho nengae’ iereo aolo’ i kivohoy eo. ");
INSERT INTO tdx_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Rambeso am’ iereo o raha zao, hitoloñe am-pitoroñañe i kibohom-pamantañañey vaho atolo­ro amo nte-Levio, songa amy fitoroña’ey. ");
INSERT INTO tdx_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Aa le rinambe’ i Mosè i sarete rey naho i katraka rey vaho natolo’e amo nte-Levio. ");
INSERT INTO tdx_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Natolo’e amo ana’ i Geresoneo ty sarete roe naho ty añombe efatse ty amo fitoroña’ iareoo, ");
INSERT INTO tdx_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","le natolo’e amo ana’ i Merario ty sarete efatse rekets’ añombe valo ty amo fitoroña’ iareo ambane’ ty fehe’ Itamare ana’ i Aharone mpisoroñeo. ");
INSERT INTO tdx_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Tsy nimea’e ka o ana’ i Kehàteo, amy t’ie mpitoroñe amo raha miavakeo, le tarazoeñe ty a iareo. ");
INSERT INTO tdx_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Nañenga amy fanokanañe i kitreliy i mpiaolo rey amy andro nañorizañ’ azey, binanabana’ o mpiaoloo mb’aolo’ i kitreliy mb’eo o enga’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Le hoe t’Iehovà amy Mosè: Hengae’ iareo, songa añ’ andro’e o enga’eo amy fanokanañe i kitreliiy. ");
INSERT INTO tdx_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","I Naksone ana’ i Aminadabe talèm-pifokoa’ Iehodà, ty nañenga i enga’ey ami’ty andro valoha’e; ");
INSERT INTO tdx_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","o nengae’eo: ty antova volafoty nilanja sekele zato-tsi-telo-polo naho soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","naho ty antova volamena folo sekele pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ty bania naho ty añondrilahy vaho vik’ añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ty oselahy ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ty añombe roe naho añondrilahy lime, oselahy lime, vaho vik’ añondri­lahy lime ho engan-kanintsiñe. Izay ty nengae’ i Naksone ana’ i Aminadabe. ");
INSERT INTO tdx_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Zao ty nengae’ i Netanele, ana’ i Tsoare, talè’ ty fifokoa’ Isakhare amy andro faharoey: ");
INSERT INTO tdx_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","nañenga ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toetse miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ty fanake volamena folo sekele, pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ty bania naho ty añondrilahy naho vik’añondrilahy hisoroñañe ");
INSERT INTO tdx_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","vaho ty vik’ ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’ i Netanele ana’ i Tsoare. ");
INSERT INTO tdx_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","I Eliabe ana’i Kelone talèm-pifokoa’ i Zebolone ty nañenga amy andro fahateloy: ");
INSERT INTO tdx_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ty fanake volamena folo sekele, pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ty bania, naho ty añondrilahy vaho vik’añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","vaho ty vik’ ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime, vaho ty vik’ añondrilahy lime. Izay ty nengae’ i Eliabe ana’ i Kelone. ");
INSERT INTO tdx_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","I Elitsore ana’ i Sedeore, talèm-pifokoa’ i Reòbene ty nañenga amy andro fah’ efatsey: ");
INSERT INTO tdx_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ty fanake volamena folo sekele, pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ty bania naho ty añondrilahy vaho vik’añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","vaho ty vik’ ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’ i Elitsore ana’ i Sedeore. ");
INSERT INTO tdx_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","I Selomiele ana’ i Tsorisadahy talè’ ty fifokoa’ i Simone ty nañenga amy andro faha limey. ");
INSERT INTO tdx_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ty fanake volamena folo sekele, pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ty bania, naho ty añondrilahy vaho vik’ añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","vaho ty vik’ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’ i Selomiele ana’ i Tsorisadahy. ");
INSERT INTO tdx_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","I Eliasafe ana’ i Dehoele talèm-pifokoa’ i Gade ty nañenga amy andro fah’eneñey. ");
INSERT INTO tdx_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ty fanake volamena folo sekele, pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ty bania naho ty añondrilahy vaho vik’ añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","vaho ty vik’ ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’ i Eliasafe ana’ i Dehoele. ");
INSERT INTO tdx_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","I Elisama ana’ i Amihode talèm-pifokoa’ i Efraime ty nañenga amy andro faha-fitoy. ");
INSERT INTO tdx_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ty fanake volamena folo sekele, pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ty bania, naho ty añondrilahy vaho vik’ añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","vaho ty vik’ ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’ i Elisama ana’ i Amihode. ");
INSERT INTO tdx_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","I Gamliele ana’ i Pedatsore talè’ ty fifokoa’ i Menasè ty nañenga amy andro fahavaloy. ");
INSERT INTO tdx_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ty fanake volamena folo sekele, pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ty bania naho ty añondrilahy vaho vik’ añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","vaho ty vik’ osen’ engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","le ho engan-kanintsiñe: ty añombe roe naho ty añondri­lahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Ie o nengae’ i Gamliele ana’ i Pedatsoreo. ");
INSERT INTO tdx_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","I Abidane ana’ i Gedoný talè’ ty fifokoa’ i Beniamène ty nañenga amy andro fahasivey. ");
INSERT INTO tdx_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ty fanake volamena folo sekele, pea’ ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ty bania naho añondrilahy vaho vik’ añondrilahy hisoroñañe ");
INSERT INTO tdx_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","vaho ty vik’ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’ i Abidane ana’ i Gedoný. ");
INSERT INTO tdx_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","I Akièzere, ana’i Amisedahy talèm-pifokoa’ i Dane ty nañenga amy andro faha-foloy. ");
INSERT INTO tdx_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ty fanake volamena folo sekele, pea’ ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ty bania, naho ty añondrilahy vaho vik’ añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","vaho ty vik’ ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’ i Akièzere, ana’ i Amisedahy. ");
INSERT INTO tdx_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","I Pejiele ana’ i Okrane talè’ ty fifokoa’ i Asere ty nañenga amy andro folo-raik’ ambiy. ");
INSERT INTO tdx_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ty fanake vola­mena folo sekele, pea’ ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ty bania, naho ty añondrilahy naho vik’ añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","vaho ty vik’ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’ i Pejiele ana’ i Okrane. ");
INSERT INTO tdx_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","I Akirà ana’ i Ainane talè’ ty fifokoa’ i Naftaly ty nañenga amy andro faha folo-roe-ambiy. ");
INSERT INTO tdx_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Nengae’e ty antova volafoty nilanja zato-tsi-telopolo sekele, naho ty soakazo volafoty fitompolo sekele an-tsekelen-toe-miavake, songa pea ty mona linaro menake ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ty fanake volamena folo sekele, pea ty emboke; ");
INSERT INTO tdx_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ty bania naho ty añondrilahy vaho vik’ añondrilahy hisoroñañe; ");
INSERT INTO tdx_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","vaho ty vik’ose ho engan-kakeo; ");
INSERT INTO tdx_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","le ho engan-kanintsiñe: ty añombe roe, ty añondrilahy lime, ty oselahy lime vaho vik’ añondrilahy lime. Izay ty nengae’i Akirà ana’ i Ainane. ");
INSERT INTO tdx_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Zao ty engam-panokanañe i kitreliy boak’ amo mpiaolo’ Israeleo, tamy nañorizañe azey: ty antova volafoty folo-ro’amby le soakazo folo-ro’ amby le fanake volamena folo-ro’amby. ");
INSERT INTO tdx_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Songa nilanja zato-tsi-telo-polo sekele i antova rey, sindre fitom-polo sekele i soakazo rey, ty tontom-bolafoty amy fanake rey le ro’arivo-tsi-efa-jato sekele an-tsekelen-toe-miavake; ");
INSERT INTO tdx_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","i fanake vo­lamena pea ty emboke folo-ro’ amby rey songa nilanja folo sekele an-tsekelen-toetse miavake, le zato-tsi-roapolo sekele ty tontom-bolamena amy fanake rey; ");
INSERT INTO tdx_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","le nitonto ho bania folo-ro’ amby i añombe nengaen-kisoroñañe rey, le folo-ro’ amby i añondrilahy rey, le folo-ro’ amby ty vik’ añondrilahy naho o enga-mahakama’eo vaho folo-ro’amby ty vik’ose nanoeñe engan-kakeo. ");
INSERT INTO tdx_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Roa­polo-efats’ amby ty tontoñan’ añombelahy nengaen-ko soron-kanintsiñe, enem-polo ty añondrilahy, enem-polo ty oselahy vaho enem-polo ty vik’ añondry. Izay o engam-panokanañe i kitreliio, ie orizañe. ");
INSERT INTO tdx_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Aa naho nizilik’ amy kibohom-pamantañañey t’i Mosè hifanaontsia’e, le jinanji’e i fiarañanañañe nitsara ama’e boak’ ambone’ i toem-pijebañañe mikapeke i vatam-pañinay añivo’ i kerobe roe reiy; izay ty fitsara’e ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Saontsio amy Aharone vaho ano ty hoe: Ie hañajary o jiroo, le ampañazavao mb’aolo mb’eo i fitàn-jiroy i jiro fito rey. ");
INSERT INTO tdx_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Le nanoe’ i Aharone izay; nalaha’e i jiro rey hañazava’e mañaolo i fitàn-jiroy amy nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Inao ty nanoeñe i fitàn-jiroy: volamena pinepeke i taho’ey pak’ amboñe’e eo; toe satam-pipepehañe, amy sare natoro’ Iehovà amy Mosèy, izay ty nanoe’e i fitàn-jiroy. ");
INSERT INTO tdx_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Aviho amo ana’ Israeleo o nte-Levio vaho efero. ");
INSERT INTO tdx_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Zao ty hañefera’o iareo: amitsezo am’ iereo ty ranon’ enga-kakeo, le ampiozàñem-piharatse ty fañòva’ ia­reo iaby, naho ampanasao sikiñe vaho ampiliovo. ");
INSERT INTO tdx_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Le ampangalao iareo ty bania rekets’ i enga-maha­kama’ey, i mona linaro menakey, vaho ampangalao bania raike ho engan-kakeo. ");
INSERT INTO tdx_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Le aseseo mb’ añatrefa’ i kibohom-pamantañañey mb’eo o nte-Levio vaho atontono ty valobohò’ Israele; ");
INSERT INTO tdx_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Aa naho fa navori’o añatrefa’ Iehovà o nte-Levio le hanampe fitàñe amo nte-Levio o ana’ Israeleo; ");
INSERT INTO tdx_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","le hengae’ i Aharone ho engan-kelahela am’ Iehovà o nte-Levy boak’ amo ana’ Israeleoo hitoroñe Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Le hanampeza’ o nte-Levio fitàñe i bania rey, naho hengae’o ho engan-kakeo ty raike vaho ho soroñañe am’ Iehovà ty raike, hijebaña’o o nte-Levio. ");
INSERT INTO tdx_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Aa le ajohaño añatrefa’ i Aharone naho o ana’eo o nte-Levio vaho engao am’ Iehovà ho engan-kelahela. ");
INSERT INTO tdx_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Izay ty hañambaha’o amo ana’ Israeleo o nte-Levio le ho ahiko o nte-Levio. ");
INSERT INTO tdx_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Henane zay, himoake hitoroñe amy kibohom-pamantañañey o nte-Levio, ie fa neferañe naho nengaeñe ho engan-kelahela. ");
INSERT INTO tdx_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Songa natolotse ahiko boak’ amo ana’ Israeleo; fa rinambeko ho amako ho solo’ ze hene manoka-koviñe; ze fonga tañoloñoloñan’ ana’ Israele. ");
INSERT INTO tdx_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Toe anjarako ze hene valohan’ ana’ o ana’ Israeleo, ondaty naho hare; tamy andro nipaohako ze fonga valohan’ ana’ i Mitsraimey ty nañambahako iareo ho ahy. ");
INSERT INTO tdx_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Le rinambeko ho soloe’ o nte-Levio o tañoloñoloñan’ ana’ Israeleo; ");
INSERT INTO tdx_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","vaho natoloko amy Aharone naho amo ana’eo aivo o ana’ Israeleo ho ravoravo o nte-Levio, hitoloñe ami’ty fitoloña’ o ana’ Israeleo amy kibohom-pamantañañey, naho hanao fijebañañe ho amo ana’ Israeleo tsy mone hiboak’ amo ana’ Israeleo ty angorosy naho harinea’ o ana’ Israeleo i efe-miavakey. ");
INSERT INTO tdx_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Izay ty nanoe’ i Mosè naho i Aharone vaho ty valobohò’ Israele amo nte-Levio; ze hene nandilia’ Iehovà i Mosè ty amo nte-Levio ty nanoe’ o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Le nañalio vatañe o nte-Levio naho nanasa’ o siki’eo iareo, naho nengae’ i Aharone am’ Iehovà ho ravoravo miavake, vaho nanao fijebañañe hañaliova’e iareo. ");
INSERT INTO tdx_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ie henane zay nimoak’ an-kibohom-pamantañañe ao o nte-Levio hitoloñe añatrefa’ i Aharone naho o ana’eo; i nandilia’ Iehovà amy Mosè ty amo nte-Levio ty nanoañe am’iareo. ");
INSERT INTO tdx_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Inao ty amo nte-Levio: ie roapolo-taoñe lim’ amby mañambone ro hizilike hitoloñe an-kibohom-pamantañañe ao; ");
INSERT INTO tdx_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ie limampolo taoñe ro hitroatse amo fitoroña’eo, le tsy hitoloñe ao ka. ");
INSERT INTO tdx_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","F’ie mete hañimba o rahalahi’eo an-kibohom-pamantañañe ao, hisary o tolon-draha’eo fe tsy hitromake. Izay ty hanoe’o amo nte-Levio amo fitoloña’eo. ");
INSERT INTO tdx_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Nitsara amy Mosè t’Iehovà an-dratraratra’ i Sinay añe ami’ty volam-balohan-taom-paharoe’ nienga’ iareo an-tane Mitsraime, ami’ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Hambena’ o ana’ Israeleo i Fihelañey amy namotoañañe azey, ");
INSERT INTO tdx_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","ami’ty andro faha-folo-efats’ ambi’ ty volañe toy naho hariva ty hambena’ areo aze amy namantañañe azey; o fañè’e iabio naho ze hene fepe’e ty hambena’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Aa le sinaontsi’ i Mosè amo ana’ Israeleo ty hiambeñe i Fihelañey. ");
INSERT INTO tdx_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Le nambena’ iareo te folakandro-miroñe amy andro faha-folo-efats’ ambi’ i volam-baloha’ey am-patrambei’ i Sinay i Fihelañey; amy nandilia’ Iehovà i Mosèy ty nanoe’ o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ie amy zao teo t’indaty nandeo-batañe ami’ ty lolo vaho tsy nete niatreke i Fihelañey amy andro zay; aa le nimb’ amy Mosè naho i Aharone amy àndroy, ");
INSERT INTO tdx_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","le nanoe’ indaty rey ty hoe, Maleotse ami’ty fate’ ondaty zahay. Aa vaho ho sebañeñe tsy hitraok’ amo ana’ Israeleo hibanabana i enga’ Iehovày amy namantañañe azey hao? ");
INSERT INTO tdx_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Le hoe t’i Mosè am’ iereo, Mahaliñisa heike hitsa­noñako ty ho lilie’ Iehovà ty ama’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Le hoe t’Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Misaontsia amo ana’ Israeleo, ty hoe: Ndra iaia t’indaty ama’ areo ndra amo tarira’ areoo maleotse ami’ty lolo, ndra t’ie am-pitaveañañe añe, le mbe hambena’e i Fihelañ’Ambone’ Iehovày; ");
INSERT INTO tdx_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","ami’ty andro miroñe’ i faha-folo-efats’ ambi’ i volam-paharoey ty hañambena’e aze. Ho kamae’ iareo ama’e ty mofo po-dalivay mitraok’ aña-mafaitse. ");
INSERT INTO tdx_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Ie tsy hanisa ami’ty maraiñe, le tsy ho pozaheñe o taola’eo. Amo fañè’ i Fihelañey iabio ty hañambena’ iareo aze. ");
INSERT INTO tdx_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Fe t’indaty malio, tsy am-pañaveloañe añe, ie ado’e i Fihelañey tsy ambena’e; toe haitoeñe am’ondati’eo indatiy, amy t’ie tsy nibanabana i enga’ Iehovày amy namantañañe azey; ho vavè’ indatiy ty hakeo’e. ");
INSERT INTO tdx_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Aa naho mañialo ama’ areo ao ty ambahiny, ie te hañambeñe i Fihelañe am’ Iehovày, le i fañèm-Pèsakey naho o fepè’eo ty anoañe aze, ho raike ty fañè’ areo naho i ambahiniy vaho i nisamak’ amy taney. ");
INSERT INTO tdx_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Amy andro nampitroareñe i kivohoiy le nakopo’ i rahoñey i kivohoy, i kibohom-pañinay; amy harivay pak’ ami’ ty maraiñe, ie ambone’ i kivohoy hoe afo. ");
INSERT INTO tdx_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Izay ty nilili’e: nikolopofe’ i rahoñey te antoandro vaho nihoe afo te haleñe. ");
INSERT INTO tdx_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Naho nonjoneñe tsy ho ambone’ i kivohoy i rahoñey, le nionjomb’eo o ana’ Israeleo; Aa naho nitsangañe i rahoñey le nitobe eo o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nandily t’Iehovà, le nienga o ana’ Israeleo, le nandily t’Iehovà vaho nitobe iereo; naho nijohañe ambone’ i kivohoy i rahoñey, le mbe nitobe eo avao. ");
INSERT INTO tdx_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ndra te nitolom-pijohañe ambone’ i kivohoy andro maro i rahoñey le nambena’ o ana’ Israeleo ty hatoro’ Iehovà, vaho tsy nañavelo. ");
INSERT INTO tdx_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ie amy zay, he nipetake ambone’ i kivohoy andro tsy ampeampe i rahoñey, le ami’ty lili’ Iehovà, nijohañe amy tobey iareo, vaho ami’ty lili’ Iehovà, nañavelo. ");
INSERT INTO tdx_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Teo i rahoñey te nitoboke hariva pak’ ami’ty maraiñe, naho nionjoñe i rahoñey le nienga iereo, ke te tambatse ey andro raike naho haleñe raike i rahoñey vaho nionjoñe, le nienga iereo. ");
INSERT INTO tdx_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ke roe andro, he volañe raike, kera taoñe raike ty nijohaña’ i rahoñey ambone’ i kivohoy, le nitolon-kitobe ey avao o ana’ Israeleo, tsy nañavelo; ie naonjoñe, vaho nañavelo. ");
INSERT INTO tdx_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Am-palie’ Iehovà, le nitobe iereo, vaho am-palie’ Iehovà, nañavelo iereo; nambena’ iareo ze nafanto’ Iehovà, ze nitsarae’ Iehovà am-pità’ i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Tseneo trompetra volafoty roe am-pipepèhañe; hanontonañe i valobohokey naho hikoihañe ty fiavotañe amy tobey. ");
INSERT INTO tdx_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Ie tiofeñe in-droe le fonga hifanontoñe ama’o an-dalan-kibohom-pamantañañe eo i valobohòkey. ");
INSERT INTO tdx_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","F’ie tiofeñe in-draike, le o mpiaoloo, o talèm-pifokoa’ Israeleo, ty hiropak’ ama’o. ");
INSERT INTO tdx_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Ie itiofan-koike le hiavotse o mpitobe atiñanañe eio. ");
INSERT INTO tdx_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Ie tiofen-koike fañindroe’e le o mpitobe atimoo ro hienga; mionjoñe iereo te itiofan-koike. ");
INSERT INTO tdx_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Naho hatontoñe i valobohòkey, le mitiofa fe tsy an-koike. ");
INSERT INTO tdx_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","O ana’ i Aharoneo, o mpisoroñeo, ro hitioke i trompetray; ho fañè’ areo hanitsike o hene tarira’ areo mifandimbeo. ");
INSERT INTO tdx_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ie mionjoñe mb’ añ’aly an-tane’ areo ao mb’ ami’ty rafelahy mañembetse anahareo, le hitiofan-koike amo trompetrao, vaho ho tiahy añatrefa’ Iehovà Andrianañahare’ areo vaho ho rombaheñe amo rafelahi’areoo. ");
INSERT INTO tdx_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ie amo andro firebeha’ areoo, naho amo andro nifantañeñeo, naho amo jiri-bolañeo le ho tiofe’ areo ambone’ o fisoroña’ areoo naho ambone’ o engam-pañanintsi’ areoo o trompetrao, ho faniahiañe anahareo añatrefan’ Andrianañahare’ areo. Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ie amy andro faha roapolo’ ty volam-paharoe’ i taom-paharoeiy, le naonjoñe ambone’ i kibohom-pañinay i rahoñey. ");
INSERT INTO tdx_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Le nionjom-beo an-kifange’e o ana’ Israeleo, nienga i fatram-bei’ i Sinaiy vaho nitsangañe am-patrambei’ i Parane eo i rahoñey. ");
INSERT INTO tdx_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Izay ty fienga’ iareo valoha’e ami’ty nandilia’ Iehovà am-pità’ i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Ty sain-tobe’ Iehodà ty niavotse valoha’e, an-ki-lia’ ki-lian-dahin-defoñe, talè’ i firimboñan-dahindefo’ey t’i Nakesone ana’ i Aminadabe, ");
INSERT INTO tdx_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","naho talè’ i firimboñan-dahin-defom-pifokoa’ o ana’ Isakhareoy t’i Netanele ana’ i Tsoare, ");
INSERT INTO tdx_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","vaho talè’ o lahindefom-pifokoa’ o nte-Zeboloneo t’i Eliabe ana’ i Kelone. ");
INSERT INTO tdx_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Nazotso amy zao i kivohoy vaho nionjoñe o ana’ i Geresoneo naho o ana’ i Merario, ninday i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Nionjom-beo ka ty sain-tobe’ i Reòbene, naho nitalèm-pirimboñam-pifokoa’e t’i Elitsore ana’ i Sedeore, ty amo lian-dahin-defo’eo, ");
INSERT INTO tdx_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","naho talè’ o lahin­defom-pifokoan’ ana’ i Simoneo t’i Selomiele ana’ i Tsorisadahy, ");
INSERT INTO tdx_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","vaho talè’ o lahindefom-pifokoan’ ana’ i Gadeo t’i Eliasafe ana’ i Rehoele. ");
INSERT INTO tdx_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Nionjoñe amy zao o nte-Kehàteo ninday o raha miavakeo, fa naoreñe aolo’ ty fiavi’ iareo i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Nionjoñe amy zao ty sain-tobe’ o ana’ i Efraimeo ty amo lian-dahin-defo’eo, i Elisama ana’i Amihode ty talèm-pirimboña’e, ");
INSERT INTO tdx_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","naho talèn-dahin-defom-pifokoan’ ana’ i Menase t’i Gamliele ana’ i Pedatsore, ");
INSERT INTO tdx_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","vaho talèn-dahin-defom-pifokoa’ o nte-Beniamèneo t’i Abidane ana’ i Gedoný. ");
INSERT INTO tdx_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Nionjoñe ami’ty naha-mpivoli’ i tobey ty sain-tobe’ o ana’ i Daneo ty amo lian-dahin-defo’eo; talè’ i firimboña’ey t’i Akièzere, ana’ i Amisedahy, ");
INSERT INTO tdx_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","naho talèn-dahin-defom-pifokoan’ ana’ i Asere t’i Pejiele ana’ i Okrane, ");
INSERT INTO tdx_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","vaho talèn-dahin-defom-pifokoan’ ana’ i Naftaly t’i Akirà ana’ i Ainane. ");
INSERT INTO tdx_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Izay ty nionjona’ o ana’ Israeleo, ty amo lia-rain-dahin-defo’eo—ie nionjoñe. ");
INSERT INTO tdx_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Le hoe t’i Mosè amy Kobabe ana’ i Reoele nte-Midiane, rafoza’ i Mosè, Mionjoñe mb’an-tane’ nitsa­rae’ Iehovà ty hoe: Hatoloko azo. Min­dreza ama’ay, le hanoe’ay soa; amy te nitsara soa ho am’ Israele t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Le hoe ty natoi’e, Tsy homb’eo iraho, fa hienga mb’an-taneko naho mb’an-drolongoko añe. ");
INSERT INTO tdx_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Aa hoe re, Miambane ama’o, ko mienga kanao fohi’o te hitobe ampatrambey añe vaho ho solom-pihaino’ay irehe. ");
INSERT INTO tdx_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ie amy zao, naho indreza’o lia, le ze hasoa hanoe’ Iehovà ama’ay ro hanoe’ay ama’o. ");
INSERT INTO tdx_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Aa le nenga’ iareo telo andro ty vohi’ Iehovà le niaolo iareo telo andro ty vatam-pañina’ Iehovà hipay fitobeañe. ");
INSERT INTO tdx_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Tambone’ iereo ey i raho’ Iehovày amy antoandro niengà’ iereo i tobeiy. ");
INSERT INTO tdx_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Aa ndra mbia’ mbia ty nionjona’ i vatam-pañinay le niongake t’i Mosè nanao ty ti-hoe: Miongaha, ry Iehovà, abaibaio o rafelahi’oo vaho ampitribaho an-day añatrefa’o o malaiñe Azoo. ");
INSERT INTO tdx_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ie nitsangañe, le ty hoe ka ty nanoe’e: Mimpolia ry Iehovà amo alealem-pifokoa’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Ie añe, le niñeoñeoñe hoe mpitoreo an-kasotriañe, an-dravembia’ Iehovà ondatio, aa ie jinanji’ Iehovà, le niviañe ty haviñera’e, naho nisolebotse am’ iareo ty afo’ Iehovà, namorototo ty añ’ olo’ i tobey. ");
INSERT INTO tdx_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Aa le nikaikaik’ amy Mosè ondatio naho nihalaly am’ Iehovà t’i Mosè vaho nakipeke i afoy. ");
INSERT INTO tdx_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Aa le natao’e ty hoe Taberà i taney amy te niforehetse am’iareo ty afo’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Teo te nivariñe an-kasijý o piaroteñe am’iareoo; mbore nibabababa ka o ana’ Israeleo ami’ty hoe: Ia ty hanjotso hena ama’ay? ");
INSERT INTO tdx_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Tiahi’ay o fiañe nikamae’ay tsy amam-bili’e e Mitsraime añeo naho ty kiseny, ty vazavo, ty foti-voly, ty tangolo vaho o tangolo-laio; ");
INSERT INTO tdx_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","fe mifoezapoezake henaneo; tsy ino ty aolom-pihaino’ay, naho tsy ty màne tiañ’ avao! ");
INSERT INTO tdx_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Nanahake voan’ ahepoty i maney fe nimena hoe vañemba. ");
INSERT INTO tdx_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Namory aze mbeo’ mbeo ondatio, le ke dinemodemo’e am-bato fandisañañe, he nilisane’e an-deoñe, naho nahandroeñe am-balàñe vaho namboareñe mofo-vonga’e; ty hafiri’e le hoe mofo natoñak’ ami’ty menake. ");
INSERT INTO tdx_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Nivotrak’ amy tobey ty zono te haleñe le nindre nihintsañe ama’e i maney. ");
INSERT INTO tdx_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Ie jinanji’ i Mosè ty fangoihoi’ ondatio, nanitsike o hasavereña’eo, songa lahilahy an-dalan-kiboho’e eo, le nisolebotse ty haviñera’ Iehovà; toe niboseke ka t’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Aa le hoe t’i Mosè am’ Iehovà, Ino ty nanotria’o i mpitoro’oy? Le manao akore t’ie tsy nahaonim-pañisohañe am-pivazohoa’o, kanao nampijinia’o o kilanka’ ondaty iaby retiañe? ");
INSERT INTO tdx_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Izaho hao ty nampi­tson­kèreñe ondatio? Izaho hao ty rae’ iareo, kanao anoa’o ty hoe: Otroño añ’araña’o ao manahake ty fiotroña’ ty mpiatrak’ ajaja, pak’an-tane nifanta’o aman-droae’ iareo? ");
INSERT INTO tdx_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Aia ty hahatreavako hena hazotsoko am’ ondatio? Ami’ty fitoreova’ iareo ty hoe, Meo hena ho kamae’ay! ");
INSERT INTO tdx_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Tsy leoko vavèñe ondaty retia, izaho raike, fa loho mavesatse amako. ");
INSERT INTO tdx_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Aa naho zao ty anoa’o ahy le ehe avetraho am-pañohofan-doza, naho toe nahatrea fañisohañe am-pivazohoa’o, fa ko apo’o ho treako o faloviloviakoo! ");
INSERT INTO tdx_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Aa le hoe t’Iehovà amy Mosè: Anontoño ondaty fitompolo amo roandria’ Israeleo, ze fohi’o te mpiaolo’ ondatio naho mpameleke iareo; le ampihovao mb’ an-kibohom-pamantañam-beo, hitrao-pijohañe ama’o. ");
INSERT INTO tdx_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Le hizotso mb’eo iraho hifanaontsy ama’o, le handivako am’ iereo i Arofo ama’oy vaho hitrao-pivave ama’o ondatio, soa te tsy ihe avao ty hivave. ");
INSERT INTO tdx_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Le ano ty hoe amy màroy, Miefera vatañe ho ami’ ty hamaray, fa hikama hena amy niroveta’ areo am-pijanjiña’ Iehovà ami’ty hoe, Ia ty hanjotso hena ama’ay? Ie nierañerañe’ e Mitsraime añe. Aa le hanjotsoa’ Iehovà hena, vaho hikama nahareo. ");
INSERT INTO tdx_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Tsy indraik’ andro ty hikama’areo, tsy roe andro, tsy lime andro, tsy folo andro, tsy roapolo andro, ");
INSERT INTO tdx_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","fa volañe raike, ampara’ te miakatse am-piantsona’ areo vaho hampangorý anahareo, amy te nisirikae’ areo t’Iehovà añivo’ areo ao, ie nangololoike añatrefa’e ami’ty hoe, Ino ty niavotan-tika amy Mitsraime? ");
INSERT INTO tdx_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Aa hoe t’i Mosè, Lahin-defo enen-ketse o mañariseho ahio; Ihe manao amako ty hoe, Hanjotsoako hena hikama’ iareo volañe raike. ");
INSERT INTO tdx_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Handentàñe añondry naho añombe hao, hahatsake iareo? Ke hanontonañe ze hene fiañe an-driak’ ao? ");
INSERT INTO tdx_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Le hoe t’Iehovà amy Mosè, Nitomoreñe hao ty fità’ Iehovà? Mbe ho oni’o aniany ke ho tafetetse i rehakoy ke tsie. ");
INSERT INTO tdx_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Aa le niakatse añe t’i Mosè naho sinaontsi’e am’ iereo i tsara’ Iehovày, le natonto’e t’indaty fitompolo amo roandria’ ondatio vaho najado’e añariari’ i kivohoy. ");
INSERT INTO tdx_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Le nizotso amy rahoñey t’Iehovà nangalak’ amy Arofo ama’ey vaho natolo’e amy roandriañe fitompolo rey; ie nivotraha’ i Arofoy le nitoky, fe tsy ho nainai’e. ");
INSERT INTO tdx_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Toe mbe nitambatse an-tobe ao t’indaty roe ama’e: i Eldade ty tahina ty raike naho i Medade ty tahina’ ty raike, vaho nivotrak’ am’iereo i Arofoy. Toe sinokitse iereo fe tsy nañavelo mb’ amy kivohoy mb’eo, fa nitoky an-tobe ao. ");
INSERT INTO tdx_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Le nihitrihitry mb’amy Mosè mb’eo ty ajalahy nitalily ama’e ty hoe: Mitoky an-tobe ao t’i Eldade naho i Medade. ");
INSERT INTO tdx_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Aa le hoe ty natoi’ Iehosoa ana’ i None, mpiamy Mosè ampara’ ty nahaajalahy aze: O talèko, rarao iereo! ");
INSERT INTO tdx_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Le hoe t’i Mosè ama’e, Mamarahy ahy v-iheo? Ee te songa nimpitoky ondati’ Iehovào, naho sindre nampivotraha’ Iehovà i Arofo’ey! ");
INSERT INTO tdx_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Aa le nimpoly mb’an-tobe mb’eo t’i Mosè naho o roandria’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Aa le boak’ am’ Iehovà ty tioke ninday hatrakatrake hirik’ an-driak’ añe, le nampipoha’e marine i tobey ie nahatakatse lia’ andro raike mb’atia vaho lia’andro raike mb’eroa añariari’ i tobey; ni-roe kiho ambone’ i taney varañe ty fitoabo’e. ");
INSERT INTO tdx_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Aa le nifanehak’ amy àndroy naho amy haleñey naho amy loakandroy ondatio nijohañe ey nanontoñe o hatrakatrakeo le ze nanontoñe tsy ampe mbe nahatsake folo homere; vaho songa nandafike ty aze marine i tobey. ");
INSERT INTO tdx_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Fe mbe añivom-pamotsi’e ao i henay ie mbe tsy nitotoe’e, le nisolebotse am’ iereo ty haviñera’ Iehovà vaho pinao’ Iehovà ami’ty angorosy loza. ");
INSERT INTO tdx_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Aa le natao’e Kibrate Hata’avà i taney amy te eo ty nandentehañe ondaty aman-kadrao. ");
INSERT INTO tdx_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Boake Kibrate Hata’avà ao ondatio ro nangovovòke imb’e Katserote mb’eo vaho nitobe e Katserote añe. ");
INSERT INTO tdx_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Ie amy zao, nifosae’ i Miriame naho i Aharone t’i Mosè amy nte-Kose nengae’ey; ie nañenga ampela nte-Kose ho tañanjomba’e. ");
INSERT INTO tdx_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Le hoe iereo, I Mosè avao hao ty nampi­tsara’ Iehovà? Tsy itika ka hao ty nilañonà’e. Jinanji’ Iehovà izay. ");
INSERT INTO tdx_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Toe ondaty nimpirè-batañe t’i Mosè, lombolombo ze hene ondaty ambone ty tane toy. ");
INSERT INTO tdx_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Aa le nanao ty hoe amy Mosè naho i Aharone vaho i Miriame amy zao t’Iehovà, Akia nahareo telo, mb’ an-kibohom-pamantañañe mb’eo! Aa le niavotse mb’eo i telo rey. ");
INSERT INTO tdx_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Nizotso amy rahoñe nijoalay t’Iehovà naho nijohañe an-dalambei’ i kivohoy vaho kinanji’e t’i Aharone naho i Miriame le niheo mb’eo iereo roe. ");
INSERT INTO tdx_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Le hoe re, Janjiño o entakoo: naho ama’ Iehovà ty mpitoky le anoñonako vatañe añ’ aroñaroñe vaho itaroñako ami’ty nofy. ");
INSERT INTO tdx_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Fe tsy izay amy Mosè mpitoroko; Ie matoe amy hene trañokoy. ");
INSERT INTO tdx_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ie ty taroñako falie am-palie, an-kazavàñe fa tsy aman-drazan-tsara; ie ty mahaisake ty talinjo’ Iehovà. Tsy nahahembañe anahareo hao ty nañinje i Mosè mpitorokoy? ");
INSERT INTO tdx_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Aa le nisolebotse am’ iereo ty haviñera’ Iehovà, le nienga re. ");
INSERT INTO tdx_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Aa naho nienga boak’ ambone’ i kivohoy i rahoñey le nizoeñe te angamae t’i Miriame, foty mika­tsatsaoke. Ie nitolik’ amy Miriame t’i Aharone, nizoe’e te angamae. ");
INSERT INTO tdx_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Le hoe t’i Aharone amy Mosè, O ry talèko! miambane ama’o, ko apo’o ama’ay i fandilara’aiy, i hakeo nanoe’ay an-kagegeañey. ");
INSERT INTO tdx_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ehe ko ampi­hambañe’o ami’ty lolo niboloañe boak’ an-tron-drene’e ao, ie fa voroke ty antsasa’ o nofo’eo. ");
INSERT INTO tdx_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Aa le nitoreo am’ Iehovà t’i Mosè nanao ty hoe, Ry Andrianañahare, mihalaly ama’o: Jangaño re! ");
INSERT INTO tdx_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Le hoe t’i Iehovà amy Mosè, Naho nitsorihan-drae’e an-tarehe’e, tsy ho nivavè’e fito andro hao ty hasalara’e? Aa le adono re hagabeñe alafe’ i tobey fito andro; ie modo le rambeseñe indraike. ");
INSERT INTO tdx_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Aa le narindriñe alafe’ i tobey fito andro t’i Miriame; le tsy nionjoñe ka ondatio am-para’ te nampihovaeñe ao indraike t’i Miriame. ");
INSERT INTO tdx_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Añe izay le nienga i Katserote ondatio nitobe am-patrambei’ i Parane añe. ");
INSERT INTO tdx_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Hoe ty nitsara’ Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Añiraho ondaty hitingañe an-tane Kanàne añe, ie hatoloko amo ana’ Israeleo, songa amantoho ondaty raike o fifoko­an-droae’eo, fonga mpamelek’ am’ iereo. ");
INSERT INTO tdx_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Aa le nampionjone’ i Mosè boak’ am-patrambei’ i Parane ao iereo ami’ ty nandilia’ Iehovà, songa mpiaolo’ o ana’ Israeleo indaty rey. ");
INSERT INTO tdx_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Aa le zao o tahina’ iareoo: tam-pifokoa’ i Reòbene, t’i Samoà ana’ i Zakore; ");
INSERT INTO tdx_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","tam-pifokoa’ i Simone t’i Safate ana’ i Horý; ");
INSERT INTO tdx_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","tam-pifokoa’ Iehodà t’i Kalebe ana’ Iefonè; ");
INSERT INTO tdx_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","tam-pifokoa’ Isakhare t’Igale ana’ Iosefe; ");
INSERT INTO tdx_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","tam-pifokoa’i Efraime t’i Hoseà ana’ i None; ");
INSERT INTO tdx_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","tam-pifokoa’ i Beniamène t’i Paltý ana’i Rafò; ");
INSERT INTO tdx_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","tam-pifokoa’ i Zebolone t’i Gadiele ana’i Sodý; ");
INSERT INTO tdx_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","tam-pifokoa’ Iosefe, tam-pifokoa’ i Menasè: t’i Gadý ana’ i Sosý; ");
INSERT INTO tdx_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","tam-pifokoa’ i Dane, t’i Amiele ana’ i Gemalý; ");
INSERT INTO tdx_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","tam-pifokoa’ i Asere t’i Setore ana’ i Mikhaele; ");
INSERT INTO tdx_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","tam-pifokoa’ i Naftalý t’i Nakhbý ana’ i Vofsý; ");
INSERT INTO tdx_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","tam-pifokoa’i Gade, t’i Geoele ana’ i Makhý; ");
INSERT INTO tdx_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Ie ro tahina’ ondaty nafanto’ i Mosè hitingañe i taneio, le novae’ i Mosè ty tahina’ i Hoseà ho Iehosòa. ");
INSERT INTO tdx_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Aa le nirahe’ i Mosè iereo hitin­gañe an-tane Kanàne añe naho nafanto’e ty hoe: Mionjona mb’ amo Negeveo mb’eo vaho mañambonea mb’ am-bohibohitse añe, ");
INSERT INTO tdx_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","le isaho te inoñe i taney naho ondaty mimo­neñe aoo ke maozatse ke maifoifo, he tsy ampeampe he maro; ");
INSERT INTO tdx_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","le i tane imoneña’ iareoy, ke soa he raty; naho o rova itoboha’ iareoo ke t’ie tobe he arikoboñen-kijoly; ");
INSERT INTO tdx_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","le i taney ke kobokara he tsy mamokatse; ke mitiry hatae he tsie. Aa le mahasibeha vaho añandeso ty voka’ i taney. Toe san-doha-voam-balòboke henane zay. ");
INSERT INTO tdx_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Aa le nienga iereo nijoko boak’ am-patrambei’ i Tsine mb’e Rekhobe am-pimoaha’ i Hamate mb’eo. ");
INSERT INTO tdx_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Le nion­joñe mañatimo naho nigodam-b’e Kebrone naho Akimane naho e Sesaý vaho e Talmaý, mb’amo ana’ i Anàkeo mb’eo. (Naoreñe fito taoñe taolo’ i Tsoane e Mitsraime añe ty Kebrone.) ");
INSERT INTO tdx_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Le nivotrak’ am-bavatane’ Eskole eo iereo vaho nibira tsampam-baloboke rekets’ angaroza’e raike nampitarazoeñe ondaty roe am-baoñe, naho nangalak’ ampongabeindañitse vaho aviavy. ");
INSERT INTO tdx_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Natao Vavatane’ i Eskole i taney amy angaroza nihitsife’ o ana’ Israeleoy. ");
INSERT INTO tdx_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ie efa-polo andro añe le nimpoly i nitampoñe i taney rey, ");
INSERT INTO tdx_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","le niheo mb’amy Mosè naho i Aharone vaho i valobohò’ Israeley am-patram-bei’ i Parane e Kadese mb’eo ninday saontsy ama’e naho amy valobohò’ Israele iabiy, vaho naboa’ iereo ty voka’ i taney. ");
INSERT INTO tdx_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Le hoe ty natalili’ iareo ama’e, Nigodañe’ay i tane’ nañiraha’o anaiy. Toe iorikorihan-dronono naho tantele, hehe ty voka’e. ");
INSERT INTO tdx_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Fe misañatse ondaty mimo­neñe amo taneo; le fahe­ran-kijoly fatratse o rova’eo vaho jaba­jaba; mbore nioni’ay ao o ana’ i Anàkeo. ");
INSERT INTO tdx_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Mimo­neñe an-tane atimo ao o nte-Amalekeo; le mimoneñe am-bohibohitse ao o nte-Kheteo naho o nte-Ie­bosèo vaho o nte-Amareo; le mimo­neñe añ’ olo’ i riakey naho añ’ olo’ i saka Iardeney o nte-Kanàneo. ");
INSERT INTO tdx_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Nampianjiñe’ i Kalebe añatrefa’ i Mosè ondatio, nanao ty hoe: Antao hionjoñe mb’eo amy zao hitavañe i taney, tsy kalafo te mahagiok’ aze tika. ");
INSERT INTO tdx_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Fe nanao ty hoe ondaty niharo-lia ama’eo: Tsy lefen-tika ty hionjoñe haname ondatio amy t’ie maozatse te aman-tika. ");
INSERT INTO tdx_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Le naboele’ iereo ty talily nahatsonevotse o ana’ Israeleo amy tane nitingane’ iereoy, ami’ty hoe: I tane niranga’ay mpitingañey, le tane mampibotseke o mpimone’eo, vaho mijoalajoala ze hene ondaty niisa’ay ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nioni’ay ondaty joakeo (toe tarira’ ondaty joake o nte-Anàkeo); le nihoe valala am-pañentea’ay zahay vaho zahay am-pahaisaha’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Aa le nañonjom-peo am-pangolalaihañe i valobohòkey, naho nangololoike ty rovetse amy haleñey ondatio, ");
INSERT INTO tdx_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","vaho nitoreo amy Mosè naho amy Aharone o ana’ Israele iabio; le nanoe’ i valobohòkey ty hoe, Ee t’ie nivetrak’ an-tane Mitsraime ao! Ndra kitra’e nikoromak’ am-patrambey atoa! ");
INSERT INTO tdx_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ino ty nandesa’ Iehovà mb’an-tane atoy ho tsingoritrìem-pibara reke-keleiañe ho tsindroke; tsy hàmake t’ie himpoly mb’e Mitsraime mb’eo? ");
INSERT INTO tdx_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Aa le hoe ty fivesoveso’ iareo, Antao hijoboñe mpiaolo vaho himpoly mb’e Mitsraime añe. ");
INSERT INTO tdx_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Nibabok’ an-daharañe añatrefa’ i fivorim-balobohò’ o ana’ Israeleoy amy zao t’i Mosè naho i Aharone. ");
INSERT INTO tdx_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","le nandriatse sarim­bo t’Iehosoa ana’ i None naho i Kalebe ana’ Iefonè, i nimpiamo nitingañe i taneio rey; ");
INSERT INTO tdx_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","le hoe ty enta’ iareo amy valobohò’ Israeley, I tane nirangà’ay mpitingañeo le tane loho fanjaka. ");
INSERT INTO tdx_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Aa naho noro’ Iehovà tika, le ie ty hanese naho hanolotse antika i taney, toe tane orikorihen-dronono naho tantele. ");
INSERT INTO tdx_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Aa ko miola am’ Iehovà, ko mireven­dreveñe am’ondati’ i taneio, ie fitsin­drohan-tika; toe nisitak’ am’ iereo ty fañarova’e vaho amantika t’Iehovà. Ko ihembañañe. ");
INSERT INTO tdx_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Fe vinola’ i fivoribey iabiy t’ie haretsam-bato, vaho niboak’ amo ana’ Israele iabio, an-kibohom-pamantañañe ey, ty enge’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Le hoe t’Iehovà amy Mosè, Pak’ ombia ty mbe hañinjea’ ondaty retiañe ahy? Ampara’ ombia t’ie mbe tsy hahafiato amako ty amo hene viloñe nanoeko añivo’ iereoo. ");
INSERT INTO tdx_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ho paoheko angorosy naho harotsako, vaho ihe ty hanoeko foko ra’elahy mandikoatse naho maozatse te ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Aa hoe t’i Mosè am’ Iehovà, Le ho tsanòñe’ o nte-Mitsraimeo, te i hao­zara’oy ty nañavota’o ondaty retiañe boak’ añivo’ iareo ao, ");
INSERT INTO tdx_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","le hatao’ iareo amo mpimone’ ty tane toio, te tsi­nano’ iereo te ihe ry Iehovà ro añivo’ ondaty retoañe, amy te Ihe ry Iehovà ro ifañatrefan-daharañe naho mitroatse ambone’ iereo i raho’oy, vaho ihe ro Fiaolo’ iareo amy rahoñe mijoalay te handro naho añ’afo mitiotiotse te haleñe. ");
INSERT INTO tdx_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Aa naho zamane’o hoe ondaty raike ondaty retiañe, le hanao ty hoe o tane iaby nahajanjiñe ty hara’elahi’oo, ");
INSERT INTO tdx_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Kanao tsy nahafanese ondaty retiañe mb’an-tane nitolora’e am-panta mb’eo t’Iehovà, le nimongore’e an-dratraratra añe. ");
INSERT INTO tdx_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Aa le ihalaliako, ehe ho ra’elahy ty haozara’ i Talè amy nitsarae’o ty hoe, ");
INSERT INTO tdx_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Malaon-kaviñerañe t’Iehovà naho lifo-pikokoa-migahiñe, mpampipoke hila naho fiòla, fe tsy apo’e ty manao hakeo, fa afetsa’e amo anakeo o tahin-droae’eo ami’ty tariratse faha-telo naho fahefatse. ");
INSERT INTO tdx_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Miambane ama’o, apoho ty hakeo’ ondaty retiañe amy hara’ elahin-kafatraram-pikokoa’oy, manahake ty nampidòna’o ty hakeo’ ondaty retiañe e Mitsraime añe pake henane. ");
INSERT INTO tdx_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Aa le hoe t’Iehovà, Fa napoko ty amy enta’oy; ");
INSERT INTO tdx_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","fe kanao velon-dRaho, ho lifore’ ty enge’ Iehovà ty tane toy, ");
INSERT INTO tdx_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","le ze hene ondaty nahaisake o engekoo naho o viloñe nanoeko e Mitsraime naho am-patram-beio, ie fa nitso-pañahy ahiko fañimpolo’e henaneo, vaho tsy nañaoñe ty feoko, ");
INSERT INTO tdx_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","toe tsy ho isa’ iareo i tane nifantàko aman-droae’ iareoy, toe tsy ho isa’ o nañinje Ahio, ");
INSERT INTO tdx_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","naho tsy i Kalebe mpitorokoy amy te hafa ty arofo ama’e le niventè’e t’ie mpañorik’ ahiko, aa le hendeseko mb’ an-tane nañaveloa’e mb’eo vaho ho lovae’ o tarira’eo. ");
INSERT INTO tdx_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Aa kanao mimo­neñe am-bavatane ao o nte-Amalekeo naho o nte-Kanàneo, le mivioña nahareo te hamaray, vaho mionjona mb’ am-patrambey mb’amy lalañe migodañe mb’an-dRia-Binda mb’eoy. ");
INSERT INTO tdx_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Le hoe ty nitsara’ Iehovà amy Mosè naho amy Aharone: ");
INSERT INTO tdx_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Pak’ombia ty hivaveako ty valobohòke lo-tsereke mañinje ahiko tia? Fa tsinanoko ty fiñeo­ñeo’ o ana’ Israeleo, ty fañinjea’ iareo ahiko. ");
INSERT INTO tdx_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Saontsio am’ iereo, Kanao velon-dRaho, hoe t’Iehovà, le hanoeko ama’ areo i sinaontsi’ areo an-tsofikoy; ");
INSERT INTO tdx_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","toe hipopok’ am-patram-bey atoa ty lolo’ areo, ze fonga nivolilieñe ama’ areo, ze hene niaheñe ama’ areo mifototse ami’ty roapolo taoñe mañambone amo nañinje Ahikoo. ");
INSERT INTO tdx_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Leo raike tsy himoak’ amy tane natoloko anahareo am-panta himoneña’ areoy, naho tsy i Kalebe ana’ Iefonè naho Iehosoa ana’ i None, ");
INSERT INTO tdx_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","le o amori’ areo kedekedeke natao’ areo ho tsindroheñeo; hendeseko ao iereo le ho fohi’ iareo i tane niheje’ areoy. ");
INSERT INTO tdx_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Inahareo ka, hifitak’ am-patrambey ao ty lolo’ areo, ");
INSERT INTO tdx_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","le hire­rerere am-patrambey ao efapolo taoñe o ana’ areoo, hivave ty hakarapiloa’ areo, ampara’ te vorok’ am-patrambey ao ty lolo’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Mira ami’ty ia’ o andro nitingane’ areo i taneio, i efa-polo andro rezay, te songa havale taoñe raike i andro rey, ho vave’ areo ty tahi’ areo, aa le efa-polo taoñe ty hahafohina’ areo ty habosehako. ");
INSERT INTO tdx_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Izaho Iehovà ty nitaro­ñe. Tsy mete tsy henefeko ami’ty valobohòke lo-tsereke nihipoke hiatreatre amako tia, ie habotse’ ty fatram-bey toy naho toe hihomak’ ao. ");
INSERT INTO tdx_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Le ondaty nirahe’ i Mosè hitin­gañe i taneio, o nimpoly ninday saontsy nampitoreo i valobohòkey amy talily raty nendese’ iereo i taneiio, ");
INSERT INTO tdx_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","le navetra’ ty angorosy añatrefa’ Iehovà ondaty ninday i talily raty ty amy taneio. ");
INSERT INTO tdx_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Iehosoa ana’ i None naho i Kalebe ana’ Iefonè avao ty mbe niveloñe amo nitingañe i taneio. ");
INSERT INTO tdx_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Aa le akore ty fihonto’ o ana’ Israeleo amy nitaroña’ i Mosè i entañe zaiy, ");
INSERT INTO tdx_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","kanao nivañoñe marain-tsikiake iereo niañambone’ i vohitsey, ami’ty hoe: Itoan-jahay, hanganike i nampitama’ Iehovà anaiy, fa nanao hakeo zahay. ");
INSERT INTO tdx_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Hoe ka t’i Mosè, Aa vaho akore te lilare’ areo ty lili’ Iehovà henaneo? Toe tsy ho tafetetse. ");
INSERT INTO tdx_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ko mionjoñe mb’eo tsy mone ho rotsaheñe añatrefan-drafelahi’ areo fa tsy mindre ama’ areo t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Aolo’ areo o nte-Amalekeo naho o nte-Kanàneo, le hampitsingoroem-pibara nahareo; amy te niambohoa’ areo t’Iehovà, vaho tsy hindreza’ Iehovà lia. ");
INSERT INTO tdx_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","F’ie nionjoñe tsinahy mb’an-tiotio’ i vohitsey mb’eo; fe tsy niakatse i tobey ka i vatam-pañina’ Iehovày ndra i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Aa le nizotso hiatreatre am’iareo o nte-Amalekeo naho o nte-Kanàne mpimo­neñe amy vohitseio, nandafa naho nandronje iareo sikala e Khormà añe. ");
INSERT INTO tdx_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Hhoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Misaontsia amo ana’ Israeleo, le ano ty hoe: Naho mimoak’ an-tane himoneña’ areo, i hatoloko anahareoy, ");
INSERT INTO tdx_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ie manao soroñe am’ Iehovà, ke enga ho lorañe he enga-ava-panta ke enga-tsatrin’ arofo he amo andro namantañañeo, le ho hàñin-kanintsiñe am’ Iehovà, he boak’ an-tro-raik’ ao ke boak’ an-dia-raike ao, ");
INSERT INTO tdx_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","le ze mibanabana enga añatrefa’ Iehovà ty hinday enga-mahakama, mona fahafolo’ ty efà linaro menake hine fahèfa’e, ");
INSERT INTO tdx_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","naho divay fahèfa’ ty hine ho enga-rano ihentseñañe, le ke amy soroñey, he amy engay, ho ami’ty vik’ añondry. ");
INSERT INTO tdx_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Aa naho añondrilahy, le ho hajarie’o ty mona roe ampahafolo’ ty efà linaro menak’ ampaha-telo’ ty hine ho enga-mahakama; ");
INSERT INTO tdx_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","le ho enga-rano: ibanabanao divay hine ampahatelo’e ho hàñin-kanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Aa naho mañenga bania hisoroñañe ke hañenek’ ava-panta, he ho fañanintsiñe am’ Iehovà, ");
INSERT INTO tdx_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","le hengaeñe mitraok’ amy baniay ty enga-mahakama: telo ampahafolo’ ty efà mona linaro menake hine vaki’e, ");
INSERT INTO tdx_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","le hengae’o ty divay hine vaki’e ho enga rano hisoroñañe, hàñin-kanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","I hoe zay ty ho sata amy ze añombe ndra añondrilahy, naho ze vik’ añondri­lahy ndra vik’ose. ");
INSERT INTO tdx_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Ty ami’ty hamaro ihentseñañe, le sindre anoeñe ty ami’ty ia’e. ");
INSERT INTO tdx_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Songa hanao izay ze samak’ amy taney, ie mañenga soroñe ho hàñin-kanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Aa naho mitaveañe ama’ areo ty renetane, ke ia ia hom’bama’ areo amo tarira’ areo iabio, ie te hañenga soroñe ho hàñin-kanintsiñe am’ Iehovà; le mira ami’ty fanoe’ areo ty hanoe’e. ");
INSERT INTO tdx_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Amy valobohòkey, fañè raike ty hifehe anahareo naho i renetane mpimoneñe aoy, fañè nainai’e tsy modo amo hene tarira’ areo mifandimbeo; manahak’ anahareo avao ze renetane añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Fetse raike naho fepetse raike ty anahareo naho ze renetane mpitaveañe ama’ areo ao. ");
INSERT INTO tdx_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Saontsio ty hoe amo ana’ Israeleo: Ie mimoak’ amy tane aneseako anahareoy ao, ");
INSERT INTO tdx_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","naho mikama amy mahakama’ i taney le mañengà engan-kavoañe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Ami’ty valohan-koba’ areo ty hañengà’ areo mofo ho engan-kavoañe; hambañe ami’ty engan-toem-pifofohañe ty hañengà’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Hatolo’ areo ho enga am’ Iehovà ty lengon-koba valoha’e, hengae’ o hene tarira’ areo mifandimbeo izay. ");
INSERT INTO tdx_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","Aa ie mandilatse tsy mahambeñe o lily retiañe, o nitsarae’ Iehovà amy Mosèo— ");
INSERT INTO tdx_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","toe ze hene tsara linili’ Iehovà am-pità’ i Mosè, ampara’ i andro nitaroña’ Iehovà i liliy pak’ amo hene tarira’ areoo— ");
INSERT INTO tdx_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ie amy zao, naho mandilatse tsy satrie’e i valobohòkey, ie nietak’ am-pihaino’e, le hengae’ i valobohòkey ty ana’ ty tro’e raike, ty bania hisoroñañe ho hàñin-kanintsiñe am’ Iehovà rekets’ i enga-mahakama’ey naho i enga-rano’ey, am-pañè, vaho ty vik’oselahy ho engan-kakeo. ");
INSERT INTO tdx_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Le hijebaña’ i mpisoroñey i valobohò’ Israeley vaho ho haha iereo kanao tsy nisatrieñe, naho fa nasese’ iereo i enga’ iareoy; enga nisoroñañe am’ Iehovà, naho i engan-kakeo nengaeñe añatrefa’ Iehovày, amy fandilara’ iareoy. ");
INSERT INTO tdx_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Aa le hapoke t’ie tsy ho ami’ty valobohò’ Israele naho tsy ho amo renetane mpimoneñe ama’eo, amy te songa añate’ i lilatse tsy nisatrieñey i màroy. ");
INSERT INTO tdx_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Aa naho ondaty raike ty mandilatse tsy satrie’e, le hengae’e ty vik’ose vave’e ho engan-kakeo, ");
INSERT INTO tdx_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","le hanao fijebañañe i mpisoroñey ho am’ indaty nandilatse tsy an-tsatrie’ey, ie toe nandilatse fe tsy nitsatrie’e, añatrefa’ Iehovà, hañeferañe aze, le halio-tahiñe. ");
INSERT INTO tdx_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Ho raike ty fetse mifehe ze mandilatse tsy satrie’e, ke tarira’ o ana’ Israeleo, he renetane mpitaveañe am’ iereo ao. ");
INSERT INTO tdx_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Fe t’indaty mañonjo haoke handilatse, ke ie samak’ amy taney ao, ke renetane, ie manirika Iehovà, le haitoañe am’ on­dati’eo indatiy, ");
INSERT INTO tdx_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","amy te ninjè’e ty tsara’ Iehovà naho niotà’e i lili’ey, toe haitoañe za­fezanake indatiy vaho ho vavè’e i hakeo’ey. ");
INSERT INTO tdx_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Ie tam-patrambey añe o ana’ Israeleo le nahaisake ondaty nanontoñe hatae ami’ty andro Sabotse. ");
INSERT INTO tdx_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Aa le nasese’ o nahaisak’ aze nanontoñe hataeo mb’ amy Mosè naho i Aharone vaho i valobohòkey mb’eo; ");
INSERT INTO tdx_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","le najo’ iareo an-drohy ao heike fa mbe tsy nitsaraeñe ty hanoañe aze. ");
INSERT INTO tdx_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Le hoe t’Iehovà amy Mosè, tsy mete tsy havetrake indatiy; songa handretsake vat o ama’e alafe’ i tobey i valobohòkey. ");
INSERT INTO tdx_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Aa le amy nandilia’ Iehovà i Mosèy: nasese’ i valobohòkey alafe’ i tobey re naho rinetsam-bato vaho nihomake. ");
INSERT INTO tdx_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Misaontsia amo ana’Israeleo ty hanoa’ iereo fole mirandrañe an-kotson-tsaro’ iareo nainai’e amo hene tarira’ iareo mifandimbeo, songa haharo’ iareo amo fole mirandrañe an-kotson-tsaroñeo ty fole manga. ");
INSERT INTO tdx_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Ty sata’ o boram-poleo ama’ areo, le ie isa’ areo ro hahatiahy o lili’ Iehovà iabio vaho hanoe’ areo, soa tsy horihe’ areo ty arofo’ areo naho o fihaino’ areo mampandrì­keo, ");
INSERT INTO tdx_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","fa ho tiahi’ areo le hene hanoe’ areo o lilikoo, vaho hiavake ho aman’ Añahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Izaho Iehovà Andrianañahare’ areo ninday anahareo nienga an-tane Mitsraime añe ho Andrianañahare’ areo: Izaho Iehovà Andrianañahare’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ie amy zao, niavotse t’i Korahk’ ana’ Itsare ana’ i Kehàte fifokoa’ i Levy reketse i Datane naho i Abirame songa ana’ i Eliabe vaho i One, ana’ i Pelete tarira’ i Reòbene, ");
INSERT INTO tdx_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","le nijohañe aolo’ i Mosè eo mindre ami’ty ila’ o ana’ Israeleo, mpiaolo’ i valobohòkey, roanjato-tsi-limampolo, jinoboñe am-pivory, aman-kasy; ");
INSERT INTO tdx_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","nifanontoñe hiatrek’ amy Mosè naho i Aharone vaho nanoe’ iareo ty hoe, Loho bey ty vavea’ areo, amy te fonga miavake i valobohòkey naho am’ iareo iaby t’Iehovà. Aa ino ty irengevoha’ areo ambone’ ty fivori’ Iehovà? ");
INSERT INTO tdx_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Ie jinanji’ i Mosè, le nibabok’ an-dahara’e, ");
INSERT INTO tdx_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","nanao ty hoe amy Korahke naho o mpiama’e iabio: Hamaray ty hampiboaha’ Iehovà o azeo, ty miavake, le ie ty hampañarinea’e; toe i ho joboñe’ey ty hampitotofa’e. ");
INSERT INTO tdx_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Ano zao: ry Korahke naho o mpiama’o iabio, andrambeso sadron’ afo, ");
INSERT INTO tdx_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","le apoho ama’e ty afo naho andafiho embok’ añatrefa’ Iehovà hamaray vaho t’indaty joboñe’ Iehovà, ie ty hiavake. Fa loho maro ty vavea’ areo ry nte-Levio! ");
INSERT INTO tdx_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Le hoe t’i Mosè amy Korahke, Mitsendreña henaneo ry ana’ i Levio: ");
INSERT INTO tdx_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Loho kede ama’ areo hao t’ie nampiambahen’ Añahare’ Israele amo valobohò’ Israeleo hampañarinea’e, hitoloñe amy kivoho’ Iehovày ao, hijohañe añatrefa’ i valobohòkey hiatrak’ iareo, ");
INSERT INTO tdx_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","ie nampañarivoe’e ama’e mitraok’ amo rahalahi’o ana’ i Levio? Aa mbe hipay ho mpisoroñe ka v’iheo? ");
INSERT INTO tdx_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","kanao mifanontoñe hiatreatre am’ Iehovà, ihe naho o mpiama’o iabio. Le i Aharone, inon-dre te injè’ areo? ");
INSERT INTO tdx_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Nampañitrife’ i Mosè amy zao t’i Datane naho i Abirame ana’ i Eliabe, fa hoe iereo: Tsy homb’eo zahay! ");
INSERT INTO tdx_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","raha kede ama’o hao te nakare’o an-tane orikorihen-dronono naho tantele ao hanjamana’o am-patrambey atoy, mbore manao ho mpifehe anay? ");
INSERT INTO tdx_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ie amy zao tsy nendese’o amy ze o tane orikorihen-dronono naho tantele zao, tsy nampandovae’o anay ty teteke naho tetem-bahe. Aa vaho havitso’o am’ondaty retiañe o fihaino’ iareoo? Zahay tsy homb’eo! ");
INSERT INTO tdx_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Niforoforo t’i Mosè le hoe re am’ Iehovà, Amoeo ty enga’ iareo. Mbe liako tsy nandrambe borìke raik’ am’ iereo vaho leo raik’ am’iereo tsy jinoiko. ");
INSERT INTO tdx_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Le hoe t’i Mosè amy Korahke, Miatrefa am’ Iehovà, ihe naho o mpiama’oo—ihe naho iereo vaho i Aharone te maray; ");
INSERT INTO tdx_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","songa mindesa sadron’ afo vaho apoho ama’e ty emboke, sindre hinday ty sadròn’ afo’e añatrefa’ Iehovà, sadron’ afo roanjato-tsi-limampolo; ihe naho i Aharone ka, sambe aman-tsadron’ afo. ");
INSERT INTO tdx_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Aa le fonga nandrambe ty sadron’ afo’e t’indaty, naho napo’e ama’e ty afo naho nandafihan’ emboke vaho nijohañe an-dalan-kibohom-pamantañañe eo mindre amy Mosè naho i Aharone. ");
INSERT INTO tdx_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Le navori’ i Korahk’ an-dalan-kibohom-pamantañañe ey i valobohòkey hiatreatre iareo. Nisodehañe amy màroy amy zao ty enge’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Le hoe ty nitsara’ Iehovà amy Mosè naho i Aharone: ");
INSERT INTO tdx_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Mivevea amo valobohòkeo fa hampangotomomoheko aniany. ");
INSERT INTO tdx_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Nibabok’ an-dahara’e amy zao iereo nihalaly ty hoe, O Andrianañahare, Andrianañaharen’ arofo’ ze hene atao nofotse; hiviñera’o ami’ty lila’ ondaty raike hao i valobohòkey? ");
INSERT INTO tdx_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Aa le hoe ty nitsara’ Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Saontsio amo valobohòkeo ty hoe: Iengao o kiboho’ i Korahke naho i Datane vaho i Abirameo. ");
INSERT INTO tdx_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Le niongake t’i Mosè nimb’amy Datane naho i Abirame mb’eo; nanonjohy aze o roandria’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Le sinaontsi’e amy valobohòkey ty hoe, Isitaho henaneo o kiboho’ ondaty lo-tsereke reroañe! Ko mitsapa ty raha’ iareo tsy mone ho faoheñe añe amo hakeo’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Aa le niviha’ iereo o kiboho’ i Korahke naho i Datane naho i Abirameo; le niakatse t’i Datane naho i Abirame vaho nijohañe an-dalan-kiboho’e eo rekets’ o tañanjomba’eo naho o ana’eo naho o amori’eo. ");
INSERT INTO tdx_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Le hoe t’i Mosè: Inao ty hahafohina’ areo t’ie nirahe’ Iehovà hanao o tolon-draha rezao, tsy te nisatriko: ");
INSERT INTO tdx_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Aa naho mikoromake manahake ze hene ondaty, ondaty retiañe, naho ho tiliheñe hambañe ami’ ty fitilihañe ze kila ondaty, le tsy nirahe’ Iehovà iraho. ");
INSERT INTO tdx_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Fa naho manao raha vao t’Iehovà, naho sokafe’ o taneo ty vava’e, hampibotseke iareo naho ze hene a’ iareo vaho hivarigodam-beloñe mb’ an-tsikeokeok’ ao, le ho fohi’ areo te ninjè’ ondatio t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Ie vaho nimodo i saontsi’ey le nivalaetrake ambane’ iereo i taney, ");
INSERT INTO tdx_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","vaho sinoka’ i taney ty vava’e le fonga na­bea’e rekets’ o hasavereña’ iareoo, ze lahilahy mpiamy Korahke naho o vara’e iabio. ");
INSERT INTO tdx_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Aa le nigodam-beloñe mb’ an-tsikeokeok’ ao iereo reke-panañañ’ iaby; nikitek’ ambone’e i taney, naho fa nimongoreñe amy valobohokey iereo. ");
INSERT INTO tdx_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Le nitriban-day iaby ze ana’ Israele narine eo, naman­tsiñe ty hoe, Ke hatele’ i taney ka zahay! ");
INSERT INTO tdx_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Niboak’ am’ Iehovà amy zao ty afo nahaforototo ‘indaty roanjato-tsi-limampolo nañemboke rey. ");
INSERT INTO tdx_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Le natoro’ Iehovà amy Mosè ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Misaontsia amy Elazare ana’ i Aharone Mpisoroñe handrambesa’e o sadron’ afo boak’ amy afoio, le hampiparatsahe’e ey i afoy, fa miavake irezay. ");
INSERT INTO tdx_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Ampipeho ho endraendra hanaroñe i kitreliy o sadron’ afo’ ondaty rinotsan-kakeo ty fiai’iareoo, fa miavake amy te nengaeñe am’ Iehovà, le ho viloñe amo ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Aa le rinambe’ i Elazare mpisoroñe o sadron’ afo torisìke nengae’ i niforototoeñe reio, vaho nipepeheñe ho kape’ i kitreliy, ");
INSERT INTO tdx_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ho faniahiañe o ana’ Israeleo te tsy hitotoke mb’eo ty ondaty sotra tsy tarira’ i Aharone hañembok’ am’ Iehovà, tsy mone hanahake i Korahke naho o mpiama’eo, amy nitsara’ Iehovà am-pità’ i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Ie amy loakandroy le fonga niñeoñeoñe amy Mosè naho i Aharone i valobohòn’ ana’ Israeley ami’ty hoe, Fa zinama’ areo ondati’ Iehovào. ");
INSERT INTO tdx_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Aa naho nifanontoñe i valobohòkey hiatreatre amy Mosè naho amy Aharone, f’ie nitolike mb’ an-kibohom-pamantañam-b’eo le hehe te nisaroña’ i rahoñey vaho niboake ty enge’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Aa le niheo mb’ aolo’ i kibohom-pamantañañey mb’eo t’i Mosè naho i Aharone. ");
INSERT INTO tdx_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Le nitsara amy Mosè t’Iehovà nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Isitaho o valobohòkeo hamorototoako aniany. Ie nibabok’ an-daharañe, ");
INSERT INTO tdx_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","le hoe t’i Mosè amy Aharone, Angalao sadron’ afo le apoho ama’e ty afo boak’ amy kitreliy, le ampipoho emboke naho mihitrifa masìka mb’amy valobohòkey ho fijebañañe iareo amy te niboak’ am’ Iehovà ty fombo vaho fa namototse i angorosiy. ");
INSERT INTO tdx_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aa ie mbe nisaontsy t’i Mosè, le rinambe’ i Aharone izay le nipitsik’ an-day naneñateña i valobohòkey; naho tendreke te niorotse am’ ondatio i angorosiy; Napo’e ama’e ty emboke vaho nijebañe ondatio. ");
INSERT INTO tdx_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Aa ie nijohañe añivo’ o mateo naho o veloñeo le nijihetse i angorosiy. ");
INSERT INTO tdx_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Rai-ale-tsi-efats’ arivo-tsi-fitonjato ty nivetrak’ amy andro zay mandikoatse o nikoromak’ amy Korahkeio. ");
INSERT INTO tdx_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Ie nijihetse i angorosiy le nibalike mb’ amy Mosè t’i Aharone mb’an-dalan-kibohom-pamantañañe mb’eo. ");
INSERT INTO tdx_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","Misaontsia amo ana’ Israeleo naho mangala kobay amo anjomban-droae iabio, ze talèn’ anjomban-droae—kobay folo-ro’amby, ie songa hanokitse ty tahina’e amy kobai’ey. ");
INSERT INTO tdx_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","Le sokiro an-kobai’ i Levy eo ty tahina’ i Aharone. Sindre kobain-droae raike ami’ty talèn’ anjomban-droae’ey, vaho ");
INSERT INTO tdx_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","apoho an-kibohom-pamantañañe aolo’ i fañina fifampikaoñan-tikañey. ");
INSERT INTO tdx_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Ie amy zao, hitaroke ty kobai’ ondaty ho joboñeko; le hijihetse ty fitoreo’ o ana’ Israeleo amako, i fiñeo­ñeoñe ama’o lomoñandroy. ");
INSERT INTO tdx_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Aa le nisaontsy amo ana’ Israeleo t’i Mosè vaho songa nanolotse kobay raike o talèo, ty aman-talèn’ anjomban-droae’e; kobay folo-ro’ amby; le nitraok’ amo kobai’ iareoo ty kobai’ i Aharone ");
INSERT INTO tdx_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","vaho napo’ i Mosè añatrefa’ Iehovà amy kibohom-pañinay i kobaiñe rey. ");
INSERT INTO tdx_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Aa naho nimoak’ amy kibohom-pañinay t’i Mosè te loak’andro, hehe te nitaroke naho namotiboty naho namòñe vaho namoa mahabibo àñoñe ty kobai’ i Aharone añ’anjomba’ i Levy. ");
INSERT INTO tdx_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Le naaka’ i Mosè boak’ añatrefa’ Iehovà mb’ amo ana’ Israele iabio i kobay rey; nahaisake iereo vaho sambe nandrambe ty kobai’e. ");
INSERT INTO tdx_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Le hoe t’Iehovà amy Mosè, Ampolio aolo’ i fañinay ty kobai’ i Aharone ho viloñe amo manjehatseo, hampigadoñe ty fañinjea’ iareo ahy tsy mone hikenkañe. ");
INSERT INTO tdx_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Aa le nanoe’ i Mosè izay; i nandilia’ Iehovà azey ty nanoe’e. ");
INSERT INTO tdx_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Le hoe o ana’Israeleo amy Mosè, Mihamomoke zahay, motso, fonga mongotse! ");
INSERT INTO tdx_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Ndra iaia mitotoke mb’eo, naho mañarine i kivoho’ Iehovày le havetrake. Kila hibanìtse hao zahay? ");
INSERT INTO tdx_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Hoe ty nitsara’ Iehovà amy Aharone: Ihe naho o anadahi’oo miharo amo anjomban-droae’oo ro hivave o hakeo’ i efe-miavakey, le ihe rekets’ o anadahi’oo ro hivave o tahi’ i fisoroñañeio. ");
INSERT INTO tdx_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Aa le endeso mb’ etoa ka o rahalahi’oo, i fifokoa’ i Leviy, i fifokoan-droae’oy, hireketse ama’o, hitoroñe azo, ihe naho o ana’oo, añatrefa’ i kibohom-pañinay. ");
INSERT INTO tdx_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Hiatrak’ azo iereo vaho hañambeñe i kivoho iabiy, fe tsy harinea’ iareo o fana’ i efe-miavakeio naho i kitreliy tsy mone hivetrake, ie naho inahareo. ");
INSERT INTO tdx_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Hampireketeñe ama’o iereo hamandroñe i kibohom-pamantañañey amy ze hene fitoloñañe amy kivohoy fe tsy hiharinea’ t’indaty tsotra. ");
INSERT INTO tdx_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Le ho toloñe’ areo o raha miavakeo, hatrafe’ areo i kitreliy, tsy hifetsahan-kaviñerañe o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Le Izaho, toe Izaho ty nandrambe o nte-Levy rahalahi’ areoo boak’amo ana’ Israeleo, ie nengaeñe ho ravoravo am’ Iehovà ho anahareo, hanoe’e o fitoroñañe an-kibohom-pamantañañeo. ");
INSERT INTO tdx_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Le ihe naho o ana’o rekets’ ama’oo ro hañambeñe o fisoroña’ areoo amy ze hene mioza amy kitreliy, le ho toroñe’ areo ze ankalo’ i lamba fañefetsey ao. Atoloko azo ho fitoroñan-karavòañe i fisoroñañey, fe havetrake ze ondaty tsotra miharine eo. ");
INSERT INTO tdx_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Hoe ty nitsara’ Iehovà amy Aharone: Izaho, toe Izaho ty nanolots’ azo o engan-kavoakoo, le navìko ho azo naho o ana’oo ho amy fañorizañey ze hene navi’ o ana’ Israeleo. Natoloko ami’ty fañorizañe naho amo o ana’oo ho fañè nainai’e. ");
INSERT INTO tdx_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ho azo amo raha miava-do’e navotso­tse amy afoio; ze hene enga’ iareo: ze enga-mahakama iaby, ze soron-kakeo iaby; ze hene engan-dilatse mete ho banabanae’ iereo amako, ho miava-do’e ama’o naho amo ana’oo. ");
INSERT INTO tdx_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Ho kamae’ areo an-toetse miavake ao, ze lahilahy iaby ty hikama ama’e, fa navaheñe ho ama’o. ");
INSERT INTO tdx_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ho azo ty enga-kavoañe amo engae’ iareoo, naho ze enga ahelahela’ o ana’ Israeleo, le fa natoloko azo naho amo ana-dahi’oo naho amo anak’ ampela’o mindre ama’oo ho fañè nainai’e, ie mete kamae’ ze malio añ’ anjomba’o ao. ");
INSERT INTO tdx_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Fa natoloko azo ze hene soa amo menakeo naho ze fonga soa amo divai-vaoo naho amy ampembay: ty loha-voñe engae’ iereo am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Azo ze hene lengom-boa an-tane’e añe engae’ iereo am’ Iehovào, songa mete mikama ama’e ze malio añ’anjomba’o ao. ");
INSERT INTO tdx_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Hene azo ze atokañe e Israele ao. ");
INSERT INTO tdx_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Azo ka ze manoka-koviñe valoha’e, ze engaeñe am’ Iehovà, he ondaty ke hare; fe toe ho jebañeñe o tañoloñoloña’ ondatio, vaho havahañe ka ze valohan’ ana’ o biby tsy malioo. ");
INSERT INTO tdx_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Le ty vilin’ ai’e, mifototse amy valò­ham-bola’ey ty ijebañañe aze; ze anjoanjoa’ o azey, sekele lime ty vili’e an-tseke­len-toe-miavake (gerà roapolo izay). ");
INSERT INTO tdx_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Fe tsy havaha’ areo ze valohan’ anak’ añombe naho valohan’ anak’ añondry naho ty valohan’ anak’ ose, fa miavake. Hadasi’ areo añariari’ i kitreliy ty lio vaho hisoroña’o ty safo’e ho enga olorañe, hàñin-kanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Le ho azo o hena’eo, ho azo hambañe amy tratran-kelahelay naho i tso’e havanay. ");
INSERT INTO tdx_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ze enga avoañe amo raha miavake engae’ o ana’ Israeleo am’ Iehovào le fa natoloko azo naho amo ana-dahi’oo naho amo anak’ ampela’o mindre ama’oo ho fañè tsy modo, ho fañinan-tsira nainai’e ama’o naho amo tarira’oo añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Le hoe t’Iehovà amy Aharone: tsy hanan-dova an-tane’ iareo irehe, naho tsy hanañ’ anjara am’ iereo ao; Izaho ro anjara’o naho lova’o amo ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Naho o nte-Levio, toe nitolorako ze fonga fahafolo’ Israele ho fanañañe hasolo ty fitoroñañe itoroña’ iareo, ty fitoloñañe an-kibohom-pamantañañe ao. ");
INSERT INTO tdx_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Tsy ho harinè’ o ana’ Israeleo ka i kibohom-pamantañañey henane zao tsy mone hivave hakeo vaho hivetrake. ");
INSERT INTO tdx_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","O nte-Levio avao ty hifanehak’ amo tolon-draha’ i kibohom-pamantañañeio, le ho vavè’ iereo o hakeo’eo; ho fañè nainai’e amo hene tarira’ areo mifandimbeo, f’ie tsy hanan-dova añivo o ana’ Israeleo, ");
INSERT INTO tdx_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","amy te nitolorako ty faha­folo avì’ o ana’ Israeleo ho engan-kavoañe am’ Iehovà, ie ty lova natoloko amo nte-Levio, toe vinolako t’ie tsy hanan-dova amo ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Le nitsara amy Mosè t’Iehovà nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Saontsio amo nte-Levio ty hoe: Naho rambese’ areo amo ana’ Israeleo i fahafolo natoloko anahareo ho lova’areoy, le añengào enga-kavoañe am’ Iehovà ty fahafolo’ i fahafoloy. ");
INSERT INTO tdx_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Le ho volili­eñe ama’ areo hambañe amy t’ie i mahakama boak’ an-toe-pamofohañey; naho te boak’ ami’ty hapea’ i fipi­ritan-divaiy i enga havi’ areoy. ");
INSERT INTO tdx_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Aa le havi’ areo ho am’ Iehovà ty enga-kavoañe boak’ amo fahafolo rambese’ areo amo ana’ Israeleo le i enga-kavoañe navike ho am’ Iehovày ty hatolo’ areo amy Aharone mpisoroñe. ");
INSERT INTO tdx_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Amo hene enga atolotse ama’ areoo, le havi’ areo ze havìke am’ Iehovà; ze hene soa ama’e naho ty miavake ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Aa le ano ty hoe: Naho avi’ areo ty soa ama’e, le ho volilieñe amo nte-Levio ho mahakama nasisa an-toe-pamofohañe ey naho ty fitomboa’ i fipiritan-divaiy. ");
INSERT INTO tdx_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Azo’ areo kamaeñe ndra aia aia izay, inahareo naho o keleia’ areoo amy te tambe’ areo amy fito­loña’ areo amy kibohom-pamantañañeiy. ");
INSERT INTO tdx_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Aa kanao avi’ areo ty soa ama’e le tsy hivavea’ areo hakeo, vaho ko leore’ areo o enga’ miava’ o ana’ Israeleoo tsy mone hivetrake. ");
INSERT INTO tdx_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Hoe ty nitsara’ Iehovà amy Mosè naho i Aharone: ");
INSERT INTO tdx_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Intoy ty fañèm-pètse linili’ Iehovà: Misaontsia amo ana’ Israeleo ty hindesa’ iareo kiloa mena tsy aman-kandra ndra hila mbe lia’e tsy nanampezan-joka. ");
INSERT INTO tdx_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Atoloro i Elazare mpisoroñe, le hasese’e alafe’ i tobey ho lentaeñe añatrefa’e; ");
INSERT INTO tdx_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","le hangala’ i Elazare an-drambo-pità’e ty lio’e, vaho hafitse’e impito aolo’ i Kibohom-pa­man­tañañey. ");
INSERT INTO tdx_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Le horoañe am-paha­isaha’e i kiloay: Fonga foro­totoeñe ty holi’e, ty nofo’e, ty lio’e vaho ty tai’e. ");
INSERT INTO tdx_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Le handrambe mendorave naho seva naho fole mena mañabarà i mpisoroñey vaho hatora’e añate’ i afo mamorototo i kiloaiy. ");
INSERT INTO tdx_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Ho sasà’ i mpisoroñey amy zao o saro’eo, le hampiandroe’e an-drano i sandri’ey, vaho himoak’ an-tobe ao; fa haleotse am-para’ te hariva i mpisoroñey. ");
INSERT INTO tdx_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Hanasa o siki’eo naho hiandro an-drano ka i nañoro azey, ie tsy halio am-para’ te hariva. ");
INSERT INTO tdx_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Le havori’ t’indaty malio ty laveno’ i kiloay vaho hahaja’e an-toetse malio alafe’ i tobey ey, naho havandroñe ey ho amy valobohò’ o ana’ Israeleoy, ho ami’ty ranom-pandeorañe, toe fañeferan-kakeo. ");
INSERT INTO tdx_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Hanasa ty siki’e i namory o lavenokeoy le tsy halio ampara’ te haleñe: ho fañè nainai’e tsy modo amo ana’ Israeleo naho amo renetane mpimo­neñe am’ iereoo. ");
INSERT INTO tdx_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Ze mitsapa lolo, ndra t’ie fate’ ia’ia, ro haleotse fito andro. ");
INSERT INTO tdx_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Hañefe’ batañe amy ranoy re ami’ty tsy haliova’e ami’ty andro fahatelo naho ami’ty andro faha-fito vaho halio; f’ie tsy mañefe-batañe amy andro fahateloy naho amy andro fahafitoy le tsy halio. ");
INSERT INTO tdx_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Ze mitsapa lolo, ty fañova’ ondaty mate, vaho tsy mañefe-batañe, le mandeotse ty kivoho’ Iehovà. Haitoañe am’ Israele indatiy. Tsy halio re amy te tsy nafitse ama’e i rano-piambahañey, tambats’ ama’e i haleora’ey. ");
INSERT INTO tdx_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Zao ty fetse te mivetrak’ añ’akiba ao t’indaty: ze mizilik’ añ’akiba ao naho ze am-po’e ao ro songa maleotse fito andro, ");
INSERT INTO tdx_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","maleotse ka ze fanake tsy mitakoñe soa. ");
INSERT INTO tdx_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Ze mitsapa ondaty vinonom-pibara an-kivoke ey ke ondaty mate avao, he taola’ ondaty, hera kibory, le haleotse fito andro. ");
INSERT INTO tdx_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Aa naho i maleo­tsey: hangalañe ty laveno’ i namoroto­to­añe ho fañeferan-kakeoiy, vaho añi­liñan-drano malio ty fitovy; ");
INSERT INTO tdx_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ho rambese’ t’indaty malio ty seva le halò’e amy ranoy vaho hafitse’e amy akibay naho amo fanake iabio naho am’ ondaty nizoeñeo naho amy nitsapa o taolañeo ndra i vinonoy ndra i loloy ndra i kiboriiy. ");
INSERT INTO tdx_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Hafitse’ i malioy amy tsy malioy ami’ty andro fahatelo naho ami’ty andro faha-fito; ie amy andro faha-fitoy ro hiefetse, le ho sasà’e o siki’eo vaho hiandro an-drano, le halio te harivay. ");
INSERT INTO tdx_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Fe t’indaty maleotse tsy miefetse amy haleora’ey, le haitoeñe amy valobohòkey indatiy, amy te nileore’e ty efe-miava’ Iehovà. Tsy nafitse ama’e i rano-kaleorañey; maleotse re. ");
INSERT INTO tdx_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Fañè nainai’e ho a iareo izay. Hanasa ty siki’e i namitse i rano-kaleorañey, vaho haleotse am-para’ te hariva ze mitsapa i rano-kaleorañey. ");
INSERT INTO tdx_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Haleotse ze raha tsinapa’ i maleotsey, le haleotse am-para’ te haleñe t’indaty nitsapa aze. ");
INSERT INTO tdx_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Nimoak’ am-patram-bei’ i Tsine eo o ana’ Israeleo, i valobohòkey, amy volañe valoha’ey le nitobe e Kadese; nihomake eo t’i Miriame vaho nalenteke. ");
INSERT INTO tdx_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Tsy nanan-drano i valobohòkey le nifanontoñe hiatreatre amy Mosè naho i Aharone. ");
INSERT INTO tdx_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Le nifandietse amy Mosè ondatio, ami’ty hoe, Hamake t’ie nivetrak’ amy nikoromaha’ o longo’aio añatrefa’ Iehovày! ");
INSERT INTO tdx_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Aa vaho ino ty nanesea’o mb’ am-patrambey mb’etoy ty fivori’ Iehovà, hibanitse etoañe, zahay naho o hare’aio? ");
INSERT INTO tdx_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Le ino ty nañakara’o anay an-tane Mitsraime añe, hanese anay an-toetse raty atoy? ie tsy mahalefe ampemba ndra sakoañe ndra vahe ndra dagoa, mbore tsy aman-drano hinomañe. ");
INSERT INTO tdx_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Aa le nienga i valobohòkey t’i Mosè naho i Aharone niheo mb’amy lalan-kibohom-pamantañañey mb’eo; le nibabok’ an-daharañe vaho nisodehañe am’ iereo ty enge’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Le nitsara amy Mosè t’Iehovà nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Rambeso i kobaiñey; le atontono i valobohòkey, ihe naho i Aharone rahalahi’o. Saontsio añatrefam-pihaino’ iareo i vatoy haña­katse ty rano’e, hamahana’o rano boak’ amy vatoy, hampi­noma’o iareo naho o hare’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Aa le rinambe’ i Mosè i kobay añatrefa’ Iehovày, amy nandiliañe azey. ");
INSERT INTO tdx_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Le navori’ i Mosè naho i Aharone añatrefa’ i vatoy i fivoriy, le nanoe’e ty hoe, Mitsen­dreña, ry mpiolao. Hañakara’ay rano boak’ ami’ty vato tia hao? ");
INSERT INTO tdx_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Aa le naonjo’ i Mosè ty fità’e naho finofo’e indroe amy kobai’ey i vatoy, vaho nidoandoañe boak’ ao ty rano bey le ninon-drano i valobohòkey naho o hare’eo. ");
INSERT INTO tdx_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Fe hoe t’Iehovà amy Mosè naho i Aharone, amy te tsy nonjone’ areo hampiboak’ amo ana’ Israeleo o hamasiñakoo, le tsy hendese’ areo hizilik’ an-tane natoloko iareo ao ty fivory tia. ");
INSERT INTO tdx_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ie o Ranom-Piolañeo amy te nikotreke am’ Iehovà o ana’ Israeleo, ie fa nivente’e am’ iareo ty hamasiña’e. ");
INSERT INTO tdx_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Aa le nañitrik’ ami’ty mpanjaka’ i Edome boake Kadese t’i Mosè. Hoe ty rahalahi’o Israele: Fohi’o o hasotriañe iaby nifetsak’ ama’aio: ");
INSERT INTO tdx_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","ty nizo­tsoa’ o rae’aio mbe Mitsraime mb’eo, ty nimo­neña’e añe andro maro, vaho te namorekeke anay naho o rae’aio o nte-Mitsraimeo. ");
INSERT INTO tdx_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Aa ie nikaike Iehovà le jinan­ji’e o fiarañanaña’aio vaho nirahe’e i Anjeli’ey ninday anay niavotse i Mitsraime; le ingo t’ie e Kadese atoy henaneo, ty rova añ’ olon’ efe-tane’o atoy. ");
INSERT INTO tdx_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Aa ehe meo lalan-jahay hitoañe o tane’oo. Tsy hiranga teteke ndra tanem-bahe, le tsy ho kamae’ay ty rano boak’ am-bovo’ areo ao; fa horihe’ay i Karanan­gam-Panjakay, vaho tsy hivio mañavia ndra mañavana ampara’ te losore’ay o fehe’oo. ");
INSERT INTO tdx_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Aa hoe ty asa’ i Edome ama’e, Tsy hiranga ty tane’ay nahareo, tsy mone hiavota’ay am-pibara. ");
INSERT INTO tdx_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Le hoe o ana’ Israeleo tama’e, I Karanangay avao ty handenako, aa naho hinome’ay o rano’oo, izaho ndra o harekoo, le havahako ty vili’e; adono hirangàko an-tomboke tsy hampianto. ");
INSERT INTO tdx_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Fe hoe re, Tsy hiranga nahareo. Le niavotse mb’am’ iareo mb’eo ty Edome an-dahin-defo maro vaho am-pitàñe maozatse. ");
INSERT INTO tdx_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Aa le nifoneñe t’i Edome tsy nanolora’ o fehe’eo lalañe hitsake t’Israele; aa le nivioñe añe t’Israele. ");
INSERT INTO tdx_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Niavotse i Kadese iereo, le niporopotìtse e Vohi-Hore o ana’Israeleo—i valobohòke iabiy. ");
INSERT INTO tdx_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Le nanao ty hoe amy Mosè naho amy Aharone t’Iehovà e Vohi-Hore ey, añ’efe-tane’ i Edome eo: ");
INSERT INTO tdx_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Hatontoñe am’ ondati’eo t’i Aharone, ie tsy hizilike amy tane natoloko amo ana’ Israeleoy, amy te niola amy volakoy nahareo an-drano’ i Meribà añe. ");
INSERT INTO tdx_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Endeso t’i Aharone naho i ana’e Elazare vaho aseseo mañambone’ i Vohi-Horey mb’eo, ");
INSERT INTO tdx_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","le abolio amy Aharone o saro’eo naho asaroño amy Elazare ana-dahi’e fa hatontoñe t’i Aharone toe hivetrake. ");
INSERT INTO tdx_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Aa le nanoe’ i Mosè i linili’ Iehovày vaho niañambone ty Vohi-Hore ampahaisaha’ i valobohòke iabiy. ");
INSERT INTO tdx_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Nafaha’ i Mosè o saro’ i Aharoneo naho nasaro’e amy Elazare ana’e, le nihomake andengo’ i vohitsey t’i Aharone, vaho nizotso amy vohitsey t’i Mosè naho i Elazare. ");
INSERT INTO tdx_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Aa ie nirendre’ i valobohòke iabiy te nivilasy t’i Aharone, le fonga nandala aze telopolo andro ty anjomba’ Israele. ");
INSERT INTO tdx_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Ie jinanji’ i Arade Mpanjaka nte-Kanàne nimoneñe Atimo añe te niary mb’e Atarime mb’eo t’Israele, le nia­ly am’ Israele re vaho nendese’e am-bahotse ty ila’e. ");
INSERT INTO tdx_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Aa le nifanta am’ Iehovà t’Israele nanao ty hoe, Naho toe hasese’o am-pità’ay ondaty rezao le fonga harotsa’ay o rova’eo. ");
INSERT INTO tdx_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Nihaoñe’ Iehovà ty fiarañanaña’ Israele le nasese’e ama’e o nte-Kanàneo; fonga finongo’ iareo o rova’eo; vaho natao Kormà i taney. ");
INSERT INTO tdx_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Niavotse boak’ am-Bohi-Hore eo le nionjoñe mb’ an-dalañe migo­dañe mb’amy Ria-Binday mb’ eo, hiariañe i tane’ Edomey; fe nahangoae ondatio i liay. ");
INSERT INTO tdx_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Le nañinje an’ Andrianañahare naho i Mosè ondatio ami’ ty hoe: Aa vaho akore t’ie nin­desa’o niakatse i Mitsraime hive­trake am-patrambey atoy, ie tsy ama’ mahakama ndra rano naho mampangorý anay ty mofo maivañe toy. ");
INSERT INTO tdx_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Aa le nañiraha’ Iehovà merem-boreke ty añivo’ ondatio ze nañehetse ondaty vaho maro amo ana’ Israeleo ty nifitake. ");
INSERT INTO tdx_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Aa le nimb’ amy Mosè mb’eo ondatio nanao ty hoe: Nandilatse ami’ ty nañinjea’ay azo naho Iehovà; ihalalio am’Iehovà ty hanintaha’e o mereñeo. Aa le nihalaly ho a ondatio t’i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Le hoe t’Iehovà amy Mosè, Itseneo sare merem-boreke le asampezo ami’ty bodan-katae; le ho veloñe ze hene ondaty nihehereñe, mitalahatse ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Aa le namboare’ i Mosè an-torisìke i mereñey naho nasampe’e an-katae, aa naho nihehetse ondaty ty mereñe, ie nañente i mereñe torisìkey le niveloñe. ");
INSERT INTO tdx_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Nionjoñe amy zao o ana’ Israeleo le nitobe e Obote. ");
INSERT INTO tdx_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Niavota’ iareo ty Obote vaho nitobe e Iai’haabarime, am-patrambey atiñana’ i Moabe mb’ am-panjirihan’ andro mb’eo. ");
INSERT INTO tdx_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Nionjoñe boak’ ao iereo le nitobe am-Bavatane’ i Zerede ao. ");
INSERT INTO tdx_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Hirik’ ao iereo niavotse vaho nitobe alafe’ i Arnone amy fatrambey mifototse an-tane’ o nte-Emoreoy; amy te efe-tane’ i Moabe i Arnoney, mañefetse i Moabe amo nte-Emoreo. ");
INSERT INTO tdx_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Izay ty nanoeñe amo Boke’ o Ali’ Iehovàoo ty hoe: Oahebe e Sofà, o toraha’ i Arnoneo, ");
INSERT INTO tdx_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","naho ty teva’ o torahañeo ze mivariñe mb’an toe’ i Are, naho miefetse amy Moabe. ");
INSERT INTO tdx_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Ie hirik’ ao nimb’e Bire mb’eo, i vovoñe nitsarae’ Iehovà amy Mosèy ty hoe, Atontono ondatio hanjotsoako rano. ");
INSERT INTO tdx_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Le hoe ty nisaboe’ Israele: Mivoaña ry vovoñeo, isabo! ");
INSERT INTO tdx_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ty vovo nalente’ o talèo, hinali’ ty roandria’ ondatio, an-kobaiñe, an-tsara’ i Mpandily. Ie boak’am-patrambey ao le nañavelo pak’e Matanà, ");
INSERT INTO tdx_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","le boake Matanà mbe Mahaliele mb’eo, le hirike Mahaliele mb’e Bamote mb’eo, ");
INSERT INTO tdx_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","vaho boake Bamote am-bavatane’ i Moabe mb’ an-dengo’ i Pisgà mitolike mb’amy ratraratray añe. ");
INSERT INTO tdx_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Le nañitrike mb’amy Sihone mpanjaka’ o nte-Emoreo t’Israele, nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Adono hiranga ty tane’o zahay. Tsy hivìke mb’ an-teteke ndra mb’ an-tane-bahe; tsy hikama rano am-bovoñe. Hañorike i Karanan­gam-Panjakay avao ampara’ te losore’ay ty efe-tane’o. ");
INSERT INTO tdx_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","F’ie tsy napo’ i Sihone hiranga i efe’ey. Aa le natonto’ i Sihone ondati’e iabio vaho niavotse haname Israele am-patram-bey ey, le nivotrake e Iàhatse re naialy am’ Israele. ");
INSERT INTO tdx_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Zinevo’ Israele an-delam-pibara vaho tinava’e i tane’ey boak’ amy Arnoney pak’ ami’ ty Iaboke naho pak’ amo nte-Amoneo amy te fatratse ty efe-tane’ o ana’ i Amoneo. ");
INSERT INTO tdx_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Aa le fonga rinambe’ Israele o rova’eo vaho songa nimo­neña’ Israele o rova’ o nte-Emoreo, e Khesbone naho o hene ana-drova’eo. ");
INSERT INTO tdx_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Nirova’ i Sihone mpanjaka’ o nte-Emoreo ty Khesbone; niazo’e te nialy amy mpanjaka’ i Moabey taoloy vaho fonga rinambe’e i tane’e pak’amy Arnoney. ");
INSERT INTO tdx_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Aa le hoe ty onin-tsaontsin-droae: Antao mb’e Khesbone mb’eo, hamboatse naho hañafatratse ty rova’ i Sihone ");
INSERT INTO tdx_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Fa niakatse i Kesobone ty afo, lel’ afo boak’ an-drova’ i Sihone, nagodra’e i Are’ i Moabey o talen-kaboa’ i Arnoneo. ");
INSERT INTO tdx_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Hekoheko ama’o ry Moabe, Rinotsake nahareo nte-Kemose: napo’e ho gike o ana-dahi’eo, naho o anak’ampela’eo ho mpirohi’ i Sihone, mpanjaka’ i Emorey. ");
INSERT INTO tdx_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Linihi’ay ambane iereo: Nihomake t’i Khesbone pak’e Dibone, le natsafe’ay pak’e Nofà, naho pak’e Medebà. ");
INSERT INTO tdx_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Aa le nimoneñe an-tane’ Emore ao t’Israele. ");
INSERT INTO tdx_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Nampihitrife’ i Mosè ty hitingañe Ia’azere le rinambe’e o tanà’eo vaho nanoe’e soike ze nte-Emore tao. ");
INSERT INTO tdx_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Nitsile iereo, nañavelo an-dalañe mb’e Basane mb’eo; le niavotse hifanalaka am’iareo t’i Oge mpanjaka’ i Basane rekets’ ondati’e iabio, hañotakotake e Edrey. ");
INSERT INTO tdx_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Aa hoe t’Iehovà amy Mosè, Ko ihembaña’o, fa natoloko am-pità’o rekets’ ondati’e iabio naho i tane’ey. Ano ama’e hambañe amy nanoa’o amy Sihone mpanjaka’ o nte-Emore nimpifehe’ i Khesboneoy. ");
INSERT INTO tdx_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Aa le zinevo’ iareo naho o ana-dahi’eo naho ondati’eo, ampara t’ie tsy aman-tsengaha’e vaho rinambe’iereo i tane’ey. ");
INSERT INTO tdx_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Nionjom-beo o ana’Israeleo nitobe an-tanemira’ i Moabe alafe’ Iardene tandrife Ierikò ey. ");
INSERT INTO tdx_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Ie amy zao hene nioni’ i Balak’ ana’ i Tsipore i nanoe’ Israele amo nte-Emoreoy. ");
INSERT INTO tdx_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Aa le nirevendreveñe am’ondatio t’i Moabe kanao ninihanìha ty hamaro’e; le nanembetse i Moabe o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Aa le hoe ty Moabe amo roandria’ i Midianeo, Fonga ho tselà’ i lahialeñey ze mañohoke an-tika manahake ty famelehan’ añombe o ahetse an-kivok’ ey. Mpanjaka’ o nte-Moabeo henane zay t’i Balak’ ana’ i Tsipore. ");
INSERT INTO tdx_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Le nampisangitrife’e mb’amy Balame ana’ i Beore e Petore añolon-tsaka’ an-tanen-te-Arame añe ty irake hikanjiy aze ami’ty hoe: Inao, nivotrake boake Mitsraime añe t’indaty; hehe t’ie manitsike ty ambone’ ty tane toy vaho mitobe marine ahiko etoa. ");
INSERT INTO tdx_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Mb’etoa aniany koahe, ozoño ho ahy ondatio, ie manjofake te amako. Hera ho gioheko le ho soiheñe hiakatse an-tane atoy, fa apotako te soa tata o tatae’oo vaho fatran-tane o ozoñe’oo. ");
INSERT INTO tdx_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Aa le niavotse mb’eo o roandria’ i Moabeo naho o roandria’ i Midianeo reketse ty saram-pamorehañe am-pitàñe vaho niheo mb’amy Balame mb’eo ninday ty nisaontsia’ i Balake. ");
INSERT INTO tdx_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Le hoe re tam’ iereo, mialeña atoy te anito, le hañerem-bolañ’ ama’ areo iraho, ze ho tsarae’ Iehovà amako. Aa le nialeñe amy Balame ao o roandria’ i Moabeo. ");
INSERT INTO tdx_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Niheo mb’amy Balame t’i Andrianañahare nanao ty hoe: Ia ondaty mitraok’ ama’oo? ");
INSERT INTO tdx_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Le hoe t’i Balame aman’ Añahare, Nampañitrike ty saontsy toy amako t’i Balak’ ana’ i Tsipore: ");
INSERT INTO tdx_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Heheke ondaty hirike Mitsraime añeo: tsitsihe’ iareo ty ambone’ ty tane toy; aa le mb’etoa irehe, ozoño ho ahiko; hera hahalefeako aly vaho haronjeko añe. ");
INSERT INTO tdx_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Le hoe t’i Andrianañahare amy Balame, Tsy hindreza’o fañaveloañe; tsy hozoñe’o ondatio fa soa-tata. ");
INSERT INTO tdx_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Aa le nitroatse maraiñe t’i Balame nanao ty hoe amo roandria’ i Balàkeo, Mimpolia mb’ an-tane’ areo añe, amy te nifoneñe t’Iehovà tsy nañomey ahy lily hindrezako. ");
INSERT INTO tdx_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Aa le niongake o roandria’ i Moabeo nimpoly mb’ amy Balàke mb’eo, nanao ty hoe: Tsy nimete nindre ama’ay t’i Balame. ");
INSERT INTO tdx_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Nañitrik’ ana-donake indraike t’i Ba­lake, ondaty maro naho ambone’ lohàñe te amo teoo. ");
INSERT INTO tdx_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Aa le niheo mb’ amy Balame mb’eo indaty rey nanao ty hoe, Hoe t’i Balak’ ana’ i Tsi­pore, Ko anga’o ndra inoñ’ inoñe ty hisebañe azo tsy homb’ amako mb’etoa; ");
INSERT INTO tdx_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","toe ho rengèko vaho hanoeko ze saon­tsia’o. Aa le miambane ama’o t’ie homb’etoa hañozoñe ondatio ho ahiko. ");
INSERT INTO tdx_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Le hoe ty natoi’ i Balame amo mpitoro’ i Balakeo, Ndra te natolo’ i Ba­lak’ amako ty anjomba’e pea volafoty naho volamena le tsy mete handilatse ty tsara’ Iehovà Andrianañahareko iraho hanao ndra inoñ’ inoñe ke t’ie bey he kede. ");
INSERT INTO tdx_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Aa le mialeña amako etoa manahake ty nanoe’ o ila’eo haharendrehako ze tsara hatovo’ Iehovà amako. ");
INSERT INTO tdx_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Le niheo mb’ amy Balame amy haleñey t’i Andrianañahare nanao ty hoe ama’e, Aa naho nimb’ama’o mb’ atoy ondatio hikanjy azo, miavota naho indrezo; fe ze entañe hatoloko azo avao ty hanoe’o. ");
INSERT INTO tdx_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Aa le nañaleñaleñe t’i Balame nanampe fitobohañe amy borìke’ey, vaho nitrao-dia amo androanavi’ i Moabeo. ");
INSERT INTO tdx_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Fe nampamiañe ty haviñeran’ Añahare i fañavelo’ey, vaho nijohañe hikalañe i lala’ey ty Anjeli’ Iehovà, hiatreatrea’e hoe rafelahy. Ie amy zao ninin­gitse borìke naho nindre ama’e ty mpitoro’e roe. ");
INSERT INTO tdx_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Nahatrea i Anjeli’ Iehovày nijohañe an-dalañe ey reketse fibara natsoak’ am-pità’e i borìkey, le nivioñe amy lalañey i borìkey nitsile mb’an-tetek’ ao, le finofo’ i Balame ty lafa hampibalik’ aze mb’amy lalañey. ");
INSERT INTO tdx_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Le nijohañe ami’ ty zitse añivo’ ty tanem-bahe roe ey i Anjeli’ Iehovày, ty kijoly etia naho ty kijoly etia. ");
INSERT INTO tdx_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ie nitrea’ i borìkey i Anjeli’ Iehovày le nioza amy rindriñey, vaho nanindry ty kitso’ i Balame amy rindriñey, aa le linafa’e indraike. ");
INSERT INTO tdx_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Nihànkañe aolo ey amy zao i Anjeli’ Iehovày nijohañe añ’ oloñoloñe ey, le tsy eo ty hivioñañe ndra mañavana ndra mañavia. ");
INSERT INTO tdx_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Naho nizoe’ i borìkey i Anjeli’ Iehovày le nibabok’ ambane’ i Balame eo; tsekak’ amy zao ty haboseha’ i Balame le finofo’e an-kobai’e i borìkey. ");
INSERT INTO tdx_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Aa le sinoka’ Iehovà ty vava’ i borìkey, vaho hoe re amy Ba­lame, Ino ty nanoeko ama’o kanao linafa’o intelo aniany? ");
INSERT INTO tdx_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Le hoe t’i Balame amy borìkey, Amy t’ie nanalatse ahy, le nainako te ni-reke-pibara ty tañako henaneo hamonoako azo! ");
INSERT INTO tdx_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Aa le hoe i borìkey amy Balame, Tsy izaho hao o borìke’oo, i niningira’o amo hene tao’o pake henaneoy? Liliko hao ty manao zao ama’o? Aiy, hoe re. ");
INSERT INTO tdx_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Aa le nampibeahe’ Iehovà ty fihaino’ i Balame naho niisa’e nijohañe amy lalañey i anjeliy, am-pibara napontsoañe am-pità’e; le nibotreke re nibabok’ an-dahara’e. ");
INSERT INTO tdx_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Le hoe i Anjeli’ Iehovày ama’e, Inoñe ty nijerà’o i borìke’oy in-telo? Nimb’ atoy iraho am-pirafelahiañe, amy te ihe manao hajangaringaria añatrefako. ");
INSERT INTO tdx_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Nitrea’ i borìkey iraho le nivioña’e intelo. Aa naho tsy niholiara’e le toe ho nañe-doza ama’o iraho anianikey vaho ho nengako velon-dre. ");
INSERT INTO tdx_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Le hoe t’i Balame amy Anjeli’ Iehovày, Nanao hakeo iraho fa tsy napotako te nijohañe an-dalañe ey irehe hiatreatre ahy. Aa naho joy ty am-pihano’o le himpoly iraho. ");
INSERT INTO tdx_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Aa le hoe i Anjeli’ Iehovày amy Bala­me, Akia, mindreza am’ondaty reo, fe ze entañe volañeko ama’o avao ty ho taroñe’o. Aa le nañavelo nindre lia amy androanavi’ i Balàke rey t’i Balame. ");
INSERT INTO tdx_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Ie jinanji’ i Balake te fa tsatoke t’i Balame le niavotse mb’e Ire-Moabe mb’amy efe-tane efera’ i Arnoney, ty efe’e lavitse ama’e mb’eo hifanalaka ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Le hoe t’i Balak’ amy Balame, Aa vaho tsy nimaneako hitrike naho kanjy v’iheo? Ino ty tsy nañaveloa’o mb’amako. Tsy haiko hao ty hiasy azo? ");
INSERT INTO tdx_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Le hoe t’i Ba­lame amy Balake, Intoy fa ama’o! meteko hao ty hanao ndra inoñ’ inoñe? Tsy mahay tsy ze tsara apon’ Añahare am-bavako ao avao ty ho taroñeko. ");
INSERT INTO tdx_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Aa le nindre lia amy Balake t’i Balame vaho nipotìtse e Keriat-kozote eo. ");
INSERT INTO tdx_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Nisoroñe añombe naho añondry amy zao t’i Balake vaho nañitrifa’e t’i Balame naho o androanavy nindre ama’eo. ");
INSERT INTO tdx_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ie amy maraiñey le nendese’ i Balake nañambone’ i Bamà-Baale t’i Balame, le eo re ro nahatalake ty indra’ ondatio. ");
INSERT INTO tdx_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Le hoe t’i Balame amy Balake, mandrafeta kitrely fito etoañe vaho hajario ho ahy ty añombelahy fito naho añondrilahy fito. ");
INSERT INTO tdx_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Le nihenefa’ i Balake i sinaontsi’ i Balamey; le songa nisoroña’ i Balake naho i Balame amy kitrely rey ty añombelahy naho ty añondrilahy. ");
INSERT INTO tdx_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Le hoe t’i Balame amy Balake, Mijohaña marine o isoroña’oo le hivìke iraho hera hifampikaoñe amako t’Iehovà, le hataliliko azo ze hatoro’e ahiko. Aa le nimb’ an-kaboa mb’eo re. ");
INSERT INTO tdx_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Le nifañaoñe amy Balame t’i Andrianañahare, vaho hoe t’i Balame ama’e. Fa hinajariko ty kitrely fito naho songa nisoroñako añombelahy naho añondrilahy amy kitreli’e rey. ");
INSERT INTO tdx_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Napo’ Iehovà am-palie’ i Balame ao ty tsara, ami’ty hoe, Mibaliha mb’ amy Balake mb’eo le inao ty ho saontsie’o. ");
INSERT INTO tdx_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Le nibalike mb’ama’e mb’eo re nanjo aze nijohañe marine o nisoroña’eo, ie naho ze hene roandria’ i Moabe. ");
INSERT INTO tdx_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Le nonjone’e ami’ ty hoe i fandrazaña’ey: Fa ninday ahy boak’ Arame t’i Balake mpanjaka’ i Moabe; hirik’ amo vohitse atiñanañ’eñeo. Mahavia, Ozoño ho ahiko t’Iakòbe, Mb’etoa onjiro t’Israele! ");
INSERT INTO tdx_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Aa vaho akore ty hamàrako ty tsy nafàn’ Añahare? Vaho akore ty hañonjirako i tsy nonjira’ Iehovày? ");
INSERT INTO tdx_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ie talakeko boak’ ambone’ vato ey, sinambako hirik’ ankaboañey; Hehe t’indaty mizoizoy, tsy ho volilieñe amo kilakila ‘ndatio! ");
INSERT INTO tdx_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ia ty mahaiake ty debo’ Iakòbe ndra hamolily ty fah’ efa’ Israele? Apoho iraho hikenkañe am-pihomaha’ o vantañeo, Ehe ampanahafo amy firompoa’ey ty ahiko. ");
INSERT INTO tdx_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Le hoe t’i Balak’ amy Balame, Ino ty nanoe’o amako? Nendeseko mb’ etoan-drehe hañozoñe o rafelahikoo te mone nitatae’o avao. ");
INSERT INTO tdx_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Le ti­noi’e ami’ty hoe, Tsy hambenako hao ty hivolañe ze apo’ Iehovà am-bavako ao? ");
INSERT INTO tdx_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Le hoe t’i Balake tama’e, Antao mb’ an-toetse raike ey hahatalakesa’o aze; ty ila’e avao ro ho oni’o fa tsy ie iaby, le ozoño boak’ ao ho ahiko. ");
INSERT INTO tdx_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Aa le nendese’e mb’an-tete’ i Tsofime mb’eo re ankaboa’ i Pisgà ey naho nañoreñe kitrely fito, vaho nisoroñe añombelahy naho añondrilahy amy kitreli’e rey. ");
INSERT INTO tdx_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Le hoe re amy Balake, Mijohaña etoa marivo o isoroña’oo, le homb’ aroan-draho, hifañaoñe. ");
INSERT INTO tdx_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Nifampi­kaoñe amy Balame t’Iehovà le nampipoke ty tsara am-pa­lie’e naho nanao ty hoe: Mibaliha mb’amy Balake mb’eo vaho isaontsio izay. ");
INSERT INTO tdx_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Aa le nimb’ ama’e mb’eo vaho nizoe’e nijohañe amy ni­soroña’ey rekets’ o roandria’ i Moabeo. Le hoe t’i Balak’ ama’e, Inoñe ty nitsarae’ Iehovà? ");
INSERT INTO tdx_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Aa le nonjone’e ami’ty hoe i razan-tsaontsi’ey: Miongaha ry Balake, mijanjiña! Anokilaño ravembia ry ana’ i Tsipore. ");
INSERT INTO tdx_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Tsy ondaty t’i Andrianañahare t’ie handañitse, naho tsy ana’ondaty t’ie haneñeñe. Aa vaho tsy hanoe’e i nitsarae’ey? tsy ho henefe’e hao i nitaroñe’ey? ");
INSERT INTO tdx_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ingo nanoloran-dily hitata iraho; aa kanao ie ro nitata tsy meteko afotetse. ");
INSERT INTO tdx_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Tsy nahaoniña’e hakeo t’Iakòbe tsy nahaisaha’e tahiñe t’Israele. Ama’e t’Iehovà Andrianañahare’e, naho ama’e ao ty koim-panjaka. ");
INSERT INTO tdx_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","I Andrianañahare nampienga aze amy Mitsraimey, ro tsifan-drimo abo ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Toe tsy atreatrem-boreke amy Iakòbe vaho tsy trean-tsikily amy ’Israele, Ie henaneo ro tsaraeñe ty am’ Iakòbe naho am’Israele, ty hoe: Heheke ty nanoen’Añahare. ");
INSERT INTO tdx_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Hitroatse hoe liona vave’e ondatio, hiongake hoe liona lahi’e: Tsy handre am-para’ t’ie mihinan-tsindroke vaho minoñe ty lio’ i vinonoy. ");
INSERT INTO tdx_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Le hoe t’i Balak’ amy Balame, Ko ozoñe‘o ka, naho ko itata’o. ");
INSERT INTO tdx_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Fe hoe ty navale’ i Balame i Balake, Tsy vinolako hao te ze tsarae’ Iehovà, le tsy mete tsy izay ty hanoeko? ");
INSERT INTO tdx_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Le hoe t’i Balak’ amy Balame, Antao, fa hendeseko mb’an-toetse raike ka irehe hera ho non’ Añahare ty hañozoñe iareo ho ahiko boake ey. ");
INSERT INTO tdx_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Le nendese’ i Balake mb’ an-dengo’ i Peore, ahatalakesañe mb’ am-patrambey eñe, t’i Balame. ");
INSERT INTO tdx_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Le hoe t’i Balame amy Balake, Añoreño kitrely fito ty etoy vaho añajario añombelahy fito naho añondrilahy fito. ");
INSERT INTO tdx_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Le nanoe’ i Balake i sinaontsi’ i Balamey vaho songa nisoroña’e an-kitrely ty añombelahy naho ty añondrilahy. ");
INSERT INTO tdx_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Aa kanao nioni’ i Balame te ninò’ Iehovà ty hitata Israele le tsy nisikilie’e nanahake i lili’ey fe nampitolihe’e mb’ am-patrambey eñe ty lahara’e. ");
INSERT INTO tdx_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Aa naho niandra t’i Balame le nioni’e t’Israele nimoneñe an-kiboho’e ey nilahatse amo fifokoa’eo; le nivotrak’ ama’e ty arofon’ Andrianañahare; ");
INSERT INTO tdx_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","vaho nonjone’e ami’ty hoe ty razan-drehake, Hoe ty fetse’ i Balame ana’ i Beore, naho ty lañona’ ondaty am-pihaino misokake. ");
INSERT INTO tdx_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Ty enta’ ondaty mahajanjiñe ty tsaran’Añahare, naho mahaisake ty aroñaro’ i El-Sadai, mibaboke fe am-pihaino mibolanake: ");
INSERT INTO tdx_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Fanjaka o kiboho’oo ry Iakòbe naho o kivoho’oo ry Israele. ");
INSERT INTO tdx_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Mivelatse hoe vavatane, hoe kodobo añ’olon-tsaka, hoe vahoñe nambole’ Iehovà hoe mendoraveñe añ’olon-drano. ");
INSERT INTO tdx_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Hidoandoan-drano o sihoa’eo naho ho an-drano maro o tabiri’eo. Mitoabotse ambone’ i Agage ty mpanjaka’e vaho onjoneñe i fifehea’ey. ");
INSERT INTO tdx_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Manahake ty tsifan-drimo mitiotiotse t’i Andrianañahare nampiavotse aze amy Mitsraime. Hampibotseke ze tane malaiñe aze hampipozapozake o taola’eo, hampitrofahe’e amo ana-pale’eo. ");
INSERT INTO tdx_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Nitsakononòke re, nanao fandrean-diona naho hoe liona rene’e, ia ty hampitsekak’ aze? Hene soa tata ze mitat’azo Fonga ozoñeñe o mañozoñ’azoo. ");
INSERT INTO tdx_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Nisolebotse amy Balame amy zao ty habose’ i Balake, le nifampitrabohe’e o fità’eo, naho hoe t’i Balak’ amy Bala­me, Nikanjiako haño­zoñe o rafelahikoo, vaho hehe te nitsitsihe’o tata in-telo. ");
INSERT INTO tdx_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Mibioña arè mb’ an-toe’o añe, ie ho nonjoneko andi­kerañe eñe ty asi’o; te mone kinala’ Iehovà i ho ni-enge’oy. ");
INSERT INTO tdx_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Le hoe t’i Balame amy Balake, Tsy vinolako hao o ìra’o nampihitrife’o amakoo ty hoe, ");
INSERT INTO tdx_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","Ndra te hatolo’ i Balak’ ahiko ty volafoty naho volamena mahaatseke i anjomba’ey, tsy ho likoareko ty falie’ Iehovà, hanoako ty soa ndra ty raty boak’ an-troko, fa ze nitsarae’ Iehovà ty ho taroñeko? ");
INSERT INTO tdx_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Aa le himpoliako ondatikoo henaneo, fe adono hey hitoroako ty hanoe’ ondaty reroañe am’ondati’oo amo andro ampara’e añeo. ");
INSERT INTO tdx_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Aa le nonjone’e ami’ty hoe i fandrazaña’ey: Ty lañona’ i Balame ana’ i Beore, ty taro’ ondaty am-pihaino nabeake. ");
INSERT INTO tdx_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Ty kora’ i mpijanjiñe o tsaran’ Añahareoy, vaho ama’e ty fahafohinañe i Andindimoneñey, Oni’e ty aroñaro’ i El-Sadai mibaboke fe am-pihaino mibeake: ");
INSERT INTO tdx_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Treako fa tsy henaneo; misamb’ aze iraho fe tsy mitotoke; hiboak’ am’ Iakòbe ty vasiañe; hionjoñe hirik’am’ Israele ty kobaiñe, ho demohe’e o olon-tane’ i Moabeo le fonga ho rotsahe’e o anam-pifandrakarakañeo. ");
INSERT INTO tdx_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ho fanañañe t’i Edome, ho hanaña’ o rafelahi’eo t’i Seire, le hitoloñ’ an-kafatrarañe t’Israele. ");
INSERT INTO tdx_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Hiboak’ am’ Iakòbe ty hifehe, handrotsake ty sehanga’ i Are. ");
INSERT INTO tdx_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ie nitalakese’e t’i Amaleke le nonjone’e ty fetse’e ami’ty hoe: Nilohà’ o kilakila taneo t’i Amaleke, Fe hamongorañe ty ho figadoña’e. ");
INSERT INTO tdx_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Nisambae’e amy zao o nte-Keineo, vaho nañonjona’e fetse ami’ ty hoe: Fatratse o fimoneña’oo naho mioreñe an-damilamy eo ty akiba’o; ");
INSERT INTO tdx_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","fe ho forototoeñe t’i Kàine; ampara’ mbia te ho tana’ i Asore an-drohy? ");
INSERT INTO tdx_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Le nonjone’e ty fetse’e nanao ty hoe: Hedey! Ia ty ho veloñe naho akipen’ Añahare? ");
INSERT INTO tdx_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Hitotsak’ eo o lakambey hirik’ añ’olo’ i Ketio, ho silofe’ iareo t’i Asore naho hampiambane’e t’i Aibere, ampara’ t’ie mongotse nainai’e. ");
INSERT INTO tdx_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Aa le niongake t’i Balame, nienga, naho nimpoly mb’an-toe’e añe; vaho nimb’ amy lia’e mb’eo ka t’i Balake. ");
INSERT INTO tdx_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","i Nitobe e Setime eo t’Israele le niorotse nanao hakarapiloañe amo ampela’ i Moabeo ondatio. ");
INSERT INTO tdx_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Nambarañe ondatio hiatreke ty fisoroña’ iareo amo ndrahare’ iareoo, le nikama ao ondatio vaho nibokoboko amo ndrahareo. ");
INSERT INTO tdx_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Aa kanao niharo baoñe amy Baale t’Israele le nisolebotse am’ Israele t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Aa le hoe t’Iehovà amy Mosè, Endeso o talè’ ondatioo vaho aradoradò an-tariñandroke eo añatrefa’ Iehovà o nandilatseo hisitaha’ ty haviñerañe miforoforo’ Iehovà am’ Israele. ");
INSERT INTO tdx_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Aa le hoe t’i Mosè amo mpizaka’ Israeleo, Songa mamonoa ze ondati’e nitrao-baoñe amy Baale’ i Peoreo. ");
INSERT INTO tdx_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Inge henane zay, te nimb’eo ty ana’ Israele ninday ty ampela nte-Midi­ane mb’ amo longo’eo ampahaisaha’ i Mosè, naho am-pahaisaha’ i valobohò’ Israeley, ie nirovetse an-dalam-pimoahañe an-kibohom-pamantañañe eo. ");
INSERT INTO tdx_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Aa naho niisa’ i Pinekase ana’i Elazare ana’ i Aharone mpisoroñe, le niongake nienga i valobohòkey ninday lefoñe am-pità’e; ");
INSERT INTO tdx_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","le norihe’e pak’ an-kiboho’e ao indati’ Israeley vaho tinombo’e i roroey; tineñateña’e indati’ Israeley naho i ampelay, le nitsa­mantak’ am-pisafoañe. Aa le nijihetse ty angorosy añivo’ o ana’Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Ro’ale-tsi-efats’ arivo ty navetra’ i angorosiy. ");
INSERT INTO tdx_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Fa nampihankañe’ i Pinekase ana’ i Elazare, ana’i Aharone Mpisoroñe amo ana’ Israeleo ty haboseko amy t’ie nahimbañe amo fahimbañako añivo’ iareo ao, le tsy nampangotomomoheko o ana’ Israeleo amy famarahiakoy. ");
INSERT INTO tdx_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Le hoe iraho: Atoloko aze ty fañinam-panintsiñako, ");
INSERT INTO tdx_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","naho ty fañinam-pisoroñañe tsy modo, ho aze naho o tarira’e manonjohy azeo; amy t’ie nimpamarahy aman’ Añahare’e le nijebaña’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Ty tahina’ indati’ Israele tinomboke nindre amy ampela nte-Midianeiy, i Zimrý ana’ i Salò, mpiaolo’ ty anjom­ban-droae’ o nte-Simoneo. ");
INSERT INTO tdx_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Le ty añara’ i ampela nte-Midiane vinonoy, i Kozbý ana’ i Tsore mpiaolo’ ty anjomban-droae’e e Midiane ao. ");
INSERT INTO tdx_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Aa hoe t’Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Hehero o nte-Midianeo le rotsaho; ");
INSERT INTO tdx_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","amy te nihehera’ iereo ami’ty fikiniàm-pamañahia’ iareo amy Peore naho amy Kozbý, ana’ i mpiaolo nte-Midianey, rahavave’ iareo tinomboke tañ’andro’ i angorosy e Peorey. ");
INSERT INTO tdx_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Ie añe i angorosiy le nitsara amy Mosè naho i Elazare ana’ i Aharone mpisoroñe t’Iehovà nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Volilio o valobohò’ Israeleo, ze roapolo taoñe mañambone, amo anjomban-droae’ iareoo, ze hene mahafiatrek’ aly e Israele ao. ");
INSERT INTO tdx_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Aa le nisaontsy am’ iereo t’i Mosè naho i Elazare a montom-bei’ i Moabe marine’ Iardeney tandrife Ierikò, ami’ ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Volilio ondatio, ze roapolo taoñe mañambone, ami’ty nandilia’ Iehovà i Mosè, naho o ana’ Israele niavotse an-tane Mitsraimeo: ");
INSERT INTO tdx_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","I Reòbene ty tañoloñoloña’ Israele. O tarira’ i Reòbeneo: boak’ amy Hanoke, o nte-Hanokeo; boak’ amy Palò o nte-Palòo, ");
INSERT INTO tdx_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","boak’ amy Ketsrone o nte-Ketsroneo, boak’ amy Karmý o nte-Karmio. ");
INSERT INTO tdx_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Zao o hasavereña’ o nte-Reòbeneoo: ze niaheñe ama’e ni-efats’ ale-tsi-telo-arivo-tsi-fiton-jato-tsi-telopolo. ");
INSERT INTO tdx_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Le o tarira’ i Palòo: i Eliabe, ");
INSERT INTO tdx_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","o ana’i Eliabeo: i Nemoele, i Datane, i Abirame nisolom-bata’ i valobohòkeiy nirekets’ amy Korahke, ie niola amy Mosè naho i Aharone vaho niola am’ Iehovày, ");
INSERT INTO tdx_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ie nanokafa’ i taney vava, nampigedrañ’e i Korahke naho nañomake i màroy, vaho namorototo indaty roanjato-tsi-limampolo rey añ’afo, hanjaria’ iareo hatahata. ");
INSERT INTO tdx_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Fe tsy nihomake o ana’ i Korahkeo. ");
INSERT INTO tdx_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","O tarira’ i Simone amo hasave­reña’eoo boak’amy Nemoele o nte-Nemoeleo, boak’ am’ Iamine o nte-Iamineo, boak’ am’ Iakine o nte-Iakineo, ");
INSERT INTO tdx_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","boak’amy Zerake o nte-Zerakeo, boak’ amy Saòle o nte-Saòleo; ");
INSERT INTO tdx_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","zao o hasavereña’ i Simoneo: ro’ ale-tsi-ro’ arivo-tsi-roan-jato. ");
INSERT INTO tdx_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","O tarira’ i Gade amo hasavereña’eoo: boak’ amy Tsefone o nte-Tsefoneo, boak’ amy Kagý o nte-Kagio; boak’ amy Soný o nte-Sonìo; ");
INSERT INTO tdx_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","boak’ amy Ozný o nte-Oznio, boak’ amy Airý o nte-Airio; ");
INSERT INTO tdx_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","boak’ amy Arode o nte-Arodeo, boak’ amy Arelý o nte-Arelio; ");
INSERT INTO tdx_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","zao o hasavereña’ i Gadeo, amo niaheñe ama’eo, efats’ale-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Ty ana’ Iehodà, i Ere naho i Onane; fe nihomak’ an-tane Kanàne añe t’i Ere naho i Onane, ");
INSERT INTO tdx_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","le o tarira’ Iehodà an-kasavereña’eo: boak’amy Selà o nte-Selao; boak’ amy Peretse o nte-Peretseo; boak’ amy Zèrake o nte-Zèrakeo. ");
INSERT INTO tdx_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Le ty ana’ i Peretse: boak’ amy Ketsròne o nte-Ketsroneo; le boak’ amy Kamòle o nte-Kamoleo. ");
INSERT INTO tdx_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Zao o hasavereña’ Iehodà amo niaheñeoo: fito-ale-tsi-eneñ’arivo-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","O tarira’ Isakhare amo hasave­reña’eoo: boak’ amy Tolà o nte-Tolào; boak’ amy Poà o nte-Poao; ");
INSERT INTO tdx_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","boak’am’ Iasòbe o nte-Iasobeo; boak’ amy Simrone o nte-Simroneo; ");
INSERT INTO tdx_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","zao o hasave­reña’ Isakhare amo niaheñeoo: eneñ’ale-tsi-efats’ arivo-tsi-telonjato. ");
INSERT INTO tdx_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","O tarira’ i Zebolone amo hasave­reña’eoo: boak’ amy Serede o nte-Seredeo; boak’amy Elone o nte-Eloneo; boak’am’ Iakleèle o nte-Iakleeleo; ");
INSERT INTO tdx_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","zao o hasavereña’ i Zeboloneo amo niaheñeo: eneñ’ ale-tsi-liman-jato. ");
INSERT INTO tdx_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ty ana’ Iosèfe amo tarira’ i Menasè naho i Efraimeo: O tarira’ i Menasè amo hasavereña’eoo: ");
INSERT INTO tdx_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","boak’amy Makìre o nte-Makireo, le nasama’ i Makìre t’i Gilàde, o hasavereña’ Gilàdeo; ");
INSERT INTO tdx_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","zao ro ana’ i Gilade: boak’ am’ Ièzere o nte-Iezereo; boak’ amy Kàileke o nte-Kailekeo; ");
INSERT INTO tdx_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","boak’ amy Asrièle o nte-Asrieleo; boak’ amy Sèkeme o nte-Sèkemeo; boak’ ");
INSERT INTO tdx_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","amy Semidà o nte-Semidao; boak’ amy Kàifere o nte-Kaifereo; ");
INSERT INTO tdx_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","tsy nanañ’ anadahy t’i Tselofekhàde ana’ i Kàifere; ty añara’ o anak’ ampela’eo le Maklà, i Noà, i Koglà, i Milkà, vaho i Tirtsà. ");
INSERT INTO tdx_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","O niaheñe amo hasavereña’ i Menasèo: lime-ale-tsi-ro’arivo-tsi-fitonjato. ");
INSERT INTO tdx_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","O tarira’ i Efraime amo hasavereña’eoo: boak’ amy Sotèlake o nte-Sotèlakeo; boak’ amy Bèkere o nte-Bekereo; boak’ amy Tàkane o nte-Takaneo; ");
INSERT INTO tdx_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","le amo ana’ i Sotèlakeo: boak’ amy Eràne o nte-Eraneo. ");
INSERT INTO tdx_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Aa o niaheñe amo hasavereña’ i Efra­imeoo: telo-ale-tsi-ro’ arivo-tsi-liman-jato. Izay o tarira’ Iosèfe amo hasavereña’eoo. ");
INSERT INTO tdx_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","O tarira’ i Beniamène amo hasavereña’eoo: boak’ amy Bèla o nte-Belao; boak’ amy Asbèle o nte-Asbeleo; boak’ amy Akiràme o nte-Akirameo; ");
INSERT INTO tdx_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","boak’ amy Sefofàme o nte-Sefofameo; boak’ amy Kofàme o nte-Kofameo. ");
INSERT INTO tdx_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","O ana’ i Belao: i Arde naho i Naamàne: boak’ amy Arde o nte-Ardeo; boak’ amy Naamane o nte-Naamaneo. ");
INSERT INTO tdx_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Aa o niaheñe amo hasavereña’ i Beniamèneoo: efats’ ale-tsi-lime-arivo-tsi-enenjato. ");
INSERT INTO tdx_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","O tarira’ i Dane amo hasavereña’eoo: boak’ amy Sokàme o nte-Sokameo; Zao o tarira’ i Dane amo hasavereña’eoo; ");
INSERT INTO tdx_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","le ty ia’ o nte-Sokàmeo amo niaheñeo: eneñ’ ale-tsi-efats’ arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","O tarira’ i Asere amo hasave­reña’eoo: boak’ am’ Imnà o nte-Imnao; boak’am’ Isvý o nte-Isvìo; boak’ amy Berìa o nte-Beriao. ");
INSERT INTO tdx_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Aa naho o ana’ i Beriao: boak’ amy Kèbere o nte-Kèbereo; boak’ amy Malkièle o nte-Malkieleo; ");
INSERT INTO tdx_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","le Sèrake ty tahina’ ty anak’ ampela’ i Asere. ");
INSERT INTO tdx_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Zao o tarira’i Asere amo hasavereña’e niaheñeoo lime-ale-tsi-telo-arivo-tsi-efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","O tarira’i Naftalý an-kasavereña’eo: boak’ am’ Iaktseèle o nte-Iaktseèleo; boak’ amy Goný o nte-Gonio; ");
INSERT INTO tdx_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","boak’ am’ Iètsere o nte-Iètsereo; boak’ amy Silème o nte-Silemeo; ");
INSERT INTO tdx_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Zao o tarira’ i Asere amo hasavereña’e niaheñeo: efats’ ale-tsi-lime-arivo-tsy efa-jato. ");
INSERT INTO tdx_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Aa le ty ia’ o ana’ Israele niaheñeo: enen-ketse-tsi-arivo-tsi-fitonjato-tsi-telopolo. ");
INSERT INTO tdx_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Amo retiañe ty anjaràñe i taney ho lova ty ami’ty ia’ o tahinañeo. ");
INSERT INTO tdx_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Ho tolora’o lova bey ty maro le hanjarà’o lova kede ty tsy ampeampe; songa hanoloran-dova ami’ty hamaro’ o vinolily ama’eo. ");
INSERT INTO tdx_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Le an-tsapake ty hanjarañe i taney; ami’ty tahinan-droae’ o fifokoañeo ty handovà’ iareo aze. ");
INSERT INTO tdx_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Tsato-piso ty hanjarañe i lovay añivo’ ty maro naho ty tsy ampeampe. ");
INSERT INTO tdx_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Le zao ty famoliliañe o nte-Levio amo amori’eo: boak’ amy Geresòne o nte-Geresoneo, boak’ amy Kehàte o nte-Kehàteo; boak’amy Merarý o nte-Merario; ");
INSERT INTO tdx_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","le zao ty hasavereña’ o nte-Levio: ty hasavereña’ o nte-Libnìo, ty hasavereña’ o nte-Kebronio, ty hasavereña’ o nte-Maklìo; ty hasavereña’ o nte-Mosìo; vaho ty hasavereña’ o nte-Korahkìo. Le nisamake i Amrame t’i Kehate; ");
INSERT INTO tdx_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Iokèbede ana’ i Levy ty tahina’ ty vali’ i Amrame, nasama’ i Amrame t’i Aharone naho i Mosè vaho i Miriame rahavave’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Nasama’ i Aharone t’i Nadàbe naho i Abihò naho i Elazare vaho Itamare; ");
INSERT INTO tdx_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","sambe nihomake t’i Nadabe naho i Abiho, ie nañenga afo tsie am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Ty ia’ o niaheñe am’ iereoo: ro’ale-tsi-telo-arivo, songa lahilahy vola’e raike mañambone; ie tsy niaheñe amo ana’ Israeleo, amy te tsy nanoloran-dova amo ana’Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Irezay ty namolilia’ i Mosè naho i Elazare mpisoroñe, ie namolily o ana’ Israeleo an-tanemira’ i Moabe añ’olo’ Iardeney tandrife’ Ierikò eo. ");
INSERT INTO tdx_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Le amo vinolilio, leo raike tsy niahe’ i Mosè naho i Aharone mpisoroñe tamy famoliliañe o ana’ Israeleo am-patrambey Sinaiy. ");
INSERT INTO tdx_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Amy tsinara’ Iehovà am’ iareo ty hoe: Toe hivetrak’ am-patrambey ao iereo, aa le tsy nengàn-dahilahy naho tsy i Kalebe ana’ Iefone naho Iehosoa ana’ i None avao. ");
INSERT INTO tdx_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Niheo mb’eo amy zao o anak’ ampela’ i Tselofekhàde ana’ i Kèfere, ana’ i Gilàde, ana’i Makìre, ana’i Menasè ana’ Iosefeo; le zao ty tahina’ o anak’ ampela’eo: i Maklà, i Noae, Kog­làe, i Milka, vaho i Tirtsà, ");
INSERT INTO tdx_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","naho nijohañe añatrefa’ i Mosè naho i Elazare mpisoroñe naho o roandriañeo naho i hene valobohòkey an-dalan-kibohom-pamantañañe eo, nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Nivilasy am-patrambey añe ty rae’ay, f’ie tsy ni-mpiamo nifanontoñe niatreatre am’ Iehovào, tsy ni-mpiamy Kòrahke, fa nihomak’ amo hakeo’eo avao vaho tsy nanañ’ ana-dahy. ");
INSERT INTO tdx_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Aa vaho hasintak’ aman-drolongo’e hao ty tahinan-drae’ay amy te tsy aman’ anadahy? Ehe anoloro lova amo longon-droae’aio. ");
INSERT INTO tdx_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Nente’ i Mosè añatrefa’ Iehovà i saontsy zay. ");
INSERT INTO tdx_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Le nitsara amy Mosè t’Iehovà nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Mivolan-tò o anak’ ampela’ i Tselofekàdeo; toe hitolora’o lova amo lovan-drahalahin-drae’eo, vaho hampandovae’o ty lovan-drae’e. ");
INSERT INTO tdx_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Le saontsio amo ana’ Israeleo ty hoe: Naho vilasy t’indaty tsy nampipok’ ana-dahy, le hampandovae’ areo o anak’ ampela’eo ty lova’e. ");
INSERT INTO tdx_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Aa ie tsy aman’ anak’ampela le hatolo’o an-droahalahi’e ty lova’e. ");
INSERT INTO tdx_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Aa ie tsy aman-drahalahy, le hatolo’o an-droahalahin-drae’e ty lova’e. ");
INSERT INTO tdx_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Aa naho tsy aman-drahalahy ty rae’e le hatolo’o amy ze longo marine aze amy fifokoa’ey i lova’ey, vaho ie ty handova aze; ho fañè-jaka amo ana’ Israeleo izay amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Aa le hoe t’Iehovà amy Mosè: Mañambonea am-bohi’ Abarìme mb’ atoy, le oniño i tane atoloko amo ana’ Israeleoy. ");
INSERT INTO tdx_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Aa ihe mahaisak’ aze, le hatontoñe amo longo’oo manahake ty nanontoñañe i Aharone amo raha­lahi’eo. ");
INSERT INTO tdx_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Amy te niola’o i lilikoy amy nifandiera’ i valobohòkey am-patrambei’ i Tsiney, ihe tsy nañonjoñe ty engeko añatrefa’ iereo amy ranoy. (Ie i rano natao Meribà e Kadese am-pa­tram-bei’ i Tsiney.) ");
INSERT INTO tdx_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Le nisaontsy am’ Iehovà t’i Mosè nanao ty hoe, ");
INSERT INTO tdx_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Ee te hanendre ondaty hifehe i valobohòkey t’Iehovà Andrianañaharen’ arofo’ ze hene nofotse, ");
INSERT INTO tdx_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ie ty hiakatse naho hizilik’ añatrefa’ iareo, naho hiaolo iareo te mionjoñe, vaho hampipoly iareo, tsy mone hanao lian’ añondry tsy amam-piarake ty valobohò’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Le hoe t’Iehovà amy Mosè: Rambeso t’Iehosoa, ana’ i None, ondaty aman’ arofo, le anampezo fitàñe; ");
INSERT INTO tdx_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","avotraho aolo’ i Elazare naho añatrefa’ i valobohòkey re le orizo am-pahaoniña’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Le andivao ama’e ty lili’o, hivohora’ ty valobohò’ Israele. ");
INSERT INTO tdx_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Hijohañe añatrefa’ i Elazare mpisoroñe re, le ie ty hañontane ho aze ami’ ty fizakà’ i Orime añatrefan’ Añahare. Amy saontsi’ey ty hiavota’ iareo vaho amy saontsi’ey ty hiziliha’ iareo; ie naho o ana’ Israele mindre ama’eo, i valobohòkey. ");
INSERT INTO tdx_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Aa le nanoe’ i Mosè i nandilia’ Iehovà azey. Rinambe’e t’Ie­ho­soa vaho nampiheove’e añatrefa’ i Elazare mpisoroñe naho i valobohòkey; ");
INSERT INTO tdx_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","le nanongoa’e fitàñe vaho namantok’ aze, amy natoro’ Iehovà am-pità’ i Mosey. ");
INSERT INTO tdx_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Lilio o Ana’ Israeleo naho ano ty hoe: Ambeno’ areo amy andro famantañañ’ azey ty hañengàñe amako i hanekoy, i soroñañe amako ho hàñin-kanintsiñe amakoy. ");
INSERT INTO tdx_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Le ano ty hoe iereo: Zao ty hisoroñañe am’ Iehovà andro am-pohatse ho lilim-pisoroñañe: vik’ añondrilahy roe tsy aman-kandra. ");
INSERT INTO tdx_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Hengae’o maraindray ty vik’ añondry vaho hengae’o folakandro ty faharoe, ");
INSERT INTO tdx_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","reketse mona fahafolo’ ty efà linaro mena-piniritse fahèfa’ ty hine ho enga-mahakama. ");
INSERT INTO tdx_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Ie lilim-pisoroñañe norizañe ambohi-Sinay añe ho hàñin-kanintsiñe, fisoroñañe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Le songa añengañe enga-rano fahèfa’ ty hine i añondry roe rey; ailiñe am’ Iehovà amy toe-miavakey i divay soay ho enga-rano. ");
INSERT INTO tdx_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Engae’o ami’ ty folakandro i vik’ añondry ila’ey rekets’ i enga-maha­kama’ey naho i enga-rano’ey, hambañe amy nañengañe amy maraiñeiy ty hañenga’o aze: soroñe ho hàñin-kanintsiñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Ie ami’ty andro Sabotse, le vik’ añondrilahy roe tsy aman-kandra, naho mona fahafolo’ ty efa roe ho enga-mahakama, linaro menake naho i enga-rano’ey: ");
INSERT INTO tdx_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","zay ty hisoroñañe boa-tSabata ambone’ i enga hisoroñañe boak’ àndroy rekets’ i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Mañengà soroñe am’ Iehovà amo jiri-bola’ areoo: bania roe, añon­drilahy raike, vik’ añondrilahy fito tsy aman-kandra; ");
INSERT INTO tdx_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","naho songa mona fahafolo’ ty efà telo linaro menake ty bania; naho fahafolo’ ty efà roe linaro menake ho enga-mahakama, i añondri­lahiy; ");
INSERT INTO tdx_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","le sindre mona fahafolo’ ty efà linaro menake ho enga-mahakama ty vik’ añondry, enga olorañe, hàñin-kanintsiñe, soroñañe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","songa ho divay vaki’ ty hine ty bania, sindre fahatelo’ ty hine i añondrilahiy vaho fonga fah’efa’ ty hine ty vik’ añondry. Izay ty hisoroñañe an-jiri-bola’ ze hene volañe amo taoñeo. ");
INSERT INTO tdx_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Le forototò ho engan-kakeo am’ Iehovà ty oselahy; ho tovo’ i soroñe boak’ andro rekets’ i enga-rano’eiy. ");
INSERT INTO tdx_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Ami’ty andro faha-folo-efats’ambi’ i volam-baloha’ey ty Pèsa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Le hanoeñe sabadidake amy andro faha folo-lime-ambi’ i volañeiy; ho kamaeñe fito andro ty mofo po-dalivay. ");
INSERT INTO tdx_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Hanao fañohara-miavake nahareo amy andro valoha’ey; tsy itolonan-draha. ");
INSERT INTO tdx_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Le mibanabanà enga hisoroñañe am’ Iehovà: bania roe, ty añondrilahy, naho ty vik’ añondrilahy fito, asoao te tsy aman-kandra. ");
INSERT INTO tdx_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Mona linaro menake ty enga-maha­kama’ iareo, songa fahafolo’ ty efà telo ty bania, naho fahafolo’ ty efà roe i añondrilahiy; ");
INSERT INTO tdx_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","le sindre fahafolo’ ty efà ty vik’ añondry, ho a i vi’e fito rey; ");
INSERT INTO tdx_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","vaho oselahy ty ho engan-kakeo hijebañañe anahareo. ");
INSERT INTO tdx_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Halankañe’ areo ho tovo’ i enga marain­draiñey, i enga boak’ androy. ");
INSERT INTO tdx_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Izay ty fañengañe boak’ andro, fito andro, ty mahakama’ i enga fisoroñañey, hàñin-kanintsiñe am’Iehovà, engaeñe ho tovo’ i enga boak’ àndroy naho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","le hanao fañohara-miavake nahareo ami’ty andro fahafito. Tsy itoloñan-draha. ");
INSERT INTO tdx_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Ie amy andron-dengom-boay, le mibanabanà enga-mahakama vao am’ Iehovà amy sabadida-kereñandro’ areoy, le ano fañohara-miavake vaho ko mitolon-draha. ");
INSERT INTO tdx_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Mibanabanà enga hisoroñañe ho hàñin-kanintsiñe am’ Iehovà: bania roe, ty añondri­lahy raike vaho ty vik’añondrilahy fito, ");
INSERT INTO tdx_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","mitraok’ ami’ty mona linaro menake ho enga-mahakama’e: songa fahafolo’ ty efà telo ty bania, naho fahafolo’ ty efà roe i añondrilahiy ");
INSERT INTO tdx_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","sindre fahafolo’ ty efà ty vik’ añondry ho amy vi’e fito rey; ");
INSERT INTO tdx_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","vaho ty vik’ oselahy hijebañañe anahareo. ");
INSERT INTO tdx_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Hengae’ areo ho tovo’ i soroñañe nainai’ey rezay, naho o enga mahakama’e naho enga-rano’e. Asoao t’ie tsy ho aman-kandra. ");
INSERT INTO tdx_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Amy andro valoha’ i volam-pahafitoy, le hanao fañohara-miavake nahareo. Tsy hitolon-draha, fa andro fipoñafam-peo ho anahareo. ");
INSERT INTO tdx_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Mañengà soroñe, hàñin-kanintsiñe am’ Iehovà: ty bania, ty añondrilahy vaho ty vik’ añondrilahy fito tsy aman-kandra. ");
INSERT INTO tdx_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Ty enga-mahakama’e le mona linaro menake: telo am-pahafolo’ ty efà ho amy baniay, le roe am-pahafolo’ ty efà ho amy añondrilahiy, ");
INSERT INTO tdx_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","le songa fahafolo’ ty efà ty vik’ añondrilahy amy fito rey; ");
INSERT INTO tdx_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","vaho ty vik’ oselahy ho engan-kakeo hañeferañe anahareo, ");
INSERT INTO tdx_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ho tovo’ i enga hisoroñañe amy pea-bolañeiy, rekets’ i enga-mahakama’ey naho i soroñe boak’ àndroy rekets’ o enga-mahakama’eo naho o enga-rano’eo miomba ty fañè’ iareo, ho hàñin-kanintsiñe soroñañe am’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Amy andro faha-folo’ i volam-paha-fitoy ty hanoa’ areo fañohara-miavake, le hilie-batañe tsy hifanehak’ amo tolon-draha’ areoo. ");
INSERT INTO tdx_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Hañenga soroñe am’ Iehovà nahareo; hàñin-kanintsiñe: bania raike, añondrilahy raike, naho vik’ añondrilahy fito, songa tsy aman-kandra. ");
INSERT INTO tdx_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ty enga-mahakama ama’e le mona linaro menake: fahafolo’ ty efà telo i baniay, fahafolo’ ty efà roe i añondrilahiy, ");
INSERT INTO tdx_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","naho sindre fahafolo’ ty efà ty vik’ añondry amy vi’e fito rey; ");
INSERT INTO tdx_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","vaho ty vik’oselahy ho engan-kakeo, ho tovo’ i engan-kakeo ho ,fijebañañey naho i soroñe boak’ àndroy rekets’ o enga-mahakama’eo naho o enga-rano’eo. ");
INSERT INTO tdx_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Amy andro faha folo-lime-ambi’ i volam-paha-fitoy, manoa fañohara-miavake le ko mitolon-draha, vaho ano sabadidak’ am’ Iehovà fito andro. ");
INSERT INTO tdx_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Mañengà soroñe, engan-koroañe ho hàñin-kanintsiñe am’ Iehovà: bania folo-telo’ amby, añondrilahy roe naho vik’ añondrilahy folo-efats’ amby, songa tsy aman-kandra. ");
INSERT INTO tdx_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Ty enga-mahakama’ iareo, le mona linaro menake: songa ty faha­folo’e telo i bania folo-telo’amby rey, sindre ty faha­folo’e roe i añondrilahy roe rey, ");
INSERT INTO tdx_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","vaho sambe ty fahafolo’e i vik’ añondrilahy folo-efats’ amby rey ");
INSERT INTO tdx_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","le ty vik’ose ho engan-kakeo, tovo’ i soroñe boak’ andro rey, naho i enga-mahakama’ey naho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Amy andro faha-roey: bania folo-ro’ amby; añondrilahy roe, vik’ añondry folo-efats’ amby tsy aman-kandra, ");
INSERT INTO tdx_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","naho ty enga-mahakama naho enga-rano amy bania rey naho amy añondrilahy rey vaho amy vik’ añondrilahy rey, ty amy ia’ iareo naho i fañè’ey; le ty vik’oselahy ho engan-kakeo, ");
INSERT INTO tdx_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","tovo’ i soroñe boak’ àndroy naho i enga-mahakama’ey vaho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Amy andro faha teloy: bania folo-raik’amby; añondrilahy roe, vik’ añondry folo-efats’amby tsy aman-kandra, ");
INSERT INTO tdx_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","naho ty enga-mahakama naho enga-rano amy bania rey naho amy añondrilahy rey vaho amy vik’ añondrilahy rey, ty amy ia’ iareo naho i fañè’ey; ");
INSERT INTO tdx_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","le vik’ oselahy raike ho engan-kakeo, tovo’ i soroñe boak’ àndroy naho i enga-mahakama’ey naho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Amy andro fahefatsey: bania folo, añondrilahy roe, vik’añondry folo-efats’ amby tsy aman-kandra, ");
INSERT INTO tdx_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","naho ty enga-mahakama naho enga-rano amy bania rey naho amy añondrilahy rey vaho amy vik’ añondrilahy rey, ty amy ia’ iareo naho i fañè’ey; ");
INSERT INTO tdx_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","le ty vik’oselahy ho engan-kakeo, tovo’ i soroñe boak’ àndroy naho i enga-mahakama’ey vaho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Amy andro fahalimey: bania sive, añondrilahy roe, vik’ añondry folo-efats’amby tsy aman-kandra, ");
INSERT INTO tdx_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","naho ty enga-mahakama naho enga-rano amy bania rey naho amy añondrilahy rey vaho amy vik’ añondrilahy rey, ty amy ia’ iareo naho i fañè’ey; ");
INSERT INTO tdx_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","le ty vik’ oselahy ho engan-kakeo tovo’ i soroñe boak’ àndroy naho i enga-mahakama’ey vaho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Amy andro faheneñey: bania valo, añondrilahy roe, vik’ añondry folo-efats’amby tsy aman-kandra, ");
INSERT INTO tdx_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","naho ty enga-mahakama naho enga-rano amy bania rey naho amy añondrilahy rey vaho amy vik’ añondrilahy rey, ty amy ia’ iareo naho i fañè’ey; ");
INSERT INTO tdx_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","le ty vik’ oselahy ho engan-kakeo tovo’ i soroñe boak’ àndroy naho i enga-mahakama’ey vaho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Amy andro faha-fitoy: bania fito, añondrilahy roe, vik’ añondry folo-efats’amby tsy aman-kandra, ");
INSERT INTO tdx_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","naho ty enga-mahakama naho enga-rano amy bania rey naho amy añondrilahy rey vaho amy vik’ añondrilahy rey, ty amy ia’ iareo naho i fañè’ey; ");
INSERT INTO tdx_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","le ty vik’ oselahy ho engan-kakeo, tovo’ i soroñe boak’ àndroy naho i enga-mahakama’ey vaho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Amy andro faha-valoy le manoa fifanontoñañe miavake naho ko mitolon-draha. ");
INSERT INTO tdx_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Mañengà soroñe, banabana oroañe, hàñin-kanintsiñe am’ Iehovà: ty bania, le ty añondrilahy naho vik’ añondrilahy fito tsy aman-kandra, ");
INSERT INTO tdx_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","naho ty enga-mahakama naho enga-rano amy baniay naho amy añondrilahy rey vaho amy vik’ añondrilahy rey, ty amy ia’ iareo naho i fañè’ey; ");
INSERT INTO tdx_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","le vik’oselahy raike ho engan-kakeo, tovo’ i soroñe boak’ àndroy naho i enga-mahakama’ey vaho i enga-rano’ey. ");
INSERT INTO tdx_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Ie ty hengae’ areo am’ Iehovà amo andro namantañañeo, (mandikoatse ze enga-ava-panta ndra engan-tsatrin’ arofo’ areo) ho fisoroña’ areo naho ho enga-rano’ areo vaho ho engam-pañanintsi’ areoo. ");
INSERT INTO tdx_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Aa le nitaroñe’ i Mosè amo ana’ Israeleo, ze hene nafanto’ Iehovà amy Mosèy. ");
INSERT INTO tdx_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Le nanao ty hoe amo talèm-pifokoa’ o ana’ Israeleoo t’i Mosè: Zao ty nandilia’ Iehovà: ");
INSERT INTO tdx_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Naho mifanta am’ Iehovà t’indaty, ndra mitangèñe hifahara’ ty arofo’e ami’ty lahatse, le tsy hivalik’ amy saontsi’ey re, fa hanoe’e ze hene miakatse am-palie’e. ");
INSERT INTO tdx_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Aa naho mifanta am’ Iehovà ty ampela, ke mitan-ty vata’e aman-titike, ie añ’anjom­ban-drae’e ao naho mbe somondrara, ");
INSERT INTO tdx_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","fa naho mahajanjiñe i nifantà’ey ty rae’e naho i titike namahora’e ty tro’ey vaho mianjiñe avao ty rae’e, le fonga hijadoñe o nifantà’eo, le hifahatse ze titike namahora’e troke. ");
INSERT INTO tdx_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","F’ie lieren-drae’e amy andro naha­janjiña’e azey, le tsy hijadoñe i nifantà’ey ndra ze titike namahora’e troke vaho hapo’ Iehovà ty aze, ty amy lien-drae’ey. ");
INSERT INTO tdx_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Aa ie nengaen-dahy te vahoram-panta, ke t’ie finehe’ ze volañe naakan-tsoñi’e tsy nisatrie’e, ");
INSERT INTO tdx_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","le ie janji’ ty vali’e fe tsy mañaoñe amy andro nijanjiña’e azey, le hijadoñe i nifantà’ey vaho hifahatse ze titike nama­hora’e troke. ");
INSERT INTO tdx_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","F’ie liere’ ty vali’e amy andro nijanjiña’e azey le hapo’e i fanta nifehe azey, ndra i volan-tsoñi’e tsy nisatrie’e namahora’e trokey; toe hado’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","(Fe ze nifantà’ ty vantotse ndra ty nariam-baly, ie namahotse ty arofo’e, le hijadoñe hifehe aze izay.) ");
INSERT INTO tdx_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Aa naho nifanta añ’an­jom­bam-bali’e ao, ke namaho-batañe aman-titike ");
INSERT INTO tdx_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","naho nahajanjiñe aze i vali’ey ie tsy nandietse, le hijadoñe iaby o nifantà’eo vaho hifahatse ama’e ze titike namahora’e arofo. ");
INSERT INTO tdx_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","F’ie avali’ ty vali’e amy andro naha­janjiña’ey, le tsy hijadoñe ndra inoñ’ inoñe niakats’ an-tsoñi’e amo ni­fantà’eo ndra amy titike namahora’e trokey; fa navali’ ty vali’e, le hapo’ Iehovà re ty ama’e. ");
INSERT INTO tdx_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Ze fanta ndra titike famahoram-batañe, le azo ty vali’e ajadoñe ndra faoheñe. ");
INSERT INTO tdx_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Fe naho tsy mañaoñe aze handro am-pohatse i vali’ey, le hene hampijadoñe’e o nifantà’eo, naho ze mamahotse ty tro’e; toe niventese’e, kanao tsy nisaontsie’e amy andro nahajanjiña’e azey. ");
INSERT INTO tdx_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Aa naho avali’e t’ie añe i nijanjiña’e azey le hivave i tahi’ey i lahilahiy. ");
INSERT INTO tdx_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Ie o fañè linili’ Iehovà añamy Mosèo amy t’indaty naho i vali’ey, naho aman-drae naho ty anak’ ampela’e mbe kede añ’ anjomban-drae’e ao. ");
INSERT INTO tdx_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Hoe ty nitsara’ Iehovà amy Mosè, ");
INSERT INTO tdx_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Ampamaleo fate amo nte-Midianeo o ana’ Israeleo. Ie heneke izay le hatontoñe am’ondati’oo irehe. ");
INSERT INTO tdx_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Aa le nisaontsy am’ ondatio t’i Mosè nanao ty hoe: Ampidiaño ty ila’e ama’ areo hialy, vaho iraho haname o nte-Midianeo hamale i Midiane ty am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Songa hañitrik’ arivo mb’amy aliy mb’eo ze fifokoa’ Israele. ");
INSERT INTO tdx_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Aa le hene nanolotse arivo boak’ amy lahiale’ Israeley o fifokoañeo, rai-ale-tsi-ro’arivo reke-pialiañe. ");
INSERT INTO tdx_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Le nampionjone’ i Mosè mb’ añ’aly mb’eo kiarivo-kiarivo’ o fifokoañeo; le nampindreze’e am’ iereo t’i Pinekàse ana’ i Elazàre ninday o fanake miavakeo naho o antsiva fikoihañeo am-pità’e. ");
INSERT INTO tdx_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Tiname’ iareo t’i Midiane ami’ty nandilia’ Iehovà i Mosè vaho vinono ze hene atao lahilahy. ");
INSERT INTO tdx_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Fonga naharo vono am’ iereo o mpanjaka’ i Midianeo: i Evý, naho i Rèkeme naho i Tsore naho i Kòre vaho i Rèba; i mpanjaka’ i Midiane lime rey vaho vinono am-pibara ka t’i Balame ana’i Beore. ");
INSERT INTO tdx_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Le kinopa’ o ana’ Israeleo ze hene rakemba naho o keleia’ o nte-Midianeoo, naho hene kinopa’ iareo o añombeo naho o mpirai-lia’eo naho o vara’eo; ");
INSERT INTO tdx_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","fonga finorototo añ’ afo o rova nimoneña’ iareoo naho ze hene tobe’ iareo, ");
INSERT INTO tdx_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","le rinambe’ iareo ze dinohitse iaby naho ze fonga kinopake: ondaty naho hare. ");
INSERT INTO tdx_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Nendese’ iareo mb’ amy Mosè naho i Elazare mpisoroñe naho i valobohò’ Israeley mb’eo ondaty iabio naho o varao vaho ze raha kinopake mb’ an-tobe a montombei’ i Moabe aolo’ Iardeney tandrife Ieriko mb’eo. ");
INSERT INTO tdx_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Niavotse amy zao t’i Mosè naho i Elazare mpisoroñe naho o talè’ i valobohòkeio hifanalaka am’ iereo alafe’ i tobey. ");
INSERT INTO tdx_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Fe niviñera’ i Mosè o mpiaolo’ o lahindefoñeoo, naho i mpifelek’ arivo rey, naho i mpifehe ki-zato rey, o niboak’ amy hotakotakeio. ");
INSERT INTO tdx_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Le hoe t’i Mosè am’ iereo: Hene nenga’ areo ho veloñe hao o ampelao? ");
INSERT INTO tdx_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Inao, ie ty nampiola o ana’ Israeleo amy Iehovà ie nikililie’ i Balame amy raha e Peorey, vaho nametsahañe angorosy ty valobohò’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Aa le fonga vonò ze lahilahy amo keleia’eo naho ze ampela fa niolots’ ama’ ondaty. ");
INSERT INTO tdx_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Fe tano ho anahareo ze ampela mbe tsy niharo sarimbo ama’ ondaty. ");
INSERT INTO tdx_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Le ie namono ondaty ndra nitsapa ty vinono ro mitoboha alafe’ i tobey fito andro; miefera vatañe ami’ty andro faha-telo naho ami’ ty andro faha-fito; inahareo naho o finao’ areoo. ");
INSERT INTO tdx_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Le liovo iaby ze sikiñe naho ze nanoeñe an’ angozy naho ze ri­nare am-bolon’ ose vaho ze raha an-katae. ");
INSERT INTO tdx_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Le hoe t’i Elazare mpisoroñe amo lahin-defo niatreke i aliio: Zao ty fañèmpètse linili’ Iehovà i Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ze volamena naho volafoty naho torisìke naho viñe naho endraendra vaho firake— ");
INSERT INTO tdx_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ze raha mete asitrik’ añ’afo avao—ro hampisorohe’ areo añ’afo, le halio, f’ie mbe heferañe an-dranom-pañeferañe. Le ze raha tsy mahaleo afo ro hampisoroheñe rano. ");
INSERT INTO tdx_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Le ho sasà’ areo ami’ ty andro faha-fito ty siki’ areo vaho halio, ie heneke izay le mahazo mizilik’ an-tobe ao. ");
INSERT INTO tdx_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Volilio, ihe naho i Elazare mpisoroñe naho o talèn-droae’eo ze fonga raha kinopake: ondaty naho hare. ");
INSERT INTO tdx_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Zarao roe o kinopakeo: ty raike ho amo nañavelo niatrek’ i aliio le ty raike ho amy valobohòkey. ");
INSERT INTO tdx_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Le ampandivao o lahindefoñe niatre-kotakotakeo ty raik’ ami’ ty liman-jato ho enga am’ Iehovà, ke t’ie ondaty, he te añombe, ke borìke he añondry, hera ose. ");
INSERT INTO tdx_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Rambeso ami’ty vaki’ iareo, vaho atoloro amy Elazare mpisoroñe ho engan-kavoañe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Le ampandivao ami’ty anjara’ o ana’ Israeleo ka ty raik’ ami’ty limampolo’ ze ondaty naho añombe naho borìke naho añondry naho ze hare iaby vaho atoloro amo nte-Levy mpiatrake i kivoho’ Iehovàio. ");
INSERT INTO tdx_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Le nanoe’ i Mosè naho i Elazare mpisoroñe i nandilia’ Iehovà i Mosey. ");
INSERT INTO tdx_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Ty vara nisisa amy nikopahe’ o lahindefoñeoy le añondry enen-ketse-tsi-fito-ale-tsi-lime-arivo, ");
INSERT INTO tdx_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","naho añombe fito-ale-tsi-ro’arivo, ");
INSERT INTO tdx_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","naho borìke eneñ’ ale-tsi-arivo, ");
INSERT INTO tdx_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","naho ondaty telo-ale-tsi-ro’ arivo: hene somondrara mboe tsy niolots’ ama’ ondaty. ");
INSERT INTO tdx_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Ty vaki’e raike, ty anjara’ o niatre-kotakotakeo, le añondry naho ose telo-hetse-tsi-telo-ale-tsi-fito-arivo-tsi-liman-jato, ");
INSERT INTO tdx_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","le o añondry naho ose nengaeñe am’Iehovào enenjato tsy-fitompolo-lim’ amby. ");
INSERT INTO tdx_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Le telo-ale-tsi-eneñ’ arivo ty añombe, aa le fitom-polo-ro’ amby ty nengaeñe am’Iehovà; ");
INSERT INTO tdx_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","telo-ale-tsi-liman-jato ty borìke vaho enempolo-raik’ amby ty nengaeñe am’ Iehovà; ");
INSERT INTO tdx_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","rai-ale-tsi-eneñ’ arivo ty ia’ondatio vaho telopolo-ro’amby ty nengaeñe am’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Aa le natolo’ i Mosè amy Elazare mpisoroñe ty anjara’ Iehovà, ami’ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Aa naho ty vaki’ i valobohòke navi’ i Mosè ami’ty anjara’ o lahin­defoñeoy; ");
INSERT INTO tdx_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ty vaki’ i valobohòkey telo-hetse-tsi-telo-ale-tsi-fito-arivo-tsi-liman-jato añondry naho ose, ");
INSERT INTO tdx_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","le telo-ale-tsi-eneñ’arivo ty añombe, ");
INSERT INTO tdx_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","naho telo-ale-tsi-liman-jato ty borìke, ");
INSERT INTO tdx_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","vaho rai-ale-tsi-eneñ’ arivo ty ia’ondatio. ");
INSERT INTO tdx_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Amy vaki’ o ana’ Israeleo, le nangala’ i Mosè raik’ ami’ty limampolo, ondaty naho hare, le natolo’e amo nte-Levio—o mpiatrake i kivoho’ Iehovào amy nandilia’ Iehovà i Mosèy. ");
INSERT INTO tdx_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Niheo amy Mosè mb’eo amy zao o mpiaolo nifehe o arivo nialio, toe o mpifelek’ arivoo naho o mpifehe zatoo; ");
INSERT INTO tdx_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","le nanao ty hoe amy Mosè: Fa niahe’ o mpitoro’oo o lahindefo nifelehe’aio, leo raike tsy nipoke. ");
INSERT INTO tdx_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Aa le mañenga ravoravo am’ Iehovà zahay, ze niazo’ ondatio ke ravake volamena ke vangovango ke tsiandetse ke bange fitomboke ke kiviro he ètse, ho fijebañañe añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Ri­nambe’ i Mosè naho i Elazare mpisoroñe am’ iereo o volamenao naho o bangeo vaho ze hene bijo, ");
INSERT INTO tdx_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","le ty ton­tom-bolamena nengae’ iareo ho am’ Iehovà, boak’ amo mpifelek’ arivoo vaho o mpifehe zatoo: rai-ale-tsi-eneñ’ arivo-tsi-fitonjato-tsi-limampolo sekele, ");
INSERT INTO tdx_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","amy te songa nikopake ho am-bata’e o lahindefoñeo. ");
INSERT INTO tdx_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Aa le rinambe’ i Mosè naho i Elazare mpisoroñe amo mpifelek’ arivo naho zatoo i volamenay, vaho nendese’ iereo am-po’ i kibohom-pamantañañey ho fitiahiañe o ana’ Israeleo añatrefa’ Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Ie amy zao ni-tsifotofoto ty añombe’ i fifokoa’ i Reòbene naho i Gade rey; aa ie nahaisake ty tane’ Ia’azère naho ty tane’ i Gilade, t’ie toe tane fiandrazañe añombe, ");
INSERT INTO tdx_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","le nimb’amy Mosè naho i Elazare mpisoroñe naho mb’amo talè’ i valobohòkeio mb’eo o ana’ i Gadeo naho o ana’ i Reòbeneo ninday ty saontsy ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","I Ataròte naho i Dibone, naho Iaazère, naho i Nimrà, naho i Kesbòne, naho i Elalè, naho i Sebàme, naho i Nebò vaho i Beòne; ");
INSERT INTO tdx_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","i tane ginio’ Iehovà añatrefa’ i valobohò’ Israeleiy, le tane fiandrazañe añombe, vaho aman’ añombe o mpitoro’oo. ");
INSERT INTO tdx_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Tinovo’ iereo ty hoe: Aa naho nisoheñe am-pahaisaha’o, le atoloro amo mpi­toro’oo i tane zay ho fanaña’e, fa ko minday anay hitsake Iardeney. ");
INSERT INTO tdx_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Aa hoe ty navale’i Mosè o ana’i Gadeo naho o ana’ i Reobeneo, Aa vaho hiatrek’ aly o rahalahi’ areoo, le hihànitse atoy avao nahareo? ");
INSERT INTO tdx_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Ino ty hampimamoa’ areo ty arofo’ o ana’ Israeleo tsy hitsaha’e mb’an-tane nitolora’ Iehovà mb’eo? ");
INSERT INTO tdx_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Izay ty nanoen-droae’ areo te niraheko boak’e Kadese-Barnea hitilike i taney. ");
INSERT INTO tdx_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Amy t’ie nionjoñe mb’ am-bavatane’ i Eskòle mb’eo vaho nahaoniñe i taney le nahamohake ty arofo’ o ana’ Israeleo tsy hizilik’ an-tane natolo’ Iehovà iareo. ");
INSERT INTO tdx_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Aa le nisolebotse amy andro zay ty haviñera’ Iehovà vaho nifanta ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Toe tsy amo lahilahy roapolo taoñe mañambone niavotse i Mitsraimeo ty hahaisake ty tane nifantàko amy Avrahame naho am’ Ietsàke naho am’ Iakòbe, amy t’ie tsy nañorik’ ahiko añ-kaàmpon-troke, ");
INSERT INTO tdx_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","naho tsy i Kalebe ana’ Iefonè nte-Kenàze naho Iehosoa, ana’ i None, amy te norihe’ iareo an-kaliforan’ arofo t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Aa le niforoforo am’ Israele ty haviñera’ ­Iehovà vaho nampirerererè’e am-patrambey añe efa-polo taoñe, am-para’ te nimodo iaby i tariratse nanao raty am-pivazohoa’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Le heheke! t’ie nitroatse handimbe an-droae’ areo nifirimboñan-kalòn-tsere­keo, hanitrà’ areo ty haviñerañe mitrotrofiak’ Iehovà am’ Israele. ");
INSERT INTO tdx_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Aa ie miamboho, tsy mañorik’ aze, le ho farie’e am-patrambey ao indraike iereo, toly ndra harotsa’ areo ondaty retiañe. ");
INSERT INTO tdx_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Aa le niharivoa’ iareo nanao ty hoe: Hañamboara’ay goloboñe atoy o hare’aio vaho rova ho a o keleia’aio, ");
INSERT INTO tdx_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","fe hitan-defon-jahay hiaolo o ana’ Israeleo ampara’ te nasese’ay an-toe’ iareo añe. Ie amy zay himoneñe an-drova iarikatohan-kijoly ao ty amo mpimoneñe amy taneio o keleia’aio. ");
INSERT INTO tdx_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Tsy himpoly mb’ añ’ anjomba’ay mb’eo zahay naho tsy songa nandrambe ty lova’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Tsy hitrao-dova am’ iereo alafe’ Iardeney añe zahay, amy te nitsatoke ho anay atiña­na’ Iardeney atoy ty lova’ay. ");
INSERT INTO tdx_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Hoe t’i Mosè am’ iereo: Aa naho toe hanoe’ areo izay, t’ie hitan-defoñe aolo’ Iehovà veka’e hialy, ");
INSERT INTO tdx_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","naho songa hitsake Iardaney añatrefa’ Iehovà o lahin-defo’ areoo, ampara’ te fonga hanoe’e soike aolo’e eo o rafelahi’eo, ");
INSERT INTO tdx_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","naho hene vinahotse añatrefa’ Iehovà i taney; izay vaho himpoly nahareo, le ho afa-tahiñe añatrefa’ Iehovà naho aolo’ Israele, vaho ho fanaña’ areo añatrefa’ Iehovà ty tane atoy. ");
INSERT INTO tdx_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","F’ie tsy hanoe’ areo, le inao! hanan-kakeo am’ Iehovà; le iantofo te hifanojo ama’ areo ty tahi’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Añoreño rova o keleia’ areoo vaho goloboño o añondri’ areoo, le ano o nakarem-palie’ areo iabio. ");
INSERT INTO tdx_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Aa le nanao ty hoe amy Mosè o nte-Gadeo naho o nte-Reòbeneo: Hanoe’ o mpitoro’oo ze andilian-talè’ay. ");
INSERT INTO tdx_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Hitobe amo rova’ i Giladeo o keleia’aio naho o vali’aio vaho o hare’ay iabio, ");
INSERT INTO tdx_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","fe hitsake mb’eo o mpitoro’oo, songa lahilahy aman-defoñe veka’e hialy hihotakotake ho a Iehovà, amy nandilia’ i talèkoiy. ");
INSERT INTO tdx_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Aa le linili’i Mosè t’i Elazare mpisoroñe naho Iehosoa ana’ i None vaho o talèn’ anjombam-pifokoa’ Israeleo ty am’ iereo, ");
INSERT INTO tdx_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","le nanoe’ i Mosè ty hoe: Naho mindre ama’ areo mitsake Iardeney añatrefa’ Iehovà ze hene mpitan-defo veka’e hialy amo ana’ i Gadeo naho amo ana’ i Reòbeneo, naho ampiambanèñe aolo’ areo i taney, le atoloro iareo ty tane’ i Gilade ho fanaña’e. ");
INSERT INTO tdx_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","F’ie tsy mitsake reke-pialiañe mindre ama’ areo le hanam-panañañe miharo ama’ areo an-tane Kanàne ao. ");
INSERT INTO tdx_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Le hoe ty natoi’ o nte-Gadeo naho o nte-Reòbeneo, Ze nitsara’ Iehovà amo mpitoro’oo ro hanoe’ay. ");
INSERT INTO tdx_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Hitsake reke-pialiañe añatrefa’ Iehovà zahay mb’ an-tane Kanàne mb’ eo fe hitobok’ atiñana’ Iardeney atoy ty hanañañe nilovà’aiy. ");
INSERT INTO tdx_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Aa le natolo’ i Mosè amo nte-Gadeo naho amo nte-Reòbeneo vaho ami’ty vakim-pifokoa’ i Menasè ana’ Iosefe, ty fehe’ i Sihone mpanjaka’ o nte-Amoreo naho ty fehe’ i Oge mpanjaka’ i Basàne, i taney rekets’ o rova’eo naho o tanàñe mañohokeo rekets’ o tane’eo. ");
INSERT INTO tdx_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Le namboare’ o nte-Gadeo ty Dibòne, naho i Ataròte, naho i Aroère, ");
INSERT INTO tdx_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","naho i Atròte-sofàne, naho Ia’azère, naho Iogbehà, ");
INSERT INTO tdx_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","naho i Bète Nimrà, vaho i Bete Haràne, songa rova aman-kijoly naho golobon’ añondry. ");
INSERT INTO tdx_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Le namboare’ o nte-Reòbeneo ty Kesbòne, naho i Elalè, vaho i Kiriatàime, ");
INSERT INTO tdx_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","naho i Nibò, naho i Baal­meòne, (ie novaeñe o añara’ iareoo) vaho i Sebàme, le nomeañe añarañe ze rova namboare’ iereo. ");
INSERT INTO tdx_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Le nomb’e Gilade mb’eo o tarira’ i Makire ana’ i Menasèo le tinava’ iereo vaho nanoe’ iereo soike o nte-Amore tama’eo. ");
INSERT INTO tdx_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Aa le natolo’ i Mosè amy Makire ana’ i Menasè ty Gilade le nimoneña’e. ");
INSERT INTO tdx_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Rinambe’ Iaìre ka o tanà’eo vaho nitokave’e Kavòte Iaìre. ");
INSERT INTO tdx_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Nomb’eo ka t’i Nòbake nitavañe i Kenàte naho o tanà’eo, le nitokave’e ty hoe Nobake, i tahina’ey avao. ");
INSERT INTO tdx_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Zao o fangem-pañaveloa’ o ana’ Israeleo te niavotse an-tane Mitsraime añe am-pivovoran-dahindefoñe ambane’ ty fehe’ i Mosè naho i Aharoneo. ");
INSERT INTO tdx_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Sinoki’ i Mosè o fiorotan-dia’ iareo ki-fange-fange’e ami’ ty lili’ Iehovào; le zao o fange’eo ty amo toe-piengà’eo. ");
INSERT INTO tdx_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Nenga’ iareo ty Ramesèse ami’ ty volam-baloha’e, ami’ty andro faha folo-lime’ ambi’ i volam-baloha’ey; ami’ty andro nanonjohy i Fihelañ’ Ambone’ o ana’ Israeleoy ty niavota’ iareo an-kavokavoke am-pahaisaha’ o nte-Mitsraime iabio, ");
INSERT INTO tdx_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","naho nandeveñe o tañoloñoloña’e iabio o nte-Mitsraimeo, o nipaohe’ Iehovà añivo’ iereoo, vaho nametsaha’ Iehovà zaka o ndrahare’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Aa le nienga i Ramesese o ana’ Israeleo naho nitobe e Sokòte; ");
INSERT INTO tdx_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","nienga i Sokòte vaho nitobe Etàme añ’olo’ i fatrambeiy. ");
INSERT INTO tdx_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Nionjoñe boak’ Etàme le niolake mb’e Pihakiròte atiñana’ i Baale-Tsefòne mb’eo vaho nitobe marine i Migdòle. ");
INSERT INTO tdx_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Ie nenga i Pihakirote, le nisoroke i riakey naho nañavelo telo andro am-patrambey Etame vaho nitobe e Marà. ");
INSERT INTO tdx_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Nenga’ iareo ty Marà le nipotìtse e Elime ao; aman-drano manganahana folo roe-ambi’ ty Elime naho satrañe fitompolo vaho nitobeañe. ");
INSERT INTO tdx_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Ie nienga i Elime le nitobe añ’ olo’ i Ria-Binday, ");
INSERT INTO tdx_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","nienga i Ria-Binday le nitobe ampatrambei’ i Sine, ");
INSERT INTO tdx_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","niavotse i fatrambei’ i Siney le nitobe e Dofkà, ");
INSERT INTO tdx_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","nienga i Dofkà le nitobe e Alòse, ");
INSERT INTO tdx_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","nienga i Alòse vaho nitobe e Refidìme, f’ie tsy aman-drano ho kamae’ ondatio. ");
INSERT INTO tdx_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Ie nienga i Refidime le nitobe am-patrambei’ i Sinay, ");
INSERT INTO tdx_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ni­enga i Fatrambey Sinay vaho nitobe e Kibròtatahavà. ");
INSERT INTO tdx_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Ie nienga i Kib­ròtatahavà le nitobe e Katseròte, ");
INSERT INTO tdx_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","nienga i Katseròte le nitobe e Ritmà, ");
INSERT INTO tdx_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","nienga i Ritmà le nitobe e Rimòne Pèretse, ");
INSERT INTO tdx_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","nienga i Rimòne Pèretse le nitobe e Libnà, ");
INSERT INTO tdx_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","nienga i Libnà le nitobe e Risà, ");
INSERT INTO tdx_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","nienga i Risà le nitobe e Kehelàta, ");
INSERT INTO tdx_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","nienga i Kehelàta le nitobe e Vohi-Sèfere, ");
INSERT INTO tdx_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","nienga i Vohi-Sè­fere le nitobe e Karadà, ");
INSERT INTO tdx_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","nienga i Karadà le nitobe e Makelòte, ");
INSERT INTO tdx_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","nienga i Makelòte le nitobe e Tàkate, ");
INSERT INTO tdx_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","nienga i Tàkate le nitobe e Tèrake. ");
INSERT INTO tdx_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","nienga i Tèrake le nitobe e Mitkà, ");
INSERT INTO tdx_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","nienga i Mitkà le nitobe e Khasmonà, ");
INSERT INTO tdx_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","nienga i Khasmonà le nitobe e Moserà, ");
INSERT INTO tdx_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","nienga i Moserà le nitobe e Benè’ià’akàne, ");
INSERT INTO tdx_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","nienga i Benè’ià’akàne le nitobe e Kore Hagid’gàde, ");
INSERT INTO tdx_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","nienga i Kore Ha­gidgàde le nitobe e Iotbàta, ");
INSERT INTO tdx_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","nienga i Iotbàta le nitobe e Ebranà ");
INSERT INTO tdx_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","nienga i Ebranà le nitobe e Etsiòne Gèbere, ");
INSERT INTO tdx_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","nienga i Etsiòne Gèbere vaho nitobe am-patrambei’ i Tsine, atao ty hoe Kadàse. ");
INSERT INTO tdx_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Ie nienga i Kadàse le nitobe e Vohi-Hore añ’olon-tane’ i Edome. ");
INSERT INTO tdx_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Niañambone’ i Vohi-Hore mb’eo t’i Aharone mpisoroñe ami’ty lili’ Iehovà vaho nihomake eo ami’ty taoñe fah’efa-polo’ niavota’ o ana’ Israeleo an-tane Mitsraime ami’ty andro valoha’ i volam-pahalimey. ");
INSERT INTO tdx_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Ni-zato-tsi-roapolo taoñe telo’ amby t’i Aharone te nivilasy ambone’ i Vohi-Hore eo. ");
INSERT INTO tdx_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Jinanji’ ty mpanjaka’ i Arade nte-Kanàne mpimoneñe atimo an-tane Kanàne ao te nomb’ ama’e mb’eo o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Aa le niavotse nitobe e Tsalmonà añe iereo. ");
INSERT INTO tdx_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Ie nienga i Tsalmonà le nitobe e Ponòne. ");
INSERT INTO tdx_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Ie nienga i Ponòne le nitobe e Obòte. ");
INSERT INTO tdx_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Ie nienga i Obòte le nitobe e Ièha Aba­rìme añ’efe-tane’ i Moabe. ");
INSERT INTO tdx_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Nenga’ iareo t’Iìme vaho nitobe e Dibone-Gade. ");
INSERT INTO tdx_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Ie nienga i Dibone-Gade le nitobe e Almone-Diblataième. ");
INSERT INTO tdx_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Ie nienga i Almone-Diblataième le nitobe amo vohi’ i Abarìmeo aolo’ i Nebò. ");
INSERT INTO tdx_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Ie nienga i am-bohi’ Abarìmeo le nitobe a montombei’ i Moabe añ’olo’ Iardeney tandrife Ierikò. ");
INSERT INTO tdx_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Nitobe marine Iardeney iereo, mifototse e Bete’ ha’ Iesimòte pak’añ’Ala-Roi’ i Abele a montombei’ i Moabe añe. ");
INSERT INTO tdx_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Aa le nitsara amy Mosè t’Iehovà a montombei’ i Moabe añ’ olo’ Iardeney tandrife’ Ierikò eo, nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Taroño amo ana’ Israeleo ty hoe: Ie mitsake Iardeney mb’an-tane Kanàne mb’eo, ");
INSERT INTO tdx_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","le fonga hanoe’ areo soike ze mpimoneñe amy tane aolo’ areoy, arotsaho o vato-sinoki’e iabio, ampiantò o sare tineno’ iareo iabio le demoho o tamboho’ iareo iabio; ");
INSERT INTO tdx_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ho tavane’ areo i taney vaho himoneñe ao, amy te natoloko anahareo i taney ho fanañañe. ");
INSERT INTO tdx_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Le ho zarae’ areo an-tsapake i taney ho lova’ o hasa­vereña’ areoo; ty maro ho tolora’ areo lova bey, le ty tsy ampe ho tolora’ areo lova kede; ze nitsatoha’ i tsapakey ty ho fanaña’ indatiy ho lova’e; ty amo fifokoañeo ty anjarañe aze. ");
INSERT INTO tdx_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Fa naho tsy hatao soike aolo’ areo mb’eo o mpimoneñe an-taneo le ho fatik’ am-pihaino’ areo, naho fitsipok’ an-deme’ areo o nisisa’ areo ama’eo, vaho hitsibore anahareo an-tane himoneña’ areo ao. ");
INSERT INTO tdx_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Le hanoeko ama’ areo i sinafiriko hanoeñe am’ iareoy. ");
INSERT INTO tdx_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Afantoho o ana’Israeleo ami’ty hoe: Ie mivotrak’ an-tane Kanàne ao (amy t’ie ty tane hitsa­toke ho anahareo ho lova: i tane Kanàney, pak’ amo efe-tane’eo), ");
INSERT INTO tdx_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","le mifototse am-patrambei’ i Tsiney añe ty efe’ areo atimo le hañorike ty efe’ i Edome; aa le hianiñànañe mb’ am-boli’ i Riake Matey mb’eo i efe’ areo atimoy; ");
INSERT INTO tdx_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","hiolake mb’atimo’ ty fionjona’ i Akrabime ty efe’ areo atimo, le homb’e Tsine mb’eo le hañorike ty atimo’ i Kadèse Barnèa le hionjom-b’an-Katsàradàre mb’eo; le hitohy mb’e Atsmòne mb’eo; ");
INSERT INTO tdx_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","hiolake e Atsmòne i efetsey le hiranga mb’añ’ oñe’ i Mitsraime añe vaho higadoñe amy Riakey. ");
INSERT INTO tdx_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Le i efetse ahandrefañey: ho efe’ areo ahandrefañe i olon-dRiake Ra’elahiy. ");
INSERT INTO tdx_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Le ty efe’ areo avaratse: mifototse amy Riake Ra’elahiy le tandrifeo ty Vohi-Hore ho efe’ areo; ");
INSERT INTO tdx_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","boak’ am-bohi-Hore tandrifeo pak’ e Lebò-Ka­màte; hitohy mb’e Tsedàde i efetsey; ");
INSERT INTO tdx_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","hionjomb’ e Zifròne i efetsey vaho higadoñe e Katsàre-Enàne. Izay ty efe’ areo avaratse. ");
INSERT INTO tdx_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Aa le sokiro ka ty efe’ areo atiñanañe, boake Katsàre-Enàne pake Sefàme; ");
INSERT INTO tdx_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","hitohy boake Sefame le pake Riblà atiñana’ i Aine añe i efetsey; le hizotso pak’ añ’ olotse atiñana’ ty Riake Kinerote ey i efetsey; ");
INSERT INTO tdx_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","horihe’ i efetsey ty olo’ Iardeney am-para’ i Riake Matey. Izay ty ho tane’ areo naho ty fiarikatoha’ i efe-tane’ey. ");
INSERT INTO tdx_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Aa linili’ i Mosè o ana’ Israeleo ami’ty hoe: Zao ty tane ho lovae’ areo an-tsapake, i nandilia’ Iehovà hatolotse amy fifokoa sive rey naho amy vakim-pifokoay. ");
INSERT INTO tdx_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","Fe sindre nandrambe ty lova’ iareo ty fifokoa’ i Reòbene ty aman’ an­jomban-droae’e naho ty fifokoa’ i Gade ty aman’ an­jomban-droae’e vaho nandrambe i lova’ey ka ty vakim-pifokoa’ i Menasè. ");
INSERT INTO tdx_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","Songa nandrambe ty lova’e i fifokoa roe rey naho i vakim-pifokoay mifototse an-dafe’ Iardene e Ieriko eo maniñanañe mb’ am-panjiriha’ i àndroy mb’eo. ");
INSERT INTO tdx_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Le hoe ty nitsarae’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Zao o tahina’ ondaty hizara i taney ama’ areo ho fanañañeo: i Elazare mpisoroñe naho Iehosoa ana’ i Nòne. ");
INSERT INTO tdx_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Le handrambesa’ areo mpiaolo kiraikiraike o fifokoañe hanjarañe i taneio ho lova. ");
INSERT INTO tdx_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Zao ty tahina’ ondatio: boak’ am-pifokoa’ Iehodà: i Kalèbe ana’ Iefonè; ");
INSERT INTO tdx_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","boak’ am-pifokoa’ o nte-Simoneo: i Semoàle ana’ i Amihòde; ");
INSERT INTO tdx_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","boak’ am-pifokoa’ i Beniamène: i Elidàde ana’ i Kislòne; ");
INSERT INTO tdx_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ty mpiaolo boak’ am-pifokoa’ i Dane: i Boký ana’ Ioglý; ");
INSERT INTO tdx_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","boak’ amo ana’ Iosefeo: ty mpiaolo boak’ amy fifokoa’ o nte-Menasèoy: i Kanièle ana’ i Efode; ");
INSERT INTO tdx_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","le ty mpiaolo boak’ am-pifokoa’ o nte-Efraimeo: i Kemoele ana’ i Seftàne; ");
INSERT INTO tdx_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ty mpiaolo boak’ am-pifokoa’ o nte-Zeboloneo: i Elitsafàne, ana’ i Parnàke; ");
INSERT INTO tdx_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ty mpiaolo boak’ am-pifokoa’ o nte-Isakhareo: i Paltiele ana’ i Atsane; ");
INSERT INTO tdx_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ty mpiaolo boak’ am-pifokoa’ o nte-Asereo: i Akihòde ana’ i Selomý; ");
INSERT INTO tdx_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ty mpiaolo boak’ am-pifokoa’ o nte-Naftalio, i Pedahele ana’ i Amihode; ");
INSERT INTO tdx_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ie ondaty nandilia’ Iehovà hizara ty tane’ o ana’ Israeleo an-tane Kanàne ao. ");
INSERT INTO tdx_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Le nitsara amy Mosè t’Iehovà a montombei’ i Moabe añ’ olo’ Iardeney tandrife Ierikò eo, ami’ty hoe: ");
INSERT INTO tdx_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Lilio o ana’ Israeleo ty hanolotse rova amo nte-Levio himoneña’e boak’ amo lova fanaña’ iareoo, vaho toloro tane mañohoke o rova’ iareoo ho fiandraza’ o nte-Levio. ");
INSERT INTO tdx_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Ho fimoneña’ iareo o rovao naho ho fiandrazañe o añombe’eo naho o mpirai-lia’eo vaho o hare’ iareo iabio i tane mañohokey. ");
INSERT INTO tdx_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Hifototse an-kijoli’ o rova’e eo vaho hitakatse arivo kiho añ’ areare i rovay o tane fiandraza’eo. ");
INSERT INTO tdx_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Le ho zehè’ areo alafe’ o rovao ty ro’arivo kiho ami’ty ila’e atiñanañe, le ro’arivo kiho ami’ty ila’e atimo, le ro’arivo kiho ami’ty lafe’e ahandrefañe, le ro’arivo kiho an-dafe’e avaratse. Añivo’e ao i rovay. Izay ty ho fanaña’ iareo ho fiandraza’ i rovay. ");
INSERT INTO tdx_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Le ho rovam-pitsolohañe o rova eneñe hatolo’ areo amo nte-Levioo, ie henga’ areo ho fitribahan-dai’ ze mamono ondaty, mandikoatse izay le ho tolora’ areo rova efapolo-ro’amby iereo. ");
INSERT INTO tdx_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Aa le mitraoke ho rova efapolo-valo’ amby ty hatolo’ areo amo nte-Levio rekets’ o tane fiandraza’eo. ");
INSERT INTO tdx_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Le boak’ ami’ty fanaña’ o ana’ Israeleo ty hano­lora’o i rova rey, hanolotse maro ty fifokoañe bey, naho tsy ampeampe ka ty boak’ ami’ty kede. Songa hanolotse rova amo nte-Levio boak’ amo rova’eo ty amy habei’ i lova ho rambese’ey. ");
INSERT INTO tdx_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Le hoe ty nitsara’ Iehovà amy Mosè: ");
INSERT INTO tdx_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Misaontsia amo ana’Israeleo, le ano ty hoe: ie mitsake Iardeney mb’an-tane Kanàne mb’eo, ");
INSERT INTO tdx_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","le mijoboña rova ho rovam-pitsolohañe, hivoratsa­ha’ ty namono ondaty tsy an-tsatri’e. ");
INSERT INTO tdx_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Rova ho fitsolohañe, hipalira’ areo ami’ty mpamale fate, soa tsy hohofan-doza ty namono ondaty ampara’ t’ie miatre-jaka añatrefa’ i valobohòkey. ");
INSERT INTO tdx_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Aa le amo rova atolo’ areoo ty hanolora’ areo rovam-pitsolohañe eneñe. ");
INSERT INTO tdx_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Ho tolora’ areo rova telo ty alafe’ Iardeney atoy naho ho tolora’ areo rova telo ty an-tane Kanàne ao ho rovam-pitsolohañe. ");
INSERT INTO tdx_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Ho rovam-pitsoloha’ o ana’ Israeleo i rova eneñe rey, naho ho a o ambahinio naho o renetane añivo’ iereoo, soa t’ie ty hivongarita’ ze mamono ondaty tsy an-tsatri’e. ");
INSERT INTO tdx_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Aa naho lafae’e ami’ty viñe t’indaty vaho mivetrake indatiy, le mpamono ondaty re, toe ho vonoeñe ty mpamono. ");
INSERT INTO tdx_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Aa naho fofohe’e ami’ty vato am-pità’eo, ze mahavetrak’ ondaty vaho mihomake indatiy le mpamono re; toe havetrake i mpamonoy. ");
INSERT INTO tdx_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Aa ie vinango’e an-kataem-pialiañe am-pità’e ao, ze maha­vetrak’ ondaty, naho mate indatiy, le mpamono re, vaho toe ho vonoeñe i mpamonoy. ");
INSERT INTO tdx_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Toe i mpamale fatey ty hañoho-doza amy mpamonoy; ie mifanojo ama’e le ho vonoe’e. ");
INSERT INTO tdx_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Aa ie maniotse aze mafe ami’ ty falai’e aze, ke mivoñoñe aze, he andretsaha’e raha, vaho mate, ");
INSERT INTO tdx_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","he ami’ty fandrafea’e ro mampitrabotrabok’ am-pità’e hampi­vetrak’ aze, le toe ho vonoeñe i nampitrabotrabokey. Mpamono re, ho vonoe’ ty mpamale fate te ifanojoa’e. ");
INSERT INTO tdx_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","F’ie mandronje am-pifanojeha’e fa tsy am-palaiñañe, ke mametsa-draha ama’e fa tsy am-pivoñonañe, ");
INSERT INTO tdx_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","hera am-bato mete mahafate ondaty, ie ahiriri’e mb’eo fe tsy nioni’e indatiy, le mate indatiy, ie tsy nirafelahi’e vaho tsy nikilily te hañe-doza ama’e, ");
INSERT INTO tdx_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","le ho zakae’ i valobohòkey añivo’ i namonoy naho i mpamale fatey amy fañè rezay. ");
INSERT INTO tdx_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Aa le havotso’ i valobohòkey boak’ am-pità’ i mpamale fatey i namono ondatiy, le hampolie’ i valobohòkey mb’ amy rova fitsolohañe nivoratsaha’ey, ao ty hipalira’e am-para’ te vilasy ty mpisorom-bei’ norizañe amy menake miavakey. ");
INSERT INTO tdx_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Aa naho eo ty andro añaveloa’ i namonoy alafe’ ty efe’ i rovam-pitsolohañe nivotitsiha’ey, ");
INSERT INTO tdx_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","le mahaisak’ aze alafe’ ty efe’ i rovam-pitsolohañey i mpamale fatey, vaho vonoe’ i mpamale fatey, le tsy hanan-tahiñe amy lio’ey re, ");
INSERT INTO tdx_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","amy t’ie tsy mete tsy midok’ am-po’ i rovam-pitsolohañey am-para’ te mihomake ty mpisorom-bey, le ie vilasy i mpisorom-beiy vaho mete mimpoly an-tanem-panaña’e añe i namonoy. ");
INSERT INTO tdx_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Ho fañè naho fepètse ho anahareo izay amo hene tarira’ areo mifandimbeo ndra aia’aia ty imoneña’ areo. ");
INSERT INTO tdx_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Ze mamono ondaty, le ho vonoeñe i mpamonoy ami’ty taro’ o nahaisakeo; fa tsy azo amonoañe ondaty ami’ty taro’ ondaty raike; ");
INSERT INTO tdx_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","vaho tsy azo jebañeñe ty fiai’ ondaty namono, ie fa voa zaka ami’ ty vono-ondaty; toe tsy mahai-tsy vonoeñe ty mpamono ondaty. ");
INSERT INTO tdx_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Le tsy azo vilieñ’ ay t’indaty nivoratsake mb’an-drovam-pitsolohañe mb’eo, hampipoliañe aze mb’an-tane’e añe aolo’ ty havilasi’ i Mpisorom-beiy. ");
INSERT INTO tdx_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Ko mandeotse ty tanen’ akiba’ areo; fa mandeotse tane ty lio, vaho tsy mete mijeba i taney ami’ty lio nadoañe ama’e naho tsy ami’ ty lio’ i nampidoañe azey. ");
INSERT INTO tdx_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Aa le ko maniva ty tane’ imoneña’ areo, fa fimoneñako, amy te mitoboke añivo’ o ana’ Israeleo ao, izaho Iehovà. ");
INSERT INTO tdx_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Niharine mb’eo o mpiaolon’ an­jomban-droaem-pifokoan-tarira’ i Gilade ana’ i Makire, ana’ i Menasè, hasavereña’ o ana’ Iosefeoo vaho nilañoñe añatrefa’ i Mosè naho o talèo naho o talèn’ anjomban-droae’ o ana’ Israeleoo, ");
INSERT INTO tdx_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","nanao ty hoe: Linili’ Iehovà i talèkoy ty hanolotse i tane lovaeñey an-tsapake; vaho linili’ Iehovà i talèkoy ty hanolotse i lovan-drahalahi’ay Tselofekhàdey amo anak’ ampela’eo. ");
INSERT INTO tdx_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Aa naho ivalia’ ty anam-pifokoa ila’e amo ana’ Israeleo, le ho rambeseñe ami’ty lovan-droae’ay ty lova’ iareo vaho ho tovoñañe ami’ty lova’ i fifokoañe nivalie’ey; aa le ho liniva amy lova niazo’ay an-tsapakey. ");
INSERT INTO tdx_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Le ie avy i Jobili’ o ana’ Israeleio, ho tovoñañe ami’ ty lova’ i fifokoañe nañeng’ azey i lova’ey; le ho livaeñe ami’ ty lovam-pifokoan-droae’ay i lova’ey. ");
INSERT INTO tdx_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Le hoe ty linili’ i Mosè amo ana’ Israeleo ty amy tsara’ Iehovày, To ty saontsi’ o tariram-pifokoa’ Iosefeo. ");
INSERT INTO tdx_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Aa hoe ty linili’ Iehovà omba o anak’ ampela’ i Tselofekhàdeo: angao hifanam­baly amy ze tea’e fe tsy mete tsy amo tariram-pifo­koan-droae’eo avao ty anambalia’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Aa le tsy hafindra am-pifokoañe raike ho ami’ty fifokoañe ila’e o lovao; fa songa hitañe ty lovam-pifokoan-droae’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Le hanambaly ami’ty fifokoan-droae’e ze anak’ ampela mitan-dova ami’ty fifokoañe raik’ amo ana’ Israeleo, soa te songa hitan-dovan-droae’e o ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Aa le tsy hafindra ho ami’ty fifokoañe ila’e ty lova fa sambe mitan-ty lova’e o fifokoan’ ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","Nanoe’ o anak’ampela’ i Tse­lofekadeo ty nandilia’ Iehovà i Mosè. ");
INSERT INTO tdx_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","Le nifanambaly ami’ty anan-drahalahin-drae’e t’i Maklà, i Tirtsà, naho i Koglà vaho i Noà ana’ i Tselofekade. ");
INSERT INTO tdx_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Nifanambaly amo tarira’ o nte-Menasè ana’ Iosefeo iereo vaho mireketse am-pifokoan-droae’e ao ty lova’ iareo. ");
INSERT INTO tdx_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Irezay ro lily naho fepetse linili’ Iehovà amo ana’ Israeleo am-pità’ i Mosè a montom-bei’ i Moabe añ’ olo’ Iordaney tandrife Ierikò eo. ");
INSERT INTO tdx_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Iretoañe o tsara nilañona’ i Mosè am’ Israele iaby alafe’ Iardeney, am-patrambey ao, an-tane mira tandrife i Sofe añivo’ i Parane naho i Tòfele naho i Labane naho i Katseròte vaho i Dizahabe. ");
INSERT INTO tdx_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","(Mahamodo andro folo-raik’ amby ty lia mb’e Kadàse-Barnèa mb’eo t’ie miary mb’e Vohi-Seire añe.) ");
INSERT INTO tdx_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Aa ie tamy taom-paha efa-poloy, ami’ty vola’e faha-folo-raik’amby, ami’ty andro valoha’ i volañey le ninday lañonañe amo ana’ Israeleo t’i Mosè, amy nampisaontsie’ Iehovày aze; ");
INSERT INTO tdx_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","naho fa zinevo’e t’i Sihone mpanjaka’ o nte-Amore nimoneñe e Khesboneo, naho i Oge mpanjaka’ i Basane nimoneñe e Astaròte e Ederèy ao; ");
INSERT INTO tdx_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","alafe’ Iardeney atoy, an-tane’ i Moabe, ty nimanea’ i Mosè halangesañe i Hake ami’ty hoe: ");
INSERT INTO tdx_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Nitsara aman-tika e Korebe añe t’Iehovà Andrianañaharentika nanao ty hoe: Ihe loho tambatse ami’ty vohitse toy: ");
INSERT INTO tdx_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","mitoliha naho tonjohizo ty lia’ areo, le mionjona mb’am-bohi’ o nte Amoreo mb’eo; naho mb’an-tane mañohoke aze iaby mb’ an-tane-mira ey naho mb’amo vohibohitseo naho mb’am-bavatane ao naho mb’ atimo añe naho mb’ añolon-driake mb’eo pak’ an-tane’ i nte-Kanàney naho pake Lebanone añe vaho migadoña amy oñe ra’elahiy, i oñe Peràtey. ");
INSERT INTO tdx_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ingo, fa nalahako añatrefa’ areo o taneo; akia rambeso ho anahareo i tane nifañinà’ Iehovà aman-droae’ areoy: amy Avrahame naho am’ Ietsake vaho am’ Iakobe, t’ie hatolots’ am’ iareo naho o tarira’ iareo hanonjohio. ");
INSERT INTO tdx_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Ie amy zay nanao ty hoe ama’ areo iraho, Tsy lefeko ty mivave anahareo, izaho avao, ");
INSERT INTO tdx_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","fa nampanaranàhe’ Iehovà Andrianañahare’ areo ho mira ami’ty ia’ o vasian-dikerañeo androany. ");
INSERT INTO tdx_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Le ee te hampitomboe’ Iehovà Andrianañaharen-droae’ areo añ’ arivo ty ia’ areo vaho hitahy anahareo amy nampitamae’ey. ");
INSERT INTO tdx_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Fa aia ty hahavaveako, t’ie raike, ty fañangara’ areo naho ty fampioremeña’ areo vaho ty fampihohokohofa’ areo ahiko. ");
INSERT INTO tdx_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Tendreo o mahilala’ areoo, o mahihi­tseo naho o maharofoanañe amo rofoko’ areoo le hanoeko mpifehe’ areo. ");
INSERT INTO tdx_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Le natoi’ areo ty hoe, Mete i nisaon­tsia’o hanoeñey. ");
INSERT INTO tdx_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Aa le rinambeko o mpiaolo’ o fifokoa’ areoo, o mahihitse naho mahilalao naho najadoko ho talè’ areo ho mpifelek’ arivo, naho mpifeleke zato, naho mpifeleke limampolo, naho mpifeleke folo, vaho ho mpitoronjo, ki-foko, ki-foko. ");
INSERT INTO tdx_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Le nafantoko amo mpizaka’ areoo amy andro zay, ty hoe: Mijanjiña añivo’ o rolongo’ areoo vaho mizakà an-katò añivo’ ze ondaty naho ty rahalahi’e ndra ze renetane ama’e. ");
INSERT INTO tdx_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Ko mirihy an-jaka; fe janjiño ty kede naho ty bey; ko hembañe ami’ty lahara’ ondaty, fa an’Andrianañahare ty zaka, le ze tsy lefe’ areo ro hasese amako ho tsanoñeko. ");
INSERT INTO tdx_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Aa le nililieko henane zay ze hene raha hanoe’ areo. ");
INSERT INTO tdx_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Aa ie nienga i Korebe tika, le niranga i fatrañe jabajaba mahareven­dreveñe nioni’ areo am-piariañe ty vohi’ o nte-Amoreoy, amy nandilia’ Iehovà Andrianañaharentikañey; le nivotrake e Kadese-Barneà eo, ");
INSERT INTO tdx_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","vaho hoe ty nanoeko: ie fa nandoak’ am-bohi’ o nte-Amoreo, i hatolo’ Iehovà Andrianañaharen-tika aman-tikañey. ");
INSERT INTO tdx_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","Ingo fa napo’ Iehovà Andrianañahare’o añatrefa’o eo o taneo: aa le mionjona mb’eo naho rambeso ami’ty nitsara’ Iehovà Andrianañaharen-droae’o, ko hembañe vaho ko mitsolofìñe. ");
INSERT INTO tdx_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Aa le songa niharine amako nanao ty hoe: hamantoke ondaty hiaolo antika mb’eo zahay hitsikarake i taney vaho hinday saontsy amantika ami’ty lalañe hionjonan-tika mb’eo naho o rova higaoñan-tikañeo. ");
INSERT INTO tdx_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Toe ninòko i saontsy zay, vaho rinambeko t’indaty folo-ro’ amby, songa raike ami’ty fifokoañe; ");
INSERT INTO tdx_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","le nitolike iereo nionjoñe mb’am-bohibohitse mb’eo naho nandoak’ am-bavatane Eskole vaho nitsoetsoek’ ao. ");
INSERT INTO tdx_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Nandrambesa’ iareo am-pitàñe ty voka’ i taney le nendese’ iareo nizotso mb’ aman-tikañe atoy, vaho ninday saontsy aman-tika nanao ty hoe: Soa i tane natolo’ Iehovà Andrianañaharen-tika aman-tikañey. ");
INSERT INTO tdx_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","F’ie amy zay, tsy ni-mete nionjom-beo nahareo te mone niola ami’ty nandilia’ Iehovà Andrianañahare’ areo, ");
INSERT INTO tdx_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","vaho niñeoñeoñe an-kiboho’ areo ao ami’ty hoe: ty falai’ Iehovà antika ty nañakara’e antika an-tane Mitsraime hanesea’e am-pità’ o nte-Amoreo harotsake. ");
INSERT INTO tdx_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Aia ty hionjonan-tika? Nahamohake ty arofo’ay ty enta’ o longontikañeo nanao ty hoe, Ra’elahy naho abo te amantika ondatio naho jabajaba o rova’ iareo reketse kijoly mitiotiotse mb’andikerañ’ eio vaho niisa’ay ao o ana’ i Anàkeo. ");
INSERT INTO tdx_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Aa le nanoeko ty hoe, Ko irevendreveñañe, ko ihembañañe. ");
INSERT INTO tdx_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Iehovà Andrianañahare Mpiaolo ro hialy ho anahareo hambañe amy nanoe’e e Mitsraime añe aolom-pihaino’ areoy; ");
INSERT INTO tdx_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","naho tam-patrambey añe; fa niisa’ areo ty fiotroña’ Iehovà Andrianañahare’ areo, manahake ty fiotroña’ ondaty i ana-dahi’ey, amo lia’ areo iabio ampara’ te nivotrak’ an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","F’ie amy zay, tsy natokisa’ areo t’Iehovà Andrianañahare’ areo, ");
INSERT INTO tdx_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","i Mpiaolo am-pañaveloañey nipay ze hañoreña’ areo o kibohotseo, ie añ’afo ao te haleñe hanoroa’e ty lalan-kombà’ areo vaho an-drahoñe ao te handro. ");
INSERT INTO tdx_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Ie jinanji’ Iehovà i feon’ enta’ areo zay, le niviñetse vaho nifanta ty hoe: ");
INSERT INTO tdx_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","Leo raik’ amo retoañe—o tariratse raty reo—tsy hahaisake i tane soa nifañinàko hatolotse aman-droae’ areoy, ");
INSERT INTO tdx_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","naho tsy i Kalèbe ana’ Iefonè. Ie ty hahaisake, le hatoloko aze naho amo tarira’eo i tane niliàm-pandia’ey ami’ty fañoriha’e fatratse Iehovà. ");
INSERT INTO tdx_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Izaho ka niviñera’ Iehovà ty ama’ areo amy tsara’ey, ty hoe: Tsy himoak’ ao ka irehe. ");
INSERT INTO tdx_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","I Iehosoa ana’ i None, mpitoro’oy, ty himoak’ ao; osiho amy t’ie ty hampandova Israele aze. ");
INSERT INTO tdx_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Le o keleia’ areoo, o natao’ areo ho nikopaheñeo, o ana’ areoo; i mboe tsy nahilala ty soa naho ty raty henane zay rey ty himoak’ ao; le hatoloko iareo vaho ho rambese’ iareo ho fanañañe. ");
INSERT INTO tdx_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","F’ina­hareo ka, mito­liha naho mionjona mb’am-patrambey miary amy ­Ria-Binday mb’eo. ");
INSERT INTO tdx_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Nanoiñ’ ahy ami’ty hoe nahareo, Toe anaña’ Iehovà hakeo! Veka’e hionjoñe hialy zahay ami’ty nandilia’ Iehovà Andrianañaharen-tika. Aa le songa nidiam-pialiañe ondatio fa natao’e ho mora ty hionjoñe mb’am-bohibohitse mb’eo. ");
INSERT INTO tdx_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Le hoe t’Iehovà amako, Isaon­tsio ty hoe: Ko mionjom’ beo vaho ko mialy, amy te tsy añivo’ areo ao iraho tsy mone ho rotsak’ aolo’ o rafelahi’ areoo. ");
INSERT INTO tdx_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Fe ndra te nivolañeko, tsy nihaoñe’ areo. Niola amy nandilia’ Iehovày, an-tsatrin-troke ty nionjona’ areo mb’ am-bohibohitse mb’eo. ");
INSERT INTO tdx_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Niavotse, niatrek’ anahareo amy zao o nte-Amore mpimoneñe am-bohitseo vaho niho­ridañe’e hoe rene tantele. Rinotsa’ iareo am-pibara e Seire pake Kormà añe. ");
INSERT INTO tdx_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Aa le nibalike naho nirovetse añatrefa’ Iehovà, fe tsy hinao’ Iehovà ty fiarañanaña’ areo, tsy nanokilaña’e ravembia. ");
INSERT INTO tdx_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Aa le nitobe e Kadese ao ela ty amo andro nitoboha’ areoo. ");
INSERT INTO tdx_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Niotak’ amy zao tika nionjomb’ am-patrambey mb’eo, niary i Ria-Binday, mb’ami’ty nanoroa’ Iehovà ahiko vaho nañariary i Vohi-Seirey andro maro. ");
INSERT INTO tdx_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Le hoe ty nitsarae’ Iehovà amako: ");
INSERT INTO tdx_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Fa losotse ty fiariaria’ areo ty vohitse toy. Mitoliha mañavaratse, ");
INSERT INTO tdx_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","le afantoho ty hoe ondatio: Ho rangae’ areo ty tanen-drolongo’ areo, o tarira’ i Esave mpimo­neñe e Seireo, f’ie ho hembañe ama’areo, aa le mitaoa ");
INSERT INTO tdx_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","tsy mone hihotakotak’ am’ iereo fa tsy hitalorako ndra zehem-pandia raik’ amy tane’iareoy amy te nimeako i Esave ho fanaña’e ty Vohi’ Seire. ");
INSERT INTO tdx_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Ho vilie’ areo an-drala o mahakama’eo hikamà’ areo, vaho hikaloa’ areo rano an-drala hinoma’ areo. ");
INSERT INTO tdx_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Toe nitahie’ Iehovà Andrianañahare’ areo amy ze hene satam-pità’ areo naho arofoana’e ty firanga’ areo am-patram-bey atoy. Tsy eo ty nipaia’ areo amy efa-polo taoñe nindreza’ Iehovà Andrianañahare’ areo rezay. ");
INSERT INTO tdx_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Aa le niarian-tika o tarira’ i Esave longon-tika mimoneñe e Seire ao, le nengan-tika ty lala’ i Arabà naho navotson-tika t’i Elate naho i Etsione-Gebere le nitsile vaho niary mb’amy lala’ i fatrambei’ i Moabeiy mb’eo. ");
INSERT INTO tdx_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Le nanao ty hoe amako t’Iehovà: Ko tsiborè’o t’i Moabe ndra hialy ama’e, fa tsy ho meiko ndra kede amo tane’eo ho fanañañe, amy te natoloko amo tarira’ i Loteo ty Are ho fanaña’e. ");
INSERT INTO tdx_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","(Nimoneña’ o nte-Emeo izay te taolo: ondaty mijoalajoala naho mitozantozañe, mira haabo amo nte-Anàkeo; ");
INSERT INTO tdx_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Betek’ atao ty hoe nte-Refae iereo manahake o nte-Anakeo, f’ie atao’ o nte-Moabeo ty hoe nte-Emà. ");
INSERT INTO tdx_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Le nimoneñe e Seire ao o nte-Koreo taolo, fa niroahe’ o ana’ i Esaveo, rinotsa’e miaolo iareo vaho nitoboke an-tane’ iareo ao, manahake ty anoe’ Israele amy tane natolotse aze ho fanaña’ey; i natolo’ Iehovà iareoy). ");
INSERT INTO tdx_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Miongaha arè, le itsaho o toraha’ i Tseredeo. Aa le nitsahan-tika i torahan-Tserèdey. ");
INSERT INTO tdx_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Le o andro nañaveloan-tika boake Kadese-Barneà am-para’ t’ie nitsake i torahan-Tseredeio, le taoñe telo-polo-valo’ amby, ampara’ te fonga nivetrak’ añivo’ i tobey o lahindefoñe mpiharo-nonoo, amy nifantà’ Iehovà am’ iereoy. ");
INSERT INTO tdx_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Toe nañonjona’ Iehovà haoke hañombota’e amy màroy am-para’ t’ie fonga nimongotse. ");
INSERT INTO tdx_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Naho hene nikoromake añivo’ on­datio i lahindefoñe rezay, ");
INSERT INTO tdx_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","le nitsara ty hoe amako t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Hitsake i Are, efe-tane’ i Moabe irehe te anito. ");
INSERT INTO tdx_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Ie miharine ty efe-tane’ o nte-Amoneo, le ko tsibore’o vaho ko ialiañe, fa tsy hañomeako ty tane’ iareo ho fanaña’o, amy te natoloko an-tarira’ i Lote ho fanaña’e. ");
INSERT INTO tdx_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","(Toe natao t’ie tane’ o nte-Refaeo ka; fa nimoneñe ao o nte-Refaeo taolo, ie nitokave’ o nte-Amoneo ty hoe Zam’zome, ");
INSERT INTO tdx_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","ondaty maozatse naho vasiañeñe mira amo nte-Anakeo. F’ie narotsa’ Iehovà aolo’ iareo eo handimbeza’ iareo fimoneñañe; ");
INSERT INTO tdx_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","manahake ty nanoe’e amo tarira’ i Esave mimo­neñe e Seireo ami’ty nandrotsaha’e o nte-Koreo aolo’ iareo, nandimbe iareo am-pimoneña’e pake henaneo; ");
INSERT INTO tdx_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","naho o nte-Aveo, ie nimoneñe e Katsere pak’ Aza añe, le rinotsa’ o nte-Kaftore boake Kaftoreo, vaho nandimbe fiambesatse.) ");
INSERT INTO tdx_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Miongaha, tonjohizo ty lia’ areo, itsaho o vavatane’ i Arnoneo. Ingo fa natoloko am-pità’ areo t’i Sihone nte-Amore mpanjaka’ i Khesbone naho ty tane’e. Miorota mitavañe, naho tameo añ’aly. ");
INSERT INTO tdx_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Hampihembañeko naho hampirevendreveñeko ama’o henane zao ze hene ondaty ambanen-dikerañeo; ie mijanjiñe azo le hititititike ami’ty anifañe. ");
INSERT INTO tdx_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Aa le nampisangitrifeko ìrake boak’ am-patrambein-Kedemote ao ho mb’e Sihone Mpanjaka’ i Khesbone añe, le hoe ty entam-panintsiñako ama’e: ");
INSERT INTO tdx_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Angao iraho hiranga ty tane’o, fa i lalañey avao ty horiheko, tsy hitsile ndra mañavana ndra mañavia. ");
INSERT INTO tdx_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Haleta’o drala amako ty mahakama hihinanako, vaho ie fahana’ areo rano hinomako, le ho soloako bogady, fe apoho ho rangaeko an-tomboke ty tane’o— ");
INSERT INTO tdx_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","hambañe ami’ty nanoe’ o tarira’ i Esave mimoneñe e Seireo amako naho ty nanoe’ o nte-Moabe mpimoneñe e Areo ka—ampara’ te itsahako Iardeney mb’an-tane nitolora’ Iehovà Andrianañahare’ay mb’eo. ");
INSERT INTO tdx_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Fe tsy nimete hampiranga an-tika t’i Sihone Mpanjaka nte-Khesbone fa nampigan-troke aze t’Iehovà Andrianañahare’ areo vaho nampitokie’e ty arofo’e hanolora’e aze am-pità’ areo, le ie henaneo. ");
INSERT INTO tdx_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Aa hoe t’Iehovà amako: Ingo, fa namototse hanolotse i Sihone naho i tane’ey ama’ areo iraho, aa le miorota henane zao hangalake i tane’ey ho lova’ areo. ");
INSERT INTO tdx_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Aa le niavotse haname an-tika t’i Sihone, ie naho ondati’e iabio, hihotakotake ty aly e Iàhatse añe, ");
INSERT INTO tdx_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","le natolo’ Iehovà Andrianañaharentika aolon-tika vaho linafa-tika naho o tiri’eo naho ondati’e iabio. ");
INSERT INTO tdx_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Le hene tinavan-tika o rova’eo henane zay, le fonga zinaman-tika ze ondaty ndra rakemba ndra ajaja amo rovao. Tsy napon-tika ndra honka’e. ");
INSERT INTO tdx_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","O hareo avao ty rinamben-tika ho fikopahañe rekets’ o raha kinopak’ amo rova tinavan-tikañeoo. ");
INSERT INTO tdx_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Boak’ Arore aolo’ i vavatane Arnoney (rekets’ i rova am-bavataney) pake Gilàde le tsy teo ty rova loho abo tsy nilefe, fonga natolo’ Iehovà Andrianañaharentika amantika. ");
INSERT INTO tdx_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Fe tsy niharinea’ areo o tanen’ ana’ i Amoneo, ndra aia aia amy saka’ Iabokey ndra amo rova ambohibohitseio, ndra aia aia nandrarà’ Iehovà Andrianañaharentika antika. ");
INSERT INTO tdx_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Aa le nitolike tika nionjoñe amy lala­ñey mb’e Basane mb’eo vaho nia­votse hiatrek’ antika t’i Oge mpanjaka’ i Basane, ie naho ondati’e iabio, hialy Edrey. ");
INSERT INTO tdx_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Hoe t’Iehovà amako, Ko ihem­baña’o fa natoloko am-pità’o naho on­dati’e iabio vaho o tane’eo. Ano ama’e hambañe amy nanoe’o i Sihone, mpanjaka’ i Amore nimoneñe e Khesboney. ");
INSERT INTO tdx_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Aa le natolo’ Iehovà Andrianañaharentika am-pitàn-tika ka t’i Oge mpanjaka’ i Basane naho ondati’e iabio, le rinotsan-tika vaho tsy nengan-tsehanga’e. ");
INSERT INTO tdx_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Ie amy zay, tinavan-tika o rova’e iabio; le tsy teo ty rova’e tsy tinavan-tika—rova enempolo, ze hene tane’ i Argobe, ty fifehea’ i Oge e Basane ao. ");
INSERT INTO tdx_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Songa narovañe an-kijoly abo o rovao, lalambey naho sikadañe, tovo’ irezay o tanàñe tsi-fotofoto tsy aman-kijolio. ");
INSERT INTO tdx_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Fonga binaibain-tika hambañe ami’ty nanoan-tika i Sihone mpanjaka’ i Khesbone, songa zinaman-tika ze lahilahy naho rakemba vaho keleiañe amy ze rova iaby. ");
INSERT INTO tdx_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Fe hene rinamben-tika ze añombe naho vara amo rovao ho tsindroke. ");
INSERT INTO tdx_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Le tinavan-tika boak’am-pitàm-panjaka nte-Amore roe amy andro zay ty tane alafe’ Iardeney atoy mifototse amy saka Arnoney pak’ am-bohi-Kermone añe; ");
INSERT INTO tdx_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","(Atao’ o nte-Tsidoneo ty hoe Sirione ty Kermone, le atao’ o nte-Amoreo ty hoe Senire;) ");
INSERT INTO tdx_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","le ze rova an-tanemira ey, naho i Gilàde iaby le i Basane iaby, pake Salkà añe vaho i Edrey, o rova am-pifehea’ i Oge nte-Basaneo. ");
INSERT INTO tdx_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","I Oge mpanjaka’ i Basane ty ni-sengaha’ o fanalolahio; inao te fandream-by ty fandrea’e, mbe e Rabate ao izay amo ana’ i Amoneo. Sive kiho ty an-dava’e naho efatse kiho ty ampohe’e an-kiho tsotra. ");
INSERT INTO tdx_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Le natoloko amo nte-Reobeneo naho amo nte-Gadeo i tane rinamben-tika amy andro zaiy, boak’ Aroere añ’ olo’ i saka Arnoney naho ty tampa’ i Vohi-Gilàdey, naho o rova’eo. ");
INSERT INTO tdx_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Le natoloko amy vakim-pifokoa’ i Menasèy ty sisa’ i Gilade naho i Basane iaby, toe ty fifehea’ i Oge, le nitokaveñe ty hoe tanem-panalolahy ze hene tane’ i Argobe mitraoke amy Basane iaby. ");
INSERT INTO tdx_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Iaire ana’ i Menasè ty nandrambe ty tane’i Argobe pak’añ’olo’ i Gesory naho i Maàkaty añe vaho nito­kave’e amy tahina’ey ty hoe: Basane-kavote-Iaire pake henane. ");
INSERT INTO tdx_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Le natoloko amy Makire ty Gilade. ");
INSERT INTO tdx_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Le natoloko amo nte-Reobeneo naho amo nte-Gadeo ty tane boake Gilade pak’ an-tsaka’ Arnone, ty aivo’ i vavataney ro efe’e, pak’ an-tsaka’ Iabòke eo, ty efe-tane’ o ana’ i Amoneo; ");
INSERT INTO tdx_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","naho i tane Mìray, Iardeney ty efe’e, le boak’e Kinerete pak’ an-dria’ i antanemira, i ria-tsiray, am-potom-piroroña’ i Asdote-Pisgà maniñanañe. ");
INSERT INTO tdx_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Le hoe ty nandiliako anahareo henane zay: Fa natolo’ Iehovà Andrianañahare’ areo ho fanaña’ areo o tane atoio le hitsake reke-pialiañe aolo’ o rahalahi’ areo ana’ Israeleo ze mahatan-defo ama’ areo iaby. ");
INSERT INTO tdx_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Fe hidoñe amo rova natoloko anahareoo o vali’ areoo, o keleia’ areoo, naho o añombe’ areoo (apotako te maro ty añombe’ areo); ");
INSERT INTO tdx_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","aa naho nampitofà’ Iehovà manahak’ anahareo o rahalahi’ areoo, naho fa nitobea’ iareo ka ty tane natolo’ Iehovà Andrianañahare’ areo alafe’ Iardeney añe, izay vaho himpoly nahareo—ze fonga ondaty—mb’ an-tane’e mb’eo, i natoloko anahareoy. ");
INSERT INTO tdx_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Le nafantoko am’ Iehosoa amy andro zay ty hoe, Toe hene nioni-pihaino’o ty nanoe’ Iehovà Andrianañahare’o i mpanjaka roe rey, le izay ka ty hanoe’ Iehovà ze fifeheañe irangà’ areo. ");
INSERT INTO tdx_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Ko ihembaña’ areo fa Iehovà Andrianañahare’ areo ty mialy ho anahareo. ");
INSERT INTO tdx_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Ie amy zay, nihalaly am’ Iehovà iraho ami’ty hoe: ");
INSERT INTO tdx_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","O Talè Iehovà, ie vaho niorotse nampiboake ty hajabahina’o naho ty haozara’o ami’ty mpitoro’o, le ia ty ndrahare an-dikerañe ao ndra an-tane atoy ty mahafitoloñe hambañe amo anoe’oo naho o sata’o ra’elahio? ");
INSERT INTO tdx_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","Ehe te henga’o hitsake mb’eo iraho hahatreavako i tane fanjaka alafe’ Iardene añey, o vohibohitse soao naho i Lebanone. ");
INSERT INTO tdx_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","F’ie niviñera’ Iehovà ty ama’ areo le tsy ni­haoñe’e. Hoe t’Iehovà amako, Fa eneñe i azoy! ko isaontsia’o ka. ");
INSERT INTO tdx_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Miañam­bonea mb’ an-dengo’ i Pisgà mb’eo le miandrà makandrefa naho mañavaratse naho mañatimo naho maniñanañe eñe. Italakeso am-pihaino, f’ie tsy hitsake Iardeney. ");
INSERT INTO tdx_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Afantoho t’Iehosoa naho osiho vaho haozaro, amy t’ie ro hitsake hiaolo ondaty retia, le ie ty hampandova iareo o tane ho isa’oo. ");
INSERT INTO tdx_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Aa le nitamañe am-bavatane tandrife i Bete-piore eo tika. ");
INSERT INTO tdx_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Ie amy zao ry Israele, janjiño o fañè naho fepètse añòhako anahareo hanoeñeo, soa t’ie ho veloñe hahafimoake vaho handova i tane atolo’ Iehovà Andrianañaharen-droae’ areo ama’areoy. ");
INSERT INTO tdx_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","Ko tovoña’ areo o tsara liliekoo naho ko añafahañe, vaho ambeno o lili’ Iehovà Andrianañahare’ areo afantoko ama’ areoo. ");
INSERT INTO tdx_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Niisam-pihaino’areo ty nanoe’ Iehovà amy Baale-Peore, ty amo fonga ondaty nañorike i Baale-Peoreo; fa narotsa’ Iehovà Andria­na­ñahare’o ama’areo irezay—indaty nañorike i Baal-peore rey, ");
INSERT INTO tdx_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","f’ie nifahatse am’ Iehovà Andrianañahare’ areo, le songa veloñe androany. ");
INSERT INTO tdx_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Ingo te nanareko o fañè naho fepetse nafanto’ Iehovà Andria­nañahareko amakoo hañoriha’ areo an-tane himoaha’ areo ho lovae’ areo henaneo. ");
INSERT INTO tdx_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Aa le oriho naho anò, fa izay ty hihi’ areo naho ty hilala’ areo am-pahaisaha’ ondatio, le ie mahajanjiñe o hene fañèo ro hanao ty hoe: Toe ondaty mahihitse naho mahilala ty foko ra’elahy tiañe. ");
INSERT INTO tdx_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Fa ia ty foko aman-drahare hañirinkiriñe Iehovà Andrianañaharen-tika, mpanoiñe ndra mbia’ mbia ikanjiantika. ");
INSERT INTO tdx_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Ia ka ty foko amam-pañè naho fepètse vantañe manahake i Hake fonitse taroñeko ama’ areo androaniy. ");
INSERT INTO tdx_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Aa le mitomira, vontitiro añ’ arofo tsy mone handikofa’ areo o raha ni­isam-pihaino’ areoo vaho ko anga’ areo himolaotse am-pitsa­koreañe amo hene andro hiveloma’ areoo; fe ampaharen­dreho o ana’ areoo naho o afe’ areoo, ");
INSERT INTO tdx_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","mentsake i nijohaña’ areo añatrefa’ Iehovà Andrianañahare’ areo e Korebey, ie nanao ty hoe amako t’Iehovà, Atontono ondatio hijanjiñe o fivolakoo, hioha’ iareo ty hañeveñ’ amako amo hene andro hiveloma’ iareo an-tane atoio, vaho hanare’ iereo hanao izay ka o keleia’eo. ");
INSERT INTO tdx_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Aa ie nitotoke mb’eo le nijohañe ambane’ i vohitsey, naho nilebalebà’ ty afo naneñateña i likerañey i vohitsey ie nisaroñan-drahoñe nimoromoroñe. ");
INSERT INTO tdx_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Le nitsara ama’ areo boak’amy afoy t’Iehovà. Jinanji’ areo ty feo’ i tsaray, fe tsy niisa’ areo ty vinta’e, i fiarañanañañey avao. ");
INSERT INTO tdx_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Tsinei’e ama’ areo i fañina linili’e ama’ areo horiheñey: i tsara folo pinate’e am-bato roe rey. ");
INSERT INTO tdx_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Le nafanto’ Iehovà amako henane zay ty hañohako anahareo o fañè naho fepètse hañoriha’ areo an-tane hitsaha’ areo ho lovaeñeo. ");
INSERT INTO tdx_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Aa kanao tsy nahaonim-bintañe nahareo te nitsara ama’ areo e Korebe añe boak’añ’ afo ao t’Iehovà, le mitomira, ");
INSERT INTO tdx_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","tsy mone hameta vatañe am-pitseneañe saren-draha ho anahareo ami’ty vintañ’ inoñ’ inoñe—ke lahy he ampela, ");
INSERT INTO tdx_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ke amam-bintam-bibi’ ty tane toy, he amam-bintam-boroñe aman’ elatse miti­liñe amo tiokeo, ");
INSERT INTO tdx_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ke amam-bintan-draha milalilaly an-tane, he amam-binta’ ze fiañe an-drano ambane’ tane ao. ");
INSERT INTO tdx_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Le he miandra mb’ andikerañey irehe mahaisake i àndroy, i volañey, naho o vasiañeo, naho i valobohòn-dikerañey, vaho mivik’ mb’a­ma’e naho mibabok’ ama’e hitoroñe irezay, o natolo’ Iehovà Andrianañahare’o amy ze kila ondaty ambanen-dikerañeo. ");
INSERT INTO tdx_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Fe rinambe’ Iehovà nahareo le hinaha’e amy fampi­tranaham-biy ao, boake Mitsraime añe, ho ondatim-panaña’e: le ie henaneo. ");
INSERT INTO tdx_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Ie amy zao niviñetse amako t’Iehovà ty ama’ areo, ie nametse te tsy hitsahako Iardeney vaho tsy himoahako i tane fanjaka atolo’ Iehovà Andrianañahare’o azo ho lovay; ");
INSERT INTO tdx_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","f’ie hikenkañe an-tane atoy, tsy hitsake Iardeney; f’inahareo ro hitsake naho hitavañe i tane fanjakay. ");
INSERT INTO tdx_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Aa le mitaoa tsy handikofa’ areo i fañina nanoe’ Iehovà Andrianañahare’ areo ama’ areoy ke hitsene sarem-bintañe, ke sareñ-inoñ’ inoñe nan­drara’ Iehovà Andrianañahare’o azo. ");
INSERT INTO tdx_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Fa afo mahaforototo t’Iehovà Andriana­ñahare’o, Andrianañahare Mpamarahy. ");
INSERT INTO tdx_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Ie nahatoly anake naho afe naho fa nierañerañe ela an-tane ao, naho manao hakarapiloañe am-pitseneañe sarem-bintañe ke sareñ-inoñ’ inoñe vaho manao tiva am-pivazohoa’ Iehovà Andrianañahare’o, hikaiha’ areo ty haviñera’e, ");
INSERT INTO tdx_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","le ho koiheko henaneo i like­rañey naho ty tane toy hitalily ama’ areo t’ie kila hihomak’ aniany an-tane himoaha’ areo am-pitsa­hañe Iardeney, handova’ areo, le tsy ho lava-ohatse fa ho vata’e mon­goreñe. ");
INSERT INTO tdx_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Ie hampiparaitahe’ Iehovà am’ ondatio añe; toe tsy ampeampe ty ho sehanga’ areo amo kilakila ondaty handroaha’ Iehovà anahareoo. ");
INSERT INTO tdx_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Ho toroñe’ areo añe ty ‘ndrahare rinanjim-pità’ ondaty; hatae naho vato, songa tsy maha­trea, tsy mahatsanoñe, tsy maha-filintseñe vaho tsy maha-antsoñe. ");
INSERT INTO tdx_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Aa ie añe ro hipaia’ areo Iehovà Andria­nañahare’o, le ho oni’o naho tsoehe’o añ-kaampon’arofo naho an-kaliforam-pañova. ");
INSERT INTO tdx_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ie ami’ty falovilovia’o, naho fa hene nifetsaha’ irezay amo andro añeo, le himpoly am’ Iehovà Andrianañahare’o vaho ho haoñe’o i fiarañanaña’ey; ");
INSERT INTO tdx_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Amy te Andrianañahare tretram-po t’Iehovà Andrianañahare’o, tsy haforintse’e, tsy hampimodoe’e; tsy ho haliño’e i fañina aman-droae’o nifantà’e am’ iereoy. ");
INSERT INTO tdx_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Ie amy zao añontaneo o sa haehaeo, o taolo’oo, ampara’ i andro nitsenen’ Añahare ondaty an-tane atoio; añontaneo boak’ añ’olon-dikerañ’ añe pak’ añ’olo’e ka; he teo ty nifetsahan-draha tsitantane hoe itiañe, ke eo ty nahajanjin-ty mañirinkiriñe aze? ");
INSERT INTO tdx_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Aa vaho eo hao t’indaty nahajanjiñe ty fiarañanañan’ Añahare nitsara ama’e boak’ añ’afo ao, manahake i jinanji’oy, t’ie mbe veloñe? ");
INSERT INTO tdx_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Hera teo ty ‘ndrahare nimane hangalake foko ho am-bata’e boak’ amo kilakila’ ondatio am-pitsohañe naho am-biloñe naho an-draha tsitantane vaho añ’ aly, andela-pitàñe maozatse naho am-pitàñe natora-kitsy, am-pampiboahan-kao­zarañe mahalatsa manahake o hene nanoe’ Iehovà Andrianañahare’ areo ho anahareo e Mitsraime añe añatrefam-pihaino’oo? ");
INSERT INTO tdx_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Ie nampiboaheñe ama’o, hatokisa’o te toe Andrianañahare t’Iehovà; le tsy eo naho tsy ie avao. ");
INSERT INTO tdx_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Nampijanjiñe’e azo boak’andikerañe ao ty fiarañanaña’e hanoroa’e azo, naho nampiboaha’e an-tane atoy ty afo’e jabajaba, vaho jinanji’o boak’ amy afoy o tsara’eo. ");
INSERT INTO tdx_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Kanao nikokoa’e o roae’oo, le jinobo’e o tariratse nandimbe iareoo, naho nampi­engà’e i Mitsraime amy fiatrefa’e naho an-kaozara’e ra’elahy ");
INSERT INTO tdx_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","hanoe’e soik’ aolo’o eo o rofoko maozatse naho bey te ama’oo, hampihova’e azo ao, hitolora’e i tane’ iareoy ho lova’o, le ie henaneo. ");
INSERT INTO tdx_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Aa le mahafohina androany vaho vontitiro añ’ arofo ao te Andrianañahare andikerañe ao naho an-tane am­bane’e atoy t’Iehovà, tsy aman-tovo’e. ");
INSERT INTO tdx_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Ambeno o fañè’eo naho o lili’eo; o andili­ako azo androanio hahasoa azo naho ty tariratse hanonjohy azo soa t’ie ho tamañe an-tane atolo’ Iehovà Andriana­ñahare’o azo ho nainai’e donia. ");
INSERT INTO tdx_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Le navì’ i Mosè ty rova telo alafe’ Iardeney mb’am-panjiriha’ i àndroy mb’ atoy ");
INSERT INTO tdx_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","hivoratsaha’ ty namono-ondaty, ie namono ondaty tsy an-tsatri’e, ie le lia’e tsy nimpirafelahy ama’e taolo, le mete hitriban-day mb’ami’ty raik’ amy rova fitsolohañe rey himoneña’e: ");
INSERT INTO tdx_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","i Betsere am-patrambey an-tane mira ho a’ o nte-Reòbeneo, i Ramote e Gileade ao ho a’ o nte-Gadeo, vaho i Golane e Basane ao ho a’ o nte-Menasèo. ");
INSERT INTO tdx_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Zao ty Hake nitaroñe’ i Mosè amo ana’ Israeleo. ");
INSERT INTO tdx_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Zao o taroñe naho fañè naho fepètse nisaontsie’ i Mosè amo ana’ Israeleo, ie fa niavotse i Mitsraimeo, ");
INSERT INTO tdx_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","alafe’ Iardeney atoy am-bavatane tandrife i Bete-peore, an-tane’ i Sihone mpanjaka’ i Amore nimoneñe e Khesbone, i ginio’ i Mosè naho o ana’ Israeleo, ie fa nienga i Mitsraimey. ");
INSERT INTO tdx_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Nimoneña’ iereo i taney naho an-tane’ i Oge mpanjaka’ i Basane, ty mpanjaka roe’ o nte-Amoreo alafe’ Iardeney mb’ am-panjirihan’ andro atoañe, ");
INSERT INTO tdx_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","mifototse e Aroere añ’olom-bavatane Arnone eo pak’ am-bohi-Sione añe (i Kermòne izay) ");
INSERT INTO tdx_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","naho i ratraratra iaby atiñana’ Iardene añey pak’ an-dRiak’Arabà ampoton-kerakera’ i Pisgà eo. ");
INSERT INTO tdx_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Kinoi’ i Mosè t’Israele iaby, le nanoe’e ty hoe: Janjiño ry Israele, o fañè naho fepètse taroñeko an-dravembia’ areo androanio: le ianaro naho itomiro vaho anò. ");
INSERT INTO tdx_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Nifañina a­mantika e Korebe añe t’Iehovà Andria­nañaharen-tika; ");
INSERT INTO tdx_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","tsy o roaen-tikañeo ty nifañina’ Iehovà fa itika, eka itikañe, itika veloñ’ etoañe henanekeo. ");
INSERT INTO tdx_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Nifanaontsy am-piatrefan-daharañe ama’ areo t’Iehovà boak’ am-bohitse ey; hirik’ amy afoy ao, ");
INSERT INTO tdx_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","(Nijohañe añivo’ Iehovà naho inahareo iraho henane zay hampalangesako ama’ areo ty tsara’ Iehovà, ie nañembañe anahareo i afoy vaho tsy nete nion­jom-b’ amy vohitsey mb’eo) nanao ty hoe: ");
INSERT INTO tdx_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Izaho Iehovà Andrianañahare’o nampienga azo an-tane Mitsraime añe boak’ an-trañom-pañondevozañe ao. ");
INSERT INTO tdx_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Tsy ho aman-drahare ila’e irehe naho tsy Izaho avao. ");
INSERT INTO tdx_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Ko mitsene samposampon-draha, ndra saren’ inoñ’ inoñe andikerañe ao, ndra an-tane ambane’e atoy, ndra an-drano ambane’ ty tane toy ao. ");
INSERT INTO tdx_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Ko ibokobokoa’o ndra italahoa’o; fa Izaho Iehovà Andrianañahare’o ro Andrianañahare Mpamarahy, mandilo anake ami’ty hakeon-droae’e pak’an-tariratse faharoe naho fahatelo’ o malaiñ’ ahio, ");
INSERT INTO tdx_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","f’ie manolotse fikokoa-migahiñe pak’an-tariratse faharivo’ o mikoko ahy vaho miambeñe o lilikoo. ");
INSERT INTO tdx_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Ko vaveñe tsy vente’e ty tahina’ Iehovà Andrianañahare’o, fa tsy havotso’ Iehovà ze mañamaivañe i tahina’ey. ");
INSERT INTO tdx_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Ambeno ty andro Sabotse hampiavahañ’ aze, ami’ty nandilia’ Iehovà Andrianañahare’o azo. ");
INSERT INTO tdx_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Eneñ’ andro ty hanoe’o ze hene tolon-draha’o. ");
INSERT INTO tdx_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Fe andro Fitofa’ Iehovà Andria­naña­hare’o ty andro faha-fito; ko mifanehak’ ama’e, ndra ihe ndra ty ana-dahi’o ndra ty anak’ ampela’o ndra ty ondevo’o lahy ndra ampela, ndra ty añombe’o ndra ty bo­rìke’o ndra inoñ’ ino­ñe amo hare’oo ndra o renetane mpimo­neñe an-drova’oo, soa te songa hitofa ka ondevo-lahy naho ampela’oo. ");
INSERT INTO tdx_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Tiahio t’ie niondevo an-tane Mitsraime añe le nampiengà’ Iehovà Andria­naña­hare’o an-dela-pitàñe maozatse naho am-pitàñe nato­ra-kitsi’e; aa le linili’ Iehovà Andria­nañahare’o te hambena’o ty andro Sabotse. ");
INSERT INTO tdx_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Iasio ty rae’o naho i rene’o, ami’ty nandilia’ Iehovà Andrianañahare’o azo, soa t’ie ho lava-andro naho ho soa tahy an-tane atolo’ Iehovà Andrianañahare’o azo. ");
INSERT INTO tdx_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Ko mañoho-doza. Ko mangala-bali’ ondaty, Ko mampikametse, Ko mitalily vilañe ondaty, ");
INSERT INTO tdx_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Ko mihañe ty vali’ ondaty, le ko mitsikirìke ty anjomban-drañe’o ndra ty tete’e ndra ty ondevo’e lahy ndra ampela ndra ty vosi’e ndra ty borìke’e ndra inoñ’inoñe a ondatio. ");
INSERT INTO tdx_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Nipazahe’ Iehovà ami’ty valobohò’ areo hirik’ am-bohitse ey boak’añ’afo ao naho amy rahoñey naho amy hamoromoroñañey, am-piarañanañañe abo i tsaray vaho tsy nitovoñañe. Pinate’e an-dravem-bato roe izay, vaho natolo’e ahiko. ");
INSERT INTO tdx_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Le nahajanjiñe i fiarañanañañe boak’ an-kamoromoroñañey nahareo, ie niforehete’ ty afo i vohitsey, le nañarine ahy ze hene talèm-pifokoa’ areo naho o androanavi’ areoo; ");
INSERT INTO tdx_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","le hoe ty asa’ areo, Ingo te naboa’ Iehovà Andrianañaharentika amantika ty enge’e naho ty hajabahina’e le jinanjintika i fiara­ñanaña’ey boak’ amy afoy ao, naho nionintika henane zay te toe mitsara ama’ ondaty t’i Andria­naña­hare vaho mitambeloñe iereo. ");
INSERT INTO tdx_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Ie amy zao ino ty hivetraha’ay avao? Toe hamorototo anay o afo jaba­jabao naho mbe hijanjiñe ty fiarañanaña’ Iehovà Andrianañaharentika, le vata’e hikoromake. ");
INSERT INTO tdx_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Fa ia amy ze hene atao nofotse ty nahajanjiñe ty fiarañanañan’ Andrianañahare veloñe boak’ añ’afo ao, manahake i nijanjiñen-tikañey vaho mbe nahatam­beloñe? ");
INSERT INTO tdx_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Miharinea mb’eo irehe, le janjiño ze hene tsarae’ Iehovà Andria­nañaharentika. Le fonga taroño ama’ay ze nitsara’ Iehovà Andrianañaharentika ama’o, le hijanjiñe vaho hanoe’ay. ");
INSERT INTO tdx_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Jinanji’ Iehovà o fisaontsi’ areoo, i nisaontsia’ areo amakoy, le hoe t’Iehovà amako: Fa tsinanoko o entañe sinaontsi’ ondatio ama’oo; le soa-fehe iaby o saontsi’ iareoo. ");
INSERT INTO tdx_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Ee te nanao hoe zao nainai’e ty arofo’iareo t’ie nañeveñe amako, naho nañambeñe o nandiliako iabio, soa te hanintsiñe nainai’e iereo naho o amori’iareoo. ");
INSERT INTO tdx_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Akia arè, isaontsio himpolia’ iareo mb’an-kiboho’ iareo mb’eo. ");
INSERT INTO tdx_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","F’ihe, mijohaña marine ahy atoy le ho taroñeko ama’o ze hene Lily, naho fañè naho fepètse, hañòha’o iareo hañorike irezay an-tane atoloko iareo ho fanañañe añe. ");
INSERT INTO tdx_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Aa asoao te hanoe’ areo ze andilia’ Iehovà Andrianañahare’ areo, tsy hiotake mb’am-pitàn-kavana ndra havia, ");
INSERT INTO tdx_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","fe horihe’ areo aman-kahiti’e ze hene lala linili’ Iehovà Andrianañahare’ areo, soa t’ie ho veloñe naho ho tahie’e vaho ho lava haveloñe an-tane fanaña’ areo atoy. ");
INSERT INTO tdx_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Intoy arè ty lily naho ty fañè naho o fepetse linili’ Iehovà Andrianañahare’ areo ahy hañòhañe anahareoo, hambenañe amy tane hitsaha’ areo ho tavaneñey, ");
INSERT INTO tdx_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","soa te hañeveña’o t’Iehovà Andrianañahare’o naho hambena’o ze hene fañè’e naho fepètse andiliako azo, ihe naho i ana’oy naho o anan’ ana’oo amo andro hiveloma’o iabio, soa t’ie ho lava-haveloñe. ");
INSERT INTO tdx_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Aa le mijanjiña, ry Israele, ambeno naho ano, soa te ho tahie’e, hibo­do­bodoa’o amy tane orikorihen-dronono naho tanteley, amy nitsara’ Iehovà Andrianañaharen-droae’o. ");
INSERT INTO tdx_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Mijanjiña ry Israele! Iehovà Andria­nañaharentika: raike t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Kokò t’Iehovà Andrianañahare’o an-kaàmpon’ arofo’o naho an-kaliforam-pañova’o vaho an-kaozara’o iaby. ");
INSERT INTO tdx_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Ambeno añ’arofo’o ao o tsara lilieko ama’o androanio. ");
INSERT INTO tdx_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Anaro an-kahimbañañe o ana’oo, le taroño naho miambesatse añ’ anjomba’o ao naho mañavelo amy lalañey naho am-pandrea’o ao vaho am-pitroara’o. ");
INSERT INTO tdx_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Feheo am-pità’o izay ho viloñe naho reketo ho alama an-dahara’o eo ");
INSERT INTO tdx_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","naho sokiro an-tokonan’ anjomba’o eo vaho an-dalambei’o eo. ");
INSERT INTO tdx_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Aa naho fa nampihovae’ Iehovà Andria­nañahare’o amy tane nifantà’e aman-droae’o Avrahame naho Ietsake naho Iàkobe hatolo’e azo, reke-drova jabajaba naho fanjàka tsy rinanji’ areoy, ");
INSERT INTO tdx_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","naho anjomba pea ty raha soa tsy natsahe’o, kadaha hinaly tsy nihalie’o, tanem-baloboke naho firiritan-katae olive tsy naketsa’o—aa ie mikama ampara’ te anjañe, ");
INSERT INTO tdx_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","asoao tsy handikofa’o t’Iehovà nañavotse azo an-tane Mitsraime añe, boak’ an-trañom-pañondevozañe ao. ");
INSERT INTO tdx_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Iehovà Andrianañahare’o ty irevendreveña’o, ie ty hitoroña’o, vaho i tahina’ey avao ro ifantà’o. ");
INSERT INTO tdx_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Ko mañorike ndrahare ila’e, o ndrahare’ ondaty mañohok’ anahareoo, ");
INSERT INTO tdx_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","amy te Andrianañahare mpamarahy añivo’o ao t’Iehovà Andrianañahare’o; ke hiviañe ama’o ty fifombo’ Iehovà Andrianañahare’o vaho ho faopaohe’e an-tane atoy. ");
INSERT INTO tdx_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Ko mitsoke Iehovà Andrianañahare’ areo, manahake ty nitsoha’ areo aze e Masà añe. ");
INSERT INTO tdx_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Fe ambeno an-kahimbañañe o lili’ Iehovà Andrianañahare’ areoo naho o fañè’e naho fepè’e linili’e ama’oo. ");
INSERT INTO tdx_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Ano am-pivazohoa’ Iehovà ty hatò naho ty hasoa, hiraoraoa’o naho himoaha’o naho handova’o i tane soa nifantà’ Iehovà aman-droae’oy, ");
INSERT INTO tdx_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","vaho haronje’e aolo’o mb’eo ze fonga rafelahi’o, amy nitsarae’ Iehovày. ");
INSERT INTO tdx_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Ie mañontane azo ty ana’o amo andro añeo ty hoe, Ino ty foto’ o taroñe naho fañè vaho fepetse nililie’ Iehovà Andrianañaharen-tika ama’ areoo? ");
INSERT INTO tdx_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Le ty hoe ty ho saontsie’o amo ana’oo, Niondevo’ i Parò e Mitsraime añe tika, fe nampiengà’ Iehovà boake Mitsraime ao an-dela-pitàm-patratse. ");
INSERT INTO tdx_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Nampi­boake viloñe am-pitoloñañe ra’elahy naho nampalovilovy amy Mitsraime naho amy Parò vaho amo añ’anjomba’e iabio añatrefam-pihainontika t’Iehovà. ");
INSERT INTO tdx_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Navota’e boak’ao tika hampihovae’e atoy, hanolora’e antika i tane nampitamae’e am-panta te hatolo’e an-droaen-tikañey. ");
INSERT INTO tdx_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Ie amy zay, linili’ Iehovà tika ty hañorike o hene fañèo, ty hañeveñe am’ Iehovà Andrianañaharen-tika ho fañasoàñe antika nainai’e, hampitambeloma’e antika, le hehe t’ie henaneo. ");
INSERT INTO tdx_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Aa le havañonan-tika t’ie mañambeñe an-kahimbañañe o lili’ Iehovà Andrianañaharen-tikañeo, amy nandilia’e antikañey. ");
INSERT INTO tdx_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Ie asese’ Iehovà Andrianañahare’o mb’amy tane himoaha’o naho ho ta­vane’oy, naho asiotsio’e mb’ aolo’o mb’eo ty fifeheañe maro: o nte-Kiteo, o nte-Girgaseo, o nte-Amoreo, o nte-Kanàneo, o nte-Perizeo, o nte-Kiveo, vaho o nte-Iebosèo, fifeheañe fito maozatse naho maro te ama’o, ");
INSERT INTO tdx_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","naho atolo’ Iehovà Andrianañahare’o ama’o vaho giohe’o, le tsy mete tsy mongore’o. Ko ifañina’o naho ko itretreza’o. ");
INSERT INTO tdx_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Ko ifangalam-baly, ko anolora’o anak’ ampela o ana-dahi’eo ndra andrambesan’ anak’ ampela i ana-dahi’oy, ");
INSERT INTO tdx_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","amy te hampiambohoe’e ty ana’o tsy haño­rik’ ahy hitoroñe ndrahare ila’e. Le hisolebotse ama’o ty haviñera’ Iehovà vaho harotsa’e aniany. ");
INSERT INTO tdx_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Fe inao ty hanoa’o iareo; demoho o kitreli’ iareoo, kimokimoho o hazomanga’ iareoo, naho firao o Asere’ iareoo vaho ampiforototò an’ afo o vongan-draha sinokitseo. ");
INSERT INTO tdx_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Ondaty miavake am’ Iehovà Andrianañahare’o irehe, ie jinobo’ Iehovà Andria­nañahare’o amy ze kila ondaty ambone’ ty tane toy ho vara’e. ");
INSERT INTO tdx_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Tsy t’ie nimaro ta ondaty ila’eo te napite’ Iehovà ama’ areo ty fikokoañe ndra ty fijoboña’e, toe nitsiampe te amy ze hene ondaty; ");
INSERT INTO tdx_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","fa ty fikokoa’ Iehovà anahareo naho ty nañambena’e i fañina nifantà’e aman-droae’ areoiy, ty nampiengà’ Iehovà anahareo an-dela-pità’e maozatse vaho nijebaña’e boak’amy trañom-pañondevozañey, hirik’ am-pità’ i Parò mpanjaka’ i Mitsraimey. ");
INSERT INTO tdx_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Mahafohina arè te toe Andr