﻿USE sofia;
DROP TABLE IF EXISTS sofia.tczchongthu_vpl;
CREATE TABLE tczchongthu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tczchongthu_vpl WRITE;
INSERT INTO tczchongthu_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Pathen'in Semtilin van le leiset asem tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Leiset chu agong bei le ahomkeu ahin, muthim chun twipi thuh tah chu akhukhum ahin, Hiche twipi chung'a chu Pathen Lhagao chu ana lhale ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Pathen'in; “Vah hung umhen,” atin, Vah chu aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Pathen'in vah chu aven pha asah e. Chule Pathen'in vah chu muthim a kon'in asep khen tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Pathen'in vah chu sun asah in muthim chu jan asah tai. Hiche apat chun nilhah le jingkah ahung umdoh tan hichu nikho masa pen ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Hichun Pathen'in aseiyin, “Twipi sukhen dingin, vanthamjol hung kidal hen lang Van, twipi le leiset twipi chu alang alang ah sukhen hen,” atin. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Hiti chun asei bangin aum in, van twipi le leiset twipi chu alang alang ah asukhen tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Pathen'in onghom chu vanthamjol asah in, hichun nilhah le jingkah achedoh kit in ahileh nikho nina ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Chule Pathen'in aseiye, “Vantham jol'a twi um jouse chu mun khat a kikhol khom hen lang chule tolgo lai um doh hen,” ati. Asei bang chun aum jeng tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Pathen'in tolgo lai chu leiset asah in chule twi jouse kikhol na mun chu twikhanglen asah e. Pathen'in aven pha asa lheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Chuin Pathen'in aseiye, “Leiset in hamphung ho, amu nei hamphung, agathei hamhing chi chom chom leh thingphung aga amunei ho, hiche ho chun ama ama chi dungjui cheh ahin sepdoh kit diu ahi,” ati. Hiti chun ahung kehdoh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Leiset a hamphung thingphung ama ama chi dungjuijin ahung kehdoh in, agathei amu nei thingphung ama ama chi dungjuijin ahung kehdoh tauvin ahi. Pathen'in aven pha asalheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nilhah khat le jingkah khat achekit in nithum alhing tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Chuin Pathen'in aseiye, “Sun le jan sepkhen dingin vanthomjol'a avah thei vahho hung kigol uhenlang, hiche ho chu kum kihei chin melchihnan jong, nikho simtoh nan jong chule kum simtoh nan jong pang'u hen. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Chujongleh hiche ho chu van'a vanthamjol'a kon'in leiset salvah-in pang uhen,’’ atin ahileh, hiti chun aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Hiche achun Pathen'in vah alen cheh ni asem in, vah alenjo chu sunlaiya thunei dingin apansah-in, chule vah aneojo chu janlaiya thunei dingin apansah tai; hiti chun ahsi ho jong ahin sem tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Pathen'in vahho chu vanthamjol'a pat in leiset salvah din apansah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Sunlaiya thunei ding, janlaiya thunei ding, chule khovah le muthim sepkhen dingin apansah tan ahi. Pathen'in aven ahileh pha asa lheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Hichu nikho li alhin ni ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Pathen'in aseiye, “Twija kon'in nga ho leh ganhing ahingthei dang ho umhen, chuleh vanthamjol'a jong vachate ajat kimsoh in hung leng leu hen,’’ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Hiti chun Pathen'in twikhanglen'a ganhing ahing thei jouse ahon'a kijot le dingin asem in, hiche ho chun twi a kidil sah sah uvin, ama ama jat cheh in alha uvin ahi, chujongleh ajat jat in alhanei vachate jong asem in ahi. Hichu Pathen'in aven pha asalheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Pathen'in abonchauvin phatthei aboh in, “Hinpha uvin lang chule pung uvin, twikhanglen'a twi lah dimset uvin, chule leiset chunga vachate jong pung uhen,’’ ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Chuin nilhah khat le jingkah khat achen ni nga lhinna ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Chuin Pathen'in aseiye, “Leiset in ama a kon'in sa jat chom chom hin hingdoh hen! Ama ama jat dungjui cheh in, vah ngoi thei gancha, tol'a kithol ganhing leh gamsa ho jong hihen” ati. Hiti chun aum jeng tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Chuin leiset chunga gamsa ho ama ama jat cheh in chule gancha ho jong ama ama jat cheh in a-opma kithol ajat jat in asem e. Pathen'in hiche ho chu aven pha asa lheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hichun Pathen'in aseiye, “Eihon mihem ho, eiho lim pu'in sem'u hitin. Amaho chu twikhanglen sunga nga ho jouse chunga thunei diu, vanlai jol'a leng le vacha ho chule vah ngoi thei gancha ho le gamsa ho, chule a op a kithol chengse chung'a thunei vaihom in pang uhen,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hiti chun Pathen'in ama lim mong mong in mihem chu asem in, Pathen lim tobang banginama lim chu asem tai, pasal le numei asem doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Pathen'in amani chu phatthei aboh in amani jah a aseiye, “Chipha lhonin chule pung jing lhonin simsen louvin leiset chung hinlo dimset un, chule nangni noiya vaihomna umhen, vanlaijol a leng vachate chunga jong chule twikhanglen'a ahingthei jouse chunga hijongleh aboncha ganhing namkim hihen chule leiset chunga lhale ganhing jouse hile achung uva thunei vaihom in pang lhon tan,’’ ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Pathen'in hitin jong seiye, “Ve lhonnin keiman leiset chunga muchi gathei phung jouse le thingphung gathei jouse aboncha hi nangni kihinso theina dinga kapeh lhon nahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Chule leiset chunga um gamsa jouse hihen chunga leng vachate ho hijongleh tol'a aop'a kithol ganhing jouse hijongleh ahaithei hinna nei jousen aneh ding uva hamhing jouse kapeh doh ahitai,’’ atile, hitobang chun aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Chuin Pathen'in asemsa chengse chu abonchan aven, “Apha lheh jengin ahi,” hichea chun nilhah le jingkah khat ahung um doh in nigup lhinni ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Hiti chun van le leiset chule asunga thil um jouse chu loupi tah a sem chai ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Hichun ni sagi lhin nin Pathen'in athilsem chu abonchan achaiyin, hiti chun a thilsem ho jouse a kon'in ama akicholdo tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Hiche ni sagi lhinni chu Pathen'in phatthei aboh in chule atheng ahi tin aphongdoh tai, ajeh chu athilsem le anatoh jousea kon'a akicholdo ni ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Hiche hi van le leiset ahung kisemdoh a akhanggui hung kipatdoh dan ho chu hiti hi anahi. Pathen'in leiset le van ahinsem patni chun, ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Leiset chunga tollhang a jong hamphung keh doh loulai ahi. Ajeh chu Pathen'in gotwi leiset chunga ajuhsah loulai ahin chule hia chu koima natong ding umlou lai anahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ahin leiset a kon'in twimei ahung kaiyin chule leichung jouse chu twiyin achap nouvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Chuin Pathen'in lei chunga kon'in vutvai achun mihem asemin, chule anahhom'a hinna hu alhakhum a ahile mihem chu hinna nei ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Chuphat in Pathen'injong niso lama Eden hon aphut doh in hiche achun asem sa mihem chu akoitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Chuin Pathen'in leichung'a kon'in vetnom nom um le neh ding thingga namkim akedoh sah in ahi, chule honlai lung'a chun hinna thingphung jong chule ase le apha hetna thingphung jong akesah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Hiche Eden hon'a kon chun honlei chapnou jing dingin vadung alongin, vadung chu vadung li in ahung long khenin vadung li asohdoh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Vadung khatna chu ahile Pishon ahin, hiche chu sana kimuna vadung ahin Havilah gam pumpia long kimvel ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Hiche gam'a sana kimu ho chu ahoi thei lheh in anamtui jah nom umtah chule song namtui jong akimui. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Vadung ni lhinna chu amin Gihon ahin, hiche vadung chu Cush gam pumpia long kimvel ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Vadung thum lhinna chu ahile Tigris ahin, hiche vadung hi sah solam gam'a Asshur gam pumpia long ahin, chule vadung li lhinna chu Euphrates ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Chuin Pakai Pathen'in ami semdohpa chu Eden honsunga apuilut in hiche hon'a natong ding le avetup dingin apansah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ahin Pathen'in mipa kom'a athupeh chu, “Nang man hiche honsunga theiga ho khu nadei dei naneh thei cheh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Hinlah nangman hon lailung'a ase le apha hetna theiga vang naneh lou beh ding, hichu naneh nini, nathi teitei ding,’’ ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Chujongleh Pathen'in aseiye, “Mihempa achanga aum hi apha poi hijeh chun keiman aum khompi ding khat sempeh ing kate,’’ ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Chuin Pathen'in leivui chu leingan asosah in lei chunga ganhing namkim asem in chule vacha ho chung lam'a alensah in chuin hiche ho jouse hi amin ipi pi asah em tin mihempa kom'a ahinpui khom in hiche a mihem pan aminvona jouse chu tuni geiya amin a pang den ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Hiti chun mihempa in ganhing namkim chu aminvo cheh in, chunga lengthei vachate ho leh gamsa jouse jong aminvo sohkeiyin ahi. Ahinlah mihempa kithopi ding akimu doh hih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Hijeh chun Pathen'in mihempa chu a imutmil sah in a imutmil kah chun Pathen'in anahgu khat aladoh in anung chu aphe in atom jol peh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Chuin Pathen'in Adam nahgu alah doh a kon chun numei khat asemdoh in amanu chu Adam kom'a ahin puilut in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Hichun mihem pan aseiye, “Amanu hi keima gu akon'a kisemdoh ahin, chule aphevou jeng jong keima phevou ahin, amanu hi tu apat a numei kiti ding ahi, ajeh chu amanu hi pasal'a konna kiladoh ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Hijeh a chu pasal in anu le apa adalhah aji a beh ding chule amani chu tipum khat kiti lhon ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ahin hiche pet chun pasalpa ahin numeinu ahin ani gel lhon a sagoh keuva um lhon ahin, ahi vangin jachatna anei lhon pon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Pakai Pathen thilsem jouse lah a gul hi alungthim thempen ahi. Nikhat chu aman numeinu adongin, “Pathen'in honsunga theiga jouse naneh thei lhon lou beh ding ahi tia asei mong em?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Numei nu chun gul jah a keini'n “Eden honsunga theiga jouse kaneh thei lhon ding ahi nai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Ahin Pathen'in hitin aseiye, “Hon lailung a theiga vangkhu naneh lhon louhel ding, lo jong nalo lhon louhel ding ahi. Ahin iti ham khat a nalo lhon a naneh lhon le nathi jeng lhon ding ahi,” tin aseiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Hinlah Satan in numeinu jah a aseiyin, “Nathi lhon loubeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ajeh chu Pathen'in ahet ahi hichu naneh nini lhon le namit lhon hung hahdoh intin Pathen toh nabah lhon ding thilpha le thilse hetheiya naum lhon ding ahi ti Pathen'in ahet jeh a asei ahi bouve,” atitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Hiche a chun numei nun theiga chu aven ahile neh dinga tui chule mitvet dinga jong vetnom nom um, chule mi achihsah jeng ding jeh chun aha duchat cheh tai. Hijeh chun numei nun theiga chu akilo in anetan chule a pasalpa jong them khat apen amapan jong ala in ane tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Hiche apat chun amit lhon chu ahung hahdoh in tahsa sagoh keo ahilhon chu aki hechen lhon tai. Hichun thingna akilo lhonin atahsa lhon chu akiselna lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Chuin nisa dai lhah lamin honsunga Pakai Pathen awgin chu ajalhonin hijeh chun hon lailung'a thinglah a chun amani tah Pakai Pathen masanga akisel mang lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ahivangin Pakai Pathen'in mihempa chu akouvin, “Adam hoiya um nahi hitam?” atile, ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Adam in jong adonbut in “Keiman nangma honsung'a na hung chu kahen ahile ka sagoh keo kahi jeh a ka kichat a kisela kahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Hichun Pakai Pathen'in jong aseiye, koi ham nangma sagoh keova na um'e tia na seipeh a chu? Honsung'a theiga nehih in kati chu naneh hitam? atile, ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Adam in adonbut in, “Keiman kaum khompi dinga nangman neipeh numeinu hin theiga chu themkhat eipen keiman kana netai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Chuphat in Pakai Pathen'in numeinu jah a aseiye, “Nangin ipi dinga hitobang pihi nabol hitam!” atile numei nun adonbut in, “Hiche gul hin eijol jol phat a kaneh ahi bouve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hichun Pakai Pathen'in gul jah a, “Nangman hiche nana boldoh jeh in, ganhing jouse lah a nang hi sapset nachan ding na hinkho lhung keiya na oipoh a na kithol tho ding, chule na hinkho sunga leivui naneh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Keiman nang le numeinu chilhah kah a kidouna kakoi ding, amapa chun nangma hi na luchang avohchip a, nangman amapa kengphang na chuh peh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Pathen'in numeinu jah a chun hitin aseiye, “Keiman na naovop hahsatna kabe peh ding, naosonat gentheiya cha nahin doh ding ahi. Najipa chung'a vai nahom nom jing ding, ahi vang'a najipan nang chunga vai ahop ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Chuin Pakai Pathen'in Adam jah a hitin ati, “Nangman naji thu na ngaiya naneh louhel ding ahi tia ka thupehsa theiga naneh tah jeh in nangma jeh a leiset hi sapset chang ahitai. Chule na hinkho damlai sungse a gimna le genthei thohpum pum'a neh na kihol a naneh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Chule nang doudin ling le mi-at thei jong hung kehdoh intin, chule nangma anche louhing a nakivah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Na ti-ul namaija long pum'a anneh na kihol'a na neh ding, chule nangma leiset a kisemdoh nahin leiset naleso kit ding ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Hichun Adam in ajinu chu amin Eve asah tai. Ajeh chu amanu mijouse hung pen dohna minu ahi tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Hichun Pakai Pathen'in savun a kon'in Adam le Eve ding von akhui peh in amani chu asilpeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hichun Pathen'in aseiye, “Tu apat a hi Adam hi eiho lah a khat tobang ahung hitan, thilpha le thilse hetheijin aumtai, chule tunjong aman hinna thingphung ga khu kilo intin hin ne lhon leh tonsot a hing den ding ahitai ati.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Hiche a pat chun Pakai Pathen'in Amani chu Eden hon a kon'in anodoh in, Chuleh Adam chu ahung kisemdohna leiset loulhou dingin asoldoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Hiti chun Pathen'in Adam anodoh jouvin, Eden hon nisolam'a hinna thingphung ngah dingin vantil Cherubim chu achen sah in, chule chemjam kou jeju chu akipei kimvel le sahtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Chujouvin Adam le Eve akitimat lhonin ahile Eve in nao ahin vop in Cain chu ahung peng tai, hiche a chun amanu'n hitin aseiye, Pathen phatthei bohna jal in cha pasal khat kanei tai ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Phat chomkhat jou chun Eve chun chapa Abel ahing kit tai, hichun khonungin chapang teni chu ahung khanglen lhon tan, Abel chu kelngoi ching in ahung pang in, Cain vang chu loubol mi ahung hitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Phat phabep jouvin Cain in alousohga alhun phat in alousohga phabep ahin pon Pathen a dingin kilhaina ahung sem tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Hitobang ma chun Abel in jong akelngoi lah a apeng masa athao pen tah khat chu Pathen a dingin ahin pedoh tai, Hichun Pathen'in Abel lam joh aven athilto jong kipah tah in asanpeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Hinlah Pathen'in Cain thilto maicham chu asanpeh tapoi, hijeh chun Cain chu hatah in alunghang in akaiku jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Hiche phat chun Pathen'in Cain jah a, “Ibola nang le nang ki lunghannahi ham? Chule ibola namai thim jeng a ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Thilpha bol dinga kilom ho chu nabol le na kisan pehda ding ham? Ahin thilpha bol dinga kilom ho chu na bolnom louleh kichih theiyin chonset nan naval lhum ding ahitai. Hiche ho hi na chinpha ding joh ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Nikhat chu Cain in asopipa Abel jah a “Eini thinglhang lam'a che hite atin, gamlang agei lhon phat in Cain chu asopipa Abel chunga achun athat tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Phat chomkhat jouvin, Pakaiyin Cain jah a, “Nasopipa Abel hoiya um hitam?” atile Cain'in jong adonbut in, “Kahepoi, Keima hi ka sopipa Abel ching tup kahim?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Hichun Pathen'in jong Cain jah a “Ipi nabol hitam? Na sopipa Abel thisan chu tol'a kon'in keima angsung gei in ahung peng in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Hijeh chun tu apatna nangma hi leiset chunga sapsetna noija uma nahitai, na sopipa Abel thisan in na chup ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Leiset a konna nangma dinga ga imacha pung ding ahi tapoi, itobanginnatong jong lechun nangman leiset a in mun neilou gamvah mangpa na kiti ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Chuphat in Cain chun Pathen henga aseiye, “Keima gotna kachan hi kei thoh jou hoi ahipoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Vetan tunin nangma a kon'in neidel mangtai, nangin lei chunga umna neilou nei hisah tai, tu apat a hi koi hijongleh eitoh khapen pen chun eitha ding ahitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Pathen'in adonbut in, “Ahipoi koi tobang nangma hinkho sumang dinga kigo a aum le keiman ama chunga sagi vei ka phulah ding ahi.” Hichea chun Pathen'in Cain chu koiman atha louna dingin Cain chunga melchihna khat akoipeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Hichea kon chun Cain in Pathen kom adalhan Eden niso lam a Nod mun'a chun acheng tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain chun ajinu aki timatpin ahile nao ahin vop kit tan hiche nao chu Enoch ahi. Chuin Cain in phat phabep jouvin khopi khat ahinsem doh in, achapa min aput sah in hiche khopi min chu Enoch asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enoch in chapa Irad ahingin, Irad chun Mehujael ahingin, Mehujael chun Methushael ahingin, Methushael chun Lamech ahing'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamech chun ji ni aneiyin amasa nu chu ahile Adah ahin chule anina nu chu Zillah ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adah in Jabal ahingin, ama hi ahiye, khoilupon in a chenga gancha chingho dinga apau chu. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Chule asopi pa min chu Jubal ahin, ama chu lathem gosem mut them masa pen ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zillah jong chun Tubal-cain ahingin, ama chun manchah ding abonchan sum-eng jong thih jong ahin kheng'e. Chule Tubal-cain chun sopi numei khat aneiyin amin Naamah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Chujouvin nikhat chu Lamech chun ajite ni jah a hitin aseiye , “Vo Adah le Zillah ka aw kasei ngai lhonin, ‘Ajeh chu pasal khat in eimavo jeh in ka that in gollhang khat in eiden jeh in ka that tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Koi tobang mikhat in Cain chu atha le sagi vei gotna chang ding ahile keima hinkho lading koi tobang aum le som sagi vei gotna chang ding joh ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Chuin Adam chun ajinu akitimatpi kit in ahile amanun chapa khat ahing kit in, amin Seth asah tai; ijeh inem itile amanun hitin aseiye, “Pathen'in chapa eipeh kit hi Abel khel a ei kipe ah ahi, ajeh chu Cain thapa khel dingin eipe tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seth chu mipi lhing ahung hiphat in chapa khat aneiyin amin Enosh asah e. Hiche apat chun mipi hon Pathen chu amin pan in ahou pan tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Hiche ho hi Adam te insung khanggui umdan kijihna lekhabu ahi. Pathen'in mihem asem chu ama lim tobang din asem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Pathen'in numei le pasal ana semdoh in aman amisem doh teni chu phatthei aboh in chuin amani chu mihem asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam chu kum jakhat le kum somthum alhinin ama lim le ama mel to kilou cha khat ahingin hiche pa chu amin Seth asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Seth apen jou chun Adam chu kum jaget tobang ahin be kit in, chu achun Adam in cha numei le pasal anei be nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam chu kum jako le kum somthum ahing nomsel in hiche jou chun ama athi tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seth chu kum jakhat le kum nga ahi chun ama chu Enosh pa ahung hi tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enosh pen jou chun Seth chu kum jaget le kum sagi ahin be nalai in chu achun aman cha numei le pasal adang ahin be nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Hichun Seth chu kum jako le kumsom le kumni ahingin hiche jou chun aleiset hinkho abeitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enosh chu kum somko ahi chun ama chu Kenan pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenan pen jou chun, Enosh chu kum jaget le kum som le kum nga ahing nalaiyin chujou chun cha numei le cha pasal ahing nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enosh chu kum jako le kum nga ahingin ama athi tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan chu kum som sagi alhing in ama chu Mahalalel pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel pen jou chun, Kenan chu kum jaget le kum somli ahing nalaiyin, chule aman chapa dang le chanu dang jong anei be nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan chu kum jako le kum som gei ahingin chuin ama hinkho abeitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Hichun Mahalalel chu kum somgup le kum nga alhing in ama chu Jared pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Jared pen jou chun, Mahalalel chu kum jaget le kum som thum jen ahing nalaiyin chule cha pasal le cha numei tamtah ahin be nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Hichun Mahalalel kum jaget le kum somko le kum nga gei ahingin hichun ama leiset hinkho abeitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Jared chu kum jakhat le kum somgup le kum ni alhin in ama chu Enoch pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enoch pen jou chun, Jared chu kum jaget gei ahingin, chuban in chapa le chanu dang jong ahing nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Jared chu kum jako le kum som gup le kumni ahingin, hichun ama aleiset hinkho abeitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enoch chu kum som gup le kum nga alhin in ama chu Methuselah pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Methuselah pen jou kum jathum sungin Enoch chu Pathen toh kinai tah in aum jing jengin chule chapa dang le chanu dang tampi jong ahinbe nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hiti chun Enoch chu kum jathum le kum somgup le kum nga ahingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Pathen toh kinai tah a um jing ahin nikhat chu ama akimu tapon Pathen'in akoudoh ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Methuselah chu kum jakhat le kum somget le kum sagi alhin in, ama chu Lamech pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamech pen jou chun, Methuselah chu kum jasagi le kum somget le kumni ahingin, hichun aman chapa le chanu dang tamtah anei be nalaiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Methuselah chu kum jako le kum somgup le kum ko ahingin hichun ama ahinkho abeitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Hichun Lamech chu kum jakhat le kum somget le kumni alhinin chapa khat ahingin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Ama min chu Noah asah in hitin aseiye, “Pathen'in agaosapsa gim genthei thoh a ikhut uva itohgim nau hiche leiset a konna ama hin eitha olsah ding'u ahi,”ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noah pen jou chun, Lamech chu kum ja nga le kum somko le kum nga ahingin hijou chun cha pasal le numei tamtah ahing nalaiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamech chu kum jasagi le kum somsagi le kum sagi ahingin, hichun aleiset hinkho abeitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noah chu kum ja nga alhin'in, ama chun Shem, Ham, chule Japheth ahingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Hiche achun leiset chunga mihem ahung pung pan tan ahile alah uva chanu jong tampi ahing tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Chuin Pathen chapate chun numei hoitah ho chu amu uvin ama hon adei thei lheh jeng uvin, hijeh chun adei dei akilhen uvin ajinu dingin akipui tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Hichun Pathen'in aseiye, “Ka lhagao mihem sunga atonsot kumkho in chengden thei deh ponte, ajeh chu ama tahsaphe bou ahin, ahin nikho jong kum jakhat le kum somni bou hi ding ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Hiche lai chun leiset chunga Nephilim miho ana um uvin, chujongleh Pathen chapate mihem Chanute henga ahunglut nung'u chun ama hon jong cha ahin peh tauve; hiche ho chu khanglui laiya mihat te ana hiuvin, chule mi minthang ho chu ana hiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Pathen'in leiset chunga mihem ho setna chu akhol chen jingin, chule Pathen'in mihem hon thil phalou agel'u ahilou le lungthima ase abolnom ho'u chu aboncha aphalou jeng ahi chu amu doh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Hichun Pakaiyin mihem asem'a leiset chung'a aumsah hatah in akisih tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Hichun Pakaiyin aseiye, “Keiman kasem doh mihem ho hi leiset chunga kon'a ka suhmang ding ahitai, mihem jouse alen aneo, gancha alen aneo tolgo chunga lamjot thei jouse chule chunglam a leng vachate ahiuvin, ajeh chu hicheng pi kana semdoh hi ka kisih lheh tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Hinlah Noah chu Pathen lungdei lam in aum jingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Hiche hi Noah le a insung mite umchan thusim ahiye, Noah chu mi chonpha, hiche khanglaiya chu leichung'a mona nei louva um chu Noah bou anahi, chule Noah chu Pathen toh ki lhakang louhel le Pathen toh kihou mat jing mi ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noah chun chate thum aneiyin amaho chu ahi le Shem, Ham, chule Japheth ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Hichun Pathen'in leiset chung ahinven ahile mihem ho phatlouna le kitahlouna jeng amudoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Pathen'in jong thil phalou jouse le thudih louva vannoi pumpia mihemte khat cheh a jong asetnau chu amudoh sohhel tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Hichun Pathen'in Noah jah a aseiyin, “Keiman tua hi hinna neiya avahle thei jouse ka suhmang ding ahitai. Ajeh chu amaho jeh hin leiset chunga pumhat a kinona jeng adim tan ahi, vetan keiman aboncha uva leiset toh ka suhmang tha ding ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Nangman Gopher thingin kong innei lentah khat kisem inlang, kong innei sunga chun indan adan adan in khah tanin, chuteng asung le apo twilutna thei lai jouse na huhbing sohkei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Hiche kong chu tong jali le somnga sao hi ding, chule asan dan chu tong somsagi le nga a sang hi ding, chule avai lam chu tong somli le nga a len hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Kong innei chu bangkot hong inlang achunglam chu khap som le get in sem inlang kong abanga kotpi hongin lang, indan noi nung danni lhinna, chule dan thum lhinna geiya nasem ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Tun ven keiman leichung jouse hi twisanglen a ka chupsah ding, hichu ganhing ahai thei jouse ahinkho kalah mang ding ahitai. Chule leichung'a um jouse ka suhmang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Hinlah keiman nangma toh kitepna khat nei ing kating, chujou tengleh kongsunga nang nahin, na chapate ahiuvin, najinu chule namoute toh na boncha uva kong sunga lut tauvin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Chule tahsa neiya hing gamsa namkim anu khat le achal khat cheh in kongsunga hin puilut un, ajeh chu twisang hatah a ahung let teng na hinso jou theina diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Vacha ho akop toni, gancha ho lah a jong ama ama jat dungjuiya, tol'a aop'a kithol tho lah a jong ama ama jat dung jui cheh a anu khat le achal khat cheh navah hing dinga na henga hung kitollut ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Chule na suhmil theilou ding chu kong sunga naneh dingu an naneh diu ninglhingset a nakipohlut diu nakikhol khom diu ahi, ajeh chu hiche anneh ding ho chu nangho le gancha ho jouse ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Hichun Noah in jong Pathen'in aseipeh bang bangin abolpan tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Chuin ima jouse ahina ding bang ahijou phat in Pathen'in Noah chu ahoulimpi tai. “Nangma le na insung mite kongsunga lut tauvin ajeh chu leiset chunga mihem holah a michonpha thudih a chon nangbou nahi”ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Nangman gancha theng lah a kon'in kop sagi, kop khat a achal khat le anu khat cheh, chule gancha thenglou lah a kon a jong kop sagi ma kop khat a achal khat le anu khat cheh ki kailut inlang, ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Chule chunga leng vachate lah a jong kop sagi cheh na puilut ding amaho lah a chu achal khat le anu khat akopto cheh a na puilut ding hichengse chu twisang let a konna nahinso theina dinga navah a chikhai dinga nahing hoi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ni sagi jouva pat go hatah a leiset chunga ka juhsah pan ding ahitai, chule go chu ni somli le jan somli sunga ka juhsah ding leiset chunga um jouse le ahing thei jouse ka suhmang hel ding ahitai,”ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Hiti chun Noah injong Pathen'in athupeh bang bang chun abonchan abolsohkei tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Leiset chunga twisang ahunglet chun Noah chu kum jagup ana lhing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Hichun Noah chu achapate toh, ajinu toh, chule amoute toh twisanglen na kon'a ahoidoh theina diuvin kong sunga alut tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Satheng ho lah a ahin, sa thenglou ho lah a kon'in jong tol'a kithol tho ho lah a kon'in jong, ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Akop kop a anu khat le achal khat cheh, Pathen'in Noah ahoulimpina bang chun kong sunga chun Noah kom'a avahlut cheh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Chuin ni sagi lhin jou chun twisanglen go ahung jupan tan, leiset chung chu gotwi in achup tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noah chu kum jagup alhin kum lhani lhinna ah, leinoija twi um jouse ahung put tan, chule vanthamjol apat in hatah in go alon tho tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ni somli le jan somli sungin go chu tang louhel'in hatah in ajujom jing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Hicheni tah chun Noah ahin, Noah chapate Shem, Ham, chule Japheth ahiuvin, Noah jinu ahin, amoute thum ahiuvin abonchauvin kong sunga alut tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Amaho ahiuvin, kong sunga um gamsa hang ahin insa gancha alen aneo chule tol'a aop'a kitholtho ho jong ama ama jat dungjui cheh in, vachate jong ama ama chilhah dungjui a vacha namkim a kon ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Akop akop in amaho chun kongsung ahin jon cheh un, hichun avetsah chu ahile hinna neiya tahsa hing ahiuve ti photchetna ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Hichu gancha ho lah a anu khat le achal khat ahung lut soh phat un Pathen'in Noah ateppeh bang chun, Pakaiyin kot akhah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Chujouvin ni somli le jan somli sungin hatah in twisanglen chu akhang in leiset chung jouse achup tan, hichun kong chu twi in ahin potou cheh cheh tan leiset sanga sang jon alet dohtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Twi chu nasa tah in akhang tul tul jeng tan ahile kong chu twi chunga akitol le len ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Achaina geiyin twi chun mol jouse lah a asangpen geiyin abonchan achup sohhel tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Twi chu akhanbe jingin mol jouse lah a asangpen jong chu tong som ni jen thuh-in achup manghel tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Hijeh chun leiset chunga um ahing thei ahaithei jouse, chunga leng vachate ahin, in na kivah gancha ho ahin, gam'a gamsa ho ahiuvin, ahon hon a kiloiya leiset chung'a kitol le ganhing namkim ahiuvin chule mihemte geiyin agam sohhel tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ima jouse leiset chunga um kiti pou anahhom a hinna hu neiya haithei jouse abonchan athigam soh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Pathen'in leiset chunga thil ahing thei jouse asumang sohhel tai. Mihem ho jouse, gancha ho, ganhing gamsa ho, tolgo chunga lamjot thei jouse, chunga leng vachate jouse abonin athi sohhel tai. Ahin hichea sohcha a hing doh Noah le a insung mite chule kong sunga um ganhing anu khat le achal khat um ho bou ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Hiche twisanglen chun leiset chung ni jakhat le nisom nga sung achup e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hinlah Pathen'in Noah le gamsaho le gancha ho kong sunga um jouse ageldoh jingin, leiset chunga huipi hattah ahin nunsah in ahile twisanglen chu ahung kem lheh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Leinoi lam a twi ho jong along kang tan, chule chunglam'a van'a konna go nasa tah a ju jong athip tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Hichun twisanglen chu leiset chunga kon'in ni jakhat le ni somnga jouvin akang heihoi tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Hiti chun nisom le nisagi lhinni lha sagi channa chun kong chu Ararat molchunga ahung kinga tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Lhani le akeh jouvin twi chu ahung kemtul tul'in mol dang dang ho jong molvum ahung kimu pan tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Chujouvin ni somli jou chun Noah in huikot kong sunga asem chu ahin hong doh tan, ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Hichun va-ah khat alha doh in ahile, leiset chung adung avaiyin aleng len, leiset chunga twi akan loulai jeh in ahung kinungle kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Chuin Noah in jong leiset chunga twi kang soh tam ti vetna dingin vakhu khat alendoh sah kit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Hinlah vakhu chun kingah na ding mun amu hihlaiye, ajeh chu twijin leiset achup nahlai jeh in ahung kinungle kit in, hichun Noah in vakhu chu akhut a adomlhan kong sunga akoilut kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Chuin ni sagi akho ngaiyin, chujouvin kong'a kon chun vakhu chu alha doh kit'a ahile, ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Vakhu chu nilhah langin ama henglam'a ahung kile kit in, vetau amuh achun athah beh a kiloulha Olive thingna khat ahin pon, hijeh chun Noah in jong leiset chunga twipi akangsoh tai, ti ahedoh paijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Chujouvin Noah jong ni sagi ma akho ngai kit in vakhu chu alha doh kit in ahile vakhu chu ahung kinung le kit tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noah hinkho chu kum jagup le kum khatna lha masapen, chu che lha nimasapen ni chun leiset chunga twipi abonchan akang sohhel tan, hijeh chun Noah in jong kong husin chu ahoh lhan agahven ahile leiset chung chu ana gohel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Hiti chun lhani jou don chun leiset chung hoitah in agohel tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Hichun Pathen'in ahoulimpin hitin ati, ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Nabon chauvin kong sunga kon chun potdoh tauvin, nangma nahin, na jinu ahin, na chapate ahiuvin, chule na moute ahiuvin kilhon dohpi'n. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Tahsa a hing ganhing jouse, naum khompi ho vachate ahiuvin, gancha ho ahiuvin, leiset chunga a op'a kithol tho ho ahiuvin, hiche ho chu leiset letthe thua ahung chikhai uva, ahung hin phat uva chule ahung punjalna ding uvin hin puidoh tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Hichun Noah ahin, ajinu ahin, achapate ho ahin amoute toh konga kon chun ahung potdoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Chuin gancha jouse alen aneo abonchauvin vacha ho ahiuvin ni ni in akop kop in anu khat le achal khat konga kon'in ahung potdoh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Hichun Noah in maicham Pathen henga asemin, hi a chun aman kipehdohna maicham pumgo thilto saho chule vacha ho amaho akipehdohna dung jui cheh in pumgo thilto dingin agouvam in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Chuin anamtui maicham ahung kisem jeh chun Pathen alung lhai lheh jengin hitin ama akihoulim in aseiye, “Mihem lung ngaitona hi achapan laiya kipat a hung gilou pan hita jongleh mihem jeh in keiman leiset hi gaosap kit tapong'e; chule ganhing ka semsa ho jong hi sumang kit tapong'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Iti nama jongleh leiset aum laisen muchi tuphat, chang aat phat, gam dap phat, gamsat phat, nipi lai le phalbi lai, sunlai le jan beilou ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Hichun Pathen'in Noah le achapate phatthei aboh in hitin ahoulimpi in hitin aseiye, “Cha le nao hing uvin, pung uvin lang leiset lochan sohkei uvin ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Leiset chunga um sa jouse ahin chunga leng vachate jouse ahin chule gamsa a op'a kithol tho ho ahiuvin chule twikhanglen'a nga ho ahiuvin abonchauva nangho naki chat cheh dingu ahi, abon chauva nangho khut a kapeh doh ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ahing theiya avahle thei jouse nangho dinga anneh a pang thei cheh ahiuve, anche louhing kapeh ma banga chu aboncha kapeh doh nahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Hinlah nangman naneh theilou ding chu sahing athisan pum pum a naneh loubeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Hinlah keiman kakhol chil ding chu koi tobang khat touvin mihem hinkho asuhbeiya thisan aso le, iti ham khat a gamsan mihem atha le hiche gamsa chu thadoh pai ding chule koitobanginmihem hinkho asuhbei leh ama hinkho hitobang ma a chu suhbei ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Koitobanginmihem hinkho asuhbei le hiche mihem hinkho sumang pa chu ama hinkho jong hi tobang'a chu kisumang ding ahiye, ajeh chu Pathen'in mihem hi ama lim bang banga asem doh ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Tuhin nangho hatah in pungnuvin lang leiset le asung dimset in cha le nao hing uvin lang, pung uvin chule hinlo chan sohkei uvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Hichun Pathen'in Noah le achate ahoulim pin hitin aseiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Keiman kakitepna avel'in ka sudet nom lheh tai, nang toh na chilhah te chengse dingin jong, ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Chule gancha nam kim nangma toh kong sunga um chengse toh vacha ho ahin, insa ho ahin, chule gamsa hang ho jouse ahin chule leiset chunga atoi thei avah thei jouse dinga hi ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Keiman nangho toh ka kitepna ka phudohna ajeh pentah chu hiche hi ahi, tahsa a hingho twisanglen a kisumang kit louhel ding ahin, chule leiset suhmangna dinga jong twisang letna um kit louhel ding ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Hichun Pathen'in aseiye, “Keiman ka kitepna ka phudoh hi nangho le nalhat khom piu ganhing nam kim ho ahiuvin chule tonsot a khangguija mite ding ahin, ikah uva amelchihna hiche hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Keiman ka semdohsa nisa vah emsel chu vantham jol'a ka koiye, hichu leiset le kei kikah a kitepna khat a um melchihna hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Keiman meibol lhang lei chunga kahin sol teng nisa vah emsel ho chu meilhang lah a hung kilang ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Hiche phat le chun keiman nangho le ikah uva ka kitepna chu hin geldoh kit ingting, chutengleh gotwi chu tahsa hingte sumang dinga twi sanga hunglen kit louhel ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Keiman nisa vah emsel meilhang lah a kamuji tengleh Pathen le leiset chunga tahsa a ahing thei jouse kah a tonsot kumkho a dinga kitepna chu kagel doh ding ahi,”ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Hichun Pathen'in Noah ahoulim pin hitin aseiye, “Hiche hi leiset chunga tahsa ahing thei jouse toh kei kikah a kitepna ka phudoh chu amelchihna hi ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noah chate ho kong sunga kon'a hung potdoh ho chu ahileh Shem, Ham chule Japheth ahiuve, Ham kiti pa hi Canaan pa ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noah chate thum ho a konna vannoi hi mihem hung dim ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Chuin twisanglet kichai jou chun Noah in tolgo lah achun lou abol pan tan hia chun lengpi phung aphut doh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Chujouvin nikhat chu Noah chun lengpitwi adonin ahile akham tan khoilupon buh sungah chun asagoh keovin alum tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ham Canaan pa chun apa Noah sagoh keova aum chu amun apotdoh paiyin asopi teni aga hetsah in ahile, ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Hichun Shem le Japheth in ponsil achoi lhonin alengkouva adom gel lhonin nunglam ngan anung toi lhonin apa akeova um chu agakhu khum lhonin, amai lhon vang ahei manggel lhonin apa akeova um amulhon poi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Hichun alupna a kon'in Noah ahung khah doh phat in achapa neopen in ana limbol chu ahedoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Hichun Noah in aseiyin: “Canaan vang gaosap chang hen, Asopi teni henga soh jouse soh in hung pang hen,” atin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Hichun Noah in hitin aseiye, “Pathen'in Shem phatthei boh maihen, ahin Canaan vang asopi soh himai hen, ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Pathen'in Japheth gam chu hatah in kehlet peh hen, chule Japheth in Shem ponbuh sung dunga jong chen sah hen, ahin Canaan vang asopipa soh hijing maihen,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Twisanglen kichai jouvin Noah chu kum jathum le kum somnga ahing nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Hiti chun Noah hin nikho abon bonin kum jako le kum somnga alhingin, chujouvin ama athi tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Hiche thusim ho hi Noah chapate Shem, Ham chule Japheth chilhah thusim chu ahiye; Twisang let jou chun amaho a kon'in cha tamtah ahung punbe in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Japheth chilhah ho chu Gomer, Magog, Madai, Javan, Tubal, Meshech chule Tiras ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Gomer chilhah ho chu Ashkenaz, Riphath chule Togarmath ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javan chilhah ho chu Elishah, Tarshish, Kittim, chule Rodanim ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Hiche apat chun amaho chilhah chengse chun leiset ahin toupha pan tauvin ama ama hitheina leh aphung achang akaidol cheh in ama nam hina dol cheh in acheng tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ham chilhah ho chu Cush, Mizraim, Put, chule Canaan ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cush chilhah ho chu Seba, Havilah, Sabtah, Raamah, chule Sabteca ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cush kitipa hin leiset chunga mihat a hung pang masapen Nimrod chu ahing'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Hiche phat laiya chun vannoiya gamleng hat sakap them pen ahung hin, chule Pathen ging tah mi jong ana hi'e, hijeh chun mihon Nimrod banga gamlen hat sakap thempen ahi tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Hichun Cush chun alenggam chu Babylon khopi sunga Babylonia tin ahin semdoh in, hiche khopi ho chu Erech, Akkad, chule Calneh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Aman hiche a kon chun Assyria ajonin hikom achun Nineveh khopi aphut doh in aban'a Rehobothir khopi ahin Calah khopi jong ahin phut doh kit e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Chuban chun Nineveh le Calah khopi teni kikah achun Resen khopi aphut doh in khopi lentah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Mizraim chu Ludite, Anamite, Naphuhite chule Lehabite ho cheng pa ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusi ho, Casluhi ho, chule Caphtori ho chu Philistine te hung kon dohna ho chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Canaan chapa tahpen chu Sidon, Sidon chilhah te hung kon dohna ho chu ahiuvin chule Hit chilhah ho jong Canaan akon ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Jebus ho, Amor ho, Girgash ho ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hivi teho, Arki ho, Sin ho ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arvad ho, Zemar ho, chule Hamath ho jouse hi ama hinsa cheh ahiuve, ahin khonungin Canaan insung kon mite chu gamtin'a akithe cheh sohkei uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Hiche apat chun Canaan gamgi chu Sidon apat Gerar lang jonin Gaza geiyin aki lhung lut peh in, Sodom lang jonin aki lhungin, Gomorrah aphan, Admah ahin phan, chule Zeboiim ahop in Lasha geiyin akilhung lut peh-e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Amaho cheng hi Ham chilhah ho ahiuvin, ama ama insung dungjui le, apao dungjui le, agam dungjui chuleh ajat dungjui uva ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Shem chate pasal ho jouse apunbe in ama chu Japheth upa ahin, Ebel chilhah ho jouse hi Shem'a konna hung kondoh cheh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Shem chilhah ho chu ahile Elam, Asshur, Arphaxed, Lud chule Ram ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ram chilhah ho chu ahile Uz, Hul, Gether, chule Mash ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arphaxad chu Shelah pa ahin, chule Shelah chu Ebel pa ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebel chun cha ni aneiyin amasapa chu Peleg (Hichu kisuh khenna tina ahi) ahi, ijeh inem itile ama phatlai a chu vannoi chu ama ama paotho doh dungjuiya ahung umdoh laitah chu ahi, chule asopipa min chu Joktan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Joktan chapa chu Almodad ahin, Sheleph ahin, Hazarmaveth ahin, Jerah ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoram ahin, Uzal ahin, Diklah ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal ahin, Abimael ahin, Sheba ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ophir ahin, Havilah ahin chule Jobab ahiuve. Amaho chengse hi Joktan chilhah cheh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ama hon gam kivaipohna atoupha uchu Mesha apat in Sephar lang jonin ahung kilhungin, nisolam'a thinglhang gamsung geiyin ahung kilhunglut peh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Amaho jouse hi Shem chilhah ahiuvin, aphung le achang, apao tho'u dungjui, agam dung jui le ajat dungjui uva Shem chilhah te ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Hiche phung le chang hung kimin phah se hi Noah chate a kon'a chi le nam hung kisem doh ama gui penna dungjuiya vannoiya nam jouse hi hiche phungpi a kon'a twisanglet jouva patna hung um doh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Phatkhat lai tah chun vannoiya mihem jousen pao khat bou ana tho uvin, apao cheng manu jong thakhat cheh ana hi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Hiche lai chun miho chu nisolama kon'in ahung kichon uvin ahile Babylonia gamsunga chun phaicham mun ong lentah ahin mudoh uvin, hikom'a chun acheng tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Hichun amaho khat le khat akihouvun, “Eihon cheh gadengu hitin goutah lheng'u hite,” akitiuvin; hiti chun song panna pang dingin cheh amang uvin, songlou dingin leingan amang uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Hichun ama hon hitin asei uve, “Hungun eihon khopi khat kisah uhitin, chule in sangtah khat atingvum vantoh kibang khat sadoh uhitin, vannoiya imin'u kithansah uhite, achuti louleh leiset chunga iki moh thethang gam ding'u ahi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Hinlah Pakai chu mihem ten khopi asah'u le insang asah doh'u vedingin ahung kumlha tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Hichun aseiye, “Vetan mipi ho hi aki pumkhat thei lheh jeng uvin chule pao khat seh bou atho uvin, hijeh chun phat chomkhat jou tengleh amaho hin ipi hijongleh abolgot ho'u chu ajolel loubeh dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Hijeh chun hungun eiho ga kumsuh'u hitin apao'u ga suhkhen peh uhite, chutile khat le khat athusei kihet mon um tauvinte,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Hiti chun Pakaiyin leiset chungah abon uvin, athe cheh soh hel'in hiche apat a chu khopi insah chu hung bouiya ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Hijeh a chu hiche kopi insang kisah chu Babel kiti ahi, ajeh chu Pakaiyin mipi ho lung asuhboui a paochom paochom athosah a hitia hi vannoiya ana thecheh'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Hiche hi Shem insung mite thusim ahi e. Twisang let kum ni jouvin Shem chu atahsa kum jakhat alhing in achapa Arphaxad chu ahing'e; ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arphaxad apen jou chun Shem chu kum ja nga ahingin, hichun aman cha numei le pasal tamtah ahinbei. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Hichun Arphaxad chu kum som thum le kum nga alhinin ama chu Shelah pa ahung hitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shelah ahung pen jou chun Arphaxad chu kum jali le kum thum ahingin, chuin aman cha pasal le numei tamtah ahinbei. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelah kum som thum alhin in ama chu Eber penna pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eber pen jou chun, Shelah chu kum jali le kum thum ahinbe in chuin cha pasal le cha numei jong ahin be nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber kum som thum le kum li alhinin ama chu Peleg pa ahung hitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Peleg pen jou chun Eber chu kum jali le kum somthum ahing nalaiyin, hiche jou chun aman cha pasal le cha numei tamtah ahinbe nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Peleg chu kum som thum alhinin, ama chu Reu pa ahung hitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Reu pen jou nungin Peleg chu kum jani le kum ko ahin be nalaiyin, cha pasal le cha numei tamtah ahinbe nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu chu kum som thum le kum ni bou alhinin Serug penna pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serug pen jou chun, Reu chu kum jani le kum sagi ahinbe nalaiyin, hiche jou chun aman cha pasal le cha numei tamtah aneibe nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serug kiti pa chu kum som thum alhinin Nahor pa ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nahor pen jou chun Serug chu kum jani ahinbe nalaiyin, hiche jou chun aman cha pasal le cha numei phachompi ahinbe nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahor chu kum som ni le kum ko bou alhin in Terah apeng tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terah pen jou chun Nahor chu kum jakhat le kum som le kum ko ahing nalaiyin, hichun aman cha pasal le cha numei simsen lou ahinbe nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terah vang chu kum som sagi jen ahung lhinin Abram, Nahor, chule Haran ahin hingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Hiche hi Terahte thusim kisei ahi. Terah chun Abram, Nahor, chule Haran pa ahin, chule Haran chu Lot pa ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ahin Haran chu apa Terah thi masang'in, apenna Chaldea gam'a Ur khopi achun athitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ahin chutobang lai chun Abram le Nahor chun ji anei gel lhonin, Abram jinu min chu Sarai ahin, Nahor jinu min chu ahile Milcah ahin, Haran chanu ahiye; (Milcah le a sopi nu Iscah chu Nahor sopi pa Haran chanute ahi lhon e). ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Ahin Sarai chu achiing in naovop thei louvin cha hing louvin aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Nikhat Terah chun achapa Abram le amounu Sarai chule Haran chapa atupa Lot akipuiyin abonchauvin Chaldea gam khopi Ur a kon chun Canaan gam jon dingin ache tauve; Ahin Haran khopi ahin phah phat uvin hiche mun'a chun acheng den tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Hichun Terah hinkho chu kum jani le kum nga alhing in, chujouvin Haran khoa chun Terah athi den tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Pathen'in Abram chu ana houlimpi in “Na gam, na insung mite, na sopiho chule napa sopi ho dalhan keiman gamthah ka musah ding khu jon tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Keiman nang hi nam lentah kaso ding nahiye; chule keiman nangma phatthei kaboh ding chule namin kaki than sah ding chule midang ho phatthei channa nahi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Chule nangman phatthei naboh ho chu phatthei chang diu, chule nangman na sapset te chu ka sapset ding; chule nangma jeh a leiset chunga phung nam kim phatthei chang ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Hichun Pathen'in athu mop dung jui chun Abram chu akichon in, chule Lot in ama aki lhonpi in. Abram chu Haran dalha a akichon doh chun akum kum somsagi le kum nga ana lhing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Aji ngaitah Sarai, asopi pa Lot, anei agou, agam jouse toh, agancha jouse, chule Haran a ana um laiya a insungmi ana kisemdoh chengse chu aki puiyin Canaan lam ajon tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram in alamjotna a Shechem chu ahopa in saotah ajot un, hiche achun ngahmun Moreh thingphung kom'ah akingauvin hiche mun chu Canaan mihon ana lodimun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Hichun Pakaiyin Abram chu akimupi'n “Keiman hiche gam hi na chilhahte kapeh ding ahiye,” hichun Abram injong ahenga hung kilah Pakaiya dingin hiche mun'a chun maicham khat asem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Phat chomkhat jou chun, Abram in noilam gam ahin jon'in kingahna mun ding thinglhang lam'ah asem doh in hichu nilhum lama Bethel khopi, niso lam'a Ai khopi, akah achun ponbuh akison in akinga in, hiche mun'a chun aman Pakaiya dingin maicham khat asemin chule Pakai min'in atao tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Hichun Abram chu noilam'a ahung chalbe ben Negev lam jonin ache paiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Hiche lai phat dontah chun Canaan gamsunga nasatah in kel alhan, Abram chu Egypt ma chelou thei ahi tapon, hikom achun Abram chu gampam mi in ana um'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Abram chu ahung suh deuvin Egypt gamgi ahung lhun phat chun, Abram'in ajinu Sarai jah achun aseiyin, Sarai “Ven, nangma hi numei mel-hoitah nahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Egypt miten namu tengu leh, ama hon hitia asei diu, “Ama hi ajinu ahi, amapa hi that doh'u hitin hiche teng chule ajinu hi eiho ichan thei ding'u ahi ati ding'u ahi!” ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Hijeh chun nang chu kei sopinu hi kahi tin kiseijin lang hile chun kei dingin phapen intin chule nangma jal'a chu kei jong ei hinghoi ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Thudihtah khat chu ahile Abram chu Egypt ahung lhun chun mipi ho chun Sarai chu amel-hoi chu amudoh soh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Chule Pharaoh lengpa chapa ten amudoh phat uvin Pharaoh kom'a amanu chu aphat sei lheh jeng tauve. Hichun Sarai chu Pharaoh insunga apuilut tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Hichun Sarai jeh chun Pharaoh in Abram chu thil mantam tah apen, kelngoi hon ahin, bong chalte ahin, sangan chal ho ahiuvin; soh pasal hihen soh numei ho hileh, sangongsao ho ahin sangongsao api ho ahiuvin anei doh sah lotai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Hinlah Pathen'in Pharaoh le a insung mite chu Abram jinu Sarai jeh chun het phahlou thoh hah tah chun abolgim lheh jeng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Hichun Pharaoh in Abram chu nasatah in ahousal in, “Ipi bol'a kingaito nahim,” atin, “I bolla na jinu ahi chu nei seipeh lou ham?” ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ibola ka sopinu ahi natia kaji dinga nei kipuisah ham? Hijeh chun ven tunjong hikom'a na jinu aum'e kipuiyin lang gangtah in chedoh tan!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Hichun Pharaoh in asemang pachong ho thu apetan, “Abram ahin ajinu ahin chule anei agou abonchan hiche gam'a kon'in gathah doh un,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Hichun Abram'in ajinu Sarai, asopipa Lot toh, Egypt gam chu adalha uvin chunglam Negev mun lang jonin achetou tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram chun gancha anei lheh jeng tan, hiche keo hilouvin sana le dangka jong ahao lheh jengtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Hiti chun Negev apat Bethel geiyin ahung cheng un, chuleh Bethel le Ai kikah a phat masa a ana sonjiu banginkhoilupon in asong uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Hiche mun chu ahile Abram in maicham anasem dohna mun ahin hikom achun Pathen'in avel in ana hou kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot, Abram toh kilhon jing pa jong chu ahung hao lheh tan kelngoi hon ahin kelcha hon ahin tamtah ahin nei tan chule khoilupon in jong ahin nei doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Hinlah achen nau gam chu Abram le Lot dingin ahung neo lheh jeng tai, ajeh chu akelngoi hon ho le kelcha hon ho ahin gancha dang ho aum khom thei tapouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Hijeh chun Abram le Lot gancha chingho kahlah a kihet khelna ahung um doh tan hiche phatlai chun Canaaan mite le Periz mite jong ana cheng khom uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Achaina keiyin Abram in Lot jah a hitin aseiye, “Eini kiheto themsel hite nangma le kei gancha ching ho kahlah a, ajeh chu eini hi kinaicha ihi bouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ven na masanga gam-ong lenpitah hi nanga ahiye, nangman kilhen in hoilam hi nadei ham kilhen in ikihop ding ahi. Leiset gam ong veilam nadei le keiman gam ong jetlam kaki lah ding, nangman jetlam aphajoi nati le keiman na dei lou lang chu kaki lhen mai ding ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot chun phat sottah gam chu aven gam pha leithao potna mun Jordan phaicham lang chu Zoar lang toh kinai lang deu, hilang chu ahile aphat seh a twiyin achapnou na mun gam Pakai honlei tobang twi chap nou jing ahilouleh Egypt te honlei banga hoitah ahi. Hiche phatlai chu Pakaiyin Sodom le Gomorrah asuhmang masang ana hi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Hijeh chun Lot in jong Jordan vadung phaicham pumpi chu akilhen in, hiti chun Lot chu niso lam jonin akitol tai; hitobang hin amani aki inkhen lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Hichun Abram Canaan gam'a cheng din aumtai. Chua chun Lot in ama khoilupon buh chu Sodom gam toh kinai phaicham geiyin aga songdoh peh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Hinlah hiche Sodom mite chu aphamo thei lheh un, chule agilou thei lheh un Pakai douna in akisa chavai lheh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot apotdoh jou phat in Pakaiyin Abram chu ahoulimpi in, “Vetem in namit a namu phah chan gam ninggei achunglam anoilam, solam le lhumlam. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Keiman nangma hiche gam jouse namit a namu phah jouse nangma le na chilhahte jouse tonsot a nei le gouva kapeh nahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Keiman nason na chilhahte chu leiset a leivui jat ka phahsah ding, leiset leivui jat sim joulou banga nang son le chilhahte jong simjou lou ahi bouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Hijeh chun kipatdoh inlang agamsung hi adung avai asuh atungin ga kholtoh in, ajeh chu ken nangma kapeh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Hichun Abram'in aumna chu Hebron mun a achon in gangpithing kena kom Mamre kiti mun chu ahi. Chule Abram in hiche mun'a chun Pakaiya dingin maicham khat asem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Hiche phat laitah chun gal kinah kiboina ana um'in, hiche a ana kiboi ho chu ahile Babylon lengpa Amraphel, Arioch lengpa Ellasar, Kedorlaomer lengpa Elam, chule Goiim lengpa Tidal ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Chule akidoupi ho'u chu Sodom gam lengpa Bera, Gomorrah lengpa Birsha , Admah lengpa Shinab, Zeboiim lengpa Shemeber, chule Bela lengpa (Zoar kitipa) ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Hiche anunung'a lengho hi Siddim phaicham (twithi kol phaicham) a apang un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kumsom le kumni sung'a amaho hi Kedorlaomer lengpa noiya ana kun jing'u ahin, amavang kum som le kum thum lhin kum'in adouvin ahung pang tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Kum khat jou chun Kedorlaomer lengpa le ama pankhompi lengho chu ahung kon uvin, Rephaim mite chu Ashteroth-Karnaim achun ajou un, Zuz mite chu Ham achun ajou un, Emim mite chu Shaveh-kiriathaim achun anajou un, ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Chule Hor mite chu amolsangu Seir apat gamthip lang gamgi El-Paran chan geiyin aga joupeh uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Hichun amaho hikom'a kon chun (Kadesh kiti) a akinung lekit uvin , tuhin En-mishpat achun Hazazon-tamar a cheng Amor mite leh Amalek mite chu agamsung pumpin ajou tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Hichun leng phalou akiphin ho sese chu Sodom, Gomorrah, Admah, Zeboiim, chule Bela (Zoar kitipa) galkon din akigong un twipi-thi phaicham achun gal asat uvin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Elam gam lengpa Chedorlaomer le Goiim lengpa Tidal toh, Babylon lengpa Amraphel toh chule Arioch lengpa Ellasar chutoh akisat uvin, hicheng leng li ho chun leng nga ho chu anadou un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Amaho se gal akisat jou uchun Twipi-thi kol phaicham achun thih e meichang adim jengin ahi. Hichun Sodom lengpa le Gomorrah lengpa sepai ho chu ajamdoh un, amaho loi khat chu kotong sunga alut un, amaho lah a loikhat chu thing lhang lama ajam cheh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Gal hangsan mihat ho chun Sodom le Gomorrah alonkhum un gal manchah ho jouse chule neh le chah ho jouse akichom khomun ache tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Amaho chun Lot, Abram sopipa jong chu aman uvin Sodom a chengpa chu anei thil le gou jouse jong alahpeh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Hinlah Lot insung mite khat ana sohcha in, amapa chun Abram Hebrew mipa aga seipeh tai, hiche lai chun Abram chu Eshcol le Aner sopipa, Amor mi Mamre gangpi thingphung vel dunga chun ana cheng nalaiye, amaho jong chu Abram toh ana pangkhom ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Hichun Abram in asopipa Lot kimat ajahdoh phat chun aman tohgon ahin neitan, mihem jathum le som le get phatah a galbol kithem chuhsa ama insunga peng cheh ahin lhengdoh in ama tah in alamkaiyin amaho chu Kedarlaomer sepai ho chu Dan geiyin aga nungdel peh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Hichun Abram in amaho chu ahom khenin jankim laitah in abulu'un Kedarlaomer sepai ho chu ajam cheh tauve, Abram in amaho sepai ho chu gamla tah in anojam'in Damascus khopi sah lang Hobah chan geiyin agadel peh-uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Hiti chun Abram injong asopipa Lot jong, athilkeo chengse toh, numeiho ahiuvin mipi ahiuvin abonchan ahin nungpui soh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram chun Kedarlaomer chuleh apankhom pi leng ho aga jo a ahung kinungle lam chun Sodom lengpan Shaveh phaicham (Shaveh tichu lengpa phaicham tina ahi), achun alamto dingin ahunge. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Hichun Melchizedek Salem lengpa chule Pathen Thempu Chungnungpen a pang pan Abram chu lengpitwi chuleh changlhah ahin pohpeh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Melchizedek in Abram chu hiti hin phatthei aboh in hitin aseiye, “Van le leiset hin phutdoh a Pathen chungnung pen kom'a, Abram phattheiboh chang hen, ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Chule nagalte nangma khut lum'a lousah a, chungnungpen Pathen chu loupi hen,” ati. Chuin Abram in Melchizedek chu thil jousea kon'in hopsom a hopkhat khat apesoh keiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodom lengpan Abram jah a hitin aseiye, “Kanam mite na hentup ho chu nei nungpeh tan, amavang thilkeo ho chengse nangin na matdoh ho vang chu nangma adin na kikoi theiye,” atile, ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram in Sodom lengpa hitin adonbut in, “Van le leiset hin phutdoh Pakai Pathen chungnung pen kom'a kakihahsel ahitai, ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Keiman patse jangkhat cha hihen lang, kengchot khao jeng cha hijongleh nang thil kiti poupou khatcha kalah louhel ding ahi, nangman Abram ka haodoh sah tai,” tia nasei thei louna dingin; ");
INSERT INTO tczchongthu_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ahin keiman kalah ding chu gollhang hon aneh doh ule mihon ana nehchai ho bou chu ahi, chule keiman ka deilhen pentah chu ahile achan ding uva kilom thil le gouho chu kaloi kamite Aner, Eshcol chule Mamre amaho petan. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Phat chomkhat jou nung hin, Pakaiyin gaovin Abram akihoulimpin hitin aseipeh e. “Abram imacha kicha hih in, ajeh chu keiman kahuh ding, kipaman jong atam a tam na chan ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abram in adonbut in, “O Pakai, loupipen nangma phatna na phatthei ho hi keiman chapa kaneipoi, ajeh chu nangman chapa nei pehlou jeh in, ka insunga soh a pang, Eliezer Damascus amapa bou hin ka gou alo ding joh in aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Nang man keima chilhah ding a chikhai ding, neipe tapon, hijeh a chu ka sohte lah a khat hin ka gou alo ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Pakaiyin ama chu ahoulim pin, “Ahipoi, nangma soh hon na gou alo ahi, nangma a konna chapa um ding ama chun na gou alo ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Hichun Pakaiyin Abram chu polama akoudoh in akihou pin, “Vanchung lam ven Ahsi ho khu simtem in nasim jou nah em. Hitobang chu ahi na chilhah atam ding dan chu,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Chuin Abram in jong Pakai tahsan na dihtah in aneitan ahile hichu ama dingin dihchan nan akisimpeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Chujouvin Pakaiyin Abram ahoulimpi kit in, “Hiche gam hi nalo dingin nape ing'e tia Chaldea gam Ur khopia konna nangma nahin puidoh a Pakai chu keima kahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Hichun Abram in adonbut in, “O Pakai hiche hi kalo ding ahi ti ipia iti kahet doh thei ding ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Hichun Pakaiyin Abram ahou lim pin ajah a, “Bongnou kum thum lhingsa khat toh, kelngoi chal kum thum lhingsa khat toh, chule vahui nou khat le vapal nou khat ka henga hin choi tan,” ati peh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Hichun Abram in hichengse chu apedoh in athat in, hichun ahapsat cheh in, ahap lang ton alupsah in hinlah vacha ho vang chu asemkeh poi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Chuin muthongho ahung lenglhauvin hiche sa kikoi ho chu ane kigo uvin ahile Abram in muthongho chu anodoh jin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Chuin nisa alhum ding kon'in Abram ahung imut soh tan, chujongleh tijat umtah muthim lhangkhal ahung jingin amapa chu ahin jinkhum tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Hichun Pakaiyin Abram ahoulimpi in, “Nangman thonlou dinga nahet ding chu na chilhah ho hi gam danga hung mah thah diu ahiye, amaho se chu kum jali sunga mi bol genthei thoh a ga um ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ahin keiman hiche nam sugenthei ho chu ka phulah ding ahi, chule phat ahung sot a achaina teng amaho chun hatah a nei le gou ahin nei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","(Nangman vang lungmong sel'a na pute heng na jot ding, chule na kum lhingset a na hinkho kichaiya na kivui ding ahiye.) ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Chule amaho hi khangli ahung lhin phat le hiche gam'a hi hung kinung lekit diu ahi, ajeh chu tuchan gei hin Amor mite khan gitlouna hi pilhing loulai ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Chuin nisa alhum phat in mu athim tan ahile, meikhu belsung khat ah mei al-lenglung khat le meivah tobang khat ahung kitol in, hiche pi chu sa kihapsat a kikoi teni kah achun ahung kitollelen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Hichun Patkaiyin Abram chu hitin a kihoulimpi in, kinoptona anei lhonin hiche nichun, “Keiman nason na chilhahte kapeh gam chu hiche hi ahi, Egypt gamgi apat luipi dung gei Euphrate vadung gei, ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Gamsung tutua Ken mite, Keniz mite chule Kadmon miten atoupha se, ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit mite, Perizz mite chule Rephaim mite, ");
INSERT INTO tczchongthu_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amor mite ahiuvin, Canaan mite ahiuvin, Girgash miho ahiuvin, chule Jebus miho gam ahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Tun, Abram jinu Sarai, chun cha anei thei tapoi. Ahinlah Sarai chun Egypt mi soh numei khat ana neiyin amanu chu Hagar ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Chuin Sarai in jong Abram jah a aseiye, “Ven Pakaiyin kei la cha eihin sah tapon, lungset tah in ka sohnu kom'a galut tan; ijem itile amanua konna khu ka inchen dohsah thei nahi,” atile, Abram in jong Sarai thu angai tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Hichun Sarai Abram inneipin Hagar chu apuiyin Abram ji din apetai, hiche phat laitah chu ahile Abram kum som Canaan na achen jou don ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Hichun Abram toh Hagar chu akitimat lhon tan, chuin Hagar chun nao ahin vop tan hichun apinu Sarai chu noise tah in ahin vepan tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Hijeh chun Sarai in Abram jah a aseitai, “Hiche ho jouse hi nang suhkhel ahi, ka sohnu hi nangma dan noiya ka koi ahin, hinlah tuhin amanun nao avop tan keima noise tah in eive tan hijeh chun kei le nang kah a Pakai thutan in hung pang jeng hen!” atitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram'in adonbut in “Ven, amanu khu nasoh hilou ham, nangman pha nasah dungjuijin bol tang em” ati. Hichun Sarai in Hagar hatah in ahin sugenthei pan tan hichun amanun (Hagar) ajamsan tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Pakai Vantil in gamthip a twikhuh phungkhat a Hagar chu aga mudoh in ahi, hiche twikhuh chu Shur jotna lampia um ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Pakai Vantil chun aseiye, “Hagar, Sarai sohnu hoilanga konna hoilam jon ding nahim? ” atile Hagar in adonbut in, “Kapinu, Sarai kom'a konna hung jam doh kahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Hichun Pakai Vantil chun amanu ahoulimpi in, “Nangma napinu kom'a kinungle in chule amanu dan noiya nakun angaiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Hichun Pakai Vantil chun ahoulimpi nalaiyin, “Keiman na chilhahte tamtah kapehbe ding nahi, sim jong na sim joulou ding ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Pakai Vantil chun ahoulimpi nalaiyin, “Tua hi nangma naovop nahi tan chapa khat nahin ding, hiche naosen chu amin Ishmael nasah ding ahi. (Pathen'in angailhi jing'e tina ahi), ijeh inem itile Pakaiyin na gimna chu na khongai peh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Chule nachapa hi mihem lah a gam'a sangan lungthim bei bang ding, mitin douna khut ahinlap a chule mitin khut ama chunga hung chu ding, chuleh aphunggol jouse toh kidou toa hung khosa ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hiche jou chun Hagar in ajah a thu hinsei Pakai chu aminvo in, “Nangma hi keima eimudoh a Pathen nahi,” ati. Ajeh chu amanu'n “Tahbeh monga keiman Pathen kamu a chule ama kamu nunga ka hing'a kaum nahlai ham?” atin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Hichun twisam putna chu amin Beer-lahai-roi asah tai, (hichu “Eimudoh Pa Hingjing twikhuh” tina ahi), Hiche Twikhuh hi Kadesh le Bered kikah a um ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Hichun Hagar in Abram chu chapa khat ahin peh tai. Hichun Abram in achapa min chu Ishmael asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Hagar in Abram dinga Ishmael ahin peh chun Abram chu kum som get le kum gup alhing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram chu kum somko le kumko alhinin Pakaiyin ahoulimpi in hitin aseipeh e, “Keima El-Shaddai____ 'Pathen chungnung kahi.' Hijeh chun lunglhaisel in nei hou jingin lang, chule thenna hinkho mang jingin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Keiman nangma to ikikah a kitepna nape ingting hichu thon louhel'a nangma chilhah simsen lou kapeh ding nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Hichun Abram in amai tol lang aven hichun Pathen'in ahin houvin hitin aseiye, ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Hiche hi keima le nangma kinoptona ahi, keiman nangma hi nam jouse pa kaso ding nahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Abanna namin jong kakhel peh ding, Abram nahi tah louding, Abraham na kiti ding ahitai, ajeh chu nangma hi nam jouse dia mipa nahi ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Keiman nangma hatah a kagasah ding, na chilhah ten nam tamtah ahin sondoh diu, chule leng thupi tah tah jong amaho lah a hung umdoh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","“Keiman athah a nangma to iki noptona chu na chilhahte to kakitepna avel'a ka phudoh kit ding nangma nunga na chilhahte a dinga jong, khang le khang kikah ajong, hiche hi atonsot a hi ding, keima na Pathen'u kahi jing ding chule nanam, na chilhahte Pathen jong kahi jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Keiman Canaan gam pumpi ahin, tua na chenna gam kholjin banga nachen nau hi nason na chilhahte atonsot a goulo dinga kapeh ding, chule amaho dinga jong a Pathen'u kahi jing ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Hichun Pathen'in Abraham ahoulimpin, “Nangma tah in jong kinoptona hi najui ding, chule na nunga nason na chilhahte dinga jong akhang lhum kei uva ajui ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Hiche hi ahi kinoptona nangma le na chilhahte jousen ajui cheh ding, nangho lah a pasal jousen chep akitan sohkei ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Nangman na bollou a hitheilou chu natahsa vunval abohlai chu nachelhah sohkei ding, hichun avetsah chu ahile keima le nangma kikah a kinoptona hijing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Hiche hi nangma insung mite seh hilouvin, koi tobang nasoh nakol nangma insunga dinga nachoh doh ho jouse jong ahop tha cheh ding, ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Abonchauva chep nakitan cheh diu, na tahsauva maha napoh uchu keima toh atonsotna iki nopto na'uva um jing ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Koi tobang pasal khat tou hiche kinoptona cheptan hi bollou aum le ama chu kinoptona insunga kon'a paimanga um ding ahi, ajeh chu kinoptona ajuilou jeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Hichun Pathen'in Abraham ahoulimpi'n “Na inneipi Sarai jong Sarai na ti tahlou ding ahi, ijeh inem itile amanu min jong hi tu apatna Sarah hi ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Keiman amanu hi phatthei kaboh a chujongleh amanu a konna hi chapa khat kapeh ding nahi, hitia chu keiman amanu hi phatthei kaboh a ama jong “Sarah” chitin namtin nu hung hi ding mitin vaipi leng ding ho jeng jong amanu a konna hung peng doh ding ahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Hichun Abraham jong akun in tol lang aven anui tai, chuin alungthim in ama le ama akihouvin, Keima hi kum jakhat kahi nunga mipa kahi thei ding ham? Chule ka inneipi Sarah jong kum som ko le kum ko ahi jouva naosen iti anei thei ding ham? ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abraham'in Pathen heng'a aseijin, “Ahi thei ding le Ishmael hi nangma phatthei bohna noiya um jing tahen.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Hinlah Pathen'in adonbut in, “ahipoi Sarah, na inneipi in nangma a dinga chapa khat nahin peh ding, nangman hiche chapang chu amin Isaac nasah ding ahi. Chule keiman ama le ama nunga ason achilhahte dinga kinoptona chu atonsot geiya kinoptona a um jing dinga ka phudoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ishmael jong chu phatthei kaboh ding nangman nathum ma bang'a ama jeng jong hatah a kapun sah ding, chule ama chilhahte ho jong hatah a pung dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Hinlah keima kitepna vang chu Sarah in khovei tulai phat a hi nahin ding Isaac chuto bou ka phudoh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Pathen'in thu aseijou phat chun Abraham chu adalhatai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Hichun Abraham'in jong achapa Ishmael ahin, asoh pasal ama insunga peng den hihen, sum a achoh tho hijongleh, Abraham mite lah a pasal jouse chu apuikhom in, Pathen'in aseipeh bang bang chun hiche nikho mama chun chep atan peh sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraham'in chep akitan chun akum kum som ko le kum ko ana lhing tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Chule achapa Ishmael in chep akitan chun kum som le kum thum ana lhing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Ani lhonin Abraham le achapa Ishmael chun nikhat in chep atan gel lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Chule a insunga pasal jouse, insunga pengden hihen lang gam dang mi soh dinga akichoh tho hijongleh aboncha ama toh thakhat a chep kitan tha cheh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Mamre munna gangpi phung kom'a chun Pakai chu Abraham henga ahung kilah in ahi. Nikhat hi nichangsat pettah hin Abraham chu aponbuh maiya ana touvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ama ahung dahdoh in ahile akom'a mithum ana din amun ahi. Amaho chu amu phat in ama alhai jelin amaho lemnan tol ah abohkhup in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Chuin Abraham'in “Ka Pakai,” tin adonbut in, “Nang hon pha nasah uleh phat chomkhat naki ngah thei diu ham. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Nakeng silna ding'u kahin choi kah in hiche thing limnoiya hin ana kicholdo tadiuvin. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Chule nang hon na lhacha pa hi khotona neitah a nei hungvil ngal'u ahileh na kholjin na mano masangun na tha kidona dingun naneh ding'u them khat nahin gon peh unge, ama hon aphai, nasei bang chun hin boltan atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Hichun Abraham chu aponbuh kom langa alhai jel'in Sarah kom'ah asei tan ahi, “Kinloi tah in changbong atena dim thum tedoh inlang twi toh mehnangin, chule changlhah hin kang loi temin,” aga tin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Hichun Abraham'in gancha ho kivahna lang ajonin bongnou athao pen asohte ho apen, gangtah in ahin hon sah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Anneh ding ho amin phat in Abraham'in bongnoi ha le bongnoi toh chule bongnou sa ahon uchu amaho angsung'ah aneh diuvin aga luipeh in ama hon anneh laisen ama jong thinglim a chun ading jinge. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Chuin ama hon Abraham jah a “Na loinu Sarah hoilam a um aham?” atiu leh Abraham'in ponbuh sunga aum nai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Chuin amaho lah a khat chun aseiyin, “Keima hi khovei tulai phat mama le kahung kinung lekit ding ahi, vetan hiche phat teng chule na inneipi Sarah khun chapa khat ana hin ding ahi,” ati chu anunga ponbuh sunglam a um Sarah chun angai lhin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham le Sarah chu atahsa kum lhon chu atam gel lhon tan, chule Sarah jong nao nei phat kum akhel ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Hichun Sarah guhthim in ama le ama aki nuisat in hitin aseiye, “Iti hithei ding ham, kei tobang aching sa numeijin kipana thil phalou kamu ding ham, ka jipa jeng jong akum atam lheh tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Pakaiyin Abraham jah achun aseiye, “Ipi dinga Sarah khu nuiya ka teh nunga keiman cha kanei tahbeh mong ding hinam,” ati ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Pakaiya dinga ipi ahahsa um ham? Keima khovei tulai phat na kahung kit ding chule Sarah in cha pasal khat anei ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Chuphat in Sarah chu atija tan hichun Sarah in aseilep tan, “Keima ka nuipoi” atin ahinla, “Pakaiyin adonbut in nangma na nui nai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Hichun pasal thum ho chu an aneh jouvun ading doh un Sodom lang chu agaldot un, ama hon adalha uvin, Abraham chu amaho thah doh ding tin lampi gei aga kilhonpin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Pakai chun aseiye, “Keiman katoh gon ho hi Abraham kom'a kasel ding ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ajeh chu Abraham chu lentah le nam hattah chule vannoiya nam jouse ama jeh a phatthei chang ding ahi ngal'in, ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Chule achapate le ama ban a a insung mi aman thu apeh a, chutia chu adih abol thei uva, thu adih a atan theina ding uva Pakai lampi ajui thei uva, chutengleh Pakaiyin Abraham chung chang'a akitepnasa chu ahin molso theina dinga ama hi kilheng doh ahi tila kahenan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Hichun Pakaiyin Abraham ahoulimpi in “Sodom le Gomorrah douna thu kisei asangval tan chule achonset nau jong aseval tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Keima chesuh ing kating ka henga thu hung kisei dungjuiya hi abol cheh uham, hilou ham gapho chen inge,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Hichun miho chu chukom'a kon'in akiheiyun Sodom lang chu ajonun ache tauve, ahinlah Abraham chu Pakai masanga chun ading chah den jingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham'in anailut in hitin aseiye, “Nangman michonpha atheng chule mi phalou agilouho aboncha na suhmang tha ding ham,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ijem tin khopi sunga chun michonpha som nga bang um ta le, asunga michonpha somnga ho jal'a jong chu akhomun chu khen dehlou hel'a na suhmang jeng ding ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Nang dinga hitobang thil nabol a, michonpha le migilou agoma natha cheh a, michonpha le migilou akibah ding chu bolda hel jeng le chun kati! Leiset thutan pan adih a atan louding ham?” atile. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Hichun Pakaiyin adonbut in, “Keiman mi somnga thudih thil phalou bol Sodom khopi a kamu doh thei le, amaho jal'a chu khopi ka huhdoh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Hichun Abraham'in aseikit in, “Ka Pakai nangman neiphal peh thei ding le kasei ban ho kajom nom in keima vang bohse vutvai tobang kahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ijem tin mi somli le nga tobang chonpha mitheng mi somnga sanga lhomjo namu le amaho jeh a chu khopi hi na suhmang ding ham, mi nga lhahsam jeh chun? Pakaiyin adonbut in, Keiman hiche khopi a hi mi som li le nga kamu doh jouva ahile sumang ponge,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Hichun Abraham'in adeichat angaichat avel in aseiyin, “Ijem tin mi som li bou umta le,” atin chuin Pakaiyin ahoulimpi kit in, “Keiman amaho mi somli jeh a chu ka suhmang louhel ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ka Pakai, “Lungset tah in lunghanglou jenin,” Abraham atao kit leovin, “Nei phalpeh thei lechun kasei nom na laiye, Ijemtin mi som thum muta le chun,” atile Pakaiyin ahoulimpi in “Keiman mi somthum hijongleh ka suhmang louding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Hichun Abraham'in aseikit in, “Nangman nei phalpeh thei le ka thusei hi kajom nom'e, “Ijem tin mi somni hijongleh atile,” Pakaiyin adonbut in, “Mi somni kamu jong le ka suhmang louding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham'in achaina in aseipeh tan, “Pakai, nei lunghan hihbeh inlang, khatvei neisei sah kit le tia katao ahi, mi som muta le chun” hichun Pakaiyin aseiye, “Mi som kamu doh jong le ka suhmang louding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Hichun Abraham henga athusei ding aboncha aseisoh phat in Pakai chu ache tan, Abraham vang chu a inmun lam'a ahung kile kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Hiche ni nilhah lam in vantil ni ahung lhonin ahile Lot chu Sodom khopi kelkot a anatou pet ahin Lot in vantil teni amu phat chun alamto dingin akipat doh in amani masanga tol ah abohkhup in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Chuin Lot in hitin aseiye, “Ka Pakai hung lhonin ka insunga nakeng hung kisop lhonin, chule tujan kain a geh lhon inlang, jingpi matah in thou lhon inlang na kholchena lhon aban najom thei lhon ahi,” atile, amanin “Ahipoi, hithei ponte,” ati lhonin “Keini tujan hiche mun a ong dunga geh mai lhon tange,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Hinlah Lot in aha sei behset jeh chun amani jong Lot inlanga geh din ache tauve, hichun Lot in amani neh ding chol kisolou changlhah akanpeh in amanin jong ane lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Hinlah anehjou don khojin masang chun Sodom khopi sunga khangthah, tehse, kiti jouse ahung kikhom un amaho gena in chu aum kimvel tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Amaho chun Lot henga asam tauvin “Nangma kom'a ageh dinga hung ho chu hoilam a nakoi hitam? amani chu hinpui doh in amani chutoh ka lupkhom diu ahi, tin athum tauve.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Hichun Lot chu amaho toh kihoulim din ahung potdoh in , anung lam a kot chu akhah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","“Lungset tah in sopi te ho” tin ama atao tan, “Hitobang Thil phalou hi bol hihbeh uvin.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Veuvin, keiman chanu nungah thengsel ni kaneiye. Keiman ka chanu teni hin puidoh ing ting nangho kom'a, amani chu nadei dei a nabol theiyu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Hinlah ama hon Lot chu “Kinung chen,” atiuvin, chujongleh ama hon aseiyun “Hiche pa hi ahung khopem len chule eiho thutanna pang ding akigo vehta! Tua amaho (Vantil teni), kigimbolna ding sanga nangma agilou cheh a kabol ding'u nahi,” atiuve. Hiti chun Lot chu hatah in avouvin kotpi jong chu phutjal dingin ahin go tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Hichun vantil teni chun Lot chu akhut na aman lhonin akailut lhonin insunga kot chu akhah tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Hichun vantil teni chun kotpi phunga miho chu ateh jong akhangthah jong abonchauvin amit'u achotsah lhonin ahile abonchauvin kotphung holmon akisu lungdong gam tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Phat chomkhat jouvin vantil teni chun Lot jah a hitin asei lhon e, “Hiche khopi a hi sopi ule nao adang nanei nahlai em? na chanu jipa ho hihen, na chapate hihen, na chanu ho hihen lang koi dang dang hijongleh hiche khopi sunga nangma mi poupou chu abonchauvin hiche mun a kon hin puidoh tan.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ajeh chu hiche khopi hi pumsuh mang ding kati lhon ahitai. Awgin hung kithong hi aphatmo na alen lheh tan Pakai kom ahin phatai, chujeh a chu keini hi asumang dia eihin sol lhon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Hijeh chun Lot chu apotdoh in achanu teni jipa ding teni jah a chun, “Kinloi tah in hiche khopi akon hin potdoh loi lhonin, ajeh chu Pakaiyin hiche khopi asuhmang ding ahitai,” agati leh, achanu teni jipa ding teni chun atot dan in ana gel lhon e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kho ahung vahlhah a jingkah chun vantil teni chu ahung kino lheh lhon tan, “Gang in Lot,” tin aseipeh lhon e, “Na jinu chule na chanute tutu hin puidoh in. Hikom'a kon'in potdoh un, achuti louleh nangma hiche khopi toh suhmang tha a naum ding ahiye,” ati lhon e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Lot chu akhongai nalaiyin, vantil teni chun ama khut, ajinu khut, chule achanu teni khutna aman lhonin khopi pam lam ah ajamdohpi lhonin ahi, ajeh chu Pakaiyin amaho angailut lheh jeng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Amaho khopi pam langa ahin puidoh lhon phat in Vantil teni in thu amop in “Naki hinso theina ding uvin jamdoh loiyun hung jong hung kinung hei hih uvin phaicham dunga jong kibangpa hihhel uvin, thinglhang lam'a jam doh loiyun achuti louleh nangma jong suhmanga naum tha khah ding ahi,” ati peh lhon e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Hichun Lot chun amani jah a “Ahipoi ka Pakai!” atin ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Nangman neina ngailu lheh in chule ka hinkho jong neina huhdoh in chukeo hilouvin ngailutna sangtah jong nei musah in, hinlah molsang langa kache jou louding ahiye, thinan eiphah lo ding ahi, ka hinkho kichai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Vetemin, khoneo phaicham khat muthei in aum'e, jamlutna dingin abailam in chule naicha bou ahi; kaki hinsona dingin lungset tah in hikom'a khun nei jamlut sah tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Vantil in adonbut in “Aphai tua nasei jong hi nanop peh ingting, chule keiman hiche phaicham gam'a um khopi nasei jong khu suhmang da tange. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Ahin kino gang un, jamdoh loiyun, Ajeh chu keiman ima ka bolthei louding nangma ho khulam nalhun kah seuvin,” (Hiche in avetsah ahilchet chu khopi min chu Zoar kiti ahin hiche chu ahile khomun neocha tina ahi). ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lot Zoar mun agah lhun chun jingkah nisa hungso doh jou tah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Hichun Pakaiyin vanthamjolla kon'in meikong chule hui thanei thina thei akongthei hui Sodom le Gomorrah chunga ajuh sah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Chule Pathen'in khopi teni jong, phaicham geiya akhopi teni sunga cheng jouse ahin, tolla kehdoh thingna louna abonchan asugam hel tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Hinlah Lot Inneipi chu akinung heijin anunglam agah vet leh chikhom asoh in akitung den tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Chule Abraham chu ajing jingkah matah in ache loijin Pakai angsunga adinna mun achun adingin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodom le Gomorrah lam gam chu agah vesuh in ahile, vetan agam meikhu pi chu meihol kilhut bangin akhu akitun doh jen jun jeng chu amu tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Hinlah Pathen'in Abraham taona ageldoh in hijeh chun asopipa Lot chu phaicham khopi asuhmang masang'in apuidoh in, chujouvin Lot chenna khopi teni chu a sumang tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Chuin phat chomkhat jouvin Lot le achanu tenin Zoar mun chu adalha uvin, thinglhang lam ajonun, songko sung khat a achanu teni chutoh acheng khom tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Nikhat chu Lot chanu teni alenjo nu chun anaonu kom'a hitin aseiye “Hikom gamsunga pasal gollhang aum tapoi midang ho banga ji inei lhon louding ahitai. Chuleh eihing hon ipa jong hungvoija ateh lang ahitan, cha aneilou ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Hungin ipa hi khamna thei donsah hitin, akham teng ikitimatpi lhon ding ahiye, hiche a konna chu eiho insung hi ipa a konna chilhah inei doh lhon ding ahi bouve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Hichun amanin hiche jan chun apa lengpitwi adonkham sah lhonin, chuin alenjo nu chu asunglhan apa to aga kiti mat lhon tan ahin apa chun achanu aluppet jong atho doh pet jong ahepoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ajing nikho chun alenjo nun anaonu kom'ah hitin aseiye, “Keima janlhah chun ipa to kaki timat lhon tai, tujan jong lengpitwija khamsah hitin, tujan teng nangma gache inlang gaki timatpi in hiche a konna eiho chilhah hi ipa a konna bou ikisem doh thei ding bou ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Hiche jan chun amanin apa lhon lengpitwi adonkham sah lhonin chuin aneojo nu aga sunglha kit in apa to aga kitimat kit tan, amasa a bang chun achanu aneonu ahung lup pet akithodoh pet jong ahepoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Hiche jeh chun Lot chanu tenin apa a kon'in nao ahin vop gel lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Achanu alenjo nu chun nao pasal khat ahing tan amin chu Moab asah tai, amapa chu nam khat ahung hitan tua Moab mite kiti ho hi ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Aneojo nun nao pasal khat ahing kit in, amanun achapa min chu Ben-ammi asah tai. Ama hi nam khat mipa lamkai ahung hin tua Ammon mite ho hi ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Hiche akon chun Abraham chu Negev gam langa akichon'in Kadesh le Shur kikah a phat chomkhat ana chengin, chuin Gerar lang geijin aga chengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abraham'in a inneipi Sarah chu “Ka sopinu ahi,” tin ana phongdoh in ahile Gerar lengpa Abimelech chun mi asol'in Sarah chu aga puisah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Hinlah hiche jan chun Pathen'in Abimelech amangin aki musah in hitin aseipeh e, “Nangma hi athisa nahi ahitai, ajeh chu numei na kipui hi ajinei numei ahi bouve!” ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ahin Abimelech chun amanu (Sarah), chu akitimatpi loulai ahi, hijeh chun Abimelech in “Pakai, nangin hiche imacha hechenlou nam hi na suhmang mong ding hitam? ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Hitia chu Abraham tah in jong 'Ka sopinu ahi' tia eina houlimpi hilou ham? Chule amanun jong 'Ka sopipa ahi' atia, hijeh achu keiman ka lungthim'a jong themmona beihel a chule ka khut teni jong atheng ahi bouve” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Hijeh chun Pathen'in amangin adonbut in, “Ahinai, keiman nangma hetthem louna ho chu ka henai. Hiche ho jeh achu nangma keima douna a chonset a konna kasuh khen'a chule hiche ho jeh a chu numeinu to kaki timatsah lou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tun numeinu chu a inneipu kom'a soltan, a inneipun taona na manpeh ding ahi, ajeh chu ama themgao ahi, chuteng nangma nadam kit ding ahitai. Ahin nahet ding khat chu a inneipi nanung pehdoh louleh nangma chule na mite nathi gam diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Hijeh chun Abimelech jong jingkah matah in akithou doh in chuin asoh ho jouse gangtah in akoukhom tan, chuin Abimelech in thusoh jouse chu asohte ho lah achun aseiyin tijatnan adim tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Hichun Abimelech in Abraham chu akouvin ajah a “Ipibol a hiti pia hi nei hung bol'u hitam? Itobang'a nang douna a kana chonset hitam, hitia kei le ka lenggam chunga chonset nasatah hi nahin pohlut ham? Bol louhel ding thil nangman neibol khum ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Chuin Abimelech in Abraham kom'a aseiye, “Nangin ipi nabolna ham?” ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham'in adonbut in, “Hiche mun hi Pathen ginglou mihem tamna mun ahi tin kagel in, ka loinu chu ka sopinu ahi kiti leh amanu jeh a chu eitha lou diu ham kati ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Adihtah a sei dinga ka sopinu jong ahi nai, eihing lhonpa chu khat ahin kanu lhon vang achom chom ahi. Keiman kaji din kakipui tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Pathen'in eina koudoh chun kapa insung kana dalhah chun mun khat a patna mun chom a kana vale lhon lai chun kana seiye, thil ngaichat kaneiye katin, hoilang hijongleh iche le nangho gamsunga kasopipa tin miho lah a nei phondoh ding ahi tin kana seipeh e.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Hichun Abimelech in akelcha ho le kelngoi hon ho chule abong hon chule numei pasal asoh ho chu Abraham apetai. Abimelech in a inneipi Sarah jong chu anungsol peh kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Hichun Abimelech in adonbut in, “Dah inlang vetem in kagamsung nangin nadei penna mun'a nachen thei ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Abimelech in Sarah jah a aseiye, “Ven keiman na sopipa dangka sang khat kapen, hiche sum hi na kom'a um chengse mitmu a suhkhel kihetthem tona dinga kapeh ahi, chule japi angsunga nangma boina nanei tapoi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Hichun Abraham'in Pathen kom'a taona amangin Pathen'in Abimelech asudam tan, chule a inneipi le asoh numei ho jouse naobu jouse jong cha anei theina diuvin akihong gam tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ajeh chu Abraham jinu Sarah jeh a Pakaiyin Abimelech insunga numei naobu jouse ana khatan peh ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Pakaiyin ana seisa bang chun Sarah ahung villin Sarah chunga asuh bulhit peh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Hichun Sarah in nao ahin vop in, Abraham chu atehset nungin Pathen'in ateppeh phat dontah in chapa khat ahin petan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham'in achapa chu amin Isaac asah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Chule Isaac pen jou niget alhin nin Abraham'in Pathen thupeh bangin achapa chu chep atanpeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Isaac ahung pen chun, Apa Abraham chu kum jakhat ana lhingtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Chuin Sarah in aphong doh in, “Pathen'in nuina eipei,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Chule aman, “Sarah hin cha le nao noi hin chepsah inte tin koipen in Abraham kom'a ana sei ngam dem? Ahinlah keiman atehset nungin chapa khat kahinpeh tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaac chu ahung khanglen deuvin anneh masapen Abraham'in kipanan kikhopna asem e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Hichun Sarah in jong achapa chu Egypt mi Hagar'in Abraham ahinpeh Ishmael to aki chep lhon chu amudoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Hichun amanun Abraham kom'ah hitin aseiye, “Hiche sohnu le achapa chu solmang in ajeh chu hiche chapang hin keima chapa toh chanvou anei khom lhon ding aumpoi; Isaac toh kikomto ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Hichun Abraham'in nopmo asa lheh jengin ajeh chu Ishmael jong chu achapa ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Hinlah Pathen'in Abraham chu ahoulimpi in, “Nangman chapang chung chang chule na sohnu jeh in ima lung phatmona nei hih in, Sarah in bol in atiho chu bol in ajeh chu Isaac akonna bou na chilhah te hung kisim ding bou ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Hinlah keiman Hagar chapa jong chu nam lentah khat kaso thou thou ding ahi. Ajeh chu amapa jong chu nangma chapa jong ahi thouve.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Hichun Abraham ajingin matah in akithouvin, neh ding bu asutup in chule twipohna ding twibom Hagar chu apen alengkouva aledoh peh tan ahi, hichun amanu le achapa chu asolmang in, chuin Hagar chu suhna ding helouvin Beersheba gamthip noiya avahlelei. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Hichun twi ahung bei chun amanu (Hagar) chun naosen chu hampa nangboh limnoiyah akoitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Hichun amanu (Hagar) apotdoh in atoulha tan achang seh in lamsom tobang kikah in “Keiman hiche chapang thi hi kamu nompoi,” atin amanu chu alhi alongin akaptai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Hinlah Pathen'in chapang ka awgin chu ajan chuin Pakai vantil in vanna kon'in Hagar chu ahin kouvin, “Hagar ipi boina nanei ham? Imacha kichatna nei hih in! Pathen'in aumna mun'a kon'in chapang ka awgin chu ajatai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Kipatdoh inlang nao khu gakidop loiyin nakhut in kipomchah jon, ijeh inem itile keiman ama khu nam lentah kahisah ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Hichun Pathen'in Hagar mit chu kho amusah in chua twi tamtah amusah tan, hichun amanun gangtah in twipai chu asudim in chapang chu adonsah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Chule chapang chu Pathen'in ahin umpi jingin neocha ahi apat gamthipnoi jenga ahung chengin, thalpi kap ahung them lheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Chule Ishmael chu Paran gamthip noiya ana chengin, chule anun Egypt gam'a ama ji dingin numei khat aga puipeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Hiche phat laitah chun Abimelech le asepai jalamkai Phicol chu Abraham vil din ahung'e. “Pathen'in nangma hi na umpi jingin, na thilbolna jouse ah na kithopi jinge,” tin ahung seiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Pathen min'in kitemin, chule nei joulhep louhel ding, ka chate jong ahilouleh ka chilhah ho jong, keivang nangma adia thilpha bolnom jing, chule tuhin na kihahsel ding, thilpha nabol jing ding hiche gamsunga maljin gampam nahi laisen,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abraham'in adonbut in “Heng'e kakitem e,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Hichun Abraham'in Abimelech kom'a lunglhai louna aphong doh in Abimelech sohten twikul hunam a Abraham sohte ana lahpeh u thu chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","“Tuchung hi hiche thu kajah masah pen ahi,” tin Abimelech in adonbut'e. “Keiman hiche chung chang hi koi oimo a, koi ngoh ding ham kahepoi. Ajeh chu phat masan ima thu nana sei khapoi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham'in hichun akelngoi ho, kelcha ho, chule bonghon ho Abimelech apen kinoptona anei lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Hichun Abraham'in kelngoi nou sagi ho chu achom a alhengdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimelech in Abraham chu adongin “Adang ho a konna hiche sagi ho hi ipi dia nachom khen ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham'in adonbut in, “Hiche twikhuh keiman kalaisa ahi, tia ahetoh a nei panpehna dinga hiche kelngoi sagi hi neisanpeh tei in” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Hijeh chun ama in hiche mun chun Beersheba asah tai. Ajeh chu mihem teni akihettona mun lhon ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Beersheba munna kihettona mun'a akimuto jouvin, Abimelech le Phicol sepai lamkaipa chu Philistine mun lama akinung le lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham'in Beersheba mun achun chahthing phung aphutdoh in, hiche achun aman Pathen chu tonsot Pathen ahi tin aphong doh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Hichun Abraham chu Phillistine mun'a chun phat sottah achengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Thil hijatpi kichai jouvin Pathen'in Abraham chu apatep in aman hitin aseiye, “Vo Abraham!” atile, “Hikom'a kaum'e, Pakai” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Hichun Pathen'in aseiye, “Nangailut tah na chapa changkhat seh Isaac chu puijin lang Moriah gam'a chen keiman kahin seipeh ding molsang khat pen pen chunga chu pumgo thilto maicham adin pedoh tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Chuti chun Abraham chu jingkah matah in athoudoh in a sangan teni akigon tup in chule asoh pasal ni akipuiyin achapa Isaac apuiyin, pumgo thilto govamna dingin thing akipoh in akipat doh in Pathen'in aseipehna mun chu ajontai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ani thum lhinnin Abraham chu adah in aven ahile amun chu gal'a kon'in amutai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Abraham'in asoh teni jah a aseiyin, “Nangni hikom'a hin sangan toh ana um tauvin, kei le ka chapa khulam akhun gache lhon tadinge, Pathen kaga hou lhon ding kahung kinung le vah lhon ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abraham'in thinglom maicham a pumgo thilto halna ding chu Isaac aputsah in chule achempai achoijin amani hiti chun akijot lhonin achelhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Chuin Isaac in apa Abraham jah a “Hepa” atile Abraham'in jong “Hoijo, kachapa” ati. Hichun Isaac in “Mei le thinglom la aum tan, pumgo thilto kelngoi hoiba ham?” ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham'in adonbut in “Kachapa, Pathen ama tah in kelngoi pumgo maicham a ding hin gong nante” atin hichun amani achebe lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Pathen'in Abraham aseipehna mun ahung lhun lhon phat in Abraham chun maicham khat asem in, thinglom chu agol chan ajam'in chuin achapa Isaac chu aheltum in maicham chunga alupsah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Hichun aman achem chu apaiya kon'in aladoh in, achapa chu sut agon akilam tai, ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Hinlah van'a kon'in Pakai vantil in “Abraham, Abraham” tin ahin kouvin ahile, Abraham'in “Pakai keima hikom'a kaum'e,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ama chun “Chapang pa chunga na khut nalha louhel ding, imacha jong nalo louding ahi, ajeh chu Pathen nagin jeh in nangman na chapa chang khat seh jeng jong keima adin na khut kihpoi, tihi tun kichen tah in kahedoh tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Chuin Abraham adah doh in avet leh, “Vetan anung langa nanglom lah a kelngoi chal khat akia kihen amun ahi,” hichun Abraham jong achen kelngoi chal chu aga kaiyin achapa khel chun maicham thilto chun atoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Hijeh chun Abraham'in hiche mun chu Yahweh-Yireh (Pathen'in hin ngaito nante) tin asahtai. Tuni geihin hiche “Pathen'in amolsang chung ah hin kingaito nante,” ti thuchih hi akisei jing nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Pakai vantil chun vanna kon'in Abraham tin aniveina a ahin koukit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Hitin aseiye, “Keima ka tahsa tah a kakihahsel ahitai, hitobang a thil hi nabol ngam jenga na chapa chang khat seh chunga khutkih louva napan jeng phat in, tin Pakaiyin aseiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Keiman kitah tah a phatthei kaboh ding nahi, chule na chilhahte ahsi jat ka phahsah ding chule vadung panga neldi jat ka sosah ding nahi, na chilhah ten amelma teu kelkot ahin toupha diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Chule nangman ka thusei nangai jeh a leiset chunga namtin vaipi nason na chilhah te vanga phatthei hung kiboh ding ahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Hichun Abraham asoh teni kom langa ahung kinungle in, chuin ama hon Beersheba lam ajon un, hichea chun Abraham chu Beersheba a aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Phat chomkhat jou chun Abraham chu thu aseipeh un Milcah jong hin nasopi pa Nahor to cha pasal phachompi ahing lhone. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz chu atahpen ahin, Buz hi ani channa ahin, Ram hingpa Kemuel ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Chesed ahin, Hazo ahin, Pildash ahin, Jidlaph ahin chule Bethuel ahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bethuel chun Rebekah ahing'e. Abraham sopipa Nahor chu Milcah cha hicheng get hi ana hinpeh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Hicheng val in jong athaikemnu amin Reumah kiti nu jong chun Tebah toh, Gaham toh, Tahash toh chule Maacah ana hing'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sarah chu kum jakhat le kum somni le kum sagi jen ahingin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sarah chu Kiriath-arba kiti mun'a athi tan, hichu Hebron kiti Canaan gamsunga um ahi, hichun Abraham chu Sarah umlou jeh a lunghel le mitlhi longin achup in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Hichun ajinu long adalhah ding jeh in Hit mite ho kom'a aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Keima gam chom mi kahin nangho lah a maljin bou kahi. Gambeh neo khat nei chohsah un, chuti le keiman ka jinu hi phaten kivui thei ing'e,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hit mite ho chun Abraham adonbut un, ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Ja umtah kapu thuseiyu ngaiyin, nangma Pathen a leng chapa banga keiho lah a uma keiho lhan khuh aphapen khat a khun na thilong chu vui jengin, kalah uva mihem khatcha jong hi alhankhuh na itpeh a na thilong na vuisah louding aumpoi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Hichun Abraham ading doh in agamsung mipite Hit miho chu salam bol din abohkhup tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Abraham'in aseiyin, “Nangman nei kithopi nom kahen ahithei ding le Ephron Zohar chapa kom'a nei seipeh uvin.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","“Ajeh chu agamgi chin a um ama Machpelah songlhan keo khu eipeh theiya ahile ken jong lhan mun'a kaman jing dingin nangho umpet tah hin aman alhingset in peng kate,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ephron chu mipi lah a atoupet ahin, Abraham chu adonbut in midang hon jong athusei chu aja cheh un, Hit mite ho khopi sunga um jouse jah ah hitin aseiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Hithei ponte ka Pakai,” tin Abraham chu adonbut e, “Lungset tah in ka thusei hi ngaiyin, keiman ka gamsunga adamlai, atonglai, kapeh ding nahi. Tuhin mipi ho masanga nangma kapeh ding nahi, chule nangman najinu alongdamsa navui thei ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham chu agam mipi ho masang'a abohkhup kit in, ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Hichun Abraham'in Ephron le mipi atou cheng ho jah a aseikit in, “Hithei ponte, lungset tah in ngaiyun, nangho kom'a ka choh nom lheh e, keiman gam man chu kapeh lhing nom e, ka loinu longdamsa kavui theina dingin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Hichun Ephron in Abraham adonbut in, ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","Ka Pakai lungset tah in ngaiyin hiche gam man hi dangka jali ahiye, amavang eini golcha kingailutna hi mantam ahi? Che inlang na loinu longdamsa chu gavui tan ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Hichun Abraham chun Ephron in aseijat dangka jali chu apetan, hiche lai phat na kailhang thil man dungjuijin, thil kichoh dan ho chu Hit mite lah a tehse hon amu cheh uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Abraham'in Ephron kom'a gam Machpelah kiti Mamre kom'a um chu achodoh tai. Hiche mun in ahop chu ahile atong, adam sung, chule akom'a thingphung um jouse jong ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abraham dinga chu anei agou ahitan, hichea chun Hit mite kelkot kom'a cheng hon jong ahesoh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Phat chomkhat jouvin Abraham'in ajinu Sarah long Machpelah a Mamre kom'a Hebron kiti Canaan gamsunga avuitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Aleimun le aleilaiya songlhan keo chu Hit miten alhan mun dingin Abraham achansah tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham chu akum ahung tam lheh tan Pathen'in hatah in anatohna jouse ah phatthei aboh sohkeiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Chuin Abraham'in nikhat chu asohte lah a atahpen insung vaihom pa heng ah hitin aseiye, “Nakhut chu kataigui noiya koiyin lang nakihahsel ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Chutengleh Pakai van le leiset sempa min'in kihahsel in hichu nangman kamou ding hi Canaan gamsung tua ichennau mun'a konna hi nahin puilou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Hinlah nangma che inlang keima umna lui gam ka sopiho lah a Isaac ji ding naga puipeh ding ahi ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Sohpan Abraham adonbut in “Ijemtin numeinu chu keiho toh hiche gam'a kanung hinjui ding da tale ikalo ding hitam? Ahilouleh keiman nachapa Isaac hi nangma hung kondohna gam a chu kanung puikit thei ding ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham'in adonbut in “Hoitah in gelchen inlang ka chapa vang kholam a na nungpui loubeh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Pakai van Pathen kanam mite le kapa insunga konna eipui dohpa, ka penna gam'a patna eihin puidoh pan kitepna aneiyin hitin eina seipeh e, nangma chilhah te hiche gam hi kapeh ding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Hinlah numeinu chun na hinjui nomlou le nangma keima dan kitepna a konna ongthol nahitai, thil khat chu ahile ka chapa vang khulam a nanungpui louhel ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Hichu Abraham sohpan apu Abraham taigui noiya akhut akoiyin apun ahilna thudol'a hin akihahsel tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hichun asohpa chun sangongsao som apupa Abraham kom'ah alan thil mantam ajat jat apon Mesopotamia lama Nahor khopi jon din achetai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Aman sangongsao ho chu twi veina kotong kom'a khopi pam a akichol sah in nilhah langkai ahiphat in numei ho chu twi khai dingin ahung potdoh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Chuin Abraham sohpa chun, “O Pakai, kapu Abraham Pathen, tunia nei pilhin sahna dingin na angsunga kataove, kapu Abraham dingin khoto na hin neiyin.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Vetan keima hiche twikhuh phunga hin kadinge, chule hiche khopi sunga miho chanu te twi khaiya hung ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Hiche hi kangai chat ahi. Alah uva khatpen pen chu kadoh ding, 'Lungset tah in nakhon a twi chu nei donsah in.' Amanun hitia hi ahin donbut leh, 'Heng'e, donin, chule na sangongsao ho jong keiman hin donsah ing'e!' Hiche nu chu nangman Isaac inneipi a dinga na lhendoh hi ding ahi. Hiche akon a chu keiman ichan geiya kapu chunga guitanlou ngailutna nachan ham ti kahet ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Asohpa taona achai masang'in Rebekah numei khangthah nu chun alengkouva twibel ahin pun ahung potdoh tan ahi, Amanu chu Bethuel chanu, Abraham sopipa Nahor le ajinu Milcah toh ahin lhon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebekah chu nungah mel-hoi vetnom nom a mel-hoi khat ahin, chule pasal toh jong kitimatna neikha loulai hel ahiye. Amanu chu twikhuh sunga achelut in a twibel dimset in twi aga kithal in chujouvin ahung kaldoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abraham sohpa chu Rebekah kom lama alhai in hitin aseiye, “Lungset tah in nabel a twi chu themkhat nei donsah thei ding ham,” atile, ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebekah in jong “Henge, kapu nadon thei ma ma ahi.” Chuin amanun a twi chu a lengkouva pat in ahin dom lhan Abraham sohpa chu adonsah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Chuin Rebekah in twi adonsah jou chun, ana khongai tadin “Keiman na sangongsao ho ding jong twi gadom tading'e ati, chule na sangongsao hon adon chimkah sen keiman gathal peh ing'e,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Hichun Rebekah chu gangtah in atwi poh chu gancha ho twikong sunga alheilhan, twikhuh langa chun twithal dingin a lhaijel kit in amapa sangongsao ho abonchauvin twi adon chimsah sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Chuphat in sohpan thipbeh in Rebekah umchan chu aven ama akingaiton Pakaiyin kahung kholyin lonapen hi alolhin sah ding khat hitam, hilou ham tin phot chen ding gon Rebekah um chan chu thip beh chan ave ave jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Phat chomkhat jouvin sangongsao ho jousen twi ahin donva cheh tauvin, hichun sohpan sana bilba anah a budin ahin ladoh in chule sana chaojang ni lentah akhut cheng teni a bupeh din ahin ladoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Amapan adong tan, “Nangma hi koi chanu nahim? Lungset tah in eihin donbut in, napa inmun a chu tujan kaki ngah thei diu ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Amanu'n adonbut in, “Keima hi Bethuel chanu kahi atin, kapu le kapi chu Nahor le Milcah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Henge, adih e, keihon changpol tamtah kanei jun sangongsao ho nehthei ding, chule jinlhun-in jong kanei uve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Hichun sohpa abohkhup in Pakai Pathen athangvah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“Pathen vahchoiyin umhen, kapupa Abraham Pathen” atitai. “Pakaiyin a lungsetna longlou chule phatkimna kapupa amusah tai, ajeh chu ahile imacha boina umlouvin kapu sopite kom'a eipui lhungjel tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Hichun khangthah nungahnu chu gangtah in a inlama alhaijel in ama chunga thilsoh um cheng a insung mite aga hetsah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekah chun sopi Laban aneiyin, amapa chun twikhuh lam'a chun ahung gamkon ho kimupi din ahung tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Laban chun anah a sana akiba a akhut a sana chaojang akibu chu amu tan, chuleh Rebekah in amaho chung chang thu asei chengse chu ajan, hichun ama alhaidoh pai jin twikhuh umna lama sangongsao ho nunga adin chu amun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban chun ama kom'a,“Nangho ding leh na sangongsao te ding uva mun gottup ahinung a khopam a iti nadin jeng uham? Pathen phatthei boh changho, hungin keiho kom'a hung umin” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Hichun amapa chu Laban toh insung alut tauvin, Laban chun sangongsao ho chu alham lhan changpol ho apen aki choldona diu, chuleh aneh diu jong twi jong sohpa ding, chule sangongsao hoiya pang ho dinga akeng kisop ngimna dingun apen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Hichun aneh diu an ahung kiluidoh tan ahin Abraham sohpan aseiye, “Kahungna ajeh kasei masang'in imacha kaneh nompoi.” “Aphai,” tin Laban in adonbut in, “Nei seipeh un” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","“Keima hi Abraham sohpa kahi,” tin aman aseitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Chule Pathen'in kapupa hi hatah in phatthei aboh in ama nei le gou jong ahao thei lheh tan ahi. Chule Pathen'in kelngoi hon, le sa namkim jong anei sah tan, chule sana dangka le soh numei le pasal, sangongsao tamtah jong chule sangan tamtah apetan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Chuin kapupa loinu Sarah chu akum ahung teh jou nungin, kapupa chapa pasal khat ahingin, kapupan achapa chu anei agou jouse ama apedoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Hiche a chun kapu Abraham'in eikitep sah in, Aman hitin aseiye, “Nangman hiche ka chapa hi Canaan numei ho toh na kichensah louhel ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","“Amavang kapate kom langa, ka insung mite kom lang joh a nache a ka chapa Isaac ji ding nei gapuipeh tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Hinlah keiman kapu ka donbut in “Keiman ipi kalo ding ham? Numei khangthah keima toh hung kinung le ding kamu theilou leh kati'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Aman ei donbut in, “Pakai ama umna limnoiya eiumpi pan avantil te nahin solpeh ding nakin jong thupitah a na lolhin sah ding ahi. Adih e! Hijeh a chu ka chapa aloinu ding keima insung miho lah a nahin pui tei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Hiche teng chule, keima a konna na onthol ding ahitai. Kasopi ho lah a naga che a ama hon achanu u chu nang toh hung ding anoplou ule hiche a chun nangma na themmo tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Hijeh chun tunnin, keima hilai twikhuh mun a hin kataove, O Pakai, kapupa Abraham Pathen tuchung hi kahung kigkonna kin hi lungset tah in nei lolhin sah in kati e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ven, keima hilaiya twikhuh kom'a kadin pet ahin, numei khangthah hon hiche twikhuh a twi thal a ahung teng ule hitia hi kasei ding, lungset tah in nakhon a chu twi themkhat nei donsah thei ding ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Amanun henge ati a chule keiman na sangongsao ho jouse jong twi ka donsah soh ding ahinti leh amanu chu kapupa chapa Isaac ji dingin nei petai tia kalah ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Keiman ka lungthima katao chai masang'in Rebekah in alengkouva twibel ahin pun twikhuh lam ahin jonin, hichun keiman amanu jah a hitin kaseiye, lungset tah in don ding twi neipen kati e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Hichun Rebekah in jong gangtah in a lengkouva twibel a twi aput chu ahin domlhan hitin aseitai. Henge aphai, twi nadon thei ahiye chule keiman na gancha Sangongsao ho jouse jong twi donva sah cheh nange ati, hichun ken jong ka donin, sangongsao ho jong abonchauvin twi avahva cheh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Hichun keiman ka dongin nangma hi koi chanu nahim katile aman eidonbut in, “Bethuel chanu kahin Nahor le Milcah chu kapu le kapi ahi, hichea chu keiman anah a sana bilba kaba peh a akhut teni a sana chaojang kabu peh ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Hichun keima ka kunin ka bohkhup in Pakai kavah choiye, kapupa Abraham Pathen chu, ajeh chu Pathen'in lolhing tah in eipuijin ama sopi atute kom lama achapa ji puithei ding mun'a kaum tah jeh in ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nei seipeh in, nangman kilungsetna longlou chule kingailut photchetna hi kapupa nasuh bulhit sah ding ham? Ahilouleh ipi neilo ding ham? Hiche teng chule keiman aban bolbe ding chu kigel tang kate. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Hichun Bethual le Laban in adonbut lhonin, “Pathen'in hikom'a hi nahin pui uchu kanom e keima ho imacha seibe ding kahe pouve.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekah hi kipuiyun che tauvin nadeima bangin napupa chapa inneipi din kipui tauvin, Pathen'in nahin pui ma bangin ati lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abraham sohpan hiche thu kisei ho jouse chu ajah phat chun tol'a abohkhup in Pathen athangvah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Hichun Abraham sohpan dangka sum eng chule sana khivui, pon mantam ho chu Rebekah apen, hiche tilou chun thil thupi mantam tah Laban le anu jong apen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Hichun ama hon an ane khomun Abraham sohpa le ahin lhonpi ho jouse hiche jan chun ageh un, hinlah jingkah matah in Abraham sohpan hitin aseiye, “Kapupa kom'a kinungle din neisol tauvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Amavang Laban le anun, “Rebekah chu nisom tobang umbe dingin adei lhon nalaiye. Hiche jou teng amanu chethei tante,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Ahin sohpan nei nichon sah sah tahih un, ajeh chu ka Pakaiyin kahungna kin lenpen tah hi eilolhin sah ahitai. Lungset tah in kapupa kom'a din eiki nungle sah tauvin. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ama hon aseiyun, “Aphai, Keihon Rebekah kouvung ting, aman ipi agel dong uving e” atiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Hichun ama hon Rebekah akouvun, “Amapa toh hin nache ding hitam,” tin adong uve. Chuin amanun adonbut in “Henge kache ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Hichun ama hon damsel tauvin tin Rebekah chu alhauvin, Abraham sohpa toh ahin kilhonpi hotoh asol tauvin ahi. Rebekah chu aneova patna ahin sasah nu jong asol peh thauvin amanu toh kilhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Amaho Rebekah in adalhah kon un hitin phatthei aboh un “Ka sahtah u sopinu, nangman mi asang sang hin hing inlang, na chilhah te jong hat jing'u hen. Ama hon amelma teu kelkot hinkal lhah jing'u hen,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Hichun Rebekah le asoh numei ho chu sangonsao chunga akaldoh un, Abraham sohpa nung chu ajui tauve, Hiti chun Abraham sohpan Rebekah chu apuijin ahung tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Hiche petna chu Isaac chu Beerlahai-roi apat achenna mun Negev lama ahung kinungle pettah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Nilhah khat Isaac chu avahlen atao dinga ache le pet in phailei lam agahven ahile sangongsang ho ahung chu amun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Chuin Rebekah agah khodah in ahile Isaac amu phat in sangongsao chunga kon'in ahung kumlha tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“Koiham khulanga phailei lama vahle a eiho eigal dot ukhu,” tin Rebekah in sohpa chu adongtan ahi. Chuin Abraham sohpan adonbut in “Ama khu kapupa ahi.” Hichun Rebekah in adel alan akikhu khume. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Hichun sohpan Isaac chu ima jouse thusoh ho chu aseipeh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Chuin Isaac in Rebekah chu anu Sarah ponbuh in na ahin puilut in, aman Rebekah chu aji din asang tan hatah in alungset in, amanu jallin Isaac anun adalhah jouvin alunghemna jouse jong amiltai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abraham'in ji khat aneibe kit in, amanu min chu Keturah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Amanu chun cha hicheng hi ahingin, amaho se chu Zimran ahin, Jokshan ahin, Medan ahin, Midian ahin, Ishbak ahin, chule Shuah ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jokshan chun Sheba le Dedan ahingin, Dedan chilhah ho chu ahile Asshurim ho ahin, Letushim ho ahin, chule Leummim ho jouse jong ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midian chate ho chu Ephah ahin, Epher ahin, Hannoch ahin, Abida ahin chule Eldaah amaho jouse hi Abraham cha Keturah a konna peng ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Chule Abraham'in anei jouse achapa Isaac chu apetan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Amavang Abraham'in athi masangin ajikopte cha ho jouse jong thilpeh anei sohkeiyin chule nisolam gam'a abon'un aki inchonsah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraham chu kum jakhat le kum som sagi le kum nga alhing in; ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Hichun Abraham kum sottah ahingin lolhing tah in ahinkho amangin aleiset hinkho abeitai, chuin ama apu apa amite to akivuitha tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Chule acha teni Isaac le Ishmael in apa lhon Abraham chu songlhan keova Machpelah achun avui lhon tai. Hichu Mamre kom ahin hiche mun chu Ephron chapa Zohar Hit miho kom'a kichodoh anahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Hiche gam hi Abraham'in Hit miho kom'a a inneipi Sarah kivuina dinga ana choh dohna mun chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abraham thijou chun, Pathen'in hatah in Isaac chu Negev gam'a Beerlahoi-roi mun a phatthei abohtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hiche ho hi Ishmael chilhah Abraham chapa Hagar a konna hung peng Egypt mite numei Sarah sohnu akon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Anoija ho hi Ishmael chilhah amin, anam, aphung dungjuiya kipe, apeng masa penpa Nebaioth ahin, Kedar ahin, Adbeel ahin, Mibsam ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishma ahin, Dumah ahin, Massa ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadad ahin, Tema ahin, Jetur ahin Naphish ahin chule Kedemah hicheng hi ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Hichengse hi Ishmael chapate ahiuvin, aminu jong akhotin a kisem a chuleh a ngahmun dungjuiya akilah le aphung khaijin haosa chapa cheh som le ni alhing uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Chule Ishmael chu kum jakhat le somthum le sagi ahingin, chuin ama aleiset hinkho abeitan hichun apu apate along lup nauva ama jong akicholdo tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Chule Ishmael chilhahte chun gam leiset Havilah apat Shur chan gei alodim un, hiche hi Assyria gam jotna Egypt gamto kinai Asshur a hung kipan ahi. Amaho chu asopi ule nao hotoh kivetda gunset in ana um jing uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hiche hi Isaac Abraham chapa insung chilhah thusim ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Chuin Isaac kum som li alhin in aji dingin Rebekah Paddan-aram gam'a Bethuel chanu Aramea mi Laban sopinu chu akipuiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isaac ajinu dingin Pathen heng'a ataovin ahi, ajeh chu ama chanei louva um ahi. Hichun Pathen'in Isaac taona chu asanpeh tan ahile Rebekah chu ahung kikopmo tan naosen ni ahung kijil tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Hinlah naosen teni chu anu naobu sunga ahung kiboi jing lhonin hichun amanu Pathen dong dingin achen hiche hi itidan ham? ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Pathen'in amanu ahoulimpi in, “Naobu sunga naocha teni chu nampi ni hung hi ding hiche nam teni hi abulla patna hung kitohmo peh lhon ding ahi, nam teni lah a khat hung hat intin, nacha teni lah a aupan anaopa chu ahin jenle ding ahi”. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Chuin nao neina ding phat ahung lhin chun Rebekah in naoni avop chu ahin kihet chen bep in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Chuin ahung peng masa pa chu asanin atahsa pumpi chu amulin atom in hichun ama chu Esau asah tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Phat chomkhat jou chun asopipa ahung penglha tan akhut teni achun a upa keng atuh chah kheh in, hichea chun amapa min chu Jacob asah un, ajinun amani ahinpeh pet hin Isaac chu kum som gup ana lhingtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Chapang teni chu ahung khanglen lhonin, Esau chu gamleng sakap them gam vahmi ahung hikhan, Jacob vang chu mi mong khat ahin pondal buh a um jing mi ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isaac in asadelsa hin pohlut aneh jing jeh in Esau angailun, hinlah Rebekah in Jacob chu alungset lheh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Nikhat chu Jacob in changchim ahon pet in Esau chu agamlen na a kon'in ahunglhung in, nasatah in agil akeltan atha alhasam lheh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Hijeh chun Esau in Jacob jah a hitin aseitai, “Kagil akel valtai na changchim hon salenglung chu them khat neipe tan” ati. Hijeh a chu amapa min Edom kisah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Aphai, tin Jacob in adonbut in, “Amasapen in upa nahina chu neipe doh tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau in hitin aseiye, “Keima gilkella thi dinga um kahi tan hiche mi upa chu ipi kaphat chompi ding ham?” ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Jacob in asei kit in, “Amasa pen a nakihahsel angaiye,” hichun Esau chu akihahsel tan mi upa ahina chu Jacob kom'a akijoh doh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Hichun Jacob in Esau chu changlhah toh changnoi apetan hichun aman anevan adon chimset in akithoudoh in achetai, Hichun Esau in mi upa ahina chu akijoh dohtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Chuin gamsunga chun nasatah in kel ahung lhatan, hiche kellhah chu Abraham damlaiya ahah tobangin, Isaac chu Gerar langa Philistine lengpa Abimelech heng a achetai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Chuin Pathen'in Isaac chu ahoulimpin hitin aseiye, “Keima thusei ngaiyin, Egypt langa nache thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Chule nangma hiche gam a hin gampam kholjin mi bangin um'in keiman hatah a phatthei kaboh ding nahi. Chule gam jouse hi nangma le na chilhahte jouse kapeh ding nahi, ajeh chu keiman napa Abraham kom'a kakihahselna kamolso tei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Keiman na chilhahte van chunga ahsite jat banga kapunsah ding, hiche gam ho jouse hi kapeh ding, chule nangma chilhahte a konna vannoi mijouse phatthei kaboh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Hiche ho jouse hi kabol ding ahi. Ajeh chu Abraham'in kathu angaiyin, ka thulhahna ahin, ka thupeh ahin, ka chondan thu ahin, chule ka danthu anitsoh keiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Hichun Isaac Gerar gam'a acheng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Hiche gam'a cheng miho chun Isaac jinu Rebekah chu koi ham tia adoh ule aman adonbut in, “Kasopinu ahi ati peh e,” Ajeh chu hiche miho hin Rebekah jeh hin, “Keima eitha lo get uvinte tia anagel jeh a ka sopinu ahi anati ahiye. Ajeh chu amanu amel-hoi jeh ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Hinlah ni phabep jou chun Abimelech Philistine lengpan bangkot a kon agahven ahile vetan Isaac in Rebekah aji bol'a akinoupi pet amudoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Hichun gang tah in Abimelech in Isaac chu akouvin, “Amanu chu na jinu hilou ham! Ibola amanu chu ka sopinu ahe tia nasei ham?” Isaac in adonbut in, “Ka seina ajeh chu ahile ka innneipi jeh a koi tobang khat in eitha lo ding ham kati ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimelech in aseiye, “Ipi dinga hiti pia chu neibol'u hitam? Ilouthem khat in ka mite lah a khat touvin na jinu chu ana kipui hen ana luppi kha tahen lang hileh nangma jeh a kei hon chonset lentah a neilhah sah ding'u hita chula em.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Hichun Abimelech in danpi khat asem in mipi jouse henga aphongdoh in ahi, “Koi hijongleh hiche mipa hihen ajinu hijongleh ahin tongkha asuse aum leh thina chan a gotna kipe ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Hiche kum chun Isaac in muchi akitun ahile kum dang sang'in ajat jakhat val jena tamjon aki-at e, hiti chun Pakaiyin ama phatthei ana boh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Chua kon chun Isaac chu nei le gouvin ahung haodoh tan, anei le agou hatah in apunbe cheh, apunbe cheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Hitobang chun nei le gou keu hilouvin kelngoi jong, keltah jong, bonghon jong chule soh le kol jong tamtah ahin neitan, hiche ho jeh hin Philistine miten nasatah in ahung engse tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Hichun Philistine miho chu athangthip jeh un Isaac twikhuh jouse chu abonchan asuhbing peh tauvin ahi. Hiche twikhuh ho sese hi apa Abraham adamlaiya asohten analai hou chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Chuin Abimelech in achaina in Isaac kom'a aseiye, “Nangma keiho kom'a kon'in chedoh tan ajeh chu nangma keiho sang'in natha lhing jotai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Hichun Isaac chu amaho kom'a kon'in achen Gerar phaicham ah amaho ponbuh akison uvin hiche mun achun acheng tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Chuin Isaac in Apa Abraham thi jouva Philistine mipiten ana huhbing peh u twikhuh ho sese chu alaihong kit in apa Abraham'in ana minsah twikhuh min ho chu avelsah kit in asemhoi sah kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Isaac sohten Gerar phaicham chu twikhuh alai uva ahile twisam phungkhat alaidoh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ahin Gerar gam'a kelngoi chinghon Isaac kelngoi chingho kom'a chun “Hiche twikhuh hi keiho twikhuh ahi,” atiuvin akinelpi tauvin ahi; hichun Isaac in hiche twikhuh chu “Esek” asah in hichun avetsah chu “Kiboina mun,” tina ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Hichun Isaac sohten twikhuh chom dang khat alaikit un ahile hiche mun jong chu boina ahung um kittan hichun Isaac in “Sitnah” (Tichu kitomona mun tina ahi) asah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Chuin Isaac in hiche mun chu adalhan akichon in twikhuh chom beh khat alai kit in ahile hiche mun a vang chun akinahpi tapouvin ahi, hijeh chun Isaac in hiche mun chu “Rehoboth” asah tai. “Ajeh chu tun vang Pathen'in eiho dingin gam eihon peh tauve, agamsung ahin eiho cha le naovin pungjal tau hite,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Hiche mun a pat chun Isaac chu Beersheba ah akichon kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Hiche jan lele chun Isaac henga Pathen ahung kilah in “Keima napa Abraham Pathen chu kahi. Imacha kichatna nei hihbeh in ajeh chu keiman nangma kaumpi jing nai, chule phatthei kaboh ding nahi, nason na chilhah te jong hatah a ka punsah ding amaho nam lentah kaso ding ahi. Hiche ho hi kasuh bulhing ding ahi. Ajeh chu kasohpa Abraham kom'a kana kitepnasa ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Hichun Isaac in hiche mun achun maicham asem in Pathen ahou tai, chule aman aponbuh jong asongdoh kit in asohten twikhuh khat alaikit un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Nikhat chu Abimelech jong Gerar gam'a pat na semangpa Ahuzzath chule asepai lamkai Phicol akipuiyin Isaac to kimuto dingin ahungtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac in amaho chu adongin, “Ipi dinga ka henga hung nahiuvem?, Nei vetda uva nagam uva patna nei nodoh u hitalou hamm,” anatin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ama hon adonbut un, “Keihon Pathen'in nangma na umpi hi phate chan kamu chen tauve. Hijeh chun nangho le keiho kikah a kihou cham ding kanom ui, chule ikah uva kitepna khat sem kanom uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ahithei le kihou chamna inei thei ding'u dei aum lheh e, keima hon jong nangho chunga imacha bolse pou ving'e, kei hon nangho ka ngailu jing uve. Chule lung damsel a ka soldoh joh nahiuve. Chule tun nangho Pathen'in nasatah in phatthei naboh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Hichun Isaac in kinoptona ankong nehkhomna asem in ama hon abonchauvin anekhom un adonkhom un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ajingin jingpi matah in akithouvun amaho khat khat in kitepna anei uvin, hichun Isaac in amaho chu a inlam uva asolkit tan, amaho jong lunglhai sel in akinung le tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Hiche ni ma ma chun Isaac sohten twisam thah khat alaidoh u chu thu ahung peuvin ama hon aseiyun, “Keihon twisam thah khat kamu uve,” ahung tiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Hichun Isaac in twisam thah chu Shibah asah tai (hichu kinoptona tina ahi). Hiche nia patna chu tuni gei a hi Beersheba khopi kiti ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esau chu kum somli alhin chun Hit mite numei Beeri chanu Judith le Hit mi mama Elon chanu Basemath chu ji dingin akipui jin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Amavang Esau ji teni chu Isaac le Rebekah din thohlel aum lheh jeng lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Ateh a kho amu chenlou nung hin nikhat hi Isaac in achapa alenjo pa chu akouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","“Ka chapa! Keima hi ateh kahitai, itih a thi ding kahim kasei thei tapoi, ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Hijeh chun tun nangma kigong inlang na manchah nathalpi kigot inlang gamlah a kei ding sa gakap in. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Chutengleh keiman kadu lamtah in hin hon inlang hinchoi jin keiman kaneh ding chutengleh nangma hi kahinkho abei masanga phatthei kaboh ding nahi ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Ahin Isaac le Esau kihouna chu Rebekah in guhthim chan ana ngaijin hichun Esau chu gamleng dinga akondoh phat in; ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah in Jacob jah a hitin aseiye, “Ngaijin, napa Isaac in na upa Esau hitin ahoulimpi kaja e,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Sa neiga delpeh inlang kadu lamtah in hin hon inlang hinchoijin keiman ne ingting chule Pathen masanga phatthei kaboh ding nahi, kahinkho abei masang'in,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Hijeh chun tun kachapa ka thusei hi phate chan ngaiyin ka thusei ho hi najui ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","“Nangma kelngoi hon lah a gachen lang ahoitah cheh anouni hin kaijin chutengleh keiman napa dulamtah a kahon peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Hiche teng chule nangman napa kom'a nachoi ding aman aneh a aneh jou teng phatthei naboh ding ahi, ama ahinkho adampet ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ahin Jacob in anu Rebekah adonbut in ajah a, “Vetem in ka upa Esau a tichung amulin ahin keima vounem a timullou kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","I kati ding ham? Kapa in eihin jut le ta le jou a kabol ahin hetdoh leh koi phatthei chan sanga sapsetna joh kachan joh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Hinlah anu Rebekah in adonbut in, “Sapsetna ho aum le abon'in keiman kipoh tang kate ati, chapa bol in kati ho hi nabol angaiye, che inlang kelngoi chu kahenga hin kailut loiyin ati!” ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Hichun Jacob jong achen kelngoi chu anu kom'a ahin kailut tai. Chuin anun jong apa dulam tah in ahon peh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Hichun Esau vonho lah a aphapen chu insunga kon'in agala doh in achapa aneojo pa Jacob chu avonpeh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Chule kelngoi nou teni mul chu akhut teni le angong amul bei lai achun atompeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Hichun Rebekah in sa tuitah a ahon chule changlhah ama semsa chu achapa Jacob khut a apetan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Hichun Jacob in changlhah le kelsa chu apa aga pen “Hepa” atileh aman jong “Hoiyo koipen nahim ka chapa?” ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob in adonbut in, “Keima Esau na chapa apeng masa chu kahi,” ati. “Keiman kahin subulhit tai nei ngansena chu lungset tah in kithou inlang kahin choi sa tuitah a kihon hi ne inlang phatthei neiboh tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Chuin Isaac in achapa chu adonbut in, “Iti dan ham? Man gangtah in nahin vaidoh loijen in ka chapa,” atile aman jong adonbut in “Pakai na Pathen'in gangtah a eihin lolhin sah ahi bouve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Hichun Isaac in Jacob henga, “Hung kikhin naijin katham phah theina din, nangma hi ka chapa Esau nahi mong hinam nahilou ham na jutle tem inge.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Hijeh chun Jacob in apa Isaac anailut in ahile ahin jutle tan ahi, “A awso hila Jacob awso ahin, akhut teni vang hi Esau khut ahi ngal in,” atin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Amavang Jacob ahi chu ahetchen theilou ahitai, ajeh chu Jacob khut chu a upa Esau khut tobanga mul ahijeh in hichun Isaac chun Jacob chu phatthei abohtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Isaac in adong pha kit leuvin, “Nangma hi kachapa Esau nahi mong hinam?” atile, Jacob in adonbut in “Ka hinai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Chuphat in Isaac in aseiye, “Ka henga hin domnai tan nangma phatthei kaboh theina dingin ka chapan gangtah a naga matsa nahon chu ne ing kate,” ati, chuin Jacob in ahin doppeh phat in anen chule lengpitwi jong ahin doppeh in ahile Isaac chun adon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Hichun apa Isaac chun ajah a “Eihin nailut inlang neihin bengchop tem in ka chapa,” atile, ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Jacob in anai pheijin apa chu abengchop tai, chuin Isaac kivkonna ho gimnam chu anah le len chuin achapa chu phatthei aboh in hitin aseiye, “Ah! Kachapa gimnam hi Pakai phatthei bohsa gamlah gimnam abang'e! ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Tun Pakai Pathen'in van'a kon'in daitwi na chap jing hen, leiset a leipha lailai nachan sah jing hen; chule chang le mim chule juning ninglhin sah jing hen. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Nam simsen louvin naja hen chule mihem tamtah nangma noija kun cheh hen lang, nasopi ho chunga vai hin hom jingin lang; nanu sunga peng doh pasal jouse jong na henga kun cheh uhen. Nangma na gaosapte chu gaosap chang hen, chule nangma phatthei na bohte chu phattheiboh chang hen,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isaac in Jacob phatthei aboh chai chai jin, Jacob in apa angsung agah dalhah ding kon chet in a upa Esau chu agam lenna a kon'in ahunglhung pai jeng tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Chuin Esau in jong neh ding a althet in ahonpeh in apa henga ahin doppeh in apa jah a aseitai. “Hepa, hung kithouvin lang, na hai hai pet a phatthei neiboh na dingin na chapa thasa hi hung ne o,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ahin Isaac in adonbut in, “Nang koi nahim?” Esau in adonbut in, “Na chapa apeng masa, Esau kahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Isaac hatah in ati akithing tan aseiye, “Koiham ijo langa hin dom a hunga chu? Keiman ama hin dop chu kana ne tai. Nangma hung lhun masang jep chun phatthei jong ka boh joutai; phattheina jouse jong ama achang jou tai!” ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Chuin Esau in apa thusei jouse chu angai chai sohhel phat in Esau jong ha kan akap in hatah in alunghang in apa kom'a atao kit in, “Hepa, keima jong phatthei nei boh teitei in ong,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Hinlah Isaac in aseiye, “Na sopipa ahungin eihung lhemlha tai, nang phatthei na chan ding jouse na lahpeh gamtai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau in adonbut in, “Hiche jeh a chu amin Jacob kisah hitei jinte ong? Ajeh chu aman nivei jen eilhep lhah ahitai, phat masa in ka upat hina eina lahpeh in, tun ka phatthei chan ding ana kilah doh kit e, atin hichun keiya dinga phatthei khat beh jong neina khen pehlou hitam?” atile, ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac in Esau adonbut in, “Keiman Jacob chu nangma chunga vaihom dingin kakoi tai, chule asopite jouse ama noija kun cheh diu, chule chang le mim ahin, juning ahin, haotheina jong kapeh ahitai, tua hijat nunga nangma ipi kabolpeh thei nahlai ding ham kachapa?” atitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ahi vang'in Esau in apa jah a “O hepa, phattheina khat chabeh jong umlou hitam? Phatthei neiboh teiteijin ong, hepa!” atin apengin akaptai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Chuin apa Isaac in ahoupin ajah a “Nangma leichung phalou lah lah a cheng ding nahi tan, chule van daitwi in jong hin chapkha taponte. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Nangma na chemjam a naki vah ding chule na sopipa noija na um ding ahin nangma na hung ki-ondoh teng vang leh nangong chang'a konna ama namkol chu na pailhah ding ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Hiche phat a pat a chu Esau in Jacob chu hatah a ahin vetda pan ahitai; ajeh chu apa Isaac in phattheina jouse Jacob aboh jeh ahi. Chule Esau in alungthim sunga hitin agel tan, “Kapa hin nikho jong hi sot tapon tin akichai tengleh keiman ka naopa Jacob hi katha ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ahin achapa alenjo Esau lungthim tohgon jouse chu Rebekah jah a aki seidoh khah tan ahin Rebekah in mi asol'in achapa neojopa Jacob chu aga kousah in ajah a aseipehtai, “Ngaiyin, na upa Esau khun nang thana dingin lungthim tohgon anei tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Chapa, chingthei tah in ngai jin, tun kigong inlang kasopipa Laban kom Haran langa jam tan. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Hiche mun achun ni ijat hijongleh na upa Esau lungdam kahsen ga umtan. ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ama ahung lungdam a na bolsetna ho asuhmil hel'a ahung lungdam mong mong tengleh keiman mi hinsol ing ting nahung holdoh sah nang'e. Nang ni ucha nikhat a na manthah lhon ding ka nompoi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Hichun Rebekah in Isaac kom'a aseiye, “Keiman hiche Hit mite numei ho ka theichim behseh jeng tai! Ijem tin Jacob in hiche numei ho jin ahin kipui kit ding kagel theipoi kathilo tei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Hichun Isaac in Jacob akouvin, phatthei aboh in chule athulhah in ajah a hitin aseiye, “Nangman hiche Canaan numei ho hi jia nakipui thei louhel ding ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Hijeh chun gangtah in kipatdoh inlang Padan-Ram a nanu upa Bethuel in a chen chukoma kon chun nanu sopipa Laban chanute joh ga kipui tan. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Pa Pathen'in phatthei naboh hen lang nacha nanao thalhinsah hen, napunsah hen, chule amaho chu nam lentah hung himaiyu hen. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Pathen'in nangma le na chilhahte chunga phatthei naboh uhen, napu Abraham kom'a ana kitepna ho chu tua nangma na khopemna gam jong hi nahin losoh ding ahi, ajeh chu Pathen'in Abraham ana pehsa ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Chule Isaac in Jacob chu asol mang tai, ama jong Paddan-aram langa Jacob le Esau hingnu Rebekah sopipa Laban, Aramea mi Bethuel chapa henga achetai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau in ahechen tai apa Isaac in Jacob phatthei aboh a Paddan-aram langa numei ji a gakipui dinga aphatsah a, chule phatthei aboh pet a agihsal a “Nangman hiche Canaan numei ho ji a nakipui ahi,” tia aseipeh jong aja tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Chule Jacob in apa le anu thu angaiyin Paddan-aram lam'ah achetai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Chule Esau chun Canaan numei ho chunga apa Isaac alunglhai poi ti ahechen tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Hichun Esau jong apu Ishmael henga achen Abraham chapa Ishmael chanu Nebaioth sopinu Mahalath chu aji masa teni belap dingin aga kipui ben ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Chule Jacob in Beersheba chu adalhan Haran lang ajontai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Hiti chun gamkimlai khat ahung geidon hin nisan alhumden tan, hichun ama jong jan chun chukom mun'a ageh dentai, agena mun'a songho khat chu alan lukhap in aneiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ama hiti chun alup lhah chun amanga kalbi saotah kido amun leiset apat vanthamjol geiya kidolut amun, hichun Jacob in Pakai vantil te akaltou akumsuh jingu chu amun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Chule kalbi achung langa chun Pakai adingin hitin aseiye, “Keima Pakai Pathen napu Abraham Pathen napa Isaac Pathen kahi. Tua naki choldona mun ho hi nangma leh na chilhahte kapeh doh ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Na chilhahte chu tol'a leivui ja kaphahsah ding amaho chun solam, lhumlam, sahlam, lhanglam aboncha ahin lodim soh dingu ahi, chule leiset chunga nangma le na insung mite jeh a vannoi phatthei kaboh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Itih chan hijongleh nangma kaumpi jing ding nache nachan a nikhat teng hiche gam'a hi kahin nung puilut kit ding nahi, ajeh chu kakitepna jouse kasuh bulhit masangse a donlouva kakoi louhel ding nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Hichun Jacob a imutna kon'in ahung khangdoh in hitin aseiye, “Hikom ahin Pathen aum mong'e tihi kana hetphah lou ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Hinlah ama chu tijatnan adimin hitin aseiye, “Hiche lai mun hi Pathen In ahilouleh thil dang imacha ahi tapoi; chujongleh hiche lai hi van gam kelkot phung ahi bouve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Hichun Jacob jingkah matah in athouvin alukhap song chu alan khom phun aphut in achunga chun thao twi asun khumin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Hiche mun chu Bethel asah tai (hichu “Pathen Hou-In” tina ahi), phat masalai chun Luz tin ana kihei. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Hichun Jacob in kigahna khat aneiyin, “Keima Pathen'in eiumpi jing le kakhol jinna hi kaneh ding bu chuleh sil le chen eipeh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Chule keima kapa in damsel a einung puilhung kitleh ama chu ka Pakai Pathen dihtah mong ahi tia ding det kahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Chule hiche song khomphu a ka phudoh hi Pathen houna in kiti ding ahi. Chuleh Pathen'in eipeh jouse hi hopsom a hopkhat nangma kapeh ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Hichun Jacob akhol che chu abanjom in solam mite gam chu ahunglhung tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Chuin aman agahven ahile loulaiya twisam amun akom'a chun kelngoi hon loi thum'a akol jong amun hiche gancha ho chu twikulla don ding twi ngah ahiuve, chule twisam chu songpi lentah in adal khum ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Hitia chu kelngoi hon ho abkonna ahung kisuhkim tengu leh kelngoi ching hon twikhuh kamsin songpi chu akhindoh jiuva kelngoi te twi achipsah jiuva achipva teng ule song chu akikoina ngai ngai twikhuh kam a chu ale khinlut kit jiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Chuin Jacob in amaho jah a “Sopite ho hoiya hung kon nahiu ham?” Atile ama hon adonbut un “Keiho Haran gam'a hung kon kahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Amapan adong kit in “Nahor chapa Laban chu nahet khah hih uvem?” atile “Ama hon jong kahe nauve,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Chuin Jacob in ajah uva “Ama chu dam dam a hinam?” tia adoh leh ama hon “Henge, adam jingnai; ven, tua hung kelngoihon toh hung kilhon khu achanu Rachel hija khu,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Jacob in amaho jah a “Tuhin nisa sangtah hinalaija gancha hoi khom phat bon hilou lai, kelngoi hon chu twi chipsah uvin lang gavah pha uvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ama hon adonbut un, “Gancha ho jouse ahung kikim tokah in twi kipe thei ponte atiuve, hichun kelngoi chingho chun songpi chu twisam kot apat chun atangdoh un kelngoi hon jouse twija ka vahva ding ahi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ama hon hitia akihoulim pet tah uchun Rachel chu apa kelngoi hon hotoh ahung kijot luttai, ajeh chu amanu jong kelngoi chinga pang ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Hichun Jacob in anu sopipa Laban chanu Rachel le anu sopipa Laban kelngoite amu phat in anailut in twikhuh kamsin songpi chu alihdoh in apupa kelngoi hon chu twi achip sah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Hichun Jacob in Rachel chu abeng chop in awging tah in akap e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Jacob in Rachel jah a apa sopinu Rebekah chapa ahi thusim aseipeh tan ahile Rachel chu achen apa aga hetsah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban in Jacob asopinu chapa ahung lhun ahet chun akimupin akoijin achop jengin chuin a inlama ahin puilut tai. Hichun Jacob in ima jouse thusim ho chu aseipeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Chuin Laban in Jacob henga aseiye, “Nangma hi kagu ka chang chule kaphe kavou mong nahi,” ati. Hichun Jacob chu apu Laban kom'a lhakhat sung aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban in Jacob henga aseiye, “Nangma hi ka insungmi nahi vang'in mohseh a tohman beiya naum ding chu adih theipoi, natoh man ipi hi ding ham nei seipeh temin tin adong tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban in chanu ni aneiyin, alenjo nu min chu Leah ahin, chule aneojo nu min chu Rachel ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Ahin Leah mit chu aleng thimin amavang Rachel chu amel-hoi jin, amaiso jong lungset aum lheh jenge. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Jacob in Rachel chu hatah a adeichat jeh in hitin aseiye, “Na chanu neojo nu Rachel khu kaji dia neipeh ding leh keiman kum sagi nana tong ing kate,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban in adonbut in, “Hithei nante,” ati. “Ajeh chu keiman midang ho kapeh sanga nangma kapeh ding chu thilphajo ahi bouve, Hijeh chun keima kom'a um jingtan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Hichun Jacob in kum sagi sungin Rachel man toh kitoh dingin na atong tan, hinlah Jacob in Rachel angailut behset jeh chun ni chomcha toh abahsah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Chujouvin Jacob in Laban jah a hitin aseiye, “Keiman ka kitepna ho jouse ka subulhit tai, kajinu tun neipe tan kaluppi nom tai,” tin ahung thum tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Hichun Laban in jet le veija cheng ule nao jouse akou khom sohkeiyin kichenna golvah chu aboltai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Hinlah hiche jan ahung thim phat chun Laban in Leah chu Jacob kom'a aga that lutpeh tan, Jacob in hichenu chu alupkhompi tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laban in asohnu Zilpah jong chu Leah kithopi a pang dingin apehtha tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ahin jingkah matah in Jacob ahung kitho leh Leah joh anahin, Jacob in Laban jah a aseiyin, “Ipi iti a hitia hi neibol hitam? Kum sagi nangma noiya na kana toh chu Rachel man dinga katoh hilou ham! “Ibol a nei jou lhep ham?” tin aseiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban in adonbut in “Keiho chondan a a unu umpet a hi anaonu jinei doh theilou ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","“Hiche hapta khat sung hin jinei dan hi subulhit tadin, hiche teng chule Rachel jong kapeh ding nahi, ahin nangman kum sagi ma kana natoh kit ding ahi” ati peh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Chuin Jacob in Leah chu hapta khat lhingin akichenpin hiche jou chun Laban in Rachel jong ajinu dingin apetai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban'in asohnu, Bilhah jong chu achanu Rachel jenle a pang dingin apehtha tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Hichun Jacob in Rachel jong alupkhompi tan, aman Rachel chu Leah sang'in hatah in adeijon, hichun Jacob in kum sagi ma Laban na atongkit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ahin Pathen'in Leah kihot bol chu amudoh tan, hijeh chun anaobu ahondoh peh in, amavang Rachel chu achiingin chanei louvin aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah vang chu achung agih tan; chapa khat ahingin amin Reuben asah tai, Ijeh inem itile, “Pathen'in kagimna ho eihetpeh tai, hiche jeh a hi kajipan eilungset ding ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Chuin aman nao avop kit in chapa khat ahing kittai, ajeh chu “Keima eikihot bol hi Pakaiyin ajah doh phat a chapa hiche jong hi eipeh kit ahiye” atin hijeh chun amin Simeon asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Hichun Leah achung gih in, nao avop kittan amanun hitin aseiye, “Tu apat a hi kajipa toh thakhat tipum khat kahi lhon ding ahitai, ajeh chu keiman cha pasal thum kahinpeh tai hichun naosen chu amin chu Levi asah tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Chujouvin Leah in nao avop kit in chapa khat ahingin, “Tuchunga vang Pakai ka thangvahna ding ahi,” atin hijeh chun amin Judah asah tai, chujou apat in vang cha abang tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Hichun Rachel'in Jacob cha ahinpeh lou akihetchet phat in asopinu athangset pin, hijeh chun Jacob kom'a atao tan, “Keijong cha le nao nei hinpeh in achuti louleh keima thi ding kanom jotai!” atin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob chu Rachel chunga alunghang jah jengin, “Keima Pathen kahipoi Ama ahi chanei louva nakoi, na naobu khah tan achu!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Hichun Rachel in adonbut in, “Kasohnu, Bilhah hi, galup khompi tan, chutile amanun nao eihinpeh intin chua konna chu keiman jong ka chilhah insung kaki semdoh thei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Rachel in Bilhah, asohnu chu, Jacob ji din apetai chuin Jacob in Bilhah chu akitimatpi tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah in nao ahinvop in Jacob dingin chapa khat ahinpeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Hichun Rachel in aseiye, “Pathen'in ka lunggel eisuh bulhitpeh tai! Chule kataona jong eisanpeh in chapa eipe tai” atin hijeh chun naosen min chu Dan asahtai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Chuin Rachel sohnu Bilhah chun nao avopkit in Jacob chapa anina ahinpeh kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Hichun Rachel'in, “Keiman ka sopinu toh hatah a kaki set delna lhon a keiman kajou tai!” atin hichun naosen min chu Naphtali asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Leah in nao aneikit tah louding ahin kihetdoh phat in asohnu Zilpah chu jidin apetai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Hijeh chun Leah sohnu Zilpah chun Jacob dingin chapa khat ahinpeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Hichun Leah in hitin aseiye, “Hamphat aum bouve,” atin naosen min chu “Gad” asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Hichun Leah sohnu Zilpah chun Jacob chapa anina chu ahinpeh kit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah chun aseiye, “Keiya din iti thanop um hitam! Tua hi numei dang jousen hatah a eikipapi diu ahitai,” atin hiche naosen min chu Asher asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Nikhat Reuben chu suhlou chang vohlai in akondoh in ahile loulai achun *Joldei-Ai amun anu Leah ahin pohpeh in ahile, hichun Rachel in Leah kom'a “Lungset tah in na chapa Joldei-Ai hinpoh chu kei jong nei hom thei ding ham,” tin athum tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Hinlah Leah in Rachel jah a “Ka inneipu nei lahpeh jong thil neocha a nabol ham? Tua jong kachapa Joldei-Ai hinpoh jong lahpeh ding neigot kit ham?” atileh Rachel in adonbut in, “Chuti ahile na chapa Joldei-Ai poh man dingin tujan Jacob in nangma na lupkhompi thei nante,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Hiche nilhah chun Jacob phailei lama konna ahung kinungle phat in Leah achen aga kimupin, “Tujan hi keima toh ilupkhom ding ahi, ajeh chu tujan a dinga ka chapan nao neitheina ahinpoh a tujana dinga ka choh nahitai,” hichun Jacob chu hiche jan chun Leah to ageh lhontai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Pathen'in Leah taona chu asanpeh tan, nao ahin voptan Jacob chapa nga lhinna ahinpeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Hichun Leah in asei tan, “Ka sohnu chu kajipa ka pehdoh jeh in Pathen'in ka chohdoh man eipetai,” atin hichun naosen min chu Issachar asah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Chujouvin jong Leah chun nao avop kit in Jacob dingin chapa gup lhinna ahinpeh kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Hichun Leah in asei tan, “Pathen'in keima numei thilken phatah tah eikenpeh tai, tu apat a kajipan ngailutna sangtah einei ding ahitai, ajeh chu chapa gup kaneipeh tai,” hichun amanun naosen min chu Zebulun asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ahin phat chomkhat jouvin nao numei khat ahingin amin chu Dinah asah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Hichun Pathen'in Rachel chu asumil pon Pathen'in ataona asanpeh in anaobu chu ahonpeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Hijeh chun Rachel in jong nao ahin vop in chapa khat ahin neitai; hichun Rachel in hitin aseiye, “Pathen'in ka jachatna jouse asubei tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Rachel'in anao min chu Joseph asah in hitin aseiye, “Pakaiyin chapa dang khat jong eihin sah kit teitei hen o!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Rachel in Joseph ahin neijou phat chun, Jacob in Laban kom'a aseitai, “Nei nungsol tan kagam lang uva,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kajite kachate neipe dohtan phat sottah nangma in'ah lhachan kapang tan, tua hi keima ki nungle phat ahung hitai, chule itobanga nangma na katohpeh nahim nangman nakihet nai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Ahin Laban in Jacob jah a aseiye, “Ahithei ding leh lungset tah in nei dalha hih in ajeh chu nangma ka insunga na hunglut apat in Pathen'in phatthei eiboh lheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Chule Jacob in aseijin, “Natoh man ding ijat ham nei seipeh tan keiman kapeh ding nahi” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Chuin Jacob in adonbut in, “Nangman nahenai, itobanga nangma na katoh a na gancha ho hung pung thei ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","“Ajeh chu keima kahung masang chun themcha bou na neijin tun apung jal tan, Pathen'in hatah in phatthei na boh tan ahi. Ahile itih phat hi ding ham? Keima insunga ding katohna ding,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Chule Laban in adong kit in, “Ipiba kapeh ding ham?” Jacob in aseiye, “Imacha neipe hih in, ahin thil khat nei bolpeh le chun keiman nagancha na vettup peh nang'e ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Tun keiman na gancha kelngoi ho gakhol sohkei jing ting, amaho lah achun apol jouse hin lhengdoh inting, chule keltah ho lah a jong apol thim hihen hapol apol jouse hin lheng doh ingting, hichengse chu keima natoh man in nei bolpeh tan, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Khonung teng ka natoh man sutoh dinga nahung teng ka kitahna nahin muchen theina dingin, kelchate lah a apollou hihen, hapol a pollou akimu doh khah a, kelngoi lah a jong apollou khattou aum khah a ahile hiche ho se chu nangma a konna kaguh a kisim jeng thei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Hichun Laban in adonbut in, “Apha lheh jeng'e nangman nasei bang chu himai tahen,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Hinlah Laban in hiche nikho ma ma chun kelcha achal asandup apol, chule abeh beh a kang kelcha anu apol ho, chule kelngoi avom ho jouse chu achapa kom'a abon'in agathah doh sah sohkei in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Hichun aman Jacob to nithum jen lampi a kigamlat in asolmang tai, chule Jacob in Laban gancha akithah lou jouse chu aching jom jing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Chuin Jacob in Almond le Shiga phung bah ho chu amalngim in hiche thingbah avel akang lai ho chu kelcha ho amusah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Hichun Jacob in thingbah amalngim ho chu kelngoi ho twi dkonna konga akoiyin, kelngoite twichip dinga ahungji teng ule kijangmatji ahijeh uva akoi ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Kelngoi ho chu thingbah akang lai masanga chu kijangmatji, chuteng chule kelngoite chun akangpol jong, hapol a pol jong ahin hing doh doh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Jacob in kelngoi ho chu ahoikhen in Laban kelngoi hon lah a akangpol ho leh avom ho chu ahoikhen in ama chan ding chengse chu atum in akhendoh in, Laban a lah achun ahoilut tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Hiti chun kelngoi lah a asapha ho chu akijangmat teng ule thingbah ho amu uva, akijangmat theina ding uvin Jacob in jong thingbah ho amasang uva twi lkonna kom laiya aga jampeh jin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Hinlah Jacob in kelngoi atahsa phalou ho ahi tengleh aga jamle jipoi, ajeh chu Laban a chu asapha lou jeng ahin, Jacob a vang chu asapha jeng ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Hijeh chun Jacob chu ahung hao thei lheh tan, kelngoi tamtah ahin neitan, soh numei ahin soh pasal ahin tamtah aneiyin, chule sangan le sangangsao jong tamtah anei doh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Jacob in Laban chapate ama chung'a alung damlou u thu ajatan ama hon aseiyun, “Jacob in ipau thil jouse akilah tan, chule anei agou athilkeo jouse khu ipauva konna akilamdoh ahi,” ati tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Chujongleh Jacob in Laban maiso aven ahile alung lhailou lungthim chom agel jong ahe chen tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Hichun Pathen'in Jacob chu ahoulimpin, “Nangma kinungle kit tan, napu napa chule na sopite chenna gam'a keiman kaumpi jing ding nahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Hichun Jacob in mi asol in loulam a akelngoi chin nauva Rachel le Leah aga kousah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Chuin Jacob in hitin aseiye, “Keiman ka hechen tai, napa lhon maiso kavet le lungthim chom chom aneitai, masang tobang ahi tapoi, hijongleh kapu kapate Pathen'in eiumpi jingnai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Nangnin jong nahe lhon nai, katha neisun kajo chan a napa lhon ding natoh katonge. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Hinlah aman eijou lhep tan, kanatoh man jong somvei tobang eikhel pehtai, amavang Pathen'in keima chunga vang thil phalou imacha alhunsah pon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Aman hitin aseiye, 'gancha apol ho jouse chu nangma nikho thaman hitante' atile gancha ho chu apol jeng hatah in ahung pung tul tul kit tan, hichun aman alunggel akhel kit in 'gancha availang jenga pol ho' atikit leh gancha anou jouse chu adung le avai langa pol bou apeng kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Hitia hi Pa Pathen'in napa gancha ho jouse alah a keima eipehsoh ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Chuin phat chomkhat jou kelngoite kijangmat laijin jan mang khat kaneiyin, ka khodah in ahile kelpi chunga kaldoh kelchal ho chu apol ho leh adup ho aki timatpiu kamui. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Chuin hitia mang kanei pet in Pakai vantil khat in eihin houpin 'Jacob!' eihin tin kenjong 'Hoijo hikom'a kaum'e,' kati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","“Chuin Pakai vantil chun, 'Dah inlang gahve temin, kelpi ho chunga kaldoh kelchal ho khu apol, adup, akangpol, availanga pol jengin amat e, ijeh inem itile Laban in na bolsetna jouse keiman abonchan ka musoh keitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Keima na Pathen Bethel mun'a song khom thao nanu a na kigahna Pathen chu kahi, tun kipatdoh in hiche gam hi dalhan lang na penna gam langa kile kit tan.'” ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Chuphat in Rachel le Leah in adonbut in, “Keinin imacha boina kanei lhonpoi; kapa lhon nei le gou chanvou ka chan lhon ding um beh ham?” ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Aman dalpam mi a eigel lhon hilou ham? Ajeh chu aman eijoh doh lhon in keini kichohna sum jouse jong eisuh mang peh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Chule nei le gou jouse Pathen'in kapa lhona kon a alahmang peh ho jouse chu eiho le ichate ho a ahi bouve. Hijeh chun tun Pathen'in najah a asei jouse chu ipi hijongleh bol jengin,” ati lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Hichun Jacob akipat doh in ajite le achate jouse chu Sangan chunga atoudoh sah sohkei tan; ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","chule aganchaho jouse amasang lam uva ahoiyin Paddan-aram gam'a anei agou jouse aki suhtup in Canaan gam'a apa Isaac henga che dingin aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Chuin Laban chu kelngoi mulvou dinga akondoh phat in Rachel in apa insung'a semthu pathen chu ana kiguh mang tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob in jong Aramea mipa Laban chu alhem lhan, ajamdoh dingu jong aseipeh pon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Hichun Jacob in anei agou jouse akipoh in Eupharate vadung apal galkai in Gilead thing lhang lam ahin jontai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ahin nithum jouvin Jacob ajammang tai tithu chu Laban ahin seipeh un; ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Chuin Laban in asopi ho cheng akou khom in, Jacob chu ahin nung del tauvin ahile, nisagi lhin ni chun Gilead lhang gamsunga ahin juilut tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Hinlah Pathen'in Laban Syrea mipa chu janin ana kimupin hitin aseiye, “Kichih theijin Jacob chu imacha nalo theilou ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Hichun Laban'in Jacob chu ahin phatan, chule Jacob in thinglhang lah a chun aponbuh akison tauvin, chuin Laban le a-u anaoten jong Gelead thinglhang a Jacob to kigamlat louvin aponbuh u akison tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Chuin Laban in Jacob jah a aseiye, “Ibola hitobanga hi neijou lhep hitam ati, chule iti dana ka chanu teni jong gal a sohchang ho banga nabol jeng ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ibola guhthim cha a najam mang uham? Ibol'a neijou lhep ham ati, chule nache ding iti dan a nei hetsah loubeh ham? Neina hetsah le chun thupitah a kilhahna ankong le la ngaitah tah kisan tin, tumging to kithoa kivailhah tadinga ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Na thilbol ho hi ngolna in na dimset e, ka chanu teni cha katute jong kabeng chop man tapon, kilhahna jong kana bol thei tapoi! ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Tua hi nangma ka suhbei thei nahi, hinlah napu napate Pathen'in janhi nilhah in eina kimuto pin gihna jong eineiyin Jacob chu na suhboi theilou ding ahi eiti! ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Nangma lunggel na inlam a nache ding na thanopna chu ka hethem lheh e, kham thei jong nahipoi, napa insung miho toh kimuto kal na ngalel jong kahe nai, hinlah ibola ka pathen houna doiphung chu naguh ham? ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob in adonbut in, “Keiman nangma kana ging lheh in ahi, ajeh chu nangman, nachanu teho chu hunam a nei lahpeh ding ham tia kana gel ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Amavang na doibom vang chu ahile nangman hol inlang na mudoh thei leh namuna mi chu koi hile ahinkho subei jeng tan ati, chule nangma thil ho jong keima sopiho ana lakha aum leh kanung peh ding nahi; Jacob in vang Rachel in ana lah chu ana hetlou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban chu doibom hol in Jacob ponbuh a ache masapen in , aban'in Leah kom'ah, hiche jou chun Leah soh teni kom'ah achen, hinlah imacha amudoh pon, achaina in Rachel ponbuh a alut in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rachel in apa insung doibom chu ana ladoh in Sangan pho kah a chu ana sel'a chule achunga chu ama ana tou ahi, hichun Laban in ponbuh sung aning akah aphet vang'in imacha amudoh tapon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Amanun apa kom'a aseitai, “Lungsettah in nei ngaidam in ka pakai keima numei hina lhinna kaneijin kadin theilou ding ahi,” Laban vang ahol chu atang dehpon amavang insung doibom chu amudoh pon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Hichun Jacob hatah in ahung lunghang tan Laban'in apupa jah a asei tan ahi, “Keima ipi ka guchatna ka jkonna umham?” atitan, “Chule ipi mong kabol khel a hichan geiya hi kanung neihin del a keima migucha banga nei bol hitam? ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nangman kanei kathil koina jouse aning akah geiyin naphet in, tun nang thil nakimudoh ho chu neivet sah un, sopi ule nao ho masang laitah ahin hin podoh in, ama hon eini kahlah a thutanna nei mai uhen!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Nangma kom'a kum som ni na gancha ho kana vettup peh in, na gancha ho kelngoi ahin na kelcha ho ahin imacha boina ana umpon hiche kum hijat kana vettup sunga chun kelngoi khat jong kana kilah khapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Keiman gamsa in, gancha ho athasa jong kahin polut khapon, athi amang ho jong keima nikhotha toh suhto din kana boljin, gancha ho sun hileh jan hileh amang ho jouse chu keima lhalo toh suhto din nei kahpeh jin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Hiche hi keima dinmun anahi. Hitipi chun sun teng nisan eihalvampai gon, jan tengleh dap kathoh jin, kamit tenin la imutna him him amupha pon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Hitobanga chu kum somni nangma insunga kana kimanchah ahi. Keiman kum som le kum li nangma insunga lhacha in kana pangin, na chanu teni lona in kum gup kana tohbe in gancha ho lona in chule kana toh man somvei tobang nei khelpeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kapate Pathen, Abraham Pathen, kapa Isaac ginpa chun eipanpi lou hile tua hi nangman khut keohel tahbah a neina solmang ding ahitai. Pathen'in ka gentheina le kakhut tah a ka tohgimna hi amua jan nilhah a chu na gihsal ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Hichun Laban in hitin Jacob adonbut in, “Hiche numei ho hi ka chanu ahin, hiche chapang ho jong katute ahi, chule gancha ho jouse jong abkonna keima gancha ahi. Chule ipi hitale namu phah chan hi aboncha keiya jeng ahi cheh nai. Amavang keiman tua hi ka chanute chule achate ho chunga ipi kabol ding hitam? ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Hijeh chun hungin eini kikah a kitepna nei hite hichun eini eikan khom cheh lhon ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Hichun Jacob in hetjingna dingin song khom khat aphutdoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Hichun Jacob in asopi ho lah a aseiyin, “Songho hin chom khom un,” ati, ama hon song chu khat chunga khat asethop un, hichun Jacob le Laban song kise thop kom'a atou lhonin kitepna ankong chu anekhom lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Songlhuh kise chu Laban in Jegar-sahadutha asah in (hichu Aramaic paova “hettohsah songthop” tina ahin), hiche ma ma chu Jacob in Galeed asah e (hichu Hebrew paova “hettohsah songthop” tina ahi). ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Hichun Laban in, “Tuni nikhoa hiche song lhuh hi kei le nang kah a sakhia panga ahitai,” tia, hiche jeh chun amin jong Galeed asah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Hiche mun jong hi Mizpah akiti tai, aman aseiyin, “Ajeh chu nangma le keima jong khonung teng jongleh gamla tah a umjongleh hen Pathen'in eiumpi jing lhon hen.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Ka chanute ho nahin suh gentheija numei dang ho jia nahin kipuiya ahile, koima chan muhih jongleh abonchan Pathen'in amusoh keiye, Pathen hi nang le kei kikah a kitepna a hiche thua hi pang jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Hiche song athopma kise ho hi Jacob in Laban jah ah, “Vejingin kei le nang kah a kihet themna hijing ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Hiche song kise thop hile songphu hi sakhi a pang ahin, ken jong nangma suse dinga hiche hi kahin khokhel louhel ding, nangin jong keima suse dinga hiche hi nahin khokhel louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Abraham Pathen, Nahor Pathen chule amani Pa Pathen chu eini kah a thutan ding ahitai,” ati. Hijeh chun Jacob jong apa Isaac ginpa minin akihahsel tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hichun Jacob in hiche molchunga chun Pathen henga maicham asem in kitepna ki hetthemna ankong jong asem in, anneh anei jou uchun hiche jan machun molchunga chun ageh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laban ajing chun matah in athoudoh in achanute ho le atute ho jouse abonchan achop sohkeiyin, chule abonchauvin phatthei aboh sohkeiyin, hichun ama a inlam ma aki nungle kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob chu akhol jinna amachal jingin, chule Pakai vantil ten ana lamto uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jacob in amaho amu chun hitin aseyin, “Hilai mun hi Pathen kicholdona mun ahi!” ati. Hiche mun chu Mahanaim asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Hichun Jacob in Edom gamsunga Seir gamkaiya a upa Esau henga dingin thupo dingin mi asol masan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Aman hitin athumop in, “Kapu Esau kom'a hitia hi nasei ding ahi: 'Na sohpa Jacob in hitin aseiye, tuni gei hin Laban kom'a kaum jing nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Keiman gancha bong hon ahin, sangan hon ahin, kelngoi hon ahin, kelcha hon ahin, soh le kol jong tamtah kanei tai. Tua ka pakai pa masanga kahung tao ahi hichu nangma mitmua ngailut kachan theina ding tia nangma seipeh dinga mi kahinsol ahiye ati, tin gasei tauvin,'” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Thu hettohsah ho ahung kinungle chun, Jacob kom'a hitin aseiyun, “Nasopi pa kaki mutopi uvin, tua hi ama nang toh kimuto dingin mi jali toh ahung kondoh in ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ahin Jacob chu hiche thu ajah chun akicha lheh tan, hichun aman a insung mite ahin, gancha kelngoi ho jouse ahin, keltah ho se chule sangongsao hose ahin hopnin ahom khenin ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jacob in hitin agel lin, “Esau vin honkhat chu ahung bulu tah jongleh honkhat pa beh asohcha theiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Hichun Jacob ataovin, “Vo kapu Abraham Pathen, kapa Isaac Pathen, O ka Pakai, 'Nangin na sopite leh nagam lang uva kinungle kit tan' tin nei seipeh in chuleh 'Keiman nang dingin aphat phat nan bolpeh nange' tin kitepna naneiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Nasohpa nei musah longlou ngailutna ho le nakitahna ho chu chang din lhinna imacha kaneipoi. Ajeh chu ka tenggol keoseh puma hiche Jordan hi hung galkaiya kahin, tun mihem loini lhingset ka lamdoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","O Pakai, lungset tah in ka sopipa Esau khut a kon'in nei huhhing teiyin, keima kati aja lheh jeng'e; ajeh chu aman kajite ho chule ka chate ho jong eihung nokhum ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Hinlah nangman, nang dingin aphat phat nan bolpeh nange, na chilhah te jeng jong twikhanglen panga neldi jat hin phantin, tam behseh jenga kisim jou louding ahi,’ tin nana kitep e,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Jacob chu hiche mun'a chun ajan geh in athil poh ho lah achun alhengdoh in asopipa Esau peh dingin: ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","kelpi jani, kelchal somni, kelngoipi jani chule kelngoi chal somni toh, ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","sangongsao pi somthum toh anoute se toh, bongpi somli toh, bongchal som toh, sanganpi somni toh, chule sangan chal som toh alheng doh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Hichun Jacob in hiche gancha ho chu hopni in ahom in amaho vekol ding chun soh khat cheh anganse in, hichun asoh ho jah a hitin aseiye, “Nang hon hiche gancha hotoh hin keima masanglam a che tauvin. Hinlah gancha hon teni kikah a chun mun ong umsah un,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Hichun ama hon lamkaipa jah achun hitin aseiye, “Ka sopipa Esau to nakimuto lhon teng aman thu nahin doh teng, 'Nangho hi hoilam jon ding nahiuvem? Chule nangho koi gam mi nahiu ham? Tua gancha ho ahung masa ho chu koiya ham?' ahin ti tengleh, ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Hiche teng chule hitia hi amaho na donbut dingu ahi, 'Hiche gancha ho se hi na sohpa Jacob a ahi, amaho hi kipa thilpeh adia kapu Esau a dinga kahin poh ahiye. Chule ama jong kanung lam uvah ahung e,'” tiuvin ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Hiti chun Jacob in soh masa pa athuhil bang chun anina pa ahin, athumna pa geiyin gancha ho vetup lamkai jouse chu aseipeh cheh tan, “Esau toh nakimuto tengu le na thusei hou chu kibang cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","'Chujongleh vetan na sohpa Jacob jong keiho nunga ahung'e, tia na seipeh ding'u ahi,'” atin ahi. Ijeh inem itile Jacob gel a chu, “Ka masanga kitol thilpeh chengse hin ama jol lungdam thei khat ingting, ajou teng amai kamu thei ding ahi; ijem atile bon eina sang jeng khat inte,” tia angaito ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Jacob in ngailut thilpeh ho chu ache masang'in asol tan ahi, amavang hiche mun achun ajan geh in akhovah dentai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Hiche jan chun Jacob in aji teni chule asoh teni chule achate pasal som le khat chu athoudoh tan Jabbok Vadung chu agalkaipi tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Hichun Jacob in amaho chutoh vadung agalkai phat chun anei agou jouse toh asol tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Hichun Jacob chu achangin adalha tauvin, pasal khat in ama chu khovah geiyin akibotpin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Pasal akibotpi pa chun ajo louding phat chun Jacob konggu homlai tah chu asuhboh pehtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Hichun mipa chun aseijin, “Nei lhatan kho hungvah ding ahitai!” Amavang Jacob in adonbut in, “Phatthei neiboh tokah a nangma kalha louding nahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Mipa chun adongin, “Na min ipi ham?” ati, hichun aman adonbut in, “Jacob ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Mipa chun, “Na min hi Jacob hitalou ding, tua patna Israel kiti ding nahitai. Ajeh chu nangma Pathen toh na kibot in jong nahat in, mihemte jong na hinjo ding ahi,” atipeh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Jacob in adongin, “Lungset tah in namin nei seipeh in,” ati, mipa chun adonbut in, “Ibola kamin chu nahet nom ham,” ati. Hichun aman Jacob chu hilai mun a chun phatthei abohtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Hichun Jacob in hiche mun chu Peniel (hichu “Pathen mai” tina ahi) asahtai, “Ajeh chu keiman Pathen kaki maitopi tan chule ka hinkho jong eihuhdoh peh in ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Jacob in Peniel adalhah chun nisa ahung sohdoh tan ahi, ajeh chu akonggu anat jeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","(Hiche jeh chun tuni geihin Israel chaten akonggu to kijopmatna khelgu hom sunga thapigui hi anepouve; ipi jeh inem itile aman Jacob konggu hom sunga thapigui ana hebal peh in ahi.) ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Hichun Jacob akhodah in avet a ahile Esau chu mihem jali jen to ahung amutai. Chuin Jacob in jong achate chu Leah le Rachel chule asoh numei teni ahop peh sohkeiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Hichun asoh numei le achate ho jouse amasat sah in, abanin Leah le achate achesah in, chule achaina in Rachel le Joseph apansah e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Chuin Jacob ama mong mong amaho jouse masanga chun achen, aupa heng ahin phah tokahsen sagi vei jen tol'a abohkhup in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Hichun Esau alhai pheijin apumkoi jengin, chule angong koiya achop a ahile ani lhonin akika lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Hichun Esau in numei ho chule achate ho chu aven adongin, “Amaho hi koi hiuva ham,” ati. Jacob in adonbut in, “Hiche chapang ho hi Pathen'in na sohpa phatthei eibohna ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Hichun soh numei teni le achate hon ahin nailut un Esau masanga chun abohkhup tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Leah le achate jong ahin nailut uvin abohkhup in asalam uve; chule anukhah penin Joseph le Rachel ahung nailut lhonin abohkhup lhonin salam abol lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esau in adong tan, “Ahile hiche kahin kitopi gancha honpi chu ipi nabolna ham?” ati. Jacob in adonbut in, “Nangma masang'a lunglhaina kamuna tei ding kati ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esau in adonbut in, “Kanao, keiman jong tamtah kanei nai” atin, “Nangma thil chu nang dingin kikoi tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ahin Jacob in asei teiyin, “Ahipoi, nangman hiche kipa thilpeh ho hi nalah louva hitheilou ahi, keiman nangma mai kamu hi Pathen mai mu tobang kahi, nangma mai kamu theiya nanui awgin kajah hi thina a konna galkai kahitai! ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Lungset tah in hiche thilpeh ho hi nei sanpeh teiyin, Pathen'in ka ngaichat jouse eipetai.” Hichun Jacob in ahasei behset jeh chun Esau chun thilpeh ho chu asang tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esau in, “Aphai,” “Keiman na lamkai jing ting eini che tahite.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Jacob in adonbut in, “Ka pakai, neihet them peh mai jin, chate ho hi alhasam thei lheh na laiyun, gancha bongnou ho leh kelnou ho jong ahonpi toh ki khen thei lou lai ahiuvin, nikhat sunga hatah in kihoi pai taleh gancha honte aboncha thigam jeng thei ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Hijeh chun lungset tah in, na sohpa masanga kapu ana masa jengin lang keiman olcha chan ka masanga gancha ho ki kalvan bang ule chapang te kikalvan bang bangu hin, Seir gam'a kapu heng kahin phah kahsen hung nange, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Apha lheh jenge tin Esau in adonbut in, “Hinlah ka mite ho themkhat tou dalhang kating nangho lamhil ding chule boina le hahsatna a pan lathei ding.” ati, Jacob in adonbut in, “Hiche ho chu ngai ponte, lungset umtah a kapun neina lamdot hi alhingset in ka sange!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Hichun Esau chu akinung heijin Seir gam jon ding chun hiche ni mama chun achekit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Jacob vang chu ahile Succoth lama achen hiche mun'a chun inlim gancha ho din asong in, chule ama chenna dingin jong in aki sahtai. Hiche jeh a chu hiche mun chu Succoth (tichu chenna mun tina ahi) kiti ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Phat chomkhat jouvin Jacob chu Paddan-aram lammah kon'in Shechem Canaan gam ahunglhung tan, hiche khopi phah masanga chun ngahmun khat asem kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jacob in Shechem pa Hamor chate khut a kon chun gam leiset phabep sum jakhat in akichoh in hikom'a chun ponbuh akison tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Hichun aman maicham atungdoh in amin chu *El-Elohe-Israel asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Jacob le Leah chanu Dinah chu nikhat apotdoh in hiche gam'a cheng numei khangthah hotoh kimuto din achen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ahin hiche gam’a Hiv mi leng Homar chapa Shechem kitipa chun Dinah chu aman in aluppi tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ahin amapa chun ahin ngailu lheh tan, hichun aman thudihtah a kihoulimpi a nopsah ding chu adei lheh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shechem in apa Homar jah a asei tan, hiche numeinu hi neipuipeh un kaji din kadeiye ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Phat chomkhat jouvin, Jacob in thusoh aja tan Shechem in Dinah aluppia asuhset chu ahetan, ahin Jacob in achate gamlah a gancha ho ching ahijeh u chun amaho ahung lhun angah in kamcheng khat jeng cha jong akehpoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamor Shechem pa chu Jacob henga kihoulim dingin achedoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Chuin Jacob chate loulam a kon'in ahunglhung tauvin ama hon hiche thu ho ajah uchun alung nommo lheh un kidang jong asa lheh uvin hatah in alunghang uvin, asopinu Dinah Shechem in asuhset a Jacob insung asuhboi chu bollou ding khat ahiye atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamor in Jacob le achate akihoulimpin, aman aseiye, “Kachapa Shechem in na chanu alungset lheh jengin ahi, lungset tah in amani chu kichensah uhite. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ahithei ding leh eiho chate kila tou hite, keihon nangho chanu ho kipui uvingting, keima ho chanute ho jong nangho chapate ho din kipui un ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Hiche gamsunga hi ichenkhom theiyu ahi, chule khosa uvin bolthei toh thei tongun, nanop chanu nei le gou jong na kilam theiyu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shechem chu Dinah sopiho le apa jah a ataotan, “Lungset tah in nei khotouvin, ahithei ding le kaji din kakipui nom e chule nang hon na thum chan uchu keiman kapeh ding nahiuve.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Numei nu chu kaji dinga nei peh pou ule keiman ipi thilpeh hijongleh suhto thei ding alen aneo hileh kapeh ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Hinlah Shechem in Dinah ana luppi a asuhset tah jeh chun Jacob chate chun Hamor le achapa Shechem chu lungphalou tah in ahoulimpi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ama hon adonbut un, “Hiche hi keima ho moh nop lhah thei kahi pouve, ajeh chu nangho hi chep tanlou nahiuvin, ka sopinu u nang hon nakipui dingu chu keiho dinga jachat umtah khat hung hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Hinlah kihoucham theina khat vang aum'e, hichu ahileh na pasal ho jouse achep natan thei diu le atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Hiche teng chule ka chanu te ho'u kapeh theiyu, chule nangho chanu ho jong keima hon jong kakipui thei dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ahin nangho pasal hon acheptan ding anoplou ule ka sopinu'u kapeh theilou dingu ahi, atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Hamor le achapa Shechem chun amaho thilgon chu pha asa lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shechem chu alunglhai lheh in bol ding ho chu ageisang tapon, ajeh chu Jacob chanu Dinah adei behset jeh chun Shechem chu amaho insung milah a jathei umdol tah khat ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Chuin Hamor le achapa Shechem khopi kelkot a ahung lhonin mipi ho lah a akihou nau kinoptona ho chu ahung phong doh lhonin hitin asei lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Amanin aphongdoh lhonin hiche miho hi mipha eiho mi ahi ati lhon e, veuvin gam jong lentah inei uvin amaho chenna thei ding, amaho toh chengkhom uhitin, bolthei thei bol uhitin, eihon jong amaho chanute ijon thei ding'u chule ama hon jong eiho chanute akichenpi thei dingu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Amaho toh eiho ichen khom theina diuvin thil khat aum'e, hichu ahileh eiho pasal jouse amaho banga chep ikitan tengu le ichen khom thei ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Hinlah thilpha khat ihet dingu chu ichen khom tengu le agancha hou, anei agou hou jouse aboncha a eiho a hung hithei ahi. Hijeh chun ama hon adei atup hou chu bolpeh leuhen amaho jong eiho lah a chen ding thanom tah a hung cheng diu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hichun khopi sunga cheng aching athem jouse Hamor le achapa Shechem thupeh chu anom cheh tauvin, chule pasal jousen achep akitan sohhel tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ahin nithum jou don chun amaho chep tanna maha jong damtheng loulai in Jacob chateni Simon le Levi asopinu Dinah toh pengkhom teni chu ahung kon lhonin hiche khopi sunga pasal jouse chemjam in asatlih lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hiche athi ho lah achun Hamor le achapa Shechem jong ajao lhon tai, hichun Dinah chu Shechem in mun'a kon'in amaho inlam a ahinpui lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Phat chomkhat jouvin Jacob chate ho ahunglhung cheh tauvin, ama hon khopi sunga mipi athi amang akithat ho chu asopinu u kisuhthangna khopi chu achom theng hel uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ama hon akelngoi hou ahin, abongchal hou chule asangan hou jouse phaicham khopi sung le tollhang a thil keo jouse akilah tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Anei agou jouse jong alahpeh sohkeiyun, amaho jite chate jong alahpeh un, amaho hetkhah nalouva apuimang tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Jacob in phat chomkhat jouvin Simon le Levi kom'a hitin aseiye, “Keima hi nei suhmang lhon ahitai! Hiche gam mite le Canaan mite le Periz mite kom'a hin kanamse in kaui lheh tai. chule eiho lhomcha ihiuvin amaho ahung kihoutoh tengule eiho eisuh mang dingu ahi. Keima kahin ka insung pumpi ka kichaihel ding ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ama hon lunghang tah in aseiyun, “Ipi bol'a chu isopinu u chu numei kijoh banga abolset ham?” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hichun Pathen'in Jacob ahoulimpin, “Kithouvin lang Bethel lama kinungle kit inlang hikom'a chun gacheng tan, chule na upa Esau kom'a nahung jampet a nahenga hung kilah Pathen ding chun hikom'a chun maicham khat gasem in,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Chuin Jacob in a insung mite ahin midang akom'a cheng ho jah a hitin aseiye, “Doiphung jouse paimang un, natahsa kisuhthengun, vonthah kivonun, ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Tua eiho Bethel lama iche diu Pathen henga maicham kasem ding ahi. Ajeh chu Pakaiyin ka hahsat laitah a kataona eisanpeh in, Aman kachena ka lamjotna jousea eiumpi jinge ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Hichun ama hon gamdang mite indoi akoi jouseu chule abil uva abilba u abonchan Jacob apeuvin ahile Jacob in abonchan Shechem nai vel'a thingphunglen noi khat ah aga vuimang tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Amaho ahung kondoh uchun Pathen a konna tijatna mipi adimun, hijeh chun Jacob insung mite bulu din koimacha ahung kondoh ngam tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob le a insung mite Luz kiti (Bethel tia jong kihe) Cannan gamsung alhungun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Chule hikom'a chun Jacob in maicham khat asem in, hiche lai mun chu El-bethel asah in ahi (hichu “Bethel Pathen” tina ahi). Ajeh chu aupa henga konna ahung jamdoh a chu hikom'a chu Pathen ama mong mong ahenga hung kiphong ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rebekah jenle nu Deborah athi a chu Bethel noiya gangpi phungnoi khat ah ana kivui ahin, hiche jeh a chu hiche min chu Allon-bacuth kisah ahiye (hichu “Lhilkonna gangpi phung” tina ahi). ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Hichun Pathen'in Jacob Paddan-aram a konna ahung chun ana kimutopi kit in, chuin Bethel mun'a Pathen'in phatthei abohkit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Pathen'in ahoulimpin ajah a, “Namin hi Jacob ahin tunia patna hi nangma Jacob na kiti talou ding ahi. Amavang Israel kiti ding nahitai,” hichun Pathen'in ama pa min chu Israel asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Hichun Pathen'in aseiye, “Keima El-Shaddai kahi. Pathen hattah kahi, hatah in ga un, hatah in pung tultul un, nam lentah kaso ding nahi, chule chilhah jong tamtah kapeh ding nahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Chule khatvei Abraham, Isaac kapeh gam chu nangma le na insung mite kapeh kit ding nahi, khonung teng jongleh nangma kapeh ding nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Hichun Pakai vantil chu Jacob akihoulimpi na a kon'in achemang tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob in Pakai to akimuto melchihna dingin hiche mun'a chun songkhom khat aphutdoh kit in, hiche khom chunga chun kilhaina ju asun khumin, chule hiche chunga chun Olive thao twi asun khume. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Chule Jacob in hilai mun chu Bethel (hichu “Pathen In” tina) asah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Jacob le a insung miten Bethel chu adalhauvin, Ephrath lam ajot laitah un Rachel chu anaovop nat ahung kipan tan, akhol chenau jong lhung joujep loulai ahiuvinn, amanu soh dingin hanat in ahung natai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Rachel chu soh dinga hanat a anat pet chun anaodom a pang asoh numei ho chun hitin ahoulimpi uve, “Nangma kicha hih in, lungneo hihbeh in, chapa khat na neibe ding ahi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Hinlah Rachel chu alhagao apotdoh tai, ajeh chu amanu athia ahitan ahi; hijeh chun aman jong nao min chu Ben-oni asah in (Ben-oni tichu ka thoh gimpet a kacha tina ahi), apan vang Benjamin asah tai. (Benjamin tichu, kajet lama pang chapa tina ahi). ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Rachel chu athitan Ephrath (hichu Bethleham) lampia avui tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Jacob in angailut hetjing nan Rachel lhan song asempeh in, tuni gei hin hiche Rachel lhan hi aum jing nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Hichun Jacob chu achen pondal buh chu Migdal-eder inting vum geiyin atung doh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ama chuche gamsunga achen laiyin Reuben in apa thaikemnu Bilhah chu ana luppin, hiche thu chu gangtah Jacob in ana jan ahi. Hiche ho hi Jacob chapa som le ni ho min chu ahi: ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Leah chapate chu Reuben (Jacob chapa apeng masa pen), Simeon, Levi, Judah, Issachar chule Zebulun ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Rachel chapa teni chu Joseph le Benjamin ahi lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Rachel sohnu Bilhah chapa teni chu Dan le Naphtali ahi lhonin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Leah sohnu Zilpah chapa teni chu Gad le Asher ahi lhone. Hichengse hi Jacob in Paddan-aram gamsunga ahindoh achapa te chu ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Hichun Jacob apa Isaac kom'a ahung kinungle kit tan Mamre a Kiriath-arba gam (Hebron tia jong kisei) phat khat laiya Abraham le Isaac maljinna ana umna'u mun chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isaac chu akum kum jakhat le somget ana lhing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Hichun Isaac ahaitan in teh kembet in ahinkho ana lhan, akhangguiya chemasa ho toh thinan akigom tai. Chuin achapa teni, Esau le Jacob in avui lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hiche hose hi Esau phunggui ahi (Edom tia jong kisei) . ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau in Canaan nungah ni aji din ana kipuijin khat nu chu Hit mi Elon chanu Adah ahi, anina nu chu ahile Anah chanu Oholibamah ahin Hiv mi Zibeon dinga atunu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Chule Esau in asopinu Basemath jong jidin akipuiyin, Ishmael dia achanu, Nebaioth dia anaonu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adah chun Esau din chapa Eliphaz ahinpeh in, Basemath chun chapa Reul ahingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibamath chun Canaan gam'a achen laiyin chapa thum Esau din ana hinpeh in, amaho min chu ahile Jeush, Jalam, chule Korah ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esau in ajite le achate cheng abonchauvin, agancha ho jouse, abongchal ho jouse, chule anei agou thil jouse Canaan gam'a achen laiya alamdoh jouse toh mun chom ajon tan, asopipa Jacob chu adalha tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Ijeh inem itile anei agou lhon, agancha lhon chuleh adinmun lhon jeh chun aumkhom lhon theina dia gam chu ninglhing joulou ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Hijeh chun Esau (Edom) chu thinglhang lam a Seir kiti mun'a acheng tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Hiche hi Esau chilhah Seir thinglhang gam’a cheng Edom mite chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Hiche ho hi Esau chapate min ahi: Eliphaz kitipa hi Esau loinu Adah in ahin, chule Reul kitipa hi Esau loinu Basemath in ahin ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Eliphaz chilhah ho Teman, Zepho, Gatam chule Kenaz ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna, Eliphaz thaikemnu chapa khat ahingin amin chu Amalek ahi. Amaho se hi Esau jinu Adah in ahin ama hung kikhailha chilhah ho ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Reul chapate ho chu Nahath, Zerah, Shammah chule Mizzah ahi. Amaho se hi Esau jinu Basemath chilhah ho ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esau chate ho Oholibamah in ahin ho chu, Jeush, Jalam, chule Korah ahiuvin, Oholibamah hi Anah chanu Zibeon dinga atute ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Hiche ho hi Esau chate chilhahte phung choma hung lamkai ho ahiuve, Esau chapa tahpen chilhah ho Eliphaz a hung kikhai lha ho, Teman, Omar, Zepho, Kenaz ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Korah, Gatam chule Amalek amaho se hi Eliphaz phung lamkai Edom gamsunga cheng ahiuve. Amaho jouse hi Esau jinu Adah chilhah a konna hung peng doh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Esau chapa Reul a konna hung pengdoh phung lamkai ho chu, Nahath, Zerah, Shammah chule Mizzah ahiuve. Amaho cheng hi phung lamkai Edom gamsunga Reuel chate ahi. Hiche ho jouse hi Esau jinu Basemath chilhah a konna hung peng doh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Esau chate ho Oholibamah toh ahin ho Jeush, Jalam chule Korah ahiuve. Amaho se hi phung lamkai cheh jong ahung hitauvin, hiche phung lamkai ho sese hi Esau loinu Oholibamah kitinu Anah chanu chilhah a hung kon doh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Hiche phung ho hi Esau a konna hung kondoh (Edom mi a jong kiheu) phung lamkai hon ahetpeh ho chu ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Hor mi Seir kitipa chilhah chengse Edom gam'a ana cheng ho chu amaho hi ahiuve: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishon, Ezer, chule Dishan ahi. Amaho hi Edom gam'a cheng Hor mi Seir chilhah a phung lamkaiho chu ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan chilhah ho chu Hori le Hemam ahi. Lotan sopinu min chu Timna ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shobal chilhah ho chu Alvan ahin, Manahath ahin, Ebal ahin, Shepho ahin, chule Onam ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon chilhah chu Aiah le Anah ahi lhon'e. (Anah kitipa hin apa gancha sangante achin pet a gamthip lah a twisamputna ana mudoh ahi). ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah chilhah chu achapa Dishon le achanu Oholibamah ahi lhone. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishon chilhah ho chu Hemdan, Eshban, Ithran chule Keran ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer chilhah ho chu Bilhan ahin, Zaavan ahin, chule Akan ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan chilhah chu Uz le Aran ahi lhone. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hor mite upa lamkai ho chu Lotan ahin, Shobal ahin, Zibeon ahin, Anah ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer chule Dishan ahiuvin aphungmin uhi phung lamkaiho min dungjuiya kisah Seir gamsunga cheng ho chu ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Hiche lengho hi Israel mite lah a lengvaipo ana um masanga Edom gamsunga lengvaipo ho chu ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beor chapa Bela chun Edom gamsunga lengvai anapon, ama khopi chu amin Dinhabah ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela athi jou chun Zerah chapa Jobab chapa chu Bozrah gamsunga vaipon ahung pangin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Jobab athi jou chun Teman mi Husham mipa chun lengvai ahin hom kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husham thi jou chun Bedad chapa Hadah chun lengvai ahinpon, ama chenna khopi Avith a pat in Moab gamsunga Midian ho jouse gal'a ahin joutan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad thi jou chun Masrekah khopi a cheng Samlah in apanmun ahinlo kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlah thi jou chun vadung a um Rehoboth khopi a cheng Shaul chun apanmun alon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaul thi jou chun Achor chapa Baal-hannan kitipa chun lengvai ahipo kit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Acbor chapa Baal-hannan thijou chun Hadar in Pau khopi apat in lengvai ahipo pantan, Hadar jinu min chu Mehetabel ahin Matred chanu Me-zahab dinga atunu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Amaho phung lamkai jouse hi Esau chilhah a konna hung kondoh cheh ahiuvin, Timna gam'a cheng ahiuvin, mi upa Alvah ahin, mi upa Jetheth ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Mi upa Oholibamah ahin, mi upa Elah ahin, mi upa Pinon ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Mi upa Kenaz ahin, mi upa Teman ahin, mi upa Mibzar ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Mi upa Magdiel ahin, chule mi upa Iram ahi; hicheng hi leiset atoupha na gamsung uva akho mun dung jui uva Edom chilhah a kon a mi upaho chu ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Hichun Jacob Canaan chu apa khopemna Canaan gamsunga anung chen kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Hiche thusim ho hi Jacob insung mite a ahi, Joseph kum som le sagi alhinin apa kelngoi ho asopi ho toh achingtup jingin avahva jingun, asopi ho apa jithah chate ho Bilhah le Zilpah chate ho toh natong khom jing ahiuve. Ahin nikhat chu Joseph in asopiho umchan phatlou dan apa kom ahin lhut tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Amavang asopi te hon Joseph chu avetda cheh un ahi, ajeh chu apan midang ho sanga Joseph angailutna jeh in ama hon Joseph henga ngailut thucheng thupha seiding hahsa asa lheh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Joseph in nikhat mang aneiyin amang chu asopiho aseipeh le ama hon avetda cheh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Aman aseiye, “Ngaijun ka mang ho kasei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","“Ehon lou lama changphel ikan khom un, hiche tah chun hetman louvin keima changphal ho chu ading doh in, nangho changphal ho chu keima changphal masanga abohkhup uve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Hichun asopi hon adonbut un, “Amapa chun keiho chunga vaihom ding kigong nahim? Ahilouleh keiho chunga thanei ding kigo mong nahim,” atiuve. Hichun ama hon amang nei toh athusei doh ho jeh in hatah in avetda uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Joseph in mang khat aneibe kit in chuin asopi ho chu aseipeh kit in aman aseiye, “Ngaijun mang khat kaneibe kit e,” ati. “Nisa, lha, chule ahsi som le khat ho jong keima masanga abohkhup cheh uve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Tua mang aneipa hi Joseph in apa chule asopi teho jouse jong abonchan aseipeh sohkeiyin ahi. “Hiche mang chu ipi tina ham?” tin adongin, “Nanu toh kei chule nasopi te ho jouse atahbeh a kahung uva nang masanga kahung bohkhup dingu ham?” tin apan aphoh thip e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Amavang Joseph sopiho chu alunghang lheh un athangthip thei lheh un, apa vang chun hiche mang chu ipi tina ham tin alungdong lheh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Phat chomkhat jou chun Joseph sopiho chu Schechem lama apa kelngoi ching dingin achekit tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Amaho chedoh jou phat chomkhat jouvin, Jacob in Joseph kom'a aseiye, “Nasopi te hon Schechem lam a kelngoi hon ho aga vah un ahin, nangma naga chelou khoh ahi atin, Joseph in adonbut in, “Keima kaga che ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Jacob in adonbut in, “Nangma gache inlang na sopi te ho chule kelngoi ho iti hinauvem gaven ati. Amaho thusoh kajah nom kitne, Hebron phaicham apat in asol tan, hichun Joseph hiche Schechem chu ahunglhung tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ahin vetan gamlah a lampi akimansah a avakoile na a mi khat in atoh khan mipa chun adongin “Ipi ham nahol le?” atile. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph in adonbut in, “Ka sopi te ho kahol ahi atin, hoi langa gancha ho achin uham nei seipeh thei ding ham,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mipa chun adonbut in, “Amaho kihoulimna kajan eiho Dothan lama chetau hite,” akitiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Joseph ahung chun asopi hon gamla thimtah ahivangin ahepai tauvin, ama ahung lhun masang'in asopi te hon Joseph thadohna ding tohgon anei tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Tuhin mang neipa ahung tai,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","“Hungun ama hi that doh taute, chule hiche kotong ho sung khat a paimang utin ipau kom'a hitin seiyu hite, “Gancha khat in Joseph chu a nedoh tai, chule eihon veu hite ama amang ho chu hunggui lhung nam,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ahin Reuben in amaho tohgon lungthim ho chu ahet phat in Joseph kithopi dingin ahungin, “Aman aseitai Joseph hi tha datau hite,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ibola thisan imoh lonsah ding'u ham? Hilai kotong gamgo lah a seplut leuhen ama chamin eihon that hih jong leuhen ama thi talou ding ham. Reuben chun alungthima Joseph chu huhdoh tei ding tichu ama dei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Hichun Joseph ahung lhun chun asopi te hon a sangkhol chol hoitah chu asut lhah peh pai tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Hichun ama hon Joseph chu aman uvin kotong sunga aseplut tauvin, hiche kotong chu imacha umlou twi jong veilou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Chule amaho anne dinga aum laitah un, aga dadoh uva ahile vetan Gilead a konna hung sumkol veile Ishmael miho a sangan ho toh hung kilhona bego le thingthao namtui toh chule lou namtui hinpoa Egypt gam lang jonsuh ding amu uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Hichun Judah in a sopiho jah a aseiyin, “Isopi pau itha doh uva ipi apha chom ding um ham? Chule athisan iselmang uva chu ipi phachom ding ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Hung uvin Joseph hi Ishmael te kom'a johdoh tau hite, isopi nah nah iphe ivou nah nah chu achunga jong ikhut lhapou hite,” atile asopi ten jong asei angai cheh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Hiti chun Egypt gam'a kivei miho chun apui tauvin Joseph chu asopi hon kotong a kon'in a kaidoh un, Ishmael miho Midian miho kom'a dangka somni in akijoh doh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Phat chomkhat jouvin, Reuben chu kokhuh langa chun achekit in ahile Joseph chu kokhuh sunga ana um tapoi, hichun Reuben chu alung akham lheh jengtan asangkhol ho chu abottel in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Hichun Reuben asopiho lah a akinungle kit in lungkham tah in, “Joseph chu aum tapoi! tua hi keiman ipi kabol ding hitam?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Hichun Joseph sopihon kelnou khat athat uvin, athisan chu Joseph sangkhol a chun anu tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ama hon hichu sangkhol thisan anu uchu apau Jacob athot un, mihon jong apau henga achoi uvin, “Hiche pihi ka mudoh uve, vetemin na chapa sangkhol chol hilou ham?” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacob in gangtah in ahedoh paijin, hitin aseitai, “Hiche hi kachapa sangkhol ahi monge gamsa khat in vang anehdoh ahitai, Joseph vang hi aphe avou lahthei hita ponte,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Hichun Jacob in apon ho chu abottel in khaodip pon akikhu khum tan, Aman nisottah lunghemin genthei tah in achapa pul adoutan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Jacob chate jouse le achanute jousen lhepbi ding agong un, ahin amavang lhepbi jou ahi tapoi, hitin amapan aseiye, “Keiman lunghem pum in kachapa lhankhuh jon tang kate,” tin Jacob chu akap e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Phat chomkhat jou chun Midian miho chun Joseph chu Potiphar kitipa Pharaoh Egypt lengpa Semang Pachong pa kom'a ajoh doh tauve. Potiphar natoh chu ahile sepai lah a semang pachong ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Hiche phat laitah chun Judah chun asopite adalhan Adullam kiti mun'a Hirah kitipa toh ana cheng khom lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Chule Judah in Canaan numei Shua chanu chu akichenpin chule ana kitimatpi tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Amanu chu ahung kivopmon chapa ahin neitan chule nao min chu Er asahtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Chuin amanu akivopmo kit in chapa khat ahin hinbe kit in nao min chu Onan asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Abanin amanun chapa athum lhinna pa chu amin Shelah asah in, Shelah pen laitah a chu amaho Kezib kiti mun'a achen laitah u ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Phat chomkhat jouvin, Judah in achapa atahpen Er dingin numei khangthah amin Tamar chu ajidin apuipeh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Hinlah Er chu migilou miphamo tah ahijeh chun Pakaiyin ahinkho aladoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Hichun Judah in Onan kitipa, Er sopipa kom'a hitin aseiye, “Nangma che inlang Tamar khu gaki chenpi tan, ajeh chu pasal khat insunga ahinkho abeitah le dan in aphal ahi, asopipan avet thei ding, na sopipa dinga chilhah na semdoh peh tei ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Amavang Onan kitipa chu anompon ama chilhah ahilou ding chu, hijeh chun asopipa ji toh alupkhom lhona akitimat teng abotwi ho chu tollhanga abolha jin, hijeh chun Tamar chun nao avop thei tapon asopipa adin jong chilhah gou aumdoh jou tapon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Amavang Pakaiyin Onan umchan chu gilou engse asa lheh in asopipa athisa adin chapa ahin peh nomlou athangthip jeh ahi, hijeh chun Pakaiyin Onan hinkho jong asuh chom pehtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Hichun Judah in Tamar amounu jah a hitin aseiye, “Kachapa Shelah kikhanlhit kah in napa in'a meithaijin ga umdoh tan,” ati. Ijeh-inem itile asopi teni bangin ama jong thiget inte tia ana gel ahi. Hijeh chun Tamar jong achen apa innah aga chengtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Phat chomkhat jouvin Judah jinu jong athi tai; ahin Judah chu akilhep lungmong dom phat in agolpa Adullam mi Hirah chutoh Timnah a akelngoi mul vouho henga aga che tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Koiham khat in Tamar chu aseipeh in, “Ven natehpu khu Timnah a kelngoi mul vou dingin ache touve,” atipeh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Chuphat in amanun jong ameithai von chu akhel loijin, ponlu akikhun, akitomjol in Timnah lampia Enaim lamkot a chun atou tai; ijeh-inem itile Shelah kikhanlhit ahitan, aji dinga amanu akipeh lou akimu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Judah in amanu chu amun ahin amanun amai asel jeh chu numei kijoh ho ahisah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Hichun ama akingapa in amounu ahilam chu helouvin amanu chu ajollin, “Keiman nangma kitimatpi inge” ati. Hichun Tamar in “Kei nei kitimatpi ding leh ipi ijat neipeh ding ham?” atileh, ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","“Keima kelchanou lah a khat nahin thah peh nang'e,” tin kitepna aneiyin ahi. Hichun amanun adongin, “Kelchanou nahin pehtei ding kihetna a ipi kitepna neipeh ding ham,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judah in adongin, “Itobang kitepna nadei ham?” ati. Amanun adonbut in, “Na Mohor le nakhao toh chule nakhut a nachoi na tenggol chutoh,” ati. Hijeh chun amapan hichengse chu apen amanu chu aluppin ahile aman jong nao avop tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Phat chomkhat jouvin, Tamar a in lama a kinungle kit in a sangkhol chol akoi lhan masanga akivkonna lui meithai sangkhol chu akivon in til a bang chun hinkho amang kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah chun kelchanou chu aloipa Adullam mipa khut a numeinu henga khamgahna thil lhatdoh dinga aga thahsah a ahile, Adullam mipan amanu chu agaholmo tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Hichun Adullam mipa Hirah in hikom'a cheng ho chu adongin, “Enaim jotna a tou numeinu aki johnu chu hoilam a che hitam, ama hon adonbut un, “Keima hon hikom'a hin numei phalou atahsa joh kamu kha pouve,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Hichun Adullam mipa Hirah ahung kinunglen thu umchan ho chu Judah aseipeh tan ahi, “Keiman amanu umna chu kahol doh jou tapoi, chule chua cheng mihon jong hitobang numei phalou atahsa joh aumpoi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah in aseiye, “Thil kana pehho chu amanun eina koipeh mai tahen, kaki nopto nalhon dungjuijin kelchanou khat kapen ahin nangman na holmo tan, amanu chu inung hol kit le khosunga mijousen ei nuisat ding'u ahitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Lhathum jou don chun Judah chu mihon aseipeh tauvin, “Tamar na mounu chu numei kijoh banga ana bol thu ahije, chule tuhin amanun nao avoptai,” atiuve.” Hichun Judah in aseiye, “Amanu chu hinpui doh unlang halvam tauvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Amavang ama hon Tamar chu tha dingin ahin puidoh tauvin, Tamar in atehpu thu athot in hitin aseiye, “Hiche thil neipa tenggol ahin, khaodip ahin, Mahor ahin, koi thil pen ham? Ipi dinga thip beh cha uma ham hiche neipa akonna hi nao kavop ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Judah in gangtah in ama nei le gou chu amu mun ageldoh paitan ahi, “Tamar hi keima sanga chonpha jo ahiye ati. Ajeh chu keiman kachapa Shelah toh akichen lhon na ding imacha kana gonlou jeh ahi,” ati, chupet tah chun Judah chu Tamar toh apum kitimat tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tamar dinga nao neina phat ahung naitan, amanun nao pasal ni pengkop ding ahi chu ahe tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Naoso nat akipan tan hiche pet tah chun naocha teni lah a khatpa akhut ahung doh in hichun numei lhacha a pangho chun patsan akhut a akanpeh un, “Hiche pa hi hung peng masa ahi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Hinlah hiche naocha chun akhut akailut kit tan, asopipa joh ahung peng masa tai. Hichun numei lhacha ho chun “Hiche hi ipi ham atiuve.” Nangin iti dan'a amasa a peng dingpa nahin chop khup ham atiuve.” Hichun amapa min chu Perez asah tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Chujouvin, naosen patsan a akhut kikanpa chu ahung peng tan hichun amapa min chun Zerah asah tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Joseph chu Egypt gam'a ana puijun hiche apat a chu Ishmael sum-kolvei mihon Potiphar kitipa kom'a ana joh un ahi. Potiphar natoh chu Egypt lengpa Pharaoh sepai lamkai a pang ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Pathen'in Joseph chu aumpi jingin, hijeh chun Egypt gamsunga abol lam jousea alolhing jingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Joseph chu Pathen'in aumpi chu athil bolna jousea kon'in apupan ahin muchen tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Hichun Potiphar chu Joseph chunga alunglhai lheh jengin, Joseph chu ama ban tah in akoi tan ahi. Chule Potiphar in Joseph chu a insung jouse chule anei agou jouse vetup dingin atungdoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Hiche nia pat a chun Joseph chu apupa Potiphar in insunga ima jouse vetup in anganse tai, chule Joseph chonphat jeh chun Pakai phatthei bohna chu Potiphar insunga achutan ahi. Hiti chun a insung a thil ijakai akitup tan, chule alousohga ho ahin chuleh agancha ho jong apung thei tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Hichun Potiphar in Joseph chu ama insung vetup ding le anei agou ho jouse vetup dingin thaneina jouse apedohtai, chule Joseph umjeh chun aman imacha ah akisaboi tapon, lungkhamna jong aum tapon, chule aneh ding anneh tilou thil dang athil dang imacha ahepha tapoi. Joseph chu mi mel-hoitah vetnom nom um khat ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Chule phat chomkhat jouvin, apupa loinun Joseph chu ahin velel tan, “Hung in eini lumkhom hitin kitimat hite tin Joseph chu ajol tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Amavang Joseph anom pon, Joseph in Potiphar inneipi chu hitin adonbut e, “Ka pupan hiche insunga thil ho jouse vetup dinga ei nganse ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Hiche insunga hi keima tilou thanei dang aumpoi, kapupan nangma chunga thaneina eipe poi, ajeh chu nangma aloinu nahi jeh in hitobang thil phalou chu iti keiman katoh a Pathen douna a chonset kabol ding ham,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Hiti chun amanun aniseh in Joseph chu ano ano jengin, amavang Joseph chu amanu toh lupkhom a kitimat ding chu pum noplou ahin, ahithei chan a jammang ding joh chu agot ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Nikhat vang chu koimacha umlouna achun Joseph chu ama ngaiya natong dingin achen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Amanu chu ahung lut in asangkhol ah akaijin, “Hung loiyin eini ilup khom lhon ding ahi!” ati. Hichun Joseph in asangkhol asut lhan akitom doh tai. Ahin asangkhol chu Potiphar loinu khutna adalha den tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Hichun Joseph la ajamdoh tan ahin amanun akhut a um asangkhol chu achoiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","Amanun insunga asohte jouse akou khom sohkeiyin, hiche phat chun pasal jousen ahin dellut cheh un, amanun hitin aseiye, “Veuvin! Ei ngolbol diuvin hiche Hebrew sohpa hi kajipan ahin puilut e! Amapa hi kei suse din ka insung denna ahunglut in, ahin keima o sangtah in kapeng in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Keima hatah a o sangtah a kapen phat in polam a ajamdoh in alhaimang tai, ahin aman asangkholchol chu kakom'a adalha dentai” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Hiti chun amanun sangkhol chu aloipa in ahung lhun masang'in phate chan akoitup sellin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Hichun amanun aloipa kom'a thusoh ho chu aseitai; “Hebrew sohpa nahin puilut pa khun insunga ahung lut in suhset ding eigoi,” atitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Amavang keima o sangtah a kapen phat in polam ah ajamdoh in a sangkhol adalhah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Hichun Potiphar chun ajinu thusim Joseph in amanu chunga athilbol chu ajahdoh phat chun hatah in alunghang lheh tan. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Hijeh chun Potiphar in Joseph chu songkul'a akoitan chule lengpa songkul'a umho to akihen khom un, ama jong hiti chun aum den tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ahin Pathen'in Joseph chu songkul'a jong aumpi jingin, angailutna ho jong avetsah jingin chule Pathen'in Joseph chu songkul ngahpa to jong kingailutna apekit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Phat chomkhat jouvin songkul ngahpan Joseph chu songkul'a umho lah a alenpen in akoitan, hiche songkul sunga thilsoh bouina jouse chu Joseph thaneina noiya akoitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Pathen'in Joseph chu aumpi jeh in imacha boina aum tapoi, athil bolna anatohna jouse alolhingsel in hijeh chun songkul ngahpa jong imacha aboi tapoi, ajeh chu thil jouse Joseph in anga jeh chun imacha aphamo ding aumpoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Hicheng thilsoh kichai nung chun Pharaoh lengpa natong ju vaihompa le an vaihompan apupa Egypt lengpa doumah abol lhonin achonse lhontai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Hiche lamkai teni chunga hin Pharaoh nasatah in alunghang tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Chuin Pharaoh in amani chu Joseph umna lengpa songkul natong ho umna ah akoiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Songkul ngahpan amani chu Joseph thaneina noiya a umsah in Joseph in jong amani chu vetkolna anei jingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Jan khat chun songkul sunga kihen teni Egypt lengpa ju vaihompa le an vaihompa chun mang khat cheh, amang ledohna toh kilhon cheh in anei lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ajing jingkah a Joseph in amani amu chun lungkham mel aput lhon chu ahedoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","“Ipi dia hibanga lhungkham nahi lhon ham?” tin adong’e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Amanin adonbut lhonin, “Janlhah in keinin mang kanei gel lhonin amavang koima chan kamang ipi kiseina ahi aledoh thei aumpoi,” ati lhon e, ahin Joseph in adonbut in, “Mang letheina kiti hi Pathen kin ahi.” Chule “Namang lhon chu neisei peh lhonin” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Hichun khon dom le a pang lamkaipa chun Joseph chu amang ho chu aseipeh tai. “Ka mangin lengpi bah ka masanga kamun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Hiche lengpi phunga chun abah thum ajam kamun, gang tah in ahung mum in chuin apahlha tai, hiche aga ho chu lengpi theiga ahung hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Pharaoh chakhon chu ka khut chunga ana um'in, hichun keiman lengpiga phabep chu atwi khon a chun kahehlhan ahi” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","“Mangin avetsah chu hiche hi ahi,” tin Joseph in aseijin. “Thingbah thum chu nithum vetsahna ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Nithum sunga hin Pharaoh in nadomtou intin, chule masanga na natohna a nanung koi kit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Chule nangma kom'a katao ahi, chanvou pha nahung chan teng neihin sumil hihbeh in Pharaoh kom'a hitobang ka thilbol ho hi eina seipeh in, ajeh chu songkul'a konna eilha doh theina dingin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ajeh chu Hebrew gam a ka in apat a eikiman doh tua hiche songkul'a kaum hi mona neilou kahin bolkhel kaneipoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Hichun changlhah hom'a lamkaipa chun mang aphalam a hoitah a Joseph in ale chu amu le ama jong atha anom lheh in; Joseph jah ah hitin aseiye, “Keiman jong janmang kaneiye, ka manga chun paipeh thum changlhah dimset kalu chunga kapun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Pharaoh a dingin Paipeh achunga pa sunga chun changlhah ajat lhingsel in aum in, ahin vacha ho ahung lengun ka luchunga changlhah ho chu anedoh tauve.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph in amang chu alepeh tan, “Paipeh thum chun nithum ma avetsah ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Nithum sunga hi Pharaoh in nalu adopsang ding thingphunga nakhai sanga, vachaten naphe anehchai ding'u ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Pharaoh in nithum jouvin ama penni kipapina in anoiya a semang pachonga pang jouse akou khom in hiche a pang dinga chu ju vaihom lamkaipa le an vaihom lamkaipa chu alhadoh gel in, ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ju vaihom pa chu aju vaihomna ma man apansah kit in, aman jong jukhon chu Pharaoh khut a agapetai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ahin an vaihom lamkaipa vang chu Joseph in amani henga mang alepeh bang chun akhai lih tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Hichun ju vaihom lamkaipan Joseph chu ageldoh tapon asumil deltai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kumni nungin Pharaoh in mang aneiyin ahile, vetan ama Nile vadung panga ana dingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Amanga chun bongchal sagi athao a thao cheh ahung kaldoh un hamhing lah a chun alhauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Chujou in amaho nunga chun bongchal sagi ma agon a gong cheh Nile vadunga kon chun ahung doh un, vadung panga bongchal sagi dang ho kom'a chun ading uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Hichun bongchal agong ho chun bongchal athao sagi ho chu aval lhum tauvin ahi! Hiche mang anei pettah chun Pharaoh chu ahung khang doh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ahin Pharaoh a imulhu kit in mang aniveina aneiyin, hiche amanga hin changphal sagi hoitah vetnom nom um phungkhat a konna hung kikhai lha amun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Hichun changphal sagi amanga amu kit in ahin hiche changphal ho chu ageo cheh chuh jengin, solam huijin amut geo lheh jeng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Chuin hiche geo cheh chuh changphal ho chun changphal lom sagi ahoi phungkhat a kikhai lha ho chu aval lhum kittai. Hichun Pharaoh ahung khangin ahile ajanmang ahi chu ageldoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Hiche ni jingkah apat in Pharaoh chu amang ho chun asuboi lheh in aum thei tapoi. Hichun Pharaoh Egypt gamsung a mitphel doi themho le miching jouse akou khomin amang chu aseitan, ahin amaho lah a khatbeh in jong ipi kiseina ham ti chu adonbut thei aum pouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Phat chaina lang chun lengpa jukhon doma lamkai pa chu ahung ding doh in, “Tunia keiman geldoh khat kaneiye phat masa a kana chatvaina,” atin Pharaoh kom'a aseitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Nangma nasoh teni chunga nana lunglhai pon changlhah hom lamkaipa le keima chunga, hijeh chun keini hi lengpa songkul'a neina koiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nikhat chu changlhah hompa le keiman mang chom cheh kanei lhonin ka mang lhon jong chu thusim chom cheh kanei lhonin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Hiche lai phat chun Hebrew khangthah khat lengpa songkul'a chun keiho toh ana um'in, ama chu lengpa semang pachong pa soh a jong ana pang ahi, kamang nei lhon chu kasei lhonin ahile aman kamang lhon chu eiledoh peh lhon e, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Chule aman eiledoh peh lhon bang bang chun ahung guilhung cheh in ahi, keiman ka natoh ngai ngai eikitohsah in an vaihompa akikhai lihtan ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Pharaoh in Joseph chu ahol in mi asol paijeng tan ama chu agan a gangin songkul'a kon'in ahin puidoh jeng uvin, chuin avon ho akikhel in chule akhamul ho a kisuhtheng in, hichun ama Pharaoh toh kimuto din alut tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Hichun Pharaoh in Joseph kom'a aseitai, “Keiman janlhah in mang ka neijin koima chan aledoh thei pon ahin keiman kajah chu ahile mang kiti ho hi nangman hettheina nanei chu kana jai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph in adonbut in, “Hiche ho chu keima a dinga thil hahsa ahi, ati. Amavang Pathen'in hiche ipi tina ham chu nahetsah theiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Chuin Pharaoh in amang chu Joseph kom'a aseitai, aman hitin aseiye, “Ka mangin Nile vadung panga kana dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","hiche a chun bongchal sagi hoitah kivah thao cheh vadunga kon chun ahung doh un chule hilaiya hampa dong ho chu anepan tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Hinlah keiman chom khat jouvin bongchal adang sagi agon a gong ahoimo cheh ahung potdoh kit kamun, keiman hitobang gancha gong aphe umlou Egypt gamsunga ka hinkhon kana mukha hih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Hiche bong agong melse tah ho chun bongchal sagi athao ho chu aval lhum tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Achuti jeng vang chun akikhel muthei aumpoi, ajeh chu amaho chu masanga bangin agong nalai un ahi. Chujouvin keima kahung khangdoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Hichun keima ka imu lhukit in, chule keiman mang khat kaneibe kit in, hichea kamang achun changvui sagi vetnom umtah phungkhat a ga kamun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Chule changvui sagi ma chu akiveigeosa akeoseh cheh, nisolam khohui mut geosa cheh chu ahung kilahdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Chuin changvui ageosa ho chun changvui hoitah ho chu avallhum kittan, hiche kamang ho hi doithem ho kom'a kaseiyin, hinlah kamang ho chu ipi kiseina ham koima chan eihil chen theipoi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph in adonbut in, “Pharaoh mang teni hi thakhat ahi, Pathen'in Pharaoh hi ipi abol ding ahin hetsah masah ahi bouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Bongchal sagi athao ahoi ho chule changvui sagi vetnom nom uma, aga hon avet sah nom chu ahile kum sagi sunga hi neh le chah neng ding avetsah ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Chule bongchal sagi agong ho leh changvui sagi ageosa aphunga goden solam huiyin asemgot den hon avetsah chu ahile kum sagi nasa tah a kel hunglha ding chu avetsah ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Hiche ho hi keiman ka phondoh banga hung guilhung ding ahi, ajeh chu Pathen'in Pharaoh hi aphat ahung lhun masanga ipi abol ding ho chu ahin hetsah ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Tu apat a Egypt gamsung'a hi kum sagi hatah a neh le chah hung neng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Amavang hiche jou le chun kum sagi ma kel nasatah in hung lhan tin, chuteng chule chun Egypt gamsung ima ma ana thalhing chu kisumil gam'a, kellhah chun agamsung abahgam jeng ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Hiche kel hung khoh hi gimnei lheh jeng ding kum tamtah neh le chah ana ning lhinna ho jouse chu koiman ageldoh louding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Pharaoh mang teni ahung ki hetsahna thupi pentah chu ahile, Pathen'in na ahintoh vah ding ahi ti gontup sa ahitai, hunglhung vah tei ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Hijeh a chu Pharaoh in achingthei tah pasal chule thil hethem tah koitobang aholdoh a Egypt gamsung pumpia mopo thei ahol angai tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Hichun Pharaoh in agam agam a lamkai avetup ding mi lhengdoh henlang hiche teng chule louga sohho kum sagi neh anen sung chun hop nga lah a hop khat koidoh uhenlang, ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Pharaoh thaneina noiya tu apatna neh le chah hiche kum sunga hatah a anen pet ahin changpang ahin koi dimset un, phate chan koitup uhenlang chule angah jong um jing hen, kho nung chan geiya khopi sunga neh le chah um jing theina din, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tua chang le mim ho jouse hi phate chan mun khat a gamsung pumpin koikhom uhen, chutile kum sagi sunga nasatah a kel ahung khoh teng Egypt gamsunga mipi jouse kihinso thei ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Hiche lungthim tohgon hi Pharaoh ahin ama semang pachong hon jong pha asa cheh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Hichun Pharaoh in amaho chu adongin, “Eihon hitobang pasal Pathen Lhagao chenna hi imujou dingu hi nam?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Hiche pet chun Pharaoh in Joseph ahoulimpi in, “Ajeh chu Pathen'in ima jouse nangma nahetsah tah jeh in nang tobang koimacha ahethem le aching aum tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Nangma keima leng touna a natou ding ahitai, kami ten nangma thupeh jouse ajui cheh dingu ahitai. Chule thil khat bou ikikhehna ding chu keima ka lengvai pohna a bou lenjo ding kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Pharaoh in Joseph jah ah aseitan, “Keiman nangma hi Egypt gamsunga thaneina le mopohna kapeh doh nahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Hichun Pharaoh in akhut a sana khutjem chu aladoh in Joseph khut a abupeh tai. Aman vonkang hoitah akivonsah in chule sana khi jong angong a aki osah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Hichun lengpan Joseph chu asakol chunga atousah in amasanga chun “Mihon dilsu vo tin asam uvin ahi.” Hiti hin aman Joseph chu Egypt gam pumpi semang in ana pansah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Chule Pharaoh in Joseph kom'a hitin aseiye, “Nangma phatsah louva Egypt gamsunga koima chan akhut alapthei louding, keima amin'a bou Pharaoh kahi ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Hichun Pharaoh in Joseph chu Egypt te min Zaphenath-paneah asah in, chuleh Potiphera chanu Asenath chu Joseph ji din Pharaoh in agontup peh in ahi. Hiche apatna chu Joseph in Egypt gamsunga mopohna alah ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Egypt lengpa Pharaoh kom'a anatong dinga alut chun Joseph kum somthum alhing tai. Chuin Joseph chu Pharaoh angsunga kon'in apotdoh in Egypt gam leiset pumpi aga kholsoh keiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ana kisei bang chun kum sagi sung chun neh le chah lousoh hatah in apungin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Hiche kum sagi sunga chun Joseph in chang le mim Egypt gamsunga kimu jouse chu mun khat a akoikhom sohkeiyin, chule khopi jousea akoina mun asem sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Hichun Joseph in chang le mim chu tamtah avum leovin akhol khom in, vadung panga neldi banga atamval tah jeh chun hetlut jou jong ahi tapon, achaina langa chun simsenglou ahitan sim jong asim tapouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kellhah kum hung lhun masang chun On thempu pa Potiphera chanu Asenath chun Joseph dingin chapa ni ana hinpeh in ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph in achapa atahjo pa min chu Manasseh asah in, aman aseiyin, “Hiche hin ka Pathen'in kagentheina jouse eisuhmil sah tai, chule kapa insung jong abonchauvin kasumil sohtai,” tina ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Joseph in achapa aneojo pa min chu Ephraim asah tai, aman hitin aseiye, “Ka Pathen'in ka hahsatna le ka gentheina jeh in lolhinna eipe tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Egypt gamsunga kum sagi sunga chang le mim mang ketkut a ga jouse chu ahung kichai gamtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Hichun kum sagi kellhah ahung kipan tan, Joseph in ana seidoh ma bangin hiche a nasatah a kellhah chun anaivel a gam ho jouse jong asuboi sohhel tai, amavang Egypt gamsunga chun neh le chah ahahsatna imacha aumpoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Egypt gamsunga kel ahung khoh lheh jeng tan, hichun mipi ho chu neh le chah ngaichat jeh in Pharaoh kom'a ahungun, hichun Pharaoh in Egypt mipi te ho chu “Joseph kom'a asol in aman bol un atiho chu bol uvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Hiti chun kellhah chu hatah in ahung khohse cheh tan gamsung jouse aboilou aum tapon, Joseph in changpang ho jouse chu ahong doh tan, Egypt mipite chu akichoh sah tai. Ajeh chu Egypt gamsunga kelkhoh chu asang lheh in hitobang kellhah chu ana um khahih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Chule gam dang dang Egypt gam kimvel a jousen neh le chah akichoh theina diuvin Joseph heng ahinnai lut tauvin, ajeh chu hitobang kel hah chun vannoi leiset chung jouse asuh boi cheh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Hichun Egypt ma anneh anen dan chu Jacob in ahetan, achate jah a aseitai, “Ibola nadin chet chut uva kiveto nahiu ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Keiman thusoh kajan Egypt gam lama chang aum'e, hijeh chun nangho cheuvin lang neh ding gacho tauvin, eima ho ikihinso theina ding uvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Hichun Joseph sopite mi som ho chu neh cho dingin Egypt lama achesuh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Hinlah Jacob in vang Joseph sopipa Benjamin chu amaho lah a asol tapoi, aman aseiyin, keima katija lheh tai ajoleh kisuhkhahna le boina toh khante, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Canaan gam kel hah aum tah jeh chun Jacob chate chu Egypt lama anneh hol din mijouse toh ahunglhung khom tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Tua hi Joseph chu Egypt gam'a chu vaihom ahitan, chule chang johna dinga thaneina jouse kipe ahitan, hiche pettah chun asopite ahunglhung tauvin, amaho ahung lhun lhunun, hikom'a chun tol'a amaho abohkhup un akunsoh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Joseph in asopite chu amu phat in abonchauvin ahe sohkeiyin, ahivangin amaho chu hetphah lou bol in, hutot tah-in ahouvin, chule ajah uva, “Hoiya konna hung nahiuvem?” atile ama hon jong “Canaan gam'a kon kahiuvin, puhsui dinga hung kahiuve,” atiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Joseph in asopiho chu ahet vang'in ama hon ahe doh jou pouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Hichun Joseph in kum tamtah masanga asopi ho mang ana mat ho chu ahin geldoh in asopi ho kom'a hitin aseiye, “Nangho hi miphalou le migucha nahiuve, keima ho gam hi lahmang thei ham ahilou le akihongbit jou pouve, tia neihung khol leu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","“Ahipoi ka pakai!” tin ama hon asam un ahi. Nasoh te ho hi anneh cho ding bou kahi jouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Keiho jouse hi pa khat a hung peng cheh kahi bouvui, milung theng kahiuve, nasoh ho hi miphalou kahi pouve!” ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ahin Joseph in aseikit leuvin, “Ahipoi nangho hin ka gam'u hi gam ong kivaipoh achavaiye tia nei hung khol leu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Hinlah ama hon adonbut uvin, “Nasoh te ho hi ucha pasal som le ni kahiuvin, pa khatna hung peng kahiuvin, Canaan gam'a incheng tuchung hin aneopen pa hi kapau toh kahin dalha uvin, chule mi khatpa vang aum tapoi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph in adonbut in, “Keiman kasei banga nangho hi michom miphalou nahiuve!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Hichea hi nangma ho kapatep ding nahiuve, Pharaoh hinlai sea kakitep ahin asopi pau alhumpen pa nahin puikah seuva Egypt hi na dalhah louding'u ah! ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Nangho lah a mikhat kisol uvin lang amapa chun na sopi pau chun hinpui henlang, chule adang ho se songkul'a na um ding'u, na thusei'u hi dihnam tia ka khol chil ding ahi; amavang hichu ahi louleh Pharaoh ahin laisea nangho hi michom, miphalou kiti chu nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Hichun Joseph in amaho chu abonchauvin songkul'a nithum jen ahen in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Nithum lhin nin Joseph in aseiyin, “Keiman Pathen ging mi kahi. Kasei nabol uva ahileh nakihinso diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Nangho hi milung theng nahiu leh nangho lah a mikhat hi songkul'a umden uvin lang, ahin adangse se vang kinungle cheh uvin, na insung mite din chang le mim kipoh un chetauvin. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Chule na sopi pau alhumpen pa chu keima kom'a nahin pui dingu, na thusei hou chu dihnam tia kakhol chil ding ahi. Chule nangho nathi lou dingu ahi.” Hichu ama hon jong pha asauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Hichun amaho khat le khat akihou limun, “Adihtah a sei dingin eiho hin isopi pau Joseph ibolset jeh uva gotna ichan'u ahitai. Ajeh chu eihon imusoh keijun aman ahinkho huhdohna dingin ataovin, hinlah eihon inahsah pouve, hiche ho jeh a chu tua hi gotna ho hi eiho chunga hung chu ahitai,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Hichun Reuben in amaho chu hitin adonbut in, “Keiman kasei hilou ham, chapang chu imachan bolse hih un, ahin ka thusei nangai pouvin, tua eihon ama thisan man chu isah diu ahitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Amaho kikah a paole aum jeh chun Joseph in amaho ahetchet u ahilam chu ama hon ahedoh pouvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Hinlah Joseph akihei doh in achom lang angan akaptai, ahin ama ahung kinung hei kit in avelin amaho jah thei dingin ahoulim in, hichun amaho lah a Simeon chu alheng doh in amaho mitmu tah in akan tup tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Hichun Joseph in thu apen, amaho dip sunga chun chang khum peh uvin, chule sum ho jong chu ama ama dip sunga nung hetpeh un, chule lampia aneh dingu jong gonpeh uvin hiti chun amaho din thil gontup in aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Hichun asopi hon sangan chunga chun neh ding chang chu ahengdoh un a inlamu ahin jon tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ahin jan na akingah nauva amaho lah a mikhat pa chun sangan anneh peh ding agotan adip sung chu agah hondoh le adip sunga sum chu ahin mudoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","“Veuvin!” tin asopiho jah a aseiyin, “Kasum ho hi ka dip sunga eiki nungkoi peh!” Hichun amaho chu alungu alhadeh tauvin kithing pum pumin khat le khat akihou khom un, “Pathen'in ipi eito sah u hitante?” atiuve.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Hichun amaho apau Jacob heng Canaan gamsung ahunglhung kit tauvin, hichun ama hon Jacob kom'a thil ahinto hou chu aseipeh ui. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Gamneipa chun hiti hin aw sangtah in keiho jah din asam in, chule keiho hi miphalou gamsunga thilse bol dingin eigingmo un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Hinlah keihon amapa chu ka donbut un, keiho hi milung theng mikitah kahi bouvui katiuvin, chule keiho miphaloute kahi pouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Chule keima ho hi ucha sopi som le ni solam a hung kon kahiuvin, Pa khat in eihin'u ahin, mikhat vang ahing tapon chule aneopen pa vang tuhin ka pau toh Canaan gamsunga kahin dalha uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Hichun gamsung a lamkai pipu pa chun hitin eisei peh uve, nangma ho hi hitia kabol ding mipha milung theng nahiu kahet doh nadin, nangho lah a khat kidalha uvin, chule adang hon anneh ding chang le mim pouvin lang na inkote kom lang nung che tauvin. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Hinlah na sopipau alhumpen pa chu ka henga nahin puilut tei ding'u ahi ati, chule keiman hiche jou teng chule nangho hi mipha midih tah nahiu, michom le mikhol nahi pouve tichu kahet chet ding ahitai. Hiche teng chule nasopi pau chu kanung peh kit diu chule nang hon boina um louva navahsel a an jong nakihol theiyu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Adip u chu alhei lha uvin ahile vetan amitakip sum chun chu ama ama dip sung cheh a ana umsoh keiyin; ama hon jong apauvin jong a sum chun chengseu chu amudoh phat uvin akihot lhul gam tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Jacob chu tijatah in ahoulim in, “Nangho hin ka chate ho neiguh mang peh cheh dingu ahitai! Joseph jong aum tapoi! Simeon jong aum tapoi! Tua nang hon Benjamin kisan nei puimang peh kit diu. Thil jouse hi keima douna jeng ahitai!” ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Hichun Reuben in apa Jacob chu adonbut in, “Benjamin chu kahin nungpui louleh kacha teni hi nadei dei nalo thei ahitai, chule keiman Benjamin na dingin mopo nang kate ati, chule thon louva kahin nungpui kit teitei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Ahin Jacob in adonbut in, “Ka chapa chu nangma toh chelou ding ahi, ajeh chu aupa Joseph jong athi tan, tua kanei ka lungmonpi ama bou ahitai; ijem tin lamkim lang nagei tengu le lamkah lah a toset tohkha tahen lang hile kasam kan nung jenga jong lunghem a thikhol khul a nei lhohlut pai tahbah dingu ahi bouve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Tuhin Canaan gamsunga kellhah chu akhoh cheh cheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Egypt gam'a konna ahinpoh u anchang aneh chai phat un hichun apau Jacob in achate jah a aseitai, “Nung chekit unlang neh ding gacho kit tauvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ahin Judah in apa Jacob adonbut in, “Gamsung lamkaipa chun hatah in eigah un, na sopi pau chu nahin puilou ule kamai namulou dingu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Benjamin keiho toh nasol khom le kache dingu anchang kaga choh dingu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Amavang Benjamin che ding naphal louleh keiho jong kache louhel ding'u ahitai ti geldoh in, ajeh chu gamsung lamkai pa chun aseiye, “Na sopi pau alhumpen pa chu nahin puilou ule kamai namu lou dingu ahi atisa ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Hichun Jacob in adonbut in, “Ibol a nang hon nei suhgenthei uhitam, hiche gam vaipopa kom'a chu sopi khat kanei nalai uve tia nahin seidoh uham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ama hon adonbut un, “Hiche gamsung lamkaipa chun eiho insung thusim hoitah in thudoh eineijun, napau dam nalai em? Sopi pasal dang nanei nahlai uvem? tin eidong un, hiche a chun keihon amapa thudoh ho chu ka donbut cheh un, chule na sopi pau hinpui yun ati ding chu keihon iti kahet thei diu ham? ,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Judah in apa Israel kom'a aseitan, “Chapang pa chu hinsol in hiche teng chule keiho kaga che diu ahi, chuti louleh ikellih diu, nang le boipu geiya ithigam diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Chule keima ka tahsa tah in mopo nang kate, ahin Benjamin chu kahin nungpui louleh boina jouse keiman mo kapoh ding ahi. Chule nangma angsunga thepmona jouse keima chunga chu jenghen. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Amavang eiho ana geisang hih leuhen tuphat a hi nivei tobang kilhung thei ding ahitai,” ati ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Chuphat in apau Israel chun ajah uva, “Chuti ding mong ahiya ahile hiti hin kigong uvin, gamsunga thingga phalai cheh lheng khom uvin lang, thingnai, lou themkhat le khoiju them khat toh, thil namtui toh, theichang toh, chule jonmot chang toh nadip sung uva mipa peh ding chun posuh uvin. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Chule dangka jong athop in pohbe un, ajeh chu nadip sung uva ana kikoi chu koitobang khat in jong anabol khel jong himai thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Hijeh chun nasopi pau hi puijun lang gamsung lamkai heng'a nungche tauvin. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Chule Hatchungnung Pathen'in phatthei naboh maiju hen, hiche gamsung vaipo mit mua jong ngailutna mel na chan thei uva na sopi pau Simeon chule Benjamin nahin lhadoh peh thei diu ahi. Keima vang ka chate jal'a thilo pai ding ka hitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Hichun ama hon Jacob thilpeh ho chu agongtup un, chule adipsung uva sum jong athop in apohbe uvin, Benjamin toh akilhon tauve; hichun amaho Egypt gam alhung tauvin Joseph masanga ading tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Chuin Joseph in Benjamin amaho lah a ahung chu amutan, hichun aman a insunga lhacha a pangho jah a hitin aseiye, “Amaho tohin tunia an nekhom ding kahiuvin hijeh chun insung lama ana puilut un, chule gancha ana that un, kin thupi tah kimang ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Hichun lhacha hon Joseph in asei bang chun abol'un, amaho sese chu Joseph inlam a apui tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Joseph insung'a akipuilut jengu ahetdoh phat un asopiho chu akichauvin, “Iche masah uva hilai mun a koiham khat in idipsung uva sum ana hetlut u ahi. Aman eihon iguh u banga agon a, eimat uva, asoh uva eisem uva, chuleh isangan hou jong eilahpeh u ahitai” akitiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Asopiho chu Joseph insung lhachapa kom'a ache un akelkot kom'a, ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Pu,” Keiho hi phat masa chun Egypt gam'a anneh ding chon kahung uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Ahin keiho kaki nungle uchun jan ahia kakichol pet uva kadip sungu ka hondoh ule keihon ka dipsung cheh uva kathil chohna man cheh uchu ana umsoh keiye! Yuhin hiche dangka ho chu kahin nungpoh cheh nauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Chule keihon anneh chohbe na ding dangka jong ka hin pohbe uvin, koi tobang ham khat in dangka ho kadip sung uva ana koi jong chu ka pum het pouve.” atiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","“Imacha lungboina nei hih un,” tin insung lhacha pa chun aseiye, “Na Pakai na pate Pathen chun na dipsung uva nahin koipeh u ahi, na dangka hou jong keima kom'a aum nai.” Hichun aman Simeon chu alhakang in amaho lah a ahin puidoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Insung lhacha pa chun miho chu Joseph leng insung lama apuilut tauvin ahi. Insung lhacha pan akengu kisil ngimna ding twi apen chule sangan ho ding anneh jong apeuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Hilai mun a chu an aneh ding thu u ahetdoh phat un, sun a Joseph ahung lhun masang'in ama hon thilpeh ho chu akigon tup tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Hichun Joseph in ahung lhun chun ama hon athilpoh u chu ahin ladoh un Joseph masanga tol'a abohkhup tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ama hon alemjou chun adong tan a”Napau akum atamtai nati pau chu itoh bang nam, dam jinga hinam?” tin adong'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ama hon adonbut un, “Henge” tin adonbut un “Ka pau, nasohpa chu adam in ahing nalaiye,” tin Joseph masanga abohkhup kit uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Hichun Joseph in apenkhompi asopipa Benjamin chu aven, “Ama hi ham na sopiu alhumpen pa natiu chu?” tin Joseph in adong tai. “Pathen'in na umpi jingta hen, ka chapa.” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Hichun Joseph kinloitah in insunga kon'in apotdoh e, ajeh chu asopipa amu chun ama akitimjou tapon, ama indan sungnunga alut in agakap tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Chuin amai akiphet jouvin ama ahung potdoh kit in nasatah in akitim ham ham in, “Anneh ding hin thuh tauvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Hijeh chun ama hon Joseph ding atum in, amaho ding atumin, chule ama toh nekhom ding Egypt mite ding atumin ankong asem tauve, ijeh inem itile Egypt miten Hebrew mite toh an anehkhom ngailouvu, neh khom ding chu Egypt mite dinga bohna khat hiya ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Joseph in asopiho chu atouna diu akoi peh cheh in, ama hon jong ajalheh jengun, amaho tahsa kum alen penna pat aneopen pa geiyin atou nau agontup peh in atousah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Amaho chan ding chu Joseph chan lah a kon'in asoh doh uvin ahi; chujongleh Benjamin chan chu amaho khat chan jat sangin chan ajat ngan atamjoi. Hitobang chun ama hon Joseph chutoh an ane khom uvin adon khom tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Hichun asopiho chu chedingin aki gong tauvin, Joseph in insung lhacha ho lah a aseitan, “Amaho dip sunga chun apoh thei jat u dimset in anchang kipoh sah un, chule dangka ahin kipoh hou chu nung hetpeh cheh kit un,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Chutengleh keima sum eng chakhon chu alhumpen pa dip sunga achungtho pena koijun chule chang choh na dinga sum ahin kipoh toh chun koi than, hiti chun insung lhacha pan jong Joseph in asei bang chun abol tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Jingkah matah in akipat doh un ache tauve, a sangan hon jong vumset in neh ding apon alampiu majon dingin asol tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Amaho chu khopia kon chun achedoh tauvin gamlapi agei masang uvin Joseph in jong a insung thil chingpa jah a chun, “Kipat doh inlang miho nung chu del loiyin, amaho chu naphah tengleh ajah uva, 'Ipi ding pen tah a ka phat nau thilpha chu git louva na lethuh uhitam ong?' Ipi dinga keima dangka khon chu nana guh mangu ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Nangho hin ibola kapupa sum eng chakhon naguh u hitam? Aman hiche chu aman chah a thil ahunglhung ding ho hetna a aneiji ahi; nang hon thil phalou tah na boldoh'u hitalou ham!'” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Insung lhacha pan amaho chu amattup jouvin hitin aseitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Ama hon amapa kom'a hitin asei uve, “Keiho hi nasoh kahiuvin, chule keihon hitobang chu kabol loubeh ding'u ahi! atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ven keiho Canaan gam'a pat in sum chu kahin kichoi cheh nauve, chule kadip sung uva ana umho chu ka pakai pa in a konna keihon iti dana sum eng chakhon chu kaguh doh thei diu ham?. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Nasohte lah a koi hijongleh ala ana umtah le ama jong chu thidoh mai tahen, chule keiho jong ka pakai pa kom'a sohchang ding kahi tauve.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","“Hiche chu apha lheh jenge,” tin ama pan adonbut e, “Hinlah ka chakhon gupa bou chu kasoh a pang ding ahi. Adang ho vang nache thei diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ama hon gangtah in adip hou chu sangan chunga kon'in adom lhauvin ahong doh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Hiphat chun insung lhacha pan alenpen apat in aneopen pa geijin adipsungu ahin kholtan ahile sum eng chakhon chu Benjamin dipsunga ahin mudoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Hichun ama hon asangkhol'u abottel tel tauvin, apot hou chu asangan chunga aheng doh kit un, khopi lam ahin nung jot kit tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Judah le asopi ho ahung lhun uchun Joseph chu a inna anaum nalaiye, chule amaho Joseph masanga tol ah abohkhup tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Chuin Joseph in amaho jah a aseiyin, “Ipi ham nang hon nabol'u hi? Hitobang mihem ho hi keiman akhonung dingu kasei thei nang hon nahet lou uham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Hichun Judah in aseitai, “O, ka pakai, ipi kasei dingu hitam? Keima ho iti them ka kichan diu hitam? Pathen'in nasohte chonsetna ho hi ahin hetdoh sah ahitai. Ka pakai, hijeh chun sum eng chakhon kimatdohna pa seh hilouvin keiho ka boncha uva nasoh a pang ding kahi tauve.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Hinlah Joseph in adonbut in, “Chuti ponte,” Keiman chutia chu thil kabol louhel ding ahi! Ka khon gupa bou chu kasoh a pang ding, adangse sevang damsel in napa kom'a nung che tauvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Hichun Judah in anaijin aseitai, “Lungset tah in, ka pakai, nasoh pan thu cheng khat tou sei inge. Lungset tah in, nangma Pharaoh toh nalalna lhon kibang jongleh nei lunghan khum hih in. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","“Ka pakai, phat masa chun nasohte ho nei dong uvin, 'Nang hon sopi nanei uvem ahilou le napa'u umnalai em?' nati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Chuin keihon ka donbut un, 'Henge, ka pakaipa, kapa'u jong adam nalaiye ahin amavang ateh lheh tai katiuve, chule achapa aneopen pa chu ateh jou nungsanga ahin ahi. Asopipa jong athi tan, ama bou chu anu sunga hing doh ahin, hijeh a chu apan jong hatah a angailut ahi,' ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Kaheng uva naseijin, kahenga hinpuiyun amapa chu keiman kamit tah inkamu nom e, nati.' ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ahin keihon kana donbut un, 'Ka pakai, hiche chapang chun apa adalha theipoi, ajeh chu apa thilo thei ahi,' ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ahin nei thumop kit un, 'Nasopi pau alhumpen pa toh nahung kilhon lou ule nang hon kamai namu kitlou dingu ahitai,' nati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","“Hichun nasohpa, kapau koma kakile un, nasei chu kana lhut tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Phat chomkhat jouvin, 'Cheuvin lang chang eiga chohpeh kit un,' atin ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","‘Ka sopiu aneopen pa toh neisol lou ule kache lou diu ahi. Aneopen pa pui louva mipa mai chu kamulou diu ahi,' tia kadonbut u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Hichun kapauvin kaheng uva aseijin, 'Ka loinun chapa ni eihinpeh nang hon naheuve, ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","amani lah a khat pan eidalha tan ahung kinungle tapoi; lung opkaina loubeh a gamsa hon atal adah a ajam'u ahi. Ama kanung mukit louhel ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tua asopipa kakoma kon a napuidoh uva, boina ahinto khah le, lunghem pum a hiche samkang pa hi alhankhuh nalhut pai diu ahitai,’ ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Tun, ka pakai, keima kapa henga hiche chapang jao louvin kinungle thei pong kate. Kapa'u hinkho hi hiche chapang pa hinkho a hi kingam ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Kapan hiche chapang hi amulou le thilo tei ding ahi. Nasohte ho hin kapa'u samkan jouva thina kato sah kit dingu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Amonga jong na sohpa hi kapa henga hiche chapang khel'a hung kipe doh jenga hitia hi, keiman ama hi naheng kahin nunglhut kit louva ahile nahenga hinkho lhumkeijin themmo chang jeng ing kate, kati ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Hijeh chun kapu, lungset tah in ahithei ding leh hiche chapang khel in keima hi nangma soh din um tang kate, chule ahithei ding leh hiche chapang hi a uteho toh kinungle tauhen. ");
INSERT INTO tczchongthu_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Keima hiche chapang pa beiya hi iti kapa kom'a kaki nungle kit ding ham? Kapan gim genthei athoh ding chu iti kavet jou ding ham,! ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Hichun Joseph anatoh khompi ho masanga ama le ama akitim jou tapon hichun awthong jejun akap tan, mijouse chukom'a kon chun asoldoh in ama asopi ho lah a akiphong doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Chuin ama hatah in akaptan ahile Egypt miten jong aja uvin, chule hiche thu kisei chu apet pet in Pharaoh in ajatan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph in asopi ho kom'a aseiyin “Keima Joseph chu kahi! Kapa chu dam nalai hinam?” ati. Hinlah asopiho imacha seithei louvin aum gam tauve! Amasang uva ding Joseph ahi ahin hetdoh u chun alung kidang lheh jengun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","“Lungset tah in, hung kikhin naijun,” ati. Hichun ama hon ahin nailut tauve. Chuin aseikit in “Keima hi Joseph, nasopi pau, Egypt gam'a najoh pau chu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ahin tija hih un, chule keima hilaimun a neijohdoh jeh uva nangho le nang hon kilunghan jong bol hih un. Ajeh chu nangho hinkho huhdohna dinga Pathen'in hilai mun a hi eina sol masah joh ahi bouve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Hiche gamsung a hi kumni bou kel hah hung kipan bep ahin, kum nga sung jen avat nalaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Pathen'in nangho huhdoh dinga eina sol masat joh ahi, nangho le na insung mite thilouva lei chunga achi amanna louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Hiche chu nang hon nabol'u ahipon, Pathen'in eina masol joh ahi! Chule Pathen'in Pharaoh hilthei ding ama lenggam Egypt gamsunga semanga pang kahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Tun gangtah in cheuvin lang kapa gaseipeh loiyun lang 'Nachapa Joseph in aseiye: Pathen'in Egypt gamsunga vaipo lenpenin eipansah tai. Hijeh chun kakom'a hungsuh loiyin! ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Keima toh kinai cha a nachate le natute jouse, na gancha ho le nanei nagou jouseu pumma Goshen gamsunga na chen theiyu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Hikom'a chu keiman kavetsui diu ahi, ijeh inem itile kellhahna ding hi kum nga jen aum nalaiye. Achuti louva ahile na insung pumpiu leh na gancha ho jouseuvin an angol diu ahi.'” ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Hichun Joseph in athusei ajom in “Veuvin! Nang hon neimu chen uva sopi Benjamin in jong nei hetchenna din, keima Joseph chu kahi! ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Cheuvin lang Egypt gamsunga jabolna changa kaum hi kapa Jacob chu gaseipeh loiyun, thil namu jouseu seipeh un, chule aganna thei chanin hilanga hin puiyun,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Hichun Joseph in Benjamin chu angong koiyin akaptai, chuti ma chun Benjamin'in jong akoiyin akaptai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Joseph in asopi ho chengse chu kappumin achop sohkeijin ahi, chujou chun ama hon chamlhat tah in akihoulimpi pan tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","“Joseph sopi ho ahunglhung tauve!” tithu chu Pharaoh leng inpi a gangtah in alhung tan, ama hon jong akipapi lheh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Hichun Pharaoh in Joseph kom'a aseiyin, “Na sopi ho chu seipeh in gangtah in na sangan chung uva napot hou chu hengdoh unlang gangtah in Canaan gama kinungle loiyun,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Chule napa ahin adang insung mite jouse keima kom'a hin lepui loiyun Egypt gamsunga aphapen kapeh diu nahi; chule agam gasoh ahoipen naneh diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Hichun Pharaoh in Joseph kom'a asei in, “Na sopiho chu seipeh tan ama hon kangtalai chu kipuiyu henlang chapang ho le a jite ho'u chule napa'u chu ka henga hin puiyun. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nang hon nathil nei hou chu lunggimpi da tauvin, ajeh chu Egypt gamsunga ahoipen aphapen jouse nangho a ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Hichun Jacob chaten amaho thu kiseipeh bang chun abol'un, Pharaoh in aphatsah le athupeh dungjuijin Joseph in jong kangtalai ho chu agontup peh in, chule lamkah a neh le chah ding jong agontup peh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Chule aman asopiho chu vonthah apecheh in, Benjamin vang chu golvah von nga chule dangka sum eng jathum toh apen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Joseph in apa din sangan chal som a Egypt gamsunga atui aphapen ho jouse apohsah in chule sangan anu som chu ahung kitol tengu leh lamkah a akihinso theina diuvin changlhah dimset apohsah un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Hichun Joseph in asopiho chu alhadoh in, amaho akipatdoh ding kon un, Joseph in amaho chu availhah in “Lampi najot lai un nangho kinapa hih un!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Chuin ama hon Egypt chu adalhauvin Canaan gam lang apa Jacob kom'a akile kit tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ama hon apau chu aseipeh un hitin atiuve, “Joseph ahing nalaiye!” Chule Egypt gam pumpia vaipoa khu ama hijah ahi!” atiuve. Ahinah vang chun Jacob in la amaho atahsan loujeh in alungthim akiloh dehpoi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ahin ama hon Joseph thusei chu avel vel in apau chu aseipeh un, chule Joseph in apa pohna dinga kangtalai chu agahven amu phat in apau Jacob lhagao chu akidodoh kittai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Hichun Jacob in aphongdoh tai, “Ka chapa Joseph ahing nalaiye! Atah hinte! Ka hinkho bei masang'a kaga kimupi ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Hichun Jacob chu Egypt gam jon din akipatdoh tan anei agou jouse jong apon Beersheba ahung lhungin hiche jan chun apa Isaac Pathen min'in maicham asem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Hiche jan chun Pathen'in gaova akihoulim pin, “Jacob! Jacob!” tin akouve. Aman jong, “Hikom'a kaume,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Keima napu napate Pathen kahi,” tin ahoulim pin, nangma Egypt gam langa chesuh ding kicha hihbeh in ajeh chu Keiman nangma hiche mun'a chu nam lentah kaso ding nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Keiman Egypt lama na chesuh teng ka kilhonpi ding nahi, chule keiman nangma ka hin nungpui kit ding Egypt a nathi ding ahi, ahin namit nasinna mun a chu Joseph in naumpi ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Hichun Jacob in Beersheba adalhan chule achate sen Egypt lama apui tauvin, kangtalai chunga ama ahin chapang naosen ho jong chule ajite ho chengse jong Pharaoh in ima ma agontup peh bangin apuisuh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ama hon anei agou jouse chule agancha hou jouse Canaan gamsunga ana kilamdoh ho jouse jong apo tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Achate hou sese chule atute ho jouse jong chule achanute ho jong chule achanute chate jouse jong ama chilhah namkim jouse toh Egypt ahin jon tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Tua min hung kipe ho chengse hi Israel chilhah Jacob chate Egypt gam'a ana cheho chu ahiuve: Reuben chu Jacob chate lah a atahpen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Reuben chapate chu Hanoch, Pallu, Hezron chule Carmi ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeon chapate chu Jemuel, Jamin, Ohad, Jakin, Johar chule Shaul ahiuve. (Shual nu chu Canaan numei ahi). ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Levi chapate chu Gershon, Kohath chule Merari ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judah chapate chu Er, Onan, Shelah, Perez chule Zerah ahiuve. (Er le Onan chu Canaan gam'a ana thi lhon tajongleh) Perez chapate chu Hezron le Hamul ahi lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issachar chapate chu Tola, Puah, Jashub chule Simron ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulun chapate chu Sered, Elon chule Zahleel ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Hiche ho hi Paddan-aram gam'a achen lai uva peng Jacob le Leah chapa te ahiuve, chule amaho tilouva apenbe achanu, Dinah chu ahi; Jacob chate jouse numei le pasal abon'a Leah a konna hung peng doh jouse chu agoma somthum le thum ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gad chapate chu Zephon, Haggi, Shuni, Ezbon, Eri, Arodi chule Areli ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asher chapate chu Imnah, Ishvah, Ishvi chule Beriah ahiuve. Serah chu asopinu u ahi. Beriah chapate chu Heber chule Malkiel ahi lhon e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Hiche pasal ho sese hi Zilpah chate ho Leah sohnu akon a Jacob chilhah ho ahiuvin agom a som le gup ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacob chilhah Rachel in ahinpeh chu Joseph le Benjamin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Joseph chate ni Egypt gam'a peng chu Mannaseh le Ephhraim ahi lhone, amani nu min chu Asenath Potiphera chanu On gam'a thempu pa chanu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjamin chapate chu Bela, Beker, Ashbel, Gera, Namaan, Ehi, Rosh, Muppim, Huppim chule Ard ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Hiche ho hi Rachel le Jacob a konna hung peng achapate ahiuvin abonchauvin som le li ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan chapa chu Hushim ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Napthali chapate chu Jahzeel, Guni, Jezer chule Shillem ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Hiche pasal ho hi Bilhah in ahin peh Laban in Rachel soh dinga apeh nu akon ahiuve. Jacob in Bilhah toh ahin chu abon'un pasal sagi ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Jacob chilhah te Egypt ma ama toh cheho chu achate jiho sim louvin mihem somgup le gup ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Hiche tilou chun Jacob in Egypt ma cha pasal ni aneiben hijeh chun abonchauvin Jacob insung mite chu Egypt gam'a anachen laiyu chun mihem somsagi alhingset un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Amaho alamjot nauva alhunna diu ahung naithim tan, Jacob in Judah chu Goshen jotna lamhil hedin asol in, phat chomkhat jouvin amaho alhung tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Joseph a sakol kangtalai chunga atou doh in apa Jacob chu Goshen lama aga kimuto pitai. Hichun Joseph in apa Jacob amu phat chun phat sottah a ngongkoi in akap tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Hichun Jacob in ahin hou in, Joseph kom'a aseitai, “Keima tua hi thi thei kahi tai, ajeh chu nangma nana hing nalai in tuhin namai kamu tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Hichun Joseph in asopite le apa insung mite jah a “Keima chetou ing ting Pharaoh jah a thu galhut ing ka ting ajah a, ‘Canaan gam'a cheng ka sopite le kapa insung mite ka heng ahunglhung tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Amaho hi kelngoi ching mi ahiuvin, chule ama hon anei thil jouse le agancha hou jong ahin kipui uve gati ing'e.'” ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","“Ahin Pharaoh in ipi na natoh u nahin doh teng ule, ");
INSERT INTO tczchongthu_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","na donbut dingu, “Keiho, nasohte hi, kapu kapa teu bangin kelngoi ching kahiuve,' nati diu ahi. Chuteng Pharaoh in Goshen lhanglam a nahin chen sah diu ahi; ajeh chu Egypt miten kelngoi chingho atheinom pouve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Hiti chun Joseph achelut in Pharaoh henga thu agalhut in, ‘‘Kapa le ka sopite Canaan gam'a kon'in ahunglhung tauve. Amaho akelngoi ho jouse le aganchau toh chule anei jouseu toh kilhonin tuhin Goshen gamsunga aum uve,” agati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Chuin Joseph in asopi ho lah a mi nga alhengdoh in Pharaoh henga phondohna aneiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Chuin Pharaoh in amaho chu thu adong tan, “Nangho ipi natong nahiu ham?” ati. Ama hon adonbut un, “Keiho, nasohte hi, kapu kapate khanga patna kelngoi ching ka hiuve,” atiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ama ho Pharaoh henga ahoulim un, “Hiche Egypt gam'a hi phat chomkhat cheng dinga hung kahiuve, ajeh chu Canaan gam'a hamdong jong aum tapoi. Khulam'ah kellhah jong akhohse lheh jenge. Hijeh chun lungset tah in, Goshen lhaanga nei chensah un,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Hichun Pharaoh in Joseph jah a aseiye, “Napa ahin, na sopiho nangma kom'a din ahung tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Egypt gamsung pumpia amaho achen theina diuvin nangman lhenpeh tan, chule Egypt gamsung gam phalai pen chu pen. Goshen lhaanga chun cheng tauhen. Chule amaho lah a miching thepna nei aum leh keima gancha ho vetup din nei koipeh in,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Hichun Joseph in apa Jacob chu Pharaoh kom'a ahin puijin akihetto sah e. Jacob in Pharaoh phatthei aboh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Chuin Pharaoh in “Kum ijat nahi hitam tin Jacob chu adongin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Jacob in adonbut in, “Keima kum jakhat le somthum hung kholjin kahitai. Amavang ka hinkho hi kapu kapate sang’in achomjo nalaiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Hichun Jacob in Pharaoh adalhah masang'in avelin phatthei abohkit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Joseph in apa Jacob ahin asopiho abonchauvin Egypt gamsunga achensah tan, chule nei le gou jong apen gam jong apha pen Rameses lhaang chu Pharaoh thupeh dungjuijin ape tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Chuin Joseph in apa ahin, asopite ahin abonchauvin ama hon angaichat dungjuijin ape sohkeijin, chule chapang neocha cha ho gei dingin jong ape jeng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Phat chomkhat jouvin neh le chah ahah lheh jeng tan, anchang kikoi jouse jong anechai gam tauve, Egypt gamsung le Canaan gamsunga mipite jouse neh le chah hahsat jeh in mipi thi dingin aum gamtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Joseph in sum le pai akhol doh jouse chu Egypt gamsung ahin Canaan gamsunga anchang achoh nau sum jouse chu Pharaoh gou kholna mun'a ahin polut tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Mipite jouse Egypt akon ahin, Canaan a kon ahin, sum le pai jouse alhahsam phat in Joseph kom'a ahung taovun ahi. Amaho akap un “Sum le pai Sana le dangka ho jouse akichai tai! an neh ding neipeh lou ule nangma mitmua thi ding kahi tauve,” atiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Hichun Joseph in adonbut in, “Na dangka hou abeitah le na gancha hou keima henga hinkaijun, keiman nangho gancha hotoh kitoh ding anneh ding kalheh peh ding nahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Hichun ama hon anneh toh lheh dingin agancha hou jouse Joseph kom'a ahin kaiyun, chule sakol hon ho ahin, kelngoi hon ho leh keltah hon ho ahin chule abong hon ho le sangan ho jouse jong Joseph kom'a alheh cheh un hichun aman kum khat anneh ding apehbe kit tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Amavang hiche kum chu akichai kit tan, kumthah ahunglhung kittan hichun ama hon a seikit tauve, “Ka pakai, nangma a kon'in imacha ka imthei tapouve. Ajeh chu ka dangka hou se la akichai tan, ka gancha hou ka bong hou la abeitan, tu hin keima hon imacha peh ding kanei tapouve, tua hi ka tahsau le ka leiset ubou aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nangma mitmua iti ka moh thi thei diu ham? Keima ho tahsa ahin ka leiset u ahin anneh ding toh lheh jeng tauvinge; ka leiset u ahin ka tahsau ahin Pharaoh soh in um tauving kate, hijeh chun kathi lou na diuvin anchang neh ding neipe uvin, chule gam leiset chu mohseh a umlou a asetna lou dingin,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Hichun Joseph in Egypt gamsunga leiset jouse Pharaoh din Egypt mite kom'a kon'in achodoh soh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mipi ho vang chu ahile khopi a kon'in gam ong thinglhang lama asol in Egypt gamsunga mun khat a pat in mun chom a asol in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Gam leiset Joseph in ana choh lou chu thempu ho gam bou chu ahi. Amaho chun Pharaoh a konna anneh akisan'u ahijeh in agam leiset u jong ajoh u ngailou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Hichun Joseph in mipite lah a ahoulim in, “Veuvin tunia keiman nangho chule nagam leiset u Pharaoh adia ka chohdoh ahitai. Keiman nangho muchi kapeh ding nang hon na phailei uva chang natu theiyu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Chule nangman chang na at teng hop nga lah a hop khat Pharaoh adia napeh ding hopli chu nangma muchi adia nakikoi diu, chule nangma ho insung mite anneh a pang ding aneocha cha ho geija kapeh nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Ama hon aphong doh un, “Keima ho hinkho hi nangman nei huhdoh peh u ahi! Chule nangma phatsah bang hi jeng hen; chule lungset tah in ka pakai pa Pharaoh soh in pangmai jeng tauvinge,” atiuvin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Chule Joseph in dan asem in Egypt gam'a tuni geihin akimang nalaiye, hichu ahile Pharaoh in hopnga lah a hopkhat ane jing nalaiyin, thempu ho a tilou chu gam leiset abon a Pharaoh a ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Hichun phat chomkhat jouvin, Israel mipite chun Egypt gamsunga Goshen lhanglam chu alodim tauvin, hichea pat chun ama hon nei le gou akilamdoh un, abol jouse'u jong nasatah in apung tul tul jengun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Hichun Jacob chu Egypt ahung lhun jouvin kumsom le kum sagi ahinbe in Jacob hin nikho abon bon'a kum jakhat le kum som li le kum sagi alhingin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Jacob chu athi tei ding nikho ahung nai tul tul phat in aman jong achapa Joseph akouvin ajah a “Namit mua nangma kalung lhaisah jouva ahile gunchu tah le kitah tah a nei bolna dingin kataipi gui noi tuh inlang Egypt gam'a neihin vui louhelna dingin kitep in; ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Keima ka hinkho ahung beiteng lungset tah in ka tahsa hi Egypt a kon'in eipodoh inlang kapu kapate kivuina mun'a neivui in,” Hichun Joseph jong akihahsel in, “Keiman nangma seibang bangin hinbol peh nang kate,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Hichun Jacob in avel in aseikit in, “Nangma kitem in,” ati, hichun Joseph akihahsel tan, chuin Jacob chu alupna a abohkhup tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Thusoh hichengse kichai nung phat chomkhat jouvin, “Napa chu alhasuh lheh jeng tai” tia Joseph ahung seipeh uleh; Joseph chu apa kimupi din achen acha teni Ephraim le Manasseh jong akipuiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Chuin Jacob chu aseipeh un, “Ven nachapa Joseph chun nangma kom ahinjon e.” Hichun Jacob atha ahung kido in alupna apat in athou doh in atoutai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Hichun Jacob in Joseph chu ahoulimpin, “Pathen hatchungnung in Luz mun'a Canaan gam'a eiki mupi chun phatthei eiboh e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Aman kakom'a ana seiyin, 'Ven nangma ka chiphat sah ding chule kapun sah ding chujongle nangma chilhah tamtah a kasem doh ding nahi. Na chilhah te chu Canaan gam hi amaho nei le gou dia atonsot a kapeh ding ahitai,' tin eihoulimpi e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Keima hung lhun masanga Egypt gamsunga nacha teni Manasseh le Ephraim hi keima a hi ding ahi. Reuben le Simeon keija ahi tobanga hi amani jong hi keiya ahi lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Hinlah chapang naosen tu khonunga peng ho vang nangma a hi ding ahitai, chule amaho se chu asopi ho goulo min lah a kisimtha ding ahi lhon e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Phatkhat lai chun, keima Paddan-aram lama kahung kinunglen Rachel chu Canaan gam'a athi tai. Keima ho Ephrath toh kikah gamla thim lheh nalaiyin lungkham tah in Rachel chu Ephrath (chehi Bethleham ahi) lampi pam a kahin vuitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Hichun Jacob in chapang teni chu aven “Hiche teni hi nangma chapa ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph in adonbut in “Heng'e,” “Hiche chapa teni hi Pathen'in Egypt gamsunga eipeh ahi.” Jacob in adonbut in “Amani chu keima kom'a hinpui nai uvin, phatthei kaboh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jacob chu akum atam phat in amittha jong alhasam lheh jeng tai. Ajeh chu aha muchen jou tapoi; hichun Joseph in acha teni chu apa kom Jacob nai deuvin ahin puijin chuin apan amani chu achop in akoiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Chuin Jacob in Joseph kom'a aseiyin, “Keiman nangma maichang mukit dinga hi kana kiginchat lou ahitai, ahin tuhin Pathen'in nacha teni jong eimusah tai!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Hichun Joseph in acha teni chu apa khup a kon'in akhindoh in amai in tollang angan abohkhup tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Chuin acha teni chu Jacob masanga agoltoh e. Akhut jet lamin Ephraim chu Jacob khut veilama chun akailut peh in, chule aveilam in Manasseh chu Jacob jetlam a akailut e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ahin Jacob in akhut apenton aluchung lhon'a akhut angamtai. Aneojo hijongleh akhut jetlam chu Ephraim achunga angam tan, chule apeng masa ahivangin Israel in akhut veilam chu Manasseh chunga angam tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Hichun Joseph phatthei aboh in hitin aseiye, “Ka Pathen kapu Abraham kapa Isaac masanga lamkai jingpa ka Pakai kelngoi chinga hung pang jing ka hinkho pumpi tuni geiya eipui hoipa; ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Thil gilou tinchenga konna eina lhatdoh jing vantil chun chapang teni hi phatthei hin boh hen; chule amani chunga hin keima min le kapu Abraham min, kapa Isaac min hung kihedoh jing jeng hen; chujongleh amani hi leiset vaipi jalah a mipi atama tam in hung pung lhon hen,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Ahin Joseph chu apan akhut jetlam Ephraim chunga angap jeh chun alung lhaimo lheh jenge. Ahin Joseph in apa khut chu atuh in ajetlam chu Manasseh chunga angap sah in, akhut veilam chu Ephraim chunga angap sah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","“Ahipoi, Hepa,” ati. “Amapa joh hi apeng masapa ahi. Na jetlam chu Manasseh chunga hin ngamin.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Amavang apa Israel anompoi, “Ka henai, ka chapa; kanai.” tin adonbut e. Manasseh jong nam len hung hintin, ahin anaopa ama sanga hung lenjo ding ahi. Chule ama chilhah ho chu nam tamtah hung hi diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Hichun Jacob in chapang teni chu hiche phattheina toh aboh in: “Israel miten phatthei akiboh teng ule namin hi apat diu ahi. 'Pathen'in nangma hi Ephraim le Manasseh bangin na lolhinsah hen,'” ati diu ahi. Hiti chun, Jacob in Ephraim chu Manasseh masanga akoi tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Hichun Jacob in Joseph kom'a aseitai, “Ven keima kathina ding anaitai, ahin Pathen'in naumpi intin, chule Canaan a napu napate gam'a nanung puikit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Chule hiche kal a chu nasopi te ho kapeh sanga lenjo ka chemjam le ka thalpi a Amor mite gam kalah chu kapeh nahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Hichun Jacob in achate jouse akou khom in hitin aseiye, “Keima naivel a hung kikhom un, chule keiman nangho thuguh ka seipeh ding nahiuve, khonunga ipi hunglhung ding ham na seipeh uvinge,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Hungun chule ngaijun, nangho Jacob chate ho; napau, Israel thusei ngaiyun.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Reuben, kachapa atahpen, ka thahatpen laiya kanei, ka khanghoi laitah a kahin chule nangma amasa penna jana chang chule nangma amasapen a thahat chang nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Nangma twi kimang banga phatna najou tapoi, ajeh chu napa lupna jalkhun nasuboh tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon le Levi sopi khat ahi lhon'e, chule amanchah lhon ho chu galsatna ding bou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Keima lhagao vang amani komah jaoda maihen, chule amani tohgon jong jahda ding kanom e; ahin amani alunghan teng le mihem hinkho ahin suhbei lhon ding ahi, chule amanin golseh a bongchal akipalsah lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Jacob chate ho lah a kahop khen ding keiman Israel sunga amani chu kathe cheh ding ahitai, alunghan nalhon sapset ahitai, ajeh chu tijat umtah, alunghan nalhon jong phalou tah ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Judah nangma nasopi hon nathang-at uve. Nangman na melma te angonga na matchah ding, nasopi ho jouse nangma masanga kun cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ka chapa Judah hi keipi bahkai nou in an anneh jou pet ahi. keipi bahkai banga kitaule a lumji tobang; keipi tobang chu kon athodoh jou ding ham? ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Leng tenggol chu Judah a konin kikhen kang pontin, vaihompa tenggol jong akhanggui mite chutoh kikhen ponte, aneipa akondohna mun ahung masangse a, nam jousen ajabol ding pa chu. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Aman a sangan chu lengpi thei phunga ahen in, chule sangan nou chu abah hoipen lengpi bah a ahen in, chule apon ho chu lengpitwiya asop in chule ama von ho chu lengpitwiya asop ngim e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Amit teni chu lengpitwi sangin athimjon, chule ahatu jouse chu bongnoi sangin akangjon ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebulun chu twikhanglen panga cheng ding chule ama kom'a chu kongho kinga ding; Sidon geiya agamgi akeh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Issachar vang chu ahile sangan hattah ahi, ama chu hahsatna molni kikah a um ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Aman ngahmun khat amudoh in chule agam nop dan jong chu dei chat um ahi; hijeh chun aman thilpo dingin alengkou adon, hunam in soh dingin akipelut tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ Dan in Israel phungdang ho bang a amite chunga vai ahin hop ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan chu lampi lhanglang a gul tobang ahi, chule lampi a gulse kijam tobang ahin, ama chun sakol keng achuh le achunga toupa akinung le lhah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Keiman nangma katahsan e huhhingna kachan theina din, O Pakai!” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gad chunga mipi hon lam ajot diu ahin achaina aman amaho chunga lam ahin jot ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Asher chu anneh neng ding chule lengho nehthei ding tah akhut a soh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Napthali chu sajuhpi nou hoitah neiya kichamlhat sah ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Joseph hi lengpi thingga phatah tobang ahi, chule twinah phung thingbah ga phatah ahi, abah hon jong bang akhokhel gamtai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Thalpi kapthem hon avetda lheh un, amapa akap un chule abol genthei lheh jeng uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ahin amapa thalpi alhou lheh in, chule Kelngoi chingpa, Israel te Songpi, Jacob Thahatna chun aban thahat sah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Napa panpi Pathen'in van chunga phattheina tincheng, chule leithol noilanga twi dim bang phattheina, chule noitwi le naobu a phattheina jouse naboh tahen. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Napan phatthei nabohna ho chu masanga napute phattheina ho sangin phatthei joh hi maihen, chule molsang pen ho sangin sangpen maihen. Hiche phattheina ho jouse hi Joseph chunga um jing tahen, ajeh chu ama hi asopite lah a dinga leng cha ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin chu Sial tobang ahi, ajeh chu jingkah lam le amelmate chu aval lhum jin nilhah lam teng alotup ho chu ahomkhen jenge.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Amaho se hi Israel phungsom le phungni ahiuve, hiche thucheng ho hi apan aseipeh u ahi; amaho jouse chu phatthei aboh in chule kilhahna thucheng aneiyin, chule amaho jouse khat khat in ama hina cheh in phatthei aboh cheh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Hichun Jacob in ahilchah un, “Kapu kapate kom jon a keima thivah ding kahitai. Hit mi Ephron louva kapa le kapu kivuina songko a chun neihin vuikhom’un. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Hiche songlhan chu Machpelah loumun Mamre nisolam Canaan gamsunga um ahin, Abraham'in lhan mun a man jing dinga Hit mipa Ephron henga ana choh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Hiche mun'a chun Abraham le Sarah akivui lhonin, chule hiche mun chu Isaac le aloinu Rabekah jong akivuijin chule keiman jong hilai mun a chu Leah kana vui ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Hiche gam chu phaicham kotong lam chu kapu Abraham'in Hit mipa kom'a ana choh doh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Hichun Jacob chu achapate athulhah chaijin jalkhun chunga akeng teni asep doh in ama ahaitan tai, chuin ama amite to akigom tan tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Joseph chu apa senan akineiyin kap pumin akoijin achop in ahi.. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Chuin Joseph in asohte louthem ho chu apa longdamsa tom din thu apen, hichun louthem ho chun atom tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Hitobanga longdamsa kitom chu nisom li tobang lut jia ahi; chule Egypt mihon ama chu ni somsagi alunghem piuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Hichun lunghem na nikho ho chu ahung kichai tan, Joseph in lengpa Pharaoh insung mite chu ahoulimpin, “ Lungset tah in kadei khat Pharaoh kom’a ka khelin nei seipeh uvin. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Kapa in adamlai in eina kihahsel sah e. “Aman kajah a, “Ngaijin, keima ka hinkho beivah ding ahitai. Ka tahsa hi Canaan gam'a hin nung lhut teiyin lang, chule keima kivuina dia lhan ka kisemna mun'a neivui tei ding ahi.' Hijeh chun lungset tah in neisol inlang kapa ga kivui inge. Kavui chai tengleh kinomsot louva kahung kile pai ding ahitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Joseph ngehna chu Pharaoh in aphasah tai. “Napan nangma nakitep sahna bangin chen lang gavui tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Hichun Joseph chu apa vui din achetan ahile Pharaoh in alhonpi dingin Egypt gamsunga alen alal ho ahin asohte ahin, asemang pachong ho jouse toh asol than ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Joseph in a insung mite ahin jouse apuijin ahi. Ahin chapang neocha ho leh gancha ho vang Goshen a adalhauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Sakol kangtalai tampia mihonpi chun Joseph alhonpi uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Jordan vadung koma Atad changphol ahunglhun un Joseph pa puldouna kin lentah nisagi sungin amangun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Agamsung mi, Canaan miten Atad changvohna mun'a amaho lunghem tah a aumu chu amu uvin, hiche mun chu (Jordan toh kinai ahi) Abel- Mizraim, tin akhel uvin, hichu “Egypt mite dia nasatah a puldouna mun” tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Hichun Jacob chaten apau thupeh bang bangin abolpeh un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ama hon apa longdamsa chu Canaan gam'a apolut tauvin Mamre kom'a Macphelah loumun a Abraham'in hiche mun chu Hit mipa Ephron kom'a atonsot a kivui theina dinga ana choh na mun achun avui tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Jacob avuijou chun Joseph ahin asopi te ho jouse chule midang akilhonpi jouse Egypt gam'a ahung kinungle tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ahin tua hi amaho apao umtah lou jeh chun Joseph sopi ho chu hatah in ahung tija tauvin, ama hon aseiyun, “Joseph chun alunghanna ho eihon ina bolset nau jouse chu ahin phulah ding ahi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Hijeh chun ama hon hiche thucheng ho hi Joseph athot tauve: napan athi masang chun hitin eina thulhah uvin ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Na heng'a kasei diuvin: na sopi ten na chunga thil gilou abol uva suhkhel anei nau chu ngaidam in.” Hijeh chun, keiho napa Pathen sohten, ka suhkhel nau chu nei ngaidamun tia katao u ahi.” Hiche thu thot amu chun Joseph akap tai. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Hichun asopi ho ahungun Joseph masanga akun tauvin ahi. “Ven, keiho hi nasohte kahiuve.” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ahin Joseph in, “Nangho tija hih un, keima Pathen beh kahia nangho kagimbol ding ham?” tin adonbut e. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Nang hon kachunga thil phalou nana gong un ahin Pathen'in aphalam tah in ahin gong e. Hiche panmun chan eilhut a tua ka mite mihem tamtah hinkho huhhing'a um thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ahipoi, nangho kicha hih un. Keiman nangho nahiuvin nachate hou ahin kavetkol jom jing diu ahi,” ati. Chuti chun aman asopi ho chu nunnem tah in alhamon kit un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Chuti chun Joseph ahin asopi te ho jouse Egypt a acheng jing uvin ahi. Joseph chu atahsa kum jakhat le som alhing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Chuin Joseph in khang thum channa geiya Ephraim chilhah ho jong amun chujongleh Joseph thagui a peng Manasseh chapa Machir chate jong ana mupeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Chuin Joseph in asopite jah a, “Keivang kathina ding anailam tai,” “ahivangin Pathen'in nangho nahungvil teiyun tin, Egypt gam a kon hin Abraham, Isaac chule Jacob henga ana kihahselna gama dingin nahin puitou vunte,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Hichun Joseph in Israel chate chu aki tepsah in chuin aman hitin aseiye, “Pathen'in nahin kithopiuva hiche mun'a konna nahung pui teng ule hiche mun'a konna kagu kachang ho hi na nungpoh teitei diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Hichun Joseph kum jakhat le kum som ahin ahinkho abeitai. Hichun Egypt miten Joseph longdamsa chu atom un athikong chu Egypt gamsunga thingkong sunga akoi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Israel mite (hichu, Jacob chapate), ama insung mi cheh hin kipuija Egypt gamsung'a apau toh kitollut ho min chu: ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Reuben, simeon, Levi, Judah, ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issachar, Zebulun, Benjamin, ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dan, Naphtali, Gad chule Asher amaho cheng hi ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Abonchauvin, Egypt gamsung'a Jacob chilhah chengse chu som sagi alhing'un chule Joseph vang agamsung'a ana um jingsa ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Phat chomkhat jouvin, Joseph le asopi chengse athigam tauvin, hiche khang mite se chu akichai tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Ahinlah ason achilhah teu, Israel chate chun tu le cha tampi anei tauvin apung lheh jengun, ahung hatdoh cheh cheh un gamsung pumpi ahin lodim tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Achainan, Egypt gamsunga chun Joseph chung chang thu le anatoh ho hephalou leng thah khat thaneina ahung chang tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Amapa chun amite henga thu aseijin, “Vetem'un, Israel mite hi eiho sang'in apung'un chule eiho sang'in ahat lheh jeng tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Amaho hi apunbe louna diuvin, tohgon khat nei tau hite. Achuti louva ahile hung hatdoh untin, chule gal hung um taleh, imelma teu ahin panpi diu eihin dou uva gamsunga kon'a jamdoh ding ahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Hijeh chun Egypt miten Israel chate jouse soh in amangcha tauvin, achung uva tohvaihom mikhanse tah tah ho apansah un, chutobang bolgimna soh natoh a kon'a chu suhnem ding akinem'un, hunam chang'in lengpa thil kholna ding Pithom leh Rameses khopi chu asah sah uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Ahinlah Egypt mite'n amaho asuhgim chan'un apunbe uvin akithejal cheh jo tauvin ahi, Egypt mite chu kichat nan aum jo tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Chutah chun Egypt miten Israel mite chu ngailutna beihel'in thohgim hahsa athohsah uvin na atohsah un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Aki manchahna jouse uva gimna alhun sah un, bon ngan achilsah un, leilhang asemsah un, loujaova natoh jouse atohsah un, atoh nalam jouseuva gimbolna achansah tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Chuin Pharaoh, Egypt lengpan Hebrew mi nao dom teni Shiphrah leh Puah henga hiche thupeh hi aneiyin: ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Hebrew numei hon nao anei uva nao dom'a napan teng lhon le, hichu phatah in vechil lhonin lang, naosen chu pasal ahileh natha lhon ding; numei ahile vang na hinghoi lhon ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Amavang naodom teni chun Pathen agin lhon jeh chun, lengpa thupeh chu anahsah lhon tapon, naosen pasal'a hungpeng lha ho jong chu ahinghoi lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Chuin lengpan naodom teni chu aheng'a akouvin, “Ipi jeh a hiche hi nabol lhon hitam?” tin adong'in, chule “Ipi jeh a naosen pasal ho chu, nahinghoi lhon ham?” tin ajah lhon'a aseiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Naodom tenin adonbut in “Hebrew numei ho hi Egypt numei hotoh abang pouve, amaho hi athohhat un aheng'u akilhun masang'in amaho le amaho bailam tah in ana kidoplhah jitauvin aphatchan kalapji lhonpoi,” tin asei lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Pathen chu naodom teni din aphalheh jengin, Israel te chu apunbe cheh cheh tauvin ahile, athanei nau jong ahung hatdoh cheh cheh jeng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Naodom teni in Pathen agin lhon jeh chun, Pathen'in amani chu ama ama ding cheh insung asem dohpeh lhon'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Chuin Pharaoh in amite jouse hiche thupeh hi aneiyin: “Hebrew naosen'a penglha pasal kiti phot chu Nile Vadung lam'a na pailhah jeng diu, ahinlah numeiya hung peng chengse vang chu hing hoiyun,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Hiche phatlai hin, Levi insung'a kon pasal khat leh Levi insungmi numei khat ma akicheng lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Numeinu chu ahung gaijin chapa khat ahing tai. Amanun achapa chu aven ahile lunglhai umtah naosen ahin, lhathum sung'in asel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ahivang'in amanun achapa chu asel joulou phat in, sinkhup Papyrus naang'a kisa khat agalan twilutna lou dingin avonglai jouse ahuhbit sohkeiye. Chuin sinkhup sung'a naocha chu akhum'in Nile Vadung pang phaipheng lah achun alha lut tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Chuin naosen a unu jong gamla thim'a kon'in adingin naosen chu i-atidem tin agalvet in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Chujouvin Pharaoh chanu vadung'a kisil dingin ahung suh tan, asottolle ho jong vadung pang achun avahle uvin ahi. Chuin amanun phaipheng phung lah a sinkhup chu ahin mudoh tan, aga ladin asohnu chu asol tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Lengpa chanun jong sinkhup chu ahongdoh in ahile, naocha chu amu in ahi. Chuin naocha chu akap in, amanun jong naocha chu avoujang natpi lheh in, “Hiche hi Hebrew mite cha khat hitei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Hichun naosen sopinun jong lengpa chanu heng ahin naije. “Keima kache a Hebrew numei khat naosen don ding kagahol peh ding ham?” tin adong'e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Lengpa chanu in jong, “Henge, gapui jin!” tin adonbut in, numeinu jong ache in naosen hingnu mama chu aga puiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Chuin lengpa chanu'n jong naosen hingnu jah a aseijin. “Naosen hi lanlang neidon peh in, Keiman nadon man kapeh ding nahi,” ati. Chuin numeinu in jong naosen chu a-inlam'a adom'in amapa chu adon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Khonung'in, chapang pa jong akhanglen tan ahile, anu in amapa chu Pharaoh chanu henga ahung thahkit tan, achapa mong mong dingin Lengpa chanun amapa chu amin Mose asah tai, ajeh chu amanun aseijin, “Keiman amapa hi twi lah a kon kaloidoh ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kum phabep ache nungin, Mose jong ahung khanglen tan, amapa jong asopiho vil din achetou tan, aman jong asopi Hebrew mite hunam'a na atohsah nau aga mudoh tai. Agavil pet chun, Egypt mikhat in asopi Hebrew mikhat chung'a akhut alha chu amupaijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Akimvel avet a koiman eivepoi, ti aphot chen phat in, Mose'n Egypt mipa chu athat in neldi lah a asel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Ajing nikho in, asopi ho vildin Mose apotdoh kit tan ahile, Hebrew mini akinah lhon aga amun ahi. “Ipi jeh a nagolpa navoh ham?” tin kinah hin panpa heng'a chun Mose'n aseiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Amapan adonbut in, “Koiham nangma keiho chunga leng'a na pansah le thutan dinga thaneina nape? Janhi a Egypt mipa natha banga chu keima jong tha ding neigot ham?” tin aseiyin ahileh, Mose jong akichan “Ka thilbol mijousen ahetai,” tin angaiton ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Mose thilbol chu Pharaoh in ahin jadoh tahbeh tan, chuin Mose chu tha ding ago tan ahi. Ahivang'in Mose jong Pharaoh angsung'a kon'in ajam'in Median gamsung'a cheng din achetai. Median alhun chun Mose jong twikul pang'a atou tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Tun Median thempupa chun chanu sagi aneiyin amaho chengse chu apau ganchahon ho dingin twi kongho chu athal ngai bang'un ahung thal dim'un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Ahinlah kelngoi ching midang phabep ahung uvin amaho chu anodoh un ahi. Hichun Mose jong achomdoh jengin kelngoi ching hoa kon chun numei chapang ho chu ahuhdoh tan ahi. Chuin amapan amaho ganchate a ding twi chu athal peh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Numei chapang ho chu apau Reuel heng ale lhun uchun, amapan adongun, “Ipi jeh a tuni nahung kimale uham?” atin ahile, ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","ama hon jong adonbut uvin, “Egypt mi khat in kelngoi ching hoa kon'a eihuhdoh uva, chule amapa chun keiho ding le igancha hon houva ding twi eithal peh jeh u ahi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","“Ahile amapa hoiba ham?” tin apauvin adong'in, “Ipi dinga amapa chu chukom'a chu nahin dalhah uham? Ahung'a ankong isokhom diuvin gakouvun,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mose'n jong akounau chu asanpeh in, thempupa toh chun hiva chun acheng khom tan ahi. Hiche phatlai chun, Reuel in achanu Zipporah chu Mose ji dingin ape tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Phat chomkhat jouvin, amanun chapa khat ahing'in, Mose'n Gershom asah tai “Ajeh chu keima hi gamchom beh a khopem kahi,” tina ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kum phabep ache nungin, Egypt lengpa athitan ahi. Hinlah Israel te chu soh a kihen ohna noiya pohgih poa khoisa jing nalai ahiuve. Panpi ngaiyin akap un, aka awgin'u chu Pathen angsung alhung tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Akhoisat nau Pathen'in aja tan, chuin Abraham, Isaac leh Jacob heng'a akitepna ahin geldoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Aman Israel mite chu avesuh in, chuin tunvang toh phat ahitai ti chu ahe tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mose’n nikhat anupa pa Midian thempu pa Jethro kelngoi achin laijin, kelngoi hon chu gamla tah gamthip lam'a apuiyin, Pathen molsang, Sinai mol lam'a chun ahung tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Hiche laimun'a chun Pathen vantil meikong in hamboh lah a ahung kilah in, Mose in lungdong tah in aven ahi. Hamboh chu akong jengin hinlah akavam deh pon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Chuin Mose ama leh ama akihoulim in, “Hiche hi datmah umtah thil ahiye, ipi jeh pentah a hiche hamboh khu kavam lou ahidem? kache a kavet tei angaiye” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Hichu vedingin Mose’n hilam chu anailut jep jep e ti Pakaiyin amu phat in, Pathen'in hamboh lailunga kon'in, “Mose! Mose!” tin akouvin ahile, Mose in jong adonbut in “Keima hiva kaum'e,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","“Hin nailut hihbeh in” tin Pakaiyin agih tan ahi. “Nakeng chot kisut in, ajeh chu nangma muntheng'a ding nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Keima napa dinga a Pathen kahi - Abraham Pathen, Isaac Pathen, leh Jacob Pathen kahi,” ati. Hichu Mose in ajah phat in amai akhutai, ajeh chu Pathen avet ngamlou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Chuphat in Pakaiyin ahenga aseijin, “Egypt a kamite kibol gimna ka muchen tai. Achung uva tohvai hom hon asuhgim nau aka awgin'u kaja tan ahi. Heng'e, athohgim nau abonchan ka hechen tai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Hijeh a chu Egypt mite thaneina noiya kon'a amaho huhdoh ding le Egypt gam'a kon'a gampha tah, khoiju le bongnoi lkonna gam hichu - Canaan mite, Hit mite, Amor mite, Periz mite, Hivi mite chule Jebus mite tua achenna'u gam'a puilut dinga Keima hikom'a hung kumlha kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Vetan! Israel chate ka awgin ka angsung ahunglhung tai, chule Egypt miten asuhgim nau kichen tah in kamutai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tun che jengin, ajeh chu Keiman nang hi Pharaoh henga kasol nahiye. Kami Israel te Egypt gam'a konna nahin puidoh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Hinlah Mose Pathen heng'ah akiphin in, “Kei koi kahia Pharaoh henga kaga kilah ding ham? Kei koi ka hia Israel te Egypt gam'a kon'a ka hin puidoh ding ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Pathen'in adonbut in, “Keiman kaumpi jing ding nahiye. Keiman kasol nahina nangma dinga melchihna hiche hi ahi: Nangman miho chu Egypt gam'a kon'a nahin puidoh tengleh, hiche mol tah a hi Pathen nahou ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Ahivang'in Mose akiphin'in, “Keima Israel chate henga kachea ajah uva, ‘Napu napa teu Pathen'in na heng uva eihinsol ahi,’ tin sei leng ‘Amin ipi ham?’ tia eidoh diu ahi, chuteng amaho chu iti ka donbut ding ham?,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Pathen'in Mose adonbut in, “KEIMA HI KEI,A KAHI JENG'E. Hiche hi Israel te heng'a seipeh in: Keima chun naheng uva eihinsol ahi,” tin ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Pathen'in jong Mose heng'a aseiyin, “Hiche hi Israel te heng'a seipeh in: Yahweh,* napu napa teu Pathen - Abraham Pathen, Isaac Pathen, chule Jacob Pathen'in - naheng uva eihin sol ahi. Hiche hi ka tonsot min ahi, akhang akhang'a nageldoh jing diu kamin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Tun chenlang Israel sung'a upaho gakou khom tan. Aheng uva seipeh in 'Yahweh, napu napa teu Pathen - Abraham, Isaac, chule Jacob Pathen - kahenga akilah in ahi. Aman kajah a aseiyin, “Keiman naichan kanave jing'un, chule Egypt miten na engbol nau keiman kamui. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Keiman nangho Egypt a na genthei thoh nauva kon'a huhdoh dinga kakitep ahi. Keiman khoiju leh bongnoi lkonna gam'a chu kapuilut ding nahiuve - hichu Canaan mite, Hit mite, Amor mite, Periz mite, Hivi mite chule Jebus mite tua achen nau gam khu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Israel upahon nathusei angai diu ahi. Chuteng nang leh Israel upa chengse Egypt lengpa heng'a nache tei uva, ‘Pakai, Hebrew mite Pathen chun, eikimupi uve. Hijeh chun lungset tah in nithum sung'a gamthip lam'a kakhol jin uva Pakai ka Pathen'u henga kilhaina kasem dingu ahi” tia aheng'a nagasei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","“Amavang Egypt lengpa chu khut thahat in ano kahse a nahin soldoh lou diu keiman kahei,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","“Hijeh a chu Keiman kakhut ka lhan a, chule Egypt mite kajep ding, alah uva thil kidang jouse kabol ding ahi. Ajona le Aman nahin soldoh ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Chule keiman Egypt mite mitvet a khotona kahin chan sah ding nahiuve. Ama hon thilpeh nahin peh dingu chuteng khut goh keova na dalhah lou diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Israel numei jousen akinaipiu Egypt mite leh a in'uva um gamchom numei ho kom'a sana leh dangka chule ponsil akithum cheh ding'u ahi. Na chanu teu leh na chapa teu hiche ho chu navon peh dingu, Egypt mite haosatna jouse na holhah peh dingu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Hinlah Mose avel'in akiphin kit in, “Ei tahsanlel uhenlang ka thusei ngai hih uleh iti tantem? 'Nangma heng'a Pakai akilah kha him him poi' tiu leh iti tantem?” ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Chuin Pakaiyin ajah a, “Nakhut a nachoi chu ipi ham?” tia adoh le, Mose’n adonbut in “Tenggol ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Pakaiyin ajah a, “Tol'ah seplhan,” ati. Hichun Mose’n tenggol chu tol'ah asep lhan, chuin gul ahung kisoh tan! Mose anung chop jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Chuin Pakaiyin aheng'a, “Nakhut lhangdoh inlang ameiyin man tem'in” ati. Hichun Mose’n akhut alhaangdoh in aman in ahile, akhut ah kelngoi chinna tenggol ahung kinung sodoh kit tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Pakaiyin ajah a, “Hiche melchihna hi nabol ding ahi. Chuteng apu apateu Pathen - Abraham Pathen, Isaac Pathen chuleh Jacob Pathen chu nangma heng'ah akilah mong'e ti ahin tahsan dingu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Chuin Pakaiyin Mose heng'ah, “Tun nakhut chu na sangkholchol sunga nadip a chun koiyin,” atile, Mose'n jong akhut chu asangkholchol sunga akoiyin, akhut chu alah doh kit a ahile, akhut chu aphah in buhbang bangin abang jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Pakaiyin, “Tun nakhut chu na sangkholchol sunga nadip'a avel'in koikit tem in,” atin ahi. Hijeh chun Mose in jong akhut chu anung koilut kit in, chuin ala doh kit in ahile atidang bangin atahsa adamsel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Pakaiyin Mose heng'a aseijin, “Ijem tia nangma na tahsan lou uva chule melchihna masapen jeng'a jong atahsan theilou uva ahile, melchihna ani channa a atahsan diu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Chule hiche melchihna teni jeng'a jong atahsan thei lou uva ahile, Nile Vadunga kon'in twi themkhat la inlang tolgo laiya sung lhan. Hichu nabol teng, Nile Vadung twi chu tolgo laiya thisan kisoh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Ahin Mose Pakai heng'a ataovin, “O Pakai, keima thusei them kahipoi. Achesa phat hihen, chule tujengin jong, kahenga thu nasei nung hijongleh, kalei a-oh jin, chule ka thusei angongkai jie,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Hichun Pakaiyin Mose adong paijin, “Koiham mihem kam sem? Koi ham mihem apaothei ahilouleh apaomo, kho jathei ahilouleh ana ngong, kho muthei ahilouleh mitcho umsah nadia gellhuhna sem ji? Hichu Keima, na Pakai kahi hilou ham? ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tun chen! na paodohna chan'a Ka umpi ding, chule na thuseina chan'a Keiman kalamhil ding nahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Ahinlah Mose avel in Pakai heng'a ataovin, “Pakai, lungset tah in! Midang khattou sol tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Chuin Pakai Mose chung'a alunghang tan, “Aphai,” ati. “Na sopipa Levi mi Aaron um'a hilou ham? Aman lei kileh pel'in thu aseitheiye ti keiman kahei. Chule vetan! Tun nang toh kimuto dingin ahung tai. Nang toh kimu ding lung thanopna a dim ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ama chu houlim pin lang, thu ho hi akamsung'a mop in. Keiman na paodohna chan lhon'a kaumpi ding, na ni lhon'a na thilbolna chan lhon'a nalamhil lhon nang'e, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","“Aaron hi nangma dinga miho lah a thuseija pang ding ahi. Nangma dinga nakam sung'a pang ding chule ama ding’a nangma hi Pathen khel’a nadin ding, aman ipi asei ding nahil ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Na kelngoi tenggol hi kichoiyin lang, melchihna bol dinga ka thumop chengse bolna dingin mang chan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Hijeh chun Mose inlam'a anu-pa-pa Jethro henga akile tan ahi. “Lungset tah in kasopi ho heng lam Egypt gam'a kile tange,” tin Mose’n aseiyin, “Hing nalaiyu hinauvam tijong hepha lou kahi,” ati in ahile, Jethro in “Lungmong in chen,” tin adonbut in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Mose in Median adalhah masang'in Pakaiyin aheng'a aseiyin, “Egypt a kile tan, ijeh-inem itileh nangma nathat nom ho abonchauvin athigam tauve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Hijeh chun Mose in ajinu leh achate akipuiyin, sangan chunga atousah in, chuin Egypt gam'a akile tauvin ahi. Akhut a Pathen tenggol chu achoiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Pakaiyin Mose heng'a aseiyin, “Egypt gamsung na lelhun teng, Pharaoh henga chen lang keiman bol dinga thuneina kapeh bangin thil kidang ho jouse abonchan gabol'in, ati. Ahinlah Keiman alungthim kasuh tah ding chuteng miho chedoh ding aphal louding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Chuteng nangman aheng'a nasei ding, 'Hiche hi Pakai thusei ahiye: Israel hi keima chapa peng masapen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Keiman thu kapeh nahi, “Ka chapa soldoh tan, chuti leh aman keima eihou thei ding ahi.” Ahivanga nangman nahsah louva nakoi jeh in, tua hi keiman na chapa amasapen katha ding ahitai!”' ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Egypt gam ajot laiyun Mose leh a insung mite jan geh din ngahmun khat a akinga tauvin, Pakaiyin amapa chu akimaitopin, amapa chu atha pai ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Amavang Mose jinu Zipporah in songgiel chem alan achapa chep atanpeh in ahi. Amanun chep chu amapa keng atohkhah sah in hiti hin aseiye, “Tua hi nangma hiche thisan jal'a kei dia moulang nahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","(Amanun “thisan jal'a moulang” tia asei chu chep tan chu aseina ahi.) Chujou chun Pakaiyin amapa chu adalhatai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Tun Pakaiyin Aaron henga, “Mose kimupi din gamthip lam'a khun chedoh in,” ati. Hijeh chun Aaron Pathen molsang lam'a achen Mose aga kimupi in, a angkoiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Hichun Mose in jong Aaron jah a Pakaiyin sei dinga athupeh jouse ajah a aseipeh tan ahi. Chule bol dinga athupeh thil kidang melchihna ho chung chang ho chu aseipeh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Chuin Mose le Aaron Egypt gam ahung kile lhon'in Israel upa jouse abonchan akoukhom lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron in Pakaiyin Mose athumop chengse chu abonchan amaho jah a aseipeh sohkeiyin, Chule Mose in melchihna thil kidang ho chu aheng uvah abol in avetsah sohkei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Hichun Israel miten Mose leh Aaron chu Pathen'in ahin sol mong ahi ti atahsan tauve. Pakaiyin amaho chung chang agelkhoh in agim hesoh nau amutai ti ajahdoh phat un, abohkhup uvin ahou tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Hicheng jouse chu Israel upaho leh lamkai chengse heng'a aseipeh chai lhon phat in, Pharaoh heng'a Mose le Aaron achelhonin aga sei lhon tai. “Hiche hi ahi Israel te Pakai, Pathen'in asei chu: Gamthip noiya kami Israel ten keima jabolna a kut abolna diuvin sol tauvin,” tin amapa henga asei lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Pharaoh in ale donbut in, “Hichu hi mong ham? Pakai kitipa chu koiham? Keiman ipi jeh a ama thu kangaiya Israel te chu ka soldoh ding ham? Pakai kitipa chu keiman kahe khapoi, chule keiman Israel te ka soldoh louding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ahinlah Aaron leh Mose apang tinten lhonin, “Hebrew mite Pathen chun eikimupi lhon ahi,” tin aphongdoh lhon'e. “Hijeh chun ni thum sung'a gamthip a kache uva Pakai ka Pathen'u henga kilhaina kaga semna diuvin neisol tauvin. Achuti louva ahile, Pakaiyin gamna hise ahinlan sah ding ahilouleh chemjam'a eitha gam diu ahi,” ati lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Pharaoh in adonbut in, “Mose leh Aaron, ipi dinga mipite anatoh nauva konna alungu nalahmang lhon'a nasuhboi lhon ham? Na kitoh kit tauvin! ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ven, “Gamsung'a namite hi tampi ahiuvin, ahin nangnin amaho hi anatohnau natansah lhon tai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Hiche nikho mama chun Pharaoh in Egypt mite dinga soh natong vaipo ho leh Israel lamkai ho chu hiche thupeh hi apetan ahi: ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Chehlhang semna dingin changpol pe tahih un. Ama ama cheh kihol sah tauvin! ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ahivang'a masang'a nabol sah ngai bang uva chehlhang nasem sah jat u kibanga nasem sah dingu ahi. Achanvou u lhom jong lhom sah hih un. Athase gam tauve. Hijeh a chu ama hon, 'Cheu hitin I-Pathen'u henga kilhaina gasem tau hite,' tia asap jengu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Achung uva natoh hahsa cheh koibe peh un. A-ulsau lonsah un! Hichun jou thu angaisah louna diuva ahil dingu ahi!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Hichun soh natong vaipo ho leh natong lamkai ho chu acheuvin mipi ho heng'a aseipeh tauvin: “Pharaoh in asei hiche hi ahi: Tu apat changpol kapeh talou ding'u nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Cheuvin lang nangma nangman gakipoh uvin. Hoilai mun hijongleh namu thei chan'un gakihol tauvin. Ahinlah masanga chehlhang jat mama semdoh dingu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Hijeh chun mipi jong Egypt gamtin'ah changpol holnan akithe cheh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Chomkhat jouvin, Egypt natong vaipo hon gahtah in aboljom nalaiyun, “Changpol kapeh laiyuva nasem bang uva, niseh leh chehlhang nasem doh ding jat u nasuh bulhit tei ding'u ahi” tin ngehna aneiyuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Chuin Israel natong lamkaiya anganse hou chu ajep uvin, “Ipi dinga janhia chule tunia jong na tohdoh diu jat na tohdoh louvu ham? tin ngehna aneiyuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Chuphat in Israel natong lamkai cheng Pharaoh heng'a ache un chule atao uvin, “Lungset tah in nasohte hi hitin neibol hih un,” tin athum un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","“Changpol la neipe pouvin, ahinlah soh vaipo hon angeh nalaiyun “chehlhang sem'un!” tin eivo jing'un, ahinlah hiche hi keiho themmo ahipoi! Nangma mite ho mama ngoh ding ahijoi!” tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ahivang'in Pharaoh apeng jah jengin, Thase! Nangho thase nahiuve! Hijeh a chu hitia hi naseiyu ahi, 'Cheu hitin chule I-Pakaiyu heng'a kilhaina gatoh doh ute natiu ahi.' ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","“Tun natong din kileuvin! Nangho changpol na kipelou diu, ahivang'a chehlhang nasem doh diu jat lhingset a nasem doh teitei ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","“Niseh a chehlhang nasem jat u nakemsuh sah theilou ding'u ahi,” ati jeh uchun Israel natong lamkai hon nasa tah a bolgim'a aum'u chu amu tauvin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Pharaoh thutanna insung ahin dalhah phat un, pam lang'a amaho ana ngah Mose leh Aaron chu akimupi uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Chuin natong lamkai ho chun ajah lhon'ah, “Pakaiyin nachung chang thu lhon tan henlang gotna nape lhon hen, ijeh inem itileh Pharaoh leh alhacha ho angsung'a nei suh namset u ahi. Nangnin amaho khut a chemjam na koipeh lhonin, nei thagam sah kigot un ahi!” ati lhon e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Chuin Mose Pakai heng'a akile in akiphin tai, “Ipi dinga namite chung'a hitobang gimna hi nalhun sah hitam, Pakai? Ipi dinga keima nei sol ham?” ");
INSERT INTO tczchongthu_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nangma thalheng'a thusei dinga Pharaoh heng kahunga kipat namite chunga akhanse cheh cheh jon ahi. Hinlah nangman amaho huhdohna din ima nabolpoi!” ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Hichun Pakaiyin Mose henga aseiyin, “Tua hi keiman Pharaoh chung'a ipi ka bol'am namu ding ahi. Aman kaban thahatna ahin hetdoh teng, aman mipi ho chu ahin soldoh ding ahi. Dihtah a, aman hunam a agamsung dalha dinga ahin soldoh ding'u ahi!” ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Chule Pathen'in Mose henga aseiyin, “Keima Yahweh - 'Pakai' kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Abraham henga, Isaac henga, chule Jacob henga El-Shaddai - 'Hatchungnung Pathen' - aheng uva ka kilah in ahi, hinlah kamin, Yahweh, ahi ti amaho heng'a kaphong doh poi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Chule kholjin miho banga achen nau gam, Canaan gam peh dinga kakitepna keiman amaho toh avel'in namdetna kanei kit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Israel mite, tua Egypt mite soh a pang ho thohgimna kaja nai ti hi naginchat mong thei ahi. Chule amaho toh ka kitepna jong phatah in kahe jing nai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Hijeh chun, Israel mite henga seiyin: 'Keima Pakai kahi. Egypt gam'a nasoh tan nauva kon'a ka huhdoh ding chule na thohgim nauva kon'a kalha ong ding nahiuve. Keiman nangho ban thahat tah le thutanna gimnei tah a kalhatdam ding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Keima mite nahi mong uve tia kachu dingu, chule na Pathen'u kahi ding ahi. Chuteng keima hi nangho Pakai na Pathen'u Egypt gam'a na thohgim nauva kon'a nahin lha ong pau chu kahi nahin hetdoh dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Keiman Abraham, Isaac, chuleh Jacob heng'a kaki hahselna gam'a chu ka puilut ding nahiuve. Nangho goulo ding mong monga kapeh ding nahiuve. Keima Pakai kahi!'” ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Pakaiyin asei bangin Mose in jong Israel mite heng'a aseipeh in, ahinlah ama hon avel'in angainom tapouvin ahi. Ajeh chu amaho asoh chan nauva aki suhgim'u chun alungphatmo sah val tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Chuin Pakaiyin Mose heng'a aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Egypt lengpa Pharaoh heng'a leche inlang, Israel miten na gamsung dalha tauhen tin aheng'a gaseiyin.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","“Ahinlah Pakai!” Mose anompon, “Ka miten ka thusei eingaipeh tapouvin tin. Iti Pharaoh in ka thu ngai mong nante tia kakinep ding ham? Keima mipaomo kahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Ahivangin Pakaiyin Mose leh Aaron heng'a thu aseiyin Israel te ding leh Egypt lengpa Pharaoh dinga abol lhon ding ho ape lhon'in, Pakaiyin Israel te Egypt akon puidoh dingin Mose leh Aaron thupeh anei tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Hichengse hi apu apateu khang chedol'a Israel insung upaho ahi: Israel insung'a apeng masapen Reuben chapate se chu: Hanoch, Pallu, Hezron, chule Carmi. Amaho chilhahse hi Reuben insung kon ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon chapate se chu: Jemuel, Jamin, Ohad, Jakin, Zohar leh Shaul ahiuve. (Shaul hingnu vang chu Canaan numei ahi.) Amaho chilhahse hi Simeon insung kon ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi chilhahte se amaho insung minbu dungjuiya achapate chu: Gershon, Kohath leh Merari. (Levi chu kum ja le somthum le sagi ana hing'e). ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershon chihahte chu Libni leh Shimei ahi lhonne. Anigel lhonin insung khangguiyin akisim lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohath chilhahte chu Amram, Izhar, Hebron leh Uzziel ahi. (Kohath chu kum ja le somthum le thum ana hing'e.) ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Merari chilhahte chu Mahli leh Mushi ahi lhon'e. Ama ho chengse hi Levi insung chedol minbua amin cheh uchu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amram chun apa sopinu Jochebed chu jin aneiyin, amanun chapa ahin peh in, Aaron leh Mose ahi lhon'e. (Amram chu kum ja le somthum le sagi ana hing'e.) ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Izhar chapate chu Korah, Nepheg leh Zicri ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzziel chapate chu Mishael, Elzaphan leh Sithri ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron in Elisheba aki chenpin, ama chu Amminadab chanu chule Nahson dinga asopinu ahi. Amanun chapa ahindoh ho chu Nadab, Abihu, Eleazar leh Ithamar ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Korah chapate ho chu Assir, Elkanah leh Abiasaph ahiuvin, amaho chilhah hi Korah insung mi ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aaron chapa Eleazar chun Putiel chanute lah a khat ji in aneiyin, chuin amanun chapa khat ahing'in Phinehas ahi. Amaho cheng hi Levi insung'a pu le pate ho insung bahkai dungjuiya chengse chu ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aaron leh Mose hiche laiya kiminphah teni mama hi ahi lhon'e Pakaiyin ajah lhon'a, “Israel mite chu Egypt gam'a kon'in sepoyte bangin hin lamkai lhonin,” tia asei chu. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Egypt lengpa, Pharaoh kom'a Israel mite Egypt gam'a konna puidoh dinga thu sei chu, Mose leh Aaron ahi lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Egypt gam'a Pakaiyin Mose ahoulimpi achun, ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","aheng'a aseiyin, “Keima Pakai kahi! Egypt lengpa, Pharaoh henga seiyin, keiman naheng'a kasei jouse chu.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Ahinlah Mose in Pakai akinel pin, aseiyin, “Hichu ka bolthei louding ahi! Ajeh chu keima mipaomo kahi! Ipi jeh a Pharaoh in ka thusei angai ding ham?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Hijeh chun Pakaiyin Mose heng'a aseiyin, “Hiche hi phate chan ngaiyin. Pharaoh lengpa kom'a Pathen tobang'a kasem ding nahiye, chule na sopipa, Aaron, hi nang dia themgaova pang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ka thupeh jouse hi Aaron jah a seijin lang, Aaron in Pharaoh heng'a Israel mite agamsung'a kon'a asol dohna dinga thu apeh tei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ahinlah Keiman Pharaoh lungthim ka suhtah ding, chuteng melchihna le thil kidang tampi Egypt gamsung'a kapun sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Hiche a jong chu Pharaoh in na thu angai loulai ding ahi. Keiman Egypt gamsung'a ka khut kahin lhanjah ding. Keiman ka thaneina a kon - kamite, Israel te Egypt gam'a kon thutanna gimnei tah pum'a ka huhdoh ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Keiman kaban thahat kahin lhan'a Israel te kahin puidoh teng, Egypt miten Keima hi Pakai kahi ahin hetdoh diu ahitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Chuin Pakai thupeh bangin Mose leh Aaron injong abol lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Pharaoh heng'a ngehna aganei lai lhon chun Mose kum somget ahitan, chule Aaron chu kum som get leh kum thum ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Chuin Pakaiyin Mose leh Aaron heng'ah thu aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Pharaoh in ngehna ahin nei ding, ‘Thil kidang nei vetsah lhonin.' Hitobang ahinsei teng, Aaron henga seiyin ‘Na tenggol chu la inlang Pharaoh masang laiya chun sep lhan, chuteng gul hung kisoh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Chuin Mose leh Aaron jong Pharaoh heng'a ache lhonin Pakai thupeh bangin abol lhon tai. Aaron in tenggol chu Pharaoh le avaipipo te ho angsung'a chun asep lhan ahile, gul ahung kisoh tai! ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Hichun Pharaoh in ama miching ho le doithem ho akou khomin, Egypt gam'a mitphel doithem hon jong chuche tobang chu abol'un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Atenggol'u tol'a aseplha cheh uvin ahile, amahoa jong gul akisoh tai! Ahinlah Aaron tenggol chun amaho tenggol ho chu avallhum soh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Hicheng nung jeng jong hin Pakaiyin asei masat bang chun Pharaoh lungthim chu atah jing nalaiyin, thu ima ngaisah in anei hih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Chuin Pakaiyin Mose heng'a aseiyin, “Pharaoh lungchang atah in, chule aman mipi ho soldoh ding anom naipoi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Hijeh chun jingkah teng Pharaoh vadung lam'a ahung suh teng nangma na che ding. Nile vadung pam'a nadin ding, hikom'a chu nakimupi ding ahi. Na tenggol gul kisoh chu kichoi teiyin. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Chuteng akom'a hiti hin seiyin, 'Pakai, Hebrew mite Pathen'in nakom'a thuseiya eihin sol ahi, “Kamiten keima eihouna ding uvin gamthip noiya soldoh tan.” Tugeiyin, nangman ama thusei iman na ngaisah poi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Hijeh a chu hiche hi Pakaiyin asei ahi: “Keima Pakai kahina ka kilah sah ding ahi.” Vetan! Ka khut a um tenngol hi mangcha a Nile twi kajep ding, chuteng vadung hi thisan kisoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Asung'a nga jouse thi ding, chule vadung uilhahel ding, Egypt miten Nile vadung'a kon twi adon thei louhel diu ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Chujongleh Pakaiyin Mose heng ah aseiyin: “Aaron jah a seiyin, 'Na tenggol kimat inlang Egypt gam'a twi jouse chunga na khut jah inlang - vadung jouse, twinah jouse, luikhuh jouse chunga twi jouse thisan sosah tan. Egypt gam muntin'a twi jouse, thingtwikong le songkong jouse sunga twi jouse geiya thisan soh ding ahi.'” ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Chuin Mose leh Aaron in jong Pakai thupeh bangin abol lhon tan ahi. Pharaoh le athunei vaihomte hon avet laiyun, Aaron in jong atenggol ajahdoh in Nile luidung chu ajep jeng tan ahi. Phulou helouvin, vadung twi apumpin thisan akisoh hel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Luidunga nga jouse athisohhel tan, chule twi anen behseh phat chun Egypt miten adon thei tapouvin ahi. Egypt gamsung pumpi mun jouse thisan dim ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ahivang'in Egypt gam'a mitphel doithem hon jong adoiyu mangchan ama hon jong twi thisan asosah uvin ahi. Hijeh chun Pharaoh lungthim chu atah jing nalaiye. Pakaiyin asei bangin Mose leh Aaron thusei chu nahsah in anei hih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaoh jong aleng inpi lam'ah akilen, hicheng thilsoh ho jouse chu alungthim'a gelkham asa hih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Ahin Egypt mite jousen luipang dung alai thuh un twi akihol le tauvin ahi, ajeh chu ama hon Nile luidunga twi chu adonthei tah louvu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Pakaiyin Nile luidung ajep kal nisagi alhing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Pakaiyin Mose heng'a aseijin, “Pharaoh heng ah chen lang hiti hin gasei kit temin, “Hiche hi Pakai thusei ahi: Kamite soldoh jeng tan, chutileh ama hon keima kin abol ding'u ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","“Nahsah moa amaho na soldoh louva ahileh, na gamsung pumpia ukeng kahin lansah ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","“Nile luidung jong ukeng dimlha jeng ding ahi. Na insung leh na lupna channa hung kaldoh diu! Na mite leh na nungjui ho jouse kom channa lhung ding, na changlhah meh nau jouse'a jong hung lut dimset ding ahiuve.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","“Ukengte chung leh nanung juiho jouse chung'a chom le ding'u ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Chuin Pakaiyin Mose heng'a aseijin, “Aaron jah a seijin lang, ‘Egypt gamsung pumpi ukeng ten ahin lodimna dingin, na tenggol jah in, twinah jouse, twilam jouse leh luidung jouse chu jeptan! Ukeng ten Egypt gam pumpi hin lodim tante, tin seipeh in,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aaron'in jong Egypt gamsung twi chung'a akhut ajah in ajep tan ahile, ukengte ahung potdoh un Egypt gamsung pumpi alodim jeng tai! ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Ahinlah Egypt gam'a mitphel doithem hon jong hitobang chun abolthei uve. Ukengte chu gamsung'a alhalut thei un ahile gam pumpi chu ukengte adimlha tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Chuphat in Pharaoh in Mose leh Aaron akouvin hiti hin aseije, “Pakai heng'a tao lhon tan, ajeh chu keima le ka mite jouse'a konna ukengte alahdohna dingin, chuteng keiman namite'u ka soldoh ding, amaho che uva Pakai kin agabol diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mose'n adonbut in, “Nang le na sohte, chule namite dinga itih phat a katao ding nei seipeh in ati. Chuteng na in dung jouse'a ukengte Nile vadung lam'a kitol ding ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Pharaoh in adonbut in ajah a, “Jing teng bol in,” ati. Mose'n henge, “Nasei bang bang hita hen. Chuti leh nangman keiho Pakai, Pathen tailou dang aumpoi ti nahin hetdoh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","“Ukeng ten nangma leh na nungjui ho jouse le namite naboncha uva na dalhah diu, Nile luidunga bou umden diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Chuin Mose leh Aaron jong Pharaoh angsung'a kon'in achedoh lhonin, Mose chu Pakai lam sang'in kap pum in ataovin, Pharaoh le amite a kon'in ukengte ladoh tan ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Pakaiyin Mose taona chu asanpeh tan, indung jouse, loujao leh gamsung'a ukeng jouse asumang hel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Egypt miten ukeng thisa ho chu aloh khom'un ahile gamsung pumpi a uilha jeng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Ahinlah Pharaoh in dinmun ahung oldom tai ti ahin hetdoh phat in, angaija bangin alungthim atah kittai. Pakaiyin aseidohsa bangin Mose leh Aaron thusei chu anahsah kit tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Chuin Pakaiyin Mose heng'a aseijin, “Aaron heng'a seijin lang, ‘Na tenggol jandoh in tollhang jep temin. Egypt gamsung pumpia vut chu vaisi kisoh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Pakai thupeh bangin Mose leh Aaron'in jong abol lhon tai. Aaron'in jong akhut ajah in atenggol'a tol lham chu ajep a ahile, vaisi tamtah in Egypt gam pumpi le agamcha jouseu alodim jeng tai. Egypt gamsunga vut jouse chu vaisi asoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Pharaoh doithem hon atobang bang abolthei jing vang uvin, tunvang alosam tauvin abolthei tapouvin ahi. Vaisi in mipi ho leh gamsung'a gancha jouse atomlha tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Hiti chun doithem hon jong Pharaoh heng'a aseiyun, “Hiche hi Pathen khutjung ahi!” ati tauve. Ahinlah Pharaoh lungthim chu angaija bangin atah jing nalaiye. Pakaiyin aseidoh sa bangin Pharaoh in jong amaho thusei chu anahsah dehpon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Chuin Pakaiyin Mose henga hiti hin aseikit tai, “Jingkah teng Nile vadung lam'a Pharaoh hung ding chuteng nangman nakimupi ding ahi. Ajah a Pakaiyin hiti hin asei je, 'Kamite soldoh tan, ajeh chu ama hon keima kin abol ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Na soldoh louva ahile, Keiman namite, nanung juiho chule na insung jousea thousi kahin lansah ding ahi. Egypt mite in jouse thousin atomlhah jeng ding, gam leiset pumpi jong dimlha jeng ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ahinlah kamite chenna Goshen achom beh a kahoidoh ding ahi. Thousi khatcha lenglut louhel ding ahi. Chuteng leiset pumpin keima hi Pakai kitipa chu kahi ti nahin hetdoh diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Keiman kamite leh na mite kah a kikhenna ka semdoh ding, Hiche thil kidang meilchihna hi jing nikho teng soh ding ahi,'” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Pakaiyin aseidoh bangin aboltan. “Thousi te chun Pharaoh insung, anungjui ho insung leh gamsung in jousea alenglut tauvin adimlha jeng tai.” Thousi ahon honin Egypt gamsung'a ahung kitol lut tan ahile gamsung pumpi chu athimlha jeng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Chuphat in Pharaoh in Mose leh Aaron aga kouvin, hiti hin aseije, “Apha tai! Cheuvin lang Pakai maicham gasem tauvin, ati.” Aman aseijin, “Hichu Egypt gamsung'a nabol ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Mose'n adonbut in hitin aseije, “Hichu adih theipoi. Keihon Ka-Pakaiyu le Ka Pathen'u angsung'a kilhaina maicham kasem diu chu, hiche lai Egypt mite adia thil kitoh ahiye. Ven! Hitobang thil ho pi chu bol taleng'u Egypt miten song'a eiselih gam ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","“Ka Pakaiyu leh ka Pathen'u angsung'a kilhaina hi nithum sung hitei ding ahi, hichu Pakaiyin keima ho dia aseidohsa ahi, ati.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Pharaoh in adonbut in ajah a hiti hin aseije, “Apha tai, che tauvin.” Keiman nangho gamthip noija na Pakaiyu kinbol dingin kaphal tai, amavang nache gamlat louhel ding'u ahi. “Tun cheuvin lang keima dingin nei taopeh un,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mose'n adonbut in, “Na angsung'a konna ka potdoh ding, jing nikho tengleh nangma akon leh namite chule na insung jouse uva konna thousi apotdohna dinga katao tei ding ahi, kagihna ahiye nangma Pharaoh in jong nei joulhep da uvin lang Israel miten jong Pakai dia kilhaina hi boldau hen nati loubeh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Pharaoh angsung'a kon'in Mose apotdoh tan, thousi jouse akitolmang helna dingin aga tao tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Pakaiyin Mose taona asanpeh tan, Pharaoh akon, anungjui ho leh amite ho jousea kon'in, thousi vaibong abonchan akitolmang tan, khatcha jeng jong akimudoh tapon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Ahinlah angaiya bangin Pharaoh lungthim atah kit tan ahileh, Israel mipi asoldoh deh tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Pakaiyin Mose thupeh aneijin,“Pharaoh heng'a chekit inlang ajah a hiti hin seijin. Hiche hi ahi Hebrew mite Pakai, Pathen'in asei chu: Kamite che'u henlang, Keima kin gabol uhen. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Na soldoh louva Israel mite hi na umsah jing dinga ahile, ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","na loujaova na gancha jouse na sakolte, sangante, sangongsao te, gancha hon, kelngoite leh na kelchate chung'a gamna hise kahin lansah ding thigam kei ding ahiuve, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ahinlah Pakaiyin Isrrael te gancha ho leh Egypt mite gancha ho chung'a chom khenna ahin sem ding, Israel mite ganchaho vang chu khatcha jong thilou ding ahi! ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","“Pakaiyin hiche gamna hise ahin lansah ding ahitai. Aman aseije jing nikho teng gamsung pumpia ahin lansah ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Pakaiyin aseidoh bangin aboltai. Ajing jingkah in Egypt mite gancha athigam hel tan, ahinlah Israel mite gancha vang chu khatcha jong athi hihbeh jeng'e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Thilsoh umchan dol khol chil dingin Pharaoh in asohte ho chu asoltan ahile, Israel mite gancha ho chu khat cha jeng jong athi pon ahi! Amavang Pharaoh lung thim chu angaiya bangin atah jing nalaiyin* aman mipi ho chu asol doh dehpon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Chuin Pakaiyin Mose leh Aaron heng'a aseijin, “Lhum sung'a kon'in vutdi tampi kiham lhon'in, hichu Pharaoh mitmu chang tah a Mose'n vanlam'a athe tou ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","“Egypt gamsung pumpi chu vutvai nelsel chun alodim jeng ding, chuteng mihem chung hile gancha chung hile uilut natna huoisen alhunden jeng diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","“Chuin amanin jong lhumsung'a kon'in vutdi akiham lhonin, Pharaoh angsung'a ading lhon tai,” Pharaoh in avet jing laiyin, Mose'n vutdi chengse chu vanlam angan athetou le, vutdi nel chun gampumpi alodim jeng tan mihem le gancha ho chung’a uilut natna hoise alang tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Egypt gam’a doichoiya thilbol ho chung'a jong achutan Mose angsung'a ading ngam tapouve, ajeh chu uilut natna hoise chun amaho leh Egypt mite jouse alhun den jeng ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Ahinlah Pakaiyin Pharaoh lungthim asutah nalaijin, “Pakaiyin Mose heng'a aseidohsa bangin, Pharaoh in ngai nahsah in anei hih laiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Pakaiyin Mose heng'a aseijin, “Jingkah matah in thouvin Pharaoh angsung'a ga dingin lang, ajah a seijin. Hebrew mite Pakai Pathen'in hiti hin aseije: “Kamite soldoh tan, keima kin agabol na ding uvin.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","“Na soldoh louva ahile, keiman natna hoise kahin lansah be nahlai ding nangma le nanung juiho chule namite chung'a kahin lansah cheh ding, chuteng nangman keima Pakai tailou leiset a Pathen dang aumpoi ti nahin hetdoh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","“Tu jenga jong keiman ka khut kalhan jah a nangma le namite chung'a gamna hoise ka lansah a leiset chung'a hi ka suhmang hel jeng thei nahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","“Ahinlah keiman leiset pumpia ka thaneina ka musah bou nahin hichu leiset pumpia kithe jal ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","“Ahinlah hicheng jouse nungin jong nangma leh nangma na kichoisang gunset in, kamite na soldoh hih laiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","“Jing nikho tuphat dontah le keiman gelchang nasatah Egypt gamsung'a imatih channa analha khaloulai chu kahin lhahsah ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","“Kino tan! Na loujaova gancha ho jouse hoitup dingin namite sol loijin, achuti louva ahile hitobang gelchang ahung kheh teng loujaova mihem hihen gancha hijongleh aki dalha chan chu gelchang'in ase a thi jeng ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Pharaoh nungjuiho mi phabep chu Pakaiyin hitia asei jeh chun akicha tauve. Amaho acheloi jun loujaova gancha ho leh asohte ho'u chu aga puilut tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ahinlah Pakai thusei ija sep louse vang chun aloujao dung uva kihong tah in gancha alha thang nalai uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Chuin Pakaiyin Mose heng'a aseijin, “Egypt gamsung loujao tin cheng'a gelchang ahung kheh a mihem ahin gancha ahin chule loujaova thingphung jouse hihen lang, Egypt gamsung pumpia thil um jouse ase khahna dingin vanlam nganlang na khut lhang jah tan,” tin aseitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Chuin Mose'n jong vanlam asang'in atenggol chu agah jahdoh jeng le, Pakaiyin vanthamjol aki thinsah in gelchang ahung khetan, leiset chung geijin meikong ahung lenglha tan, Egypt gam pumpia Pakaiyin gelchang goju toh kibangchet in akhehsah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Imatih chan a jong hitobang gelchang chu Egypt gamsunga ana khe khalou lai ahin, tanglou hel'in gelchang chu akhe tan meikou apahlha jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Hitobang gelchang chun Egypt gamsung pumpi alodim lhajeng tan chule loujaova umphot gancha hihen mihem hijongleh aum jouse chu asep lhu jeng tan, gamsunga thingphung jouse jong asep thang deh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Goshen mun Israel mite chenna mun bou chu ahoidoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Hitia thil aso phat chun, Pharaoh in jong mi asol loijin Mose leh Aaron agakou sah tan hiti hin aseiye, “Tun vang keima chonse kahitai,” tin kilhanna aneiyin “Pakai hi thudih tanpa ahin, keima le kamite kadih tapouve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Pakai henga nei taopeh lhon tan, ajeh chu vanthamjol aging jeng jung'e! Gelchang nasatah in akhe jing nalaijin ahi. Ka gimval tauve. Keiman na soldoh tauving'e; um jong umsot tahih un, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mose'n adonbut in, “Ahi le aphai.” Khopi sung hi ka dalhah lhah leh keima jong Pakai heng'a ka tao ding ahi. Vanthamjol gin hung thip ding, gelchang khe jong hung tang jeng ding, nangman jong leiset pumpi hi Pakaiya ahi ti nahet doh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","“Ahinlah keiman kahe jing nalaije, nangma leh nasoh ten tuchan'in Pakai na ging hih lai uve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Hiti chun gamsung'a Phaipheng jouse leh sakol chang abonchan amangthah hel jeng tai, sakol chang chu avui ado laitah ahin chule phaipheng chu ahung don doh laitah ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Hiche lah achun suhlou chang leh butun chang vang ahoidoh nai, ajeh chu suhlou chang leh butun chang chu aduo aum loulai phat ana hiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Chuin Mose jong Pharaoh angsung khopi dalhan achetai. Pakai lam asang'in ataovin ahile, vanthamjol kithin le gelchang khe chu atang jeng tan, leiset pumpia gojuh jeng jong atang hel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pharaoh in jong gojuh, van kithin, leh gelchang kheh akitang tai ti ahin hetdoh phat in ama le anungjui ho achonse kit tauvin, angaiya bangin Pharaoh lungthim atah kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Pakaiyin Mose heng'a ana seidoh sa bangin Pharaoh lungthim angaiya bangin atah kittan, Pharaoh in jong Israel mite asoldoh deh poi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Chuin Pakaiyin Mose heng'a aseijin, “Pharaoh heng'a chekit inlang, ga seikit tan. Keiman ama leh asohte ho lungthim ka suhtah ahin, melchihna hicheng jouse hi kakilah sah ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","“Chule nangman jong na chapate leh natupate jah a ichan geija kagim sah uva chule melchihna tampi kamu sah uve ti na jahsah theina diuva kasei ahiye. Nangho jengin jong keima hi Pakai kitipa chu kahi ti nahet doh jeng diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mose leh Aaron jong Pharaoh heng'a ache lhonin asei lhon tai, “Hebrew mite Pakai, Pathen'in hiti hin aseiye: Itih chan ka-angsung'a kun ding da nahi tam? Keima kin agabolna ding uvin, kamite soldoh tan. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Nanop louva ahile, vetan! Jing nikho tengleh na gamsung'a khaokho te kahin lansah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Gam pumpi alodim soh uva tol lham jong na muthei louding ahi. Gelchang'in akhehlih lou amoh chengse khaokho ten aneh gamhel diu, loujaova keh thingphung ho jouse jong anehchai kei ding'u ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Nangma insung hihen nasohte insung hijongleh Egypt gam insung jouse ahin lodim sohhel jeng diu, hiche tobang thilsoh gimnei hi napu napateu khang'a pat na gamsung uva anaum khalou lai ahi, tin ahenga agasei lhon tai, chuin Mose jong Pharaoh angsung'a kon'in apotdoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Pharaoh sohte ho jong ahung uvin Pharaoh heng'a asei tauve. “Amapa hin itih chan lom lom eiho dinga hahsatna alhunsah ding hitam? Mipi ho hi che uva a Pathen kin abolna diuvin soltan! Egypt mite pihi jou le nal'a mangthah gam ding ahi tauve ti na hetdoh hih laiyem?” ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Chuin Mose leh Aaron chu Pharaoh heng'a dingin ahin puilut kit tauvin. Pharaoh in jong amani jah a aseiyin, “cheuvin lang na Pakai leh na Pathen kin gabol tauvin. Ahile koipen mong hi nahiuvem ache ding?” tin amani chu adong tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mose'n adonbut in, “Ateh akhang, ka chapate hou ahin ka chanute hou jaona a khatcha kidalha louding kahiuve. Ka kelngoi jouseu leh gancha jouse aboncha kapui sohkei diu, chule keihon kut chu alouthei louva kagabol teitei ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pharaoh in jong aseijin, “Keiman nangho nacha sen gei uva ka soldoh tha ngei ngeija ahile Pakai umpina chu chang un! Na lungthim sung lhkonna lungthim phalou na keng lhon'e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Hiche vang chu hithei louhel ding ahi! Nangho lah a Pasal chengse cheuvin lang na Pakaiyu kin gabol tauvin, hichu natup tenten uva hilou ham?” Chuin Pharaoh in aleng in a konin ahin nodoh lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Chuin Pakaiyin Mose heng'a aseijin, “Egypt gamsung pumpia khaokhopite alanna dingin na khut jahdoh jeng tan. Egypt gamsung'a hamphung gelchang in akhehlih moh chengse aboncha aneh gamset diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mose’n atenggol chu Egypt gamsung pumpi chungvum a ajahdoh jeng tan ahile, hiche nikho chun Pakaiyin Egypt gamsung pumpi nilhum kei leh khovah hel'in huiphalou solama kon'in tanglouvin anun sah tai. Jingkah in solam akon huijin khaokho te ahon hon'in ahin polut tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Chule Egypt gam pumpi chu khaokho ten alosoh hel jeng tan, hitobang'a gamsunga khaokho te chu imatih channa ana um kha loulai ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Khaokho ten gamsung pumpi alodimlha tauvin ahile mu athimlha jeng tai. Gelchang in akheh moh chengse gam leiset a thingphung jouse jong anemang hel tauvin, Egypt gamsung pumpi thingphung chule hamphung abonchan ado khat jeng cha jong um louvin khaokho ten anechai hel jeng tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Chuphat in Pharaoh in jong asohte ho asol loiyin, Mose leh Aaron aga kousah un, hiti hin aseiye. “Keiman na Pakai leh nangni chung'a chonset phat louna kabol khatai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","“Ka chonsetna nei ngaidam lhon'in, Pakai heng'a nei taopeh teitei lhon tan, hiche thigamna hoise hi keima angsung'a kon'in tolmang jeng lhon tan,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mose jong Pharaoh angsung'a kon'in a kondoh in Pakai heng'a aga tao tai, ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Pakaiyin nisolam a kon'in hui hattah ahin nunsah in ahile, hiche huipi chun khaokho te jouse twikhanglen dung laiya alhoh lut sohhel jeng tai. Egypt gamsung pumpia khaokho te chu khat jeng cha jong aum tahih hel jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ahinlah Pakaiyin Pharaoh lungthim asutah jing nalaijin, Pharaoh in jong mipi ho chu asol doh hih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Chuin Pakaiyin Mose heng'a aseijin, “Nakhut jah inlang vanlam sang tem in, Egypt gamsung pumpi muthim'in alo sohhel jeng ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mose'n jong Pakaiyin athupeh bangin vanlam asan jeng'a ahile, Egypt gamsung pumpi nithum sung mu athim lha jeng tan, ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Hiche phat sung chun khat le khat akimu thei tapouvin, koimacha jeng jong pot le theilou ahitai. Ahinlah Israel chate chenna mun vang chu khovah in aumpi jing uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ajonan, Pharaoh in jong Mose akoukit tai. “Cheuvin lang Pakai kin gabol tauvin,” ati. “Na chate'u kipui jun lang, ahinlah na kelngoi hon teu vang na dalhah ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mose'n adonbut in, “Hichu hithei him him ponte. Ka gancha te'u chu nei puisah tei teiju angaije, ajeh chu ka Pakai uleh ka Pathen angsung'a kilhaina a ka manchah ding'u ahi, ati.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","“Ka gancha teu aboncha, ka pui teitei diu ahiye; khat jeng cha jong ka dalhah thei louhel diu ahi. Ajeh chu ka ganchate'u lah a konna hi keihon Pakai angsung'a kilhaina'a katdoh dinga ka lhendoh cheh cheh diu ahi. Chule amun ka lhun kahse uva itilam dol'a Pakai kin kabol diu ham ti kahe chen nai pouve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Ahinlah Pakaiyin Pharaoh lungthim chu khatvei asutah kit nalaijin, Pharaoh in jong mipi ho chu asoldoh hih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Chuin Pharaoh jong apeng jah jeng tan, Mose henga aseiyin, “Ka angsunga kon'in potdoh jengin!” ati. “Keiman nangma ka gih nahiye. Avel'a nei hung kinung mupi kitthei louhel ding ahi! Nei kimupi kit ngai ngaiya ahile hiche nikhoa chu nathi jeng ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mose'n adonbut in, “Apha jenge,” “Avella ka kimaitopi tah louding nahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Pakaiyin Mose heng'a aseijin, “Keiman Egypt gamsung leh Pharaoh chung'a ka hin lhunsah ding hoise khat akivat nalaije. Hiche hi aso chai chai tengleh, Pharaoh in agamsung dalha dinga nahin no jeng ding'u ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","“Israel mite heng'a seipeh inlang, ama ama cheh in aheng akom Egypt mite sana dangka akijepna ding uvin kithum cheh tauhen,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Tun Pakaiyin Israel chate chu Egypt mite mitmun lunglhaina achansah tai. Chule Mose chu Egypt gamsung pumpia amin akithang in, Pharaoh mitmu chang leh mipite mitmun amin che lheh jeng tan ahi.) ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Chuin Mose'n Pharaoh heng'a aseijin, “Hiche hi Pakaiyin aseiye: “Keiman jankim tah le Egypt mite lungthim kahin suhthou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Egypt gamsung'a chapang peng masa jouse, Pharaoh chapa peng masapen ahin, alaltouna a peng masa penpa ahin, a sumbuh laiya changbong goija pang asohnu chapa chan geija abonchauva thigam kei ding, gancha peng masa jouse jong aboncha thisoh hel ding ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Chuteng Egypt gamsung pumpia ka le mao kithong lha ding, ajeh chu hitobang thilsoh gimnei hi imatih channa anaum khalou laiya ahin, avella hung kilah kit talou ding chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ahinlah Israel mite vang chu lungmon nan aumpi jing diu, uicha jeng jong hampoh louding ahi. Chuteng Pakaiyin Egypt mite leh Israel mite kikah a ijakai datkhenna asemdoh tai, hichu nang hon na hetdoh cheh ding'u ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Chuteng Egypt gam'a na nungjui ho leh nasohte abonchauva keima lam'a hung kipelut ding'u hitia hi asei diu ahi, khaiye! 'Nangma leh nanung juiho abonchauvin hikom'a kon hin potdoh tauvin!' tin aseije atipeh tai. Chuin Mose jong lungphamo tah in Pharaoh angsung'a kon'in achedoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Tun Pakaiyin Mose heng'a aseijin, “Pharaoh in nangma thusei ahin ngailou ding, ahinlah keiman Egypt gamsung'a thil kidang melchihna ka bolbe nahlai ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mose leh Aaron'in jong Egypt gam Pharaoh angsung'a thil kidang melchihna tampi aki lahsah lhon'in, ahinlah Pakaiyin Pharaoh lungthim chu kidang tah in asutah jing nalaijin ahile, Pharaoh in Israel mite chu Egypt gamsung a kon'in ana soldoh hih laiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Israel mite Egypt gam'a aum jing laijun, Pakaiyin Mose leh Aaron heng'a hicheng hi thupeh aneiye: ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Tu apat hiche lha hi nangho dinga lha kipatna ahin, kumkhat adia lha kipatna a kisim ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Israel te kikhop khomna munpi jouse ah ga seipeh lhon tan. Hiche lhasung nisom alhinni tengleh ama ama cheh in apu apateu insung kai lhah apat, insung khat cheh akon kelngoi khat cheh katdoh dinga ahin kai diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kelngoinou khat kitha dinga insung khat a mijat chu alhom khah a ahile, inneipu le aheng akom'a pa kinopto ding kelngoi nou adol ding chabep khat chu aga kimat lhon ding, amichan cheh in aneh khopset ding kelngoinou khat ding mijat chu phatecha nasim toh lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","“Kelngoinou chu nolna beihel hi ding, kumkhat lhingsa hitei ding, hiche kelngoinou chu kelngoi honlah a konna hihen kelcha honnlah konna hijongleh athah beh mong mong'a na kimat ding'u ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Hichea manchah ding kelngoinou chu hiche lha nisom leh nili lhinni geija nahen cheh diug'u hichu nilhum lam tengleh Israel kikhom pumpi chun ama ama cheh adia akitha ding'u ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Gancha kithat thisan chu phabep asodoh diu, hichu kelngoinou thisan a chu in kotpi phung le inkam'a aloinat cheh cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Hicheni jan teng chule kelngoinou sa chu meiya akihul min uva aneh cheh diu, hichu cholsolou changlhah leh anchekha toh ametha cheh cheh diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Hiche sa chu asel puma hihen twija kihonminsa hijongleh koima chan naneh thei louhel diu ahi. Sa pumpi aluchang le akeng chule asung jouse jaona meiya na kihulmin tho uva naneh cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Sa amoh neocha jong jingkah channa na khovah sah louhel diu ahi. Akinelou taphot chu jingkah masanga meiya na govam jeng ding'u ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","“Hicheng hi sa naneh teng ule najui cheh ding'u ahiye: nangma cheh na kivon lhingsel uva, nakeng chot ho'u na kisi cheh diu, chule nakhut uva tenggol na kiphu sohkei ding'u ahi. Chuteng naneh khom sohkei diu hichu Pakaiya dia Kalchuh Kut ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Hiche jan teng chule keiman Egypt gamsung kahin jotpa a mihem leh gancha aboncha apeng lha masa jouse kasuh gamhel ding ahi. Chule Egypt gamsung'a milim doi kisemthu jouse chung'a jong thu katan ding ahiye, ajeh chu keima Pakai kahi!. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ahinlah nangho jouse dinga hiche thisan kiso chu melchihna hung kilah tading, keiman Egypt gam pumpi kahin suhmang ding, hiche thisan chu kahin mudoh jiteng keiman nangho jouse chung'a natna hoise hung lang thei jouse a konna kaven doh ding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Hiche nikho hi nangho dinga hetjingna nikhoa pang jeng ding ahitai. Hichu kumsih chule akhang akhang'a Pakaiya dia kut nikho ahi ti na geldoh jing ding'u ahiye. Na khang lhumkei uva chonna dan hitia nanit jing diu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Nisagi sung'a cholsolou changlhah jeng naneh ding'u ahi. Nisagi alhinni tengleh nangma insung cheh a chol um jouse pamlamma na paidoh sohkei ding'u ahi. Nalah uva koi tobang khat chun hiche cholsolou changlhah, nisagi lhinnia pat naneh khah ngeingei uva ahile, ama chu Israel mite lah a konna kisumang jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Kut kipat nikho masa penni teng khompi len khat nanei uva, nisagi alhinni teng jongleh khompilen theng khatma nanei diu ahi. Hiche nikho teni hi atumbeh a nanit cheh diu, amichan'in aneh khop ding nabol peh teitei ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Hiche hi Cholsolou changlhah kut a naman diu ahiye, ajeh chu hiche nikhoa hi keiman nangho Egypt gamsung'a konna kahin puidoh nau na geldoh jing diu, nakhang lhumkei uva nangho jousen hiche nikho chu chonna dan ahi tia nanit jom jing ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Lhamasa nisom le nili lhin nikho nilhah lam tengleh na boncha uva hiche cholsolou changlhah chu naneh pan diu ahi ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Nisagi sungse'a vang chu nangma nangma insung cheh a, chol sosa changlhah khat jeng cha jong kilah louding ahiye. Kholjin mi ahin agamsung cheng den miho hijonglehu chun cholsosa changlhah nekha tapou chu, Israel khompi a konna kisumang jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Hiche phatsung hin amitakip in cholsosa changlhah kiti phot naneh louhel ding'u ahiye. Ajeh chu cholsolou changlhah jeng naneh diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Chuin Mose'n jong Israel sung'a upaho jouse akou khom in aheng uvah aseipeh tai, “Cheuvin, nangma cheh insung ding kelngoinou gaki kaiyun lang, chule Kalchuh Kut a dingin kithauvin.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","“Khutsilna kong'a gan thisan chu koiyun. Chule hichu hyssop nado phabep lauvin lang dekot uvin. Hyssop chu lauvin lang thisan achun kotpi khom teni ahin kotpi chunglah inkam a chun loinat sohkei uvin. Jing khovah kahsea koima chan hichu akallhah thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ajeh chu Pakaiyin Egypt mite jouse sugam'a hung ding kahi, chuteng Pakaiyin kotpi chung lah a thisan kiloinat ho chu amu ding, hitia chu asuhgam ding hojal a chu hiche insung chu apeldoh ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Geldoh jing'un, thupeh hichengse hi nangho jouse ding leh nachateu khang geija chonna dan ahi tia najui jing ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Pakaiyin nangho peh dinga akitepna sa gamsung nalhun teng ujongleh hiche chonna dan hi najui jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Chule hiche chonna hi na chate uvin 'Ipi dinga kibol ham?' ti nahin doh ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Nang hon jong na donbut uva, “Hiche chonna dan hi Pakaiyaa dia gantha kilhaina ahin chule Pakaiyin Egypt mite ana thagam lai chun Aman Israel mite in ho chu ana kalchuhji e,'” tia na seipeh ding'u ahi. Chuin Mose'n thupeh hichengse chu achai phat in mipi jouse Pakai angsung'a akunlha sohkei uvin chibai aboh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Pakaiyin Mose leh Aaron athupeh bangin Israel mite'n jong abol tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Chule hiche Jan khangkim chun Pakaiyin Egypt gamsung'a naocha peng masa jouse, Pharaoh chapa apeng masapen alaltouna toupa a kipat, akimvella cheng asohpa chapa peng masapen ahin, chule gancha peng masa jouse athat gamhel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Jankim laijin Pharaoh, asohte ho chule Egypt mite abonchauvin athou doh tauvin, Egypt gamsung pumpia ka le mao awgin akithong sohhel tai. Ajeh chu intin cheng'a mi thina lou umlouva ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Jankim laijin Pharaoh in Mose le Aaron aga kousah tauvin, “Ka mite dalhan che tauvin chule Israel mite kipuijin che tauvin! Nei tepna bangun cheuvin lang Pakai kin chu gabol jeng tauvin. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Na seima bangin na kelngoi jouseu leh na gancha jouse'u abonchan kipui unlang, che tauvin, nei dalhah ding tah jeh un keima jong phatthei neichan lhon ding ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egypt miten abonchauvin Israel te dingin akisaboi lheh jeng tauvin, Egypt gamsung'a konna Israel mite soldoh loiding lunggel akeng tauvin, ama hon “Keiho ka boncha uva thigam ding kahi tauve!” tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Israel mite'n jong changbong neldi anei jouse'u aki hamkhom tauvin. Changbong ameh nau lhengkam jouse jao nan poh dingin akigot cheh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Mose'n athupeh bang bang uvin, Israel mite'n jong abol tauvin ahi; Egypt mite a kon'in sana le dangka kijepna ding jouse akithum doh gam tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Pakaiyin Israel mite chu Egypt mite mitmun alunglhai sah sohkeijun ahile, Egypt miten jong anei chasun uchu itcha louhel lin ana pesohkei uve. Egypt mite haona jouse toh akon tauvin ahi! ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Hiche jan chun Israel mite Rameses khopia kon'in Succoth lam'a dingin akipat doh tauvin ahi. Numei chapang simtha louvin keng lamma che pasal jat mong chu sang jagup alhing uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Amaho ahiuvin chule miphuh miphah, gancha ho, kelngoi hon tampi le gancha hon tampi jaonan aki tol tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Egypt gamsung'a aum lai uva kisem changbong chu alhon lhon'in akiken jiuvin ahi. Egypt gam'a kino tah a kisoldoh ahijeh uvin ama hon changlhah chu chol aso man tah louvu, chule ama cheh neh ding jeng jong ana kigon man tapouve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israel mite chu Egypt gamsung'a kum jali le kum somthum ana cheng uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Chuin, Kum jali le kum somthum lhinin Pakai thaneijin Israel mite chu Egypt gam'a kon'in ahin puidoh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Hiche jan chun Pakaiyin Israel mite Egypt gam'a konna ahin puidoh ding kitepna aneiyin ahi. Hiche jan hi Pakai dinga mong ahin, hijeh a chu Israel mite'n akhang akhang uva anit jing diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Chuin Pakaiyin Mose le Aaron heng'a aseijin, “Hichengse hi Kalchuh Kut kibol ding dan ahi. Kalchuh Kut ankong hi kholjin min anehthei louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Amavang hiche mihem chu sum'a kichodohsa le cheptan sa ahile aneh jeng thei ahinai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Kholjin maimai le tha a kila a kigoi mihon aneh louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Insung cheh a Kalchuh Kut an chu kine ding ahi. Inpolam'a naneh theilou diu chule agu jong khatcha na suhboh lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Hiche hi Isreal khompi jousen phatecha anit cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Gamdang mikhat tou ahung kholjin khah a Pakai Kalchuh Kut a ajaonom'a ahile pasal kiti phot chun achep kitan cheh uhen, chuteng Kalchuh Kut chu anailut uva aneh thei ding chuteng amaho chu Israel mite bang'a lhathei ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Hiche thupeh hi amitakip ading ahin, agammi Israel te hihen gamdang mi hijongleh dan khat a um cheh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Pakaiyin Mose le Aaron athupeh bangin Israel mite'n jong abol sohkei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Hiche nikho chun Pakaiyin Israel mite Egypt gamsung a kon'in galsat sepaite bangi nahin puidoh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Chuin Pakaiyin Mose heng'a aseijin, ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Israel mite lah a apeng lhamasa phot kaheng'a na todoh dingu ahi. Mihem hihen gancha hijongleh aboncha keija ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","“Mose'n mipi ho heng'a aseijin, “Hiche nikho hi imatih channa geldoh jing uvin Egypt gam'a nasoh chan nauva konna nahung kitoldoh nikhou chu ahiye. Tunin Pakaiyin aban thahat panin nahin puidoh tauve. (Geldoh jingun, cholsolou changlhah jeng naneh ding'u ahi),” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Hiche nikho hi phalbi matah hichu Abid* nikhoa hi na boncha uva chamlhat tah a na potdoh sohkei ding'u ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Pakaiyin nangho chan dia napu napa teu heng'a akitepna Canaan gam mite, Hit mite, Amor mite, Hivi mite chule Jebus mite chenna (khoiju le bongnoi lkonna gamsung'a nahin puilut tengu leh hiche lhasung'a chu nangman jong hiche chonna dan chu nabol ding ahi), ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Nisagi sung'a cholsolou changlhah jeng naneh diu ahi. Nisagi lhinni tengleh vang Pakai heng'a kut khat nabol diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Nisagi sung'a cholsolou changlhah jeng bou naneh thei diu ahi. Tahbeh in hiche nikho sagi sungsea hi na gamsung kimvel'u aboncha koiman cholsosa changlhah kiti toh naum khom louhel diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Nisagi lhinni tengleh na chate hou heng'a nasei uva, ‘Egypt gamsung'a keima kaum laiya Pakaiyin hiche melchihna hi eibol peh ahiye,’ nati ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","“Hiche golvahna hi melchihna khat a pang jing ding, chule namit jeng a jong hetjingna a pang ding, hiche kihilna hi na kamsung'a navop jing ding ahi: Pakaiyin nangma aban thahat pan'a Egypt gamsung'a konna nahin puidoh ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Hijeh chun hiche golvahna hi kumseh angai ngaija bang'a nabol jing dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Hiche chonna dan hi Pakaiyin khangluija pat a kitepna anei bang'a hichu aguilhun kahsea nabol jom jing diu, nanghon Canaan mite chenna nalhun teng uleh nabol diu, ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","hijeh a chu Israel sung'a konna pasal pengdoh masapen mihem hihen gancha hijongleh Pakaiya dia napeh doh jing diu ahi, hichu Pakaiya ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Hiti achu sangan nou penglha masa chan chu kelngoi nouva nalhat diu, nalhat tah lou ujong le sangan nou ho chu angong chang na hekelep diu ahi. Chule na chapate lah a apeng masa chan nale lhatdoh cheh cheh diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Chule khonung teng, na chapan thil umchan dol nahin doh ding, 'Hiche ho jouse hi ipi jeh pentah a kibol ham?' Nangman hitia hi na donbut ding, 'Egypt gam'a soh ichan lai uva Pakaiyin aban thahat panna mipi jouse leh gancha aboncha eihin puidoh u ahiye, nati diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Pharaoh ana lungtah lheh jengin ahile, Egypt gam'a konna ipotdoh diu chu ana phal tapon, ajonan Pakaiyin Egypt gamsung'a pasal peng masa jouse leh gancha jouse abonchan athat chaikeiye. Hijeh a chu tua hi keiman Pakaiya dia kilhaina kasem ahin hibang'a chu keiman ka chapate lah a apeng masa pen chan chu lhatdohna kaneiji ahi.' tia na seipeh ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Hiche chondan hi nakhut teni ahin, namit teni chule na nahlhong geija melchihna thil'a navop jing ding ahiye. Hichu Pakaiyin aban thahat panna Egypt gam'a konna nahin puidoh hetjingna ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ajonan Pharaoh in Israel mite ahin soldoh tan ahile, gamtepna lam lhunna naicha ahi vang chun, Pathen'in Philistine galbol ho jeh chun lampia ahinpui pouvin ahi. Pathen'in aseiye, “Kamite hon gal tohkha ta le alung heikhao vintin Egypt lam'a kile ding ahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Pathen'in amaho chu gamthip lah a ahinpui leuvin, Twipi San* lam mun chu ahin jon tauvin ahi. Israel mite chu galsat mi bangin ahung kitol tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mose'n jong Joseph gu le chang ahin pon, ajeh chu Joseph in hiche thulhahna hi ana neijin, hiti hin aseiye, “Pathen nangho kithopia hung jing ding ahi. Aman nangho nahin panpi teng ule, hiche kagu kachang hi nahin poh ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israel miten Succoth mun ahin dalha uvin gamthip lah Etham kiti mun ahunglhung tauvin hiche mun a chun ngahmun akisem tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Pakaiyin amite chu malam'a alhonpi jingin, Sunteng meibol khompi bangin alhonpi uvin, jan teng meivah khompi bangin alhonpi jiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Pakaiyin amite dalha louvin meilhang meivah in aumpi jing uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Pakaiyin Mose heng'a thupeh hicheng hi aneijin: ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Israel mite heng'a seiyin nung lam'a akihei uva Pi-hahiroth le Migdol kikah san-dung chule Baalzephon gal lamma ngahmun asem nai diuvin aheng uvah seipeh un. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Chutileh Pharaoh in hitia hi angaito ding, 'Israel mite alungdong tauvin, suhna ding helouvin gamthip noija akitol le tauve!' ati ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","“Hitia chu keiman avel'a Pharaoh lungthim ka suhtah ding, aman nangho nung ahin del ding ahi.* Ajeh chu keiman ka gontupsa ahitai, Pharaoh le agalsat mite chung'a ka loupina kakilah sah ding ahi. Chuteng Egypt mite'n keima Pakai kahi ahin hetdoh diu ahitai!” Aheng uva kiseipeh bangin Israel mite'n hiche munna chun ngahmun akisem tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Pharaoh lengpa le asohte ho heng'a Israel mite ajam tauve tithu alhun phat in, Pharaoh leh asohte lungthim akikhel kit tan, “Ipi khat ibol uva Israel mite asoh chan nauva konna jam gam'u hitam?” tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Pharaoh in jong agalsat miho le sakol kangtalai ho chu agontup sah loijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Pharaoh in sakol-kangtalai hatcheh jagup le Egypt gamsung'a sakol kangtalai dang ho jouse abonchan vaihom mitampi chu atou tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Pakaiyin Pharaoh kiti Egypt lengpa lungthim asutah nalaijin ahile, aman jong Egypt gamsung dalha a jam Israel mite nung chu adel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Egypt mite'n jong Israel te chu Pharaoh in galsat miho thaneina lhingset apen anung adel tauvin a sakol jouseu leh sakol-kangtalai jouse, sakol touthem jouse le agalsat mijouse abonchauvin adimlha tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Pharaoh in jong Israel mite umna lam anailut jep phat in ama hon Pharaoh lam chu avetou uvin, hichun ama hon anunglam uva Egypt mite ahung kitol chu amu tauve. Abonchauvin Pakai heng'a atao uvin, ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Mose heng'a aseiyun, “Ipi dinga gamthip noija hi thigam dinga neihin puidoh u hitam? Egypt a chu keiho dinga lhanmun lhingset uma hilou ham? Ka chung uva hi ipi nabola nahi hitam? Ipi dinga Egypt nei dalhah sah uham? ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Egypt gamsung kaum lai uva chu hitobang hi soh tei ding ahi tia ka seiju hilou ham? 'Nei dalha jeng tauvin! Egypt mite khut noija soh in umkit tau vinge. Hiche lai munna ka thigam sang uvin Egypt mite khut noija soh a kaum'u apha joi!'” tin asei tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Ahinlah Mose'n mipi heng'a aseijin, “Kicha hihhel un, dingdet jingun veuvin, tunia hi Pakaiyin na huhdoh diu ahiye. Chule tunia kipat avel'a Egypt mite namukit tah lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Pakai ama tah in nangho gal asat ding ahi. Nangho umthim beh un,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Chuin Pakaiyin Mose heng'a aseijin, “ Ipi dinga kaheng’a kap a nahim? Mipiho malamma akitolna diuvin seijin! ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Na tenggol jan doh tem in twikhanglen chung vum achun domin. Twipi chu sukhen'in chutileh Israel mite twikhanglen lailung tolgo lah a chu kijot ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Chule keiman Egypt mite lungthim kasuh tah ding, ama hon Israel mite thagamna ding angaito diu ahi, chuteng asakol kangtalai jouseu, asakol tounau nangho that gam dinga hungkon ahiuvin, abonchauva keiman ka thaneina aheng uva kakilah sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Egypt mite ma-sang'a kaloupina kakimusah ding ahijoi, chuteng keima Pakai kahi ahin hetdoh diu ahi!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Chuin Pakai vantil'in Israel mite ahin lhonpi'n, mipi masang lam'a meilom chu nunglam joh a ahung tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Chuin meilom chu Israel mite le Egypt mite kah a ahung umtai. Mu athimlha jeng tan, meilom jong meikong akisoh in kho ahung thim tan ahile, jan khovah keijin Israel mite chu Egypt miten ahin delpha tapouvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Chuin Mose'n atenggol chu Twipi San dung vumma ajah doh jeng'a ahile, chuin Pakaiyin twikhanglen dung chu solama kon hui ahung nungin ahin semhoh tan ahi. Jan khovah keijin huijin twikhanglen chu asem in, twikhanglen jong aki khen'in tol lham golai ahung umdoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Chuphat in Israel mite abonchauvin tolgo laiya chun akitol'un alang alang'a bang bangin twi chu akiting tan ahi! ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Chuin Egypt mite Pharaoh galsat sakol jouse, sakol kangtalai jouse chule sakol touthem jouse jaona'n twikhanglen lailung'a kitol Israel mite chu adel tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Jingpi ahi phat in Pakaiyin Egypt mite chu meikong leh meilom mangchan ahin vesuh tauvin ahile, chuin Egypt galsat miho chu abonchauvin suhna ding beijin anoh gam tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Pakaiyin akangtalai jouseu abonchan atuhtang gam tan ahile, kangtalai ho chu abonchan akitang den gamtai. Egypt miten jong asei tauvin! “Israel mite angsung'a kon'in jamdoh loiju hite!” ajeh chu “Pakaiyin Israel mite apan pin Egypt mite chung'a gal asat tai!” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Israel mite agalkai phat uvin, Pakaiyin Mose heng'a aseijin, “Egypt mite twijin ale lonkhum na dingin na tenggol jahdoh kit in, ati.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Nisa ahung sodoh toh ki lhon'in, Pakaiyin athupeh bangin Mose'n twipi chung vumma akhut ajah tan ahile, twipi jong angaija bangin ahung um doh kit tai. Egypt miten hoidoh agouvin, hinlah Pakaijin twipi lah a atollut tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Chuin Twi akitol mat kittan, Israel mite nung hindel a Egypt galsat miho le sakol touthem jouse, kangtalai jouse abonchauvin twijin achup gamhel tauvin khat jeng cha jong asohcha tapouvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Ahinlah Israel mite chu twipi lailung'a tolgo achun akitol jing uvin, twipi jeng jong ajet aveija akisong den jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Hiche nikho'a hi Pakaiyin Israel mite chu Egypt mite khut a kon'in ahugdoh in Israel mite'n amittah uvin twipi galla Egypt mite thilong kijam ho chu amu tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Egypt miten Isreal mite douna anei uva Pakai thahat le natoh kidang amuchen tauvin ahile, Israel mite'n Pakai chu aging tauve. Pakai le alhachapa Mose jong aging tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Chuin Mose le Israel mite'n Pakai avahchoijun la asa uve: “Keiman Pakai vahchoila ka sah ding, ajeh chu aman loupitah in gal ajou tai; sakol ahin achung toupa Pakaiyin twikhanglen lailunga aseplut tan ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Pakai hi kei dinga, ka thahat na le ka vahchoi dinga lomtah ahi; ajeh chu aman galjona eipetai.” Ama hi ka Pathen, ka vahchoi ding ahi, chule kapau Pathen ahin, choiat dinga lom Ama bou ahi! ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","“Pakai hi galhattah ahin, ajeh chu amin jong Pakai ahiye!”. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","“Pharaoh kangtalai jouse le agalsat jouse, Pakaiyin twikhanglen lailunga aseplut tauvin; Pharaoh deitum le alhentum ho abonchauvin Twipi San dunga aseplut gamtauvin ahi”. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Twikhanglen kinong in achup gamsoh hel jeng uvin; abonchauvin songtum bangin twinoi lamma a lhalhum gam tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“O Pakai nakhut jetlam hi loupi le thahat chungnung ahi. Melmate jeng jong asugam hel tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Na lalna leh na loupina jalin na melmate na lehkhup jeng e, na lunghanna nasatah in nahin tahlang jitan ahile; abonchauvin meijin changpol akah vamkei bangin akavam sohhel tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Nangma husan a kon'in twipi kinong jeng jong alhuh den in ahile atang jeng tai. Chule twikhanglen lailung'a twi kitang jong chu ale chupsoh hel jengin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Chuin Melmapa chun hitin aseiye, 'Keiman anung kadel ding ka phah tei ding ahi. Thil kiladoh kale lah ding chule ka deichat bangtah a kakile lah ding ahiye; ka chemjam ka sadoh ding, abonchauva kasat chap jeng ding ahiuve.' ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ahinlah nangman na haikhum in ahile, abonchauvin twikhanglen in achup tauve. Twipi hattah lailung'a alhum gam tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“O Pakai, Pathen dang ho jouse lah jeng'a jong koimacha nang kal lhah aumpon, amaho chu imacha toh akite thei deh pouvin, nangma kala koimacha thenna chang ding aum hih e. Loupina leh tijat umtah a thilbol a koiham? ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Nangman nakhut jetlam na jahdoh in ahile, hichun leiset a melmate avallhum gam tauve.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Na lungsetna long louvin, na lhatdohsa mite aumpi jingin ahi. Na chena mun geijin na mite nahin puilhung tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Mitin vaipin hichu ahin jasoh tauvin ahile; Philistine gamsung'a cheng jouse din nat hesoh achang tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edom gamsung'a lamkai kiti phot alung thomhao gamtan; Moab gam'a lamkai jouse jong akithing sohhel tauve. Canaaan gam'a cheng jouse jong alungthoi gam tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Nangman namite nahin puilut ding nangma molsang chungvum a chu na tundoh ding ahiye; ajeh chu nangman hiche laimun chu na chenna dinga na tundohsa ahitai, O Pakai nangman mun theng lai jeng jong chu na khut tenia na tundoh ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Pakai hi tonsot tonsot a chungnung chang ahitai!” ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ajeh chu Pharaoh sakol kangtalai jouse twikhanglen lailung'a atollut in, Pakai thahat chun achungvum uvah twikhanglen chu alechup sah gam ahitai. Ahinlah Israel chate abonchauvin twikhanglen lailung tolgo lah achun akijot galkai sah tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Chuin Aaron sopinu, themgao Miriam chun akhut a sum-eng behging akilah in numei jouse alamkaijin, behging abengun alam tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Chule Miriam chun hiche jaila hi a-oijin ahi: “Pakai vahchoila sau hite, Aman loupitah in gal asat in ajou tai; sakol chung'a toupa le akangtalai jeng jong twikhanglen lailung'a aleh hup jeng tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Mose'n jong Twipi San a kon'in Israel te chu ahin pui nalaiyun, chuin Shur kiti neldi gam'a akitol lut tauvin ahi. twidon ding thei louvin nithum sung'in akitol tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Marah mun ahunggei tauvin ahile hiche mun a twi chu akha'n don thei ahi tapoi. Hijeh chun hiche lai mun chu Marah asah tauvin ahi (hichu akha tina ahi). ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Chuin mipi chun Mose dounan “Ipi kadon diu hitam?” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mose jong Pakai lam sang'in kap pumin atao tai. Pakaiyin thing lhon neokhat avetsah in hichu asat doh in twi lah a chu akholut a ahile twi chu donthei ahung sohdoh tan ahi. Chuin Pakaiyin hiche Marah munna chun Israel te dingin chonna dan khat asempeh in Ama a akitah jingna diuvin jong hilchetna aneiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","“Aman hiti hin aseije, “Nangman ching thei tah in na Pakai na Pathen thusei ngaijin, Ama mitmua thudih jeng'a na chon ding, athupeh jouse nanit ding, hitia chu Egypt mite chung'a gamna hoise ka lansah chu nangho chung'a ka lansah louhel ding ahiye, ajeh chu keima na damsah na Pakai chu kahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Marah mun adalhah phat uvin Israel mite jong Elim kiti twiko som le ni putdohna mun tomthing somsagi kena munna twipang achun ngahmun akisem tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Elim a kon'in Israel mipi akitol uvin Sin* kiti gammang lam hichu Elim le Sinai Mol kahlah ahiye. Hiche mun chu Egypt gamsung'a konna ahung potdoh kal'u lhani alhing tan, hiche lhasung nisom le ninga lhinin ahunglhung tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Hiche mun jeng ajong chun Isreal mite Mose le Aaron heng'a aphunchel tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Ama hon aseiyun, “Kada tangei uve! Egypt gamsunga kana um laiyun saneh ding hihen changlhah hijongleh adimlha jeng jin, tun nangman hiche gamthip noiya hi kelthohsah a thigam sah ding nei got u hitam,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Chuin Pakaiyin Mose heng'a aseijin, “Vetan! Van’a konna keiman nangho ding ann kahin juhsah ding ahi. Nisim niseh a aneh diu adeichan'u aga kilo ding'u ahi. Hiche a hi amahon kathu angai angailou u kapatep diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Nigup lhinni teng keiman aneh khopset diuva anneh kahin peh ding ahiuve, hichu anehkhopset diu ajatnia tam hi ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Chuin Mose le Aaron in jong Israel mite heng'a aseipeh lhon tan, “Nilhah lam teng Egypt gamsung’a konna nahin puidoh pau chu koi ahi nahetdoh dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","“Chule jingkah lamteng Pakai loupina namu diu ahi, ajeh chu nangho nakiphin nau awgin Aman ajasoh tai, hichu Ama dia doumah um ahin, hichu keini chung'a doumahna neijin phun hihhel un, ati lhon'e.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mose'n asei aseikit in, “Pakaiyin nilhah lamma naneh diu sa nahin peh diu, jingkah lama naneh diu changlhah nahin peh diu ahi, ajeh chu Pakaiyin nangho na phunchel uva ama douna thu na seinau aja soh tai. Keini a kon ipi jeh a na kiphin'nu ham? Henge, na phunchel nau chu keini douna hilouvin, Pathen douna ahijoi,” ati lhonne. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Chuin Mose'n jong Aaron heng'a aseijin, “Israel mite jouse heng'a seipeh tem in: 'Nangma cheh Pakai angsung'a kipelut uvin, ajeh chu Aman nangho phunchelna ajahsoh ahitai, tin seiyin,'” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaron in jong Isreal mite jouse heng'a aseiyin ahile, ama hon gammang lah chu avele tauvin ahi. Ama hon Pathen loupina thil chu vanlam'a amu tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Chuin Pakaiyin Mose heng'a aseijin, ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Keiman Israel mite phunchelna ka jasoh tan ahi. Tun nangman aheng uvah seijin, 'Nilhah lamteng naneh diuva sa kahin peh ding nahiuvin chule jingkah lamteng naneh diuva changlhah kahin peh ding nahiuve. Chuteng nang hon keima hi na Pakai ule na Pathen'u kahi na hetdoh ding'u ahi,'” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Hiche nilhah lam chun vamimte ahung kitol tauvin ahile ngahmun chu alo dimlha jeng tauve. Jingkah khovah ma chun ngahmun kimvel lah jouse chu daitwi jin ana chup in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Chuin daitwi ho chu ahung kihoh dohtan ahile, gammang lah akon chun thilpha tah khat alomlom chan ahung um tan, hichu abeh beh a kigol'in anaum'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israel miten jong hichu ahin mudoh tauvin ahile, amaho akidongto cheh un, “Hiche hi ipi ahidem?” Ama hon ipi ahi chu ahedoh jou pouvin ahi. Chuin Mose'n ahilchen un, “Hiche hi neh ding'a Pakaiyin napeh u ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Hicheng hi Pakaiyin aseije: Nangma insung cheh in naneh khopset diu kilah unlang, chule mikhat in vamim jatnia tamjo naponbuh sung uvah kichoi lut un,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Pakaiyin athupeh bangin Israel mite'n jong abol tauvin ahi, kimkhat in tampi akichoiyun, akim khatma chun achoi khambep cheh akichoi uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ahinlah atetoh uvin ahileh, tamtah hin kilah ho ahin chule ama ding khambep hin kilah ho jong hiti chun, kitam lah chom leh kilhom lah chom um louvin; abonchauvin kitohchet chet in akihom uvin aki choiyuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Chuin Mose'n aheng uvah aseiyin, “Jingkah khovah lhah channa ahalsi cha jeng jong nakoi lou diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kimkhat chun angaisah pouvin changlhah aneh moh uchu jingkah lam chanin akoiyun ahile, changlhah akoi den hou chu than achutan a uilha gamtai. Mose jong achung uva chun alunghang lheh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Jingkah sih in mipiho chun aneh khop cheh diu changlhah chu aga kilo jiuvin, nisa ahungsat doh tengleh vang changlhah ho chu ajunmang jitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Nigup lhinni tengleh changlhah chu achan jatbep cheh diuvin akilo uvin ahi. Khoppi lamkai ho ahungun ahilchen diuvin Mose adongun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Aman aheng uvah aseiyin, “Pakaiyin hiti hin aseije: Jing nikho teng nangho nakicholdo diu ahi, ajeh chu Pakaiya dia Sabbath nikho theng ahi. Changlhah nakisem thei jat chan'u tunin kisem unlang, hiche ho chu jinglam'a ding jong kikoi doh tauvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Mose'n athupeh bang'un changlhah phabep chu achomin jingkah khovah chanin akoiyun ahi. Jingkah in changlhah ho chu ima ati tapon than jong chulouvin hoitah in ana um'e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mose'n aseijin, “Hiche changlhah hi tunin neuvin, ajeh chu tunikho hi Pakaiya dia Sabbath ahi. Ajeh chu tollhamma changlhah umlou ding ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Nigup sung'a changlhah nakilo cheh diu, ahin nisagi ni chu Sabbath ahi. Hiche nikho a chu an umlou ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kim khat chu Sabbath nikhon changlhah kilo din acheuvin, hinlah changlhah khat jeng cha jong amu tapouve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Pakaiyin Mose heng'a aseijin, “Hiche mite hin itih chan ka thupeh apalkeh diu hitam? ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ama hon ageldoh diu chu Sabbath nikho hi Pakaiya kon ahin Aman eipeh u ahiye. Hijeh a chu Pakajin nigup sung'in changlhah neh ding na peuvin, nigup lhinni man nini sung'a neh ding changlhah na peuve. Nalah uva koi hijonglehu chun na umna cheh uva umthim beh jeng uvin lang,’ nisagi lhinni teng koimacha achenna munna kon'in pamlama potda jeng tahen,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Chuti chun nisagi lhinni’n koiman an agaloh tapouvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Israel miten changlhah chu Manna asah tauvin ahi. Hichu muchi mu tobang bang ahin, atui dan jong khoiju tobang ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mose'n asei in, “Pakai thupeh chu hiche hi ahiye: Nakhang lhumkei uva um jing dingin manna kihamdoh cheh uvin, hichu nakhang lhumkei uva mite hon Egypt gamsung'a konna kahin pui uva gamthip lah a manna a kahin vah nau ahidan ahetdoh thei ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mose'n jong Aaron heng'a aseijin, “Belneo khat latem'in asung'a chun manna phabep khat khum'in. Hichu akhang akhang'a um jing dia Pakai ansung munthenga nagakoi ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Pakaiyin Mose athupeh bangin Aaron in jong aboltan ahi. Pakai angsunga akhang akhang'a hettohsah a pang dingin kitepna thingkong maiya chun akoi tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israel mite'n jong achenna diu mun ahin phah kahseuvin, kum somli sung sen manna jeng ahin neuvin, Canaan gam ahung lhun kahse uva dingin manna jeng chu ahin netauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Manna Omer dimkhat chu Ephah khat seh hopsom'a hop khat toh aki bangin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Pakai thupeh bangin Israel chate abonchauvin Sin* gammang a kon'in akitol uvin mun khat akon mun chom khat a akitol leuvin ahi. Rephidim kiti mun a ngahmun akisem uvin hinlah hiche lai mun a chun twidon ding aum tapon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Mipi jong Mose heng'a avellin a phunchel kit tauvin, “Don ding twi neipe uvin,” ati tauve. Mose'n adonbut in ajah uva, “Ipi dinga kei kom'a kiphin'a nahiuvem? Chule ipi dinga nang hon Pakai na patep uham?” ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Mipi hon twi angaicha jing uvin Mose dounan thu aseijun akiphin gam tauvin, “Ipi dinga Egypt gamsung'a konna neihin puidoh mong mong'u hitam? Nangman keiho le, ka chate'u chule ka gancha teu ka boncha uva dangchah a thigam sah ding nei got uva hitam?” tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Chuin Mose jong Pathen heng'a kap pum'in ataovin, “Hiche mite ho dinga ipi kabol ding hitam? Song'a selih ding eigo tauve!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Chuin Pakaiyin Mose heng'a aseijin, “Mipiho masanga kon chun kikhindoh tan. Nile vadung najepna tenggol chu kichoiyin lang Israel upaho phabep kipuijin. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Keiman Sinai mol a songpi chung’a ka dinpi ding nahiye. Songpi chu jep lechun twi hung kikho doh jeng ding ahi. Israel miten adon thei diu ahitai,” ati. Chuin Mosen songpi chu akiseipeh bangin ajep in, chule upa hon avet laitah un twi chu ahung kikhodoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Mose'n jong hiche mun chu Massah asah tan ahi (hichu ‘patepna’ tina ahi) chule Meribah (hichu “nelkal” tina ahi) ajeh chu Isreal mite Mose heng'a phunchel pumin Pakai patepna aseidoh uvin, “Pakaiyin hikom'a hi eiumpiu ham eiumpilou uham?” atiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Israel mite Rephidim mun aum jing laiyun, Amalek mite ahung kon uvin akisatpi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Chuin Mose'n jong Joshua heng'a thupeh aneiyin, “Amalek mite toh kisat ding pasal galsat ding phabep khat lheng doh tem'in. Jing nikho le keima gamlah molsang'a kadin ding hichea chu Pathen ban thahat kadopsang'a kapan ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Mose thupeh bangin Joshua'n jong galsat ding pasal phabep alheng doh tan Amalek mite chu gal akisatpi tauvin ahi. Chuin Mose, Aaron leh Hur amaho cheng chu gam lah molsang lam'a akal tou tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mose'n akhut teni adopsang chanin Israel mite ahat be cheh jiuvin, chule akhut teni akham tengleh vang Amalek mite ahatji tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mose khut teni chu ahung kham tan ahile aman jong adomsang jou tapon chuin Aaron le Hur in jong akhut ngapna dingin song ahol le lhon tan, akhut teni chu song chung'a angam lhan toumun in nilhum keijin akhut chu chol louhel in adomsang thei lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Ajonan Joshua le agalsat mihon Amalek mite chu ajou tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Gal ajo phat uvin, Pakaiyin Mose heng'a aseijin, “Het jingna dingin lekhajol khat lan lang hiche gal kisat chung chang thu hi sunlut inlang Joshua jah din gingtah in simin: Keiman vannoiya Amalek kihetna kiti ka suhmang hel ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mose'n jong hiche lai mun achun maicham asem in, Yaweh-Nissi (“Pakai chu ka ponlop ahi”) tin asah tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Aman aseijin, “Amahon Pakai laltouna douvin khuttum adomun, tua pat akhang akhanga Pakaiyin Amalek mite akidintepi ding ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Mose dinga anupa pa, Jethro Midian thempupa'n Mose le asopi Israel mite chung'a Pakai natoh thil kidang abol ho ajadoh tai. Amapan jong Pakaiyin Israel mite Egypt gama konna ahin lhatdoh chu kidang asaval jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Mose'n jong anupa pa, Jethro heng'a ajinu Zipporah le achapa teni chu asol'in, chuin ama hon insung'a apuilut uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","(Mose chapa apeng masa min chu Gershom ahin*, achapa apen lhah chun Mose'n hiti hin aseiye. “Mi gamsung'a khosa kahi,” tia ana minsah chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ani channa achapa min chu Eliezer* asah in, Mose'n hiti hin aseije, “Keima khanglui laiya pat ka Pathen chun Pharaoh chemjam akon eihuhhing ahi,” tia asah ahi.) ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mose nupa pa, Jethro chu Mose villin gammang lam'a ahung tan ahile aman ajinu le achapa teni chu ahin puijin, Mose le amiten gamthip lah a Pathen molsang kom'a ngahmun akisem nau mun ahinpha tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Jethro in jong Mose chu thu athot tan, “Keima Jethro nanupa pa kahin, keima nangma vil'a najinu le na chapa teni toh hung kahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mose jong pamlam'a aga chedoh in anupa pa chu aga kimupi tai. Ama jong akum lhan abeng achop peh tan ahi. Hiti chun khat le khat akilem touvin Mose chenna ponbuh sunga alut tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mose'n jong anupa pa heng'a Pakaiyin ichan geiya Egypt gam'a konna Israel mite chung'a na ahintoh ham ti thudol'a aseipeh in ahi. Chule lamkah jousea thohgim hahsa athoh nau le agentheina jouseu abonchan anupa pa henga aseipeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Pakaiyin Israel te ichan geiya Egypt mite khut a kon ahin panpi hitam tithu le ahin huhdohna thudol phatah a ahet chet phat in alungthim akipah lheh jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Jethro'n hiti hin aseiye, “Pathen thangvah in umhen.” “Ajeh chu Aman Pharaoh le Egypt mite a konna nahin huhdoh jal in. Henge, Pakai bou chu ahiye Egypt mite thaneina a konna na huhdoh uva!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","“Tun keiman ka hechen sel taije, Pakai hi pakai jouse lah a thanei chungnungpen Pakai ahiye. Ajeh chu Aman aban thahat apanin Egypt mite akiletsah nauva konna Amite ahin huhdoh ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Chuin Jethro, Mose dinga anupa pan jong Pathen angsung'a pumgo thilto kilhaina asem in ahi. Aaron le Israel sung'a upaho ahung uvin Pathen angsung'a kilhaina ankong chu asoh khom uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ajing nikhon Mose'n jong atouna a konin mipi ho thutan dingin ahung doh tan ahile, mipi ho jong chu nilhum keijin ading tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mose nupa pan, hitia mipi ho chung'a athilbol amudoh phat in aman Mose heng'a aseijin, “Hiche lai mun a hi ipi mong mong tongdoh inge nati ham? Ipi bol mong inge natia jingkah a kipat nilhah chan geiya mipi ho hi nahiti dinsah hitam?” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mose’n adonbut in, “Ajeh chu mipi ho hi kaheng’a hung uva Pathen akon vaihopna hi akilah got u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Amaho hi ahung kinah komu le kaheng ahin jonlut jiuvin, chuteng keiman thu katan peh jiuvin, Pathen akon nun leh khan dan toh kitoh a Pathen phatsah bang'a ka hilchen jiu ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Chuin Mose nupa pan “Na thilbol hi adih poije!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","“Mipi ahin nangma nahin nabon uva na gimna diuva ahi bouve ajeh chu na thilbol hi abaipon ahi. Nangma changseh adin thil hahsa tah khat ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Tun keiman kahil nahiye, ajeh chu keiman kultah a kahil nahi ngaijin lang Pathen'in naumpi jing hen. Mipiho jouse khella hi Pathen ansung'a ding jing nahin, akibaotam nau jouse Pathen angsung'a na selhah ding ahijoi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Mipiho hi Pathen akon chonna Dan ho le phatsahna ho hilchen inlang, hichu abolteina diuvin thumop in. Hinkho hi iti man ham ti vetsah in. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ahinlah mipi ho lah a konna thilbol thei mi mantam, Pathen ging, nehguh chah guh beija natong thei ding nalhen doh ding ahi. Amaho chun mi sangkhat lah hihen, jakhat lah, somnga lah, somkhat lah hijongleh aloi loija vaihom'a na pansah ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Phat tinna mipi thutan a napan sah diu, thupi deuva thutanna ding aum vang le nangma heng'a hinpuiyun tin, thuneo ho jouse vang chu ama hon ama cham a atanlhah jeng theiyu ahi. Nangma dia jong agom lam hijo ding chule ama hon jong nangma nahin kithopi nau jong ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Hichengse hi najuiya ahile, nangma chunga Pathen'in toh ding nahin peh teng doujouna tha nanei joh ding chule mipi hon jong lungmoung sella ama ama in cheh akile jot thei diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mose'n jong anupa pa Jethro thusei chu angaijin, aman asei bang bangin aboltan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Israel mite lah a kon'in thilbol thei mi mantam cheh alheng doh tai. Amaho chengse chu Israel mite lah a lamkaija pang ding hichu mi sangkhat, jakhat, somnga, somkhat chung'a vaihomin apansah sohkei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Amaho chun kiphunna le baotamna neiho chu Mose heng'a ahin lhut jiuvin ahi. Thuneo boina ho vang chu ama hon acham'un asulham jiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Hiche ho jouse nung hin, Mose'n anupa pa availhah in, ama jong agam langa akile tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israel miten Egypt gamsung* ahin dalhah kalseu lhani lhin'in Sinai mun gamthip ahunglhung tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Rephidim ngahmun ahin dalhah nung uvin Sinai gamthip noi ahin jot un Sinai Mol kom'a chun abusa tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mose molchunga akaltou tan Pakai toh aga kimuton ahile, Pakaiyin molchung'a kon'in ahin kouvin aseije, “Thupeh hiche ho hi Jacob insung le Israel mite heng'a seipeh tauvin: ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","'Egypt mite chung'a ipi ti lamdol'a na katoh nang hon namu sohkei uve. Keiman nangho muvanlai lhaving'a kahin pui uve ti namu chenset tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Chule tua hi kathu nangai uva kakitepna nakoi jing uva ahileh, nangho hi vannoi mite jouse lah a keima dia atumbeh a naum diu; ajeh chu vannoi leiset pumpi hi keima a ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Chule keima lenggam a chu nangho na leng chan diu, ka gamtheng nalo ding'u ahi. Hiche thu hi nangman Israel mite heng'a na seipeh tei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Chuin Mose molchunga kon'in akumsuh in Israel sung'a upaho akou khom'in Pakaiyin a thupeh chengse abonchan aseipeh sohkei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Chuin ama hon adonbut cheh uvin, “Ijakai Pakai thupeh bang'a keihon kabol diu ahi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Chuin Pakaiyin Mose heng'a aseijin, “Keima naheng'a meilhanga kahung ding, Mose, nangma kahin houpi teng Israel miten ajah cheh diu, chuteng ama hon jong nangma nahin tahsan jing diu ahi,” ati. Mose'n jong Israel miten adonbutna chu Pakai heng'a aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Chuin Pakajin Mose heng'a asei in, “Kumsuh inlang keima kahungna dingin Israel mite gongtup tan, tuni le jing nikhoa din seipeh uvin chule avon jengu jong kisop theng cheh uhen. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Nithum lhinnia dingin kigontup sah sohkei uvin, nithum lhin niteng amitmu tah uva Pakai chu Sinai Mol chung'a pat hung kumlha ding ahi tipeh un. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Mol kimvel achun gamgi semin. Mipi ho chu gihgah in, 'Kichih theiyun! Koima molchung lam'a kaldoh hih hel'un chujongleh gamgi jeng jong koiman natham khah theilou diu ahi. Koi hileh mol thamkha chan chu thi jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Mihem hihen ganhcha hijongleh gamgi kallhah taphot chu songa se jeng ding, ahilouleh thalpi a kap jengun. Amaho chu tha doh ding ahi. Ahinlah, sumkon ahung kimut ginga pat mipi jong molchung lam'a kal thei ding ahiuve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Chuin Mose'n jong mipi lam chu ahin jonsuh tai. Aman houkhomna a din mipi thensona aneijin, mipi hon jong ama ama von cheh akisop theng uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Aman mipi heng'a aseijin, “Nithum lhin nia dingin ki gotup cheh uvin chule nu le pa kitimatna a jong naki kangse ding'u ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Nithum lhinni jingkah khovah lam'in, vah akithing'in kolphe avah in, molchung achun meilhang ahung kum lha jeng tan ahi. Sumkon hatah in ahung ging tan ahile, ngahmun sung lam'a um mipi abonchauvin akihotlhul lhajeng tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mose'n jong mipi abonchauvin Pathen toh kimaito dingin ahin pui uvin, chuin mipi abonchauvin mol bul achun ading gam tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sinai molchunga konin Pakai chu meikhu in ahung kum lhan ahile, lhum sung'a konna mei bangin ahung khudoh jeng tan, liing jong akihot lha jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Sumkon gin chu ahat cheh cheh jeng tan ahile, Mose jong akipat in hiti hin aseije, van gin kithong lah a konin Pathen'in ahin houpin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Pakai chu Sinai molchung vum'a kon'in ahung kumsuh tan chuin, Molchung vum'a kon'in Pakaiyin Mose ahin kouvin ahi. Mose jong akipatdoh in molchung lam'a chun akal touvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Pakaiyin Mose heng'a aseijin, “Kumsuh inlang mipi heng'a seipeh loijin, ajeh chu Pakai amunom uva gamgi khu ahin khal uva ahile thigam ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Chule thempu ho Pakai kom nai jing ho jengin jong ama cheh akithenso uva ahile bou Pakaiyin asuhmang lou diu ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","“Hinlah Pakai,” tin Mose'n aseijin, 'mipi abonchauva Sinai molchung'a hung kal theilou diu ahi. Ajeh chu nangman nei gihgah u ahitai. Nei seipeh bangin, 'Mol kimvella gamgi sem a athenga umsah dinga nei thupeh sa'u ahiye'” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Ahinlah Pakaiyin aseiyin, “Chesuh inlang Aaron gakipuiyin lang hin kilhonpi tan. Amavang thempu ho le mipi ho abonchauvin thupeh neijin lang koimacha gamgi khokhel a Pakai lam'a hung theilou ding'u ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Chuti chun Pakajin athupeh bangin Mose achesuh in mipi ho heng'a aga seipeh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Chuin Pakaiyin mipi ho thupeh hichengse hi apen ahi: ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Keima Pakai na Pathen'u chu kahi, Egypt gamsung'a nasoh channa uva konna nalhatdoh pau chu keima kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Keima tailou Pathen dang nanei louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Nang hon limsemthu pathen van a ahilouleh leiset a ahilouleh twikhanglen'a um ipi thil hijongleh nakisem theilou ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Hicheng ho angsung'a chu naboh khup nahou thei louhel diu ahi, ajeh chu keima, Pakai na Pathen u kahin pathen dang na kisem uva ahileh, keiman nangho heng'a ka lethuh diu napu napa teu le nangma insung cheh chule akhang thum le lina channa lethuh ding kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Keima thupeh nit jinga, eingailu mi chu asang aja chung'a kalungset na longlou chu ka umsah jing ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nangman Na Pakai le na Pathen min jeng jong ajeh beija namin phah louding ahi. Ajeh chu Pakaiyin Ama min ajeh beija minphah chung'a themmo achansah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Cholngah nikho hi atheng'a nanit jing ding ahi ti sumil hih hel'in. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Natoh ding cheng nigup sungse'a natoh chai ding, ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","hinlah nisagi lhinni hi na Pakaiya dia cholngah nikho, hiche nikhoa hi nangman natoh ima nabol louhel ding chule nangma nahin, na chapa, na chanu, na sohpa, na sohnu, na gancha jouse le na kelkot phung hung sunglha a na kholjin mi na boncha uva ima natoh thei louhel diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ajeh chu Pakaiyin nigup sungsen van le leiset, twikhanglen le asung'a um jouse ana sem in; hiche nikhoa chu Pakaiyin cholngah nikho hi atheng dia phatthei aboh a ana lhandohsa ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Pakai na Pathen'in napehsa hiche leiset chunga na hinkho asot theina dingin nanu napa ging jingin. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Toltha nabol louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Mitoh jon nabol louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Guchat nabol louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Na sopi muda man a thuse pole a napan louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Na kinaipi khat inchen chu na thangsetpi louding ahi. Na sopi ji khat chu na deichat louding, chule asohpa ahin, asohnu ahin abongchal ahin, asangan hijongleh na sopi chule na kinaipi kom'a thil ima navetlal louhel ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mipi hon van gin nasa tah chu aja tauvin, kolphe jeng jong amu tauvin, molchung lam'a kon meikhu amu tauvin ahile amaho chung'a kichatna alhung tan, kithing pumin gamla tah a ading den tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Chuin mipi hon jong Mose heng'a asei tauvin, ‘Sei dinga na deisah chan keima ho heng'a seijeng tan, na sei kangai diu ahiye. Ahinlah Pathen'in keiho heng'a thu seikha taleh mohseh a ka thigam lhah jeng ding'u ahi!” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","“Mose'n adonbut uvin hiti hin aseiye, “Kicha hih un,” Pathen na gin diu chule na chonset theilou na diuva, nangho sudet dinga Pathen hung'a ahi joi!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mipi ho chu gamla thim achun adingun, Mose vang chu mei jing lah a Pathen kom chu anaijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Pakaiyin Mose heng'a aseijin, “Hiche hi Israel mite heng'a seipeh tauvin: vanna kon'in nangho toh kihouna kaneije, tihi namit tah uvin namu tauve,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Geldoh jingun, sana hihen dangka a kisem pathen dang kiti keima douna a nasem loubeh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“Keima dinga leiset a konna maicham bolna nasem ding, hiche maicham chung'a chu na kelngoi le keltah chule bongchal pumgo thilto le chamna thilto a nato ding ahi. Hoichan hijongleh Keima geldoh jing na dinga maicham natundoh na a chu naheng'a kahunga phatthei kaboh ding nahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Songa konna maicham mun nasem ding le khutthem lutna song naman louding ahi. Ajehchu khutthem lutna a kisem chu kintheng bolna dinga lhinglou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Chule kaltouna khochut umna a maicham nanai louding ahi. Chutia chu nabol leh, noiya konin min hinvetou khaleh sagohkeo nahi amudoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Hichengse hi Israel mite chonna ding dan ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Hebrew mi soh dinga na choh tengleh, ama chun kumgup sungsea soh na chu atoh jing ding, kumsagi ahung lhin teng vang le soh a kivul mi chu chamlhat chang ding che ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Soh a pangpa chu ama chang seh seh bou ahileh, ama bou kile ding chule, jineisa ahi khah tah le, ajinu jaona anilhon'a kilhon doh lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Hiche sohpa chu apupan ji aholpeh a ahile, achate sese leh sohpa jinu chu apupa chang ding, ajona tengleh sohpa chu achangseh a che ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Ahinlah sohpa chun hitia asei ding, 'kapupa kangailun ahin ka jinu chule ka chate abonchauvin kalha ngaije.’ Chamlhat chang din cheda jeng ing'e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Hitia chu aseiya ahileh, apupan Pathen heng'a ahin puiding, hiche asohpa chu kotphung gei hihen kotphung khom chan hijongleh ahin puija, chuteng apupan thihtul khat a asohpa bilkol a vuhom peh ding ahi. Hiche jouteng chule sohpa chu ahinkhoa apupa kin’a kisalal ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Pasal khat bang chun achanu soh dinga akijoh doh dinga ahile, amanu chu soh pasal ho bang'a kisol doh louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Hiche sohnu chun apupa lunglhaina mong mong aboldoh joulou dinga ahile, apupan jong midang akilhat doh sah thei jeng ding, apupan hiche sohnu chu kitahna nei louvin anabol tan ahile amanu chu apupan jong gamchom a johdoh son na ding ima agel louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ahinlah hiche sohnu chu apupan achapa toh kicheng dinga agon’a ahile amanu chu soh a bol louva achanu banga abol ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","“Mi khat chun sohpa ji chu jia aneiya aman jidang akipuiya kit a ahile, aji masa chu anneh, sil le chen, nupa kitimatna ima nahsah louva akoi louding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","“Aman hiche thum ho lah a nahsah pehlou aneiya leh, amanun ima pelouva adalhah a chamlhat ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Khat touvin midang chung'a akhut alha khah a ahile akhutlha pa chu tha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Hinlah Pathen phatsah a kihetkhelna maimai jeh ahile, Keiman kihuhhingna ding mun kagon a chulaiya chu mi mavopa akihuhhingna dia jamlut thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Amavang, khat touvin midang khat chu gotten’a atha leh, hiche mithat pa chu Ka maicham phunga konna kaidoh a tha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Koi hileh, anu ahilouleh apa chung'a khut lha aum'a ahile ama chu tha jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Mihem gumang aum'a, amiguhpa bang chu ana johdoh tah a chule akom'a ana um nahlaiya, akom'a aum pet hichu ama toh kimudoh khom hijongleh, akimudoh pa chu tha jeng ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Koiman anu apa a engbol thei louding amavang anu engbol mihem chu tha jeng ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Tun, Pasal khat le pasal khat akinah a, khatpan jong khat pa chu song tum'a asuh ham akhut tumma akhet ham ahile hiche amisuhpa chu athipai deh louva ahile jalkhun anga ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","“Ahinlah alhupa chu ahung kitho doh a tenggol mangcha a avale theiya ahile, ama ana sukhapa chu achung chang kisutheng thei ding, anatna sung'a akijenna phat mansah chengse alepeh ding chule ajen damsel ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Mihem khat touvin asohpa ham asohnu ham chung'a khut alha a athi khah le, soh neipa chu thina chang ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","“Ahinlah hiche soh kijep pen chu nikhat ahilou le nini sung'a adamtheng tah a ahile, soh chung'a khutlha mihem chu thina chang louding ahiye. Ajeh chu soh kivul mi chu ama nei gou khat ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Tun tekah nan, pasal ni akina tan, numei naovop lai chu asuh khah tah lhonna anaovop chu kisuhmo'a aphat louva ahung potdoh khah tah le, numeinu sukha penpen chu ajipan jong anop channa aman adel khum jeng thei ahi. Ahinlah apeh ding chengse chu thutan vaihom hon aphatsah peh u angaiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","“Amavang numeinu kisuhkhahna khonung'a ahung nat khah tah le: hiche hinkho khel dinga chu hin kho khat ma lepeh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Mitchang khella michang hi ding, ha khella ha hi ding, khut khel a khut hi ding, keng khel a kengg napeh ding, ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","meiyin akah a ahile meikah jeh a meiya na le peh ding, kimavo jeh a namavoa chule kijep jeh a chu nale jep jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Mihem koitobang khat chun asohpa ahilouleh asohnu ham mit asuh khah peh a ahile, hiche soh chu amit adam tahlou jeh a chamlhat dinga asol doh jeng ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Soh goiya pang pan jong asohnu ham, asohpa ham khat chu aha asuhlhoi peh a hile, aha asuh lhoipeh tah jeh a hiche sohpa ham sohnu ham chu chamlhat chansah dinga asol doh ding ahitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Bongchal khat touvin numei ham pasal ham khat chu aki a ahin pihlih khah a ahile, hiche bongchal chu song'a selih jeng ding ahiye. Amavang bongsa chu koiman aneh thei louding chuteng bong neipa dinga achung chang thu kisutheng ahitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","“Ahinlah hiche bongchal chun masang kisanna mihem dang ana pihlihsa ahileh, aneipa jengin jong anahsah lou ahitah leh, hiche bongchal in jong numei ham pasal ham chu aki a apihlih khah a ahileh, bongchal chu thadoh jeng ding chule aneipa jeng jong anigel la tha teitei lhon ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Amavang athipa chu long lhatna dinga aki peh doh a ahile, aki pehdoh sah jat chu aman jong long lhatna dinga apeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","“Hiche bongchal chun numei ham pasal ham khat ahin pih lih khah le, hiche gancha neipa chu dan kisem dungjuiya kitham gah ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","“Bongchal chun soh numeija pang ham pasal ham khat chu ahin pihlih bang ahileh, bongchal neipan jong soh neipa chu dangka shekel somthum apeh teitei ding chule hiche bongchal chu song'a aselih pai jeng ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Tekah nan, mikhat chun kokhuh khahbit louva adalhah jeng'a sangan ham bongchal ham kokhuh a alhah lut a athiden tah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","“Kokhuh neipan jong aphat toh kitohchetna asem phat ding, gancha neipa jong sum apeh ding, a gancha pohlih vang chu ama chang ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Mikhat bongchal chun midang khat bongchal asuhkhah a asuh khah bongchal chu athi jeng'a ahile, bong neiten jong hiche bongchal athi loulai chu akijoh doh diu akijohdohna man vang chu kihom lhon ding, hiche bongchal thisa jeng jong chu aman kihom lhon ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","“Ahinlah hiche bongchal chun masang jeng'a jong gancha dang ana pihlih jeng'a ahile, aneipa jengin jong ahilchahsa ahi a chule ngaisah a akoi louva ahile, anei pan jong bongchal thi chu bongchal khat mama a alesah ding, bongchal thisa vang chu ama chang teitei ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Mikhat touvin bongchal ham kelngoi ham aguhdoh a hichu akitha ham ahilouleh akijoh doh ham ahile bongchal khat chu bongchal nga a ale ding, chule kelngoi khat chu kelngoi li alepeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Gucha chun jankah a inbang aphetvang jeh a ama chu akimatna akivohlih khah tah a ahileh, hiche guchapa hinkho that pa chu tolthat a kisim louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Ahinlah hiche thilsoh hi sun khovah pet ahivang leh mithat pa chu tolthat a kisim ding ahi. “Ajeh chu gucha kiman chun, athil guhdoh jouse aboncha alesah kit ding ahin, alesah joulouva ahileh ama chu kijoh doh a athil guh ho sahna a kinei ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Khat touvin bongchal hihen lang, Sangan hihen, Kelcha hijongleh aguhdohsa khat ama insung nei le gou lah a aga kimatdoh khah a ahileh ajat lenia asah kit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Mihem koi hileh loulaija gancha alutsah a lengpi lei ham khat gasoh aneh khah a ahileh gancha chingtup louva loulaija alha thang jeh a hiche pa chun aloulaija gasoh phapen a chu alepeh teitei ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Chule loulai meiyin ahinkah khah a ling le khao leilah ahin kah jeng'a, chang aki at-lai leh a ki-at loulai mun lah chule loulai chu akahvam lhah jeng tah a ahile, meihal pen pen chun akahvam chengse aboncha alesah cheh cheh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Tekahnan mi khat touvin aheng akom'a sum ham thil khat koi dinga angensea ahile, hiche thil chu akoipa insung'a konna aki guhmang khah tah a ahile hiche gucha pa chu akimat matna a athil guh chengse aboncha ajat nia alepeh cheh cheh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Amavang hiche guchapa chu akimatdoh khah tah louva ahile athil koipa chu alah ham alou ham ti hetchetna dinga Pathen angsung'a kipui lut ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Mi khat touvin asopi khat kom’a gancha manchah dinga alah a hiche gancha chu akisuh khah, ahilouleh athi khah tah a ahile, hiche vang chu alapan aman phatah a lepeh cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Tun tekahnan mi khat touvin aheng akom khat ngansena aneija sangan ahilou le bongchal ham kelngoi ham gancha khat pen pen apeh a ahile, hichu koima muphah nalou munkhat a akidel mang tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Hitia chu aum khah tah le anigel lhonna Pakai angsung'a kihahselna anei lhon ding ahi. Chuteng gancha neipan jong kihahselna chu anganse jeng ding hiche gancha chu asah louding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ahinlah akoipa a konna kigumang anahi khah tah le, gancha koipan aneipa chu phatecha alepeh cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Gamsahang in atha khah ahitah le hiche hetchetna chu gancha koipan jong avetsah ding, chuteng gancha koipan asah tah louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Mi khat touvin asopi khat kom’a gancha manchah dinga alah a hiche gancha chu akisuh khah, ahilouleh athi khah tah a ahile, hiche vang chu alapan aman phatah a lepeh cheh cheh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ahinlah aneipa umpet toh akito khah a ahile alapa chun asah tah louding, manpeh dinga alah ahi jongleh alahman toh akitosah cheh cheh ding ahitai.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Pasal toh kihepha loulai nungah khat chu pasal khat in ajol lhah a alupi khah a ahile, aman jong hiche nungah nu man chu apeh ding chuteng jia anei pai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ahinlah nungahnu pan achanu chu hiche pasalpa chu apeh nom hihbeh jeng'a ahileh, amapa chun nungah thengho man kikhum peh jat jat apeh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Nangman numei doithem kiti nahinghoi louding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Chule koi hijongleh gancha toh lumkhom kiti phot chu tha jeng ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Koi hijongleu chun Pakai kom tailouva kilhaina dang nei mihem chu tha jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Maljin kiti chu adih louva nabol louhel ding, na suhgenthei louhel ding ahi. Ajeh chu nangho jong Egypt gamsung'a maljin ana hisa nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Meithai le chaga jeng jong na ngailut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Amaho na suhgim uva ahile amaho kaheng lama hung diu chuteng keiman amaho taona kasan ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Chuteng ka lungsatna nachung uva hunglhung ding naji teu kasat lhuh gam diu, nacha teu chaga kisoh gam ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Chule naheng nakom'a um kamite khat tou sum le pai nabat sah ahile, vaichapa chung'a chun sumkol vei tobangin umdan lang, sumtong jeng jong ama chung'a chu nadel khum louhel ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Naheng nakom ponsil khattou tundoh dinga nalah a ahile, nilhum masang'a hiche ponsil chu aneipa nalepeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ajeh chu aman hiche bou chu tahsa ponsilla anei ahin, pondang silla imutpi ding aneilou ahin ipi pon akisil ding ham? Keima heng'a hung tao henlang hile keiman ama chu kangai peh teitei ding ahi ajeh chu keima hi milainatpi jing kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Pathen doumah nasei thei louding chule namite lah a vaihompa jeng jong gaosapna nabol louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Na lhosohga le na lengpi gasoh chengse chu lung opkaina neilouhel'a nakatdoh jing ding, nachapate lah a apeng masapen chu keima nei peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Na bongchal le na kelngoi jeng jong hitia chu nabol ding, hiche gancha nou chu nisagi sung'a api koma umden ding, ahinlah niget lhinni tengleh keima nei pehdoh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Nangho ka mitheng te nahi diu ahi. Chujeh a chu gamlah a sahang'in athasa kiti naneh louhel diu ahi. Hiche tobang ho chu uicha te neh dinga napeh diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Nangman jouthu nasei thei louding, muda jeh a thet umtah hettohsah a napan thei louding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Chule thilse bol dinga mihem chele ho jong najui a najop louhel ding, mipi nung najui louva amaho khat le khat kikah a them achan theina diuva jong hettohsah a napan louding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Vaichaho thu kitanna jenga jong pan nalah louhel ding, sihnei langneina jeng jong nabol louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Chule na melma khat sangan ahi louleh bongchal vahmang jong nadon peh louding, hiche gancha chu ama heng'a nahin lekailut peh joh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Nangma doumah bolpa sangan in apot apohlal tah a aopkhum ma ahile hichu, na dalhah jeng louding, sangan akitho doh theina dinga na panhu teitei ding ahijoi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Vaicha thutanna a adinmun a konna achan ding dolla thudih chu na pampai peh louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Jouthu phot a kinilna le kihehtona chu na jamsan jeng ding, themmona beija mihem chu natha louding, ajeh chu keiman kahenai agiloupa chu them kachan sah him him louding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Nehguh chahguh jong nakilah thei louding, ajeh chu nehguh kiti hi vaihom a pangpan amit aselmang jin chule adih a pangte chu akhup athal'a alekhup jeng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Kholjin mi jong na suhgim louding, ajeh chu kholjin mihon ichanna lunggel anei uvem ti nahe tauve, amaho banga chu nanngho jong Egypt gam'a kholjin mi a nana um'u ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Kumgup sung'a phatah a na gamsung'a ann-ga natu ding, muchi gasoh na kilokhom ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Kum sagi alhin teng hiche kum sung'a chu na gamsung nakicholdo sah ding hichu nangma miten avaicha ho chun aneh diu, lou natong loubeh a na kichol damsah thei ding, ama hon aneh joulou aneh moh chengseu vang chu gamsa hon aneh diu ahitai. Hiche bang bang'a chu lengpi leilai le Olive chu nabol cheh cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Nigup sung'a hi natoh ding chan natoh ding, chule ni sagi lhinni vang le na sangan jeng jong na choldam sah ding, na bongchal ahin sangan jeng jong choldo thei ding, na sohnu chapa ahin najin ho jong kicholdo thei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Naheng uva ka seidoh hi nanit jingjeng diu, chule hichengse hi na kamsung uva jong na potdoh sah louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Kumkhat sung'a keima dinga kut thumvei chan nabol diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Chol solou changlhah kut, keiman phat kateppeh dungjuiya hi ding, Abib* lhasung hichu cholsolou changlhah nisagi sung sea naneh ding hiche lhasung hi Egypt gamsung'a konna na hungdohna lha ahiye. Hijeh achu khat cha jong keima angsung'a khutgoh keova hung sunglha thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Loulaija na lhosoh ga amasapen pen chu nangman lholhun Kut a dinga na katdoh jeng ding, hitobang ma a chu loulai pumpia na lhosoh ga nahin chop khom teng jong le kut nabol ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kum khat sung'a namite ho lah a pasal'a kai lhah kiti phot chu Pakai Pathen keima ansung'a thumvei hung kilah cheh diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Keima angsung'a kilhaina gancha kithat chu cholsosa changlhah jaona nahin totha thei louding, kaheng'a kilhaina sathao jeng jong khovah geija nakoi den louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Na leiset ga soh lah a gamasa pen pen chu Pakai na Pathen heng'a nahin pohlut masat pen ding, kelngoi sa kithat jeng jong chu api noitwi mangcha a nahon louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ven, na chena channa nangma na vengtup ding le na lhonpi jing dingin na masang lama vantil khat ka solpeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Vantil khu jabol inlang, athu na palkeh thei louding, ama doumah thei himhim nabol louding ahiye, ajeh chu aman na suhkhel chan u ngaidam intin, ajeh chu ama sung'a khu keima min um jeng'a ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Aman asei chan lunglut tah a na ngai jing ding, keiman kasei chan nabol'a ahile, na melmate dia melma a kapan ding, nadou te dinga adouva pang ding kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ka vantil chu na masang lama lamkai jing ding, Amor mite, Hit mite, Periz mite, Canaan mite, Hivi mite, chule Jebus mite jouse abonchauva nahin pui tengleh keima tah in abonchauva ka suhmang hel jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Chule mihem in asemthu milim doi pathen ho masang kitia na bohkhup louding, hiche ho dinga jong chu na kisahlal louhel ding, anatoh bang bang uva jong ima natoh thei louding aboncha na phuhlhuh ding, a songkhom tincheng jong na lekhup jeng ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Na bonchauva Pakai na Pathen nahou uva ama kin jeng nabol diu ahi. Na boncha uva Pakai na Pathen kin jenga na kisahlel diu, ama tah in na changlhah neh diu le na twidon ding jengu jong phatthei aboh ding, chuteng keiman na jalah uva konna phatthei nasatah kahin boh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nangma gamsunga chu koima aching kalval jong um thei louding, amavang nangma hinkho chu kasuh bukim sel joh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Na masang tinna mihem ten akichat thei chan kamasol peh ding, kidoupi dinga nahin tup chan lungsung kasuhmol peh jing ding, chuteng nangma nahin doute jam cheh diu nangma nunglam jeng'a bou khodah diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Na masang'a khoi-ngel te kalha masat peh ding, Hivi mite, Canaan mite, Hit mtie abonchauva khoingel ten adelmang hel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Na masang'a vang amaho chu kumkhat sung'a kadel cheh louding ahi, ajeh chu gamsung ahomkeova aum khah le gamsa hungpung lha jeng ding gamsa ten nangma nahin dou khah diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Nangma na hung punbe jing ding, chuteng amaho khu aloiloija kadel cheh ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Na gamgi chu twipisan a kipat Mediterranean twikhanglen chan hop a ka kaipeh ding, solam gammang lah a kipat Euphrates vadung channa kakai peh ding nahiye, ajeh chu hiche gamsung ana lo jouse keiman nangho khut a kapeh doh ding, amaho chu nangman jong nadel cheh jeng diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Amite jouse lah hihen asemthu u pathen hijongleh kitepna neocha jong nanei thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Amaho jouse khu khat jeng cha jong na gamsung'a cheng theilou diu ahi, ahinlah amaho pathen limsemthu ho kin nabol khah ngai ngaiya ahile vang, hichea chu nasatah a nangma nakipal lhuh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Pakaiyin Mose heng'a aseijin: “Pakai heng lama Aaron, Nadab, Abihu chule Israel upate mi somsagi toh hung kal touvun. Gamla thim'a konna chibai nahin boh diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Mose bouseh Pakai heng'a hung lut thei ding, adangse vang khat a khat cha jong Pakai heng nahin nailut theilou diu ahiye, hitia chu Mose le mipi aboncha hung kilhon lut thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Chuin Mose jong akumsuh tan Pakaiyin apeh chonna dan thu abonchan mipi ho heng'a aseipeh sohkeiyun ahi. Mipin jong awkhat in adonbut uvin asei uve, “Pakaiyin asei chan chu aboncha kabol diu ahi,” tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mose in jong Pakai thupeh chengse abonchan asundoh sohkeiye. Ajing jingkah matah in athou doh in molbul achun maicham bolna ding mun asemin ahi. Aman maicham phung chu Israel phung dungjuijin som le ni atungdoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Mose'n jong Israel te lah a gollhang phabep asol tan, ama hon abonchauvin Pakaiya din pumgo thilto le chamna thilto din bongchal atohdoh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mose'n jong thisan akehkhat pi chu athal in twibel ho sunga chun asunglut in ahi. Chule thisan kehkhat chu maicham maija achap khumin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Chuin Mose'n jong Kitepna Lekhabu chu ahin choiyin mipi angsung'a chun gingtah in asimdoh tan ahi. Mipi'n jong adonbut uvin, “Pakai thupeh chan aboncha kabol kimsohkei diu ahi. Ka jabol diu ahi,” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Chuin Mose'n jong thisan phasah khat alan mipi ho chu achap khum uvin, aseipeh tauve, “Veuvin, hiche thisan hin Pakai le nangho kah a thupeh ho chu anomdet ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Chuin Mose, Aaron, Nadab, Abihu le Israel upa som sagi ho mol'a akaltou tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Israel Pathen chu abonchauvin aga mutauve. Pathen kengphang noiya chun Sapphire song jeng keng lampi khat ana um in, athen dan jong van chungvum kihohsel'a theng bep bep in anaum in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Chule Pakaiyin Israel mite chung'a chun doumah abol tapon, Pathen loupina chu nasatah in amu tauvin ahile, kitepna anneh jong Ama umpina in aneuvin adon uve! ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Chuin Pakaiyin Mose heng'a aseipeh in, “Mol chunga khun keima heng'a hung kaldoh in. Chulaiya chun um in, chule Keiman mipi ho ding thupeh ho le gahchahna ho kasutdoh hi kapeh ding chutenteng mipi ho nahil thei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mose le alhacha Joshua chu apotdoh lhoinin, chule Pathen molsang chunga chun Mose akaltou tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Mose'n jong upaho heng'a seipeh uvin, “Keini naheng uva kahung kile kah lhona hiche mun a hin ana umun. Aaron le Hur in naumpi nauve. Ka chedoh kah a kibouna nanei uleh amani toh nakijahto diu ahiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mose jong molsang lama akaltou tan ahile meilhang in mol chu ahin tomlha jeng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Hichun Pakai loupina chu Sinai molsang chung'a ahung kingam jeng tan, chule nigup sungin meilhang in atom tai. Nisagi nin meibol sunga konin Pakaiyin Mose ahin kou vin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Mol bul langa um Israel te mitmun, molchung vumma Pakai loupina ahung kilah chu meikong bangin amu tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mose chu akalsang jep jep tan ahileh meibang lah a chun akimu tapoi. Ama nisomli le jan som li molsang lama chun ahung umden tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Pakaiyin Mose henga aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Israel chate jouse heng'a seipeh inlang, keima henglam'a thilto ding adon khom diu, amichang cheh keima dinga thiltoh nom chanin thil hin dongkhom cheh uhen. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Israel chate jousea konna nadon diu thil ho chu hicheng hi hi ding ahi: “Sana, dangka, chule sum eng hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","A eng-dup, asan dup, asan thim ho leh kelcha vun hose hi ding, ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","Chule akijut jolsa kelngoi chal vun, kelcha vun jaona thinggi thing hi ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Thaomei hoa manchah ding thaotwi jong, kinujolna ding thaotwi tah jaona hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Thempu in aki-O ding leh alengkou chunga akikhai ding song mantam chu hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Chujou teng Israel mite lailunga ka chenna ding muntheng tah khat na semdoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Houbuh le asunga thilkeo ding ho aboncha kavet sah ding hiche dungjuiya chu nabol diu ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Israel miten thinggi thinga thingkong khat asem diu hichu, adung inche 45, avai inch 27 le atun inch 27 a asem dingu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Thingkong chu asung le apo sana a natom jol ding, agei gol jong sana a natom jol ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Hiche thingkong'a manchah dinga chu sana chaokol li nalhah jun ding, chaokol ni chu thingkong pang langkhat a akeng teni chung'a na khai ding, khat teni machu alangkhat teni chung'a na khai lhah ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Nangman thinggi chu mol lhon ni tah nasui ding, hiche mol lhon teni chu anigella sana twiya natom jolsel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Hiche mol lhon teni chu kong putna a kimang thing ahin hichu apang lang khat a chaokol teni sung'a chu nathol lut cheh cheh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Mol lhon teni chu thingkong panga chaokol kikhai lha teni sung'a chu aputna dia kikhai den jing ding, hiche mol lhon teni chu koimacha gache a aga sutlhah louhel ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Hiche thingkong akichai tengleh asunga chu keiman kapeh ding hettohsahna chu na khumlut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Sana touna chu nalah ding hiche a chu ngailut hepi touna khat na semdoh ding, hichu adung inch 45 chule avai inch 27 hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Nangman jong sana cherub ni nasem ding hichu ngailut hepi touna among lang tenia na khetbeh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Amang lang khat a ding chu cherub khat nasem teitei ding, ngailut hepi touna among lama dinga na boncha uva cherub nasem cheh cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Cherub lha teni chun ani gel'a achunglam angat lhon ding, alha teni chun ani gel'a ngailut hepi touna chu alekhu teitei lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Hiche mun na chu keiman nang kahin kimupi ding, ngailut hepi touna le hettohsahna thingkong chung'a um cherub teni kikah a chu keiman Israel chate dinga thil manlutah kasei ding hichu keiman thupeh a kapeh ding nahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Thinggi thing na manchah ding hichu dokhang khat nasem ding, adung inch 36, avai inch 18, chule atun inch 27 hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Hiche dokhang chu sana thengsella phatah a natom khum ding, apam jouse aboncha sana keoseh a natom ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Dokhang kimvel'a chu inch 3 a nakaikol ding, hiche akimvel'a kivei kol jong chu sana a kijem lha ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Dokhang'a manchah ding sana chaokol li nasem ding, hiche chaokol li chu dokhang keng ningli hosea chu naba peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Dokhang kol kimvel chule chaokol hose chu kimat sohkei ding, dokhang chu akijon tengleh hiche chaokol ho a chu thingjol thillut ding chuteng kipu ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Thinggi thing phatah a moljol phasahpi khat nasui nam ding hichengse chu sana a natom jol ding, moljol hosese chu dokhang jonlena a kimang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Dolhang adia kong hoitah tah sana a kisem ___ lheng ho, khelhei ho, kongtong ho chule twithei ho___atwi thilto a sunlutna dia nasem ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Hiche bang bang'a chu nangman jong keima kaum jing nai ti photchetna dinga dokhang chung'a keima changlhah nakoi jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Sana keu seh a kisem thaomei khom khat nasem ding, thaomei tunna dinga akhom chu sehcha a na khetbeh ding, akhon hose le alulangse chule pahcha a kijem chengse aboncha thakhat chet a kigom khom ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Thaomei phung ajet le avei apat abah gup hung um doh ding, thaomei pang lang khat a abah thum hung um doh ding chule langkhat ma a chu abah thum hung kisep doh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Abah gup ho chu alangtogel’a thaomei khon thum cheh um ding, hichu jonmot pahlhasel’a amum le ana um tobang hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Thaomei khom jong chu jonmot bang bang'a kisem khon li hiding hichu jonmot pahlhasel’a amum le ana um tobang hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Thaomei phung'a kon abah gup chengse dangnoiya chu jonmot mum um ding abah ho chu aphunga konna hung jamdoh cheh diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Jonmot mum le abah chu alaiya jol toh thakhat a um ding, hichu apumpia sana thengsel'a konna sehcha a kikheng hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Hichea det kong dinga thaomei sagi nasem ding, amalam salvah dia hiche thaomei sagi ho chu tundoh cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ameikong attanna ding choiche ahin adopna kong tong aboncha sana theng'a kisem jol cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Hiche thaomei khom le angaicha danga manchah dinga chu sana theng pound 75 ngai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Hiche ho jouse hi aboncha molchunga alim umdan kavetsah bang banga nasem doh tei tei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Nangman nasah ding houbuh chu tupet Pondal som khat a nasah ding pon'a kikhong hi ding ahi. pondum chule pon pol them naman khom ding, pondal chengse chu Cherub ho lim hoitah a kisem bang'a nakhai cheh cheh ding'u ahiye. Hichengsea chu houbuh nasah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Pondal som ho chu adung tong som ni le tong get a len le sao hi ding, pondal khat cheh vang chu tong li cheh hi ding, pondal kiti phot aboncha adung avai alet le aneo dan kibang cheh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Pondal nga chengse vang chu kigom sohkeiding chule alang khat a pondal nga jong chu kigom sohkei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Pondal masa chengse chu aninggol hoa akol kol'a tampi patdum'a nasem ding, hichebang bang'a chu pondal gol niloilah a apam nung pen pondal gol lah a chu abil nasut hom ding akol kola tampi nasem doh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Pondal kimkhat chu abil navu hom pehding akol kol somnga nasem peh ding, chule pondal kolni lhinna gollah ajong abil navu ding akoljong somnga jen nasem peh ding ahi. Akol navu hom chengse chu amacheh lhing'a toding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Sana kol somnga nasem ding, hiche sana sumkol ho achu pondal chengse chu na kaimat cheh cheh ding, chuteng houbuh thil hojouse kigom khomma houbuh khat a nasah doh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Houbuh chung khuna ding nangman kelcha mul'a kikhong pon phabep naman chah ding, agoma dinga pondal somle khat nasem ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Pondal khat a tongsom'a sao hi ding chule avai tong li cheh hi ding, hiche pondal som le khat se chu aboncha alet le aneo dan kibang chet ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Pondal ngaho vang chu nakil mat sohkei ding, adang pondal gup jong na kilmat sohkeiya, agup channa pondal vang chu ponbuh maiya chu na khu ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","“Chule pondal golmasa pen chu apam chin lah a akol somnga jen nasem ding, pondal golni channa jong chu aning gol hoa akol somnga mama navu hom ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Nangman sum eng somnga jen na sem ding, sumkol hose chu aboncha pondal kol navu hom hoa chu nathil lut ding, ajeh chu ponbuh chu khat seh a akitun doh na dinga na kaimat sohkei ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Chule ponbuh'a pondal amoh chengse chu, houbuh ponbuh nunglama chu nakailhah sah cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ponbuh kisahna'a amoh chengse ho chu alang khat a hihen khat lang a hijongleh, houbuh lang to gella dinga tongkhat cheh kikhai lhasuh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","“Hiche ponbuh khu nadinga chu nangman jong kelgnoi chal vun le kelcha vun nemlai jeng naman chah ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Houbuh'a manchah thil ho chu nanagman thinggi thing jol namsella nasem cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kol khat a naman chah ding chu tongsom hi ding, akol khat ding chu avai tongkhat a sao le tong keh hi ding ahi. Akol khatna tongsom hi ding, chule akol khat ding chu avai tong khat le tong keh hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Hiche thing kol khat cheh chu among lang'a abil navu hom peh cheh ding, houbuh thing kol jouse chu aboncha abil nahoi peh cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Houbuh dinga thing kol nasem peh ding chule lhang lamma dingse chu aboncha thing kol som cheh hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Thing kol khat cheh le among lang suhmat nadinga chu, thingkol som in chung'a pansa dinga abil hom somin nadinga a dangka a kisem abiltom somli nasem ding, thingkol khat among lang'a chu asuh mat nathei ding abil tom ni cheh nasem peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","A golni channa houbuh chung lamkaiya pang ding chu thingkol som nia nasem ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Dangka'a kitomjol abil somli hi ding, thing kol khat mong lang'a pang ding chu abil tomni hi ding chule thingkol lang khat a pansa ding jong chu abil tomni mama hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Lhumlam nga a houbuh nunglama pang ding chu thing kol gup nasem peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Chule houbuh nunglama'a pang dia abiltomma dinga ni mama na sem peh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Hiche thing kol teni chu anoi lam douva pang lhon ding, chule a lulam'a vang chu chaokol masapen chutoh adang ho kaimat na a pang ding ahi. Hiche teni chu aning koltenia pang ding mong mong ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Dangka a kisem abil tom hojouse chu a gomma thingkol get hi ding, abil tom aboncha somle get lhing ding ahi; thingkol khat a pang ding chu abikol tom hi ding, anoija pang ding ma chu abiltom ni mama hi ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Houbuh lang khatna thingkol chengsea vang chu thinggi'a kisui nam kotgol nga nasem ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Hichu houbuh lang khat a thingkol hose avaiya pang dinga nga nasem ding, chule houbuh nunglama lhum lama pansa dinga agol'a jam dinga ngama nasui ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Chule thing kol chengse chu akimlaija pang dinga alailha pen chu among langto gella dinga pang ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Hiche thingkol chengse chu aboncha sana a natomjol selding chaokol hojouse jong chu aboncha sana ‘a natom jol ding, agola kijam jouse jong chu sana mama'a natom jol cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Molsang chung'a houbuh na kimu sah bang bang'a na tundoh teitei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Chuteng houbuh chu pondum, ponsandup chule ponsan pol thim naman chah ding ponbuh chu nakhu ding, tupat ponnem ma ki khong naman chah tei teija; hiche pon ho chu aboncha khut a kikhong cheh cheh hi ding, cherub lim bang'a kikhong ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Chule aponchu sana akitom jol hi ding thinggi thing'a kisui khom li chung'a hi ding, abilkol a kol li ho achu na khai lhah cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Alukhuh asumkol ho chu na khai lhah cheh cheh ding, hettohsahna thingkong jong chu pon lukhuh noija chu nahin koi ding ahiye; hichu pon lukhuna akonna chu mungtheng chungnung nga konna chu muntheng laichu na sem khen diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Chuteng het-tohsah na thing kong muntheng laiya chu hepi touna khat na do ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Pon lukhuna polama achu dokhang khat nasem ding houbuh lhang lama dokhang toh kinga to lhon ding akimlai tah achu thao Meivah natun ding ahi; hiche dokhang chu sahlam sang a nadoh doh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ponbuh kot maiya ding chu pon dum leh pon sendup chule ponsan pol thim. Tupat pon nemma heojang pahcha jem kijepna hoa bou nasem peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Pondah na dinga thinggi khom nga nasui ding, hichengse chu aboncha sana a natom jolsel ding, akikhai lhah nading thihkol chengse jong sana twiya kisem jeng hi ding, abil tom nga jong chu sum eng jenga nasem cheh cheh ding ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Chule maicham dinga thinggi thing naman chah ding, maicham chu bempel'a kisem hi ding, hichu tong nga a sao hi ding, maicham chu abem pilla kisem hi ding, asan lam vang chu tong thumma kisem ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Maicham gol'a pang dinga aki li na sem ding, aki sese chu maicham toh kigom khom cheh ding, hiche akichengse chu sana a natom jolsel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Vutvam ho lo doh nadinga bel phabep khat na sem ding, khe keh jong phabep khat nasui ding, twibel jong chule sumkhe jong nasem ding khangbel phabep khat jong nasem ding, manchah thilkeu jouse chu aboncha sum eng jeng a kisem hicheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Maicham'a pansa ding chu kipheh chah kheh khat nasem ding, hichu len pheh'a kipheh chah kheh bang a na sem ma achunga chu sum eng koli jen na koi ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Hichu maicham thinggi jol noija chu na koi ding, hitia chu lenpheh'a kipeh chah kheh chu akimlai tah a hung kijung lhah ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Maicham putna dinga moljol ni nasem ding hichu thinggi jeng na sem ding aboncha sana a na tom jolsel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Hichu thingpel tobang'a nasem ding, alai nahom sah ding, molsang lama na kimusah bang a aboncha nabol sohkei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Houbuh munlaise chu pal naget khum cheh cheh ding, lhang lama pang ding pondal kikhai lha chengse chu tupat pon nemma kikhong hi ding hichu pondal tong jakhat a sao naman chah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Akikhai lhah na ding khom jong agomma somni hi ding, aboncha keija sum eng jeng'a kisem hi ding ahiye. Akhompi'a pang ding le aning lah a chengse vang chu aboncha dangka a kisem cheh cheh hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Pal kigen sah lamse'a chu pondal na khai lhung kei ding, aboncha sum eng jeng jakhat a kikhai lha'a nasem ding, akhom ning dung'a pang thih koi chengse le alutom ho jouse aboncha dangka a na sem peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Nilhum lama pang pal kigen avaiya um chengse chu somnga jeng na khailhah ding, khompi som khat se chu atunlut nadinga somkhat cheh kisem ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Nisom lama pal kigen maiya chu avai lang pang tong somnga nasem ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Kelkot'a pat alang khat sese a pondal vangchu tong som le tong nga a sao ding, atun nading khom phung thum toh khomko thum hitha teitei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Alang khat a pang ding pondal jonchu tong som le tong nga hi ding, akhom pi phung thum jaona atunna ding thum toh hitha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Kelkot'a pang ding pondal chu tong somni jen hi ding, pon sen-ao thim leh pondup chule ponsandup thim hichu tupet pon nemma ki khong hi ding, hichu phatah a na jep pol cheh cheh diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Pal kiget'na a pang khom jouse chu aboncha dangka jeng'a na jep ding, khom phung chengse vang chu sum eng'a kijem hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Pal kigen chu tong jakhat lhing ding, a vailam chu tong somnga jen hi ding, asan lam vang chu tong nga hi ding ahiye; hichengse chu aboncha tupat pon nemma ki khong jeng kikhai lha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Hiche thil manchah jouse chu aboncha keiya, thil khaina jouse hihen lang, pal geiya ki khailha ding jouse hi jong le abon chakeija sum-eng jeng'a kisem naman chah diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Nangman Israel chate ho thu na peh ding, ama hon Olive'a ki ladoh thaomei thengsel chu ahin choi uva; a Ima tih channa kivah vah jeng ding a thaomei chu ahin tundoh diuva ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Kikhopna ponbuh sung ahin, chule het-tohsahna ponbuh mailam ma Aaron le achapaten hiche thaomei chu nilhah lama pat jingkah khovah chan geiya, Pakai angsung a akisah lal peh diu ahi.” Hichengse hi aboncha Israel chate ding a akhang akhang lhung keiyuva anit jing diu le chonna dan a aneiying diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Israel chate lah a kon'in chien lang nasopipa Aaron le a chapate chengse khu ka heng a hinpui in; amaho chengse khu keima thempu a pang ding ahiuve, Aaron le Aaron chapate, Nadab le Abihu chule Eleazar le Ethamar, hi chengse chu hi diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Na sopipa Aaron dinga khu nangman aloupi na ding le amel-hoi nadinga akivon nading nagon peh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Keiman nangma lungthim ahin chule tha ka peh chengse aboncha thilbol theina jousea chu thu nasei doh ding, chuteng ama hon Aaron kivon na dinga von tamtah akhon diu, ama chu keima themo pua pang ding a thensona um ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Akivon na dinga akhon peh diuva pon chu hicheng hi ahiye: Ompho a ding khat, kongah na ding khat, sangkhol chol khat, thempu natoh na ding a sangkhol achol khat le aponung a ding khatma, delkop'a ding khat, taigah na ding khat jaona hichu keima ding mong mong'a thempua pang ding na sopipa Aaron le a chapate din von theng chu kimsel la agon peh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Sana jong, pondum chule ponsandup jaona pon san pol thim hichu tupat ponnem ma kikhong chu amanchah diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Konggah'a pang dia sana, patdum, ponsandup, patsan polthim khut tem na nei tah a kikhong hichu tupet ponemma asem peh cheh cheh ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Hichu aki jotmat na dinga among lam teni alengkouva hung kikhai lhathei jong asem peh ding'u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Khut themna neitah a kikhon pet chu ahin, kong'a kigah ding jong, konggah'a kigah dinga kisem ki mang cha jat chengse chu akisem bang bang'a khut soh tah mong'a kisem hi ding, sana jaona, pat dum, patsan dup chule pansan pol thim, hichengse chu aboncha tupat ponnem ma kikhong cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Nangman song mantam ni na lah ding, Hiche songman tam ni chung a chu Israel chate ama ama min cheh nakhet lut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Song mantam khat penna chu amin'u gup nakhet beh ding chule, amoh chengse hoding achu gupma ma khat joh a chu nakhet peh diu ahi, hichea chu amin jouse ama ama cheh pen dungjuiya nakhet peh cheh cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Sana kheng them pan khut jem hoa thil hoitah a akhet them bang'a nangman jong songman tam chung'a chu Israel chate min jouse na khet pol peh sohkei uva, na khet polna chan chu aboncha sana twiya nasun jol cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Hichu song mantam teni chu Israel chate dinga het jingna dinga kong gah teni among geiya agen tenia chu na suh beh den ding; Aaron injong Israel chate het jing na dinga amin jouse'u alengkou chung vumma apoh'a Pakai heng'a apoh lut peh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Sana khut thempa akonna jong nasem ding sana thengsel'a kisem sana jang ni jong khaokol veija kivei bang'a na sem ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Hiche khao veija kivei sana chu na jopmat cheh cheh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Nangman thutanna munna akivkonna ding ompho jong chu khut them tah a nasem peh teitei ding, konggah kisem na bang bang'a nasem ding ahi; sana jong, patdum, patsan dup, patsan polthim chule hiche jong chu tupat pon nemma ki sem'a na sem peh cheh cheh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Nangman ompho khat nasem ding hichu, aning li chule hichu thoni hi ding adung khapkhat chule avai jong khap khat ma hi ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","A kimlaija gol lia song na gol ding chule amasa'a na gol ding chengse chu Sardis song hi ding; Topaz song aiha song jong hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Gol nina a pang ding ho chu ahile, Emerald Song, sapphire song chule diamond song hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Gol thum lhinna pang ding ho chu ahile; Jacinth song, Agate song chule Amethyst songhi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Golli channa ding chu ahileh, Beryl song, Onyx song, Jesper songhi cheng chu ahiye; aboncha sana twija chap nou ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Song som leni chu ama ama mincheh dungjuiya Israel te khat khat cheh toh umtha ding; hiche bang bang achu Israel phung som le ni ho chu songkhat cheh chu toh Mohor kinam den tha ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Nangman jong omphoa man chah dingin sana thengsel khao jang bang'a kiheh'a na sem ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Ompho'a manchah dinga sana kaokol nijong nasem ding, hiche chaojong teni chu ompho ning'a bupeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Hiche chaojang kol teni sung'a chu sana khaojang chu nathillut ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Hiche chaokol teni among lam akolsung'a patjang nathil lut ding; konggah teni masang lama chu um ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Sana chaokol ni nasem ding; hiche chaokol ompho agei tenia chule hiche teni chu ompho sung lama kon ageichanna konggah bantah a nathil lut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Hitia chu sana chaokol nijong nasem tha ding, hiche chaokol teni konggah lengkouva ki khailhahna noilang chule amasang lama na suhmat peh ding; kong gah ding a kisem hoitah chunga chu kikhai mat ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ama hon patdum a manchah diu hichu omphoa chaokol sung tenia chu athil doh paijel ding u ahiye; hiche konggah a chaokol teni toh chun athil mat ding u, khut them na tah a kisem konngah chu toh asuh mat chat diu, ompho le konggah chu kikhen louva um jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Hichu Aaron injong Pakai angsunga alut teng, Israel chate asuh mil louva, thutanna'a kivkonna ompho achu Israel chate mincheng apoh jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Hiche thutanna ompho chung achu Urim le Thummin chu adal na naman chah ding, Pakai angsunga na lut teng hiche teni chu Aaron chunga kikhai den ding, Aaron in jong hichu Israel chate thutanna Pakai angsunga alut teng apoh ji ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Thempu hon konggah a manchah cheng chu pondum jeng a nakhon peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Hiche sangkhol chol a chu luchang hetlut nading ahomkhat na sem ding ahi. Hiche sangkhol chol achu luchang hetlut na ding ahom khat anei ding; Sangkhol dang bang'a angaija a ngong kol kimvelse chu pha tah a ki pheh chah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Sangkhol gei jouse aboncha ajem asan le adup a hi ding, asan-ao thim hichu kolbu theiga bang bang a nasem ding; kolbu thei lim a kisem chengse chu aboncha sana jeng a nasem a agei mong se a naum sah ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Sana chao khat naba na munna chu kolbuthei lima kisem khat cheh um ding, sangkhol chol gei lhung keija sana chao chu na ba peh ding hichu kolbu thei ga limma kisem khat cheh hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron in Hou-In sunga kin anei teng hiche sangkhol chol chu akiah ding, Pakai ansunga alut pat hihen ahung potdoh hijongleh hiche chao jang chu agin kija jeng ding, hichu akijah khah louva ahile athi a hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Sana theng set'a apheng khat na sem ding, Achung'a chu Mohor kijem bang'a Pakaiyin athenso ahitai tia ajem khat nakhet dinga ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Sana pheng chu pat jang adum khat a delkop'a na kan chah peh ding, adelkop chu amai lam ama sang lang'a aki tah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Sana pheng chu Aaron chal pang'a kitah jing ding, Aaron in jong Israel chaten thil theng ato ding chengse'u a thensoa chule themmona hung lut kha photphot chu hichu ama cheh in mona atahsa chung a akipoh ding, Pakai angsung'a santhei dol ahi na dinga Aaron in jong achalpanga kitah jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Hiche sangkhol chol chu tupet pom nemma na khon peh ding, delkop jing jong tupet ponnem ma na khon peh ding konggah jeng jong heu jang khatna khut themmna neitah mikhat in apheh peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Chuteng nangman Aaron chapate jouse chu aloupi na diu le a vethoina diuva sangkhol ahin, konggah ahin, lukhuh ho jong na gonpeh cheh cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Hiche von hose chu na sopipa Aaron ahin chule a chapate chengse na von peh ding, thempua pang diu keima kin'a akisah lal na diuva thao na nu sohkei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Nangman jong amaho se chu atahsa gohkeovu a kidal na diuva sangkhol chol na choh peh cheh cheh ding u ahiye; hiche sangkhol chol sese chun akong uva pat akhu jal channu akhu khum cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aaron le achapate ho chu kikhop khomna ponsunga ahunglut'u hihen, muntheng munna kinbol maicham phung ahin nailut pet'u hijongleh hiche delchol chengse chu a ki-ah sohkei diu ahi; achuti louva ahile amaho le amaho themmo akipoh lut uva hicheng toh chun thina ato tha khah diu ahi. Hiche dan chengse hi Aaron le ama nung a ason a chilhhahte ding geija chonna dan hi jing ding ahitai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Nangman keima thempua pang dia hite ho hi na thenso tengleh hicheng hi nabol peh cheh cheh ding ahi. Bongchal khat le kelngoi chal khat nahin mat ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Chuteng cholsolou changlhah lhon phabep jao na hi ding, hicheng chu thao toh kihelsa jeng hi ding ahi. Chule cholsolou changlhah neldisel thao thoh kihel tha hi ding hiche ho chu aboncha suhlou changbong akon na lah doh cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Hiche hojouse chu aboncha pucha khat a nakhum lut cheh cheh ding, apucha puma chu nahin todoh ding chuteng bongchal golpai le kelngoi chal na hin kai lut tha pai pai ding ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Chule nangman Aaron le achapa te chengse abonchauva kotpi phung maiya na hin puilut sohkei uva, abonchauva twiya nasil ngim sohkei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Chuteng nagman ponsil ho chu na gah lah ding, Aaron chu sangkhol chol a kisem chule konggah chu navon peh ding; hitia chu konggah chu nagah peh ding, ompho jong navon peh ding, konggah ding a khut themna tah a kipheh chu nagah peh ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Aluchang'a delkop na kop peh ding, hiche delkop chunga chu lukhuh theng na khuh peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Chuteng tahsa chunga nuding thao chu na lah a Aaron chu nanu khum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Chule hichu nabol chai tengleh a chapate ho chu na hin puilut pai dng abonchauva sangkhol chol chu na ah peh sohkei diuva ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Amaho chengse jong chu konggah nagah peh cheh cheh ding, hichu thempu hina beitih nei louva ama hon achonna dan a ahin cheh pe jing ding ahiuvin. Nangman Aaron le a chapate chu thempua pang ding na suh det ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Chuteng nangman kikhop na in maiya chu bong chal nahin kailut pai ding, hiche bongchal luchung nga chu Aaron le achapate chengin akhut angap lhah cheh diu ah. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Hiche bongchal chu Pakai angusng a natha ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Chule bongchal thisan chu na khut jung na dekot ding hichu selki hoa chu naloi nat cheh ding ahiye, gan thisan amoh chengse vang chu maicham maiya chu nasun lhah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Bongchal sathao jouse ahin, chule athin, akel tenia athao jouse jong nalha doh ding hichengse chu aboncha maicham chung a na go vam hel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Hiche bongchalsa chu avun ahin chule a eh chengse chu pam lam ma meiya na go vam mang ding ahi; ajeh chu chonset kithoina ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Chujou teng nangman kelngoi achal sang nei khat na hin kailut paipai ding, Chuteng Aaron le achapate ho jousen hiche kelngoi achal luchung'a chu akhut angap lhah cheh ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Chuteng nangman kelngoi chal chu natha ding, athisan phabep khat na lah ding maicham maiya akimvel lah achu nathe khum sohkei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Kelngoi chal sa chu na sem ding, asung jouse jaona akeng jeng jong nasop ngim soh ding chule hitia chu asa na sem sa chengse leh a luchang jaona hichengse chu ki tupchet a na koi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Hiche kelngoi chal sa chu aboncha maicham ma na go vam hel ding ahiye. Hichu Pakaiya dia pumgo thilto ahin, chule agimnamtui sel hichu lung lhaisah nading ahin, Pakaiya dia meiya govam hel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Hichu aki chai chai le kelngoi chal khat ma na kai lut kit ding Aaron le achapa ten jong kelngoi chal chunga chu akhut angap lhah cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Chuteng kelngoi chal chu na tha ding, Athisan phabep na lah doh ding, Aaron bilkol jet lama nanu nat peh ding, chule akhut jetlamma akhutpi chense jaona akeng jetlamma khutpi chung jousea jong nanu nat peh cheh cheh ding ahi; chuteng athisan moh chengse chu maicham maiya nathe khum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Maicham chung a thisan phabep le thao kinu thei chu na lah ding Aaron ponsil cheng chung a chu na sun khum ding ahi; hitia chu Aaron le aponsil chengse kithenso a atheng a um ding, ama ahin chule a chapate jeng jong ki thenso na chang ding atheng a um jing ding ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Nangman jong kelngoi chal sa thao chengse ahin, chule amei thao ahin asung thao le amei thao ho ahin amel jetlam toh nalah tha ding ahiye; hichu ki suhdet na dinga kelngoi chal ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Changlhah phengkhat ahin thao toh kihelsa changlhah khat na lah ding, changlhah pheng khatma toh nalah tha ding, hichu Pakai angsunga cholsolou changlhah pucha sung a umho a konna chu na lah doh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Hichengse chu Aaron le achapate khutna na peh doh ding, aboncha chu Pakai angsunga thilpeh ding a na koi jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Chuteng Aaron ahin chule achapate ho a konna na lelah doh kit ding, Pakai angsung maicham chunga chu na le halvam cheh cheh ding ajeh chu Pakai adia govam thilpeh khat a ki sim ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Chule Aaron ki suhdet na kelngoi chal op-phang chu na lah ding, hichu Pakai angsunga thilto dinga na todoh ding, hichu nangma na chan vou a paimang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Hiche thilto chu thempu ho chan ding chule amal toh chule ki suhdet na ding a kitoh doh ding chengse jaona Aaron le achapate chan ding ahijeh a then sona na sem peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Hichengse chu Aaron le a chapate jouse ding a akhang akhanga Israel chaten apeh cheh ding uva bat a anei cheh diu ahi, ajeh chu Israel cha ten chamna thil ahin to doh ding u hichu Aaron le achapate chan ding ahi. hichu Amaho jouse dia Pakaiya thil to ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aaron kivkonna ponsil chengse chu ama khang akichai teng achapate chan vou ding ahin, thao akinu uva hichu ki suhdetna a anei jing ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Aaron umna munna achapa thempua pang ding pen pen chun kikhopna ponbuh sunga ahung sung lhah ding teng; ni sagi sungsea hiche vontheng chu aki von jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Nangman jong kelngoichal ki suhdeh na chu na hin puiya, asa chu muntheng lai khat a naga hon min ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Chuteng Aaron le achapaten kelngoi chalsa le pucha sung a kikoi changlhah chengse chu aneh khom diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Hichengse chu kisem hoina ding le kisem toh na pang ding, ajeh chu hiche thil jouse chu aboncha atheng sa ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Chujongleh ki suhdet na sa moh ham changlhah moh ham khat jingkah khovah geiya aum khah a ahile; nangman hiche ho chu meiya na govam cheh ding ahiye, hichu koiman anehthei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Keiman nangma ka thupeh bang bang a hi Aaron le achapa ten abolna diuva na hil chah sohkei diu ahi, nisagi sungse amaho chu na suhdet ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Aniseh le ki suhdihna dinga chonset thilto a pang dia bongchal khat na katdoh jing ding, hichu nabol teng nangman maicham sunga konna chonset suhmang theina dinga, maicham chu thao nanu cheh cheh ding, thensona na nei ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ni sagi sungsea nangman ki suhdetna maicham nasem jing ding, hichu maicham lah a atheng chungnung penna kisim ding ahin; ipi hi jong le hiche maicham sukha phot phot chu atheng aum jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Maicham chunga na thilto ding chu hicheng hi jing ding ahiye: Anisih a tang louhel ding a kumkhat lhingsa kelngoi chal ni na katdoh jing ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kelngoinou chu jingkah simma na katdoh jing ding chule kelngoinou dang khat chu nilhah lang a na katdoh ji ji ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Kelngoinou kikatdoh masa pa chu ahin changbong nel hopkhat a kitena hopsom jaona akiheh lhasa thaotwi khon dimkhat hopli a kihom hopkhat jaona, kilhaina ding a khon dimkhat hoplia kihom khat jaona hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Jingkah lama natoh bang bang chu nilhah lamma jong kelngoi chal khat na todoh ding ahin; kelgnoi chal aki toh doh jaona chule chang thil ki todoh chu ahin, don ding a thilto jong na jaosah ding; Hichu Pakaiya dia gim namtui tah pumgo thilto a ki mang cha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Hi chengse hi na khang khang uva pumgo thilto a naman jing ding u ahi. hichu kikhop khomna ponbuh maiya nabol jing diu ahin, chuteng keiman nangma hiche kotpi phung maiya chu najah a thu ka sei peh ding nahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Hiche mun laitah achu keiman jong Israel chate ka kimu pi ding, keima loupi nan amun chu asuh theng jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Keiman jong ki khopkhomna ponbuh leh maicham ka suhtheng ding, Aaron leh a chapate ahin thempu a pang dia ka suhtheng ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Hichutengleh Israel chate lah a kachen ding, amaho dinga keima hi a Pathen u ka hi jing ding ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Chuteng keima hi amaho jouse Pakai le Pathen ka hi jing ding, alah uva ka chen jing na ding a amaho hi keiman Egypt gam'a konna ka hin pui galkai uva ahi; ti ahin hetdoh diu ahi, ajeh chu keima hi Pakai dihtah amaho hin puidoh pa chu ka hi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Nang man gim-namtui kihalnam jing a maicham na sem ding ahiye, hiche maicham chu thinggi thing a na sem ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Maicham chu adung tongkhat asao ding chule avai jong tongkhat a sao hi ding, a ning li um ding; a tunjong tongni a sao ding, hiche a kimang saki ho jong chu maicham toh thakhat a um tha cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Maicham chung lang chule ajet le avei a kimvel sese ahin saki ho jaonan, aboncha sana thengsel'a na tom jol ding, a kimvel jouse chu sana a na jep pahthet ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Hiche maicham a manchah dia chu sana chaokol nijen nalhah ding, hiche chaokol teni chu maicham alang alang a sana ki jeppah na noiya abil na sem ma na ba peh chehcheh ding ahiye. Hiche chaokol teni sung a chu moljol ki thillut ding chuteng maicham chu kiputna ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Hiche maicham putna dinga moljol teni jeng jong chu thinggi thing na suipeh ding, ania chu sana a na jep pah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Chule hiche hettoh-sahna thing-kong maicham ki khaina pondal maija chu, hettoh-sahna hepi laltouna mai lai tah hichu keiman nangma toh ka kimuto na ding a ka lhen dohna munna chu maicham na sem ding ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Aaron in jong jingkah sim le hiche maicham kilhutna ho chu asuh theng jing ding chule hiche munna chu gimnatwi ahal nam jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Hiche bang achu nilhah lam jong le Aaron in gim namtui chu ahal nam jing ding, na khang lhum kei uva Pakaiya dia hiche gimnam tui chu na halnam jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Hiche maicham chunga chu atheng lou ahin, chule gimnamtui hihen pumgo thil to hijongleh na tothei lou diu ahi; don thei thilto jeng jong na sun khum louhel diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Kum khat sungse'a Aaron in jong sakiho chunga chu suhdetna abol ding, chule hiche na dinga chu suhdet na chonset thilpeh gan thisan amanchah ding ahiye; na khang lhum kei uva kumseh le khat vei cheh nabol diu, hichu Pakaiya dia thil theng chungnung penna pang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Pakaiyin Mose henga thu aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Nangman Israel cha te na simma amin bu u na sem peh tengleh, ama mimal cheh in along lhen diu akipoh cheh cheh diu ahi. Hitia chu nabol a amin u nasim teng achung uva natna hoisi hung lang louding ahitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Amin hungkisim ding jousen muntheng chunga chu longlhen man chah dinga shekel keh khat cheh ahin kipoh uva akoi diu ahi. hiche shekel khat chu Gerah dim khat toh'a kibangin, sekel keh khatma chu Pakaiya dia kikat duha ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Hiche min sim na pang kum somni'a lhah chunglam sen, Pakai heng'a thilpeh ding chengse chu apeh doh cheh diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Na boncha uvin Pakai ya dia thilpeh na peh tengu leh ahao avai khentum na beihel la shekel keh khat cheh na peh ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Israel chaten ki suhdetna dinga athilpeh chengse'u chu aboncha na lah khom ding, hiche a sum ho chengse chu kikhomna ponbuh thil le loa na man chah ding ahi. Hichea konna chu Israel chaten a natoh na uva konna Pathen'in ahet jing ding u, hichu amaho Jouse longlhenna dinga kibol jing ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Pakaiyin Mose henga aseijin. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Kisilna dinga sum eng kong khat na sem ding, atunna ding jong sum eng a na sem peh ding ahi. Hiche sum eng kong chu kikhop-khomna ponbuh le maicham kikah a na tun ding asung'a chu twi na sun dim ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Hiche twiya chu Aaron le achapate jousen a khut ule akeng chengse'u a kisil ngim diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Aaron leh achapate houbuh sunga aluh ding teng ule, maicham a kin bolna dinga ahung nailut teng'u hi jong le, Pakaiya ding a thilto ding a hung u ham halnam ding thil a ahung u hijongleh, abonchauva twiya chu kisil ngim sohkei ding u ahiye. Achuti louva ahile thina chang jeng ding ahiuve, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Ama hon akeng phang jouse'u le akhut jouseu akisil ngim chehcheh diu ahi, Ajeh chu hitia chu abollou uva ahile thina chang ding ahiuvin; a chate jouse'u ding hihen Aaron a ding hijongleh ason achilhah jouseu va ding hi jong le hiche hi a khang a khang lhumkei uva chonna dan a ache pe jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Pakaiyin Mose henga thu aseijin. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Nangman gimnamtui lah a anam tuipen na kilah ding, gimnam tui atwi lah Myrrh chu shekel ja-nga man nalah ding agim nam tui lah a ahoipen thingnam tuichu kehkhat nalah ding, hichu shekel jani le somnga alhing in, thingnam tui lah a jong anamtuipen shekel jani le somnga mama nalah ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","Lingnamtui ga jing jong chu shekel kisim dungjuiya janga ma hi ding, chule Olive thao jong khon dimkhat ma na lah ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","“Hi chengse'a konna chu thao namtui sem them hon abolngai bang bang a, kinu thei dinga thao namtui nasem ding, hiche thao chu aboncha thao theng a kimang jing ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Hiche thao chu kikhopna ponbuh a na nunam ding hettohsahna thingkong a jong chu na nunam ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","Dokhang ahin, thilman chah ahin, thaomei khom ahin chule aman chah ho jouse jaonan, gim- namtui halna maicham jong aboncha nanu sohkei ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","Hichu pumgo thilto le maicham thilto ahin, chule twikong ahin a kitunna jeng jong chu nanu sohkei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Thil hichengse chu aboncha atheng ahi jing na dinga na thenso ding, ipi hi jong le hiche thil tongkha chan chu atheng a um jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Keima thempua pang dinga Aaron le achapate jouse chu na thenso ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Chuteng Nangman Israel chate henga na seipeh ding, hiche thao hi keima kinu ding a kasem ahin chule hichu akhang akhang a nakoi jing diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Hiche thao theng chu moh mi chunga kinu khum thei louhel ding, hiche thao theng kihal khom bang chu thao dang toh na hel tha louhel ding, hiche hi thao theng mong mong ahin, nangho jouse dia athenga um jing ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Koi hileh hiche thao theng chu adang ho bang'a kihel chop ma aum ngai ngaija chule khol jin mi ham hetlou mikhat chung'a nanu nat ngai ngai uva ahile ama chu amite lah akon a ki delmang jeng ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Pakaiyin Mose henga aseiyin, Thilnamtuiho chu kilah inlang, Stacte, le Onycha, Chule Galbunum, thilnam tui ho jaonan Bego thengsel'a kihel ho chu kilah tan ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Thao namtui sem pa sem bang bang a na sem ding, chi naso khum ding thengsel'a na koi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ahalneo khat pha bep khat alum lumma na sem ding hicheng akonna chu akeh khat na khen doh a keiman nangma ka kimu pi na ding munna chu, hettosahna maicham maiya na koi ding, hichu nangho jouse dia thil theng chungnungpen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Nangman hiche na sem ding thao namtui chu nangho manchah ding maimaija na kisem jeng lou diu ahiye; Ajeh chu nangma dinga Pakaiya dia atheng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Koi hijongleh nalah uva hiche gim namtui ja ki sem thil theng kihal mangcha aum khah a ahile ama chu amite lah a kon a delmang aum jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Pakaiyin Mose henga aseijin, ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Vetan Judah phung akon Hur chapa ahin, Uri chapa Bezalel chu amin ka pan in ka kou e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Keiman jong Bezalel chu Pathen lhangao ka dimsah in, chule thil boltheina le chihna khut themna jong ka petai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Thil lim jat chom chom a semna ding sana, chule sana dangka ahin sum eng khen themna tah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Chule song tampi jong ahin, thingthem bol theina agomma Bezalel ka peh ahitai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Tun vetan, Bezalel kitipa hi Dan phunga kon Ahisamach chapa Oholiab toh ka kitho khomsah ahiye, hiche chung chonna keiman nangma ka thupeh chengse hi asuh bukimsel na ding un, Keima mi ahi jal a bolthei chan abolna ding ka peh a ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Kikhop khomna ponbuh ahin, hettohsahna thingkong chule achunga hepi touna le asunglama thil jouse aboncha hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","Dokhang chule manchah jouse jao nan, thaomei khom le amanchah chengse le gimnamtui kihalna jong hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","Pumgo thilto maicham semna manchah ahin, kisil thengna kong le aman chah jong hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Phatah a kikhong ponsil chule hichu thempu-kin abolna diuva kikhong hi ding Aaron thempu chule achapate ding a akivon na diu atheng jong hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Tahsa a kinu ding thao namtui a kibol sohkei uva. Hitia chu ka thupeh chengse bang a aboltei tei diuva ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Hicheng jouse nung hin Pakaiyin Mose henga asei kit tan. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Israel chate henga seipeh tem in, nang hon keima cholngah nikho nanit teitei diu ahi, hiche cholngah nikho hi na khang lhum kei uva keima le nangho kikah a melchihna pang jing ding ahin; ajeh chu keima na Pakai uvin nangho jouse kathenso nao nahin hetjing diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Na boncha uva cholngah nikho nanit teitei diu ahi, ajeh chu cholngah nikho hi nangho dinga atheng ahin; koi hile hiche cholngah nikho'a atheng lou a kikum kha chan chu thina chang ding ahiye. Chule cholngah nikhoa na tong a aumjong le hiche mipa chu amite lah akonna paidoh a um jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Nigup sungse'a toh thei channa toh ding, nisagi lhinni teng hichu nikho theng cholngah nikhoa naman chah diu ahin, ajeh chu Pakai nikho theng ahi. Koi hijongleh cholngah nikhoa na tong pen pen chu thina kichan sah ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Hijeh a chu Israel chate jousen cholngah nikho theng hi beitih nei louva nanit jing diu, cholngah nikho chu aman jing diu, bei tih nei louva anit jing jing diuva ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ajeh chu ni gup sung chun Pakaiyin van le leiset anasem in; ni sagi lhin nin a kicholdo in ahi. hiche laitah jeh ahi nangman Israel chate jouse henga keima leh amaho kikah a melchihna apang jing ding ahi tin aheng uvah seiyin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Chuin Pakaiyin Sinai molsang chung a Mose henga hichengse asei chaisoh phat in, hettohsahna song pheng teni Pathen akon khutjih chu, Mose apetai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mose chu Sinai Molsang a kon'in ahung kumlha vah tapon ahile, Israel mipi abonchauvin Aaron henga ahung uvin ajah a asei tauvin ahi; Nagman keiho eilam kai diuvin milim Pathen'in neisem peh uvin, Mose Egypt gam'a kon'a eihin puidoh pa'u ageina lam ka hepha tapouvin, ama chung chang thua ima ka hepouve tin aseiyuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaron in jong aheng uva aseiyin, Na ji na chate'u bilba jouse sutlha uvin lang ka heng a na hin lhut sohkei diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Chuin mipin jong abilba chengse'u a sutlha uvin Aaron henga ahin choi sohkei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aaron in jong sana ho chu alan, sana khen na manchah khat a kheng in, hichu bongnou khat limin akheng doh tai. Chuin mipin jong “Vo! Israel, Egypt gam'a konna na hin puidoh uva Pathen chu hiche hi ahi, atiuve”. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron in jong bongnou kilhajol chu aven, hiche lim kisemna maiya chun maicham asem in, Aaron in hitin aseiye; Jing nikho tengleh Pakaiya di kut khat um ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Mipi jong chu jingkah matah in atou tauvin Pakaiya din pumgo thilto maicham ahin choiyun, mipin jong neh le don ding twi jong atoh doh un, hiti chun ama ama malam cheh a nopsanan aumpai kit tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Pakaiyin Mose henga thu a seikit in, ajah a, Chen lang na mite lam jon suh tan, ajeh chu nangman Egypt gamsunga konna nahin puidoh namite khu ama ama lam cheh a chon nun mangthah ding ahitaove, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Keiman jui ding a ka peh jousea kon'in amaho achemang gam tauvin, ama cham un bongnou lim asemun, chibai aboh un kithoi nan amang uvin hiti hin asei uve, “Vo israel mipite Egypt gam'a konna nahin puiod uva pathen chu hiche ho ahi, tin asam uve, ati.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Pakaiyin Mose henga aseijin, “Amaho chung chang thua keima kaki kum ding ahiye, ahi na'u abonchan kahesohkeijin milouchal te ahiuve, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Keima kaki kum ding, achung uva kalung souna ka buhlhah ding abonchauva kabah gam hel ding ahiuve, amavang keiman in nangma hi nam lentah a katun ding nahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mose jong Pakai henga atao jing tan hitin aseije, “Ka Pakai na lungsatna Egypt gam'a konna na hin puidoh namite chunga nalhun sah kigot jeng hi tam, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Egypt miten hiti hin sei unte, Pakaiyin amaho hi thagam dinga ahin puidoh a, Pakaiyin amaho hi molsang chunga pat a ahin pui doh uva tha gam hel ding ati ahi tin gel unte, tia a seina thei diuva nabol ki got hi tam? Na lunghanna a kon'in lungset tah in na lung heijin lang hiche mite chunga hin suhgamna lhun sah hihbeh jengin tin a tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Nalhacha masa Abraham, Isaac chule Israel chu avel in geldoh kit temin, aheng uvah kihahselna nana neiyin hitin naseiye, “Na son na chilhah teu kapunsah ding van'a ahsi jat kaphah sah diu chule keiman katepsa hiche gampumpi hi nang hon naluo soh hel ding u ahi, hichu nang hon atonsot tonsot geija ding ahi tia nasei chu avel in geldoh kit temin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Chuin Pakaiyin amite chung a abol ding thil chu bol talouvin alung ahai tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mose jong molsang apat chun ahung kumsuh tan ahile, hettohsahna songpheng teni a mailamma Pathen khut jih ki jih teni chu ahin choiyin ahi. Hiche song pehng teni chu anung lam ahin chu le amalam a jong anigel a lekha jem kisun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Hiche songpheng teni chu Pathen'in asem ahin, Lekha jem kisung jeng jong chu Pathen lekha sut ma ahi. Hichu asong peng teni chunga chu a kijih sa ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Chuin mipi awgin chu akithong jeng tan ahile Joshua injong Mose henga aseitai, “Ngahmun sunglama khu galkisat a hitam awgin khu ngaitiem in atin ahi”, ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mose'n jong a don but in aseije, “galjona awgin jong ahideh poi chule gal lal na jeh a awgin jong ahipoi, keiman ka jah dan in lakisa awgin joh ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Mose jong ngahmun lailung ahung lhun tan ahile, bongnou lim ki sem thu chu amutan chule mipi abonchauva alam ujong chu amun ahile ama alungsa lheh jeng tan ahi. Chuin akhut tenia ahin choi songpheng teni chu tolla asep lhajeng tan ahile anigellin akeh jeng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mose'n jong bongnou lim kisem chu alan meiyin ahal vam lha jeng tan chuin tol lham ma jong agoidi jel in chujouvin avutvai chengse chu twija asunglut in hiche twi chu Israel te abonchauvin adonsah in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mose'n jong Aaron henga aseiyin, hiche mite hon na chunga ipi lomlom a se abol uva nangman amaho chung chang thu jeh a hichan loma hi chonset nabol jeng hitam tin aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron jeng jong chun aseijin ipilom ma nalung sat na na lhunsah jeng hitam kapu atin, amaho hi thilse bol ding a kipedoh ahi tauve tin aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","ama hon ka heng a aseiyun, ei lamkai thei diuvin pathen limsemthu tampi eisem peh un ajeh chu Mose kitipan Egypt gam'a kon'in eihin puidoh uvin tun amahoiya uma iti ham keihon ama chung chang imacha kahe tapouve tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Keiman jong aheng uva ka seijin, sana bilba neichan in sutlha uvin katin ahile hichu kaheng a ahin choi jun, chuin keiman jong sana bilba jouse chu meilhum sung a kalhah a ahile bongnou lim in ahung soh doh tan ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Aaron in hitia mipi anabol tah jeh chun Mose'n jong hiche mite hi akijumso ding mong mong a kilha thang ahi tauve ti ahe chen tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mose jong achen ngahmun kelkot achun adingin, Pakaiya dia pang jing koikoi nalah uva um'em, kaheng lama hungun tin aseitan ahile, Levi chapate jouse chu Mose henglama ahung tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Mose'n jong amaho henga aseijin, Pakai Israel Pathen'in aseije, Pasal ki tiphot in chem cha akong a ki poh cheh uhen, ngahmun kelkot alangto gel'in phetlha uvin lang, pasal a kai kiti phot in asopipa chu that jeng hen, chule pasal a kai phot chun a sopipa that jeng hen, pasal jousen aheng akom'a in heng chan chu that jeng hen tin aseiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Chuin Levi chapaten jong Mose thupeh bang ban in mi a that tauvin ahile, hiche nikho chun mihem sang thum jen athi tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mose'n jong hiti hin aseyin, tunia kipat nang hon na macham cheh uva Pakai kin nabol theina diuva, mi abangin achapa atha a, chule asopipa ham atha a, ajeh chu tuni nikhoa hi nangho jouse chunga Pakaiyin nachung cheh uva thensona anei ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Mose'n jong ajing nikho in japi henga chun aseijin, nang hon chonsetna thanghoi tah nabol doh tauvin, keima tua hi Pakai henglama che touding ka hin, hiche chonset nabol uchu thoidamna na kisem peh diuva ahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mose jong Pakai henglama akilen aseitai, Hiche mipite jouse hi abonchauvin thanghoi tah in chonset abol tauvin ahi. ama amacham in pathen limsem thu tamtah ana kisem doh tauvin ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Hijongleh Pakaiyin na lung ahile a chonset na'u jouse ngaidam teiyin, ngaidam thei lou dinmun ahitah le vang, na heng a ka hung tauve, nangman na jihdohsa hiche songpheng a kon chun keima hi nei sugam hel jeng tan tin atao tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Chuin Pakaiyin Mose henga aseijin, “Koi hijongleh keima doumah bol'a chonse pa bou chu hiche ka lekhasut akonna chu keiman jong ka suh gam hel jeng ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tun nangma ki patdoh in keiman ka sei peh na mun, hiche mun channa chu mipi na ga lam kai ding ahiye. Ka vantil chu na masang lama masa ding, keiman nangma ka hung vil tengleh koi hile hiche mite lah a achonse pen pen chu keiman lethuhna ka peh cheh cheh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","“Aaron in mijouse bong lim ana sem peh tah jeh in Pakaiyin jong gamsunga natna hoise alansah tan ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Pakaiyin Mose henga thu aseijin, “kipat doh inlang che touvin, nangma chule Egypt gam'a konna nahin puidoh mite jouse jao nan, Abraham, Isaac chule Jacob henga kana kihah silna, na son na chilhha te ka peh ding ahi tia ka seina gam khu jon tauvin, ati.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","“Keiman na masang lama vantil khat ka sol ding, chuteng keiman Canaan mite, Amor mite, Hit mite, Periz mite, Hivi mite, Hit mite chule Jebus mite abonchauva ka deldoh gam hel ding ahiuve, ati.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","“Bongnoi le khoiju lkonna gam khu jon tauvin lang, ahin ka tahsa tah a ka lhonpi louding nahi. Ajeh chu na louchal jeh a lampi a ka moh suhgam jeng thei nahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mipin jong thu kisei awgin chu ajah doh phat uvin akap lha gam tauvin ahi. Mikhat jouse khat jeng cha jong a kivon na ngai yin a kivon ta pouvin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","“Pakaiyin Mose henga thu aseijin, Israel chate jouse henga seiyin, mi louchal te na hiuvin, bangkah khat na lhon tou pi jong leu, na louchal jal uva ka suhgam hel thei nahiuve, tun nangma chung cheh a na kivon na chengse'u sutlha uvin lang, chuteng keiman nangho lamhil ding dan na hin het them diu ahi, ati.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Chuin Horeb molsang a kon'in Israel chaten achung uva kai akivon na jouse'u asut lha'u vin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mose'n jong ponbuh chu ana lang jing chule hichu ngah mun apat ki gamla thim khat a ana son ji ahiye. Ponbuh chu kikhop khomna ponbuh ahin, miholah a koi hijongleh Pakai holnom chan chu ngahmun pamlama ponbuh ki song lama chu ga che teitei ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mose jong chu ponbuh akonna ahung potdoh teng mipi abonchauvin ading doh jiuvin, mjouse jong chu ama ama kotpi phungbula ding den sohkeijuva, Mose jong ponbuh asung lha kahsea mipin jong avet mang kei u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Chuin Mose jong ponbuh sung alut jiteng meibol chu ahung kitollut jin, kotpi phunga chun akitang den jin, chuteng Pakaiyin Mose chu akihoulim pijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Mipiho jousen hiche meilhang kotpi phunga ahung kitan den amujiteng ule, Mipi jong abon chaovin ading doh uvin, amimal cheh in ama kotpi phung bul cheh a chibai aboh jiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Mikhat in aloipa ahoulimpi bang banginPathen'in Mose chu ahoulim pijin ahi. Mose jong ponbuh sunga ahung sunglhah kit teng, ama lhacha a pang leji Nun chapa Joshua jong hiti chun aum den jitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mose'n Pakai henga aseijin, ven! Nangmatah in kajah a nasei ahi. Hiche mite ho hi hinpui touvin tin naseiyin, ahinlah amahola a hi koipen toh neisol ding ham ti nei seipeh pon ahi. Ahinlah nangman naseiyin, keiman nangma hi hetsahna kapeh nahin chule nangman naseijin keima lunglhaina vang nachang e nei tinai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Tun nangma mitmua lunglhaina kachan tah a ahile, nahenga kahung taove, nangma kahetthem jinga chule namitmua jong lunglhaina kachan jing theina dingin, lamdih a kipugina ding jouse abonchan neihil inlang, amaho jong hi nagma mite ahiuve tijong hin sumil hih hel in, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Pakaiyin aseijin, kami umpi nachun nalhon pi jing ding ahi. Hiche akonna chu nangma choldamna kachansah tei ding nahiye, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mose'n jong Pakai henga aseijin, ahinaije, nangma umpi na chun neilhonpi jing louva ahile hiche munna pat hin neipuidoh dajeng tauvin ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Keima kahin chule namite jouse ahin nangma mitmua lunglaina kachang uve tihi iti kihetdoh thei ding ham? Neilhon piteng ule keima ho hi atumbeh a neigel na'u ahin, keima ka hin chule namite abonchauva leiset chunga midang jouse akonna a tumbeh mong mong ka hitauve tihi ka het doh thei lou diu ham, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Chuin Pakaiyin Mose henga aseijin, “Na seidohsa hi keiman ka bol ding ahi. Ajeh chu kamit mua lunglhaina nachan ahin, hiche jeh chun keiman nangma ka het chenset na hitai,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mose'n jong aseijin, ka hung tauve,” na loupina ka heng'a kilah sah tei teijin ati tan ahile.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Pakaiyin adonbut in ajah a, “Ka loupi na aboncha na masang lama ka kitolsah ding, na masang lama pakai min ka sam phong peh ding, chule ka lungsetna chu na chan jing ding, hepi na jong nangma kachansah ding naiye,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Chuin aman aseijin, “Ahinlah kamai vang namu thei louding ahiye, ajeh chu mihem koi hileh kamai muchan chu thijeng ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Pakaiyin aseijin, Ven! “Ka kom'a a onglaija hin hung dinginlang, hiche songpi chunga hi nadin ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","“Ka loupina ahung kitol tengleh keiman songpi kikah a kasel ding, hiche laimunna chu kasel jing ding keiman kadalhah tengleh bou kahoh doh kit ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","“Ka dalhah tengleh keiman ka hin hoh doh ding, chuteng kanung lam bou namu ding, itinama jong le kamai vang namu thei louding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Pakayin Mose henga thu aseijin, “Masang ngaiya bangin songpheng'ni suiyin lang, hiche song pheng teni achu masang'a nangman nasekeh songpheng teni chung'a kijih thuchang chu keiman ka hin sut kit ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","“Kigo'inlang jingkah teng'le Sinai molsang lam'a nahung kal touding, molsang vum'a kaheng'a nahung din ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","“Koima dang na hin kilhon pithei louding, hiche molsang jousea khu koimacha dang kilah thei louding ahi. Kelngoi hon ahin gancha kitiphot khat jeng cha jong molsang lah a khu nalhat sah louding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mose'n jong masang'abang bang chun songpheng ni asuiyin, ajing jingkah matah in athoudoh'in Pakai thupeh bang chun Sinai molsang chung vum'a ache tou tan, song pheng teni achoijin a kaltou tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","“Molvum lama kon'in Pakai chu mei bol in ahung tan chuin Mose toh'a ding khom lhonne. Chuin Pakai min chu sangtah in akouvin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","“Pakai jong Mose masa lang lama chen, a sei peh in, Pakai, Pakai hepi them le lunghang vah lou iti channa mi lungset them le dihna dimset jeng tin asei in ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","“Mihem asang asang chung'a lungset na nei jing, themmona le suhkhel na jouse jong ngaidam jia, amavang themmona alembaseh a umsah lou mipa le chate kikah atute channa natong jing ding, chule khang thumle-li channa natong theiya ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","“Mose jong tol lhamma akun'in chibai aboh paijin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","“Mose'n aseijin, “O Pakai nangma mitmua lunglhaina kachanna ahile, nahenga kataove, Pakai hi kalah uvah hung um henlang, kathemmonao le kachonset najouse ngaidamin, nagoulo thei din neisem tauvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","“Chuin Pakaiyin aseijin, Tua hi keiman nangma toh ikah a kitepna ka sem ding ahi. Namite lah a keiman thil nasatah tah ka kilah sah ding, hitobang thil ki dang ho hi leiset a ana umkha lou lai ahin, chule nam dang telah jeng ajong anasoh khalou lai ahi. Na chenna chan uva mihem hon Pakai thil bol ki dang ahin mudoh diu, ajeh chu keiman ka hinbol ding thil hi thil ki dang tah ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","“Tunin ka thupeh hi na suhmil louding ahi. Nei hin ven, kei matah in namasang lama Amor mite, Canaan mite, Hit mite, Periz mite, Hivi mite le Jebus mite abonchauva kajam sah gam diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","“Tun nangma ki cheh theiyin, na chenna gammite toh kitepna hinsem khan nate, achuti louva ahile hitobang kitepna chu kipal lhuh'na hung pang ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","“Hijeh chun nangman hiche gammite maicham jouse chu nasuh set gamhel ding, akhompi jouseu jong nasuh lhuh sohkei ding ahi, chule Asher doi jong chu na phuh lhuh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","“Ajeh chu nangma pathen dang angsung'a naboh khup'a natao thei louhel ding ahi. Ajeh chu amin jong Pakai chule Pathen chu hung thang tom jing thei ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Hijeh chun agamsung chengte toh kitepna na sem thei louding, hiche mite chun a pathen'nu umchan atho diu amaho le amho kah a jonthanhoi in apat diu, hiche pathen semthu ho heng'a kilhaina asem teng ule nangma jong nahin tep diu ahin, hiche a na hinkou pen pen-sa ki lhaina chu naneh thei louding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","“Na chapate ji dinga agam cheng numei napuipeh theilouding, a channute jouse'u a pathen'u umchan atho uva a ki joh bang uva khu, na chapate jeng jong hung ki joh lo ding'u ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Chule nangma macham'ma pathen limsem thu kiti mong mong nahou louding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Chol solou Changlhah Kut jong imatih channa na man jing ding ahi. Ka thupeh bang bang'a aphat ahung lhun teng, Abib lha sungse'a chu nangman cholsolou changlhah na neh ding ahi. Ajeh chu hiche lha sunga hi nangma Egypt gam sung'a kon'a na hung doh ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Chule ahung peng doh masa jouse chu keiya ding ahi. Achal'a kai lhah ki tiphot chu, gancha lah a bong ahin, kelngoi hi jong le keija ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","“Sangan hung peng doh masa jong chu nangman kelngoi khat a nalhat doh ding, itobang khatna na lhat doh jou louva ahile hiche sangan nou chu angong chang na he boh peh ding ahi. Na chapate lah a ahung peng doh masa pen jong lhat dohna na sem peh tei ding, ajeh chu na lah uva koima ka heng lam'a khut goh keuva hung kilah thei louding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Ni gup sung se'a nangman tohthei chan natoh ding, ni sagi lhinni tengleh na kichol do ding ahi. Lou na toh lai hihen lholhun lai hijongleh nangma nakichol teitei ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Ni sagi lhin nia kut jong nabol jing ding na nit teitei ding ahi. Chule suhlou chang kut jong nabol jing ding, kum lhun tengleh muchi ga soh khop tup kut jong nabol cheh cheh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","“Kum khat sung'a namite lah a pasal'a kai lhah jouse Israel Pakai, Pathen heng'a hung kilah cheh ding'u ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","“Ajeh chu keiman nam tin vaipi jouse masang'a ka huhdoh a hitia chu na gamgi ka suh len ding ahi. Ajeh chu nangma kumkhat sung'a Pakai heng'a kilah ding na che tengleh hiche gam'a konna chu khat jeng chan jong na umlou kah a na gam sung lah ding lung aken louhel ding'u ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Ka heng'a ki lhaina sa kiti phot chol sosa toh na neh tha louding, Kalchuh Kut a dinga sa kithat chan jong jing khovah geiya na koi den theilou diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Na gamsung'a ga soh jouse jong na Pakai leh na Pathen heng'a nahin poh lut cheh cheh ding ahi. Chule kelngoi nou jeng jong api noitwija na hon min thei louding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","“Pakaiyin Mose heng'a thu asei in, Ka thupeh chengse abonchan sun doh cheh cheh in, Ka thupeh chengse dungjuiya hi Israel toh na kikah a kitepna ka sem doh ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Hiche laimun na chun Pakai le Mose chu ni som le jan som li jen aum khom in ahi. Hiche phatsung'a ahin Mose'n twi jong donlou an jong ne louvin aum'inahi. Hichea kitepna jouse chu Mose'n jong song pheng teni chung achun ajih lut tan ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","“Sinai molsang lam'a kon'in Mose jong ahung kum suh'in ahile hettohsahna song pheng teni chu ahin choiyin ahi. Mose mai chu vahlha jeng'e ajeh chu Pathen toh aga kihou lim jeh ahin hinlah aman ahedoh pon ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","“Chuin Aaron le Israel chate jousen amudoh tauvin ahile, Mose chu amai avah lha jeng tan, chuin amaho abonchauvin akicha lheh jeng tauvin ave ngam ta pouvin nai jong ahin nai lut ngam tapouve.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Mose'n ahin kouvun, Chun in Aaron le khopi sung'a lamkai jouse Mose henglama ahungun, Mose'n jong amaho chengse chu aki hou pin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","“Israel chate ho jousen jong ahin nailut cheh uvin, Sinai molsang chung vumma Pakaiyin Mose ahoupi na bang banginMose'n jong Israel mite Jouse chu a houlim pi'n thu jouse chu ajah uva a sei peh tan ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","“Mose'n jong thupeh Jouse aheng uva asei chai soh phat in amai dal dingin pon khat aki lekhu sah tai.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","“Mose jong Pakai to kihoulim dinga ache lut ji teng, ahung potdoh kit kahsen amai dalna dinga ponkhu chu ahin ki lah doh kit ji tan ahi. Mose jong ahung poh doh a Pakaiyin ipi ahin seipeh ahidem ti Isreal mite heng'a a seipeh jin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Israel cha ten jong Mose maichu ave uvin ahile, avah lha jengin ahi. Mose jong Pakai toh kimuto dinga ache lut kit kah sen amai dalna pon chu akikhu jin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mose'n jong Israel insung abonchauvin a kou khom sohkeiyin ajah'uva a seipeh in ahi. Hi chengse hi Pakaiyin nangho jouse jui dingin aseiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","“Nang hon hapta sung'a tohthei chan na toh pan ding un ni gup na nei uvin, ni sagi lhinni hi nangho dia nikho theng ahin, hiche nikhoa hi na kichol sohkei diu ahi. Ajeh chu Pakaiya dia thenso ahitai, koi hile hiche nikhoa na tong chan chu thina chang jeng ding ahiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","“Cholngah nikhoa hi nangma insung cheh a mei jong nati kong louhel ding'u ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Chuin Mose'n Israel chate jouse heng'a a seipeh in, hiche hi Pakaiyin athupeh ahi: ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","“Pakai henga na thilpeh diu chu nangma nei cheh chu dong khommu vin lang, ami chancheh in Pakai dinga thilpeh na katdoh diu chu ki choi cheh'uvin. Pakai dinga hongphal tah in hicheng hi pehen: sana le dangka chule sum eng,” ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","“A engdum ahin, asan dup hichu hoitah a kikhong hi ding; kelcha mul jaona hi ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","“A ki nam-sel kelngoi chal vun chule kelcha vun ahin thinggi thing jaona hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","“Thaomei dinga Olive thao hi ding; chule kinu ding thao namtui jong halnam thei thao twi jao cheh cheh ding ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","“Songman tam, chule tun ding song jong konggah omphoa manchah ding jong ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Koi hileh na lah uva khutthem na tong thei jouse hung'un. Tundoh dinga Pakai thupeh chengse sauvin: ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“A ponbuh ding, a chung vum'a khu ding, athil manchah jouse jao nan, ajol le akhompi jouse jaona hi ding ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","“Thingkong chule aputna ding moljol teni jong; hepi touna, chule pon akhu khumna'a kimang jong hi ding ahiye; ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","“Chule dokhang ahin amol jol ho jaona; manchah chengse le changlhah ki katdohsa ho jaona hi ding ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","“Meivah thaomei khom le aman chah chengse; chule Olive thao vah ding jaona hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Gimnam tui lhut na ding; chule amol jol chengse kinu ding; thaotwi le halnam thei thao twi chengse jong; chule houbuh a manchah ding pondal chengse jong hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Pumgo thilto maicham; chule athil keo Jouse kisilna kong le atunna jong ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Amunna khai ding ho jong; akhailhah nading khom ho jaonan; chule kotbulla khai ding pon dal jong jaona hi ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Houbuh kilmat na ding ahom ho ahin, akhao jouse jong jao cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Muntheng'a manchah dinga kikhong von jouse leh thempu kin bol'a apan teng ule aman chah diuva kikhong Aaron vontheng chengse ahin chule a chapate von chengse jong hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Chuin Israel insung pumpi'n Mose akon chun apotdoh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Chule alungthim'ma ki tilkhou na nei chan le lhagaova hel doh chan chu ahung khom uvin, ki khopkhomna ponbuh sung'a manchah ding ahin, kin bolna'a manchah ding chule ki von'na athenga manchah ding abonchan Pakai heng'a ahin lhut tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Numei le pasal ani gel'in ahung khom tauvin ahi. Chuin heo jang ahin, khutjem, bilba, chaokol le sana a ki sem thil jouse jong ahin choikhom sohkei uvin ahi. Ama ama michan cheh in sana thil peh jouse ahin choisohkei uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Ama cham'a kipedoh chan chun hi chengse hi ahin choiyun ahi: pon dum, sandup, a sanpol, tupat pon, kelcha mul, kelngoi chal vun, kelcha vun chengse jong anei channu ahin choi khom sohkei uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Ami takip in Pakaiya thilpeh ding ama ama cheh in ahin choiyuvin ahi. Chule ipi thil'a ki mang hi jong le Pakaiya din ahin choi khom sohkei un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ajou chan in ama cheh khut themna tah in pat akhong un, chuteng hiche pat kikhong jouse chu asan hihen asan dup hijongleh asanpol jaonan tupat ponnem'ma hijongleh ahin choi khomsohkeiyuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Numei ho jouse lah a alung sung'a konna kipiehdohna nei channa chun kelcha mul'a kon'in abol cheh uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Japi lamkaija pang chengse'n jong konggah ding le omphoa beh dingin songman tam jatchom cheh ahin choi khom uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Chule ama hon gim namtui ahin, meivah'a pang ding thaotwi ahin, kinu ding thaotwi chule gimnam tuiya halnam thei jong ahin choi khom uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","“Isreal chate lah a numei ahin chule pasal ahin, Pakaiyin Mose heng'a a thupeh banginbol inge tia a lungthim ma kon na ki tilkhouna nei channa chu Pakai heng'a ki pah le thanom tah in ipi hijongleh apeh nom chan'u chu ahin choi khom uvin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Chuin Mose'n Israel mite heng'a aseijin. “Juda phung'a kon Hur chapa Bezalel chu Pakaiyin alheng dohtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Pakaiyin Bezalel chu Pathen Lhagao adimset sah jeng tan, amapa jong Chihna, le lung thim hat tah thil bol thei tah ahung hidoh tan ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","“Amapa chu thil jep dan jong them tah, sana le dangka jaonan thil ijakai sem dan jong amacham'in ahin he doh theiyin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","“A mapa chun tun ding song tam tah a sem in, thing jong ajat jat in ajem theiyin, khutthem na jouse achang theiyin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","“Pakaiyin Bezalel chule Dan phungkai akon'in Ahismach chapa Oholiab ahin, ani tah lhon'in mijouse kihil nathei dingin asem doh lhon tan ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","“Pakaiyin Amani chu natoh ijakai thepna ape lhon tan ahile, thilsem themna neijin, thembol in apang lhonin, thil lim gon dan jong, pon jep pol dan jong, a dum, asan pol, chule tupat pon bang khui themna jong apeh lhkonna ahi. Bezalel le Oholiab in jong thil ijakai boltheina chu achang lhon tan ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Pakaiyin Bezale le Oholiab chu thilbol theina ape'n chule muntheng tun dohna mun chu chihna le ijakai bol ding jouse het them theina apie'n ahi. Pasal'a kailhah kitiphot in Pakai thupeh bang bang'a abol diu'vin a seiyin ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mose'n jong Bezalel le Oholiab Pakaiyin thilbol theina apieh lhon bang chun adang hojouse'n jong natong dingin ama cheh in thanopna aneiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mose in jong muntheng sah doh na ding le amun theng tun doh na ding chun Israel mite'n thil man chah ding a dondoh chengse'u chu natong ho ape tauvin ahi. Ahinlah ama hon jingkah sim in Mose heng'a thil lelo ahin choijun atohdoh jing uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ajo nan thilbol them ho chun mun theng munna ana toh banjom dalhan ache tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Ama hon Mose heng acheuvin hiti hin asei uve, Mipihon ka heng uva Pakaiyin toh ding eipeh chengse'u sang'a tamjo eipe tauvin ahi, tin aga sei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Chuin Mose'n jong aum nau ngahmun achun thu athot tauvin ahi: “Muntheng na toh na dingin pasal hile numei hile thil ima hin peh be dajeng tauvin, tia thu ahil'uvin, ajeh chu thil ijakai aning lhing'e tin aseiyin ahi!” Chuin mipi'n jong thil ijakai ahin choiyu chu angatauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Thil le lo ahin choijeh uchun ijakai adimlha jeng tan, tohgon ding kalval'in manchah aum tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Natong them ho chun pondal somkhat cheh amang uvin ponbuh akison tauvin ahi. Bezalel in jong ponbuh'a kimang chu tupet ponnem kikhong ahin, adum le asadup le asanpol ho chu ahin, thilbol theina tah a cherub limbang bang kisem hose chu amangchan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Pondal khat cheh chu a dung tongsom li-le-tongni asaovin, a vailam'a pang pondal ho chengse vang chu tong gup alhing in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Pondal lah a nga chu khat le khat akilmat cheh cheh in adang pondal nga chengse jong chu khat le khat akilmat in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Chule amasang lam'a pondal kigol chengse chu abil homkol tampi dum thim in asem peh'in chule pondal kikhai ageigol'a chengse jong chu abilhom tampi asem'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Pondal masa joa abilhom somnga asem peh in, ani chana pondal chengse jong somnga ma asem in ahi. Aki kilmat na ho chu khat le khat kimai ngat tocheh in ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Aman sana kol somnga asem in, sana kol ho chun pondal khat le khat akilmat in, chuin houbuh chu pondal buh khat ahung sodoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Chuin aman houbuh chungvuma khu dingin kelcha'vun ho chu amang chan, pondal jong som le khat asem doh'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Pondal khat chu adung somli-le-nga cheh alhing in, chule adang pondal availama chu tong-gup alhing in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Bezalel'in jong pondal ngaho chengse chu akilmat sohkeiyin, chule amoh pondal gup chengse chu anichanna achun apansah'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Aman pondal hoa chun abi lhom somnga asem peh in, hichun pondal saotah a a kilmatsah cheh cheh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Chuin aman ponbuh khat seh a akison doh theina ding le akilmat na dingin sum eng kol somnga asem in ahi. Hiti lamdol chun, ponbuh chu a khu khum na a sempeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Chule houbuh sem doh na dingin Bezalel chun thinggi thing pha bep asem doh'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Thingtun khat chu adung tongsom le tonnga alhing in, atun khat cheh chu inchi somni le sagi alhing in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Thingtun khat cheh chun atun na ni aneiyin ahi. Chule atunna jouse chu abonchan asem hoisohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Aman thingtun somni a semdoh in hichu lhanglam houbuh'a amang cha'n ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Aman jong atunna dangka in somli asem'in chule atunna khat abil'a pang ding achu abilhom jong asempeh cheh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Houbuh solam'a pang ding chun atun somni ma asem peh'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Atunna dangka somli'a kisem khomkhat na atunna chu ni asempeh cheh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Aman houbuh nunglama pansa dingin ajol gup asem'in ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Houbuh nunglama pang ding chun atun ni ma asem peh'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Hichea kimang atunna ho jouse chu abul lang achom cheh ahin, alu lamse vang chu anung lama chu kikai mat cheh a ahiuvin, aning gol'a pang dingin atunna teni jong chu asem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Aki tunna dangka chu toh'a semtha in ahile som le gup alhing in ahi. Ajol'a pang ding chun atunna ni cheh alhing in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Chuin aman thinggi thing amang chan avaiya pang ding asuiyin, houbuh solam'a pang ding chun agolvai nga asem in, ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","Chule lhanglam'a pansa dingin agolvai nga ma asem'in ahi. Hichengse chun lhumlam angan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Aman alaigol lah a pansa din among lang khat a konna alang khat mong golla pang ding chun, ajol khat asem kit in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","A tunna chengse chu abonchan sana in atom jol nam sohkeiyin, sanakol jouse jong chu agolvai ho manchah din asempeh in, agolvaiya ho jouse jong chu sana mama'in atom jol sohkeiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Houbuh chung lam'a pansa ding chun Bezalel in pondum, ponsandup le asan-ao tupat pon mang chan asem in, hiche pon chu khut themna nei tampi'n asem cherub lim tampi akhuijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Hichea pansa ding chun thingggi thing-li a sem doh in chule akhom jong sana-li in ajol nam sel in, akol asempeh'in akhom li ding machun sana jong lijen asem'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Chule aman ponbuh kot phung lam'a pansa ding chun adum, asan dup, asa-ao chule tupat pon jeng'a ajem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","A kikhaina chengse chu sana jeng'a kisem atunna nga asempeh in ahi. Akhom chengse ahin chule atomna chengse chu sana jengin atom jol sohkeiyin akhom nunglam'a pansa ding vang chun sumeng jeng mangchan asem'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Chu ban'in Bezalel chun thinggi thing mangchan thingkong asem tan; adung tongni le akeh ahin, avai tongkhat le akeh chule atun tongkhat le akeh ma alhing in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Aman jong asung lam le apolam ani gellin sana'in atomjol sellin, akimvel jouse jong sana mama in atom'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Aman jong aning gol'a pansa ding chun sana kol-li asem in pang lang khat a chun kol-ni asem'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Chun aman moljol ni thinggi thing mangchan asuiyin, sana mama'in atom na'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Thingkong putna dingin moljol teni chu thingkong geiya chaokol teni achun athil lut'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Chuin aman sana thengsellin thingkong khuna asem in, chule hepi touna jong asem in adung lam chu tong ni le akeh ahin, availam chu tongkhat le akeh alhing in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Chuin aman sana sehcha'a kikheng cherub lim bang'a um ni asem doh'in hepi touna among lam'a chun hiche teni chu apansah'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Chule aman cherub khat aning lam khat achun apansah'in among langkhat ma achun Cherub khat ma apan sah in hichengse chu khat'in asem doh'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Cherubim teni chun chunglang anga lhon'in chule alha ajap lhon'in hepi touna chu alhaving tenin a veng bit lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Chuin Bezalel in jong thinggi thing mangchan dokhang asem in ahi. Adunglam chu tongni in asem in, avai chu tong khat ahin chule atun lam chu tong khat le akeh alhing'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Aman akhom ho jouse chu sana in atom jol sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Akimvel sechu khutphang tebep a saovin akhuna asem in chule ageikol jouse jong sana'in atomjol sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Chuin aman dokhang'a manchah dingin sana chaokol-li asem in, dokhang keng-li lama chung apansah'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Chaokol chengse chu abonchan kinai chan aumsah sohkeiyin, chaokol hose chu dokhang akijon teng kimang cha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Aman hichengse chu thinggi thing jeng mangchan asuiyin, abonchan sana'in atomjol sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Chule dokhang'a machah ding chun sana kong thengsel phabep asem'in lhengkong ahin, gimnamtui halna ding chule lengpitwi chapna ding jong abonchan sana in atomjol sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Chuin Bezalel'in thaomei khom asem'in hichu sana theng sela asem ahi. Thaomei khom tuna ding ahin aputna ding, anigellin phatah in sehcha'n akheng in ahi. Hichea pahcha kijem'a pang le alutom ijakai jouse chutoh thaomei khom jong jaonan khat'in asem doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Thaomei khom chu gup ahin, aning ho a kon'in abah thum cheh ahin jamdoh'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Alang alanga abah gup jamdoh hoakon chun thaomei vah khon banginajamdoh'in alu ajum in apah jeng jong ahung um doh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Hiche thaomei khom chu almond pahbangin aning li aum'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Thaomei khom akonna hung jam doh abah gup chengse chu toh'a noilam'a chengse jao nan khat in asem doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Almond bah hung jam doh chengse chu toh abonchauva khat ahung soh doh theiyin, hichengse chu sana thengsella kikheng jeng seh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Aman jong thaomei sagi asem in amei khao che tanna chengse jaonan sana thengsel in asem doh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Thaomei khom chu ahin, aman chah jouse jaonan sana thengsel dangka somsagi le nga mangchan asem doh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bezalel chun gimnam tuiya dingin maicham khat thinggi thing'in asem'in ahi. Hichu adung tong khat chule atun tong khat ahi. Chule hichea kimang cha saki chengse chu toh khat in ahung um doh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Aman maicham chu sana theng sel in atom namsel in, achung vumlam ahin chule ajet le avei jeng ajong, chu le a saki jouse jong abonchan sana in atom namsel in ahi. Hiti chun aboncha'n a kimvel jouse'a chun sana ajem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Sana ki jem pah noiya akol a pang dingin aman sana chaokol ni asem doh in, khat cheh chu akingat tohsah in akhaiyin, maicham put le na manchah dingin asem doh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Aman amoljol jouse jong chu thinggi thing jengin asemin sana'in atomnam sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Chuin aman kinu thei dingin thaotwi asem doh'in gimnamtui jeng jong chu halnam thei dingin asem'in ahi. Hichengse chu abonchan thaosem them hon asemdoh bang bangin asem tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Chuban in Bezalel in jong thinggi thing amangchan, pumgo thilto maicham asem in ahi. Hichu atun feet sagi le akeh ahin asaodan jong feet sagi le akehma alhing'in chule asan dan tong li-le-akeh alhing'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Aman aningli chengse a chun saki-li asem'in hiti chun saki chengse le maicham chu khat'in aum doh theiye. Aman maicham chu sum-eng in atom in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Chule aman maicham'a manchah dingin sum-eng a mangchan bel ahin, khe keh, khangbel, kong le sum khe asem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Chujouvin aman sum-eng jengin lhuhkhuh asem in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Aman hiche dopna ding chun ningli asem'in ajol toh tho a pansahna ahin, hichengse chu sum-eng jeng mangcha'a alhah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Aman thinggi mangcha'n thingjol jouse chu sum-eng jengin atom'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Aman maicham putna dinga akol-li asem ho chun, moljol chengse athillut'in ahi. Chuin maicham chu aumna ding asemtuoh'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Bezalal chun ponbuh kotphung'a lhacha'a pang numei ho kisil'na kong ahin chule atunna ding jong chu sum-eng jeng'a asem'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Chuin Bezalel'in pal agen kimsohkeiyin, pal'a khaiding poun jouse chu tupat pomnem ma kisem jeng ahi. Chule lhanglam'a khai ding poundal se chu feet jakhat to somnga alhing'in ahi. hiche pal lhanglama khaiding pondal chengse jong chutupat ponnem jing a kikhong ahin agom chun tong jakhat jen ahilhng e. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Apal khom somni ahin, aboncha sum-eng jeng'a kisem ahi. Palkhom'a akol kisem chengse jong dangka jeng'a kisem ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Aman pal sah lam'a pansa dingin feet jakhat thoh somnga chule akhom somni jaona hichengse chu sum-eng jeng'a asem ahi. Pal khom ahin, akhaina kol aboncha sana le dangka jeng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Chule lhumlam'a pondal pal chengse chu feet somsagi le nga alhing'in akhom ahin, akol kisem jouse chu sana le dangka jeng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Mailam'a pansa pondal chengse jong chu tong somsagi le nga sao ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Kelkot polam'a pondal khat chu Tong somnileni akeh alhing in, chule atunna khom jong thum ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Chule kelkot langkhat a pansa jong chu kibangin asem'in Tong somni le ni ahin, chule atunna khom jong thum’ ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Pal kigetna'a pansa pondal jouse chu tupat ponnem jeng'a kisem ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Palkhom ahin atunna khom aboncha sum-eng jeng'a kisem ahi. Akhom'a kimang ho jouse jong chu sana le dangka jeng'a kisem ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Aman palmai kot phung'a ding chun pondal asem'in ahi. Hichu Tong somthum in asaovin, asandan tong sagi le akeh ahi. Aboncha pal'a kigen chengse toh chun kibang ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Akhom chengse chu li ahin, atunna jouse jong chu sum-eng jeng ahi. Chule atunna, akhaina kol jouse jong chu sana le dangka jeng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Houbuh ahin chule akimvella pondal jouse jong sum-eng jeng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Hichengse houbuh ahin, chule hettohsana houbuh hichu Mose thupeh dungjuiya kisem, thempu Aaron chapa Ithamar ngaisahna dungjuiya Levi te ho natoh nadinga kisem ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Chule Juda phung khaiya kon Hur chapa, Uri chapa Bezalel'in jong Pakaiyin Mose athupeh bang chu bolkim sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Amapa chu Dan phung akon Ahismach chapa Oholiab chule khut themna neitah le ijakai thilbol them patdum ahin,ponsandup chule tupat ponnem bol them'a jong pang ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Houbuh le muntheng sahdohna dingin sana Shekhel somni le ko leh ja sagi leh somthum ahin choi khom uve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Israel pumpi'n dangka talent jakhat toh Shekhel sangkhat toh jasagi leh som sagi leh nga jaonan apedoh'uvin muntheng sahna'a kimangcha shekel dungjuiya kisim ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Hiche dangka kidongkhom chengse hi min kisim dungjuiya hung kipielut chu ahi. (Hichu beka khat shekel kehkhat toh kibang ahin, muntheng laiya manchah ding ahi) Pasal Kum somni'a pat chunglamsea konna ki dong sangjagup le sangthum le janga le somnga alhing'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Muntheng chung khunading, chule atunna ho aboncha'n sana le dangka sangsagi le janga alhing in atunna khat cheh chu dangka somsagi a ki sem ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Amoh cheng sang le dangka somli le nga chengse chu akhom ahin, akhaina nadinga kisem akol chengse tomnan amangin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Chule mipi chun sum-eng a kisem dangka sangnga le jathum le somkhat ahin choijun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Hichengse chu akhomho chule houbuh semnan amang'in maicham achun sum-eng apansah'in chule sum-eng chu thil ijakai semnan jong amang'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Sum-eng mangchan palkikai jouse, kelkot chule houbuh sung'a thil ijakai jouse semnan aneiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Muntheng'a natong ding hon aman chah diu'vin asan-dup chule asanpol bang'a kikhong pon akikhuiyu'vin—Aaron'in muntheng'a na-atoh teng akivkonna ding hichu Pakaiyin Mose heng'a athupeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bezalel chun sana mangcha'n konggah asem'in hichu asandup le asan-ao patnem jaonan asem'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Aman sana khat lim'in hoisel in khut them tah in asem'in ahi. Hichu asandup, asan-ao patdum mangcha'n sehcha'n akheng tuoh'in asemdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Chule konggah akon chun akhaina ding anung le ama lam'a aumtuo'n lengkou chan gei jin akhailhah'na aum'in among lam chu akijopmat'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Hiche jong hi a ngaija bangin hoisel'in asem'in: phatah a ki pheh, adum, asan-dup, asan-ao sana jeng'a ki tom ponnem mangcha'a kisem, hichu Pakaiyin Mose heng'a athupeh dungjuiya kisem ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Chule Onyx song chu-ni amang chau'vin chuin sana alhon'in agol tuoh sohkeiyun ahi. Song-ho chu Israel mite ama ama insung dungjui cheh in amin'u mohor kinam khum bangin agol tuoh sohkei u've. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Aman hiche song-agol chule kong-gah lengkou vumma ki khailha akon chun, Israel mite geldoh jing na dingin asem tuoh sohkeijin. Hichengse jong hi Pakaiyin Mose a thupeh banginabol sohkei u've. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bezalel chun khutthem tah in Ompho asem'in ahi. Aman konggah bang bang chun asemdoh'in hichu sana ahin, adum chule asan-dup ponnem jaonan asem'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Aman ompho chu lheptup theiyin asemdoh'in akilhep teng adung avai khutchang ko ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ama hon song-mantam chu golli'n akoi jun. Amasan Carnelian song-san apansah'uvin, pale-green, chule emerald song ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Golni channa dingin blue lapis lazuli, chule songgil ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Gol-thum channa dingin aiha song, khipi chule umbel song ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Gol-li channa dingin song-eng, Onyx song chule song-mantam-eng apansah'uve. Hi chengse hi abonchan sana twiyin akaimatsohkeiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Song-gol khat cheh chun Israel mite ama-ama kailhah dungjuijin amin jouse toh akijih tha'n songkhat cheh achu Mohor kisem ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ompho le konggah kijopmatna ding chun sana thengsel la kisem khao bangin akhuiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Chule sana pat-jaang'a kisem le sana akol-ni jong asem uvin sana-kol teni chu ompho ning lama chun akaimat'uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ompho tenia kikhai sana kol teni chu akhaimat'uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Chule sana-pat-jaang teni le sana golteni chu a jopmat uvin ahi. Konggah khaina leng-kou tenia kon chun agen kikhailha tenichu ompho maiya chun abehpeh peh'uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Chuin ama hon sana kol-ni asemkit'vin, ompho geilam hichu konggah toh chun akaimat uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Chule sana-pat-jang kolni a semdoh kit uvin ani tah chun lengkou vumma konggah ki khaina achun akaimat uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Chuin ompho chu pat-jaang khat mangcha'n akolsung'a chun athilmat'uvin konggah'a beh akol chengse toh athilmat uvin ahile phatah a kipheh bangin aumdoh tan ahi. Hitia abol phat uchun konggah le ompho chu achah kheh jeng tan ahi. Hichengse chu Pakaiyin Mose athupeh bangin abol sohkei uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Bezalel chun adum'a kikhong kivkonna dingin sang-khol asem'in ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Hichu Aaron'in aki-ah ding chule hiche songkhol chol chu agei gol akhui-eh cheh cheh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ama hon sangkhol-chol chu kolbu thei jem'in asem uvin patdum, asan-ao chule ponnem mangcha'n asemdoh'uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Chuin ama hon sana thengsel'in chaojang asem'uvin hichengse chu abonchan kolbuthei jem le sangkhol golla chun akoiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Chao jang khat khaina achun kolbu theijem khat in akiba cheh-cheh in ahi. Hiche sangkhol-chol thempu khat chun na-atoh teng hoilai mun hijongleh Pakaiyin Mose athupeh bang'a kivon ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Ama hon Aaron le achapate ho jouse dingin sangkhol chol len tupat jengin asem peh'uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Delkop chule lukhuh ding jong jaonan toka-chol jong poun phatah in asem'uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Kigah-ding jouse chu pon-nem asan-dup, san-ao phatah a heo jang'a kisem jeng, hichu Pakaiyin Mose athupeh bang'a kibol ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Achaina'n lal lukhuh sana thengsel in a sem uvin ahi. Mohor kinam den banginaum khum uvin: Pakai atheng e ti thucheng akoi un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ama hon lukhuh chu adum khat Aaron delkop dingin asem'uvin, hichu Pakaiyin Mose athupeh bang'a abol ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Hiti chun ajona lam in kikhop khomna hou buh* chu sahchaiyin aumtai. Pakaiyin Mose athupeh bangin Israel mite'n jong atong chai sohkeiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Chuin ama hon Mose heng'a houbuh chule thil-le-lo ijakai abonchan ahin choijun: akhaina-kolho, agolho, akhomho, akhom noi nung'a ho hiti chun abonchan ahin choi sohkeiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Ponbuh khuna ding chun kelngoi chule kel chal-vun; hichengsea chu khuding ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Hettoh sahna thingkong; thingkong putna dinga moljol teni; chule hepi touna jaona, ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","Dokhang le thilkeo ho; chule changlhah thilto chengse jaona ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Sana thengsel'a ki semdoh thaomei-khom chule thaomei-khon chengse jaona, amanchah chengse le athaotwi jong jaona ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Sana'a kisem maicham, chule kinu ding thaotwi; gimnamtui jaona le pondal jouse jong ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","sum-eng'a kisem maicham; chule aputna dinga sum-eng jolho jaonan; kisilna kong le atunna jouse jong ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Bangpheija kigol pondal ho; pal khom chengse ahin; chule houbuh lutna lam; houbuh'a kimang thil-le-lo jouse jaona ahi; ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Thempu hodinga hoitah a kikhui hichu muntheng laiya na-atoh teng ule akivon nadiu Aaron thempu, chule achapate hon thempu kin abol teng ule akivon nadiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Pakaiyin Mose heng'a athupeh bang chun Israel mite'n jong abonchan ajuikimsohkeiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Chuin Mose'n anatoh jouseao abonchan avelhan ahi. Ama hon toh ding ijakai Pakai thupeh bangin atong kimsohkeiyuve ti amuchet phat chun, phatthei aboh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Pakaiyin Mose heng'a aseijin, ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Kum-thah nikho masa pennia houbuh natundoh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","“Chule houbuh sung'a chu hettohsahna thingkong na koi ding, hiche thing-kong chu muntheng chungnung mun ahin, hichu pondal na khu ding ahi” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","“Dokhang hinpu'n lang, manchah thil-le-lo ho jong jaonan, chule thaomei khom ahin thaomei vah chengse jong na hinchoi ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","“Hettohsahna thingkong maija chu gimnamtui lhut'na maicham nakoi ding ahi. Chuteng houbuh kotphung'a chu nakhai ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Kikhop khomna ponbuh lutna maiya chu hiche pumgo thilto maicham chu nasem ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","“Kikhop khomna ponbuh le pumgo thilto maicham kimlai dkonna chu kisil-na kong nakoi ding, adimset'a twi nadip ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","“Chule ponbuh kimvel jousea pal kaiyin lang, kelkot lut'na chu pondal nakhai cheh cheh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Kinu thei thao chu choiyin lang houbuh sung'a thil-le-lo ijakai nanu sohkei ding, aboncha atheng dinga nathenso ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","“Chule pumgo thilto maicham ahin athilkeo jouse jaona thao nanu ding, atheng dinga thensona nanei ding ahi. Chuteng hiche maicham chu atheng chungnung'a pang ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","“Chu jou teng, kisilna-kong le atunna ho aboncha thao nanu ding, thensona naneipeh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Aaron le achapate chengse kikhop-khomna ponbuh sung lam'a hinpuijin lang, kong'a kilui twiya chu nasil diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","“Aaron chu thao nanu ding chule ponsil theng pen'na navon ding, ajeh chu keima kinbol thempu a pang diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","“Chule achapate chengse jong hinpuijin lang abonchaova sangkhol-chol na-ah peh ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","“Apau Aaron thao nanu bang chun, amaho chengse jong thao nanu sohkei ding ahi. Ajeh chu abonchauva keima kinbol thempua pang diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Pakaiyin athupeh bang chun Mose'n jong atong kimsohkei tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kumkit-kum thah lha masa nikho ma sapen'in houbuh chu atung doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mose'n hichengse jaonan houbuh chu ana-tung doh tan ahi; akhom ho, amoljol ho, pal khom ho abonchan atong kimsohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Chuin aman houbuh chung lam'a pon akhu'n Pakai thupeh bangin abol'in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Aman hettohsahna song-pheng chengse chu alan tingkong sung lam'a chu akoiyin ahi. Chuin aman thingkong chungvum'a chun moljol chu akoilut'in thingkong chungvum'a chun hepi touna akoiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Aman thingkong chu houbuh lailung'a ahin pu'n pondal kikhu chu ahohdoh paijin, Pakaiyin athupeh bang chun abol in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Chuban in Mose'n houbuh sung lam'a chun dokhang akoiyin, polam pondal kilan'na achun akoiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Chule aman dokhang chung'a chun Pakai angsung'a dingin changlhah akoiyin ahi. Hichu Pakai thupeh bang'a abol ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Aman houbuh lhang lam dokhang chule muntheng laiya chu thaomei atung doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Chuin aman thaomei chu atung doh tan, Pakaiyin athupeh bang'a abol ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Aman ponbuh sung lam'a chun sana gimnamtui chu aluoi doh'in hichu pondal maiya muntheng chungnung chu ahi. Achung'a chun sana gimnamtui chu ahal'in ahi. Ajeh chu Pakaiyin athupeh bang'a abol ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Aman houbuh kotphung maija chun ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Chule aman houbuh lut-na kotbul'a chun pumgo thilto maichan chu akoiyin ahi. Achung'a chun pumgo thilto atodoh'in ahi. Ajeh chu Pakaiyin athupeh bang'a abol ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Chu ban in Mose'n houbuh le maicham kimlaija chun kisilna-kong chu akoiyin ahi. Aman kong dimset chun twi adip tan, ajeh chu thempu kinbol'a pang hon kisilna'a amanchah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mose chule Aaron le achapate'n kong- sung'a twi chu kisilna'a aman chah diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Houbuh maicham lam ahinjut lut teng ule, kisil ngimna'a aman jing ding'u ahi. Ajeh chu Pakaiyin Mose heng'a athupeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Chuin aman houbuh le maicham kimvel chengsea chun pondal akhaiyin ahi. Chule kelkot lam'a jong pondal akhaijin ahi. Ajonan Mose'n natoh ijakai atong kimsohkeijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Meibol'in ponbuh chu akhu jeng tan ahile, Pakai loupina chu kikhop khom'na ponbuh adim lha jeng tai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mose chu houbuh sung lam'a chun alut thei tapon akiting den tai, ajeh chu meibol lom chu kiheh jeng ahitan, chule Pakai loupi na chun houbuh chu atomlhah jeng ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Tun meibol jong chu houbuh akon'in ahung kitol tan ahile, Israel mite jeng jong meibol chie dungjuijin akitol tha jitauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Amavang meibol aum den laisen, amaho jong aumden jitauve. ");
INSERT INTO tczchongthu_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Pakaiya konna meibol chun nilhum kei jin houbuh chu atomlha jeng tan, janteng mei-kong in akilah'jin ahile Israel mite'n amittah'uvin amuthei jun ahi. Hiche hin a kholjin na chan uva ahin jui peh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Pakaiyin Mose chu houbuh a kon'in akouvin, ajah a hiti hin aseipeh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Hiche thupeh chengse hi Israel te hengah seipeh in. Nang hon Pathen henga pumgo thilto nabol tengu leh, bong hon ahilouleh kelcha hon chule kelngoi hon lah a konna nato jeng thei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Nangman gancha nato ding chu pumgo thilto ding gancha akul sunga pat hi ding, nolna bei thilto hi ding hichu Pathen'in asan theina dinga houbuh kotphunga todoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Hiche gancha pumgo thilto chu aluchunga nakhut ngamlhan, chuteng kithoidam nadia hiche thilto chu Pakai adia santhei dol hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","“Chutengleh Pakai Pathen ma sanga bongchal nou natha ding chule Aaron chapate leh thempu hon gancha thisan chu houbuh maiya maicham akimvel jousea athe khum diu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Chutengleh gancha chu avun nalip ding abong bonga nasat chen ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Hitia chu Aaron chapate thempu hon maicham chunga mei atikong diu, meikong chunga chu thing alom loma akoi diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ama hon maicham kitonaa sa kisem ho chu, aluchang leh athao ho chu maicham chung meikou lah achu aban bana akoi diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Amavang sasung jouse leh akeng ho jouse amasa pena twiya sop lhah ngimsel ding, hiche teng chule thempu pan pumgo thilto maicham chung meiya ahal vam ding, hichu Pakai, Pathen adia namtui tah thilto hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Nangman pumgo thilto dinga gancha hon lah akon napeh teng, kelngoi ahilouleh kelcha hithei ahi; amavang hichu achal hitei ding chule nolna beihel hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Chuteng gancha chu maicham chunglama natha ding, Pakai angsunga Aaron thempu leh achapate hon, gancha thisan chu maicham phung anigli chunga achap kimvel soh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Hiche teng chule thempu pan gancha maicham chu atum tum, alhang lhang nga asat khen ding, aluchang, alap leh athao jouse pumgo thilto maicham mei kong nga ahalvam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Ahinla sasung jouse chule akeng jouse chu amasa tah’a twiya asop theng ding ahi. Hiche teng chule thempu pan pumgo maicham pumpia maicham phung meiya ahal vam soh ding, hichu thilmanlutah kipe, Pakaiya dia gimnamtui kihal vam ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Nangman Pakaiya pumgo maicham’a vacha napeh le, nalhen kah ding vakhu ahilou le vapal napeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Hiche teng chule thempu pan vapal leh vakhu ham chu maicham phunga akoi ding, chuteng aluchang chu maicham phung chunga atan lhah ding, thempupan amasa pena hiche thisan jouse chu maicham aning gol jousea achap khum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Chule thempu pan achang-oi le amul jouse apaimang ding, niso lam maicham phung meivam lah’a ase lhah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Chuteng thempu pan vapal lha ving tenia amat a abojal ding; asat tel louhel ding chule maicham chunga meiya ahal vam ding, hichu pumgo maicham, gimnamtui Pakai adia kikatdoh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Nangman lhosohga Pathen maichama napeh tengleh, hiche lhosohga changbong neldisel chu nalhen doh ding, hiche changbong chunga chu Olive thao nasunkhuma, Bego toh nachap khum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","Hichu Aaron chapate, Thempu ho kom'a nahin choi ding, Thempu ho chun changbong thaotwi toh kihalsa chu, khut a sip-kham khat ahamdoh ding, Bego namthei toh kihalsa changbong ho chengse chu maicham phunga ahal diu ahi. Hichu Pakaiya dia thilpeh pha leh gimnamtui tah hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Gasoh maicham amoh chengse chu Aaron leh achapate jouse na hoppeh ding, hiche maicham thilpeh hi Pakai adia thilpeh athengpen leh aman lupen hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Na lhosohga thilto changlhah chu lhummeiya kisang minsa ahileh changlhah chu thao thengsel'a kikeng hi ding, chol kiso lou hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Na lhosohga maicham chu khangbela naken min ahijongleh changbong lah’a anel pen hi ding, chule Olive thao naloi ding, hijong chu chol jao lou hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Hiche changbong hose chu, atum tum in homkhen inlang chuteng Olive thao toh nuhel in, hichu lhosohga maicham ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Nangman lhosohga maicham anbela nahon teng, hiche changbong chu anelpen leh Olive thao ahoi pen toh kihel hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Ipi lhosohga maicham hijongleh, iti kisem hijongleh thempupa kom'a hinpuiyun amapa chun maichama atodoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Thempupa chun lhosohga maicham atodoh chu, maicham chunga agovam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Hiche lhosohga maicham amoh chengse chu Aaron le achapate kipe ding ama hon anneh chohnaa anei diu, hiche maicham chu atheng pen, ahoipen leh lunglhaina dimset Pakaiya dia kikatdoh hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Nang hon lhosohga maicham nabol tengu leh chol kisolou changlhah jeng hi ding, Pathen henga na pehdoh jouseu chu khoiju leh chol jaona ho chu maicham phunga na halvam thei louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Theichang gathah ho jouse jong, Pakai angsunga thilto dia nahin choi thei ahinai, hinlah hiche ho vang chu maicham phunga ki gouvam thei louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Na lousohga maicham todoh ding jouse chu chi-al toh na haltha cheh ding ahi. Hichu Pathen tonsot a dia na kiteppi nau na geldoh jing nau hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Na lousohga amasa pen maicham nasem tengleh, changvui lah a ahinhoi apumchep ho chu meiya na hulgot a, Pakaiya dia nahin todoh thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Na anchang ho chu Olive thao sunkhum inlang Bego namthei toh hal in. ");
INSERT INTO tczchongthu_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Thempu pan lousohga phasah khat chu alah a Olive thao asunkhuma, Bego toh ahal ding, chuteng Pathen adia thilto loupi hi ding meiya ahal vam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Nangman gancha akul apat maicham nasem teng, achal hihen anu hijongleh nato thei ding, amavang nolna bei hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Gancha luchunga chun nakhut ngam inlang, chule Houbuh lutna a chun that in. Chutengleh Aaron chapate, thempu ho chun, thisan chu maicham ning jousea chu athe khum diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Thempu pa chun chamna thilto phabep chu Pakaiya dinga thilpeh lutah a apeh dingu ahi. Hichea hi athao jouse le asung ho jouse ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Akongbuh toh kinaiya um akal teni le akimvela beh athao chengse, chule athin chunga beh athao jouse jong jaoding ahi. Hichengse hi akal toh kiladoh khoma, ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Chule Aaron chapaten hichengse chu pumgo thilto dinga maicham chunga meikonga chu ahal vam diu ahi. Hichu Pakaiya dinga lunglhai um gimnam tuitah, thilpeh lupen hi ding ahi ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Nangman gancha kul sunga konna gancha chu Pakaiya chamna thilto a naton ding tengleh, hichu achal ahilou le anu hi ding, amavang nolnabei hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Nangman nato ding thilto chu kelngoi ahile, Pakai henga nahin kailut na, ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","aluchunga nakhut nangapma, chule Houbuh maiya chu natha ding ahi. Chutengleh Aaron chapaten kelngoi thisan chu maicham ning jousea chu athekhum sohkei dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Thempupa chun hiche chamna thilto a athao jouse chu Pakaiya dinga thilpeh lutah a apeh ding ahi. Hiche lah a chu atingpigu amei kitanlhah na geiya beh athao ho, agila beh athao jouse, ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","akongbuh toh kinaiya um akal teni le akimvela beh athao chengse, chule athin chunga beh athao jouse jong jaoding ahi. Hichengse hi akal toh kiladoh khoma, ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Chule Thempu pan hichengse hi maicham chunga ahal vam ding ahi. Hichu Pakai anneh dinga kipe thilpeh lutah hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Nangman nato ding thilto chu kelcha ahile, Pakai henga nahin kailut na, ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","aluchunga nakhut nangapma, chule Houbuh maiya chu natha ding ahi. Chutengleh Aaron chapaten kelcha thisan chu maicham ning jousea chu athekhum sohkei dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Thempu pan hiche thilto lah a konna phabeh khat chu Pakaiya dinga thilpeh lutah a apeh ding ahi. Hiche ho lah a chu sunga um athao jouse, ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","akongbuh toh kinaiya um akal teni le akimvela beh athao chengse, chule athin chunga beh athao jouse jaoding ahi. Hichengse hi akal teni toh kiladoh khoma, ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","chule thempu pan maicham chunga ahalvam ding ahi. Hichu Pakai anneh dinga kipe thilpeh lutah, lunglhai um gimnamtui tah ahi. Athao jouse chu Pakaiya ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Nangman athao hihen athisan hileh naneh louhel ding ahi. Hiche hi nanga dinga aum jing ding dathupeh ahin, chule hoilai mun'a cheng jong leuchun, akhang khanga nanit jing jeng dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Chuin Pakaiyin Mose henga hitin aseiye, ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Israel te henga anoiya hilchahna chengse hi seipeh tan. Koitobang hetlouva chonset bola Pakai danthu ho lah a khat pen pen palkeh aum khah a ahileh hitia hi nabol dingu ahi ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Thempu Chungnung chun chonset abola ahile, mipi jouse chunga chonset ahin pohlut ahin, hijeh a chu aman hitobang chonset jeh a chu chonset thilto atoding ahi. Hichea chu aman Pakaiya dinga nolnabei bongchalgol khat atoding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Aman Houbuh maiya Pakai kom'a chu bonchalgol chu ahin kailutna, aluchunga akhut angapma, chule Pakai angsunga chu atha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Chutengleh Thempu Chungnung chun bongchalgol thisan chu themkhat alah a, Houbuh sunga chu lutding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Akhutjung chu thisan lah a adelutna, chule muntheng chungnung kidaltan na pondal mai Pakai angsunga chu sagi vei athinkhum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Chutengleh thempupa chun Houbuh sunga Pakai angsunga kitung gimnamtui halna maicham chunga saki hoa chu thisan phabep cheh asunlut ding ahi. Bongchalgol thisan adangse vang chu Houbuh maiya pumgo thilto kitona maicham bula chu asunlhah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Chujongleh thempupa chun bongchalgol chu athao jouse chonset thilto a todinga alahdoh sohkeiding ahi. Hiche sathao lah a chu agila beh athao jouse, ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","akongbuh toh kinaiya um akal teni le akimvela beh athao chengse, chule athina beh athao jouse jaoding ahi. Hiche ho jouse hi akal teni toh alahdoh tha ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","chamna thilto a kitoh kelngoi chunga abol banga abola, chule pumgo thilto maicham chunga ahalvam sohkeiding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ahin bongchalgol vun, asa, alu, akengho, asung, chule a-eh amoh jouse chu alah a ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","chule ngahmun polama vutvam ho kisunlhah na a kimang ngai jing muntheng lai khat na apohdoh ding ahi. Hiche vutbou chunga chu thing ati-a agovam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Israel nampi chun Pakai dan thupeh holah a khat apelkeh a achonset uva, ahivanga ama hon achonsetlam akihetdoh hih'u jong le, amaho chu chose hithou thou dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Itih hijongleh achonset nau ahin kihetdoh tengule, ama hon bongchalgol khat chonset thilto dinga ahin to uva chule Houbuh maiya chu ahin kailut dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","A-upahouchun bongchalgol luchunga chu akhut angap uva Pakai angsunga chu atha dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Chutengleh Thempu Chungnung chun bongchalgol thisan chu phabep khat alah a Houbuh sunga chu achoilut ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","akhut jung chu thisan lah a chu aphum lut a, chule muntheng chungnung kidaltan na pondal mai Pakai angsunga chu sagi vei athinkhum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Chutengleh thempupa chun Houbuh sunga Pakai angsunga kitung gimnamtui halna maicham chunga saki ho a chu thisan phabep cheh asunlut ding ahi. Bongchalgol thisan adangse vang chu Houbuh maiya pumgo thilto kitona maicham bula chu asunlhah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Chutengleh Thempupa chun sathao jouse chu alahdoh sohkei ding, chule maicham chunga chu ahal vam ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Thempu chungnunga dinga kitoh chonset thilto bongchal kibolna bang banga abol ding ahi. Hitobanga hi, thempupa chun mipi chu asuh thenga, Pakai toh asuhcham ding, chutengleh achonset nau ngaidama um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Chutengleh thempu pan bongchal amoh chengse chu ngahmun polama achoidoh a ahalvam ding, Thempu Chungnunga dinga chonset thilto tobanga chu abol ding ahi. Hiche hi Israel mipi jousea dinga chonset thilto ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Koi hijongleh Israel mite lah’a alamkai khat pen chun Pakai a Pathen thupeh apelkeh a achonset khah a ahivanga achonsetna kigeldoh lou aum khah ahile, amapa chu chonse hithou thou ding ahi . ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Amapa chun achonsetna ahin kigel doh ni nileh, chonset thilto a dinga nolnabei kelchal khat ahin kailut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Chutengleh akhut chu kelchal luchanga angap a chule pumgo thilto a kitoh gancha ho kithana Pakai angsunga chu atha ding ahi. Hichu chonset thilto ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Chutengleh thempu pan chonset thilto gan thisan lah achu akhut jung aphumlut ding, chule pumgo thlto dinga maicham chunga saki ho a chu asunlut ding ahi. Adangse vang chu maicham bula chu asunlhah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Chutengleh kelchal thao jouse chu maicham chunga ahal vam ding, chamna thilto tobanga abol ding ahi. Hitobanga hi, thempupan lamkaipa chu achonsetna a konna asuh thenga, Pakai toh asuhdih ding, chutengleh achonsetna kingaidam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Koitobang milhamho lah a Pakai thupeh pelkeh a chonset bola, ahivanga abollam helou ho jong chu chonse hithou thou dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Achonsetnau ahin geldoh ni niuleh, achonset nau thilto dinga nolnabei kelpi khat ahin kai dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Chonset thilto luchunga chu khut angap uva, pumgo thilto a kitoh gancha ho kithana mun'a chu atha dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Chutengleh thempu pan akhutjung gan thisen lah achu aphumlut a pumgo thilto dinga maicham chunga saki ho a chu asunlut ding ahi. Thisan amoh chengse vang chu maicham bula asun lhah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Chutengleh kelpi thao jouse chu alah doh ding, chamna thilto a kitoh sathao kibolna banga abol ding ahi. Sathao chu maicham chunga ahal vam ding, chule hichu Pakaiya dinga lunglhai um namtui tah hi ding ahi. Hitobanga hi, thempupa chun mipi chu asuh thenga Pakai toh asuhdih ding, Chutengleh achonset nau ngaidama um dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Mipi chun chonset thilto dinga kelngoi ahin kai uva ahile, hichu nolnabei anu hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Chonset thilto chunga chu akhut angap uva chule pumgo thilto a kitoh gancha ho kithana mun'a chu atha dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Chutengleh thempupan akhutjung chu chonset thilto gan thisan lah a chu aphumlut a pumgo thilto dinga maicham chunga saki ho a chu asunlut ding ahi. Thisan amoh chengse vang chu maicham bula asun lhah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Chutengleh kelngoi thao jouse chu alah doh ding, chamna thilto a kitoh kelngoi thao kibolna bang banga abol ding ahi. Pakaiya dinga thilpeh lutah kipehna chunga sathao chu maicham chunga ahal vam ding ahi. Hitobanga hi, thempupan mipi chonsetna a konna asuh thenga, Pakai toh asuhdih ding, chutengleh amaho chu ngaidama um dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Nanghon thil khat namu'u leh nahet'u chung changa hettohsah dinga nakikou tengule, hitobang hettohsah louva um chu chu chonset ahin, chule na chonset jeh a chu gotna nachan ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ahilouleh nangman sathenglou sathisa hamkhat chu hetlouva natoh khah a ahileh hichu chona dola thenglou ahi. Hitobanga nathilbol chu nahet doh tengleh nangman nakisuhboh na le na chonsetna chu na phondoh ding ahi. Hitobang sathisa chu gamsa hihen, insa hihen, ahilou le tolla vah ho hijongleh aboncha chunga nabol sohkei dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","“Ahilou jongleh nangman hetlouvin mihem suhboh thei thil khat natongkha tai. Hiche nathil tohkhah chu nahet doh ni nileh, nangman na chonsetna chu na phondoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","“Ahilouleh nangman aphatna ding hihen asetna ding hijongleh ngol-hoitah in nakihahsel tan ahi. Hichu ngol-hoitah ahi ti nageldoh tengleh, na chonsetna chu na phondoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Hitobang chonsetna ho hi khat pen pen hijongleh nahin geldoh ni nileh, na chonsetna na phondoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Chutengleh chonset themona jeh a nangman gancha kul sunga konna kelngoi hihen kelcha hijongleh anu khat Pakai henga nahin kai ding ahi. Hiche hi chonset thilto hi ding thempupan nangma chonsetna a konna nasuhtheng na le Pakai toh nasuh dih na hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Ahinlah nangman kelngoi nahin kaijou hih jongleh, chonset themmona jeh a thilto dinga vakhu ni ahilouleh vapal ni nahin choi ding ahi. Vahcha khat chu chonset thilto ding ahin chule khat chu pumgo thilto hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Hichengse chu thempupa henga nahin choi ding, aman vacha khat pen chu chonset themmona thilto a ato ding ahi. Vacha ngong chang chu ahechip a, ahivanga aluchang chu atahsa toh akikhen sah louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Chuteng chonset thilto gan thisan phabep chu maicham ning ho a chu athekhum ding, chule thisan amoh chengse chu maicham bula chu alonlhah sah ding ahi. Hichu chonset thilto hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Hitia chu thempu pan vacha ani chana pa chu pumgo thilto adia asem ding, akibolding dan kisei tobang chetna abol ding ahi. Hitobanga hi thempupa chun na chonsetna a konna nasuhthenga, Pakai toh nasuhdih a, chtengleh ngaidama naum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Vakhu ni le vapal ni nahin choi jou louva ahileh, na chonset thilto dinga chu changbong ephah dimni nahin choi thei ahi. Hiche hi chonset thilto ahijeh chun, olive thao toh nahelkhom louding, thil namtui jong nalhah lut louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Changbong chu thempupa kom'a nahin choiding, chutengleh aman changbong lah a konna chu khut dimkhat asodoh hing ahi. Pakaiya dinga thilpeh lutah napeh na bana hiche changbong chu Maicham chunga ahalvam ding ahi. Hichu chonset thilto ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Hitobanga hi chonset jeh a themona neiho chu thempu pan asuhtheng a, Pakai anga asuhdih ding, chule achonset nau ngaidama um ding ahi. Changbong amoh chengse chu lhosohga thilto kibolna banga, thempupa chang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Chuin Pakaiyin Mose henga aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“nalah uva khat touvin hettohlou jeh a Pakai thilthengho asuhboh a chonsetna naneikhah uva ahile, Pakai henga chonset thilto nahin choi ding ahi. Chonset thilto ding chu nangma a mong mong kelngoichal nolna bei hi ding, ahilou le aman kibahpi khat dangka a nachoh ding, hichu muntheng phunga thiltena a kitetoh dungjuiya hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Thiltheng nasuhset ho chu aman napeh a nasem phat kitding kit ding, chule adang soma ni jong napehtha ding ahi. Thempupa kom'a napeh tengleh, aman kilhaina kelngoichal toh chun chonset thilto a ato a nasuhtheng ding, Pakai toh nasuhdih a, chule ngaidama naum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“vetsahnan Pakai thupeh ho lah a khat napelkeh in na chonsetai. Nangman nabolkhel chu nahetlouva nabol hijongleh chonse nahithou thou ding chule na chonset jeh a chu bolgima naum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Hitobang chonset thilto dinga chu, thempupa henga nangma kelngoichal nolnabei khat nahin kailut ding, ahilou le aman kibahpi khat nachoh a nahin kailut ding ahi. Hitobanga hi thempupan hetlouva nabolkhah chonsetna ho a konna nasuhtheng ding, Pakai toh nasuhdih a, chule ngaidama naum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Hiche hi chonset thilto hi ding ahi, ajeh chu Pakai douna a chonse nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Chuin Pakaiyin Mose henga aseiye, ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Vetsahnan mikhat touvin akivoppi khat dounan chonset abolin, chule Pakai henga kitah louvin aumin ahi. Ahilouleh vetsahna dangkhat mikhat in sum nakoisah chu najoubolin, nagumang in, nachompeh tai, ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ahilouleh thilkeu mangkhat namun chule najou naseiyin, thutah seina a nakihahsel in jou naseiyin, ahilouleh hitobang chonsetna dangkhat naboldoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Hitobang chonsetna ho hi khatpen pen nabolkhah a ahileh, nangma chonse nahitai. Naguhmang jouse chu na lepeh ding, achamlouva nalahpeh sum hihen lang, min nakoisah naguhmangho hijongleh, ahilouleh thilmang namuho hihen lang, ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","jouthu a nakihahsel a nalamdoh jouse hijongleh aboncha a na lepeh ding ahi. Nalahpeh ho jouse kom'a lhingsetna na lepeh ding lhingsetna na lepeh ding akelvala jong soma ni napeh tha ding ahi. Napehdoh nikho lechun chonset thilto jong napeh tha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Chonset thilto dinga chu, nangma a mong mong kelngoichal nolnabei khat nahin kaiding, nangma a aumlou leh aman kibahpi khat nachoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Hitobanga hi thempupan Pakai angsunga nasuhtheng ding, ama toh nasuhdih, chule hitobang chonsetna jousea konna ngaidama naum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Chuin Pakaiyin Mose henga aseiye, ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Aaron le achapate henga pumgo thilto chung changa hilchahna hi seipeh tan. pumgo thilto chu ajing jingkah chan'a maicham chunga nadalhah den ding, chule maicham mei jong chu jankhovah keiya nakousah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","jingkah tengleh, thempupan atupatpon von chu ahin kivona chule tupat pon vonsungnung chu ahin kivon jouteng chuleh, pumgo thilto kihal vamna vut ho chu ahin suhtheng ding, chule maicham ning langa akoi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Chujoutengleh avonho chu asutlhah ding, avon ngaiya kivon kit ding, chule vutvam ho chu ngahmun polama munthenglai khatna apohdoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Hiche phat sunga chu maichama mei chu kou jing ding; mitsah louhel ding ahi. Jingkah sehle thempupa'n meilah a chu thing ahetbe jing ding chuleh pumgo thilto a dinga agontup jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Maicham chunga mei chu phat jousea kou jing jeng ding, ding, mit louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Hichu lhosohga thilto maicham ahin, chule Aaron chapate jousen thilto ding chu Maicham Pakai angsunga ahin tocheh diu; ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Amaho jouse lah a mikhat pen chun athilto lah’a konna lhosoh changbong neldi khut dim khat aham doh ding, lhosoh thilto toh kihel thaotwi leh gimnamtui puma alah a, hichu mangtheilou maicham chunga chu agovam soh hel ding, Pakaiya dia gimnamtui soh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Chule amoh chengse chu Aaron le achapate sesen aneh diu ahi. Aneh tengu leh cholsolou hi ding, hichu muntheng lai khat a aganeh diu ahi; aneh nadiu mun chu kikhop khomna ponbuh sunga chu aneh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Chule changlhah neh dia akiken tengu leh, cholsolou hi ding; hichu keiman pumgo maicham ka chan ka hoppeh ahin, chonset maicham le themmona chungnung ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Pathen akonna pumgo thilto thudol'a nakhang lhung uva dia thu katep peh na hiuvin, hichu Aaron chate lah a pasal jousen aneh diu ahi, hiche maicham thilto hi koi hile atongkha chan theng jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Mose henga Pakaiyin hiti hin aseijin, ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Aaron le achapate hon thempu pan mun dia thao akinu nikho tengu leh, Pakai henga athilto diu chu hiche hi ding ahi; lhosohga thilto dia changbong nelsel ephah dimkhat hopsom lah a hop khat hi ding, akeh khat chu jingkah maichama atoding chule akeh langkhat ma chu nilhah lang maichama ato ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Changbong nel chu khangbel sunga thaotwi toh kichoh hel ding, chuteng nangman dip a kihelsa chu maicham thilto dang ho banga apheng phenga nakoi tup ding; hichu Pakaiya dia gimnamtui dinga nahin choi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Chule Aaron chapate ho lah a, ama khela thempu dia thaonu chang pa chun, hiche maicham thilto chu a-itih chana dia Pakai heng lama ato ding, hiche ho jouse chu govam hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Thempu koi hileh lhosohga maicham thilto ato doh jouse, aboncha agovam hel ding, hichu koima chan anehthei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Chuin Mose henga Pakaiyin hitin aseipehin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","Aaron le achapate henga hiti hin sepeh in, hiche hi chonset jeh’a maicham thilto dinga dan ahin; hichu pumgo thilto gancha kitthana mun Pakai angsunga chonset maicham thilto ding gancha jong tha ding, ajeh chu hiche hi maicham thilto lah a atheng chungnung ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Chonset jal'a maicham thilto toh doh a thempu pan asa chu aneh ding, hichu kikhop khomna ponbuh muntheng lailung khat a aneh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Chule itobang thil hijongleh hiche maicham thilto sa gatong kha chan athenga um jing ding, athisan hijongleh apon chunga anat khah a ahileh, hiche thisan natna ponsil chu nangman muntheng lailunga nasop ngim ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Chule sa hkonna bel jeng jong kivo keh ding, sum eng bela mangchaa kihon ahileh, suhtheng sela twiya phumlut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Hiche maicham thilto sa chu, thempu ho jouse lah a pasal kiti phot in aneh diu, hichu atheng chungnung ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Ahinlah muntheng mun'a kithoidamna dinga thisan puma kipolut sa, kikhopkhomna ponbuh sunga kilhut chonset themmo thiltoa kithat sa chu koiman anehthei louhel ding, asa chu apumpia meiya govam hel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Themmo jeh a maicham thilto ding chu hiche hi ahi, hichu atheng chungnung hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","“Pumgo thilto maicham phunga gancha kithana mun'a chu, hiche themmona thilto chu kithat ding chule gan thisan chu maicham ning gol jousea chapkhum ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Hitia chu thempu pan athao jouse aboncha maichama atodoh ding, amei tobuh thao, asung thao alap jouse toh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","Ataijung lah a akal teni leh akala athao um chengse, athin leh akal teni jaonaa aphe le athao jouse aboncha alah doh cheh cheh ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Chutengleh thempu pan pumgo thilto ding a Pakai heng lam, maichan chunga agovam hel ding ahi, ajeh chu themmo maicham thilto ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Hitobang maicham thilto chu thempu ho lah a pasal kiti phot in anehthei ding, ahin muntheng sung lai khat a aneh ding dol ahi, hichu atheng lah a atheng chungnung khat ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Themmona maicham thilto le chonset thilto hi akikhehna umbeh lou ahin, anitah a dan khat a um chu ahi, chutia chu athoiya pang thempupa chun ki thoi damna maicham thilto chu akilah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Pumgo maicham thilto a pang jouse sanpeh a toh doh a pang thempu pan hitobang maicham thil to savun chengse chu akilah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Chule lhosohga maicham thilto, meilhum sunga kigousa, khang bela kihon sa le ki kang sa jouse chu aboncha hiche thempupa chun akilah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Hitia chu lhosohga maicham thilto thaotwi kichap kotsa hihen, akichap kot lou hijongleh, aboncha Aaron chapate chang diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ajeh chu hiche maicham thilto hi, koi hileh Pathen henga chamna maicham kilhaina ganthaa hitia hi chepi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Maicham thiltoh pan thangvahna dia ato doh ding ahileh, hitobang thangvah maicham thilto ding chu changlhah thaotwi kichap khumsa changlhah pheng phabep chu toh, hiche thaotwi toh kihalsa changlhah le changbong neldil a kisem chutoh ato thading ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Amapa chun hiche thangvahna maicham thilto kilhaina gantha chu chol jaolou changlhah chutoh ahin totha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Chule hiche thilto ho jouse lah’a konna chu khat cheh alah doh ding, hichu Pakai maicham thiltoa apeh ding ahi. Hiche ho jouse chu chamna maicham thilto gancha thisan jouse chap jal'a pang thempupa chang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Hiche thangvahna maicham thilto kilhaina gancha kithat chu, anikhoa neh ding ahin, asa neo khat jeng jong khovah chan umsah louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Chule hiche gancha kilhaina maicham toh doh pa chun, thu lolhin sah a kitoh doh ham ahilouleh deisah jal'a kitoh doh ahileh, hiche kilhaina gancha kitha nikho mama achu aneh ding amoh chengse chu ajing lam le anehthei kit ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Chule ani thum chana sa umho vang chu meiya govam hel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Ito bangkhat a hiche mipan gancha kilhaina maicham thilto aneh nah laiya ahileh, hiche kilhaina maicham tohpa chu santhei dol ahipoi; hiche maicham thilto chu amapa dinga ngensea um thei louding ahi, ajeh chu hot umtah sohdoh ahitan hitobang thilto nekha sun chu chonset themmona chu chang jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Thil theng lou sa chu neh tah louding, hichu meiya govam hel ding ahi, hinlah mi koi hileh atahsa chung theng chan chun sa aneh thei jing ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Ahinlah koibang khat chu ama tichung boh puma, Pakaiya dia kitoh doh kilhaina maicham nekha sun chu koi hileh amite lah a konna pampeiya um jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Koi hileh atheng lou tongkha achu, hiche atheng lou atoh khah pen pen chu, mihem ahin gancha theng lou hi jong le hiche ho jouse toh chun kilhaina maicham thilto ho chu nekha jing ta leh, amapa chu amite lah a konna pampeiya um jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Pathen'in Mose henga hiti hin asei tan, ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Israel chate jouse henga hiti hin thu sepeh in, sathao kiti phot bongchal thao hihen, kelngoi thao, kelcha thao hitaleh athao kiti phot chu neh da jengun, ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Gancha thikam thao hihen, gam mang lah a gamsa tha athao hijongleh hiche sa thao ho chu lam choma kimang thei ding, hinlah neh vang naneh louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Hitobang achu koi hijonglehu chun, Pathen henga govam dia kitoh doh gancha sa thao nekha chan chu namite lah uva konna pampeiya um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Nanghon thisan kiti phot, vacha thisan le gancha thisa kiti phot, nache lenauva thisan um phot chu naneh thei lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Hiche bang achu nalah uva koi hileh, thisan tep kha phot chu pampeiya um jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Pathen'in Mose henga hiti hin aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Israel chate jouse henga hiti hin seipeh tan, nalah uva koitobanginPathen adia chamna maicham thilto kilhaina gancha apeh nom chan in peh jeng thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Ama chun atahsa tah a hiche kilhaina gancha chu Pathen heng lama ahin kaiya, hichea chu athilto ding chu athao le a oppheng ahin choi ding, chuteng Pathen ansunga aoppheng lai chu maicham thennso naa pang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Chujou tengleh thempu pan sa thao chengse maicham phunga agovam hel ding, a oppheng jouse vang chu Aaron chapate chang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Chamna thilto nabol bang un, Sa amal khat pen chu thempupa henga napeh lut diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Hitia chu Aaron chapate ho lah a gancha thisan le athao toh'a pangpa chun, ama chan ding samal jet lam chu aki koi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ajeh chu kithenso sa oppheng le sa mal chu Israel chate jouse lah a kon kiladoh a, chamna maicham thilto apeh jouse lah uva konna kachom khen doh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Hichu Aaron le achapate jouse chang diu ahi, ajeh chu amaho Pathen thempu adia akithen souva ahung kipeh doh nikhouva pat, Pathen henga pumgo maicham thilto jouse akilah diuva gotsa chu ana hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Chule thempu dia thao akinu nikhouva pat, hichu amaho chang diu ahitia Pathen'in Israel te lah a ana phondohsa ahitai, hitia chu akhang lhung keiyuva tang louhela bat a anei jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Hichu pumgo maicham thilto ding dan, lhosohga, themmona, kisuhthengna chule chamna maicham thilto dan hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Gamthip lailunga Pathen'in Mose henga athusei chun, Israel chaten Pathen henga maicham thilto ahinchoi diu ahitia, ana phondohsa ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Hichun Pathen'in, Mose henga hiti hin aseiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Aaron leh achapate kou khom inlang, akivkonna ding un, kiloi ding thaotwi choiyin chonset maicham thilto dingin bongchal le kelngoi achal nitoh puiyin chule cholsolou changlhah pucha khat jong nachoi peh ding u, ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Chutengleh khopi sunga ami takip ki khopkhomna ponbuh kot phunga chun koukhom sohkeiyin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Chuin Mose’n jong Pathen thupeh bang bang chun na atong in, khopi sunga kon'in amitakip chu kikhopkhomna ponbuh kot achun ahung kikhom soh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Hichun Mose’n jong Mipi hojouse jah a thu aseiyin, hiche hi Pathen'in bol dinga thupeh anei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Aaron le achapate ho Mose’n ahin puitan, abonchauvin twiyin asiltheng soh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Chuin Aaron chu sang khol lah a alenpen chu avonpeh tan, sangkhol chol jong avon peh in, konggah jong agah peh tan ahi, hichu khut them tah a kisem chalchep konggah chu agahpeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Hiti chun ompho achung a atom peh in, chuin ompho chunga chun vahna le chamkimna akoi lhing sel’in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Chuin Mose’n Aaron luchunga del akop peh in, adelkop mailama chun sana pheng lallukhuh akhaipeh tan, Pathen'in Mose athupeh bang chun aboltai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Chuin Mose’n tahsaa anu ding thao chu alan, Pathen houbuh le asunga um jouse anu sohkeiyin, thensona aneiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Hichea chu vel sagi jen achap khum ding, maicham leh ama manchah thil jouse jong chu thao achap soh in, kisilna konglen chule atunna jong thaotwi achap in abonchan athenso tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Thempu Aaron luchunga nu dingin thaotwi helkhat achap khum in, atahsa ajong anun, athenso paitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Chuin Aaron chapte ho chu Mose’n ahin puiyin, khat cheh in sangkhol len a ahpeh tauvin; konggah jeng jong gahpeh in aluchang cheh uva lukhuh akhuh peh cheh un, Pathen thupeh bang banginMose’n amaho chu khat cheh in abolpeh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Hiti chun Chonset maicham thilto dingin, bongchal chu ahin kai luttan, chuin Aaron le achapate hon gancha luchanga chun akhut angam lhasohkeiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Chuin bongchal chu Mose’n athat paiyin, athisan achun akhut jung aphum lut in, maicham phunga saki ho achun achap natsohkeiyin, maicham jong athenso in, gan thisan chu maicham khombul hoa achapnat soh helin, thensona sem in, hiche achun kithoina jong aboltan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Asunga athao jouse achom khen in, athin lah a aphe le athao le akal teni ahin, athao beh jouse jong achom khen in, hiti chun Mose’n maicham achun agouvam tai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Hiche bongchal avun atahsa ho chule aeh jaonan, Pathen thupeh bang banginMose’n polam ngah mun achun agouvam heltan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Chuphat in pumgo maicham thilto dingin kelngoi chal ahin pelut in, hiti chun Aaron le achapaten kelngoi chal chunga chun akhut-u angam sohkei tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mose’n kelngoi chal chu athat in, gan thisan chu maicham aning gola achap khum in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Kelngoi chal sa chu asem toh selin, aluchang ahin asa kisem toh sel leh athao abonchan Mose’n meiya agouvam tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Gancha sa sung jouse ahin, akeng ahin; abonchan twiya asoptheng soh phat in, Pumgo maicham thiltoa dingin Mose’n kelngoi chal chu agoutan, Pathen thupeh dungjuijin Mose’n Pathen heng lam adin pumgo thilto namtuisel chu atodoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Chuin kelngoi chal khatma thensona dingin ahin kailut paiyin, Aaron le achapate hon gancha luchang achun akhut-u angam sohkeiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Hiti chun Mose’n jong Kelngoi chal thenso na chu athat tan, athisan phabep aladoh in, Aaron bilkol jetlam achun aloipeh in, akhut jetlang khupi achun thisan anupeh in, akeng phang khupia jong chun anupeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Hiti chun Aaron chapate abonchauvin ahin puiyin, gan thisan hel khat khat abilkol jet lamu aninggol leh akhut jet lamu khutpi cheh-u ahin, akengphang jetlamu khupi achun anunat peh sohkeiyin ahi. Gan thisan chu Mose’n jong maicham kimvela chun athe chap soh hel in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Athao ho jouse ahin, asunga athao ho jouse jaonan, athina aphe um cheng leh athao toh kihal akal teni jaonan, athao chengse chutoh amal jet lam achom khen in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Pathen angsunga kitung pucha sunga chol jaolou changlhah phengkhat, thao toh kihal chu mang chan, changlhah atum tuma umkhat jong alan, hiche ho jouse chu abonchan sathao ho leh samal chunga chun akoiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Chuphat in Aaron le achapate khut a apedoh tan, hichengse chu abonchan Pathen angsunga thensona maicham din thennsona aneiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Hiche ho chu abonchan Mose’n anung lah in, abonchan pumgo maicham thilto toh chun maicham phunga meiyin agouvam tai. Ajeh chu ki thensona maicham ahin, hichu Pathen heng lam adia gimnamtui tah pumgo thilto ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Aoplhang se chu Mose’n aladoh in, Pathen heng lama thensona thilto din alhan in, hichu Pathen thupeh bang banga Mose’n chanvou anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Thao phabep khat le gan thisan phabep maicham chunga um chu nu dingin, Mose’n alan Aaron tahsa chung le aposil chung hoa chun achap khum in, Aaron le achapate jouse jaonan, achapate jouse ponsil ahin ama ponsil abonchan thensona aneiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Hiti chun Mose’n Aaron chule achapate jouse henga hiti hin aseipeh in, kikhop khomna ponbuh achun sa hi kihon tauvin, ajeh chu Aaron le achapa ten aneh diu ahi, tia ana kiphong doh bang bang achun; khopi phung lam achun sa thensona changlhah pucha sunga um chu naneh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Hichea naneh moh chengseu chu, aboncha sa hihen changlhah hileh meiya nago vam diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Chule ni sagi sung sesea koima chan kotpi phung apaltan louding, hichu thensona nikho ahung lhun kahsea koimacha pampot louhel ding nahiuve, ajeh chu na kithenso na dinga, na ki suhtheng ngaijah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Hichu ahin tunia na kitong banga hi, Pathen'in nangho kithoina sem nadinga thupeh ana nei ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Hijeh chun nangho koihijonglehu chun nisagi sunga hi, ki khopkhomna ponbuh kotpi bula najan ge jeng diu; Pathen thupeh banga ima jouse najui diu, hiche bang bang achu keima jong ngensena eina kipe a ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Chuin Aaron le achapate jousen, Pathen akon Mose’n athupeh bang uchun ijakai abol tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Chuin niget lhin nin, Mose’n Aaron chapate chengse le Israel te lah a upaho akou khom in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Aaron henga hiti hin aseipeh in, chonset maicham thilto dingin bongchal khat gakaiyin, chule pumgo maicham thiltoa todingin kelngoi chal khat ma gakaiyin lang, anitah achu Pathen henga na todoh a, ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Hitia hi Israel chate henga na seipeh ding, chonset maicham thilto dingin, kelchal khat gakaiyun lang chule pumgo maicham thilto dingin, nolnabei bongnou khat leh kelngoi nou khat nahin kaidiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Pathen angsunga chamna maicham ki lhaina thiltoa din, bong chal khat le kelngoi chal khat naga kaidiu; lhosohga maicham thiltoa din changbong thaotwi kichapsa jong jaonan, ajeh chu tuni khoa hi nangho henga Pakai, Pathen hung kilah thei ahi, tin hil’un tin aseiye. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Hitobang chun amaho jousen Mose akonna athu jah bang un, thil jouse chu kikhop khomna ponbuh mailam achun ahin poluh sohtauvin; chuin khopi sung akon japin ahin nailut un, abonchauvin Pathen ansung achun ading sohkeiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Chuin Mose’n ajah uva hiti hin aseipeh in, hitobang thil ho jouse hi Pathen'in nangho natoh dinga napeh doh-u ahitan, hichea chu Pakai, Pathen loupina nangho jal'a naheng uva hung kilah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Hiti chun Mose’n jong Aaron henga hiti hin aseipeh in, maicham phung lam hin nailut in, chonset maicham thilto nato ding le pumgo maicham thilto nato ding chu hung toh'inlang, hichea chu nangma mimala ding ahin namite jousea ding hijongleh ki thoidamna nasem ding, Pathen thupeh bangmin japin maicham thilto dinga ahin choi chengse chu, hinchoi inlang amaho dia jong kithoidamna nasem peh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aaron in jong maicham phung lam ahin nailut paiyin, ama mimal kithoi damna dia chonset maicham thilto bongnou chu athat tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Gan thisan chu achapaten Aaron henglama ahin choiyun, hichun Aaron in jong gan thisan lah achun akhut jung aphum lut in; chuin maicham ning li saki hoa achun thisan aloinat in, thisan amoh chengse vang chu maicham phunga chun abonchan abolhan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Chule hiche chonset maicham thilto gancha thao le akal teni, athin a um aphe chengse chu Mose henga Pathen'in anathu peh bang chun maicham chunga meiya agou vam I ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Gancha tahsa le avun chengse vang chu, Aaron in polam mun khat a meiyin agou vam tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Chuban in Pumgo maicham thiltoa kito doh gancha chu athattan, gan thisan chu Aaron chapaten ama heng lama ahin choiyun, hiti chun Aaron in jong maicham phung aning gol gola chun gan thisan chu achap khum sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Chuin Aaron kom'a pumgo maicham sa um chu achapate hon asem khen khen un, aluchang jaonan ahin polut un; chuin Aaron in maicham chunga meiyin agou vam in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Sasung ahin akeng li ho ahin, abonchan Aaron in asop theng in pumgo maicham thilto ahin, abonchan maicham chunga chun meiyin agou vam in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Hiche jouse kichaiyin, Aaron in japi maicham thilto chengse ahin kaiyin, japi dinga ki tohdoh chonset maicham thilto kelcha chu athat in, masanga thilto kibol bang bang chun chonset maicham thilto in apedoh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Pumgo maicham thilto jong ahin choilut in, dan kisem bang bang chun hiche jong chu atodoh paiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Lhosohga akon maicham thilto ding ahin polut'in, maicham thilto ding chu akhut dim in aham doh in, pumgo maicham thilto jingkah seh’a kibolna mun achun agou vam in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Chuin Aaron in chamna maicham thilto kilhaina japi dingin, bongchal leh kelngoi athat in, gan thisan chu Aaron chapaten ama henga ahin choiyun ahileh, Aaron in jong gan thisan chu maicham phung gol gola chun achap khum in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Bongchal leh kelngoi achal thaose chu, amei thaolai le asung alap thao jaonan akal teni le aphe um chengse, ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Abonchan athao jouse jaonan aoplhang chungvuma chun akoi uvin, ahin hilah achun athao laise chu meiyin ahalvam un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aoplhang kah le amal jetlam vang chu, Patheng henga Aaron in athensona maicham thilto din athenso paiyin, hiti chun Mose thupeh banginaboltai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Hiche jouse kichai nungin, Aaron in japi lamven phatthei aboh un ahi. Hiti chun hiche maicham thilto ho; chonset maicham thilto, pumgo maicham thilto leh chamna maicham thilto abonchan Pathen henga atodoh nung chun ama ahung kumsuh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Kikhop khomna ponbuh sung achun, Mose le Aaron asung lha lhonin, ahung potdoh kit lhon tan, japi chu phatthei aboh pai lhonin, apattah chun japi angsung achun Pathen loupina ahung kilah jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Hiche pattah chun Pathen angsunga mei akou jeng tan, maicham phunga kikoi sa thao pumgo maicham thilto chu aka lha jeng tai, japin hiche thilsoh amu phat un a-ul lha tauvin, abonchauvin tollhang achun, amaiyu angasohkeiyun akun lha tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Chule Nadab le Abihu, Aaron chateni chun meibom chu akilah lhon tan, asung achun mei atih kou lhonin, gimnamtui jong akoiluttha lhonin, Pathen thupeh loubeh in achon lhontai, thenna beihel khop in Pathen angsunga chun hiche gimnamtui chu ahal lha lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Chuin Meikong hattah Pathen a kon'in ahung koudoh in, Pathen angsunga chun ani lhonin thina atoh lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mose’n jong Aaron henga aseipeh in, hiche hi Pathen'in ana thupeh keima heng lam hin nailut chan chu, Keiman jong thengsel'a kakimu sah ding, chitin namtin anga choi-at a kaum ding ahi, tia asei chu ahi, chuin Aaron jong thip chat in aumtai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Uzziel chapte ni Mishael le Elzaphan chu Aaron in akou lhonin, ajah lhona hiti hin aseipeh lhonin, muntheng sunga hung lut lhonin nasopi te ni longdamsa hi polang ngahmun khat a gathah doh lhonin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Chuin amanin jong muntheng achun alut lhonin, Mose thupeh banginasopi teni longdamsa chun asang khol len achun, akhu lhonin polang ngahmun achun apodoh lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mose’n jong Aaron ahin achapateni Zar chule Ithamar henga hiti hin aseipeh in, na jangtel sam uchu lhaideh a naput louhel diu ahi, hitia chu na ponsil jeng-u jong na kesah lou diu, hichu nanit lou uva ahileh thina na chan jeng thei uahi, chugoh hi louvin na khopi sung uva jong lunghanna kibung lha thei ahi. Pathen lunghanna aso jah khah a ahileh, Israel chate jouse chu kap ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Kikhop khomna ponbuh kotbul chu jabol unlang khokal hih un, hiche jong chu nanit lou uva ahileh thinan naphah diu ahi, ajeh chu nangho hi Pathen adia thaonu chang nahi tauve. Hiti chun Mose’n athupeh bang bang uchun abol tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Pathen'in Aaron henga hiti hin jong aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Kikhop khomna pobuh sung lam nalut ding uva ahileh, na chapate jouse ahin chule nangma tah nahin na boncha uva ju leh khamna thei kitiphot nadon theilou diu ahi, ajeh chu thina na chan jeng thei diu; hijeh chun nakhang nakhang uva najui diuva thupeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Thil theng le thil ijakai athenglou hose chu, na chomkhen sohkei diu, atheng le atheng lou chu datkhen jidan nathep diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Hiche jeh’a chu Pathen'in Israel chate jouse, Mose mangchaa athusei jouse nun le khan ding dan chengse chu phatah a na seipeh sohkei diu ahi, tin a seipeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Chuin Aaron chapa teni Eleazar le Ithamr adam nalai teni jah chun, Mose’n hiti hin aseipeh lhonin, Pathen adia lhosohga maicham thilto amoh chengse chu chomtup unlang, chol jaolou in maicham phung kom achun netauvin, hichu thil theng lah a achungnung pen ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Hiche hi muntheng lai khat a naneh diu ahi, ajeh chu hiche hi Pathen adia pumgo maicham govam dinga thilto lah a konna kihom khena chapateu janaa nangho ding dia a-itih a kichom koi chu ahi. Hiche hi keima tah henga thupeh ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Hinlah ana kithensosa oplhang le sa amal anakitoh dohsa chu na chapate jouseu le na chanute jouseu janan, muntheng lailung khat a naneh khom diu ahi. Hichengse chu Nangho jouse chule Israel chate jousen chamna maicham thilto kilhaina gancha tha chu ahin, nangho le na chapa teu neh dinga a-itih a thupeh le aki koitup chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Sa aoplhang le sa amal ana kitoh dohsa chu hin choi unlang, pumgo maicham thilto ahin sathao jaona ahin pohlut diu, chutengleh Pathen angsunga thensona maicham thilto dinga thensona um ding, a-imatih chana dinga hiche maicham thilto jouse chu nangho jaonaa na chapate jouse chan ding ahin, Pathen thupeh bang banga chu um ding ahi tin aseipeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Chuin Chonset maicham thilto kelcha chung chang thua Mose’n kholchilna aneiyin, kelcha chu ana gouvam un ahi. Mose’n jong Aaron chapateni adamna lai Eleazar ahin Ithamar lunghanna achutan, hiti hin aseipeh lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Chonset maicham thilto chu ipi dinga munthenga naneh lhon lou hitam? Thil lah a atheng chungnungpen nang ni chanvou ahitan, Pathen masanga khopi sung japi thoidamnaa na natoh lhon ding ahitia mopohna sangpen nakipe lhon hilou ham? ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Tun gan thisan chu muntheng lailunga akikoi lut tapon, kathu hetsah bang chun nangnin jong muntheng lai lunga chu naneh teitei lhon ding ahi, tin aseipeh lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaron in jong Mose henga aseitan, chonset jeh a Pumgo maicham thilto ding chu Pathen angsunga akat lhonin, hiche thilto hi angai ngai ahina laiye, hijeh chun keima tah mo eiki chansah ahi. Tuni hin hiche chonset maicham thilto sa hi kananeh hitaleh, Pathen mitmua san theidol ahidem? tin aseiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mose’n jong hitia Aaron in ahenga, aseiphat chun alung dam tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Pakaiyin Mose le Aaron henga hiti hin, aseipeh lhonin, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Israel chate henga hiti hin seipeh lhonin, hiti hin chon uhen, hiche ganhing leiset chunga lha le jouse hi naneh thei diuva um ganhing ho chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Gancha ho chu abang atin ni kehkop, atin keh to, chule anehsa akama lhai ho chu naneh thei diu gancha ho ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Gancha atin kika ho leh anehsa ihdoh a avel'a lhai ji ho chu, naneh diu hijongleh sangongsao vang naneh theilou diu ahi, ajeh chu anehsa aihdoh a alhai vang'in, atin akika poi. Hitobang gancha ho hi nangho dia satheng lou aboh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Jupi jeng jong athenglou anehsa aihdoh a alhaiji vang'in, atin kika lou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Talep kiti gan hing jong hi nangho dia aboh ahi, anehsa aihdoh a alhaiji vang'in, atin kika lou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Gancha lah a vohcha jeng jong hi nangho dia aboh ahi. Ajeh chu atin kika ahivangin, anehsa kiti aihdoh khapon lhai jong alhai poi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Hiche gancha ho hi toh jong natoh khah lou diu, along jeng ujong nasuh loh lou diu satheng lou aboh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Tuilah a cheng ganhing naneh thei diu ho chu ahileh, twikhanglen le vadunga cheng aving chule alip nei tapou naneh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Ahinlah twikhanglen le vadunga cheng jouse lah achun ahon hon'a lhakhom hihen, ipi ganhing chu hitaleh alip, aving neilou jouse nangho dia atheng lou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Hichengse chu nangho dia thet umtah a nagel diu, asa jong naneh louhel diu, athisa jong chu natoh khah louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Twi lah a alipbei le alhaving bei ganhing jouse, nangho dia atheng lou aboh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Vachate lah jeng ajong nathet bol diuva ganhing ho chu ahileh, hiche ho hi nathet bol diu naneh louhel diu ahi: muthong, muvanlai, mu ngaman, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Ipi mu hijongleh mubong hijongleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Vangah hijongleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Va ngongsang ahin, Bahpi ahin, twiva, itobang va hihen muvanlai jouse jaonan ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","Sumbupi ahin, vatot muhsao ahin, twi vahong ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","Twi va-ah ahin, vatot kamkabah ahin, muthong, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Twilungva ahin, ipiva hileh twi vakang jouse jaonan, sel ehva leh bah, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Alha neiya akenglia lamjot ganhing kiti phot, nangho dia thet umtah ganhing ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Alha neiya akeng lia lam ajot jing vang chun, tol'a achop le achut le nathei akeng jung nei ho vang chu nang hon naneh thei diu ahinai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Nangho neh thei ding chu hichengse hi ahi: khaokho naneh thei diu, mul neilou khaokho hovang naneh lou diu, khongbai naneh thei diu, khaokhopi jat chengse naneh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Amavang tol'a vah akeng li um, lhaving neiya lengthei kit ganhing kiti jouse chu nangho dia thet um ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Hiche hoa chu na kisuh boh thei diu ahi, akimin phah chengse hi nalah uva koi hijongleh, atongkha chu aboh ahin hichu nilhah geiya aboh a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Koi hijongleh hiche ganhing thisa tongkhaa kipoh aum khah leh, aponsil akisop theng ding nilhah geiya ama chu aboh a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Chule gancha tin kika neiya hinlah atin teni khe lhalouva, anehsa ihdoh kit a lhai kit lou gancha chu nanghodia aboh atheng lou ahi, koi hileh hiche gancha tongkha chan chu aboh a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Sa ho lah a akeng lia lamjot hihen, akengpeh tollhang chon jouse hijongleh, nangho dia hichengse jong hi aboh a kisim ahi. koi hijonglehu chun hiche sa thilong thamkha chan chu, nilhum geiya aboh a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Chule hitobang saboh tham kha chun aponsil akisop thenga, nilhum geiya aboh a um ding ahi, ajeh chu hichengse hi nangho dia atheng lou aboh a kisim jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ahon hon'a lha khoma kiloikhom ganhing leiset chunga lha hichengse jong hi aboh ahi. Khoili ahin, jucha ahin, thangkip pi ahin, thangkip to kibangse ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Daidep ahin, Tang, Thangkip, Taangnam, jucha thangkip hichengse hi ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Ahon hon'a lha ganhing hichengse chu aboh a um ding ahi, hichengse hi athitengleh nalah uva koihijonglehu chun athilong tong kha aum leh, ama chu nilhum geiya aboh a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Hiche ganhing hose hi athiteng ahung kipai lhah namun'a aho khah pen pen chu thinglom lah hihen, ponsil chung hihen, savun chung hihen, dip chunga hijongleh, manchah jat chom choma kimang bel chung hijongleh, aho khah pen pen chu aboh a um ding, aho khah penpa chu nilhuma aboh ahitan, nilhum tengleh amapa chu kisutheng thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Hitia ch ganhing aboh hose chu hetman louva leibel sung ahung ho lut khah tah a ahileh, hiche belsunga um jouse jaonaa chu atheng lou ahitan, aleibel jeng jong chu na tekeh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Neh ding hijongleh hichu twiya sopngim thei ahitapon, athenglou aboh a um ding ahi. Hiche leibel sunga twi uma donkha aum khah a ahileh, ama jong chu twi aboh banga aboh a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Hitia chu hiche ganhing ho chun athijoua ahokhah pen pen chu atheng louva um ding, meithuh ahin, thaomei bom ho lah ahin, ahokhah pen pen chu tekah ding ahi, ajeh chu hiche manchah thil jouse chu aboh ahitan, nangho dia jong atheng loua pang ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Itobang khat a twinah le twisam putdoh namun ahikhah levang hichu athenga um ding ahinai, hinlah thil dang tongkha pen pen chu ganhing aboh bang banga chu aboh atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Chule hitobang ganhing ho chun muchi tudia kikoi, hiche ganhing athisa neokhat touin atoh khah a ahileh, hiche muchi tuding chu athenga um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Hiche muchi tuding chu twiya kichop nousa ahileh, hiche ganhing atheng lou thilongin ahokhah tah jeh a chu, hiche muchi tuding chu nangho dia atheng lou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Naneh ngaiyu gancha khattou athi khah a ahileh, hiche gancha thilong tongkha pen pen chu koi hijonglehu chun nilhum keiya atheng loua um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Hiche gancha thikamsa nekha chan chun aponsil akisop ngim ding, hinlah ama chu nilhum geiya athenglou aboh ahitai. Hiche bang achu koi hijonglehu chun nalah uva hiche ganthikam pole apang aum khah leh, ama chun aponsil akisop ngima nilhum kahsea atheng loua um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Chule ganhing ahon hon'a lhakhom chele jouse chu, nang hon napam paidiu ahi, hichengse chu naneh thei louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Ganhing aop a kithol lea, akeng li neiya aoipoh a kithol, keng tamtah neiya kithol jaonaa ahon hon'a kithol khom ho jong naneh lou diu, ajeh chu thet umtah ganhing ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Hitobang ganhing aop a kithol ahon hon'a lhakhom ho chu, toh jong natoh khah lou diu hichea konna chu dalbola naum lou nadiu ahi; hichengsea kon chun kisu boh hih hel un, hijeh chun naboh nalou diuvin um cheh un. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ajeh chu keima hi nangho jouse Pathen chu ka hin, keima kathen banga nangho jong nathen diu, hijeh chun vannoi leiset a aop a kithol ganhing akonna nakiven doh uva nakisuh boh lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Hicheng ho jouse chung achu keima tah nangho jouse Pathen ka hi jeh in, nangho jouse Egypt gam'a konna nahin puidoh pau Pakai kahi, keima kathen bang banga hi nangho jong nathen diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Tua na heng uva kisei hi ahileh, sa ahin, vacha ahin, twi lah a cheng ganhing namkim ahin, twi lah a kithol jouse ahin, leiset chunga ahon hon'a lhakhoma ganhing ho ahin chule achung chang cheh uva dan um ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Hiche ganhing ho jouse lah akonna chu atheng le athenglou dat khen nadinga, neh thei ding le nehthei louding thudol'a dan kisem ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Hiti hin Pakaiyin, Mose henga thu aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Israel chate jouse jah a hiti hin seipeh in, Numei khat in nao avop a anavah lhah a nao chu pasal ahileh, hiche numeinu chu athi neipet banga, ni sagi sung aboh a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Hitobanga chu niget lhinni le, achapa chu chep kitan ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Chujouteng hiche numeinu chu athisana konna thenso kinbolna dinga, nisom thumle nithum hitia chu um ding; hiche nikho kitipna nikho sunga chu hiche numeinu chun thiltheng khat jong atoh khah louding, Hou-In munthenga jong lutlou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Hiche numei chun cha ahin a numei ahileh, athi neiphat bang banga hapta ni kah atheng loua um ding; chujouteng athisana konna thenso nadia nisom le nigup angai banga anga ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Chapa pen dol hihen lang chanu pen dola hijongleh, jechan ding numeinu kithensona nikho jat alhin teng, hiche numeinu chun kikhop khomna ponbuh kotbula chu, thempu henga pumgo maicham thilto dinga kum khat lhing kelngoi ahin kai ding, chule chonset maicham thilto dinga vapal nou ahin choi thading ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Chuteng numei naosen neinu dia thempu pan kithoina dinga Pakai henga atodoh peh ding, chule numei nu chu athisan lkonna akonna athenga umbep ding ahi. Hiche dan hi numei chanu le chapa hing thei jouse dinga dan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Hiche numei chanei nuchun kelngoinou anei louva ahileh, vakhu nou ni pumgo maicham thiltoa anei ding, hiche lah a adang khat chu chonset maicham thiltoa ding, chuteng thempu pan amanu dinga kithoina asempeh a athenga um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Pakaiyin Mose le Aaron henga, hiti hin thu aseipeh lhonin. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Koitobang khat chu atahsa vun pomdoh aboldoh ham, ahilouleh adul doh a ham auma ahileh, hiche natna akonna chu avun ahung pat doh a, ahung phah lha dia ginmo ahileh, amapa chu thempupa Aaron kom ham ahilouleh achapate thempu ho heng lama puiding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Chuteng thempu pan atahsa pat laichu avet peh ding, hiche atipat laiya amulse chu akan tom ding, chule hiche atahsa pat laichu atahsa vunpotho sanga asunglut joham khat akimu leh, hitobang tipat natna chu aphah veiya ahi; thempu pan ama chu avet lhah ding, hitobang natna nei mihem chu thempu pan ama hi aphah ahin abohtai, aphondoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Atipat lai avunbeh chu akan chah ding, akang laichu avun tho sunga alut loulai leh, atahsaa amul jong akan chah loulai ahileh, hiche natna neipa chu thempu pan nisagi sunga angai banga ajehsah ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Chule nisagi lhinni leh thempu pan avel'a avet lhah kit ding, chuteng thempupa mitmu changa anat chu a oldoma, ati pat jeng jong avun beh dang hoa achalbe tahlouva ahileh, hiche natna neipa chu thempu pan ni sagi sung vet a akoi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Ni sagi ahung lhin kit nikho tengleh thempu pan natna neipa chu avel'a avet lhah kit ding, atipat na chu avom doh a, atahsa chung dang hoa atipat chu achalbe tah louva ahileh, amapa chu thempu pan akisutheng ahitai, tia phondohna anei ding ahi. Hiche tipat chu tahsa chung boldoh tobang ahin, hiche natna neipa tipat neipa chun, aponsil ho akisop theng ding chuteng athenga um thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Hinlah thempu pan avet lhah jou nung jenga jong, atibol chu avunbeh dang hoa achalbe nah laiya ahileh, thempupa heng lama avel'a che kit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Chuteng thempu pan avet lhah ding, atibol chu atahsa vun danga achal bea ahileh, hichea chu thempu pan ama chu atheng lou ahitai, ti aphondohna anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Mihem khat chu tiphah natna anei tengleh, thempupa heng lama puiding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Chuteng thempu pan tiphah nat veipa chu avet lhah ding, avun beh a chu akang tobang adul doh a, hiche akang lai chun atahsa mul kisan akan sah tah a, adul doh lai akonna avouso thah akimu doh khah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Hiche natna chu anapa tahsa vun sung thoa lut ahitan, chuteng thempu pan nantna neipa chu athenglou ahitai, ti aphondohna snri ding, vet a jong akoitah louding, hiche pa chu atheng lou aboh a kisim ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Chule hiche tiphah natna chu atahsa vun hoa achan soh tah a, hichea chu phah natna veipa chun thempupa mu theiya, aluchang apat akengto phang chan, phah natna chun atom lhah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Amapa chu thempu pan hoitah a vet lhahna anei ding, hichea jong chu tiphah natna chun amapa chu atom lhah jing tah ahileh, thempu pan amapa chu hiche tiphah natna anei jeh’a chu, atheng lou aboh ahitai, tia aphondoh ding, hinlah aphah natna atina khem hojouse chu akan doh a ahileh, amapa chu athenga kisim ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Chule amapa tahsa chunga chu avouthah akisebea ahileh, atheng louva umnalai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Amapa vouthah kisepbe lai chu thempu pan avet ding, atheng lou ahitia aphondoh ding ahi; ajeh chu vouthah kisep doh kiti hi atheng lou ahin, hichu tiphah natna ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Hinlah tichunga natna chu akhip tah a ahung kan doh khah a ahileh, tiphah natna veipa chu thempu heng lama hung ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Amapa chu thempun avet lhah ding, anatna tiphah chu ahung kansoh a akikhenna auma ahileh, hichea chu thempu pan tiphah natna veipa chu aphahna akonna athengdoh ahitai, amapa hi athengtai tia aphondoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Mihem khattou tahsa chunga uilut neiya, pomdoh aum khah leh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Hiche tina maha akonna chu anai kang ahung umdoh khah a, asan le akang kihal ahung pomdoh thaa ahileh, hitobang natna chu thempupa henga vetlhahna nei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Thempu pan vet lhahna anei ding, hiche natna chu avun tho sanga asung lut joh a, atahsa mul jeng jong akang ahung umdoh khah a ahileh, amapa chu thempu pan atheng lou ahitai, ti aphondohna anei ding ahi. Ajeh chu hitobang natna chu tiphah ahin uilut lima hung sohdoh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Ahinlah thempu pan avet lhah a tina maha beh, atahsa mul ho kang doh nailou anatna jeng jong asung thoa lut nailou, tina maha nai jong avom nah laiya ahileh, hiche pa chu thempu pan ni sagi sunga vet a aum sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Hiche natna chu atahsa chunga achalbe khah a ahileh vang, amapa chu thempu pan atheng lou ahitai, ti aphondohna anei ding, hiche jeng jong hi phahnat vei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Hiche anatn chu ati chung munkhat seh a sohdoh chalbe louva aum leh, hiche tiphah chu uilut ahiin, hichea chu thempu pan amapa chu atheng e, tia aphondoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Meiyin mihem tahsa chu akah khah a, meikahna avun beh le avouso chu ahung dul doh a, asan le akang kihel, akang ham ahung sodoh tah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Hichea chu thempu pan anat nalai meikah lai chu avet lhah peh ding, anat nalai a atahsa timul geiya ahung kan doh khah a chule avun tho sunga asunglut khahtaa ahileh, hichu phah natna ahin, meiyin akah na maha chu hung soh oh a ahitan, thempupan amapa chu atheng loua ahitai, ti aphondohna anei ding ahi, ajeh chu hiche natna chu phah natna ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Hinlah anatna chu thempu pan vetlhahna aneiya, anatna behkah timul jeng jong akang asohdoh nailou, anatna chu avuntho sung jenga jong lutnai louva, avom den nah laiya ahileh, thempu pan amapa chu ni sagi sunga vet a aum sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Thempu pan jong ni sagi alhin nikho tengleh avel'a avet lhah kit ding, anatna chu avunbeh dang hoa achalbe khah a ahileh, hichea chu thempu pan nat veipa chu athengloua ahitai, ti aphondohna anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Ahin hiche anatna chu munbeh khat bouva auma chule avunbeh dang hoa chalbe talouva, hitia chu avunbeh khat bou aumden tah a, avun chu avom ahikhah leh, meiyin akah jeh’a hung duldoh a ahin, thempu pan hitobang ho chu atheng lou ahipoi tia, phondohna anei ding ahi, meiyin akahna maha chu akhem hung sohdoh kha ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Pasal leh numei khat pen pen in aluchang, akha lhang dona tina anei khah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Hichu thempu pan avet lhah ding, anatna chu avun thosunga alut khah a ahileh, atina maha beh a atahsa mul jeng jong eng lilih a auma, voichet chut dana aum khah a ahileh; hiche natna veipa chu thempu pan atheng louva ahitia, phondohna anei ding ahi. Ajeh chu hitobang natna chu tithah phah natna ahin, hichu lu chung leh kha lhang chana chal lut thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Hinlah hiche natna veipa chu thempu pan avetlhah nung jenga jong avuntho sung nunga asung lut hih laiya, atina maha beh a atahsa mul doh nailou ahileh, hiche natna tithah veipa chu thempu pan ni sagi sunga vet a aum sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Chule ni sagi lhin nikho tengleh, thempu pan vetlhahna aneipeh ding, ki thejal louva anatna tithah chu auma, anatna beh kah jenga jong atahsa mul eng kimuloua, tithah natna jeng jong avunthoa asunglut loudana akimu a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","Hiche tithah veipa chun ama tah in atahsa mul aki vochai ding, atithah nabeh lai vang chu ahoi ding ahi; chutengleh thempu pan hiche tithah veipa chu ni sagi sunga vet a aum sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Nisagi lhin nikho le thempu pan atithah natna chu avet lhah peh kit ding, atithah natna chu avunbeh hoa chalbe talouva, avuntho sung nunga jong sunglut louva auma ahileh, thempu pan tithah veipa chu atheng ahitai, ti aphondohna anei ding ahi. Chuteng amapa chun aponsil jouse akisop lhah ding, athenga um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Itobang khat a athengtai, tia athenga aum nung jenga jong, ati chung dunga ahung chalbe khah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Avela thempu pan hiche tithah veipa natna chu avet lhah peh kit a, atithah natna chu atahsa chung dang hoa achalbe khahtah a ahileh, hichea thempua pang ding chun atahsa mul a-eng ham a-eng lou ham ti, khol talouva hiche pa chu atheng lou ahitai, ati jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Hinlah thempupa mitmua atithah natna chu akinga dana auma atithah beh jong, atahsa mulvom ahung kedoh a, atithah natna jong adam ding tah a ahileh, amapa chu atheng ahitan, hiche jeh’a chu thempu pan jong amapa chu athenga ahitai, ti aphondohna anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Pasal hileh numei hileh atahsa chung aboldoh a, akang ahung sohdoh a duldoh khat tou anei khah leh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Ahung boldoh lai chu vet lhahna thempupan anei ding, atahsa dullai chu akan dup hela, ati chunga konna soh maimai ahivang leh, hichu avunthoa hung kimu chen ahitan, hiche pa chu athenga um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Mihem koitobang khat chu, alujang sam pullha chai keiya auma alu kisan atolleua ahileh, amapa chu atheng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Chule mikhat tou achal sam jouse apullhah a, alujang sam jouse apul lhah a adetol leuva leh amapa chu atheng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Adetol lai ahin achal sam tollai ahin, hiche beh a konna chu avun san tobang ahung dul doh a ahileh, hitobang natna chu asung lama konna tithah natna hung sohdoh ahin, hichu adeh tollai le achalsam tollai achu hung sohdoh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Chuteng thempu pan amapa chu avet lhah ding, adeh tollai ham achal sam tollai mun hama, tin ahung sohdoh chu, tahsa chunga tithah natna banga agel khah tah leh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Hiche pa chu aphah ahitan, atheng louva ahitai, tia aphondoh ding, hiche pa chun alujang chunga natna chu akipoh ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Hitobang natna tithah vei mi chun ponse jong akisil ding, alujang sam aput lhai ding, amuh chung geiya pon'a aki toma, aboh, aboh tia penga asap ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Ama tobanga natna nei mihem chun, adammo sungsea atheng louva um ding ahi, ajeh chu aboh ahitan, ama chu achangseh a polam ngahmun tiphah ho umna mun'a cheng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Ponsil dunga tithah natna anat khah tah a ahileh: samul pon hihen, tupat ponnem hileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Adung le avaiya kikhong tupet ponnem hihen, samul pon hihen, savun hihen ipi savun a kisem hijongleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","Hiche ponsil chunga chu tina maha ahung dul liuva, asan jong ahung sodoh a ahileh, hiche ponsil chu manlutah a adung avai kipheh a kikhong hijongleh, savuna kikhong hihen ipi savuna ponsil kikhong hijongleh, hiche natna chu tithah phah natna ahin, thempupa heng lama puiya vetsah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Thempu pan anatna chu avet lhah sohkeijya, hiche natna vei mihem chu nisagi sung vet a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Ni sagi lhin nikho tengleh thempupan avel'a vet lhahna anei kit ding, hichea jong chu anatna posila achalbe nalai leh, aponsil chu adung avaiya kipheh a chalchep a kikhong hihen, savun thoa kikhong hihen, ipi tobang hihen, savun jat jat a kikhong hijongleh, anatna chu tiphah natna ahin, hijeh achu aponsil pen pen chu atheng lou ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Hiche mipa chun aponsil chu meiya agovam ding, adung avaiya kipheh chalchep pon hihen, sa vun hihen, tupat ponnem hileh, ipi sa vuna kisem von hijongleh, natna chunga akonna titphah natna ahin, hichu meiya govam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Thempu pan avet a hiche adung avaiya kipheh chalchep a kikhong, ponsil chung lah hihen savuna kisem vonlah hijongleh, anat nachu chalbe louva auma ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","Hichea chu thempu pan amaho henga thu aseiya, japi hon nat bena ponsil chu asop ngim diu, chuteng thempu pan hiche ponsil chu ni sagi sunga vet a aum sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Hiche nat bena ponsil chu akisop ngim soh tengleh thempu pan avel'a avet lhah ding, natbe na ponsil vang chu akisop ngim jou tah louva ahileh, anatna chu ponsil chung achalbe louvang in, hiche ponsil chu aboh a um ding, tithah natna khem chu ponsil sung lang ham apolang hama abe jongleh hichu meiya govam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Thempu pan avet lhah laiya ama hon hichu asop ngim thei uva, nat bena beh lai chu avom aum dana ahileh, hiche beh lai kahse chu ponsil vona konna chu abo-eh a apai jeng thei ahi, savuna kisem hihen adung avaiya kipheh chah kheh a ki khong hijongleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Hiche jenga jong chu ponsil chung lah ham, adung avaiya kipheh a kikhong ponsil lah ham, savuna kisem von chung ham, chule ipi vona kisem hijongleh, savun von kisem chung jenga jong ahung sodoh a akimu kit nah laiya ahileh, hiche anatpi chu thi loulai ahin, chalbe nalai ahi, abena penvang chu meiya agovam manghel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Ahinlah aponsil ham, savuna kisem von ham ahilouleh ipi pena kisem ponsil hijongleh, savuna kisem jeng jong nasop ngim sel uva; hiche natpi chu abeihela ahileh ani chan nan jong sop kit un, chutileh theng ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Hichea akisei jouse hi tithah natna ham, samul pon chung lah ham, tupat ponnem chung ham, adung avaiya kipheh a kikhong ponsil chung ham, ipi pen vona kisem ponsil chung hihen, savuna kisem hitaleh achunga hiche tithah natna natpi achuh tah jeh a, itilam dola dantoh kitoh a phaham ti, abol ding dan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Pakaiyin Mose henga hiti hin thu aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Hiche hi miphah kisuh theng nikhoa bol ding dan ahin, miphah chu thempupa henga puiding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Thempupa jong ngahmun polama potdoh’a chuteng thempu pan kholchilna anei ding ahi. Hichea chu miphah pa chu damna achan khah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","Thempu pan akisutheng ding pa jeh’a chu miho thu apeh ding, vacha hing thengsel ni jaonaa Cedar thing toh agalah sah a, ponsan thim chule hyssop jong agalahsah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Chutengleh thempu pan miho henga thu apeh a, twi longlai chung khat achu leibel sunga vacha atha sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Vacha chu ahin nalai leh Cedar thing chule ponsan thim le hyssop pon chu alah a, twi longlai chunga kithat vacha thisan chu anunat sohkei ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Chule tiphah nat akonna akisutheng ding pa chunga chu sagi vei jen athin khum ding, chuteng tiphah nat veipa chu atheng ahitai, tia aphondoh a vacha hing jong chu ahinga alha doh a, hichu gamlah a alha mang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Thensona kibol peh ding pa chun aponsil aboncha akisop lhah a, asam jong aki chetol a, twija kisil thengsel ding, chuteng amapa chu athenga uma, hiche ho jouse akibol chaisoh tengleh masanga tiphah nat veipa chu naghmun sunga hung ding ahitan, hinlah amapa chu aponbuh polama ni sagi chan nichong nalai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Ni sagi lhin nikho tengleh alujang sam jouse akivo ngima, anemul akhamul le amitmul jouse jong akivo ngimsohkei ding, asama kai kiti phot avongim ding ahi. Chujou tengleh amapa chun aponsil jouse akisop thenga, atahsa twiya ki soplha ding, kisil thengsel'a, hitia chu amapa chu athenga um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Niget lhinni tengleh, masanga miphah pa chun nolna beihel kelngoi chal ni leh, nolnabei kelngoi pi khat aga mat ding, hiche kelngoi chu kum khat lhingsa hi ding, changbong neldi thaotwi kichapsa ephah dimkhat hopsoma hop thum toh agalah thaa, thaotwi khon dimkhat toh agathal tha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Chujou tengleh miphah pa suthenga pang ding thempu pan miphah pa ahin, thil hichengse chu kikhop khomna ponbuh kotpi phunga, Pakai angsunga atousah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Thempu pan kelngoi chal khat joh chu amat a thaotwi khon dimkhat chu themmona maicham thiltoa atoding, hiche teni chu Pathen angsunga themmona maicham thiltoa atodoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Chule kelngoi chal chu miho chonset maicham thilto chule pumgo maicham thilto athana mun-u muntheng laiya chu atha ding ahi, ajeh chu hiche themmona maicham thilto jong hi chonset maicham thilto banga thempupa chan ding dol ahin, athilto dohsa chu atheng chungnung ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Thempu pan hiche themmona maicham thilto thisan chu phabep khat aham doh a, thempu pan jong hiche thisan chu alah a aki thenso ding pa jetlam khut khopia abilkol geiya anunat soh ding, akeng khopi jetlam'a jong anunat peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Thempu pan jong khon dimkhat akonna thaotwi helkhat athaldoh a, hichu akhut veilam khut phang chunga asun lhah ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Hiche akhut veilam khut phang chunga asun lhahsa thaotwi chu, akhut jetlam khut junga akhoi nat ding, Pakai angsung achu vel sagi jen athin ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Akhut a umnalai thaotwi phabep chu akisutheng ding pa, ajetlam bilkola chu thempu pan anunat peh a, ajetlam khut pia jong anunat peh a, akeng phang lam khopia jong hitia chu themmo maicham thilto thisan kiloina chunga chu anunat peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Hichea thaotwi amoh chengse chu thempu pan jong aki sutheng ding pa luchang achu anupeh ding ahi. Hitia chu tiphah nat veipa chu, Pakai angsunga kithoidamna asempeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Thempu pan jong athenlounaa konna kisuh thengna le aki thoidam dingpa dia chonset maicham thilto asempeh ding ahi. Hi chu abol chai tengleh, pumgo maicham thilto jong chu atha paipai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Thempu pan jong pumgo maicham thilto le lhosoh thilto chu maicham chunga agato doh ding, hitia chu tiphah natveipa chu thempun athoidama, chuteng tiphah veipa chu theng ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Chule tiphah nat veipa chu mivai cha ahikhah a, athilto ding ato joulou tah a ahileh, themmo thilto dinga kelngoi chal khat beh ahin toding, hichu amapa kithoidamna thiltoa pang ding, chule changbong neldi thaotwi kichapsa iphah dimkhat hopsoma hop khat lhosoh thilto dinga thaotwi khon dimkhat toh jaonaa atoding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Hitobanga chu aman jong hiche khela chu, atodoh kham vakhu ni le vapal nou ni jong ato thei ahi; vacha khat pen chu chonset thiltoa ding ahin, chule vacha khat chu pumgo thiltoa pang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Miphahpa chun niget lhin ni tengleh, akisuh thengna ding kikhop khomna ponbuh kot phung Pakai angsunga, thempu henga ahin choi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Hiche themmona thilto kelngoi chu thempu pan amat ding, khon dimkhat thaotwi jaonaa thempupan anitah a, thenso thilto dinga Pakai angsunga athenso ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Chuteng amapan themmo thiltoa ki tohdohsa kelngoi chu athaa, hiche themmo thilto gan thisan chu thempu pan themkhat alah ding, hichu aki sutheng ding pa bilkol jetlam'a aloinat peh ding, akhut jetlam khutpia jong aloipeh ding, akeng phang jetlang khutpia jong aloinat peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Chule thempu pan jong ama tah khut veilama chu, thaotwi helkhat asun lhah ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Akhut veilam khut phanga kisung lha thaotwi chu akhut jetlam khut junga akhoinat ding, hichu Pakai angsunga sagi veijen athin khum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Akisu theng ding pa bilkol jet langa chu, thempu pan jong thaotwi themkhat aloinat ding, akhut jetlang khutpi le akengphang jetlang akhopi jaonaa themmo thilto thisan kiloina chunga chu aloinat cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Thempupa khut phanga umnalai thaotwi moh chengse chu, thempu pan jong aki sutheng ding pa luchanga chu anupeh ding, chuteng Pakai angsunga athoidam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Tiphah natveipa chun ajokham chabep a vakhu ni ahin, vapal nou ni ahinto ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Lhosohga thilto jouse jaonaa chonset thilto ding atodoh a chule vacha khatpen chu pumgo thilto dinga atodoh a, chuting leh thempu pan aki sutheng ding pa dia chu, Pakai angsunga kithoidamna asempeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Hiche hi mihem tiphah nat veiya akisuh thengna dinga thilto lhingsel, atoh jouloupa dinga chu dan kisem peh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Pathen'in Mose le Aaron, ajah lhona thu aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Keiman nangho gamlo dinga kapeh Canaan gamsung nalhun tengu leh, na chennau gamsunga chu, koitobang nalah uva konna insung khat a tiphah natna ka lhunsah khah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Hiche inneipu chu thempupa henglama hunga thu ahung peh ding, ka insunga natna hi lungdon aum lheh jinge, tia ahung sei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Chuteng thempu pan hiche natna chu avetchil masanga, in'a chenghon abonchauva insung adalhah diuva thu aseipeh ding; thempu pan thu aseipeh masat diu ahi. Achuti louva ahileh hiche insunga cheng jouse chu atheng louva umdiu, hitia chu mihon hiche insung chu adalhah soh tengu leh thempupa insung lut bep ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Hiche natna chu thempu pan avet chilpeh a, natna chu inbang lah a anabe khah a, adum dehduh ahilouleh asan thima akilah a ahileh, hiche natpi chu inbanga asung lut khah tah leh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Thempu pan insung adalhah a kotpi chu akal lhah ding, hiche in chu ni sagi sunga vet a um dinga kotpi akamkhum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Thempupa jong ni sagi lhin ni leh hung kit a, ahung vetlhah ding, natpi chu in bang lah a ana kithejal bea ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","Miho jouse chu thempu pan thu apeh ding, in bang lah a natpi bedenna ho chu akhodoh sohkei diu, khopamlam munsang lai khat a agase lhah diuva thu apeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Insung lam chu atheh ngim sah sohkei ding, akimvel lhung keiya akho ngimsah ding, athah jut namsah kit ding, ahinlah akikhoh dohsa chengse vang chu, khopam lam munsang lai diu khat a agaboh lhah sah diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Natpi bena song kikhoh doh chengse nung jenga jong adang akoilut kit uva, inloi namna chu alah a aloinam kit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Ibangkhat a natpi bena song jouse alah doh a asuhtheng jou ahilouleh, aloinam jou nunga jong insunga chu natpi akithe jah kit nah laiya ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Thempupa chea agavet lhah kit ding, natpi mong mong ahia insunga chu ana kithe jah kit a ahileh, hitobang natna chu mihem tiphah natna phaloutah insung hung lut ahitan, hiche in chu athenglou ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Amapan jong hiche a-in chu aphetlhah jeng ding, ain-a song ho leh thing ho chule invai kijutna jouse jong aphit ngimsela, aboncha khopamlam munsang lai khat a agahthah mang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Hiche jouse nunga jong hi, a-in hi atheng louva kikoi kotpi kikam densa ahin, koi hileh kotpi kikam sunga lut kha aum leh nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Koi hileh hiche insunga imu khapen pen jong chun aponsil akisop lhah ding chule insunga an nekha pen pen injong, aposil jouse akisop theng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Ahinlah thempu pan ahung vet lhah kit a, natpi chu insung kijut namlai hoa ana kithe jah tah louva ahileh, hichea chu thempu pan jong a-in chu athengtai, tia aphondoh ding ahi, ajeh chu hiche natpi akonna chu damna chang ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Hiche insuh theng nadia chu vahcha ni agakimat ding, cedar thing, ponsandup le hyssop pon ahin choitha ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Vacha teni lah a khat pen chu, twi long chung leibel sunga atha ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Cedar thing le hyssop pon, ponsandup jaonaa vacha ahing nalai chutoh ahin choi ding, hichengse chu twi long chunga vacha kithat thisan lah achu akoilut ding, a-in chu thisana vel sagi jen athin khum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Hitia chu ain vacha thisan toh twilong pet jaona a, vacha hing chutoh, cedar thing ahin, hyssop pon, ponsandup jaona a asuhtheng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Chujou tengleh vacha hing chu khopi sung akonna gamlah langa alha mang ding, hichea chu insuh theng na leh thoina asem ding, chuteng in chu athenga um ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Danthu hi mihem tiphah natna vei chung changa bolding dan hihen, tithah hihen, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","Ponsil le chen hihen chule inchunga hung chu jeng phah natna thudol hijongleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Apomdoh ham, adul doh ham, aboldoh hijongleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Hicheng jouse chu agomsoh a ding ahitan, atheng ding ahitai, ti photchet nadia dan thu chu ahi. Mihem tiphah nat veina chung chnaga dan thu chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Pakai, Pathen'in Mose le Aaron henga hiti hin aseipeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Israel chate jah’a seipeh lhon inlang hiti hin um uhen, pasal khat chu ahinpia thilong aum khah a ahileh, hiche thi hung longdoh chu atheng lou ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Hitia thilong doh akonna pasalpa athenglou ahitia dan kisem chu, atahsa akonna athilon chu tanglou hela ahunglon jinga, chule atahsa akonna akitang densah a ahijongleh, hiche pa chu asunga athenglou aboh uma ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Athia longpa imutna jalkhun chu atheng loua um jing ding, itobang thil hijongleh atoupha chan chu aboh a kisim ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Hijeh chun mihem koi hileh athi longpa imutna tongkha chan chun, aponsil jouse akisop ngimsel ding ama tah jeng jong twiya kisil thenga, nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Hitia chu koi hijongleh athilongpa touna mun'a toukha chan chun, aponsil jouse akisop theng ding, ama tah jong twiya kisil lha ding, nilhum keiya aboh a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Hitobanga chu koi hijongleh, hiche athilong pa tahsa tongkha chan chun, aponsil jouse akisop thenga, ama jeng jong twiya kisil lha ding, nilhum keiya atheng loua um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Chutia chu athilong pa chun mi koi tobang khat chu ngimsela aum pet a achil aset khum khah banga ahileh, aset khum pen pen chun aponsil jouse akisop ngim ding, ama tah jong twiya kisil lha ding, nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Chule hiche athia longpa touna sakol jeng jong chu atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Ipi thil hijongleh athia longpaa umsa kiti phot tongkha auma ahileh nilhum keiya atheng louva um ding ahi, hitobang thil kilah khah aum leh ama chun aponsil jouse akisop theng ding, ama tah jeng jong twiya kisil lha a, hicheng jouse nunga chu nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Koi hijongleh athia longpan akhut twiya sop ngim louva atham khat napen pen chun, aponsil jouse akisop theng ding, ama tah jong twiya kisil lha ding nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Chujongleh athia longpan atoh khah leibel kiti phot chu tekeh jeng ding, chule thinga konna kisem manchah ahikhah jongleh, hichu twiya sop ngimsel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Athia longpa chu akibol damteng, athilon jeh a suhda na achan jal'a chu amapan jong, akisuh thengna ding, ni sagi sung anga ding aponsil jouse jong akisop ngimsoh hel ding ahi. Atahsa ahinpi jeng jong chu twi long alhai lai mun khat achu akisil thenga, chuteng athenga um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Niget alhin teng athia longpa chun vakhu ni ahilouleh vapalnou ni ham ahin choi ding, kikhop khomna ponbuh kotphung bula Pathen angsunga hunglut ding, hiche vacha teni chu thempupa henga apeh lut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Vacha teni chu khat penpen thempu pan alah a chonset thilto dinga atodoh peh ding, adang khat chu pumgo thiltoa atodoh peh a; thempu pan jong athia longpa ding jal'a Pathen angsunga athoi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Pasal koi ham khat chun abotwi achedoh a ahileh, atahsa jouse twiya asiltheng ding, nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Ponsil chung lah ahin savun chung hijongleh abotwi vet lhahna chu twiya soptheng ding, nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Numei khat tou chu pasal toh alup khom naa abotwi ache khuma ahileh, amani chu twiya kisil lha lhon ding, nilhum keiya atheng louva um lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Numei khat touvin ahinpia konna thilong doh ngei chu anei teng, amanu chu nisagi sunga atheng louva um ding, koi hijongleh hiche numeinu tongkha chan chu nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Chule numei nun athi neilai tah a imut naa aneipen chu ipi hijongleh, atheng louva um jeng ding ahi; hitia chu ipi thil hijongleh atoupha chan chu atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Koi hijongleh hiche numeinu imutna jal khun tongkha aum khah leh, atongkha pen pen chun akivkonna jouse akisop ngim ding, ama tah jong twiya kisil lha ding, nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Hitia chu ipi thil hijongleh hiche numei thinei nun atoupha tongkha chan chun akivkonna jouse akisop lhah a, ama tah jong twiya kisil theng ding, nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Hiche numei thinei nun atouphana chu pasal koi hileh, atongkha chan chu nilhum keiya athenglouva um jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Pasal koi hileh hiche numei thi neinu chu aluppi noma aluppi khah a ahileh, numeinu thichu pasalpa chunga nat ahitan, pasalpa cu nisagi sunga aboh a um ding chule hiche pa lupna jalkhun chu atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Numei khattou nikho tampi athi tang louva alon khah a ahileh, athi neina ding phat jong hitalou, hitia chu athineina phat kalvala athi alon jing tah a ahileh, athilon sungsea chu numeinu chu atheng louva um ding, angaiya athi neilaia aboh a aum banga um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Athilon sungsea a-imutna jalkhun chu, angaiya athinei laiya a-imutna jalkhun banga chu atheng louva um ding; ipi thil hijongleh numei nun atoupha chan chu angaiya athinei lai banga atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Chule hiche jalkhun leh touna tongkha chan chun aponsil jouse akisop ngim ding, ama tah jong twiya kisil lha ding, nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Hiche numeinu chu athilkonna akonna boldamna achan khah leh, numeinu chu ni sagi sunga vet a um ding, chuteng amanu chu athenga kisim bep ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Niget lhin ni tengleh numeinu chun vakhu ni ham vapal nou niham chu agakimat a, hiche vacha teni chu thempu henga, kikhop khomna ponbuh kot bula chu ahin choi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Thempu pan jong vacha khat pen pen chu chonset thiltoa atohdoh peh a, chule vacha adang khat chu pumgo thiltoa atodoh peh ding, thempu pan hitia chu numeinu thilon doh thoidamna chu asempeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Hitia hi nangho jousen Israel chate athenlou nauleh aboh nauva konna nachom khen doh diu; achuti louva ahileh amaho lailunga kitung keima houbuh aboh a aumsah diu, hichea chu athenlou nauleh aboh nauva konna chu thijeng theiyu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Hitobang danthu hi pasal thinei le abotwi che doh jeh a, atheng lou aboh a umpa ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","Chule numei thinei pet thudol'a, numei hileh pasal hileh aphat achang louva ahin pia konna tang louva thilong ho jaonaa, numei athilon pat a pasal in aluppi ho ding dan kisem chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Dan toh kitoh louva Pathen angsunga thilto anabol lhon jal'a, thina chang teni Aaron chapate ni thinung in Pakai, Pathen'in Mose henga hiti hin aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Pakai, Pathen'in Mose henga hiti hin asei tan, “Na sopipa Aaron jah a seipeh tan pondal kidalna muntheng lailung, thingkong chunga um ngailut hepi touna maiya ama cham in alut nom phat chan in hung lut louding, hichu ahilouleh thi jeng thei ahi; ajeh chu hichea ngailut hepi touna chunga khu keima meiloma kilahji kahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Aaron vang hiche munthenga hi lut theia, chonset thilto dinga bongchal gol khat leh kelngoi chal khat jaonaa ahin kai ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Chule tupet ponnema kikhui sangkhol chol len chu aki ah ding, tupet ponnem a kikhui toka chol jong akichen a, chule tupet ponnem a kikhui chalchep konggah chu akong akigah a, tupet'a kikhong delkop jong akop ding, hichengse hi von lah a atheng ahin, hijeh chun thempu pan jong hiche von ho chu akivon theina din atahsa pumpi twiya kisil thengsel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Chule Israel chate khoppi apat chu kelchal nou nitah, pumgo thiltoa to dinga kelchal khat ma akimat ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Aaron in jong atumbeh a ama dinga bongchal khat atodoh ding, hitia chu amading leh a insung mite dinga kithoidamna anei masat ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Chule Aaron in jong kelchal teni chu akai ding, kikhop khomna ponbuh kotbul Pathen ansunga chu adinsah a, ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Chule Aaron in jong kelchal teni dia phun asan ding, hiche aphunsan lah a khat chu, Pakai ding chule aphunsan khat vang chu Azazel chang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Chule Aaron in jong Pakaiya dia phun, achunga phunchan chuhna kelcha chu akai ding, chonset thiltoa atodoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Hitobanga chu Azazel chan ding phun pha, achunga phunchan chuhna kelcha chu kithoidamna dinga ahing laiya todoh ding, hichu Azazel chan dinga gamlah a ahinga lha mang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aaron in jong ama tah chonset thilto dinga bongchal chu atodoh ding, hiche bongchal chu ama chonset thilto dinga akitha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Chule Aaron in jong Pakai angsung maicham phunga pat, meiam kong khat dim hichu gimnamtui lhutna ding, chule hoitah a kisemsa gimnamtui khut dimni aham doh a, hichu pondal kikhai kal lama chu apohlut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Hitia chu Pakai angsunga meikong lah a gimnamtui chu alelhah ding, chule hettohsahna dinga kido ngailut hepi touna chu, gimnamtui kilhutna meikhu chun atom sohhel ding ahi, hichu ahilouleh thinan alhun thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Chule bongchal thisan chu themkhat alah ding, akhut jung akonna ngailut hepi touna mailah a chu athe lhah ding, ngailut hepi touna mailah a chu akhut jung akonna sagi veijen athe khum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Hiche jouteng chule mipi dinga chonset thilto kelcha chu atha ding, athisan vang chu pondal sunglama achoilut a, hiche kelcha thisan chu bongchal thisan kibolna bang bang achu abol ding, ngailut hepi touna chungvum chule ngailut hepi touna maiya chu athin khum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Hitobang achu Israel chate aboh a aumna jouseu leh chonset a aumnauva konna muntheng pen chu asuhtheng ding, hitobang akonna hi ngahmun lailung chu atheng loua umji ahitan, suh thengna abolji ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Muntheng pen suhthengna dia Aaron asung lhah a ahung potdoh kit kahsea, kikhop khomna ponbuh sunga koima um thei louding ahi. Amavang ama le a insung mite chule miho dinga thensona anei ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Chule maicham phunga pumgo thilto abola suh thengna anei ding, hichea chu bongchal thisan phabep le kelcha thisan phabep alah a, maicham ninga selki hose chu anunat ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Hiche thisan chu akhut junga akhoi ding, chuteng maicham chung vum lah achu athin khum ding ahi. Hitia hi Israel te chonset jal'a maicham asema athenso ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Chule Aaron in jong muntheng pen jouse le Pakai Pathen chenna ponbuh suhthengna chule maicham sutheng naho achai kimsoh tengleh, phun phatna dia kelcha chu atodoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Chuteng Aaron in akhut teni kelcha chunga chu angap ding, chonset thil ho ahin, gitlouna jouse, Israel chaten doumah aboldoh jouseu aphondoh ding, kelcha chunga buhlhah peh banga abola, chuteng son umtah mikhat chun gammang lah a dellut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Hiche kelcha chun achonsetna ho jouseu chu, chenna loubeh gammang lah khat a apohmang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Chujouteng muntheng sung alut masanga, thempu vona kivon chengse chu kikhop khomna ponbuh lut a Aaron in aga puilut ding, hiche mun'a chu ahin dalhah diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Chule muntheng khat a kisil lha ding, akivona ngai banga kivona hichea chu ama tah chonsetna le mipi chonset thensona dinga, pumgo thilto chu anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Chule chonset thoidam nadia sathao jouse chu, maicham phunga agovam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Chule gammang lah a kelcha delmang pa chu, ngahmun ahung lhun kah a avon jouse akisop lhah ding, ama jeng jong kisil lha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Chonset thoidamna dia kithat bongchal le kelcha teni thisan jong chonset abeina thei dingin, muntheng pena kikoisa chu ngahmun polama govam ding, avun leh asa chule agil jaonaa aboncha govam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Hitia chu agouvam penpen in ngahmun asung lhah kah a, aponsil jouse asop lhah ding, chuteng ngahmun lai achu sunglha bep ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Chule hiche dan hi akhang akhanga na jui diu, lha sagi, nisom alhin nikho teng Israel chate chule alah uva cheng gamchom mihon an angol diu, na atoh louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Hou thulam dola thenna anei na ding un, hiche nikhoa chu achonset nau thoidamna nei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Hiche nikho hi nikho theng ahin, anngol ding natoh jong bol louva um ding ahi. Hitia chu dan jouse hi akhang akhanga chepi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Thempupa khela dantoh kitoh a thensona changsa, Thempu Chungnung in suh thengna kin anei ding, thempu vona kivon ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Pakai chenna ponbuh chule muntheng chungnung, maicham phung chule thempu ho jouse le mipi ho chu suhthengna abolpeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Hitia chu dan hichengse hi akhang akhanga jui ding ahi. Israel chate achonset nauva konna suhthengna thei dia, hiche kithoidamna hi kumseh a khatvei bol ding, hichu Pakai, Pathen thupeh banginMose’n jong aboltan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Pakaiyin, Mose henga hiti hin aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Aaron le achapte chule Israel chate jouse henga aseipeh dingin, bannei chan dan ho chu athupeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Israel telah a koi hijongleh, Pakai, Pathen chenna ponbuh kot phung tailouva; Pakai adia kilhaina bong, kelngoi chule kelcha that pen pen in danthu apalkeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Ama chun thisan asotah jeh a, Pathen miteh lah a konna kisimtha louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Hiche thupeh in adeisah pen chu, gammang tollah a kithat gancha jouse chu, Pakai angsunga ahin kailut diuva thupeh ahi. Kotbul lama thempupa henga ahinkai lut diu, kiloikhomna thilto dia kithat ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Thisan chu thempu pan ki khop khomna ponbuh kot phung maicham kimvel jousea athe thang ding, Pakaiya dia sathao ho chu gimnamtuiya agovam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Israel chaten Pathen ajoulhep nauva kelcha limsemthu, doihou dinga gammang lah a gancha atha kitlou diu ahi. Hiche dan thupeh hi Israel ten akhang akhanga ajui diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Israel mite hihen amaho lah a cheng gamchom mi hijongleh pumgo thilto ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Kikhop khomna ponbuh kotphung tailouva Pathen adia kilhaina sem jouse, Pathen mite holah a konna kisim thalou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Israel hihen gamchom mi hijongleh, thisan lhoh lha theng louva sa toh neh tha aum le, hichu Pakai, Pathen toh kidou ahin, amite lah akonna simtha louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Ganhing jouse hinna hi thisan akon ahi, hiche jeh achu Pakaiyin mijouse chonset suhmang ahitheina dinga, hichu maicham phunga asun lhah dinga thupeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Hijeh chun Pakaiyin Israel chate le alah uva cheng gamchom miho jaonaa, sa chu thisan jaonaa neh lou dia athupeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Israel mi hihen, gamchom mi alah uva cheng hijongleh, gamlah a saham vacha ham, houtoh kitoh a atheng, hiche ho that pen pen chu thisanso ahitan, hichu leiset avuh khu ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Ganhing hinna kiti hi thisan ahin, hibanga chu sa kiti phot Israel chaten thisan jaonaa nehlou dia Pakai thupeh ahi, koi hileh anetha chu amite lah a konna pampeiya um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Israel mi hihen gamchom mi hijongleh, gan thikam ahilouleh, sa hang ham in atha nekha aum le avon jouse akisop theng ding, ama jong kisil lha ding, nilhum keiya atheng louva um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Hichu abol tah louva ahileh, themmo chang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Pakai, Pathen'in Mose henga hiti hin thu aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Israel chate henga seipeh inlang, Keima hi nangho Pakai, na Pathen u-chu kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Nanghon na bonchauva masanga Egypt gamsunga, nachen laiyuva na chonna bang un, Keiman kahinpui lutna Canaan gam'a vang nachon louhel diu ahi. Amaho chonna dan jouse hi najui lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Nanghon na bonchauva keima chonna dan jeng nanit diu, nunle khan tohthoa keima chonna dan aboncha najui diu ahi. Ajeh chu keima nangho Pakai leh Pathen kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Hijeh chun na boncha uva keima chondan jouse le chonna dan aboncha, nun le khan tohthoa nanit jing diu ahi, hichu nit ding chua konna hinna ahiye, ajeh chu keima Pakai chu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nangho jouse leh pasal kiti phot in aki naipi ainko ham chu, ajotlut a anih ahopeh louhel ding ahi. Pakai le Pathen keima kaum jing e. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Nanu sagoh keoham, napa delchen nasut peh thei louhel ding, nanu nih chen le sil jong naho peh thei louhel ding ahi; ajeh chu ama nahingnu ahin, nangman anih chu naho peh louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Napa jinu nih chen jong naho louding, hichu nabol khah ngai ngai leh napa delchen nasut tobang ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Napa akonna na numei channu hihen, nanu akonna numei chanu hijongleh, hiche na sopi numei chu insung akonna peng hihen kholgama konna peng hijongleh, anih naho peh louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Na chapate chanu, na tunu te ham khat chu anih na hopeh louhel ding ahi; ajeh chu na tute nihchen na hodoh peh chu nangma le nangmaa kihoh doh peh tobang nahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Nangman napa jinu chanu ham, napa akonna hungpeng numei chu anih naho peh louhel ding ahi, hiche nu chu na sopinu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Nangman napa sopi numei jeng jong anih na hodoh peh louhel ding ahi, hiche nu chu napa dings sopi kinai cha ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Nanu sopi numei jong anih nahopeh thei louhel ding, nanu akonna asopi numei akinai picha ahi bouve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Napa sopipa delchen jong nalhep peh louding, ajinu jong nanailut thei louding ahi, ajeh chu nang dia nanu ngahnu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Namou nu jeng jong anih na hodoh louding ahi, ajeh chu amanu hi nangma chapa dia ajinu ahin, anih na hodoh thei louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Na sopipa jinu nih jong na hodoh peh thei louding, ajeh chu amanu chu na sopipa nabolna tobang bang hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Numei khat chu anih na hodoh pehtah jongleh, achanu chu anih na hopeh louhel ding ahi; chule hiche numei nu chapa le chanu hihen achanu hijongleh, anih hodoh dia na kipui thei louding, amaho cheng chu nangdia na kinaipi tikhat nahiuvin, hichu nabol khah tah leh gitlounaa chon chu na hitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Chule numei khat chu asopinu dam lai sung sea, asopinu chu anih hodoh peh dia napui thei louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Numei chu a thinei pet a na nai lut a anih na hopeh louhel ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Nangman kiphal theng tah dana na in hengpa jinu chu luppi ding lung na vop louhel ding, amanu chutoh chonset a na lhalut a na kisuh boh thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Na chate khat a khat cha jong meiya govam ding chule Molech adia na todoh louhel ding, hiche hoa konna chu na Pakai le Pathen min nasuh thang theilou ding ahi, ajeh chu keima Pathen kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Pasal hi numei tobang banga na luppi thei louhel ding, hichu thet umtah thil bol ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Kiphal theng tah dana gancha nanai lut a na luppi louhel ding ahi, hitobang chu chonset ahi bouve, numei jeng jong kiphal thengtah a gancha angsunga konna kido louhel ding ahi, hichu conset lah a gitlouna lenpen khat ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Hichengsea kon hin nangho chonset a lhalut hihhel un, ajeh chu keima tah in nangho masang a namtin vaipi kadohna chu hitobanga ana chonset khah jih-u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Hitia chu gamle leiset jong ana suhboh uva ahitai; hichea konna chu themmo channa talent kamat sah ahin, hitobanga chu agam leiset a cheng mite jouse jong acham loua kitol mang ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Nanghon na boncha uva keima chonna dan ngai le ka chonna jouse hi nit sohkeiyun; agama cheng hihen ahilouleh, nalah uva konna hung kholjin hijongleh, hitia thet umtah thil ho hi khat a khat cha jong nabol thei louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Ajeh chu thil thet umtah hicheng jouse hi, nangho masanga cheng mite nana bolu ahitan; hiti chun agam jeng jong ana suboh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Tun nang hon agam hi suboh kit leuchun, nangho masanga ana cheng namtin vaipi te bang banga chu nache doh jeng diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Koihijongleh hitobang thil thet umtah a konna chonkha aum ngai ngai leh, hitobang bol kha mihem chu nangho jouse lah akonna pampeiya um jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Keima thupeh hi nanit jeng diu, namasang uva mite nana bolsau thet umtah chondan chengse hi, nabol louhel diu ahi, hichea kon chun kisuboh hihhel un, Keima hi nangho Pakai le na Pathen u-kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Pakai, Pathen'in Mose henga hiti hinaseipeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Israel chate jouse kikhop khomnaa hiti hin seipeh tan, na Pakai le na Pathenu keima then bang banga hi nangho jong nathen diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Nalah uva koi hileh nu le pa jabolna nanei cheh diu, keima cholngahna nikho jeng jong nanit cheh diu ahi, keima hi na Pakai ule na Pathenu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Milim doi kisem thu houhih hel un, milim doi jong semthua jabolna chansah di gohih hel un, Pakai le na Pathenu keima kaum'e. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Nanghon chamna thilto ahin, kilhaina gantha ahin Pakai henglama todoh ding nanop uva ahileh, nangma cheh jong santhei dolin kisemtoh masauvin lang, chuteng hichu nakatdoh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Nathil to chengseu chu akikatdoh nikhoa neh chai ding, ajing nikho chan kat ding neh thei pai hi ding, hitia chu nithum lhinni geiya amoh chengse chu aboncha meiya govam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Nithum lhin nikhoa hiche thilto nekha chan chun, athil kitoh doh chu thet umtah ahitan, santhei dol ahi tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Chule koi hijongleh hiche sa nekha chan chun ama cheh in themmona akipoh ding ahi; ajeh chu aman Pakaiya thiltheng asuh thang ahitan, ama chu amite lah akonna pampaiya um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Chule nang hon leiset gasoh nachop khom tengu leh, nalou beh uchu apam chin geiya nachop khom lou diu, chule changphal jeng jong changpal geiya chom louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Chule na lengpi gui jong ngimsela nachom louding, na lengpi lei laiya lengpithei ajam thang ho jouse jong nalo ngim louding ahi, hichengse chu vaichate le kholjin hodia nakhen tei ding ahi, keima hi Pakai na Pathenu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Guchat kiti bol hih hel un, koi hijonglehu chun naheng nakom cheh u jouva nabol louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Keima min pana jouthua koima nalhep lhah louhel diu, hiche hoa chu na Pathen min nasuhchat veilou ding ahi; keima hi Pakai kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Nang man naheng nakom nachoma nasuhgim thei louding, thalah soh natoh man jong pelouva najan khovah sah louding, peh ding dol napeh ding ahi, keima hi Pakai chu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Na-ngong mi jong nagaosap louhel ding chule mitcho masang jenga jong aki pallhuh nathei ima nakoi louding, hiche ho sanga chu na Pathen gin ding hi na thupi sah ding ahi, keima hi Pakai chu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Nanghon thu natan tengu leh adih louvin tanding go hihhel un, vaichaho chunga langneina nanei ham, ahilouleh milen ho chunga jong khentumna ima nabol louding ahi. Ahinlah thu chu adihtah a naheng nakom chunga natan ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Nangma mikahlah a thuse polea chesuh chetou nabol louhel ding, chule naheng nakom jeng jong athi nathei ding nagela na kidou pithei louding ahi. Keima Pakaiyin kaumpi jing uve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Na lungthim sung akonna naheng nakom na thetbol louding, hiti sang chun naheng nakom in atohmo thudol'a phatah a naki houlimpi joh ding ahi, ajeh chu achunga phatlouna lhung thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Nangman namite lah a konna achapateu chunga phulahna nabol louding, tahsa lunghimona jong nei hihhel in, chuti sang chun nangma na kingailut banga, naheng nakom nangailut ding ahi, keima Pakai kaum jing e. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Na bonchauva keima chonna dan jouse nanit sohkei diu ahi, na gancha ho chu jatchom chom na kitimat sah a, na kingai sah louhel ding, na loulai jenga jong muchi jatchom chom na tuhel louding, chule ponsil jatchom cheh a kikhui von na tahsa chunga navon louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Pasal koi hileh huh jeh a numeiya kicho doh loulai, chamlhatna jong kipe nailou, ahinlah pasal chom khat toh kitepsa khat chu aluppi tah a ahilea, hichu phatah a kholtoh masat a, anumeinu chu chamlhatna kichansah nailou ahin. hijeh achu thina chan mochan sah louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Hiche mihempa chun athemmo thilto ding, ama ding mong monga kikhop khomna ponbuh kotpi maiya Pakai angsunga ahin kai lut ding, hichea themmona thilto ding chu kelngoi chal khat hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Hiche themmona thilto hiche mipa chun abol jeh achu, thempu pan jong themmona thilto kelchal chu Pakai angsunga thoidamna anei peh ding, hichea chu chonset abol khahna akonna ngaidamna chang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Na bonchauva gamsung nahung luttengu leh, thing agathei natu jouseu aga masa chengse chu mihem chep kitan peh banga nagel diu, kumthum sunga thingga jouse chu cheptan lou ahitia, nagel cheh diu ahi. Hiche thingga ho chu koiman aneh thei lou lai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Kumli ahung lhin teng chule hiche kuma chu thingga jouse aboncha, Pakai angsunga thangvahna kut khat a thensona um cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Chule kum nga lhin teng thingga jouse chu naneh thei diu, nang hon gamga jouse chu nangma nangma ding cheh a nakilo lhah jeng thei u ahitai. Pakai na Pathenu keima kaum jing e. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Nanghon ipisa hitaleh athisan pum in netha hihhel un, phun jong sanghih unlang mitpheldoi kiti jong choi hih hel un. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Nachal samu jong som hih unlang, nabeng mul-u jong among lamse natan thei lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Mithi hojeh in natahsa chungu atpop ding go hih unlang, na tahsa na tichung hou na atkeh louhel diu, na tahsa cheh uchu milim hoa khat chan nasem thei lou diu ahi, Pakai kitipa keima kaum jing e. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Na chanu chu aki joh a pansah ding got dan lang, na kisuh bohsah louhel ding ahi, achuti louva ahileh gamsung pumpi jeng jong akijoh a pang ding, hitia chu gamsung pumpi phatlounan ahinlo jeng thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Keima cholngah nikho jouse chu nanit cheh diu, keima muntheng jong jabolna nanei jing diu ahi. Keima na Pathenu chu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Doithem ho leh lhagao phalou ho heng jong jon louvin don jong don hih un, hiche ho chu gellut daovin lang, hiche ho chun kisuboh khaget un nate, Pakai na Pathenu keima kaum jing e. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Tehse lukang jabolna napeh a amasanga na dindoh ding, upa masanga jong jabolna nanei ding chule Pakai na Pathen jong nagin jing ding ahi, keima Pakai kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Kholgam mi khattou toh na gamsunga kholjin khomna nanei leh, na boncha uvin hiche kholjin mi chu aphalouva nabol thei lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Na lah uva hung kholjin le kholgam mi chu nalah uva konna peng doh banga um jing ding, hiche kholjinpa chu nangma cheh na kingai bang bang uva nangailut cheh diu ahi, ajeh chu na boncha uva Egypt gamsunga ana kholjinsa nahi tauve, Pakai na Pathenu keima kahi jing e. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Thu natannau mun jouse, ipiham khat tou adung avai natenau ahin chule thil ajat nasim nau hijongleh, adih louva nabol louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Lep toh le ding thil jouse jong dihtah a kitoh del dela nakoi diu, thil agih tena jong adihtah naman diu, ephah jong akitoh chet chet naman diu adihtah chu naman diu ahi, keima hi Pakai na Pathenu kahin, Egypt gam'a konna nahin puigal kaipau chu kahi jing e. ");
INSERT INTO tczchongthu_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Hijeh chun nabonvchauvin keima chonna dan jouse kachon dan aboncha keiya na jui uva, nabol jing diu ahi, keima Pakai kahi jing e, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Pakaiyin Mose jah a hiti hin aseipeh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Israel chate jah in seipeh tan, Israel chate lah a mihem kiti phot hihen, chule ahung kholjin kholgam mi hijongleh achateu Molech houna dia tohdoh aum leh, thina chang jeng ding, amapa chu gamsung cheng miten songa aselih jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Chule hitobang mihem chu keiman jong kaki doupi ding, amite lah akonna hitobang mihem chu paidoh a umjeng ding ahi; ajeh chu aman asunga konna pengdoh khat chu Molech houna din atodoh in, hichun keima muntheng asuh boh ahitan, kamin jong asuh chatvei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Ahilou jongleh gamsung cheng miten, hiche pan achate Molech houna dinga atodoh chu akimu mosah khah uva, thana chan dinmun'a konna ahoidoh sah khah tah ule, ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Kei matah in hiche pa douna chung chona a insung mite dounaa kahung kilah jeng ding, ama jong chule ama nungjuia pang Molech houna'a kimangcha akijoh sese chu abonchauva, amite lah uva konna kapampai jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Mihem koitobang lhagao dihlou ho leh doithempuho tahsanna neiya amaho juiya apan khah leh, amaho nung ajuiya akijoh ho chona achon tah ahileh, keimat ah in hitobang chonna akonna chu kamai kahin lah jeng ding, hitia chu ama chu amite lah akonna pampaiya um jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Nang ma cheh kithenso unlang atheng in umdoh jeng tauvin, ajeh chu keima Pakai na Pathenu chu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Chule kachonna dan jouse nanitsohkei uva, hichengse chu nanjui cheh diu ahi, keima nangho jouse sutheng na Pakai uchu kahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Koi hileh nalah uva apa ham anu ham, gaosapna neiya naum uva ahileh, ama chu thina chang ding ahi, aman amapa ahilouleh amanu agaosap tah jeh chun, athisan chu ama chunga chu ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Pasal koi hileh aheng akompa jinu chu achonset pikhah tah leh, ajongpa ahin ajonpinu jaonaa anilhona thana chan chang lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Koi hileh apa jinu toh lumkhom aum khah le ama chun apa delchen alhep peh ahitan, ani lhona thina chang jeng lhon ding, thisan soman jong ama nin achung cheh lhona akipoh lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Amounu luppi pasal aum khah jongleh, amapa ahin amounu jong ani lhkonna thina chang jeng lhon ding ahi, ajeh chu chonset gitlouna chu abol khah lhon ahitan, thisan soman jong achung cheh lhona akipoh lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Numei kilup khompi bang banga pasal khat chun pasal khat a luppi tah a ahileh, thet umtah a chonkha ahilhon tan, ani lhona thina chansah jeng ding, athisan kisona lhon kisona chu ama cheh in akipoh lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Numei khat jaonaa anu jong ji dinga akipui tha khah a ahileh, hiche pasalpa chun Thil phalou chungnung abol khah ahitan, pasalpa jaonaa numei teni ahin, abonchauva meiya govam heldiu, ajeh chu nalah uva hitobang thilse avel'a aum kit louna ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Ama kiphal thengtah a gancha lup khom pi pasal kiti chu thadoh jeng ding ahi, a kitimatpi gancha jeng jong chu natha doh jeng diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Gancha kitiphot kom'a gachea kitimatsah ding gela kido numei chu, gancha ahin numeinu ahin natha jeng ding, hitia chu ani tah lhona thana nachan sah a, athisan lhon sona chu amani chung cheh a mo akipoh lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","A sopinu apa chanu ham ahilouleh anu chanu ham kipui aum leh, apan amanu chu anih alhap peh ding amanun apa del alhep peh ding, pasal pan jong sagoh keova aum chu avet a, numei nun jong hiche pa sagohkeova aumchu avet peh khah tah leh, hichu jachat na lah a jachat sangpen ahitan, hitia aum khah lhontah jeh achu achate ahilouleh amite lah akonna pampaiya um jeng ding ahilone, hiche pa chun asopinu nih alhep lhah peh ahitan themmona chu aman akipoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Numei in phat ngai banga thi aneiya, hiche pet achu pasal in alup pia ahileh, anih alheppeh a sagoh keova alupsah a ahileh, hiche pa chun numei thisan hung potdoh sagoh keova alupsah ahin, chule amanu jong athisan lonlai tah a lumlha jeng ahitan, hijeh achu hiche teni chu amite lah’a konna pampaiya um jeng lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Nanu sopinu ham na pa sopinu ham nih chu na sut thei louhel ding, hitia kibol chu a inko puma akeova ajam ahitan; hitia chon ho chun themmona ama cheh in akipoh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Apaneo jinu luppi pasal chun apaneo del asutpeh tobang ahitan, hiche pasalpa le numeinu chun achonset lhon akipoh cheh lhon ding, cha hingthei louva thi lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Asopipa jinu jidia kipui pasal aum khah tah leh, hiche pa chun dihlouna aboldoh ahitan, hiche pa chun asopipa delchen asut ahitan, hijeh a chu numeinu jaonaa anilhona thi jeng ding ahi lhone. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Nabon chauvin keima chondan le ka chondan jouse najui sohkei diu, aboncha keiya nabol tahtah diu ahi, chuteng na chenna diu gamsung ka puilut nauva konna hi kapaidoh louding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Chule nangho masanga kana paidoh namtin le vaipi ho chonna bang chun, chon hihhel un; ajeh chu hitobang hoa chonna hinkho ana mantah jeh un, keima adia amaho chu thet umtah anahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Hiti hojeh a chu najah uva ka seipeh nahiuve, amaho chenna gampumpi nang hon nalosoh uva, keiman jong hiche gam'a bongnoi le khoiju lkonna hi nalo nadiuva kapeh nahi tauve, tia kasei ahi. Namtin vaipi lah a nangho atuma lheng doh achu na Pakaiyu le na Pathenu keima hi kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Hijeh chun na boncha uvin satheng le satheng lou chu hom khen unlang, vacha atheng ahin athenglou ho nakhen diu; hitia chu hiche ganhing ho ahin, vachate ahin tollhanga kithol tho hijongleh khat a khat cha nakisuh boh thei lou diu ahi, hichengse hi athenglou aboh a kase khen sa ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Na bonchauva keima dia athenga naum diu, keima hi Pakai kitipa athenga um chu kahin, keima mite nahi na diuva namtin le vaipi lah akonna kalhen dohsa chu nahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Pasal hihen numei hileh lhagao phalou vop a pang ham, mitphel doithem ham, ani gela thina chansah jeng ding ahi lhone, songa selih jeng ding, athisan sona jal'a mona jong amaho chung cheh a lechuh ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Pakaiyin Mose henga hiti hin aseipeh in, keiman kathupeh chengse hi Aaron chapate thempuho jah a seipeh tan. “Thempu koi hileh aheng akom thivuina kina, panga kisuboh thei louding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Inko khat akinaipi hichu anu ham, apa ham, achanu ham chule asopipa ham ahikhah louleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Asopinu chu nungah laileh atheng hinalai ahileh, hichenu chu ajipa um nailou ahin, amadia jong insungkhat a umnalai ahin, asopinu chunga vang hi athilong aop a kisuhboh thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Pasal khat mipa dinmun ahinunga amite lah a kisuh boh louhel ding, ama le ama jeng jong kisunoh phah louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","ama hon aluchang-u akihotol thei loudiu, abeng mul jeng ujong akivo chai lou diu, chule atahsa jeng ujong timaha um thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Abonchauva Pathen adia atheng hidiu, a Pathen pau min asuh thang louhel diu ahi, ajeh chu amaho hina Pathen pau nehdia changlhah thilto jouse Pakai lama ahinto doh jio ahin, hijeh achu amaho hi athenga umdiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Numei aki johsa kiti jong akichen pithei lou diu, ajipa khat in adalhahsa numei jong chu akichenpi thei louhel diu ahi. Ajeh chu hiche thempu chu a Pathen pa dia atheng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Nangman ama chu thensona nanei peh a, ajeh chu amapan na Pathen adia changlhah atodohji ahin, ama jong nangdia atheng ahin, hiche jouse chunga hin nangho thensoa pang Pakai keima hi, atheng jing kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Chule thempupa chanu chu akijoh a apan khah a ama le ama akisuh boh khah tah leh, hiche nu chun apa jeng jong asuhboh ahitan, hitia chon numei kiti phot chu meiya govam hel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Chule asopi holah a Thempu Chungnung penpa, angaiya alua kinu thaotwi kinusa, vontheng ngena kivon dinga thenso nachang khat chun, asam alhaiya putda henlang, aponsil jong akehlai aumsah louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Apa hihen anu hijongleh mithi long anailut a, ama le ama kisuboh thei louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Muntheng lai chu adalhah a hiche muntheng chu asuhboh thei louhel ding ahi, ajeh chu ama hi a Pathen akonna thensona thaotwi akinu chu achunga akipoh le ahitan, keima Pakai chu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Chule amapan jong aji ding nu chu, nungah theng ahiphat a akipui ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Meithai hihen akidasa hijongleh, chule akisubohsa numei hihen akijohsa hijongleh, amaho tobang chu thempu pan ji dinga akipui thei louhel ding, amaji ding chu amite lah a kon mong mong nungah thengset akipui ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Hichu abol teng amite lah a chu ama chate jeng jong asuhboh tah louding, ajeh chu amapa thensoa pang chu keima Pakai kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Chule Pakaiyin Mose hengah thu aseiyin, hiti hin bolin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Aaron jah a seipeh tan, nason na chilhah te ho chu akhang akhang uva, abonchauva atahsa chunga losapna nei jouse a Pathen dinga changlhah tohdoh dia hungsung lha thei louding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Koi hileh tahsaa losapna nei chu, amitcho hihen, a elbai hihen, anah jom hihen atumpoh hijongleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Mi koi hileh akeng phang ham ahilouleh, akhut kisuh boh ahikhah a, ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Chule atingbong ham adung nem amitkho mulou, tiphah natna ham, atibol lha jeng ham atilchang kisuh keh aum leh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Aaron chapate lah a konna hitobang atibukim lou puma, Pakai dia pumgo thilto tohdoh a pangthei louhel diu ahi, amapa tahsa chu aboh nei ahitan, hijeh achu a Pathen dia changlhah tohdoh a hungsung lhate hi louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Ama chuna Pathen dia changlhah kitoh doh chu aneh thei ding, thil thengho chule atheng pen thil dang ho jong chu aneh thei ding ahinai, ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ahinlah pondal phung hung lut a maicham phung jeng jong ajotpa louhel ding ahi, ajeh chu atibah kimlou ahitan, keima muntheng penchu asuhboh louhel ding ahi. Thempu jouse sutheng chu keima bou kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Hicheng jouse hi abonchan, Mose’n Aaron ahin Aaron chapate jouse jah a anathupeh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Pakaiyin Mose henga, thu hiti hin aseipeh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Aaron leh achapate henga seipeh unlang kamin theng asuhboh louna diuvin, Israel chate akonna thiltheng aboncha keima lama ahin todoh a houva konna akidalsena diuvin seipeh in, keima Pakai kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Hiti hin seipeh tauvin, nang hon nakhang nakhang uva nachilhah teu chan geiya, then louna chang puma Israel chate jousen thil theng kitiphot ajot a asung lhah jeng a ahileh; ama chu ka angsung akonna paidoh a um jeng ding ahi, ajeh chu keima Pakai chu kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Aaron chilhah kitiphot koima chan miphah hihen, athi long puma natna thoh hijongleh athen kahsea thil theng cheng chu aneh loubeh ding ahi. Koi hijongleh hiche hi thil thenglou ahitai tia, ahivanga tongkha nah nah chun mithi long tongkha hihen botwi potdoh jeh a athenglou ahitia kisei tongkha aum jongleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","Aop lhanga kithol tho ipi ganhing hile aboh ahitia, ahivanga tongkha chule athenlouna akon kilason thei asuh khahna akon aboh aum thei hijongleh, mihem a dia aboh ahina thei kiti poupou chu, ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Koi hileh hiche tongkha pen pen chu nilhum keiya aboh a um jeng ding, atibah pumpi twi a kisil lha ding achuti louva ahileh, hiche mihem chun thiltheng kiti aneh thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Chule nisa alhum tenglehvang ama chu athenga umkit ding ahitai, hitia chu thiltheng ho jong aneh thei ding ahi, ajeh chu aboncha amapa dia chu hinna anneh a anei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Koi hileh sa thikam ahilouleh gamsa hang in athasa kiti phot aneh louding, hichu ne-in ama leh ama kisuboh hih hel hen, keima Pakai kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Hitia chu kathu lhah hi phatecha anitsohkeidiu, hichu ahilouva ahileh abonchauva chonset anei khah teidiu, thiltheng chu ahin suhkhah tengu leh, thina chan achung uva lhung ding, amaho jouse suthenga Pakai chu keima hi kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Thiltheng kiti phot ahung gamvaikon hon aneh theilouding, thempu kom'a hung kholjin hihen asoh thagoi hijeng jongleh thiltheng chu aneh thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Thempupa dia asoh ham, suma achohdohsa ham, ahilouleh ama insung tah a pengden ham vang chun thempupa dia kipe neh leh chah ho chu nethei nante. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Thempupa chanu ham khat chu thempu hilou khat toh akichen leh, thilto thengho aneh thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Meithainu ham, akidasa numei ham, cha hinglouva um hichu apa inlama hung kile kit a apa jeng jong kingainaa neikit chu, thempu hina jal’in apan amu thil chengse vang chu aneh thei ding ahi. Hitia chu thempu insung kon hon bou hitobang thilto ho hi aneh thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Thempu insung hilou ima hetoh louva thilto thengho nekha aum leh, ama chun aneh doh jat man thempupa henga alepeh ding, hitia chu aman jat mong mong jakhat a somni to apeh tha jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Thempuhon thilto theng Israel ten Pakai henga ahinto houchu, asuhboh thei lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Nehsah dia lomlou ho anehsah da jeng diu, hitobang chu aneh sah angai ule themmona chule talent matnaa kibol doh jeng thei diu ahi. Keima Pakai chu kahin, thilto jouse sutheng pa chu kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Pakaiyin Mose jah a aseipeh in. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Abana kisei chondan jouse hi aboncha Aaron le achapate chule Israel te seipeh dingin athumop tan ahi. Israel ham ahilouleh Israel gamsunga ahung cheng midang koiham khat chun pumgo thilto ato tengleh, deilhen thilto hihen, kinepna dia lolhinsah ding thilto hijongleh, hichu nolna beihel gancha bou ato thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Santhei ding dol chu ahileh achal hi ding, hichu nolna beihel hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Nolna nei gancha tohdoh chu Pakai adia santhei dol hilou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kitepna bulhitsahna ham, deilhen tum adia thilto ham, Pakai heng lama kikhop khomna dia todoh chun nolnabei ato le bou santhei dol hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Gancha amit khomu lou ham, a elbai ham, ati bukim lou ham, atiphah ham, atibol ham, apat ham khat chu Pakai dinga nato doh thei louhel diu ahi. Thilto doh chu neh le chah ding ahijeh in, hitobang ho hi maicham phunga pehda jeng uvin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Deilhen chombeh thilto din natna neiya, akhang theilou tibu kimlou hijongleh todoh jeng thei ahi. Ahinlah hitobang ho chu kitepna molso nadia vang santhei dol ahipoi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Gancha atil kilasa ahin, akisukeh saham, akigot kehsa ham chu, Pakai henga nato lou diu ahi. Hitobang chondan kiti hi, nangho gamsunga najom thei lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Gamchom mi akonna kichosa gancha kiti chu nehthei ding thilto kitia natodoh lou diu, hitobang gancha hi nolnaa dim jeng ahin, santhei dol ahipoi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Bongham ahilouleh kelngoi ham kelcha hamkhat chu anou aso tengleh, hichu nisagi alhin kahsea apitoh nakhen theilou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Ni sagi jou tengleh vang, hichu neh leh chah thilto dinga santhei dol hibep ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Nikhat sung chun bongpi anou jaonan chule kelngoi api chutoh, kelpi le anou chu ki lhaina nabol kop louhel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Pakai lama thangvah thilto na todoh tengu leh, santhei ahina tei dingin, abol ding dan kisem jouse hi abonchan jui cheh un, ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Hiti chun nathilto doh nikho mama chun nechai jengun, ajing nikho chan in naneh moh houchu khen hih hel un, ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Pakiyin aseiye, ka thupeh chengse bol un ajeh chu keima Pakai kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ka mintheng hi suthang hih hel un, Israel pumpin kathen dan joh seiphong hen, keima Pakai chu kahin, keiman ka suhtheng nahiuve, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Nangho Pathen hina dia Egypt gam'a konna kahin pui galkai nahi tauvin, keima Pakai chu kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Pakaiyin Mose henga thu aseiyin, hiti hin bolin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Israel chate jouse jah a seipeh tan, Pakai dia phat tepsa kut na bonchauva atheng ahitia na phondoh cheh diu, keima dia hiche phat tepsa kut ho chu ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Nigup sunga mihon na akitoh cheh ding, nisagi lhinni vang chu imacha bol louva ki choldo nikhoa nanei cheh diu, hichu thengsel'a kikhop nikhoa ding ahi, hiche nikho kitia hi natoh nabol thei louhel diu ahi. Hoilai chana cheng jong leu chun, hiche nikho hi kicholdo nikhoa nanit jing diuva thupeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Hicheng hi Pakaiya dia phat ana kitepsa kikhop khomna theng chu ahin, hitobang nikho jousea hi aphat kitepsa dung juicheh a, nang hon mi nakou khom diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Lhamasa nisom le nili lhin nikho, hiche nilhah lam vang chu Pakai dia Kalchuh Kut hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Chule hiche lhasung nisom le ninga lhinni chu, Pakai dia cholsolou Changlhah Kut nikho ding ahin, ni sagi sung vang chun cholsolou changlhah tang loua naneh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Nikho masapen nileh na bonchauva khompi theng naman diu, lel nathei na natoh lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Ni sagi sungsea chu Pakai dia govam thil tang louva na todoh diu, ni sagi lhin nikho vang leh khompi theng nikho ahitan, hiche nikho tengchu leh na bonchauva na kichol diu lelna thei na natoh lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Pakaiyin Mose henga thu aseipeh in, hiti hin bol in, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Israel chate henga ajah uva hiti hin seiyin, keiman kapeh nau gamsung nahin phah uva gamga soh nahin lo tengu leh, nachangphal gao masapen chu thempupa lama nachoi diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Hichea konna chu thempu pan nangho santhei dol nahi theina diuva nathenso diu, ajing nikho cholngah ni tengleh thempu pan thensona anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Hiche thensona kibol nikhoa changpal natodoh tengu leh, kelngoinou achal khat jong Pakaiya dia nolnabei hel chu nakatdoh tha diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Hiche nikhoa lhosohga todoh ding chu, suhlou changbong neldisel Ephah khat dim, hopsoma hopni kiso ding; hichu thaotwi toh kihal, Pakaiya dia gimnamtui sela govam ding, don ding lengpithei jong chu khon dimkhat hoplia konna hopkhat chu hichea ding chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Chule hiche nikho masang chun, na Pathen pa diuva thilto ding nahin pohlut kahseo vin, changlhah jong nehdao vinlang, chang kikang poh ahin changlhah kigou tho jong nehdauvin, hoilai chana cheng jong leuchun hicheng hi nakhang nakhang uva chonna dan in jui jingun. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Cholngah nikho aki chai apat, changpal nahin choi uva, thensona thilto nabol nikho uva pat nikho nasim cheh cheh diu, hapta sagi chan nasim diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Cholngah nikho vel sagi chan geiya nasim uva chule ajing nikho nisomnga lhin chan geiya nasim tha diu, chujou tengleh Pakai heng lama lhosohga thilto natodoh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Na inson cheh uva pat Ephah dim khat cheh hopsom lah a, hopnia kikhen thenso thilto dinga changlhah lhonsao ni jaona nahin choi diu ahi, hiche teni chu cholsosa ahin, Pakaiya dia lhohsoga masapen thiltoa pang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Chule hiche changlhah jaona chu kumkhat lhing tasa nolna beihel kelngoi sagi, bongchal golpai khat, kelngoi chal ni jaona nakatdoh uva, hiche gancha ho chu Pakaiya dia pumgo thiltoa kimang ding gimnamtui sela meiya govam ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Chonset thilto dingin kelchal khat mang unlang, chamna thilto le gantha ki lhaina dinga kum khat a tah kelchal ni nahin kat diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Chule hicheng ho chu thempu pan Pakai angsunga thensona anei ding, lhosohga masa thilto changlhah jaonaa, kelngoi chalteni jong chu athenso tha ding ahi, hiche hose hi thempu dia Pakai angsunga thil thengsel'a um ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Hiche nikhoa hi khompi khat nanei diu, hichu khompi thengsel'a naman uva, lel nathei natoh nabol lou diu, na khang lhum keiyuva hoichana chejong leuchun, hiche hi chonna dan dungjuiya najui jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Na bonchauva na gamsung uva konna chang na-at tengu leh, na lou jao uchu apam chin jousea na-at chai lou diu, nachang at na nung uva chang khai ho jong nachom thengsel lou diu ahi; vaichate leh kholjin hodia na koipeh diu ahi, ajeh chu keima nangho Pakai, Pathen kaum jing e, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Pakaiyin Mose henga thu aseipeh in hiti hin bol in, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Israel chate jouse jah a hiti hin sei peh tan, lha sagi lhin teng, hiche lhasung nimasa nileh na bonchauva naki chol uva khompi theng nanei diu, sumkon mutgin tothoa naphon jal jidiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Thabeina thei natong hih un, Pakai henga pumgo thilto nahaimil lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Pakaiyin Mose henga thu aseipeh in, hiti hin bolin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Lha sagi lhin nikho nisom alhin nikho hi ki thoidamna ahin, hiche nikhoa hi thonlouva khompi theng khat nabol diu, anngol tothoa Pakai dia pumgo thilto nato doh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Hiche nikhoa hi koima chan thabeina thei natoh nabol lou diu, ajeh chu kithoidamna nikho loupi khat ahin, na Pakaiyu leh na Pathenu henga thoidamna nanei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Koi hijongleh hiche nikhoa anngol lou aum leh, amite lah akonna pampeiya um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Hitia chu koi hijonglehu chun, hiche nikhoa hi thabeina thei natong aum khah leh, ama chu amite lah a konna ka suhmang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Na bonchauva natoh thilbol akon na nakikangse cheh diu, hoilai mun'a hijongleh na chenna jouseuva chonna dan ahitia, najui cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Hiche nikho hi na boncha diuva kicholdo nikhoa naman jing diu, hitia chu anngol tothoa, hiche lhasung nikho ahung lhin niapat, ajing nilhah lam chana choldonaa naman cheh diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Pakiyin Mose henga thu aseipeh in, hiti hin bol in, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Israel chate jouse henga seipeh tan, lhasagi lhinna chule nisom le ninga lhin nikhoa pat, ni sagi sungse hi Pakaiya dia ponbuh kut a kimang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Kut akipat nikho chu khompi theng nikho ahin, hijeh chun thabei nathei natoh ima bol-hih un, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Tanglouhel a ni sagi sunga Pakaiya dia thilto nabol jom jing diu, niget alhin nikho tengleh khompi theng khat nabol diu, Pakai ansunga pumgo thilto nakatdoh diuchu ahin, hichu khompi theng laitah ahijeh in thabei nathei natoh akon nakikangse cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Achunga kimin phah chengse hi, Pakaiya dia phat tepsa kut ho chu ahin, hiche nading chun Israel chate koukhom sohkeiyun lang, khompi theng tothoa, thilto ding ho ahin, pumgo thiltonaa naman diu, anikho mama a abol ding dan jouse govam ding hihen, donthei lengpitwi hijongleh, nabol diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Hiche ho jouse hi na bonchauva Pakaiya dia na thiltou hichu deilhen choma na thilto uva ahitan, chule athenso ho jouse jaonan, nathil pehdoh jouseu leh Pakaiya dia cholngah nikho le adang dang nanit kimsel hou kisim tha lou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Lhasagi chan nisom leh ninga lhin nikho leh, na bonchauva gamsung lho sohga nachop kimsoh niuva pat nasim uva Pakaiya dia ni sagi sungsea kut tang louva nabol jom jing diu, hiti chun kut akipat nichu choldo nikho theng hi ding, niget lhin nichan chu choldo nikhoa naman diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Kut kipat nikho teng thingga ahoilai nalo lhah diu, lusuna tampi jaona, thingboh phatah tah na helhah diu, vadung pang lah a tomdo he tohthoa, hicheng chu na kichoi uva, na Pakaiyu leh na Pathenu angsunga tang louva nakipa jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Kumkhat seh le Pakai heng lama ni sagi tang louva kut khat nabol jing diu, hichu nakhang lhumkei uva chonna dan ngaiya naman chah jing diu, lhasagi lhinna lhasung achu naman diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Ni sagi sunga na bonchauva lhambuh a nachen diu, Israel sungkon agammi cheng aboncha lhambuh sunga cheng ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Hichea kon chun nachilhah teuvin keima tah in Egypt gam'a konna, Israel chate jouse kahin puidoh chun lhambuh sung a bou kachen sah ji'e ti, ahin hetdoh thei diu ahi, ajeh chu keima hi na Pakaiyu leh na Pathenu kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Mose’n Pakai dinga phat tepsa kut ho jouse chu, Israel chate jouse lah a aphondoh peh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Pakaiyin Mose hengah thu asepeh in, hiti hin bol in, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Israel chate ho henga seipeh tan, mit thei louhel ding vah jing din, olive thaomei chu nahin choipeh nading un seipeh tauvin. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Ki khop khomna ponbuh hettohsahna pon kilang doh, hiche mun'a chu Aaron in thaomei kivah chu tang louva avet kol jing ding ahi. Hiche thaomei hi Pakai angsunga nilhah muthima pat jingkah khovah geiya kivah khovah hel ding ahi. Hiche hi nakhang lhumkei uva chonna dana nanei jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaron in jong Pakai sana thaomei khom phunga chu, hiche thaomei kivah jouse chu avah jingnai ti, photchetna avetkol jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Chule nangman changbonga kigoidi chu nalah ding, hichu changlhah lhonsom le ni nasoa naken ding, lhonkhat cheh chu Ephah dimkhat hopsoma hopni lhingsela kisem hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Changlhah nasemsa chu golni nia nagol ding, golkhat achu changlhah lhongup pang ding, sana thengsel'a kisem touna chunga chu nagola nakoi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Gimnamtui nalah a changlhah golkhat chu nasun den ding, hichu nangman nato doh changlhah toh chun Pakaiya dia govam thiltoa kitoh doh tha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Cholngah nikho seh le hichu Pakai angsunga kigol doh ding, hitia chu beitih umlouva Israel chaten machah thei ho chu atodoh jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Hiche thilto hose hi Aaron le achapate ho ding ahin, hitia chu hiche thilto ho chu muntheng laiya anehji diu ahi, ajeh chu hiche thilto chu Aaron ding Pakaiya dia pumgo thilto kitoh dohsa, ama chanvou dia thiltheng tah ahin, hichu tang louva chonna dan dinga juijing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Pasal khat chu anu Israel numei chule apa Egypt mi, hiche pa chu ahungvah doh le tan ngahmun khat a avah lut in ahileh, hichun Israel chaten aum kemvel tauvin, chuin Israel numei nu chapa jong Israel chapa khat toh chun akiboi lhontan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Israel numeinu chapan jong Pathen pa min panin taitomna toh thon agao sapjeng tai, chuin mipi hon ama chu Mose heng lama ahin pui tauve. Hiche pa anu min chu Shelomith ahin, Dan phung akonna Dibri chanu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","ama hon jong hiche pa hi iti ding hi tam atiuvin, Pakai lunglam aheng uva ahung kilah kahsea din, mihenna kul sunga chun akhumlut tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Pakaiyin Mose henga thu aseiyin, hiti hin bolin, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Pathen gaosap mipa chu polam ngahmun'a hin kaidoh inlang, aman agaosapna awchang japha chan in, aluchunga akhut angap lhah cheh diu, hiche joutengleh khompi thenga mipi jousen song in seplih jeng tauhen, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Chule Israel chate henga ajah uva hiti hin aseipeh tan, koi hileh Pathen gaosap mihem aum khah leh, hiche mihem chun ama tah themmona akipoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Pathen taitom mihem chu thajeng ding ahi, khompia pang mihem jousen ama chu songa aselih diu, kholgammi hihen agamsung chengden hijongleh, Pathen min taitom mihem kiti phot chu thana chang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Chule mihem khat that chu, ama jong thina chansah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Koi hileh gancha that achu ama chun akhel apeh doh pai ding, hiche gancha khel thei dia chu gancha hing khat alepeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Koi hileh ain-heng khattou amavo khah leh, aman hiche pa abolna banga chu ama chunga jong bolgimna lhung ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Agu ham achang ham asuh chep a ahileh, ama jeng jong agu achang suhchep del ding, amit asuh chot tah jongleh ama mit jong hitia chu suhchot peh ding, aha ham khat asuh lhoi khah jongleh ama ha jong suh lhoi pai ding; aman mi abol gimset banga chu ama chunga jong abepbep a lhunsah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Gancha that aum leh hiche athat pen pen chun akhel ahola apeh le ding, mihem chunga hem lama thatpa chu ama jeng jong tha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Na bonchauvin kholgam akonna mihem hihen, agamsung akon hijonglehuchun abonchauva danthu khat a chondel del diu, ajeh chu keima Pakai leh nangho jouse Pathen pa chu kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mose jong hiti chun Israel chate jouse jah aseipeh soh tan, chuin ama hon Pathen taitomna neipa chu polam ngah munkhat a ahin kaiyun, amapa chu song in aseplih tauvin ahi. Pathen thupeh banginIsrael chate jousen abolun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Pakaiyin Sinai molsang chunga kon'in, Mose henga hiti hin aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Israel chate jouse jah a seiyin, na bonchauva keiman kapehna gam nahung lhun tengu leh agam pumpia jong Pakaiya dia choldam kum anei tei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Kumgup sunga na loujaova muchi nathe ding, hitia chu kumgup sunga na lengpi thei nalho ngimsela, chuteng aga nakilo ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Kum sagi lhinkum levang agamsung pumpin choldam kum anit ding, hitia chu loujaova muche jeng jong natu thei louding, na lengpithei lei jong nalho ngimtah louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Chule changval hung kehdoh ho jong na-at louding, lengpi lei lholou laiya hung kehdoh aga ho jong nadon da jeng ding, ajeh chu na boncha diuva choldamna kum ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Gamsung pumpia dia choldamna kum ahitan, ami chan cheh adingin chule nangma nahin nasoh pasal ham nasoh numei hijon gleh; natha lah mihem hihen lang gamchom ahung kholjin hijongleh, na bonchauva dia anneh ding nahin ngaito peh diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Nangma gancha ho ahin, na gam'a um gamsa ho jaona hiche gamga soh ho chu aneh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Kum khat sunga hapta sagi nasim dohji ding, hatpa sagi veijen na simdoh ding hitia chu agoma kumsom li leh kumko aphah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Hiche jou tengleh nangman lha sagi lhinna hiche lhasung mama achu, nisom lhin nikho chule sumkon namut ging ding, hichea chu kithoidamna nikho nagam pumpiuva thong jejua sum kon na lhangsap uva nathejal soh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Kum nga don ahung lhin teng hiche kum chu kum theng tah ahi, hichu na phonjal diu, gamsung pumpia khosa jouse henga chamlhat kum ahitia naphon jalsoh diu ahi; hiche kum hi na boncha diuva jubilee kum ahitan, mihem koi hileh athilkeo jouse akile lah kit ding, mihem jeng jong ama cheh in mun'a kile cheh ding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Hiche kum somnga lhinkum hi nangho jouse dia jubilee kum ahitan, hiche kuma hi muchi jeng jong natu louhel diu, achama hung keh muche chang jeng jong na-at da jeng diu, lengpilei nalho louna beh a hung kehdoh aga ho jong nadon louding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Ajeh chu Jubilee kum hi kum theng tah ahi, na boncha diuva atheng ahi; hijeh chun agamsunga anagasa hobou naneh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Hitia chu Jubilee kum ahung lhun teng, na boncha uva koi hileh agoulo cheh chu na kile pehto diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Na kinaipi henga na thil joh ham, ahilouleh nathil chohsa ham jeng jong chu, hitia thil joh chung chang leh akijoh doh thil chung changa na sopi khat toh adih louva na kibol to thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Chule Jubilee aki chaiya pat naheng nakom'a na thilchoh chule akum ijat sunga hijongleh, agamga soh toh kitoh a nangma kom'a thil ale joh ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kum vang chu ahung tamkhah tah leh hiche thilman chun nasan sah ding, ahinlah akumjat chu alhom khah vang leh athilman jeng jong nalhom sah ding ahi, ajeh chu akum kisim jat dungjuiya aman jong gamga toh ajoh ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Na bonchauva khat leh khat nakisuh gim louhel diu, hiche sangchun na Pathen chu ging jingin, ajeh chu keima na Pakai leh na Pathenu chu kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Na bonchauva ka chonna dan jouse najuikim sohkei diu, hiche ho jouse chutoh natoh doh diu ahi, chuteng gamsung pumpia na bonchauva lungmong sela nakhosah diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Agamsunga jong gamga pha hung um doh ding, hitia chu oiva sela naneh thei diu, agamsunga lungmong sela nachen thei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Na bonchauva na ngaito uva, kum sagi ahung lhin kum le ipi ham ineh diu, muchi la itu ta pouvin, chang jeng jong i-at lou diu hitam, tia na lung don khah uva ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Keima tah in kumgup alhin kumle na boncha chung cheh uva phattheina kahin bung lhah peh diu, hichun kum thum sungsea naneh khop diuva anga ahin sodoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Na bonchauvin kum get lhin kum apat muchi tujong leu chun lhosoh ga aumsa alui hobou naneh diu, kumko ahung lhina lhosohga athah kahsea lhosohga alui hobou naneh na ai diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Gam leiset kiti jong najoh doh thei lou diu, aneipa kei kahin, na bonchauva gamchom mi kholjina kanei nahiuve, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Hijeh chun hoilai chan hijongleh nachen na jouse uva, gam leiset lhatdohna man na bonchauva napeh cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Na sopipa hamkhat hahsatna ato jeh a, agam leiset ajoh doh khah a ahileh, ama bana asopipa chu hunga athiljoh doh chu ahung lhat ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Ahinlah ajoh dohpa ham khat chun, asopi alhat doh thei mi anei tah louva, amavang khonunga ahung haodoh thei dinga auma ahileh, aman ahin kilhat doh thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Hitia chu agamjoh doh pan jong ajohdoh kuma pat phatah a sim ding, ajohna pa henga chu aman jat apeh dia lom cheng chutoh apeh dohtha ding, chujou tengleh ana chodoh pa chun agam leiset chu aboncha anung peh kit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ahinlah amapa chun alhat dohna ding anei louva ahileh, Jubilee kum ahung lhun kahsea ajoh dohnapa kom'a chu athil joh doh chu chuti um ding ahitan, Jubilee kum ahung lhun phat levang chun achopa chun ale lhatdoh ding, athil neipa chu lechan kit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kula kigensa gam leiset behkah khat tou johdoh a umleh, hiche ajohdoh pa chun ajoh kum sunga chu akile lhat dohthei ding ahi. Ajeh chu kum khat sunga chu akile lhatdohna dia thu anei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Ahinlah a-in chu kum sunga chu alhatdoh jou louva ahileh, khopi sunga kul ki gensa ki johdoh a akichohpa chun akhang lhum keiya anei ding ahitan, Jubilee kum hunglhung jongleh akile lhatna ding thu anei lou ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Kul kigen lou khopi neocha sunga in ki johdoh ho vang chu, amin mai maiya ki sim peh ding, hiche ho chu lhatdohna tha um ding, hichu Jubilee kum ahung lhunteng lhatdoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Ahinlah Levi te chenna khopi ho chu, amaho ana chennasa akhopi sung uva in ho vang chu, Levi ten itih phatlai hijongleh akile lhatdoh thei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Koi hileh Levi mite akonna athuneina aman chah louva ahileh, amaho chenna khopi sunga ana kijoh dohsa in vangchu, Jubilee kum ahung lhun teng kile peh cheh cheh ding ahi, ajeh chu Israel chate chenna tin cheng chu Levi mite dia amaho goulo jeng ahi bouve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Levi mite dia kikoi gam beh jouse chu, khat a khat cha kijoh doh thei louding, hichu amaho dia tonsot goulo ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Na sopipa chu aneilel valtah a, nakom tah a akivah lelna aum doh a ahileh, nangman jong ima dang gel louva ama chu navah jeng ding, kholgam akonna jin banga nakom'a khosa jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Natoh le tham a kon'in apung akal jong tep peh dan lang, na Pathen maiven na sopipa chu nakom'a khosa teijo hen, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Ama chu veikan dia sum bat napeh thei louding, nehle chah jeng jong apung dia nei peh louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ajeh chu kei matah hi na Pakaiyu leh na Pathenu kahin, nangho Pathen kahiye tia Cannan gam kapeh diu ahitia, Egypt gam'a konna nahin puigal kaipau chu kahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Hijeh chun nangma nai lama cheng na sopipa chu anei lelval tah a nangma kom'a ama le ama ahung ki peh lut tah leh, ama chu soh tobanga nagoi thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Amapa chu na kom'a thalah mi banga khosa jeng ding, Jubilee kum ahung lhun kahsea na kom'a khosa ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Jubilee akichai teng nangma dalhaa pot tading achate jouse jaona che diu, a insung lama leche diu, apu apa khanga gou ho chu lechan ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Ajeh chu abonchauva keima lhachaa pang ahiuvin; abonchauva Egypt gam'a konna kahin puigal kai ahiuve, hiche jeh chun amaho hi abonchauva sohjoh a najoh doh lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Nangman amaho jouse munemna neitah a thu nasei louding, na Pathen ging khencha hinkho naman ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Soh pasal ho in numei jong nanei jeng thei ahin, hiche soh ding achu nakom lah a namtin vaipi ho chu na chohdoh a navul thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Na bonchauva nalah uva chenglut kholgam mih ho chu nachoh doh uva, soh a nalap thei diu ahi, na gamsung pumpiuva chengsa ho jong nachoh thei diu, hitobang mi nachoh doh hou chu na in cheh uva uma nalap le thei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Chule soh ho chu na chateu banga na goulo diuva na umsah uva, khonunga goulo ding jong nakoi peh diu, nangho Israel te lah a vang khat in khat chunga thuneina tah a vaihoma chatloh thei louding ah. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Na kom'a cheng kholjin mi chu ahung haodoh jeng tah a, na kom'a cheng na sopi pakhat machu achen dan ahah satval tah a ahileh; amajeng jong na kom'a cheng kholjin mipa kom'a ahung kipeh doh jeng tah a ahileh, chule asopi ho kom ham khat a akijoh doh jeng tah a ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Hitia akijoh nunga chu lelhat kit thei ahi, asopi ho lah akonna khat penpen in amapa chu ale lhat kit ding, ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Ahilouleh apaneo ham apaneo chapa ham khat in jong ale lhat thei ahi, ama toh kinai asopi aheng akom aphung chan khompi a insung toh kinai pen khat injong alhat doh thei ding, hiche kala chu ama le ama ahung neijou tah levang ama chama kilhat ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Ana ki chohdoh patoh akinopto banga, ama le ama akijoh doh niapat Jubilee kum chana asim ding, aman jat chu akum tam leh lhom dungjuiya alepeh ding ahi, anakichoh pan amapa alap sungsea chu thalah man toh kibang ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Jubilee kum lhunna ding kum phabep avat nah laileh, aki lhatdohna dia ana ki chohdohna man chu alang khat alepeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Ahinlah Jubilee lhinna ding chu kum lhomcha akivat tah a ahileh, akichoh apat akum jat chu avet toh lhon ding, hiche kuma pat chu atohman jat dungjuiya avaldoh chengse chu akile lhat dohna dia ale dip ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Tohman akisim teng hiche pa chu thagoi man bep bep a kisim peh ding, koi hileh hiche pa tobang chunga engset nanei thei hoa konna navet tup ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Hiche ho jouse nunga hi, amapa hi aki lhatdoh joulou tah vang leh, chuti uma Jubilee kum ahung lhun teng lhat ding, ama ahin achate jouse jaona lhat tha ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Ajeh chu Israel chate hi abonchauva keima lhacha ngen ahiuvin, amaho hi kalhacha ahin, Egypt gam'a konna keima tah in kahin puigal kai ahiuvin, keima hi na Pakaiyu le na Pathenu chu kahi jinge, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Na bonchauva milimdoi nasem thu louhel diu, milim akisem hihen songa tun ding hijongleh, khat a khat cha natundoh theilou diu ahi, gamsung pumpi naum nau kitia hi song milim natundoh theilou diu, hiche ho chu nabol uva amasanga naboh khup loubeh diu ahi; ajeh chu keima na Pakai uleh na Pathen pau kaum jing e, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Na bonchauva ka cholngah nikho chu nanit kimsohkei diu chule ka muntheng jeng jong jabolna napeh jing diu ahi. Ajeh chu keima Pakai kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Na bonchauva ka chonna dan ho najui kimsohkeidiu, ka thupeh chengse jong aboncha nanit kimsohkeidiu aboncha nabol kimsel tengu leh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Hichea chu keima tah in nangho jouse dia gotwi kahin lhah sah ding, chuting leh agam leiset pumpia kon'in gamsa hung kisep doh becheh ding, thingga jeng jong hagaa hung ga ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Chuteng na loujao dung uva thingga louding le lengpi theiga louding, alhang alhanga mihem kikaiya, chuteng na oivasel uva changlhah naneh cheh diu na gamsung jeng uva jong lungmong le lhamonga na khosah diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Chuteng keiman nangho gamsung pumpia chamna kaumsah ding, nomtah a na choldo diu koiman nasuh kichat tahlou diu ahi, gamsung pumpia gamsa phalou jouse katol manghel ding, na chennau gam jenga jong hem mangchaa kitona um talou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Namel mateu nadel jam diu, na masang lai tah uva chem jam tothoa nasat lih jeng diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Nanghoa konna mi nga jengin jong mi jakhat nadel jam thei diu, chule nangho mi jakhat seh in melma sangsom nadel jam thei kit diu ahi, namel mateu chu chemjam lama nasat chop joukei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Na bonchauva kagel khoh cheh diu, na boncha chung uva ka kitepna jong guilhun sah ding kahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Na bonchauva nahou thei diu lho sohga abeisa naneh uva, lhosohga thah ahung lhun kit teng aumsa ho chu na otdoh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Keima tah jong nalah uva khosa ding kahin, ka lungsung jenga jong kidah tah a na kibol kit lou diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Chule nalah uva kalhat le ding, na Pathen pau chu kahi jing ding, na bonchauva ka mite nahi jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Egypt gam mite soh nahi lou na diuva, agam sung uva konna hinpui galkai Pakai na Pathen uchu keima hi kahin, keiman na bonchauva namkol chu kasuh chip a nangho jouse dingdet puma ka che sah nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Na bonchauvin kathu nit ding nanom pouve, thupeh jouse jong najui tapouvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","Ka chonna dan aboncha nahsah louva na koi uleh, na hinkho sung uva ka chondan ho kidah le thet a nakoi khah uleh, ka thupeh khat cha beh jong bol ding go louhela naum uva, ka kitepna napel keh khah tah uleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Keima tah in na boncha chung uva hitobang chu ka lhunsah ding. Na chung cheh uva lunggim hesoh lhung jeng ding chule na gam nadiu ka lhunsah a, nahai hu jengu jong bing leuva ka lhunsah ding ahi, namel mateu neh chai ding bep sohdoh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Na bonchauva kaki doupi sohkeiyuva, namel mateu masanga jong na kisuhgam set diu ahi, nadei lou uleh nathet bol teu aboncha nangho chung vum'a vaihom thuneiya umdiu, koima dellou beh a ha jama najam cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Akisei chengse nahsah a koi louva kathu jeng jong na kijah mosah ngei ngei uleh, na chonset nauva konna vel sagi jen bolgimna ka lechuh sah ding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Na kiletsah nau le natha nei sunu aboncha ka suhmanghel ding, na chung cheh uva thih ka chuh sah a, na gam sung jengu jong sum eng ka hisah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Hitia chu na thaneina jouseu panna bei jeng hi tading, nagam leiset pum piuva jong lhosohga um talou ding, gamsung pumpia thing phung jouse gasoh thei louhel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Keima dounaa na kisah uva na chon khah uleh, keima tah in nat phalou jouse na gamsung ule na boncha chung uva, kalansah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Keima tah in na boncha chung uva gamsa hang jouse kahin hoilut peh diu, na chateu aboncha abah gamset diu, gancha jeng jong natha chai peh kei uva; na bonchauva na manthai cheh cheh diu, naki jotna jouseu jong thip del ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Hiche ho jouse nunga jong na khah doh thei lou uva, nei ki doupi nah lai uva ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Keiman na bonchauva kahin kile doupi diu, na chonset jal uva na bonchauva talent namat cheh diu, na pumpiuva kasuh gamset ding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Kitepna phulahna chemjam hem chu na chunguva kahin jah jeng ding, Na khopi lai lung uva kikhom khom unlang aning aum jong leu chun, na boncha chung cheh uva natna huise hung lang in tin, chuteng na kidou piteu ma sanga nakun cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Nangho hinna changlhah mol chu kalahpeh diu, nalah uva numei som seh seh in jong changlhah pha bep cha bou anei diu, hichu kitup tah a atena toh kitoh chet a tepeh cheh cheh ding, naneh jeng vang uva oivan'aa neh diu ahi tapoi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Kathu naki jah mosah uva, nei ki doupi nah laiyu ahileh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","Na chunguva lungsatna tothoa ka doudal diu, hiche chonsetna nanei jal uva ajat sagi vei nachung cheh uva lethuhna chu ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Na chateu tahsa geiya, numei kithei lou pasal kitheilouva nahin neh nah laidiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Na chunguva munsang lai jouse kahin suh chim jeng ding, gim namtui na halvam nau maicham phung jeng jong kasuh jaldeh ding, hinkho lhum keiya ka kidah uva kathet ding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Na chennau khopi aboncha aching ding koima um louva kalha ding, muntheng lai nanei chengseo jong thipdel ding, nagim namtui lhut nam jengu jong kanah sahpeh louding nahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Gamsung pumpi akeuseh a um ding, na gamsung uva um nakidou piteuvin nalung don jeng diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Namtin chitin lah a kathejal sohhel diu, chemjam kalap a hajam a kajam sah diu, na gamsungu aboncha akeova um ding, nakhopi jengu jong thip dela um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Na bonchauva na kidoupi teu gam'a na vaitham sung seuva na gamsung uchu thip dela koima um louva um ding, chuteng agam sung pumpi chu kitha kimat ima louva choldam sel ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Gamsung chu akeuva aum channa chol damsel ahin, ajeh chu nachen laiyuva cholngah nikho nanit tapouvin hijeh achu cholngah nikho banga chol damsel ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Nalah uva konna athi moh cheng ahing nalai na kidou piteu gamsunga cheng ho jeng jong alungthimu kasuh nemdeh peh diu, nathu khat a kheh lhah a agin khu chemjam kilam banga tijat tothoa jam lele uva, mikhat seh del maimaia jong jamcheh ji diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Koima del louva amaho le amaho kigela chemjam in adel banga jamcheh diu, khat le khat kinolhua jamcheh cheh jeng ding ahiuvin, na bonchauva naki doupiteu masang kitia nalhuh lhuh jeng diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Namtin lah a navaitham gam kei diu, na kidou piteu gam leiset chun nasuh gamset jeng diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Na kidou piteu gamsunga chengho ahing doh chengse jong chu achonset jal uva meidoi gamkei diu, apu apateu chonset a alhah nauva konna amaho jouse jong apu apateu akilo diu meidoi joukei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Abonchauva keima douna jeh’a chon khelna abol uva, keima eiki doupi uva joule nal thua achon uva apu apateu chonset phondohna neiya, ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Hitia achon khah tah jeh uva chu keiman jong akale lama lethuhna achung uva ka lhunsah ding, akidoupi teu angsunga kapui lut nau ajehmpentah aphondoh thei ule; alung tahna jengu,jong aki suhnem thei uva, achonset nauva konna kisem thahna anei thei uleh, ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Jacob henga ka kitepna kageldoh kit ding chule Isaac toh ka kitepna jong kagel doh ding, hitia chu Abraham henga ka kitepna jong kagel doh ding, agam leiset pumpi jong kahin geldoh thaa ka huhdoh kit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Adalhahna agam sung pumpiu chu cholngah nikho tobanga anisih a choldamnaa aman chah diu, hitia chu chondan jouse nahsah moa akoi uva ahinkho sung uva keima doumah le kidahna achonset jouseuva konna kisemphatna achung uva lhung ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Hiche ho jouse jal'a hi abonchauva akidou piteu gamsunga achen tengu leh, keiman jong abonchauva sumil louhela ka hebol cheh diu, ka kitepna jong um jing ding ahi, ajeh chu keima na Pakai uleh na Pathen uchu kahi jing jenge, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Amaho jouse Pathen kahi jing na dinga keima tah in Egypt gamsunga konna mijouse mitmu changtah a kahin puigal kaiyu ahin, apu apateu chunga kana kitepna keiman achung uva gelkhohna kanei ding ahi, keima Pakai chu kahi jing jeng e, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Hiche chondan jouse ahin chonna dan jouse jaonan, danthu chengse toh Pakaiyin ama tah le Israel chate dinga akoichu ahitia, Mose henga ana thupeh chengse chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Pakaiyin Mose henga hiti hin aseipeh in, ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Israel chate henga chondan chengse hi aseipeh in, kinop toh jeh a mihem khat chu Pakaiya dia kipeh dohna anei ding ahi, sum aki seijat hi apeh a kilhat doh thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Kitepna dungjui cheh le aki chepi bang banga pasal kum somni apat kumsom gup chan chu dangka somnga jaonan shekel jaonan sanaa kisem shekel somnga hichu muntheng laiya ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Chule numei ahileh amanu chun dangka somngaa kitepna anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Hitia chu Pasal kum nga apat somni chan, dangka somni hi ding, numei vang chu dangka somkhat hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Chule naosen kum nga apat noilam dangka cheng nga hi ding, numei ahileh dangka cheng thum hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Amavang pasal kum somgup chunglam dangka somle nga hi ding, numei kum somgup chung lamse ahileh dangka somkhat a lhatdoh thei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Ahinlah hitobanga kitepna nei dingpa chun, hiche chepi ding chu angaplal banga ahileh, ana kikatdohsa mihempa chu thempu lama apui ding, chuteng thempu pan aman ato khambep ateppeh ding, hiche mipan ajokham ding chu atep peh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Amavang hiche kitepna hi gancha peh ding toh kisaiya kitepna nei ding ahileh, Pakai lama santhei ding, hitia chu Pakaiya dia kipe dohsa chu atheng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Kitepna neipa chun gancha chu aphajo ding gelna jal'a adang khat a akhel thei louding, apeh khel dia aum jongleh, atodoh masat le akhel dia atodoh chu ania atheng ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Pakai lama todoh theilou hichu gancha theng lou kitepna ahi vang leh, kitepna nei dingpa chun agancha chu thempupa heng lama akai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Thempu pan aman lutdan le aman lut lou dan atetoh ding, thempu pan aphatsah dungjuiya hichu achaina hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Ahinlah atodoh pa chun akile lhat noma ahileh, aman jat jaonaa jakhat lah a somni toh alepeh tha ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Chule mi koi hileh a in atheng dinga Pakai henga apehdoh noma ahileh, in ahoi dan le ahoi loudan dungjuiya thempu pan jong atetoh chet ding, thempu pan atetoh bang banga chu achaina hi jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","In pedoh pa chun akile lhatdoh noma ahileh, aman sum leh jakhat lah a somni chu toh ale peh tha jeng ding ahi. Hichea bouchu akitepna banga lechan thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Chule koi ham khat chun Pakaiya dia agam beh khat tou apeh doh noma ahileh, hiche gambeh khat chu muchi kitu lutjat ding toh atetoh a, chuteng suhlou chang shekel somni ki tulutna thei gambeh chu sum somkhat man jat atepeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Thil kile pehna kum kut kon chaa apeh doh khah ahile vang, aki tepehna banga aman jat jong lhingset a apeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ahinlah agambeh chu apat a alhat doh jou louva ahileh, thil kile pehna kum kut ahung lhun kahsea dinga thempu pan aman jat atetoh peh ding, aman hichea chu lhat dohna anei thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Agam beh pedoh pa chun akile lhat noma ahileh, sum aman jat bang banga jakhat lah a somni toh alepeh tha ding, hichea bouchu lechan thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Pakai henga chodoh louva midang kom khat touva agam beh chu ajoh doh khah bang leh, hichu itih chan hijongleh akile lhatdoh thei talou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Amavang thil kile peh to kum ahunglhung ding, chuting leh imatih chana Pakai gambeh mong monga um ding, hitia chu thempu pan ama neiya akisim ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Chule koi hileh aki chodohsa gambeh khattou Pakaiya dia apehdoh noma ahileh, hichu ama gambeh hilou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","Hitia chu thempu pan thil man lepeh kum ahung lhun ding to kitoh a aman jat atepeh ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Thil kilepeh na kum ahung lhun tengleh, hiche gambeh chu aneisa pa ahilouleh aki naipi henga lepeh kit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Thilman ho aboncha chondan dungjuiya akiman dan bang banga ale teppeh cheh ding, hichu Gerah somni jaona shekel toh kitoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Gancha masa jouse aboncha Pakaiya ding bou ahin, hicheng chu aboncha koima chan atum beh a apehdoh thei louding, bong nou hihen kelngoi nou hihen, kelnou hi jeng jongleh hichu aboncha Pakaiya bou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Amavang gancha thenglou masa vang chu akile lhatdoh thei ding, amanjat chule jakhat lah a somni chutoh apehtha ding, ahinlah ale lhat dohtah louva ahile, chonna dan dungjuiya midang khat henga ajoh thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Hitia chun mihem ahin, gancha hihen, gambeh jeng jong, ajeh um louva Pakaiya dia kipeh dohsa chu koiman ale lhat thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Ajeh beihela Pakaiya kitoh doh chu mihem jeng jong kiledoh thei louva, thina chan sah jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Lhosohga chang ahin, thingga hihen, ipi chu hijongleh gamga jouse chu hopsom lah a hop khat vang Pakaiya ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Koi hileh thil som’a khat kipeh dohsa le choh nom aum leh, chonna ngai banga aman jat jaonan jakhat lah a somni alepeh cheh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Hitobang chun gancha jouse som lah a khat chu Pakaiya ding ahin, hitia chu gancha kiti phot, som lhinna jouse aboncha khat chu Pakaiya ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Gancha neipan jong agancha ho chu ahoi leh apha alhen chil louding, alhen kah le louding ahi. Gancha khat khela chu achom khat apeh khah bang leh ani tah a Pakai chang jeng ding. ale lhat thei louding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Hiche thupeh chengse hi Israel te henga Pakayin Sinai molchunga Mose athupeh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Israel ten Egypt gamsung ahin dalhah kal u kum khat ahung lhin chun Pathen'in Sinai gamthip a houbuh a chun Mose ahoulimpi tan ahi. Hichu alhani channa nikho masapen ni ahin, Pakaiyin hitin aseipeh e, ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Israel namsung pumpi a kon'in aphung cheh uva kon a gal hangsanho leh a insung mihou min jouseu aumden dingin jihlut cheh in. Pasalho jouse chu jihlut soh hel in ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","kum somni apat chunglam gal boltheiho jouse chu Nang le Aaronnin amin u najihlut teitei lhon ding, ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","chuleh hiche phungho jouse lah a kon a chu lamkai khat cheh in nangma nakithopi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Hiche phungho a kon a lamkai ho hi nakithopi ding ho chu ahiuve. Reuben Shedeur chapa Elizur ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simeon Zurishaddai chapa Shelumiel ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Judah Anminadab chapa Nahshon ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Issachar Zuar chapa Nethanel ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Zebulun Helon chapa Eliab ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Joseph chapa Ephraim Ammihud chapa Elishama Joseph chapa Manasseh Pedahzur chapa Gamaliel ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Benjamin Gideoni chapa Abidan ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dan Ammishaddai chapa Ahiezer ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asher Ocran chapa Pagiel ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Gad Deuel chapa Eliasaph ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Naphtali Enan chapa Ahira ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Amaho hi japi lah akon a kilhengdoh lamkai cheh, apu apa phung kailhah a pat lamkaiho chuleh Israel te phung ho a konna mi upa cheh ahiuve.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Hichun lamkai kilheng doh chengse chu Mose le Aaron in akou khom lhonin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","hiche nikho ma ma chun Israel te jalhang pumpi jong akhom tup lhonin ahi. Mipiho jouse chu ama ama phung leh insung cheh kailhah a kon'in amin akijihlut cheh in ahi. Pathen'in Mose athupeh bangin, Israel pasal kum somni apat chunglamse chu khat khatnin akijihlut in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Hiti chun Mose in amaho min jouse Sinai gamthip lai mun a chun ana sutup sohkeiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","21","Ama ama phung dungjui cheh a amin u kijihlut banga pasal kum somnia pat achunglam galsat a konthei amijat ho chu hicheng hi ahi. Phung Mijat Reuben (Jacob chapa tahpen) 46,500 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","23","Simeon 59,300 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","25","Gad 45,650 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","27","Judah 74,600 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","29","Issachar 54,400 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","31","Zebulun 57,400 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","33","Ephraim (Joseph chapa) 40,500 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","35","Manaseh (Joseph chapa) 32,200 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","37","Benjamin 35,400 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","39","Dan 62,700 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","41","Asher 41,500 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","43","Napthali 53,400 ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Israel phung som le ni lamkaiho toh Mose le Aaron in akhumlut u pasal ho cheng hi abonchauva ama ama phung chilhah dungjui cheh a kikhumlut cheh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Amaho chu ama ama insung duijui cheh a kikhumlut ahiuve - Israel te pasal kiti pou kum somni apat chunglam gal bolthei jouse hi abonchauva a insung dungjuiya kijihlut cheh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Amaho chu agomma 603,550 ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Ahinlah hiche kisim khomna a hin Levi te vang apang pon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Ajeh chu, Pathen'in Mose kom'ah hiti hin ana seiyin ahi, ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Min najihlut teng Levi te hi najihlut loubeh ding, Israel mite lah a nasim tha loubeh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Kikhop khomna ponbuh le aki mangcha thil ho aboncha a Levi te mopohna napeh ding, nachena chan uva Ponbuh le amanchah chengse aboncha ama hon apoh uva, akimvella ngahmun semtoh thoa alhacha a pang ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kikhop khomna ngahmun chon phat alhin teng, Levi chapate chengin aphet lhah diu, hitia chu ngahmun nalhun tengu leh ama hon athah sondoh kit diu, amavang koi hileh phalna beiya kikhop khomna ponbuh ganailut behseh chan chu thi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Phung jousen ama ama insung ponlap cheh utoh ngahmun akisem diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Israel pumpi chunga Pakai lunghan louna dinga Levi chapaten vang kitepna ponbuh kimvella ngahmun akisem cheh uva avetsui diu ahi. Hitia chu hiche ponbuh ventupna chu Levi te mopohna hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Hiti chun Pathen'in Mose henga athupeh bang tah chun Israel chaten imajouse abol tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Hichun Pakaiyin Mose le Aaron chu thu hicheng a hin hilchahna aneitan ahi: ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Israel ten ngahmun asem tengu leh, ama ama phung kai cheh a um ding ahiuve. Aphung phung leh ama ama insung micheng chu ama ama ponbuh noija khosa cheh ding ahiuve. Aphung aphung a kihomtohho chun angahmun cheh uchu kikhop khomna houbuh pangli kiemvel a akisem ding u ahi, hinlah hichu kikahjep hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","4","Kikhop khomna ponbuh niso lama ngahmun semding phungho chu Judah, Issachar leh Zebulun hidiu ahi. Anoia ho hi amin kikhum galsat ding jat, aphungmin uleh alamkai hou chu ahiuve. Judah Amminadab chapa Nahshon 74,600 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","6","Issachar Zuar chapa Nethanel 54,400 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","8","Zebulun Helon chapa Eliab 57,400 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Judah phung lamkaina noiya galsat mi ahung kikhom jat chu mihem 186,400 ahi. Israel ten ngahmun thah ajot a asemji tengu leh hiche phung thumho leh alamkai hou hi mapui a pang ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","11","Reuben, Simeon leh Gad chu kikhop khomna ponbuh lhanglam a ngahmun sem a pangding phungho chu ahiuvin, aphungjem u noi cheh a um cheh ding ahiuve. Anoia ho hi galsat ding a amin kikhum jat, aphungmin uleh alamkai hou chu ahiuve. Reuben Shedeur chapa Elizur 46,500 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","12","Simeon Zurishaddai chapa Shelumiel 59,300 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","15","Gad Deuel chapa Eliasaph 45,650 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Reuben phung lamkaina noija galsat thei aloi loiya kikhomdoh jat chu agom a mihem 151,450 ahi. Israel te ahon a achenna jouseuva hiche phung thum ho hi anina a pang ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Chuleh houponbuh Levi ten aput uchu ngahmun lailung a pat a hung kipudoh ding ahi. Phung jouse ngahmun ana kison bang cheh u sukeh louhel a ama ama phung jem noicheh a kitol diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","19","Kikhop khomna ponbuh lhum lama ngahmun semding phungho chu Ephraim, Manasseh leh Benjamin hidiu ahin, aphungjem u noi cheh a um cheh ding ahiuve. Anoia ho hi amin kikhum galsat ding jat, aphungmin uleh alamkai hou chu ahiuve. Ephraim Ammihud chapa Elishama 40,500 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","21","Manasseh Pedahzur chapa Gamaliel 32, 200 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","23","Benjamin Gideoni chapa Abidan 35,400 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Ephriam phung lamkaina noija galsat thei aloi loiya kikhomdoh jat chu agom a mihem 108,100 ahi. Israel te ahon a achenna jouseuva hiche phung thum ho hi athumna a pang ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","26","Kikhop khomna ponbuh sahlama ngahmun semding phungho chu Dan, Asher leh Naphtali hidiu ahin, aphungjem u noi cheh a um cheh ding ahiuve. Anoia ho hi amin kikhum galsat ding jat, aphungmin uleh alamkai hou chu ahiuve. Dan Ammishaddai chapa Ahiezer 62,700 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","28","Asher Ocran chapa Pagiel 41,500 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","30","Naphtali Enan chapa Ahira 53,400 ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Dan phung lamkaina noija galsat thei aloi loiya kikhomdoh jat chu agom a mihem 157,600 ahi. Israel te ahon a achenna jouseuva aphungjem noi cheh uva hiche phung thum ho hi anukhahpen a pang ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Agomlam tah in, aloi loiya um Israel te, a insung cheh uva kon kijihlutho chu abonchauva gomsoh in mihem 603,550 alhing uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Pakai thu peh bang chun Levi te vang chu amin u akisim tha tapon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Hiti chun Pakaiyin Mose ana thupeh bang bang chun Israel ten ima jouse abolsohkei tauvin ahi. Pakai thupeh jui in ama ama insung leh phung jem noi cheh a chun akijotji un chuleh ngahmun jong asemji tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Hiche hi Sinai molchunga Pakaiyin Mose ahoupi lai a ana kijihlut Aaron le Mose insung khanggui thu chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Aaron chapate ho min chu Nadab (atah pen), Abihu, Elezear chule Ithamar ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Hiche Aaron chapate ho chengse hin thempu kintheng atoh theina ding uva thao anu uva chule atumbeh a kilhandoh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Ahinlah Nadab le Abihu chu Pathen umpet a Sinai gamthip a maicham asemlai uva Pathen thupeh toh kikal a meikong dihlou ahal lhon jeh chun, ani lhonin hiche mun'a chun athilhon tan ahi. Chapa dang aneitahlou jeh in kintheng natong ding chu adalhahlhon Eleazer le Ithamar chutoh apalhon Aaraon chubou ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Hichun Pakaiyin Mose henga thu aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Levi phung le changho chu koukhom min lang, Aaron kintheng natoh ga kithopi dingin gapuiyin. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Amaho chu Aaron leh mipijenlea pang ding u, houbuh leh akimvel a kintheng natong a pang ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Levi te jousen hiche ponbuh theng chu avettup dingu Israel mipite thalheng a ponbuh maicham a chu kin thengna atoh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Levi chilhahho jouse chun Aaron leh achapate vaihomna noi a umsah in. Amaho chu Israel mipi ho jouse lah a kon a Aaron le achapate jenle ding leh kithopi ding a kipehdoh ah ahitauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaron le achapate ho jouse chun thempu kintheng na atoh ding uvin seipeh in. Koi hijongleh nganse changlou a muntheng ganailut ho chu thitei teidiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Chuin Pakaiyin Mose kom'a asei in, ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Ven, Levi te hi Israel japi lah kon a Israel chapate apengmasa jouse thalheng a natong ding a kalhendoh ahitai. Levi te ho jouse keiya ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ajeh chu chapa tahpen jouse keima a ahi. Egypt chapate lah a apeng masa jouse kanasuhgam nikho apatna keima Israel chapa tahpen jouse hi keidia atumbeh a ka lhendohsa ahin, mihem a hihen gancha a hijongleh amaho jouse chu keia ahiuve; Keima Pakai chu kahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Pakaiyin Sinai molchung a chun Mose hengah thu aseikit in, hiti hin ati, ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Levi te chu ama ama insung leh phung kailhah in amin u jihlut cheh in. Pasal jouse lhakhat a pat chunglam se jihlut in.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Hichun Mose chun Pakai thupeh bang chun minho chu ajihlut tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Levi in chapa thum aneiyin, amaho chu Gershon, Kohath chule Merari ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Gershon a kon a phungguiho chu ama chilhahte lah a kon a mini min, Libni leh Shimei a kiminsah ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kohath akon a phungguiho chu ama chilhah a kon miliho- Amran, Izhar, Hebron chule Uzzeil a kiminsah ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Merari a kon a phungguiho chu ama chilhahte lah a kon a mini min, Mahli le Mushi a kiminsah ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gershon chilhahte chu Libni le Shimei phunggui akon ahiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Gershonte phunggui a kon a Pasal kum khat a pat chunglam chu abonchauvin mi 7,500 aum uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Amaho chu houbuh akon a lhumlam lang chu angahmun kisahna ding uva kipedoh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Gershonte phungho chung a lamkai a ana pang chu Lael chapa Eliasaph ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Hiche phung teni chung a mopohna a um chu ahileh houbuh avetsui diu, ponbuhtheng leh achung a kidal akhuna chengse ahin, maicham ponbuh lutna phung a kikhai pondal ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Maicham ponbuh leh maicham phung kimvel a ki-dah pondal chengse ahin, a khaoho ahin, chuleh manchah akimangcha ding jouse jaona a ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kohath chilhahte chu Amram, Izhar, Hebron chule Uzziel phung a kon ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Gershonte phunggui a kon a Pasal kum khat a pat chunglam chu abonchauvin mi 8,600 aum uvin, amaho chu muntheng ventup leh vettupna mopohna kipe ahiuvin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","chuleh angahmun sahna ding uva Houbuh a kon a lhanglam kipe ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Kohath phungho chung a lamkai a ana pang chu Uzzeil chapa Elizaphan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Hiche phung li ho hin Pathen thingkhong, dokhang, thaomei khom, maicham phungho, houbuh sung a kimang thil le lo chom chomho, asung dan pondal, chuleh amaho manchah ding a angaicha jouse chung a mopohna anei ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Thempupa Aaron chapa Eleazer chu, Levi te ho jouse chung a vaihom pipu anahin, houbuh sung a nakitong jouse vetup ding a deichom a mopohna kipe ahi ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Merari chilhahte chu Mushi le Mahli phung a kon ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Merari phunggui a kon a Pasal kum khat a pat chunglam chu abonchauvin mi 6,200 aum uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Amaho chu houbuh akon a Sahlam lang chu angahmun kisahna ding uva kipedoh ahiuve. Merari phungho chung a lamkai a ana pang chu Abihal chapa Zuriel ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Hiche phung teni hin houbuh thingkolho, ingolvaiho, akhumho, akhumdouho leh amaho man ding manchah ho jouse avetup diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Chuleh houbuh kimvel a palkhumho leh athehho ahin, akikhainaho le khaoho jouse jong avettup ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Maicham ponbuh mai lhang, solam niso lamkot lang sese chu, Israel mipi ho thalheng a Houbuh muntheng a natohna ding a mopohna nunungpen kipe, Mose le Aaron chapate ponbuh kisahna dinga ana kikoitup a ahi. Koi hijeng jongleh Thempu le Levi te tilou Houbuh muntheng maicham lang hin nailailut tapou chu tha jeng ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Mose le Aaron chun Pakai thupeh banga Levi te phunghoa a kon'in pasal lhakhatna pat chunglam se chu asim lhonin ahileh mi 22,000 alhing uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Hichun Pakaiyin Mose jah a aseiyin, “Tun nangman Israel te chapate apeng masa lhakhat lhingtasa apat chunglam jouse amin u jih lut in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Keima Pakai kahin, keima ding a Levi te chu, Israel chapa tahpenho thalhelng ding a kikoitup teitei ding ahi. Chuleh Israel te pumpi a gancha apengdoh masa ho khel ding a Levi te gancha ho chu kikoitup teitei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Hiti chun Mose’n Pathen thupeh bangtah in Israel chapate lah a atahpen ho chu asimtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Lhakhat a lhingsa leh achunglam chapa tahpenho chu 22,273 anahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Hichun Pakaiyin Mose jah a aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Levi te chu Israel chapate lah a atahpen ho thalheng chun la in. Chuleh Israel te gancha apeng masa ho khel ding a Levi te gancha ho chu nalah ding ahi. Keima Pakai kahi, Levi te chu keiya ahi bouve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Levi te sang'in Israel chapate apeng masa mi 273 in atamjo uvin ahi. Amaho lhatdoh a aum theina ding un, ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","mikhat cheh a ding a Sumgoi a Shekel nga nalahkhom ding, hiche shekel chu muntheng laiya shekel ho toh agihdan nakibahsah ding, gerah somnia shekel khat dungjuiya nate ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Chapa pengmasa avahdoh ho lhatdoh na dingin hiche sum chu Aaron le achapate petan.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Hiti chun Levi te jat sang a hung tamjo Israel chapa tahpen ho lhatdoh a aum nading uvin Mose’n in sum ho chu achom khom in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Aman Israel chapate lah a apengmasa ho thalheng chun sum pum 1,365 achomdoh in ahi. Hiche ho khat cheh hi muntheng a Shekel khat cheh toh agihdan kibang cheh ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Chuin Pathen'in thu apeh bang bang chun, akilhatdoh theina diuvin Mose in hiche sumho chu Aaron le achapate apetan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Hichun Pakaiyin Mose le Aaron henga thu aseijin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Levi phung sung a kon a Kohath insung le chilhahte chu aminhou najih lut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Amaho lah a houbuh sunglam maicham phunga natong thei ding a lhinna nei, kum somthum apat kum-somnga sungse ho chu abonchan jihlut in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Kohath hon Houbuh sunga anatoh ding u chu manchah thil athenga umho jouse vettupna chung chang chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ama hon ngahmun u achon ding teng ule Houbuh maicham sunnung pondal chu Aaron le achaten alahlhah diu kitepna thingkong khuna a anei ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Chuteng hiche pondal chu kelcha vun kisuhtah a atom dingu, hiche ho jouse chu pondum khat seh a apha chansoh ding u ahi. Chiho jouse kichai teng thingkhong chu aputna thinglhon toh asuhto ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Abankit a Changlhah a umpi jing ahiu melchihna, hiche Changlhah kikoina dokhang chunga pondum khat aphajal ding u ahi. chuleh hiche pon kipha chung a chu lheng kongho, gimnamtui halna lhengho, khonho, twi lhitthengna, chuleh deisahtah a aum jing jeng changlhah ho kikoi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ama hon hiche ho jouse chu ponsan a akhu diu, chutengleh kelchavun thengsel'a hiche ponsan chu kikhuson kit diu ahi. Chujouteng dokhang chu aputna ding thinglhon toh asuhto ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Hicheban jom a chu ama hon pondum-eng achu thaomei khum chu ahin khu a, thaomei semtohna, achoina kong, chuleh Olive thao kikoina khon jong chu akhu khum dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Chule ama hon pondum a chu thaomei khom leh athil manchah ho jouse chu kelchavun thengsel'a atom khum uva chuleh hiche alom chu akiputna kolchahna chung a chu akoi ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Chuban leh pondum khat a sana gimnamtui maicham kilhaina chung a aphajal ding u, kelchavun thengsel'a hiche pon chu akhu diu ahi. Chuteng aputna ding thinglhon toh maicham chu asuhto ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Maicham kin a dia manchah akigongtuplou laise chu pondum khat a tomding, kelchavun thengsel khat a hiche pon chu kitomson ding, chuteng aputna kolchah a chu kikoi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Ama hon kilhaina ding a maicham phung a kon a vutvam ho chu alodoh diu, chule ponsandup a maicham phung chu atom diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Maicham thilkeuho jouse - meihalna kong, thihkhe, leilodohna longkhol, kisilna kongho, chuleh thilkoina ho jouse - pon chung a chu kikoi a, chuleh kelchavun thengsel chu hiche ho chung a chu kiphajal a kikhu ding ahi. Chuteng aputna thingjol chutoh asuhto ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Aaron le achapaten munthengho ahin, atheng a um thil le lo ho ahin, ahintom jousoh teng ule ngahmun a kon a kitol theidiu ahitai. Kohath chapaten hiche hi lhun nading mun chan ahin putdiu ahi. Ahivang a thil theng ho chu asuhkhah louhel ding u ahi, achuti louleh thilo ding ahiuve. Hichengse hi Kohath chapaten houbuh a konna aput diu ho chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Aaron chapa Eleazer thempupa mopohna chu thaomei khom a thaotwiho, gim namtui ho, niseh a kitoh lhosoh thiltoho, kinuding thaotwi ho avettup jing ding ahi. Houbuh pumpi leh asung thil ijakai, muntheng le muntheng a akimangcha jouse chu Eleazar vettup na noi a um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Pakaiyin Mose le Aaron henga thu aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Levi te phung a kon'in Kohath chilhah ho mahthah sahhih in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Muntheng pen thil ho ahin nailut teng a thilou nadiuva nangin hiche hi nabolpeh ding ahi. Aaron le achapaten aki lhonlutpi jing diu chule amichang cheh a atoding abol ding u chu napeh cheh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Kohath chilhah te chu phat chomcha hijongleh muntheng laiya thil umho veding a lutlouhel ding u ahiuve, achuti louleh thitei teidiu ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Chuin Pakaiyin Mose henga ahin asei in, ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Levi phung sung a kon a Kohath insung le chilhahte chu aminhou najih lut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Amaho lah a houbuh sunglam maicham phunga natong thei ding a lhinna nei, kum somthum apat kum-somnga sungse ho chu abonchan jihlut in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Gershon chilhahte chu japi natohna a leh thilgih domding ho chung a mopoding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","ama hon Houbuh pondal ho jouse apoh diu, Houbuh jong aki tomna pon puma, kelcha vuntheng sel a akitomna pum a, chuleh houbuh lutna kotphung a pondal toh ahinpoh tha diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Houbuh polama ahin amalam ahin houbuh leh maicham phung vel'a pondal ho jouse jong, khaoho ahin, chuleh amaho natoh toh kisai a amanchah hou jouse ahi. Hiche ho jouse chung a hi Gershon chilhahten avettup diuva mopohna chang ahiuve ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Aaron le achapate mopohna Gershonten amopohna hou jouse, thil dople ding hihen, natohna dang dang tohna ding hijongleh Aaron leh achapaten akomu peh jing diu ahi. Gershon chilhahten thilgih putna ding a jong ngansena apeh ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Hichengse hi Gershon chilhahten Houbuh sunga atohdiu kipe chu ahin, Ama ho hi Aaron thempupa chapa Ithanar vetsuina noi a umdiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Levi phung sung a kon a Kohath insung le chilhahte chu aminhou najih lut ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Amaho chapate lah a houbuh sunglam maicham phunga natong thei ding a lhinna nei, kum somthum apat kum-somnga sungse ho chu abonchan jihlut in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Merarite hon Houbuh a mun'a atoh diu chu Houbuh thilho dop le ding ho ahi. Houbuh kolchah thingho, a agol kamho, khom ho, chuleh atotheh ho adop diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","chukit jongleh houbu kimvel a pal khomho leh atotheh ho, akikhainaho le khaoho chuleh amaho natoh toh kisaiya amanchah ho jouseu jong avettup ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Hichengse hi Merari chilhahten Houbuh sunga atohdiu kipe chu ahin, Ama ho hi Aaron thempupa chapa Ithanar vetsuina noi a umdiu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Hichun Mose, Aaron chule phung lamkai hon Kohath insung le chilhahte chu aminhou anasim un anajih lut tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Hiche min kijihna chun houbuh sunglam maicham phunga natong thei ding a lhinna nei, kum somthum apat kum-somnga chan ho chu abonchan jihlut cheh ahiuvin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Chule amaho chu agom a mi 2,750 ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Hicheng hi Kohath chilhah ho lah a Houbuh a natong thei cheh ding a lhin na nei ho ahiuve. Pathen'in Mose athupeh banginMose le Aaron in jong ajihdoh lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Gershon chilhahte jong chu hitobang ma chun aphung achang dungjuijin aki sundoh cheh uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Hiche min kijihna chun houbuh sunglam maicham phunga natong thei ding a lhinna nei, kum somthum apat kum-somnga chan ho chu abonchan jihlut cheh ahiuvin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","chule amaho agom a mi 2,630 ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Hicheng hi Gershon chilhah ho lah a Houbuh a natong thei cheh ding a lhin na nei ho ahiuve. Pathen'in Mose athupeh banginMose le Aaron in jong ajihdoh lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Merari chilhahte jong chu hitobang ma chun aphung achang dungjuijin aki sundoh cheh uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Hiche min kijihna chun houbuh sunglam maicham phunga natong thei ding a lhinna nei, kum somthum apat kum-somnga chan ho chu abonchan jihlut cheh ahiuvin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","chule amaho agom a mi 3,200 ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Hicheng hi Merari chilhah ho lah a Houbuh a natong thei cheh ding a lhin na nei ho ahiuve. Pathen'in Mose athupeh banginMose le Aaron in jong ajihdoh lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Hichun Mose le Aaron chule Israel phung lamkai hon Levi te chu a insung le ama phung dungjui cheh in ana jihlut tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Kum somthum apat somnga chan Houbuh a natong thei leh thilho po le theija pang thei ding ho chu ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","agom a mi 8,580 ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Pathen'in Mose thu apeh dungjuiya, aminhou jouseu jihlut a aumphat chun, pasal khat cheh chu atoh ding dol cheh uleh apoh ding dol cheh u akipecheh tauvin ahi. Hiti chun Pathen'in Mose thu apeh bangtah in min kijihlutna natoh chu akichai tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Pakaiyin thu hichengse hi Mose hilchahna anei e: ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Israel mipite lah a koi hijongleh tiphah nei, boina nei, ahilouleh mithilong suhkhah jeh a chonna dan dungjui a athenglou a uma ahileh, ngahmun chu adalhah sah nading uvin thu pen. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Hiche thupeh hi numei leh pasal chung a umgel ding ahi. Ngahmun a amaho lah a cheng kahin, asuhboh lou nading un amaho chu koidoh un.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Hichun Pakaiyin Mose thu apeh bang chun Israel mipiten hitobang ho chu ngahmun a kon'in akoimang, hiti chun aboltauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Chuin Pakaiyin Mose henga thu aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Anoija hilchahna chengse hi Israel mipite pen: Pasal hihen, numei hihen, koi hijeng jongleh, midang chung a Thil phalou bol a Pathen joulhep a chu themmo chang a ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ama hon achonset nau aphondoh teitei diu chuleh athilbol khel cheng chu aboncha a aledit ding ahi. Hiche chungvum a asuhkhel na pa chu asuhkhelna jakhat lah a 20 abelap peh nalai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Ahinlah aki suhkhel napa chu athi tah a, asuhkhel ho dit nading asopi a-u, a-nao aumtah louva ahile, pehdinga um jouse chu Pathen ding ahitan chuleh thempuho kipe ding ahiuve. Themmona neiho vang chun Pakai henga kilheina dia kelngoinou ahin kai ding, chuteng suhtheng a umdiu, Pathen toh kicham diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Israel ten pumgo thilto ahin poh jouseu aboncha a ama chan ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Atheng a kipehna a hung kitohho jouse aman asan chan chu, ama ama thempu cheh chun akikoi ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Chuin Pakaiyin Mose kom'a aseiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Israel mite chu hiche hilchahna ho ho hi pen. “Vetsahnan pasal khat ji chu achon chavei tan, chuleh ajipa a dingin kitahlouvin aum tan ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","chule Pasal dang toh ajong tan, ahin ajipa ahin midang ahin koimacha in ahedoh tapon ahi. Koimacha ahetoh umlouva, ajon bolpettah a akimat lou jeng vang a, amanu chu ama le ama kisuboh a ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","Itiham khat a ajipa chun ajinu chu aginmo a athangthip a, amanu akisuhboh akisuhbohlou hettei ding agot leh, ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","ajipa chun ajinu chu thempu ang a ahin puilut ding ahi. Chuleh chang suhbongsa pucha ni chu amanu khel a ahinto ding ahi. Hiche chu Olive thao le gimnamtui toh nahel louding ahi, ajeh chu hiche kilhaina hin a in-neipi chu kisuboh aham, kisubohlou ham ti photchetna dinga thangtomna a kibol ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“Chuteng Thempupan Numeinu chu Pakai thutanna ang a adinsah ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Thempu chun leikhonlen a twitheng themkhat asodoh a Houbuh mai leitol a konna leivui alahdoh chu asunkhum ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Thempu pan hiche numeinu chu Pathen henga ahin kilahsah teng, amanu sam chu alheplhah peh ding chule akhutteni chu hettohsah kilhaina a chu akoipeh ding ahi - hichu inneipu ginmona chu atah alhem ahi hettheina dinga kibol ahi. Hiche teng Thempu chu numeinu nunglam a ding, athemmo pen pen gaosap chan na ding twikha umna leikhonlen, chu ahin dop ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Hiche teng chule Thempupan numeinu kitepna noi a aumsah a, “Najipa thunoiya naum sung a Pasal dangtoh nana chonset khah louva, nana chonchatvei louva nana kisuhboh lou leh, hiche gaosapna twikhatah hi nathoh jou ding himei tahen” tia asei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ahinlah na in-neipu adia kitahjou lou jeh a nana chekhel khah tah a, pasal dang toh nana chonset a nana kisuhboh khah tah a ahileh,' ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","“Thempu pan numeinu chu kitepna noi a aum sah ding, hitia hi asei ding ahi, ‘Pakaiyin chanei thei louva nakoi a, nanaobun panna anei louva , nathong apomsah teng mipi jousen Pakai sapsetna na chunga lhung ahitai ti hehen. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Tuhin hiche sapsetna twihi nasung a lut henlang, nathong pomsah hen lang, naobu jong panna bei himai tahen.’ Chuleh numeinu chu, ‘Henge, hunglhung tahen’ atisah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Chule Thempupa chun hiche sapsetna thucheng ho chu savun chunga ajihdoh a hiche twikha a chu a sop lhah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Hiche sapsetna polut twikha chu numeinu adonsah ding ahi. Itiham khat a hiche numei chu themmo chang ahikhah leh twi chun amanu oisung aphah teng, hiche chun khajenjun a athohlelsah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Thempu pan hiche thangtom kilhaina chu numeinu khutna kon a alahdoh a, Pakai masang a dopsang ding, chuleh maicham phung a achoi ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Thempupa chun hiche changbong khutsip dim khat chu mangmo thilto ding a ahamdoh a maicham phunga ahalvam ding, twi chu numei adonsah teitei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Hiche numeinu chu a jipa angsung a kitah joulouva ana kisuboh khah tah leh, hiche sapsetna po twi chun numeinu chu khajenjun a atho lehlsah ding ahi. athong hung poh ding chule anaobu jong panna bei hi ding, chuteng chuleh amanu min chu amite lah a sapsetna hi ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Ahinlah amanu chu anathen jinga kisuhbuh khah lou ahileh, imacha tilou ding, naosen jong anei thei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“Hiche hi ginmona thu suhlhepna dinga chonna dan ahi. Numei chu ajipa thuneina noiya aum sung a akisuhboh khah a ana chon chatvei khah tah a, ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ahilouleh Pasal khat chun ajinu chu kitahjoulou ding a ahin ginmo khah tah leh, ajipa chun ajinu chu Pakai angsung a apui ding, chuteng Thempu chun hiche chonna dan jouse hi abol ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Hiche thua vang ajipa themmona itobang hijongleh ongthol ding, ajinu vang achonsetna dungjuiya themmo chang ding ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Chuin Pakaiyin Mose henga hiti hin aseyin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Israel mite chu hiche hilchahna ho hi pen. Mipiho lah a koi hijongleh, numei hihen pasal hijongleh atumbeh a Nazirte kitepna a kitem aum a, Pakaiya dia atumbeh a ama leh ama kipedoh aum leh, ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Amaho chun khamnathei juho leh lengpithei twiho don angah ding u ahi. Hitobang miho chun lengpi theitwi ahilouleh adangdang khamnathei a kisem juthuh kilhahna ho chu aman louding u ahi. Lengpiga apat a twikilhithah jeng jong adonlou ding, Lengpi theiga ahin Lengpi theiga gopsaho jeng jong aneh uva adonlou ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Amaho chu Nazirte kitepna kol sung a aum laise uva, lengpi gui a kon a kisemdoh ho chu aneh diu le adondiu phal ahipoi - Lengpi thei ahoh le amu jeng jong aneh louding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“Nazirte tia kitepna kol sunga aum sung sese uva chu asam u jong ache louhel diu ahi. Akitepnau suh bulhit a aum phatsungse a chu asam u akihoisao ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Chule hiche kitepna kol sung a aum sung sese uva hi thilong umna'a vel lah a che louding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Hiche mithi long chu apen na mong mong pa hihen, anu hihen, sopipa ahilouleh asopinu hijongleh amaho chu kisuboh louding ahiuve, ajeh chu alu uva asam uchu Pathen a dinga kitum lhandoh ahinau lim a um ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Pakai kintheng natong dinga lhenchom a aum chan uva hiche kigahna ho hi ajui jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Itiham khat a ama angsung a mikhat chu alhuh a athi jeng tah a ahileh asam kithenso chu kisuhboh ahitai. Nikho sagi kho ngai dingu, asam u akivotol ding u ahi. Chuteng amaho chu akisuhbohna uva kon a atheng a umkit a ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ni get lhinni teng vakho kopkhat ahilouleh in vapal nou ni houbuh maicham lutna dontah a thempu kom'a ahin choi ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Thempu chun vacha teni lah a khat chu chonset kilhaina a atodoh ding, khatpen chu pumgo maichamma a dia atodoh ding ahi. Hitia dol a chu thempupan mithi tahsa suhkhah jeh a themmo channa chu asuhtheng ding ahitai. Ama hon akitep nau chu aphudet kit uva, asam u chu aki hoisao kit diu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Amaho aboh a aum masang uva kitepna nikho ajo cheng uchu kisimlou a ahitai. Amaho chu athahbeh a Pakai angsung a Nazir ahinau chu alhumkei a ding a kilhandohkitna ding u chuleh amacheh in themmo kilhaina thilto ding a kumkhat lhingsa kelngoi achal khat ahin kai ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“Hiche hi Nazirte chonna dan chu ahi. Nazir a dia akilhekhen nau phat nunung lam teng, houbuh kotphung a chu che diu ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","chule Pakai ang a thilto hou alhantheng diu ahi. Hichu kumkhat lhingsa nolnabeihel kelngoichal khat pumgo thilto ading, kumkhat lhingsa nolnabeihel kelngoi anu khat chonset kilhaina ding chuleh nolnabei kelngoi achal lhingset khat hichu chamna maicham ding, ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Cholsolou changlhah Pocha khat - hichu akilhengdoh changbong Olive thao toh kimehhel chule changlhah neocha cha a paset a kisem a olive thao kichapkhum- chuleh pehding a umsa lhosoh thilto leh atwi a kilhaina thiltoho ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Hiche thilto ho hi Thempu in Pakai angsung a pehdohna anei ding ahi. Amasa penna chonset kilhaina thilto leh pumgo maicham thilto ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","aban'a chamna maicham ding a kelngoichal lhinsel chu ahin, chuleh Cholsolou changlhah pocha khat ahi. Pehding a umsa lhosoh thilto leh atwi a kilhaina thiltoho ho hjong chu Thempu in Pakai kom'a pehdohna anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“Chuteng Nazirte ho chun Houbuh lutna kotphung achu asam u akivolhah diu ahi. Chamna maicham kilhaina noi a meilah a chu anakikatdohsa asam u chu akoilut diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Nazir hon asam u akivotol joutengu leh, thempun amaho cheh ding a akihulmin sa kelngoi chal dah chu alah ding, Pocha sung a um cholsolou changlhah leh changlhah neocha cha a paset a kisem chu alah ding ahi. Hichengse chu aman Nazirpa khut teni a akoi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Thempun hiche ho chu adopsang a kilhanna thilpeh tumbeh Pakai anga a abol ding ahi. Thempupa dinga atheng hung kitoh dohho chu ahileh, atumbeh a hung kitoh a-omlhang leh thengtah a Pakai anga a kitohdoh leh kidomsang a-mal jaona cheng chu hi ding ahi. Hiche kintheng hi ahung kichai teng Nazirpa chun lengpitwi adonthei ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Hiche hi, kilhaina hicheng Pathen kom hinlhut ding a kitepna nei Nazirte chonna dan chu ahi. Hiche chungchon a kilhaina apehjou chan uva jong apeh thei u ahi. Chuleh amaho chu Nazir tia lhendoh chom a aumtengu leh khopho tah a hitia akitepna jouseu chu abol ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Chuin Pakaiyin Mose henga aseijin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aaron le achaten Israel te mipi jouse chu atumbeh a phatthei abohdiung uvin seipeh in: ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Pathen'in phatthei naboh uhenlang naveng jing uhen. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Pathen'in lhaisel in nave jing uhenlang nachung nga lung lhaisel jing tahen. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Pathen mitvet in lung lhaina chang in chule chamna nape hen. ");
INSERT INTO tczchongthu_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Aaron le achapaten keimin a Israel te phatthei aboh tengu leh keima in jong amaho chu phatthei kaboh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mose chun houbuh atundoh nichun thao anun, atheng in atum koi tai. Aman thilkeo jouse jong thao anun, houbuh sung manchahho, maicham phung leh athilkeo ho jong atheng in atum akoitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Chuin Israel te lamkai ho - akilom a um miho min jihlut a pang phung lamkaiho- ahungun, ama ama thilto ahin pohlut cheh uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","ama hon abonchauvin Sakol kangtalai lentahtah gup toh Bongchal Somle ni ahin kaiyun ahi. Sakol kangtalai khat chu lamkai ni a ahin, Bongchal khat cheh chu Lamkai khat cheh a ahi. Hiche ho cheng hi Pakai a ding Houbuh mai a chun apeuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Chuin Pakaiyin Mose kom'a seiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Thilpeh ho chu sang'in, Sakol kangtalai leh bongchalho chu houbuh pohle na a nanei ding ahi. Levi te chu atoh dungjui cheh un homkhen in.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Hiti chun Mose’n kangtalaiho leh bongchal ho chu Levi te apetan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Mose’n Kangtalai ni le Bongchal li chu Gershonten anatohnauva amanchah ding uvin apetan ahi, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Chuleh Kangtalai li le Bongchal get chu Merariten anatohnauva amanchah ding uvin apetai. Na kitong jouse aboncha a thempu Aaron chapa Ithamar vaihom nanoiya umsohkei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ahinlah Houbuh a kimang cha thil theng ho chu alengkou uva apoh ding u ahijeh chun Kohatte vangchu kangtalaiho le Bongchalho imacha apepon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Lamkaiho jousen jong kilhanthengna thilpeh ahin kichoi cheh uvin, kisuhtheng nikho chun maicham phung nga akoi cheh tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Pakaiyin Mose kom'a aseiyin, “Maicham kithensona dingin lamkai khat in thilpeh khat cheh hintoh hen.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Nikho masapen tah chu Nahson kiti Aminadab chapa Judah phung lamkai chun maicham a ahin pelut in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Nahson in ahinto doh thilho chu sum-eng lheng, agihdan shekel jakhat le somthum a gih chule sum-eng lheng khat Hou-In sung nga dangka kholna ahin, hiche ho jouse hi changbong kitahna chule chanbong neljet Olive thao toh ania kisung dim cheh ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Nahson chun sana a kisem thilkoina li gimnamtui dimset chu ahin choiyin ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","Nahson in Bongnou khat toh, kumkhat lhingsa kelngoi chal chu pumgo maicham dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","Chule kelchal khat chu chonset kithoina maichama pang dingin ahin kai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","Chamna maicham adin Bongchal ni, kelngoi achal lhingset nga, kelchal nga, kelngoi kumkhat lhingsa ho chu ahinkai in ahi. Hichengse hi Amminadab chapa Nahson in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Nikhoni lhinni in Zuar chapa Nethanel, Issachar phung lamkai pan, amaicham ahintoh doh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Ama hinto ho chu, sum-eng hopthum ahin tohdoh in chule sum-eng kong khat sopna agih diu khat hichu Hou-In nathilgih tetoh na kila ahi. Hiche sum-eng kong twihi changbong kitang Olive thao kisun khum ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","chuleh sana a kisem thilkoina gimnamtui dimset ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Zuar chapa Nethenel in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Anithum lhinnin Helon chapa Eliab, Zebulunte phung lamkai pan jong amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Ama hinto ho chu, sum-eng hopthum ahin tohdoh in chule sum-eng kong khat sopna agih diu khat hichu Hou-In nathilgih tetoh na kila ahi. Hiche sum-eng kong twihi changbong kitang Olive thao kisun khum ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","chuleh sana a kisem thilkoina gimnamtui dimset ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Helon chapa Eliab in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Nili lhinnin Sheduer chapa Elizur, Reuben phung lamkai pan jong amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Aman sum-eng kong khat chule houbuh sunga thiltena kitetoh chat ahin, hihcu changbong jaona Olive thao toh kihel khomma ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Eliazur in jong sana dangka kong ahin choijin hichu gimnamtui jaona ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Sheduer chapa Elizur in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Ni-nga lhinna in Zurisaddi chapa Shelumiel, Simeon phung Lamkai pan jong amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Shelumeul chun maicham ho hi sum-eng kong tong gihtah ahin, amaho shelul kitena dungjuijin Hou-In sunga kimanchahna bang chun changbong neldijet Olive thaotoh kihel chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Sana dangka kong jing ahin kitetoh in agih Gram li tobang ahin hiche chu gimnamtui a dimset e. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Zurisaddi chapa Shelumiel in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Ni-gup lhinnin Deuel chapa Eliasaph, Gad phung Lamkaipan jong amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Phung lamkai dang hon atobang chun Eliasaph in jong lhingsel in a maicham ho ahin kipeh lut e. Sum-eng changbong neldi jet jaona hichu Olive thaotoh kihelsohkeija ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Eliasaph in Sana dangka jaonan gimnam tui dimsetna kikoi chu ahintoh doh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Eliasaph chapa Deuel in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Nisagi lhinna in Amihud chapa Elishaph, Ephraimte phung Lamkaipan jong amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Ama chu phung sagi hou lamkai cheh in atodoh u akibang chet in sum-eng changbong ho chu Olive thaova kihel sohkeija ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Elishamma in sana dangka chule gim namtui tui dimsetna kikoi ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Amihud chapa Elisaph in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Niget lhina in Pedazur Chapa Gamaliel, Manassehte phung lamkaipan jong amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","to consider ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Todoh maicham phung sung hotoh aki bang chat nalaiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Amihud chapa Elisaph in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Niko lhinnah in Gideon chapa Abidan, Benjamin phunga Lamkai pan amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","to reconsider ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","Chuleh kelchal khat chonset maicham kilhainan apang in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Gideon chapa Abidan in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Nisom lhinna in, Ammishaddai chapa Ahiezer, Dan phung lamkaipan amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Ahiezer lin maichamma ahin todoh hiche ho hi ahiye. Sum-eng khon sopna Israel te houdan thua thiltena toh kitohchetna kite, changbong deitah ki subong chule kisuh neldijet Olive thao toh kinu khom ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Ahiezer kite Amishaddai chapa in Sana dangka chule gim namtui thao jaonan ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Ammishaddai chapa Ahiezer in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Nisomlehkhat lhin in Ocran chapa Pagiel, Asher phung lamkai pan anoija ho hi maicham a din ahin tohdoh e. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Sumeng khon sopna theija gih hiche sum-eng lhengkong tunna chu leh changbong neldisel jaona hichu Olive thao toh kihal ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Sana dangka le lhengkong chule gimnamtui dimset jao nan ahin toh e. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","Bongchal nou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Ocran chapa Pagiel in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Nisom le ni lhinna in Enan chapa Ahira, Napthali phung lamkaipan amaicham ahin tohdoh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Ahira maicham ho sum eng jaonan changbong hichu Olive thao jaonan ahin todoh ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Ahira in sana dangka jaonan gimnamtui toh ahin toh doh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","Bongchal anou khat, kelchal khat chule kelngoi achal kum khat lhingsa chu pumgo maichamma a dingin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","chule kelchal khat chonset kithoina maicham a pang dingin ahinkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","Chamna maicham a din Bongchal ni, kelngoichal lhingset nga, kelchal nga, chule kelngoi kumkhat lhingsel-nga ahin kai in ahi. Hichengse hi Enan chapa Ahira in kilhaina thilto a ahinto ho chu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Israel a phung lamkai hon maichamphung thao ana kinu a kilhandohna maicham dia ahintodoh hou chu: Sumeng lheng kong len som le ni, Sumeng kisilna kong som le ni, Gimnamtui kikholna Sana lhengkongho ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Hou-Intheng a shekel kitena a ilep leh Sumeng lhengkong len khat gihdan chu 3-1/4 pounds ahin chuleh Sumeng kisilna kong khat gihdan chu 1-3/4 pounds ahi. Sumeng mong mong agihdan chu 60 pounds ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Hou-Intheng a shekel kitena a ilep leh Sana lhengkong som le ni khat cheh gimnamtui jaona a agihdan chu 4 ounces ahin. Sana mong mong agom a agihdan chu 3 pounds ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Bongchal anou som le ni, kelngoi achal lhingset som le ni, kum khat lhing cheh kelngoi achal som le ni pumgo thilto a dingin ahung kitoh in, todoh ding a umsa lhosoh maicham jong ahi. Chonset kilheina maicham dingin kelcha achal som le ni ahung kikailut in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Chamna maicham dingin Bongchal somni le li, kelngoi achal lhingset somgup, kelchal somgup, kumkhat lhingsa kelngoi chal somgup ahung kitohdoh in ahi. Hicheng hi maicham phung thao akinu jouva maicham phung a dia kitodohna maicham dia hung kitohho ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mose chu Pakai toh kihou ding a Houbuh sunga alutji teng, aman houpina awgin thingkhong akhu (Themmona akon a themchanna mun - Kitepna thingkhong chung a kinga) chung a Cherubim teni lailung a kon chun aja jin ahi. Hiche lai mun a kon a chu Pakaiyin ama chu ahin houpi ji ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Pakaiyin Mose henga aseiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Aaron in hiche hilchahna ho hi pe in: Thaomei khom sagi chu atunna a natundoh tengleh, amalam ma thaomei khom mailah chu a salvah jou nading nadingin tundoh in.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aron in chuti chun aboltan ahi. Thaomei khom Sagiho chun amailam salvahna din Pakaiyin Mose henga asei bang bang chun atungdohtan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Hiche thaomei khom aboncha a, akhombul apat ajem kisemna chan gei chu sana kikhen a kisemdoh ahi. Hiche hi Pathen'in Mose alim um ding dol avetsah bangtah a kisem a ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Chuin Pakaiyin Mose henga ahisei in, ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Tun Israel mipi adang ho jouse a kon'in Levi te tumkhen inlang, chonna dan ngai banginsutheng sohkei in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Kisuhtheng na twi chu nathinkhum ding, amaho apumpiuva atahsa uva amul jouseu kivoumui diu chule amanchah jing apon hou akisoptheng diu ahi. Hitia chu aboltengu leh chonna dol a atheng a ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Bongchal gol khat leh lhosohga maicham a kon a changbong Olive thao a kisunum chip chep, chule Bongchal golkhat mama toh chonset kilheina maicham a ding a ahin to dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Chuteng Israel nam mite jouse chu nakhopkhom a Houbuh kotphung a umdia Levi te chu na peh doh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Pathen na dinga Levi te chu napeh doh tengleh, Israel miten amaho chunga chu akhut u angap diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aaron in akhut teni adopsanga Israel mipite lah a kon a Levi te chu Pathen a dinga atumbeh a katohna anei ding, hitiachu Pathen lhacha natong ding a lhandohna anei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Hiche jouteng chule Levi te jousen Bongnou achalni chung nga khut ngapna anei diu, Bongchalnou khat chu chule chonset maicham kisem chu pumgo maicham kisem na ding ahin, Pathen henga Levi te chun ki suhtheng na anei diu cham dela umdiu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Aaron le achaten Levi te chu Amaho ma sanga adin sah uva, akhot u adop sang jou tengu leh Pathen masanga loupi tah’a maicham a sempeh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Levi te chu Israel mipi telah akonna natum khandoh diu, ajeh chu amaho keija um jing diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Hi chengse kichai teng, Houbuh sunga chu lut diu ana toh diu ijakai ajom thei diu ahitai. Ajeh chu Pakaiyin amaho chu asuh thenga na pehdoh ahi tan nangma heng nga loupi tah ana peh doh ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israel mipite dingin Levi te hi keima dinga kikoisa ahin Israel te chi lhah’a pang masa pen ho chu keima konna phondoh le lhen doh tum ahitai. Levi te chu numei chilhah apat kilah doh ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Israel mipite lah’a peng masapen mihem pasal ahin gancha hijongleh keima ahi sohkeiyin, Egypt mite pasal chapa masapen jouse kana suhmang nia pat chun keima dinga kana gontup sa ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Levi te phung hi keiman Israel te lah’a chapa peng masa penna ka koi ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Aaron le achate ho hi Levi te vetup ding nga ki sem ahitai. Israel te tha khel lah maicham Houbuh a kin theng na tong ding ahiuvin, pumgo maichamma kisuh thengna kin thenga a na tong le ding mong mong ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mose Aaron chule Israel mipi jousen Levi te chu alheng doh un Pathen'in amaho thu apeh dungjuijin abol tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Levi ten achonset na’u chu aki soptheng uvin chule aponsil ho jong aki noilhah un. Pathen masang nga loupi tah in maicham asem peh tai. Aaron in amaho chu maicham athengsel na ding uvin abolpeh in ajeh chu Pathen toh chamdela aum na diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Chuteng Levi te chu Houbuh maicham’a sunglha diu kintheng na toh apat diu, Aaron le achaten aki thopi diu ahiye. Amaho thu nit ding aki pat jouse Pathen'in Levi te jui dinga Mose ahin hetsah ho chun anit sohkeiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Chuin PakaiyinMose hengah hiti hin aseiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Hiche dan hi Levi ten anit’u ngaijin, Houbuh sunga chu kintheng na toh apat na diuva chu kum-somni le nga beh alhin’u ngai ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Chule Levi te chu kum-somnga alhin teng ule kichol thei ding ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Levi te chu akichol joulam teng ule asopiu aloi agol hon Houbuh kimvella ajenle a jong pangthei nalaiju ahi. Ahinlah akintheng na tong vang pang thai ta louding ahi. Hi chengse hi Levi te kin theng natoh na mun'a aman chah diu dan ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israel te chu Egypt a patna ahung kichon doh jou kum khat ahung lhing chun Sinai lhang a gamthip lah a chun Pakaiyin Mose kom'a ahin seiyin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Kalchuh Kut kiman na ding phat kitepna a hi aman ding uvin Israel mite chu seipeh tan , ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","hichu lha masa pen nisom le nili lhina a khojin chip chep phat hi ding ahi. Hiche kipathanop kibol ding dan thupeh ho leh dan umho phate a najui sah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Mose’n jong mipi henga Kalchuh Kut kipa golnop abol ding uvin aseipeh tan ahi, ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","ajeh chu Sinai lhang gamthip lah a nisomle nili ahung lhin a khovah chip chep in ahinphah den un ahitai. Pathen'in Mose thu apeh bang bang chun ama hon jong kipagolnop chu abol tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Ahinlah amaho lah a mi phabep chun mithi long ana thamkhah jeh un, chonna ngai banginakisuboh a ahitauvin, hiche nikho a Kalchuh Kut kipa golnop a chun alha thei tapouve. Hiche nikho chun Mose leh Aaron kom'a ahungun ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","“keihon mithi long ka tham khah tah jeh un, chonna ngai banga atheng louva ka hi tauve. Hijongleh Israel mipin asem leng a keihon jong Pathen ang a maicham kasem mo diu ham?” ahungtiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mose chun adonbut, “Nangho ding a Pathen a kon a hilchahna kamu kah khongai un” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Pakaiyin Mose ahin donbutna chu hiche hi ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Hiche hilchahna ho hi Israel mipite seipeh in: Tukhang hihen lang khang hunglhung ding ho hijongleh chonna ngai bang a akisuhboh kha hihen, kholgam a chedoh ho hijongleh Kalchuh Kut kipa golnop a pangthei ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Kalchuhkut kipa golnop kichai lhakhat lhin teng Kalchuh Kut maicham thilto abol ding u ahi, hichu lhani lhinna a nisom le nili lhinna khojin chip chep phat hi ding ahi. Hicheteng chuleh Kalchuh Kut kelngoi sa chu anche kha le cholsolou changlhah toh aneh tha dingu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","ama hon kelngoi chu jingkah khovah geija akoi thei louding u, chuleh hiche agu jong asuh boh thei lou dingu ahiye. Kalchuh Kut kiman na chung chang a dan umho hi ajui cheh ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","“Ahin Israelmi hiya chon na ngai a aboh jong hilou, kholche a jin doh jong hilou, ahivang a Kalchuh Kut nahsah lou miho chu Israel nampi akonna kah lhah’a um ding ahi. Pathen maicham jong aphat tah ahin todoh lou leh achonsetna jal a themmo chang a um ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Nangho lah a nam dangmi Kalchuh Kut golnop a jaonom aum leh, nit ding leh jui ding a kipe jouse hi anit ngaiyin, hiche dan hin Israel nam chilhah a kon hihenlang, gamdang chilhah a kon a koi hijongleh akan sohkei ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Houbuh ahin phudoh nikho uchun, meilom in Houbuh chu atom tan ahi. Houbuh chung nga meilom nilhah apat jingkah geiya umchu meikong lomtoh abang jengin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Hiche meilom houbuh chung a um, jan tengleh meikong alom a hung kilah ji tobang chun aum jing tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Houbuh chunga meilom chu akihohdal ji teng, Israel mipiten hiche amaicham ponbuh chu aphet lhah jiuvin meibol lom chu ajui ji uvin ahi. Chuleh hiche meilom akingah ngah na a chun Israel mipi ten ngahmun akisemkit jiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Hiti chun che ding a Pathen thupeh amu dungjuijin lam ajot un, ngahmun asa jiuvin ahi. chuleh houbuh chung a meilom aum chan chun ngahmun dalhalouvin aum jiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Hiche meilom chu Houbuh chung nga nisot tah aum ji teng Israel te chu akichol jiuvin Pathen Houna dinga atoh ding umho chu atong jiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Phatkhat khat teng Pathen thupeh dungjuijin meilom chu Houbuh chung nga ni chom chacha bou akingaji in, amaho jong ni chomcha bou akichol jiuve. Chuteng Pathen thupeh dung in ngahmun chu aphet lha uvin ache jomkit jitauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Phat chomkhat kit teng Meilom chu jankhovah in aum'inJingkah teng akichon doh jin ahi. Ahinlah sun hihen jan hita jongleh hiche meilom chu ahung ki hohdoh teng ngahmun chu aphetlha jiuvin ache jom jingji un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Houbuh maicham chunga meilom chu ni ni umhen, lhakhat umhen, ahilouleh kumkhat um jongleh , Israel mipite chu ngahmun na chun aki chol jing jiuvin apotdoh jipouvin ahi. Amavang Meilom chu Houbuh chunga ahung kihoh dal teng ngahmun chu aphet un achejom kit jitauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Hiti chun Pakai thupeh bangtah in akichol un, akalsong jingun ahi, chule Pathen'in Mose a kon a athupeh jouse chu abolkim soh jingun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Pakaiyin Mose henga hiti hin aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Mipi ho koukhomna ding leh ponbuh phetlhahna ding a melchihna a manchah din dangka sehcha a kikhengjol pengkul ni sem doh in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Hiche Pengkul teni chu ahung kimut ji teng mipi ho chu Houbuh lutna kotphung a nangma masang nga hungkhom ji ding u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Ahinlah pengkul khat bou chu ahung kimut tah vang leh Lamkai hobou - Israel phung lamkai jouse atahsa tah uva na masang a hung kilah cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Nangma in hiche gin a chu hetsahna nanei teng, Houbuh a kon solam a ngahmun nei phung ho chun angahmun u chu aphet lhah uva malam a chu che jom ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Nangma in hiche gin a hetsahna anivei channa nanei teng lhanglam a ngahmun neihon ajui ding u ahi. Achejom jing ding u hetsahana a chu nangman agin chom naginsah ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Ahinlah mipi kikhom khom hen nati teng, pengkul chu awgin chomjep in mut in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aaron chilhah, thempu ho bou chun pengkolho amut thei ding u ahiye. Hiche hi nanga ding a akhang akhang a aumden jing ding leh nitjing ding dan chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","“Nangma ho gamsung nga na hung lut uva, nangho doujing namelmate ho sat ding a nakon doh ding tengu leh pengkulho kigottup nadia naginsah diu ahi. Hiche teng chu leh na Pakaiyin na hin geldoh ding, na melmate akonna nahuhdoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Na pengkulho chu kipa thanop phat na jong na mut ging ding, kumsung a kipa golnop ho leh lha thah hung ki sim pan phat ho a jong namut ging ding ahi. Hiche pengkulho chu kipana maicham kisem phat hihen, pumgo maicham kibol sih hijongleh hiche maichamho chung a chu namutging ding ahi. Hiche pengkulho gin chun na Pathen ana kitepna hin gel doh sah ding ahi. Keima na Pakai, Pathen chu ka hiye.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Kumni jouva Israel te Egypt gam a konna ahung dohnau - alhani channa a ni somni alhinni chun - meilom chu kitepna ponbuh akon chun akikhang doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Hijeh chun Israel mipi chun Sinai gamthip lah a kon'in ahungdoh un Paran gamthiplah aphah uva meilom akingah masang sen mun chom chom in ana kitol le le un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Mose in Pakaiya kon hilchahna amu bang tah a, Israel mipi ho amasapen a ding a ahung kitol pan un chun, ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Juda te aloiloi a um ho chun aponlap noi uva lam akai un ahi. Chuleh alamkai uva pang chu Aminadab chapa Nahshon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Amaho banjom chu Issacharte ahiuvin, a hin Lamkai a chu Nathanel kitipa Zuar chapa ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Chule Zebulun chilhah hon ajom un, Helon chapa Eliab chu ahinlamkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Hichun Houbuh chu aphet lha uvin Levi te sung a kon a Gershon te le Merari te chun houbuh apo uvin abanjom in acheuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Reubente ho aloiloi a umho chun aponlap noi uva abanjom un, Sheduir chapa Elizer chun amaho ahin lamkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Aban achu Semeonte aloiloi a umhon ahinjuiyun, amaho Lamkai pa chu Shelumiel, Zunishadai chapa ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Chule aloiloi a um Gadte ahiuvin, Elisab kitipa, Deuel chapan ahin lamkai in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Hiche banjom chu Levi te lah a kon a Kohathte ahiuvin houbuh sung a manchah atheng ho jouse ahin po un ahi. Ngahmun thah alhun masang un Houbuh chu Ngahmun thah a chun tun dohsan ana um jitan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Hiche banjomma chun Ephraimte chu aponlop noiuvah aloiloi in ahung kitol un ahi. Amaho Lamkai a hungpang a chu Amihud chapa Elishama ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Amaho chu Manasseh te aloiloi a umho chun ahinjui un, Pedahzur chapa Gamaliel kitipan ahin lamkai un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Chuleh Benjamin phung a kon aloiloi a umho ahiuvin, Abidan chapa Gideon in ahin lamkaiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Anunung pen chu Dan phung a aponlap noi a aloi loi a kitolho ahiuvin, amaho hi phungho jouse ngahmun vengtup a ahiuve. Amaho Lamkai pa chu ahileh Ahiezel, Ammishaddai chapa ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Amaho Banjomma hung kitol ho chu ahileh Okran chapa Piegel lamkaina a Asherte aloiloi a umho ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Chuleh Enan chapa Ahira in ahin lamkai, Naphtali te aloiloi a umhon ahin jui un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Hitia hi agol gol a Israel chilhahte, ama ama kihopkhen dol cheh a hung kitol jiu ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Nikhat chu Mose’n ajinu sopi pa, Median mipa Reuel chapa Hobab kom'a aseiyin, “eiho hi Pakaiyin ei tep pehnao lam chu jot jing ihiuve, ajeh chu Pakaiyin asei chu, 'ka pehding nahiuve'. Nangma keima holah hung tan, keihon nangma ngailut tah a kabol diu ahi, ajeh chu Pakaiyin Israel te chu kidangtah phattheina ho bohding kitepna anei ahi' ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobab in adonbut in, 'Ahipoi, keima kache louding ahi. Keima ka gam le ka insung mite henga kile ding kahiye.' ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mose ataovin ahi, 'Neidalhah hih un, gamthip a hoilai a ngahmun kisongding ham ti nangin nahet ahi. Hungin land neihun lamhil un. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kaseinei nop peh leh, Pakaiya kon phattheina kachanho jouseu i nei khom diu ahi' ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Hiti chun Pakai molsang chung adalhah jou uchun nithum sung ana kitol un, kingah nading mun phochen dingin Pakai kitepna thingkong in ana amakai un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Hitia niseh a lam ajot jing lai un, Pakai meibol lom in akhu khum jingun apuile jing uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Chule thingkong chu akitoldoh ji teng, Mose’n aw sangtah in a sam ding, “kipatdoh tan, O Pakai, namelma te kithecheh uhen, nangma angsung a kon'in jammang uhen” atiding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Chule thingkong chu akikoi lhah teng, “Simsenlou asang sang umna Israel te heng a hung ki le kit tan Pakai” tia aman aseikit ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Phat chomkhat jouvin mipite ho chu hahsat genthei jeh a lunglhei louna ahin phong doh tauvin, chule Pakaiyin aseidohho jouseu abonchan ajasohkeiyin ahi. Hiche Pathen lunghanna chu amaho chunga akoujah jengtan, amaho hal vam ding meikong asoltan, chule ngahmun polam a um mi phabeppi chu asumang tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Hichun mite ho chu Mose henga kithopina ngaichan akap un amao tauvin, chuin Mose chun Pathen henga taona anei phat in, meikong chu athiptai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Phat chomkhat jouchun, hiche lai lhang chu Taberah(Hichu 'mei kou namun' tina ahi) tin akihetai ajeh chu Pathenna konna meikong chun amaho lah a mi phabep ahal lhah namun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Israel mite toh lamjot khom namdang ho chun Egypt gam'a neh le chah ho chu ahin ngaicha tauvin, hichun Israel chate jong ahung kiphin kit tauvin, “Oh, Sa themkhat beh neipe un!” tin a eujah tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Egypt gam sung a nga aman beija kaneh jiu ka lhangai jun ahi. Chule changmaiho, donkhoho, leeks, louthul atil neiho, chule changnam(Garlic) ho akingai cha chan akimu thei je tin asam uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ahinlah tuhin imacha ka duchat hou kanei tapouvin, Tua kamu kaneh jing uhi hiche Manna bou hi ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Manna kiti chule louthul amu neocha cha hotobang ahin hiche ai-eng tobanga eng dup a kiselum a ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Mipi chu pamlam a gache uva ahin kilokhom uva, changbong tobang asothei nadia khutpei changsuhgoina manchah amangcha jiuvin ahilou jongleh agoi nel tho jiu ahiye. Hiche ama hon changbong tobang chu bel lah ahon uva changlhah pheng ahin sodoh sah jiu ahi. Changlhah pheng chu Olive thao toh kihal jia nehthei tui in atui in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Hiche manna chu ngahmun'a jankim teng daitwi toh hung khelha tha jia ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Hichun Mose’n mipi ho jouse ama ama insunga amaponbuh a in kotbul a kiphinna husa ajan, chule Pakai lunghanna akhong gei leutan, Mose jong alung nopmo asah lheh in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Chuin Mose’n Pakai henga aseijin, “Ipidia nasoh hi hiti lom lom a hi nei gimbol hitam? Kachung a khotona nei nei in! Bolkhel ipi kanei a, mipi ho pohgih jouse kapoh ding naphal ham? ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Keiman amaho hi kahindoh sa hiuvem? hiche vannoiya hi ka hin poh lut hiuvem? Minun naosen ajenle a apoh le bang a ipi dia amaho hi kaban a kadople ding a nei seipeh ham? Apu apateu nana peh na gam a chu iti keiman amaho hi ka puilut jou ding ham? ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Keiman hoilam a hiche mipi ho neh dinga saphe ka lah ding hitam? Amaho akiphin phin jengun, “Saphe kaneh ding nei piuvin!” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Keiman hiche mipi ho hi kachangin ka jou tapoi! Hiche pohgih hi kapohjou kalval in agihtai! ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Hitobang tah a hi gimsah ding mong neitileh, kipat inlang nei that doh tan. Neihin khohsah inlang hiche gim genthei ho a kon hin nei huidoh o!” ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Hichun Pathen'in Mose kom'a ahinsei in, “Keima angsung a Israel mipi te lamkai leh Upa ho som sagi hin puilut in. Hiche lamkai ho chu Houbuh a nang doh ding khom uhen. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Keima hung kumlha ingting kahin houpi ding nahi. Keiman nang a um lhagao phabep khat la ingting amaho chunga hiche lhagao chu ka khumlut peh ding ahi. Ama hon mipi ho pohgih chu a pohhu diu, nangin nachang a napoh ngailou ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Chule mipi ho chu seipeh un, 'nangho kisutheng un, ajeh chu jing nikho teng nang hon sa neh ding nanei ding u ahitai. Nangho na kiphin un, chuleh Pathen'in naka nau ajatai. 'Saphe themkhat jeh in Egypt ma um kanom jouve! na tiuve' tua hi Pakaiyin nangho nahin peh diu naneh tei dingu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Hichu nikhat ahilouleh nini tina jong ahi tapon, ni nga, nisom chule nisomni tina jong ahi tapoi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Nanghon lhakhat sunga nachimdeh tokah uva naneh diu ahi. Ajeh chu nang hon nakom uva um jing Pakai napampai un, chuleh ama kom'a kiphinnan naseiyun, “Idia Egypt gam ihin dalhah mong mong uham” natiuve.”” ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Ahin Mose chun Pakai chu adonbut nin, “tua hi mihem sang jagup keima toh um kahiuve, ahin Pakai nangma in 'lhakhat sungse aneh diu kapeh ding ahi! nati.' ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Kaganchan neihou jouse kithat jongleh, mihem hijat kipejou nantem? twi khanglen’a um nga jouse kiman hen lang hita jongleh hiche ho jeh achu lhing mong ding hinam? ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Hichun Pakaiyin Mose henga thu aseijin, “Ka khut hin atha lhasam aham? Tua hi nangman ka thusei hi atah ahi alhem ahi na hetchen ding ahitai!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Hichun Mose aga potdoh tan Pakaiyin ahenga asei bang chun mipi ho aga hetsah tan ahi. Mose’n Upa ho mi som sagi asukhom in chu Houbuh kim vella chun adin sah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Chuin meilom lah a kon chun Pakai ahung kumlhan Mose chu akihoulim pitai. Hichun Upa somsagi ho chu Mose apeh bang bang Lhagao chu amaho jouse chungnga apetan ahi. Chule lhagao ho chun mi somsagiho chunga achuh phatun, gaova thu aphongdoh tauvin ahi. Ahinlah hiche tobang thil umchan dol chu asoh kit tapon ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Mipa ni Eldad le Medad chu ngahmun nunglam ah aum lhonin ahi. Amani chu upaho min kijih lut na a ajao lhonin, ahinlah amanin houbuh chu adalhah hon lou beh ahitai. Ahijeng vang in amani chunga jong chun Lhagao chu aum tan, hichun amani jong chun gaothu aphong doh lhon e. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Pasal gollhang khat alhaiyin Mose kom'a thu chu agah lhut tan, “Eldad le Medad in gaothu aphong doh lhon tai!” ahung ti. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Nun chapa Joshua, aneo laiya pat a Mose kithopi a hung pang pa vang chun lunglhai louna aphong doh in “Mose kapu, Eldad le Medad khu kicholdo sah tan!” tin aseiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Ahinlah Mose’n adonbut in, “Keima a ding ngaito na a ipi na thangset pi ham? Keiman ka dei pha ka sah vang chu mijouse hi themgao hihen lang chuleh Pakaiyin alhagao chu amaho jouse chung nga jong chun koi cheh le kati!” atin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Hichun Mose jong chu Upa ho chutoh ngahmun kom langa akile kit tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Hiti chun Pakaiyin Vamin puidingin twikhanglen a huipi ahin nunsah tan, ngahmun chung leh kimvel jousea vamin akhehsah tan ahi. Amaho umna akon a avetna lamlam u miles a gamla chan a chun tol a kon feet thum sang bou leng thei Vamim adimsoh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Hichun mipi chu a potdoh'un hiche Vamim chu nilhum kei jin aman un hiche ni jan khovah keijin jong chuleh ajing gei jong chun aloh khom na laijun ahi. Koiman bushels somnga sang a lhomjo amanpouvin ahi! Ngahmun kimvel a chun Vamin sa ho chu agot nadingin aphou un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ahinlah Israel ten saphe chu akam uva alhai’u aval lhah ding kontah u chun Pakai lunghanna achung uva ahung chu tan, pul gimneitah alhunsah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Hiti ahijeh chun hilaimun chu Kibroth-Hattaavah(milop ho lhankhuh) aki sahtai ajeh chu ama hon Egypt lamah saphe ngai cha jing miho avuinao chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kibroth-Hattaavah apat chun Israel mite chu Hazeroth gei chu ahung kitol un, phat chomkhat hilai mun a chun ahung kichol uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Hazeroth mun'a aum laijun, Mose in Cush a kon numei khat akichenpi jeh in Miriam le Aaron chun ama demna thu aseilhontai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Amani hiti hin asei lhonin, “Pakai chu Mose henga bou kilah thei ham? Eini heng a jong hung ki lahdoh hung kilah hilouham?” atilhon e. Hilah amani thusei chu Pakaiyin ajasohkei in ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Mose chu akineosah lheh jengin ahi- Leiset a akineosahpen pa sang'in akineosah joh nalai in ahi). ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Hichun gang tah in Pakaiyin Mose, Aaron chule Miriam chu akouloi in hitin aseipeh tai, “Nathum un Houbuh lama gache tauvin” ati, hichun amaho thum in jong hilam chu ajon tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Chuin Pathen chu meilom in ahung kumlhan houbuh lutna a chun ading den in, “Aaron leh Miriam” tin ahinkou in ahileh, amaninjong ahin nailut lhonin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Chuin Pathen'in ahoulim pilhonin tuhin ka thusei ho hi ngailhonin: “Nangma ho lah’a themgao um ahileh, Keima, Pakaiyin, gaova kaki phon tah hih ding ham. Ahilouleh manga kaki houlim pi ding ahitai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Hinlah kasohpa Mose vang hitobang chu ahipoi, Ka insung pumpi a ama hi katahsan pentah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Keima ama toh gaophelphul hilouva kichentah kimaingat toa kihoulim kahi lhon e! Aman Pakai chu ahina bang tah a amu ahi. Chiti ahileh idia kasohpa Mose dem ding kicha lou nahivem? ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Pakai chu amaho chunga chun alunghang lheh jeng tan, a dalha lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Houbuh chunga meilhang akitol toh lhonin, Miriam chu adingin, Tiphah natna jeh chun avun chu buhbang banginabang tan ahi. Aaron in Miriam chunga thilsoh ijakai amusoh phat in, ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Mose henga akaptan, “Oh! kapu hiche ngol-hoitah chonsetna kana boldoh jeh lhonin gotna neipelhon hihbeh in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Amanu jong hi naosen athisa a hung peng, apen lhah lhah a amonsa banginkoi hihbeh in,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Hichun Mose Pakai anga a akapjah jeng tan, “O Pakai, katao ahi, lung set tah in amanu hi damsah tan!” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Ahin Pakaiyin Mose jah a seitan, “Amanu hi apa chun achil aset khum hitaleh, ni sagi sung chu aboh a um a jum le ja athoh louding ham? hijeh chun amanu hi ngahmun pamlamma nisagi sung koidoh un lang, chujou teng lah lut kit thei hi ding ahi” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Hiti chun Miriam chu ngahmun pam lamah ni sagi aumsah un, chuleh akitol kit masang un, amanu chu ngahmun sung nga ahung kit ding chu mipi ho chun angah un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Hiti chun Hazeroth adalha tauvin ache peh un Paran gamthip munkhat a ngahmun khat akisemkit tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Pakaiyin Mose aseijin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Canaan gam, Israel chate kapehna gam gakhol toh ding Pasal ho sol in. Phung som le ni ho a kon a lamkai khat cheh sol tan” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Hichun Mose’n Pathen bang chun abol tai. Paren gamthip a angahmun uva kon chun, phung lamkai cheh mi som le ni asol tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Hiche ho hi amin uleh aphung min cheh uchu ahi: Reuben sungkon Zaccur chapa Shammua ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simeon sungkon Hori chapa Shaphat ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Judah sungkon Jiphanneh chapa Caleb ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Issachar sungkon Joseph chapa Igal ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Ephraim sungkon Nun chapa Hosea ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Benjamin sungkon Raphu chapa Palti ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Zebulun sungkon Sodi chapa Gaddiel ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Joseph chapa Manasseh sungkon Susi chapa Gaddi ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dan sungkon Gemalli chapa Ammiel ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asher sungkon Michal chapa Sethur ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Napthali sungkon Vophsi chapa Nahbi ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gad sungkon Malki chapa Geuel ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Amaho chengse hi Mose’n gamkhol dinga alhen doh pasal ho chu ahiuve. (Mose’n Nun chapa Hoshea chu Joshua in akou e) ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mose’n hiche Pasal gam leiset kholchil dinga ngansena anei a soldoh ho chu thugahna aneiyin: “Sahlam Negev hopa thinglhang lam naho diu ahin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","gam umdan ijakai kholchilna naganei diu, hiche gam a um mihem ho chu hat uvem lhasam uvem, tam uvem lhom uvem ti nahin khol doh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Gam chu gampha ham phalou ham? kulpi bang anei uvem ahilouleh ngahmun mei mei a um uham? itobang gam a um uham ti hin vetoh un. Amaho chenna gamho chu apha ham, aseham akhosah dan u ijakai hinkhol un chule khopi umdan jong hinve chil un. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Leiset chu thao putna ham ahilouleh gamgo apha lou ham? Hilai kom dunga chu thing phung tamtah um hinam? Theitop hinso unlang thingga louga ho jouse vetchil din hinpo un. (hiche phat chu lengpi ga lophat ahi laitah ahi) ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Hichun ache touvun Zin gamthip apat akhol chil un Rehob gam Leboh Hamath kom dung gei chu abonchan gakholsohkeiyun. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Sahlam ahouvin, Negev gamthip mun ajot pauvin chuin Hebron alhung tauve. Hikom mun chu Ahiman, Sheshai, chuleh Talmai (Anak chilhah ho) chen na ahi. (Hebron khopi chu Egypt khopi Zoan sanga kum-sagi masanga ana um ahitai.) ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","ama hon Eshcol phaicham ahin phah uchun lengpi thei boh khat ahin sat lhauvin, aletthei beh jeh chun moljol a minin ahin pu un ahi. Kolbuthei leh theichang ga ho jong vetchil dingin ahin ahinpo lhungun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Hiche lai mun chu Eshcol phaicham aki tin ahi. Ajeh chu gamvelhi Israel mihon hilai mun a chu lengpiga aboh a ahin satna mun u chu ahi ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Ni somli jen gam le go kholchilna anei jou phat un Pasal ho chu ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Mose, Aaron chule Israel mipi ho kom Paran gamthip, Kadesh mun a ahung kinungle tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Hichun ama hon Mose jah hiti hin aseiyun: “keiho gamkholtoh dia nei nganse nauva kache uchiun, agam chu anom in avethoilheh jengin - Khoiju leh bongnoi lkonna gam ahi. Hichengse hi gamsunga gasoh ho chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ahinlah hilai gam'a umho chu athahat theiyun, chuleh a khopi hou jong chu alen thei in hoitah in aveng tup un ahi. Chuleh Anak chilhah milen ho jong chu kaga mu uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amalek mite chu Negev a acheng un, Hit mite, Jebus nite chuleh Amor mite ho jouse thinglhang lam a acheng un ahi. Cannan mite chu Jordan phaicham leh Mediterranean twi pi pang dung a acheng un ahi.” ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Ahinlah Caleb in Mose angsung a thulhut miho chu suhthip ding angaiton, “Eiho cheu hitin gam chu gala jeng uhite” atin, “Eihon ijo tei tei diu ahi” atin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Amavang Caleb toh gam kholle a che ho chun “Amaho eiho sang a hatjo ahijeh un, eiho jo jou ding ahipoi” tin anom pouvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Chuleh lunglhahdai na thulhut joh chu Israel mite lah a ahin sei phong uvin: “Kache uva kakhol chil u gam leiset chun koi hileh hilai mun a cheng ho chu avallhum ding ahi. Kahin mi mu ho jouseu jong chu alen thei un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Chuleh keihon milen tah tah, Anak chillhah mite jong chu kamu uvin ahi. Amaho toh tedingin eiho hi khaokhoho tobang bep ihiuvin, ama hon jengin jong hitia chu eigellu ahiye” atiuvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Hichun Israel mite abonchauvin aw-sang tah in akap un chu leh amaho chu jan khovah geijin akap’un hiche mipi ho awgin chu lakisa’a ki thong banginMose leh Aaron dounan aboldoh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Hiche mipi awgin lakisa chu akithong jingin Mose le Aaron douna kibol ahin Egypt gamah ana thidoh kihi le pha jonte tin asam uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Pakaiyin hilang gam lah ahi eipui doh jing’u ham gal’a thi bep dinga ka jite hou numei chapang jaona athigam bep dinga Egypt gamsunga konna neihin puidoh u ham tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Hi chun Amaho khat le khat aki hou khom mun eihon lamkai thah lheng u hitin Egypt lamah kinung le tau hite tin akihou lim tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Hichun Mose le Aaron chu Israel mite jouse masang tol lang ngan akun lha lhon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Pasal mini gam kholla che teni chu Nun chapa Joshua le Jephanneh chapa Caleb chun aponsil lhon abotkeh lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Ama nin Israel mipi te ho lah’a asei lhon tan, keini’n ka khol chil lhon gam ho chu ki dang tah le loupi tah ahiye, tin asei lhon’e. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Chule Pathen hi eiho dinga hiche gamsung khu eiphatsah peh uva ahi tan Pakai chun agamsunga ei pui lut diu, khoiju le bongnoi lkonna gam ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Pakai chu douhih un, chule hiche gamsunga chengte jong kicha hih un. Eiho a dingin amaho khu apanpi ding umlou anchah a pang tobangbep ahiuve! Avengtup ding anei pouve, Pathen thahat chungnung aum'inaman abanthahat in ei panpi jing diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Amavang Mipi jouse chu Joshua le Caleb chu songa se lih ding agong tauvin Pakai, Pathen loupina chungnung chu Israel te chunga ahung kitah lang tan houbuh thingkong chu ahung kilah tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Chuin Pathen'in Mose chu a houlimpi tan itih chan hiche Israel mite hin donlou nahsah louva eikoi diu hitam? Thet-um tah thil ki dang tampi aboldoh tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Keiman amaho chu ka kihet mosah ding chule ka suh mang ding ahiuve. Ahinlah keiman nangma mihat tah ka so ding, Amaho sanga hat jo phajo ka so ding na hi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Ahinlah Mose vang chu anom pon a lung phamo lheh in Egypt miten ipi agel diuvem hiche thil um dan ahin het teng ule Mose’n Pathen chu adong tan Egypte ahat soh hel lin nangma tha hatna Israel mite na hin pui doh’a Egypt apat na hung sohchat’u ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Pakai, Pathen nangma tun hiche Israel mite hi na suhmang le Egypt miten agam'a cheng ho lah’a alhut diu, nangma toh kimai to ahiuvin chule jan teng meikonga napui jun sun teng meilhang in na pui jiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Pakai nangman amaho hi ilou theh a na suhmang leh hiche nam mite na puidan kidangtah ana hesa nam mite chun, sei uvin tin, ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","Pakaiyin Amaho chu a suhgam na ajeh chu atep peh na’u gamsung chu apui lhung jou tahlou jeh ahi ati diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Pakaiyin nangma boltheina natoh chu jom in vetsah kit in. Pakai nangma in kiphong doh kit inlang, ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","Pakai, Pathen hi lung neng tah lunghang vahlou chuleh ngailutna dim jing chonset ngaidam them ahin suhkhel neite angaidam jing Pakai hi chonsetna ho ngaidam themji ahi kiti chu musah in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ngaidam min hiche mite chonset nahi keima Mose ka taona nei ngai peh inlang nami hepina leh ngailutna jal’a nangman hiche mite Egypt apatna na hin ngaidam jing sa bang chun. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Hichun Mose chu Pathen'in ahin houlim pitan nangma thusei dungjuijin ka ngaidam tai, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Tahbeh’a kasei ahi Keima hingjing Pathen chu kahi jeh in vannoi Leiset hi ka loupina dimset jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Hiche Israel chate ho lah’a hi koima jong katep peh gam lhung jou talou diu ahi. Ajeh chu Amaho jousen ka loupina chu ahetsoh hel’u ahin, chule thil kidangtah melchihna Egypt gam’a jong ka bol lin chule gamthip lah’a jong ka bol lin ahinlah ama hon tun avel lin ima lou tah in awgin sangtah in asam un, aki phin uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","Keiman apute apateu ka teppihna gam chu a amu lou beh diu, Amaho lah’a koi tobang eidou dal ho jouse chu imacha amu lou beh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ahinlah ka lhachapa Caleb vang hi midang hotoh alungel’a kibah louna aum'inCaleb hin hom tho tah’in eihou jingin hi ti ahijeh achu agam kholna mun'a chu ka pui lhung tei ding ahi, Caleb le achilhahte jouse hiche gam chu aboncha a alo soh hel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Tun nangma ki nunghei tan, nangman Amalek te ho, Canan mite ho chenna lang chu na jot lou beh ding, jing teng nangma kipat doh in gamthip lam nama no ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Hichun Pakaiyin Mose le Aaron henga hiti hin aseiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Itihchan hiche migilou namho toh hin ka chenkhom’a kaumpi jing ding ham? Kipah lou lunglhai louva ka chung’a aum jing uhin ipi avetsah hi tantem, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Tun amaho chu seipeh un. Keima hi Pathen ka hin kaum jingin nangma na sei doh na geldoh lou chu ka bol peh ding na hi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Nangho gamthipma thiden ding nahi tauve, ka chunga lungkim louna na neitah jeh un kum som nia pat chunglam sen thina ato ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Katepna gamsung na lo tahlou diu, Caleb, Jephanneth chapa chule amani Joshua, Nun chapa amani bou chun alo lhon ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ahinlah nachate khangthah ho nang hon mi thagam ding bep a na gel hou chu keiman ka panpi ding agam leiset na deimo sau gam chu a toupha diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Amavang nangho jouse na thilong uchu hiche gamthip nelgam ahi kivui lhum ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Na chate ho nachilhah hou vang hikom gam thip lah’a kum somli-le-li gei kelngoi chinga pang ding ahi tauve. Hi tobang’a chu nang hon nalou chalna hou na mu diu hiche nelgam ahi na thi soh heldiu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ijeh inem itileh, na lamkai hon ni somli jen lutna gam leiset kholla cheuva ahin na chonset jeh’a kisuh genthei ding na hitai nikhat lampi chu kum somli jen na jot ding u ahitai. Hiche teng chule nang hon Pathen toh melma a umhi itobang’a hahsa ham ti nahet doh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Keima Pakai, Pathen kahin na ka hin toh pan ding ahitai hiche mipi ho lah’a eidou’a pang jing ho chu hikom nelgam ma hi suh gentheiya umdiu chule amaho chu a hinkho kicha soh hel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Pasal som ho lah’a Mose gamvelhi dinga asol ho lah’a ami khat Pathen douna ana tong gopa chu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Pathen henga amapa chu pul in athi tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Gam kholchin lah’a pasal somle ni ahiuvin amaho lah achu Joshua le Caleb bou asoh cha uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mose’n Pathen thu cheng seidoh jouse chu Israel ho lah a aseipeh phat chun mipi ho chun nopma asah thei lheh jengun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Amaho chu a Jing nikho in, jingkah matah in aki thou un mol chungvum laitah a akaldoh un, aki hou uvin, Pathen douna a chonset natoh ibol doh’u ahitai, tun vang Pakai jin ei teppeh na’u gam chu jon tau hite aki tiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Ahinlah Mose’n adonbut in ibola nangho Pathen thupeh palkeh dia na got uva, Gamthip gam a kile ding na kisah u baham? ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Tun nang hon hiche gam-tep gam lam’a lut ding jong got datauvin, na melmateu khut ah gamla bepseu un nate, Ajeh chu Pathen'in na kithopi louhel diu ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Nanghon Amalek mite le Cannan mite na ki dinte pi tengu leh ama hon na tha gamhel lo diu ahitai. Ajeh chu ama nana dalhah tah jeh uva, Pathen'in nangho jong na dalhah’u ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Hinlah mipin atum tentun uvin, Mose jong pang lou, Pakai thingkong jong jao talou hel in, aki tol uvin thinglhang lam chu ama no tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Hichun thing lhang molchung lamma pansa ho chu Amalek mite leh Canaan miten ahin bulhu tauvin, hiti chun Hormah chan ahin del tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Chuin Pakaiyin Mose henga thu aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Israel mite chu hiche thuhil ho hi seipeh in, keiman ka peh ding gam Leiset mun chu na lhun teng ule, ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","Nangman pumgo maichamn thiltoh gimnamtui sellah Pathen heng nga napeh ding ahiye. Na gancha hon bong, kelngoi hon lah chule kelchal ho lah ajong ahoicheh pumgo maicham thiltoh kumlhunsih akibol banga chu napeh diu ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Nangma hiche maicham ho hi bol ding tia na gel teng Pathen Pakai chu mim le chang a kon na changbong chu gopni hi ding chule Olive thao chu Hopkhat hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Kelngoi chu khat pumgo maicham thiltoa na kat diu pumgo maicham thil to na dia lengpitwi jong hop khat maicham na hin to ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Pumgo thilto chu kelngoi ahile changbong kipe dol chu gal la Pathen’a dinga gim namtui tah hi ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Chule lengpi thei twi chu khon thum tobang twija maicham din sem in hichu Pathen adinga gimnam tui tah ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Nangman bongchal nou pumgo maicham thilto nabol teng Pathen’na dia kipana maicham kisuh thengna nabol ji ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Nangman mim le changbonga kisem hop gup hi ding chule Olive thao jaona hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Chule nangman hopni lengpitwi na peh ding hichu Pakai, Pathen adia gimnamtui tah hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Pumgo maicham jouse aboncha Kelchal hihen, Kelpi hihen, Kelnou hihen, chule adang jong hitia chu na bolsohkei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Nangman pumgo thilto napeh teng hiche thupeh ho hi najui ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Nangho Israel mite hiche mumna peng jousen Pathen heng nga gimnamtui maicham, napeh teng ule hiche thupeh ho hi najui’u angaiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Koi tobang nangho kom'a kholjin mi aum ham ahi lou leh acheng den aum khah jongleh Amaho jong chun hiche dan hi ajui cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Israel mite agam leiset mun'a peng dan hihen gampam ma kon hung pemlut mi hijongleh Pakai mitmu’a thakhat cheh ahiuve. Hijeh’a chu Dan khat noija um cheh ahiuve. Hiche hi nangho dia tonsotna jui dinga dan kisem ahin hichu najui diuva kipe ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Nangho ding hihen gamchom mi hung pemlut ho hiu jongleh, Hiche thupeh jui ding’a kigong ho hi nabolcheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","PakaiyinMose heng ah asei be kit in. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Israel te chu anoija thupeh thuhil ho hi seipeh tan, nangho ka pehna gam nalhun uva, ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Hiche gamsung gasoh ho naneh teng ule Pathen maicham ding jong na khen doh cheh cheh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Na lousoh mim le chang aga masa penchu changbong a na suhdi ding changlhah lumma na sem ding hichu Pathen a dinga gamasa pen ahijeh’a napeh doh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Ahunglhung ding khonung khang geija hiche maicham atheng Pathen hengnga pehdoh ding hi a kumsih leh najui ding na lou gasoh amasa pen chu na koidoh jing ding ahiye. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","I-ham tia Pakaiyin Mose henga athupeh chengse hi nahsahmo jeh hilouva, hetthem lou jeh joh’a na suhmil khah uva, ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","Khonung’a Na chilhah ho jengin jong Pathen thupeh ho a suhmil khah uva, ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","Hiche suhkhelna chu mipi jousen ana hetthem lou jeh ahi khah tah leh Israel mipi te chun Bongchal nou khat Pathen heng’a gim namtui thilto dia ato diu ahi. Chuleh Anneh ding thilto leh don ding thil to toh, chonset thilto adia kelnou khat ato tha diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Hiche ho jouse toh hin thempupan Israel mipi ho chu Pakai ma-sang’a a suhtheng ding chuteng amaho chu ngaidam ma umdiu ahi. Ajeh chu ama hon achonset nau chu ana hetlou jeh’u ahin, a maicham thilto jal uva, kingaidam diu ahi. Pathen heng’a chonset thilto leh kilhaina abol jal uva chu ngaidam kichan diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Israel mipite leh gampam mi abonchauva ngaidam a um nahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Koi tobang khat nin hethem louva chonsetna ahin bol tah leh, amapa chun kelpi kumkhat lhingset khat a chonset thilto ahin tohdoh ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Thempu chun hiche Pasal chu Pakai masanga asuh theng ding chuteng amapa chu ngaidam ma um ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Hiche thuhil hin nangma ho Israel chilhah ho na hiuvin chule midang, chi dang nam dang nagam uva khopem ho jouse jong ahopsohkei ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Hinlah nangho lah a koitobang ahe nasa’a Pathen deilam bollou vang chu Pathen taitom kiti ding chule amaho chu Israelte lah a pat’a chomkhen’a um ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ama hon Pathen thupeh chu he nasa a khohsah louva akoitah jeh un amaho jouse chu pum noa no mang ding ahi tauve chule achonset nau jeh’a gim gentheina a thoh diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israel mite nikhat gamthip akhosah laitah uchun mipi ho chun pasal khat nin Sabbath nikhoa na atoh a thing achom pettah ahin tohkha tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Israel te lah’a pasalpa thilbol mudoh jouse chun amapa chu Mose le Aaron chule mipi lah ahin puiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ama hon ipi lo ding ham atheilou jeh uvin munkhat na aumsah un ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Hichun Pakaiyin Mose chu a houlimpi tan “Hiche Pasalpa hi thina channa gotna chang ding ama chu khopi pam lamma mipin song’a ase lih ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Hichun mipi’n amapa chu ngahmun pam lam’a akai doh un song in asep lih tauve, hichu PakaiyinMose henga thu apeh bang banga abol’u ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Chuin Pakaiyin Mose henga thu aseiyin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Israel te chu anoiya thuchang kihil na ding ho hi seipeh kit tan. A ponmang jouse’u chu alum khat aba diu ahi. alum laichu ajem adum a naboldiu ahi. hichu akhang akhang a akivon diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","“Nangman hiche pon mangjem chu namu teng na Pathen thupeh sang’a tahsa ngaichat na joh nasuh bukim nomlou na diu ahi” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Hiche pon dum chun thupeh jui ding’a umho chu na hin tilkhou diu Pathen a theng’a umpa toh na kinai sah jing diu ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Keima na Pakai na Pathen Egypt gam'a petna na hin puidoh pa chu kahi ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Nikhat chun Izhar chapa Korah, Ama chu Levi Phung akon Kohath insungmi ahin, ama chun Reuben phung’a kon mi aki tep khom in, hite ni chu Dathan le Abiram, amani chu Eliab chate ahin, chule Peleth chapa On jaonan, ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Israel chilhah jouse phung lamkai jani le somnga jaonan Mose doumah in achon tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Amaho jouse thakhat tah in lungkhat in apang khom un Mosele Aaron heng nga hitin asei tauve. “Nangni hi nachat val lheh lhon tai. Israel mipi hin Pathen akhosah jingun, Pakaiyin keiho jong eiumpi jing nauve, nangnin ipi thahat leh boltheina, keiho sanga lenjo Pathen mite lah a hi neija ki gella na him”, tin asei uve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mose’n Amaho thusei ajah phat chun a kaiku jeng tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Hichun Mose’n Korahte nungjui ho lah achu hitin aseitai, jing teng Pakaiyin eihetsah diu ahi koi ho hi ama chate hiham tichu het dohna um ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Vo Korah nangma na hin nanung juiten, jing teng maicham thaomei halna chu na hin kichoi diu ahi ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Chuteng Pathen masanga koi chu a thengjo ham ti chu evet diu ahitai. Veuvin Levi chate ho nangho joh in nabol khel tauve ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Chuin Mose’n Korah henga asei in, Levi te insung injong ngai un, ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Pathen chun Israel mipite lah’a nalhen doh uva, ama jen ding leh a kintheng natoh tong ding’a na ngense uhi, thil neocha a ngaito na hiu ham ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Korah! Pathen'in hi tobang kintheng tongdia na sopite’u Levi te toh na ngense jing lai’uva, Themputna jong na holbe uva na ngaichat nahlai di’u ham? ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Nangho hin na doudal pentah uchu midang ahipon Pathen chu ahi bouve, Aaron chu koi na hisah uva ama chung chang’a nang lungphatmo na vetsah jing uham? ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Hichun Mose’n Dathan chule Abiram ahin Eliab chateni chu ajui din akou tai, Ahinlah amaho ada tauvin, Keiho ka hung doh nom pouve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ajeh chun Nangman Egypt gam sung khoiju le bongnoi lkonna gam'a patna neihin pui doh uva, tun hikom nelgam a thidoh dinga neikou’u ahi phaset talou ding ham? Nangma in tuchan geija keiho chung a lengpa vaipoh bang nga hi nei poh jing ding’u ham? ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ipi seibe ding um nalaija ham? Nang man Khoiju leh bongnoi lon na gam natina alah neipui hih laiyun, Keiho chenna ding gam la neipi pouvin, hon lei lhosoh ga konna ding gam lah aum pon, mingol bolla bol jing ding neigot nahlai uham, atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Hichun Mose chu a lunghang tan Pathen kom'a hitin aseitai. Levi ten chang minsa maicham ima ahin choi teng, anasan datan, Amaho akon imachacha ka lah aum khapon, Amaho doumah ima cha jong ka bolkhah aumpoi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Chuin Mose’n Korah kom'a hitin aseijin Jing nikho teng nangma na hin, na nung jui jouse hilai mun'a na hung ki khop cheh diu, Pathen masang nga na din diu, Aaron jong hikom'a hi hung ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Nangma nahin na nung jui mi jani-le-somnga ho jouse chun gimnamtui halnam na ding thaomei chu Pakai masang’a ahin kichoi cheh diu, Aaron thempu pa jong ama gimnamtui maicham halna ding ahin kichoiya hung ding ahi, ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Chuin amaho jousen maicham meihalna chu akilah cheh un, meikong chu ahal un Pathen maicham lutna phol lam a maicham phunga chun Mose le Aaron jong ading khom lhon’e. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Hiche phat don laitah chun Korah in mipi tam tah ahin tildoh tan Mose le Aaron gotna pe dingin amaho jouse chu houbuh maicham leitol lutna laitah’a chun aki khom khom tauvin ahi. Hiche Pathen loupina chu mipi holah’a hatah in ahung kilang doh tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Chuin Pakaiyin Mose le Aaron henga thu aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Mipi ho lah’a kon'in kinung khin doh lhon tan ajeh chu amaho hi abonchauva gang tah’a ka suh mang ding ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Amavang Mose le Aaron chu tol lhamma amai anga hon tan, O Pakai ati lhonin atao lhon tai. Pakai, Pathen nangma hinna nei jouse sempa chu na hi. Mikhat chonsetna jeh mei meiya mijouse na suhgam jeng ding hitam ati lhon e. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Chuin Pakaiyin Mose henga thu aseiyin. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Khuti ahileh Mipi ho chu seipeh tan, Korah ahin, Dothan chuleh Abiram houbuh a konna kichon doh ding’in seipeh in ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Chuin Mose chu a ding doh in Israel Upa ho jao na in, Dothan le Abiram ki ngah na mumna ponbuh lamma chun alhai tauvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Mose’n mipi ho kom'a chun gangtah in hiche migilou ho henga pat chun kikhin doh un chule nangman Amaho thilho jouse na tham khah louding, natham khat le achonset jeh uva gotna nachan thei diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Hichun mipi jouse chu Dotham le Abiram chule Korah khoi lu pon in na kon'in a kikhin doh tauvin ahi. Hi chun Dothan, Abiram le ajite ho ahiuvin achate ho jouse jaonan khoilu ponbuh kisah na leitol la ahungun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Chuin Mose’n aseijin, Pakaiyin eihin sol lona pentah katoh kabol ding ho hi keima chang’a kabol theilou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Hiche miho hi thi ngaina a athi uva, kivui ngai bang’a aki vui poupou uleh, Keihi Pathen hinsol kahi lou himei hen. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ahinlah Pathen, thilsoh thah khat abol ding, Leiset in akam akah’a amaho chu anei agou jouse’u toh avel lhum di’u, chuleh kotong sung’a chu khelut ding’u ahi. Chuteng chu leh hite ho hin Pathen asu lunghang tauve tihi na het doh thei diu ahitai ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mose’n hiche thucheng ho seichai man loulai jin, Leiset chu ahung poh keh in Amaho noilam a chun a joplha gam tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Korah mite jouse jong aloi agol ho chuleh anei agou abonchauvin hiche leivui chun akam akah in abonchauvin aval lhum soh heltai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Hichun amaho ahing lai pum in lhankhuh chu ajon tauvin anei agou hou jouse toh avuh khum tha tauve, chule amaho jouse chu Israel mipi te chilhah a kon'in agamla ahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Mipi avel’a um jouse chu amaho ka-le-mao awgin ajah phat un atija lheh jengun; “Eiho jong Leiset hin eivel lhum diu ahitai” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Pathen a kon'in mei ahung kong in, Pasal jani le somnga chu ahal vam soh tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Chuin Pakaiyin Mose henga thu aseijin. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","Aaron thempupa chapa Eleazar seipeh tan, Amaho atheng ahijeh uchun, kipat untin gimnamtui kihal na lhengkong ho chu mei-am lah’a kon'in loidoh henlang, a mei-am ho jong chu thaijah ta’u hen, ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Hiche ahing’a chonset bol hon amanchah kilhaina Lhengkong ho chu chomkhom uvin lang, Maicham khuna ding asin in sem un, ajeh chu ama hon Pathen lhaina dia atodoh sa’u ahin atheng a kisim ahi. Chuleh Hiche thilsoh hi Israel chate adin melchihna hi jing hen. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Hichun Eleazar thempu pan mi meiyin akahvamho sum-eng lhengkong ho chu achom khom in, Maicham phun khutup na sinkha din akheng tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Hiche hin Israel mite jouse a suhchih ding, koi hita jongleh nganse’a um Aaron insung mite hilou chun Pathen angsung’a gimnamtui hal dia lut loudiu ahi. A juilou chu Korah leh achilhah te banga um ding ahi tihi Pathen'in Mose kom'a aseisa ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Ahinlah ajing nikho’n Israel mite chun Mose le Aaron chu a oimo pan kit tauvin, “Nang nin Pathen mite nathat lhon’e” atiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Hiti chun mipite ho chun Mose le Aaron doudalna a, houbuh sung ano khum kigot laitah un Pathen loupina chu ahung kilang doh in, Meibol in ahin tom tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Mose le Aaron chu ahung lhei lhontan houbuh masang’a ading lhon tan, ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Chuin Pakaiyin Mose henga hiti hin aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","Hi tobang mihem ho lah a kon'in kikhin doh lhon tan keiman amaho abonchauva ka suh gam ding ahitai. Mose le Aaron chu tol’ah abohkhup lhon tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Chuin Mose’n Aaron kom'a aseijin nangman gangtah in maicham meikhat chu la inlang, houbuh maicham sem inlang Amaho din Pathen toh ki houcham loijin, ajeh chu gamna hise akipan tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aron in Mose seibang chun abol lin mipi te lah ah chu alhei lut in, gimnamtui ahal in mipi ho adin kilhaina abol in, alangsa gamna hise chu sutang ding agoi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Aaron chun mihem athi leh ahingho kikah ah palai jin adingin hichun pul chu atang tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Ahinlah pasal sangsom-le-sangli leh jasagi chu a thigam hel man tan hichu Korah chung chang jeh’a thiho kisim thalou ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Thina hise chu atan phat in, Aaron jong houbuh lutna kom'a Mose heng lam chu ahin jon tan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Chuin PakaiyinMose henga hiti hin aseijin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Israel mipi henga seijin, ama hon Tenggol som le ni hin kisem uhen, Insung leh a phungkai cheh uvin khat cheh kisem uhenlang, aphung lamkai mincheh hin kisut sohkei uhen, ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Phung lamkai khat min cheh chu kijih lut ding ahijeh in, Aaron min chu Levi te phung lamkai ding chun sun in, ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Hiche tenggol ho hi nangman nakoi tup ding houbuh masanga kimutona mun'a keima toh iki mutoh ji ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Hiche thingpeh ka lhen doh chunga chu hung pahdoh ding koija ahi het theina ding hiche tengleh keiman achaina natoh kahin nei ding nangma chunga kipah thei lou lung lhai lou na tong ho chung hi ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Hichun Mose’n Israel mipi chu hilgahna aneiyin chule Israel phungsom le ni lamkai ho jouse jong chu Aaron tenggol thingpeh jong chu ahin choiyun ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Mose’n hiche tenggol ho sese chu Pathen houbuh leitol Pathen um pettah in akoi lhah soh hel in houbuh het jing na ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Hichun Mose chu ajingin houbuh sung’a chun aga lut in ahileh Levi te insung thakhel dia kikoi Aaron tenggol chu ana dondoh in, amum aum in, apahlhah jouvin, aga chu Almond ahin, ana min kit tai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Hichun Mose’n Tenggol jouse chu Pathen masang nga ahin choi doh cheh in, aman hiche ho jouse chu mipi ho chu avetsah sohkeiye. Mi jousen ama ama phungkhai Tenggol vchu akilah cheh uvin ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Hichun Pathen'in Mose ahin houlimpi’n: Aaron Tenggol chu Kitepna Thingkong chung’a chu a-itih’a na tun jing ding ahi, Hiche chu miphalou ho hilna a pang’a, Pathen douna’a akiphin’u ajom ngam tahlou nadiu leh a thilham jina’u akon ahuidoh na diuva, hettohsah a pang jing ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mose’n jong Pathen'in ahil bang bang chun aboltan ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israel mipiten Mose kom'a hitin asei uvin: Keiho pihi among thah ding bep’a um kahi tauve. Keiho athisa kahi tauve, kei ho akichai gam ding kahi tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Ajeh chu Pathen maicham nailut jouse a hiti thi thuthu jeng pihi ati tauve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Pakaiyin Aaron heng ah thu aseijin, nangma na hin nachapate ahin, na insung Levi te chilhah hon na boncha uva Hou-In Theng sung’a boina le suhkhel jouse chung’a mo na poh diu ahi. Chuleh Thempu natoh na chung chnag’a mopoh na jouse vang nang leh na chapate chung’a bou chu ding ahi,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","“Na phung chanpi Levi chate ho chu nang leh na chapate toh Houbuh sung’a ki thokhom dingin, hin pui jin lang hungun, Kitepna Thingkong maija na toh diu kin hung tong pan tauvin,” ati. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Ahin Levi te vang chu houbuh maichama natong ache teng ule, amaho chu ching thei tah a aum uva na atoh’u a ngaije. Maicham mun theng lam ah thilkeo ho kom'a nailut louding ahi. Hiche ho chu atham khah tah uva ahile nangma na hin, na sopi ho abon na nathi soh hel diu ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Levi te tia kiminsah jouse houbuh maicham semna natoh na jouse jao cheh diu ahi. Ahinlah midang vang nangma toh natong’a nakitho pi dinga pang thei louding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Houbuh maicham kintheng sunga natong, akimang cha ding ho ahin nangman hiche thupeh jouse hi chingthei tah na jui leh Pathen lunghanna nangho Israel te chunga um kit talou ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Keima katah satah’a nangma Levi te lah na natoh khompi ding Israel te ka lhen doh peh ding ahi. Amaho jouse chu nangma dia hung kipedoh diu Houbuh maicham kin theng na tong ding ahiuve. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Ahinlah nangma nahin na chate jouse vang hiche kin theng maicham thempu natoh kiti jouse nang hon na tahsa tah’a nabol diu ahiye. Chuleh maicham phol sunga thil kimsel la pondal nung lam’a um jouse jong jaona ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Pakai thupeh jouse hi Aaron henga sei peh in hiche kinthenga Israel miten ahin toh hou chu vetup dinga ki nganse na hitai. Nangma nahin na chate ahin kin thenga hung ki tohdoh jouse hiche maichamma ho hi atonsot nadia mopohna ahitai. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Nangma maicham kinthenga thupi pentah chu mopoh na nakipe ahitai meivam min ahal lhah lou beh ding, maicham athupi pentah hiche ho chu: lou ahin mim le changa maicham chonset jeh’a chule themmona jeh’a maicham ho hi atheng chungnung maicham kiti ding hichu nangma ahin nachatea channa ding ahi. ");
INSERT INTO tczchongthu_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Nangman hiche maicham chu na toh ding, atheng chungnung pentah maicham jong ahin Pasal jouse anah thei cheh u ah