﻿USE sofia;
DROP TABLE IF EXISTS sofia.tcs_vpl;
CREATE TABLE tcs_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tcs_vpl WRITE;
INSERT INTO tcs_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mina prapa longtaim, bipotaim, God i bin meke da skai ane ebriting de antap wea da skai, da lan ya daun ane ebriting lo da lan. ");
INSERT INTO tcs_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Da lan ya daun ane ebriting lo da lan i bin prapa no bin kamaut yet ane i bin gad prapa nating. Daktaim i bin kabare da prapa bigwata ane da Spirit blo God i bin mub antap lo dat prapa bigwata. ");
INSERT INTO tcs_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Den God i bin oda diskain, ‘Lait kamaut nau,’ ane wen God i bin tok dis tok i bin gad lait. ");
INSERT INTO tcs_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Ane wen God bin luk lait, em bin nadakain api. Den God i bin splitap da taim blo lait prom da taim blo daktaim. ");
INSERT INTO tcs_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","God i bin kole lait ‘Deitaim’ ane dak ‘Naittaim’. Ane i bin gad deitaim ane naittaim. Diswan i bin namba wan dei. ");
INSERT INTO tcs_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Den God i bin oda diskain, ‘Meke speis melen wea dem wata solong wata i go stap antap wea da speis ane wata i go stap de andanit wea da ert.’ ");
INSERT INTO tcs_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ane i bin apen wiskain God i bin odarem. Wa! God i bin meke speis po meke ol wata po stap antap wea da speis ane ol wata stap andanit wea da speis tu. ");
INSERT INTO tcs_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","God i bin kole speis ‘Skai’. Ane i bin gad deitaim ane naittaim. Diswan i bin namba tu dei. ");
INSERT INTO tcs_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Den God i bin oda diskain, ‘Wata ya andanit lo skai, kam klostu po wananada, solong drai graun i go kamaut.’ Ane i bin apen wiskain God i bin odarem. ");
INSERT INTO tcs_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","God i bin kole da drai graun ‘Lan’ ane em kole da wata ‘Solwata’. Ane wen God i bin luk diswan, em bin nadakain api. ");
INSERT INTO tcs_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Den God i bin oda diskain, ‘Laue lan po groe ol bus, po groe ol plant wea i lego dempla sid ane po groe ol pruttri.’ Ane i bin apen wiskain God i bin odarem. ");
INSERT INTO tcs_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Wa. Ane ol bus bin kamaut, gro wea da lan ane olkain plant wea i lego sid. Prom dem dipren sid mo seimkain plant, gras ane tri i gad prut i bin gro. Ane wen God i bin luk diswan, em bin nadakain api. ");
INSERT INTO tcs_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ane i bin gad deitaim ane naittaim. Diswan i bin namba tri dei. ");
INSERT INTO tcs_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Den God i bin oda diskain, ‘Nadakain plenti lait kamaut nau insaid lo speis blo da skai po meke deitaim lait sain wea wan ples, ane naittaim lait sain wea nada ples. Ane dem nadakain plenti lait go soe sain blo ol sizan, sain blo ol taim blo dem dei ane sain blo ol dem iya. ");
INSERT INTO tcs_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Ane dem nadakain plenti lait mas laitap da speis blo da skai, solong dem lait i go sain godaun po lan ya daun ane ebriting wea da lan.’ Ane i bin apen wiskain God i bin odarem. ");
INSERT INTO tcs_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","God i bin meke tu nadakain big braitlait; da prapa braitwan po bi bos blo deitaim; da san, ane da no prapa braitwan po bi bos blo naittaim; da mun. Ane God i bin wantaim meke ol sta. ");
INSERT INTO tcs_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","God i bin pute demtu mina big braitlait ane dem sta insaid speis blo da skai solong dem lait i go sain godaun po da lan ya daun ane ebriting wea da lan. ");
INSERT INTO tcs_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Dem lait i gobi bos lo deitaim ane lo naittaim, ane dem lait i go splitap taim blo dei prom taim blo nait. Ane wen God i bin luk diswan, em bin nadakain api. ");
INSERT INTO tcs_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ane i bin gad deitaim ane naittaim. Diswan i bin namba po dei. ");
INSERT INTO tcs_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Den God i bin meke oda diskain, ‘Olkain pis ane plenti ol laipsamting swim lo solwata. Olkain pizin plai antap lo da lan ya daun wea speis blo skai.’ ");
INSERT INTO tcs_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Wa, God i bin meke dem nadakain big laipsamting blo solwata, ane olkain ebri pis wea i stap insaid lo solwata, ane olkain pizin lo speis blo skai. Wen God i bin luk diswan i bin nadakain api. ");
INSERT INTO tcs_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","God i bin blese demting ane i bin spik diskain, ‘Yupla insaid lo solwata, yupla brid ane kam plenti ebriwea insaid lo solwata. Yupla pizin antap lo da lan, yupla brid ane kam plenti ebriwea antap lo da lan.’ ");
INSERT INTO tcs_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ane i bin gad deitaim ane naittaim. Diswan i bin namba paib dei. ");
INSERT INTO tcs_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Den God i bin oda diskain, ‘Lan, lego kamaut olkain plenti laipsamting; plenti teimanimal wea i gud po kaikai, ane olkain plenti smolanimal, ane olkain plenti wailanimal po wagbaut lo lan.’ Ane i bin apen wiskain God i bin odarem. ");
INSERT INTO tcs_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","God i bin meke olkain plenti teimanimal wea i gud po kaikai, olkain tumas smolanimal ane olkain plenti wailanimal blo lan ya daun. Ane wen God i bin luk diswan, em bin nadakain api. ");
INSERT INTO tcs_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Den God i bin tok diskain, ‘Yumpla go meke ol pipol solong dem pipol go gad seimkain imiz wase yumpla. Meke dempla po kam bos blo ol laipsamting: ol pis blo solwata, ol pizin, ol teimanimal, ol wailanimal ane ol smolanimal i wagbaut ya antap lo da lan.’ ");
INSERT INTO tcs_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Wa, God i bin meke ol pipol wea seimkain imiz wase em. Em bin meke pipol po bi prapa wase em. Em bin meke dempla, man ane oman. ");
INSERT INTO tcs_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","God i bin blese dempla ane God i bin spik po dempla, ‘Yupla go kam plenti ane yupla go gad plenti pikinini ebriwea lo da lan ya daun. Yupla gobi bos blo da lan ane yupla mas lugaut da lan. Ane yupla gobi bos blo dem pis, dem pizin ane ebri animal ya lo da lan.’ ");
INSERT INTO tcs_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","God i bin tok gen diskain, ‘Prapa tru! Antap lo da lan, ai bin gibe yupla ebri plant wea i go lego olkain sid, ane ebri pruttri wea i go lego olkain prut gad sid insaid. Demwan i kaikai blo yupla po kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Ebri plant wea i lego sid ane ol nada plant, ai bin gibem po ol animal, ane po ol pizin po kaikai blo dempla.’ Ane i bin apen wiskain God i bin odarem. ");
INSERT INTO tcs_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","God i bin luk ebrisamting wea em bin mekem ane em bin mina nadakain api wea ebriting em i bin mekem. Ane i bin gad deitaim ane naittaim. Diswan i bin namba siks dei. ");
INSERT INTO tcs_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","God i bin pinis meke ebriting: skai ane ebriting antap wea skai, ane lan ane ebriting ya daun lo lan, ane ebrisamting insaid wea dempla, i bin pinis mekem. ");
INSERT INTO tcs_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Wen God i bin pinis meke dem wok blo em, em bin spel prom meke ebri wok blo em. Diswan i bin namba seben dei. ");
INSERT INTO tcs_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","God i bin blese namba seben dei. Ane em bin meke namba seben dei oli bikoz i bin namba seben dei wea God i bin pinis ebri wok blo em, ebriting wea em bin mekem. ");
INSERT INTO tcs_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Diswan i wanem bin apen lo da taim wen da AntapGod i bin meke skai ane ebriting antap lo skai, ane ebriting wea i bin mekem ya daun lo lan. Wea da taim wen da AntapGod i bin meke lan ane ebriting wea lan ane skai, ");
INSERT INTO tcs_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","i no bin gad bus ane sid blo plant po gro lo da lan, bikoz da AntapGod i no bin meke rein po poldaun antap lo lan. I no bin gad nobodi po wok ane digemape graun po plante dem gadan kaikai po kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Bat wata i bin kamap prom andanit da lan ane i bin go ebriwea ausaid ane wete ebriwea lo graun. ");
INSERT INTO tcs_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Den da AntapGod i bin teke graun prom da lan ane em bin meke bodi blo wan man prom da graun. God i bin bloue win blo em wea i gad laip go insaid nos blo da man ane da man i bin kamlaip. ");
INSERT INTO tcs_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ane da AntapGod i bin meke gadan insaid lo wan ples i kolem Iden, wea istsaid. Da AntapGod i bin pute dat man wea dat gadan wea em bin mekem. ");
INSERT INTO tcs_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Da AntapGod i bin meke prapa olkain nais tri po gro de, ane ol i bin mina nais po wasem ane dempla lego ol prapa gud kaikai. Ane insaid, melen lo da gadan i bin stanap da tri i gibe laip, ane nada tri wea i gibe sabe blo gud ane sabe blo nugud. ");
INSERT INTO tcs_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Wan prapa big riba i bin ran go ausaid prom Iden go po wete dat gadan. Prom de i bin splitap kam meke po dipren riba. ");
INSERT INTO tcs_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Da neim blo dat pas riba i bin Pison. Em i da wan wea i ran goraun lan blo Abila, wea i gad ol gold. ");
INSERT INTO tcs_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Gold blo dat lan i prapa gud gold, ane i gad olkain tri i gad gud smel. I gad ol prapa nais kala ston de tu. ");
INSERT INTO tcs_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Da neim blo da sekan riba i Gion. Em i da wan wea i ran goraun lan blo Kus. ");
INSERT INTO tcs_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Da neim blo namba tri riba i Taigris, wea i ran goraun po istsaid blo lan blo Asu. Ane da neim blo da namba po riba, i Yupreitis. ");
INSERT INTO tcs_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Da AntapGod i bin teke dat man go ane pute em insaid lo da gadan blo Iden po digemap graun, plante gadan kaikai po kaikai, ane po lugaut dat gadan. ");
INSERT INTO tcs_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Ane da AntapGod i bin gibe oda po da man ane spik diskain po em, ‘Yu ken kaikai ebri prut blo ebri tri insaid lo da gadan, ");
INSERT INTO tcs_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","bat prut blo da tri uda gibe sabe blo gud ane sabe blo nugud, yu mas no kaikai em. Lo seimtaim, ip yu go kaikai em, yu go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Den da AntapGod i bin spik diskain, ‘I no rait po man po stap emselp. Ai go meke wan pren po em uda i gobi longsaid lo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Wa. Da AntapGod i bin meke ol animal prom graun, ane ol pizin, ane da AntapGod i bin teke dempla kam po Adam po luk wanem em i go kole dempla. Wiskain da man i bin kole ebri laipsamting, diswan i gobi neim blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Da man i bin neime ebridem animal wea i gud po kaikai, ane em i bin neime ebridem pizin, ane em i bin neime ebridem wailanimal. Bat da man i stil no bin gad pren longsaid lo em. ");
INSERT INTO tcs_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Den da AntapGod i bin meke da man po mina dedslip. Den apta wen em bin slip, da AntapGod i bin tekemaute wan rib blo em ane em bin klozem baigen. ");
INSERT INTO tcs_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ane da rib wea da AntapGod i bin tekemaute prom da man, i bin meke wan oman ane em bin tekem go po da man. ");
INSERT INTO tcs_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Den da man i bin spik diskain: ‘Diswan nau, pren blo mi. Em i bin kamaut prom mi. Em i mit ane bon blo mi. Diswan ai go kolem “oman”, bikoz i bin tekemautem prom “man”.’ ");
INSERT INTO tcs_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Daswai nau man i go libe papa ane mama blo em ane mata stap klostu wea oman blo em, ane demtu nau kam tugeda kamwan. ");
INSERT INTO tcs_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ane da man ane oman blo em i bin neket ane demtu no bin gad sem. ");
INSERT INTO tcs_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Wa. Da sneik i bin prapa smat prom ol dem nada animal wea da AntapGod i bin mekem. Da sneik i bin tok diskain po da oman, ‘Ei, lisen pas. God bin spik dis tok a? “Yu no lau po kaikai eni prut prom ebri tri insaid lo gadan a?” ’ ");
INSERT INTO tcs_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Dat oman i bin ansabaik po da sneik ane spik diskain, ‘Mitu ken kaikai prut prom eni tri insaid lo da gadan, ");
INSERT INTO tcs_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bat God i bin spik diskain, “Yutu no lau po kaikai prut prom dat tri wea i melen lo gadan, ane yutu no lau po tasem, bambai yutu go ded.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bat da sneik i bin spik diskain po da oman, ‘Nono, i no tru! Yutu nogo ded. ");
INSERT INTO tcs_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","God i sabe wen yutu go kaikai prut prom dat tri, yutu go sabe niu samting: yutu go kam wase God. Yutu go gad sabe blo gud ane sabe blo nugud.’ ");
INSERT INTO tcs_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Wen da oman i bin luk dem prut blo dat tri, i prapa gud po kaikai, ane i prapa nais po luk ane dat tri i ken prapa meke sambodi sabe niu samting, da oman i bin nake sam prut ane em bin kaikai. Em bin wantaim gibe sam prut po man blo em ane em bin kaikai tu. ");
INSERT INTO tcs_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Stretwei nau wen demtu bin pinis kaikai, demtu bin sabe ol niu samting, ane demtu bin pil sem bikoz demtu bin neket. Demtu bin teke ol lip blo pigtri, somapem tugeda wase klos po kabare demtuselp. ");
INSERT INTO tcs_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Lo da smolwin blo naittaim, da man ane oman i bin lisen da noiz blo da AntapGod wagbaut insaid lo da gadan. Demtu bin aide demtuselp melen wea ol tri solong da AntapGod nogo paine demtu. ");
INSERT INTO tcs_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Den da AntapGod i bin singaut po da man ane spik diskain, ‘Oi! Wea yu?’ ");
INSERT INTO tcs_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Da man i ansa po em ane spik diskain, ‘Ai bin lisen noiz blo yu wagbaut lo da gadan, ane ai bin prait nau bikoz ai neket, ane ai bin go aid.’ ");
INSERT INTO tcs_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Da AntapGod i askem, ‘Wiskain yu sabe yu neket? Uda bin spik po yu? Yu mas bin kaikai sam prut, prom dat tri wea ai bin oda yu no po kaikai?’ ");
INSERT INTO tcs_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Da man i bin ansa, ‘Da oman wea yu bin gibem po stap lo mi, em bin gibe mi sam prut blo dat tri, ane ai bin kaikai dat prut.’ ");
INSERT INTO tcs_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Den da AntapGod i bin spik diskain po da oman, ‘Wanem yu bin meke demkain po?’ Da oman i bin ansarem, ‘Da sneik i bin lai mi ane ai bin kaikai prut blo dat tri.’ ");
INSERT INTO tcs_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Den da AntapGod i bin tok diskain po da sneik: ‘Bikoz yu bin meke diswan, panis blo mi i go poldaun antap wea yu po splitap yu prom ebridem teimanimal, ane prom ebridem wailanimal. Prom distaim nau yu go krol lo beli blo yu ane yu go kaikai dast prom graun antil laip blo yu go pinis. ");
INSERT INTO tcs_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Prom distaim nau yu ane da oman i gobi ol enami. Ane pikinini blo yu ane pikinini blo em i gobi ol enami tu. Pamlelain blo em i go smase ed blo yu, ane yu go baite put blo pamlelain blo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Da AntapGod bin spik po da oman diskain: ‘Yu go gad prapa adtaim wen yu pamle ane i gobi prapa nadakain bigpein wen yu go bone pikinini. Bat yu go stil wande man blo yu, ane em gobi bos blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ane God i bin spik diskain po da man: ‘Yu bin lisen po tok blo oman blo yu, ane yu bin mekem wanem em bin spik. Yu bin mata kaikai dem prut blo dat tri wea ai bin oda yu no po kaikai. Bikoz prom wanem yu bin mekem, da graun i go gad panis blo mi. Yu go meke adwok groe ol kaikai blo yu prom da graun, antil da dei yu go ded. ");
INSERT INTO tcs_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Da graun i go lego go ausaid po yu ol plant wea i gad ol sap samting ane ol bainplant, bat yu go kaikai ol plant wea i lego olkain sid, ane ebri pruttri wea i lego ol prut gad sid insaid. ");
INSERT INTO tcs_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Yu go adwok lo laip blo yu po groe ol kaikai blo yu antil da dei wen yu go ded ane wen yu ded bodi blo yu go gobaigen po da graun. Ai bin meke yu prom da graun ane yu go gobaigen po da graun.’ ");
INSERT INTO tcs_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adam i bin kole oman blo em Ib, bikoz em gobi mama blo ebri pipol ebriwea. ");
INSERT INTO tcs_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ane da AntapGod i bin meke klos prom skin blo animal po Adam ane oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Den da AntapGod i bin spik diskain po emselp, ‘Prapa tru! Dat man i bin kam wase yumpla, sabe ebriting blo gud ane sabe ebriting blo nugud. Mait demtu go kaikai prut blo da tri i gibe laip, ane den demtu go gad longlaip poeba.’ ");
INSERT INTO tcs_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Da AntapGod i bin sanewei Adam ane Ib go ausaid prom da gadan blo Iden, po digemape graun, plante gadan kaikai. I bin prom graun wea da AntapGod i bin meke man. ");
INSERT INTO tcs_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Em bin oda demtu po go ausaid prom da gadan ane da AntapGod i bin pute ol prapa strongeinzel lo istsaid blo da gadan blo Iden. Da AntapGod i bin wantaim pute wan sod wea i gad paia ban raun dat sod, ane dis sod i tan ebriwea po stape enibodi uda wande go po da tri i gibe laip. ");
INSERT INTO tcs_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adam i bin slip lo Ib, oman blo em, ane Ib bin kam pamle ane em bin bone wan boi pikinini. Ib bin kolem Kein. Ib bin spik diskain po emselp, ‘Wea elp blo da AntapGod ai bin bone boi pikinini.’ ");
INSERT INTO tcs_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ane apta, Ib i bin bon gen ane em bin gad nada boi pikinini ane em bin kolem Eibol. Wen Kein ane Eibol bin kam bigman nau, Eibol i bin lugaut ol sip, ane bala blo em Kein bin wok lo da graun meke ol gadan kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Da taim wen gadan kaikai i bin redi, Kein i bin teke wan opring blo dem kaikai go po da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Eibol, em i bin teke sam dem prapa gud smolsip prom dem nadalot sip, den em bin tekem go po da AntapGod. AntapGod bin nadakain api lo Eibol ane da opring wea Eibol i bin gibem po em. ");
INSERT INTO tcs_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Bat da AntapGod no bin api lo Kein ane da opring blo em. Den Kein i bin kam mina nadakain wail ane em bin prapa atso. ");
INSERT INTO tcs_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Apta nau, da AntapGod i bin spik diskain po Kein, ‘Wanem yu wail po, ane aukam yu prapa atso? ");
INSERT INTO tcs_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ip yu go meke gudting blo raitwei, yu gobi api nau. Bat ip yu nogo meke gudting lo raitwei, den lugaut. Nugudpasin ya i weit po kese yu ane tere yu, bat yu mas bite em ane kam bos blo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Apta nau Kein bin tok po Eibol ane spik diskain, ‘Kam, yumi go lego go raitausaid po da big gadan eria.’ Wen demtu bin kam de, Kein bin paite em ane kile bala blo em. ");
INSERT INTO tcs_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Den da AntapGod i bin spik diskain po Kein, ‘Ei! Wea Eibol, bala blo yu?’ Kein i bin ansa po God ane spik diskain, ‘Wiswei? Ai mas lugaut bala blo mi a? Ai no sabe wea em!’ ");
INSERT INTO tcs_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ane da AntapGod i bin spik po Kein, ‘Wanem yu bin mekem? Blad blo bala blo yu leidaun wea da graun. Blad blo em i singaut po mi wase man i krai! ");
INSERT INTO tcs_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Yu bin kile bala blo yu ane blad blo em bin poldaun ane da graun bin kaikai da blad. So nau ai go seswei yu prom dis graun. ");
INSERT INTO tcs_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wen yu go wok po groe ol kaikai blo yu prom da graun, yu go prapa adwok po groe dem kaikai bat no plenti kaikai go kamaut. Yu go wagbaut ebriwea ya lo da ert. Ebriting wea da ert i gobi ad po yu ane yu nogad no aus po stap.’ ");
INSERT INTO tcs_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kein i spik po da AntapGod, ‘Panis blo mi i prapa nadakain ebiwan. Ai kan karem. ");
INSERT INTO tcs_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Tidei yu bin sanewei mi prom da lan blo mi ane ai nomo go stap klostu lo yu. Ai go wagbaut ebriwea lo ert. Ebriting wea da lan i gobi ad po mi. Ai nogad no aus po stap ane enibodi uda go mite mi mait go kile mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Den da AntapGod i spik po Kein, ‘No i kan! Nobodi go kile yu. Ip enibodi go kile yu, ai go panis dat man sebentaim mobad.’ Ane da AntapGod i bin pute mak lo Kein, solong enibodi uda go mite em, i nogo kile em. ");
INSERT INTO tcs_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Den Kein i bin gowei prom stap klostu wea da AntapGod ane em bin stap wea lan blo Nod, i wea istsaid blo Iden. ");
INSERT INTO tcs_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kein i bin slip lo oman blo em, ane oman blo em i bin kam pamle ane em bin bone wan boi pikinini, kolem Inok. Kein bin bilde wan siti ane em bin kole da siti Inok, wea em bin neimem apta boi blo em. ");
INSERT INTO tcs_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inok i bin papa blo Irad ane Irad bin papa blo Meuzaiel, ane Meuzaiel i bin papa blo Metuzaiel, ane Metuzaiel i bin papa blo Lamek. ");
INSERT INTO tcs_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Nau Lamek i bin maret tu oman. Da paswan blo em i Ada ane da nada oman i Zila. ");
INSERT INTO tcs_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada i bin bone Zabal ane Zabal i bin bigate blo dem pipol uda lukapta ol buluk, ol sip ane ol gout, ane stap lo ol tent. ");
INSERT INTO tcs_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Ane bala blo Zabal i kolem Zubal. Em bin bigate blo dem pipol uda sabe plei plut ane ap. ");
INSERT INTO tcs_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Zila da nada oman blo Lamek i bin bone wan boi pikinini, ane em bin kolem Tubalkein. Em bigate blo dempla uda wok meke olkain samting prom bronz ane aian. Sisi blo Tubalkein i kolem Nama. ");
INSERT INTO tcs_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Wandei Lamek bin tok po demtu oman blo em: ‘Ada ane Zila, yutu lisen po mi, yutu tu oman blo mi. Ai bin kile wan yangman. Mitu bin pait ane em bin meke mi gad ol kat. ");
INSERT INTO tcs_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ip enibodi i go kile Kein, ol laip blo seben pipol i go ded po peibaik. Bat ip enibodi uda go wande kile mi, 77 pipol i go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam bin slip wea oman blo em gen, ane em bin bone wan boi pikinini. Ib i bin kolem Set ane em bin spik diskain, ‘God i bin gibe mi nada boi pikinini po teke ples blo Eibol bikoz Kein i bin kile em.’ ");
INSERT INTO tcs_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Wen Set i bin gro kam man, em bin gad boi pikinini ane em bin kolem Inos. Ane i bin wea dat seimtaim nau wen ol pipol i bin stat po wosip da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Diswan ya stori blo pamlelain blo Adam. Wea dat taim wen God i bin meke ol pipol, em bin meke dempla gad seimkain imiz wase God. Em bin meke dempla, man ane oman. Wen em bin meke dempla em bin blese dempla, ane kole dempla “pipol”. ");
INSERT INTO tcs_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Wen Adam i bin kese 130 iya oul, em i bin gad wan boi pikinini uda bin prapa luk wase em, ane em bin kolem Set. ");
INSERT INTO tcs_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Da taim apta wen Set i bin bon, Adam i bin stap laip po nada 800 iya, ane Adam i bin gad ol nada boi ane gel pikinini tu. ");
INSERT INTO tcs_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Wen Adam bin ded, em bin 930 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Wen Set i bin kese 105 iya oul, em bin gad wan boi pikinini, ane em bin kolem Inos. ");
INSERT INTO tcs_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Da taim apta wen Inos i bin bon, Set i bin stap laip po nada 807 iya, ane Set i bin gad ol nada boi ane gel pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Wen Set i bin ded, em bin 912 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Wen Inos i bin kese 90 iya oul, em bin gad wan boi pikinini, ane em bin kolem Kenan. ");
INSERT INTO tcs_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Da taim apta wen Kenan i bin bon, Inos i bin stap laip po nada 815 iya, ane Inos bin gad ol nada boi ane gel pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Wen Inos i bin ded, em bin 905 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Wen Kenan i bin kese 70 iya oul, em bin gad wan boi pikinini, ane em kolem Malalil. ");
INSERT INTO tcs_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Da taim apta wen Malalil i bin bon, Kenan i bin stap laip po nada 840 iya, ane Kenan i bin gad ol nada boi ane gel pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Wen Kenan i bin ded, em bin 910 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Wen Malalil i bin kese 65 iya oul, em bin gad wan boi pikinini, ane em bin kolem Zared. ");
INSERT INTO tcs_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Da taim apta wen Zared i bin bon, Malalil i bin stap laip po nada 830 iya, ane Malalil i bin gad ol nada boi ane gel pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Wen Malalil i bin ded, em bin 895 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Wen Zared i bin kese 162 iya oul, em bin gad wan boi pikinini, ane em bin kolem Inok. ");
INSERT INTO tcs_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Da taim apta wen Inok i bin bon, Zared i bin stap laip po nada 800 iya, ane Zared i bin kip gad ol nada boi ane gel pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Wen Zared i bin ded, em bin 962 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Wen Inok i bin kese 65 iya oul, em bin gad wan boi pikinini, ane em bin kolem Metusela. ");
INSERT INTO tcs_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Da taim apta wen Metusela i bin bon, Inok i bin prapa pole God klostu po 300 iya. Inok i bin gad ol nada boi ane gel pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ane Inok i bin kese 365 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inok i bin prapa lisen ane pole God prapa klostu. Den i no bin gad Inok eniwea lo ert ya daun, bikoz God i bin tekem lo laipbodi go antap lo eben. ");
INSERT INTO tcs_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Wen Metusela i bin kese 187 iya oul, em bin gad wan boi pikinini, ane em bin kolem Lamek. ");
INSERT INTO tcs_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Da taim apta wen Lamek i bin bon, Metusela i bin stap laip po nada 782 iya, ane Metusela i bin gad ol nada boi ane gel pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Wen Metusela i bin ded, em bin 969 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Wen Lamek i bin kese 182 iya oul, em bin gad wan boi pikinini, ");
INSERT INTO tcs_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ane em bin kolem Noa. Ane Lamek i bin spik, ‘Dis pikinini i go gibe yumpla spel prom dem adwok yupla mekem lo gadan, bikoz God i bin kerse da graun.’ ");
INSERT INTO tcs_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Da taim apta wen i Noa bin bon, Lamek i bin stap laip po nada 595 iya ane Lamek bin gad ol nada boi ane gel pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Wen Lamek i bin ded, em bin 777 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Wen taim blo laip blo Noa i bin kese 500 iya em bin pinis gad tri boi pikinini, ane em bin kole dempla Sem, Am ane Zapet. ");
INSERT INTO tcs_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Den ol pipol bin stat po kam plenti ebriwea lo ert. ");
INSERT INTO tcs_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Wen sam einzel bin luk dem yangoman i prapa nais, dem seim einzel i bin maret dem yangoman wea dempla bin wandem. ");
INSERT INTO tcs_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Den da AntapGod i bin spik, ‘Ai kan kip laue ol pipol po stap laip po prapa longtaim, bikoz dempla i mata pipol blo ert. Prom nau ai go mata laue dempla po stap laip po 120 iya, den dempla go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Wea dat seimtaim, ane apta dat seimtaim, ol mina big ane prapa strong pipol bin stap lo ert. Dem mina big ane prapa strong pipol i bin dem pikinini blo dem einzel ane dem yangoman. Dem mina big ane prapa strong pipol bin ol sampian. Demwan bin ol man uda bin gad ol bigneim prom mina longtaim. ");
INSERT INTO tcs_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Da AntapGod i bin luk wei blo ebri pipol i bin kam prapa nugud, ane ebriting wea ebri pipol bin tingk ane mekem, i bin ebritaim mata ol nugudting. ");
INSERT INTO tcs_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Da AntapGod i bin pil prapa sore em bin meke ol pipol. God i bin prapa atso. ");
INSERT INTO tcs_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Da AntapGod i bin tingk po emselp ane i bin spik diskain, ‘Ai go prapa distroi ebri pipol wea ai bin mekem. Wa. Ane ai go distroi laip blo ebriting lo ert, ebri pipol tugeda wea ebri animal ane ebri pizin. Tru gar! Ai mina sore ai bin meke dempla.’ ");
INSERT INTO tcs_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bat da AntapGod i bin mina nadakain api wea laip blo Noa. ");
INSERT INTO tcs_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","Diswan ya stori blo Noa. Em bin gad tri boi pikinini kole dempla, Sem, Am ane Zapet. Noa i no bin meke nating rong wea ol pipol, ane Noa i bin meke ebriting rait ane stret prant wea God. Noa i bin ebritaim lisen ane pole God. ");
INSERT INTO tcs_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","God i bin luk ebridem pipol i bin prapa gad nugud laip. Ebriwea pipol i bin prapa laik po meke ebriting wea i rong ane dempla bin mata pait wea wananada ebritaim. ");
INSERT INTO tcs_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","God i bin luk wiskain dempla i bin meke ol nugud samting. Wa, prapa tru! Dem pipol ol mata wande pait ane dempla i no bin sem po gad mina nadakain stingkin laip. ");
INSERT INTO tcs_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","God i bin spik po Noa, ‘Ai bin meke main blo mi po distroi laip prom ebridem pipol bikoz dempla prapa laik po meke ebriting rongwei, dempla no laik po meke eni raitting. Wa! Ai go prapa distroi laip prom ebri pipol wantaim wea da ert. ");
INSERT INTO tcs_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","‘Noa, yu bilde wan bigbot prom prapa gud wud ane meke ol dek insaid ane gad plenti rum. Pasem insaid ane ausaid wea ta po stape wata po kam insaid lo da bot. ");
INSERT INTO tcs_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Meke saiz blo da bigbot diskain: 135 mita longwei, 22 mita waid ane mekem 13 mita tol. ");
INSERT INTO tcs_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Wen yu meke da rup blo da bigbot, no laue rup po pas gense said blo da bot, bat libe speis blo apmita melen da rup ane dem said blo da bot. Meke insaid lo da bigbot po gad tri dek, wan andanit ane nadawan melen ane nadawan antap. Ane pute wan doa lo said blo da bigbot. ");
INSERT INTO tcs_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","‘Ai bin meke main blo mi po meke prapa big pladwata po mata ran kam antap kabare da ert ane em i go prapa distroi laip prom ebri laipsamting wea i gad laip. Ebriting i gobi smas. ");
INSERT INTO tcs_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bat ai go meke strong griment blo mi wea yu po kipe yupla. Ane yu mas go insaid da bigbot, yu ane oman blo yu, ane ol boi blo yu, ane ol oman blo ol boi blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Yu mas tekem go insaid da bigbot, tutu blo olkain dipren animal, ol manwan ane ol omanwan. Yu go lugaut demwan ane meke dempla stap laip wea yu wea da pladwata taim. ");
INSERT INTO tcs_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tutu blo olkain animal i go kam po yu po lugaut. Tutu blo olkain dipren pizin ane blo olkain dipren big ane smolanimal i go kam tu. ");
INSERT INTO tcs_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Bat yu mas meke disting. Teke olkain dipren kaikai po pamle blo yu ane po ol dem animal ane putem wansaid insaid lo da bot.’ ");
INSERT INTO tcs_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Noa i bin meke ebriting prapa stret wanem God i bin oda em po mekem. ");
INSERT INTO tcs_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Den da AntapGod i bin spik po Noa, ‘Diskaintaim go insaid da bigbot, yu ane ol pamle blo yu. Wa! Ai bin luk prom ebridem pipol dat mata yu i meke ebriting wea i prapa rait ane stret prant lo mi. ");
INSERT INTO tcs_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tekem wea yu seben man animal ane seben oman animal wea i bin spik i gud po kaikai. Dem seimwan i rait po banem antap lo olta po wosip God. Teke tutu prom ol dem nada animal. ");
INSERT INTO tcs_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Ane teke seben blo ebri man ane oman pizin, solong dem pizin i go mata stap laip prom da pladwata ane ol i go gad pikinini gen ya lo ert. ");
INSERT INTO tcs_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Prom tidei, wen i go kese namba seben dei, ai go sane rein po poldaun ya lo ert po poti dei ane poti nait, ane ebri laipsamting wea ai bin mekem, ai go tekemaute laip prom ebriwan dempla.’ ");
INSERT INTO tcs_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa i bin meke ebriting prapa stret wea da AntapGod i bin odarem po mekem. ");
INSERT INTO tcs_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Wen Noa i bin kese 600 iya oul, prapa big pladwata wea i bin kam, i bin mata ran kabare da ert. ");
INSERT INTO tcs_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Noa ane oman blo em, ol boi blo em ane ol oman blo demtri boi, ol i bin go insaid lo da bigbot po aid prom da prapa big pladwata. ");
INSERT INTO tcs_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Melen wea Noa ane pamle blo em, i bin gad ol dem animal i gud po kaikai ane po banem antap lo olta po wosip God, ane ol dem nadalot animal, ane ol dem pizin ane ol dem smolanimal. ");
INSERT INTO tcs_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Dempla ol i bin go tutu go insaid po da bot wea Noa, wiskain God i bin oda Noa po mekem. ");
INSERT INTO tcs_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Apta dem seben dei i bin pinis, da big pladwata i bin stat po mata ran kam antap ane kabare da ert. ");
INSERT INTO tcs_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Wen Noa i bin kese 600 iya oul ane lo da sebentin dei blo namba tu mant, ebridem spring blo prapa bigwata andanit wea da graun i bin bas kam antap go ausaid, ane da skai bin open wase winda. ");
INSERT INTO tcs_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Rein bin poldaun antap wea da lan po poti dei ane poti nait. ");
INSERT INTO tcs_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Lo dat seimdei Noa ane oman blo Noa, ane ol boi blo em, Sem, Am, ane Zapet, ane oman blo demtri boi blo Noa, bin go insaid da bigbot. ");
INSERT INTO tcs_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Ebri olkain animal ol i bin go wea dempla, ebri olkain teimanimal wea i gud po kaikai ane ebri olkain wailanimal, ane ebri olkain smolanimal ane ebri olkain pizin, ebri olkain laipsamting wea i gad ol wing. ");
INSERT INTO tcs_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Tutu ol bin lego kam insaid wea da bot, ");
INSERT INTO tcs_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","manwan ane omanwan, seimkain wanem God i bin oda. Den da AntapGod i bin sate doa blo da bot. ");
INSERT INTO tcs_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Da prapa big pladwata i bin mata go, ran kam antap kabare ert po poti dei ane poti nait, ane da wata i bin kip kam plenti ane plenti, ane da bigbot bin plot go rait antap prom da lan. ");
INSERT INTO tcs_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Da wata i bin kip kam mobig, ane i bin kam prapa nadakain plenti lo da lan, ane da bigbot bin plot, seipwan antap lo wata. ");
INSERT INTO tcs_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Da wata i bin kip kam prapa nadakain big, i bin kabare ebridem prapa big ai maunten. ");
INSERT INTO tcs_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Da wata bin kip kam kese seben mita antap lo dem big ai maunten. ");
INSERT INTO tcs_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Ane mina olkain laipsamting ya lo ert i bin ded: ol dem dipren pizin, ol dem dipren teimanimal, ol dem dipren wailanimal, ol dem dipren laipsamting wea i wagbaut antap lo da graun ane ebridem pipol. ");
INSERT INTO tcs_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ebrisamting lo da drai graun wea i ole win i bin ded. ");
INSERT INTO tcs_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Ebri laipsamting wea i bin stap wea ert i bin distroi: ebridem pipol, ebridem smolanimal ane ebridem biganimal ane ebridem pizin. Ebri demting i bin distroi. Mata Noa ane pamle blo em ane dem animal wea i bin insaid wea da bot i bin laip. ");
INSERT INTO tcs_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ane da wata bin kabare ert po 150 dei. ");
INSERT INTO tcs_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Bat God i bin mata tingbaut po Noa ane ebridem animal wea i bin wea Noa insaid lo da bot. God i bin meke win po go antap wea da prapa big pladwata ane da wata i bin stat po godaun. ");
INSERT INTO tcs_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ebridem spring blo da prapa bigwata andanit wea lan ane skai wea i bin open wase winda, bin satem, ane rein i bin stap prom poldaun. ");
INSERT INTO tcs_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Da prapa big pladwata i bin stat po godaun slowan. Wa! Wen i bin kese 150 dei, ");
INSERT INTO tcs_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","paib mant prom wen da bigplad i bin stat, da bigbot i bin kam ane pas antap lo big ai maunten, kolem Maunt Ararat. ");
INSERT INTO tcs_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Da mina big pladwata i bin kip godaun ane apta tu ane ap mant, dem ai pat blo dem nada maunten i bin stat po kamaut. ");
INSERT INTO tcs_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Wen i bin kese end blo da poti dei, Noa i bin opene winda wea em bin mekem lo da bot, ");
INSERT INTO tcs_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ane Noa bin lego wan blaik krou go ausaid wea da winda. Da krou no bin kambaigen po da bot bat bin mata plai stap ausaid prom da bot antil da prapa big pladwata i bin drai. ");
INSERT INTO tcs_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Apta Noa i bin lego da krou, Noa bin lego wan dab po luk ip em ken paine draiples. ");
INSERT INTO tcs_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Bat da dab i no bin paine eni sidaun ples lo graun ane em bin kambaigen po da bot bikoz i stil bin gad wata. Noa i bin pute an blo em go ausaid po teke da dab kam insaid po da bot. ");
INSERT INTO tcs_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Noa i bin weit po nada seben dei, den em bin lego gen da dab go ausaid prom da bot. ");
INSERT INTO tcs_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ane wen i bin naittaim da dab i bin kambaigen kare wan niu lip blo olibtri lo maut blo em. Den Noa i bin wantaim sabe da prapa big pladwata i bin klostu po drai. ");
INSERT INTO tcs_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Noa bin weit po nada seben dei ane em bin lego gen da dab go ausaid ane distaim da dab i no bin kambaigen. ");
INSERT INTO tcs_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa i bin kese 601 iya oul, diswan i ten ane ap mant apta da big pladwata i bin stat. Den Noa i bin opene doa po luk go ausaid. Wen Noa i bin luk go ausaid da graun i bin stat po kam drai. ");
INSERT INTO tcs_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Nada tu mant bin pas ane da lan i bin prapa drai. ");
INSERT INTO tcs_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Den God i bin spik po Noa, ");
INSERT INTO tcs_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","‘Yupla ebriwan, go ausaid prom da bot. ");
INSERT INTO tcs_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Lego ebridem dipren animal ane pizin go ausaid prom da bot solong dempla go brid ane kam plenti ebriwea lo da lan.’ ");
INSERT INTO tcs_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Wa! Noa i bin go ausaid prom da bot wea oman blo em, ol boi blo em, ane ol oman blo boi blo em. ");
INSERT INTO tcs_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ane ebridem dipren dipren animal ane pizin, ol bin kamaut tutu kam ausaid. ");
INSERT INTO tcs_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Den Noa i bin bilde wan olta po mata wosip da AntapGod, ane Noa i bin teke sam dem rait animal ane dem rait pizin ane em bin kilem ane bane demwan antap wea olta po wosip da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Ane da smel blo sakripais i bin meke da AntapGod pil nadakain api ane em i bin spik po emselp, ‘Yagar! Nomo gen ai go kerse da ert. Yagar! Nomo gen ai go smas ane distroi ebri laipsamting wea ai bin mekem, nomata wen dem pipol i kip tingk ol nugudwei ane wen pipol meke ol nugudting prom wen dempla smol. ");
INSERT INTO tcs_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Da taim blo laip blo ert i go mata kipgo ane no stap. I go gad taim po plante ol gadan kaikai ane taim wen dem kaikai redi po kaikai. I go gad taim blo kol ane taim blo ot, ane i go gad taim blo rein ane taim blo no rein, ane taim blo naittaim ane taim blo deitaim.’ ");
INSERT INTO tcs_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","God i bin blese Noa ane ol boi blo em. Em bin spik diskain, ‘Yupla ol kam plenti ane meke plenti pikinini po stap ebriwea ya lo ert. ");
INSERT INTO tcs_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ebri wailanimal, ebri pizin, ane ebridem pis blo solwata, ebriting wea i stap ane wagbaut antap lo graun, i go prapa prait prom yupla. Yupla gobi bos blo ebridem samting. ");
INSERT INTO tcs_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ebri laip animal i gobi kaikai blo yupla, seimkain wiskain ai bin gibe yupla ebri sid ane bezdabol po kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bat, da wan samting wea yupla mas no kaikai, i eni mit i gad blad i pas. Ai no wande yupla po kaikai diswan bikoz i gad laip insaid lo da blad. ");
INSERT INTO tcs_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ane God i kip spik po dempla, ‘Wan man mas no kile nada man. Ip animal i kile man, den kile da animal. Ane ip wan man i kile nada man, den kile dat man. ");
INSERT INTO tcs_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wa. Eni man uda i kile nada man, den dat man mas ded, bikoz God bin meke ebri pipol i gad imiz blo em. ");
INSERT INTO tcs_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ane yu mas kam plenti ane gad plenti pikinini, solong ol pamlelain blo yupla go stap ebriwea lo ert.’ ");
INSERT INTO tcs_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Den God i bin tok gen po Noa ane ol boi blo em diskain, ");
INSERT INTO tcs_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","‘Diskaintaim ai meke strong griment blo mi wea yupla ane wea ol pamlelain blo yupla, ");
INSERT INTO tcs_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","ane wea ebri laipsamting blo yupla, ebridem olkain pizin ane ebridem olkain teimanimal ane ebridem wailanimal, ane ebridem animal wea i bin kamaut prom da bot wea yupla. ");
INSERT INTO tcs_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Wa! Dem tok ya ai spik, ai go meke strong griment blo mi wea yupla. Ai promis ai nomo go sane prapa big pladwata po tekemaute laip prom ebri laipsamting wea lan, ane po nomo gen distroi ert.’ ");
INSERT INTO tcs_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","God i spik diskain, ‘Diswan i sain wea ai go kipe dis strong griment wea ai mekem wea yupla, ane wea ebri laipsamting poeba: ");
INSERT INTO tcs_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ai go pute reinbou blo mi wea klaud. I gobi sain blo da strong griment blo mi wea ai bin mekem melen lo mi ane ert. ");
INSERT INTO tcs_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Ebritaim wen ai kabare skai wea klaud, reinbou go soe emselp, ");
INSERT INTO tcs_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ane ai go tingbaut strong griment melen lo mi ane yupla ane ebri laip animal. Da big pladwata i nomo go kam gen ane tekemaute laip prom ebri laipsamting. ");
INSERT INTO tcs_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Wen ai go luk reinbou wea dem klaud, ai go tingbaut da strong griment wea i go poeba melen God ane ebri laipsamting wea ert.’ ");
INSERT INTO tcs_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","God i spik po Noa, ‘Wa. Dis reinbou i sain blo da strong griment ai mekem melen lo mi ane ebridem laipsamting wea i stap lo ert.’ ");
INSERT INTO tcs_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Dem boi blo Noa wea ol i bin kam ausaid prom da bot i bin Sem, Am ane Zapet. Wa. Am i bin bigate blo dem pipol blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Prom demtri boi blo Noa ya, ebri pipol blo da lan i bin kamaut, ane ol i bin go ebriwei lo ert. ");
INSERT INTO tcs_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Wen da bigplad i bin pinis, Noa i bin stat wok wase pama, ane em i meke gadan, plante ol greipbain. ");
INSERT INTO tcs_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Wantaim, em bin dringk wain ane em bin kam spak, ane em bin leidaun neketwan insaid tent blo em. ");
INSERT INTO tcs_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Am, bigate blo dem pipol blo Kanan, bin luk papa blo em bin neketwan. Em bin go ausaid prom da tent ane em bin spik po demtu bala blo em. ");
INSERT INTO tcs_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Den Sem ane Zapet i bin teke kaliko ane bin kesem putem antap wea solda blo demtu, ane demtu bin wagbaut baikwei go insaid po da tent ane demtu bin kabare papa blo demtu. Demtu meke pes blo demtu luk go nadawei solong demtu no go luk papa blo demtu i neketwan. ");
INSERT INTO tcs_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Wen sens blo Noa i bin kam orait prom dringk, ane em bin paindaut wanem Am, smolboi blo em i bin mekem po em, ");
INSERT INTO tcs_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","em spik: ‘Panis i go poldaun antap wea dem pipol blo Kanan, dem pamle blo Am! Dempla i gobi nambalas sebant blo ol pamlelain blo Sem ane Zapet.’ ");
INSERT INTO tcs_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Noa kip spik: ‘Mata preize da AntapGod, God blo Sem. Dem pipol blo Kanan gobi sebant blo Sem. ");
INSERT INTO tcs_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","God, laue dem pamlelain blo Zapet po stap ebriwea lo ert, Laue dem pamlelain blo Zapet po stap tugeda wea dem pamlelain blo Sem ane laue Kanan po bi sebant blo Zapet.’ ");
INSERT INTO tcs_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Apta wen da prapa big pladwata i bin pinis, Noa bin kipgo po nada 350 iya. ");
INSERT INTO tcs_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Wen Noa i bin ded, em i bin kese 950 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Diswan ya stori blo pamlelain blo Sem, Am ane Zapet, demtri boi blo Noa. Wen da prapa big pladwata i bin pinis, demtri boi blo Noa ya i bin gad ol plenti pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ol boi blo Zapet i bin Gomer, Magog, Madai, Zaban, Tubal, Mesek ane Tiras. ");
INSERT INTO tcs_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ol boi blo Gomer, i bin Askanaz, Ripat ane Togama. ");
INSERT INTO tcs_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ol boi blo Zaban, i bin Elisa, Tasis, Kitim ane Rodanim. ");
INSERT INTO tcs_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Dem pamlelain blo Zaban i bin dem pipol uda stap lo dem sanbisples ane antap lo ol ailan. Demwan i bin stap wea dempla oun kantri, wea dempla dipren pamlelain ane tok dempla oun langus. ");
INSERT INTO tcs_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ol boi blo Am i bin Kus, Izipt, Put ane Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ol boi blo Kus i bin dem pipol blo Seba, Abila, Sabta, Rama ane Sabteka. Ane ol boi blo Rama i bin Siba ane Dedan. ");
INSERT INTO tcs_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kus i bin gad wan nada boi pikinini kolem Nimrod. Ane Nimrod i bin pas man po kam nadakain strong man po pait ane nobodi ken tere em po pait. ");
INSERT INTO tcs_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Wa. Wea da elp blo da AntapGod, Nimrod i bin kam prapa dedli man po anting, daswai ol pipol i spik, ‘Da AntapGod i meke yu prapa dedli man po anting wase Nimrod.’ ");
INSERT INTO tcs_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Wa, Nimrod bin bos blo kantri blo Babilonia, ane insaid Babilonia i gad dem siti ya, Babilon, Erek, Akad ane Kalne. ");
INSERT INTO tcs_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Prom dat kantri, Nimrod i bin go po nada kantri kolem Asiria. Ane em bin bilde dem siti blo Ninaba, Riobotir, Kala ");
INSERT INTO tcs_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ane Resen. Resen em i melen wea da siti blo Ninaba ane Kala. Resen em i da mein siti blo ol lan blo Nimrod. ");
INSERT INTO tcs_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Prom dem boi blo Izipt i bin gad dem pipol ya: dem Lud, Anam, Liab, ane dem pipol blo Naptu, ");
INSERT INTO tcs_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","dem Patru, Kaslu, ane dem pipol blo Kapto. Dem pipol blo Pilistia i bin kamaut prom dem pipol blo Kapto. ");
INSERT INTO tcs_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanan i bin gad tu boi pikinini, paswan i Sidon ane sekanwan i It. ");
INSERT INTO tcs_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kanan, em i bin bigate blo dem Zebu, Amo, Girgas, ");
INSERT INTO tcs_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ib, Ak, Sin, ");
INSERT INTO tcs_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Abad, Zema, ane dem pipol blo Amat. Dem dipren pamle blo dem pipol blo Kanan i bin mub go ausaid ebriwea. ");
INSERT INTO tcs_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Baundri blo dempla i bin stat prom Sidon go sautsaid po Gaza ane prom de go insaidsaid klostu po Gera ane go istsaid po Sodom, Gomora, Adma, ane Zeboim go de kese Lasa. ");
INSERT INTO tcs_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Demwan ya i bin pamlelain blo Am, wea dempla i bin stap wea dempla oun dipren pamlelain, tok dempla oun langus, stap wea dempla oun ples, ane dempla oun kantri. ");
INSERT INTO tcs_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sem, bigbala blo Zapet, i bin gad ol pikinini tu. Sem i bin bigate blo ebri pamlelain blo Iba. ");
INSERT INTO tcs_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ol boi pikinini blo Sem i bin Elam, Asu, Arpaksad, Lud ane Aram. ");
INSERT INTO tcs_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ol boi blo Aram i bin Uz, Ul, Geter ane Mas. ");
INSERT INTO tcs_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpaksad i bin papa blo Sela ane Sela i bin papa blo Eber. ");
INSERT INTO tcs_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eber i bin gad tu boi pikinini, wan i bin kolem Peleg, bikoz wea taim blo Peleg ebri pipol blo ert i bin splitap go stap ebriwea. Da nada boi pikinini blo Eber i bin Zoktan. ");
INSERT INTO tcs_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ol boi blo Zoktan i bin Almodad, Selep, Azamabet, Zera, ");
INSERT INTO tcs_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dikla, ");
INSERT INTO tcs_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Siba, ");
INSERT INTO tcs_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Oper, Abila ane Zobab. ");
INSERT INTO tcs_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Da lan wea dempla bin stap i bin go raitausaid prom Mesa go po Separ wea dem ilkantri wea istsaid. ");
INSERT INTO tcs_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Demwan ya i bin dem pamlelain blo Sem, wea dempla i bin stap wea dempla oun dipren pamlelain, tok dempla oun langus, stap wea dempla oun ples, ane dempla oun kantri. ");
INSERT INTO tcs_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Demwan ya, i dem dipren pamlelain uda i bin kamaut prom dem boi blo Noa, stret wea pamle blo dempla, ane prom dempla oun pipol, ane prom dem pamlelain blo dem boi blo Noa. Dempla i bin mub go ausaid lo da lan wen da prapa big pladwata i bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","I bin gad taim wen ebri pipol wea ert i bin gad wan langus wea ol ken tok lo wananada. ");
INSERT INTO tcs_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Wen ol dem pipol i bin wagbaut go wea istsaid, dempla bin paine platples melen wea ol maunten lo da ples blo Babilonia ane dempla bin stap de. ");
INSERT INTO tcs_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Den dempla bin spik po wananada, ‘Wa. Yumpla go teke graun po meke brik ane bane dem brik prapa po meke dem brik strong.’ Apta, dempla bin yuze ol brik po meke ol bilding blo dempla ane ol ta po meke dem brik pas tugeda. ");
INSERT INTO tcs_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Den dempla bin spik, ‘Kam. Yumpla go bilde wan siti po yumplaselp wea i gad wan taua wea i go kese skai ane ebriting antap wea skai. Den ol pipol go luk dat yumpla gad prapa bigneim po yumplaselp, ane yumpla no nid mub go ebriwea lo ert.’ ");
INSERT INTO tcs_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Den da AntapGod i bin kamdaun po luk dat siti ane da taua wea dem pipol i bin bildem. ");
INSERT INTO tcs_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Da AntapGod i bin spik, ‘Wa! Dempla ebriwan ya i wan pipol ane gad wan langus wea ol tok po wananada. Diswan i kasa stat blo wanem dempla go mekem. Sottaim prom nau dempla ken meke enisamting wea dempla i wandem. ");
INSERT INTO tcs_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kam. Yumpla godaun, ane gibe dempla olkain dipren langus solong dempla nogo sabe wen ol i tok po wananada.’ ");
INSERT INTO tcs_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Wa, da AntapGod i bin mube dem pipol go prom dat platples, da ples blo Babilonia, go ausaid ebriwea lo ert, ane dem pipol i bin nomo bilde dat siti. ");
INSERT INTO tcs_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Dempla bin kole da siti Babal, bikoz i bin de da AntapGod bin gibe dempla olkain dipren dipren langus solong dem pipol i bin mub go ausaid ebriwea lo ert. ");
INSERT INTO tcs_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Diswan ya stori blo pamlelain blo Sem. I bin tu iya apta da prapa bigplad i bin pinis, wen Sem i bin kese 100 iya oul. Em bin gad boi pikinini, neim blo em bin Arpaksad. ");
INSERT INTO tcs_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Apta Arpaksad bin bon, Sem bin kip gad ol nada boi ane gel pikinini bipo em bin pinis. Em bin kese 500 iya oul bipo em bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Wen Arpaksad i bin kese 35 iya oul em bin gad boi pikinini. Neim blo em bin Sela. ");
INSERT INTO tcs_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Apta Sela i bin bon, Arpaksad i bin kip gad ol nada boi ane gel pikinini bipo em bin pinis. Em bin kese 403 iya oul bipo em bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Wen Sela i bin kese 30 iya oul em bin gad boi pikinini. Neim blo em bin Eber. ");
INSERT INTO tcs_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Apta da taim wen Eber i bin bon, Sela i bin kip gad ol nada boi ane gel pikinini bipo em bin pinis. Em bin kese 403 iya oul bipo em bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Wen Eber i bin kese 34 iya oul, em bin gad boi pikinini. Neim blo em bin Peleg. ");
INSERT INTO tcs_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Apta da taim wen Peleg i bin bon, Eber i bin kip gad ol nada boi ane gel pikinini bipo em bin pinis. Em bin kese 430 iya oul bipo em bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Wen Peleg i bin kese 30 iya oul, em bin gad boi pikinini. Neim blo em i bin Riu. ");
INSERT INTO tcs_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Apta da taim wen Riu i bin bon, Peleg bin kip gad ol nada boi ane gel pikinini bipo em bin pinis. Em bin kese 209 iya oul bipo em bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Wen Riu i bin kese 32 iya oul, em bin gad boi pikinini. Neim blo em i bin Serug. ");
INSERT INTO tcs_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Apta da taim wen Serug i bin bon, Riu bin kip gad ol nada boi ane gel pikinini bipo em bin pinis. Em bin kese 207 iya oul bipo em bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Wen Serug i bin kese 30 iya oul, em bin gad boi pikinini. Neim blo em bin Nao. ");
INSERT INTO tcs_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Apta da taim wen Nao bin bon, Serug i bin kip gad ol nada boi ane gel pikinini bipo em bin pinis. Em bin kese 200 iya oul bipo em bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Wen Nao i bin kese 29 iya oul, em bin gad boi pikinini. Neim blo em i bin Tera. ");
INSERT INTO tcs_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Apta da taim wen Tera i bin bon, Nao bin kip gad ol nada boi ane gel pikinini bipo em bin pinis. Em bin kese 119 iya oul bipo em bin pinis. ");
INSERT INTO tcs_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Wen Tera i bin kese 70 iya oul, em bin kam papa blo Abram, Nao, ane Aran. ");
INSERT INTO tcs_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Diswan ya stori blo pamlelain blo Tera. Em bin papa blo Abram, Nao, ane Aran. Aran i bin papa blo Lot. ");
INSERT INTO tcs_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Ane Aran i bin lus wea ples blo pipol blo em wea da big taun blo Er wea kantri blo Babilonia. Bat Tera, papa blo Aran, em i bin stil laip. ");
INSERT INTO tcs_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abram ane Nao i bin maret tu oman. Dat oman blo Abram neim i Sarai, ane dat oman blo Nao neim i Milka. Milka em i bin gel blo Aran, bala blo Abram. Aran i bin papa blo tu gel, Milka ane Iska. ");
INSERT INTO tcs_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Bat Sarai, oman blo Abram, em kan gad pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tera, i bin teke boi blo em, Abram ane oman blo em Sarai, ane nepiu blo Abram, Lot. Lot i boi blo Aran. Dempla ebriwan ol i bin libe dat ples blo Er wea kantri blo Babilonia, go po dat kantri blo Kanan. Bat wen dempla bin kam po da biliz blo Aran, ol bin mata stap de. ");
INSERT INTO tcs_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tera i bin kese 205 iya oul bipo em bin lus de wea Aran. ");
INSERT INTO tcs_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Den da AntapGod i bin spik po Abram, ‘Libe kantri blo yu, ol kazen blo yu, ane ol pamle blo papa blo yu, ane go po da kantri wea ai go soe yu. ");
INSERT INTO tcs_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Ai go meke yu bigate blo wan bigmob pipol uda stap wea dempla oun kantri, ane ai go blese yu ane meke yu gad prapa bigneim. Bikoz prom yu, ai go blese ol pipol. ");
INSERT INTO tcs_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ai go blese dem pipol uda blese yu, ane demwan uda kerse yu ai go kerse dempla, ane prom laip blo yu ai go blese ebri dipren pamlelain ya lo ert.’ ");
INSERT INTO tcs_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Wa, Abram i bin lego go, prapa wiskain da AntapGod i bin spik em, ane Lot i bin go wea Abram. Abram i bin 75 iya oul wen em bin libe dat biliz blo Aran. ");
INSERT INTO tcs_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abram bin teke Sarai oman blo em, nepiu Lot, ebri gudsamting wea demtu bin gad ane ebridem wokman wea demtu bin gedem wea da biliz blo Aran. Dempla bin lego go po da lan blo Kanan. Wen dempla bin kesem de, ");
INSERT INTO tcs_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abram i bin kip lego go antil ol bin kesem de wea dat oli tri wea ol kolem More, wea taun blo Sekem. Wea dat seimtaim dem pipol blo Kanan bin stap wea dat lan. ");
INSERT INTO tcs_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Da AntapGod bin soe emselp po Abram ane em bin spik, ‘Ai go gibe dis kantri po pamlelain blo yu.’ Den apta, Abram i bin bilde olta po wosip da AntapGod, bikoz da AntapGod i bin soe emselp de po Abram. ");
INSERT INTO tcs_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Prom dat ples, Abram i bin mub go saut po dem ilkantri wea istsaid blo taun blo Betel. Em bin setemap ol tent blo dempla melen wea Betel ane da taun blo Ai. Ane Abram i bin bilde nada olta de ane bin wosip da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Den Abram i bin mub, libe da ples biain ane em bin stap lo ol dipren dipren ples, bat kip mub go po sautsaid pat blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Wa. Wea dat seimtaim nau i no bin gad kaikai wea lan blo Kanan. Wen dat anggretaim i bin kese Abram i bin prapa nugud. Em bin lego go po kantri blo Izipt po stap de po sottaim. ");
INSERT INTO tcs_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Wen Abram i bin klostu po kese baundri blo Izipt, em bin spik po oman blo em Sarai, ‘Yu mina gudluking oman. ");
INSERT INTO tcs_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Wen dem Izipt pipol i go luk yu, ol i go wande yu. Dempla go spik, “Diswan oman blo em. Kam, yumpla kile da man ane teke da oman.” ");
INSERT INTO tcs_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","So ip yu spik dempla yu sisi blo mi, dem pipol blo Izipt go trite mi gud ane dempla nogo kile mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Wen Abram bin kros go insaid po Izipt, dem pipol bin luk oman blo em, em prapa gudluking oman. ");
INSERT INTO tcs_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Sam dem bigman blo king blo Izipt, da Pero king, ol bin luk Sarai ane tokbaut em. Dempla bin go ane spik po da Pero king wiskain dis naisluking oman. Da Pero king bin oda dem bigman po teke Sarai kam po stap insaid wea aus blo em. ");
INSERT INTO tcs_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Da Pero king bin tingk Sarai em i sisi blo Abram, so da Pero king bin meke gudpasin po Abram, gibe em ol sip, gout, buluk, dongki, kamal, ane ol man ane oman sleib. ");
INSERT INTO tcs_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Bat da AntapGod i bin sane ol prapa bad sik go po da Pero king ane po ebriwan uda stap wea aus blo em. Diswan i bin apen bikoz da Pero king i bin teke Sarai, oman blo Abram. ");
INSERT INTO tcs_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Den da Pero king bin oda Abram po kam ane da Pero king bin spik po Abram diskain, ‘Wanem pasin diswan yu mekem po mi? Aukam yu no bin spik mi em oman blo yu? ");
INSERT INTO tcs_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Yu bin spik em sisi blo yu, so ai bin go meke em oman blo mi ya. Bat em oman blo yu. Yu teke em ane go nau.’ ");
INSERT INTO tcs_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Da Pero king i bin oda ol amiman blo em po sanewei Abram, ane oman blo em ane ebrisamting blo dempla, go ausaid prom kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abram ane oman blo em bin teke ebrisamting blo demtu kamaut prom Izipt ane lego go po sautsaid pat blo Kanan. Lot i bin go wea demtu tu. ");
INSERT INTO tcs_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Wa, Abram i bin prapa risman. Em bin gad plenti sip, gout, buluk, ane prapa tumas silba ane gold. ");
INSERT INTO tcs_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Den Abram i bin libe sautsaid pat blo Kanan ane em bin go stap wea ol dipren dipren ples, bat em kip mub go antil em bin kam po taun blo Betel. Em bin kesem wea da ples melen wea demtu taun Betel ane Ai wea em bin stap de pas. ");
INSERT INTO tcs_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Diswan ya i da seim ples wea em bin pinis meke olta. Ya gen Abram bin tok po da AntapGod ane wosip em. ");
INSERT INTO tcs_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lot em i bin go lo Abram. Demtu bin gad plenti ol sip, gout, buluk, pamle blo demtu ane ol sebant blo demtu. ");
INSERT INTO tcs_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","I no bin gad nap lan po demtu po stap klostu wananada bikoz demtu i bin gad mina plenti animal. ");
INSERT INTO tcs_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ane dem man uda bin lugaut ebri animal blo Abram ane dem man uda bin lugaut ebri animal blo Lot, dempla ebriwan bin graul gense wananada. Wea dat seimtaim, dem pipol blo Kanan ane dem pipol blo Perez i bin stap wea da seim lan. ");
INSERT INTO tcs_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Den Abram i bin spik po Lot, ‘Yumi wan pamle, ane ol wokman blo yumi ol i no spostu graul. ");
INSERT INTO tcs_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","I gad plenti lan ya po yumi. Suzem wanem lan yu wandem ane yumi go splitem. Ip yu teke da lan de nadasaid den ai go teke dis lan ya, bat ip yu teke dis lan ya ai go teke da lan de nadasaid.’ ");
INSERT INTO tcs_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lot bin lukraun ane em bin luk big platples lo tu said blo Zodan Riba wea i gad prapa gud graun ane plenti wata. Dis ples bin kipgo antil i kese taun blo Zoa. Dis ples i wase da gadan blo da AntapGod ane wase da big platples blo da Nail Riba lo kantri blo Izipt. Dis ples i bin gud pas, bipo da AntapGod i bin tekemaute laip prom ebri laipsamting blo tu taun blo Sodom ane Gomora. ");
INSERT INTO tcs_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lot bin meke main blo em po stap wea da big bali lo tu said blo Zodan Riba wea i gad prapa gud graun ane plenti wata. Em bin mub go libe da ples go istsaid blo da riba. Diswan i wiskain da tu man bin splitap. ");
INSERT INTO tcs_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram bin stap wea da ples blo Kanan bat Lot i bin mub ane go stap klostu po Sodom. Sodom i bin wea dem nada taun lo da platples wea tu said blo Zodan Riba. ");
INSERT INTO tcs_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Wa, dem pipol blo Sodom i ebritaim meke ol prapa nugud samting ane ol prapa badting gense da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Da taim apta wen Lot ane Abram demtu bin splitap, da AntapGod i bin spik po Abram, ‘Prom wea yu stanap, luk go ebriwea po ebri ples wea yu ken lukem. ");
INSERT INTO tcs_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ai go gibe yu ane pamlelain blo yu, ebridem lan wea ai blo yu i kesem. Dis lan i gobi blo yu ane pamlelain blo yu poeba. ");
INSERT INTO tcs_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ai go meke pamlelain blo yu prapa plenti solong nobodi i ken kaunte dempla. I go gad mo dempla den dast wea ert. ");
INSERT INTO tcs_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","I taim nau po wagbaut ane lukraun ebriwea lo dis lan bikoz ai go gibem po yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","So, Abram ane pamle blo em bin mub go stap klostu po da ples wea dem spesil bigtri blo wan man neim Mamre. Diswan klostu wea taun blo Ebron. De Abram bin bilde nada olta po wosip da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Wea dis seimtaim nau, King Amrapel blo Babilonia, King Ariok blo da ples blo Elasa, King Kedolomer blo da ples blo Elam, ane King Tidal blo da ples blo Goim, ");
INSERT INTO tcs_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ol bin go po bigpait gense ol nada paib king. I gad King Bera blo taun blo Sodom, King Bersa blo taun blo Gomora, King Sinab blo taun blo Adma, King Semeber blo taun blo Zeboim, ane da King blo taun blo Bela wea ol pipol ya nau tidei kolem Zoa. ");
INSERT INTO tcs_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Dem paib king ya i bin teke amiman blo dempla kam tugeda po pait wea da big bali blo Sidim wea ol pipol ya nau tidei kolem Ded Solwata. ");
INSERT INTO tcs_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","King Kedolomer i bin bos blo dempla po tuelb iya, bat lo da 13 iya, dem paib king ya bin meke main blo dempla po nomo lisen po King Kedolomer ane nomo mekem wanem em bin wandem. ");
INSERT INTO tcs_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Lo da neks iya, King Kedolomer ane dem nada tri king uda bin wea em, bin kam wea dem amiman blo dempla. Dempla bin tere dem pipol blo Repa wea Asterotkanaim, dem pipol blo Zuz wea Am, dem pipol blo Em wea da platples blo Kiriataim, ");
INSERT INTO tcs_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ane dem pipol blo Ora wea dem ilkantri blo Ser. Dempla bin apte dem lot go raitap antil ol mangi wea Elparan klostu wea ausaid said blo da big dezetples wea i nogad no man. ");
INSERT INTO tcs_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Den King Kedolomer ane dem nada tri king bin tanbaik ane dempla bin kam po da ples blo Enmispat. Tidei nau ol pipol i kolem Kades. Dem po king bin smase dem pipol blo Amalek ane bin smase dem pipol blo Amo uda bin stap wea Azazon Tama. ");
INSERT INTO tcs_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Den apta, king blo Sodom, king blo Gomora, king blo Adma, king blo Zeboim ane king blo Bela, wea ol pipol ya nau tidei kolem Zoa, ol bin lego go ausaid ane bin meke redi po pait lo dat bali blo Sidim, wea ol pipol i ya nau tidei kolem Ded Solwata. ");
INSERT INTO tcs_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Dempla bin pait gense King Kedolomer blo Elam, ane dem king blo Goim, Babilonia, ane Elasa; po king wea wansaid gense paib king wea nadasaid. ");
INSERT INTO tcs_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Da platples melen wea dem il blo Sidim bin pulap wea plenti big oll i gad ta. Ane wen dem king blo Sodom ane Gomora ane amiman blo dempla bin trai po ranwei prom da bigpait, sam dem amiman blo dem king blo Sodom ane Gomora bin poldaun go insaid dem oll i gad ta. Bat dem nada pipol bin tekop ranwei go po dem maunten. ");
INSERT INTO tcs_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","King Kedolomer, King Tidal, King Amrapel, ane King Ariok ane dem amiman blo dempla bin teke ebri gudsamting ane ebri kaikai blo dem pipol blo Sodom ane Gomora. Ane dem po king bin go. ");
INSERT INTO tcs_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Lot, em nepiu blo Abram. Em bin stap wea Sodom ane dempla bin kese Lot ane ebrisamting blo em ane teke em go wea dempla. ");
INSERT INTO tcs_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Bat wan man uda bin ranwei prom da pait bin kam spik po Abram, da Ibruman. Abram bin stap klostu dem spesil bigtri blo wan man neim Mamre, uda man prom Amo. Mamre ane tu bala blo em, neim Eskol ane Aner, bin kam ane meke strong griment wea Abram po elpe em. ");
INSERT INTO tcs_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Wen Abram bin lisen wiskain dem po king bin pose nepiu blo em po go wea dempla, em bin ala po ebri man blo em uda sabe pait po kam tugeda. Dempla i bin 318 uda bin kam prom pamle blo em. Den Abram ane ol man blo em uda sabe pait, ane Mamre ane ol bala blo em, dempla bin apte dem po king ane dem amiman blo dempla, bin go raitap po taun blo Dan. ");
INSERT INTO tcs_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Wen Abram dempla bin kesem de, em bin splitemap dem amiman blo em po ol dipren dipren mob. Wea naittaim nau, dempla bin lego go paite dem po king ane ol amiman blo dempla. Abram i bin prapa smase dempla ane apte dempla, go raitap po taun blo Oba wea notsaid blo taun blo Damaskas. ");
INSERT INTO tcs_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ane Abram i bin kambaigen gad ebrisamting wea dem po king ane dem amiman ol i bin tekem. Abram i bin teke nepiu blo em Lot kambaik, ane ebrisamting blo em, dem oman ane dem pipol wea dem po king i bin posem po go wea dempla. ");
INSERT INTO tcs_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Wen Abram i bin kambaigen prom pait ane tere King Kedolomer ane dem nada tri king ane dem amiman blo dempla, da king blo Sodom bin go po luk Abram wea da platples melen wea ol il blo Saba, wea ol pipol ya nau kolem ‘Bali blo ol king’. ");
INSERT INTO tcs_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ane da seimtaim, Melkizadek uda bin da king blo da big taun blo Salem ane prist blo da Prapa AntapGod, i bin teke bred ane wain kam po Abram. ");
INSERT INTO tcs_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Melkizadek bin blese Abram ane spik diskain: ‘God i blese Abram, da Prapa AntapGod uda bin meke da skai ane ebriting de antap, ane ert ya daun! ");
INSERT INTO tcs_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ol pipol mata blese God, da Prapa AntapGod uda bin elpe yu po pait ane tere ebridem man uda bin kam po pait gense yu.’ Nau Abram i bin teke ebri gudsamting wea em bin tekem prom dem po king, den em bin splitemap demting, ane em bin teke wanten prom dem gudsamting ane bin gibem po king Melkizadek. ");
INSERT INTO tcs_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Den king blo Sodom i bin spik po Abram, ‘Kipe ebridem gudsamting, bat gibe mi baigen ebri pipol blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram bin ansa, ‘Ai spik dis strongpromis prant wea da AntapGod, da Prapa AntapGod uda bin meke skai ane ebriting de antap ane ert ya daun, ");
INSERT INTO tcs_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","ai nogo teke enisamting wea i blo yu, no iben wan sandol. Ip yu mekem diskain den yu ken spik, “Ai da wan uda bin meke Abram prapa risman, uda gad prapa plenti samting.” ");
INSERT INTO tcs_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Ai nogo teke enisamting po maiselp. Ai go mata teke ebri kaikai wea ol man blo mi i bin pinis kaikai. Bat laue ol pren blo mi, Aner, Eskol ane Mamre po teke sea blo dempla prom dem gudsamting, bikoz demplatri bin pait gense dem po king ane dem amiman blo dempla.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Apta wen demting ya wea i bin apen, Abram i bin luk da AntapGod insaid lo drim, ane da AntapGod i bin spik, ‘Abram, no prait! Ai go lugaut yu prom ebri nugudting ane gibe yu prapa gudsamting wea yu no bin luk.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Bat Abram i bin ansa, ‘AntapGod, bos blo ebriting, wanem yu go meke ol gudsamting po mi po? Ai nogad pikinini! Da wan man uda go gede ebri gudsamting blo mi, em Elieza blo Damaskas. Em i sebant blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abram i bin kip spik, ‘Prapa gud! Bat yu no bin gibe mi pikinini. Nau wan sebant blo mi i go gede ebri gudsamting blo mi po emselp.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Den God i bin spik po em, ‘Nono! Dis sebant Elieza i nogo gede ebri gudsamting blo yu. Yu go gad wan boi pikinini prom bodi blo yu uda go gede ebri gudsamting blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Da AntapGod i bin teke Abram go ausaid prom tent blo em ane da AntapGod i bin spik, ‘Luk go antap po skai ane trai kaunte dem sta. Yu go gad prapa plenti pamle wase dem sta.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram i bin mata bilib wea God daswai laip blo Abram i bin rait ane stret prant wea God. ");
INSERT INTO tcs_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Den da AntapGod i bin spik po Abram, ‘Ai da AntapGod, uda bin teke yu go ausaid prom big taun blo Er wea kantri blo Babilonia po gibe yu dis lan wea i gobi lan blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Bat Abram i bin askem, ‘AntapGod, bos blo ebriting, wiskain ai go sabe dis lan i gobi blo mi?’ ");
INSERT INTO tcs_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Da AntapGod i bin ansa, ‘Teke wan yang tri iya oul omankau kam po mi wea i no bin gad beibi, ane wan tri iya oul omangout wea i no bin gad beibi, ane wan tri iya oul mansip. Ane teke wan kudluk ane wan yang geinau.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abram i bin teke dem animal kam po God, den em bin kile ebridem animal ane em bin splite dem animal rait melen meke tu pis ane em pute demtu pat blo dem animal lo tu lain. Bat em no bin splite da kudluk ane geinau. ");
INSERT INTO tcs_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ane wen ol prapa anggre nugudpizin bin kam po kaikai dem bodi blo dem animal, Abram i bin seswei dempla. ");
INSERT INTO tcs_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Nau wen da san i bin godaun, bipo i bin stat po kam dak, Abram bin dedslip ane stretwei em bin pil nadakain prapa prait ane em bin stat po go senslus prom nadakain ebipiling. ");
INSERT INTO tcs_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Den da AntapGod bin spik po Abram, ‘Yu prapa sabe diswan, ol pamlelain blo yu i go kam wase streinza lo wan kantri i no blo dempla. Dem pipol blo dat kantri i go pose pamlelain blo yu po wok po dempla, ane dempla i go meke nugudwei po ol pamlelain blo yu, po 400 iya. ");
INSERT INTO tcs_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bat ai go panis dem pipol uda i go meke ol pamlelain blo yu ol sleib. Ane wen ol pamlelain blo yu i go libe dat kantri biain, dempla go teke ebri gudsamting wea dempla. ");
INSERT INTO tcs_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Yu go gad pis ane yu gobi prapa oulman wen yu go pinis. ");
INSERT INTO tcs_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Wen i go kese da namba po pamlelain, dat pamlelain blo yu i go kambaik po dis ples, bikoz ai nogo tekemaute dem pipol blo Amo antil nugudwei blo dempla i go kam prapa nugud wea ai mas panis dempla.’ ");
INSERT INTO tcs_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Wen i bin naittaim, Abram i bin luk wan sospan wea i gad paia ban insaid ane mata ol smok i bin kamaut. Wan paiastik i bin pas go rait melen lo dem mit blo dem animal. ");
INSERT INTO tcs_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Lo da seimdei, da AntapGod i bin meke strong griment wea Abram. God bin spik, ‘Po dem pamlelain blo yu, ai prapa gibe dempla dis lan, i stat prom baundri blo Izipt go po da big riba blo Yupreitis, ");
INSERT INTO tcs_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ane dem lan blo dem pipol blo Ken, blo dem pipol blo Keniz, blo dem pipol blo Kadmon, ");
INSERT INTO tcs_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","blo It, Perez, Repa, ");
INSERT INTO tcs_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amo, Kanan, Gergas, ane blo dem pipol blo Zebu.’ ");
INSERT INTO tcs_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Sarai oman blo Abram, i no bin gad pikinini po Abram. Bat Sarai bin gad wan yang sebant oman prom kantri blo Izipt. Neim blo em Eiga, ");
INSERT INTO tcs_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ane Sarai i bin spik po Abram, ‘Da AntapGod i bin stape mi po gad pikinini. Mata go ane slip wea sebant oman blo mi. Mait em go gad wan pikinini po mi.’ Ane Abram bin lisen ane mekem wanem Sarai i bin wandem. ");
INSERT INTO tcs_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Apta da taim wen Abram bin stap wea lan blo Kanan po ten iya, Sarai i bin teke sebant oman blo em, Eiga kam po Abram po mekem sekan oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram bin slip wea Eiga. Wen Eiga bin paindaut em pamle, em bin luk Sarai wansaid ane nomo rispekt em. ");
INSERT INTO tcs_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Sarai bin spik po Abram, ‘I polt blo yu Eiga i meke rongting po mi. Ai bin gibe sebant oman blo mi po yu ane wen em luk em pamle, em luk mi wansaid. Ai aske da AntapGod po luk uda prom yumitu i rait; yu o mi!’ ");
INSERT INTO tcs_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram ansa, ‘A wa! Yu bos blo em. Mekem wanem yu tingk i rait.’ Den apta, Sarai bin meke prapa nugudpasin po Eiga, ane prom dem nugudpasin blo em, Eiga bin ranwei prom Sarai. ");
INSERT INTO tcs_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Da einzel blo da AntapGod bin mite Eiga wea wan spring lo da dezet eria wea da rod go po Sur, klostu baundri blo kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Da einzel blo da AntapGod i bin spik diskain, ‘Eiga, yu sebant oman blo Sarai. Wea yu kam prom a, ane wea yu go nau?’ Ane Eiga i bin ansa, ‘Ai ranwei prom Sarai, bos blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Da einzel blo da AntapGod i spik po em, ‘Gobaigen po Sarai ane mekem wanem em oda yu po mekem.’ ");
INSERT INTO tcs_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Da einzel blo da AntapGod i bin spik gen. Em spik, ‘Ai go gibe yu prapa tumas pamlelain i go kan kaunte dempla.’ ");
INSERT INTO tcs_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ane da einzel blo da AntapGod i bin spik po Eiga, ‘Wa, i prapa tru! Yu diskaintaim yu pamle ane yu go bone boi pikinini. Yu go kolem Ismaiel, bikoz da AntapGod i bin lisen wiskain yu bin atso. ");
INSERT INTO tcs_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Bat boi blo yu i gobi prapa stronged ane wail man tu. Em i go mata wande pait lo ebriwan, ane dempla go wande paite em. Em mata go stap lo nada ples prom ol kazen blo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Wa! Eiga bin kole da AntapGod diskain, ‘Da God uda bin luk mi.’ Em bin spik, ‘Ai bin luk da wan uda luk mi ane ai stil laip.’ ");
INSERT INTO tcs_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","So nau ol i bin kole dat wel, Bilairoi, i stap melen wea Kades ane Bered. Dat neim i min ‘Da wel blo da Laipwan uda luk mi’. ");
INSERT INTO tcs_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Eiga i bin bone boi pikinini po Abram. Ane Abram i bin kole dat pikinini Ismaiel. ");
INSERT INTO tcs_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram i bin 86 iya oul wen Eiga i bin bone Ismaiel. ");
INSERT INTO tcs_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Wen Abram bin kese 99 iya oul, da AntapGod i bin kam ane soe emselp po em. Da AntapGod i bin spik po em, ‘Ai da Strong AntapGod. Yu mas meke ebriting wea i rait prant lo mi ane no meke eni nugudting. ");
INSERT INTO tcs_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ane ai go go ane meke strong griment wea yu ane ai go gibe yu prapa plenti pamlelain.’ ");
INSERT INTO tcs_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Den Abram bin poldaun, pesdaun tase graun, ane God bin spik, ");
INSERT INTO tcs_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","‘Ai meke dis strong griment wea yu. Yu gobi prapa bigate blo ol prapa plenti pipol uda stap wea dempla oun kantri. ");
INSERT INTO tcs_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Nomo nau neim blo yu gobi Abram. Ai go kole yu Eibram nau bikoz ai bin meke yu bigate blo ol prapa plenti pipol uda stap wea dempla oun kantri. ");
INSERT INTO tcs_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ai go gibe yu plenti pamlelain. Ol pamlelain blo yu i go kam plenti dipren dipren pipol, uda tok dempla oun langus ane stap wea dempla oun kantri, ane ol king i go kamaut prom yu. ");
INSERT INTO tcs_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","‘Ai go meke strong griment wea yu. I gobi melen mi ane yu, ol pamlelain blo yu uda i bon apta yu, ane pamlelain apta pamlelain godaun. Dis strong griment i go mata go poeba. Ai God blo yu, ane God blo pamlelain blo yu uda i go bon apta yu. ");
INSERT INTO tcs_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ai go gibe dis lan po yu, ane po ol pamlelain blo yu. Ebridem lan blo Kanan i gobi blo yupla pamlelain poeba, ane ai gobi God blo dempla.’ ");
INSERT INTO tcs_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","God i bin kip spik po Eibram, ‘Da pat blo yu, yu mas pole dis strong griment blo mi, yu ane da pamlelain blo yu, pamlelain apta pamlelain go nau. ");
INSERT INTO tcs_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Diswan da strong griment blo mi wea yupla mas mekem, melen mi ane yu, ane pamlelain blo yu uda kam apta yu: ebri boi pikinini lo pamlelain blo yu mas kate poskin. ");
INSERT INTO tcs_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Yupla mas mekem wanem ai spik po yupla. Diswan gobi sain blo da strong griment melen mi ane yupla. ");
INSERT INTO tcs_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Pamlelain apta pamlelain blo yupla, ebri boi pikinini prom yupla mas kate poskin wen dempla i kese da namba eit dei apta dempla bon. Ebridem boi pikinini uda bin bon insaid wea pamle blo yu, yu mas kate poskin blo dempla. Ebridem boi pikinini uda bin bon prom sebant blo yu, yu mas kate poskin blo dempla. Ane ebridem boi pikinini wea i bin baiem wea mani prom ausaid man, dempla tu, mas kate poskin blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Ebridem boi pikinini uda i bon insaid lo pamle blo yupla, ebridem boi pikinini uda i bon prom sebant blo yupla, ane ol dem nadawan yupla baiem wea mani, yupla mas kate da poskin blo dempla. Diswan gobi sain wea bodi blo yupla blo dis strong griment ai bin mekem wea yupla ane dis strong griment i go mata go poeba. ");
INSERT INTO tcs_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Eni man pikinini uda no kate poskin blo dempla, dat man i nomo gobi man blo mi bikoz em no bin pole da strong griment blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","God bin kip spik po Eibram, ‘Sarai oman blo yu, yu nomo go kolem Sarai. Neim blo em gobi Sera nau. ");
INSERT INTO tcs_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ai go blese em ane ai go gibe yu wan boi pikinini prom em. Wa. Da boi pikinini gobi prapa bigate blo plenti dipren pipol wea ol stap lo dempla oun kantri, ane ol king i go kamaut prom ol pamlelain blo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Den Eibram bin nildaun, pes blo em tase da graun, ane em bin lap ane tingk po emselp, ‘Sa! Wiskain man diswan i go gad pikinini wen em i kese 100 iya oul? Wiskain Sera diswan i go bone pikinini wen em i kese 90 iya oul?’ ");
INSERT INTO tcs_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ane Eibram spik po God, ‘Yagar! Mata lugaut boi blo mi, Ismaiel gar, ane mata meke gudsamting po em.’ ");
INSERT INTO tcs_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","God ansarem, ‘Nono! Sera, oman blo yu, i go bon wan boi pikinini, ane yu go kolem Aizak. Ai go meke strong griment wea em solong da strong griment go mata go poeba po pamlelain blo em ane uda i go bon apta em. ");
INSERT INTO tcs_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Bat po Ismaiel, ai bin lisen wanem yu wande mi po mekem po em. Tru gar! Ai go blese em ane gibe em prapa plenti pikinini ane prapa plenti pamlelain. Em i go kam bigate blo tuelb prapa impotant man uda go kamaut prom pamlelain blo Ismaiel. ");
INSERT INTO tcs_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bat ai go meke strong griment wea Aizak. Prom Sera ane yu, dis boi i gobi bon distaim neks iya.’ ");
INSERT INTO tcs_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Wen God bin pinis tok po Eibram, God bin libe em ane go. ");
INSERT INTO tcs_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Wa. Dat seimdei Eibram bin mekem wanem God bin wandem. Em bin kate poskin blo Ismaiel ane ebridem man uda i bon insaid lo pamle blo em, ebridem man uda i bon prom sebant blo em, ane ol dem nadawan em bin baiem wea mani. ");
INSERT INTO tcs_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","26","Poskin blo demtu Eibram ane Ismaiel i bin kat lo seimdei. Eibram nau i bin 99 iya oul, ane Ismaiel i bin 13 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ane poskin blo ebridem man sebant ane boi blo dem sebant blo Eibram, ane ebridem man ane boi uda Eibram bin baiem wea mani, bin kat tu wea dat dei. ");
INSERT INTO tcs_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Da AntapGod bin soe emselp po Eibram wea dem prapa spesil bigtri blo man neim Mamre. I bin melendei nau ane Eibram i bin sidaun lo doawei blo tent blo em. ");
INSERT INTO tcs_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Eibram bin luk go ausaid ane em bin luk tri man stanap no longwei prom em. Wen em bin luk dempla, em bin kuikwan lego go po luk uda dempla. Ane wen em bin kam de, em bin nildaun pes blo em bin tase graun. ");
INSERT INTO tcs_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Eibram i bin spik po dempla, ‘Bos, plizgar. Ip yupla api, no kip wagbaut, mata stap ya po sotwail. ");
INSERT INTO tcs_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ai go singaut ol sebant po teke wata kam po yupla solong yupla ken wase leg blo yupla ane yupla ebriwan ken spel lelbet ya andanit dis tri. ");
INSERT INTO tcs_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Yupla bin prapa ona mi po kam bizit mi ane ai sebant blo yupla. Laue mi po go ane teke smol kaikai kam po yupla po kaikai solong yupla ken kam strong, ane apta yupla ken go gen.’ Demplatri i bin ansa, ‘A wa! Mekem wiskain yu bin spik.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","So Eibram bin kuikwan go insaid tent blo em ane go spik po Sera, ‘Kuikwan, teke nap plaua prom gud plaua blo yu, miksem ane meke tri loupbred.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Den Eibram bin ran go po dem buluk ane kau blo em, ane em bin suze wan nais yangkau wea i nais patwan wea i gad sopt mit. Eibram bin gibe da nais yangkau po wan sebant ane spik em po kilem, kukem, ane mekem redi po kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Wen kaikai i bin redi, Eibram i bin gede krimsiz, presmilk ane da kukmit. Den Eibram i bin tekem ane putem prant lo demtri man. Ane wail dempla bin kaikai, Eibram i bin stanap serbe dempla andanit dat tri. ");
INSERT INTO tcs_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Demplatri spik po Eibram, ‘Wea oman blo yu Sera?’ Em ansa po dempla, ‘Em de insaid tent.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Wan prom demplatri i spik, ‘Ai go kambaigen po yu diskaintaim neks iya, ane tru gar, Sera i go gad wan boi pikinini.’ Sera i bin lisen prom da doawei blo da tent, biain wea Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Eibram i bin eiz blo ol ate ane Sera bin eiz blo ol aka. Em i kan bone pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Sera bin lap po emselp wea tent ane bin spik po emselp, ‘Nau ai prapa aka, ane man blo mi i ate tu. Wiskain mitu ken gad pikinini? Nono! Mitu tu oul!’ ");
INSERT INTO tcs_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Da AntapGod bin aske Eibram, ‘Aukam Sera i bin lap ane spik po emselp, “Ei! Ai prapa aka nau. Wiskain ai go gad pikinini a?” ");
INSERT INTO tcs_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Yu spik mi nau. I gad eniting i prapa ad po da AntapGod po mekem, a? Ai go kambaigen po yu wea diskaintaim neks iya ane Sera i go gad boi pikinini.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Bat Sera bin nadakain prait, ane em bin spik laitok diskain, ‘Ai no bin lap.’ Bat da AntapGod i bin spik, ‘Wa! I tru, yu bin lap.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Den apta, demtri man bin lego go libe da ples blo Eibram biain ane Eibram i bin wagbaut wea dempla po yawo dempla. Ol i bin go antap aipat blo wan il wea dempla bin luk godaun po taun blo Sodom. ");
INSERT INTO tcs_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Da AntapGod i bin tingk po emselp, ‘Ai nogo aidem prom Eibram wanem ai go mekem, ");
INSERT INTO tcs_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","bikoz Eibram i go kam bigate blo wan big strong pipol uda i stap wea dempla oun kantri. Ol dem blesing ai go mekem po Eibram i go go tru em, po ebridem pipol blo ert. ");
INSERT INTO tcs_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ai bin suze em, solong em go soe ol pikinini blo em ane pamlelain blo em po meke ebrisamting wiskain ai da AntapGod i wandem ane meke ebriting wea rait ane gudwei. Den ai go meke ebriting po Eibram wanem ai bin spik ai go mekem.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Den da AntapGod i bin spik po Eibram, ‘Ai bin lisen dem pipol blo Sodom ane Gomora, ol i nugudpipol. Ane ai sabe dem prapa nugudting wea dem pipol blo Sodom ane Gomora i bin mekem. I mina nugud ane ");
INSERT INTO tcs_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ai mas lego godaun po luk wanem dempla bin mekem. Den ai go sabe nau ip i tru.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Den, demtu nada man bin wagbaut go po taun blo Sodom bat da AntapGod i bin stap biain lo Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Den Eibram i bin kam klostu po da AntapGod ane spik, ‘Wiswei dempla uda rait ane stret prant lo yu a? Yu go distroi dempla tugeda wea dem nugudpasin pipol tu a? ");
INSERT INTO tcs_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Wiswei ip i gad pipti pipol wea da taun uda rait ane stret? Yu go go ane distroi dempla tu a? Yu go distroi ane damiz ebridem pipol wea da taun, ane yu nogo sore po dem pipti pipol a? ");
INSERT INTO tcs_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Wiswei? Yu go distroi dempla uda rait ane stret prant lo yu, tugeda wea dem nugudpipol a? Nono! Yu nogo meke diskain, bikoz ip yu meke diskain yu go trite dem nugudpipol seimwei wase yu trite dem gudpipol. Mata yu i da zaz blo ert. Ane yu go zaz wea peawei so yu kan mekem diskain!’ ");
INSERT INTO tcs_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Da AntapGod i bin ansa, ‘Ip ai paine pipti pipol wea Sodom uda prapa rait ane stret prant lo mi, ai go sore ane ai nogo distroi ebridem pipol uda stap lo dat taun.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Eibram i bin spik gen, ‘Ai mina sore gar po meke stronged po kip tok po da Lodbos. Ai kasa man. Ai nogad no rait po tok. ");
INSERT INTO tcs_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Wiswei, ip i gad poti paib pipol, no pipti pipol uda i prapa stret prant lo Yu? Yu go mata distroi dempla wea da taun bikoz i mata gad poti paib pipol uda prapa stret prant lo yu?’ Den da AntapGod i bin ansarem, ‘Ai nogo distroi dempla wea da taun ip ai go luk i gad poti paib pipol uda prapa rait ane stret prant lo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Eibram i bin kip aske da AntapGod, ‘Wiswei, ip i mata gad poti pipol uda prapa stret prant lo yu?’ Da AntapGod i bin ansa po Eibram, ‘Bikoz prom dem poti pipol uda prapa stret prant lo mi ai nogo distroi ebridem pipol de.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Eibram spik gen po da AntapGod, ‘Yagar! Pliz gar! No wail po mi. Bat ken ai tok gar? Wiswei ip i mata gad tati pipol uda prapa rait ane stret prant lo yu?’ Da AntapGod i bin ansabaik po Eibram, ‘Ai nogo distroi dem pipol lo da taun ip ai go paine tati prapa stret pipol de.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Eibram i bin spik gen po da AntapGod, ‘Tru gar! Ai mina sore gar po meke stronged po mata tok po yu. Kasa, ip i gad tuenti pipol?’ Da AntapGod i bin ansa Eibram, ‘Bikoz prom dem tuenti pipol de, ai nogo distroi ebridem pipol wea da taun.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Den Eibram i bin sake lastok, ‘Yagar! Pliz gar! Lodbos, no wail po mi, bat laue mi po tok laswan. Kasa ip i gad ten pipol uda meke ebriting wea i prapa stret prant lo yu?’ Da AntapGod i bin ansa po Eibram, ‘Bikoz prom dem ten pipol uda meke ebriting wea i prapa stret prant lo God, ai nogo tekemaute laip prom ebri laip pipol wea da taun.’ ");
INSERT INTO tcs_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Apta da AntapGod i bin pinis tok wea Eibram, da AntapGod bin go ane Eibram bin gobaigen po tent blo em. ");
INSERT INTO tcs_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Demtu einzel bin kesem de lo taun blo Sodom, ane i bin olredi naittaim. Lot, nepiu blo Eibram, i bin sidaun lo doawei blo da geit blo da taun. Ane wen Lot i bin luk demtu einzel, em bin stanap ane spik po demtu. ‘Wiswei?’ Den Lot bin nildaun prant wea demtu, pesdaun po graun. ");
INSERT INTO tcs_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Den Lot i spik, ‘Wiswei, ol pren blo mi? Kam gar, ane stap lo aus blo mi solong yutu ken wase leg blo yutu ane slip ya. Den moningtaim yutu ken go.’ Bat demtu ansa, ‘No, mitu go slip ya melen wea taun.’ ");
INSERT INTO tcs_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bat Lot i bin mina tokstrong, den demtu einzel i bin gri po go insaid aus blo em. Lot i bin meke mina big kaikai, ane em bin kuke bred nogad yis po demtu ane dempla bin lego po kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bat bipo demtu einzel bin go po slip, ebri man lo Sodom, ol yangman ane ol oulman, stanap raun lo aus blo Lot. ");
INSERT INTO tcs_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Dempla ebriwan i ala po Lot, ‘Wea demtu man uda bin kam po stap lo yu ya tunait? Teke demtu kam po mipla solong mipla ken teke demtu po slip wea demtu.’ ");
INSERT INTO tcs_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot i bin go ausaid po dem pipol ane sate doa biain lo em, ");
INSERT INTO tcs_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ane spik, ‘Pliz gar! Ol pren blo mi, no meke dem nadakain mina nugud samting. ");
INSERT INTO tcs_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ai gad tu gel uda no bin slip lo man. Yupla mas laue mi po teke demtu kam po yupla solong yupla ken mekem wanem yupla wandem wea demtu. Bat no meke eniting nugud po demtu man ya uda stap wea aus blo mi, bikoz ai mas lugaut demtu.’ ");
INSERT INTO tcs_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bat dempla ala po Lot, ‘Gedaut prom rod blo mipla!’ Den dempla bin spik po wananada, ‘Ei! Dis man i ausaidman uda bin kam ya ane nau em wande akt wase em zaz blo mipla!’ Ane dempla bin spik, ‘Wa! So mipla nau go meke monugud samting po yu wiskain mipla go mekem po demtu.’ So dempla bin trai po grabe Lot po broke doa blo em daun. ");
INSERT INTO tcs_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Bat demtu man de insaid lo dat aus i bin pute an blo demtu go ausaid ane bin grabe Lot kam insaid da aus, ane demtu bin sate da doa biain lo em. ");
INSERT INTO tcs_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ane demtu i bin meke ebridem ai blo dem man uda de wea da doa solong dempla kan luk da doa. So dempla bin gibap po trai po kam insaid. ");
INSERT INTO tcs_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Den demtu man i bin spik po Lot, ‘Yu gad ol nada pamle ya a? Teke ol tawi blo yu, ol boi ane ol gel blo yu, ane ol nada pipol uda i pamle blo yu ya wea da taun. Teke dempla ebriwan go ausaid prom dis taun. ");
INSERT INTO tcs_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Bikoz mitu go mina distroi dis ples. Da stingk blo dis taun i bin singaut kese da AntapGod ane da AntapGod bin sane mitu kam po distroi ebridem pipol blo dis taun.’ ");
INSERT INTO tcs_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot i bin lego go po spik diskain po demtu man uda go kam man blo demtu gel blo em. Em spik po demtu, ‘Kuikwan, kamaut prom dis ples bikoz da AntapGod i ya kam po distroi dis ples.’ Bat demtu bin lap bikoz demtu bin tingk em meke pan po demtu. ");
INSERT INTO tcs_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Wen i bin stat po deilait, demtu einzel i bin trai po meke Lot po kuikwan kamaut. Demtu bin spik, ‘Teke oman blo yu ane tu gel blo yu ane kuikwan kamaut prom ya. Bambai yupla go wantaim lus wea ebridem nada pipol blo dis taun.’ ");
INSERT INTO tcs_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Den Lot i bin wase apenap po go. So demtu einzel i bin kese an blo Lot ane pamle blo em bikoz da AntapGod i bin prapa soe gudpasin po Lot. Den demtu einzel i bin teke dempla gudwei go ausaid prom dat taun. ");
INSERT INTO tcs_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Wen demtu einzel i bin pinis teke Lot ane pamle blo em go ausaid prom dat taun, demtu einzel i bin spik po dempla, ‘Yupla mas kuikwan ranwei po seibe yuplaselp. No stap ane luk baigen. Wen yupla go, go ane no stap lo da platples blo Zodan Riba. Mata ran antil yupla kese dem il. Bambai yupla go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Den Lot i bege demtu einzel, ‘No gar, Lodbos. ");
INSERT INTO tcs_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Tru gar! Yutu bin trite mi prapa gudwei, seibe laip blo mi ane yutu bin soe gudpasinwei po mi. Bat ai kan kuikwan ranwei go po dem maunten bikoz ai prait. Bambai nada nugudting i go kese mi wea dem maunten ane ai go ded. ");
INSERT INTO tcs_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Yutu luk. I gad wan prapa smol biliz ya klostu so ai ken kuikwan ran go de. Pliz gar, ai ken ran go de solong da laip blo mi i gobi orait a?’ ");
INSERT INTO tcs_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Wan dem einzel i bin ansa po em, ‘Orait. Ai go meke dis peiba po yu. Ai nogo distroi dat smol biliz. ");
INSERT INTO tcs_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Yupla kuikwan, ran go po dat biliz, bikoz ai kan meke eniting antil yupla go kesem de.’ Prom dat taim ol pipol i bin kole dat biliz Zoa, wea i min ‘smolples’. ");
INSERT INTO tcs_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Da san i bin stat po kamaut wen Lot i bin kesem de wea Zoa. ");
INSERT INTO tcs_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Den da AntapGod i bin stat meke ol ot ston wea i gad paia i ban, poldaun wase rein. Ol ot ston i poldaun antap lo demtu taun blo Sodom ane Gomora. ");
INSERT INTO tcs_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","God i bin distroi demtu taun wea da bali blo Zodan Riba, kile ebridem pipol uda stap wea dem taun ane kile ebrisamting wea i gro lo da graun wea dem taun. ");
INSERT INTO tcs_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bat da oman blo Lot uda bin wagbaut biain lo Lot, em bin luk gobaik po dat taun ane em bin tan kam po solt, ad wase ston. ");
INSERT INTO tcs_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Eibram i bin lego go prapa elimoning po da ples wea da AntapGod i bin stanap ane tok po Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","So wen Eibram i bin luk godaun po Sodom ane Gomora ane da lan wea da bali blo Zodan Riba, em bin luk smok go antap prom dem taun wase wan nadakain bigpaia. ");
INSERT INTO tcs_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","I bin demkain wen God i bin mina distroi dem taun blo da bali blo Zodan Riba. God bin mata tingbaut po Eibram wen em bin seibe Lot prom da taun bipo em bin distroi dem taun. ");
INSERT INTO tcs_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Apta wen demting ya i bin apen, Lot bin lego go prom Zoa. Em bin stap wea dem maunten lo tu gel blo em. Em bin prait po stap wea Zoa, so em bin mata stap insaid keib wea tu gel blo em. ");
INSERT INTO tcs_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Wantaim, biggel blo Lot i bin spik po smolsisi blo em, ‘Papa blo yumi i oulman nau, ane i nogad no man ya raun po yumi go maret. ");
INSERT INTO tcs_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kam, yumi go meke papa blo yumi dringk tumas wain po kam prapa spak, solong yumi ken slip wea em ane yumi ken meke pamlelain prom em.’ ");
INSERT INTO tcs_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Dat seim nait, demtu i bin meke papa blo demtu dringk mina plenti wain. Da biggel blo Lot i bin go ane slip wea papa blo em. Bat Lot i no bin sabe wanem biggel blo em bin mekem bikoz em bin prapa spak. ");
INSERT INTO tcs_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Lo da neks moning, biggel blo Lot i spik po smolsisi blo em, ‘Wa tru! Lasnait ai bin slip wea papa blo mi. Kam, yumi go gibe em dringk gen tunait po mekem prapa spak gen, den yu ken slip wea em solong yumi ken meke pamlelain prom em tu.’ ");
INSERT INTO tcs_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Wa! Dat seim naittaim, demtu gen bin meke papa blo demtu spak. Distaim smolsisi bin go ane slip wea papa blo em, ane Lot no bin sabe wanem smolgel blo em bin mekem bikoz em bin prapa spak. ");
INSERT INTO tcs_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","So demtu gel blo Lot i bin kam pamle prom papa blo demtu. ");
INSERT INTO tcs_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Da biggel blo Lot i bin bone boi pikinini, kolem Moab. Em bigate blo dem pipol blo Moab blo tidei. ");
INSERT INTO tcs_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ane da smolgel blo Lot i bin bone boi pikinini kolem Benami. Em bigate blo dem pipol blo Amon blo tidei. ");
INSERT INTO tcs_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Prom dem prapa spesil bigtri blo Mamre, Eibram i bin mub go libe dat ples biain ane em bin go saut po eria blo Negeb. Em bin stap melen dem ples blo Kades ane Sur wea taun blo Gera. ");
INSERT INTO tcs_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Wea dat taim, Eibram bin spik po dem pipol diskain, Sera oman blo em, i sisi blo em. So King Abimalek blo Gera bin singaut po Sera po kam po em ane Abimalek bin meke em po oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Dat nait God i bin kam po Abimalek insaid lo drim ane bin spik po em, ‘Prapa tru! Yu go ded sun bikoz dat oman wea yu bin tekem, em i oman blo nada man.’ ");
INSERT INTO tcs_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Bat Abimalek no bin slip wea Sera yet, so em bin aske God, ‘Yu go stil distroi mi ane pipol blo mi uda no bin meke rongting a? ");
INSERT INTO tcs_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Eibram emselp i bin spik po mi, “Sera em i sisi blo mi”, ane Sera emselp bin spik, “Wa, em bala blo mi.” Ai bin meke diswan wea gudat blo mi. Ai no bin meke eniting rong.’ ");
INSERT INTO tcs_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Den God i bin kip tok po Abimalek insaid wea da drim blo em, ‘Wa, ai sabe yu bin meke disting wea gudat blo yu, ane wa, i bin mi uda bin stape yu prom meke nugudting gense mi. Daswai ai no bin laue yu po slip wea em. ");
INSERT INTO tcs_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Taim nau po teke da oman gobaigen po man blo em, bikoz man blo da oman i wan spesilmesizman ane em go prea po yu solong yu nogo ded. Bat ip yu no teke em gobaigen po man blo em, ai spik yu tru, bambai yu go ded, yu ane ol pipol blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Wen i bin elimoning, Abimalek bin gedap ane bin singaut po ol edman blo em po kam. Ane em bin spik po dempla ebriting wanem i bin apen lo drim blo em. Dempla bin prapa nadakain prait. ");
INSERT INTO tcs_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Den Abimalek bin spik po teke Eibram kam po em ane em bin tok rapwei po Eibram diskain, ‘Wanem disting yu bin mekem po mipla? Ai no bin meke eni nugudting po yu. Bat tok blo yu bin meke mi ane pipol blo mi po meke wan prapa nugudting. Nobodi spostu meke ol nugud samting wiskain yu bin mekem po mi. ");
INSERT INTO tcs_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Watpo yu bin meke disting po?’ ");
INSERT INTO tcs_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Eibram i bin ansa po King Abimalek, ‘Ai bin meke diswan bikoz ai bin tingk, ol pipol ya lo dis ples i no lisen ane pole God. Ai bin tingk dempla go kile mi solong ol ken teke oman blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ane wa, em i prapa sisi blo mi. Mitu gad seim papa bat dipren mama, den apta ai bin maret em. ");
INSERT INTO tcs_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ane wen God i bin spik mi po wagbaut go ane libe da aus blo papa blo mi biain, ai bin spik po oman blo mi po lugaut mi ane spik po ebri pipol demkain, ai bala blo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Apta wen Eibram bin pinis dis tok, Abimalek bin teke plenti sip ane buluk, ane man ane oman sleib go gibem po Eibram ane wantaim i bin teke Sera gobaigen po Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Den Abimalek bin spik po Eibram, ‘Wa! Luk ebriwea lo dis ples ya wea ai bos. Yu ken stap eniwea wea yu wandem.’ ");
INSERT INTO tcs_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Den Abimalek bin spik po Sera, ‘Tru gar. Ai gibe bala blo yu 1,000 pis blo silba. Diswan i po soe ebri pipol blo yu, yu no bin meke eniting rong. Ai no bleime yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Da AntapGod i bin prapa stape ebri oman uda stap wea aus blo Abimalek bikoz em i bin teke Sera, oman blo Eibram. Den Eibram i prea nau po God, ane God bin wantaim gibe Abimalek baik da strong po meke pikinini ane wantaim meke oman blo em ane ol oman sleib kamgud solong dempla ken bone beibi. ");
INSERT INTO tcs_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Da AntapGod i bin mekem po Sera wiskain da AntapGod bin spik em go mekem. ");
INSERT INTO tcs_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sera bin pamle ane em bin bone boi pikinini prom Eibram wen Eibram bin oulman. Disting i bin apen da seimkain wiskain wen God bin tok pas po Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Eibram bin kole boi pikinini blo em, Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Wen Aizak i bin eitdei oul, Eibram i bin kate poskin blo Aizak wiskain God i bin oda Eibram po mekem. ");
INSERT INTO tcs_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Eibram i bin 100 iya oul wen Aizak i bin bon. ");
INSERT INTO tcs_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sera i bin spik, ‘God i bin meke mi nadakain api, ane meke mi lap. Ebriwan uda go lisen dis tok, dempla gobi api bikoz ai api.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ane Sera i bin spik gen, ‘Nobodi bin tingk ai go gad pikinini prom Eibram. Wa! Ai bin bone boi pikinini prom Eibram ane em i oulman.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Aizak bin kam boi nau ane em i nomo dringke susu, so Eibram bin meke big kaikai lo seimtaim. ");
INSERT INTO tcs_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Melen da big kaikai, Sera i bin luk da boi blo Eiga, oman sebant blo em. Eiga em i Iziptoman. Da boi blo Eiga bin moke Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Sera bin tok strong po Eibram, ‘Seswei da sebant oman ane boi blo em go ausaid, bikoz ai no wande demtu go kese eni gudsamting blo yu. Mata boi blo yu Aizak, go kese ebri gudsamting blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Eibram bin prapa atso bikoz Ismaiel i bin pikinini blo em tu. ");
INSERT INTO tcs_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bat God i bin spik po Eibram, ‘Yu no atso po da boi pikinini ane sebant oman blo yu prom wanem Sera bin spik po yu. Mata mekem bikoz yu go gad pamlelain tru Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Bat ai go meke boi blo Eiga kam bigate blo wan bigmob pipol uda stap wea dempla oun kantri, bikoz em boi blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Wa, neks moning, Eibram i bin gedap prapa eli, ane em bin meke ol kaikai redi ane teke wan skinbaig prapa pulap wea wata ane em bin gibem po Eiga. Em bin pute dem samting lo solda blo Eiga ane bin spik po demtu po go ane libe aus blo Eibram biain. So Eiga ane boi blo em bin lego go ane demtu bin wagbaut eniwea lo da dezet eria blo Bisiba. ");
INSERT INTO tcs_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Wen wata insaid da skinbaig bin pinis, Eiga i bin libe boi blo em andanit wea wan smoltri po seid. ");
INSERT INTO tcs_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Den Eiga bin go ane sidaun stret kros prom em, no prapa longwei. I bin baut 100 mita ane em tok po emselp, ‘Yagar! Ai no wande witnis dis pikinini po ded.’ Ane wen em bin sidaun kros prom da pikinini em bin stat po krai. ");
INSERT INTO tcs_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Ane God bin lisen krai blo da pikinini, ane da einzel blo God i bin singaut po Eiga prom antap, ane em spik, ‘Eiga! Aukam yu wori? No prait. God i bin lisen da krai blo da boi blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Stanap! Kese an blo da boi pikinini klostu. Ai go meke em bigate blo wan prapa bigmob pipol uda stap wea dempla oun kantri.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Den God i bin meke Eiga po paine wan wel wea i gad wata insaid. Eiga bin go ane em bin pilemap da skinbaig wea wata ane em bin go gibe pikinini wata po dringk. ");
INSERT INTO tcs_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","God i bin lugaut da pikinini antil em bin bigman. Em bin stap wea da dezet eria blo Paran ane em bin kam prapa gud po anting lo bounaro. ");
INSERT INTO tcs_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Dat taim wen Ismaiel i bin stap lo da dezet eria blo Paran, mama blo em i bin mekem stret po wan Iziptoman po kam oman blo Ismaiel. ");
INSERT INTO tcs_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Lo dat seimtaim nau King Abimalek ane Paikol, uda da bos blo ol amiman blo Abimalek, bin kam yan lo Eibram. King Abimalek i bin spik po Eibram, ‘Ai sabe God i elpe yu lo ebrisamting yu mekem. ");
INSERT INTO tcs_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Wa. Yu mas meke strongpromis prant wea God. Yu nogo meke ol nugud samting gense mi ane ol pikinini blo mi ane gense ol pamlelain blo mi. Ai bin meke gudpasin po yu, so yu mas meke gudpasin po mi ane po ol pipol blo dis kantri blo mi, bikoz yu stap ya wase ausaidman.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Den Eibram i bin ansa, ‘Wa! Prant wea God ai go mekem wanem yu bin wande mi po mekem.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Den Eibram bin komplein po Abimalek diskain, em no bin laik wiskain sam dem sebant blo Abimalek bin sanewei sam sebant blo em prom wan wel. ");
INSERT INTO tcs_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimalek bin ansa po Eibram, ‘Ai no sabe uda bin meke disting. Watpo yu no bin spik mi disting? Diswan pastaim ai lisen dis tok.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Den Eibram bin teke ol sip, ane ol buluk ane em bin gibem po Abimalek ane demtu bin meke kontrak. ");
INSERT INTO tcs_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Den apta, Eibram bin teke nada seben yang omansip ane putem go wansaid. ");
INSERT INTO tcs_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ane Abimalek i bin spik po Eibram, ‘Aukam yu bin pute dem seben yang omansip go wansaid?’ ");
INSERT INTO tcs_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Eibram ansa gobaigen po Abimalek, ‘Yu mas teke dem seben yang omansip prom mi, solong wen yu teke dem sip i go soe ebribodi, ai bin digine dat wel.’ ");
INSERT INTO tcs_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tru gar, da ples i bin kolem Bisiba. Bisiba i min ‘wel blo promis’, bikoz i bin de demtu bin gri po mekem wanem demtu bin spik demtu go mekem. ");
INSERT INTO tcs_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Apta nau wen Eibram ane King Abimalek bin pinis meke strongpromis de lo Bisiba, Abimalek ane Paikol da bos blo dem amiman blo King Abimalek, i bin gobaigen wea da ples blo dem pipol blo Pilistia. ");
INSERT INTO tcs_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Den apta nau Eibram bin plante wan tamarisktri de lo Bisiba ane Eibram i bin wosip da AntapGod, da longlaip God. ");
INSERT INTO tcs_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Eibram i bin stap wase ausaidman po longtaim lo da ples blo dem pipol blo Pilistia. ");
INSERT INTO tcs_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Wen Eibram i bin stap de gudwail, God i bin meke samting po em po luk ip em i stil bilib lo God. God i bin spik po em, ‘Eibram!’ Ane Eibram i ansa gobaigen po God, ‘Wa. Ai ya AntapGod. Wiswei?’ ");
INSERT INTO tcs_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","‘Boi blo yu, Aizak, wea yu prapa gad tumas lab po em, yutu mas go po da ples wea ol pipol kolem Moria. Wen yutu kesem de, yu mas kile boi blo yu ane banem antap lo olta po wosip mi. Yu mas mekem lo wan maunten wea ai go soe yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Prapa elimoning, neksdei, Eibram bin gedap prom slip, ane meke dongki redi, teke tu sebant, ane teke boi blo em, Aizak. Em bin kate paiwud po da banopring, ane ol i bin lego go po da ples wea God i bin soe em po go. ");
INSERT INTO tcs_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Lo namba tri dei wen ol bin stil wagbaut, Eibram i bin luk ane em bin tekenotis da maunten bat i bin stil longwei. ");
INSERT INTO tcs_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Den Eibram bin spik diskain po tu sebant blo em, ‘Stap ya wea dem dongki. Mi ane boiwan go lego go de. Mitu go wosip God, den mitu go kambaigen po yutu.’ ");
INSERT INTO tcs_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Eibram bin teke paiwud po banopring ane bin gibem po Aizak po karem, ane em emselp bin kare da naip ane ot asis po state da paia. Wa! Demtu bin wagbaut go tugeda. ");
INSERT INTO tcs_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Aizak spik po papa blo em, ‘Papa?’ Ane Eibram ansarem, ‘Wiswei mai boi?’ Ane Aizak spik po papa blo em, ‘Prapa tru. Yumi gad ot asis po state paia ane yumi gad naip, bat wea da smolsip po kilem ane banem antap lo olta.’ ");
INSERT INTO tcs_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Eibram i bin ansa, ‘Mai boi, God emselp i go gibe da smolsip po kilem ane banem antap lo olta po wosip God.’ Apta nau demtu i bin wagbaut go tugeda. ");
INSERT INTO tcs_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Wen demtu bin kese da ples wea God bin spik po Eibram, em bin meke olta ane bin meke dem paiwud stret antap lo olta. Eibram bin taite an ane leg blo Aizak, ane em bin meke em leidaun antap lo dem paiwud, antap lo olta. ");
INSERT INTO tcs_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Den Eibram bin grabe da naip po kile da boi blo em. ");
INSERT INTO tcs_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Bat da einzel blo da AntapGod bin singaut po Eibram prom eben kamdaun, ane da einzel bin singaut prapa laudwan diskain, ‘Eibram! Eibram!’ Ane Eibram i ansa, ‘Ai ya God. Wiswei?’ ");
INSERT INTO tcs_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Da einzel i spik, ‘Stap! No kile da boi o meke eniting po em. Ai sabe nau yu prapa lisen ane pole God bikoz yu soem yu redi po kile da boi ane banem antap lo da olta po wosip mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ane Eibram i bin luk go wansaid ane em bin luk i bin gad wan mansip, pas lo wan smoltri wea on blo em. Eibram bin go ane grabe da mansip ane em bin kile em ane banem antap lo da olta po wosip God. Da sip i bin teke da ples blo da boi. ");
INSERT INTO tcs_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Den prom dat taim, Eibram i bin kole dat ples ‘Da AntapGod emselp i go gibem’. Ol pipol i stil spik diskaintaim, ‘Lo maunten blo da AntapGod, em i go gibem.’ ");
INSERT INTO tcs_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Da einzel blo da AntapGod i bin singaut gen po Eibram prom eben, ");
INSERT INTO tcs_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","ane God i bin spik, ‘Maiselp ai go meke disting. Diswan i wanem da AntapGod i spik. Bikoz yu bin lisen po mi ane no bin kipe boi blo yu prom mi, ");
INSERT INTO tcs_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ai go blese yu nau, ane ai go meke ol pamlelain blo yu mina plenti wase dem sta lo skai, ane wase san wea ol sanbis. Ane ol pamlelain blo yu i go prapa smase dem pipol uda no laik dempla ane gobi bos blo siti blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tru ol pamlelain blo yu, God i go blese ebridem pipol wea ert bikoz yu bin mina prapa lisen po mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Den Eibram ane Aizak bin wagbaut gobaigen po demtu sebant, ane dempla ebriwan bin lego go tugeda gobaigen po Bisiba ane Eibram bin stap de wea Bisiba. ");
INSERT INTO tcs_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Apta wen dem samting ya wea i bin apen, niuz i bin kam po Eibram ane i bin diskain; Milka oman blo Nao, bala blo Eibram i bin gad eit boi pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Uz bin pas boi pikinini, Buz bala blo em, Kemuel i papa blo dem pipol blo Aram, ");
INSERT INTO tcs_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Azo, Pildas, Zidlap, ane Betuel. ");
INSERT INTO tcs_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel i bin kam papa blo Ribeka. Milka bin bone dem eit boi pikinini ya po Nao. ");
INSERT INTO tcs_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Ane da sekan oman blo Nao i bin Ruma uda bin bone po boi pikinini, Teba, Gam, Taias, ane Maka. ");
INSERT INTO tcs_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sera i bin 127 iya oul wen em bin lus. ");
INSERT INTO tcs_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Em bin lus de lo da siti blo Kiriataba (wea nau i kolem Ebron) wea lan blo Kanan. Eibram i bin go insaid po tent po luk bodi blo Sera. Em bin nadakain sorewan gar, ane Eibram bin prapa krai po em. ");
INSERT INTO tcs_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Eibram i bin gedap prom bodi blo Sera, ane em bin go po da mitingples blo dem bigman blo dem pipol blo It, ane apta, em bin spik diskain, ");
INSERT INTO tcs_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","‘Ai ausaidman, ai nogad no lan ya lo yupla. Spik eni prais po mi po baie smol lan po bere oman blo mi gar.’ ");
INSERT INTO tcs_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Dem pipol blo It bin ansa baigen po Eibram diskain, ");
INSERT INTO tcs_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","‘Mai bos, lisen ya po mipla, yu prapa bigman ya wea mipla. Bere oman blo yu lo eni dem prapa gud beriolples blo mipla. Eniwan ane ebriwan prom mipla i nadakain api po gibe yu beriolples, solong yu ken bere em.’ ");
INSERT INTO tcs_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Eibram bin gedap ane baudaun wea rispekt po dem pipol blo It, dem pipol blo da lan. ");
INSERT INTO tcs_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Eibram i bin spik po dempla, ‘Ip yupla mina laue mi po bere oman blo mi ya, den lisen ya, ane plizgar aske Epron, boi blo Zoar, ");
INSERT INTO tcs_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","solong em mait selem po mi da keib de wea Makpela, wea em i bos. Diswan i wea lan blo em. Po da pul prais, laue em po selem po mi ya prant wea yupla, ane dat beriolples i gobi samting blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Den Epron i bin sidaun lo dem pipol blo It. Ane Epron i bin ansa po Eibram wea da mitingples blo dem pipol blo It, prant lo ebriwan uda bin wea da dowei blo geit blo da taun. Em i bin spik diskain, ");
INSERT INTO tcs_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","‘Bos blo mi, lisen po mi. Ai gibe dis ples priwan po yu, ane ai gibe yu dis keib priwan insaid dis ples. Prant lo dem pipol blo mi, ai gibem priwan po yu po bere oman blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Den Eibram baudaun gen wea rispekt po dem pipol blo dat lan. ");
INSERT INTO tcs_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Eibram ansabaik po Epron wea da mitingples blo dem pipol. Em bin spik, ‘Pliz gar. Mata lisen po mi! Ai go pei pul prais po da lan. Teke da mani solong ai ken bere oman blo mi de lo dat ples.’ ");
INSERT INTO tcs_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Nau Epron i ansa gobaigen po Eibram diskain, ");
INSERT INTO tcs_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","‘Mai bos, lisen po mi. Da prais blo lan i 400 pis blo silba. Bat yumi tu pren. Mitu mas no woribaut prais. Yagar. Go ane bere oman blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Eibram i bin gri wea Epron. Em bin gibem po Epron dem pis blo silba wea Epron bin kolem. Eibram bin mekem prant wea dem bigman blo dem pipol blo It. I bin 400 pis blo silba ane i bin stret wea weit wea ol biznisman i mekem wea maketples. ");
INSERT INTO tcs_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Wa! Dat lan blo Epron, wea Makpela, i bin lo istsaid blo da ples blo Mamre. Da lan wea i bin gad da keib insaid ane ebri tri wea dat lan i bin ");
INSERT INTO tcs_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kam lan blo Eibram. Dis griment i bin apen prant wea ebriwan lo da mitingples blo dem pipol blo It. ");
INSERT INTO tcs_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Apta nau, wen Eibram i bin pinis baie lan, em bin go ane bere oman blo em Sera, insaid da keib blo da lan blo Makpela. Diswan prapa klostu po Mamre wea nau i kolem Ebron, wea lan blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Da lan ane keib insaid wea da lan i bin kam lan blo Eibram, wea em bin baiem prom dem pipol blo It, po bi beriolples blo ol pipol blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Taim i bin pas ane Eibram i bin kam prapa oulman nau, ane da AntapGod i bin meke ol gudsamting po ebriting Eibram i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Wandei, Eibram i bin spik po da bossebant blo em uda bos blo ebrisamting blo em. ‘Yagar. Pute an blo yu lo leg blo mi ");
INSERT INTO tcs_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ane ai go meke yu po promis disting po mi prant wea AntapGod, da God uda bin meke skai ane ebriting antap lo skai ane lan ya daun. Ai wande yu po promis yu nogo meke boi blo mi Aizak gad oman prom dem pipol blo Kanan wea ai stap ya melen dempla. ");
INSERT INTO tcs_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Bat yu mas go po kantri blo mi ane po ol kazen blo mi ane teke wan oman kam po Aizak, boi blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Dat bossebant bin ansabaik po Eibram, ‘Wiswei ip da oman no wande kambaik wea mi po dis lan? Yu go wande mi po teke boi blo yu gobaigen po dat lan prom wea yu bin kamaut a?’ ");
INSERT INTO tcs_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Eibram bin spik po bossebant blo em, ‘No! Yu prapa meikso po no teke boi blo mi gobaigen de. ");
INSERT INTO tcs_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Da AntapGod, God uda bin meke skai ane ebriting antap wea skai, i bin teke mi prom ol pamle blo papa blo mi ane prom da ples wea ai bin bon. Da AntapGod i bin spik, em go meke disting po mi diskain, “Po pamlelain blo yu, ai go gibe dis kantri.” Em go sane einzel blo em po go pas, ane yu go teke wan oman kambaigen po boi blo mi prom dat ples. ");
INSERT INTO tcs_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Bat ip da oman no wande kam wea yu, den yu mas no meke disting wea yu bin promis yu go mekem po mi. Bat yu mas no teke boi blo mi gobaigen po dat ples.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Den da bossebant i pute an blo em lo leg blo Eibram, ane em bin promis em go meke disting po Eibram wiskain Eibram i bin odarem po mekem. ");
INSERT INTO tcs_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Den da bossebant blo Eibram bin teke ten kamal blo Eibram ane bin stat lego go nau ane em bin kare olkain gudsamting prom bos blo em. Em bin pres go po da taun wea Nao, bala blo Eibram, i bin stap wea nowessaid blo kantri blo Mesapotamia. ");
INSERT INTO tcs_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Wen da bossebant blo Eibram i bin kesem de, em bin meke dem kamal leidaun ausaid prom taun klostu lo wan wel wea i gad wata. I bin leit aptanun nau ane i bin seimtaim wen ol oman i go ausaid prom taun po teke ol wata. ");
INSERT INTO tcs_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ane da bossebant blo Eibram i bin prea diskain, ‘AntapGod, God blo Eibram, pliz elpe mi gar po paine oman po boi blo em Aizak. Ane soe lab blo yu po bos blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ai ya stanap wea dis wel ane dem yangoman blo dis taun, uda no sabe man, ol i ya kam nau po teke wata. ");
INSERT INTO tcs_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ai go aske wan dem oman po gibe mi wata po dringk prom big watazag blo em. Ip em gibe mi dringk ane em wande gibe dringk po dem kamal, den ai go sabe em da rait oman, da wan yu bin suzem po oman blo Aizak. Wen i go apen diskain, ai go sabe yu bin soe lab blo yu po Eibram.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Bipo da bossebant blo Eibram i bin pinis prea po da AntapGod, wan yangoman i bin kam ausaid prom taun. Em bin kare wan big watazag antap lo solda blo em. Neim blo em i Ribeka. Ribeka em i gel blo Betuel. Betuel i bin boi blo Nao, bala blo Eibram ane oman blo Nao i bin Milka. ");
INSERT INTO tcs_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ribeka i bin nadakain gudluking gel uda no bin slip wea man yet. Em bin godaun po da wel, pilemap big watazag blo em. Ane wen em bin kam antap gen ");
INSERT INTO tcs_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","da sebant blo Eibram bin ran go po mite em ane spik diskain po em, ‘Pliz gar. Yu ken gibe mi smol wata po dringk prom watazag blo yu?’ ");
INSERT INTO tcs_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Em ansa, ‘Wa! Dringk gar.’ Ane em bin kuikwan pase da big watazag godaun prom solda blo em, ane kesem wail da man i bin dringk. ");
INSERT INTO tcs_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Wen em bin pinis gibe da bossebant blo Eibram wata po dringk, em bin spik, ‘Ai go wantaim teke ol wata kam po dem kamal antil dempla go gad nap po dringk tu.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Apta em kuikwan kapsaid ol wata ausaid prom da big watazag po dem dringking konteina blo dem kamal, em bin ran go po da wel po teke mo wata kam. Em bin kip teke mo wata antil dem kamal i bin gad nap po dringk. ");
INSERT INTO tcs_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Da bossebant blo Eibram i bin stap kuaiat, no tok, mata wase da yangoman po paindaut ip da AntapGod i bin suze em po bi oman blo Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Wen dem kamal i bin gad nap wata po dringk, da bossebant blo Eibram i bin teke wan prapa dia gold ring ane putem wea nos blo da yangoman ane tu big gold breislet putem wea tu an blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Da bossebant blo Eibram i bin tok po em diskain, ‘Mai gel. Uda papa blo yu? Yu tingk i gad nap rum wea aus blo papa blo yu po mi ane ol man blo mi po slip, mata po wan nait a?’ ");
INSERT INTO tcs_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Da yangoman i bin ansa diskain gobaigen, ‘Ai gel blo Betuel ane Betuel em boi blo Nao ane Milka, ate blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Mipla gad speis po yupla ebriwan po stap wea mipla, ane mipla gad ol speis po ol dem kamal ane i gad ol kaikai po dem kamal tu.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Den bossebant blo Eibram i bin baudaun, pesdaun ane em bin wosip da AntapGod ");
INSERT INTO tcs_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","ane em bin tok po emselp, ‘AntapGod yu prapa gud, yu da God blo Eibram, wea yu no bin luk wansaid po soe lab blo yu ane gudpasin blo yu po bos blo mi. AntapGod, yu bin meke mi wagbaut kam stret lo da rod go po da aus blo kazenbala blo bos blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Den da yangoman bin ran go po aus blo mama blo em ane em bin spik po dempla ebriting wanem i bin apen. ");
INSERT INTO tcs_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribeka i bin gad wan bigbala neim Laban. ");
INSERT INTO tcs_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Wen Laban bin luk dia gold nosring, ane demtu big gold breislet wea tu an blo sisi blo em, ane wen em bin lisen dem tok blo sisi blo em, Laban i bin lego go po da bossebant blo Eibram. Em bin stil stanap lo dem kamal wea da wel. ");
INSERT INTO tcs_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban i spik po da sebant blo Eibram, ‘Alo gar, mai pren. Da AntapGod i bin blese yu. Yagar, i no rait po yupla po weit ya ausaid dis taun. Kam. Ai bin pinis meke speis redi ane ples po dem kamal.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Den da bossebant blo Eibram i bin go insaid da aus, ane Laban i bin tekemaute ol samting prom dem kamal, ane meke ol gud speis po ol kamal po slip ane gibe dem kamal kaikai. Den Laban i bin teke wata kam po da bossebant blo Eibram ane dem man blo em, po wase leg blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Den em bin sete teibol pute ol kaikai antap. Bat da bossebant blo Eibram i spik diskain, ‘Ai nogo kaikai antil ai go spik wanem ai bin kam ya po.’ Laban i ansa, ‘Wa. Wiswei?’ ");
INSERT INTO tcs_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Da bossebant blo Eibram i ansa, ‘Ai da bossebant blo Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Da AntapGod i bin blese bos blo mi ane em gad ol nadakain plenti samting. Da AntapGod i bin gibe em tumas sip, gout ane ol plenti buluk ane kau, ane ol mina tumas silba ane mina tumas gold, ol plenti man ane oman sebant, ane plenti kamal, ane ol dongki. ");
INSERT INTO tcs_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","‘Ane Sera oman blo da bos blo mi Eibram, em bin bone pikinini. Em i bigman nau ane Eibram i bin gibe boi blo em ebri gudsamting wea em i gad. ");
INSERT INTO tcs_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Bos blo mi bin meke mi po promis disting ya po em. Em bin spik po mi, “Yu nogo meke Aizak gad oman prom dem pipol blo Kanan, wea ai stap ya melen dempla. ");
INSERT INTO tcs_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Bat yu go po pipol blo papa blo mi, po ol kazenbala blo mi ane teke wan oman kam po boi blo mi Aizak.” ");
INSERT INTO tcs_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","‘Ai bin spik po bos blo mi, “Wiswei ip da oman no wande kambaigen lo mi a?” ");
INSERT INTO tcs_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Bat, bos blo mi, Eibram, i bin ansa ane spik diskain po mi, “Da AntapGod uda meke ebriting wea laip blo mi, i go mekem. Em i go sane einzel blo em go wea yu, solong da einzel go soe uda i gobi oman blo Aizak. Yu go teke wan oman kam po boi blo mi prom ol kazen blo mi, prom ol pipol blo papa blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Wen yu go go po ol kazenbala blo mi ane ip dempla nogo gibe da yangoman po yu, yu mas no meke disting wea yu bin promis yu go mekem po mi.” ");
INSERT INTO tcs_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","‘Ai bin kam tidei po da wel, ane ai bin prea, “AntapGod, God blo Eibram. Yagar. Mata yu ken soe mi da oman blo Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ai ya stanap wea dis wel. Wen wan yangoman uda i no sabe man i go kam ausaid po teke wata, ai go aske em po smol dringk prom big watazag blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ip em go gibe mi ane ol kamal blo mi wata po dringk, yu laue em po kam da oman wea da AntapGod bin suzem po boi blo bos blo mi.” ");
INSERT INTO tcs_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","‘Bipo ai bin pinis prea kuaiatwan, Ribeka i bin kam ausaid wea big watazag antap lo solda blo em ane em bin lego godaun po da wel po teke wata. Ai bin spik diskain po em, “Pliz gar. Yu ken gibe mi smol wata po dringk a?” ");
INSERT INTO tcs_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Em bin kuikwan pute da big watazag godaun prom solda blo em ane em bin spik diskain, “Dringk gar ane ai go wantaim gibe wata po dem kamal blo yu tu.” Den apta ai bin dringk wata, em bin wantaim gibe wata po dem kamal blo mi po dringk. ");
INSERT INTO tcs_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","‘Den ai bin aske em, “Mai gel, uda papa blo yu?” Em bin ansa, “Ai gel blo Betuel ane Betuel i boi blo Nao ane Milka, ate blo mi.” Ai bin pute ring wea nos blo em ane demtu breislet wea tu an blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","‘Den ai bin baudaun pesdaun ane wosip da AntapGod, ane ai bin spik, “AntapGod yu prapa gud, yu God blo bos blo mi Eibram.” Ai eso em po teke mi kam stret po da rait ples, po wel blo bala blo bos blo mi, solong ai ken aske wan oman blo dis aus po kam oman blo boi blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Wa, diskaintaim, ip yupla go meke ol samting lo gudwei ane prapawei po bos blo mi, spik mi gar! Ip yupla nogo mekem, spik mi solong ai go trai luk wanem nau ai go mekem.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Den Laban ane Betuel bin ansa da bossebant blo Eibram diskain, ‘Wa. Ip da AntapGod bin meke diswan, wel mipla kan meke nating. ");
INSERT INTO tcs_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","A wa! Ribeka em ya. Teke em ane go. Meke em po kam oman blo Aizak, boi blo bos blo yu, wiskain da AntapGod bin spik.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Wen da bossebant blo Eibram i bin lisen wanem dempla bin spik, em bin baudaun ane bin wosip da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ane bossebant blo Eibram i bin tekemaute ol nais samting blo silba ane gold po werem wea bodi ane ol klos, ane em bin gibem po Ribeka. Em wantaim gibe ol mina prapa dia samting po bala blo Ribeka ane mama blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Den apta, bossebant blo Eibram ane ol man blo em bin kaikai, ane dempla bin slip de po wan nait. Wen bossebant blo Eibram ane ol man blo em bin gedap moningtaim nau, da bossebant bin spik diskain po bala ane mama blo Ribeka, ‘Pliz gar. Sane mi po gobaigen po da bos blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Bala ane mama blo Ribeka bin ansa, ‘Laue Ribeka po stap ya sotwail wea mipla po baut ten dei, den apta em ken go.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Bat da bossebant blo Eibram ansa po demtu diskain, ‘No meke mi stap bikoz da AntapGod i bin meke mi paine da oman po Aizak, boi blo bos blo mi. Laue mi po go, solong ai ken gobaigen po da bos blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Bala ane mama blo Ribeka i bin spik diskain po da sebant, ‘Mitu go singaut Ribeka kam po aske em wiswei em tingk.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Ane demtu bin ala po Ribeka po kam ane demtu aske em diskain, ‘Wiswei yu tingk, yu wande go wea dis man a?’ Em bin ansa po demtu diskain, ‘Wa! Ai wande go.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","So pamle blo Ribeka i bin sane Ribeka ane oman uda bin groemape Ribeka prom wen em bin beibi, po go wea bossebant blo Eibram ane dem man blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ane pamle blo Ribeka bin blese Ribeka, ane dempla i bin spik diskain: ‘Sisi blo mipla, mait yu go kam mama blo ol prapa plenti pipol! Mait ol pamlelain blo yu go smase dem pipol uda enami blo yupla.’ ");
INSERT INTO tcs_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Den Ribeka ane dem oman sebant blo em, bin klaimap antap lo dem kamal, ane ol bin lego gobaigen wea bossebant blo Eibram ane dem man blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Baut seimtaim nau Aizak i bin kam prom Bilairoi. Ane em i bin stap lo eria blo da Negeb. ");
INSERT INTO tcs_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Wen i bin kam leit aptanun nau, Aizak i bin go po wagbaut tingk lo wan klia ples, ane wen em bin luk go longwei, em bin luk ol kamal wagbaut kam. ");
INSERT INTO tcs_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ane wen Ribeka bin luk go longwei em bin luk Aizak. Em bin kuikwan godaun prom da kamal. ");
INSERT INTO tcs_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Den em bin spik diskain po bossebant blo Eibram, ‘Ei! Uda dat man lo dat ples de, ane em ya wagbaut kam po mipla?’ Da bossebant i bin ansa, ‘Diswan i bos blo mi. Neim blo em Aizak.’ Den Ribeka i bin tekemaute da edskap blo em ane em bin kabare pes blo em. ");
INSERT INTO tcs_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Da bossebant blo Eibram i bin yan po Aizak ebrisamting wanem em bin mekem. ");
INSERT INTO tcs_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Den Aizak i bin teke Ribeka go insaid tent blo mama blo em Sera, da seim tent wea em bin stap insaid wen em bin laip. Aizak bin kam man blo Ribeka ane Ribeka em bin kam oman blo Aizak. Ane Aizak bin prapa laik Ribeka ane Ribeka bin mekem pilgud, bikoz Aizak i bin stil pil mina sore bikoz mama blo em bin lus, ane em bin api nau. ");
INSERT INTO tcs_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Eibram bin gad nada oman apta Sera. Neim blo em Ketura. ");
INSERT INTO tcs_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Em bin bone siks boi pikinini po Eibram ane kole dempla, Zimran, Zoksan, Medan, Midian, Isbak ane Sua. ");
INSERT INTO tcs_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Zoksan i bin papa blo Siba ane Dedan. Ane dem pamlelain blo Dedan i bin dem pipol blo Asur, Letus ane dem pipol blo Lium. ");
INSERT INTO tcs_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Dem boi pikinini blo Midian i bin Epa, Eper, Anok, Abida, ane Elda. Ebri demwan ya i bin ol pikinini blo Ketura. ");
INSERT INTO tcs_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Eibram i bin meke main blo em po gibe ebri gudsamting blo em po Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Bat po dem boi pikinini blo ol dem nada oman blo Eibram, wen Eibram bin stil laip em bin gibe ol mina gudsamting po dempla. Den em bin sanewei dempla prom boi blo em Aizak, go po dem lan lo istsaid. Eibram no bin wande dempla po stap lo seimples wea Aizak i bin stap. ");
INSERT INTO tcs_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Eibram i bin kese 175 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Eibram i bin prapa oulman wen em bin lus. Em bin gad prapa long ane gudlaip. Wen em bin ole laswin blo em, em bin go ane zoine ol pamle blo em uda bin pinis ded. ");
INSERT INTO tcs_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Tu boi blo Eibram, Aizak ane Ismaiel i bin bere em insaid lo da keib blo Makpela wea lan blo Epron. Epron em i boi blo Zoar da It man, ane dis lan i bin lo istsaid blo Mamre. ");
INSERT INTO tcs_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Diswan lan wea Eibram i bin baiem wea da mitingples blo dem pipol blo It. Demtu bin bere em de wea Sera, oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Apta wen Eibram bin ded, God i bin meke ol mina prapa gudsamting po Aizak. Ane Aizak bin go po stap de lo Bilairoi wea eria blo Negeb. ");
INSERT INTO tcs_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Diswan ya stori blo pamlelain blo Ismaiel. Mama blo Ismaiel i bin Eiga da sleib oman, wea Sera uda bin gibem po Eibram po bi nada oman po em. ");
INSERT INTO tcs_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Ya nau dem neim blo dem boi pikinini blo Ismaiel. Neim blo dempla i stat prom da bigwan wen dempla bin bon. Nebaiot, em pas boi blo Ismaiel, ane Kedar, Adbil, Mibsam, ");
INSERT INTO tcs_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO tcs_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Adad, Tema, Zetur, Napis, ane Kedema. ");
INSERT INTO tcs_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Prom dem tuelb boi pikinini dem tuelb pamlelain bin stat. Ebriwan kare neim blo dempla oun pamlelain ane dempla stap lo dempla oun ples. ");
INSERT INTO tcs_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaiel i bin kese 137 iya oul. Em bin ole laswin blo em ane em bin zoine ol pamle blo em uda bin pinis ded. ");
INSERT INTO tcs_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Dem pamlelain blo Ismaiel bin lego go po stap lo da lan melen wea Abila ane Sur. Dis lan i lo istsaid lo kantri blo Izipt, wea da bigrod wea i go po lan blo Asu. Ane Ismaiel ane pamlelain blo em i bin stap nada ples prom dem nada pamlelain blo Eibram bikoz ol bin gense wananada. ");
INSERT INTO tcs_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Diswan ya stori blo pamlelain blo Aizak. Em boi blo Eibram ane Eibram bin papa blo Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Wen Aizak bin kese 40 iya oul, em bin kam man blo Ribeka. Ribeka bin gel blo Betuel. Betuel em man blo Aram prom kantri blo Mesapotamia ane Ribeka i bin gad wan bala neim Laban. ");
INSERT INTO tcs_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aizak bin prea po AntapGod po aske da AntapGod po elpe oman blo em bikoz em no bin gad pikinini yet. Ane da AntapGod i bin mekem wanem Aizak i bin aske em po mekem, ane apta, Ribeka i bin kam pamle wea tuin. ");
INSERT INTO tcs_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Dem boi pikinini i bin prapa pus gense wananada insaid beli blo Ribeka. I bin wase demtu pait gense wananada. Ane Ribeka bin aske da AntapGod diskain, ‘Aukam disting i apen po mi?’ ");
INSERT INTO tcs_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ane da AntapGod i bin spik po Ribeka, ‘Yu gad tu boi pikinini insaid beli blo yu ane demtu go kam tu ate blo tu dipren dipren pamlelain blo pipol. Demtu boi pikinini wea i go kamaut prom yu, demtu go gad pikinini ane dempla pamlelain go prapa pait gense wananada. Pamlelain blo wan boi pikinini i gobi mostrong den pamlelain blo da nadawan. Da pas boi pikinini i go kam sebant blo da las boi pikinini.’ ");
INSERT INTO tcs_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Wen i bin taim blo Ribeka po bon, em bin bone tu beibi. ");
INSERT INTO tcs_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Pas boi pikinini i bin kamaut gad prapa red skin. Em gad tumas eya wase em bin were wan kout blo animal skin. Apta, dempla bin kolem Iso. ");
INSERT INTO tcs_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Stretwei sekan boi pikinini i bin kamaut tu. Em bin kese leg blo Iso taitwan kam ausaid. Da sekanwan i bin kolem Zekop. Aizak i bin 60 iya oul wen Ribeka i bin bone demtu boi pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Wen demtu boi pikinini i bin kam bigman nau, Iso bin dedli man po anting. Em bin man uda laik wagbaut ausaid lo bus, bat Zekop i bin dipren. I bin kuaiat man uda bin mata stap ane wok klostu po wea dempla i stap. ");
INSERT INTO tcs_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aizak bin prapa laik Iso, bikoz em bin laik po kaikai dem mit blo dem bus animal wea Iso i bin kilem. Bat Ribeka i bin prapa laik Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Wantaim Zekop i bin kuke sup. Den Iso i bin kam prom anting ane i bin mina prapa taiat ane anggre. ");
INSERT INTO tcs_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Iso spik diskain po Zekop, ‘Yagar. Ai prapa anggre! Ariap. Gibe mi sam red bezdabol sup.’ (Diswan wiskain em bin gede dis nada neim blo em, Edom, wea i min ‘red’.) ");
INSERT INTO tcs_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Zekop ansa po em diskain, ‘Orait! Bat pas yu mas gibem po mi dem rait blo da pasbon boi pikinini, bikoz yu da bigwan prom yumi. Den apta ai go gibe yu sam sup.’ ");
INSERT INTO tcs_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iso i spik gen, ‘Wa, tekem, i blo yu. Ariap, ai tingk ai go ded prom anggre. Wiskain dem rait blo da pasbon boi go elpe mi nau bikoz ai prapa anggre?’ ");
INSERT INTO tcs_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Zekop i bin spik prapa strong po Iso diskain, ‘Orait. Bat pas, yu mas meke strongpromis, yu go gibe mi dem rait blo da pasbon boi pikinini bikoz yu bigbala prom yumi.’ So Iso bin meke promis po em, ane Iso bin sele rait blo da pasbon boi po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Den Zekop i bin gibe Iso sam bred ane sam sup, ane Iso bin mina lego po kaikai. Apta wen em belipul em bin lego go. Tru gar! Iso no bin kea o gad eni piling em i bin gibe dem rait blo da pasbon boi po bala blo em. ");
INSERT INTO tcs_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","I bin gad wan prapa nadakain big anggretaim wea Aizak i bin stap, seimkain wase da taim blo Eibram wen em bin stil laip. Ane Aizak bin go ane libe Bilairoi ane em bin go po Gera, wan nada ples, po King Abimalek uda i bin king blo dem pipol blo Pilistia. ");
INSERT INTO tcs_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Da AntapGod bin soe emselp po Aizak ane bin spik diskain po em, ‘Yu nogo po Izipt bat yu mata go stap lo da ples wea ai go soem po yu. ");
INSERT INTO tcs_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Stap ya lo dis ples blo Gera wase ausaidman. Ai go elpe yu, ane ai go blese yu, yu ane po pamlelain blo yu. Ai go gibe ebridem ples ya, ane ai go mekem kam tru strongpromis wea ai bin spik ai go mekem po papa blo yu Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ai go meke pamlelain blo yu mina prapa plenti, wase dem sta antap wea skai ane ai go gibem po pamlelain blo yu ebridem ples ya. Ane tru pamlelain blo yu ai go blese dempla; ebridem pipol uda stap lo dempla oun kantri ya lo ert. ");
INSERT INTO tcs_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Ai go mekem diskain bikoz Eibram i bin prapa lisen po mi. Em bin prapa mekem wanem ai bin odarem po mekem ane em bin prapa lisen po demwei blo mi, dem tok blo mi, ane pole dem lo blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Aizak i bin stap nau wea da ples blo Gera. ");
INSERT INTO tcs_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Wandei, sam dem man blo ples blo Gera bin aske Aizak baut oman blo em. Aizak ansa dempla diskain, ‘Em sisi blo mi’, bikoz em bin prait po spik, ‘Em oman blo mi.’ Aizak i bin tingk diskain, ‘Bambai dem man blo dis ples go kile mi prom Ribeka, bikoz em prapa gudluking oman.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Wantaim, wen Aizak i bin stap de po gudwail, King Abimalek uda bin king blo dem pipol blo Pilistia, bin luk go ausaid prom wan winda ane em bin luk Aizak gasu ane kise oman blo em, Ribeka. ");
INSERT INTO tcs_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Den King Abimalek bin singaut po Aizak po kam, ane em bin spik diskain po em, ‘I mina tru! Ribeka, em oman blo yu. Aukam yu bin spik diskain, “Em sisi blo mi”?’ Aizak i ansa em diskain, ‘Bikoz ai bin tingk sam dem man go kile mi ane teke em.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","King Abimalek i kip tok gen, ‘Yu no spostu meke diskainting po mipla! Wiswei ip wan prom dem man bin slip lo oman blo yu. Ip disting i bin apen, den God mait bin panse mi ane pipol blo mi prom meke nugudting.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Abimalek bin tok prapa strong ane gibe oda po ebri pipol blo em, ane em bin spik diskain, ‘Eni man uda go meke eni badsamting po dis man o oman blo em, i go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nau lo dat seim ples blo Gera wea Aizak i bin stap, em bin plante ol sid blo wit. Wea da seim iya andredtaim mo kaikai i bin kamaut prom dem sid blo wit. Da AntapGod i bin meke ol gudsamting po em. ");
INSERT INTO tcs_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Den Aizak i bin gad ol prapa plenti gudsamting. Em bin kip gad ol mo ane mo samting antil em bin kam prapa risman. ");
INSERT INTO tcs_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Aizak bin kip gede ol prapa plenti sip, gout, buluk ane kau. Ane em bin gad ol prapa plenti sebant tu. Ane wa, dem pipol blo Pilistia bin zeles Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Nau dem pipol blo Pilistia bin pilemapem wea graun, ebridem wel wea dem sebant blo papa blo Aizak i bin digemapem lo da taim blo Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Den King Abimalek bin spik diskain po Aizak, ‘Yu gowei prom mipla. Yupla kam prapa mostrong den mipla.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","So Aizak i bin lego go ane libe taun blo Gera biain wea em bin stap ane em bin mub go ane stap nau wea dem tent lo da big bali ausaid lo Gera. ");
INSERT INTO tcs_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aizak ane ol sebant blo em bin digemap dem wel gen, dem seim wel Eibram i bin mekem pas. Ane Aizak i bin kole dem seim neim wea papa blo em i bin kolem. Dem pipol blo Pilistia bin pilemapem wea graun dem wel apta wen Eibram bin ded. ");
INSERT INTO tcs_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Bat wandei, wen dem man uda lugaut sip blo Aizak bin diginem, dempla bin paine nada preswata wel lo da big bali blo Gera. Dempla bin paine nadakain plenti wata. ");
INSERT INTO tcs_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Bat dem man blo Gera uda lugaut ol animal bin kam kleime da wel. Dempla bin spik diskain, ‘Dis wata i blo mipla.’ So big graul bin stat wea dem man uda lugaut dem animal blo Aizak ane dem man blo Gera. Prom diswan Aizak bin kole da wel Esek wea i min ‘po graul’. ");
INSERT INTO tcs_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Apta datwan, dem sebant blo Aizak bin digine nada wel, ane dem man blo Gera bin kam, graul gen wea dem sebant blo Aizak dat dempla bin bos blo da wel tu. Aizak bin kole da wel Sitna, wea i min ‘gense wananada’. ");
INSERT INTO tcs_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Aizak bin libe demtu wel ane dem sebant blo Aizak bin digine nada wel lelbet longwei. Dem man blo Gera nomo bin kam ane graul wea dem sebant blo Aizak. Aizak i bin kole da wel Riobot, wea i min ‘plenti speis’. Ane Aizak bin spik diskain, ‘Diskaintaim da AntapGod i bin meke speis po yumpla ebriwan, ane yumpla go kam plenti lo dis ples.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Den prom de Aizak ane ol pipol blo em bin libe dat ples biain ane bin mub go po ples blo Bisiba. ");
INSERT INTO tcs_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Ane lo dat seim naittaim wen Aizak dempla bin kesem de lo Bisiba, da AntapGod bin soe emselp po Aizak ane em bin spik diskain, ‘Ai da God blo papa blo yu, Eibram. Yu no prait bikoz ai ebritaim lo yu ane ai go blese yu ane ai go meke ol pamlelain blo yu nadakain plenti bikoz Eibram i bin oltaim lisen po mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Aizak i bin meke olta de, ane em bin wosip da AntapGod, ane Aizak bin setemap tent blo em po stap de. Dem sebant blo em bin digine nada wel. ");
INSERT INTO tcs_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Den wandei King Abimalek i bin go prom Gera go po Bisiba, lo Aguzat uda ebritaim gibe em adbais, ane Paikol uda bos blo dem amiman blo King Abimalek. ");
INSERT INTO tcs_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aizak spik po demplatri diskain, ‘Aukam yuplatri kam po luk mi? Baizi, yupla mas prapa eite mi ane yupla bin prapa meke mi kamaut prom ples blo yupla?’ ");
INSERT INTO tcs_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Demplatri man ansare Aizak, ‘Mipla prapa sabe da AntapGod em i ebritaim elpe yu. Mipla bin tingk mipla wande meke disting wanem mipla spik mipla go mekem lo yu. Laue mipla gar po meke wan strong kontrak lo yu ");
INSERT INTO tcs_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","solong yu nogo meke eni badsamting po mipla, seimkain wiskain mipla no bin meke badsamting po yu. Mipla bin mata meke ol gudpasin po yu ane wen mipla bin sanewei yu go, at blo mipla bin pil orait. I prapa klia da AntapGod i bin blese ebriting yu mekem.’ ");
INSERT INTO tcs_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Wa, Aizak i bin meke big pisting, em ane King Abimalek, Aguzat ane Paikol i bin gad prapa big kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Wen i bin elimoning Aizak ane King Abimalek, Aguzat ane Paikol i bin gedap ane dempla bin meke da strongpromis wea dempla spik dempla go mekem lo wananada. Ane Aizak i bin yawo demplatri, den dempla at i bin orait wen dempla bin lego go prom Bisiba. ");
INSERT INTO tcs_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Lo da seimdei wen King Abimalek bin gobaigen aus, dem sebant blo Aizak bin kam tok po Aizak baut da wel wea dempla bin diginem ane ol bin spik diskain po em, ‘Ei! Mipla bin paine wata!’ ");
INSERT INTO tcs_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","So Aizak i bin kole da wel Siba, wea i min ‘strongpromis’. Tidei nau i gad taun de kolem Bisiba wea i min ‘wel blo strongpromis’. ");
INSERT INTO tcs_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Wen Iso i bin poti iya oul, em bin maret tu oman blo It, Zudit gel blo Biri ane Basemat gel blo Elon. Demtu gel bin kam oman blo Iso. ");
INSERT INTO tcs_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Demtu oman blo Iso i bin meke laip blo Aizak ane Ribeka prapa nugud. ");
INSERT INTO tcs_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aizak bin kam prapa oulman nau ane em bin klosap po blain tu, em kan luk prapa. Em bin singaut po dat bigboi blo em Iso po kam ane em bin spik po em diskain, ‘Mai boi.’ Ane Iso ansa em, ‘Wa. Mi ya. Wiswei?’ ");
INSERT INTO tcs_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Aizak spik, ‘Mina tru gar. Ai prapa oulman nau ane ai no sabe wattaim ai go ded. ");
INSERT INTO tcs_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Teke ol samting blo yu, ol dem bounaro, ane go ausaid po anting lo bus ane teke mit blo bus animal kam po mi po kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Den kukem po mi da nais kaikai gar. Mekem wase da peibretwan blo mi, ane tekem kam po mi po kaikai. Den ai go aske da AntapGod po blese yu nau, seimkain wiskain da AntapGod i bin blesem pas po ate blo yu Eibram. Ai go aske da AntapGod bipo ai go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Wen Aizak i bin tok po Iso, Ribeka bin lisen tu. Wa, wen Iso bin lego go po bus po anting, ");
INSERT INTO tcs_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribeka bin spik po Zekop diskain, ‘Ei! Ai bin lisen papa blo yu spik diskain po bala blo yu Iso, ");
INSERT INTO tcs_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","“Teke mit blo bus animal kam po mi, ane kuke nais kaikai solong ai ken kaikai, den ai go aske da AntapGod po blese yu. Ai go askem prant lo da AntapGod po meke disting bipo ai go ded.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ribeka spik gen po Zekop, ‘Mina tru gar mai boi. Prapa lisen po tok blo mi wiskain ai oda yu. ");
INSERT INTO tcs_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Yu go po dem gout, ane teke tu yang patwan kam po mi, solong ai go kuke nais kaikai po papa blo yu, da prapa peibret blo em. ");
INSERT INTO tcs_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Den yu go tekem go po papa blo yu po kaikai, solong wen em go pinis kaikai em go aske da AntapGod po blese yu bipo em go ded. Den yu go gede da blesing bipo Iso.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Bat Zekop i bin ansa po mama blo em diskain, ‘Prapa tru gar mama. Yumi sabe bala blo mi Iso. Bodi blo em i wase em were kout blo animal skin, ane bodi blo mi, i wase smud. ");
INSERT INTO tcs_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ip papa blo mi i go tase bodi blo mi, den em go sabe ai bin mekpul em. Wa, Papa blo mi i go aske da AntapGod po kerse mi ane em nogo aske da AntapGod po blese mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ribeka i bin ansa po Zekop diskain, ‘Mai boi, lete ol dem nugud samting kerse laip blo mi. Mata lisen po tok blo mi ane go, teke demtu yang pat gout kam po mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Apta, Zekop i bin lego go ane kile demtu gout, klinem ane tekem kam po mama blo em. Ane mama blo em bin kuke nais kaikai, prapa peibret blo Aizak. ");
INSERT INTO tcs_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Den Ribeka i bin teke gud klos blo Iso kam wea em bin gad, ane meke Zekop po werem. ");
INSERT INTO tcs_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Den em bin teke dem skin blo dem gout, meke tu glab ane pasem lo tu an blo Zekop, teke mo skin pasemraun lo da nek pat blo em. ");
INSERT INTO tcs_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Den Ribeka i bin gibe Zekop da nais kaikai, ane bred wea em bin pinis kukem. ");
INSERT INTO tcs_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Apta, Zekop i bin lego go po papa blo em, ane em bin spik diskain po em, ‘Papa.’ Ane Aizak i ansa gobaigen po em, ‘Wiswei gar, mai boi? Uda yu?’ ");
INSERT INTO tcs_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Zekop i spik po papa blo em, ‘Diswan mi ya Iso, bigboi blo yu. Ai bin mekem wanem yu bin spik mi po mekem. Yagar sidaun nau ane kaikai mit blo bus animal, solong yu go aske da AntapGod po gibe blesing po mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Bat Aizak spik diskain po boi blo em, ‘Mai boi, wiskain yu bin painem kuikwan?’ Em ansa gobaigen po da papa blo em diskain, ‘Da AntapGod, God blo yu, i bin elpe mi po painem kuikwan.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Den Aizak i bin spik po Zekop, ‘Yagar, kam klostu po mi gar mai boi, solong ai go tase yu. Ai wande meikso yu mai boi Iso.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Zekop bin mub go klostu po papa blo em Aizak. Wen Aizak bin tase Zekop, Aizak bin tok po emselp diskain, ‘Bois blo em i bois blo Zekop, bat dem an i an blo Iso.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aizak, em i kan megaraut Zekop bikoz dem an blo Zekop i bin gad plenti eya wase dem an blo Iso. So Aizak i bin redi po meke blesing po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Bat Aizak i bin spik gen, ‘Ei! Sa, yu prapa boi blo mi Iso a?’ Em ansarem, ‘Wagar, diswan mi ya, Iso.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Den Aizak i spik, ‘Teke da kaikai kam po mi, ane ai go kaikai, den ai go aske da AntapGod po blese yu.’ Zekop i bin teke dem kaikai kam po Aizak ane em i bin kaikai. Zekop bin teke wain kam, ane em bin dringk. Den Aizak bin spik diskain po em, ");
INSERT INTO tcs_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","‘Yagar, mai boi. Kam klostu ane kise mi gar.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Zekop bin kam klostu po Aizak ane kise em ane Aizak i bin smele da smel blo dem klos blo Iso. Da smel i bin prubem po Aizak dat diswan i Iso. So nau em bin blesem diskain ane em spik, ‘Tru gar, da smel blo boi blo mi i wase ol pres gadan smel wea da AntapGod i bin blesem. ");
INSERT INTO tcs_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ai aske God po oltaim meke diu po wete dem gadan wea i gad kaikai blo yu ane pamlelain blo yu, ane ai aske God po oltaim meke ol gadan blo yu po groe ol plenti gud kaikai blo wit ane wain. ");
INSERT INTO tcs_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ai aske God po meke ebri pipol uda stap lo ert, ol gobi sebant blo yu ane ol pamlelain blo yu. Ai aske God po meke yu ane ol pamlelain blo yu po bi bos blo ebri kazenbala blo yu. Dempla go lisen tok ane pole oda blo yu ane pamlelain blo yu. Ip enibodi kerse yu den God go kerse dempla, ane ip enibodi blese yu den God go blese dempla.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Wen Aizak bin pinis aske God po blese Zekop lo seimtaim wen Zekop bin go ausaid prom da tent, Iso i bin kambaik prom anting. ");
INSERT INTO tcs_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Iso bin wantaim kuke nais kaikai ane em bin tekem go po papa blo em. Den em i spik diskain po papa blo em, ‘Yagar! Papa sidaun nau ane kaikai mit blo bus animal wanem ai bin kilem po yu, solong yu go aske God po blese mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Papa blo Iso i ansa po em diskain, ‘Uda yu?’ Em ansarem, ‘Diswan mi ya Iso, bigboi blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Den Aizak bin prapa prait ane seik obamak, ane em bin tok diskain, ‘Uda datwan nau, wea em bin go po teke mit blo bus animal kam po mi? Ai bin pinis kaikai ane ai bin pinis aske God po blese em. Ai kan! Ai kan seinze blesing. I blo em poeba.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Wen Iso i bin lisen dem tok wanem em papa bin spik, em bin krai prapa laudwan lo wailwei, ane em bin spik diskain po papa blo em, ‘Yagar! Papa, aske God po blese mi tu gar.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Bat papa blo em i ansa po em diskain, ‘Bala blo yu bin kam ane em mekpul mi. Ai bin wande aske God po meke blesing po yu, bat ai bin aske God po meke blesing po bala blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Iso i spik gen, ‘Prapa tru, neim blo em i Zekop. Em man uda mekpul ol pipol. Diswan da sekan taim em bin mekpul mi! Em bin kam ane teke dem rait blo pasbon boi pikinini, wea ai da pasbon boi blo yu, ane nau em bin teke blesing blo mi wea God spostu gibem po mi.’ Den Iso i bin spik, ‘Yu ken stil aske God gar po meke wan blesing po mi a?’ ");
INSERT INTO tcs_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Aizak ansa Iso diskain, ‘Ai bin pinis meke em po bi bos blo yu, ane ai bin meke ebri kazen blo em po bi ol sebant blo em, ane ai bin aske God po oltaim meke ol gadan blo em po groe prapa plenti wit ane wain. Yagar mai boi! Ai kan meke nating po yu nau.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iso bin kip aske papa blo em diskain, ‘Papa, plizgar! Ken yu stil meke nada blesing a? Yagar papa, aske God po meke wan blesing po mi tu gar!’ Iso bin base krai, mina laudwan. ");
INSERT INTO tcs_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Den papa blo em Aizak bin ansa po Iso diskain, ‘Orait! Ai go blese yu diskain. Yu ane pamlelain blo yu nogo gad gud lan po groe olkain gadan kaikai ane ol diu prom antap nogo wete dem gadan kaikai blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Yu ane ol pamlelain blo yu go oltaim paite ol nada pipol. Yu ane ol pamlelain blo yu gobi sebant blo bala blo yu ane ol pamlelain blo em. Bat apta, dem pamlelain blo em nomo gobi bos blo ol pamlelain blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Tru gar, Iso prapa no bin laik Zekop bikoz em bin teke blesing blo em. Iso bin tok po emselp ane spik diskain, ‘Da taim i klostu po papa blo mi go lus ane mipla go krai. Wen mipla go pinis krai, den ai go go po kile Zekop.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Bat wen Ribeka bin paindaut Iso i bin tingbaut po kile Zekop, Ribeka bin singaut po Zekop po kam ane em bin spik diskain po em, ‘Yagar. Bala blo yu Iso wande peibaik. Em go kile yu. ");
INSERT INTO tcs_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mai boi. Yu lisen po mi. Yu mas kuikwan ranwei go po bala blo mi Laban, de lo taun blo Aran. ");
INSERT INTO tcs_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Ane yu mas stap lo em po gudwail, antil da big wail blo bala blo yu i go pinis. ");
INSERT INTO tcs_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Ane wen wail blo bala blo yu i go pinis nau, em go piged wanem yu bin mekem po em. Den ai go sane man go po spik po yu po kam ane teke yu kambaigen prom de. Ai no wande luze tu boi blo mi lo seimdei.’ ");
INSERT INTO tcs_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Den Ribeka bin tok ane spik diskain po Aizak, ‘Ai prapa no laik demtu oman blo Iso. Demtu i It oman. Demtu prapa meke laip blo mi prapa nugud. Ai no wande Zekop po gad eni oman prom dis ples ya. Ai wande ded, no stap laip bikoz ai no wande luk wan It oman po kam oman blo mai boi Zekop!’ ");
INSERT INTO tcs_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Den Aizak i bin singaut Zekop po kam po em ane em bin blese em, ane bin oda em diskain, ‘Lisen ya po mi mai boi. Yu nogo maret eni dem Kanan oman blo ya. ");
INSERT INTO tcs_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yu wantaim ariap go po kantri blo Mesapotamia go po pamle blo ate Betuel. Em papa blo mama blo yu. Ane wan gel prom de i go kam oman blo yu, wan gel blo awa Laban, uda bala blo mama blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ai aske da Strong AntapGod po blese yu, ane yu go gad plenti pikinini ane ol plenti pamlelain i go kamaut prom yu. ");
INSERT INTO tcs_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Den ai go aske God po gibe yu da blesing wea em bin gibem po ate blo yu Eibram. Diswan i po yu ane pamlelain blo yu, solong yu gobi bos blo da lan wea yu stap ya nau wase ausaidman. Diswan nau da lan wea God i bin gibem po Eibram.’ ");
INSERT INTO tcs_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Apta da tok i bin pinis, Aizak i bin sane Zekop go nau, ane em bin go po kantri blo Mesapotamia, po dat awa blo em Laban, uda boi blo Betuel. Em man blo Aram prom Mesapotamia ane em bala blo Ribeka, uda mama blo Zekop ane Iso. ");
INSERT INTO tcs_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Den Iso, bala blo Zekop, em bin paindaut Aizak bin aske God po blese Zekop, ane Aizak bin sane Zekop go po kantri blo Mesapotamia po maret wan oman prom de. Iso bin paindaut em bin blese Zekop tu, ane bin oda Zekop diskain, ‘Mai boi, yu no gobi man blo wan dem Kanan oman blo ya.’ ");
INSERT INTO tcs_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Iso i bin paindaut Zekop bin prapa lisen po papa ane mama blo em, ane em bin pinis go po Mesapotamia. ");
INSERT INTO tcs_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Iso bin prapa sabe nau papa blo em no api wea ol dem Kanan oman. ");
INSERT INTO tcs_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","So Iso bin go po Ismaiel, awa blo em. Em i boi blo Eibram, ane Iso bin maret Magalat, gel blo Ismaiel. Magalat bin sisi blo Nebaiot. Em bin gel blo Ismaiel ane Ismaiel bin boi blo Eibram. ");
INSERT INTO tcs_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Zekop bin libe taun blo Bisiba biain, ane em bin lego go po ples blo Aran lo kantri blo Mesapotamia. ");
INSERT INTO tcs_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Wandei, wen em bin kip wagbaut em bin kam po wan ples ane em bin stap de po wan nait bikoz da san i bin redi po godaun. Em bin teke wan dem ston prom de raun, den em bin mekem wase pela po em po slip lo dat ples. ");
INSERT INTO tcs_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Wen em bin slip nau, em bin luk lo drim blo em, i bin gad plenti step, wea i stat prom ya daun ane i bin go, kipgo, go antap po eben. Em bin luk ol einzel blo God bin go antap ane kamdaun. ");
INSERT INTO tcs_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ane da AntapGod i bin kam lo em insaid lo da drim blo em, wea em bin stanap klostu po Zekop ane da AntapGod i bin spik diskain po em, ‘Ai da AntapGod, da God blo Eibram, ate blo yu, ane da God blo papa blo Aizak. Dis lan wea yu leidaun antap nau, ai go gibem po yu ane po ol pamlelain blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Dem pamlelain blo yu i go kam mina plenti wase dast blo ert. Dempla go mub go ausaid ebriwea po not, saut, ist ane wes. Wa, bikoz prom yu ane pamlelain blo yu, ai go blese ebri pamle ya wea lo ert. ");
INSERT INTO tcs_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Mina tru, ai ebritaim lo yu ane ai lugaut yu ebriwea wea yu wagbaut, ane ai go teke yu kambaigen po dis lan. Ai nogo libe yu antil ai bin pinis meke ebriting wanem ai bin spik ai go mekem po yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Den Zekop i bin gedap prom slip ane bin spik diskain po emselp, ‘Ei, mas bi da AntapGod i ya lo dis ples, ane ai no bin sabe diswan!’ ");
INSERT INTO tcs_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ane Zekop bin stat po prait nau ane em bin spik diskain po emselp, ‘Ei, ei! Wiskain ples diswan? Diswan mas aus blo God, ane diswan i da doa po go antap po eben.’ ");
INSERT INTO tcs_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Zekop i bin gedap prapa elimoning ane em bin teke da ston wea em bin mekem po pela blo em. Em bin teke da ston mekem stanap naiswei wase memorialston, ane em bin kapsaid oliboil antap lo da ston. ");
INSERT INTO tcs_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Zekop bin kole da ples Betel, wea i min ‘aus blo God’. Bipotaim, da smol biliz de longsaid i bin kolem Luz. ");
INSERT INTO tcs_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Den Zekop i bin meke dis strongpromis po God. Em spik diskain, ‘Ip God i go go wea mi ane lugaut mi lo dis rod wea ai wagbaut go, ane ip em go gibe mi kaikai ane klos po werem, ");
INSERT INTO tcs_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ane ip em go teke mi kambaigen po aus blo papa blo mi gudwan, den da AntapGod i gobi God blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Dis ston wea ai bin stanapem naiswei wase memorialston, i gobi ples po wosip God. Ai go gibem baigen po God wanten blo ebrisamting wea em gibem po mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Den Zekop i bin kip wagbaut go po istsaid po da lan wea ol kazen blo em i stap. ");
INSERT INTO tcs_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Wandei wen Zekop bin stil wagbaut, em bin luk wan wel lo bus, ane tri grup blo ol sip leidaun klostu po da wel. I bin prom dat wel dem sip i bin dringk wata. Da ston wea i bin kabare da wel i bin bigwan, ");
INSERT INTO tcs_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ane wen ebridem sip bin kam klostu da wel, dem man uda lugaut dem sip role da ston go wansaid, ane gibe wata po dem sip po dringk. Den apta, dempla kabare da wel gen wea da ston. ");
INSERT INTO tcs_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Den Zekop i spik diskain po dem man uda lugaut dem sip, ‘Ei bala. Wea yupla kam prom?’ Dempla ansa, ‘Mipla kam prom Aran.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Den Zekop i bin ask, ‘Yupla sabe Laban? Ate blo em i Nao.’ Dempla i ansa, ‘Wa, mipla sabe em.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Zekop i bin aske dempla gen, ‘Laban, em i orait a?’ Dempla bin ansa gobaigen, ‘Wa! Em prapa elti ane em prapa risman tu. Luk gel blo em, Reisel ya kam lo dem sip.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Zekop i bin tok gen ane spik, ‘Lisen ya, i stil melendei, da san i stil antap. I tu eli po teke dem sip kam insaid. Aukam yupla no gibe wata po dem sip, ane teke dempla wagbaut go ausaid po kaikai gen?’ ");
INSERT INTO tcs_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bat dempla i ansa po em, ‘Mipla kan gibe dem sip wata antil ebri sip ane man i ya, solong dem man ken puse da ston go wansaid prom da wel, den mipla i go gibe wata po dem sip.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Zekop i bin stil tok po dem man uda lugaut dem sip wen Reisel i bin kam lo dem nada sip blo papa blo em. Em oman uda lugaut dem sip blo papa blo em tu. ");
INSERT INTO tcs_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Reisel i bin kazensisi blo Zekop, ane gel blo Laban uda i bala blo mama blo em, Ribeka. Bikoz dem sip i blo dem awa blo em, Laban, Zekop i bin lego go puse da ston wansaid prom da wel ane gibe wata po dem sip blo awa blo em. ");
INSERT INTO tcs_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Wen Zekop bin pinis gibe wata po dem sip, em bin go ane kise Reisel, ane em bin nadakain api em bin base mina bigkrai po Reisel. ");
INSERT INTO tcs_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ane Zekop i bin yan po Reisel ane spik em pamle blo papa blo em, ane em bin boi blo Ribeka. Den Reisel bin ran go ane bin spik po Laban, papa blo em. ");
INSERT INTO tcs_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Wen Laban bin lisen niuz baut Zekop boi blo Ribeka, sisi blo em, em bin ran go po luk em. Em bin gasu em ane kise em, ane em bin teke em go po aus blo em. Zekop bin yan lo Laban ebriting wanem i bin apen, ");
INSERT INTO tcs_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ane Laban i bin spik diskain po em, ‘Mina tru. Yumi kam prom seim bladpamle!’ Apta wan mant wen Zekop i bin stap lo awa blo em, ");
INSERT INTO tcs_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laban i spik po Zekop, ‘Nomata yu pamle blo mi, yu mas gede mani po dem wok wea yu mekem po mi. Yu spik mi, aumas yu wande mi po pei yu?’ ");
INSERT INTO tcs_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban i bin gad tu gel. Neim blo da biggel i Lia, ane neim blo da smolgel i Reisel. ");
INSERT INTO tcs_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Dem ai blo Lia bin mina nais bat Reisel, em da gudluking gel. Em gad prapa nais pes ane bodi. ");
INSERT INTO tcs_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Zekop i bin labe Reisel. So em spik po Laban diskain, ‘Ai go wok po yu po seben iya ip yu go laue mi po kam man blo da yang gel blo yu Reisel.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban i bin ansa po Zekop diskain, ‘A wa, ai gri. Diswan i go meke mi nadakain api. Yu da rait man po em. Stap ya lo mi ane wok po mi po seben iya.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Zekop i bin wok po seben iya solong em go kam man blo Reisel. Dem seben iya i bin plai prapa kuikwan, wase mina sottaim bikoz Zekop bin mina lab Reisel. ");
INSERT INTO tcs_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Den Zekop bin tok diskain po Laban, ‘Dem seben iya ai bin wok po yu i pinis nau. Gibe Reisel nau po mi solong ai go maret em.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Den Laban i bin singaut ebri pipol blo dat ples wea em stap po kam tugeda, ane em bin meke big kaikai po weding blo Reisel ane Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Bat wen i bin naittaim nau, prapa dak, Laban i bin teke biggel blo em Lia ane i bin gibem po Zekop po kam oman blo em, ane Zekop i bin slip lo em. ");
INSERT INTO tcs_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ane wea dat seim nait, Laban bin gibe wan sebant oman blo em, Zilpa po Lia po kam sebant oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Wen i bin moningtaim nau, Zekop i paindaut em bin slip lo Lia, i no bin Reisel! Wa, Zekop i bin nadakain wail ane em bin go ane tok wailwan po Laban diskain, ‘Ei! Aukam yu bin meke disting po mi a? Ai bin wok po yu po kam man blo Reisel. Wanem po yu bin mekpul mi diskain?’ ");
INSERT INTO tcs_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ansa po em, ‘No, i pasin blo mipla ya po da bigsisi go maret pas, den da smolsisi. ");
INSERT INTO tcs_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Weitpas. Mata go tru dis seben dei weding kaikai blo yu ane Lia, den yu go kam man blo da smolsisi. Bat bipo mipla i go gibwei em, yu mas gri po wok po mi po nada seben iya.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Zekop i bin meke diswan, ane em ane Lia i bin meke da weding kaikai po seben dei. Wen dem seben dei i bin pinis Laban bin gibe em Reisel po bi oman blo Zekop tu. ");
INSERT INTO tcs_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laban bin gibe wan sebant oman blo em, Bila po Reisel po kam sebant oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Wa, Zekop bin slip lo Reisel tu, ane em bin mina labe Reisel prapa moden em bin labe Lia. Den Zekop i bin stap de wok po Laban po nada seben iya. ");
INSERT INTO tcs_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Wen da AntapGod bin luk dat Zekop bin mina labe Reisel mo wiskain em bin labe Lia, da AntapGod bin laue Lia po gad pikinini, bat Reisel i kan bone eni pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lia i bin kam pamle ane bin bone wan boi pikinini, ane em bin kolem Ruben. Lia bin tok diskain, ‘Da AntapGod bin luk ai mata gad trabol, mait man blo mi go labe mi nau.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lia bin kam pamle gen ane bin bone nada boi pikinini, ane em bin kolem Simion. Em bin spik diskain, ‘Da AntapGod bin lisen man blo mi i stil no labe mi. Em bin gibe mi dis boi pikinini tu.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Den Lia i bin kam pamle gen ane em bin bone nada boi pikinini, ane em bin kolem Libai. Em bin spik diskain, ‘I mas nau diskaintaim man blo mi i go stat po tingbaut mi, bikoz ai bin gibe em tri boi pikinini.’ ");
INSERT INTO tcs_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lia i bin kam pamle gen ane bin bone nada boi pikinini, ane em bin kolem Zuda. Em bin spik diskain, ‘Diskaintaim ai prapa eso da AntapGod.’ Den apta dem po boi pikinini, em no bin bone mo pikinini po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Wen Reisel i bin sabe em kan bone pikinini po Zekop, em prapa zeles po bigsisi blo em, ane em bin spik diskain po Zekop, ‘Meke mi gad ol pikinini, bambai ai go ded!’ ");
INSERT INTO tcs_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Den Zekop i bin kam nadakain wail po Reisel ane em bin spik diskain po em, ‘Oman! Ai no God! Em da wan uda bin stape yu prom nogad pikinini.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Den Reisel i bin spik po Zekop, ‘Ya! Diswan i oman sebant blo mi Bila. Slip lo em solong ai go gad pikinini prom em.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Den Reisel i bin gibe sebant oman blo em Bila po Zekop po kam nada oman blo em ane Zekop bin slip lo em. ");
INSERT INTO tcs_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Den Bila i bin kam pamle ane em bin bone wan boi pikinini po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Reisel bin kolem Dan. Den Reisel i bin spik diskain, ‘God bin luk dat ai bin rait, ane em bin mina lisen po mi ane bin gibe mi wan boi pikinini po Zekop.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Den Bila i bin kam pamle gen, ane em bin bone nada boi pikinini po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Reisel i bin kolem Naptali. Ane Reisel i bin spik diskain, ‘Ai bin big rau wea sisi blo mi po longtaim, bat ai bin win.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Wen Lia i bin sabe em kan bone mo pikinini po Zekop, em bin teke Zilpa, sebant oman blo em ane em bin gibem po Zekop po kam nada oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Zilpa i bin bone wan boi pikinini po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lia i bin kolem Gad. Lia i bin spik diskain, ‘Ei! Samting gud i go apen po mi!’ ");
INSERT INTO tcs_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Den Zilpa i bin bone nada boi pikinini po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ane Lia i bin kolem Asa. Lia i bin spik diskain, ‘Wa. Ai nadakain glad! Ebri oman i go spik diskain, ai nadakain glad oman.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Wandei wen i bin taim po kate ol gadan kaikai blo wit, Ruben boi blo Lia, i bin go ane bin paine sam busmersin de ausaid prom da gadan. Ol i kolem mandreik. Ruben i bin tekem kam po mama blo em. Den Reisel i bin spik po Lia, ‘Yagar. Ken yu gibe mi dem busmersin blo boi blo yu gar?’ ");
INSERT INTO tcs_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Bat Lia ansa po em diskain, ‘Yu prapa stronged! Yu bin pinis teke man blo mi! Bat nau yu wande teke ol busmersin blo boi blo mi tu a?’ Reisel i bin ansa gobaik po Lia, ‘Orait! Yu ken slip lo em tunait solong yu gibe mi dem busmersin.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Wen i bin naittaim, Zekop i bin kam prom wok wea gadan blo dem wit. Lia bin go po mite em, ane spik diskain po em, ‘Tunait yu go slip lo mi. Ai bin pei Reisel wea dem busmersin blo boi blo mi.’ So em bin slip wea Lia dat seim nait. ");
INSERT INTO tcs_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","God bin lisen po prea blo Lia, ane em bin kam pamle ane bin bone namba paib boi pikinini po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Lia i bin kolem Isaka. Lia bin spik diskain, ‘God bin gibe mi pei blo mi bikoz ai bin gibe sebant oman blo mi po man blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Den Lia i bin kam pamle gen, ane em bin bone namba siks boi pikinini po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Lia i bin kolem Zebulun. Den Lia i bin spik diskain, ‘God bin gibe mi wan gud riwod. Distaim man blo mi i go rispekt mi bikoz ai bin bone siks boi pikinini po em.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Den apta, Lia bin bone wan gel pikinini, ane em bin kolem Daina. ");
INSERT INTO tcs_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Den God i bin tingbaut po Reisel. God bin lisen prea blo em ane bin laue em po gad pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Reisel i bin kam pamle ane bin bone wan boi pikinini, ane em bin spik diskain, ‘God i bin tekemaute sem blo mi lo dis boi pikinini wea ai bin bonem.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Reisel i bin kolem Zosep, ane em bin spik diskain, ‘Ai aske da AntapGod, plizgar po gibe mi nada boi pikinini.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Apta nau, wen Reisel bin bone Zosep, Zekop bin spik diskain po Laban, ‘Laue mi po go, solong ai ken gobaigen po aus blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Laue mi po teke ol oman ane pikinini blo mi wea ai bin gedem prom wen ai bin wok po yu, ane ai go gowei. Yu prapa sabe wiskain ai bin wok po yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Bat Laban i bin spik diskain po em, ‘Ip yu nadakain api wea laip blo mi, mata stap ya. Ai bin yuze mazik ane ai bin paindaut God i bin blese mi bikoz yu stap ya lo mi. ");
INSERT INTO tcs_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kolem aumas yu wande mi po pei yu. Wanem yu kole da prais, ai go pei yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Zekop bin ansa gobaigen po Laban, ‘Yu prapa sabe wiskain ai bin wok po yu, ane wiskain buluk, sip, gout, ane ol kamal blo yu bin kam plenti wen ai bin lugaut dempla. ");
INSERT INTO tcs_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Yu bin gad ol lelbet animal wen ai bin pas kam ya, ane nau yu gad prapa plenti animal ane da AntapGod i bin blese yu lo ebriting wanem ai mekem. Bat diskaintaim nau, i taim po mi po stat lugaut ol pamle blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laban i bin spik diskain, ‘Wiskain yu wande mi po pei yu?’ Zekop ansarem, ‘Yu no nid po pei mi enisamting. Ip yu mata meke wan ting po mi, ai go lugaut gen ol sip ane ol gout blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Distaim laue mi gar, po go melen ebridem animal blo yu ane tekemaute ebri sip wea i gad smol spotspot ane dotdot, ane ebri blaiksip. Ane laue mi gar tu, po tekemaute ebridem blaik kala gout wea i gad wait smol spotspot ane dotdot. Prom demwan ya i gobi pei blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Apta nau yu go kam ane yu go paindaut ip ai bin mekem stret po yu, wen yu go luk dem animal. Demwan ol pei blo mi. Ip yu go paine eni blaik kala gout wea i nogad smol spotspot ane dotdot o eni wait sip wea i nogad ol spotspot ane dotdot, ip ai go gad, den yu go sabe ai bin stilem prom yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban i bin ansarem, ‘A wa. Yu luk de.’ ");
INSERT INTO tcs_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Bat seimdei Laban bin tekemaute ebri mangout wea i gad straipstraip, spotspot ane dotdot, ane ebri omangout wea i gad smol spotspot ane dotdot, ane em bin tekemaute ebri blaik kala sip. Den Laban bin teke ebridem animal ane em bin gibem po ol boi blo em po lugaut. ");
INSERT INTO tcs_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Den ol boi blo em bin mub go longwei prom Zekop go po wan ples wea i teke tri dei po kesem de. Bat Zekop i bin stap de ane lugaut ebridem nada sip ane gout blo Laban. ");
INSERT INTO tcs_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Den Zekop bin katemdaun ol pres brans blo popalatri, amantri, ane ol pleintri. Den em bin tekemaute bakstrip prom dem brans solong i gad ol wait straip. ");
INSERT INTO tcs_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Zekop i bin pute dem waitstrip brans longsaid wea dem wata konteina, solong dem animal go luk dem brans wen ol i go kam po dringk wata, bikoz dem sip ane gout i brid wail dempla kam de po dringk. ");
INSERT INTO tcs_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Dem sip ane gout bin brid prant lo dem straip brans, ane wen dem sip ane gout i bin gad ol beibi dempla i bin kamaut gad straipstraip, smol spotspot, ane dotdot. ");
INSERT INTO tcs_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Zekop i bin teke dem beibi prom dem animal blo Laban ane em bin pute dempla go wansaid. Wen em i bin kam taim po brid, Zekop bin gede dem wait oman animal po kaikai solong ol ken luk dem man animal wea i gad ol dem straipstraip ane blaik kala. Prom demkainwei, Zekop bin meke dem namba blo dem animal blo em kam mo plenti. ");
INSERT INTO tcs_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ebritaim wen dem strong sip ane gout i brid, Zekop i pute dem pres brans longsaid dem wata konteina solong dempla ken brid wen ol luk dem pres brans. ");
INSERT INTO tcs_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Bat dem sip ane gout wea i no strong, Zekop no bin pute dem pres brans prant wea dempla. Wa! Dem sip ane gout wea i no strong, i bin blo Laban ane dem strong sip ane gout i bin blo Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Zekop i bin kam prapa risman. Em bin gad ol mina plenti ol sip ane gout, ane em bin gad ol prapa plenti sebant, kamal ane dongki tu. ");
INSERT INTO tcs_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Wandei Zekop bin paindaut dem boi blo Laban i bin spik diskain, ‘Zekop i bin teke ebriting wea i bin blo papa blo yumpla. Em risman. Ebrisamting wea em gad i blo papa blo yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ane Zekop bin tekenotis Laban nomo meke naiswei po em wiskain em bin mekem pas wen Zekop bin pas kam de. ");
INSERT INTO tcs_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Den da AntapGod bin spik diskain po Zekop, ‘Gobaigen po da ples blo papa ane ol pipol ane ol kazenpamle blo yu, ane ai gobi lo yu ane elpe yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Den Zekop i bin sane mesiz po Reisel ane Lia po kam wea da ples wea ol animal blo em, ");
INSERT INTO tcs_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","ane den em spik diskain po demtu, ‘Ai tekenotis papa blo yutu, em i nomo meke gudpasin po mi wiskain em bin pas mekem. Bat da God blo ate blo mi, Eibram, em i elpe mi. ");
INSERT INTO tcs_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Yutu sabe ai bin wok po papa blo yutu lo ebri strong blo mi, ");
INSERT INTO tcs_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","bat papa blo yutu bin geman mi ane bin seinze pei blo mi tentaim. Ane God no bin laue em po meke badsamting po mi. ");
INSERT INTO tcs_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ip papa blo yutu bin spik, “Dem smol spotspot animal i gobi pei blo yu”, den i bin apen. Ebri animal wea i kamaut go gad ol smol spotspot. Bat den papa blo yu i bin seinze main ane spik diskain, “Dem straipi animal i gobi pei blo yu”, den i bin apen. Ebri animal wea i kamaut ol i bin gad ol straip.’ ");
INSERT INTO tcs_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Wa, i tru. God bin tekemaute dem animal blo papa blo yu, ane bin gibem po mi ane nau ai bin kam prapa risman. ");
INSERT INTO tcs_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","‘Lo da briding taim blo dem animal, ai bin gad wan drim wea ai bin luk dem mangout wea i bin brid lo dem omangout wea i gad dem smol spotspot, straipi, ane dotdot wan. ");
INSERT INTO tcs_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Den da einzel blo God i bin spik diskain po mi insaid lo da drim, “Zekop”, ane ai bin ansa em, “Wiswei? Mi ya.” ");
INSERT INTO tcs_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","‘Ane em bin spik, “Yu luk gen ane luk mata dem mangout wea i brid lo dem nada animal. Dempla i smol spotspot, straipi, ane dotdot wan, bikoz ai bin luk ebriting wanem Laban i bin mekem po yu. ");
INSERT INTO tcs_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ai da seim God uda bin soe maiselp po yu lo Betel wea yu bin meke dat ston stanap ane yu bin kapsaid oliboil antap dat ston ane yu bin meke wan tru promis po mi. Wa. Diskaintaim libe dis ples biain ane gobaigen po da ples wea yu bin bon.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Den Reisel ane Lia i bin ansa po Zekop, ‘Orait. Mitu pinis sabe mitu nogo gede eniting prom papa blo mitu. ");
INSERT INTO tcs_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Em prapa trite mitu wase ol ausaid pipol. Em bin sele mitu po yu, den em bin weiste ebridem mani yu bin pei em po mitu. ");
INSERT INTO tcs_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ebri sip ane gout wea God i bin tekemaut em prom papa blo mitu i blo mitu ane blo ol pikinini blo mitu tu. Wa. Diskaintaim mekem wanem God i bin spik po yu po mekem.’ ");
INSERT INTO tcs_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Den Zekop i bin meke redi po lego go, ane em bin pute ol pikinini ane ol oman blo em antap wea ol kamal. ");
INSERT INTO tcs_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Ane Zekop i bin meke ol animal blo em wagbaut po go pas. Ane em bin paikap ebriting blo em wea em bin gedem prom kantri blo Mesapotamia. Em bin lego gobaigen po papa blo em Aizak, wea lan blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Wea dat seimtaim nau Laban bin lego go longwei prom de, po go kate eya blo ol sip blo em. Reisel i bin stile laigod kabing blo papa blo em wea em i wosip demting. ");
INSERT INTO tcs_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ane Zekop i bin trike Laban, da man prom Aram. Zekop i no bin spik Laban em go go ane em bin sikretwan gowei prom de. ");
INSERT INTO tcs_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Wa, den Zekop bin tekop go prapa kuikwan ane kuaiatwan lo ebrisamting em bin gad. Pas em bin krose da Yupreitis Riba, ane em bin go po da ilkantri blo Giliad. ");
INSERT INTO tcs_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Lo namba tri dei apta dempla bin go, wan man i bin spik po Laban, Zekop i bin ranwei kuaiatwan. ");
INSERT INTO tcs_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Den, Laban bin teke ol kazenbala blo em po go wea em ane bin tekop prapa kuikwan apte Zekop go biain po seben dei, antil dempla kam klostu po Zekop lo da ilkantri blo Giliad. ");
INSERT INTO tcs_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Bat God bin soe emselp po Laban lo wan drim dat nait, ane bin spik po em, ‘Lugaut nau! No spik nugudwei po Zekop.’ ");
INSERT INTO tcs_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Wen Laban i bin kesem de wea Zekop, Zekop bin pinis sete tent blo em wea wan maunten. Laban ane ol kazen blo em i bin sete ol tent lo da ilkantri blo Giliad tu. ");
INSERT INTO tcs_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban i spik po Zekop, ‘Ei! Yu bin meke rongting. Yu bin trike mi ane ranwei kuaiatwan. Yu bin teke ol gel blo mi wase prizina. ");
INSERT INTO tcs_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Aukam yu bin ranwei kuaiatwan ane yu bin trike mi ane no bin spik mi? Ai bin wande meke sendop kaikai po yu lo gladat ane big sing, paite ol smol warup ane ol ap. ");
INSERT INTO tcs_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Aukam yu no bin laue mi po kise tu gel blo mi ane ol ngep blo mi po yawo dempla? Diswan i bin prapa nugudpasin yu bin mekem! ");
INSERT INTO tcs_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ai ken meke nugudting po yupla, bat God blo papa blo yu i bin spik po mi lasnait, “Lugaut. No spik nugudwei po Zekop.” ");
INSERT INTO tcs_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ai sabe yu bin wande go bikoz yu bin prapa wande gobaigen po aus blo papa blo yu. Bat aukam yu bin stile ol dem kabing blo ol laigod blo mi, demting wea ai wosip?’ ");
INSERT INTO tcs_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Zekop i ansa po Laban, ‘Bikoz ai bin prait, ai bin tingk diskain, yu go tekemaute demtu gel blo yu rapwei prom mi. ");
INSERT INTO tcs_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Bat ip yu go paine enibodi ya uda gad dem samting blo yu wea yu wosip demting, dat man i go ded. Ya prant lo ol kazen blo yumi, ip yu paine eniting wea i blo yu, tekem.’ Bat Zekop i no bin sabe diskain Reisel i bin stile dem samting blo papa blo em. ");
INSERT INTO tcs_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laban i bin go lego go ane stat lukraun lo tent blo Zekop, tent blo Lia, ane da tent blo demtu sleib oman, bat em no bin paine dem laigod kabing blo em. Ane den Laban i bin go ausaid prom tent blo Lia, ane go insaid tent blo Reisel. ");
INSERT INTO tcs_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Reisel bin teke dem samting blo papa blo em ane em bin aide demting insaid wan pokit blo sadol blo kamal blo em. Ane Reisel bin sidaun antap lo sadol. Laban bin lukraun ebriwea insaid lo tent, bat em no bin paine dem laigod samting blo em. ");
INSERT INTO tcs_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ane Reisel spik po papa blo em, ‘Papa. No wail po mi gar bikoz ai kan stanap prant wea yu. Ai gad mantli blo mi.’ Wa. Laban bin prapa lukraun, bat kan paine dem laigod samting blo em. ");
INSERT INTO tcs_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Den Zekop i bin kam prapa wail, ane bin bleime Laban. Zekop spik po Laban, ‘Wanem rong ai bin mekem? Wanem nugudting ai bin mekem po yu, po meke yu kam apte mi wase ai bin stila? ");
INSERT INTO tcs_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Yu bin lukraun ebriwea lo ebrisamting blo mi. Eni samting yu bin painem wea i blo aus blo yu a? Pute dem samting wea ai bin stilem prom yu ya prant wea ol pipol blo yumi, ane laue dempla po meke main blo dempla, uda i rait ane uda i rong prom yumi. ");
INSERT INTO tcs_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","‘Ai bin wok lo yu po tuenti iya. Ol beibi blo ol yang omansip ane gout blo yu no bin bon dedwan. Ai no bin kaikai eni man animal prom dem sip ane gout blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Dem animal wea i bin ded prom wailanimal, ai no bin tekem kam po yu po prubem ol nada animal bin kile demwan. Ai bin peibaik maiselp po demwan. Ebritaim wen sambodi i bin stile wan sip o gout blo yu, yu bin oda mi po gibe wan po yu, bikoz yu spik diswan i polt blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","‘Ai bin wok po yu lo deitaim. Ot blo da san i prapa bane mi, ane kol blo naittaim, ai kan slip prapa. ");
INSERT INTO tcs_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","I bin wase demkain po dem long tuenti iya ai bin wea yu. Ai bin wok po yu po potin iya solong ai ken maret tu gel blo yu, ane nada siks iya mo ai bin lugaut ol sip ane gout blo yu. Ane dem taim yu bin prapa seinze ol pei blo mi tentaim. ");
INSERT INTO tcs_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ip God blo mi, da seim God blo ate Eibram ane papa blo mi Aizak no bin elpe mi, den nau, diskaintaim, yu bin pinis sanewei mi nogad nating. Bat God i bin luk ol dis trabol yu bin mekem po mi ane em i bin luk dat adwok ai bin mekem. Daswai lasnait God i bin tok po yu ane soe yu dem rongting wea yu bin mekem.’ ");
INSERT INTO tcs_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Den Laban bin ansa po Zekop diskain, ‘Dem oman ya, demwan ol gel blo mi. Dem pikinini blo demtu i ol ngep blo mi. Ol dem animal ya ane ebriting yu gad, yu bin gedem prom mi. So wiswei? Ai kan meke enisamting po dem gel blo mi o dem pikinini wea demtu bin bonem. ");
INSERT INTO tcs_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kam gar, yumi go meke strongpromis, yu ane mi, ane laue dis strongpromis po bi witnis melen lo yu ane mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Zekop i bin teke wan ston, ane bin meke da ston stanap naiswei wase memorial. ");
INSERT INTO tcs_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ane Zekop bin spik po ol kazenbala blo em, ‘Teke ol ston kam.’ Den dempla bin go teke ol ston kam, ane dempla bin meke big ip blo ston klostu po da wan ston blo Zekop. Zekop ane Laban ane ol kazenbala blo demtu bin kaikai tugeda lo da big ip blo dem ston. ");
INSERT INTO tcs_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban bin kole da ip blo ston Zegarsaiaduta. Wea langus blo dem Arameikpipol i min ‘Witnis Ip’. Ane Zekop bin kole da ip blo dem ston Galid. Wea langus blo dem Ibrupipol i min ‘Witnis Ip’. ");
INSERT INTO tcs_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laban i bin spik po Zekop, ‘Dis ip blo ston ya i witnis melen lo yu ane mi ya tidei.’ Daswai ol i bin kolem Galid. ");
INSERT INTO tcs_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ane ol i bin kole dat seim ples Mizpa. Wea Ibrulangus i min ‘Lugaut Ples’. Bikoz Laban i bin spik diskain, ‘Ai aske da AntapGod po lugaut yumi solong yumi go ebritaim pole dis strongpromis apta wen yumi go libe dis ples biain.’ ");
INSERT INTO tcs_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban i kip tok, ‘Ip yu go meke badpasin po dem gel blo mi, o ip yu maret nada oman, ai nogo sabe diswan. Bat tingbaut diswan ya, dat God em i witnis melen yu ane mi. ");
INSERT INTO tcs_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","‘Luk dem ston wea ai bin ipemap melen wea yumi, ane luk dat nada ston i stanap ya. ");
INSERT INTO tcs_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Dem ston ya i witnis ai nogo pase dis tu stonmak go po meke ol nugudting po yu, ane yu no go pase dis tu stonmak tu po kam po mi po meke ol nugudting po mi. ");
INSERT INTO tcs_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ai aske God blo dem pamlelain blo yumi, God blo ate Eibram blo yu ane God blo ate Nao blo mi. Ai askem dat God gobi zaz melen yumi.’ So Zekop i bin meke strongpromis wea neim blo God blo papa blo em Aizak, dat em go pole dat strongpromis. ");
INSERT INTO tcs_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Ane Zekop bin kile wan animal ane banem antap lo olta po wosip God lo dat maunten. Apta, Zekop bin singaut ebriwan po kam po da strongpromis kaikai. Zekop ane dempla bin kaikai ane apta dempla bin kaikai, dempla bin slip dat nait wea dat maunten. ");
INSERT INTO tcs_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Elimoning da neksdei, Laban i bin gedap prom slip ane em bin kise dem gel blo em ane ngep blo em. Em bin blese dempla. Den em bin yawo dempla ane em bin lego gobaigen po ples blo em. ");
INSERT INTO tcs_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Wandei, wen Zekop bin lego gobaigen po Kanan, ol einzel blo God i bin kam po mite em. ");
INSERT INTO tcs_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Wen Zekop bin luk dem einzel, em bin spik, ‘Diswan wea God i kempaut!’ Zekop bin kole dat ples Maganaim, wea Ibrulangus i min ‘ples blo kemp’. ");
INSERT INTO tcs_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Zekop i bin sane ol man po teke mesiz go pas po bala blo em Iso, wea da lan blo Ser, lo dat kantri blo Edom. ");
INSERT INTO tcs_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Zekop i bin prapa spik po dem mesizman, ‘Diswan i wanem yupla mas spik po Iso, bos blo mi, “Sebant blo yu Zekop i spik diskain, ‘Ai bin stap longtaim lo awa Laban ane ai bin stap de antil distaim nau. ");
INSERT INTO tcs_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ai gad buluk, kau, dongki, sip, gout ane ol man ane oman sebant. Diskaintaim ai sane dis mesiz po yu gar, bos blo mi, solong yu gobi nadakain api wen yu go luk mi.’” ’ ");
INSERT INTO tcs_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Wen dem mesizman i bin kambaigen po Zekop, dempla spik, ‘Mipla bin go po bala blo yu, Iso, ane em ya kam diskaintaim po mite yu, ane em gad 400 amiman wea em.’ ");
INSERT INTO tcs_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Wen Zekop bin lisen dis niuz, em bin wantaim prapa prait ane mina wori. Den em bin splitemap ol dem ebriting em bin gad po meke tu big mob. Ap blo dem pamle go diswei go po wansaid, den nada ap go nadasaid, den dem sip, gout, ol dem buluk, kau ane ol dem kamal go wansaid ane dem nadawan go nadasaid. ");
INSERT INTO tcs_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Em bin tingk po emselp diskain, ‘Ip Iso go kam po wanmob ane kile ebriwan, den da nadamob ken ranwei.’ ");
INSERT INTO tcs_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Den Zekop i bin prea, ‘God blo ate blo mi Eibram ane God blo papa blo mi Aizak. AntapGod, yu bin spik po mi, “Gobaigen po kantri blo yu ane po ol kazenbala blo yu, ane ai go meke ebriting orait.” ");
INSERT INTO tcs_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ai prapa nugudman bat yu bin soe mi lab blo yu, ane gudpasin blo yu po mi, sebant blo yu. Ai bin krose dis Zodan Riba mata wea wan wokingstik, ane nau ai bin kambaigen wea wan big pamle ane plenti animal ane dempla nap po meke tu big kemp. ");
INSERT INTO tcs_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Lugaut mi prom bala blo mi Iso, bikoz ai prapa prait prom em. Em mait kam ane kile mipla ebriwan, dem oman ane ol dem pikinini blo mi tu. ");
INSERT INTO tcs_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Bat yu bin spik wea promis de pas diskain, “Ai go prapa meke gudpasin po yu, ane meke pamlelain blo yu wase san lo sanbis, wea man i kan kauntem bikoz ol prapa plenti.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Wa. Zekop i bin slip de po wan nait bat neksdei, prom ebridem animal wea em bin gad, em bin suzem po gibe present po bala blo em Iso, ");
INSERT INTO tcs_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","200 omangout ane 20 mangout, 200 omansip ane 20 mansip, ");
INSERT INTO tcs_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","30 omankamal ane beibi blo dempla, 40 kau ane 10 buluk, 20 omandongki ane 10 mandongki. ");
INSERT INTO tcs_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Zekop bin splitemap dem animal go po ol dipren mob lo dempla ane em bin meke ol sebant blo em po lugaut dem animal. Zekop spik po dem sebant blo em diskain, ‘Yupla wagbaut prant lo mi, ane meke big speis bituin dem mob blo dem dipren animal.’ ");
INSERT INTO tcs_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Zekop i bin oda dem sebant uda go wagbaut rait prant diskain, ‘Wen Iso i mite yu, ane em aske yu, “Uda bos blo yu? Wea yupla go? Uda bos blo dem animal?” ");
INSERT INTO tcs_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Den yu go ansa gobaigen po em, “Dem animal ya i blo sebant blo yu Zekop. Dem animal ya i present po yu, Iso, bos blo em. Zekop ya kam biain lo mipla.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Zekop bin spik da seim oda po dem sebant blo dem sekan lot animal, ane po dem namba tri lot sebant ane po ebridem nadawan uda bin pole wea dem animal biain. Em bin spik diskain, ‘Diswan i wanem yu mas spik po Iso wen yu luk em, ");
INSERT INTO tcs_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","ane prapa spik diskain, “Sebant blo yu, Zekop, ya kam biain lo mipla.” ’ Zekop bin tingk diskain po emselp, ‘Diswan mait go elpe em po nomo wail po mi wea dem present wea ai bin sanem po em pas. Wen ai go luk em, mait em go meke mi bala blo em gen.’ ");
INSERT INTO tcs_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Wa, dem present blo dem animal prom Zekop i bin go pas, ane Zekop i bin gobaigen po da tent blo em po stap emselp po da nait lo dat ples. ");
INSERT INTO tcs_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Lo dat seim nait, Zekop i bin meke redi ane em bin sane Lia ane Reisel ane dem nada tu oman blo em ane leben pikinini blo em, ane dempla i bin krose da salo pat blo da Zabok Riba. ");
INSERT INTO tcs_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Seimkain, em bin sane ebrisamting wea i bin blo em go wea dempla tu. ");
INSERT INTO tcs_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Zekop no bin krosem go nadasaid lo da riba bat em bin stap emselp, ane wan man i bin kam po em ane bin stat po puse Zekop godaun po da graun. Dis pait melen da man ane Zekop i bin go raittru po deilait. ");
INSERT INTO tcs_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Wen da man i bin luk em i kan win po puse Zekop godaun po da graun, em bin ite Zekop lo ipbon, ane da ipbon blo em i bin kamaut prom zoint. Bat Zekop i bin stil trai po puse da man godaun po graun. ");
INSERT INTO tcs_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Den da man i bin spik, ‘Ei! Laue mi po go, i stat po deilait nau.’ Bat Zekop ansa po em, ‘Nono! Ai nogo laue yu po go antil yu go blese mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Da man i bin aske Zekop, ‘Wanem neim blo yu?’ Em ansa, ‘Mi Zekop.’ ");
INSERT INTO tcs_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Den da man i tok gen, ‘I go nomo go kole yu Zekop, bat nau i go kole yu Izrael, bikoz yu bin pait wea God ane lo dem pipol, ane yu bin win.’ Wea Ibrulangus, Izrael i min ‘pait gense God o God i pait’. ");
INSERT INTO tcs_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Den Zekop i bin aske da man, ‘Spik mi neim blo yu.’ Bat da man i bin ansabaik, ‘Aukam yu wande sabe neim blo mi?’ Ane da man i bin blese Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Zekop i bin kole da ples Peniel. Wea Ibrulangus i min ‘pes blo God’. Em bin spik diskain, ‘Ai bin luk God prapa klostuwan, ane ai stil laipwan. God no bin kile mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Da san bin kam antap nau wen Zekop libe Peniel ane em bin wagbaut kripolwan bikoz prom ipbon blo em. ");
INSERT INTO tcs_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ane daswai tidei dem pamlelain blo Izrael no kaikai da mit blo animal prom da ipbon, bikoz i bin lo dis pat blo mit wea dat man i bin ite Zekop wea da ipbon. ");
INSERT INTO tcs_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Wen em bin liptemap ed, Zekop i bin luk go longwei ane bin luk Iso ya kam. Em i bin gad 400 man lo em. So Zekop i bin pute ol pikinini blo em go po ol dempla oun mama. Sam bin go wea Lia, ane wea Reisel, ane sam bin go wea demtu nada oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Em pute demtu nada oman blo em wea dempla pikinini wagbaut pas, den Lia wea em pikinini, ane Reisel ane Zosep prapa laswan. ");
INSERT INTO tcs_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Zekop emselp i bin wagbaut prapa prant prom dem pamle blo em, ane wen Zekop bin kam klostu po bala blo em, em bin nildaun pesdaun sebentaim prant wea Iso. ");
INSERT INTO tcs_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bat Iso bin mata ran go po mite Zekop, ane bin gasu em. Iso bin pute an blo em raun wea Zekop ane em bin kise em. Demtu bin bigkrai. ");
INSERT INTO tcs_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Wen Iso bin luk goraun, em bin luk ol oman ane pikinini. Em bin aske Zekop, ‘Uda dempla ya?’ Zekop i bin ansa em, ‘Dem pikinini ya, God uda gad gudpasin, i bin gibem po mi, sebant blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Den demtu nada oman blo Zekop i bin kam klostu. Demtu ane pikinini blo demtu, ane ol bin baudaun. ");
INSERT INTO tcs_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Seimkainwei Lia ane pikinini blo em bin kam klostu ane dempla bin baudaun. Ane laswan, Zosep ane Reisel bin kam klostu, ane demtu bin baudaun tu. ");
INSERT INTO tcs_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iso aske Zekop gen, ‘Ane wanem ol dem bigmob animal ai bin luk wen ai bin pas kam diswei ai bin luk?’ Zekop i bin ansa po em, ‘Dem animal i ol present po yu. Yu bos blo mi. Ai bin gibem solong yu gobi nadakain api po mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Bat Iso i spik, ‘Mai bala, ai pinis gad plenti animal. Yu mata kipem po yuselp.’ ");
INSERT INTO tcs_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Zekop i bin ansa, ‘Nono! Ip yu nadakain api po mi, den teke dem present ya prom mi. Wen ai bin luk pes blo yu i wase ai bin luk pes blo God, bikoz ai prapa api po luk yu. ");
INSERT INTO tcs_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Teke dem present wea ai bin tekem kam po yu, bikoz God em bin meke gudpasin po mi, ane em bin gibe mi plenti.’ Bikoz Zekop bin prapa spik em po teke dem animal, Iso i bin gri. ");
INSERT INTO tcs_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Den Iso bin spik, ‘Kam, yumi go lego nau, ane ai go go longsaid lo yu po soe yu da rod.’ ");
INSERT INTO tcs_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Bat Zekop i bin ansa, ‘Bos blo mi, dem pikinini no prapa strong po lego go wea da spid blo yu. Ai woribaut dem animal wea ol i lugaut smolbeibi. Ip ai go meke dempla po ariap, mait dempla ebriwan go lus. ");
INSERT INTO tcs_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Yu go pas ane ai go kam biain, ane ai go kam biain slowan. Ai go mekem stret po dem spid blo dem animal ane pikinini. Den ai go mite yu wea da lan blo Ser.’ ");
INSERT INTO tcs_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Iso i spik, ‘Laue mi gar po libe sam man blo mi wea yu, po lugaut yu ane po soe yu da rod.’ Bat Zekop i bin ansa, ‘No wori. Nap yu nadakain api po luk mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Den, Iso i bin lego go prom de da seimdei, gobaik po da lan blo Ser. ");
INSERT INTO tcs_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Bat Zekop i bin go po Sakot, wea em bin meke wan aus po emselp ane ol smolseid po ol dem animal blo em. Zekop bin kole dat ples Sakot, bikoz wea Ibrulangus i min ‘smol seid’. ");
INSERT INTO tcs_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Wen Zekop i bin kambaigen prom Mesapotamia, em bin kam seipwan de wea taun blo Sekem, lo lan blo Kanan ane em bin setemap ol tent blo em de ausaid prom dat taun. ");
INSERT INTO tcs_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Prom dem pamle blo Amo, papa blo Sekem, Zekop bin baie big eria blo lan po 100 pis silba. Zekop i bin pute ebri tent blo em de. ");
INSERT INTO tcs_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Zekop bin bilde wan olta po wosip da AntapGod ane em bin kole da olta Eleloui Izrael. Wea Ibrulangus i min ‘God, em i God blo Izrael’. ");
INSERT INTO tcs_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Wandei Daina, da gel blo Lia ane Zekop, i bin lego go ausaid po luk sam dem yang Kanan oman. ");
INSERT INTO tcs_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sekem bin boi blo Amo. Em blo dem pipol blo Ib ane Amo bin bos blo da eria. Wen Sekem bin luk Daina, Sekem bin rapwei grabem ane em bin nadakain pose Daina po slip lo em. ");
INSERT INTO tcs_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Bat den Sekem i bin gad nadakain strong piling po Daina, gel blo Zekop. Sekem bin prapa laik da yangoman, ane em bin tok naiswei po Daina po meke em laik po em. ");
INSERT INTO tcs_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Apta, Sekem bin spik po Amo, papa blo em diskain, ‘Go teke dis yangoman kam, em go kam oman blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Zekop i bin paindaut Sekem i bin meke prapa nugudting po gel blo em Daina. Seimtaim, ol boi blo Zekop i bin ausaid lo bus wea dem animal. So Zekop i bin meke nating antil dem boi blo em bin kambaik. ");
INSERT INTO tcs_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Amo, papa blo Sekem i bin kam ane tok wea Zekop, ");
INSERT INTO tcs_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","seimtaim nau wen dem boi blo Zekop bin kambaigen nau prom lugaut dem animal. Wen dempla bin lisen dis tok, dempla bin pil prapa sore ane nadakain wail bikoz Sekem bin meke dis nadakain nugudting po sisi blo dempla. Ane diswan i bin meke pamle blo Zekop prapa nadakain wail, bikoz diskainting i prapa no lau po mekem. ");
INSERT INTO tcs_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Bat Amo i bin spik po Zekop ane ol boi blo em diskain, ‘Boi blo mi Sekem, i prapa wande dis yangoman blo yupla. Gibe Daina solong em go kam oman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Laue ol boi ane ol gel blo yumpla po kam man ane oman blo wananada. Laue ol yangoman blo yupla po maret ol man blo mipla ane laue ol yangman blo yupla po kam man blo ol yangoman blo mipla. ");
INSERT INTO tcs_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Yupla go stap ya wea mipla, ane yupla ken stap eniwea wea yupla wandem. Meke aus blo yupla ya ane yumpla ken sele ol diprenting po wananada, ane yupla ken baie eni lan ya.’ ");
INSERT INTO tcs_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sekem tu i bin spik po papa blo Daina ane ol bala blo em diskain, ‘Ip yupla gri po dis tok blo mi, den wanem samting yupla wandem ai go gibem po yupla. ");
INSERT INTO tcs_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Yupla ken kole da prais po da oman ane prais blo dem present nadakain plenti wiskain yupla wandem. Eni samting wanem yupla askem, ai go pei em. Mata gibe mi da yangoman po kam oman blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Dem boi blo Zekop bin ansa Sekem ane papa blo em Amo lo gemanwei, bikoz em bin meke nugudting po Daina, sisi blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Dem boi blo Zekop bin spik po demtu, ‘Mipla kan meke diskainting, po gibe sisi blo mipla po da man uda no bin kate da poskin blo em, bikoz ol pipol i no go rispekt mipla. ");
INSERT INTO tcs_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Mata wan ting ya, bipo mipla go gibe sisi blo mipla po yu, solong yupla mas kam wase mipla, wea ebri man blo yupla mas kate poskin blo yupla. ");
INSERT INTO tcs_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ip yupla meke diswan, den apta, mipla go gibe ol yangoman blo mipla po kam oman blo yupla, ane mipla gobi ol man blo ol yangoman blo yupla. Mipla go stap wea yupla ane kamwan pipol. ");
INSERT INTO tcs_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Bat ip yupla no mekem wanem mipla spik ane no kate poskin blo yupla, den mipla go teke Daina ane go.’ ");
INSERT INTO tcs_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Dem tok blo dem boi blo Zekop i bin meke Amo ane Sekem gri po diswan. ");
INSERT INTO tcs_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ane da yangman no bin slo po meke da samting wanem dem boi blo Zekop bin askem po mekem, bikoz em bin prapa wande dat gel blo Zekop. Diskaintaim ol pamle blo papa blo em bin prapa rispekt Sekem. ");
INSERT INTO tcs_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Apta, Amo ane Sekem bin kam po geit blo da taun ane demtu bin tok po dem man blo da taun. ");
INSERT INTO tcs_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Dempla bin spik diskain, ‘Dem man ya i bin meke naiswei po yumpla. Laue dempla gar po stap ya lo dis ples ane yumpla ane dempla i ken sele ol diprenting po wananada, bikoz da lan i bigwan ane gad plenti rum, nap po dempla tu. Yumpla ken go ane teke ol yangoman blo dempla po kam oman blo yumpla, ane dempla ken teke ol yangoman blo yumpla po kam oman blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Mata dis wan ting ya wea dempla gri po stap ya wea yumpla po kamwan pipol. Ebri man ya blo yumpla mas kate poskin blo yumpla seimkain wiskain dempla man i mekem. ");
INSERT INTO tcs_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Bambai, ebridem animal blo dempla, ane ebridem nada samting wea i blo dempla i gobi blo yumpla. Mata kam. Yumpla go mekem wanem dempla wande yumpla po mekem solong dempla go stap ya wea yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Ane ebridem man i bin gri wea Amo ane Sekem, ane ebri man blo da taun i bin kate poskin blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Lo namba tri dei, wen dem man bin stil prapa soa prom kate poskin, tu boi blo Zekop, Simion ane Libai, demtu prapa bladbala blo Daina, demtu bin teke big sod blo demtu ane bin kam po dem man blo da taun wea dempla i kan pait. Ane demtu bin kile ebri man. ");
INSERT INTO tcs_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Demtu bin kile Amo ane Sekem wea big sod ane demtu bin teke Daina go ausaid prom aus blo Sekem, ane bin gobaigen po ol tent blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ebridem nada boi blo Zekop bin wagbaut melen pase dem ded bodi, ane dempla bin stile ol samting blo dem ded pipol blo da taun, bikoz dempla bin meke ol nugudting po sisi blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Dempla bin teke ol sip, gout, buluk ane kau, ane dongki, ane ebrisamting wea i insaid da taun ane lo dem big gadan eria blo da taun. ");
INSERT INTO tcs_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Dem boi blo Zekop bin tekem ane stile ebridem gudsamting ane ol demting prom dem aus, ane ol bin teke ebridem oman ane pikinini blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Den Zekop spik po Simion ane Libai, ‘Yutu bin meke mi gad nadakain nugudneim ane go gad big trabol. Diskaintaim dem pipol blo Kanan, Perez ane ebribodi ya lo dis lan i go eite mi. Yumpla prapa lelbet pipol, ane ip dempla go kam tugeda ane paite yumpla, mi ane ol pamle blo mi i go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bat demtu i bin ansa, ‘Wiswei? Mitu kan laue dat man po trite sisi blo mipla wase em oman uda slip wea olkain man po mani.’ ");
INSERT INTO tcs_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Den God i bin spik po Zekop, ‘Yupla meke redi nau ane lego go po Betel, ane mata stap de. Meke wan olta de po mata wosip mi, da God uda bin soe emselp po yu wen yu bin ranwei prom bala blo yu Iso.’ ");
INSERT INTO tcs_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","So Zekop i bin spik po pamle blo em ane po ebriwan uda bin de lo em diskain, ‘Smase dem laigod wea yupla wosip, wea yupla bin tekem kam prom ol nada ples. Meke laip blo yupla stret po wosip God, ane were ol klin klos. ");
INSERT INTO tcs_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Den kuikwan meke redi. Kam, yumpla go go po Betel, solong ai go meke wan olta po wosip da God uda bin elpe mi wen ai bin prea ane wen ai bin gad trabol. Em bin lo mi ebriwea wea ai bin wagbaut.’ ");
INSERT INTO tcs_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Apta nau, dempla bin gibe Zekop ebridem laigod wea dempla bin wosip em, ane dem yaring blo dempla. Zekop bin teke ebridem samting ane em bin berem andanit da prapa big tri de klostu po taun blo Sekem. ");
INSERT INTO tcs_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Wen Zekop ane ebribodi wea em i bin meke redi po go, God i bin meke ebridem pipol blo ol dem taun de raun nadakain prait, solong dempla no bin kam apte dem pamle blo Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Zekop ane ebri pipol blo em bin kam po Luz wea ol pipol i nau kolem Betel. Diswan i wea lan blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Zekop i bin bilde olta de ane em bin kole da ples Elbetel, wea Ibrulangus i min ‘God blo Betel’. Bikoz i bin de God bin soe emselp po Zekop wen em bin ranwei prom bala blo em. ");
INSERT INTO tcs_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Apta dempla bin bilde da olta, Debora, da oman uda bin lugaut Ribeka prom wen em bin smolbeibi, i bin lus. Dempla bin berem de andanit wea wan prapa big tri wea da bali ausaid prom Betel. Wa, i bin kolem Alonbakut, wea Ibrulangus i min ‘prapa big tri blo krai’. ");
INSERT INTO tcs_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","God i bin soe emselp gen po Zekop. Wa, diswan i bin apta wen em bin kambaigen prom kantri blo Mesapotamia, ane God i bin blese Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","God bin spik diskain po Zekop, ‘Neim blo yu i Zekop. Bat nomo gen ai go kole yu Zekop. Prom distaim nau Izrael i gobi neim blo yu.’ I bin prom de nau God i bin kolem Izrael. ");
INSERT INTO tcs_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","God i bin spik po em, ‘Ai da Strong AntapGod. Yu go kam plenti ane yu go gad plenti pikinini. Ane yu gobi pipol uda stap wea dempla oun kantri ane prapa plenti pipol i go kamaut prom yu. Sam prom pamlelain blo yu i gobi ol king. ");
INSERT INTO tcs_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Da lan wea ai bin gibem po ate blo yu Eibram ane papa blo yu Aizak, ai go gibem po yu, ane ai go gibe da lan po ol pamlelain blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Den God bin go, libe Zekop lo da ples wea God bin tok po em. ");
INSERT INTO tcs_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Zekop bin meke wan ston stanap naiswei wase memorial ston wea da ples wea God i bin tok po em. Em bin kapsaid opring blo wain po God antap da ston, ane em bin kapsaid oliboil antap da ston po meke da ston wan spesil ples po wosip God. ");
INSERT INTO tcs_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Wa, Zekop bin kole da ples Betel, wea God i bin tok wea em. Wea Ibrulangus i min ‘aus blo God’. ");
INSERT INTO tcs_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Apta nau, Zekop ane ol pipol blo em i bin libe Betel biain, ane dempla bin lego go po Eprat. Ane wen dempla bin stil longwei prom Eprat, Reisel i pamle ane i bin redi po bone da pikinini blo em. Da pein prom bone beibi i bin prapa nadakain nugud. ");
INSERT INTO tcs_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Wen pein prom bone beibi i bin kam nadakain bad, da oman uda bin elpe em po bone da beibi i bin spik po em diskain, ‘Reisel, yu no prait. Yu gad nada boi pikinini nau.’ ");
INSERT INTO tcs_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Reisel i bin klosap po ded. Wea laswin blo Reisel, bipo em bin ded, em bin kole boi blo em Benoni, wea Ibrulangus i min ‘boi blo sore blo mi’. Bat papa blo da boi bin kolem Benzaman, wea Ibrulangus i min ‘boi blo raitan blo mi’. ");
INSERT INTO tcs_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Apta Reisel i bin ded, dempla bin bere em lo da rod go po Eprat. Nada neim blo taun i Betliem, ");
INSERT INTO tcs_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Zekop bin meke wan memorial ston stanap wea da greib blo Reisel solong po em po rimemba. Dat ston i stil de diskaintaim. ");
INSERT INTO tcs_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Zekop bin kip lego go, ane em bin setemap tent blo em lo da nadasaid blo da taua blo Migdaleder. ");
INSERT INTO tcs_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Lo dat taim wen Zekop i bin stap lo dat ples, Ruben bin go ane em bin slip wea Bila, da nada oman blo papa blo em, ane sambodi bin spik Zekop baut diswan. Dem neim blo dem 12 boi pikinini blo Zekop ya: ");
INSERT INTO tcs_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Dem boi pikinini blo Lia i bin Ruben, pas boi pikinini blo Zekop. Apta Ruben i bin gad Simion, Libai, Zuda, Isaka, ane Zebulun. ");
INSERT INTO tcs_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Dem boi pikinini blo Reisel i bin Zosep ane Benzaman. ");
INSERT INTO tcs_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Dem boi pikinini blo Bila, sebant oman blo Reisel i bin Dan ane Naptali. ");
INSERT INTO tcs_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Dem boi pikinini blo Zilpa, sebant oman blo Lia i bin Gad ane Asa. Demwan ya i bin dem boi pikinini blo Zekop wea em bin gad wea kantri blo Mesapotamia. ");
INSERT INTO tcs_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","So Zekop i bin kambaigen po aus nau blo papa blo em Aizak, de lo Mamre, klostu po Kiriataba. Diswan i Ebron wea Eibram ane Aizak i bin stap. ");
INSERT INTO tcs_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aizak i bin kese 180 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ane Aizak i bin prapa oulman wen em bin lus. Em bin gad prapa long ane gud laip. Wen em bin ole laswin blo em, em bin go ane zoine ol pamle blo em uda bin pinis ded. Den Iso ane Zekop, tu boi blo em i bin bere em. ");
INSERT INTO tcs_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Diswan ya stori blo pamlelain blo Iso. Nada neim blo Iso ol kolem Edom. ");
INSERT INTO tcs_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso i bin kam man blo tu oman prom dem pipol blo Kanan; Ada gel blo Elon, man blo It, ane em bin maret Olibama gel blo Ana. Ate blo Olibama i Zibion, man blo Ib. ");
INSERT INTO tcs_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Iso bin maret gen ane em bin maret kazensisi blo Basimat, gel blo Ismaiel, ane bala blo Basimat i bin Nebaiot. ");
INSERT INTO tcs_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada i bin bone Elipaz po Iso, Basimat bin bone Reuel po Iso, ");
INSERT INTO tcs_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ane Olibama bin bone Zeus, Zalam, ane Kora po Iso. Demwan i bin dem boi pikinini wea Iso i bin gad lo lan blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Den Iso bin teke ol oman blo em, ol pikinini blo em, ane ebri pipol uda stap lo aus blo em, ol buluk, ol kau ane ebri animal blo em, ane dem ebrisamting wea em bin gedem wea lan blo Kanan. Ane Iso i bin mub go po ples longwei prom bala blo em, Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Dem ebri gudsamting blo Iso ane Zekop i bin kam nadakain tumas po demtu po stap tugeda. Da lan wea demtu bin stap no bin gad nap kaikai po pide ebri animal blo demtu bikoz demtu bin gad nadakain plenti animal. ");
INSERT INTO tcs_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","So Iso bin go ane stap lo da ilkantri blo Ser. Nada neim blo Iso i Edom. ");
INSERT INTO tcs_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Diswan ya stori blo pamlelain blo Iso, dem pipol blo Edom uda bin stap lo ilkantri blo Ser. ");
INSERT INTO tcs_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Demwan ya dem neim blo dem boi pikinini blo Iso; Elipaz, da boi pikinini blo Ada, oman blo Iso; Reuel, da boi pikinini blo Basimat, oman blo Iso. ");
INSERT INTO tcs_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Dem boi pikinini blo Elipaz i bin Teman, Omar, Zepo, Gatam, ane Kenaz. ");
INSERT INTO tcs_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timna i bin nada oman blo Elipaz. Elipaz i bin boi blo Iso. Em bin bone Amalek po Elipaz. So demwan i bin dem ngep blo Ada, uda i bin oman blo Iso. ");
INSERT INTO tcs_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Demwan ya i dem boi pikinini blo Reuel; Nat, Zera, Sama, ane Miza. So demwan i bin dem ngep blo Basimat, uda bin oman blo Iso. ");
INSERT INTO tcs_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Demwan ya i dem boi pikinini blo Olibama, uda bin nada oman blo Iso. Em i gel blo Ana uda i boi blo Zibion; Olibama bin bonem po Iso, Zeus, Zalam ane Kora. ");
INSERT INTO tcs_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Dem pamlelain blo Iso i bin kam lida blo ol dipren pamlelain: Demwan ya i dem pamlelain uda bin kamaut prom Iso. Pas boi pikinini blo Iso i bin Elipaz uda ate blo dem pamlelain ya: Teman, Omar, Zepo, Kenaz, ");
INSERT INTO tcs_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kora, Gatam, ane Amalek. Demwan dem pamlelain blo Elipaz lo lan blo Edom. Dempla i ol pamlelain blo Iso ane Ada. ");
INSERT INTO tcs_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Reuel uda bin boi pikinini blo Iso i bin ate blo dem pamlelain ya: Nat, Zera, Sama, ane Miza. Demwan dem pamlelain blo Reuel lo lan blo Edom. Dempla i bin ol pamlelain blo Basimat, oman blo Iso. ");
INSERT INTO tcs_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Dem pamlelain ya i bin kamaut prom Olibama, oman blo Iso: Zeus, Zalam, ane Kora. Olibama, da gel blo Ana, uda bin oman blo Iso, i bin bone dem pamlelain ya. ");
INSERT INTO tcs_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Ebridem pamlelain i bin kamaut prom Iso. Ane nada neim blo Iso i Edom. ");
INSERT INTO tcs_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Dem prapa pipol blo lan blo Edom i bin kamaut prom pamlelain blo wan man neim Ser. Em i man prom Ora. Dem boi pikinini blo Ser i bin dem ate blo dem pamlelain blo dem pipol blo Ora. Demwan i bin: Lotan, Sobal, Zibion, Ana, Dison, Ezer ane Disan. ");
INSERT INTO tcs_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan i bin bigate blo dem pamlelain blo Ori ane Eman, ane sisi blo Lotan i bin Timna. ");
INSERT INTO tcs_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal i bin bigate blo dem pamlelain blo Alban, Manat, Ebal, Sepo, ane Onam. ");
INSERT INTO tcs_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibion i bin bigate blo dem pamlelain blo Aia ane Ana. Diswan da seim Ana wea em bin paine ot spring wata wea da dezet eria, wen em bin lugaut dem dongki blo papa blo em, Zibion. ");
INSERT INTO tcs_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ana i bin bigate blo da pamlelain blo Dison, ane gel pikinini Olibama. ");
INSERT INTO tcs_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dison i bin bigate blo dem pamlelain blo Emdan, Esban, Itran ane Keran. ");
INSERT INTO tcs_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezer i bin bigate blo dem pamlelain blo Bilan, Zaban ane Akan. ");
INSERT INTO tcs_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disan i bin bigate blo dem pamlelain blo Uz ane Aran. ");
INSERT INTO tcs_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Demwan i bin dem bigate blo dem pamlelain blo dem Ora pipol wea da lan blo Ser. Demwan i bin: Lotan, Sobal, Zibion, Ana, Dison, Ezer ane Disan. ");
INSERT INTO tcs_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Dem king ya i bin bos lo da lan blo Edom bipo i bin gad eni king wea dem pipol blo Izrael: ");
INSERT INTO tcs_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela i bin boi blo Beo uda bin king blo Edom. Neim blo siti blo em i Dinaba. ");
INSERT INTO tcs_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Wen Bela bin lus, Zobab uda bin da boi blo Zerar i bin kam king. Zerar bin kam prom da siti blo Bozra. ");
INSERT INTO tcs_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Wen Zobab bin lus, Usam prom lan blo dem pipol blo Teman i bin kam king. ");
INSERT INTO tcs_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Wen Usam bin lus, Adad boi blo Bedad i bin kam king. Em bin stap wea da siti blo Abit. Em bin prapa terem ane smase da ami blo dem pipol blo Midia wea ol bin bigpait lo kantri blo Moab. ");
INSERT INTO tcs_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Wen Adad bin lus, Samla prom da siti blo Masraka i bin kam king. ");
INSERT INTO tcs_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Wen Samla bin lus, Saul prom da siti blo Riobot wea da Yupreitis Riba i bin kam king. ");
INSERT INTO tcs_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Wen Saul bin lus, Balanan boi blo Akbo i bin kam king. ");
INSERT INTO tcs_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Wen Balanan boi blo Akbo bin lus, Adad i bin kam king. Neim blo da siti blo Adar i bin Pau. Neim blo oman blo Adar i Metabel ane Metabel i gel blo Matred wea Matred i bin gel blo Mezarab. ");
INSERT INTO tcs_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Iso i bin bigate blo dem pamlelain blo Edom: Timna, Alba, Zetet, ");
INSERT INTO tcs_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Olibama, Ela, Pinon, ");
INSERT INTO tcs_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenaz, Teman, Mibzar, ");
INSERT INTO tcs_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, ane Iram. Da ples wea dem pamlelain i bin stap, ol bin neime dem ples apta dem pamlelain. Iso i bin bigate blo ol dem pamlelain blo Edom. ");
INSERT INTO tcs_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Zekop i bin stap lo ples wea papa blo em bin stap lo lan blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Diswan stori blo pamlelain blo Zekop. Wen Zosep i bin sebentin iya oul, i bin lugaut dem sip ane gout blo papa blo em wea dem bala blo em; dem boi blo Bila ane Zilpa, dem nada oman blo papa blo em. Zosep bin yan po papa blo em baut dem rongting wanem dem bala blo em i mekem. ");
INSERT INTO tcs_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Zekop bin mina laik Zosep moden dem nada boi blo em, bikoz Zosep i bin bon wen em bin oulman. Ane Zekop bin gibe Zosep wan prapa plas kout wea i kabare an ane leg. ");
INSERT INTO tcs_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Bat wen dem bala blo Zosep bin luk papa blo dempla i bin mina laik Zosep moden dem ebri bala blo em, dempla bin prapa no laik em, ane kan tok naiswei po em. ");
INSERT INTO tcs_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Wantaim Zosep bin gad drim, ane wen em bin spik diswan po ol bala blo em, da wail blo dempla i bin kam moantap. ");
INSERT INTO tcs_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Zosep i bin spik po dempla diskain, ‘Yupla lisen ya po dis drim wea ai bin gad. ");
INSERT INTO tcs_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Yumpla ebriwan, ol bala blo mi, i bin de lo big gadan taiemape ol dem witplant mekem po ol bandol. Wantaim bandol blo mi bin gedap ane stanap, ane ol bandol blo yupla bin stanap raun bandol blo mi, ane demwan i bin baudaun tase graun prant lo dat bandol blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Dem bala blo Zosep bin spik po em, ‘Yu tingk yu gobi king ane bos blo mipla a?’ Wa, dem bala bin eitem mo bikoz prom dem drim blo em ane bikoz prom wanem em bin spikbaut dempla. ");
INSERT INTO tcs_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Den Zosep bin gad nada drim, ane bin spik po ebri bala blo em diskain, ‘Ai bin gad nada drim gen. Da san, mun, ane leben sta i bin baudaun tase graun prant lo mi!’ ");
INSERT INTO tcs_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Bat distaim Zosep bin spik po papa blo em ane po dem bala blo em tu. Papa blo em i bin graul em, ane bin spik po em, ‘Wanem dis drim? Yu tingk mi, ane mama blo yu ane ebri bala blo yu, i go baudaun tase graun prant lo yu a?’ ");
INSERT INTO tcs_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ebridem bala blo Zosep bin zeles em, bat papa blo em i bin tingbaut wanem dem drim i min. ");
INSERT INTO tcs_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Wantaim ol bala blo Zosep i bin go po lugaut dem sip ane gout blo papa blo em klostu lo taun blo Sekem. ");
INSERT INTO tcs_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ane Zekop bin spik po Zosep, ‘Ol bala blo yu lugaut dem sip ane gout de lo Sekem. Kam, ai go sane yu go po dempla.’ Em ansa, ‘Wa, ai go.’ ");
INSERT INTO tcs_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Zekop bin spik po em, ‘Go nau po luk ip ol bala blo yu ane dem sip ane gout tu, ip dempla orait, ane kambaigen ane spik mi wiswei ol dem samting de.’ Zekop i bin sanem go prom da big bali blo Ebron ane Zosep i bin kam de po Sekem. ");
INSERT INTO tcs_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Wan man bin luk Zosep em bin wagbaut de raun. Da man aske em, ‘Wiswei? Wanem yu lukraun po?’ ");
INSERT INTO tcs_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Zosep i bin ansa em baigen, ‘Ai lukraun ol bala blo mi. Dempla i lugaut ol sip ane gout. Yu no bin luk dempla a?’ ");
INSERT INTO tcs_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Da man i ansa, ‘Dempla bin go. Ai bin lisen dempla tok, “Kam yumpla go po Dotan.” ’ Wa, Zosep bin lego go biain ol bala blo em, ane bin paine dempla wea Dotan. ");
INSERT INTO tcs_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Dem bala blo Zosep i bin luk ane megaraut em prom longwei, ane bipo em bin kam prapa klostu po dempla, ol bin meke main po kile em. ");
INSERT INTO tcs_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Dempla spik po wananada, ‘Wa, em ya kam, da man uda oltaim drim. ");
INSERT INTO tcs_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Wiswei? Kam, yumpla go kile em ane sake bodi blo em go insaid wan drai wel, den yumpla ken spik demkain, wailanimal i bin kaikai em. Den yumpla go luk ip dem drim blo em i tru o no tru.’ ");
INSERT INTO tcs_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Bat wen Ruben bin lisen dis tok, em bin trai po seibe laip blo Zosep. Em bin spik po dempla, ‘Yumpla nogo kile em gar. ");
INSERT INTO tcs_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Mobeta mipla no meke dis nugud samting po em. Mata sake em godaun laipwan wea dis wel i nogad no wata, ya wea dis dezetples wea i nogad no man. Den em go ded eniwei ane yumpla no bin kile em wea oun an.’ Em bin tok diskain bikoz em i gad main po seibe Zosep prom dempla ane sanem gobaigen po papa blo em. ");
INSERT INTO tcs_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Wen Zosep bin kam klostu po dem bala blo em, ol bin tekemaut da prapa plas kout blo em, da kout wea em bin werem, ");
INSERT INTO tcs_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","ane ol bin teke em ane sakem godaun da empti wel. Da wel i no bin gad wata insaid. ");
INSERT INTO tcs_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Den apta nau dem bala blo Zosep bin sidaun po kaikai, ane wen ol bin luk go longwei dempla bin luk wanmob blo Ismaiel pipol uda sele ol samting. Dempla ol pipol blo da pamlelain blo Ismaiel. Ol bin kam prom da ples blo Giliad godaun po kantri blo Izipt. Ol kamal blo dempla i bin kare ol mersin, ane ol samting wea i gad prapa naissmel. ");
INSERT INTO tcs_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Den Zuda i bin spik po ol bala blo em, ‘Wanem gud yumpla go gedem prom disting ya ip yumpla go kile bala blo yumpla? Yumpla go pil nadakain gilti. ");
INSERT INTO tcs_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kam, yumpla go sele em po dem pipol blo Ismaiel, ane nobodi go kile em, bikoz em bala blo yumpla, pamle blo yumpla.’ Dem bala blo Zuda i gri. ");
INSERT INTO tcs_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wen dem pipol blo Ismaiel i bin kam klostu, dem bala blo Zosep bin tekemaute Zosep prom da wel, ane sele em po dempla po tuenti pis blo silba. Ane dem pipol blo Ismaiel i bin teke Zosep go po kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Wea dat seimtaim, dem Ismaiel pipol bin kam, bat Ruben no bin de. Wen em bin go po tekemaut Zosep prom dat wel em bin luk em no bin de. Em bin broke klos blo em bikoz em bin prapa sore ane wori. ");
INSERT INTO tcs_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ruben bin gobaigen po dem bala blo em, ane em bin krai ane spik, ‘Ei! I nogad da boi de. Wanem ai go mekem nau?’ ");
INSERT INTO tcs_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Den dem bala blo Zosep bin teke da prapa plas kout blo Zosep, ane ol bin kile wan gout, ane bin wete da prapa plas kout insaid blad blo da gout. ");
INSERT INTO tcs_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Den dempla bin teke da plas kout go po papa blo dempla, ane dempla spik diskain, ‘Mipla bin paine disting ya. Yagar, trai luk ip diswan da plas kout blo boi blo yu?’ ");
INSERT INTO tcs_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Zekop bin kesem, ane spik, ‘Yagar! Wa! Diswan plas kout blo boi blo mi! Ol wailanimal bin kile em ane kaikai em. I mas tru, Zosep i ded gar.’ ");
INSERT INTO tcs_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Den Zekop bin broke klos blo em, ane em bin were klos wea ol i mekem prom esianbaig po soem dat em i prapa atso. Em bin base prapa bigkrai po boi blo em ane em bin krai po prapa longtaim. ");
INSERT INTO tcs_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ebri boi ane gel blo Zekop i bin prapa trai po meke em pilgud bat em no bin wande nobodi po meke em pilgud. Em bin spik, ‘No! Dis krai blo mi po boi blo mi go go wea mi antil dat dei ai go ded.’ Tru gar. Em bin mata krai po Zosep. ");
INSERT INTO tcs_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Lo da seimtaim, dem pipol blo Ismaiel i bin sele Zosep po Potipa de lo kantri blo Izipt. Potipa em i wan dem bigman blo da Pero king, da king blo Izipt. Potipa i bin bos blo dem amiman wea ol i gade da aus blo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Diswan ya i bin apen wea da taim wen Zuda bin go ane libe ol bala blo em biain ane em bin go ane stap wea man neim Ira, uda bin prom taun blo Adulam. ");
INSERT INTO tcs_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Zuda i bin gad piling po wan gel blo de. Em bin gel blo wan Kanan man neim Sua. Zuda bin maret em ane em bin slip lo em. ");
INSERT INTO tcs_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Em bin kam pamle ane bin bone wan boi pikinini ane Zuda bin kolem Er. ");
INSERT INTO tcs_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Oman blo Zuda bin kam pamle gen ane bin bone nada boi pikinini ane em bin kolem Onan. ");
INSERT INTO tcs_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ane em bin kam pamle gen ane bone nada boi pikinini, ane em bin kolem Sela. Dempla bin stap de wea taun blo Kezib wen dat boi pikinini i bin bon. ");
INSERT INTO tcs_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Wen Er bin bigman nau, Zuda bin meke wan oman po kam oman blo Er, pas boi pikinini blo em. Neim blo da oman i bin Tamar. ");
INSERT INTO tcs_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Bat Er i bin prapa nugudman prant lo da AntapGod, ane da AntapGod i bin kile em. ");
INSERT INTO tcs_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Den wantaim apta wen Er bin lus, Zuda bin spik po Onan da namba tu bala, ‘Kam, yu mas maret widooman blo bigbala blo yu. Yu mas meke diswan bikoz i wei blo yumpla. Tamar mas gad wan boi pikinini po meke da pamlelain blo Er, da ded man blo Tamar.’ ");
INSERT INTO tcs_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Bat Onan bin prapa sabe da pamlelain i no gobi blo em. Ebritaim wen em i slip lo da oman blo bala blo em, Onan i bin kapsaid go ausaid lo graun, solong Onan nogo meke pamlelain po bala blo em. ");
INSERT INTO tcs_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wanem Onan bin mekem i bin prapa nugudting prant lo da AntapGod, ane da AntapGod i bin kile em tu. ");
INSERT INTO tcs_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Den Zuda bin spik po dotalo blo em Tamar, oman blo Er. Zuda spik diskain, ‘Mata gobaigen aus blo papa blo yu ane weit de antil boi blo mi Sela go kam bigman.’ Zuda bin prait dat Sela mait go ded tu, wase demtu bala blo em. Tamar bin go ane stap lo aus blo papa blo em. ");
INSERT INTO tcs_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Longtaim apta, oman blo Zuda i bin lus. Wen Zuda bin kam strong prom nomo krai po oman blo em, em bin go wea Aira, pren blo em, po taun blo Timna. Aira em i wan man prom Adulam. Demtu bin go de bikoz demtu i lidingan po dem man uda bin kate ol eya blo dem sip blo Zuda. ");
INSERT INTO tcs_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Den sambodi bin spik po Tamar diskain, ‘Padalo blo yu Zuda, i diskaintaim go po Timna po kate ol eya blo ol sip blo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Tamar sabe Sela em bigman nau, bat em stil weit wattaim Zuda go maret demtu, Tamar ane Sela. Tamar i bin tekemaute dem widooman klos wea em bin werem. Em bin pute nada klos po wantaim kabare ed ane pes blo em. Den em bin go sidaun wea da rod wea i go, go insaid po da biliz blo Enaim. Dis seim rod i pas tru Enaim go stret po taun blo Timna. ");
INSERT INTO tcs_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Wen Zuda bin luk Tamar, em bin tingk em oman uda sele emselp po mani bikoz Tamar bin kabare pes blo em. ");
INSERT INTO tcs_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Zuda bin wagbaut go klostu po Tamar wea em bin sidaun lo da rod ane spik, ‘Ei, ai wande slip wea yu.’ Em no bin sabe diswan Tamar, dotalo blo em. Tamar aske em, ‘Wanem yu go pei ip ai slip lo yu?’ ");
INSERT INTO tcs_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Em ansa, ‘Ai go sanem po yu, wan yang gout prom dem animal blo mi.’ Ane Tamar spik, ‘Wanem samting yu go gibe mi po soe mi wanem yu bin spik i tru, dat yu go sane wan gout blo yu kam po mi?’ ");
INSERT INTO tcs_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Zuda i bin aske Tamar, ‘Wa, wanem samting yu wandem nau?’ Tamar ansarem, ‘Ai wande da neklis wea i gad neim blo yu ane da wokingstik blo yu.’ Zuda i bin gibem po Tamar, ane Zuda bin slip lo em. Ane Tamar bin kam pamle prom em. ");
INSERT INTO tcs_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Den Tamar i bin gedap ane em bin go aus blo em. Ane em bin tekemaute da klos wea i bin kabare ed ane pes blo em, ane em bin were dem seim klos wea em bin werem pas po soem dat em widooman. ");
INSERT INTO tcs_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Den Zuda bin sane yang gout go lo Aira, man prom Adulam, go po gibe dat oman Tamar, ane po tekem kambaigen dat wokingstik ane dat neklis wea i gad neim blo Zuda. Bat Aira no bin paine dat oman Tamar. ");
INSERT INTO tcs_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Aira i bin aske sam man blo da biliz blo Enaim diskain, ‘Wea da oman uda sele emselp? Em bin sidaun lo da rod kam insaid po dis taun.’ Bat dempla ansarem, ‘Nono! I nogad no demkain oman ya.’ ");
INSERT INTO tcs_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Aira i bin gobaigen po Zuda, ane spik, ‘Ai no bin paine dat oman, bat sam dem man blo da biliz blo Enaim i bin spik, “No! I nogad no oman ya uda i sele emselp.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Zuda ansarem, ‘Mata libem! Laue em po kipe dem samting po emselp. Yumi no gobaigen de, bambai ol pipol go sabe. Dempla go prapa meke pan baut yumi. Wa! Ai bin trai po pei em wea da gout, ane yu no bin paine em.’ ");
INSERT INTO tcs_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tri mant apta, sambodi bin spik po Zuda diskain, ‘Tamar, dotalo blo yu i bin meke emselp po wan oman uda sele emselp, ane em pamle nau.’ Ane Zuda bin tok nadakain rapwei diskain, ‘Tekem kam ya ausaid ane bane em wea paia po kile em!’ ");
INSERT INTO tcs_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wail dempla bin tekem kam ausaid, Tamar bin sane mesiz po Zuda diskain, ‘Da man uda da bos blo dem samting ya wea ai gad, em bin meke mi pamle. Prapa luk ya. Dis neklis wea i gad neim ane dis wokingstik ya, i blo uda?’ ");
INSERT INTO tcs_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Den Zuda bin luk dem samting blo em, ane em spik, ‘Tamar bin meke rait ane stret ting. Ai bin meke rongting bikoz ai no bin meke em po kam oman blo Sela, boi blo mi.’ Zuda nomo bin slip lo Tamar gen. ");
INSERT INTO tcs_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Wen i bin taim blo Tamar po bon, i bin gad tu beibi insaid beli blo em. ");
INSERT INTO tcs_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Wen Tamar bin bone dem pikinini, wan beibi bin pute an blo em kam ausaid. Ane da oman uda bin elpe Tamar bone beibi i bin teke da an blo da beibi ane taite red kala string wea dat an. Ane da oman i bin spik, ‘Dis beibi bin kamaut pas.’ ");
INSERT INTO tcs_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Bat den dat beibi i bin pute an blo em gobaigen insaid, ane bala blo da nada beibi i bin bon paswan. Da oman uda bin elpe Tamar bone beibi i bin spik, ‘Ei! Aukam yu bin kam ausaid pas?’ So ol i bin kolem Perez; wea Ibrulangus i min ‘brok go ausaid’. ");
INSERT INTO tcs_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ane apta, bala blo em bin bon wea i gad red string lo an blo em. Ane i bin kolem Zera; wea Ibrulangus wea i min ‘brait moning red blo elimoning’. ");
INSERT INTO tcs_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nau wen Zosep bin kesem de lo Izipt, dem pipol blo Ismaiel i bin sele Zosep po Potipa de lo kantri blo Izipt. Potipa em i wan dem bigman blo da Pero king, king blo Izipt. Potipa i bin bos blo dem amiman wea ol gade aus blo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Da AntapGod i bin elpe Zosep, ane em bin meke ol samting kam orait po Zosep. Em bin wok insaid aus blo da Izipt bos blo em. ");
INSERT INTO tcs_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Da bos blo em tekenotis, ane em rilaiz da AntapGod i bin elpe Zosep, ane da AntapGod bin meke ebrisamting wea em bin mekem po kam orait. ");
INSERT INTO tcs_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Zosep i bin peibretwan lo bos blo em. Em bin meke Zosep po kam klostu sebant blo em. Potipa bin meke em po kam bossebant blo aus blo em, ane kam bos lo ol biznis samting blo em. ");
INSERT INTO tcs_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Apta da taim wen Zosep i bin kam bos, da AntapGod i bin blese aus blo Potipa bikoz prom Zosep. Da AntapGod bin meke ebrisamting wea Potipa bin gad po kam plenti, insaid lo aus blo em ane wea big gadan blo em. ");
INSERT INTO tcs_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Bos blo Zosep bin meke Zosep bos po lugaut ebrisamting wea em bin gad, so Potipa no bin woribaut eniting. Em mata tingbaut po kaikai ane wanem em i go kaikai. Zosep i bin prapa gudluking man ane em bin gad prapa nais strong bodi. ");
INSERT INTO tcs_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Ane wantaim wen Zosep i bin wok, da oman blo Potipa i bin prapa wande Zosep ane em bin spik po Zosep diskain, ‘Kam gar ane slip wea mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Bat Zosep no bin wandem ane bin spik po oman blo Potipa diskain, ‘Lisen ya, Potipa no woribaut enisamting lo dis aus, ane em bin meke mi po lugaut ebrisamting blo em. ");
INSERT INTO tcs_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ai bos blo dis aus seimkain wiskain em i bos. Ai ken meke eniting wea ai wandem insaid lo dis aus. Mata yu ai kan tasem, bikoz yu oman blo em. Watpo nau ai go meke dis prapa nugudting, ane meke badting gense God?’ ");
INSERT INTO tcs_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ane oman blo Potipa i bin kip aske Zosep ebridei, bat Zosep i no bin gri po slip lo em. Zosep bin trai no po stap klostu po em. ");
INSERT INTO tcs_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Wandei, wen Zosep bin go insaid da aus po meke wok blo em, i no bin gad eni sebant insaid da aus. ");
INSERT INTO tcs_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Oman blo Potipa i bin prapa kese Zosep wea ausaid klos blo em, ane em bin bege Zosep, ‘Slip wea mi!’ Bat Zosep bin ariap ranwei ane lego go ausaid, libe dem ausaid klos blo em biain, wea an blo oman blo Potipa. ");
INSERT INTO tcs_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Wen oman blo Potipa bin luk dat em kare dem ausaid klos blo Zosep lo an blo em ane Zosep bin ariap ranwei go ausaid, ");
INSERT INTO tcs_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","em bin ala po dem sebant blo da aus ane em bin spik po dempla, ‘Luk ya. Potipa i bin teke Zosep kam po yumpla, ane dis Ibruman i meke yumpla po sem! Em bin kam insaid rum blo mi ane em bin trai po pose emselp po slip wea mi, bat ai bin ala prapa laudwan. ");
INSERT INTO tcs_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ane wen ai bin ala, em bin libe ausaid klos blo em ya wea mi, ane em bin ariap ranwei go ausaid.’ ");
INSERT INTO tcs_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Da oman blo Potipa bin kipe da ausaid klos blo Zosep klostu wea em antil Potipa bin kam aus. ");
INSERT INTO tcs_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Em bin spik po em da seim stori, diskain, ‘Dat Ibruman uda i sleib, wea yu bin tekem kam po mipla, em bin kam insaid rum blo mi po meke mi sem, ");
INSERT INTO tcs_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","bat stretwei wen ai bin ala, em bin libe ausaid klos blo em ya lo mi, ane em bin ariap ranwei go ausaid.’ ");
INSERT INTO tcs_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Wen bos blo Zosep bin lisen dem tok wea em oman i bin spik po em, da bos blo Zosep i bin kam nadakain wail. ");
INSERT INTO tcs_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ane Potipa i bin kese Zosep ane sakem insaid zeilaus. Dis zeilaus i po dem pipol uda meke rongting gense da king. Zosep i bin stap insaid zeilaus. ");
INSERT INTO tcs_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Bat da AntapGod i bin elpe Zosep ane bin soe lab blo em po Zosep. Ane da AntapGod bin meke bos blo da zeilaus nadakain api wea laip blo Zosep. ");
INSERT INTO tcs_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","No longtaim nau, bos blo da zeilaus bin meke Zosep bos po lugaut ebri pipol uda insaid zeilaus. Wanem wok i bin mekem de, Zosep bin da wan uda bin gibe oda. ");
INSERT INTO tcs_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Da bos blo da zeilaus no bin woribaut enisamting wea Zosep bin lugaut, bikoz da AntapGod i bin elpe Zosep, ane enisamting wea Zosep bin mekem, da AntapGod i bin mekem kam orait. ");
INSERT INTO tcs_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Wantaim, da Pero king, da king blo Izipt, i bin gad nadakain wail po tu boswokman blo em; da bos po kare da dringking kap po da Pero king ane da bos uda beike ol bred po da Pero king. Demtu bin meke rongting gense king blo demtu, da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Em i bin loke demtu insaid lo zeilaus blo bos blo da amiman, wea Zosep i bin stap. ");
INSERT INTO tcs_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Bos blo da zeilaus i bin oda Zosep po bi klostu sebant blo demtu, ane demplatri bin stap insaid lo zeilaus po longtaim. ");
INSERT INTO tcs_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Nau wan nait, demtu bosman blo da Pero king i bin gad drim wea zeilaus. Demtu bin gad dipren drim ane dem drim blo demtu i bin gad demtu oun mining. ");
INSERT INTO tcs_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Moningtaim wen Zosep i bin kam po demtu, em i bin luk demtu bin prapa wori. ");
INSERT INTO tcs_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Zosep i bin aske demtu bosman blo da Pero king uda bin de wea em insaid zeilaus. Em i bin spik diskain, ‘Wanem yutu wori diskain po?’ ");
INSERT INTO tcs_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Demtu bin ansa, ‘Mitu bin gad tu drim, ane i nogad nobodi po spik wanem i min.’ Zosep i spik po demtu, ‘No wori. Mata God gad sabe po gibe ansa blo ol drim! Mata yan lo mi wanem yutu bin drim.’ ");
INSERT INTO tcs_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Da bosman po kare dringking kap blo da Pero king i bin spik drim blo em po Zosep. Em spik, ‘Lo drim blo mi, i bin gad wan plant blo greipbain prant wea mi, ");
INSERT INTO tcs_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ane da greipbain i bin gad tri brans. Dem brans i stat sake lip ane plaua, den dem plaua i tan po raip greip. ");
INSERT INTO tcs_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Da kap blo da Pero king i bin lo an blo mi ane ai bin teke dem greip ane ai bin skuizem po meke zius go insaid kap blo da Pero king, den ai bin gibe da kap po da Pero king.’ ");
INSERT INTO tcs_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Den Zosep i bin spik po em, ‘Diswan i da mining blo da drim: dem tri brans i tri deitaim. ");
INSERT INTO tcs_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Lo da namba tri dei da Pero king go teke yu go kamaut prom dis zeilaus ane meke yu gobaigen po wok blo yu, ane yu go gibe da dringking kap po da Pero king gen, seimkain wanem yu bin mekem bipo. ");
INSERT INTO tcs_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Bat tingbaut mi wen ebriting blo yu i orait. Pliz gar, meke gudting po mi po kole neim blo mi po da Pero king, so em go teke mi kamaut prom zeilaus. ");
INSERT INTO tcs_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bikoz pipol i bin pose mi kam ausaid prom lan blo mi, lan blo dem Ibrupipol; ane ya tu, ai bin meke nating rong po dempla po pute mi insaid lo zeilaus.’ ");
INSERT INTO tcs_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wen da bosbeika blo da Pero king bin kesem dat da mining i bin gud ansa, em spik po Zosep, ‘Ai bin gad wan drim tu. I bin gad tri basket blo wait bred antap lo ed blo mi, ");
INSERT INTO tcs_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ane dat prapa antap basket i bin gad olkain bred wea ai bin kukem po da Pero king, bat dem pizin i bin kam kaikai dem bred prom dat antap basket lo ed blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ane Zosep i bin ansarem, ‘Diswan da mining blo dat drim: demtri basket, i tri deitaim. ");
INSERT INTO tcs_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Lo da namba tri dei, da Pero king i go teke yu kamaut prom dis zeilaus ane kate ed blo yu, ane ainge bodi blo yu antap lo wan tri. Den ol pizin go kam kaikai ol mit blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Wea da namba tri dei nau, i bin batdei blo da Pero king. Em bin meke mina big kaikai po ebri bigman blo em ane ol sebant blo em. Em bin teke demtu kam, da bos po uda kare dringking kap po da Pero king ane da bos uda beike ol bred po da Pero king. Em bin meke demtu stanap prant lo ol dem nada bigman blo em. ");
INSERT INTO tcs_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Den em bin meke da man uda kare kap blo da king po gobaigen po meke da seim wok po da Pero king, ane em bin kare da kap po da Pero king gen. ");
INSERT INTO tcs_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Bat da Pero king i bin kate ed blo dat bosbeika blo em, ane em bin ainge bodi blo em de antap tri, seimkain wiskain Zosep i bin spik. ");
INSERT INTO tcs_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Bat da bosman uda kare dat kap blo da Pero king, em no bin tingbaut po Zosep, em i mina piged em. ");
INSERT INTO tcs_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Wen tu iya i bin pas, da Pero king i bin drim em bin stanap lo said blo da Nail Riba. ");
INSERT INTO tcs_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Wea da drim em bin gad, em i luk seben pat kau wea i bin kamaut prom dat riba, seben kau wea i prapa raun ane pat. Ane dempla i bin kaikai ol gras. ");
INSERT INTO tcs_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Apta nau, seben nada kau, ol mina skiniwan ane nogad no mit, i bin kamaut prom da Nail Riba. Ane demwan i bin stanap klostu po dem nada kau wea said blo dat riba. ");
INSERT INTO tcs_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Dem seben kau wea i prapa skini ane nogad no mit i bin kaikai dem kau wea i bin prapa raun ane pat. Da Pero king bin gedap prom slip. ");
INSERT INTO tcs_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Den em bin gobaigen po slip ane em bin gad nada drim. Em bin luk wea dat drim seben prapa raip ane swelap wited, i bin gro lo wan plant. ");
INSERT INTO tcs_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Apta nau, ol nada seben wited i bin kamaut, diskain ol prapa nugud ane prapa skini prom da istwin wea i blou prom da dezet eria. ");
INSERT INTO tcs_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Dem wited wea i prapa nugud ane prapa skini, i bin kaikai dem prapa raip ane swelap wited. Da Pero king bin gedap prom slip, ane em sabe demwan i bin drim. ");
INSERT INTO tcs_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Neks moning, da Pero king i bin prapa nadakain wori. Em bin wande paindaut wanem dem drim i min. Em bin singaut ebridem maidman po kam ane ebri man uda sabe ebrisamting. Da Pero king i bin spik dempla dem drim blo em, bat nobodi i bin sabe wanem dem mining blo dem drim blo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Den da bosman uda kare da dringking kap blo da Pero king i bin spik po em, ‘Diskaintaim nau ai tingbaut datting wea ai bin spostu mekem. ");
INSERT INTO tcs_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Wantaim yu bin wail wea da bosbeika blo yu, ane yu bin wail po mi tu. Yu bin loke mitu insaid zeilaus blo da bos blo dem amiman blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Mitu bin gad drim lo da seim nait, da bosbeika ane mi. Mitu tu i bin gad dipren drim wea i gad dipren mining. ");
INSERT INTO tcs_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Wan yang Ibruman i bin de wea mitu. Em i sebant blo da bos blo dem amiman uda lugaut aus blo yu. Wen mitu bin spik po em, em bin spik da mining blo dem drim po mitu. ");
INSERT INTO tcs_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Wen em bin spik dem mining po mitu, wa, dem tu drim bin kam tru. Ai bin gobaigen po wok blo mi, ane yu bin kate da ed blo da bosbeika, aingem antap lo tri.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Den da Pero king i bin singaut po Zosep po kam, ane dempla bin ariap tekemautem prom dat zeilaus. Apta Zosep i bin kate eya ane seib, ane em bin seinze ol klos blo em, den em bin kam ane stanap prant lo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Da Pero king spik po Zosep, ‘Ai bin gad wan drim, ane i gad nobodi ya uda ken spik mi wanem ai bin drim. Ai bin lisen i gad tokbaut yu diskain, wen yu lisen drim yu ken spik wanem da mining.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Zosep ansa po da Pero king, ‘I no mi, bat God i go gibe yu wan gud ansa.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Den da Pero king i bin spik po Zosep, ‘Lo drim blo mi, ai bin stanap wea said blo da Nail Riba, ");
INSERT INTO tcs_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ane seben kau mina raun ane pat, bin kamaut prom da Nail Riba ane ol bin kaikai gras de. ");
INSERT INTO tcs_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Apta dem paswan i bin kamaut, ol nada seben kau, prapa skini ane nogad no mit bin kamaut. Ai no bin luk diskain kau wea i prapa nogad no mit lo dis lan blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Dem kau wea i prapa skini ane nogad no mit i bin kaikai dem pat kau wea i bin pas kamaut prom da riba. ");
INSERT INTO tcs_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Bat apta dem skini kau bin kaikai dem pat kau, ol bin stil stap skini ane nogad no mit. Den ai bin gedap prom slip. ");
INSERT INTO tcs_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","‘Ai bin gobaigen po slip ane ai bin drim gen, ane distaim ai bin luk seben prapa raip ane swelap wited. Dempla bin gro lo wan plant. ");
INSERT INTO tcs_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Den apta dem paswan i bin kamaut, ai bin luk nada seben wited bin kamaut, ane demwan ol prapa nugud, skini, ane prapa drai prom da istwin wea i blou prom da dezet eria. ");
INSERT INTO tcs_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Dem prapa skini wited i bin kaikai dem seben prapa raip ane swelap wited. Bat wen ai bin spik dem drim po dem maidman, i bin gad nobodi uda ken spik wanem i min.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Den Zosep i bin spik po da Pero king, ‘Demtu drim blo da Pero king i gad wan mining. God i soe da Pero king wanem em go mekem sun. ");
INSERT INTO tcs_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Dem seben pat kau i seben iya, ane dem seben raip ane swelap wited i seben iya tu. Dempla i seben iya blo prapa gud rein wea ol plenti kaikai go gro. ");
INSERT INTO tcs_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Dem seben kau wea i prapa skini ane nogad no mit, ane dem seben wited wea i prapa nogad no kaikai, dempla i seben iya blo prapa big anggretaim. ");
INSERT INTO tcs_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","‘Diswan i go apen wiskain ai spik po da Pero king. God i bin soe da Pero king wanem em go mekem sun. ");
INSERT INTO tcs_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","I go gad taim blo seben iya blo prapa plenti kaikai ebriwea lo dis kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Apta dem seben gud iya i go gad taim blo seben iya blo prapa big anggretaim. Ol pipol i go piged da taim blo plenti kaikai. Da big anggretaim i go prapa damiz dis kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Da anggretaim wea i go kamaut i gobi mina nadakain nugud. Pipol i go nomo tingbaut lo da taim blo plenti kaikai bikoz prom dat nugudtaim. ");
INSERT INTO tcs_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ane bikoz da Pero king i bin gad da drim tu taim, i min God i prapa meke main blo em baut demting, ane God i go meke demting po apen sun. ");
INSERT INTO tcs_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","‘Wa i rait. Da Pero king mas paine wan smatman uda sabe ol plenti samting, ane meke em bos blo demting ebriwea wea dis kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Wea dat taim blo seben iya blo prapa plenti kaikai, da Pero king mas suze ol boswokman po lugaut ol kaikai ya lo kantri blo Izipt. Dem boswokman mas splitemap ebridem kaikai dem pipol blo Izipt i groem. Dempla mas meke paib ip; wan ip dem boswokman mas tekem ane dem nada po ip i blo dem pipol po kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Dem boswokman mas tekem kam dat kaikai blo da taim blo dem gud iya ane pute dem kaikai wansaid wea ol big storum blo da Pero king. Kipe dem kaikai solong i go gad kaikai po ebridem siti ya, ane meke dem boswokman po prapa kipe dem kaikai seip. ");
INSERT INTO tcs_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Dem kaikai i gobi kaikai po kantri blo Izipt wen dem seben iya blo prapa anggretaim i go kam. Ane lo diswei dem pipol i nogo ded prom anggre.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Da Pero king ane ebri bosman blo em i bin lisen tok blo Zosep ane ol bin gri i tru wanem Zosep i bin spik. ");
INSERT INTO tcs_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","So da Pero king bin aske dem bosman blo em. ‘Wiswei? Yumpla gri? Yumpla nogo paine nada man mogud wase Zosep a? Em i man uda gad da spirit blo God insaid lo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Den da Pero king i bin spik po Zosep, ‘Bikoz God i bin soe yu ebridem samting ya, i nogad wan smatman uda sabe ol plenti samting wase yu. ");
INSERT INTO tcs_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Yu gobi bos blo gabman blo mi, ane ebri pipol blo mi i go mata lisen po oda blo yu. Mata mi uda sidaun wea tron, i gobi mobig den yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ane da Pero king i kip spik po Zosep diskain, ‘Prapa tru. Ai go meke yu po kam bos blo kantri blo Izipt.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Da Pero king i bin tekemaut ring blo em prom pingga blo em, ane em bin putem lo pingga blo Zosep. Em bin dresemap em lo nadakain plasklos ane bin meke em po were gold sein raun lo nek blo em. ");
INSERT INTO tcs_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ane em bin gibe Zosep da sekan oskariz blo da Pero king. Nomata wea Zosep i go go, dem amiman i singaut prant lo Zosep diskain, ‘Yupla baudaun, Zosep ya kam!’ So da Pero king i bin meke Zosep po bi bos blo kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Den da Pero king, i spik po Zosep demkain, ‘Ai da Pero king! Bat nobodi ya lo kantri blo Izipt i lau po meke eniting antil yu go gibe oda po dempla po mekem.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Da Pero king i bin gibe Zosep neim wea Iziptlangus, Zapenatpania ane em bin gibe em Asenat po bi oman blo em. Asenat em i gel blo Potipera, prist blo da siti blo On. Wa, den Zosep bin kam bos blo kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Zosep i bin 30 iya oul wen em bin stat kam po sekanbos blo da Pero king, da king blo Izipt. Den Zosep i bin go nau ane em bin go ausaid ebriwea lo kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","48","Ane i bin apen lo dat taim blo dem seben iya i bin gad nadakain tumas plenti kaikai ebriwea lo kantri blo Izipt. Zosep i bin teke ebridem kaikai blo da taim blo dem seben iya, ane em bin storem insaid lo dem storum lo dem siti. ");
INSERT INTO tcs_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Wen dem seben iya bin pinis, Zosep bin pinis store dem nadakain plenti kaikai. I bin wase da san wea sanbis. I bin mina plenti kaikai dat ol pipol kan kauntem, bikoz i bin prapa obamak. ");
INSERT INTO tcs_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Bipo da taim blo dem iya blo prapa big anggretaim i bin kam, Zosep i bin gad tu boi pikinini wea Asenat i bin bonem po em. Asenat bin gel blo Potipera, prist blo On. ");
INSERT INTO tcs_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Zosep i bin kole pas boi pikinini blo em Manasa, ane i bin spik, ‘God i bin meke mi po nomo tingbaut trabol ane adtaim blo mi ane pamle blo papa blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Da sekan boi pikinini em bin kolem Ipreim, bikoz em bin spik, ‘God bin meke mi gad pikinini wea dis kantri blo ol trabol blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Da taim blo dem seben iya blo prapa plenti kaikai lo Izipt i bin kam po pinis nau, ");
INSERT INTO tcs_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","ane taim blo dem seben iya blo prapa big anggretaim i bin stat, prapa seimkain wiskain Zosep bin spik. I bin gad prapa big anggretaim lo ol dem nada kantri. Bat ebriwea lo kantri blo Izipt i bin gad olkain plenti kaikai wea ol dem storum. ");
INSERT INTO tcs_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Wen ebri pat blo kantri blo Izipt i bin stat po nogad no kaikai, dem pipol bin krai ane aske da Pero king po kaikai. Da Pero king i bin tok po ebridem pipol blo Izipt, ‘Go luk Zosep ane mekem wanem em i spik po yupla.’ ");
INSERT INTO tcs_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Wen ebri pat blo kantri blo Izipt i bin stat po nogad no kaikai ane prapa anggre, Zosep i bin opene dem big storum ane em bin sele dem wit po dem pipol blo Izipt, bikoz da prapa big anggretaim i bin prapa bigwan wea kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Pipol bin kam prom ebriwea wea ert, kam po Izipt po baie wit prom Zosep, bikoz prapa big anggretaim i bin prapa nugud. ");
INSERT INTO tcs_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Wen Zekop, papa blo Zosep, i bin lisen i gad plenti wit wea Izipt, em spik po ol boi blo em diskain, ‘Aukam yupla no meke samting? ");
INSERT INTO tcs_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ai bin lisen i gad plenti wit wea Izipt. Go ane baie wit po yumpla, po stape yumpla prom prapa anggre. Bambai yumpla go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Den, dem ten bala blo Zosep i bin lego go po baie wit wea Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Bat Zekop i no bin laue smolbala blo Zosep, Benzaman po go bikoz em bin prait mait nugud samting go apen po em. ");
INSERT INTO tcs_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","So dem boi blo Zekop i bin go melen wea ol nada pipol uda bin kam po baie wit. Prapa bad anggretaim i bin kese da lan blo Kanan tu. ");
INSERT INTO tcs_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Zosep i bin da sekanbos blo kantri blo Izipt. I bin em uda gibe oda po sele wit po ebridem pipol. Ane wen ol bala blo Zosep i bin kam de wea Izipt, dempla bin baudaun pesdaun prant lo Zosep. ");
INSERT INTO tcs_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Stretwei wen Zosep i bin luk ol bala blo em, em bin megaraut dempla, bat em bin akt em no sabe dempla ane em bin tok rapwei po dempla. Zosep i bin spik, ‘Wea yupla kam prom?’ Dempla ansa po em, ‘Mipla kam prom da lan blo Kanan, kam po baie kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Zosep bin megaraut ol bala blo em, bat dempla no bin megaraut Zosep. ");
INSERT INTO tcs_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Den Zosep i bin tingbaut po dem drim wea em bin gad, baut dem bala blo em. Em spik po dempla, ‘Yupla ol enami! Yupla i bin kam po luk ip mipla no strong solong yupla go tere mipla!’ ");
INSERT INTO tcs_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Dem bala blo em bin ansa po em, ‘Nono gar, bos blo mipla! Mipla ol sebant blo yu uda bin kam po baie kaikai gar. ");
INSERT INTO tcs_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Mipla ebriwan ya ol boi blo wan papa. Mipla ol pipol uda meke ol samting lo truwei. Mipla ol sebant blo yu ane mipla i no ol enami.’ ");
INSERT INTO tcs_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Bat Zosep i bin spik po dempla, ‘Nono! Yupla bin kam po paindaut ip kantri blo mipla i stil strong!’ ");
INSERT INTO tcs_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Dem bala bin spik, ‘Mipla i ol sebant blo yu, tuelb bala, ol boi blo wan papa lo da lan blo Kanan. Ane da las bala em wea papa blo mipla, ane wan nada bala em i bin lus.’ ");
INSERT INTO tcs_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Bat Zosep i bin spik po dempla, ‘I prapa wiskain ai bin spik po yupla, yupla ol enami! ");
INSERT INTO tcs_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Diswan i wiskain ai go sabe ip wanem yupla spik i tru. Ai spik trutok wea da neim blo da Pero king, yupla nogo libe dis ples biain antil las bala blo yupla i go kam ya tu! ");
INSERT INTO tcs_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Sane wan prom yupla po go ane teke da las bala blo yupla kam ya. Den ol nadawan i go stap insaid wea zeilaus, solong ai go sabe ip tok blo yupla i trutok. Ip tok blo yupla i no trutok, den ai prapa sabe yupla ol enami.’ ");
INSERT INTO tcs_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Ane Zosep bin pute dempla insaid wea zeilaus po tri dei. ");
INSERT INTO tcs_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Wen namba tri dei i bin kam, Zosep i spik po dempla, ‘Meke diswan wanem ai spik ane yupla nogo ded, bikoz ai man uda i prapa rispekt God. ");
INSERT INTO tcs_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ip yupla ol man uda meke ol samting wea truwei, suze wan bala blo yupla po stap ya insaid wea zeilaus. Ebridem nada bala ken go ane teke wit go po gibem po ol pamle blo yupla uda prapa anggre. ");
INSERT INTO tcs_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Bat yupla mas teke las bala blo yupla kam po mi, solong ai go luk, den ai go sabe ip tok blo yupla i trutok, ane yupla nogo ded.’ Ane dempla i bin gri po meke diswan. ");
INSERT INTO tcs_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Dempla i bin spik po wananada, ‘Wa, i tru! Yumpla gede panis nau bikoz prom wanem yumpla bin mekem po bala blo yumpla. Yumpla tingbaut wiskain prapa sore Zosep i bin wen em ala po yumpla po stap, no sakem insaid wel. Bat yumpla no bin lisen po em. Daswai dis panis i kambaigen po yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Den Ruben i bin ansa po dempla, ‘Ai bin spik yupla no po meke demkain nugudting po da boi, bat yupla no bin wande lisen. Distaim yumpla gede panis bikoz yumpla bin kile em.’ ");
INSERT INTO tcs_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Zosep i bin tok wea Iziptlangus tru wan sebant blo em uda bin tok Ibrulangus po dempla. So dem bala no sabe dat Zosep i bin kesem wanem dempla i bin tok po wananada. ");
INSERT INTO tcs_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Zosep bin gowei, libe dem bala blo em ane em bin base big krai. Den wen em bin meke emselp strong em bin kambaik tok po dempla gen. Em bin suze Simion prom dempla ane pute ol sein raun wea an ane leg blo em, prant lo dem nada bala. ");
INSERT INTO tcs_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Zosep i bin gibe oda po pilemap ol sekbaig blo dempla lo wit. Den kuaiatwei em bin gibe oda po nada wokman po pute mani gobaigen insaid wea sekbaig blo dem bala. Em bin oda po gibe dempla ol kaikai po kaikai lo da rod gobaigen po aus blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","So dem bala bin pute dem sekbaig blo wit antap dem dongki blo dempla, ane dempla bin lego go. ");
INSERT INTO tcs_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Wen dempla ebriwan bin stap lo wan ples dat nait po slip, wan prom dempla bin opene sekbaig blo em po gibe kaikai po dongki blo em. Wen em bin luk, em luk mani blo em de insaid lo da sekbaig. ");
INSERT INTO tcs_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Em i bin spik po ol bala blo em, ‘Ei luk ya! Sambodi bin pute mani blo mi ya baigen, i ya insaid sekbaig blo mi!’ Prom diswan dempla bin mina prapa wori ane ol bin luk po wananada, prapa prait ane spik po wananada, ‘Ei. Wiswei nau? Wanem God i bin mekem po yumpla?’ ");
INSERT INTO tcs_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Wen dempla i bin kam po papa blo dempla Zekop, lo lan blo Kanan, dempla bin spik em ebriting wanem i bin apen po dempla. Dempla bin spik, ");
INSERT INTO tcs_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","‘Da man uda sekanbos blo Izipt i bin tok prapa rapwei po mipla ane em bin meke mipla wase enami gense kantri blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Bat mipla bin spik po em, “Mipla ol pipol uda meke ol samting lo gudwei ane mipla no bin kam po tere yupla. ");
INSERT INTO tcs_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Mipla i tuelb bala, ol boi blo wan papa. Wan bala em i bin lus ane dat las bala i wea papa blo mipla lo da lan blo Kanan.” ");
INSERT INTO tcs_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","‘Da sekanbos blo Izipt, i bin spik po mipla, “Libe wan bala blo yupla ya lo mi, ane tekem wanem yupla nidem po ol pamle blo yupla uda prapa anggre. Prom diswan ai go sabe ip yupla ol man blo meke ol samting wea gudwei. ");
INSERT INTO tcs_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Yupla mas teke las bala blo yupla kam po mi, den ai go sabe yupla no ol enami, bat man blo meke samting wea gudwei. Den ai go tekemaute bala blo yupla kam ausaid prom zeilaus, ane yupla ken kambaigen enitaim po gede mo kaikai.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Wen dem bala blo Zosep bin kapsaid ausaid dem wit prom dem baig, insaid sekbaig blo ebri man i bin gad mani blo dempla. Wen dempla ane papa blo dempla i bin luk manibaig blo dempla, ebriwan dempla bin prapa prait nau. ");
INSERT INTO tcs_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ane Zekop bin spik po dempla, ‘Yupla wande mi po luze ebri pikinini blo mi a? Zosep i bin lus ane Simion i de insaid zeilaus, ane diskaintaim yupla wande teke Benzaman a? Ai da wan uda gad prapa big atso, no yupla!’ ");
INSERT INTO tcs_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Den Ruben bin spik po papa blo em, ‘Yu ken kile tu boi blo mi ip ai no teke Benzaman kambaigen po yu. I orait! Ai go lugaut em ane tekem kambaigen po yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Bat Zekop i bin ansa po em, ‘Boi blo mi, Benzaman mas nogo daun wea yupla. Bala blo em i lus ane ai mata gad em nau. Ip samting go apen po em wea dis ran blo yupla, yupla go sane dis waiteya oulman go ded prom atso.’ ");
INSERT INTO tcs_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Wa, da prapa big anggretaim i bin prapa nugud lo da lan blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ane wen pamle blo Zekop bin kaikai ebridem wit wea dempla bin baiem prom Izipt, Zekop i bin spik po dem boi blo em, ‘Lego go gen ane baie lelbet mo wit po yumpla po kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Bat Zuda spik po em, ‘Da sekanbos blo Izipt i bin prapa wone mipla diskain, “Yupla nogo luk pes blo mi antil smolbala blo yupla i go kam lo yupla.” ");
INSERT INTO tcs_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ip yu go sane bala blo mipla po go wea mipla, mipla i go lego go ane baie kaikai po yumpla. ");
INSERT INTO tcs_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Bat ip yu nogo laue em po kam, wel mipla go mata stap. Da sekanbos blo Izipt bin spik po mipla, “Yupla nogo luk pes blo mi antil smolbala blo yupla i go kam ya wea yupla.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Zekop i bin spik, ‘Aukam yupla bin spik diskain po da sekanbos yupla i gad nada bala? Yupla bin meke nugudwei po mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Dempla ansa em, ‘Da sekanbos bin prapa wande paindaut uda mipla ane pamle blo mipla. Em bin askem, “Papa blo yupla i stil laip a? Yupla gad nada bala a?” Wanem mipla bin spik em, i bin dem ansa po dem kuestin blo em. Mipla no bin sabe em go spik, “Teke bala blo yupla kam ya”?’ ");
INSERT INTO tcs_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Den Zuda i bin spik po Zekop, ‘Sane da smolbala po kam wea mipla, ane lete mipla go wantaim. Bambai yumpla go ded prom prapa anggre, yu ane mipla ebriwan ane ol smolwan blo yumpla tu. ");
INSERT INTO tcs_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ai maiselp promis po lugaut em. Ai go teke bleim po em. Ip ai no tekem kambaigen gudwan po yu, yu ken bleime mi po disting poeba. ");
INSERT INTO tcs_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ip yu no bin weiste mipla taim, mipla diskaintaim bin tu ran godaun po Izipt.’ ");
INSERT INTO tcs_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Den papa blo dempla Zekop i bin spik po dempla, ‘A wa! Ip i go apen demkain, den mekem diskain. Teke present godaun po da sekanbos blo Izipt lo baig blo yupla, dem prapa gudting blo dis lan. Kare ol mersin, ani, spais, prapa nais sentoil, ane ol nat. ");
INSERT INTO tcs_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Teke tu pei blo mani wea yupla, ane gibe da mani baigen wea i bin sidaun insaid dem sekbaig, mait i bin misteik. ");
INSERT INTO tcs_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Teke smolbala blo yupla wantaim lo yupla, ane go ariap po da man uda i da sekanbos. ");
INSERT INTO tcs_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Strong AntapGod, meke da sekanbos po soe sorewei po yupla, solong da sekanbos go sane dat nada bala blo yupla ane Benzaman kambaigen. Bat ip ai go luze ol pikinini blo mi, wa den ai go luze dempla.’ ");
INSERT INTO tcs_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Dem bala bin teke dem present, ane ol bin teke tu pei blo mani ane Benzaman wantaim. Den dempla bin ariap go po Izipt, ane dempla i bin go luk Zosep. ");
INSERT INTO tcs_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Wen Zosep i bin luk Benzaman i de lo dempla, em bin spik po dat bossebant blo aus blo em, ‘Teke dem man ya go po aus blo mi, ane kile wan animal ane meke big kaikai. Melendei tidei, dem man i go kaikai wea mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Ane dat bossebant blo Zosep bin mekem wiskain Zosep bin odarem ane em bin teke dem man go po aus blo Zosep. ");
INSERT INTO tcs_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Dem bala i bin prapa prait bikoz i bin teke dempla go po aus blo Zosep ane dempla bin tingk diskain, ‘Em bin teke yumpla kam ya bikoz prom dat mani wea i bin insaid dem sekbaig blo yumpla. Em wande bleime yumpla, ane meke yumpla sleib blo em, ane teke dem dongki blo yumpla po emselp.’ ");
INSERT INTO tcs_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Dempla bin wagbaut go klostu po da bossebant blo Zosep ane dempla bin tok wea em prant wea doa blo da aus. ");
INSERT INTO tcs_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Dempla i bin spik, ‘Bos blo mipla, plizgar, prapa lisen gar. Mipla i bin kam ya po Izipt pas po baie kaikai, ");
INSERT INTO tcs_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ane wen mipla bin gobaik, mipla bin stap lo wan ples dat nait po slip. Wen mipla bin opene sekbaig blo mipla, mipla i bin paine mani blo da wit de insaid antap wea sekbaig blo mipla. Ya nau. Mipla bin teke dem mani kambaigen wea mipla. ");
INSERT INTO tcs_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ane mipla bin teke mo mani kam po baie mo kaikai. Mipla no sabe uda bin pute dem mani baigen insaid lo sekbaig blo mipla.’ ");
INSERT INTO tcs_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Dat bossebant i bin ansa dempla, ‘I orait. Yupla no wori ane no prait. I mas bi da God yupla wosip, da God wea yupla pamlelain i wosip, uda bin pute mani insaid wea sekbaig blo yupla. Ai sabe yupla bin pei dat mani po dat wit blo yupla.’ Den da bossebant blo Zosep i bin teke Simion kam ausaid prom zeilaus kam po dem nada bala. ");
INSERT INTO tcs_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Da bossebant blo Zosep i bin teke dempla go insaid aus blo Zosep ane em bin gibe dempla wata po wase dempla leg, ane gibe kaikai po ol dongki blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Dempla bin lisen dempla go kaikai wea aus blo Zosep. So dempla bin meke redi dem present po gibem po Zosep wen em go kam melendei po aus. ");
INSERT INTO tcs_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Wen Zosep i bin kam insaid lo aus, dempla bin gibe em dem present wea dempla bin tekem kam. Dempla bin baudaun pesdaun prant wea em. ");
INSERT INTO tcs_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Zosep i bin aske dempla ip ol i orait, ane em spik, ‘Papa blo yupla orait a, da oulman wea yupla bin tokbaut? Em stil laip a?’ ");
INSERT INTO tcs_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Dempla i bin ansa, ‘Papa blo mipla i orait gar, ane wa, em stil laip.’ Sekantaim nau, dempla bin baudaun. ");
INSERT INTO tcs_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Wen Zosep bin luk gen em bin luk Benzaman, boi blo mama blo em, ane em bin spik, ‘Diswan smolbala blo yupla a? Diswan em ya nau wea yupla bin spik mi? God blese yu, mai boi!’ ");
INSERT INTO tcs_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Zosep bin wantaim atso prom prapa strong piling blo lab po da smolbala blo em. Em bin klosap stat po krai, ane em bin ariap go insaid rum blo em ane em bin base bigkrai de. ");
INSERT INTO tcs_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Den em bin wase pes blo em ane apta em bin kamaut. Em bin meke emselp strong. Em bin oda ol sebant blo em po teke kaikai kam nau. ");
INSERT INTO tcs_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Dempla i bin gibe kaikai po Zosep lo wan teibol, ane i bin gibe kaikai po dem bala lo nada teibol. Dem pipol blo Izipt uda bin kam po kaikai lo Zosep i bin kaikai lo nada teibol, bikoz dempla i prapa eite dem Ibrupipol ane no laik po kaikai wea dempla. ");
INSERT INTO tcs_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Zosep i bin oda dem bala po sidaun kaikai diskain ya, prom da bigbala go rait daun po da las bala. Wen dem bala bin luk nau wiskain ol bin sidaun, dempla i bin wase wananada wea atzamp wei. ");
INSERT INTO tcs_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Dem sebant i bin teke ol kaikai po dem bala prom teibol blo Zosep, bat kaikai blo Benzaman i bin paib taim mobig den dem nada bala. So dem bala i bin mina lego po kaikai ane dringk wain wea Zosep antil ol bin kam nadakain api. ");
INSERT INTO tcs_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Zosep gibe oda po bossebant blo em diskain, ‘Pilemap dem sekbaig blo dem man wea prapa plenti wit, ane pute dem mani blo dempla ebriwan insaid lo sekbaig blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Pute kap blo mi, da silba kap, de insaid lo sekbaig blo da smolbala wantaim wea da mani.’ Da bossebant blo Zosep i bin mekem wiskain Zosep i bin spik. ");
INSERT INTO tcs_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Wen i bin deibreik neksdei, dem bala bin lego gobaik wea dem dongki blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Bat wen dem bala no bin prapa longwei prom da siti, Zosep bin spik po da bossebant blo em, ‘Wantaim lego go apte po dem man. Wen yu go kese dempla, yu spik po dempla diskain, “Aukam yupla bin meke nugudwei po mipla, wen mipla i bin meke gudwei po yupla? ");
INSERT INTO tcs_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Aukam yupla bin stile dat silba kap blo bos blo mi? Dis kap, da bos blo mi i yuzem po dringk, ane em i yuzem po paindaut demting wea i go apen. Diswan prapa nugudting wea yupla bin mekem.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Wen da bossebant blo Zosep bin kesap lo dem bala, em bin spik ebridem tok blo bos blo em po dempla. ");
INSERT INTO tcs_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bat dempla ansarem, ‘Bos blo mipla, wiskain yu ken tok ol demkain tok? I kan bi! Mipla ol sebant blo yu, ane mipla kan meke demkainting! ");
INSERT INTO tcs_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ei, lisen ya! Dem mani wea mipla bin painem insaid lo da sekbaig blo mipla, mipla bin tekem kambaigen po yu prom da lan blo Kanan. Aukam mipla go stile dem silba ane gold prom aus blo bos blo yu? ");
INSERT INTO tcs_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ip wan prom mipla i gad da silba kap, em go ded ane mipla ebriwan i go kam sleib blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Da bossebant i ansa, ‘A wa! I wiskain yu spik. Ai gri po mekem wanem yu spik. Bat i mata da wan uda go gad disting i go kam sleib. Dem nadawan i go mata go.’ ");
INSERT INTO tcs_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Ebridem bala bin pute dem sekbaig blo dempla daun lo da graun ane dempla bin opene dem baig. ");
INSERT INTO tcs_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Wen da bossebant bin stat lukraun, em bin pas stat lo da bigbala go rait daun po da smolbala, ane em bin paine da silba kap insaid lo sekbaig blo da smolbala Benzaman. ");
INSERT INTO tcs_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Prom diswan dem bala bin broke klos blo dempla bikoz dempla bin prapa sorewan. Den ebri bala bin pute dem sekbaig antap lo dongki blo dempla, ane dempla bin gobaigen po da siti. ");
INSERT INTO tcs_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Zosep i bin mata de lo aus wen Zuda ane ol bala blo em bin kam de. Dem bala bin kuikwan poldaun godaun lo da graun prant wea Zosep. ");
INSERT INTO tcs_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Zosep spik po dempla, ‘Aukam yupla meke diskain po mi? Ai da sekanbos blo Izipt ane ai mas sabe wen ol man meke demkain samting po mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Zuda i bin spik, ‘Bos blo mipla, mipla gad nating po spik nau! Mipla kan meke nating po soem dat mipla no bin meke rongting. God bin soem po mipla wanem rongting mipla bin mekem. So ebriwan prom mipla ya gobi ol sleib blo yu ane no mata da wan wea i bin paine da silba kap.’ ");
INSERT INTO tcs_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Zosep ansarem, ‘I kan bi! Ai kan meke demkain samting! Mata da man uda bin gad da silba kap i gobi sleib blo mi. Yupla dem nadawan, yupla orait. Yupla ken go aus po papa blo yupla.’ ");
INSERT INTO tcs_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Den Zuda i bin kam klostu po Zosep ane spik, ‘Yagar, bos blo mi, laue sebant blo yu po tok wea yu lo gudwei. No wail wea mi gar. Yu prapa bigman seimkain wase da Pero king emselp ane yu gad dat rait po kile mi. ");
INSERT INTO tcs_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","‘Bos blo mi, yu bin aske mipla ip mipla gad papa o bala. ");
INSERT INTO tcs_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Mipla bin ansa, “Mipla gad papa ane em i prapa oulman. Wen em bin prapa oulman em bin gad wan boi pikinini. Da nada prapa bala blo dis boi i ded. Em i mata gad wan bala prom demtu boi pikinini prom mama blo em. Wa, papa blo em i prapa labe em.” ");
INSERT INTO tcs_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","‘Yu bin spik po mipla, ol sebant blo yu, “Teke em kam ya po mi, solong ai go luk em.” ");
INSERT INTO tcs_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Bos, mipla bin spik po yu, “Dat boi i kan libe papa blo em biain. Ip em go libe papa blo em, papa blo em i go ded.” ");
INSERT INTO tcs_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Yu bin spik po mipla gen, “Yupla nogo luk mi gen antil yupla i go teke da smolbala blo yupla kam.” ");
INSERT INTO tcs_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","‘Wen mipla bin gobaigen po papa blo mipla, mipla bin spik po em wanem dem seimting wanem yu bin spik po mipla. ");
INSERT INTO tcs_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Wen Papa blo mipla bin spik, “Go gen, baie lelbet mo wit po yumpla po kaikai”, ");
INSERT INTO tcs_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","mipla bin ansa, “Mipla kan go po Izipt ip dat smolbala blo mipla i no kam wea mipla. Mipla kan luk dat man antil smolbala blo mipla i wea mipla.” ");
INSERT INTO tcs_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","‘Den papa blo mipla i bin spik po mipla, “Yupla sabe oman blo mi i bin bone tu boi pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Wan boi i bin gowei ane no bin kambaigen. Mas bi wailanimal bin kaikai em bikoz ai no bin luk em gen. ");
INSERT INTO tcs_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ip yupla go teke dis las boi prom mi, ane nugud samting i go apen po em, yupla go sane dis waiteya oulman go ded prom atso.” ");
INSERT INTO tcs_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","‘Ane nau, sekanbos blo Izipt, ai kan gobaigen po luk papa blo mi nogad dat boi wea mipla, bikoz laip blo papa i stap lo dat boi. ");
INSERT INTO tcs_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Wen em go luk dat boi i no lo mipla, em go ded ane i gobi polt blo mipla po sane dat waiteya oulman go ded prom atso. ");
INSERT INTO tcs_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Nadating ya nau. Ai bin meke promis ai go lugaut da boi. Ai bin spik diskain po papa blo mi, “Ip ai nogo tekem kambaigen gudwan po yu, den ai go gad bleim po disting antil ai go ded.” ");
INSERT INTO tcs_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","‘Yagar bos blo mi. Laue mi po stap ya po teke ples blo da boi ane ai gobi sleib blo yu, ane laue da boi po kambaigen lo dem bala blo em. ");
INSERT INTO tcs_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Wiskain nau, ip ai gobaigen nogad dat boi po papa blo mi? Ai kan stan po luk wiskain atso da papa blo mi i go gad.’ ");
INSERT INTO tcs_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Zosep kan stape emselp nomo prant lo ol dem sebant blo em. Em bin kraiwan singaut diskain po dem sebant, ‘Ebriwan gowei! Libe mi pas!’ I no bin gad nobodi lo em wen Zosep bin soe emselp po ol bala blo em uda em. ");
INSERT INTO tcs_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Zosep i bin base nadakain bigkrai. Dem pipol blo Izipt uda bin stanap ausaid lo aus blo Zosep, dempla ol bin lisen krai blo em. Da niuz blo diswan i bin kese aus blo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Zosep i bin spik po dem bala blo em, ‘Yupla megaraut mi, ai Zosep. Papa blo mi stil laip a?’ Bat dem bala bin gad nating po spik. Ol bin blok. Dempla prapa kan bilib dempla luk Zosep. Dempla kan ansa ol tok blo em. ");
INSERT INTO tcs_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Zosep bin spik po dem bala blo em, ‘Yagar, kam klostu po mi’, ane wen dempla bin mub kam klostu, em bin spik, ‘Ai bala blo yupla, Zosep. Ai da seimwan yupla bin sele mi go po Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Wa, diskaintaim, no atso o bleime yuplaselp bikoz yupla bin sele mi kam ya. I bin apen diskain bikoz God i bin sane mi kam pas prom yupla po lugaut ol laip blo yupla. ");
INSERT INTO tcs_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Dis prapa big anggretaim ya lo dis lan blo Izipt, i bin pinis go po tu iya nau, ane i go gad nada paib iya wea ol pipol kan plante ol gadan ane gede ol kaikai prom dem gadan. ");
INSERT INTO tcs_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","God i bin sane mi kam pas prom yupla solong yupla go stap laip ane no ded. Den yupla go kam wan pipol uda stap wea yupla oun kantri. ");
INSERT INTO tcs_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Wa, i prapa klia i no bin yupla uda bin sane mi kam ya, bat God. Ane em bin meke mi longsaidman blo da Pero king, ane bos blo gabman blo em ane bos blo ebri pipol blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","‘Ariap gobaigen po papa blo mi ane spik em dis mesiz prom da boi blo em Zosep, “Diswan i wanem Zosep, boi blo yu i spik, ‘God i bin meke mi po bi bos blo ebri pipol blo Izipt. Wantaim kam ya daun po mi. ");
INSERT INTO tcs_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Yu go stap lo eria blo Gosin solong yu go stap klostu po mi. Yu, ane ol pikinini blo yu ane ol ngep blo yu, ol sip, gout, buluk, ane kau blo yu, ane ebrisamting wea yu gad. ");
INSERT INTO tcs_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ai go lugaut yupla wea kaikai bikoz i gad nada paib iya blo prapa big anggretaim po kam. Ip yupla no kam ya daun, yu ane pamle blo yu nogo gad nating.’” ");
INSERT INTO tcs_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","‘Ane wa! Yupla ken luk po yuplaselp ane bala blo mi Benzaman i ken luk tu, dat ai prapa Zosep uda i tok po yupla. ");
INSERT INTO tcs_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Spik papa blo mi wiskain ebri pipol ya lo Izipt, dempla i prapa rispekt mi. Spik em ebrisamting wea yupla bin luk, ane ariap teke papa blo mi kambaik ya.’ ");
INSERT INTO tcs_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Den Zosep i bin krai ane gasu bala blo em Benzaman, ane Benzaman bin krai tu ane gasu Zosep baigen. ");
INSERT INTO tcs_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ane Zosep bin kraiwan kise dem nada bala blo em. Apta diswan dem bala blo em i bin mata yan wea em. Yan mata go. ");
INSERT INTO tcs_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Wen dat tok i bin kese Pero king ol bala blo Zosep i bin kam de, da Pero ane ol bigman blo em i bin nadakain api. ");
INSERT INTO tcs_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Da Pero king i bin spik po Zosep, ‘Spik po ol bala blo yu, “Meke diswan: pute dem samting antap lo ol animal blo dempla ane gobaigen po da lan blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Go teke papa blo yupla kam, ol pamle blo dempla ane kambaigen ya.” Spik po dempla, “Ai go gibe yupla da prapa bes lan i gad ya lo Izipt, ane yupla go gad prapa gud kaikai po kaikai lo dis kantri.” ");
INSERT INTO tcs_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","‘Yu spik dem bala diskain, “Meke diswan: teke ol big oskariz prom ya Izipt, go lo yupla po kare yupla smolwan ane yupla oman, ane teke papa blo yupla kam ya. ");
INSERT INTO tcs_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Yupla no wori prom libe lelbet samting blo yupla biain, bikoz da prapa gud lan ya wea Izipt, i blo yupla.” ’ ");
INSERT INTO tcs_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Dem boi blo Zekop i bin mekem wanem da Pero king i bin oda dempla. Zosep i bin gibe dem bala ol big oskariz, stret wiskain da Pero king i bin oda em, ane Zosep i bin gibe dempla kaikai po ran blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Po ebri bala, Zosep i bin gibe dempla niu klos, bat po Benzaman em bin gibe em paib niu klos ane 300 pis blo silba. ");
INSERT INTO tcs_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Zosep i bin sanem po papa blo em, ten mandongki po teke ol mina gudsamting prom Izipt, ane ten omandongki po teke wit, bred, ane ol nada kaikai po papa blo em wea da ran blo em. ");
INSERT INTO tcs_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Zosep bin yawo dem bala blo em, ane bin tok strong po dempla diskain, ‘No graul lo wananada lo da ran.’ ");
INSERT INTO tcs_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Dem bala i bin tekop go, ane ol bin lego go prom Izipt po papa blo dempla Zekop, de lo dat lan blo Kanan. ");
INSERT INTO tcs_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ane dem bala bin broke niuz po papa blo dempla. Dempla i bin spik, ‘Yagar! Papa, lisen mipla gar! Boi blo yu Zosep, em i stil laip. Em no ded. Diskaintaim em i sekanbos blo kantri blo Izipt.’ Zekop i bin atzamp prom dat niuz ane em no bin bilib dempla. ");
INSERT INTO tcs_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Bat wen dempla bin spik po Zekop, papa blo dempla, ebriting wanem Zosep i bin spik po dem bala, ane wen Zekop i bin luk dem big oskariz wea Zosep bin gibem po teke Zekop gobaigen po Izipt, den em bin bilibe dempla. ");
INSERT INTO tcs_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Zekop i bin spik, ‘Yagar! Diswan i dat wan ting wea ai bin wandem! Boi blo mi Zosep em i laip gar! Ai go lego go ane luk em bipo ai go ded.’ ");
INSERT INTO tcs_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Wa, den Zekop i bin lego go wea ran blo dempla, teke ebriting dempla bin gad go po Izipt. Wen em bin kese Bisiba, Zekop i bin kile animal ane banem antap lo olta po wosip God, da God blo Aizak, papa blo em. ");
INSERT INTO tcs_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Dat nait God i spik po Zekop lo drim, ‘Zekop! Zekop!’ Ane em bin ansa, ‘Mi ya God. Wiswei?’ ");
INSERT INTO tcs_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","God i spik, ‘Ai God, da God wea papa blo yu i wosip. No prait po godaun po Izipt. De lo dat kantri ai go meke yu bigate blo ol prapa big pamlelain uda tok dempla oun langus, ane uda go stap lo dempla oun kantri. ");
INSERT INTO tcs_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ai go godaun po Izipt lo yu, ane mata mi God, ai go teke yu kambaigen ya, ane an blo Zosep i go sate ai blo yu de lo Izipt.’ ");
INSERT INTO tcs_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Zekop i bin lego go prom Bisiba. Dem boi blo Zekop i bin pute Zekop, ane oman blo dempla ane pikinini blo dempla wea dem big oskariz wea da Pero king i bin sanem kam po Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Dem boi blo Zekop i bin teke ol dem animal blo dempla, ane ebrisamting blo dempla wea ol bin gedem wea Kanan ane dempla bin go po Izipt, Zekop ane ebri pamle blo em, ");
INSERT INTO tcs_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ol boi blo em ane ol gel blo em, ol boi blo dempla ane ol gel blo dempla. Zekop i bin teke dempla ebriwan godaun po Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Diswan ya neim blo dem pipol blo Izrael, dem pamlelain blo Zekop ane ol boi blo em, uda bin kamdaun po Izipt: Ruben, bigboi blo Zekop, ");
INSERT INTO tcs_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","ane dem boi blo Ruben i Anok, Palu, Ezron, ane Karmi. ");
INSERT INTO tcs_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Dem boi blo Simion i Zemuel, Zamin, Oad, Zakin, Zoar, ane Saul. Da mama blo Saul i bin wan Kanan oman. ");
INSERT INTO tcs_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Dem boi blo Libai i Gerson, Koat, ane Merari. ");
INSERT INTO tcs_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Dem boi blo Zuda i Er, Onan, Sela, Perez, ane Zera. Prom demwan ya, Er ane Onan bin lus de lo Kanan. Dem boi blo Perez i bin Ezron ane Amul. ");
INSERT INTO tcs_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Dem boi blo Isaka i Tola, Pua, Zasub, ane Simron. ");
INSERT INTO tcs_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Dem boi blo Zebulun i Sered, Elon, ane Zalil. ");
INSERT INTO tcs_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Demwan ya i dem boi pikinini blo Lia wea em bin bonem po Zekop lo kantri blo Mesapotamia, ane i bin gad wan gel blo Zekop neim Daina. Da pamlelain blo Lia ane Zekop i bin olgeda 32 boi ane wan gel. ");
INSERT INTO tcs_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Dem boi blo Gad i Zepon, Agi, Suni, Ezbon, Eri, Arodi, ane Areli. ");
INSERT INTO tcs_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Dem boi blo Asa i Imna, Isba, Isbi, Beria, ane sisi blo dempla Sera. Dem boi blo Beria i Eber ane Malkiel. ");
INSERT INTO tcs_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Dem sikstin pipol ya i pamlelain blo Zilpa ane Zekop, da sebant oman blo Laban i bin gibem po gel blo em Lia. ");
INSERT INTO tcs_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Dem boi blo Reisel ane Zekop i Zosep ane Benzaman. ");
INSERT INTO tcs_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Dem boi blo Zosep i Manasa ane Ipreim. Demtu bin bon de wea Izipt po Asenat. Asenat em i gel blo Potipera, prist blo On. ");
INSERT INTO tcs_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Dem boi blo Benzaman i Bela, Beka, Asbel, Gera, Naman, Ei, Ros, Mupim, Upim, ane Ard. ");
INSERT INTO tcs_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Dem potin pipol ya i pamlelain blo Reisel ane Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dat boi blo Dan i Usim. ");
INSERT INTO tcs_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Dem boi blo Naptali i Zazil, Guni, Zezer ane Silem. ");
INSERT INTO tcs_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Dem seben pipol ya i pamlelain blo Bila ane Zekop, da sebant oman wea Laban i bin gibem po gel blo em Reisel. ");
INSERT INTO tcs_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Ebri pipol uda bin kam po Izipt lo Zekop, dem pamlelain uda gad blad blo em, i bin siksti siks pipol. Bat dem oman blo dem boi blo Zekop no bin insaid dat namba. ");
INSERT INTO tcs_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Tu boi i bin bon prom Zosep de wea Izipt. Ane de lo Izipt i bin gad sebenti wea pamlelain blo Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Zekop i bin sane Zuda go pas po Zosep po spik em po soe em wiswei da rod i go po Gosin. Ane wen dempla bin go insaid Gosin, ");
INSERT INTO tcs_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Zosep i bin meke dat paiting oskariz blo em redi ane em bin go po Gosin po luk papa blo em, Zekop. Wen demtu bin kam prapa klostu po wananada, Zosep bin prapa gasu em ane krai lo solda blo Zekop po longtaim. ");
INSERT INTO tcs_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Den Zekop i bin spik po Zosep, ‘Ai ken lus nau bikoz ai bin luk yu ane sabe dat yu stil laip.’ ");
INSERT INTO tcs_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Zosep i bin spik po ol bala blo em ane po ebri pipol blo papa blo em, ‘Ai go go nau ane spik po da Pero king, “Ol bala blo mi ane pamle blo papa blo mi wea ol bin stap lo Kanan, ol ya nau kam po stap klostu po mi. ");
INSERT INTO tcs_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Dem pipol ya, i pipol blo lugaut ol animal ane mata groe dempla oun animal. Dempla bin tekem kam wea dempla, ol sip, gout, buluk, kau, ane ebrisamting wea dempla i gad.” ");
INSERT INTO tcs_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","‘Wen da Pero king i singaut yupla po kam ane aske yupla wanem wok blo yupla, ");
INSERT INTO tcs_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","yupla mas spik diskain, “Ol sebant blo yu, mipla prom de pas i bin ebritaim lugaut ol animal, seimkain wase ol ate blo mipla.” Wen yupla go tok demkain, da Pero king i go laue yupla po stap lo da ples blo Gosin, bikoz dem pipol blo Izipt i prapa no wande miks o meke enisamting wea ol pipol uda lugaut ol animal.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Zosep i bin kam ane spik po da Pero king, ‘Papa blo mi ane ol bala blo mi i bin kam prom Kanan, wea dempla sip, gout, buluk, kau ane ebrisamting blo dempla, ane dempla diskaintaim de lo Gosin.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Zosep i bin suze paib bala prom ol bala blo em, ane em bin meke dempla stanap prant lo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Da Pero king bin aske ol bala blo Zosep, ‘Wanem wok blo yupla?’ Dempla ansarem, ‘Mipla ol pipol uda lugaut ol animal, seimkain wase ol ate blo mipla. ");
INSERT INTO tcs_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Mipla bin kam po stap lo dis kantri. Mipla bin kam prom da prapa big anggretaim de lo Kanan wea i prapa nogad no kaikai po dem animal blo mipla. Yagar. Mipla aske yu gar, laue ol sebant blo yu po stap ya lo lan blo Gosin.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Da Pero king i bin spik po Zosep, ‘A wa! Yu bos ya lo Izipt. Bikoz papa blo yu ane ol bala blo yu i bin kam po stap ya lo yu, ");
INSERT INTO tcs_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","meke dempla stap lo da prapa bes ples wea i gad ya lo Izipt. Laue dempla po stap lo Gosin. Ip i gad prapa gudman prom dempla wea ol i sabe lugaut animal, meke dempla po bi bosman po lugaut ol animal blo mi tu.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Den Zosep i bin teke papa blo em kam, ane bin meke em stanap prant lo da Pero king, ane Zekop i bin aske God po blese da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Da Pero king i bin aske Zekop, ‘Wanem eiz blo yu?’ ");
INSERT INTO tcs_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Zekop i ansa po da Pero king, ‘Ai bin stap laip po 130 iya wase streinza ane ai bin mata mubraun po ol dipren ples. Dem iya blo mi i mata sot, bikoz ai stil no bin kese eiz blo ol ate blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Zekop i bin aske God po blese da Pero king bipo em bin lego go ane libe aus blo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","So Zosep i bin mata pole ol dem oda blo da Pero king ane em bin suze da bes ples wea i gad de lo Izipt. Diswan ples i bin Ramases ane em bin gibem po papa ane ol bala blo em po stap de. ");
INSERT INTO tcs_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Ane Zosep i bin gibe papa blo em, ane ol bala blo em, ane ebri pikinini blo bala blo em, ol kaikai wiskain ebri pamle i bin nidem. ");
INSERT INTO tcs_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Wa, i no bin gad nating kaikai lo ebri lan blo Izipt ane Kanan, bikoz da prapa big anggretaim i bin kip kam mina nugud. Ol dem pipol i bin kam slaik no bin gad strong prom anggre. ");
INSERT INTO tcs_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Dem pipol blo Izipt ane Kanan bin pei Zosep ol mani blo dempla po kaikai ane Zosep i bin gibe dem pipol ol kaikai. Den Zosep i bin teke dem mani go po baingk blo da Pero. ");
INSERT INTO tcs_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Wen ebri mani prom kantri blo Izipt ane prom da lan blo Kanan bin pinis, dem pipol blo Izipt i bin kam po Zosep, ane singaut, ‘Gibe mipla kaikai! Bambai mipla go ded ya prant wea yu ip yu no go meke enisamting po mipla, bikoz ol mani blo mipla i pinis.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Zosep i bin ansa, ‘Bikoz ol mani blo yupla i pinis, gibe mi ol animal blo yupla, ane ai go gibe yupla kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","So dempla ebriwan i bin teke ol animal blo dempla kam po Zosep ane Zosep i bin teke dem animal wase pei po kaikai. So dempla i bin seinze ol os, sip, gout, buluk, kau ane ol dongki po kaikai. Ane Zosep i bin gibe dempla kaikai, nap po wan iya. ");
INSERT INTO tcs_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Wen dat wan iya i bin pinis, dempla ebriwan bin kambaigen po Zosep ane dempla bin spik, ‘Mipla kan aidem prom yu bos. Ol mani blo mipla i pinis ane ebri animal blo mipla i blo yu nau. I gad nating po gibem po yu, mata mipla ane ol lan blo mipla. ");
INSERT INTO tcs_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Yu kan laue mipla po ded! Pliz gar, elpe mipla! Teke mipla ane ol big gadan eria blo mipla wase pei, den yu ken gibe mipla ol kaikai. Den mipla gobi ol sebant blo da Pero king po gud, ane em gobi bos blo ebridem big gadan eria blo mipla. Mata gibe mipla ol sid po kaikai, solong mipla stap laip ane no ded solong da lan i no gobi empti, nogad ol pipol.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Zosep i bin baie ebridem lan po da Pero king wea kantri blo Izipt. Ebri pipol blo Izipt i bin sele ebri big gadan eria blo dempla, bikoz da prapa big anggretaim i bin mina nugud. Ebri lan blo kantri blo Izipt i bin kam ol lan blo da Pero king po gud. ");
INSERT INTO tcs_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Dem pipol blo Izipt, Zosep i bin meke ebridem pipol ol sebant blo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Mata dem lan blo dem prist wea Zosep i no bin baiem, bikoz dem prist bin gede ol kaikai prom da Pero king. Dempla no nid po sele lan blo dempla. ");
INSERT INTO tcs_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Den Zosep i bin spik po dem pipol, ‘Lisen nau. Ai bin baie yupla ane ol lan blo yupla po da Pero king. Ai go gibe yupla ol sid po plantem. So yupla go ane groem wea dem big gadan eria. ");
INSERT INTO tcs_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Wen dem sid kaikai i raip po katemdaun, yupla mas meke dem sid kaikai po paib ip ane wan ip i blo da Pero king. Ol dem nada po ip blo sid kaikai i blo yupla. Yuzem po gad sid po groem da neks iya, ane po ol kaikai po yupla, ane ol dem nada pipol wea aus blo yupla, ane po ol pikinini blo yupla.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Dem pipol i bin ansa, ‘Yu bin stape mipla prom ded. Bos, yu bin meke gudting po mipla, ane mipla gobi ol sebant blo da Pero king.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Den Zosep i bin meke wan lo wea kantri blo Izipt, ane dat lo i spik diskain, dat wen dem sid blo wit blo dem pipol blo Izipt go raip po katemdaun, dempla mas meke paib dipren ip ane mas gibe wan ip po da Pero king. Ane dis lo i stil de lo dis dei. Mata dem lan blo dem prist i no bin kam lan blo da Pero king. ");
INSERT INTO tcs_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ol dem pipol blo Izrael i bin stap lo kantri blo Izipt, wea da lan blo Gosin. Dempla bin gad ol prapa plenti samting, ane dempla bin kuikwan kam ol plenti pipol ane dempla bin gad ol nadakain plenti pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Zekop i bin stap wea kantri blo Izipt po sebentin iya, ane i bin 147 iya oul. ");
INSERT INTO tcs_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wen taim blo Zekop po lus i bin kam klostu, em bin singaut Zosep po kam po em ane Zekop i bin spik, ‘Pliz gar, meke diswan po mi. Yu mas meke strongpromis po mi, yu go soe mi yu prapa labe mi ane gad rispekt po mi. Dis lasting ai wandem: No bere mi ya lo dis kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Wen ai go ded, teke da bodi blo mi go ausaid prom Izipt ane bere mi wea dat beriolples blo ol pamlelain blo mi.’ Zosep i bin ansa em, ‘Ai go prapa mekem wiskain yu bin askem.’ ");
INSERT INTO tcs_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ane Zekop i bin spik strongwan, ‘Meke diswan nau po mi ya prant lo God.’ So Zosep i bin spik dat strongpromis prant lo God. Den Zekop i bin baue ed blo em ane eso God de lo bed blo em. ");
INSERT INTO tcs_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Apta nau sambodi bin kam ane spik po Zosep diskain, ‘Papa blo yu i klostu po ded.’ Zosep i bin teke tu boi pikinini blo em, Manasa ane Ipreim lo em ane demplatri i bin go po luk Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Sambodi i bin spik Zekop, ‘Boi blo yu Zosep ya kam po luk yu.’ Zekop bin meke emselp strong ane em bin sidaun lo bed blo em. ");
INSERT INTO tcs_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ane Zekop i bin spik po Zosep diskain, ‘Strong AntapGod i bin soe emselp po mi lo da ples blo Luz lo dat lan blo Kanan, ane em bin blese mi de. ");
INSERT INTO tcs_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Em bin spik, “Ai go meke yu kam prapa plenti pipol uda stap wea dempla oun kantri ane uda tok dempla oun langus, ane ai go gibe dis lan blo Kanan po ol pamlelain blo yu, uda go kam apta yu. Dis lan i gobi blo dempla poeba.” ");
INSERT INTO tcs_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","‘Diskaintaim ai go adopte demtu boi blo yu, wea yu bin gad ya lo da lan blo Izipt bipo ai bin kam ya. Demtu, Ipreim ane Manasa i gobi boi blo mi nau, seimkain wase Ruben ane Simion, demtu boi blo mi tu. ");
INSERT INTO tcs_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Bat dem pikinini uda bon apta Ipreim ane Manasa, dempla i gobi ol pikinini blo yu. Dem lan wanem demtu go gedem, i mas kam tru demtu Ipreim ane Manasa. ");
INSERT INTO tcs_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ane Zekop i bin kip tok, ‘Wen ai bin kambaik prom kantri blo Mesapotamia, mama blo yu Reisel, em bin ded lo da lan blo Kanan. I no bin prapa longwei po go po taun blo Eprat ane diswan i da seim taun i kole em Betliem. Ai bin bere em lo said blo rod, da rod i go po Eprat. Diswan i bin meke mi prapa atso.’ ");
INSERT INTO tcs_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Den Zekop bin luk po demtu boi blo Zosep, ane em bin spik, ‘Demtu boi blo yu a?’ ");
INSERT INTO tcs_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Zosep i bin ansa po papa blo em, ‘Wa. Demtu i boi blo mi, wea God i bin gibem po mi ya lo Izipt.’ Ane Zekop i bin spik, ‘Teke demtu kam po mi gar, solong ai go aske God po blese demtu.’ ");
INSERT INTO tcs_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Zekop i kan luk prapa bikoz em bin prapa oulman. Den Zosep bin teke Ipreim ane Manasa kam klostu po em. Zekop i bin kise ane gasu demtu. ");
INSERT INTO tcs_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Den Zekop i bin spik po Zosep, ‘Ai no bin tingk ai go luk yu gen, bat God i bin laue mi po luk yu ane demtu pikinini blo yu tu.’ ");
INSERT INTO tcs_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Den Zosep bin tekemaute Ipreim ane Manasa prom ni blo ate blo demtu ane Zosep i bin nildaun pesdaun prant lo papa blo em. ");
INSERT INTO tcs_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Zosep bin teke demtu tu, Ipreim lo dat leptan blo Zekop, ane Manasa lo dat raitan blo Zekop. ");
INSERT INTO tcs_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Bat Zekop bin krose tu an blo em. Em bin pute em raitan go ausaid ane em bin putem antap lo da ed blo Ipreim, uda bin da smolbala, ane em bin pute em leptan go ausaid ane em bin putem antap lo ed blo Manasa uda i bin da pasbon bala. ");
INSERT INTO tcs_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Zekop i bin aske God po blese Zosep, ane em bin spik diskain: ‘Da God blo ate blo mi Eibram ane papa blo mi Aizak, wea demtu bin meke ebriting wea God i bin spik po demtu po mekem. God i bin da wan uda ebritaim lugaut laip blo mi kam po dis dei nau, ");
INSERT INTO tcs_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ane da einzel uda bin lugaut mi prom ebri badting, em i go blese demtu boi pikinini ya tu. Ane tru demtu, laue neim blo mi po mata stap poeba, ane neim blo ate blo mi Eibram, ane papa blo mi Aizak. Ane laue demtu boi pikinini po gad prapa plenti pamlelain, wea dempla stap ebriwea wea ert.’ ");
INSERT INTO tcs_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Wen Zosep i bin tekenotis dat papa blo em bin pute raitan blo em antap lo ed blo Ipreim, diswan i bin meke Zosep prapa no api. Den Zosep bin kese raitan blo papa blo em, po tekemaut em an prom ed blo Ipreim, po putem lo ed blo Manasa. ");
INSERT INTO tcs_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Zosep spik diskain po papa blo em, ‘Yagar, mai papa, i no demkain! Bikoz dis pikinini ya i da bigwan. Pute raitan blo yu antap lo ed blo em.’ ");
INSERT INTO tcs_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bat Zekop i no bin wandem, ane em bin spik, ‘Ai sabe, mai boi. Pamlelain blo Manasa i go kamwan strong pipol uda stap lo dempla oun kantri. Bat smolbala blo em i go kam mostrong den em, ane pamlelain blo em i go kam prapa mo plenti pipol uda go stap lo dempla oun kantri.’ ");
INSERT INTO tcs_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","So Zekop i bin aske God po blese demtu boi ane em bin spik dis blesing, ‘Wen dem pipol blo Izrael i go blese wananada, dempla go yuze neim blo yutu. Dempla go spik, “Mait God i go blese yu seimkain wiskain God i bin blese Ipreim ane Manasa.” ’ Wea dem tok, Zekop bin meke Ipreim kam pas prant wea Manasa. ");
INSERT INTO tcs_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Den Zekop i bin spik po Zosep, ‘Wa! Ai go ded sun, bat God i go lugaut yu ane teke yu gen gobaigen po da lan blo ol ate blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Diskaintaim ai go gibem po yu wan pat blo da lan, moden ai bin gibem po ol nada bala blo yu. Dat lan wea ai go gibem po yu i da lan wea ai bin tekem prom dem pipol blo Amo wea ai bin pait wea dempla lo big sod ane bounaro blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Den Zekop bin singaut ol boi blo em po kam, ane i bin spik diskain, ‘Kam ane sidaun ya klostu wea mi, solong ai go spik yupla wanem go apen po yupla dat taim de prant. ");
INSERT INTO tcs_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","‘Kam klostu ane lisen, yupla ol boi blo Zekop, lisen po mi. Ai Izrael, papa blo yupla. ");
INSERT INTO tcs_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","‘Ruben, yu pas pikinini blo mi ane yu bin pikinini blo mi wen ai bin prapa strong man. Yu da prapa spesilwan ane strongwan prom ebridem boi blo mi. ");
INSERT INTO tcs_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Bat wailwei blo yu i wase pladwata wea i kan stap. Yu nomo gobi da nambawan bikoz yu bin slip wea wan dem oman blo mi ane yu no bin rispekt bed blo papa blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","‘Simion ane Libai, demtu tu bala. Demtu gad seimkainwei. Demtu man blo mata yuze sod po pait. ");
INSERT INTO tcs_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Yagar. Ai nogo tingk ane meke samting wanem demtu mekem, ane ai nogo zoin wea dem nugud plan blo demtu. Wen demtu bin wail, demtu bin kile ol pipol, ane kate leg blo ol buluk po pan; mekem solong dem buluk kan wagbaut prapa. ");
INSERT INTO tcs_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Simion ane Libai, demtu go gede kers bikoz prom dem wailwei blo demtu, bikoz demtu gad prapa nadakain nugud wail. Demtu go gede kers bikoz prom dem peibaik wei blo demtu, bikoz demtu prapa nogad piling wen demtu i peibaik! Ai go splitemap ol pamlelain blo demtu ebriwea lo dat lan blo Izrael ane meke pamlelain blo demtu stap lo dem nada pamlelain blo Izrael. ");
INSERT INTO tcs_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","‘Zuda, ol bala blo yu i go spik ol gudsamting baut yu. Yu go tere dem pipol uda pait ane gense yu. Yu gobi da bos blo ol pamlelain blo yu. ");
INSERT INTO tcs_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Zuda, boi blo mi, yu wan strong yang laian, uda i bin pinis kambaik prom kaikai wanem em bin kilem. Yu wase laian, nau em rilaks ane leidaun kuaiatwan. Yu wase oman laian, nobodi gad strong po boda em. ");
INSERT INTO tcs_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Da paua blo da king i nogo kamaut prom yu Zuda, ane da rait po kare lo antap, i nogo kamaut prom ol pamlelain blo yu, antil dat taim wen da wan uda i go kam, bikoz i blo em. Em da wan wea ebri pipol i go ona em. ");
INSERT INTO tcs_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Zuda i taiemape yang dongki blo em po greipbain, dat yang dongki i taiemap lo wan spesil greipbain. Em wase ol plasklos blo em wea bladred wain. ");
INSERT INTO tcs_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ai blo Zuda i prapa modak den wain, ane tit blo em i prapa mowait den milk. ");
INSERT INTO tcs_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","‘Zebulun i go stap lo da sanbis blo solwata. Yu gobi da gud angkaples po ol bot, ane baundri blo yu i gobi wea Sidon. ");
INSERT INTO tcs_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","‘Isaka em wan strong dongki, wea em i leidaun melen wea ol baig wea em bin kare ol samting insaid. ");
INSERT INTO tcs_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Bat em luk da ples wea em spel i bin prapa naisples, ane da lan i prapa gudwan. Wa, em godaun meke redi po kare ebriting, ane em redi po wok wase wan sleib. ");
INSERT INTO tcs_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","‘Dan i gobi bos po zaze ol pipol blo em, seimkain wiskain dem nada pamlelain blo Izrael i mekem. ");
INSERT INTO tcs_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan i gobi wan sneik lo said blo da rod, wan bad sneik klostu po busrod, wea em baite da leg blo os, solong dat man uda raidem i go poldaun. ");
INSERT INTO tcs_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ai weit po yu, plizgar po seibe mi, AntapGod! ");
INSERT INTO tcs_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","‘Gad, ol smol mob pipol uda stile samting, go kam po stile ol samting blo em, bat em go apte dempla ane em go kese dempla. ");
INSERT INTO tcs_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","‘Asa go gad lan po groe ol nadakain nais kaikai. Dis kaikai em rait po gibe ol king po kaikai. ");
INSERT INTO tcs_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","‘Naptali i wan red oman dia wea i ran pri, ane i gad ol nais yang pikinini. ");
INSERT INTO tcs_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","‘Zosep i da mein brans blo wan bainplant wea plenti brans i kamaut. Zosep em bainplant klostu lo spring lo wata; ol brans blo em i go gro oba da ston wol. ");
INSERT INTO tcs_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Dem bounaro man i prapa wail man. Ol i bin kam po paite em; dempla bin mata kip paia ol aro po em. ");
INSERT INTO tcs_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bat bou blo em i bin mata stap stret, i no seik, ane tu an blo em, i bin kam strong prom da paua blo da prapa Strong AntapGod blo Zekop, wea ol kolem Bosman uda lugaut sip, da Ston blo Izrael. ");
INSERT INTO tcs_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Lete da God blo ol ate blo mi elpe yu. Lete da Strong AntapGod blese yu wea ol rein po wete dem gadan kaikai blo yu, ane wea dem spring wata wea i go kamaut andanit prom graun. Ane wea yu go gad plenti pikinini ane ol plenti animal. ");
INSERT INTO tcs_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Da blesing wea papa blo yu i bin kesem prom dem ate blo yu, i mobig den blesing wea God i bin mekem po dem maunten wea i mata stap poeba, ane da prapa nais samting prom dem il wea i mata go poeba. Wa. God i po meke ol gudsamting ya po Zosep, wea i bin mekem po bi bos blo ol bala blo em. ");
INSERT INTO tcs_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","‘Benzaman i wan prapa anggre wail bus dog. Wea moningtaim em tere enami blo em, ane wea naittaim em seremaut wanem em bin stilem.’ ");
INSERT INTO tcs_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ebriwan ya i dem tuelb pamlelain blo Izrael, ane diswan i wanem dempla papa Zekop i bin spik po dempla wen em bin aske God po blese dempla, ane ebri gudsamting wanem ebridem bala mas gad. ");
INSERT INTO tcs_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Den Zekop i bin spik po dem boi blo em diskain, ‘Ai go ded sun ane ai go zoine ol pamle blo mi uda bin pinis ded. Pute mi daun lo dem pamlelain blo mi, wea da keib lo da graun blo Epron da It man. ");
INSERT INTO tcs_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Diswan i da seim keib wea da graun lo Makpela, klostu Mamre, lo lan blo Kanan. Diswan da lan wea Eibram i bin baiem prom Epron da It man po kam beriolples blo Eibram godaun. ");
INSERT INTO tcs_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ol bin pute demtu Eibram ane oman blo em, Sera, daun de; ane Aizak ane oman blo em Ribeka tu; ane ai bin pute Lia daun tu. ");
INSERT INTO tcs_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Da lan ane keib de, ate blo mi Eibram i bin baiem prom dem pipol blo It.’ ");
INSERT INTO tcs_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Wen Zekop i bin pinis gibe oda blo em po dem boi blo em, em leidaun gobaik lo bed, ole ane lego laswin blo em, ane em bin ded. ");
INSERT INTO tcs_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Den Zosep bin poldaun antap bodi blo papa blo em ane em bin gasu em. Em bin krai den em bin kise papa blo em. ");
INSERT INTO tcs_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Zosep i bin oda sam sebant blo em, dempla ol pipol uda meke bodi blo ol ded pipol redi po beriol, po rabe oil lo bodi blo papa blo em. Den dem man i bin rabe ol diprenkain oil lo dat bodi blo Zekop solong bodi blo em nogo ratan. ");
INSERT INTO tcs_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","I teke poti dei po meke diswan wea i mas rabe oil wea ded bodi po meke da bodi redi. Ane dem pipol blo Izipt bin krai po Zekop po sebenti dei. ");
INSERT INTO tcs_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Wen da taim blo krai po Zekop i bin pinis nau, Zosep i spik po dem bigman blo gabman blo da Pero king, ‘Pliz gar, yupla ken meke diswan, ane go ane spik po da Pero king diskain po mi: ");
INSERT INTO tcs_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Spik da Pero king, papa blo mi bin meke mi po spik strongpromis. Em bin spik po mi, “Ai go ded sun. Teke bodi blo mi go po lan blo Kanan. Pute mi daun de wea da keib, da beriolples blo ol pamle blo mi.” Pliz gar, laue mi po go po Kanan, solong ai go pute papa blo mi daun de. Den ai go kambaigen.’ ");
INSERT INTO tcs_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Da Pero king i bin ansa, ‘Go po Kanan, ane pute papa blo yu daun wiskain em bin meke yu promis em.’ ");
INSERT INTO tcs_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Zosep i bin go po Kanan po pute papa blo em daun. Wen Zosep i bin go po Kanan plenti pipol bin go wea em: dem bigman blo gabman blo da Pero king, dem bigman blo pamle blo da Pero king, ane ebridem lida blo kantri blo Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Ebri pamle blo Zosep, ol bala blo em, ane ebri pamle blo papa blo em bin go tu. Mata dem smolpikinini blo dempla, ane ol sip, gout, buluk ane kau, i bin stap wea da lan blo Gosin. ");
INSERT INTO tcs_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Plenti man i bin draibe paiting oskariz go ane prapa nadakain bigmob blo pipol bin go tu. ");
INSERT INTO tcs_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Den dempla bin kam wea da ples blo Atad. Diswan i da ples klostu po Zodan Riba wea ol pipol i yuzem po splitemap wit prom dem nada pat blo da witplant. Wea dat ples dem bigmob blo pipol i bin base prapa bigkrai, ane Zosep bin meke taim blo krai po papa blo em po seben dei. ");
INSERT INTO tcs_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wen dem pipol blo Kanan i bin luk krai blo pipol wea dat ples blo Atad, dempla spik, ‘Diswan i mina bigkrai blo dem pipol blo Izipt.’ Wagar. Dem pipol blo Kanan i bin kole dat ples Abelmizraim, wea Zuwislangus i min ‘krai blo ol pipol blo Izipt’. Diswan i klostu Zodan Riba. ");
INSERT INTO tcs_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Dem boi blo Zekop i bin mekem wiskain papa blo dempla bin oda dempla po mekem. ");
INSERT INTO tcs_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Dempla bin kare bodi blo Zekop go po da lan blo Kanan ane bin putem daun wea da keib lo Makpela, da lan klostu Mamre, wea Eibram i bin baiem prom Epron da It man, po bi beriolples. ");
INSERT INTO tcs_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Apta nau wen Zosep bin pute papa blo em daun, Zosep, ol bala blo em, ane ebriwan uda bin de, i bin gobaigen po Izipt. ");
INSERT INTO tcs_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Apta nau wen papa blo dempla bin pinis ded, dem bala blo Zosep ol stat po prait nau. Dempla tok po wananada, ‘Ei! Mait Zosep i stil gad wail gense yumpla ane em wande peibaik yumpla po ebri badting wea yumpla bin mekem po em!’ ");
INSERT INTO tcs_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Dem bala blo Zosep i bin sane mesiz go po Zosep, ‘Bipo papa blo mipla i bin ded, ");
INSERT INTO tcs_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","em bin oda mipla po spik yu diskain, “Pliz gar pogibe mipla ol bala blo yu po dat nugudting wea mipla i bin mekem gense yu, po dat nugudsin dempla i bin mekem gense yu.” Pliz gar pogibe mipla, ol sebant blo da God wea papa blo yu i wosip.’ Zosep i bin prapa bigkrai wen em bin lisen dis tok. ");
INSERT INTO tcs_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Den dem bala blo Zosep dempla bin kam ane kuikwan sake demplaselp pesdaun lo da graun prant lo Zosep, ane dempla bin spik po Zosep, ‘Wa! Mipla i ol sleib blo yu nau.’ ");
INSERT INTO tcs_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Bat Zosep spik po dempla, ‘No prait! Ai kan zaze yupla ane panis yupla. Ai no God. ");
INSERT INTO tcs_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Yupla bin wande meke ol nugudting gense mi, bat God i bin seinze dat badting po gudting. God i bin meke mi sekanbos blo Izipt solong ai ken seibe dem prapa plenti pipol. ");
INSERT INTO tcs_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Wa, yupla no prait. Ai maiselp i go lugaut yupla ane ol pikinini blo yupla.’ Wea diswei Zosep i bin meke dempla pilgud ane tok naiswei po dem bala blo em. ");
INSERT INTO tcs_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Zosep i bin mata stap lo kantri blo Izipt, em ane ol pamle blo papa blo em. Zosep bin stap laip po 110 iya. ");
INSERT INTO tcs_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Zosep i bin stap laip po luk tri zenareisan blo pamlelain blo boi blo em Ipreim. Zosep bin luk dem pikinini blo Makir uda boi blo Manasa. Em bin trite dem pikinini wase pikinini blo em. ");
INSERT INTO tcs_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Den Zosep i bin spik po ol bala blo em, ‘Ai go ded sun, bat God i go prapa kam po elpe yupla, ane teke yupla go ausaid prom dis lan go po da lan wea God i bin spik em go gibem po Eibram, po Aizak, ane po Zekop.’ ");
INSERT INTO tcs_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Den Zosep i bin meke dem pipol blo Izrael po meke dis strongpromis prant lo God. Em i bin spik diskain, ‘Wen God i go kam po elpe yumpla gobaigen po Kanan, yupla mas kare dem bon blo mi go prom dis ples po Kanan.’ ");
INSERT INTO tcs_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Den Zosep em bin 110 iya oul wen em bin ded. Dempla i bin rabe oil lo da bodi blo Zosep ane dempla bin pute em insaid wea kopen de lo Izipt. ");
INSERT INTO tcs_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Bipo Izrael i bin gad king, dem zaziz i bin rule dem pipol. Wea dat seimtaim nau i bin gad wan man, neim blo em Elimalek. Em blo pamlelain blo Eprat. Em bin gad oman blo em, neim blo em Nomi ane tu boi blo demtu, Malon ane Kilion. Dempla ol bin stap lo da taun neim Betliem lo Zuda. Wea da seimtaim nau i bin kam prapa drai, nogad no rein, ol kan groe kaikai lo lan blo dempla. So Elimalek i bin mata mub teke pamle blo em go po da nada kantri blo Moab. Wail ol i bin stap lo Moab, ");
INSERT INTO tcs_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Elimalek i bin ded gar. Wen em bin ded i bin libe Nomi ane tu boi blo em. ");
INSERT INTO tcs_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Demtu boi bin maret tu oman prom Moab, wan bin maret lo Opa, nadawan i bin maret lo Rut. Wen demtu bin maret, dempla bin stap de po ten iya. Den apta ten iya, ");
INSERT INTO tcs_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","demtu boi i bin ded nau. I bin mata libe Nomi emselp wea em no bin gad man ane demtu boi blo em, Malon ane Kilion i bin ded gar. ");
INSERT INTO tcs_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Nau Nomi ane tu dotalo blo em bin lisen da AntapGod i bin blese dem pipol blo em lo Zuda, gibe dempla gud rein ane plenti kaikai bin gro. So Nomi ane tu dotalo blo em i bin meke redi po libe kantri blo Moab gobaigen po kantri blo Nomi. ");
INSERT INTO tcs_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Dempla bin libe Moab wea ol i bin stap, ane ol i bin go tugeda gobaik lo Zuda. ");
INSERT INTO tcs_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Bat wen dempla i bin go lo rod, Nomi em i spik po tu dotalo blo em, ‘Yagar! Yutu mata gobaik ane stap lo mama blo yutu. Ubi blo mi i po da AntapGod go blese yutu wanem yutu bin mekem po mi ane po dem man blo yutu uda bin ded nau. ");
INSERT INTO tcs_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Ane da AntapGod i go paine man po yutu wea yutu go maret gen.’ Nomi i bin kise demtu ane spik yawo. Demtu gar mata krai. ");
INSERT INTO tcs_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Demtu bin spik po em, ‘No gar. Mitu wande go lo yu po pipol blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Bat Nomi bin tok po demtu, ‘Yutu mata gobaigen mai tu gel. Ei! Wanem yutu wande kam lo mi po? Yutu tingk ai go gad nada tu boi gen po yutu go maret a? ");
INSERT INTO tcs_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Yutu mata gobaik mai tu gel. Mi, ai ouloman, ai nogo maret gen. Iben ip ai go maret tunait ai nogo bone tu boi. ");
INSERT INTO tcs_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Yutu nogo weit po demtu beibi po gro po kam man ane maret demtu. Diskain pasin i stape yutu prom maret lo nada man. Nono gar, mai tu gel. Yutu sabe diskain pasin i nugud. Da AntapGod i prapa gense mi ane ai gad nating. Laip blo mi i moad wea yutu.’ ");
INSERT INTO tcs_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Demtu bin lak krai gen. Den Opa mata kise madalo blo em ane em bin spik yawo lo em. Bat Rut em i bin kese Nomi. Em i no wande libe Nomi, em i wande mata stap lo em. ");
INSERT INTO tcs_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Nomi bin spik po em, ‘Ei, Rut! Opa gar, em i mata gobaik po pipol blo em ane dem god blo em. Yu mata gobaigen ane stap lo pipol blo yu tu.’ ");
INSERT INTO tcs_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Rut em i bin spik diskain, ‘Yu no pose mi po gobaik. Ai bin libe ebriting blo mi biain, ai go mata kam lo yu. Lete mi go lo yu. Wiswei yu go, ai go de tu, wiswei yu go stap, ai go stap diskain tu. Pipol blo yu i gobi pipol blo mi tu ane God blo yu i gobi God blo mi tu. ");
INSERT INTO tcs_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ai go ded ane ol i go bere mi wea da seimples wea ol i go bere yu. Ai bin spik God po panse mi ip ai no kipe promis blo mi dat mata ded go separeit mi prom yu!’ ");
INSERT INTO tcs_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Wen Nomi bin luk Rut gibap emselp po go lo em, Nomi nomo spik demkain gen. ");
INSERT INTO tcs_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Demtu bin kip wagbaut lo rod antil demtu kese Betliem. Wen demtu bin mangi de, ebri pipol lo Betliem prapa nadakain api po luk Nomi. Dem oman blo de, ol bin spik po wananada diskain, ‘Diswan prapa Nomi, a?” ");
INSERT INTO tcs_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Nomi i bin ansa dempla, ‘No kole mi Nomi, bikoz dat neim i min “api”. Ane ai no api oman nau. Yupla kole mi Mara, bikoz da Strong AntapGod i bin meke laip blo mi mina nadakain nugud. ");
INSERT INTO tcs_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Wen ai bin go prom dis ples ai bin gad ebriting ane Strong AntapGod i bin teke mi kambaik wea ai nogad nating. Wanem yupla kole mi Nomi po? Da Strong AntapGod i bin panse mi ane gibe mi tumas trabol.’ ");
INSERT INTO tcs_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","So Nomi i bin kambaik prom Moab ane em i bin teke dotalo blo em Rut kam wea em. Wen demtu bin kesem lo Betliem i bin taim po stat kate ol dem balisid wea dem gadanples blo de. ");
INSERT INTO tcs_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Nau, de lo Betliem i bin gad wan risman, elda blo da taun. Neim blo em Boaz. Dis man em i prapa klostupamle blo Elimalek. Elimalek em i da ded man blo Nomi. ");
INSERT INTO tcs_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Wandei Rut i bin spik po Nomi, ‘Plizgar mama, lete mi go po dem gadanples. Maitbi i gad sambodi de po lete mi pikemap dem leptoba sidkaikai blo bali ol i bin libem biain.’ Nomi bin spik, ‘Orait mai gel. Yu trai go.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","So Rut em bin goaut lo dem gadanples po pikemap dem leptoba sidkaikai blo bali wea dem wokman i bin libem biain. Em bin paindaut em bin wok wea gadanples blo Boaz, pamle blo padalo blo em, Elimalek. ");
INSERT INTO tcs_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Wail Rut i bin wok, Boaz i bin mangi prom Betliem. Em i bin grite ol wokman blo em diskain, ‘Da AntapGod i de wea yupla.’ Dempla ansarem, ‘Da AntapGod blese yu tu.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Boaz bin aske boswokman blo em, ‘Uda da yangoman de wok ane wea em kam prom?’ ");
INSERT INTO tcs_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Dat bosman i spik, ‘Dis oman, em no blo ya. Em bin kam wea Nomi. Em i oman blo kantri blo Moab. ");
INSERT INTO tcs_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Em bin aske mi dis moning ip em ken pole dem wokman biain solong em ken pikemap dem leptoba sidkaikai. Em wok prapa ad. Em i mina gudwoka. Em bin wok prom elimoning, ane em stil wok nau. Em mata bin gad sot spel, lo smolseid de.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Boaz bin go ane spik po Rut, ‘Lisen po mi mai gel. Stap ya ane wok ya lo dis gadanples blo mi. No go po dem nada gadanples. Yu zoine dem oman uda wok po mi. Yu pole dempla biain ane pikemap dem leptoba kaikai. ");
INSERT INTO tcs_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Yu luk wea dem oman wok, yu pole dempla. Ai bin wone dem yangman no po pute an lo yu. Wen yu wande dringk wata, no prait. Mata go elpe yuselp prom watazag wea dempla i bin teke wata prom wel.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Rut mata poldaun pesdaun prant lo Boaz ane eso po em. Em i spik, ‘Auken yu meke gudpasin po mi? Yu sabe ai prom nada kantri.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","‘Wa, ai sabe’, Boaz i bin ansa em. ‘Ai bin lisenbaut dem gudpasin yu bin soem po madalo blo yu, da taim wen man blo yu bin ded. Yu bin mata libe mama ane papa blo yu biain lo ples blo yupla, ane yu bin kam ya ane stap lo pipol wea yu no sabe dempla. ");
INSERT INTO tcs_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ubi blo mi i diskain, da AntapGod, God blo Izrael, em i go blese yu po demting wanem yu bin mekem, ane em i go lukapta yu ane em i go gibe yu eniting wanem yu wandem.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Rut i bin spik, ‘Bos. Ai mina bigeso wanem yu bin spik po mi. Ai go trai po meke demkain pasin. Yu bin meke mi pil prapa orait wen yu bin spik demkain naiswei po mi. Yu sabe ai no wase dem wokman blo yu, ai louklas oman.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Dinataim bin kesem, Boaz i bin ala po em, ‘Mai gel, yu mata kam ya ane kaikai wea mipla. Yu ken go soke bred wea wain tu.’ Rut em bin sidaun melen lo dem wokman ane Boaz i bin gibe em sid kaikai ol rosem. Em bin kaikai antil em bin belipul. ");
INSERT INTO tcs_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Wen Rut i bin gobaigen po wok, Boaz bin oda dem yangman blo em diskain, ‘Yupla luk da oman de, lete em pikemap dem sidkaikai de melen lo yupla ane no stape em. ");
INSERT INTO tcs_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ane yupla tekemaut sam dem sidkaikai prom bandol blo yupla ane sakem wea graun solong Rut ken pikemap dem kaikai. Ane no gibe em adtaim gar!’ ");
INSERT INTO tcs_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Orait. So Rut i bin mata pikemap dem sidkaikai ol dei antil da san i bin godaun. Den em bin tekemaut ane sakwei da nugud pat blo da sidkaikai. Ane wen em i teke da gudpat i bin gad plenti kaikai. Em bin klosap meke ten kilo. ");
INSERT INTO tcs_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Em bin kare sidkaikai gobaik po da taun, soem po madalo blo em. Ane antap dem sidkaikai, Rut bin gibe em da leptoba dina blo em. ");
INSERT INTO tcs_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Nomi i bin prapa atzamp. Em spik, ‘Ei, tumas! Wea yu bin pikemap dem sidkaikai prom? Wea yu bin wok? Ubi blo mi po da AntapGod go mina blese da wan uda bin elpe yu!’ So Rut i bin spik po em, ‘Ai bin wok tidei wea gadanples blo Boaz.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Nomi bin spik po em, ‘Ubi blo mi po da AntapGod go mina blese Boaz. Em soe gudpasin blo em po yumi ane em rispekt ded man blo yu.’ Den Nomi i bin spik, ‘Boaz em i prapa klostu pamle blo yumi. Em da wan uda mas prapa lukapta yumi.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Den Rut i bin ansarem, ‘Nadating em i bin spik, ai mas gobaik ebridei po wok lo da gadanples antil ebri wok blo da gadan i go pinis.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Nomi i bin spik po em, ‘Datwei i mina gud. Mekem wanem em spik. Yu kipgo wok wea dem wokinggel wea gadanples blo Boaz. Yu zoin lo dempla antil ebri wok i go pinis. Ai sabe yu gobi orait de, bikoz wea dem nada gadanples mait dem man go ambag yu.’ ");
INSERT INTO tcs_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Rut em i bin wok klostu lo dem nada oman lo gadan blo Boaz. Em i bin pikemap sidkaikai lo dempla antil ebri wok i bin pinis lo da gadan. Den dempla bin go po nada gadanples blo Boaz. Dat gadanples i blo witsid. So dempla bin wok de nau, kate ol dem witsid antil wok i bin pinis. Ebrinait Rut i bin gobaik aus blo madalo. ");
INSERT INTO tcs_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Wandei Nomi i bin spik po Rut, ‘Mai gel. Ai trai go paine man po yu wea em gad ebriting ane yu go stap lo em ane em go lukapta yu. ");
INSERT INTO tcs_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Yu sabe diskain, Boaz em i klostupamle blo yumi, ane em i bin mina gud. Em bin lete yu po pikemap dem sidkaikai. Dis nait em i go wok gen lo gadanples blo em wea i tekemaut dem witsid prom dem graspat. ");
INSERT INTO tcs_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ai wande yu go mekem wanem ai go spik yu. Orait. Yu go swim, pute nais sentoil ane yu were da prapa gud klos blo yu, da beswan. Wen yu pinis, ai wande yu po go stretwei go po da ples wea Boaz i wok. Bat no lete em po luk yu. Yu weit em de antil em go pinis kaikai. ");
INSERT INTO tcs_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Yu mas luk ebriting. Luk wea em i go slip. Wen em dedslip, yu go insaid ane tekemaut dem kaba prom legsaid blo em ane leidaun wea put blo em. Wen em gedap prom slip, em i go spik yu wanem po mekem.’ ");
INSERT INTO tcs_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Rut i bin ansa po Nomi, ‘Wa! Ai go meke ebriting wanem yu bin spik mi po mekem.’ ");
INSERT INTO tcs_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","So dat nait Rut i bin godaun po da ples wea Boaz bin wok ane em bin meke demting wiskain madalo blo em bin spik em po mekem. ");
INSERT INTO tcs_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Apta Boaz bin pinis kaikai, em i bin pilgud nau. Den em bin go leidaun longsaid lo big ip blo sidkaikai. Wen em bin slip prapa dedslip, Rut i bin go po em kuaiatwan ane em bin tekemaut da kaba prom em leg ane leidaun lo legsaid blo em. ");
INSERT INTO tcs_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Klostu po melennait, Boaz em i gedap prom slip ane em rol go po nadasaid. Em i zamp, ‘Ei! Uda diswan!’ Em paine oman leidaun lo legsaid blo em. ");
INSERT INTO tcs_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Boaz bin askem, ‘Uda yu?’ Rut em i bin ansa, ‘Mi Rut, da wan uda bin wok po yu. Teke end blo da kaba ane kaba mi bikoz yu da man uda go lukapta mi.’ ");
INSERT INTO tcs_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boaz bin spik po em, ‘Mai gel, AntapGod go prapa blese yu. Da gudpasin yu bin soem po mi i mobig den da gudpasin yu bin soem po Nomi de pas. Yu no bin lukraun po yangman po maret nomata em gad gudsamting o em gad nating. ");
INSERT INTO tcs_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Nau mai gel, no prait. Ai go meke ebriting wanem yu aske mi po mekem. Ebriwan lo taun blo yumi sabe wiskain gudpasin oman yu. ");
INSERT INTO tcs_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Wa i tru, ai pamle blo yu. Ai da man uda spostu lukapta yu. Bat i gad nada man uda moklostu pamle po yutu. ");
INSERT INTO tcs_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Stap ya po dis nait ane wen i go moning ai go tok po da man. Ip dat man i go gri po maret yu, den i orait. Bat ip em nogo gri, den ai promis prant lo God ai go maret yu. Den ai go baie lan blo Elimalek baigen po yu. Wan truting, God em i laip. Ane nada tru samting, ai go meke disting ya, so leidaun ya antil moning.’ ");
INSERT INTO tcs_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Rut mata leidaun lo legsaid blo Boaz antil moning. Rut i bin gedap prapa elimoning wea pipol kan megaraut samting prapa. Boaz bin spik po dem wokman blo em, ‘Ai no wande pipol po sabe i bin gad oman ya wea dis wokples.’ ");
INSERT INTO tcs_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Den Boaz bin spik po Rut, ‘Teke kout blo yu kam ane spredemaut em ya.’ Em i bin kapsaid tuenti kilo dem sidkaikai lo da kout. Den em bin elpe em pute da baig lo baik blo em. Den Rut i bin gobaigen po taun. ");
INSERT INTO tcs_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Em bin go po aus blo madalo blo em ane madalo blo em bin aske em, ‘Wiswei mai gel? Wanem bin apen?’ Rut em ansa po Nomi, ‘Boaz bin meke olkainting po mi. ");
INSERT INTO tcs_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Nadating tu em bin mekem, em bin gibe mi dis tuenti kilo sidkaikai ya. Boaz bin spik mi diskain, “Yu mas kare samting gobaik po madalo blo yu.” ’ ");
INSERT INTO tcs_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Den Nomi bin spik po em, ‘No wori mai gel, mata weit. Taim go kam yumi go lisen wanem i go apen. Dat man Boaz, em nogo spel antil em go pinis meke demting wanem em bin promis em go mekem tidei.’ ");
INSERT INTO tcs_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boaz bin go po da mitingples blo da taun de lo taun geit ane em i sidaun de. Bambai da seim man wea em ane Rut i bin tokbaut, da man blo da pamlelain blo Elimalek, i bin wagbaut kam nau ane pasbai em. Boaz bin ala po em, ‘Bala, kam ya pas, plizgar ane sidaun ya. Ai gad samting po spik yu.’ So da man bin kam ane sidaun de. ");
INSERT INTO tcs_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Den Boaz i bin singaut ten elda blo da taun ane aske dempla po sidaun lo demtu solong dempla go witnis demting demtu go tokbaut. ");
INSERT INTO tcs_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Boaz i bin spik, ‘Yu pamle blo mi. Yu sabe Nomi, widooman blo Elimalek uda bin kambaik prom Moab. Em wande sele da gadanples blo Elimalek. ");
INSERT INTO tcs_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ai bin promis po spik yu baut disting ya. Ip yu wande baie da lan, baiem nau prant wea dem witnis ya sidaun. Yu moklostu po Elimalek. Yu gad pas rait po baiem, bat ip yu no wande baiem, spik mi nau solong ai go sabe, bikoz ai da neks pamle apta yu.’ Da man bin ansa, ‘Wa. Ai go baiem.’ ");
INSERT INTO tcs_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Den Boaz bin spik, ‘Rimemba, ip yu baie dis lan prom Nomi, yu mas maret Rut tu, da widooman prom Moab. Dem pikinini em i go gad prom yu, dempla no gobi pikinini blo yu. Dempla gobi wea da pamlelain blo da ded man blo Rut solong da lan go pasem godaun po dem pikinini. Rimemba diswan kastamlo blo mipla.’ ");
INSERT INTO tcs_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Da lida blo da pamle bin spik, ‘Nono! Ai no wande baie da lan bikoz mai pikinini nogad no rait po da lan. Nomata ai da klostupamle blo Nomi, ai no wande yuze rait blo mi. Ai gibe yu pulrait po baie da lan bikoz ai no wandem.’ ");
INSERT INTO tcs_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Longtaim lo Izrael, kastamlo blo dempla, ip dem pipol treid o baie samting baik, ol mas tekemaut sandol blo dempla ane gibem po da man uda bin sele da samting po dempla. Diswan po prubem dempla bin baie dat samting. ");
INSERT INTO tcs_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Dat lida blo da pamle i bin spik po Boaz, ‘Yu mata baie da lan.’ Den em bin tekemaut sandol blo em ane gibem po Boaz. ");
INSERT INTO tcs_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Den Boaz bin spik po dem nada elda ane ol dem pipol de, ‘Dat lan blo Elimalek, Kilion ane Malon, yupla ebriwan witnis tidei ai bin baie da lan prom Nomi. ");
INSERT INTO tcs_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ane nadating, Rut, da Moab widooman blo Malon, em gobi oman blo mi. Ai meke disting so ded bala propati go stap wea pamle blo em. Diswei neim blo em nogo separeit prom ol pamle blo em ane lan blo em. Yupla bin witnis diswan tidei.’ ");
INSERT INTO tcs_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Dem elda ane ol dem nada pipol bin spik. ‘Orait. Mipla witnis. Mipla prea diskain, da AntapGod meke da oman blo yu wase Reisel ane Lia, demtu prapa bigaka blo yumpla. Demtu bin gad plenti pikinini prom Zekop, daswai dem pipol blo Izrael i plenti. Yu go kam impotant man blo da kantri blo Eprata ane bigman wea Betliem. ");
INSERT INTO tcs_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Da AntapGod go gibe yu ane Rut seimkain plenti pikinini wase da pamle blo Perez, boi blo Zuda ane Tamar.’ ");
INSERT INTO tcs_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Orait, Boaz bin teke Rut ane maret em. Den da AntapGod i bin blese em ane em bin kam pamle, ane em i bon wan boi pikinini. ");
INSERT INTO tcs_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Dem oman prom da taun i bin spik po Nomi, ‘Preiz da AntapGod! Mipla mina big eso po da AntapGod. Em bin gibe yu dis pikinini. Em da wan uda go lukapta yu. Em gobi impotant man lo Izrael. ");
INSERT INTO tcs_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Rut, dis dotalo yu prapa labem, em bin lugaut yu mobeta den ip yu gad seben boi. Dis boi wanem em bin bon, go seinze laip blo yu ane wen em i go kam big, em go lukapta yu wen yu go kam ouloman.’ ");
INSERT INTO tcs_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Nomi bin teke da boi ane kare em ane i bin prapa lukapta em. ");
INSERT INTO tcs_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Dem oman neiba blo Nomi i bin neime da pikinini Obed ane ol bin spik diskain, ‘Nau Nomi i gad boibeibi.’ Apta nau, Obed bin papa blo Zesi ane Zesi bin papa blo King Deibid. ");
INSERT INTO tcs_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Diswan pamlelain blo Perez raitap po King Deibid: Perez i bin papa blo Ezron. ");
INSERT INTO tcs_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Ezron i bin papa blo Ram. Ram i bin papa blo Aminadab. ");
INSERT INTO tcs_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadab i bin papa blo Nason. Nason i bin papa blo Salmon. ");
INSERT INTO tcs_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon i bin papa blo Boaz. Boaz i bin papa blo Obed. ");
INSERT INTO tcs_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed i bin papa blo Zesi. Zesi i bin papa blo Deibid. ");
INSERT INTO tcs_vpl VALUES ("JH1_1","033_1_1","JON","1","1","1","Diswan stori blo Zona. Zona em bin boi blo Amatai. Wandei God bin spik diskain po em, ");
INSERT INTO tcs_vpl VALUES ("JH1_2","033_1_2","JON","1","2","2","‘Yu mas go nau po da big siti blo Ninaba. Ol dem pipol de ol nadakain nugud. Yu mas go spik po dempla ol mas tan prom dem nugudwei blo dempla. Bambai ai go panse dempla.’ ");
INSERT INTO tcs_vpl VALUES ("JH1_3","033_1_3","JON","1","3","3","Bat Zona no bin wande lisen po God. Em bin ranwei prom da AntapGod go nadawei prom Ninaba. Em bin go wea da koslain godaun po Zopa ane em bin baie tikit po seilbaut go wea bot go po Tasis. Em i bin go ane em bin zamp insaid da bot ane seilbaut prom Zopa. Em bin ranwei prom da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("JH1_4","033_1_4","JON","1","4","4","Bat God i bin meke strongwin kamap ane da win dat rap da bot bin klostu brok ane klostu singdaun. ");
INSERT INTO tcs_vpl VALUES ("JH1_5","033_1_5","JON","1","5","5","So dem kru bin prapa prait ane dempla bin stat po prea po ol dem laigod blo dempla. Den ol bin sakwei dem kago ausaid lo solwata po meke da bot kam molait. Wail demting bin apen Zona bin prapa dedslip andanit lo dek. ");
INSERT INTO tcs_vpl VALUES ("JH1_6","033_1_6","JON","1","6","6","Da skipa blo da bot i bin go ane spik po em diskain, ‘Ei! Wiswei? Wanem yu slip diskain po? Gedap ane prea po god blo yu. Mait em go sore po yumpla ane yumpla nogo ded.’ ");
INSERT INTO tcs_vpl VALUES ("JH1_7","033_1_7","JON","1","7","7","Seimtaim, dem kru bin stat tok po wananada, ‘Yumpla go sake dais po paindaut uda bin meke dis trabol.’ Dais bin poldaun prant wea Zona, so dempla bin sabe em da wan uda bin meke ol dis trabol. ");
INSERT INTO tcs_vpl VALUES ("JH1_8","033_1_8","JON","1","8","8","Dempla bin lego ol kuestin po em, ‘Ei Zona! Yu bin meke ol dis trabol a? Uda yu? Wea yu kam prom? Wanem da kantri blo yu? Uda ol kantriman blo yu? Wanem wok yu oltaim mekem?’ ");
INSERT INTO tcs_vpl VALUES ("JH1_9","033_1_9","JON","1","9","9","Zona bin ansa po dempla, ‘Ai Ibruman ane ai pole da AntapGod blo eben de antap. Em da seimwan uda bin meke da solwata ane da drai lan.’ ");
INSERT INTO tcs_vpl VALUES ("JH1_10","033_1_10","JON","1","10","10","Zona bin kip yan po dempla ane dempla bin sabe nau em bin ranwei prom da AntapGod. Wen dem kru bin lisen diswan ol bin prapa prait. Den ol bin spik po em, ‘Ei! Yu prapa dugi! Watpo yu bin mekem diskain?’ ");
INSERT INTO tcs_vpl VALUES ("JH1_11","033_1_11","JON","1","11","11","Da win bin kam mostrong ane dem kru bin aske Zona diskain, ‘Wanem mipla go mekem po yu po meke da win ane da si kamdaun?’ ");
INSERT INTO tcs_vpl VALUES ("JH1_12","033_1_12","JON","1","12","12","So Zona i bin ansa dempla baigen, ‘Sake mi insaid lo solwata, ane da bigsi ane da win i go kamdaun. Diswan i polt blo mi. Ai bin meke dis trabol kam po yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("JH1_13","033_1_13","JON","1","13","13","Dem kru no bin wande sake em ausaid. So dempla bin trai po pul ad po kese sanbis. Bat ol kan, i bin tuad po dempla bikoz da win i bin kam mina strong. ");
INSERT INTO tcs_vpl VALUES ("JH1_14","033_1_14","JON","1","14","14","Dempla bin singaut po da AntapGod, ‘Plizgar! Yu no panse mipla ane kile mipla po seik blo dis man ya uda bin ranwei prom yu.’ ");
INSERT INTO tcs_vpl VALUES ("JH1_15","033_1_15","JON","1","15","15","So den, dempla bin kese Zona ane sakem ausaid lo solwata. Stretwei da win bin kamdaun. ");
INSERT INTO tcs_vpl VALUES ("JH1_16","033_1_16","JON","1","16","16","Wen dempla bin luk, da solwata i bin kam wase gris, wantaim dempla bin prapa akan. Dempla bin kile wan animal ane ol bin banem meke sakripais po da AntapGod ane dempla bin meke promis po pole da AntapGod. ");
INSERT INTO tcs_vpl VALUES ("JH1_17","033_1_17","JON","1","17","17","Da AntapGod bin meke wan bigpis swim go po Zona. Da bigpis bin swelemdaun Zona. Em bin stap insaid wea da bigpis po tri dei ane tri nait. ");
INSERT INTO tcs_vpl VALUES ("JH2_1","033_2_1","JON","2","1","1","So Zona i bin prea prom insaid da bigpis po da AntapGod blo em. ");
INSERT INTO tcs_vpl VALUES ("JH2_2","033_2_2","JON","2","2","2","Em prea diskain: ‘Melen wea trabol blo mi ai bin singaut po God, ane em bin ansa mi. Prom insaid da greib ai bin singaut po elp, ane yu bin lisen krai blo mi. ");
INSERT INTO tcs_vpl VALUES ("JH2_3","033_2_3","JON","2","3","3","Yu bin sakwei mi insaid wea prapa dipwata, raitandanit wea da batam. Mata wata ebriwea ane dem prapa bigweib bin role mi raun ane raun ane ol bin kaba mi. ");
INSERT INTO tcs_vpl VALUES ("JH2_4","033_2_4","JON","2","4","4","Ai bin tingk nau, i bin wase God i bin puse mi go longwei prom em. Ai bin tingk nau ai nogo luk da oli Tempol blo yu gen. ");
INSERT INTO tcs_vpl VALUES ("JH2_5","033_2_5","JON","2","5","5","‘Ai bin singdaun wea da prapa dipwata, sigras pas wea ed blo mi. ");
INSERT INTO tcs_vpl VALUES ("JH2_6","033_2_6","JON","2","6","6","Ane ai bin rait daun wea stat blo dem maunten, de andanit insaid wea da solwata. Ai bin tingk ai go lok ausaid prom laip, wea dem doa i go mata lok poeba. Bat yu, AntapGod blo mi, yu bin seibe mi prom da greib ane yu bin gibe laip blo mi baigen po mi. ");
INSERT INTO tcs_vpl VALUES ("JH2_7","033_2_7","JON","2","7","7","AntapGod, wen ai bin klostu pinis, ai bin tingbaut yu insaid da oli Tempol blo yu ane yu bin lisen prea blo mi. ");
INSERT INTO tcs_vpl VALUES ("JH2_8","033_2_8","JON","2","8","8","Demwan uda pole dem laigod ane tane baik lo God, no go gede gudlaip wanem God i wande gibe dempla. ");
INSERT INTO tcs_vpl VALUES ("JH2_9","033_2_9","JON","2","9","9","Po mi nau, ai go mata preize yu ane gibe mina bigeso po yu. Ai go meke opring, preiz opring po yu. Ai go kipe ol dem promis ai bin mekem po yu. Mata yu da AntapGod ken seibe ebribodi.’ ");
INSERT INTO tcs_vpl VALUES ("JH2_10","033_2_10","JON","2","10","10","Den da AntapGod i bin spik po da bigpis po spiu Zona antap lo sanbis. ");
INSERT INTO tcs_vpl VALUES ("JH3_1","033_3_1","JON","3","1","1","Den da AntapGod i bin spik gen po Zona diskain: ");
INSERT INTO tcs_vpl VALUES ("JH3_2","033_3_2","JON","3","2","2","‘Ei! Stanap ane go po da big siti blo Ninaba ane pase dis zazment mesiz ya wanem ai bin pinis gibe yu.’ ");
INSERT INTO tcs_vpl VALUES ("JH3_3","033_3_3","JON","3","3","3","So nau Zona bin lisen da oda blo da AntapGod ane stretwei em bin go po da siti blo Ninaba. Dat siti i bin dat big i bin teke tri dei po wagbaut go kros. ");
INSERT INTO tcs_vpl VALUES ("JH3_4","033_3_4","JON","3","4","4","Zona bin wagbaut po wan dei go tru da siti ane em bin singaut ebriwea po dem pipol, ‘Yupla mas lisen po mi. Poti dei prom nau God i go distroi olgeda dis siti blo Ninaba.’ ");
INSERT INTO tcs_vpl VALUES ("JH3_5","033_3_5","JON","3","5","5","Dem pipol i bin lisen da mesiz blo God. Ebridem edman i bin spik ol mas stap prom kaikai. So ebriwan prom ol edman go rait daun po ol smolpikinini, i no bin kaikai. Ane dempla i bin were kaliko mekem prom esianbaig po soem dat dempla i prapa sore po dem nugudting dempla i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("JH3_6","033_3_6","JON","3","6","6","Wen da king blo Ninaba i bin lisen wanem Zona bin spik, em stretwei gedap ane kamdaun prom dat tron blo em. Em i bin tekemaut da gud klos blo em ane em bin were dem esianbaig klos. Den em bin sidaun melen wea ip blo asis. Diswan po soe God em prapa sore po dem nugudwei em bin mekem gense God. ");
INSERT INTO tcs_vpl VALUES ("JH3_7","033_3_7","JON","3","7","7","Da king ane ol dem impotant man blo da siti bin sane mesiz ebriwea raun lo da siti. Da mesiz bin spik diskain: ‘Yumpla ebriwan no lau po kaikai ane no lau po pide dem animal blo yumpla. ");
INSERT INTO tcs_vpl VALUES ("JH3_8","033_3_8","JON","3","8","8","Yumpla ebriwan mas were dem klos wea i mekem prom esianbaig ane yumpla mas kaba dem animal wea dem esianbaig kaliko tu. Yumpla ebriwan mas ala laudwan po God ane yumpla mas tan prom dem nugudwei blo yumpla ane stap prom pait. ");
INSERT INTO tcs_vpl VALUES ("JH3_9","033_3_9","JON","3","9","9","Ip yumpla go stap prom meke dem nugudting, mait God go seinze main blo em ane em go stap prom wail po yumpla, ane em nomo go kile yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("JH3_10","033_3_10","JON","3","10","10","So wen God bin luk dempla bin seinze nugudwei blo dempla, em bin sore po dempla ane em no bin kile dempla. Em no bin mekem wanem em bin spik em i go mekem po dempla. ");
INSERT INTO tcs_vpl VALUES ("JH4_1","033_4_1","JON","4","1","1","Zona i bin prapa wail bikoz God bin seinze plan blo em ane no bin panse dem pipol wea da siti. ");
INSERT INTO tcs_vpl VALUES ("JH4_2","033_4_2","JON","4","2","2","So em bin komplein po God diskain, ‘God, ai bin sabe diswan i go apen wen ai bin stil wea kantri blo mi. Daswai ai bin trai po ranwei go po longwei taun blo Tasis. Wa! Ai sabe yu prapa gud God, yu prapa gad mina biglab, yu pil sore, yu prapa slo po wail ane i izi po yu po seinze plan no po tere ol pipol. ");
INSERT INTO tcs_vpl VALUES ("JH4_3","033_4_3","JON","4","3","3","AntapGod, mata kile mi diskaintaim! Ai wande ded. Ai no wande bi laip bikoz yu meke mi sem. Ai bin pinis spik po dempla yu go panse dempla bat nau yu nogo mekem!’ ");
INSERT INTO tcs_vpl VALUES ("JH4_4","033_4_4","JON","4","4","4","AntapGod em i bin spik baigen po Zona, ‘Ei! Yu gad rait po wail po diskainwei blo mi a? Watpo?’ ");
INSERT INTO tcs_vpl VALUES ("JH4_5","033_4_5","JON","4","5","5","Den Zona bin kamaut ane go po da istsaid blo da siti. Em bin meke seid po sidaun andanit ane em bin weit ane luk ip God go meke samting po da siti. ");
INSERT INTO tcs_vpl VALUES ("JH4_6","033_4_6","JON","4","6","6","So da AntapGod bin meke wan bainplant i krol gro prapa kuikwan, po meke seid po Zona po mekem gud kai, bikoz em bin stil wail. Bat wen em bin gad seid em bin prapa glad po sidaun andanit. ");
INSERT INTO tcs_vpl VALUES ("JH4_7","033_4_7","JON","4","7","7","Da neksdei wen da san bin kamap, God bin sane wan wom ane da wom i bin krol kam ane kaikai da bodi blo da plant ane da plant i bin ded. ");
INSERT INTO tcs_vpl VALUES ("JH4_8","033_4_8","JON","4","8","8","Wen da san bin kam prapa ot, God bin sane ot drai win ane da san bin bane ed blo Zona. Em bin kam nadakain slaik ane em tingk, ‘Ai prapa wande ded! Ded, em i mogud den dis laip ya ai gad.’ ");
INSERT INTO tcs_vpl VALUES ("JH4_9","033_4_9","JON","4","9","9","Den God bin aske Zona, ‘Wanem yu wail po dat plant po?’ Ane Zona bin ansa, ‘Aptu mi ip ai wande wail. Ai go wail demkain antil ai go ded.’ ");
INSERT INTO tcs_vpl VALUES ("JH4_10","033_4_10","JON","4","10","10","God i bin spik, ‘Yu tumas woribaut da plant wase yu bin plante da plant de. Kuikwan i bin gro ane kuikwan i bin ded. ");
INSERT INTO tcs_vpl VALUES ("JH4_11","033_4_11","JON","4","11","11","Lisen! Ninaba em i gad 120,000 man ol i stap de ane ol animal tu. Yu bin tingbaut da plant de, bat ai mata woribaut ol dem pipol blo Ninaba. Dem pipol i no sabe rait prom rong.’ ");
INSERT INTO tcs_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Dis buk i tokbaut Zizas Kraist da Promiswan uda God i bin sanem, da wan uda i bin kamaut prom da pamlelain blo King Deibid ane blo Eibram: ");
INSERT INTO tcs_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Eibram i bin da papa blo Aizak. Aizak i bin da papa blo Zekop. Zekop i bin da papa blo Zuda ane ol bala blo em. ");
INSERT INTO tcs_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Zuda i bin da papa blo Perez ane Zera, ane mama blo demtu i bin Tamar. Perez i bin da papa blo Ezron. Ezron i bin da papa blo Ram. ");
INSERT INTO tcs_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram i bin da papa blo Aminadab. Aminadab i bin da papa blo Nason. Nason i bin da papa blo Salmon. ");
INSERT INTO tcs_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon i bin da papa blo Boaz ane mama blo em i bin Reiab. Boaz i bin da papa blo Obed ane mama blo em i bin Rut. Obed i bin da papa blo Zesi. ");
INSERT INTO tcs_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Zesi i bin da papa blo King Deibid. Deibid i bin da papa blo Solomon ane mama blo em i bin Batsiba, da widooman blo Uraia. ");
INSERT INTO tcs_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon i bin da papa blo Riaboam. Riaboam i bin da papa blo Abiza. Abiza i bin da papa blo Asap. ");
INSERT INTO tcs_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asap i bin da papa blo Ziosapat. Ziosapat i bin da papa blo Zioram. Zioram i bin da papa blo Uzaia. ");
INSERT INTO tcs_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzaia i bin da papa blo Zotam. Zotam i bin da papa blo Eiaz. Eiaz i bin da papa blo Ezakaia. ");
INSERT INTO tcs_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezakaia i bin da papa blo Manasa. Manasa i bin da papa blo Amos. Amos i bin da papa blo Zosaia. ");
INSERT INTO tcs_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Zosaia i bin papa blo Zioiakin ane ol bala blo em. Diswan i bin da taim wen da king blo Babilonia i bin kese ol dem Zuwispipol ane teke dempla go ane meke dempla sleib de lo Babilonia. ");
INSERT INTO tcs_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Apta wen dempla i bin teke dempla go po Babilonia: Zioiakin i bin da papa blo Salatela. Salatela i bin da papa blo Zerubabal. ");
INSERT INTO tcs_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabal i bin da papa blo Abiud. Abiud i bin da papa blo Eliakim. Eliakim i bin da papa blo Azor. ");
INSERT INTO tcs_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor i bin da papa blo Zadok. Zadok i bin da papa blo Akim. Akim i bin da papa blo Eliud. ");
INSERT INTO tcs_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud i bin da papa blo Eliazar. Eliazar i bin da papa blo Matan. Matan i bin da papa blo Zekop. ");
INSERT INTO tcs_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Zekop i bin da papa blo Zosep, ane Zosep i bin da man blo Meri. Meri i bin da mama blo Zizas, ane em nau da Promiswan uda God i bin sanem kam. ");
INSERT INTO tcs_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Prom Eibram kam po King Deibid i gad 14 pamlelain, den nada 14 pamlelain kam prom Deibid kam po dat mub blo ol dem pipol blo Izrael go po Babilon, den nada 14 pamlelain prom da taim wea Babilon kam po da taim blo da Promiswan uda God i go sanem. ");
INSERT INTO tcs_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nau diswan da stori baut wiskain Zizas da Promiswan uda God i go sanem kam, i bin bon. Meri mama blo Zizas i bin engeiz po Zosep, demtu no bin maret yet. Wail Meri stil no bin sabe slip lo man, da OliSpirit i bin kam ane Meri i bin kam pamle. ");
INSERT INTO tcs_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Zosep i bin prapa gudman ane wen em bin sabe Meri i bin pamle, em tot po emselp, ‘Aukam em i pamle. Em mas bin slip lo nada man. Ai nogo graul em prant ol pipol, bat ai mata go paine wei po broke dis engeizment blo mitu kuaiatwan.’ ");
INSERT INTO tcs_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wail em bin leidaun tingbaut po wei po go, em bin go slip. Midel lo da slip wan einzel blo da AntapGod i bin kam po em lo drim, ane da einzel i bin spik po em, ‘Zosep, yu kam prom pamlelain blo King Deibid, so yu no prait prom maret Meri, bikoz da beibi de lo Meri i gad nau, i bin kam prom da OliSpirit. ");
INSERT INTO tcs_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Em go bone boibeibi ane yu mas neim em Zizas. Yu mas gibe em dat neim bikoz em i go seibe ol pipol blo em prom meke ol nugudting.’ ");
INSERT INTO tcs_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Disting i bin apen po prube dem tok blo dat spesilmesizman blo God Aizaia: ");
INSERT INTO tcs_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","‘Luk! Da oman uda prapa no sabe slip lo man em go gad pamle! Em go bone boi pikinini, ane demtu i go neim em Imanuel. Dis neim i min “God i ya midel lo yumpla”.’ ");
INSERT INTO tcs_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wen Zosep i bin gedap prom slip, em bin mekem wanem da einzel blo da AntapGod i bin spik. So em bin go maret Meri. ");
INSERT INTO tcs_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Meri i bin stap demkain, no slip lo Zosep antil da boi i bin bon, den Zosep i bin neim em Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Zizas i bin bon lo taun blo Betliem insaid lo eria blo Zudia, lo taim wen Erod i bin king. Apta wen Zizas i bin bon, sam smat ane waizman prom da ist, i bin kam po Zarusalem. Dempla i bin askem diskain po ol pipol de, ");
INSERT INTO tcs_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","‘Mipla i bin kam po luk beibi wea i bin bon uda i go kam king blo ol Zuwispipol, bikoz mipla i bin luk sta blo em i bin kamap. Mipla i bin kam po wosip em.’ ");
INSERT INTO tcs_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wen King Erod i bin lisen dis tok ya baut dis niu king, em bin nadakain wori bikoz em tingk, ‘Mait dis niu king i go teke ples blo mi.’ Ane ebridem pipol tu lo Zarusalem i bin nadakain wori. ");
INSERT INTO tcs_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erod bin sane tok po ebri edprist, prist ane ol nada tisa blo dem lo blo God po kam po miting. Den em i bin aske dempla, ‘Yupla sabe a? Dem bipotaim spesilmesizman blo God i bin spik wea da Promiswan i go bon, a?’ ");
INSERT INTO tcs_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Dempla i bin ansa baigen po em, ‘De lo Betliem, ane demting ya wanem da spesilmesizman blo God i bin raitem: ");
INSERT INTO tcs_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Yupla, dem pipol blo Betliem insaid lo eria blo Zudia, dat smol taun blo yupla i go kam prapa impotant taun blo Zudia, bikoz wan rula i go kam prom yupla, ane em go lide ol pipol blo mi, dem pipol blo Izrael, wase man uda lugaut sip i lide ol sip blo em.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Apta wen Erod i bin lisen disting, em i bin sane wokman blo em go po aske dem waizman po kam po em, i go gad sikret miting. Wen dempla i bin miting de, Erod i bin sabe nau da prapa taim wen ol i bin pas luk dat sta. ");
INSERT INTO tcs_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Den em bin spik po dempla, ‘Yupla go po Betliem ane lukraun po dat pikinini, ane wen yupla painem kambaik ane spik po mi solong ai ken go de tu po wosip em.’ ");
INSERT INTO tcs_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Apta miting blo dempla, dem waizman bin wagbaut go. Wen ol bin wagbaut go, da sta i bin kamaut po dempla de gen, ane i bin lide dempla go pas po Betliem. Ane da sta i bin stap stret antap lo da ples wea da pikinini i bin stap. ");
INSERT INTO tcs_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Wen dempla i bin luk da sta, dempla i bin prapa nadakain api. ");
INSERT INTO tcs_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Dempla i bin go insaid po aus wea da boibeibi ane mama blo em Meri i bin. Dempla i bin baudaun pesdaun prant lo em ane wosip em. Den dempla i bin gibem ol present blo gold, ol naissmel insens, ane nais sentoil. ");
INSERT INTO tcs_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bat wen dempla bin redi po gobaik po taun blo dempla, God i bin wone dempla lo drim po go nadawei, no gobaik datwei po Erod. ");
INSERT INTO tcs_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Apta dem waizman i bin go, wan einzel blo da AntapGod i bin kam po Zosep insaid lo drim. Em bin spik po Zosep, ‘Gedap, teke pikinini ane mama blo em ane kuikwan go po Izipt. Stap de antil ai go spik yupla po kambaik, bikoz Erod i go trai po kile da pikinini.’ ");
INSERT INTO tcs_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","So dat seim nait Zosep i bin gedap, teke pikinini ane mama blo em ane lego go po Izipt. ");
INSERT INTO tcs_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Dempla i bin stap de antil Erod i bin ded. Diswan i bin po prubem wanem da AntapGod i bin spik de prapa longtaim pas po dat spesilmesizman blo em, Ozeia, ‘Ai bin singaut Boi blo mi kamaut prom Izipt.’ ");
INSERT INTO tcs_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wen Erod i bin paindaut dem waizman bin trike em, em i bin prapa nadakain wail. Em bin gibe oda po ol amiman blo em po kile ebri boi pikinini uda i tu iya oul ane andanit, de lo Betliem ane raun lo dem biliz. Em bin mekem diskain bikoz dem waizman i bin spik po em da sta i bin kamaut po dempla baut tu iya bipo. ");
INSERT INTO tcs_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","So wanem God i bin spik po da spesilmesizman blo em Zeramaia, i bin kam tru: ");
INSERT INTO tcs_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Da noiz blo nadakain nugud sorekrai, i bin kamaut prom taun blo Rama, ane nadakain nugud sorekrai i mata go. Krai i kamaut prom Reisel. Em bin krai po ol pikinini blo em, ane nobodi i ken stapem prom krai, bikoz ol pikinini blo em i bin ded pinis, nomo gad.’ ");
INSERT INTO tcs_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wen Erod i bin ded, wan einzel blo da LodGod i bin kamaut lo drim po Zosep de lo Izipt ane spik po em, ");
INSERT INTO tcs_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","‘Weikap, teke pikinini ane mama blo em ane gobaik po lan blo Izrael, bikoz dempla uda i bin trai po kile da pikinini i ded nau.’ ");
INSERT INTO tcs_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","So Zosep i bin gedap, teke Zizas ane mama blo em ane wantaim lego go po Izrael. ");
INSERT INTO tcs_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bat apta wen em i bin lisen dat Akilaus, boi blo Erod, i bin da niu king, Zosep i bin prait. Den God i bin wonem lo nada drim po go po eria blo Galali. ");
INSERT INTO tcs_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","So dempla i bin go ane stap lo wan smol taun blo Nazaret. Diswan po pole wanem dem spesilmesizman blo God i bin spik, ‘Da Promiswan i gobi Nazaretman.’ ");
INSERT INTO tcs_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Longtaim de pas Zon Baptaizman i bin stat po tise ol pipol de lo eria blo Zudia de lo ples wea i nogad man. Dem mesiz blo em wea em i bin tise dempla i bin diskain, ");
INSERT INTO tcs_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","‘Nomo meke ol nugudting ane yupla tan po God bikoz da taim blo God i go ruloba ebribodi i klostu nau.’ ");
INSERT INTO tcs_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Aizaia da spesilmesizman blo God i bin tokbaut Zon wen em bin spik: ‘I gad sambodi de ala lo ples wea i nogad man, “Meke da wei redi po da AntapGod. Meke da rod stret po em po wagbaut!” ’ ");
INSERT INTO tcs_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Dem klos wea Zon i bin werem i bin mekem prom eya blo kamal. Em i bin were leda belt, ane kaikai blo em i bin grasopa ane bus ani. ");
INSERT INTO tcs_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ol pipol i bin kam prom Zarusalem, prom ol nada pat blo Zudia, ane prom ebriwea lo eria blo Zodan Riba. Ol i bin go po da ples wea i nogad man po lisen Zon pris. ");
INSERT INTO tcs_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wen dempla i bin spik Zon baut dem rongting wea dempla i bin mekem, em bin baptaiz dempla de insaid lo Zodan Riba. ");
INSERT INTO tcs_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bat wen em i bin luk ol dem Parasi ane nadalot uda bin kole demplaselp Sadusi, kam de wea em baptaiz ol dem pipol, em bin spik po dempla, ‘Yupla debol! Yupla wase dem dedli sneik! Yupla kan ranwei prom zazment blo God ya go kam. Yupla tingk ip ai go baptaiz yupla, God i go pogibe yupla prom dem nugudting wea yupla i bin mekem? Yupla rong. ");
INSERT INTO tcs_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yupla mas tanewei prom ebridem nugudting lo laip blo yupla ane tan po God, so ai go sabe yupla bin slu prom ol sin blo yupla ");
INSERT INTO tcs_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","No spik diskain ya, “Mipla orait wea God, bikoz mipla kam prom seim pamlelain blo bigate Eibram.” Diswan i no min nating. God i ken seinze dem ston ya po pikinini blo Eibram. ");
INSERT INTO tcs_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","God i wase man wea i wok lo gadan. Da tamiok blo da zazment blo God i redi po katemdaun ol dem tri ane ol dem rut. Ebri tri uda no sake gudprut, em i go katemdaun ane sakem wea bigpaia.’ ");
INSERT INTO tcs_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Den Zon i bin spik po dem pipol de, ‘Yupla uda bin tanewei prom dem nugudting wea yupla i bin mekem ane tan po God, ai baptaiz yupla ya lo wata. Bat i gad sambodi uda i mina nadakain mo bigman den mi. Ai no pit po bi sleib blo em. Em go baptaiz yupla lo OliSpirit ane lo paia. ");
INSERT INTO tcs_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Em gobi wase pama uda i separeit gud kaikai prom ol nugud kaikai. Em go pute dem gud kaikai insaid lo storum, ane dem nugudwan em i go banem lo dat paia wea i kan aut.’ ");
INSERT INTO tcs_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Den Zizas i bin go prom Galali kam po Zodan Riba po Zon go baptaiz em. ");
INSERT INTO tcs_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bat Zon no bin wande baptaiz Zizas. So em bin spik po Zizas diskain, ‘Ai da wan wea yu mas baptaiz. Aukam yu kam po mi po baptaiz yu?’ ");
INSERT INTO tcs_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Bat Zizas i bin ansa, ‘Yumi mas meke ebriting wanem God i wandem.’ Wen Zon i bin lisen wanem Zizas i bin spik, em bin baptaiz Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Apta wen Zizas i bin kamap prom da wata, eben i bin open ane da Spirit blo God i bin kamdaun wase dab ane sidaun antap lo em. ");
INSERT INTO tcs_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ane bois prom de antap eben i bin spik, ‘Diswan prapa boi blo mi. Ai prapa lab em ane ai prapa api po em.’ ");
INSERT INTO tcs_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Den da OliSpirit blo God i bin teke Zizas go po wan ples wea i nogad man po Satana i go trai po trike em. ");
INSERT INTO tcs_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Zizas i bin de po poti dei ane poti nait. Em no bin kaikai nating ane em i bin kam prapa nadakain anggre. ");
INSERT INTO tcs_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Den Satana i bin kam ane spik po em, ‘Ip yu prapa Boi blo God, tane dem ston ya po bred.’ ");
INSERT INTO tcs_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Bat Zizas i bin spik po em, ‘No! Baibol i spik: “Pipol nide moden kaikai po stap laip. Ol mas lisen po ebri wod wanem God i spik ane mekem.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Den Satana i bin teke Zizas go po Zarusalem ane mekem stanap antap lo prapa ai pat blo da Tempol blo God. ");
INSERT INTO tcs_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Satana i bin spik po em, ‘Ip yu prapa Boi blo God, zamp godaun, bikoz Baibol i spik diskain ya: “God i go oda ol einzel po kese yu. Dempla i go kare yu antap solong yu nogo poldaun, paite leg lo ston.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Zizas i ansa em baik diskain ya, ‘Baibol i spik diskain ya tu, “No teste da AntapGod uda i God blo yu.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Den Satana i bin teke Zizas go po top blo wan prapa ai maunten, ane em soem ebri kantri blo da wold wea i gad ol prapa nais samting po luk. ");
INSERT INTO tcs_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Satana bin spik, ‘Ip yu go nildaun ane wosip mi ai go gibe ebridem samting ya po yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Zizas i spik po em, ‘Gedaut prom ya Satana. Baibol i spik: “Yu mas wosip da AntapGod uda i God blo yu. Mata wosip em.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Den Satana i bin tekop go ane ol einzel i bin kam ane elpe Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wen Zizas i bin lisenbaut Zon i bin insaid zeilaus, em bin libe Zudia ane em bin kambaik po Galali. ");
INSERT INTO tcs_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Bat em no bin stap de lo Nazaret. Em bin go ane stap de lo Kapaniam, longsaid lo leik blo Galali, lo eria blo Zebulun ane Naptali. ");
INSERT INTO tcs_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Diswan i bin po prubem wanem Aizaia, da spesilmesizman blo God i bin spik: ");
INSERT INTO tcs_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Ai gad mesiz ya po yupla dem pipol blo Zebulun ane Naptali, uda i stap klostu po Leik Galali, ane stap kros lo Zodan Riba, wea da eria blo Galali wea dem Nozuwispipol i stap. ");
INSERT INTO tcs_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Yupla dem pipol uda i bin stap lo dak, yupla go luk prapa nadakain braitlait, wase san i go laitap da ples blo ded.’ ");
INSERT INTO tcs_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ane prom de go, Zizas i bin stat po tise ol pipol diskain, ‘Nomo meke ol nugudting ane tan kam po God bikoz dat taim wea God i go ruloba ebribodi i klostu nau.’ ");
INSERT INTO tcs_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Prom de Zizas i bin wagbaut wea sanbis blo Leik Galali. Em bin luk tu bala, Saiman uda nada neim i Pita, ane Andru, uda sake net de. Demtu tu pisaman. ");
INSERT INTO tcs_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Zizas i bin ala po demtu, ‘Kam ane bi klostuman blo mi, ane ai go soe yutu wiskain po wine man po God.’ ");
INSERT INTO tcs_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Demtu wantaim bin libe net blo demtu biain ane pole Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Den lelbet longwei go lo sanbis em bin luk tu nada bala, Zemes ane Zon, sidaun insaid lo bot wea papa blo demtu, Zebadi. Dempla bin somape net. Em bin ala po demtu po kam. ");
INSERT INTO tcs_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Demtu bin wantaim zamp ausaid prom da bot, libe papa blo demtu ane da bot biain ane go wea Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Zizas i bin wagbaut wea Galali tise ol pipol insaid lo dem zuwispreaus, ane ebriwea tise dempla baut da Gudniuz blo da ples wea God i king. Ane em i bin meke dem pipol uda i gad olkain sik ane olkain diziz kamgudgen. ");
INSERT INTO tcs_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pipol prom ebri ples blo da eria ausaid prom Galali i bin lisenbaut em, raitap go po kantri blo Siria. Ol i bin teke ebridem pipol kam po Zizas wea dempla i bin gad bigpein lo bodi blo dempla, ane nugudspirit insaid lo dempla, demwan uda i bin paralaiz ane demwan uda i bin gede tumas pit. Ane Zizas i bin meke ebriwan dempla kamgudgen. ");
INSERT INTO tcs_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Prapa nadakain plenti pipol i bin pole em. Sam dempla i bin kam prom da eria blo Galali. Dem nadalot i bin kam prom Zarusalem ane prom nada pat blo da eria blo Zudia. Ane sam dem nadalot i bin kam prom da eria blo Dekapolis, ane prom ol nada ples kros lo Zodan Riba. ");
INSERT INTO tcs_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wen Zizas i bin luk dem plenti pipol i bin pole em, em i bin go antap lo wan maunten wea ol klostuman blo em. Dempla i bin sidaun ane Zizas i bin tise dempla de. ");
INSERT INTO tcs_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Diswan wanem Zizas i bin tise dempla: ");
INSERT INTO tcs_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","‘God i blese demwan uda i louklas pipol uda i sabe God, bikoz da ples wea God i ruloba ebriwan i gobi blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","God i blese demwan uda i base big sorekrai, bikoz God i go blese dempla. Ol nomo go pil sore gen. ");
INSERT INTO tcs_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","God i blese demwan uda i ambol, bikoz God i go gibe dempla da ples wea em i bin promis dempla. ");
INSERT INTO tcs_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","God i blese demwan uda i prapa wande meke da raitting po ol pipol, wanem God i wandem, bikoz God i go gibe dempla ebriting wanem dempla i bin wandem. ");
INSERT INTO tcs_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","God i blese ol pipol uda i soe sorewei po ol nada pipol, bikoz God i go soe sorewei po dempla. ");
INSERT INTO tcs_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","God i blese demwan uda i no woribaut ol nadating, bat mata ebritaim wori po meke wok blo God, bikoz dempla i go luk God. ");
INSERT INTO tcs_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","God i blese demwan uda i mata meke pis midel wea ol pipol, bikoz God i gobi papa blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","God i blese demwan uda i meke wok blo God, wea ol nada pipol meke trabol po dempla, bikoz da ples wea God i ruloba ebribodi, i gobi blo demwan. ");
INSERT INTO tcs_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‘God i blese yu wen ol pipol i daune yupla, tok olkain nugudtok po yupla, prapa spoile yupla, ane tok olkain laitok baut yupla, mata bikoz yupla i pole mi. ");
INSERT INTO tcs_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yupla mas bi api. No wail po dem pipol uda i meke demkain po yupla, bat bi nadakain api, bikoz i gad nadakain big riwod de weit po yupla antap lo eben. Tingbaut dem bipotaim spesilmesizman blo God. Wen ol pipol i bin meke dem seimkain nugudting po dempla, dempla no bin wail. Dempla i bin nadakain api bikoz dempla i sabe i gad nadakain big riwod de weit po dempla antap lo eben.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Zizas i bin spik, ‘Yupla wase solt stap ya lo ert. Bat ip da solt i luze tes i gobi nugud, yupla kan yuzem gen. Pipol i go sakem ausaid ane wen ol pipol i go wagbaut kam diswei ane gobaik datwei, ol i go wagbaut antap lo da solt.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Yupla ol wase lait blo taun antap lo il. Lo daktaim ebri pipol i ken luk da lait i sain. ");
INSERT INTO tcs_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pipol no aide lait andanit lo basket. No! Dempla ainge da lamp antap solong ebri pipol de insaid lo dat aus i ken luk dat lait. ");
INSERT INTO tcs_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Seimkain wase da lait blo da lamp, yupla mas mata ebritaim meke wok blo God ane ebritaim soe gudpasin po ol pipol, solong ebriwan i go luk da gudwei wea yupla i gad. Ol i go preize PapaGod de lo eben.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Zizas i bin spik, ‘No tingk ai bin kam ya daun po ert po sakwei dem lo blo Mozes ane dem tising blo dem longtaim spesilmesizman blo God. Nono! Ai bin kam ya po pole ebridem lo. ");
INSERT INTO tcs_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ai spik trutok po yupla, wail eben ane ert i stil stap, ebridem lo blo God i go stap, iben dem prapa nadakain smolpat blo dem lo i go stap tu. ");
INSERT INTO tcs_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ip yupla i broke wan smolpat blo dem lo ane tise ol nada pipol po pole wei blo yupla, wel, yupla i gobi nobodi lo da ples wea God i go ruloba ebribodi. Bat eniwan uda i mata lisen ane mekem po wanem dem lo blo God i spik, ane tise ol nada pipol baut dem lo, dempla i gobi sambodi de lo da ples wea God i go ruloba ebribodi. ");
INSERT INTO tcs_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","‘Bat ai wone yupla nau. No wosip God wase dem tisa uda i tise dem Zuwislo. Ip yupla mekem demkain yupla kan go insaid lo da ples wea God i go ruloba ebribodi.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Zizas i kip spik, ‘Yupla i bin lisenbaut Mozeslo wea em bin spik, “Yu no lau po kile man. Ip yupla i kile man, yupla mas go po kot ane mas gede panisment.” ");
INSERT INTO tcs_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bat ai spik diskain. Ip yupla i wail po sambodi God i go wail po yupla, ane yupla mas gede panisment. Ip yupla wail po sambodi ane kipgo ane kolem olkain, den yupla mas go po kot ane da kot i go panis yupla. Ane i seimkain tu prant lo God. Ip yupla i prapa no laik sambodi, ane yupla i spik po em diskain ya, “God i go kerse yu”, wel yupla i lukraun po ban insaid lo dat paia blo el. ");
INSERT INTO tcs_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","‘Ip yupla i stanap wea da Tempol, prant lo olta redi po meke sakripais po God, ane tot i kam lo yupla baut sambodi i bin spik dat yupla i bin meke sam rongting gense em, ");
INSERT INTO tcs_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","yupla mas no meke sakripais yet. Yupla mas go pas po meke pis lo da man. Den apta wen yupla i bin pinis meke pis lo da man, yupla i ken kambaik apiwan nau ane meke dat sakripais po God.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Zizas i bin spik diskain ya tu, ‘Ip wan man i spik diskain ya, em i go teke yu go po kot bikoz yu no bin pei bil blo yu. Kuikwan go ane tok wea em, solong em mait go seinze main blo em ane nogo teke yu go po kot. Bat ip yu nogo po tok, strete datting midel lo yutu, em go teke yu po kot. Den da zaz i go spik po da opisa blo da kot po teke yu ane loke yu insaid lo zeilaus. ");
INSERT INTO tcs_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ane yu go stap de insaid antil yu go pei ebridem bil blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","‘Yupla i bin lisenbaut Mozeslo wea em i bin spik, “Maret man mas kiptru po oman blo em, ane maret oman mas kiptru po man blo em.” ");
INSERT INTO tcs_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bat ai spik po yupla, eni man uda luk nada oman ane bane ai po slip lo em, wel em bin pinis meke dat sekssin insaid lo at ane main blo em. ");
INSERT INTO tcs_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","So ip dat ai blo yupla i meke yupla po meke dat sin, tekemaut em ane sakwei em, bikoz i mobeta po luze wan pat blo bodi blo yupla, den po go insaid lo el lo mura bodi. ");
INSERT INTO tcs_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ane ip an blo yupla i meke yupla po meke sin, nomata i da strong an blo yupla, katem go ausaid ane sakwei em, bikoz i mobeta po luze wan pat blo bodi blo yupla, den po go insaid lo el lo mura bodi.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Orait. Zizas i kip spik, ‘Yupla i bin lisenbaut Mozeslo wea em i bin spik, “Ip man i dibos oman blo em, em mas gibe dat oman dibos peipa.” ");
INSERT INTO tcs_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bat ai spik po yupla, i gad mata wan rizan po man po dibos oman blo em, i bikoz oman blo em i no bin kiptru po em ane em bin slip lo nada man. Ane enibodi uda i maret dat dibos oman em i meke sekssin. Ip man i dibos oman blo em po eni nada rizan, em meke dat oman po meke sekssin tu.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Zizas i kip spik, ‘De gen, yupla i bin lisenbaut Mozeslo wea em i bin spik, “No broke dem promis wea yupla i bin mekem lo da AntapGod. Yupla mas kip meke dem promis.” ");
INSERT INTO tcs_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bat ai spik po yupla, no meke eni promis. Ip yu yuze neim blo eben po meke promis, yu yuze neim blo God bikoz i ples blo God. ");
INSERT INTO tcs_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ane no iben yuze neim blo ert tu, bikoz God i da wan uda i kontrol da ert. No iben yuze neim blo Zarusalem, bikoz dat siti i blo God, ane God i da prapa nadakain Bigking. ");
INSERT INTO tcs_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","No iben yuze neim blo yu, bikoz God i bin meke yu. ");
INSERT INTO tcs_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ip yu wande tok demkain, mata spik, “Wa, ai go mekem”, o mata spik, “No, ai nogo mekem.” Ip yu go yuze olkain promis wod po meke yuselp strong, den dem wod i kamaut prom Satana.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ane Zizas i kip spik, ‘Yupla i bin lisenbaut Mozeslo wea em i spik, “Ip nada man i poke ai blo dat nada man, wel em mas gede da seim tritment baigen. Ane ip da nada man i lego an ane broke tit blo da nada man, wel em mas gede da seim tritment baigen tu.” ");
INSERT INTO tcs_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bat ai spik po yupla, ip enibodi i meke nugudting gense yupla, no meke da seimting baigen po em. Ip em i slape yupla lo raitsaid pes blo yu, no wail ane slape dempla baigen. Spik dempla po slape da leptsaid pes blo yu tu. ");
INSERT INTO tcs_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ip sambodi i wande teke yu po kot, ane da zaz i oda yu po tekemaut klos blo yu ane gibem po da man, wel gibe em kout blo yu tu. ");
INSERT INTO tcs_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ip wan amiman i aske yu po kare ol gia blo em po wan kilamita, kare dem gia po tu kilamita. ");
INSERT INTO tcs_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Enibodi uda i aske yu po samting, mata gibem, ane eniwan uda i wande yuze samting blo yu, mata gibe em po yuzem.’ ");
INSERT INTO tcs_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Zizas i spik gen, ‘Yupla i bin lisenbaut Mozeslo wea em i bin spik, “Yupla mas labe ol pamle blo yupla, bat no labe dem enami blo yupla.” ");
INSERT INTO tcs_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bat ai spik po yupla, yupla mas labe ol enami blo yupla tu, ane yupla mas prea po dem pipol uda i kerse yupla, uda i meke nugudting po yupla. Ane yupla mas mata meke gudting po demwan uda i prapa no laik yupla. ");
INSERT INTO tcs_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Wen yupla i mekem diskain, yupla i kam prapa pikinini blo da PapaGod blo yupla de antap lo eben. Em i lab ebribodi, daswai em i meke san po sain antap lo ol gudpipol ane ol nugudpipol tu. Seimkain tu lo rein. Em i meke rein poldaun antap lo ol gudpipol ane nugudpipol tu. ");
INSERT INTO tcs_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ip yupla i mata labe dem pipol uda i labe yupla bat no demwan uda i no lab yupla, wiswei? Yupla seimkain wase dem nugud taksman. Dempla i labe dem pipol uda i labe dempla. Yupla nogo gede no riwod prom God. ");
INSERT INTO tcs_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ane ip yupla i soe gudpasin po mata ol pren blo yupla, den yupla i seimkain wase ol nada pipol. Iben pipol uda i no sabe God, i soe gudpasin po pren blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bat yupla mas bi prapa nadakain klin, seimkain wase PapaGod blo yupla de antap lo eben uda i nogad not wan dati.’ ");
INSERT INTO tcs_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Zizas i tok mo diskain, ‘Lugaut. Wen yupla i meke ol gudwok, no mekem prant lo ol pipol po luk, bikoz ip dempla i go luk, ol go preize yupla ane PapaGod blo yumpla de antap lo eben nogo gibe yupla no riwod. ");
INSERT INTO tcs_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","So wen yupla i elpe pipol i gad nid, no spik po nobodi dat yupla i bin gibe dempla ol samting. No lete nobodi luk yupla wen yupla i gibe dempla dem samting. No teke wei blo dem tupes pipol wea dempla bloubaut wanem dempla bin mekem prant wea ebribodi insaid lo da zuwispreaus ane midel wea da rod. Diswan i mata po meke dempla gud solong dem pipol i go soe rispekt po dempla. Ai spik trutok po yupla, dempla i bin pinis gede ebridem riwod blo dempla prom dem pipol. ");
INSERT INTO tcs_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wen yupla i elpe demwan uda i nide elp, meikso dat nobodi luk. ");
INSERT INTO tcs_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Mata yu ane em i sabe da gudting wea yu bin mekem po em. Ane wen PapaGod blo yupla de antap lo eben i go luk wanem yu bin mekem, em go gibe yu riwod.’ ");
INSERT INTO tcs_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Zizas i kip spik, ‘Wen yupla prea no teke da wei blo dem tupes pipol uda i prea midel lo strit o lo zuwispreaus po ebriwan po luk dempla. Ai spik trutok po yupla, dempla i bin pinis gede ebridem riwod blo dempla prom dem pipol. ");
INSERT INTO tcs_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bat wen yupla prea, go insaid lo rum blo yupla, sate doa solong nobodi i ken luk yupla. Ane prea po PapaGod blo yupla wea dempla i kan luk yupla. Mata em i ken luk yupla ane em i go gibe yupla riwod. ");
INSERT INTO tcs_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","‘Wen yupla prea, no kip ripit yuplaselp wase dem pipol lo ol nada dipren rilizan i mekem. Ol tingk God i lisen po dem prea blo dempla wen ol kip ripit demplaselp. ");
INSERT INTO tcs_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","No prea demkain wase dempla, bikoz PapaGod blo yupla i sabe demting wanem yupla i prapa nidem pas bipo yupla i askem! ");
INSERT INTO tcs_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Prea diskain: PapaGod blo yumpla de antap lo eben, mipla prea ol pipol go ona ane kare neim blo yu antap. ");
INSERT INTO tcs_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mipla prea da taim go kam kuikwan wen yu go ruloba ebribodi. Mipla prea ebridem ubi blo yu go kamaut ya lo ert, seimkain wase i kamaut de antap lo eben. ");
INSERT INTO tcs_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gibe mipla nap kaikai wanem mipla nidem po tidei, ");
INSERT INTO tcs_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ane pogibe mipla po ol dem nugudting mipla i bin mekem, seimkain wase mipla i bin pogibe dem pipol uda i bin meke nugudting gense mipla. ");
INSERT INTO tcs_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pliz elpe mipla so mipla nogo gibap ane meke ol nugudting, bat elpe mipla prom no pole dat nugudwan. Da ples wea yu ruloba ebribodi, da prapa bigpaua blo yu, ane prapa big preiz, i mata blo yu poeba. Amen. ");
INSERT INTO tcs_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Ip yupla i pogibe demwan uda i bin meke nugudting po yupla, wel PapaGod blo yupla de antap lo eben i go pogibe yupla po dem nugudting wea yupla i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Bat ip yupla i nogo pogibe dempla, PapaGod blo yupla i nogo pogibe yupla po dem nugudting wea yupla i bin mekem.’ ");
INSERT INTO tcs_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Zizas kip spik, ‘Wen yupla no kaikai po mata prea, no meke pipol po tekenotis lo yupla wase dem tupes pipol uda i meke demplaselp luk sik solong pipol i go tekenotis, ane ol i go blou dempla po wanem dempla i mekem. Ai spik trutok po yupla, dasol preiz blo dempla de ol i go gedem, prom dem pipol uda i bin blou dempla. ");
INSERT INTO tcs_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bat wen yupla no kaikai po meke prea, meke yuplaselp luk strong. Wase pes blo yu ane brase eya blo yu, ");
INSERT INTO tcs_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","solong nobodi i go sabe yupla i no kaikai mata prea. Mata PapaGod blo yupla de antap lo eben i sabe. Wen yupla i mekem diskain, PapaGod blo yupla de antap lo eben i go gibe yupla riwod.’ ");
INSERT INTO tcs_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Zizas kip spik, ‘Yupla no wande pailemap ol gudsamting blo yupla ya lo ert, wea ol kakros i go kaikai, ane dem samting i go rasti ane wea stilaman i ken kam ane stile dem samting. ");
INSERT INTO tcs_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pailemap ol demting wea i gudsamting blo yupla de antap lo eben, wea kakros i kan neba kaikai, ane demting i kan neba rasti ane i nogad no stilaman de. ");
INSERT INTO tcs_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ip tot blo yupla i prapa wande dem samting ya lo ert, den at blo yupla i prapa wande dem samting ya lo ert. Bat ip tot blo yupla i prapa wande dem samting de antap lo eben, den at blo yupla i go prapa wande dem samting de antap lo eben. ");
INSERT INTO tcs_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Dem ai blo yupla, em prapa wase lamp i meke lait wea laip blo yupla. Ip yupla mata luk da raitwei po meke ebriting, laip blo yupla i go kam wase lait i sain. ");
INSERT INTO tcs_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bat ip yupla luk rongwei po meke ebriting, laip blo yupla i go kam wase yupla stap wea prapa nadakain dakples wea i nogad no lait. Yupla lugaut! Tekenotis nau. Maitbi demwei blo yupla i nogad no lait i sain. Yupla mait stil stap wea dakples. ");
INSERT INTO tcs_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Nobodi i ken meke wok po tu bos. Bikoz em go laik da wan bos, ane em no go laik da nadawan. Ip yupla wande kam wokingman blo God, wel, i seimkain tu. Yupla kan meke wok blo God ane meke mani bos blo yupla da seimtaim tu. ");
INSERT INTO tcs_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","‘So ai spik yupla, no woribaut ip yupla i gad nap kaikai po kaikai, o dringk po dringk, o klos po werem, bikoz laip blo yupla i mo impotant den demting. ");
INSERT INTO tcs_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Yupla tingbaut dem pizin. Dempla no meke gadan po groe ol kaikai po dempla, ane dempla i no store ol kaikai blo dempla lo storum. Bat PapaGod blo yupla de antap lo eben i pide dempla ebridei. Ane da PapaGod de antap lo eben i prapa labe yupla moden dem pizin. ");
INSERT INTO tcs_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wen yupla wori, yupla kan pute nating insaid lo laip blo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘Wanem yupla woribaut ol klos po? Yupla luk dem nais kala plaua de ane wiskain dempla i gro. Dempla i no bin wok prapa ad po meke demkain nais kala kamaut. ");
INSERT INTO tcs_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ai spik yupla, iben dem prapa nadakain plasklos blo King Solomon, i no prapa nais wase wan prom dem plaua ya. ");
INSERT INTO tcs_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nomata dem nais kala plaua i ya tidei ane i nogad em de tumoro, bat stil God i lukapta dem plaua. Wa! God i mas lukapta yupla tu. Nomata lelbet bilib yupla i gad lo em, em i go stil lukapta yupla. ");
INSERT INTO tcs_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","‘So no woribaut ol kaikai po kaikai, o dringk po dringk, o ol klos po werem. ");
INSERT INTO tcs_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","No kam wase demwan uda i prapa woribaut demting, bikoz bipo yupla i gad woribaut ol samting, PapaGod blo yupla de antap lo eben i pinis sabe wanem yupla i nidem. ");
INSERT INTO tcs_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ip yupla i mata meke wok blo God, ane meke em king blo yupla, den em i go gibe yupla ebriting yupla i nidem. ");
INSERT INTO tcs_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","‘So no wori tidei po samting blo tumoro bikoz tidei i gad em oun trabol ane tumoro i gad em oun trabol.’ ");
INSERT INTO tcs_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Zizas i tok mo diskain, ‘Yupla mas no zaze nada man bikoz ip yupla i go zaze nada man God i go zaze yupla. ");
INSERT INTO tcs_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ip yupla i paine polt lo enibodi, wel God i go paine polt lo yupla tu da seimkainwei. Ane ip yupla zaze enibodi, wel God i go zaze yupla tu da seimkainwei. ");
INSERT INTO tcs_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","‘Ip wan pren blo yupla i gad smol pis blo dati i pas insaid lo ai blo em, ane dat seimtaim yupla i gad bigpis blo dati i pas insaid lo ai blo yupla, den yupla i kan go ane tekemaut dat dati prom ai blo pren blo yupla. Yupla kan luk. Yupla mas tekemaut da big dati prom ai blo yupla pas. ");
INSERT INTO tcs_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Aukam yupla spik, “Kam. Ai go tekemaut da smol dati prom ai blo yu”, wen yupla gad big dati i pas insaid lo ai blo yupla, wea i meke yupla i kan luk prapa. ");
INSERT INTO tcs_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yupla tupes pipol. Yupla mas tekemaut da big dati prom ai blo yupla pas, solong yupla ken luk klia, den yupla ken tekemaut da smol dati prom ai blo pren blo yu. ");
INSERT INTO tcs_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘No gibe dem prapa oli samting blo God po dem pipol uda no wande bilib, bikoz ip yupla i go gibe dempla dat oli samting i gobi wase wen yupla i sake prapa nais perl neklis po ol pig. Ol mata go wagbaut antap ane smasem bikoz dempla no sabe dat demting i gud, den ol i go tanraun ane baite yupla.’ ");
INSERT INTO tcs_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Zizas i kip spik, ‘Ip yupla wande eniting, prea ane aske God ane em i go gibe yupla demting wanem yupla i bin askem po. Enibodi uda i lukraun po God, i go painem. Ane ip yupla i kip nok lo da doa, God i go opene da doa po yupla. ");
INSERT INTO tcs_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Enibodi uda i prea ane askem po ol samting, i go gede dem samting wanem em i bin askem po. Ebribodi uda i lukraun po em i go painem. Ane God i go opene da doa po ebribodi uda i nok. ");
INSERT INTO tcs_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘Wen ol pikinini blo yupla i aske yupla po kaikai, wiswei, yupla gibe dempla ol kaikai o gibe dempla ol ston? ");
INSERT INTO tcs_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O ip dempla i aske yupla po pis, yupla go gibe dempla sneik a? Nono! Yupla no stupit! ");
INSERT INTO tcs_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nomata yupla ol pipol uda tumas meke ol nugudting, bat yupla stil gibe dem pikinini blo yupla ol gudsamting. Mata tingk aumas gudsamting PapaGod blo yupla de antap lo eben i gad po yupla ip yupla i aske em.’ ");
INSERT INTO tcs_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Zizas i spik, ‘Ip yupla wande sambodi po meke gudsamting po yupla, wel yupla mas meke da seimkainting tu po dempla. Diswan i wanem Baibol i tokbaut.’ ");
INSERT INTO tcs_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Den Zizas i spik mo, ‘Ip yupla i wagbaut lo dat naro geit, yupla gobi de lo da ples wea God i go ruloba ebribodi. Bat ip yupla i wagbaut lo dat big rod, yupla i go kese dat ples neim el. Plenti pipol i bin wagbaut lo dat big rod, bikoz i mina izi, i gad mina big speis po wagbaut. ");
INSERT INTO tcs_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bat datwei po gede longlaip poeba i mina smol ane da geit i mina naro. Mata lelbet pipol i paine dat geit.’ ");
INSERT INTO tcs_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Zizas i kip spik, ‘Lugaut prom ol lai pipol uda i spik dat dempla i ol spesilmesizman blo God. Bat dempla i go kam ane tok laiwan po yupla po meke yupla bilib lo da laiwei blo dempla. Ane wen dempla i go kam po tok po yupla, dempla i go meke demplaselp wase gudpipol, bat prapa, dempla i prapa nugud. ");
INSERT INTO tcs_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ane ip yupla i kip wase dempla ebridei po wanem dempla i mekem, den yupla i go sabe wiskain pipol dempla. Dempla i wase dem pama uda i zaze tri lo da kaikai dat tri i sakem. Ol sabe ip da tri i gud o nugud. Prut blo greip i kan gro midel lo ol putigras, ane da gudprut blo pigtri i kan gro midel ol tonibus. ");
INSERT INTO tcs_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Gudtri i sake gudprut ane nugudtri i sake nugudprut. ");
INSERT INTO tcs_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Gudtri i kan neba sake nugudprut. Ane nugudtri i kan neba sake gudprut. ");
INSERT INTO tcs_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ebridem tri wea i no sake gudprut, dem pama i katemdaun ane banem lo paia. ");
INSERT INTO tcs_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Wa, i seimkain tu po dem lai pipol uda i spik dempla i ol mesizman blo God. Ip yupla i kip wase dempla ebridei po wanem dempla i mekem, den yupla i go sabe wiskain pipol dempla.’ ");
INSERT INTO tcs_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Den Zizas i spik mo, ‘Plenti pipol i kam ane kole mi “BosLod”, bat stil dempla i nogo go antap po eben bikoz dempla i no meke demting wanem PapaGod blo mi de antap lo eben i spik po dempla po mekem. ");
INSERT INTO tcs_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lo dat dei bambai wen God i go zaze ol pipol, plenti pipol i go spik po mi diskain, “BosLod! BosLod! Mipla i bin prise ol gud mesiz baut yu, ane mipla i bin yuze neim blo yu po meke olkain mirikal ane po tekemaut nugudspirit prom ol pipol.” ");
INSERT INTO tcs_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Bat ai go spik po dempla, “Ai no bin sabe yupla. Gowei prom mi, yupla ol nugudpipol.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Zizas i spik mo, ‘Enibodi uda i lisen po wanem ai spik ane mekem, em wase man uda i bilde aus blo em antap lo ad graun. ");
INSERT INTO tcs_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nomata strong win i blo, bigblaik i kam, ane pladwata i kamap, dat aus i kan poldaun bikoz i bin bildem antap lo ad graun. ");
INSERT INTO tcs_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bat enibodi uda i lisen po wanem ai bin spik bat no mekem, em wase man uda i bilde aus blo em antap lo sanbis. ");
INSERT INTO tcs_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wen strongwin i blo, bigblaik i kam ane pladwata i kamap, dat aus i go poldaun smas.’ ");
INSERT INTO tcs_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wen Zizas i bin pinis nau prom tok po dem pipol, ol dem pipol i bin stap prapa kuaiat, ol atzamp ane tingbaut po dem tok wanem Zizas i bin spik po dempla. ");
INSERT INTO tcs_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Dem tising wea em i bin tise dempla i kare lo, ane i gad paua, ane i no wase dem tising blo dem lida blo dem zuwispreaus. ");
INSERT INTO tcs_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wen Zizas i bin pinis tok po dem pipol de antap dat il, em i bin kamdaun. Ane prapa plenti pipol i bin pole em. ");
INSERT INTO tcs_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Den wan man uda i gad nugud skindiziz i bin kam po Zizas ane nildaun prant lo em ane spik, ‘BosLod ip yu wandem, yu ken meke mi gudgen.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","So Zizas i bin tase da man ane spik, ‘Wa. Ai wandem. Yu kam orait nau.’ Stretwei da sik i bin libe da man. ");
INSERT INTO tcs_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Den Zizas i bin spik po em, ‘No spik nobodi wanem i bin apen ya po yu. Nau yu mas stretwei go po luk prist solong da prist i go luk bodi blo yu ip i bin kamgud prom dat sik. Bat wen yu go po luk da prist, yu mas kare opring go po meke sakripais wase Mozeslo i bin spik de longtaim pas po dat seim sik, bikoz i po prubem yu nomo gad dat sik nau.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Prom de, Zizas i bin go po Kapaniam. Wen em i bin mangi de, wan sekan amiopisa blo Rom i bin kam ane tok wea em. ");
INSERT INTO tcs_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Em spik, ‘BosLod. Pliz gar. Mai yang wokman de leidaun lo bed lo aus blo mi. Em kan mube bodi blo em ane em i gad nadakain nugud pein.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Zizas i spik po em, ‘Ai go kam ane meke em gud.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Bat da amiopisa i bin spik baik po Zizas, ‘BosLod, yu kan kam po aus blo mi, bikoz ai nobodi. Yu mata tok prom ya ane wokman blo mi i go bi orait! ");
INSERT INTO tcs_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ai sabe ai andanit lo paua blo da big bos blo mi. Bat ai gad paua tu oba ebridem amiman blo mi. Wen ai spik po dempla po go, dempla go. Wen ai spik po dempla po kam, dempla i kam, ane wen ai spik po ol wokman blo mi, po meke disting o datting, dempla i mekem.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wen Zizas i bin lisen wanem da amiopisa i bin spik, em bin atzamp. Em bin tanraun po dem plenti pipol uda i bin pole em ane spik, ‘Ai spik trutok po yupla, ai no bin luk nobodi ya lo Izrael uda i gad demkain bilib wase dis man ya. ");
INSERT INTO tcs_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ai spik yupla disting ya tu. Plenti pipol uda i Nozuwisman, i go kam prom ebriwea, prom ol nada kantri ane sidaun lo Eibram, Aizak, ane Zekop po kaikai lo da ples wea God i ruloba ebribodi de antap lo eben. ");
INSERT INTO tcs_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bat plenti dem pipol blo God, dem pipol blo Izrael uda prapa no lisen ane mekem wanem God i bin spik dempla po mekem, God i go sake dempla go ausaid po dat nadakain dakples wea dempla i go mata krai ane graine tit blo dempla.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Den Zizas i bin spik po dat amiopisa, ‘Go aus nau, bikoz bilib blo yu i bin meke da yang wokman orait.’ Ane da yang wokman i bin kam orait dat seimtaim. ");
INSERT INTO tcs_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Prom de Zizas i bin go po aus blo Pita. Wen em i bin mangi de, em luk da madalo blo Pita i bin leidaun lo bed, sikwan gad piba. ");
INSERT INTO tcs_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","So em bin go po da oman ane tase an blo em. Stretwei da piba i bin libe da oman. Den em bin gedap ane meke kaikai po Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wen da san i bin godaun, plenti pipol i bin teke ol dem pipol uda i bin gad ol nugudspirit insaid lo dempla kam po Zizas. Den Zizas i bin gibe oda po dem nugudspirit po kamaut ane dem nugudspirit i bin stretwei kamaut. Ane dem nada pipol uda i bin gad olkain dipren dipren sik, Zizas i bin meke dempla kamgud tu. ");
INSERT INTO tcs_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Diswan i po prube da tok blo Aizaia, da longtaim spesilmesizman blo God. Aizaia bin spik diskain ya: ‘Dat man i bin tekemaut olkain sik prom yumpla, ane meke yumpla nomo gad ol diziz.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wen Zizas i bin luk da bigmob blo pipol i bin kam mobig, em bin spik dem klostuman blo em po kros go po da nada said blo da leik. ");
INSERT INTO tcs_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bipo dempla i bin krosem go, wan Zuwislotisa i bin kam ane tok po Zizas diskain, ‘Tisa, nomata wea yu go, ai go mata pole yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Bat Zizas i bin spik po em, ‘Ol dem wail dog i gad ples po slip insaid, ane ol dem pizin i gad nest po slip insaid. Ane mi, da Truwan blo Man i nogad no ples po slip, no iben pela po pute ed blo mi antap.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Den gen, wan klostuman blo Zizas i bin spik, ‘BosLod, lete mi go aus pas po bere papa blo mi, den wen ai go pinis ai go kambaik ane pole yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Zizas i bin spik baik po em, ‘Pole mi nau. Lete demwan uda i no lisen ane meke wok blo God i go bere papa blo yu. Nomata dempla stil laip bat prapa dempla ded.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Den apta, Zizas ane ol klostuman blo em i bin zamp insaid lo da bot ane tekop go kros po da nadasaid blo da leik. ");
INSERT INTO tcs_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Wen dempla i bin midel lo da leik, prapa strongwin i bin kese dempla de, ane ol prapa bigsi i bin brok kam insaid lo da bot. Zizas i bin de slip. ");
INSERT INTO tcs_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Dem klostuman blo em bin go ane weikemapem. Ol i bin ala diskain, ‘BosLod yumpla go draun! Seibe yumpla prom ded!’ ");
INSERT INTO tcs_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Zizas i bin weikap ane spik po dempla, ‘Watpo yupla prait? Aukam yupla nogad bilib lo mi?’ Den em bin oda da strongwin ane bigsi po stap kuaiat. Stretwei da strongwin ane bigsi i bin kam mutaru. ");
INSERT INTO tcs_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Dempla i bin atzamp ane prait tu wen ol i bin luk ane lisen po wanem Zizas i bin spik po da strongwin ane bigsi. Dem klostuman i bin spik po demplaselp diskain, ‘Wiskain man diswan? Em i gibe oda po da strongwin ane bigsi po stap kuaiat, da strongwin ane bigsi i lisen po em!’ ");
INSERT INTO tcs_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Zizas ane ol klostuman blo em i bin kesem de nadasaid blo Leik Galali lo da lan blo dem Gerasinpipol. Tu man i bin mite em de uda i bin gad nugudspirit insaid lo demtu. Demtu stap de insaid lo dem keib wea ol pute ded bodi. Demtu i ebritaim wande pait, daswai ol pipol i no wagbaut lo dat rod de klostu po dem keib. ");
INSERT INTO tcs_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Wen demtu bin luk Zizas, demtu i bin ala nadakain laudwan po em diskain ya, ‘Boi blo God! Wanem yu go mekem lo mitu? Yu kam nau po panis mitu pas bipo da taim wea God i bin setem po panis mitu a?’ ");
INSERT INTO tcs_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","I bin gad bigmob blo pig i bin kaikai de, lelbet longwei. ");
INSERT INTO tcs_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Dem nugudspirit i bin bege Zizas, ‘Ip yu go oda mitu po kamaut prom dis tu man ya, sane mitu go insaid po dem bigmob blo pig de, plizgar.’ ");
INSERT INTO tcs_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Den Zizas i bin oda, ‘Go. Go nau!’ Stretwei dem nugudspirit i bin kamaut ane go insaid lo dem bigmob blo pig, ane dem pig i bin ran godaun prom dat stip il godaun insaid po da leik ane draune demplaselp. ");
INSERT INTO tcs_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Dem man uda i bin lukapta dem pig ol i bin ran godaun po taun blo dempla ane spik po ebribodi wanem i bin apen po demtu man uda i bin gad ol nugudspirit insaid lo demtu. ");
INSERT INTO tcs_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ebribodi prom da taun i bin go ausaid po mite Zizas. Ane wen ol i bin mite em de, ol bin askem po gowei prom da eria blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Zizas i bin zamp baik insaid lo da bot lo ol klostuman blo em ane ol bin gobaik po taun blo em. ");
INSERT INTO tcs_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Wen ol bin mangi de, sam pipol i bin kare wan paralaizman kam antap lo mat. Wen Zizas i bin luk dempla, em bin sabe dempla i bin prapa bilib lo em. So em i bin spik po da man, ‘Mai pren! Ai bin tekemaut dem nugudwei prom yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","I bin gad sam Zuwislotisa de midel lo dem pipol. Wen ol i bin lisen wanem Zizas i bin spik, dempla i bin tok po demplaselp diskain, ‘Ei! Dis man i tok badtok gense God. Em meke emselp wase em God.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Zizas i sabe wanem dempla i bin tingk, so em i bin spik po dempla, ‘Aukam yupla i gad demkain nugudtot? ");
INSERT INTO tcs_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wiswei yupla tingk, i moizi po spik po dis paralaizman, “Ai bin tekemaut dem nugudwei blo yu”, o po spik, “Gedap ane wagbaut”? ");
INSERT INTO tcs_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ai go soe yupla ai da Truwan blo Man, ai gad paua, ai kare lo ya lo ert po tekemaut ol nugudwei blo ol pipol.’ Den em bin tan po dat paralaizman ane spik, ‘Gedap, teke mat blo yu ane go aus, bikoz yu nomo paralaiz nau.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Stretwei da man i bin gedap, teke mat blo em ane go aus! ");
INSERT INTO tcs_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wen dem pipol i bin luk lo ai blo dempla wanem i bin apen po da paralaizman de, dempla i bin atzamp ane nadakain prait tu. So dempla i bin mata preize neim blo God po sane diskain man kam uda i gad prapa nadakain bigpaua po kare lo. ");
INSERT INTO tcs_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Okei. Zizas i bin wagbaut godaun lo rod ane em bin luk Matiu i bin sidaun de wea taksopis ples blo em. Em weit po ol pipol po kam de po pei taksmani blo dempla po em. Zizas i spik po em, ‘Kam, yu kam klostuman blo mi.’ So Matiu i bin gedap ane pole Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wen san i bin godaun, Matiu i bin singaut Zizas ane ol klostuman blo em, dem nada pren blo Matiu uda i bin meke da seim wok wase em, ane olkain nugudpipol, po kam ane kaikai de lo aus blo em. ");
INSERT INTO tcs_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wen sam dem Parasi i bin luk Zizas i bin kaikai midel lo dem nugudpipol, dempla i bin aske dem klostuman blo Zizas diskain, ‘Aukam yupla ane tisa blo yupla i kaikai midel lo ol dem taksman ane dem rabis pipol?’ ");
INSERT INTO tcs_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Wen Zizas i bin lisen wanem dem Parasi i bin spik, em bin spik baik po dempla diskain, ‘Dem pipol uda i no sik ol no wande dokta, bat dem pipol uda i sik, ol wande dokta.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Den em bin tok gen po dempla. Em spik, ‘Go ane paindaut prapa insaid lo Baibol wanem da mining wen God i bin spik diskain ya: “Ai wande pipol po lugaut wananada, no po mata meke animal sakripais po mi.” ’ Den Zizas i bin spik stret po dempla, ‘Ai no bin kam ya po ert po spik dem pipol uda tingk dempla rait ane stret, po libe dem nugudwei blo dempla. Ai bin kam po spik dem pipol uda sabe dempla nugud, po libe dem nugudwei blo dempla.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Apta nau, dem klostuman blo Zon Baptaizman i bin kam de po Zizas ane askem, ‘Aukam mipla ane dem Parasi no kaikai po mata prea, bat ol klostuman blo yu i no meke demkain?’ ");
INSERT INTO tcs_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Zizas i spik baigen po dempla, ‘Dem pren blo da man uda i go maret, ol nogo pil sore midel wea da maret, bikoz em i go maret de lo dempla. Bat apta, taim i go kam po gowei prom dempla, em ane oman blo em i go libe dempla ane go. Den dempla i go pil nadakain sore, ane da sore blo dempla i go meke dempla gibap kaikai. ");
INSERT INTO tcs_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‘Ip yu pase pis blo niu matirial lo oul klos wea i brok, da niu matirial i go strese dat oul klos ane da tea wea dat oul klos i go kam mobig. ");
INSERT INTO tcs_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","‘Ane ip yu kapsaid niu wain insaid lo oul skinbaig da oul skinbaig i go swelap ane bas prom dat niu wain, ane da wain i go kapsaid ane ran go ausaid. So niu wain i mas putem insaid lo niu skinbaig solong demtu i go mata stap rait.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wen Zizas i bin stil tok de, wan lida blo da zuwispreaus i bin kam ane nildaun prant lo em ane spik, ‘Mai smolgel i bin disnau ded. Pliz gar, ken yu kam ane pute an blo yu antap lo em po mekem kamlaipgen?’ ");
INSERT INTO tcs_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","So Zizas ane dem klostuman blo em i bin stat po wagbaut go po dat aus. Ol bin wagbaut go. ");
INSERT INTO tcs_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","I bin gad wan oman uda po tuelb iya bin kare siknis blo oman wea em bin luze tumas blad. ");
INSERT INTO tcs_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Em bin tingk po emselp diskain, ‘Ip ai go tase klos blo Zizas, den dis sik ya i go stap.’ So em i bin kam biain lo Zizas ane tase end blo da klos blo em. ");
INSERT INTO tcs_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Zizas i bin tanraun po da oman ane spik po em, ‘Yu no wori, bikoz dat strong bilib blo yu wea yu gad lo mi, i bin meke da sik ranwei prom yu. Yu nomo gad dat sik nau.’ Stretwei da oman i bin kamgud. ");
INSERT INTO tcs_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wen Zizas i bin mangi de lo dat aus, em bin luk plenti pipol i bin de krai po da smolgel, ane ol nadalot i bin sing ol piunrul sing. ");
INSERT INTO tcs_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Zizas i bin spik po dem bigmob pipol, ‘Gowei! Da smolgel i no ded, em mata slip.’ Wen Zizas i bin spik diskain, dem bigmob pipol i bin lap lo em. ");
INSERT INTO tcs_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Dem pamle blo da smolgel i bin spik po dem pipol po go ane stanap ausaid prom dat aus. Wen dem pipol i bin de ausaid nau, Zizas i bin go insaid ane kese an blo da smolgel. Da smolgel i bin gedap ane stanap. ");
INSERT INTO tcs_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Den apta nau, niuz baut da smolgel i bin spred go ebriwei lo da kantri eria. ");
INSERT INTO tcs_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Apta Zizas i bin libe dat aus blo da smolgel ane wagbaut go, tu blainman i bin pole em biain. Demtu i bin ala demkain, ‘Yu Promiswan wase King Deibid. Plizgar soe sorewei po mitu ane elpe mitu!’ ");
INSERT INTO tcs_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Demtu i bin pole Zizas go raitinsaid lo dat aus wea Zizas i go stap. Den Zizas i bin tanraun ane spik po demtu, ‘Yutu bilib ai ken meke yutu luk a?’ Demtu i bin ansa baik, ‘Wa, BosLod. Mitu prapa bilib.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Den Zizas i bin tase ai blo demtu ane spik, ‘Bikoz yutu gad strong bilib, yutu go luk gen.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Stretwei demtu i ken luk! Den Zizas i bin tokstrong po demtu, ‘No spik nobodi wanem i bin apen ya po yutu.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bat demtu no bin tekenotis wanem Zizas i bin spik po demtu. Demtu i bin go ane sprede da niuz ebriwea lo dat eria. ");
INSERT INTO tcs_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wen demtu man i bin go nau, sam pipol i bin teke wan man kam po Zizas uda i kan tok bikoz em bin gad nugudspirit insaid lo em. ");
INSERT INTO tcs_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Den Zizas i bin oda da nugudspirit po kamaut prom da man ane stretwei da nugudspirit i bin kamaut ane da man i bin tok. Dem bigmob pipol uda i bin de, ol bin atzamp ane spik diskain, ‘Ei! Wanem diswan? Diskainting i no bin apen ya lo dis kantri blo Izrael bipo!’ ");
INSERT INTO tcs_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wen dem Parasi i bin luk, ol bin spik diskain, ‘Em i gede paua blo em prom Satana, daswai em ken tekemaut nugudspirit prom ol man.’ ");
INSERT INTO tcs_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Apta prom de, Zizas i bin go tru ebri taun ane biliz blo da kantri. Em i meke ebri pipol uda i bin gad olkain sik kamgudgen ane em bin tise ol pipol de lo dem zuwispreaus baut da Gudniuz wen God i go ruloba ebribodi. ");
INSERT INTO tcs_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Em bin pil nadakain sore po dem bigmob pipol uda i bin kam de, bikoz dempla i bin gad nobodi po elpe dempla. Dempla i bin prapa taiat ane wori. Dempla i bin wase sip nogad bos po lugaut demwan. ");
INSERT INTO tcs_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Den Zizas i bin tan po ol klostuman blo em ane spik, ‘Plenti pipol i no sabe da wei go po God ane i gad mata lelbet wokman blo God po meke da wok. ");
INSERT INTO tcs_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","So yupla mas prea ane aske God po sane plenti wokman kam, solong ol go tise ebribodi baut da raitwei go po God.’ ");
INSERT INTO tcs_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Zizas i bin singaut dem tuelb klostuman blo em. Em bin gibe dempla paua po kare lo po tekemaut nugudspirit prom ol pipol ane po meke ol pipol kamgudgen prom olkain dipren dipren sik. ");
INSERT INTO tcs_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Demwan dem neim blo dem tuelb misnareman ya: paswan, Saiman (nada neim blo em i Pita), den Andru (bala blo Pita), Zemes (boi blo Zebadi), ane Zon (bala blo Zemes), ");
INSERT INTO tcs_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip, Batolomiu, Tomas, Matiu (da taksman), Zemes (boi blo Alpias), ane Tadias, ");
INSERT INTO tcs_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saiman (ol bin kole em da Zelot bikoz em pat blo dat Zelotgeng uda bin pait po dem rait blo ol Zuwispipol), ane Zudas blo Iskara (em da wan uda apta, bin sele Zizas po dem Zuwislida po kilem). ");
INSERT INTO tcs_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Bipo Zizas i bin sane dem tuelb misnareman blo em go, em bin tok strong po dempla. Em spik, ‘No go po dem pipol uda i Nozuwis, o po dem Samariapipol, ");
INSERT INTO tcs_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","bat go po dem pipol blo Izrael uda i no sabe God prapa. ");
INSERT INTO tcs_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Go ane spik po dempla baut da taim wea God i go ruloba ebribodi i klostu nau. ");
INSERT INTO tcs_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Demwan uda i sik o gad nugud skindiziz, meke dempla gud. Demwan uda i bin ded, meke dempla laipgen. Demwan uda i gad nugudspirit insaid lo dempla, tekemaut dem nugudspirit prom dempla. Wen ol pipol i go wande pei yupla po meke demting, mata spik po dempla, “I pri, bikoz da paua ane blesing wea yupla i gad nau, yupla bin gedem po pri.” ");
INSERT INTO tcs_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Wen yupla go, no kare no mani lo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","No kare no baig wea i gad spea klos insaid o sandol ane no kare wokingstik. Dem pipol wea yupla i go elpem, ol go gibe yupla demting wanem yupla i nidem. ");
INSERT INTO tcs_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Wen yupla i go insaid po eni taun, yupla mas lukraun po samwan uda i wande teke yupla po stap lo aus blo em. Stap de antil yupla i redi po go po neks taun. ");
INSERT INTO tcs_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wen yupla go insaid lo aus blo enibodi, yupla mas blese dat aus ane ol pipol blo dat aus. ");
INSERT INTO tcs_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ip dat pamle i api yupla stap de lo dempla, den lete da blesing blo yupla stap de lo dempla. Bat ip dempla i no api, wel God i nogo blese dempla. ");
INSERT INTO tcs_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ip pipol prom dat taun i no welkam yupla o no wande lisen po yupla, yupla mas seike dem graun prom sandol blo yupla prant lo dempla wen yupla libe dempla. ");
INSERT INTO tcs_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ai spik trutok po yupla, wen dat dei i go kam wen God i go zaze ol pipol, dem pipol blo dat taun wea i no bin welkam yupla ane no wande lisen po yupla, dempla i go gede mobig panisment den dem pipol blo dat tu siti blo Sodom ane Gomora. ");
INSERT INTO tcs_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Nau lisen, ai go sane yupla go ausaid po ples wea i gad ol mina nadakain nugudting. Yupla go go wase smolsip wagbaut wea ol wail dog i stap. Bat yupla mas smat wase sneik, ane kuaiat wase dab. ");
INSERT INTO tcs_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bat lugaut! Sam man i go teke yupla go po kot bambai, den apta ol i go ploke yupla insaid lo zuwispreaus. ");
INSERT INTO tcs_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dempla go trite yupla prapa nugudwei ane pose yupla po stanap prant wea ol gabana ane ol king. Ol i go mekem diskain po yupla bikoz yupla i pole mi. Ane wen yupla i go stanap de prant, i sans blo yupla nau po spik po dempla baut mi ane po dem pipol uda i Nozuwisman. ");
INSERT INTO tcs_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wen ol go kese yupla, no woribaut wanem yupla go spik bikoz God i go gibe yupla dem wod po spik de lo dat raittaim. ");
INSERT INTO tcs_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ane i no gobi yupla uda go tok, bat da Spirit blo God i go tok tru yupla. ");
INSERT INTO tcs_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Wen dat taim i go kam bambai, bala go gibe dempla oun bala po ol enami po kilem, ol papa i go gibe dempla oun pikinini po ol enami po kile dempla tu, ane pikinini i go meke da seimting po mama ane papa blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ebri pipol i go prapa no laik yupla bikoz yupla blo mi. Bat lisen, enibodi uda i mata stap strong po mi, raitap po end, God i go seibe dempla. ");
INSERT INTO tcs_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ip ol pipol i trite yupla nugudwei lo eni taun, no stap de, tekop go po nada taun. Ai spik trutok po yupla, yupla nogo pinis wok blo yupla lo ebridem taun blo Izrael bipo ai da Truwan blo Man i go kambaigen. ");
INSERT INTO tcs_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Zizas i bin spik, ‘Tisa i gad mosabe den skul pikinini ane bos i gad mosabe den dem wokman blo em. ");
INSERT INTO tcs_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Yupla mas bi api po kam wase mi, tisa blo yupla. Da wokman mas api po kam wase bos blo em. Ai lida blo yupla. Ip ol pipol i kole mi Belzibel, da bos blo ol nugudspirit, den ol mas go kole yupla lo olkain nugudneim tu. ");
INSERT INTO tcs_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Bat no prait prom ol demkain pipol, bikoz da taim i stil de yet po kam wea ebriting i go kamaut klia. Dem sikretting wea ol pipol i bin aidem, i go kamaut wea ol i ken luk. ");
INSERT INTO tcs_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ane demting ya ai spik po yupla ya kuaiatwei, yupla mas go ebriwea ane spik demting. Demting wanem ai spik po yupla insaid lo aus, yupla mas tok prapa strong po ebri pipol solong ol go prapa sabe. ");
INSERT INTO tcs_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","‘No prait prom demwan uda wande kile yupla. Bikoz dempla mata ken kile bodi blo yupla, dempla kan tase spirit blo yupla. Prait prom God, bikoz em da wan uda i ken sake bodi ane spirit blo yupla insaid lo el. ");
INSERT INTO tcs_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yupla sabe tu smol pizin, neim sparo, demtu kos mina lelbet mani. Bat ip God no lauem po ded, wel demtu kan ded. ");
INSERT INTO tcs_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ane em i sabe aumas stran blo eya yupla i gad antap lo ed. ");
INSERT INTO tcs_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","So yupla no prait prom nobodi, bikoz yupla i mo impotant po em den prapa plenti sparo. ");
INSERT INTO tcs_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Ip eniwan i tokbaut mi prant lo ol pipol ya lo ert, den ai go spik prant lo PapaGod blo mi lo eben diskain, “Em blo mi.” ");
INSERT INTO tcs_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bat ip eniwan i no tokbaut mi po ol pipol ya lo ert, den ai go spik prant lo PapaGod blo mi lo eben diskain, “Ai no sabe em.” ");
INSERT INTO tcs_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘No tingk ai bin kam po meke pis ya lo ert! Nono! Ai bin kam po separeit ol pipol. ");
INSERT INTO tcs_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","“Ai bin kam po meke boi go gense em papa, gel go gense em mama, ane dotalo go gense em madalo. ");
INSERT INTO tcs_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dem pamle insaid lo wan aus, nogo laik wananada, bikoz prom mi!” ");
INSERT INTO tcs_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Ip eniwan wande kam wokman blo mi, den em mas laik mi moden papa blo em, mama blo em, boi blo em ane gel blo em. Ip yu no redi po datwan, den yu no pit po kole yuselp wokman blo mi. ");
INSERT INTO tcs_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ane ip eniwan i no redi po pole mi ane ded po mi, den em no pit po kam wokman blo mi. ");
INSERT INTO tcs_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Eniwan uda i prapa lugaut laip blo em po dis wold ya, wel em kan gede dat nada laip. Bat eniwan uda i mata stap ya lo ert lo da laip blo mata pole mi, wel em go gad dat nada laip. ");
INSERT INTO tcs_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Eniwan uda i welkam yupla ol wokman blo mi, i welkam mi tu, ane eniwan uda i welkam mi, i welkam PapaGod blo mi tu uda i bin sane mi. ");
INSERT INTO tcs_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ip yu welkam wan spesilmesizman blo God, wel God i go gibe yu da seimkain preiz wiskain da spesilmesizman i gedem. Ip yu welkam ol rait ane stret pipol prom dem rait ane stretwei dempla mekem, yu go gede seimkain riwod wiskain dempla gedem. ");
INSERT INTO tcs_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ane ip eniwan iben gibe wan kolwata glas po dis smolpikinini ya uda i pole mi, em mas go gede riwod lo preiz.’ ");
INSERT INTO tcs_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wen Zizas i bin pinis tok po dem tuelb klostuman blo em de, em bin tekop go po dem taun lo eria blo Galali, ane tokbaut da gudniuz po dempla de, ane tise ol pipol de. ");
INSERT INTO tcs_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Zon Baptaizman i bin de insaid lo zeilaus ane em i bin lisenbaut demting wanem da Promiswan uda God i bin sanem kam, i bin mekem. So Zon i bin sane ol klostuman blo em po aske Zizas kuestin. ");
INSERT INTO tcs_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Dempla i bin kam de ane aske Zizas, ‘Yu spik po mipla. Yu nau dat spesilwan wea Zon i bin tokbaut i go kam a, o mipla i go kip luk po wattaim da Promiswan blo God i go kam?’ ");
INSERT INTO tcs_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Zizas i bin spik po dempla, ‘Gobaik po Zon ane spik po em wanem yupla i bin luk ane lisen: ");
INSERT INTO tcs_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","demwan uda bin blain, nau ol luk; demwan uda bin kripol, nau ol wagbaut stret; demwan uda bin gad nugud skindiziz, nau ol nomo gad; demwan uda bin dep, nau ol lisen; demwan uda bin ded, nau ol laip; ane dem poapipol bin lisen ane sabe nau baut da Gudniuz blo God. ");
INSERT INTO tcs_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ane spik po Zon, “Demwan uda i go mata stap gad strong bilib lo mi, God i go blese dempla.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wen Zizas i bin pinis prom tok nau, dempla i bin go. Den Zizas i bin tok po dem bigmob pipol de baut Zon. Em bin spik po dempla, ‘Wen yupla i bin go de po luk Zon lo ples wea i nogad man, wiskain man yupla i bin tingk em bin? Yupla no bin go de po luk ol long gras wea i mub go diswei ane datwei wen da win i blou. ");
INSERT INTO tcs_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","So wanem yu bin go de po luk? Yupla bin tingk em bin risman were ol prapa plasklos? Pipol uda i dresap demkain, were ol prapa plasklos, ol stap lo palis. Ol i no stap lo ples wea i nogad man. ");
INSERT INTO tcs_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Wel, yupla spik po mi nau, yupla no bin kasa go de po luk em a? Yupla i bin go de po luk spesilmesizman blo God. Wa, ai spik po yupla, Zon em no kasa spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Lo Baibol i bin spik diskain ya baut Zon: “Ai go sane mesinza blo mi go pas, po meke da rod redi po yu.” ");
INSERT INTO tcs_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","‘Ai spik trutok po yupla ya, Zon Baptaizman, em i mina impotant man. Em i mo impotant den enibodi uda i bin bon po dis wod. Bat iben po da man uda i louklas wea da ples wea God i ruloba ebribodi, dat man i mobig den Zon! ");
INSERT INTO tcs_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ane prom da taim wen Zon Baptaizman i bin stat po pris mesiz blo God ane baptaiz ol pipol kam antil nau, plenti pipol i bin trai prapa ad po spoile da tising wea Zon i bin tise ol pipol baut longlaip poeba ane da ples wea God i ruloba ebribodi. ");
INSERT INTO tcs_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ai spik po yupla, bipo Zon i bin kam, ol dem longtaim spesilmesizman blo God i bin tok de pas baut dis niuwei ya nau wanem Zon i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ip yupla bilib wanem Baibol i bin spikbaut Ilaiza, den yupla go bilib dat Zon Baptaizman i Ilaiza. ");
INSERT INTO tcs_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yupla lisen uda gad talinga, ane yupla prapa tingbaut nau! ");
INSERT INTO tcs_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘Ai go spik yupla wiskain pipol blo tidei. Pipol blo tidei kan lisen. Ol tumas plei wase smolpikinini ane tumas komplein po pren blo dempla: ");
INSERT INTO tcs_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mipla sing ol maret sing po yupla, bat yupla no wande dans. Den mipla sing ol sore sing po yupla, bat yupla no wande krai.” ");
INSERT INTO tcs_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","‘Wen Zon Baptaizman i bin kam, plentitaim em no bin kaikai bat mata prea ane em no dringk wain wase ol nada pipol. Bat ol pipol i bin spik, “Em i gad nugudspirit insaid lo em.” ");
INSERT INTO tcs_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Bat wen mi, da Truwan blo Man i bin kam, ol pipol i bin spik diskain, “Ei, luk em kai. Em kaikai ane dringk wain tumas, ane em i pren blo ol taksman ane ol nada nugudpipol.” Pipol i go luk dem waizwei blo God i rait wen dempla go luk dem waizwei blo dem pipol blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Den Zizas i bin daune dem taun wea em i bin meke ol plenti mirikal apen de, bikoz dem pipol blo dem taun no bin tan po God. Ol bin stil meke ol nugudting. ");
INSERT INTO tcs_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Zizas i bin spik diskain, ‘Prapa nugudting i go apen po pipol blo dem tu taun ya, Korazin ane Betsaida, bikoz ai bin meke plenti mirikal de, bat ol pipol blo de no bin tekenotis. Ip dem seim mirikal i bin apen de lo demtu nugud taun blo Taira ane Sidon, ol pipol blo dat tu taun i bin pinis libe dem nugudwei blo dempla ane tan po God. Dempla i bin were klos wea i bin mekem prom esianbaig po soem dat dempla sore, ane ol mas sake asis antap ed blo dempla po soe God dat dempla i bin prapa sore po dem nugudting wea dempla i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wen dat taim i go kam po God i go zaze ebri pipol, God i go panis dem pipol blo Korazin ane Betsaida moden dem pipol blo Taira ane Sidon. ");
INSERT INTO tcs_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","‘Ane yupla pipol blo taun blo Kapaniam, no tingk God i go teke yupla go antap po eben. No, em go sake yupla insaid el, bikoz ai bin meke mirikal de prant lo yupla. Bat yupla no bin wande tekenotis ane tan prom dem nugudwei blo yupla. Ai spik po yupla tru, ip ai bin meke mirikal de po dem pipol blo Sodom, God no bin smase da siti. ");
INSERT INTO tcs_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ane wen da taim i go kam po God i go zaze ebri pipol, yupla dem pipol blo Kapaniam i go gede mobig panis den dem pipol blo Sodom.’ ");
INSERT INTO tcs_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Den Zizas i bin prea diskain ya, ‘PapaGod, AntapGod blo eben ane ert, mina big eso po aide dem truwei prom demwan uda i tingk dat dempla i sambodi, bat po soem po demwan uda i wase smolpikinini. ");
INSERT INTO tcs_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wa, PapaGod blo mi, ai bin meke demting wea yu bin wandem!’ ");
INSERT INTO tcs_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Den Zizas i bin spik, ‘PapaGod blo mi i bin gibe mi paua oba ebriting. Ane nobodi i sabe mai PapaGod mata mi, ane nobodi i prapa sabe Boi blo em, mata PapaGod. Ane dem pipol uda da Boi i wande soem po da PapaGod, i demwan nau uda i go sabe da PapaGod. ");
INSERT INTO tcs_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ane Zizas i kip spik, ‘Yupla uda kare ebiloud, kam po mi ane ai go meke yupla spel. ");
INSERT INTO tcs_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mata meke wok blo mi, ane lane demting wea ai bin mekem. Ebritaim ambol yuplaselp ane ebritaim meke samting wea gudwei. Wen yupla i go mekem demkain, yupla i go gede longlaip poeba. ");
INSERT INTO tcs_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yupla sabe, po pole tising blo mi i prapa izi, ane po mekem i no ad.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Apta nau lo wan Zuwis Sabatdei, Zizas ane ol klostuman blo em i bin wagbaut midel lo pam blo wit. Dem klostuman blo em i bin anggre so dempla i bin broke sam dem wit, sakwei dem ausaid pat, ane kaikai da insaid sidpat. ");
INSERT INTO tcs_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Wen sam dem Parasi i bin luk wanem dem klostuman blo Zizas i bin mekem, ol bin spik po Zizas, ‘Yu sabe dempla i bin broke da lo, ol no mas wok broke wit lo Zuwis Sabatdei.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Zizas i bin spik baik po dempla diskain, ‘Yupla i bin rid lo Baibol wanem King Deibid ane ol klostuman blo em i bin mekem wen dempla i bin anggre a? ");
INSERT INTO tcs_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dempla i bin go insaid lo aus blo God, ane kaikai da spesil bred, wea mata prist i lau po kaikai. So yupla lisen nau, dempla i bin broke da lo tu. ");
INSERT INTO tcs_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ane yupla bin rid wanem dem Mozeslo i bin spik a? Em bin spik diskain ya, “Ip i taim blo da prist po meke prea insaid lo aus blo God, ane dat dei i stret lo Zuwis Sabatdei, den em mas meke amen wok lo dat Sabatdei.” ");
INSERT INTO tcs_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ai spik po yupla disting ya, i gad sambodi ya uda i mo impotant den da lo blo Tempol blo God. ");
INSERT INTO tcs_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yupla no prapa sabebaut dem wod wea God i bin tok lo Baibol, wea em i bin spik diskain ya, “I mo impotant po ol pipol po soe sorewei po wananada den po meke ol opring sakripais po mi.” Ip yupla i bin prapa sabe wanem i bin min, den yupla no bin paine polt lo ol nada pipol. ");
INSERT INTO tcs_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yupla ebribodi lisen. Ai nau da Truwan blo Man wea God i bin sanem, ane ai da BosLod blo da Sabatdei.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Apta prom de Zizas i bin lego go po da zuwispreaus. ");
INSERT INTO tcs_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Wen em bin kesem de, em bin luk wan man uda i bin gad kripol an. Dem Parasi bin de tu. Dempla bin trai po paine polt lo Zizas solong dempla i ken tekem go po kot. So dempla i bin askem, ‘I orait po ile man lo Zuwis Sabatdei a?’ ");
INSERT INTO tcs_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Zizas i bin spik baik po dempla diskain, ‘Ip yupla gad wan sip ane em i poldaun insaid lo wel lo Zuwis Sabatdei, wiswei, yupla mas meke wok go ane tekemautem prom da wel a? ");
INSERT INTO tcs_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pipol i mo impotant den sip! Wa, i mina rait po meke gudting lo Sabatdei.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Den Zizas i bin spik po da man, ‘Strete an blo yu kam ya!’ Da man i bin mekem ane stretwei dat an blo da man i bin orait wase da nada an blo em. ");
INSERT INTO tcs_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Den apta dem Parasi bin go prom de ane bin meke miting po paine wei po kile Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bat Zizas i bin sabe plan blo dempla. So em bin go prom dat eria, ane plenti pipol i bin pole em go. Ane em bin tekemaut sik prom ebridem pipol uda i bin sik, ");
INSERT INTO tcs_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","bat em bin wone dempla no po spik ol nada pipol wanem em i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Diswan i po prubem wanem Aizaia, da longtaim spesilmesizman blo God i bin spik. Em bin spik diskain: ");
INSERT INTO tcs_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Yupla luk dis sebant blo mi ya, wa, ai bin suzem. Ai prapa labem, ane ai prapa api po em. Ai go gibem Spirit blo mi, ane em i go meke pis lo ebri kantri ebriwea. ");
INSERT INTO tcs_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Em nogo graul o saut po ol pipol, ane em nogo tok rapwei prant wea ol pipol. ");
INSERT INTO tcs_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Em go elpe demwan uda i no strong ane pil sore, ane elpe demwan uda i kan lukapta demplaselp. Em go kip mekem antil ol pipol i go prapa sabe da raitwei. ");
INSERT INTO tcs_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ane olkain pipol prom ebriwea, i go bilib lo em.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Apta nau, sam pipol i bin teke man kam po Zizas uda i bin blain ane kan tok bikoz em i bin gad nugudspirit insaid lo em. Ane Zizas i bin meke dat man po luk ane tok. ");
INSERT INTO tcs_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Wen Zizas i bin meke da man gud, dem bigmob pipol uda i bin de ol bin prapa atzamp. Ol i bin tok po wananada diskain, ‘Ei! Maitbi diswan i prapa Boi blo King Deibid, da Promiswan uda God i go sanem kam, bikoz em i gad paua po tekemaut nugudspirit?’ ");
INSERT INTO tcs_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bat wen dem Parasi bin lisenbaut wanem Zizas i bin mekem po da man, dempla i bin spik diskain ya, ‘Daswai em ken tekemaut nugudspirit prom man bikoz em i gede paua blo em prom Satana.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Zizas i bin sabe wanem dempla bin tingbaut, so em i bin spik po dempla diskain, ‘Eni kantri uda i pait bituin demplaselp i go pinis. Seimkain po ol pipol blo ol siti tu. Ip ol pait bituin demplaselp ol go pinis, ane seimkain ip ol pamle meke da seimting tu. ");
INSERT INTO tcs_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","So ip Satana i pait gense ol wokman blo em, den bambai da ples wea em i ruloba i go pinis. ");
INSERT INTO tcs_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ip paua blo mi i kam prom Satana, den wanem paua dem pipol blo yupla i yuzem wen dempla i tekemaut nugudspirit prom ol pipol? I mas bi prom Satana tu! Demting wea dem pipol blo yupla i mekem i go soem kliawan dat yupla i rong. ");
INSERT INTO tcs_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bat ai spik po yupla, dat paua i bin kam prom da OliSpirit blo God. Em bin gibe mi da paua po tekemaut nugudspirit prom ol pipol, ane i po soe yupla da taim wea God i ruloba ebribodi i ya nau midel lo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ane ai spik ya gen. Ip enibodi wande go insaid aus blo wan strongman po stil, em i kan mata go insaid ane stil prant lo pes blo dat man. Em mas taiemapem pas bipo em ken stil ol samting blo dat strongman. ");
INSERT INTO tcs_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Enibodi uda i no elpe mi po teke ol pipol kam po God, i go gense God. Ane enibodi uda i no meke wok blo God, i meke wok gense God. ");
INSERT INTO tcs_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","‘Yupla lisen prapa gud. God i ken pogibe yupla prom dem nugudting wea yupla i bin spik ane wanem yupla mekem, bat ip enibodi i tok ol nugudtok gense da OliSpirit, God i nogo pogibe dempla. ");
INSERT INTO tcs_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Enibodi uda i tok olkain nugudtok gense mi, da Truwan blo Man, God i ken pogibe dempla. Bat enibodi uda i tok nugudtok gense da OliSpirit, God prapa nogo pogibe dempla ya lo ert, o de antap lo eben. ");
INSERT INTO tcs_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","‘Yupla tingbaut po dem tri. Ip yupla luk kaikai blo da tri i gud, wel yupla sabe da tri i gud, bat ip da kaikai i nugud, wel yupla sabe da tri i nugud. ");
INSERT INTO tcs_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yupla prapa wase sneik! Yupla prapa kan tokbaut eni gudsamting, bat mata ol nugud samting, dem seim nugud samting wea i bin ebritaim stap insaid lo at blo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ol pipol uda i gad gudat i ebritaim mata tok gud. Bat dem pipol uda i gad nugud at i ebritaim mata tok nugud. ");
INSERT INTO tcs_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nau lisen. Wen da dei i go kam po God i go zaze ol pipol, ebridem nugudtok wea yupla i bin tok, yupla mas eksplein ebridem tok po God. ");
INSERT INTO tcs_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Dem oun wod blo yupla i gobi witnis po yupla. Wanem yupla spik i ken baigemap yupla o i ken paine yupla gilti. So yupla mas prapa kepul wanem yupla spik.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Apta nau, sam dem Zuwislotisa ane dem Parasi i bin kam de po Zizas ane spik po em, ‘Tisa, mipla wande yu po soe mipla mirikalsain po prubem dat yu bin kamdaun prom God, dat yu gad rait po kare lo.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Zizas i ansa dempla baigen, ‘Mata nugudpipol ane demwan uda i no bilib wande luk mirikalsain. Bat wan sain ai go soe yupla i prom da spesilmesizman blo God neim Zona. ");
INSERT INTO tcs_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Zona i bin insaid lo beli blo dat bigpis po tri dei ane tri nait, ane da seimwei tu da Truwan blo Man i gobi insaid lo graun ya lo ert po tri dei ane tri nait tu. Wa, ai da Truwan blo Man. ");
INSERT INTO tcs_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","‘Wen da taim i go kam po God i go zaze ol pipol, ol dem pipol blo dat taun blo Ninaba i go stanap tugeda lo dem pipol blo tidei ane go tok gense dempla po dem rongting wea dempla i bin mekem. Bikoz prom da taim wen Zona i bin pris mesiz blo God po dem pipol blo Ninaba, dempla i bin wantaim libe dem nugudwei blo dempla ane tan po God. Bat i gad sambodi ya uda i mobig den Zona, bat yupla stil no wande libe dem nugudwei blo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Wen God i go zaze ol pipol, da kuin blo Siba i gobi de tu lo dat dei. Ane em i go tok gense dem pipol blo tidei po dem rongting wea dempla i bin mekem, bikoz em bin kam prom de prapa longwei ples po lisen mesiz blo God prom King Solomon. Ane i gad sambodi ya midel lo yupla uda i mobig den King Solomon. Bat yupla stil no wande lisen po em.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Den Zizas i spik diskain, ‘Ip sambodi i tekemaut nugudspirit prom man, da spirit i go tekop go lukraun po ples po stap, bat no paine nating. ");
INSERT INTO tcs_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Den da spirit i spik po emselp diskain, “Ai gobaik po da man wea ai bin kamaut prom.” So em gobaik po dat man ane paine em prapa klin ane taidi, ane nogad nobodi de i stap insaid. ");
INSERT INTO tcs_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","So da nugudspirit i go teke seben nada spirit, monugud den emselp, go ane ol stap insaid lo da man. Den da man i go kam monugud nau den bipo. Yupla luk nau. Dat seimting i apen ya nau tidei po dem pipol uda i meke nugudting.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Seimtaim nau wen Zizas i bin tok po dem bigmob pipol de, mama ane ol bala blo Zizas i bin sane tok lo wan man go po singaut Zizas po kam ausaid prom dat aus po dempla bikoz dempla wande tok po em. ");
INSERT INTO tcs_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dat man i bin go ane spik po Zizas diskain, ‘Mama ane ol bala blo yu ya stanap ausaid. Dempla wande tok po yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Zizas i bin spik diskain, ‘Uda i mama blo mi? Uda i ol bala blo mi?’ ");
INSERT INTO tcs_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Den em bin point po ol dem klostuman blo em ane spik, ‘Dempla ya i mama ane ol bala blo mi. ");
INSERT INTO tcs_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Enibodi uda i mata lisen ane mekem wanem PapaGod i wandem, i bala, sisi ane mama blo mi!’ ");
INSERT INTO tcs_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Da seimdei nau, Zizas i bin libe dat aus ane em i bin godaun po Leik Galali. ");
INSERT INTO tcs_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Wen em i bin kesem de lo sanbis blo da leik, i bin gad mina bigmob pipol i bin stanap raun lo em de so em i bin zamp insaid lo bot ane tise dem bigmob pipol prom de insaid go antap po da sanbis. ");
INSERT INTO tcs_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Em bin yan po dempla plenti stori wea i gad mining, seimkain wase dis stori ya: ‘Wan pama i bin go po plante sid lo gadan blo em. ");
INSERT INTO tcs_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wen em bin sake dem sid ebriwea lo da gadan eria, sam dem sid i bin poldaun lo rod, ane dem pizin i bin kam ane kaikai dempla. ");
INSERT INTO tcs_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Sam dem nadalot i bin poldaun antap lo stonigraun wea i gad ston andanit ane lelbet graun antap, ane dem sid i bin bas kuikwan. ");
INSERT INTO tcs_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bat wen da san i bin ot, em bin bane dem plant ane dem plant i bin draiap ded bikoz dem rut blo dempla i bin kan godaun po gede wata. ");
INSERT INTO tcs_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Dem nadalot sid i bin poldaun midel ol tonibus, ane wen ol bin gro, dem bus i bin skuize dempla. ");
INSERT INTO tcs_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Bat sam dem nadalot sid i bin poldaun lo gudgraun, ane dempla i bin gad plenti kaikai. Sam i bin gad tati kaikai, sam i bin gad siksti kaikai ane sam i bin gad andred kaikai moden wanem da pama i bin plantem. ");
INSERT INTO tcs_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yupla lisen uda gad talinga, ane yupla prapa tingbaut nau!’ ");
INSERT INTO tcs_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Apta wen em i bin pinis yan dem stori, dem klostuman blo em i bin aske em diskain ya, ‘Aukam yu ebritaim yan stori wen yu tok po ol pipol?’ ");
INSERT INTO tcs_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Zizas i bin spik po dempla diskain, ‘God i bin laue yupla po sabe demting baut wen God i go ruloba ebribodi. Bat dem nada pipol i no sabe. ");
INSERT INTO tcs_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Eniwan uda i wande lisen dem wod blo God, wel God i go gibem mosabe. Bat eniwan i no wande lisen dem wod, wel God i go tekemaut eni sabe blo God prom em. ");
INSERT INTO tcs_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Daswai ai yuze stori bikoz, Ol pipol i luk wanem ai mekem, bat ol i blain. Dempla lisen wanem ai spik, bat dempla i dep, dempla no sabe da mining wanem ai min. ");
INSERT INTO tcs_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Diswan i prubem wea da mesiz blo Aizaia da spesilmesizman blo God wea em bin spik: “Yupla go lisen ane lisen dem wod blo mi, bat yupla nogo sabe wanem i min. Yupla go luk ane luk wanem ai mekem, bat yupla nogo luk eniting. ");
INSERT INTO tcs_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bikoz main ane at blo dem pipol ya i no bilib enimo, dempla i bin kam aded. Ip dempla no bin koke talinga blo dempla ane no bin sate ai blo dempla, den dempla ol i bin luk ane lisen ane tekenotis. Den dempla go sabe wea at blo dempla ane go sluraun ane ai go pogibe dempla.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Den Zizas i bin spik po dem klostuman blo em diskain, ‘Yupla ya i prapa laki, bikoz ai blo yupla i ken luk, ane talinga blo yupla i ken lisen. ");
INSERT INTO tcs_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ai spik trutok po yupla, plenti dem spesilmesizman blo God ane dem rait ane stret pipol blo God i bin prapa wande luk wanem yupla i luk nau, ane lisen wanem yupla i lisen nau. Bat dempla no bin luk ane lisen demting ya nau. ");
INSERT INTO tcs_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","‘Nau ai go spik po yupla wanem ai bin min wen ai bin yan da stori baut da pama plante sid: ");
INSERT INTO tcs_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Orait. Dem sid wea i bin poldaun lo rod i wase demwan uda i bin lisen da mesiz blo God bat no sabe wanem i min. Stretwei Satana i kam ane teke da mesiz prom dempla. ");
INSERT INTO tcs_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Dem sid wea i bin poldaun lo stonigraun, i wase demwan uda i lisen da mesiz ane tritem gudwei po sotwail, ");
INSERT INTO tcs_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","bat prapa, i nogo raitdaun kese at blo dempla. Wen olkain trabol i kam po dempla, dempla i piged baut da mesiz nau. ");
INSERT INTO tcs_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Dem sid wea i bin poldaun lo tonibus, i wase demwan uda i lisen ane bilib da mesiz. Bat dempla tumas woribaut mani ane demting wea dempla i prapa wandem. Daswai da mesiz i kan wok lo laip blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Dem sid wea i bin poldaun lo gudgraun, i wase demwan uda i bin lisen ane bilib da mesiz, ane da mesiz i wok insaid lo laip blo dempla nau. Plenti kaikai i kamaut prom dem sid wea i bin poldaun lo da gudgraun. Seimkain wase dem plenti kaikai, da mesiz i bin meke dem pipol kam mostrong ebridei.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Den Zizas i bin yan po dempla nada stori. Em spik, ‘Da ples wea God i ruloba ebribodi, i seimkain wase pama uda plante ol gudsid lo gadan blo em. ");
INSERT INTO tcs_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bat wen naittaim i kam ane ebribodi i slip, enami blo em i kam ane plante putisid ebriwei lo da gadan tu. ");
INSERT INTO tcs_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","So wen dem gudsid i gro ane stat po sake kaikai nau, dem putigras i gro tu. ");
INSERT INTO tcs_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","‘Wen dem wokman blo da pama i luk dem putigras i gro de midel lo da gadan tu, ol bin kam ane spik po bos blo dempla diskain, “Bos, yu bin plante ol gudsid de lo gadan blo yu, bat aukam i gad ol putigras de gro midel tu?” ");
INSERT INTO tcs_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","‘Da pama i ansa dempla diskain, “Enami blo mi i bin plante dem putigras de.” ‘Den dempla i bin spik baik po bos, “Yu wande mipla po go ane pulemaut dem putigras a?” ");
INSERT INTO tcs_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","‘Bat da bos i bin spik po dempla, “No, mata libem. Ip yupla i go pulemaut dem putigras, yupla mait go pulemaut dem gudsid kaikai tu. ");
INSERT INTO tcs_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","So lete demtu gro tugeda. Wen da taim i go kam bambai po pike dem sidkaikai, ai go spik po dem wokman po sotemaut dem sidkaikai prom dem putigras ane store dem sidkaikai insaid lo storum, ane bane dem putigras.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Den Zizas i bin yan po dempla nada stori. Em spik, ‘Da ples wea God i ruloba ebribodi, i seimkain wase mastadsid wea yupla i plantem lo gadan. ");
INSERT INTO tcs_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Nomata da sid i prapa nadakain smol, mo smol den dem nada sid, bat wen em gro, em gro kam nadakain bigtri, wea ol pizin i kam ane meke nest blo dempla lo dem tam blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Den Zizas i bin yan po dempla nada stori. Em spik, ‘Da ples wea God i ruloba ebribodi, i seimkain wase yis wea oman i yuzem po meke dampa. Em mata go sake lelbet yis miksem lo plenti plaua ane wata po meke dampa. Dat lelbet yis nau i go meke da dampa swelap.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ane Zizas em bin ebritaim yuze stori wen em tise ol pipol. ");
INSERT INTO tcs_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Diswan i po pole da mesiz blo wan spesilmesizman blo God wea em i bin spik: ‘Ai go yan stori wea i gad mining po ol pipol. Ai go tise ol pipol demting wea dempla no bin sabe bipo, prom dat taim wen ai bin meke da wold.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Den apta, Zizas i bin libe dem bigmob pipol de ausaid ane em bin go insaid po dat aus. Dem klostuman blo em i bin de tu lo em. Dempla i bin askem, ‘Plizgar eksplein po mipla wanem yu bin min wen yu bin tokbaut dem putigras.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","So Zizas i bin eksplein po dempla diskain, ‘Ai da Truwan blo Man ane ai seimkain wase da pama uda i bin plante gudsid. ");
INSERT INTO tcs_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Dis wold i seimkain wase da gadan, ane dem pipol uda meke wok blo God, i seimkain wase dem gudsid. Dem pipol uda meke wok blo Satana, i seimkain wase dem putigras. ");
INSERT INTO tcs_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ane dis enami uda i bin plante sid blo putigras midel lo dem gudsid kaikai, i seimkain wase Satana. Wen da taim i go kam po dem gudsid kaikai i redi nau po brokem, i gobi seimkain po da taim wen God i go zaze ol pipol, ane dem wokman wea i bin sotemaut dem gudsid kaikai prom dem putigras, demwan i ol einzel. ");
INSERT INTO tcs_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","‘Dem wokman uda i bin teke dem putigras ane banem, i go apen seimkain tu po ol pipol wen da taim i go kam wen God i go zaze ol pipol. ");
INSERT INTO tcs_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ai da Truwan blo Man i go sane ol einzel blo mi godaun po ert. Dempla i go tekemaut prom da ples wea God i go ruloba ebribodi, ebridem pipol uda i bin meke nugudting ane uda bin meke ol nada pipol po meke nugudting. ");
INSERT INTO tcs_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ane dem einzel i go sake dempla insaid lo bigpaia ane bane dempla. Dempla go sake bigkrai ane graine tit blo dempla prom pein blo dat paia. ");
INSERT INTO tcs_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Den apta, dem rait ane stret pipol uda blo God, dempla go sain wase da san, ane dempla i gobi de midel lo dem pipol wea God i go rul. So nau, yupla lisen uda gad talinga, ane yupla prapa tingbaut nau!’ ");
INSERT INTO tcs_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Zizas i bin spik gen diskain, ‘Dat ples wea God i ruloba ebribodi, i wase prapa dia samting wea sambodi i bin berem insaid lo graun lo wan eria. Wen nada man i bin kam ane paine da dia samting de, em bin wantaim berem gen. Em bin prapa nadakain api. Ane wen em i bin pinis berem, em bin go ane sele ebrisamting blo em ane baie da eria so em ken gede dat dia samting.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Zizas i spik tu diskain, ‘Dat ples wea God i ruloba ebribodi, i wase man i lukraun po baie prapa nais perl. ");
INSERT INTO tcs_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Den wandei em i bin luk prapa nais perl, so em i bin go ane sele ebriting blo em so em ken baie dat nais perl.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ane em spik gen diskain, ‘Dat ples wea God i ruloba ebribodi, i wase pising net, wea ol pisaman i sakem ane kese olkain pis. ");
INSERT INTO tcs_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wen ol kese bigmob, ol draige da net go antap po sanbis. Den ol pute dem pis wea dempla i wandem insaid lo basket, ane sakwei demwan wea dempla no laik. ");
INSERT INTO tcs_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","I gobi demkain wen da taim i go kam po God i go zaze ol pipol. Dem einzel i go kam ane separeit dem rait ane stret pipol prant lo God prom dem nugudpipol, ");
INSERT INTO tcs_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ane ol i go sake dem nugudpipol insaid lo paia blo el. Dem pipol i go mata krai ane graine tit prom pein blo da paia.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Den Zizas i bin spik po ol klostuman blo em diskain, ‘Yupla sabe wanem ai bin tokbaut a?’ Dempla bin ansarem, ‘Wa, mipla sabe.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Den Zizas i bin spik diskain baik po dempla, ‘Ebri tisa blo dem lo blo God, uda i sabebaut da ples wea God i ruloba ebribodi, i wase bos blo aus. Em gad ol oul samting ane ol niu samting de insaid lo dat aus. Ane em i yuze dem oul samting ane dem niu samting tu.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wen Zizas i bin pinis prom yan dem stori, em ane ol klostuman blo em i bin tekop go prom dat eria. ");
INSERT INTO tcs_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Dempla i bin go po Nazaret, taun blo Zizas. Ane em i bin tise ol pipol insaid lo da zuwispreaus de. Wen dem pipol i bin lisen wanem em bin pris de ol bin atzamp, ane dempla i bin spik po wananada diskain, ‘Ei, wea dis man i bin gede dat bigsens prom po tise yumpla ol dem pipol ya, ane wea em i gede paua blo em prom po meke ol mirikal ya? ");
INSERT INTO tcs_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Yumpla sabe em mata boi blo kapenta, ane yumpla sabe Meri, mama blo em, ane ol bala blo em i Zemes, Zosep, Saiman ane Zudas. ");
INSERT INTO tcs_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ane ol sisi blo em i stap ya tu lo Nazaret. So yumpla sabe em, em no bigman.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ane dem pipol no bin wande lisen ane bilib lo em. Den Zizas i bin spik po dempla diskain, ‘Ol pipol blo ol nada kantri i lisen ane bilib lo spesilmesizman blo God, bat no wea taun blo em ane no wea pipol blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","So em bin meke mata lelbet mirikal de, bikoz dempla no bin bilib lo em. ");
INSERT INTO tcs_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nau King Erod Antipas, uda i king blo Galali, i bin lisen niuz baut wanem Zizas i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","So em i bin spik po dem lida blo em diskain, ‘Diswan mas bi Zon Baptaizman, em bin kambaik laipgen. Daswai em i ken meke demkain mirikal.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","De pas, Erod i bin spik dem amiman blo em po go ane kese Zon, ane sakem insaid zeilaus. Erod i bin mekem diskain bikoz em bin maret rongwei po Erodias. Wea Erodias i bin oman blo Pilip de pas ane Pilip i bin bala blo Erod. ");
INSERT INTO tcs_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Erod i bin mekem diskain po Zon bikoz Zon i bin spik diskain, ‘Ei Erod, yu sabe yu no lau po maret oman blo bala blo yu?’ ");
INSERT INTO tcs_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erod i bin wande kile Zon, bat em bin prait prom dem pipol bikoz dem pipol i bin bilib diskain, Zon i bin spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Bat wen i bin gad batdei pati blo Erod, gel blo Erodias i bin dans po dem gest blo Erod ane wen Erod i bin luk em dans, Erod i bin prapa api. ");
INSERT INTO tcs_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Erod i bin spik po da gel diskain, ‘Ai promis yu eniting yu wandem, ai go gibem po yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Dat gel i bin go ane tok po mama blo em pinis, den em bin kambaik ane spik po Erod, ‘Ai wande yu po teke ed blo Zon Baptaizman kam po mi antap lo trei.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Wen King Erod i bin lisen wanem da gel i bin spik em bin pil nadakain sore, bat em sabe em bin meke promis ane dem pipol uda i bin kaikai de lo em tu, ol i bin lisen. So em bin sane ol amiman blo em go ane mekem wanem da gel i bin wandem. ");
INSERT INTO tcs_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Dempla i bin go de po da zeilaus ane kate ed blo Zon ausaid. ");
INSERT INTO tcs_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Den dempla i bin teke ed blo Zon kam antap lo trei ane gibem po da gel, den da gel i bin gibem po mama blo em. ");
INSERT INTO tcs_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Apta wen dem klostuman blo Zon i bin lisenbaut wanem i bin apen po em dempla i bin go de po da zeilaus ane teke bodi blo Zon go ane berem. Apta dempla i bin berem, dempla i bin tekop go po Zizas ane spik po em wanem i bin apen. ");
INSERT INTO tcs_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wen Zizas i bin lisen dat badniuz blo Zon Baptaizman, em i bin zamp insaid lo bot ane go po wan kuaiatples bikoz Zizas i bin nadakain sore po Zon. Bat dem bigmob pipol prom olkain biliz i bin luk wea Zizas i go, so dempla i bin wagbaut pole em go biain. ");
INSERT INTO tcs_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wen Zizas i bin zamp ausaid prom da bot, em bin luk bigmob pipol i bin pole em, so em i bin pil sore po dempla ane em bin meke dem sikpipol midel lo dempla kamgudgen. ");
INSERT INTO tcs_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wen i bin kam klostu po dak, dem klostuman i bin kam po Zizas ane spik po em diskain, ‘Tisa, i nogad no ples ya wea i ken paine kaikai po pide dem bigmob pipol ya, ane ples po dempla po stap. Sane dempla go po dem biliz so dempla i ken baie kaikai po demplaselp.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bat Zizas i bin ansa dempla, ‘Dempla mas nogo po dem biliz po baie kaikai. Yupla gibe dempla kaikai ya.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ol i kuikwan ansa, ‘Wiskain? Mipla mata gad paib loupbred ane tu pis.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Zizas i bin spik, ‘Wel, teke demtu pis ane bred kam ya po mi.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Den em bin spik po dem bigmob pipol po sidaun lo dem gras. Ane em bin teke da tu pis ane dem paib loupbred, luk go antap po eben, ane aske God po blese dem kaikai. Den em i bin broke dem bred ane pis po smolpis ane bin gibem po dem klostuman blo em, den dem klostuman blo em i bin gibem po dem bigmob pipol. ");
INSERT INTO tcs_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dem bigmob pipol i bin kaikai po prapa belipul ane wen dempla i bin prapa belipul dem klostuman blo Zizas i bin pikemap dem nada kaikai wea nobodi i bin kaikai ane meke tuelb basket. ");
INSERT INTO tcs_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Baut 5,000 man i bin kaikai prom dem kaikai de. I bin gad ol oman ane pikinini de tu, bat ol i no bin kaunte dempla. ");
INSERT INTO tcs_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Stretwei apta wen dem bigmob pipol i bin pinis kaikai, Zizas i bin spik po dem klostuman blo em po krosem go pas lo bot go po da nadasaid blo Leik Galali. Seimtaim em bin de sane ol pipol gobaik aus blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Apta wen em bin pinis sane ol dem bigmob pipol go, em bin de emselp nau. Em bin go antap po wan il po prea. Em bin stap de antap antil naittaim. ");
INSERT INTO tcs_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Dem klostuman blo Zizas i bin de longwei ausaid lo dat bot wen prapa strong edwin i bin kamap ane ol bigsi i bin smas gense da bot. ");
INSERT INTO tcs_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Prapa elimoning bipo san i kamap, Zizas i bin wagbaut antap lo wata kam po dempla. ");
INSERT INTO tcs_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wen dempla bin luk em ol bin nadakain prait. Dempla bin ala diskain, ‘Ei, debol ya kam!’ ");
INSERT INTO tcs_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bat Zizas i bin spik po dempla, ‘No prait! Diswan mi Zizas.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Den Pita i bin spik po em, ‘BosLod, ip diswan i prapa yu, wel spik mi po wagbaut go de po yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","So Zizas i bin spik po em, ‘Kam.’ Den Pita bin zamp ausaid prom da bot ane wagbaut antap wata go po Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bat wen em bin luk dem bigsi em bin prait ane stat po singk, ane em bin ala po Zizas diskain, ‘BosLod, elpe mi!’ ");
INSERT INTO tcs_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Stretwei Zizas i bin pute an blo em go ane kese Pita. Den Zizas i bin spik po em, ‘Bilib blo yu i tu smol. Aukam yu no bilib mi prapa?’ ");
INSERT INTO tcs_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Den wen demtu i bin klaimap gobaik insaid da bot, da win i bin stap. ");
INSERT INTO tcs_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ane dem klostuman i bin wosip em ane dempla bin spik, ‘Yu prapa tru Boi blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Apta wen dempla i bin kesem de nadasaid blo da leik, ol bin go po da eria blo Genesaret. ");
INSERT INTO tcs_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Wen ol pipol i bin luk Zizas, dempla i bin sane mesiz ebriwea lo dat eria ane ol pipol i bin teke demwan uda i sik kam po em. ");
INSERT INTO tcs_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ane dem pipol i bin aske Zizas po lete dem sikpipol po tase end blo klos blo em solong dempla go kamgud. So Zizas i bin lete dempla ane dem sikpipol uda i bin tasem i bin stretwei kamgud. ");
INSERT INTO tcs_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sam Zuwislotisa ane Parasi i bin kam de prom Zarusalem po tok po Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Dempla i bin spik po em diskain, ‘Aukam ol klostuman blo yu i no pole dem kastamlo blo dem prapa longtaim ate blo yumpla, wea ol bin spik, ol mas wase an pas bipo kaikai?’ ");
INSERT INTO tcs_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Zizas i bin spik po dempla baigen, ‘Aukam yupla no pole lo blo God, bat pole kastamlo blo yupla? ");
INSERT INTO tcs_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Da lo blo God i bin spik diskain ya, “Yupla mas rispekt mama ane papa blo yupla. Ane ip enibodi i tok ol nugudtok gense mama ane papa blo dempla, dempla mas kile em.” ");
INSERT INTO tcs_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bat yupla spik diskain po ol pipol, ip mama o papa blo yupla i aske yupla po mani, yupla spik po dempla diskain, “Wa, ai gad mani ya, bat sore, ai kan gibe yupla bikoz dis mani ya i blo God.” ");
INSERT INTO tcs_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wen yupla spik demkain, yupla tise dempla dem kastamlo blo yupla, bat yupla no tise dempla baut dem lo blo God. ");
INSERT INTO tcs_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yupla ol tupes pipol! Aizaia da spesilmesizman blo God i bin rait wen em i bin spikbaut yupla diskain: ");
INSERT INTO tcs_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Dem pipol tok gudwei baut God mata lo maut blo dempla, bat at blo dempla i prapa longwei prom em. ");
INSERT INTO tcs_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nomata dempla spik dat dempla bilib lo dem lo blo God, bat prapa, dempla no mekem wanem dem lo blo God i spik. Ol mekem wanem dem kastamlo blo dempla i spik.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Den Zizas i bin spik po dem bigmob pipol diskain, ‘Lisen prapa gud po wanem ai go spik ane prapa tingbaut dem wod ya ai go spik. ");
INSERT INTO tcs_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Demting wea yupla kaikai, i no meke yupla nugud, bat dem nugudting wea yupla i spik ane mekem, demwan i meke yupla nugud.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Apta wen Zizas i bin pinis tok, dem klostuman blo em i bin kam de po em ane spik po em diskain, ‘Wen yu bin tok diskain po dem Parasi, yu bin meke dempla wail.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Zizas i bin spik baigen po dempla diskain, ‘Ebri tri wea mai PapaGod de antap lo eben no bin plantem, em i nugud ane dempla mas pulemautem olgeda, ");
INSERT INTO tcs_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","so no lisen po dempla. Dempla blain ane uda dem pipol i go pole dempla i blain tu. Yupla sabe ip wan blainman i go lide nada blainman, demtu tu i go poldaun insaid lo oll.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Den Pita i bin spik po Zizas diskain, ‘Mipla no sabe wanem yu bin min wen yu bin spik diskain, demting wea pipol i kaikai i no meke dempla nugud.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Zizas i bin spik, ‘Aukam yupla kan kese dem mining blo dem tok wea ai spik? ");
INSERT INTO tcs_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Eniting wea pipol i kaikai, i go insaid lo beli blo dempla, den em kamaut gen prom bodi blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bat dem nugudtok wea pipol i spik, i kam prom insaid lo nugud at blo dempla ane meke dempla nugud. ");
INSERT INTO tcs_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ane i meke main blo dempla po tingbaut olkain nugudting wase kile man, maretman no kiptru po oman blo em, o maret oman no kiptru po man blo em, meke olkain sekssin, stil, lai ane tok olkain nugudtok gense ol nada pipol. ");
INSERT INTO tcs_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dem Zuwislotisa i spik, bipo yupla kaikai yupla mas wase an blo yupla pas. Bat i no go meke yupla nugud ip yu no wasem. Bat ai spik yupla, dem nugudting wea i bin kamaut prom at blo yupla i meke yupla nugud.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Apta prom de, Zizas i bin tekop go po nowessaid go po da eria blo demtu taun Taira ane Sidon. ");
INSERT INTO tcs_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Wen em i bin mangi de, wan oman prom dat eria prom da pamlelain blo Kanan i bin kam de ane singaut po em diskain, ‘BosLod! Yu Promiswan wase King Deibid. Plizgar soe sorewei po mi ane elpe mi! Mai gel i gad nugudspirit insaid lo em, ane da nugudspirit i prapa meke nugudting po em gar.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bat Zizas i bin stap kuaiat, em no bin spik nating po em. Den dem klostuman blo em i bin spik po em diskain, ‘Yu sese da oman prom ya, bikoz em tumas meke niusens ya.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Den Zizas i bin spik po da oman diskain, ‘PapaGod blo mi i no bin sane mi kam po elpe ol nada pipol, bat mata po elpe dem pipol blo Izrael, bikoz dempla wase sip i wagbaut ebriwea nogad no bos po lugaut dempla.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ane dat oman em bin kam ane nildaun prant lo Zizas ane spik po em gen diskain, ‘BosLod, plizgar elpe mi!’ ");
INSERT INTO tcs_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Den Zizas i bin spik, ‘I no rait po teke kaikai prom ol smolpikinini ane sakem po ol dog.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Dat oman i bin ansarem, ‘Prapa tru wanem yu spik BosLod, bat nomata, dog i stil sabe kaikai dem smolpis kaikai wea i poldaun andanit lo teibol blo bos blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Zizas i bin spik, ‘Oman, yu gad prapa strong bilib lo mi! Ai go mekem wanem yu bin wandem.’ Stretwei wen Zizas i bin spik diskain, da smolgel blo da oman i bin kam orait. ");
INSERT INTO tcs_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Apta prom de, Zizas ane ol klostuman blo em i bin tekop gobaik po da said blo Leik Galali. Wen ol bin kesem de, Zizas i bin klaimap wan il ane sidaun. ");
INSERT INTO tcs_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bigmob pipol i bin teke ol dem pipol kam uda i bin leim, blain, kripol, kan tok. Ane olkain dipren dipren sikpipol bin kam de po em, ane ol dempla bin leidaun de prant lo em. Em i bin meke ebridem pipol kamgudgen. ");
INSERT INTO tcs_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Dem bigmob pipol i bin atzamp. Ol luk demwan uda i kan tok ol i bin tok nau, demwan uda i bin kripol i bin wagbaut stret, demwan uda i bin leim i bin wagbaut, demwan uda i bin blain i ken luk nau. Dempla i bin mata preize da God blo Izrael. ");
INSERT INTO tcs_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Den Zizas i bin singaut dem klostuman blo em ane spik diskain, ‘Dempla i bin ya lo yumpla po tri dei nau, ane dempla i no bin kaikai nating. Ip ai go sane dempla gobaik po ples blo dempla, dempla mait go blaikaut de midel lo rod prom anggre.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Dem klostuman bin ansa, ‘Wiskain mipla go pide dempla? I nogad no kaikai po pide ebri dempla ya lo dis ples wea i nogad man.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Den Zizas i bin spik, ‘Aumas loupbred yupla gad?’ Dempla i bin ansa, ‘Seben loupbred ane lelbet smol pis.’ ");
INSERT INTO tcs_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","So Zizas i bin spik dem pipol po sidaun daun lo da graun. ");
INSERT INTO tcs_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ane em i bin teke dem seben loupbred ane dem pis, luk go antap po eben ane aske God po blese dem kaikai. Den em i bin broke dem kaikai po smolpis ane gibem po dem klostuman blo em, den dem klostuman blo em i bin gibem po dem pipol. ");
INSERT INTO tcs_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dempla ebriwan i bin kaikai po prapa belipul. Wen dempla i bin prapa belipul nau, dem klostuman i bin pikemap dem leptoba kaikai ane meke seben big basket. ");
INSERT INTO tcs_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Baut 4,000 man i bin kaikai prom dem kaikai de. I bin gad ol oman ane pikinini de tu, bat ol i no bin kaunte dempla. ");
INSERT INTO tcs_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Den Zizas i bin sane dem pipol gobaik po aus blo dempla. Apta wen em bin sane ebriwan go, em bin zamp insaid lo bot ane krosem go po da eria blo Magadan. ");
INSERT INTO tcs_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Wen Zizas i bin kesem de, sam Parasi ane Sadusi i bin kam de ane trai po trikem. Ol i bin spik po em diskain, ‘Ip yu prapa prom God wel soe mipla mirikalsain prom God dat yu kare lo.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Zizas i bin spik baigen po dempla, ‘Wen yupla luk da kala blo da skai wen da san godaun i red, yupla sabe i gobi gud weda da neksdei. ");
INSERT INTO tcs_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ane wen yupla luk da skai i dak ane red lo moningtaim, yupla sabe i go gad rein. Yupla luk dem sain lo da skai ane yupla sabe wanem i min. Wiswei? Yupla luk dem sain i apen ya nau, bat yupla stil no tekenotis wanem ol i min. ");
INSERT INTO tcs_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yupla dem pipol blo tidei i prapa nugud bikoz yupla tumas wande luk mirikalsain prom God. Ai nogo soe yupla mirikalsain bat yupla tingbaut po da spesilmesizman blo God neim Zona, wanem God i bin mekem po em.’ Den Zizas i bin libe dempla ane tekop go. ");
INSERT INTO tcs_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Den apta, Zizas ane dem klostuman bin zamp insaid lo bot ane krosem go po da nadasaid blo Leik Galali. Wen ol i bin kesem de, dem klostuman blo em i bin piged po kare kaikai kam. ");
INSERT INTO tcs_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Zizas i bin tokstrong po dempla diskain, ‘Lugaut prom da yis blo dem Parasi ane dem Sadusi.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wen Zizas i bin tokbaut yis, dempla i bin tok po wananada, ‘Ei, em tokbaut yis bikoz yupla no bin kare bred kam lo yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Zizas i bin sabe wanem dempla i bin tingbaut, so em bin spik po dempla, ‘Bilib blo yupla i prapa smol! Yupla tumas woribaut nogad no kaikai! ");
INSERT INTO tcs_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Aukam yupla stil no tekenotis wanem ai tokbaut? Wasmara? Yupla no rimemba dem 5,000 pipol wea ai bin pidem lo dem paib loupbred ane aumas basket kaikai i bin leptoba. ");
INSERT INTO tcs_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ane dem 4,000 pipol tu, wea ai bin pidem lo dem seben loupbred, ane aumas basket i bin leptoba. ");
INSERT INTO tcs_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Yupla tingk ai bin tokbaut yis o bred a? No! Ai spik yupla gen, lugaut prom ol rong tising blo dem Parasi ane Sadusi.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Den dem klostuman blo em i bin kesem wanem em bin min wen em bin tokbaut yis ane bred. Dempla bin sabe nau em i bin tokbaut dem rong tising blo dem Parasi ane Sadusi. ");
INSERT INTO tcs_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Zizas ane ol klostuman blo em i bin tekop go po da eria blo taun blo Sizaria Pilipi. Wen ol bin kesem de klostu nau, Zizas i bin aske dem klostuman diskain, ‘Uda dem pipol i spik da Truwan blo Man?’ ");
INSERT INTO tcs_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Dempla i bin ansa, ‘Sam pipol spik em i Zon Baptaizman, nadalot i spik dat em i Ilaiza, nadawan i spik em i Zeramaia, o wan prom dem nada spesilmesizman blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Den Zizas i bin aske dempla, ‘Orait. Ane yupla tingk uda mi?’ ");
INSERT INTO tcs_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saiman Pita i bin ansa, ‘Yu da Promiswan uda God i bin sanem, Boi blo da God uda i laip.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Zizas bin spik gen, ‘Saiman, boi blo Zon, God i bin blese yu, bikoz no pipol i bin spik yu uda mi, bat PapaGod blo mi de antap lo eben i bin spik yu uda mi. ");
INSERT INTO tcs_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nau ai kole yu Pita, bikoz yu wase big ston. Ane antap lo dis ston ai go bilde sos blo mi ane Satana ane paua blo em i go kan brokem. ");
INSERT INTO tcs_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ai go gibe yu ki blo da ples wea God i ruloba ebribodi. So wanem yu go stapem ya lo ert, God i go stapem de lo eben. Ane wanem yu letem go ya lo ert, God i go letem go de lo eben.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Den em bin tok strong po dempla no po spik nobodi dat em da Promiswan uda God i bin sanem kam. ");
INSERT INTO tcs_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Prom dat taim nau Zizas i bin spik po dem klostuman blo em wea em go ded. Em spik, ‘Ai mas go po Zarusalem ane ai go go tru olkain trabol prom dem edprist, dem Zuwiselda ane dem Zuwislotisa. Ol i go kile mi bat lo namba tri dei ai go kamlaipgen.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wen Zizas i bin pinis tok, Pita i bin teke em go wansaid ane spik po em, ‘Nono BosLod! Dempla kan kile yu!’ ");
INSERT INTO tcs_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Zizas i bin tan po Pita ane spik, ‘Gowei prom mi Satana. No trai po stape mi. Yu mata tingbaut wiskain pipol i tingbaut. Yu no tingbaut wiskain God i tingbaut.’ ");
INSERT INTO tcs_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Den Zizas i bin spik po dem klostuman, ‘Ip eniwan i wande pole mi, em i mas libe ebridem samting wea em i prapa laik, ane mas gri po kare kros blo em ane pole mi. ");
INSERT INTO tcs_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ip enibodi i mata tingbaut emselp, wel wen em go ded, em go ded po gud, nogad laipgen. Bat ip enibodi i mata lisen ane pole mi, wen em go ded, God i go gibem niulaip. ");
INSERT INTO tcs_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ip sambodi i gad ebrisamting ya lo dis laip ya blo dis wold ane em i ded, wel ebridem samting wea em i gad, i kan teke laip blo em kambaigen. ");
INSERT INTO tcs_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ai da Truwan blo Man i go kambaik lo nadakain brait sainilait, da paua blo PapaGod blo mi ane ol einzel blo em, ane em go zaze ebridem pipol po demting wea dempla i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ai spik trutok ya po yupla. Sam prom yupla ya stanap, bipo yupla go ded, yupla go luk mi, da Truwan blo Man kamdaun po ruloba ebribodi ane ebriting.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Siks dei apta, Zizas bin tokbaut ded blo em, em i bin teke Pita ane demtu bala Zemes ane Zon go antap lo wan ai maunten. ");
INSERT INTO tcs_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wen demtri man i bin luk Zizas nau, ngad blo em i bin seinz. Pes blo em i bin sain nadakain brait wase da san, ane klos blo em i bin kam nadakain braitwait. ");
INSERT INTO tcs_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Seimtaim nau demtri man i bin luk Mozes ane Ilaiza i bin stanap de ane tok lo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Wail dempla bin tok, Pita i bin spik go po Zizas diskain, ‘BosLod, ai gad gudsens ya. Ip yu wandem ai ken meke tri smolseid, wan po yu, wan po Mozes, ane wan po Ilaiza.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Midel lo da tok blo Pita wan nadakain sainibrait klaud i bin kam antap lo dempla ane bois prom da klaud i bin spik diskain, ‘Diswan mai Boi ane ai prapa labe em. Ai prapa api wea laip blo em. Yupla mas lisen po em.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wen dem klostuman blo Zizas i bin lisen dat bois, dempla i bin nadakain prait ane poldaun pesdaun lo da graun. ");
INSERT INTO tcs_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Den Zizas i bin kam ane tase dempla ane spik, ‘Gedap. Yupla no prait.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ane wen dempla i bin gedap ane lukraun, dempla mata bin luk Zizas i bin de nau lo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wen dempla i bin kamdaun prom dat maunten Zizas i bin tok strong po dempla diskain, ‘Yupla mas no spik po nobodi wanem yupla i bin luk de antap lo dat maunten, antil dat taim wen mi da Truwan blo Man i go kamlaipgen prom ded.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Apta wen Zizas i bin pinis prom tok, demtri klostuman i bin askem, ‘BosLod, aukam dem Zuwislotisa i spik Ilaiza mas kam pas bipo da Promiswan uda God i go sanem?’ ");
INSERT INTO tcs_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Zizas i bin ansa, ‘Wa i tru, Ilaiza mas kam pas po meke ebriting redi. ");
INSERT INTO tcs_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bat ai spik po yupla, em i bin pinis kam, ane ol pipol i no bin sabe uda em. Dempla i bin tritem prapa nugudwei. Ane i klostu nau po mi, da Truwan blo Man i go gede da seim trabol wase Ilaiza i bin gedem prom dem pipol.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wen demtri klostuman i bin lisen wanem Zizas i bin spik, dempla i bin stretwei sabe em i bin tokbaut Zon Baptaizman. ");
INSERT INTO tcs_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wen dempla i bin kesem de andanit lo da maunten, bigmob pipol i bin weit de po dempla. Wan man i bin kam po Zizas, nildaun prant lo em ane spik, ");
INSERT INTO tcs_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","‘BosLod, plizgar soe sorewei po boi blo mi ane elpe em! Em ebritaim gad pit, ane dat pit i prapa spoilem. Wen dat pit i kesem, em poldaun antap lo paia o insaid lo wata. ");
INSERT INTO tcs_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","So ai bin tekem po dem klostuman blo yu bat dempla kan meke em gud.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Zizas i bin ansa, ‘Yupla dem pipol blo tidei i prapa aded pipol! Aukam yupla no bilib? Ane aulong ai mas kip soe yupla? Teke da boi kam ya po mi.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Den Zizas i bin oda da nugudspirit po kamaut prom da boi. Stretwei da nugudspirit i bin kamaut, ane da boi i bin orait nau. ");
INSERT INTO tcs_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Apta nau, dem klostuman i bin kam de po Zizas wen em bin de emselp ane askem, ‘Aukam mipla kan tekemaut da nugudspirit prom da boi?’ ");
INSERT INTO tcs_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Zizas i bin spik baik, ‘Yupla nogad strong bilib. Ai spik trutok po yupla. Ip bilib blo yupla i demkain smol wase sid blo mastadtri, yupla ken spik po dis maunten ya, “Mub prom ya go de”, ane da maunten i go lisen ane mub. So, ip yupla i gad bilib, den yupla i ken meke eniting.’ ");
INSERT INTO tcs_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dempla i bin mit wan ples de lo Galali, ane Zizas i bin spik po dempla, ‘Ai da Truwan blo Man i go ded. ");
INSERT INTO tcs_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Dempla i go sele mi po ol dem man uda i go kile mi. Bat lo namba tri dei, ai go gedap laipgen prom ded.’ Wen dem klostuman i bin lisen wanem em i bin tok, dempla i bin pil nadakain sore. ");
INSERT INTO tcs_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Prom de dempla i bin tekop go po taun blo Kapaniam. Wen dempla i bin mangi de, sam dem man uda i bin kolekt taksmani po da Tempol i bin kam de po Pita ane askem, ‘Tisa blo yupla i pei taksmani po da Tempol tu a?’ ");
INSERT INTO tcs_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita i bin spik baigen, ‘Wa, i mas.’ Den em bin go po Zizas, go insaid lo dat aus po tok po Zizas baut kolekte taksmani. Bipo Pita i bin tok, Zizas i bin askem, ‘Wiswei yu tingk Pita? Dem king i meke ol oun pipol blo dempla po pei taksmani, o po dem pipol blo nada kantri?’ ");
INSERT INTO tcs_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita i bin spik, ‘Dem king i meke dem nada pipol po pei taksmani.’ Den Zizas i bin spik, ‘Wel, dem pipol blo dem king i pri, ol no nid po pei taksmani. ");
INSERT INTO tcs_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bat yumi no wande meke dempla wail. Yu godaun po da leik ane sake lain. Pas pis yu kesem, yu opene maut blo em ane yu go paine wan silba koin. Teke da koin go ane pei da taksmani po yumi.’ ");
INSERT INTO tcs_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Apta nau, dem klostuman blo Zizas i bin aske em diskain, ‘BosLod, uda prom mipla i gobi da nambawan man lo da ples wea God i ruloba ebribodi?’ ");
INSERT INTO tcs_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Zizas i bin singaut wan smolpikinini kam ane mekem stanap de midel lo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Den em bin spik, ‘Ai spik trutok po yupla, ip yupla wande go insaid po da ples wea God i ruloba ebribodi, yupla mas libe dem nugudwei blo yupla ane kam demkain wase smolpikinini. ");
INSERT INTO tcs_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ane enibodi uda i meke emselp ambol wase dis smolpikinini ya, em gobi da nambawan man de lo da ples wea God i ruloba ebribodi. ");
INSERT INTO tcs_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","‘Enibodi uda i welkam smolpikinini, wase diswan ya, em i labe mi tu. ");
INSERT INTO tcs_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Bat ip sambodi i meke wan prom dem smolpikinini uda gad bilib lo mi po meke nugudting, i mobeta po kese dat sambodi, taite sein raun nek blo em ane pute big angka lo sein ane sakem insaid lo solwata. ");
INSERT INTO tcs_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","‘Ebri pipol blo dis wold mas lugaut prom meke enibodi po meke nugudting. Pipol i go meke dem nugudting, bat dem pipol uda i meke ol nada pipol po mekem, prapa nugud samting i go apen po dempla. ");
INSERT INTO tcs_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","So ip an o leg blo yupla i meke yupla po meke nugudting, katem ausaid ane sakwei em. I mobeta po go eben lo wan an o wan leg, den po ban insaid lo dat nadakain paia lo tu an o tu leg. ");
INSERT INTO tcs_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ane ip ai blo yupla i meke yupla po meke nugudting, pulemautem ane sakwei. I mobeta po go eben lo wan ai, den po ban insaid lo el lo tu ai. ");
INSERT INTO tcs_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Lugaut, yupla. No tingk dem smolpikinini i nobodi. Ai spik yupla, dempla i gad ol einzel de antap lo eben, ane dem einzel i ebritaim de lo PapaGod blo mi. ");
INSERT INTO tcs_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ai da Truwan blo Man i bin kam po paine ane seibe dem pipol uda i lus.’ ");
INSERT INTO tcs_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Zizas i bin kip spik, ‘Nau yupla tingbaut. Ip wan bos i gad andred sip ane wan i bin lus, wanem yupla tingk em i go mekem? Em mas libe dem nainti nain sip biain ane tekop go po lukraun da wan i bin lus antil em painem. ");
INSERT INTO tcs_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ai spik trutok po yupla, wen em bin painem, em gobi prapa nadakain api, moapi den po dem nainti nain sip wea i no bin lus. ");
INSERT INTO tcs_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ane i seimkain tu, PapaGod blo yupla de antap lo eben no wande nobodi po gowei prom em.’ ");
INSERT INTO tcs_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Zizas i kip spik, ‘Ip amenbala blo yu i meke nugudting gense yu, go yuselp ane sotemaut datting lo em. Ane wen em i lisen po yu ane spik sore po dat nugudting wea em i bin mekem po yu, yu bin mekem kambaik po bala blo yu gen. ");
INSERT INTO tcs_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bat ip em no wande lisen po yu, teke wan o tu man lo yu gobaik po em, solong demtu i go lisen po dem tok wea yu go spik po em. ");
INSERT INTO tcs_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Bat ip em stil no wande lisen po yu, den teke em go po sos, ane lete ebribodi de insaid lisen wanem yu spik po em de. Bat ip em stil no wande lisen, den meke em nobodi, mekem nomo amenbala blo yu. ");
INSERT INTO tcs_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Ai spik trutok po yupla, wanem yupla stapem ya lo ert, God i go stapem de antap eben, ane wanem yupla i go letem go ya lo ert, God i go letem go de antap eben. ");
INSERT INTO tcs_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Nadating ai spik. Ip tu man prom yupla i gri ane aske PapaGod blo mi de antap eben po enisamting, em go mekem po demtu. ");
INSERT INTO tcs_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ane ip tu o tri pipol i kam tugeda po wosip mi, ai gobi de midel lo dempla tu.’ ");
INSERT INTO tcs_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Den Pita i bin kam po Zizas ane askem diskain, ‘BosLod, ip sambodi i kip meke nugudting po mi, aumas taim ai mas pogibe em? Yu tingk seben taim a?’ ");
INSERT INTO tcs_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Zizas i bin spik baigen po Pita, ‘No! Ai spik yu, ip em bin meke nugudting po yu sebenti seben taim, yu mas pogibe em sebenti seben taim!’ ");
INSERT INTO tcs_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ane Zizas i kip spik, ‘Ane da ples wea God i ruloba ebribodi i wase king uda i go ane kolekte dem mani baik prom dem wokman uda i bin boro mani prom em. ");
INSERT INTO tcs_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ane wan dem wokman uda i mas pei da king prapa nadakain tumas mani, ol bin teke em kam po da king. ");
INSERT INTO tcs_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Dat king i bin spik po em po pei em dem mani baik. Bat em no bin gad nap mani po peibaik dat det. So da king i bin gibe oda po sele em, ane oman blo em, ane pikinini blo demtu, ane ebrisamting wea em bin gad, po pei da det blo em. ");
INSERT INTO tcs_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","‘Bat wen da wokman i bin lisen wanem da king i bin spik, em bin poldaun prant lo da king ane spik, “Pliz gar, yu gibe mi lelbet mo taim ane ai go pei yu ebridem mani.” ");
INSERT INTO tcs_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wen da king i bin lisen wanem da wokman blo em bin spik, em bin pil nadakain sore po em ane spik po em, “I orait! Yu ken go. No wori po peibaik da mani.” ");
INSERT INTO tcs_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","‘Bat wen da man i bin go prom da king, em bin go po wan nada wokman uda i mas pei em mani. Em bin kesem lo trot ane spik diskain po em, “Yu gibe mi da mani nau wea yu oue mi!” ");
INSERT INTO tcs_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","‘Dat nada wokman i bin poldaun prant lo em ane spik, “Plizgar, yu gibe mi lelbet mo taim ane ai go pei yu da mani baik.” ");
INSERT INTO tcs_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bat da pas wokman i no bin gibe da nada wokman lelbet mo taim. Em bin teke da man go po kot, ane ol i bin putem insaid zeilaus antil em pinis peibaik da mani. ");
INSERT INTO tcs_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","‘Wen dem nada wokman i bin luk wanem da pas wokman i bin mekem, dempla i bin go ane spik po da king. ");
INSERT INTO tcs_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Den da king i bin singaut da pas wokman kam wea em bin pogibe em bipo, ane spik po em diskain, “Yu gad prapa nadakain nugudwei. Wen ai bin luk da sorewei yu bin mekem ya prant lo mi, ai bin pil nadakain sore po yu ane spik po yu no wori po peibaik da bigmani wea yu bin spostu pei mi. ");
INSERT INTO tcs_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yu spostu gad sorewei po da nada wokman uda i bin oue yu mani.” ");
INSERT INTO tcs_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Den da king i bin wail nau ane sane dat wokman go zeilaus. Dem gad blo da zeilaus i bin trite em nadakain nugudwei, ariapem po peibaik ebri mani wea em mas pei da king. ");
INSERT INTO tcs_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Den Zizas i bin spik diskain, ‘PapaGod blo mi de antap lo eben i go meke diskain po eniwan ip dempla no pogibe dempla bala ane sisi prom dempla at.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Apta wen Zizas i bin pinis yan dem stori po dem klostuman, dempla i bin libe Galali ane tekop go po Zudia ane den dempla i bin krose Zodan Riba go po da nadasaid. ");
INSERT INTO tcs_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Wen dempla i bin kese da nadasaid, prapa bigmob pipol i bin pole dempla antap go de ane Zizas i bin meke ebridem pipol uda i bin sik kamgud. ");
INSERT INTO tcs_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Sam dem Parasi i bin de tu. Dempla i bin kam po Zizas ane bin trai po trike em wea wan kuestin. ‘Ip eni man i nomo wande oman blo em, ken em dibos oman blo em a?’ ");
INSERT INTO tcs_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Zizas i bin ansa, ‘Yupla bin rid wanem God i bin spik lo Baibol a? God bin spik diskain, “Ai bin meke man ane oman.” ");
INSERT INTO tcs_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ane God bin spik gen, “Daswai man i go libe mama ane papa blo em ane zoin lo oman blo em, ane demtu i go kamwan.” ");
INSERT INTO tcs_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","So lete nobodi i separeit demtu, bikoz God i bin zoine demtu tugeda. Demtu nomo tu nau, bat wan.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Den dempla i bin spik diskain po Zizas nada kuestin, ‘Orait. Aukam Mozes i bin spik, ip eni man i wande dibos oman blo em, em mas gibe oman blo em dibos peipa, den em ken dibos em?’ ");
INSERT INTO tcs_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Zizas i bin ansa, ‘Mozes i bin spik po mekem diskain bikoz at blo yupla i bin prapa kloz. Bat wen God i bin meke da wold, em no bin wandem demkain. ");
INSERT INTO tcs_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ai spik po yupla tru, ip eni man libe oman blo em ane maret nada oman, em broke maretlo blo God. Seimwei, wen eni oman libe man blo em ane maret nada man, em broke maretlo blo God tu.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Den dem klostuman blo Zizas i bin askem, ‘Den i gud po no maret?’ ");
INSERT INTO tcs_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Zizas i spik, ‘Sam man i nogo maret, mata demwan uda God i suzem. ");
INSERT INTO tcs_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sam man i bin bon diskain kan maret, sam pipol i bin stape man prom maret wen ol i kate bol blo dempla, ane sam dem nada man no wande maret bikoz dempla mata wande meke wok blo God. Ane ip diswan i ubi blo eniwan, mata polem.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Apta nau, sam pipol i bin teke ol pikinini kam de po Zizas po blese dempla. Bat dem klostuman blo Zizas i bin graule dempla no po teke dempla kam. ");
INSERT INTO tcs_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Bat Zizas i bin spik, ‘No stape dem pikinini prom kam ya po mi, bikoz demwan uda i go meke demplaselp smol wase dem smolpikinini ya, dempla i go stap de lo da ples wea God i ruloba ebribodi.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Den Zizas i bin pute an antap lo ed blo dempla ane blese dempla. Apta wen em bin pinis blese dempla de, em bin lego go. ");
INSERT INTO tcs_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wan man i bin kam po Zizas ane askem, ‘Tisa, wanem gudting ai mas mekem po gede longlaip poeba?’ ");
INSERT INTO tcs_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Zizas i bin ansarem, ‘Aukam yu aske mi baut wanem i gud? Mata God i gud. Bat ip yu wande gede longlaip poeba, yu mas pole ebridem lo blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Dat man i bin ask gen, ‘Wanem dem lo nau?’ Den Zizas i bin ansa, ‘No lau po kile man, yu mas kiptru po oman blo yu, no lau po stil, no lau po lai. ");
INSERT INTO tcs_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Yu mas mata lisen ane mekem wanem mama ane papa blo yu i spik yu po mekem. Yu mas trite ol nada pipol seimkain wiskain yu trite yuselp.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Em ansa Zizas, ‘Ai bin pole ebridem lo. Wanem nada lo ai mas polem?’ ");
INSERT INTO tcs_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Zizas i spik po em, ‘Ip yu wande kam rait prant wea God, yu mas go ane sele ebriting blo yu ane gibe ebridem mani po dem pipol uda poa. Wen yu go mekem diskain yu go gede ol mo gudsamting de antap lo eben. Den wen yu pinis meke ebridem samting, yu kam ane pole mi.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Bat wen da man i bin lisen wanem Zizas i bin spik po em, em bin prapa nadakain sore ane tekop go bikoz em bin gad prapa nadakain tumas samting. ");
INSERT INTO tcs_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Den Zizas i bin spik po dem klostuman, ‘Ai spik trutok po yupla, i prapa nadakain ad po risman po go antap po eben. ");
INSERT INTO tcs_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ai spik po yupla disting ya tu, i moizi po kamal po wagbaut go tru lo ai blo nidol, den po risman po go po da ples wea God i ruloba ebribodi!’ ");
INSERT INTO tcs_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Wen dem klostuman i bin lisen, dempla i bin prapa atzamp, ane dempla i bin spik baigen po Zizas, ‘Den yu tingk uda prom ebri pipol God i ken seibem?’ ");
INSERT INTO tcs_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Zizas i bin luk stret po dempla ane spik, ‘Diswan samting wea pipol i kan mekem, bat God i ken meke eniting.’ ");
INSERT INTO tcs_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Den Pita i bin spik po Zizas, ‘Mipla i bin libe ebriting po pole yu, ane wanem mipla i go gedem prom pole yu?’ ");
INSERT INTO tcs_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Zizas i bin ansa po Pita diskain, ‘Ai spik po yupla tru, wen ai da Truwan blo Man i go sidaun lo da spesil tron de lo dat ples po zaze ebriting, yupla dem klostuman blo mi i go sidaun lo tuelb spesil tron de tu, ane yupla go zaze dem tuelb pamlelain blo Izrael. ");
INSERT INTO tcs_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ane uda dempla i libe aus blo dempla, o bala o sisi, o papa o mama, o pikinini, o ebriting wea i blo em, po kam ane pole mi, em go gede demting andred mo baigen, ane dempla i go gede longlaip poeba tu. ");
INSERT INTO tcs_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bat uda dem pipol i meke demplaselp sambodi nau, dempla gobi nambalas wen dat taim i go kam. Ane uda dem pipol i meke demplaselp nambalas nau, dempla gobi sambodi wen dat taim i go kam.’ ");
INSERT INTO tcs_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Zizas i kip tok po dempla, ‘Dat ples wea God i ruloba ebribodi i wase bos blo greip pam, wea em i go wan moning po lukraun ol wokman po wok lo greip pam blo em. ");
INSERT INTO tcs_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Em spik po dempla aumas em go pei dempla po ol dei wok, den em i sane dempla go ausaid po wok. ");
INSERT INTO tcs_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","‘Wen i bin kese nain aklok moning, da pama i bin tekop go insaid po taun ane paine sam man i bin stanap de meke nating. ");
INSERT INTO tcs_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","So em bin go ane spik po dempla ip ol wande wok lo da greip pam blo em, ane em go pei dempla prapa po wok de. ");
INSERT INTO tcs_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Dempla i bin gri ane bin go ane wok lo da greip pam blo em. Wen i bin kese dinataim, da pama i bin paine mo wokman ane sane dempla go po wok tu lo da greip pam. Wen i bin kese tri aklok aptanun smokotaim, da pama i bin meke da seimting gen po dem nada wokman wea em i bin painem. ");
INSERT INTO tcs_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","‘Ane wen i bin kese klostu po nokoptaim, da pama i bin go po taun gen ane paine mo man i bin stanap de meke nating. Em bin spik po dempla, “Aukam yupla stanap ya? Yupla no wok a?” ");
INSERT INTO tcs_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","‘Dempla i bin spik baigen po da pama, “Wel nobodi i bin aske mipla ip mipla wande wok.” ‘So da pama i bin spik po dempla ip dempla wande wok lo da greip pam blo em. Dempla i bin gri ane bin go wok lo da greip pam. ");
INSERT INTO tcs_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‘Wen i bin nokoptaim da pama i bin spik po da boswokman po singaut ebridem wokman kam po gede pei blo dempla. Em bin stat pei dempla prom demwan uda i bin kam po wok klostu po nokoptaim pas. ");
INSERT INTO tcs_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dem laswan uda i bin kam po wok paib aklok, ol bin gede pul dei pei. ");
INSERT INTO tcs_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Wen dem laslot i bin gede pei blo dempla nau, dempla i bin tingk dempla i go gede mo. Bat wen dempla i bin luk, dempla i bin gede da seim pei wase dem laslot uda i bin stat wok lo paib aklok. ");
INSERT INTO tcs_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Dempla i bin go ane graul lo da pama. Dempla i bin spik, ");
INSERT INTO tcs_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Dem pipol i bin mata wok po wan aua, ane yu bin pei dempla seimkain wase mipla uda i bin wok ol dei lo otsan.” ");
INSERT INTO tcs_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","‘Dat pama i bin spik po wan prom dempla diskain baigen, “Mai pren, yu bin lisen ane gri po wok ol dei po da seim pei. ");
INSERT INTO tcs_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nau teke dis pei ane go. Ai wande pei dem las wokman seimkain wase yu. ");
INSERT INTO tcs_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","I gad lo a, po wiskain ai mas yuze mani blo mi? Ane aukam yu wail wen ai meke da seimkain gudpasin po ebribodi?” ");
INSERT INTO tcs_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","‘Wa. I gobi demkain. Uda i meke demplaselp sambodi nau, em gobi nambalas wen dat taim i go kam. Ane dempla uda i nambalas nau ol gobi sambodi.’ ");
INSERT INTO tcs_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Apta nau, Zizas ane dem klostuman blo em i bin tekop go po Zarusalem. Wen dempla i bin go apwei lo da rod go, Zizas i bin spik po dempla wanem i go apen po em wen dempla i go kese Zarusalem. ");
INSERT INTO tcs_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Em bin spik, ‘Wen yumpla i go kesem de, dem pipol i go sele da Truwan blo Man po dem edprist ane dem Zuwislotisa. Da kot i go spik ol mas kile mi. ");
INSERT INTO tcs_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Den wen dempla i go pinis lo mi, dempla go gibe mi po dem Rom amiman po daune mi, ploke mi lo wip ane neile mi lo kros po ded. Bat lo da namba tri dei, ai go kambaik laipgen.’ ");
INSERT INTO tcs_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mama blo Zemes ane Zon, demtu boi blo Zebadi, i bin kam de po Zizas lo demtu. Em bin kam ane nildaun prant lo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Zizas bin spik po em, ‘Wanem yu wandem?’ Em bin spik baigen po Zizas, ‘Lo dat ples bambai wen yu go ruloba ebribodi, ken yu meke tu boi blo mi sidaun klostu po yu, wan lo raitansaid ane da nadawan lo leptansaid?’ ");
INSERT INTO tcs_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Bat Zizas i bin spik po da mama ane demtu boi, ‘Yutu no sabe wanem yupla i askem po. Yutu tingk yupla ken go tru da big trabol wea ai go go tru a?’ Demtu boi i bin ansa, ‘Wa, mitu ken.’ ");
INSERT INTO tcs_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Den Zizas i bin ansa demtu, ‘Prapa tru wanem yutu i spik. Bat ai nogad no rait po spik uda i go sidaun lo da spesil tron klostu po mi lo raitansaid o leptansaid. Mata PapaGod blo mi de antap lo eben i sabe uda i go sidaun lo raitansaid o lo leptansaid blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wen dem nada ten klostuman i bin lisen wanem Zemes ane Zon i bin spik po Zizas, dempla i bin wail po demtu. ");
INSERT INTO tcs_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Bat Zizas i bin singaut dempla kam klostu ane em spik po dempla, ‘Yupla sabe ol king ane ol nada bigbos i oda dem pipol po meke samting ane dempla i mas mekem. Dempla wande soe ebribodi dat dempla kare lo. ");
INSERT INTO tcs_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bat yupla no mekem diskain wase dempla. Ip wan prom yupla i wande kam lida, em mas mata lisen ane mata mekem wanem dem nadawan de i nide em po mekem. ");
INSERT INTO tcs_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ane ip wan prom yupla i wande kam lida, em mas meke emselp wokman blo ebri pipol. ");
INSERT INTO tcs_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Seimkain wase mi da Truwan blo Man. Ai no bin kam po meke ol pipol po wok po mi. Ai bin kam po meke wok po dempla ane po ded po dempla.’ ");
INSERT INTO tcs_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wen Zizas ane dem klostuman blo em i bin libe taun blo Zeriko ane go, prapa bigmob pipol i bin pole dempla go biain. ");
INSERT INTO tcs_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tu blainman i bin lisen dat Zizas i bin kam datwei po demtu. So demtu i bin sidaun de lo da rodsaid weit po em. Demtu i bin ala diskain, ‘BosLod! Yu Promiswan wase King Deibid. Plizgar soe sorewei po mitu ane elpe mitu!’ ");
INSERT INTO tcs_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Wen demtu i bin ala diskain po Zizas, dem bigmob pipol i bin spik demtu po sadap. Bat demtu no bin lisen po dempla ane demtu i bin ala molaud diskain, ‘BosLod! Yu Promiswan wase King Deibid. Plizgar soe sorewei po mitu ane elpe mitu!’ ");
INSERT INTO tcs_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Zizas i bin lisen ala blo demtu so em bin stap ane spik po demtu, ‘Wanem yutu wande mi po mekem?’ ");
INSERT INTO tcs_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Demtu bin spik, ‘BosLod, mitu wande luk!’ ");
INSERT INTO tcs_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Zizas i bin sore po demtu ane tase ai blo demtu. Stretwei demtu i bin luk ane demtu bin pole Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wen Zizas ane dem klostuman blo em i bin wagbaut go po Zarusalem, dempla bin kam klostu po da biliz blo Betpas longsaid Maunt Olibtri. Zizas i bin sane tu klostuman blo em go pas po da biliz. ");
INSERT INTO tcs_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Em bin spik diskain po demtu, ‘Wen yutu go go insaid po dis biliz ya, yutu go luk wan mama dongki ane boi dongki blo em i bin mekpas wea rop de lo wan tri. Yutu teke demtu dongki kam ya. ");
INSERT INTO tcs_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ip enibodi i aske yutu wea yutu teke demtu dongki go, spik dempla, “BosLod i wandem”, ane da man go laue yutu po tekem kam.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","So wanem Aizaia da spesilmesizman blo em God i bin spik, i bin kam tru nau, ");
INSERT INTO tcs_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Spik po dem pipol blo Izrael diskain: “Luk, king blo yupla ya kam po yupla. Em no sabe praud. Em raidantap dongki, raidantap lo yang dongki.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","So demtu klostuman blo Zizas i bin mekem wanem Zizas i bin spik demtu po mekem. ");
INSERT INTO tcs_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Demtu i bin go ane teke da tu dongki kam po Zizas ane dempla i bin tekemaut kout ane putem antap lo baik blo da yang dongki, den Zizas i bin zamp antap ane raide da yang dongki go. ");
INSERT INTO tcs_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Plenti pipol wea da bigmob i bin tekemaut kout blo dempla ane sakem prant lo da rod wea Zizas i bin raid kam, ane dem nadalot i bin kate brans blo dem tri ane sakem prant lo da rod tu. ");
INSERT INTO tcs_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Zizas i bin midel wea dempla ane dem pipol uda i bin wagbaut prant ane biain lo em, i bin sing laudwan: ‘Ozana, liptemap neim blo God po dis Boi blo King Deibid! Blese dis Promiswan ya, uda kam wea da neim blo da AntapGod! Ozana, liptemap neim blo da God de antap lo eben!’ ");
INSERT INTO tcs_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wen Zizas i bin raid go insaid po Zarusalem, ebri pipol prom da siti i bin nadakain atzamp, ane dempla i bin spik po dem plenti pipol uda i bin kam lo Zizas, ‘Uda dis man?’ ");
INSERT INTO tcs_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ane dem plenti pipol i bin ansa dempla diskain, ‘Diswan Zizas, da prapa spesilmesizman prom Nazaret de lo Galali.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Apta nau, Zizas i bin go de po da Tempol ane luk pipol i bin de insaid sele ol samting po dem nada pipol. Em bin kam nadakain wail ane em bin go ane tanoba dem teibol wea blo seinze mani ane tanoba dem stol blo demwan uda i bin sele pizin, ane em bin seswei dempla prom de. ");
INSERT INTO tcs_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Em bin tok, ‘Baibol i spik, “Aus blo mi i blo mata prea, bat yupla i bin meke dis aus wase aus blo ol stilaman!” ’ ");
INSERT INTO tcs_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Zizas i bin stil de wea da Tempol wen dem pipol, uda blain ane kripol i bin kam de po em ane em bin meke dempla ebriwan kamgud. ");
INSERT INTO tcs_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Dem edprist ane dem Zuwislotisa i bin luk wanem Zizas i bin mekem po dem pipol ane lisen wanem dem pikinini i bin singaut, diskain ya, ‘Mipla preize God po da Promiswan, dis Boi blo King Deibid.’ Dempla i bin nadakain wail, ");
INSERT INTO tcs_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ane ol i bin aske Zizas, ‘Yu lisen wanem dem pikinini i spik a?’ Zizas i bin ansa, ‘Wa! Ai lisen. Yupla i bin rid wanem Baibol i bin spik a? I spik diskain, “God i bin lane pikinini ane beibi po preize neim blo em.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Apta prom de, Zizas ane dem klostuman blo em i bin go ausaid po da biliz blo Betani ane stap de da nait. ");
INSERT INTO tcs_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wen i bin moningtaim, Zizas ane dem klostuman blo em i bin stat gobaik po Zarusalem. Wen dempla i bin wagbaut go midel lo rod, Zizas i bin pil anggre, ");
INSERT INTO tcs_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ane em bin luk wan pigtri i bin stanap de wansaid lo da rod. Em bin wagbaut go klostu po da tri po luk ip em gad prut, bat da pigtri no bin gad no prut, mata ol lip. So Zizas i bin tokstrong po da pigtri, ‘Yu nogo sake no prut gen!’ Stretwei da pigtri i bin draiap ded. ");
INSERT INTO tcs_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wen dem klostuman blo Zizas i bin luk da pigtri i bin draiap ded, dempla i bin atzamp, ane aske Zizas diskain, ‘Aukam dis pigtri i bin draiap ded diskain kuikwan?’ ");
INSERT INTO tcs_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Zizas i bin spik dempla, ‘Ai spik trutok po yupla, ip yupla i gad strong bilib ane no tingk tuwei, yupla ken meke diskainting ya wanem ai bin mekem ane plenti mo. Yupla ken spik po dis maunten ya, “Go, zamp insaid solwata”, ane da maunten i go mekem. ");
INSERT INTO tcs_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ip yupla i gad strong bilib, yupla prea ane aske God po eniting, em i go gibem po yupla.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Den Zizas ane dem klostuman blo em i bin gobaik po da Tempol ane Zizas i bin stat po tise dem pipol de. Wen Zizas i bin tise dem pipol, dem edprist ane ol nada Zuwiselda i bin kam de po em ane adwan spik po em, ‘Wanem rait yu gad po meke demting ya wea yu bin mekem lo dis Tempol? Uda bin gibe yu da rait po kare lo a?’ ");
INSERT INTO tcs_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Zizas i ansa dempla, ‘Ai go spik yupla uda bin gibe mi dat rait po kare lo. Ip yupla i go ansa dis kuestin blo mi, den ai go ansa kuestin blo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yupla spik mi, Zon Baptaizman i bin gede dat rait po baptaiz ol pipol, prom man o prom God a?’ Dempla bin tok po wananada, ‘Ip yumpla go spik diskain, em bin gedem prom God, den em go spik, “Aukam yupla no bin bilib Zon?” ");
INSERT INTO tcs_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ane ip yumpla i go spik diskain, em bin gedem prom man, dem pipol i go meke big trabol po yumpla bikoz dem pipol i bin bilib dat Zon i bin spesilmesizman prom God.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","So dempla i bin ansa, ‘Mipla no sabe.’ Den Zizas i spik, ‘Den ai nogo ansa kuestin blo yupla, uda bin gibe mi da rait po kare lo.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Den Zizas bin spik, ‘Ai go yan po yupla wan stori blo wan man uda i bin gad tu boi pikinini, den yupla ken spik po mi wanem yupla tingbaut da stori. Orait. Da papa bin spik po da bigboi blo em diskain, “Mai boi, yu go wok lo da gadan tidei.” ");
INSERT INTO tcs_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Da boi i bin spik diskain, “Ai no wandem.” Bat apta, em bin seinze main blo em ane em bin go ane wok lo da gadan. ");
INSERT INTO tcs_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Den da papa i bin spik po da yangboi blo em diskain, “Mai boi, yu go ane wok lo da gadan.” Da boi i bin spik, “Wa, papa ai go.” Bat em no bin go. ");
INSERT INTO tcs_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","‘So yupla tingk, uda prom demtu i bin lisen po papa blo demtu?’ Dempla i bin ansa, ‘Da paswan.’ Den Zizas i bin eksplein da mining, ‘Ai spik trutok po yupla, ebri pipol wea yupla spik i prapa nugud wase taksman ane rabisoman, dempla i go go antap po da ples wea God i ruloba ebribodi pas, bipo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Zon Baptaizman i bin ya lo yupla, ane em i bin soe yupla da raitwei po stap, bat yupla no bin bilib em. Bat dem nugudpipol, dem taksman ane oman uda sele demplaselp po mani, i bin bilib em ane dempla i bin tanewei prom dem nugudwei blo dempla. Yupla i bin luk dempla i bin tanewei prom dem nugudwei bat yupla stil no bin bilib lo Zon Baptaizman ane pole datwei blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Zizas i bin spik gen, ‘Yupla lisen po dis stori ya ai go yan. Wantaim wan pama i bin go ane plante plenti greipbain lo da lan blo em. Em bin bilde stonwol raun da eria lo da lan, ane digine oll lo da graun po smase dem greip insaid po meke zius. Em bin bilde taua tu po luk go ausaid. Em bin rente da pam blo em po dem nada pama, den em bin mub go po stap lo nada kantri. ");
INSERT INTO tcs_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wen da taim i bin kam po sele dem greip, dat ouna blo da pam i bin sane dem wokman blo em go po kolekt sea blo em prom dem greip. ");
INSERT INTO tcs_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bat dem pama i bin kese dempla, paite wan, kile da nadawan ane stone da nadawan. ");
INSERT INTO tcs_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Dat ouna i bin sane plenti wokman blo em nau go po kolekt sea blo em prom dem greip, bat da seimting i bin apen po dempla. ");
INSERT INTO tcs_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","‘So da ouna i bin tingk diskain, “Ip ai go sane boi blo mi go, dempla nogo meke nating po em, bikoz dempla i go rispekt em.” So em bin sane boi blo em go. ");
INSERT INTO tcs_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","‘Bat wen dem pama i bin luk da boi blo da ouna i bin kam, dempla i bin tok po wananada, “Diswan i da wan boi blo da ouna. Ip yumpla i go kile em, yumpla go gad dis pam ya po yumplaselp!” ");
INSERT INTO tcs_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","So dempla i bin kese em ane tekem go ausaid prom da pam ane kile em.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Den Zizas i bin spik po dempla de, ‘Wanem yupla tingk i go apen po dem pama wen da ouna blo da pam i go kam de?’ ");
INSERT INTO tcs_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Dem lida blo dem Zuwislotisa bin ansa, ‘Em go kile ebridem nugud pama wea nadakain nugudwei, ane em go rente da greip pam po dem nada pama uda i go gibe sea blo em ebritaim apta dempla i sele dem greip.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Zizas i bin aske dempla, ‘Yupla bin rid diswan insaid Baibol a? “Diswan da timba wanem ol dem kapenta i no bin wandem, bat nau, em da meintimba po olde da rup po meke em strong. AntapGod i bin meke dat timba da mein wan, ane mipla bin luk prapa gudsamting ya.” ");
INSERT INTO tcs_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‘Ai spik po yupla tru, God go teke da ples wea em i go ruloba ebribodi prom yupla uda no wande lisen po em ane go gibem po ol pipol blo ol nada kantri uda go lisen po em ane mekem wanem em wandem. ");
INSERT INTO tcs_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ip enibodi no sabe da timba ane trip oba da timba, da timba i go prapa katem. Bat ip da timba i poldaun antap lo enibodi, i go prapa smase em.’ ");
INSERT INTO tcs_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wen dem edprist ane dem Parasi i bin lisen wanem Zizas i bin spik, dempla i bin stretwei sabe Zizas i bin tokbaut dempla. Dempla i bin dem nugudpama lo dat stori. ");
INSERT INTO tcs_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Dempla bin wande kesem go po kot, bat dempla i bin prait bikoz dem bigmob pipol i bin bilib Zizas em i spesilmesizman prom God. ");
INSERT INTO tcs_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Den apta, Zizas i bin yan po dempla ol nada stori wea i gad mining. Em bin yan, ");
INSERT INTO tcs_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","‘Dat ples wea God i ruloba ebribodi i wase king uda i meke prapa big maret kaikai po boi blo em. ");
INSERT INTO tcs_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Dat king i bin inbait plenti pipol po kam po da maret kaikai. Orait, wen da taim i bin kam nau po da maret kaikai, da king i bin sane dem sebant blo em go po spik dem pipol po kam. Bat dempla no bin wandem. ");
INSERT INTO tcs_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","‘So da king i bin sane dem nada sebant blo em go po swite dempla po kam diskain ya, “Dem kaikai i redi nau ane i gad olkain nais mit i bin pinis kuk. Ariap kam nau.” ");
INSERT INTO tcs_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bat dempla stil no bin wande go. Wan blo dempla i bin go ane wok lo pam blo em ane nadawan i bin go wok lo stoa blo em. ");
INSERT INTO tcs_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Dem nadalot man i bin kese dem mesinza blo da king, ane ploke dempla ane kile dempla. ");
INSERT INTO tcs_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","‘Wen da king i bin lisen wanem i bin apen po dem sebant blo em, em i bin nadakain wail nau, ane em bin sane dem amiman blo em go ane kile dem man uda i bin kile dem sebant blo em, ane bane siti blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Den da king i bin singaut dem nada sebant blo em ane spik po dempla, “Da maret kaikai i redi nau. Dem pas pipol wea ai bin inbait po kam, dempla no pit po kam po dis kaikai. ");
INSERT INTO tcs_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yupla go ane paine enibodi de wagbaut midel lo rod ane lo ebri kona ane singaut dempla kam.” ");
INSERT INTO tcs_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","So dempla i bin go ane paine olkain gudpipol ane nugudpipol ane teke dempla kam po da maret kaikai. Da bilding wea i bin gad da maret kaikai, i bin nadakain pulap lo ol gest. ");
INSERT INTO tcs_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Bat wen da king i bin kam de po mite dem pipol, em bin luk wan man de uda no bin were gud klos kam de po da maret kaikai. ");
INSERT INTO tcs_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","So em bin spik po da man, “Mai pren, aukam yu no were gud klos kam po dis maret kaikai?” Dat man no bin spik nating. ");
INSERT INTO tcs_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Den da king i bin spik po dem sebant blo em po taite an ane leg blo da man ane sakem go ausaid lo dak, ane den da man i go pil sore po emselp. Em go krai ane graine tit blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ane Zizas i spik, ‘God i go singaut plenti pipol po kam, bat mata lelbet em i go suzem.’ ");
INSERT INTO tcs_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Apta nau, dem Parasi i bin kam tugeda po tok po paine wei po trape Zizas lo olkain trik kuestin, solong dempla i ken tekem go po kot. ");
INSERT INTO tcs_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","So dempla i bin sane sam dem klostuman blo dempla ane sam sapota blo da Zuwis King Erod go po Zizas po askem, ‘Tisa, mipla sabe yu no sabe lai ane yu mata tise ol pipol baut da wei wiskain God i wandem. Yu mata spik pipol stret wanem i rait ane rong prant wea God, nomata dempla i ol bigman. ");
INSERT INTO tcs_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bat ken yu spik mipla, ip i orait po pei taksmani po da bigking blo Rom o no?’ ");
INSERT INTO tcs_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Zizas i bin sabe dempla i bin trai po trike em, so em bin spik po dempla diskain, ‘Yupla ol tupes pipol! Yupla kan trike mi wea demkain kuestin! ");
INSERT INTO tcs_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yupla soe mi wan koin yu yuzem po pei taks.’ So dempla i bin soem wan koin. ");
INSERT INTO tcs_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Den em bin aske dempla, ‘Uda piksa ane neim i gad ya lo dis koin?’ ");
INSERT INTO tcs_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Dempla bin ansa, ‘Siza, da bigking blo Rom.’ Den Zizas i bin spik, ‘Gibe Siza, wanem blo em, ane gibem po God ebriting wanem blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Dis ansa blo Zizas i bin meke dempla atzamp, den dempla i bin gowei prom Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Dat seimdei, sam dem lida blo da Zuwislo uda kole demplaselp Sadusi i bin kam de po Zizas. Dempla no bilib God go meke ol ded pipol kamlaipgen. Dempla i bin trai po trike em, so dempla go kuestin em, ");
INSERT INTO tcs_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","‘Tisa, Mozes i bin spik, “Ip man i bin maret ane em i ded nogad pikinini, wel da bala blo em mas maret da widooman solong demtu go meke pikinini ane da pikinini i gobi blo da ded bala tu.” ");
INSERT INTO tcs_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","I bin gad seben bala. Dat bigbala i bin maret bat nogad pikinini ane em bin ded. So da sekan bala i bin maret da widooman. ");
INSERT INTO tcs_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Dis bala i bin ded tu nogad pikinini. Dat oman i bin maret po da nada bala. Da seimting i bin apen tu po em ane ol dem nada po bala wea dat oman i bin maret. ");
INSERT INTO tcs_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Den apta nau, dat oman i bin ded. ");
INSERT INTO tcs_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","So yu spik po mipla, wen dat taim i go kam wen ebri pipol i go gedap laipwan gen prom ded, em gobi oman blo uda, bikoz em i bin oman blo ebridem seben bala?’ ");
INSERT INTO tcs_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Zizas i bin ansa dempla diskain, ‘Yupla no sabe wanem dem wod blo God i spik. Yupla tok rongwei ane yupla no sabe dat paua blo God. ");
INSERT INTO tcs_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wen ebribodi go kambaigen laip, dempla nogo maret. Dempla gobi seimkain wase dem einzel wea eben. ");
INSERT INTO tcs_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","‘Ane aukam yupla tingk ebridem ded pipol i kan gedap laipwan gen prom ded? Yupla bin rid wanem Baibol i bin spik a? God bin spik po Mozes diskain, ");
INSERT INTO tcs_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ai da God blo Eibram, Aizak ane Zekop.” So God em i God blo ol laip pipol. Em i no God blo ol dem dedwan.’ ");
INSERT INTO tcs_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Wen dem bigmob pipol i bin lisen wanem Zizas i bin spik, dempla i bin nadakain atzamp. ");
INSERT INTO tcs_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wen dem Parasi i bin lisen dat dem Sadusi i bin gad no ansa po Zizas, dempla i bin meke dempla oun kuestin po askem. ");
INSERT INTO tcs_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Wan prom dempla i bin smatman blo Zuwislo, so em i bin trai po trike Zizas lo dis kuestin: ");
INSERT INTO tcs_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","‘Tisa, wanem da nambawan lo blo Mozes prom dem lo blo em?’ ");
INSERT INTO tcs_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Zizas i bin ansa, ‘Yupla mas labe da AntapGod wea olgeda at blo yupla, ane olgeda laip blo yupla, ane olgeda sens blo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Diswan i da prapa pas lo ane da mein lo tu. ");
INSERT INTO tcs_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Da sekan lo i prapa impotant wase da pas lo: “Labe kantriman blo yupla wiskain yupla labe yuplaselp.” ");
INSERT INTO tcs_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ol dem lo blo Mozes ane dem wod blo dem spesilmesizman blo God i bin kamaut prom dis tu lo blo God ya nau.’ ");
INSERT INTO tcs_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wen dem Parasi i bin plenti de raun lo Zizas, Zizas i bin aske dempla: ");
INSERT INTO tcs_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","‘Yupla tingk uda, i da Promiswan uda God i go sane kam, ane em i boi blo uda?’ Dempla i bin ansa, ‘Em i boi blo King Deibid.’ ");
INSERT INTO tcs_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Den Zizas i bin spik, ‘So aukam da OliSpirit i bin spik po Deibid insaid tot blo em po kole da Promiswan uda God i go sanem, BosLod? King Deibid i bin spik: ");
INSERT INTO tcs_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Da AntapGod i bin spik po da BosLod blo mi, Sidaun ya wea raitansaid blo mi, da ples blo ona, antil ai go pute dem enami blo yu andanit kontrol blo yu.” ");
INSERT INTO tcs_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ip King Deibid bin kole da Promiswan uda God i sanem kam, BosLod, den auken da Promiswan bi boi blo em? Nono, i kan!’ ");
INSERT INTO tcs_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Nobodi i bin gad ansa po em. So dempla no bin gad no kuestin po askem gen. ");
INSERT INTO tcs_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Den Zizas i bin spik po dem bigmob pipol ane dem klostuman blo em, ");
INSERT INTO tcs_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","‘Dem Zuwislotisa ane dem Parasi prapa sabebaut tising blo Mozeslo. ");
INSERT INTO tcs_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","So yupla stap kuaiat ane lisen po wanem dempla i tise yupla ane mekem. Bat no mekem wanem dempla i mekem, bikoz dempla i spik wan ting bat meke nadating. ");
INSERT INTO tcs_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yupla sabe. Dempla meke dem Zuwislo prapa ad po yupla, ane wen yupla nid elp dempla no tingbaut po elpe yupla. ");
INSERT INTO tcs_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","‘Dempla meke olkain samting solong ol pipol i go tekenotis lo dempla wase dempla prapa impotant man. Dempla were plas kout wea i prapa long, ane taite big strap wea pored blo dempla wea ol i bin raite sam Baibol wod. ");
INSERT INTO tcs_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ane wen i gad pati, dempla mas sidaun po kaikai lo da mein teibol, ane wen i gad miting lo zuwispreaus, dempla mas sidaun lo dem prapa spesil sit blo ona. ");
INSERT INTO tcs_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Wen dempla i go po wagbaut go eniwei ane mite ol pipol, dempla wande dem pipol po rispekt dempla ane kole dempla “Tisa”. ");
INSERT INTO tcs_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘So yupla lisen po mi nau, no lete nobodi kole yupla “Tisa”, bikoz yupla ebriwan i bala ane sisi. Da wan tisa blo yupla i de antap lo eben. ");
INSERT INTO tcs_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ane no kole nobodi ya lo ert “PapaGod”, bikoz yupla mata gad wan PapaGod ane em de antap lo eben. ");
INSERT INTO tcs_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","No lete nobodi kole yupla “Bos”, bikoz i mata gad wan bos, ane em i da Promiswan uda God i sanem. ");
INSERT INTO tcs_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Uda man i go lisen ane mata meke wok po enibodi, em gobi da nambawan man. ");
INSERT INTO tcs_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Bat ip yu meke yuselp nambawan man, den yu go kam da nambalas wan. Yu mas ambol yuselp, den God i go meke yu nambawan. ");
INSERT INTO tcs_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","‘I gobi prapa nugud po yupla Zuwislotisa ane yupla Parasi. Yupla prapa tupes! Yupla stape dempla prom go insaid po da ples wea God i go ruloba ebribodi. Yupla nogo go insaid dat ples de antap. ");
INSERT INTO tcs_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘I gobi prapa nugud po yupla Zuwislotisa ane yupla Parasi. Yupla prapa tupes! Yupla go prapa longwei ane krose solwata go po dem nada kantri po meke mata wan man po bilib dem rong tising blo yupla. Wen yupla i kip mekem diskain, yupla meke dat man monugud den yuplaselp ane em go ban insaid el seimkain wase yupla. ");
INSERT INTO tcs_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘I gobi prapa nugud po yupla dem blain lida. Yupla bin spik, “Ip enibodi i meke promis ane yuze neim blo da Tempol blo God po baigemap emselp, wel em ken broke dat promis.” Bat den yupla spik, “Ip enibodi i meke promis ane yuze neim blo dem gold de insaid lo da Tempol, wel em kan broke dat promis.” ");
INSERT INTO tcs_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yupla ol apsens blain pipol! Dat gold de insaid i mospesil den da Tempol a? No! Dat Tempol nau i meke da gold spesil. ");
INSERT INTO tcs_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ane yupla bin spik diskain tu, “Ip enibodi i meke promis ane yuze neim blo da olta wea i blo meke opring po baigemap emselp insaid lo dat preaus, wel em ken broke da promis. Bat ip em i yuze neim blo dem opring wea ol bin putem antap lo dat olta, wel em kan broke dat promis.” ");
INSERT INTO tcs_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Yupla prapa blain! Dat opring wea ol putem antap lo olta i mospesil den da olta a? No! Dat olta nau i meke da opring spesil. ");
INSERT INTO tcs_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bikoz wen yu meke promis ane kole neim blo da olta, yu wantaim kole neim blo demting de antap lo da olta tu. ");
INSERT INTO tcs_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ane wen yu meke promis ane kole neim blo da Tempol, yu wantaim kole neim blo God tu, uda i stap de insaid lo da Tempol. ");
INSERT INTO tcs_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ane wen yu meke promis ane kole neim blo eben, dasmin yu kole neim blo da spesil tron ane God tu, uda i sidaun lo dat spesil tron. ");
INSERT INTO tcs_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘I gobi prapa nugud po yupla Zuwislotisa ane yupla Parasi. Yupla prapa tupes! Yupla tise dem pipol prapa smol samting, wase gibe pat blo ebri smol samting blo dempla po opring. Bat yupla no tise dem pipol baut da prapa impotant ting blo dem lo, wase tise dempla baut gudwei, sorewei, ane bilib. I gud yupla i bin tise dempla po gibe pat samting blo dempla po opring. Bat yupla mas tise dempla baut dem prapa impotant lo tu. ");
INSERT INTO tcs_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yupla prapa ol blain lida! Opene yupla ai! Yupla tumas woribaut dem smolsmol lo, bat yupla no woribaut dat prapa impotant lo. ");
INSERT INTO tcs_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘I gobi prapa nugud po yupla Zuwislotisa ane yupla Parasi. Yupla prapa tupes! Yupla prapa kline kap ane pleit blo yupla, ane meke yuplaselp prapa klin. Bat insaid, yupla prapa nugud, prapa gridi ane dati. ");
INSERT INTO tcs_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yupla Parasi, yupla ebriwan i blain! Ip insaid blo yupla i klin den da ausaid blo yupla i go klin tu. ");
INSERT INTO tcs_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘I gobi prapa nugud po yupla Zuwislotisa ane yupla Parasi. Yupla prapa tupes! Yupla wase greib wea dem oman i pute ol nais plaua po mekem luk nais. Bat de andanit ol bon ane olkain ratan bodipat i leidaun. ");
INSERT INTO tcs_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yupla trai meke yuplaselp luk rait ane stret ausaid po dem pipol, bat insaid yupla prapa tupes ane gad ol prapa nugudwei. ");
INSERT INTO tcs_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘I gobi prapa nugud po yupla Zuwislotisa ane yupla Parasi. Yupla prapa tupes! Prapa longtaim de pas, dem longtaim ate blo yupla i bin kile dem spesilmesizman ane nau yupla meke tumston blo dem spesilmesizman. Ane dem longtaim ate blo yupla i bin kile dem bipotaim pipol blo God ane nau yupla meke dem beriolples blo dempla prapa nais lo ol onament ane ol nais plaua po kabarap. ");
INSERT INTO tcs_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Den yupla i bin spik, “Ip mipla i bin de, mipla no bin zoin po kile dem spesilmesizman blo God.” ");
INSERT INTO tcs_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","‘Wen yupla tok diskain, dasmin yupla gri dem prapa longtaim ate blo yupla i bin kile dem spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Maitbi yupla mas pole demwei blo dem ate ane go kile ol dem spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Dem ate blo yupla i bin wase sneik, ane yupla tu i wase sneik. Ai spik po yupla tru. Yupla kan ranwei prom da big paia blo el. ");
INSERT INTO tcs_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","‘Ai go sane ol spesilmesizman ane ol smatman ane ol tisa blo lo blo God po yupla. Yupla i go kile sam prom dempla, ane go neile sam lo kros, ane go ploke sam lo wip lo dem zuwispreaus, ane yupla go apte sam prom wan siti go po nada siti. ");
INSERT INTO tcs_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Prom de nau God i go panse yupla. Em go peibaik prom dat taim wea ate blo yupla i bin kile dem prapa longtaim tru biliba blo God, prom dat rait ane stret Eibol, ane Zakaraia uda i bin boi blo Barekaia. Yupla ate bin kile Zakaraia de insaid da Tempol, midel wea da olta ane da Seramoni eria. ");
INSERT INTO tcs_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ai spik trutok po yupla, God i go panse yupla, dem pipol blo tidei, po kile ol dem prapa longtaim pipol blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Apta nau, Zizas i bin spik, ‘Zarusalem, a Zarusalem! Yupla ebridem pipol blo Zarusalem bin ebritaim kile dem spesilmesizman blo God ane yupla bin stone dem spesilmesizman wea God i bin sanem kam po yupla. Aumas taim ai bin trai po kese yupla klostu wase mama paul i kese dem pikinini blo em andanit lo wing, bat yupla no bin lete mi. ");
INSERT INTO tcs_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","So yupla luk nau, God i kamaut prom aus blo em nau, libe da Tempol empti. ");
INSERT INTO tcs_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ai spik po yupla tru, yupla nogo luk mi gen antil yupla i go spik, “Blese dis Promiswan ya uda i bin kam lo neim blo da AntapGod!” ’ ");
INSERT INTO tcs_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Wen Zizas ane ol klostuman blo em i bin libe da Tempol eria, dem klostuman i bin spik po Zizas diskain, ‘Yu luk ol dem bilding ane dis Tempol ya?’ ");
INSERT INTO tcs_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Den Zizas i bin spik, ‘Ai spik trutok po yupla, wa yupla luk ebridem bilding ya, a? Dempla ebriwan go smas, i nogo gad no wan ston i go stap antap lo nada ston!’ ");
INSERT INTO tcs_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Prom de, Zizas ane ol klostuman blo em i bin go po Maunt Olibtri wea i gad gadan blo ol olibtri. Wen ol i bin sidaun de lo dat il, dempla wase da Tempol gobaik. Dempla bin kam po Zizas ane askem, ‘Wattaim i go apen? Ane i go gad eni sain po soem dat yu ya kambaik ane wen dis wold i go pinis?’ ");
INSERT INTO tcs_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Zizas i bin spik baik, ‘No lete nobodi trike yupla. ");
INSERT INTO tcs_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bikoz plenti pipol i go spik diskain ya, “Ai nau da Promiswan uda God i go sanem.” Plenti pipol i go bilib prom dempla tu. ");
INSERT INTO tcs_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ane wen yupla lisenbaut ol bigpait, dat ebriwei ol i pait, yupla no prait bikoz demting mas kam. Bat da wold i nogo pinis yet. ");
INSERT INTO tcs_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bipo da pinistaim go kam, ol nada kantri go pait gense nada kantri, ane i go gad ertseik lo ebri eria blo da wold, ane prapa plenti pipol i go anggre ebriwea raun lo da wold tu. ");
INSERT INTO tcs_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bat demting wea i go apen, demwan i mata da stat blo da trabol de kam biain. ");
INSERT INTO tcs_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Ane wen da trabol i go kam, demwan uda i blo mi, dempla i go kese yupla ane teke yupla go po kot. Ane ol i go paine olkain polt lo yupla bikoz yupla i blo mi. Den ol i go kile yupla. ");
INSERT INTO tcs_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Plenti pipol i go tanewei prom mi, ol pren go eite wananada, ane go teke pren blo dempla po kot. ");
INSERT INTO tcs_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ane plenti ol laimesizman i go kamaut ane trike ol plenti pipol. ");
INSERT INTO tcs_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dempla i go meke dem pipol meke ol monugud samting, ane i go meke ebri pipol nomo gad lab. ");
INSERT INTO tcs_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bat demwan uda i go mata stap gad strong bilib lo mi, dempla gobi seib. ");
INSERT INTO tcs_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ane wen ebri pipol wea ol kantri lo da wold i go lisenbaut da Gudniuz blo God, den ai go kambaigen.’ ");
INSERT INTO tcs_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Zizas em i spik diskain, ‘Dat taim i go kam wen yupla i go luk dat prapa nugud samting stanap insaid lo da Oli Tempol, dis seimting nau wanem Daniel da spesilmesizman blo God i bin tokbaut. Yupla uda ride diswan mas prapa sabe mining blo dem wod ai spik. ");
INSERT INTO tcs_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ane wen yupla blo Zudia i go luk dat nugud samting, yupla ebriwan i go stretwei ranwei prom Zudia go antap po dem ilkantri. ");
INSERT INTO tcs_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ip enibodi i sidaun ausaid lo aus blo em, wel em mas nogo insaid po paikap ol samting blo em. Em mas stretwei ranwei prom de go. ");
INSERT INTO tcs_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ane i go po demwan tu uda i wok lo gadan blo em. Em mas nogo aus pas po teke kout blo em. ");
INSERT INTO tcs_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Lo dat taim bambai, i gobi prapa nugud po dem oman uda pamle ane ol mama uda i gad beibi. ");
INSERT INTO tcs_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bat prea ane aske God po dat taim wen yupla i go ranwei go po dem ilkantri, aske em po no mekem lo koltaim o lo Sabatdei. ");
INSERT INTO tcs_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Dis trabol, i no wase dem trabol wea dis wold i bin luk bipo. Dis trabol i gobi prapa nadakain monugud wea dis wold i no bin luk bipo, ane nogo luk gen. ");
INSERT INTO tcs_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ip God nogo stape dis trabol, i nogo gad nobodi lept. Bat God i sabe. Em mata go meke dis trabol go po sotwail, bikoz em bin pinis suze ol pipol blo em. ");
INSERT INTO tcs_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Ane wen dat taim i go kam, sam pipol i go spik, “Luk, da Promiswan ya”, o “luk, em de”. Wen dempla go tok demkain no lisen ane bilib dempla. ");
INSERT INTO tcs_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ol lai Promiswan ane ol laimesizman i go kamap. Ane dempla go meke olkain gudsain ane spesil gudsamting, ane plenti pipol i go tekenotis lo dempla. Dempla go trai po tane dem pipol uda bilib lo God gowei prom God. ");
INSERT INTO tcs_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yupla i bin lisen prapa gud po demting ya ai bin spik! Bikoz demwan ol woning po yupla. So yupla lugaut nau. ");
INSERT INTO tcs_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","‘So ip sambodi spik diskain, “Luk, da Promiswan de ausaid lo ples wea i nogad man”, no wori po go de po luk. O “Luk, da Promiswan em de aid insaid lo dat aus”, no bilib em. ");
INSERT INTO tcs_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bikoz wen ai da Truwan blo Man i go kambaigen, i gobi demkain wase laitning i laitap ebri pat blo da skai. ");
INSERT INTO tcs_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yumpla sabe wen ol solwata pizin i kam tugeda, i mas gad ded pis de leidaun. Wen yupla luk ol diskainting i apen, den yupla sabe da taim blo mi i klostu po kam.’ ");
INSERT INTO tcs_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Zizas i kip spik, ‘Stretwei apta dem dei blo trabol da san i go kam dak, ane da mun nomo go gibe lait, dem sta go poldaun prom skai, ane ebridem strong samting blo skai i go seik. ");
INSERT INTO tcs_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Den apta demting i bin apen, ebribodi i go luk mi da Truwan blo Man kamaut lo eben, ane ebri pipol blo ebri kantri i go mata base bigkrai, ol go mata sorewan krai. Ol go luk mi da Truwan blo Man i go kam lo klaud blo eben ane kam lo nadakain sainilait prom paua blo God. ");
INSERT INTO tcs_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ane wen dat trampat i go blou nadakain adwan, ol einzel i go go prom nada end, tu nada end blo eben ane ert, ane go teke dem pipol wea God i bin suzem kam tugeda.’ ");
INSERT INTO tcs_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Den Zizas i kip tok, ‘Wel yupla tingbaut nau, wen yupla luk ol niu sut i kamaut prom pigtri, yupla sabe i klostu po nowestaim nau. ");
INSERT INTO tcs_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Seimkain. Wen yupla go luk ebri demting wea ai bin eksplein po yupla i apen, yupla go sabe da taim blo mi da Truwan blo Man po kambaigen, i prapa klostu nau. ");
INSERT INTO tcs_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ai spik trutok po yupla, ebriwan blo distaim ya nau ol nogo ded. Ol go luk demting i go apen. ");
INSERT INTO tcs_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ane eben ane ert i go pinis, bat wod blo mi i kan neba pinis. ");
INSERT INTO tcs_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Bat nobodi i sabe wattaim ol demting i go apen. Iben mi ane dem einzel de antap lo eben i no sabe. Mata PapaGod blo mi de antap lo eben i sabe. ");
INSERT INTO tcs_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‘Ane wen ai da Truwan blo Man i go kambaigen, i gobi demkain wase dat taim blo Noa. ");
INSERT INTO tcs_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Bipo da big pladwata i bin kam, dem pipol i bin meke ol big maretpati, ol big kaikai ane big dringkap, spakap. Dempla i bin meke demkain raitap po da taim wen Noa i bin go insaid po da bot blo em. ");
INSERT INTO tcs_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Dem pipol no bin gede woning, ane dempla i no bin sabe wanem go apen antil da big pladwata i bin kam ane wase dempla ebriwan go. Wa, dat taim wen ai da Truwan blo Man i go kambaigen, plenti pipol i go mekem seimkain. ");
INSERT INTO tcs_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","‘Tu man i go wok ausaid lo gadan. Dem einzel i go kam ane teke wan ane libe da nadawan biain. ");
INSERT INTO tcs_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tu oman i go graine wit po meke plaua. Dem einzel i go kam ane teke wan ane libe da nadawan biain. ");
INSERT INTO tcs_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘So yupla mas ebritaim redi, bikoz yupla no sabe wattaim ai go kambaigen. ");
INSERT INTO tcs_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Bat sabe diswan. Ip bos blo wan aus i prapa sabe wattaim da stilaman i go kam po stil lo aus blo em, em nogo slip. Em go weit po em. Em go meikso da stilaman nogo stile ol samting prom aus blo em. ");
INSERT INTO tcs_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Seimkain. Yupla mas redi ebritaim, bikoz yupla no sabe wattaim ai da Truwan blo Man i go kambaik. ");
INSERT INTO tcs_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘Yupla tingbaut. Wotip i gad wan smat ane gudwokman. Dat bos i go putem po lukapta dem nada wokman ane pamle blo em wen da bos i gowei. ");
INSERT INTO tcs_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ip da bos i kambaik ane luk da wokman i bin meke demting wea em bin spik po em po mekem, den da bos i go gibe em riwod. ");
INSERT INTO tcs_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ai spik trutok po yupla. Bikoz em bin lisen ane meke demting wea da bos i bin spik em po mekem, da bos blo em i go prapa trasem nau, ane go meke em po lugaut ebridem samting blo em. ");
INSERT INTO tcs_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bat ip dat wokman i nugudman ane tingk da bos i go gowei po longtaim, ");
INSERT INTO tcs_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","em i go ane paite dem nada wokman, ane em i kaikai ane dringk lo dem nada pipol uda i drongk. ");
INSERT INTO tcs_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Wail dempla i stil pati, da bos i kambaik ane paine dempla. ");
INSERT INTO tcs_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Dat bos i go prapa panse dat wokman ane em go sanem go wea ol dem tupes pipol i stap. Wea dat ples, dempla i go pile nadakain nugud pein ane go krai ane graine tit blo dempla lo pein.’ ");
INSERT INTO tcs_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Den Zizas bin yan dis stori wea i gad mining. Em spik, ‘Dat taim wen God i go ruloba ebribodi, i gobi demkain wase ten gel uda i teke lamp blo dempla ane tekop go po mite da man uda i blo maret. ");
INSERT INTO tcs_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Paib gel i bin smat ane dem nada paib i bin stupit. ");
INSERT INTO tcs_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dem paib stupitwan i no bin kare ekstra oil po lamp blo dempla, ");
INSERT INTO tcs_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","bat dem smatwan i bin kare ekstra oil po lamp blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Wen dempla i bin kese dat ples wea dempla i go mite da man uda i blo maret, em no bin de yet bikoz em i bin leit. So dempla i bin mata leidaun de ane slip. ");
INSERT INTO tcs_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","‘Wen i bin kese midelnait, sambodi i bin ala diskain, “Da man uda i blo maret, em ya kam nau. Yupla kam ane mite em.” ");
INSERT INTO tcs_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","‘Den dem gel i bin gedap ane laite lamp blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bat dem lamp blo dem paib stupitwan i bin go po aut, bikoz dempla no bin kare ekstra oil po pilemapem gen. So dempla i bin aske dem nadawan po oil. ");
INSERT INTO tcs_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Bat dem smatwan i bin spik po dempla diskain, “Nono! Ip mipla i go gibe yupla sam prom mipla, mipla go ranaut tu. So yupla mata go ane baie oil po yuplaselp.” ");
INSERT INTO tcs_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","‘Wen dempla i bin go po baie oil, da man uda i blo maret i bin kam de, ane dem paib smatwan uda i bin de redi, dempla i bin go wantaim lo em, go insaid po da maret kaikai, den da doa i bin lok. ");
INSERT INTO tcs_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Apta nau, dem paib stupitwan i bin kam de ane ala diskain, “Bos! Bos! Lete mipla go insaid!” ");
INSERT INTO tcs_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","‘Bat da bos i bin spik diskain, “Nono! Ai no sabe yupla!” ");
INSERT INTO tcs_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‘So yupla lisen nau. Yupla mas ebritaim redi bikoz yupla no sabe wattaim da taim blo mi po kambaigen.’ ");
INSERT INTO tcs_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Zizas i spik gen, ‘Dat ples wea God i go ruloba ebribodi i wase wen bos blo aus i gowei po nada kantri. Bat bipo em go, em i singaut tri wokman blo em ane spik po dempla po lukapta sam dem mani blo em. ");
INSERT INTO tcs_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Em bin gibe $5,000 po wan wokman bikoz em i sabe em i prapa sabe wiskain po lugaut mani. Em bin gibe da nadawan $2,000, bikoz em i sabe lelbet wiskain po lugaut mani. Den em bin gibe da laswan $1,000, bikoz em no sabe prapa wiskain po lugaut mani. Den em i bin gowei. ");
INSERT INTO tcs_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","‘Dat wokman uda i bin gad $5,000, em bin go kuikwan ane meke biznis wea dat mani. Em bin meke nada $5,000 antap lo da pas $5,000. ");
INSERT INTO tcs_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Seimkain tu po da namba tu wokman uda i bin gad $2,000. Em bin go kuikwan ane meke biznis wea da mani. Em bin meke nada $2,000 antap lo da pas $2,000. ");
INSERT INTO tcs_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bat da namba tri wokman uda i bin gad $1,000, em i bin teke da mani go, digine oll ane berem. ");
INSERT INTO tcs_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Apta nau, da bos i bin kambaigen ane aske dempla wanem dempla i bin mekem lo dem mani. ");
INSERT INTO tcs_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dat wokman uda i bin gad $5,000, em i bin kam ane spik, “Yu bin gibe mi $5,000. Ai bin go meke biznis ane nau ai bin meke nada $5,000 antap.” ");
INSERT INTO tcs_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘So da bos i bin spik po em, “Yu bin meke prapa gudting ane yu prapa sabe po meke ol smol samting kam big. Nau, ai prapa trase yu. Yu go lugaut ol prapa big samting nau blo mi. So nau kam, yumi go meke pisting.” ");
INSERT INTO tcs_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","‘Den da wokman uda i bin gad $2,000, em i bin kam ane spik, “Bos, yu bin gibe mi $2,000. Ai bin go ane meke biznis ane nau ai bin meke nada $2,000 antap.” ");
INSERT INTO tcs_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Den da bos i bin spik dem seimtok po em wanem em bin spik po da pas wokman. ");
INSERT INTO tcs_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","‘So nau da wokman uda i bin gad $1,000, em i bin kam ane spik, “Bos, ai sabe yu prapa adman ane yu ken teke eni gadan kaikai yu wandem prom eniwea, nomata yu no bin meke adwok po plante demting. ");
INSERT INTO tcs_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ai bin prait, daswai ai bin go ane aide mani blo yu insaid lo graun, ane dat mani i ya.” ");
INSERT INTO tcs_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Bat da bos i bin spik, “Yu prapa nugud leizi wokman. Yu bin sabe ai prapa adman ane yu bin prapa tekenotis wei blo mi wanem ai mekem. ");
INSERT INTO tcs_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Mobeta yu bin pute da mani insaid lo baingk so wen ai kambaigen, yu go gibe mi ekstra mani da baingk i go putem insaid.” ");
INSERT INTO tcs_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","‘So da bos i bin spik po dem nada wokman po tekemaut mani prom em ane gibem po da wokman uda i gad $10,000. ");
INSERT INTO tcs_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Enibodi uda i yuze dem samting wanem dempla gad lo gudwei, dempla i go gede nadakain plenti mo dat seim samting. Bat demwan uda i go mata kipe dem samting po demplaselp, dempla i go luze ebriting. ");
INSERT INTO tcs_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Den da bos i bin spik, “Sake dis nugud wokman ausaid lo dak wea dem pipol i krai ane graine tit blo dempla lo pein.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Zizas bin kip tok, ‘Wen da Truwan blo Man i go kam gen lo nadakain brait sainilait ane da paua blo em, ane ebridem einzel blo em i go kam tu lo em, den em i go sidaun king lo dat spesil tron blo em po zaze ebri pipol. ");
INSERT INTO tcs_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ane ebri pipol blo da wold i go stanap de prant lo em. Em go mekem demkain wase da man uda i bos blo dem sip i separeit dem sip prom dem gout. Em go separeit ebri pipol demkain meke tu grup. ");
INSERT INTO tcs_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Em go pute dem nugudwan lo leptansaid blo em ane dem gudwan lo raitansaid blo em. ");
INSERT INTO tcs_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","‘Den em go spik po dempla wea da raitansaid, “Kam, PapaGod blo mi i bin pinis blese yupla. Kam ane stap lo dat ples wea God i ruloba ebribodi wea em i bin pinis mekem de prapa longtaim pas wen em i bin meke da wold. ");
INSERT INTO tcs_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bikoz wen ai bin anggre, yupla bin gibe mi kaikai. Wen ai bin tasti yupla bin gibe mi wata. Ai bin streinza lo kantri blo yupla bat yupla no bin luk mi wansaid. Yupla i bin teke mi go insaid po aus blo yupla. ");
INSERT INTO tcs_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ai bin neket ane yupla i bin gibe mi klos po werem. Ai bin sik ane yupla bin lukapta mi ane wen ai bin insaid zeilaus yupla bin kam ane bizit mi.” ");
INSERT INTO tcs_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","‘Den dem rait ane stret pipol blo God i go ansa, “BosLod, wea mipla bin luk yu anggre ane gibe yu kaikai? Wea mipla bin luk yu tasti ane gibe yu wata? ");
INSERT INTO tcs_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Wea mipla bin luk yu streinza lo kantri blo mipla ane teke yu kam insaid po aus blo mipla? Wea mipla bin luk yu neket ane gibe yu klos po werem? ");
INSERT INTO tcs_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ane wea mipla bin luk yu sik o insaid zeilaus ane bin lukapta yu o bizit yu?” ");
INSERT INTO tcs_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","‘Den da king i go spik po dempla, “Ai spik trutok po yupla, wen yupla i bin meke wok elpe ol nada louklas pamle blo mi, yupla i bin mekem po mi tu!” ");
INSERT INTO tcs_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","‘Den da king i go spik diskain po dem pipol uda i stanap lo leptansaid blo em. “Gowei prom mi. God i go panse yupla. Yupla go ban insaid lo da big paia blo el, dat paia blo el nau wea God i bin mekem po Satana ane ebridem nugudspirit blo em. ");
INSERT INTO tcs_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Bikoz wen ai bin anggre yupla no bin gibe mi kaikai. Ai bin tasti ane yupla no bin gibe mi wata. ");
INSERT INTO tcs_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ai bin streinza lo kantri blo yupla bat yupla bin luk mi wansaid ane yupla no bin teke mi go insaid po aus blo yupla. Ai bin neket ane yupla no bin gibe mi klos po werem. Ai bin sik ane insaid zeilaus ane yupla no bin lugaut mi o kam ane bizit mi.” ");
INSERT INTO tcs_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","‘Den dem pipol i go ansa, “BosLod, wea mipla bin luk yu anggre o tasti? Wea mipla bin luk yu streinza lo kantri blo mipla? Ane wea mipla bin luk yu neket o sik o insaid zeilaus ane no kam elpe yu?” ");
INSERT INTO tcs_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","‘Den da king i go ansa, “Ai spik trutok po yupla, wen yupla no bin elpe eni dem louklas bala ane sisi blo mi ya, wa, dasmin yupla no bin elpe mi tu.” ");
INSERT INTO tcs_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","‘So nau God i go panse dempla poeba. Bat dem rait ane stret pipol blo God i go mata gede longlaip poeba.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Apta wen Zizas i bin pinis yan po dempla ebriting, em bin spik diskain po dem klostuman blo em, ");
INSERT INTO tcs_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","‘Yupla sabe, wea tu deitaim i go gad da Pasoba Pestabol. Lo dat seimdei nau, mi dat Truwan blo Man, ol go sele mi po dem enami blo mi, ane dempla i go neile mi lo kros po ded.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Dat seimtaim nau, dem edprist ane dem nada Zuwiselda i bin gad miting de lo aus blo Kaiapas da bosprist, ");
INSERT INTO tcs_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ane dempla i bin tokbaut wiskain dempla i go paine kuaiatwei po kese Zizas ane kile em. ");
INSERT INTO tcs_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Dempla i bin gri, ‘Yumpla kan meke disting wen i gad da Pasoba Pestabol, bikoz prapa plenti pipol i gobi de, ane yumpla prapa sabe dem pipol i prapa laik Zizas. Ip yumpla i go meke samting po em de, dem pipol i go meke big trabol po yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Zizas ane dem klostuman blo em i bin de lo biliz blo Betani lo aus blo Saiman. Dat man i bin gad nugud skindiziz. ");
INSERT INTO tcs_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wen i bin sapataim dempla i bin kaikai de. Wan oman i bin kare wan prapa plas stonbotol wea i gad prapa dia sentoil insaid ane i gad prapa naissmel. Em bin kam ane sake sentoil antap lo ed blo Zizas wail Zizas i bin kaikai. ");
INSERT INTO tcs_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wen dem klostuman i bin luk wanem dat oman i bin mekem po Zizas, dempla i bin wail po em. Dempla i bin spik, ‘Aukam em bin weiste dia sentoil diskain? ");
INSERT INTO tcs_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Em ken selem ane meke plenti mani ane gibe dem mani po dem poapipol!’ ");
INSERT INTO tcs_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Zizas i bin sabe wanem dempla i bin tingbaut, so em spik, ‘Wanem yupla graule dis oman po? Em i bin meke prapa nais samting ya po mi. ");
INSERT INTO tcs_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Dem poapipol i gobi ebritaim lo yupla, bat ai mata gobi ya lo yupla po sotwail. ");
INSERT INTO tcs_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wanem dis oman ya i bin mekem, sake oil antap lo mi, em bin meke bodi blo mi redi po go greib. ");
INSERT INTO tcs_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ai spik trutok po yupla, ebriwea raun da wold lo ebri kantri wea dempla i go rid da Gudniuz blo mi, wa, dempla i go rid dis stori ya blo dis oman wanem em i bin mekem po mi. Ane dempla i nogo piged em.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Den apta, wan prom dem tuelb klostuman blo Zizas, neim Zudas blo Iskara, i bin go ane tok lo dem edprist, ");
INSERT INTO tcs_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ane aske dempla, ‘Ip ai go sele Zizas po yupla, wanem yupla i go pei mi?’ So dem edprist i bin gibe Zudas tati koin blo silba. ");
INSERT INTO tcs_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Apta nau Zudas i bin weit po da raittaim po sele Zizas po dempla. ");
INSERT INTO tcs_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wen i bin pas dei blo da pestabol wea i kolem diskain, “Bred i nogad yis”, dem klostuman blo Zizas i bin kam ane askem diskain, ‘Wea yu wande mipla po go meke sapa redi blo da Pasoba Pisting?’ ");
INSERT INTO tcs_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Zizas i bin ansa, ‘Yupla go insaid taun, ane de yupla go paine wan man. Yupla spik diskain po em, “Tisa blo mipla, em ya nau ane em bin sane mipla kam po spik yu em wande kaikai da Pasoba Pisting tugeda lo dem klostuman blo em lo aus blo yu.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","So dem klostuman blo Zizas i bin mekem wanem Zizas i bin spik dempla po mekem. Dempla i bin go de ane meke ebriting redi po da sapa blo da Pasoba Pisting. ");
INSERT INTO tcs_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wen i bin klostu po sapataim nau, Zizas ane dem klostuman blo em i bin go sidaun wea da teibol. ");
INSERT INTO tcs_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wail dempla i bin kaikai de, Zizas i bin spik, ‘Ai spik trutok po yupla, i gad sambodi ya midel lo yumpla uda i go sele mi po dem pipol uda go kile mi.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wen dem klostuman i bin lisen wanem Zizas i bin spik, dempla i bin pil nadakain sore po em. So wan wan prom dempla i bin spik diskain baigen po em, ‘BosLod i no mi a?’ ");
INSERT INTO tcs_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Em ansa, ‘Da wan uda go sele mi em i da wan uda i bin soke em kaikai wea boul ya seimtaim wase mi. ");
INSERT INTO tcs_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ai da Truwan blo Man wea God i bin sanem, ai mas ded. Wa, God i bin spik diskain insaid lo Baibol. Bat i gobi prapa nugud po dat man uda i go sele mi, da Truwan blo Man po ded. I bin mobeta po dat man no bin bon!’ ");
INSERT INTO tcs_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Den Zudas i bin spik po Zizas, ‘Tisa, diswan mi a?’ Zizas i bin spik baik po em, ‘Yu ask yuselp!’ ");
INSERT INTO tcs_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wail dempla i bin stil kaikai, Zizas i bin teke sam bred ane eso God po da bred. Den em bin brokem ane gibem po dem klostuman blo em ane spik diskain, ‘Tekem ane kaikai. Diswan i bodi blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Den em bin teke da kap blo wain ane eso God po da kap blo wain, den gibem po dem klostuman blo em ane spik diskain, ‘Dringk lelbet wain ya prom dis kap ebriwan yupla. ");
INSERT INTO tcs_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Diswan blad blo mi wea God i meke niu strong griment bituin em ane prapa nadakain plenti pipol. Ane dis blad i go kapsaid go ausaid po dempla ane go kline dempla prom ol dem nugudwei blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ai spik po yupla tru. Ai nogo dringk diskain wain ya lo yupla gen, antil dat dei wen PapaGod blo mi de antap lo eben i go ruloba ebribodi. Den ai go dringk niu wain lo yupla lo dat niuples.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Apta wen Zizas i bin pinis tok, dempla bin sing da las sing blo da Pasoba Pisting, den dempla i bin go po Maunt Olibtri. ");
INSERT INTO tcs_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Den Zizas i spik po dempla, ‘Wen i go naittaim, yupla i go ranwei prom mi, libe mi maiselp. Baibol i bin spik: “God i go kile da bos blo dem sip, ane dem sip i go ranwei.” ");
INSERT INTO tcs_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bat apta wen ai go gedap laipwan gen, ai go go pas po Galali. Ai go mite yupla de.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Den Pita i spik, ‘Mait ebridem nada klostuman ya blo yu i go ranwei prom yu. Bat no mi. Ai nogo ranwei prom yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Zizas i bin spik baik po Pita, ‘Ai spik trutok po yupla, tunait bipo rusta go ala, yu go spik tri taim, yu no sabe mi.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bat Pita i bin spik baigen po Zizas, ‘Ai prapa nogo spik demkain. Ai go ded tu lo yu!’ Ane dem nada klostuman blo Zizas i bin spik dem seimkain. ");
INSERT INTO tcs_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Den Zizas ane dem klostuman i bin go po Getsemani, wan gadan eria wea i gad ol plenti olibtri. Wen dempla i bin kesem de, Zizas i bin spik, ‘Yupla sidaun ya weit po mi. Ai go go de po prea.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Em bin spik Pita ane demtu boi blo Zebadi, Zemes ane Zon po go lo em. Wen dempla i bin go, Zizas i bin stat pil nadakain nugud ane nadakain sore. ");
INSERT INTO tcs_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Em bin spik po demplatri, ‘Mai at i prapa nadakain ebi ya, ane i pil wase ai go ded. Yupla stap ya ane kip lugaut solong nobodi go kam.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Den em bin wagbaut go lelbet longwei ane poldaun pesdaun lo graun ane prea diskain, ‘PapaGod, yu ken meke ebriting. Plizgar, yu ken tekemaut dis nadakain pein wea i go apen po mi. No lete mi po ded. Bat ai no wande meke ubi blo mi, ai wande meke ubi blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Den wen em bin pinis prom prea, em bin gobaik po demtri ane paine demtri i bin slip. So em bin spik po Pita, ‘Saiman Pita, yu slip a? Aukam yu kan lugaut mi po wan aua? ");
INSERT INTO tcs_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","No slip. Prea po meke at blo yupla strong, solong yupla nogo meke ol nugudting. Spirit blo yupla i wandem, bat bodi blo yupla i slaik!’ ");
INSERT INTO tcs_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Den Zizas i bin libe dempla de, ane gowei gen po prea. ‘PapaGod, plizgar yu ken tekemaut dis nadakain pein wea i go apen po mi. Bat ai no wande meke ubi blo mi bat blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wen Zizas i bin pinis prom prea, em bin kambaik po demtri klostuman blo em ane paine dempla slip gen. ");
INSERT INTO tcs_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","So em i bin libe dempla ane gobaigen po prea. Dis namba tri taim, em i bin prea da seim prea gen. ");
INSERT INTO tcs_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Den em bin gobaik ane weikemap demtri klostuman, ane em bin spik diskain po dempla, ‘Aukam yupla kan stap weik? Yupla tumas slip. Dat taim ya nau, po dat man i go sele mi da Truwan blo man po dem nugudpipol. ");
INSERT INTO tcs_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gedap nau, yumpla mas go. Luk, dat man uda i go sele mi, em ya nau!’ ");
INSERT INTO tcs_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wail Zizas i bin stil tok po dem klostuman de, Zudas dat nada klostuman blo Zizas, i bin kamaut de lo ol bigmob pipol. Dempla i bin kare ol big sod ane big paitingstik. Dem edprist ane dem nada Zuwiselda i bin sane dempla kam. ");
INSERT INTO tcs_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Zudas i bin spik diskain de pas bipo dempla i bin kam de, ‘Da man uda ai go kisem, em nau i Zizas. Yupla kese em.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","So wen dempla i bin kam de Zudas i bin wagbaut go stret po Zizas ane spik diskain, ‘Alo Tisa!’ Den em bin kis Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Zizas i bin spik po Zudas, ‘Mai pren, mata meke datting wea yu bin kam po mekem.’ Den dem man i bin kese Zizas ane tekem go po kot. ");
INSERT INTO tcs_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wen dempla i bin kese Zizas wan klostuman blo Zizas i bin tekemaut em sod ane kate talinga blo da sebant blo da bosprist. ");
INSERT INTO tcs_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Zizas i bin spik po da klostuman uda i bin kate talinga, ‘Pute da sod baik. Demwan uda i yuze sod po pait, demwan i go ded prom dem pait. ");
INSERT INTO tcs_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ane ip ai wandem, ai ken spik po mai PapaGod de antap lo eben po sane tauzen tauzen blo einzel kam po elpe mi ane dempla go stretwei kam. ");
INSERT INTO tcs_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bat Baibol i bin spik ol demting ya i mas apen diskain.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Den Zizas i bin spik po dem bigmob pipol diskain, ‘Yupla kam po kese mi, kare ol sod ane big paitingstik wase ai bin kile man. Ebridei ai bin de lo da Tempol tise ol pipol de. Aukam yupla no bin kese mi de? ");
INSERT INTO tcs_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bat disting mas apen po prube dem tok blo dem spesilmesizman blo God, wea ol i bin raitem insaid lo Baibol.’ Den ebridem klostuman blo Zizas i bin ranwei prom em, libe em. ");
INSERT INTO tcs_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Den dempla i bin teke Zizas go de po aus blo Kaiapas, da bosprist. Dem Zuwislotisa ane dem nada Zuwiselda i bin de tu. ");
INSERT INTO tcs_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pita i bin pole Zizas longwei biain. Em bin go insaid da yad blo da aus blo Kaiapas. Em bin sidaun de ausaid lo dem amiman po luk wanem dempla i go mekem po Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Insaid lo dat aus, dem edprist ane ebridem memba blo da Zuwiskaunsil i bin kuestin Zizas po paindaut wanem rongting em bin mekem, solong dempla i go kile em. ");
INSERT INTO tcs_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Plenti pipol i bin kam ane tok laiwan baut em, bat dem edprist ane da Zuwiskaunsil i no bin lisen nating wea i bin rong lo em. Den, tu man i bin kam de ");
INSERT INTO tcs_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ane spik, ‘Mitu i bin lisen dis man tok diskain, “Ai ken broke da Tempol blo God ane mekem gen lo tri deitaim.” ’ ");
INSERT INTO tcs_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Den da bosprist i bin gedap ane spik po Zizas diskain, ‘Ei yu! Yu go ansa dem tok gense yu? Wanem dis stori dem man ya i spik gense yu?’ ");
INSERT INTO tcs_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bat Zizas i bin spik nating. Den da bosprist i bin spik po em, ‘Mata wanwei ai ken meke yu po tok. Ai spik yu lo neim blo God, spik po mipla uda yu! Spik po mipla ip yu dat Promiswan uda God i go sanem, da Boi blo God?’ ");
INSERT INTO tcs_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Zizas i bin ansa dempla diskain, ‘Das wanem yu yuselp bin spik! Bambai yupla i go luk, mi da Truwan blo Man i go sidaun wea dat ples blo ona, wea raitansaid blo God ane yupla go luk mi kambaigen daun prom God antap wea ol klaud blo eben.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wen da bosprist i bin lisen wanem Zizas i bin spik em bin nadakain wail, ane tere klos blo em. Em bin singaut laudwan, ‘Yupla lisen a? Dis man i bin tok ol badtok gense God ya! Yumpla no nide mo witnis! Yupla i bin lisen wiskain em tok ane em i meke emselp wase God.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Den em bin spik po da Zuwiskaunsil, ‘Wiswei? Wanem yupla tingk?’ Dempla i singaut, ‘Mipla i bin paine em rong! Em mas ded!’ ");
INSERT INTO tcs_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Den dem pipol i bin paite Zizas lo an blo dempla, ane spet lo pes blo em ane sam i bin slape em ");
INSERT INTO tcs_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ane spik, ‘Ip yu da Promiswan uda God i go sanem kam, wel spik po mipla uda i bin paite yu?’ ");
INSERT INTO tcs_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Seimtaim nau, Pita i bin de sidaun insaid wea da yad. Wan gel sebant blo da bosprist i bin kam de po em ane spik po em diskain, ‘Yu bin pole Zizas tu, dat man prom Galali?’ ");
INSERT INTO tcs_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bat Pita i bin spik laiwan prant lo dem pipol diskain, ‘Ai no sabe wanem yu tokbaut.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Den Pita i bin stanap ane wagbaut go po da geit. Wen em bin kese da geit, nada gel sebant blo da bosprist i bin luk em ane spik po ebridem man de diskain, ‘Ai bin luk yu pole Zizas, dis Nazaretman.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita i bin wail nau, ane em bin spik, ‘Ai ya spik yupla tru, ai no sabe da man!’ ");
INSERT INTO tcs_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Apta, sam dem man i bin kam po Pita ane spik, ‘Ei yu! I tru. Yu klostuman blo Zizas bikoz bois blo yu saun wase man prom Galali.’ ");
INSERT INTO tcs_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita i bin spik, ‘Ai spik yu, tru God, ai no sabe dis man!’ Stretwei wen Pita i bin spik diskain, rusta i bin ala. ");
INSERT INTO tcs_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Pita i bin stretwei tingbaut po dat tok wea Zizas i bin spik po em, ‘Bipo rusta i go ala, yu go spik tri taim diskain yu no sabe mi.’ Pita bin nadakain sore ane em bin gowei prom de ane base nadakain bigkrai. ");
INSERT INTO tcs_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Elimoning neksdei, dem edprist ane ebridem Zuwiselda i bin kam tugeda po tokbaut wiskain dempla i go meke gabana prom Rom po gibe oda po kile Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","So dempla i bin taiemape Zizas ane tekem go po gabana prom Rom neim Pailat. ");
INSERT INTO tcs_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wen Zudas i bin luk dempla i go kile Zizas, em bin pil nadakain sore nau po Zizas bikoz em i bin da wan uda i bin sele Zizas po dempla. Em i bin seinze main blo em ane teke dem mani gobaik po dem edprist ane dem Zuwiselda. ");
INSERT INTO tcs_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Em tok, ‘Ai bin meke prapa nugudting. Ai bin sele dat man uda bin meke nating rong po yupla, ane nau yupla go kilem.’ Bat dempla i bin spik baik po em, ‘Aukam yu bin kam ya ane spik diskain yu bin meke nugudting? Datwan biznis blo yu, i no biznis blo mipla.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","So Zudas i bin mata sake da mani godaun de wea da Tempol, ane em bin gowei prom de ane ainge emselp. ");
INSERT INTO tcs_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Dem edprist i bin pikemap dem mani ane spik, ‘Lo blo yumpla i spik, yumpla no lau po pute diskain mani lo dem nada mani ya blo dis Tempol, bikoz dis mani i bin pei po man po ded.’ So dempla i bin tok po wananada wanem dempla i go mekem lo dat mani. ");
INSERT INTO tcs_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","So dempla i bin gri po baie lan, wea graun blo em i mata klei, ane lan blo klei, dempla i go yuzem po enibodi uda i kam po bizit Zarusalem ane ded de. Diswan i gobi sematri po dem bizita. ");
INSERT INTO tcs_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Prom de raitap kam po tidei, dempla stil kolem Yad blo Blad. ");
INSERT INTO tcs_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Dis seimting nau wanem Zeramaia, da spesilmesizman blo God i bin spik lo Baibol: ‘Dem pipol blo Izrael i bin pute prais lo em, ane dat prais i bin tati silba koin. ");
INSERT INTO tcs_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Den apta dempla i bin teke da mani, ane baie dat lan blo klei, seimkain po wiskain da AntapGod i bin spik po mi.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dempla i bin teke Zizas, mekem stanap prant lo Pailat, ane Pailat i bin spik, ‘Yu spik po mi nau. Yu king blo dem Zuwispipol a?’ Zizas i bin ansa, ‘Das wanem yu yuselp bin spik.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wen dem edprist ane dem Zuwiselda i bin lisen wanem Zizas i bin spik, dempla i bin spoile em olkain, bat Zizas no bin ansa dempla baigen. Em bin stap kuaiat. ");
INSERT INTO tcs_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Den Pailat i bin spik po Zizas gen, ‘Yu bin lisen wanem dem pipol ya i bin spikbaut yu a?’ ");
INSERT INTO tcs_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bat Zizas stil no bin tok, em no bin ansa Pailat. Pailat i bin prapa atzamp aukam Zizas i no bin ansa. ");
INSERT INTO tcs_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wel ebri iya, dempla meke da Pasoba Pestabol. Wen taim blo Pasoba i kam, da gabana ebritaim lete wan prizina go pri prom zeilaus. Bat ebritaim i no gabana uda i suzem, i dem pipol uda i suzem. ");
INSERT INTO tcs_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Dat seimtaim nau, i bin gad wan prizina, neim blo em i bin Barabas, ane em bin prapa nugudman. ");
INSERT INTO tcs_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Wen dempla i bin de nau lo aus blo Pailat, Pailat i bin aske dempla, ‘Uda prom dis tu prizina ya ai go letem go pri, Barabas o Zizas da Promiswan uda God i go sanem kam?’ ");
INSERT INTO tcs_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Wel Pailat i bin sabe dem edprist ane dem lida blo dem Zuwislotisa i bin zeles Zizas, daswai dempla i bin andemoba po em. ");
INSERT INTO tcs_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wail Pailat i bin sidaun de tok po dempla, oman blo em i bin sane mesiz kam po em, ane da mesiz i bin spik, ‘Yu no zaze dat gudman bikoz ai bin gad nugud drim baut em lasnait, ane ai pil nadakain sore po em.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bat dem edprist ane dem Zuwiselda i bin spik po dem pipol de po spik Pailat po lete Barabas go pri, ane kile Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","So wen Pailat i bin aske dempla gen, ‘Uda prom demtu yupla wande ai go letem go pri?’ Dempla i bin ala, ‘Barabas!’ ");
INSERT INTO tcs_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Den Pailat i bin spik, ‘Ip ai go lete Barabas go pri, den wanem ai go mekem lo Zizas da Promiswan?’ Ane dempla i bin ala, ‘Kilem, kilem lo kros po ded!’ ");
INSERT INTO tcs_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Den Pailat i bin singaut, ‘Wanem po? Wanem rongting em bin mekem?’ Bat ebridem pipol i bin ala molaud diskain, ‘Kilem, kilem lo kros po ded!’ ");
INSERT INTO tcs_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","So Pailat i bin tingbaut nau. Em bin spik po emselp, ‘Ip ai go lete dis man go pri, mait dem pipol i go state big trabol.’ So em bin spik po teke boul blo wata kam, ane em bin wase an blo em pinis. Den em bin spik po ebridem pipol diskain, ‘Ai no bin wande dis man po ded, bat yupla i bin wandem, so no bleime mi po ded blo dis man. Bleime yuplaselp, bikoz yupla wande em po ded.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dempla i bin ala baik po Pailat diskain, ‘Wa, mipla ane ebridem pikinini blo mipla i go teke ebridem bleim po ded blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","So Pailat i bin lete Barabas go pri po dem pipol, den em bin gibe oda po dem amiman blo em po ploke Zizas lo wip. Den em bin gibe Zizas go po dem Romamiman po neilem lo kros. ");
INSERT INTO tcs_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Prom de, dem amiman blo Pailat i bin teke Zizas go po amibarik blo dempla. Ane ol dem nada amiman bin kamaut ane stanap raitraun lo em. ");
INSERT INTO tcs_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Dempla i bin tekemaut klos blo em ane were red roub lo em. ");
INSERT INTO tcs_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Dempla i bin meke kraun prom tonibus ane putem raun lo ed blo em, ane gibe em stik lo raitan blo em wase king. Den dempla i bin nildaun prant lo em ane daunem diskain, ‘Mipla grite yu, bigbos yu, king blo ol Zuwispipol!’ ");
INSERT INTO tcs_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Dempla i bin spet lo em, ane tekemaut stik prom em, ane plokem lo ed lo dat stik. ");
INSERT INTO tcs_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Apta wen dempla i bin pinis prom daunem, dempla i bin tekemaut dat roub prom em ane were klos blo em baik lo em. Den dempla i bin tekem go po neilem lo da kros po ded. ");
INSERT INTO tcs_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wen dempla i bin go midel lo rod go po neile Zizas lo da kros, dempla i bin paine wan man de apwei. Neim blo em i bin Saiman ane em bin kam prom siti blo Sairini de wea Aprika. So dempla i bin meke em po kare da kros blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Dempla i bin teke Zizas go ausaid da siti po dat ples neim Golgota (i min ‘Skal Il’). ");
INSERT INTO tcs_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Wen dempla i bin kesem de, dem amiman i bin gibe em wain i bin miksem lo prapa strong mersin wea em i kan pile pein. Bat wen em i bin tesem, em no bin wande dringkem. ");
INSERT INTO tcs_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Den dempla i bin neilem po da kros. Apta wen dem amiman i bin neilem po da kros, dempla i bin plei dais po uda go wine dem klos blo em. ");
INSERT INTO tcs_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Den dempla i bin sidaun ane gadem wail em bin aing de lo da kros. ");
INSERT INTO tcs_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ane i bin gad wan notisbod i gad raiting. Dempla i bin neilem wea da kros, stret antap lo ed blo Zizas, ane i spik diskain: ‘Diswan Zizas uda i king blo ol Zuwispipol ");
INSERT INTO tcs_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Dem amiman i bin neile tu man uda bin broke da lo wea tu kros de wea em, wan lo raitansaid blo Zizas ane nadawan lo leptansaid. ");
INSERT INTO tcs_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bigmob pipol i bin wagbaut pas ane dempla i bin ala ane daune em ane seike ed blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","‘Yu bin spik diskain, yu ken broke da Tempol ane bildem gen lo tri deitaim. Wel, ip yu spik yu Boi blo God, wel kamdaun prom da kros ane seibe yuselp.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Dem edprist, dem Zuwislotisa ane dem nada Zuwislida i bin daune Zizas tu. Dempla i bin lap em, ");
INSERT INTO tcs_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","‘Em bin seibe ol nada pipol, bat em kan seibe emselp! Em spik em i king blo ol Zuwispipol! Letem kamdaun prom da kros den yumpla i go bilibe em! ");
INSERT INTO tcs_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Em i trase God, ane em spik em i Boi blo God. Wel, yumpla go luk ip God i go seibem.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ane da tu nugudman i bin spik nugudting po Zizas tu. ");
INSERT INTO tcs_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wen i bin kese tuelb aklok aptanun taim, da skai i bin kam dak. I bin dak prom tuelb aklok go kese tri aklok. ");
INSERT INTO tcs_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wen i bin kese tri aklok, Zizas i bin ala diskain lo langus blo em, ‘Eli, Eli, lema sabaktani?’ I min diskain ya, ‘Mai God, mai God, aukam yu bin libe mi?’ ");
INSERT INTO tcs_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sam pipol uda i bin stanap de, dempla i bin lisen rongwei. Dempla tot Zizas i bin ala po Ilaiza da spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Stretwei wan prom dempla i bin ran ane teke ripspanz, taitem lo stik, den sokem insaid lo saua wain ane putem go antap po Zizas po dringk. ");
INSERT INTO tcs_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bat dem nada pipol i bin spik diskain, ‘Libe em. Yumpla go luk ip Ilaiza i go kam ane seibe em.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Den Zizas i bin ala gen, den em nomo bin ole win. ");
INSERT INTO tcs_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Dat seimtaim wen Zizas i bin ded, da nadakain bigblain insaid lo da Tempol i bin brok rait midel, go prom antap raittru godaun. I bin gad ertseik ane ol ston i bin brok midel. ");
INSERT INTO tcs_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ol greib blo ol pipol uda i bin bilib lo God, man ane oman uda i bin ded, i bin open, ane dempla i bin gedap laipwan gen. ");
INSERT INTO tcs_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Den apta wen Zizas i bin gedap laipwan gen, dem pipol i bin kamaut prom sematri blo dempla ane ol i bin go po siti blo Zarusalem ane soe demplaselp po ebribodi de. ");
INSERT INTO tcs_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Da sekan amiopisa blo Rom ane dem amiman uda i bin gade Zizas, dempla i bin pile dat ertseik ane dempla i bin luk ebriting wanem i bin apen. Dempla i bin spik, ‘Wa, dis man i prapa tru Boi blo God!’ ");
INSERT INTO tcs_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Plenti oman prom Galali i bin kam tu lo Zizas po lugaut em. Dempla i bin de stanap lelbet longwei, wase em. ");
INSERT INTO tcs_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Midel lo dempla i bin gad Meri Magdala, Meri uda i mama blo Zemes ane Zosep, ane oman blo Zebadi uda i mama blo Zemes ane Zon. ");
INSERT INTO tcs_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Zosep i bin wan risman prom Aramatia. Em bin wan dem biliba blo Zizas tu. Wen i bin kam klostu po dak, ");
INSERT INTO tcs_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Zosep i bin go ane aske Pailat po bodi blo Zizas. So Pailat i bin gibe oda po dempla po lete em po teke da bodi. ");
INSERT INTO tcs_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Den Zosep i bin teke bodi blo Zizas kamdaun prom da kros ane rapem lo wan prapa long gudkaliko. ");
INSERT INTO tcs_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Den em bin pute bodi blo Zizas insaid lo wan keib wea i bin kabem prom ston. Den em bin role wan big ston prant lo dat keib ane em bin gowei prom de. ");
INSERT INTO tcs_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Meri Magdala ane nada Meri i bin de sidaun klostu wase da keib wea Zosep i bin pute bodi blo Zizas insaid. ");
INSERT INTO tcs_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Neksdei nau i bin Zuwis Sabatdei, ane dem edprist ane dem Parasi i bin go po luk Pailat, ");
INSERT INTO tcs_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ane dempla i bin spik diskain po em, ‘Bos, mipla bin tingbaut wanem dat laiman Zizas i bin spik wen em bin stil laip. Em bin spik diskain ya, “Lo namba tri dei, ai go gedap laipwan gen prom ded.” ");
INSERT INTO tcs_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","So mipla aske yu, ip yu ken sane sam amiman blo yu go po gade dat keib po tri dei, bikoz mait dem klostuman blo Zizas i go kam ane stile bodi blo em ane go laiwan spik ol pipol, em bin gedap laipwan gen. Ip ol go mekem diskain, wel, dis lai i gobi monugud, monugud nau den dat pas lai wanem Zizas i bin spik.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Den Pailat i bin spik, ‘Orait. Yupla teke sam amiman go ane meke dempla po prapa gade da keib.’ ");
INSERT INTO tcs_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","So dem edprist ane dem Parasi bin go wea dem amiman. Dem amiman i bin pute mak blo da gabana wea da doa po silem. Den dempla i bin libe dem amiman de po gade da keib. ");
INSERT INTO tcs_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Dat Zuwis Sabatdei i bin pinis nau. Prapa elimoning neksdei, Sandei, Meri Magdala ane nada Meri i bin go ausaid po luk da keib. ");
INSERT INTO tcs_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","I bin gad nadakain big ertseik. Wan einzel blo God i bin kamdaun prom eben ane role ston prom dat doa go wansaid ane em bin sidaun de antap lo dat ston. ");
INSERT INTO tcs_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Dat einzel i bin nadakain saini braitwait wase laitning, ane dem klos blo em i bin nadakain wait. ");
INSERT INTO tcs_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wen dem amiman uda i bin gade da keib i bin luk em, dempla i bin nadakain seik prom prait ane dempla i bin poldaun blaikaut. ");
INSERT INTO tcs_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Den dat einzel i bin spik po dat tu oman, ‘Yutu no prait. Ai sabe yutu bin kam po luk Zizas uda i bin ded lo kros. ");
INSERT INTO tcs_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Em no ya! Em bin gedap laipwan gen, seimkain wanem em bin spik i go apen. Kam, luk da ples wea bodi blo em i bin leidaun. ");
INSERT INTO tcs_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","So yutu ariap go nau ane spik po dem klostuman blo em, em bin gedap laipwan gen, ane em de go po Galali. Go de ane yupla i go lukem de. Ai bin kam po spik yutu po spik dempla dis seimtok ya nau.’ ");
INSERT INTO tcs_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Demtu oman i bin wantaim prait ane nadakain api tu. Demtu i bin stretwei ran kuikwan gobaik po spik dem klostuman blo Zizas wanem dat einzel i bin spik po demtu. ");
INSERT INTO tcs_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wen demtu i bin ran go apwei lo rod, Zizas i bin mite demtu de ane spik po demtu, ‘Wiswei!’ Demtu i bin ran go po em ane poldaun prant lo em godaun, kese leg blo em ane wosip em. ");
INSERT INTO tcs_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Den Zizas i bin spik, ‘No prait! Yutu go ane spik po dem gudpren blo mi diskain, dempla mas go po Galali, ane dempla i go luk mi de.’ ");
INSERT INTO tcs_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Apta wen demtu i bin gobaik lo wei blo demtu, sam dem amiman uda i bin gade da keib i bin gobaik po siti ane spik po dem edprist ebriting wanem i bin apen de. ");
INSERT INTO tcs_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","So dem edprist ane dem Zuwiselda i bin gad miting po paine wei po meke dem amiman no po spik ol pipol wanem i bin apen de. So dempla i bin gibe dem amiman plenti mani po swite dempla po meke laiwan. ");
INSERT INTO tcs_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Dempla i bin spik po dem amiman, ‘Yupla mas spik diskain po dem pipol, “Wen mipla i bin slip, dem klostuman blo Zizas i bin kam ane teke bodi blo em.” ");
INSERT INTO tcs_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Bat no wori, mipla i go tok po gabana ip em go paindaut. Mipla go meke ebriting stret po yupla.’ ");
INSERT INTO tcs_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","So dem amiman i bin teke da mani ane spik dem pipol baut dat laistori, ane dat laistori i bin go ebriwea lo kantri blo dem Zuwispipol. Stil tidei dem Zuwispipol i stil tingk dem klostuman blo Zizas i bin teke bodi blo em. ");
INSERT INTO tcs_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Den dem leben klostuman blo Zizas i bin tekop go po dat maunten de lo Galali wea Zizas i bin spik dempla po go. ");
INSERT INTO tcs_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","De nau, dempla i bin luk em de, ane nomata sam dempla i no bin gad prapa strong bilib, bat dempla ebriwan i bin nildaun ane wosip em! ");
INSERT INTO tcs_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Den Zizas i bin kam ane spik po dempla, ‘PapaGod blo mi i bin gibe mi da rait po kare ebri lo blo eben ane ert. ");
INSERT INTO tcs_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ai spik po yupla nau, go po ebri kantri ane meke dempla kam klostuman blo mi. Baptaiz dempla lo neim blo God da PapaGod, ane da Boi ane da OliSpirit. ");
INSERT INTO tcs_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tise dempla ebriting wanem ai bin soe yupla, po pole ebridem lo ai bin gibe yupla. Ai gobi lo yupla ebritaim antil da taim blo dis wold i go pinis.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ai go spik po yupla trutok. Dis stori i Gudniuz baut Zizas Kraist da Promiswan, da Boi blo God. Diswan i stat blo da stori. ");
INSERT INTO tcs_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aizaia, em i wan spesilmesizman blo God. Em bin raite dis tok ya wanem God i bin spik: ‘Bambai ai go sane man po teke niuz blo mi po yupla. Ai go sane mesizman go pas bipo da BosLod go kam. Dem tok em go spik i go meke da wei redi po da BosLod, wase man i meke rod redi po wagbaut. ");
INSERT INTO tcs_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","I gad sambodi de ala lo ples wea i nogad man. “Meke da wei redi po da AntapGod. Meke da wei stret po em po wagbaut!” ’ ");
INSERT INTO tcs_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Orait. So dat mesizman blo God i bin kam. Neim blo em Zon. Zon bin go de wea da dezetples wea i nogad no man. Em i baptaiz ol man ane em i spik po dempla diskain, ‘Yupla mas libe ol dem nugudwei ane yupla mas baptaiz sole God go pogibe yupla po ol dem nugudting yupla bin mekem.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ebri pipol prom Zarusalem ane ol dem smolsmol taun blo Zudia i bin kam de klostu po lisen wanem Zon i tok. Demwan uda bin lisen, ol bin konpes po God baut ol dem nugudting dempla bin mekem. Ane Zon i bin baptaiz dempla wea Zodan Riba. ");
INSERT INTO tcs_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Dem klos blo Zon, em bin mekem prom eya blo kamal ane em bin were leda belt ane em bin kaikai grasopa ane bus ani. ");
INSERT INTO tcs_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Em bin spik po dempla diskain, ‘Da man uda go kam biain wea mi, em i mo bigman wea mi. Ai no gudnap po tekemaute sandol blo em. Ai kasaman.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Zon i bin spik gen diskain, ‘Ai baptaiz yupla wea wata, bat dat man i go baptaiz yupla wea da OliSpirit.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Da seimtaim nau Zizas i bin kam prom Nazaret, wan taun wea Galali. Wen Zizas bin kam po Zon, em bin baptaiz Zizas de wea Zodan Riba. ");
INSERT INTO tcs_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wen Zizas bin kamaut prom da wata em bin luk go antap, da skai i bin open ane da OliSpirit i bin kamdaun lo em wase dab. ");
INSERT INTO tcs_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ane em lisen bois blo God i bin tok po em diskain. Em spik, ‘Yu prapa boi blo mi ane ai prapa wande yu. Ai prapa api wanem yu mekem.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wen God i bin pinis spik, stretwei nau da OliSpirit bin meke Zizas po go po dezetples. ");
INSERT INTO tcs_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Zizas i bin de poti dei ane Satana i bin trai po tempte em. Ane ol einzel blo God bin kam de po elpe em. I bin gad ol wailanimal de tu. ");
INSERT INTO tcs_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Den King Erod bin spik ol amiman blo em po kese Zon. So dempla bin kese em, putem insaid zeilaus. Apta nau, Zizas bin go po prise da Gudniuz baut God de wea Galali. ");
INSERT INTO tcs_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Zizas i bin spik po dempla diskain ya, ‘Da taim i kam klostu nau, ebriwan go sabe God i go ruloba ebriwan. Ane yupla mas libe ol dem nugudwei blo yupla ane bilib da Gudniuz.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wen Zizas i bin wagbaut longsaid wea Leik Galali, em bin luk tu pisaman, Saiman ane Andru, demtu tu bala. Demtu bin sake net de. ");
INSERT INTO tcs_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Zizas bin go longsaid demtu ane spik po demtu diskain, ‘Pole mi. Ip yutu pole mi nau ai go lane yutu po kese pipol po God.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Stretwei demtu bin libe net ane pole em go. ");
INSERT INTO tcs_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Em wagbaut go lelbet mo ane em luk tu boi blo Zebadi, Zemes ane Zon. Demtu insaid lo bot blo demtu meke net redi po sakem gen. ");
INSERT INTO tcs_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Stretwei Zizas singaut po Zemes ane Zon diskain, ‘Ei, yutu! Kam ane pole mi.’ Demtu wantaim libe ebriting biain, libe Zebadi, papa blo demtu, ol wokman blo demtu de lo bot ane demtu wantaim go wea Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Orait nau. Zizas ane dem klostuman blo em i bin go po Kapaniam. Zuwis Sabatdei bin kam ane dempla bin go insaid lo da zuwispreaus ane Zizas bin stat po tise ebriwan de. ");
INSERT INTO tcs_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Dempla uda bin lisen bin atzamp prom wanem Zizas bin tok. Dempla bin spik, ‘Ei! Zizas, em no wase dem Zuwislotisa. Wa, tok blo em i kare lo, i gad paua prapa moden dem Zuwislotisa.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Stretwei, de insaid dat zuwispreaus, wan nugudspirit uda bin stap insaid wan man de i bin singaut po Zizas diskain, ");
INSERT INTO tcs_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","‘Zizas, yu Nazaretman. Wanem yu wandem wea mipla? Mipla sabe uda yu. Yu da Oliwan blo God. Ei! Yu bin kam po tere mipla, a?’ ");
INSERT INTO tcs_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Zizas i bin spik po dat nugudspirit, adwan. ‘Stap! Nomo tok! Ane kamaut prom dat man.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nau da nugudspirit i bin ala, laudwan. Em bin seike da bodi blo da man, nadakain ad. Den da spirit i bin kamaut prom da man. ");
INSERT INTO tcs_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ol dem pipol uda bin de wea dat zuwispreaus ol bin nadakain atzamp. Dempla i bin stat spik po wananada, ‘Ei lugaut! Wanem diswan? Diswan pastaim mipla bin lisen diskain tok. Dis man i gad paua orait, wen em tok. Wen em i spik po da spirit “kamaut”, da spirit i kamaut.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","I no bin teke long ane ebri dem pipol wea Galali ol bin lisen wanem Zizas i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Orait nau. Zizas ane dem klostuman blo em i bin libe dat ples ane ol bin stretwei lego go po aus blo Saiman ane Andru. Zemes ane Zon i bin wea dempla tu. ");
INSERT INTO tcs_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Stretwei wen ol bin kese dat aus, dempla bin spik po Zizas diskain, ‘Mama blo oman blo Saiman, em mata leidaun wea bed. Em gad piba.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","So Zizas i bin go po em, kese an blo em ane elpe em po sidaun. Stretwei da piba bin pinis, ane da oman bin go ane redi kaikai po dempla. ");
INSERT INTO tcs_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wen san bin godaun i naittaim nau. Ol pipol de lo dat biliz blo Kapaniam, i bin kam po luk Zizas. Ol bin teke ol dem sikpipol kam ane ol dem pipol uda gad ol nugudspirit wea dempla. ");
INSERT INTO tcs_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ebri pipol blo dat biliz bin de stanap ausaid lo dat aus ane luk go insaid da aus. ");
INSERT INTO tcs_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Zizas i bin meke plenti pipol orait prom olkain dipren sik ane em bin tekemaut ol dem nugudspirit prom dempla. Dem nugudspirit bin sabe uda Zizas, so daswai Zizas i bin stape dempla prom tok. ");
INSERT INTO tcs_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Orait. Prapa elimoning, Zizas bin gidap bipo san bin kamap. Apta em bin libe dat aus em bin go ausaid prom da taun. Em bin go luk po kuaiatples po prea. ");
INSERT INTO tcs_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Apta nau, Saiman ane ol met blo em bin gidap. Ol i bin luk Zizas i no de. So dempla bin tekop go, lukraun po em. ");
INSERT INTO tcs_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wen dempla bin paine em, dempla bin spik po em, ‘Ol pipol i lukraun po yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Bat Zizas i spik, ‘Wa, ai sabe. Bat yumpla mas go po dem nada biliz ya raun so ai go pris po dempla de tu. Daswai ai bin kam.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","So Zizas bin goraun wea Galali. Em bin pris insaid wea ol dem zuwispreaus ane em bin tekemaut ol nugudspirit prom dem pipol de. ");
INSERT INTO tcs_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wantaim, wan man i bin kam ane poldaun prant wea Zizas. Em bin gad plenti nugud skindiziz ebriwea wea skin blo em. Em bin aske Zizas po elpe em. Em bin spik po Zizas, ‘Ai sabe yu ken meke mi orait.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Zizas sore bin kamap. Em pute an blo em ane tase dat man. Em spik, ‘Ai wandem. Yu gobi orait nau.’ ");
INSERT INTO tcs_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wantaim dat nugud skindiziz bin pinis ane da man bin stretwei orait. ");
INSERT INTO tcs_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Den Zizas i spik po em prapa strong, ‘Ei! No spik nobodi baut wanem bin apen. Yu mata go stret po luk da prist. Spik em po luk yu ip yu gad gudskin. Bikoz God bin ile yu, yu mas teke opring go wea yu wase Mozeslo i spik. Tekem ane gibem po da prist. Diswan po prubem po ebriwan yu orait.’ So stretwei Zizas i bin sane em go po luk da prist. ");
INSERT INTO tcs_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bat da man no bin lisen. Em bin go ane tok ebriwea baut wanem Zizas bin mekem po em. So i bin kam prapa ad po Zizas po go insaid wea dem taun prom tumas tok blo da man. Zizas i bin mata stap ausaid prom dem taun lo dem ples wea i nogad no man ane ol pipol bin go po luk em de. ");
INSERT INTO tcs_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Piudei apta, Zizas bin gobaigen po Kapaniam ane ebriwan wea da taun bin lisen niuz dat em bin kambaigen. ");
INSERT INTO tcs_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Dat aus wea Zizas bin stap i bin gad tumas pipol, kan pit enimo pipol insaid. Ane i bin gad plenti pipol raitraun wea dat aus. Zizas bin tise dem wod blo God po dempla. ");
INSERT INTO tcs_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Orait. Po man bin kare wan paralaizman kam wea mat wase stresa. ");
INSERT INTO tcs_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Dempla bin teke da man po go insaid po putem prant wea Zizas, bat i bin gad plenti pipol. So dempla bin go antap wea da rup ane dempla bin meke oll wea da rup, stret antap wea Zizas i bin stanap. Dempla bin taite rop wea da mat den ol bin slaike da mat godaun prant wea Zizas, wea em bin stanap. ");
INSERT INTO tcs_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wen Zizas bin luk dat bilib blo dempla, em bin spik po da paralaizman, ‘Mai boi, ai tekemaut ol dem nugudwei blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","I bin gad sam Zuwislotisa uda bin sidaun de, ane ol bin smolsmoltok diskain, ");
INSERT INTO tcs_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Uda dis man? Em spik badtok gense God. Wen em tekemaut sin em i meke emselp wase God. Mata God ken tekemaut sin.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Bat Zizas sabe wanem dempla bin tingbaut, so em bin spik stret po dempla, ‘Ei, lugaut! Ai sabe wanem yupla tingbaut. ");
INSERT INTO tcs_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wanem yupla tingk kai? I moizi po spik po dis man diskain, “Yu nogad no sin nau” o po spik po em, “Gedap ane wagbaut?” ");
INSERT INTO tcs_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ai go soe yupla! Ai wande yupla po sabe diswan. Ai da Truwan blo Man, ai kare lo ya wea ert po tekemaut sin.’ Den Zizas bin slu po da paralaizman ane spik, ");
INSERT INTO tcs_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","‘Gedap, rolemap mat blo yu ane go aus. Ai bin meke yu gud.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Da man bin stanap prant wea dempla, rolemap mat blo em ane wagbaut go tru da bigmob pipol. Wen dempla bin luk, ol bin nadakain seik. Ebribodi bin preize God ane dempla bin spik, “Prapa gudting bin apen ya. Ol no bin luk diskainting apen bipo.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Den Zizas i bin godaun po edz blo da leik gen. Nau ol bigmob pipol bin kam po em po lisen po Zizas ane em bin lane dempla. ");
INSERT INTO tcs_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wail em wagbaut go, em bin luk wan taksman. Neim blo em Libai. Libai em i boi blo Alpias. Em sidaun wea taksopis blo em. Zizas bin spik po em, ‘Ei yu! Yu kam ane pole mi.’ Libai bin gedap, libe ebriting ane em bin pole Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dat seim nait Libai bin meke big kaikai po Zizas ane ol klostuman blo em, po dem nada taksman ane ol dem nada nugudpipol uda bin pole Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sam dem Zuwislotisa uda bin Parasi i bin de. Wen dempla bin luk dem pipol kaikai wea Zizas, dempla bin spik po dem klostuman blo Zizas, ‘Ei! Aukam Zizas i kaikai ane dringk melen wea ol taksman ane ol dem nada man? Dempla ol nugudman!’ ");
INSERT INTO tcs_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Wen Zizas bin lisen dempla tok diskain, em ansa dempla, ‘Ol sikpipol nide dokta, no dem strong eltiwan. Ai no bin kam po spik ol demwan uda tingk dempla rait ane stret, po seinze wei blo dempla. Ai bin kam po spik ol demwan uda sabe dempla nugud, po seinze nugudwei blo dempla.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wantaim dem klostuman blo Zon Baptaizman ane dem Parasi ol bin pasting. Sam pipol i bin kam po Zizas ane aske em diskain, ‘Ol dem klostuman blo Zon Baptaizman ane dem klostuman blo dem Parasi, plentitaim dempla pasting. Bat wiswei ol klostuman blo yu? Dempla no pasting.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","So Zizas bin aske dempla, ‘Wiswei yupla tingk? Yupla ken meke ol weding gest no kaikai wen da man uda go maret em stil de melen wea dempla? Nono! Yupla kan. ");
INSERT INTO tcs_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Da taim go kam wen da man uda bin maret, em go libe dempla olgeda. Datwan da taim nau wen dempla nogo kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Nobodi teke niu kaliko po pasem wea oul kaliko. Da niu kaliko i go strese dat oul kaliko ane spoilem ane dat oll i go kam mobig. ");
INSERT INTO tcs_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","‘Pipol no kapsaid niu wain insaid oul skinbaig. Ip ol i mekem diskain, da niu wain go base da oul skinbaig ane da wain i go kapsaid ausaid. Mobeta yupla kapsaid da niu wain insaid wea niu skinbaig.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Orait nau. Wan Zuwis Sabatdei, Zizas bin wagbaut wea wan gadan wea ol groe wit po meke plaua. Dem klostuman blo em bin de ane dempla bin broke sam sided. Dempla bin tekemaut dat ausaid skinpat ane ol bin kaikai dat insaid sidpat. ");
INSERT INTO tcs_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sam dem Parasi bin aske em, ‘Watpo ol klostuman blo yu bin broke dem lo? Dempla bin meke wok wea Zuwis Sabatdei. Yupla sabe. Yupla no lau po broke sided po kaikai wea Sabatdei.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Zizas bin ansa dempla, ‘Yupla bin ridem wanem King Deibid ane ol man blo em bin mekem wen dempla bin anggre? ");
INSERT INTO tcs_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","I bin da seimtaim wen Abiata bin bosprist. Deibid bin go insaid da aus blo God. Em bin kaikai da spesil opringbred blo God, wea mata dem prist i lau po kaikai. Ane Deibid bin gibe sam bred po ol dem man uda bin de wea em.’ ");
INSERT INTO tcs_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","28","Den Zizas bin spik gen, ‘God i meke da Sabatdei po man. Em no meke man po Sabatdei. Ai da Truwan blo Man gad antap paua. Mata mi ken kare dem lo blo da Sabatdei bikoz ai da BosLod blo da Sabatdei.’ ");
INSERT INTO tcs_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nada Zuwis Sabatdei nau, Zizas bin go gen po da zuwispreaus. Em bin go insaid ane em bin tekenotis i bin gad wan man de uda an blo em bin paralaiz. ");
INSERT INTO tcs_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Bikoz i bin Zuwis Sabatdei, ol dem enami blo Zizas i bin wase em prapa klostu. Dempla bin wase em po luk ip em go ile dat paralaiz an blo da man, bikoz dempla bin luk po wei po paine polt wea Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Zizas bin spik po da man, ‘Yu gedap ane kam stanap ya prant wea ebriwan.’ ");
INSERT INTO tcs_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Den Zizas bin sluraun ane luk dempla ane em aske dempla, ‘Wiswei da raitwei? I mobeta po meke gudting o badting wea Sabatdei? I mobeta po seibe laip blo man o libe man po ded?’ Dem man kan ansa Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Zizas bin wail po dempla ane em bin luk prapa adwan po dempla. Em bin nadakain apset bikoz dempla prapa stronged. Den em bin slu po da man ane em bin spik po em, ‘Pute an blo yu kam.’ Da man bin lisen ane bin pute an blo em kam ane an blo em bin kamgudgen. ");
INSERT INTO tcs_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Stretwei dem Parasi bin lego go ane tok po dem pipol uda bin pole King Erod po paine wei po kile Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Zizas ane dem klostuman blo em i bin go po Leik Galali ane bigmob pipol bin pole dempla biain. Ol bin kam po lisen Zizas bikoz da niuz blo em bin go ausaid ebriwea. ");
INSERT INTO tcs_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Dempla bin kam prom Galali, Zudia, Zarusalem, Idumia ane prom da nadasaid blo Zodan Riba, iben prom dem longwei taun, Taira ane Sidon. ");
INSERT INTO tcs_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Zizas bin spik po dem klostuman blo em po teke bot kam klostu po em, so em ken zamp insaid. I nogad no rum wea sanbis po stanap bikoz dem plenti pipol pose demplaselp po kam klostu po em. ");
INSERT INTO tcs_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Plenti pipol bin il dat dei ane mo sikpipol bin puse demplaselp po kam klostu wea Zizas bikoz dempla bin wande tase em. ");
INSERT INTO tcs_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ebritaim wen demwan uda bin gad nugudspirit insaid dempla bin luk Zizas, dempla bin poldaun ane dem nugudspirit bin singaut prapa laudwan, ‘Zizas, yu da Boi blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Bat em bin wone dem nugudspirit prapa strong po stap kuaiat, po no spik uda em. ");
INSERT INTO tcs_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Samtaim apta, Zizas bin singaut dem pipol uda em wandem, po go wea em go antap wan il. Dempla bin kam ane go wea em antap da il. ");
INSERT INTO tcs_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Zizas bin pike tuelb klostuman blo em. Em bin suze dempla po kam misnareman blo em, po pole em ane po spik gudniuz blo God, ");
INSERT INTO tcs_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ane dempla go kare da paua po ile man ane po tekemaut ebri nugudspirit. ");
INSERT INTO tcs_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Dem neim ya blo dem tuelb misnareman: Saiman (Zizas bin gibe em nada neim, Pita), ");
INSERT INTO tcs_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zemes ane Zon, tu boi blo Zebadi. Zizas bin gibe demtu pleineim ‘Tu boi blo Tanda’. Diswan i min demtu prapa kuik po wail, ");
INSERT INTO tcs_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Pilip, Batolomiu, Matiu, Tomas, Zemes (boi blo Alpias), Tadias, Saiman (ol bin kole em da Zelot bikoz em pat blo dat Zelotgeng uda bin pait po dem rait blo ol Zuwispipol), ");
INSERT INTO tcs_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Zudas Iskara (em da wan uda apta bin sele Zizas po dem Zuwislida po kilem). ");
INSERT INTO tcs_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nau Zizas bin gobaigen po da aus wea em bin stap ane bigmob pipol bin kam tugeda de gen po lisen po Zizas. I bin gad dat mas pipol de, Zizas ane ol klostuman blo em no bin gad taim po kaikai o slip. ");
INSERT INTO tcs_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Orait. Wen ol pamle blo Zizas bin lisen wanem em bin go tru, dempla bin kam po tekem go aus bikoz dempla bin tingk, ‘Em bin luze sens.’ ");
INSERT INTO tcs_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Den dem Zuwislotisa uda bin kam prom Zarusalem, ol bin spik, ‘I gad Belzibel insaid wea em, ane Zizas gede mostrong prom em po tekemaut dem nugudspirit prom dem pipol uda gad nugudspirit.’ ");
INSERT INTO tcs_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Zizas bin spik po ebriwan po kam po em ane em bin yan wan stori wea i gad mining. ‘Wiswei yupla tingk? Satana go draibe Satana aut? ");
INSERT INTO tcs_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Eni kantri uda go splitap, meke ol dipren grup ane paite wananada, dat kantri go pinis. ");
INSERT INTO tcs_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Da seim wea pamle tu. Ip pamle gense wananada, dat pamle i go splitap. ");
INSERT INTO tcs_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","So nau, ip Satana go gense ol nugudspirit blo em, paua blo em go pinis. ");
INSERT INTO tcs_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Lisen ya. Yupla kan go insaid aus blo strongman. Yupla mas paine wei po kese em ane taitem pas bipo yupla ken go insaid po teke ol samting blo em. ");
INSERT INTO tcs_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ai spik trutok po yupla, yupla ken meke ol nugudting ane tok ol nugudtok gense God bat God go stil pogibe yupla ebribodi. ");
INSERT INTO tcs_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Bat enibodi uda go daune ane tok ol nugudtok gense OliSpirit blo God, God nogo pogibe dempla. Dempla gobi gilti poeba.’ ");
INSERT INTO tcs_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Zizas bin spik dis tok po dem Zuwislotisa bikoz dempla bin spik em gad nugudspirit insaid wea em. ");
INSERT INTO tcs_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Apta Zizas bin yan, mama blo em ane ol bala blo em, i bin kam de po dat aus. Ane dempla bin sane tok go po Zizas po kam ausaid. ");
INSERT INTO tcs_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bigmob pipol bin babuk raun wea Zizas ane dempla bin pase da mesiz po Zizas. ‘Ei Tisa! Mama ane ol bala ane sisi blo yu, ya ausaid. Ol wande yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Zizas bin aske dem pipol, ‘Uda mama blo mi? Uda bala blo mi?’ ");
INSERT INTO tcs_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Zizas bin sore po dempla ane em bin spik po dempla, ‘Yupla ol bala ane mama blo mi. ");
INSERT INTO tcs_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Enibodi uda meke ubi blo God, i mai bala, mai sisi ane mai mama.’ ");
INSERT INTO tcs_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Orait. Nadataim gen, Zizas bin tise ol pipol de lo da sanbis klostu lo Leik Galali ane bigmob pipol bin pole em. Wen em bin luk dem mob pipol i tumas, em bin zamp insaid wan bot ane em bin tok po dem pipol prom dat bot. ");
INSERT INTO tcs_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Em bin lane dem pipol plenti stori wea i gad mining ane wan stori i bin go diskain. ");
INSERT INTO tcs_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","‘Lisen ya yupla. I bin gad wan man, em i pama ane em bin meke gadan. ");
INSERT INTO tcs_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Em bin go po meke gadan ane em bin sake plenti sid wea dat gadan. Bat wen em bin go ausaid, sam sid bin poldaun wea busrod. Pizin bin kam ane kaikai dem sid. ");
INSERT INTO tcs_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sam dem nada sid bin poldaun wea stonigraun. Ol bin bas kuikwan. ");
INSERT INTO tcs_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Dem smolplant bin draiap prom ot blo da san bikoz dem rut kan godaun bikoz i stonigraun. ");
INSERT INTO tcs_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nada sid i bin poldaun wea ol bainplant i bin krol, bat wen ol dem plant i bin stat po gro, dempla kan, bikoz dem bainplant bin skuize dempla. ");
INSERT INTO tcs_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ane sam dem nada sid i bin poldaun wea gudgraun ane ol bin sake plenti sid. Sam ed bin sake tati sid, nada ed bin sake siksti sid, i stil gad mo ed sake andred sid.’ Den Zizas i spik, ");
INSERT INTO tcs_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","‘Yupla uda gad talinga, yupla mas lisen prapa ane yupla mas tingk nau.’ ");
INSERT INTO tcs_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Apta nau, wen Zizas bin sidaun emselp, dem tuelb klostuman blo em ane sam nada biliba i bin kam askem po eksplein da mining blo dem stori blo em. ");
INSERT INTO tcs_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","So Zizas bin ansa dempla, ‘God gibe yupla sabe so yupla go sabe dis niuwei wen God i go ruloba ebriwan ane ebriting, ane dis niu wei i tru. Bat po dem nadalot pipol, wanem ai spik i mata stori. Dempla noboda po paindaut da prapa mining. ");
INSERT INTO tcs_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Baibol i spik: “Dempla luk wanem ai mekem, bat ol no tekenotis. Dempla lisen wanem ai tok, bat ol no sabe. So dempla nogo sabe da trutok blo God ane dempla nogo sluraun prom nugudwei blo dempla so God nogo pogibe dempla.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Den Zizas bin spik, ‘Orait nau. Ip yupla no kese dis stori, wiskain yupla go kese ol dem nada stori ai go spik. ");
INSERT INTO tcs_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Da pama, i da man uda sere wod blo God po ebribodi. ");
INSERT INTO tcs_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Dem sid wea i poldaun melen wea rod i wase dem pipol uda lisen dem wod blo God. Bat Satana i bin stretwei kam ane tekemaut dem wod prom at blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ol dem nada sid wea i poldaun wea stonigraun, i wase dem pipol uda glad po lisen dem wod blo God, ");
INSERT INTO tcs_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bat dempla no teke dem tising dip daun insaid at blo dempla. So dempla kipem po sottaim. Daswai wen ol adtaim i kam ane ol pipol go prapa moke ane daune dempla, dempla go gibap ane nomo pole God. ");
INSERT INTO tcs_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Da sid wea i poldaun wea da bainplant, i wase dem pipol uda lisen dem wod ane kip dem wod blo God. ");
INSERT INTO tcs_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Bat dem wod kan gro ane wok wea laip blo dempla. Ol nogad no rum po dem wod blo God bikoz dempla tingbaut ebriting blo dis laip. Dempla wande plenti mani ane olkain gudting po meke dempla api. Bat ol demting stape dem wod blo God prom goed. ");
INSERT INTO tcs_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Dem nada sid nau wea i poldaun wea da gudsoil, i wase dem pipol uda lisen dem wod blo God ane kipe dem wod prapa strong. Wen pipol go luk laip blo dempla, dempla go gad gudpasin ane dempla go ebritaim spik da gudniuz blo God. Dempla wase sid, samtaim dem sid sake tati mo, sam siksti mo ane sam, andred mo.’ ");
INSERT INTO tcs_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Den Zizas aske dempla, ‘Yupla tingk, dempla uda go laite lamp go kabarem wea dis, o aidem andanit wea bed, solong da lait kan sain go ausaid? Nono! Yupla wande luk dat lait i sain, yupla mas aingem antap. ");
INSERT INTO tcs_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ebri sikretting go kamaut. Ebriting go kamaut wea da lait blo God. ");
INSERT INTO tcs_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Eniwan uda wande lisen nau, lisen prapa gud. ");
INSERT INTO tcs_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","‘Orait nau. Yupla mas lisen prapa gud po da tok blo God. Ip yupla kip lisen po God, God go gibe yupla mosabe. ");
INSERT INTO tcs_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","So yupla nau mas lisen prapa gud po da tok blo God. Ip enibodi gad sabe wea God, God go gibe yupla mo sabe. Bat ip yupla nogad sabe, God go tekemaut ebri sabe yupla gad, iben dat bilib yupla tingk yupla gad.’ ");
INSERT INTO tcs_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Zizas bin tok gen, ‘Ai gad nada stori baut dat ples wea God i go ruloba ebriwan. I wase pama plante ol sid insaid wea gadan blo em. ");
INSERT INTO tcs_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Da pama bin go ane meke ol nada wok wea da gadan. Ol dei em bin gedap ane wok ane naittaim em i slip. Dem sid i bas ane gro bat da pama no sabe wiskain em gro. ");
INSERT INTO tcs_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Da graun i meke dem sid gro. Wen dem sid i gro, ol lip i kamaut pas. Den apta ol plaua i kamaut, dem sid kamaut ane dem seim sid i kam raip. ");
INSERT INTO tcs_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Apta, wen dem sid i raip, da pama i kam ane kate dem sid wea uknaip.’ ");
INSERT INTO tcs_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Zizas bin spik, ‘Ei! Wiskain ai go soe yupla da ples wea God i gad po yupla wen em go ruloba ebribodi? Wiskain stori ai go eksplein po yupla?’ ");
INSERT INTO tcs_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Em bin spik, ‘Dat niuples em wase prapa smolsid blo mastadtri wea sambodi plante em wea gadan blo em. Nomata i prapa smolsid, wen smol mastadsid go gro, i go gro prapa kuik po bigtri ane ol pizin ken meke nest wea brans blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Zizas bin yan olkain stori wea i gad mining po dem pipol po lane dempla solong dempla go sabe. ");
INSERT INTO tcs_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Zizas ebritaim yan stori wea i gad mining po lane ol dem pipol. Bat wen em ane ol klostuman blo em bin wea demplaselp, Zizas bin eksplein ol dem mining blo dem stori po dempla. ");
INSERT INTO tcs_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Zizas bin singaut go po klostuman blo em wen i bin stat po dak. Em spik, ‘Kam, yumi go kros po da nadasaid blo da leik.’ ");
INSERT INTO tcs_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","So ol bin yawo dem pipol ane tekop go ane ol dem nada bot bin pole dempla go biain. ");
INSERT INTO tcs_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Prapa big strongwin bin kam kros wea da leik. Da bigsi bin stat po kam insaid da bot ane da bot i klostu singdaun. ");
INSERT INTO tcs_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Zizas bin leidaun slip, ed blo em bin antap wea pela de biain wea da stan. Dem klostuman bin weikemapem ane singaut, ‘Ei Masta! Yu no wori a? Yumpla go draun!’ ");
INSERT INTO tcs_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Den Zizas bin gedap ane em bin oda da strongwin ane da bigsi, ‘Yu stap!’ Da win bin stap kuaiat ane da bigsi bin kamdaun kam gris. ");
INSERT INTO tcs_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Zizas bin aske dempla, ‘Ei! Wanem yupla prait po? Wea bilib blo yupla?’ ");
INSERT INTO tcs_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Dempla bin prapa prait ane atzamp. Dempla tok po demplaselp, ‘Ei! Uda dis man? Em gibe oda ane da win ane da si bin lisen po em.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Apta nau, dempla bin kese da ples Gerasin, nadasaid lo Leik Galali. ");
INSERT INTO tcs_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wen Zizas bin zamp ausaid prom da bot po sanbis, wan man uda bin gad nugudspirit stap insaid wea em, i bin ran kam prom sematri, bikoz em stap wea sematri. ");
INSERT INTO tcs_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Em nadakain wail man, nobodi ken stape em prom pait ane em broke ebriting. Ol man kan taiemapem, no iben wea sein. ");
INSERT INTO tcs_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Plentitaim ol bin taite an ane leg blo em wea sein bat em ebritaim broke dem sein. Em bin nadakain strong. Nobodi ken stape em. ");
INSERT INTO tcs_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ebridei ane ebrinait dis man wagbaut de wea da sematri ane antap wea dem il. Em i ala de laudwan ane paite emselp wea ston. ");
INSERT INTO tcs_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","So nau, wen da man bin luk Zizas prom longwei, em bin ran go po Zizas ane poldaun prant wea em. ");
INSERT INTO tcs_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Zizas bin spik po da nugudspirit diskain, ‘Yu nugudspirit, gedaut prom dis man!’ Da nugudspirit bin singaut prapa laudwan, ‘Wanem yu wandem wea mi Zizas, Boi blo da Prapa AntapGod. Plizgar, wea neim blo God, yu no panse mi, no meke mi po sapa.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Zizas i bin spik po em, ‘Uda neim blo yu?’ Da nugudspirit bin ansa em, ‘Mina Plenti, bikoz mipla prapa plenti ya insaid dis man.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ol dem nugudspirit bin bege Zizas no po sane dempla go prom dat ples. ");
INSERT INTO tcs_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Plenti bigmob pig bin kaikai de wea ilsaid. ");
INSERT INTO tcs_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ol dem nugudspirit bin bege Zizas po sane dempla go insaid wea ebridem pig. ");
INSERT INTO tcs_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","So Zizas bin gri. Ol dem nugudspirit bin kamaut prom da man ane ol bin go insaid dem pig. Da namba blo dem pig i bin 2,000. Den dat bigmob pig bin ran kamdaun da il, go insaid da leik wea ol i bin draun. ");
INSERT INTO tcs_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Dem pipol uda bin lugaut dem pig bin luk wanem bin apen ane dempla bin atzamp. Ol bin ranwei. Ol bin go sprede da niuz wea dat taun ane ebriwei wea da kantri eria. Plenti pipol bin kam po luk wanem bin apen de. ");
INSERT INTO tcs_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ol bin kam de wea Zizas. Ol bin paine da man uda bin gad dem nugudspirit. Em bin sidaun kuaiatwan, de klostu po Zizas ane em bin were klos nau. Em nomo dugi nau. Dem pipol bin prapa prait. ");
INSERT INTO tcs_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Dempla uda bin luk wiskain Zizas bin mekem po da man, ol bin yan po dem nadalot pipol. ");
INSERT INTO tcs_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Apta nau ol dem pipol bin bege Zizas po libe dempla ane go prom dat eria. ");
INSERT INTO tcs_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Den Zizas ane ol klostuman blo em bin zamp baigen insaid da bot blo dempla, redi po go. Dat man wea Zizas i bin tekemaut dem nugudspirit, bin bege em ip em ken go wea dempla tu. ");
INSERT INTO tcs_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bat Zizas bin spik, ‘Nono! Go aus po pamle blo yu. Yu spik dempla ol dem gudting wanem God i bin mekem po yu, bikoz em bin sore po yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","So dat man bin go bizit dem ten taun wea da eria blo Dekapolis. Em bin spik ebriwan de ol demting wanem Zizas bin mekem po em. Ane ebriwan i bin prapa atzamp baut demting wanem em bin spik po dempla. ");
INSERT INTO tcs_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wen Zizas bin kambaik prom Gerasin, bigmob pipol bin kam po em ane stanap raun wea em wea da sanbis. ");
INSERT INTO tcs_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Wan man, neim blo em Zairas, em i wan lida blo da zuwispreaus. Em bin kam de wea Zizas ane em bin nildaun prant wea em. ");
INSERT INTO tcs_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Em bin bege Zizas, ‘Plizgar, yu kam ile smolgel blo mi! Em go ded sun. Plizgar, kam ane pute an blo yu antap wea em ane prea po em. Yu ile em solong em go stap laip.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","So Zizas bin go wea em, bat i bin gad prapa bigmob pipol raun wea em. Dempla kip puse demplaselp kam klostu po em. ");
INSERT INTO tcs_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Wan oman bin de melen wea dat bigmob tu. Em bin gad big problem wea mantli blo em, po tuelb iya. ");
INSERT INTO tcs_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Longtaim da oman bin sapa prom dat sik. Plenti dokta bin trai po mekem kamgud bat dempla kan. Bat nau em bin kam mobad prom dat sik. Ebri mani blo em bin pinis prom pei dem dokta. ");
INSERT INTO tcs_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Em bin lisen Zizas bin ile pipol, so em bin go biain lo Zizas, prapa klostu po em, ane em bin tase end blo da klos blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Em bin tingk pas po emselp, ‘Ip ai ken mata tase klos blo Zizas, ai go kam orait.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Stretwei da blad i bin stap, ane em sabe em orait. ");
INSERT INTO tcs_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Zizas stretwei sabe paua blo em bin meke sambodi kam orait ane em i wantaim tanraun ane tok po dat bigmob pipol, ‘Uda bin tase klos blo mi?’ ");
INSERT INTO tcs_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Dem klostuman blo Zizas bin spik po em, ‘Masta, i gad plenti pipol ya stanap raun wea yu ane dempla ebriwan bin tase yu. Aukam yu aske mipla, “Uda bin tase klos blo mi?” ’ ");
INSERT INTO tcs_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Zizas i kip lukraun po uda bin tase klos blo em. ");
INSERT INTO tcs_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Da oman sabe em bin kam orait. Em bin prait, nadakain seik. Em bin poldaun wea leg blo Zizas ane spik ebriting wanem bin apen po em. ");
INSERT INTO tcs_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Da BosLod i spik po em, ‘Mai gel, bilib blo yu bin meke yu kamgud. Yu orait nau, go nau wea pis.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wail Zizas bin stil tok po da oman, sam man bin kare niuz kam po Zairas. Dempla bin spik po Zairas, ‘Mipla teke sadniuz kam po yu. Gel blo yu bin pasawei. Spik po da Tisa, em no nid po kam wea yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Bat Zizas no bin tekenotis wanem dempla tok. Em spik po Zairas, ‘Yu no prait, yu mata bilib mi.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Den Zizas bin spik po da bigmob pipol, ‘Yupla ebriwan stap ya. Mata demtri klostuman blo mi go kam, Pita, Zemes ane Zon.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wen dempla bin kese aus blo da zuwispreaus lida, Zizas bin luk ebribodi stanap de, ol mata krai laudwan. ");
INSERT INTO tcs_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Em bin go insaid da aus, ane tok po dem pipol. Em spik, ‘Ei! Wanem yupla krai laudwan po? Dis gel no ded. Em mata slip.’ ");
INSERT INTO tcs_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Dempla ebriwan bin lap em, bat Zizas i oda ebriwan po go ausaid prom dat aus. Den Zizas bin teke mama ane papa blo da smolgel, ane demtri klostuman blo em go insaid da rum wea da smolgel i leidaun. ");
INSERT INTO tcs_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Zizas bin teke an blo da gel ane tok po em wea langus, ‘Talita kum.’ Diswan i min ‘Smolgel, gedap’. ");
INSERT INTO tcs_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ane da gel bin stretwei stanap ane wagbaut. Em bin tuelb iya oul. Mama ane papa blo em bin nadakain atzamp ane api. ");
INSERT INTO tcs_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Bat Zizas bin oda dempla, ‘Yupla no spik nobodi wanem bin apen ya tidei.’ Ane em spik po dempla, ‘Gibe em kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Orait nau. Zizas ane ol klostuman blo em bin libe dat ples ane ol bin gobaik po taun blo em, Nazaret. ");
INSERT INTO tcs_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Da nada Zuwis Sabatdei apta, em bin kambaik po Nazaret ane Zizas bin go po da zuwispreaus, stat po tise dempla. Plenti pipol bin lisen em ane ol bin prapa atzamp. Ol dem pipol i tok ane spik po wananada diskain, ‘Aukam em tok diskain? Wea em bin gede ol dis gudsens prom ane wea em bin gede ol dis paua prom po meke ol dem mirikal em mekem. ");
INSERT INTO tcs_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Yumpla sabe dis man, em i mata kapenta ane em i boi blo Meri. Em bala blo Zemes, Zosep, Zudas ane Saiman. Ol sisi blo em stap ya wea yumpla.’ Daswai dem pipol blo Nazaret bin wail po Zizas ane ol no bin wande bilibe em. ");
INSERT INTO tcs_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Bat Zizas i spik po dempla, ‘Diswan ya i pasin blo pipol. Ol pipol ebriwea go kare spesilmesizman blo God antap, bat no wea dat ples wea dat spesilmesizman bin gro.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Bikoz dempla no bin bilib, Zizas kan meke no mirikal wea dat ples, so em bin mata pute an antap lelbet sikpipol ane meke dempla kam orait. ");
INSERT INTO tcs_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Zizas bin atzamp ane sore ol pipol blo em no bin bilibe em. ");
INSERT INTO tcs_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nau Zizas em bin singaut po dem klostuman blo em, ane em bin spik po dempla ebriwan, ‘Ai go sane yupla goraun ebri biliz tubaitu. Ane ai go gibe yupla paua prom God so yupla ken yuze da paua po tekemaut ebridem nugudspirit.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ane Zizas i bin tok strong po dem klostuman, ‘Wen yupla goraun po dem biliz, yupla no teke nating, no bred, no baig, no mani. Bat yupla ken teke wan wokingstik.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Em bin spik po dempla po were sandol, bat no teke ekstra klos. ");
INSERT INTO tcs_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","‘Wen yupla go insaid dem dipren biliz, yupla mas stap wea wan aus. Stap de antil yupla redi po go prom dat taun. ");
INSERT INTO tcs_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ip ol dem pipol wea dem taun no welkam o lisen po yupla, yupla libe dempla ane go. Bat pas, yupla mas seike dast prom put blo yupla po wone dempla, ane spik diskain po dempla, “God go panse yupla bikoz yupla no bin wande lisen da mesiz blo em.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ol dem klostuman bin goaut ane spik dis mesiz blo God po ebriwan de. Ol bin spik diskain, ‘Yupla ebriwan mas libe ol nugudwei blo yupla nau.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ane dempla bin tekemaut ebri nugudspirit ane dempla bin prea den kapsaid oliboil wea ol sikpipol po meke dempla kam orait. ");
INSERT INTO tcs_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Orait nau, King Erod Antipas em bin lisen pipol ebriwea tokbaut Zizas. Sam pipol bin tok diskain, ‘Ei! Diswan ai tingk em i Zon Baptaizman uda bin kamlaipgen. Daswai dis man Zizas gad paua po meke ol mirikal nau.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ol nada pipol bin spik, ‘Diswan dat longtaim spesilmesizman, neim blo em Ilaiza.’ Ol nada pipol bin spik diskain, ‘Em wase wan dem spesilmesizman prom bipotaim.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Bat wen Erod bin lisen, em bin spik, ‘Diswan Zon Baptaizman uda ai bin gibe oda po kate ed blo em. Em bin kamlaipgen.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Wail Zon Baptaizman bin stil laip, em bin ebritaim graul po Erod, ‘Ei, i no rait po yu po maret da oman blo bala blo yu.’ Erodias i bin da oman blo bala blo Erod, neim Pilip, bat Erod bin maret em. Wen Zon bin tok diskain, dat oman blo Erod, Erodias bin ebritaim prapa wail po Zon. Erodias bin wande Erod po gibe oda po kile Zon, bat Erod no bin wande kile em, so em bin mata oda dem amiman po kesem ane lokem insaid zeilaus. Wen Zon bin insaid zeilaus, Erod bin lugautem prapagud bikoz em sabe Zon bin gudman blo God. Ebritaim wen Erod i yan wea Zon, em bin laik po lisen po em bat wen demtu pinis yan, Erod bin ebritaim wori bikoz em no sabe wanem po mekem baut wanem Zon bin tokbaut. ");
INSERT INTO tcs_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nau Erod bin meke big pisting po batdei blo em. Em bin inbait ebri edman wea gabman blo em, ebri kapten blo ami blo em ane ol dem elda blo Galali po kam ane kaikai wea em. Ane seimtaim nau Erodias bin paine wei po kile Zon Baptaizman. ");
INSERT INTO tcs_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Da gel blo Erodias i bin kam insaid wea da pati ane em bin dans po dempla ane ebriwan bin luk em. Erod ane ol pren blo em bin nadakain api po luk da gel dans. So Erod bin aske da gel diskain, ‘Mai gel, aske mi po eniting yu wandem, ai go gibem po yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Den em meke dis promis po da gel. Em spik diskain, ‘Ai go gibe yu eniting yu wandem, iben ap blo ebriting ai gad.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wen da gel bin pinis dans em bin go po Erodias, mama blo em ane aske em diskain, ‘Wanem ting ai go aske Erod po?’ Mama spik po em baigen, ‘Aske Erod po ed blo Zon Baptaizman.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Da gel bin ariap gobaigen po Erod ane spik po em diskain, ‘Ai wande yu po kate ed blo Zon Baptaizman ane pute ed blo em antap wea trei ane kare em kam po mi.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wen da king bin lisen dis tok em bin nadakain sore, bat em bin sem po spik no po da gel, prant wea ebriwan uda bin de wea em. ");
INSERT INTO tcs_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Erod bin sane wan amiman go po da zeilaus po kate ed blo Zon ane tekem kambaik po em. Da amiman bin go ane kate ed blo Zon de insaid wea da zeilaus, ");
INSERT INTO tcs_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ane em bin kare da ed kam antap wea trei ane gibem po da gel. Den da gel bin gibem po mama blo em. ");
INSERT INTO tcs_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wen dem klostuman blo Zon bin lisen Zon bin ded, dempla bin kam po teke da bodi ane bere em. ");
INSERT INTO tcs_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Orait. Dem misnareman blo Zizas bin pinis goraun ol dem biliz. Wen ol bin kambaik, ol bin spik po Zizas wea dempla bin go ane wanem dempla bin mekem ane wiskain ol bin tok ane tise ol dem pipol de. ");
INSERT INTO tcs_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","I bin gad plenti pipol raun wea Zizas ane plenti pipol bin kip kam ane go. Zizas ane dem misnareman blo em no bin gad taim po kaikai. So Zizas spik po dempla, ‘Kam, yumpla go po kuaiatples sole yumpla ken spel.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","So ol bin zamp insaid wan bot ane go po kuaiatples. ");
INSERT INTO tcs_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bat plenti pipol bin luk dempla go. So dem pipol bin ran go wea da said blo da leik po dat ples wea Zizas bin go. So dempla i bin kesem de pas. ");
INSERT INTO tcs_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wen Zizas bin go antap wea sanbis, em bin luk i gad tumas pipol de weit po em. So Zizas bin pil nadakain sore po dem pipol bikoz dempla wase smolsip nogad no man po lugaut dempla. So Zizas bin tise dempla plentiting. ");
INSERT INTO tcs_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wen i bin klostu po dak, dem klostuman bin kam ane spik po Zizas, ‘Ei Masta. I stat po dak nau ane diswan em i ples wea i nogad nating. ");
INSERT INTO tcs_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Yu sanewei dem bigmob pipol go po dem klostu biliz so dempla ken go baie kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Zizas bin ansa dempla baigen, ‘No! Yupla gibe dempla kaikai.’ Nau dempla bin ansa diskain po em, ‘Mipla go nide eit mant pei po pide dempla ebriwan. Yu wande mipla po spene dat mas mani po pide dempla?’ ");
INSERT INTO tcs_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ane Zizas aske dem klostuman, ‘Ei, yupla gad eni kaikai? Yupla go nau ane paindaut.’ Den dem klostuman bin kambaik ane spik po Zizas, ‘Mipla bin paine paib smol bred ane tu smol pis.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nau Zizas bin spik po dem klostuman po spik ol dem pipol po splitap po smol mob ane sidaun daun wea da gras. ");
INSERT INTO tcs_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","So ebriwan bin sidaun wea da gras, baut pipti o andred wea ebri mob. ");
INSERT INTO tcs_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Zizas bin luk go antap po eben ane em bin eso God po da kaikai. Em bin broke da bred po smolpis. Den em bin gibem po dem klostuman blo em po seremaut po ebriwan. ");
INSERT INTO tcs_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Ebriwan bin kaikai ane ol bin belipul. Dem leptoba kaikai, ol bin pilemap tuelb basket. ");
INSERT INTO tcs_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wea dat taim nau, i bin gad 5,000 man ane ol pamle blo dempla, ane ol i bin kaikai. ");
INSERT INTO tcs_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Stretwei nau Zizas em i spik po ol dem klostuman blo em, ‘Yupla ebriwan zamp insaid wea da bot ane yupla ran go nadasaid blo da leik, go po Betsaida.’ Bat em bin stap biain ane sane ebribodi gobaik po aus. ");
INSERT INTO tcs_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wen em bin pinis sane dem pipol go aus, em bin go emselp go antap dem il po prea. ");
INSERT INTO tcs_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Naittaim nau, Zizas em bin stil antap wea da il. Dem klostuman blo em bin insaid da bot rait melen wea da leik. ");
INSERT INTO tcs_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Orait, i klosap po deilait nau. Zizas bin luk dem klostuman blo em prapa adwok. Ol bin padol da bot gense da strongwin ane da big rapsi. So em bin wagbaut go ausaid po da bot, bat em bin kip wagbaut go po pase dempla. ");
INSERT INTO tcs_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Bat wen dem klostuman blo em bin luk em wagbaut antap wea wata, dempla bin tingk em bin gos. ");
INSERT INTO tcs_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Dempla bin ala prapa laudwan bikoz dempla nadakain akan. Seimtaim nau Zizas i spik po dempla diskain, ‘I orait. Diswan mi, Zizas. Yupla nomo prait.’ ");
INSERT INTO tcs_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Zizas i bin wagbaut go ane zamp insaid dat bot ane da win bin stap. Bat dem klostuman blo em bin prapa atzamp wen ol bin luk da rapsi ane strongwin i bin godaun. ");
INSERT INTO tcs_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Dempla no bin kesem wanem da mining blo da mirikal Zizas bin mekem wea dem paib smol bred de wea da il. Dempla kan bilib Zizas bikoz at blo dempla i bin tuad. ");
INSERT INTO tcs_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Orait nau. Dempla ebriwan bin go po da nadasaid blo da leik po wan ples neim Genesaret. Wen ol bin kam de, dempla bin angka da bot ");
INSERT INTO tcs_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ane zamp ausaid. Dem pipol uda bin de ol bin wantaim sabe diswan Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Wen dem pipol uda bin luk Zizas, dempla bin ran go ebriwea lo taun blo dempla ane spik po ebriwan Zizas bin kam. Dempla bin stretwei kare ol sikpipol kam antap wea mat wase stresa. ");
INSERT INTO tcs_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ebri ples wea Zizas i bin go, insaid wea dem biliz ane taun, ane ausaid wea dem kantri eria, ol dem pipol bin meke dem sikwan leidaun daun wea dem maketples ane melen wea rod. Ol sikpipol bin bege em po lete dempla tase da end blo klos blo em ane ebriwan uda bin tase dem klos ol bin kam orait. ");
INSERT INTO tcs_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wantaim, sam dem Parasi ane dem Zuwislotisa i bin kam prom Zarusalem, kam po Zizas po strete em. ");
INSERT INTO tcs_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Dempla tekenotis sam dem klostuman blo Zizas no bin pole dat prapa Zuwis seramoni blo wase an pas bipo kaikai. ");
INSERT INTO tcs_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Dem Parasi ane dem Zuwispipol, kastam blo dempla ol mas kapsaid wata antap an, raitap po elbou blo dempla bipo dempla kaikai, bikoz diswan i lo blo dempla prom longtaim. ");
INSERT INTO tcs_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Seimkainwei, wen dempla baie kaikai wea maketples, dempla no kaikai dem kaikai antil dempla swim wea kastamlo blo dempla. Ane dempla gad tumas olkain kastamlo po wase ol kap ane zag ane ketol. ");
INSERT INTO tcs_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Orait. Dem Parasi ane Zuwislotisa bin aske Zizas, ‘Aukam dem klostuman blo yu no pole kastam blo dem ate blo yumpla ane dempla no pole da seramoni wei wea wase an pas bipo kaikai?’ ");
INSERT INTO tcs_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Zizas i ansa dempla, ‘Aizaia da spesilmesizman i bin rait wen em bin spik de pas baut yupla ol tupes pipol. Insaid lo Baibol i bin raitem diskain: “Dem pipol spik dempla rispekt mi, bat insaid at blo dempla, dempla no rispekt mi. ");
INSERT INTO tcs_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Dempla no wosip mi prapa. Dempla tekemaut tising blo God, pute tising blo dem man.” ");
INSERT INTO tcs_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","‘Yupla nomo pole dem lo blo God. Yupla tumas pole dem kastamlo blo man.’ ");
INSERT INTO tcs_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Den em spik, ‘Yupla prapa no wande dem lo blo God bikoz yupla wande pole kastamlo blo yupla. ");
INSERT INTO tcs_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Da lo blo Mozes i spik diskain, “Yu mas soe rispekt po papa ane mama blo yu. Enibodi uda tok nugudtok gense papa ane mama blo em, em mas ded.” ");
INSERT INTO tcs_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bat yupla, dem Parasi ane Zuwislotisa i spik po dem pipol, i orait po spik po papa o mama diskain, “Ai gad mani po elpe yu, bat ai bin meke promis po gibe dis mani po God.” ");
INSERT INTO tcs_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wa! Yupla no laue dem pipol po gibe dat mani po papa o mama blo dempla ip dem papa o mama gad nid. So nau dem pipol tingk dempla no nid po lugaut dempla papa ane mama enimo. ");
INSERT INTO tcs_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","I wase diskain. Yupla broke dem lo blo God solong yupla ken kipe dem Zuwislo yupla bin mekem. Ane yupla meke plentiting demkain.’ ");
INSERT INTO tcs_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Den Zizas i singaut po dem bigmob pipol po kam ane lisen po em. Em spik, ‘Yupla ebriwan, lisen prapagud po dis stori ai go yan yupla. Trai kese da mining. ");
INSERT INTO tcs_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kaikai i nating, bat dem nugudting yupla tingk, spik ane mekem go lide yupla go rongwei. ");
INSERT INTO tcs_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ip enibodi gad talinga, lisen prapa gud.’ ");
INSERT INTO tcs_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Apta nau, Zizas ane ol klostuman blo em bin libe dem bigmob pipol ane dempla bin go insaid dat aus wea dempla bin stap. Ane dem klostuman blo em bin askem baut da mining blo da stori blo em. ");
INSERT INTO tcs_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Zizas i ansa, ‘Wiswei? Yupla stil no sabe wanem ai bin spik? Yupla lisen nau. Wanem yupla kaikai i nogo meke yupla nugud prant wea God. ");
INSERT INTO tcs_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Wen yupla kaikai, dem kaikai i nogo tase at blo yupla, bat i go tru beli blo yupla ane i go kamaut prom bodi blo yupla.’ (Wen Zizas i bin tok diskain, em i spik, ebri kaikai i orait po kaikai.) ");
INSERT INTO tcs_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ane Zizas i kip tok, ‘Wanem dem nugudting blo pipol, i meke dempla nugud prant wea God? ");
INSERT INTO tcs_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ol dem nugudting stat insaid wea at ane tot blo pipol: ol nugudtot, ol nugud seks, kil, stil, ");
INSERT INTO tcs_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ol maret man o oman no kiptru po maret blo dempla, ol pipol uda gridi, ol pipol uda meke ol nugudting po ol nada pipol, ol pipol uda trike ane lai ol nada pipol, ol pipol uda meke ol badpasin po ebribodi, ol pipol uda bane ai po tingbaut ol man o oman, ol pipol uda zeles ol nada pipol, ol pipol uda daune God ane kareyan, ol nada pipol uda bloubaut demplaselp ane kamap, ane ol pipol uda i meke pan baut God, dempla nogad gudsens. ");
INSERT INTO tcs_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ol dem nugudting go kamaut prom insaid laip blo yupla, so God nogo wande yupla.’ ");
INSERT INTO tcs_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Den Zizas bin libe Galali ane em bin go po taun blo Taira. Wen em bin kesem de wea dat taun, em bin trai po stap de kuaiatwan lo wan aus, bat seimkain, da niuz blo em bin goraun kuikwan wea da taun. ");
INSERT INTO tcs_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Nau wan oman bin kam po luk Zizas. Em bin gad wan smolgel uda gad nugudspirit insaid wea em ane em bin lisen Zizas i bin de. Da oman bin kam ane poldaun prant wea Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Da oman em i Nozuwis bat em bin bon de wea Ponisia, de wea kantri blo Siria. Em spik sorewan po Zizas, ‘Zizas, plizgar! Yu ken tekemaut dis nugudspirit prom smolgel blo mi?’ ");
INSERT INTO tcs_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Zizas spik po em, ‘Pas ting, ai go elpe dem pamle blo mi, dem Zuwispipol. I no rait po teke da kaikai blo dem pikinini ane gibe dem kaikai po dog.’ ");
INSERT INTO tcs_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Da oman spik baigen, ‘Yu spik tru BosLod. Iben dem dog andanit wea da teibol kaikai dem smolpis bred wea i poldaun prom dem pleit blo dem pikinini.’ ");
INSERT INTO tcs_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","So Zizas em i tok po da oman diskain, ‘Bikoz yu bin tok diskain, ai spik po yu nau, wen yu gobaigen po aus, yu go paindaut da nugudspirit bin kamaut prom smolgel blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nau wen da oman bin kese aus blo em, em bin go luk smolgel blo em i bin orait, leidaun kuaiatwan antap wea da bed. Da nugudspirit bin pinis go. ");
INSERT INTO tcs_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Orait nau, Zizas bin libe Taira ane wagbaut go antap po taun blo Sidon. Den em bin wagbaut gobaigen po Leik Galali ane da eria blo Dekapolis. ");
INSERT INTO tcs_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ol bin teke wan man uda dep ane uda kan tok prapa, kam po Zizas. Ane dem pipol bin spik sorewan po Zizas po pute an blo em antap wea da man po meke em kamgud. ");
INSERT INTO tcs_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Zizas bin tekem go po kuaiatples wea i no bin gad pipol. Em pute ol pingga blo em insaid wea da talinga blo da man. Den em bin spet wea ol pingga blo em ane em tase da tang blo da man wea spet blo em. ");
INSERT INTO tcs_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Em luk go antap po eben ane em pil sore po da man ane em bin spik wea langus, ‘Epata.’ Diswan i min ‘Yu open nau’. ");
INSERT INTO tcs_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Stretwei da man ken lisen ane tok prapa. ");
INSERT INTO tcs_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Zizas bin tok strong po dem bigmob pipol, ‘No spik nobodi.’ Bat da mo em spik, dem pipol no po sprede da niuz, dempla no bin lisen, ol bin kip sprede da niuz. ");
INSERT INTO tcs_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bikoz dempla bin nadakain atzamp, dempla kip spik, ‘Ei! Em i meke ebriting prapagud. Em iben ile dempla uda dep ane kan tok!’ ");
INSERT INTO tcs_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nadataim, prapa bigmob pipol bin de wea Zizas ane da kaikai blo dempla i bin pinis bikoz dempla bin de wea Zizas po piudei. So Zizas bin singaut ol dem klostuman blo em po kam po em ane em i spik diskain po dempla. ");
INSERT INTO tcs_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","‘Ai prapa sore po dem pipol ya bikoz dempla stap ya wea yumpla po tri dei nau ane dempla nogad nating lept po kaikai. ");
INSERT INTO tcs_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ip ai go sane dempla go aus blo dempla ane no gibe dempla kaikai, dempla go blaikaut wea da rod prom anggre bikoz sam dempla bin kam ya prom longweiples.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nau dem klostuman blo Zizas i spik po em, ‘I nogad no aus ya klostu wea dis dezetples. Wea mipla go paine kaikai po pide dem plenti pipol ya?’ ");
INSERT INTO tcs_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Bat Zizas aske dempla, ‘Aumas bred yupla gad ya?’ Dempla spik, ‘Mipla gad seben loupbred ya.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nau Zizas em bin spik po ol dem pipol po sidaun daun wea graun. Den em bin teke dem bred ane luk go antap po God ane eso em po dem bred. Em broke dem bred ane gibem po dem klostuman blo em po seremaut wea dem pipol. ");
INSERT INTO tcs_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","I bin gad sam smol pis de wea dempla. So Zizas bin teke dem pis ane eso God, den ol dem klostuman blo Zizas bin seremaut dem kaikai po dem pipol tu. ");
INSERT INTO tcs_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ebriwan uda bin kaikai bin nadakain belipul. Dem leptoba kaikai bin pilemap seben basket pul. ");
INSERT INTO tcs_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Baut 4,000 pipol bin de wea Zizas uda bin kaikai. Nau wen Zizas i bin pinis sane ebriwan gobaigen po aus blo dempla, ");
INSERT INTO tcs_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Zizas ane dem klostuman blo em bin zamp insaid wea wan bot ane krosem go po da eria blo Dalmanuta. ");
INSERT INTO tcs_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Wen dem Parasi bin lisen Zizas bin kam de, dempla bin go po em ane stat graulem ane trai po trike em. So dempla bin aske em rapwei, ‘Yu soe mipla mirikalsain prom eben so mipla go bilib God bin sane yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Wen Zizas bin lisen wanem dempla bin tok, em bin lego bigwin, ane spik, ‘Wa! Yupla ebritaim wande luk mirikal! Ai spik trutok po yupla, ai nogo soe yupla no mirikalsain.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","So em bin zamp baik insaid da bot ane libe dempla de ane krosem go po da nadasaid blo da leik. ");
INSERT INTO tcs_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Bat dem klostuman blo Zizas bin piged po teke kaikai. Mata wan loupbred bin de insaid da bot. ");
INSERT INTO tcs_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Wen dempla bin krosem go nadasaid blo da leik, Zizas bin wone dempla, ‘Lugaut prom dem nugudwei blo dem Parasi ane King Erod. Dempla wase yis insaid wea bred.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Dem klostuman bin tingk ane tok po demplaselp diskain, ‘Ei, Zizas bin tok demkain bikoz mipla no bin teke bred kam.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Bat Zizas bin sabe wanem dempla bin tok so em i spik po dempla, ‘Yupla tumas wori po kaikai. Wattaim yupla go lan ane wattaim yupla go sabe? Yupla opene main blo yupla, so yupla ken sabe wanem ai tok. ");
INSERT INTO tcs_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yupla gad ai po luk, bat yupla blain. Yupla gad talinga po lisen, bat yupla dep. Yupla no kese nating ai bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Yupla no rimemba da taim wen ai bin pide dem 5,000 man wea paib loupbred a? Aumas bred bin leptoba ane aumas basket yupla bin pilemap?’ Dempla bin ansabaik, ‘Tuelb basket.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ane Zizas bin spik gen, ‘Wen ai bin pide 4,000 wea seben loupbred, aumas bred i bin leptoba ane aumas big basket yupla bin pilemap?’ Dempla bin ansa em baigen, “’Seben basket.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","So Zizas bin tok diskain po dem klostuman blo em, ‘Ei! Wiswei? Yupla stil no kesem wanem ai tok po yupla baut dem rong tising blo dem Parasi a?’ ");
INSERT INTO tcs_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wen dempla bin kesem de wea Betsaida, sam pipol bin teke dis blainman kam po Zizas ane dempla bin bege em po tase da man sole da man ken lukgen. ");
INSERT INTO tcs_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Zizas bin kese an blo da man ane lidem go ausaid prom dat biliz. Den em spet po da ai blo da man ane pute an blo em antap wea da man ane aske em, ‘Yu ken luk eniting nau?’ ");
INSERT INTO tcs_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Da man bin lukraun ane em spik, ‘Wa. Ai luk ol pipol bat ai kan luk dempla prapa klia. Dempla wase ol tri ya wagbaut raun.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Den Zizas bin pute an blo em gen wea da ai blo da man. Wen da man bin luk gen, ai blo em bin orait ane em ken luk ebriting nadakain klia. ");
INSERT INTO tcs_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Zizas bin tok strong po em diskain, ‘No wagbaut gobaigen po da biliz. Yu mata go aus.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Zizas ane ol dem klostuman blo em bin libe Galali ane dempla bin go antap po dem biliz blo Sizaria Pilipi. Wail dempla bin wagbaut go, Zizas bin aske dempla diskain, ‘Wanem ol pipol spikbaut mi? Uda mi?’ ");
INSERT INTO tcs_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Dempla bin ansa em baigen, ‘Sam spik yu Zon Baptaizman. Ol dem nadawan spik yu Ilaiza. Sam dem nadalot spik yu wan dem nada spesilmesizman blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Den em bin aske dempla, ‘Wanem yupla tingk uda mi?’ Pita bin ansa em, ‘Yu da Promiswan uda God bin sanem.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Zizas bin tok nadakain strong, ‘No yan po enibodi baut mi!’ ");
INSERT INTO tcs_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Den Zizas bin stat po spik po dem klostuman blo em diskain, ‘Ai, da Truwan blo Man, go sapa olkain nugudting. Ol dem Zuwiselda, dem edprist ane ol dem Zuwislotisa, ol i nogo wande mi ane ol i go kile mi, bat wea namba tri dei ai go kamlaipgen.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wanem Zizas bin tok po dem klostuman blo em, da tok bin nadakain klia. Den Pita bin tekem go wansaid ane spik po em, ‘BosLod, yu no mas tok demkain!’ ");
INSERT INTO tcs_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bat Zizas em i tanraun ane luk po dem klostuman blo em ane em tokstrong po Pita diskain, ‘Gedaut prom mi Satana. Wanem yu spik ya, yu noboda baut demting blo God. Yu tumas tingbaut demting wanem pipol i mekem.’ ");
INSERT INTO tcs_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Den Zizas bin singaut po dem klostuman blo em ane po dem bigmob pipol po kam po em ane lisen wanem em go tok. Zizas bin stat po tok diskain, ‘Orait nau. Ip eniwan wande pole mi, dempla mas redi po ded ane teke da kros blo dempla ane sapa wase mi. Ebridei dempla mas redi po gibap laip blo dempla po pole mi. ");
INSERT INTO tcs_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Dempla uda wande lugaut laip blo dempla, dempla go luze laip blo dempla poeba. Bat ip yupla go sapa ane ded po mi ane po da Gudniuz blo God, God go gibe yupla longlaip poeba. ");
INSERT INTO tcs_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Yupla tingk i go elpe enibodi ip dempla gad ebriting? Nono! Dempla nogo gede longlaip poeba! ");
INSERT INTO tcs_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","I nogad nating lo dis ert ken gibe yupla laip. ");
INSERT INTO tcs_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ip pipol i sem prom mi ane sem prom spik da mesiz blo mi wea dis nugudtaim nau wen ol pipol puse God wansaid, den ai, da Truwan blo Man, gobi sem prom dempla tu. Ai gobi sem prom dempla wen ai go kambaigen wea ol dem oli einzel ane da brait sainilait blo PapaGod blo mi ane da paua blo em.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Zizas kip spik po dempla, ‘Ai spik trutok po yupla, sam dem pipol uda stanap ya nau nogo ded. Ol go luk dat taim wen God i go kam ruloba ebriwan ane ebriting wea nadakain bigpaua.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Siks dei apta, Zizas bin teke Pita, Zemes ane Zon go antap wan ai maunten, nobodi de mata dempla. Den dem klostuman bin luk ngad blo Zizas i bin seinz. ");
INSERT INTO tcs_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ane klos blo em bin kam nadakain sainiwait, mowait den eniting ya wea dis ert. ");
INSERT INTO tcs_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Stretwei tu bipotaim spesilmesizman blo God, Ilaiza ane Mozes bin stanap de tok po Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita bin spik po Zizas, ‘Tisa, i gud yumpla ya. Kam, mipla go meke tri smolseid po yupla, wan po yu, wan po Mozes ane nadawan po Ilaiza.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Dem klostuman blo Zizas bin nadakain prait, daswai Pita no bin tingbaut wanem em bin spik, em mata tok. ");
INSERT INTO tcs_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wan klaud bin kam antap wea dempla ane kabare dempla. Ol bin lisen bois prom da klaud spik diskain, ‘Diswan mai Boi ane ai prapa labe em. Yupla mas lisen po em.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Stretwei wen dem klostuman blo Zizas bin luk gen, mata Zizas bin stanap de wea dempla. ");
INSERT INTO tcs_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wen dempla bin wagbaut godaun da maunten, Zizas spik po dempla diskain, ‘No spik nobodi wanem yupla bin luk. Yupla weit antil apta ai, da Truwan blo Man go gedap laipgen.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","So demplatri no bin spik nobodi baut wanem bin apen. Demplatri bin kip aske wananada wanem da mining blo dat tok wea Zizas i bin spik diskain wen em go laipgen. ");
INSERT INTO tcs_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nau dem klostuman blo Zizas askem diskain, ‘Aukam dem Zuwislotisa spik Ilaiza mas kambaigen pas bipo da Promiswan blo God i go kam?’ ");
INSERT INTO tcs_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Zizas bin ansabaik, ‘I tru. Ilaiza mas kam pas po meke ebriting redi. Aukam da Baibol i spik diskain, da Truwan blo Man go sapa plentiting ane ol nogo wande em? ");
INSERT INTO tcs_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ai spik yupla nau, Ilaiza em bin pinis kam. Ol man bin meke dem badting po em seimkain wiskain da Baibol i spik.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wen Zizas ane Pita, Zemes ane Zon bin kam klostu po dem nada klostuman blo Zizas, dempla bin luk bigmob pipol stanap raun lo dem nada klostuman ane dem Zuwislotisa bin de graul wea dempla. ");
INSERT INTO tcs_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wen dem pipol bin luk Zizas wagbaut kam, dempla bin nadakain atzamp ane ran go po mite em. ");
INSERT INTO tcs_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Zizas aske dem pipol, ‘Aukam yupla graul?’ ");
INSERT INTO tcs_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wan man prom dem pipol bin spik po Zizas diskain, ‘Tisa. Ai bin teke boi blo mi kam po yu. Em gad wan nugudspirit insaid wea em ane dat spirit i stapem prom tok. ");
INSERT INTO tcs_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ebritaim dat nugudspirit tekoba em, da nugudspirit sakem adwan godaun po da graun. Ol spet bin kamaut prom maut blo em ane em graine tit blo em ane em kam stip. Ai bin aske dem klostuman blo yu po tekemaut dis nugudspirit bat dempla kan tekemaut prom boi blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Zizas bin spik diskain, ‘Yupla nadakain! Yupla no bilib. Aulong ai bin stap ya wea yupla ane yupla stil no tekenotis wei blo mi. Orait. Teke da boi kam po mi.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Dempla bin teke da boi kam po em. Bat wen da nugudspirit bin luk Zizas, da nugudspirit bin meke da boi seik nadakain ane da boi bin poldaun. Em bin rol ebriwei wea da graun ane em bin gad ol spet kamaut prom maut blo em. ");
INSERT INTO tcs_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Zizas aske da papa blo da boi, ‘Aulong da boi blo yu bin demkain?’ Da papa blo da boi bin ansabaik, ‘Em bin ebritaim diskain prom wen em bin smolboi. ");
INSERT INTO tcs_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Da nugudspirit ebritaim meke da boi poldaun antap wea paia o sake em insaid wea wata, trai po kile em. Bat ip yu ken meke eniting, plizgar soe sorewei po mitu ane elpe mi ane boi blo mi!’ ");
INSERT INTO tcs_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Zizas bin spik po papa blo da boi, ‘Watpo yu spik diskain, “Ip ai ken meke eniting?” Eniwan uda gad bilib wea God, i ken meke eniting.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Stretwei da papa blo da boi bin ansabaik, ‘Ai gad bilib, bat plizgar, elpe mi po bilib mo.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Orait. Wen Zizas bin luk ol dem pipol kam mo tumas, em tok strong po da nugudspirit ane oda em diskain, ‘Ei nugudspirit blo dep ane dam, ai spik yu nau, kamaut prom em ane nogo insaid wea em gen.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Stretwei da nugudspirit bin skrim laudwan. Em bin meke da boi seik nadakain den da nugudspirit bin kamaut prom da boi. Da boi bin leidaun de slaikwan, luklaik em ded. Ol dem pipol de raun bin smolsmoltok po wananada diskain, ‘Ei, em i ded ai tingk!’ ");
INSERT INTO tcs_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bat Zizas bin kese an blo da boi ane elpe em po stanap ane da boi bin stanap gudwan. ");
INSERT INTO tcs_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Apta nau wen Zizas ane klostuman blo em bin go insaid wan aus, dem klostuman blo em bin askem kuaiatwan, ‘Aukam mipla kan tekemaut da nugudspirit prom da boi?’ ");
INSERT INTO tcs_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Zizas bin ansa, ‘Ip yupla wande tekemaut diskain nugudspirit, yupla mas pasting ane prea.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Zizas ane dem klostuman bin libe dat eria ane dempla bin wagbaut go tru Galali. Zizas no bin wande ol pipol po sabe wea em wagbaut ");
INSERT INTO tcs_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","bikoz em wande spene taim tise dem klostuman blo em. Den Zizas bin spik po dempla, ‘Sam pipol go sele mi, da Truwan blo Man, po dem enami blo mi. Ol go kile mi, bat wea namba tri dei ai go kam laipgen.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Dempla no bin kesem wanem em i min. Dempla bin prait po aske Zizas po eksplein wanem da mining blo dem tok blo em. ");
INSERT INTO tcs_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Apta nau, dempla bin kese taun blo Kapaniam ane dempla bin stap de wea wan aus. Zizas bin aske dempla, ‘Wen yumpla bin wagbaut kam, wanem yupla bin smolsmoltok baut?’ ");
INSERT INTO tcs_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bat ol bin stap kuaiat, no ansa em. Dempla bin graul baut uda da nambawan man melen wea dempla. ");
INSERT INTO tcs_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Zizas bin singaut po dem klostuman blo em po kam sidaun wea em. Em spik, ‘Eniwan uda wande kam nambawan man, em mas bi da nambalas man ane meke emselp sebant blo ebriwan.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Den Zizas bin teke wan pikinini ane meke em stanap melen wea dempla. Den em bin pikemapem ane bin spik po dempla diskain, ");
INSERT INTO tcs_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","‘Eniwan uda labe dem smolpikinini wea neim blo mi, dempla labe mi tu. Ane eniwan uda labe mi, dempla labe PapaGod blo mi uda bin sane mi kam.’ ");
INSERT INTO tcs_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Zon bin spik po Zizas, ‘Tisa, mipla bin luk wan man, em bin yuze neim ane paua blo yu po pose dem nugudspirit po kamaut prom sam pipol. Mipla bin spik po em, “Yu no lau po meke disting bikoz yu no blo mipla.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Zizas bin spik, ‘Yupla no stape em. Enibodi uda meke mirikal wea neim ane paua blo mi, em nogo spik nugudting baut mi. ");
INSERT INTO tcs_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Enibodi uda nogo gense yupla, go sapot yupla. ");
INSERT INTO tcs_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yupla lisen nau. Ai spik trutok po yupla, ip enibodi go gibe yupla iben wan smol kap wata po dringk bikoz yupla blo mi, dat man i go gede riwod prom God. ");
INSERT INTO tcs_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‘Bat ip eniwan prom dem smolpikinini ya, bilib mi ane sambodi spik dempla no po bilib mi, mobeta po datwan po taite big ston raun wea nek blo em ane sake emselp insaid wea dipwata. ");
INSERT INTO tcs_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ip an blo yu i meke yu po meke nugudting, katemautem. I mobeta po go antap eben wea wan an den po go insaid el wea tu an, wea da paia i mata ban. ");
INSERT INTO tcs_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","45","Ip leg blo yu i meke yu po meke nugudting, katemautem. I mobeta po go antap eben wea wan leg den po go insaid el wea tu leg. ");
INSERT INTO tcs_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","47","Ip ai blo yu i meke yu po meke nugudting, tekemautem. I mobeta po go antap po dat ples wea God i ruloba ebribodi wea wan ai, den po go insaid el gad tu ai. ");
INSERT INTO tcs_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","De wea el, dem wom go kaikai dem pipol poeba ane da paia i go mata ban. ");
INSERT INTO tcs_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘I gobi ad, God go teste ebriwan wea paia ip dempla bin meke ubi blo God. ");
INSERT INTO tcs_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Solt i gud antap wea kaikai, bat ip da solt i luze tes i gobi nugud. Laip blo yupla mas bi wase gud solt, gud. Bat ip yupla no kip da gudwei, yupla go luzem wase solt i nogad tes. So yupla mas pole da gudwei ane meke pis wea wananada.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Den Zizas bin libe Kapaniam ane bin godaun po da eria blo Zudia ane den em bin go po da nadasaid blo Zodan Riba. Ane de gen i bin gad ol bigmob pipol raun wea Zizas ane em bin lane dempla de. ");
INSERT INTO tcs_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Sam Parasi bin kam de po Zizas ane trai po mekem tok rong. Dempla bin aske em, ‘Ei! Wiswei? Ken eni man dibos oman blo dempla a?’ ");
INSERT INTO tcs_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","So Zizas bin ansa, ‘Wanem Mozes bin spik po yupla baut dibos?’ ");
INSERT INTO tcs_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Dempla bin spik po Zizas diskain, ‘Mozes bin laue man po dibos solong da man gibe da oman dibos peipa ane spik da oman po go.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Zizas bin spik, ‘Wa. Bikoz yupla tumas stronged, daswai Mozes bin laue yupla po mekem diskain. ");
INSERT INTO tcs_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Prom da stat blo da wold, God bin meke man ane oman. ");
INSERT INTO tcs_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Daswai, man i libe papa ane mama blo em ane zoin wea oman blo em ");
INSERT INTO tcs_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ane demtu kamwan. So demtu nomo tu separeit pipol nau bat wan. ");
INSERT INTO tcs_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ip God bin zoine demtu tugeda den lete nobodi separeit demtu.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Apta nau wen dempla bin gobaigen po aus, dem klostuman bin aske Zizas mo baut disting. ");
INSERT INTO tcs_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Den Zizas bin spik diskain, ‘Ip eni man libe oman blo em ane maret nada oman, em broke maretlo blo God. ");
INSERT INTO tcs_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Seimwei, wen eni oman libe man blo em ane maret nada man, em broke maretlo blo God tu.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wantaim, ol pipol bin teke ol pikinini kam po Zizas bikoz dempla bin wande Zizas po tase dem pikinini. Bat wen dem klostuman bin luk ol dem pikinini, dempla bin spik, ‘Nono. Yupla no lau po teke dem pikinini kam.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wen Zizas i bin luk wanem dem klostuman bin mekem, em bin wail. Em bin spik po dempla diskain, ‘Yupla no stape dempla prom kam po mi. Lete dempla kam bikoz dat ples wea God ruloba ebriwan i blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ai spik trutok po yupla, enibodi uda nogad bilib wase pikinini ane no gri dat God em ruloba ebriwan, em no blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Den Zizas bin kese dem pikinini klostu ane pute an antap wea ed blo dempla ane blese dempla. ");
INSERT INTO tcs_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Zizas bin go ausaid prom dat aus redi po go po nada biliz wen wan man bin ran kam ane broke ni prant wea Zizas ane askem diskain, ‘Gudtisa. Wiskain ai go gede longlaip poeba?’ ");
INSERT INTO tcs_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Zizas bin ansa em, ‘Ei! Wanem po yu kole mi gud? Nobodi gud, mata God i gud. ");
INSERT INTO tcs_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yu sabe dem lo blo God. Yu mas no kile man, no broke maretlo, no stil, no spik laitok baut enibodi o eniting, no mekpul, ane sit ane lai wananada. Ane yu mas ona papa ane mama blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Bat dis man bin spik, ‘Tisa, ai bin meke demting. Ai bin pole ol dem lo blo God prom wen ai bin yangboi.” ");
INSERT INTO tcs_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Zizas bin luk po dis man ane em bin gad lab po em. Zizas spik po em, ‘Wa! Bat yu mise samting. Yu mas sele ebriting blo yu ane seremaut ebri mani po ol dem poapipol. Den yu go gad gudting wea eben. Den yu kam ane pole mi.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wen em bin lisen wanem Zizas bin spik, ngad blo em bin seinz. Em bin sluraun ane gowei nadakain sore, bikoz em bin prapa risman. ");
INSERT INTO tcs_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Zizas bin lukraun po ol dem klostuman blo em ane spik, ‘Wa! I prapa ad po dem rispipol po go po dat ples wea God i ruloba ebribodi!’ ");
INSERT INTO tcs_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Dem klostuman bin atzamp wen ol bin lisen dis tok blo da BosLod. Bat Zizas i tok gen, ‘Mai pren. I prapa ad po go eben! ");
INSERT INTO tcs_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Wa! I moizi po big weil po go insaid aus blo kreipis den po rispipol po go po dat ples wea God i ruloba ebribodi.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Wen dem klostuman bin lisen, ol bin atzamp ane smolsmoltok po wananada, ‘Ei! Wiswei? Ip i diskain ad po go eben, wel uda gobi seib?’ ");
INSERT INTO tcs_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Zizas bin luk stret po dempla ane spik, ‘Pipol prapa kan mekem. Mata God i ken mekem. God ken meke ebriting.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Den Pita bin spik, ‘Mipla bin libe ebriting po pole yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Zizas bin ansa dempla, ‘Ai spik yupla trutok. Yupla uda libe aus blo yupla, libe bala, sisi, papa ane mama, pikinini ane gadan blo yupla po pole mi ane da gudniuz, ");
INSERT INTO tcs_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","wel God go gibe yupla plenti mo, andred mo wea dis laip. God go gibe yupla aus ane bala, sisi, mama, pikinini ane gadan. Ol pipol go meke nadakain nugudpasin gense yupla bat yupla go gad longlaip poeba wea eben. ");
INSERT INTO tcs_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bat lisen gud nau. Sam pipol uda bigman nau, ol gobi nambalas. Sam pipol uda louklas nau, ol gobi prapa nambawan.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Orait nau. Zizas ane klostuman blo em bin wagbaut go po Zarusalem ane Zizas bin wagbaut go pas prant wea dempla ebriwan. Zizas bin mata lego go pas ane dem pipol uda bin kam biain wea dem klostuman ol bin prapa akan. Den Zizas bin teke dem tuelb klostuman blo em go wansaid ane em bin spik po dempla ebriting wanem i go apen po em insaid wea Zarusalem. ");
INSERT INTO tcs_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Em bin spik po dempla, ‘Wen yumpla go kese Zarusalem, sambodi go sele da Truwan blo Man po dem edprist ane dem Zuwislotisa. Dempla go zaze em po kile em ane ol gibe em po dem lida blo Rom. ");
INSERT INTO tcs_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ol go meke pan ane moke em, spet lo em, plokem wea wip blo dempla ane kilem. Bat wea namba tri dei em go kamlaipgen.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Den demtu boi blo Zebadi, Zemes ane Zon, bin wagbaut kam klostu po Zizas ane spik po em diskain, ‘Tisa. Mitu aske yu ip yu ken meke samting po mitu gar.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Zizas ansa, ‘Orait, wanem yutu wandem?’ ");
INSERT INTO tcs_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","’Insaid wea da Saini Truglori wea God go ruloba ebriwan, mitu wande sidaun de wea yu, wan wea leptsaid ane nadawan wea raitsaid.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Zizas bin ansa, ‘Ei! Yutu no sabe wanem yutu askem. Yutu tingk yutu ken go tru dat sore wea ai mas go tru? Yutu tingk yutu ken sapa wiskain ai go sapa?’ ");
INSERT INTO tcs_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","‘Wa! Mitu ken’, demtu bin ansa em. Den Zizas bin spik po demtu, ‘I tru wanem yutu spik. Yutu go go tru da sore wanem ai go go tru ane sapa wase mi. ");
INSERT INTO tcs_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bat ai nogad no rait po spik uda go sidaun wea rait o leptansaid blo mi. God meke da ples po demwan uda em go suzem.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wen dem nada ten klostuman blo Zizas bin lisen wanem Zemes ane Zon bin askem, dempla bin nadakain wail. ");
INSERT INTO tcs_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Zizas bin singaut po dem klostuman po kam tugeda. Em bin spik, ‘Dem bigbos blo dis wold yuze paua blo dempla rongwei. Yupla sabe ol king meke demplaselp wase bigbos blo ebriwan. Dempla meke adlaip po ebribodi uda andanit wea dempla. ");
INSERT INTO tcs_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bat yupla mas no mekem demkain. Yupla uda wande bi bigman, yupla mas meke gudpasin. Yupla mas bi sebant blo ebribodi. ");
INSERT INTO tcs_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ane eniwan uda wande meke emselp nambawan, em mas serbe ol pipol wase sleib. ");
INSERT INTO tcs_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nomata ai Truwan blo Man, ai no bin kam po meke ol pipol wok po mi, ai bin kam po wok po dempla. Ai bin kam po dis wold po ded po ebriwan. Diswan i prais ai go pei po seibe ebriwan prom dem nugudwei wanem dempla bin mekem.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Orait. Dempla bin kese taun blo Zeriko. Apta nau, wen Zizas ane klostuman blo em bin libe dat taun tumas ol pipol bin pole dempla biain. Wan blain begaman, Batimas, boi blo Timas bin sidaun klostu da rod seimtaim wen Zizas bin pas. ");
INSERT INTO tcs_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wen Batimas bin lisen dem pipol spik Zizas blo Nazaret em klostu nau, em bin singaut prapa laudwan, ‘Zizas! Yu Promiswan wase King Deibid! Plizgar soe sorewei po mi ane elpe mi!’ ");
INSERT INTO tcs_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Sam dem pipol bin ala, ‘Sadap, stap kuaiat!’ Bat em no bin lisen, em kip singaut molaud, ‘Zizas! Yu Promiswan wase King Deibid! Plizgar soe sorewei po mi ane elpe mi!’ ");
INSERT INTO tcs_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Wen Zizas bin lisen em, em bin stap prom wagbaut ane em bin spik, ‘Singaut em kam ya!’ So dempla bin singaut diskain po da blainman, ‘Ei yu, Batimas! Gedap kam ya. Zizas i singaut po yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Em bin gedap kuikwan sakwei blangket blo em ane em bin ran go po Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Den Zizas bin askem, ‘Wanem yu wandem?’ Da blainman bin ansa, ‘Tisa, ai blain. Ai kan luk. Plizgar, elpe mi po lukgen.’ ");
INSERT INTO tcs_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Zizas bin spik po em, ‘Bikoz yu bin bilib wea mi, yu gud nau. Go aus.’ Stretwei da blainman bin luk bat em no bin go aus, em pole dempla uda bin pole Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wen Zizas ane klostuman blo em bin kam klostu po Zarusalem, dempla bin pase tu biliz, Betpas ane Betani wea said blo Maunt Olibtri. Zizas bin sane tu klostuman blo em go pas. ");
INSERT INTO tcs_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Em bin spik po demtu, ‘Yutu go pas po da nada biliz ane wen yutu go insaid dat biliz, yutu go paine wan yang dongki bin taiemapem de ane nobodi bin raide dis dongki bipo. Teke da dongki kam ya po mi. ");
INSERT INTO tcs_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ip enibodi i aske yutu wanem yutu mekem, yutu spik dempla diskain, “Da BosLod i wande dis dongki ane em go sanem kambaik apta.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Demtu bin go ane paine da dongki stanap de, taiemap wea wan aus ane da aus i no longwei prom da rod. ");
INSERT INTO tcs_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","So demtu bin stat po tekemautem. Sam pipol uda bin stanap de aske demtu, ‘Ei! Wanem yutu mekem? Watpo yutu tekemaut da dongki?’ ");
INSERT INTO tcs_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Demtu bin ansa, ‘Da BosLod wandem ane em go sanem kambaigen apta.’ So dem pipol bin laue demtu po teke da dongki. ");
INSERT INTO tcs_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nau demtu klostuman bin teke da dongki kam po Zizas ane dempla bin pute sam kaliko blo dempla antap baik blo da dongki ane Zizas bin sidaun antap wea da dongki. ");
INSERT INTO tcs_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Dem bigmob pipol de wea Zizas bin prapa glad ane ol bin wande ona em. So dempla bin spredemaut ol kaliko wea da rod prant wea Zizas ane nadalot bin kate ol lip ane sakem prant wea da rod po soe ona po em. ");
INSERT INTO tcs_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Zizas bin raid melen wea dem bigmob pipol ane dempla bin singaut preiz po God: ‘Ozana, liptemap neim blo God!’ ‘Blese dis Promiswan ya, uda kam wea da neim blo da AntapGod!’ ");
INSERT INTO tcs_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","‘Blese da wan uda go ruloba mipla wase bigate Deibid uda bin king blo mipla.’ ‘Ozana, liptemap neim blo God de antap lo eben!’ ");
INSERT INTO tcs_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wen Zizas bin kese Zarusalem em bin go po da Tempol blo God ane em bin luk ebriting adwan wanem ol dem pipol bin mekem de. Bat bikoz i bin klostu po dak, Zizas ane dem tuelb klostuman blo em bin gobaigen po Betani. ");
INSERT INTO tcs_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Da neksdei wen Zizas ane dem klostuman blo em bin kamaut prom Betani, anggre bin kese Zizas nau. ");
INSERT INTO tcs_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ane em bin luk wan pruttri lelbet longwei prom de, i bin gad plenti lip. So em bin go po lukraun prut wea da tri. Bat wen em i kam klostu po da tri, i no bin gad prut, mata ol lip bikoz i no bin taim po da tri po sake ol prut. ");
INSERT INTO tcs_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Den Zizas i sake tok po da tri, ‘Ei tri! Yu nogo sake prut gen!’ Ane dem klostuman blo em bin lisen wanem Zizas bin spik po da tri. ");
INSERT INTO tcs_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wen Zizas ane klostuman blo em i bin kesem de baigen wea Zarusalem, dempla bin go insaid da yad blo da Tempol blo God. Wen Zizas bin luk nau, em bin wail bikoz plenti pipol de bin meke rongting. Dempla bin meke pipol pei big prais po ol dem sakripais ting. Em bin stat sesewei dem man uda bin meke mani po goaut prom de. Zizas bin tanoba dem mani teibol blo dem man uda bin meke plenti mani, stilawei prom dem pipol, ane em bin tanoba dem stol blo dem man uda bin sele pizin. ");
INSERT INTO tcs_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Zizas bin stape ol dem pipol uda bin wagbaut sotkat tru da Tempol blo God kare ol samting blo dempla go po da maketples. ");
INSERT INTO tcs_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Den em bin tise dempla diskain, ‘Yupla lisen. Baibol i spik, “Aus blo mi i aus blo prea po ebriwan”, bat yupla bin meke dis ples wase aus blo roba.’ ");
INSERT INTO tcs_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wen dem edprist ane Zuwislotisa bin lisen wanem Zizas bin mekem, dempla bin stat po tingbaut po paine wei po kile em bikoz dempla bin zeles em. Dempla prait Zizas go gad tumas paua oba dem pipol, bikoz dem pipol bin prapa rispekt Zizas ane ol bin glad po lane demting wanem em bin tise dempla. ");
INSERT INTO tcs_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wen i bin stat kam po dak, Zizas ane ol klostuman blo em bin gobaik po Betani. ");
INSERT INTO tcs_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Elimoning Zizas ane dem klostuman bin gobaigen po Zarusalem wea da seim rod ane ebriwan bin luk dat pruttri i ded, dem rut bin prapa drai. ");
INSERT INTO tcs_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Wen Pita bin luk, em bin rimemba wanem Zizas bin spik po da tri. Pita bin spik, ‘Ei, Tisa luk! Da tri yu bin tok po yestidei, i ded nau!’ ");
INSERT INTO tcs_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Den Zizas spik po dem klostuman, ‘Yupla mas bilib wea God. ");
INSERT INTO tcs_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ai spik trutok po yupla, ip yupla bilib God, yupla ken spik po dis maunten, “Sake yuselp insaid solwata,” ane da maunten go mekem wanem yu spik. Bat ip yupla no bilib wea God, i nogo apen. ");
INSERT INTO tcs_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lisen po mi! Yupla ken prea po eniting ane ip yupla bilib, God go gibe demting po yupla ane yupla go gad. ");
INSERT INTO tcs_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ane wen yupla prea ane yupla rimemba dem nugudwei nada man bin mekem po yupla, yupla mas pogibe em bipo PapaGod blo yupla wea eben go pogibe nugudwei blo yupla. ");
INSERT INTO tcs_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ip yupla no pogibe nada man, PapaGod blo yupla wea eben nogo pogibe yupla po dem nugudwei yupla bin mekem.’ ");
INSERT INTO tcs_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wen Zizas ane klostuman blo em bin kese Zarusalem, dempla bin go po da Tempol blo God ane Zizas bin wagbaut ane tise dem pipol wea da yad blo da Tempol. Sam edprist, sam Zuwislotisa, ane sam dem Zuwislida bin kam po tok po Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Dempla spik diskain po em, ‘Uda bin gibe yu da rait po kare lo po spik po dem pipol? Uda bin gibe yu da rait po meke demting ya wea dis Tempol?’ ");
INSERT INTO tcs_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Zizas i ansa, ‘Ai go aske yupla wan kuestin ane ip yupla go ansa mi, den ai go spik po yupla uda bin gibe mi da rait po kare lo po meke demting ");
INSERT INTO tcs_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yupla ansa mi. Wen Zon bin baptaiz ol pipol, wanem rait em bin gad? Dat rait i bin kam prom God o i bin kam prom man, a?’ ");
INSERT INTO tcs_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Dempla bin tok po wananada, ‘Wiskain yumpla go ansa em baik? Ip yumpla go spik, “God bin sane Zon,” den em go spik baigen po yumpla, “Ip God bin sane Zon den aukam yupla no bin bilibe Zon?” ");
INSERT INTO tcs_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Bat yumpla go gede trabol ip yumpla go spik, “Diswan no blo God.” ’ Dem Zuwislida bin prait prom ol dem pipol de ol mait go meke big trabol wea dempla, bikoz dem pipol bin bilib Zon em i da spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Dempla bin ansa Zizas diskain, ‘Mipla no sabe uda bin gibe Zon da rait po baptaiz dem pipol.’ So nau Zizas ansa dempla baigen, ‘Wel, ai nogo spik yupla uda bin gibe mi da rait po meke demting.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Den Zizas bin yan ol nada stori wea i gad mining. ‘Wan man bin plante gadan blo greipbain. Em bin bilde stonwol raun wea da gadan ane em bin meke big oll po smase dem greip po meke wain. Den em bin bilde ston taua solong man ken stanap de antap po gade da gadan. Em bin rente dis gadan po sam man, den em bin gowei po nada kantri. ");
INSERT INTO tcs_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Da taim bin kam po broke ol dem greip po selem. Da prapa ouna blo da gadan bin sane wan wokman blo em kam po gede da rentmani prom dem pipol uda bin rente dat gadan. ");
INSERT INTO tcs_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Bat dem man bin ploke dat wokman ane sanem gobaigen, gad nating. ");
INSERT INTO tcs_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","‘Den em bin sane nada wokman ane dempla bin ite em wea ed ane meke nadakain badpasin po em. ");
INSERT INTO tcs_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","So apta, em bin sane namba tri wokman go nau, ane dempla uda bin rente da gadan bin kile em. Em bin sane plenti mo wokman go. Sam prom dem wokman bin ploke sam wokman nadakain ad ane bin kile nadalot. ");
INSERT INTO tcs_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","So nau da ouna blo da gadan no bin gad enimo wokman lept, mata boi blo em, ane dis boi, em bin prapa labe em. So da ouna bin sane em go. Em bin tingk diskain, “Ai go sane boi blo mi. Dempla go rispekt em.” ");
INSERT INTO tcs_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","‘Bat nau, dem man uda bin rente da gadan, wen ol bin luk da boi blo da prapa ouna bin kam de po dempla, dempla bin tok po wananada, “Ei! Diswan da bigboi blo da ouna. Em go gede dis propati wen papa blo em go ded. Ip yumpla kile em, wel dis propati gobi blo yumpla.” ");
INSERT INTO tcs_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","So dempla bin kile em ane sakem ausaid prom da gadan.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","So Zizas bin aske dempla, ‘Wanem yupla tingk dat ouna blo da gadan go mekem po dempla? Ai go spik yupla. Em go kambaik ane kile dem man ane rente da gadan po ol nada man. ");
INSERT INTO tcs_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yupla no bin ride dis tok wea i bin raitem wea Baibol a? “Diswan da timba ol dem kapenta no bin wandem, bat nau em da meintimba, po olde da rup po meke em strong. ");
INSERT INTO tcs_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","AntapGod i meke dis mina gudplan ane mipla prapa api po luk dis plan.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Dem Zuwislotisa ol bin wande kese Zizas bikoz dempla bin sabe Zizas pointe pingga po dempla wea dem stori em bin yan baut dem nugudpama. Bat dempla no bin kese Zizas bikoz dempla bin prait prom dem pipol. So dem Zuwislotisa bin libe Zizas ane ol bin gowei. ");
INSERT INTO tcs_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Apta nau, dempla bin sane sam Parasi ane sam sapota blo da Zuwis king. Neim blo em Erod. Dempla ol spai. Dempla bin kam po trai po trike Zizas po spik rongtok so dempla ken kese em, teke em go po kot. ");
INSERT INTO tcs_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","So dempla bin askem, ‘Tisa. Mipla sabe yu prapa stretman. Yu trite ebriwan wea seim rispekt nomata uda. Ane yu tise mipla da truwei baut wanem God wande ol pipol po mekem. ");
INSERT INTO tcs_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yu spik mipla wiswei, ip i rait po pei taksmani po da bigking blo Rom o no?’ Bat Zizas bin sabe dempla trai po trike em. Em ansa dempla baigen, ‘Ei! Yupla trai po trike mi wea ol sili kuestin blo yupla a? Soe mi wan koin blo Rom ane ai go spik po yupla.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wen dempla bin gibe da mani po em, em bin aske dempla, ‘Uda ed ane neim i stap wea dis koin?’ Dempla bin ansa em, ‘Da bigking blo Rom.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Den Zizas bin spik po dempla, ‘Gibe da bigking wanem blo em, ane gibem po God wanem blo God.’ Dis ansa blo Zizas bin meke dempla atzamp. ");
INSERT INTO tcs_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sam Zuwislotisa uda bin kole demplaselp Sadusi, ol bin kam po Zizas. Dempla no bilib God go meke ol ded pipol kamlaipgen. ");
INSERT INTO tcs_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Dempla bin aske Zizas, ‘Tisa. Mozes bin raitem diskain wea lo blo em. “Ip wan man bala ded ane em libe oman blo em nogad pikinini, bala blo em mas maret dat widooman. Dem pikinini uda gobi bon prom dat widooman, gobi pikinini blo dat ded bala.” ");
INSERT INTO tcs_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wantaim i bin gad seben bala. Da paswan i bin maret ane em bin ded, nogad pikinini. ");
INSERT INTO tcs_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nau da sekan bala, em bin maret da widooman blo dat bigbala blo em. Den em bin ded tu, nogad pikinini, ane da seimting i bin apen wea da namba tri bala. ");
INSERT INTO tcs_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Bambai nau ol seben bala bin maret da oman ane dempla ebriwan i bin ded nogad pikinini. Apta nau da oman bin ded tu. ");
INSERT INTO tcs_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tisa, yu spik mipla. Wiswei? Wen da dei go kam wen ol dem ded pipol go kamlaipgen, em gobi oman blo uda? Ebridem seben bala bin maret em.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Zizas bin ansa dempla, ‘Da trabol blo yupla, i yupla no sabe nating baut Baibol, ane yupla no sabe nating baut da paua blo God. Daswai yupla lane ol rong tising. ");
INSERT INTO tcs_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wen ebribodi go kambaigen laip, dempla nogo maret. Dempla gobi seimkain wase dem einzel wea eben. ");
INSERT INTO tcs_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","‘Nau ai go eksplein baut wen ol dem pipol go kambaigen laip. Yupla bin rid wanem Mozes bin raitem wea Baibol da stori wea da bus i ban. De, God bin spik po Mozes diskain, “Ai da AntapGod blo Eibram, Aizak ane Zekop.” ");
INSERT INTO tcs_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","So, God em God blo ol laip pipol. Em no God blo ol ded pipol. Yupla rong.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wan prom dem Zuwislotisa bin lisen wanem dempla bin tok. Em bin rilaiz Zizas bin gibe dempla gud ansa so em bin aske Zizas kuestin, ‘Wanem da nambawan lo blo God prom dem nada lo blo em?’ ");
INSERT INTO tcs_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Zizas bin ansa, ‘Pas nambawan lo blo God i diswan: “Yupla ebriwan blo Izrael lisen gud! Da AntapGod blo yumpla, em da tru AntapGod. ");
INSERT INTO tcs_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Labe da AntapGod wea olgeda at blo yupla, ane olgeda laip blo yupla, ane olgeda sens blo yupla, ane olgeda strong blo yupla.” ");
INSERT INTO tcs_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ane da sekan lo i prapa impotant wase da pas lo. “Labe kantriman blo yupla wiskain yupla labe yuplaselp.” Ol dem nada lo blo God i no prapa impotant wase dis tu lo blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Da Zuwislotisa bin ansa, ‘Tisa i gud wanem yu spik. I tru wen yu spik da AntapGod blo yumi, em i LodGod, da God blo ebribodi. ");
INSERT INTO tcs_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ane ai sabe i prapa impotant po labe da AntapGod wea olgeda at blo mi ane olgeda sens blo mi ane olgeda strong blo mi ane ai mas labe neiba blo mi wiskain ai labe maiselp. I mo impotant po labe God den po bane ol sakripais ane meke opring wanem da Mozeslo i spik.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wen Zizas bin lisen da waiztok blo dis man em bin spik po em, ‘Yu tingk raitwei. Yu klostu po pole wei blo God.’ Apta nau, dem Zuwislotisa bin gibap bikoz ol kan trike em ane ol bin prait po aske mo kuestin. ");
INSERT INTO tcs_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","So Zizas bin kip tok wea dem pipol de wea da Tempol blo God. Em bin aske dempla, ‘Aukam dem Zuwislotisa spik diskain, da Promiswan uda God i go sanem kam, i gobi boi blo King Deibid? ");
INSERT INTO tcs_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Da OliSpirit bin tok po Deibid insaid tot blo em. Em bin spik diskain: “Da AntapGod bin spik po da BosLod blo mi, Sidaun ya wea raitansaid blo mi, da ples blo ona antil ai go pute dem enami blo yu andanit kontrol blo yu.” ");
INSERT INTO tcs_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","‘Ip King Deibid bin kole da Promiswan uda God i sanem kam, BosLod, den auken da Promiswan bi boi blo em? Nono, i kan!’ Ane dem pipol bin lisen po Zizas prapa gud. ");
INSERT INTO tcs_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Wail ebribodi bin de lisen po Zizas, em bin spik po ol klostuman blo em, ‘Lugaut prom dem Zuwislotisa. Dempla wande pipol po tingk dempla prapa impotant. So dempla were ol dem long plasklos blo prist po stail, prant wea ol dem pipol. Dempla prapa laik wen pipol grite dempla wea rispekt prant wea ebribodi, so pipol go tingk dempla impotant. ");
INSERT INTO tcs_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","‘Dempla wande ol dem spesil sea blo ona wea zuwispreaus, ane dem spesil sea blo ona wea pisting. ");
INSERT INTO tcs_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Dem Zuwislotisa spik po dem widooman, dempla go lukapta ol samting blo dempla, bat ol trike dem widooman. Ol teke ebriting po demplaselp. Den dempla meke ol long prea po kabarap po dem rongting dempla bin mekem. Dempla blape ol pipol dempla meke raitting, bat dempla go gede prapa mobig panisment den enibodi.’ ");
INSERT INTO tcs_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Zizas bin mata wase dem rispipol uda bin pute big mani wea dat koleksin boks blo da Tempol blo God. ");
INSERT INTO tcs_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Den em bin luk wan widooman, uda nogad mas mani. Em bin pute tu smol koin insaid da boks. ");
INSERT INTO tcs_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Zizas bin singaut dem klostuman blo em ane spik po dempla, ‘Ai spik trutok po yupla, dis widooman uda nogad mas mani, em bin gibe moden ol dem rispipol, bikoz em bin gibe ebriting em gad. ");
INSERT INTO tcs_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Dem rispipol bin gibe lelbet mani prom dem mani dempla no nidem. Bat dis widooman ya, em prapa poa. Em bin gibe ebri mani blo em wanem em gad. Em gad nating nau.’ ");
INSERT INTO tcs_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Seimtaim nau wen Zizas bin redi po kamaut ane libe da Tempol blo God, wan klostuman blo em bin spik, ‘Tisa, luk dem bilding blo da Tempol, i prapa plas ane dem ston wea dem wol i prapa big.’ ");
INSERT INTO tcs_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Zizas bin spik po dempla, ‘Dat taim go kam wen dis prapa plas Tempol go poldaun plat, lebel wea graun. No iben wan ston go stap antap wea nada ston.’ ");
INSERT INTO tcs_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Apta nau, Zizas bin sidaun wea Maunt Olibtri wea da gadan blo dem olibtri ane em bin luk go kros da bali po da Tempol. Pita, Zemes, Zon, ane Andru bin kam tok kuaiatwan po em. ");
INSERT INTO tcs_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Dempla askem, ‘Tisa, yu spik mipla. Wattaim demting go apen po da Tempol? Wiswei mipla go luk gudsain, so mipla sabe demting go apen a?’ ");
INSERT INTO tcs_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Zizas i eksplein po dempla, ‘Yupla mas lugaut yuplaselp. No lete enibodi blape yupla dat dempla i go spik dat dempla i da Promiswan uda God i bin sanem kam. Ip enibodi spik yupla diskain, no bilib ane pole dempla. ");
INSERT INTO tcs_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ane nugud woa go stat ebriwea wea dis wold, bat yupla no akan. Wa, demting mas apen, bat da end blo da taim i nogo pinis yet. ");
INSERT INTO tcs_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ol neisin go paite wananada ane ol kantri go gense wananada ane i go gad olkain nadakain big ertseik wea ol dipren ples blo da wold ane plenti pipol go ded prom anggre. Bat diswan i mata da stat blo dem nadakain badting wen ol go kam. ");
INSERT INTO tcs_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Bat wen dem nadakain badting go kam, lugaut! Dempla go kese yupla ane teke yupla po kot ane belte yupla insaid wea dem zuwispreaus, bikoz yupla pole mi. Dempla go trite yupla prapa nugudwei ane pose yupla po stanap prant wea ol gabana ane ol king. Diswan i gobi sans blo yupla po spik dempla baut mi. ");
INSERT INTO tcs_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ane yupla mas prise da Gudniuz baut mi po ebri neisin. ");
INSERT INTO tcs_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Bat wen dempla kese yupla ane teke yupla go po kot, no woribaut wiskain yupla go ansa po dempla. God go tok tru yupla. Den i no gobi yupla uda i tok po dempla baut da OliSpirit. Em go tok tru yupla. ");
INSERT INTO tcs_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","‘Dem bala uda eite Zizas go sele dem nada bala blo dempla uda labe Zizas ane kile dempla, ane ol papa go meke da seimting po pikinini blo dempla ane pikinini go meke da seimting po papa ane mama blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ane ebribodi go eite yupla bikoz yupla labe mi ane pole mi. Bat dempla uda go kip pole mi raitap antil wen dempla go ded, dempla go gad longlaip poeba. ");
INSERT INTO tcs_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Da taim i go kam wen da Prapa Nadakain Nugudting go stanap insaid da Tempol blo God ane disting i go spoile da Oliples, so God go kamaut prom da Tempol. Yupla uda rid diswan mas tingk prapa ad baut demting so yupla sabe ane prapa kese da mining blo demting. Den demwan uda stap wea kantri blo Zudia mas ran prapa kuik po dem maunten solong ol nogo ded. ");
INSERT INTO tcs_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ip dempla i ausaid aus blo dempla, dempla mas nogo insaid po teke ol samting blo dempla. ");
INSERT INTO tcs_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ip dempla wok wea gadan, dempla mas no gobaik po teke wom klos. Ol mas ranwei go. ");
INSERT INTO tcs_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ol dem oman uda pamle ane demwan uda gibe susu po beibi wea dat taim, i gobi prapa nugudtaim po dempla. ");
INSERT INTO tcs_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yupla prea dat dis badtaim nogo apen wea koltaim. ");
INSERT INTO tcs_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Wea dem dei, dem pipol go sapa nadakain wiskain dempla no bin sapa bipo, prom dat taim wen God bin meke da wold. Ane dis Prapa Nadakain Nugudting nogo apen gen. ");
INSERT INTO tcs_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Da LodGod nogo meke dempla po kip gad diskain adtaim po prapa longtaim. Ip God no go meke dat taim sot, den ebribodi go ded. Bat em go meke dat taim sot bikoz em labe dempla uda em bin suzem prom bipotaim. ");
INSERT INTO tcs_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‘Ane ip eniwan go spik yupla, ‘Ei, luk da Promiswan blo God, em ya’ o, “Luk, em de,” yupla no bilibe dempla. ");
INSERT INTO tcs_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Sam pipol go akt, dempla da Promiswan blo God, bat dempla lai ane nadalot go kam ane akt wase spesilmesizman blo God. Ol go meke olkain sain ane spesil samting po trike ebriwan, iben demwan uda God bin suzem. ");
INSERT INTO tcs_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lugaut! Ai wone yupla nau. Lugaut prom dempla! ");
INSERT INTO tcs_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Wea dat taim wen dem nugudting go pinis, da san i go kam dak, ane da mun nogo sain, ");
INSERT INTO tcs_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","dem sta go poldaun prom skai, ane ol dem nadating lo skai go seik ane kamaut. ");
INSERT INTO tcs_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","‘Wen demting go apen, ebribodi go luk mi da Truwan blo Man go kamdaun wea klaud wea prapa bigpaua ane da sainilait blo God. ");
INSERT INTO tcs_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ai go sane ol einzel blo mi go ebriwei wea dis wold po teke ebriwan uda ai bin suzem prom bipotaim, po kam tugeda prom ebri ples wea da ert ane eben. ");
INSERT INTO tcs_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Nau tingbaut da mekeitri ane lan prom dat tri. Wen em sake ol niu sut ane lip, yupla sabe i kam po kukitaim. ");
INSERT INTO tcs_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","So wen yupla luk ol dem badting i stat po apen, yupla go sabe da taim i klostu wen da wold i go pinis, ane ai da Truwan blo Man go kambaigen. ");
INSERT INTO tcs_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ai spik trutok po yupla, sam pipol uda laip nau gobi laip wen ol dem badtaim go apen. ");
INSERT INTO tcs_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Eben ane ert go pinis bat wod blo mi go stap poeba, i nogo pinis.’ ");
INSERT INTO tcs_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ane Zizas i kip spik, ‘Nobodi sabe wen demting go apen. Dem einzel wea eben ane mi da Boi blo God no sabe. Mata PapaGod blo mi sabe wattaim demting go apen. ");
INSERT INTO tcs_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lugaut. Ai wone yupla nau! Yupla mas meke wok blo mi solong yupla gobi redi po mi, bikoz yupla no sabe wattaim ai go kambaigen. ");
INSERT INTO tcs_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","‘Da taim wen ai da Truwan blo Man go kambaigen, i gobi wase wan man uda go trabel go po nada ples. Em libe aus blo em po ol sebant blo em po da taim antil em go kambaik. Em gibe ebri sebant zob blo dempla po mekem, ane da man uda lugaut da doa, zob blo em i po wone ebriwan wen em luk da bos blo da aus i kambaigen. ");
INSERT INTO tcs_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","So kip lugaut, bikoz yupla no sabe wattaim da bos blo da aus go kambaigen. Yupla no sabe ip i gobi wen da san godaun, o melennait o prapa elimoning, o wen da san kam antap. ");
INSERT INTO tcs_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","I gobi nugud ip em go kambaigen ane kese yupla slip, bikoz nobodi sabe wattaim em go kam. ");
INSERT INTO tcs_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","So ai spik po yupla ebriwan. Kip luk po mi ane weit po wattaim ai go kam.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Orait nau. I bin tu dei bipo da Pasoba ane da Pisting blo da Platbred i nogad yis. Ol dem edprist ane ol dem Zuwislotisa bin stil trai po paine sikretwei po kese Zizas po kile em. ");
INSERT INTO tcs_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Dem edprist ane dem Zuwislotisa bin tok po wananada diskain, ‘Yumpla nogo kese em po kile em wea da Pasoba Pisting. Bambai ol dem bigmob pipol ya go stat po paite yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Zizas bin de wea da biliz blo Betani. Em bin kaikai wea aus blo wan man, neim blo em Saiman. Dat man bin gad nugud skindiziz bipo, bat Zizas bin pinis ile em. Wail dempla bin kaikai de, wan oman bin kam klostu po Zizas. Em bin kare prapa dia sentoil insaid lo plas stonbotol. Da oman bin opene da botol ane bin kapsaid da sentoil antap ed blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sam dem pipol uda bin de i bin tok po wananada wailwan diskain, ‘Ei! Watpo em weiste dis dia sentoil? ");
INSERT INTO tcs_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Mobeta em bin sele dis dia sentoil po meke plenti mani ane dem mani wanem em mekem, em gibem po dem poapipol.’ Ane dempla bin graul da oman ane bin soe badpasin po em. ");
INSERT INTO tcs_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Zizas bin spik, ‘Ei, yupla no meke badpasin po em. Aukam yupla daunem diskain? Em bin meke spesil gudsamting po mi. ");
INSERT INTO tcs_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Dem poapipol go stap wea yupla ebritaim, ane yupla ken elpe dempla enitaim wen yupla wandem. Bat ai no gobi wea yupla ebritaim. ");
INSERT INTO tcs_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Dis oman bin meke wok blo em po ona mi. Em bin kapsaid sentoil lo bodi blo mi ya nau, po meke mi redi po piunrul blo mi. ");
INSERT INTO tcs_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ai spik trutok po yupla, wen da Gudniuz blo mi go spred ebriwea wea da wold ebribodi go lisen wanem dis oman bin mekem po mi.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Den Zudas Iskara, wan dem klostuman blo Zizas, i bin go po dem edprist po sele Zizas po dempla. ");
INSERT INTO tcs_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Dem edprist bin nadakain api po lisen wanem Zudas bin spik po dempla ane dempla bin meke promis po gibe em mani. So Zudas bin weit po da raittaim po kese Zizas ane tekem go po dem edprist. ");
INSERT INTO tcs_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Da pas dei blo da Pisting blo Platbred i nogad yis, i bin kam. Wea dat dei, i bin kastam po meke sakripais blo dem Pasoba smolsip, wan smolsip prom ebri pamle. Diswan i bin da taim po dem pipol blo Izrael po tingbaut po dem bipotaim pamle blo dempla, wen ol i bin kaikai dat Pasoba de wea Izipt. Dem klostuman blo Zizas bin aske Zizas, ‘Wea yu wande mipla po go po meke redi po da kaikai blo da Pasoba Pisting?’ ");
INSERT INTO tcs_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","So Zizas bin sane tu klostuman blo em go po Zarusalem ane em bin spik po demtu diskain, ‘Wen yutu go go insaid Zarusalem, yutu go mite wan man kare big botol wata, yutu pole em. ");
INSERT INTO tcs_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ane da aus wea em go go, yutu spik po da bos blo dat aus diskain, “Da Tisa blo mipla bin spik, yu go soe mitu da rum wea mipla, ol klostuman blo em ane Zizas, go kaikai da Pasoba Pisting?” ");
INSERT INTO tcs_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Den em go teke yutu go antap po wan big rum, da rum gobi redi ane klin. Yutu meke da sapa redi po yumpla po kaikai de.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Demtu klostuman blo Zizas bin lego go insaid po Zarusalem ane paine ebriting wiskain Zizas bin spik demtu. So demtu bin meke da kaikai redi blo da Pasoba Pisting. ");
INSERT INTO tcs_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Den demtu bin gobaigen po Zizas. Wen da san bin godaun ane i bin stat po kam dak, Zizas ane dem tuelb klostuman blo em bin go de po da aus wea dempla ebriwan go kaikai da Pasoba Pisting. ");
INSERT INTO tcs_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wail dempla bin sidaun raun da teibol kaikai, Zizas i bin spik, ‘Ai spik trutok po yupla, wan prom yupla ya i go sele mi. Em i ya kaikai wea yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Dem klostuman blo Zizas bin nadakain atso ane sore ane wan apta nadawan dempla bin spik po Zizas, ‘I no mi a?’ ");
INSERT INTO tcs_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Zizas bin spik, ‘I wan man prom yupla, dem tuelb klostuman blo mi. Em da man uda go teke kaikai prom da dis, da seimtaim wen ai go tekem. ");
INSERT INTO tcs_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ai spik yupla, ai da Truwan blo Man go ded wiskain Baibol i spik. Yagar. I gobi prapa nugud po dis man uda go sele mi. Mobeta dis man no bin bon.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nau Zizas bin teke bred ane eso God, broke da bred ane gibe dempla. Em bin spik, ‘Teke diswan. Em i bodi blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Den Zizas i bin kese da kap blo da wain ane eso God ane gibem po dempla, ane dempla ebriwan bin dringk prom dat kap. ");
INSERT INTO tcs_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","‘Diswan i blad blo mi, i kapsaid po ebriwan. I da niu strong griment bituin God ane ol pipol blo em.’ Den Zizas i bin spik po dempla gen, ");
INSERT INTO tcs_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","‘Ai spik yupla trutok. Ai nogo dringk wain gen antil dat dei wen ai go dringk niu wain wea da niuples wea God go ruloba ebriwan.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Den dempla bin sing wan amen sing po ona God. Den apta, Zizas ane dem klostuman blo em bin lego go po Maunt Olibtri. ");
INSERT INTO tcs_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Zizas i spik po dempla, ‘Yupla ebriwan go ranwei prom mi, bikoz da Baibol i spik diskain: “God go kile da man uda lugaut sip, ane dem sip go ranwei, ol go skata ebriwei.” ");
INSERT INTO tcs_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bat apta ai go kambaigen laip prom ded, ai go go pas po Galali ane ai go mite yupla de.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita kan stape emselp. Em sake tok po Zizas, ‘Nomata ip ebriwan i go ranwei prom yu, yu no wori. Ai nogo libe yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Zizas i ansarem, ‘Ai spik trutok po yupla, tidei, wa tunait, bipo da rusta go ala tutaim, yu go spik tri taim, “Ai no sabe Zizas.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bat Pita i tok mostrong po Zizas, ‘Iben ip ai go ded wea yu, ai nogo spik ai no sabe yu.’ Ane ol dem nada klostuman blo Zizas bin spik da seimtok wiskain Pita bin spik. ");
INSERT INTO tcs_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Den dempla bin kesem de lo Getsemani, wan gadan eria wea i gad ol plenti olibtri. Zizas bin spik po dem klostuman blo em, ‘Yupla stap ya, ai go prea.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Den Zizas i teke Pita, Zemes, ane Zon po go wea em. Ane Zizas i bin stat po pil nadakain atso ane main blo em i bin prapa ebi. ");
INSERT INTO tcs_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Em spik po demplatri, ‘Mai at i nadakain sore, ane ai pil laik ai go ded. Stap ya wea mi ane kip lugaut solong nobodi go kam.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Zizas em bin wagbaut go lelbet longwei prom demplatri ane poldaun pesdaun wea graun ane prea, aske God ip em ken gibe em sans so em nogo kare dat atso. ");
INSERT INTO tcs_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Em bin prea diskain, ‘Mai prapa labing PapaGod, yu ken meke ebriting. Plizgar, tekemaut dis nadakain pein wea i go apen po mi. No lete mi po ded. Bat ai no wande meke ubi blo mi, ai wande meke ubi blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Den Zizas bin gobaigen po Pita, Zemes, ane Zon ane paine dempla slip. Em spik po dempla, ‘Saiman Pita, yu slip a? Aukam yu kan lugaut mi po wan aua? ");
INSERT INTO tcs_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yupla no slip. Yupla mas prea po God solong yupla nogo meke ol nugudting. Da spirit blo yupla wande meke wok blo God bat da bodi blo yupla i tu wik.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Zizas i wagbaut go gen ane meke da seim prea po God. ");
INSERT INTO tcs_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wen Zizas bin kambaik prom prea em bin paine dem klostuman blo em ol i stil slip, bikoz ai blo dempla bin prapa ebi. Dempla no bin sabe wanem ol go spik po em. ");
INSERT INTO tcs_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wen Zizas bin kambaigen prom prea da namba tri taim, em bin spik diskain po dempla, ‘Yupla stil slip a? Nomo slip, ai spik yupla, nap! Da taim ya nau. Sambodi go sele mi da Truwan blo Man po dem nugudman uda gad tumas paua. ");
INSERT INTO tcs_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yupla gedap nau! Yumpla go nau! Da man uda bin sele mi, em ya kam!’ ");
INSERT INTO tcs_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Orait nau. Stretwei wen Zizas bin stil tok, Zudas, wan klostuman blo Zizas bin kam wea dem bigmob pipol ane dem bigmob pipol bin kare ol big sod ane ol big paitingstik. Dem edprist, dem Zuwislotisa ane dem Zuwiselda bin sane dis bigmob pipol kam po Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nau da man uda bin sele Zizas bin spik de pas po dem bigmob pipol, em i go soe dempla sain diskain: ‘Da man uda ai go kisem, dem amiman mas kesem ane tekem go.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Zudas i bin wagbaut stret go po Zizas ane spik po Zizas, ‘Tisa!’ ane em bin kisem. ");
INSERT INTO tcs_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ane dem man bin grabe Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Den wan dem klostuman blo Zizas bin kese naip ane lego po da sebant blo da bosprist ane bin kate talinga blo em. ");
INSERT INTO tcs_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Zizas bin tok, ‘Aukam yupla kam ya wea ol sod ane ol big stik po kese mi, wase ai man uda bin broke lo? ");
INSERT INTO tcs_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ebridei ai bin de wea yupla, lane yupla dem wod blo God wea da Tempol blo God. Aukam yupla no bin kese mi de wea Tempol? Bat ol dem wod blo God baut mi mas kamaut.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Den dem klostuman blo Zizas bin ranwei ane libe Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Bat wan yangman bin pole dempla biain dat mob uda bin kese Zizas. Em no bin were prapa klos, mata kaliko po kaba emselp. Dem amiman bin trai po kese em, ");
INSERT INTO tcs_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","bat dempla bin kese da kaliko blo em. Da kaliko bin kamaut ane da man i bin ranwei neketwan, libe da kaliko blo em biain wea dempla. ");
INSERT INTO tcs_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Dem mob pipol bin teke Zizas go po da aus blo da bosprist, ane ebriwan dem edprist, ane ol dem Zuwiselda ane ol dem Zuwislotisa, dempla ebriwan i bin kam tugeda. ");
INSERT INTO tcs_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita bin pole Zizas longwei biain. Pita bin go insaid da yad blo da aus blo da bosprist. Wen em bin de insaid, em bin sidaun klostu po da paia wea ol dem amiman. ");
INSERT INTO tcs_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Dem edprist ane ebridem man blo da Zuwiskaunsil bin trai po paine dem rongting wanem Zizas bin mekem solong dem edprist ane dem Zuwiskaunsil ken kile em. Bat dempla bin paine nating rong wanem Zizas bin mekem. ");
INSERT INTO tcs_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tumas pipol bin spik ol laitok gense Zizas, bat dem tok blo dem pipol bin olkain dipren dipren tok. Ol no bin gri wea wananada. ");
INSERT INTO tcs_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Den sam pipol bin stanap ane tok dis laitok gense Zizas, ");
INSERT INTO tcs_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","‘Mipla bin lisen em bin spik diskain, “Ai go broke dis Tempol blo God wea i bin teke prapa longtaim po plenti man po bildem, ane wea tri deitaim, dis Tempol, ai go bilde nadawan maiselp ane man no go bildem.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bat dem pipol uda bin notlong tok, dempla bin spik ol dipren dipren stori prom wananada. ");
INSERT INTO tcs_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Den da bosprist bin stanap prant wea dempla ane aske Zizas, ‘Ei, yu! Yu go ansa dem tok gense yu? Wanem dis stori dem man ya i spik gense yu?’ ");
INSERT INTO tcs_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bat Zizas bin stap kuaiat ane em no bin ansa da bosprist. Ane gen da bosprist i bin aske Zizas, ‘Ei, yu! Yu da Promiswan uda God i go sanem a, da Boi blo da wan uda kare ebri blesing?’ ");
INSERT INTO tcs_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Zizas bin ansa, ‘Wa! Ai da BosLod, ai da Truwan blo Man ane yupla go luk mi sidaun wea da ples blo ona, wea raitansaid blo da AntapGod ane yupla go luk mi kambaigen daun prom God antap wea ol klaud prom eben.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Wen da bosprist bin lisen wanem Zizas bin tok, em bin nadakain wail ane em bin tere klos blo em ane em bin spik, ‘Yupla lisen a? Mipla no nid mo witnis! Em tok nugud gense God. ");
INSERT INTO tcs_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Wanem yupla tingk?’ So da Zuwiskaunsil bin saze em prom tok nugudtok gense God ane dempla bin spik, ‘Em mas ded.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Sam dem man bin gedap ane spet wea pes blo Zizas. Den dempla bin taite raig raun ai blo em solong em kan luk. Ane dempla bin paite em wea pes blo em ane mokem diskain, ‘Ip yu spesilmesizman blo God, yu spik mipla uda bin ite yu nau!’ Iben dem amiman uda bin teke Zizas go bin paite em tu. ");
INSERT INTO tcs_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Wen da Zuwiskaunsil bin stil kuestin Zizas, Pita bin de insaid da yad blo da aus blo da bosprist, klostu po da paia. Wan sebant gel ");
INSERT INTO tcs_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","bin kam ane em bin mata luk stret po Pita ane em bin spik, ‘Ai bin luk yu pole dat Nazaretman, Zizas.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bat Pita bin ansa, ‘Ai no sabe dis man ane ai no sabe wanem yu tokbaut.’ Em bin gedap ane go stanap klostu da doa. Seimtaim nau da rusta bin singaut. ");
INSERT INTO tcs_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Den dis seim sebant gel uda bin luk Pita, bin spik po dempla uda i de wea Pita, ‘Dis man ya, em blo dempla.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ane Pita i ansa gen strongwei, ‘Nono!’ Sottaim apta nau, sam dem nada pipol uda i stanap de bin spik po Pita da seimting gen, ‘Ei yu! I tru. Yu klostuman blo Zizas bikoz bois blo yu i saun wase man prom Galali.’ ");
INSERT INTO tcs_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita bin kese emselp bikoz em bin spik diskain, ‘Ai spik yu tru, ai swea God, ai no sabe uda dis man!’ ");
INSERT INTO tcs_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Stretwei da rusta bin singaut gen ane Pita bin rimemba wanem Zizas bin spik, ‘Bipo da rusta go ala, tutaim yu go spik tri taim, yu no sabe mi.’ Wen Pita i bin rilaiz da tok blo Zizas, em bin nadakain bigsore ane base big krai. ");
INSERT INTO tcs_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Prapa elimoning, ol dem edprist, dem Zuwiselda ane dem Zuwislotisa ane ebri demwan blo da Zuwiskaunsil, i bin kam tugeda po tokbaut wanem dempla go mekem lo Zizas. Dempla bin mekpas em ane tekem go po Pailat, da gabana blo Rom, de wea Zarusalem. ");
INSERT INTO tcs_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat i bin aske Zizas, ‘Ei yu! Yu da king blo dem Zuwispipol a?’ Zizas bin ansa, ‘Wa! Diswan i wiskain yu spik.’ ");
INSERT INTO tcs_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ane ol dem edprist bin kam prant wea Pailat ane dempla bin spik po em dat Zizas i gad plenti saz gense em. ");
INSERT INTO tcs_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Den Pailat bin aske Zizas gen, ‘Yu nogad eniting po spikbaut demting wanem dempla i spik gense yu?’ ");
INSERT INTO tcs_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pailat bin tingk, ‘Watpo Zizas no bin ansa po mi?’ ");
INSERT INTO tcs_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ebri iya wea taim blo da Pasoba Pestabol, i bin gad pasin blo da gabana po meke peiba po dem Zuwispipol po suze sambodi po letem go pri prom insaid zeilaus. ");
INSERT INTO tcs_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Wea distaim i bin gad wan man, neim blo em Barabas, insaid wea zeilaus. Em ane bigmob man bin de insaid tu, bikoz dempla bin pait gense dem man blo da gabman blo Rom ane bin kile sam dem man. ");
INSERT INTO tcs_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nau bigmob pipol i bin kam po Pailat ane askem po da peiba wea em mekem ebri iya po lete wan man go pri prom insaid zeilaus. ");
INSERT INTO tcs_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","So Pailat bin aske dempla, ‘Wiswei? Yupla wande mi po lete da king blo da Zuwispipol go pri a?’ ");
INSERT INTO tcs_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat bin aske diswan bikoz em bin sabe dem edprist bin teke Zizas go po kot bikoz dempla bin zeles em. ");
INSERT INTO tcs_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bat dem edprist bin stere dem bigmob pipol po aske Pailat po lete Barabas go pri. ");
INSERT INTO tcs_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat bin spik, ‘Ip ai go lete Barabas go pri, wanem ai go mekem wea dis man uda yupla kolem da king blo dem Zuwispipol?’ ");
INSERT INTO tcs_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Dempla bin singaut nadakain laudwan, ‘Kilem, neilem wea kros!’ ");
INSERT INTO tcs_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ane Pailat bin aske dempla, ‘Watpo? Yupla spik mi wanem rong em bin mekem?’ Bat da bigmob pipol bin mata singaut molaud, ‘Kilem, neilem wea kros!’ ");
INSERT INTO tcs_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","So Pailat bin mata plize ubi blo dempla, ane em bin lego Barabas. Bat em bin oda dem amiman po ploke Zizas ane em bin spik dempla po tekem go ane neilem wea kros. ");
INSERT INTO tcs_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Dem Romamiman bin teke Zizas go po da amibarik ane bin singaut ol dem amiman wea da amibarik po kam tugeda. ");
INSERT INTO tcs_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Den dempla bin kabare solda blo Zizas wea papal klot kaliko ane dempla bin meke wan kraun prom plant wea i gad ol spaik. Dempla bin pose da kraun godaun wea ed blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Dempla bin mokem, ‘Mipla grite yu, yu bigbos, king blo dem Zuwispipol!’ ");
INSERT INTO tcs_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ane dempla bin ite ed blo em wea stik ane spet wea pes blo em ane mokem. Dempla bin nildaun prant wea em wase man uda ona king. ");
INSERT INTO tcs_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ane wen dempla bin taiat prom mokem, dempla bin tekemaut da papal klot kaliko prom em ane dempla bin were klos blo em baik wea em. Ane den dempla bin tekem go ausaid prom da siti po neilem wea da kros po kilem. ");
INSERT INTO tcs_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Dempla bin mite wan man uda bin wagbaut go insaid po da siti. Dem amiman bin stape em ane bin pose em po kare da kros blo Zizas. Neim blo dis man i Saiman. Em kam prom da siti blo Sairini, wan ples lo Aprika. Em i papa blo Alikzanda ane Rupas. ");
INSERT INTO tcs_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Dempla bin teke Zizas go po wan ples, wea dempla kolem Golgota, i min ‘Skal Il’. ");
INSERT INTO tcs_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Dempla i bin trai po gibe Zizas wain miks wea mersin. I po stape pein bat Zizas no bin wandem. ");
INSERT INTO tcs_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Dem amiman bin neilem wea da kros ane dempla bin sake dais po paindaut uda go gede ol klos blo em. ");
INSERT INTO tcs_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","I bin nain aklok moningtaim wen dempla bin neile Zizas wea da kros. ");
INSERT INTO tcs_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Antap lo da kros dempla bin neile wan smol notisbod i gad raiting. Da raiting i bleime Zizas diskain: Em i King blo dem Zuwispipol ");
INSERT INTO tcs_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Dem amiman bin neile tu man uda bin broke da lo wea nada tu kros, wan wansaid ane nadawan, nadasaid lo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ane dem wod blo God i bin kam tru wea i spik, ‘Dempla bin meke em wase man uda i broke lo.’ ");
INSERT INTO tcs_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Dem pipol uda bin wagbaut pase Zizas, i bin stap luk po em ane ala ol nugudtok po em ane seike ed blo dempla po daunem. Dem pipol i bin ala po em diskain, ‘Luk yu nau! Yu bin spik yu ken broke da Tempol blo God ane bildem gen wea tri dei! ");
INSERT INTO tcs_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Wa nau! Trai elpe yuselp ane kamdaun prom da kros!’ ");
INSERT INTO tcs_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Dem edprist ane dem Zuwislotisa bin moke Zizas tu ane dempla bin spik, ‘Yu bin seibe ol nada pipol bat yu kan seibe yuselp! ");
INSERT INTO tcs_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yu bin spik, yu da Promiswan blo God, da king blo Izrael. So nau yu mas kamdaun prom da kros so mipla ebriwan go luk ane bilib lo yu.’ Iben demtu nugudman uda bin neilem wea dem kros longsaid wea Zizas bin moke em. ");
INSERT INTO tcs_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Melendei i bin kam nadakain dak wase naittaim. Ebriwea wea da kantri, i bin dak po tri aua. ");
INSERT INTO tcs_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Den Zizas bin singaut wea laud bois, ‘Eloi, Eloi, lema sabaktani?’ Diswan i min ‘God blo mi, God blo mi, aukam yu bin gowei ane libe mi?’ ");
INSERT INTO tcs_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Dem pipol uda bin stanap klostu po da kros bin lisen Zizas singaut ane sam dem lot bin spik, ‘Lisen! Em singaut po da spesilmesizman Ilaiza.’ ");
INSERT INTO tcs_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wan prom dempla bin ran go wete wan ripspanz wea saua wain ane bin pase da ripspanz go antap wea stik po Zizas po dringk. Sambodi bin spik, ‘Weitpas! Libe em! Yumpla go trai luk ip Ilaiza go kam po tekem godaun prom da kros!’ ");
INSERT INTO tcs_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Den Zizas bin singaut gen prapa laudwan ane em bin ole laswin blo em ane pinis. ");
INSERT INTO tcs_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ane da seimtaim wen Zizas bin pinis, da prapa nadakain bigblain, i bin aing insaid wea da Tempol blo God, da blain i bin brok prom top go raittru godaun. ");
INSERT INTO tcs_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wen da sekan amiopisa blo Rom uda bin stanap de luk wiskain Zizas bin pinis, em bin spik diskain, ‘Wa, diswan i tru. Em da Boi blo God.’ ");
INSERT INTO tcs_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lelbet longwei prom da kros, sam dem oman bin stanap de. Neim blo sam dempla bin Meri Magdala, Meri mama blo Zosep ane Zemes da smolwan, ane Salomi. ");
INSERT INTO tcs_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Dempla bin pat blo dem bigmob pipol uda bin pole Zizas. Dem oman bin lugaut Zizas ebriwea wea Galali. Dempla ane plenti ol nada oman bin kam wea Zizas po Zarusalem. ");
INSERT INTO tcs_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Diswan bin apen lo Praidei, da dei po meke ebriting redi po da leit aptanun wen da Zuwis Sabatdei i go stat. Wen i bin klostu po dak, ");
INSERT INTO tcs_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Zosep prom Aramatia, wan smol taun de wea Zudia, i bin go po luk Pailat. Em no bin prait so em po askem po da bodi blo Zizas. (Zosep em wan gudpasin man blo da Zuwiskaunsil ane em bin weit po da taim wen God go ruloba ebriwan.) ");
INSERT INTO tcs_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat bin atzamp po lisen Zizas bin pinis ded nadakain kuik, so em i bin singaut ane aske da bos blo dem amiman ip diswan i tru dat Zizas i ded. ");
INSERT INTO tcs_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Da bos blo dem amiman i bin spik i tru Zizas em i ded, so Pailat bin spik po Zosep em i ken teke da bodi blo Zizas go po bere em. ");
INSERT INTO tcs_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Zosep bin baie prapa long gudkaliko. Apta em bin teke da bodi blo Zizas kamdaun prom da kros em bin rape da bodi wea da prapa gudkaliko. Em bin kare da bodi blo Zizas go insaid wea da keib insaid il wea dempla bin meke greib ane em bin libe da bodi de. Den em bin role wan big ston prant wea da greib. ");
INSERT INTO tcs_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Meri Magdala ane Meri mama blo Zosep bin de tu ane dempla bin luk wea Zosep bin pute bodi blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Da Zuwis Sabatdei bin pinis wen da san bin godaun ane Meri Magdala, Salomi, ane Meri da mama blo Zemes bin go po baie sentoil po rabem wea da ded bodi blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Prapa eli lo Sandei moning wen da san bin kamap, dempla bin go po da greib blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wail dempla bin wagbaut go, dempla bin aske wananada, ‘Wiskain yumpla go role da big ston go wansaid prom da doa blo da greib?’ ");
INSERT INTO tcs_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bat wen dempla bin kam klostu po da greib, dempla bin luk da nadakain big ston i leidaun wansaid. Da doa i bin pinis open. ");
INSERT INTO tcs_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","So dempla bin lego go insaid da greib ane dempla bin luk wan yangman uda were long waitklos sidaun de lo raitansaid. Dem oman bin nadakain atzamp ane prait. ");
INSERT INTO tcs_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bat da man bin spik po dempla, ‘Yupla no prait! Ai sabe yupla lukraun po Zizas blo Nazaret uda bin ded wea da kros. Em no ya. Em bin gedap laipwan gen. Luk ya! Diswan i da ples wea dempla bin pute da bodi blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yupla go nau ane spik dis mesiz po Pita ane dem nada klostuman blo Zizas, “Zizas i go go pas po Galali. Yupla go lukem de, wiskain em bin spik bipo em bin pinis.” ’ ");
INSERT INTO tcs_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Wen dem oman bin kam ausaid prom da greib dempla bin tekop ane ariap go. Dempla bin nadakain seik ane prait. Dempla no bin tok po nobodi bikoz prait bin stape dempla prom tok. ");
INSERT INTO tcs_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","I bin Sandei elimoning apta Zizas bin gedap laipwan gen. Pas wan uda bin luk Zizas i bin Meri Magdala. Em da seim oman uda Zizas i bin tekemaut seben nugudspirit prom em. ");
INSERT INTO tcs_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Dem klostuman blo Zizas bin stil krai ane prapa sore po Zizas ane Meri Magdala bin go luk dempla ane spik po dempla wanem bin apen. ");
INSERT INTO tcs_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Wen em bin spik dempla Zizas i laipgen ane em bin luk Zizas, dempla no bin bilib em. ");
INSERT INTO tcs_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Apta nau, Zizas bin soe emselp po tu man uda bin wagbaut go ausaid prom da siti blo Zarusalem. Bat demtu no bin megaraut em bikoz ngad blo em bin dipren. ");
INSERT INTO tcs_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Bat wen demtu bin megaraut em, demtu bin ran gobaik kuikwan po Zarusalem po spik dem nadalot klostuman blo Zizas. Bat nobodi bin bilib demtu. ");
INSERT INTO tcs_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nadataim, Zizas bin soe emselp po dem leben klostuman blo em wen dempla bin sidaun kaikai tugeda. Ane em bin graule dempla bikoz dempla no bin wande bilib. Dempla bin nadakain aded bikoz dempla no bin wande bilib demwan uda bin luk em apta wen em bin kamlaipgen. ");
INSERT INTO tcs_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ane den Zizas bin spik po dempla, ‘Yupla mas go ebriwea wea da wold ane yupla mas spik da Gudniuz baut mi po ebriwan. ");
INSERT INTO tcs_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Enibodi uda bilib dis mesiz ane em baptaiz, em go gad longlaip poeba wea God. Bat enibodi uda i no wande bilib, dempla nogo gad longlaip poeba wea God. ");
INSERT INTO tcs_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nau dempla uda bilib, God i go gibe dempla paua po spik wea neim blo mi po tekemaut ol nugudspirit prom dempla uda i gad ane dempla go spik ol nada langus wea ol no sabe. ");
INSERT INTO tcs_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ane nomata dempla kese ol sneik lo an blo dempla o dringk poizin samting, dempla nogo ded. Wen dempla go prea ane pute an blo dempla antap dem sikpipol, dem sikpipol go kamgudgen.’ ");
INSERT INTO tcs_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nau wen BosLod Zizas i bin pinis tok po dempla, God bin teke em go antap po eben ane mekem sidaun wea da ples blo ona wea raitansaid blo God. ");
INSERT INTO tcs_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","So nau dem klostuman blo Zizas bin go ane spik da Gudniuz baut Zizas po ol dem pipol ebriwea. Dem klostuman bin spik dis mesiz, ane God bin meke plenti mirikalsain po soe ebriwan dis mesiz i tru. ");
INSERT INTO tcs_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Dia Gabana Tiopalas, plenti pipol i bin trai po raite ol dem stori baut Zizas wanem em bin mekem wen em bin ya wea ert. Ane yu bin lisen dem stori. ");
INSERT INTO tcs_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dem pipol uda i bin lisen dem stori, prom ol dem pipol uda i bin luk wanem Zizas bin mekem, dempla bin raitem daun ol dem stori wanem ol i bin lisen. ");
INSERT INTO tcs_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","So ai bin go po aske ol dem pipol uda i bin de wea Zizas, po spik mi wanem ol i bin luk ane lisenbaut Zizas. Den ai bin raitem daun ane diswan i da trutok baut Zizas Kraist. ");
INSERT INTO tcs_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ai bin raite dem stori so yu ken sabe i tru wanem yu bin lisenbaut Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Orait. Dat taim wen Erod bin edman de wea Zudia i bin gad wan Zuwisprist blo da pamlelain blo da prist Abiza. Neim blo em i bin Zakaraia. Em bin maret wan oman blo pamlelain blo Aron, dat bipotaim bosprist. Neim blo dat oman i bin Lizabet. ");
INSERT INTO tcs_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Demtu i bin rait ane stret pipol prant wea God ane demtu bin mata pole ubi blo God. Demtu i bin gibe laip blo demtu po God. ");
INSERT INTO tcs_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Lizabet em kan gad pikinini. So demtu nogad pikinini ane nau demtu i prapa oul. ");
INSERT INTO tcs_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","I bin kastam blo ol dem prist po suze wan man po bane insens wea Tempol blo God, so dempla i bin suze Zakaraia. Zakaraia i bin go po bane insens de insaid da Tempol blo God. ");
INSERT INTO tcs_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Da seimtaim nau wen em bin go po bane da insens, ol dem pipol uda i bin kam de po wosip, dempla bin stanap de ausaid ane prea. ");
INSERT INTO tcs_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Wail Zakaraia bin bizi de insaid da Tempol, da einzel blo God i bin soe emselp de lo raitsaid blo da olta wea em bin bane da insens. ");
INSERT INTO tcs_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Wen Zakaraia bin luk dat einzel, em bin prapa atzamp ane prait. ");
INSERT INTO tcs_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bat da einzel i bin spik po em, ‘Ei. Yu no prait. God bin lisen prea blo yu. So nau ai spik yu, Lizabet oman blo yu i go bone boibeibi. Yu mas pute neim blo dat boibeibi, Zon. ");
INSERT INTO tcs_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yu ane plenti pipol i gobi prapa glad wen da beibi i go bon. ");
INSERT INTO tcs_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Em gobi prapa bigman wea God. Em no lau po dringk wain o eni strongdringk. Da OliSpirit paua i go stap wea em prom da taim wen em go bon. ");
INSERT INTO tcs_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Em go teke plenti pipol wea dis kantri Izrael, ane em go teke yupla kambaigen po God, God blo yupla. ");
INSERT INTO tcs_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Em go go pas po meke redi po da BosLod. Em i gobi prapa strong ane em go gad plenti paua blo God wase da spesilmesizman Ilaiza. Em i go meke ol pamle kambaigen tugeda ane tane ol pipol uda no bin lisen, po kambaik po da raitwei ane go meke dempla redi po da BosLod.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaraia bin spik da einzel, ‘Wiskain? Wiskain ai go sabe diswan i tru? Mitu prapa tu oul po meke beibi!’ ");
INSERT INTO tcs_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Da einzel bin ansa em, ‘Mi Geibrel, ai oltaim stanap klostu wea God ane God go elpe “yutu. God bin sane mi kam po spik yutu dis gudniuz. ");
INSERT INTO tcs_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yu no bilibe mi, bat wanem ai spik po yu i tru. Prom distaim nau, yu gobi dam, kan tok, raitap po da taim wen da beibi i go bon.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ol dem pipol i bin weit de ausaid da Tempol po Zakaraia. Dempla i bin stat po pazol nau. ‘Kole, wanem longtaim em mekem de insaid lo da Tempol?’ ");
INSERT INTO tcs_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wen em bin kam ausaid, em kan tok. Em bin meke ansain po dem pipol so ol i bin stretwei sabe em bin luk samting wase bizin de insaid lo da Tempol. ");
INSERT INTO tcs_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wen Zakaraia bin pinis dem wok blo em, em bin go longwei gobaik po aus blo em. ");
INSERT INTO tcs_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Apta nau, Lizabet oman blo em, i bin kam pamle. Em no bin libe aus po paib mant, bikoz em no bin wande nobodi po sabe em pamle. ");
INSERT INTO tcs_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Lizabet bin spik po emselp diskain, ‘God bin gibe mitu samting prapa gud. Em bin tingbaut mitu ane em bin tekemaut sem prom mi bikoz ai nogad pikinini ane nau ai pamle.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wen Lizabet i bin siks mant pamle, God i bin sane einzel Geibrel go po da biliz blo Nazaret wea da smol eria blo Galali. ");
INSERT INTO tcs_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Da einzel i bin go luk wan gel neim Meri. No man bin go wea dis gel. Em bin promis po maret wan man, neim blo em Zosep. Zosep i bin kam prom pamlelain blo King Deibid. ");
INSERT INTO tcs_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Da einzel bin kare mesiz prom God po Meri. Em bin spik diskain po Meri, ‘O o! Wiswei yu? God i go ona yu ane blese yu. Em i ya wea yu. Em bin suze yu prom ol dem nada oman.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wen Meri i bin luk ane lisen po wanem da einzel i spik, em bin prapa prait. Em bin pazol baut demting wanem da einzel bin spik po em. ");
INSERT INTO tcs_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Da einzel bin spik po em, ‘Yu no prait Meri, bikoz God i prapa kea po yu. Em bin suze yu. ");
INSERT INTO tcs_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Lisen gud! Yu gobi pamle ane yu go gad boibeibi. Yu mas pute da neim blo da boibeibi, Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Em gobi bigman ane ebribodi i go kole em Boi blo da Prapa AntapGod. Da LodGod i go meke em king wase Deibid, dat prapa bigate blo em. ");
INSERT INTO tcs_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Em gobi king oba Izrael, poeba. Em gobi king wea i nogad end.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Den Meri i bin spik baik po dat einzel diskain, ‘Wiskain ai go pamle? Ai no sabe man.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Da einzel ansa em baik, ‘Da OliSpirit go kam insaid wea yu ane da paua blo da Prapa AntapGod go kaba yu. So da pikinini wea i go bon, i gobi Boi blo God. ");
INSERT INTO tcs_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yu lisen po mi nau. Yu sabe kazen blo yu Lizabet prom mamasaid blo yu. Em nogad pikinini ane em prapa oul. Wel, em siks mant pamle nau. ");
INSERT INTO tcs_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Wa, bikoz i God uda ken meke ebriting.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Meri i bin ansa em baik diskain, ‘Ai wokinggel blo God ane ai mas mekem wanem God i wande mi po mekem, so lete demting wanem yu spik i go kam tru.’ So apta Meri bin spik diskain, da einzel bin go. ");
INSERT INTO tcs_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","So nau Meri i bin meke redi ane ariapwan go po dat taun wea ilkantri blo Zudia. ");
INSERT INTO tcs_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Seimtaim wen em bin go insaid aus blo Zakaraia, em bin alo po Lizabet. ");
INSERT INTO tcs_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Wen Lizabet i bin lisen da ala blo Meri, dat beibi i bin mub insaid beli blo Lizabet. Ane da OliSpirit i bin kese em strong. ");
INSERT INTO tcs_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Lizabet bin singaut laudwan, ‘God i bin blese yu moden eni nada oman. Ane em bin blese da boibeibi yu karem de insaid wea yu. ");
INSERT INTO tcs_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ei! Uda mi, dat disting i apen po mi, dat yu, mama blo mai BosLod i kam ya po bizit mi? ");
INSERT INTO tcs_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Meri, wen ai bin lisen yu singaut, da beibi insaid mi i bin zamp prom glad. ");
INSERT INTO tcs_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yu gobi prapa api ya nau bikoz yu bin bilib da mesiz blo God po yu, i go kam tru.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Den Meri i bin spik diskain: ‘At blo mi i singaut preiz po God. ");
INSERT INTO tcs_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mai at preize God ane kare neim blo em antap. Spirit blo mi i prapa glad bikoz God em i seibe mi. ");
INSERT INTO tcs_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Em bin tingbaut mi nomata ai prapa louklas gel blo em. Prom distaim nau ol pipol go kare neim blo mi antap, bikoz God bin suze mi. ");
INSERT INTO tcs_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Da Strong AntapGod, i bin meke ol prapa bigting po mi. Neim blo em i Oli. ");
INSERT INTO tcs_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Em soe sorewei po ebriwan uda i ona em ane pole em, demwan prom bipotaim, demwan ya nau ane demwan uda go kam biain. ");
INSERT INTO tcs_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","God bin soe paua blo em po yumpla. Demwan uda i praud, demwan uda i tingk dempla prapa ai, God spoile ol plan blo dempla. Em bin puse dempla go ausaid, meke dempla plai ebriwea wea win. ");
INSERT INTO tcs_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Em bin teke ol dem king prom taun blo dempla ane em bin daune dempla. Em bin liptemap ol louwan go antap. ");
INSERT INTO tcs_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Em bin gibe ol anggre pipol, ol plenti gudting, bat em bin sane ol riswan gowei, nogad nating. ");
INSERT INTO tcs_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Em bin elpe ol wokman blo em wea Izrael, dem longtaim pamle blo mipla. Diswan i bin Eibram ane ol pamle blo em. God bin meke dis promis, em ebritaim go meke gudpasin po dempla.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Meri bin stap de wea Lizabet po tri mant. Den apta tri mant em bin gobaik po aus blo em. ");
INSERT INTO tcs_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wen da taim i bin kam nau po Lizabet po bon, em bin bon boibeibi. ");
INSERT INTO tcs_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ol pren ane ol pamle blo em i bin lisen da prapa gudting wanem God i bin mekem po Lizabet. So dempla i bin prapa glad po em tu. ");
INSERT INTO tcs_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Eit dei apta da boibeibi i bin bon, dempla i bin meke redi po kate poskin blo em wase dem Mozeslo i spik. Pamle blo em i bin wande neime em Zakaraia apta papa blo em. ");
INSERT INTO tcs_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Lizabet i bin spik, ‘Nono. Neim blo em i Zon.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Dempla spik diskain po Lizabet, ‘Yu nogad no pamle wea i gad dat neim.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Dempla i bin meke ansain po Zakaraia, askem, ‘Wiswei? Wanem neim yu wande kole da boibeibi?’ ");
INSERT INTO tcs_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","So Zakaraia i bin askem po smol raitingbod ane em bin raitem diskain, ‘Neim blo em, Zon.’ Dempla bin sapraiz. ");
INSERT INTO tcs_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Da seimtaim nau, Zakaraia i bin stat po tok gen ane em bin mata preize God. ");
INSERT INTO tcs_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wen Zakaraia i bin pinis tok, ol dem pipol i bin prapa atzamp ane niuz i bin spred oloba ilkantri blo Zudia baut da boi blo em. ");
INSERT INTO tcs_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ebriwan uda bin lisen wanem bin apen, dempla bin tingbaut ane ol bin aske wananada, ‘Wanem dis boibeibi gobi. Ebribodi sabe da paua blo God i stap wea em.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Da OliSpirit blo God i bin tekoba Zakaraia, papa blo Zon, ane em bin spik dis mesiz blo God: ");
INSERT INTO tcs_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","‘Yumpla ebribodi kam preize da LodGod, da God blo Izrael. Em bin kam po elpe ol pipol blo em ane meke dempla pri. ");
INSERT INTO tcs_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Em bin sane wan prapa strongwan po seibe yumpla. Da wan uda seibe yumpla, em kam prom da pamlelain blo Deibid, sebant blo God. ");
INSERT INTO tcs_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Prapa mina longtaim de pas, God i bin promis wea ol dem spesilmesizman blo em, ");
INSERT INTO tcs_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","em go seibe yumpla prom ol enami blo yumpla, ane prom demwan uda i eite yumpla. ");
INSERT INTO tcs_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Em bin spik, em ken meke gudwei ane kipe dat spesil promis po ol dem longtaim pipol blo em. ");
INSERT INTO tcs_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Diswan da strong griment wea em i bin gibe Eibram, bigate blo yumpla. ");
INSERT INTO tcs_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Em go seibe yumpla prom ol dem enami blo yumpla, so yumpla ken serbe em ane no prait prom nating. ");
INSERT INTO tcs_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ane yumpla ken bi oli ane mata pole da raitwei, raitap po dat taim wen yumpla go ded. ");
INSERT INTO tcs_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","‘Ane yu, boi pikinini blo mi, ebriwan go kole yu spesilmesizman blo da Prapa AntapGod. Yu go pas, bipo da BosLod i go kam ane yu go meke da rod redi po em. ");
INSERT INTO tcs_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yu go spik ol pipol blo em diskain, em go seibe dempla ane em go pogibe ol sin blo dempla. ");
INSERT INTO tcs_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Bikoz God em gad prapa sorewei po ebriwan em go sane wan kam po seibe ebribodi. I gobi wase da elimoning san prom eben go kamap wea yumpla. ");
INSERT INTO tcs_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Em go sane sain prom eben po ebriwan uda stap wea dakples. Ebriwan uda nogad oup, demwan uda no sabe God ane no pole wei blo em, em go gaide yumpla wea da rod blo pis.’ ");
INSERT INTO tcs_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Da boi Zon i bin gro, ane wen em bin kam man nau, em bin prapa strong wea spirit blo em. Ane da OliSpirit bin gibe em paua. Apta nau, em bin go stap ebritaim wea da dezetples wea i nogad no man, kam raitap nau antil dat taim wen em bin soe emselp po dem pipol blo Izrael. ");
INSERT INTO tcs_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Orait. Dat taim wen Ogasta i bin da bigking blo Rom, em bin meke lo po ol dem kantri uda bin kam andanit wea em. Seimtaim, Korinias i bin gabana blo Siria tu. Dat lo i bin diskain: Ol pipol blo ol dem kantri mas raite neim blo dempla wea da taun wea dempla bin bon, bikoz da gabman bin wande meke sensis. ");
INSERT INTO tcs_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","So ebriwan i bin gobaik po da taun wea dempla i bin bon. Sam pipol i bin wagbaut go prapa longwei. ");
INSERT INTO tcs_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","So Zosep i bin wagbaut kam prom da biliz blo Nazaret wea kantri blo Galali, go po taun blo Betliem wea kantri blo Zudia. Betliem i bin da ples wea King Deibid i bin bon ane Deibid i bin dat longtaim bigate blo Zosep. ");
INSERT INTO tcs_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Orait. Zosep i bin teke Meri go wea em po raite neim blo demtu. Dat seimtaim nau, Zosep i bin meke promis po maret Meri. ");
INSERT INTO tcs_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Meri i bin pamle ane da taim i bin kam klostu po em po bon. ");
INSERT INTO tcs_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wail demtu bin de wea Betliem, Meri i bin bone boibeibi, pasbon blo em. Demtu i no bin paine rum po stap wea bodingaus. So demtu i bin go stap wea da ples wea ol animal i stap. Wen da boibeibi bin bon, Meri bin rape da boibeibi wea sam smol stripkaliko. Meri bin meke em leidaun wea grasbed wea animal kaikaiboks. ");
INSERT INTO tcs_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Dat seim nait nau, sam man uda i lugaut dem mob blo sip bin stap klostu wea Betliem. Ane dempla i bin gade ol dem sip de. ");
INSERT INTO tcs_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wan einzel blo God bin kam ane stanap melen wea dempla. Prapa braitlait blo God i bin sain antap dempla. Dempla bin nadakain prait. ");
INSERT INTO tcs_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Da einzel bin spik, ‘Yupla no prait. Ai go spik gudniuz po yupla. Yupla gobi prapa api ane diswan i go meke ebriwan api tu. ");
INSERT INTO tcs_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tidei wea dat seim taun wea King Deibid i bin king, da wan uda kam po seibe ebriwan i bin bon. Em i da Promiswan uda God i sanem kam, da BosLod. ");
INSERT INTO tcs_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yupla i go sabe diswan i tru wen yupla go paine dat boibeibi, em gobi rolemap wea ol smol stripkaliko, leidaun de wea grasbed insaid wea animal kaikaiboks.’ ");
INSERT INTO tcs_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Da seimtaim nau ol nadalot einzel bin kamaut de. Ol bin kamdaun prom eben ane ol bin go rait melen wea dempla. Ol bin sing preiz po God diskain: ");
INSERT INTO tcs_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","‘Preize da AntapGod uda stap wea eben, ane pis wea ebriwan uda plize em.’ ");
INSERT INTO tcs_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Apta nau, wen ol dem einzel i bin gobaigen po eben, ol dem wokman uda lugaut sip i bin spik po demplaselp, ‘Kam, yumpla go po Betliem po luk disting wanem i bin apen wiskain God bin spik po yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","So dem wokman i bin ariap go ane dempla bin paine Meri ane Zosep seimkain wase da einzel i bin spik. Dempla bin luk da boibeibi leidaun de wea grasbed wea animal kaikaiboks blo animal. ");
INSERT INTO tcs_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wen ol dem wokman blo sip i bin yan wanem da einzel i bin spikbaut dat beibi, ");
INSERT INTO tcs_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ebriwan uda i bin lisen dis tok i bin prapa atzamp. ");
INSERT INTO tcs_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Meri bin kipe ol demting wea at blo em, ane plentitaim em bin tingbaut demting. ");
INSERT INTO tcs_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Apta nau dem wokman i bin gobaigen po dem sip. Dempla i bin mata sing ane preize God po wanem dempla i bin luk ane lisen. Demting i bin apen seimkain wiskain da einzel i bin spik po dempla. ");
INSERT INTO tcs_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lo namba eit dei, dempla i bin kate da poskin blo da boibeibi Zizas wase dem Mozeslo i spik. Demtu bin neime da boibeibi, Zizas. Diswan da neim wea dat einzel i bin spik Meri po putem, wen em bin spik po Meri bipo em bin pamle, da promis dat em go bone boibeibi. ");
INSERT INTO tcs_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Orait. Lelbet longtaim apta da beibi i bin bon nau, da taim i bin kam po Meri po meke dat seramoni wase dem Mozeslo i spik. Da lo i spik dat ol oman uda i bin bone beibi i mas mekem so dem oman ken wosip ane prea gen wea da Tempol. So Zosep ane Meri bin go po Zarusalem ane demtu bin teke Zizas go wea demtu po dedikeit em wase dem Mozeslo i spik. ");
INSERT INTO tcs_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Dis lo blo God i spik, ebriwan mas dedikeit ol dem pasbon boi po da AntapGod, po meke wok blo God. ");
INSERT INTO tcs_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Go nau. Demtu bin teke tu smol pizin po opring wase dem Mozeslo i spik po meke da seramoni blo oman po meke dempla pri po wosip gen apta dempla i bin bone beibi. ");
INSERT INTO tcs_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","So dat seimtaim nau, wan man neim Simion, em bin stap de wea Zarusalem tu. Em bin i prapa rait ane stretman ane em bin mata wosip God. Da OliSpirit bin stap wea em ane em bin weit po da taim wen da Promiswan uda God go sanem kam, po meke Izrael pri prom dem ad lo blo Rom. ");
INSERT INTO tcs_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Da OliSpirit i bin spik po em diskain, ‘Bipo yu go ded yu go luk da Promiswan, da wan uda God i go sanem kam, da wan uda go seibe da ert.’ ");
INSERT INTO tcs_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Papa ane mama blo Zizas i bin teke em go po da Tempol po dedikeit Zizas po God wase dem Mozeslo i spik. Dat seimtaim nau da OliSpirit i bin lide Simion po go po da Tempol tu. ");
INSERT INTO tcs_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simion i bin paine dempla, ane em bin teke da boibeibi ane em bin liptemap Zizas ane em bin eso God. ");
INSERT INTO tcs_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Em bin spik: ‘AntapGod, bos blo ebriting, yu bin kipe yu promis po mi. Yu ken lete mi ded nau wea pis. ");
INSERT INTO tcs_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ai bin luk nau wea ai blo mi, wanem yu bin mekem po seibe ol pipol blo yu, ");
INSERT INTO tcs_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ane ol dem pipol blo ol dem nada kantri i go luk da wan uda i go seibe ebribodi. ");
INSERT INTO tcs_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Em go gibe lait po ol dem pipol blo dem nada dipren kantri, sole dempla ken bi seib tu. Ane yumpla blo Izrael go gibe em preiz ane ona.’ ");
INSERT INTO tcs_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Orait. Da ai blo mama ane papa blo Zizas bin prapa open, atzamp prom ol demting wanem Simion i bin spikbaut Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simion i bin blese demplatri ane em bin spik po Meri, ‘Ai spik yu, God bin suze dis boi ane bikoz em bin kam plenti pipol nogo laik em. Bat ol nada pipol blo Izrael i go stanap po paine gudlaip. Dis boi i da sain God bin sanem kam po soe da wei po God. ");
INSERT INTO tcs_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Bat plenti pipol i go go gense em, ane ol dem dip sikret blo dempla i go kamaut. Yagar. Meri, yu gobi prapa sore, bikoz i gobi wase prapa sap naip i spere at blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Orait. Wan spesilmesizoman blo God, neim blo em Ana, em bin stap de wea da Tempol tu. Ana bin gel blo Panuel blo da longtaim pamlelain blo Asa. Em bin maret po seben iya den em bin stap widooman prom wen em bin yangoman. Nau em prapa oul oman, 84 iya oul. ");
INSERT INTO tcs_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Em no sabe libe da Tempol. Nait ane dei em bin meke wok blo God de, mata ebritaim em i prea ane pasting. ");
INSERT INTO tcs_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Da seimtaim nau Ana bin kam de wea dempla wea da Tempol. Em bin eso God ane em bin spik ebriwan uda bin weit po dat taim wen da Masaia, da Promiswan i go kam po meke Zarusalem pri. Ana i bin spik diskain baut Zizas, ‘Em da wan uda God i bin suzem.’ ");
INSERT INTO tcs_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Apta Zosep ane Meri i bin pinis meke ebriting wanem dem lo blo God i bin spik, demtu bin gobaigen po aus blo demtu wea taun blo Nazaret wea Galali. ");
INSERT INTO tcs_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Da pikinini Zizas bin gro ane em bin kam strong ane elti. Em bin kam prapa waiz ane em bin mata wea raitsaid blo God ane God i bin blese em. ");
INSERT INTO tcs_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Orait. Ebri iya nau, mama ane papa blo Zizas i bin go po Zarusalem po da Pasoba Pestabol. Diswan da Pestabol blo da Platbred wea i nogad yis. ");
INSERT INTO tcs_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Nau wen Zizas i bin tuelb iya oul, em bin go Zarusalem wea papa ane mama blo em, go po dat big pisting. Ol dem Zuwisman i bin go de bikoz i kastam blo dempla tu. ");
INSERT INTO tcs_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Apta nau, wen da big pisting bin pinis, ebribodi i bin go wagbaut gobaigen po aus blo dempla. Zizas bin stap de biain de wea Zarusalem. Mama ane papa blo em no bin sabe em bin stap. ");
INSERT INTO tcs_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Demtu i bin wagbaut ol dei ane demtu i bin tingk em de melen wea ol dem nada kantriman blo demtu. Wen san i bin godaun, demtu i bin stat po lukraun po em nau. Demtu bin aske ol pamle ane pren blo demtu, bat dempla no bin luk em. ");
INSERT INTO tcs_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","So demtu i bin gobaigen po Zarusalem po lukraun po em de. ");
INSERT INTO tcs_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Demtu bin lukraun po em, ane i bin tri dei apta wen demtu bin paine em de wea da Tempol. Em bin sidaun wea ol dem Zuwislotisa ane em bin lisen po dempla ane em bin aske dempla ol kuestin. ");
INSERT INTO tcs_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ebriwan de wea da Tempol bin prapa atzamp wen dempla bin lisen ol dem waiz ansa blo em ane ol dem sabe blo em wanem em i gad. ");
INSERT INTO tcs_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Papa ane mama blo em i bin prapa atzamp wen demtu bin luk Zizas de wea ol dem tisa. Den mama blo em i bin spik po em, ‘Mai boi, wanem yu bin mekem diskain po. Mitu bin prapa nadakain wori. Mitu bin lukraun po yu ebriwea.’ ");
INSERT INTO tcs_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Zizas i bin ansa demtu. ‘Watpo yutu bin lukraun po mi? Yutu no sabe ai mas ya wea aus blo Papa blo mi a?’ ");
INSERT INTO tcs_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bat demtu no bin sabe wanem em i min. ");
INSERT INTO tcs_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Apta nau, Zizas i bin gobaik wea demtu po aus blo dempla wea Nazaret ane em bin ebritaim lisen po demtu. Mama blo em i bin kipe ol demting baut Zizas wea at blo em. ");
INSERT INTO tcs_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Zizas bin gro mostrong wea bodi ane wea waizwei blo em. Em bin wea raitsaid blo God ane raitsaid blo ebribodi uda sabe em. ");
INSERT INTO tcs_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Diswan nau i bin piptin iya Taibirias i bin da bigking wea da siti blo Rom. Pontis Pailat i bin gabana blo kantri blo Zudia. Erod Antipas i bin edman wea smol kantri blo Galali ane bala blo em Pilip, i bin edman blo smol kantri blo Ituria ane Trakanaitis. Laisania bin edman blo smol kantri blo Abalin. ");
INSERT INTO tcs_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Demtu Anas ane Kaiapas bin teke tan po bi bosprist. Da seimtaim nau, Zon boi blo Zakaraia, i bin de wea da dezetples ane God i bin de tok po Zon. ");
INSERT INTO tcs_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","So den Zon i bin goraun ane pris raittru lo dem eria blo Zodan Riba ane em i bin spik po dempla diskain, ‘Yupla sabe yupla mas baptaiz apta yupla bin tan prom ol sin blo yupla, den God i go pogibe sin blo yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Aizaia, da spesilmesizman blo God, i bin raitem diskain baut Zon: ‘I gad sambodi de ala lo ples wea i nogad man. Em singaut: “Meke da wei redi po da AntapGod, meke rod stret po em po wagbaut. ");
INSERT INTO tcs_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ebri bali, yupla mas pilemapem, ebri maunten ane il, yupla mas lebelem. Ol kruket rod, yupla mas mekem stret, ol dem busrod, yupla mas smudem. Meke ol demting bipo da BosLod go kam. ");
INSERT INTO tcs_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ebriwan i go luk diswan God i bin sanem kam po seibe ebribodi.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","‘Plenti pipol i bin kam po Zon so em ken baptaiz dempla. Bat em bin graul dempla prapa strong ane bin spik stret po dempla, ‘Yupla wase ol sneik. Yupla tingk wen yupla go baptaiz, God nogo panse yupla po ol dem rongting wea yupla bin mekem a?’ ");
INSERT INTO tcs_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ai spik yupla nau. Yupla mas tanewei prom ebridem nugudting lo laip blo yupla ane tan po God, so ai go sabe yupla bin tan prom ol sin blo yupla. No spik diskain ya, “Yumpla orait wea God bikoz yumpla kam prom dat seim pamlelain blo bigate Eibram.” Datwan i no min nating. God i ken seinze dem ston ya po pikinini blo Eibram. ");
INSERT INTO tcs_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","God i wase man wea i wok lo gadan. Da tamiok blo da zazment blo God i redi po katemdaun ol dem tri ane ol dem rut. Ebri tri uda no sake gudprut, em i go katemdaun ane sakem wea dat bigpaia.’ ");
INSERT INTO tcs_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Dem pipol ol i bin aske em, ‘Wanem mipla i go mekem sole God nogo panse mipla?’ ");
INSERT INTO tcs_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Em i ansa baigen po dempla, ‘Uda gad tu kaliko mas gibe wan po em uda nogad. Ane uda i gad kaikai mas seremaut po dempla uda nogad.’ ");
INSERT INTO tcs_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Sam taksman ol i bin kam po baptaiz ane ol bin aske Zon, ‘Tisa, wanem mipla go mekem?’ ");
INSERT INTO tcs_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Zon bin spik po dempla, ‘Yupla no meke pipol pei mo mani den wanem da gabman i askem.’ ");
INSERT INTO tcs_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sam amiman i bin aske Zon tu, ‘Wiswei mipla? Wanem mipla go mekem?’ Em bin ansa dempla, ‘Yupla no puse eniwan po gibe yupla mani. Yupla no bleime man uda no bin meke rong. Yupla mas satispai wea pei blo yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Dem pipol i bin atzamp. Dempla bin tingk samting gud mas go apen. ‘Ei, mait Zon gobi da Promiswan.’ ");
INSERT INTO tcs_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Go nau. Zon i bin spik po dempla, ‘Ai baptaiz yupla wea wata, bat i gad sambodi mobig uda i go kam. Ai no gudnap po tekemaut sandol blo em. Em go baptaiz yupla wea da OliSpirit ane wea paia. ");
INSERT INTO tcs_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Em i go zaze ol pipol ane em i go tekemaut ol dem gudpipol wase mipla tekemaut da gudkaikai prom da koknat sel ane sakwei da sel. Ol dem gudpipol, em go kipe dempla wea eben wase mipla kipe da gudkaikai wansaid. Ol dem nugudpipol, em go sake dempla wea dat paia i ban poeba, datwan el. Em go sake dempla de wase yumpla sake ol koknat sel po banem wea paia.’ ");
INSERT INTO tcs_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Zon bin prise da gudniuz po elpe demwan uda i sabe da raitwei po God. Em bin tok strong ane em bin trai olkainwei po wone dempla po seinze wei blo dempla. ");
INSERT INTO tcs_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Zon bin graule Erod Antipas, da edman blo Galali. Em i bin spik em stret bikoz Erod i bin maret oman blo bala blo em. Neim blo dat oman Erodias. Ane Erod i bin meke plenti ol nadakain nugudting tu. ");
INSERT INTO tcs_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Den Erod i bin meke nada prapa nugudting gen. Em bin sane ol amiman blo em go po kese Zon ane po putem insaid wea zeilaus. ");
INSERT INTO tcs_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Apta wen Zon i bin baptaiz ol dem pipol, Zon bin baptaiz Zizas tu. Wail Zizas i bin prea, eben i bin open ");
INSERT INTO tcs_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ane da OliSpirit bin kamdaun antap wea em wase dab. Ane bois bin spik prom eben, ‘Yu mai boi. Ai prapa labe yu ane ai prapa glad ane satispai wea yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Orait. Zizas i bin baut 30 iya oul wen em bin stat dat spesil wok blo em. Ol dem pipol bin tingk em boi blo Zosep. Dis seim Zosep i da boi blo Elai, ");
INSERT INTO tcs_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elai i da boi blo Matat. Matat i da boi blo Libai. Libai i da boi blo Melki. Melki i da boi blo Zanai. Zanai i da boi blo Zosep. ");
INSERT INTO tcs_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Zosep i da boi blo Matatias. Matatias i da boi blo Amos. Amos i da boi blo Neiam. Neiam i da boi blo Esli. Esli i da boi blo Nagai. ");
INSERT INTO tcs_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai i da boi blo Mat. Mat i da boi blo Matatias. Matatias i da boi blo Semein. Semein i da boi blo Zosak. Zosak i da boi blo Zoda. ");
INSERT INTO tcs_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Zoda i da boi blo Zoanan. Zoanan i da boi blo Resa. Resa i da boi blo Zerubabal. Zerubabal i da boi blo Salatela. Salatela i da boi blo Neri. ");
INSERT INTO tcs_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri i da boi blo Melki. Melki i da boi blo Adi. Adi i da boi blo Kosam. Kosam i da boi blo Elmadam. Elmadam i da boi blo Er. ");
INSERT INTO tcs_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er i da boi blo Zosua. Zosua i da boi blo Elieza. Elieza i da boi blo Zorim. Zorim i da boi blo Matat. Matat i da boi blo Libai. ");
INSERT INTO tcs_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai i da boi blo Simion. Simion i da boi blo Zuda. Zuda i da boi blo Zosep. Zosep i da boi blo Zonam. Zonam i da boi blo Eliakim. ");
INSERT INTO tcs_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim i da boi blo Melia. Melia i da boi blo Mena. Mena i da boi blo Matata Matata i da boi blo Natan. Natan i da boi blo Deibid. ");
INSERT INTO tcs_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deibid i da boi blo Zesi. Zesi i da boi blo Obed. Obed i da boi blo Boaz. Boaz i da boi blo Salmon. Salmon i da boi blo Nason. ");
INSERT INTO tcs_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason i da boi blo Aminadab. Aminadab i da boi blo Ram. Ram i da boi blo Ezron. Ezron i da boi blo Perez. Perez i da boi blo Zuda. ");
INSERT INTO tcs_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Zuda i da boi blo Zekop. Zekop i da boi blo Aizak. Aizak i da boi blo Eibram. Eibram i da boi blo Tera. Tera i da boi blo Nao. ");
INSERT INTO tcs_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nao i da boi blo Serug. Serug i da boi blo Riu. Riu i da boi blo Peleg. Peleg i da boi blo Eber. Eber i da boi blo Sela. ");
INSERT INTO tcs_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela i da boi blo Kainan. Kainan i da boi blo Arpaksad Arpaksad i da boi blo Sem. Sem i da boi blo Noa. Noa i da boi blo Lamek. ");
INSERT INTO tcs_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek i da boi blo Metusela. Metusela i da boi blo Inok. Inok i da boi blo Zared. Zared i da boi blo Malalil. Malalil i da boi blo Kenan. Kenan i da boi blo Inos. ");
INSERT INTO tcs_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Inos i da boi blo Set. Set i da boi blo Adam ane Adam i da boi blo God. Diswan da pamlelain blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Orait. Zizas em i bin kambaik prom Zodan Riba ane paua blo da OliSpirit i bin stap wea em. Apta em bin baptaiz, da OliSpirit i bin lide em go po da dezetples wea i nogad no man. ");
INSERT INTO tcs_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Satana, dat bosdebol i bin tempte em de po poti dei. Lo dat taim Zizas no bin kaikai nating. Apta poti dei em bin nadakain anggre. ");
INSERT INTO tcs_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satana i bin spik po Zizas, ‘Ip yu da Boi blo God, tane ol dem ston ya po bred.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Zizas i bin ansa em. ‘Ei lugaut! Wod blo God i spik, “Po gad trulaip yupla nide moden kaikai.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Go nau. Satana i bin teke Zizas go po prapa aiples ane em bin soe em prapa kuikwan wase laitning, ol dem kantri blo da ert. ");
INSERT INTO tcs_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Satana bin kip spik po em diskain, ‘Yu luk, ebriting i blo mi. Ip yu baudaun, pesdaun prant wea mi ane wosip mi, den ai go gibe yu da rait po kare lo blo dis wold ane dat bigneim blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Zizas bin spik baik po em, ‘Ei Lugaut! Da wod blo God i spik: “Mata wosip da AntapGod blo yupla ane mata serbe em.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Go nau. Satana bin teke em go po Zarusalem ane meke em stanap wea aipat blo da Tempol blo God. Den em spik po Zizas, ‘Ip yu Boi blo God, sake yuselp godaun nau.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Satana bin kip spik, ‘Wod blo God i spik: “God go oda ol einzel blo em po lugaut yu gud. ");
INSERT INTO tcs_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ol dem einzel go kese an blo yu ane kare yu antap so put blo yu nogo bang wea ston.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Bat Zizas i bin ansa em gen diskain, ‘Ei, yu sabe! Da wod blo God i spik, “I nugud po pose da AntapGod po soe yupla em kea po yupla.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wen Satana i bin pinis tempte Zizas olkainwei, em bin libe Zizas po nadataim apta. ");
INSERT INTO tcs_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Apta nau, Zizas bin gobaik go po Galali ane em bin kam wea da paua blo da OliSpirit. Da niuz baut em i bin go ebriwea wea da smol kantri blo Galali. ");
INSERT INTO tcs_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Em i bin lane ebriwan de wea dem zuwispreaus ane ebriwan bin preize em po wanem em i bin lane dempla. ");
INSERT INTO tcs_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Zizas i bin go po Nazaret wea em i bin gro. Kastam blo em bin diskain, wea Zuwis Sabatdei em bin go po dem zuwispreaus. Nau dis Zuwis Sabatdei em bin go po da zuwispreaus wea Nazaret ane em bin gedap po ride dem wod blo God de. ");
INSERT INTO tcs_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Dempla i bin gibe em da buk blo Aizaia, da longtaim spesilmesizman blo God. Zizas bin rid wea dem wod blo God wea i spik diskain: ");
INSERT INTO tcs_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘God i bin pute Spirit blo em wea mi bikoz em bin suze mi po spik da Gudniuz po ol dem poapipol. Em bin sane mi kam po spik po ol dem sina, em go pogibe ol sin blo dempla, ane meke dempla uda blain po luk, ane tekemaut ebriwan uda bin sapa bikoz dempla stap wea paua blo sin, ");
INSERT INTO tcs_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ane po spik, diswan i da taim nau po da AntapGod po go seibe ol pipol blo em.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Den Zizas bin rolemap da buk ane em i bin gibe da buk baik po da serba ane den Zizas bin go ane sidaun. Ol dem pipol de wea da zuwispreaus ol i bin mata wase em prapa adwan. ");
INSERT INTO tcs_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Zizas i bin spik diskain po dempla, ‘Nau ai spik yupla stret. Dis mesiz blo Aizaia bin kam tru tidei wea dat seimtaim wen ai bin ride da buk.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dempla i bin prapa atzamp wen dempla bin lisen da gud mesiz wanem em bin spik. Dempla i bin gri baut wanem em bin spik ane dempla bin smolsmoltok po demplaselp. Dempla bin spik po wananada, ‘Ei, wiskain? Em mata kasa boi blo Zosep a!’ ");
INSERT INTO tcs_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Zizas bin spik po dempla, ‘Ai sabe yupla go tok smat po mi. Yupla go spik diskain, “Dokta, ile yuselp.” Yupla mas bin lisenbaut wanem ai bin mekem de wea Kapaniam ane nau yupla wande mi po meke da seimting ya wea taun blo yumpla a?’ ");
INSERT INTO tcs_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Zizas i bin kip spik po dempla, ‘Ai spik trutok po yupla, ai sabe wei blo pipol. Dempla no welkam dem spesilmesizman blo God wea taun blo em. ");
INSERT INTO tcs_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","‘Yupla lisen po mi nau. Diswan i tru, i bin gad plenti widooman ya wea Izrael wea dat taim blo Ilaiza. Dat seimtaim i no bin gad rein po tri ane ap iya. I bin prapa nadakain draitaim ebriwea wea dem kantri. ");
INSERT INTO tcs_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bat God no bin sane Ilaiza go po elpe enibodi ya wea Izrael. Nono! Em bin sane Ilaiza longwei go po nada kantri po elpe dat widooman uda bin stap wea Zarapat longsaid wea Sidon. ");
INSERT INTO tcs_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Den nadataim ya wea Izrael, plenti pipol bin gad prapa nugud skindiziz. God no bin sane Ilaiza po ile dempla ya. Nono! God i bin yuze Ilaiza po mata ile dat man Naman, uda i bin kam prom kantri blo Siria.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Apta ol dem pipol de wea dat zuwispreaus bin lisen dis tok blo Zizas, at blo dempla i bin kamap. Dempla i bin prapa nadakain wail. ");
INSERT INTO tcs_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Dempla i bin gedap ane draige Zizas go ausaid prom da zuwispreaus ane ausaid prom dat taun. Da taun i bin de wansaid wea il. Dempla bin draige Zizas go antap wan klip po sake em godaun. ");
INSERT INTO tcs_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bat Zizas i bin mata wagbaut raittru ol dem bigmob pipol ane em bin kipgo. ");
INSERT INTO tcs_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Prom de nau Zizas i bin go po Kapaniam, nada biliz de wea Galali. Ebri Zuwis Sabatdei em oltaim tise dempla de. ");
INSERT INTO tcs_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ol dem pipol i bin prapa atzamp prom wanem em bin tise dempla. Tok blo em i gad paua, prapa kare lo. ");
INSERT INTO tcs_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Wantaim nau Zizas i bin de wea da zuwispreaus. Wan man de i bin gad debolspirit insaid wea em. Da debolspirit i bin singaut wea prapa laud bois, ");
INSERT INTO tcs_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","‘Ei yu, Zizas blo Nazaret! Gowei! Wanem yu wandem wea mipla? Yu kam po distroi mipla a? Ai sabe uda yu. Yu da Oliwan, da Boi blo God.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Zizas i bin oda da spirit, ‘Yu sadap! Yu kamaut prom em. Ai spik yu, kamaut nau!’ Stretwei da debolspirit bin sake da man daun prant wea dempla ane em bin kamaut prom em. Bat em no bin erte da man. ");
INSERT INTO tcs_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ol dem pipol i bin nadakain atzamp ane dempla bin tok po demplaselp diskain, ‘Wiskain oda diswan? Em mata spik strong. Em gad paua orait, prapa kare lo. Em gibe oda po debolspirit ane dem debolspirit kamaut tu.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","So apta nau da niuz blo Zizas i bin go ebriwea wea da eria. ");
INSERT INTO tcs_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Wen Zizas i bin kamaut prom dat zuwispreaus em bin go po aus blo Saiman. Madalo blo Saiman i bin sik de, gad strong piba ane dempla bin aske Zizas po elpe em. ");
INSERT INTO tcs_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","So Zizas bin go insaid ane em bin stanap klostu wea bed blo dat oman. Em bin oda da piba po stap. Stretwei da piba blo em bin pinis ane em bin gedap ane meke kaikai po dempla. ");
INSERT INTO tcs_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wen i bin stat po dak nau, demwan uda i bin gad olkain sikpipol uda stap wea aus blo dempla, ol i bin teke dempla kam po Zizas. Em bin pute an wea dempla ane em bin ile ebriwan. ");
INSERT INTO tcs_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ol debolspirit i bin kamaut prom plenti pipol. Wen ol dem spirit bin kamaut, dempla singaut laudwan po Zizas, ‘Yu da Boi blo God!’ Bat Zizas i bin oda dem spirit po stap kuaiat bikoz dempla i bin sabe em i da Promiswan. ");
INSERT INTO tcs_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Neksdei, elimoning, Zizas i bin go po kuaiatples wea i nogad pipol. Ol dem bigmob pipol i bin stat po lukraun po em. Wen dempla i bin paine em, dempla bin trai po stap Zizas prom libe dempla. ");
INSERT INTO tcs_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Bat Zizas i bin spik po dempla, ‘Ai mas go nau po ol dem nada biliz tu, bikoz God i bin sane mi kam po teke da Gudniuz wea God em i go ruloba ebriwan.’ ");
INSERT INTO tcs_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","So em bin go ane spik da mesiz po ebriwan wea dem zuwispreaus de wea Zudia. ");
INSERT INTO tcs_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wandei nau Zizas i bin stanap longsaid wea Leik Galali. Plenti pipol ol bin puse dem wei kam po lisen dem wod blo God. ");
INSERT INTO tcs_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nau Zizas i bin luk tu bot leidaun de wansaid wea sanbis wea watamak blo da leik. Nobodi bin de wea demtu bot bikoz ol dem pisaman i bin libe demtu bot de ane ol i bin go po wase dem net blo dempla. ");
INSERT INTO tcs_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Zizas bin go ane em zamp insaid wan bot. Diswan i bin bot blo Saiman Pita. Ane den em bin aske Saiman po puse da bot go ausaid go lelbet longwei prom sanbis. So nau Zizas bin sidaun wea dat bot ane em bin tise ol dem plenti pipol prom de. ");
INSERT INTO tcs_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wen Zizas i bin pinis tok, em bin spik po Saiman, ‘Yu pul go ausaid wea dipwata. Yu ane ol met blo yu sake net de nau po kese pis.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saiman bin ansa Zizas, ‘Masta, mipla bin adwok ol nait ane mipla no bin kese nating. Orait. Ip yu spik diskain, den ai go mekem wanem yu spik.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","So dempla bin sake dem net blo dempla ane ol bin kese prapa tumas pis. Dem net bin klostu brok. ");
INSERT INTO tcs_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","So ol bin singaut po dem nada met blo dempla wea da nada bot po kam po elpe dempla. Dempla bin kese prapa plenti pis so demtu bot bin prapa pulap wea pis ane i bin klostu po singdaun. ");
INSERT INTO tcs_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wen Saiman Pita i bin luk wanem ting bin apen, em bin nildaun prant wea Zizas. Em spik diskain, ‘BosLod, yu gowei prom mi. Ai nugudman.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Em bin spik diskain bikoz em ane ol dem nada met blo em bin prapa atzamp wen dempla bin luk ol dem plenti pis wea dempla bin kesem. ");
INSERT INTO tcs_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","I bin gad tu klostumet blo Saiman wea da nada bot tu. Zemes ane Zon, boi blo Zebadi, demtu bin prapa atzamp tu. Apta nau Zizas bin spik po Saiman. ‘Yu no prait. Prom distaim nau yupla nomo go kese pis. Yupla go kese man. Yupla mas meke wok blo God nau po spik wod blo God po ol pipol.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","So dempla bin puse da bot go rait antap wea grasmak. Den dempla i bin libe ebriting ane ol bin pole Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wea wan dem biliz, i bin gad wan man uda gad prapa nugud skindiziz ebriwea lo bodi blo em. Wen em bin luk Zizas em bin singaut po em. Em bin baudaun pesdaun prant wea Zizas ane em bin bege em ane em spik diskain, ‘Masta, ip yu wandem, yu ken meke mi gudgen.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Zizas bin strete an blo em go aut ane em bin tase da man. Zizas bin ansa em, ‘Wa, ai go meke yu gud.’ Stretwei da nugud skindiziz blo da man i bin kamgud. ");
INSERT INTO tcs_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Zizas i bin spik po em prapa strong diskain, ‘Yu no spik nobodi, bat mata go soe yuselp po da prist ane laue em po eksamin yu. Den po soe ebriwan yu bin kamgudgen, yu mas teke spesil opring go po da prist wase dem Mozeslo i bin spik. Den ol dem pipol go luk yu de.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bat da niuz blo Zizas i bin spred prapa kuikwan ebriwea. Bigmob lo pipol bin kam de po lisen wanem Zizas i bin spik ane po Zizas po ile demwan uda i sik. ");
INSERT INTO tcs_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Plentitaim Zizas bin go emselp po kuaiatples po prea. ");
INSERT INTO tcs_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Orait. Wandei wen Zizas i bin tise dem pipol, sam dem Parasi ane dem Zuwislotisa ol bin sidaun de po lisen tu. Dempla bin kam prom ebri biliz wea Galali, Zudia ane prom Zarusalem. Da paua blo da LodGod i bin de wea Zizas po ile ol sikman. ");
INSERT INTO tcs_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nadataim sam man i bin kare wan paralaizman kam wea mat wase stresa. Dempla i bin trai po tekem po go insaid da aus po putem prant wea Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Bat dempla kan paine wei po go insaid bikoz tumas pipol i bin stanap de. I nogad no rum po go insaid, so dempla bin mata go antap wea rup. Dempla bin meke oll wea da rup ane dempla bin teke da man wea mat, taite rop wea dem kona blo da mat, den dempla bin slaike da mat godaun, melen wea dem pipol de prant wea Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wen Zizas i bin luk da prapa strong bilib blo dempla, em bin spik po dat sikman, ‘Mai boi, ai tekemaut ol dem nugudwei blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Dem Parasi ane dem Zuwislotisa ol bin tingk, ‘Uda dis man? Em spik badtok gense God. Em daune God! Wen em tekemaut sin em i meke emselp wase God. Mata God ken tekemaut sin.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bat Zizas sabe wanem dempla bin tingbaut, so em bin spik stret po dempla, ‘Ei lugaut. Ai sabe wanem yupla tingbaut. ");
INSERT INTO tcs_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yupla tingk i moizi po spik po dis man, “Yu nogad no sin nau, i pinis”, o po spik, “Gedap ane wagbaut?” ");
INSERT INTO tcs_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ai go soe yupla! Ai wande yupla po sabe diswan. Ai da Truwan blo Man, ai kare lo ya wea ert po tekemaut sin.’ Den Zizas bin tan po da paralaizman ane spik po em, ‘Gedap, rolemap mat blo yu ane go aus.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Stretwei da man bin stanap prant wea dempla, rolemap mat blo em. Den em bin wagbaut go aus ane em bin mata preize God. ");
INSERT INTO tcs_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ebribodi i bin prapa atzamp ane ol i bin preize God tu. Dempla bin prapa prait baut disting bat dempla ebriwan bin pil nadakain gud insaid. Dempla bin spik po wananada, ‘Prapa gudting bin apen ya tidei ane diswan i bin meke yumpla atzamp.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Apta nau wen Zizas bin kamaut prom dat taun, em bin luk wan taksman. Neim blo da man i Libai. Em sidaun de wea taksopis blo em. Zizas bin spik po em, ‘Ei yu. Yu kam pole mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Libai bin gedap, libe ebriting blo em biain ane em bin pole Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Apta nau, Libai i bin meke big kaikai po Zizas wea aus blo em. Bigmob pipol i bin de ane plenti taksman i bin kam tu. ");
INSERT INTO tcs_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Sam dem Parasi ane sam dem Zuwislotisa blo dat seim grup, ol bin komplein po dem klostuman blo Zizas. Dempla spik diskain, ‘Wiskain yupla kaikai ane dringk melen wea ol taksman ane ol dem nada man, dempla ol nugudman?’ ");
INSERT INTO tcs_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Zizas bin ansa po dempla, ‘Ol sikpipol nide dokta, no dem strong eltiwan. ");
INSERT INTO tcs_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ai no bin kam po spik ol demwan uda tingk dempla rait ane stret. Ai bin kam po spik demwan uda sabe dempla i nugud po seinze nugudwei blo dempla.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sam pipol i bin kam komplein po Zizas. Ane dempla bin aske em diskain, ‘Ol dem klostuman blo Zon Baptaizman, plentitaim dempla pasting, no kaikai po meke prea. Ane i seimkain wea ol dem klostuman blo ol dem Parasi. Bat wiskain ol klostuman blo yu? Dempla mata kaikai ane dringk.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","So den Zizas bin aske dempla, ‘Wiswei? Yupla go meke ol weding gest no kaikai a, wen da man uda go maret, em i stil de melen wea dempla? Nono! Yupla kan. ");
INSERT INTO tcs_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Da taim go kam wen da man uda bin maret, em go go prom dempla po gud. Datwan i da taim wen dempla nogo kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Den Zizas i bin yan dempla dis stori wea i gad mining. ‘Nobodi teke niu kaliko po pasem wea oul kaliko, bikoz yupla sabe da niu kaliko go brok tu. Dat pis prom da niu kaliko, em no gobi seimkain wase da oul kaliko. ");
INSERT INTO tcs_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","‘Pipol no kapsaid niu wain go insaid oul skinbaig. Ip ol mekem diskain, da niu wain go base dat oul skinbaig ane da wain go kapsaid ane ran ausaid, bikoz da skinbaig i go bas prom da niu wain. ");
INSERT INTO tcs_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mobeta yupla kapsaid da niu wain insaid wea niu skinbaig. ");
INSERT INTO tcs_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Enibodi uda bin dringk dat oul wain nogo wande da niu wain. Dempla go spik, “Dat oul wain i tes mogud.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Orait nau. Wan Zuwis Sabatdei, Zizas bin wagbaut wea wan gadan wea pama groe wit po meke plaua. Ol klostuman blo Zizas bin de ane dempla bin broke sam sided. Dempla bin tekemaut dat ausaid skinpat ane ol bin kaikai da insaid sidpat. ");
INSERT INTO tcs_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Sam dem Parasi ol bin aske Zizas, ‘Aukam ol klostuman blo yu i bin broke da lo? Dempla bin meke wok wea Zuwis Sabatdei. Yupla sabe yupla no lau po broke sided po kaikai wea Sabatdei.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Zizas bin ansa dempla, ‘Wiswei? Yupla bin ridem wanem King Deibid ane ol man blo em i bin mekem wen dempla bin anggre? ");
INSERT INTO tcs_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Deibid bin go insaid aus blo God. Em bin kaikai da spesil opringbred blo God dat mata prist i lau po kaikai. Ane Deibid bin gibe sam po ol dem man uda i bin de wea em.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Den Zizas bin spik gen, ‘Ai da Truwan blo Man uda gad antap paua. Mata mi kare dem lo blo da Sabatdei bikoz ai da BosLod blo da Sabatdei.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Orait. Nada Zuwis Sabatdei nau Zizas bin go insaid da zuwispreaus ane em bin tise dempla. Wan man melen wea dempla i bin gad paralaiz raitan. ");
INSERT INTO tcs_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ol dem Parasi ane dem Zuwislotisa i bin wase Zizas adwan, wanem em go mekem. Dempla bin wande luk ip em go ile da man wea Zuwis Sabatdei so dempla ken paine polt wea em po broke dem lo blo da Sabatdei. ");
INSERT INTO tcs_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bat Zizas bin sabe wanem dempla tingbaut. So em bin spik po da man uda gad paralaiz an, ‘Yu kam stanap ya melen wea da zuwispreaus.’ Da man bin gedap go ane stanap de. ");
INSERT INTO tcs_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Den Zizas bin spik, ‘Ai aske yupla disting. Wiswei da raitwei? I mobeta po meke gudting o meke badting wea Sabatdei? I mobeta po ile em o mata libe em diskain?’ ");
INSERT INTO tcs_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Zizas bin wase dempla prapa ad, den em spik po da man, ‘Strete an blo yu kamaut.’ Da man i bin lisen em ane strete an blo em go ausaid. Stretwei an blo em bin kamgudgen wase leptan blo em. ");
INSERT INTO tcs_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","So nau dem Zuwislotisa ane dem Parasi uda i bin enami blo Zizas, ol bin prapa wail. Dempla i bin tok po wananada, ‘Ei! Wanem yumpla go mekem po em?’ ");
INSERT INTO tcs_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Go nau. Zizas bin go wea da maunten po prea. Ol nait em prea po God, raittru po deilait. ");
INSERT INTO tcs_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wen i bin elimoning nau, Zizas bin singaut ol dem klostuman blo em po kam klostu. Em bin suze tuelb man prom ol dem nada klostuman po sane dempla go ebriwea wea neim blo em. Em bin meke dempla misnareman blo em. Neim blo dempla: ");
INSERT INTO tcs_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Saiman (Zizas i bin gibe em nada neim, Pita), Andru (bala blo Saiman), Zemes, Zon, Pilip, Batolomiu, ");
INSERT INTO tcs_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiu, Tomas, Zemes (boi blo Alpias), Saiman (ol bin kole em da Zelot bikoz em pat blo dat Zelotgeng uda bin pait po dem rait blo ol Zuwispipol), ");
INSERT INTO tcs_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Zudas (boi blo Zemes) ane Zudas Iskara (em da wan uda apta, bin sele Zizas po dem Zuwislida po kilem). ");
INSERT INTO tcs_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Orait nau. Apta wen Zizas bin prea, Zizas ane dem tuelb misnareman blo em bin kamdaun prom da maunten. Dempla i bin kam stanap wea big lebelples. Nada bigmob klostuman blo em ane plenti bigmob pipol i bin de weit po em. Dempla bin kam prom ebriwea wea Zudia, prom Zarusalem ane prom tu taun wea da koslain, Taira ane Sidon. ");
INSERT INTO tcs_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ol bin kam po lisen Zizas ane em po ile demwan uda i sik. Dempla uda bin gad debolspirit insaid wea dempla bin kamgud tu. ");
INSERT INTO tcs_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Da bigmob pipol ol bin trai po tase em bikoz dempla bin pile da paua blo Zizas ane da paua bin meke ebriwan kamgudgen. ");
INSERT INTO tcs_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Zizas i bin sluraun luk po dem klostuman blo em ane em bin spik diskain: ‘Yupla gobi api nomata yupla louklas, bikoz yupla sabe yupla blo God ane em ruloba yupla nau. ");
INSERT INTO tcs_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Yupla gobi api nomata yupla anggre, bikoz yupla sabe God go meke yupla satispai. Yupla gobi api nomata yupla krai, bikoz yupla sabe God go meke yupla lap. ");
INSERT INTO tcs_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‘Yupla gobi api nomata pipol eite yupla, puse yupla go ausaid, pute neim blo yupla daun ane tok ol nugudtok baut yupla, bikoz yupla bilib ane pole mi, da Truwan blo Man. ");
INSERT INTO tcs_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ip ol demting i apen, yupla ken mata glad nau ane klape an blo yupla. Yupla go gede big riwod wea eben. Bikoz diswan i da seimkain wase ol dem longtaim pamle blo yupla i bin trite ol spesilmesizman blo God.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Ai wone yupla, lugaut. Yupla ol dem rispipol uda mata tingbaut yuplaselp, yupla go gad prapa adtaim prom God, bikoz yupla olredi gad izilaip ya. ");
INSERT INTO tcs_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ei! Ai wone yupla, lugaut. Yupla uda sidaun de satispai, yupla go mata stap anggre. Ei! Ai wone yupla, lugaut. Yupla uda lap nau, yupla go mata gad bigsore ane krai. ");
INSERT INTO tcs_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","So, nomata ol pipol spik gudting baut yupla, i gobi bad po yupla. Ei! Ai wone yupla, lugaut. Dem longtaim pamle blo yupla bin spik seimkain gudting baut dem laimesizman, bat dem laimesizman bin prapa nugud.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Zizas bin kip tok, ‘Bat nau ai spik yupla ebriwan uda lisen: Labe enami blo yupla ane meke gudpasin po dempla uda eite yupla. ");
INSERT INTO tcs_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ip sambodi kers yupla, yupla aske God po meke gudpasin po dempla. Prea po dempla uda trite yupla nugudwei. ");
INSERT INTO tcs_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ip sambodi slape yupla wansaid wea pes, spik em po slape yupla lo nadasaid tu. Ip sambodi teke klos blo yupla, yupla gibe em nada klos tu. ");
INSERT INTO tcs_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Yupla i gibe ebriwan samting uda aske yupla po samting. Ip sambodi teke samting blo yupla, yupla no spik, “Gibe mi baik.” ");
INSERT INTO tcs_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ip yupla wande sambodi po meke samting gud po yupla, yupla mas meke gudsamting po dempla pas. ");
INSERT INTO tcs_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Yupla nogo gede blesing ip yupla mata labe sambodi uda labe yupla. Demwan uda no pole God i gad seimkainwei tu. ");
INSERT INTO tcs_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yupla nogo gede blesing ip yupla mata elpe sambodi uda elpe yupla. Demwan uda no pole God i gad seimkainwei tu. ");
INSERT INTO tcs_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yupla nogo gede blesing ip yupla gibe samting po sambodi uda go peibaik yupla. Demwan uda no pole God i gad seimkainwei tu. ");
INSERT INTO tcs_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","‘Mobeta yupla meke gudpasin po ol enami blo yupla ane labe dempla. Ip yupla gibe samting po dempla, yupla no aske dempla po peibaik yupla. Den yupla go gad prapa big riwod. Yupla gobi pikinini blo da Prapa AntapGod. God i gad prapa gudpasin po ol pipol nomata dempla nugudpipol ane dempla no lisen ane eso em. God stil labe dempla. ");
INSERT INTO tcs_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yupla mas sore po dempla wase PapaGod em sore po yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Zizas i kip spik, ‘Yupla no tingbaut o tokbaut dem nugudting wanem ol dem nada pipol i mekem. Yupla no daune dempla, den God nogo daune yupla. Yupla mas pogibe dempla, den God i go pogibe yupla. ");
INSERT INTO tcs_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yupla gibe samting po demwan uda nogad, den God go gibe yupla plenti mo, obamak. God go meke da seimwei po yupla wase yupla mekem po ol nada pipol.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Zizas bin yan dempla stori wea i gad mining. Em bin spik diskain, ‘Ip wan blainman go lide nada blainman, demtu go poldaun insaid oll. ");
INSERT INTO tcs_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Demwan uda go skul, dempla no big wase tisa blo dempla. Bat demwan uda bin pinis lan ebriting, dempla go kam wase tisa blo dempla. ");
INSERT INTO tcs_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","‘Ei! Wiskain yu go luk da prapa smol dati insaid ai blo bala blo yu, wen yu no luk da prapa big dati de wea ai blo yu. ");
INSERT INTO tcs_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wiskain yu go spik po bala blo yu? “Yagar. Bala kam ya. Ai go tekemaut da smol dati prom ai blo yu.” Bat yu kan luk dat prapa big dati wea ai blo yuselp. Yu prapa stupit. Yu meke yuselp gudman. Bat yu sabe, yu mas tekemaut dat prapa big dati prom ai blo yu pas, den yu ken luk prapa kliawan po tekemaut da smol dati prom ai blo bala blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Zizas bin kip tok po dempla diskain, ‘Yupla sabe. Gudtri no sake nugudprut, ane nugudtri no sake gudprut. ");
INSERT INTO tcs_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yupla no broke wangai prut prom gaibui o broke mekei prut prom sigras. Nono! Yupla sabe ebri tri gad prut blo dempla. ");
INSERT INTO tcs_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Da gudman tingbaut ol gudting. Wen em spik, em spik ol gudting. Bat nugudman tingbaut ol nugudting. Wen em spik, em spik ol nugudting. Ol demting yupla tingbaut wea at blo yupla i go kamaut prom maut blo yupla wen yupla go spik.’ ");
INSERT INTO tcs_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Den Zizas bin kip spik diskain po dem klostuman blo em, ‘Ei! Wanem yupla kip kole mi, “Masta, ane Bos”, po? Yupla no mekem wanem ai spik yupla po mekem. ");
INSERT INTO tcs_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Enibodi uda kam po lisen wanem ai spik ane mekem wanem ai spik em po mekem, em diskain man. ");
INSERT INTO tcs_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Em wase da kapenta uda meke aus po emselp. Bipo em stat bilde aus, em i go diginem godaun po da rok po meke da paundeisan antap da rok. Wen da riba go plad ane da pladwata go plade dat aus, da aus nogo brok, bikoz da waiz kapenta bin meke paundeisan blo da aus prapa strong. ");
INSERT INTO tcs_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bat da man uda lisen tok blo mi bat no mekem wanem ai spik em po mekem, em wase da stupit kapenta uda bin meke aus nogad paundeisan. Wen da pladwata go plade dat aus, da aus go poldaun ane smas, ane i go meke prapa big mes.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Orait nau. Wen Zizas bin pinis yan ol dem stori po dem pipol, em bin gobaigen po Kapaniam. ");
INSERT INTO tcs_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Wea dat seim taun i bin gad wan sekan amiopisa blo Rom uda bin gad wan sebant. Dat amiopisa bin prapa labe em ane rispekt em. Dis sebant i bin prapa sik, klosap ded. ");
INSERT INTO tcs_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Da amiopisa i bin lisenbaut Zizas, so em bin sane sam Zuwiselda blo da taun go po Zizas. Dempla bin bege Zizas po kam ane seibe laip blo da sebant. ");
INSERT INTO tcs_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Dempla bin bege em diskain, ‘Dis amiopisa em i prapa gudman. Yu mas elpe em bikoz em meke olkain gudting. ");
INSERT INTO tcs_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Em labe ol Zuwispipol ane em bin bilde da zuwispreaus wea mani blo em.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","So Zizas i bin go wea dempla. Wen em bin kam klostu po da aus, da sekan amiopisa bin luk em kam ane em bin sane ol pren blo em po spik Zizas diskain ya, ‘BosLod, yu no kam po aus blo mi, bikoz ai nugud. ");
INSERT INTO tcs_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Daswai ai no bin go lukraun po yu. Bat yu mata gibe oda ane meke sebant blo mi kamgudgen. ");
INSERT INTO tcs_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yu sabe ai bos, ai kare lo seimkain wase yu ane ai gad bigbos tu wea dis ami. Ai ken gibe oda po ol dem amiman blo mi ya. Ai ken spik po wan, “Yu go”, ane em go. Ai spik po nadawan, “Yu kam”, ane em kam. Ai spik sebant blo mi po meke diswan ane em pole da oda. Orait, Zizas, yu mata gibe oda nau.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Zizas bin atzamp wen em bin lisen dis tok ane em bin sluraun po ol dem bigmob pipol uda bin pole em. Zizas bin spik diskain, ‘Ei lugaut! Ai no bin paine nobodi ya wea Izrael uda gad diskain big bilib.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wen ol dem pren bin kambaigen po da aus blo dat amiopisa, ol bin paine da sebant i sidaun gudwan, em nomo sik. ");
INSERT INTO tcs_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Apta nau, Zizas bin go po wan taun, neim blo da taun i Nein. Ol dem klostuman blo Zizas ane bigmob pipol i bin go wea em tu. ");
INSERT INTO tcs_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wen em bin kam klostu po da geit blo da taun, piunrul prosesan blo wan boi kamaut prom da taun. Dat boi i bin da wan pikinini blo wan widooman de wea da taun. I bin gad bigmob pipol wagbaut longsaid wea da widooman. ");
INSERT INTO tcs_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wen da BosLod bin luk da widooman, em bin prapa sore po em. Em bin toknais po em, ‘Mai gel. Yu no krai.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Zizas bin go ane em bin tase dat bodi blo da boi. Den ol dem man uda bin kare da bodi i bin stap. Zizas bin spik diskain, ‘Yangboi. Ai spik yu nau, gedap.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Den da boi bin kamlaip, gedap ane em bin stat po tok. So Zizas bin teke em go po mama blo em. ");
INSERT INTO tcs_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ebribodi bin nadakain prait, mata preize God. Dempla bin spik, ‘God kam po seibe ol pipol blo em. Prapa big spesilmesizman blo God, em ya melen wea yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dis niuz blo Zizas bin spred ebriwea wea Zudia ane ol dem nada kantri eria. ");
INSERT INTO tcs_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Orait nau. Ol klostuman blo Zon Baptaizman bin spik po Zon ol demting wea Zizas i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Apta nau, Zon Baptaizman bin singaut po tu klostuman blo em. Em bin sane demtu go po aske da BosLod wan kuestin. ");
INSERT INTO tcs_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Demtu bin kam po Zizas ane spik po em, ‘Zon Baptaizman bin sane mitu po aske yu, “Yu da Promiswan, da wan uda Zon bin spik i go kam a, o mipla mas lukraun po nada man?” ’ ");
INSERT INTO tcs_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Dat seimtaim nau Zizas bin bizi ile plenti pipol uda gad olkain sik ane uda bin gad debolspirit. Em bin meke plenti blainman kamgud so ol ken lukgen. ");
INSERT INTO tcs_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","So Zizas bin ansa demtu diskain, ‘Yutu gobaigen po Zon ane spik em wanem yutu bin luk ane lisen ya. Demwan uda bin blain i ken luk ane demwan uda bin kripol i ken wagbaut. Demwan uda bin gad skindiziz, i kamgud. Demwan uda bin dep i ken lisen ane demwan uda bin ded i gedap laipwan. Dem pipol uda nogad mani i lisen da Gudniuz blo God. ");
INSERT INTO tcs_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ebribodi go prapa glad uda kip bilib ane nogo libe mi, nomata wanem ai mekem.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Apta nau wen da tu klostuman blo Zon bin gobaik, Zizas bin spik diskain po dem bigmob pipol baut Zon, ‘Dat taim wen yupla bin go ausaid po dezetples po lisen wanem Zon bin pris, wanem yupla bin tingk yupla go luk ane lisen de? Yu tingk em wikman wase long gras, da win blou em ebriwei? ");
INSERT INTO tcs_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wiskain man yupla bin go po luk? Yupla bin luk po man uda were plasklos a? Ol dempla uda were plasklos ol stap de wea palis blo king. ");
INSERT INTO tcs_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Orait. Yupla spik po mi nau. Wanem yupla bin go de po luk? Yupla bin go po luk spesilmesizman blo God a? Wa. Zon i spesilmesizman blo God, bat em mobig wea dem longtaim spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Da Baibol bin spik Zon Baptaizman em i spesilmesizman blo God. Ane da Baibol i spik diskain baut em: “Ai go sane mesizman go pas, bipo da Promiswan go kam. Em go meke da wei redi po yu po kam.” ");
INSERT INTO tcs_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","‘Ai spik yupla nau, Zon em i mobig wea eni man uda bin bon ya wea ert. Bat ol dem louklas pipol uda lisen wod blo mi ane pole da niuwei blo God wen em go ruloba ebriwan, dempla gobi mobig den Zon.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ol dem pipol uda bin lisen Zon, ane dem taksman bin gri wea Zizas, da wei blo Zon i bin da raitwei. Daswai ol bin aske Zon po baptaiz dempla. ");
INSERT INTO tcs_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mata dem Parasi ane ol dem smatman blo dem Zuwislo no bin wande lisen o pole dat plan blo God. Dempla no bin wande go po Zon po baptaiz dempla. ");
INSERT INTO tcs_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Orait. Zizas bin kip tok po dempla, ‘Ei! Wiskain pipol yupla? Wiskain pipol yupla distaim ya nau? ");
INSERT INTO tcs_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yupla wase smolpikinini uda sidaun wea plei eria. Ol singaut bleime wananada: “Mipla bin plei dans miusik po yupla, bat yupla no bin tekenotis. Yupla no bin dans. Mipla bin sing piunrul sing po yupla, bat yupla stil no bin tekenotis. Yupla no bin krai.” ‘Yupla ol pipol ya nau wea dis kantri, yupla wase pikinini. Yupla stil no satispai. Nomata wiswei ai go mekem, yupla go spik mi, “Yu rong.” ");
INSERT INTO tcs_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","‘Zon i bin kam gibe da mesiz blo God. Em no po dringk wain ane kaikai plentitaim. Wei blo em i bin prapa streinz, so yupla bin spik, “Em gad debolspirit insaid wea em.” ");
INSERT INTO tcs_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","So nau wen ai bin kam, da Truwan blo Man, ai bin kaikai ane dringk wain ane yupla spik, “Ei luk em! Em kaikai obamak ane em i spakman. Em pren blo ol nadakain nugudman, ol sina.” ");
INSERT INTO tcs_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Yupla sabe waizwei blo God em i raitwei bikoz wen yupla luk dempla uda pole ubi blo God, dempla gad gudlaip.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Orait. I bin gad wan Parasi, neim blo em Saiman. Em bin aske Zizas po kam kaikai wea aus blo em. So Zizas bin go po aus blo em ane sidaun redi po kaikai. ");
INSERT INTO tcs_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Wan oman uda bin prapa nugudoman bipo, em bin stap de wea dat taun. Em bin paindaut Zizas em i kaikai wea aus blo dat Parasi. So nau, em bin teke prapa dia sentoil wea plas stonbotol, go de po Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Em bin kam insaid dat aus ane em bin nildaun longsaid wea Zizas, klostu wea put blo Zizas. Den em bin base bigkrai. Wen tia blo em bin wete put blo Zizas, em bin waipe dem tia wea eya blo em. Den em bin kise put blo Zizas ane em bin kapsaid sentoil wea put blo Zizas po ona em. ");
INSERT INTO tcs_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wen dat Parasi uda i bin inbait Zizas po kam aus blo em bin luk wanem dat oman bin mekem, em tingk diskain nau, ‘Ei! Ip dis man em prapa spesilmesizman blo God em spostu sabe dis oman i prapa nugudoman ane em no lau po tase em.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Zizas bin tok po da Parasi, ‘Saiman. Ai gad samting po spik yu.’ So Saiman bin ansa em baigen, ‘Tisa, yu mata spik mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Den Zizas bin spik diskain po em, ‘Tu man bin oue mani po da baingkmaniza. Wan man bin oue em 500 silba koin. Nadawan bin oue em 50 silba koin. Pas man bin oue em tentaim mo wea da nadawan. ");
INSERT INTO tcs_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Bat demtu nogad mani po pei em baik. So da baingkmaniza bin prapa sore po demtu. Den em bin spik po demtu, “I orait. Mata libem. No nid po pei mi baik.” ’ Zizas kip spik, ‘Uda yu tingk go labe da baingkmaniza mo?’ ");
INSERT INTO tcs_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saiman bin ansa em, ‘Ai tingk da wan uda gad mobig det.’ Zizas spik baik po em, ‘Wa, de nau. Yu rait.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Den em bin sluraun po da oman, bat em kip spik po Saiman, ‘Yu luk dis oman, wanem em bin mekem. Ai bin kam insaid aus blo yu bat yu no bin gibe mi wata po wase put blo mi. Bat dis oman ya bin wase put blo mi wea tia blo em ane em bin draiem wea eya blo em. ");
INSERT INTO tcs_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yu no iben bin kise mi. Bat prom dat taim ai bin sidaun ya, dis oman ya no bin stap prom kise put blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yu no bin gibe mi oliboil po rabem wea ed blo mi, bat dis oman ya, em bin kapsaid prapa dia sentoil wea put blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","‘Ai spik yu nau, nomata em bin gad prapa plenti nugudwei, ai bin pinis tekemaut sin blo em. Daswai em gad biglab po mi. Bat demwan uda nogad plenti sin po tekemaut, yupla sabe, demwan nogo labe God mas.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Den Zizas bin spik po dat oman, ‘Ai tekemaut ol nugudwei blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ol dem nada gest bin tok po wananada. ‘Ei! Uda dis man ya uda tekemaut sin?’ ");
INSERT INTO tcs_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Den Zizas bin kip spik po da oman, ‘Bilib blo yu bin seibe yu. Mata go wea pis.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Apta nau Zizas bin go wagbaut prom dat taun, go biliz, go po nada taun, kipgo diskain. Em bin pris ebriwea baut da Gudniuz, dat God i go ruloba ebriwan ane ebriting. Ol dem tuelb klostuman blo em bin de wea em tu. ");
INSERT INTO tcs_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Sam oman bin de tu wea em, bikoz em bin ile dempla prom ol diprenkain sik ane em bin spik po dem debolspirit po kamaut prom dempla. Meri em bin wan prom dempla. Ol bin kole em Meri Magdala bikoz em bin kam prom dat ples Magdala. Seben debolspirit bin kamaut prom em. ");
INSERT INTO tcs_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Nada oman i bin Zoana. Man blo em Kusa, i bin maniza po King Erod. Suzana ane ol plenti nada oman ebritaim elpe Zizas. Dempla bin gibe mani po em ane ol dem klostuman blo em. ");
INSERT INTO tcs_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Orait. Prapa plenti pipol i bin kam de, kam prom ebri taun, kam tugeda de wea Zizas po lisen po em. So nau em bin yan wan stori wea i gad mining. ");
INSERT INTO tcs_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","‘I bin gad wan man ane em i pama, em i meke gadan. Em bin go po meke gadan ane em bin sake ol sid wea da gadan. Bat sam sid bin poldaun wea rod wea ebriwan i wagbaut. Pizin i bin kam kaikai dem sid. ");
INSERT INTO tcs_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Sam dem nada sid bin poldaun wea stonigraun. Wen ol bin bas, dem smolplant bin draiap bikoz nogad wata. ");
INSERT INTO tcs_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nada sid bin poldaun wea bainplant bin krol, bat wen ol dem plant bin trai stat po gro, dempla kan bikoz da bainplant bin krol antap dempla. ");
INSERT INTO tcs_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ane sam dem nada sid bin poldaun wea gudgraun ane ol bin gro gudwan, sake plenti kaikai.’ Wen Zizas bin pinis yan da stori, em bin spik diskain, ‘Yupla lisen uda gad talinga, ane yupla prapa tingbaut nau!’ ");
INSERT INTO tcs_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Apta nau, ol dem klostuman bin spik po Zizas, ‘Mipla no sabe da mining, yu spik po mipla.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","So Zizas bin ansa dempla baigen, ‘God bin gibe yupla da sabe so yupla ken sabe i tru, dis niuwei wen God i go ruloba ebriwan ane ebriting. Bat po dem nadalot pipol, dem stori i mata stori. Em i diskain: “Dempla luk, bat dempla luk nating. Dempla lisen, bat ol no sabe.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","So Zizas bin stat po eksplein po dem klostuman da mining blo dat stori. Em spik, ‘Da sid, em i wod blo God. ");
INSERT INTO tcs_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ol dem sid wea i poldaun melen wea rod, i wase dempla uda lisen dem wod blo God. Bat da debolspirit kam ane tekemaut da wod prom at blo dempla, so dempla no go bilib ane God kan seibe dempla. ");
INSERT INTO tcs_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ol dem nada sid wea i poldaun wea stonigraun, i wase dempla uda lisen dem wod blo God. Dempla glad po lisen, bat dempla no prapa tekem go insaid at blo dempla. Dempla bilib po sottaim, bat wen da adtaim go kam, dempla go poldaun ane gibap. ");
INSERT INTO tcs_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Dem sid wea i poldaun wea da bainplant, i wase dempla uda lisen dem wod blo God. Bat dem wod kan gro ane wok wea laip blo dempla bikoz dempla nogad rum po dem wod blo God. Dempla tumas woribaut wande plenti mani ane olkain gudting po meke dempla api. ");
INSERT INTO tcs_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Dem nada sid nau wea i poldaun wea da gudsoil, i wase dempla uda lisen dem wod blo God ane kipe dem wod prapa strong insaid at blo dempla. Dempla gad gudpasin ane dempla oltaim spik da gudniuz baut God.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Zizas bin spik po dem klostuman gen, ‘Yupla sabe. Nobodi laite lamp kabarem wea dis, o aidem andanit wea bed. Nono! Ebriwan uda laite lamp mas angem antap so demwan uda kam insaid ken luk wea dempla go. ");
INSERT INTO tcs_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","God go meke dem wod blo em prapa klia. Bambai ebri sikretting go kamaut po ol pipol po luk. Ebri sikretting go kamaut wea da lait blo em. ");
INSERT INTO tcs_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","‘So yupla nau mas lisen prapa gud po dem tok blo God. Ip sambodi gad bilib wea God, God go gibe em mo. Bat ip yupla nogad, God go tekemaut ebriting olgeda. Iben ip yupla tingk yupla gad bilib, em go tekemaut datwan tu.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Den mama blo Zizas ane ol bala blo em, dempla bin kam po luk em. Bat dempla kan kam klostu, bikoz tumas pipol bin stanap raun wea em. ");
INSERT INTO tcs_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Sambodi bin go spik po Zizas, ‘Mama ane ol bala blo yu ya stanap ausaid. Dempla bin kam po luk yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Zizas bin ansa dempla diskain, ‘Yupla uda lisen ane pole da mesiz blo God, demwan i mama ane ol bala blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Orait nau. Wandei Zizas ane dem klostuman blo em bin go wea bot. Zizas bin spik po dempla, ‘Yumpla go kros go nadasaid blo da leik.’ So dempla bin go. ");
INSERT INTO tcs_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wail dempla bin seilbaut go, Zizas em bin go leidaun po slip. No teke long, prapa big strong win bin kam kros wea da leik. Da wata bin stat kam insaid da bot ane dempla bin gad big trabol. ");
INSERT INTO tcs_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","So dem klostuman bin go po Zizas, weikemapem ane singaut po em, ‘Masta! Ei, yumpla go draun!’ Den Zizas bin gedap ane em bin oda da win ane da big rapsi, ‘Yu stap!’ Stretwei da win bin stap kuaiat ane da si bin kam wase gris. ");
INSERT INTO tcs_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Zizas bin aske dempla, ‘Ei, wea bilib blo yupla?’ Dempla bin prapa prait ane atzamp. Dempla tok po demplaselp, ‘Ei! Uda dis man? Em gibe oda ane da win bin stap ane da wata i kam wase gris!’ ");
INSERT INTO tcs_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Apta nau, dempla bin kese Gerasin, nadasaid blo da leik, kros prom Galali. ");
INSERT INTO tcs_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wen Zizas bin zamp ausaid prom da bot po sanbis, wan man prom dat taun bin mite em de. Dat man em bin gad olkain debolspirit stap insaid wea em. Em bin wagbaut neketwan. Em no stap wea aus, em bin stap wea sematri. ");
INSERT INTO tcs_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","So nau, wen da man bin luk Zizas, em bin poldaun prant wea Zizas. Em bin singaut prapa laudwan, ‘Wanem yu wandem wea mi Zizas, Boi blo da Prapa AntapGod. Plizgar, yu no panse mi, ane no meke mi po sapa.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Plentitaim dem debolspirit i bin tekoba laip blo da man ane plenti pipol i bin gade em ol da taim. Dempla bin pute sein wea an ane leg blo em bat em bin kip broke dem sein. Ane dem debolspirit bin meke em go wea da dezetples wea i nogad no pipol de. ");
INSERT INTO tcs_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Zizas bin aske em, ‘Wanem neim blo yu?’ Em bin ansa baigen po Zizas, ‘Prapa bigmob.’ Em ansa diskain bikoz plenti debolspirit bin stap insaid wea em. Zizas bin oda dem debolspirit po kamaut prom da man. ");
INSERT INTO tcs_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ol dem debolspirit bin bege Zizas no po sane dempla go po el. ");
INSERT INTO tcs_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","I bin gad prapa bigmob pig bin kaikai de wea dat ilsaid. Ol dem debolspirit bin bege Zizas po sane dempla go insaid wea ol dem pig. So Zizas bin gri. ");
INSERT INTO tcs_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","So ol dem debolspirit bin kamaut prom da man ane ol bin go insaid dem pig. Den ol dat bigmob pig bin ran godaun dat ilsaid, ol bin go insaid da leik ane ol dem pig bin draun. ");
INSERT INTO tcs_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wen ol dem pipol uda i bin lugaut dem pig bin luk wanem bin apen, dempla bin wail. Dempla bin ranwei ane dempla bin go sprede da niuz wea dat taun ane raitraun wea dat ausaid kantri eria. ");
INSERT INTO tcs_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Plenti pipol i bin go luk po wanem bin apen de wen dempla bin kam de wea Zizas. Dempla bin luk dat man wea ol dem debolspirit i bin kamaut prom em. Em bin sidaun de klostu po Zizas. Em bin were klos nau. Em nomo senslus ane em ken tingk stret nau. Dem pipol bin prapa prait. ");
INSERT INTO tcs_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Dempla uda bin luk wiskain Zizas bin meke da man kamgud prom dem debolspirit, bin yan po dem nadalot pipol. ");
INSERT INTO tcs_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Apta nau, ol dem pipol prom dat kantri eria blo Gerasin bin bege Zizas po go, po libe dat eria blo dempla bikoz dempla bin prapa nadakain prait prom demting wanem bin apen de. So Zizas ane ol klostuman blo em bin go nau. Dempla bin zamp insaid da bot ane redi po go. ");
INSERT INTO tcs_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Dat man wea Zizas bin tekemaut dem debolspirit bin bege em ip em ken go wea em. Bat Zizas bin spik, ‘Nono! Yu no kam. Yu stap ya. ");
INSERT INTO tcs_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Mobeta yu go aus po pamle blo yu. Yu spik dempla wanem gudting God bin mekem po yu.’ So dat man bin go aus. Apta em bin go po da taun, em bin spik po ebriwan de wea da taun ol demting wanem Zizas i bin mekem po em. ");
INSERT INTO tcs_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Apta Zizas bin kambaik prom Gerasin, bigmob pipol bin de, weit po em. Dempla bin welkam em. ");
INSERT INTO tcs_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wan man, neim blo em Zairas, em i wan lida blo da zuwispreaus. Em bin kam de po luk Zizas. Em bin nildaun prant wea em. Em bin bege Zizas diskain, ‘Plizgar, yu kam aus blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Tuelb iya oul gel blo mi, em klosap po ded. Em da wan gel blo mi.’ So Zizas bin go, bat i bin gad prapa bigmob pipol raun wea em. Ol bin puse dempla wei klostu po em. ");
INSERT INTO tcs_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Wan oman bin de, melen wea dat bigmob tu. Em bin gad big problem wea mantli blo em po tuelb iya. Ebritaim em luze tumas blad. Nobodi ken ile em. ");
INSERT INTO tcs_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","So em bin kam biain Zizas, prapa klostu po em, ane em bin tase end blo da klos blo Zizas. Stretwei da blad bin stap ane em bin kamgudgen. ");
INSERT INTO tcs_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Zizas bin sluraun ane singaut, ‘Uda bin tase mi?’ Ebriwan bin spik, ‘Nono! Mipla no bin tase yu.’ Den Pita bin spik, ‘Ei tisa. I gad plenti pipol ya, bigmob raun wea yu. Ol puse demplaselp kam klostu po yu ane tase yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bat Zizas ansa dempla baigen. ‘Ai sabe. Ai sabe sambodi bin tase mi, bikoz ai bin pile da paua go prom mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wen da oman bin sabe em kan aide emselp enimo, em bin prait. Em bin prapa seik ane nildaun prant wea Zizas. De nau em bin spik po Zizas, prant wea ol dem pipol, em bin tase Zizas bikoz em bin sabe Zizas ken ile em. Wa, ane wen em bin tase Zizas, stretwei em bin kamgud. ");
INSERT INTO tcs_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Zizas bin spik po em, ‘Mai gel. Bilib blo yu bin meke yu kamgudgen. Go nau, yu go wea pis.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wail Zizas bin stil tok po da oman, wan man bin kam prom aus blo Zairas, da zuwispreaus lida. Dat man bin spik po Zairas, ‘Ai teke badniuz kam po yu. Gel blo yu bin pasawei. Noboda po da tisa po kam nau.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Wen Zizas bin lisen dis tok, em spik po Zairas, ‘Yu no prait, yu mata bilibe mi, trase mi. Gel blo yu, em go kamgud.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","So wen Zizas bin kese da aus blo Zairas, em no bin laue nobodi po go insaid wea em, mata Pita, Zon, Zemes ane papa ane mama blo da gel. ");
INSERT INTO tcs_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ebribodi uda bin stanap de bin mata krai ane prapa sore. Zizas bin spik stret po dempla, ‘Ei, wanem yupla krai po? Em no ded. Em slip.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Dempla ebriwan bin lap em. Dempla tingk em sili po spik dat tok bikoz dempla sabe da gel i ded. ");
INSERT INTO tcs_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Apta nau wen Zizas bin go insaid, em bin teke an blo da gel ane em bin singaut, ‘Gedap mai gel!’ ");
INSERT INTO tcs_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Stretwei em bin gedap, laipwan. Den Zizas bin spik po papa ane mama blo da gel, ‘Gibe em kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Dempla bin prapa atzamp. Bat Zizas bin spik po demtu mama ane papa blo da gel, ‘Yupla no spik nobodi wanem bin apen ya tidei.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Zizas i bin singaut dem tuelb misnareman blo em po kam longsaid. Em bin gibe dempla paua ane rait po kare lo so dempla ken yuze da paua po tekemaut ebri debolspirit ane po ile ol sikpipol. ");
INSERT INTO tcs_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Zizas bin sane dempla po ile ol sikpipol ane po spik po dempla baut da ples wea God i go ruloba ebriting ane ebriwan. Em bin sane dempla po ol dem pipol po spik da gudniuz ane po ile ol sikpipol. So ip dem pipol go sluraun prom dem nugudwei God go pogibe dempla. ");
INSERT INTO tcs_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Zizas bin spik dempla, ‘Yupla no teke nating wen yupla go. No teke wokingstik, no teke baig, no kaikai, no mani ane no teke klos po seinz. ");
INSERT INTO tcs_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wen yupla go insaid po aus, yupla mas stap de, stap de wan ples antil yupla redi po go prom dat taun. ");
INSERT INTO tcs_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ip ol dem pipol wea da taun i no welkam yupla, yupla libe dempla ane go. Bat pas, yupla mas seike dast prom put blo yupla po wone dempla ane spik diskain po dempla, “God go panse yupla bikoz yupla no bin wande lisen da mesiz blo em.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","So dempla bin lego go, kipgo tru olkain dipren dipren biliz. Ol bin prise da Gudniuz ane ile ol sikpipol ebriwea wea dem biliz. ");
INSERT INTO tcs_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Erod Antipas, dat edman wea Galali, em bin lisen ebriting wanem bin apen de. Em bin pazol bikoz sam pipol bin spik diskain, Zon Baptaizman em bin kamlaipgen. ");
INSERT INTO tcs_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Sam pipol bin spik, ‘Ilaiza bin kamlaipgen.’ Nadalot bin spik, ‘Nono! Em wan prom dem nada longtaim spesilmesizman blo God. Em bin kambaik laipwan.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Erod bin spik, ‘Ei! Ai bin gibe oda po kate ed blo Zon. Uda dis man ya nau, uda meke ol demting?’ Erod bin prapa wande luk Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wen dem misnareman blo Zizas i bin kambaigen, ol bin spik po Zizas ebriting wanem dempla i bin mekem. Apta nau, Zizas i bin wande teke dempla go wansaid wea em, mata dempla. So em bin teke dempla go wea em po wan taun. Neim blo da taun Betsaida. ");
INSERT INTO tcs_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bat ol dem bigmob pipol ol bin paindaut wea dempla bin go. So ol i bin pole dempla. Zizas bin spik po dat bigmob pipol, ‘Welkam.’ Den em bin yan po dempla diskain, ‘Da taim i kam klostu wen God i go ruloba ebriwan ane ebriting.’ Den apta, em bin ile ebriwan de uda i bin sik. ");
INSERT INTO tcs_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Leit aptanun, bipo da san i bin stat po godaun, dem tuelb klostuman bin kam po Zizas. Dempla bin spik po Zizas, ‘Yu sanewei dem bigmob pipol, go po dem klostu biliz so dempla ken paine kaikai ane ples po stap, bikoz nobodi stap ya wea dis ples.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Zizas bin ansa dempla baigen, ‘Yupla mas gibe dempla kaikai.’ Dem klostuman blo Zizas bin spik baik po em, ‘Mipla nogad no kaikai. Mipla mata gad paib smol bred ane tu smol rospis. Wiswei? Yu wande mipla po go baie kaikai po dempla a?’ ");
INSERT INTO tcs_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","I bin gad baut 5,000 man de, iben mo plenti ip i bin kaunte ol oman ane pikinini. Zizas bin spik ol klostuman blo em, ‘Meke dempla sidaun wea mob, baut pipti pipol wea ebri mob.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","So dempla bin pole dat oda blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Apta nau, Zizas bin teke dem paib smol bred ane demtu smol rospis. Em bin luk go antap po eben ane em bin eso God po da kaikai. Em bin broke dat bred, ol smolsmol pis. Den em bin gibem po dem klostuman blo em po seremaut po ebriwan. ");
INSERT INTO tcs_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ebribodi i bin kaikai ane ol bin belipul. Apta nau, dempla bin pikemap ol dem leptoba kaikai, dempla bin pilemap tuelb basket. ");
INSERT INTO tcs_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Orait. Wantaim wen Zizas bin prea wea wan kuaiatples, dem klostuman bin de longsaid wea em. Zizas bin aske dempla, ‘Wanem ol pipol i spikbaut mi? Uda Mi?’ ");
INSERT INTO tcs_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Dempla bin ansa em baigen, ‘Sam spik, yu Zon Baptaizman. Ol dem nadawan spik, yu Ilaiza. Sam dem nadalot bin spik, yu wan prom dem longtaim spesilmesizman blo God, uda bin kamlaipgen.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Zizas bin aske dempla, ‘Wanem yupla tingk uda mi?’ Pita bin ansa em, ‘Yu da Promiswan uda God i bin sanem kam.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Den Zizas bin gibe strong oda po dem klostuman, ‘Ei, yupla lisen po mi! Yupla no spik nobodi uda mi. ");
INSERT INTO tcs_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ol dem elda blo dem Zuwispipol, dem edprist ane ol dem Zuwislotisa go meke mi, da Truwan blo Man po sapa obamak nugudting. Dempla go puse mi wansaid ane kile mi, bat wea namba tri dei ai gobi laipgen.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Den Zizas bin spik po ebriwan de, ‘Ip enibodi wande pole mi, dempla mas redi po ded ane teke da kros blo dempla ebridei ane sapa wase mi. Ebridei yupla mas redi po gibap laip blo yupla po pole mi. ");
INSERT INTO tcs_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Enibodi uda wande lugaut laip blo dempla, dempla go luze longlaip blo dempla poeba. Bat ip yupla go sapa ane ded po mi, God go gibe yupla longlaip poeba. ");
INSERT INTO tcs_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ip yupla gad ebriting, demting i nogo elpe yupla, bikoz wen yupla go ded yupla go luze ebriting. Yupla nogo gede longlaip poeba. ");
INSERT INTO tcs_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ip pipol i sem prom mi ane mesiz blo mi, den ai da Truwan blo Man gobi sem prom dempla tu. Ai gobi sem prom dempla wen ai go kam king wea da truglori, dat prapa braitlait ane paua blo mi ane blo da papa blo mi ane ol dem oli einzel tu. ");
INSERT INTO tcs_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ai spik trutok po yupla. Sam prom yupla uda stanap ya nau nogo ded yet, bipo yupla go luk dat taim wen God i go kam ruloba ebriwan ane ebriting.’ Zizas i bin tok prapa stret po dempla. ");
INSERT INTO tcs_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Orait nau. Eit dei apta, Zizas bin teke Pita, Zon, ane Zemes go antap maunten po prea. ");
INSERT INTO tcs_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Seimtaim wen Zizas bin prea, pes blo em bin seinz ane klos blo em bin kam prapa nadakain sainiwait, brait wase san. ");
INSERT INTO tcs_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Stretwei, tu man i bin stanap de tok wea Zizas. Neim blo demtu Mozes ane Ilaiza. ");
INSERT INTO tcs_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Demtu bin gad prapa nadakain braitlait i sain raun wea demtu. Demtu bin tok wea Zizas baut da plan blo God wiskain Zizas go ded de wea Zarusalem, bipo em go antap po eben. ");
INSERT INTO tcs_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nau Pita ane dem nada tu klostuman blo Zizas bin dedslip. Wen demplatri bin gedap prom slip, dempla bin luk prapa nadakain braitlait i sain raun wea Zizas. Dempla bin luk tu man uda bin stanap klostu wea em. ");
INSERT INTO tcs_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Apta nau wen demtu man, Mozes ane Ilaiza bin redi po go, Pita i bin spik po Zizas. Pita no bin tingbaut wanem em spik, em mata tok. ‘Tisa diswan i gud. Mipla tri ya wea yu. Mipla go meke tri smolseid, wan po yu, wan po Mozes ane wan po Ilaiza.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Orait. Wail em i bin stil tok, klaud bin kam ane meke sado oba dempla. Den da klaud i bin kaba dempla ane dem tri klostuman bin prapa prait. ");
INSERT INTO tcs_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Dempla bin lisen bois i kamaut prom da klaud. Da bois i spik, ‘Diswan mai Boi ane ai bin suze em. Yupla mas lisen po em.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Apta, wen da bois bin pinis tok, dem klostuman bin luk mata Zizas bin stanap de. I nogad dem nada tu man de. Po longtaim apta, Pita, Zon, ane Zemes no bin spik po nobodi wanem demplatri bin luk de dat dei. ");
INSERT INTO tcs_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Orait. Neksdei, wen dempla bin kamdaun prom dat maunten, prapa bigmob pipol i bin mite Zizas de daun. ");
INSERT INTO tcs_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wan man de wea dat mob i bin singaut laudwan, ‘Tisa, plizgar! Ai prapa wande yu po kam luk boi blo mi. Em mata da wan pikinini blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Da debolspirit i tekoba bodi blo em, meke em skrim nadakain ane meke em gede pit. Ol spet kamaut prom maut blo em. Da debolspirit no wande libe em, ane apta wen da debolspirit i pinis wea em, em libe mai boi prapa nadakain slaikwan. ");
INSERT INTO tcs_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ai bin prapa bege dem klostuman blo yu po tekemaut dis debolspirit prom mai boi, bat dempla kan.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Zizas bin spik diskain, ‘Yupla nadakain! Yupla no bilib. Yupla meke olkain nugudting. Aulong ai bin ya stap wea yupla ane yupla stil no sabe wei blo mi.’ Den Zizas bin spik po da man, ‘Yu teke yu boi kam.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wen da man bin teke da boi kam po Zizas, da debolspirit bin sake da boi wea graun ane em bin stat po gede pit. Zizas bin oda da debolspirit po kamaut prom dat boi. Stretwei da boi bin ile ane Zizas i bin gibe em baigen po papa blo em. ");
INSERT INTO tcs_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ebriwan bin prapa atzamp wen ol bin luk dat prapa big strongpaua blo God. Dempla i bin tokbaut ol dem gudting wanem Zizas bin mekem. Ol bin prapa nadakain glad. Den Zizas bin spik po dem klostuman blo em, ");
INSERT INTO tcs_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","‘Lisen gud! Rimemba wanem ai spik po yupla ya. Sambodi go sele mi, da Truwan blo Man po dem enami blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bat dem klostuman no bin kesem wanem Zizas i min. God bin aide da mining prom dempla ane dempla bin prait po aske Zizas po eksplein wanem da mining blo dat tok blo em. ");
INSERT INTO tcs_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Graul bin stat gen wea dem klostuman blo Zizas baut uda gobi nambawan man wea dempla. ");
INSERT INTO tcs_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Zizas i bin sabe wanem dempla bin tingbaut. So Zizas bin teke wan smolpikinini ane mekem stanap klostu wea em. ");
INSERT INTO tcs_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Den em bin spik po dempla, ‘Uda ya i labe dem smolpikinini wea neim blo mi, dempla i labe mi tu. Uda labe mi, dempla labe papa blo mi uda bin sane mi kam. Dem nambalas man ya wea yumpla, dempla gobi nambawan.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Zon bin spik po Zizas, ‘Tisa, mipla bin luk wan man, em bin yuze neim ane paua blo yu po pose dem debolspirit po kamaut prom sam pipol. Mipla bin spik, “Yu no lau po meke disting bikoz yu no blo mipla.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Bat Zizas bin spik, ‘No stape em bikoz em no gense yumpla. Em wok tugeda wea yumpla.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Nau wen da taim i bin kam klostu po Zizas po gobaik po eben, em bin prapa wande go po Zarusalem. ");
INSERT INTO tcs_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Em bin sane sam mesinza go pas po wan biliz wea Samaria po meke ebriting redi de po em po stap. ");
INSERT INTO tcs_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bat bikoz Zizas bin gad main po go Zarusalem po da pisting taim, dem pipol wea dat biliz no bin welkam em. Dempla no bin bilib Zarusalem i da prapa ples po meke da pisting. ");
INSERT INTO tcs_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Zemes ane Zon bin lisen distok. Demtu bin aske Zizas, ‘BosLod, yu wande mitu po singaut da paia po kamdaun prom eben po bane dempla ebriwan.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bat Zizas bin sluraun ane spik, ‘Nono! Yutu nogad no rait po spik diskain.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","So dempla bin mata go po nada biliz. ");
INSERT INTO tcs_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wail dempla bin wagbaut go wea da rod, wan man i bin spik po Zizas, ‘Ai mata go pole yu ebriwea wea yu go go.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Zizas bin spik po em, ‘Sanbis krab i gad oll wea sanbis, ol pizin i gad nest, bat ai da Truwan blo Man, ai nogad no ples po stap.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Zizas bin spik po nada man diskain, ‘Kam, pole mi.’ Da man i bin spik em, ‘Wa, ai go kam apta bambai wen papa blo mi i go ded.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Bat Zizas ansa em, ‘Ol dem pipol uda no pole God, dempla wase ded pipol, lete dempla bere dem ded pipol blo dempla. Bat yu mas go ebriwea ane spik ebriwan da taim i ya nau wea God i go ruloba ebriwan ane ebriting.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Nadawan bin spik, ‘Wa, ai go pole yu BosLod, bat yu lete mi go pas po yawo pamle blo mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Zizas bin spik po em, ‘Demwan uda wande meke wok blo God, wel God kan yuze em po meke wok blo em, ip em gad main po meke ol nadating.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Apta nau da BosLod bin suze nada 72 klostuman ane em bin sane dempla tu tu go po ebri taun ane ples wea Zizas bin wande go. ");
INSERT INTO tcs_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Em bin spik po dempla, ‘Wea yupla go go, ol dem pipol i redi po lisen da niuwei blo God. Dem pipol yupla go luk i wase dem raip prut redi po pikemap prom gadan. Bat yupla mata lelbet pipol ya go po wine dempla. So yupla mas prea po God. Em da bos blo dat gadan so em go elpe yupla po gede mo wokman po wine mo pipol. ");
INSERT INTO tcs_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yupla go nau, bat yupla mas sabe ai sane yupla melen wea olkain trabol wase smolsip melen wea ol prapa wail dog. ");
INSERT INTO tcs_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yupla no kare mani, no teke baig, no kare ekstra sandol, no teke nating wea yupla ane yupla no stap po yan wea nobodi wea rod. Yupla mata kipgo. ");
INSERT INTO tcs_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","‘Wen yupla go insaid aus, yupla alo po dat pamle diskain, “God gibe pis po dis aus.” ");
INSERT INTO tcs_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ip da bos blo dat aus no soe gudwei po yupla, den dat pisblesing go kambaigen po yupla. Da man uda teke da pisblesing go, wea God i bin gibe em, em go gede taim blo pis wea dat aus. ");
INSERT INTO tcs_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Yupla mas stap wea dat aus. Kaikai ane dringk wanem dempla gibe yupla, diswan i pei blo yupla bikoz yupla i bin meke prapa adwok. Yupla stap wan ples, no mub go po ol nada aus. ");
INSERT INTO tcs_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","‘Wen yupla go insaid taun ane ol pipol welkam yupla, yupla kaikai ebriting wanem dempla i gibe yupla. ");
INSERT INTO tcs_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ile ol dem sikpipol de. Spik dempla da taim i kam klostu nau wen God i go ruloba ebriwan ane ebriting. ");
INSERT INTO tcs_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ip da biliz wea yupla go no welkam yupla, den mata libe da biliz, bat bipo yupla go, yupla singaut wea da rod diskain, ");
INSERT INTO tcs_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mipla seike dast prom biliz blo yupla prom leg blo mipla po wone yupla, diswan i bin da taim wen God bin wande ruloba yupla bat yupla no bin wandem.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Zizas bin eksplein po ol klostuman blo em, ‘Ai spik yupla, zazmentdei blo God gobi moizi po dat taun blo Sodom den po dat biliz.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","‘Yagar. Olkain nugudting go apen po yupla, ol pipol wea dis tu taun blo yupla, Korazin ane Betsaida. Yupla bin luk plenti mirikal bat yupla no bin tan prom dem nugudwei blo yupla. Ip dem pipol wea demtu taun, Taira ane Sidon bin luk ol dem mirikal wanem yupla bin luk, wel dem pipol de olredi bin tan prom dem nugudwei blo dempla. Ol bin sake asis wea ed blo dempla ane sidaun were klos ol mekem prom esianbaig po soe God dempla nadakain sore po dem rongting wanem dempla bin mekem. ");
INSERT INTO tcs_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Zazmentdei gobi moizi po demtu taun, Taira ane Sidon, den po yupla ol pipol blo Korazin ane Betsaida. God go prapa panse yupla mo bikoz yupla no bin tan prom nugudwei blo yupla. ");
INSERT INTO tcs_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ane yupla blo Kapaniam, yupla tingk yupla go gede ples antap wea eben. No wei! Yupla go go el!’ ");
INSERT INTO tcs_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Zizas i spik gen po dem klostuman blo em, ‘Ip uda lisen po yupla, wel dempla lisen po mi tu. Ip uda no tekenotis po yupla, wel, dempla no tekenotis po mi tu. So dempla uda no tekenotis wea mi, wel, dempla no tekenotis wea God uda bin sane mi kam.’ Den dem 72 klostuman bin go. ");
INSERT INTO tcs_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wen dem 72 klostuman bin kambaigen po Zizas, dempla bin prapa nadakain api. Dempla bin spik Zizas diskain, ‘BosLod. Wen mipla bin spik oda wea neim blo yu, iben dem debolspirit bin lisen ane obei.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Zizas bin ansa dempla, ‘Ai bin luk wen Satana i bin poldaun wase laitning prom eben. ");
INSERT INTO tcs_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yupla lisen nau, tekenotis. Ai bin gibe yupla rait po kare lo, paua po smase ol dem dedli sneik ane ol dem skopion wea put blo yupla. Ai bin gibe yupla paua po kare lo oba dem debolspirit po bite dempla. Nating go erte yupla. ");
INSERT INTO tcs_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Orait. Yupla api dem debolspirit i lisen po yupla. Bat ai spik yupla, i mobeta yupla bi moglad bikoz ol neim blo yupla i bin raitem daun wea da buk blo eben.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Dat seimtaim nau, da OliSpirit i bin meke Zizas prapa nadakain glad ane Zizas bin spik, ‘PapaGod, Bos blo eben ane ert, ai eso yu ane preize yu bikoz yu bin aide ol demting blo yu prom ol demwan uda tingk dempla smat ane waiz. Bat yu bin soe demting wanem yu bin aidem po ol dem pipol uda wase smolpikinini. Wa. PapaGod, ai preize yu nau bikoz diswan i bin da wei wea yu bin wande mekem. ");
INSERT INTO tcs_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","‘PapaGod blo mi, i bin gibe mi paua oba ebriting. Nobodi sabe dat Boi, mata Papa blo em i sabe em, ane nobodi sabe dat Papa, mata Boi blo em i sabe em. Mata dempla uda da Boi go suzem, go sabe da Papa.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wen Zizas bin stanap wansaid wea dem klostuman blo em, em bin spik kuaiatwei po dempla, ‘Yupla bi prapa api, bikoz yupla prapa blest po luk ol demting ya nau. ");
INSERT INTO tcs_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ai spik po yupla nau, dem bipotaim plenti spesilmesizman blo God ane ol longtaim king bin wande sabe wanem yupla luk ya nau. Bat dempla no bin luk. Dempla bin prapa wande lisen, bat dempla no bin lisen.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Apta nau, wan smatman blo dem Zuwislo bin wande teste Zizas. So em bin aske Zizas diskain, ‘Tisa, wanem ai go mekem po gede longlaip poeba?’ ");
INSERT INTO tcs_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Zizas i bin ansa em baik ‘Yupla bin rid wanem dem Mozeslo i spik a? Wanem yupla bin ridem de?’ ");
INSERT INTO tcs_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Em ansa Zizas, ‘Labe da AntapGod wea olgeda at blo yupla, ane olgeda laip blo yupla, ane olgeda strong blo yupla, ane olgeda sens blo yupla. Labe kantriman blo yupla wase yupla labe yuplaselp.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Zizas bin spik po em, ‘Wa, yu spik tru. Ip yu meke disting, laip blo yu go stap poeba.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Bat da man bin smattok baik po Zizas. Em bin aske Zizas, ‘Uda kantriman blo mi?’ ");
INSERT INTO tcs_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","So Zizas bin yan wan stori wea i gad mining baut dem Samariaman. Ol dem Zuwisman bin prapa eite dem Samariapipol. ‘Wan Zuwisman bin kam prom Zarusalem godaun po Zeriko. Wen em bin wagbaut go, sam stilaman i bin kese em ane paite em, tekemaut ol klos blo em ane libe em de, apded. ");
INSERT INTO tcs_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","‘Apta, wan Zuwisprist i bin kam wea da seim rod. Wen em luk da man em bin wagbaut goraun em ane em bin kipgo. ");
INSERT INTO tcs_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Den wan man, em serba wea da Tempol, em bin kam po dat seimples tu. Em bin luk da man ane em bin wagbaut goraun em ane em bin kipgo tu. ");
INSERT INTO tcs_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","‘Bat wan streinza prom Samaria i bin wagbaut kam, kam klostu po da man. Wen em bin luk em, em bin pil prapa sore po em. ");
INSERT INTO tcs_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Em bin kapsaid wain ane oil wea ol soa blo em. Den em bin bandiz em. Em bin pute da man antap wea dongki blo em ane teke em go po lugaut em wea gestaus. ");
INSERT INTO tcs_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Da neksdei, dat Samariaman bin tekemaut tu silba koin, ane gibe dem koin po da bos blo da gestaus. Em bin spik po da bos, “Yu mas lugaut em gud. Ip yu spene mo mani wea em, ai go pei yu wen ai go kambaik.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Den Zizas bin aske da smatman blo dem Zuwislo, ‘Orait. Prom demplatri man, uda yu tingk i kantriman blo dis man uda bin leidaun klosap ded?’ ");
INSERT INTO tcs_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Da smatman blo Mozeslo bin ansa em diskain, ‘Dat streinza uda bin sore ane bin soe sorewei po em. Em da wan.’ So Zizas bin spik em diskain, ‘Yu go nau ane yu meke da seimkain pasin.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Den Zizas ane ol klostuman blo em bin wagbaut go. Dempla bin go po wan biliz. Wan oman, neim blo em Mata, em bin welkam Zizas wea aus blo em. ");
INSERT INTO tcs_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata i bin gad wan sisi, neim blo em Meri. Meri bin sidaun klostu wea da BosLod ane em bin lisen ebriting wanem Zizas bin lane dempla. ");
INSERT INTO tcs_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bat Mata em bin prapa bizi meke ol kaikai. So Mata bin go aske Zizas, ‘BosLod yu tingk diswan i rait a? Sisi blo mi bin libe ebriting po mi po mekem. Yu spik em po kam elpe mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bat da BosLod bin ansa em, ‘Mata, Mata. Yu tumas woribaut ol smol samting ane demting i meke yu taiat. ");
INSERT INTO tcs_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Bat diswan ya, i da wan impotant ting po tingbaut ane Meri bin suzem. Meri i bin stap ane em lisen po mi. Nobodi ken tekemaut dat gudting prom em.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wandei Zizas bin prea wea wan ples. Wen em bin pinis prea wan klostuman blo em bin spik po em, ‘BosLod, yu lane mipla po prea wase Zon Baptaizman bin lane ol dem klostuman blo em.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","So Zizas bin spik po dempla baigen, ‘Orait. Wen yupla prea yupla mas spik diskain: PapaGod, mipla prea ol pipol go ona ane kare neim blo yu antap. Mipla prea da taim go kam kuikwan wen yu go ruloba ebribodi. ");
INSERT INTO tcs_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gibe mipla nap kaikai ebridei wanem mipla wandem po dat dei. ");
INSERT INTO tcs_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pogibe mipla po ol dem nugudting mipla bin mekem, seimkain wase mipla pogibe ol dem nada pipol uda bin meke nugudting gense mipla. Pliz elpe mipla so mipla nogo gibap ane meke ol nugudting.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Apta, Zizas bin spik po dem klostuman blo em, ‘Ip wan man prom yupla gad pren ane yupla go po luk em melennait, yupla spik em, “Mai pren, plizgar, yu ken gibe mi tri loupbred. Ai go pei yu baik. ");
INSERT INTO tcs_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Nada pren blo mi bin disnau kam po stap wea mi. Ai nogad no kaikai po gibe em.” ");
INSERT INTO tcs_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wel wanem yupla tingk? Yupla tingk em go ansa em diskain prom insaid aus? “Ei. Yu noboda mi nau. Ai kan gedap po gibe yu samting. Doa blo mi i lok ane ol pikinini blo mi i slip.” ");
INSERT INTO tcs_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nono! Em nogo spik diskain, iben ip em no wande gedap po gibe yu samting, em go mata gedap ane gibe yu ebriting wanem yu wandem bikoz em pren blo yu ane yu no sem po aske em po kaikai. ");
INSERT INTO tcs_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","‘So ai spik yupla stret nau. Wen yupla aske God po wanem yupla nidem em go gibe yupla. Ip yupla lukraun, yupla go paine wanem yupla wandem. Ip yupla singaut ausaid wea doa blo God, em go lisen ane opene da doa po yupla. ");
INSERT INTO tcs_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ebribodi uda go aske God po samting, God i go gibe dempla. Uda go lukraun, go paine em. Uda go singaut ausaid wea da doa, dat doa gobi open so dempla ken go insaid. ");
INSERT INTO tcs_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","‘Ip smolpikinini blo yupla aske yupla po pis, yupla nogo gibe em sneik. ");
INSERT INTO tcs_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ip em aske yupla po eg, yupla nogo gibe em skopion. ");
INSERT INTO tcs_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nomata ip yupla nugud, yupla sabe wiskain po gibe ol gudting po pikinini blo yupla. Bat PapaGod blo yupla wea eben, em ebritaim redi po gibe yupla plenti gudting. So God i go gibe da OliSpirit po enibodi uda aske em.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Orait nau, wantaim Zizas bin oda wan debolspirit po kamaut prom wan man uda kan tok bikoz da debolspirit bin stap em. Wen da debolspirit bin kamaut, da man bin stretwei stat tok. Ol dem pipol bin nadakain atzamp. ");
INSERT INTO tcs_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bat sam dem pipol bin tok diskain, ‘Belzibel, lida blo ol dem debolspirit, bin gibe paua po Zizas po draibe dem debolspirit po kamaut.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ol nada pipol bin wande teste em diskain. Dempla bin spik po em po meke mirikalsain prom eben po prubem po dempla God bin gibe em da rait po kare lo. ");
INSERT INTO tcs_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Zizas bin sabe wanem dempla bin tingbaut. So em bin tok po dempla diskain, ‘Eni kantri uda go splitap, meke ol dipren grup ane paite wananada, bambai dat kantri go pinis. Da seim wea pamle tu. Ip pamle gense wananada dat pamle i go splitap. ");
INSERT INTO tcs_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","So nau, ip Satana go gense ol debolspirit blo em, paua blo em go pinis. Yupla spik, Belzibel bin gibe mi paua po draibe ol debolspirit po kamaut. ");
INSERT INTO tcs_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bat Belzibel i no bin gibe mi paua po draibe dem debolspirit po kamaut, ane ol klostuman blo yupla no yuze paua blo Belzibel po draibe dem debolspirit po kamaut. Nono! Dempla yuze paua blo God. Okei! Ol klostuman blo yupla go zaze yupla ip i tru wanem yupla spik. ");
INSERT INTO tcs_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bat i God uda gibe mi da paua po draibe dem debolspirit po kamaut, so yupla ken sabe God em i ruloba yupla ya nau. ");
INSERT INTO tcs_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Satana em wase strongman uda bin meke plenti bunaro po pait, po gade aus blo em. Em no wori bikoz ebriting i prapa redi. ");
INSERT INTO tcs_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bat ip nada mo strongman wase mi go kam, em go prapa smase em wantaim. Dat mo strongman nau go teke ol dem samting blo pait prom em, ol demting wanem da pas strongman i bin prapa trasem. Den da nada mo strongman go teke ebriting blo dat pas man nau ane seremautem. So nau da pas man nomo gad paua. ");
INSERT INTO tcs_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‘Enibodi uda no stanap wea said blo mi, em gense mi. Enibodi uda no elpe mi, ane no teke ol pipol blo mi po kam po mi, em gense mi tu. Em meke ol dem pipol blo mi skata ebriwea. Em no wok tugeda wea mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Zizas bin tokbaut ol debolspirit po wone dempla baut dem debolspirit. ‘Wen debolspirit go kamaut prom eni man wea em bin stap, em go tekop go wea dezetples. Em go stat lukraun nada ples po stap. Bat wen em nogo paine nada ples po stap, em go spik po emselp, “Ei! Ai gobaigen po dat ples wea ai bin stap pas.” ");
INSERT INTO tcs_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","So wen em bin gobaik, em go paine da ples blo em prapa klin ane taidi. ");
INSERT INTO tcs_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Den em bin go po lukraun po ol nada debolspirit nau. Em go teke seben mo prapa nugud debolspirit wea em, po kam stap de insaid wea dat man. So dat seim man go kam monugud den em bin bipo.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wail Zizas bin stil tok, wan oman wea da mob bin singaut prapa laudwan, ‘Mama blo yu mas prapa glad bikoz em bin bone yu ane em bin gibe yu susu.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Zizas bin ansa em, ‘Wa. Diswan i tru de yu spik. Bat ol dem pipol uda bin lisen da mesiz blo God ane pole em, dempla gobi obamak glad.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","So nau plenti mo pipol bin kam klostu po Zizas. Em bin stat spik dem pipol diskain, ‘Yupla ebribodi wea distaim ya nau, yupla gad nadakain nugudwei. Yupla tumas aske mi po mirikalsain prom eben. Bat ai nogo soe yupla mirikalsain, mata da sain wanem Zona bin spik dem pipol blo da siti blo Ninaba po sluraun prom ol nugudwei blo dempla. ");
INSERT INTO tcs_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wa. Diswan tru, em bin da sain po ol dem pipol blo Ninaba. Nau da seimwei, mi da Truwan blo Man gobi dat sain po ebribodi blo distaim ya nau. ");
INSERT INTO tcs_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","‘Dat dei wen God go zaze ebriwan, da kuin blo Siba i go kamlaipgen tugeda wea ol dem pipol blo distaim ya nau. Dat kuin go singaut ol dem nugudting wea yupla bin mekem lo distaim. Nomata em bin stap prapa longwei, dat kuin bin stil kam po lisen dat waiz tok blo King Solomon. Bat ai spik yupla, i gad sambodi ya nau, uda i prapa mobig, mo impotant den King Solomon. ");
INSERT INTO tcs_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Wen dat zazmentdei blo God go kam, ol dem pipol blo Ninaba go kamlaipgen tugeda wea ol dem pipol wea distaim. Dempla go soe yupla ol dem nugudting wanem yupla bin mekem. Wen Zona bin pinis spik da mesiz blo God, dempla bin prapa sore ane ol bin wantaim sluraun prom ol nugudwei blo dempla. Ai spik yupla ya nau, i gad sambodi ya nau, uda i prapa mobig ane mo impotant den Zona. Bat yupla stil no wande seinze ol nugudwei blo yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ane Zizas i kip spik, ‘Yupla sabe nobodi laite lamp ane aide em o putem andanit wea basket. No! Yupla angem antap wea ples blo lamp, solong uda kam insaid, dempla ken luk dat lait. ");
INSERT INTO tcs_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","‘Ol ai blo yupla, i prapa wase lamp i meke lait wea laip blo yupla. Ip yupla mata luk raitwei po meke ebriting, laip blo yupla go kam wase lait i sain. Bat ip yupla luk rongwei po meke eniting, laip blo yupla i go kam wase yupla stap wea prapa nadakain dakples wea i nogad no lait. ");
INSERT INTO tcs_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Yupla lugaut. Tekenotis nau. Maitbi demwei blo yupla i nogad no lait i sain. Yupla mait stil stap wea dakples. ");
INSERT INTO tcs_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ip laip blo yupla ebriwan i stap wea lait, nogad sado, den yupla gobi brait wase lait blo lamp i sain wea yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Apta Zizas bin pinis tok, wan Parasi bin aske Zizas po go kaikai wea aus blo em. So Zizas bin go po aus blo dat man po kaikai. ");
INSERT INTO tcs_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Dat Parasi i bin atzamp wen em bin luk Zizas no bin pole dem kastam blo dem Zuwislo po meke spesil seramoni po wase an blo em bipo em bin sidaun po kaikai. Da Parasi i bin spik diskain, ‘Man mas wase an pas bipo em kaikai.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","So BosLod Zizas i bin spik stret po em, ‘Yupla Parasi, yupla prapa wase dem kap ane dis solong i bin wasem prapa klin wea ausaid, bat insaid yupla prapa nadakain nugud ane gridi tu. ");
INSERT INTO tcs_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yupla prapa nadakain ol stupit pipol tu. Wiswei? God uda bin meke da ausaid, em no bin meke da insaid tu, a? ");
INSERT INTO tcs_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mobeta yupla gibe ebriting po dem poaman wanem yupla prapa wande kipem po yuplaselp. Den yupla gobi prapa klin. ");
INSERT INTO tcs_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‘Yupla ol Parasi, yupla ebriwan go gad nadakain big trabol. Yupla gibe ol opring blo God po em, iben ol dem prapa smol erbopring. Bat, yupla bin prapa piged po soe lab po God ane yupla no bin trite ol pipol raitwei tu. Mobeta yupla labe God pas, trite ol pipol blo yupla raitwei, den apta yupla gibe opring po God. Diswan i da raitwei. ");
INSERT INTO tcs_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘Yupla ol Parasi, yupla lisen po mi nau. Yupla go gad nadakain big trabol. Wea da zuwispreaus, yupla prapa laik po sidaun wea da nambawan sit. Yupla prapa kamap wen ol man grite yupla wea rispekt wea da maketples, so ol pipol ken mata luk yupla. ");
INSERT INTO tcs_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘Yupla ol Parasi, yupla go gad nadakain big trabol. Yupla wase greib nogad edston. Pipol wagbaut antap wea dem greib bikoz dempla no sabe i gad ol ratan bodi de andanit.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wan dem smatman blo dem Zuwislo bin spik po em, ‘Tisa, yu prapa spoile mipla wen yu spik diskain baut mipla.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Den Zizas i bin tok mostrong, ‘Ane yupla, yupla go gede mobig trabol tu. Yupla uda smatman blo dem Zuwislo, yupla puse ol dem pipol po kare tumas dipren lo, demwan yupla bin mekem. Dem lo yupla bin mekem, i prapa nadakain ad ane dem pipol kan kare dem lo. Yupla no iben boda po elpe dem pipol po kare dem lo wanem yupla i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Yupla go gede mobig trabol. Yupla bin bilde prapa plas edston antap dem greib blo dem bipotaim spesilmesizman blo God. Bat dem bipotaim papa blo yupla, dempla bin kile ol dem spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Dem edston yupla bildem, i wase yupla prapa gri po wanem dem bipotaim papa blo yupla i bin mekem. Dempla bin kile ol dem man blo God. ");
INSERT INTO tcs_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","God bin yuze sabe blo em wen em bin tokbaut yupla diskain, “Ai go sane sam spesilmesizman ane sam misnareman. Ai sabe dem pipol go kile sam dem man blo mi ane dem pipol go meke nadakain nugudpasin po ol dem nada pipol blo mi.” ");
INSERT INTO tcs_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","‘God go panse yupla prom demwei blo yupla ya nau. God i bleime yupla po ebridem pipol blo God wea ol papa blo yupla bin kile dempla, prom wen God i bin pas meke ert. ");
INSERT INTO tcs_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Yupla tingk gobaik wen dempla bin kile Eibol, go po dat taim wen dem ate blo yupla bin kile Zakaraia de melen wea da olta ane da seramoni eria blo da Tempol. Wa, wanem ai spik yupla ya nau i tru. Dem pipol blo distaim ya nau, ol go gede da bleim po kile ol dem bipotaim spesilmesizman blo God. ");
INSERT INTO tcs_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘Lugaut nau! Ol trabol i go kam po yupla ol smatman blo dem Zuwislo. Yupla bin aide da ki prom ol dem pipol uda bin wande paindaut ol dem waizwei blo God. Yupla no bin yuze da waizwei blo God ane yupla bin stape ol dem pipol uda wande paindaut tu.’ ");
INSERT INTO tcs_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Prom dat taim nau, apta Zizas bin gowei prom aus blo dat Parasi, ol dem Zuwislotisa ane dem Parasi dempla bin stat po spik olkain nugudting baut Zizas. Ane dempla bin graul ane tok ol prapa nugudtok po em. Dempla bin stat nau po aske em olkain ad kuestin tu, ");
INSERT INTO tcs_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","bikoz dempla bin wande trike em po tok rongwei solong dempla ken paine polt wea Zizas diskain, dat em bin daune da antap neim blo God ane dat em no pole dem Mozeslo. ");
INSERT INTO tcs_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tauzen ane tauzen pipol i bin de wea Zizas. Dempla i bin trai puse wei blo dempla po luk em. Bat wen Zizas bin stat po tok, em bin spik po ol klostuman blo em. Em bin spik diskain, ‘Lugaut nau prom dem Parasi. Dempla lane yupla prapa nugudwei. Dempla ratan wase yis wea em i mata kip gro. Bambai i go spoile ebriting wen em gro. ");
INSERT INTO tcs_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Yupla kan aide nating. Ol dem sikret go kamaut ane ebribodi go paindaut bikoz God go soe ebriting. ");
INSERT INTO tcs_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ol demting wea yupla i bin mekem de biain wea dak, i go kamaut prant wea lait. Wanem demting wea yupla bin smolsmoltok insaid wea aus blo yupla wea nobodi no lisen wanem yupla i bin spik? Bambai da tok i go kamaut kliawan de wea pablik miting ples wea ebribodi i go lisen. Da wan yupla mas prait prom i God.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‘Ol pren blo mi, ai spik yupla prapa stret. Yupla no prait prom dempla uda ken kile da bodi blo yupla. Dempla kan meke nating mo po yupla. ");
INSERT INTO tcs_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Bat ai go soe yupla uda da wan yupla mas prait prom. Yupla mas rispekt God. God da wan yupla mas prait prom, bikoz em ken teke laip blo yupla ane sake yupla insaid el. Wa, ai spik yupla, yupla mas prait prom em. ");
INSERT INTO tcs_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‘Yupla sabe dem smol pizin. Dempla gad smol prais. Wea da Tempol, yupla ken baie paib smol pizin po tu sent. Bat nomata wiskain smol da pizin, God no piged demwan. ");
INSERT INTO tcs_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yupla no prait, bikoz prant wea God, yupla prapa mobeta den dem pizin. God em prapa sabe aumas eya yupla i gad wea ed blo yupla. ");
INSERT INTO tcs_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Wa, ai spik trutok po yupla. Ip ebriwan spik yupla sabe mi ane labe mi, ai da Truwan blo Man go spik de prant wea ol dem einzel blo God diskain, ai sabe ane ai labe yupla tu. ");
INSERT INTO tcs_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ip eniwan uda spik, dempla no sabe mi, den ai go spik prant wea ol dem einzel blo God, ai no sabe dempla tu.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Zizas bin spik diskain, ‘Ip enibodi tok gense mi da Truwan blo Man, God ken pogibe dempla. Bat enibodi uda spoile da neim ane prapa daune da OliSpirit, God nogo pogibe dempla.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Zizas i bin eksplein po dem klostuman blo em diskain, ‘Bambai dempla i go kese yupla ane teke yupla po kot wea dem zuwispreaus, prant wea ol dem lida ane ol dem gabmanlida. Yupla no wori wiskain yupla go ansa wen dempla go aske yupla olkain kuestin. ");
INSERT INTO tcs_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Dat seimtaim nau da OliSpirit i go spik po yupla wanem yupla go spik po dempla.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Den sambodi wea da bigmob pipol i bin aske Zizas, ‘Tisa, spik bala blo mi po seremaut ol demting blo papa blo mitu bikoz papa blo mitu i ded nau.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Bat Zizas i bin spik po em, ‘Ai kan. Ai no zaz blo kot po elpe yutu po seremaut da lan ane ebriting papa blo yutu bin libem po yutu.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Den em bin spik po ebribodi de, ‘Yupla mas lugaut nau prom olkain gridiwei. Em ken kese yupla ane yupla go wande mo ane mo samting. Nomata yupla gad plenti samting, i nogo meke laip blo yupla gud.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Apta nau, Zizas i bin yan stori wea i gad mining. Em bin spik, ‘Wantaim wan risman bin gad prapa gudples. Em bin groe plenti gudkaikai de. ");
INSERT INTO tcs_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Em bin tingbaut diskain, “Wanem ai go mekem? Ai nogad nap rum po pute ol dis kaikai blo mi.” ");
INSERT INTO tcs_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Den em bin gad aidia. Em tingbaut, “Ai sabe wanem ai go mekem. Ai go broke pas storum blo mi ane bilde mobig wan so ai ken kipe ol dem sid blo kaikai ane ol dem nada kaikai blo mi.” ");
INSERT INTO tcs_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Den em bin spik po emselp, “Ai gad plenti gudsamting. Ai ken kipem po longtaim, po plenti iya. Nau ai go gad izilaip. Den ai ken kaikai, dringk ane prapa enzoi maiselp.” ");
INSERT INTO tcs_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","‘Bat God bin spik po em, “Ei, yu stupit man! Yu meke mi wail. Dis nait yu go ded. Wanem i go apen nau wea ol demting wea yu bin kipem?” ");
INSERT INTO tcs_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","‘Dempla uda kipe ol samting blo dis ert po demplaselp, dempla nogo gad gudlaip wea God.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Zizas bin spik po klostuman blo em, ‘Ai spik yupla. Yupla no wori po wanem yupla go kaikai o wanem yupla go werem. I nugud yupla tumas woribaut laip blo yupla. ");
INSERT INTO tcs_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Laip blo yupla i moden kaikai ane klos blo yupla. ");
INSERT INTO tcs_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yupla luk ol pizin. Ol no sabe plante sid o broke dem sid wen dem sid i raip. Dempla nogad no aus po kipe kaikai. God gibe dempla kaikai. Yupla mo impotant den dem pizin. ");
INSERT INTO tcs_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","I nugud wen yupla wori. Yupla tingk wori go meke laip blo yupla molong? Nono! ");
INSERT INTO tcs_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Yupla no woribaut meke ol big samting o ol smol samting, bikoz God em lugaut ebriting. ");
INSERT INTO tcs_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘Luk wiskain ol dem plaua i gro. Dempla kan digine da soil o meke klos. Bat ai spik yupla, iben Solomon no bin were plasklos wase dem plaua. ");
INSERT INTO tcs_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Dem plant gro eniwea. Tidei, plaua i prapa plas, tumoro i ded ane man bane den plaua wea paia. Ip God ken mekem diskain po dem plaua, aumas mo em go wande gibe yupla ol gudsamting, yupla uda gad lelbet bilib. ");
INSERT INTO tcs_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","‘Yupla no woribaut wanem yupla go kaikai ane dringk. Yupla no woribaut eniting. ");
INSERT INTO tcs_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ebribodi wea ert woribaut demting, bat yupla no wori po demting. PapaGod blo yupla sabe wanem yupla nidem ane em go gibe yupla. ");
INSERT INTO tcs_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ip yupla pole da wei blo God ane soe em dat em God blo ebriting wea laip blo yupla, den em go gibe yupla ebriting yupla nidem. ");
INSERT INTO tcs_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‘Yupla no prait. Yupla mata lelbet pipol ya uda i pole ubi blo God. Em i God blo yupla ane em prapa api po teke yupla go po da niuples wea em go ruloba yupla. ");
INSERT INTO tcs_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","34","‘Yupla sabe. Wea ol dem prapa gudsamting blo yupla i stap, at blo yupla i go stap de tu. Ip demting blo yupla, i ya wea ert, ol stila i ken stilem ane ol rat ane kakros i ken spoilem. Bat ip yupla sele ebriting wanem yupla gad ane gibem po ol dempla uda nogad, wen yupla go po eben, yupla go gede spesil samting wea i kan pinis.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Zizas bin spik gen, ‘Orait. Yupla mas dresap po wok, laite lamp redi po go. ");
INSERT INTO tcs_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Yupla mas mekem wase dem wokman uda weit po da bos blo da aus uda go kambaik prom dat maret kaikai. Wen da bos i go singaut, dem wokman i go stretwei opene da doa. ");
INSERT INTO tcs_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Dempla gobi glad wen da bos blo da aus go kam ane paine dempla redi, weit po em. Ai spik trutok po yupla, da bos go tekemaut da gud klos blo em, ane seinz po wokingklos blo em. Den em go spik ol dem wokman blo em po sidaun wea teibol ane em go serbe dempla. ");
INSERT INTO tcs_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Dempla gobi api nomata da bos go kam insaid melennait o klostu po deilait ane paine dempla stil wok po em. ");
INSERT INTO tcs_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","‘Rimemba diswan. Ip eni bos blo aus go sabe wanem taim da stila go kam po da aus, em nogo lau em po kam insaid. ");
INSERT INTO tcs_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","So yupla i mas redi, bikoz yupla no sabe wattaim ai da Truwan blo Man go kam.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita bin aske Zizas, ‘BosLod, wanem yu bin eksplein ya? Wiswei, diswan i mata po mipla o i po ebribodi?’ ");
INSERT INTO tcs_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Da BosLod bin ansa baik po em, ‘Dat wokman uda gad bilib ane smat, em gobi da wan uda da bos blo da aus go meke em po edwokman blo dat aus. So dis edwokman go gibe ebriwan kaikai wea da raittaim. ");
INSERT INTO tcs_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Dat edwokman i gobi glad wen da bos blo aus go kambaik ane paindaut em bin meke ol dem wok wanem da bos bin spik em po mekem. ");
INSERT INTO tcs_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ai spik trutok po yupla, da bos go meke dat wokman, bos oba ebriting blo em. ");
INSERT INTO tcs_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Bat mait dat edwokman go tingk da bos i go teke mina longtaim po kambaik ane em stat po ploke ol dem man ane oman uda wok de. So em ploke dempla ane em go stat po kaikai ane dringk obamak, prapa gridiman. ");
INSERT INTO tcs_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Wel, den dat edwokman no gobi redi bikoz em i no sabe wattaim da bos blo em go kambaik. Wen da bos go kambaigen, dis man no gobi redi. Da bos go panse em ane meke em adleiba wase dem pipol uda no bilib. ");
INSERT INTO tcs_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Da wokman sabe wanem da bos blo em i wande em po mekem, bat em no bin redi ane em no bin meke dat wok blo em. Wel da bos blo em go prapa panse em adwan. ");
INSERT INTO tcs_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bat da wokman uda no sabe wanem po mekem, em meke rongting bikoz em no sabe wanem da bos i wandem, da bos nogo panse em prapa adwan. Ip God gibe yupla plenti, yupla mas eso em ane mas gibe em baik. Wen yupla sabe plenti baut God, yupla mas seremaut, prapa mo plenti, dat sabe wanem God i bin gibe yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ane Zizas i kip spik, ‘Orait nau. Ai bin kam po teke zazment blo God wea ol dem pipol blo dis ert wase paia i go bane dempla. Ai kan weit. Ai prapa wande da paua blo zazment po stat ban nau. ");
INSERT INTO tcs_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ai go sapa prapa nadakain wase da man uda go andanit wata po baptaiz, ane ai gobi prapa nadakain ebi antil apta ol dem nugudting wea ai go sapa i go pinis. ");
INSERT INTO tcs_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Yupla tingk ai bin kam po gibe pis wea dis wold. Nono! Ai bin kam po splitemap da wold. ");
INSERT INTO tcs_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Prom distaim ya nau, ol pamle go pait. Ol go splitap bikoz prom mi. Tri gense tu ane tu gense tri. ");
INSERT INTO tcs_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Dempla go splitap: “Papa go gense boi blo em ane boi go gense papa blo em. Mama go gense gel blo em, ane gel go gense mama blo em. Madalo go gense dotalo blo em ane dotalo go gense madalo blo em.” Ebriwan go splitap.’ ");
INSERT INTO tcs_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Den Zizas bin spik po ol dem pipol, ‘Da taim wen yupla go luk da klaud kamap wea naigaisaid, yupla spik i go rein ane da rein i go poldaun. ");
INSERT INTO tcs_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wen yupla pile da sagerwin blou, yupla spik i go prapa nadakain ot. ");
INSERT INTO tcs_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Bat yupla ol tupes pipol. Yupla sabe da wei blo da weda ane yupla sabe wanem go apen. Ei, yupla ol lai pipol. Yupla no sabe o tekenotis po demting ya nau. ");
INSERT INTO tcs_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‘Wasmara yupla? Yupla kan tingbaut po da raitwei? ");
INSERT INTO tcs_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ip yupla gad problem wea nada man ane yupla spostu go po kot, yupla mas pas trai po meke ebriting stret bipo yupla kese kot. Ip yupla no mekem rait, em go teke yupla prant wea da zaz ane da zaz i go gibe yupla po da bos blo da zeilaus. Da bos blo da zeilaus go sake yupla wea zeilaus. ");
INSERT INTO tcs_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Den yupla go sidaun de insaid wea zeilaus ane yupla nogo kamaut antil yupla bin pinis pei ebri las sent.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Da seimtaim nau sam pipol i bin kam gibe niuz po Zizas diskain, Pailat bin oda ol amiman blo em po kile sam pipol prom Galali. Dem amiman bin kile dem man wea da Tempol blo God da seimtaim dempla bin bizi meke sakripais po wosip God. ");
INSERT INTO tcs_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Den Zizas bin aske dempla diskain, ‘Wiswei yupla tingk? Dempla bin ded diskain bikoz dempla gad prapa nugudsin moden dem nadawan de wea Galali, so God bin panse dempla? ");
INSERT INTO tcs_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nono! I no tru. Ai spik yupla, ip yupla no sluraun ane seinze ol wei blo yupla ane pole God, yupla go ded da seimwei wase dempla. ");
INSERT INTO tcs_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yupla tingk po ol dem eitin man uda bin ded wen dat taua bin poldaun, kile dempla wea dat biliz blo Sailoum. Yupla tingk dempla i monugud wase ebribodi uda i stap wea Zarusalem a? ");
INSERT INTO tcs_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nono! I no tru. Ai spik yupla, ip yupla no sluraun ane seinze wei blo yupla ane pole God, yupla go ded da seimwei wase dempla.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Den Zizas bin yan wan stori wea i gad mining, ‘Wantaim wan man i bin gad wan pigtri gro melen wea gadan blo greipbain. Wantaim em bin go lukraun po prut wea dat tri, bat em bin paine nating. ");
INSERT INTO tcs_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","So em bin spik po da man uda lugaut dis gadan, “I bin tri iya nau ai bin kam po luk ip dis tri i sake prut, bat dis tri stil no bin sake prut. Mobeta yu kate dis tri daun bikoz em teke tumas speis wea da gadan.” ");
INSERT INTO tcs_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","‘Bat da man uda lugaut da gadan i bin ansa, “Bos, mipla go libe em wan mo iya. Ai go digemap raun wea dis tri ane pute blaiksoil wea ed blo da tri ane weterem po mekem gro gud. ");
INSERT INTO tcs_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Maitbi em go sake prut. Ip no, den ai go katemdaun.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Go nau. Da Zuwis Sabatdei nau, Zizas bin de wea da zuwispreaus ane em bin tise dempla. ");
INSERT INTO tcs_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Wan oman bin de ane em bin gad debolspirit wea em. Da debolspirit bin meke em kripol po eitin iya. Dis oman bin gad benbaik ane em kan stanap stret. ");
INSERT INTO tcs_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wen Zizas bin luk em, em bin spik em po kam klostu. ‘Oman! Yu pri nau prom da sik wea i bin spoile yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Den Zizas i bin pute tu an blo em antap wea ed blo em. Stretwei dat oman bin stanap stret ane em bin eso God. ");
INSERT INTO tcs_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Da lida blo da zuwispreaus i bin wail po Zizas bikoz em bin meke wok, ile sambodi wea da Zuwis Sabatdei. Da lida i bin spik dem bigmob pipol, ‘Yupla gad siks dei po meke wok. So ip yupla wande eniwan po ile sik blo yupla, yupla mas kam wea dem wokdei. Yupla no kam po disting wea Sabatdei.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Da BosLod i bin ansa, spik dempla stret, ‘Ei! Yupla tupesman. Nomata i Zuwis Sabatdei, yupla stil tekemaut rop prom ol kau ane dongki blo yupla ane teke dempla po dringk wata. ");
INSERT INTO tcs_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wiswei dis oman ya? Em blo da pamlelain blo longtaim papa Eibram. Bat Satana bin meke em kripol po eitin ya. Yupla tingk i nugud po meke em pri wea Zuwis Sabatdei a?’ ");
INSERT INTO tcs_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wail Zizas bin tok diskain, dem enami blo em i bin prapa sem. Bat ebribodi de wea dat mob ol bin prapa nadakain api bikoz em bin meke prapa plenti ol gudsamting. ");
INSERT INTO tcs_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Zizas bin yan dempla baut dat niuples wea God go ruloba ebriwan. ");
INSERT INTO tcs_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Em bin spik, ‘Dat niuples em wase prapa smolsid blo mastadtri wea sambodi plante da sid wea gadan blo em. Nau wen da taim go kam, dat smol mastadsid i go gro kam prapa big tri ane ol pizin ken meke nest wea dem tam blo em. Diswan i min, mina lelbet pipol i go pole ubi blo God nau. Bat mo go luk ane ol go zoin dem lelbet pipol ane God i go ruloba dempla.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Den Zizas bin aske dempla gen, ‘Wiskain dat niuples wea God go ruloba ebriwan? ");
INSERT INTO tcs_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Em wase yis. Ol oman mikse lelbet yis wea wata ane plenti plaua, solong meke big dou. Dat yis i go meke dat dou swelap redi po meke gud dampa. Wea da seimwei nau, God ken suze wan man po spik da gudniuz po ol dem nada pipol sole plentimo pipol go pole ubi blo God.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Bipo Zizas bin wagbaut go po Zarusalem, em bin go po ol dem dipren taun ane biliz po tise dempla baut God. ");
INSERT INTO tcs_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Sambodi bin aske em, ‘BosLod, wiswei? Mata lelbet pipol i gobi seib a?’ Zizas bin ansa baik em, ");
INSERT INTO tcs_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","‘Yupla mas trai prapa ad. Yupla mas trai olkainwei po go tru da naro doa wea eben, bikoz prapa plenti pipol i go trai po go tru da doa bat dempla kan. ");
INSERT INTO tcs_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Da taim i go kam wen da bos blo da aus go loke da doa bikoz i leit ane em go libe yupla stanap de ausaid. Yupla go singaut ane nok, “O o bos! Opene da doa po mipla.” ‘Bat da bos go ansa yupla, “Nono! Ai no sabe yupla o wea yupla kam prom.” ");
INSERT INTO tcs_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","‘Den yupla go singaut po em, “BosLod, mipla bin kaikai tugeda wea yu, ane yu i bin tisa wea taun blo mipla.” ");
INSERT INTO tcs_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bat da BosLod i go spik po yupla, “Ai no sabe uda yupla. Gowei prom mi, ebriwan yupla uda i bin meke ol nugudting.” ");
INSERT INTO tcs_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","‘Yupla go nadakain bigkrai ane graine tit prom sore wen yupla go luk Eibram, Aizak, ane Zekop ane ol dem longtaim spesilmesizman blo God, de insaid wea dat niuples blo God ane yupla nogo lau wea dat ples wea God i ruloba ebribodi. God go sate doa wea pes blo yupla. ");
INSERT INTO tcs_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ol pipol go kam prom ebriwea wea ert. Dempla go kam po da big pisting wea dat niuples wea God go ruloba ebriwan. ");
INSERT INTO tcs_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Bat lisen gud nau. Sam pipol uda louklas nau, ol gobi prapa nambawan. Sam pipol uda bigman nau, ol gobi nambalas.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Da seimtaim nau, sam Parasi i bin kam po spik wea Zizas, ‘Yu mas libe dis ples ane go nada ples bikoz Erod Antipas i wande kile yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Zizas bin spik po dempla, ‘Yupla go ane spik po Erod, em tumas tok, mata paipa. Em ken tok diskain em go kile mi, bat ai no prait. Tidei ane tumoro ai go kip meke ol dem debolspirit po kamaut prom dem pipol ane ai go ile dem sikpipol. Den wea namba tri dei, ol wok blo mi i go pinis. ");
INSERT INTO tcs_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ai go diswei nau po Zarusalem, tidei, tumoro ane da neksdei, wen ai go kesem de wea Zarusalem. Wel yupla sabe, mata Zarusalem da rait ples po kile ol dem spesilmesizman blo God.’ ");
INSERT INTO tcs_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Zizas bin spik, ‘Zarusalem, Zarusalem. Yagar! Yupla kile ol dem longtaim spesilmesizman blo God, dempla uda spik da ubi blo God. Yupla bin stone dempla po ded, demwan uda God bin sanem po yupla. Plentitaim ai bin wande kese yupla wan ples wase mama pizin kese ol smolpikinini pizin andanit wing blo em. Bat yupla no bin lete mi po kese yupla. Ol mai pikinini kam klostu. ");
INSERT INTO tcs_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yupla lisen po mi nau. God i go go prom da Tempol blo em. Yupla nogo luk mi gen antil dat taim go kam ane yupla go singaut diskain, “AntapGod, yu blese da wan uda kam wea da neim blo Yu.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wan Zuwis Sabatdei, Zizas i bin po go kaikai wea aus blo wan edman blo dem Parasi. Ol dem pipol uda bin inbait po da kaikai, ol bin mata wase Zizas prapa klostu. ");
INSERT INTO tcs_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wan man de i bin prapa sik. Bodi blo em bin prapa nadakain swelap. ");
INSERT INTO tcs_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Zizas bin luk em, den em bin aske ol dem Parasi ane ol dem smatman blo dem Zuwislo, ‘Ei! Wiswei yupla tingk? I rait po ile man wea Zuwis Sabatdei?’ ");
INSERT INTO tcs_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bat dempla bin stap kuaiat. Dempla no bin ansa. So nau Zizas bin kese an blo dat sikman ane Zizas bin ile em. Den em bin spik dat sik po go. ");
INSERT INTO tcs_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Zizas bin aske dempla, ‘Ip buluk o kau blo yupla poldaun insaid wel wea Zuwis Sabatdei, wiswei yupla go mekem? Yupla sabe. Stretwei yupla go pulem kam antap.’ ");
INSERT INTO tcs_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Dempla kan spik nating, dempla mata stap kuaiat. ");
INSERT INTO tcs_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Den Zizas i bin tekenotis sam man uda suze da bes ples po sidaun, ol dem gudples. So em i bin yan dis stori wea i gad mining. ");
INSERT INTO tcs_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","‘Wen sambodi inbait yupla po weding pisting, yupla no teke ol dem spesil sit, bikoz dempla i bin inbait mo bigman po da weding pisting tu. So wanem yupla go mekem? ");
INSERT INTO tcs_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Ip da bos blo da weding go spik po yupla, “Yu gibe da sit po dis man po sidaun,” den yu go pil sem, bikoz yu mas mub go po da prapa nugud sit. ");
INSERT INTO tcs_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","‘Bat wen dempla inbait yupla, yupla go sidaun wea dem nugud sit. Den da man uda bin inbait yupla, em go kam ane spik po yupla, “Mai pren, yu kam sidaun ya wea da gudples.” Den ol dem pipol uda bin inbait po da weding pisting ol go luk wiskain yu gede ona prom da bos blo da weding. ");
INSERT INTO tcs_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Dempla uda meke demplaselp prapa big, God go meke dempla kamdaun lou. Bat dempla uda meke demplaselp lou, God go meke dempla big.’ ");
INSERT INTO tcs_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Den Zizas bin spik po da man uda bin inbait em, ‘Wen yu meke pisting, yu no mata inbait pren blo yu ane pamle ane ol dem ris neiba blo yu, bikoz dempla ol go peibaik yu. ");
INSERT INTO tcs_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Nono! I mobeta wen yu meke pisting, yu inbait ol dem poapipol, ol dem kripol, ol dem pipol uda leim ane ol dem pipol uda blain. ");
INSERT INTO tcs_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Yu spostu glad dat dempla kan peibaik yu. God go blese yu dat dei wen ol dem pipol blo em i go gedap laipwan wea dat lasdei.’ ");
INSERT INTO tcs_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wan man uda bin kaikai de wea Zizas i bin spik, ‘Ei! Ol dem pipol uda gobi de wea da big pisting wea da ples wea God go ruloba ebriwan, dempla gobi nadakain api.’ ");
INSERT INTO tcs_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Zizas bin ansabaik diskain, ‘Wantaim wan man bin meke big kaikai ane em bin inbait prapa plenti pipol po kam. ");
INSERT INTO tcs_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Bat wen da kaikai blo da pisting bin redi, em bin sane wokman blo em po singaut dempla uda em bin inbait, “Kam, kaikai i redi nau.” ");
INSERT INTO tcs_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","‘Bat ebriwan uda i bin inbait, ol bin gad ekskius no po kam po da kaikai. Pas man i spik po da wokman, “Sore, ai kan kam. Ai bin baie pam ane ai mas go po luk da pam.” ");
INSERT INTO tcs_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","‘Nadawan i bin spik em, “Sore, ai kan kam. Ai bin baie ten buluk ane ai wande go nau bikoz ai mas traie dem buluk, ip ol gud po wok wea pam.” ");
INSERT INTO tcs_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","‘Namba tri wan bin meke ekskius tu, “Sore, ai kan kam bikoz ai bin disnau maret.” ");
INSERT INTO tcs_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","‘Da wokman bin kambaik po da bos blo em ane em bin spik po em wanem i bin apen. Dat bos i bin nadakain wail wen em bin lisen ol dem ekskius. Den em bin spik po dat wokman blo em, “Yu go kuikwan po taun, go ebri strit ane ol smolrod. Singaut ol dem pipol uda poa ane ol dem kripol ane ol dem pipol uda blain ane leim po kam po dis pisting.” ");
INSERT INTO tcs_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Den apta wen da wokman i bin kambaik, em bin spik, “Bos. Mipla bin mekem wanem yu bin spik mipla po mekem, bat yumpla stil gad speis po mo pipol.” ");
INSERT INTO tcs_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Den da bos blo dat aus bin spik po da wokman blo em gen, “Yu go wea ol dem mein rod ane ol dem smol busrod ane singaut dempla uda wagbaut wea dem rod po kam po dis pisting tu. Ai wande dis aus blo mi gobi prapa pul. ");
INSERT INTO tcs_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ai spik yupla nau. Nobodi prom dempla uda ai bin inbait de pas i go lau po kaikai eniting wea da pisting blo mi.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mina bigmob blo pipol i bin wagbaut wea Zizas wail em wagbaut go. Em bin sluraun ane em bin spik po dempla, ");
INSERT INTO tcs_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","‘Ip enibodi labe papa ane mama, ane oman ane ol pikinini, ane bala ane sisi, ane iben laip blo em moden mi, em kan kam klostuman blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ip enibodi no wande kare kros blo em, po pole mi ane redi po ded po mi, em kan kam klostuman blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","‘Ip yupla wande bilde big bilding, yupla mas sidaun pas ane luk aumas i go kos. Yupla mas paindaut pas ip yupla gad nap mani po pinis da bilding. ");
INSERT INTO tcs_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ip yupla nogo mekem diskain, yupla go gad paundeisan das ol. Den yupla kan pinis bildem ane ol dem nada pipol go moke yupla. ");
INSERT INTO tcs_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ol go spik, “Ei luk. Ol bin stat da bilding bat ol kan pinis da bilding.” ");
INSERT INTO tcs_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","‘Ip wan king em gad 10,000 amiman po pait wea nada king uda gad 20,000 amiman, da paswan go sidaun pas ane luk ip em ken bite da king uda gad 20,000 amiman. ");
INSERT INTO tcs_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ip em sabe em nogad nap strong po paite dat nada king uda gad 20,000 amiman, den mobeta em sane saidman blo em po dat nada king po meke pis wea em bipo dat nada king kam moklostu. ");
INSERT INTO tcs_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ip yupla wande kam klostuman blo mi, yupla mas gibap ebriting ane pole mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","Zizas i bin spik gen, ‘Yupla sabe wiskain solt em gud po kaikai. Bat ip da tes blo da solt kam nugud, wiswei yupla go meke da tes kamgudgen. Yupla kan. So mata sakwei. Yupla lisen uda gad talinga, ane yupla prapa tingbaut nau!’ ");
INSERT INTO tcs_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Orait nau. Plenti dem taksman ane ol dem nugudman bin kip kam po lisen dem yan blo Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bikoz dempla ol nugudman bin kam, dem Parasi ane dem Zuwislotisa, ol bin smolsmoltok baut Zizas diskain, ‘Ei! Em welkam ol dem nugudman ane em bin kaikai wea dempla.’ ");
INSERT INTO tcs_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Zizas bin sabe diswan, so em bin yan dis stori wea i gad mining. ");
INSERT INTO tcs_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","‘Ip wan prom yupla gad andred sip ane em luze wan, wanem yupla tingk em go mekem? Yupla sabe. Em go libe dem nainti nain sip de. Den em mas go lukraun po dat wan sip i bin lus, lukraun antil em go paine dat sip. ");
INSERT INTO tcs_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ane wen em pinis paine da sip i bin lus, em gobi prapa glad ane em go putem wea solda ane kare em go po aus. ");
INSERT INTO tcs_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Wen em go kese aus blo em, em go singaut ol pren ane neiba blo em po kam klostu. Den em go spik po dempla, “Yumpla go meke pisting bikoz ai bin pinis paine da sip wea ai bin lusem.” ");
INSERT INTO tcs_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ai spik yupla trutok. Ol dem einzel wea eben gobi moglad bikoz dat wan nugudman i bin sluraun ane seinze laip blo em, den po ol dem nainti nain rait ane stret pipol uda no bin sluwei prom God.’ ");
INSERT INTO tcs_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Zizas i bin yan wan stori wea i gad mining, ‘Ip wan oman em gad ten silba koin ane em i luze wan, wanem yupla tingk em go mekem? Yupla sabe. Em mas go laite lamp ane swipe da aus prapa gud antil em go paine da silba koin. ");
INSERT INTO tcs_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nau wen em go paine da silba koin, em go singaut ol dem pren ane neiba blo em. Em go spik dempla diskain, “Yumpla go meke pisting bikoz ai bin pinis paine da silba koin wea ai bin lusem.” ");
INSERT INTO tcs_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ai spik yupla nau. Da seimwei ol dem einzel blo God gobi moglad bikoz wan nugudman i bin sluraun ane seinze laip blo em.’ ");
INSERT INTO tcs_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Zizas i bin yan wan mo stori wea i gad mining, ‘I bin gad wan man ane em bin gad tu boi. ");
INSERT INTO tcs_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wandei da las bala i bin tok po papa blo em. Em spik diskain, “Papa, yu gibe mi mai sea blo da mani ane da propati.” So da papa i bin splite da propati melen po demtu boi blo em. ");
INSERT INTO tcs_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","‘Apta nau, da namba tu boi bin sele dat sea blo em. Nau em bin teke da mani ane em bin go, go longwei po nada kantri. Em bin spene ol dat mani blo em siliwei. Ol mani blo em i bin skint, nogad. ");
INSERT INTO tcs_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ane seimtaim, dat ples i bin kam prapa drai, nogad no rein. Em i kan paine kaikai eniwea. ");
INSERT INTO tcs_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","So em bin go lukraun po zob. Em i paine zob wea wan man blo dat kantri. Da man i bin spik em, “Orait. Yu go wok po mi. Wok blo yu ya ai spik, yu go pide pig blo mi.” ");
INSERT INTO tcs_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","So ebritaim da boi teke kaikai go po pide dem pig, em prapa wande kaikai da kaikai blo dem pig bikoz em i prapa anggre. Ebritaim i kipgo laidat. Em tingk, “Ei, ai tingk ai go kaikai dem kaikai blo dem pig tu. Nobodi ya bin gibe mi eniting po kaikai.” ");
INSERT INTO tcs_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","‘So wandei em i sidaun. Em i tingk gobaik po papa blo em. Em i tingk, “Baizi! Wanem ai mekem ya? Wea aus blo papa blo mi, em i gad wokingman. Dempla ebriwan gad plenti kaikai. Ane mi ya, ai mina anggre, klosap po ded. Ei, ai nogad nating po kaikai! ");
INSERT INTO tcs_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ai tingk ai go gedap. Ai go luk mai papa. Wen ai go luk em, ai go spik po em diskain, “Papa. Ai bin meke rongting gense God ane ai bin meke rongting gense yu. ");
INSERT INTO tcs_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ane yu no kole mi boi blo yu nau. Ai nugudnap po boi blo yu. Yu meke mi wase dem wokingman blo yu. ” ");
INSERT INTO tcs_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","‘So da boi tingk, “Wa!” Den em i gedap prom de ane em i kambaik po papa blo em. Em i kam, kam. Wen em i kam klosap po dat ples, da papa i luk. Em spik, “Ei! Diswan boi blo mi ya kambaik. Ai megaraut em. Ai go ran ane ai go kese mai boi.” So em i ran go. Em i pute an raun wea da boi blo em ane em kis em. ");
INSERT INTO tcs_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Da boi spik po papa blo em. Em i spik, “Papa. Ai nugudnap po yu po kole mi, boi blo yu. Ai bin meke rong gense God ane ai bin meke rong gense yu.” ");
INSERT INTO tcs_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","‘Bat da papa bin singaut po sam sebant blo em, “Teke da bes klos kam ane putem wea em. Pute ring wea pingga blo em ane pute sandol wea put blo em. ");
INSERT INTO tcs_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yupla go de, teke da bes buluk ane kilem. Yumpla go meke big pisting po welkam em kambaigen. ");
INSERT INTO tcs_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Yumpla mekem diskain bikoz boi blo mi, i bin wase ded bat nau em i laip. I bin lus bat nau mipla bin painem.” So dem sebant bin go. Ol i kile da bes buluk ane ol i stat meke da kaikai. ");
INSERT INTO tcs_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Dat seimtaim wen ol i bin meke da kaikai, dat namba wan boi em bin wok de ausaid samwea wea pam. Wen em i kam klostu po aus, em i lisen miusik ane ol i dans. ");
INSERT INTO tcs_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Den dat namba wan boi i singaut wan dem sebant, “Wanem ol i mekem de?” ");
INSERT INTO tcs_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Da sebant spik po em, “Ol i meke kaikai po smolbala blo yu. Em bin kambaik po gud ane papa blo yu bin kile da bes buluk.” ");
INSERT INTO tcs_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","‘Wen em bin lisen dat tok, da bala bin prapa wail ane em no bin go insaid po dat pisting. So da papa bin go ausaid ane em trai po mekem gud so dat namba wan boi go kam insaid. “Yu kam insaid nau so yu ken kaikai wea smolbala blo yu. Em bin kambaik.” ");
INSERT INTO tcs_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bat da bigbala bin spik, “Yu prapa wande da smolbala moden mi. Ebritaim, prom ol da taim ai bin stap ya wea yu, ai bin wok po yu wase sleib. Ai bin meke ebriting wea yu bin spik mi po mekem ane yu no bin gibe mi nating. Yu no bin gibe mi iben wan smolgout po meke pisting po mi ane ol pren blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bat dis smolboi blo yu ya, i bin weiste ol da mani blo em wea rabisoman. Den wen em bin kambaik nau, yu welkam em. Yu bin kile da bes buluk po em.” ");
INSERT INTO tcs_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","‘Bat da papa bin spik po em, “Ei! Ai wande yutu, bikoz yutu tu pikinini blo mi. Yu bin ya ol da taim wea mi. Wanem ai gad, i blo yu. Ebriting ai gad, i blo yu. ");
INSERT INTO tcs_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mipla mas meke pisting ane mipla mas prapa glad po em. Dis smolbala blo yu em bin wase ded bat nau em i laip. Em bin lus bat nau mipla bin painem.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Diswan nada stori wea i gad mining wiskain Zizas bin yan po dem klostuman blo em. Zizas bin spik diskain, ‘I bin gad wan risman uda bin gad wan maniza. Dat maniza bin wok po em. Bat dem pipol bin ripot em po da risman, bikoz da maniza bin weiste mani blo em. ");
INSERT INTO tcs_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","So da risman bin singaut da maniza ane askem, “Wiswei? Ai bin lisenbaut wanem yu bin mekem wea mani blo mi. Ai go sekap ol biznis buk blo yu. Bikoz yu no bin lugaut da propati blo mi gud, ai go seke yu nau.” ");
INSERT INTO tcs_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","‘Da maniza bin tingbaut, “Wanem ai go mekem nau? Ai go luze zob blo mi. Ai nogad strong po wok wea an blo mi, ane ai kan beg po kaikai bikoz ai sem. ");
INSERT INTO tcs_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Orait. Ai sabe wanem ai go mekem sole ol pipol go lugaut mi wea aus blo dempla wen ai go luze zob blo mi.” ");
INSERT INTO tcs_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","‘So em bin singaut ebriwan uda bin oue mani po da bos blo em. Em bin spik wansaid po paswan, “Aumas yu oue bos blo mi?” ");
INSERT INTO tcs_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘ “Andred dram oil po kuk”, em bin ansa em baik. ‘Da maniza bin spik po em, “Okei. Ip yu pei mi pipti dram oil, ol dem det blo yu i klia.” Diswan po meke da risman pilgud. ");
INSERT INTO tcs_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","‘Den em bin aske da nekswan, “Aumas yu oue da bos?” ‘Dat man bin ansa em, “Andred sekbaig sid blo wit po meke plaua.” ‘Da maniza bin gibe em da bil ane em bin spik po em, “Ip yu pei mi eiti sekbaig blo sid blo wit, ol dem det blo yu i klia.” Diswan po meke dat man pilgud. ");
INSERT INTO tcs_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","‘Wen da bos bin lisen wanem da nugud maniza bin mekem, em bin spik diskain, “Em prapa smat bikoz em gad gudsens wiskain po lugaut emselp.” ’ Zizas bin spik, ‘Plenti pipol wea dis ert ol mosmat po andel wananada den dempla uda pole God. Wa! Ai wande yupla po bi diskain smat.’ ");
INSERT INTO tcs_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Zizas i bin kip spik diskain, ‘Ai spik yupla nau, yupla no meke mani wase dat maniza bin mekem. Diswan i nugudwei. Yupla mas yuze mani raitwei po meke pren po yuplaselp. So wen yupla go ded ane mani i pinis, yupla gobi welkam de wea God poeba wea dat ples blo yupla de wea eben. ");
INSERT INTO tcs_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Ip yupla sabe yupla ken trase sambodi wea ol smolting, den yupla ken trase em wea ol bigting tu. Bat ip yupla kan trase sambodi wea ol smolting den yupla kan trase em wea ol bigting tu. ");
INSERT INTO tcs_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Wiswei nau! Ip yupla kan andele mani raitwei ya wea dis ert, wel God kan gibe yupla gudting prom eben, bikoz em kan trase yupla po yuzem raitwei. ");
INSERT INTO tcs_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ip yupla kan lugaut dem gudting blo God, den God kan gibe yupla ol dem gudting wea em wande gibem po yupla. ");
INSERT INTO tcs_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Wokman kan wok po tu bos wantaim. Nono! Em go laik da wan ane em go eite da nadawan. Dat wokman go teke mo notis po da wan bos ane no tekenotis blo da nadawan. So, yupla kan labe God ane mani seimtaim.’ ");
INSERT INTO tcs_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wen dem Parasi uda bin prapa labe plenti mani bin lisen dis tok blo Zizas, dempla bin meke prapa nugud pes po Zizas ane lap em. ");
INSERT INTO tcs_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Bat Zizas bin sabe ane em bin spik po dempla, ‘Yupla meke yuplaselp luk prapa rait ane stret prant wea ol dem pipol, bat God sabe at blo yupla. God em i daune ol demting wea pipol tingk i impotant po dempla. ");
INSERT INTO tcs_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‘Yupla bin gad dem Mozeslo ane ol dem longtaim spesilmesizman blo God, raitap po da taim blo Zon Baptaizman. Bat prom dat taim da Gudniuz bin kamaut diskain, God go meke niuples wea em go ruloba ebriwan, ebriwan go trai po puse wei blo dempla go de. ");
INSERT INTO tcs_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wel ai go spik yupla ya nau. Dem lo blo God kan pinis, no iben wan smolpat blo dem lo i kan pinis. Dem lo i go kipgo poeba. Ip eben ane ert i go pinis, dem lo blo God ol nogo pinis. Dem lo i go mata stap poeba.’ ");
INSERT INTO tcs_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Den Zizas bin spik, ‘Wen man libe oman blo em ane maret nada oman, diswan prapa nugudwei. Em broke maretlo blo God. Seimwei, ip man maret oman uda bin libe man blo em, em broke maretlo blo God tu.’ ");
INSERT INTO tcs_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Orait. Zizas i bin yan stori wea i gad mining baut wan risman. Em bin spik, ‘I bin gad dis risman bin were ol prapa plasklos ane em mata meke pisting ebridei. Em bin stap wea prapa plas ples. ");
INSERT INTO tcs_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Klostu wea da prant doa blo da aus blo da risman, wan begaman bin leidaun. Neim blo em Lazaras. Ebridei sambodi bin kare em kam ane libe em de. Em bin gad prapa plenti soa ebriwei wea bodi blo em. ");
INSERT INTO tcs_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ol dog bin kam ane lik ol soa blo em. Lazaras bin prapa wande kaikai dem smolpis blo kaikai wea i bin poldaun prom teibol blo dat risman. ");
INSERT INTO tcs_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","‘Orait nau. Lazaras bin ded ane ol einzel bin kare em go ane pute em longsaid wea Eibram. Da risman i bin ded tu ane ol bin bere em. ");
INSERT INTO tcs_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Em bin go el wea em gad mina nadakain bigpein. Wen em bin luk go antap, prapa longwei, em luk Eibram ane Lazaras tugeda. ");
INSERT INTO tcs_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","‘Da risman bin singaut prapa laudwan po Eibram. “Ei! Papa Eibram, plizgar elpe mi. Sane Lazaras da begaman po wete pingga blo em wea wata ane kam tase tang blo mi po meke tang blo mi kol. Ai gad nadakain nugud pein ya melen wea dis paia.” ");
INSERT INTO tcs_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","‘Bat Eibram bin ansa em diskain, “Mai boi. Yu sabe wen yu bin laip wea ert. Yu bin gad ol plenti gudting, bat Lazaras bin gad olkain nugudtrabol wea em. Bat nau, yu gad trabol ane pein, ane Lazaras i gad pis ya. ");
INSERT INTO tcs_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bat nadating ai spik yu ya. Nobodi kan kros go de nadasaid wea yu ane nobodi kan kros kam ya. I gad prapa bigwaid dipklip ya melen wea yumi.” ");
INSERT INTO tcs_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","‘So da risman bin spik, “Yu lisen po mi papa Eibram. Plizgar, yu ken sane Lazaras go po aus blo papa blo mi? ");
INSERT INTO tcs_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Em go gibe mesiz po spik po ol paib bala blo mi po seinze ol wei blo dempla, so dempla i nogo endap wase mi ya wea el.” ");
INSERT INTO tcs_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","‘Bat Eibram bin ansa em, “Ol dem bala blo yu i gad dem Mozeslo ane dem raiting blo dem longtaim spesilmesizman blo God. Dempla spostu tekenotis po dem raiting.” ");
INSERT INTO tcs_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","‘Da risman bin ansa em baik, “Nono gar, papa Eibram. Ip sambodi uda bin ded, em gobaik ane wone dempla, den dempla ol go sluraun prom ol nugudlaip blo dempla.” ");
INSERT INTO tcs_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Bat Eibram ansa em baik, “Ip dempla nogo lisen po da raiting blo dem Mozeslo ane dem spesilmesizman blo God, dempla nogo lisen po sambodi uda bin gedap laipwan prom ded.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nau Zizas bin yan po ol dem klostuman blo em, ‘Yupla sabe olkainting go kam po tempte ol pipol po gibap ane no po pole ubi blo God. Bat lugaut po dem nugudpipol uda meke ol dem pipol gibap. God go prapa panse dempla uda mekem diskain. ");
INSERT INTO tcs_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mobeta dempla taiemape rop i gad big angka ane angem raun wea nek blo demplaselp ane sake demplaselp insaid wea dipwata. Den dempla kan meke demwan uda gad wik bilib gibap ane nomo pole ubi blo God. ");
INSERT INTO tcs_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","So yupla lugaut nau wanem yupla mekem! ‘Wotip wan bala meke nugudting, yu mas strete em. Ane ip em spik, “Ai sore po wanem ai bin mekem”, yupla mas pogibe em. ");
INSERT INTO tcs_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Iben ip em meke nugudting po yupla sebentaim wea wan dei ane ebritaim em spik yupla, em sore, yupla mas kip pogibe em.’ ");
INSERT INTO tcs_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Dem misnareman blo Zizas i bin aske da BosLod, ‘Yu gibe mipla mo bilib plizgar!’ ");
INSERT INTO tcs_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Da BosLod bin ansa dempla, ‘Yupla sabe smolsid blo mastadtri. Nomata ip bilib blo yupla wase saiz blo demkain smolsid, yupla ken tok po tri, “Yu pulemaut yuselp prom graun ane yu go plante yuselp wea solwata”, ane da tri go lisen yupla. ");
INSERT INTO tcs_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","‘Wotip wan prom yupla ya gad wokman uda bin bizi meke gadan o maitbi em bin lugaut ol sip. Wen dat wokman go kam prom dat wokples, wiswei da bos go spik po em? Em go spik diskain, a? “Kam sidaun nau ane kaikai.” ");
INSERT INTO tcs_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Nono! Da bos go spik diskain, “Yu go kuke sapa pas, den meke yuselp redi ane kam po serbe mi kaikai. Apta, wen ai pinis kaikai den yu ken kaikai.” ");
INSERT INTO tcs_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Wiswei? Yupla tingk da wokman go gede spesil eso prom da bos po da wok wanem em bin spik em po mekem? Nono! Da bos nogo eso em. ");
INSERT INTO tcs_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","So da seimwei wea yupla tu. Wen yupla meke ebriting wanem ai, da bos blo yupla bin aske yupla po mekem, yupla spostu spik diskain, “Wa. Mipla ol wokman blo yu. Yu no oue mipla eniting. Mipla mata meke wok blo yu wanem mipla spostu mekem.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Nau Zizas bin wagbaut go po Zarusalem ane em bin pas tru dat ples bituin Galali ane Samaria. ");
INSERT INTO tcs_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wen em bin kam klostu po wan biliz, ten man uda bin gad nugud skindiziz bin mite em de. Dempla bin stanap lelbet longwei prom em. ");
INSERT INTO tcs_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Dempla bin singaut po em, ‘Zizas. Tisa, plizgar soe sorewei po mipla ane elpe mipla!’ ");
INSERT INTO tcs_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wen Zizas bin luk dempla em bin spik po dempla, ‘Go soe yuplaselp po dem prist pas so dempla go luk yupla.’ Nau, wen dempla bin wagbaut go po luk dem prist, dempla bin luk ol dem nugud skindiziz i bin pinis. Dempla skin bin kambaigen gud. ");
INSERT INTO tcs_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wen wan man prom dempla bin luk skin blo em bin kamgud, em stretwei tan gobaik po Zizas ane em bin singaut ane preize God prapa laudwan. ");
INSERT INTO tcs_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Em bin poldaun prant wea Zizas ane em bin eso em. Ane em bin man prom Samaria. ");
INSERT INTO tcs_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Zizas bin aske dem klostuman blo em, ‘Ei! Ai sabe olgeda dem ten man bin il prom sik. Wea ol dem nada nain man? ");
INSERT INTO tcs_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mata wan man bin kambaik po preize God ane em no kantriman blo yumpla. Em blo Samaria.’ ");
INSERT INTO tcs_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Den Zizas bin spik po dat man, ‘Gedap. Yu ken go nau. Bilib blo yu bin meke yu kamgud.’ ");
INSERT INTO tcs_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wantaim sam Parasi bin aske Zizas, ‘Wattaim God go kam po ruloba mipla wea niuwei blo em?’ Zizas bin ansa dempla, ‘Niuwei blo God i diskain. Wen em go kam po ruloba yupla, em wase samting yupla kan luk wea ai blo yupla. ");
INSERT INTO tcs_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Yupla kan spik diskain, “Luk, em ya”, o “Luk, em de.” Nono! Bikoz God gobi insaid yupla ane God go ruloba yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Apta nau, Zizas bin yan po ol klostuman blo em, ‘Da taim go kam wen yupla go prapa wande luk da dei wen ai da Truwan blo Man go kam. Bat yupla nogo luk mi. ");
INSERT INTO tcs_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Sam pipol go spik po yupla, “Ei! Luk da Truwan blo man em de!” o “Luk em ya!” Bat yupla mas no pole dempla. ");
INSERT INTO tcs_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Wen ai da Truwan blo Man go kambaik, i gobi wase laitning i straik wea da skai. Da skai go laitap olgeda ane yupla ken luk prapa klia. ");
INSERT INTO tcs_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bat bipo disting i go apen, dem plenti pipol ya tidei nomo go pole mi. Dempla no go wande bilib ai go seibe dempla. Dempla go meke mi, da Truwan blo Man sapa wea olkain prapa nugudwei. ");
INSERT INTO tcs_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","‘Bipo ai da Truwan blo Man go kambaigen, da taim i gobi wase dem bipotaim dei wen da man Noa i bin stap ya wea ert. ");
INSERT INTO tcs_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ol dem pipol de bin kaikai, dringk ane maret, raitap po da dei wen Noa bin go insaid wea dat bigbot. Den da bigplad bin kam ane kile ebriwan wea ert. ");
INSERT INTO tcs_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Zizas bin kip spik, ‘I bin seimkain wen Lot bin stap wea ert tu. Ol pipol i bin meke da seimting. Dempla bin kaikai ane dringk, baie ol samting ane selem, meke gadan ane bilde ol aus tu. ");
INSERT INTO tcs_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bat da seimdei Lot bin kamaut prom Sodom, God bin meke paia poldaun prom da skai wase rein ane kile ebriwan de wea da taun blo Sodom. ");
INSERT INTO tcs_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Laip i go kipgo wea da seimwei antil dat dei wen ai da Truwan blo Man go kambaigen. ");
INSERT INTO tcs_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Wea dat seimdei, ip sambodi i ausaid aus blo em, em mas nogo insaid po teke ol samting blo em. I seimkain, uda dempla i meke gadan, ol mas no gobaigen aus po teke ol samting blo dempla. Yupla no tingbaut po gobaik po teke demting, mata ran luk po ples po aid. ");
INSERT INTO tcs_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Yupla i tingbaut wanem bin apen po oman blo Lot. ");
INSERT INTO tcs_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","‘Enibodi uda wande lugaut laip blo em, em go luze laip blo em. Bat enibodi uda luze laip blo em po mi, em go gede longlaip poeba. ");
INSERT INTO tcs_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ai spik yupla ya nau. Wea dat nait, tu pipol go slip wea wan bed, dem einzel uda go kam po teke dempla, dem einzel go teke wan ane libe da nadawan. ");
INSERT INTO tcs_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Tu oman gobi bizi graine sid po meke plaua. Dem einzel go teke wan ane libe da nadawan. ");
INSERT INTO tcs_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Tu man go wok wea gadan. Dempla go teke wan ane libe da nadawan.’ ");
INSERT INTO tcs_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ol klostuman blo Zizas bin aske em, ‘Ei! BosLod. Wea disting i go apen?’ Zizas bin ansa dempla, ‘Yupla kan mise da ples. Em wase ples wea ol ded pis i leidaun ane ol solwata pizin i plai raun wea dem ded pis. Wen yupla luk ol diskainting i apen, den yupla sabe da taim blo mi i klostu nau po kam.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Orait nau. Zizas bin yan dis stori wea i gad mining po lane dem klostuman blo em dat dempla mas kip prea ebritaim ane no gibap. ");
INSERT INTO tcs_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","So em bin yan dis stori, ‘Wea wan taun i gad wan man. Em i zaz blo kot. Dat zaz em no prait prom God ane em noboda baut dem pipol. ");
INSERT INTO tcs_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wea dat taun i bin gad wan widooman uda bin kip kambaik po dat zaz. Em bin aske em, “Plizgar, yu ken elpe mi bikoz dis nada man kip meke trabol po mi.” ");
INSERT INTO tcs_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Pastaim dat zaz no bin wande elpe em, bat apta em bin tingbaut, em bin tingk po emselp, “Ei, dis widooman em prapa meke mi wail. Ai no prait prom God ane ai noboda po dem pipol. ");
INSERT INTO tcs_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Bat ai go mata pole ubi blo em. Em go meke mi nadakain taiat bikoz em go kip pestaring mi tumas. Bambai ai go spik em po stap kuaiat.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Da BosLod bin spik, ‘Yupla lisen mi. Yupla lane lesen prom wanem dis nugud zaz bin tok. ");
INSERT INTO tcs_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wiswei yupla tingk? God go meke raitting po pipol blo em uda singaut ol nait ane ol dei po em a? Yupla sabe God. Em no wase dat nugud zaz. Nono! Em go ansa dempla prapa kuikwan.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Zizas kip spik, ‘God go meke raitting po pipol blo em ane em i go mekem kuikwan. Ai aske yupla nau. Wiswei? Wen ai da Truwan blo Man go kambaigen, yupla tingk ai go paine pipol blo mi uda gad bilib wea mi wen ai go kambaigen?’ ");
INSERT INTO tcs_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Orait. Zizas bin yan wan stori wea i gad mining po sam pipol uda tingk dempla mogud wea ol dem nada pipol ane dempla bin daune ebriwan tu. ");
INSERT INTO tcs_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Em spik, ‘Wan Parasi ane wan taksman bin go po da Tempol blo God po prea. ");
INSERT INTO tcs_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Da Parasi bin stanap wansaid ane em bin prea, “Ai eso yu God ai no wase ol dem nugudpipol. Ai no stilaman, ai no broke maretlo. Ai prapa glad ai no wase dis taksman ya. ");
INSERT INTO tcs_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Po tu dei ebri wik, ai no kaikai po wosip God. Ai seremaut ebriting. Ai gibe wanten prom olgeda wok blo mi.” ");
INSERT INTO tcs_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","‘Bat da taksman bin stanap lelbet longwei. Em no bin luk go antap po eben wen em bin prea bikoz em bin sem. Em bin nadakain sore po ol dem nugudting wea em bin mekem. Em bin krai ane singaut, “Plizgar, pogibe mi. Ai nadakain nugudman.” ");
INSERT INTO tcs_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ai spik yupla nau, wen dis taksman bin go aus, em bin kam rait wea God, bat dat Parasi no bin kam rait wea God. Dempla uda meke demplaselp mobig, wel God i go daune dempla. Bat uda i daune demplaselp, God go kare dempla antap.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wantaim, ol pipol bin teke smolpikinini blo dempla kam po Zizas bikoz dempla bin wande Zizas po tase dem pikinini ane blese dempla. Bat wen dem klostuman bin luk ol dem pikinini, dempla bin spik, ‘No. Yupla no lau po teke dem pikinini kam.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bat Zizas bin singaut po dem pikinini po kam klostu. Em bin spik, ‘Yupla no stap dempla prom kam po mi. Lete dempla kam bikoz God em i ruloba dempla. Dempla blo em. ");
INSERT INTO tcs_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ai spik trutok po yupla, enibodi uda nogad bilib wase smolpikinini ane no gri God em ruloba em, em no blo God.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Orait. Wan lida blo dem Zuwislotisa i bin aske Zizas, ‘Gudtisa. Wiswei ai go gede longlaip poeba?’ ");
INSERT INTO tcs_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Zizas bin ansa em, ‘Ei! Wanem po yu kole mi gud? Nobodi gud, mata God i gud. ");
INSERT INTO tcs_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yu sabe dem Mozeslo. Yu no broke maretlo, yu mas nogad at po kile man ane yu no stil tu. Yu no spik laitok baut enibodi o eniting. Yu mas ona papa ane mama blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Bat dis lida bin spik, ‘Ai bin obei ane pole ol dem Mozeslo prom wen ai bin smolboi.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","So wen Zizas bin lisen diswan, em bin spik baik po em, ‘Wan mo ting yu mas mekem. Sele ebriting blo yu ane seremaute ol mani blo yu po ol dem poapipol, den yu kam ane pole mi. Den yu go gede plenti gudting wea eben.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wen dis lida bin lisen wanem Zizas i bin spik em po mekem, em bin nadakain sore bikoz em bin prapa risman. ");
INSERT INTO tcs_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Wen Zizas bin luk po da man em bin tok po em, ‘Wa! I prapa ad po dem rispipol po go insaid dat niuples wea God go ruloba ebriwan. ");
INSERT INTO tcs_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Wa! I moizi po weil po go insaid aus blo kreipis den po rispipol po go insaid dat niuples wea God i go ruloba ebriwan, anles dempla seinze laip blo dempla ane seremaut wanem ol gad.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Dempla uda bin lisen wanem Zizas bin spik i bin aske em, ‘Ei! Wiswei? Ip i diskain ad po go eben, wel uda den gobi seib?’ ");
INSERT INTO tcs_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Zizas bin ansa em baigen, ‘Ol demting pipol kan mekem, bat God ken mekem. God ken meke ebriting.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Den Pita bin spik, ‘Mipla bin libe ebriting po pole yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Zizas bin ansa dempla, ‘Ai spik yupla trutok. Enibodi uda bin libe aus blo em o oman blo em, ane bin libe bala blo em o papa ane mama blo em o pikinini blo em, ane meke God ruloba laip blo em, ");
INSERT INTO tcs_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","wel, God i go gibe em plenti mo wea dis laip ane em go gede longlaip poeba wea eben.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nau Zizas i bin teke dem tuelb klostuman blo em go wansaid ane em bin spik po dempla, ‘Nau yumpla go go po Zarusalem. Ebriting wanem dem longtaim spesilmesizman blo God bin raitem baut mi, da Truwan blo Man go kam tru nau. ");
INSERT INTO tcs_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Da mesiz i diswan, dempla go gibe mi po dem lida blo Rom wea Zarusalem ane dem Rom man de go meke pan ane moke mi, daune mi ane spet wea pes blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Dempla go ploke mi wea wip ane kile mi. Bat wea namba tri dei ai go gedap gen laipwan.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Bat dem klostuman blo Zizas no bin sabe eniting wanem em bin tokbaut. Dempla no bin kese da mining wanem em bin spik. ");
INSERT INTO tcs_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nau Zizas bin kam klostu po Zeriko. Wan blain begaman bin sidaun wea said blo da rod. ");
INSERT INTO tcs_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wen em bin lisen da bigmob pipol bin kamdaun wea da rod klostu po em, em bin aske dempla, ‘Ei! Wanem i apen ya?’ ");
INSERT INTO tcs_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Dempla spik po em, ‘Diswan Zizas blo Nazaret ya pas go.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","So em bin singaut laudwan, ‘Ei, Zizas! Yu Promiswan wase King Deibid. Plizgar soe sorewei po mi ane elpe mi!’ ");
INSERT INTO tcs_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ol pipol de prant wea dat bigmob bin graul em, ‘Sadap yu! Stap kuaiat!’ Bat em no bin lisen. Em bin singaut molaud, ‘Ei, Zizas! Yu Promiswan wase King Deibid. Plizgar soe sorewei po mi ane elpe mi!’ ");
INSERT INTO tcs_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","So Zizas bin stap ane em bin oda dempla po teke dat blainman kam po em. Wen em bin kam klostu po Zizas, Zizas bin aske em, ");
INSERT INTO tcs_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","‘Wiswei? Wanem yu wande mi po mekem?’ Da blainman bin spik, ‘BosLod, ai wande yu po meke ai blo mi kamgudgen.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Zizas bin ansa em, ‘Yu ken luk nau. Bilib blo yu bin meke yu kam orait.’ ");
INSERT INTO tcs_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Stretwei em ken lukgen ane em bin pole Zizas ane stat preize God. Ol dem pipol uda bin luk disting wanem i bin apen, ol bin preize God tu. ");
INSERT INTO tcs_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Go nau. Zizas i bin kamdaun po Zeriko po go tru po Zarusalem. ");
INSERT INTO tcs_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Wan man de em bin gad plenti mani. Neim blo da man, Zakias. Em i bos blo dem taksman de wea Zeriko. ");
INSERT INTO tcs_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Zakias bin wande luk Zizas po paindaut wiskain man em. Em prapa sot man, so em kan luk Zizas. Plenti man i bin kam po luk Zizas tu. ");
INSERT INTO tcs_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Orait. Em bin ran go prant, lelbet longwei prom da mob ane em bin klaimap antap wea pigtri po luk Zizas. Em sabe Zizas i go pas andanit wea dat rod. ");
INSERT INTO tcs_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wen Zizas i bin kam po dat ples, em bin luk go antap po Zakias. Zizas spik po em, ‘Zakias, kuik kamdaun. Tidei ai mas stap wea aus blo yu.’ ");
INSERT INTO tcs_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Stretwei Zakias bin kamdaun ane em bin prapa glad po teke Zizas go po aus blo em. ");
INSERT INTO tcs_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wen dem pipol uda bin luk disting, ol bin stat smolsmoltok. Ol bin spik, ‘Luk kai. Dis man i go po stap wea aus blo nugudpasin man.’ ");
INSERT INTO tcs_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakias bin stanap ane em bin spik po BosLod, ‘Lisen Bos! Ai go gibe ap dem ris blo mi po dem pipol wea i nogad, ane ai go kipe ap po mi. Ip ai bin robe eni man ai go gibe em baik, po taim mo.’ ");
INSERT INTO tcs_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Zizas i spik po dempla de, ‘Dis man ya em Zuwisman tu. Em kam prom pamlelain blo Eibram. Tidei, ol pipol blo dis aus i seib ");
INSERT INTO tcs_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","bikoz ai da Truwan blo Man, ai bin kam po lukraun ane seibe ol dem pipol uda no sabe wiswei po go.’ ");
INSERT INTO tcs_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Dem pipol de wea aus blo Zakias bin prapa tekenotis wanem Zizas bin spik. Zizas bin de wea Zeriko, wan biliz klostu po Zarusalem ane dem pipol bin gad strongpiling, enitaim nau dempla go luk dat niuples wea God go ruloba ebriwan. Bikoz dempla bin gad dis aidia, Zizas i bin yan dis stori wea i gad mining. ");
INSERT INTO tcs_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Em bin yan diskain ya, ‘Wantaim de, i bin gad bigman ane em mas go prapa longwei po da siti blo Rom ane da bigking blo Rom go meke em king. Den em go kambaik po kantri blo em wea em gobi king. ");
INSERT INTO tcs_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Orait. Bipo em bin go, em bin singaut ten wokman blo em. Em bin tok po dempla wanwan. Em spik diskain po da pas wokman, “Ai go nau po Rom. Ai go gibe yu wan gold koin. Yu mas wok po meke plenti mani so wen ai go kambaik yu go gad plenti mani po gibe mi baigen.” Da bigman i bin tok diskain po ol dem ten wokman blo em. Den em bin tekop go. ");
INSERT INTO tcs_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bat dem pipol blo em, ol bin prapa eite em ane dempla bin sane ol mesinza go biain po spik da bigking wea Rom diskain, “Mipla no wande dis man po king blo mipla.” ");
INSERT INTO tcs_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","‘Apta nau, em i bin kambaik prom dat ples wea dempla bin meke em king. Em bin oda ol dem wokman blo em uda bin gede gold koin po teke da mani kam po em. Em i bin wande dempla po spik em aumas mani dempla bin mekem. ");
INSERT INTO tcs_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Dat pas wokman i bin spik po em, “Bos, ai bin meke ten taim mo wea dat wan koin wea yu bin gibe mi.” ");
INSERT INTO tcs_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Da king bin spik po em baigen, “Das gud. Yu bin meke gudwok po mi. Bikoz ai ken trase yu wea dat lelbet mani ai bin gibe yu, nau ai go meke yu lida blo ten taun.” ");
INSERT INTO tcs_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","‘Da sekanwan i bin kam. Em spik, “Bos, ai bin meke paib taim mo wea dat wan koin wea yu bin gibe mi.” ");
INSERT INTO tcs_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Da king bin spik po em, “Ai go meke yu lida blo paib taun.” ");
INSERT INTO tcs_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","‘Da namba tri wokman bin kam ane spik po em, “Bos, da mani wea yu bin gibe mi, ai bin rapem wea kaliko ane ai bin aide em. ");
INSERT INTO tcs_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ai bin nadakain prait prom yu bikoz yu prapa adman. Yu teke mani wea yu no bin wok po, ane yu teke kaikai wea yu no bin plantem.” ");
INSERT INTO tcs_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Dat king bin spik po em, “Yu nugud wokman. Ai go trite yu diskain wase yu bin spikbaut mi. Yu spik ai adman ane ai teke mani wea ai no bin wok po ane ai teke kaikai wea ai no bin plantem.” ");
INSERT INTO tcs_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","So nau da king bin spik po em, “Ei. Wasmara yu no bin pute da mani wea baingk po mekem po gro so wen ai bin kambaik da mani i bin gro mo?” ");
INSERT INTO tcs_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","‘Da king bin gibe oda nau po dem nadalot uda bin stanap de, “Teke dat mani prom em ane gibem po dat nada wokman uda bin meke ten taim mo mani.” ");
INSERT INTO tcs_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Dempla bin spik baigen, “Bat Bos, em olredi gad ten taim mo plenti!” ");
INSERT INTO tcs_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Den da king bin ansa dempla, “Ai spik yupla ya. Dempla uda gad samting ane ol yuzem gudwei, wel dempla go gede mo prom mi. Bat dempla uda yuzem nugudwei, iben ip dempla gad lelbet, ai stil go tekem prom dempla. ");
INSERT INTO tcs_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ol dem enami blo mi uda no bin wande mi po king blo dempla, teke dempla kam ya ane kile dempla prant wea mi.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wen Zizas bin pinis dis tok, em bin libe dat ples ane em bin kip wagbaut go po Zarusalem. ");
INSERT INTO tcs_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Orait. Wen em bin kam longsaid Maunt Olibtri, klostu po demtu biliz, Betpas ane Betani, em bin sane tu klostuman go pas. ");
INSERT INTO tcs_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Em bin spik po demtu bipo demtu bin go, ‘Yutu go paine wan yang dongki. No man i bin sidaun wea baik blo em bipo. Yutu tekemaut rop prom dat dongki. ");
INSERT INTO tcs_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ip da bos go aske yutu, “Ei! Wanem yutu mekem?” yutu spik po em diskain, “Bos, da BosLod blo mitu wande dis dongki.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Demtu bin go ane demtu paine ebriting wiskain Zizas i bin spik. ");
INSERT INTO tcs_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","So demtu bin tekemaut da rop prom da dongki po teke em go wea demtu. Bat bos blo da dongki bin singaut, ‘Ei! Wea yutu go wea da dongki? Wanem yutu mekem wea da dongki?’ ");
INSERT INTO tcs_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Demtu bin ansa po em gobaik, ‘Da BosLod wande em.’ ");
INSERT INTO tcs_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","So em bin spik, ‘Orait.’ Den demtu bin teke da smoldongki go po Zizas. Apta nau, demtu sake ol klos blo demtu antap wea baik blo dongki den demtu bin elpe Zizas po sidaun antap. ");
INSERT INTO tcs_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Orait. Zizas bin raide da dongki go wea da rod ane ol pipol bin sprede ol klos blo dempla wea da rod. ");
INSERT INTO tcs_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Den Zizas bin kam klostu po Zarusalem, da ples wea da rod godaun klostu po Maunt Olibtri. Prapa plenti klostuman blo Zizas i bin kam. Ol bin prapa glad. Ol bin eso God ane preiz em nadakain wea laud sing. Dempla bin mekem diskain po ol dem mirikalting dempla bin luk wanem i bin apen. ");
INSERT INTO tcs_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Dempla bin sing dis sing: ‘Blese dis Promiswan ya, uda kam wea da neim blo da AntapGod!’ ‘God go meke pis ya nau wea yumpla! Mipla prapa kare neim blo God antap uda stap wea eben!’ ");
INSERT INTO tcs_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Den sam dem Parasi bin graule Zizas. Dempla bin spik, ‘Ei yu de! Yu spik klostuman blo yu, dempla mas sadap!’ ");
INSERT INTO tcs_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Zizas bin spik gobaigen po dempla, ‘Ei, ai spik yupla stret. Ip ol dem pipol go stap kuaiat den ol dem ston ya i go stat po singaut preiz.’ ");
INSERT INTO tcs_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wen Zizas bin kam klostu po Zarusalem, em bin luk dat taun ane em bin mata krai po da taun. Den em bin spik, ");
INSERT INTO tcs_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","‘Yagar, ai sore po yupla bikoz yupla no sabe wiswei yupla ken gede pis. Yupla bin dat blain po luk dat pis yupla ken gedem. Dat pis ya nau. ");
INSERT INTO tcs_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Zarusalem, taim go kam wen ol enami blo yupla go bilde wol raitraun wea yupla ane atak yupla prom ebriwea. ");
INSERT INTO tcs_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Zarusalem, dempla go kam po smase yu, meke yu lebel wea graun ane kile ol dem pipol uda stap ya wea yu. Dempla nogo libe iben tu ston antap wananada. Ebriting go smas ane plat andanit wea graun. Ol demting i go apen bikoz God bin kam po seibe yupla ane yupla no bin tekenotis.’ ");
INSERT INTO tcs_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nau wen Zizas bin go po da Tempol blo God, em bin stat po sesewei dem pipol uda bin sele olkainting de wea aus blo God. ");
INSERT INTO tcs_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Em bin spik dempla diskain, ‘God i spik wea Baibol, “Aus blo mi i ples blo wosip ane prea. Bat yupla bin meke dis aus blo God wase ples blo ol stilaman.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nau ebridei Zizas bin lane dempla wea da Tempol blo God. Ol dem edprist, dem Zuwislotisa ane sam lida blo dem pipol bin wande kile Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Bat dempla no bin sabe wiswei dempla go paine wei po kile em bikoz ebriwan bin de ol dei wea Zizas, po lisen po em. Dempla no bin wande mise eniting wanem em bin lane dempla. ");
INSERT INTO tcs_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wandei nau wen Zizas i bin de wea da Tempol blo God, em bin tise dem pipol ane em bin spik da Gudniuz blo God. Ol dem edprist ane Zuwislotisa ane dem Zuwiselda bin kam po tok wea em. ");
INSERT INTO tcs_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Dempla bin aske Zizas, ‘Yu spik mipla wanem rait yu gad po kare lo po meke ol demting?’ ");
INSERT INTO tcs_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Zizas bin ansa dempla, ‘Lete mi aske yupla kuestin. Yupla spik po mi nau. ");
INSERT INTO tcs_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wen Zon bin baptaiz ol dem pipol, wanem rait em bin gad? I bin kam prom God o i bin kam prom man?’ ");
INSERT INTO tcs_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Dempla bin tok po demplaselp, ‘Wiskain yumpla go ansa em baik? Ip yumpla go spik, “God i bin sane Zon”, den em go spik baigen po yumpla, “Wel ip God bin sane Zon den aukam yupla no bilibe mi?” ");
INSERT INTO tcs_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Bat ip yumpla go spik, “Diswan no blo God, i blo man”, ol dem bigmob pipol ya go kile yumpla wea ston. Dem pipol bin bilib Zon em i spesilmesizman blo God.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","So dempla bin ansa Zizas diskain, ‘Mipla no sabe. Mipla no sabe uda bin gibe Zon da rait po baptaiz dem pipol.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","So nau Zizas bin ansa dempla baigen, ‘Wel ai nogo spik yupla uda bin gibe mi rait po kare lo po meke demting.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Den Zizas bin yan nada stori wea i gad mining, ‘Wan man bin plante gadan blo greipbain, ane em bin gibem po sam man po rentem. Den em bin gowei po longtaim po nada kantri. ");
INSERT INTO tcs_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Den da taim bin kam po broke ol dem greip po selem. Da ouna blo da gadan blo greipbain bin sane wan wokman blo em po dem pipol uda bin rente dat gadan. Em bin sane em go po gede da rentmani prom da sea blo dat greip mani. Bat dem man bin ploke dat wokman ane sane em gobaigen, nogad nating. ");
INSERT INTO tcs_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","So em bin sane nada wokman blo em go. Bat dempla bin meke da seimting, dempla bin ploke em tu. Dempla bin trite em nugud ane sane em gobaigen, nogad nating. ");
INSERT INTO tcs_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","So apta datwan, dat ouna blo da gadan bin sane namba tri wokman go nau, ane dempla uda rente da gadan bin meke da seimting gen. Dempla bin ploke em mobad ane sakwei em ausaid prom dat gadan. ");
INSERT INTO tcs_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‘Da ouna blo da gadan bin tingk, “Wiswei ai go mekem?” Den em bin gede aidia, “Ei weitpas! Ai sabe. Ai go sane boi blo mi uda ai prapa lab. Maitbi dempla go soe rispekt po em.” ");
INSERT INTO tcs_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","‘Bat nau, dem man uda bin rente da gadan, wen ol bin luk da boi blo da ouna, dempla bin tok po demplaselp, “Ei, diswan da bigboi blo da ouna. Em go gede dis propati wen papa blo em go ded. Ip yumpla kile em, wel dat propati i gobi blo yumpla.” ");
INSERT INTO tcs_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","So dempla bin sakem ausaid prom da gadan den dempla bin kile em. Zizas bin kip spik, ‘Wanem dat ouna blo da gadan go mekem po dempla? ");
INSERT INTO tcs_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Em go kambaigen ane kile dem man ane gibe dat gadan po ol nada pipol.’ Wen ol dem pipol bin lisen dis stori, dempla bin singaut, ‘Nono! Diswan kan apen.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bat Zizas bin luk stret po dempla, ‘Orait. So wanem da mining blo dis tok i bin raitem wea Baibol? “Diswan da timba wanem ol dem kapenta no bin wandem, bat nau em da meintimba po olde da rup po meke da rup strong.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Zizas bin spik, ‘Ol dem pipol uda poldaun wea dat timba, bodi blo dempla i go brok. Ane ip dat timba go poldaun antap eniwan, da timba go smase dempla.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Dem Zuwislotisa ane dem edprist ol bin stretwei wande kese Zizas bikoz dempla bin sabe Zizas bin tok gense dempla. Bat dempla bin prait prom ol dem pipol de. ");
INSERT INTO tcs_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Dempla bin weit ane wase Zizas prapa klostu po kese em. So dempla bin sane spai. Dem spai bin trai po blape em dat dempla ol gudpipol. Dempla bin aske em kuestin so dempla ken kese em ip em spik rongting. Ip dempla go kese em spik rongting, den dempla ken andemoba po da Rom gabana po panse em. ");
INSERT INTO tcs_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","So dem spai bin aske Zizas diskain, ‘Tisa. Mipla sabe yu tise mipla da truwei baut wanem God i wande ol dem pipol po mekem. Yu trite ebriwan wea seim rispekt nomata uda. ");
INSERT INTO tcs_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nau, yu spik mipla wiswei, ip i rait po pei taksmani po da bigking blo Rom o no?’ ");
INSERT INTO tcs_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bat Zizas bin sabe dempla trai po trike em. Em bin ansa dempla baigen, ");
INSERT INTO tcs_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","‘Soe mi wan silba koin. Uda ed ane neim i stap wea dis koin?’ ");
INSERT INTO tcs_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Dempla bin ansa em, ‘Da bigking blo Rom.’ Den Zizas bin spik po dempla, ‘Gibe da king, wanem blo em, ane gibe God wanem blo em.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ol dem ansa blo Zizas bin meke dempla prapa pazol, so ol bin mata sadap. Dempla kan meke em spik ol rongting prant wea dem pipol. ");
INSERT INTO tcs_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Sam Zuwislotisa uda bin kole demplaselp Sadusi, ol i bin kam po Zizas. Dempla no bilib God go meke ol ded pipol kamlaipgen. ");
INSERT INTO tcs_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Dempla bin aske Zizas, ‘Tisa, Mozes bin raitem diskain wea lo blo em. Ip wan bala i ded ane em libe oman blo em nogad pikinini, dat nada bala blo em mas maret dat widooman blo em. Dem pikinini uda gobi bon prom dat widooman, gobi pikinini blo dat ded bala. ");
INSERT INTO tcs_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wantaim i bin gad seben bala. Da paswan i bin maret ane em bin ded, nogad pikinini. ");
INSERT INTO tcs_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nau da sekan bala, em bin maret da widooman blo da bigbala blo em nau. Den em bin ded tu, nogad pikinini. ");
INSERT INTO tcs_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Da seimting i bin apen wea da namba tri bala, den i bin go raitap po da laswan, namba seben bala. Ebridem seben bala uda bin maret da widooman ol bin mata ded, nogad pikinini. ");
INSERT INTO tcs_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Apta nau da widooman i bin ded tu. ");
INSERT INTO tcs_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Tisa, yu spik mipla. Wiswei? Wen da dei go kam wen ol dem ded pipol uda i go kamlaipgen, em gobi oman blo uda? Ebridem seben bala ol bin maret wea em.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Zizas bin ansa dempla, ‘Pipol blo dis ert maret wananada nau. ");
INSERT INTO tcs_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bat wen ebribodi go kambaigen laipwan, dempla uda go gede dat gud niulaip nogo maret. ");
INSERT INTO tcs_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Dempla kan ded nomo. Dempla seimkain wase einzel. Dempla gobi pikinini blo God, dem pikinini uda bin gedap laipwan prom ded. ");
INSERT INTO tcs_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","‘Mozes bin raitem wea Baibol wan stori wea da bus i bin ban. De, God bin spik po Mozes diskain, “Ai da LodGod, God blo Eibram, Aizak ane Zekop.” ");
INSERT INTO tcs_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Em da God blo ol laip pipol. Em no God blo ol dem dedwan. Ol dem pipol uda God bin kolem, dempla gad laip, longlaip poeba.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Sam Zuwislotisa bin spik, ‘Tisa, i gud wanem yu bin spik.’ ");
INSERT INTO tcs_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Prom dat taim nau dempla bin prait po aske Zizas mo kuestin. ");
INSERT INTO tcs_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","So den Zizas bin aske dempla kuestin diskain ya, ‘Wanem po ol pipol i spik dat da Promiswan, da wan uda seib, em i da Boi blo King Deibid a? ");
INSERT INTO tcs_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yu sabe Deibid bin spik wea da Buk blo Saam: “Da AntapGod bin spik po da BosLod blo mi, Sidaun ya wea raitansaid blo mi, da ples blo ona ");
INSERT INTO tcs_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","antil ai go bite enami blo yu, ane meke dempla leidaun plat prant wea put blo yu.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","‘Ip King Deibid bin kole da Promiswan uda God i sanem kam, BosLod, den auken da Promiswan bi boi blo em? Nono, i kan!’ ");
INSERT INTO tcs_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wail ebribodi i bin de lisen po Zizas, em bin spik po ol dem klostuman blo em, ");
INSERT INTO tcs_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","‘Lugaut prom dem Zuwislotisa. Dempla laik po were ol dem long plasklos wase prist po stail. Dempla prapa laik wen ol pipol grite dempla wea rispekt prant wea ebribodi. Dempla wande ol dem spesil sit blo ona wea zuwispreaus, ane dem sit blo ona wea pisting. ");
INSERT INTO tcs_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Dempla Zuwislotisa trike dem widooman po gibe aus blo dempla ane ebriting blo dem widooman. Den dem Zuwislotisa i meke long prea wea zuwispreaus po kabarap da rongting dempla i bin mekem. Dempla blape ol pipol dat dempla meke raitting. Dempla go gede mina mobig panisment den enibodi.’ ");
INSERT INTO tcs_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Zizas bin mata wase ol dem rispipol uda bin pute mani wea koleksinboks lo da Tempol blo God. ");
INSERT INTO tcs_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Den em bin luk wan widooman, nogad mas mani. Da widooman bin pute tu smol kopa koin insaid dat boks. ");
INSERT INTO tcs_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Zizas bin spik, ‘Ai spik trutok po yupla, dis widooman uda nogad mas mani, em bin gibe moden ol dem rispipol bikoz em bin gibe ebriting em gad. ");
INSERT INTO tcs_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Iben dem rispipol ya bin gibe mani bikoz dempla gad prapa tumas mani wea ol i no nidem. Bat dis oman ya, em prapa poa. Em bin gibe ebri mani blo em wanem em gad ane em nogad nating lept.’ ");
INSERT INTO tcs_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Wantaim nau sam pipol bin tokbaut da Tempol blo God. Dempla bin tokbaut ol dem plas ston dempla bin yuzem po bilde da Tempol ane ol dem plas dekoreisan dem pipol bin gibe God po meke da Tempol luk gud. ");
INSERT INTO tcs_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Bat Zizas em bin spik po dempla, ‘Ol demting yupla luk ya nau gobi nating. Dat taim i go kam wen dis Tempol go brok daun plat, lebel wea graun. No iben wan ston go stap antap wea nada ston.’ ");
INSERT INTO tcs_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sam pipol i bin aske Zizas, ‘Tisa, wanem taim demting go apen? Wiskain gudsain mipla go luk so mipla go sabe dat demting i go apen?’ ");
INSERT INTO tcs_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Zizas bin eksplein po dempla, ‘Yupla mas lugaut, bikoz taim i go kam wen i go gad olkain dipren man uda go trai po blape yupla diskain, “Yupla luk po da Promiswan uda God i go sanem a? Wa, diswan i mi.” Ip enibodi spik yupla diskain, yupla no lisen, no pole dempla. ");
INSERT INTO tcs_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yupla no prait ip yupla go lisenbaut woa ane prapa bigmob pipol i meke trabol, bikoz ebri demting mas apen pas. Bat dat taim i nogo pinis yet.’ ");
INSERT INTO tcs_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Zizas bin kip spik po dempla, ‘Ol neisin go paite wananada ane ol kantri gobi gense wananada. ");
INSERT INTO tcs_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Olkain dipren ples go gad nadakain big ertseik. Plenti pipol i go ded prom anggre ane ol go gede olkain nugud sik. I go gad olkain prapa streinzting i go apen wea skai. Ebribodi gobi nadakain prait prom demting. ");
INSERT INTO tcs_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‘Bat bipo demting i go apen, plenti pipol go trite yupla prapa nugudwei. Dempla go teke yupla po kot wea zuwispreaus ane pute yupla wea zeilaus. Bikoz yupla pole mi, dempla go teke yupla po kot, prant wea dem king ane dem gabana tu. ");
INSERT INTO tcs_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","De lo kotaus yupla ken gede sans po spik dempla ebriting wanem yupla bilib baut mi. ");
INSERT INTO tcs_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Yupla no wori bipo dat taim wanem yupla go ansa po demting ol go spik gense yupla. ");
INSERT INTO tcs_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ai go gibe yupla sabe po ansa dempla so ol dem enami kan stanap gense yupla ane prube yupla rong. ");
INSERT INTO tcs_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Iben papa ane mama blo yupla ane bala ane pamle ane pren blo yupla, ol go gense yupla ane meke ol nugudting po yupla. Sam yupla go ded ane dem lida go kile yupla. ");
INSERT INTO tcs_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ebribodi go eite yupla bikoz yupla pole mi ane yupla blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bat yupla no wori. Nobodi ken meke nugudting po yupla. ");
INSERT INTO tcs_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ip yupla mata gad bilib wea mi, yupla go gad trulaip.’ ");
INSERT INTO tcs_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Zizas bin kip spik, ‘Da taim wen yupla go luk ol amiman go meke kemp raitraun Zarusalem, yupla go sabe da taim i kam klostu nau wen Zarusalem i go pinis olgeda. ");
INSERT INTO tcs_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Yupla uda de wea Zudia, yupla mas ranwei go po dem maunten. Yupla uda stap wea Zarusalem, yupla mas stretwei ranwei prom de. Dempla uda stap ausaid prom taun, ol mas nogo insaid da taun po luk po seip ples po aid. ");
INSERT INTO tcs_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Diswan gobi taim blo panisment wanem God bin wone pipol blo em. Diskain em bin raitem wea Baibol. ");
INSERT INTO tcs_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ol dem oman uda pamle, uda gibe susu, dat taim i gobi da nadakain nugudtaim po dempla. Ebriwei wea dat kantri pipol go sapa olkain prapa nugudtrabol prom dat panisment. ");
INSERT INTO tcs_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dem amiman go kile dempla wea sod. Ol nada enami go teke dempla po prizina go po olkain dipren kantri. Ol dem enami neisin go smase Zarusalem. Dem enami go mata meke diskain de antil dat taim wen God go spik po dempla, “Nomo nau, i pinis.” ’ ");
INSERT INTO tcs_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Zizas i bin kip spik, ‘Olkain streinzting go apen wea da san ane mun ane ol dem sta. Ol dem neisin blo da ert go prait prom big weibnoiz ane bigtaid. Ol nogo sabe wanem po mekem. ");
INSERT INTO tcs_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ol dem pipol ol go prapa nadakain prait prom wanem i go apen wea dis ert. Ebriting wea da skai go prapa seik ane ol demting wea skai go kamaut prom ples blo dempla. ");
INSERT INTO tcs_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Wea da seimtaim, ol go luk mi, da Truwan blo Man go kam wea klaud wea paua ane sainilait, dat Truglori blo mi. ");
INSERT INTO tcs_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wen demting go stat po apen, yupla mas stanap strong ane luk go antap, bikoz da taim i kam prapa klostu nau wen God go seibe yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Apta nau, Zizas bin yan dempla wan stori wea i gad mining, ‘Wen da taim yupla luk da pigtri ane ol nada tri ");
INSERT INTO tcs_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","sake niu lip, yupla sabe i kam po kukitaim. ");
INSERT INTO tcs_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","So wen yupla luk ol demting apen, yupla sabe da taim i kam klostu wen God go ruloba ebriwan. ");
INSERT INTO tcs_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ai spik trutok po yupla, dem pipol uda i laip tidei ol gobi stil ya antil ol demting i go apen. ");
INSERT INTO tcs_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Eben ane ert go pinis olgeda, bat dem tok wea ai spik i neba go ded, i go stap poeba. ");
INSERT INTO tcs_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‘Yupla mas lugaut. Yupla no pole laip blo dis ert, wase tumas kaikai, tumas dringk ane woribaut demting blo dis laip. Bambai wen ai go kambaigen, ai go paine yupla apwei. ");
INSERT INTO tcs_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Dat dei go sapraiz ebribodi ya wea dis ert. Dat lasdei i go kam kese yupla ya, wase kasnet oba yupla. ");
INSERT INTO tcs_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yupla lugaut ane kip prea po God po gibe yupla strong, sole yupla ken kipgo tru ol demting wanem i go apen. So apta demting, yupla ken stanap stret, prant wea mi, da Truwan blo Man.’ ");
INSERT INTO tcs_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ebridei Zizas i bin tise dempla de wea da Tempol blo God ane ebrinait em bin go ausaid prom Zarusalem ane em bin de wea Maunt Olibtri. ");
INSERT INTO tcs_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ebribodi i bin gedap prapa eli po go po da Tempol blo God po lisen Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Orait. Da taim i bin kam klostu po da Pestabol blo da Platbred i nogad yis. Nada neim blo da pestabol i Pasoba Pestabol. ");
INSERT INTO tcs_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ol dem edprist ane ol dem Zuwislotisa bin wande kile Zizas, bat dempla bin prait prom dem pipol bikoz ol dem pipol bin prapa laik Zizas. So dempla bin trai po paine wei, sikretwei po kile Zizas. ");
INSERT INTO tcs_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Orait. Satana, em bin go insaid wan dem tuelb klostuman blo Zizas. Neim blo dat man, Zudas Iskara. ");
INSERT INTO tcs_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","So Zudas em bin tekop go po luk ol dem edprist ane sam dem gad blo da Tempol blo God. Wen em bin pinis paine dempla, Zudas bin spik diskain po dempla, ‘Ai ken elpe yupla po kese Zizas.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Dempla bin nadakain api ane ol bin gri po pei em mani. ");
INSERT INTO tcs_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Zudas em i gri ane prom dat taim em bin stat lukraun po wei po sele Zizas go po enami blo em. Em bin luk po sikretwei sole ol pipol nogo sabe. ");
INSERT INTO tcs_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nau i bin da taim wea da Pasoba, blo da Pestabol blo da Platbred wea i nogad yis. Dat dei i bin kam po sakripais dem Pasoba smolsip, wan prom ebri pamle. ");
INSERT INTO tcs_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Zizas bin sane Pita ane Zon go. Em bin spik po demtu diskain, ‘Yutu go ane meke ebriting redi po yumpla po kaikai da Pasoba Pisting.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Demtu Pita ane Zon bin aske em, ‘Wea yu wande mitu go po meke redi?’ ");
INSERT INTO tcs_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Zizas ansa demtu, ‘Yutu go insaid po Zarusalem ane yu go luk wan man em i kare big baket blo wata. Em go mite yutu de ane yutu mas pole em. Ane da aus wea em go go, ");
INSERT INTO tcs_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","yutu spik po da man blo dat aus diskain, “Tisa blo mipla bin spik, yu go soe mitu da ples wea mipla mas meke redi po da Pasoba Pisting.” ");
INSERT INTO tcs_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Em go soe yutu da big rum wea i stap antap. Em i gad teibol ane ol samting blo sidaun. Yutu meke ebriting redi de.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wen demtu bin go, demtu bin paindaut ebriting seimkain wase Zizas i bin spik. So demtu bin meke Pasoba kaikai redi de. ");
INSERT INTO tcs_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Orait. Da taim i bin kam po kaikai. Zizas ane dem misnareman blo em bin sidaun redi po da Pasoba kaikai. ");
INSERT INTO tcs_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Zizas bin spik dempla diskain, ‘Ai prapa wande kaikai wea yupla bipo ai go ded. ");
INSERT INTO tcs_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ai go spik yupla, ai nomo go kaikai dis kaikai ya wea ert. Apta wen ebriting go pinis apen ane God em i go ruloba ebriwan, den ai go kaikai gen wea yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Orait. Zizas bin teke kap blo wain ane em bin eso God. Em spik, ‘Yupla dringk nau ane pasem goraun. ");
INSERT INTO tcs_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ai nomo go dringk wain gen wea ert. Ai go dringk wain gen wen ai go kambaigen king blo ebriwan.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nau Zizas bin teke bred ane em bin eso God, broke da bred ane gibe dempla. Em bin spik, ‘Diswan bodi blo mi, ai gibe yupla. Yupla mas mata meke disting sole yupla go tingbaut wanem ai bin mekem po yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Seimwei, apta dempla bin pinis kaikai, em bin teke da kap blo wain ane em bin spik, ‘Ai gibe yupla dis kap po dringk. Dis kap blo wain i gobi da niu strong griment wea God ane yupla. Diswan i griment wea blad blo mi. Wen blad blo mi i go kapsaid, i gobi da sakripais po yupla. ");
INSERT INTO tcs_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‘Bat lugaut nau. I gad wan man ya wea teibol. Em go sele mi. ");
INSERT INTO tcs_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ai spik yupla, God bin pinis spik, ai da Truwan blo Man go ded. Bat dis man uda go gibe mi po ol enami blo mi, ai wone em, em mas lugaut. Em go gad prapa adtaim.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ol dem klostuman bin tok po demplaselp, ‘Uda prom yumpla go meke dis nugudting po em?’ ");
INSERT INTO tcs_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Orait. Big rau bin stat wea dempla. Wan prom dempla bin spik, ‘Ai bos blo yupla.’ Nadawan spik, ‘Nono! Ai bos blo yupla.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Zizas bin lisen da agiu ane em bin spik, ‘Dem edman blo dis ert uda no sabe God, bin yuze paua blo dempla rongwei. Dempla uda meke demplaselp lida blo ebriwan, dempla meke demplaselp wase pren blo ebriwan. ");
INSERT INTO tcs_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bat yupla no mekem diskain. Da bigwan mas bi wase da louwan. Da edman mas bi wase da wokman. ");
INSERT INTO tcs_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Uda mobig? Da man uda sidaun wea teibol, o da wokman uda gibe em kaikai? Yu sabe! Da man uda sidaun wea teibol. Bat ai ya nau po serbe yupla. Ai wokman blo yupla. ");
INSERT INTO tcs_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Wen ai bin wea trabol, yupla bin oltaim stanap po mi. ");
INSERT INTO tcs_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mai papa i bin gibe mi paua oba ebriting. Ane ai go gibe da seimting po yupla wase Papa blo mi i bin mekem. ");
INSERT INTO tcs_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yupla go kaikai ane dringk wea teibol blo mi de wea eben ane yupla go sidaun wea mi ane zaze ol dem tuelb pamle blo Izrael.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Apta nau, Zizas bin spik po Saiman. Nada neim blo em Pita. Em spik, ‘Saiman, Saiman, yu lisen po mi nau. God go lau Satana po teste yupla wase man i streine da sabi prom da nobi. ");
INSERT INTO tcs_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bat ai bin prea po yu dat yu go kip luk po mi. Yu go poldaun bat wen yu go tan kambaik, yu mas elpe ol met blo yu po trase God mo.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bat Pita bin tok baigen po em, ‘BosLod. Ai redi po go zeilaus wea yu. Ai redi po ded wea yu tu.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","So Zizas bin ansa em diskain, ‘Ai spik yu Pita, ai go spik yu disting. Dis nait bipo da rusta go singaut, yu go spik tri taim yu no sabe uda mi.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Orait. Zizas bin spik apta, ‘Yupla sabe dat taim wen ai bin sane yupla go? Yupla no bin kare mani o kaikai o were sandol. Wiswei? Yupla bin sot eniting?’ Dempla bin spik, ‘No, nating.’ ");
INSERT INTO tcs_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","So Zizas bin spik po dempla, ‘Bat wea distaim ya nau, ip yupla gad mani ane kaikai, tekem go wea yupla.