﻿USE sofia;
DROP TABLE IF EXISTS sofia.tcn_vpl;
CREATE TABLE tcn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tcn_vpl WRITE;
INSERT INTO tcn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ताङबो वचन होतो, वचन कजसुबा ङ्याबो होतो, तेहि वचन कजसुबा हिना, ");
INSERT INTO tcn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","खो ताङबो कजसुबा ङ्याबो होतो। ");
INSERT INTO tcn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","पार चानला होएता पोरो खोने स्यिसोङ, पार च्यानला होएता पोरो खो मेताला मासोइबालो। ");
INSERT INTO tcn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","हतिला मिजे होतो राङ, हति मिजेते मितेबे होए हिना ");
INSERT INTO tcn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","हति होएते मुन्नाला होए भारिनलो, राङ मुन्नायि हतिला जब याङ हा को माङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","कजसुबाने चाँचाँबि लोन खोरङान मिजि होतो, सुइ मिन युहान्ना हिना ");
INSERT INTO tcn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","हति हतिबे होएतेबे भारेला साछि तेरायापयि चाला साछि च्युङदे लेप्ते, कि मि पोरो ख्युइ चाने हिछे क्यायोङ। ");
INSERT INTO tcn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","खो राङ हति होए मानालो हिन्नाङ हति होएयि साछि तेरतु लेलेबालो ");
INSERT INTO tcn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","हति तेम्बा होए हिना। हति होए काङ संसारला हुन राङ मि पोरोला होए भारिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","खि संसारला धुलो, संसार खोने सोइरसोङ, हति हिन्नाङ संसारयि खोला ङोमास्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","खो खुरि मि तेहा लेप्सोङ, हिन्नाङ खुरि मितेबे खोला हिछे माक्याइसोङ ");
INSERT INTO tcn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","हिन्नाङ चोमयि खोला हिछे क्याइरे राङ ख्युइ मिनला हिछे क्याइरे, ख्युइ हतिबाला कजसुबे मि हिना नाङानयि आङ पिन्देलो। ");
INSERT INTO tcn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","हतिबा ठाने, स्हुयि धोप्पाने, राङ मि रेनयि धोप्पाने माना हिन्नाङ कजसुबाने क्येक्येबा हिना। ");
INSERT INTO tcn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","तेहि वचन स्हुला क्येसोङ, राङ ङाहि ङिङच्येने तेम्बि खारे हुइ उइला ते सोङ। हुइ ख्युइ छे तेतेका थोङसोङ, हति छेते काङ आकेने लेलेबि चिक्पा झि मात्रा पिजि धोला खुखुबा ध्हु। ");
INSERT INTO tcn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","युहान्नायि ख्युइ भारेला साछि तेरिन राङ क्ये छेया क्याइरे नाइसोङ, “को हति मि राङ ना, सुइ भारेला ङाहि नाइरे, ‘ङाहि च्येला होङान ङाले हाङ छेयाना चिचालानाना खो ङा कोयापयि ताङलाने होतो।’” ");
INSERT INTO tcn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ख्युइ ङाहि ङिङच्येने हुइ पोरो च्यिनलाब जि ने स्यान च्यिनलाब जि खुखुबा होतो। ");
INSERT INTO tcn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","चिचालानाना ठिम मोशाने पिपिना ना, ङिङच्येने राङ तेम्बाते येशु ख्रिष्टने लेलेबाना। ");
INSERT INTO tcn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","कजसुबाला सुइ याङ नामयाङ थोथोवा मेतालो। आके पाङला त्योएङान चिक्पा झि मात्रा पिजियि खोला ताताना हिना। ");
INSERT INTO tcn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","जब यरुश्लेमने यहुदि आङकिङानबे पुजारिबा राङ लेविबाला युहान्नायि तिया “ख्योए सुना” नाङयि ताम ढिरु चाँरेलो। तेहि युहान्नायि साछि धि ना। ");
INSERT INTO tcn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","युहान्नायि जवाक तेरयापला माना मानाइबा, हिन्नाङ चाङमा क्याइरे नाइरेलो, ङा ख्रिष्ट माना। ");
INSERT INTO tcn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","तेहि हतिबे ख्हेला टिसोङ, “तेहि च्हि ख्योए एलिया हिनाइ?” ख्युइ नाइरेलो “ङा अर्थात।” “च्हि ख्योए हति ङोन्सेखिलङान हिनाइ?” ख्युइ जवाक पिन्सोङ, “अर्थात।” ");
INSERT INTO tcn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","हतिबे खिला नाइसोङ, “ख्योए स्यु ना? ङेला नोइ, राङ ङेला चोँङानला ङाहि जवाक तेरयाप हो। ख्योए खुरि भारेला च्हि नाज्याइ?” ");
INSERT INTO tcn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","युहान्नायि जवाक पिन्देलो “यशैया ङोन्सेखिलङानयि नानाइबा च्वरा ‘कजसुबे लाम थारका सोइ’ नाङान सा थुवाला क्ये धोनङान मिझिकि क्येते ङ्याना।”* ");
INSERT INTO tcn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","हतिबाला फरिसिबे चाँचाँबा हिना। ");
INSERT INTO tcn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","तेहि हतिबे खोला टिसोङ “ख्योए ख्रिष्ट याङ मानाइ, एलिया याङ मानाइ, हति ङोन्सेखिलङान याङ अर्थात, चिचाला बप्तिसमा तेरिन?” ");
INSERT INTO tcn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","युहान्नायि हतिबाला जवाक पिन्देलो, “ङाता छ्युइ बप्तिसमा तेरिन हिन्नाङ खि उइला मिझि लाँरे तोकिन, सुला खि ङो मिस्येबा। ");
INSERT INTO tcn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ङाहि च्येला होङान खोराङन ना। ख्हुइ पोउलो यि ताना ढोलयापयि झ्योदायि मि ङा माना।” ");
INSERT INTO tcn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","धि ताम यर्दन च्याङभुइ फारकानला बेथानियाला च्युङदेलो, का युहान्नायि बप्तिसमा तेरिन ताता होतो। ");
INSERT INTO tcn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ङाहि टो तेला युहान्नायि येशु खो यहला होङान थोङसोङ नाइरेलो, “तेहि, संसारयि तिक्पा खुरते खेरङान कजसुबे लु! ");
INSERT INTO tcn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","हति खो राङना, स्यु भारेला ङाहि नानाइबा होतो, ‘ङाहि च्येला मिझि हुन, स्युरे ङाले छेया ना चिचालानाना खो ङा केयापले ताङला राङ होतो।’ ");
INSERT INTO tcn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ङा ङारि खोला ङो स्येस्येबा मेता हिन्नाङ खो इस्राएलि लेभोङ नाइरे राङ छ्युइ बप्तिसमा तेरिन राङ ङा लेप्ते।” ");
INSERT INTO tcn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","युहान्नायि जु नेन राङ साछि पिन्देलो, “ङाहि पवित्र आत्माला ङोम्मुइ धोला तेङला ने पुप्ते लेप्ते ख्युइ थोला पापते होङान थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ङाहि खोला ङो स्येस्येबा मेता हिन्नाङ सुइ ङाला छ्युइ बप्तिसमा पिन नाइरे चाँरे, ख्युइ राङ ङाला नाइसोङ, ‘सुइ थोला ख्युइ पवित्र आत्मा पुपङान राङ त्योएङान थोङान ना, पवित्र आत्मायि बप्तिस्मा तेरङान हति राङ ना’ ");
INSERT INTO tcn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ङाहि थोथोवा होतो, राङ साछि पिपिना होतो, कि कजसुबे पिजा खो राङ ना।” ");
INSERT INTO tcn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","याङ स्यान ङिनते युहान्ना खुरि लोब्टुबे नाङने ङाहि लोब्टुबा ङ्याबो लाँरे त्येतु। ");
INSERT INTO tcn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ख्युइ येशु ढुन ताताता थोङसोङ नाइरेलो, “तेहि, कजसुबे लु!” ");
INSERT INTO tcn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ङिकार लोब्टुयि ख्युइ धि नाङान थोइरे राङ येशु ङ्याबो पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","येशुयि लक्ते ताइरेलो, राङ हतिबा च्येच्येला होङान थोङसोङ हतिबाला टिरेलो, “खे च्हि फाकिन?” हतिबे खोला नाइरेलो, “रब्बि (काङयि तोन गुरुज्यु,) ख्योए का तोकिन?” ");
INSERT INTO tcn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ख्युइ हतिबाला नाइरेलो, “सअ, तेहि खि थोङान ना।” हतिबा पुइसोङ, तेहि खो त्योएसा थोङसोङ। हतिबा हति ङिन खो ङ्याबो त्येसोङ, चिचालानाना हा:लाम चार बजे च्युङ छारतुलो। ");
INSERT INTO tcn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","युहान्नायि नानाइबि ताम थोइरे राङ येशुयि च्येच्येला ढोङान ङाहियि नाङने च्यिते सिमोन पत्रुसयि भाइ अन्‍द्रियास हिना। ");
INSERT INTO tcn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ख्युइ ताङला खुरि भाइ सिमोनला ठातेलो, तेहि खोला नाइरेलो “ङाहि मसिहला तोन ना (ख्रिष्ट) ठातेलो। ");
INSERT INTO tcn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","हति सिमोनला येशुयि तेहा ख्योसोङ। येशुयि खोला ताइरे नाइसोङ, ख्योए युहान्नायि पिजा सिमोन हिनाइ, ख्योए केफास मदलब (काङयि खुँ पत्रुस च्वरा टा ना) नाङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ङाइटोतेला येशु गालिलला ढोयापयि थाकच्योए क्याइसोङ। राङ फिलिपला ठाते ख्युइ खोला नाइसोङ, “ङाहि च्येला सअ।” ");
INSERT INTO tcn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","अन्‍द्रियास राङ पत्रुस च्वरा फिलिप याङ बेथसेदा भजारयि हिना। ");
INSERT INTO tcn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","फिलिपयि नथानेलला ठाते नाइसोङ, “काङयि भारेला मोशायि ठिम राङ ङोन्सेखिलङानयि टिटिबा होतो, योसेफयि पिजा नासरातयि येशुला ङाहि ठाठाता होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","नथानेलयि हतिला टिसोङ, “च्हि नासरात ने ताम ल लेभोङ ङेला?” फिलिपयि खोला जवाक पिन्सोङ, “लेप्ते तेहि।” ");
INSERT INTO tcn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","येशुयि नथानेल खुरि तेहा होङान थोङसोङ ख्युइ भारेला नाइसोङ, “च्हि इस्राएलि तेम्बा क्याइरे तेहि, काङला च्याङ नोठुल मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","नथानेलयि टिरेलो, “ख्युइ ङाला च्हिरु क्याइरे ङो ङोस्येसुइ?” येशुयि खोला जवाक तेरिनराङ नाइसोङ, “फिलिपयि सअ क्ये ताताते ताङला, भेलडुयि तोङबोङ यि हअला ङाहि ख्योएला थोथुवा होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","नथानेलयि खोला नाइसोङ, “रब्बि, ख्योए कजसुबे पिजा ना, ख्योए इस्राएलयि क्यालबो ना।” ");
INSERT INTO tcn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","येशुयि खोला जवाक तेरिन राङ नाइसोङ “ङाहि खेला भेलडुयि तोङबोङयि हअला थोसोङ नाङान तेला हिछे किनाइ? ख्युइ धि ताम लेहाङ ताम छेया लेइ राङ थोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","तेहि ख्युइ हतिला नाइसोङ, “तेम्बारे, ङा खेला नाज्याइ, खि तेङला पोपिया राङ कजसुबे तेङलायि लोन खेरङानला मि पिजा थोला झ्येङान राङ पुपङान थोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ङिन सुबा तेला गालिलयि काना भजारला मिजे किन्दुलो। येशुयि आमा हतिया धुलो। ");
INSERT INTO tcn_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","येशु राङ हति लोब्टुतेबाला याङ मिजेला पोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","छ्याङ सिन येशुयि आमि खोला नाइसोङ, “हतिबे तेहा छ्याङ मिदु।” ");
INSERT INTO tcn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","येशुयि हतिबाला नाइसोङ, “हे पोमु ङाहि च्हि किकोइ होतो ङाला माना। ङाहि भेला तरह लेलेबा मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","मुइ आमायि यक्पुवातेबाला ला नाइसोङ, “ख्युइ नानाइबा च्वरा खे कि।” ");
INSERT INTO tcn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ता यहुदिबे चाङमा सोयापयि लुलामयि चाला हतिया हा:लाम लिटर क्या झि स्योङान टोउयि ट्हु थाबा क्याङबा पोरतुइ। ");
INSERT INTO tcn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","येशुयि हतिबाला नाइसोङ, “क्याङबा बा छ्युयि खोङ।” हतिबे काङभि खा थु छ्युयि काङदेलो। ");
INSERT INTO tcn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ख्युइ हतिबाला नाइरेलो, “टिझि खापेरे भत्यारयि ङोधो मितेबाला खेर।” हतिबे नानाइबा च्वरा केन राङ खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","भत्यारयि ङोधो मितेबायि हति छ्यु तुरेलो, काङते ता छ्याङला घ्युरतुलो। हति ल काने लेलेबाना खोला छ्या मेतालो हिन्नाङ छ्यु घाङानयि यक्पुवातेबाला छ्या होतो। तेहि भत्यारयि ङिन हतिबे ख्योबोतेला क्ये ताङदे नाइरेलो। ");
INSERT INTO tcn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“ताङस्युवा मि पोरोयि ल छ्याङ पोरते ढुनलो तेहि मि तेबे लेइ राङ त्हु मात्रा अल छ्याङ भोरिनलो। ख्युइनि थल्ला थु ल छ्याङते पोरतु।” ");
INSERT INTO tcn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","येशुयि ख्युइ ताङस्युवा हा:लाइतु झ्युयापयि लाइते गालिलयि काना भजारला क्याइसोङ। हतिच्वरा क्याइरे ख्युइ खुरि छे त्येसोङ, तेहि ख्युइ लोब्टुबे खोला हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","हतिच्येला खो खुरि आमा, भाइतेबा राङ लोब्टुतेबा ङ्याबो कफर्नहुमला पुइसोङ। ङिन रेन हतिया तातेलो। ");
INSERT INTO tcn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","यहुदिबे निस्तार कालापसोल याङ धुनला हुन्दु, राङ येशु यरुश्लेमला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ख्युइ मोनलाम क्यासि खिमला लोङ, लु, ङोम्मु छोङान राङ आलाइ च्येङानतेबा ङ्युन छोङिन ताताता ठेसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","तेहि थाक्पि चापकि झि सोइरे ख्युइ हति पोरोला, हतिबे लु राङ लोङ हाङ मोनलाम क्यासि खिमने त्येसोङ, आलाइ च्येङानबे टेबुल खोलबु क्याप्ते हतिबे टेबुल लला क्याप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ङोम्मु छोङान तेबाला ख्युइ नाइसोङ, “धिने धिबा पोरो खेर। ङाहि आकि खिमला छोङ क्यायापयि खिम मासो।” ");
INSERT INTO tcn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ख्युइ लोब्टुबे शास्त्रला नानाइबा हा:कोरेलो, “ख्युइ खिमयि जोश तरह ङाला झ्योपतु झ्युङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","यहुदि आङ किङानबा ख्युइ तेहा टिवा जि ख्योँरे लेप्सोङ, “ख्योए धि लाइ किन्दु, ख्योए धि चाला ङेला काङ हा:लाइयापयि लाइ तोन ज्याइ?” ");
INSERT INTO tcn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","येशुयि हतिबाला जवाक पिन्सोङ, “धि मोनलाम क्यासि खिम तिप, राङ ङा ङिन सुमला लोङ ज्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“तेहि यहुदिबे नाइसोङ, धि मोनलाम क्यासि खिम सोज्याइला लो खलङि राङ टु थसोङ, राङ ङिन सुमला ख्युइ धि मोनलाम क्यासि खिम लोङ ङ्युयि नाइ च्हि?” ");
INSERT INTO tcn_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","हिन्नाङ काङ मोनलाम क्यासि खिम यि भारेला ख्युइ नानाइबा होतो, हति ख्युइ स्हु हिना; ");
INSERT INTO tcn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","जब खो स्यिरे लाँहिन, तेहि येशुयि नानाइबि धि ताम लोब्टुबाला टाम्बा सोइसोङ, राङ हतिबे पवित्रशास्त्रयि थोला राङ येशुयि नानाइबि वचनयि थोला हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","जब येशु निस्तार कालापसोलयि तुना यरुश्लेमला होतो, हतितुइना ख्युइ क्याक्याइबि हा:लाइयापयितेबा थोङसोङ लेइ राङ यि ख्युइ मिनला हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","हिन्नाङ येशुयि खोराङला हतिबे भरला मापोरसोङ, चिचालानाना ख्युइ पोरोला ङोस्येयिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","चिचालानाना मि च्हिना नाइरे खोला छ्या होतो। खोला मि भारेला सुइ नाकोइ मेतालो चिचालानाना मि सम च्हिरु हुन खो खुरि हा:कुनलो। ");
INSERT INTO tcn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","फरिसिबे नाङने निकोदेमस नाङान मि झि होतो। खो यहुदिबे झोमसि नाङने घोबा झि हिना। ");
INSERT INTO tcn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","खो छाम्मु येशुयि तेहा लेप्सोङ, राङ खोला नाइरेलो, “गुरुज्यु, ङेला छ्या होतो ख्योए कजसुबाने लेलेबि गुरु झिना चिचालानाना कजसुबा ङ्याबो मेना ख्युइ क्याक्याइबि धि हा:लाइयापयि लाइतेबा सुइ याङ कि मिङ्युइबा।” ");
INSERT INTO tcn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","येशुयि खोला जवाक पिन्सोङ, “तेम्बारे ङा खेला नाज्याइ, सु याङ सारबा क्याइरे माकेना ख्युइ कजसुबे राज्य मिथुवालो।” ");
INSERT INTO tcn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","निकोदेमसयि खोला नाइसोङ, “मि काप्पो च्युङदे च्हिरु क्याइरे किन? च्हि खो याङ आमायि टोपाला लाम्मा ङिबा सुरे याङ क्येङ्युइ किनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","येशुयि जवाक पिन्सोङ, “तेम्बारे ङा खेला नाज्याइ, रेन छ्यु राङ आत्माने माकेना कजसुबे राज्यला ढो मिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","स्हुने क्येक्येबि सुना, राङ आत्ममाने क्येक्येबा आत्माने। ");
INSERT INTO tcn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ङाहि खेला सारबा क्याइरे क्ये नाइरे हा:मालाइ। ");
INSERT INTO tcn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","हुरबो छोम्मुवा काङ यहला ढोसोम होए हति यहला ढुन। ख्युइ हुरबुइ क्ये ङ्यानकिन हिन्नाङ हति काङ योने हुन राङ काङ यहला ढुन, हति हा:मिकुवा। आत्माने क्येक्येबि मि पोरो हति च्वरा राङ हुन।” ");
INSERT INTO tcn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","निकोदेमसयि हतिला टिसोङ, “धि च्हिरु क्याइरे हुन?” ");
INSERT INTO tcn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","येशुयि हतिला जवाक पिन्सोङ, “ख्योए इस्राएलयि छिया गुरु ना, झोमयाङ हा:मिकुवाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","तेम्बारे, ङा खेला नाज्याइ, हुइ च्हि हा:कुन हति नेन, राङ हुइ च्हि थोङ हति साछि तेरिन हिन्नाङ खे ङाहि साछि हिमिछेबालो। ");
INSERT INTO tcn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ङाहि खेला पृथवियि ताम नाइरे, हति हिन्नाङ हिमिछेबा, तेहि खेला तेङलायि ताम नाइना च्हिरु क्याइरे हिछे कि ङ्युइ किन? ");
INSERT INTO tcn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","तेङलाने पापाबि मि पिजा अर्थात सु याङ तेङला लाला पुपुता मेता लो। ");
INSERT INTO tcn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","च्हिरु क्याइरे मोशायि रुल्ला च्याङ मेते साला तेक्ते, हति च्वरा क्याइरे मि पिजा धेकोइ हुन ");
INSERT INTO tcn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ओर सुगे खोला हिछे क्याइ, हतिला नामयाङ मिसिनयापयि मिजे खुयिन। ");
INSERT INTO tcn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“चिचालानाना कजसुबे संसारला धि च्वरा करि क्याइसोङ, कि खोला रेँ पिजा चिक्पा तेहाङ पिन्देलो, हति क्याइरे सुइ याङ खोला हिछे किङान सुवाङ मासि मायोङ नाइरे, हिन्नाङ नामयाङ मिसिनयाप मिजे खु। ");
INSERT INTO tcn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","चिचालानाना कजसुबे संसारला दोषि सोयाप नाइरे पिजाला संसारला चाँचाँबा मानालो, हिन्नाङ खोने संसार क्योबोङ नाइरे चाँचाँबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","सुइ पिजाला हिछे क्याइ, हति घल मिहा हिन्नाङ हिमिछे किङानते ताङलाने राङ घल च्युङ चिचालानाना ख्युइ कजसुबे पिजा चिक्पायि मिनला हिछे मा क्याइबालो। ");
INSERT INTO tcn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ल अल भेयापते छाछाराते धि राङ ना होए संसारला लेप्तु, राङ मि तेबे होएले ले याङ मुन्ना केनलो चिचालानाना हतिबे लाइ अल किन लो। ");
INSERT INTO tcn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","चिचालानाना लाइ अल किङान पोरो होएला मि कालो, राङ होएला मिहालो, स्यान अर्थात ख्युइ लाइ थोङिन। ");
INSERT INTO tcn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","तेम्बाला मिजे क्योङानयि मि होएला हुन, राङ हति च्वरा क्याइरे ख्युइ क्याक्याइबि लाइ कजसुबे तेहा क्याक्याइबा हिना नाइरे साल्बो थोङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","हतिच्येला येशु राङ ख्युइ लोब्टुतेबा यहुदियायि प्रदेशला पुइसोङ, तेहि हतिया हतिबा ङ्याबो ङिन रेन ढोम्बोला त्येसोङ राङ बप्तिस्मा पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","युहान्नायि याङ सालिम यी धुनयि एनोनला बप्तिस्मा तेरिनलो चिचालानाना हतिया छ्यु लेइ राङ धुलो। हतिया मितेबा हुन राङ बप्तिसमा खेरिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","हति भेला थु युहान्ना झ्याल्ला पुपुता मेतालो। ");
INSERT INTO tcn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","हति भेलाला राङ युहान्नायि लोब्टु झि यहुदि ङ्याबो चाङमा सोयाप यि भारेला नारे च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","युहान्नायि तेहा लेप्ते हतिबे खोला नाइसोङ, “गुरुज्यु, यर्दनयि स्यार छोयि फारकानला सु ख्योए ङ्याबो होतो, सुइ भारेला ख्युइ साछि पिन्दे, तेहि, खो बप्तिस्मा तेरिन तेतु, राङ पोरो ख्युइ तिया ढुन्दु।” ");
INSERT INTO tcn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","युहान्नायि जवाक पिन्देलो, “मिला तेङलाने मा पिन थु च्याङ मिखुबा।” ");
INSERT INTO tcn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ङा ख्रिष्ट माना हिन्नाङ ङा खोले ताङला चाँचाँबा हिना नाङानयि ङाहि साछि खेराङ तेरिन्दु। ");
INSERT INTO tcn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","सु ङ्याबो नामा होतो, ख्योबो हति राङ ना। ख्योबोयि रेँ रुवा सु ख्युइ धुनला लाँरे तोकिन, ख्युइ क्ये थोइरे लेइराङ किप्पो हुन। हतिचाला ता ङाहि किप्पो पुरा च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","खो याला राङ ङा माला होङकोइ राङ होतो। ");
INSERT INTO tcn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","कोङने होङान ते पोरो ले छेया ना। पृथविते पृथ्‍वीने राङ ना, राङ पृथवि राङ ताम नेन। तेङलाने लेलेबा ते पोरोले छेना। ");
INSERT INTO tcn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ख्युइ च्हि थोङ राङ थोइरे, हति साछि हति राङ तेरिन हिन्नाङ ख्युइ साछि सुइयाङ मिङ्यानालो। ");
INSERT INTO tcn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","सुइ ख्युइ साछि ङ्यानकिन, हति कजसुबा तेम्बा हिना नाङानयि तामयि प्रमान तेरिन। ");
INSERT INTO tcn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","चिचालानाना सुला कजसुबायि चाँरे, हतियि कजसुबे वचन नेन चिचालानाना कजसुबे छे माक्याइबा पवित्र आत्मा तेरिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","आकि ख्युइ पिजाला करि किनलो, राङ क्यु पोरो खुरि लाला टोटोता होतो। ");
INSERT INTO tcn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","सुइ पिजाला हिछे किन, हतिला नामयाङ मिसिनयापयि मिजे खु। सुइ पिजायि आदेस मिङ्याना, हति मिजे मिथुवालो, हिन्नाङ कजसुबे स्येताङ हति थोला ताताति ताताता किनलो। ");
INSERT INTO tcn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","युहान्नाले याङ येशुयि लोब्टु मा सुन्दु राङ बप्तिस्मा तेरिन धुलो नाङान फरिसिबे थोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(तेम्बा तेला येशु खुरि ता माना, हिन्नाङ ख्युइ लोब्टुतेबे बप्तिस्मा तेरिनलो) ");
INSERT INTO tcn_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","तेहि येशुयि धि थोइरे, खि यहुदिया ताङदे याङ गालिलला लक्ते पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","खि सामरिया लाम च्युङदे ढोकोइ च्युङदेलो ");
INSERT INTO tcn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","खि सामरियायि सुखार नाङान भजारने लेप्सोङ हति भजारते याकुब खुरि पिजा योसेफला पिपिना सायि धुनला धुलो। ");
INSERT INTO tcn_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","हतिया याकुबयि ठोम्पा धुलो। येशु हुनहुन थाङछ्याते हति ठोम्पि धुनला ङाला सोइ सोङ। हा:लाम ङिम्मुइ भेला च्युङदुलो। ");
INSERT INTO tcn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","सामरिया पोमुवा झि छ्यु घाङदु हतिया लेप्सोङ। येशुयि हतिला नाइसोङ, “ङाला छ्यु थुङदु छ्यु।” ");
INSERT INTO tcn_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ख्युइ लोब्टुतेबा भजारला सायाप ङ्योरु पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","तेहि सामरि पोमुवायि खोला नाइसोङ, “ख्योए युहुदि क्याइरे ङा समरियायि लाने छ्यु च्हिरु क्याइरे थुङज्याइ?” (यहुदिबे समरिया ङ्याबो च्याङ नाता मिभोरा।) ");
INSERT INTO tcn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","येशुयि हतिला नाइसोङ, “ख्युइ कजसुबे च्यिनलाब राङ ख्योएला छ्यु लोङान मिला ङोस्येस्येबा हिन्ना ख्युइ खोला लोङान ना, राङ ख्युइ ख्योएला सोम्बो छ्यु तेरङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","हति पोमुवायि खोला नाइसोङ, “प्रभु, ख्योएला छ्यु धोनयापयि नोचे मेताइ, राङ ठोम्पि याङ तिङरिङमुवा दु। तेहि ख्योए काने सोम्बो छ्यु ख्योङ ज्याइ? ");
INSERT INTO tcn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","च्हि ख्योए ङाहि ताङबुइ याकुबले छेया हिनाइ? ख्युइ ङेला धि ठोम्पा सोइ सोङ, राङ खो खुरि, ख्युइ मि राङ ख्युइ पालाङतेबे धि ठोम्पि छ्यु राङ त्हुरेलो।” ");
INSERT INTO tcn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","येशुयि हतिला जवाक पिन्सोङ, “धि छ्यु थुङान पोरो याङ खाकोमङान ना, ");
INSERT INTO tcn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","हिन्नाङ सुइ ङाहि पिपिनि छ्यु थुङिन हति जब याङ खामि कोमा। काङ छ्यु ङा खोला तेर च्याइ, हति हतिला नामयाङ मिसिनयापयि मिजेयि चाला छ्यु भेलङानयि क्याकपा होङान ना!” ");
INSERT INTO tcn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","हति पोमुयि खोला नाइसोङ, “प्रभु, ङाला हति छ्यु राङ नाङ, राङ तेहि ङा खा कोमङान माना ना, राङ तेहि ङेला छ्यु घाङदु होङकोइ याङ मिहा।” ");
INSERT INTO tcn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","येशुयि हतिला नाइसोङ, “कु, ख्युइ ख्योबोला सअ नोइ।” ");
INSERT INTO tcn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","हति पोमुयि नाइसोङ, “ङाहि ख्योबो मेता।” येशुयि हतिला नाइसोङ, “ख्युइ ख्योबो मेता नाइरे ख्युइ तेम्बा नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","चिचालानाना ख्युइ ख्योबो ङा थाबा च्युङ छारतु, राङ सु थाल्ला ख्योए ङ्याबो दु, हति ख्युइ ख्योबो माना। ख्युइ धि तेम्बा नानाइबा ना।” ");
INSERT INTO tcn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","हति पोमुयि खोला नाइसोङ, “हजुर, ख्योए ङोन्सेखिलङान हिना नाइरे ङाला छ्या होतो। ");
INSERT INTO tcn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ङाहि ताङबुइ मि धि सुरला कजसुबायि पुजा क्याइरे, तेहि खे यहुदि नेन्दु, आराधाना किसि सा यरुश्लेमने नेन्दु।” ");
INSERT INTO tcn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","येशुयि हतिला नाइसोङ, “ए पोमु ङाला हिछे कि, हति भेला हुन राङ दु, जब खे न त धि सुरला, न यरुश्लेमला आकि आराधाना किकोइ हुन।” ");
INSERT INTO tcn_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","खे समरिया काङ आराधाना किन खि हा:मिकुवा। ङे च्हि आराधाना किन ङेला छ्या होतो चिचालानाना मुक्तिते यहुदिबाने हुन। ");
INSERT INTO tcn_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","हिन्नाङ भेला हुन राङ दु, राङ हति भेला थाल्ला राङ ना, जब तेम्बा आराधाना किङानबे आकेला आत्मा राङ तेम्बाला आरा किङान ना। चिचालानाना आराधाना किङान च्वरा आराधाना किङानला आके फाकिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","कजसुबा आत्मा ना, राङ खोला आराधाना किङानतेबे आत्मा राङ तेम्बा ला आराधाना किकोइ हुन। ");
INSERT INTO tcn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","हति पोमुयि खोला नाइसोङ, “ङाला छ्या होतो, कि थारथोनदु झ्युङान हुन (काङला ख्रिष्ट नेन), राङ जब खो हुन, हतितुइना ङेला ताम पोरो नेन।” ");
INSERT INTO tcn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","येशुयि हतिला नाइसोङ, “ख्योए ङ्याबो ताम नाङान, ङा हति राङ ना।” ");
INSERT INTO tcn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","हतितुइना राङ ख्युइ लोब्टुतेबा लेप्सोङ, राङ खो पोमु झि ङ्याबो ताम नाङान थोङसोङ हा:लाइरेलो हिन्नाङ “ख्योए ल च्हि कोयिन?” अर्थात “ख्योए धि पोमु ङ्याबो चिचाला ताम नेन?” नाइरे सुइ याङ मा टिसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","तेहि हति पोमु घारि पोरते भजार यहला पुइसोङ, राङ मि तेबाला नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“सअ, मि झिला तेहि, सुइ ङाहि क्याक्याइबि लाइ पोरो ङाला नाइसोङ। हति राङ ख्रिष्ट हिनोम?” ");
INSERT INTO tcn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","तेहि हतिबा भजारने थोन्दे येशुयि तेहा पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","हति उइला लोब्टुबे खोला जु नाइरे स्युवा क्यापसोङ, “गुरुज्यु, चिगा सो।” ");
INSERT INTO tcn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","हिन्नाङ ख्युइ हतिबाला नाइसोङ, “ङाला सायापयि चाला धि च्वरा ङ्योपा होतो, काङते खेला छ्या मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","हतिचाला लोब्टुतेबे चिकि च्हि नारे क्याइसोङ, “च्हि रेनयि खोला ङ्योपा ख्योँरे पिनोम का कि च्हिरु?” ");
INSERT INTO tcn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","येशुयि हतिबाला नाइसोङ, “ङाला चोँङानयि धोप्पा च्वरा कि, राङ ख्युइ लाइ पुरा कियाप राङ ङाहि ङ्योपा ना। ");
INSERT INTO tcn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","च्हि खे मिनाइ, तरह धा सि लाँमा दु, तेहि भालि तुइयापयि भेला हुन? ङा खेला नाज्याइ, रेँ मि तेक्ते स्यिङ राङ भारि तोइ, भालि तुइयापला भालि छोहि छारतु। ");
INSERT INTO tcn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","सुइ भालि तुकिन हतिला ला खुकिन, नामयाङ मिसिनयापयि मिजेयि चाला ढेबु रुकिन, राङ जु ङान राङ तुइङान ङाहि कार ङ्याबो किप्पो किनलो। ");
INSERT INTO tcn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","चिचालानाना ‘चिकि झुयिन, राङ स्यानति तुबिनलो,’ नाङानयि वचन धिला राङ तेम्बा हुन। ");
INSERT INTO tcn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ङाहि ख्योएला हतिया तुप्तु चाँरे, काँहा तुका क्याक्याइबा मेता। स्यान तेबे तुका क्याक्याइबा होतो, राङ खि तुका क्याक्याइबि ढेबु खेराङला खुदु।” ");
INSERT INTO tcn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","“ङाहि च्हि क्याइ हति पोरो ख्युइ नाइसोङ हति पोमुवायि साछि क्याइरे हति भजारयि सामरितेबे नाङने लेइराङयि ख्युइ थोला हिछे क्याइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","हतिचाला जब सामरि ख्युइ तेहा लेप्ते, हतितुइना हतिबे खोला खोङ ङ्याबो त्योएयापयि स्युवा क्यापतु, राङ येशु ङिन ङा खोङ ङ्याबो तातेलो। ");
INSERT INTO tcn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","तेहि ख्युइ वचनयि चाला तरह याङ लेइराङयि ख्हुइ थोला हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","हति पोमुला हतिबे नाइसोङ, “ता ख्युइ नानाइबि तामयि चाला ङाहि हिछे क्याक्याइबा माना हिन्नाङ ङे ङिरि थोथोइबि चाला तेम्बारे खो संसारयि मुक्तिदाता हिना नाइरे ङाहि हा:कोसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ङिन ङाहि च्येला येशु हतिने थोन्दे गालिलला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","(येशु खुरि साछि पिन्सोङ, कि रेँ अल देशला ङोन्सेखिलङानला सम्मान राङ मिदु नाइरे) ");
INSERT INTO tcn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","जब खो गालिलला लेप्ते, तेहि ख्युइ यरुश्लेमला निस्तार कालापसोलयि भेलाला च्हि क्याक्याइबा होतो हति पोरो लाइ थोङसोङ गालिलयि मितेबे ल क्याइरे सअ नाइरेलो चिचालानाना हतिबा हाङ कालापसोलला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","हतिच्येला येशु गालिलयि काना भजारला लेप्सोङ, काँहा ख्युइ छ्युला आरा स्यिरेलो। कफर्नहुमला घोबा आङकिङान झि धुलो, सुइ पिजा नाप्पा धुलो। ");
INSERT INTO tcn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","येशु यहुदियाने गालिलला लेप्तुना थोइरे खो ख्युइ तेहा लेप्सोङ, तेहि ख्युइ पिजा टाक्तु छ्यु नाइरे स्युवा क्यापसोङ चिचालानाना ख्युइ पिजा स्यिलेके धुलो। ");
INSERT INTO tcn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","येशुयि खोला नाइसोङ, “खे शक्ति राङ हा:लाइयापयि लाइ माक्याइ थु हिछे राङ मिकिता।” ");
INSERT INTO tcn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","हति घोबा आङकिङानति खोला नाइसोङ, “प्रभु, ङाहि पिजा स्यियापले ताङला ङा ङ्याबो सअ।” ");
INSERT INTO tcn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","येशुयि खोला नाइसोङ, “क्यु, ख्युइ पिजा सोम्बो दु।” येशुयि नानाइबि धि वचनला ख्युइ हिछे क्याइसोङ, राङ खुरि लाम स्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","तेहि खो लामला ढुन ताताताला ख्युइ यक्पुवातेबा खोला ठाते ख्युइ पिजा सोम्बो दु नाइरे खोला स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","चोम भेलाने खो टाकाला छेलसुइ नाइरे टिरे हतिबे नाइसोङ, “धाङ ङिम्मुइ एक भजेने खोला छायोएयि ताङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","येशुयि हतिला, “ख्युइ पिजा सोनङान ना” नेतुइने राङ हिना नाइरे आकि हा:कोरेलो। तेहि खो राङ ख्युइ प्येरा पोरोयि हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","यहुदियाने गालिलला लेप्ते येशुयि क्याक्याइबि हा:लाइयापयि लाइ लाम्मा ङिबा हिना। ");
INSERT INTO tcn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","हतिच्येला यहुदिबे कालापसोङ हिना, राङ येशु यरुश्लेमला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","यरुश्लेमला लु त्येसि कोयि धुनला क्य ङा थाबा होएता ठोम्पा धुलो, काङला हिब्रु क्येला बेथसेदा नेनलो। ");
INSERT INTO tcn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","हतिया लेइराङ नाझा होएता, मदलभ मि लोँलोँवा, काङबा खोरिया, नाप्पा तेबा स्यियिन। हतिबा छ्यु जब घुलिन नाइरे कहुरे तोकिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","चिचालानाना कजसुबे तेङलायि लोन खेरङान झिकि छ्यु किकिलाला छोएछोएला पुपते जुनलो, राङ छ्यु योमयोम क्याइरे च्येला स्यु ताङला छ्युइ नाङला स्यु, च्हिरु नाप्पा थ्‌हुवा च्युङनाङ, हति टाकिन लो। ");
INSERT INTO tcn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","हतिया लो ङिस्यु राङ क्येने नाङान मिझि धुलो। ");
INSERT INTO tcn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","येशुयि हति ङेरे ताताता थोङसोङ तेहि खो लेइ राङ ताङलाने राङ नाङान हिना नाइरे हा:कोरे येशुयि हतिला नाइसोङ, “च्हि ख्योए टासोम होतोइ?” ");
INSERT INTO tcn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","नाप्पाति खोला नाइसोङ, “प्रभु, जब छ्यु थोरिन हतितुइना ङाला खिल छ्यु थु केलङान ङाहि सुवाङ मेता, ङा ढुनढुन ङाले ताङला मि स्यान पुते स्युयिनदु।” ");
INSERT INTO tcn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","येशुयि हतिला नाइसोङ, “लाँरे त्योए, राङ खुरि तान तुइ, तेहि क्यु।” ");
INSERT INTO tcn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","हतितुइना राङ हति मि टासोङ, राङ खुरि तान तुरे पुइसोङ। हति ङालसुइ ङिन हिना। ");
INSERT INTO tcn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","हतिचाला नाप्पा टाक्तु च्युच्युका मि तेला यहुदिबे नाइसोङ, “धिनि ङालसुइ ङिन हिना, ख्युइ तान खुर च्याइ ल माना।” ");
INSERT INTO tcn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","हति हतिबाला जवाक पिन्सोङ, “सुइ ङाला टाक्तु च्युकते ख्युइ राङ नाइसोङ ‘रेँ तान खुरते क्यु।’” ");
INSERT INTO tcn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","हतिबे खोला टिसोङ, “ख्योएला तान खुरते क्यु नाङान मि सु ना?” ");
INSERT INTO tcn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","हिन्नाङ टाक्तु च्युच्युकि मि ति येशु सुना नाइरे ङोस्येस्येबा मेतालो चिचालानाना हति साला मि लेइराङ च्युवा राङ खो हतिने पुइछारतुलो। ");
INSERT INTO tcn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","हतिच्येला येशुयि खोला मोनलाम क्यासि खिमला ठाते नाइसोङ, “तेहि, ख्योए टातु। याङ तिक्पा मा क्ये, राङ ख्युइ थोला याङ अल मायोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","खोला टाक्तु झ्युङान नि येशु हिना नाइरे हति मि पुते यहुदि आङकिङानतेबाला नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","हतिचाला यहुदिबे येशुयि तुका तेराला छेलसोङ चिचालानाना ख्युइ धि लाइ ङालसुइ ङिनला क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","तेहि येशुयि हतिबाला नाइसोङ, “ङाहि आके बारतै लाइ किन राङ ङा याङ लाइ किनराङ होए।” ");
INSERT INTO tcn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","हतिचाला यहुदिबे येशुला सोएयाप हतिले मा च्युइ क्याइरे चिचालानाना ख्युइ ङालसुइ ङिनयि ठिम मासि लाँलाँबा मात्रा माना, हिन्नाङ खोराङ ला कजसुबा च्वरा हिना नानाइबा राङ ख्युइ कजसुबाला खुरि आके हिना नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","येशुयि हतिबाला नाइसोङ, “तेम्बारे, ङा खेला नाज्याइ, पिजा खुरि च्याङ कि मिङ्युइबा, हिन्नाङ आकि च्हि क्याक्याइबा थोङ हति किन, चिचालानाना आकि च्हि क्याइ, पिजि याङ हति किन। ");
INSERT INTO tcn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","चिचालानाना आकि पिजाला करि किन, राङ खो खुरि क्याक्याबि लाइ पोरो पिजाला तोनिन। हतिले याङ लाइ ल ख्युइ पिजाला तोनिन, राङ खे हा:लाइङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","चिचालानाना च्हिरु क्याइरे आकि मि स्यिस्यियातेबाला लोङिन राङ खोला मिजे तेरिन, हति च्वरा क्याइरे पिजि याङ सुला धोप्पा होए, हतिला मिजे तेरिन। ");
INSERT INTO tcn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","चिचालानाना आकि सुइ याङ ल अल भेयापयि मिकिता हिन्नाङ पोरो ल अल भेयापयि कियापयि लाइ पिजाला पिपिना होतो, ");
INSERT INTO tcn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","तेहि पोरोयि पिजि सम्मान किन नाइरे, च्हिरु क्याइरे हतिबा आकि सम्मान किन। पिजि सम्मान मि किङानयि खोला चोँङान आकि याङ सम्मान मि किता।” ");
INSERT INTO tcn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“तेम्बारे, ङा खेला नाज्याइ, सुइ ङाहि वचन ङ्यान राङ ङाला चोँङान यि थोला हिछे क्याइ, हतिला नामयाङ मिसिनयापयि मिजे होतो। हति ल अल भेयापयिला मिहा हिन्नाङ स्यियापले मिजेला लेप छारते।” ");
INSERT INTO tcn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","तेम्बारे, ङा खेला नाज्याइ, हति भेला हुन्दु, राङ हति भेला थाल्ला ना जब स्यिस्यियातेबे कजसुबे पिजि क्ये ङ्यानकिन राङ, ङ्यान ङान तेबा सोम्बो होङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","चिचालानाना च्हिरु क्याइरे आके खोराङला मिजे दु, हति च्वरा क्याइरे ख्युइ पिजाला याङ खोराङला मिजेयि क्याक्याला होङयापयि आङ पिन्देलो। ");
INSERT INTO tcn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","तेहि खोला ल अल भेयापयि था च्योएयापयि आङ पिन्देलो चिचालानाना खो मि पिजा ना। ");
INSERT INTO tcn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“धिला हा:मालाइ चिचालानाना भेला हुन राङ दु, जब तुरसाला होएता पोरोयि ख्युइ क्ये थोइङान ना, ");
INSERT INTO tcn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","तेहि तुरने फिला थोन्दे होङान ना लाइ ल किङान तेबा स्येताङयिस्यिने मिजेला लाँयायि चाला राङ लाइ अल किङान तेबा ङेबायि चाला स्यिस्यियाने लायाप।” ");
INSERT INTO tcn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“ङा ङारि च्याङ कि मिङ्युइबा। च्हिरु क्याइरे ङा कजसुबे ङ्यानकिन, हति च्वरा क्याइरे ङा ल अल भेयापयि किन, राङ ङाहि ल अल भेयापयि तेम्बा हुन चिचालानाना ङा ङारि धोप्पा मि फाता हिन्नाङ ङाला चोँङानयि धोप्पा फाकिन।” ");
INSERT INTO tcn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“तेम्बारे ङा ङारि भारेला साछि पिन्ना ङाहि साछि तेम्बा मिहा।” ");
INSERT INTO tcn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ङाहि भारेला साछि तेरङान मि स्यान हुन, राङ ङाला छ्या होतो, कि ङाहि भारे ख्युइ च्हि साछि तेरिन, हति साछि तेम्बा ना। ");
INSERT INTO tcn_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“खि युहान्नायि तेहा ढोरु चाँदु, तेहि ख्युइ तेम्बि साछि पिन्दु। ");
INSERT INTO tcn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","हिन्नाङ ङा ङारि भारेला मि साछि कोइ सोम मिकिता, याङ ङा धि ताम हति चाला नेन, कि खे थारथोनोङ नाइरे ");
INSERT INTO tcn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","युहान्ना छेङान राङ होए भारङानयि छ्योएमे हिना, राङ खे ख्युइ होएला टिझि थु किप्पो कियापला राजि च्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","हिन्नाङ ङाला ङ्याबो काङ साछि होतो, हति युहान्नाले छेया होतो। चिचालानाना काङ लाइ कियाप यि चाला आकि ङाला पिपिना होतो, हति लाइ ङा किनराङ होतो, तेहि हतिराङ ङाहि भारेला साछि तेरिन्दु कि आकि ङाला चाँचाँबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ङाला चोँङान आकि खुरि राङ ङाहि भारेला साछि तेरिन्दु। ख्युइ क्ये खि जब याङ थोथोइबा मेता, तेहि ख्युइ च्ये जब याङ थोथोवा मेता। ");
INSERT INTO tcn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ख्युइ वचन खेला मितोता, चिचालानाना सुला ख्युइ चाँरे, खे हति थोला हिछे मिकिता। ");
INSERT INTO tcn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","खे पवित्रशास्त्राला फाकिन्दु, चिचालानाना हतिया नामयाङ मिसिनयापयि मिजे होतो नाइबा खे किन्दु। ङाहि भारेला साछि तेरङान हति पवित्रशास्त्रा राङ ना, ");
INSERT INTO tcn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","हचु हिन्नाङ खे मिजे थोपयापला ङाहि तेहा होङसोम मिकिता। ");
INSERT INTO tcn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“ङा मियि छे धेयाप धोप्पा मिकिता” ");
INSERT INTO tcn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","हिन्नाङ ङाला छ्या होतो कि, खि च्हिरु मि हिना नाइरे, याङ ङाला छ्या होतो कि, ख्युइ समला कजसुबायि चाला करि च्याङ मिदु। ");
INSERT INTO tcn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ङा ङारि आकि मिनला लेलेबा होतो, हिन्नाङ खे ङाहि काला मि ङ्याना। स्यान सु याङ ङाहि मिनला लेपन्ना हतिला हिना नाइरे खाला ङ्यान ङानना। ");
INSERT INTO tcn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","खे च्हिरु क्याइरे हिछे कि ङ्युइ किन्दुइये, जब कि खे खिरी नाङने सम्मान प्येरे किन्दु, तेहि चिकि चिने सम्मान फाकिन्दु, काङ छे ते च्हि मात्रा कजसुबाने हुन? ");
INSERT INTO tcn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“धि हिना नाइरे समला मास्यार कि ङा आकि धुनला खेला घल सुन नाइरे। खेला घल सोङान ता मोशा होतोना, सुला खि रेँ भरोसा पोपोरा होतो। ");
INSERT INTO tcn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","चिचालानाना खि मोशाला हिछे क्याक्याइबा नाना ङाला हाङ हिछे किन, चिचालानाना ख्युइ ङाहि भारेला टिटिबा होतो। ");
INSERT INTO tcn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","हिन्नाङ खे ख्युइ टिटिबि तामला हिछे मि किना, ङाहि तामला च्हिरु क्याइरे हिछे किच्याइ?” ");
INSERT INTO tcn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","धि तामयि च्येला येशु गालिल, मदलभ तिबेरियास छो छियि फारकानला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","तेहि तुम छोम्मुवा झि ख्युइ च्येला लेप्सोङ चिचालानाना ख्युइ नाप्पातेबाला क्याक्याइबि हा:लाइयापयि लाइतेबा हतिबे थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","येशु स्हुरयि थोला पुइसोङ, राङ खुरि लोब्टुबा ङ्याबो त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","यहुदिबे कालापसोङ, निस्तार-कालापसोलयि भेला धुनला धुलो, ");
INSERT INTO tcn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","तेहि येशुयि फालाछुला ताइरे तुम छोम्मुवा झि खो यहला होङान थोङसोङ ख्युइ फिलिपला नाइसोङ, “धिबाला स्योमयापयि चाला हु काने लोटा ङ्योज्याइ?” ");
INSERT INTO tcn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ख्युइ खोला छोए तायापयि चाला धि नानाइबा ना, चिचालानाना को च्हि कितु पुते, सो खोला छ्या होतो। ");
INSERT INTO tcn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","फिलिपयि खोला नाइसोङ, “पोरोला टिझिटिझि खुनाङ ङाहि ङुलयि सिक्कि क्या लोटा हतिबाला छाँमिदु।” ");
INSERT INTO tcn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ख्युइ लोब्टुबे नाङने च्हि सिमोन पत्रुसयि भाइ अन्‍द्रियासयि नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ङ्या पिजा झि दु, हतिला जौकायि लोटा ङा राङ ङ्या ङाहि दु। हिन्नाङ झोम मि चाला झोबा झि कि काँहा छाङिन?” ");
INSERT INTO tcn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","येशुयि नाइसोङ, “मितेबाला तोतुछ्‌यु।” हतिया चा लेइराङ क्येक्येबि थाङ धुलो। तेहि तोङ ङा थाबा पिजा हतिया त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","तेहि येशुयि लोटा खेरसोङ, राङ कजसुबा ला कटिनक्याँ नाइरे च्येला त्योएङान तेबाला कोहििसोङ, हतिच्वरा क्याइरे ङ्या याङ कोहििसोङ। हतिबाला चोम कोइबा होए होचोम पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","तेहि ख्होए ढ्हाढ्हा थु साइ सोङ ख्युइ खुरि लोब्टुतेबाला नाइसोङ, “ला मा लुलुइबि तुबुतेबा तुइ, चियाङ मासहि होङदु माजु।” ");
INSERT INTO tcn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","साङानतेबे लालाकि जौका हति लोटा ङाहि तुभुइ हतिबे तुरे ख्योए फुगो च्युनङि खाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","हतिचाला ख्युइ क्याक्याइबि धि हा:लाइयापयि लाइतेबा थोङसोङ मितेबे नाइसोङ, “संसारला होङान ङोन्सेखिलङान तेम्बारे खो राङ हिना।” ");
INSERT INTO tcn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","हतिबा लेप्ते खोला बलजफति ङ्याबो क्यालबो सोज्याइ फाकिन्दु नाइरे हा:कोरे येशु याङ चिक्पा सुरला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","कमु च्युङदे येशु लोब्टुतेबा छो यहला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","राङ डुङगाला स्योन्दे हतिबा छो छोम्मुवा फारकानला कफर्नहुम यहला ढुवाला छेलसोङ। हतितुइना स्योरुपलेके धुलो, राङ येशु थल्ला थु ख्होए तेहा लेलेबा मेतालो। ");
INSERT INTO tcn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","तेहि हुरबो छोम्मुवा क्याक्याबाति, छो छोम्मुवायि भाल्लाप क्याकाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ङा ट्हु किलोमिटर डुङगा चलाइ क्याइरे पुते हतिबे येशु छो छोम्मुवायि थोला काङबि डुङगायि धुनला होङान थोङसोङ, तेहि हतिबा झिसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","हिन्नाङ ख्युइ हतिबाला नाइसोङ, “ङ्याना माझि।” ");
INSERT INTO tcn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","हतिबे खोला क्येन राङ ङ्याबो डुङगाला पोरसोङ, राङ हतिबा ढुन ताताति साला डुङगा लेप छारसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","छो छोम्मुवायि फारकान ला होएता मि झोम ति थाहि टो तेला हतिया डुङगा झि मात्रा थोङसोङ। हतिबाला छ्या होतो, कि येशु खुरि लोब्टुबा ङ्याबो डुङगाला स्योस्योना मेता नाइरे हिन्नाङ खुरि लोब्टुबा मात्रा पुते नाइरे। ");
INSERT INTO tcn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","तेहि तिबेरियासने स्यान डुङगा तेबा हति साला लेप्सोङ, का प्रभुयि कटिन क्या नाइरे हतिबे लोटा सासायिबा तेहा। ");
INSERT INTO tcn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","येशु राङ ख्युइ लोब्टुबा हतिया मेता छ्या च्युङदे हतिबा येशुला फाकिन डुङगाला स्योन्दे कफर्नहुम पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ख्होए येशुला छो छोम्मुवा यि फारकानला ठाते खोला टिरेलो, “गुरुज्यु, ख्योए ङिहा जब लेप्ते?” ");
INSERT INTO tcn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","येशुयि हतिबाला जवाक तेरिन ताङ नाइसोङ, “तेम्बारे ङा खेला नाज्याइ, खि हा:लाइयापयि लाइतेबा थोङसोङ माना हिन्नाङ ढ्हाढ्हा थु लोटा सासाइबि चाला ङाला फातु लेलेबाना। ");
INSERT INTO tcn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","मासि होङान यि ङ्योपि चाला तुका माके, हिन्नाङ नामयाङ मिसिनयापयि मिजे तु त्योएङानयि ङ्योपायि चाला तुका कि, काङते मि पिजि खेला तेरङान ना। चिचालानाना कजसुबा आकि ख्युइ थोला छाप च्याच्यारा होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","हतिबे खोला नाइसोङ, “कजसुबे धोप्पा होएते लाइ किच्याइला ङाहि च्हि कि कोइ हुन?” ");
INSERT INTO tcn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","येशुयि हतिबाला नाइसोङ, “कजसुबे लाइ हति राङना सुला ख्युइ चाँचाँबा होतो हतिला खे हिछे कि।” ");
INSERT INTO tcn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","हतिचाला हतिबे खोला नाइसोङ, “ख्योए काङ हा:लाइयापयि लाइ तोनिन्दु, सो ङे ताज्याइ, तेहि ख्योएला हिछे किता? ख्योए च्हि किच्याइ? ");
INSERT INTO tcn_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ङाहि ताङबुइ मि च्याङ मेते साला मन्न साइरेलो, पवित्रशास्त्रला धि च्वरा नाइरे टिदु, ‘ख्युइ हतिबाला सायापला तेङलाने लोटा पिन्सोङ।’” ");
INSERT INTO tcn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","येशुयि हतिबाला नाइसोङ, “तेम्बारे, ङा खेला नाज्याइ, खेला तेङलाने लोटा तेरङान मोशा माना हिन्नाङ तेङलाने खेला तेम्बा लोटा तेरङान ङाहि आके ना। ");
INSERT INTO tcn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","चिचालानाना कजसुबे लोटा हति राङना, काङते तेङलाने हुन राङ, संसारला मिजे तेरिन।” ");
INSERT INTO tcn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","हतिबे येशु नाइसोङ, “प्रभु, हति लोटा ङेला बारतै नाङ।” ");
INSERT INTO tcn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","येशुयि हतिबाला नाइसोङ, “मिजेयि लोटा ङ्याना। ङाहि तेहा होङान टोपा मितोबा, राङ ङाहि थोला हिछे किङान नामयाङ खा मिकोमा। ");
INSERT INTO tcn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","हिन्नाङ ङाहि खेला नानाइबा राङ होए, खि ङाला थोथोवा होतो, राङ हिछे मिकिता। ");
INSERT INTO tcn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","आकि ङाला पिपिना पोरो ङाहि तेहा होङान ना, राङ ङाहि तेहा होङान च्यिलाङ ङा मासि मिसो। ");
INSERT INTO tcn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ङा ङारि धोप्पा पुरा कितु ङा तेङलाने लेलेबा माना हिन्नाङ ङाला चोँङानयि धोप्पा पुरा कितु लेलेबाना। ");
INSERT INTO tcn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","तेहि ङाला चोँङान यि धोप्पा धि ना, कि ख्युइ ङाला पिपिनि नाङने सुलाङ ङाहि ढोरु झ्युयाप माना, हिन्नाङ खेला सिनि ङिन सोम्बो सोइरे लोङयापयि चाला। ");
INSERT INTO tcn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","चिचालानाना ङाहि आकि धोप्पा धिना, कि पिजाला ताङानला राङ ख्युइ थोला हिछे किङान पोरोला नामयाङ मिसिनयापयि मिजे होङ राङ, राङ ङा हतिला सिनि ङिन सोम्बो सोज्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","यहुदिबा येशुयि विरोधला नाला छेलसोङ चिचालानाना ख्युइ नाइसोङ, “तेङलाने पुपुबि लोटा ङा राङना।” ");
INSERT INTO tcn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","हतिबे नाइसोङ, “च्हि धि योसेफयि पिजा, येशु मानाइ? ख्युइ आके राङ आमाला हुइ ङोमिस्येबाइ च्हि? थाल्ला धि च्हिरु ‘ङा तेङलाने लेप्ते’ नाइरे नेन्दु?” ");
INSERT INTO tcn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","येशुयि हतिबाला जवाक पिन्सोङ, “खे खिरि नाङला स्युताम नारे माके। ");
INSERT INTO tcn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ङाला चोँङानयि आकि मा टुइना सुइ याङ ङाहि तिया होङ मिङ्युइबा, राङ ङा हतिला सिनि ङिन सोम्बो सोज्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","‘तेहि हति पोरो कजसुबाने लोपङान ना नाइरे’ ङोन्सेखिलङानयि किताबला टिटिबा दु। पोरो सुइ आकेने ङ्यानिन राङ स्येयिन हति ङाहि तेहा हुन। ");
INSERT INTO tcn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","आकेला मि सुइ याङ थोथोवा मेता मात्रा हति थोथोवा मेता। सुइ कजसुबाने लेलेबा होतो, हति राङ आकेला थोथोवा होतो। ");
INSERT INTO tcn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","तेम्बारे ङा खेला नाज्याइ, सुइ हिछे क्याइ हतिला नामयाङ मिसिनयापयि मिजे होतो। ");
INSERT INTO tcn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ङा मिजेयि लोटा ना। ");
INSERT INTO tcn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","खि ताङबुइ कानाने साथुवाला मन्न साइरे हाङ स्यिरे पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","हिन्नाङ तेङलाने पापते होङानयि लोटा धि राङ ना, सुइ हति साइ हति मिस्यिया। ");
INSERT INTO tcn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","तेङलाने पापाबि सोम्बो लोटा ङा राङ ना। सुइ धि लोटा साइ हति बारतै मिसिया तोकिन। राङ काङ लोटा ङा संसारयि मिजेयि चाला तेरच्याइ, हतिते ङाहि स्हु ना।” ");
INSERT INTO tcn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","तेहि यहुदिबा ख्होरे नाङला नारे किताला छेलसोङ, “धि मि च्हिरु क्याइरे खुरि स्हु हुला सारु जु ङ्युइकिन?” ");
INSERT INTO tcn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","येशुयि हतिबाला नाइसोङ, “तेम्बारे, ङा खेला नाज्याइ, खि मि पिजि स्हु मासाइना, राङ ख्युइ ठा मातुना, खेला मिजे मिहा।” ");
INSERT INTO tcn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ङाहि स्हु साङान राङ ङाहि ठा थुङान ला नामयाङ मिसिनयापयि मिजे दु, राङ सिनि ङिन हतिला सोम्बो सोज्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","चिचालानाना ङाहि स्हु तेम्बारे सायापयि क्यु ना, राङ ङाहि ठा तेम्बारे थुङयाप यि क्यु ना। ");
INSERT INTO tcn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ङाहि स्हु साङान राङ, ङाहि ठा थुङान ङाहि तेहा तोकिन, राङ ङा हतिला तोकिन। ");
INSERT INTO tcn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","च्हिरु क्याइरे सोम्बो आकि ङाला चाँरे, राङ ङा आकि चाला सोम्बो होतो, हति च्वरा क्याइरे ङाला साङान याङ ङाहि क्याइरे सोम्बो लुइङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","“तेङलाने लेलेबि धि लोटा धि च्वरा माना काङते ताङबुइ काने साइनाङ स्यिरे पुते। धि लोटा साङान ते बारतै सोम्बो त्योएङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ख्युइ धि ताम कफर्नहुम यहुदि झोमसि खिमला छोइ लोबितुइना नाइरेलो। ");
INSERT INTO tcn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","धि ताम थोइरे ख्युइ लोब्टु लेइराङ नाङने नाइसोङ, “धि वचन काबोदु, सुइ धि ङयान ङ्युइकिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","हिन्नाङ ख्युइ लोब्टुतेबा भारेला ख्होरे नाङला नारे किन्दु नाइरे हा:कोरे येशुयि हतिबाला नाइसोङ, “च्हि धि ताम खि चाला पारछ्ये हुन दुये? ");
INSERT INTO tcn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","खि मि पिजा ताङला खो काँहा होए हतिने पुपकिन ताताता थोङसोङ कि च्हिरु? ");
INSERT INTO tcn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","मिजे तेरङान कजसुबायि आत्मा ना, स्हुने च्याङ मिहा। काङ वचन ङाहि खेला नाइरे, हति कजसुबायि आत्मा राङ मिजे ना। ");
INSERT INTO tcn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","हिन्नाङ खि नाङने चोम होतो, सुइ हिछे मि किता” चिचालानाना खोला हिछे मि किङान सुगासुगा ना, राङ खोला धोका तेरङान सु हुन नारे येशुला ताङलाने राङ छ्या होतो। ");
INSERT INTO tcn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","येशुयि नाइसोङ, “हति चाला ङाहि नानाइबा होए आकि आङ मा पिनथु सुयाङ ङा होएसा ना होङ मिङ्युइबा।” ");
INSERT INTO tcn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","हतिच्येला ख्युइ लोब्टु लेइराङ क्यापला पुइसोङ राङ खो ङ्याबो टालटियाप ताङदेलो। ");
INSERT INTO tcn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","येशुयि लोब्टु च्युनङिगारला नाइरेलो, “च्हि खे याङ ङाला तादे ढोज्ये?” ");
INSERT INTO tcn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","सिमोन पत्रुसयि जवाक पिन्देलो, “हे प्रभु, ङे सुइ तेहा ढोज्याइ? ख्योए ङ्याबो नामयाङ मिसिनयापयि मिजेयि वचन दु। ");
INSERT INTO tcn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","राङ ङाहि हिछे क्याक्याइबा होतो राङ ङोस्येस्येबा होतो, ख्योए कजसुबे पवित्र मि ना।” ");
INSERT INTO tcn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","येशुयि हतिबाला जवाक पिन्सोङ, “च्हि ङा ङारि खे च्युनङिगारला धाधामा मानाइ? तेहि खि नाङने च्हि ते तुइ ना।” ");
INSERT INTO tcn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","धि ख्युइ सिमोन इस्करियोतयि पिजा यहुदायि भारेला नानाइबा हिना, चिचालानाना च्युनङियि नाङने च्हि क्याइरे याङ ख्युइ येशुला धोका तेर च्युइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","हतिच्येला येशु गालिलला राङ युकिन त्येसोङ हिन्नाङ खो यहुदियाला ढोसोम मेतालो चिचालानाना यहुदि आङकिङान खोला सोयापयि च्युइला होतो। ");
INSERT INTO tcn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","तेहि यहुदिबे छाप्रो कालापसोल धुनला होतो। ");
INSERT INTO tcn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","हतिचाला येशुयि भाइतेबे खोला नाइरेलो, “धि सा ताङदे यहुदियाला क्यु, राङ ख्युइ क्याक्याइबि लाइतेबा ख्युइ लोब्टुतेबे थोङोङ। ");
INSERT INTO tcn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","सु मियि तहोन तुइच्याइ धोप्पा किन, हति फाला लाइ मिकिता। ख्युइ धि लाइतेबा किना संसारला थोङदु छ्यु।” ");
INSERT INTO tcn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","चिचालानाना ख्युइ भाइतेबे याङ खोला हिछे मिकितालो। ");
INSERT INTO tcn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","येशुयि हतिबाला नाइसोङ, “ङाहि थारका भेला तरह लेलेबा मेता, हिन्नाङ खि चालाता पोरो भेला थारका हिना। ");
INSERT INTO tcn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","संसारयि खेला मिका कि मिङ्युइबा, हिन्नाङ ङाला मिका किन, चिचालानाना संसारयि भारेला ख्युइ लाइ तेबा अल दु नाइरे ङा साछि तेरच्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","खे धि कालापसोङला क्यु। ङा धि कालापसोङ ला मिढो चिचालानाना ङाहि भेला थाल्ला थु पुरा च्युच्युङा मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","हतिबाला जु नाइरे खो गालिलला राङ त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","हिन्नाङ ख्युइ भाइतेबा कालापसोलला पुते खो याङ मनस्याङ ला माना, हिन्नाङ येशु हिबिनहिबिन पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","कालापसोलला यहुदि आङकिङनबे खोला फाकिन त्येतु, राङ “खो काँहा होतो?” नाइरे ढुन्दु। ");
INSERT INTO tcn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","मि झोमयि उइला ख्युइ भारेला ह:लाइ धुलो। रेन नेन धुलो, “खो ल होतो।” स्यानयि नेन्दुलो, माना, “ख्युइ मि तेबाला आच्यामाच्या सुन्दु।” ");
INSERT INTO tcn_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","हिन्नाङ यहुदि आङकिङानतेबा झिरे सुङ धुनला ताम मिनालो। ");
INSERT INTO tcn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","कालापसोलयि उइला येशु मोनलाम क्यासि खिमला नाङला स्युसोङ, राङ छोइ पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","यहुदिबा हा:लाइरे जु नाइसोङ, “च्याङ छोइ मालाबि धि च्हिरु क्याइरे धि झोम छोइ स्येबे?” ");
INSERT INTO tcn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","तेहि येशुयि हतिबाला जवाक तेरिन राङ नाइसोङ, “ङाहि छोइ ङाहि माना, हिन्नाङ कजसुबे ना, सुइ ङाला चाँरे। ");
INSERT INTO tcn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","तेम्बारे सुङ मि कजसुबे धोप्पा ङ्यान्सोम होएना, ङाहि छोइ कजसुबाने ना, कि ङाहि चाने ना खो खुरि हा:कोङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","सुइ रेँ चाने नेन, खो खुरि सम्मान फाकिन, हिन्नाङ सुइ रेँ चोँङान यि सम्मान फाकिन हति तेम्बाना, राङ खोला चुन मेता। ");
INSERT INTO tcn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","च्हि मोशायि खेला ठिम मापिन्सोए? हिन्नाङ खे सुइयाङ हति ठिम मिङ्याना। खे ङाला चिचाला सोए च्युइ किन?” ");
INSERT INTO tcn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","मि झोम यि जवाक पिन्सोङ, “ख्योएला ढे कालदु?” “सुइ ख्योएला सोए च्युइ क्यासुइ?” ");
INSERT INTO tcn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","येशुयि जवाक तेरिन राङ हतिबाला नाइसोङ, “हा:लाइयापयि लाइ झि ङाहि क्याइरे, तेहि खे पोरो हतिला हा:लाइन्दु। ");
INSERT INTO tcn_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","मोशायि खेला खतनायि ठिम पिन्दु (यिनज्याइता हति मोशाने ता माना हिन्नाङ ताङबुइ कानाने ना), तेहि याङ ङालसुइ ङिनला खे मिला खतना किन्दु। ");
INSERT INTO tcn_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","मोशायि ठिम मासि मायोङ नाइरे तेम्बारे मि सुयाङ ङालसुइ ङिनला खतना क्याइ ना, ङाहि ङालसुइ ङिनला मिझि टाक्तु च्युक्ते नाइरे च्हि खे ङाला स्येताङ किनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","च्ये ताइरे माना, हिन्नाङ ल क्याइरे तेम्बा ल अल फे। ");
INSERT INTO tcn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","यरुश्लेमला मि रेनरेनयि नाइसोङ, “च्हि धि खो मानाइ, सुला यहुदि आङकिङानतेबे सोच्याइ फाकिन्दु? ");
INSERT INTO tcn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","तेहि, धिनि मनस्याङ क्याइरे ताम नेन दु, हिन्नाङ हतिबा धिला च्याङ मिना! च्हि धि राङ ख्रिष्ट हिना नाइरे आङकिङानतेबे तेम्बारे हा:कोरेइ? ");
INSERT INTO tcn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","हिन्नाङ जब ख्रिष्ट हुन, खो काँहा होतो नाइरे सुइ याङ हा:मिकुवा।” हिन्नाङ ङेला छ्या होतो धि मि काने लेलेबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","तेहि येशुयि यरुशलेम मोनलाम क्यासि खिमला छोइ लोभि तुइना, ख्युइ क्ये छेया क्याइरे नाइसोङ, “खि ङाला ङोस्येयिन, राङ ङा काने लेलेबाना, हति याङ छ्या होतो। ङा ङारि धोप्पि लेलेबा माना हिन्नाङ सुइ ङाला चाँरे हति तेम्बा ना। खि खोला ङोमिस्येबा ");
INSERT INTO tcn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","हिन्नाङ ङाहि खोला ङोस्येयिन, चिचालानाना ङा खोने लेलेबाना राङ ख्युइ ङाला चाँचाँबाना।” ");
INSERT INTO tcn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","हतिचाला खि खोला सुङज्याइ पाते, हिन्नाङ सुइ याङ लाक्पा माक्याङसोङ, चिचालानाना ख्युइ भेला तरह लेलेबा मेता। ");
INSERT INTO tcn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","हिन्नाङ मि झोमयि मि लेइ ख्युइ थोला हिछे क्याइसोङ। हतिबे नाइसोङ, “जब ख्रिष्ट हुन, हतितुइना च्हि धि क्याक्याइबि धि हा:लाइयापयि लाइले महा हा:लाइयापयि लाइ ख्युइ क्यायोङ ङे च्हि?” ");
INSERT INTO tcn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","मि झोमयि येशुयि भारेला हल्ला क्याक्याइबा फरिसिबे थोइसोङ। तेहि घोबा पुजारितेबा राङ फरिसिबे तुमयि खोला सुङयापयि चाला कोराबातेबे तुम झि चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","येशुयि नाइसोङ, “तरह हाङ टिझिथु ङा खे ङ्याबो हुन, हतिच्येला ङा ङाला चोँङानयि तेहा ढोज्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","खि ङाला फेङान ना हिन्नाङ खुङान मानाना, राङ काँहा ङा हुन, खे हतिया होङ मिङ्युइबा।” ");
INSERT INTO tcn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","तेहि यहुदिबे नाङला नारे क्याइसोङ, “खो काँहा ढोज्याइ लुइ, राङ हु खोला ङान ठेङान माना ना? च्हि खो ग्रिक भजारयि यि उइला थोरते ताताति यहुदिबे तेहा पुते ग्रिकबाला छोइ तेरसोम किन दुये? ");
INSERT INTO tcn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ख्युइ नानाइबि धि वचन चिना? ‘खि ङा ला फेङान ना, राङ खुङान मानाना, राङ काँहा ङा हुन, खे होङ मिङ्युइबा?’” ");
INSERT INTO tcn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","तेहि कालापसोलयि ङिमा च्येमाते, मदलब कालापसोलयि ङोधो ङिनला, लाँरे येशुयि क्ये छोम्मुवाला जु नाइसोङ, “तेम्बारे सुङ खा कोम ना ङाहि तेहा सअ राङ थुङ। ");
INSERT INTO tcn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","सुइ ङाला हिछे क्याइ, पवित्रशास्त्राला नानाइबाला च्वरा क्याइना ‘ख्युइ टोपि तिङने सोम्बो छ्युयि लुङबा थोन्देहुन।’” ");
INSERT INTO tcn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","हिन्नाङ ख्युइ धि ताम पवित्र आत्मायि भारेला नानाइबाना, काङ पवित्र आत्माते ख्युइ थोला हिछे किङानतेबे खुबाला छेलसोङ। चिचालानाना पवित्र आत्मा थाल्ला थु पिपिना मेतालो, चिचालानाना येशुयि छे ङाला थु तेतेका मेतालो। ");
INSERT INTO tcn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","धि ताम थोइङान मि रेन रेनयि जु नाइसोङ, “धिनि तेम्बारे ङोन्सेखिलङान हिना।” ");
INSERT INTO tcn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","स्यानतेबे नाइसोङ, “धि ख्रिष्ट ना।” हिन्नाङ रेनरेनयि नाइसोङ, “च्हि ख्रिष्ट गालिलने हुनाइ च्हि? ");
INSERT INTO tcn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","च्हि पवित्रशास्त्रयि मानाइ दुये च्हि, कि ख्रिष्ट दाउदयि ख्युइने राङ दाउदयि भजार बेथलेहेमने हुन?” ");
INSERT INTO tcn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","हतिचाला येशु चाला मितेबे उइला तुम ङि खा पे सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","हतिबे नाङने चोमयि खोला सुङ च्युइ क्याइसोङ, हिन्नाङ ख्युइ थोला सुइ याङ लाक्पा माक्याङालो। ");
INSERT INTO tcn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","तेहि मोनलाम क्यासि खिमयि कोराबातेबा घोबा पुजारितेबा राङ फरिसितेबे तेहा लेप्सोङ। हतिबे हतिबाला नाइरेलो, “खि हतिला चिचाला माख्योँबा?” ");
INSERT INTO tcn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","कोराबातेबे जवाक पिन्सोङ, “हति मि च्वरा सुइ याङ नामयाङ मानाइसोङ!” ");
INSERT INTO tcn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","फरिसिबे हतिबाला नाइसोङ, “खे याङ ख्युइ तामला भुलि च्युङसुइ कि च्हिरु? ");
INSERT INTO tcn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","च्हि आङकिङान आथावा फरिसिबे नाङने सुइ याङ ख्युइ थोला हिछे क्याइ दुये? ");
INSERT INTO tcn_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","हिन्नाङ धि मिझोम, सुइ मोशायि ठिम हा:मिकुवा, हतिला कजसुबायि छार चुचुबा हुन।” ");
INSERT INTO tcn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","हतिबे नाङने च्हि फरिसि सुइ मिन निकोदेमस ना, सु ताङला लाम्मा झि येशुयि तेहा लेप्सोङ, ख्युइ नाइरेलो, ");
INSERT INTO tcn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“च्हि हुइ ठिमयि ताङस्युवा मिति नानाइबा माना राङ हति च्हि क्याइरे नाइरे हा:माकुवा हतिला दोषि नाज्याइ खुकिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","हतिबे खोला जवाक पिन्सोङ, “च्हि ख्योए याङ गालिलयि हिनाइ? पवित्र शास्त्रा पाते तेहि, राङ तेहि खि थोङान ना, कि गालिलने ङोन्सेखिलङान मिथोना।” ");
INSERT INTO tcn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","तेहि पोरो राँ राँसि खिमला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","हिन्नाङ येशु जैतून सुरला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","खो जब थरह याङ मोनलाम क्यासि खिमला पुइसोङ, राङ मि पोरो ख्युइ तेहा लेप्सोङ, राङ खो त्येसोङ, राङ हतिबाला छोइ पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","शास्त्रि राङ फरिसिबाबे पतारला थेथेबि पोमुवा झिला ख्योँदु, राङ हतिला उइला लाङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","हतिइ येशुला नाइसोङ, “गुरुज्यु, धि पोमुवा पातार कितितुइना सुसुङा ना। ");
INSERT INTO tcn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ठिमला मोशायि धि च्वरा पोमुवाला टोउ क्याप नाइरे हुला आदेश च्युतु ख्योए धि भारेला च्हि नाज्याइ?” ");
INSERT INTO tcn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","हिन्नाङ हतिबे खोला छोए तायापला राङ ख्युइ थोला आरोप जुयाप ङ्युइन नारे जु नाइरेलो। येशुयि साला क्हुरकुर क्याइरे झुयि टिसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","हिन्नाङ जब ख्होए येशुला ढिन राङ ताताता होतो, हतितुइना ख्युइ लाँरे हतिबाला नाइसोङ, “खि नाङने सु तिक्पा माक्याइबा होए हति राङ धि पोमुला ताङस्युवा टोउ क्योप।” ");
INSERT INTO tcn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","याङ ख्युइ कुरकुर क्याइरे साला झुयि टिसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","हिन्नाङ जब हतिबे धि थोइरे, हतितुइना छोम्मुवाने सुरु क्याइरे टिमा थु च्यिच्यि क्याइरे पुइसोङ, राङ येशुला हति पोमु ङ्याबो चिक्पा पोरसोङ, तेहि हति पोमुते ख्युइ धुन्नला लाँरे त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","येशुयि हति पोमुला ताइरे नाइसोङ, “ए पोमु हतिबा काँहा पुइसुइ? च्हि सुयाङ ख्योएला ङेबा मापिन्सोए?” ");
INSERT INTO tcn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","हति नाइसोङ, “प्रभु, सुइ याङ मा पिन्सोङ।” येशुयि नाइसोङ, “ङा ख्योएला ङेबा मितेर। कु, याङ तिक्पा माके।” ");
INSERT INTO tcn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","येशुयि याङ हतिबाला नाइसोङ, “ङा संसारयि होए ना। ङाहि च्येच्येला होङान मुन्नाला युङान मानाना, हिन्नाङ हतिला मिजेयि होए खुङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","तेहि फरिसिबे खोला नाइसोङ, “ख्योए खुरि भारेला साछि तेरिन्दु। ख्युइ साछि तेम्बा मिहा।” ");
INSERT INTO tcn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","येशुयि जवाक पिन्सोङ, “ङा ङारि भारेला साछि तेरच्याइ, हिन्नाङ ङाहि साछि तेम्बा ना। ङाला छ्या होतो, ङा काने लेलेबा ना, राङ का ढोयाप ना। हिन्नाङ खेला छ्या मेता ङा काने लेलेबाना, राङ काँहा ढोयाप ना।” ");
INSERT INTO tcn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","खे मि लुलामने ल अल भिन्दु। ङा सुलाङ ल अल भेयापयि लाइ मिकिता। ");
INSERT INTO tcn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ङाहि ल अल भेयापयि लाइ क्याइना, ङाहि ल अल भेयापयि लाइ तेम्बा मिहा। चिचालानाना ल अल भेयापयि लाइ किङान ङा चिक्पा मेता, हिन्नाङ ङा होतो, राङ ङाला चोँङान आके होतो। ");
INSERT INTO tcn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","खि या ठिमला मि ङाहि साछि तेम्बा हुन नाइरे टिटिबादु। ");
INSERT INTO tcn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ङाहि भारेला ङा ङाराङ साछि तेरच्याइ, राङ ङाला चोँङानयि आकेयि ङाहि भारेला साछि तेरिन। ");
INSERT INTO tcn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","हतिबे खोला नाइसोङ, “ख्युइ आके काँहा होतो?” येशुयि जवाक पिन्सोङ, “खि न ङाला ङोस्येयिन न ङाहि आकेला। खि ङाला ङो स्येस्येबा हिन ना ता ङाहि आकेला हाङ ङोस्येङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","धि ताम ख्युइ मोनलाम क्यासि खिमला छोइ लोबितुइना आलाइ तुइङान दान तोङानयि धुनला नानाइबा ना। तेहि सुइ याङ खोला मा सुङङा, चिचालानाना येशु भेला तरह लेलेबा मेता। ");
INSERT INTO tcn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","येशुयि याङ हतिबाला नाइसोङ, “ङा ढो छारच्याइ, राङ खि ङाला फेङान ना, खे खिरि तिक्पाला स्यिङान ना। काँहा ङा होतो, खे होङ मि ङ्युइबा।” ");
INSERT INTO tcn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","यहुदि आङकिङानबे नाइसोङ, “धिनि खो राङ रेँ राङला स्योएङान यिनटा कि च्हिरु? चिचालानाना ‘खो काँहा ढुन खे होङ मिङ्युइबा’ नाइरे नेन्दु।” ");
INSERT INTO tcn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","तेहि येशुयि हतिबाला नाइसोङ, “खे हकिना। ङा कोङी ना। खे धि संसारयि ना। ङा दु संसार यि माना। ");
INSERT INTO tcn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ङाहि खेला नाइरे, ‘खे खेरि तिक्पाला स्यिङान ना, चिचालानाना ङा हति राङ ना नाइरे खि हिछे माक्याइना खिरि तिक्पाला स्यिङान ना।’” ");
INSERT INTO tcn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","हतिबे येशुला टिसोङ, “ख्योए सुना?” येशुयि हतिबाला नाइसोङ, “ङा हति राङ ना, काङते ङाहि खेला ताङलाने राङ नेन ताता होतो। ");
INSERT INTO tcn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ङाहि खि भारेला ल अल भेयाप राङ समलो तोङयाप लेइराङ होतो हिन्नाङ ङाला चोँङान तेम्बा होतो, राङ ख्युइ चाने ङाहि च्हि थोइ संसारला हति ताम राङ नेन।” ");
INSERT INTO tcn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","आकि भारेला येशुयि नानाइबा हिना नाइरे हतिबे हा:माकुवा। ");
INSERT INTO tcn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","हतिचाला येशुयि नाइसोङ, “जब खि मि पिजा याला धेकिन, ङा हति राङ हिना नाइरे हा:कोङान्ना, राङ ङा ङारि आङ यि च्याङ मिकिता हिन्नाङ आकि लालाबि तामतेबा नेन नाइरे ङाला छ्या होतो। ");
INSERT INTO tcn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ङाला चोँङान ङा ङ्याबो होतो। ख्युइ ङाला चिक्पा पोपोरा मेता चिचालानाना ङा बारतै ख्युइ सम क्याप यि लाइ मात्रा किन।” ");
INSERT INTO tcn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","येशुयि धि ताम नेतुइना ता ङ्यान ङान लेइराङयि ख्युइ थोला हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","येशुयि खुरि थोला हिछे किङान यहुदिबाला नाइसोङ, “खे ङाहि वचनला त्येना ङाहि तेम्बा लोब्टु ना। ");
INSERT INTO tcn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","तेहि खि तेम्बा च्हि ना नाइरे हा:कोङान ना, राङ तेम्बि खेला मनस्याङ सोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","हतिबे खोला जवाक पिन्सोङ, “ङे अब्राहामयि ख्युइ ना, राङ ङेला थाल्ला थु सुइयाङ यक्पुवा च्युङदे ताताता मेता। ‘खे मनस्याङ होङान ना’ नाइरे च्हिरु क्याइरे नेन?” ");
INSERT INTO tcn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","येशुयि हतिबाला जवाक पिन्सोङ, “तेम्बारे, ङा खेला नाज्याइ, तिक्पा किङान पोरो तिक्पि यक्पुवा ना। ");
INSERT INTO tcn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","यक्पुवा बारतै खिमला मितोता हिन्नाङ पिजा ते बारतै खिमला तोकिन। ");
INSERT INTO tcn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","हतिचाला पिजि खेला मनस्याङ सोइना खे तेम्बारे मनस्याङ होङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ङाला छ्या होतो, खे अब्राहामयि ख्युइ ना। हिन्नाङ खे ङाला सोच्याइ फाकिन्दु, चिचालानाना ङाहि वचनला खि तेहा त्योएसा मिखुबा। ");
INSERT INTO tcn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","काङकाङ ङाहि ङारि आके होतोला थोथोवा होतो, हति ङा नेन। खे याङ च्हि खि आकेने थोइ, हति किन।” ");
INSERT INTO tcn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","हतिबे खोला नाइसोङ, “ङाहि आके नि आब्रहाम हिना।” येशुयि हतिबाला नाइसोङ, “खे आब्रहमयि मि हिन नाता, अब्राहामयि च्हि लाइ क्याइ हति किङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ङाहि कजसुबाने तेम्बा थोथोइबाते खेला नानाइबा होए, हिन्नाङ थाल्ला खे ङाला सोच्याइ फाकिन्दु। अब्राहाम धि च्वरा लाइ माक्याइबा। ");
INSERT INTO tcn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","खि आकि च्हि लाइ क्याइ खि याङ हति लाइ किन।” हतिबे खोला नाइसोङ, “ङा पातान्नि च्युङदे क्येक्येबा माना! ङाहि आके च्हि राङ होतो, हति कजसुबाना।” ");
INSERT INTO tcn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","येशुयि हतिबाला नाइसोङ, “कजसुबा खि आके हिना ता खि ङाला करि क्यायोङ ना, चिचालानाना ङा कजसुबाने थोथोना ना। ङा ङारि धोप्पि लेलेबा माना, हिन्नाङ ख्हुइ ङाला चाँचाँबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ङाहि नानाइबा खि चिचाला हा:मिकुवा धुइ? चिचालानाना खि ङाहि वचन ङ्यान मिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","खे खिरि आके दियाबलसयि ना, खे खिरि आकि धोप्पा पुरा कियापला ख्युइ च्हि धोप्पा किन हति किन। खो ता ताङलाने राङ मिसोए हिना, राङ तेम्बा ङ्याबो खोला च्याङ मदलब मेता। चिचालानाना हतिला च्याङ तेम्बा मेता। जब खो चुन नेन, हति खुरि बानि च्वरा क्याइरे नेन। चिचालानाना हति चुन ना राङ चुनयि आके ना। ");
INSERT INTO tcn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ङा तेम्बा नेन, हिन्नाङ खे ङाला हिछे मिकिता। ");
INSERT INTO tcn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","खि नाङने सुइ ङाला तिक्पि दोषि नाङ्युइकिन? तेम्बारे ङा तेम्बा नाना चिचाला खे ङाहि थोला हिछे मिकिता? ");
INSERT INTO tcn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","सु कजसुबाने हुन, हति कजसुबे वचन ङ्यानकिन हिन ज्याइता खे कजसुबाने माना, हतिचाला खे मिङ्याना।” ");
INSERT INTO tcn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","यहुदिबे खोला जवाक पिन्सोङ, “च्हि ङाहि धि नानाइबा तेम्बा मानाइ, कि ख्योए सामरि ना राङ ख्योएला ढे कालदु?” ");
INSERT INTO tcn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","येशुयि जवाक पिन्सोङ, “ङाला ढे क्याकाला मेता, हिन्नाङ ङा ङारि आकि सम्मान किन, राङ खे ङाहि सम्मान किन्दु। ");
INSERT INTO tcn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","हिन्नाङ ङा ङारि छे मिफाता, च्हि होतो सुइ खुरि छे फाकिन राङ ल अल भेयापयि किन। ");
INSERT INTO tcn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","तेम्बारे ङा खेला नाज्याइ, तेम्बारे सुइ ङाहि वचन ङ्यान हति नामयाङ मिसिया।” ");
INSERT INTO tcn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","यहुदिबे खोला नाइसोङ, “ता ङेला छ्या च्युङसोङ, ख्योएला ढे कालदु। अब्राहाम स्यिरे पुइसोङ, ङोन्सेखिलङान याङ स्यिसोङ, हिन्नाङ ख्योए नेन्दु, ‘सु ङाहि वचन ङ्यान हति नामयाङ मिसिया नाइरे।’ ");
INSERT INTO tcn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","च्हि ङाहि ताङबुइ अब्राहामले ख्योए छेया हिनाइ? खो स्यिरे पुइसोङ, तेहि ङोन्सेखिलङान याङ स्यिरे पुइसोङ। ख्योए ते ख्योराङ सु हिना नाइरे दाबि किन?” ");
INSERT INTO tcn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","येशुयि जवाक पिन्सोङ, “तेम्बारे ङा ङारि छे त्येना ङाहि छे तेतेका फान मिहा। ङाहि छे धेङान ङाहि आके होतो, काङला खि ङाहि कजसुबा नेन। ");
INSERT INTO tcn_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","खि खोला जब याङ ङोस्येस्येबा मेता, हिन्नाङ ङाहि खोला ङोस्येयिन। ङाहि खोला ङोमिस्येबा नाइना ङा खे च्वरा चुन हुन। हिन्नाङ ङाहि खोला ङोस्येयिन, राङ ख्युइ वचन ङ्यान किन। ");
INSERT INTO tcn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","खि ताङबुइ अब्राहाम ङाहि धि ङिन थोङज्याइला क्याका होतो, राङ ख्युइ थोङसोङ राङ कारे।” ");
INSERT INTO tcn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","हतिचाला यहुदिबे खोला नाइरेलो “ख्योए तरह लो ङोपच्यु माक्योबि, चिला अब्राहामला थोङसोङ नेन?” ");
INSERT INTO tcn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","येशुयि हतिबाला नाइसोङ, “तेम्बारे ङा खेला नाज्याइ, अब्राहामले होङ ज्याइले ताङला राङ ङा होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","तेहि हतिबे खोला क्याकच्याइ नाइरे टोउ तुरेलो, हिन्नाङ येशु हिप्ते मोनलाम क्यासि खिमने फिला थोन्दे पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","हतिने ढुन ताताताला येशुयि क्येने राङ काना झिला थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ख्युइ लोब्टुबे खोला टिसोङ, “गुरुज्यु, सुइ तिक्पा क्याइरे, धि कि धिबे आके आमायि, राङ धि काना च्युङदे?” ");
INSERT INTO tcn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","येशुयि जवाक पिन्सोङ, “न त धि तिक्पा क्याइरे न त धि आके आमायि, हिन्नाङ धि चाला च्युङदे कि कजसुबे लाइ धि मि मिजेला सअ नाइरे। ");
INSERT INTO tcn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","जब थु ङिन होतो हति थु हु राङला चोङानयि लाइ कि कोयिन, छान स्यारिन दु स्यान सुइ याङ लाइ कि मिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ङा संसारला होएहोए थु ङा संसारयि होए ना।” ");
INSERT INTO tcn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","धि ताम नाइरे ख्युइ साला छिमा ताप्सोङ, राङ छिमायि साबे च्हिरे धाबा स्यिरे हति मिला कुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","तेहि ख्युइ हतिला नाइसोङ, “कु, सिलोआमयि चाँचाँबि चिङला पुते स्योल।” हति पुते टिसो राङ थोङान च्युङदे लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","हति खिमजे राङ हतिला लोङमा लोङान थोङानतेबे नाइसोङ, “ताते लोङान ते धि मानाइ च्हि?” ");
INSERT INTO tcn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","रेनरेनयि नाइसोङ, “धि हति राङ ना।” “स्यानतेबे नाइसोङ, माना, हति च्वरा थोङिन्दु।” हति नाइसोङ, “ङा हति राङ ना,” ");
INSERT INTO tcn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","तेहि हतिबे हतिला टिसोङ, “ख्युइ मि ख्योए च्हिरु क्याइरे थोङ ङ्युइङान च्युङसुइ?” ");
INSERT INTO tcn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","हति जवाक पिन्सोङ, “येशु नाङान मि झिकि साबि धाबा सोइरे थाहि मिला कुइरे ङाला नाइसोङ, ‘सिलोआमला कु राङ सोल।’ तेहि पुते ङाहि टिरे, तेहि ङा तोङान च्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","हतिबे हतिला नाइसोङ, “खो का धुइ?” हति नाइसोङ, “ङाला छ्या मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","तेकि काना होएता हति मितेला हतिबे फरिसिबे तेहा ख्योँदु सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","काङ ङिन येशुयि साबि धाबा मिला कुइरे मि प्येसुइ हति ङिनते ङालसुइ ङिन हिना। ");
INSERT INTO tcn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","फरिसिबे हतिला टिसोङ, “ख्योए च्हिरु क्याइरे थोङान च्युङसुइ?” हति हतिबाला नाइसोङ, “ख्युइ ङाहि मिला साबि धाबा कुइसोङ, तेहि ङाहि स्यालदे राङ थोङान च्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","फरिसिबे नाङने रेनरेनयि नाइसोङ, “हति मि कजसुबाने लेलेबा माना, चिचालानाना हति ङालसुइ ङिन मानि मिकिता” हिन्नाङ स्यानतेबे नाइसोङ, “च्हिरु क्याइरे तिक्पा किङान मिबे धि च्वरा हा:लाइयापयि लाइ किङ्युइ किन?” राङ हतिबे उइला पेयाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","हतिबे हति मि कानाला याङ टिसोङ, “ख्हुइ ख्युइ मि पेदु, ता ख्योए ख्युइ भारेला च्हि नाज्याइ?” हति जवाक पिन्सोङ, “खो ङोन्सेखिलङान मि ना।” ");
INSERT INTO tcn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","मि पेपेयि आके आमाला मा ख्योँरे मा टि थु यहुदिबे खो मि काना हिना राङ थोङान च्युङदे नाइरे हिछे मा क्याइबालो। ");
INSERT INTO tcn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","तेहि हतिबे हतिबाला टिसोङ, “च्हि धि खि च्यिबा हिनाइ स्यु काना क्येक्येबा होतो नारे खे नेन्दु? ता खो च्हिरु क्याइरे थोङान च्युङसुइ?” ");
INSERT INTO tcn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","हति आके आमायि हतिबाला नाइसोङ, “ङेला छ्या होतो धि ङाहि पिजा हिना, राङ काना राङ क्येक्येबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ता धि च्हिरु क्याइरे थोङान च्युङदे नाइरे ङेला छ्या मेता, धि मि सुइ पेरे ङेला छ्या मेता। ख्युइ लो छाँछाँ होतो खोराङ ला टि। खुरि भारेला खो खोराङ नाङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ख्युइ आके आमायि धि ताम नाइसोङ, चिचालानाना हतिबा यहुदि आङकिङानला झियिनलो। चिचालानाना सुइ याङ हतिला ख्रिष्ट हिना नाइरे ङ्यान ना, हतिला यहुदि झोमसि खिमने धोन कोकिन नाइरे यहुदिबे तेकि राङ रुताम क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","हतिचाला हति आके आमायि नाइसोङ, “ख्युइ हा:कोङान च्युङ छाछारा होतो, धि राङ ला टि।” ");
INSERT INTO tcn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","हतिबे हति मिला सु क्येने राङ काना होतो, याङ लक्ते सह नाइरे, हतिला नाइसोङ, “कजसुबायि धुनला नाक्योल कि ख्योए तेम्बा ताम नाज्याइ! ङेला छ्या होतो कि हति पिजा सुइ ख्योएला थारका सोइरे हति राङ तिक्पा किङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","हति जवाक पिन्सोङ, “खो तिक्पा किङान हिना कि माना ङाला छ्या मेता। ताम झि मात्रा ङाला छ्या होतो कि ङा काना होतो, हिन्नाङ ता थोङान च्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","तेहि हतिबे खोला नाइसोङ, “हति ख्योएला च्हि क्याइ सुइ? ख्हुइ ख्युइ मि च्हिरु क्याइरे पेसुइ?” ");
INSERT INTO tcn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","हति हतिबाला जवाक पिन्सोङ, “ङाहि खेला तेकि राङ नाइछारते, हिन्नाङ खि माङ्यानसोङ। ता याङ चिचाला ङ्यान्सोम हुन्दुइ? खे याङ ख्युइ लोब्टु होङ सोम हुन्दुये कि च्हिरु?” ");
INSERT INTO tcn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","हतिबे हतिला ङारकिन राङ नाइसोङ, “ख्योए पु ख्युइ लोब्टुना, हिन्नाङ ङेता मोशायि लोब्टु ना। ");
INSERT INTO tcn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ङेला छ्या होतो मोशा ङ्याबो कजसुबे ताम नाइरे, हिन्नाङ ङेला छ्या मेता धि मिते सुना।” ");
INSERT INTO tcn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","हति मि हतिबाला जवाक तेरिन राङ नाइसोङ, “हा:लाइयापयि ताम! खो काने लेलेबा ना ता खेला छ्या मेता हिन्नाङ ङाहि मि ख्युइ प्येसुइ। ");
INSERT INTO tcn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ङेला छ्या होतो कि कजसुबे मि तिक्पा किङानयि ताम मिङ्याना हिन्नाङ कजसुबाला झिङान राङ ख्युइ धोप्पा ङ्यानङानयि मि ताम कजसुबे ङयान किन। ");
INSERT INTO tcn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","संसार सुरु च्युङने राङ थाल्ला थु क्येने राङ कानायि मि पेपेयि ताम नामयाङ माथोइ। ");
INSERT INTO tcn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","तेम्बारे धि मि कजसुबाने लेलेबा अर्थात धि च्याङ कि मिङ्युइबा।” ");
INSERT INTO tcn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","हतिबे खोला जवाक तेरिन राङ नाइसोङ, “ख्योए ता तिक्पाला राङ क्येक्येबाना, राङ च्हि ता ख्योए ङेला लोप्सोम हुनदुये?” तेहि हतिबे खोला फिला तोन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","हतिबे हतिला फिला तोन्सोङ नाङानयि ताम येशुयि थोइसोङ, राङ हतिला ठाते नाइसोङ, “च्हि ख्योए मि पिजि थोला हिछे किनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","हतिला जवाक तेरिन राङ नाइसोङ, “प्रभु, खो सुना? ङा ख्युइ थोला हिछे किच्याइ?” ");
INSERT INTO tcn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","येशुयि हतिला नाइसोङ, “ख्युइ खोला थोथोङा होतो, तेहि ख्योए ङ्याबो ताम नाङान हति राङ ना।” ");
INSERT INTO tcn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","तेहि हति नाइसोङ, “प्रभु, ङा हिछे किन,” राङ हति खोला काङबाला छ्या क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","तेहि येशुयि नाइसोङ, “ङा ल अल भेयापयि चाला धि संसारला लेप्ते, कि मिथोङानतेबा थोङान राङ थोङान तेबा मिथोङान हुन नाइरे।” ");
INSERT INTO tcn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","धि ताम थोइरे ख्युइ धुनला होएता फरिसि रेनरेनयि नाइसोङ, “च्हि ङे हाङ काना हिनाइ च्हि?” ");
INSERT INTO tcn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","येशुयि हतिबाला नाइसोङ, “खे काना हिन नाता तिक्पि दोषि होङान माना ना, हिन्नाङ ङि थोङिन दु, नेन्दु, हतिचाला खि तिक्पा ताताति ताताता किन।” ");
INSERT INTO tcn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","येशुयि नाइसोङ, “तेम्बारे, ङा खेला नाज्याइ, काङ लु राहायि कोने नाङला मिसुबा, हिन्नाङ स्यानयोने झिरे स्युयिन, हतिते कुम्मा राङ डाकुना, ");
INSERT INTO tcn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","हिन्नाङ कोने नाङला स्युङानते लुयि रच्चिया ना। ");
INSERT INTO tcn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","को भेङानयि ख्युइ चाला को भिन, राङ लु तेबे ख्युइ क्ये ङ्यान किन राङ ख्युइ खुरि रेँ लु तेबाला मिन नेननेन क्ये तोङिन, तेहि हतिबाला फिला खेरिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","जब ख्युइ खुरि लु पोरोला फिला तोन्दे खेरिन, खो हतिबे ताङताङला ढुन, राङ लु तेबे ख्युइ क्यापला हुन, चिचालानाना हतिबे ख्युइ क्ये ङोस्येयिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","हिन्नाङ ङो मिस्येङानयि क्यापला हतिबा मिढुवा, हिन्नाङ हति टोइरे ढुनलो। चिचालानाना ङो मि स्येङानयि मि क्ये ङोमिस्येबालो” ");
INSERT INTO tcn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","येशुयि हतिबाला हति प्ये नाइसोङ, हिन्नाङ ख्युइ हतिबाला नानाइबि तामयि तोन हतिबे हा:माकुवलो। ");
INSERT INTO tcn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","हतिचाला येशुयि याङ हतिबाला नाइसोङ, “तेम्बारे, ङा खेला नाज्याइ, लुबे को ङाराङ ना। ");
INSERT INTO tcn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ङाले ताङला होङान पोरो कुम्मा राङ डाकु ना, हिन्नाङ लुबे हतिबे ताम ङ्यानङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","को ङाराङ ना, तेम्बारे सु मि याङ ङाने नाङला स्युना हति सोनङान ना, राङ नाङ फि किङान ना, राङ कोप्पोला छोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“कुम्मानि कुरु, सोतु राङ मासि सोरु मात्रा होङान ना। ङानि खेला मिजे खुहोङ राङ हति लेइराङला खुहोङ नाइरे लेलेबा ना।” ");
INSERT INTO tcn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ङा ल रच्चिया ना। ल रच्चियायि रेँ लुयि चाला उ तेरिन। ");
INSERT INTO tcn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","आलाइ पिन्दे ख्योख्योबि मिते लुयि मिते लु खुरि रच्चिया च्वरा माना। हतिता वाजे लेलेबा थोङसोङ लुबाला पोरते ढुन, राङ वाजे ल तेबाला गाजिला खेरिन, राङ कार च्युङच्युङला चोँङिन। ");
INSERT INTO tcn_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","हति टोइरे ढुन, चिचालानाना हति आलाइ पिन्दे ख्योख्योबि मिना, हति लुला ल क्याइरे मिता। ");
INSERT INTO tcn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“ङा ल रच्चिया ना, ङाहि ङारि लुला ङोस्येयिन, तेहि ङाहि लुयि ङाला ङोस्येयिन। ");
INSERT INTO tcn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","च्हिरु क्याइरे आकि ङाला ङोस्येयिन, ङाहि याङ आकेला ङोस्येङान ना, तेहि लुबे चाला ङारि उ तेरच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","“ङाहि लु स्यान याङ हति, काङते धि रायि माना। हतिबा लाङ ङाहि ख्योँङ कोहिि दु, राङ हतिबे ङाहि क्ये ङ्यानङान ना, राङ हतिबे तुमझि होङान ना, राङ रच्चिया झिला त्योएङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","आकि ङाला हति चाला करि किन, चिचालानाना ङा ङारि, मिजे याङ लक्ते ख्योङ ङ्युइकिन नाइरे तेरिन।” ");
INSERT INTO tcn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","सुइ याङ ङाहि चाने ङाहि मिजे खेर मिङ्युइबा हिन्नाङ ङा ङारि धोप्पि ङारि उ तेरिन। ङा ङारि उ तेरयापयि आङ ङाला होतो, तेहि ख्योङयापयि आङ याङ ङाला होतो। धि आदेश ङाहि आकेने खुँखुँबाना। ");
INSERT INTO tcn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","धि वचनयि चाला याङ यहुदिबे उइला खा पेसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","हतिबे नाङने लेइराङ यि नाइसोङ, “धिला ढे कालदु राङ धि ङ्युन दु। खे धि ताम च्हिला ङ्यान किन?” ");
INSERT INTO tcn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","स्यान तेबे नाइसोङ, “ढे कालयापयि ताम धि च्वरा मिहा। च्हि ढेयि मि कानायि मि भे ङ्युइकिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","यरुश्लेमला मोनलाम क्यासि खिमला कजसुबाला चिगा भुलयापयि कालापसोलयि भेला हिना। हति कुङघायि भेला हिना ");
INSERT INTO tcn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","येशु मोनलाम क्यासि खिमयि नाङला सोलोमनयि क्यला ढुनतेतुलो। ");
INSERT INTO tcn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","यहुदिबे ख्युइ फालाछुला पोरोला ताते टिसोङ, “जब थु ख्योए ङेला आच्यामाच्याला भोर च्याइ? ख्योए ख्रिष्ट हिन्ना ङेला ल क्याइरे नोइ।” ");
INSERT INTO tcn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","येशुयि हतिबाला जवाक पिन्सोङ, “ङाहि खेला नाइ छाछारा होतो हिन्नाङ खे हिछे मिकिता। ङाहि आकि मिनला ङा च्हि लाइ क्ये हति राङ साछि तेरिन।” ");
INSERT INTO tcn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","हिन्नाङ खे हिछे मि किता चिचालानाना खे ङाहि लुबे नाङने माना। ");
INSERT INTO tcn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“ङाहि लुबे ङाहि क्ये ङ्यानकिन राङ हतिबे ङाला ङोस्येयिन, राङ हतिबा ङाहि च्येला हुन। ");
INSERT INTO tcn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","हतिबाला ङा नामयाङ मिसिनयापयि मिजे तेरच्याइ, राङ हतिबा नामयाङ मासि मिहा, राङ सुइ याङ हतिबाला ङाहि लाने खेर मिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ङाहि आकि ङाला पिपिना होतो; खो पोरोले छेयाना। आकि लाने सुइयाङ खेरमिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","आके राङ ङा च्हिराङ ना।” ");
INSERT INTO tcn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","यहुदिबे धि ताम थोइरे च्येला याङ येशुला क्याकच्याइ नाइरे टोउ तुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","येशुयि हतिबाला नाइसोङ, “ङाहि खेला ङाहि आकि चाने लेइराङ लाइ ल तान्दे, हति नाङने काङ लाइयि चाला ङाला खे टोउ क्याकच्याइ?” ");
INSERT INTO tcn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","यहुदिबे येशुला जवाक पिन्सोङ, “लाइ लयि चाला ङे ख्योएला टोउ मिक्याका हिन्नाङ कजसुबाला अल नानाइबि चाला चिचालानाना ख्योए मि च्युङदे हाङ ख्योराङ ला कजसुबा नेन्दु।” ");
INSERT INTO tcn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","येशुयि हतिबाला जवाक पिन्सोङ, “ठिमला टिटिबा धु, कजसुबा नेन्दु खे ला ना। ");
INSERT INTO tcn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ङेला छ्या होतो कि पवित्रशास्त्रा च्हि नेन हति बारतै तेम्बा हुन: हतिबाला कजसुबायि ला नाइरे सुला ख्युइ लोन पिन्दे।” ");
INSERT INTO tcn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ख्युइ भारेला च्हि, सुला रेँ पवित्र सोइरे कुरु पोरते राङ संसारला चाँरे? याङ ख्योए ङाला चिला ला ना च्योकिन्दु नाइरे आरोप लाइ किन चिचालाना ङाहि नाइरे, “ङा कजसुबे पिजा ना।” ");
INSERT INTO tcn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","तेम्बारे ङाहि आकि धोप्पा क्याक्याइबा लाइ ङाहि मकाइना ङाला हिछे माके। ");
INSERT INTO tcn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","हिन्नाङन “तेम्बारे ङा आकि लाइ किन राङ ङाहि थोला हिछे मिकिना धि लाइतेबे थोला हिछे कि, राङ खि हा:कोङान ना, कि आके ङाला होतो, राङ ङा आकेला।” ");
INSERT INTO tcn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","हतिबे याङ खोला सुङ ज्याइयि च्युइ क्याइसोङ हिन्नाङ खो हतिबे लाने थारसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","तेहि याङ येशु यर्दन चाङबोयि यि फारकानला हति साला पुइसोङ, काँहा युहान्नाले ताङला बप्तिसमा तेरिनलो, राङ खो हतिया त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","मि लेइराङ ख्युइ तेहा होङाला छेलसोङ, युहान्नायि च्याङ हा:लाइयापयि लाइ माक्याइसोङ राङ “युहान्नायि ख्युइ भारेला च्हि नाइ हति पोरो तेम्बा ना।” ");
INSERT INTO tcn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","तेहि हतिया लेइराङ मियि येशुयि थोला हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","लाजारस मिन क्याक्याइबा नाप्पा मिझि होतो। हति मरियम राङ ख्युइ इझि मार्थायि युल बेथानियायि हिना। ");
INSERT INTO tcn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","प्रभुला अत्तर कुइरे ख्युइ काङबा फिङान मरियम धि राङ हिना। हति भाइ लाजारस नाप्पा हिना। ");
INSERT INTO tcn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","हति इझि ङिबुइ येशुयि तेहा जु नाइरे लोन कुरसोङ, “प्रभु, सुला ख्योए करि किन, हति नाप्पा दु।” ");
INSERT INTO tcn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","हिन्नाङ धि थोइरे येशुयि नाइसोङ, “धि नानाइबि सिरु काल थु मिखेरा, हिन्नाङ धि कजसुबे छे धेयापयि चाला ना, तेहि धि ने कजसुबे पिजायि छे तेतेका होङ।” ");
INSERT INTO tcn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","येशुयि मार्था, मुइ भैनि राङ लाजारसला करि किनलो, ");
INSERT INTO tcn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","हति हिन्नाङ लाजारस नाप्पा होतो नाइरे थोइरे हाङ खो काँहा होतो, हतिया, तरह ङिन ङि येशु हतिया राङ तातेलो। ");
INSERT INTO tcn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","हतिच्येला ख्युइ लोब्टुतेबाला नाइरेलो, “ल, ता याङ हु यहुदियाला लक्ते क्यु।” ");
INSERT INTO tcn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","लोब्टुबे खोला नाइसोङ, “गुरुज्यु, थाल्ला काँहा यहुदिबे ख्योएला टोउ क्याकच्याइ प्येसुइ, राङ च्हि ख्योए याङ हतिया राङ ढो च्युइ फाकिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","येशुयि जवाक पिन्सोङ, “च्हि ङिनला घण्टा च्युनङि मिहाइ? ङिम्मु ढोज्याइला नातो मिक्याका, चिचालानाना हति धि संसारयि होए थोङिन। ");
INSERT INTO tcn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","हिन्नाङ छाम्मु फाला छुलो किच्याइला नातो क्याकिन, चिचालानाना हति मिला साल्बो मिहा।” ");
INSERT INTO tcn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","हतिच्येला येशुयि हतिबाला नाइसोङ, “हुइ रबो लाजारस ङि टोदुलो, हिन्नाङ ख्युइ ङि सोतु ङा हतिया ढोज्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","लोब्टुतेबे खोला नाइसोङ, प्रभु, “खो ङि टोदु नाइना खो टाकिनाइ।” ");
INSERT INTO tcn_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","येशुयि हति स्यिस्यियायि भारेला नानाइबा हिना, हिन्नाङ हतिबे च्युका उलतोएला च्वरा ङि टोटुवा हिना नाइबा क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","येशुयि हतिबाला ल क्याइरे नाइरेलो, “लाजारस स्यिदु। ");
INSERT INTO tcn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","खि हिछे क्यायोङ नाइरे खि चाला ङा हतिया मेता ला ङा क्याका होए, च्हि हिन्नाङ हु हतिया ढो।” ");
INSERT INTO tcn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","तेहि दिदुमास नाङान थोमायि खुरि तुमयि लोब्टुतेबाला नाइसोङ, “ल, हुङ ढो, राङ खो ङ्याबो स्यिया।” ");
INSERT INTO tcn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","जब येशु क्योपते, तेहि लाजारसला तुरला पोरते ङिन सि पुइतु। ");
INSERT INTO tcn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","बेथानिया यरुश्लेमयि धुला हा:लाम किलोमिटर सुम घ्याबोला धुलो। ");
INSERT INTO tcn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","यहुदि लेइराङ मार्था राङ मरियमयि तेहा हतिबे भाइयि भारेला मोला छिमा फिक्तु लेप्तुलो। ");
INSERT INTO tcn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","येशु हुनतेतु नाइरे थोइरे मार्था पुइसोङ, राङ खोला ठातेलो। हिन्नाङ मरियम खिमला राङ तातेलो। ");
INSERT INTO tcn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","तेहि मार्थायि येशुला नाइसोङ, “प्रभु, ख्योए ङिहा होतो नाना ङाहि भाइ मास्यि होएरो।” ");
INSERT INTO tcn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","हिन्नाङ ङाला छ्या होतो, ख्युइ कजसुबाला च्हि लाँ, कजसुबायि हति तेरकिन। ");
INSERT INTO tcn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","येशुयि मोला नाइसोङ, “ख्युइ भाइ याङ सोम्बो हुन।” ");
INSERT INTO tcn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","मार्थायि खोला नाइसोङ, “ङाला छ्या होतो, कि सिनि ङिनयि चाला याङ सोम्बो च्युङदे लाँयिन।” ");
INSERT INTO tcn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","येशुयि हतिला नाइसोङ, “स्यिरे लाँङान राङ मिजे ङाराङ ना। ङाला हिछे किङान स्यि नाङ सोम्बो हुन। ");
INSERT INTO tcn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","तेहि सोनङान राङ ङाहि थोला हिछे किङान नामयाङ मिस्यिया। च्हि ख्योए धि हिछे किनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","मुइ येशुला नाइसोङ, “प्रभु, ङा हिछे किन, ख्योए संसारला होङान ख्रिष्ट, कजसुबे पिजा ना।” ");
INSERT INTO tcn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","होचोम नाइरे मार्था पुइ छारसोङ, राङ मुरि भैनि मरियमला चामाना क्ये ताङदे नाइसोङ, गुरुज्यु; लेप्छारसोङ, “राङ ख्योएला क्ये तोङिन्दु।” ");
INSERT INTO tcn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","धि थोइरे मरियम हो:प्तामेला लाँरे ख्युइ तेहा पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","हति थुहाङ येशु युलाला लेप्छाछारा मेतालो, हिन्नाङ खो हतिया राङ धुलो काँहा मार्थायि खोला ठातु लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","खिमला छिमा फिक्तु होङान यहुदिबे मरियम हो:प्तेमेला लाँरे फिला पुपुता थोङसोङ, मो हति तुरला ङुरु पुते नाइबा क्याइरे, मुइ च्येला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","जब मरियम येशु होएते साला लेप्ते, राङ खोला थोङसोङ, तेहि जु नेनराङ ख्युइ काङबाला टाला च्यार सोङ, “हे प्रभु, ख्योए ङिया होतो नाना ङाहि भाइ मास्यि होएरो।” ");
INSERT INTO tcn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","जब येशुयि मो राङ मो ङ्याबो होङान यहुदिबा ङुङान थोङसोङ, तेहि ख्युइ सम याङ तुसोङ तेहि सम अल च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ख्युइ हतिबाला टिसोङ, “खि खोला काँहा पोरते?” हतिबे खोला नाइसोङ, “प्रभु, लेप्ते तोइ।” ");
INSERT INTO tcn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","येशु याङ ङुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","हतिचाला यहुदिबे नाइसोङ, “तेहि, ख्हुइ ख्योएला चोम करि किन्दुइ।” ");
INSERT INTO tcn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","हिन्नाङ रेनरेनयि नाइसोङ, “च्हि कानायि मि भेङान धि मिलाङ स्यिस्यियाने सोम्बो सो ङ्युइकिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","तेहि याङ येशुयि लेइराङ सम तुक्ते तुरला पुइसोङ। हति तुर ते फु झिला धुलो। हति खा टोउ झिकि क्यापतु। ");
INSERT INTO tcn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","येशुयि नाइसोङ, “टोउ फाला कि।” स्यिस्यियायि मिति इझि मार्थायि खोला नाइसोङ, “हे प्रभु, धि भेला थु ता हति टिमा खाला छेल होएरो, चिचालानाना खो स्यिरे ङिन स्यि पुइछारसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","येशुयि हतिला नाइसोङ, “च्हि ङाहि खेला नानाइबा मानाइ च्हि, ‘खि हिछे क्याइना कजसुबे छे तेतेका थोङान ना?’” ");
INSERT INTO tcn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","हतिबे टोउ फाला क्याइसोङ। तेहि येशुयि मि क्येल्ला क्याइरे नाइसोङ, “हे आके, ङा ख्योएला कटिनक्या नाज्याइ, चिचालानाना ख्युइ ङाहि स्युवा ङ्यन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ङाला छ्या होतो, ख्युइ ङाहि स्युवा बारतै ङ्यानकिन। हिन्नाङ ङिया लाँरे ताताता मि झोमयि चाला ङाहि धि नानाइबाना, तेहि ख्युइ ङाला चाँचाँबा हिना नाइरे खि हिछे कि।” ");
INSERT INTO tcn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","तेहि धि ताम नाइ छारते ख्युइ क्ये छेया क्याइरे क्ये ताङसोङ, “लाजारस, फिला थोन।” ");
INSERT INTO tcn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","हति स्यिस्यिया मिते हति लाक्पा काङबा राइयि तातामा राङ च्ये कोहिलायि तुतुमा राङला फिला थोन्दे लेप्सोङ। येशुयि हतिबाला नाइसोङ, “खोला तातामाते ठोल, राङ हतिला ढोरु छ्यु।” ");
INSERT INTO tcn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","मरियमयि तेहा लेलेबि यहुदि लेइराङयि येशुयि क्याक्याइबि लाइ थोङसोङ हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","हिन्नाङ हतिबे नाङने रेनते फरिसिबे तेहा पुइसोङ, राङ येशुयि क्याक्याइबि लाइतेबा स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","तेहि घोबा पुजारि राङ फरिसिबे झोमसा छेयायि स्दस्यतेबाला क्ये ताङदे हतिबाला नाइसोङ, “ता हु च्हि किच्याइ? चिचालानाना धि मिनि लेइराङ हा:लाइयापयि लाइ तोनिन्दु। ");
INSERT INTO tcn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","धिला चुका ताङना पोरोयि धिला हिछे किङान ना राङ रोमि आङकिङानबा लेप्ते हुइ मोनलाम क्यासि खिम राङ हुइ मि देश ङिकार मासि लोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","हिन्नाङ हतिबे नाङने च्हि, कैयाफा, काङते हति लोयि घोबा पुजारि हिना, ख्युइ हतिबाला नाइसोङ, “खि च्याङ मिस्येबा! ");
INSERT INTO tcn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","लेइराङ राष्ट मासि होङयापले जनताबे चाला मिझि स्यियाप राङ खि चाला ल हुवा नाइरे खि हा:मिकुवा धुये।” ");
INSERT INTO tcn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","धि खुरि चाने नानाइबा माना, हिन्नाङ धि लोयि घोबा पुजारि च्युच्युवाति राष्टयि चाला येशु स्यि कोइ नाइरे ङोन्सेखिलदे नानाइबाना। ");
INSERT INTO tcn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","राष्टयि चाला मात्रा ख्युइ धि नानाइबा माना, हिन्नाङ कार च्युङच्युङला होएते कजसुबायि सन्तनला लाम्मा झिला ङ्याबो स्योएयापला नानाइबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","हतिचाला हति ङिनने यहुदि आङकिङानबे येशुला हतिबे सोयापयि टपि क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","हतिचाला याङ येशु यहुदिबे उइला मनस्याङ क्याइरे फालाछुला माक्याइबालो, हिन्नाङ सा थोवाला धुनला होएता एफ्रइम नाङान भजारला पुइसोङ, राङ हतिया लोब्टुतेबा ङ्याबो त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","यहुदिबे निस्तार कालापसोल धुनला धुलो, राङ युलयुलने लेइराङ रेँ राङला चाङमा सोरु ताङला यरुश्लेमला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","तेहि हतिबे येशुला पातेलो, तेहि हतिबा मोनलाम क्यासि खिमला लाँरे तोतितुइना खोरे नाङला नारे क्याइसोङ, “खेला च्हि लागि हुनधुइ, च्हि खो कालापसोङला लेबोङङे?” ");
INSERT INTO tcn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","घोबा पुजारि राङ फरिसिबेते येशुला सुङज्याइ नाइरे खो काँहा धुइ नाइरे सुलाङ छ्या होएना लोन कुर नाइरे आदेश पिपिना होतो। ");
INSERT INTO tcn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","निस्तार कालापसोलयि ङिन टुयि ताङला येशु बेथानियाला पुइसोङ। हतिया लाजारस तोकिनलो, सुला येशुयि स्यिस्यियाने सोम्बो सोइरसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","हतिबे येशुयि चाला मुइ ङ्योपा तयार सोइसोङ। मार्था स्यापच्यि स्युनलो, तेहि लाजारस ते खो ङ्याबो ताते साङान झिकि नाङने च्यि। ");
INSERT INTO tcn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","तेहि मरियमयि लिटर फे कुना ङोलोयि उइयि टिमा होङान पहझि ख्योँरे येशुयि पिवर काङबा ला कुइरेलो, तेहि ख्युइ काङबा रेँ स्येभुइ पिरेलो, राङ अत्तरयि टिमि खिम खाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","हिन्नाङ येशुयि लोब्टुबे नाङने च्हि मदलब खोला धोका तेरङान यहुदा इस्करियोतयि नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“धि अत्तर सुमला क्या ङुलयि सिक्काला चोँरे हति आलाइ टाङनाला पिन्ना मिहाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","हिन्नाङ ख्युइ हति टाङनाला ताइरे नानाइबा माना, चिचालानाना हति कुम्मा ना, राङ आलाइयि किउ ख्युइ पोरते, तेहि हतिने कुनलो। ");
INSERT INTO tcn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","येशुयि नाइसोङ, “धिला च्याङ माना, ङाहि कुङयापयि ङिनयि चाला खोला पोरते सह। ");
INSERT INTO tcn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","चिचालानाना टाङनाबा बारतै खे ङ्याबो हुन।” ङा बारतै खे ङ्याबो मिहा। ");
INSERT INTO tcn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","यहुदितेबे तुम छेया झिकि खो हतिया होतो नाइरे हा:कोसोङ, राङ येशुयि चाला मात्रा माना, हिन्नाङ ख्युइ स्यिस्यियाने सोम्बो सोसोइबि लाजरसला याङ तायापयि चाला हतिबा लेप्तु लो। ");
INSERT INTO tcn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","हतिचाला घोबा पुजारितेबे लाजारस लायाङ सोएयापयि टोइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","चिचालानाना हति क्याइरे यहुदिबे नाङने लेइराङ हतिबाने पेरे पुते येशुला हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ङिमा च्येमातेला निस्तार कालापसोङ होङान तुम छोम्मुवाति तेहि येशु यरुश्लेमला हुन्दु नाइरे थोइरेलो, ");
INSERT INTO tcn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","राङ मितेबा खजुरयि ढाला खुरते खोल स्वगत कितु क्ये धोनिन राङ थोन्सोङ, “होसन्ना! धन्य कजसुबयि मिनला होङान इस्राएलयि क्यालबो!” ");
INSERT INTO tcn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","तेहि टेयि टेटुझि ठाते येशुयि हति थोला स्योन्सोङ, नाइरे पवित्रशास्त्राला टिदु, ");
INSERT INTO tcn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“सियोनयि पोमु माझि। तोइ ख्युइ क्यालबो टेयि टेटुयि थोला स्योन्दे हुन राङ धु।” ");
INSERT INTO tcn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","धि ताम ताङला ख्युइ लोब्टुतेबे हा:माकोसोङ। हिन्नाङ येशुयि छे ते छारते धि ताम ख्युइ भारेला पवित्रशास्त्रला टिदुलो, राङ धि लाइ ख्युइ चाला हतिबे क्याक्याइबा ना नाइरे हतिबे हा:कोरेलो। ");
INSERT INTO tcn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","येशुयि लाजारसला तुरने क्ये ताङदे स्यिस्यियाने सोम्बो सुइतुइना खो ङ्याबो होएता मि तुमतेबे ख्युइ साछि तेरिन राङ तातेलो। ");
INSERT INTO tcn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ख्युइ धि हा:लाइयापयि लाइ क्याइसोङ नाइरे थोथोइबातेबे याङ खोला ठातु पुइतु। ");
INSERT INTO tcn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","तेहि फरिसिबे खोरे नाङला नारे क्याइसोङ, “तेहि, खेने च्याङ मिहा। तेनराङ होए, संसार ख्युइ च्येला पुइसोङ!” ");
INSERT INTO tcn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","कालापसोङ ला आराधाना कितु ढोङान यि नाङने रेनरेन ग्रिक याङ धुलो। ");
INSERT INTO tcn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","हतिबा गालिलयि बेथसेदाला त्योएङान फिलिपयि तेहा लेप्ते जु नाइरे स्युवा क्यापसोङ, “हजुर, ङे येशुला ठेसोम होए।” ");
INSERT INTO tcn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","फिलिप पुते आन्द्रियासला नाइसोङ, अन्‍द्रियास राङ फिलिप हति ङिबो पुते येशुला नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","येशुयि हतिबाला जवाक पिन्सोङ, “मि पिजि छे धेयापयि भेला लेप्छारतु। ");
INSERT INTO tcn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","तेम्बारे, ङा खेला नाज्याइ, ढुयि घेरा साला छारते मासिना हति चिक्पा लुइयिन। हिन्नाङ हति स्यिना लेइराङ ढेबु क्येरु झ्युकिन। ");
INSERT INTO tcn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","रेँ उला करि किङानयि हति मेता सुन, हिन्नाङ रेँ उल धि संसारला अल नाङानते नामयाङ मिसिनयापयि मिजेयि चाला सुरछित भोरिन। ");
INSERT INTO tcn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","सुइ याङ ङाहि स्यापच्यि स्युना हति ङाहि च्येला सअ राङ ङा काँहा होए, ङाला स्यापच्यि स्युङानतेबा याङ हतिया हुन। सुइ याङ ङाहि स्यापच्यि स्युना आकि याङ हति सम्मान किन। ");
INSERT INTO tcn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ता ङाहि सम अल च्युङसोङ, राङ ङा च्हि नाज्याइ? हे आके, धि भेलाने क्योप? माना, धि चाला राङ ङा धि भेला थु कोप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","हे आके ङा ख्युइ मिनला छे धेक च्याइ।” तेहि तेङलाने धि च्वरा क्ये झि लेप्सोङ, “ङाहि हति छे तेतेका होए याङ किच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","हतिया लाँलाँबि मि झोमयि हति थोइरे नाइसोङ, “धि लोमार क्याक्याइबा ना!” स्यानतेबे नाइसोङ, “तेङलायि लोन खेरङानतेबा खो ङ्याबो ताम नानाइबाना!” ");
INSERT INTO tcn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","येशुयि हतिबाला जवाक पिन्सोङ, “धि वचन ङाहि चाला च्युच्युवा माना हिन्नाङ खि चाला ना। ");
INSERT INTO tcn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ता धि संसारला ल अल भेयापयि लाइ हुन। धि संसारयि क्यालबो फिला ढिमङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","तेहि जब पृथ्‍वी धेकिन, ङा मि पोरोला ङा यहला ढुच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","खो च्हिरु क्याइरे स्यिन, सो ता तोनयापयि चाला जु नानाइबाना। ");
INSERT INTO tcn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","मि झोमयि खोला टिसोङ, “ख्रिष्ट बारतै सोम्बो तोकिन नाइरे ठिमने ङि थोथोइबा होतो। ख्योए च्हिरु क्याइरे नाङ्युकिन, मि पिजा धेराङ कोयिन नाइरे? धि मि पिजा ते सुना?” ");
INSERT INTO tcn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","येशुयि हतिबाला नाइसोङ, “तरह टिझि थु होए खे ङ्याबो धु। होए खे ङ्याबो होएहोए थु फालाछुला कि, तेहि मुन्नायि खेला घाङान अर्थात। सुवाङ मुन्नाला फालाछुला किना, हति खो काँहा ढुन खो राङ ला छ्या मिहा। ");
INSERT INTO tcn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","जब थु होए खे ङ्याबो होए हति थु हिछे पोर, राङ खे होएयि सन्तन ना।” धि ताम नाइरे, येशु हतिने पुइसोङ, राङ हतिबाने हिप्ते त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","येशुयि हतिबे धुनला झोमयि हा:लाइयापयि क्याक्याइबा होतो, हचु हिन्नाङ हतिबे खोला हिछे माक्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","हति कोइबा होतो, यशैया ङोन्सेखिलङानयि वचन पुरा सह, “हे प्रभु, हुइ लोन सुइ हिछे क्याइ सुइ? तेहि कजसुबे शक्ति सुला तानसुइ?” ");
INSERT INTO tcn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","हतिचाला हतिबे हिछे कि माङ्युइ सोङ, चिचालानाना यशैयायि याङ जु नानाइबा होतो, ");
INSERT INTO tcn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ख्युइ हतिबे मि क्याकाका होतो, राङ हतिबे सम क्योङबो सोसोइबा होतो, हति च्वरा क्याइरे हतिबे मियि मि थोङयाप राङ समयि हा:मिकोयाप, स्यान अर्थात हतिबा लाँङान ना राङ ङाहि हतिबाला टाक्तु झ्युकोहि होङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","यशैयायि धि ताम नाइरेलो, चिचालानाना ख्युइ हति छे तेतेका थोङसोङ, राङ ख्युइ भारेला नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","हिन्नाङ यहुदि आङकिङानबे नाङने लेइराङयि येशुला हिछे क्याइसोङ, हिन्नाङ फरिसिबे झिटायि, राङ हतिबाला यहुदि झोमसि खिमने धोनिन नाइरे झिटायि हति माङ्याना लो। ");
INSERT INTO tcn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","चिचालानाना कजसुबे छे धेयापले मा हतिबा मियि छे धेयाप करि किनलो। ");
INSERT INTO tcn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","येशुयि क्ये छेया क्याइरे नाइसोङ, “ङाला हिछे किङानयि ङाला माना, हिन्नाङ ङाला चोँङानयि हिछे किन। ");
INSERT INTO tcn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","सुइ याङ ङाला थोङान ना, हति ङाला चोङान ला थोङिन। ");
INSERT INTO tcn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ङा संसारला होए च्युङदे लेलेबा होतो, तेहि ङाला हिछे किङान मुन्नाला मियोङ नाइरे।” ");
INSERT INTO tcn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“सुइ ङाहि वचन ङ्यानकिन राङ हति खाला मिङ्यान ना, ङा हति ल अल भेयापयि लाइ मिके। चिचालानाना ङा संसारयि ल अल भेयापयि लाइ कितु लेलेबा माना, हिन्नाङ संसारला क्योपतु लेलेबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ङाला माना नाङन राङ ङाहि वचन मिङ्यानङानयि चाला च्हि ल अल भेङानयि लाइ किङान झि होतो। काङ वचन ङाहि सिनि ङिनला ल अल भेयापयि लाइ किङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","चिचालानाना ङाहि चाने नानाइबा माना हिन्नाङ ङाहि च्हि नायाप हिना, ङाला चोँङानयि आके खोराङयि ङाला आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ङाला छ्या होतो, कि ख्युइ आदेश नामयाङ मिसिनयापयि मिजे ना। हतिचाला ङा च्हि नेन, आकि नानाइबा च्वरा नेन।” ");
INSERT INTO tcn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","निस्तार कालापसोलले ताङला धि संसारने बिदा च्युङदे आकि तेहा ढोयापयि भेला लेप्तु नाङान येशुयि हा:कोदुलो, तेहि संसारला होएता खुरि मितेबे करि क्याइरे ख्युइ हतिबाला सिनसिन थु राङ करि क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","येशु राङ येशुयि लोब्टु कमुइ ङ्योपाला दियाबलसयि सिमोनयि पिजा यहुदा इस्करियोतयि समला खोला सुङदु झ्युयापयि विचार ताङलाने राङ क्याइ छारतु। ");
INSERT INTO tcn_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","आकि क्यु पोरो येशुयि लाला टोए छारतुलो, राङ खो कजसुबाने लेलेबा ना, राङ कजसुबे तेहा राङ ढुन नाङान येशुला छ्या होतो। ");
INSERT INTO tcn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","तेहि खो ङ्योपा साइरे लाँरेलो, राङ फिला कोहिला यि च्हिला पोरते रुमाल झि रेँ केप्पाला च्यीसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","तेहि ख्युइ भाटाला छ्यु च्योसोङ, राङ लोब्टुबे काङबा ठुताला छेलसोङ, राङ ख्युइ रेँ कोकोनि रुमालयि हतिबे काङबा फिकाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","जब खो सिमोन पत्रुसयि तेहा लेप्ते, ख्युइ येशुला नाइसोङ, “प्रभु, च्हि ख्योए ङाहि काङबा ठुच्ये?” ");
INSERT INTO tcn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","येशुयि खोला जवाक पिन्सोङ, “ङा च्हि किन थाल्ला खेला छ्या मेता, हिन्नाङ च्येला हा:कोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","पत्रुसयि खोला नाइसोङ, “ख्युइ ङाहि काङबा नामयाङ ठुच्याइ मिखुबा।” येशुयि हतिला जवाक पिन्सोङ, “ङाहि माटुइना ख्योए ङाहि लोब्टु मिहा।” ");
INSERT INTO tcn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","सिमोन पत्रुसयि खोला नाइसोङ, “हे प्रभु, ङाहि काङबा मात्रा माना हिन्नाङ ङाहि लाक्पा राङ घोबो याङ ठुइ।” ");
INSERT INTO tcn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","येशुयि हतिला नाइसोङ, “ठुइ क्याप छाछाराला मिइ काङबा माना स्यान च्याङ ठुइकोइ मिहा, धि पोरो चाङमा राङ धु। तेहि खे पोरो चाङमा धु, हिन्नाङ पोरो ता माना।” ");
INSERT INTO tcn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","चिचालानाना खोला धोका तेरङानते येशु ङोस्येदु। हतिचाला ख्युइ नाइसोङ, “खे पोरो चाङमा मिदु।” ");
INSERT INTO tcn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","हतिबे काङबा टुइ चारते च्येला रेँ खो फि कोहिला कोन्दे खो याङ त्येसोङ। तेहि येशु हतिबाला नाइसोङ, “च्हि खेला छ्या होतो, ङाहि खि चाला च्हि क्याइरे? ");
INSERT INTO tcn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","खे ङाला ‘गुरु राङ प्रभु’ नेन्दु, धि खे तेम्बा नेन्दु, चिचालानाना ङा हति राङ ना। ");
INSERT INTO tcn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","तेम्बारे खि गुरु राङ प्रभु च्युङदे ङाहि खि काङबा टुटुइबा हिन्ना खि याङ चिकि च्यियि काङबा ठुइ कोहि हुन, ");
INSERT INTO tcn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","चिचालानाना ङाहि खेला प्ये झि मात्रा तान्दे, राङ च्हिरु ङाहि खि चाला क्याइरे। खे याङ हति च्वरा कि। ");
INSERT INTO tcn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","तेम्बारे ङा खेला नाज्याइ, यक्पुवा ख्युइ ताक्पो ले छे मिहा, तेहि तेङलायि लोन खेरङान लोन कुरङान ले छेया मिहा ");
INSERT INTO tcn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","तेम्बारे खि धि तेम्बा ताम हा:कोरे राङ क्याइना, खे धन्य होङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ङाहि खे पोरोयि भारेला नानाइबा माना, ङाहि सुला धाम्दे हतिला ङाहि ङोस्येयिन। हिन्नाङ पवित्रशास्त्रा पुरा होङ नाइरे धि च्युङसोङ, कि ‘ङाहि लोटा साङानयि ङाहि थोला तोति क्यापसोङ।’” ");
INSERT INTO tcn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“धि होङज्याइले ताङला राङ ङा खेला नाज्याइ, तेहि जब हति हुन, ङा हति राङ ना नाइरे खेला हिछे होङ। ");
INSERT INTO tcn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","तेम्बारे ङा खेला नाज्याइ, ‘सुला ङा चोँङिन, हतिला हिना नाइरे खाला ङ्यानङानला ङा याङ हिना नाइरे खाला ङ्यानज्याइ, तेहि ङाला हिना नाइरे खला ङ्यानङानयि ङाला चोँङानयि मिला याङ हिना नाइरे खाला ङ्यानकिन।’” ");
INSERT INTO tcn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","धि ताम नाइछारते येशुयि सम तुसोङ राङ ख्युइ साछि तेरिन राङ नाइसोङ, “तेम्बारे ङा खेला नाज्याइ, खि नाङने च्हि कि ङाला टायि लाला सुङदु झ्युङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","येशुयि धि सुला नानाइबा ना नाइरे हा:माकुवा लोब्टुतेबा चिकि चिला तारे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ख्युइ लोब्टुबे नाङने येशुयि करि किङान झि ख्युइ धुनला ङेरे रेँ त्येतु। ");
INSERT INTO tcn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","तेहि सिमोन पत्रुसयि खोला मिता क्याकिन राङ टिसोङ, खोला टि “ख्युइ धि ताम सुइ भारेला नानाइबाना?” ");
INSERT INTO tcn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","तेहि हति लोब्टु येशुयि टाङला जु क्याइरे ङेरे राङ खोला टिसोङ, “प्रभु, हति सुना?” ");
INSERT INTO tcn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","येशुयि जवाक पिन्सोङ, “सुला ङा लोटायि तुबु पहारे तेरच्याइ, खो हति राङ ना।” तेहि ख्युइ लोटायि तुबु प्हासोङ, राङ तोन्दे सिमोनयि पिजा यहुदा इस्करियोतला पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","लोटायि तुबु खेरछारते तुइ हति नाङला स्युसोङ। तेहि येशुयि हतिला नाइसोङ, “ख्योएला च्हि किसोम होए, सो घ्योबो कि।” ");
INSERT INTO tcn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","हिन्नाङ येशुयि हतिला च्हि नानाइबा ना नाइरे ङ्योपा सारु ताताति सुइ याङ हा:माकोसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","चिचालानाना रेनरेनयि धि नाइबा क्याइरे लो, कि यहुदाला आलाइयि किउ होतो, हति येशुयि हतिला कालापसोलयि चाला कोइबा आलमाल ङ्योयोङ, अर्थात हति टाङनाबाला चिगा पिनोङ नानाइबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","तेहि लोटायि तुबु साइरे यहुदा इस्करियोत हो:प्तामेला फिला थोन्दे पुइसोङ। हति तुना छाम्मु च्युङछरतु। ");
INSERT INTO tcn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","जब खो फिला पुते तेहि येशुयि नाइसोङ, “ता मि पिजायि छे तेतेका च्युङ छारते, राङ कजसुबा हतिला छे तेतेका च्यङछारते। ");
INSERT INTO tcn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","तेम्बारे कजसुबा हतिला छे तेतेका च्युच्युवा होएना कजसुबा यि खोराङला छे धेङान ना, तेहि हतिला थाल्ला राङ छे धेङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“च्यिबा टिमाबा, टिझि थु ङा खे ङ्याबो हुन! खि ङाला फे ङान ना, राङ च्हिरु ङाहि यहुदि आङकिङनबाला नाइरे, ता ङा खेलाङ नाज्याइ, ‘का ङा ढुन, खे होङ मिङ्युइबा।’” ");
INSERT INTO tcn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“ङा खेला आदेश सारबा झि तेरच्याइ :खे चिकि च्हिला करि कि। खेला ङाहि च्हिरु करि क्याइ, खेयाङ हति च्वरा क्याइरे करि कि। ");
INSERT INTO tcn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","तेम्बारे खि चिकि चिला करि क्याइना हतिने राङ हा:कुन कि खे ङाहि लोब्टु ना।” ");
INSERT INTO tcn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","सिमोन पत्रुसयि खोला नाइसोङ, “हे प्रभु, ख्होए काँहा ढुन?” येशुयि जवाक पिन्सोङ, “ङा काँहा ढुन थाल्ला खि होङ मिङ्युइबा, हिन्नाङ च्येला खे ङाहि च्येला होङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","पत्रुसयि खोला नाइसोङ, “प्रभु, ङा चिचाला थाल्ला राङ ख्युइ च्येला होङ मिङ्युइबा? ख्युइ चाला ङाहि उ तेरच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","येशुयि जवाक पिन्सोङ, “च्हि ख्योए ङाहि चाला उ तेरच्ये? तेम्बारे ङा ख्योएला नाज्याइ, ख्युइ ङाला लाम्मा सुमला माना मानाइबा ताङला च्याबो मिभोता।” ");
INSERT INTO tcn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“खि सम तुकि तु। येशुयि हतिबाला नाइसोङ खे कजसुबायि थोला हिछे किन्दु, ङाहि थोला याङ हिछे कि। ");
INSERT INTO tcn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ङाहि आकि खिमला त्योएसा लेइराङ होतो। हति च्वरा अर्थात ङाहि खेला नेनाइ, कि खि चाला ङा तोएसा तयार सोरु ढुन होए? ");
INSERT INTO tcn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","तेहि खि चाला तोएसा सोइरे ङा याङ लक्ते होङज्याइ, राङ खेला ङा ङाहि तेहा खेरच्याइ, राङ ङा काँहा होतो, हतिया खे याङ होङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ङा काँहा ढुन, खे हाङ हतिया ढोसि लाम हा:कोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","थोमायि येशुला नाइसोङ, “हे प्रभु, ख्योए काँहा ढुन, ङेला छ्या होतो, तेहि ङाहि लाम च्हिरु क्याइरे ङोस्येच्याइ?” ");
INSERT INTO tcn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","येशुयि हतिबाला नाइसोङ, “लाम, तेम्बा राङ मिजे ङा राङ ना। ङा ने अर्थात आकि तेहा सुवाङ ढोमिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","खि ङाला ङोस्येस्येबा हिन्ना, ङाहि आके लाङ ङोस्येयिन। ताने ङोस्येयिन राङ खोला थोङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","फिलिपयि खोला नाइसोङ, “हे प्रभु, ङेला आके तोन होचोम च्युङना ङेला हुन।” ");
INSERT INTO tcn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","येशुयि हतिला नाइसोङ, “फिलिप, झोम भेला थु ङा खे ङ्याबो होतो, हचु हिन्नाङ खि ङाला ङोमास्येसोङ? सुइ ङाला थोथोवा होतो, हति आकेला याङ थोथोवा होतो। ख्होए च्हिरु क्याइरे नाङ्युइ किन, ‘ङेला आके तोन?’” ");
INSERT INTO tcn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ङा आकेला, राङ आके ङाला होतो नाङान च्हि फिलिप ख्योए हिछे मिकिताइ? काङ वचन ङा खेला नेन, हति ङारि आङने नानाइबा माना हिन्नाङ ङाला ताताता आकि लाइ क्याक्याइबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ङाला हिछे कि, कि ङा आकेला होतो, राङ आके ङाला। अर्थात धि लाइ यि चाला हिछे कि। ");
INSERT INTO tcn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“तेम्बारे, ङा खेला नाज्याइ, सुइ ङाला हिछे किन, हति ङाहि क्याक्याइबि लाइ याङ कि ङ्युइकिन, राङ हतिले याङ लाइ छेया किन, चिचालानाना ङा आकि तेहा ढुनहोए।” ");
INSERT INTO tcn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","खि ङाहि मिनला च्हि लाँना याङ पिजाला आकि छे तेतेका होङ नाइरे ङा हति कि च्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","खि ङाहि मिनला च्हि लाँ नाङ हति ङा किच्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“खि ङाला करि क्याक्याइबा हिन नाता ङाहि आदेश तेबा ङ्यानकिन। ");
INSERT INTO tcn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","राङ ङा आकेला स्युवा क्याकच्याइ, राङ ख्युइ खेला स्यान टोइकिङान तेरङान ना, राङ खो खे ङ्याबो बारतै त्योएङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","धि तेम्बि आत्मा ना, काङला संसारयि हिना नाइरे खाला मिङ्याना, चिचालानाना संसारयि खोला न त थोङिन न त ङोस्येयिन। खि खोला ङोस्येयिन। चिचालानाना खो खे ङ्याबो तोकिन, राङ खो खे ङ्याबो राङ त्योएङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ङा खेला चिक्पा टोकिया मिभोर। ङा खि तेहा याङ होङज्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ता टिझि च्येला संसारयि ङाला नामयाङ थोङान माना ना, हिन्नाङ खि ङाला थोङान ना। ङा सोम्बो होतोति, खे याङ सोम्बो त्योएङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","हति ङिन खि हा:कोङान ना, कि ङा ङारि आकेला होतो, राङ खे ङाला, राङ ङा खेला होतो। ");
INSERT INTO tcn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ङाला करि किङान हति राङ ना सुला ङाहि आदेश होतो राङ हति खाला ङ्यानकिन। तेहि ङाला करि किङानला ङाहि आकि करि किन। ङा हतिला करि किच्याइ, राङ ङा ङाराङला हतिया थोङदु झ्युक च्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","यहुदा (इस्करियोत माना) ख्युइ नाइरेलो, “प्रभु, ख्युइ च्हि नाइरे, ख्योए ख्योएराङला ङाहि तेहा थोङदु झ्युक च्याइ, राङ संसार तेला मानाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","येशुयि हतिला जवाक तेरिन राङ नाइसोङ, “सुइ ङाला करि किन, हति ङाहि वचन ङ्यानकिन, राङ ङाहि आकि हतिला करि किन, राङ हु हति तेहा होङान ना, राङ हति तेहा त्योएङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ङाला करि मिकिङानयि ङाहि वचन खाला मिङ्याना। काङ वचनते खे ङ्यान किन, हति ङाहि माना, हिन्नाङ ङाला चोँङान आकि ना।” ");
INSERT INTO tcn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“धि ताम ङा खे ङ्याबो होतोला राङ नानाइबाना। ");
INSERT INTO tcn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","हिन्नाङ टोइकिङानते, मदलब पवित्र आत्मा, सुला आकि ङाहि मिनला चोँङान ना, ख्युइ खेला ताम पोरो लोप्ङान ना, राङ ङाहि खेला नानाइबि ताम पोरो याका लोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","किप्पो ङा खे ङ्याबो राङ पोरते ढोज्याइ। ङा ङारि शान्ति खेला तेरच्याइ। संसारयि पिपिना च्वरा ङा खेला मितेर। खि सम मातु राङ माझि। ");
INSERT INTO tcn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“ङाहि खेला ‘ङा ढुन होए, राङ खि तेहा होङज्याइ’ नानाइबा खि थोइसोए। खि ङाला करि क्याक्याइबा हिन्ना ङा आकि तेहा ढुन होए नानाइबा थोइरे खे काङान ना, चिचालानाना आके ङाले छेना। ");
INSERT INTO tcn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ता धि होङज्याइले ताङला राङ ङाहि खेला नाइछारते, राङ तेहि धि जब हुन तेहि खि हिछे ङ्युइयोङ। ");
INSERT INTO tcn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ङा ता खे ङ्याबो ताम मा मिना, चिचालानाना धि संसारयि क्यालबो हुन्दु। हति ङाहि थोला च्याङ शक्ति मेता। ");
INSERT INTO tcn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","हिन्नाङ ङा आकेला करि किन, राङ च्हिरु आकि ङाला आदेश पिन्दे हति अनुसार राङ किन नाइरे संसारयि हा:कोहोङ। ल्हो, हु धि साने ढो।” ");
INSERT INTO tcn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“तेम्बा अंगुरयि तोङभोङ ङ्याना, राङ ङाहि आके स्यिङयि लाइ किङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ङाला होएता पोरो ढाला काङयि ढेबु मितेरा हतिला तुप्ते ल सोयाप राङ ढेबु तेरङान पोरो ढालाला हतिले याङ झन मा तेरिन नाइरे झन तुप्ते भे क्याकिन। ");
INSERT INTO tcn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ङाहि खेला नानाइबि वचनयि खे तेकि राङ चाङमा च्युङ छारते। ");
INSERT INTO tcn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ङाला त्योए, राङ ङा खेला तोच्याइ। च्हिरु क्याइरे ढाला अंगुरयि तोङभोङला मात्येना हति खुरि ढेबु छ्या मिङ्युइबा, हति च्वरा क्याइरे खे ङाला मात्येना खि याङ ढेबु छ्या मि ङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“अंगुरयि भोटि ङा ना, खे ढालातेबा ना। तेम्बारे सुवाङ ङा ङ्याबो त्येना, राङ ङा हतिला त्येना, हति ढेबु लेइराङ छ्यातु झ्युङान ना चिचालानाना ङाने कुरु ताते खि च्याङ कि मिङ्युइबा।” ");
INSERT INTO tcn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","मि सुवाङ ङाला मा त्येना, हति ढाला च्वरा फिला ढिमङान ना, राङ हति कामछारङान ना। हतिच्वरा ढालातेबा मितेबे थुन राङ मेला झ्युकिन, राङ हति झ्योप छारकिन। ");
INSERT INTO tcn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","खे ङाला त्येना, राङ ङाहि ताम खेला त्येना, खेला च्हि धोप्पा होतो लोँ, राङ हति खि चाला होङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","खि लेइराङ ढेबु छ्या च्युक्ते ङाहि लोब्टु हिना नाइरे प्रमाण क्याइना हतिला राङ ङाहि आकि छे तेतेका होङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“आकि च्हिरु क्याइरे ङाला करि क्याइरे, ङाहि याङ खेला करि क्याइरे खे ङाहि करिला त्योए।” ");
INSERT INTO tcn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","तेम्बारे खि ङाहि आदेश खाला ङयान ना खे ङाहि करिला त्योएङान ना, च्हिरु क्याइरे ङाहि आकि आदेश खालाङ्यान्दे, राङ ख्युइ करिला तोकिन। ");
INSERT INTO tcn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","ङाहि धि ताम खेला धि चाला नानाइबा ना, कि ङाहि किप्पो खेला होङ, राङ खि किप्पो पुरा होङ। ");
INSERT INTO tcn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“ङाहि आदेश धि राङ ना, कि ङाहि खेला च्हिरु क्याइरे करि क्याइरे, खि याङ चिकि चिला हति च्वरा क्याइरे करि कि।” ");
INSERT INTO tcn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","रेँ रुवायि चाला रेँ उ तेरच्याइले छेया करि स्यान सुवाङ मिहा। ");
INSERT INTO tcn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ङाहि खेला आदेश पिन, हति ख्युइ खाला ङ्यान्ना, खे ङाहि रबो ना। ");
INSERT INTO tcn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ता ङा खेला योक्पुवा मिना, चिचालानाना ख्युइ ताक्पो च्हि किन ख्युइ हा:मिकुवा। हिन्नाङ ङाहि खेला रबो नानाइबा होए, चिचालानाना च्हि ङाहि आकेने थोइरे, ङाहि हति पोरो खेला स्यास्याता होए। ");
INSERT INTO tcn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ङाला खि माधामा, हिन्नाङ ङाहि खेला धाम्दे, कि खे क्यु, ढेबु छ्यातु छ्यु, तेहि खि ढेबु छ्याछ्याबा राङ त्योए। हतिचाला आकेला ङाहि मिनला च्हि लाँ, ख्युइ खेला हति तेरङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ङा खेला धि आदेश तेरच्याइ, कि खे चिकि चिला करि कि। ");
INSERT INTO tcn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“तेम्बारे संसारयि खेला अल किना, खे हा:कुवा कि, कि खेला अल किच्याइले ताङला ङाला अल क्याक्याइबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","तेम्बारे खे धि संसारयि हिननाता खेला रेँ मि नाइरे करि क्यायोङ ना। हिन्नाङ खे धि संसारयि माना। खेला संसारने ङाहि धाम्दे, हतिचाला संसारयि खेला अल नेन। ");
INSERT INTO tcn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ङाहि खेला नानाइबि वचन टाम्बाला पोर, ‘यक्पुवा खिमयि ताक्पोले छेया मिहा।’ हतिबे ङाला तुका पिन्न खेला हाङ तुका तेरङान ना। खि ङाहि वचन खालाङ्यान ना खि वचन याङ खाला ङ्यानङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","हिन्नाङ हतिबे धि ताम पोरो ङाहि मिनला खेला किङान ना, चिचालानाना ख्होए ङाला चोँङानला ङोमिस्येबा। ");
INSERT INTO tcn_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ङा मालेबा नाना रेँ राङ हतिबाला मानाइबा झिनाना खे तिक्पि दोषि होङान अर्थात, हिन्नाङ ता खिरि तिक्पा ङ्याबो च्याङ ताम सोयाप मिहा। ");
INSERT INTO tcn_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","सुइ ङाला मिका किन हति ङाहि आके लाङ मिका किन। ");
INSERT INTO tcn_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","तेम्बारे स्यान सुइयाङ माक्याइबि लाइ ङाहि हतिबे उइला माक्याइबा झि नाना हतिबा तिक्पि दोषि होङान अर्थात। हिन्नाङ ता हतिबे ङा राङ ङाहि आके ङिकारला थोथोवा होतो राङ मिका क्याक्याइबा होतो। ");
INSERT INTO tcn_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","हिन्नाङ ठिमला टिटिबि धि वचन पुरा होङयापयि चाला धि च्युच्युवा ना, ‘खि ङाला चुराङडि मिका क्याइसोङ।’” ");
INSERT INTO tcn_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“जब टोइकिङान हुन, सुला ङा आकि तर्फने खि तेहा चोङज्याइ, मदलब तेम्बि आत्मा, काङते आकेने हुन, ख्युइ राङ ङाहि भारेला साछि तेरङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","खे ताङस्युवाने राङ ङा ङ्याबो होतो ति, खे याङ ङाहि साछि ना।” ");
INSERT INTO tcn_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“खि हिछे मा तोङ नाइरे राङ ङाहि धि ताम खेला नानाइबा ना। ");
INSERT INTO tcn_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","हतिबे खेला यहुदि झोमसि खिमने खेला धोन्ङान ना। तेम्बा तेला धि च्वरा भेला हुन्दु, जब खेला मिपसोएयि कजसुबे स्यापच्यि स्युन नाइरे ठानि किङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","हतिबे धि लाइ किङान ना, चिचालानाना हतिबे आकेला ङोस्येस्येबा मेता, राङ ङा लाङ ङोमिस्येबा। ");
INSERT INTO tcn_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","हिन्नाङ धि ताम ङाहि खेला स्यास्याता होए, कि जब हति भेला हुन, तेहि खेला च्हि नेन सो स्मरण हुन। ताङला राङ ङाहि खेला धि ताम मानाइबा, चिचालानाना ङा खे ङ्याबो होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“ता ङा ङाला चोँङान यि तेहा ढुन, हिन्नाङ ‘ङा काँहा ढुन?’” नाइरे खे सु याङ ङाला मिढिया। ");
INSERT INTO tcn_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","हचु हिन्नाङ ङाहि खेला धि ताम नानाइबि तोनयि सम शोकयि खाँखाँबा धु। ");
INSERT INTO tcn_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","हचु हिन्नाङ ङा खेला तेम्बा ताम नाज्याइ, ङा ढोयाप ला राङ खेला ल हुन। चिचालानाना ङा मापुइना, टोइकिङान खि तेहा होङान मानाना। हिन्नाङ पुइना ङा खोला खि तेहा चोङज्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","तेहि खो जब हुन, ख्युइ संसारला तिक्पा राङ केवा, ल अल भेयापयि लाइ भारेला दोष सोङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","तेहि तिक्पि भारेला, गलग दु चिचालानाना हतिबा ङाहि थोला हिछे मिकिता, ");
INSERT INTO tcn_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","केवायि भारेला, चिचालानाना ङा आकि तेहा ढोज्याइ, राङ खि ङालाङ थोङान मानाना। ");
INSERT INTO tcn_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","राङ ल अल भेयापयि लायि भारेला संसारयि ठिमयि आङकिङान दोषि सोइछारसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ङाहि खेला नायापयि ताम तरह लेइराङ होतो, हिन्नाङ थाल्ला खि हति ताम ङ्यान मिङ्युइबा।” ");
INSERT INTO tcn_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","जब खो मदलब तेम्बि आत्मा हुन, तेहि ख्युइ खे पोरोला तेम्बाला ठिङान ना। खो खुरि चाने नाङान मानाना। ख्युइ च्हि थोइ हतिराङ नाङान ना, राङ होङानयि तामतेबा खेला किङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ख्युइ ङाहि छे धेङाना, चिचालानाना काङते ङाहि ना, हति ङाने खेरते खेला सो क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","चोम आकेला होए, हति पोरो ङाहि ना। हतिचाला ङाहि नाइरे, काङ ङाहि हिन हति ङाने खेरते आत्मायि खेला किङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“टिझि च्येला याङ खि ङाला थोङान मानाना, याङ टिझि च्येला खि ङाला थोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","तेहि ख्युइ लोब्टु रेनरेन खोरे नाङला नारे क्याइसोङ, “ख्युइ हुला धि नानाइबा चिना? ‘टिझि च्येला खि ङाला थोङान माना ना, तेहि याङ टिझि च्येला ङाला खि थोङान ना, राङ चिचालानाना ङा आकि तेहा ढुन ताताता होए।’” ");
INSERT INTO tcn_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","हतिबे नाइसोङ, “ख्युइ ‘टिझि थु’ नानाइबि तोन च्हिना? ङेला छ्या मेता, ख्युइ च्हि नानाइबा ना नाइरे।” ");
INSERT INTO tcn_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","हतिबे येशुला ढिसोम किन्दु नाइरे येशुयि हा:कोदु, राङ ख्युइ नाइसोङ, “‘टिझि च्येला खि ङाला थोङान मानाना, तेहि टिझि च्येला थोङान ना’ नाङानयि तामयि तोन च्हि ना नाङान यि भारेला च्हि खे खिरि उइला नारे किनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","तेम्बारे ङा खेला नाज्याइ, खे ङुङान ना राङ सम अल होङान ना। हिन्नाङ संसार काङान ना। खे सम तुङान ना, हिन्नाङ तुका किप्पोला घ्युरङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","च्यिबा कितुइना पोमुवातेबाला तुका हुन, चिचालानाना हति भेला लेलेबा हुन। हिन्नाङ जब मुइ च्यिबा क्येरु झ्युकिन, हतितुना हति तुका टाम्बा मिहा चिचालानाना संसारला च्यिबा झि क्येसोङ नाङान ला केनलो। ");
INSERT INTO tcn_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","हति च्वरा क्याइरे थाल्ला खेला तुका हुन, हिन्नाङ याङ ङा खेला थोङान ना, राङ खि सम किप्पो होङान ना। तेहि सुइ याङ खि किप्पो खेने ठोमिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","जब हति ङिन खि ङाला होङान ना खि ङाला च्याङ ढिङान मानाना। तेम्बारे ङा खेला नाज्याइ, खि ङाहि मिनला आके ला च्हि लाँ, ख्युइ खेला हति तेरङान ना। ");
INSERT INTO tcn_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","थाल्ला थु खि ङाहि मिनला च्याङ लाँलाँबा मेता। लँ, तेहि खेला खुङान ना। धि च्वरा क्याइरे खि किप्पो पुरा सअ। ");
INSERT INTO tcn_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“धि ताम ङाहि खेला प्येला नानाइबा ना। हिन्नाङ भेला हुन्दु, जब ङा खेला ला क्याइरे ताम नाङान मानाना, हिन्नाङ जब ङा याङ खे ङ्याबो प्येला ताम नाङान माना ना, हिन्नाङ आकि भारेला चाङमा क्याइरे नाज्याइ। ");
INSERT INTO tcn_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","हति ङिन खि ङाहि मिनला लोङान ना। ङा खि चाला आकेला स्युवा क्याकिन नाइरे खेला मिना, ");
INSERT INTO tcn_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","चिचालानाना आके खुरि खेला करि किन। चिचालानाना खि ङाला करि क्याक्याइबा होतो, राङ ङा कजसुबाने लेलेबा ना नाइरे हिछे क्याक्याइबा होतो। ");
INSERT INTO tcn_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ङा आकेने लेप्ते, तेहि संसारला लेप्ते, राङ याङ ङा संसारला ताङदे आकि तेहा ढुन होए।” ");
INSERT INTO tcn_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","येशुयि लोब्टुतेबे नाइसोङ, “ता ख्योए ताम चाङमा क्याइरे नेन्दु, प्येल माना। ");
INSERT INTO tcn_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ता ङाहि हा:कोसोङ, ख्युइ ताम पोरो हा:कुन्दु, तेहि ता ख्योए सुलाङ ढि कोइ मिदु। हतिचाला ङे हिछे किन कि ख्योए कजसुबाने लेलेबा ना।” ");
INSERT INTO tcn_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","येशुयि हतिबाला जवाक पिन्सोङ, “च्हि ता खे हिछे किनाइ? ");
INSERT INTO tcn_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","तेहि, भेला हुन्दु, तेम्बा तेला लेप्तु, जब खे थोरते रेँ खिमला ढुन राङ ङाला चिक्पा भोरङान ना। हचु हिन्नाङ ङा चिक्पा मेता चिचालानाना आके ङा ङ्याबो होतो। ");
INSERT INTO tcn_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ङाहि धि ताम खेला धि चाला नानाइबा ना, कि ङाला खे शान्ति होङ। संसारला खेला तुका होङान ना, हिन्नाङ सम छेया कि, ङाहि संसारले क्याक्याला होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","धि ताम नाइ छारते येशुयि तेङला यहला मि केल्ला ताइरे नाइसोङ, “हे आके, भेला छारतु, ख्युइ पिजि छे धेयाप थोङान ना, राङ पिजि ख्युइ छे तेतेका थोङदु झ्युङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","चिचालानाना ख्युइ हतिला मि पोरोयि थोला आङ पिपिना होतो, तेहि ख्युइ खोला पिपिना पोरोला ख्युइ नामयाङ मिसिनयापयि मिजे पिनोङ। ");
INSERT INTO tcn_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ता नामयाङ मिसिनयापयि मिजे धि राङ ना, कि हतिबे ख्योएला, च्हि मात्रा तेम्बा कजसुबा ङोस्येयोङ, राङ ख्युइ चाँचाँबि येशु ख्रिष्टला ङोस्येयोङ। ");
INSERT INTO tcn_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","काङ लाइ ख्युइ ङाला पिन्दे, हति पुरा क्याइरे ख्योएला पृथ्‍वीला ङाहि छे तेतेका होतो। ");
INSERT INTO tcn_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ता हे आके, संसार सोयापले ताङला ख्युइ धुनला ङाहि काङ छे तेतेका होतो, हति ख्योए राङ ताताताला ङाला छे थे। ");
INSERT INTO tcn_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“संसारने काङ मितेबा ख्युइ ङाला पिन्दे हतिबाला ख्युइ मिन ङाहि थोङदु च्युच्युका होतो। हतिबा ख्युइ ना, तेहि ख्युइ हतिबा ङाला पिन्सोङ, राङ हतिबे ख्युइ वचन खाला ङ्याङ्याना होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ता हतिबाला ता छ्या होतो, कि ख्युइ ङाला पिपिना पोरो क्यु ख्योएने लेलेबाना। ");
INSERT INTO tcn_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","चिचालानाना काङ वचन ख्युइ ङाला पिपिना होतो, ङाहि खेला पिन्दे, राङ खि याङ हति ङ्यान्दे। राङ ङा ख्योएने लेलेबा ना नाइरे हतिबे तेम्बारे हा:कोदु, तेहि ख्युइ ङाला चाँचाँबा ना नाइरे हतिबे हिछे क्याक्याइबा होतो। ");
INSERT INTO tcn_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ङा हतिबे चाला मोनलाम क्याकच्याइ, संसारयि चाला ङा मोन्लाम मिक्या, हिन्नाङ हतिबे चाला, सुला ख्युइ ङाला पिन्दे। चिचालानाना हतिबा ख्युइ राङ ना। ");
INSERT INTO tcn_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ङाला च्हि होतो हतिबा पोरो ख्युइ ना, ख्युइ च्हि होए ङाहि ना। ङाहि छे तेतेका खि तेहा थोथोङा होतो। ");
INSERT INTO tcn_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“ता ङा याङ संसारला मितोए, हिन्नाङ हतिबा ता संसारला तोकिन। ङा ख्युइ तेहा हुन होए। पवित्र आके, ख्युइ ङाला पिपिना ख्युइ मिनला ता क्याप्ते पोर, राङ हु च्वरा हतिबा हाङ च्हि ना।” ");
INSERT INTO tcn_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","जब थु ङा खे ङ्याबो होतो, ख्युइ ङाला पिपिना ख्युइ मिनलाता क्याप्ते पोर। हतिबाला च्याङ होङदु माजु। तेहि हतिबाने मासि होङयाप ते अर्थात सुवाङ मासि मा च्युङसोङ चिचालानाना पवित्रशास्त्रा पुरा होङ कोहिि राङ होतो। ");
INSERT INTO tcn_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“ता ङा ख्युइ तेहा हुन होए। संसारला होतितुइना ङा धि ताम नेन, कि खेला ङाहि जब याङ मिसिनयापयि हतिबाला ङाहि क्याप पुरा होङ।” ");
INSERT INTO tcn_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ङाहि हतिबाला ख्युइ वचन पिन्दे हिन्नाङ संसारयि खेला अल क्याइसोङ चिचालानाना खे संसारयि माना, च्हिरु क्याइरे ङा संसारयि माना। ");
INSERT INTO tcn_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ख्युइ हतिबाला संसारने खेर नाइरे ङा मोनलाम मिका हिन्नाङ हतिबाला अलने क्याप। ");
INSERT INTO tcn_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","हतिबा संसारयि माना, च्हिरु क्याइरे ङा धि संसारयि माना। ");
INSERT INTO tcn_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","हतिबाला तेम्बाला पवित्र सोइ, ख्युइ वचन तेम्बा ना। ");
INSERT INTO tcn_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","च्हिरु क्याइरे ख्युइ ङाला संसारला चाँरे, ङाहि याङ हतिबाला संसारला चाँरे। ");
INSERT INTO tcn_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","हतिबे चाला ङा ङारि ङाराङला पवित्र स्युन होए, तेहि हतिबा हाङ तेम्बाला पवित्र होङ। ");
INSERT INTO tcn_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","ङा हतिबे चाला मात्रा मोनलाम मिक्या, हिन्नाङ हतिबे लोनने ङाहि थोला हिछे किङानयि चाला हाङ मोनलाम क्याकच्याइ, ");
INSERT INTO tcn_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","कि खे पोरो च्हि होङ हे आके, च्हिरु क्याइरे ख्योए ङाहि तेहा होतो, राङ ङा ख्योएला, हति च्वरा क्याइरे हुला होङ, राङ ख्युइ ङाला चाँरे नाइरे संसारयि हिछे क्यायोङ। ");
INSERT INTO tcn_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","काङ छे ख्युइ ङाला पिपिना होतो, ङाहि हतिबाला पिन्दे, तेहि हु च्हि च्युच्युवा च्वरा हतिबा हाङ च्हि होङ। ");
INSERT INTO tcn_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ङा हतिबाला, तेहि ङा खेला, राङ खे पोरो काङ च्याने च्हि होङ, राङ ख्युइ ङाला चाँचाँबा ना, तेहि ङाला करि क्याक्याइबा च्वरा हतिबा लाङ क्यायोङ नाइरे संसारयि हा:कोहोङ। ");
INSERT INTO tcn_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“आके ङा धोप्पा कि च्याइ, कि ख्युइ ङा ला पिपिना तेबा ङा काँहा होए, ङा ङ्याबो त्येयोङ राङ ङाहि छे थोङङोङ, काङ छे, संसारयि सोयापले ताङला ङाला करि क्याक्याइबा ति ख्युइ ङाला पिपिना होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“तेम्बायि आके, संसारयि ख्योएला ङोमिस्येबा, हिन्नाङ ङाहि ख्योएला ङोस्येयिन तेहि ख्युइ ङाला चाँरे नाइरे धिबाला छ्या होतो। ");
INSERT INTO tcn_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ङाहि ख्युइ मिन धिबाला थोङदु च्युकते, तेहि ख्युइ मिन धिबाला थोङदु च्युच्युकि च्युच्युका कि च्याइ, तेहि काङ करि ख्युइ ङाला करि क्याइरे, धि हतिबाला त्येयोङ, राङ ङा खेला त्येयोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","धि च्येला मोनलाम क्याप्ते येशु खुरि लोब्टुबा ङ्याबो किद्रोनला पुइसोङ। हतिया पाङ झि धुलो। येशु खुरि लोब्टुबा ङ्याबो हतिया स्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","खोला सुङदु झ्युङान यहुदाला हाङ हति सा छ्या होतो, चिचालानाना येशु माङछेया खुरि लोब्टुबा ङ्याबो हतिया झोम्दे तोकिनलो। ");
INSERT INTO tcn_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","तेहि भिजोउलि, म्हे राङ लाकच्या ख्योक्योबि सिपाहियि तुम झि राङ घोबा पुजारि राङ फरिसिबे चाँचाँबि कोराबा ख्योरे यहुदा हति पाङला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","तेहि रेँ थोला होङयापयि ताम पोरो हा:कोरे येशु धुनला लेप्सोङ, राङ हतिबाला नाइसोङ, “खे सुला फाकिन?” ");
INSERT INTO tcn_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","हतिबे खोला नाइसोङ, “नासरतयि येशुला।” येशुयि हतिबाला नाइसोङ, “ङा हति राङ ना।” तेहि खोला सुङदु झ्युङान यहुदा याङ हतिया लाँरे तेतु। ");
INSERT INTO tcn_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","जब ख्युइ हतिबाला “ङा हति राङ ना” नाइरे तेहि हतिबा क्यापला पुइसोङ, तेहि साला घेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","याङ ख्युइ हतिबाला टिसोङ, “खे सुला फा किन?” हतिबे नाइसोङ, “नासरतयि येशुला।” ");
INSERT INTO tcn_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","येशुयि जवाक पिन्सोङ, “ङाहि खेला नाइछारते, ङा हति राङ ना। हति चाला खे ङाला फेना धि मितेबाला ढोरु छ्यु।” ");
INSERT INTO tcn_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","“ख्युइ ङाला पिपिनि नाङने च्हि याङ ङाहि मासि मालाङा नाइरे नानाइबि वचन पुरा होङ नाइरे धि च्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","सिमोन पत्रुसयि खो राङला होएता तोरबालि तोन्दे हति यक्पुवाला क्यापते हति जब नामज्यो याइबाते तुप्ते क्युरसोङ। घोबा पुजारि यक्पुवायि ति मिन माल्खस हिना। ");
INSERT INTO tcn_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","येशुयि पत्रुसला नाइसोङ, “तोरबालि तोर स्युपला छ्यु। च्हि आकि पिपिनि भोटोला ङा मिथुवाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","हतिच्येला रोमि सिपाहियि तुम, हतिबे घोबा, राङ यहुदिबे कोराबाबे येशुला सुङसोङ, राङ खोला ताम्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ताङला हतिबे खोला हन्‍नासयि तेहा खेरसोङ, सुते धि लोयि घोबा पुजारि कैयाफायि मेमे हिना। ");
INSERT INTO tcn_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","खो हति कैयाफा राङ हिना, सुइ जनतातेबे चाला मिझि स्योएयाप राङ ल हुन नाइरे यहुदिबाला टोइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","सिमोन पत्रुस राङ येशुयि स्यान लोब्टु झि येशुयि च्येला पुइसोङ। हति स्यानते घोबा पुजारि ङोस्येस्येबा हिना, राङ येशु ङ्याबो राङ क्यला स्युरे। ");
INSERT INTO tcn_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","हिन्नाङ पत्रुस फिला कोना राङ लाँरे तेतु। हति स्यान लोब्टुते, सुते घोबा पुजारि ङोस्येङान हिना लो, फिला कोना त्योएङानयि पोमुला नाइरे पत्रुसला नाङला ख्योसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","तेहि हति कोना त्योएङान यक्मुवाति पत्रुसला नाइसोङ, “च्हि ख्योए याङ धि मि लोब्टुयि नाङने च्हि हिनाइ?” पत्रुसयि नाइरेलो, “ङा माना।” ");
INSERT INTO tcn_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","हतिया कोराबा रच्चिया यक्पुवातेबा लाँरे म्हे धि त्येतु चिचालानाना टाङ मि धुलो। तेहि पत्रुस याङ लाँरे हतिबा ङ्याबो म्हे धियाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","तेहि घोबा पुजारि येशुयि लोब्टु राङ ख्युइ छोइ यि भारेला टिसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","येशुयि हतिला जवाक पिन्सोङ, “ङाहि संसारला मिसाँबा नाइरे। ङाहि बारतै यहुदि झोमसि खिम राङ मोनलाम क्यासि खिमला छोइ पिपिना होतो, काँहा यहुदिबा पोरो झोमिन। ङाहि फाला च्याङ नानाइबा मेता। ");
INSERT INTO tcn_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ङाला च्हिला ढिन? ङाहि खेला च्हि नाइरे ङ्यानङानतेबा ला राङ टि। ङाहि नानाइबि ताम तेबा हतिबाला छ्या होतो।” ");
INSERT INTO tcn_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","येशुयि धि तामतेबा नेतुइना धुनला लाँलाँबि कोराबाझि कि जु नेन राङ येशुला थालच्या क्यापसोङ, “च्हि घोबा पुजारि ङ्याबो धि च्वरा क्याइरे जवाक तेरिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","येशुयि हतिला नाइसोङ, “ङाहि घल नाइना हति प्रमाण नाङ हिन्नाङ तेम्बारे ङाहि थारका नाइना च्हिला ङाला क्याप्ते?” ");
INSERT INTO tcn_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","तेहि हन्‍नासयि तातामा ला राङ घोबा पुजारि कैयाफा यि तेहा चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","सिमोन पत्रुस लाँरे म्हे धि तेतु। हतिबे खोला नाइसोङ, “च्हि ख्युइ लोब्टुबे नाङने च्हि ख्योए याङ मानाइ च्हि?” हति माना नाइरे नाइसोङ, “ङा माना।” ");
INSERT INTO tcn_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","घोबा पुजारि यक्पुवायि नाङने च्हि, सुइ पुल्लायि जब पत्रुसयि तुप्तु, हति टिसोङ, “च्हि ङाहि ख्योएला खो ङ्याबो पाङला माथोङाइ च्हि?” ");
INSERT INTO tcn_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","तेहि याङ पत्रुसयि माना नाइसोङ। तेहि होप:तामेला च्याबो पोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","तेहि हतिबे येशुला कैयाफायि खिमने खिम छोम्मुवा हअला खेरसोङ। हति तुना नामे हिना। झोम्दे निस्तार कालापसोलयि भत्यार साज्याइ मिखुबा नाइरे हतिबा खिम छोम्मुवायि नाङला मास्युवालो। ");
INSERT INTO tcn_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","तेहि हतिबे तेहा फिला थोन्दे पिलातसयि नाइसोङ, “धि मि विरोधला खे च्हि आरोप लाइ किन?” ");
INSERT INTO tcn_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","हतिबे खोला नाइसोङ, “तेम्बारे धि मि अपराधि माना नाना ता ङे ख्योएला चिचाला सोच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","पिलातसयि हतिबाला नाइसोङ, “खे धिला खेर, राङ खिरि ठिमने धिला ठिम कि।” यहुदिबे खोला नाइसोङ, “मि सुलाङ स्योएपयि आङ ङेला, मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","खो च्हिरु क्याइरे सिन नाइरे हति ता पिन्दे येशुयि नानाइबि वचन पुरा होङ नाइरे धि च्वरा च्युच्युङा ना। ");
INSERT INTO tcn_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","पिलातस याङ खिम छोम्मुवायि नाङला स्यु सोङ, राङ ख्युइ येशुला क्ये ताङदे नाइसोङ, “च्हि ख्योए यहुदिबे क्यालबो हिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","येशुयि जवाक पिन्सोङ, “ख्योए ख्योएराङ धि च्वरा नेन्दु, वा ङाहि भारेला ख्योएला स्यान यि नाइसुइ?” ");
INSERT INTO tcn_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","पिलातसयि जवाक पिन्सोङ, “च्हि ङा यहुदि हिन दुये? ख्युइ मितेबा राङ घोबा पुजारि ख्योएला ङाला टोएसोङ। ख्युइ च्हि क्याइरे?” ");
INSERT INTO tcn_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","येशुयि जवाक पिन्सोङ, “ङाहि राज्य धि संसारयि माना। ङाहि राज्य धि संसारयि हिना ता ङाला रुवा किङान तेबा ङाहि चाला रुवा किङान ना, राङ ङा यहुदिबे लला थेपङान माना ना। हिन्नाङ ङाहि राज्य धि संसारयि माना।” ");
INSERT INTO tcn_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","पिलातसयि खोला टिसोङ, “च्हि ख्योए क्यालबो राङ हिनाइ?” येशुयि जवाक पिन्सोङ, “ङा क्यालबो ना नाइरे ख्योए राङ नेन दु, धि चाला राङ ङा क्येक्येबा ना, राङ हति चाला राङ धि संसारला तेम्बि साछि तेरतु लेलेबा ना। पोरो सु तेम्बि छ्याला होतो, हति ङाहि क्ये थोयिन।” ");
INSERT INTO tcn_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","पिलातसयि खोला टिसोङ, “तेम्बा च्हि ना?” होचोम नाइरे यहुदिबे तेहा फिला थोन्दे पुइसोङ, राङ हतिबाला नाइसोङ, “ङाहि खोला च्याङ दोष मि ठाता।” ");
INSERT INTO tcn_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","निस्तार कालापसोलला ङाहि मिझिला खि चाला तोङयाप खि माग होतो। च्हि खे धोप्पा किनाइ, कि यहुदियि क्यालबोला तोङज्ये? ");
INSERT INTO tcn_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","हिन्नाङ हतिबे जु नेन राङ क्ये तोन्सोङ, “धि ला माना हिन्नाङ बारब्बाला।” बारब्बा ते डाकु हिना। ");
INSERT INTO tcn_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","तेहि पिलातसयि येशुला खेरते च्यायि छेरिमिन च्यालता क्याक्तु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","तेहि सिपाहितेबे ख्युइ घोबोला छेरमि टोपो कापसोङ, राङ खोला बैजनी छोइयि कोहिला कापसोङ, ");
INSERT INTO tcn_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","राङ ख्युइ धुनला लेप्ते नाइसोङ, “खामसाँ, यहुदिबे क्यालबो!” तेहि हतिबे खोला थालच्या क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","याङ फिला थोन्दे पिलातसयि हतिबाला नाइसोङ, “तोइ, ङाहि खोला खि तेहा ख्युहि होए, राङ खेला हा:कोरु झ्युकच्याइ, ङाहि खोला च्याङ दोष मिथुवा।” ");
INSERT INTO tcn_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","तेहि छेरमि टोपो राङ बैजनी छोइयि कोहिला कोकोना येशु फिला लेप्सोङ, राङ पिलातसयि हतिबाला नाइसोङ, “तोइ, धि मिला!” ");
INSERT INTO tcn_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","जब घोबा पुजारि राङ कोराबातेबे खोला थोङसोङ, हतिबे जु नेन राङ क्ये तोन्सोङ, “हतिला क्रुसला थ्ह, हतिला क्रुसला थ्ह!” पिलातसयि नाइसोङ, “खे राङ धिला क्रुसला पुते थ्ह, चिचालानाना ङाहि धि ला च्याङ दोष मिखुबा!” ");
INSERT INTO tcn_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","यहुदिबे खोला नाइसोङ, “ङि ठिम झि होतो, राङ हति ठिम च्वरा हिन्ना धि सि कोहिराङ हुन, चिचालानाना खो खोराङ कजसुबे पिजा हिना नेन्दु।” ");
INSERT INTO tcn_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","धि ताम थोइरे पिलातस झन ख्यारसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","खो याङ खिम छोम्मुवायि नाङला स्युरे येशुला टिसोङ, “ख्योए काने ना?” हिन्नाङ येशुयि खोला च्याङ मानाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","हतिचाला पिलातसयि खोला नाइसोङ, “च्हि ख्योए ङा ङ्याबो ताम मिनाइ? ख्योएला तोङयापयि आङ ङाला होतो, राङ ख्योएला क्रुसला धपापयि आङ याङ ङाला होतो नाङान ख्योएला छ्या मेताइ?” ");
INSERT INTO tcn_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","येशुयि जवाक पिन्सोङ, “ख्योएला कजसुबे मापिना नाना ङाहि थोला च्याङ आङ मिहा। हति चाला ङाला ख्युइ लाला तेरङानते झन तिक्पि दोषि हुन।” ");
INSERT INTO tcn_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","हतिच्येला पिलातसयि खोला तोङयापयि लेइराङ कोशिश क्याइसोङ। हिन्नाङ यहुदिबे जु नेन राङ क्ये तोन्सोङ, “तेम्बारे ख्युइ धि मिला ताङना ख्योए कैसरयि रबो माना। रेँ राङला क्यालबो हिना नाङान पोरो कैसरयि विरोधला लाँयिन।” ");
INSERT INTO tcn_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","पिलातसयि धि ताम थोइरे येशुला फिला ख्योसोङ, राङ खो? “टोउयि” छ्या नाङानयि साला (काङतेला हिब्रुला गब्बथा नेन) ल अल भेयापयि ठिला त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","हति भेलाते निस्तार कालापसोलयि तयारि ङिन हिना, ङिम्मुइ हा:लाम च्युनङि बजेना माला हिना। पिलातसयि यहुदिबाला नाइसोङ, “तोइ खि क्यालबो!” ");
INSERT INTO tcn_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","हिन्नाङ हतिबे जु नेन राङ क्ये तोन्सोङ, “धिला सोए, सोए, धिला क्रुसला थ्ह!” घोबा पुजारिबे जवाक पिन्सोङ, पिलातसयि हतिबाला टिसोङ, “च्हि ङा खि क्यालबोला क्रुसला ध्हच्ये?” “कैसर अर्थात ङि स्यान सुङ क्यालबो मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","तेहि ख्युइ येशुला क्रुसला धतु हतिबे लाला सातेलो। हति चाला सिपाहितेबे जिम्माला खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","खो खुरि क्रुस खुरते खप्पेर नाङान साला पुइसोङ, काङला हिब्रुला गलगथा नेनलो। ");
INSERT INTO tcn_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","हतिया खोला क्रुसला तारेलो राङ खो ङ्याबो स्यान ङि लाङ तारेलो, च्हिला यि च्हिला राङ स्यानतेला स्यान यहला तारेलो, राङ उइला येशुला। ");
INSERT INTO tcn_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","पिलातसयि दोष पाना झि याङ टिसोङ, तेहि क्रुसला च्यारसोङ। हतिला धि टि धुलो, “नासरतयि येशु, यहुदिबे क्यालबो।” ");
INSERT INTO tcn_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","तेहि यहुदि लेइराङयि हति दोष पानाते टसोङ, चिचालानाना येशु क्रुसला ताताबि सा भजारयि धुनला धुलो। हति हिब्रु, लाटिन राङ ग्रिक क्येला टिदुलो। ");
INSERT INTO tcn_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","यहुदिबे घोबा पुजारियिति पिलातसला नाइसोङ, “‘यहुदिबे क्यालबो’ नायाप माना, हिन्नाङ हति यहुदिबे क्यालबो हिना नाइसोङ नाइरे ढोयाप ना।” ");
INSERT INTO tcn_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","पिलातसयि जवाक पिन्सोङ, “ङाहि च्हि टिरे, टिरे।” ");
INSERT INTO tcn_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","जब सिपाहियि येशुला क्रुसला तारेलो, हतितुइना ख्युइ कोहिला खेरते ओरला च्यिच्यि थोपयापयि हिसाबला भाग च्हि सोइसोङ। ख्युइ फि कोहिला याङ खेरसोङ, हति कोहिला ते चेचेमा माना तोएने राङ म्हे थु लालाइबा किरबो हिना। ");
INSERT INTO tcn_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","हतिचाला हतिबे ख्होरे नाङला नारे क्याइसोङ, “धि मारोल हिन्नाङ धि सुइ होङयाप हिना नाइरे क्यान स्यिङ क्याका।” पवित्रशास्त्रा पुरा होङ नाइरे राङ धि च्युङ शास्त्रा “हतिबे ङाहि कोहिला राराला साला कोइसोङ, फि कोहिलाते क्यानसिङ क्यापसोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","हति चाला सिपाहितेबे धि लाइ क्याइरे लो। तेहि येशुयि क्रुसयि धुनला ख्युइ आमा, ख्युइ आमायि भैनि, क्लोपासयि भैनि मरियम राङ मरियम मग्‍दलिनी लाँरे तेतु। ");
INSERT INTO tcn_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","जब येशुयि खुरि आमा राङ ख्युइ करि किङान लोब्टु टुला लालाबा थोङसोङ, हतितुइना ख्युइ खुरि आमाला नाइसोङ, “पोमु तेहि, ख्युइ पिजा!” ");
INSERT INTO tcn_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","तेहि हति लोब्टुतेलाङ नाइसोङ, “तेहि ख्युइ आमा!” हति भेला ने हति लोब्टुति मोला खुरि खिमला खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","तहि च्येलाता येशुयि ताम पोरो सिन्सोङ नाइरे हा:कोरे पवित्रशास्त्रा पुरा होङ नाइरे नाइसोङ, “ङा खा कोम्सोङ।” ");
INSERT INTO tcn_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","खाडे खुवायि खाँखाँबि सअबुझि धुलो। खुवायि खाखा बे क्पास होसपयि ढालाला पोरते हति ख्युइ खाला क्यालसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","तेहि येशुयि खुबा तुइसोङ, तेहि ख्युइ नाइसोङ, “ता सिन्सोङ, ”तेहि ख्युइ घोबो थुल्ला क्याइरे रेँ उ च्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","हति ङिन छेलयापयि ङिनलो। हति चाला यहुदि आङकिङानबे ङालसुइ ङिन स्यिस्यियायि स्हु क्रुसला माभोर नाइरे पिलातसला स्युवा क्याप्सोङ, राङ हतिबे काङ च्याक्ते हतिबा ला खेर नाइरे माग क्याइसोङ ");
INSERT INTO tcn_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","तेहि सिपाहि तेबा लेप्ते खो ङ्याबो क्रुसला ताताबातेबे काङबा च्यासोङ, ताङला चिकि राङ च्हिला स्यान त्हि। ");
INSERT INTO tcn_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","तेहि हतिबा येशुयि तेहा लेप्सोङ हतिबे थोङसोङ, कि येशु तेकि राङ स्यिदु नाइरे, राङ ख्युइ काङबा माच्याँका लो। ");
INSERT INTO tcn_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","हिन्नाङ सिपाहतिबे नाङने च्यियि ख्युइ चिमाला च्यायि पोरकि चासोङ, तेहि युप्पु झिला ठा राङ छ्यु थोन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","खे याङ हिछे कि नाइरे थोङान तेबे साछि पिपिना ना। राङ ख्युइ साछि तेम्बा ना, राङ तेम्बा नेन नाइरे हा:कोरेलो। ");
INSERT INTO tcn_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“ख्युइ रेँ रुइको च्हि याङ च्यकोइ मिदु” नाङान यि पवित्रशास्त्रयि धि वचन पुरा होङ नाइरे धि ताम च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","याङ स्यान साला पवित्रशास्त्रा नेनदु, “काङला खि सुरतु हतिबे खोला ताङान माना ना।” ");
INSERT INTO tcn_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","हतिच्येला आरिमाथियि योसेफ, काङते यहुदिबाला झिरे फा:ला मात्रा येशुयि लोब्टु हिना, हति पिलातसला येशुयि रो खेरच्याइ नाइरे स्युवा क्यापसोङ। पिलातसयि आङ पिन्सोङ। तेहि खो लेप्ते स्यिस्यिये स्हु खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","तेहि तकि छाम्मु होङान निकोदेमस याङ हा:लाम ङिस्यु राङ च्यु किलो मुर्र राङ एलवा स्येस्येबा ल टिमायि मोरकु ख्योहोरे लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","हति च्वरा क्याइरे येशुयि स्यु यहुदिबे रो तहयापयि लुलाम च्वरा क्याइरे टिमा स्यिबो मलम राङ ङ्याबो कोहिलायि तुम्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","खोला क्रुसला ताताबि साला हतिया पाङ झि धु। हति पाङला च्याङ मापोरि तुर झि धु। ");
INSERT INTO tcn_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","चिचालानाना यहुदिबे तयारियि ङिन हिना, तेहि हति तुर याङ धुनला धु, राङ तेहि हतिबे येशुयि स्हु हति तुरला राङ पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","हप्तायि ताङस्युवा ङिन नामे मुन्नाला राङ मरियम मग्‍दलिनी नाङान तुरला लेप्सोङ, राङ मुइ टोउ तुरने टिटिमा थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","हति सिमोन पत्रुस राङ येशुयि करि किङान स्यान लोब्टुते स्युरते पुइसोङ, तेहि हतिबाला नाइसोङ, हतिबे प्रभुला तुरने फिला खेरतु, राङ खोला काँहा पोरते, ङेला छ्या मेता। ");
INSERT INTO tcn_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","तेहि पत्रुस राङ स्यान लोब्टुते फिला थोन्दे तुर यहला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","हतिबा ङिकार ङ्याबोङ्याबो स्युरे पुइसोङ, तेहि स्यान लोब्टुते पत्रुसला पोरते ताङला तुरला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","तुरयि नाङला घोबो कहुरे तेतुइना, ख्युइ तेकि लाइ तातामि सुतियि कोहिला मात्रा होएता थोङसोङ, हिन्नाङ खो नाङला मास्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","सिमोन पत्रुस च्येच्येला लेप्सोङ, राङ तुरयि नाङला स्युसोङ, ख्युइ याङ मलमलयि तातामि कोहिला मात्रा थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ख्युइ घोबोला तातामि रुमालते मलमलयि कोहिला ङ्याबो मिधु हिन्नाङ कुरु सा झिला ताप्ते पोरतुलो। ");
INSERT INTO tcn_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","तेहि तुरला ताङला होङान स्यान लोब्टुते हाङ नाङला स्युसोङ, राङ हति थोङसोङ हति हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","चिचालानाना हतिबे खो स्यिरे लाँ कोहिहुन नाङान पवित्रशास्त्रायि ताम थाल्ला थु हा:कोकुवा मेता। ");
INSERT INTO tcn_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","हतिच्येला हति लोब्टुबा खिमला लक्ते पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","हिन्नाङ मरियम तुरयि फिला ङुन राङ तेतु। मो ङुन राङ तुर यहला घो कहुरे ताइसोङ, ");
INSERT INTO tcn_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","राङ काँहा येशुयि स्यिस्यियायि स्हु पोपोरा होतो, हतिया कारबो कोहिला कोकोना तेङलायि लोन खेरङान ङेला च्यिते घोबोला राङ च्यि काङबा यहला ताताता मुइ थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","हतिबे मोला नाइसोङ, “पोमु चिचाला ङुन?” मुइ हतिबाला नाइसोङ, “हतिबे ङाहि प्रभुला खेरतु, खोला काँहा पोरते, ङाला छ्या मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","धि ताम नाइरे छारते मो क्याप यहला ताइसोङ, राङ मुइ येशु लाँरे ताताता थोङसोङ हिन्नाङ येशु राङ हिना नाइरे ङोमास्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","येशुयि हतिला नाइसोङ, “पोमु ख्योए चिला ङुन? सुला फाकिन?” मुइ हतिला पाङयि चा तुप्ङान हिना नाइरे नाइसोङ, “हजुर, ख्युइ खोला धिने खेखेरा हिन्ना, काँहा पोरते ङाल नोइ, राङ ङा खोला खेरच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","येशुयि हतिला नाइसोङ, “मरियम!” ख्युइ लक्ते मोला हिब्रुला नाइसोङ, “रब्बिनि,” मदलब “हे गुरुज्युनि!” ");
INSERT INTO tcn_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","येशुयि मोला नाइसोङ, “ङाला लाक्पा माधो, चिचालानाना ङा थाल्ला थु आकि तेहा मा पुता। हिन्नाङ ङाहि भाइबे तेहा पुते हतिबाला नोइ, ‘ङाहि आके राङ खि आके, राङ ङाहि कजसुबा राङ खि कजसुबे तेहा ढुन होए।’” ");
INSERT INTO tcn_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","मरियम मग्दलनि पुइसोङ, राङ लोब्टुबाला स्येसोङ, “ङाहि प्रभुला थोङसोङ।” तेहि ख्युइ नानाइबि ताम हतिबाला मुइ नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","हति ङिन, मदलब हप्तायि ङिन ताङस्युवा कमु, जब लोब्टुबा यहुदिबाला झिरे को क्यापते नाङला ताताता धुलो, येशु लेप्ते हतिबे उइला लाँरे त्येसोङ, राङ हतिबाला नाइसोङ, “खेला शान्ति!” ");
INSERT INTO tcn_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","हति नाइरे हतिबाला रेँ टाङ राङ लाक्पा तान्सोङ। प्रभुला थोङदे लोब्टुबा कासोङ। ");
INSERT INTO tcn_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","तेहि याङ येशुयि हतिबाला नाइसोङ, “खेला शान्ति! च्हिरु क्याइरे आकि ङाला चाँसोङ, हति च्वरा क्याइरे ङा खे ला चोङज्याइ।” ");
INSERT INTO tcn_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","तेहि होचोम नाइरे ख्युइ हतिबे थोला उ ताङदे नाइसोङ, “पवित्र आत्मा खेर। ");
INSERT INTO tcn_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","सुइ मियि तिक्पा खे माप किन हतिबे तिक्पा झ्हयिन, राङ सुइ तिक्पा माप मिकिता हति तिक्पा माप मिहा।” ");
INSERT INTO tcn_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","येशु हुइतुइना च्युनङियि नाङने चि, दिदुमास नाङान थोमाते, हतिबा ङ्याबो मिधु। ");
INSERT INTO tcn_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","हतिचाला स्यान लोब्टुतेबे खोला नाइसोङ, “ङाहि प्रभुला थोङसोङ।” हिन्नाङ ख्युइ हतिबाला नाइसोङ, “जब थु ङाहि ख्युइ लक्पाला किलोयि मेटा मिथुवा, राङ किलोयि मेटाला झु मिसुरा, ख्युइ टाङला लाक्पा मिसुरा, हति थु ङा हिछे मिके” ");
INSERT INTO tcn_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ङिन क्येयि च्येला याङ ख्युइ लोब्टुतेबा खिमयि नाङला राङ धु। थोमा याङ हतिबा ङ्याबो धु। को तेबा क्यापतु हिन्नाङ येशु नाङला स्युसोङ, राङ उइला लाँरे नाइसोङ, “खेला शान्ति!” ");
INSERT INTO tcn_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","तेहि ख्युइ थोमाला नाइसोङ, “ख्युइ झु ङिया पोर, राङ ङाहि लाक्पातेबा तोइ। ख्युइ लाक्पा ख्योरे ङाहि टोपाला छ्यु। हिमिछे माके राङ हिछे किङान सह।” ");
INSERT INTO tcn_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","थोमायि खोला नाइसोङ, “ङाहि प्रभु, राङ ङाहि कजसुबा!” ");
INSERT INTO tcn_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","येशुयि हतिला नाइसोङ, “ख्युइ ङाला थोथोति चाला ङाला हिछे क्याइसोङ? धन्य ना हतिबा, सुइ ङाला थोथोङा मेता हिन्नाङ हिछे किन्दु।” ");
INSERT INTO tcn_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","येशुयि लेइराङ हा:लाइयापयि लाइतेबा लोब्टुबे धुनला क्याइसोङ, काङते धि किताबला टिटिबा मेता। ");
INSERT INTO tcn_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","हिन्नाङ धि टिटिबा होतो, कि खि येशु कजसुबे पिजा, ख्रिष्ट होतो नाइरे हिछेयि लाम्ला ख्युइ मिनला खेला मिजे खुवार सह। ");
INSERT INTO tcn_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","हतिच्येला लोब्टुबे तेहा तिबेरियास छो छोम्मुवायि धुनला येशुयि याङ खो राङला तानसोङ। ख्युइ खो राङला धि च्वरा क्याइरे थोङदु च्युसोङ: ");
INSERT INTO tcn_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","सिमोन पत्रुस, दिदुमास नाङ थोमा, गालिलयि काना भजारयि नथानेल, जब्दियायि पिजा ङिबो राङ ख्युइ लोब्टुबे नाङने स्यान ङिबो ङ्याबो धुलो। ");
INSERT INTO tcn_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","सिमोन पत्रुसयि हतिबाला नाइसोङ, “ङा ङ्या सोतु ढुन होए।” हतिबे खोला नाइसोङ, “ङेला याङ ख्योए ङ्याबो होङज्याइ।” हतिबा पुते डुङगाला स्योसोङ हिन्नाङ हति छाम्मु हतिबे च्याङ मासुङा। ");
INSERT INTO tcn_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","नामे हुवाला छेलसोङ, येशु छ्युइ नेमुला लाँरे तेतु। हिन्नाङ लोब्टुबे खो येशु राङ हिना नाइरे ङोमास्येबा। ");
INSERT INTO tcn_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","येशुयि हतिबाला नाइसोङ, “च्हिटाबा, खेला ङ्या रेन होतोइ?” हतिबे खोला जवाक पिन्सोङ, “मेता।” ");
INSERT INTO tcn_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ख्युइ हतिबाला नाइसोङ, “झालि डुङगायि याइ यहला छ्यु, तेहि खुङान ना।” तेहि हतिबे झालि च्युसोङ, राङ ङ्या माहारा छेरे हतिबे धोन माङ्युइसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","येशुला करि किङान लोब्टुति येशुला नाइसोङ, “खो प्रभु हिना ये।” “खो प्रभु हिना” नाङान थोइरे सिमोन पत्रुसयि रेँ फियि कोहिला केप्पाला तामसोङ, चिचालानाना ख्युइ कोहिला पुइतु राङ छुला फारसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","स्यान लोब्टुतेबा डुङगाला राङ ताते ङ्या थेथेबि झालि ढुन किनराङ लेप्सोङ। हतिबा छोयि नेमुला घ्याबोला माना, हिन्नाङ हा:लाम मिटर क्या झि झोमयि घ्याबोला धु। ");
INSERT INTO tcn_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","जब हतिबा नेमुला पुप्ते, हतितुइना हतिबे सोलायि थपुङला ङ्या पोपोरा लोटा थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","येशुयि हतिबाला नाइसोङ, “थाल्ला खि सुसुङायि ङ्याने रेन ख्याला।” ");
INSERT INTO tcn_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","तेहि सिमोन पत्रुस पुते डुङगाला स्योन्दे क्या राङ ङोपच्यु राङ सुम थाबा ङ्या छोम्मुवायि खाँखाँबि झालि पाङला टुइसोङ, हिन्नाङ होचोम होएनाङ झालि मारालसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","येशुयि हतिबाला नाइसोङ, “लेप्ते सो।” लोब्टुबे नाङने सुइ याङ “ख्योए सुना?” नाइरे ढि माङ्युइसोङ, चिचालानाना खो प्रभु हिना नाङान छ्या होतो। ");
INSERT INTO tcn_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","येशु लेप्सोङ राङ हतिबाला लोटा पिन्सोङ। हति च्वरा क्याइरे ङ्यायाङ पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","स्यिरे सोम्बो च्युङदे लाँरे लेलेबा येशु लोब्टुबे तेहा थोथोङा लाम्मा सुबा हिना। ");
INSERT INTO tcn_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","जब हतिबे साइ छारसोङ, हतितुइना येशुयि सिमोन पत्रुसला नाइसोङ, “युहान्नायि पिजा सिमोन, च्हि ख्योए धिबाले म्हा ङाला करि किनाइ?” हति खोला नाइसोङ, “ज्यु प्रभु, ख्योएला छ्या होतो ङा ख्योएला करि किन।” ख्युइ हतिला नाइसोङ, “ङाहि लुतेबाला सायाप पिन।” ");
INSERT INTO tcn_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ख्युइ याङ लाम्मा सुबा हतिला नाइसोङ, “युहान्नायि पिजा सिमोन, च्हि ख्योए ङाला करि किनाइ?” ख्युइ खोला नाइसोङ, “ज्यु, प्रभु, ख्योएला छ्या होतो, ङा ख्योएला करि किन।” ख्युइ हतिला नाइसोङ, “ङाहि लुबाला ल क्याइरे तोइ।” ");
INSERT INTO tcn_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ख्युइ हतिला लाम्मा सुबा टिसोङ, “युहान्नायि पिजा सिमोन, च्हि ख्योए ङाला करि किनाइ?” पत्रुसयि सम तुसोङ, चिचालानाना ख्युइ लाम्मा सुबा खोला “च्हि ख्योए ङाला करि किनाइ?” नाइसोङ। ख्युइ हतिला नाइसोङ। “प्रभु, ख्योएला ताम पोरो छ्या होतो।” ङा ख्योएला करि किन नाइरे ख्योएला छ्या होतो येशुयि हतिला नाइरेलो, “ङाहि लुबाला तोइ।” ");
INSERT INTO tcn_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","तेम्बारे, “ङा ख्योएला नाज्याइ, जब ख्योए स्यारा होतो ख्योए खुरि कारा ख्युरि किसोङ, राङ काँहा ढोसोम होए ढुन्दु। हिन्नाङ जब ख्योए काप्पो हुन, तेहि ख्योए खुरि लाक्पा क्योङान ना, राङ स्यानयि ख्युइ कारा छिङान ना, राङ काँहा ख्योए ढोसोम म्हे हतिया खेरङान ना।” ");
INSERT INTO tcn_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","च्हिरु क्याइरे स्यिरे ख्युइ कजसुबे छे धेकिन, हति ता तोनिन राङ ख्युइ धि नानाइबा ना। झोम नाइरे येशुयि पत्रुसला नाइसोङ, “ङाहि च्येला सअ।” ");
INSERT INTO tcn_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","पत्रुसयि क्यापला लक्ते तेतुइना येशुयि करि किङान लोब्टुला च्येला हुन ताताता थोङसोङ। ख्युइ राङ कमुइ ङ्योपि तुइना ख्युइ टाङला ङेरे, “प्रभु, ख्योएला सुङान सुना?” नाइरे टिसोङ। ");
INSERT INTO tcn_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","खोला थोङदे पत्रुसयि येशुला नाइसोङ, “प्रभु, ख्युइते च्हि हुन?” ");
INSERT INTO tcn_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","येशुयि पत्रुसला नाइसोङ, “ङा मालेप थु खो त्येना ङाहि धोप्पा ख्योएला च्हि? ख्योए ङाहि च्येला सअ।” ");
INSERT INTO tcn_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","हतिचाला हति लोब्टु मिस्यिया नाङान भाइबे नाङला टाइक्ये च्युङसोङ। येशुयि खो मिस्यिया नानाइबा माना हिन्नाङ “ङा मालेप थु खो कहुरे सोम्बो त्येना ङाहि धोप्पा ख्योएला च्हि?” नानाइबा हिना। ");
INSERT INTO tcn_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","धि हति लोब्टु राङ ना सुइ धि तामबे भारेला साछि तेरिन, राङ धि तामबा टिदु, तेहि ङेला छ्या होतो कि ख्युइ साछि तेम्बा ना। ");
INSERT INTO tcn_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","येशुयि स्यान लाइ याङ लेइराङ क्याइसोङ। हतिबे नाङने च्यिच्यि क्याइरे ढीङान नाना, ङाला धि च्वरा लागि हुन्दु, कि ख्युइ टिटिबि किताब संसारला राङ मिस्युवा।");
INSERT INTO tcn_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","करि थियोफिलस, येशुयि क्याक्याइबा राङ लोबाला छेछेलि ताम पोरोयि भारेला ङाहि ताङस्युवा किताबला टिटिबा होए। ");
INSERT INTO tcn_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ङारि धाधामि लोब्टुबाला येशुयि पवित्र आत्माने आदेश पिन्छारते च्येला खोला तेङलाला तेतेकि ङिन थु ताम पोरो हति किताबला टिटिबा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","रेँ तुका ङ्योङ छारते अकाट्य साछि लाम्ला हतिबे धुनला ख्युइ राङला सोम्बो ताताना होतो। ङि खलङि थु खो हतिबे तेहा थोङसोङ तेहि कजसुबायि राज्ययि भारेला हतिबाला स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","हतिबा ङ्याबो ङ्योपा स्येतुइना ख्युइ हतिबाला धि च्वरा आदेश पिन्सोङ, “खे यरुश्लेमने काँहाङ माढो, हिन्नाङ आकेयि ना क्याक्यालाला कुँरे त्योए। धि भारेला खि ङाहि लाम्ला थोइ छाछारा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","चिचालानाना युहान्नि ता छ्युयि बप्तिस्मा पिन्सोङ, हिन्नाङ ता ङि रेनरेन च्येला पवित्र आत्माने बप्तिस्मा तेरङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","हतिचाला जब लोब्टुबा झोमदे, हतितुइना हतिबे खोला टिसोङ, “हे प्रभु, च्हि ख्युइ इस्राएल राज्य याङ घोने सोलाइ किच्ये?” ");
INSERT INTO tcn_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ख्युइ हतिबाला नाइसोङ, “आकेयि रेँ आङयि लाम्ला थाकच्योए क्याक्याइबि भेला वा भेला हा:कोयाप खि लाइ मानाइ। ");
INSERT INTO tcn_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","हिन्नाङ पवित्र आत्मा खि तेहा लेप्छारते खेला शक्ति खुङान ना, राङ खे यरुश्लेमला, यहुदिया पोरोला, सामरियाला राङ पृथ्‍वीयि च्येस्युवा धुन थु ङाहि साछि होङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ख्युइ धि तामतेबा नाइ छारते, हतिबे तेनतेन राङ खो याला तेसोङ, राङ मुक्पाला खो हतिबे मिने तोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","जब हतिबे खो लाम्ला झि पान्नाङ यहला ढुन ताताता तेन ताताता होतो, हतितुइना हो:प्तामेला कोहिला कारबो कोकोना मि ङि हतिबे धुनला लाँरे त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","हतिबे नाइसोङ, “गालिलयि मिबा, खे चिला पान्नाङ यहला तेनराङ लाँरे तोकिन? धि राङ येशु, काङते खि चाने तेङलाला तेतेका होतो, थाल्ला च्हिरु क्याइरे खोला तेङलाल ढोङान थोङदे, हति च्वरा क्याइरे याङ खो होङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","तेहि हतिबा जैतुन नाङान रि यरुश्लेमने हा:लाम किलोमिटर क्या झि झोम घ्याबो परि हुन। ");
INSERT INTO tcn_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","भजारयि नाङला स्यु छारते हतिबा राङ त्योएसि थकि कोटाला झिसोङ। हतिबा पत्रुस, युहान्ना, याकुब, अन्‍द्रियास, फिलिप राङ थोमा, बारथोलोमाइ राङ मत्ति, अल्फायसयि पिजा याकुब राङ कट्टरपन्थि तुमयि सिमोन राङ याकुबयि पिजा यहुदा हिना। ");
INSERT INTO tcn_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","पुमो चोम राङ येशुयि आमा मरियम ख्युइ भाइतेबा ङ्याबो हतिबा पोरो सम चिकि च्युङदे मि छ्याता मोनलाम क्याकिन राङ त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","हति ङिनला भाइतेबे उइला पत्रुस लाँसोङ (हति मितेबे टाँगा हा:लाम क्या राङ ङिस्यु धु), राङ नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“भाइबा, पवित्रशास्त्रयि वचन पुरा होङकोइ हुन, काङ वचनते येशुला सुङदु झ्युङान घोबा यहुदायि भारेला दाउदयि खाने ताङलाने राङ पवित्र आत्माने क्ये ताताङा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","चिचालानाना हति टाँगा ङे ङ्याबो राङ च्युच्युङा होतो। राङ हति स्यापच्यिला हतिला भाग खुखुबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","हति मियि तिक्पायि कमाइने सा झि ङ्योइसोङ, राङ थुल्ला झिङबा क्याइरे टुलसोङ राङ हति पुइमु छ्यासोङ, राङ हति नाङयि लुवा छिमबा पोरो थोन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","धि ताम यरुश्लेमयि त्योएङान पोरोला हा:कोसोङ। हति सायि मिन हतिबे रेँ क्येला आखेल्दाला पोरसोङ, अर्थात ठायि स्यिङ। ");
INSERT INTO tcn_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","पत्रुसयि नाइसोङ, “चिचालानाना भजनयि किताबला धि च्वरा टिदु, ‘हति त्योएसा मेता सअ, राङ हतिया त्योएङान सुयाङ मेता सअ, राङ हति लाइयि पद स्यानयि खेखेरा सअ।’” ");
INSERT INTO tcn_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","हतिचाला हु ङ्याबो त्योएङान मितेबे नाङने धि च्वरा झि धामकोइ राङ हुन, काङ मिते प्रभु येशु हुइ धुनला ताते फि नाङ कितितुइना बारतै हु ङ्याबो होतो, ");
INSERT INTO tcn_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","अर्थात हत च्वरा मि काङते युहान्नि बप्तिसमाने खेरते खो हुने थोला खेरि थिन थु हु ङ्याबो होतो। हति मि हु ङ्याबोङ्याबो स्यिरे सोम्बो च्युङदे लाँलाँबि साछि होङकोइ हुन। ");
INSERT INTO tcn_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","हतिबे मिरको ङि, अर्थात बारनाबास नाङान योसेफ, काङति मिन ङोधो, युस्तस हिना, राङ मतियासयि मिन प्रस्ताव क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","हतिबे धि च्वरा मोनलाम क्यापसोङ, “मि पोरोयि समयि ताम हा:कोङान प्रभु, धि ङिबुइ नाङने ख्युइ सुला धाधामा होतो नसो ङेला तोन, ");
INSERT INTO tcn_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","राङ हति धि स्यापच्यि राङ स्यु ङ्युइ, काङ स्यापच्यिने यहुदा घो ख्यामदे रेँ सा अलला स्यिसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","तहि हतिबे हति ङि उइला गोला च्युसोङ, राङ मतियासयि मिनला थोपसोङ, राङ लोब्टु च्युच्यि ङ्याबो हतिला टाँगा चिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","जब पेन्तिकोसयि ङिन लेप्ते, हतिबा पोरो सा झिला झोमदे त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","तेहि तेङलाने हो:प्तामेला मुक्पा छोम्मुवा झिकि क्ये च्वरा झि लेप्सोङ, राङ हतिबा ताताति खिम पोरो राङ खाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","मेयि मेरतो च्वरा हतिबे तेहा थोङसोङ, राङ भागभाग च्युङदे हतिबा पोरोयि थोला त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","तेहि पोरो पवित्र आत्मायि खाँसोङ, राङ पवित्र आत्मायि हतिबाला पिपिना क्ये तोतोना च्वरा हतिबा स्यान क्येला ताम नाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","तेङलायि हअला होएता देश पोरो कजसुबायि भक्ता यहुदि हति भेलाला यरुश्लेमला ताताता धु। ");
INSERT INTO tcn_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","तेहि हतितुइना धि क्ये थोइरे मियि तुम झोमसोङ। हतिबा हा:लाइसोङ, चिचालानाना पोरोयि राँ राँसि क्येला हतिबा ताम नाङान थोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","हतिबा पोरो हा:लाइसोङ, राङ हा:लाइरे नाला छेलसोङ, “च्हि धि ताम नाङानबा पोरो गालिलितेबा मानाइ च्हि? ");
INSERT INTO tcn_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ता च्हिरु क्याइरे हतिबा पोरोयि रेँ क्येला ताम नानाइबा ङि थोयिन धुइ? ");
INSERT INTO tcn_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","हु ङिहा पार्थीतेबा, मादियातेबा, एलामि, मेसोपोटामियायि, यहुदियायि, कापाडोकियाला पोन्टस, एशियाला त्येएङान तेबा। ");
INSERT INTO tcn_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","फ्रिगिया, पामफिलिया, मिश्र र कुरेनीला परि होङान लिबिया छेत्रतेबा राङ रोमने लेलेबि यहुदितेबा राङ यहुदि मत मानि किङान ङिकार होतो। ");
INSERT INTO tcn_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","यहुदि राङ यहुदि मान्ते मि ङिकार यहुदिया च्युङसोङ। क्रेटला त्योएङानतेबा राङ अरबितेबा याङ होतो, तेहि ङे राँ राँसि क्येला कजसुबायि हा:छेयायि लाइयि टाइक्ये हतिबे क्याक्याइबा थोयिन्दु।” ");
INSERT INTO tcn_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","हतिबा पोरो हा:लाइसोङ राङ आच्या माच्याला चिकि स्यान झिला नाइसोङ, “धि खुँ च्हि ना?” ");
INSERT INTO tcn_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","हिन्नाङ स्यानतेबे कुँरे क्याइरे नाइसोङ, “हतिबा सारबा अंगुरयि खुवायि सिदु।” ");
INSERT INTO tcn_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","हिन्नाङ पत्रुसयि च्युच्यि ङ्याबो लाँरे क्ये छेया किङगा हतिबाला नाइसोङ, “यहुदियायि मितेबा, राङ यरुश्लेमला त्योएङान मितेबा पोरो, खेला धि ताम छ्या सअ, राङ ङाहि ताम ङ्योन। ");
INSERT INTO tcn_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","चिचालानाना खि ठानि क्याक्याइबा च्वरा धिबा स्यिस्यिया मेता, चिचालानाना थाल्ला नामेयि नौ बजे मात्र च्युच्युङा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","हिन्नाङ योएल ङोन्सेखिलङान यि लाम्ला नानाइबि ताम धि राङ ना, ");
INSERT INTO tcn_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘सिनि ङिनतेबाला धि च्वरा होङान ना नाइरे कजसुबा ने्न्दु, ङा मि पोरोयि थोला ङाहि आत्मा झ्योज्याइ, राङ खि पिजातेबा, राङ हतिबे पुमोतेबे ङोन्सेखिलङान ना, राङ हतिबे स्यारातेबे दर्शन थोङान ना, राङ हतिबे काप्पोतेबे मुलाम थोङान ना, ");
INSERT INTO tcn_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","हिना, ङा ङारि यक्मुवा यक्पुवातेबे थोला हति ङिनतेबाला ङाहि आत्मा झ्योज्याइ, राङ हतिबे ङोन्सेखिलङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","थोकि पान्नाङला ङा हा:लाइयापयि लाइ राङ हअ पृथ्‍वीला हा:लाइयापयि लाइतेबा तोनङान ना, अर्थात ठा, मे, राङ तुप्पि मुस्लो। ");
INSERT INTO tcn_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","कजसुबायि छेया राङ हा:लाइयापयि ङिन होङयापले ताङला ङिमा मुन्नाला राङ धा: ठाला परिनत होङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","तेहि सुइ कजसुबायि मिन खेरकिन, हतिला थारथोनयाप खुङान ना।’” ");
INSERT INTO tcn_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“इस्राएलि मितेबा, धि तामतेबा ङ्योन, नासरतयि येशु धि च्वरा मिना, काङला कजसुबायि शक्तिशालि लाइतेबा, हा:लाइयापयि लाइतेबा राङ हा:लाइयापयि लाइतेबाने खि धुनला साछि पिपिना होतो। ख्योए छ्या होतो माने कि कजसुबायि खि उइला धि लाइतेबा ख्युइ लाम्ला क्याक्याइबा ना। ");
INSERT INTO tcn_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","कजसुबायि थाकच्योए क्याक्याइबि थारका योजाना राङ ताङमे छोइ च्वरा थेथेबा धि येशुला राङ तिक्पा किङानयि मितेबे लाकि लाम्ला खि क्रुसला तारे स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","खोला कजसुबायि स्यियापयि तुकाने थारथोनदु च्युक्ते सोम्बो सोइसोङ। चिचालानाना कालयि हअला खो होङयाप असम्भव ना। ");
INSERT INTO tcn_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","चिचालानाना दाउदयि ख्युइ भारेला नेन्दु, ‘ङाहि प्रभुला बारतै ङाहि धुनला थोङसोङ, चिचालाना ङा खो माख्याम नाइरे खो ङाहि लाक्पा याइ यहला होतो। ");
INSERT INTO tcn_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","हतिचाला ङाहि सम किप्पो राङ ङाहि च्ये कासोङ। हति अर्थात ङाहि स्हुयि याङ आशाला सोनङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","चिचालानाना ख्युइ ङाहि उला हअलुला तोङान मानाना, न त ख्युइ रेँ पवित्र मियि स्हु रुलदु झ्युङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ख्युइ ङाला मिजेयि लाम स्येसोङ, ख्युइ ङाला रेँ उपस्थितियि लाम्ला आन्नद क्याइरे गदगद सोङान ना।’” ");
INSERT INTO tcn_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“भाइबा, हुइ ताङबुइ दाउदयि भारेला ङा ख्योएला थारका क्याइरे नाङ्युइकिन, कि खो स्यिरे राङ कुँरे, तेहि तिरिङयि ङिन थु ख्युइ तुर होए राङ होतो। ");
INSERT INTO tcn_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","हतिचाला ङोन्सेखिलङान च्युच्युङाति, खोला छ्या होतो कि कजसुबायि ना क्याक्याला होतो कि ख्युइ छिमा पिपिबाने ख्युइ क्याल ठिला मिझिला कजसुबायि भोरङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ताङलाने राङ धि थोङदे ख्रिष्ट स्यिरे सोम्बो च्युङदे लाँलाबि भारेला नानाइबा नोम कि खो न हअलुला ताङोमका कि, न त ख्युइ स्हु राङ रुलदे।” ");
INSERT INTO tcn_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","“हति येशुला राङ कजसुबायि सोम्बो सोइसोङ। धि तामयि ङे पोरो साछि होतो। ");
INSERT INTO tcn_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","हतिचाला कजसुबायि लाक्पा याइ यहला खोला तेक्ते पोरसोङ, राङ आकेने पवित्र आत्मायि ना क्येलयाप खुँसोङ, राङ ख्युइ धि च्योच्युवा ना, काङ ख्योए ङ्यान किन राङ थोइकिन। ");
INSERT INTO tcn_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","चिचालानाना दाउद ता तेङलाला माझिबा, हिन्नाङ खो खुरि नेन्दु, ‘कजसुबायि ङाहि प्रभुला नाइसोङ, ख्योए ङाहि लाक्पा याइ यहला त्योए ");
INSERT INTO tcn_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","जब थु ङा ख्युइ टाला ख्युइ काङबि तिङबा मिसुवा।’” ");
INSERT INTO tcn_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“हतिचाला इस्राएलयि प्येरा पोरो धि पक्का क्याइरे हा:कुवा कि येशु सुला ख्युइ क्रुसला तारे, कजसुबायि खोला प्रभु राङ ख्रिष्ट सोइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","धि ताम थोइरे हतिबे सम अल च्युङसोङ, तेहि पत्रुस राङ स्यान लोब्टुतेबाला हतिबे नाइसोङ, “ए भाइबा, ङे च्हि किच्याइ?” ");
INSERT INTO tcn_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","पत्रुसयि हतिबाला नाइसोङ, “घ्योप्पा कि, राङ खि तिक्पा माप कियापयि चाला येशु ख्रिष्यि मिनला के पोरोयि बप्तिस्मा खेर, राङ खेला पवित्र आत्मायि बप्तिस्मा खुङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","चिचालानाना ना क्याक्याला खि चाला, खि सन्तनयि चाला, घ्याबो घ्याबोला होएता पोरोयि चाला ना, पोरो सुला प्रभु हुइ कजसुबायि क्ये तोङिन।” ");
INSERT INTO tcn_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","स्यान लेइराङ तामतेबे लाम्ला ख्युइ हतिबाला साछि पिन्सोङ, राङ जु नाइरे छोइ पिन्सोङ, “धि अल पालिने खे खिरि खेराङला क्योप।” ");
INSERT INTO tcn_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","तेहि सुगेसुगे ख्युइ ताम ङ्यान्दे हतिबे बप्तिसमा खेरसोङ, राङ हति ङिन हा:लाम तोङ सुम जोम मितेबा ख्होए टाँगाला थपि च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","हतिबा लोब्टुतेबे छोइ, सङ्गति राङ लोटा च्ययाप राङ मोनलामला भक्ति राङ ङ्याबो ढुन तोकिन। ");
INSERT INTO tcn_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","पोरोयि समला झिटा च्युङसोङ, राङ लोब्टुबे लाम्ला लेइराङ हा:लाइयापयि लाइ राङ होन तोरयापयि लाइ च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","हिछे किङानबा पोरो ङ्याबो तोकिनलो, राङ हतिबे क्यु पोरो पिमा धु। ");
INSERT INTO tcn_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","हतिबे रेँ सम्पति राङ क्युतेबा चोँरे सुगा सुगाला चिगाचिगा कोइबा हुन पोरोला हति घोकिन। ");
INSERT INTO tcn_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","हतिबा सम च्हि च्युङदे मोनलाम क्यासि खिमला पोरो ङ्याबो हुन, राङ खिम खिमला लोटा च्यकिनलो, राङ हतिबा केनराङ सम चाङमा क्याइरे ढिक्ते सेनलो। ");
INSERT INTO tcn_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","राङ कजसुबायि छे धेकिनलो, राङ मितेबा पोरने ल नायोङ नाइबा क्याइरे तोकिनलो। मुक्ति खुङानतेबाला प्रभुयि ङिन राङ हतिबे टाँगाला थपि क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","पत्रुस राङ युहान्ना ङिम्मु तिन बजे मोनलाम क्यायापयि भेलाला मोनलाम क्यासि खिमला ढुन त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","मोनलाम क्यासि खिमयि नाङला स्युङानतेबा ङ्याबो क्येने राङ ढुडिया लोङमा लोङान मिझि खुरते ख्युहि राङ बारतैला सुन्दर मिन क्याक्याइबि कोना भोरिनलो। ");
INSERT INTO tcn_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","पत्रुस, राङ युहान्नाला मोनलाम क्यासि खिमयि नाङला स्युङान थोङदे हति लोङमा लाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","युहान्ना ङ्याबो पत्रुसयि खोला लाम्मा झि ताइरे नाइसोङ, “ङे यहला तोइ!” ");
INSERT INTO tcn_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","हतिबाने चिगा खुयापयि सम क्याइरे हति ध्यान पिन्दे हतिबाला ताइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","तेहि पत्रुसयि नाइसोङ, “सेर राङ ङुल ङाला मेता। हिन्नाङ च्हि ङाला होतो, ङा हति ख्योएला तेर च्याइ। नासरतयि येशु ख्रिष्टयि मिनला क्यु!” ");
INSERT INTO tcn_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ख्युइ हति लाक्पा याइबा यहला सुङदे लाँसोङ, राङ हतितुनाराङ राङ हति काङबातेबा सुङदे राङ छिबाला स्यु लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","तेहि होप्तामेला लाँरे हति लाँसोङ राङ ढुवाला छेलसोङ, राङ ढुन राङ फारकिन राङ कजसुबायि छे धेकिन राङ हतिबा ङ्याबो मोनलाम क्यासि खिमला स्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","तेहि मि पोरोयि हतिबाला ढुन ताताता राङ कजसुबायि छे तेतेका थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","हतिबे खोला मोनलाम क्यासि खिमयि सुन्दर खोला लोङमा लोङदु त्योएङान धि राङ ना नाइरे ङोस्येसोङ, राङ हति थोला च्युच्युङायि तामला हतिबा हा:लाइसोङ राङ होन:तोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","हति मि पत्रुस राङ युहान्नायि च्येच्येला लेलेबा थोङदे मि पोरो लेइराङ हा:लाइरे सोलोमन मिन क्याक्याबि क्यला हतिबे तेहा स्युरते पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","धि थोङदे पत्रुसयि मितेबाला नाइसोङ, “इस्राएलि मिबा, धि तामला खे चिला हा:लाइकिन? अथवा हुरि शक्ति वा भक्तियि लाम्ला हुइ हतिला ढोयाप राङ सोसोइबा च्वरा चिला स्येता च्युक्ते ङेला तेन?” ");
INSERT INTO tcn_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","अब्राहाम, इसाहाक राङ याकुबयि कजसुबा, हुइ ताङबुइ मितेबे कजसुबा रेँ स्यापच्यि येशुला छे तेसोङ, सुला ख्युइ सुङदु च्युसोङ, राङ पिलातसयि खोला तोङ च्युइ कितितुइना याङ ख्युइ खोला ख्युइ धुनला राङ मिके नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","हिन्नाङ खि पवित्र राङ केवाकिङानयि मिला माना नाइरे मिप स्योए झिला तोङयापयि माग क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","राङ मिजे सोङान मिला ख्युइ स्येसोङ, सुला कजसुबे स्यिस्यियाने सोम्बो सोइरे लाँसोङ, ङे धि साछि होतो। ");
INSERT INTO tcn_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ख्युइ मिनयि थोला क्याक्याइबि हिछेयि राङ ख्युइ मिनयि राङ ख्युइ थोथोङायि राङ ङोस्येस्येबायि धि मिला क्योङबो सोइसोङ। येशुने खुँखुँबि हिछेयि धि मिला खे पोरोयि धुनला टाक्तु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ता भाइबा, ङाला छ्या होतो, कि ख्युइ हा:माकुवाला धि च्वरा क्याइसोङ, राङ खि आङकिङानतेबे याङ धि च्वरा राङ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ख्युइ ख्रिष्टयि तुका ङ्योङ कोइ हुन नाङान कजसुबायि ङोन्सेखिलङान पोरोयि खाने नानाइबि ङोन्सेखिखिला ख्युइ धि च्वरा क्याइरे पुरा क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","हतिचाला घ्योप्पा कि राङ लक्ते सअ, कि खि तिक्पा झतु छ्यु, राङ कजसुबायि उपस्थितिने किप्पोयि भेला लेबोङ, ");
INSERT INTO tcn_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","राङ ख्युइ खि चाला ताङलाने राङ धाधामि ख्रिष्ट, अर्थात येशुला चोङिन। ");
INSERT INTO tcn_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","कजसुबायि ताङबुइ भेलाने राङ रेँ पवित्र ङोन्सेखिलङानयि खाने नानाइबि क्यु पोरोयि याङ सोलाइ कियापयि भेला मालेप थु ख्रिष्ट तेङलाला त्योए कोइ राङ हुन। ");
INSERT INTO tcn_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","मोशायि नानाइबा धु, ‘परमप्रभु कजसुबायि ङाला लाँलँङा च्वरा खि आज्यो भाइयि उइला ङोन्सेखिलङान झि खि चाला लाँङान ना। ख्युइ खेला चिगाचिगा क्याइ हतिबा ताम पोरो खि ङ्यानकोइ हुन।’” ");
INSERT INTO tcn_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","धि च्वरा होङान ना, कि हति ङोन्सेखिलङानला मिङ्यान ङान उ होएता मितेबे उइने मासि होङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“शमुएने खेरते हति च्येयि ङोन्सेखिलङान चोमयि नानाइबा होतो, हतिबा पोरोयि धि ङिनयि थाकच्योए क्याक्याइ होतो। ");
INSERT INTO tcn_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","खे हति ङोन्सेखिलङानतेबा राङ हति ना क्याक्यालि सन्तन ना, काङ वाचा क्याक्याला कजसुबायि खि ताङबुइ अब्राहाम ङ्याबो जु नाइरे तामसोङ, ‘खि सन्तनला पृथ्‍वीयि पोरो प्येराला च्यिनलाब खुङान ना।’ ");
INSERT INTO tcn_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","खे पोरोला रेँ अलने लक्तु च्युक्ते खेला च्यिनलाब तेरतु नाइरे कजसुबायि रेँ स्यापच्यिला लाँसोङ राङ ताङस्युवाला खि तेहा चाँसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","पत्रुस राङ युहान्ना मितेबा ङ्याबो ताम नेन राङ धु, पुजारितेबा, मोनलाम क्यासि खिमयि घोबा राङ सदुकितेबा ख्युइ तेहा लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","हतिबा स्येताङ लाँलाँबा धु, चिचालानाना येशुला स्यिरे सोम्बो च्युङदे लाँकिन नाङानयि ताम हतिबे मितेबाला लोबिन राङ धु राङ घोषाण किन राङ धु। ");
INSERT INTO tcn_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","तेहि हतिबे खोङला सुङसोङ, राङ ङाइटो थु झ्याल्ला पोरसोङ, चिचालानाना हति भेला कमु च्युङ छारतु। ");
INSERT INTO tcn_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","हिन्नाङ वचन ङ्यानङानतेबे नाङने लेइराङयि हिछे क्याइसोङ, राङ हिछे किङानयि टाँगा हा:लाम तोङ ङा च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ङाइटोतेला हतिबे आङकिङान, केवा किङान गुरुतेबा राङ शास्त्रितेबा यरुश्लेमला झोमसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","घोबा पुजारि हन्‍नास, कैयाफा, युहान्ना, अलेक्जेन्डर राङ घोबा पुजारि प्येरायि पोरो हतिया धु। ");
INSERT INTO tcn_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","हतिबे पत्रुस राङ युहान्नाला उइला लाँङदे टिसोङ, “काङ शक्तिने अथवा सुइ मिनला क्युइ धि क्याक्याइबा ना?” ");
INSERT INTO tcn_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","तेहि पवित्र आत्मायि खाँरे पत्रुसयि हतिबाला नाइसोङ, “मितेबे आङकिङान राङ केवा किङान गुरुतेबा, ");
INSERT INTO tcn_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","तिरिङ ङि मि ढुडिया झिकि थोला लाइ ल झि क्याक्याइबि भारेला हति काङ च्युइयि टाक्तु च्युक्ते नाइरे टिना, ");
INSERT INTO tcn_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","खे पोरोला राङ इस्राएलयि मि पोरोला छ्या सअ, कि खि क्रुसला ताताबि राङ कजसुबायि स्यिस्यियाने सोम्बो सोसोइबि, खो राङ नासरतयि येशु ख्रिष्टयि मिनला धि मि खि धुनला टाक्ते लाँलाँबा धु। ");
INSERT INTO tcn_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","‘हति टोउ राङ ना, काङ टोउते, सोङानतेबे मिके नानाइबा होतो, सो थाल्ला कुना यि घोबोयि टोउ च्युच्युङा होतो।’ ");
INSERT INTO tcn_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","स्यान च्यालाङ मुक्ति मेता, चिचालानाना मुक्ति खुयापला तेङलायि हअला मितेबाला स्यान च्याङ मिन पिपिना मेता।” ");
INSERT INTO tcn_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","जब हतिबे पत्रुस राङ युहान्नायि हा:म थोङदे, राङ हतिबा छोइ मालाबि मि ना राङ शाधाराण मि ना नाइरे हा:कोसोङ, तेहि हतिबा हा:लाइसोङ, राङ हतिबा येशु ङ्याबो तोकिन नाङान हतिबे हा:कोसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","हिन्नाङ टाटाकि मिला हतिबा ङ्याबो लाँलाँबा थोङदे हतिबे च्याङ ताम ना माङ्युइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","हतिचाला हतिबाला यहुदिबे नेतातेबा झोझोमि तुमने फिला ढोयापयि आदेश पिन्छारते हति जु नेन राङ खोरे नाङला टोइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“धि मिबाला ता हु च्हि किच्याइ? चिचालानाना तेम्बारे राङ धिबाने हा:लाइयापयि लाइ झि च्युङदु नाङान यरुश्लेमला त्योएङानयि मि पोरोला थोङ छारतु, राङ ङि धि मिके ना मिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","हिन्नाङ धि ताम जनताला टाइक्ये मा योङ नाइरे ‘याङ धि मिनला मि रेन ङ्याबो खे च्याङ माना’ नाइरे हुइ धिबाला चेतावानि तेर कोयिन।” ");
INSERT INTO tcn_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","तेहि हतिबाला क्ये ताङदे “ता याङ येशुयि मिनला ताम माना राङ छोइ च्याङ मातेर” नाइरे हतिबे आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","हिन्नाङ पत्रुस राङ युहान्नि हतिबाला जवाक पिन्सोङ, “कजसुबायि ताम ङ्यानयापले ख्युइ ताम ङ्यानयाप कजसुबायि मिला ल हिना कि माना खेराङ विचार कि।” ");
INSERT INTO tcn_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","“चिचालानाना ङि थोथोङा राङ थोथोइबा तामतेबा मानाइबि ङ्युइ राङ मिङ्युइबा।” ");
INSERT INTO tcn_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","हतिबे ङेबा तेरयापयि च्युइ राङ माखुबा राङ हतिबाला तरह लेइराङ थरकाइ चेरे ताङसोङ, चिचालानाना काङ घटना घटि च्युच्युङा होए हति चाला मि पोरोयि कजसुबे छे धेकिन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","चिचालानाना काङ मि हा:लाइयापयि लाइने टाटाका होतो, हति लो खलङिले मा हिना। ");
INSERT INTO tcn_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","थारथोनयाप खुरे हतिबे रेँ रुवायि तेहा लेप्सोङ, राङ घोबा पुजारितेबा राङ केवा किङान गुरुतेबे नानाइबि ताम पोरो हतिबाला स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","जब हतिबे धि थोइरे, हतितुइना हतिबे लाम्मा झिला कजसुबा ङ्याबो रेँ क्ये तेक्ते नाइसोङ, “हे प्रभु, सुइ तेङला, पृथ्‍वी, छो छोम्मुवा राङ हतिला होएता क्यु पोरो सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","सुइ पवित्र आत्मायि लाम्ला रेँ स्यापच्यि हुइ ताङबुइ दाउदयि खाने नाइसोङ, ‘यहुदि मान्ते मितेबा चिला स्येताङ लाँदुइ, राङ मितेबे फान मेते तामतेबा चिला टान्दे? ");
INSERT INTO tcn_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","परमप्रभुयि विरोधला ख्युइ अभिशेक क्याक्याइबा मियि विरोधला पृथ्‍वीयि क्यालबो लाँसोङ, राङ आङकिङानतेबा ङ्याबो झोमसोङ।’ ");
INSERT INTO tcn_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","चिचालानाना तेम्बारे ख्युइ अभिशेक क्याक्याइबा, ख्युइ पवित्र स्यापच्यि येशुयि विरोधला हेरोद राङ पन्तियस पिलातस ङिकार, यहुदि मान्ते मि राङ इस्राएलतेबा ङ्याबो धि भजारला राङ झोझोमा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","हति कियापला राङ ख्युइ लाक्पाने राङ ख्युइ योजाना च्वरा ताङलाने राङ नाइ छाछारा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ताता हे प्रभु, हतिबे थरकाइ चेचेबि थोला मि तोइ, राङ ख्युइ यक्पुवातेबाला पुरा हा:म राङ ङ्याबो ख्युइ वचन नारु छ्यु। ");
INSERT INTO tcn_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","राङ टाक्तु झ्युयापला ख्युइ रेँ लाक्पा ख्योङि तुइना, रेँ पवित्र स्यापच्यि येशुयि मिनयि लाम्ला हा:लाइयापयि लाइ राङ हो:न तोरयापयि लाइ होङवार सअ।” ");
INSERT INTO tcn_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","हतिबे मोनलाम क्याप छारते च्येला हतिबा झोझोमि साला धारसोङ, राङ हतिबा पोरो पवित्र आत्मायि खाँसोङ, राङ हतिबे हा:म राङ ङ्याबो कजसुबायि वचन नाइसोङ ");
INSERT INTO tcn_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","हिछे किङानतेबे तुम पोरो सम च्हि राङ आत्मा च्हि च्युच्युङा धु, राङ हतिबे नाङने चिकि याङ रेँ क्यु समप्ति च्याङ क्यु धि ङाहि ना नाइरे मिना, हिन्नाङ हतिबे क्यु पोरो पिमा ना। ");
INSERT INTO tcn_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","हति लोब्टुतेबे शक्ति छेया राङ ङ्याबो प्रभु येशु याङ स्यिरे सोम्बो च्युङदे लाँयापयि भारेला साछि तेरिन्दु, राङ हतिबा पोरोयि थोला ङिङच्ये छेया ताताता धु। ");
INSERT INTO tcn_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","हतिबे नाङने रेनला च्याङ क्युयि कोइबा मिहा, चिचालानाना चोम सा स्यिङ कि खिमयि ताक्पो हिना, हतिबे हति चँहरे हति घोङ क्याकिन्दु, ");
INSERT INTO tcn_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","राङ लोब्टुतेबे काङबाला भोरिन्दु, राङ सुगा सुगाला काङकाङ तामयि कोइबा हुन, सो पोरोला घोकिन। ");
INSERT INTO tcn_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ता साइप्रस देशयि लेवि क्युइयि योसेफ, सुला लोब्टुतेबे बारनाबास नाइरे मिन पोपोरा होतो (हति समस्युयि च्यिटा ना)। ");
INSERT INTO tcn_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ख्युइ रेँ सा राङ हति आलाइ ख्योरे लोब्टुबे काङबाला पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","हिन्नाङ हननिया मिन क्याक्याबि मि झि राङ हति केरमान सफिरायि सायि तुभु झि चाँरेलो। ");
INSERT INTO tcn_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","राङ हति घोङने हति केरमानला छ्या होतोला राङ भाग रेन रेँ तेहा पोरते राङ, भाग रेन खेरते लोब्टुबे काङबाला पोरते। ");
INSERT INTO tcn_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","हिन्नाङ पत्रुस यि नाइसोङ ए हननिया, पवित्र आत्मा ङ्याबो चुन नाङान राङ सा चँचँबि घोङयि आलाइने भाग रेन राङ ङ्याबो भोरयापयि ताम तुइयि च्हिरु क्याइरे ख्युइ समला काङसुइ? ");
INSERT INTO tcn_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","हति माचँ थु च्हि ख्युरि मेताइ? राङ हत चाँह छारते याङ हति ख्युइ आङला मेताइ च्हि? “धि च्वरा लाइ कियापयि च्युइ च्हिरु क्याइरे ख्युइ समला लेप्सुइ? ख्युइ मिला ता माना, हिन्नाङ कजसुबाला चुन नानाइबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","धि थोइरे हननिया साला घेलसोङ राङ हति उ च्येसोङ। धि थोइसोङन पोरो लेइराङ झिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","तेहि स्यारातेबा लाँरे खोला कोहिलायि किसोङ राङ फिला खुरते खेरसोङ, राङ कुँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","काङ च्युङ छारते हति हा:माकुवा हा:लाम घण्टा सुम झोम च्येला ख्युइ केरमान याङ नाङला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","पत्रुसयि हतिला टिसोङ, “ङाला नोइ, खि सा होचोमला राङ चोँचोँबि हिनाइ?” तेहि मुइ नाइसोङ, “ज्यु होचोमला राङ।” ");
INSERT INTO tcn_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","हिन्नाङ पत्रुसयि हतिला नाइसोङ, “खि प्रभुयि आत्माला छोएतायाप च्हिरु क्याइरे टोइ क्याइरे? तपि, ख्युइ ख्योबोला कुङानतेबा कोला राङ धु राङ हतिबे ख्योएला खुरते फिला खेरङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","तेहि हतितुइना राङ हति ख्युइ काङबाना घेलसोङ राङ उ च्येसोङ। जब स्यारातेबा नाङला लेप्सोङ, हति स्यिस्यिया थोङदे फिला खुरते खेरसोङ, राङ हति ख्योबोयि धुनला कुँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","चर्च पोरोयि थोला राङ धि ताम थोइङानतेबा पोरो लेइराङ झिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","तेहि लोब्टुबे लाने लेइराङ हा:लाइतु झ्युयापयि लाइ राङ हो:नतोरतु झ्युयापयि लाइ मितेबे उइला हुवाला छेलसोङ, राङ हतिबा पोरो सोलोमनयि क्यला लाम्ला झिला ङ्याबो झोम्दे त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","हिन्नाङ स्यानतेबे नाङने सुइ याङ हतिबा ङ्याबो ढिक्तु होङयापयि आट माच्युङसोङ, हचु हिन्नाङ मितेबा हतिबाला सम्मान किनलो। ");
INSERT INTO tcn_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","प्रभुला हिछे किङान पि:जा राङ पुमो ङिकारयि तुम तरह माहा फेलाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","धि थु कि मितेबे लाम लामला नाप्पातेबाला ख्योसोङ, राङ पत्रुस हुइतुइना ख्युइ टिप्सो मात्र च्युङ नाङ हतिबे नाङने रेन रेनयि थोला परि होङ नाइरे मालसा राङ खाटातेबाला हतिबा ङ्यालदे राङ तोकिनलो। ");
INSERT INTO tcn_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","यरुश्लेमयि फाला छुलुइ भजारतेबाने याङ लेइराङ मितेबे नाप्पातेबा राङ भाभा आत्मायि तुरि पिपिनातेबाला ख्योरे हुन राङ हतिबा पोरो टाकिनलो। ");
INSERT INTO tcn_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","घोबा पुजारि राङ हतिबा ङ्याबो होङान (काङते सदुकि तुमयि हिना) ठाधोयि खाँरे लोब्टुबे विरोधला लाँसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","राङ हतिबाला लोब्टु पोरोला सुङदे ङिहाला होएता झ्याल्ला च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","हिन्नाङ प्रभुयि तेङलायि लोन खेरङान झिकि छाम्मु झ्यालयि कोतेबा पेसोङ, राङ हतिबाला फिला ख्योरे नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“क्यु राङ मोनलाम क्यासि खिमला लाँरे धि मिजेयि लोन पोरो मितेबाला स्योए।” ");
INSERT INTO tcn_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","धि थोइरे हतिबा नामे राङ मोनलाम क्यासि खिमयि नाङला स्युसोङ राङ छोइ तेराला छेलसोङ। हिन्नाङ घोबा पुजारि राङ हतिबा ङ्याबो होएतातेबा लेप्सोङ, राङ नेतातेबे तुम छोम्मुवा, अर्थात इस्राएलतेबे नेतातेबे तुम पोरोला क्ये ताङसोङ, राङ लोब्टुबाला झ्यालने ख्योङदु मितेबाला चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","हिन्नाङ आङकिङानतेबे हतिबाला झ्याल्ला माठाता राङ लक्ते धि लोन पिन्सोङ, ");
INSERT INTO tcn_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ङि झ्याल्ला ल क्याइरे कोलच्या क्याक्याइबा राङ कोराबातेबा कोतेबाला लाँलाँबा राङ ठेसोङ, हिन्नाङ को भियेतुइना ङि नाङला सुलाङ माठेसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","जब मोनलाम क्यासि खिमयि घोबा राङ घोबा पुजारितेबे धि लोन थोइरे हतितुइना नतिजा च्हि होङयाप नोम नाइरे हतिबा लोब्टुतेबे भारेला आच्या माच्या च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","हिन्नाङ मिझि लेप्ते हतिबाला नाइसोङ, “तोइ, खि काङ मितेबाला झ्याल्ला पोरते हतिबा मोनलाम क्यासि खिमला लाँरे मितेबाला छोइ लोबिन्दु।” ");
INSERT INTO tcn_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","तेहि अफिसरतेबा ङ्याबो घोबा पुते हतिबाला ढिप्पि मिकित ख्योसोङ, चिचालानाना मितेबे हतिबाला टोउयि क्याकिन नाइरे हतिबा झिदु। ");
INSERT INTO tcn_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","हतिबे खोङला ख्योरे यहुदिबे तेतातेबा झोझोमा साला लाँसोङ, राङ घोबा पुजारितेबे हतिबाला टिसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ङि खेला धि मिनला छोइ च्याङ मितेरयापयि कडा आदेश पिपिना होतो, हिन्नाङ खि रेँ छोइयि यरुश्लेम काङ खाँतु च्युसोङ, राङ हति मियि ठायि दोष ङि घोला झ्युसोम ठाकिन धुये।” ");
INSERT INTO tcn_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","हिन्नाङ पत्रुस राङ स्यान लोब्टुतेबे नाइसोङ, “ङि मितेबे माना हिन्नाङ कजसुबायि आदेश ङ्यान कोइ राङ हुन। ");
INSERT INTO tcn_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ङि ताङबुइ कानाबे कजसुबे येशुला स्यिस्यियाने सोम्बो सोइसोङ, सुला खि पालेपला तारे स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","कजसुबे इस्राएलयि घ्योप्पि चाला राङ हतिबे तिक्पि माप तेरतु खोला क्यालबो राङ मुक्तिदाता सोइरे ख्युरि याइला त्योएसा याला तेतेका होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","“धि ताम पोरोयि साछि ङे होतो, राङ हति च्वरा क्याइरे राङ पवित्र आत्मा याङ, सुला कजसुबायि आदेश ङ्यानङानतेबाला पिपिना होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","हिन्नाङ जब हतिबे धि थोइरे हतितुइना हतिबा लेइराङ स्येताङ लासोङ, राङ हतिबाला स्योए च्युइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","हिन्नाङ ठिमयि पण्डित राङ माननिय गमलिएल मिन क्याक्याइबि फरिसि नेतातेबा झोझोमि तुमना लाँरे हतिबाला टिझि थु फिला ढोयापयि आदेश पिन्सोङ, ");
INSERT INTO tcn_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","राङ ख्युइ नेतातेबा झोझोमि तुमतेबे खिमयि मितेबाला नाइसोङ, “इस्राएलि तेबा, धि मिबाला खि च्हि कि च्युइ क्याइरे आट क्याक्याइबा होए, हतिला च्याङबो क्याइरे त्योए। ");
INSERT INTO tcn_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","चिचालानाना तिरिङले ताङला याङ थुदासयि च्हि हिना नाङानयि दाबि क्याइसोङ राङ हा:लाम मिरको स्यिपक्या ख्युइ च्येला पुइसोङ। हति स्येसोङ, राङ हति च्येला ढोङानतेबा पोरो खा थोरसोङ राङ पोरो फान मेता च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","तेम्बारे मियि च्येला मि ङोति भेलाला गालिलयि यहुदा नाङान लाँसोङ, राङ मि चोमला रेँ यहला टुइसोङ। हति याङ मासि च्युङदे पुइसोङ, राङ हतिला मानि किङान फाला छुला खा थोरते पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","थल्लि धि मामलाला ङा खेला नाज्याइ, कि धि मिबाने कुरुला त्योए, राङ धिबाला तोङ, चिचालानाना धिबे धि योजाना आथवा धि लाइ मितेबाने हिन्ना हति खोराङ स्यिक्ते ढोङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","हिन्नाङ तेम्बारे धि कजसुबाने हिन्ना ता ख्युइ धिला घा मिङ्युइबा। स्यान अर्थात खे कजसुबायि विरोधला लाँलाँबा होङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","तेहि हतिबे ख्युइ टोइ ङ्यानसोङ। तेहि हतिबे लोब्टुतेबाला नाङला क्ये ताङदे क्यापसोङ, राङ “येशुयि मिनला ता माना” नाइरे आदेश पिन्दे हतिबाला ताङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","तेहि येशुयि मिनला अपमान सहि किङान च्युङसोङ नाङानयि तामला आन्नद मानि किनराङ हतिबा नेतातेबा झोझोतेने थोन्दे पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","तेहि बारतैला मोनलाम क्यासि खिमला राङ खिम खिमला पुते येशु राङ ख्रिष्ट हिना नाइरे लोपयाप राङ टाइक्ये कियाप मा ताङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","हति ङिनला जब लोब्टुबे टाँगा फेलिन राङ पुइसोङ, तेहि हिब्रुतेबे विरोधला ग्रिक यहुदिबे नाला छेलसोङ, चिचालानाना बारतैयि ङ्योपा घोतितुइना हतिबे राढियातेबाला कोइबा होएता ङ्योपा मिखुबा। ");
INSERT INTO tcn_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","तेहि च्युनङि गारयि लोब्टुतेबे तुमला क्ये ताङदे नाइसोङ, “कजसुबे वचन टाइक्ये किच्याइ ताङदे सायाप राङ थुङयापयि स्यापच्यि स्युङान हुला ल मिहा। ");
INSERT INTO tcn_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","हतिचाला भाइबा, खे फ्येने पवित्र आत्मा राङ रिक्पि खाँखाँबा राङ सम्मान पोरो खुखुबा मि तुन होतो सुला ङे धुला लाइला धाम ज्याइ। ");
INSERT INTO tcn_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","हिन्नाङ हु मोनलाम राङ वचनयि स्यापच्यिला समय पोरो तेरच्याइ ना।” ");
INSERT INTO tcn_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","धि ताम तुमयि पोरोला सम ठेसोङ राङ झोझोमा पोरोला ल स्येसोङ, राङ हतिबे पवित्र आत्मा राङ हिछेयि खाँखाँबा स्तिफनस, फिलिप, प्रखरस, निकनोर, तीमोन, पर्मिनास राङ एन्टिओखियायि यहुदि मत मानि किङान निकोलाउसला धामसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","हतिबे हति मिला लोब्टुबे धुनला ख्योसोङ राङ लोब्टुबे मोनलाम क्यापसोङ राङ हतिबे थोला रेँ लाक्पा पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","कजसुबे वचन फाकिन् राङ पुइसोङ, राङ लोब्टुबे टाँगा यरुश्लेमला लेइराङ फेलसोङ। पुजारितेबे नाङने लेइराङयि धि हिछेला ङ्यानसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","स्तिफनसला ङिङच्ये राङ शक्तियि खाँरे मितेबे उइला हा:लाइयापयि लाइ छेयाछेया राङ शक्तियि लाइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","हिन्नाङ रेन रेनते सुते स्वतन्त्र तुमयि यहुदि झोमसि खिमतेबा (धि मिन हति राङ ना), राङ कुरेनि, अलेक्जेन्ड्रिया, किलिकिया राङ एशियायि मितेबा हिना, हतिबा लाँरे स्तिफनस ङ्याबो नारे किताला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","हति काङ रिक्पा राङ आत्मायि लाम्ला नेन, हतिबे ख्युइ सामाना कि माङ्युइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","तेहि हतिबे फा:ला मितेबाला हुर:स्युइ लाङदे जु नारु च्युसोङ, “मोशा राङ कजसुबायि विरोधला धि फा:ला ताम अल नानाइबा ङि थोइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","तेहि हतिबे जनता, केवा किङान गुरु राङ शास्त्रिबाला घो ख्यामदु च्युसोङ, राङ हतिबाला छेलसोङ राङ सुङदे यहुदि नेता झोमसि खिमला ख्योसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","हतिबे जु नायाप चुन साछितेबाला ताङला सारि क्याइसोङ, “धि मियि पवित्र सा राङ ठिमयि विरोधला ताम नायाप मितोङा। ");
INSERT INTO tcn_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","चिचालानाना धि जु नानाइबा ङि थोइसोङ, ‘नासरतयि येशुयि धि साला मासि लोङान ना, राङ मोशायि ङेला पिपिना धार्मिक लुलाम याङ च्येङान ना।’” ");
INSERT INTO tcn_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","यहुदि नेतातेबा झोमसि हतिबा पोरोला ल क्याइरे ताइसोङ, राङ हतिबे धुनयि भाग तेङलायि लोन खेरङानयि धुनयि भाग च्वरा थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","तेहि घोबा पुजारियि टिसोङ, “च्हि धि ताम थारका हिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ख्युइ नाइसोङ, “आज्यो भाइ राङ तेबा, ङ्योन। छे धेयापयि कजसुबे ङि आके अब्राहामला हति हरानला त्योएयापले ताङला मेसोपोटामियाला होतितुइना दर्शन पिन्सोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“राङ खोला नाइसोङ, ‘ख्योए रेँ देश राङ रेँ रुइबाने थोन्दे, काङ देश ङा खेला तोनज्याइ, हतिया क्यु।’ ");
INSERT INTO tcn_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","तेहि हतिबा कल्दियि देशने थोन्दे हरानला लेप्ते त्येसोङ, राङ हति आके स्यि छारते च्येला कजसुबे हतिला हति साने धि साला सारि क्याइसोङ, काँहा थाल्ला खे तोकिन।” ");
INSERT INTO tcn_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","खोला धि साला होएता पोरो समप्ति पोरो क्यु, कोबा भोरसि सा याङ मापिन्सोङ। हिन्नाङ हतिला छिमा मापिना याङ हति होएते समप्ति पोरो कजसुबायि हति सन्तन पुजाबला पोपोरि सन्तन रेँ निजि सम्पत्तियि धोला तेरयापयि ना क्यालसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","कजसुबायि धि च्वरा क्याइरे नाइसोङ, ख्युइ सन्तन स्यानयि मुलुला पुते त्योएङान ना, राङ हतिबे खेला यक्पुवा सोइरे लो स्यिप क्या दबाबला भोरङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","कजसुबायि नाइसोङ, “हिन्नाङ हतिबा ‘काङ मितेबायि यक्पुवा च्युङदे त्योएङान ना हति मितेबे ल अल ङा भे ज्याइ। तेहि हति च्येला हतिबा थोन्दे लेप्ते हति साला राङ ङाहि आराधाना किङान ना।’” ");
INSERT INTO tcn_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“ख्युइ हति ङ्याबो पिजायि फा:ला होएते पाबु तुपयापयि वाचा क्याइसोङ, राङ अब्राहाम इसहाकयि आके च्युङदे ङिन क्येकि तुइना इसाहाकयि पिजायि फा:ला होएते पाबु तुपसोङ। इसहाक याकुबयि आके हिना, राङ याकुब कुल च्युनङियि आके च्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","योसेफयि पिजा येशुला ठाधो क्याइरे हतिला मिश्रदेशला चाँसोङ। हिन्नाङ कजसुबा हतिबा ङ्याबो धु। ");
INSERT INTO tcn_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","कजसुबे हतिबे तुका पोरोने थारतोन्दे मिश्रदेशयि क्यालबोला फारोयि धुनला हतिला ङिङच्येसोङ राङ रिक्पा पिन्सोङ, राङ फारोयि मिश्रदेश राङ ख्युइ खिम पोरोयि हाकिम सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“हति च्येला मिश्रदेश राङ कनानला अनिकाल परि च्युङदे लेइराङ तुरि च्युङसोङ, राङ ङि ताङबुइ मिला साइ माखुसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","हिन्नाङ याकुबयि मिश्रदेशला साइ धु नाङान ताम थोइरे ङि ताङबुइ मिबाला लाम्मा ताङस्युवा हतिया चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","लाम्मा ङिबायि ठेयापतेला हति आज्यो भाइला रेँ ङोस्ये पिन्सोङ, राङ योसेफयि प्येरा याङ फारोयि तेहा पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","योसेफयि रेँ आके याकुब राङ रेँ मितेबा पोरोला, काङते खलसुम राङ च्याइङा तुढो होतो, हतिबे तेहा लोन कुरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","याकुब मिश्रदेशला पुइसोङ, राङ हतिया राङ खो स्यिसोङ, राङ ङि ताङबुइ मितेबा याङ हतिया राङ स्यिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","हति च्येला हतिबे स्यिस्यियायि रो शकेमला खेरसोङ, राङ अब्राहामयि शकेमला हमारयि पिजातेबाने आलाइ पिन्दे ङ्योङ्योइबि तुरसाला पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“हिन्नाङ जब कजसुबायि अब्राहामला ना क्याक्यालि भेला पुरा होङयापयि भेला धुनला लेप्सोङ हतितुइना मिश्रदेशला हति मितेबा फेलाला छेलसोङ, राङ हतिबे टाँगा लेइराङ च्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","तेहि मिश्रदेशला योसेफला ङोमिस्येङान स्यान क्यालबो झि लाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ख्युइ ङि मितेबा ङ्याबो बानि अल क्याइसोङ, तेहि ङि ताङबुइ मितेबाला हतिबे च्यिबा फिला भोरयापला कर क्याइसोङ राङ, हतिच्वरा क्याइरे, थाल्लाका क्येक्येबि च्यिबा पोरो स्यिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“हति भेलाला राङ मोशा क्येसोङ। खो कजसुबायि मिला ल धु। खो धा: सुम थु ख्युइ आकि खुरि खिमला सोइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","खो फिला टिम छारते फारोयि पोमुइ खोला तेक्ते खेरसोङ, राङ रेँ पिजा च्वरा क्याइरे सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","मोशाला मिश्रीतेबे पोरो छोइला योदान लाप्सोङ, राङ मोशा रेँ वचन राङ लाइला शक्तिशालि च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“जब तहि लो खलङियि च्युङसोङ, हतितुइना रेँ इस्राएलि आज्यो भाइबाला ठेयापयि धोप्पा ख्युइ समला लेप्सोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","रेँ क्युइयि भाइयि नाङने चिकि थोला अन्य च्युच्युङा थोङदे, ख्युइ हतिला क्योपसोङ, राङ हति अन्य किङान मिश्रीतेला साते रेँ भाइयि थोला च्युच्युङि अत्याचारयि बदला खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","कजसुबायि ङाहि लाने हतिबाला मुक्ति हुन नाङान ङाहि भाइबे हा:कोहोङ नाङान ख्युइ विचार क्याइदु। हिन्नाङ हतिबे धि हा:माकोसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","“ङाइटोतेला हतिबा राङ खोरे नाङला क्याइरे चिन ताताताला खो लेप्सोङ, राङ हतिबाला ढिक्तु झ्युयापयि कोशिश क्याइरे नाइसोङ, ‘मितेबा, खेता आज्यो भाइ ना, तेहि खे चिला चिकि चिला अन्य किन?’” ");
INSERT INTO tcn_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“हिन्नाङ रेँ खिमजेयि थोला अन्य किङानयि खोला जु नाइरे फुलसोङ ‘ङि थोला आङकिङान राङ ल अल भेङान कियापला खेला सुइ धामसुइ?’” ");
INSERT INTO tcn_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","धाङ हति मिश्रीला स्यिस्यिया च्वरा ख्योए ङाल चिला सोएसोम किन? ");
INSERT INTO tcn_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","धि च्वरा जवाक थोइरे मोशा टोइरे मिद्यान देशला पुते प्रवासी च्युङदेलो। हतिया हतिबे च्यिटा ङि क्येरेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“लो खलङि पुइ छारते च्येला सिनै लायि च्याङ मेते साला छेरिमि भोटि छेकिन ताताता मेरतोयि ज्यावाला तेङलायि लोन खेरङान झि हतिबे तेहा थोङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","“तेहि मोशायि धि थोङसोङ तेहि धि दर्शनयि हा:लाइसोङ, राङ हति तायापला धुनला ढुइतुइना कजसुबायि धि च्वरा ताम नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘ङा खि ताङबुइ मितेबे कजसुबा ना अब्राहाम, इसाहाक राङ याकुबयि कजसुबा।’ मोशा धाराला छेलसोङ, राङ ख्युइ हत यहला तायापयि आट याङ माक्याइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“तेहि कजसुबायि हतिला नाइसोङ, ‘ख्युइ काङबि पोउलो फुइ, चिचालानाना काङ साला ख्योए लाँलाँबा होतो, हति पवित्र सा ना।’” ");
INSERT INTO tcn_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","मिश्रला होएता ङाहि जनतायि दशा ङाहि थोथोङा होतो, राङ हतिबा ङुङुइबा याङ ङाहि थोथोइबा होतो। हतिबाला थारथोनयाप तेरतु ङा पुपते लेलेबा होतो। ता सअ, ङा खेला मिश्रदेशला चाँतोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“धि मोशा राङ, सुला हतिबे ‘सुइ खेला आङकिङान राङ ल अल भेङान सोइसुइ’ नाइरे माना नानाइबा होतो, हतिला कजसुबायि तेङलायि लोन खेरङान छेरिमि भोटि मे छेकिन ताताति लाम्ला हाकिम राङ मुक्तिदाता सोइरे चाँसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","धि मि राङ मिश्रदेशला, मोरु छो छोम्मुवा राङ लो खलङि थु च्याङ मेते साला हा:लाइयापयि लाइ राङ शक्तियि लाइतेबा क्याइरे हतिबाला फिला ख्योसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“खो हति राङ मोशा ना, काङति इस्राएलितेबाला नानाइबा होतो, ‘कजसुबायि ङेला लालाङा च्वरा हतिबे आज्यो भाइबे नाङने खि चाला ङोन्सेखिलङान झि लाङसोङ।’” ");
INSERT INTO tcn_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","धि हति मोशा राङ ना, काङते च्याङ मेते साला होएता समाजला तेङलायि लोन खेरङान ङ्याबो धु, काङ तेङलायि लोन खेरङानयि सिनै लाला राङ हुइ ताङबुइ मितेबा ङ्याबो ताम नानाइबा होतो, राङ हति राङ हुला तेरयापयि चाला सोम्बो ताम नानाइबातेबा खुँखुँबा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“हुइ ताङबुइ मितेबे ख्युइ आदेश ङ्यानयापला खाला माङ्याना। हतिबे खोला फुलदे मिश्रदेशला राङ लक्ते ढोयापयि सम क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","हतिबे हरुनला जु नाइसोङ, ‘ङि ताङ ताङला ढोङान ला रेन ङि चाला सोइ, चिचालानाना ङेला मिश्रदेशने तोन्दे ख्योङान धि मोशाला च्हि च्युङ ङेला छ्या मेता।’ ");
INSERT INTO tcn_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","हति ङिनला हतिबे पिउ झिकि कु सोइसोङ, राङ हतिला भोल याङ क्यापते पुलसोङ, राङ रेँ लाक्पि लाइ ला कासोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","हिन्नाङ कजसुबायि हतिबाला ङिङच्येसोङ, राङ हतिबाला पान्नाङयि कारमातेबे आराधाना कियाप तोङदु च्युसोङ, च्हिरु ङोन्सेखिलङानबे किताबला टिटिबा धु, ‘इस्राएलयि मितेबा, च्हि लो खलङि थु च्याङ मेते साला ङाला तुढोयि भोल राङ भेटितेबा पुलदेइ? ");
INSERT INTO tcn_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","हतिबे मोलोखयि कुर राङ रेफन लायि कारमा, राङ खि पुजा कियापला सोसोइबि कुतेबा तेक्ते खेरसोङ। ता ङा खेला बेबिलोनने फोइना बन्दि सोइरे खेर च्याइ।’” ");
INSERT INTO tcn_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“च्याङ मेते साला ङि ताङबुइ मितेबे साछियि मण्डप होतोलो। ‘मोशायि थोथोङायि फोटो च्वरा क्याइना कजसुबायि आदेश च्वरा क्याइरे धि सोसोइबा होतो।’ ");
INSERT INTO tcn_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","हुइ ताङबुइ मितेबे याङ हतिबे पालिला यहुदि मान्ते देश आङला ख्युइतुइना यहोशु ङ्याबो हति कुर ख्योसोङ। हतिबा याला ढोलेकेला कजसुबायि हतिबाला तेसोङ, दाउदयि पालि थु राङ हति हतियाराङ लुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","हति कजसुबायि ङिङच्ये खुँसोङ, राङ याकुबयि कजसुबायि चाला त्योएसा झि सोयापयि आङ लाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","हिन्नाङ ख्युइ चाला खिमते सोलोमनयि सोइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“हिन्नाङ लाक्पि सोसोइबि खिमतेबाला पोरोले हा:छेया कजसुबा मितोता, च्हिरु ङोन्सेखिलङानयि नाइदु, ");
INSERT INTO tcn_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ङाहि क्याल ठि तेङला ना, राङ पृथ्‍वी ङाहि काङबि तिङबा, खि ङाहि चाला च्हिरु खिम सोयाप ना? कजसुबा नेन्दु, ङाहि ङालसोसि सा काँहा ना?” ");
INSERT INTO tcn_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","च्हि धि क्युतेबा पोरो ङाहि लाक्पि सोसोइबा मानाइ च्हि? ");
INSERT INTO tcn_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“हे राङढिया बा, सम क्योङबो होएता राङ नामज्यो मिथोइङानबा, खे बारतैला पवित्र आत्मायि विरोध किन्दु। खि ताङबुइ मियि च्हि क्याइ खे याङ हति च्वरा राङ किन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ङोन्सेखिलङानयि नाङने कातेला खि ताङबुइ मितेबे तुरि मापिना? हतिबे केवाकिङान मितेबे क्येयापले ताङला राङ थाकच्योए किङान पोरोला स्येसोङ। खोङला खि धोका पिन्सोङ, राङ खोला स्येसोङ। हतिबा पोरोला स्येसोङ, सुइ हति केवा किङान होङानयि लोन ताङलाने राङ स्यास्याता होतो। ता खे खोला राङ धोका तेरङान राङ मिपस्योए च्युच्युङा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","तेङलायि लोन खेरङानति ठिम ख्योएला खुँसोङ, हिन्नाङ हति माङ्यानसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","जब हतिबे धि ताम थोइरे हतितुइना स्येताङ लाँसोङ राङ स्येताङयि सो चियाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","हिन्नाङ ख्युइ पवित्र आत्मायि खाँरे तेङला यहला लाम्ला झि ताइसोङ, राङ कजसुबयि छे धेयाप राङ येशुला कजसुबायि याइ यहला लाँलाँ थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ख्युइ नाइसोङ, “तोइ, तेङला पेपिया ङाहि थुइदु, राङ मि पिजाला कजसुबायि याइ यहला लाँलाँबा ङाहि थोङिन्दु।” ");
INSERT INTO tcn_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","हिन्नाङ हतिबा क्ये छेया क्याइरे लाँसोङ, राङ राँ राँसि नामज्यो कापसोङ, राङ हतिबा लाम्मा झिला ख्युइ थोला फाल क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","हतिबे खोला भजारयि फिला तोन्दे खेरसोङ, राङ हति थोला टोउ क्यापसोङ। राङ साछितेबे रेँ कोहिला शाउल मिन क्याक्याइबि स्यारा झिकि काङबाला पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","च्हिरु क्याइरे हतिबे स्तिफनसयि थोला टोउ क्याकिन त्येतु, ख्युइ मोनलाम क्यापसोङ, “हे प्रभु येशु, ङाहि आत्माला ग्रहण कि।” ");
INSERT INTO tcn_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ख्युइ पुइमु चुरे क्ये छेया किङगा नाइसोङ, “हे प्रभु येशु, धि तिक्पायि दोष धिबाला लाइ माके।” होचोम नाइरे हतिबे उ च्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ख्युइ सोएयापला शाउल याङ सहमतला होतोलो। हति ङिन यरुश्लेमला च्युच्युङायि चर्चयि विरोधला तुका छोम्मुवा झि सुरु च्युङसोङ, राङ लोब्टुतेबा अर्थात हतिबा पोरो यहुदिया राङ सामरियायि छेत्र यहला खा थोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","भक्ति मितेबे स्तिफनसला खेरते कुसोङ राङ ख्युइ चाला छिमा लेइराङ ताङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","हिन्नाङ शाउल खिम खिमला स्युरे चर्चला सोएयापयि ला किन राङ धु। ख्युइ पिजा राङ पुमोला ढुकिन राङ झ्याल्ला झ्युकिन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","तेहि हति खा थोरते तातातातेबे फाला छुला पोरोला पुते वचन टाइक्ये क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","फिलिपते सामरियायि भजार झिला पुते हतिबाला ख्रिष्ट टाइक्ये किन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","फिलिपयि नानाइबि वचन थोइरे ख्युइ क्याक्याइबि हा:लाइयापयि लाइतेबा थोङदे, मियि तुमतेबे सम च्हि च्युङदे ख्युइ ताम ध्यान पिन्दे ङ्यानसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","चिचालानाना लेइराङने भाभा आत्मातेबा क्ये धोनिन राङ थोनाला छेलसोङ, राङ लेइराङ स्हुयि चा मिघुलङानतेबे नाझा होएतातेबा राङ खोरियातेबा टासोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","हति च्वरा क्याइरे हति भजारला लेइराङ किप्पो च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","सिमोन मिन क्याक्याइबि मिझि हतिया धु। ख्युइ ताङलाने राङ हति भजारला जादु क्याइरे हति सामरियायि मितेबाला हा:लाइतु च्युतु, रेँ राङला ङाराङ ना नाइरे ठानि किन्लो। ");
INSERT INTO tcn_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","हति मिला टिमाने राङ छेया थु जु नाइरे मानि किनलो, “धि मि कजसुबायि हति शक्ति ना, काङतेला शक्ति हा:छेया नेन।” ");
INSERT INTO tcn_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","हतिबे खोला नेनलो, चिचालानाना भेला लेइराङने क्युइ रेँ जादुयि मितेबाला हा:लाइतु च्यु छारतु। ");
INSERT INTO tcn_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","हिन्नाङ जब हतिबे कजसुबे राज्य राङ येशु ख्रिष्टयि मिनयि लोन ल स्योएङान फिलिपयि ताम ला हिछे क्याइसोङ, तेहि पि:जा राङ पुमोतेबे बप्तिस्मा खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","सिमोन खुरि याङ हिछे क्याइसोङ। ख्युइ बप्तिस्मा खेरसोङ, राङ खो फिलिप ङ्याबो पुइसोङ, राङ हा:लाइयापयि लाइ राङ शक्तियि छेयाछेया लाइ क्याक्याइबा थोङदे खो हा:लाइदु। ");
INSERT INTO tcn_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","सामरियायि मितेबे कजसुबायि वचन ङ्यानसोङ नाङान थोइरे यरुश्लेमला होएता लोब्टुतेबे पत्रुस राङ युहान्नाला हतिबे तेहा चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","हतिबा हतिया लेप्ते हतिबाला पवित्र आत्मा खुहोङ नाइरे हतिबे चाला मोनलाम क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","चिचालानाना हतिथु हतिबे नाङने रेनयि थोला याङ खो लेलेबा मेता। हतिबे बप्तिस्मा प्रभु येशुयि मिनला मात्र च्युच्युङा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","तेहि ख्योए रेँ लाक्पा हतिबे थोला पोरसोङ, राङ हतिबाला पवित्र आत्मा खुसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ता लोब्टुतेबे लाक्पा भोरितुइना पवित्र आत्मा खुयिन्दु नाइरे थोङदे सिमोनयि जु नेनराङ हतिबाला आलाइ तेराला छेलसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ङाला याङ धि शक्ति नाङ, राङ काङ काङला लाक्पा पोर छारते च्येला हति पवित्र आत्मा खुहोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","हिन्नाङ पत्रुसयि नाइसोङ, “ख्युइ आलाइ ख्योए ङ्याबो मासि सह, चिचालानाना कजसुबायि वरदान आलाइयि ङ्यो ङ्युइकिन नाइरे ख्युइ विचार क्यइदु। ");
INSERT INTO tcn_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","धि भारेला न त ख्युइ भाग होतो न हिस्सा होतो, चिचालानाना कजसुबायि धुनला ख्युइ सम थारका मिधु। ");
INSERT INTO tcn_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","हतिचाला ख्युइ अलयि चाला घ्योप्पा कि तेहि प्रभुला मोनलाम क्योप, राङ हा:लाम ख्युइ समयि धि च्वरा विचार माप होङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","चिचालानाना ङा थोङिन्दु, ख्योए खाडेयि खाँखाँबा धु, तेहि तिक्पायि लाला धु।” ");
INSERT INTO tcn_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","तेहि सिमोनयि नाइसोङ, “खिरि राङ ङाहि चाला प्रभुला मोनलाम क्योप, राङ क्युइ नानाइबि ताम च्याङ ङाहि थोला मायोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","तेहि हतिबे साछि पिन छारते च्येला राङ प्रभुयि ताम नाइ छारते सामरियि लेइराङ युलला लोन ल टाइक्ये किन राङ हतिबा यरुश्लेमला लक्तेलो। ");
INSERT INTO tcn_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","हति च्येला प्रभुयि तेङलायि लोन खेरङान झिकि फिलिपला नाइसोङ, “लाँरे च्याङ यहला यरुश्लेमने गाजा यहला ढोङानयि लामला क्यु। हतिया च्याङ मेते लाम धु।” ");
INSERT INTO tcn_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","तेहि फिलिप लाँरे पुइसोङ, राङ इथियोपियायि फोलोमोलो झिला ठेसोङ, काङते इथिपिया देशयि क्यालमु कन्दाकिया पद छोम्मुवा राङ लेइराङ क्युयि कोषाध्‍यछ हिना। मो यरुश्लेमला आराधाना कितु पुइतु। ");
INSERT INTO tcn_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","मो लक्ते हुन त्येतु, राङ रेँ ताङाला ताते यशैया ङोन्सेखिलङानयि किताब टकिन त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","तेहि पवित्र आत्मायि फिलिपला नाइसोङ, “क्यु राङ हति ताङा ङ्याबो क्यु।” ");
INSERT INTO tcn_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","फिलिप हति तेहा स्युरे पुइसोङ, राङ खोला यशैया ङोन्सेखिलङानयि किताब टोङान थोइरे मुइ नाइसोङ, “ख्युइ टटबि ताम हा:कुन धुये?” ");
INSERT INTO tcn_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","तेहि ख्युइ नाइसोङ, “सुयाङ मानाइबि ङाहि च्हिरु क्याइरे हा:को ज्याइ?” तेहि मुइ फिलिपला ताङायि थोला कालदे मो ङ्याबो त्योएयापयि स्युवा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ता ख्युइ टकिन ताताति पवित्रशास्त्रयि लाइनते धि ना, “च्हिरु क्याइरे लुला तुपयापयि चाला खेरिन, वा लु हति तुपङानतेबे धुनला च्यामाना तोकिन, हति च्वरा क्याइरे राङ क्युइ रेँ खा मापेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ख्युइ ना च्याच्याति अवस्थाला खोला न्याय माखुसोङ। क्युइ पालियि मनङि सुइ क्याक च्याइ? चिचालानाना ख्युइ मिजे पृथ्‍वीने मासि च्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","तेहि हति फोलो मोलोयि फिलिपला टिसोङ, “ङिङच्येरे ङाला नोइ, ङोन्सेखिलङानयि धि ताम सुला नानाइबा ना, ख्युइ खुरि भारेला कि स्यान सुगे भारेला?” ");
INSERT INTO tcn_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","तेहि फिलिपयि रेँ खा पेरे पवित्रशास्त्रयि हति लाइनने राङ खोला येशुयि लोन ल स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","तेहि खो लामला ढुनढुन छ्यु टिझि होएते साला क्योप छारसोङ। हति फोलोमोलोयि नाइसोङ, “तोइ, ङिहा छ्यु धु, ङाला बप्तिस्मा होङयापला सुइ घा ङ्युकिन?” ");
INSERT INTO tcn_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","फिलिपयि नाइसोङ, “तेम्बारे सम पोरोयि हिछे किना ख्युइ बप्तिस्मा खेरना हुन।” हति जवाक पिन्सोङ “येशु ख्रिष्ट राङ कजसुबायि पिजा ना नाइरे ङा हिछे किन होए।” ");
INSERT INTO tcn_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ख्युइ ताङा घायापयि आदेश पिन्सोङ, तेहि फिलिप राङ हति फोलो मोलो ङिकार छ्युला पुपसोङ, राङ ख्युइ हतिला बप्तिस्मा पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","हिन्नाङ जब हतिबा छ्युने फिला थोन्दे, तेहि प्रभुयि आत्मि फिलिपला सुङदे खेरसोङ, राङ हति फोलो मोलुइ खोला याङ माथोङा, राङ हति केन राङ रेँ लाम स्युरे पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","हिन्नाङ फिलिप अश्दोदला थोङसोङ, राङ कैसरिया माक्योप थु भजारतेबाला लोन ल स्योकिन राङ पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","शाउल प्रभुयि लोब्टुतेबे विरोधला तरह थरकाइ राङ सोएयापयि धुनला घोबा पुजारि तेहा पुइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","राङ ख्युइ धि लामयि पिजा होङ वा पुमो, कुला खु नाङ हतिबाला किरे यरुश्लेमला ख्योङ ज्याइ खु नाइरे दमस्कसयि यहुदि झोमसि खिमतेबे मिनला पुर्जि लाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","जब शाउल ढुल कि राङ दमस्कसयि धुनला क्योपते, हो:प्तामेला तेङलाने होए झि ख्युइ फाला छुलोला होए भारसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","खो साला घेलसोङ, राङ ख्युइ जु नाङान क्ये थोइसोङ, “शाउल, शाउल, ख्योए ङाला चिला तुका तेरिन?” ");
INSERT INTO tcn_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ख्युइ नाइसोङ, “प्रभु, ख्योए सु ना?” तेहि ख्युइ नाइसोङ, “ङा येशु ना, सुला ख्योए तरि तेरिनदु। ");
INSERT INTO tcn_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","हिन्नाङ लाँरे भजारला क्यु, राङ ख्युइ च्हि किच्याइ होङ सो खेला स्योएङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","खो ङ्याबो ढोङान मितेबे क्येते थोइसोङ, हिन्नाङ माथोङा राङ च्याङ नायाप मेता च्युङदे लुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","तेहि शाउल साने लाँसोङ राङ मि भेतुइना ख्युइ च्याङ माथोङसोङ, राङ हतिबे ख्युइ लाक्पा सुङदे ठिते खोला दमस्कसला खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","तेहि ङिन सुम थु खो मिथोङान च्युङसोङ, राङ न त ङ्योपा साइसोङान छ्यु तुसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","दमस्कसला हननिया मिन क्याक्याइबि लोब्टु झि धु। खोला प्रभुयि दर्शनला नाइसोङ, “ए हननिया।” ख्युइ नाइसोङ, “प्रभु, ङिहा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","तेहि प्रभुयि खोला नाइसोङ, “ल्हँ, राङ ‘थारका’ मिन क्याक्याइबा होएता गल्लिला क्यु, राङ हतिया यहुदायि खिमला शाउल मिन क्याक्याइबि टार्ससला त्योएङान झिला फोए, चिचालानाना को मोनलाम क्याकिन राङ धु। ");
INSERT INTO tcn_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ख्युइ मिलामला हननिया मिन क्याक्याइबि मिझि नाङला लेप्ते खो थोङ ङ्युइ नाइरे रेँ थोला ख्युइ लाक्पा पोपोरा थोथोङा धु।” ");
INSERT INTO tcn_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","हिन्नाङ हननियायि नाइसोङ, “प्रभु, धि मितेबे यरुश्लेमला ख्युइ कजसुबायि मितेबाला चोम अल क्याक्याइबा होतो, सो ङाहि लेइराङने थोथोइबा होए। ");
INSERT INTO tcn_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ङिहा याङ ख्युइ मिन खेरङान पोरोला तेमयापयि आङ घोबा पुजारितेबाने खोला खुँखुँबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","हिन्नाङ प्रभुयि हतिला नाइसोङ, “क्यु, चिचालानाना यहुदि मान्ते मितेबाला, क्यालबोतेबा राङ इस्राएलयि सन्तनतेबे धुनला ङाहि मिन टाइक्ये कियापला खो धाधामा ङाहि पत्र झि ना। ");
INSERT INTO tcn_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","चिचालानाना ङाहि मिनयि चाला ख्युइ चोम तुरि ङ्योङ कोइ हुन, सो ङा खोला तोनज्याइ।” ");
INSERT INTO tcn_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","तेहि हननिया पुते हति खिमयि नाङला स्युसोङ, राङ हति थोला रेँ लाक्पा पोरते नाइसोङ, “भाइ शाउल, काङ प्रभु येशु हुन तातातायि लामला ख्युइ तेहा थोङदे, ख्युइ राङ ख्योए थोङान सह राङ पवित्र आत्मायि खाँखाँबा सह नाइरे ङाला चाँचाँबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","हतितुइनाराङ ख्युइ मिने पाप्रा च्वरा चिगा ङिलसोङ, राङ याङ खो थोङान च्युङसोङ। तेहि खो लाँसोङ राङ बप्तिस्मा खेरसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","तेहि ङ्योपा साइरे खोला तोप क्येसोङ। शाउल ङिन लेइराङ थु दमस्कसला होएता लोब्टुतेबा ङ्याबो त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","तेहि हतितुइना राङ यहुदि झोमसि खिमतेबाला येशुयि घोषाणा धि च्वरा क्याइरे क्याइसोङ, “खो कजसुबायि पिजा हिना।” ");
INSERT INTO tcn_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","तेहि ङ्यानङानतेबा पोरोयि हा:लाइरे नाइसोङ, “ङाहि मिन खेरङान पोरोला यरुश्लेमला मिप सोएयि काण्डला राङ ङिहा याङ हतिबाला ताम्दे घोबा पुजारितेबे चाना खेरयापला हा:कोरे होङान ङिहा राङ मानाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","हिन्नाङ शाउल तरह शक्तिशालि हुन राङ पुइसोङ, राङ येशु राङ ख्रिष्ट हिना नाङानयि साछि पिन्दे दमस्कसला त्योएङान यहुदिबाला च्यामाना सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","तेहि ङिन लेइराङ पुइ छारते यहुदिबे खोला सोएयापयि छल सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","हिन्नाङ हतिबे छल शाउलला छ्या च्युङसोङ। हतिबा झोला स्योएयापयि चाला ङिन छान भजारतेबे खोला कहुरे तोकिनलो। ");
INSERT INTO tcn_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","हिन्नाङ ख्युइ लोब्टुतेबे खोला छाम्मु राङ फुगोला च्युक्ते प्येने पापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","खो यरुश्लेमला लेप्छारते ख्युइ लोब्टुतेबा ङ्याबो ढियापयि कोशिश क्याइसोङ। हिन्नाङ हतिबाला खो लोब्टु हिना नाङान हिछे माच्युङाति पोरो खो ङ्याबो झिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","हिन्नाङ बारनाबासयि खोला ङ्याबो खेरते लोब्टुतेबे तेहा खेरसोङ। तेहि शाउलयि प्रभुला लामला थोथोङा राङ प्रभु खो ङ्याबो ताम नानाइबा राङ ख्युइ दमस्कसला हा:मराङ किङगा येशुयि मिन टाइक्ये क्याक्याइबि ताम हतिबाला स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","शाउल हतिबा ङ्याबो यरुश्लेमला मन स्याङ क्याइरे ढुवाला छेलसोङ, राङ हा:म किङगा राङ प्रभुयि मिनला टाइक्ये किताला छेलसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","तेहि खो ग्रिक यहुदितेबा ङ्याबो नारे क्याइसोङ, हिन्नाङ हतिबे खोला सोए च्युइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","हिन्नाङ धि हा:कोरे भाइतेबे खोला कैसरियाला ख्योसोङ राङ हतिने खोला टार्ससला चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","हति च्वरा क्याइरे यहुदिया पोरो, गालिल राङ सामरिया काङ चर्चला शान्ति च्युङसोङ राङ चर्च स्यु छेया च्युङसोङ। प्रभुयि झिटाला ढुन राङ पवित्र आत्मायि खाइकोए खुँरे चर्च यारके हुन राङ पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","पत्रुस फाला छुला सा पोरोला ढुल किन राङ लुड्डाला होएता कजसुबायि मितेबे तेहा याङ लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ख्युइ हतिया एनियास मिन क्याक्याइबि मिझिला ठेसोङ, सुते लो क्येने स्हु च्याङ मिघुलङानयि नाझि मालसाला ङ्यालान च्युच्युङा धु। ");
INSERT INTO tcn_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","पत्रुसयि हतिला नाइसोङ, “ए एनियास, येशु ख्रिष्टयि ख्योएला टाक्तु झ्युङान ना। ल्हँ, राङ ख्युइ मालसा तुइ।” तेहि खो हतितुइना राङ लाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","लुड्डा राङ शारोनला त्योएङान पोरोयि हतिला थोङदे प्रभु यहला लसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","योप्पा भजारला तबिता, अर्थात, डोरकास(हरिणि) नाङान लोब्टुमो झि धु। हति लाइ ल कितु राङ दान तेरयापयि लाइ किन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","हति ङिनला हति नाप्पा च्युङसोङ राङ हति स्यिसोङ, राङ मितेबे ठुइ क्यापते मोला थकि तलायि कोटाला पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","लुड्डा योप्पायि धुनला च्युच्युङाति, लोब्टुतेबे पत्रुस हतिया धु नाङान थोइरे ख्युइ तेहा मिरको ङेला जु नाइरे स्युवा क्याकतु चाँसोङ, “ङि तेहा पुला मिकिता सअ।” ");
INSERT INTO tcn_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","तेहि पत्रुस लाँरे हति ङ्याबो पुइसोङ। हतिया क्योप छारते हतिबे खोला थकि कोटाला खेरसोङ। राढितेबा पोरो ख्युइ धुनला लाँरे ङुवाला छेलसोङ, राङ डोरकास हतिबा ङ्याबो होतितुइना सोसोइबि कोहिला राङ स्यान कोहिलातेबा तानसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","हिन्नाङ पत्रुसयि हतिबा पोरोला फिला चाँरे पुइमु चुसोङ राङ मोनलाम क्यापसोङ, राङ हति स्हु यहला लक्ते नाइसोङ, “तबिता, ल्ह!” तेहि मुइ मि पेसोङ, राङ पत्रुसला थोङदे लाँरे त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ख्युइ मोला रेँ लाक्पि सुङदे जुरुक्का लाँसोङ, तेहि कजसुबायि मितेबा राङ राढियातेबाला क्ये ताङदे हतिला सोम्बो तानसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ता धि ताम योप्पा काङ राङ फैलि च्युङसोङ, राङ लेइराङयि प्रभुला हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","तेहि खो ङिन लेइराङ थु सिमोन नाङान झि पाबुइ लाइकिङान ङ्याबो योप्पाला त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","कैसरिया कर्नेलियस मिन क्याक्याइबि मिझि धु, सुते इटालिया नाङानयि सिपाहियि घोबा हिना। ");
INSERT INTO tcn_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","खो कजसुबायि भक्ता हिना, राङ खो राङ ख्युइ प्येरा पोरोयि कजसुबायि झिटा मानि किनलो। ख्युइ मितेबाला सम छेया किङगा दान पिन्दे कजसुबाला बारतैला मोनलाम क्याकिन। ");
INSERT INTO tcn_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ख्युइ ङिम्मु तिन बजे झोमला दर्शनला चाङमा क्याइरे कजसुबायि तेङलायि लोन खेरङान झि राङ यहला लेप्ते जु नानाइबा थोइसोङ, “कर्नेलियस!” ");
INSERT INTO tcn_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","झिरे ख्युइ हतिला ल क्याइरे ताइसोङ राङ नाइसोङ, “प्रभु, नोइ।” तेहि ख्युइ नाइसोङ, “ख्युइ मोनलाम राङ टाङनाबाला पिपिनि दान याकायि चाला कजसुबायि धुनला क्योक्योबा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","तेहि मितेबाला योप्पाला चँह, राङ पत्रुस नाङान सिमोनला क्ये ताङदे चँह। ");
INSERT INTO tcn_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","खो पाबुइ लाइकिङान सिमोनयि तेहा त्येतु, सुइ खिम छो छोम्मुवायि धुनला धु।” ");
INSERT INTO tcn_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","जब खो ङ्याबो ताम नाङान तेङलायि लोन खेरङान, बिदा च्युङदे, तेहि ख्युइ रेँ यक्पुवातेबे नाङने ङि राङ मिछ्याता ख्युइ स्यापच्यि स्युरु भक्ता सिपाहि झिला क्ये ताङदेलो, ");
INSERT INTO tcn_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","राङ हतिबाला ताम पोरो स्ये छारते च्येला योप्पाला चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ङाइटोतेला हतिबा रेँ ढुलला हति भजारयि धुनला हुइतुइना, ङिम्मुइ च्युनङि बजे झोमला पत्रुस मोनलाम क्याकतु खिमयि खानाला थोन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","खो टोपा तसोङ, राङ ख्युइ चिगा सा सोम क्याइसोङ, हिन्नाङ स्यानतेबे ङ्योपा तयार सुइतुइना खो ध्यान मग्न च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ख्युइ तेङला प्येप्ये राङ हतिने फाला छुला पोरोने तन्ना तातामा च्वरा पृथ्‍वी यहला रेन कुरुकुरु काङबा स्यि क्याक्याइबा तुढो राङ स्युरे ढोङान उ होएता तुढो राङ पान्नाङला च्याचिउतेबा धु ");
INSERT INTO tcn_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","हति तन्नाला पृथ्‍वी पोरो कुरकुर काङबा स्यि क्याक्याइबा तुढो राङ स्युते ढोङानयि तुढो राङ पान्नाङयि च्योज्युङतेबा याङ धु। ");
INSERT INTO tcn_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","तेहि ख्युइ क्ये झि थोइसोङ, “ए पत्रुस ल्ह, राङ साते स्हो।” ");
INSERT INTO tcn_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","हिन्नाङ पत्रुसयि नाइसोङ, “माना प्रभु, चिचालानाना ङाहि जब याङ च्याङ अपवित्र वा भाभा क्यु सासाइबा मेता।” ");
INSERT INTO tcn_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","हति क्ये लाम्मा ङिबा याङ ख्युइ थोइसोङ, “कजसुबायि चाङमा सोसोइबा होतो हतिला ख्योए भाभा ठानि माके।” ");
INSERT INTO tcn_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","लाम्मा सुम थु धि च्वरा च्युङसोङ, राङ हतितुइना राङ हति तन्ना तेङला यहला खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","जब पत्रुस खुरि थोथोङा धि दर्शनयि खुँ च्हि हिनोम नाइरे सम नाङ नाङला आच्यामाच्या च्युङसोङ, हतितुइना राङ कर्नेलियसयि चाँचाँबि मितेबा सिमोनयि खिम फाकिन राङ कोयि धुनला लाँरे त्येसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","“पत्रुस नाङानयि सिमोन ङिहा ताताता होए कि?” नाङान क्ये छेयाला टिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","जब पत्रुस दर्शनयि भारेला विचार किन ताताता होतो हतितुइना अपवित्र आत्मायि खोला नाइसोङ, “तोइ, मिरको समुयि ख्योएला फाकिन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ल्हँ, राङ माला क्यु, राङ माख्यारा हतिबा ङ्याबो क्यु, चिचालानाना हतिबाला ङाहि चाँचाँबा ना।” ");
INSERT INTO tcn_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","तेहि पत्रुस पुपसोङ, राङ हति मितेबे तेहा पुते नाइसोङ, “तोइ, खि पापाति मिते ङा ना। खे ङिहा लेलेबि खुँ च्हि ना?” ");
INSERT INTO tcn_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","हतिबे नाइसोङ, “घोबा मिझि कर्नेलियस, सु टुङबो राङ कजसुबा ङ्याबो झियाप राङ यहुदि मितेबाने सम्मान खुँखुँबि मिना, ख्योएला ख्युइ खिमला क्ये ताङदे चोँङान राङ ख्युइ चिने लोन ङ्योन नाइरे पवित्र तेङलायि लोन खेरङानने खोला आदेश खुँखुँबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","तेहि ख्युइ हतिबाला नाङला क्ये ताङदे हतिबाला ढोम्बो स्यामसोङ। ङाइटोतेला पत्रुस लाँरे हतिबा ङ्याबो पुइसोङ, राङ योप्पायि चोम राङ भाइतेबा। ");
INSERT INTO tcn_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","जब हतिबा कैसरियाला क्योपसोङ। रेँ मितेबा राङ धुनयि रुवातेबाला क्ये ताङदे रुरे कर्नेलियस हतिबे लाम तेन त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","जब पत्रुस नाङला लेप्ते हतितुइना कर्नेलियस खो ङ्याबो ठाते ख्युइ काङबा सुङदे छ्या पुलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","हिन्नाङ पत्रुसयि खोला जु नेन राङ त्येसोङ, “ल्हँ, ङा राङ याङ मिनि हिन।” ");
INSERT INTO tcn_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","तेहि खो हति ङ्याबो ताम नेन राङ खिमयि नाङला स्युसोङ, राङ ख्युइ हतिया लेइराङ झोझोमा ठेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","तेहि पत्रुसयि खोला नाइसोङ, “यहुदि मान्ते मितेबा ङ्याबो सङ्गत कि, अथवा हतिबा ङ्याबो ठेरे कि यहुदि झिकि चाला अनुचित हिना नाङान ताम ख्योएला छ्या मेताइ, हचु हिन्नाङ कजसुबायि ङाला मि रेनला अपवित्र अर्थात भाभा ठानि माके नाइरे ताताना होतो। ");
INSERT INTO tcn_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","हतिचाला क्योबि पाल्ला आपति च्याङ माताना ङा ख्युइ तेहा लेप्ते। ख्युइ ङाला चिला कापते? ता नोइ।” ");
INSERT INTO tcn_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","तेहि कर्नेलियसयि नाइसोङ, “ङि स्यियि ताङला हा:लाम धि भेलाला तिन बजेयि मोनलाम किन ताताता धु, तेहि चहकिलो कोहिला कोकोनि मिझि ङाहि धुनला लाँसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","राङ नाइसोङ, ‘कर्नेलियस, कजसुबायि धुनला ख्युइ मोनलाम ङ्याङ्याना होतो, राङ ख्युइ टाङनाबाला पिपिनि दानयि याका च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","हतिचाला योप्पाला मितेबा चाँरे पत्रुस नाङान सिमोनला क्ये ताङदे चाँसोङ। खो छो छोम्मुवायि नेमुला पाबुइ लाइकिङान सिमोनयि खिमला ताताता धु।’ ");
INSERT INTO tcn_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","तेहि ङाहि हतितुइना राङ ख्युइ तेहा मि चाँसोङ, राङ ख्योए ङिङच्ये राङ ङ्याबो लेप्सोङ। ता प्रभुने ख्योएला आदेश पिपिनि ताम पोरो ङ्यानयापला ङे पोरो कजसुबायि धुनला ङिहा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","तेहि पत्रुसयि ताम नाला छेलसोङ, “तेम्बारे ङा थुइदु, कि कजसुबायि छह मिकिता।” ");
INSERT INTO tcn_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","हिन्नाङ मितेबे पोरोला सु खो ङ्याबो झिकिनलो, राङ लाइ ल किन, हति ग्रहण योग्य हुन। ");
INSERT INTO tcn_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","कजसुबायि इस्राएलितेबाला चाँचाँबि लोन, अर्थात येशु ख्रिष्टयि लाम्ला टाइक्ये क्याक्याइबि शान्तियि लोन ल खेला छ्या होतो। (खो राङ पोरोयि कजसुबा ना।)। ");
INSERT INTO tcn_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","युहान्नायि टाइक्ये क्याक्याइबि बप्तिसमायि च्येला, गालिलने सुरु क्याइरे यहुदिया काङ टाइक्ये क्याक्याइबि वचन धि राङ ना, ");
INSERT INTO tcn_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","कि कजसुबायि नासरातयि येशुला पवित्र आत्मा राङ शक्तियि अभिशेक क्याइसोङ लाइ ल किन राङ दियाबलसने तुका पिपिनातेबाला टाक्तु झ्युकिन राङ ढुनलो, चिचालानाना कजसुबा खो ङ्याबो धु। ");
INSERT INTO tcn_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“तेहि ख्युइ यहुदितेबे देश राङ यरुश्लेमला क्याक्याइबि तामयि ङे साछि ना। खोला खि पालेपला तारे याङ सेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","खोला राङ कजसुबायि ङिन सुबाला सोम्बो सोइरे लाङसोङ, राङ खोला तान्सोङ, ");
INSERT INTO tcn_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","मि पोरोला माना, हिन्नाङ हु सुला ल कजसुबायि साछियि धोला धाधामा होतो, राङ खो स्यि छारते सोम्बो च्युङ छारते ङि खो ङ्याबो ङ्योपा साइरे। ");
INSERT INTO tcn_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ख्युइ ङेला जनताला टाइक्ये कितु, राङ खो सोम्बो राङ स्यिस्यियातेबे ल अल भेङान होङयापला कजसुबायि लामला धाधामा मि ना नाङानयि साछि तेरयापला आदेश पिपिना धु। ");
INSERT INTO tcn_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ङोन्सेखिलङान पोरोयि ख्युइ साछि पिपिना होतो, कि ख्युइ थोला हिछे किङान पोरोयि ख्युइ मिनयि लाम्ला तिक्पा माप खुकिन।” ");
INSERT INTO tcn_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","पत्रुसयि धि तामतेबा नेननेन वचन ङ्यान ङान पोरोयि थोला पवित्र आत्मा पापतु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","यहुदि मान्ते मितेबे थोला याङ पवित्र आत्मायि वरदान च्योच्युवा थोङदे पत्रुस ङ्याबो होङान यहुदि हिछे किङानतेबा हा:लाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","चिचालानाना स्यान क्येला ताम नाइरे हतिबे कजसुबायि छे तेतेका हतिबे थोइसोङ। तेहि पत्रुसयि नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“ङेला च्वरा पवित्र आत्मा खुङान धिबाला छ्युयि बप्तिसमा होङयापला सुइ माना न ङ्युइकिन?” ");
INSERT INTO tcn_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","तेहि क्युइ हतिबाला येशु ख्रिष्टयि मिनला बप्तिसमा पिन नाइरे आदेश पिन्सोङ। तेहि हतिबे पत्रुसला चिगा तेरयापला हतियाराङ त्योए नाइरे स्युवा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","यहुदियाला होएता लोब्टु राङ भाइतेबे यहुदि मान्ते मितेबे याङ कजसुबायि वचन ग्रहण क्याइदु नाङान थोइदु। ");
INSERT INTO tcn_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","जब पत्रुस यरुश्लेमला लेप्ते, हतितुइना खतना किङानतेबे तुमतेबे खोला जु नेन राङ ख्युइ विरोध क्याइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“खतना मिकिङान मितेबे तेहा पुते हतिबाला ख्युइ च्हिला ङ्योपा साइरे?” ");
INSERT INTO tcn_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","तेहि पत्रुस पालिपालि किङगा मनङि क्याकाला छेलसोङ: ");
INSERT INTO tcn_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ङा योप्पा भजारला मोनलाम क्याकिन होए, तेहि तन्ना छेया झि च्वरा कुना स्यिला सुङदे तेङलाने माला पापङान चिगा क्यु ङाहि दर्शनला थोङसोङ, राङ हति ङाहि तेहा लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ङा ल क्याइरे तोतितुइना हतिया पृथ्‍वी तुढो राङ झङगलयि तुढो, स्युते ढोङानयि तुढो राङ पान्नाङयि च्याचिउतेबा थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ङाला जु नानाइबि क्ये झि ङाहि थोइसोङ, ‘पत्रुस ल्हँ, राङ साते स्हो।’ ");
INSERT INTO tcn_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","हिन्नाङ ‘ङाहि माना प्रभु, चिगा भाभा अथवा भाभा ताम ङाहि खाला जब याङ स्युस्युबा मेता।’” ");
INSERT INTO tcn_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“हिन्नाङ हति क्येयि लाम्मा ङिबा तेङलाने ङाला नाइसोङ, ‘च्हि कजसुबायि चाङमा सोइरे हतिला ख्योए भाभा माना।’” ");
INSERT INTO tcn_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","लाम्मा सुम धि च्वरा राङ च्युङसोङ, राङ हतिबा पोरो याङ तेङलाना खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","हति भेलाला राङ कैसरियाने ङाहि तेहा चाँचाँबि मिरको सुम ङे ताताति खिमला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","मा झिबा हतिबा ङ्याबो ढोयापला पवित्र आत्मायि ङाला नाइसोङ। धि भाइ टुपाते याङ ङा ङ्याबो खेखेरा होतो, राङ ङे हति मियि खिमला स्युरे। ");
INSERT INTO tcn_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","ख्युइ ङेला नाइसोङ, कि तेङलायि लोन खेरङान झि ख्युइ खिमला लाँरे जु नाङान ख्युइ थोङसोङ, योप्पाला मि चाँरे पत्रुस नाङान सिमोनला क्ये ताङते चँह। ");
INSERT INTO tcn_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ख्युइ खेला वचन स्योएङान ना, काङति लाम्ला खोला थारथोनयाप खुङान ना ख्योए राङ क्युइ प्येरा पोरोला। ");
INSERT INTO tcn_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“जब ङाहि ताम नाला छेलदे, हतितुइना ताङला ङि थोला पापाबा च्वरा क्याइरे पवित्र आत्मा ख्युइ थोला याङ पापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","तेहि प्रभु नानाइबि हति वचन ङाला टाम्बा च्युङसोङ, ‘युहान्नि ता छ्युयि बप्तिसमा पिन्सोङ, हिन्नाङ पवित्र आत्माने खि बप्तिस्मा होङान ना।’ ");
INSERT INTO tcn_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","प्रभु येशु ख्रिष्टयि थोला हिछे कितितुइना कजसुबायि ङेला काङ वरदान पिन, हतिबाला याङ हति वरदान पिन छारते कजसुबाला घा ङ्युइङान ङा सु ना?” ");
INSERT INTO tcn_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","धि ताम थोइ छारते हतिबा च्यामाना त्येसोङ, राङ जु नेन राङ हतिबे कजसुबायि छे तेसोङ, “ता कजसुबायि यहुदि मान्ते मितेबाला याङ मिजेयि चाला घ्योप्पा कियाप पिन्दु।” ");
INSERT INTO tcn_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","स्तिफनसयि सम्बन्धला सुरु च्युच्युङायि तुकायि चाला काङ च्याला खा थोथोरातेबे स्यानला माना, हिन्नाङ यहुदिबाला मात्रा वचन टाइक्ये किन राङ, फोनिके, साइप्रस राङ एन्टिओखिया थु ढुल क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","हिन्नाङ हतिबे नाङने रेनरेन साइप्रस राङ कुरेनियि मितेबा धु। हतिबे एन्‍टिओखियाला लेप्ते ग्रिकबाला याङ प्रभु येशु टाइक्ये क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","प्रभुयि लाक्पा हतिबा ङ्याबो होतोति हिछे किङानतेबा टाँगा लेइराङला प्रभु यहला लसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","धि लोन यरुश्लेमला होएता चर्चयि नामज्योला क्योपसोङ राङ हतिबे बारनाबासला एन्‍टिओखियाला चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","हति लेप्ते कजसुबायि ङिङच्ये थोङदे कासोङ, राङ हतिबा पोरोला सम तिङने राङ प्रभुयि थोला हिछे त्योएयापयि साला समस्यु पिनसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","चिचालानाना हति ल, पवित्र आत्मा राङ हिछेयि खाँखाँबि मि झि होतोलो। मितेबे तुम छोम्मुवा झि प्रभुला थपि च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","तेहि शाउल फातु बारनाबास टार्ससला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","जब ख्युइ खोला ठेसोङ तेहि ख्युइ एन्‍टिओखियाला ख्योसोङ। तेहि पुरा लोझि थु चर्चयि मियि तुम छोम्मुवाला छोइ पिन्सोङ। लोब्टुतेबा लाम्मा ताङस्युवा एन्‍टिओखियाला ख्रिष्टियान नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","हति भेलाला ङोन्सेखिलङानतेबा यरुश्लेमने एन्‍टिओखियाला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","हतिबे नाङने अगाबस मिन क्याक्याइबि मि झि लाँरे संसार पोरोला अनिकाल छेया झि होङाला छेलदु नाङान पवित्र आत्मायि लाम्ला ङोन्सेखिलदु। हति अनिकाल क्‍लौडियसयि शासन कितितुइना परि च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","तेहि लोब्टुतेबा पोरोयि राँ राँसि औकात च्वरा क्याइरे यहुदियाला त्योएङान भाइतेबे सहमति चाला भेटि कुरयापयि थाक च्योए क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","हतिबे जु राङ क्याइसोङ, राङ बारनाबास राङ शाउलयि लाक्पि लाम्ला हतिबे भेटि एल्डरतेबे तेहा चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","हति ङिनला हेरोद क्यालबुइ चर्चयि चोमयि थोला क्योङ अत्यचार किताला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ख्युइ युहान्नायि भाइ याकुबला तोरबालि स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","हति लाइयि यहुदिबा काका थोङदे पत्रुसला याङ सुङयापयि च्युइ क्याइसोङ। हति घटना सिनि ङिनयि लोटायि का:लापसोङ भेलाला च्युच्युङा होतोलो। ");
INSERT INTO tcn_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","हेरोदयि पत्रुसला सुङदे झ्याल्ला च्युसोङ, राङ निस्तार कालापसोलयि च्येला खोला जनतायि धुनला ख्योङयापयि च्युइ क्याइरे खोला स्युङानतेबाला सिपाहियि तुम स्यिला टोएसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","हति च्वरा क्याइरे पत्रुसला झ्याल्ला च्युसोङ, हिन्नाङ ख्युइ चाला चर्चयि कजसुबाला जोस छेया क्याइरे मोनलाम क्याकिन त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","हेरोदयि हतिला फिला ख्योङयाप पापाति छान, पत्रुस च्यालतायि ताम्दे सिपाहि ङि उइला ङ्याङ्याला धु। सिपाहितेबा याङ कोयि धुन यहला लाँरे झ्याल्ला स्युङिन त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","हो:प्तामेला प्रभुयि लोन खेरङान झि हतिया थोङसोङ, राङ कोटायि नाङला होए भारसोङ। तेङलायि लोन खेरङानयि पत्रुसला टाङला क्यापसोङ तेहि “घ्यबो ल्ह” नाइरे खोला लाङसोङ। तेहि च्यालतातेबा ख्युइ लाने पिते छारसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","तेङलायि लोन खेरङानयि खोला नाइसोङ, “कोहिला कोन, राङ पोउला कोन।” तेहि ख्युइ हति च्वरा राङ क्याइसोङ। ख्युइ हतिला नाइसोङ, “कोहिला कोन्दे ङाहि च्येला सह।” ");
INSERT INTO tcn_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","तेहि को थोन्दे ख्युइ च्येच्येला पुइसोङ। तोङलायि लोन खेरङानयि तेम्बारे हिना नाङान खोला छ्या माच्युङसोङ। हिन्नाङ दर्शन थोङिन नाइरे ख्युइ ठानि क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","जब ताङस्युवा राङ ङिबा स्युङान तुम झोम्दे भजारला स्युङान च्यायि कोला हतिबा क्योपसोङ, तेहि हति को खो राङ हतिबे धुनला प्येसोङ, राङ हतिबा फिला थोन्दे लालिलयि लाम झिकि लाम्ला पुइसोङ, राङ हतितुइना राङ तेङलायि लोन खेरङान खोला ताङदे पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","जब पत्रुसयि होस खोलि च्युङसोङ, “ता ङाला तेम्बारे राङ छ्या च्युङसोङ, कि प्रभुयि रेँ तेङलायि लोन खेरङान चाँरे हेरोद क्यालबोयि लाने, राङ यहुदिबे च्हि किसोम होए हतिबा पोरोने थारथोनयाप पिन्सोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","धि ताम खोला छ्या च्युङ छारते, खो मर्कुस नाङान युहान्नायि आमा मरियमयि खिमला पुइसोङ। हतिया लेइराङ झोम्दे मोनलाम क्याकिन त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ख्युइ को तुङितुइना रोदा मिन क्याक्याइबि यक्मुवा को भेरु लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","पत्रुसयि क्ये ङस्येरे हति कारे को राङ मा पिया नाङला स्युरते पुइसोङ “पत्रुस खोला लाँरे राङ त्यतु” नाइरे लोन पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","हिन्नाङ हतिबे हतिला नाइसोङ, “ख्योए ङ्योमबा राङ ना” हिन्नाङ हति नानाइबि ताम तेम्बारे राङ ना नाइरे हति राङढिया क्याइसोङ। तेहि हतिबे नाइसोङ, “हति ख्युइ लोन खेरङान हिनोम।” ");
INSERT INTO tcn_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","हिन्नाङ पत्रुसयि तुङिन राङ त्येसोङ। को भेतुइना कोल थोङदे हतिबा हा:लाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","मुइ “च्यामाना त्योए” नाइरे लाक्पि इसारा क्याइसोङ, राङ प्रभुयि हतिला च्हिरु क्याइरे झ्यालने फिला तोन्दे सो हतिबाला स्येसोङ। धि तामबे लोन याकुब राङ स्यान भाइतेबाला पिन नाइरे हति बिदा च्युङदे स्यान साला पुइ छारसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","साल्बो च्युङ छारते पत्रुसला च्हि च्युङसोङ नाइरे सिपाहितेबे उइला हलचल छेया च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","हेरोदयि खोला पाते याङ माखुसोङ, सिपाहितेबे छोए ताइरे खोला सोएयापयि ङेबा तेरयापयि टिसोङ आदेश पिन्सोङ। हेरोदते यहुदियाने कैसरियाला पुते हतिया राङ त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","हेरोद टुरोस राङ सिदोनयि मितेबा ङ्याबो लेइराङ तुका च्युङसोङ। हतिबा तुम झि च्युङदे ख्युइ तेहा लेप्सोङ, राङ क्यालबोयि कोटा नाङयि लाइ किङान बलस्त ङ्याबो कारु च्युक्ते ढियापयि चाला स्युवा क्यापसोङ। चिचालानाना हतिबे देश साइयि चाला क्यालबोयि देशला त्योएकोइ च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","तोकि क्याक्याइबि ङिनला क्यालबुइ कोहिला कोन्दे हेरोद ख्युइ ठिला त्येसोङ, राङ हतिबाला ख्युइ भाषाण पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","मितेबा “धि ता कजसुबायि क्ये ना, मितेबे माना!” नाइरे क्ये तोन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","हिन्नाङ कजसुबाला छे मातेकाति हतितुइना राङ कजसुबायि तेङलायि लोन खेरङान झिकि खोला क्यापसोङ, राङ सिसि खोलखोल भु क्यापते खो स्यिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","हिन्नाङ कजसुबायि वचन छारिन राङ फेलिन पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","बारनाबास राङ शाउल रेँ मिशन पुरा क्याइरे यरुश्लेमने लसोङ। हतिबा ङ्याबो मर्कुस नाङान युहान्ना याङ पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","एन्‍टिओखियायि चर्चला ङोन्सेखिलङान राङ छोइ लोपङानतेबा, अर्थात बारनाबास, काला नाङान शिमियोन, कुरेनीका लुकियस, प्रान्‍तीय आङकिङान हेरोद ङ्याबो छाछारा मनेन राङ शाउल होतो। ");
INSERT INTO tcn_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","हतिबे प्रभुयि आराधाना किन ताताता राङ वर्त ताताताला पवित्र आत्मायि नाइसोङ, “ङाहि चाला बारनाबास राङ शाउलला हति लाइयि चाला कुरु पोर, काङ लाइयि चाला ङाहि खेला क्ये ताताङा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","तेहि वर्त राङ मोनलाम क्यापते हतिबे ख्होए थोला रेँ लाक्पा पोरते हतिबाला बिदा पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","तेहि पवित्र आत्मायि लाम्ला चाँचाँबाति हतिबा सिलुकियाला पुइसोङ राङ हतिने डुङगाला स्योन्दे साइप्रस यहला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","सलामिसला लेप्छारते च्येला हतिबे यहुदि झोमसि खिमला कजसुबायि लोन ल टाइक्ये क्याइसोङ। हतिबाला रुवा किङान युहान्ना हतिबा ङ्याबो धु। ");
INSERT INTO tcn_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","जब हतिबा छोयि उइला होएता सा पोरो ढुल किन राङ ढुनराङ पाफोस थु क्योपसोङ, तेहि हतिया हतिबे यहुदि झि ङोन्सेखिलङान बार येशु नाङान जादुगर झिला ठेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","हति जादुगर प्रदेशयि आङकिङान सर्गियस पौलस ङ्याबो तोकिनलो। सर्गियस पौलस रिक्पा होएता मिझि हिना। ख्युइ शाउल राङ बारनाबासला क्ये ताङदे कजसुबायि वचन ङ्यानयापयि धोप्पा क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","हिन्नाङ एलुमास जादुगरयि (चिचालानाना ग्रिक क्येला हति मिनयि खुँ हति राङ ना) सर्गियस पौलस हिछे लक्ते ख्योङ च्युइ क्याइरे हतिबे सामाना क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","हिन्नाङ शाउलयि, सुला पावल याङ नेन, पवित्र आत्मायि खाँरे हतिला लाम्मा झि ल क्याइरे ताइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ख्योए दियाबलसयि पिजा, केवाकिङानयि टा, छल राङ अलयि खाँखाँबा! प्रभुयि थारका लाम योम्बो सोयाप मितोङाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ता तोइ, प्रभुयि लाक्पा ख्युइ थोला परि च्युच्युङा होतो, राङ ता ख्योए टिझि थुङिमायि होए मिथोङान च्युङदे काना होङान ना। तेहि हतितुइना राङ मुक्पा राङ मुन्नायि हतिला कापसोङ, राङ रेनयि ख्युइ लाक्पा सुङदे ठिते खेरिनतोम नाइरे हति फाला छुला ढुवाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","तेहि प्रदेशयि आङकिङानति धि च्युच्युङा थोङदे हिछे क्याइसोङ, चिचालानाना प्रभुयि छोइला हति हा:लाइदु। ");
INSERT INTO tcn_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","पावल राङ हतिबे रुवातेबा पाफोसने डुङगा छोम्मुवा स्योन्दे पामफिलियायि पाखाला क्योपसोङ, राङ युहान्नाते हतिबाने पेरे यरुश्लेमला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","हिन्नाङ हतिबा पाखाने थोन्दे पिसिदियायि एन्‍टिओखियाला लेप्सोङ, राङ ङालसुइ ङिनला यहुदि झोमसि खिमयि नाङला स्युरे त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ता ठिम राङ ङोन्सेखिलङानयि किताबयि पाठ ट छारते यहुदि झोमसि खिमयि आङकिङानतेबे ख्युइ तेहा जु नाइरे चाँसोङ, “ए भाइ बा, खि तेहा मितेबे चाला छोइयि वचन चिगा होए ना नोइ।” ");
INSERT INTO tcn_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","तेहि लाँरे पावलयि लाक्पि इसारा क्याइरे नाइसोङ, “हे इस्राएलि मि राङ कजसुबाला झिङानबा, ङ्योन” ");
INSERT INTO tcn_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","इस्राएल मितेबे कजसुबायि हुइ आके ताङबुइ मितेबाला धाम्दे मिश्रदेशला तोतितुइना हतिबाला हा:छेया सोइसोङ, राङ ख्युइ शक्तिशालि लाक्पि हतिबाला हति देशने तोन्दे ख्योसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","च्याङ मेते साला हा:लाम लो खलङि थु ख्युइ हतिबाला ताइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","तेहि ख्युइ कनान देशला मितेबे तुनला मासि सोइरे हतिबे देशयि आङ हा: स्यिपक्या ङोपच्यु थु हतिबाला पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","“धि तामयि च्येला शमुएल ङोन्सेखिलङानयि पालो थु ख्युइ न्याय किङानतेबा पिन्सोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","हति च्येला हतिबे क्यालबो लाँसोङ, राङ कजसुबायि बेन्यामिन क्युइयि किशयि पिजा शाउलला लो खलङि थु हतिबे थोला आङ कितु च्युक्तेलो। ");
INSERT INTO tcn_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ख्युइ हतिबाला टिम छारते दाउदला हतिबे क्यालबो होङयापला लाँसोङ। ख्युइ भारेला कजसुबायि साछि पिन्दे नाइसोङ, ङाहि यशैयि पिजा दाउदला ङाहि सम च्वरा मि खुँसोङ, सुइ ङा धोप्पा पोरो पुरा किङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“धि मियि होङानयि सन्तनने, ख्युइ ना क्याक्याला च्वरा, कजसुबायि इस्राएलयि चाला मुक्तिदाता झि, येशुला ख्योसोङ।\" ");
INSERT INTO tcn_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","खो होङयापले ताङला युहान्नायि इस्राएलयि मि पोरोला घ्योप्पा कियापयि बप्तिस्मायि टाइक्ये क्याक्याइबा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","युहान्नायि रेँ लाइ चोरि तुइना नानाइबा होतो, ‘खे च्हि ठानि किन, ङा सुना? ङा खो माना। हिन्नाङ ङाहि च्येला च्हि हुन, सुइ काङबायि पोउलो याङ भुइयापयि लायकयि मेता।’ ");
INSERT INTO tcn_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ए, अब्राहामयि क्यालिक्युइयि सन्तन, राङ खि नाङने कजसुबायि झिटा किङान ए भाइबा, ङि तेहा राङ हति मुक्तियि लोन चाँचाँबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","चिचालानाना यरुश्लेमला त्योएङान राङ हतिबे आङकिङानतेबे खोला ङो मास्येबा राङ पोरोयि ङालसुइ ङिनला टङान ङोन्सेखिलङानतेबे वचनतेबा हा: माकुवा राङ खोला ङेबायि आदेश पिन्दे हति वचन पुरा क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","सोएयापयि ङेबायि च्याङ खुँ माखु नाङ हतिबे खोला स्योए कोइ हुन नाइरे पिलातसला स्युवा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","राङ ख्युइ भारेला टिटिबा ताम पोरो हतिबे पुरा क्याइ छारते हतिबे खोला पालेपने पापते तुरसाला पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","हिन्नाङ कजसुबायि खोला स्यिस्यियाने सोम्बो सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","को राङ ङ्याबो गालिलने यरुश्लेम थु होङानतेबे तेहा खो लेइराङ ङिन थु थोङसोङ, राङ हतिबा थाल्ला जन्ताला ख्युइ साछि होए राङ होए। ");
INSERT INTO tcn_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“कजसुबायि ताङबुइ कानाला क्याक्याइबि हति ना क्याक्यालि लोन ल ङे खि तेहा ख्योतोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","अर्थात च्हिरु क्याइरे कजसुबायि येशुला सोम्बो सोइरे लाङदे हति ताम हु, हतिबे सन्तानयि चाला पुरा कि, च्हिरु क्याइरे भजनला टिधुइ, ‘ख्योए ङाहि पिजा ना, तिरिङयि ङिन ङाहि क्ये ख्योएला केरु च्युच्युका होए।’ ");
INSERT INTO tcn_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ख्युइ ख्रिष्टला नामयाङ मिरुलयाप क्याइरे सोम्बो सोसोइबि भारेला चाहि जु नानाइबा होतो ‘ङा खेला दाउदला पिपिनि पवित्र राङ जब याङ मिसिनयाप च्यिनलाब तेरच्याइ।’ ");
INSERT INTO tcn_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","चिचालानाना स्यान साला याङ जु नाइदु, ‘ख्युइ रेँ पवित्र मियि स्हु रुलदु झ्युङान मानाना ना।’” ");
INSERT INTO tcn_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“चिचालानाना खो रेँ पालिला कजसुबायि उदेश्य च्वरा स्यापच्यि स्युइरे स्यि छारते ख्युइ ताङबुइ मितेबा ङ्याबो दाउद कुँसोङ, राङ ख्युइ स्हु रुलदे पुइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","हिन्नाङ सुला कजसुबायि स्यिस्यियाने सोम्बो सोइसोङ ख्युइ स्हु मारुलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“हतिचाला भाइबा, ख्योएला छ्या सह, कि धि राङ मोशायि ठिमला टिटिबा मियि लाम्ला तिक्पा माप हुन नाइरे घोषाणा ख्योएला क्याक्याइबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","खे हिछे किङान पोरोयि ख्युइ लाम्ला राङ ताम पोरोने थारथोनयाप खुँखुँबा होतो, काङ थारथोनयाप मोशायि ठिमयि लाम्ला ख्युइ चाला सम्भव मेता। ");
INSERT INTO tcn_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","“हतिचाला च्याङबो क्याइरे त्योए, स्यान अर्थात ङोन्सेखिलङानयि किताबला नानाइबा धि ताम ख्युइ थोला होङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘हे ताम अल नाङानतेबा, तोइ राङ हा:लोइ तेहि मासि च्युङदे क्यु, चिचालानाना खि भेलाला ङा लाइ झि किच्याइ, धि च्वरा लाइ काङयि भारेला सुइ याङ मनङि क्यापना याङ खि जब याङ हिछे किङान मानाना।’ ");
INSERT INTO tcn_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","पावल राङ बारनाबास यहुदि झोमसि खिमने थोन्दे हुइतुइना होङानयि ङालसुइ ङिनला याङ धि तामबा स्योए नाइरे मितेबे खोला स्युवा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","मि झोम खा थोरते च्युङ छारते यहुदिबा राङ यहुदि भक्ता मानि किङान भक्तातेबा पावल राङ बारनाबास च्येला पुइसोङ, राङ हतिबे हतिबा ङ्याबो हतिबाला कजसुबायि ङिङच्येला त्योए नाइरे स्युवा क्यापसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","स्यान ङालसुइ ङिनला हा:लाम पोरो भजार कजसुबायि वचन ङ्यानयापला लक्ते लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","मियि तुमला थोङितुइना, यहुदिबा ठाधोयि खाँरे राङ पावलयि नानाइबि तामयि खण्डन क्याइसोङ, राङ ख्युइ ना च्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","हिन्नाङ पावल राङ बारनाबासयि हा:म क्याइरे नाइसोङ, “कजसुबायि वचन पोरोले ताङस्युवा ख्योएला स्योएयाप राङ कोइबा होए। ख्युइ धिला माना नाइरे राङला नामयाङ मिसिनयापयि मिजेयि झ्योदा च्युच्युङाति हु ता यहुदि मान्ते मितेबे चिना ढोङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","चिचालानाना प्रभुयि हुला धि च्वरा आदेश पिन्सोङ, ‘पृथ्‍वीयि फोइ धुन थु मुक्ति खुयापला ङाहि ख्योएला यहुदि मान्ते मितेबे चाला होए होङयापला धाधामा होए।’” ");
INSERT INTO tcn_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","जब यहुदि मान्ते मितेबे धि ताम थोइरे, हतिबा कासोङ, राङ कजसुबायि वचनयि छे तेसोङ, राङ नामयाङ मिसिनयापयि मिजेयि चाला धाधामा चोमयि हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","प्रभुयि वचन छेत्र काङ खाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","हिन्नाङ पावल राङ बारनाबासयि विरोधला यहुदिबे भक्ता राङ ङो होएता पोमुवातेबाला राङ साजामयि फिला चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","हिन्नाङ हतिबा रेँ काङबायि साबे हतिबे विरोधला स्युरे, आइकोनियनला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","लोब्टुबा किप्पो राङ पवित्र आत्मायि खाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ता आइकोनियनला हतिबा ङ्याबो यहुदि झोमसि खिमला स्युरे जु नाइरे नाइसोङ, कि यहुदिबा राङ ग्रिकतेबा मियि तुम छोम्मुवा हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","हिन्नाङ हिछे मिकिङान यहुदितेबे यहुदि मान्ते मितेबाला घो ख्यामदु च्युक्ते भाइतेबे विरोधला हतिबे सम क्युमु सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","प्रभुयि हिछेला हा:म राङ ङ्याबो नेनराङ लेइराङ भेला थु पावल राङ बारनाबास हतिया त्येसोङ। प्रभुयि हतिबे लाने हा:लाइयापयि लाइतेबा राङ होन:तोरयापयि लाइतेबा कितु च्युक्ते रेँ ङिङच्येयि वचन साछि पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","हिन्नाङ भजारयि मितेबाला पियाला छेलसोङ, राङ रेँ यहुदिबा यहला राङ रेन लोब्टुतेबा यहला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","यहुदि मान्ते मितेबा राङ यहुदि ङिकारला हतिबे आङकिङान मितेबा ङ्याबो ढिक्ते हतिबाला तुका तेरङान राङ टोउ क्यायापयि कोशिश क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","हतिबे धि ताम हा:कोसोङ, राङ लुकोनियायि भजारतेबा, लुस्त्रा, डर्बि राङ धुनयि जिल्लायि लाम्ला टोइरे पुइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","राङ हतिया हतिबा लोन ल टाइक्ये किनलो। ");
INSERT INTO tcn_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ता लुस्त्रा भजारला लाङ घुल मिङ्युइङान मिझि त्येतु। हति कितुइना राङ काङबा खोरिया हिना, राङ नामयाङ काङबि पुपुता मेता। ");
INSERT INTO tcn_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","पावलयि नानाइबा हति ङ्यानिन्दु। पावलयि हतिला ल क्याइरे ताइसोङ, राङ टायापयि हति हिछे माथोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","क्ये छेया क्याइरे नाइसोङ, “ख्युइ काङबि भरोसाला थारका ल।” तेहि हति हुइ क्याला लाँसोङ राङ ढुवाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","जब पावलयि क्याक्याइबि धि लाइ मियि तुमयि थोङदे, तेहि हतिबे लुकोनियायि क्येला क्ये छेया क्याइरे जु नाइसोङ, “लातेबा मियि धोला हुइ तेहा पापते लेप्तु।” ");
INSERT INTO tcn_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","हतिबे बारनाबासला जिउसयि ला राङ पावलला हर्मेस ला नाला छेलसोङ, चिचालानाना हतिबाते ङोधो भक्ता हिना। ");
INSERT INTO tcn_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","भजारयि धुन यहला होएते जिउसयि मोनलाम क्यासि खिमला पुजारि मुल कोतेबाला लोङतेबा राङ मिधोयि यि मालातेबा ख्योरे हतिया मितेबा ङ्याबो ढिक्ते भोल क्यायापयि पुजा किताला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","हिन्नाङ जब लोब्टुतेबा, बारनाबास राङ पावलयि धि ताम थोइरे, तेहि हतितुइना हतिबे रेँ कोहिला रालदे जु नेनराङ क्ये तोन्दे मितेबे उइला स्युरे ढुन राङ नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“मितेबे नाइसोङ, खे चिला धि च्वरा लाइ किन? ङे याङ खे च्वरा कितु ङ्योङानयि मिना, राङ खेला धि फान मेते तामतेबाने सोम्बो कजसुबा यहला ख्योङयापला लोन ल स्योकिन, काङ कजसुबायि तेङला, पृथ्‍वी, छो छोम्मुवा राङ हतिया होएता क्यु पोरो सोइरे। ");
INSERT INTO tcn_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ख्युइ ताङला पुइ छाछारि पालिला मि पोरोला राँराँसि लुलाम च्वरा ढोरु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","हचु हिन्नाङ ख्युइ राङला साछि मेताला मा ताङा, चिचालानाना ख्युइ ल क्याइरे खेला तेङलाने छ्युयि झरि राङ ढेबु छ्यायापयि ऋतु पिन्सोङ राङ खि समला ङ्योपा राङ आनन्दयि सम खाँतु च्युसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","धि तामतेबा नाइ छारते हतिबे तुका क्याइरे हतिबाला भोल क्यापते भुलयापयि पुजाने मितेबाला कासोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","हिन्नाङ यहुदि रेन एन्‍टिओखिया राङ आइकोनियनने हतिया लेप्सोङ, राङ मियि तुमतेबाला घोकोरते पावलला टोउ क्यापसोङ, राङ खो स्यि होम नाइरे भजारने फिला टुते खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","हिन्नाङ जब लोब्टुतेबा क्युइ फाला छुलोला लाँरे खो लाँसोङ, तेहि भजारयि नाङला स्युसोङ, राङ ङाटोतेला बारनाबास ङ्याबो थोन्दे डर्बिला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ख्युइ हति भजारला लोन ल टाइक्ये क्याइरे लेइराङ लोब्टु सोइसोङ, राङ हतिबा लुस्त्रा, आइकोनियन राङ एन्‍टिओखियाला लसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","लोब्टुतेबे आत्माला क्योङबो सोइरे हतिबाला हिछेला त्योएयापयि समस्यु पिन्सोङ, राङ लेइराङ तुका ङ्योङदे हु कजसुबायि राज्यला स्यु कोयिन नाइरे हतिबाला नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","जब हतिबे ख्योए चर्च पोरोला एल्डरतेबा धाम्दे, तेहि मोनलाम राङ वर्त राङ ङ्याबो हतिबा खोरे हिछे क्याक्याइबि प्रभुयि जिम्माला हतिबाला टोएसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","हति च्येला हतिबा पिसिदियायि लाम्ला पामफिलियाला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","पाखाला वचन टाइक्ये क्याइ छारते हतिबा अटालियाला पुपसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","तेहि हतिने हतिबा छो छोम्मुवायि ढुल क्याइरे एन्‍टिओखियाला पुइसोङ, काँहा हतिबे पुरा क्याक्याइबि लाइयि चाला कजसुबायि ङिङच्येला हतिबाला पुपुला होतो। ");
INSERT INTO tcn_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","जब हतिबा एन्‍टिओखियला लेप्ते, तेहि चर्चला झोम्दे, तेहि कजसुबा ङ्याबो क्याक्याइबि लाइ पोरोयि मनङि क्यापसोङ, राङ च्हिरु क्याइरे ख्युइ यहुदि मान्ते मितेबे चाला हिछेयि को पेपिया थोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","हतिबा हतिया लोब्टुतेबा ङ्याबो लेइराङ त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ता मि रेनयि यहुदियाने एन्‍टिओखियाला लेप्ते भाइबाला धि च्वरा छोइ तेराला छेलसोङ, “खे मोशायि लुलाम च्वरा खतना माच्युङना ता खोला थारथोनयाप खुङान मानाना।” ");
INSERT INTO tcn_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","तेहि पावल राङ बारनाबास हतिबा ङ्याबो भेद भाब राङ नारे क्याइ छारते च्येला, हतिबे भाइबे पावल राङ बारनाबासला राङ स्यान चोमला धि टिवायि थाकच्योएयि चाला लोब्टुतेबा राङ एल्डरतेबे तेहा यरुश्लेमला ढोयापला धामसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","चर्चयि स्दस्यतेबा हतिबाला हतिने बिदा पिन्सोङ। हतिबा फोनिके राङ सामरियायि लाम्ला यहुदि मान्ते मितेबे प्रभुला ग्रहण क्याइ छारते ताम हतिबाला सविस्तार क्याइरे स्येसोङ। हति लोन यि हतिबे भाइतेबा लेइराङ किप्पो च्युङदु। ");
INSERT INTO tcn_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","जब हतिबा यरुश्लेमला लेप्ते, तेहि हति हतिबाला चर्च, लोब्टु राङ एल्डरतेबे स्वागत क्याइसोङ। कजसुबायि हतिबा ङ्याबो क्याक्याइबि ताम पोरो रिपोट हतिबे हतिया पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","तेहि फरिसियि तुमयि नाङने हिछे किङान चोम राङयि लाँरे नाइसोङ, “यहुदि मान्ते खतना होङयाप राङ हतिबाला मोशायि ठिम पालाना कितु आदेश तेरकोइ हुन।” ");
INSERT INTO tcn_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","धि भारेला सोच विचार कियापला लोब्टुतेबा राङ एल्डरतेबा झोमसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","लेइराङ नारे क्याइ छारते पत्रुस लँरे हतिबाला नाइसोङ, “भाइबा, ख्योएला छ्या राङ होतो माने ताङस्युवा ङिनतेबाला च्हिरु क्याइरे कजसुबायि ङाहि खाने यहुदि मान्ते मितेबे लोन लयि वचन ङ्यानोङ राङ हिछे क्यायोङ नाइरे खि उइने ङाला धामसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","समयि ताम हा:कोङान कजसुबायि खेला याङ ङेला च्वरा पवित्र आत्मा पिन्दे हतिबाला ग्रहण क्याक्याइबि ताम तानसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ख्युइ हतिबा राङ हुइ उइला च्याङ भेदभाब मा पोरसोङ, हिन्नाङ हतिबे सम हिछेयि लाम्ला चाङमा सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","हतिचाला लोब्टुतेबे ठाला धि ङेरस्यिङ पोरते चिला कजसुबाला छोए तेन? धि ङेरस्यिङ न हुइ ताङबुइ काने न हुइ खुर ङ्युइकिन। ");
INSERT INTO tcn_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","हिन्नाङ हिछे किन, कि प्रभु येशुयि ङिङच्येने हुला थारथोनयाप खुँखुँबा होतो, च्हिरु क्याइरे हतिबाला लाङ खुँखुँबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","तेहि यहुदि झोमसाला पोरो राङ च्यामाना त्येसोङ, तेहि यहुदि मान्ते मितेबे उइला कजसुबायि ख्युइ लाम्ला च्हिरु हा:लाइयापयि लाइतेबा राङ होन:तोरयापयि लाइतेबा क्यासुइ हति मनङि बारनाबास राङ पावलयि क्याइसोङ। हतिबे धि मनङि क्याक्याइबा थोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","हतिबे ताम नाइछारते याकुबयि जु नाइसोङ, “भाइबा, ङाहि ताम ङ्योन, ");
INSERT INTO tcn_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","कजसुबायि रेँ मिनयि चाला यहुदि मान्ते मितेबे चाने मितेबे झि धामयापयि ङिङच्ये कि नाङानयि ताम सिमोनयि स्यास्याता होतो। ");
INSERT INTO tcn_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","धि ताम ङ्याबो ङोन्सेखिलङानयि वचन याङ खुकिन, च्हिरु टिधुइ, ");
INSERT INTO tcn_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘धि तामबे च्येला ङा लकच्याइ, राङ दाउदयि तितिबि त्योएसा याङ सोज्याइ, हति तिप छाछारा याङ ङा सोज्याइ, राङ ङा हतिला लोङज्याइ, ");
INSERT INTO tcn_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","राङ लाँमा मितेबे कजसुबाला प्येयोङ, राङ यहुदि मान्ते मि पोरोयि याङ, काङतेबा ङाहि मिनयि लाम्ला क्ये ताताङा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","धि ताम कजसुबा नेन्दु, सुइ ताङबुइ भेलाने राङ धि ताम हा:कोकुवा होतो, काङते सोयापले ताङलाने राङ स्येस्येबा होतो।’ ");
INSERT INTO tcn_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“हतिचाला ङाहि थाकच्योए धि होतो, कि कजसुबा यहला लक्ते होङान यहुदि मान्ते मितेबाला तुका मातेर, ");
INSERT INTO tcn_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","हिन्नाङ हतिबाला धि तामतेबा टि, कि हतिबा कुला पुजा कियापयि भाभातेबाने कुरुला त्योए, पातारने, झ्यिङबा च्युइरे सासाति तुढोतेबे स्या राङ ठाने कुरुला त्योए। ");
INSERT INTO tcn_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","चिचालानाना ताङमे पुस्ताने राङ भजारयि क्यापला मोशायि ठिमयि टाइक्ये हुन राङ धु, चिचालानाना धि यहुदि झोमसि खिमला ङालसुइ ङिन पोरोला टकिन राङ धु।” ");
INSERT INTO tcn_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","तेहि लोब्टुतेबा, एल्डरतेबा राङ चर्च पोरो ढिक्ते रेँ उइने मि चोमला राङ धाम्दे पावल राङ बारनाबास ङ्याबो एन्‍टिओखियाला चोङयाप ल ठानि क्याइसोङ, राङ भाइतेबे नाङने ङोधो मितेबा, यहुदा नाङान बारनाबास राङ सिलासला धामसोङ ");
INSERT INTO tcn_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","राङ खो ङ्याबो हतिबे धि पत्र चाँसोङ “एन्‍टिओखिया, सिरिया राङ किलिकियाला त्योएङान यहुदि मान्ते मितेबे हिछे किङान भाइतेबाला, लोब्टुतेबा राङ एल्डरतेबे नामास्ते।” ");
INSERT INTO tcn_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ङि थोथोइबा होतो, कि हुइ उइयि रेनरेन हुइ आदेश मेताला राङ खि सम थारका मेता च्युङदे खेला लेइराङ तामयि तुका पिपिना होतो। ");
INSERT INTO tcn_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","हतिचाला हु पोरोयि सहमतियि लाम्ला क्याक्याइबि थाकच्योए च्वरा क्याइरे मि छोमला राङ धाम्दे खेला ङि करि बारनाबास राङ पावल ङ्याबो खि तेहा चोङयापला ङेला ल स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","धि मितेबा धि च्वरा ना, काङति हुइ प्रभु येशु ख्रिष्टयि चाला रेँ उ भेन पोपोरा धु। ");
INSERT INTO tcn_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","हतिचाला ङि यहुदा राङ सिलासला चाँचाँबा होतो। हतिबे याङ ताम थारकातेबा स्योएङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","चिचालानाना पवित्र आत्मा राङ ङेला धि ल स्येसोङ, कि धि कोइबि लाइतेबा अर्थात स्यान लेइराङ बोझ खेला घेलयाप मिहा। ");
INSERT INTO tcn_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","“खि कुतेबाला भोल क्याक्याबि क्यु, ठा, झिङबा च्युइरे सासाता तुढोयि स्या राङ पातार ने कुरुला त्योए। धि तामतेबाने कुरु त्योए नाङान ल होङान ना। बिदा।” ");
INSERT INTO tcn_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","बिदा च्युङ छारते हतिबा एन्‍टिओखियाला लेप्सोङ, राङ समाजला च्हि झोम्दे धि च्वरा पत्र पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","पत्रला होएता छोइयि तामतेबा टरे हतिबा कासोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","यहुदा राङ सिलास खोराङ याङ ङोन्सेखिलङान हिनाति भाइतेबाला लेइराङ वचनयि लाम्ला छोइ पिन्दे हतिबाला क्योङबो सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","हतिबे आरोङ भेला हतिया बिताइ क्याइ छारते, हतिबे भाइतेबे हतिबाला चोँङानतेबे तेहा ल सह नाइरे बिदा पिन्दे चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","हिन्नाङ सिलासला हतिया राङ त्योएयाप ल स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","पावल राङ बारनाबासते छोइ लोबिन राङ प्रभुयि वचन टाइक्ये किन राङ स्यान लेइराङ ङ्याबो एन्‍टिओखियाला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ङिन रेन च्येला पावलयि बारनाबासला नाइसोङ, “सह, काङकाङ भजारला ङि प्रभुयि वचन टाइक्ये क्याइरे हति भजारतेबाला लक्ते पुते भाइतेबाला ठाता राङ हतिबा च्हिरु धुइ ता।” ");
INSERT INTO tcn_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","बारनाबासयि मर्कुस नाङान युहान्नाला हतिबा ङ्याबो खेरयापयि धोप्पा क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","हिन्नाङ पावलयि मर्कुसला ङ्याबो खेरयाप ल मास्येसोङ, चिचालानाना खो पामफिलियाने हतिबा ङ्याबो पेरे पुइतु, राङ हतिबा ङ्याबो लाइला पुपुता मिधु। ");
INSERT INTO tcn_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","हतिबे उइला झोम छेया भेदभाब च्युङसोङ कि हतिबा खोरे नाङला पेसोङ, राङ बारनाबास मर्कुसला ङ्याबो साइप्रस यहला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","हिन्नाङ पावलयि सिलासला धामसोङ, तेहि भाइतेबाने कजसुबायि ङिङच्येला पुलदे बिदा च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","चर्चला क्योङबो सुन राङ हति सिरिया राङ किलिकियायि ढुल क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","पावल डर्बि राङ लुस्त्राला याङ लेप्सोङ। हतिया तिमोथि मिन क्याक्याइबि लोब्टु झि याङ धु। खो हिछे किङान यहुदि पुमो झिकि पिजा हिना। हिन्नाङ ख्युइ आके ग्रिकयि हिना। ");
INSERT INTO tcn_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","लुस्त्रा राङ आइकोनियनयि भाइतेबाला ख्युइ मिन चलि च्युच्युङा धु। ");
INSERT INTO tcn_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","खोला पावलयि ङ्याबो खेरयापयि सम क्याइसोङ। हति साला त्योएङान यहुदिबे चाला पावलयि खोला खेरते खतना क्याइसोङ। चिचालानाना ख्युइ आके ग्रिक हिना नाङान हतिबा पोरोला छ्या होतो। ");
INSERT INTO tcn_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","तेहि हतिबा भजारयि लामतेबे लाम्ला हतिबे यरुश्लेमयि लोब्टुतेबा राङ एल्डरतेबे क्याक्याइबि थाकच्योएतेबा हतिबाला ङ्यानरो कि नाइरे स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","हति च्वरा क्याइरे चर्च हिछेला क्योङबो हुन राङ टाँगाला फेलकिन राङ पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","पवित्र आत्माने एशियाला वचन टाइक्ये कियाप मेता ति हतिबा फ्रिगिया राङ गलातियायि छेत्रतेबे लाम्ला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","माइसियायि साँधला लेप्छारते हतिबे बिथानिया यहला ढोयापयि विचार क्याइसोङ। हिन्नाङ येशुयि आत्मायि हतिबाला ढोरु माच्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","तेहि माइसियायि लाम्ला हतिबा त्रोआसला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","छाम्मु पावलला दर्शन च्युङसोङ माकेडोनियायि मि झि लँरे खोला स्युवा क्याकिन राङ धु। “माकेडोनिया सअ, राङ ङेला रुवा कि।” ");
INSERT INTO tcn_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","जब खोला धि दर्शन खुँरे, हतितुइनाराङ माकेडोनियाला ढोयाप तयार च्युङसोङ। ङि धि थाकच्योए क्याइरे कि ख्योएला लोन ल टाइक्ये कितु कजसुबायि हुला क्ये ताताङा धु। ");
INSERT INTO tcn_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","तेहि हु त्रोआसने डुङगाला स्योन्दे थारका सामोथ्राके यहला पुइसोङ, राङ ङाइटोतेबा नियापोलिस लेप्छारसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","राङ हतिने फिलिप्पिला लेप्छारसोङ, काङते माकेडोनियायि ङोधो भजार राङ रोमि सा याङ धु। हु धि भजारला ङिन रेन ताते। ");
INSERT INTO tcn_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ता ङालसुइ ङिनला भजारयि कोने फिला चाङबोयि नेमुला पुइसोङ, चिचालानाना हतिया मोनलाम क्यासि सा होतो नाइरे ङि छोए क्याक्याइबा होतो, राङ हतिया ङे ताते राङ झोम्दे ताताति पुमोतेबा ङ्याबो ताम नाला छेलदे। ");
INSERT INTO tcn_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","तेहि थिआटिरा भजारला त्योएङान, बैजनी कोहिलायि छोङ क्याङान लिडिया मिन क्याक्याइबि कजसुबायि भक्ता पुमोति ङि ताम ङ्यानसोङ। पावलयि नानाइबि ताम ल क्याइरे ङ्योन नाइरे प्रभुयि ख्युइ सम पेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","जब खो राङ ख्युइ खिमयि पोरोयि बप्तिस्मा च्युङदे, तेहि ख्युइ ङेला स्युवा क्यापसोङ, “तेम्बारे ख्युइ ङाला प्रभुयि हिछे किङान ठानि कि ना ङाहि खिमला लेप्ते त्योए।” राङ ख्युइ ङेला कर माक्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","जब ङे मोनलाम क्यायापयि खिमला ढुन ताताता होतो, तेहि लाक्पा ताङान आत्मा होएता यक्मुवा पुमो झि ङ्याबो ङे ठेसोङ, काङ हति लाक्पा ताइरे हति ताक्पोतेबे चाला लेइराङ कमाइ किनलो। ");
INSERT INTO tcn_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","हति पावल राङ ङि च्येच्येला लेप्सोङ, राङ जु नेन राङ क्ये तोनसोङ, “धि मितेबा पोरोले छेया कजसुबायि स्यापच्यितेबा ना। हतिबे खेला मुक्तियि लामयि घोषाणा किन।” ");
INSERT INTO tcn_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","हति लेइराङ ङिन थु हति च्वरा राङ क्याइसोङ। तेहि पावलयि छेरते फरक्याला लक्ते हति ढेला नाइसोङ, “येशु ख्रिष्टयि मिनला ख्योएला ङा हति मिने थोनयापयि आदेश तेरच्याइ।” तेहि हति ढेते हति भेलाला राङ हतिने थोन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","हिन्नाङ हति ताक्पोतेबे हतिबे कमाइयि आशा माच्युङा थोङा राङ पावल राङ सिलासला सुङदे भजारयि चोकला आङकिङानतेबे तेहा ढुकिन राङ खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","तेहि हतिबाला भजारयि हाकिमतेबे तेहा ख्योरे नाइसोङ, “धि मितेबा यहुदि ना, धि मितेबे ङि भजारला घलघल क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","धिबे धि च्वरा धि च्वरा लुलाम लोबिन्दु काङते हु रोमिला ग्रहण कियाप वा पालाना कियाप न्याय कियाप लायकयि माच्युङसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","तेहि मियि तुमतेबा ढिक्ते ख्युइ थोला लक्ते छेलतु लेप्सोङ। भजारयि हाकिमतेबे टिम्सोङ, राङ कोहिला रालदे टिम्सोङ, राङ हतिबाला पेरका क्यायापयि आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","हतिबे खोला लेइराङ पेरका क्याप छारते च्येला हतिबाला झ्याल्ला च्युसोङ, राङ झ्याल्ला च्युसोङ, राङ ज्यालयि हाकिमला धि झ्यालयि हाकिमला कैदिबाला कडा मिता क्यापते भोरयाप आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","धि च्वरा आदेश खुरे ख्युइ हतिबाला झ्यालयि नाङयि भागला हतिबे काङबाला ठिँगुरो क्यापते पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","हिन्नाङ छान फेना माला पावल राङ सिलास मोनलाम क्याकिन राङ कजसुबायि भजन लेनिन ताताता धु, राङ कैदितेबे सो ङ्यानिन त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","तेहि हो:प्तामेला साघुल छेया झि पुइसोङ, राङ झ्यालयि झतेबा घुलसोङ, राङ कोतेबा पोरो पेसोङ, राङ पोरोयि तातामातेबा पोरो पेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","झ्यालयि हाकिम मिलामने ङिसेसोङ राङ कोतेबा पेपिया थोङदे कैदितेबा पोरो टोइ छारते नोइबा च्युङदे ख्युइ रेँ राङला सो च्याइ नाइरे विचारयि रेँ तोरबालि तोनसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","हिन्नाङ पावलयि क्ये छेयायि जु नेन राङ क्ये तोनसोङ, “ख्युइ ख्योए राङला च्याङ नोक्सानि माके, चिचालानाना ङे पोरो ङिहा राङ होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","तेहि बत्ति लाँरे खो फारिन राङ नाङला लेप्सोङ, राङ झिटायि धारिन पावल राङ सिलासयि धुनला ताङला खोल्बु क्यापते त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","हतिबाला फिला ख्योरे ख्युइ नाइसोङ, “गुरुज्यु, थारथोनयापला ङाहि च्हि कि कोयिन?” ");
INSERT INTO tcn_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","तेहि हतिबे नाइसोङ, “प्रभु येशु ख्रिष्टयि हिछे कि, राङ ख्योएला थारथोनयाप ना ख्योए राङ ख्युइ प्येरा।” ");
INSERT INTO tcn_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","हतिबे खोला राङ ख्युइ खिमला होएता पोरोला प्रभुयि वचन स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","तेहि छाम्मुयि हति भेलाला राङ हतिबे खोला खेरते मा टुइसोङ। तेहि मो राङ मुइ प्येरायि हतितुइनाराङ बप्तिस्मा खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","हति च्येला हतिबाला खेरते हतिबे धुनला ङ्योपा खेरसोङ, राङ कजसुबाला हिछे क्याइसोङ नाङानयि ताम ख्युइ प्येरा पोरो ङ्याबो खो लेइराङ अन्नद च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","हिन्नाङ साल्बो च्युङ छारते भजारयि हाकिमतेबा सिपाहितेबाला धि आदेश पिन्दे नाइसोङ, “हति मिबाला तोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","तेहि झ्यालयि हाकिमयि पावलयि धि तामतेबा स्येसोङ, “भजारयि हाकिमतेबे खेला तोङयापयि आदेश पिन्सोङ। हतिचाला ता थोन्दे शान्ति ङ्याबो ढो।” ");
INSERT INTO tcn_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","हिन्नाङ पावलयि हतिबाला नाइसोङ, “हु रोमि मितेबाला घोलो राङ मासोइबा हतिबे मितेबे धुनला क्यापसोङ, राङ झ्यालला याङ च्युसोङ, राङ ता ङेला फा:ला धोनिन्दु? धि हुवा मिधु। हतिबा सह राङ ङेला तोन्दे खेर।” ");
INSERT INTO tcn_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","हति सिपाहिबे हाकिमतेबाला धि तामतेबा स्येसोङ। हतिबाता रोमियि मि हिना नाङान थोइरे हतिबा झिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","हतिबा लेप्ते हतिबा ङ्याबो माप ल्हँ, राङ हतिबाला फिला खेरसोङ राङ भजार ताङदे ढोयापयि स्युवा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","हतिबा झ्यालने फिला थोन्दे ढुइतुइना लिडियायि खिमला पुइसोङ, राङ भाइतेबा ङ्याबो ठे छारते च्येला हतिबाला समस्यु पिन्दे बिदा च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","पावल राङ सिलास अम्‍फिपोलिस राङ अपोल्‍लोनियायि लाम हुन राङ थेसलोनिकेला लेप्सोङ। हतिया यहुदितेबे यहुदि झोमसि खिम झि धु। ");
INSERT INTO tcn_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","पावल रेँ बानि च्वरा क्याइरे हतिबे तेहा नाङला पुइसोङ, राङ ङालसुइ ङिन सुम थु पवित्रशास्त्रने हतिबा ङ्याबो नारे किन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","“ख्रिष्टला अवश्य तुका ङ्योङयाप राङ स्यिस्यियाने सोम्बो होङकोइ हुन, राङ धि राङ येशु, सुइ लोन ल ङा ख्योएला स्योच्याइ, खो राङ ख्रिष्ट ना” नाङान तामयि खुँ पेरे ख्युइ प्रमाण क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","हतिबे नाङने चोम राङ हिछे क्याइरे पावल राङ सिलास यहला खेरसोङ। लेइराङ टाँगाला कजसयुबायि भक्ता ग्रिकबा राङ लेइराङ ङोधो पुमोतेबा याङ खेखेरा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","हिन्नाङ ठाधोयि खाँरे यहुदिबे भजारयि अल च्योप्पा किङान मितेबाला रुरे तुम राङ खेरते भजारला ठुझि किताला छेलसोङ, तेहि यासोनयि खिमला ठुझि क्याइरे पावल राङ सिलासला जनतातेबे धुनला ख्योङ च्युइ पेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","हतिबा मा खुँबाला छेलाराङ, हतिबे योसेन राङ भाइबा रेन रेनला भाइतेबाला भजारयि आङकिङानतेबे तेहा जु नेन राङ ढुकिन राङ ख्योसोङ, “संसारला उलटो फुलटो सुन राङ हति मिबा ङिहा याङ लेप छाछारा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","हतिबा यासोनयि ढोम्बो च्युच्युङा होतो, राङ हतिबा पोरोयि येशु नाङान मिझि स्यान क्यालबो झि होतो नाइरे कैसरयि आदेश विरोध लाइकिन।” ");
INSERT INTO tcn_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","धि तामबा थोइरे मितेबा राङ भजारयि आङ किङानतेबा आत्ति च्युङदु। ");
INSERT INTO tcn_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","हतिबे योसेन राङ हतिबा ङ्याबो होएता लाँमा मितेबाला धरौटी खेरते हतिबाला ताङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","भाइबे हतितुइना राङ पावल राङ सिलासला छाम्मु राङ बेरियाला चाँसोङ, तेहि जब हतिबा हतिया क्योपसोङ तेहि हतिबा यहुदियि यहुदि झोमसि खिमयि नाङला स्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","धिबे यहुदिबा थेसलोनिकेयि नाङने माहा ल धु चिचालानाना हतिबे पुरा केन राङ ग्रहण क्याइसोङ, राङ हति तामतेबा थारे हचु राङ हिना कि माना नाइरे बारतै पवित्रशास्त्रा फाकिनलो। ");
INSERT INTO tcn_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","हतिचाला हतिबे नाङने लेइराङयि, छुक्पो खिम ग्रिक पुमोतेबा राङ पिजातेबे याङ हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","हिन्नाङ जब कजसुबायि वचन पावलयि लाम्ला बेरिया याङ टाइक्ये च्युङ छाछारा धु नाङान थेसलोनिकेयि यहुदि हा:कोसोङ, तेहि हतिबा हतिया याङ मियि तुमतेबाला धेयाप राङ हाम क्येरु झ्युयाप लेप छारतु। ");
INSERT INTO tcn_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","तेहि भाइतेबे हतितुइना राङ पावलला छो छोम्मुवा यहला चाँसोङ। हिन्नाङ सिलास राङ तिमोथिते हतिया राङ त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","पावलला केलदु ढोङानतेबे हतिला एथेन्स थु ख्योसोङ, सिलासला राङ तिमोथिते चोम ङ्युइ घ्यबो हतिया होङ कोयिन नाङान आदेश खुँरे हतिबा लसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","पावलयि हतिबाला एथेन्सला कुकितुइना, हति भजारला कुयि पिजायि खाँखाँबा थोङदे हति आत्मा खुरि नाङला समतु च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","हतिचाला ख्युइ यहुदिबाला राङ कजसुबायि भक्ता मितेबाला यहुदि झोमसि खिमतेबाला, राङ ठाठातातेबा ङ्याबो बारतै भजारला नारे किनलो। ");
INSERT INTO tcn_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","इपिक्‍युरी राङ स्‍तोइकी दार्शनियतेबे नाङने चोमयि राङ हतिबाला याङ हतिबा ङ्याबो नाइरे क्याइसोङ। हतिबे नाङने चोमयि राङ नाइसोङ, “च्हि बकबक चिनाने?” स्यानतेबे नाइसोङ, “स्यान सु याङ फियि मि लातेबे टाइक्ये किङान च्वरा थोङिन धुये।” चिचालानाना ख्युइ येशु राङ स्यिस्यियातेबाने सोम्बो होङयापयि ताम नेन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","तेहि हतिबे खोला अरियोपागसला खेरसोङ राङ नाइसोङ, “ख्युइ पिपिनि धि सारबा छोइ चिना, च्हि ङेला हा:कोरु झ्यु ङ्युइकिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","“चिचालानाना ख्योए ङि नामज्योला अनौठा तामतेबा स्योकिन्दु। हतिचाला धि तामबे खुँ चिना सो ङे हा:कोसोम होए।” ");
INSERT INTO tcn_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","पोरो एथेन्सला त्योएङान मि राङ हतिया त्योएङान फियि मितेबा घलघल ताम नायाप वा ङ्यानयाप अर्थात रेँ समय स्यान च्याङ तामला बित मिकिता। ");
INSERT INTO tcn_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","पावल अरियोपागसयि उइला लाँरे नाइसोङ, “एथेन्सला त्योएङन मितेबा, ख्योएला ङा ताम पोरोला, धर्मला लेइराङ आसता होएता थोङिन्दु,” ");
INSERT INTO tcn_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","चिचालानाना युकिन ढुइतुइना ख्युइ सोलङान क्युतेबा ङाहि थोङसोङ। ङाहि धि च्वरा वेदि याङ ठेसोङ काङला “ङोमिस्येङान लायि चाला नाङान कोए क्याइदु। हतिचाला सुला खे हा:माकुवा सोलिन्दु खोला ङा खि उइला घोषाणा किच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24",":कजसुबा, सुइ संसारला राङ हतिला होएता क्यु पोरो सोइरे, खो तेङला राङ पृथ्‍वीयि प्रभु च्युच्युङाति लाक्पि सोसोइबि मोनलाम क्यासि खिमला मितोता, ");
INSERT INTO tcn_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","खोला चिगे कोइबा होएता च्वरा क्याइरे मितेबे लाने ख्युइ स्यापच्यि स्यु कोइ हुन नाइरे सोचि माके। चिचालानाना ख्युइ राङ पोरोला मिजे, उ राङ क्यु पोरो तेरिन। ");
INSERT INTO tcn_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ख्युइ मिझिने पृथ्‍वी पोरोला त्योएसा पोरो सोइसोङ। हतिबा त्योएसि मितेबे पोरो सोइसोङ। हतिबा त्योएसि मियि टाँगा राङ साजाम याङ थाकच्योए क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","हतिबे कजसुबाला फोए, हा:लाम हतिबे समेसमे क्याप्ते खोला ठाकिन तोम नाइबा आश क्याइरे धि च्वरा क्याइसोङ। हिन्नाङ खो हु पोरोने घ्याबोला मेता। ");
INSERT INTO tcn_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","चिचालानाना “हु खोला सोम्बो तोकि, राङ खोला किप्पो किन राङ ख्युइ तेहा हुइ अस्‍तित्‍व होतो। ख्योए ख्युरि कवितातेबा याङ नानाइबा होतो, ‘हु तेम्बारे ख्युइ सन्तन ना।’” ");
INSERT INTO tcn_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“तेहि हु कजसुबायि सन्तन च्युच्युङाति, कजसुबा सेर ङुल वा टोउ हिना नाइबा किच्याइ माना ना हतिबा मितेबे कला राङ कल्पनायि धो मात्रा ना। ");
INSERT INTO tcn_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","धि च्वरा छ्यामेते भेलाला कजसुबायि ध्यान मापिनसोङ, हिन्नाङ सा पोरोला मि पोरोला घ्योप्पा कियापयि आदेश तेरिन। ");
INSERT INTO tcn_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","चिचालानाना ख्युइ ङिन झि थाकच्योए क्याक्याइबा होतो, काङ ङिनला ख्युइ रेँ धाधामायि मिझिकि लाम्ला संसारयि इनसाफ किङान ना। खोला स्यिस्यियाने सोम्बो सोइरे ख्युइ मि पोरोला धि प्रमाण मापिनसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","जब हतिबे स्यिस्यियाने सोम्बो होङयापयि भारेला थोइरे, तेहि रेन रेनयि ना च्येसोङ। हिन्नाङ स्यानतेबे “ङे याङ धि भारेला ख्युइ ताम ङ्यानज्याइ” नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","हति च्येला पावल हतिबे उइने पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","हिन्नाङ मि रेनतेबा ङ्याबो खेरसोङ, तेहि हिछे क्याइसोङ। हतिबे नाङने अरियोपागसयि डियनुसियस, दामारिस मिन क्याक्याइबि पोमो, राङ स्यानतेबा याङ होतो। ");
INSERT INTO tcn_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","हति च्येला हतिबा एथेन्सने बिदा च्युङदे कोरिन्थिला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ख्युइ पेन्टसला त्योएङान अकिलास मिन क्याक्याइबि यहुदि झिला ठेसोङ। हति रेँ केरमान प्रिस्किला ङ्याबो इटालियाने लेलेबा धु, चिचालानाना क्यालबो क्‍लौडियसयि यहुदिबा पोरोला रोमने थोन्दे ढोयापयि आदेश पिन्सोङ। पावल हतिबाला ठातु पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","आलाइ झि होतोति खो हतिबा ङ्याबो राङ त्येसोङ, राङ लाइ क्याइसोङ। चिचालानाना हतिबे लाइ कुरसोङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ङालसुइ ङिन पोरोला खो हति यहुदि झोमसि खिमला नारे किनलो, राङ यहुदितेबा ग्रिकबाला खाइकोए झ्युयापयि कोशिश किनलो। ");
INSERT INTO tcn_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","जब सिलास राङ तिमोथि माकेडोनियाने क्योप छारते, पावल वचन टाइक्ये कियापला व्यस्था धु, राङ यहुदिबाला येशु राङ ख्रिष्ट हिना नाइरे हतिबाला छोइ तेरिन राङ धु। ");
INSERT INTO tcn_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","“हिन्नाङ जब हतिबे विरोध क्याइरे हतिबाला फा:ला ताम अल नाला छेलसोङ, तेहि ख्युइ रेँ कोहिला स्युरे हतिबाला नाइसोङ” “खि ठा खि थोला राङ फोवार सअ, ङा निर्दोष होतो। ता ङा याङ यहुदि मान्ते मितेबे थोला ढोज्याइ।” ");
INSERT INTO tcn_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","तेहि हतिबाने हतिने कजसुबायि भक्ति किङान तितस युस्तस मिन क्याक्याइबि मिति खिमला पुइसोङ। ख्युइ खिम यहुदि झोमसि खिमयि धुनला राङ धु। ");
INSERT INTO tcn_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","यहुदि झोमसि खिमयि आङकिङान क्रिस्पसयि प्येरा पोरो प्रभुला हिछे किन, राङ कोरिन्थितेबे नाङने लेइराङयि पावलयि वचन ङ्यान्दे हिछे क्याइसोङ, राङ बप्तिस्मा खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","छान झि प्रभुयि दर्शनला पावलला नाइसोङ। माझि, हिन्नाङ ताम नेन राङ कि राङ हिम्मत हारि माके। ");
INSERT INTO tcn_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","“माझि, हिन्नाङ ता नेनराङ क्यु, राङ च्यामाना मात्योए, चिचालानाना ङा ख्योए ङ्याबो होतो, राङ सुइ याङ ख्योएला क्याइरे ताङदे नोए केल मिङ्युइबा, चिचालानाना धि भजारला ङाहि मि लेइराङ होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","तेहि कजसुबायि वचन लोपकिन राङ पावल लो झि राङ धा टु थु हतिबा ङ्याबो त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","जब गलियोन अखैया आङकिङान च्युङदे, तेहि यहुदि बा मत चिकि च्युङदे पावलला ठुझि क्याइसोङ, राङ खोला अदालतला ख्योसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","राङ नाइसोङ, “धि मियि मोशायि ठिमयि विरोधला कजसुबायि आराधाना कियाप मितेबाला लोबिन्दु।” ");
INSERT INTO tcn_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","जब पावल नाला छेलसोङ, तेहि गलियोनयि हति यहुदितेबाला नाइसोङ, “यहुदिबा, तेम्बारे राङ धि अन्य राङ वा अल तामयि घलयि ताम हिननाता ङा खि ताम ङ्यानयाप ल मिहा। ");
INSERT INTO tcn_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","हिन्नाङ छितेबा, मिनतेबा राङ खे खिरि ठिमयि शवाल च्युच्युङाति खे खेराङ विचार कि। ङा धि तामबे ल अल भेयाप इनकार किच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","तेहि ख्युइ हतिबाला अदालतने तेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","तेहि हतिबा पोरोयि यहुदि झोमसि खिमयि आङकिङान सोस्थेनेसला सुङदे अदालतयि धुनला क्यापसोङ। हिन्नाङ गलियोनयि हति तामयि च्याङ वास्ता मापोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","तेहि हति च्येला पावल ङिन लेइराङ थु कोरोन्थिला त्येसोङ। तेहि भाइतेबाने बिदा च्युङदे खो डुङगाला स्योन्दे सिरियाला पुइसोङ। खो ङ्याबो प्रिस्‍किला राङ अकिलास याङ धु। ख्युइ वाचा झिला ख्युइ क्रियाक्रमला रेँ स्येबु टाकुलिया सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","हतिबा एफिससला क्योपसोङ, तेहि पावलयि हतिबाला हतिया राङ ताङसोङ, राङ खो राङ यहुदि झोमसि खिमला स्युरे यहुदिबा ङ्याबो नारे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","तेहि हतिबे खोला ङिन रेन त्योएयापयि स्युवा क्याकितुइना ख्युइ इनकार क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","हतिबाने बिदा हुइतुइना ख्युइ नाइसोङ, “कजसुबायि सम होएना याङ ङा खि तेहा लक्ते होङज्याइ।” तेहि हतिबा डुङगाला स्योन्दे एफिससने पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","जब हतिबा कैसरियाला पुपते तेहि याला झिरे चर्चला ठाते नामास्ते क्याइरे एन्टिओखिया यहला पुपसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ख्युइ हतिया ङिन रेन बिताइ क्याइरे गलातिया राङ फ्रिगियायि छेत्रतेबे लाम्ला लोब्टुबा पोरोला सम स्यु तेरिन राङ कुरुकुरु साला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","अलेक्‍जेन्ड्रियाला त्योएङान अपोल्‍लोस मिन क्याक्याइबि यहुदि एफिससला लेप्सोङ। हति कुशल भाषाण किङान झि राङ पवित्रशास्त्राला छोइ होएता झि ना। ");
INSERT INTO tcn_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","खोला प्रभुयि छोइयि लाम खुदु, राङ आत्माला सम स्यु फारते ख्युइ येशुयि भारेला तामतेबा थारकाथारका नायाप राङ लोबिन्दु। हिन्नाङ ख्युइ युहान्नायि बप्तिस्मा मात्र स्येस्येबा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ख्युइ यहुदि झोमसि खिमतेबाला हा:छेया किङगा ताम नाला छेलसोङ। हिन्नाङ ख्युइ नानाइबि तामतेबा थोइरे प्रिस्किला राङ अकिलासला ख्युइ रेँ खिमला ख्योसोङ, राङ कजसुबायि लामयि तोन चाङमा क्याइरे लाप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ख्युइ अखैयाला ढोसोम किता राङ भाइतेबे खोला हतिया ढोयापयि समस्यु पिन्सोङ, राङ खोला ग्रहण क्यायोङ नाइरे हति लोब्टुतेबाला समस्यु पिन्दे पत्र टिसोङ। ख्युइ हतिया क्योपते ङिङच्येयि लाम्ला हिछे किङानतेबाला लेइराङ रुवा क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","चिचालानाना ख्युइ पवित्रशास्त्रायि वचनयि लम्ला येशु राङ ख्रिष्ट हिना नाङान ताम तान्दे यहुदिबाला पोरोयि धुनला लान ल मिङ्युइयाप सोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","अपोल्लोस कोरिन्थि होतितुइना पावल नाङयि छेत्रयि लाम्ला एफिससला लेप्सोङ। ख्युइ हतिया लोब्टु रेनला ठेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ख्युइ हतिबाला नाइसोङ, “जब खि हिछे क्याइरे च्हि खेला पवित्र आत्मा खुसुइये?” हतिबे खोला नाइसोङ, “पवित्र आत्मा होतो नाङान ता ङि ता थोथोइबा याङ मेता।” ");
INSERT INTO tcn_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","तेहि हति हतिबाला नाइसोङ, “तेहि खि च्हिरु बप्तिस्मा खेरते?” हतिबे नाइसोङ, “युहान्नायि बप्तिस्मा।” ");
INSERT INTO tcn_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","तेहि पावलयि नाइसोङ, “युहान्नायि पिपिनि बप्तिसमाते घ्योप्पा कियापयि बप्तिस्मा ना। ख्युइ च्येला होङानयि मि, अर्थात येशुयि थोला हिछे कि नाइरे ख्युइ मितेबाला स्येसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","धि तामबा थोइरे हतिबे प्रभु येशुयि मिनला बप्तिस्मा खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","जब पावलयि हतिबे थोला लाक्पा पोरसोङ, तेहि पवित्र आत्मा हतिबे थोला लेप्सोङ, राङ हतिबे स्यान क्येला ताम नाइसोङ राङ ङोन्सेखिलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","हतिबा हा:लाम च्युनङि झोम धु। ");
INSERT INTO tcn_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","पावल यहुदि झोमसि खिमला स्युरे धा सुम थु कजसुबायि राज्ययि भारेला हतिबा ङ्याबो हा:म राङ ङ्याबो नारे क्याइसोङ राङ मितेबाला हो:कोयापला स्योकिन त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","हिन्नाङ जब रेनरेन राङढिया च्युङदे हिछे माक्याइसोङ, राङ धि सामजयि विरोधला मिझोमयि धुनला ताम नाला छेलसोङ, तेहि पावल हतिबाने कुरु त्येसोङ, राङ लोब्टुबाला ङ्याबो खेरते टुरान्नसयि स्कुलला नारे किताला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","धि लाइ लो ङि थु चलि च्युङसोङ, राङ एशियायि त्योएङान मि पोरो, यहुदि राङ ग्रिक ङिकारयि प्रभुयि वचन ङ्यानसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","कजसुबायि पावलयि लाने बारतैले कुरु हा:लाइयापयि लाइतेबा क्याइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","धि थु कि रुमाल आथावा भरकि स्हुला छुइ क्याइरे नाप्पातेबे तेहा खेरिनलो, राङ हतिबे स्हुने नाझातेबा ढुन राङ ढेतेबा याङ थोनिनलो। ");
INSERT INTO tcn_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","हिन्नाङ रेनरेन फाला छुलो युङान यहुदि झाक्रितेबे ढे काकालातेबाला प्रभु येशुयि मिन धोनिन राङ जु नाइसोङ, “पावलयि टाइक्ये क्याक्याइबि येशुयि लाम्ला ङा ख्योएला आदेश तेरकिन होए।” ");
INSERT INTO tcn_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","हतिया चि स्केवास मिन क्याक्याबि यहुदि घोबा पुजारियि पिजा तुनयि जु किनलो। ");
INSERT INTO tcn_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","तेहि ढेति जवाक पिन्दे हतिबाला नाइसोङ, “येशुला ङाहि ङोस्येयिन, राङ पावलला याङ ङाहि ङोस्येयिन, हिन्नाङ खे सुना?” ");
INSERT INTO tcn_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","हति ढे काकालि मि हतिबे थोला फाकिन राङ लेप्सोङ, राङ हतिबा पोरोला कबुला ख्योरे हतिबे च्येला लेप्सोङ राङ हतिबे हति खिमने च्येपटाका राङ नाप्पा च्युङदे टोइरे पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","धि ताम एफिससला त्योएङान, यहुदि राङ ग्रिकतेबाला हाङ चाङमा चाङक्याङ च्युङसोङ। तेहि हतिबा पोरोयि थोला झिटा च्युङसोङ, राङ प्रभु येशुयि मिनला छे त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","हिछे किङानतेबा लेइराङ लेप्सोङ, राङ हतिबे क्याक्याइबि लाइ अलतेबा पोरो स्विकार क्याइसोङ राङ हति थोङदु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","हतिबे नाङने लेइराङ, सुगेसुगे जादु किन, राँ राँसि किताबतेबा रुरे ख्योसोङ, राङ पोरोयि धुनला मेला क्यापसोङ। हतिबे हति घो क्याकितुइना तोङ ङोपच्यु ङुलयि सिक्कायि हिसाब लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","हति च्वरा क्याइरे प्रभुयि वचन फेलिन राङ क्योङबो हुन पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","हति घटनातेबे च्येला, पवित्र आत्मायि प्रेरणाला पावलयि माकेडोनिया राङ अखैयायि लामयि लाम्ला यरुश्लेमला ढोयापयि थाकच्योए क्याइसोङ। ख्युइ नाइसोङ, “हतिया क्योप छारते ङा रोमला ढोकोइराङ हुन।” ");
INSERT INTO tcn_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ख्युइ स्यापच्यि स्युङान ङि, तिमोथि राङ इरास्तला ख्युइ माकेडोनियाला चाँसोङ, हिन्नाङ खो खोराङते ङिन रेन एशियाला राङ त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","हति भेलाला राङ हति लामयि भारेला लेइराङ हलचल च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","चिचालानाना डेमित्रियस मिन क्याक्याइबि मिझि ङुलयि शिल्पकारयि श्यिङयि लाइ किङानयि आर्तेमिस खाडोमि ङुलयि टिमाटिमा मोनलाम क्यासि खिम सोइरे स्यिप होएतातेबा लेइराङला लाइ तेरिनलो। ");
INSERT INTO tcn_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","तेहि हतिबाला राङ स्यान हति च्वरा लाइ होएतातेबाला हति जम्मा क्याइरे नाइसोङ, “भाइबा, खेला छ्या होतो माने, कि धि छोङने हुला कमाइ ल हुन। ");
INSERT INTO tcn_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","खे थोङिन्दु राङ थोयिन्दु, कि एफिससला मात्र माना, हिन्नाङ हा:लाम एशिया पोरोला लाक्पि सोसोइबि खाडोमा राङ लाते च्याङ माना नाइरे पावलयि मितेबे तुम लेइराङला हा:क्येरु च्युक्ते घो ख्याम्दु च्युच्युका होतो। ");
INSERT INTO tcn_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","हतिचाला ङि छोइयि ना छेया मात्रा माना हिन्नाङ हा:छेया खाडोमा आर्तेमिसयि मोनलाम क्यासि खिमबा याङ फान मेता हुन, राङ एशिया पोरो राङ संसारयि मानि किन लेलेबि खाडोमि रेँ ना छ्याछ्याता च्वरा हुन।” ");
INSERT INTO tcn_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","हति थोइरे हतिबा स्येताङ लाङदु, राङ “एफिससयि आर्तिमिस हा:छेया ना।” नाइरे क्ये धोनाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","भजार पोरोला हल्ला च्युङसोङ राङ हतिबा पोरो छ्या झि च्युङदे पावल ङ्याबो ढोङान माकेडोनियाला त्योएङान गायस राङ अरिस्तार्खसला सुङदे थाङ छोम्मुवाला ढुकिन राङ खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","पावल मि झोमयि उइला ढोसोम क्याइसोङ, हिन्नाङ लोब्टुतेबे खोला ढोरु माच्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","एशियायि चोम राङ घोबा मितेबे पावलयि रुवा च्युङसोङ। हतिबे पावलला थाङ छोम्मुवायि नाङला माढो नाइरे स्युवा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","तेहि हतिबा क्ये करुकुरुला ताम नेन राङ क्ये धोनाला छेलसोङ। चिचालानाना हति मिझोमला हल्ला होङाला छेलसोङ, राङ मि लेइराङयि त हतिबा चिला झोझोमा ना सो हति याङ छ्या माच्युवा। ");
INSERT INTO tcn_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","मिझोमयि मि चोम राङयि अलेक्‍जेन्‍डरला धुनला ख्योसोङ, सुला यहुदिबे लाँलाँङाना। अलेक्‍जेन्‍डरयि लाक्पि ता तान्दे मितेबे धुनला क्योपयापयि चाला चिगा नासोम कियापयि ताम पोरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","हिन्नाङ हतिबे हति ता यहुदि हिना नाङान हा:कोरे पोरोयि क्ये झिला हा:लाम घण्टा ङि झोम “एफिससतेबे आर्तेमिसयि हा:छेया ना” नेनराङ क्ये तोनसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ङ्यालबि हाकिमयि मितेबाला शान्त सोइरे नाइसोङ, “एफिससयि मितेबा, एफिससयि भजारते हा:छेया अर्तिमिसयि मोनलाम क्यासि खिम राङ पान्नाङने ङिङला ख्युइ कु क्योपङान ना नाङानयि ताम सुला छ्या मेता?” ");
INSERT INTO tcn_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","खेला छ्या होतो धि ताम जवाक क्यामिङ्युइङान धु, हतिचाला खे शान्त होङकोइ हुन राङ च्याङ आत्ति क्याक्याबि लाइ किच्याइ मिहा। ");
INSERT INTO tcn_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","चिचालानाना खि ख्योख्योबि धि मि मोनलाम क्यासि खिम लुटि क्याक्याइबा मेता राङ खाडोमि ना च्याच्याता याङ मेता। ");
INSERT INTO tcn_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","हतिचाला तेम्बारे डेमेत्रियस राङ हति ङ्याबो होएता श्यिप होएतातेबे विरोधला चिगा उजुर होएना अदालत खुलाला राङ होतो, राङ ल अल भेङानतेबा याङ धु राङ धु, हतिबे चिकि चियि विरोधला मुद्दा चे। ");
INSERT INTO tcn_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","हिन्नाङ धि अर्थात स्यान भारेला लोङसोम होएना ता हति थाकच्योए बारतैयि झोमसाला हुन। ");
INSERT INTO tcn_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","चिचालानाना तिरिङयि धि मिझोमयि ठुझियि दोष हुइ थोला फयापयि खतरा धु। चिचालानाना धि मनङि छ्युनङि मेते ठुझियि च्याङ च्याङक्याङ ङि तेर मिङ्युइबा। ");
INSERT INTO tcn_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","झोम नाइरे ख्युइ मिटिङते क्येतु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","हति ठु झि खा छारते पावलयि लोब्टुबाला डाकिला चाँसोङ, राङ हतिबाला छोइ पिन्सोङ, राङ हतिबाने बिदा च्युङदे माकेडोनिया यहला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","हति छेत्रला पुते हतिबाला समस्यु लेइराङ पिन छारते हति ग्रिसला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ख्युइ हतिया धा सुम बिताइ क्याइसोङ। खो सिरिया यहला डुङगायि लाम्ला ढुल कितितुइना यहुदिबे ख्युइ विरोधला छल क्याक्याइबाति पावलयि माकेडोनियायि लाम्ला लयापयि थाकच्योए क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","तेहि बेरियाला त्योएङानयि पुरसयि पिजायि सोपात्रोस, थेसलोनिके अरिस्‍तार्खस राङ सिकन्‍दस, डर्बीका गायस तेहि तिमोथि र एशियायि तुखिकस र त्रोफिमस खो ङ्याबो पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","हतिबा ताङलाने राङ क्योपते ङेला त्रोआसला कुँरे त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","तेहि ङे अखमरि लोटा कालापसोलयि ङिनतेबे च्येला फिलिप्पिने डुङगाला ढुल क्याइरे ङिन ङाला त्रोआसला हतिबे तेहा लेप्ते, राङ हतिया ङिन तुन ताते। ");
INSERT INTO tcn_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","हप्तायि ङिमा ताङस्युवाला जब ङे लोटा च्ययापला झोम्दे, तेहि पावलयि ङाइटोतेला ढोसोम क्याक्याइबाति, हतिबा ङ्याबो छान फेला ताम नेन त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ङे झोमदे ताताति थकि कोटाला बत्ति लेइराङ धु। ");
INSERT INTO tcn_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","युटिकस मिन क्याक्याइबि स्यारा झि झ्याल्ला त्येतु। पावलयि लेइराङ भेला थु ताम नानाइबाति हति ङि तिङ रिङमुवाला पुइसोङ राङ ङि टोरे हति तला सुमयि थोने टुलसोङ राङ हतिला हतिबे स्यिस्यियाला लाङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","तेहि पावल माला पापसोङ, राङ कुरकुर क्याइरे हतिला क्यालच्यामु क्यापसोङ राङ नाइसोङ, “माझि चिचालानाना हति सोम्बो राङ धु।” ");
INSERT INTO tcn_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","तेहि खो याला झिरे तेहि लोटा च्याक्ते साइ छारते नामे साल्बो माच्युङ थु लेइराङ भेला थु ताम नेन त्येसोङ। हति च्येला बिदा च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","तेहि हतिबे हति स्याराला सोम्बो अबस्थाला राङ खेरोसङ राङ लेइराङ छिमा फिङान खुँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ङा ताङलाने राङ डुङगा थु पुते राङ डुङगाला स्योन्दे अस्सोसला पुते। ङे हतिया पावलला हतिया डुङलाला स्योन्दु च्युसोम होए। पावलयि हति च्वरा राङ व्यवस्था क्याइरे खो अस्सोस थु काङबि राङ पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","तेहि जब ख्युइ ङेला अस्सोसला ठाते, ङि खोला डुङगाला स्योन्दु च्युक्ते, राङ मितिलेनेला लेप्ते। ");
INSERT INTO tcn_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","हतिने डुङगाला ढुल क्याइरे ङाइटोतेला खियसयि धुनला लेप्छारसोङ, राङ जब सामोसला लेप्छारते। हति स्यान ङिनतेला मिलेटसला लेप्ते। ");
INSERT INTO tcn_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","एशियाला भेला बिताइ किसोम मेताति पावल एफिसस मिस्युबा ढोयापयि थाकच्योए क्याइसोङ। चिचालानाना च्युङना पेन्तिकोसयि ङिन यरुश्लेमला राङ क्योपयापयि ख्युइ आत्ति क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ख्युइ मिलेटसने एफिससला मितेबा चाँरे चर्चयि एल्डरतेबाला क्ये ताङदे चाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","जब हतिबा ख्युइ तेहा लेप्ते ख्युइ हतिबाला नाइसोङ, “एशियाला कोबा क्याक्याबि ङिमा ताङस्युवाने राङ ङाल भेला पोरो राङ खि उइला काङ किसिमयि बिताइ क्याइसुइ सो खेला राङ छ्या होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","पुरा टुङबो च्युङदे छिमा तोङिन राङ, यहुदि छलयि छोए तायापला याङ ङाहि प्रभुयि स्यापच्यि स्युइरे। ");
INSERT INTO tcn_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","खेला फाइदा होङयापयि ताम खि धुनला घोषाणा कियापने राङ क्याइरे राङ खिम खिमला पोरोयि धुनला छोइ तेरयापले क्याइरे ङा च्येला मापुता। ");
INSERT INTO tcn_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","यहुदिबाला राङ ग्रिकतेबाला घ्योप्पा केरु च्युक्ते कजसुबा यहला लयाप राङ हुइ प्रभु येशु ख्रिष्टयि थोला हिछे भोरयाप नाङानयि तामयि साछि ङाहि पिपिना होतो। ");
INSERT INTO tcn_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“ता तोइ, ङा पवित्र आत्माला बाध्य च्युङदे यरुश्लेम यहला ढुन होए, हतिया ङाल च्हि होङयाप ना सो ङाला च्याङ छ्या मेता। ");
INSERT INTO tcn_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","झोम मात्रा छ्या होतो कि भजारला कैद राङ तुका ङाहि थोला परि हुन नाङान पवित्र आत्मायि ङाला साछि तेरिन। ");
INSERT INTO tcn_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","हिन्नाङ ङा ङारि मिजेला घोङ राङ ङारि चाला मिका। झोम मात्रा सम किन, कि कजसुबायि ङिङच्येयि लोन लयि साछि तेरयापला ङाहि स्युरयाप राङ प्रभु येशुने खुँखुँबि ङाहि स्यापच्यि ङा पुरा कि ङ्युइकिन।” ");
INSERT INTO tcn_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“ता तोइ, ङाला छ्या होतो कि खि नाङने पोरो कि, सुगा सुगाला ङाहि राज्ययि टाइक्ये किनराङ पुते, खि याङ ङाहि च्ये नामयाङ थोङान माना ना।” ");
INSERT INTO tcn_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","हतिचाला तिरिङयि ङिन ङा खेला साछि तेरच्याइ, कि सुइ याङ ठायि दोषि मिहा। ");
INSERT INTO tcn_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","चिचालानाना कजसुबायि उदेश्य खेला नायापला ङा च्येला हटि मिके। ");
INSERT INTO tcn_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","खे रेँ चाला राङ रेँ तुम छोम्मुवाति चाला च्याङबो क्याइरे त्योए। पवित्र आत्मायि खेला तुमयि जिम्मा खेरङान सोसोइबाति ख्युइ रेँ ठायि ङ्योङ्योइबि कजसुबायि चर्चयि तारो खेराङ कि। ");
INSERT INTO tcn_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","चिचालानाना ङाला छ्या होतो, कि ङा पुइ छारते झिझिरा वाजेतेबा खि उइला स्युङान ना, सुइ तुमला लाँमा लुइतु मिझ्युका। ");
INSERT INTO tcn_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","खिरि उइने घो ख्यामदु झ्युङानयि ताम नाङान मितेबा लाँङान ना, काङति लोब्टुतेबाला रेँ च्येला खेरङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","हतिचाला हति टाम्बा क्याइरे च्याङबो क्याइरे त्योए, कि लो सुम ङिन छान छिमा तोङिन राङ मि पोरोला चेतावानि तेरिन ताते। ");
INSERT INTO tcn_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“ता ङा खेला कजसुबाला राङ ख्युइ ङिङच्येयि वचनला टोच्याइ, सुइ खेला क्योङबो सुन, राङ पवित्र सोसोइबातेबा पोरोयि उइला होङानयि आङकिङान सुन। ");
INSERT INTO tcn_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ङाहि कि रेनयि सेर, ङुल, कि कोहिलायि लोभ माक्याइबा। ");
INSERT INTO tcn_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","खे राङला छ्या होतो कि ङाहि धि लाक्पि राङ ङारि राङ ङा ङ्याबो होएतातेबे कोइबाला पुरा क्याक्याइबा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ङाहि ताम पोरोला ख्योएला उदारण पिपिना होए, कि ख्युइ याङ धि च्वरा तुका क्याइरे सोरे मेतातेबाला रुवा किकोइ हुन। प्रभु येशुयि वचन टाम्बाला पोर, च्हिरु क्याइरे खो कुँरि नानाइबा धुइ, कि ख्योङयापले याङ तेरयाप चोम ल ना।” ");
INSERT INTO tcn_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","होचोम नाइरे ख्युइ पुइमु चुसोङ राङ हतिबा पोरो ङ्याबो मोनलाम क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","हतिबा पोरो ङुइसोङ, राङ पावलला क्यालच्यामु क्यापते पा च्यारसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","हतिबे याङ नामयाङ ख्युइ च्ये थोङान मानाना नाइरे पावलयि नानाइबि तामला हतिबे लेइराङ बैरा क्याइसोङ। तेहि हतिबे खोला डुङगा थु क्यालसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","खो ङ्याबो बिदा च्युङदे ङे डुङगाला स्योन्दे शिधा कोशला लेप्ते, राङ ङाइटोतेला रोडसला राङ हतिने पटाराला क्योप छारसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","तेहि फोनिकेला ढोयापयि डुङगा झि खुँ छारते ङे हतिला राङ स्योन्दे पुते। ");
INSERT INTO tcn_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","जब साइप्रस थोङसोङ, तेहि ङि हतिला योन यहला सिरिया यहला टुरोसला पापते। चिचालानाना डुङगायि सामान हतिया भयाप च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","लोब्टुबाला पाते खुछारते हतिबा ङ्याबो ङे हतिया ङिन तुन ताते। पावलला यरुश्लेमला माढो नाइरे हतिबाला पवित्र आत्मायि लाम्मला नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","हतिने ङे ढोयापयि भेला च्युङ छारते रेँ ढुलला थोन्दे। रेँ प्येरा राङ च्यिटाकातेबा पोरो राङ हतिबा पोरो ङेला भजारयि फि थु केलदु लेप्सोङ, राङ ङि छो छोम्मुवायि नेमुला पुइमु चुरे मोनलाम क्यापते, राङ चिकि चिने बिदा च्युङदे। ");
INSERT INTO tcn_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","तेहि ङे डुङगाला स्योन्दे, राङ हतिबा रेँ खिमला लसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","टुरोसने छो छोम्मुवायि ढुल क्याइ छारते ङे टेलिमाइसला क्योप छारसोङ। हतिया भाइबाला नामास्ते क्याइरे ङिन झि ताते। ");
INSERT INTO tcn_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ङाइटोतेला ङे बिदा च्युङदे कैसरियाला लेप्ते, राङ टाइक्ये किङान फिलिपयि खिमला स्युरे। खो हति तुनयि नाङने च्हि ना, राङ ङे हति ङ्याबो ताते। ");
INSERT INTO tcn_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ङोन्सेखिलङान ख्युइ पोमु ङा मिजे माक्याइबा धु। ");
INSERT INTO tcn_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ङे हतिया ङिन रेन ताते यहुदियाने अगाबस मिन क्याक्याइबि ङोन्सेखिलङान झि लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ख्युइ ङि तेहा लेप्ते पावलयि कारा खेरते लाक्पा काङबा तामसोङ, राङ नाइसोङ, “पवित्र आत्मा जु नेन्दु, ‘धि कारा मि सुइ हिना, हतिला यरुश्लेमला यहुदिबे याङ धि च्वरा क्याइरे राङ तेमङान ना राङ यहुदि मान्ते मितेबे लाला टोएङान ना।’” ");
INSERT INTO tcn_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","धि ताम थोइरे, ङे राङ हति सायि मि ढिक्ते हतिला यरुश्लेमला माढो नाइरे स्युवा क्याप्ते। ");
INSERT INTO tcn_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","हिन्नाङ पावलयि जवाक पिन्सोङ, “खे धि च्वरा क्याइरे ङुइरे ङाहि समला चिला किप्पो मेता सुन? चिचालानाना प्रभु येशुयि मिनयि चाला कैदि होङयाप मात्रा माना, हिन्नाङ यरुश्लेमला स्यियाप याङ ङा तयार होए।” ");
INSERT INTO tcn_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","हतिला घोकोर माङ्युइबाति “प्रभुयि धोप्पा पुरा सअ” नाइरे ङे च्यामाना ताते। ");
INSERT INTO tcn_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","हति ङिन ङे तयार ताते, राङ यरुश्लेम यहला पुते। ");
INSERT INTO tcn_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ङे ङ्याबो कैसरियायि लोब्टु रेन याङ पुइसोङ, राङ हतिबे ङेला साइप्रसयि लोब्टु ङिङबा झि मनासोन नाङानयि खिमला ख्योसोङ। हति तेहा ङे त्योए कोइ च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","तेहि जब ङे यरुश्लेमला क्योपते, तेहि भाइतेबे ङेला केन राङ स्वागत क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ङाइटोतेला पावल ङे ङ्याबो याकुबयि तेहा पुइसोङ। हतिया एल्डरबा पोरो धु। ");
INSERT INTO tcn_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","हतिबाला नामास्ते नाइ छारते, पावलयि हतिबे स्यापच्यियि लाम्ला यहुदि मान्ते मितेबे उइला कजसुबायि क्याक्याइबि लाइ हतिबाला च्यिच्यि क्याइरे मनङि क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","धि थोइ छारते हतिबे कजसुबायि छे तेसोङ। तेहि खोला नाइसोङ, “तोइ भाइ, यहुदिबे उइला हिछे किङानतेबा तोङ ल्हायि च्हि धु, राङ ठिमयि तामला हतिबा पोरो जोशिलो धु। रुपरेखा हतिबे ख्युइ भारेला याङ ताम रेन थोथोइबा धु, सो च्हि हिना नाना, यहुदि मान्ते मितेबे उइला त्योएङान यहुदिबाला ख्युइ ‘मोशाला तोङ राङ हतिबे च्यिटातेबाला खतना माके राङ लुलाब मानि माके’ नाइरे लालाबा धु। ");
INSERT INTO tcn_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","हतिबे याङ ख्युइ भारेला ताम रेन थोथोइबा होतो, सो काङते ना नाइना, यहुदि मान्तातेबे उइ ");
INSERT INTO tcn_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ला त्योएङान यहुदितेबाला ख्युइ ‘मोशाला तोङ राङ हतिबे च्यिटाकातेबाला खतना माके राङ लुलाम खाला ङ्योन’ नाइरे लालाबा होतो, अरे। ");
INSERT INTO tcn_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","हतिचाला च्हि हुन नेन, सो कि वाचा किङानतेबा स्यि ङे ङ्याबो होतो। ");
INSERT INTO tcn_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","हतिबाला खेरते ख्योए याङ धिबा ङ्याबोङ्याबो चाङमा सअ, राङ हतिबाला कोइयापयि खर्च ख्युइ पिन, राङ हतिबे स्येबु टाकुलिया सोयोङ। हति च्वरा क्याइरे ख्युइ ठिम ङ्याङ्याना थोङदे ख्युइ भारेला च्याङ तामयि तेम्बा मिधु नाइरे पोरोयि हा:कोङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","हिन्नाङ यहुदि मान्ते मितेबे सुइ हिछे क्याक्याइबा होतो, हतिबे कुला भोल क्यापते पुपुलि क्यु, ठा, झिङबा च्युइरे सासाति तुढोयि स्या राङ पातारने कुरुला त्योए कोइ हुन नाङान हुइ थाकच्योए हा:कोरु च्युक्ते पत्र टिटिबा धु।” ");
INSERT INTO tcn_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","तेहि पावलयि हति मिबाला खेरसोङ, राङ ङाइटोतेला हतिबा ङ्याबोङ्याबो राङला याङ चाङमा सोइसोङ, राङ चाङमा सोयापयि ङिनतेबाला जब पुरा होङयाप ना, तथा पोरोयि चाला तेरङानयि भेटियि लोन तेरतु हति मोनलाम क्यासि खिमयि नाङला स्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","जब ङिन तुन पुरा होङाला छेलसोङ, तेहि एशियायि यहुदिबे पावलला मोनलाम क्यासि खिमला थोङदे मियि तुम पोरोला कारु च्युसोङ, राङ खोला सुङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","हतिबा जु नेन राङ क्ये धोनाला छेलसोङ “इस्राएलि मितेबा” “रुवा कि! मितेबाला काङ च्याला हुइ मि, हुइ ठिम राङ धि सायि विरोधला छोइ पिन्दे ढोङान मि धि राङ ना। झोम मात्रा माना, धि ग्रिकबाला याङ मोनलाम क्यासि खिमयि नाङला ख्योरे हति पवित्र साला भाभा सोसोइबा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","चिचालानाना धि ताङला हतिबे एफिससयि त्रोफिमस नाङान मि झिला खो ङ्याबो भजारला थोथोङाति हतिला पावलयि मोनलाम क्यासि खिमयि नाङला ख्योख्योबा ना नाइरे हतिबे ठानि क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","तेहि भजार काङ च्याला ठुझि च्युङसोङ, राङ मितेबा लाम्मा झिला स्युरे लेप्सोङ। हतिबे पावलला सुङदे मोनलाम क्यासि खिमयि फिला ढुकिन राङ ख्योसोङ, राङ हतितुइनाराङ कोतेबा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","जब हतिबे खोला सोएयापयि च्युइ क्याइरे, तेहि यरुश्लेम पोरो मि किप्पो च्युङदु नाङानयि ताम यि लोन सिपाहियि सेनापतियि तेहा क्योपतु। ");
INSERT INTO tcn_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","खो हतितुइनाराङ सिपाहि राङ घोबातेबा ङ्याबो खेरते ख्युइ तेहा स्युकिन राङ लेप्सोङ। हतिबे सेनापति राङ सिपाहितेबाला थोङसोङ, राङ पावलला क्याकाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","तेहि हति सेनापति पावलयि धुनला लेप्ते सुङदे खोला च्यालता ङि तेमयापयि आदेश पिन्सोङ। धि सु हिना राङ धि च्हि क्याइ सुइ नाइरे टिसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","धि हति मिझोमयि नाङने रेनयि ताम झि राङ रेनयि स्यान ताम नाइरे क्ये तोन्सोङ, राङ हति होलोयि क्याइरे घटना च्हि ना सो हा:को माङ्युबाति पावलला अड्डाला खेर नाइरे आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","जब पवाल टाइला क्योपते, तेहि होलोयि तुप्पाति क्याइरे सिपाहितेबे खोला तेक्ते खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","चिचालानाना मितेबे तुम “हतिला सोए” नाइरे क्ये धोनिन राङ च्येच्येला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","अड्डाला क्योलेला पावलयि सेनापतिला नाइसोङ, “हजुर, आङ होएना, ङा चिगा नासोम होए।” ख्युइ नाइसोङ, “च्हि ख्युइ ग्रिकयि क्ये स्येयिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","“च्हि ख्योए मिश्री मानाइ च्हि, सुइ थाल्लाका विद्रोह मचाइ क्याइरे तोङ स्यि विद्रोतेबाला झङगलला खेखेरा होतो?” ");
INSERT INTO tcn_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","हिन्नाङ पावलयि जवाक पिन्सोङ, “ङाता किलिकियायि भजार टार्सस यि यहुदि मिझि ना, टिमा भजारयि मि माना। स्युवा होए, धि मिला चिगा नायापयि आङ पिन।” ");
INSERT INTO tcn_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","जब ख्युइ आङ पिन्दे, तेहि टाइला लाँरे पावलयि मितेबाला लाक्पि ता तान्सोङ। मितेबा शान्त च्युङ छारते च्येला, ख्युइ मितेबाला हिब्रु क्येला जु नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“भाइबा तथा बाबु बा, खि धुनला ङा ङारि छहला नायाप ताम ता ङ्योन।” ");
INSERT INTO tcn_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","हतिबा हिब्रु क्येला ताम नानाइबा थोइरे हतिबा तरह च्यामाना त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","हतिबे नाइसोङ, “ङा किलिकियायि भजार टार्ससला क्येक्येबा यहुदि झि ना, हिन्नाङ धि भजारला गमलिएलयि पाङला छाछारा ना। ङा ताङबुइ ठिम च्वरा क्याइना ङाला थारकाथारका छोइ खुँखुँबा होतो। तिरिङ खे कजसुबा यहला चोम काका होए, ङा याङ होचोम काका होए।” ");
INSERT INTO tcn_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ङा धि लामयि मितेबाला स्यिस्यिथु राङ तुरि पिन्दे, तेहि पिजा राङ पोमुवा ङिकारला तेमिन राङ झ्याल्ला च्युक्ते। ");
INSERT INTO tcn_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","घोबा पुजारि राङ पोरो नेता झोझोमि तुमयि याङ ङा छहला साछि तेरिन। ख्युइ तर्फने भाइतेबे मिनला पुर्जि खुँरे ङा हतियायि हिछे किङानतेबाला ताम्दे यरुश्लेमला ख्योरे ङेबा तेरतु दमस्कसला पुपुता होतो। ");
INSERT INTO tcn_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ङा ढुलला दमस्कसयि तेहा क्योबि तुइना हा:लाम ङिम्मु च्युङदु, हो:प्तामेला तेङलाने होए छोम्मुवा झि ङाहि फाला छुलोला होए भारसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","राङ ङा चाल का तापसोङ, तेहि ङाला जु नानाइबा क्ये झि थोइसोङ, ‘ए शावल, ए शाउल, ख्योए ङाला चिला तिक्पा तेरिन?’ ");
INSERT INTO tcn_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","तेहि ङाहि टिरे, ‘हे प्रभु, ख्योए सुना?’ तेहि ख्युइ ङाला नाइसोङ, ‘नासरतयि येशु ङाराङ ना, सुला ख्योए तुरि तेरिन्दु।’ ");
INSERT INTO tcn_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","तेहि ङा चोम मि होए, हतिबे होएता थोङसोङ, हिन्नाङ ङा ङ्याबो नानाइबि तामयि छिते माथोइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“ङाहि नाइरे ‘हे प्रभु ता ङा चि किच्याइ?’ तेहि प्रभुयि ङाला नाइसोङ, ‘ल्ह। दमस्कसला क्यु, राङ खि कोइयापयि तोकि क्याक्याइबि लाइतेबा ङाला स्योए।’” ");
INSERT INTO tcn_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","“हति होएयि होए छेयाति क्याइरे जब ङाहि च्याङ थोङ माङ्युइसोङ, तेहि ङा ङ्याबो होएतातेबे लाक्पि ठिते ङाला दमस्कसला ख्योसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“हननिया नाङान मिझि ठिम च्वरा क्याइना ढोङान भक्ता मि सुइ हतिया त्योएङान यहुदिबा पोरोने सम्मान खुँखुँ होतो। ");
INSERT INTO tcn_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","खो ङाहि तेहा लेप्सोङ, राङ ङाहि धुनला लाँरे ङाला नाइसोङ, ‘भाइ शाउल, थोङान होङवार सअ।’ राङ ङा हतितुइना राङ थोङान च्युङसोङ, राङ खोला थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","तेहि ख्युइ नाइसोङ, ‘हुइ ताङबुइ आकेतेबे कजसुबायि ख्युइ धोप्पा खि हा:को, राङ हति केवाकिङान मितेबाला थोङयापला, राङ ख्युइ खाने छि थोइयापला खो धाधामा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","चिचालानाना मितेबा पोरोयि चाला ख्युइ च्हि थोथोङा होतो राङ थोथोइबा होतो, ख्योए हति साछि होङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","ता चिला कुकिन? ल्हँ, राङ बप्तिस्मा खेर, तेहि ख्युइ मिन तोन्दे रेँ तिक्पा ठुइ।’” ");
INSERT INTO tcn_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“यरुश्लेमला लक्ते लेप्छारते मोनलाम क्यासि खिमला मोनलाम क्याकितुइना ङाहि थोङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","ख्युइ ङाला जु नानाइबा ङाहि थोङसोङ, ‘घ्यबो राङ यरुश्लेमने थोन्दे क्यु, चिचालानाना ङाहि भारेला ङाहि पिपिनि साछि हतिबे ग्रहण किङान मानाना।’” ");
INSERT INTO tcn_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“ङाहि नाइरे, ‘हे प्रभु, ङा यहुदि झोमसि खिम पोरोला पुते ख्युइ थोला हिछे किङानला झ्याल्ला च्युच्युका राङ क्याक्तु तुङदु च्युच्युका धिबा पोरोला छ्या होतो माने।’ ");
INSERT INTO tcn_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","ख्युइ साछि स्तिफनसयि सोतितुइना ङा राङ याङ धुनला लाँरे हति मिपस्योएला सहमत च्युङदे, खोला स्योएङानतेबे कोहिला कुँरे ताताता होए। ");
INSERT INTO tcn_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","तेहि प्रभुयि ङाला नाइसोङ, ‘क्यु, चिचालानाना ङा ख्योएला यहुदि मान्ते मितेबे तेहा घ्याबो घ्याबोला चोङज्याइ।’” ");
INSERT INTO tcn_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","हतिबे पावलयि क्ये झोम थु मात्रा ङ्यानसोङ, “राङ जु नेन राङ हतिबा क्ये छेया धोनाला छेलसोङ। धि च्वरा मि पृथ्‍वीने मेता होङवार सअ। चिचालानाना हति सोन्यापयि झ्योदायि मिधु।” ");
INSERT INTO tcn_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","हतिबा रेँ कोहिला रोलिन राङ थोलजुप लोङिन राङ क्ये धोलाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","सेनापतियि आदेश पिन्सोङ, “हतिला अड्डायि नाङला ख्याला, कि च्यायि छेरमा क्यापते छोए तोइ, कि चिचाला हतिबा धि विरोधला क्ये धोनिन धुइ।” ");
INSERT INTO tcn_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","“तेहि जब हतिबे पावलला पाबुइ थाक्पि किसोङ, तेहि पावलयि धुनला लालाबा घोबाला टिसोङ, च्हि रोमियि नागरिक राङ दोषि मेते मिला च्यायि छेरमा क्यायाप इनसाफ हिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","घोबायि धि थोइ छारते सेनापतियि तेहा लेप्ते जु नाइसोङ, “ख्युइ चि कियाप आटि क्याइरे? चिचालानाना धि मिता रोमि नागरिक हिना।” ");
INSERT INTO tcn_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","तेहि सेनापति लेप्ते पावलला टिसोङ, “ङाला नोइ, च्हि ख्योए रोमि नागरिक हिनाइ?” ख्युइ नाइसोङ, “हिना।” ");
INSERT INTO tcn_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","सेनापतियि जवाक पिन्सोङ, “ङाहि ता धि मि लेइराङ आलाइ च्यारे ङ्योङ्योइबा ना।” पावलयि नाइसोङ, “हिन्नाङ” ");
INSERT INTO tcn_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","हिन्नाङ खोला छोए तायापला तयार होएतातेबा पोरो हतितुइनाराङ राङ हटि क्याइरे पुइसोङ, राङ पावल रोमि नाकरिक झि हिना नाइरे हा:कोरे सेनापति याङ झिसोङ, चिचालानाना ख्युइ हतिला तातामा धु। ");
INSERT INTO tcn_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","हिन्नाङ ङाइटोतेला यहुदिबे पावलला काङ खास तोनयि चाला दोष लाइ क्याक्याइबा हिना सो हा:कोयपयि धोप्पा क्याक्याबाति खोला टोलसोङ, राङ घोबा पुजारि पोरो राङ नेतातेबा पोरोला झोमयापयि आदेश पिन्सोङ, तेहि पावलला हअला ख्योरे हतिबे धुनला लाङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","पावल नेतातेबा झोमसि नाङला लाम्मा झि ताइसोङ, राङ नाइसोङ, “भाइबा, तिरिङयि ङिन थु कजसुबायि मिला चाङमा रिक्पि मिज क्याक्याङा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","हति तामला घोबा पुजारि हननियायि ख्युइ धुनला लाँरे तातातातेबाला खाला थालच्या क्यापयि आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","तेहि पावलयि हतिला नाइसोङ, “हे सागार कुकुइबि पे! ख्योएला याङ कजसुबे क्याङान ना। ख्योए ठिम च्वरा क्याइरे ङाहि इनसाफ कितु ताते च्हि ठियि विरोध ङाला क्यायापयि आदेश तेरिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","तेहि धुनला लाँरे तातातातेबे नाइसोङ, “च्हि ख्योए कजसुबायि घोबा पुजारि ना च्योकिनाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","तेहि पावलयि नाइसोङ, “भाइबा, खो घोबा पुजारि हिना नाइरे ङाला छ्या मेता। चिचालानाना टिटिबा धु, ‘ख्युइ रेँ जनतायि शासकला अल माना।’” ");
INSERT INTO tcn_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","हिन्नाङ हति नेता झोझोमि सायि तुमझि सदुकि राङ स्यान तुमते फरिसितेबा हिना नाइरे हा:कोरे पावलयि क्ये छेया क्याइरे नाइसोङ, “भाइबा, ङा ता फरिसियि पिजा फरिसि राङ ना। स्यिस्यियातेबे आशा राङ स्यिरे सोम्बो च्युङदे लाँङानतेबे चाला ङाहि मुद्दा चलिहुन राङ होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ख्युइ जु नाइ छारते च्येला फरिसितेबा राङ सदुकिला भेदभाब च्युङसोङ, राङ तुमते खा पियाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","चिचालानाना सदुकि नेन्दु कि स्यिरे सोम्बो च्युङदे लाँयाप, तेङलायि लोन खेरङान, आत्मा नाङान च्याङ मिहा। हिन्नाङ फरिसिबा हतिबा पोरो मानि किन। ");
INSERT INTO tcn_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","हतिया हल्ला छेया च्युङसोङ, राङ फरिसि तुमयि रेन शास्त्रि लाँरे जु नेन राङ आन्दोलोन क्याइसोङ, “धि मिला ङि च्याङ अल मिथोङा। तेम्बारे आत्मा वा तेङलायि लोन खेरङान यि खोला जु नानाइबा हिन ना ता च्हि?” ");
INSERT INTO tcn_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","हतियि भेदभाब छेया च्युङ छारते हतिबे लाने पावल च्योमतु लाङोङ नाइबि झिटाति सेनापतियि सिपाहितेबाला हअला पुते खोला हतिबे उइने स्यु किङगा ख्योरे अड्डायि नाङला खेरयापयि आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ङाइटोतेला प्रभुयि ख्युइ धुनला लाँरे नाइसोङ, “हिम्मत कि, पावल, चिचालानाना च्हिरु क्याइरे ख्युइ यरुश्लेमला ङाहि भारेला साछि पिन्दे, हति च्वरा क्याइरे ख्युइ रोमला याङ साछि तेरकोइ हुन।” ");
INSERT INTO tcn_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","नामे साल्बो च्युङ छारते च्येला यहुदिबे रेँ नाङला तुम च्योइरे पावल ला मासे थु च्याङ मिसायाप राङ च्याङ मिथुङयापयि ना क्यालसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","हति छल किङान मितेबा मिरको खलङिले याङ मा धु। ");
INSERT INTO tcn_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","हतिबे घोबा पुजारि राङ धर्म गुरुतेबे तेहा च्याङ मिसा नाइरे ङि क्योङबो ना क्याक्याला होतो। पावल मास्ये थुङे च्याङ मिसा नाइरे ङि क्योङबो ना क्याक्याला होतो। ");
INSERT INTO tcn_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","हतिचाला खे राङ नेतातेबा ढिक्ते सेना पतिला अपिल कि, राङ हति मुद्दायि थाकच्योए तरह ल क्याइरे किकोइ हुन नाइरे बाहाना सोइरे हतिला थोन। तेहि हति लेबि पाल्ला हतिला स्योएयापयि चाला तयार तोकिन होए। ");
INSERT INTO tcn_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","ता तेहि पावलयि भैनि धि छल हा:कोरे अड्डायि नाङला पुते पावलला स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","तेहि पावल घोबातेबे नाङने चिला क्ये ताङदे नाइसोङ, “धि स्याराला सेनापति तेहा खेर, चिचालानाना ख्युइ खोला चिगा नायापयि ताम होतोलो।” ");
INSERT INTO tcn_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","“हतिचाला ख्युइ हतिला खेरते सेनापति तेहा खेरते नाइसोङ, बन्दि पावलयि ङालाक्ये ताङदे धि स्योर च्युङला ख्युइ तेहा खेर नानाइबा धु, ख्योएला नायापयि ताम रेन होतो, अरे।” ");
INSERT INTO tcn_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","सेनापतियि हति लाक्पा सुङदे यह चिला खेरते सुहुङ मेते साला खेरते टिसोङ, “ख्युइ ङाला नायापयि ताम चिना?” ");
INSERT INTO tcn_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","हति नाइसोङ, “यहुदिबे पावलयि भारेला तरह ल क्याइरे ढियापयि निहुँ क्याइरे ङाइटो खोला यहुदि नेताबा झोम्सि खिमला ख्याला नाइरे स्युवा क्यायापयि टोइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","हिन्नाङ हतिबे ताम माङ्यान, चिचालानाना हतिबे नाङने मिरको खलङिले मा मितेबे हतिला मासे थु च्याङ मिसायापयि ना क्यालदे सोएयापयि चाला कुँरे त्येतु, राङ ता हतिबा ख्युइ वचनयि आशा क्याइरे छेलदे ताताता धु।” ");
INSERT INTO tcn_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","हतिचाला सेनापतियि हति स्योरच्युङला जु नाइरे आदेश पिन्दे चाँसोङ, “ख्युइ ङाला धि लोन पिपिनि ताम सुलाङ माना।” ");
INSERT INTO tcn_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","हति च्येला ख्युइ घोबातेबे नाङने मिरको ङेला क्ये ताङदे नाइसोङ, “तिरिङ छाम्मु नौ बजे झोमला सिपाहि ङि क्यातेबा, खलसुम राङ च्युझोम ताला स्योन्दे राङ ङिक्या च्यायि पेरका ङ्युङङ्युङ खुरते कैसरिया थु ढोयापला तयार सोइरे पोर। ");
INSERT INTO tcn_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","तेहि पावलयि चाला याङ तायि व्यवस्था कि, राङ खोला स्युङिन राङ हाकिम फेलिक्सयि तेहा क्योल।” ");
INSERT INTO tcn_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","ख्युइ धि च्वरा पत्र याङ टिसोङ: ");
INSERT INTO tcn_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“मान्निय हाकिम फेलिक्सला, क्‍लौडियस लुसियसयि खामसाँ! ");
INSERT INTO tcn_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","धि मिला यहुदियि सुङदे स्योएच्युइ क्याइसोङ, हिन्नाङ धि रोमियि मि हिना नाइरे ङाहि हा:कोरे सिपाहितेबा ङ्याबो हतिया क्योपते खोला छुटाइ क्याइरे। ");
INSERT INTO tcn_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","काङ दोष ला हतिबे खोला दोष लाइ क्याक्याइबा हिना नाइरे हा:कोयापयि सम क्याइरे ङाहि धिला हतिबे नेतातेबा झोम्सि खिमला ख्योरे। ");
INSERT INTO tcn_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","हतिबे ठिमयि टिवायि भारेला धिला दोष लाइ क्याक्याइबा हिना। हिन्नाङ स्योएयापयि ङेबा अथावा कैद कियाप माफिकयि च्याङ दोष ङाला माठेसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","धि मियि विरोधला छल हुन्दु नाङानयि तामयि लोन ङाला पिन्सोङ, राङ खोला हतितुइना राङ ख्युइ धुनला चाँचाँबा होए, राङ ख्युइ विरोधला दोष लाइ किङानतेबा याङ ख्युइ धुनला मनङि क्योप नाइरे आदेश क्याक्याइबा होए।” ");
INSERT INTO tcn_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","हति चाला आदेश खुँखुँबा च्वरा सिपाहितेबे पावलला छाम्मु राङ एन्‍टिपाट्रिसला क्यालदे लसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ताला स्योनङानतेबाला खो ङ्याबो ढोरु हतिया राङ ताङदे ङिमा च्येमातेला हतिबा अड्डाला लसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","कैसरियाला क्योप छारते हतिबे हाकिमला पत्र टोते पावलला याङ ख्युइ धुनला स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","ख्युइ पत्र ट छारते च्येला खो काङ जिल्लायि हिना नाइरे टिसोङ। खो किलिकियायि हिना नाइरे हा:को छारते च्येला ख्युइ नाइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","“खेला दोष लाइ किङानतेबा लेप्छारते च्येला खि मुद्दा ङ्यानज्याइ।” तेहि ख्युइ हतिला हेरोदयि सोसोइबि क्यालखाङला पोर नाइरे आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","ङिन ङाहि च्येला घोबा पुजारि हननिया राङ चोम राङ धर्म गुरुतेबा, तर्तुल्लस मिन क्याक्याइबि वकिल झि ङ्याबो हतिया लेप्सोङ, राङ हतिबे पावलयि विरोधला हाकिमयि धुनला मुद्दा देश क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","पावल हतिया तोन छारते च्येला तर्तुल्लसयि खोला जु नेनराङ दोष लाइ किताला छेलसोङ, “लेइराङ माननिया फेलिक्स, ख्योएने ङि लेइराङ छेया शान्ति ङ्योङिन होए, राङ ख्युइ धि मितेबे चाला याङ सोलाइते सुरु क्याइ छारसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","धि ताम काङच्याने सा पोरोला फेलिक्सला कटिनक्याँ राङ ङ्याबो स्विकार किच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","हिन्नाङ ख्युइ लेइ समय मिखेरा ङि स्युवा तुइमाझिला ङिङच्येरे ङ्यान रोकि। ");
INSERT INTO tcn_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“चिचालानाना ङि धि मिला काङच्याला तुरि तेरिन राङ ढोङान, संसार काङयि यहुदिबे उइला आन्दोलोन किङान, राङ नासरि पाटियि घोबा घोठि किङानयि धोला ठाठाता होतो। ");
INSERT INTO tcn_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","धि मोनलाम क्यासि खिम भाभा सोयाप याङ कोशिश क्याक्याइबा होतो, हिन्नाङ धिला ङि सुङदे। ङि ठिम च्वरा क्याइरे कारबाइ याङ कि च्युइ क्याइरे। ");
INSERT INTO tcn_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","हिन्नाङ सेनापति लुसियासयि ङि तेहा लेप्ते लेइराङ स्यु ढिप्पि क्याइरे हतिला ङि लाने ठरे खेरसोङ, राङ हति विरोधला दोष लाइ किङानतेबाला ख्युइ तेहा होङयापयि आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","ता ख्योए ख्योएराङयि धि छानबिन क्याइना ङि धिला लाइ क्याक्याबि दोषला धि ताम पोरो खोने हा:को ङ्युइकिन।” ");
INSERT INTO tcn_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","हति यहुदिबे याङ हति ताम पोरो तेम्बाना नाइरे रुवा क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","हाकिमयि खोला ताम नायापयि ता तान छारते पावलयि जवाक पिन्सोङ, “लो लेइराङने ख्योए यहुदि मितेबे ल अल भेङानयि च्युच्युङायि ताम हा:कोकुवाति ङा ङारि भारेला केनराङ नेन होए। ");
INSERT INTO tcn_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","ख्युइ पत्ता लाइ कि ङ्युइयोङ कि ङा यरुश्लेमला आराधाना कितु पुपुति ङिन च्युनङिले मा च्युच्युङा मेता। ");
INSERT INTO tcn_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","धिबे न त ङाला मि रेन ङ्याबो नारे किन ताताता ठाते, न मोनलाम क्यासि खिमला वा यहुदि झोमसि खिम अथवा भजारला जनताला उत्तेजित परि च्युच्युङा ठाते, ");
INSERT INTO tcn_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","न त ङला थाल्ला दोष लाइ क्याक्याइबि तामयि धिबे प्रमान तेरङ्युइकिन। ");
INSERT INTO tcn_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","हिन्नाङ ङा धि ख्युइ धुनला राङ स्विकार किच्याइ, कि काङ लामला खे पाटि झि नेन, हति च्वरा क्याइ नाङ ठिमला होएता ताम राङ ङोन्सेखिलङानयि किताबला टिटिबि ताम पोरो हिछे क्याइरे ङा ताङबुइ कजसुबायि आराधाना ङा किच्याइ। ");
INSERT INTO tcn_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","केवाकिङान राङ तिक्पा किङान ङिकार स्यिस्यियाने सोम्बो च्युङदे लाँकिन नाङान हतिबा खोरे स्विकार क्याक्याइबा च्वरा ङा कजसुबाला आशा भोरच्याइ। ");
INSERT INTO tcn_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","हतिचाला कजसुबायि थोला राङ मियि थोला ङा बारतै चाङमा रिक्पा भोरयापयि कोशिश किन होए। ");
INSERT INTO tcn_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“ता लो रेन च्येला रेँ मितेबे चालादान राङ भेटितेयापला ङा लेलेबा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","धिबे ङाला मोनलाम क्यासि खिमला ठातितुइना चाङमा होङयापयि लुलाम ङाहि पुरा क्याइ छारते। हति च्याङ मिझोम मिदु, हल्ला याङ मिदु। हिन्नाङ हतिया एशियायि यहुदि रेन धु, ");
INSERT INTO tcn_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","हति एशियायि यहुदितेबा हतिया ख्युइ धुनला होङकोइ राङ हुन। ङाहि विरोधला ताम नाकोइ होएना हतिबे दोष लाइ कि ङ्युइकिन। ");
INSERT INTO tcn_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","अथवा धि मिबे ख्होरे ङिहा नोइ ङा नेतातेबा झोझोमि साला लाँरे तोतितुइना ङाला च्हि दोष खुँरे? ");
INSERT INTO tcn_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","मात्र धि ताम झि मात्रा हिना, काङते ङाहि खि उइला लाँरे क्ये तोन्दे नानाइबा होतो, ‘स्यिस्यिया सोम्बो च्युङदे लाँयापयि भारेला तिरिङ खि धुनला ङाहि मुद्दा चिला हुन राङ होतो।’” ");
INSERT INTO tcn_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","धि लामयि भारेला फेलिक्सला तेम्बारे छोइ च्युच्युवाति ख्युइ धि तामबा थोइ छारते हतिबाला जु नेन राङ टारि क्याइरे चाँसोङ, “सेनापति लुसियस ङिहा लेप्छारते ङा खि मुद्दा थाकच्योए क्याइरे चाँतोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","तेहि पावलला स्युङानतेबा पोर राङ हतिला मनस्याङ कितु याङ छ्यु, तेहि ख्युइ रुवा सुलाङ खोला कोइबा होएता क्यु पुरा कियापला मा घा नाइरे घोबाला आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","ङिन रेन च्येला फेलिक्स ख्युइ यहुदि केरमान द्रूसिल्‍लाl ङ्याबो खेरते लेप्सोङ, राङ ख्युइ पावलला क्ये ताङदे येशु ख्रिष्टयि हिछेयि भारेला खोने थोइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","पावलयि धर्मिक्ता, रेँ छोए सुङयाप राङ होङानयि इनसाफ भारेला नारे कितितुइना फेलिक्स आत्ति क्याइसोङ, राङ जु नाइसोङ, “थाल्लि चाला क्यु, मौका परि च्युच्युङायि भेलाला ङा ख्योएला क्ये ताङतोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","पावलने चि क्याइना आलाइ खुहोङ नाइबा क्याइरे ख्युइ आशा याङ क्याइसोङ। हतिचाला याङ ख्युइ हतिला लोलाइलोलाइ क्याइरे ताम क्ये ताङसोङ राङ ताम नेनलो। ");
INSERT INTO tcn_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","हिन्नाङ लो ङि च्येला जब फेलिक्सयि छापला पर्किअस फेस्तसला लेप्सोङ, तेहि फेलिक्सयि यहुदिबाला केन राङ भोरयापयि चाला पावलला झ्याल्ला राङ पोरते पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","फेस्तस रेँ छेत्रला लेलेबि ङिन सुम च्येला कैसरियाने यरुश्लेमला पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","घोबा पुजारितेबा राङ यहुदिबे ङोधो मितेबा पावलयि विरोधला दोष लाइ क्याइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","राङ खोला लाम्ला राङ सोएयापयि छल क्याइरे पावलला यरुश्लेमला राङ धोनयापयि कृपा सा नाइरे स्युवा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","हिन्नाङ फेस्तसयि पावल कैसरियाला राङ झ्याल्ला पोरसोङ, राङ खो राङ याङ घ्यबो ढोसोम होएते ताम नाइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","ख्युइ नाइसोङ, “हतिचाला खिङानाङयि नेताबा हतिया ङा ङ्याबो ढो, राङ हति मिला चिगा नानाइबा होएना हतिला दोष लाइ कि।” ");
INSERT INTO tcn_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","हतिबे उइला खो च्याक्पा क्ये कुले मा माताता कैसरियाला लसोङ, राङ हति ङाइटोतेला ल अल भेसि ठिला ताते ख्युइ पावलला ख्योङयापयि आदेश पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","खो लेप्छारते यरुश्लेमने लेलेबि यहुदिबा ख्युइ फाला छुला लाँसोङ, राङ पावलयि विरोधला कुरुकुरु गम्भिर दोष लाइ क्याइसोङ, काङति हतिबे साछि तेर माङ्युइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","पावलयि रेँ छहला ताम नेन राङ नाइसोङ, “ङाहि यहुदिबे ठिमयि विरोधला, मोनलाम क्यासि खिमयि विरोधला, राङ कैसरयि विरोधला च्याङ अपराध क्याक्याइबा मेता।” ");
INSERT INTO tcn_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","हिन्नाङ फेस्तसयि यहुदिबाला कारु झ्युयापयि चाला पावलला नाइसोङ, “च्हि ख्योए यरुश्लेमला पुते हतिया ङाहि धुनला धि तामतेबे भारेला इनसाफ क्यायोङ नाइबा किनाइ?” ");
INSERT INTO tcn_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","हिन्नाङ पावलयि नाइसोङ, “ङा कैसरयि ल अल भेसा त्योएसि ठि धुनला लाँरे ताताता होए, काँहा ङाहि इनसाफ होङकोइ हुन। यहुदिबाला ङाहि च्याङ अल क्याक्याइबा मेता, सो ख्योएला फैसाला सअ। ");
INSERT INTO tcn_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","तेम्बारे ङा अपराधि हिन्नता, राङ ङाला सोएयापयि ङेबा खुयापयि झ्योदायि होएनाता ङा इनकार मिके। हिन्नाङ तेम्बारे धिबे ङाला दोष लाइ क्याक्याइबि च्याङ तेम्बा मेना ङाला धिबे लाला सुइयाङ टोए मिङ्युइबा। ङा कैसरला स्युवा क्याकिन होए।” ");
INSERT INTO tcn_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","तेहि फेस्तसयि ठोइ किङानतेबा ङ्याबो टोइ क्याइरे नाइसोङ, “ख्युइ कैसरला स्युवा क्यापतेइ, ख्योए कैसरयि तेहा राङ ढोङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","ङिन रेन पुइ छारते फेस्तसला खाँमसाँ नारु क्यालबो अग्रिपास राङ बरनिकि कैसरियाला लेप्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","खो हतिया ङिन लेइराङ त्ये छारते फेस्तसयि पावलयि मुद्दा क्यालबुइ धुनला जु नेन राङ पेश क्याइसोङ, “फेलिक्सयि पोरते पुपुता कैदि झि ङिहा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","सुइ भारेला ङा यरुश्लेमला होतितुइना, घोबा पुजारितेबा राङ यहुदिबे धर्म गुरुतेबे हति विरोधला दोष लाइ क्याइरे ङेबा तेरकोइ राङ हुन नाइरे स्युवा क्यापसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“दोष फोफोकाति दोष लाइ किङानतेबा ङ्याबो धुन धुनला माना, राङ रेँ विरोधला लाइ क्याक्याइबा दोषयि भारेला ताम नायापयि मौका माखुबा राङ सु मिलाङ चुका छ्या भुलयापयि रोमिबे लुलाम मेता नाइरे ङाहि पोरोला जवाक पिन्दे। ");
INSERT INTO tcn_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","जब हतिबा झोम्दे हतिया लेप्सोङ, ङा पुला माक्याइबा ङाइटोतेला राङ ल अल भेसा त्योएसा ठितेला ताते खोला हतिया स्योएयापयि आदेश पिन्दे। ");
INSERT INTO tcn_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","जब दोष लाइकिङानतेबा लाँसोङ ङा विचार क्याक्याइबा च्वरा ख्युइ मुद्दाला च्याङ अल तामयि दोष हतिबे ख्योङ माङ्युइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","हिन्नाङ हतिबे भेदभाबते हतिबे राङ धर्मयि भारेला राङ स्यि छाछारि येशुयि भारेला ना, काङतेला पावलयिते तरह सोम्बो होतो नाइरे दाबि किन्दु। ");
INSERT INTO tcn_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","हतिचाला धि तामयि छानबिन कियापयि भारेला ङा आच्यामाच्या हुइतुइना धि भारेला टोइ कितु यरुश्लेमला ढोयापयि ख्युइ सम होरोम नाइरे खोला ङाहि टिरे। ");
INSERT INTO tcn_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","हिन्नाङ पावलयि क्यालबुइ थाकच्योए माच्युङ थु झ्याल्ला राङ पोर नाइरे स्युवा क्याक्याबाति हतिला कैसरयि तेहा पाचाँ थु सुङदे भोरयापयि आदेश पिन्सोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","तेहि अग्रिपासयि फेस्तसला नाइसोङ, “धि मियि ताम ङा ङारि याङ ङ्यानज्याइ च्युवा नाना हुवा।” तेहि ख्युइ नाइसोङ, “ङाइटो ख्योए ङ्यानरो कि।” ");
INSERT INTO tcn_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ङाइटोतेला अग्रिपास राङ बरनिकि छेया रवाफ ङ्याबो सेनापतितेबा राङ भजारयि ङोधो मितेबा ङ्याबो यहुदि झोम्सि खिमला स्युसोङ। तेहि फेस्तसयि आदेश खुँरे पावलला हतिया स्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","फेस्तसयि नाइसोङ, “क्यालबो अग्रिपास राङ ङे ङ्याबो होएता पोर, खि धि मिला थोङिन्दु, सुइ भारेला यहुदि पोरोयि ‘धि मि ता याङ सोन्यापयि झ्योदायि मिधु’ नाइरे यरुश्लेमला राङ ङिहा याङ ङा ङ्याबो स्युवा क्याक्याइबा होतो। ");
INSERT INTO tcn_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","हिन्नाङ सोएयापयि ङेबा खुकोइराङ हुन नायापयि ङेबा ङाला खोने च्याङ माखुबाति राङ धि खोराङयि याङ क्यालबुइ तेहा स्युवा क्याक्याबाति ङा खोला चोङयापयि थाकच्योए क्याइरे। ");
INSERT INTO tcn_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","धि भारेला क्यालबोला टिरे कुरयाप खास ता च्याङ मेता। हतिचाला ङाहि धिला ख्युइ धुनला, राङ खास क्याइरे, हे क्यालबो अग्रिपास, ख्युइ धुनला ख्योख्योबा होतो, राङ ङि धि छानबिन क्याइ छारते हा:लाम चिगा ढियापयि ताम खुहोङ। ");
INSERT INTO tcn_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","चिचालानाना कैदियि विरोधला च्याङ दोष मास्याता हतिला चोङयाप ङाला ठिक लागि मिहा।” ");
INSERT INTO tcn_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","अग्रिपासयि पावलला नाइसोङ, “ख्योएला रेँ छहला नायापयि आङ होतो।” तेहि रेँ लाक्पा क्याङदे पावल राङला क्योपयापला नाला छेलसोङ: ");
INSERT INTO tcn_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“हे क्यालबो अग्रिपास, यहुदिबे ङाला ला क्याक्याइबि दोष पोरोयि भारेला तिरिङ ख्युइ धुनला तिरिङ ङा राङला क्योपयापला नायाप खुँखुँबाला ङा ङारि ङा राङला सोरे होएता ठानि किन होए।” ");
INSERT INTO tcn_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","यहुदिबे ताम पोरोयि लुलाम राङ नारे कियाप पोरोला ख्योए खा क्याइरे ङोस्येस्येबाति, ङाहि खुँलुँ सिरिया क्याइरे ङ्यान रो कि नाइरे ङा स्युवा क्याकिन होए। ");
INSERT INTO tcn_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“ङाहि मितेबे उइला राङ यरुश्लेमला ताङलाने राङ बिताइ क्याक्याइबि ङाहि स्यारायि अवस्थाने राङ ङाहि मिजे क्योङ ता यहुदिबाला छ्या होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","लेइराङ भेलाने हतिबाला छ्या होएते ताम राङ ना, कि ङाहि धर्मि पोरोले क्योङस्युवा पाटि ङ तुमयि ङाहि फरिसि च्युङदे ङाहि मिजे क्याक्याङा होतो। हतिबे चाहि क्याइना धि तामयि साछि तेर ङ्युइकिन ");
INSERT INTO tcn_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","कजसुबायि रेँ ताङबुइ मिला क्याक्याइबि ना क्याक्यालातेला ङाहि आशा पोपोरि चाला तिरिङ ङा धि मुद्दाला लाँलाँबा होए। ");
INSERT INTO tcn_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ङि च्युनङिगार क्यालिक्युइयि धि आशा खुयापला ङिन छान मेता सम चि च्युङदे आराधाना क्याइसोङ, राङ हति आशायि चाला, हे क्यालबो, यहुदिबे ङाला दोष लाइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","कजसुबे स्यिस्यियातेबाला सोम्बो सुन नाङन ताम झि खेला चिला हिछे माच्युङसुइ? ");
INSERT INTO tcn_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","नासरतयि येशुयि विरोधला लेइराङ कारबाइ किकोइहुन नाङान ङा ङाराङला याङ लेइराङ हिछे होतो। ");
INSERT INTO tcn_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ङाहि यरुश्लेमला हति च्वरा राङ क्याइरे, राङ घोबा पुजारितेबाने आङ खुँरे लेइराङ कजसुबायि मिला ङाहि झ्याल्ला च्युच्युका मात्रा माना, हिन्नाङ हतिबाला सोतितुइना हतिबे विरोधला राङ ङाहि ङारि भोट याङ च्युक्ते। ");
INSERT INTO tcn_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","तेहि पोरो यहुदि झोमसि खिमला हतिबाला लोलाइलोलाइ किनकिन ङेबा पिन्दे हतिबाला हिछे तोङयापयि कर याङ क्याइरे। हतिबे विरोधला स्येताङयि ठा खोल्दे फियि भाजरला याङ ङाहि हतिबाला तुरि पिन्दे। ");
INSERT INTO tcn_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“हति च्वरा क्याइरे घोबा पुजारिने आङ राङ आदेश पत्र खुँरे ङा दमस्कसला पुते। ");
INSERT INTO tcn_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","हे क्यालबो, ङिमा झाराना माला ङाहि तेङलाने ङिमाले केना साल्बो होए थोङसोङ, काङते ङा राङ ङा ङ्याबो ढुल किङानतेबे फाला छुलो पोरोला होए भारिन त्येतु। ");
INSERT INTO tcn_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","जब ङे पोरो साला घेघेला होतो, तेहि हिब्रु क्येला ङाला जु नानाइबा क्ये ङाहि थोइसोङ, ‘शाउल, शाउल, ख्योए ङाला चिला तुरि तेरिन? खापला तोति क्याकितुइना ख्योए राङला आया क्याकिन।’ ");
INSERT INTO tcn_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","तेहि ङाहि नाइरे, ‘हे प्रभु, ख्योए सु ना?’ प्रभुयि ङाला नाइसोङ, ‘ङा येशु ना, सुला ख्योए तुरि तेरिन्दु।’ ");
INSERT INTO tcn_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","हिन्नाङ ल्हँ राङ रेँ काङबाला लाँरे त्योए, चिचालानाना ङाला ख्युइ थोथोङा राङ ङाहि ख्योएला तोनयापयि तामयि चाला स्यापच्यि राङ साछि धामङान उदेश्ययि ङा ख्युइ तेहा थोथोङा ना। ");
INSERT INTO tcn_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","ङा ख्योएला ख्योए ख्युरि मि राङ यहुदि मान्ते मितेबेने छुटकारा तेर च्याइ, सुइ तेहा ङा ख्योएला चोङज्याइ, ");
INSERT INTO tcn_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","कि ख्युइ हतिबे मि फे, राङ हतिबा मुन्नाने होए यहला, राङ तुइयि शक्तिने कजसुबा यहला लहोङ। हति च्वरा क्याइरे तिक्पि माप खुङान ना राङ ङाहि थोला हिछेयि लाम्ला पवित्र आत्मा होएतायि सा हतिबाला लाङ खुङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“हतिचाला हे क्यालबो अग्रिपास, तेङलायि थोङयापयि थोला ङा नानाइबा च्वरा माच्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","हिन्नाङ ताङला दमस्कसला, तेहि यरुश्लेमला राङ यहुदिया देश काङ त्योएङानतेबाला, राङ यहुदि मान्ते मितेबाला याङ घ्योप्पा क्याइरे कजसुबा यहला लह राङ रेँ घ्योप्पा क्याक्याइबा चोमयि लाइ कि नाइरे ङाहि टाइक्ये क्याइरे। ");
INSERT INTO tcn_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","हतिचाला यहुदिबे ङाला मोनलाम क्यासि खिमला सुङदे सोएयापयि कर क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","तिरिङयि ङिन थु कजसुबाने ङाला रुवा खुँखुँबा होतो। धि छेया छुवा ङिकारला साछि तेरिन ङोन्सेखिलङान राङ मोशायि नानाइबि वचन तेम्बा पुरा होङान ना ताम अर्थात ङाहि स्यान च्याङ नानाइबा मेता। ");
INSERT INTO tcn_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","हतिबे नाइसोङ कि ख्रिष्टयि तुरि ङ्योङकोइराङ हुन, राङ स्यिस्यियाने सोम्बो च्युच्युङा ताङस्युवा हिनाति ख्युइ रेँ मि राङ यहुदि मान्ते मितेबाला होएयि घोषाणा किङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ख्युइ रेँ क्योपयापयि धि तामतेबा नेन ताताताला राङ फेस्तसयि क्ये छेया क्याइरे नाइसोङ। “ए पावल, ख्योए ङ्योमबा हिनाइ, ख्युइ छोइ माहाति ख्योएला ङ्योमबा सोइदु।” ");
INSERT INTO tcn_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","हिन्नाङ पावलयि नाइसोङ, “लेइराङ मान्निय फेस्तस, ङा ङ्योमबा माना, हिन्नाङ तेम्बा राङ योदानयि तामतेबा नेन। ");
INSERT INTO tcn_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","चिचालानाना क्यालबो खोराङयि धि तामयि भारेला हा:कुन, सुइ धुनला ङा ढुक्क किङगा ताम नेन। चिचालानाना धि तामबा पोरो खोने भाभाइबा मेता, चिचालानाना धि ताम फा:ला क्याक्याइबा माना। ");
INSERT INTO tcn_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","क्यालबो अग्रिपास, च्हि ख्युइ ङोन्सेखिलङानबे थोला हिछे किनाइ? ङाला छ्या होतो, ख्योए हिछे किन तोम।” ");
INSERT INTO tcn_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","अग्रिपासयि पावलला नाइसोङ, “च्हि टिझि भेलायि चाला ख्योए ङाला ख्रिष्टियान सोसोम होतोइ?” ");
INSERT INTO tcn_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","पावलयि जवाक पिन्सोङ, “टिझिला होस याङ महाला धि च्यालताबा ताङदे, ख्योए मात्रा माना हिन्नाङ तिरिङ ङाहि ताम ङ्यानङानबा पोरो ङा च्वरा होङवार सअ नाइरे ङा कजसुबाला मोनलाम क्याकच्याइ।” ");
INSERT INTO tcn_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","तेहि क्यालबो, हाकिम, बरनिकि राङ हतिया होएता पोरो लाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","तेहि हतिबा थोन्छारते च्येला रेँ नाङला जु नेन राङ ताम नाला छेलसोङ, “धि मिला सोएयापयि ङेबा अथवा कैदला ढोयापयि माफिकयि च्याङ लाइ माक्याइबा।” ");
INSERT INTO tcn_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","अग्रिपासयि फेस्तसला नाइसोङ, “धि कैसरयि तेहा स्युवा माक्याइबा नाना त धि मिला ताङनाङ हुवा।” ");
INSERT INTO tcn_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","छो छोम्मुवायि ढुलयि लाम्ला ङे इटालियाला ढोकोइ हुन नाङान थाकच्योए च्युङ छारते, हतिबे पावल राङ स्यान चोम राङ कैदितेबे क्यालबो अगस्टपासयि सिपाहियि युलियस मिन क्याक्याबि घोबायि जिम्लाला टोएसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","एड्रामिटेनोसने एशियायि कुरुकुरु बन्दरगाहतेबा हुन राङ ढोङानयि डुङगाला स्योन्दे ङि ढु;ल सुरु क्याइरे। अरिस्‍तार्खस मिन क्याक्याइबि थेसलोनिकेयि मि झि माकेडोनिया ङे ङ्याबो होत। ");
INSERT INTO tcn_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ङाइटोतेला ङि सिदोनला लङ्गर च्युक्ते। युलियसयि पावलला ङिङच्ये तान्दे हतिबे रुवातेबे तेहा पुते कोइयापयि रुवा खेरयापयि आङ पिन्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","हतिने याङ डुङगा छो छोम्मुवा यहला खेरसोङ, राङ हुरबो छोम्मुवा क्याक्याबाति ङे साइप्रसयि आड खेरते पुइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","किलिकिया राङ पामफिलिया फारकानयि छो छोम्मुवाला क्योप छारते च्येला, ङे लुकियायि भजार माइरामाला क्योपसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","हतिया इटालियाला ढोङान अलेक्‍जेन्‍ड्रिया डुङगा झि ठाते घोबायि ङेला हतिला पुलदे। ");
INSERT INTO tcn_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","ङिन लेइराङ थु कुलेकुले पुते लेइराङ तुका किङगा क्निडसला क्योपसोङ राङ हुरबो छोम्मुवायि तरह ताङला ढोरु माच्युकाति क्रेटयि आड खेरते ङे सालमोनेयि धुनयि लाम्ला पुते। ");
INSERT INTO tcn_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","तुका किनकिन हति नेमु नेमुयि लाम्ला ङे लेबो बन्दरगाह नाङान साला क्योपसोङ। हतिने लासिया भजार धुनला राङ धु। ");
INSERT INTO tcn_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","भेला लेइराङ पुइसोङ राङ छो छोम्मुवायि ढुल याङ झिझिरा च्युङ छारतु, ङ्याबो राङ घ्योप्पा कियापयि कालापसोलयि वर्तयि भेला याङ पुइ छाछाराति, पावलयि हतिबाला ");
INSERT INTO tcn_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","जु नेन राङ खाइकोए च्युसोङ, “रुवा बा, धि छो छोम्मुवायि ढुलयि मात्रा डुङगा राङ साम्मायि मात्रा माना, हिन्नाङ हु स्हुयि समेत झिझिरा हुन राङ नोए हुन नाङान ङाहि थोङिन्दु।” ");
INSERT INTO tcn_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","हिन्नाङ घोबायि पावलयि तामले केना डुङगा चला किङान राङ डुङगालियि ताक्पोला लेइ हिछे क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","धि बन्दरगाह कुङगा बिताइ कियापला सुबिधा मेताति चि क्याइरे याङ फोनिक्सला राङ क्योपते कुङगा बिताइ किकोइ हुन नाइरे लेइराङयि हइने डुङगा चलाइ किकोइ हुन नाइरे टोइ क्याइसोङ। फोनिक्सते क्रेटयि बन्दरगाह झि ना, काङते स्यार नुप राङ लो नुप यहला ललका धु। ");
INSERT INTO tcn_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","जब च्याङ हुरबो छोम्मुवा गति ढुवाला छेलसोङ, हतिबे उदेश्य थारका च्युङदे नाइ छारते, लङ्गर तोन्दे हतिबा क्रेटयि नेमुनेमुयि लाम्ला राङ ढुल किताला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","टिझि भेलायि च्येला हति छो छोम्मुवायि उइयि साने हुरबो छोम्मुवा छेयायि वेगाला लो-स्यार नाङानयि हुरबो छोम्मुवा क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","जब डुङगा हुरबो छोम्मुवा छेयायि धुइयापला लेप्सोङ, हति हुरबो छोम्मुवा छेया ङ्याबो माङ्युइसोङ, राङ ङि हतिला काँहा ढोनाङ क्यु नारे ताङदे पोरते। ");
INSERT INTO tcn_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","क्‍लौडा नाङान झि टिमा छो छिम्मुवायि उइयि साला क्योप छारते ङि तुका क्याइरे डुङगा छोम्मुवायि डुङगाला क्योप ङ्युइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","हतिला याला ते छारते हतिबे च्युइ चिगा क्याइरे डुङलाला हअ यहला तेमिन राङ ख्योरे, राङ सिरटिस नाङान क्‍लौडा धाबाला छ्युकिन नाङानयि झिटायि हतिबे कुर पापसोङ, राङ डुङगा खोराङ च्यारे खेराला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","ता हुरबुइ ङेला लेइराङ धेकिन राङ तेबाला छेलसोङ, राङ ङाइटोतेला हतिबे डुङगायि सामान ढिमाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","तेहि ङिमा सुबाला हतिबे रेँ लाक्पि डुङगायि लठारा मिलाइ किताला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","ङिन लेइराङ थु ङिमा, कारमा च्याङ थोङज्याइ माखुसोङ। हुरबो छोम्मुवा छेया लेइराङ मिछ्याता क्याक्याबाति किनकिन ता ङि सोनयापयि आशा याङ मेता च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","ङिन लेइराङ थु हतिबा मिसा त्येतु। तेहि पावल हतिबे तेहा लेप्ते नाइसोङ, “रुवातेबा, खि ङाहि खाइकोए ङ्यान्दे क्रेटने डुङगा चला मिकिता ताता नाना च्युवा ना, राङ धि च्वरा दशा राङ नोए खेला ङ्योङकोइ माच्युङाना। ");
INSERT INTO tcn_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","ता ङा नाज्याइ, हिम्मत पोर। खि नाङने सुहुङ मिस्यिया, हिन्नाङ डुङगाते मासि होङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","चिचालानाना काङ कजसुबायि ङा ना, राङ सुइ आराधाना ङा किन, ख्युइ लोन खेरङान झि तिरिङ छाम्मु ङा धुनला लाँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ख्युइ ङाला नाइसोङ, ‘पावल, माझि, ख्योए कैसरयि धुनला लाँकोइ राङ हुन, राङ तोइ, ख्योए ङ्याबो डुङगाला स्योस्योना पोरोयि उ कजसुबायि ङि लाक्पाला टोएसोङ।’ ");
INSERT INTO tcn_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","हतिचाला रुवा बा, हिम्मत कि। ङा कजसुबाला हिछे किन, ङा च्हिरु स्यास्याता होए, थारका हति च्वरा राङ किच्याइ। ");
INSERT INTO tcn_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","हिन्नाङ हुते रेन छो छोम्मुवायि उइयि सायि नेमुला ढोकोइ राङ हुन।” ");
INSERT INTO tcn_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","हिन्नाङ जब छान स्यिबा च्युङदे, राङ एड्रियास छो छोम्मुवाला स्युरे ढुन ताताता होए, तेहि छान फेला माला छोयि मितेबे हु सा झिकि धुनला क्योपलेके धु नाङान अनुमान क्याइसोङ, ");
INSERT INTO tcn_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","राङ तिङरिङमुवा नापि क्याइरे तोतितुइना हतिबे ङिस्यु राङ च्युइरु मिटर पत्ता लाइ क्याइसोङ, राङ याङ टिझि फाला पुते तिङ नापि कितुइना हतिबे ङिस्यु राङ टु पत्ता लाइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","तेहि चि क्याइना टोउला फहोङ नाङानयि झिटायि, हतिबे डुङगायि क्याप यहने लङ्गर स्यि थाबा टिम्सोङ, राङ नामे होङवार सअ नाइरे मोनलाम क्यापसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","जब छोयि मितेबा डुङगाने टोइरे ढुवा फाताला छेलसो, राङ धुन यहला लङ्गर ढिमयापयि बाहानाति डुङगा छोला छारछारतु। ");
INSERT INTO tcn_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","तेहि पावलयि घोबा राङ सिपाहितेबाला नाइसोङ, “धि मितेबा डुङगाला मा स्योन्ना खे सोनङान मानाना।” ");
INSERT INTO tcn_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","तेहि सिपाहितेबे डुङगायि थाक्पातेबा तुपसोङ, राङ डुङगाला ढोरु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","नाम सिरि भिरि हुवाला छेलसोङ, पावलयि हतिबा पोरोला ङ्योपा सायापयि स्युवा क्यापसोङ। ख्युइ नाइसोङ, “तिरिङयि ङिन च्युपझि च्युङ छारसोङ, खे आच्या माच्या च्युङदे टोपा तोङबा च्याङ मासाइबा त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","हतिचाला च्याङ मासा नाइरे ङा ख्योएला स्युवा क्याकच्याइ। चिगा साइना खोला तोप खुङान ना, खि सुइ याङ स्येबु झि याङ मास्यि होङान मानाना।” ");
INSERT INTO tcn_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","धि तामबा पोरो नाइ छारते ख्युइ लोटा खेरसोङ, राङ पोरोयि धुनला कजसुबाला कटिनक्याँ नाइछारते सो च्याक्ते साला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","तेहि हतिबाला सम स्यु खुँरे चिगा सायाप साइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","(डुङगाला होएता ङे जम्मा पोरो क्याइरे ङिक्या खलसुम राङ च्युइरु होतो) ");
INSERT INTO tcn_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","हतिबा ढ्हाढ्हा थु साइरे, डुङगा या सोयापयि चाला छो छोम्मुवाला ढु टिम्सोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","साल्बो च्युङ छारते याङ हतिबे हति सा ङोस्ये माङ्युइसोङ, हिन्नाङ हतिबे तोङ झि थोङसोङ। हति बलौटे नेमु झि धु। च्युङना डुङगाला हतिया खोङ च्युइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","हतिबे लङ्गरतेबा पापसोङ, राङ छो छोम्मुवाला राङ हति तोतु च्युसोङ। हति भेलाला राङ खोल्लोतेबा तातामायि थाक्पातेबा टोलसोङ। धुनयि कुरतेबा तेक्ते हुरबो छोम्मुवा यहला लसोङ राङ डुङगाला नेमु यहला खेरसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","हिन्नाङ छ्युयि हअकि हिहिबि पेमायि धाबाला डुङगा भारतो क्यापते ढो माङ्युइसोङ, तेहि क्यापयि भागते भाल्लापयि स्युटायि तुबुतुबु हुवाला छेलसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","कैदितेबा पौडि क्यापते टोइरे पुयोङ नाइबा क्याइरे सिपाहितेबे हतिबाला सोएयापयि टोइ क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","हिन्नाङ घोबायि पावलला क्योपसोम क्याइरे हतिबाला हति च्वरा कियापले काक्ते पोरसोङ। पौडि क्या मिङ्युइङानतेबा ताङला डुङगाने फारते थाङला क्यु नाङानयि आदेश ख्युइ पिन्सोङ, ");
INSERT INTO tcn_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","राङ लाँमा लुलुइबाते पालेपला राङ डुङगायि तुभुला फारकानला क्यु नाइसोङ। हति च्वरा क्याइरे पोरो ल क्याइरे नेमुला ढो ङ्युइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","ङे ल क्याइरे नेमुला लेप्छारते च्येला हति छो छोम्मुवायि उइयि सायि मिनला माल्टा हिना नाङान ङेला छ्या च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","हतिया त्योएङान मितेबे ङेला लेइराङ ङिङच्ये तान्सोङ। नाम क्यापते टाङमु च्युच्युङाति कारणयि हतिबे मे ताङसोङ, राङ ङे पोरोला स्वागत क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","पावलयि छ्याक्पा झि श्यिङ रुदु राङ सो ख्योरे मेला च्युसोङ। मेयि टोएति रुल झि थोन्दे लेप्सोङ। राङ ख्युइ लाक्पाला फेरक्यापते त्येसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","हतिया त्योएङान मितेबे ख्युइ लाक्पाला रुल फेरक्यापते ताताता थोङदे खोरे नाङला नाला छेलसोङ, “धि पि पक्का मिपसोए किङान राङ ना। धि छो छोम्मुवाने सोन्दे त थोन्सोङ हिन्नाङ इनसाफने धि थार माङ्युइसोङ।” ");
INSERT INTO tcn_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","हिन्नाङ पावलयि हति रुलला मेला स्युसोङ, राङ खोला च्याङ नोए क्येल माङ्युइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","हिन्नाङ ख्युइ स्हु स्याहाङान ना, अथवा खो हो:प्तामेला घेल्दे स्यिङान ना नाइरे हतिबा कुँरे तोताला छेलसोङ। हिन्नाङ लेइराङ भेला थु कुँरे ताते याङला खोला च्याङ नोए क्याक्याला माथोङाति हतिबे रेँ विचार च्येरे नाला छेलसोङ, “धिता ला हिना।” ");
INSERT INTO tcn_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","हति छो छोम्मुवायि उइयि सायि पब्लियस मिन क्याक्याइबि मुखियायि सा स्यिङ हति सायि धुन धुनला राङ धु। ख्युइ ङेला स्वागत क्याइसोङ, राङ ङिन सुम थु ख्युइ खिमला ङेला ढोम्बो स्यामसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","पब्‍लियसयि आके छ्याबा राङ आउँयि नाझि नाप्पा च्युङदु। पावल हतिला तारु पुइसोङ, राङ ख्युइ चाला मोनलाम क्यापसोङ, राङ रेँ लाक्पा हति थोला पोरते खोला टाक्तु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","धि घटना च्युङ छारते च्येला, हति छो छोम्मुवायि उइयि सायि नाझा होएता मितेबा याङ लेप्सोङ, राङ टाक्तु च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","हतिबे काङ च्याने ङेला सम्मान क्याइसोङ। जब ङे डुङगाला स्योन्दे, हतिबे ङेला कोइबा होए चोमयि सामान डुङगाला च्युसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","धा सुमयि च्येला, ङे अलेक्‍जेन्ड्रियायि डुङगाला स्योन्दे। हति डुङगा कुङगि तुइना धि छो छोम्मुवायि उइयि सा राङ धु। डुङगायि ताङमा भागला छेमा लायि कु कोए क्याक्याइबा धु। ");
INSERT INTO tcn_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","सुराकुसाइला क्योपते ङे हतिया ङिन सुम ताते। ");
INSERT INTO tcn_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","हतिने ङे नेमु नेमुने रेगियानला क्योपसोङ। ङिन झिकि च्येला च्याङयि हुरबो छोम्मुवा क्यापसोङ, राङ ङाइटोतेला पटिओलिला क्योपसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","हतिया ङि भाइबाला ठाते, राङ हतिबे ङेला ङिन तुन थु हतिबा ङ्याबो त्योएयापयि स्युवा क्यापसोङ। हति च्वरा क्याइरे ङे रोमला क्योपसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","हतिने ङे होङानयि लोन थोइरे भाइबा ङेला ठातु अप्‍पियसयि भजार राङ तिन पाटि नाङान साला लेप्छारसोङ। हतिबाला थोङदे पावलयि कजसुबाला कटिनक्याँ नाइसोङ, राङ हिम्मत खुँसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","जब ङे रोमला स्युरे, तेहि पावलला सिपाहि झि तारु चिक्पा त्योएयापयि आङ खुसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","ङिन सुमयि च्येला पावलयि यहुदि घोठिङानला क्ये ताङदे चाँसोङ। हतिबा झोम छारते ख्युइ हतिबाला नाइसोङ, “भाइबा, ङाहि ता रेँ देशयि मितेबाला, अथवा ताङबुइ आकेयि लुलामयि विरोधला च्याङ लाइ क्याक्याइबा मेता। हचु हिन्नाङ बन्दि च्युङदे यरुश्लेमने रोमिबे लाने ङाला टोटोता होतो। ");
INSERT INTO tcn_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","हतिबे छानबिन क्याइ छारते ङाला स्योएयापयि ङेबा च्याङ माखुबा राङ ङाला तोङसोम क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","हिन्नाङ यहुदिबे विरोध क्याक्याइबाति कैसरयि तेहा स्युवा क्याक्तु ङाला कर क्याइसोङ ङाहि मितेबे विरोधला च्याङ दोष लाइ कियाप ताम माच्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","हतिचाला ङाहि खे ङ्याबो ठाते ताम नारु खेला क्ये ताताङा ना। चिचालानाना इस्राएलयि आशा सुना हति चाला धि च्यालताला ङा तातामा होतो।” ");
INSERT INTO tcn_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","हतिबे खोला नाइसोङ, “ङेला ता ख्युइ भारेला यहुदियाने च्याङ चिठि खुखुबा मेता। भाइ रेन लेप्ते ख्युइ विरोधला च्याङ अल ताम स्यास्याता वा ताम नानाइबा मेता। ");
INSERT INTO tcn_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","हिन्नाङ ख्युइ विचार चि ना, सो ख्योएने ङ्यानसोम होए। चिचालानाना धि तुमयि भारेला ङेला झोम मात्रा छ्या होतो, कि काङ च्याला मितेबा धि भारेला मात्रा ताम नेन्दु।” ");
INSERT INTO tcn_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","तेहि हतिबे ख्युइ चाला ङिन झि तोकि क्याइसोङ, राङ टाँगा लेइराङला मितेबा खो त्योएसा तेहा लेप्सोङ। ख्युइ हतिबाला नामेने कमु थु राङ भाषाण पिन्सोङ, राङ मोशायि ठिम राङ ङोन्सेखिलङानयि किताबने कजसुबायि राज्ययि साछि पिन्सोङ, तेहि येशुयि भारेला हतिबाला हिछे तेरयापयि स्यु क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","ख्युइ नानाइबि ताम चोम राङयि हिछे क्याइसोङ राङ, चोमयि राङ माक्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","हतिबा रेँ नाङला मिढिकाला छेलसोङ, राङ क्योबितुइना पावलयि धि च्येस्युवा ताम नाइसोङ, “हतिबे ताङबुइ आकेला यशैया ङोन्सेखिलङानयि लाम्ला पवित्र आत्मायि नानाइबि वचन थारे राङ ना।” ");
INSERT INTO tcn_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","धि मितेबे तेहा पुते नोइ, “ङ्यान ज्याइ ता खे ङ्यानिन्दु, हिन्नाङ नामयाङ हा:मिकुवा, ताज्याइ ता तेन्दु, हिन्नाङ नाम याङ मिथोङा।” ");
INSERT INTO tcn_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","चिचालानाना धि मियि सम बैरागि च्युङदु, राङ हतिबे नामज्यो हो:न्दु, राङ हतिबे रेँ मि रुरुबा धु स्यान अर्थात हतिबे मिकि थोङान ना, नामज्योयि थोइङान ना, समयि हा:कोङान ना राङ लङान ना राङ ङाहि खेला टाक्तु झ्युङान ना। ");
INSERT INTO tcn_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","“हतिचाला खेला छ्या होतो कि, कि कजसुबायि धि मुक्ति यहुदि मान्ते मितेबे चाला चाँचाँबा होतो, राङ हतिबे थोइङान ना।” ");
INSERT INTO tcn_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","तेहि ख्युइ धि वचन नाइ छारते च्येला, यहुदिबा रेँ नाङला लेइराङ नारे क्याइरे विदा च्युङसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","पावल पुरा लो ङि थु रेँ खर्चला रोमला त्येसोङ, राङ ख्युइ तेहा होङान पोरोला ख्युइ स्वागत क्याइसोङ। ");
INSERT INTO tcn_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","ख्युइ खुल्लामखुल्ला राङ घाङान सु मेता कजसुबायि राज्यि टाइक्ये किन, राङ प्रभु येशु ख्रिष्टयि भारेला छो तेरिन।");
ALTER TABLE tcn_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
