﻿USE sofia;
DROP TABLE IF EXISTS sofia.tcaNT_vpl;
CREATE TABLE tcaNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tcaNT_vpl WRITE;
INSERT INTO tcaNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ñaã nixĩ ga yema nuxcümaxü̃güxü̃ ga duü̃xü̃gü ga Ngechuchu ya Cristu natanüwa ngóxü̃. Rü yematanüwa rü Dabí nixĩ ga wüxi, rü Abráü̃ nixĩ ga to. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Rü Abráü̃ rü Ichaánatü nixĩ. Rü nüma ga Ichaá rü Acóbunatü nixĩ. Rü nüma ga Acóbo rü Yudánatü rü naẽneẽgünatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Rü Yudá rü Fárenatü rü Záranatü nixĩ. Rü Támara iyixĩ ga norü mamá. Rü nüma ga Fáre rü Eróü̃natü nixĩ. Rü nüma ga Eróü̃ rü Aráü̃natü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rü Aráü̃ rü Aminadánatü nixĩ. Rü nüma ga Aminadá rü Nachóü̃natü nixĩ. Rü nüma ga Nachóü̃ rü Charmóü̃natü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Rü Charmóü̃ rü Boónatü nixĩ, rü Raá iyixĩ ga naẽ. Rü nüma ga Boó rü Obénatü nixĩ, rü nae rü Rux iyixĩ. Rü nüma ga Obé rü Ichaxínatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Rü nüma ga Ichaxí rü ãẽ̱xgacü ga Dabínatü nixĩ. Rü nüma ga ãẽ̱xgacü ga Dabí rü Charomóü̃natü nixĩ. Rü ngima ga Bechabé ga Uría namèxchirẽ́x ixĩcü iyixĩ ga naẽ ga Charomóü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Rü Charomóü̃ rü Roboáü̃natü nixĩ. Rü nüma ga Roboáü̃ rü Abíanatü nixĩ. Rü nüma ga Abía rü Achánatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Rü Achá rü Yochapánatü nixĩ. Rü Yochapá rü Yoráü̃natü nixĩ. Rü nüma ga Yoráü̃ rü Uchíanatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Rü Uchía rü Yotáü̃natü nixĩ. Rü Yotáü̃ rü Acánatü nixĩ. Rü nüma ga Acá rü Echequíanatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Rü Echequía rü Manachénatü nixĩ. Rü Manaché rü Amóü̃natü nixĩ. Rü nüma ga Amóü̃ rü Yochíanatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Rü Yochía rü Yeconíanatü rü naẽneẽgünatü nixĩ. Rü yexguma nixĩ ga Babiróniãcü̱̃ã̱x ga churaragü Yudíugüxü̃ íyauxü̃xü̃ rü Babiróniããnewa nagagüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Rü yexguma Babiróniãwa Yudíugüxü̃ nagagüguwena, rü Yeconía nane ga Charatíe nabu. Rü nüma ga Charatíe rü Chorobabénatü nixĩ ");
INSERT INTO tcaNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Rü Chorobabé rü Abiúnatü nixĩ. Rü Abiú rü Eriaquíü̃natü nixĩ. Rü nüma ga Eriaquíü̃ rü Achónatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Rü Achó rü Chadóxnatü nixĩ. Rü Chadóx rü Aquíü̃natü nixĩ. Rü nüma ga Aquíu rü Eriúnatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Rü Eriú rü Ereachánatü nixĩ. Rü Ereachá rü Matáü̃natü nixĩ. Rü nüma ga Matáü̃ rü Acóbunatü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Rü Acóbu rü Yúchenatü nixĩ. Rü nüma ga Yúche rü María ngĩte nixĩ. Rü ngima ga María rü Ngechuchu ya Cristu naẽ iyixĩ. Rü guma Ngechuchuxü̃ nixĩ ga naxunetaxü̃ ga Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Rü yemaãcü Abráü̃wa inaxügü ga yema duü̃xü̃gü rü 14 nixĩ ñu̱xmata Dabíwa nangu. Rü yemawena to ga 14 inaxügü ga Dabíwa rü ñu̱xmata Babiróniãcü̱̃ã̱x ga churaragü Yudíugüxü̃ íyauü̃xguwa nangu. Rü yemawena to ga 14 inaxügü ga yexguma Yudíugüxü̃ ínayauü̃xguwena rü ñu̱xmata Cristu buxguwa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Rü ñaãcü nixĩ ga yexguma nabuxgu ga Ngechuchu. Rü naẽ ga María rü marü Yúchemaã ixãtechaü̃. Natürü naxü̃pa ga nügüna na nangugüxü̃ rü marü Tupanaãẽ i Üünexü̃ãrü ĩnüãxü̃́ ixãxãcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Rü Yúche ga María ngĩtechaü̃ ixĩcü rü wüxi ga mecü nixĩ. Rü yemacèx tama nanango̱xẽẽchaü̃ ga yema na naxãxãcüxü̃ ga María. Rü nagu narüxĩnü ga bexmamare ngĩxü̃ na ínatáxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Rü yexguma yemagu ínaxĩnüyane, rü wüxi ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃, rü nanegüwa naxcèx nango̱x rü namaã nidexa. Rü ñanagürü nüxü̃: —Pa Yúche Pa Dabítanüxü̃x, ¡tãxṹ i ngĩxü̃ cuxoxü̃ i María na ngĩmaã cuxãmaxü̃! Erü Tupanaãẽ i Üünexü̃ ngĩxna ĩnüxü̃gagu nixĩ i naxãxãcüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","—Rü ngĩma tá ngĩxü̃́ nangẽxma ya wüxi ya ngine, rü cuma rü tá Ngechuchugu cunaxüéga. Rü ngẽma nae̱ga rü ‘maxẽẽruxü̃’ ñaxüchiga nixĩ, erü nüma tá norü pecadugüwa ínananguxü̃xẽẽ i norü duü̃xü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Rü guxü̃ma ga yema orearü ngeruü̃ nüxü̃ ixuxü̃ rü nangupetü na yanguxü̃cèx ga Cori ga Tupanaãrü ore ga nuxcümaü̃xü̃ ga norü orearü uruü̃wa nüxü̃ yaxuxü̃ ga ñaxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Rü tá tauemacü ngĩxü̃ inayarütaxu i ngẽma nge i taguma yatüxü̃ cuèxcü. Rü tá nayatü. Rü Emanue̱ tá nixĩ i nae̱ga. Rü ngẽma nae̱ga rü ‘Tupana tatanüwa nangu’, ñaxü̃chiga nixĩ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Rü yexguma pewa nabèi̱ãchigu ga Yúche, rü nanaxü ga yema Tupanaãrü orearü ngeruü̃ ga daxũcü̱̃ã̱x namaã nüxü̃ ixuxü̃. Rü Maríamaã naxãmèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Natürü taguma ngĩxü̃nexü̃ nacuèx ñu̱xmata nabu ga guma ngĩne. Rü Ngechuchugu nanaxüéga. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Rü Ngechuchu rü Yudéaanewa yexmane ga ĩãne ga Beréü̃gu nabu ga yexguma Erode ãẽ̱xgacü ixĩxgu ga yema nachiü̃ãnewa. Rü yexguma nixĩ ga ĩãne ga Yerucharéü̃wa nangugüxü̃ ga ñuxre ga yatügü ga nüxü̃ cuèxüchigüxü̃ ga woramacuriwa ngúexü̃ ga yaxü̃wa ne ĩxü̃ ga üèxcü ne ũxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Rü duü̃xü̃güna nacagüe, rü ñanagürügü: —¿Ngextá nixĩ i nangẽxmaxü̃ ya yima Yudíugüarü ãẽ̱xgacü ya ngexwacèx bucü? Toma rü yéama tochiü̃ãnewa nüxü̃ tadau ya norü woramacuri rü ngẽmacèx núma taxĩ na nüxü̃ tayarücuèxüü̃güxü̃cèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Rü yexguma yemachigaxü̃ nacuèxgu ga ãẽ̱xgacü ga Erode rü poraãcü naxoegaãẽ. Rü guxü̃ma ga duü̃xü̃gü ga Yerucharéü̃cü̱̃ã̱xgü rü ta naxoegaãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Rü yexguma ga ãẽ̱xgacü ga Erode rü naxcèx nangema ga guxü̃ma ga paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃. Rü nüxna naca, rü ñanagürü: —¿Ngexta nixĩ i nabuégaxü̃ ya Cristu? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Rü nümagü nanangãxü̃gü, rü ñanagürügü: —Nuã Yudéaanewa ngẽxmane ya ĩãne ya Beréü̃gu tá nixĩ i nabuxü̃. Yerü nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ rü nachiga nanaxümatü, rü ñanagürü ga yema ore: ");
INSERT INTO tcaNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Rü Beréü̃ ya ĩãne ya Yudéaanewa ngẽxmane, rü yima rü tama wüxi ya ngexnerüǘnemare ya ĩãne nixĩ, erü nagu tá nabu i ngẽma ãẽ̱xgacü i taxü̃ i Cristu. Rü nüma tá nüxna nadau i guxü̃ma i Tupanaãrü duü̃xü̃gü i Yudíugü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Rü yexguma ga ãẽ̱xgacü ga Erode rü bexma naxcèx naca ga yema yatügü ga nüxü̃ cuèxüchigüxü̃ ga yaxü̃wa ne ĩxü̃. Rü nüxna naca ga tèxacü rü ngunexü̃ na nangóxü̃ ga noxri ga guma woramacuri. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Rü ñu̱xũchi ga Erode rü Beréü̃wa nanamugü ga yema yatügü. Rü ñanagürü nüxü̃: —¡Rü nge̱ma pexĩ rü meã naxcèx peyadèu̱x i ngẽma buxü̃. Rü ngẽxguma nüxü̃ ipeyangauxgu rü chomaã nüxü̃ pixu na choma rü ta nge̱ma chaxũxü̃cèx, na nüxü̃ chayarücuèxüü̃xü̃cèx i ngẽma buxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Rü yexguma yema orexü̃ naxĩnüẽguwena, rü inaxĩãchi ga yema yatügü. Rü guma woramacuri ga noxri nüxü̃ nadaugücü rü napẽ́xegu nixũchigü rü ñu̱xmata guma bucü ga Ngechuchu íyexmaxü̃e̱tüwa nangu. Rü yéma nayachaxãchi. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Rü yexguma guma woramacurixü̃ nadaugügu ga yema yatügü, rü poraãcü nataãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Rü nagu nichocu ga guma ĩ ga nawa nayexmane, rü yexma nüxü̃ nayangau ga guma bucü ngĩmaã ga naẽ ga María. Rü guma bucüpegu nacaxã́pü̱xügü, rü nüxü̃ nicuèxüü̃gü. Rü ñu̱xũchi nayawãxna ga norü baúxacügü, rü õxchanana nanaxãmaregü ga uiru rü pumaragü ga yixichixü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Rü yemawena, ga yexguma napeeyane ga yema yatügü, rü nanegüwa Tupana nayaxucu̱xẽgü na tama Erodecèx nawoeguxü̃cèx. Rü yemacèx to ga namagu nachiü̃ãnecèx nawoegu. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Rü yexguma marü íyaxĩxguwena ga yema yatügü rü wüxi ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃, rü nanegüwa Yúchecèx nango̱x, rü ñanagürü nüxü̃: —¡Nabèi̱xãchi rü írüda! ¡Rü ínaxũxũ namaã ya yima bucü rü naẽ rü Equituanewa naxũ! ¡Rü nge̱ma pengẽxmagü ñu̱xmatáta choma cumaã nüxü̃ chixu na ñuxgu tá cutaeguxü̃! Erü ãẽ̱xgacü i Erode rü yima bucücèx tá nadau na yamáãxü̃cèx —ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Rü yexguma ga Yúche rü nabèi̱xãchi rü ínarüda. Rü yexgumatama chütacü namaã inaxũãchi ga guma bucü ga Ngechuchu rü naẽ. Rü Equituanewa naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Rü Equituanewa nayexmagü ñu̱xmata nayu̱x ga ãẽ̱xgacü ga Erode. Rü yemaãcü nangupetü na yanguxü̃cèx ga Tupanaãrü ore ga nuxcümaü̃cü ga norü orearü uruü̃ nüxü̃ ixuxü̃ ga ñaxü̃: “Naxcèx changema ya Chaune rü Equituanena chanataeguxẽẽ”, ñaxü̃ ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Rü yexguma ãẽ̱xgacü ga Erode nüxü̃ cuèxgu ga to ga namagu na nawoeguxü̃ ga yema yatügü ga nüxü̃ cuèxüchigüxü̃ ga yaxü̃wa ne ĩxü̃, rü poraãcü nanu. Rü Beréü̃wa nanamugü ga norü churaragü na guxü̃ ga yema naãnewa tüxü̃ nadèi̱xü̃cèx ga guxãma ga guxema buxegü ga iyatüxe ga yexwacèx buexe rü ñu̱xmata taxre ga taunecü tüxü̃́ yexmagüxewa nangu. Yerü yema yatügü ga yaxü̃wa ne ĩxü̃ rü marü nüxü̃ nixugügü rü taxre ga taunecü nixĩ ga noxri na nangóxü̃ ga guma woramacuri. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Rü yemaãcü ningu ga ore ga nuxcümaü̃xü̃ ga Tupanaãrü orearü uruü̃ ga Yeremíã ümatüxü̃ ga ñaxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Rü Ramáwa nüxü̃ taxĩnüẽ i wüxi i naga i poraãcü ngechaü̃gaãcüma auxexü̃. Rü Raquera iyixĩ i ngĩxãcügücèx poraãcü auxcü. Rü taxuacüma ngĩxü̃ tataãẽxẽẽe̱ga, erü nayue i ngĩxãcügü”, ñanagürü ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Natürü yexguma marü nayu̱xguwena ga ãẽ̱xgacü ga Erode, rü Equituanewa rü wüxi ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃ rü nanegüwa Yúchecèx nango̱x. Rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Pa Yúchex, ¡írüda, rü pechiü̃ãnecèx namaã pewoegu ya yima bucü ya Ngechuchu! Erü marü nayue i ngema duü̃xü̃gü ya yima bucüxü̃ imèxgüchaxü̃xü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Rü yexguma ga Yúche rü ínarüda rü nachiü̃ãnecèx namaã nataegu ga guma bucü rü naẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Natürü yexguma Yúche nüxü̃ cuáchigagu na Aqueránu ãẽ̱xgacüxü̃ ingucuchixü̃ nanatü ga Erodechicüü ga Yudéaanewa, rü namuü̃ ga Yúche ga yéma na naxũxü̃. Yerü wüxi ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃ nanegüwa nanaxucu̱xẽ na tama yéma Yudéaanewa na naxũxü̃cèx. Rü yemacèx Gariréaanewa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Rü yexguma Gariréaanewa nangugügu, rü ĩãne ga Nacharétuwa naxĩ, rü yexma naxãchiü̃gü. Rü yemaãcü nangupetü na yanguxü̃cèx ga yema ore ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü nüxü̃ ixugüxü̃ ga ñaxü̃: “Ngechuchu ya Cristu rü Nacharétucü̱̃ã̱xmaã tá nanaxugü”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Rü yexguma Nacharétuwa nayexmagu ga Ngechuchu, rü Cuáü̃ ga baiü̃xẽẽruü̃ inanaxügü ga Tupanaãrü orexü̃ na yaxuxü̃ ga Yudéaanewa ga dauxchitawa ngextá taxúema íxãpataxü̃wa. Rü duü̃xü̃gümaã nüxü̃ nixu rü ñanagürü: —¡Nüxü̃ perüxoe i pecüma i chixexü̃! Erü marü ningaica na perü ãẽ̱xgacü na yiĩxü̃ ya Tupana —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Rü guma Cuáü̃ ga baiü̃xẽẽruü̃chiga nixĩ ga naxümatüãxü̃ ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ichaxía ga yexguma ñaxgu: “Rü dauxchitawa i ngextá taxúema íxãpataxü̃wa tá nangẽxma i wüxi i duü̃xü̃ i nge̱ma tagaãcü ñaxü̃: ‘¡Pegü pemexẽẽ̱x naxcèx ya Cori! ¡Rü naxcèx ipeyanawẽ́xãchixẽẽ̱x i perü maxü̃!’ ” ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Rü naxchiru ga Cuáü̃ rü cameyutèxanaxcèx nixĩ, rü norü goyexü̃ rü naxchèxmünaxcèx nixĩ. Rü beruremaã rü munümaã naxãwemü. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Rü yéma Cuáü̃xü̃tawa inayarüxĩnüẽgüxü̃ ga duü̃xü̃gü ga Yerucharéü̃cü̱̃ã̱x, rü duü̃xü̃gü ga guxü̃ ga Yudéaanewa ne ĩxü̃, rü duü̃xü̃gü ga natü ga Yudáü̃ãrü ngaicamagu ãchiü̃güxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Rü guxema duü̃xẽgü ga nüxü̃ ixugüexe ga tümaãrü pecadugü, rü Cuáü̃ rü tüxü̃ ínabaiü̃xẽẽ ga natü ga Yudáü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Natürü yexguma Cuáü̃ nüxü̃ dèu̱xgu ga naxü̃tawa na nangugüxü̃ ga muxü̃ma ga ãẽ̱xgacügü ga Parichéugü rü Chaduchéugü na ínabaiü̃xẽẽãxü̃cèx, rü Cuáü̃ ñanagürü nüxü̃: —Pa Ãxtapearü Duü̃xü̃güx, ¿rü texé pemaã nüxü̃ tixu na naxchaxwa pibuxmüxü̃cèx i ngẽma Tupanaãrü poxcu i ãũcümaxü̃ i marü ingaicaxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","—¡Rü penaxwèxe na Tupana naxwèxexü̃ãcüma pemaxẽxü̃ na ngẽmaãcü guxü̃ma i duü̃xü̃gü nüxü̃ nadaugüxü̃cèx na aixcüma marü nüxü̃ perüxoexü̃ i ngẽma pecüma i chixexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","—Erü Tupanapẽ́xewa rü taxuwama name na pegü pixuxü̃ na Abráü̃tanüxü̃ i Yudíugü pixĩgüxü̃ erü tama ngẽmacèx nixĩ ya Tupana i duü̃xü̃güxü̃ nayaxuxü̃. Rü pemaã nüxü̃ chixu rü ngẽxguma Tupana naxwèxegu, rü tama nüxü̃́ naguxcha na daa nutawa Abráü̃tanüxü̃ nanguxü̃xẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","—Rü Tupanaãrü yuema rü marü íimemare na nadaxü̃xü̃cèx i ngẽma nanetügü i tama mexü̃. Rü guxü̃ma i nanetügü i chixearü õṍxü̃ rü tá nadaxü̃, rü ñu̱xũchi tá ínagu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Rü ñanagürü ta ga Cuáü̃: —Choma rü aixcüma dexáwamare pexü̃ íchabaiü̃xẽẽ na togü i duü̃xü̃gü nüxü̃ cuáxü̃cèx na aixcüma marü nüxü̃ perüxoexü̃ i pecüma i chixexü̃. Natürü choweama tá ínangu i to i Tupanaãrü orearü uruü̃. Rü nüma tá pexü̃tawa nanamu i Tupanaãẽ i üünexü̃ na naporaexẽẽãxü̃ i ngẽma Tupanawe rüxĩxü̃, rü nüma tá nanapoxcue i ngẽma Tupanaxü̃ oexü̃. Erü nüma rü poraãcü choxü̃ narüyexera na ãẽ̱xgacü yiĩxü̃. Rü choma rü napẽ́xewa rü taxuwama chame rü bai i norü chapatuarü ngewaxüra chame. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","—Rü nüma rü marü ínamemare na ñoma i naãnewa yadexechiãxü̃cèx i norü duü̃xü̃gü ñoma wüxi i yatü trigu naã́tüna idexechixü̃rüü̃. Rü ngẽmaãcü tá nayadexechi i ngẽma noxrü ixĩgüxü̃ na naxü̃tawa nangẽxmagüxü̃cèx, natürü ngẽma tama noxrü ixĩgüxü̃ rü tá ínanagu nawa ya yima üxü ya taguma ixoxü̃ne —ñanagürü ga Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Rü yexguma nixĩ ga Gariréaanewa ne naxũxü̃ ga Ngechuchu. Rü Cuáü̃xü̃tawa nanguxü̃ ga Yudáü̃ ga natüwa, na Cuáü̃ ínabaiexẽẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Rü noxri rü tama Ngechuchuxü̃ ínabaiexẽẽchaü̃ ga Cuáü̃. Rü ñanagürü nüxü̃: —Choxü̃ waxi nixĩ i namexü̃ na ícubaiexẽẽxü̃. ¿Rü ñuxãcü i cuma i chauxü̃tawa cuxũxü̃ na choma cuxü̃ íchabaiexẽẽxü̃cèx? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —Name nixĩ i choxü̃ ícubaiexẽẽ i ñu̱xmax. Erü name nixĩ i tanaxü i guxü̃ma i ngẽma Tupana tüxü̃ muxü̃ —ñanagürü. Rü yexguma ga Cuáü̃ rü: —Ngü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Rü yexguma marü Cuáü̃ Ngechuchuxü̃ íbaiexẽẽguwena, rü dexáwa ínaxü̃ãchigu ga Ngechuchu. Rü yexgumatama niwãxna ga daxũguxü̃ ga naãne, rü Ngechuchu nüxü̃ nadau ga Tupanaãẽ i Üünexü̃ ga wüxi ga muxtucurüü̃ na inagoxü̃ rü nüxna na nanguxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Rü dauxü̃wa inanaxũ ga wüxi ga naga ga ñaxü̃: —Daa nixĩ ya Chaune ya nüxü̃ changechaü̃xü̃chicü, rü poraãcü namaã chataãẽxü̃chicü —ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Rü yemawena rü Tupanaãẽ i Üünexü̃ rü wüxi ga nachica ga ngextá taxúema íxãpataxü̃wa Ngechuchuxü̃ naga na yéma Chataná nüxü̃ üxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Rü taguma nachibü ga 40 ga ngunexü̃ rü 40 ga chütaxü̃. Rü yemawena rü nataiya. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Rü yexguma ga ngoxo ga Chataná rü Ngechuchuxü̃tawa nangu, na nüxü̃ naxüxü̃cèx. Rü ñanagürü nüxü̃: —Ega aixcüma Tupana Nane quixĩgu, ¡rü daa nutagüxü̃ namu na pãũxü̃ nanguxü̃xü̃cèx! —ñanagürü ga Chataná. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Natürü Ngechuchu nanangãxü̃, rü ñanagürü: —Tupanaãrü ore i ümatüxü̃ rü ñanagürü: “Tãũtáma pãũxĩca nanamaxẽxẽẽ i duü̃xü̃gü, natürü guxü̃ma i ore i Tupana nüxü̃ ixuxü̃ nixĩ i duü̃xü̃güxü̃ maxẽxẽẽxü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Rü yexguma ga ngoxo ga Chataná rü guma ĩãne ga üünene ga Yerucharéü̃wa nanaga. Rü tupauca ga taxü̃netapẽ́xegu nanamunagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Rü ñanagürü nüxü̃: —Ega aixcüma Tupana Nane quixĩgu, ¡rü nuã cugü rütáe! Erü Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Tupana tá nanamu i norü orearü ngeruü̃gü i daxũcü̱̃ã̱x na cuxna nadaugüxü̃cèx. Rü naxmẽ́xmaã tá cuxü̃ niyauxgü na tama ṯacü rü nutagu cunguxü̃cèx”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Rü Tupanaãrü ore i ümatüxü̃ rü ñanagürü ta: “¡Tama name i nüxü̃ na cuxüxü̃ ya Cori ya curü Tupana!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Rü yexguma wenaxãrü ga ngoxo ga Chataná rü wüxi ga mèxpǘne ga máxpü̱xüchinetapẽ́xewa nanaga. Rü yéma Ngechuchuxü̃ nanawẽ́x ga guxü̃ma ga nachiü̃ãnegü na ñuxãcü yamexẽchixü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Rü Chataná rü ñanagürü nüxü̃: —Choma chi cuxna chanaxã i guxü̃ma i ñaã cuxü̃ chawéxü̃ i ngẽxguma chi chopẽ́xegu cucaxã́pü̱xügu rü choxü̃ quicuèxüü̃gu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Choxna ixũgachi, Pa Chatanáx! Erü Tupanaãrü ore i ümatüxü̃ rü ñanagürü: “¡Nüxü̃ icuèxüü̃ ya Cori ya curü Tupana, rü yimaãxü̃́xĩcatama napuracü!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Rü yexguma ga ngoxo ga Chataná rü Ngechuchuna nixũgachi. Rü Ngechuchuxü̃tawa nangugü ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃gü. Rü Ngechuchuxü̃ narüngü̃xẽẽgü rü nüxna nadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Rü yexguma Ngechuchu nüxü̃ ĩnügu ga na napoxcuxü̃ ga Cuáü̃ ga baiü̃xẽẽruü̃, rü Gariréaanewa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Natürü tama ĩãne ga Nacharétugu narüxã̱ũ̱x, rü ĩãne ga Capernáũwa naxũ na yexma yaxãchiü̃xü̃cèx. Rü guma ĩãne rü naxtaxa ga Gariréacutüwa nayexma ga Chaburã́ũtanüxü̃ rü Netarítanüxü̃ ga duü̃xü̃gü ixãchiü̃güxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Rü yema nangupetü na yanguxü̃cèx ga ore ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ichaxía ümatüxü̃ ga ñaxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Rü duü̃xü̃gücèx tá nango̱x i wüxi i ngóonexẽẽruü̃ i Chaburã́ũãrü naãnewa, rü Netaríarü naãnewa, rü Yudáü̃ãrü tocutüwa rü ngẽma nama i taxtücutüwa nadaxü̃wa, rü Gariréaanewa i ngextá duü̃xü̃gü i tama Yudíugü ixĩgüxü̃ ixãchiü̃güxü̃wa. Rü ngẽmaãcü i ngẽma duü̃xü̃gü ga noxri ẽãnexü̃wa yexmagüxü̃, rü tá nüxü̃ nadaugü i wüxi i taxü̃ i ngóonexẽẽruü̃. Rü ngẽma duü̃xü̃gü ga noxri yutüü̃wa yexmagüxü̃ rü tá nüxü̃ nabaxi i ngẽma ngóonexẽẽruü̃”, ñanagürü ga yema Ichaxíaarü ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Rü yexgumaü̃cüü nixĩ ga inaxügüãxü̃ ga Ngechuchu ga nüxü̃ na yaxuchigaxü̃ ga norü ore ga ñaxü̃: —¡Nüxü̃ perüxoe i pecüma i chixexü̃! Erü marü ningaica na perü ãẽ̱xgacü na yiĩxü̃ ya Tupana —ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Rü yexguma naxtaxa ga Gariréaanacügu yaxũxgu ga Ngechuchu, rü yéma nüxü̃ nadau ga taxre ga yatü ga nügüeneẽgü ixĩgüxü̃. Rü wüxi rü Chimáũ ga Pedrugu ãe̱gaxü̃ nixĩ. Rü to rü Aü̃drégu ãe̱gaxü̃ nixĩ. Rü nümagü rü ínapüchaegü, yerü woetama püchaetanüxü̃ nixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Chowe perüxĩ! Rü chorü puracüwa tá pexü̃ chamugü na chauxü̃tawa penagagüxü̃cèx i duü̃xü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Rü yexgumatama ga yema taxre, rü yéma nanatèxgü ga norü püchagü. Rü Ngechuchuwe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Rü yéamaxü̃ra naxũ ga Ngechuchu, rü yéma nüxü̃ nadau ga to ga taxre ga nügüeneẽgü. Rü Acobu nixĩ ga wüxi, rü Cuáü̃ nixĩ ga to. Rü Zebedéu nanegü nixĩ ga nümagü. Rü nanatümaã wüxi ga nguewa nayexmagü. Rü yéma ínanangáitagü ga norü püchagü. Rü Ngechuchu naxcèx naca. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Rü yexgumatama yéma nguewa tüxü̃ natèxgü ga nanatü. Rü Ngechuchuwe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Rü guxü̃ ga Gariréaanegu nixũgüchigü ga Ngechuchu. Rü wüxichigü ga ĩãnewa, rü duü̃xü̃güarü ngutaquẽ́xepataü̃wa ningu̱xẽẽtaechigü. Rü duü̃xü̃gümaã nüxü̃ nixuchiga ga ore ga mexü̃ na ñuxãcü ãẽ̱xgacü yiĩxü̃ ya Tupana. Rü guxü̃ma ga duü̃xü̃gü ga yema iḏaaweexü̃ rü nanameẽxẽẽ ga woo nañuxraü̃xü̃ ga norü ḏaawe nüxü̃́ yexmaxü̃, rü naxcèx nitaanegü. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Rü Ngechuchuxü̃ nacuáchigagü ga guxü̃ma ga duü̃xü̃gü ga Chíriaanecü̱̃ã̱x. Rü naxü̃tawa nanagagü ga nagúxü̃raü̃xü̃ ga ḏaxweanemaã iḏaaweexü̃. Rü yematanüwa nayexma ga duü̃xü̃gü ga ngúanemaã iḏaaweexü̃, rü duü̃xü̃gü ga poraãcü naxü̃newa nangúxü̃, rü duü̃xü̃gü ga ngoxo nawa yexmaxü̃, rü duü̃xü̃gü ga óxwaã̱xgüxü̃, rü duü̃xü̃gü ga naw̱ãĩxãchigüxü̃. Rü Ngechuchu nanameẽxẽẽ ga guxü̃ma ga yema. ");
INSERT INTO tcaNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Rü Ngechuchuwe narüxĩ ga muxü̃ma ga duü̃xü̃gü ga Gariréaanecü̱̃ã̱x, rü Decaporíchiuanecü̱̃ã̱x rü Yerucharéü̃cü̱̃ã̱x, rü Yudéaanecü̱̃ã̱x, rü natü ga Yudáü̃ãrü tocutücü̱̃ã̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga yema muxü̃ma ga duü̃xü̃gü, rü wüxi ga mèxpǘnewa ínaxü̃ãchi namaã ga norü ngúexü̃gü. Rü yéma narüto, rü norü ngúexü̃gü nüxü̃ ínachomaẽguãchi. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Rü inanaxügü ga Ngechuchu ga na nangúexẽẽãxü̃, rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Tataãẽgü ya yíxema nüxü̃ icuèxãchitanüxẽ i tümaãrü pecadu rü nüxü̃ rüxoexe. Erü tümacèx nixĩ i ngema daxũguxü̃ i naane i Tupana ãẽ̱xgacü íxĩxüwa. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","—Tataãẽgü ya yíxema ngechaü̃güxe, erü Tupana tá tüxü̃ nataãẽxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","—Tataãẽgü ya yíxema tama tügü icuèxüxü̃güxe, erü tá tanayauxgü i ñoma i naãne i Tupana tümamaã ixunetaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","—Tataãẽgü ya yíxema poraãcü tüxü̃́ nangúchaü̃xẽ na Tupanapẽ́xewa meã tamaxẽxü̃, erü Tupana tá tüxna nanaxã i ngẽma maxü̃ i mexü̃ i naxcèx tadaugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","—Tataãẽgü ya yíxema togü i duü̃xü̃gü tüxü̃́ ngechaü̃tümüü̃güxe, erü tümagü rü tá ta Tupanaãxü̃́ tangechaü̃tümüü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","—Tataãẽgü ya yíxema tama chixexü̃gu rüxĩnüẽxẽ i tümaãẽwa, erü yíxemagü tá tixĩgü ya Tupanaxü̃ daugüxe. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","—Tataãẽgü ya yíxema togüarü chogüruü̃ ixĩgüxe, erü Tupana rü nanegümaã tá tüxü̃ naxu. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","—Tataãẽgü ya yíxema togü i duü̃xü̃gü tümachi aiexe naxcèx na Tupana naxwèxexü̃ãcüma meã tamaxẽxü̃. Erü tümacèx nixĩ i ngema daxũguxü̃ i naane i Tupana ãẽ̱xgacü íxĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","—Petaãẽgü i pema ega duü̃xü̃gü ṯacü pemaã ixugüegu, rü chixri pemaã namaxẽgu, rü chaugagu doramaã poraãcü chixri pechiga yad exagügu. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","—¡Rü petaãẽgüama rü tama pexoegaãẽgü! Erü daxũguxü̃ i naãnewa tá penayauxgü i wüxi i perü ãmare i mexẽchixü̃. Rü ngẽma ñu̱xma pexü̃ ngupetüxü̃rüü̃ nixĩ ga nüxü̃ nangupetüxü̃ ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü, yerü ga duü̃xü̃gü rü naxchi rü ta naxaie. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","—Pema rü ñoma yucürarüü̃ pixĩgü i ñoma i naãnewa. Erü yima yucüra rü õna na namexẽẽxü̃rüü̃, rü ngẽxgumarüü̃ ta i pema rü ñoma i naãnecü̱̃ã̱x i duü̃xü̃güarü mexẽẽruü̃ pixĩgü. Natürü ngẽxguma chi nangeacagu ya yucüra, ¿rü ṯacüwa chi i namexü̃ i ngẽxgumax? Rü dücax, rü taxuwama name, rü ítanatèxmare, rü nge̱ma duü̃xü̃gü nawa nangagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","—Pema rü ñoma i naãnecü̱̃ã̱xãrü ngóonexẽẽruü̃ pixĩgü. Rü wüxi ya ĩãne ya wüxi ya mèxpǘnewa ngẽxmane, rü taxuacüma inicu̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","—Rü taxúema wüxi i omüwa tanangixichi na wüxi i caichã́ũtüü̃gu na tayaxücuchixü̃cèx. Natürü wüxi i omüwa tanangixichi na norü üchicaü̃gu tanaxünagüxü̃cèx, na nge̱ma tüxü̃ nabaxixü̃cèx ya guxãma ya yíxema yima ĩwa ngẽxmagüxe. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","—Rü name nixĩ i duü̃xü̃güpẽ́xewa na meã pemaxẽxü̃. Erü ngẽmaãcü i pema rü omügürüü̃ tá pinaĩgü. Rü ngẽmaãcü duü̃xü̃gü tá nüxü̃ nadaugü i ngẽma mexü̃ i pexüxü̃, rü tá nüxü̃ nicuèxüü̃gü ya Penatü ya daxũwa ngẽxmacü. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","—Tama name i nagu perüxĩnüẽ na núma chaxũxü̃ na ichayanaxoxẽẽxü̃cèx i Tupanaãrü mugü ga Moĩché ümatüxü̃, rü yema ore ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü namaã ngu̱xẽẽtaegüxü̃. Natürü núma chaxũ na meã chayanguxẽẽxü̃cèx i ngẽma mugü, rü tama na ichayanaxoxẽẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","—Rü aixcüma pemaã nüxü̃ chixu, rü ñu̱xma na tama nangupetüxü̃ i daxũguxü i naane rü ñoma i naãne rü taxucürüwa naxüchicüxü i ngẽma mugü, rü bai i írarüwa ñu̱xmatáta yangu i guxü̃ma i ngema mugü nüxü̃ nixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","—Rü ngẽmacèx ya yíxema tama naga ĩnüxẽ i ngẽma mugü, rü woo i ṯacü i íraxü̃ i ngéma nüxü̃ yaxuxü̃ rü duü̃xü̃güxü̃ tangúexẽẽ̱xgu na nümagü rü ta tama naga naxĩnüẽxü̃cèx, rü yíxema rü tá guxü̃ãrü yexera wixweama tatèx i Tupana ãẽ̱xgacü íixĩxü̃wa. Natürü yíxema naga ĩnüxẽ i Tupanaãrü mugü rü duü̃xü̃güxü̃ ngúexẽe̱xẽ na tümagü rü ta naga taxĩnüẽxü̃cèx, rü guxü̃pẽ́xewa tá taxü i Tupana ãẽ̱xgacü íixĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","—Rü pemaã nüxü̃ chixu, rü ngẽxguma tama Parichéugü rü ngúexẽẽruü̃gü i ore i mugüwa ngu̱xẽẽtaegüxü̃ãrü yexera meã pemaxẽgu, rü tagutáma Tupana íngexmaxü̃wa pichocu. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","—Pema rü marü nüxü̃ pexĩnüẽ ga Moĩchéarü ore ga nuxcümaü̃güxü̃ ga duü̃xü̃gümaã nüxü̃ yaxuxü̃ ga ñaxü̃: “¡Tãxṹ i pemáẽtagüxü̃! Erü texé yamáẽtaxe rü tá tapoxcu”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","—Natürü choma rü pemaã nüxü̃ chixu rü texé ya tümaẽneẽmaã nuxẽ, rü tá tapoxcu. Rü texé ya ṯacü tümaẽneẽmaã ixugüxe, rü ãẽ̱xgacügüpẽ́xewa tá tüxü̃ nagagü na tüxü̃ napoxcuxü̃cèx. Rü texé ya tümaẽneẽxü̃ ngoxo wogüxe, rü ãũcümaxü̃wa tangẽxma, erü ngürüãchi tá tapoxcu nagu ya yima üxü ya ngoxo nagu poxcuene. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","—Rü ngẽxguma tupaucawa Tupanana cunaxãxgu i curü dĩẽru, rü nge̱ma nüxna cucuèxãchigu na ṯacücèx cumaã nanuxü̃ i cueneẽ, ¡rü ngẽxma tupaucagutama naxü i ngẽma curü ãmare i Tupanana cuxãxchaü̃xü̃! ¡Rü cueneẽxü̃tawa naxũ, rü namaã yamexẽẽxĩra i ngẽma cuxchi na naxaixü̃! Rü ngẽmawena rü marü name i tupaucacèx cutaegu na Tupanana cuyaxãmarexü̃cèx i curü dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","—Rü ngẽxguma chi wüxie wüxi i ngetanücèx cuxü̃ íxuaxü̃gu, rü ãẽ̱xgacüxü̃tawa cuxü̃ tagaxgu, rü name nixĩ i namawatama tüxü̃ curüngüxmüxẽẽ na tama ãẽ̱xgacüpẽ́xewa cuxü̃ tagaxü̃cèx. Erü wüxicana na ãẽ̱xgacüxü̃tawa cunguxü̃, rü ãẽ̱xgacü tá purichíagüna cuxü̃ namu na cuxü̃ napoxcuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","—Rü aixcüma cumaã nüxü̃ chixu rü tãũtáma nge̱ma poxcupataü̃wa ícunguxuchi ñu̱xmatáta ngĩxü̃ cuxütanü i gu̱xcü i ngẽma dĩẽru i nüxü̃́ ngĩxü̃ cungetanücü. Rü name nixĩ i paxa Tupanana peca na pexü̃́ nüxü̃ nangechaü̃xü̃cèx i perü pecadugü na tama pexü̃ napoxcuexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","—Pema marü nüxü̃ pexĩnüẽ ga Tupanaãrü mu ga Moĩché nuxcüma nüxü̃ ixuxü̃ ga ñaxü̃: “¡Tama name i naĩ i ngemaã na icupexü̃!” ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","—Natürü choma rü pemaã nüxü̃ chixu, rü yíxema texé ya wüxi i ngexü̃ dawenüxẽ rü tüxü̃́ nangúchaü̃xẽ na ngĩmaã itapexü̃, rü Tupanapẽ́xewa rü marü chixexü̃ ngĩmaã taxü i tümaãẽwa. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","—Rü ngẽxguma chi yima curü tügünexẽtü pecadu cuxü̃ üxẽẽgu rü ¡noxtacüma nayaxu rü yaxü̃gu naña! Erü narümemaẽ nixĩ na yima cuxetüxicatama iyarütaxuxü̃ na tama guxü̃ i cuxune iyarütaxuxü̃cèx nagu ya yima üxü ya ngoxogü nagu poxcuene. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","—Rü ngẽxguma chi yima curü tügünemẽ́xẽ pecadu cuxü̃ üxẽẽgu, rü name nixĩ i noxtacüma ícunadae rü yaxü̃gu cuyaña. Erü narümemaẽ nixĩ na yima cuxmẽ́xĩcatama iyarütaxuxü̃ na tama guxü̃ i cuxune iyarütaxuxü̃cèx nagu ya yima üxü ya ngoxogü nagu poxcuene. Rü ngẽmaãcü ega woo pexü̃́ naguxchagu rü name nixĩ i nüxna pixĩgachi i guxü̃ma i chixexü̃ i nagu piyixchaü̃xü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Rü ñanagürü ta ga Ngechuchu: —Moĩché rü ü̃pa nüxü̃ nixu rü yíxema tümamèxü̃ ítáxe, rü tanaxwèxe i ngĩxna tanaxã i wüxi i popera i nawa nüxü̃ tixuxü̃ na marü ngĩxü̃ ítatáxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","—Natürü choma rü pemaã nüxü̃ chixu, rü ngẽxguma wüxi ya yatü naxmèxü̃ ítèxgu, rü chi tama naĩ ya yatümaã nangẽãẽxü̃gagu yixĩgu, rü ãũcümaxü̃wa ngĩxü̃ tangẽxmaxẽẽ erü ngẽmaãcü ngürüãchi pecadu ixü. Rü yíxema ngĩmaã ãmaxẽ i wüxi i nge i marü ngĩte ngĩxü̃ ítèxcü, rü tüma rü ta pecadu taxü. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Rü ñanagürü ta ga Ngechuchu: —Pema rü marü nüxü̃ pexĩnüẽ ga Moĩchéarü ore ga nuxcümaü̃güxü̃ ga duü̃xü̃gümaã nüxü̃ yaxuxü̃ ga ñaxü̃: “Ngẽxguma Tupanae̱gagu texémaã ṯacücèx icuxunetagu, rü name nixĩ i cuyanguxẽẽ i ngẽma curü uneta”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","—Natürü choma rü pemaã nüxü̃ chixu rü tama name i texéégagu rü ẽ́xna ṯacüégagu wüxi i duü̃xü̃maã ipexuneta. Rü tama name i daxũguxü̃ i naãnee̱gagu ipexuneta, erü nge̱ma narüto ya Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","—Rü tama name i ñoma i naãnee̱gagu ipexuneta, erü Tupanaãrü cuaixcutüchica nixĩ. Rü tama name i Yerucharéü̃e̱gagu ipexuneta, erü Tupana ya guxü̃ãrü ãẽ̱xgacüarü ĩãne nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","—Rü tama name i cugüégagu icuxuneta, erü woo wüxitama i cuyae rü taxucürüwa cunaxüchicüü na nachóxü̃cèx rü ẽ́xna nawaxüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","—Rü ngẽmacèx rü ngẽxguma icuxunetagu rü narümemaẽ nixĩ i: —Ngü̃, tá chanaxü —ñaperügü, rü ẽ́xna: —Tãũtáma chanaxü —ñaperügü. Erü guxü̃ma i to i ore i namaã icuxunetaxü̃, rü ngoxo i Chatanáwa ne ũxü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Rü ñanagürü ta ga Ngechuchu: —Pema rü marü nüxü̃ pexĩnüẽ ga Tupanaãrü mu ga Moĩché nuxcüma nüxü̃ ixuxü̃ ga ñaxü̃: “Ngẽxguma texé wüxi i duü̃xü̃xü̃ icháixetüxẽẽgu, rü tümaxẽtümaãtama tayangutanüxẽẽ. Rü texé wüxi i duü̃xü̃xü̃ ibüepütagu, rü tümapütamaãtama tayangutanüxẽẽ”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","—Natürü choma rü pemaã nüxü̃ chixu rü tama name i pegütama ípepoxü̃ nüxna i duü̃xü̃ i chixecümaxü̃. Rü ngẽxguma texé cuxü̃ pechiwegu, rü marü name i curü tochiwe rü ta icunaxã na nge̱ma rü ta cuxü̃ tapechiwexü̃cèx rü tama name na cuxütanüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","—Rü ngẽxguma texé cuxü̃ íyaxuaxü̃gu rü cuxna tayapuchaxü̃gu i curü daxũ, rü name nixĩ i curü gáuxü̃chiru rü ta noxtacüma tüxna cunaxã. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","—Rü ngẽxguma texé cuxü̃ mu̱xgu na wüxi i kilómetrugu ṯacü tüxü̃́ quingexü̃cèx, rü name nixĩ i taxre i kilómetrugu tüxü̃́ cuyange. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","—Rü ngẽxguma texé curü ngẽmaxü̃cèx cuxna caxgu, rü name nixĩ i tüxna cunaxã. Rü tama name na namaã cuxaüxü̃ i curü ngẽmaxü̃gü ega texé paxaãchi cuxna naxcèx caxgu. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Rü ñanagürü ta ga Ngechuchu: —Pema rü marü nüxü̃ pexĩnüẽ ga Tupanaãrü mu ga Moĩché nuxcüma nüxü̃ ixuxü̃ ga ñaxü̃: “¡Nüxü̃ nangechaü̃ i cumücü, rü naxchi naxai i curü uwanü!” ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","—Natürü i choma rü pemaã nüxü̃ chixu rü: —¡Nüxü̃ pengechaü̃ i perü uwanügü! ¡Rü naxcèx peyumüxẽ i ngẽma duü̃xü̃gü i chixexü̃maa pewe ingexütanüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","—Rü ngẽxguma ngẽmaãcü pemaxẽgu rü aixcüma Penatü ya daxũgucü nanegü tá pixĩgü. Erü nüma rü inanabáixẽẽ ya üèxcü naxcèx i mexü̃ i duü̃xü̃gü rü chixexü̃ i duü̃xü̃gü. Rü nanapuxẽẽ naxcèx i duü̃xü̃gü i meã maxẽxü̃ rü duü̃xü̃gü i chixri maxẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","—Rü ngẽxguma chi ngẽma duü̃xü̃gü i pexü̃ ngechaü̃güxü̃xü̃xĩcatama pengechaü̃gügu, ¿rü ṯacü rü ãmare tá Tupanaxü̃tawa peyauxgü naxcèx i ngẽma? Erü ngẽma yatügü i Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ideetanüxü̃wa puracüexü̃ rü ngẽxgumarüü̃ nanaxügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","—Rü ngẽxguma chi peeneẽgüxü̃xicatama perümoxẽgu, rü guxü̃ i duü̃xü̃gürüü̃tama pixĩgü. Erü woo ngẽma duü̃xü̃gü i tama Tupanaxü̃ cuèxgüxü̃, rü ngẽxgumarüü̃tama nanaxügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","—Rü ngẽmacèx penaxw̱ae na aixcüma namexü̃ i perü maxü̃ naxrüxü̃ ya Penatü ya Tupana ya aixcüma mearü maxü̃ã́cü. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Rü ngẽxguma ṯacü rü mexü̃ pexüxchaü̃gu, rü name nixĩ i pexuãẽ na tama duü̃xü̃güpẽ́xewa penaxüxü̃ i ngẽma na duü̃xü̃gü pexü̃ dauxü̃cèx rü pexü̃ yacuèxüü̃güxü̃cèx. Erü ngẽxguma duü̃xü̃gü pexü̃ icuèxüü̃güxü̃cèx mexü̃ pexü̱xgu, rü Penatü ya daxũgucü rü tãũtáma ãmare pexna naxã. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","—Rü ngẽmacèx ngẽxguma texéxü̃ curüngü̃xẽẽchaü̃gu, rü name nixĩ i tama poraãcü nüxü̃ quixuchiga i ngẽma. Rü tama name i ngẽma duü̃xü̃gü i togüpẽ́xewa meã maxẽnetaxü̃rüü̃ na quiĩxü̃. Erü nümagü rü norü me nixĩ i ngutaquẽ́xepataü̃güwa rü ítamü̃güwa nüxü̃ nixuchiga ega ṯacü rü mexü̃ naxügügu. Rü ngẽmaãcü nanaxügü na togü meã nachiga idexagüxü̃cèx. Natürü choma rü aixcüma pemaã nüxü̃ chixu rü ngẽma na duü̃xü̃gü nüxü̃ icuèxüü̃güxü̃ nixĩ i norü ãmare, rü tãũtáma nanayauxgü i to i ãmare i Tupanaxü̃tawa. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","—Natürü i cuma rü ngẽxguma ṯacü tüxna cuxãxgu ya yíxema ngearü ngẽmaxü̃ã̱xgüxe, rü name nixĩ i taxúema cuxü̃ dauãcüma na cunaxüxü̃ i ngẽma. Rü woo cumücüxüchi rü tama name i nüxü̃ na nacuáxü̃ i ngẽma. Rü Cunatü ya daxũgucü ya nüxü̃ daucü i ngẽma cuxicatama cuxüxü̃, rü tá cuxna nanaxã i curü ãmare. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","—Rü ngẽxguma peyumüxẽgügu, rü tama name i ngẽma duü̃xü̃gü i togüpẽ́xewa meã maxẽnetaxü̃rüü̃ pixĩgü. Erü nümagü rü ngẽxguma nayumüxẽgügu, rü norü me nixĩ na chiãcü nayumüxẽgüxü̃ i ngutaquẽ́xepataü̃güwa rü ítamü̃güwa na duü̃xü̃gü nüxü̃ na daugüxü̃cèx. Rü aixcüma pemaã nüxü̃ chixu rü ngẽma na duü̃xü̃gü nüxü̃ daugüxü̃xĩcatama nixĩ i norü ãmare. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","—Natürü ngẽxguma cuyumüxẽgu, rü name nixĩ i curü ucapugu cuxücu, rü cunawãxta i curü ĩã̱x, rü nge̱ma cuyumüxẽ namaã ya Cunatü ya bexma cumaãxĩcatama nge̱ma ngẽxmacü. Rü ngẽxguma ya yima Cunatü ya Tupana ya nüxü̃ daucü i ngẽma cúãcü cuxüxü̃, rü nüma tá cuxna nanaxã i curü ãmare. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","—Rü tama name i natücèxma cunamèxẽẽ i curü yumüxẽ naxrüü̃ i ngẽma duü̃xü̃gü i tama Tupanaxü̃ cuèxgüxü̃. Erü nümagü rü nagu narüxĩnüẽ rü ngẽma na namèxẽẽgüãxü̃cèx i norü yumüxẽ rü Tupana tá nüxü̃ naxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","—Rü tama name i ngẽma duü̃xü̃gürüü̃ pixĩgü, erü woo tauta naxcèx ípecaxgu rü Penatü ya Tupana rü marü nüxü̃ nacuèx na ṯacü pexü̃́ taxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","—Rü ngẽmacèx rü ñaãcü tá peyumüxẽgü i pemax: “Pa Tonatü ya Daxũgucüx, rü aixcüma üünecü quixĩ i cumax. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","¡Rü núma naxũ na torü ãẽ̱xgacü quiĩxü̃cèx! Rü tanaxwèxe i curü ngúchaü̃ na naxügüxü̃ i duü̃xü̃gü i ñoma i naãnewa ngẽxgumarüü̃ i daxũguxü̃ i naãnewa na curü ngúchaü̃ ínaxügüxü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","¡Rü toxna naxã i torü õna i ñoma i ngunexü̃cèx ixĩxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","¡Rü toxü̃́ nüxü̃ nangechaü̃ i torü chixexü̃ i taxüxü̃ ngẽxgumarüü̃ i toma rü tüxü̃́ nüxü̃ na tangechaü̃xü̃rüü̃ ya yíxema chixexü̃ tomaã ügüxe! ");
INSERT INTO tcaNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","¡Tãxṹ i ṯacü rü chixexü̃pẽ́xewa toxü̃ cuwogüxü̃ na tama nagu tayixü̃cèx! Natürü tanaxwèxe i toxna cudau na tama ngẽma chixexü̃ taxügüxü̃cèx. Erü cuma rü guxü̃guma guxü̃ãrü ãẽ̱xgacü quixĩ rü cuporaxüchi rü cumexẽchi. Rü ngẽmaãcü yiĩ”. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","—Rü ngẽxguma pema nüxü̃́ nüxü̃ pengechaü̃gu i ngẽma duü̃xü̃gü i chixexü̃ pemaã ügüxü̃, rü Penatü ya daxũgucü rü tá ta pexü̃́ nüxü̃ nangechaü̃ i perü pecadugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","—Natürü ngẽxguma tama nüxü̃́ nüxü̃ pengechaü̃gu i ngẽma duü̃xü̃gü i chixexü̃ pemaã ügüxü̃, rü Penatü ya daxũgucü rü tá ta tãũtáma pexü̃́ nüxü̃ nangechaü̃ i perü pecadugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Rü ngẽxguma tama pechibüeãcüma peyumü̃xẽgügu rü tama name i pegü pengechaü̃chíwexẽẽ naxrüü̃ i ngẽma duü̃xü̃gü i togüpẽ́xewa meã maxẽnetaxü̃. Erü nümagü rü ngẽmaãcü nanaxügü na togü nüxü̃ na daugüxü̃cèx i ngẽma na Tupanacèx naxaureexü̃. Rü aixcüma pemaã nüxü̃ chixu rü ngẽma na duü̃xü̃gü nüxü̃ daugüxü̃xĩcatama nixĩ i norü ãmare. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","—Natürü ngẽxguma cuma rü tama cuchibüãcüma cuyumü̃xẽgu rü name nixĩ i meã cugü cuyauxchiwe rü meã cugü curüxĩxẽẽru. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","—Rü ngẽmaãcü i togü i duü̃xü̃gü rü tãxũtáma nüxü̃ nacuèxgü na tama cuchibüãcüma cuyumü̃xẽxü̃. Rü Cunatü ya bexma cumaã nge̱ma ngẽxmacüxicatátama cuxü̃ nadau, rü tá cuxna nanaxã i curü ãmare naxcèx i ngẽma cuxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","—Rü tama name i pegücèx penanutaquẽ́xe i muxü̃ma i perü meruü̃gü i ñoma i naãnewa. Erü ñoma i naãnewa rü paxama nagu̱x i perü ngẽmaxü̃gü, rü naweane rü paxama nanachixexẽẽ, rü ngĩ́tèèxgüxü̃ rü naxcèx nangĩ̱xgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","—Rü narümemaẽ nixĩ i penamuxẽẽ i perü meruü̃ i daxũguxü̃ i naãnewa. Erü nge̱ma rü tãxũtáma nagu̱x, rü naweane rü tãxũtáma nanachixexẽẽ, rü ngĩ́tèèxgüxü̃ rü tãxũtáma ngexma nachocu na naxcèx nangĩ̱xgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","—Erü ngextá ínangẽxmaxü̃wa i perü ngemaxü̃gü, rü ngẽxma nixĩ i perüxĩnüẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","—Cuxetügü rü ñoma wüxi i omürüü̃ nixĩ i cuxunecèx. Rü ngẽxguma ngẽma Tupana cuxü̃́ naxwèxexü̃cèx cudèu̱xgu, rü guxü̃ma i curü maxü̃ rü name. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","—Natürü ngẽxguma ñoma i naãneãrü ngúchaü̃cèx cudèu̱xgu, rü guxü̃ma i curü maxü̃ rü chixexü̃wa nangẽxma. Rü aixcüma nataxuma i ẽãnexü̃ i ngẽmaãrü yexera ixĩxü̃ i Tupanapẽ́xewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","—Taxucürüwa wüxi i duü̃xü̃ rü nataxrearü coriã̱x. Erü wüxi i norü corichi rü tá naxai, rü ngẽma to rü tá nüxü̃ nangechaü̃. Rü ẽ́xna wüxicèx rü tá meã napuracü, rü ngẽma to rü tá nüxü̃ naxo. Rü taxucürüwa Tupanacèx pemaxẽ, ega perü dĩẽruguama perüxĩnüẽgu. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","—Rü ngẽmacèx pemaã nüxü̃ chixu rü: ¡Tãxṹ i pexoegaãẽgüxü̃ naxcèx na ṯacü tá pengõ̱xgüxü̃ rü ṯacü tá pixaxgüxü̃, rü ṯacümaã tá na pexãxchirugüxü̃! Erü perü maxü̃ rü õnaãrü yexera nixĩ, rü pexene rü naxchiruarü yexera nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","—¡Dücèx penangugü i werigü i tama toegüchiréxü̃, rü tama nanetüarü o ibuxgüxü̃, rü ngepatagüxü̃ na ngexta namaã nanguxü̃güxü̃cèx i norü õna! Natürü Penatü ya daxũgucü rü nanaxüwemü. Rü pema rü Tupanacèx rü guxü̃ma i werigüarü yexera pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","—Rü taxuwama name na ṯacücèx pexoegaãẽgüxü̃. Erü taxucürüwa ya wüxie i pema rü wüxi i oragu rü ipenamèxãchixẽẽ i perü maxü̃ ega woo poraãcü naxcèx pexoegaãẽgügu. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","—¿Rü tü̱xcüü̃ pexoegaãẽgü naxcèx i pexchiru? ¡Dücèx penangugü i ngẽma putüragü i ngextámare yaexü̃ i tama puracüexü̃, rü tama nügü üxchirugüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","—Natürü pemaã nüxü̃ chixu rü woo guma ãẽ̱xgacü ga Charumóũ ga na namexẽchixü̃ ga naxchiru, rü taguma wüxi ga putürachacurüü̃ namexẽchi. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","—Rü ngẽxguma Tupana ngẽmaãcü nangèxãẽgu i ngẽma putüragü i ñu̱xma ngẽxmagüxü̃ natürü moxü̃ rü marü taxuxü̃, rü yexera tá pexna nadau i pemax, Pa Yatügü i Tama Aixcüma Meã Yaxõgüxü̃x. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","—Rü ngẽmacèx tama name i pexoegaãẽgü rü ñaperügügü: —¿Ṯacü tá tangõ̱xgü? rü ẽ́xna —¿ṯacü tá tixaxgü? rü ẽ́xna —¿ṯacümaã tá taxãxchirugü? —ñaperügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","—Erü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü rü naxcèx nadaugü i guxü̃ma i ngẽma pemaã nüxü̃ chixuxü̃. Natürü pema rü pexü̃́ nangẽxma ya Penatü ya daxũgucü ya nüẽchama nüxü̃ cuácü i pexü̃́ na nataxuxü̃ i guxü̃ma i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","—Natürü narümemaẽ nixĩ i Tupanacèxira pedaugü na ngẽma nüma pexü̃́ nanaxwèxexü̃xĩra pexügüxü̃cèx. Rü nae̱tü tá pexna nanaxã i guxü̃ma i ṯacü i pexü̃́ taxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","—¡Tãxṹ i naxcèx pexoegaãẽgüxü̃ i ngẽma moxü̃ tá üpetüxü̃! Erü ngẽma moxü̃ãrü ngunexü̃ rü tá nüxü̃́ nangẽxma i guxchaxü̃gü i namaã ínanguxü̃. Erü wüxichigü i ngunexü̃ rü nüxü̃́ nangẽxma i noxrütama guxchaxü̃gü, rü ngẽmacèx tama name i moxü̃ãrü guxchaxü̃gücèx pexoegaãẽgü i ñu̱xmax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Rü Ngechuchu rü ñanagürü ta: —¡Rü taxũ i togüxü̃ pixuxü̃! Rü ngẽxguma ya Tupana rü tãxũtáma pexü̃ nixu na pechixexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","—Erü ngẽxgumarüü̃ na togüxü̃ pixuxü̃ rü Tupana rü tá pexü̃ nixu na pechixexü̃. Rü ngema na togüxü̃ pepoxcuexü̃, rü ngemaãcü tátama nixĩ ya Tupana i pexü̃ napoxcuexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","—¿Rü tü̱xcüü̃ i nüxü̃ cudawenüxü̃ i ngẽma cueneẽãrü üxaxetüxü̃ i íraxü̃, ega chi tama naxcèx cuxoegaãẽgu i ngẽma cuxetüwatama ngẽxmaxü̃ i naĩpüta i taxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","—Rü ngẽxguma cuxetüwatama nangẽxmagu i wüxi i naĩpüta i taxü̃ ¿rü ñuxãcü i cueneẽxü̃ cuchixewexü̃, rü ñácuxü̃ nüxü̃: “¡Pa Chaueneẽx, cuxü̃ chanayauxchaü̃ i ngẽma curü üxaxetüxü̃!” —ñácuxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","—Pa Duü̃xü̃ i Meã Maxnetaxü̃x, rü name nixĩ i cunayauxira i ngẽma naĩpüta i cuxetüwatama ngẽxmaxü̃, rü ngẽmaãcü tá mea nüxü̃ cudau na cunayaxuxü̃cèx i ngẽma cueneẽãrü üxaxetüxü̃. Rü ngẽmacèx name nixĩ i cuxira nüxü̃ curüxo i ngẽma chixexü̃ i taxü̃ i cumatama cuxüxü̃, rü ngẽxguma tá cume na nüxü̃ curüngü̃xẽẽxü̃cèx i cueneẽ na nüxü̃ naxoxü̃cèx i ngẽma chixexü̃ i íraxü̃ i naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","—Rü tama name i Tupanaãrü ore i üünexü̃maã penachixewe i ngẽma duü̃xü̃gü i chixecümagüxü̃ i tama yaxõgüchaü̃xü̃, erü ngürüãchi ngẽmacèx tá pexü̃ nimèxgü. Rü ngẽxgumarüü̃ tama name i Tupanaãrü oremaã penachixewe i ngẽma duü̃xü̃gü i tama nüxü̃ cuèxgüchaü̃xü̃, erü tá ínanatèxgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—¡Tupanana naxcèx peca! rü nüma tá pexna nanaxã. ¡Rü Tupanaxü̃tagu naxcèx pedau! rü tá nüxü̃ ipeyangau. ¡Rü norü ĩã̱xwa: Tu tu tu, ñapegü! rü tá pexcèx nayawãxna. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","—Erü guxãma ya yíxema naxcèx íc̱axe, rü tanayaxu. Rü guxãma ya naxcèx dauxe, rü nüxü̃ itayangau. Rü guxãma ya yixema ĩã̱xwa: Tu tu tu, ñagüxe, rü tá tümacèx niwãxna. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","—Rü dücax i pemax, rü ngẽxguma chi wüxi i pexacü pãũcèx ícaxgu, rü ¿ñuxãcü chi wüxi ya nuta nüxna pexãxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","—Rü ngẽxguma chi choxnicèx pexna nacaxgu rü ¿ñuxãcü chi i ãxtape nüxna pexãxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","—Rü pema na pichixecümachiréxü̃ rü nüxü̃ pecuèx na mexü̃ i ãmare pexacügüna pexãxü̃. Natürü Penatü ya daxũgucü rü ngẽma pema pexacügüna pexãxü̃ãrü yexera tá tüxna naxã ya yíxema naxü̃tawa naxcèx íc̱axe. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","—Rü pemaã nüxü̃ chixu, rü ngẽma pema penaxwèxexü̃ i togü pemaã na naxüxü̃, rü name nixĩ i pema rü ta ngẽmaãcütama namaã penaxü. Erü ngẽmaãcü tüxü̃ namu i Tupanaãrü ore ga Moĩché ümatüxü̃ rü yema ore ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü ümatüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","—Name nixĩ i ngẽma ĩã̱x i íraxü̃waama pichocu. Erü ngẽma ĩã̱x i yuwa tüxü̃ gaxü̃ rü ngẽma nama i yuwa daxü̃ rü nata. Rü muxũchixü̃ma i duü̃xü̃gü nagu naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","—Natürü ngẽma nama i maxü̃wa nadaxü̃ rü ngẽma ĩã̱x i maxü̃cèx nawa ixücuxü̃ rü naxíra. Rü noxretama nixĩ i duü̃xü̃gü i nüxü̃ iyangaugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","—Rü naxcèx pexuãẽgü i ngẽma doratèèxgüxü̃ i nügü ixugünetaxü̃ na Tupanaãrü orearü uruü̃gü yixĩgüxü̃. Erü nümagü rü petanüwa nangugü, rü nügü mexü̃ i duü̃xü̃güneta nixĩgüxẽẽ. Natürü naãẽwa rü poraãcü chixexü̃gu narüxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","—Rü pema rü nacümawa tá nüxü̃ pecuèx i ngẽma duü̃xü̃gü, ngẽxgumarüü̃ i wüxichigü i nanetügü rü norü owa na nüxü̃ icuáxü̃rüü̃ ngoxi name rü ẽ́xna tama. Rü wüxi i torawa rü taxucürüwama ubagü tayaxu. Rü wüxi i chuchuxü̃wa rü taxucürüwama ori̱x i igu tayaxu. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","—Erü guxü̃ma i nanetü i mexü̃ rü name i norü o. Rü guxü̃ma i nanetü i chixexü̃ rü nachixe i norü o. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","—Rü wüxi i nanetü i mexü̃ rü taxucürüwama nachixe i norü o. Rü wüxi i nanetü i chixexü̃ rü taxucürüwama name i norü o. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","—Rü guxü̃ma i nanetü i tama mexü̃ i norü o rü tayadaxüchi, rü ñu̱xũchi tayagu. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","—Rü ngẽxgumarüü̃ nacümawa tá nüxü̃ pecuèx i ngẽma duü̃xü̃gü i Tupanaãrü orearü uruü̃güneta ixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","—Rü tama guxü̃ma i duü̃xü̃gü i nügü ixugüxü̃ na chorü duü̃xü̃gü yixĩgüxü̃ rü tá nichocu i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa. Natürü yíxema aixcüma Chaunatü ya daxũgucüga ĩnüẽxẽxĩcatátama tixĩ ya nge̱ma ichocuxe. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","—Rü ngẽxguma ngẽma ngunexü̃ i naãneãrü gu̱xwa nanguxgu, rü muxü̃ma i duü̃xü̃gü rü choxü̃ tá ñanagürügü: —Pa Corix, toma rü togü i duü̃xü̃gümaã nüxü̃ tixu i curü ore, rü cuégagu ítanawoxü̃ i ngoxogü, rü cuégagu tanaxü i muxü̃ma i mexü̃ i taxü̃ i Tupanaãrü poramaã taxüxü̃ —ñanagürügü tá choxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","—Natürü ngẽxguma rü tá ñacharügü nüxü̃: —Taguma chorü duü̃xü̃gü pixĩgü. ¡Rü choxna pixĩgachi i pema i chixexü̃ ügüe! —ñacharügü tá. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","—Rü ngẽmacèx ya yíxema choxü̃ ĩnüxẽ rü naxǘxe i ngẽma choma tüxü̃ chamuxü̃, rü wüxi ga yatü ga meã naãẽxü̃ cuácü ga nuta ga tacüétügu üpatacürüü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","—Rü pucü ga tacü ínangu, rü narümèx ga taxtü, rü nixũũchi ga wüxi ga tacü ga buanecü rü guma ĩgu nanguema. Natürü guma ĩ rü tama niwèxtaü̃ yerü wüxi ga nutaétügu naxü. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","—Natürü yíxema choxü̃ ĩnüxẽ rü tama naxǘxe i ngẽma choma tüxü̃ chamuxü̃, rü wüxi ga yatü ga tama naãẽxü̃ cuácü ga naxnücügumare üpatacürüü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","—Rü pucü ga tacü ínangu, rü narümèx ga taxtü, rü wüxi ga tacü ga buanecü nixũũchi rü nagu nanguema ga guma ĩ. Rü niwèxtaü̃, rü yexma nayarüxo ga guxü̃ma —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Rü yexguma yagúegagu ga Ngechuchu ga na yadexaxü̃, rü ga duü̃xü̃gü rü nabèi̱xãchiãẽgü namaã ga norü ngu̱xẽẽtae. ");
INSERT INTO tcaNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Yerü nüma rü Tupanaãrü poramaã nanangúexẽẽ, rü tama yema ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃rüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Rü yexguma guma mèxpǘnewa yanaxüegu ga Ngechuchu, rü muxü̃ma ga duü̃xü̃gü nawe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Rü Ngechuchucèx nixũ ga wüxi ga yatü ga chaxünemaã iḏaawecü. Rü Ngechuchupẽ́xegu nayacaxã́pü̱xü, rü ñanagürü nüxü̃: —Pa Corix, ngẽxguma chi cuma cunaxwèxegu, rü chi cuxü̃́ natauxcha na choxü̃ curümexẽẽxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Rü yexguma ga Ngechuchu rü nüxü̃ ningõgü, rü ñanagürü nüxü̃: —Ngü̃, chanaxwèxe. ¡Rüme! —ñanagürü. Rü yexguma yema ñaxgu ga Ngechuchu, rü naxcèx nitaane ga guma yatü ga na nachaxüneã́xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Rü Ngechuchu rü ñanagürü nüxü̃: —¡Dücèx, taxuemaã tá nüxü̃ quixu! ¡Natürü nge̱ma paixü̃tawa naxũ, rü cugü iyawẽ́x! ¡Rü nüxna naxã i ngẽma ãmare ga Moĩché tüxü̃ muxü̃ na duü̃xü̃gü nüxü̃ cuáxü̃cèx na curümexü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Rü Capernáũwa naxũ ga Ngechuchu. Rü yexguma yéma nanguxgu, rü wüxi ga churaragüarü ãẽ̱xgacü ga capitáü̃ ga Dumacü̱̃ã̱x rü Ngechuchucèx nixũ. Rü Ngechuchuxü̃ nacèèxü̃, rü ñanagürü: —Pa Corix, chorü duü̃xü̃ rü nanaw̱ãĩxãchi. Rü ngürücarewa nangẽxma i chopatawa, rü poraãcüxüchima ngúxü̃ ninge —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Rü Ngechuchu rü ñanagürü nüxü̃: —Marü tá nge̱ma chaxũ na naxcèx chayataanexẽẽxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Natürü nüma ga capitáü̃ nanangãxü̃, rü ñanagürü: —Pa Corix, choma rü taxuwama chame na chopatagu na cuxücuxü̃cèx. Rü chanaxwèxe i curü orewaxicatama nüxü̃ quixu, rü tá naxcèx nitaane i chorü duü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","—Erü choma rü ta rü chorü ãẽ̱xgacümẽ́xẽwa changẽxma. Rü cho̱xmẽ́xwa nangẽxmagü ta i ñuxre i churaragü. Rü ngẽxguma chanamu̱xgu i wüxi na ngextá naxũxü̃cèx, rü nge̱ma naxũ. Rü ngẽxguma chaugüxü̃tawa naxcèx changemagu i to, rü chauxü̃tawa nangu. Rü ngẽxguma wüxi i chorü duü̃xü̃xü̃ chamu̱xgu na ṯacü na naxüxü̃cèx, rü choxü̃́ nanaxü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Rü yexguma yemaxü̃ naxĩnügu ga Ngechuchu rü nabèi̱xãchiãẽ. Rü ñanagürü nüxü̃ ga yema duü̃xü̃gü ga nawe rüxĩxü̃: —Aixcüma pemaã nüxü̃ chixu rü taxuü̃ma i Yudíugütanüwa nüxü̃ ichayangau i wüxi i duü̃xü̃ i ñaã yatürüü̃ aixcüma yaxõxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","—Rü choma rü pemaã nüxü̃ chixu rü muxũchixü̃ i duü̃xü̃gü rü guxü̃wama tá ne naxĩ, rü Tupana ãẽ̱xgacü íixĩxü̃wa tá nachibüe namaã ya tórü o̱xigü ya Abráü̃ rü Ichaá, rü Acobu. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","—Natürü muxü̃ma i Abráü̃tanüxü̃gü i Yudíugü rü tãũtáma nichocu i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa. Rü ẽãnexü̃wa tá nawogü. Rü nge̱ma tá naxauxe, rü tá nixü̃́xchapütagü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Rü yexguma ga Ngechuchu rü ñanagürü yema capitáü̃xü̃: —¡Cupatacèx nataegu! Rü tá naxcèx nitaane i curü duü̃xü̃, erü cuyaxõ na naxcèx tá yataanexü̃ —ñanagürü. Rü yexgumatama naxcèx nitaane ga yema capitáü̃ãrü duü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Rü Pedrupatawa naxũ ga Ngechuchu. Rü yéma ngĩxü̃ nadau ga Pedru nèxẽ ga ngürücaregu irüxã̱ũ̱xcü yerü iyaxaxüne. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Rü Ngechuchu ngĩxmẽ́xgu ningõgü, rü yexgumatama igèu̱xãchi ga yema na yaxaxünexü̃. Rü íirüda ga ngĩmax. Rü ñu̱xũchi naxcèx inamexẽẽ ga õna. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Rü yexguma marü yanaxücuchaü̃gu ga üèxcü, rü Ngechuchuxü̃tawa nanagagü ga muxü̃ma ga duü̃xü̃gü ga ngoxoã̱xgüxü̃. Rü wüxitama ga oremaã Ngechuchu ínanawoxü̃ ga yema ngoxogü. Rü nanameẽxẽẽ ta ga guxü̃ma ga yema togü ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Rü yemaãcü Ngechuchu nayanguxẽẽ ga yema ore ga nuxcümaü̃xü̃ ga Tupanaãrü orearü uruü̃ ga Ichaxía nüxü̃ ixuxü̃ ga ñaxü̃: “Rü nüma rü tüxü̃ naporaexẽẽ i ngẽxguma ituraegu, rü tüxü̃ narümeexẽẽ i ngẽxguma iḏaaweegu”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga muxü̃ma ga duü̃xü̃gü na nüxü̃ íchomaẽguãchixü̃, rü norü ngúexü̃gümaã nüxü̃ nixu, rü ñanagürü: —¡Rü ngĩxã, rü naxtaxaarü tocutüwa taxĩ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Rü wüxi ga ngúexẽẽruü̃ ga ore ga mugüwa ngu̱xẽẽtaexü̃, rü Ngechuchucèx nixũ, rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃ Pa Ngechuchux, cuwe charüxũxchaü̃ i ngextá cuma ícuxũxü̃wa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Ngowagü rü nüxü̃́ nangẽxma i naxmaü̃gü, rü werigü rü nüxü̃́ nangẽxma i naxchiãü̃gü. Natürü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü nataxuma i chauchica i ngextá nagu chicuxeruxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Rü wüxi ga to ga norü ngúexü̃, rü ñanagürü nüxü̃: —Pa Corix, cuwe charüxũxchaü̃, natürü chanaxwèxe i chaunatü tüxü̃ ichayatèxira —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —¡Noxtacüma chowe rüxũ! Rü nüe̱ i ngẽma cutanüxü̃ i tama yaxõgüxü̃ iyatèxgü i ngẽma yuexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Rü yexguma ga Ngechuchu rü wüxi ga nguegu nixüe. Rü norü ngúexü̃gü rü ta ínayaxümücügü, rü inaxĩãchi. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Rü ngürüãchi naxtaxaarü ngãxü̃tügu nüxü̃ naxü ga wüxi ga buanecü ga taxüchicü. Rü guma nguewa rü niyaucuchichigü ga dexá. Natürü ga Ngechuchu rü nape. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Rü yexguma ga norü ngúexü̃gü rü ínanabèi̱xgügü, rü ñanagürügü nüxü̃: —Pa Corix, ¡toxü̃ rüngü̃xẽẽ, erü ngẽmama itabaxü̃gü! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Pa Duü̃xü̃gü i Tama Aixcüma Yaxõgüxü̃x, ¿tü̱xcüü̃ pemuü̃ẽ? —ñanagürü. Rü yexguma ga Ngechuchu rü ínarüda. Rü buanecü rü yuapena nachogü. Rü ínayachaxãchi ga buanecü, rü inayarüxo ga yuape, rü ínachaxanemare. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Rü nümagü ga norü ngúexü̃gü rü nabèi̱xãchiãẽgü, rü nügümaã ñanagürügü: —¿Ṯacü ẽ́xna nixĩ i ñaã yatü rü ngẽmacèx woo ya buanecü rü yuape rü naga naxĩnüẽxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Rü Ngechuchu rü norü ngúexü̃gü rü naxtaxaarü tocutüwa nangugü ga Gadáraarü naãnewa. Rü yexguma yéma nangugügu, rü Ngechuchucèx yéma nibuxmü ga taxre ga yatügü ga duü̃xẽchíquẽ́xetanügu yarüxauchigütanüneü̃xü̃. Rü yema taxre rü ningoxoã̱x, rü nidüraexüchi. Rü yemacèx taxucürüwama texé yéma namawa taxüpetü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Rü yema taxre rü aita naxüe, rü ñanagürügü: —¿Tü̱xcüü̃ toxü̃ nuã cuyachixewe, Pa Ngechuchu ya Tupana Nane? ¿Ẽ́xna nuã cuxũ na toxü̃ ícuyawoxü̃xü̃cèx tauta nawa nanguyane na Tupana toxü̃ poxcuexü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Rü yema nachicaarü ngaicamana nachibüe ga muxü̃ma ga cuchigü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Rü yema ngoxogü rü Ngechuchuxü̃ nacèèxü̃gü, rü ñanagürügü: —Rü ngẽxguma toxü̃ ícuwoxü̃gu, ¡rü ngẽma cuchigügu toxü̃ nachocuxẽẽ! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Rü yexguma ga Ngechuchu, rü ñanagürü nüxü̃: —Ẽcü, ¡nge̱ma pexĩ! —ñanagürü. Rü yexguma ga yema ngoxogü rü ínachoxü̃ nawa ga yema taxre ga yatügü, rü yema cuchigügu nayachocu. Rü ñu̱xũchi guxü̃ma ga yema cuchigü rü inaxü̃ãchi, rü naxtaxacutüarü mèxpǘxü̃wa nayarüyuxgü, rü yexma nayi. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","—Rü yema cuchigüarü dauruü̃gü rü nabèi̱xãchiãẽgü, rü ĩãnecèx nibuxmü. Rü yexguma ĩãnewa nangugügu, rü nüxü̃ nixugügü ga guxü̃ma ga yema ngupetüxü̃ ga ñuxãcü naxcèx na yataanegüxü̃ ga yema taxre ga yatügü ga ngoxoã̱xgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","—Rü yexguma ga guxü̃ma ga yema ĩãnecü̱̃ã̱x ga duü̃xü̃gü, rü Ngechuchuxü̃tawa naxĩ. Rü yexguma Ngechuchuxü̃ nadaugügu, rü nüxü̃ nacèèxü̃gü na ínaxũxũxü̃cèx ga yema norü naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Rü yexguma ga Ngechuchu rü wüxi ga nguegu nixüe. Rü naxtaxaarü tocutüwa naxũ, rü noxrütama ĩãnewa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Rü yéma guma ĩãnewa rü duü̃xü̃gü rü Ngechuchuxü̃tawa nanangetaü̃gü ga wüxi ga yatü ga naw̱ãĩxãchicü. Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga ñuxãcü aixcüma na yaxõgüãxü̃ ga yema duü̃xü̃gü rü ñanagürü nüxü̃ ga guma iḏaawecü: —¡Nataãẽ, Pa Chaunex! Erü curü pecadugü rü marü cuxü̃́ nüxü̃ changechaü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Rü yéma nayexma ga ñuxre ga ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃. Rü nümagü rü naãxẽgüwa ñanagürügü: —¿Ñaã yatü rü ṯacü Tupanamaã nixugü? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Natürü ga Ngechuchu rü nüxü̃ nacuèxama ga yema naãẽwa nagu naxĩnüẽxü̃. Rü yemacèx ñanagürü nüxü̃: —¿Tü̱xcüü̃ chixexü̃gu perüxĩnüẽ? ");
INSERT INTO tcaNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","—¿Ṯacü nixĩ i ngẽma rütauxchamaẽxü̃ na namaã nüxü̃ ixuxü̃ ya daa naw̱ãĩxãchicü: “Rü curü pecadugü rü marü cuxü̃́ nüxü̃ changechaü̃”, rü ẽ́xna: “¡Inachi rü íixũ!” ñagüxü̃ nüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","—Natürü i ñu̱xma rü tá pexü̃ nüxü̃ chadauxẽẽ na Chaunatü ya Tupana núma choxü̃ muxü̃ na duü̃xü̃güaxü̃́ nüxü̃ changechaü̃xü̃cèx i norü pecadugü —ñanagürü. Rü yexguma rü ñanagürü nüxü̃ ga guma naw̱ãĩxãchicü: —¡Inachi, rü nayaxu i curü caruü̃, rü cupatawa naxũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","—Rü yexgumatama ga guma naw̱ãĩxãchicü rü inachi, rü napatawa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Rü yexguma yemaxü̃ nadaugügu ga duü̃xü̃gü, rü poraãcü namuü̃ẽ. Rü Tupanaxü̃ nicuèxüü̃gü, rü ñanagürügü: —Moxẽ, Pa Tupanax, erü cunaporaxẽẽ i ñaã yatü na ngẽmaãcü mexü̃ toxcèx naxüxü̃cèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Rü yexguma yéma inaxũãchigu ga Ngechuchu, rü yéma nüxü̃ nadau ga wüxi ga yatü ga Mateugu ãe̱gaxü̃ ga yéma rütoxü̃ ga ngextá Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ínayauxgüxü̃wa yerü woetama yemawa napuracü. Rü Ngechuchu rü ñanagürü nüxü̃: —¡Chowe rüxũ! —ñanagürü. Rü yexguma ga Mateu rü inachi, rü nawe narüxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Rü Mateupatawa naxũ ga Ngechuchu, rü yéma nachibü. Rü ínangugü ta ga muxü̃ma ga togü ga duü̃xü̃gü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ yauxgüxü̃wa puracüexü̃, rü togü ga duü̃xü̃gü ga taxúema nacümamaã taãẽgüxü̃. Rü yema duü̃xü̃gü rü yéma mechawa narütogü namaã ga Ngechuchu rü norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Natürü yexguma yemaxü̃ nadaugügu ga Parichéugü, rü Ngechuchuarü ngúexü̃güna nacagü, rü ñanagürügü: —¿Ñuxãcü i perü ngúexẽẽruü̃ rü namaã nachibü i ãẽ̱xgacüarü duü̃xü̃gü i dĩẽruarü yauxwa puracüexü̃, rü duü̃xü̃gü i pecaduã̱xgüxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Rü yexguma yemaxü̃ naxĩnügu ga Ngechuchu, rü ñanagürü nüxü̃ ga Parichéugü: —Ngẽma poraexü̃ rü tama nanaxwèxegü ya duturu, natürü ngẽma iḏaaweexü̃ nixĩ i naxwèxegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","—¡Rü ípixĩ, rü nawa pengúe i Tupanaãrü ore i ümatüxü̃ i ñaxü̃: “Choma rü tama chanaxwèxe i chauxcèx peyamèx i carnerugü, natürü chanaxwèxe i togü pexü̃́ nangechaü̃tümüü̃gü”, ñaxü̃! Rü ñanagürü ta ga Ngechuchu: —Choma rü tama mexü̃güna na chaxuxü̃cèx nixĩ i núma chaxũxü̃, natürü núma chaxũ na nüxna chaxuxü̃cèx i ngẽma pecaduã̱xgüxü̃ na ngẽmaãcü nüxü̃ naxoexü̃cèx i nacümagü i chixexü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Rü yexguma ga Cuáü̃ ga baiü̃xẽẽruü̃ãrü ngúexü̃gü, rü Ngechuchucèx naxĩ, rü nüxna nacagüe, rü ñanagürügü: —Toma i Cuáü̃ãrü ngúexü̃gü na tixĩgüxü̃ rü nümagü i Parichéugü rü muẽ̱xpü̱xcüna tama tachibüeãcüma tayumü̃xẽgü. ¿Rü tü̱xcüü̃ i curü ngúexü̃gü rü tama toxrüü̃ tama nachibüãcüma nayumü̃xẽgü? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —¿Ẽ́xna wüxi i ngĩgüarü petawa rü pexcèx namexü̃ na nangechaü̃ẽxü̃ rü naxaureexü̃ i ngẽma nüxna naxugüxü̃ ega natanüwa nangẽxmagu i ngẽma yatü i ngexwacèx ãmaxü̃? Maneca tama nixĩ. Natürü wüxi i ngunexü̃gu rü ngẽma yatü i ngexwacèx ãmaxü̃ rü tá namücügüna nixũgachi. Rü ngẽma ngunexü̃gu tá nixĩ i aixcüma naxaureexü̃ i namücügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Rü taxúema tanapaita i wüxi i naxchiru i ngauxü̃ namaã i wüxi i natüchi i ngexwacaxü̃xü̃ i tauta nañaãchimüxü̃. Erü ngẽxguma nayau̱xgu i ngẽma naxchiru rü tá nügü ínanaxíraxãchi i ngẽma natüchi i ngexwacaxü̃xü̃, rü tá nanagauxẽẽ i ngẽma wexachiru. Rü noxriarü yexera tá nixĩ i na nagauxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","—Rü ngẽxgumarüü̃ ta rü taxúema ngexwacaxü̃cü ya binu rü nagu tayabacuchi i wüxi i naxchixü̃ i marü ngauxü̃ i naxchèxmünaxcèx. Erü ngẽxguma ngẽmaãcü naxü̱xgu rü yima binu ya ngexwacaxü̃cü rü narüngu, rü tá nayawã̱ĩ̱xẽẽ i ngẽma naxchixü̃ i ngauxü̃ i naxchèxmünaxcèx. Rü ngẽxma tá nayarütaxu ya binu rü ngẽma naxchixü̃ rü ta. Rü ngẽmacèx tanaxwèxe ya ngexwacaxü̃cü ya binu rü ngexwacaxü̃xü̃ i naxchixü̃gu tayabacuchi. Rü ngẽmaãcü tãũtáma inayarütaxu. Rü chorü ngu̱xẽẽtae i ngexwacaxü̃xü̃ rü ngẽxgumarüü̃ ta nixĩ na taxucürüwama namaã nawüxiguxü̃ i ngẽma nuxcümaü̃xü̃ i pecümagü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Rü yexguma yemaãcü ínangúexẽẽtaeyane ga Ngechuchu, rü naxü̃tawa nangu ga wüxi ga ãẽ̱xgacü ga Yudíugüarü. Rü Ngechuchupẽ́xegu nayacaxã́pü̱xü, rü ñanagürü nüxü̃: —Pa Corix, chauxacü rü ngexwacèx iyu. Natürü ngẽxguma chi nge̱ma cuxũxgu rü ngĩxü̃ quingõgügu, rü wena chixarü imaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Rü inachi ga Ngechuchu, rü norü ngúexü̃gümaã yema ãẽ̱xgacüwe narüxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Rü yexguma yéma naxũyane ga Ngechuchu rü wüxi ga ngecü ga 12 ga taunecü ãgüechacü rü naweama ne ixũ. Rü naxpechinüchirugu iyangõgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Yerü ngĩma rü nagu irüxĩnü rü yexguma chi naxchiruxü̃xĩcatama yangõgümaregu, rü chi ngĩxcèx nitaane. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Natürü nüma ga Ngechuchu rü nügü ínidau, rü ngĩxü̃ nadau ga yema nge. Rü ñanagürü ngĩxü̃: —¡Nataãẽ, Pa Chauxacüx! Marü cuxcèx nitaane, erü cuyaxõ —ñanagürü. Rü yexgumatama ngĩxcèx nitaane. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Rü yexguma yema ãẽ̱xgacüpatawa nanguxgu ga Ngechuchu, rü nüxü̃ nadau ga paxetatanüxü̃ ga marü na ínamemaregüxü̃ na ngĩxü̃ iyatèxgüxü̃ ga yema bucü. Rü ga duü̃xü̃gü rü nixáicha rü naxauxe. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Rü Ngechuchu ñanagürü nüxü̃ ga yema duü̃xü̃gü: —¡Ípechoxü̃ i nuã! Erü ngẽma bucü rü tama iyu. Rü ipemare —ñanagürü. Natürü nümagü ga duü̃xü̃gü rü Ngechuchuxü̃ nacugüeama. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Rü yexguma Ngechuchu ínachoxü̃xẽẽxgu ga duü̃xü̃gü, rü yema bucüarü ucapugu naxücu. Rü ngĩxmẽ́xgu nayayauxãchi, rü yexgumatama íirüda ga ngĩmax. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Rü guxü̃wama ga yema naãnewa, rü duü̃xü̃gü nüxü̃ nixuchigagü ga yema Ngechuchu üxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Rü yexguma yéma ínaxũũxgu ga Ngechuchu, rü taxre ga ngexetüxü̃ rü nawe nangẽgü. Rü tagaãcü ñanagürügü: —Pa Ngechuchux, Pa Dabítanüxü̃x, ¡cuxü̃́ tangechaü̃tümüü̃gü! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Rü yexguma Ngechuchu guma ĩ ga nagu napexü̃negu naxücuxgu, rü yema taxre ga ngexetüxü̃ rü naxcèx naxĩ. Rü Ngechuchu nüxna naca, rü ñanagürü: —¿Peyaxõgüxü̃ yiĩxü̃ na chaporaxü̃ na pexü̃ charümeẽxẽẽxü̃cèx? —ñanagürü. Rü nümagü nanangãxü̃gü, rü ñanagürügü: —Ngü̃, Pa Corix, tayaxõgü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Rü yexguma ga Ngechuchu rü naxẽtügügu ningõgü, rü ñanagürü nüxü̃: —¡Cü pexcèx yataane, erü peyaxõgü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Rü naxcèx nitaanegü. Rü Ngechuchu rü poraãcü nayaxucu̱xẽgü na taxúemaãma nüxü̃ na yaxugüxü̃cèx ga yema nüxü̃ ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Natürü yema taxre rü yexguma yéma ínachoxü̃gu rü guxü̃wama ga yema naãnewa rü nüxü̃ nixugüeama ga yema Ngechuchu üxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Rü yexguma yema taxre ga yatü íchoü̃xguwena, rü ñuxre ga duü̃xü̃gü rü Ngechuchuxü̃tawa nanagagü ga wüxi ga yatü ga tama idexacü yerü ngoxo nawa nayexma. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Rü Ngechuchu ínanatèxüchi ga yema ngoxo. Rü yexgumatama inanaxügü ga na yadexaxü̃ ga guma yatü. Rü nümagü ga duü̃xü̃gü rü nabèi̱xãchiãẽgü. Rü ñanagürügü: —Taguma nüxü̃ tadau i nuã tachiü̃ãnewa i ṯacü i ñaãrüü̃ ixĩxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Natürü ga Parichéugü rü ñanagürügü: —Ñaã yatü rü ngoxogüarü ãẽ̱xgacü i Chatanáãrü poramaã nixĩ i ínawoxü̃ãxü̃ i ngoxogü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Rü yema naãnewa rü guxü̃nema ga ĩãnegügu rü ĩãnexãcügügu nixũgüchigü ga Ngechuchu. Rü wüxichigü ga ĩãnewa, rü duü̃xü̃güarü ngutaquẽ́xepataü̃wa ningu̱xẽẽtaechigü. Rü duü̃xü̃gümaã nüxü̃ nixuchigü ga ore ga mexü̃ na ñuxãcü ãẽ̱xgacü na yiĩxü̃ ya Tupana. Rü nanameẽxẽẽ ga duü̃xü̃gü ga iḏaaweexü̃. Rü woo nañuxraü̃xü̃ ga norü ḏaawe nüxü̃́ yexmaxü̃, rü nanameẽxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga yema muxü̃ma ga duü̃xü̃gü ga naxü̃tawa ngugüxü̃, rü nüxü̃́ nangechaü̃tümüü̃gü. Yerü carnerugü ga ngearü dauruü̃ã́xü̃rüü̃ nanaxi̱xãchiãẽgü, rü tama nataãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Aixcüma pemaã nüxü̃ chixu rü nangẽxma i muxũchixü̃ i duü̃xü̃gü i ímemaregüxü̃ na yaxõgüãxü̃ i Tupanaãrü ore. Natürü nanoxreẽ́xpü̱x i Tupanaãrü puracütanüxü̃ na namaã nüxü̃ yaxugüxü̃cèx i ngẽma ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rü ngẽmacèx name nixĩ i duü̃xü̃güarü yora ya Tupanana naxcèx peca i perü yumüxẽwa na yamugüãxü̃cèx i norü puracütanüxü̃ i orearü uruü̃gü na ngẽma duü̃xü̃gümaã nüxü̃ yaxugüxü̃cèx i norü ore i mexü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Rü yexguma ga Ngechuchu, rü yema 12 ga norü ngúexü̃gücèx naca. Rü nüxna naxãga rü nanaporaexẽẽ na ínawoxü̃ãxü̃cèx ga ngoxogü rü nameẽxẽẽãxü̃cèx ga duü̃xü̃gü ga iḏaaweexü̃ ga woo nañuxraü̃xü̃ ga ḏaawe nüxü̃́ yexmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Rü ñaã nixĩ ga nae̱gagü ga yema 12 ga Ngechuchuarü ngúexü̃gü ga imugüxü̃. Rü natanüwa rü Chimáũ ga Pedrugu ãe̱gacü nixĩ ga naẽru ixĩxü̃. Rü to nixĩ ga Pedrueneẽ ga Aü̃dré. Rü to nixĩ ga Chaü̃tiágu rü to nixĩ ga Chaü̃tiágueneẽ ga Cuáü̃. Rü yema taxre rü Zebedéu nanegü nixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Rü togü nixĩ ga Piripi, rü Baturumé, rü Tumachi, rü Mateu ga Dumaãrü ãẽ̱xgacücèx dĩẽruarü yauxwa puracüchirécü. Rü togü nixĩ ga Chaü̃tiágu ga Arupéu nane, rü Tadéu. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Rü to nixĩ ga Chimáũ ga iporaãẽcüücü. Rü to nixĩ ga Yuda ga Icariúte ga yixcama bexma cúãcü Ngechuchuxü̃ íxuaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Rü Ngechuchu nayamugü ga yema 12 ga norü ngúexü̃gü. Rü nüxna naxãga, rü ñanagürü: —¡Tãũtáma natanüwa pexĩ i ngẽma duü̃xü̃gü i tama Yudíugü ixĩgüxü̃! ¡Rü tãũtáma Chamáriacü̱̃ã̱x i duü̃xü̃güarü ĩãnegüwa pexĩ! ");
INSERT INTO tcaNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","—Natürü chanaxwèxe i ngẽma Yudíugü i carnerugürüü̃ iyarütauxexü̃tanüwa pexĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","—¡Rü nge̱ma natanüwa nüxü̃ peyarüxu na marü yangaicaxü̃ ya Tupana na norü ãẽ̱xgacü yiĩxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","—¡Rü penameẽxẽẽ̱x i ngẽma duü̃xü̃gü i iḏaaweexü̃! ¡Rü wena penamaxẽxẽẽ̱x i ngẽma duü̃xü̃gü i marü yuexü̃! ¡Rü penameẽxẽẽ̱x i ngẽma duü̃xü̃gü i chaxünemaã iḏaaweexü̃! Rü ngẽma duü̃xü̃gü i ngoxogü nawa ngẽxmagüxü̃ ¡rü nüxü̃́ ípenawoxü̱̃x! Rü tama name i penaxãtanü ega texéxü̃ perümexẽẽxgu, erü pema rü pexü̃́ nangetanümare i ngẽma pora. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","—¡Rü tãũtáma ípingearü dĩẽruã̱xgü na perü ṯacücèx petaxegüxü̃cèx rü bai i perü choca i perü namawaü̃! ¡Rü wüxitama i pexchiru ípinge, rü bai i perü chapatu, rü bai ya perü caxü̃chigüxü̃ ya naĩxmenèxã ípinge! Rü pemaã nüxü̃ chixu rü wüxi i puracütanüxü̃ rü name nixĩ i ngẽma duü̃xü̃ i nüxü̃́ napuracǘü̃xü̃tawa nachibü. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","—Rü ngẽxguma wüxi ya ĩãnewa rü ẽ́xna wüxi ya ĩãnexãcüwa pengugügu i pemax, ¡rü naxcèx pedèu̱x i wüxi i duü̃xü̃ i mecümaxü̃! ¡Rü ngẽmaxü̃tagu perücho ñu̱xmatáta ipexĩãchi i ngẽma ĩãnewa! ");
INSERT INTO tcaNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","—Rü ngẽxguma yima ĩpatagu pechocugu, rü meã tá nüxü̃ perümoxẽgü i ngẽma duü̃xü̃gü i nge̱ma ngẽxmagüxü̃ rü: “¡Tupana pexü̃ rüngü̃xẽẽ̱x!” ñaperügügü tá nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","—Rü ngẽxguma ngẽma duü̃xü̃gü rü meã pexü̃ nayau̱xgu rü Tupana tá nüxü̃ narüngü̃xẽẽ. Natürü ngẽxguma tama meã pexü̃ nayau̱xgu i napatawa rü ñaperügügü tá nüxü̃: “Marü name i toxnamana taxĩ”, ñaperügügü tá. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","—Rü ngẽxguma wüxi ya ĩwa rü ẽ́xna wüxi ya ĩãnewa duü̃xü̃gü tama meã pexü̃ yauxgügu rü tama nüxü̃ naxĩnüẽchaü̃gu i perü ore, ¡rü ípechoxü̃! Rü ngẽxguma ípechoü̃xgu, ¡rü meã pegü ipepagücutü i perü üxaxü̃cutü, na ngẽmawa nüxü̃ nacuèxgüxü̃cèx na chixexü̃ na naxügüxü̃ i ngẽma duü̃xü̃gü! ");
INSERT INTO tcaNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","—Rü aixcüma pemaã nüxü̃ chixu rü ngẽma ngunexü̃ i nagu nagúxü̃ i naãne, rü Chodomacü̱̃ã̱x rü Gomoracü̱̃ã̱x i duü̃xü̃güarü yexera Tupana tá nanapoxcue i ngẽma duü̃xü̃gü i tama meã pexü̃ yauxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—Dücèx, ãũcümaxü̃wa pexü̃ chamugü, ngẽxgumarüü̃ i carnerugüxü̃ aigütanüwa imugüxü̃rüü̃. ¡Rü ngẽmacèx penaxwèxe i ãxtapegürüü̃ pexuãẽgü, natürü muxtucugürüü̃ taxuü̃ma i chixexü̃ pexügü! ");
INSERT INTO tcaNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","—¡Rü pegüna pedaugü! Erü duü̃xü̃gü rü tá pexü̃ ínayauxü̃, rü ãẽ̱xgacügüxü̃tawa tá pexü̃ nagagü na pexü̃ napoxcuexü̃cèx. Rü ngutaquẽ́xepataü̃gügu tá pexü̃ nic̱uaixgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","—Rü chaugagu tá ãẽ̱xgacügü ya tacügüpẽ́xewa pexü̃ nagagü. Rü ngẽmaãcü tá chauchigagu pidexagü napẽ́xewa i ngẽma ãẽ̱xgacügü rü napẽ́xewa i ngẽma duü̃xü̃gü i tama Yudíugü ixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","—Natürü ngẽxguma ãẽ̱xgacügüpẽ́xewa pexü̃ nagagügu na pexü̃ napoxcuexü̃cèx, ¡rü taxucèxtáma pexoegaãẽgü na ṯacümaã tá penangãxü̃xü̃ rü ẽ́xna ṯacüxü̃ tá namaã na pixuxü̃! Erü ngẽxguma nawa nanguxgu na pidexagüxü̃, rü Tupanaãẽ tá pexü̃ nangu̱xẽẽ na ṯacüxü̃ tá namaã pixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","—Rü tãũtáma pema nixĩ i pidexagüxü̃, natürü Tupanaãẽ i Üünexü̃ tá nixĩ i pewa idexaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","—Rü nügüeneẽgüwa rü tá nügü ínaxuaxü̃gü na ãẽ̱xgacügü yamèxgüxü̃cèx. Rü ngẽxgumarüü̃ tá ta nanatügü rü naxãcügüxü̃ ínaxuaxü̃gü, rü naxãcügü rü nanatügüxü̃ tá ínaxuaxü̃gü na ãẽ̱xgacügü tüxü̃ imèxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","—Rü chaugagu tá guxü̃ i duü̃xü̃gü pexchi naxaie. Natürü yíxema aixcüma yaxõõmáxẽ i chorü ore rü tama choxü̃ ítáxe, rü yíxema tá tixĩ ya nayaxúxe i ngẽma maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","—Rü ngẽxguma wüxi ya ĩãnewa rü duü̃xü̃gü pexü̃ daixchaü̃gu, rü name nixĩ i pibuxmü ya yima ĩãnewa, rü náĩ ya ĩãnewa pexĩ. Rü aixcüma pemaã nüxü̃ chixu rü tãũtáma guxü̃ne ya Yudíugüarü ĩãnewa pengugü naxü̃pa na chataeguxü̃ i chomax. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","—Rü taxuü̃ma i wüxi i ngúexü̃ rü norü ngúexẽẽruü̃xü̃ narüyexera. Rü taxuü̃ma i wüxi i coriarü duü̃xü̃ rü norü corixü̃ narüyexera. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","—Rü ngẽma norü ngúexẽẽruü̃xü̃ üpetüxü̃rüü̃ tátama nüxü̃ naxüpetü i ngẽma norü ngúexü̃. Rü ngẽma norü corixü̃ üpetüxü̃rüü̃ tátama nüxü̃ naxüpetü i ngẽma norü duü̃xü̃. Rü ngẽxguma duü̃xü̃gü rü ngoxo i Bechebú choxü̃ nawogüegu, ¿rü ñuxãcü tá pexü̃ naxu i pemax? ");
INSERT INTO tcaNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","—Rü ngẽmacèx ¡tãxṹ i nüxü̃ pemuü̃ẽxü̃ i ngẽma duü̃xü̃gü! Erü guxü̃ma i ngẽma cúãcü üxü̃ rü tá nango̱xoma. Rü guxü̃ma i ngẽma ñu̱xma duü̃xü̃gücèx ẽxü̃guxü̃, rü yixcüra rü tá nüxü̃ nacuèxgüama. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","—Rü guxü̃ma i ngẽma pemaãxĩcatama nüxü̃ chixuxü̃, ¡rü meã duü̃xü̃gücèx penango̱xẽẽ̱x! Rü guxü̃ma i ngẽma bexma pemaã nüxü̃ chixuxü̃, ¡rü tagaãcü guxü̃ i duü̃xü̃gümaã nüxü̃ pixu! ");
INSERT INTO tcaNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","—¡Rü tãxṹ i nüxü̃ pemuü̃ẽxü̃ i ngẽma duü̃xü̃gü i pexü̃ daixchaü̃xü̃! Erü taxünexü̃xĩcatama nimèxgü. ¡Natürü name nixĩ i nüxü̃ pemuü̃ẽ ya yima Tupana! Erü nüma nüxü̃́ nangẽxma i pora na napoxcuãxü̃cèx i pexene rü peãẽ rü ta i ngẽma ngoxogüxü̃ ínapoxcuexü̃gu. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","—¿Tama ẽ́xna wüxitachinü i dĩẽrugu namaã petaxe i taxre i werixacügü? Natürü bai i wüxi i ngẽma werixacü rü ñaxtüanegu nangu, ega tama nanaxwèxegu ya Penatü ya Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","—Rü woo i peyae rü Tupana rü wüxichigü rü nayaxugü, rü nüxü̃ nacuèx na ñuxre ngẽxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","—Rü ngẽmacèx ¡tãxṹ i pemuü̃ẽxü̃! Erü pema rü muxü̃ma i werixacügüarü yexeraxüchi pexü̃ nangechaü̃ ya Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","—Rü guxãma ya texé i ñoma i naãnewa i duü̃xü̃güpẽ́xewa tügü ixuxe na chorü duü̃xü̃ tiĩxü̃, rü choma rü tá ta Chaunatü ya daxũgucüpẽ́xewa tüxü̃ chixu na chorü duü̃xü̃ tiĩxü̃ i tümax. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","—Natürü texé ya ñoma i naãnewa i duü̃xü̃güpẽ́xewa tügü ixuxe na tama chorü duü̃xü̃ tiĩxü̃, rü choma rü tá ta Chaunatü ya daxũgucüpẽ́xewa tüxü̃ chixu na tama chorü duü̃xü̃ tiĩxü̃ i tümax. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","—Rü tama name i nagu perüxĩnüẽ na núma chaxũxü̃ na guxü̃ i duü̃xü̃gü rü wüxigu naxĩnüẽxü̃cèx. Natürü pemaã nüxü̃ chixu rü núma chaxũ na chaugagu yatoyexü̃cèx i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","—Rü nuã chaxũ na wüxi ya yatü rü tama nanatümaã wüxigu naxĩnüxü̃cèx, rü wüxi i paxü̃ rü tama naẽmaã wüxigu naxĩnüxü̃cèx, rü wüxi i naneã̱x rü tama ngĩ̱xẽmaã na wüxigu naxĩnüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","—Rü ngẽmaãcü wüxi ya ĩwa, rü nügütanüxü̃maã tátama naxuwanüã̱xgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","—Rü yíxema texé ya choxü̃ na tangechaü̃xü̃ãrü yexera tümanatüxü̃ rü ẽ́xna tümaẽxü̃ ngechaü̃xẽ, rü taxucürüwama chorü duü̃xü̃ tixĩ. Rü yíxema texé ya choxü̃ na tangechaü̃xü̃ãrü yexera tümanexü̃ rü ẽ́xna tümaxãcüxü̃ ngechaü̃xẽ, rü taxucürüwama chorü duü̃xü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","—Rü yíxema tama yaxna namaã ĩnüxẽ i ngẽma guxchaxü̃gü i chaugagu tümacèx ínguxü̃ rü ngẽmaãcü chowe rüxũxẽ, rü taxucürüwama chorü duü̃xü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","—Rü texé ya tügü maxẽẽchaü̃xẽ rü tá itayarütaxu. Natürü texé ya chauxcèx yuxe rü tá tanayaxu i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","—Rü texé ya pexü̃ yaxúxe rü choxü̃ nixĩ i tayaxuxü̃. Rü texé ya choxü̃ yaxúxe rü yima núma choxü̃ mucü ya Chaunatüxü̃ nixĩ i tayaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","—Rü texé ya wüxi i orearü uruü̃ i Tupana nge̱ma muxü̃xü̃ yaxúxe, rü ngẽmatama ãmare i wüxi i orearü uruü̃ yaxuxü̃raü̃xü̃ tátama tayaxu. Rü texé ya wüxi i yatü i mecümaxü̃xü̃ yaxúxe erü namecüma, rü ngẽmatama ãmare i wüxi i yatü i mecümaxü̃ yaxuxü̃raü̃xü̃ tátama tayaxu. ");
INSERT INTO tcaNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","—Rü texé ya wüxi i pochiyuãcu i dexá i gèu̱xchiüxü̃ nüxna ãxẽ i ngẽxü̃rüüxü̃ i chorü buxü̃gü i chowe rüxĩxü̃, rü aixcümaxü̃chi tá tanayaxu i tümaãrü ãmare —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Rü yexguma nüxü̃ nachauxgu ga Ngechuchu ga na yaxucu̱xẽgüãxü̃ ga yema 12 ga norü ngúexü̃gü, rü inaxũãchi ga yéma na duü̃xü̃güxü̃ nangúexẽẽxü̃cèx rü nüxü̃ yaxúxü̃cèx ga ore ga mexü̃ ga guxü̃ne ga ĩãnegü ga yema naãnewa yexmagünewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","3","Rü Cuáü̃ ga baiü̃xẽẽruü̃ rü yexguma poxcupataxü̃wa nayexmayane, rü nüxü̃ nacuáxchiga ga yema Ngechuchu üxü̃. Rü yemacèx ga Cuáü̃ rü Ngechuchuxü̃tawa nanamugü ga ñuxre ga norü duü̃xü̃gü na nüxna yacagüxü̃cèx rü aixcüma Cristu ga ínanguxẽẽgücü yiĩ, rü ẽ́xna to tá yiĩ ya Cristu. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃ ga yema duü̃xü̃gü: —¡Pewoegu rü Cuáü̃maã nüxü̃ peyarüxu i ngẽma pematama nüxü̃ pedaugüxü̃ rü nüxü̃ pexĩnüẽxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","—¡Rü namaã nüxü̃ pixu rü ngẽma ngexetügüxü̃ rü marü nidauchigü, rü ngẽma ichixeparaxü̃ rü marü inachigü, rü ngẽma chaxüneã̱xgüxü̃ rü marü naxcèx nitaanegü, rü ngẽma ngauchi̱xẽgüxü̃ rü marü ningo̱xnamachi̱xẽgü, rü ngẽma yuexü̃ rü wenaxãrü namaxẽ, rü ngẽma ngearü ngẽmaxü̃ã̱xgüxü̃ rü marü namaã nüxü̃ tixu i Tupanaãrü ore i mexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Rü tataãẽ ya yíxema texé ya tama nüxü̃ rüxoxe na choxü̃́ tayaxõxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Rü yexguma nawoegu̱xgu ga yema Cuáü̃ ga baiü̃xẽẽruü̃ãrü duü̃xü̃gü, rü Ngechuchu inanaxügü ga guma Cuáü̃chiga na yadexaxü̃. Rü ñanagürü nüxü̃ ga duü̃xü̃gü: —¿Ṯacü nixĩ ga pema ípeyadaugüxü̃ ga dauxchitawa ga ngextá taxúema íxãpataxü̃wa? —¿Ẽ́xna wüxi ga ngẽxü̃rüüxü̃mare ga yatü ga ñoma dexne ga buanecü yaxĩã̱xtanücüüxẽẽcürüü̃ ixĩxü̃ nixĩ ga ípeyadaugüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","—Rü ẽ́xna ega tama guma ípeyadaugügu, ¿rü ṯacü nixĩ ga ípeyadaugüxü̃? ¿Ẽ́xna wüxi ga yatü ga poraãcü nügü ngèxãẽxü̃ yiĩxü̃ ga ípeyadaugüxü̃? Pema nüxü̃ pecuèx i ngẽma poraãcü nügü ngèxãẽgüxü̃ rü ãẽ̱xgacügü ya tacügüpatawa nangẽxmagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","—¿Ṯacü ẽ́xna nixĩ ga ípeyadaugüxü̃? ¿Ẽ́xna wüxi ga Tupanaãrü orearü uruü̃xü̃? Ngẽmáãcü aixcüma yema nixĩ ga ípeyadaugüxü̃. Rü pemaã nüxü̃ chixu rü Cuáü̃ ya baiü̃xẽẽruü̃ rü tama wüxi i ngẽxü̃rüüxü̃mare i Tupanaãrü orearü uruü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","—Rü Cuáü̃chiga nixĩ ga naxümatüxü̃ ga yema Tupanaãrü ore ga ñaxü̃: “Cupẽ́xegu chayamu i chorü orearü ngeruü̃ na cuxcèx namexẽẽãxü̃cèx i duü̃xü̃güarü maxü̃”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","—Rü aixcüma pemaã nüxü̃ chixu rü guxü̃ i duü̃xü̃gütanüwa rü nataxuma i Tupanaãrü orearü uruü̃ i Cuáü̃ ya baiü̃xẽẽruü̃ãrü yexera ixĩxü̃. Natürü yíxema Tupana ãẽ̱xgacü íixĩxü̃wa wixwexüchi üxe, rü Cuáü̃ãrü yexera tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","—Rü yexguma noxri Cuáü̃ ya baiü̃xẽẽruü̃ inaxügügu na nüxü̃ yaxúxü̃ i ñuxãcü Tupana ãẽ̱gacü ixĩxü̃wa nangugüxü̃ i duü̃xü̃gü, rü nüma ga duü̃xü̃gü rü norütama ngúchaxü̃maã nawa nangugüchaxü̃ i ngema nachica. Rü ñu̱xma rü ta ngemagutama narüxĩnüe. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","—Rü guxü̃ma ga Tupanaãrü orearü uruü̃güarü orewa, rü ore ga mugü ga Moĩché ümatüxü̃wa rü nüxü̃ nixuchigagü na ínanguégaxü̃ ya Cristu na ãẽ̱xgacü na yiĩxü̃cèx. Rü yemaãcü nixĩ ñu̱xmata ínangu ga Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","—Rü ngẽxguma chi peyaxõgüchaü̃gu i ñaã chorü ore, rü pemaã nüxü̃ chixu rü Cuáü̃ ya baiü̃xẽẽruü̃ nixĩ ya yima yanguxẽẽcü ga yema ore ga guma nuxcümaü̃cü ga orearü uruü̃ ga Ería ga ípenanguxẽẽcüchiga ümatüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","—Rü yíxema ãchi̱xẽgüxe, ¡rü naga taxĩnüẽ i ngẽma ore! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Rü ñanagürü ta ga Ngechuchu: —¿Ṯacügu tá chanangu i ñaã duü̃xü̃gü i ñu̱xma maxẽxü̃? Maneca ñaã duü̃xü̃gü rü taxumaãma nataãẽgü ngẽxgumarüü̃ i ñuxre i buxü̃gü i nügümaã ĩã̱xtüwa rütogüxü̃, rü íxĩnücèxwèxegüxü̃, rü tagaãcü namücügüxü̃ ñagüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Marü wowerumaã pexcèx tapaxetagü, natürü tama ípixü̃ãchitanüxü̃. Rü marü ngechaü̃ i wiyaegu pexcèx tawiyaegü, natürü tama pexauxe”, ñagüxü̃. Rü ngẽma buxü̃gürüü̃ nixĩ i ñaã duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","—Yerü núma naxũ ga Cuáü̃ ga baiü̃xẽẽruü̃ rü tama pãũ nangõ̱x rü tama binu nayaxaxü. Rü yexguma ga nümagü rü: “Nangoxoã̱x” ñanagürügü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","—Rü ñu̱xũchi núma chaxũ i choma ya Tupana Nane na duü̃xü̃xü̃ chiĩxü̃. Rü choma rü õna changõ̱x rü binu chayaxaxü. Rü ngẽxguma i nümagü rü taanüxü̃chixü̃ rü ngãxwèxexü̃ choxü̃ nawogüe. Rü nüxü̃ nixugüe rü pecaduã̱xgüxü̃maã chaxãmücü, rü namaã chaxãmücü i ngẽma duü̃xü̃gü i Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ideetanüxü̃. Natürü Tupanaãrü cuèx rü meãma nango̱x tümawa ya yíxema aixcüma nawe rüxĩxẽ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Rü yexguma ga Ngechuchu rü inanaxügü ga na yangagüãxü̃ ga yema duü̃xü̃gü ga guma ĩãnegücü̱̃ã̱x ga ngextá yexeraãcü ínaxüaxü̃wa ga taxü̃ ga mexü̃gü ga Tupanaãrü poramaã naxüxü̃. Rü poraãcü nayangagü, yerü yema duü̃xü̃gü rü tama nüxü̃ narüxoe ga norü chixexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Rü ñanagürü ga Ngechuchu: —Rü wüxi i ngechaü̃ nixĩ i pexcèx, Pa Corachíü̃cü̱̃ã̱xgü rü Pa Bechaídacü̱̃ã̱xgüx, yerü yexguma chi Tiruarü ĩãnewa rü Chidã́ũãrü ĩãnewa chanaxü̱xgu ga yema mexü̃gü ga cuèxruü̃gü ga Tupanaãrü poramaã petanüwa chaxüxü̃, rü woo ga na poraãcü yachixexü̃ ga yema duü̃xü̃gü rü nuxcümama chitama nüxü̃ narüxoe ga yema nacüma ga chixexü̃, rü poraãcüxüchi chima nügümaã nangechaü̃gü rü naxauxe, yerü chi nügü nicuèxãchitanü ga na yapecaduã̱xgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","—Natürü pemaã nüxü̃ chixu rü ngẽma ngunexü̃ i Tupana nagu napoxcuexü̃ i pecaduã̱xgüxü̃, rü ngẽma ngunexü̃gu rü Tirucü̱̃ã̱xgü rü Chidã́ũcü̱̃ã̱xgüarü yexera tá pexü̃ napoxcue i pemax, Pa Corachíü̃cü̱̃ã̱xgü rü Bechaídacü̱̃ã̱xgüx. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","—Rü pemax, Pa Capernáũcü̱̃ã̱xgü i Duü̃xü̃güx, ¿rü pema nagu perüxĩnüẽgu rü daxũguxü̃ i naãnewa tá ipexĩxü̃? Pemaã nüxü̃ chixu rü naãnetüü̃wa i ngextá Tupana Chatanáxü̃ ípoxcuxü̃wa tá nixĩ i pewogüxü̃. Rü yexguma chi Chodomaãrü ĩãnewa chanaxü̱xgu ga yema mexü̃gü ga cuèxruü̃gü ga Tupanaãrü poramaã petanüwa chaxüxü̃, rü guma ĩãne ga nuxcüma norü pecadugagu iyarüxoxü̃ne rü ñu̱xma rü chi nangẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","—Natürü pemaã nüxü̃ chixu rü ngẽma ngunexü̃ i Tupana nagu napoxcuexü̃ i pecaduã̱xgüxü̃, rü ngẽma ngunexü̃gu rü Chodomacü̱̃ã̱xgüarü yexera tá pexü̃ napoxcue i pemax, Pa Capernáũcü̱̃ã̱xgüx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Rü yexguma rü ñaãcü nayumüxẽ ga Ngechuchu, rü ñanagürü: —Pa Chaunatü ya Daxũguxü̃ i Naãne rü Ñoma i Naãneãrü Yorax, cuxü̃ chicuèxüü̃, erü ñaã chorü ngúexü̃güxü̃ nüxü̃ cucuèxẽẽ i ñaã ore i naxchaxwa iquicúxü̃ i duü̃xü̃gü i ñoma i naãnewa nüxü̃ cuèxüchigüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","—Rü moxẽ cuxna chaxã, Pa Chaunatüx, erü cuma cunaxwèxe na ngẽmaãcü cunaxüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Rü ñanagürü ta ga Ngechuchu: —Chaunatü choxna nanaxã i guxü̃ma i ṯacü i ngẽxmaxü̃. Rü Chaunatüxicatama choxü̃ nacuèx na texé chiĩxü̃ i choma i Nane. Rü tama guxü̃ma i duü̃xü̃gü aixcüma nüxü̃ nacuèx na texé yiĩxü̃ ya Chaunatü. Rü choma ya Nane, rü ngẽma duü̃xü̃gü i Chaunatüxü̃ nüxü̃ chadauxẽẽchaü̃xü̃xĩcatama nixĩ i aixcüma nüxü̃ cuèxgüxü̃ na texé yiĩxü̃ ya Chaunatü. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","—¡Rü nuã chauxü̃tawa pexĩ i guxãma i pema ya ipaexe nagagu i perü chixexü̃gü rü perü ĩxãchiãẽgü! Rü choma rü tá pexna chanayaxu i pexweta na iperüngü̃ẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","—¡Rü ñuxũchi penayaxu i chorü ucu̱xẽgü rü naxcèx pedauxü̃taegü i chaucüma! Erü choma rü yaxna pemaã chaxĩnü rü taguma chaugü chicuèxüxü̃. Rü ngemaãcü tá nüxü̃ ipeyangau i ngema taãẽ i aixcüma ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","—Erü ngẽma pexü̃ chamuxü̃ rü natauxcha na naga pexĩnüẽxü̃. Rü ngẽma pexü̃́ chanaxw̱aexü̃ rü tama naguxcha na penaxüxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Rü wüxi ga ngü̃xchigaarü ngunexü̃gu rü Ngechuchu rü norü ngúexü̃gümaã trigunecügu nixũ. Rü nataiyae ga norü ngúexü̃gü, rü yemacèx inaxĩãcüma yoxocüne triguta nicãũẽtanü, rü inayangṍẽtanü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Rü yexguma yemaxü̃ nadaugügu ga Parichéugü rü ñanagürügü Ngechuchuxü̃: —Dücèx i curü ngúexü̃gü rü chixexü̃ naxüe. Erü ngü̃xchigaarü ngunexü̃gu napuracüe, rü nachu̱xu nixĩ i ngẽma —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —¿Taguma ẽ́xna poperawa nüxü̃ pedau ga ṯacü na naxüxü̃ ga nuxcümaü̃cü ga ãẽ̱xgacü ga Dabí ga yexguma nataiyèxgu ga nüma rü natanüxü̃gü? ");
INSERT INTO tcaNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","—Rü Tupanapatagu naxücu rü nanangõ̱x ga yema pãũ ga üünexü̃ ga Dabícèx rü natanüxü̃gücèx chu̱xuxü̃ ga na nangõ̱xgüãxü̃. Yerü paigücèxicatama nixĩ ga yema pãũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","—Rü pemax, Pa Parichéugüx ¿taguma ẽ́xna nawa pengúe ga yema ore ga mugüpanegu Moĩché ümatüxü̃ ga ñaxü̃ rü marü name i paigü rü ngü̃xchigaarü ngunexü̃gu napuracüe i tupauca ya taxü̃newa? Rü ngẽma rü tama wüxi i pecadu nixĩ naxcèx i ngẽma paigü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","—Natürü pemaã nüxü̃ chixu rü nuã petanüwa nangẽxma i wüxi i duü̃xü̃ i tupauca ya taxü̃neãrü yexera ixĩxü̃ i Tupanapẽ́xewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","—Natürü pema rü tama nüxü̃ pecuèx i ñuxũ ñaxü̃chiga nixĩ i ngẽma Tupanaãrü ore i ümatüxü̃ i ñaxü̃: “Choma rü tama chanaxwèxe i chauxcèx peyamèx i carnerugü, natürü chanaxwèxe i togü pexü̃́ nangechaü̃tümüü̃gü”, ñaxü̃. Rü ngẽxguma chi meã nüxü̃ pecuèxgügu i ngẽma ore, rü tãũ chima chixri nachiga pidexagü i ñaã chorü ngúexü̃gü i taxuü̃ma i chixexü̃ ügüxü̃ i Tupanapẽ́xewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","—Rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü aixcüma ngü̃xchigaarü yora chixĩ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Rü yexguma yema nachicawa ínaxũũxgu ga Ngechuchu, rü guma ĩãneãrü ngutaquẽ́xepataü̃gu naxücu. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Rü yéma nayexma ga wüxi ga yatü ga norü wüxichacüüwa yumécü. Rü nümagü ga Parichéugü rü naxcèx nadaugü ga ñuxãcü norü ãẽ̱xgacügüxü̃tawa Ngechuchuxü̃ na ínaxuaxü̃güxü̃. Rü yemacèx Ngechuchuna nacagüe, rü ñanagürügü: —¿Namexü̃ yiĩxü̃ na texé naxcèx yataanexẽẽxü̃ i wüxi i ḏaawexü̃ i ngü̃xchigaarü ngunexü̃gu? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —¿Texé i petanüwa rü ngẽxguma chi ngü̃xchigaarü ngunexü̃gu wüxi i perü carneru puchugu nguxgu, rü taux ẽ́xna i ngẽxgumatama ípeyadaugüxü̃ rü ípenatúãchixü̃ woo ngü̃xchigaarü ngunexü̃ yixĩgu? ");
INSERT INTO tcaNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","—Natürü Tupanapẽ́xewa rü wüxi i duü̃xü̃ rü poraãcüxüchima wüxi i carneruarü yexera nixĩ. Rü ngẽmacèx name nixĩ i mexü̃ taxü i woo ngü̃xchigaarü ngunexü̃ yixĩgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Rü ñu̱xũchi ga Ngechuchu rü ñanagürü nüxü̃ ga guma yatü ga yumécü: —¡Iyarüwẽ́xãchimẽ́xẽ! —ñanagürü. Rü guma yatü rü inayarüwẽ́xãchimẽ́xẽ, rü yexgumatama narümemẽ́x, rü naĩ ga naxmẽ́x ga mexü̃nerüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Rü yexguma yemaxü̃ nadaugügu ga Parichéugü, rü ínachoxü̃ ga yéma. Rü inanaxügüe na naxcèx nadaugüxü̃ ga ñuxãcü tá na Ngechuchuxü̃ yamèxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Rü yexguma Ngechuchu nüxü̃ cuáchigagu na Parichéugü na yamèxgüchaü̃xü̃, rü ínaxũxũ ga guma ĩãnewa. Rü muxü̃ma ga duü̃xü̃gü rü nawe narüxĩ. Rü nüma ga Ngechuchu rü nanameẽxẽẽ ga guxü̃ma ga yema duü̃xü̃gü ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Rü duü̃xü̃güna naxãga na tama nüxü̃ yaxugüexü̃cèx na texe na yiĩxü̃ ga nümax. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Rü yemaãcü nanaxü ga Ngechuchu na yanguxẽẽãxü̃cèx ga yema ore ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ichaxía nüxü̃ ixuxü̃ ga ñaxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Daa nixĩ ya chorü duü̃ ya chomatama nüxü̃ chaxunetacü rü nüxü̃ changechaü̃cü rü namaã chataãẽxü̃chicü. Rü Chauãẽ i Üünexü̃ rü nüxna tá chanamu. Rü nüma tá guxü̃ i duü̃xü̃gü i tama Yudíugü ixĩgüxü̃maã nüxü̃ nixu i ore i mexü̃ i aixcüma ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Rü tagutáma ngextá texémaã niporagacüü rü taxúemaãtáma ngextá nipura. Rü tagutáma texé ĩãneãrü ítamü̃güwa nüxü̃ taxĩnü na natagaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Rü nüma rü tãũtáma nanadai i ngẽma duü̃xü̃gü i norü õwa turaexü̃, rü tãũtáma inayanaxoxẽẽ i ngẽma duü̃xü̃gü i írarüwatama yaxõgüxü̃. Rü ngẽmaãcü tá nixĩ ñu̱xmatáta guxü̃ i naãnewa nangu i ngẽma norü ore i aixcüma ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Rü guxü̃ i duü̃xü̃gü i tama Yudíugü ixĩgüxü̃ rü tá naxcèx naxĩ na ngẽmaãcü naxü̃tawa nayauxgüãxü̃cèx i norü maxü̃ i taguma gúxü̃”, ñanagürü ga Ichaxía. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Rü Ngechuchuxü̃tawa nanagagü ga wüxi ga yatü ga ngoxoã́cü ga ngexetücü rü tama idexacü. Rü Ngechuchu nanamexẽẽ. Rü guma yatü rü yexgumatama nidauchi rü nidexa. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Rü guxü̃ma ga duü̃xü̃gü rü nabèi̱xãchiãẽgü ga yexguma yemaxü̃ nadaugügu. Rü ñanagürügü: —¿Taux ẽ́xna daa yiĩxü̃ ya Dabí nane ya Cristu? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Natürü yexguma yemaxü̃ naxĩnüẽgu ga Parichéugü, rü ñanagürügü: —Ñaã yatü i Ngechuchu, rü ngoxogünatü i Bechebúarü poramaã nixĩ i ínawoxü̃ãxü̃ i ngoxogü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Natürü nüma ga Ngechuchu rü nüxü̃ nacuèxama ga ṯacügu na naxĩnüẽxü̃. Rü yemacèx ñanagürü nüxü̃: —Ngẽxguma chi wüxi i nachiü̃ãnecü̱̃ã̱x i duü̃xü̃gü nügü itoyegu rü nügütanüwa chitama nügü nadaixgu, rü nügü chitama nagu̱xẽẽ. Rü ngẽxguma chi wüxi ya ĩãnecü̱̃ã̱x rü ẽ́xna wüxi ya ĩcü̱̃ã̱x nügümaã nuẽẽchagu rü nügü nadaixgu, rü nügü chitama nagu̱xẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","—Rü ngẽxguma chi Bechebú nügütama ítèxüchigu rü nügütama yamèxgu, ¿rü ñuxãcü chi ãẽ̱xgacüecha yiĩxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","—Rü pemax, Pa Parichéugüx, rü choxü̃ pixuxgu rü Bechebúarü poramaã íchanawoxü̃ i ngoxogü. Natürü ngẽxguma chi Bechebúarü poramaã íchanawoü̃xgu i ngoxogü, ¿rü texéarü poramaã nixĩ i perü ngúexü̃gü rü ínawoxü̃ãxü̃ i ngoxogü? Rü dücax, rü ngẽma perü ngúexü̃gütama nixĩ i pexcèx nango̱xẽẽxü̃ na ípetüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","—Natürü pemaã nüxü̃ chixu rü aixcüma Tupanaãẽ i Üünexü̃ãrü poramaã nixĩ i íchanawoxü̃xü̃ i ngoxogü. Rü ngẽmawa pexü̃ nüxü̃ chacuèxẽẽ na marü núma petanüwa nanguxü̃ ya Tupana, na perü ãẽ̱xgacü yiĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","—¿Rü ñuxãcü texé wüxi ya yatü ya poracüpatagu taxücu na tanapuxü̃xü̃cèx i norü ngẽmaxü̃gü, ega tama tayanèĩ̱xiragu i noxrix? Rü ngẽxguma tayanèĩ̱xiraguxicatama nixĩ i nüxna tanapuxü̃xü̃ i norü ngẽmaxü̃gü ya yima yatü ya poracü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Rü yíxema tama choxü̃ ngechaü̃xẽ rü chauxchi taxai. Rü yíxema tama choxü̃ rüngü̃xẽe̱xẽ na Tupanacèx tananutaquẽ́xexü̃ i duü̃xü̃gü rü chauxchawa tanangianexẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","—Rü ngẽmacèx pemaã nüxü̃ chixu rü Tupana tá nüxü̃́ nüxü̃ nangechaü̃ i guxü̃ma i pecadugü i duü̃xü̃gü ügüxü̃ rü guxü̃ma i norü dexagü i chixexü̃. Natürü yíxema Tupanaãẽ i Üünexü̃maã ṯacü ixugüxe, rü Tupana rü tagutáma tüxü̃́ nüxü̃ nangechaü̃ i ngẽma chixexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","—Rü guxãma ya texé ya ṯacü chomaã ixugüxe rü Tupana tá tüxü̃́ nüxü̃ nangechaü̃ i ngẽma. Natürü texé ya Tupanaãẽ i Üünexü̃maã ṯacü ixugüxe, rü Tupana rü tagutáma tüxü̃́ nüxü̃ nangechaü̃ i ngẽma, rü bai i ñoma i naãnewa, rü bai i daxũguxü̃ i naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","—Rü ngẽxguma wüxi i nanetü rü namexgu, rü norü o rü ta name. Natürü ngẽxguma wüxi i nanetü rü nachixẽ́xgu, rü norü o rü ta nachixe. Rü wüxi i nanetü rü norü owa nixĩ i nüxü̃ icuáxü̃ ngoxi name rü ẽ́xna tama. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","—Pa Ãxtapearü Duü̃xü̃güx, ¿ñuxãcü i mexü̃ i orexü̃ pixuxü̃ ega pematama rü pichixecümagu? Erü ngẽma ore i peèxmaã nüxü̃ pixuxü̃ rü peãẽwa nixĩ i ne naxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","—Wüxi ya mecü ya yatü rü mexü̃ i orexü̃ nixu, erü naãẽwa rü aixcüma mexü̃gu narüxĩnü. Natürü wüxi i yatü i chixecümaxü̃ rü chixexü̃ i orexü̃ nixu, erü naãẽwa rü chixexü̃gu narüxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","—Rü choma pemaã nüxü̃ chixu rü ngẽma ngunexü̃ i nagu nagúxü̃ i naãne, rü Tupana rü tá nüxna naca i guxü̃ i duü̃xü̃gü naxcèx i guxü̃ma i ore i chixexü̃ i nüxü̃ yaxuxü̃ i ñoma i naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","—Erü ngẽma curü dexagüwa rü Tupana tá cuxü̃ nangugü, rü tá cumaã nüxü̃ nixu ngoxita cume i napẽ́xewa rü ẽ́xna tama —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Rü yexguma rü ñuxre ga Parichéugü rü Yudíugüarü ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃ rü ñanagürügü Ngechuchuxü̃: —Pa Ngúexẽẽruü̃x, cuxü̃ tadauxchaü̃ na cunaxüxü̃ i wüxi i cuèxruü̃ i mexü̃ i Tupanaãrü poramaã cuxüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Ñaã duü̃xü̃gü i chixecümagüxü̃ rü tama yaxõgüxü̃ rü naxcèx ínacagü i wüxi i cuèxruü̃ i mexü̃ i Tupanaãrü poramaã üxü̃. Natürü yema cuèxruü̃ ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Yonáxü̃ ngupetüxü̃xü̃xĩca tátama nadaugü. Rü taxuü̃táma i to i cuèxruü̃ nüxü̃ tadauxẽẽ i ñaã duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","—Rü yexgumarüü̃ ga Yoná ga tomaẽ̱xpü̱x ga ngunexü̃ rü tomaẽ̱xpü̱x ga chütaxü̃ choxni ga taxü̃ ga bayenaãnüwa na nayexmaxü̃ rü wenaxãrü na nangóxü̃, rü ngẽxgumarüü̃ tá ta nixĩ i choma i tomaẽ̱xpü̱x i ngunexü̃ rü tomaẽ̱xpü̱x i chütaxü̃ i chatáxü̃wa changẽxmaxü̃. Natürü wena táxarü chango̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","—Rü ngẽxguma naãneãrü gu̱xgu rü Tupana rü ñaã duü̃xü̃güna nacaxgu i norü pecaduchiga, rü nuxcümaü̃güxü̃ ga Nínibecü̱̃ã̱x ga duü̃xü̃gü rü tá inachigü. Rü Tupanapẽ́xewa tá ínanaxuaxü̃gü i ñaã duü̃xü̃gü i ñu̱xma maxẽxü̃. Yerü nümagü ga Nínibecü̱̃ã̱x rü nüxü̃ narüxoe ga nacümagü ga chixexü̃ ga yexguma Yoná namaã nüxü̃ ixuxgu ga Tupanaãrü ore. Natürü ñu̱xma nuã petanüwa nangẽxma i wüxi i Yonáãrü yexera ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","—Rü ngẽxguma naãneãrü gu̱xgu rü Tupana rü ñaã duü̃xü̃güna nacaxgu i norü pecaduchiga, rü ngĩma ga nuxcümaü̃cü ga Chabaaneãrü ãẽ̱xgacü rü tá iichi. Rü tá íinaxuaxü̃ i ñaã duü̃xü̃gü i ñu̱xma maxẽxü̃. Yerü ngĩma rü yaxü̃waxüchi ne ixũ na ãẽ̱xgacü ga Charumóũxü̃ naxĩnüxü̃cèx ga ñuxãcü poraãcü nüxü̃ na nacuèxüchixü̃. Natürü ñu̱xma nuã petanüwa nangẽxma i wüxi i Charumóũãrü yexera ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","—Rü ngẽxguma wüxi i ngoxo rü wüxi ya yatüwa ínaxũũxgu, rü dauxchitawa i ngextá taxúema íxãpataxü̃wa rü nu ne nanaxũmare. Rü naxcèx nadau na ngexta na nangü̃xü̃cèx. Rü ngẽxguma taxuxguma nüxü̃ iyangauxgu na ngexta nangü̃e̱gaxü̃, rü nagu narüxĩnü na wena nataeguxü̃ naxcèx ya yima yatü ga noxri nawa ínaxũxũchirécü. Rü ngẽxguma nataegugu, rü nüxü̃ inayangau ya yima yatü na wüxi ya ĩ ya ngẽãcúne rü mexẽe̱ne rü meã nabixichinerüü̃ na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","—Rü ngẽma ngoxo rü ínixũ rü naxcèx nayadau i to i 7 i ngoxogü i norü yexera i chixexü̃. Rü guxü̃ma i ngẽma rü yima yatügu nayachocu, rü ngẽxma naxãchiü̃gü. Rü ngẽxguma ya yima yatü rü noxriarü yexera nachixe. Rü ngẽxgumarüü̃ tá ta nüxü̃ naxüpetü i ñaã duü̃xü̃gü i chixecümagüxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Rü yexguma duü̃xü̃gümaã íyadexayane ga Ngechuchu, rü yéma tangu ga naẽ rü naẽneẽgü. Rü ĩpataarü düxétügu tarücho, rü Ngechuchumaã tidexagüchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Rü wüxi ga duü̃xü̃ Ngechuchumaã nüxü̃ nixu, rü ñanagürü: —Yéa düxétüwa tangẽxma ya cue rü cueneẽgü, rü cumaã tidexagüchaü̃ —ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Natürü Ngechuchu nanangãxü̃ ga yema duü̃xü̃ ga namaã nüxü̃ ixuxü̃ ga yema ore, rü ñanagürü nüxü̃: —¿Texé tixĩ ya chaue? ¿Rü texégü tixĩ ya chaueneẽgü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Rü yexguma ga Ngechuchu rü norü ngúexü̃güxü̃ naxuneta, rü ñanagürü: —Dücèx, daxe tixĩ ya chaue, rü daagü nixĩ ya chaueneẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","—Erü guxãma ya texé ya naxǘxe i Chaunatü ya daxũgucüarü ngúchaü̃, rü yíxema tixĩ ya chaueneẽ rü chaueyèx rü chaue —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Rü yematama ngunexü̃gu ga Ngechuchu rü ínaxũxũ nawa ga guma ĩ ga nagu napexü̃ne. Rü naxtaxaãnacüwa nayarüto. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Rü muxü̃ma ga duü̃xü̃gü rü yéma naxcèx nangutaquẽ́xegü. Rü yemacèx düxwa wüxi ga nguegu nixüe ga Ngechuchu, rü guma nguewa narüto. Rü guxü̃ma ga duü̃xü̃gü rü yexma naxnecütẽ́xegu nachigü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Rü yexguma ga Ngechuchu rü muxü̃ma ga ore ga cuèxruü̃wa nanangúexẽẽ ga duü̃xü̃gü. Rü norü ngu̱xẽẽtaewa rü ñanagürü: —Rü wüxi ga yatü ga toecü rü trigumaã nanagüane. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","—Rü yexguma trigumaã nagüaneãgu, rü ñuxre ga guma trigu rü namacüwagu nayi. Rü ínangugü ga werigü, rü nanawecu. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","—Rü náĩgü ga trigu rü nutatanügu nayi ga ngextá ínachixcaxü̃wa ga waixü̃mü. Rü paxa narüxügü ga guma trigu, yerü ga waixü̃mü rü tama nayaxcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","—Rü yexguma nangunagügu ga üèxcü, rü narüngẽxgü ga guma trigu. Rü nayue yerü tama poraãcü nixãmèxã. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","—Rü náĩgü ga trigu rü tuxunecügu nayi. Rü yexguma nayaegu ga tuxugü, rü guma triguxü̃ inawocu, rü nanadai. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","—Natürü náĩgü ga trigu rü mexü̃ ga waixü̃mügu nayi. Rü yexguma nayaegu rü muxü̃ma ga trigu nawa ínanguxuchi. Rü nümaxü̃ rü wüxireewa rü 100 pü̱xü ínanguxuchi ga norü o, rü náĩreegüwa rü 60, rü náĩreegüwa rü 30. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","—Rü yíxema ãchi̱xẽgüxe, ¡rü nagu tarüxĩnüẽ i ngẽma ore! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Rü yexguma ga norü ngúexü̃gü rü Ngechuchucèx naxĩ, rü nüxna nacagüe, rü ñanagürügü: —Pa Corix, ¿Tü̱xcüü̃ i cuèxruü̃gügu cuyaxuãcüma cunangúexẽẽxü̃ i ñaã duü̃xü̃gü? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Tupana rü pexü̃xĩcatama nüxü̃ nacuèxẽẽ i ngẽma ẽxü̃guxü̃ na ñuxãcü ãẽ̱xgacü yiĩxü̃ i nümax. Natürü nüma i togü i duü̃xü̃gü rü tama nüxü̃ nüxü̃ nacuèxẽẽ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","—Rü texé ya aixcüma naga ĩnüxẽ i chorü ore, rü Tupana rü yexeraãcü tá tüxü̃ nüxü̃ nacuèxẽẽ. Rü ngẽmaãcü tá tüxü̃́ nangẽxma i taxü̃ i cuèx. Natürü texé ya tama naga ĩnüxẽ i ñaã ore rü Tupana tá tüxna nanayaxu i ngẽma íraxü̃ i cuèx i tüxü̃́ ngẽxmachiréxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","—Rü ngẽmacèx nixĩ i ore i cuèxruü̃maã chanangúexẽẽxü̃ i ngẽma duü̃xü̃gü. Erü nümagü rü woo nüxü̃ nadaugügu, rü ñoma tama nüxü̃ nadaugüxü̃rüü̃ nixĩgü. Rü woo nüxü̃ naxĩnüẽgu, rü ñoma tama nüxü̃ naxĩnüẽxü̃rüü̃ nixĩgü. Rü tama nüxü̃ nacuèxgüéga. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","—Rü aixcüma ngẽma duü̃xü̃güchiga nixĩ ga yema Tupanaãrü ore ga nuxcümaü̃cü ga norü orearü uruü̃ ga Ichaxía nüxü̃ ixuxü̃ ga ñaxü̃: “Rü ngẽma duü̃xü̃gü rü tá aixcüma nüxü̃ naxĩnüẽ, natürü tãũtáma nüxü̃ nacuèxgüéga i ṯacüchiga na yiĩxü̃ i ngẽma nüxü̃ naxĩnüẽxü̃. Rü aixcüma tá nüxü̃ nadaugü, natürü tãũtáma nüxü̃ nacuèxgü na ṯacüchiga yiĩxü̃ i ngẽma nüxü̃ nadaugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Erü ngẽma duü̃xü̃gü rü tãũtáma nüxü̃ nacuèxgüchaü̃ i chorü ore, rü naxchaxwa tá nügü narütütamachi̱xẽgü rü tá naxchaxwa napexetügü. Rü ngẽmaãcü tá nanaxügü na tama nüxü̃ nadaugüxü̃cèx i ngẽma mexü̃ i naxcèx chaxüxü̃, rü tama nüxü̃ naxĩnüẽxü̃cèx i chorü ore, rü tama nüxü̃ nacuèxgüxü̃cèx na ñuxãcü choma chanaxwèxexü̃ãcüma na namaxẽxü̃, rü tama chauxcèx nadaugüxü̃cèx na chanamaxẽxẽẽxü̃cèx”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Rü ñanagürü ta ga Ngechuchu: —Natürü pemax, Pa Chorü Ngúexü̃güx, rü petaãẽgü erü pexetügümaãtama nüxü̃ pedaugü i ngẽma chaxüxü̃ rü pexmachi̱xẽmaãtama nüxü̃ pexĩnüẽ i chorü ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","—Rü aixcüma pemaã nüxü̃ chixu rü muxũchixü̃ ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü rü muxũchixü̃ ga duü̃xü̃gü ga imecümaxü̃, rü nüxü̃ nadaugüchaü̃ i ngẽma ñu̱xma chauxü̃tawa nüxü̃ pedaugüxü̃. Natürü tama nüxü̃ nadaugü. Rü nüxü̃ naxĩnüẽchaü̃ i ngẽma ore i ñu̱xma chauxü̃tawa nüxü̃ pexĩnüẽxü̃. Natürü tama nüxü̃ naxĩnüẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Rü ñanagürü ta ga Ngechuchu: —¡Dücèx, iperüxĩnüẽ na ñuxũ ñaxü̃chiga yiĩxü̃ i ngẽma ore i cuèxruü̃ i toecüchiga! ");
INSERT INTO tcaNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","—Rü guma trigu ga namagu y̱ixü̃nerüü̃ tixĩgü ya yíxema nüxü̃ ĩnüẽxẽ i ore i mexü̃ na ñuxãcü ãẽ̱xgacü yiĩxü̃ ya Tupana natürü tama nüxü̃ cuèxgüxe i ñuxũ ñaxü̃chiga na yiĩxü̃ i ngẽma ore. Rü tümaxü̃tawa nangu i Chataná, rü tüxü̃ nüxü̃ inayarüngümaẽxẽẽ i ngẽma ore i tümaãẽwa ngẽxmachiréxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","—Rü guma trigu ga nutatanügu y̱ixü̃nerüü̃ nixĩ i ngẽma duü̃xü̃gü i nüxü̃ ĩnüẽxü̃ i Tupanaãrü ore rü taãẽãcüma nayauxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","—Natürü ngẽma na tama aixcüma nagu naxĩnüẽxü̃ i ngẽma ore, rü paxaãchitama nayaxõgü, rü yixcüra ngẽxguma ngẽma oregagu guxchaxü̃gü nüxü̃ üpetügu rü ẽ́xna duü̃xü̃gü naxchi aiegu, rü ínanatèxgü i ngẽma ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","—Rü guma trigu ga tuxunecügu y̱ixü̃nerüü̃ nixĩ i ngẽma duü̃xü̃gü i Tupanaãrü orexü̃ ĩnüẽxü̃ rü yaxõgüxü̃. Natürü ñoma i naãneãrü ngẽmaxü̃gücèx oegaãẽgüxü̃, rü ngẽmaguama rüxĩnüẽxü̃, rü düxwa nüxü̃ inayarüngümaẽ i ngẽma ore. Rü guxü̃ma i ngẽma rü Tupanaãrü orexü̃ nüxü̃ narüxoxẽẽ na tama aixcüma meã Tupanawe naxĩxü̃cèx i ngẽma duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","—Natürü guma trigu ga mexü̃ ga waixü̃mügu y̱ixü̃nerüü̃ nixĩ i ngẽma duü̃xü̃gü i nüxü̃ ĩnüẽxü̃ i Tupanaãrü ore, rü nüxü̃ cuèxgüxü̃ i ṯacüchiga na yiĩxü̃, rü naga ĩnüẽxü̃ rü meã naxcèx maxẽxü̃. Rü tümáxẽ rü guma trigu ga 100 pü̱xü nawa ínguxuchinerüü̃ tixĩ. Rü tümáxẽ rü guma 60 pü̱xü nawa ínguxuchinerüü̃ tixĩ. Rü tümáxẽ rü guma 30 pü̱xü nawa ínguxuchinerüü̃ tixĩ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Rü Ngechuchu rü to ga ore ga cuèxruü̃xü̃ duü̃xü̃gümaã nixu, rü ñanagürü: —Rü nüma ya Tupana rü ñoma wüxi ga yatü ga mexü̃ne ga triguchire naãnegu tocürüü̃ tá nanaxü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","—Rü guma yatü rü yexguma ínapeyane rü wüxi ga norü uwanü ga naxchi aixü̃ rü yéma naxũ. Rü naẽchita yexma trigunecügu nayatogü ga chixexü̃ ga natüane. Rü ñu̱xũchi ínixũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","—Rü yexguma naxügügu ga trigu rü nayaegu rü yexwacèx yaxo̱xgu, rü yema natüane rü ta nango̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","—Rü yexguma ga yema yatüarü duü̃xü̃gü, rü namaã nüxü̃ nayarüxugü, rü ñanagürügü: “Pa Corix, cuma rü cuanegu rü triguxicachirẽ́x ngẽxma cuto. ¿Natürü ñuxãcü i ñu̱xma rü chixexü̃ i natüane rü ta nge̱ma naxügüxü̃?” ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","—Rü yexguma ga yema naãneãrü yora, rü ñanagürü nüxü̃: “Maneca wüxi i chorü uwanü i chauxchi aixü̃ nixĩ i nge̱ma ngexü̃ wagüxü̃” ñanagürü. Rü yexguma ga norü duü̃xü̃gü rü nüxna nacagü, rü ñanagürügü: “Pa Corix, ¿cunaxwèxexü̃ na tanabéxü̃ i ngẽma chixexü̃ i natüane?” ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","—Natürü nüma ga norü cori rü ñanagürü nüxü̃ ga yema norü duü̃xü̃gü: “¡Nüe̱tama nge̱ma nangẽxmagü! Erü ngẽxguma chi penabẽ́xgu, rü ngürüãchi trigumaã chi ta penangauxẽẽ na penabéxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","—Rü narümemaẽ nixĩ i nüe̱tama nge̱ma nayae ñu̱xmatáta triguarü buxgüwa nangu. Rü ngẽxguma rü nge̱ma tá chanamugü i chorü puracütanüxü̃, rü tá nanabẽ́xira i ngẽma chixexü̃ i natüane. Rü tá ínanagoxü̃cüta, rü ñu̱xũchi tá ínanagu. Rü ngẽmawena tá nayabuxgü i trigu, rü naxchiü̃gu tá choxü̃́ namaã nanguxü̃gü” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Rü Ngechuchu rü to ga ore ga cuèxruü̃xü̃ duü̃xü̃gümaã nixu, rü ñanagürü: —Rü ngẽma Tupanaarü ore rü yexera nixũchigü. Rü ñoma wüxi ya motachachire ya wüxi ya yatü naãnegu toxü̃nerüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","—Rü woo naxíraxüchichirẽ́x ya yima naxchire, natürü ngẽxguma naxüxgu rü nayèxgu, rü wüxi i nanetü i taetaxü̃ nixĩ. Rü ngẽmacèx i werigü rü natanüwa naxĩ, rü ngẽxma nayarüxüxchiãü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Rü Ngechuchu rü to ga ore ga cuèxruü̃xü̃ duü̃xü̃gümaã nixu, rü ñanagürü: —Rü Tupanaarü ore rü duü̃xü̃gütanüwa nangu. Rü nixũchigü rü nanaxüchicüxü i norü maxü. Rü ñoma íxraxü̃ i pãũãrü puxẽẽruü̃ i wüxi i nge taxü̃ i ngĩrü pãũchara namaã ipuxẽẽxü̃rüxü̃ nixĩ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Rü guxü̃ma ga yema ore ga Ngechuchu duü̃xü̃gümaã nüxü̃ ixuxü̃, rü cuèxruü̃gu yaxuãcüma namaã nüxü̃ nixu. Rü yemaãcüxicatama nixĩ ga namaã nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Rü yemaãcü nanaxü ga Ngechuchu na yanguxẽẽãxü̃cèx ga yema Tupanaãrü ore ga nuxcümaü̃cü ga norü orearü uruü̃ ga Ichaxía ümatüxü̃ ga ñaxü̃: “Choma rü cuèxruü̃gu ixuxü̃ i oremaã tá duü̃xü̃gümaã chidexa. Rü tá namaã chanango̱xẽẽ i ngẽma cuèx i ẽxü̃guxü̃ ga yexguma noxri naãne ixügügumama iicúxü̃”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Rü Ngechuchu ínayamugü ga duü̃xü̃gü, rü guma ĩ ga nagu napexü̃negu naxücu. Rü norü ngúexü̃gü rü yéma naxcèx naxĩ, rü ñanagürügü nüxü̃: —Pa Corix, ¡tomaã nango̱xẽẽ na ṯacüchiga yiĩxü̃ i ngẽma chixexü̃ i natüanegu ixuxü̃ i ore! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Rü yima mexü̃ i trigumaã toecü, rü nüma nixĩ ya Tupana Nane ya duü̃xü̃xü̃ ixĩcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","—Rü ngẽma naãne i nagu natoexü̃, rü ñoma i naãne nixĩ. Rü ngẽma mexü̃ i trigu rü ngẽma nixĩ i duü̃xü̃gü i Tupanaãrü duü̃xü̃gü ixĩgüxü̃. Rü ngẽma chixexü̃ i natüane, rü ngẽma nixĩ i duü̃xü̃gü i Chatanáãrü ixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","—Rü ngẽma norü uwanü i chixexü̃ i natüanemaã naẽchita naãnegu yatoexü̃, rü ngẽma nixĩ i Chataná. Rü ngẽma ngunexü̃ i nagu nabuxuxü̃ i trigu rü naãneãrü gúxchiga nixĩ. Rü ngẽma puracütanüxü̃ i triguarü buxwa puracüexü̃, rü Tupanaãrü orearü ngeruü̃gü i daxũcü̱̃ã̱x nixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","—Rü ngẽxgumarüü̃ i ngẽma chixexü̃ i natüane rü na nabéxü̃ rü ñu̱xũchi na ínaguxü̃, rü ngẽxgumarüü̃ tá ta nixĩ i naãneãrü gu̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","—Rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü tá chanamu i chorü orearü ngeruü̃gü i daxũcü̱̃ã̱x na nadeãxü̃cèx i ngẽma duü̃xü̃gü i chixexü̃ ügüxü̃ rü ngẽma duü̃xü̃gü i ṯoguã̱xü̃ chixexü̃ ügüxẽẽxü̃. Rü tá ínanawoxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","—Rü tá üxüxetüwa nayawocu. Rü nge̱ma tá naxauxe rü tá nixü̃́xchapütagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","—Natürü guxü̃ma i ngẽma duü̃xü̃gü i Tupanaga ĩnüẽxü̃, rü tá üèxcürüü̃ inabaixgü i ngextá Tanatü ya Tupana ãẽ̱xgacü íixĩxü̃wa. Rü yíxema ãchi̱xẽgüxe, ¡rü nüxü̃ taxĩnüẽ i ngẽma ore! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Rü Ngechuchu rü to ga ore ga cuèxruü̃xü̃ duü̃xü̃gümaã nixu, rü ñanagürü: —Rü ngẽma na ãẽ̱xgacü yiĩxü̃ ya Tupana rü duü̃xü̃gücèx rü namexechi ñoma wüxi i uiru i wüxi i naãnegu icúxü̃rüxü̃. Rü wüxi ya yatü rü ngẽxguma nüxü̃ iyangauxgu i ngẽma uiru, rü paxa wena ngẽma naãnegu nayacu̱x. Rü taãẽãcüma namaã nataxe i guxü̃ma i norü ngẽmaxü̃gü na naxcèx nataxexü̃cèx i ngẽma naãne na noxrü yiĩxü̃cèx i ngẽma uiru —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Rü ñanagürü ta ga Ngechuchu: —Rü duü̃xü̃gü rü ñoma wüxi i taxetanüxü̃ i nutagü ya ngèxãẽruü̃cèx dauxü̃rüü̃ nixĩgü na poraãcü Tupanaxcèx nadaugüxü̃ na nüma norü ãẽ̱xgacü yixĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","—Rü ngẽma taxetanüxü̃ rü ngẽxguma düxwa nüxü̃ iyangauxgu ya wüxi ya nuta ya ngèxãẽruü̃ ya guxü̃ãrü yexera mexẽchicü, rü namaã nataxe i guxü̃ma i norü ngẽmaxü̃gü na naxcèx nataxexü̃cèx ya yima nuta ya mexẽchicü, na noxrü yiĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Rü ngẽma Tupana na ãẽ̱xgacü yixĩxü̃ rü wüxi i pücha i nagúxü̃raü̃xü̃ i choxni namaã iyaxuxü̃xü̃rüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","—Rü ngẽxguma naxããcuxgu i ngẽma pücha, rü ngẽma püchaetanüxü̃ rü naxnecüpechinügu ínanatúãchigü. Rü nge̱ma narütogü rü nayadexechi i ngẽma mexü̃ i choxni, rü pexchigu nananucu. Rü ngẽma tama ingṍxü̃ i choxni rü ínanawogü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","—Rü ngẽxgumarüü̃ tá nixĩ i ngẽxguma nagu̱xgu i naãne. Erü Tupanaãrü orearü ngeruü̃gü i daxũcü̱̃ã̱x, rü núma tá naxĩ. Rü tá nayadexechi i ngẽma mexü̃ i duü̃xü̃gü nüxna i ngẽma ichixexü̃, rü tá üxüxetüwa nayawocu i ngẽma duü̃xü̃gü i chixexü̃. Rü nge̱ma tá naxauxe, rü tá nixü̃́xchapütagü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Rü yexguma ga Ngechuchu rü norü ngúexü̃güna naca, rü ñanagürü: —¿Nüxü̃ pecuáxü̃ yiĩxü̃ na ṯacüchiga yiĩxü̃ i ngẽma pemaã nüxü̃ chixuxü̃? —ñanagürü. Rü nümagü nanangãxü̃gü rü ñanagürügü: —Ngẽmáãcü, Pa Corix, nüxü̃ tacuèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Rü ngẽxguma wüxi i ngúexẽẽruü̃ i ore i mugüwa ngu̱xẽẽtaexü̃ aixcüma nüxü̃ cuèxgu na ñuxãcü ãẽ̱xgacü yiĩxü̃ ya Tupana, rü nanaxwèxe na meã nüxü̃ nacuáxü̃ i ngẽma nuxcümaü̃xü̃ i Tupanaãrü ore rü ñaã ngexwacaxü̃xü̃ i chorü ore rü ta, ngẽxgumarüü̃ i wüxi i cori i norü taxepatawa duü̃xü̃gücèx inawéxü̃ i norü ngẽmaxü̃gü i ngexwacaxü̃güxü̃ rü norü ngẽmaxü̃gü i nuxcümaü̃güxü̃ ta —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Rü yexguma Ngechuchu nüxü̃ rüchauxgu ga yema ore ga cuèxruü̃güxü̃ na yaxuxü̃, rü inaxũãchi ga yéma. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Rü guma ĩãne ga nawa nayaxü̃ne ga Nacharétuwa naxũ. Rü guma ĩãneãrü ngutaquẽ́xepataü̃gu naxücu rü yéma nanangúexẽẽ ga duü̃xü̃gü. Rü yema duü̃xü̃gü rü nabèi̱xãchiãẽgü namaã ga norü ore. Rü ñanagürügü: —¿Ngextá nüxü̃ nacuèx i ngẽma ngu̱xẽẽtae? ¿Rü ñuxãcü nüxü̃ nacuèx na naxüãxü̃ i ngẽma mexü̃gü i taxü̃gü i Tupanaãrü poramaã naxüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","—¿Taux ẽ́xna i daa yiĩxü̃ ya carpinteru ya Yúche nane ya María ngĩne, ya Chaü̃tiágu rü Yúche rü Chimáũ rü Yuda naẽneẽ ixĩcü? ");
INSERT INTO tcaNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","—¿Rü taux ẽ́xna i naẽyèxgü rü nuxma tatanügu naxãchiü̃güxü̃? ¿Rü ngẽxguma i ngextá yiĩxü̃ i nayauxãxü̃ i ngẽma nüxü̃ nacuáxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Rü yemacèx ga duü̃xü̃gü rü tama nüxü̃́ inarüxĩnüẽchaü̃. Natürü Ngechuchu rü ñanagürü nüxü̃: —Guxü̃ma i togü i duü̃xü̃gü rü namaã nataãẽgü i wüxi i Tupanaãrü orearü uruü̃. Natürü ngẽma orearü uruü̃chiü̃ãnewatama rü duü̃xü̃gü rü tama namaã nataãẽgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Rü yema duü̃xü̃gütanüwa rü tama poraãcü nanaxü ga mexü̃gü ga taxü̃gü ga Tupanaãrü poramaã naxüxü̃, yerü tama nüxü̃́ nayaxõgüchaü̃ ga yema duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Rü yema ngunexü̃gügu nixĩ ga Gariréaaneãrü ãẽ̱xgacü, ga Erode rü Ngechuchuxü̃ nacuáchigaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Rü Erode rü norü duü̃xü̃gümaã ñanagürü: —Yima nixĩ ya Cuáü̃ ga baiü̃xẽẽruü̃ rü marü wena namaxü̃. Rü ngẽmacèx nüxü̃́ nangẽxma i pora na naxüãxü̃ i ngẽma mexü̃gü i taxü̃gü i Tupanaãrü poramaã naxüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Rü yema ñanagürü, yerü nümatama ga Erode rü ü̃paacü norü churaragüxü̃ namu na Cuáü̃xü̃ yayauxgüxü̃cèx rü cadenamaã yanèĩ̱xgüãcüma poxcupataü̃wa nagagüãxü̃cèx. Rü yemaãcü nanaxü ga Erode, yerü yemaãcü naxcèx íica ga naxmèx ga Erodía ga naẽneẽ ga Piripi naxmèxchirẽ́x ixĩcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Rü Erode rü Cuáü̃maã nanu yerü ga Cuáü̃ rü ñanagürü nüxü̃: —Tama name na cuxumèxmaã cuxãmaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Rü Erode rü Cuáü̃xü̃ nimáxchaü̃, natürü duü̃xü̃güxü̃ namuü̃ yerü guxü̃ma ga duü̃xü̃gü rü nagu narüxĩnüẽ rü aixcüma Tupanaãrü orearü uruü̃ nixĩ ga Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Natürü yexguma norü taunecüarü ngunexü̃wa nanguxgu ga Erode rü wüxi ga peta naxü. Rü yema petawa rü Erodíaxacü rü íyayüxparachigüxü̃ napẽ́xewa ga yema petatanüxü̃. Rü nüma ga ãẽ̱xgacü ga Erode rü poraãcü norü me nixĩ ga yema naxüxü̃ ga naxãcürücü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Rü yemacèx ngĩmaã inaxuneta rü ñanagürü ngĩxü̃: —¡Choxna naxcèx naca i ṯacü i cunaxwèxexü̃, rü aixcüma tá cuxna chanaxã! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Rü yexguma ga ngĩma rü ngĩẽxü̃tawa ixũ, rü ngĩẽna iyaca, rü ngĩgürügü: —Pa Ma, ¿ṯacü i cunaxwèxexü̃ na naxcèx íchac̱axü̃? —ngĩgürügü. Rü ngĩẽ ngĩxü̃ ingãxü̃, rü ngĩgürügü: —¡Naxcèx ínaca i Cuáü̃ ya baiü̃xẽẽruü̃ẽru! —ngĩgürügü ga ngĩẽ. Rü yexguma ga yema pacü rü ngĩgürügü nüxü̃ ga Erode: —Chanaxwèxe i wüxi ya poratugu choxna cunaxã i Cuáü̃ ya baiü̃xẽẽruü̃ẽru —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Rü yexguma ga ãẽ̱xgacü ga Erode rü inayarümaãchi namaã ga yema ore, natürü norü unetacèx rü norü petatanüxü̃cèx rü tama ngĩxü̃ nawomüxẽẽchaü̃. Rü nanamu ga ñuxre ga norü churaragü na ngĩxna naxãgüãxü̃cèx ga yema naxcèx ínac̱axü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Rü yemaãcü poxcupataü̃wa nanamu na yéma Cuáü̃xü̃ yanadaenaãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Rü yemawena wüxi ga poratugu ngĩxü̃tawa nanange ga Cuáü̃ẽru, rü yema pacüna nayaxã. Rü ngĩma rü ñu̱xũchi ngĩẽna iyaxã. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Rü yexguma ga Cuáü̃ãrü ngúexü̃gü rü yéma naxĩ, rü nayangegü ga naxü̃ne, rü inayatèxgü. Rü yemawena rü Ngechuchumaã nüxü̃ nayarüxugüe. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Rü yexguma yemaxü̃ nacuáchigagu ga Ngechuchu, rü nüxĩcatama wüxi ga nguegu nixüe, rü ínaxũxũ ga yéma. Rü wüxi ga nachica ga taxúema íxãpataxü̃wa naxũ. Natürü ga duü̃xü̃gü rü nüxü̃ nacuèxgüama ga ngextá na naxũxü̃. Rü ínachoxü̃ ga norü ĩãnegüwa, rü dauxchitagu nawe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Rü yexguma nguewa ínaxüegu ga Ngechuchu rü nüxü̃ nadau ga yema muxü̃ma ga duü̃xü̃gü. Rü nüxü̃́ nangechaü̃tümüü̃gü. Rü nanameẽxẽẽ ga yema duü̃xü̃gü ga iḏaaweexü̃ ga naxcèx yéma nagagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Rü yexguma marü nachütachaü̃gu rü Ngechuchucèx naxĩ ga norü ngúexü̃gü, rü ñanagürügü nüxü̃: —Marü nachütachaü̃, rü ñu̱xũchi taxúema nuxma taxãpata i nuã. Rü name nixĩ ícuyamugü i ñaã duü̃xü̃gü na ĩãnexãcügü ya ngaicamana ngẽxmagünewa naxĩxü̃cèx, rü nge̱ma norü õnatèèx yataxegüxü̃cèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —Taxuacüma nawoegu. ¡Rü pematama penachibüexẽẽx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rü nümagü nanangãxü̃gü, rü ñanagürügü: —Natürü nuã rü wüximẽ́ẽ̱xpü̱x i pãũ rü taxre i choxnixĩcatama toxü̃́ nangẽxma —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —¡Nuã chauxü̃tawa penana! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Rü yexguma ga Ngechuchu rü duü̃xü̃güxü̃ namu na maxẽtẽ́xewa natogüxü̃cèx. Rü ñu̱xũchi nanade ga yema wüximẽ́ẽ̱xpü̱x ga pãũ rü yema taxre ga choxnigü. Rü daxũgu nadawenüãcüma Tupanana moxẽ naxã, rü ñu̱xũchi inanabücu ga yema pãũgü. Rü norü ngúexü̃güna nanana, rü yema duü̃xü̃güxü̃ nayanu. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Rü guxü̃ma ga yema duü̃xü̃gü rü meãma nachibüe. Rü yemawena rü 12 ga pexchigü nanapagüamatama namaã ga yema pãũ rü choxnichipẽ́xegü ga íyaxügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Rü yema yéma chibüexü̃ rü 5000 ga yatügü nixĩ, natürü ga ngexü̃gü rü buxü̃gü rü tama nayaxugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Rü yemawena ga Ngechuchu rü duü̃xü̃güxü̃ íyamugüyane rü wüxi ga nguegu nayachoü̃xẽẽ ga norü ngúexü̃gü na yoxni naxtaxaarü tocutüwa naxĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Rü yexguma duü̃xü̃güxü̃ íyamugüguwena rü guma mèxpǘnewa ínaxü̃ãchi ga Ngechuchu na nüxĩca yéma yayumüxẽxü̃cèx. Rü yexma nüxĩcatama nachütaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Natürü ga norü ngúexü̃gü rü naxtaxaarü ngãxü̃tüchiügu nixãgü ga yexguma. Rü tacü ga buanecü yexma nüxü̃ naxü, rü poraãcü nayuape. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Rü yexguma marü yangunechaü̃gu rü norü ngúexü̃güwe inaxũãchi ga Ngechuchu. Rü dexáchiüétügu nixũ naxcèx ga norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Rü yexguma norü ngúexü̃gü nüxü̃ daugügu ga dexáchiüétügu na yaxũxü̃, rü poraãcü nabèi̱xãchiãẽgü. Rü norü muü̃maã aita naxüe, rü ñanagürügü: —Wüxi i naxchi̱ximare nixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Natürü ga Ngechuchu rü namaã nidexa rü ñanagürü nüxü̃: —¡Peporae! rü choma chixĩ. ¡Rü tãxṹ ipemuü̃ẽxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Rü yexguma ga Pedru rü Ngechuchumaã nidexa rü ñanagürü: —Pa Corix, ega chi cuma quixĩgu, ¡rü choxü̃ namu na choma rü ta dexáétügu chixũxü̃cèx rü cuxü̃tawa na chaxũxü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Rü Ngechuchu ñanagürü nüxü̃: —Ẽcü ¡nuã naxũ! —ñanagürü. Rü yexguma ga Pedru rü ínaxüe ga nguewa. Rü inanaxügü ga dexáétügu na yaxũxü̃ na Ngechuchuxü̃tawa naxũxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Natürü yexguma nüxü̃ yacuèxãchigu ga na naporaxü̃ ga buanecü rü namuü̃, rü inanaxügü ga na dexáchiügu nanguxü̃. Rü aita naxü rü ñanagürü: —Pa Corix, ¡choxü̃ rüngü̃xẽẽ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Rü yexgumatama ga Ngechuchu rü Pedrumẽ́xẽgu nayayauxãchi, rü ñanagürü nüxü̃: —Cuma rü írarüwatama cuyaxõ. ¿Rü tü̱xcüü̃ tama aixcüma cuyaxõxõchi? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Rü yexguma nguegu yachoü̃gu ga Ngechuchu rü Pedru, rü nangupetü ga guma buanecü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Rü guxü̃ma ga norü ngúexü̃gü ga nguewa yexmagüxü̃ rü Ngechuchupẽ́xegu nacaxã́pü̱xügü rü nüxü̃ nicuèxüü̃gü, rü ñanagürügü nüxü̃: —Aixcümaxü̃chi cuma nixĩ i Tupana Nane quiĩxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Rü yexguma marü yanguü̃gu ga naxtaawa, rü Yenecharétuanewa nangugü rü yéma ínachoü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Rü yexguma yema duü̃xü̃gü ga yémacü̱̃ã̱x nüxü̃ icuèxãchitanügu ga Ngechuchu na yiĩxü̃ ga guma, rü guxü̃ma ga yema naãnewa nanguchiga ga yéma na nayexmaxü̃ ga Ngechuchu. Rü yemacèx naxü̃tawa nanagagü ga yema duü̃xü̃gü ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Rü Ngechuchuxü̃ nacèèxü̃gü na naxchirupechinügumare yangõgügüxü̃cèx. Rü guxü̃ma ga yema naxchirupechinügu ingõgüexü̃ rü narümeẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Rü Ngechuchucèx naxĩ ga ñuxre ga Parichéugü rü ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃ ga Yerucharéü̃wa ne ĩxü̃. Rü Ngechuchuna nacagü, rü ñanagürügü: ");
INSERT INTO tcaNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Tü̱xcüü̃ i curü ngúexü̃gü rü tama nagu naxĩ i nuxcümaü̃güxü̃ i tórü o̱xigücüma? ¿Rü tü̱xcüü̃ tama nayanguxẽẽgü i ngẽma nacüma na Tupanacèx nayauxmẽ́xgüxü̃ naxü̃pa na nachibüexü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Natürü ga Ngechuchu rü nüxna naca ga yema Parichéugü rü ngúexẽẽruü̃gü, rü ñanagürü nüxü̃: —¿Rü tü̱xcüü̃ i pema rü nüxü̃ pexo i Tupanaãrü mu na nagu pexĩxü̃cèx i pecümagütama? ");
INSERT INTO tcaNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Erü Tupana rü norü orewa rü ñanagürü: “¡Tüxü̃ nangechaü̃ ya cunatü rü cue!” ñanagürü. Rü ngẽma orewa rü ñanagürü ta: “Rü texé ya tümanatümaã rü ẽ́xna tümaẽmaã guxchigaxe rü name nixĩ i noxtacüma ngẽmacèx tüxü̃ tayuxẽẽ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Natürü pema rü ñaperügügü: “Marü name ega wüxi ya yatü nanatüxü̃ rü naẽxü̃ ñaxgu: ‘Taxucürüwa chorü ngẽmaxü̃maã cuxü̃ charüngü̃xẽẽ erü guxü̃ma i chorü ngẽmaxü̃ rü marü Tupanana chanaxã’,” ñaxgu. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Rü ngẽxguma texé ngẽma ñagügu rü pexcèx rü marü namexü̃ na tama tümanatüxü̃ rü tümaẽxü̃ tarüngü̃xẽẽxü̃. Rü ngẽmaãcü ipeyanaxoxẽẽ i Tupanaãrü mu na nagu pexĩxü̃cèx i pecümagütama. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Pema nixĩ i duü̃xü̃gü i togüpẽ́xewa rü meã pemaxẽnetaxü̃, natürü peãẽwa rü chixexü̃gu perüxĩnüẽ. Rü aixcüma nixĩ ga yema ore ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ichaxía pechiga ümatüxü̃ ga ñaxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ñaã duü̃xü̃gü rü naã̱xmaãmare choxü̃ nicuèxüü̃gü. Natürü naãẽwa rü tama aixcüma chaugu narüxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Rü taxuwama name na ngẽmaãcü natücèxma choxü̃ yacuèxüü̃güxü̃. Rü guxü̃ma i norü ngu̱xẽẽtae rü yatügüarü mugümare nixĩ rü tama aixcüma chorü mu nixĩ”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Rü ñu̱xũchi ga Ngechuchu rü duü̃xü̃gücèx naca, rü ñanagürü nüxü̃: —¡Meã iperüxĩnüẽ i ñaã chorü ore, rü nagu perüxĩnüẽ! ");
INSERT INTO tcaNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ngẽma õna i duü̃xü̃gü ngṍxü̃ rü tama ngẽma nixĩ i napecaduã̱xẽẽgüxü̃. Natürü ngẽma ore i chixexü̃ i nüxü̃ yaxuxü̃, rü ngẽma waxi nixĩ i napecaduã̱xẽẽgüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Rü ñu̱xũchi ga norü ngúexü̃gü rü naxcèx naxĩ, rü ñanagürügü nüxü̃: —¿Pa Corix, tama ẽ́xna nüxü̃ cucuèx na Parichéugüãẽwa nangúxü̃ i ngẽma ore i namaã nüxü̃ quixuxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Natürü nüma ga Ngechuchu rü nanangaxü̃ rü ñanagürü nüxü̃: —Guxü̃ma i ngema nanetü i tama Chaunatü itoxü̃ rü tá nanabẽ́x. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Rü nüe̱tama i ngẽma Parichéugü, erü namaãrü cuèxruü̃gü i ngexetüxü̃rüü̃ nixĩgü. Rü ngẽxguma wüxi i ngexetüxü̃ rü naxrüü̃ ngexetüxü̃maã inacuèxgu rü ngürüãchi ngẽma taxre rü wüxi i ãxmaxü̃gu tá nügümaã nayayicu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Rü ñu̱xũchi ga Pedru rü Ngechuchuna naca, rü ñanagürü: —¡Tomaã meã nango̱xẽẽ na ñuxũ ñaxü̃chiga yiĩxü̃ i ngẽma ore i tomaã nüxü̃ quixuxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —¿Ẽ́xna pema rü ta tama nüxü̃ pecuèxgüéga i ngẽma ore? ");
INSERT INTO tcaNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Tama ẽ́xna nüxü̃ pecuèx rü guxü̃ma i ngẽma õna i duü̃xü̃gü ngṍxü̃ rü naãnüwa naxũ, rü yixcama rü ñu̱xũchi ínaxũxũ? ");
INSERT INTO tcaNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Natürü guxü̃ma i ngẽma ore i duü̃xü̃gü nüxü̃ ixuxü̃ rü naãẽwa nixĩ i ne naxũxü̃. Rü ngẽma ore i chixexü̃ waxi nixĩ i napecaduã̱xẽẽgüxü̃ i ngẽma duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Erü naãẽwa nixĩ i chixexü̃gu naxĩnüẽxü̃ i duü̃xü̃gü. Rü nge̱ma ne naxũ na namáẽtaxü̃, rü to i ngexü̃ i ãtexü̃maã na inapexü̃, rü na nangẽãẽmarexü̃, rü na nangĩ́xü̃, rü na yadoratèxáxü̃, rü na naguxchigawèxexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Rü guxü̃ma i ngẽma chixexü̃ waxi nixĩ i duü̃xü̃güxü̃ pecaduã̱xẽẽxü̃. Natürü ngẽma na tama nayauxmẽ́xgüxü̃ naxü̃pa na nachibüexü̃, rü ngẽma rü tama nanapecaduã̱xẽẽ i duü̃xü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Rü yexguma yéma inaxũãchigu ga Ngechuchu, rü Tiruane rü Chidã́ũãneãrü ĩãnegüwa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Rü Ngechuchuxü̃tawa ingu ga wüxi ga ngecü ga Canácü̱̃ã̱x ga Tiruanegu ãchiü̃cü. Rü tagaãcü ngĩgürügü nüxü̃: —Pa Cori Pa Dabítanüxü̃x, ¡cuxü̃́ changechaü̃tümüü̃! Erü chauxacü rü wüxi i ngoxo ngĩwa nangẽxma i poraãcü ngĩxü̃ chixewexü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Natürü ga Ngechuchu rü tama ngĩxü̃ nangãxü̃. Rü düxwa ga norü ngúexü̃gü rü naxcèx naxĩ, rü Ngechuchuxü̃ nacèèxü̃gü, rü ñanagürügü: —Pa Corix ¡Ngĩmaã nüxü̃ ixu i ngẽma nge rü íyaxũ, erü tawe iyacaechigü! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Rü yexguma ga Ngechuchu rü ñanagürü: —Tupana núma choxü̃ namu na Yudíugü i pecaduã̱xgüxü̃cèxicatama na chadauxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Natürü ngĩma ga yema nge ga tama Yudíu ixĩcü rü Ngechuchucèx iyaxũ. Rü napẽ́xegu iyacaxã́pü̱xü, rü ngĩgürügü nüxü̃: —Pa Corix ¡choxü̃ rüngü̃xẽẽ! —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Natürü Ngechuchu rü ñanagürü: —Tama name i taxacügüna tanapu i norü õna na airugüna naxãxü̃cèx —ñanagürü. Rü yema ñanagürü yerü nümagü ga Yudíugü rü nügü nixugüe na Tupanaxãcügüxüchi yiĩgüxü̃ rü yema togü rü ñoma airugürüü̃ na yixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Natürü ngĩma ga yema nge rü ngĩgürügü: —Rü aixcüma nixĩ i curü ore, Pa Corix, natürü airugü rü ta norü yoraarü õnatüchi i mechawa rüyixü̃ nangõ̱x —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Rü yexguma ga Ngechuchu rü ñanagürü ngĩxü̃: —Pa Ngecüx, aixcümaxü̃chi cuyaxõ. Marü tá chanaxü i ngẽma cuma cunaxwèxexü̃ —ñanagürü. Rü yexgumatama ngĩxcèx nitaane ga ngĩxãcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Rü yemawena ga Ngechuchu rü inaxũãchi ga yema naãnewa, rü naxtaxa ga Gariréacutüwa naxũ. Rü ñu̱xũchi wüxi ga mèxpǘnewa ínaxü̃ãchi, rü yéma nayarüto. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Rü muxü̃ma ga duü̃xü̃gü naxü̃tawa nangugü. Rü yéma naxü̃tawa nanagagü ga duü̃xü̃gü ga ichixeparagüxü̃, rü ngexetügüxü̃, rü tama idexagüxü̃, rü chixechacüügüxü̃, rü muxü̃ma ga togü ga iḏaaweexü̃. Rü Ngechuchupẽ́xegu nayamugü, rü nüma ga Ngechuchu rü nanameẽxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Rü ga duü̃xü̃gü rü poraãcü nabèi̱xãchiãẽgü ga yexguma nüxü̃ nadaugügu ga ñuxãcü yema noxri tama idexagüxü̃ rü marü na yadexagüxü̃, rü yema noxri chixechacüügüxü̃ rü marü naxcèx na yataanegüxü̃, rü yema noxri chixeparagüxü̃ rü marü na nameparagüxü̃, rü yema noxri ngexetügüxü̃ rü marü na yadauchigüxü̃. Rü yemacèx ga duü̃xü̃gü rü Tupanaxü̃ nicuèxüü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Rü ñu̱xũchi ga Ngechuchu rü norü ngúexü̃gücèx naca, rü ñanagürü nüxü̃: —Choxü̃́ nangechaü̃tümüü̃gü i ñaã duü̃xü̃gü, erü marü tomaẽ̱xpü̱x i ngunexü̃ nuã chauxü̃tawa nangẽxmagü, rü nüxü̃́ nataxuma i norü õna. Rü taxuacüma ngẽmaãcümare nachiü̃wa chanamugü, erü ngürüãchi namagu tá nayaturae —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Rü norü ngúexü̃gü rü ñanagürügü nüxü̃: —¿Natürü ngextá tá tanayaxu i õna naxcèx i guxü̃ma i ñaã duü̃xü̃gü? Erü taxúema nuxma taxãpata i nuã —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Rü Ngechuchu nüxna naca, rü ñanagürü: —¿Ñuxre i pãũ pexü̃́ nangẽxma i pemax? —ñanagürü. Rü nanangãxü̃gü, rü ñanagürügü: —Toxü̃́ nangẽxma i 7 i pãũ rü noxretama i choxnixãcügüxicatama —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Rü ñu̱xũchi ga Ngechuchu rü duü̃xü̃güxü̃ namu na ñaxtüanewa natogüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Rü nanade ga yema 7 ga pãũ rü yema choxnigü. Rü Tupanana moxẽ naxã. Rü ñu̱xũchi inanabücu. Rü norü ngúexü̃güna nanana na duü̃xü̃güxü̃ yanuãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Rü guxü̃ma ga duü̃xü̃gü rü meãma nachibüe. Rü yemawena rü 7 ga pexchigü nanapagüamatama namaã ga yema pãũ rü choxnichipẽ́xegü ga íyaxügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Rü yema yéma chibüexü̃ rü 4,000 ga yatügü nixĩ, natürü ga ngexü̃gü rü buxü̃gü rü tama nayaxugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Rü yemawena ga Ngechuchu rü duü̃xü̃güxü̃ ínimugü. Rü ñu̱xũchi wüxi ga nguegu nixüe, rü Magadáarü naãnewa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Rü ga Parichéugü rü Chaduchéugü rü Ngechuchuxü̃ ínayadaugü. Rü Ngechuchuna nacagüe na nüxü̃ nüxü̃ nadauxẽẽgüxü̃cèx ga wüxi ga cuèxruü̃ ga Tupanaãrü poramaã naxüxü̃, yerü nüxü̃ naxügüchaü̃mare. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Natürü nüma ga Ngechuchu rü nanangãxü̃, rü ñanagürü nüxü̃: —Pema rü yáuanecü rü ñaperügügü: “Name tá nixĩ i moxü̃ãrü ngunexü̃, erü nadautüweane”, ñaperügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Rü ngẽxguma pèxmama nadautüweanegu rü poraãcü nacaixanegu, rü: “Nachixe tá nixĩ i ngunexü̃” ñaperügügü. Pema nixĩ i duü̃xü̃gü i togüpẽ́xewa meã pemaxẽnetaxü̃, natürü chixexü̃gu perüxĩnüẽ. Rü pema nüxü̃ pecuèx na penangugüxü̃ i ñuxgu tá nameãnexü̃ rü ñuxgu tá nachixeanexü̃. Natürü ñu̱xma na yanguxü̃ i ngẽma cuèxruü̃gü ga nuxcüma Tupana pemaã ixunetaxü̃ rü tama nüxü̃ pecuèxgüéga na ṯacüchiga yiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Rü ñanagürü ta ga Ngechuchu: —Ñaã duü̃xü̃gü i chixecümagüxü̃ rü tama yaxõgüxü̃ rü naxcèx ínacagü i wüxi i cuèxruü̃ i Tupanaãrü poramaã üxü̃. Natürü yema cuèxruü̃ ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Yonáxü̃ ngupetüxü̃rüü̃xicatátama nadaugü. Rü yexgumarüü̃ na bayenaãnüwa na ínaxũxũxü̃, rü choma rü ichatáxü̃wa tá íchaxũxũ. Rü taxuxü̃táma i to i cuèxruü̃xü̃ nüxü̃ chadauxẽẽ i ñaã duü̃xü̃gü —ñanagürü. Rü ñu̱xũchi nüxna yéma nixũ ga Ngechuchu, rü inaxũãchi. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Rü yexguma naxtaxaarü tocutüwa naxĩxgu ga norü ngúexü̃gü, rü nüxü̃ inayarüngümaẽ na nawemü ta íyangegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Dücèx, pexuãẽgü naxcèx i Parichéugü rü Chaduchéugüarü pãũãrü puxẽẽruü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rü yema norü ngúexü̃gü rü inanaxügüe ga nügü na ñagüxü̃: —Ngẽma ñanagürü tüxü̃, erü tama tawemüta ítingegü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Natürü ga Ngechuchu rü nüxü̃ nacuèxama ga ñuxãcü na yadexagüxü̃ ga norü ngúexü̃gü. Rü yemacèx ñanagürü nüxü̃: —¿Tü̱xcüü̃, “Tüxü̃́ nataxu i tawemü” ñaperügügü? Pema rü tama aixcüma peyaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","—¿Tama ẽ́xna nüxü̃ pecuèxgüéga rü nüxna pecuèxãchie ga yema wüximẽ́ẽ̱xpü̱x ga pãũ ga yema 5,000 ga yatügücèx ichabücuxü̃? ¿Rü ñuxre ga pexchi penaxüãcuxü̃ namaã ga yema naxchipẽ́xegü ga íyaxügüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","—¿Rü tama ẽ́xna nüxna pecuèxãchie ga yema 7 ga pãũ ga yema 4,000 ga yatügücèx ichabücuxü̃? ¿Rü ñuxre ga pexchi penaxüãcuxü̃ namaã ga yema naxchipẽ́xegü ga íyaxügüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","—¿Rü ñuxãcü nixĩ i tama nüxü̃ pecuáxü̃ i tama pãũchiga na chidexaxü̃ i ngẽxguma ñachagu: “¡Pexuãẽgü naxcèx i Parichéugü rü Chaduchéugüarü pãũãrü puxẽẽruü̃!” ñachagu? —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Rü yexguma ga norü ngúexü̃gü rü nüxü̃ nacuèxgü ga tama pãũãrü puxẽẽruü̃chiga na yadexaxü̃ ga Ngechuchu, natürü Parichéugü rü Chaduchéugüarü ngu̱xẽẽtaechiga na yiĩxü̃ ga na yadexaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Rü yexguma Checharéa ga Piripuaneãrü ngaicamana nanguxgu ga Ngechuchu, rü norü ngúexü̃güna naca, rü ñanagürü: —¿Ñuxũ ñaxü̃ i duü̃xü̃gü i chauchiga na texé chiĩxü̃ i chomax? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rü nüma ga norü ngúexü̃gü rü nanangãxü̃ rü ñanagürügü: —Nangẽxma i duü̃xü̃gü rü: “Cuáü̃ ya baiü̃xẽẽruü̃ quixĩ” ñagüxü̃. Rü togü i: “Ería quixĩ” ñagüxü̃. Rü togü i: “Yeremíã quixĩ” ñagüxü̃. Rü togü rü: “Wüxi ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ quixĩ” ñagüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Rü yexguma ga Ngechuchu rü nüxna naca rü ñanagürü: —¿Rü pema i ñuxũ ñapegüxü̃ choxü̃ na texé chiĩxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Rü Chimáũ ga Pedru nanangãxü̃, rü ñanagürü nüxü̃: —Cuma nixĩ i Cristu ya Tupana ya maxü̃cü Nane quiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Cuma rü aixcüma cutaãẽ, Pa Chimáũx, Pa Yoná Nanex, erü taxuü̃ma i duü̃xü̃ nixĩ i cuxü̃ nüxü̃ cuèxẽẽxü̃ i ngẽma, natürü Chaunatü ya daxũgucü nixĩ ya cuxü̃ nüxü̃ cuèxẽẽcü na Nane chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","—Rü choma cumaã nüxü̃ chixu rü cuma rü Pedru quixĩ. Rü ngẽma cuéga rü “nuta” ñaxü̃chiga nixĩ. Rü cuma tá nixĩ i chorü duü̃xü̃güarü dauruü̃ quiĩxü̃. Rü Chataná rü tãũtáma nüxü̃ narüyexera i ngẽma chorü duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","—Rü choma rü tá cuxna chanaxã i chorü ore na duü̃xü̃gümaã nüxü̃ quixuxü̃cèx na nüxü̃ nacuèxgüxü̃cèx na ñuxãcü daxũguxü̃ i naãnewa nangugüxü̃ i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa. Rü yíxema tama cuxü̃́ irüxĩnüẽxẽ i ngẽma ore rü tãũtáma nge̱ma tichocu. Natürü yíxema meã cuxü̃́ irüxĩnüẽxẽ i ngẽma ore rü aixcüma nge̱ma Tupana ãẽ̱xgacü íixĩxü̃wa tá tangugü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Rü yexguma ga Ngechuchu rü norü ngúexü̃gümaã nüxü̃ nixu, rü ñanagürü: —¡Taxúemaãtáma nüxü̃ pixu na choma rü Cristu chiĩxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Rü yemawena inanaxügü ga norü ngúexü̃gümaã nüxü̃ na yaxuxü̃ ga ṯacü tá nüxü̃ na üpetüxü̃. Rü ñanagürü: —Choma rü Yerucharéü̃wa tá chaxũ, rü nge̱ma poraãcü ngúxü̃ tá choxü̃ ningexẽẽgü. Rü choxü̃ tá nimèxgü i Yudíugüarü ãẽ̱gacügüerugü rü paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü i ore i mugüwa ngu̱xẽẽtaegüxü̃. Natürü tomaẽ̱xpü̱x i ngunexü̃ ngupetügu rü wena táxarü chamaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Rü yexguma ga Pedru rü nüxĩca noxrüwama Ngechuchuxü̃ naga, rü inanaxügü ga na naxucu̱xẽãxü̃, rü ñanagürü: —Pa Corix, Tupana rü tama nanaxwèxe na ngẽmaãcü quidexaxü̃. Rü tãũtáma ngẽmaãcü cuxü̃ nangupetü i cumax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Natürü ga Ngechuchu rü Pedrucèx nadaueguãchi, rü ñanagürü nüxü̃: —¡Choxna ixũgachi, Pa Chatanáx, erü chixexü̃gu choxü̃ cunguxẽẽchaü̃! Rü tama Tupana nagu rüxĩnüxü̃gu curüxĩnü, rü yatügü nagu rüxĩnüxü̃gumare curüxĩnü i cumax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Rü yexguma ga Ngechuchu rü norü ngúexü̃güxü̃ ñanagürü: —Rü ngẽxguma texé chowe rüxũxchaü̃gu, ¡ẽcü nüxü̃ tarüxo i tümaãrü ngúchaü̃, rü namaã tapora i ngẽma guxchaxü̃gü i tümacèx ínguxü̃ i ñoma curuchawa tipotaxü̃rüü̃ tüxü̃ ixĩxẽẽxü̃, rü ngẽmae̱tüwa chowe tarüxũãma! ");
INSERT INTO tcaNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Erü yíxema tügü maxẽchaxẽẽchaü̃xẽ rü tá tayu. Natürü yíxema chauxcèx yúxe rü aixcüma tá tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Rü ¿Ṯacüwa i nüxü̃́ namexü̃ ya wüxi ya yatü ega nayauã̱xgu i guxü̃ma i ñoma i naãneãrü ngẽmaxü̃gü, natürü iyanatauxẽẽãgu i norü maxü̃? Erü taxucürüwama wüxi ya yatü rü norü dĩẽrumaã naxcèx nataxe i norü maxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Erü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃ rü wena táxarü núma chaxũ. Rü ngẽxguma rü Chaunatü ya Tupanarüü̃ tá ãẽ̱xgacü chixĩ, rü daxũcü̱̃ã̱x i orearü ngeruü̃gümaã tá íchangu. Rü ngẽxguma tá nixĩ i nüxü̃́ chanaxütanüxü̃ i wüxichigü i duü̃xü̃gü i ngẽma ñuxãcü chauxcèx na namaxẽxü̃rüü̃ãcüma maxẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Rü aixcüma pemaã nüxü̃ chixu rü nangẽxma i ñuxre i duü̃xü̃gü i núma ngẽxmagüxü̃ rü tãũtáma nayu ñu̱xmatáta choxü̃ nadaugü na yuwa ícharüdaxü̃ rü aixcüma ãẽ̱xgacü ya poracü na chiĩxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Rü 6 ga ngunexü̃guwena rü Ngechuchu ínayagagü ga Pedru rü Chaü̃tiágu rü Cuáü̃ ga Chaü̃tiágueneẽ. Rü nüxĩcatama wüxi ga mèxpǘnewa noxrüwama namaã naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Rü yéma yema ngúexü̃güpẽ́xewa rü toraxü̃ãcü nango̱x ga Ngechuchu. Rü üèxcürüü̃ nixĩ ga nachiwe ga na yay̱auracüüxü̃. Rü naxchiru rü ta üèxcüemarüü̃ nixĩ ga na nangóonexẽẽãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Rü ngürüãchi yéma naxcèx nango̱xgü ga Moĩché rü Ería. Rü Ngechuchumaã yéma nidexagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Rü yexguma ga Pedru rü ñanagürü Ngechuchuxü̃: —Pa Corix, name nixĩ nuã tangẽxmagü. Rü ngẽxguma cunaxwèxegu rü tá tanaxü ya tomaẽ̱xpü̱x ya düxenü, rü wüxi ya cuxcèx, rü náĩ ya Moĩchécèx, rü náĩ ya Eríacèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Rü yexguma íyadexayane ga Pedru rü wüxi ga caixanexü̃ ga nangóonexẽẽxü̃ rü natanügu nayangaixema. Rü yema caixanexü̃wa inanaxũ ga wüxi ga naga ga ñaxü̃: —Daa nixĩ ya Chaune ya nüxü̃ changechaü̃xü̃chicü rü namaã chataãẽxü̃chicü. ¡Rü naga pexĩnüẽ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Rü yexguma yemaxü̃ naxĩnüẽgu ga yema ngúexü̃gü, rü ñaxtüanegu nanangücuchiãchitanü, yerü poraãcü namuü̃ẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Natürü ga Ngechuchu rü naxcèx nixũ, rü nüxü̃ nayarüngõgü, rü ñanagürü nüxü̃: —¡Ipechigü rü tãxṹ ipemuü̃ẽxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Rü yexguma wenaxãrü nadaunagütanügu, rü Ngechuchuxü̃xĩcatama nadaugü rü taxúema ga toguexü̃ nadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Rü yexguma ínaxĩgügu ga guma mèxpǘnewa, rü Ngechuchu nayaxucu̱xẽgü ga taxúemaãma na nüxü̃ yaxugüexü̃cèx ga yema yéma nüxü̃ nadaugüxü̃, ñu̱xmatáta yuwa ínadaxgu rü wena namaü̃xgu. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Rü ñu̱xũchi ga yema ngúexü̃gü rü Ngechuchuna nacagü, rü ñanagürügü: —¿Tü̱xcüü̃ i ngẽma ngúexẽẽruü̃gü i ore i mugüwa ngu̱xẽẽtaegüxü̃ rü ñanagürügü: “Ería tá nixĩ ya nüxĩra cuxü̃pa nuã ũcü?” ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Aixcüma nixĩ i Ería na nüxĩra tá núma naxũxü̃ na chauxü̃pa Tupanacèx yamexẽẽãxü̃cèx i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Natürü choma pemaã nüxü̃ chixu, rü Ería rü marü núma naxũ, natürü duü̃xü̃gü rü tama nüxü̃ nacuèxgü na texe yiĩxü̃. Rü yemacèx chixri namaã nachopetü. Rü ngẽxgumarüü̃ tá ta nixĩ na chixri tá chomaã nachopetüxü̃ i duü̃xü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Rü yexguma ga yema ngúexü̃gü rü nüxü̃ nicuèxãchitanü ga Cuáü̃ ga baiü̃xẽẽruü̃chiga na yiĩxü̃ ga yema Ngechuchu namaã nüxü̃ ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Rü yexguma duü̃xü̃gü íyexmaxü̃wa nangugügu, rü wüxi ga yatü Ngechuchucèx nixũ. Rü napẽ́xegu nayacaxã́pü̱xü rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Pa Corix, ¡nüxü̃ nangechaü̃ ya chaune rü naxcèx yataanexẽẽ! Erü muẽ̱xpü̱xcüna rü naxãũãẽxü̃, rü poraãcü nüxü̃́ nangu̱x. Rü muẽ̱xpü̱xcüna rü üxüxetügu nayanguxẽẽ, rü ẽ́xna dexágu. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","—Rü nuã curü ngúexü̃güxü̃tawa chanaga, natürü nümagü rü tama nüxü̃ nacuèxgü na namexẽẽgüãxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Rü yexguma Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃ ga yema duü̃xü̃gü ga yéma yexmagüxü̃: —Pa Duü̃xü̃gü i Tama Yaxõgüxü̃ i Chixri Maxẽxü̃x, ¿ñuxguratáta i pemaã chanuxmaxü̃ rü yaxna pemaã chaxĩnüxü̃? ¡Nuã penaga ya yima bucü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Rü Ngechuchu nananga ga yema ngoxo ga guma bucüwa yexmaxü̃. Rü yemaãcü ínanatèxüchi ga yema ngoxo. Rü yexgumatama naxcèx nitaane ga guma bucü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Rü yemawena ga norü ngúexü̃gü rü noxrüwama Ngechuchumaã nidexagü. Rü nüxna nacagüe, rü ñanagürügü nüxü̃: —Pa Corix, ¿tü̱xcüü̃ i toma rü taxuacüma ítanatèxüchi i ngẽma ngoxo? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Pema rü taxuacüma ípenatèxüchi erü tama aixcüma peyaxõgü. Rü aixcüma pemaã nüxü̃ chixu, rü ngẽxguma chi woo wüxi ya motachachirerüxü̃ naxiraxü̃chigu i perü õ, rü chi daa mèxpǘnemaã nüxü̃ pixuxgu na yaxũgachixü̃cèx, rü chi pega naxĩnü. Rü taxuxü̃ chima pexü̃́ naguxcha ega aixcüma peyaxõgügu. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","—Natürü ñaãrüü̃ i ngoxo rü tama ínaxũxü̃ ega tama ixaureãcüma iyumüxẽgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Rü yexguma norü ngúexü̃gümaã Gariréaarü naãnegu yaxũxgu ga Ngechuchu, rü norü ngúexü̃gümaã nüxü̃ nixu, rü ñanagürü: —Choma ya Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü chixri tá chomaã nachopetü rü ãẽ̱xgacügüna tá choxü̃ namugü i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","—Rü tá choxü̃ nimèxgü, natürü tomaẽ̱xpü̱x i ngunexü̃guwena rü wena táxarü chamaxü̃ —ñanagürü. Rü yexguma yema orexü̃ naxĩnüẽgu ga norü ngúexü̃gü, rü poraãcü nangechaü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ngechuchu rü norü ngúexü̃gümaã Capernáũãrü ĩãnewa naxĩ. Rü yexguma yéma nangugügu rü Pedruxü̃ ínayadaugü ga yema yatügü ga tupauca ga taxü̃necèx dĩẽru ngĩxü̃ yauxgüxü̃. Rü Pedruna nacagüe rü ñanagürügü: —¿Yima curü Cori rü tama ẽ́xna ngĩxü̃ naxütanü i ngẽma dĩẽru i tupauca ya taxü̃neãrü ixĩcü? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Rü Pedru nanangãxü̃, rü ñanagürü: —Ngẽmáãcü nanaxütanü —ñanagürü. Rü yixcama ga yexguma ĩxgu naxücuxgu ga Pedru, rü Ngechuchuxira Pedrumaã nidexa, rü ñanagürü nüxü̃: —¿Ñuxũ ñacuxü̃ i cumax, Pa Pedrux, rü ngextá nixĩ i nayauxgüãxü̃ i norü dĩẽru i guxü̃ i nachiü̃ãneãrü ãẽ̱xgacügü? ¿Cuxcèx i nügütanüwatama rü ẽ́xna togü i duü̃xü̃gütanüwa? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Rü Pedru nanangãxü̃, rü ñanagürü: —Maneca togü i duü̃xü̃gütanüwa nixĩ i nayauxgüãxü̃ —ñanagürü. Rü ñu̱xũchi Ngechuchu nanangãxü̃ rü ñanagürü: —Rü ngẽxguma ngẽmaãcü yixĩgu, rü yixema na Tupanaãrü ixĩgüxü̃ rü taxucèxma tanaxütanügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","—Natürü ngẽma na taxúema tamaã nuxü̃cèx, rü chanaxwèxe i cuyaxütanü i ngẽma dĩẽru. ¡Rü yéa naxtaawa naxũ, rü nge̱ma yapoxwaxe! ¡Rü ngẽma nüxĩraü̃xü̃ i choxni i cunapoxwaü̃xü̃ rü naã̱xwa tá nüxü̃ icuyangau i wüxi i dĩẽru i nagu mexü̃ na yangutanüxẽẽxü̃cèx i chauxcèx rü cuxcèx rü ta! ¡Rü tupauca ya taxü̃newa nange i ngẽma dĩẽru, rü yaxütanü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Rü yexguma ga norü ngúexü̃gü rü Ngechuchucèx naxĩ rü nüxna nacagü, rü ñanagürügü: —¿Pa Corix, texé tá tixĩ ya guxü̃ãrü yexera ixĩxẽ i ngẽma Tupana ãẽ̱xgacü íixĩxü̃wa? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Rü yexguma ga Ngechuchu rü wüxi ga buxü̃cèx naca, rü norü ngúexü̃güarü ngãxü̃tanügu nanachixẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Rü ñu̱xũchi ñanagürü nüxü̃: —Dücèx, Pa Chorü Ngúexü̃güx, aixcüma pemaã nüxü̃ chixu, rü ngẽxguma tama nüxü̃ perüxoegu i ngẽma na togüarü yexera pegü pixĩgüxẽẽchaü̃xü̃ rü ñu̱xũchi tama ñaã buxü̃rüü̃ pegü íperüxíragu, rü taxucürüwa pichocu i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","—Rü aixcüma yíxema tügü írüxíraxe rü ñaã buxü̃rüü̃ ixĩxẽ, rü yíxema tá tixĩ ya guxü̃ãrü yexera ixĩxẽ i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","—Rü texé ya chauégagu meã nayaxúxe i wüxi i buxü̃ i ñaãrüü̃ ixĩxü̃ rü choxü̃ nixĩ i tayaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","—Rü texé ya pecadugu nanguxẽe̱xẽ i wüxi i ñaã buxü̃gü i choxü̃́ yaxõgüxü̃ rü tümacèx rü narümemaẽ chi nixĩ na noxtacüma wüxi ya nuta tümanaãwa nayangacuchixü̃, rü ñu̱xũchi ngẽmaãcü taxtüchiüwa tüxü̃ nayarütáexü̃ na ngẽxma tayuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","—Ñoma i naãnecü̱̃ã̱x i duü̃xü̃gücèx rü wüxi i taxü̃ i ngechaü̃ nixĩ na nangẽxmaxü̃ i muxũchixü̃ i ṯacü i pecadugu nayixẽẽxü̃. Rü guxü̃guma tá nangẽxma i ngẽma chixexü̃gü, natürü wüxi i ngechaü̃xü̃chi tá nixĩ naxcèx i ngẽma yatü i togüxü̃ pecadugu nguxẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","—Rü ngẽmacèx i ngẽxguma chi cuxmẽ́x rü ẽ́xna cucutü pecadugu cuxü̃ nguxẽẽgu, rü name nixĩ i noxtacüma ícunadae rü yaxü̃gu cuyaña. Erü narümemaẽ nixĩ i cuboxmẽ́xãcüma rü ẽ́xna cubocutüãcüma na cunayaxuxü̃ i curü maxü̃ na tama guxü̃ne ya cuxmẽ́xmaã rü ẽ́xna guxü̃ne ya cucutümaã üxü ya taguma ixoxü̃newa quitèxcuchixü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","—Rü ngẽxguma chi cuxetü pecadugu cuxü̃ nguxẽẽgu, rü name nixĩ i ícunacaxüchi, rü yaxü̃gu cunaña. Erü narümemaẽ nixĩ i wüxixetümaã na cunayaxuxü̃ i curü maxü̃ na tama guxü̃ne ya cuxetümaã üxü ya ngoxogü nagu poxcuenewa na quitèxcuchixü̃cèx. Rü ngẽmaãcü woo cuxü̃́ naguxchagu, natürü name nixĩ i nüxna quixũgachi i guxü̃ma i ngẽma chixexü̃gü i nagu cunguchaü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","—Rü tama name i nüxü̃ pexoo̱x i wüxi i buxü̃ i ñaãrüü̃ choxü̃́ yaxõxü̃. Erü ngẽma norü dauruü̃gü i orearü ngeruü̃gü i daxũcü̱̃ã̱x rü guxü̃guma Chaunatü ya daxũgucüpẽ́xewa nangẽxmagü na nge̱ma ngẽma buxü̃e̱tüwa nachogüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","—Rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃ rü núma chaxũ na chanamaxẽxẽẽxü̃cèx i duü̃xü̃gü iyarütauxexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","—¿Rü ñuxũ ñapegüxü̃ i pema ega wüxi ya yatü rü nüxü̃́ nangẽxmagu i 100 i carnerugü rü wüxi nüxü̃́ iyarütau̱xgu? ¿Taux ẽ́xna i nachitaü̃gu namugüãxü̃ i ngẽma 99, rü ñu̱xũchi naxcèx yadauxü̃ i ngẽma nüxü̃́ iyarütaxuxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","—Rü ngẽxguma nüxü̃ iyangauxgu, rü namaã nataãẽxü̃chi i ngẽma norü carneru. Rü woo guxü̃guma namaã nataãẽ i ngẽma 99 i tama iyarütauxexü̃, natürü yexeraãcüxüchi namaã nataãẽ i ngẽma wüxi i iyarütaxuxü̃, erü marü nüxü̃ inayangau. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","—Rü ngẽxgumarüü̃ ta nixĩ ya Penatü ya daxũgucü na tama nanaxwèxexü̃ na wüxi i ñaã buxü̃ na iyarütaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","—Rü ngẽxguma cueneẽ chixexü̃ cumaã ü̱xgu, rü name nixĩ i nüxĩcatama namaã quidexa, rü nüxna nüxü̃ cucuèxãchixẽẽ i ngẽma norü chixexü̃ i cumaã naxüxü̃. Rü ngẽxguma cuga naxĩnügu, rü marü wenaxarü mexü̃cèx cunataeguxẽẽ i ngẽma cueneẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","—Natürü ngẽxguma tama cuga naxĩnügu i ngẽma cueneẽ, rü name nixĩ i naxcèx cuca i wüxi rü ẽ́xna taxre i duü̃xü̃gü na nümagü rü ta namaã yadexagüxü̃cèx i ngẽma cueneẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","—Rü ngẽxguma rü ta tama nüxü̃́ inaxĩnügu i ngẽma taxre i duü̃xü̃güarü ore, rü name nixĩ i guxü̃ i yaxõgüxü̃maã nüxü̃ quixu na ngẽma cueneẽmaã yadexagüxü̃cèx. Rü ngẽxguma rü ta tama nüxü̃́ inaxĩnügu i ngẽma yaxõgüxü̃ãrü ore, rü name nixĩ i wüxi i duü̃xü̃ i tama yaxõxü̃rüü̃gu namaã curüxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","—Rü aixcüma pemaã nüxü̃ chixu rü yíxema núma ñoma i naãnewa tama pexü̃́ irüxĩnüxẽ i chorü ore rü tãũtáma Tupana ãẽ̱xgacü íixĩxü̃wa tichocu. Natürü yíxema meã pexü̃́ irüxĩnüxẽ i ngẽma ore rü aixcüma nge̱ma tá tangu. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","—Rü pemaã nüxü̃ chixu rü ngẽxguma chi taxre i pema i núma ñoma i naãnewa rü wüxigu ṯacücèx ípecaxgu i Chaunatü ya daxũgucüxü̃tawa, rü nüma ya Chaunatü rü tá pexna nanaxã. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","—Erü ngẽma ngextá taxre rü ẽ́xna tomaẽ̱xpü̱x i duü̃xü̃gü chauégagu íngutaquẽ́xexü̃wa, rü choma rü ta norü ngãxü̃tanüwa changẽxma —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Rü yexguma ga Pedru rü Ngechuchucèx nixũ, rü nüxna naca, rü ñanagürü: —¿Pa Corix, ngẽxguma chaueneẽ chixexü̃ chomaã ü̱xgu, rü ñuxreẽ́xpü̱xcüna i namexü̃ na nüxü̃́ nüxü̃ changechaü̃xü̃ naxcèx i ngẽma chixexü̃ i chomaã naxüxü̃? ¿Rü marü namexü̃ i cuxcèx ega 7 ẽ́xpü̱xcüna yixĩgu na nüxü̃́ nüxü̃ changechaü̃xü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Tama name i 7 ẽ́xpü̱xcünaxĩcatama nüxü̃́ nüxü̃ cungechaü̃. Natürü guxü̃gutáma nixĩ i nüxü̃́ nüxü̃ na cungechaü̃xü̃ woo 70 ẽ́xpü̱xcüna i 7 wa nangu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Rü Ngechuchu rü ñanagürü: —Rü ngẽma Tupana na ãẽ̱xgacü ixĩxü̃, rü ñoma wüxi ga nachiü̃ãneãrü ãẽ̱xgacü ga norü duü̃xü̃gü ga nüxü̃́ nangetanügüxü̃maã namexẽẽchaü̃xü̃rüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","—Rü yexguma inaxügüãgu ga meã nüxü̃ na yadaugüxü̃ ga yema nüxü̃́ nangetanügüxü̃pane, rü naxü̃tawa nanagagü ga wüxi ga norü duü̃xü̃ ga taxüchicü ga dĩẽru nüxü̃́ ngĩxü̃ ngetanüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","—Natürü ga yema norü duü̃xü̃ rü nangearü dĩẽruã̱x, rü taxuacüma norü cori ga ãẽ̱xgacüaxü̃́ nanaxütanüe̱ga. Rü yemacèx ga yema ãẽ̱xgacü rü norü churaragüxü̃ namu na to ga corixü̃ namaã nataxegüxü̃cèx ga yema yatü, wüxigu tümamaã ga naxmèx rü naxãcügü rü norü yemaxü̃gü, na yema natanü ga dĩẽrumaã naxütanüãxü̃cèx ga norü ngetanü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","—Rü yexguma ga yema norü duü̃xü̃ rü norü ãẽ̱xgacüpẽ́xegu nacaxã́pü̱xü, rü nüxü̃ nacèèxü̃, rü ñanagürü: “Pa Corix ¡choxü̃ nangechaü̃! Rü marü tá chapuracü, rü tá cuxü̃́ chanaxütanü i guxü̃ma”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","—Rü yema norü ãẽ̱xgacüaxü̃́ nangechaü̃tümüü̃, rü yemacèx namaã nüxü̃ nixu ga marü tama nüxü̃́ na naxütanüãxü̃cèx ga yema norü ngetanü. Rü ñu̱xũchi ínananguxuchixẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","—Natürü yexgumatama yéma ãẽ̱xgacüxü̃tawa ínaxũũxgu ga yema yatü, rü nüxü̃ inayangau ga wüxi ga namücü ga írarüwatama nüxü̃́ nangetanüxü̃. Rü yema yatü rü nüxna natüxüe, rü nananu̱xnaxã, rü ñanagürü nüxü̃: “¡Choxü̃́ ngĩxü̃ naxütanü i ngẽma dĩẽru i ngĩxü̃ cungetanücü!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","—Rü yexguma ga yema namücü rü yema yatüpẽ́xegu nacaxã́pü̱xü, rü nüxü̃ nacèèxü̃, rü ñanagürü: “Pa Chomücüx, ¡choxü̃ nangechaü̃! Rü marü tá chapuracü, rü tá cuxü̃́ chanaxütanü i guxü̃ma”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","—Natürü ga yema yatü rü tama nüxü̃ nacuáxchaü̃ ga yema ore. Rü poxcupataü̃gu tüxü̃ napoxcuama ñu̱xmata nüxü̃́ tanaxütanü ga yema tümaãrü ngetanü. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","—Rü yexguma togü ga yema ãẽ̱xgacüarü duü̃xü̃gü nüxü̃ daugügu ga yema ngupetüxü̃, rü poraãcü naãẽwa nangu̱x ga yema naxüxü̃ ga yema yatü. Rü norü corixü̃tawa naxĩ rü nüxü̃ nayarüxugüe ga guxü̃ma ga yema ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","—Rü yexguma ga yema ãẽ̱xgacü rü nanamu ga norü churaragü na naxü̃tawa nagagüãxü̃cèx ga yema yatü. Rü yexguma naxü̃tawa nanguxgu, rü ñanagürü nüxü̃: “Wüxi i chixexü̃ i chorü duü̃xü̃ quixĩ. Choma rü cuxü̃́ nüxü̃ changechaü̃ ga yema choxü̃́ cungetanüxü̃, erü choxü̃ cucèèxü̃ na tama cuxü̃ chapoxcuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","—Rü cuma rü chita nüxü̃́ nüxü̃ cungechaü̃ i ngẽma cumücü i cuxü̃́ nangetanüxü̃, yexgumarüü̃ ga choma rü cuxü̃́ nüxü̃ na changechaü̃xü̃rüü̃ ga yema choxü̃́ cungetanüxü̃”, ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","—Rü poraãcü nanuxũchi ga yema ãẽ̱xgacü. Rü norü churaragüxü̃ namu na napoxcugüãxü̃cèx ga yema yatü ñu̱xmata guxü̃ nüxü̃́ naxütanü ga yema nüxü̃́ nangetanüxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Rü ñu̱xũchi ñanagürü ta: —Rü ngẽxgumarüü̃ tá pemaã nanaxü ya Chaunatü ya daxũgucü i ngẽxguma tama wüxichigü aixcüma peenexẽgüaxü̃́ nüxü̃ perüngümaegu i ngema chixexü̃ i pemaã naxüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Rü yema ñaxguwena ga Ngechuchu rü inaxũãchi ga Gariréaarü naãnewa. Rü natü ga Yudáü̃ãrü tocutüwa naxũ ga Yudéaarü naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Rü muxü̃ma ga duü̃xü̃gü nawe narüxĩ, rü nüma ga Ngechuchu rü yéma nanameẽxẽẽ ga yema iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Rü Ngechuchucèx naxĩ ga ñuxre ga Parichéugü, rü nüxna nacagü rü ñanagürügü: —¿Cuxcèx namexü̃ i wüxi i yatü na ínatáxmèxmarexü̃ ega ṯacü rü chixexü̃ taxü̱xgu ya naxmèx? —ñanagürügü. Rü yemaãcü nüxna nacagü yerü Ngechuchuxü̃ chixexü̃gu nanguxẽẽgüchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —¿Taguma ẽ́xna nawa pengúe i ngẽma Tupanaãrü ore i ümatüxü̃ i nüxü̃ ixuxü̃ ga noxri Tupana naxü̱xgu ga duü̃xü̃gü, rü yatüxü̃ rü ngecüxü̃ na naxüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","—Rü ñanagürü ga Tupana: “Rü ngẽmacèx ya yatü rü tá nanatü rü naẽna nixũgachi na namèxmaã inaxã́ũxü̃cèx. Rü ngẽmaãcü i ngẽma taxre rü ñoma wüxitama i duü̃xü̃rüü̃ tá nixĩgü”. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","—Rü ñu̱xũchi tama taxre nixĩ, rü wüxitama nixĩ. Rü ngẽmacèx taxucürüwa texé nügüna tayaxĩgachitanüxẽẽ i ngẽma taxre i Tupana nügüna mugüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Rü yexguma Ngechuchuna nacagü rü ñanagürügü: —¿Tü̱xcüü̃ nixĩ ga Moĩché ga duü̃xü̃gümaã nüxü̃ yaxuxü̃ rü ngẽxguma texé tümamèxü̃ ítáxchaü̃gu rü name nixĩ i wüxi i popera i tèxgüpane ngĩxna taxã, rü ñu̱xũchi ngĩxü̃ ítatèx? ñaxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Pegagu nixĩ ga Moĩché ga tama pexna nachúxãxü̃ na pexmèxü̃ ípetáxü̃. Yerü nüma nüxü̃ nacuèx na tama aixcüma peyaxõgüxü̃. Natürü noxriarü ügügu rü tama yemaãcü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","—Rü choma pemaã nüxü̃ chixu rü tama name na texé tümamèxü̃ ítáxü̃ ega tama naĩ ya yatümaã nangẽãẽxü̃gagu yixĩgu. Rü ngẽxguma chi yima yatü rü ñu̱xũchi naĩ i ngemaã naxãxmèxgu, rü chixexü̃ naxü, rü ñoma naĩ i ngemaãmare nangẽãẽxü̃rüü̃ nixĩ. Rü texé ya ngĩmaã ãmaxẽ i ngẽma nge i ngĩte ngĩxü̃ ítèxcü, rü ñoma naĩ i ngemaãmare itapexü̃rüü̃ tixĩ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Rü ñu̱xũchi ga norü ngúexü̃gü rü ñanagürügü nüxü̃: —Ega ngẽmaãcü yixĩgu rü name nixĩ i noxtacüma tama naxãmèx ya yatü rü tama ixãte i nge —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Rü Ngechuchu norü ngúexü̃güxü̃ nangãxü̃ rü ñanagürü: —Taxucürüwa guxü̃ma i duü̃xü̃gü nüxü̃ nacuèx i ṯacüchiga na yiĩxü̃ i ngẽma ngu̱xẽẽtae. Natürü yíxema Tupana tüxü̃ nüxü̃ cuèxẽe̱xẽxĩcatama tixĩ ya nüxü̃ cuèxgüxe. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","—Rü nangẽxma i nagúxü̃raü̃xü̃ i guxchaxü̃ na tama naxãmèxü̃cèx ya yatü. Erü nümaxü̃ i yatü rü woetama taxucürüwa naxãmèx erü norü bucüma nangepü̱xüchare. Rü nümaxü̃ i yatü rü taxucürüwa naxãmèx erü nayauxpü̱xücharee. Rü togü tama naxãmèx erü Tupanaãrü ngúchaü̃xĩcatama naxügüchaü̃. Rü texé ya ngẽmaãcü maxchaü̃xẽ rü marü name i ngẽmaãcü tamaxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Rü duü̃xü̃gü rü Ngechuchuxü̃tawa nanagagü ga ñuxre ga buxü̃gü na Ngechuchu nüxü̃ ingõgüxü̃cèx rü namaã nayumüxẽxü̃cèx. Natürü ga Ngechuchuarü ngúexü̃gü rü inanaxügüe ga na yangagüãxü̃ ga yema duü̃xü̃gü ga Ngechuchuxü̃tawa buxü̃güxü̃ gagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Natürü ga Ngechuchu rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Marü name i chauxü̃tawa naxĩ i buxü̃gü. ¡Rü tãxṹ i nüxna penachu̱xuxü̃! Erü Tupana ãẽ̱xgacü íixĩxü̃wa rü tümacèx nixĩ ya yíxema ñaã buxü̃gürüü̃ meã yaxõgüxe —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Rü ñu̱xũchi ga Ngechuchu rü yema buxü̃güétü naxümẽ́x. Rü yemawena inaxũãchi ga yéma. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Rü wüxi ga ngextü̱xücü rü Ngechuchuxü̃tawa nangu, rü nüxna naca, rü ñanagürü: —Pa Ngúexẽẽruü̃ ya Mecüx, ¿ṯacü tá chaxüxü̃ na chanayaxuxü̃cèx i maxü̃ i taguma gúxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ “Mecü” ñacurügü choxü̃? Erü Tupanaxĩcatama nixĩ ya mecü ixĩcü, rü nataxuma i to. Natürü ngẽxguma cunayauxchaü̃gu i maxü̃ i taguma gúxü̃, rü ¡naga naxĩnü i Tupanaãrü mugü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Rü yexguma ga guma ngextü̱xücü rü ñanagürü: —¿Ngẽxü̃rüüxü̃ tá nixĩ i Tupanaãrü mugü i naga chaxĩnüxü̃? —ñanagürü. Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —¡Tãũtáma cumáẽta, rü tãũtáma naĩ i ngemaã icupe, rü tãũtáma cungĩ́tèèx, rü tãũtáma doraxü̃ quixu i togüchiga! ");
INSERT INTO tcaNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","—¡Rü tümaga naxĩnü ya cunatü rü cue, rü nüxü̃ nangechaü̃ i cumücügü ngẽma na cugü cungechaü̃xü̃rüü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Rü yexguma ga guma ngextü̱xücü rü ñanagürü: —Guxü̃ma i ngẽma mugü i nüxü̃ quixuxü̃ rü woetama chorü bucüma meã chayanguxẽẽ. ¿Rü ṯacü rü to tá chaxü na choxü̃́ nangẽxmaxü̃cèx i maxü̃ i taguma gúxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Ega aixcüma Tupanapẽ́xewa mecü quixĩxchaü̃gu, rü name nixĩ i namaã cutaxe i guxü̃ma i curü ngẽmaxü̃gü rü togü i ngearü ngẽmaxü̃ã̱xgüxü̃na cunaxã i ngẽma curü natanü. Rü ngẽxguma tá cuxü̃́ nangẽxma i cuchica i daxũguxü̃ i naãnewa. Rü ñu̱xũchi marü name i chowe curüxũ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Natürü yexguma yemaxü̃ naxĩnügu ga guma ngextü̱xücü rü poraãcü nangechaü̃, yerü namuãrü dĩẽruã̱xü̃chi. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Rü yexguma ga Ngechuchu rü norü ngúexü̃güxü̃ ñanagürü: —Aixcüma pemaã nüxü̃ chixu rü naguxchaxüchi nixĩ na wüxi i duü̃xü̃ i dĩẽruã̱xü̃chixü̃ rü Tupana ãẽ̱xgacü íixĩxü̃wa na nanguxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","—Rü aixcüma pemaã nüxü̃ chixu rü ñoma wüxi i cameyu na taxucürüwama wüxi ya ucumaxẽtüwa naxüpetüxü̃ãrü yexera narüguxchamaẽ naxcèx i wüxi i duü̃xü̃ i dĩẽruã̱xü̃chixü̃ na yaxücuxü̃ i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Rü yexguma yemaxü̃ naxĩnüẽgu ga norü ngúexü̃gü rü poraãcü nabèi̱xãchiãẽgü. Rü nügüna nacagüe rü ñanagürügü: —¿Rü texé tá ẽ́xna tixĩ ya nayaxúxe i maxü̃ i taguma gúxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Rü Ngechuchu nüxü̃ nadawenü rü ñanagürü nüxü̃: —Duü̃xü̃gü rü taxuacüma nügü namaxẽẽ, natürü Tupanaãxü̃́ rü natauxcha na namaxẽxẽẽãxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Rü yexguma ga Pedru rü ñanagürü nüxü̃: —Pa Corix, toma rü marü ítanawogü ga guxü̃ma ga torü yemaxü̃gü na cuwe tarüxĩxü̃cèx. ¿Rü ṯacü tá nixĩ i torü natanü i ñu̱xmax? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü ngẽma ngunexü̃ i Tupana nagu nangexwacaxü̃xẽẽxü̃ i guxü̃ma, rü choma rü ãẽ̱xgacü ya tacü tá chixĩ. Rü chorü tochica i mexẽchixü̃wa tá charüto. Rü pema i 12 i chorü ngúexü̃gü na chowe perüxĩxü̃ rü pema rü tá ta pexü̃́ nangẽxma i perü tochicaxü̃ i mexẽchixü̃ i chauxü̃tawa. Rü nge̱ma tá perütogü na norü maxü̃chigacèx nüxü̃ picagüxü̃ i guxü̃ma i Yudíugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Rü guxãma ya yíxema tümapata chauxcèx ítáxe, rü ẽ́xna tümaẽneẽgü rü tümaẽyèxgüxü̃ chauxcèx ítáxe, rü ẽ́xna tümanatü rü tümaẽxü̃ chauxcèx ítáxe, rü ẽ́xna tümamèx rü tümaxãcügüxü̃ rü tümaãrü naãne chauxcèx ítáxe, rü 100 ẽ́xpü̱xcüna i ngẽma noxri tüxü̃́ ngẽxmaxü̃ãrü yexera tá tayaxu. Rü nae̱tü tá tanayaxu i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","—Natürü muxü̃ma i nümaxü̃ i ñoma i naãnewa duü̃xü̃gü wixpẽ́xewa ügüxẽẽxü̃, rü daxũguxü̃ i naãnewa rü Tupana tá wixweama nanaxügüxẽẽ. Rü muxü̃ma i nümaxü̃ i ñoma i naãnewa duü̃xü̃gü wixweama ügüxẽẽxü̃, rü daxũguxü̃ i naãnewa rü Tupana tá wixpẽ́xewa nanaxügüxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Rü ngẽma Tupana ãẽ̱xgacü íixĩxü̃wa rü ñoma wüxi ga ubanecüarü yora ga pèxmama norü puracütanüxü̃ ta yadaucürüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Rü yema puracütanüxü̃maã nanamexẽẽ na wüxitachinü ga dĩẽrugu nüxü̃́ na naxütanüãxü̃cèx ga wüxichigü ga ngunexü̃gu. Rü ñu̱xũchi naãnewa nanamugü na yéma yapuracüexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","—Rü yixcama ga 9 arü oragu rü ínayadau ga ngextá yatügü ga puracücèx daugüxü̃ íngutaquẽ́xegüxü̃xü̃wa. Rü yexma nüxü̃ nayangau ga ñuxre ga yatügü ga ngearü puracüã̱xgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","—Rü ñanagürü nüxü̃: “¡Nge̱ma chorü ubanecüwa peyapuracüe! Rü meã tá pexü̃́ chanaxütanü”, ñanagürü. Rü nümagü rü yéma naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","—Rü yema ubanecüarü yora rü tocuchigu rü wenaxãrü togü ga puracütanüxü̃ ta nayadau. Rü tomaẽ̱xpü̱xarü oragu ga yáuanecü rü wenaxãrü yexgumarüü̃ ta nayadau. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","—Rü yixcama ga wüximẽ́ẽ̱xpü̱xarü oragu ga yáuanecü rü wenaxãrü ínayadau ga ngextá yatügü ga puracücèx daugüxü̃ íngutaquẽ́xegüxü̃xü̃wa. Rü yexma nüxü̃ nayangau ga ñuxre ga togü ga yatügü ga ngearü puracüã̱xgüxü̃. Rü ñanagürü nüxü̃: “¿Tü̱xcüü̃ i pema rü nuxã perüchomare i guxü̃ i ñoma i ngunexü̃gu, rü tama pepuracüe?” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","—Rü nümagü nanangãxü̃gü, rü ñanagürügü nüxü̃: “Tama tapuracüe erü taxúema toxcèx tadau na tüxü̃́ tapuracüexü̃cèx”, ñanagürügü. Rü yexguma ga yema naãneãrü yora rü ñanagürü nüxü̃: “¡Pema rü ta nge̱ma chorü ubanecüwa pexĩ rü peyapuracüe! Rü meã tá pexü̃́ chanaxütanü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","—Rü yexguma marü nachütagu rü yema naãneãrü yora, rü naxcèx naca ga norü puracütanüxü̃ãrü dauruü̃, rü ñanagürü nüxü̃: “¡Naxcèx naca i ngẽma puracütanüxü̃. Rü nüxĩra nüxü̃́ naxütanü i ngẽma wixwenaxü̃chima nge̱ma ĩxü̃, rü nawa tá icuyacuèxẽẽ i ngẽma nüxĩra nge̱ma puracüexü̃!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","—Rü yéma naxĩ ga yema puracütanüxü̃ ga wüximẽ́ẽ̱xpü̱xarü oragu ga yáuanecü puracüwa ĩxü̃. Rü wüxichigü ngĩxü̃ nayauxgü ga wüxitachinü ga dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","—Rü yemawena rü yéma naxĩ ga yema nüxĩrama puracüexü̃ ga puracütanüxü̃. Rü nümagü nagu naxĩnüẽgu rü yexera tá ngĩxü̃ nayauxgü ga dĩẽru, natürü nümagü rü ta ngĩxü̃ nayauxgü ga wüxitachinütama ga dĩẽru ga wüxichigü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","—Rü yexguma ngĩxü̃ nayauxgügu rü inanaxügüe ga chixri na yadexagüxü̃ nachigagu ga yema naãneãrü yora. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","—Rü ñanagürügü: “Yixema rü guxü̃ i ngunexü̃gu üèxcüxetüwa tapuracüe, natürü i ñaã puracütanüxü̃ i wixwenaxü̃chi íngugüxü̃ rü wüxi i oratama napuracüe. Natürü ngẽma tüxü̃́ naxütanüãxü̃́ẽ̱xpü̱xtama nüxü̃́ nanaxütanü”, ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","—Natürü ga yema ubanecüarü yora nanangãxü̃, rü ñanagürü nüxü̃ ga wüxi ga yema puracütanüxü̃: “Pa Chomücüx, tama cuxü̃́ changĩ̱x. ¿Tama ẽ́xna i wüxitachinügu yiĩxü̃ ga chomaã cunamexẽẽxü̃ na cuxü̃́ chanaxütanüxü̃ i ngẽma puracü? ");
INSERT INTO tcaNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","—¡Ñaã i curü dĩẽru, rü íixũ! Rü ngẽma puracütanüxü̃ i wüxi i oratama puracüexü̃, rü choma nüxna ngĩxü̃ chaxãxchaü̃ i ngẽma cuxna ngĩxü̃ chaxãcüẽ́xpü̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","—¿Tama ẽ́xna name i ngẽma choma chanaxwèxexü̃ãcüma ngĩmaã na chaxüxü̃ i chorü dĩẽru? ¿Rü ẽ́xna quixãũxãchi erü ngẽmaãcü chamecüma?” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","—Rü yíxema ñu̱xma duü̃xü̃gü wixweama tüxü̃ ügüxẽe̱xẽ, rü daxũguxü̃ i naãnewa rü Tupana tá wixpẽ́xewa tüxü̃ naxügüxẽẽ. Rü yíxema ñu̱xma duü̃xü̃gü wixpẽ́xewa tüxü̃ ügüxẽe̱xẽ rü daxũguxü̃ i naãnewa rü Tupana tá wixweama tüxü̃ naxügüxẽẽ. Erü Tupana rü muxũchiena naxu, natürü noxretama tixĩ ya yíxema tüxü̃ nadexe —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Rü yexguma namagu yaxũxgu ga Ngechuchu ga Yerucharéü̃wa na naxũxü̃ rü noxrüwama naxcèx naca ga yema 12 ga norü ngúexü̃gü, rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Pema nüxü̃ pecuèx na marü ingaicaxü̃ na Yerucharéü̃wa ingugüxü̃. Rü nge̱ma rü duü̃xü̃gü rü tá chixri chomaã nachopetü. Rü tá paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü i ore i mugüwa ngu̱xẽẽtaegüxü̃na tá choxü̃ namugü. Rü nümagü rü tá chomaã nanaxuegugü na chayuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","—Rü tá to i nachiü̃ãnecü̱̃ã̱xna choxü̃ namugü. Rü ngẽmagü tá nixĩ i chaugu idauxcüraü̃güxü̃ rü choxü̃ c̱uaixgüxü̃. rü ñu̱xũchi tá curuchawa choxü̃ nipotagü na ngẽxma chayuxü̃cèx. Natürü tomaẽ̱xpü̱x i ngunexü̃guwena rü tá wenaxãrü chamaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Rü yéma iyexma ga naẽ ga Chaü̃tiágu rü Cuáü̃. Rü yema taxre rü Zebedéu nanegü nixĩgü. Rü ngĩma rü Ngechuchucèx iyaxũ namaã ga yema taxre ga ngĩnegü. Rü Ngechuchupẽ́xegu iyacaxã́pü̱xü, rü wüxi ga ngü̃xẽẽcèx nüxna iyaca. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Rü nüma ngĩxna naca, rü ñanagürü: —¿Ṯacü nixĩ i cunaxwèxexü̃? —ñanagürü. Rü ngĩma inangãxü̃ rü ngĩgürügü: —Pa Corix, ngẽxguma ãẽ̱xgacüxü̃ quingucuchigu rü chanaxwèxe i cunamu na wüxi i ñaã chaune rü curü tügünecüwawa na natoxü̃, rü ngẽma to i curü ṯoxwecüwawa na natoxü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Natürü Ngechuchu ngĩxü̃ nangãxü̃ rü ñanagürü: —Pema rü tama nüxü̃ pecuèx na ṯacücèx ípec̱axü̃. ¿Namaxã chi peporaexü̃ i ngẽma ngúxü̃ i tá choxü̃ üpetüxü̃? —ñanagürü. Rü nümagü nanangãxü̃gü rü ñanagürügü: —Ngẽmáãcü namaã tá taporae —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Aixcüma tá nixĩ i chauxrüü̃ ngúxü̃ pingegüxü̃. Natürü ngẽma chorü tügünecüwawa rü chorü ṯoxwecüwawa na perütogüxü̃cèx, rü tama cho̱xmẽ́xwa nangẽxma na pexna chanaxãxü̃. Rü Chaunatümẽ́xẽwa nixĩ na nangẽxmaxü̃ i ngẽma, rü nüma tá tüxna nanaxã ya yíxema tümacèx íyiĩxẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Rü yexguma yemaxü̃ naxĩnüẽgu ga yema togü ga 10 ga Ngechuchuarü ngúexü̃gü, rü Chaü̃tiágumaã rü Cuáü̃maã nanuẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Natürü Ngechuchu naxcèx naca rü ñanagürü nüxü̃: —Pema nüxü̃ pecuèx rü guxü̃ i nachiü̃ãnegüarü ãẽ̱xgacügü rü poraãcü nanamu i norü duü̃xü̃gü. Rü ngẽma ãẽ̱xgacügü i taxü̃gü rü norü duü̃xü̃güarü yora nügü nixĩgüxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","—Natürü tãũtáma ngẽmaãcü nixĩ i petanüwa. Rü ngẽxguma texé naxwèxegu na ãẽ̱xgacü tiĩxü̃ i petanüwa, rü name nixĩ i noxri rü guxããrü ngü̃xẽẽruü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","—Rü ngẽxguma chi texé i petanüwa naxwèxegu na tümamücügüeru na tiĩxü̃, rü name nixĩ i noxri rü guxü̃ma i tümamücügüarü ngü̃xẽẽruü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","—Yerü chomatama i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃ rü tama togü choxü̃ rüngü̃xẽẽxü̃cèx nixĩ i núma chaxũxü̃. Natürü núma chaxũxü̃ na duü̃xü̃güxü̃ charüngü̃xẽẽxü̃cèx rü naxcèx na chayuxü̃cèx rü ngẽmaãcü chanaxütanüxü̃cèx na muxü̃ma i nümagü rü nüxü̃́ nangẽxmaxü̃cèx i maxü̃ i taguma gúxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Rü yexguma Ngechuchu norü ngúexü̃gümaã Yericúarü ĩãnewa íchoü̃xgu, rü muxü̃ma ga duü̃xü̃gü nawe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Rü yéma namacüwawa narütogü ga taxre ga ingexetüxü̃. Rü yexguma nüxü̃ naxĩnüẽgu na Ngechuchu yéma üpetüxü̃, rü tagaãcü Ngechuchuna nacagüe, rü ñanagürügü: —Pa Corix, Pa Dabítanüxü̃x, ¡Cuxü̃́ tangechaü̃tümüü̃gü! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Rü yema duü̃xü̃gü ga Ngechuchuwe rüxĩxü̃ rü nayangagü na iyanangeèxgüxü̃cèx. Natürü nümagü ga yema ingexetüxü̃ rü yexeraãcü Ngechuchuna nacagüe, rü ñanagürügü: —Pa Corix, Pa Dabítanüxü̃x, ¡cuxü̃́ tangechaü̃tümüü̃gü! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Rü yexguma ga Ngechuchu rü yexma nayachiãchi rü naxcèx naca ga yema ingexetüxü̃. Rü nüxna naca rü ñanagürü: —¿Ṯacü i penaxwèxexü̃ na pexcèx chanaxüxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Rü nümagü nanangãxü̃gü rü ñanagürügü: —Pa Corix, tanaxwèxe na toxü̃ quidauchitanügüxẽẽxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Rü yexguma ga Ngechuchu rü nüxü̃́ nangechaü̃tümüü̃gü, rü naxẽtügügu ningõgü. Rü yexgumatama nidauchigü, rü Ngechuchuwe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Rü yexguma marü yangaicagügu ga Yerucharéü̃wa na nangugüxü̃, rü nawa nangugü ga guma ĩãne ga Bechagué ga Oríbunecüarü mèxpǘneãrü ngaicamana yexmane. Rü Ngechuchu nanamu ga taxre ga norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Rü ñanagürü nüxü̃: —¡Gua tórü to̱xmèxtawa ngẽxmane ya ĩãnexãcüwa pexĩ! Rü ngẽxma tá ngixü̃ pengau i wüxi i buru i ngẽxma ngaxü̃cü namaã i wüxi i ngixãcü i yatüxü̃ i ngixü̃tagu irüxã́ũxü̃. ¡Rü ngixü̃ piwẽxü̃, rü nuã chauxü̃tawa ngixü̃ pega namaã i ngixãcü! ");
INSERT INTO tcaNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Rü ngẽxguma texé pexna caxgu na ṯacücèx ngixü̃ piwẽxü̃xü̃, ¡rü tümamaã nüxü̃ pixu rü ñapegügü: “Torü Cori nangixwèxe namaã i ngixãcü, natürü paxa tá ngixü̃ nawoeguxẽẽ”, ñapegügü tüxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Rü yema naxüpetü yerü yemaãcü Tupana nayanguxẽẽ ga norü ore ga nuxcümaü̃xü̃ ga norü orearü uruü̃ ümatüxü̃ ga ñaxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“¡Yerucharéü̃cü̱̃ã̱xgümaã nüxü̃ pixu rü ñapegü: ‘¡Dücèx ya perü ãẽ̱xgacü ya nuã pexü̃tawa ũcü! Rü nüma rü tama nügü yacuèxüü̃ãcü ínangu, rü wüxi i buruxacüétügumare naxaunagü!’” ñanagürü ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Rü yexguma ga yema taxre ga norü ngúexü̃gü rü yéma naxĩ, rü nanaxügü ga yema Ngechuchu namaã nüxü̃ ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Rü Ngechuchuxü̃tawa ngixü̃ nagagü ga yema buru ngixacümaã. Rü yema norü ngúexü̃gü rü naxchirumaã nanac̱ẖatagü ga yema ngixacü, rü ñu̱xũchi ga Ngechuchu rü natagu naxaunagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Rü yema muxü̃ma ga duü̃xü̃gü ga nawe rüxĩxü̃ rü naxchirumaã nayac̱ẖamatanü ga nama. Rü togü rü naĩxã́tü ta nadaü̃gü rü yemamaã nayac̱ẖamatanü ga nama. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Rü yema duü̃xü̃gü ga napẽ́xegu ãgüxü̃, rü yema togü ga wixweama ãgüxü̃, rü tagaãcü ñanagürügü: —¡Nüxü̃ ticuèxüxü̃gü ya daa ãẽ̱xgacü ya Dabítanüxü̃! ¡Rü namecümaxüchi ya daa Tupanae̱gagu núma ũcü! ¡Rü pema rü ta, Pa Daxũcüã̱x, rü nüxü̃ picuèxüxü̃gü ya Tupana! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Rü yexguma Ngechuchu Yerucharéü̃wa ixücuxgu, rü guxü̃ma ga yema ĩãnecü̱̃ã̱x rü nanaxi̱xãchiãẽgü, rü ñanagürügü: —¿Texe nixĩ ya daa? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Rü yema Ngechuchuwe rüxĩxü̃ ga duü̃xü̃gü rü nanangãxü̃gü rü ñanagürügü: —Daa nixĩ ya Tupanaãrü orearü uruü̃ ya Ngechuchu ya Gariréaanewa ngẽxmane ya ĩãne ya Nacharétucü̱̃ã̱x ixĩcü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Rü tupauca ga taxü̃negu naxücu ga Ngechuchu, rü ínanawoxü̃ ga yema yéma ṯacümaã taxegüxü̃ rü naxcèx taxegüxü̃. Rü nanangüegutanü ga norü mechagü ga yema duü̃xü̃gü ga yéma Tupanaarü ãmarewa mexü̃ ga dĩẽrumaã taxegüxü̃ rü muxtucugümaã taxegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Rü ñanagürü nüxü̃ ga yema duü̃xü̃gü: —Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Chopata rü yumüxẽpataü̃ nixĩ”. Natürü pema rü ngĩ́tèèxgüxü̃pataü̃ peyaxĩxẽẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Rü yéma tupauca ga taxü̃newa rü Ngechuchucèx naxĩ ga ñuxre ga ingexetügüxü̃ rü ichixeparagüxü̃. Rü Ngechuchu nanameẽxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Natürü ga paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃, rü nüxü̃ nadaugü ga yema mexü̃gü ga taxü̃gü ga Tupanaãrü poramaã naxüxü̃ ga Ngechuchu rü buxü̃güxü̃ naxĩnüẽ ga na ñagüxü̃: —¡Namexẽchi ya daa ãẽ̱xgacü ya Ngechuchu ya Dabítanüxü̃! —ñagüxü̃. Rü yemacèx ga yema ãẽ̱xgacügü rü nanuẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Rü ñanagürügü Ngechuchuxü̃: —¿Nüxü̃ cuxĩnüxü̃ i ngẽma buxü̃gü namaã idexagüxü̃? —ñanagürügü. Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Ngü̃, nüxü̃ chaxĩnü. ¿Natürü taguma ẽ́xna nawa pengúe i Tupanaãrü ore i ümatüxü̃ i ñaxü̃: “Rü ngẽma buxü̃gü i íraxüchixü̃ rü õxchanagü rü tá ta cuxü̃ nicuèxüü̃gü”, ñaxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Rü yexguma ga Ngechuchu rü nüxna yéma nixũ, rü ñu̱xũchi ínaxũxũ ga guma ĩãnewa. Rü ĩãne ga Betániawa naxũ, rü yexma nayape. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Rü moxü̃ãcü ga pèxmama rü yexguma wenaxãrü Yerucharéü̃cèx nataegugu ga Ngechuchu rü nataiya. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Rü namacüwawa nüxü̃ nadau ga wüxi ga ori̱x ga iguera. Rü naxcèx nixũ, natürü taxuü̃ma ga norü oxü̃ inayangau, rü naã́tüxü̃xĩcatama inayangau. Rü yemacèx ñanagürü nüxü̃ ga yema ori̱x: —Rü tagutáma wena cuxo̱x, —ñanagürü. Rü yexgumatama narüṉ̃exẽ ga yema ori̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Rü yexguma yemaxü̃ nadaugügu ga norü ngúexü̃gü, rü nabèi̱xãchiãẽgü. Rü Ngechuchuna nacagüe rü ñanagürügü: —¿Rü ñuxãcü i ñaã ori̱x i paxama naṉ̃exẽxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Aixcüma pemaã nüxü̃ chixu rü ngẽxguma chi meã peyaxõgügu rü tama ngẽma igueramaã chaxüxü̃xĩca chi pexü. Natürü yexeraxü̃ chi pexü. Rü ngẽxguma chi daa mèxpǘnemaã nüxü̃ pixuxgu na yaxũgachixü̃cèx rü taxtü i taxü̃chiüwa naxũxü̃cèx, rü pega chi naxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Rü guxü̃ma i ṯacü i naxcèx ípec̱axü̃ i perü yumüxẽwa, rü tá penayauxgü ega aixcüma peyaxõgüãcüma naxcèx ípecaxgu. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Rü Ngechuchu rü tupauca ga taxü̃negu naxücu. Rü yexguma yéma ínangu̱xẽẽtaeyane rü naxcèx naxĩ ga paigüarü ãẽ̱xgacügü rü Yudíugüarü ãẽ̱xgacügüerugü. Rü Ngechuchuna nacagüe rü ñanagürügü: —¿Rü texégagu nixĩ i cunaxüxü̃ i ngẽma núma cuxüxü̃? ¿Rü texé cuxü̃ tamu na cunaxüxü̃cèx i ngẽma? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Choma rü tá ta pexna chaca, rü ngẽxguma choxü̃ pengãxü̃gu i ngẽma pexna naxcèx chac̱axü̃, rü choma rü tá ta pemaã nüxü̃ chixu na ngẽxü̃rüüxü̃ i ãẽ̱xgacü na choxü̃ muxü̃ na nuã changu̱xẽẽtaexü̃. ¿Rü texé tanamu ga Cuáü̃ na duü̃xü̃güxü̃ ínabaiü̃xẽẽxü̃cèx? ¿Pexcèx rü Tupana yiĩxü̃ ga namucü rü ẽ́xna duü̃xü̃gümare? —ñanagürü. Rü yexguma ga yema ãẽ̱xgacügü rü inanaxügüe ga nügümaã na yaporagatanücüüxü̃. Rü nügümaãtama ñanagürügü: —¿Ñuxũ ñagügüxü̃ tá? Erü ngẽxguma chi nüxü̃ ixuxgu na Tupana núma namuxü̃ rü nüma rü tá ñanagürü tüxü̃: “¿Rü tü̱xcüü̃ ga tama nüxü̃́ peyaxõgüxü̃?” ñanagürü tá. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","—Rü ngẽxguma chi nüxü̃ ixuxgu na yatügümare núma namuxü̃ rü taxcèx rü tá naxãũcüma, erü duü̃xü̃gü tá tüxü̃ nadai. Erü nümagü i duü̃xü̃gü rü nagu narüxĩnüẽ na Tupana yiĩxü̃ ga Cuáü̃xü̃ núma mucü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Rü yemacèx Ngechuchuxü̃ nangãxü̃gü rü ñanagürügü: —Tama nüxü̃ tacuèx ga texé núma na namuxü̃ ga Cuáü̃ ga baiü̃xẽẽruü̃ —ñanagürügü. Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Choma rü tá ta tãũtáma pemaã nüxü̃ chixu na texé choxü̃ muxü̃ na chanaxüxü̃ i ngẽma choxna naxcèx pec̱axü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Rü ñanagürü ta ga Ngechuchu —¿Ñuxũ ñapegüxü̃ naxcèx i ñaã ore i tá pemaã nüxü̃ chixuxü̃? Rü wüxi ga yatü rü nüxü̃́ nayexma ga taxre ga nane. Rü wüxi ga guma nanemaã nüxü̃ nixu rü ñanagürü nüxü̃: “Pa Chaunex, chanaxwèxe i yéa chorü ubaarü buxgüwa cuyapuracü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","—Rü guma nane nanangãxü̃ rü ñanagürü: “Choxü̃́ nawèxtümüü̃ na nge̱ma chaxũxü̃”, ñanagürü. Natürü ga yixcamaxü̃ra rü nagu narüxĩnü rü düxwa yéma nayapuracü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","—Rü yixcüra ga guma nanatü rü naĩ ga nanexü̃tawa naxũ, rü yexgumarüü̃ ta nüxü̃ yema ñanagürü. Rü guma nane nanangãxü̃ rü ñanagürü: “Marü name, Pa Pa, rü nge̱ma tá chaxũ”, ñanagürü. Natürü tama aixcüma yéma naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","—Rü ñu̱xma chanaxwèxe i chomaã nüxü̃ pixu rü ngexcürüücü ga guma taxre ga nane ga aixcüma naxücü ga yema nanatü naxwèxexü̃ —ñanagürü. Rü nümagü nanangãxü̃gü rü ñanagürügü: —Ga guma nüxĩra namuãcü nixĩ ga naga ĩnücü —ñanagürügü. Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü ngẽma yatügü i Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ dexü̃ rü ngẽma ngexü̃gü i chixri maxẽxü̃ tá nixĩ i pexü̃pa nüxĩra ichocuxü̃ i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","—Yerü Cuáü̃ ga baiü̃xẽẽruü̃ rü núma naxũ na pemaã nüxü̃ yaxuxü̃cèx na ñuxãcü tá na pemaxẽxü̃, natürü ga pema rü tama nüxü̃́ peyaxõgü. Natürü ga yema yatügü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ dexü̃ rü yema ngexü̃gü ga chixri maxẽxü̃ rü Cuáü̃ãxü̃́ nayaxõgü. Natürü ga pema rü woo nüxü̃ na pedaugüxü̃ ga ñuxãcü na yaxõgüãxü̃, rü tama nüxü̃ perüxoechaü̃ i pecüma i chixexü̃ na peyaxõgüxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Rü ñanagürü ta ga Ngechuchu: —Rü chanaxwèxe i iperüxĩnüẽ i ñaã to i ore i cuèxruü̃ i tá pemaã nüxü̃ chixuxü̃. Rü nayexma ga wüxi ga yatü ga nüxü̃́ nayexmacü ga wüxi ga norü naãne. Rü yexma nanato ga muxü̃ma ga ori̱x ga uba. Rü ñu̱xũchi ínanapoxegu, rü nanaxü ga wüxi ga ubaarü yauxtüü̃xü̃chica rü wüxi ga dauxü̃taechica. Rü ñu̱xũchi ñuxre ga puracütanüxü̃na nüxü̃ nadauxẽẽ. Rü namaã nanamexẽẽ na ngãxü̃gu namaã ngĩxü̃ yatoyexü̃cèx ga yema ubatanü. Rü ñu̱xũchi ga yema naãneãrü yora rü wüxi ga to ga nachiü̃ãne ga yaxü̃guxü̃wa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","—Rü yexguma norü ubaarü buxgüwa nanguxgu, rü yema naãneãrü yora rü yéma nanamugü ga ñuxre ga norü duü̃xü̃gü na yema puracütanüxü̃na ngĩxcèx yac̱axü̃cèx ga yema ubatanü ga nüxna ücü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Natürü ga yema puracütanüxü̃gü rü ínanayauxü̃ ga yema coriarü duü̃xü̃gü. Rü nanac̱uaixgü ga wüxi, rü ga to rü nayamèxü̃chigü, rü ga yema to rü nutamaã ínanamuxũchigü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","—Rü yema naãneãrü yora rü wenaxãrü noxriarü yexera rümumaẽxü̃ ga norü duü̃xü̃gü yéma namugü. Natürü ga yema puracütanüxü̃gü rü yema togürüü̃tama chixri namaã nachopetü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","—Rü düxwa ga yema naãneãrü yora rü yéma nanexü̃chixü̃ namu yerü nüma nagu naxĩnügu rü chi nanega naxĩnüẽ ga yema puracütanüxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","—Natürü yexguma yema cori nanexü̃ nadaugügu ga yema puracütanüxü̃gü, rü nügümaã ñanagürügü: “Ngẽmaãrü tá nixĩ i ñaã naãne i yixcama. ¡Rü ngĩxã tayamèxgü na tóxrü yiĩxü̃cèx!” ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","—Rü nayayauxgü, rü toxnamana nanagagü, rü yexma nayamèxgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Rü yexguma ga Ngechuchu rü yema paigüarü ãẽ̱xgacügüna naca rü ñanagürü: —¿Rü ngẽxguma ínanguxgu i ngẽma naãneãrü yora, rü ṯacü tá yema puracütanüxü̃maã naxü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Rü yema ãẽ̱xgacügü rü Ngechuchuxü̃ nangãxü̃gü, rü ñanagürügü: —Ngẽma naãneãrü yora rü tama nüxü̃́ nangechaü̃tümüü̃ãcüma tá nanadai i ngẽma puracütanüxü̃gü i chixri maxẽxü̃. Rü ñu̱xũchi togü i puracütanüxü̃gü i meã namaã ngĩxü̃ itoyexü̃ i dĩẽruna tá nüxü̃ nadauxẽẽ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Rü Ngechuchu rü ñanagürü nüxü̃: —¿Taguma ẽ́xna nawa pengúe i Tupanaãrü ore i ümatüxü̃? Erü ngẽmawa rü ñanagürü: “Rü yima nuta ya mecü ya ĩãrü üruü̃gü nüxü̃ oechirécü rü ñu̱xma rü yimatama nixĩ ya Tupana nüxĩra yaxücuchicü na namaã inaxügüãxü̃cèx ya ĩpata. Rü tórü Cori ya Tupana nixĩ ga naxücü ga yema, rü ñu̱xma rü namexẽchi i taxcèx”, ñanagürü i ngẽma ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","—Rü ngẽmacèx pemaã nüxü̃ chixu rü woo pexcèxchirẽ́x na yiĩxü̃ i ngẽma naãne i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa, natürü pexna tá nanapu. Rü togü i duü̃xü̃gü i aixcüma Tupanaga ĩnüẽxü̃na tá nanaxã. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","—Rü yima nuta ega texé namaã yarüñaxgu rü tá itapoü̃gü. Rü yíxema tümae̱tügu nanguxe ya yima nuta, rü tá tüxü̃ niñaĩxmü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Rü yexguma ga paigüarü ãẽ̱xgacügü rü Parichéugü nüxü̃ ĩnüẽgu ga yema ore ga cuèxruü̃ ga Ngechuchu namaã nüxü̃ ixuxü̃, rü nüxü̃ nicuèxãchitanü ga nachiga na yiĩxü̃ ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Rü yexgumatama ga yema ãẽ̱xgacügü rü Ngechuchuxü̃ niyauxgüéga. Natürü taxucürüwama nayayauxgü yerü duü̃xü̃güxü̃ namuü̃ẽ, yerü nümagü ga duü̃xü̃gü rü nayaxõgü ga aixcüma Tupanaãrü orearü uruü̃ na yiĩxü̃ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Rü Ngechuchu rü wenaxãrü nanangúexẽẽ. Rü ore ga cuèxruü̃gu namaã nayaxu, rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Rü ngẽma Tupana na ãẽ̱xgacü ixĩxü̃ rü ñoma wüxi ga nachiü̃ãneãrü ãẽ̱xgacü ga naneãrü ngĩgü üchiücürüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","—Rü norü duü̃xü̃güxü̃ namu na naxcèx yac̱axü̃cèx ga yema duü̃xü̃gü ga marü ü̃paacü nüxna naxuxü̃. Natürü yema duü̃xü̃gü ga marü nüxna naxuchiréxü̃ rü tama yéma naxĩxchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","—Rü wenaxãrü togü ga norü duü̃xü̃güxü̃ yéma namugü. Rü ñanagürü nüxü̃: “¡Nge̱ma pexĩ naxü̃tawa i ngẽma duü̃xü̃gü i nüxna chaxuchiréxü̃, rü namaã nüxü̃ peyarüxu rü marü íname i chorü õna i taxü̃. Rü marü chanadai i chorü wocagü i ingüexü̃ rü guxü̃ma marü ínamemare. Rü chanaxwèxe i paxa nuã naxĩ naxcèx i ñaã chorü peta!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","—Natürü yema duü̃xü̃gü ga nüxna naxuchiréxü̃ rü tama naga naxĩnüẽ. Rü wüxi rü naãnewa naxũ, rü ga to rü norü taxepataü̃wa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","—Rü ga togü rü yema ãẽ̱xgacüarü duü̃xü̃güxü̃ ínayauxü̃ rü nayac̱uaixgü ñu̱xmata nayuexẽẽã. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","—Rü yexguma ga guma ãẽ̱xgacü rü poraãcü nanu. Rü norü churaragüxü̃ yéma namugü na yadaiãxü̃cèx ga yema duü̃xü̃gü ga máẽtagüxü̃, rü na yagugüãxü̃cèx ga guma norü ĩãne. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","—Rü ñu̱xũchi ñanagürü nüxü̃ ga norü duü̃xü̃gü: “Guxü̃ma i chorü peta rü marü ínamemare. Natürü ga yema duü̃xü̃gü ga nüxna chaxuchiréxü̃ rü woetama nüxü̃ chaxo na nuã naxĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","—¡Rü yéa taxü̃ i ítamü̃wa pexĩ, rü nüxna peyaxu i guxü̃ i duü̃xü̃gü i nge̱ma nüxü̃ pedauxü̃, na núma chorü petawa naxĩxü̃cèx!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","—Rü yema ãẽ̱xgacüarü duü̃xü̃gü rü yéma ítamü̃wa naxĩ. Rü nüxna nixuetanü ga guxü̃ma ga duü̃xü̃gü ga mexü̃gü rü chixexü̃gü ga nüxü̃ iyangaugüxü̃. Rü yemaãcü duü̃xü̃gümaã nanapa ga guma ãẽ̱xgacüpata. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","—Rü yexguma ga guma ãẽ̱xgacü rü nixücu nawa ga yema ucapu ga nawa peta naxüxü̃, yerü ínayadau ga yema duü̃xü̃gü ga nüxna naxuxü̃. Natürü yéma nüxü̃ nadau ga wüxi ga yatü ga tama norü ngèxãẽchirugu icúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","—Rü ñanagürü nüxü̃: “Pa Chomücüx ¿ñuxãcü i nuxã cuxücuxü̃ na tama curü ngèxãẽchirugu quicúxü̃?” ñanagürü. Natürü nüma ga yema yatü rü nangeèxmare. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","—Rü yexguma ga guma ãẽ̱xgacü rü ñanagürü nüxü̃ ga yema norü duü̃xü̃gü: “¡Meã peyanèĩ̱xpara rü peyanèĩ̱xchacüügü i ñaã yatü, rü yéama düxétüwa i poraãcü ínaxẽãnexü̃wa peyatá! Rü nge̱ma tá narüdoxü rü tá nixü̃́xchapüta erü poraãcü tá nüxü̃́ nangu̱x”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","—Rü Tupana rü muxũchíena naxu, natürü noxretama tixĩ ya yíxema aixcüma Tupana tüxü̃ ndexe —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Rü yexguma ga Parichéugü rü nixĩgachi. Rü noxrüwama nügümaã nayamexẽẽgü na ṯacü rü oremaã tá Ngechuchuna nacagüexü̃cèx na chixexü̃gu nanguxẽẽgüãxü̃cèx rü ñu̱xũchi ãẽ̱xgacüxü̃tawa na ínaxuaxü̃güãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Rü yemacèx Ngechuchuxü̃tawa nanamugü ga ñuxre ga norü duü̃xü̃gü namaã ga ñuxre ga Erodearü duü̃xü̃gü na yema oremaã Ngechuchuna na yacagüexü̃cèx. Rü yexguma Ngechuchuxü̃tawa nangugügu rü ñanagürügü: —Pa Ngúexẽẽruü̃x, nüxü̃ tacuèx rü aixcüma nixĩ i ngẽma nüxü̃ quixuxü̃ i curü ore. Rü aixcüma cunangúexẽẽ i duü̃xü̃gü na Tupana naxwèxexü̃ãcüma namaxẽxü̃cèx. Rü tama duü̃xü̃gügamare cuxĩnü, erü tama norü düxétüxü̃negu cudawenü, natürü nacüma nixĩ i cungugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","—¡Rü tomaã nüxü̃ ixu! rü ngẽma dĩẽru ya ãẽ̱xgacü ya tacü ya Dumacü̱̃ã̱x totanüwa yayauxchaü̃xü̃, ¿rü namexü̃ yiĩxü̃ na nüxna ngĩxü̃ taxãxü̃ rü ẽ́xna tama? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Natürü Ngechuchu nüxü̃ nacuèxama na chixexü̃gu naxĩnüẽxü̃ ga yema duü̃xü̃gü, rü yemacèx ñanagürü nüxü̃: —Pema nixĩ i togüpẽ́xewa meã pemaxẽnetaxü̃, natürü peãẽwa rü chixexü̃gu perüxĩnüẽ. ¿Rü tü̱xcüü̃ i chixexü̃gu choxü̃ penguxẽẽchaü̃xü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","—¡Choxü̃ ngĩxü̃ pewé i wüxi i dĩẽru i ngĩmaã ãẽ̱xgacüaxü̃́ penaxütanücü! —ñanagürü. Rü yéma naxü̃tawa ngĩxü̃ nangegü ga wüxitachinü ga yema dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Rü yexguma Ngechuchu ngĩxü̃ dèu̱xgu, rü nüxna naca, rü ñanagürü —¿Rü texéchicünèxã rü texééga nixĩ i ngĩgu üxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rü nümagü nanangãxü̃gü, rü ñanagürügü: —Dumacü̱̃ã̱x ya ãẽ̱xgacü ya tacüchicünèxã nixĩ —ñanagürügü. Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Ãẽ̱xgacüna ngĩxü̃ pexã i ngẽma ãẽ̱xgacüarü ixĩcü, rü Tupanana ngĩxü̃ pexã i ngẽma Tupanaãrü ixĩcü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Rü yexguma yema orexü̃ naxĩnüẽgu, rü nabèi̱xãchiãẽgü. Rü Ngechuchuna ínixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Rü yematama ngunexü̃gu rü ñuxre ga Chaduchéugü rü Ngechuchuxü̃tawa naxĩ. Rü nümagü nixĩ ga nagu naxĩnüẽxü̃ na yuexü̃ rü tagutáma wena namaxẽxü̃. Rü yemacèx Ngechuchuna nacagüe, rü ñanagürügü: ");
INSERT INTO tcaNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Pa Ngúexẽẽruü̃x, Moĩché nüxü̃ ixuxgu rü ngẽxguma wüxi ya yatü naxãmèx rü nangexacüyane nayu̱xgu, rü name nixĩ i naẽneẽtama ngĩmaã naxãmèx i ngẽma yutecü i naxü̃mèx, na ngẽmaãcü naxãxãcüxü̃cèx nüxü̃́ ya yima naẽneẽ ya marü yucü —ñanagürü ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Rü ñanagürügü ta ga Chaduchéugü: —Nayexma ga totanüwa ga 7 ga nügüeneẽ. Rü naxãmèx ga guma yacü, natürü tauta naxãxãcüyane nayu. Rü yexguma ga naĩ ga naẽneẽ nüxĩ ngĩmaã naxãmèx ga yema ngecü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","—Rü guma rü ta nayu, rü nangexacü. Rü yexguma rü naĩ ga naẽneẽ nüxĩ ngĩmaã naxãmèx. Rü yemaãcü gucüma ga guma 7 ga nügüeneẽ rü ngĩmaã naxãmèx ga yema nge. Rü gucüma nayue tauta naxãxãcüyane. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","—Rü yemawena rü ngĩma rü ta iyu ga yema nge. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","—Rü ngẽxguma yuexü̃ wena maxẽgu, ¿rü ngexcürüücü ga guma 7 ga nügüeneẽ naxmèx tá iyixĩ i ngẽma nge? Yerü gucüma ga guma 7 ga nügüeneẽ ngĩmaã naxãmèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Rü yexguma ga Ngechuchu rü nanangãxü̃, rü ñanagürü: —Pema rü ípetüe erü tama nüxü̃ pecuèx i Tupanaãrü ore i ümatüxü̃, rü tama nüxü̃ pecuèx i ñuxãcü na yiĩxü̃ i Tupanaarü pora. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","—Rü ngẽxguma yuexü̃ wena maxẽgu rü taxúetáma tixãmèxgü rü ẽ́xna tixãtegü. Erü daxũcü̱̃ã̱x i Tupanaãrü orearü ngeruü̃gürüü̃ tá tixĩgü i ngẽxguma. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","—Pema choxna peca i yuexü̃ãrü dagüchiga. ¿Natürü tama ẽ́xna nawa pengúe i Tupanaãrü ore i ümatüxü̃ i ngextá Tupanatama ngẽmachigaxü̃ pemaã íyaxuxü̃wa? Erü nge̱ma rü ñanagürü ya Tupana: ");
INSERT INTO tcaNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Choma nixĩ i Abráü̃ãrü Tupana, rü Ichaáarü Tupana, rü Acobuarü Tupana”, ñanagürü. Rü ngẽma orewa nüxü̃ tacuèx rü woo ñoma i naãnewa nayuegu i duü̃xü̃gü, natürü Tupanaarü ĩnüwa rü guxü̃guma namaxẽ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Rü yexguma yemaxü̃ naxĩnüẽgu ga duü̃xü̃gü, rü guxü̃ma nabèi̱xãchiãẽgü namaã ga norü ngu̱xẽẽtae ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Rü nangutaguẽ́xegü ga Parichéugü ga yexguma nüxü̃ naxĩnüẽgu ga ñuxãcü Ngechuchu rü yema Chaduchéugüxü̃ na iyanangeèxgüxẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Rü wüxi ga yema Parichéugü ga ore ga mugüwa ngu̱xẽẽtaexü̃ rü Ngechuchuxü̃ chixexü̃gu nanguxẽẽchaü̃. Rü yemacèx Ngechuchuna naca rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Pa Ngúexẽẽruü̃x, ¿ngẽxü̃rüüxü̃ i Tupanaãrü mu nixĩ i guxü̃ i norü mugüarü yexera ixĩxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Ngẽma Tupanaãrü mu i guxü̃ i norü mugüarü yexera ixĩxü̃, rü ñanagürü: “¡Rü nüxü̃ nangechaü̃ ya Cori ya curü Tupana i guxü̃ne ya curü maxü̃nemaã, rü guxü̃ i cuãẽmaã, rü guxü̃ i nagu curüxĩnüxü̃maã!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","—Rü ngẽma nixĩ i Tupanaãrü mu i guxü̃ i norü mugüarü yexera ixĩxü̃. Rü ngẽma nixĩ i nüxĩraü̃xü̃ i norü mu ga duü̃xü̃güna naxãxü̃ ga Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","—Rü ngẽma norü taxre i Tupanaãrü mu, rü ngẽma nüxĩraü̃xü̃ i norü murüü̃tama nixĩ, rü ñanagürü: “¡Nüxü̃ nangechaü̃ i cumücü ngẽma na cugü cungechaü̃xü̃rüü̃!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","—Rü ngẽma taxre i Tupanaãrü mugüwa nixĩ inaxügüxü̃ i guxü̃ma i Tupanaãrü mugü ga Moĩché ümatüxü̃ rü nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü namaã ngu̱xẽẽtaegüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Rü yoxni ga Parichéugü rü yéma nangutaquẽ́xegü, rü Ngechuchu nüxna naca, rü ñanagürü: —¿Rü ñuxũ ñapegüxü̃ i pema nüxü̃ ya Cristu? ¿Rü texétaa yiĩxü̃? —ñanagürü. Rü nümagü ga Parichéugü rü nanangãxü̃gü rü ñanagürügü: —Cristu rü nuxcümaü̃cü ga ãẽ̱xgacü ga Dabítaa nixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Rü yexguma ga Ngechuchu rü ñanagürü: —¿Tü̱xcüü̃ ga Dabí ga norü Corimaã naxuaxü̃ ga Cristu ga yexguma Tupanaãẽ ga Üünexü̃ Dabíxü̃ idexaxẽẽgu? Yerü ga Dabí rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Tupana rü chorü Cori ya Cristuxü̃ ñanagürü: ‘¡Nuã chorü tügünecüwawa rüto ñu̱xmatáta nüxü̃ charüporamaẽ i curü uwanügü na cuga naxĩnüẽxü̃cèx!’ ” ");
INSERT INTO tcaNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","—Natürü ¿ñuxũcürüwa i Dabítaa yiĩxü̃ ya Cristu ega nümatama ga Dabí rü norü Corimaã naxuãgu? —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Rü taxumaãma nanangãxü̃güéga ga yema Parichéugü, rü bai ga wüxi ga oremaã. Rü yemawena rü guxü̃ma namuü̃ẽ na ṯacücèx Ngechuchuna nacagüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Rü yemawena ga Ngechuchu rü duü̃xü̃güxü̃ rü norü ngúexü̃güxü̃ ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Ngẽma ngúexẽẽruü̃gü i ore i mugüwa ngu̱xẽẽtaegüxü̃ rü Parichéugü, rü meãma nüxü̃ nacuèxgü ga Tupanaãrü ore ga Moĩché ümatüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","—Rü ngẽmacèx name i naga pexĩnüẽ i guxü̃ma i ngẽma pemaã nüxü̃ yaxugüxü̃. Natürü tama name i nüma namaxẽxü̃ãcüma pemaxẽ, erü nüma nüxü̃ nixugü i mexü̃ i ore natürü chixri namaxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","—Erü nüma rü poraãcü pexü̃ namu na naga pexĩnüẽxü̃cèx i norü mugü i guxchaxü̃ i taxucürüwama texé aurexü̃. Natürü nümagütama rü bai i írarüwa naga na naxĩnüẽxü̃ i ngẽma nawa pexü̃ namuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","—Rü guxü̃ma i ngẽma naxügüxü̃, rü nanaxügü na duü̃xü̃gü nüxü̃ daugüxü̃cèx. Rü ina-yangegü i Tupanaãrü ore na ngẽmaãcü duü̃xü̃gü nagu rüxĩnüẽgu rü aixcüma Tupanaãrü duü̃xü̃gü na yiĩgüxü̃. Rü nügü nangèxãẽgü na duü̃xü̃gü nüxü̃ rüdaunüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","—Rü petagüarü õnawa rü nümagü i Parichéugü rü nanaxwèxegü i õnaãrü yoraxü̃tawaxüchi na natogüxü̃ na duü̃xü̃gü nge̱ma nüxü̃ rüdaunüxü̃cèx. Rü ngutaquẽ́xepataü̃güwa rü nanaxwèxegü na napẽ́xewaxüchi ügüxü̃ i naxmèxwẽ́xegüwa natogüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","—Rü ĩãneãrü ítamü̃güwa rü nanaxwèxegü na duü̃xü̃gü meã nüxü̃ rümoxẽgüxü̃ ñoma ãẽ̱xgacüxü̃ meã rümoxẽxü̃rüü̃. Rü nanaxwèxegü na duü̃xü̃gü rü: “Pa Ngúexẽẽruü̃x” ñagüxü̃ nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","—¡Natürü pema rü tãũtáma ngẽmagu perüxĩnüẽ! Erü guxãma i pema rü pegüeneẽgü pixĩgü, rü wüxixicatama nixĩ ya perü ngúexẽẽruü̃ ixĩcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","—Rü tama name i ñoma i naãnecü̱̃ã̱xmaã pexãnatü, erü wüxixicatama nixĩ ya Penatü, rü nüma rü daxũwa nangẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","—Rü tama name i texé: “Pa Ãẽ̱xgacüx” ñatarügü pexü̃. Erü chaxicatama nixĩ i perü ãẽ̱xgacü chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","—Rü yíxema petanüwa guxããrü yexera ixĩxẽ rü tanaxwèxe na guxü̃ma i tümamücüarü ngü̃xẽẽruü̃ tiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","—Erü yíxema tügü írütaxe rü Tupana tá tüxü̃ naxãnexẽẽ. Natürü yíxema tügü írüxíraxe, rü Tupana tá tüxü̃ nicuèxüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","—Pa Ngúexẽẽruü̃gü i Ore i Mugüwa Ngu̱xẽẽtaegüxü̃ rü Pa Parichéugüx, pema nixĩ i togü i duü̃xü̃güpẽ́xewa meã pemaxẽnetaxü̃ natürü peãẽwa rü chixexü̃gu perüxĩnüẽxü̃. Rü wüxi i ngechaü̃ nixĩ i pexcèx erü pegagu nixĩ na tama Tupanaxü̃tawa nangugüxü̃ i togü i duü̃xü̃gü. Rü pema rü ta rü tãũtáma ngẽxma pechocu, Rü ngẽxgumarüü̃ ta rü nüxü̃́ penaguxchaxẽẽ na tama ngẽxma nachocuxü̃cèx i togü i ngẽxma chocuchaü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","—Pa Ngúexẽẽruü̃gü i Ore i Mugüwa Ngu̱xẽẽtaegüxü̃ rü Pa Parichéugüx, pema nixĩ i togü i duü̃xü̃güpẽ́xewa meã pemaxẽnetaxü̃ natürü peãẽwa rü chixexü̃gu perüxĩnüẽxü̃. Rü wüxi i ngechaü̃ nixĩ i pexcèx erü tüxna penapuxü̃ ya tümapata ya yíxema yutegüxe. Rü ñu̱xũchi penamèxẽẽ i perü yumüxẽgü na duü̃xü̃gü nagu rüxĩnüẽgu rü aixcüma mexü̃ i Tupanaãrü duü̃xü̃gü na pixĩgüxü̃. Rü ngẽmacèx pema tá nixĩ i togü i duü̃xü̃güarü yexera pepoxcuexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","—Pa Ngúexẽẽruü̃gü i Ore i Mugüwa Ngu̱xẽẽtaegüxü̃ rü Pa Parichéugüx, pema nixĩ i togü i duü̃xü̃güpẽ́xewa meã pemaxẽnetaxü̃ natürü peãẽwa rü chixexü̃gu perüxĩnüẽxü̃. Rü wüxi i ngechaü̃ nixĩ i pexcèx erü guxü̃wama pexĩ na togü i duü̃xü̃gümaã nüxü̃ peyarüxuxü̃cèx i ore na wüxitama ya duü̃xẽ pexrüü̃ na yaxõxü̃cèx. Rü ngẽxguma marü pexü̃ tanguü̃xgu, rü tüxü̃ pechixexẽẽ na düxwa taxreẽ́xpü̱xcüna perü yexera chixexü̃wa tangẽxmaxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","—Pa Ngúexẽẽruü̃gü i Ore i Mugüwa Ngu̱xẽẽtaegüxü̃ rü Pa Parichéugüx, pema rü ñoma cuèxruü̃gü i ngexetüxü̃rüü̃ pixĩgü. Rü wüxi i ngechaü̃ nixĩ i pexcèx, erü nüxü̃ pixuxgu rü: “Ngẽxguma texé ya tupauca ya taxü̃nee̱gagu ṯacücèx ixunetagu, rü marü name ega tama tayanguxẽẽgu i ngẽma tümaãrü uneta”, ñaperügügü. Natürü ngẽxguma texé tupauca ya taxü̃neãrü dĩẽruégagu ṯacücèx ixunetagu, rü: “Tanaxwèxe i aixcüma tayanguxẽẽ i ngẽma tümaãrü uneta”, ñaperügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","—Pema rü pengẽãẽgü rü ñoma pengexetügüxü̃rüü̃ pixĩgü. ¿Pexcèx rü ṯacü nixĩ i yexera rümemaẽxü̃, tupauca ya taxü̃neãrü dĩẽru rü ẽ́xna nümatama ya tupauca ya nagagu naxüünene i ngẽma dĩẽru? ");
INSERT INTO tcaNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","—Rü tupauca ya taxü̃newa nangẽxma i ngẽma ãmarechica i ngexta Tupanacèx ínadaiaxü̃wa i naxü̃nagü na Tupanana naxãmarexü̃cèx. Rü pema rü ñaperügügü: “Rü ngẽxguma texé ya tupauca ya taxü̃neãrü ãmarechicaégagu ṯacücèx ixunetagu, rü marü name ega tama tayanguxẽẽgu i ngẽma tümaãrü uneta. Natürü ngẽxguma texé tupauca ya taxü̃neãrü ãmarechicawa ngẽxmaxü̃ i ãmareégagu ṯacücèx ixunetagu, rü tanaxwèxe i aixcüma tayanguxẽẽ i ngẽma tümaãrü uneta”, ñaperügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","—Pema rü pengẽãẽgü rü ñoma pengexetügüxü̃rüü̃ pixĩgü. ¿Pexcèx rü ṯacü nixĩ i yexera rümemaẽxü̃, rü yima tupauca ya taxü̃neãrü ãmarechicawa ngẽxmaxü̃ i ãmare rü ẽ́xna nümatama ya tupauca ya taxü̃neãrü ãmarechica i nagagu naxüünexü̃ i ngẽma ãmare? ");
INSERT INTO tcaNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","—Erü yíxema tupauca ya taxü̃neãrü ãmarechicaégagu ṯacücèx ixunetaxe, rü tama ngẽma nachicaégaguxicatama itaxuneta, natürü ngẽma ãmare i ngẽma nachicawa ngẽxmaxü̃e̱gagu rü ta itaxuneta. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","—Rü yíxema tupauca ya taxü̃nee̱gagu ṯacücèx ixunetaxe, rü tama ngẽma tupaucaégaguxicatama itaxuneta, natürü Tupana ya ngéma maxü̃cüégagu rü ta itaxuneta. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Rü yíxema daxũguxü̃ i naãnee̱gagu ṯacücèx ixunetaxe, rü Tupanaãrü toruü̃e̱gagu rü ta itaxuneta, rü ngẽxgumarüü̃ ta Tupana ya nge̱ma rütocüégagu rü ta itaxuneta. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","—Pa Ngúexẽẽruü̃gü i Ore i Mugüwa Ngu̱xẽẽtaegüxü̃ rü Pa Parichéugüx, pema nixĩ i togü i duü̃xü̃güpẽ́xewa meã pemaxẽnetaxü̃, natürü peãẽwa rü chixexü̃gu perüxĩnüẽxü̃. Rü wüxi i ngechaü̃ nixĩ i pexcèx, erü woo ṯacü i íraxü̃ i pexü̃́ ngẽxmaxü̃ rü Tupanana penaxã i ngẽma nüxna üxü̃. Natürü tama naga pexĩnüẽ i Tupanaãrü mugü i guxü̃ i mugüarü yexera ixĩxü̃. Erü pexü̃́ nataxu na ãẽ̱xgacügü i aixcüma meãma duü̃xü̃gümaã icuèxgüxü̃ na pixĩgüxü̃, rü pexü̃́ nataxu na duü̃xü̃gü pexü̃́ nangechaü̃tümüü̃güxü̃, rü aixcüma meã Tupanamaã pixaixcümagüxü̃. Rü guxü̃ma i ngẽma nixĩ i Tupana naxwèxexü̃ na penaxüxü̃, tama nüxü̃ ipeyarüngümaẽãcüma i ngẽma mexü̃ i marü pexüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","—Pa Cuèxruü̃gü i Ngexetügüxü̃x, pema rü guxü̃ma i mugü i woo íraxüchixü̃ rü meãma penaxaure, natürü tama Tupana naxwèxexü̃ãcüma pemaxẽ. Pema rü ñoma wüxi i duü̃xü̃ i tunücèx norü axexü̃ bapetüxü̃ rü ñu̱xũchi arü wüxi i cameyu ixaxwetaü̃xü̃rüü̃ pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","—Pa Ngúexẽẽruü̃gü i Ore i Mugüwa Ngu̱xẽẽtaegüxü̃ rü Pa Parichéugüx, pema nixĩ i togü i duü̃xü̃güpẽ́xewa meã pemaxẽnetaxü̃ natürü peãẽwa rü chixexü̃gu perüxĩnüẽxü̃. Rü wüxi i ngechaü̃ nixĩ i pexcèx, erü perü düxétüxü̃newaxicatama pegü pemexẽẽchaü̃, natürü perü maxü̃wa rü poraãcü pichixe. Erü penawomüxẽẽãcüma poraãcü naxcèx pengĩ̱x i duü̃xü̃güarü ngẽmaxü̃gü, rü pegüguxicatama perüxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","—Pa Parichéugü i Ñoma Ngexetüxü̃rüü̃ Ixĩgüxü̃x, name nixĩ i pegü pimexẽẽ i perü aixepewa i perü maxü̃wa. Rü ngẽxguma tá nixĩ i perü düxétüwa rü tá ta pimexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","28","—Pa Ngúexẽẽruü̃gü i Ore i Mugüwa Ngu̱xẽẽtaegüxü̃ rü Pa Parichéugüx, pema nixĩ i togü i duü̃xü̃güpẽ́xewa meã pemaxẽnetaxü̃ natürü peãẽwa rü chixexü̃gu perüxĩnüẽxü̃. Rü wüxi i ngechaü̃ nixĩ i pexcèx, erü ñoma yuetachiquẽ́xegü i düxétüwa cómüxü̃maã chauxetügüxü̃ natürü aixepewa rü yuetachinaxãmaã rü nagúxü̃raü̃xü̃ i ãũãchixü̃maã napagüxü̃rüü̃ pixĩgü. Erü perü düxétüwa i duü̃xü̃gü nüxü̃ ídaugüxü̃waxicatama pime, natürü aixepewa i peãẽwa rü poraãcü pichixe. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","—Rü wüxi i ngechaü̃ nixĩ i pexcèx, Pa Ngúexẽẽruü̃gü i Ore i Mugüwa Ngu̱xẽẽtaegüxü̃ rü Pa Parichéugüx. Pema rü peyamecagü ga naxchiquẽ́xegü ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü rü yema duü̃xü̃gü ga imexü̃ ga yuexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","—Rü ñu̱xũchi ñaperügügü: “Rü yexguma chi nuxcümaü̃güxü̃ ga tórü o̱xigü maxẽyane imaxẽgu, rü tãũ chima nüxü̃ tarüngü̃xẽẽ ga na nadaiãxü̃ ga yema nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü”, ñaperügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","—Rü ngẽma oremaã rü pegü pengo̱xẽẽ na nataagü pixĩgüxü̃ ga yema duü̃xü̃gü ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃güxü̃ dèi̱xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","—¡Ẽcü, noxtacüma chomaã rü ta peyanguxẽẽ̱x ga yema chixexü̃ ga nuxcümaü̃güxü̃ ga perü o̱xigü ügüexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","—Pa Ãxtapearü Duü̃xü̃güx, pema rü poraãcü pichixe. ¿Ñuxãcü tá naxchaxwa pibuxmü ya yima üxü ya Tupana tá namaã pexü̃ poxcuene? ");
INSERT INTO tcaNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","—Rü ngẽmacèx i choma rü tá pexcèx núma chanamugü i Tupanaãrü orearü uruü̃gü, rü yatügü i mexü̃gü i nüxü̃ cuèxüchigüxü̃, rü ngúexẽẽruü̃gü i mexü̃gü. Natürü pema rü tá curuchawa peyapotagüãcüma penadai i ñuxre. Rü togü rü ngutaquẽ́xepataü̃güwa rü tá peyac̱uaixgü, rü togü rü ĩãnechigüwa rü tá nawe pingẽxü̃tanü na chixexü̃ namaã pexügüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","—Natürü Tupana tá pexü̃ napoxcue naxcèx i guxü̃ma ga norü duü̃xü̃gü ga imexü̃gü ga perü o̱xigü dèi̱xü̃. Rü Abéwa nixĩ ga inaxügüãxü̃ ga na nadaiãxü̃ rü Chacaría ga tupauca ga taxü̃negu peyamèxgücügu nixĩ ga yacuáxü̃ ga yema. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","—Rü aixcüma pemaã nüxü̃ chixu rü guxü̃ma ga yema chixexü̃cèx rü Tupana tá nanapoxcue i duü̃xü̃gü i ñomaü̃cüü maxẽxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Rü ñanagürü ta ga Ngechuchu: —Pa Yerucharéü̃cü̱̃ã̱x, pema penadai i Tupanaãrü orearü uruü̃gü, rü nutamaã ípenamuxũchigü i Tupanaãrü orearü ngeruü̃gü i pexcèx núma namugüxü̃. Rü ñuxreẽ́xpü̱xcüna wüxigu chaugüxü̃tagu pexü̃ chanutaquẽ́xexẽẽchaü̃ ñoma wüxi i ota i naxãcüxã nügütüü̃gu tüxü̃ nutaquẽ́xexü̃rüü̃. Natürü pema rü tama penaxwèxe. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","—Dücèx i ñu̱xma ya perü ĩãne, rü Tupana tá ínanatèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","—Rü pemaã nüxü̃ chixu rü tãũtáma wena choxü̃ pedau ñu̱xmatáta daxũguxü̃ i naãnewa ne chaxũ. Rü ngẽxguma rü tá choxü̃ pedaugü rü tá ñaperügügü: “Namexẽchi nixĩ ya yima Cori ya Tupana núma namucü”, ñaperügügü tá —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Rü yexguma tupauca ga taxü̃newa ínaxũũxgu ga Ngechuchu, rü norü ngúexü̃gü naxcèx naxĩ. Rü ñanagürügü nüxü̃: —Dücèx, Pa Corix, ñuxãcü nimexẽchi ya daa tupauca ya taxü̃neãrü ĩpatagü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Natürü Ngechuchu nanangãxü̃ rü ñanagürü: —Pema nüxü̃ pedaugü ya guxü̃nema ya yima tupauca ya taxü̃neãrü ĩpatagü. Natürü pemaã nüxü̃ chixu rü aixcüma guxü̃nema ya daa ĩpatagü rü tá nagu napogüe. Rü naxtapü̱xarü nutagü rü taxucütáma nügüétü naxüxüra, rü bai ya wüxi —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Rü ñu̱xũchi guma Mèxpǘne ga Oríbunecügu ãe̱ganewa naxĩ. Rü yexguma guma mèxpǘnewa nato̱xgu ga Ngechuchu rü norü ngúexü̃güxicatama naxü̃tawa naxĩ na noxrüwama nüxna nacagüexü̃cèx. Rü ñanagürügü: —Tanaxwèxe i tomaã nüxü̃ quixu na ñuxgu tá nangupetüxü̃ i ngẽma nüxü̃ quixuxü̃. ¿Rü ṯacü tá nixĩ i norü cuèxruü̃ i nawa nüxü̃ tacuáxü̃ i ñuxgu tá wena núma na cuxũxü̃ rü tá na nagúxü̃ i naãne? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Pexuãẽgü na taxúema pexü̃ womüxẽẽxü̃cèx! ");
INSERT INTO tcaNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","—Erü muxũchixü̃ i duü̃xü̃gü tá ínangugü, rü chaugu tá nügü nicu̱xgü rü tá ñanagürügü: “Choma nixĩ i Cristu”, ñanagürügü tá. Rü muxũchixü̃ i duü̃xü̃güxü̃ tá nawomüxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","—Rü tá nüxü̃ pexĩnüẽchiga na nügü nadèi̱xü̃ i ñuxre i nachiü̃ãnegü rü nügü na nadaixchaü̃xü̃ i togü i nachiü̃ãnegü. ¡Natürü tãũtáma ngẽmacèx pebèi̱xãchiãẽgü! Erü woetama ngẽmaãcü tátama nangupetü i noxrix. Natürü tãũtáma naãneãrü gu̱x nixĩ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","—Erü wüxi i nachiü̃ãne rü to i nachiü̃ãnemaã tá nügü nadai. Rü wüxi i ãẽ̱xgacü rü to i ãẽ̱xgacümaã tá nanu, rü norü churaragü rü ngẽma to i ãẽ̱xgacüarü churaragümaã tá nügü nadai. Rü tá taiya nangu̱x, rü tá nataxüchi i ḏaaweanegü, rü muxü̃ma i nachicawa rü tá naxĩã̱xãchiane. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","—Rü guxü̃ma i ngẽma pemaã nüxü̃ chixuxü̃, rü ngẽma nixĩ i norü ügümare i ngẽma ngúxü̃ i tá ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","—Rü ngẽxguma i togü i duü̃xü̃gü rü tá pexü̃ ínayauxü̃ na chixexü̃ pemaã naxügüxü̃cèx. Rü tá pexü̃ nadai. Rü guxü̃ i naãnewa i duü̃xü̃gü rü tá pexchi naxaie, erü chorü duü̃xü̃gü pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","—Rü ngẽxguma rü tá muxũchixü̃ i chorü duü̃xü̃gü ínanatèxgü i chorü ore, rü nügütanüwa rü tá nügüchi naxaie. Rü nügüechita tá ãẽ̱xgacüxü̃tawa nügü ínayaxuaxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","—Rü muxũchixü̃ i orearü uruü̃güneta tá ínangugü. Rü tá nüxü̃ nixugügü na Tupana yiĩxü̃ ya núma namugücü na nüxü̃ yaxugüxü̃cèx i ore. Rü ngẽmaãcü tá muxũchixü̃ i duü̃xü̃güxü̃ nawomüxẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","—Rü poraãcü tá nangẽxma i chixexü̃, rü ngẽmagagu rü muxũchixü̃táma i duü̃xü̃gü rü tãũtáma nügü nangechaü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","—Natürü yíxema nae̱tüwa meã Tupanaãxü̃́ yaxõõmáxẽ rü yíxema tá tixĩ ya aixcüma nayaxúxe i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","—Rü ngẽma Tupanaãrü ore i mexü̃ rü guxü̃ i naãnewa tá nüxü̃ nixugügü na guxü̃ i duü̃xü̃gü nüxü̃ na cuèxgüxü̃cèx. Rü ngẽmawena tá nixĩ i nagúxü̃ i naãne. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","—Rü nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Danié nachiga nanaxümatü i ngẽma chixexü̃ i Tupanapẽ́xewa ãũãchixü̃ i ínguxchaü̃xü̃. Rü ngẽxguma nüxü̃ pedèu̱xgu na tupauca ya taxü̃newa nangóxü̃ i ngẽma chixexü̃ i Tupanapẽ́xewa chixexüchixü̃, rü name nixĩ i pexuãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","—Rü ngẽxguma ngẽma üpetügu, rü ngẽma Yudéaanewa ngẽxmagüxü̃ i duü̃xü̃gü rü nanaxwèxe na mèxpǘneãnewa nabuxmüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","—Rü ngẽma ngunexü̃gu ega texé tümapataèxtüwa ngẽxmagu, rü tama name i tümapatagu tayangaxi na tümaãrü ngẽmaxü̃ tayayaxuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","—Rü texé ya tümaãnewa ngẽxmaxẽ rü tama name i tümapatacèx tataegu na tümachirugü tayayaxuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","—Rü ngẽma ngunexü̃gügu rü wüxi i ngechaü̃ tá nixĩ i tümacèx ya yíxema ngeã̱xtagü ya tacharaü̃güxe rü yíxema imaĩxãcügüxe. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","—¡Rü Tupanana naxcèx pec̱a i perü yumüxẽwa na tama gáuane ixüyane rü ẽ́xna ngü̃xchigaarü ngunexü̃guyane pexü̃ na nangupetüxü̃cèx i ngẽma chixexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","—Erü ngẽma ngunexü̃gügu rü poraãcü tá nangẽxma i ngúxü̃ ga noxri naãne ixügügumama taguma yexmaxü̃, rü ngẽmawena rü tagutáma wena nangẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","—Rü ngẽxguma Tupana tama nanoxrexẽẽgu i ngẽma ngunexü̃gü, rü taxúetáma tamaxü̃. Natürü Tupana tá nananoxrexẽẽ i ngẽma ngunexü̃gü tümacèx ya yíxema nüma tüxü̃ nadexe. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","—Rü ngẽxguma texé pexü̃ ñagügu: “Dücèx, daa nixĩ ya Cristu” ñagügu, rü ẽ́xna: “Gua nixĩ ya Cristu” ñagügu, ¡rü tama name i nüxü̃́ peyaxõgü! ");
INSERT INTO tcaNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","—Erü Cristugüneta rü Tupanaãrü orearü uruü̃güneta tá ínangugü. Rü tá nanaxügü i muxü̃ma i cuèxruü̃gü i taxü̃gü na ngẽmaãcü, ega nüxü̃́ natauxchagu, na tüxü̃ nawomüxẽẽgüxü̃cèx èi̱xrüxe ya yíxema duü̃xẽgü ya Tupanatama tüxü̃ dexe. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","—Dücèx, naxü̃pa na nangupetüxü̃ i guxü̃ma i ngẽma ngúxü̃, rü marü pemaã nüxü̃ chixu i nachiga. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","—Rü ngẽmacèx i ngẽxguma duü̃xü̃gü ñagügu pexü̃: “Dücèx, yéa taxúema íxãpataxü̃wa nangẽxma ya Cristu”, ñagügu, rü tama name i nge̱ma pexĩ. Rü ngẽxguma ñagügu pexü̃: “Dücèx, nuã ucapuwa nangẽxma ya Cristu”, ñagügu, rü tama name i nüxü̃́ peyaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","—Erü ñoma wüxi i bèi̱xbẽ́xane i guxü̃wama nangóonexẽẽxü̃rüü̃ tá nixĩ i ngẽxguma wenaxãrü núma chaxũxgu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Rü duü̃xü̃gü rü tá chauxcèx nangutaquẽ́xegü ñoma ẽxchagü nawemücèx ngutaquẽ́xexü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","—Rü nawena i ngẽma ngúxü̃gü rü tá nixo ya üèxcü, rü tãũtáma inabáxi ya tauemacü. Rü woramacurigü rü ẽxtagü rü tá narüyi. Rü guxü̃ma i ñoma i naãne rü üèxcü rü tauemacü rü woramacurigü rü ẽxtagü rü tá naxĩã̱xãchitanü rü tá nu ne nanaxĩmare. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","—Rü ñu̱xũchi duü̃xü̃gü tá nüxü̃ nadaugü na ñuxãcü daxũwa ne chaxũxü̃. Rü guxü̃ i nachiü̃ãnecü̱̃ã̱x i duü̃xü̃gü rü tá naxauxe. Rü tá choxü̃ nadaugü i ngẽxguma caixanexü̃gügu ícharüxĩxgu rü núma chaxũxgu. Rü ngẽxguma i choma rü ãẽ̱xgacü ya poraxüchicü rü mexẽchicü tá chixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","—Rü tá chanamu i chorü orearü ngeruü̃gü i daxũcü̱̃ã̱x na yacuegüãxü̃cèx ya norü cornetagü na ngẽmaãcü naxĩtaquẽ́xexẽẽãxü̃cèx i guxü̃ma i ngẽma duü̃xü̃gü i chadexü̃ i guxü̃wama ngẽxmagüxü̃ ñu̱xmata naãne iyacuáxü̃wa ngẽxmagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","—¡Iperüxĩnüẽ i ñaã ore i cuèxruü̃ i ori̱x i iguerachiga, rü naxcèx pengúe! Rü ngẽxguma ngexwacaxü̃xü̃ i nachacüügü iyarüyixgu rü naxüátügu, rü ngẽmawa nüxü̃ pecuèx na paxa tá taunecü na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","—Rü ngẽxgumarüü̃ tá nixĩ i ngẽxguma nagúxchaü̃gu i naãne. Erü ngẽxguma nüxü̃ pedèu̱xgu na nangupetüxü̃ i ngẽma pemaã nüxü̃ chixuxü̃, rü ngẽmawa tá nüxü̃ pecuèx na marü chingaicaxüchixü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","—Rü aixcüma pemaã nüxü̃ chixu rü guxü̃ma i ngẽma nüxü̃ chixuxü̃ rü tá nangupetü naxü̃pa na nayuexü̃ i duü̃xü̃gü i ñomaü̃cüü maxẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","—Rü ñoma i naãne rü ngẽma daxũwa nüxü̃ idauxü̃ rü tá nagu̱x. Natürü chorü ore rü tagutáma inayarüxo rü aixcüma tá ningu. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","—Natürü ngẽma ngunexü̃ rü ora i nagu tá nangupetüxü̃ i ngẽma pemaã nüxü̃ chixuxü̃, rü Chaunatü ya Tupanaxĩcatama nüxü̃ nacuèx na ñuxgu tá nangupetüxü̃ i ngẽma, rü taxúema ya togue nüxü̃ tacuèx. Rü woo i norü orearü ngeruü̃gü i daxũcü̱̃ã̱x rü tama nüxü̃ nacuèxgü, rü woo i choma i Nane na chiĩxü̃ rü tama nüxü̃ chacuèx na ñuxgu tá nangupetüxü̃ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","—Rü yexgumarüü̃ ga duü̃xü̃güxü̃ ngupetüxü̃ ga yexguma Noe̱ maü̃xgu, rü ngẽxgumarüü̃ tá ta nüxü̃ nangupetü i ngẽxguma íchanguxgu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","—Rü yexguma, naxü̃pa ga guma mucü ga taxüchicü ga guxü̃wama inanguanexẽẽcü, rü ga duü̃xü̃gü rü nachibüe, rü naxaxegü, rü nixãmèxgü rü nixütexacügü ñu̱xmata nawa nangu ga yema ngunexü̃ ga nagu Noe̱ naweü̃gu ixüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","—Rü noxri ga yema duü̃xü̃gü rü tama nüxü̃ nacuèxgüéga ga ṯacü tá nüxü̃ na ngupetüxü̃. Natürü yexguma ínanguxgu ga guma mucü ga taxüchicü ga yema duü̃xü̃güxü̃ ḏaicü, rü yexguma nixĩ ga nüxü̃ yacuèxãchitanüxü̃. Rü ngẽxgumarüü̃ tá ta nixĩ i ngẽxguma wenaxãrü núma chaxũxgu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","—Rü ngẽma ngunexü̃gu rü taxre i yatügü rü wüxi i naãnewa tá nügümaã nangẽxmagü. Rü wüxi tá nixĩ i Tupana igaxü̃ rü ngẽma to rü tá nge̱ma natèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","—Rü taxre i ngexü̃gü tá nügümaã ínacaegü. Rü wüxi tá nixĩ i Tupana igaxü̃ rü ngẽma to rü tá nge̱ma natèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","—¡Rü pexuãẽgü! Erü tama nüxü̃ pecuèx i ṯacü rü ora tá íchangu i chomax. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","—¡Rü nagu perüxĩnüẽ i ñaã ore! Rü ngẽxguma chi wüxi i ĩpataarü yora nüxü̃ cuèxgu na ṯacü rü oragu tá ínanguxü̃ i ngĩ́tèxáxü̃ rü tãũ chima nape. Erü nüxna chi nadau ya napata na tama ngẽxma naxücuxü̃cèx i ngẽma ngĩ́tèxáxü̃ na ṯacücèx nge̱ma yangĩ́xü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","—Rü ngẽmacèx name nixĩ i pexuãẽgü i pemax. Erü ngẽma ngunexü̃ i tama nagu íperüxĩnüẽxü̃gu tá nixĩ i ngürüãchi íchanguxü̃ i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","—¿Rü texé tiĩxü̃ ya tümaãrü coriarü duü̃xü̃ ya aixcüma yanguxẽe̱xẽ rü tümaãẽxü̃ cuáxe? ¿Tama ẽ́xna yíxema tiĩxü̃ ya tümaãrü cori tüxna ãgaxe na meã nüxna tadauxü̃cèx rü meã oragu tanachibüexẽẽxü̃cèx i norü duü̃xü̃gü? ");
INSERT INTO tcaNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Rü tataãẽ ya yíxema coriarü duü̃xẽ ega ngẽxguma ínanguxgu i tümaãrü cori rü tüxü̃ íyanguexü̃gu na meãma ítanaxüxü̃ i ngẽma puracü i nagu tüxü̃ namuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","—Rü aixcüma pemaã nüxü̃ chixu rü ngẽma tümaãrü cori rü tá guxü̃ma i norü ngẽmaxü̃güarü dauruü̃xü̃ tá tüxü̃ nixĩxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","50","—Natürü ngẽxguma chi ngẽma coriarü duü̃xü̃ rü wüxi i yatü i chixexü̃ yixĩgu, rü chi nagu naxĩnügu na tãũtáma paxa ínanguxü̃ i norü cori, rü chi inaxügüãgu na chixri namuãxü̃ i namücügü i norü coriarü duü̃xü̃gü, rü chi ngãxẽxü̃tanügu naxãxgu na namaã nachibüxü̃cèx rü naxaxexü̃cèx, rü ngürüãchi ngẽma ngunexü̃ rü ngẽma ora i tama nagu ínanguxẽẽãxü̃gu rü tá ínangu i norü cori. ");
INSERT INTO tcaNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","—Rü poraãcüxüchima tá nanapoxcu i ngẽma norü duü̃xü̃, ñoma meã maxẽnetaxü̃ i duü̃xü̃güxü̃ napoxcuexü̃rüü̃. Rü nge̱ma tá narüdoxü rü nixü̃́xchapüta. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Rü ñanagürü ga Ngechuchu: —Pemaã tá nüxü̃ chixu i wüxi i ore na nawa nüxü̃ pecuáxü̃cèx i ñuxãcü tá duü̃xü̃güarü ãẽ̱xgacü na yiĩxü̃ ya Tupana i ngẽxguma nagu̱xgu i naãne. Rü iyexma ga 10 ga pacü ga ngĩrü daparinamaã ngĩgüarü petawa ĩcü na yaxümücügüãxü̃cèx ga guma yatü ga ingĩxchaü̃cü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","—Rü 5 ga yema pacü rü tama ixuãẽgü. Rü yema naĩ ga 5 ga pacü rü meãma ixuãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","—Rü yema tama uãẽgücü, rü yexguma ngĩrü daparina íyangegügu rü tama to ga ngĩrü queruchinu ta íyangegü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","—Natürü ga yema uãẽgücü rü to ga ngĩrü queruchinu ta íyangegü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","—Natürü ga guma yatü ga ingĩxchaü̃cü rü tama paxa ínangu. Rü düxwa ga yema pacügü rü ipee yerü iyaxtae. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","—Rü yexguma ngãxü̃cüüwa nanguxgu, rü yema pacügü nüxü̃ ixĩnüẽ ga wüxi ga naga ga ñaxü̃: “Domama nixĩ ya yima yatü ya ingĩxchaü̃cü. ¡Rü íperüdagü, rü ípeyadaugü!” ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","—Rü gu̱xcüma ga yema pacügü rü íirüdagü, rü iyamexẽẽgü ga ngĩrü daparinagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","—Rü yexguma ga yema 5 ga pacügü ga tama uãẽgücü rü ngĩgürügügü ngĩxü̃ ga yema pacügü ga uãẽgücü: “¡Íraxü̃ i perü queruchinu toxnata pexã, erü torü omügü rü nixogü!” ngĩgürügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","—Natürü ga yema pacügü ga uãẽgücü rü ngĩxü̃ ingãxü̃gü, rü ngĩgürügügü: “Taxucürüwa pexna ta taxã, erü ngẽxguma chi pexna ta taxãxgu rü tãũ chima ningu i toxcèx rü pexcèx. Rü ngẽmacèx narümemaẽ nixĩ i ngextá namaã ínataxegüxü̃wa pegüxü̃́ nawa pexĩ”, ngĩgürügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","—Natürü yexguma ga yema 5 ga pacügü ga tama uãẽgücü ngĩrü queruchinuwa naxĩyane, rü ínangu ga guma yatü ga ingĩxchaü̃cü. Rü ga yema pacügü ga uãẽgücü rü iyachocu nawa ga guma ĩ ga nawa iyangĩxü̃ne. Rü ñu̱xũchi narüwãxta ga ĩã̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","—Rü yemawena íingugü ga yema pacügü ga tama uãẽgücü, rü ngĩgürügügü: “¡Pa Corix, toxcèx yawãxna i ĩã̱x!” ngĩgürügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","—Natürü nüma ga cori, rü ngĩxü̃ nangãxü̃, rü ñanagürü: “Pemaã nüxü̃ chixu rü aixcüma tama pexü̃ chacuèx na texégü pixĩgüxü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Rü ñu̱xũchi ñanagürü ga Ngechuchu: —¡Ípexuãẽgü! Erü tama nüxü̃ pecuèx i ṯacü rü ngunexü̃ rü ṯacü rü ora tá íchangu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Rü ñanagürü ta ga Ngechuchu: —Rü ngẽma Tupana na duü̃xü̃güarü ãẽ̱xgacü na ixĩxü̃ rü ñoma wüxi ga yatü ga ixũãchichaü̃cü ga to ga nachiü̃ãnewa na naxũxü̃cèxrüü̃ nixĩ. Rü nüma ga guma yatü rü norü duü̃xü̃gücèx naca, rü nüxna ngĩxü̃ naxã ga dĩẽru na nüxü̃́ ngĩmaã nanguxü̃xü̃cèx rü ngĩmaã na ínapuracüexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","—Rü wüxi ga yema norü duü̃xü̃na ngĩxü̃ naxã ga 5000 tachinü ga dĩẽru. Rü yema tona ngĩxü̃ naxã ga 2000 tachinü ga dĩẽru. Rü yema tona ngĩxü̃ naxã ga 1000 tachinü ga dĩẽru. Rü yemaãcü nanangugü na ñuxãcü tá yema dĩẽrumaã napuracüexü̃ ga wüxichigü ga norü duü̃xü̃gü rü yemaãcü wüxichigüna ngĩxü̃ naxã ga yema dĩẽru. Rü ñu̱xũchi inaxũãchi ga yema cori na to ga nachiü̃ãnewa naxũxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","—Rü yema norü duü̃xü̃ ga 5000 tachinü ga dĩẽru ngĩxü̃ yaxuxü̃, rü ngĩmaã napuracü, rü naĩ ga 5000 tachinü ngĩmaã nayaxu. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","—Rü yexgumarüü̃ ta ga yema norü duü̃xü̃ ga 2000 tachinü ga dĩẽru ngĩxü̃ yaxuxü̃, rü ngĩmaã napuracü, rü naĩ ga 2000 tachinü ngĩmaã nayaxu. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","—Natürü ga yema norü duü̃xü̃ ga 1000 tachinü ga dĩẽru ngĩxü̃ yaxuxü̃, rü ngĩmaã ínixũ. Rü ngĩxü̃ nixaixmaü̃, rü yexma ngĩxü̃ natèx ga yema norü coriarü dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","—Rü nuxcüxürama nataegu ga yema duü̃xü̃güarü cori. Rü yexguma ínanguxgu rü inanaxügü ga norü duü̃xü̃gümaã na namexẽẽãxü̃ ga norü dĩẽruchiga. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","—Rü nüxĩra norü corixü̃tawa naxũ ga yema norü duü̃xü̃ ga 5000 tachinü ga dĩẽru ngĩxü̃ yaxuxü̃. Rü norü corina ngĩxü̃ naxã ga yema 5000 tachinü. Rü ngĩe̱tü ngĩxü̃ inaxã ga naĩ ga 5000 tachinü ga ngĩxü̃ nayaxucü ngĩmaã ga yema norü cori nüxna ngĩxü̃ ãcü ga dĩẽru. Rü ñanagürü norü corixü̃: “Dücèx Pa Corix, ñaã iyixĩ ga yema 5000 tachinü ga dĩẽru ga choxna ngĩxü̃ cuxãcü. Marü ngĩmaã chapuracü rü ngĩmaã cuxü̃́ ngĩxü̃ chayaxu i ñaã naĩ i 5000 tachinü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","—Rü norü cori rü ñanagürü nüxü̃: “Pa Chorü Duü̃xü̃x, wüxi i mexẽchixü̃ quixĩ, rü meãma cupuracü. Rü meã nüxna cudau ga yema noxre ga dĩẽru ga cuxna ngĩxü̃ chaxãcü, rü meãma ngĩmaã cupuracü. Rü ngẽmacèx i ñu̱xma rü tá rümumaẽcüna cuxü̃ chadauxẽẽ. ¡Rü ixücu i chopatawa rü ngĩxã tataãẽgü!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","—Rü yemawena ínangu ga yema to ga norü duü̃xü̃ ga 2000 tachinü ga dĩẽru ngĩxü̃ yaxuxü̃. Rü ñanagürü norü corixü̃: “Dücèx Pa Corix, ñaã iyixĩ ga yema 2000 tachinü ga dĩẽru ga choxna ngĩxü̃ cuxãcü. Marü ngĩmaã chapuracü rü ngĩmaã cuxü̃́ ngĩxü̃ chayaxu i naĩ i 2000 tachinü. Rü ñaã iyixĩ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","—Rü norü cori rü ñanagürü nüxü̃: “Pa Chorü Duü̃xü̃x, wüxi i mexẽchixü̃ quixĩ, rü meãma cupuracü. Rü meã nüxna cudau ga yema noxre ga dĩẽru ga cuxna ngĩxü̃ chaxãcü, rü meãma ngĩmaã cupuracü. Rü ngẽmacèx i ñu̱xmax rü tá rümumaẽcüna cuxü̃ chadauxẽẽ. ¡Rü ixücu i chopatawa rü ngĩxã tataãẽgü!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","—Natürü yexguma norü corixü̃tawa nanguxgu ga yema norü duü̃xü̃ ga 1000 tachinü ga dĩẽru ngĩxü̃ yaxuxü̃, rü ñanagürü norü corixü̃: “Dücèx Pa Corix, choma nüxü̃ chacuèx rü wüxi i yatü i aüxü̃ quixĩ. Rü cunayaxu i nanetüarü o i ngextá tama ícutoexü̃wa, rü cunabuxarü oõ̱x i nanetü i tama icutoxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","—Rü yemacèx chamuü̃. Rü waixü̃mügu ngĩxü̃ chixaixmaü̃ rü ngĩxü̃ ichatèx. Natürü ñaã iyixĩ i ngẽma curü dĩẽru”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Rü yexguma ga norü cori rü nanangãxü̃ rü ñanagürü: “Pa Chorü Duü̃xü̃x, wüxi i chixexü̃ rü oxü̃ i chorü duü̃xü̃ quixĩ. Rü cuma meãma nüxü̃ cucuèx rü ngextá tama íchatoexü̃wa rü chanayaxu i nanetüarü o, rü chanabuxarü oõ̱x i nanetü i tama ichatoxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","—Rü yemacèx narümemaẽ chi nixĩ ga bancugu choxü̃́ ngĩmaã na cunguxü̃xü̃ ga chorü dĩẽru na nge̱ma choxü̃́ ngĩxü̃ yamuxẽẽgüxü̃cèx, rü ngẽmaãcü mucü ngĩxü̃ na chayaxuxü̃cèx i ngẽxguma íchanguxgu”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","—Rü yexguma ga yema cori rü nanamu ga yema togü ga norü duü̃xü̃gü ga yéma yexmagüxü̃, rü ñanagürü nüxü̃: “¡Nüxna ngĩxü̃ peyau̱x i ngẽma dĩẽru, rü ngẽma yatü i 10,000 i dĩẽru nüxü̃́ ngẽxmaxü̃na ngĩxü̃ pexã! ");
INSERT INTO tcaNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","—Erü yíxema tüxü̃́ nangẽmèxcü rü yexera tá tüxna ngĩxü̃ taxã, rü ngẽmaãcü tá tüxü̃́ imuxũchi. Natürü yíxema tüxü̃́ natau̱xcü rü woo ngẽma noxre i tüxü̃́ ngẽmèxcü rü tá tüxna ngĩxü̃ tayaxu. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","—¡Rü yéama düxétüwa i poraãcü ínaxẽãnexü̃wa peyatá i ñaã chorü duü̃xü̃ i taxuwama mexü̃! Rü nge̱ma tá narüdoxü rü tá nixü̃́xchapüta”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Rü ñanagürü ga Ngechuchu: —Rü ngẽxguma wenaxãrü núma chaxũxgu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü chorü orearü ngeruü̃gü i daxũcü̱̃ã̱x rü tá choxü̃ naxümücügü. Rü ãẽ̱xgacü ya tacü tá chixĩ rü chorü tochica i mexẽchixü̃wa tá charüto. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","—Rü guxü̃ i nachiü̃ãnecü̱̃ã̱x i duü̃xü̃gü rü tá chopẽ́xegu nangutaquẽ́xegü. Rü choma rü tá chayadexechi ñoma wüxi i carneruarü dauruü̃ i norü carnerugü rü chibugü noxrüwama mugüxü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","—Rü ngẽma choxrü ixĩgüxü̃ rü chorü tügünecüwawa tá chanangẽxmagüxẽẽ. Rü ngẽma tama choxrü ixĩgüxü̃ rü chorü ṯoxwecüwawa tá chanangẽxmagüxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","—Rü ngẽxguma i choma i tá ãẽ̱xgacü ya tacü na chiĩxü̃ rü ñacharügü tá nüxü̃ i ngẽma chorü duü̃xü̃gü: “¡Nuã pexĩ i pema ya texé ya Chaunatü ya Tupana tüxü̃ rüngü̃xẽẽgüxe, rü penayaxu i ngẽma pechica i ngextá nüma ãẽ̱xgacü íyiĩxü̃wa! Yerü Chaunatü rü pexcèx nanamexẽẽ i ngẽma pechica ga yexguma tauta naãne naxü̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","—Rü ngẽmaãcü tá pemaã namecüma yerü yexguma chataiyagu rü pema rü choxü̃ pechibüxẽẽ. Rü yexguma chiṯawagu rü choxü̃ pexaxexẽẽ. Rü yexguma tama nüxü̃ pecuèxgu na texé chiĩxü̃ rü meã choxü̃ peyauxgü ga pepatawa. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","—Rü yexguma changexchirugu rü choxü̃ pexüxchiru. Rü yexguma chiḏaawegu rü choxü̃ perüngü̃xẽẽ. Rü yexguma poxcupataü̃wa chayexmagu rü choxü̃ ípeyadau”, ñacharügü tá nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","—Rü ngẽxguma i ngẽma duü̃xü̃gü i chadexü̃ rü ñanagürügü tá choxü̃: “Pa Corix, ¿ñuxgu ga cuxü̃ tadauxü̃ ga na cutaiyaxü̃ rü cuxü̃ tachibüxẽẽxü̃? ¿Rü ñuxgu ga cuxü̃ tadauxü̃ ga na quiṯaawaxü̃ rü cuxü̃ taxaxẽẽxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","—¿Rü ñuxgu ga tochixü̃wa cunguxü̃ rü meã cuxü̃ tayauxgüxü̃ ga woo tama cuxü̃ tacuèxgügu? ¿Rü ñuxgu ga cungexchiruxü̃ rü cuxü̃ taxüxchirugüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","—¿Rü ñuxgu ga cuxü̃ tadaugüxü̃ na quiḏaawexü̃ rü ẽ́xna poxcupataü̃wa cuyexmaxü̃ rü cuxü̃ ítayadaugüxü̃?” ñanagürügü tá choxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","—Rü choma na ãẽ̱xgacü ya tacü na chiĩxü̃, rü tá chanangãxü̃, rü ñacharügü tá: “Aixcüma pemaã nüxü̃ chixu rü yexguma nüxü̃ perüngü̃xẽẽgügu i ngẽma chorü duü̃xü̃ i yexeraãcü ngearü ngemaxü̃áxü̃, rü choxü̃ nixĩ ga perüngü̃xẽẽgüxü̃”, ñacharügü tá nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Rü ñu̱xũchi i choma na ãẽ̱xgacü ya tacü na chiĩxü̃, rü ñacharügü tá nüxü̃ i ngẽma tama chorü duü̃xü̃gü ixĩgüxü̃: “¡Choxna pixĩgachi i pema i perü chixexü̃cèx poxcuexe! ¡Rü nge̱ma pexĩ nawa ya yima üxü ya taguma ixoxü̃ne ya Tupana ímexẽe̱ne naxcèx i ngoxo i Chataná rü norü duü̃xü̃gü! ");
INSERT INTO tcaNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","—Yerü yexguma chataiyagu rü pema rü tama choxü̃ pechibüxẽẽ. Rü yexguma chiṯawagu rü tama choxü̃ pexaxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","—Rü yexguma tama nüxü̃ pecuèxgu na texé chiĩxü̃ rü tama meã choxü̃ peyauxgü ga pepatawa. Rü yexguma changexchirugu rü tama choxü̃ pexüxchirugü. Rü yexguma chiḏaawegu rü poxcupataü̃wa chayexmagu rü tama choxü̃ ípeyadaugü”, ñacharügü tá nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","—Rü ngẽxguma i nümagü i tama chorü duü̃xü̃gü ixĩgüxü̃, rü ñanagürügü tá choxü̃: “Pa Corix, ¿ñuxgu tochixü̃wa cungu rü tama meã cuxü̃ tayauxgü yerü tama cuxü̃ tacuèxgü? ¿Rü ñuxgu ga cuxü̃ tadaugüxü̃ ga na cutaiyaxü̃, rü ẽ́xna na quiṯaawaxü̃, rü ẽ́xna na cungexchiruxü̃, rü ẽ́xna quiḏaawexü̃, rü ẽ́xna poxcupataü̃wa na cuyexmaxü̃, rü tama cuxü̃ tarüngü̃xẽẽgüxü̃?” ñanagürügü tá choxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","—Rü choma na ãẽ̱xgacü ya tacü na chiĩxü̃, rü tá chanangãxü̃, rü ñacharügü tá nüxü̃: “Aixcüma pemaã nüxü̃ chixu rü yexguma tama nüxü̃ perüngü̃xẽẽgügu ga wüxi ga duü̃xü̃ ga yexeraãcü ngearü ngemaxü̃áxü̃, rü choxü̃ rü ta tama perüngü̃xẽẽgü”, ñacharügü tá nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","—Rü ñu̱xũchi i ngẽma duü̃xü̃gü i tama chorü duü̃xü̃gü ixĩgüxü̃ rü tá poxcu i taguma gúxü̃wa naxĩ. Natürü ngẽma duü̃xü̃gü i aixcüma meã chauxcèx maxẽxü̃ rü tá nanayauxgü i maxü̃ i taguma gúxü̃, —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Rü yexguma Ngechuchu nüxü̃ rüchauxgu ga yema orexü̃ na yaxuxü̃, rü ñanagürü norü ngúexü̃güxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Pema nüxü̃ pecuèx rü taxre i ngunexü̃ nataxu na nangõ̱xgüãxü̃cèx i ngẽma õna i Üpetüchigaarü petacèx naxügüxü̃. Rü ngẽxguma tá nixĩ i choxü̃ yayauxgüxü̃ i chorü uwanügü na curuchawa choxü̃ yapotagüxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Rü yexgumaü̃cüü ga paigüarü ãẽ̱xgacügü, rü ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃, rü Yudíugüarü ãẽ̱xgacügüerugü rü nangutaquẽ́xegü ga napatawa ga Caipá ga paigüarü ãẽ̱xgacü ixĩcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rü yéma nügümaã nanamexẽẽgü na Ngechuchuxü̃ nawomüxẽẽgüãcüma na yayauxgüãxü̃cèx rü na yamèxgüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Natürü nügümaã ñanagürügü: —Taxucürüwama i ñu̱xma petagu tayayauxgü, erü duü̃xü̃gü rü tá tamaã nanuẽ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Rü Ngechuchu rü Betániãwa nayexma napatawa ga Chimáũ ga rüchaxünecümaã naxugüãcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Rü Ngechuchucèx yéma iyaxũ ga wüxi ga ngecü ga yéma nangecü ga wüxiweü̃ ga pumara ga tatanüxü̃chixü̃ ga mexẽchicü ga butiyamaã ãchiü̃xü̃. Rü yexguma mechawa ínachibüyane ga Ngechuchu, rü ngĩma rü naẽrugu inaba ga yema pumara. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Rü yexguma yemaxü̃ nadaugügu ga Ngechuchuarü ngúexü̃gü, rü naãẽwa nangu̱xgü, rü inanaxügüe ga na ñagüxü̃. —¿Tü̱xcüü̃ ngẽxma inaxaiyaxü̃ i ngẽma pumara? ");
INSERT INTO tcaNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","—Rü narümemaẽ chi nixĩ i tatanüxü̃gu namaã itaxe, rü ñu̱xũchi ngẽma dĩẽrumaã nüxü̃ irüngü̃xẽẽ i ngẽma duü̃xü̃gü i ngearü ngẽmaxü̃ã̱xgüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Rü Ngechuchu nüxü̃ naxĩnü. Rü ñu̱xũchi ñanagürü norü ngúexü̃güxü̃: —¿Tü̱xcüü̃ ngĩxü̃ pechixewe i ngẽma nge? Erü ngẽma chomaã naxüxü̃ rü wüxi i mexü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","—Ngẽma ngearü ngẽmaxü̃ã̱xgüxü̃ rü guxü̃gutáma petanüwa nangẽxmagü. Natürü choma rü tãũtáma guxü̃gu petanüwa changẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","—Rü ngẽma chomaã naxüxü̃ i ñaã ngecü na chaxunegu nabaãxü̃ i ngẽma pumara i yixixü̃, rü ngẽmaãcü inaxü erü paxa tá chayu rü tá choxü̃ inatèxgü. Rü ngẽmacèx nixĩ i chaxunegu nabaãxü̃ i ngẽma pumara. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","—Rü aixcüma pemaã nüxü̃ chixu rü guxü̃ i naãnewa i ngextá duü̃xü̃gü nüxü̃ íixugügüxü̃wa i Tupanaãrü ore i mexü̃, rü ñaã ngecü chomaã üxü̃ rü tá ta nüxü̃ nixugügü. Rü ngẽmaãcü tá ngĩxna nacuèxãchie i duü̃xü̃gü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Rü ñu̱xũchi ga wüxi ga Ngechuchuarü ngúexü̃ ga Yuda ga Icariúte rü paigüarü ãẽ̱xgacügüxü̃tawa naxũ rü namaã nayarüdexa. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Rü Yuda rü ñanagürü nüxü̃: —¿Ñuxre tá choxü̃́ penaxütanüxü̃ i ngẽxguma pexü̃́ chanatauxchaxẽẽgu na Ngechuchuxü̃ piyauxgüxü̃cèx? —ñanagürü. Rü yexguma ga nümagü ga paigüarü ãẽ̱xgacügü rü 30 tachinü ga dĩẽrugu namaã naxuneta. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Rü yexgumama inanaxügü ga Yuda ga naxcèx na nadauxü̃ ga ñuxãcü nüxü̃́ na natauxchaxẽẽgüãxü̃ na Ngechuchuxü̃ yayauxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Rü nawa nangu ga ngunexü̃ ga nagu inaxügüxü̃ ga yema peta ga pãũ ga ngearü puxẽẽruü̃ã́xü̃ nagu nangõ̱xgüxü̃. Rü norü ngúexü̃gü rü Ngechuchucèx naxĩ, rü ñanagürügü nüxü̃: —¿Ngextá tá tanamexẽẽ i nachica i nawa nangõ̱xgüxü̃ i õna i Üpetüchigaarü petagu ingṍxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Rü nüma ga Ngechuchu rü ñanagürü nüxü̃: —¡Nge̱ma ĩãnewa pexĩ, rü yima yatü ya pemaã nüxü̃ chaxunetacüpatawa pexĩ! ¡Rü namaã nüxü̃ pixu rü ñapegügü: “Torü ngúexẽẽruü̃ rü ñanagürü: ‘Marü ningaicaxüchi na chayuxü̃ rü nuã cupatawa rü chorü ngúexü̃gümaã chanangupetüxẽẽchaü̃ i Üpetüchigaarü peta’,” ñaperügügü tá nüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Rü yéma naxĩ ga yema norü ngúexü̃gü. Rü yema Ngechuchu namaã nüxü̃ ixuxü̃rüü̃ nanaxügü. Rü nanamexẽẽgü ga yema õna ga Üpetüchigaarü petagu tá nangõ̱xgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Rü yexguma nachütagu rü yéma mechawa nachibü ga Ngechuchu namaã ga yema 12 ga norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Rü yexguma ínachibüeyane, rü Ngechuchu rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü wüxie i petanüwa tá tixĩ ya bexma chauechita choxü̃ íyaxuaxü̃xẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Rü yexguma ga nümagü ga norü ngúexü̃gü rü poraãcü nangechaü̃gü. Rü wüxichigü nüxna nicachigü, rü ñanagürügü: —Pa Corix, ¿choma ẽ́xna tá chiĩxü̃ ya yíxema cuxü̃ íyaxuaxü̃xẽ? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Rü nüma ga Ngechuchu nanangãxü̃ rü ñanagürü: —Ngẽma wüxi ya poratuwa namaã tá chachibüxü̃, rü ngẽma tá nixĩ i chauechita choxü̃ íyaxuaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","—Rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃ rü tá chayu ngẽxgumarüü̃ i Tupanaãrü ore i ümatüxü̃ nüxü̃ ixuxü̃rüü̃. Natürü wüxi i ngechaü̃xü̃chi nixĩ naxcèx i ngẽma yatü i choxü̃ íyaxuaxü̃xü̃. Rü narümemaẽ chi nixĩ ga noxtacüma tãũ chima na nabuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Rü nadexaãchi ga Yuda ga naẽchita íyaxuaxü̃xü̃, rü ñanagürü: —Pa Ngúexẽẽruü̃x, ¿tãũtáma choma nixĩ? —ñanagürü. Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Ngẽmáãcü cuma nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Rü yexguma ínachibüeyane rü Ngechuchu nanayaxu ga wüxi ga pãũ. Rü Tupanana moxẽ naxã, rü inanabücu, rü norü ngúexü̃güxü̃ nayanu. Rü ñanagürü: —Ñaã pãũ rü chaxunechiga nixĩ. Rü ¡penangṍ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Rü yemawena rü nanayaxu ga wüxi ga pochiyu ga binumaã ããcuxü̃. Rü yexgumarüü̃ ta Tupanana moxẽ naxcèx naxãxĩra, rü ñu̱xũchi norü ngúexü̃güna nanaxã, rü ñanagürü nüxü̃: —¡Rü guxãma i pema rü peyaxèü̱x ya daa binu! ");
INSERT INTO tcaNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","—Erü daa binu rü nachiga nixĩ ya chaugü ya muxü̃ma i duü̃xü̃gücèx tá ibacü na ngẽmaãcü Tupana nüxü̃́ nüxü̃ nangechaü̃xü̃cèx i norü pecadugü. Rü yimawa Tupana nanango̱xẽẽ na aixcüma yiĩxü̃ i norü uneta. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","—Rü pemaã nüxü̃ chixu rü tagutáma wena binu chayaxaxü ñu̱xmatáta Chaunatü ya Tupana ãẽ̱xgacü íixĩxü̃wa ngexwacaxü̃cü ya binu pemaã chayaxèü̱x —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Rü ñu̱xũchi nawiyaegü ga wüxi ga Tupanaãrü wiyaegu. Rü yemawena rü guma Mèxpǘne ga Oríbunecügu ãe̱ganewa naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Guxãma i pema rü tá choxü̃ ípetèxgü i ñoma i chütaxü̃gu. Erü Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Tá chayamèx ya carneruarü dauruü̃, rü tá nanaxüanemare i carnerugü”, ñanagürü i ngẽma ore. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","—Natürü ngẽxguma marü yuwa ícharüdaxguwena, rü tá chaxira pexü̃pa Gariréaanewa chaxũ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Rü yexguma ga Pedru rü nanangãxü̃ rü ñanagürü: —Rü woo guxü̃ma i togü cuxü̃ ítèxgu, natürü i chomax rü tãũtáma cuxü̃ íchatèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Rü Ngechuchu ñanagürü nüxü̃: —Aixcüma cumaã nüxü̃ chixu rü ñomatama i chütaxü̃gu rü naxü̃pa na otá ic̱axü̃, rü tomaẽ̱xpü̱xcüna tá cugü iquicu̱x na chorü duü̃xü̃ quiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Rü Pedru nanangãxü̃ rü ñanagürü: —Rü woo wüxigu cumaã chayu̱xgu rü tãũtáma chaugü ichicu̱x na curü duü̃xü̃ chiĩxü̃ —ñanagürü. Rü guxü̃ma ga togü ga norü ngúexü̃gü rü ta yema ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Rü Ngechuchu rü norü ngúexü̃gümaã nawa nangugü ga wüxi ga nachica ga Yechemanígu ãe̱gaxü̃. Rü Ngechuchu rü ñanagürü nüxü̃: —¡Nuã perütogü! Rü paxa yoxni yéa chayayumüxẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Rü Ngechuchu nügüwe nanagagü ga Pedru rü Zebedéu nanegü ga Chaü̃tiágu rü Cuáü̃. Rü Ngechuchucèx inaxügü ga na poraãcü nangechaü̃xü̃ rü naxi̱xãchiãẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Poraãcü changechaü̃ rü nagu charüxĩnü rü ngẽmamaã tá chayu. ¡Rü nuxa perücho i pemax, rü chauxrüü̃ ipedaue! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Rü yexguma ga Ngechuchu rü yéaxüra naxũ. Rü waixü̃müãnegu nanangücuchi. Rü nayumüxẽ rü ñanagürü: —Pa Chaunatüx, ngẽxguma cuma cunaxwèxegu, ¡rü nüxna choxü̃ ínanguxuchixẽẽ i ñaã ngúxü̃ i tá choxü̃ üpetüxü̃! Natürü chanaxwèxe i cuxrütama ngúchaü̃ cuxü rü tama i choxrü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Rü yemawena ga Ngechuchu rü nataegu ga yema norü ngúexü̃gü íyexmagüxü̃wa. Rü nüxü̃ inayangau ga na ínapeexü̃. Rü ñanagürü Pedruxü̃: —Pa Pedrux, ¿taxucürüwama ẽ́xna namaã peporae na chomaã ipedauexü̃, rü bai i wüxi i ora? ");
INSERT INTO tcaNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","—¡Rü pexuãẽgü rü Tupanana naxcèx pec̱a na pexü̃ nangü̃xẽẽxü̃cèx na tama choxü̃ ípetáxü̃cèx ega ngẽxguma ṯacü rü guxchaxü̃ pexü̃ üpetügu! Erü aixcüma peãẽwa rü ípememare, natürü pexene nixĩ ituraxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Rü yexguma rü wenaxãrü noxri ínayumüxẽxü̃cèx nataegu ga Ngechuchu. Rü wenaxãrü nayumüxẽ, rü ñanagürü: —Pa Chaunatüx, ngẽxguma tama cunaxwèxegu na nawa choxü̃ ícunguxuchixẽẽxü̃ i ñaã ngúxü̃ i tá chingexü̃, rü marü name i ngẽma cuma cunaxwèxexü̃ãcüma chomaã cunaxü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Rü ñu̱xũchi wenaxãrü norü ngúexü̃gü íyexmagüxü̃wa naxũ. Rü nüxü̃ inayangau ga na ínapeexü̃, yerü poraãcü nayaxtaexüchi. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Rü yéma nüxna nixũ, rü wenaxãrü nayayumüxẽ. Rü noxriãcütama nayumüxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Rü yemawena rü norü ngúexü̃gü íyexmagüxü̃wa naxũ. Rü ñanagürü nüxü̃: —¡Ñu̱xma waxi pepee rü iperüngü̃ẽ! Erü marü nawa nangu i ora na chorü uwanü choxü̃ iyauxgüxü̃ rü pecaduã̱xgüxü̃na choxü̃ namugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Ipechigü rü ngĩxã ítixĩ! Erü marü ñomatáma nixĩ i ngẽma choxü̃ íyaxuaxü̃xü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Rü yexguma íyadexayane ga Ngechuchu, rü ínangu ga Yuda ga norü ngúexü̃chirẽ́x ixĩxü̃. Rü nawe narüxĩ ga muxü̃ma ga duü̃xü̃gü ga taramaã rü naĩmaã ixãxnexü̃. Rü yema nixĩ ga duü̃xü̃gü ga paigüarü ãẽ̱xgacügü rü Yudíugarü ãẽ̱xgacügüerugü yéma mugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Rü ga Yuda ga ínaxuaxü̃xü̃ rü marü yema duü̃xü̃gümaã nanamexẽẽ, rü ñanagürü: —Ngẽma nüxü̃ chachúxuxü̃ tá nixĩ i Ngechuchu. Rü ngẽma tá nixĩ i piyauxgüxü̃ —ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Rü yexguma Ngechuchucèx nixũ, rü ñanagürü nüxü̃: —Nuxmaẽ Pa Ngúexẽẽruü̃x —ñanagürü. Rü ñu̱xũchi nüxü̃ nachúxu. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Pa Chomücüx, ¿ṯacüwa nuã cuxũ? —ñanagürü. Rü yexgumatama Ngechuchuxü̃ niyauxgü ga yema duü̃xü̃gü ga Yudawe rüxĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Rü wüxi ga Ngechuchumücü nanawẽ́xechi ga norü tara, rü paigüarü ãẽ̱xgacüarü duü̃xü̃xü̃ ínadaechinü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Rü yexguma ga Ngechuchu rü ñanagürü: —¡Naxchiü̃gu yaxücuchi i curü tara! Erü guxãma ya yíxema taramaã nuẽxẽ, rü taragu tátama tayue. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","—¿Tama ẽ́xna nüxü̃ cucuèx rü ngẽxguma chi choma chanaxwèxegu, rü Chaunatüna chi naxcèx chaca na choxü̃́ núma namugüãxü̃cèx i muxü̃ma i norü orearü ngeruü̃gü i daxũcü̱̃ã̱x na choxü̃ yanangü̃xẽẽgüxü̃cèx? ");
INSERT INTO tcaNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","—Natürü ngẽxguma chi ngẽma chaxü̱xgu, rü ¿ñuxãcü chi ningu i Tupanaãrü ore i ümatüxü̃ i nüxü̃ ixuxü̃ na choma rü tá chayuxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃ ga yema duü̃xü̃gü: —¿Tü̱xcüü̃ taragü rü naĩxmenèxãgümaã chauxcèx nuã pexĩ na choxü̃ peyarüyauxgüxü̃cèx ñoma wüxi i ngĩ́tèxáxü̃ chiĩxü̃rüü̃? Rü guxü̃ ga ngunexü̃gu rü tupauca ga taxü̃newa changu̱xẽẽtae natürü taguma yexma choxü̃ piyauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","—Natürü guxü̃ma i ñaã ñu̱xma ngupetüxü̃, rü ngẽmaãcü nangupetü na yanguxü̃cèx i Tupanaãrü ore ga nuxcümaü̃güxü̃ ga norü orearü uruü̃gü ümatügüxü̃ —ñanagürü. Rü yexguma ga guxü̃ma ga norü ngúexü̃gü rü nüxna nibuxmü. Rü nüxĩcatama yéma nanatèxgü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Rü Caipá ga paigüarü ãẽ̱xgacüxü̃tawa Ngechuchuxü̃ nagagü ga yema duü̃xü̃gü ga yayauxgüxü̃. Rü yexma nixĩ ga nangutaquẽ́xegüxü̃ ga ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃ rü Yudíugüarü ãẽ̱xgacügüerugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Natürü ga Pedru rü yaxü̃gu nawe nixãchigü ñu̱xmata paigüarü ãẽ̱xgacü ga Caipáxü̃tawa nangu. Rü purichíagü ga tupaucaarü dauruü̃gümaã yéma ĩã̱xtüwa narüto, yerü nüxü̃ nadauxchaü̃ ga ṯacü tá Ngechuchumaã na naxüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Rü ga paigüarü ãẽ̱xgacügü rü guxü̃ma ga Yudíugüarü ãẽ̱xgacügüerugü rü naxcèx nadaugü ga wüxi ga ore ga doramare ixĩxü̃ na yemamaã Ngechuchuxü̃ ínaxuaxü̃güxü̃cèx na yamèxgüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Natürü woo muxü̃ma ga duü̃xü̃gü doraxü̃mare nachigaxü̃ yéma yarüxugüe, natürü taxuxü̃ma ga chixexü̃ inayangaugü ga naxcèx tá yamèxgüãxü̃. Rü düxwa yéma naxĩ ga taxre ga yatügü ga doraxü̃mare yéma yarüxugüxü̃. Rü ñanagürügü: —Toma nüxü̃ taxĩnüẽ i ñaã yatü rü ñanagürü: “Tá nagu chapogü ya daa tupauca ya taxü̃ne ya Tupanaãrü, rü tomaẽ̱xpü̱x i ngunexü̃gu tá wenaxãrü íchanadaxẽẽ”, ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Rü yexguma ga paigüarü ãẽ̱xgacü ga Caipá rü inachi, rü ñanagürü Ngechuchuxü̃: —¿Rü ṯacümaã cunangãxü̃ i ñu̱xmax? ¿Rü ñuxũ ñaxü̃ yiĩxü̃ i ngẽma cuchiga i nüxü̃ yaxugügüxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Natürü ga Ngechuchu rü nangeèxmare. Rü yemacèx ga paigüarü ãẽ̱xgacü ga Caipá rü ñanagürü nüxü̃: —Tupana ya Maxü̃cüégagu chanaxwèxe i aixcüma tomaã nüxü̃ quixu na texé quiĩxü̃. ¿Rü cuma ẽ́xna i Cristu ya Tupana Nane quiĩxü̃, rü ẽ́xna tama? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Ngü̃, rü ngẽma nüxü̃ quixuxü̃ chixĩ. Rü pemaã nüxü̃ chixu rü tá choxü̃ pedaugü i ngẽxguma Chaunatü ya Poracüxü̃tawa charüto̱xgu rü ngẽxguma caixanexü̃gu wenaxãrü núma chaxũxgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Rü yexguma ga paigüarü ãẽ̱xgacü rü norü numaã nügüchirugu nagaugü. Rü ñanagürü: —Rü ñaã yatü rü ṯacü Tupanamaã nixugü. Rü taxucèxma marü tanaxwèxe i ñu̱xma i to i ore na napoxcuxü̃cèx i ñaã yatü. Rü pematama marü nüxü̃ pexĩnüẽ na ñuxãcü chixexü̃maã na yadexaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","—¿Ñuxũ ñapegüxü̃ i pemax? —ñanagürü. Rü nümagü ga togü ga ãẽ̱xgacügü rü nanangãxü̃gü rü ñanagürügü: —Ngẽmáãcü chixexü̃ naxü. Rü name nixĩ i noxtacüma nayu —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Rü yexguma rü Ngechuchuchiwewa nac̱uaixgüe. Rü nüxna nanac̱uaixcagü. Rü togü rü nanapegüchiwegü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Rü ñanagürügü: —Pa Cristux, ¡nüxü̃ nacuèx na texé cuxü̃ pegüchiwegüxü̃ rü cuxna nac̱uaixcagüxü̃! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Rü yoxni ga Pedru rü ãẽ̱xgacüpataèxtüwa narüto. Rü wüxi ga pacü ga ãẽ̱xgacüarü duü̃xü̃ ixĩcü, rü Pedrucèx iyaxũ. Rü ngĩgürügü nüxü̃: —Cuma rü ta namücü quixĩ i ngẽma Ngechuchu i Gariréaanecü̱̃ã̱x —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Natürü ga Pedru rü guxü̃ ga yema duü̃xü̃güpẽ́xewa rü tama nügü nixu na Ngechuchuarü duü̃xü̃ yiĩxü̃, rü ñanagürü: —Choma rü tama nüxü̃ chacuèx i ṯacüchiga nixĩ i ngẽma nüxü̃ quixuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Rü yexguma marü yema ĩpataèxtüarü ĩã̱xwa ínaxũũxgu ga Pedru, rü naĩ ga pacü nüxü̃ idau. Rü ngĩgürügü namaã ga yema duü̃xü̃gü ga yéma yexmagüxü̃: —Ñaã yatü rü Ngechuchu ya Nacharétucü̱̃ã̱xmücü nixĩ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Natürü ga Pedru rü wenaxãrü tama nügü nixu na Ngechuchuarü duü̃xü̃ yiĩxü̃. Rü ñanagürü: —Choma rü tama nüxü̃ chacuèx i ngẽma yatü. Rü Tupana choxü̃ poxcux ega tama aixcüma yixĩgu i chorü ore —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Rü yixcamaxü̃ra rü yema duü̃xü̃gü ga yéma yexmagüxü̃ rü Pedrucèx naxĩ, rü ñanagürügü nüxü̃: —Aixcüma nixĩ i cuma rü ta rü ngẽma Ngechuchutanüxü̃ quiĩxü̃, erü wüxi i Gariréaanecü̱̃ã̱x idexaxü̃rüü̃ quidexa —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Rü nüma ga Pedru rü poraãcü nügü nixã, rü ñanagürü nüxü̃: —Rü aixcüma tama nüxü̃ chacuèx i ngẽma yatü. Rü ngẽxguma doraxü̃ chixuxgu rü Tupana choxü̃ poxcux —ñanagürü. Rü yexgumatama nica ga otá. ");
INSERT INTO tcaNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Rü nüma ga Pedru rü yexguma nüxna nacuèxãchi ga yema ore ga Ngechuchu namaã nüxü̃ ixuxü̃ ga ñaxü̃: “Rü naxü̃pa na otá ic̱axü̃, rü cuma rü tomaẽ̱xpü̱xcüna cugü tá quixã na chorü duü̃xü̃ quiĩxü̃”, ñaxü̃. Rü yéma ínaxũxũ ga Pedru rü poraãcüxüchima naxaxu. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Rü yexguma yangunegu rü guxü̃ma ga paigüarü ãẽ̱xgacügü rü Yudíugüarü ãẽ̱xgacügüerugü, rü nügümaã nanamexẽẽgü na ñuxãcü Ngechuchuxü̃ yamèxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Rü nayanèĩ̱xgüchacüügü rü yemaãcü ãẽ̱xgacü ga Piratuxü̃tawa nanagagü. Piratu nixĩ ga Dumacü̱̃ã̱x ga ãẽ̱xgacü ga Yudéaanemaã icuácü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Rü nüma ga Yuda ga Ngechuchuxü̃ íyaxuaxü̃xü̃ rü nüxü̃ nadau ga Ngechuchuxü̃ na napoxcuexü̃. Rü poraãcü nagu narüxĩnü ga yema chixexü̃ ga nümatama naxüxü̃. Rü yéma naxũ naxü̃tawa ga yema paigüarü ãẽ̱xgacügü rü yema Yudíugüarü ãẽ̱xgacügüerugü. Rü ngĩxü̃ nayataeguxẽẽ ga yema 30 tachinü ga dĩẽru ga nüxna ngĩxü̃ naxãgücü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Rü ñanagürü nüxü̃: —Choma rü marü chixexü̃ chaxü, erü naẽchita íchayaxuaxü̃ i wüxi i yatü i taxuü̃ma i chixexü̃ üxü̃, rü ñu̱xma rü tá ngẽmagagu nayu —ñanagürü. Natürü nümagü ga ãẽ̱xgacügü rü nanangãxü̃gü, rü ñanagürügü: —Toma rü tama nüxü̃ tacuáxchaü̃ i ngẽma. Cugagutama nixĩ, rü cuma i nüxü̃ cucuáxü̃ na ñuxãcü cugümaã cunamexẽẽxü̃ i ngẽma —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Rü yexguma ga Yuda rü yexma tupauca ga taxü̃nechiãgu ngĩxü̃ nawotanü ga yema dĩẽru. Rü ñu̱xũchi ínixũ rü nügü nayawẽxnaxã. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Rü ga paigüarü ãẽ̱xgacügü rü ngĩxü̃ nade ga yema dĩẽru. Rü ñanagürügü: —Taxucürüwa tupauca ya taxü̃neãrü dĩẽruchiü̃gu ngĩxü̃ tanu i ñaã dĩẽru, erü ngẽmamaã tanaxütanü i ngẽma yatü i tá yuxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Rü ñu̱xũchi nügümaã nanamexẽẽgü na yema dĩẽrumaã naxcèx nataxegüxü̃cèx ga wüxi ga naãne ga waixü̃mü ga üwechixü̃ nawa nayauxgüxü̃. Rü yema naãnecèx nataxegü na nüxü̃́ nayexmaxü̃cèx ga nachica ga ngexta na natèxgüãxü̃cèx ga yema duü̃xü̃gü ga togü ga nachiü̃ãnecü̱̃ã̱x ixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rü ngẽmacèx i ñu̱xma rü ta i ngẽma naãne rü Nagüchitaü̃gu naxãe̱ga. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Rü yemaãcü ningu ga Tupanaãrü ore ga nuxcümaü̃cü ga norü orearü uruü̃ ga Yeremíã ümatüxü̃ ga ñaxü̃: “Rü nümagü ngĩxü̃ nade ga yema 30 tachinü ga dĩẽru ga Cristutanü Yudíugü ngĩxü̃ ixãgücü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Rü yema dĩẽrumaã naxcèx nataxegü ga wüxi ga naãne ga waixü̃mü ga üwechixü̃ nawa nayauxgüxü̃, yema Cori ga Tupana chomaã nüxü̃ ixuxü̃rüü̃”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Rü ãẽ̱xgacü ga Piratuxü̃tawa Ngechuchuxü̃ nagagü. Rü nüma ga Piratu rü Ngechuchuna naca, rü ñanagürü: —¿Cuma quiĩxü̃ i Yudíugüarü ãẽ̱xgacü ya tacü? —ñanagürü. Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Ngü̃, rü ngẽma nüxü̃ quixuxü̃ chixĩ i chomax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Rü Ngechuchuxü̃ ínaxuaxü̃gü ga paigüarü ãẽ̱xgacügü rü Yudíugüarü ãẽ̱xgacügüerugü. Natürü ga Ngechuchu rü taxuxü̃maãma nanangãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Rü yexguma ga Piratu rü ñanagürü: —¿Tama ẽ́xna nüxü̃ cuxĩnü i ngẽma ore i namaã cuxü̃ ínaxuaxü̃güxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Natürü ga Ngechuchu rü taxuxü̃maãma nanangãxü̃. Rü yemacèx poraãcü nabèi̱xãchiãẽ ga ãẽ̱xgacü ga Piratu. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Rü guxü̃guma ga yema Üpetüchigaarü petagu, rü Piratu ínananguxuchixẽẽxü̃ ga wüxi ga poxcuxü̃ ga duü̃xü̃gü naxcèx ícagüxü̃, yerü yema nixĩ ga nacüma. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Rü yéma nayexma ga wüxi ga poxcuxü̃ ga guxü̃ ga duü̃xü̃gü meã nüxü̃ cuáxü̃. Rü Barabá nixĩ ga nae̱ga. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Rü yexguma yéma nangutaquẽ́xegügu ga duü̃xü̃gü, rü Piratu nüxna naca, rü ñanagürü: —¿Rü ngexü̃rüxüxü̃ i penaxw̱aexü̃ na íchananguxuchixẽẽxü̃? ¿Penaxwèxexü̃ na Barabáxü̃ íchananguxuchixẽẽxü̃ rü ẽ́xna Ngechuchu i Cristumaã naxugüxü̃xü̃ íchananguxuchixẽẽxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Rü yema ñanagürü ga Piratu yerü nüxü̃ nacuèx na Ngechuchuchi naxaiexü̃ ga Yudíugüarü ãẽ̱xgacügü, rü yemacèx nixĩ ga naxü̃tawa nagagüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Rü yexguma norü tochicawa nato̱xgu ga Piratu, rü naxmèx yéma imuga, rü ngĩgürügü: —Tama name i cunapoxcu i ngẽma yatü i taxuü̃ma i chixexü̃ üxü̃. Yerü nagagu ĩne chütacü rü poraãcü chachixenegü —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Natürü yema paigüarü ãẽ̱xgacügü rü Yudíugüarü ãẽ̱xgacügüerugü, rü duü̃xü̃güxü̃ naxucu̱xẽgü na naxcèx ínacagüxü̃cèx na Barabáxü̃ ínanguxuchixẽẽxü̃cèx rü Ngechuchuxü̃ na nayuxẽẽgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Rü ãẽ̱xgacü ga Piratu rü wenaxãrü duü̃xü̃güna naca, rü ñanagürü: —¿Ngẽxü̃rüüxü̃ i ngẽma taxrewa i pema penaxwèxexü̃ na íchananguxuchixẽẽxü̃? —ñanagürü. Rü nümagü ga duü̃xü̃gü nanangãxü̃gü, rü ñanagürügü: —Tanaxwèxe i Barabáxü̃ ícunguxuchixẽẽ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Rü yexguma ga ãẽ̱xgacü ga Piratu rü nüxna naca, rü ñanagürü: —¿Ṯacü tá chaxüxü̃ namaã i ngẽma Ngechuchu i Cristugu ãe̱gaxü̃? —ñanagürü. Rü guxü̃ma ga duü̃xü̃gü rü nanangãxü̃gü, rü ñanagürügü: —¡Curuchawa yapota! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Rü yexguma ga Piratu rü ñanagürü nüxü̃: —¿Natürü ṯacü rü chixexü̃ naxü? —ñanagürü. Natürü ga nümagü ga duü̃xü̃gü rü wenaxãrü tagaãcü ñanagürügü: —¡Curuchawa yapota! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Rü yexguma Piratu nüxü̃ dèu̱xgu ga marü taxucürüwama Ngechuchuxü̃ na ínanguxuchixẽẽe̱gaxü̃, yerü ga duü̃xü̃gü rü marü nanaxi̱xãchiãẽgüchaü̃, rü yemacèx wüxi ga norü duü̃xü̃xü̃ namu ga dexá naxü̃tawa na tanangexü̃cèx. Rü nügü nayauxmẽ́x ga Piratu napẽ́xewa ga guxü̃ma ga yema duü̃xü̃gü. Rü ñanagürü: —Tama chaugagu tá nixĩ i na nayuxü̃ i ñaã yatü i taxuü̃ma i chixexü̃ üxü̃, rü pegagu tátama nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Rü guxü̃ma ga yema duü̃xü̃gü nanangãxü̃gü, rü ñanagürügü: —Togagu rü toxocügügagu tá nixĩ i nayuxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Rü yexguma ga Piratu rü Barabáxü̃ ínanguxuchixẽẽ. Rü ñu̱xũchi norü churaragüxü̃ namu na Ngechuchuxü̃ nac̱uaixgüxü̃cèx, rü yemawena curuchawa na yanapotagüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Rü ñu̱xũchi ga yema churaragü rü Piratupataarü aixepewa Ngechuchuxü̃ nagagü. Rü yexma Ngechuchuxü̃tagu nanangutaquẽ́xexẽẽ ga guxü̃ma ga churaragü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Rü ñu̱xũchi Ngechuchuxü̃ ínacu̱xuchigü, rü wüxi ga máxü̃ ga naxchiru ga dauxü̃gu nayacu̱xẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Rü naẽruwa nayangèxcuchigü ga wüxi ga boxü̃ ga chuchuxü̃wa naxügüxü̃. Rü wüxi ga naĩxmenèxãxãcüxü̃ nüxü̃ nayayauxãchixẽẽ ga norü tügünemẽ́xẽwa. Rü ñu̱xũchi napẽ́xegu nacaxã́pü̱xügü, rü nüxü̃ nacugüe, rü ñanagürügü: —¡Namaü̃x ya Yudíugüarü Ãẽ̱xgacü ya Tacüx! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Rü nüxna nac̱uaixgüe. Rü nüxna nanayauxgü ga guma naĩxmenèxãxãcü, rü naẽruwa namaã nanac̱uaixcagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Rü yexguma nüxü̃ nacugüeguwena rü ínanacu̱xuchigü ga yema naxchiru ga daucharaxü̃. Rü wenaxãrü naxchirugutama nayacu̱xẽẽgü. Rü ñu̱xũchi nayagagü na curuchawa yanapotagüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Rü yexguma yéma inaxĩãchigu, rü nüxü̃ nadaugü ga wüxi ga yatü ga Chirénecü̱̃ã̱x ga Chimáũgu ãe̱gacü. Rü guma yatüxü̃ ngĩxü̃ iningexẽẽgü ga Ngechuchuarü curucha. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Rü nawa nangugü ga wüxi ga nachica ga Górgutagu ãe̱gaxü̃. Rü ngẽma nae̱ga rü Duü̃xẽẽruchinèxã ñaxü̃chiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Rü nüxna nanaxãgü ga binu ga ngúxü̃ãrü naãchixẽẽruü̃maã ãe̱xü̃cü na yaxaxãxü̃cèx. Rü Ngechuchu nüxü̃ naxaxneta, natürü tama nayaxaxü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Rü yexguma marü curuchawa yapotagüãxguwena rü ga churaragü rü nanade ga Ngechuchuchiru. Rü ñu̱xũchi wüxi ga dĩẽru ngĩxü̃ nañanagügü na yemawa nüxü̃ nacuèxgüxü̃cèx na ṯacü tá nayaxuxü̃ ga wüxichigü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Rü ñu̱xũchi yéma narütogü ga churaragü na Ngechuchuna yéma nadaugüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Rü norü curuchatapẽ́xewa nayapocuchi ga wüxi ga mürapewa ga ãe̱gatachinüxü̃ ga nüxü̃ ixuxü̃ ga ṯacücèx Ngechuchuxü̃ curuchawa na yapotagüxü̃. Rü ñanagürü: “Ñaã nixĩ i Ngechuchu i Yudíugüarü Ãẽ̱xgacü ya Tacü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Rü yexgumarüü̃ ta curuchawa nayapotagü ga taxre ga máẽtagüxü̃. Rü wüxi rü Ngechuchuarü tügünecüwawa naxü, rü to ga norü ṯoxwecüwawa. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Rü yema duü̃xü̃gü ga yéma chopetüxü̃, rü Ngechuchumaã naguxchigagü, rü nanexãẽrugüãcüma ñanagürügü: —Dücèx, cuma cunangutaü̃xẽẽe̱ga ya tupauca ya taxü̃ne, rü tomaẽ̱xpü̱x i ngunexü̃gu wenaxãrü ícunadaxẽẽe̱ga. ¡Cugütama namaxẽẽ i ñu̱xmax! Rü ngẽxguma chi aixcüma Tupana Nane quixĩgu, rü ¡írüxĩ i curuchawa! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Rü yexgumarüü̃ ta Ngechuchuxü̃ nacugüecüraxü̃ ga paigüarü ãẽ̱xgacügü, rü ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃, rü Parichéugü, rü Yudíugüarü ãẽ̱xgacügüerugü. Rü nügümaã ñanagürügü: ");
INSERT INTO tcaNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Rü nüma rü togüxü̃ namaxẽxẽẽ natürü i ñu̱xma rü tama nüxü̃ nacuèx na nügütama namaxẽẽxü̃. Rü ngẽxguma chi aixcüma Yudíugüarü ãẽ̱xgacü yixĩgu, ¡rü ñu̱xma rü ínaxĩ̱x i curuchawa na nüxü̃́ yaxõgüxü̃cèx! ");
INSERT INTO tcaNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","—Rü nüma nagu naxĩnügu rü Tupana tá nüxü̃ narüngü̃xẽẽ. Ẽcü, ñu̱xma rü Tupana nüxü̃ rüngü̃xẽẽ̱x ega aixcüma nüxü̃ nangü̃xẽẽchaü̃gu. ¿Tama ẽ́xna nümatama tamaã nüxü̃ yaxuxü̃ na Tupana Nane yiĩxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Rü woo ga yema máẽtagüxü̃ ga naxrüü̃ curuchawa ipotagüxü̃, rü namaã naguxchigagü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Rü yexguma rü guxü̃ ga naãnewa naxẽãne. Rü tocuchigu inaxügü ga yema ñu̱xmata tomaẽ̱xpü̱xarü orawa nangu ga yáuanecü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Rü yema tomaẽ̱xpü̱xarü oragu nixĩ ga Ngechuchu ga tagaãcü aita naxüxü̃, rü ñaxü̃: —Erí, Erí, ¿damá chabátani? —ñanagürü. Rü ngẽma rü ñaxü̃chiga nixĩ: “Pa Chorü Tupana, Pa Chorü Tupanax, ¿tü̱xcüü̃ choxna quixũgachixü̃?” ñaxü̃chiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Rü nümaxü̃ ga duü̃xü̃gü ga yéma yexmagüxü̃ rü nüxü̃ naxĩnüẽ, rü ñanagürügü: —Ñaã yatü rü nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Eríacèx naca —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Rü yexgumatama rü wüxi ga yema duü̃xü̃gü ga yéma yexmagüxü̃ rü inañaãchi rü Ngechuchuxü̃tawa nanange ga wüxi ga tüaxmü ga binu ga marü ngúchièxüchicümaã yawaixẽẽxü̃. Rü wüxi ga dexnewa nayanèĩ̱x. Rü ñu̱xũchi Ngechuchuèxgu nanawẽ́x na nüxü̃ natuxuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Natürü ga yema togü ga duü̃xü̃gü ga yéma yexmagüxü̃ rü ñanagürügü: —Yixrüma. Rü ngĩxã itarüdaunü ngoxita Ería nuã ũ na nüxü̃ yanangü̃xẽẽxü̃cèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Rü wenaxãrü tagaãcü aita naxü ga Ngechuchu, rü ñu̱xũchi nayu. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Rü yexgumatama ga tupauca ga taxü̃neãrü tüyemachiãxü̃ rü taxregu narügaute. Rü daxũwa inanaxügü ga na nagautexü̃ rü ñu̱xmata ñaxtüwa nangu. Rü naxĩã̱xãchiane, rü narüngǘxtegü ga nutagü ga itacü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Rü yuetamaü̃gü rü ningenagü. Rü wena namaxẽ ga muxü̃ma ga duü̃xü̃gü ga yuechiréxü̃ ga Tupanaãxü̃́ yaxõgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Rü yexguma Ngechuchu wena maü̃xguwena, rü naxmaü̃wa ínachoxü̃ ga yema duü̃xü̃gü ga wena maxẽxü̃. Rü Yerucharéü̃wa naxĩ. Rü muxü̃ma ga duü̃xü̃gü nüxü̃ nadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Rü yema churaragüarü ãẽ̱xgacü rü norü churaragü ga Ngechuchuna ídaugüxü̃, rü nüxü̃ nadaugü ga na naxĩã̱xãchianexü̃ rü guxü̃ma ga yema ngupetüxü̃. Rü yexguma rü poraãcü namuü̃ẽ, rü ñanagürügü: —Aixcüma nixĩ ya daa yatü i Tupana Nane na yiĩxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Rü iyexmagü ga mucüma ga ngecügü ga yéma yaxü̃wa nüxü̃ rüdaunücü. Rü yema ngecügü iyixĩ ga Ngechuchuxü̃ íixümücügücü rü nüxü̃ rüngü̃xẽẽgücü ga yexguma Gariréaanewa ne naxũxgu. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Rü yema ngecügütanüwa iyexma ga María ga Magadácü̱̃ã̱x, rü María ga Chaü̃tiágu rü Yúche naẽ, rü Zebedéu namèx ga Chaü̃tiágu rü Cuáü̃ naẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rü yexguma marü nachütachaü̃gu, rü yéma nangu ga wüxi ga yatü ga Arimatéacü̱̃ã̱x ga taarü dĩẽruã́cü ga Yúchegu ãe̱gacü. Rü nüma rü ta Ngechuchuaxü̃́ nayaxõ. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rü nüma rü Piratuna nayaca rü ngoxita name na nayauxãxü̃ ga Ngechuchuxü̃ne ga curuchawa. Rü Piratu norü churaragüxü̃ namu na nüxna naxãgüãxü̃cèx ga Ngechuchuxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Rü Yúche nanayaxu ga Ngechuchuxü̃ne ga curuchawa. Rü wüxi ga naxchápenüü̃ ga ngẽmataxü̃maã nananuque. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Rü yema naxmaü̃ ga yexwacaxüxü̃ ga Yúche nügücèxtama duü̃xü̃güxü̃ yacaxmaxẽẽxü̃ ga nuta ga tacüarü mèxpǘxü̃wa yexmaxü̃gu nayaxücuchi ga Ngechuchuxü̃ne. Rü ñu̱xũchi nanangũxtaü̃ namaã ga wüxi ga nuta ga taxüchicü. Rü yemawena rü ínixũ. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Rü yéma Ngechuchumaü̃ãrü to̱xmèxtawa irütogü ga María ga Magadácü̱̃ã̱x rü naĩ ga María. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Rü moxü̃ãcü ga ngü̃xchigaarü ngunexü̃gu rü paigüarü ãẽ̱xgacügü rü Parichéugü rü yéma Piratuxü̃tawa naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Rü ñanagürügü nüxü̃: —Pa Corix, nüxna tacuèxãchie ga yema yatü ga Ngechuchu ga idoratèxáxü̃ rü yexguma namaü̃xgu rü ñanagürü tomaã: “Ngẽxguma chayu̱xgu rü tomaẽ̱xpü̱x i ngunexü̃guwena rü wena táxarü ícharüda”, ñanagürü tomaã. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","—Rü ngẽmacèx tanaxwèxe i churaragü nge̱ma cumugü na nüxna yadaugüxü̃cèx i ngẽma naxmaü̃ ñu̱xmatáta tomaẽ̱xpü̱x i ngunexü̃wa nangu na tama chütacü nge̱ma naxĩxü̃cèx i norü ngúexü̃gü na yayauxgüãxü̃cèx i naxü̃ne rü ñu̱xũchi duü̃xü̃gümaã nüxü̃ na yaxugüxü̃cèx na marü wena namaxü̃xü̃. Erü ngẽxguma chi ngẽmaãcü naxüpetügu, rü noxriarü yexera tá nixĩ na duü̃xü̃güxü̃ nawomüxẽẽxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Rü Piratu ñanagürü nüxü̃: —Ngẽãgü nixĩ i churaragü i pexcèx. ¡Ẽcü nge̱ma namaã pexĩ na meãma pema penaxwèxexü̃ãcüma nüxna pedaugüxü̃cèx i naxmaü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Rü yema churaragümaã yéma naxĩ, rü meãma nayataixẽẽgü ga guma nuta ga Ngechuchumaxü̃ namaã rüngũxtaü̃cü. Rü nanaxüarü cuèxruü̃ã̱xgü na taxúema naẽchita ínaxügachigüxü̃cèx ga guma nuta. Rü ñu̱xũchi yexma nanamugü ga churaragü na nüxna nadaugüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Rü sabaduarü ngunexü̃guwena ga yüxüarü pèxmama, rü yéma naxmaü̃wa íiyadaugü ga María ga Magadácü̱̃ã̱x rü naĩ ga María. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Rü ngürüãchi poraãcü naxĩã̱xãchiane, yerü wüxi ga daxũcü̱̃ã̱x ga Cori ga Tupanaãrü orearü ngeruü̃ ínarüxĩ, rü naxmaü̃wa nangu rü ínanangũxgachi ga guma nuta ga namaã nangũxtaü̃cü ga yema naxmaü̃. Rü ñu̱xũchi guma nutaétüwa narüto. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rü yema orearü ngeruü̃ rü wüxi ga bèi̱xbẽ́xanexü̃rüü̃ niy̱auracüü. Rü nacómüxü̃chi ga naxchiru. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Rü yexguma yemaxü̃ nadaugügu ga churaragü rü norü muü̃maã nidu̱ru̱xe, rü yexma niyuãchitanü. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Rü yexguma ga yema orearü ngeruü̃, rü ñanagürü ngĩxü̃ ga yema ngecügü: —¡Tãxṹ i pemuü̃ẽxü̃! Choma nüxü̃ chacuèx rü naxcèx pedaugü ya Ngechuchu ga guma curuchawa yapotagüãcü. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nataxuma i nuã, erü marü wena namaxü̃, yema nüma ü̃pa pemaã nüxü̃ yaxuxü̃rüü̃. ¡Rü nuã pexĩ, rü ípeyadèu̱x i naxmaü̃ i ngẽma inaxügüãxü̃wa ga naxü̃ne! ");
INSERT INTO tcaNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","¡Rü paxa ípixĩ, rü norü ngúexü̃gümaã nüxü̃ peyarüxugüe rü marü ínarüda rü wena namaxü̃ ya Ngechuchu! Rü ñu̱xma rü marü pexü̃pa nüxĩra Gariréaanewa naxũ i nümax. Rü nge̱ma tá nixĩ i nüxü̃ peyadauxü̃. Rü ngẽma nixĩ i ore i pemaã nüxü̃ chayarüxuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Rü yexguma ga yema ngecügü rü paxama nüxna íiyaxĩ ga yema naxmaü̃. Rü imuü̃ẽ, natürü itaãẽgü ta. Rü poraãcü iixü̃ãchi na Ngechuchuarü ngúexü̃gümaã nüxü̃ na yanaxugüexü̃cèx ga yema ore ga daxũcü̱̃ã̱x ngĩmaã nüxü̃ ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Rü yexguma inaxü̃ãchiyane, rü ngürüãchi yéma ngĩxcèx nango̱x ga Ngechuchu, rü ngĩxü̃ narümoxẽ. Rü ngĩmagü rü Ngechuchucèx iyabuxmü rü nüxü̃ iyacuèxüü̃gü, rü naparawa inèĩ̱xãchitanü. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Rü nüma ga Ngechuchu rü ñanagürü ngĩxü̃gü: —¡Tãxṹ i pemuü̃ẽxü̃! ¡Rü ípixĩ rü chaueneẽgü i chorü ngúexü̃gümaã nüxü̃ peyarüxu rü Gariréaanewa naxĩ! Rü nge̱ma tá nixĩ i choxü̃ nadaugüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Rü yexguma ga yema ngecügü rü namagu naxĩyane, rü ñuxre ga churaragü ga yéma naxmaü̃wa dauxü̃taegüxü̃ rü Yerucharéü̃wa naxĩ. Rü paigüarü ãẽ̱xgacügümaã nüxü̃ nayarüxugüe ga guxü̃ma ga yema ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Rü yema paigüarü ãẽ̱xgacügü rü namaã nayarüdexagü ga Yudíugüarü ãẽ̱xgacügüerugü. Rü nügümaã nanamexẽẽgü ga ṯacümaã tá churaragüxü̃ na yaxucu̱xẽgüxü̃. Rü ñu̱xũchi nüxna ngĩxü̃ naxãgü ga tacü ga dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Rü namaã nüxü̃ nixugüe rü ñanagürügü: —¡Pema rü ñaperügügü tá: “Ngẽxguma chütacü tapeeyane, rü norü ngúexü̃gü toechita nge̱ma naxĩ rü nayayauxgü ga naxü̃ne” ñaperügügü tá! ");
INSERT INTO tcaNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Rü ngẽxguma ãẽ̱xgacü ya Piratu tá nüxü̃ cuèxgu i ngẽma ngupetüxü̃, rü toma rü tá namaã tidexagü rü namaã tá tanamexẽẽ na taxuü̃ma pemaã naxüxü̃cèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Rü yexguma ga yema churaragü rü ngĩxü̃ nayauxgü ga yema dĩẽru. Rü yema ãẽ̱xgacügü namaã nüxü̃ ixugüxü̃rüü̃ duü̃xü̃gümaã nüxü̃ nixugüe. Rü ñu̱xma rü ta ngẽmatama dexa nixĩ i nüxü̃ yaxugüxü̃ i Yudíugü. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Rü yema 11 ga Ngechuchuarü ngúexü̃gü rü Gariréa- anewa naxĩ ga guma mèxpǘne ga Ngechuchu namaã nüxü̃ ixuxü̃newa. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Rü yexguma Ngechuchuxü̃ nadaugügu rü nüxü̃ nicuèxüü̃gü, woo ñuxre ga norü ngúexü̃gü rü tama aixcüma nayaxõgü na Ngechuchu yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Rü yexguma ga Ngechuchu rü naxcèx nixũ, rü ñanagürü nüxü̃: —Tupana rü ãẽ̱xgacüxü̃ choxü̃ nixĩxẽẽ i guxü̃ i daxũguxü̃ i naãnewa rü guxü̃ i ñoma i naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","—Rü ñu̱xma rü chanaxwèxe i guxü̃ i nachiü̃ãnewa pexĩ i guxü̃ i duü̃xü̃gütanüwa. ¡Rü chorü duü̃xü̃güxü̃ peyaxĩgüxẽẽ̱x! ¡Rü ípenabaiü̃xẽẽ̱x chauégagu rü Chaunatüégagu rü Naãẽ i Üünexü̃e̱gagu! ");
INSERT INTO tcaNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","¡Rü penangúexẽẽ̱x na naga naxĩnüẽxü̃cèx i guxü̃ma i ngẽma pexü̃ chamuxü̃! ¡Rü dücax, guxü̃gutáma pexü̃tawa changẽxmaẽcha ñu̱xmatáta nagú i naãne! —ñanagürü ga Ngechuchu.");
INSERT INTO tcaNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ñaã nixĩ i norü ügü i ore i mexü̃ ya Ngechuchu ya Cristu ya Tupana Nanechiga. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Rü nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ichaxía ümatüxü̃ ga Tupanaãrü ore, rü ñanagürü: “Cupẽ́xegu chayamu i chorü orearü ngeruü̃ na namexẽẽãxü̃cèx i cumaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Rü dauxchitawa i ngextá taxúema íxãpataxü̃wa rü tá nangẽxma i wüxi i duü̃xü̃ i nge̱ma tagaãcü ñaxü̃: ‘¡Pegü pemexẽẽ̱x naxcèx ya Cori. Rü naxcèx ipeyanawẽ́xãchixẽẽ̱x i perü maxü̃!’ ” ñaxü̃ tá. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Rü Cuáü̃ rü dauxchitawa ga ngextá taxúema íxãpataxü̃wa nango̱x rü yéma ínanabaiü̃xẽẽ ga duü̃xü̃gü. Rü namaã nüxü̃ nixu ga na namexü̃ na Tupanacèx nadaugüxü̃ rü ínabaiü̃xü̃ na Tupana nüxü̃́ nüxü̃ nangechaü̃xü̃cèx ga norü pecadugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Rü guxü̃ma ga duü̃xü̃gü ga Yudéaanecü̱̃ã̱x rü ĩãne ga Yerucharéü̃cü̱̃ã̱x rü yéma Cuáü̃xü̃tawa naxĩĩxü̃ ga na nüxü̃́ iyanaxĩnüẽxü̃cèx. Rü nümagü rü norü pecadugüxü̃ yéma nayarüxugüxü̃, rü Cuáü̃ rü natü ga Yudáü̃wa ínayabaiü̃xẽẽtanü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Rü naxchiru ga Cuáü̃ rü cameyutèxanaxcèx nixĩ, rü norü goyexü̃ rü naxchèxmünaxcèx nixĩ. Rü beruremaã rü munümaã naxãwemü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Rü Cuáü̃ rü yema nüxü̃ yaxuxü̃ ga orewa, rü ñanagürü: —Choweama tá ne naxũ ya choxü̃ rüyexeracü. Rü choma rü taxuwama chame rü bai na ichayarümaxãchixü̃ na íchayaw̱ẽxü̃cèx i norü chapatucunügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","—Choma rü dexáwamare pexü̃ íchabaiü̃xẽẽ, natürü nüma rü tá Tupanaãẽ i Üünexü̃ pexna nanguxẽẽ —ñanagürü ga Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Rü yema ngunexü̃gügu, rü Ngechuchu rü ínaxũxũ nawa ga guma ĩãne ga Nacharétu ga Gariréaanewa yexmane. Rü Cuáü̃ rü natü ga Yudáü̃wa ínanabaiexẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Rü yexguma dexáwa ínaxü̃ãchigu, rü Ngechuchu nüxü̃ nadau ga na yangenaxü̃ ga daxũwa. Rü yema Tupanaãẽ i Üünexü̃ rü wüxi ga muxtucurüü̃ inanago, rü Ngechuchuna nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Rü daxũwa inanaxũ ga wüxi ga naga ga ñaxü̃: —Cuma nixĩ i Chaune i cuxü̃ changechaü̃xü̃chixü̃ rü cumaã chataãẽxü̃chixü̃ —ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Rü yemawena rü Tupanaãẽ i Üünexü̃ rü dauxchitawa ga ngextá taxúema íxãpataxü̃wa Ngechuchuxü̃ naga. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Rü yéma nayexma ga 40 ga ngunexü̃. Rü naẽü̃gü ga idüraexü̃ íyexmagüxü̃wa nayexma, rü ngoxo ga Chataná rü nüxü̃ naxü. Natürü Tupanaãrü orearü ngeruü̃gü ga daxũcü̱̃ã̱x rü Ngechuchuxü̃ narüngü̃xẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Rü nawena ga poxcupataü̃gu na napoxcuxü̃ ga Cuáü̃, rü Gariréaanewa naxũ ga Ngechuchu na naxunagüãxü̃cèx ga Tupanaãrü ore i mexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Rü ñanagürü: —Marü nawa nangu i ngunexü̃ ga Tupana nagu unetaxü̃, rü pexcèx ningaica na perü ãẽ̱xgacü na yiĩxü̃. ¡Rü ñu̱xma rü name nixĩ i Tupanacèx pedaugü rü peyaxõgü i ngẽma norü ore i mexü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Rü yexguma naxtaxa ga Gariréaanacügu yaxũxgu ga Ngechuchu, rü yéma nüxü̃ nadau ga Chimáũ rü naẽneẽ ga Aü̃dré. Rü nümagü rü woetama püchaetanüxü̃ nixĩgü rü yéma naxtaawa napüchaegü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Rü Ngechuchu rü ñanagürü nüxü̃: —¡Chowe perüxĩ rü tá pexü̃ charüngü̃xẽẽ na chauxü̃tawa penagagüxü̃cèx i duü̃xü̃gü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rü yexgumatama ga yema taxre, rü yéma nanawogü ga norü püchagü. Rü Ngechuchuwe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Rü yéamaxü̃ra naxũ ga Ngechuchu, rü yéma nüxü̃ nadau ga Chaü̃tiágu rü naẽneẽ ga Cuáü̃. Rü Zebedéu nanegü nixĩgü ga nümagü. Rü wüxi ga nguewa nayexmagü, rü yéma ínanangáitagü ga norü püchagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Rü yexgumatama Ngechuchu naxcèx naca. Rü nümagü rü yéma nguewa tüxü̃ natèxgü ga nanatü ga Zebedéu namaã ga tümaãrü puracütanüxü̃gü, rü Ngechuchuwe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Rü ĩãne ga Capernáũwa nangugü. Rü yexguma ngü̃xchigaarü ngunexü̃wa nanguxgu, rü Ngechuchu rü ngutaquẽ́xepataü̃wa naxũ rü yexma naxücu. Rü yéma inanaxügü ga na nangúexẽẽtaexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Rü duü̃xü̃gü rü nabèi̱xãchiãẽgü namaã ga norü ngu̱xẽẽtae, yerü aixcüma Tupanaãrü poramaã meã nanangúexẽẽ rü tama ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃rüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","24","Rü guma ĩãneãrü ngutaquẽ́xepataü̃wa nayexma ga wüxi ga yatü ga ngoxo nawa yexmaxü̃. Rü aita yéma naxü, rü ñanagürü: —¿Tü̱xcüü̃ totanüwa cuxũ, Pa Ngechuchu Pa Nacharétucü̱̃ã̱x? ¿Nuã cuxũ na toxü̃ cuyadèi̱xü̃cèx? Choma rü cuxü̃ chacuèx na Tupana Nane ya Üünecü quiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Rü Ngechuchu nüxü̃ naxoo̱x ga yema ngoxo, rü ñanagürü: —¡Iyarüngeèx rü ínaxũxũ nawa ya yima yatü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Rü yexguma ga yema ngoxo rü guma yatüxü̃ niyuãchixẽẽ, rü tagaãcü aita naxüãcüma nawa ínaxũxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Rü guxü̃ma ga duü̃xü̃gü rü nabèi̱xãchiãẽgü, rü namücügüna nicachigü rü ñanagürügü: —¿Ṯacü nixĩ i ñaã? Maneca wüxi i ngexwacaxü̃xü̃ i ngu̱xẽẽtae nixĩ. Nüma rü aixcüma Tupanaãrü poramaã meã nangu̱xẽẽtae. Rü woo i ngoxogü rü naga naxĩnüẽ i ngẽxguma namuãxgu —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Rü yemaãcü nixĩ ga paxa guxü̃wama ga Gariréaanewa rü Ngechuchuchigaxü̃ nacuèxgüxü̃ ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Rü yexguma ngutaquẽ́xepataü̃wa ínaxũxũgu ga Ngechuchu, rü Chaü̃tiágu rü Cuáü̃maã Chimáũ rü Aü̃drépatawa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Rü Chimáũ nèxẽ rü ngürücarewa iyexma, yerü iyaxaxüne. Rü Ngechuchumaã ngĩxü̃ nixugüe. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Rü ngĩxcèx nixũ, rü ngĩxmẽ́xgu nayayauxãchi, rü ngĩxü̃ ínarüdaxẽẽ. Rü yexgumatama igèu̱xãchi ga na yaxaxünexü̃. Rü íirüda, rü inaxügü ga naxcèx na namexẽẽãxü̃ ga õna. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Rü yexguma marü yanaxücuxgu ga üèxcü ga na nachütachaü̃xü̃, rü Ngechuchuxü̃tawa nanagagü ga guxü̃ma ga duü̃xü̃gü ga iḏaaweexü̃ rü guxü̃ma ga ingoxoã̱xgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Rü guxü̃ma ga yema ĩãnecü̱̃ã̱x rü yexma guma ĩpataarü ĩã̱xwa naxcèx nangutaquẽ́xegü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Rü nüma nanameẽxẽẽ ga muxü̃ma ga duü̃xü̃gü ga nagúxü̃raü̃xü̃ ga ḏaawemaã iḏaaweexü̃. Rü ínanawoxü̃ ga muxü̃ma ga ngoxogü, natürü nüxna nanachu̱xu ga na yadexagüxü̃, yerü nümagü ga ngoxogü rü nüxü̃ nacuèxgü na texé yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Rü ngunetüü̃ ga tauta yangóonegu, rü inaxũãchi ga Ngechuchu. Rü ĩãneãrü yéaxüra ga ngextá taxúema íxãpataxü̃wa naxũ na yéamaxü̃ra yayumüxẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Rü Chimáũ rü namücügümaã Ngechuchucèx nayadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Rü yexguma nüxü̃ iyangaugügu, rü ñanagürügü nüxü̃: —Guxü̃ma i duü̃xü̃gü rü cuxcèx nadaugü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Natürü ga nüma rü nanangãxü̃ rü ñanagürü nüxü̃: —¡Ngĩxã rü toxnamana taxĩ náĩgü ya ĩãnexãcügü ya ngaicamagünewa na nge̱ma rü ta chanaxunagüxü̃cèx i ore i mexü̃! Erü woetama ngẽmacèx nixĩ i Capernáũãrü ĩãnewa íchaxũxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Rü yemaãcü ga Ngechuchu rü guxü̃ma ga Gariréaanegu nixũãgüchigü. Rü wüxichigü ga ĩãneãrü ngutaquẽ́xepataü̃wa rü nüxü̃ nixuchigü ga ore ga mexü̃, rü ínayawoxü̃ẽtanü ga ngoxogü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Rü Ngechuchucèx nixũ ga wüxi ga yatü ga chaxünemaã iḏaawecü. Rü napẽ́xegu nayacaxã́pü̱xüãcüma ñanagürü nüxü̃: —Pa Corix, ngẽxguma cunaxwèxegu na choxü̃ curümexẽẽxü̃, rü cuxü̃́ natauxcha na chauxcèx cuyataanexẽẽxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Rü Ngechuchuaxü̃́ nangechaü̃tümüü̃ ga guma yatü. Rü nüxü̃ ningõgü rü ñanagürü nüxü̃: —Ngü̃, chanaxwèxe. ¡Marü curüme! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Rü yexgumatama nüxü̃́ inayarüxo ga na nachaxünexü̃ ga guma yatü. Rü meãma naxcèx nitaane. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Rü Ngechuchu rü yexgumatama ínayamu. Rü meãma nanaxucu̱xẽ rü ñanagürü nüxü̃: —¡Dücèx, tãxũtáma texémaã nüxü̃ quixu! ¡Natürü nge̱ma paixü̃tawa naxũ, rü cugü nüxü̃ yadauxẽẽ! ¡Rü curü mexẽẽcèx nüxna yaxuaxü̃ i curü ãmare ga yema Moĩché tüxü̃ muxü̃ na nüxü̃ nacuáxü̃cèx i duü̃xü̃gü na curümexü̃ nawa i curü daawe! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Natürü nüma ga guma yatü rü ínixũ rü inanaxügü ga na guxãmaãma nüxü̃ yaxuxü̃ ga yema nüxü̃ ngupetüxü̃. Rü yemacèx ga Ngechuchu rü marü taxucürüwa ngóxü̃wama duü̃xü̃güpẽ́xewa ĩãnegügu naxücu. Natürü dauxchitagu ga ngextá duü̃xü̃gü ítaxuxü̃gu narüxã̱ũ̱x. Rü yéma naxcèx naxĩĩxü̃ ga duü̃xü̃gü ga guxü̃ãnewa ne ĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Rü yixcama ga ñuxre ga ngunexü̃wena rü wenaxãrü Capernáũãrü ĩãnegu naxücu ga Ngechuchu. Rü yexguma duü̃xü̃gü nüxü̃ cuáchigagügu na ĩpatawa nayexmaxü̃, rü yéma nangutaquẽ́xegü ga muxü̃ma ga duü̃xü̃gü. Rü düxwa ga ĩã̱xtüwa rü nanapá. Rü nüma ga Ngechuchu rü namaã nüxü̃ nixu ga ore i mexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Rü yéma nangugü ga ãgümücü ga yatügü ga yéma nangetaü̃güxü̃ ga wüxi ga yatü ga naw̱ãĩxãchicü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Natürü yema na namuxũchixü̃ ga duü̃xü̃gü, rü taxucürüwama Ngechuchuxü̃tawa nangugü. Rü yemacèx ínanapogüétü ga Ngechuchu íyexmaxü̃wa ga guma ĩpata. Rü yéma norü caruü̃gu ínanac̱ẖüxüetaü̃gü ga guma naw̱ãĩxãchicü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga ñuxãcü aixcüma na yaxõgüãxü̃ ga yema duü̃xü̃gü, rü ñanagürü nüxü̃ ga guma naw̱ãĩxãchicü: —Pa Chaunex, curü pecadugü rü marü cuxü̃́ nüxü̃ changechaü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Natürü ñuxre ga ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ rü yéma narütogü. Rü naãẽwa ñaxü̃gu narüxĩnüẽ: —¿Ñuxãcü tama namuü̃ na ngẽmaãcü yadexaxü̃? ¿Rü ṯacü Tupanamaã yaxugüxü̃? Erü Tupanaxĩcatama nixĩ ya duü̃xü̃güarü pecaduxü̃ ngechaü̃cü —ñaxü̃gu narüxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Natürü yexgumatama ga Ngechuchu rü nüxü̃ nicuèxãchi ga yema nagu naxĩnüẽxü̃, rü yemacèx nüxna naca rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ ngẽmagu perüxĩnüẽ i pemax? ");
INSERT INTO tcaNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","—¿Ṯacü nixĩ i rütauchamaẽxü̃ na namaã nüxü̃ ixuxü̃ ya daa naw̱ãĩxãchicü: “Curü pecadugü rü marü cuxü̃́ nüxü̃ changechaü̃”, rü ẽ́xna: “¡Inachi, rü nayaxu i curü caruü̃, rü íixũ!” ñaxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","—Natürü ñu̱xma rü tá pexü̃ nüxü̃ chadauxẽẽ na Chaunatü núma choxü̃ muxü̃ na duü̃xü̃güaxü̃́ nüxü̃ changechaü̃xü̃cèx i norü pecadugü —ñanagürü. Rü yexguma yema ñaxguwena rü guma naw̱ãĩxãchicüxü̃ ñanagürü: —Cumaã nüxü̃ chixu rü ¡inachi, rü nayaxu i curü caruü̃, rü cupatawa naxũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Rü yexgumatama inachi ga guma iḏaawecü. Rü nanayaxu ga norü caruü̃, rü ínaxũxũ napẽ́xewa ga guxü̃ma ga yema duü̃xü̃gü ga yéma yexmagüxü̃. Rü yemacèx ga yema duü̃xü̃gü rü nabèi̱xãchiãẽgü, rü Tupanaxü̃ nicuèxüü̃gü, rü ñanagürügü: —Taguma nüxü̃ tadau i ṯacü i ñaãrüü̃ ixĩxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Rü yemawena rü wenaxãrü naxtaacutüwa naxũ ga Ngechuchu. Rü yema muxü̃ma ga duü̃xü̃gü rü naxcèx naxĩ. Rü nüma rü nanangúexẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Rü yexguma yéma naxüpetügu ga Ngechuchu, rü yéma nüxü̃ nadau ga Lebí ga Arupéu nane. Rü nüma ga Lebí rü yéma narüto nawa ga yema nachica ga duü̃xü̃güna dĩẽru ngĩxü̃ ínayaxuxü̃wa naxcèx ga Dumacü̱̃ã̱xãrü ãẽ̱xgacü yerü woetama yema nixĩ ga norü puracü. Rü Ngechuchu rü ñanagürü nüxü̃: —¡Chowe rüxũ! —ñanagürü. Rü inachi ga Lebí, rü nawe narüxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Rü yéma Lebípatawa nachibü ga Ngechuchu. Rü yéma nachibüe ga muxü̃ma ga duü̃xü̃gü ga Lebírüü̃ Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ yauxgüxü̃. Rü nayexmagü ta ga togü ga duü̃xü̃gü ga taxúema nacümamaã taãẽgüxü̃ ga yéma mechawa rütogüxü̃ namaã ga Ngechuchu rü norü ngúexü̃gü. Yerü namu ga yema nawe rüxĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Rü yéma nayexmagü ta ga ñuxre ga Parichéugü rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃. Rü yexguma nüxü̃ nadaugügu ga yema togümaã na nachibüxü̃ ga Ngechuchu, rü norü ngúexü̃güna nacagü, rü ñanagürügü: —¿Ñuxãcü i perü ngúexẽẽruü̃ rü namaã nachibü i ãẽ̱xgacüarü duü̃xü̃gü i dĩẽruarü yauxwa puracüexü̃ rü duü̃xü̃gü i pecaduã̱xgüxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Rü yexguma yemaxü̃ naxĩnügu ga Ngechuchu rü ñanagürü nüxü̃: —Ngẽma poraexü̃ rü tama nanaxwèxe ya duturu, natürü ngẽma iḏaaweexü̃ waxi nixĩ i naxwèxexü̃ ya duturu. Choma rü tama mexü̃güna na chaxuxü̃cèx nixĩ ga núma chaxũxü̃, natürü núma chaxũ na nüxna chaxuxü̃cèx i pecaduã̱xgüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rü wüxi ga ngunexü̃gu rü tama nachibüe yerü Tupanacèx naxauree ga Cuáü̃ ga baiü̃xẽẽruü̃ãrü ngúexü̃gü rü Parichéugüarü ngúexü̃gü. Rü yemaxü̃ nadaugügu ga ñuxre ga duü̃xü̃gü, rü Ngechuchuxü̃tawa naxĩ rü nüxna nayacagüe, rü ñanagürügü: —Ngẽma Cuáü̃ãrü ngúexü̃gü rü Parichéugüarü ngúexü̃gü rü naxauree. ¿Rü tü̱xcüü̃ i curü ngúexü̃gü i tama naxaureexü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —¿Ẽ́xna wüxi i ngĩgüarü petawa rü pexcèx namexü̃ na naxaureexü̃ i ngẽma nüxna naxugüxü̃ ega natanüwa nangẽxmagu i ngẽma yatü i ngexwacèx ãmaxü̃? Pemaã nüxü̃ chixu rü ngẽxguma natanüwa nangẽxmayane i ngẽma yatü i ngexwacèx ãmaxü̃ rü taxucürüwama naxauree i ngẽma nüxna naxugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","—Natürü wüxi i ngunexü̃ rü ngẽma yatü i ngexwacèx ãmaxü̃ rü tá namücügüna nixũgachi. Rü ngẽma ngunexü̃gu tá nixĩ i naxaureexü̃. Rü chorü ngúexü̃gü rü taxucürüwama naxauree i ñu̱xma erü natanüwa changẽxma. Natürü ínangu tá i ngẽma ngunexü̃ na nüxna chixũgachixü̃, rü ngẽxguma tá nixĩ i naxaureexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Rü taxúema wüxi i naxchirutüchi i ngexwacaxü̃xü̃maã tanapaita i wüxi i naxchiru i ngauxü̃. Erü ngẽxguma nañaãchimügu i ngẽma natüchi i ngexwacaxü̃xü̃, rü tá nanagáuxẽẽ i ngẽma ngauxü̃ i naxchiru. Rü noxriarü yexera tá narügáu. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","—Rü ngẽxgumarüü̃ ta taxúema ngexwacaxü̃cü ya binu rü wüxi i marü ngauxü̃ i naxchiü̃ i naxchèxmünaxcèxgu tayabacuchi. Erü ngẽxguma ngẽmaãcü naxü̱xgu rü yima binu ya ngexwacaxü̃cü rü narüngu, rü tá nayawã̱ĩ̱xẽẽ i ngẽma naxchiü̃ i ngauxü̃ i naxchèxmünaxcèx. Rü ngẽxma tá inayarüxo ya binu rü naxchiü̃ rü ta. Rü ngẽmacèx tanaxwèxe ya ngexwacaxü̃cü ya binu rü ngexwacaxü̃xü̃ i naxchiü̃gu tayabacuchi. Rü chorü ngu̱xẽẽtae i ngexwacaxü̃xü̃ rü ngẽxgumarüü̃ ta nixĩ na taxucürüwama namaã nawüxiguxü̃ i ngẽma nuxcümaü̃xü̃ i pecümagü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wüxi ga ngü̃xchigaarü ngunexü̃gu ga Ngechuchu rü norü ngúexü̃gümaã trigunecüwa nachopetü. Rü nümagü ga norü ngúexü̃gü rü inaxĩãcüma inanaxügüe ga trigu na yabuxetanüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Rü yema Parichéugü rü Ngechuchuna nacagü rü ñanagürügü: —Dücèx ¿rü tü̱xcüü̃ i curü ngúexü̃gü rü nanaxügü i ngẽma tama mexü̃ i ngü̃xchigaarü ngunexü̃gu na naxüxü? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Natürü nüma ga Ngechuchu rü ñanagürü nüxü̃: —¿Taguma ẽ́xna poperawa nüxü̃ pedau ga ṯacü na naxüxü̃ ga nuxcümaü̃cü ga ãẽ̱xgacü ga Dabí rü natanüxü̃gü ga yexguma õna nüxü̃́ tau̱xgu rü nataiyaegu? ");
INSERT INTO tcaNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Rü yexguma paigüarü ãẽ̱xgacü yixĩgu ga Abiatáru, rü Dabí rü Tupanapatagu naxücu. Rü nanangõ̱x ga yema pãũ ga üünexü̃ ga paigücèxicatama ixĩxü̃. Rü nüma ga Dabí rü natanüxü̃maã rü ta nangau ga yema pãũ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Rü ñanagürü ta ga Ngechuchu: —Ngẽma ngü̃xchigaarü ngunexü̃ rü duü̃xü̃gücèx nixĩ ga naxüxü̃. Rü tama ngü̃xchigaarü ngunexü̃cèx nixĩ ga naxüxü̃ ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","—Rü ngẽmacèx ya Tupana Nane ya duü̃xü̃xü̃ ixĩcü rü namaã inacuèx ta i ngü̃xchigaarü ngunexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Rü wenaxãrü ngutaquẽ́xepataü̃gu naxücu ga Ngechuchu. Rü yéma nayexma ga wüxi ga yatü ga norü wüxichacüüwa yumécü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Rü yema Parichéugü, rü Ngechuchuxü̃ nangugügü ngoxi tá namexẽẽã ga ngü̃xchigaarü ngunexü̃gu, na yemaãcü nüxü̃́ nayexmaxü̃cèx ga ṯacücèx na ínaxuaxü̃güãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃ ga guma yumécü: —¡Írüda, rü nuxã ngãxü̃tanügu yachi! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Rü yexguma ga Ngechuchu rü yema togü ga yéma yexmagüxü̃na naca, rü ñanagürü nüxü̃: —¿Ṯacü nixĩ i mexü̃ na naxüxü̃ i ngü̃xchigaarü ngunexü̃gu? ¿Namexü̃ na naxüxü̃ i mexü̃ rü ẽ́xna chixexü̃? ¿Rü namexü̃ na namaxẽẽxü̃ rü ẽ́xna yamáxü̃? —ñanagürü. Natürü ga nümagü rü yexma nayarüngeèxgümare. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Rü nüma ga Ngechuchu rü nuchametüãcüma nüxü̃ nidaugüãchi ga yema nüxü̃ íchomaẽguãchixü̃. Rü nangechaü̃ yerü tama inaxĩnüẽchaü̃ ga yema duü̃xü̃gü. Rü guma yatüxü̃ ñanagürü: —¡Iyanawẽ́xãchixẽẽ ya cuxmẽ́x! —ñanagürü. Rü yexguma ga guma yatü rü nügü inayarüwẽ́xãchimẽ́xẽxẽẽ. Rü yexgumatama rü narümexmẽ́x. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Natürü yexguma yemaxü̃ nadaugügu ga Parichéugü, rü ínachoxü̃ ga yéma. Rü Erodetanüxü̃maã inanaxügüe ga na naxcèx nadaugüxü̃ ga ñuxãcü tá na Ngechuchuxü̃ yamèxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Rü Ngechuchu rü norü ngúexü̃gümaã naxtaacutüwa naxũ. Rü muxü̃ma ga duü̃xü̃gü ga Gariréaanecü̱̃ã̱x rü nawe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Rü yexguma nüxü̃ nacuáchigagügu ga guxü̃ma ga yema mexü̃gü ga naxüxü̃ ga Ngechuchu, rü naxcèx naxĩtaquẽ́xe ga muxü̃ma ga duü̃xü̃gü ga Yudéaanecü̱̃ã̱x, rü Yerucharéü̃cü̱̃ã̱x, rü Iduméããnecü̱̃ã̱x, rü Yudáü̃ãrü tocutücü̱̃ã̱x rü yema naãne ga Tiru rü Chidã́ũãrü ĩãnegü nawa yexmaxü̃cü̱̃ã̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Rü yemacèx ga Ngechuchu rü norü ngúexü̃güxü̃ namu na wüxi ya ngue naxcèx namexẽẽgüxü̃cèx na tama yéma yaxũxtügüãxü̃cèx ga yema muxü̃ma ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Yerü nüma rü nanameẽxẽẽ ga muxü̃ma, rü yemacèx guxü̃ma ga yema iḏaaweexü̃ rü naxcèx naxĩ na nüxü̃ yangõgügüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Rü yexguma yema ngoxoã̱xgüxü̃ ga duü̃xü̃gü nüxü̃ daugügu, rü napẽ́xegu nacaxã́pü̱xügü rü tagaãcü ñanagürügü: —Cuma nixĩ ya Tupana Nane quiĩxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Natürü nüma ga Ngechuchu rü poraãcü nayaxucu̱xẽgü na tama duü̃xü̃gümaã nüxü̃ yaxugüexü̃cèx ga nachiga. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Rü yemawena ga Ngechuchu rü wüxi ga mèxpǘnewa ínaxü̃ãchi. Rü yéma naxcèx naca ga yema ngúexü̃gü ga nüma nanaxwèxexü̃. Rü naxü̃tagu naxĩtaquẽ́xegü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Rü yematanüwa nayadexechi ga 12 ga norü ngúexü̃gü na namücügüxüchi yiĩxü̃cèx, rü na yamugüãxü̃cèx ga norü orearü unagüwa. Rü yemagü rü Imugüxü̃gu nanaxüéga. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Rü pora nüxna naxã na Tupanaãrü poramaã ínawoxü̃ãxü̃cèx ga ngoxogü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Rü ñaãgü nixĩ ga nae̱ga ga yema 12 ga norü ngúexü̃gü ga nadexü̃. Rü wüxi nixĩ ga Chimáũ ga Pedrugu naxüégaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Rü togü nixĩ ga Chaü̃tiágu rü naẽneẽ ga Cuáü̃. Rü nümagü rü Zebedéu nanegü nixĩ. Rü Ngechuchu rü Boanéregu nanaxüéga. Rü ngẽma nixĩ i Duruanexü̃ Nanegü —ñaxü̃chiga. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Rü togü nixĩ ga Aü̃dré, rü Piripi, rü Baturumé, rü Mateu, rü Tumachi, rü Chaü̃tiágu ga Arupéu nane, rü Tadéu, rü Chimáũ ga iporaãẽcüücü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Rü to nixĩ ga Yuda ga Icariúte ga yixcama bexma Ngechuchuxü̃ íxuaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Rü yemawena rü wüxi ga ĩpatagu naxücu ga Ngechuchu. Rü wenaxãrü naxcèx nangutaquẽ́xegü ga muxü̃ma ga duü̃xü̃gü. Rü yemacèx woo na nachibüexü̃cèx rü nangechicagü ga nüma rü norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Rü yexguma yemaxü̃ taxĩnüẽgu ga guxema natanüxü̃gü ga Ngechuchu, rü ítayadaugü na tayagagüxü̃cèx, yerü nüxü̃ tixugügü rü: —Naxãũãẽmare —ñatagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Rü yexgumarüü̃ ta ga yema ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ ga Yerucharéü̃wa ne ĩxü̃, rü ñanagürügü: —Ñaã yatü i Ngechuchu, rü ngoxogünatü i Bechebúarü poramaã nixĩ i ínawoxü̃ãxü̃ i ngoxogü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Natürü ga Ngechuchu rü naxcèx naca ga yema ngúexẽẽruü̃gü. Rü wüxi ga ore ga cuèxruü̃xü̃ namaã nixu, rü ñanagürü: —¿Rü ñuxãcü i Chataná i nügütama ínatèxüchixü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","—Rü ngẽxguma chi wüxi i nachiü̃ãnecü̱̃ã̱x i duü̃xü̃gü rü nügütanüxü̃watama nügü nadaixgu, rü taxuacüma natai i ngẽma nachiü̃ãne. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","—Rü ngẽxguma chi wüxi ya ĩpatacü̱̃ã̱x nügü itoyegu, rü taxuacüma natai ya yima ĩpata. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","—Rü ngẽxgumarüü̃ chi ta nixĩ i Chataná ega nügümaã nanuxgu rü nügü yamèxgu, rü taxuacü chima natai i ngẽxguma. Rü chi ngẽxma nagu̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","—Rü taxuacüma texé wüxi ya yatü ya poracüpatagu taxücu na nüxna tanapuxü̃xü̃cèx i norü ngẽmaxü̃gü, ega tama tayanèi̱xiragu. Erü ngẽmaãcüxica tá nixĩ i tüxü̃ nanguxü̃xü̃ na tanapuxü̃xü̃ i norü ngẽmaxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Rü aixcüma pemaã nüxü̃ chixu rü Tupana tá nüxü̃́ nüxü̃ nangechaü̃ i duü̃xü̃gü i guxü̃ma i norü pecadugü rü guxü̃ma i ṯacü i chixexü̃ i namaã yadexagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","—Natürü texé ya chixexü̃ namaã ixugüxe i Tupanaãẽ i Üünexü̃, rü tagutáma tüxü̃́ nüxü̃ nangechaü̃ ya Tupana. Rü guxü̃gutáma chixexü̃wa tüxü̃ natèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Rü yema ñanagürü ga Ngechuchu, yerü yema ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ rü: “Nangoxoã̱x” ñanagürügü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Rü yexgumayane rü ítangugü ga Ngechuchuarü mamá rü naẽneẽgü. Natürü ĩpataarü düxétügu tarücho, rü naxcèx yéma tangemagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Rü yema duü̃xü̃gü ga Ngechuchuxü̃ íchomaẽguãchixü̃, rü ñanagürügü nüxü̃: —Curü mamá rü cueneẽgü rü cueyèxgü, rü yéa düxétüwa tangẽxmagü, rü cuxcèx tadaugü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Rü nüma nanangãxü̃, rü ñanagürü: —¿Texé tixĩ ya chaue rü chaueneẽgü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Rü yema nüxü̃ íchomaẽguãchixü̃xü̃ nidaugüãchi, rü ñanagürü: —Rü daxegü tixĩ ya chaue rü chaueneẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","—Erü guxãma ya texé ya naxǘxe i Tupanaãrü ngúchaü̃, rü yíxema tixĩ ya chaueneẽ rü chaueyèx rü chaue —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Rü wenaxãrü inanaxügü ga Ngechuchu ga na nangúexẽẽãxü̃ ga duü̃xü̃gü ga guma naxtaxaãnacüwa. Rü muxü̃ma ga duü̃xü̃gü yexma naxcèx nangutaquẽ́xegü. Rü yemacèx düxwa wüxi ga ngue ga yéma naxtaawa yexmanegu nixüe ga Ngechuchu, rü gumawa narüto. Rü yema duü̃xü̃gü rü naxtaxaãnacügu narücho. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Rü yexguma ga Ngechuchu rü inanaxügü ga muxü̃ma ga ore ga cuèxruü̃wa na nangúexẽẽãxü̃ ga duü̃xü̃gü. Rü norü ngu̱xẽẽtaewa rü ñanagürü: —¡Dücèx, iperüxĩnüẽ i ñaã ore! Wüxi ga yatü ga toecü rü triguarü towa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","—Rü yexguma triguchiremaã nagüaneãgu, rü ñuxre ga triguchire rü namagu nayi. Rü ínangugü ga werigü, rü nanawecu. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","—Rü náĩgü ga triguchire rü nutatanügu nayi ga ngextá ínachicaxü̃wa ga waixü̃mü. Rü paxa narüxügü ga guma triguchire, yerü ga waixü̃mü rü tama nayaxcü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","—Natürü yexguma nangunagügu ga üèxcü, rü ínanagu ga guma trigu rü narüṉ̃exgü. Rü nayue, yerü tama poraãcü nixãmaxã. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","—Rü náĩgü ga triguchire rü toranecügu nayi. Rü yexguma nayaegu ga tora, rü guma triguxü̃ inawocu, rü yemacèx tama nixo. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","—Natürü náĩgü ga triguchire rü mexü̃ ga waixü̃mügu nayi. Rü meãma nayae, rü muxü̃ma ga trigu nawa ínanguxuchi. Rü nümaxü̃neyèxawa rü 30 pü̱xü ínanguxuchi ga norü o, rü náĩgüwa rü 60, rü náĩgüwa rü 100 ínanguxuchi —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Rü ñu̱xũchi ñanagürü ta: —Rü yíxema ãchi̱xẽgüxe, ¡rü nüxü̃ taxĩnüẽ i ñaã ore! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Rü yemawena ga yexguma nanüxĩcèxgu ga Ngechuchu, rü yema naxü̃tagugüxü̃ wüxigu namaã ga yema 12 ga norü ngúexü̃gü, rü nüxna nacagüe ga na ṯacüchiga yiĩxü̃ ga yema ore ga cuèxruü̃gu ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Rü nüma nanangãxü̃ rü ñanagürü nüxü̃: —Tupana rü pexü̃ nüxü̃ nacuèxẽẽ i ngẽma ẽxü̃guxü̃ i taxuü̃ma i togü nüxü̃ cuáxü̃ na ñuxãcü ãẽ̱xgacü na yiĩxü̃ i nümax. Natürü ngẽma togü i tama tatanüxü̃ ixĩxü̃cèx rü cuèxruü̃gu chayaxuãcüma namaã nüxü̃ chixu i ore na woo nüxü̃ nadaunügu rü ñoma tama nüxü̃ nadaugüxü̃rüü̃ na yiĩxü̃cèx, rü woo nüxü̃ naxĩnüẽgu rü tama nüxü̃ na nacuèxgüxü̃cèx. Rü ngẽmaãcü namaã nüxü̃ chixu na tama nüxü̃ naxoexü̃cèx i nacüma i chixexü̃ rü tama Tupana nüxü̃́ nüxü̃ ngechaü̃xü̃cèx i norü pecadugü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Rü Ngechuchu ñanagürü nüxü̃: —¿Pema rü ta ẽ́xna tama nüxü̃ pecuèxgü na ṯacüchiga yiĩxü̃ i ngẽma ore i cuèxruü̃ i nüxü̃ chixuxü̃? ¿Rü ñuxũcürüwa tá nüxü̃ nacuèxgü i ngẽma togü? ");
INSERT INTO tcaNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","—Rü yíxema toexe, rü yíxema tixĩ ya ore i mexü̃ unagüxe. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","—Rü nangẽxma i duü̃xü̃gü i guma triguchire ga namagu y̱ixü̃nerüü̃ ixĩgüxü̃. Rü nümagü rü nüxü̃ naxĩnüẽ i ore i mexü̃, natürü yixcama marü nüxü̃ naxĩnüẽguwena, nge̱ma nangu i Chataná rü nüxna nanapu i ngẽma ore i mexü̃ ga noxri yaxõgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","—Rü togü rü ngẽma triguchire ga nutatanügu y̱ixü̃nerüü̃ nixĩgü. Rü ngẽmagü nixĩ i nüxü̃ ĩnüẽxü̃ i ore i mexü̃, rü taãẽãcüma nayauxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","—Natürü ngẽma na tama aixcüma nagu naxĩnüẽxü̃ i ngẽma ore, rü paxaãchitama nayaxõgü. Rü ngẽmacèx i yixcama ngẽxguma ngẽma oregagu guxchaxü̃gü nüxü̃ üpetügu rü ẽ́xna duü̃xü̃gü naxchi aiegu, rü nüxü̃ narüxoe i ngẽma ore ga noxri yaxõgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","—Rü togü rü guma triguchire ga toranecügu y̱ixü̃nerüü̃ nixĩgü. Nümagü rü nüxü̃ naxĩnüẽ i ngẽma ore i mexü̃, natürü ñoma i naãneãrü ngẽmaxü̃gücèx naxoegaãẽgü rü norü dĩẽruguama narüxĩnüẽ, rü nanaxwèxegü i nüxü̃́ na nangẽxmaxü̃ i muxü̃ma i to i norü ngẽmaxü̃gü. Rü guxü̃ma i ngẽma rü nüxü̃ nüxü̃ inayarüngümaẽxẽẽ i ngẽma ore i mexü̃ rü nüxü̃ nüxü̃ narüxoexẽẽ na tama naxügüãxü̃cèx i ngẽma mexü̃ i Tupana nüxü̃́ naxwèxexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","—Rü togü rü guma triguchire ga mexü̃ ga waixü̃mügu y̱ixü̃nerüü̃ nixĩgü. Ngẽmagü nixĩ i nüxü̃ ĩnüẽxü̃ i ore i mexü̃ rü nayauxgüxü̃ rü meã Tupana naxwèxexü̃ãcüma maxẽxü̃. Rü nümaxü̃ rü guma trigu ga 30 pü̱xü nawa ínguxuchinerüü̃ nixĩgü. Rü nümaxü̃ rü guma 60 pü̱xü nawa ínguxuchinerüü̃ nixĩgü. Rü nümaxü̃ rü guma 100 pü̱xü nawa ínguxuchinerüü̃ nixĩgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Rü yexgumarüü̃ ta ñanagürü nüxü̃: —¿Ẽ́xna nuã tanange i wüxi i omü na wüxi i caichã́ũtüü̃gu rü ẽ́xna wüxi i pechicatüü̃gu na yaxücuchixü̃cèx? Tama ngẽmaãcü nixĩ, erü wüxi i omü rü dauxnagu tanaxünagü na nge̱ma inabaxixü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","—Rü ngẽxgumarüü̃ ta i guxü̃ma i ṯacü iicúxü̃, rü yixcüra rü duü̃xü̃gü rü tá nüxü̃ nacuèxgüama. Rü guxü̃ma i ngẽma ñu̱xma duü̃xü̃gücèx ẽxü̃guxü̃ rü tá nango̱xoma i yixcüra. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","—Rü yíxema ãchi̱xẽgüxe, ¡rü nüxü̃ taxĩnüẽ i ngẽma ore! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Rü yexgumarüü̃ ta ñanagürü nüxü̃: —¡Meã naga pexĩnüẽ i ngẽma nüxü̃ pexĩnüẽxü̃! Rü ngẽma pema naga na pexĩnüẽxü̃rüü̃ tá nixĩ i Tupana i pexna naxããxü̃ i cuèx. Rü nae̱tü tá poraãcü pexü̃ narüngü̃xẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","—Rü pemaã nüxü̃ chixu, rü texé ya aixcüma naga ĩnüxẽ i ñaã ore i mexü̃ rü Tupana rü yexeraãcü tá tüxü̃ nüxü̃ nacuèxẽẽ. Natürü yíxema tama naga ĩnüxẽ i ñaã ore rü Tupana tá tüxna nanayaxu i ngẽma íraxü̃ i cuèx i tüxü̃́ ngẽxmachiréxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Rü Ngechuchu rü ñanagürü ta: —Pemaã tá nüxü̃ chixu i wüxi i ore i cuèxruü̃ na nüxü̃ pecuáxü̃cèx na ñuxãcü ãẽ̱xgacü na yiĩxü̃ ya Tupana. Rü wüxi ya yatü rü waixü̃mügu nanato ya triguchire. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","—Rü nüma ya yatü rü chütacü nape rü moxü̃ãcü ínarüda, rü yoxni ya yima triguchire rü narüxü rü niyachigü. Natürü nüma ya yatü rü tama nüxü̃ nacuèx na ñuxãcü na naxüxü̃ rü na nayaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","—Rü ngẽmaãcü i ngẽma waixü̃mü rü nüẽchamatama nanaxüxẽẽ ya yima triguchire. Rü naã́tügüxira narüxü rü yixcama i nachacu rü ngẽmawena nachacuwa nanguxü̃ i norü o. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","—Rü ngẽxguma marü yadauxgu i ngẽma norü o, rü nanabuxu erü marü nawa nangu i norü buxgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Rü ñanagürü ta ga Ngechuchu: —Rü Tupanaarü ore rü yexera nixũchigü ¿Rü nanaṯacüraxü̃ rü ṯacügu tanangu? ");
INSERT INTO tcaNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","—Rü ñoma wüxi ya motachachire ya waixü̃mügu itoxü̃nerüü̃ nixĩ. Rü woo guxü̃nema ya nanetüchirexü̃ narüxíramaẽ, natürü ngẽxguma inatoxgu, rü narüxü rü naya ñu̱xmata guxü̃ma i togü i nanetüxü̃ nayexera. Rü nachacüü rü nita, rü woo werigü rü natanügu nixüachiãü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Rü yemaãcü ga Ngechuchu rü muxü̃ma ga nayexgumaãchiraü̃xü̃ ga ore ga cuèxruü̃gümaã nanangúexẽẽ ga duü̃xü̃gü. Natürü yema cuèxruü̃gü rü tama yema duü̃xü̃güarü cuèxü̃ nangupetü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Rü ore ga cuèxruü̃gu ixuxü̃xĩcatama nixĩ ga norü ngu̱xẽẽtae. Rü yixcama ga yexguma nanüxĩcèxgügu, rü norü ngúexü̃gücèx meãma nanango̱xẽẽ ga guxü̃ma. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Rü yematama ngunexü̃gu ga marü nachütachaü̃gu, rü Ngechuchu rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —¡Ngĩxã rü naxtaxaarü tocutüwa taxĩ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Rü yexguma duü̃xü̃güna yéma inaxĩãchi. Rü norü ngúexü̃gü rü Ngechuchuxü̃ nigagü nagu ga guma ngue ga marü nawa nayexmane. Rü yexgumarüü̃ ta ga togü ga duü̃xü̃gü rü náĩgü ga nguegügu ínayaxümücügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Rü yexguma yaxãü̃yane rü inaxü ga wüxi ga buanecü ga taxüchicü. Rü yema na nataxüchixü̃ ga buanecü, rü guma nguegu niyauxcuchichigü ga yuape, rü yexma nabaxü̃güchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Natürü ga Ngechuchu rü guma nguechinüwa wüxi ga cüxeruü̃gu naca, rü yéma nape. Rü ínanaḇaixgügü, rü ñanagürügü nüxü̃: —Pa Ngúexẽẽruü̃x, ¿ẽ́xna curü me nixĩ na nuxma ibaxü̃güxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Rü yexguma ínarüda ga Ngechuchu. Rü buanecüna nachogü rü ñanagürü nüxü̃ ga guma naxtaxa: —¡Iyarüchiane rü íyachaxãchi! —ñanagürü. Rü ínayachaxãchi ga buanecü rü guxü̃wama ínachaxanemare. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Rü yemawena ga Ngechuchu rü norü ngúexü̃güxü̃ ñanagürü: —¿Tü̱xcüü̃ ngẽmaãcü poraãcü pemuü̃ẽ? ¿Ñu̱xma rü ta ẽ́xna tama aixcüma peyaxõgü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Natürü nümagü ga norü ngúexü̃gü rü poraãcü namuü̃ẽ. Rü nügüna nacagüe rü ñanagürügü: —¿Texe ẽ́xna nixĩ ya daa rü èi̱xrücü ya buanecü rü yuape rü naga naxĩnüẽxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Rü naxtaxaarü tocutüwa nangugü ga Gadáraanewa. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Rü yexguma marü nguewa ínaxüegu ga Ngechuchu, rü yéma naxcèx nixũ ga wüxi ga yatü ga ngoxo nawa yexmaxü̃. Rü yema yatü rü duü̃xẽgüchíquẽ́xewa ne naxũ, yerü yexma nixĩ ga yanaxauchigünexü̃xü̃. Rü taxúexü̃ma nanguxü̃ na tayanáĩxü̃, woo cadenamaã. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Rü woo muẽ̱xpü̱xcüna cadenamaã nayanèĩ̱xparagü rü nayanèĩ̱xchacüügü, natürü nüma rü guxü̃guma íraxü̃gu inanacauü̃güama, rü yemaãcü taxúexü̃ma nanguxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Rü ngunecü rü chütacü rü yuetachiquẽ́xetanügu rü naxpü̱xgügu nanaxauchigüane. Rü yexma nanacaeane, rü nutamaã nügügu napogü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Natürü yexguma yaxü̃gutama Ngechuchuxü̃ nadèu̱xgu, rü naxcèx inañaãchi, rü napẽ́xegu nayacaxã́pü̱xü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Rü aita naxüãcüma ñanagürü nüxü̃: —¿Tü̱xcüü̃ nuã choxü̃ cuyachixewe, Pa Ngechuchux, Pa Tupanaxü̃chi Nanex? Rü Tupanae̱gagu cuxü̃ chacèèxü̃ na tama ngúxü̃ choxü̃ quingexẽẽxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Rü yemaãcü nidexa ga yema ngoxo yerü Ngechuchu rü marü ñanagürü nüxü̃: —Pa ngoxox, ¡ínaxũxü̃ nawa ya yima yatü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Rü yexguma ga Ngechuchu rü nüxna naca, rü ñanagürü: —¿Ṯacü nixĩ i cuéga? —ñanagürü. Rü nüma ga ngoxo nanangãxü̃, rü ñanagürü: —Muxũchixü̃ nixĩ i chauéga, erü tamu i tomax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Rü poraãcü Ngechuchuxü̃ nacèèxü̃gü na tama ínawoxü̃ãxü̃cèx ga yema naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Rü yema nachicaarü ngaicamana ga naxpü̱xpechinüwa rü nayexmagü ga muxü̃ma ga cuchigü ga yéma chibüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Rü yemacèx ga yema ngoxogü rü Ngechuchuxü̃ nacèèxü̃gü, rü ñanagürügü: —¡Nge̱ma cuchitanüwa toxü̃ namugü na nagu tachocuxü̃cèx! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Rü Ngechuchu rü: —Ngü̃ —ñanagürü. Rü yexguma ga yema ngoxogü rü guma yatüwa ínachoxü̃, rü yema cuchigügu nayachocu. Rü yema cuchigü ga wixgu 2000 ixĩgüxü̃ rü inaxü̃ãchi, rü naxtaacutüarü mèxpǘxü̃wa nayarüyuxgü. Rü yexma nayi. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Rü yema cuchigüarü dauruü̃gü rü ĩãnewa nabuxmü. Rü ĩãnewa rü yema ĩãneãrü ngaicamana ipeagüxü̃ ga duü̃xü̃gütanüwa nüxü̃ nayarüxugügü ga yema üpetüxü̃. Rü ga duü̃xü̃gü rü ínayadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Rü yexguma Ngechuchu íyexmaxü̃wa nangugügu, rü yéma nüxü̃ nadaugü ga guma yatü ga ngoxoã̱xchirécü. Rü yéma narüto, rü naxãxchiru, rü meãma naãẽxü̃ nacuèx. Rü poraãcü naḇaixãchiãẽgü ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Rü yema cuchigüarü dauruü̃gü ga nüxü̃ daugüxü̃ ga ṯacü na nüxü̃ ngupetüxü̃ ga guma yatü ga ngoxoã̱xchirécü rü ṯacü nüxü̃ na ngupetüxü̃ ga yema cuchigü, rü yema nixĩ ga togü ga duü̃xü̃gümaã nüxü̃ ixugüexü̃ ga guxü̃ma ga yema ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Rü yexguma yemaxü̃ naxĩnüẽgu ga duü̃xü̃gü, rü inanaxügüe ga Ngechuchuxü̃ na nacèèxü̃güxü̃ ga na ínaxũxü̃xü̃cèx ga yema naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Rü yexguma wenaxãrü nguegu yaxüegu ga Ngechuchu, rü guma yatü ga ngoxoã̱xchirécü, rü nüxü̃ nacèèxü̃ na Ngechuchuwe naxũxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Natürü ga Ngechuchu rü tama nanaxwèxe, rü ñanagürü nüxü̃: —¡Cuchiü̃wa naxũ rü cutanüxü̃maã nüxü̃ yarüxu i guxü̃ma i ngẽma cuxcèx naxüxü̃ ya Cori ya Tupana, rü ñuxãcü nüxü̃́ na cungechaü̃tümüü̃xü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Rü nüma ga guma yatü rü ínixũ. Rü inanaxügü ga guxü̃ma ga Decaporíchiuanewa yexmagüne ga ĩãnegüwa nüxü̃ na yaxuxü̃ ga yema Ngechuchu naxcèx üxü̃. Rü guxü̃ma ga duü̃xü̃gü rü naḇaixãchiãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Rü yexguma nguegu naxtaxaarü tocutüwa nataegugu ga Ngechuchu, rü muxü̃ma ga duü̃xü̃gü rü naxcèx yéma nangutaquẽ́xegü. Rü nüma rü naxtaapechinüwa nayexma. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Rü yexguma yéma nayexmayane, rü yéma naxü̃tawa nangu ga ngutaquẽ́xepataü̃ãrü ãẽ̱xgacü ga Yáirugu ãe̱gacü. Rü yexguma Ngechuchuxü̃ nadèu̱xgu, rü napẽ́xegu nanangücuchi. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Rü poraãcü nüxü̃ nacèèxü̃, rü ñanagürü nüxü̃: —Chauxacü rü ituraxüchi. Rü chanaxwèxe i nge̱ma cuxũ na ngĩxü̃ cuyarüngõgüxü̃cèx na ngĩxcèx yataanexü̃cèx rü namaxü̃xü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Rü yexguma ga Ngechuchu rü nawe narüxũ. Rü muxü̃ma ga duü̃xü̃gü ínayaxümücügü. Rü yéma nayaxũxtügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Rü yema muxü̃ ga duü̃xü̃gütanüwa iyexma ga wüxi ga nge ga 12 ga taunecü iḏaawecü namaã ga na naxãgüechaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Rü muxü̃ma ga duturugü ngĩxü̃ naxüxü̃gü rü poraãcü ngúxü̃ ngĩxü̃ ningexẽẽgü. Rü yemaãcü natücèxma ngĩxü̃ igu̱xẽẽ ga gu̱xcü ga ngĩrü dĩẽru. Natürü tama ngĩxcèx nitaanee̱ga, rü niyexeraguchigüama ga ngĩrü ḏaawe. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Rü ü̃paacü togüèxwa Ngechuchuchigaxü̃ ixĩnü. Rü yemacèx yéma ixũ. Rü natanüwa ga yema muxü̃ma ga duü̃xü̃gü rü Ngechuchuweama ne ixũ rü naxchirugu iyangõgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Yerü ñaxü̃gu irüxĩnü: —Ngẽxguma chi naxchiruxü̃mare chingõgügu, rü chi chauxcèx nitaane —ñaxü̃gu iruxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Rü yexgumatama ínayachaxãchi ga ngĩgü, rü nüxü̃ iyacuèxãchi ga ngĩxĩnewa ga na ngixcèx yataanexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Natürü ga Ngechuchu rü nüxü̃ nicuèxãchi ga na nawa ínaxũxü̃xü̃ ga pora. Rü naxcèx nadauegu ga yema muxü̃ma ga duü̃xü̃gü, rü nüxna naca, rü ñanagürü: —¿Texé tixĩ ya chauxchirugu ingõgüxe? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rü norü ngúexü̃gü nanangãxü̃gü, rü ñanagürügü: —Cuma nüxü̃ cudau i ñuxre i duü̃xü̃gü nge̱ma cuxü̃ na yaxũtügüxü̃ rü ngẽxguma rü ta: “¿Texé ya choxü̃ ingõgüxe?” ñacuxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Natürü ga Ngechuchu rü nüxü̃ nidaugüãchiama na tüxü̃ nadauxü̃cèx ga na texé na tiĩxü̃ ga guxema nüxü̃ ingõgüxe. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Rü yexguma ga yema nge rü ngĩrü muü̃maã yadu̱ru̱xãcüma naxü̃tawa ingu, yerü nüxü̃ icuèx ga ṯacü na ngĩxü̃ ngupetüxü̃. Rü napẽ́xegu iyacaxã́pü̱xü, rü aixcümaxü̃chi namaã nüxü̃ iyaxu ga guxü̃ma. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Rü nüma ga Ngechuchu rü ñanagürü ngĩxü̃: —Pa Chauxacüx, curüme erü cuyaxõ. ¡Rü taãẽãcüma íixũ, erü marü naxüxü̃ i curü ḏaawe! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Rü yexguma íyadexayane, yéma nangugü ga ñuxre ga natanüxü̃gü ga guma ngutaquẽ́xepataü̃ãrü ãẽ̱xgacü rü ñanagürügü nüxü̃: —Cuxacü rü marü iyu. ¿Tü̱xcüü̃ nüxü̃ cuchixeweecha ya Ngúexẽẽruü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Natürü ga Ngechuchu rü tama nüxü̃ nacuáxchaü̃ ga yema duü̃xü̃güarü dexa. Rü yemacèx guma ngutaquẽ́xepataü̃ãrü ãẽ̱xgacüxü̃ ñanagürü: —¡Tãxṹ i cumuü̃xü̃, rü yaxõmare! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Rü yexguma ga Ngechuchu rü ínayagagü ga Pedru rü Chaü̃tiágu rü Cuáü̃ ga Chaü̃tiágueneẽ. Natürü tama nanaxwèxe na texé ga togue nawe rüxĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Rü yexguma guma ngutaquẽ́xepataü̃ãrü ãẽ̱xgacüpatawa nangugügu, rü Ngechuchu nüxü̃ nadau ga na íyacuxcuxü̃ rü poraãcü aita naxüeãcüma naxauxexü̃ ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Rü guma ĩpatagu naxücu ga Ngechuchu, rü ñanagürü: —¿Tü̱xcüü̃ ípicuxcu rü ngẽmaãcü pexauxe? Ngẽma bucü rü tama iyu. Rü ipemare —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Rü nüxü̃ nacugüecüraxü̃ãma ga duü̃xü̃gü. Natürü nüma ga Ngechuchu rü ĩã̱xtüwa nanamugü ga guxü̃ma. Rü yema bucünatücèx naca rü ngĩẽ, rü yema namücügü, rü namaã nixücu ga ínayexmaxü̃wa ga yema bucü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Rü ngĩxmẽ́xgu nayayauxãchi, rü ñanagürü ngĩxü̃: —Tarita cumi —ñanagürü. Rü ngẽma ore rü ñaxü̃chiga nixĩ: “¡Inachi, Pa Bucü, ñacharügü cuxü̃!” ñaxü̃chiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Rü yexgumatama ga yema bucü ga 12 ga taunecü ngĩxü̃́ yexmèxcü, rü íirüda rü iyaxũ. Rü poraãcü naḇaixãchiãẽgü ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Natürü ga Ngechuchu rü poraãcü nüxna nanachu̱xu na taxúemaãma nüxü̃ yaxugüexü̃cèx ga yema ngupetüxü̃. Rü ñu̱xũchi nanamu na ngĩxü̃ naxüwemügüxü̃cèx ga yema bucü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Rü yéma inaxũãchi ga Ngechuchu, rü guma ĩãne ga Nacharétu ga nawa nayaxü̃newatama naxũ. Rü norü ngúexü̃gü rü nawe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Rü yexguma ngü̃xchigaarü ngunexü̃wa nanguxgu rü inanaxügü ga na nangúexẽẽtaexü̃ ga ngutaquẽ́xepataü̃wa. Rü yema muxü̃ma ga duü̃xü̃gü ga yéma irüxĩnüẽxü̃, rü naḇaixãchiãẽgü. Rü nügüna nacagüe rü ñanagürügü: —¿Ngextá naxcèx nangu̱x i guxü̃ma i ngẽma ngu̱xẽẽtae? ¿Rü ngextá nanayaxu i ngẽma cuèx? ¿Rü ñuxãcü nanaxü i ngẽma mexü̃gü i taxü̃gü i naxüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","—¿Taux ẽ́xna ñaã yiĩxü̃ i carpinteru i Ngechuchu, i Maríane, ya Chaü̃tiágu rü Yúche rü Chimáũ rü Yudaẽneẽ ixĩcü? ¿Rü taux ẽ́xna i naẽyèxgü rü nuxma tatanügu naxãchiü̃güxü̃? —ñanagürügü. Rü yemacèx ga yema duü̃xü̃gü rü tama naga naxĩnüẽchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —Wüxi i Tupanaãrü orearü uruü̃ rü guxü̃wama i duü̃xü̃gü rü nüxü̃ nangechaü̃gü. Natürü norü ĩãnewatama rü natanüxü̃gütanüwatama rü napatawatama rü tama aixcüma nüxü̃ nangechaü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Rü yemacèx taxuacüma yéma nanaxü ga muxü̃ma ga mexü̃gü ga Tupanaãrü poramaã naxüxü̃. Rü noxretama ga duü̃xü̃gü ga iḏaaweexü̃xü̃xĩcatama ningõgü rü naxcèx nayataanexẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Rü naḇaixãchiãẽ ga Ngechuchu, yerü yema duü̃xü̃gü rü tama nüxü̃́ nayaxõgü. Rü Ngechuchu rü guma ngaicamagüne ga ĩãnexãcügügu nixũgüchigü, rü nayangúexẽẽtanü ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Rü naxcèx naca ga yema 12 ga norü ngúexü̃gü, rü inanaxügü ga na namuãxü̃ ga taxrechigü. Rü nüxna nanaxã ga pora na ínawoxü̃ãxü̃cèx ga ngoxogü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Rü nüxna naxãga ga na taxuxü̃ma íyangegüxü̃cèx ga norü namawaxü̃, rü bai ga choca rü bai ga pãũ rü bai ga norü dĩẽru. Rü nanaxwèxe ga naxnetüxü̃xĩcatama na íyangegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Rü namaã nüxü̃ nixu na nacuaixcuxü̃ ga norü chapatu. Natürü tama nanaxwèxe ga taxre ga naxchiru na íyangegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Rü ñanagürü nüxü̃: —Rü ngẽxguma wüxi ya ĩãnewa wüxi ya ĩgu pechocuxgu, ¡rü ngẽxma pepegü ñu̱xmata pema ñuxgu nge̱ma ipexĩãchi̱x nawa ya yima ĩãne! ");
INSERT INTO tcaNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","—Rü ngẽxguma ngexnerüǘne ya ĩãnewa tama meã pexü̃ nayauxgüchaü̃gu rü tama pexü̃́ inaxĩnüẽchaü̃gu, ¡rü ípechoxü̃ i nge̱ma! Rü ngẽxguma ipexĩãchigu, ¡rü ipenapagü i perü üxaxü̃cutü na ngẽmawa nüxü̃ nacuèxgüxü̃cèx na nataxüchixü̃ tá i norü poxcu i ngẽxguma nagu̱xgu i naãne! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Rü yexguma inaxĩãchi ga norü ngúexü̃gü. Rü duü̃xü̃gümaã nüxü̃ nixugüe ga na nüxü̃ naxoexü̃cèx ga nacüma ga chixexü̃ rü Tupanacèx na nadaugüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Rü ínanawoxü̃ ta ga muxü̃ma ga ngoxogü. Rü chixü̃maã yachagüãcüma nanameẽxẽẽ ga muxü̃ma ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rü Ngechuchuchigaxü̃ naxĩnü ga ãẽ̱xgacü ga Erode, yerü guxü̃wama duü̃xü̃gü poraãcü nachiga nidexagü. Rü yexguma ga Erode rü ñanagürü: —Rü ngẽma Ngechuchu nixĩ i Cuáü̃ i baiü̃xẽẽruü̃ ixĩxü̃ rü wena namaxü̃, rü ngẽmacèx nixĩ i nüxü̃́ nangẽxmaxü̃ i pora na naxüãxü̃cèx i ngẽma taxü̃ i mexü̃ i Tupanaãrü poramaã naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Natürü ga togü rü ñanagürügü: —Nuxcümaü̃cü ga orearü uruü̃ ga Ería nixĩ —ñanagürügü. Rü togü rü ñanagürügü: —Wüxi i Tupanaãrü orearü uruü̃ i nuxcümaü̃güxü̃rüü̃ nixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Natürü yexguma yemaxü̃ naxĩnügu ga Erode, rü ñanagürü: —Rü ngẽma Ngechuchu nixĩ i Cuáü̃ ga chorü churaragüxü̃ chidayenaxãxẽẽchiréxü̃, rü ñu̱xma rü wenaxãrü namaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Rü yema ñanagürü ga Erode yerü marüchirẽ́x Cuáü̃xü̃ niyaxu rü poxcupataü̃gu cadenamaã nayachota. Rü yemaãcü nanaxü ngĩgagu ga naxmèx ga Erodía ga naẽneẽ ga Piripimèxchirẽ́x ixĩcü ga ngĩxü̃ napucü ga Erode. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yerü ü̃paacü ga Cuáü̃ rü Erodemaã ñanagürü: —Tama name i cuxmèxü̃ cuyaxĩxẽẽ i cueneẽmèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Rü yemacèx ga Erodía rü poraãcü Cuáü̃chi ixai rü inaxwèxe ga na yamáãxü̃, natürü poraãcü ngĩxü̃́ naguxcha. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Yerü ngĩte ga Erode rü Cuáü̃xü̃ namuü̃, yerü nüxü̃ nacuèxchirẽ́x na wüxi ga yatü ga mecü rü üünecü na yiĩxü̃, rü yemacèx nixĩ ga nae̱tüwa nachogüxü̃. Rü yexguma Cuáü̃ãrü orexü̃ naxĩnügu ga Erode, rü naxoegaãẽ, natürü meã nüxü̃́ inarüxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Natürü wüxi ga ngunexü̃ nawa nangu na ngĩxü̃́ natauxchaxü̃ na yamáãxü̃cèx ga Cuáü̃, ga yexguma Erodearü taunecüarü ngunexü̃wa nanguxgu rü wüxi ga peta ga taxü̃ naxü̱xgu naxcèx ga norü ñatügumaẽgüxü̃ ga ãẽ̱xgacügü, rü norü churaragüarü ãẽ̱xgacügü rü yema Gariréaanecü̱̃ã̱x ga corigü ga taxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Rü yema petawa iyaxücu ga Erodíaxacü, rü yema petatanüxü̃pẽ́xewa íyañaãchixü̃chigüxü̃. Rü poraãcü norü me iyixĩ ga Erode rü norü petatanüxü̃gü. Rü yemacèx ga nüma ga ãẽ̱xgacü ga Erode rü ñanagürü ngĩxü̃ ga yema pacü: —¡Choxna naxcèx naca i ṯacü i cunaxwèxexü̃, rü tá cuxna chanaxã! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Rü aixcümaxü̃chi ngĩmaã inaxuneta, rü ñanagürü: —Ngẽxü̃rüüxü̃ i ṯacü i choxna naxcèx cuc̱axü̃ rü tá cuxna chanaxã, woo ngãxü̃gu i chorü naãne yixĩgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Rü nüxna iyaxũgachi, rü ngĩẽna iyaca, rü ngĩgürügü: —¿Ṯacü i cunaxwèxexü̃ na naxcèx íchac̱axü̃? —Ngĩgürügü. Rü ngĩẽ ngĩxü̃ ingãxü̃, rü ngĩgürügü: —¡Naxcèx ínaca i Cuáü̃ ya baiü̃xẽẽruü̃ẽru! —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Rü yexgumatama ga yema pacü rü paxa iyaxücu ga ãẽ̱xgacüxü̃tawa rü ngĩgürügü: —Chanaxwèxe i ñu̱xmatama paxa wüxi ya poratugu choxna cunaxã i Cuáü̃ ya baiü̃xẽẽruü̃ẽru —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rü nüma ga ãẽ̱xgacü rü poraãcü inayarümaãchi, natürü yema norü petatanüxü̃pẽ́xewa marü ngĩmaã na inaxunetaxü̃cèx, rü tama ngĩxü̃ nawomüxẽẽchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Rü yemacèx ga Erode rü yexgumatama yéma ínapoxcuxü̃wa nanamu ga wüxi ga churara na naxü̃tawa nangeaxü̃cèx ga Cuáü̃ẽru. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Rü poxcupataü̃wa naxũ ga yema churara, rü Cuáü̃xü̃ nidaeru. Rü wüxi ga poratugu ãẽ̱xgacüxü̃tawa nanange ga yema naẽru. Rü yema pacüna nanaxã. Rü ngĩma rü ngĩẽna iyaxã. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Rü yexguma yemaxü̃ nacuáchigagügu ga norü ngúexü̃gü ga Cuáü̃, rü yéma poxcupataü̃wa nayayauxgü ga naxü̃ne, rü inayatèxgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Rü yemawena rü yema norü ngúexü̃gü ga yamugüxü̃ rü Ngechuchumaã nangutaquẽ́xegü. Rü namaã nüxü̃ nixugüe ga guxü̃ma ga yema naxügüxü̃ rü yema nangu̱xẽẽtaegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Rü Ngechuchu rü ñanagürü nüxü̃: —¡Nuã pexĩ, rü ngĩxã, wüxi i nachica i ngextá taxúema íxãpataxü̃wa taxĩ, na paxaãchi ngẽxma yarüngü̃güxü̃cèx! —ñanagürü. Rü yema ñanagürü yerü namu ga duü̃xü̃gü ga yéma ingugütanücüüxü̃ rü woeguxü̃ ga togü. Rü yemacèx ga Ngechuchu rü norü ngúexü̃gü rü woo na nachibüexü̃cèx rü nangechicagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Rü yemacèx wüxi ga nguegu nichoü̃, rü noxrüwama wüxi ga nachica ga taxúema íxãpataxü̃wa naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Natürü muxü̃ma ga duü̃xü̃gü nüxü̃ nadaugü ga yexguma inaxĩãchigu, rü nüxü̃ nacuèxgü ga texégü na yiĩxü̃. Rü yemacèx guxü̃ne ga guma ĩãnegücü̱̃ã̱x ga duü̃xü̃gü, rü dauxchitagu nibuxmü rü napẽ́xegu nayayi. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Rü yexguma nguewa ínaxüegu ga Ngechuchu, rü nüxü̃ nadau ga yema muxü̃ma ga duü̃xü̃gü. Rü nüxü̃́ nangechaü̃tümüü̃gü yerü ñoma carnerugü ga ngearü dauruü̃ã̱xgüxü̃rüü̃ nixĩgü. Rü inanaxügü ga na nangúexẽẽãxü̃ ga muxü̃ma ga norü ore. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Rü yexguma marü nayáuanegu, rü norü ngúexü̃gü rü naxcèx naxĩ, rü ñanagürügü: —Marü nayáuanexü̃chi rü ñaã rü wüxi i nachica i taxúema nagu ãpataxü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","—Rü ngẽmacèx name nixĩ i ícuyamugü i duü̃xü̃gü na namapechinüwa ipeagüxü̃ i duü̃xü̃güxü̃tawa rü ĩãnexãcügü ya ngaicamagünewa naxĩxü̃cèx na nge̱ma norü õnacèx yataxegüxü̃cèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Natürü ga Ngechuchu rü nanangãxü̃, rü ñanagürü nüxü̃: —¡Pematama penaxüwemü! —ñanagürü. Rü nümagü nanangãxü̃gü rü ñanagürügü: —¿Ẽ́xna cunaxwèxe i 200 tachinü i dĩẽru naguxü̃ i pãũcèx nüxü̃́ tayataxexü̃ na ngẽmamaã tanachibüexẽẽxü̃cèx? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¿Ñuxre i pãũ pexü̃́ nangẽxma? ¡Rü ípeyadèu̱x! —ñanagürü. Rü yexguma íyadaugüãgu, rü ñanagürügü nüxü̃: —Toxü̃́ nangẽxma i wüximẽ́ẽ̱xpü̱x i pãũ rü taxre i choxni —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Rü yexguma ga Ngechuchu rü duü̃xü̃güxü̃ namu na ñuxrechigü nügüxü̃tawa rütogüxü̃cèx ga maxẽtẽ́xewa. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rü ínarütogü ga 100 chigü rü 50 chigü ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Rü yexguma ga Ngechuchu rü nanade ga yema wüximẽ́ẽ̱xpü̱x ga pãũ rü yema taxre ga choxni. Rü daxũguxü̃ ga naãnegu nadawenüãcüma Tupanana moxẽ naxã. Rü inanabücu ga yema pãũ, rü norü ngúexü̃güna nanana na yema duü̃xü̃güxü̃ yanuãxü̃cèx. Rü yema taxre ga choxni rü ta guxü̃ma ga yema duü̃xü̃güxü̃ nüxü̃ nayanuxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Rü guxü̃ma nachibüe ñu̱xmata meãma nüxü̃́ yangu. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Rü yemawena rü 12 ga pexchigü nanapagüamatama namaã ga yema pãũ rü choxni ga íyaxügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Rü yema yéma pãũgü ngõ̱xgüxü̃ rü 5000 ga yatügü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Rü yemawena ga Ngechuchu rü duü̃xü̃güxü̃ íyamugüyane rü wüxi ga nguegu nayachoü̃xẽẽ ga norü ngúexü̃gü na yoxni naxtaxaarü tocutüwa Bechaídawa naxĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Rü yexguma duü̃xü̃güxü̃ íyamugüguwena, rü mèxpǘnewa naxũ ga Ngechuchu na yéma yayumüxẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Rü yexguma marü nachütagu, rü naxtaxaarü ngãxü̃tüwa nayexmagü ga norü ngúexü̃gü. Rü Ngechuchu rü nüxĩcatama dauxchitawa nayaxü̃ãchi. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Rü nüxü̃ nadau na guxchaxü̃ãcüma yaxãgüxü̃ ga norü ngúexü̃gü, yerü ga buanecü rü nawaama nabuxuchi. Rü yexguma marü yangunechaü̃gu, rü Ngechuchu rü dexáétügu nawe narüxũ. Natürü ñoma nüxü̃ naxüpetüchaü̃xü̃rüü̃ nügü nixĩxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Rü yexguma norü ngúexü̃gü nüxü̃ daugügu ga dexáétügu na yaxũxü̃, rü nagu narüxĩnüẽ ga wüxi ga naxchi̱ximare na yiĩxü̃. Rü yemacèx aita naxüe, yerü guxü̃ma nüxü̃ nadaugü rü poraãcü naḇaixãchiãẽgü. Natürü yexgumatama ga Ngechuchu rü namaã nidexa rü ñanagürü nüxü̃: —¡Peporae! Rü chomachirẽ́xtama chixĩ. ¡Tãxṹ i pemuü̃ẽxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","52","Rü nguegu nixüe, rü inarüxó ga buanecü. Natürü nümagü ga norü ngúexü̃gü rü naḇaixãchiãẽgümare yerü woo nüxü̃ na nadaugüxü̃ ga yema mexü̃ ga Tupanaãrü poramaã naxüxü̃ ga Ngechuchu ga yexguma yema pãũ yamuxẽẽgu, natürü tama nüxna nacuè x-ãchie na Tupana Nane na yiĩxü̃ yerü nüxü̃́ naguxcha na yaxõgüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Rü yexguma marü yanguü̃gu ga naxtaawa, rü Yenecharétuanewa nangugü. Rü yexma naxãnacügu nanangaxü̃gü ga naweü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Rü yexguma nguewa ínachoü̃gu, rü yexgumatama ga duü̃xü̃gü rü nüxü̃ nicuèxãchitanü ga Ngechuchu na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Rü yema naãnewa rü guxü̃ne ga ĩgüwa nabuxmü ga yema duü̃xü̃gü. Rü yexguma nüxü̃ nacuèxgügu ga ngextá na nayexmaxü̃ ga Ngechuchu, rü yéma norü caruü̃gügu naxcèx nanagagü ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Rü guxü̃wama ga ngextá íyanguchigüxü̃wa ga Ngechuchu, ga ĩãnexãcügüwa rü ĩãnegü ga itaxü̃newa, rü ĩãnepechinüwa, rü yexma ítamü̃pechinügu naxcèx nayamugü ga iḏaaweexü̃. Rü nüxü̃ nacèèxü̃gü na tama nüxna nachúxãxü̃cèx na naxchirupechinügumare yangõgügüxü̃cèx. Rü guxü̃ma ga yema nüxü̃ ingõgüexü̃, rü naxcèx nitaanegü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Rü Ngechuchucèx naxĩ ga Parichéugü namaã ga ñuxre ga ngúexẽẽruü̃gü ga mugüwa ngu̱xẽẽtaegüxü̃ ga Yerucharéü̃wa ne ĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Rü yexguma ñuxre ga Ngechuchuarü ngúexü̃güxü̃ nadaugügu ga tama Yudíugücüma na yanguxẽẽgüxü̃, rü tama Yudíugü yauxmẽ́xgüxü̃rüü̃ na nayauxmẽ́xgüxü̃ naxü̃pa na nachibüexü̃, rü chixri nachiga nidexagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yerü nümagü ga Parichéugü rü guxü̃ma ga togü ga Yudíugü rü nagu naxĩ ga norü o̱xigücüma na nayauxmẽ́xiraxü̃ na yemaãcü Tupanapẽ́xewa nügü yamexẽẽgüxü̃ naxü̃pa ga na nachibüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Rü ngẽxguma taxepataü̃wa ne naxĩxgu ga nümagü rü tama nachibüe ega tama ngẽmaãcü nügü nayauxmẽ́xiragu. Rü nangẽxma i muxü̃ma i togü i nuxcümaü̃xü̃ i nacümagü. Rü ngẽmacèx nagu naxĩ i ngẽma nacümagü na Tupanacèx nayauxgüãxü̃ i norü pochiyugü rü basugü rü paneragü rü pechicaxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rü yemacèx ga yema Parichéugü rü ngúexẽẽruü̃gü rü Ngechuchuna nacagü, rü ñanagürügü: —¿Tü̱xcüü̃ i curü ngúexü̃gü i tama nagu naxĩxü̃ i ngẽma tórü o̱xigücüma rü tama toma tayauxmẽ́xgüxü̃rüü̃ nayauxmẽ́xgüxü̃ naxü̃pa na nachibüexü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Natürü Ngechuchu nanangãxü̃ rü ñanagürü: —Pa Duü̃xü̃gü ya Pegü Naxaixcümaraü̃güxe, rü aixcüma pechiga nixĩ ga yema ore ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ichaxía ümatüxü̃ ga ñaxü̃: “Ñaã duü̃xü̃gü rü naã̱xmaãmare choxü̃ nicuèxüü̃gü, natürü naãẽwa rü tama chaugu narüxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Rü taxuwama name na ngẽmaãcü natücèxma choxü̃ yacuèxüü̃güxü̃. Erü guxü̃ma i ngẽma norü ngu̱xẽẽtae rü yatügüarü mugümare nixĩ, rü tama aixcüma chorü mu nixĩ”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","—Rü pema i ñu̱xma rü aixcüma nüxü̃ perüxoe i Tupanaãrü mugü na nagu pexĩxü̃cèx i ngẽma duü̃xü̃gücümamare ixĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Rü yexgumarüü̃ ta ñanagürü nüxü̃: —Pema rü penangexrü i Tupanaãrü mugü na pecümagügutama pexĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","—Yerü ga Moĩché rü ñanagürü: “¡Tüxü̃ nangechaü̃ ya cunatü rü cue!” ñanagürü. Rü ñanagürü ta: “Texé ya tümanatümaã rü ẽ́xna tümaẽmaã chixexü̃ ixugüxe, rü ãẽ̱xgacü tá tümamaã nanaxuegu na tayuxü̃cèx”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","—Natürü pema rü ñaperügügü: “Marü name ega wüxi ya yatü nanatüxü̃ rü naẽxü̃ ñaxgu: ‘Taxucürüwama chorü ngẽmaxü̃maã cuxü̃ charüngü̃xẽẽ, erü guxü̃ma i chorü ngẽmaxü̃ rü marü Tupanana chanaxã’,” ñaxgu. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","—Rü ngẽxguma texé ngẽma ñagügu, rü pexcèx rü marü namexü̃ na tama tümanatüxü̃ rü tümaẽxü̃ tarüngü̃xẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","—Rü ngẽmaãcü ipeyanaxoxẽẽ i Tupanaãrü mugü, na nagu pexĩxü̃cèx i pecümagütama i togüwa pexüexẽẽxü̃. Rü ngẽxgumarüü̃ ta muxü̃ma i to i pecümagü i ngẽmarüü̃ ixĩxü̃gu pexĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Rü yexgumawena duü̃xü̃gücèx naca ga Ngechuchu, rü ñanagürü nüxü̃: —¡Meã choxü̃́ iperüxĩnüẽ, rü nüxü̃ pecuá i ñaã chorü ore! ");
INSERT INTO tcaNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","—Rü taxuü̃ma i ṯacü i düxétüwa ne ũxü̃ rü taèxwa ixücuxü̃ nixĩ i Tupanapẽ́xewa tüxü̃ chixexẽẽxü̃. Natürü ngẽma taãẽwa ne ũxü̃, rü ngẽma waxi nixĩ i tüxü̃ chixexẽẽxü̃ i Tupanapẽ́xewa. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","—Rü ngẽxguma pixãchi̱xẽgu, ¡rü nüxü̃ pexĩnüẽ i ngẽma ore! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Rü yexguma Ngechuchu duü̃xü̃güna ixũgachigu rü ĩpatagu naxücuxgu, rü norü ngúexü̃gü nüxna nacagü nachiga ga yema ngu̱xẽẽtae. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Rü nüma rü ñanagürü nüxü̃: —¿Pema rü ta ẽ́xna tama nüxü̃ pecuèxéga i ngẽma? ¿Ẽ́xna tama i nüxü̃ pecuáxü̃ na taxuü̃ma i ṯacü i düxétüwa ne ũxü̃ rü taèxwa ixücuxü̃ yiĩxü̃ i Tupanapẽ́xewa tüxü̃ chixexẽẽxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","—Erü guxü̃ma i ngẽma düxétüwa ne ũxü̃ rü taèxwa ixücuxü̃, rü tama taãẽwa nangu. Natürü taanüwa naxũmare na yixcama taxünewa ínaxũxü̃xü̃cèx —ñanagürü. Rü yemaãcü nüxü̃ nixu na guxü̃ma i õna rü namexü̃ na nangṍxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Rü ñanagürü ta: —Rü ngẽma duü̃xü̃ãẽwa ne ũxü̃, rü ngẽma waxi nixĩ i Tupanapẽ́xewa nachixexẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","—Erü norü aixepewa i naãẽwa nixĩ i ne naxũxü̃ i muxü̃ma i chixexü̃gü. Rü ngẽma nixĩ i chixexü̃gu na naxĩnüxü̃, rü naxü̃neãrü ngúchaü̃we na naxũxü̃, rü na nangĩ́xü̃, rü na namáẽtaxü̃, rü naĩ i ngemaã na inapexü̃, rü togüarü ngẽmaxü̃ na nüxü̃́ nanguchaü̃xü̃, rü chixexü̃ na naxüxü̃, rü na yadoratèxáxü̃, rü chixexü̃ i nacümagügu na naxã́ũxü̃, rü na yaxãũxãchiwèxexü̃, rü na naxoregütèxáxü̃, rü nügü na yacuèxüü̃xü̃, rü tama meã naãẽxü̃ na nacuáxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","—Rü guxü̃ma i ngẽma chixexü̃gü rü duü̃xü̃ãrü aixepewa nixĩ i ne naxĩxü̃, rü ngẽma nixĩ i Tupanapẽ́xewa nachixexẽẽxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Rü yemawena rü ĩãne ga Tiru nawa yexmaxü̃ ga naãnewa naxũ ga Ngechuchu. Rü yéma wüxi ga ĩpatawa nangu, natürü tama nanaxwèxe na texé nüxü̃ cuáxü̃ ga yéma na nanguxü̃. Natürü taxuacüma nügü inicu̱x. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Rü paxama nüxü̃ icuáchiga ga wüxi ga nge ga ngĩxãcüwa ngoxo yexmèxcü. Rü yéma ixũ, rü Ngechuchupẽ́xegu iyacaxã́pü̱xü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Rü yema nge rü to ga nachiü̃ãnecü̱̃ã̱x ga Chiropeníchiucü̱̃ã̱x iyixĩ. Rü Ngechuchucèx iyaxũ, rü nüxü̃ icèèxü̃ na ngĩxãcüwa ínatèxüchiãxü̃cèx ga yema ngoxo. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Natürü ga Ngechuchu rü ñanagürü ngĩxü̃: —Name nixĩ i taxacügüxü̃xĩra tachibüexẽẽ. Erü tama name i taxacügüna tanayaxu i norü õna na airugüna naxãxü̃cèx —ñanagürü. Rü yema ñanagürü yerü nümagü ga Yudíugü rü nügü nixugüe na Tupanaxãcügüxüchi yixĩgüxü̃ rü yema togü rü ñoma airugürüü̃ na yixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Natürü ngĩma ga yema nge rü inangãxü̃, rü ngĩgürügü: —Aixcüma nixĩ i curü ore, Pa Corix, natürü woo airugü rü ta nanangõ̱x i ngẽma õnatüchi i mechatüü̃gu nayixẽẽxü̃ i ngẽma ĩpataarü yoraxacügü —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Rü yexguma ga Ngechuchu rü ñanagürü ngĩxü̃: —Aixcüma name nixĩ i ngẽma nüxü̃ quixuxü̃. Rü marü name i cutaegu, erü ngẽma ngoxo rü marü ínaxũxũ ngĩwa i cuxacü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Rü yexguma ngĩpatawa nanguxgu ga yema ngecü, rü yema ngĩrü ngürücarewa ngĩxü̃ iyanguéü̃ ga ngĩrü bucü. Natürü marü ngĩxna ínaxũxũ ga yema ngoxo. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Rü Tiruanewa nataegu ga Ngechuchu. Rü Chidã́ũãrü ĩãnewa naxüpetü, rü ñu̱xũchi Decaporíchiuaneãrü ĩãnegüwa rü ta naxüpetü rü ñu̱xmata Gariréaaneãrü naxtaawa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Rü yéma naxü̃tawa nanagagü ga wüxi ga yatü ga ngauchi̱xẽcü rü moxü̃cü, rü nüxna naxcèx nacagü ga nüxü̃ na yangõgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Rü yexguma ga Ngechuchu rü noxrüwama duü̃xü̃güna nanaga. Rü naxmachi̱xẽgu nixuxmẽ́x, rü naxbü̱xágümaã nügü yawaixmẽ́xẽẽãcüma norü conügu ningõgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Rü yemawena rü daxũ nadawenüãcüma yaxna narüngü̃, rü guma yatüxü̃ ñanagürü: —Epéta —ñanagürü. Rü ngẽma rü: “¡Ingoxna!” ñaxü̃chiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Rü yexgumatama ningo̱xnamachi̱xẽ ga guma ngauchi̱xẽcü, rü norü conü rü marü narüme rü meã nidexa. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Rü Ngechuchu rü duü̃xü̃güxü̃ namu na taxúemaãma nüxü̃ yaxugüexü̃cèx. Natürü yexguma yexeraãcü duü̃xü̃güna nachúxãgu ga na taxúemaãma nüxü̃ yaxugüexü̃cèx ga nachiga rü yexeraãcü nüxü̃ nixugüeama. ");
INSERT INTO tcaNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Rü poraãcü naḇaixãchiãẽgü ga duü̃xü̃gü, rü ñanagürügü: —Meãma nanaxü i guxü̃ma rü woo ngauchi̱xẽgüxü̃ rü nayango̱xnamachi̱xẽgüxẽẽ, rü ngeèxgüxü̃ rü nayadexagüxẽẽ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Rü wüxi ga ngunexü̃gu wenaxãrü naxcèx naxĩtaquẽ́xe ga muxü̃ma ga duü̃xü̃gü, rü nüxü̃́ nataxuma ga norü õnagü. Rü Ngechuchu rü norü ngúexü̃gücèx naca, rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Choxü̃́ nangechaü̃tümüü̃gü i ñaã duü̃xü̃gü, erü marü tomaẽ̱xpü̱x i ngunexü̃ nuã chauxü̃tawa nangẽxmagü, rü nataxuma i nawemü i nango̱xgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","—Rü ngẽxguma chi ngẽmaãcümare íchayamugügu, rü chi ngürüãchi namagu tá nayaturae, erü nümaxü̃gü rü yaxü̃wama ne naxĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Rü norü ngúexü̃gü rü nanangãxü̃gü, rü ñanagürügü: —¿Natürü ñuxãcü tá tanachibüexẽẽ i núma i ngextá taxúema íxãpataxü̃wa? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Rü Ngechuchu nüxna naca, rü ñanagürü: —¿Ñuxre i pãũ pexü̃́ nangẽxma i pemax? —ñanagürü. Rü nümagü nanangãxü̃gü, rü ñanagürügü: —Toxü̃́ nangẽxma i 7 i pãũ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Rü ñu̱xũchi ga Ngechuchu rü duü̃xü̃güxü̃ namu na ñaxtüanewa natogüxü̃cèx. Rü nanade ga yema 7 ga pãũ, rü Tupanana moxẽ naxã. Rü ñu̱xũchi inanabücu, rü norü ngúexü̃güna nanana. Rü nümagü rü duü̃xü̃güxü̃ nayanu. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Rü nüxü̃́ nayexma ta ga ñuxre ga choxnixãcügü. Rü Ngechuchu rü Tupanana moxẽ naxã, rü ñu̱xũchi norü ngúexü̃güxü̃ namu na iyanuãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Rü guxü̃ma ga yema duü̃xü̃gü rü meãma nachibüe ñu̱xmata meã nüxü̃́ yangu. Rü yexguma rü ta 7 ga pexchi nanapagü namaã ga yema íyaxügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Rü yema duü̃xü̃gü ga yéma chibüexü̃ rü maneca 4000 nixĩ. Rü yemawena ga Ngechuchu rü duü̃xü̃güxü̃ ínimugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Rü ñu̱xũchi wüxi ga nguegu nixüe namaã ga norü ngúexü̃gü, rü Damanútaanewa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Rü Ngechuchuxü̃tawa nangugü ga Parichéugü, rü inanaxügüe ga na namaã yaporagatanücüüxü̃. Rü nüxna nacagüe na nüxü̃ nüxü̃ nadauxẽẽxü̃cèx ga wüxi ga cuèxruü̃ ga Tupanaãrü poramaã naxüxü̃, na yemaãcü nüxü̃ naxügüxü̃cèx, rü nüxü̃ nacuèxgüxü̃cèx ngoxi aixcüma Tupana Nane yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Rü Ngechuchu rü poraãcü yaxna narüngü̃, rü ñanagürü: —¿Tü̱xcüü̃ i ñaã duü̃xü̃gü naxcèx ínacagü i wüxi i cuèxruü̃ i Tupanaãrü poramaã üxü̃? Rü aixcüma pemaã nüxü̃ chixu rü bai i wüxi i cuèxruü̃ tá nüxü̃ chawẽ́x —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Rü yema ñaxguwena, rü nüxna yéma nixũ ga yema duü̃xü̃gü. Rü wenaxãrü nguegu nixüe rü naxtaxaarü tocutüwa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Natürü ga norü ngúexü̃gü rü nüxü̃ inayarüngümaẽ ga norü õna na íyangegüxü̃, rü wüxixicatama ga pãũ nüxü̃́ nayexma ga nguewa. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Rü yexguma ga Ngechuchu rü nayaxucu̱xẽgü, rü ñanagürü nüxü̃: —¡Dücèx, pexuãẽ naxcèx i Parichéugüarü rü Erodearü pãũãrü puxẽẽruü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Rü yema norü ngúexü̃gü rü inanaxügüe na nügümaã ñagüxü̃: —Ngẽma ñanagürü tüxü̃ erü tama tawemü ta ítingegü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Natürü ga Ngechuchu rü nüxü̃ nacuèxama na yema ñagüxü̃, rü yemacèx ñanagürü nüxü̃: —¿Tü̱xcüü̃ “Tangearü õnaã̱x”, ñaperügügü? ¿Ẽ́xna ñu̱xma rü ta tama nüxü̃ pecuèxgüéga rü tama nüxü̃ picuèxãchitanü i ngẽmachiga? ¿Ẽ́xna pexcèx naxẽ i ngẽma? ");
INSERT INTO tcaNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pema rü pexãxẽtügüchirẽ́x, ¿rü ñuxãcü i tama nüxü̃ pedauxü̃? Rü pexãxmachi̱xẽgüchirẽ́x, ¿rü ñuxãcü i tama nüxü̃ pexĩnüẽxü̃? ¿Rü ẽ́xna tama nüxna pecuèxãchie ga yexguma chayamuxẽẽgu ga yema pãũ rü choxni? ");
INSERT INTO tcaNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","—Rü yexguma yema 5000 ga duü̃xü̃güxü̃ chayanuxgu ga yema wüximẽ́ẽ̱xpü̱x ga pãũ, ¿rü ñuxre ga pexchigü yiĩxü̃ ga napagücü ga yexguma penadexgu ga yema íyaxügüxü̃? —ñanagürü. Rü nümagü nanangãxü̃gü rü ñanagürügü: —Rü 12 ga pexchigü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Rü ñu̱xũchi ñanagürü ta ga Ngechuchu: —Rü yexguma yema 4000 ga duü̃xü̃güxü̃ chayanuxgu ga yema 7 ga pãũ, ¿rü ñuxre ga pexchigü yiĩxü̃ ga napagücü ga yexguma penadexgu ga yema íyaxügüxü̃? —ñanagürü. Rü nanangãxü̃gü rü ñanagürügü: —7 ga pexchigü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Rü yexguma rü ñanagürü nüxü̃: —¿Rü ñu̱xma rü ta taũtama nüxü̃ pecuèxgüégaxü̃ na Parichéugücüma rü Erodecüma i chixexü̃chiga yiĩxü̃ i ngẽma pãũãrü puxẽẽruü̃gu pemaã chixuxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Rü yemawena rü Bechaídaarü ĩãnewa nangugü. Rü yéma Ngechuchuxü̃tawa nanagagü ga wüxi ga ngexetücü. Rü nüxü̃ nacèèxü̃gü na nüxü̃ yangõgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Rü Ngechuchu rü guma ngexetücümẽ́xẽgu nayayauxãchi, rü ĩãneãrü yéamaxü̃ra nanaga. Rü yéma naxbü̱xágümaã nayawaixetüxẽẽ, rü ñu̱xũchi naxẽtügu ningõgü, rü nüxna naca ngoxi marü ṯacüxü̃ nadau. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Rü yexguma ga guma ngexetücü rü inanaxügü ga na yadauchixü̃. Rü ñanagürü: —Nüxü̃ chadau i duü̃xü̃gü i ñoma naĩgü i ixĩxü̃nerüü̃ ixĩgüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Rü yexguma ga Ngechuchu rü wenaxãrü naxẽtügu ningõgü. Rü nüma ga guma yatü rü meãma inadawenü. Rü yemaãcü naxcèx nitaane rü meãma naxcèx nango̱x ga guxü̃ma. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Rü yemawena ga Ngechuchu rü napatawa nanamu. Rü namaã nüxü̃ nixu na tama ĩãnecèx nataeguxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Rü yemawena rü Checharéa ga Piripuanewa yexmane ga ĩãnexãcügüwa naxũ ga Ngechuchu norü ngúexü̃gümaã. Rü namawa rü Ngechuchu rü norü ngúexü̃güna naca, rü ñanagürü nüxü̃: —¿Ñuxũ ñagüxü̃ i duü̃xü̃gü i chauchiga na texé chiĩxü̃ i chomax? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rü norü ngúexü̃ nanangãxü̃gü rü ñanagürügü: —Nangẽxma i duü̃xü̃gü rü: “Cuáü̃ ya baiü̃xẽẽruü̃ quixĩ”, ñagüxü̃, rü togü i: “Ería quixĩ”, ñagüxü̃, rü togü rü: “Wüxi ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ quixĩ”, ñagüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Rü yexguma Ngechuchu rü nüxna naca rü ñanagürü: —¿Rü pema i ñuxũ ñapegügüxü̃ choxü̃ na texé chiĩxü̃? —ñanagürü. Rü Pedru nanangãxü̃ rü ñanagürü: —Cuma nixĩ i Cristu i Tupana cuxü̃ unetacü quiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Rü yexguma ga Ngechuchu rü norü ngúexü̃güxü̃ namu na taxúemaãma nüxü̃ yaxugüexü̃cèx ga yema ore ga nachiga. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Rü yemawena rü Ngechuchu inanaxügü ga norü ngúexü̃gümaã nüxü̃ na yaxuxü̃ ga ṯacü tá nüxü̃ na üpetüxü̃. Rü ñanagürü nüxü̃: —Choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü poraãcü ngúxü̃ tá chinge. Rü choxü̃ tá naxoxgü i Yudíugüarü ãẽ̱xgacügüerugü, rü paigüarü ãẽ̱xgacügü, rü ngẽma ngúexẽẽruü̃gü i Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃. Rü tá choxü̃ nimèxgü, natürü tomaẽ̱xpü̱x i ngunexü̃gu rü wena táxarü chamaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Rü yema ore rü meãma namaã nanango̱xẽẽ. Natürü yexguma ga Pedru rü nüxĩca noxrüwama Ngechuchuxü̃ naga, rü inanaxügü ga na naxucu̱xẽãxü̃ na tama yemaãcü yadeaxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Natürü ga Ngechuchu rü nadauegu, rü norü ngúexü̃güxü̃ nadawenü. Rü Pedruxü̃ nanga, rü ñanagürü: —¡Choxna ixũgachi, Pa Chatanáx! Cuma rü tama Tupana nagu rüxĩnüxü̃gu curüxĩnü, erü yatügü nagu rüxĩnüxü̃gumare nixĩ i curüxĩnüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Rü yexguma ga Ngechuchu rü norü ngúexü̃gücèx rü duü̃xü̃gücèx naca. Rü ñanagürü nüxü̃: —Rü ngẽxguma texé chowe rüxũxchaü̃gu, ¡ẽcü nüxü̃ tarüxo i tümaãrü ngúchaü̃, rü ñoma wüxi i curucha ngĩxü̃ tayaxuxü̃rüü̃ namaã tapora i guxü̃ma i ngúxü̃ i chauxcèx tingexü̃, rü chowe tarüxũ! ");
INSERT INTO tcaNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","—Erü yíxema tügü maxẽchaxẽẽchaü̃xẽ rü tá tayu. Natürü yíxema chaugagu rü ore i mexü̃gagu yuxe, rü aixcüma tá tamaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","—¿Rü ṯacüwa nüxü̃́ namexü̃ ya yatü ega ngẽxguma nayauxãgu i guxü̃ma i ñoma i naãneãrü ngẽmaxü̃gü, natürü norü maxü̃ iyanatauxẽẽgu? ");
INSERT INTO tcaNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","—Rü ngẽxgumarüü̃ ta, ¿rü ñuxre i dĩẽru iyangu na ngẽmamaã naxcèx nataxexü̃ i norü maxü̃ i wüxi ya yatü? ");
INSERT INTO tcaNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","—Rü ngẽxguma texé i ñaã duü̃xü̃gü i pecaduã̱xgüxü̃ i tama yaxõgüxü̃pẽ́xewa chauxcèx taxãnegu rü naxcèx taxãnegu i chorü ore, rü choma i Tupana Nane i duü̃xü̃xü̃ na chiĩxü̃ rü tá ta tümacèx chaxãne i ngẽxguma Chaunatüarü poramaã rü norü orearü ngeruü̃gü i daxũcü̱̃ã̱x i üünegüxü̃maã wenaxãrü núma chaxũxgu. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Rü yexgumarüü̃ ta ga Ngechuchu rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü ñuxre i duü̃xü̃gü i nuã ngẽxmagüxü̃ rü tãũtáma nayu ñu̱xmatáta nüxü̃ nadèu̱x na ñuxãcü ãẽ̱xgacü ya poracü na yiĩxü̃ ya Tupana —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Rü 6 ga ngunexü̃guwena rü Ngechuchu rü wüxi ga mèxpǘnewa naxũ. Rü ínayagagü ga Pedru rü Chaü̃tiágu rü Cuáü̃xĩcatama. Rü yéma yema ngúexü̃güpẽ́xewa toraxü̃ãcü nango̱x ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Rü niy̱auracüü ga naxchiru rü nacómüxü̃chi. Rü nataxuma i yauxchiruxü̃ i nüxü̃ cuáxü̃ na ngẽmaãcü nacómüxẽẽãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Rü nüxü̃ nadaugü ga Ería rü Moĩché ga yéma Ngechuchumaã idexagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Rü yexguma ga Pedru rü ñanagürü Ngechuchuxü̃: —Pa Ngúexẽẽruü̃x, namexẽchi nixĩ na nuã ingẽxmagüxü̃. Rü tá tanaxü ya tomaẽ̱xpü̱x ya düxenü, rü wüxi ya cuxcèx, rü naĩ ya Moĩchécèx, rü naĩ ya Eríacèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Rü yema na poraãcü naḇaixãchiãẽgüxü̃ ga yema ngúexü̃gü, rü yemacèx ga Pedru rü tama nüxü̃ nacuèx ga na ñuxü̃ ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Rü yexgumatama wüxi ga caixanexü̃ ínarüxĩ, rü natanügu nayangèi̱xema. Rü yema caixanexü̃wa inanaxũ ga wüxi ga naga ga ñaxü̃: —Daa nixĩ ya Chaune ya nüxü̃ changechaü̃xü̃chicü. ¡Rü nüxü̃́ iperüxĩnüẽ! —ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Rü yexgumatama nügücüwagu ínadaueguãchitanü, rü taxúexü̃ma ga toguexü̃ nadaugü, rü Ngechuchuxü̃xĩcatama. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Rü yexguma ínaxĩgügu nawa ga guma mèxpǘne, rü Ngechuchu nüxna naxãga ga taxúemaãma na nüxü̃ yaxugüexü̃ ga yema yéma nüxü̃ nadaugüxü̃, ñu̱xmatáta yuwa ínadaxgu ga nümax. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rü yemacèx ga yema ngúexü̃gü rü bexma nüxü̃ nacuèxgü ga yema nüxü̃ nadaugüxü̃. Natürü nügüna nacagü ga ṯacüchiga na yiĩxü̃ ga: “Yuwa ínadaxgu”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Rü ñu̱xũchi ga yema ngúexü̃gü rü Ngechuchuna nacagü, rü ñanagürügü: —¿Tü̱xcüü̃ i ngúexẽẽruü̃gü i ore i mugüwa ngu̱xẽẽtaegüxü̃ rü ñanagürügü: “Ería tá nixĩ ya nüxĩra cuxü̃pa núma ũcü?” ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Aixcüma nixĩ i Ería na nüxĩra núma naxũxü̃ na chauxü̃pa namexẽẽãxü̃cèx i guxü̃ma. ¿Natürü tü̱xcüü̃ i ore i ümatüxü̃wa i ñaxü̃: “Rü Tupana Nane ya duü̃xü̃xü̃ ixĩcü rü tá ngúxü̃ ninge, rü duü̃xü̃gü rü tá nüxü̃ naxoe”, ñaxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Natürü i choma rü pemaã nüxü̃ chixu, rü Ería rü marü núma naxũ. Natürü ga duü̃xü̃gü rü nümagü nanaxwèxegüxü̃ãcüma poraãcü chixri namaã nachopetü, yexgumarüü̃ ga ore ga ümatüxü̃wa nüxü̃ yaxuxü̃rüü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Rü yexguma yema togü ga norü ngúexü̃gütanüwa nangugügu, rü yéma nüxü̃ nadaugü ga muxü̃ma ga duü̃xü̃gü ga yema ngúexü̃güxü̃ íchomaẽguãchixü̃. Rü ñuxre ga ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü yéma niporagatanücüü namaã ga yema ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Rü yexguma Ngechuchuxü̃ nadaugügu ga yema muxü̃ma ga duü̃xü̃gü, rü poraãcü naḇaixãchiãẽgü. Rü guxü̃ma naxcèx nibuxmü na nüxü̃ yanamoxẽgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Rü nüma ga Ngechuchu rü nüxna naca, rü ñanagürü nüxü̃: —¿Ṯacü nixĩ i pema namaã naxcèx ípiporagatanücüüxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Rü wüxi ga yema duü̃xü̃gü ga yéma yexmagüxü̃ rü nanangãxü̃, rü ñanagürü: —Pa Ngúexẽẽruü̃x, nuã cuxcèx tüxü̃ chaga ya chaune, erü tümawa nangẽxma i wüxi i ngoxo i tüxü̃ ngegaxẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","—Rü ngextá ítangẽxmaxü̃wa rü ngẽxma tüxü̃ yaxüxgu rü waixü̃müãnegu tüxü̃ naña. Rü tarüchièx, rü tixü̃́xchapüta, rü ngẽxma tiyuãchi. Rü marü nüxü̃ chacèèxü̃ i curü ngúexü̃gü na tümawa ínatèxüchiãxü̃cèx i ngẽma ngoxo, natürü tama nüxü̃́ inaxĩnü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Pa Duü̃xü̃gü i Tama Yaxõgüxü̃, ¿ñuxguratáta i pemaã chanuxmaxü̃ rü yaxna pemaã chaxĩnüxü̃? ¡Nuã penaga ya yima bucü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Rü Ngechuchuxü̃tawa nanagagü ga guma bucü. Natürü yexguma Ngechuchuxü̃ nadèu̱xgu ga yema ngoxo, rü guma bucüxü̃ naxü ga na yayuãchixẽẽãxü̃. Rü yexma ñaxtüanegu nayangu. Rü yexma nidixegugü, rü narüchièx. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Rü Ngechuchu rü guma bucünatüna naca, rü ñanagürü: —¿Rü ñuxgumama nixĩ ga naxcèx inaxügüxü̃ ga yema? —ñanagürü. Rü guma bucünatü nanangãxü̃ rü ñanagürü: —Nabuxgumamatama. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Rü muẽ̱xpü̱xcüna i ngẽma ngoxo rü üxüxetügu rü dexágu nanañaü̃xü̃ na ngẽmaãcü yamáãxü̃cèx. Rü ngẽmacèx ega cumaã nanguxü̃gu na ṯacü toxcèx cuxüxü̃, ¡rü cuxü̃́ tangechaü̃tümüü̃gü, rü toxü̃ rüngü̃xẽẽ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¿Rü tü̱xcüü̃ “ega chomaã nanguü̃xgu”, ñacurügü? Erü guxü̃ma natauxcha tümacèx ya yíxema yaxṍxẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Rü yexguma ga guma bucünatü rü tagaãcü ñatarügü: —Chayaxõ. ¡Choxü̃ rüngü̃xẽẽ na yexeraãcü chayaxõxü̃cèx! —ñatarügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu na muxü̃ma ga duü̃xü̃gü marü yexma ngutaquẽ́xexü̃, rü nananga ga yema ngoxo. Rü ñanagürü nüxü̃: —Pa ngoxo i Ngegaxẽẽruü̃ rü Ngauchi̱xẽxẽẽruü̃x, ¡choma cuxü̃ chamu na nawa ícuxũxũxü̃ ya daa bucü, rü tagutáma wena nagu cuyaxücuxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Rü yexguma ga yema ngoxo rü aita naxü, rü wenaxãrü guma bucüxü̃ niyuãchixẽẽ. Rü ñu̱xũchi nawa ínaxũxũ, rü ñoma nayuxuchixü̃rüü̃ yéma nanatèx. Rü yemacèx ga muxü̃ma ga duü̃xü̃gü rü ñanagürügü: —Marü nayuxuchi nixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Natürü ga Ngechuchu rü naxmẽ́xgu nayayauxãchi, rü ínanadaxẽẽ. Rü nüma ga guma bucü rü inachi. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Rü yemawena ga Ngechuchu rü wüxi ga ĩpatagu nayaxücu namaã ga norü ngúexü̃gü. Rü yéma nüxĩca nüxna nacagü, rü ñanagürügü nüxü̃: —Pa Corix, ¿tü̱xcüü̃ i toma rü taxuacüma ítanatèxüchi i ngẽma ngoxo? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Tama ngẽmaãcümare ítanatèxüchi i ngẽmarüü̃ ixĩxü̃ i ngoxo. Natürü tanaxwèxe i Tupanana tanaxuaxü̃ i tórü yumü̃xẽwa na nüma ínatèxüchiãxü̃cèx. Rü ngẽmaãcüxicatama nixĩ i ínaxũxũxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Rü yéma inaxĩãchi rü Gariréaanewa nachopetü. Natürü ga Ngechuchu rü tama nanaxwèxe ga texé nüxü̃ na cuáxü̃ ga na yéma nayexmaxü̃, yerü norü ngúexü̃güxü̃ ínangúexẽẽ. Rü ñanagürü nüxü̃: —Tupana Nane ya duü̃xü̃xü̃ ixĩcü, rü duü̃xü̃gü tá nayayauxgü rü tá nayamèxgü. Natürü tomaẽ̱xpü̱x i ngunexü̃gu rü wena tá ínarüda —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Natürü ga nümagü rü tama meã nüxü̃ nacuèxgü ga ṯacüchiga na yiĩxü̃ ga yema ore, rü namuü̃ẽ ga nüxna na nacagüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Rü Capernáũãrü ĩãnewa nangugü. Rü yexguma ĩxwa nayexmagügu, rü Ngechuchu nüxna naca, rü ñanagürü: —¿Rü ṯacü nixĩ ga pegümaã naxcèx piporagaetanüxü̃ ga namawa? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Natürü ga nümagü rü nangeèxgümare, yerü ga namawa rü nachigagu nügümaã niporagaetanü ga texé tiĩxü̃ ga natanüwa rüyexeramaẽxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Rü yexguma ga Ngechuchu rü ínarüto, rü naxcèx naca ga yema 12 ga norü ngúexü̃gü, rü ñanagürü nüxü̃: —Rü ngẽxguma texé naxwèxegu na guxãe̱tüwa na taxüxü̃, rü name nixĩ i noxri rü guxããrü ñaxtümaẽwa tügü taxüxẽẽ na guxããrü ngü̃xẽẽruü̃ tiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Rü yemawena rü norü ngãxü̃tanügu nayachixẽẽ ga wüxi ga buxü̃. Rü ñu̱xũchi nachacüügu yayauxãchiãcüma ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Rü texé ya chauégagu meã nayaxúxe i wüxi i buxü̃ i ñaãrüü̃, rü choxü̃ nixĩ i tayaxuxü̃. Rü texé ya choxü̃ yaxúxe, rü tama choxü̃xĩcatama tayaxu, natürü yima núma choxü̃ mucü ya Chaunatüxü̃ rü ta nixĩ i tayaxuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Rü yexguma ga Cuáü̃ rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃x, nüxü̃ tadau ga wüxi ga yatü ga cuégagu ngoxogü íwoxü̃xü̃. Natürü toma nüxna tanachu̱xu ga yema, yerü tama tatanüxü̃ nixĩ ga nümax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Natürü Ngechuchu nanangãxü̃, rü ñanagürü: —Tama name i nüxna na penachu̱xuxü̃. Erü texé ya chauégagu naxǘxe i wüxi i mexü̃ i Tupanaãrü poramaã üxü̃, rü taxucürüwama yixcama chixri chauchiga tidexa. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Erü texé ya tama taxchi aixe, rü tórü ngü̃xẽẽruü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Rü texé ya woo wüxitama i pochiyuãcu i dexá pexna ãxẽ naxcèx na chorü duü̃xü̃gü pixĩgüxü̃, rü aixcüma pemaã nüxü̃ chixu rü tá tüxü̃́ nangẽxma i tümaãrü ãmare —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Rü ñanagürü ta: —Texé ya pecadugu nanguxẽe̱xẽ i wüxi i ñaã buxü̃gü i choxü̃́ yaxõgüxü̃, rü tümacèx rü narümemaẽ chi nixĩ i noxtacüma wüxi ya nuta ya tacü tümanaxãwa tayangacuchi, rü ngẽmaãcü taxtüchiüwa tüxü̃ tayatáe. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","—Rü ngẽxguma chi wüxi ya cuxmẽ́x pecadugu cuxü̃ nguxẽẽgu, rü name nixĩ i noxtacüma ícunadae. Erü narümemaẽ nixĩ i cuboxmẽ́xãcüma cunayaxu i curü maxü̃ na tama guxü̃ne ya cuxmẽ́x ya mexü̃nemaã nawa quitèxcuchixü̃cèx ya yima üxü ya ngoxogü nagu poxcuene ya taguma ixoxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","—Rü ngẽxguma chi wüxi ya cucutü pecadugu cuxü̃ nguxẽẽgu, rü name nixĩ i noxtacüma ícunadae. Erü narümemaẽ nixĩ i cubocutüãcüma cunayaxu i curü maxü̃ na tama guxü̃ne ya cucutü ya mexü̃nemaã nawa quitèxcuchixü̃cèx ya yima üxü ya ngoxogü nagu poxcuene. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","48","—Rü ngẽxguma chi wüxi ya cuxetü pecadugu cuxü̃ nguxẽẽgu, rü name nixĩ i noxtacüma ícunacaxüchi. Erü narümemaẽ nixĩ i wüxitama ya cuxetümaã Tupana ãẽ̱xgacü íixĩxü̃wa quixücu, na tama guxü̃ne ya cuxetü ya mexü̃nemaã nawa quitèxcuchixü̃cèx ya yima üxü ya taguma ixoxü̃ne ya ngoxogü nagu poxcuene i ngextá õxmigü taguma íyuexü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","—Rü aixcüma ñoma õnawa yucüra nagüxü̃rüü̃ tá nixĩ na guxãtáma guxchaxü̃wa chopetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","—Name ya yucüra. Natürü ngẽxguma chi nangeacagu, ¿rü ñuxãcü tá wenaxãrü naxããca? ¡Rü meã pegüna pedaugü na ñoma yucüra ya taguma iyarüngeacacürüü̃ na namexü̃cèx i perü maxü̃! ¡Rü meã pegümaã pemaxẽ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Rü yexguma ga Ngechuchu rü Capernáũãrü ĩãnewa inaxũãchi. Rü Yudéaanewa naxüpetü rü ñu̱xmata natü ga Yudáü̃ãrü tocutüwa nangu. Rü yéma rü wenaxãrü naxcèx nangutaquẽ́xegü ga duü̃xü̃gü. Rü nüma rü inanaxügü ga na nangúexẽẽtaexü̃ guxü̃gurüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Rü ñuxre ga Parichéugü rü naxcèx naxĩ ga na nüxü̃ yaxügüxü̃cèx yerü chixexü̃gu nananguxẽẽgüchaü̃. Rü yemacèx nüxna nacagüe, rü ñanagürügü: —¿Namexü̃ i cuxcèx na wüxi ya yatü rü naxmèxü̃ ínatáxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Rü nüma nanangãxü̃, rü ñanagürü nüxü̃: —¿Rü ṯacü yiĩxü̃ ga Moĩché pexü̃ muxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rü nümagü nanangãxü̃gü, rü ñanagürügü: —Moĩché nüxü̃ nixu ga na tama nachu̱xuxü̃ na wüxi ya yatü rü ínatámaxü̃, ega wüxi i popera i tèxgüpane ngĩxna naxãxgu —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Rü yexguma ga Ngechuchu rü nanangãxü̃, rü ñanagürü nüxü̃: —Rü yema na taxúegama na pexĩnüẽxü̃gagu nixĩ ga Moĩché ga tama pexna nachúãxü̃ ga pexmèxü̃ na ípetáxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","—Natürü noxriarü ügügu, rü Tupana nanaxü ga yatüxü̃ rü ngexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","—Rü ngẽmacèx ya yatü rü tá nanatü rü naẽna nixũgachi na naxmèxmaã inaxã́ũxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","—Rü ngẽmaãcü i ngẽma taxre rü ñoma wüxitama i duü̃xü̃rüü̃ tá nixĩgü. Rü marü tãũtáma taxre nixĩ, erü wüxi tátama nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","—Rü ngẽmacèx taxucürüwa texé nügüna tayaxĩgachixẽẽ i ngẽma taxre i Tupana nügüna mugüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Rü yexguma marü ĩpatawa nangugügu, rü norü ngúexü̃gü rü wenaxãrü nüxna nacagüe naxcèx ga yema. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Rü Ngechuchu rü ñanagürü nüxü̃: —Rü yíxema tümamèxü̃ ítáxe rü naĩ i ngemaã ãmaxẽ rü pecadu taxü ngĩmaã i ngẽma noxriü̃cü i tümamèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","—Rü ngẽxgumarüü̃ ta, ega wüxi i nge ítèxtegu rü naĩ ya yatümaã naxãtegu, rü ngĩma rü ta pecadu ixü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Rü yéma Ngechuchuxü̃tawa tüxü̃ nagagü ta ga ñuxre ga buxegü na tüxü̃ yangõgügüxü̃cèx. Natürü ga yema norü ngúexü̃gü rü inanaxügüe ga tüxü̃ na yangagüxü̃ ga guxema tümaxãcüxegüxü̃ Ngechuchuxü̃tawa gagüxe. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Rü yexguma yemaxü̃ nadèu̱xgu ga Ngechuchu, rü naãẽwa nangu̱x, rü ñanagürü nüxü̃: —Chanaxwèxe i chauxü̃tawa naxĩ i buxü̃gü. ¡Rü tãxṹ i nüxna penachu̱xuxü̃! Erü Tupana ãẽ̱xgacü íixĩxü̃wa rü tümacèx nixĩ ya yíxema ñaã buxü̃gürüü̃ taxuü̃ma i chixexü̃xü̃ icuáxe. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","—Rü aixcüma pemaã nüxü̃ chixu rü texé ya tama wüxi i buxü̃rüü̃ Tupanaxü̃ yaxúxe na tümaãrü ãẽ̱xgacü yiĩxü̃cèx, rü tagutáma nagu taxücu i ngẽma naãne i Tupana ãẽ̱xgacü íixĩxü̃wa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Rü nüma rü tüxü̃ naganagütanü ga guxema buã̱xta, rü tümaẽrugügu naxümẽ́xãcüma ñanagürü tüxü̃: —¡Tupana pexü̃ rüngü̃xẽẽ̱x! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Rü yexguma marü inaxũãchichaü̃gu ga Ngechuchu, rü yéma naxcèx niña ga wüxi ga yatü. Rü napẽ́xegu nayacaxã́pü̱xü, rü nüxna naca rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃ ya mecüx, ¿ṯacü tá chaxüxü̃ na chanayaxuxü̃cèx i maxü̃ i taguma gúxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —¿Tü̱xcüü̃, “Mecü” ñacurügü choxü̃? Erü Tupanaxĩcatama nixĩ ya mecü ixĩcü, rü nataxuma i to. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Cuma rü marü nüxü̃ cucuèx i Tupanaãrü mugü i ñaxü̃: “¡Tãũtáma cumáẽta, rü tãũtáma naĩ i ngemaã icupe, rü tãũtáma cungĩ́tèèx, rü tãũtáma doraxü̃ quixu i togüchiga, rü tãũtáma quidoratèèx, rü tümaga naxĩnü ya cunatü rü cue!” ñaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Rü yexguma ga guma yatü rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃x, rü chorü bucümatama meã chanaxaure i guxü̃ma i ngẽma mugü i nüxü̃ quixuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Rü yexguma ga Ngechuchu rü nüxü̃ nangechaü̃ãcüma nüxü̃ nadawenü, rü nanangãxü̃ rü ñanagürü: —Rü wüxixicatama cuxü̃́ nataxu. ¡Rü íixũ, rü namaã yataxe i guxü̃ma i curü ngẽmaxü̃gü, rü ñu̱xũchi togü i ngearü ngẽmaxü̃ã̱xgüxü̃na naxã i ngẽma curü natanü! Rü ngẽmaãcü tá cuxü̃́ nangẽxma i cuchica i daxũguxü̃ i naãnewa. Rü ngẽmawena rü marü name i chowe curüxũ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Natürü nüma ga guma yatü rü nanaxi̱xãchiãẽ ga yexguma nüxü̃ naxĩnügu ga yema ore. Rü nangechaü̃ãcüma ínixũ, yerü namuxũchi ga norü yemaxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Rü Ngechuchu rü nüxü̃ nidaugüãchi, rü ñanagürü norü ngúexü̃güxü̃: —Naguxchaxüchi tá nixĩ na Tupana ãẽ̱xgacü íyiĩxü̃wa na yachocuxü̃ i ngẽma dĩẽruã̱xü̃chigüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Rü naḇaixãchiãẽgü ga norü ngúexü̃gü namaã ga yema ore. Natürü ga Ngechuchu rü wenaxãrü namaã nüxü̃ nixu, rü ñanagürü: —Pa Chauxacügüx, ñuxãcü wüxi i guxchaxüchixü̃ nixĩ na Tupana ãẽ̱xgacü íyiĩxü̃wa na yaxücuxü̃ i wüxi i duü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","—Rü aixcüma pemaã nüxü̃ chixu rü ñoma wüxi i cameyu na taxucürüwama wüxi ya ucumaxẽtüwa naxüpetüxü̃ãrü yexera narüguxchamaẽ naxcèx i wüxi i duü̃xü̃ i dĩẽruã̱xü̃chixü̃ na yaxücuxü̃ i ngextá Tupana ãẽ̱xgacü íixĩxü̃wa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Rü yexguma yemaxü̃ naxĩnüẽgu ga norü ngúexü̃gü, rü yexeraãcü naḇaixãchiãẽgü. Rü nügüna nacagüe, rü ñanagürügü: —¿Rü texé tá ẽ́xna tixĩ ya nayaxúxe i maxü̃ i taguma gúxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Rü Ngechuchu rü nüxü̃ nadawenü, rü nanangãxü̃ rü ñanagürü nüxü̃: —Yatügü rü taxuacüma nügü namaxẽẽ, natürü Tupanaãxü̃́ rü natauxcha i ngẽma, erü Tupanacèx rü nataxuma i ṯacü i guxchaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Rü yexguma inanaxügü ga Pedru ga na yadexaxü̃, rü ñanagürü nüxü̃: —Toma rü marü yéma tanawogü ga guxü̃ma ga torü yemaxü̃gü na cuwe tarüxĩxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Aixcüma pemaã nüxü̃ chixu rü texé ya chaugagu rü ore i maxẽxẽẽruü̃gagu tümapatana, rü ẽ́xna tümaẽneẽgüna, rü ẽ́xna tümaẽyèxgüna, rü ẽ́xna tümaẽna, rü ẽ́xna tümanatüna, rü ẽ́xna tümaxãcügüna, rü ẽ́xna tümaãnegüna nge̱ma ixũxẽ, rü tá tanayaxu i tümaãrü natanü. Rü aixcüma ñu̱xma i ñoma i naãnewa rü tá tanayaxu i 100 ẽ́xpü̱xcüna ya tümapatagü, rü tümaẽneẽgü, rü tümaẽyèxgü, rü tümaẽgü, rü tümaxãcügü, rü tümaãnegü. Natürü ngẽxgumarüü̃ tá ta tanayaxu i ngúxü̃gü i togü tá tüxü̃ ingexẽẽgüxü̃. Natürü yixcamaxü̃ra i daxũguxü̃ i naãnewa rü tá tanayaxu i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","—Natürü muxü̃ma i nümaxü̃ i ñu̱xma ñoma i naãnewa duü̃xü̃gü wixpẽ́xewa ügüxẽẽxü̃, rü daxũguxü̃ i naãnewa rü Tupana tá wixweama nanaxügüxẽẽ. Rü muxü̃ma i nümaxü̃ i ñu̱xma ñoma i naãnewa duü̃xü̃gü wixweama ügüxẽẽxü̃, rü daxũguxü̃ i naãnewa rü Tupana tá wixpẽ́xewa nanaxügüxẽẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Rü Yerucharéü̃waama naxĩ. Rü nüma ga Ngechuchu rü norü ngúexü̃güpẽ́xegu nixũ. Rü nümagü rü naḇaixãchiãẽgü, rü yema togü ga duü̃xü̃gü ga wixweama ãgüxü̃ rü namuü̃ẽ. Rü Ngechuchu rü wenaxãrü noxrüwama naxcèx naca ga yema 12 ga norü ngúexü̃gü. Rü inanaxügü ga namaã nüxü̃ na yaxuxü̃ ga ṯacü tá nüxü̃ na ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rü ñanagürü nüxü̃: —Pema nüxü̃ pecuèx na marü ingaicaxü̃ na Yerucharéü̃wa ingugüxü̃. Rü nge̱ma rü duü̃xü̃gü rü tá chixri chomaã nachopetü. Rü paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü i ore i mugüwa ngu̱xẽẽtaegüxü̃na tá choxü̃ naxuaxü̃gü. Rü nümagü rü tá chomaã nanaxuegugü na chayuxü̃, rü tá ngẽma Dumacü̱̃ã̱xgüna choxü̃ namugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Rü ngẽmagü tá nixĩ i chaugu idauxcüraü̃güxü̃. Rü tá choxna nacuaixgüe, rü tá choxna nanac̱uaixcagü, rü tá choxü̃ nayuxẽẽgü. Natürü tomaẽ̱xpü̱x i ngunexü̃guwena táxarü chamaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Rü Ngechuchucèx naxĩ ga Chaü̃tiágu rü Cuáü̃ ga Zebedéu nanegü, rü ñanagürügü nüxü̃: —Pa Ngúexẽẽruü̃x, tanaxwèxe i toxcèx cunaxü i ngẽma ngü̃xẽẽ i naxcèx tá cuxna tac̱axü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Rü nüma rü nüxna naca, rü ñanagürü: —¿Ṯacü nixĩ i penaxwèxexü̃ na pexcèx chanaxüxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rü ñanagürügü: —Rü ngẽxguma ãẽ̱xgacüxü̃ quingucuchigu, rü tanaxwèxe na wüxie i toma rü curü tügünecüwawa tarütoxü̃, rü togue i curü ṯoxwecüwawa —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Pema rü tama nüxü̃ pecuèx na ṯacücèx ípec̱axü̃. ¿Rü pexü̃́ chi natauxchaxü̃ i na peyaxaxüxü̃ i ngẽma axexü̃ i üxchiüxü̃ i choma tá chixaxüxü̃? ¿Rü namaã chi peporaexü̃ i ngẽma ngúxü̃ i tá chingexü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Rü nümagü nanangãxü̃gü rü ñanagürügü: —Ngẽmáãcü, namaã tá taporae —ñanagürügü. Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Aixcüma tá nixĩ i chauxrüü̃ peyaxaxüxü̃ i ngẽma axexü̃ i üxchiüxü̃ rü chauxrüü̃ ngúxü̃ na pingegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","—Natürü ngẽma chorü tügünecüwawa rü chorü ṯoxwecüwawa na perütogüxü̃cèx, rü tama cho̱xmẽ́xwa nangẽxma na pexna chanaxãxü̃, erü Chaunatü tá tüxna nanaxã ya yíxema tümacèx íyiĩxẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Rü yexguma yemaxü̃ naxĩnüẽgu ga yema togü ga 10 ga ngúexü̃gü, rü Chaü̃tiágumaã rü Cuáü̃maã nanuẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Natürü Ngechuchu naxcèx naca rü ñanagürü nüxü̃: —Pema nüxü̃ pecuèx i togü i nachiü̃ãnegüwa rü nangẽxmagü i ãẽ̱xgacügü i nügü nacuèxgügu na namexü̃ na nuãcü namuãxü̃ i norü duü̃xü̃gü. Rü ngẽma ãẽ̱xgacügü i taxü̃gü rü norü duü̃xü̃güarü yora nügü nixĩgüxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","—Natürü tãũtáma ngẽmaãcü nixĩ i petanüwa. Erü ngẽxguma texé naxwèxegu na guxããrü yexera na tiĩxü̃ i petanüwa, rü name nixĩ i noxri rü guxããrü ngü̃xẽẽruü̃ na tiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","—Rü ngẽxguma chi texé i petanüwa naxwèxegu na tümamücügüeru na tiĩxü̃, rü name nixĩ i noxri rü guxü̃ma i tümamücügüarü ngü̃xẽẽruü̃ na tiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","—Rü woo i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü tama togü choxü̃ rüngü̃xẽẽxü̃cèx nixĩ i núma chaxũxü̃. Natürü núma chaxũ na duü̃xü̃güxü̃ charüngü̃xẽẽxü̃cèx rü naxcèx ichanaxãxü̃cèx i chorü maxü̃, na ngẽmaãcü chanaxütanüxü̃cèx na norü pecadugüna ínanguxü̃xü̃cèx i muxü̃ma i duü̃xü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Rü Yericúarü ĩãnewa nangugü. Rü Ngechuchuwe narüxĩ ga norü ngúexü̃gü rü muxü̃ma ga togü ga duü̃xü̃gü. Rü yexguma guma ĩãneãrü gu̱xwa nangugüchaü̃gu ga nüxna na ínachoxü̃xü̃, rü yéma namacüwawa narüto ga wüxi ga ngexetücü ga Bartiméũgu ãe̱gacü ga Timéũ nane. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Rü yexguma guma ngexetücü nüxü̃ ĩnügu ga Ngechuchu ga Nacharétucü̱̃ã̱x na yiĩxü̃ ga guma yéma üpetücü, rü inanaxügü ga poraãcü aita na naxüxü̃, rü: —Pa Ngechuchu ya Dabítanüxü̃x, ¡cuxü̃́ changechaü̃tümüü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Natürü muxü̃ma ga yema duü̃xü̃gü rü ínanangaxüchigüama ga na iyanangeáxü̃cèx. Natürü ga nüma rü yexeraãcü aita naxüama, ñaxü̃maã: —Pa Dabítanüxü̃x, ¡cuxü̃́ changechaü̃tümüü̃! —ñaxü̃maã. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Rü yexguma ga nüma ga Ngechuchu rü inayachiãchi, rü ñanagürü: —¡Naxcèx peca! —ñanagürü. Rü guma ngexetücücèx nacagü, rü ñanagürügü: —¡Nataãẽ rü inachi! Rü cuxcèx nixĩ i nac̱axü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Rü guma ngexetücü rü yexacü nanaña ga norü gáuxü̃chiru. Rü inayuxnagü rü Ngechuchucèx nixũ. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Rü Ngechuchu nüxna naca, rü ñanagürü nüxü̃: —¿Ṯacü nixĩ i cunaxwèxexü̃ na cuxcèx chanaxüxü̃? —ñanagürü. Rü nüma ga guma ngexetücü, rü nanangãxü̃, rü ñanagürü: —Pa Ngúexẽẽruü̃x, chanaxwèxe na chidauchixü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Rü yexguma ga Ngechuchu, rü ñanagürü nüxü̃: —¡Ẽcü, íixũ! Rü marü cuxcèx nitaane erü cuyaxõ —ñanagürü. Rü yexgumatama ga guma ngexetücü rü nidauchi, rü Ngechuchuwe narüxũ ga namawa. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Rü marü Yerucharéü̃ãrü ngaicamana nangugü ga Oríbunecüarü Mèxpǘneãrü ngaicamana yexmagüne ga ĩãnexãcügü ga Bechagué rü Betániã. Rü yexguma yéma nangugügu, rü Ngechuchu nanamu ga taxre ga norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Rü ñanagürü nüxü̃: —¡Gua tórü to̱xmèxtawa ngẽxmane ya ĩãnexãcüwa pexĩ! Rü ngẽxguma nawa pengugügu, rü ngẽxma tá nüxü̃ peyangau i wüxi i buru i ngẽxma ngaxü̃xü̃ i taguma texé natagu aunagüxü̃. ¡Rü peyawẽxü̃ rü nuã penaga! ");
INSERT INTO tcaNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","—Rü ngẽxguma texé pexna caxgu na ṯacücèx peyawẽxü̃xü̃ i ngẽma buru, ¡rü tümamaã nüxü̃ pixu rü ñapegügü: “Torü Cori nanaxwèxe, rü ñu̱xma tátama nanataeguxẽẽ”, ñapegügü! ");
INSERT INTO tcaNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Rü yéma naxĩ. Rü yexma namacüwagu nüxü̃ nayangaugü ga yema buru ga wüxi ga ĩpataèxü̃tagu ngaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Rü ñuxre ga duü̃xü̃gü ga yéma yexmagüxü̃ rü nüxna nacagüe, rü ñanagürügü: —¿Ṯacü ípexüe? ¿Rü tü̱xcüü̃ peyawẽxü̃ i ngẽma buru? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rü nümagü ga yema ngúexü̃gü, rü yema ore ga Ngechuchu namaã nüxü̃ ixuxü̃ãcü nanangãxü̃gü. Rü yemacèx tama nüxna nanachu̱xgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Rü natagu nanac̱ẖagümü ga naxchirugü. Rü yemaãcü Ngechuchuxü̃tawa nanagagü. Rü nüma ga Ngechuchu rü natagu naxaunagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Rü muxü̃ma ga duü̃xü̃gü rü naxchirumaãtama nanac̱ẖamagü. Rü togü rü naĩxã́tügü ga naãnewa nadaü̃xü̃maã nayac̱ẖamagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Rü yema duü̃xü̃gü ga napẽ́xegu ãgüxü̃ rü yema togü ga wixweama ãgüxü̃, rü tagaãcü ñanagürügü: —¡Cuxü̃ ticuèxüxügü! ¡Rü naxüüne ya daa Tupanae̱gagu núma ũcü! ");
INSERT INTO tcaNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Rü ãẽ̱xgacü ya Dabírüxü̃ namecümaxüchi ya daa ãẽ̱xgacü ya núma ngucü! ¡Rü pema rü ta, Pa Daxũcüã̱x, rü nüxü̃ picuèxüxü̃gü ya Tupana! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Rü Yerucharéü̃gu naxücu ga Ngechuchu, rü tupauca ga taxü̃necèx nixũ. Rü meãma guxü̃wama inanadauaxü̃ne. Rü ñu̱xũchi yema norü 12 ga ngúexü̃gümaã Betániããrü ĩãnecèx nataegu, yerü marü nayáuane. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Rü moxü̃ãcü yexguma Betániãwa inaxĩãchigu ga Ngechuchu rü nataiya. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Rü yaxü̃gu nüxü̃ nadau ga wüxi ga ori̱x ga iguera ga ãã́tüxü̃. Rü nüma ga Ngechuchu rü naxcèx nixũ na íyadauãxü̃cèx rü ngoxi nayexmèx ga norü o. Natürü yexguma naxü̃tawa nanguxgu, rü taxuü̃ma inayangau, rü naã́tüxü̃xĩcatama, yerü tauta norü owa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Rü yexguma rü ñanagürü igueraxü̃: —¡Tagutáma texé wena cuxü̃ tamúãrü oõx! —ñanagürü. Rü norü ngúexü̃gü rü nüxü̃ naxĩnüẽ ga yema. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Rü yexguma Yerucharéü̃wa nangugügu, rü Ngechuchu rü tupauca ga taxü̃negu naxücu. Rü inanaxügü ga na ínawoxü̃ãxü̃ ga yema yéma ṯacümaã taxegüxü̃ rü naxcèx taxegüxü̃. Rü nanangüegutanü ga norü mechagü ga yema duü̃xü̃gü Tupanaarü ãmarewa mexü̃ ga dĩẽrumaã taxegüxü̃ rü muxtucumaã taxegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Rü nanachu̱xu ga texé ṯacü na yéma ngepetüxü̃ tupauca ga taxü̃nemachiawa. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Rü inanaxügü ga na nangúexẽẽtaexü̃, rü ñanagürü: —Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Chopata rü guxü̃ma i nachiü̃ãnecü̱̃ã̱xgüarü yumüxẽpataü̃gu tá naxãe̱ga”, ñanagürü. Natürü pema rü ngĩ́tèèxgüxü̃pataü̃ peyaxĩxẽẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Natürü yexguma yemaxü̃ naxĩnüẽgu ga paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü inanaxügüe ga naxcèx na nadaugüxü̃ ga ñuxãcü Ngechuchuxü̃ na yamèxgüxü̃. Natürü duü̃xü̃güxü̃ namuü̃ẽ, rü yemacèx taxucürüwama duü̃xü̃güpegu nayayauxgü. Yerü nüma ga duü̃xü̃gü rü namaã nataãxẽgü ga yema Ngechuchuarü ngu̱xẽẽtae. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Natürü yexguma marü nayáuanegu, ga Ngechuchu rü norü ngúexü̃gümaã nawa ínachoxü̃ ga guma ĩãne. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Rü moxü̃ãcü pèxmama rü igueraxü̃tawa nachopetü. Rü yéma nüxü̃ nadaugü ga na naṉ̃exẽxü̃ ñu̱xmata naxchúmèxãwa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Rü yexguma ga Pedru rü nüxna nacuèxãchi ga yema ĩneãcü ngupetüxü̃, rü ñanagürü Ngechuchuxü̃: —Pa Ngúexẽẽruü̃x, dücax i iguera ga chixexü̃ namaã cuxueguxü̃, rü marü narüṉ̃exẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —¡Nüxü̃́ peyaxõgü ya Tupana! ");
INSERT INTO tcaNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","—Rü aixcüma pemaã nüxü̃ chixu rü ngẽxguma chi wüxie daa mèxpǘnexü̃ tamuxgu na yaxũgachixü̃cèx rü taxtü i taxü̃chiüwa nügü na yatáexü̃cèx, rü chi pega naxĩnü, ega aixcüma peyaxõgüãcüma nüxü̃ ngẽma ñapegügu. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","—Rü ngẽmacèx pemaã nüxü̃ chixu rü guxü̃ma i ṯacü i naxcèx ípec̱axü̃ i perü yumüxẽwa, rü name nixĩ na peyaxõgüxü̃ na marü penayaxuxü̃, rü aixcüma tá penayaxu. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","—Rü ngẽxguma peyumüxẽgügu, natürü nangẽxmagu i ṯacücèx texémaã na penuẽxü̃, ¡rü tüxü̃́ nüxü̃ pengechaü̃! na Penatü ya daxũgucü rü ta pexü̃́ nüxü̃ nangechaü̃xü̃cèx i perü pecadugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","—Natürü ngẽxguma pema tama tüxü̃́ nüxü̃ pengechaü̃gügu, rü Penatü ya daxũgucü rü tá ta tãũtáma pexü̃́ nüxü̃ nangechaü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Rü yemawena rü Yerucharéü̃cèx nawoegu. Rü yexguma Ngechuchu rü tupauca ga taxü̃negu yaxũgüchigüyane, rü naxcèx naxĩ ga paigüarü ãẽ̱xgacügü, rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü Yudíugüarü ãẽ̱xgacügüerugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Rü nüxna nacagüe, rü ñanagürügü: —¿Texéarü mugagu nixĩ i cunaxüxü̃ i ngẽma núma cuxüxü̃? ¿Rü texé cuxü̃ tamu na cunaxüxü̃cèx i ngẽma? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Rü yexguma ga Ngechuchu rü nanangãxü̃, rü ñanagürü nüxü̃: —Choma rü tá ta pexna chaca, rü ngẽxguma choxü̃ pengãxü̃gu i ngẽma pexna naxcèx chac̱axü̃, rü choma rü tá ta pemaã nüxü̃ chixu na texé choxü̃ muxü̃ na chanaxüxü̃cèx i ngẽma. ¿Rü texé tanamu ga Cuáü̃ na duü̃xü̃güxü̃ ínabaiü̃xẽẽxü̃cèx? ¿Rü Tupana yiĩxü̃ ga namucü rü ẽ́xna duü̃xü̃gümare? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Rü yexguma ga nümagü rü inanaxügüe ga nügümaã na yaporagatanücüüxü̃, rü ñanagürügü: —Rü ngẽxguma chi: “Tupana núma nanamu”, ñagügügu, rü nüma rü chi ñanagürü tüxü̃: “¿Tü̱xcüü̃ ga tama nüxü̃́ peyaxõgüxü̃?” ñanagürü chi tüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Rü ñuxũcürüwa rü: “Yatügümare núma nanamu”, ñatarügügü tá? Rü yema ñanagürügü yerü duü̃xü̃güxü̃ namuü̃ẽ. Yerü guxü̃ma ga duü̃xü̃gü rü nayaxõgü rü aixcüma Tupana nanamu ga Cuáü̃ na nüxü̃ yaxuxü̃cèx ga norü ore. ");
INSERT INTO tcaNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Rü yemacèx Ngechuchuxü̃ nangãxü̃gü, rü ñanagürügü: —Tama nüxü̃ tacuèx ga texé núma na namuxü̃ ga Cuáü̃ ga baiü̃xẽẽruü̃ —ñanagürügü. Rü yexguma ga Ngechuchu rü nanangãxü̃ rü ñanagürü nüxü̃: —Choma rü ta tãũtáma pemaã nüxü̃ chixu na texé choxü̃ muxü̃ na chanaxüxü̃ i ngẽma choxna naxcèx pec̱axü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Rü Ngechuchu rü inanaxügü ga ore ga cuèxruü̃gügu ixuxü̃maã na nangúexẽẽtaexü̃. Rü ñanagürü nüxü̃: —Nayexma ga wüxi ga yatü ga norü naãnegu ubanecü ücü. Rü ínanapoxegu, rü nanaxü ga wüxi ga ubaarü yauxtüxü̃xü̃chica, rü wüxi ga dauxü̃taechica na meã nüxna nadauxü̃cèx ga guxü̃ma. Rü ñu̱xũchi ñuxre ga puracütanüxü̃na nüxü̃ nadauxẽẽ. Rü namaã nanamexẽẽ na ngãxü̃gu namaã ngĩxü̃ yatoyexü̃cèx ga yema ubatanü. Rü ñu̱xũchi ga yema naãneãrü yora rü to ga nachiü̃ãnewa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","—Rü yexguma nawa nanguxgu ga na yadauxü̃ ga yema ubagü, rü guma yatü rü yéma puracütanüxü̃güxü̃tawa nanamu ga wüxi ga norü duü̃xü̃xü̃ na naxcèx íyac̱axü̃cèx ga yema ubagü ga nüxna üxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","—Natürü yema puracütanüxü̃gü rü nayayauxgü, rü nanac̱uaixgü ga guma yatüarü duü̃xü̃. Rü taxuü̃ma ga ubagü nüxna naxãgü, rü yemaãcü ínayamugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","—Rü yexguma ga guma yatü rü to ga norü duü̃xü̃xü̃ yéma namu. Natürü ga guma rü nayamèxẽrugü, rü namaã naguxchigagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","—Rü yexguma rü to ga norü duü̃xü̃xü̃ yéma namu. Natürü nayamèxgü. Rü yemawena, rü yéma nanamugü ga muxü̃ma ga togü ga norü duü̃xü̃gü. Natürü ga yema puracütanüxü̃gü rü nayac̱uaixgü ga ñuxre, rü togü rü nanadai. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","—Rü yexguma rü nüxü̃́ ínayaxü ga nanexü̃chi ga poraãcü nüxü̃ nangechaü̃cü. Rü düxwa guma nanexü̃ yéma namu, yerü nüma nagu naxĩnügu rü chi nanega naxĩnüẽ ga yema puracütanüxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","—Natürü yexguma guma cori nanexü̃ nadaugügu ga yema puracütanüxü̃gü, rü nügümaã ñanagürügü: “Ngẽmaãrü tá nixĩ i ñaã naãne i yixcama. ¡Rü ngĩxã tayamèxgü na tóxrü na yiĩxü̃cèx!” ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","—Rü yemaãcü nayayauxgü, rü nayamèxgü. Rü yema ubanecüpechinüwa nayatèxgü ga naxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—Rü ñu̱xma rü pexna chaca, ¿pexcèx rü ṯacü tá naxü ya yima ubanecüarü yora namaã i ngẽma puracütanüxü̃gü i chixexü̃gü? Rü dücax, rü nge̱ma tá naxũ, rü tá nanadai i ngẽma puracütanüxü̃gü, rü togüna tá nanaxã i ngẽma ubanecü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","—¿Taguma ẽ́xna nawa pengúe i Tupanaãrü ore i ümatüxü̃? Erü ngẽmawa rü ñanagürü: “Rü yima nuta ya mecü ya ĩãrü üruü̃gü nüxü̃ oechirécü, rü ñu̱xma rü yimatama nixĩ ya Tupana nüxĩra yaxücuchicü na namaã inaxügüãxü̃cèx ya ĩpata. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Rü tórü Cori ya Tupana nixĩ ga naxücü ga yema, rü ñu̱xma rü namexẽchi i taxcèx”, ñanagürü i ngẽma ore. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Rü yexguma ga yema paigüarü ãẽ̱xgacügü, rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü Yudíugüarü ãẽ̱xgacügüerugü, rü Ngechuchuxü̃ niyauxgüchaü̃. Yerü nüxü̃ nacuèxgü ga nachiga na yiĩxü̃ ga yema ore ga cuèxruü̃gu yaxuxü̃. Natürü duü̃xü̃güxü̃ namuü̃ẽ rü yemacèx taxuü̃ma namaã naxüe. Rü nüxna yéma ínixĩmare. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Rü yexguma ga yema ãẽ̱xgacügü rü Ngechuchuxü̃tawa nanamugü ga ñuxre ga norü duü̃xü̃gü ga Parichéugü rü Erodetanüxü̃gü na nüxna yacagüexü̃cèx, rü ngoxi ṯacü rü chixexü̃ ga dexamaã nüxü̃ nangãxü̃ na yemaãcü ãẽ̱xgacügüxü̃tawa na íyaxuaxü̃güãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Rü nümagü rü naxü̃tawa naxĩ, rü ñanagürügü nüxü̃: —Pa Ngúexẽẽruü̃x, nüxü̃ tacuèx rü aixcüma nixĩ i ngẽma nüxü̃ quixuxü̃ i ore. Rü tama duü̃xü̃gügamare cuxĩnü, erü tama norü düxétüxü̃negu cudawenü, natürü nacüma nixĩ i cungugüxü̃. Rü aixcüma cunangúexẽẽ i duü̃xü̃gü na Tupana naxwèxexü̃ãcüma namaxẽxü̃cèx. ¡Tomaã nüxü̃ ixu! Rü ngẽma dĩẽru ya ãẽ̱xgacü ya tacü ya Dumacü̱̃ã̱x totanüwa ngĩxü̃ yauxchaü̃cü ¿rü namexü̃ yiĩxü̃ na nüxna ngĩxü̃ taxãxü̃, rü ẽ́xna tama? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Natürü ga Ngechuchu rü nüxü̃ nacuèxama ga na chixexü̃gu namaã naxĩnüẽxü̃ ga yema duü̃xü̃gü woo meã namaã na yanadexagüxü̃. Rü yemacèx ñanagürü nüxü̃: —¿Tü̱xcüü̃ chixexü̃gu choxü̃ penguxẽẽchaü̃xü̃? ¡Nuã ngĩxü̃ pinge i wüxitachinü i dĩẽru na ngĩxü̃ chadauxü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Rü yéma naxü̃tawa ngĩxü̃ nangegü ga wüxitachinü ga dĩẽru. Rü Ngechuchu rü ñanagürü nüxü̃: —¿Texéchicünèxã rü texééga nixĩ i ngĩgu üxü̃? —ñanagürü. Rü nümagü nanangãxü̃gü, rü ñanagürügü: —Dumacü̱̃ã̱x ya ãẽ̱xgacü ya tacüchicünèxã nixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Ãẽ̱xgacüna ngĩxü̃ pexã i ngẽma ãẽ̱xgacüarü ixĩcü, rü Tupanana ngĩxü̃ pexã i ngẽma Tupanaãrü ixĩcü! —ñanagürü. Rü yexguma yema orexü̃ naxĩnüẽgu, rü namaã naḇaixãchiãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Rü yemawena rü Ngechuchuxü̃tawa ínayadaugü ga ñuxre ga Chaduchéugü. Rü nümagü nixĩ i nüxü̃ yaxugüexü̃ na tagutáma wena namaxẽxü̃ i yuexü̃. Rü yemacèx Ngechuchuna nayacagüe, rü ñanagürügü: ");
INSERT INTO tcaNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Pa Ngúexẽẽruü̃x, Moĩchéarü mugüwa rü ñanagürü: “Rü ngẽxguma wüxi ya yatü naxmèx ngexacüyane nayu̱xgu, rü name nixĩ i naẽneẽtama ngĩmaã naxãmèx i ngẽma yutecü i naxü̃mèx, na ngẽmaãcü naxãxãcüxü̃cèx ya naẽneẽ ga marü yucü”, ñanagürü ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","—Dücèx, nayexma ga 7 ga nügüeneẽgü. Rü naxãmèx ga guma yacü, natürü tauta naxãxãcüyane nayu. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","—Rü yexguma ga naĩ ga naẽneẽ nüxĩ ngĩmaã naxãmèx ga yema ngecü, natürü guma rü ta nayu rü nangexacü. Rü yexguma ga guma norü tomaẽ̱xpü̱x ga naẽneẽ nüxĩ ngĩmaã naxãmèx, natür ü yexgumarüü̃tama nüxü̃ nangupetü. Rü yemaãcü, gucüma ga guma 7 ga nügüeneẽ rü ngĩmaã naxãmèx ga yema nge. Rü gucüma nayue tauta naxãxãcüyane. Rü düxwa ngĩma rü ta iyu ga yema nge. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","—Rü dücax, ngẽxguma yuexü̃ wena maxẽgu, ¿rü ngexcürüücü naxmèx tá iyixĩ i ngẽma nge? Yerü gucüma ga guma 7 ga nügüeneẽgü ngĩmaã naxãmèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Rü yexguma ga Ngechuchu rü nanangãxü̃, rü ñanagürü nüxü̃: —Pema rü ípetüe erü tama nüxü̃ pecuèx i Tupanaãrü ore i ümatüxü̃, rü tama nüxü̃ pecuèx i ñuxãcü na naporaxü̃ ya Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","—Rü ngẽxguma yuexü̃ wena maxẽgu, rü taxúetáma tixãmèxgü rü ẽ́xna tixãtegü. Erü daxũcü̱̃ã̱x i Tupanaãrü orearü ngeruü̃gürüü̃ tá tixĩgü i ngẽxguma. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","—Pema choxna peca i yuexü̃ãrü dagüchiga. ¿Natürü tama ẽ́xna nawa pengúe i Tupanaãrü ore ga Moĩché ümatüxü̃ ga naĩxãcü ga íiy̱auxratanünechigaxü̃ íyaxuxü̃wa? Erü yema orewa rü Moĩchéxü̃ ñanagürü ga Tupana: “Choma nixĩ i Abráü̃ãrü Tupana, rü Ichaáarü Tupana, rü Acobuarü Tupana”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","—Rü ngẽma orewa nüxü̃ tacuèx rü Tupana rü maxẽxü̃ãrü Tupana nixĩ rü tama yuexü̃ãrü Tupana nixĩ, erü Tupanaarü ĩnüwa rü taxúema tayu. Rü ngẽmaãcü i pema rü poraãcü ípetüe —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Rü wüxi ga ngúexẽẽruü̃ ga Moĩchéarü mugüwa ngu̱xẽẽtaexü̃, rü nüxü̃ naxĩnü ga yema togü ga namücügü ga Ngechuchumaã na íyaporagatanücüüxü̃. Rü nüma rü nüxü̃ nicuèxãchi ga meãma na nangãxü̃ãxü̃. Rü yemacèx Ngechuchucèx nixũ, rü nüxna naca, rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃x, ¿ngẽxü̃rüüxü̃ i Tupanaãrü mu nixĩ i guxü̃ i norü mugüarü yexera ixĩxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Ngẽma Tupanaãrü mu i guxü̃ i norü mugüarü yexera ixĩxü̃, rü ñaã nixĩ, ñanagürü: “¡Iperüxĩnüẽ, Pa Iraéanecü̱̃ã̱xgü! Rü nüma ya Cori ya tórü Tupana, rü yixicatama nixĩ ya tórü Cori. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","¡Rü nüxü̃ nangechaü̃ ya Cori ya curü Tupana guxü̃ne ya curü maxü̃nemaã, rü guxü̃ i cuãẽmaã, rü guxü̃ i nagu curüxĩnüxü̃maã, rü guxü̃ i curü poramaã!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","—Rü ngẽma norü taxre i Tupanaãrü mu, rü ñanagürü: “¡Rü nüxü̃ nangechaü̃ i cumücü na cugü cungechaü̃xü̃rüü̃!” ñanagürü. Rü nataxuma i to i Tupanaãrü mu i ngẽmagüarü yexera ixĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Rü yexguma ga yema ngúexẽẽruü̃ ga mugüwa ngu̱xẽẽtaexü̃, rü ñanagürü Ngechuchuxü̃: —Marü name, Pa Ngúexẽẽruü̃x, erü aixcüma nixĩ i ngẽma nüxü̃ quixuxü̃ na wüxixicatama na yiĩxü̃ ya Tupana, rü nataxuma ya naĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","—Rü ngẽma Tupanaxü̃ na ingechaü̃xü̃ guxü̃ne ya tórü maxü̃nemaã, rü guxü̃ i nagu rüxĩnüxü̃maã, rü guxü̃ i tórü poramaã, rü nüxü̃ na ingechaü̃xü̃ i tamücü i yigü na ingechaü̃xü̃rüü̃, rü ngẽma rü guxü̃ma i carnerugü i Tupanacèx idèi̱xü̃ rü íguxü̃arü yexera narümemae —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga mexü̃gu na naxĩnüãcüma na nangãxü̃ãxü̃ ga yema ngúexẽẽruü̃ ga mugüwa ngu̱xẽẽtaexü̃, rü ñanagürü nüxü̃: —Marü tama taxü̃ cuxü̃́ nataxu na cunayaxuxü̃ ya Tupana na curü ãẽ̱xgacü yiĩxü̃cèx —ñanagürü. Rü yemawena rü marü taxuü̃ma nügü naporaxẽẽ na nüxna yacachigüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Rü yexguma tupauca ga taxü̃newa ínangúexẽẽtaeyane ga Ngechuchu, rü duü̃xü̃güna naca, rü ñanagürü: —¿Tü̱xcüü̃ nixĩ i ngẽma ngúexẽẽruü̃gü i mugüwa ngu̱xẽẽtaegüxü̃ i ñagüxü̃: “Yima Cristu ya Tupana nüxü̃ unetacü rü nuxcümaü̃cü ga ãẽ̱xgacü ga Dabítaa nixĩ”, ñagüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","—¿Rü ñuxãcü i ngẽmaãcü yadexagüxü̃? Yerü nümatama ga Dabí, rü yexguma Tupanaãẽ i Üünexü̃ naãẽwa ideaxgu rü ñanagürü: “Cori ya Tupana rü chorü Corixü̃ ñanagürü: ‘¡Nuã chorü tügünecüwawa rüto ñu̱xmatáta nüxü̃ charüporamaẽ i curü uwanügü na cuga naxĩnüẽxü̃cèx!’ ” ñanagürü ga yema orewa. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","—¿Natürü ñuxũcürüwa i Dabítaa yiĩxü̃ ya Cristu, ega nümatama ga Dabí, rü norü Corimaã naxuãgu? —ñanagürü. Rü yema muxü̃ma ga duü̃xü̃gü ga yéma yexmagüxü̃, rü taãẽãcüma Ngechuchuaxü̃́ inarüxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ngechuchu rü norü ngu̱xẽẽtaewa rü ñanagürü: —¡Pexuãẽgü naxcèx i ngẽma ngúexẽẽruü̃gü i Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃! Erü nümagü rü norü me nixĩ i mexü̃ i naxchirumaã na naxĩãneãxü̃. Rü nanaxwèxegü na ítamü̃wa duü̃xü̃gü meã nüxü̃ na rümoxẽgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","—Rü ngutaquẽ́xepataü̃güwa rü norü me nixĩ i ãẽ̱xgacügümèxwẽ́xewa na natogüxü̃. Rü õnagü i taxü̃wa rü ngẽma õnaãrü yoraxü̃tawa ügüxü̃ i nachicacèx nadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","—Natürü tüxna nanapuxü̃ ya tümapatagü ya yíxema yutegüxe. Rü ñu̱xũchi nanamèxẽẽ i norü yumüxẽgü na ngẽmagu nügü yacu̱xgüxü̃cèx rü duü̃xü̃gü nagu rüxĩnüẽxü̃cèx na aixcüma mexü̃gü na yixĩgüxü̃. Natürü nümagü tá nixĩ i yexeraãcü napoxcuexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wüxicana ga Ngechuchu rü tupauca ga taxü̃neãrü dĩẽruchiü̃ãrü to̱xmèxtawa narüto. Rü yéma inadawenü ga ñuxãcü duü̃xü̃gü yexma ngĩxü̃ yanaxücuchigüxü̃ ga norü dĩẽrugü. Rü muxü̃ma ga duü̃xü̃gü ga idĩẽruã̱xgüxüchixü̃ rü yexma ngĩxü̃ nayarüxücuchigü ga muxũchicü ga norü dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Rü ngürü yéma ingu ga wüxi ga yutecü ga ngearü dĩẽruã̱xcü. Rü ngĩma rü wüxi ga yema dĩẽruchiü̃gu ngĩxü̃ iyarüxücuchi ga taxretachinü ga dĩẽruxacü ga ítanücü. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Rü yexguma ga Ngechuchu rü norü ngúexü̃gücèx naca, rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü ñaã ngecü i yutecü i ngearü dĩẽruã̱xcü, rü guxü̃ i ngẽma togü i dĩẽruchiü̃gu dĩẽru ngĩxü̃ ixücuchigüxü̃ãrü yexera ngĩxü̃ ixã. ");
INSERT INTO tcaNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Erü guxü̃ma i togü rü ngĩxü̃ inaxãgü i ngẽma nüxü̃́ íyaxügücü. Natürü ngĩma ngĩxü̃́ natauxyane ngĩxü̃ ixã i gu̱xcüma i ngĩxü̃́ ngẽxmèxcü i ngĩrü õnatanü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Rü yexguma tupauca ga taxü̃newa ínaxũxũgu ga Ngechuchu, rü wüxi ga norü ngúexü̃gü rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃x ¡dücax ñuxãcü nimexẽchi ya daa tupauca ya itaxü̃ne rü naxtapü̱xarü nutagü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Natürü Ngechuchu nanangãxü̃, rü ñanagürü: —Pema nüxü̃ pedaugü ya guxü̃nema ya yima tupauca ya taxü̃neãrü ĩpatagü. Natürü pemaã nüxü̃ chixu rü aixcüma guxü̃nema ya daa ĩpatagü rü tá nagu napogüe. Rü norü nutagü rü taxucütáma nügüétü naxüxüra, rü bai tá ya wüxi —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Rü yemawena rü Oríbunecüarü Mèxpǘne ga tupauca ga taxü̃neãrü to̱xmèxtawa yexmanewa naxĩ. Rü yéma narüto ga Ngechuchu. Rü Pedru rü Chaü̃tiágu rü Cuáü̃ rü Aü̃dré rü naxü̃tawa naxĩ na noxrüwama nüxna nacagüexü̃cèx. Rü ñanagürügü: —Tanaxwèxe i tomaã nüxü̃ quixu na ñuxgu tá nangupetüxü̃ i ngẽma nüxü̃ quixuxü̃. ¿Rü ṯacü tá nixĩ i norü cuèxruü̃ i nawa nüxü̃ tacuáxü̃ ega nawa tá nanguxgu i ngẽma? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Rü yexguma ga Ngechuchu rü nanangãxü̃ rü ñanagürü nüxü̃: —¡Pexuãẽgü na taxúema pexü̃ womüxẽẽxü̃cèx! ");
INSERT INTO tcaNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","—Erü muxũchixü̃ i duü̃xü̃gü tá ínangugü, rü chaugu tá nügü nicu̱xgü, rü ñanagürügü tá: “Choma nixĩ i Cristu”, ñanagürügü tá. Rü muxũchixü̃ i duü̃xü̃güxü̃ tá nawomüxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","—Rü ngẽxguma nüxü̃ pexĩnüẽgu na nügü nadèi̱xü̃ i nachiü̃ãnegü i ngaicamagüxü̃ rü togü i nachiü̃ãnegü i yaxü̃gugüxü̃, ¡rü tãũtáma ngẽmacèx peḇaixãchiãẽgü! Erü woetama ngẽmaãcü tá nangupetü. Natürü tãũtáma naãneãrü gu̱x nixĩ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","—Erü wüxi i nachiü̃ãne rü to i nachiü̃ãnemaã tá nügü nadai. Rü wüxi ya ãẽ̱xgacüarü churaragü rü to i ãẽ̱xgacüarü churaragümaã tá nügü nadai. Rü muxü̃ma i nachicawa rü tá naxĩã̱xãchiane. Rü tá taiya nangu̱x. Natürü guxü̃ma i ngẽma rü norü ügümare nixĩ i ngẽma ngúxü̃ i tá ínguxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","—¡Rü meã pegüna pedaugü! Erü ãẽ̱xgacügüpẽ́xewa tá pexü̃ nagagü, rü ngutaquẽ́xepataü̃gügu tá pexü̃ nic̱uaixgü. Rü nachiü̃ãnegüarü ãẽ̱xgacügüpẽ́xewa tá pexü̃ nagagü naxcèx na chorü duü̃xü̃gü na pixĩgüxü̃. Natürü ngẽmaãcü tá pexü̃́ natauxcha na ngẽma ãẽ̱xgacügümaã nüxü̃ pixuxü̃ i chauchiga. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","—Natürü naxü̃pa na nagúxü̃ i naãne rü tá nüxü̃ nixugüe i Tupanaãrü ore i guxü̃ i nachiü̃ãnegüwa. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","—Natürü ngẽxguma ãẽ̱xgacügüpẽ́xewa pexü̃ nagagügu, ¡rü tãũtáma pexoegaãẽgü naxcèx na ṯacümaã tá penangãxü̃xü̃! ¡Rü namaã nüxü̃ pixu i ngẽma ore i ngẽxgumatama Tupana pexna ãxü̃ na nüxü̃ pixuxü̃cèx! Erü tãũtáma pema nixĩ na pidexagüxü̃, natürü Tupanaãẽ i Üünexü̃ tá nixĩ i pewa idexaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","—Rü nügüeneẽgüwa tátama rü ãẽ̱xgacügüxü̃tawa nügü ínayaxuaxü̃gü na ngẽmaãcü tüxü̃ nadèi̱xü̃cèx. Rü ngẽxgumarüü̃ tá ta i papágü rü mamágü rü tá naxãcügüxü̃ ínayaxuaxü̃gü. Rü nümagü i naxãcügü rü tá nanatügümaã rü naẽgümaã nanuẽ, rü tá tüxü̃ ínayaxuaxü̃gü na ãẽ̱xgacügü tüxü̃ nadèi̱xü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","—Rü guxü̃ i naãnewa rü duü̃xü̃gü tá pexchi naxaie naxcèx na chorü duü̃xü̃gü pixĩgüxü̃. Natürü yíxema nae̱tüwa meã Tupanaãxü̃́ yaxõõmáxẽ, rü yíxema tá tixĩ ya aixcüma nayaxúxe i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","—Rü ngẽxguma nüxü̃ pedèu̱xgu i ngẽma ãũãchixü̃ rü ãũcümaxü̃chixü̃ i chixexẽẽruü̃ i ngextá tama íinaxwèxexü̃wa na nangẽxmaxü̃, rü ngẽxguma ya yíxema Yudéaanewa ngẽxmagüxe, rü tanaxwèxe i mèxpǘneãnewa tabuxmü. Rü texé ya yíxema nüxü̃ daumatüxe, ¡rü name nixĩ i meã nagu tarüxĩnü i ngẽma! ");
INSERT INTO tcaNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","—Rü ngẽma ngunexü̃gu texé tümapataèxtüwa ngẽxmagu, rü tama name i tümapatagu tayangaxi na ṯacü i tümaãrü ngẽmaxü̃ tayayaxuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","—Rü texé ya tümaãnewa ngẽxmaxẽ rü tama name i tümapatacèx tataegu na tümachirugü tayayaxuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","—Rü ngẽma ngunexü̃gügu, rü wüxi i ngechaü̃ tá nixĩ i tümacèx ya yíxema ngexegü ya itacharaü̃güxe rü yíxema maĩxãcügüxe. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","—¡Rü Tupanana naxcèx peca i perü yumüxẽwa na tama gáuane ixüyane pexü̃ na nangupetüxü̃cèx i ngẽma chixexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","—Erü ngẽma ngunexü̃gügu rü poraãcü tá nangẽxma i ngúxü̃ ga noxri Tupana naãne ixügügumama taguma yexmaxü̃, rü ngẽmawena rü tagutáma nangẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","—Rü ngẽxguma Tupana tama nanoxrexẽẽgu i ngẽma ngunexü̃gü, rü taxúetáma tamaxü̃. Natürü Tupana rü marü nananoxrexẽẽ i ngẽma ngunexü̃gü erü tüxü̃ nangechaü̃ ya yíxema noxrüxü̃ tüxü̃ nadexe. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","—Rü ngẽxguma texé pexü̃ ñagügu: “Dücèx, daa nixĩ ya Cristu”, ñagügu, rü ẽ́xna: “Gua nixĩ ya Cristu”, ñagügu, ¡rü tãxṹ i nüxü̃́ peyaxõgüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","—Erü Cristugüneta rü Tupanaãrü orearü uruü̃güneta tá ínangugü. Rü tá nanaxügü i muxü̃ma i cuèxruü̃gü i taxü̃gü. Rü ngẽmaãcü, ega nüxü̃́ natauxchagu, rü tá tüxü̃ nawomüxẽẽgü woo ya yíxema duü̃xẽgü ya Tupanatama tüxü̃ dexe. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","—¡Pexuãẽgü! Erü guxü̃ma i ngẽma tá ngupetüxü̃, rü marü naxü̃pa pemaã nüxü̃ chixu. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","—Natürü marü nangupetügu i ngẽma ngúxü̃gü, rü ngẽma ngunexü̃gügu rü tá nixo ya üèxcü rü tãũtáma inabaxi ya tauemacü. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","—Rü woramacurigü rü ẽxtagü rü tá narüyi. Rü guxü̃ma i daxũwa ngẽxmaxü̃ rü tá naxĩã̱xãchitanü rü nachicana tá nixĩgachitanü. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","—Rü ngẽxguma i duü̃xü̃gü rü tá nüxü̃ nadaugü ya Tupana Nane ya duü̃xü̃xü̃ ixĩcü na caixanexü̃gu ínaxĩxü̃ i guxü̃ma i norü poramaã rü norü ngóonexü̃maã. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","—Rü tá nanamu i norü orearü ngeruü̃gü i daxũcü̱̃ã̱x na tüxü̃ nanutaquẽ́xexü̃cèx ya yíxema Tupana tüxü̃ idexechixe ya guxü̃wama ngẽxmagüxe ñu̱xmatáta naãne íyacuáxü̃wa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","—¡Iperüxĩnüẽ i ñaã ngu̱xẽẽtae i ori̱x i iguerachiga, rü naxcèx pengúe! Rü ngẽxguma ngexwacaxü̃xü̃ i nachacüüxacügü iyarüyixgu rü naxüátügu, rü ngẽmawa nüxü̃ pecuèx na paxa tá taunecü yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","—Rü ngẽxgumarüü̃ ta, rü ngẽxguma nüxü̃ pedèu̱xgu na nangupetüxü̃ i ngẽma pemaã nüxü̃ chixuxü̃, rü ngẽmawa tá nüxü̃ pecuèx na paxaxüchi tá ínanguxü̃ ya Tupana Nane ya duü̃xü̃xü̃ ixĩcü. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","—Rü guxü̃ma i ngẽma ñu̱xma pemaã nüxü̃ chixuxü̃ rü aixcüma tá nangupetü naxü̃pa na nayuexü̃ i ngẽma duü̃xü̃gü i ngẽxguma maxẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","—Daxũguxü̃ i naãne rü ñoma i naãne rü tá inayarüxo. Natürü chorü ore rü tagutáma inayarüxo, rü aixcüma tá ningu. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","—Natürü ngẽma ngunexü̃ rü ora i nagu tá nangupetüxü̃ i ngẽma pemaã nüxü̃ chixuxü̃, rü Tanatü ya Tupanaxĩcatama nüxü̃ nacuèx i ñuxgu tá na nangupetüxü̃ i ngẽma, rü taxúema ya togue nüxü̃ tacuèx. Rü woo i norü orearü ngeruü̃gü i daxũcü̱̃ã̱x rü tama nüxü̃ nacuèxgü, rü woo i choma na Nane chiĩxü̃ rü tama nüxü̃ chacuèx i ñuxgu tá na nangupetüxü̃ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","—Rü ngẽmacèx, ¡ipedaue rü pexuãẽgü! Erü tama nüxü̃ pecuèx i ṯacü rü ora tá íchangu i chomax. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","—Rü guxü̃ma i ngẽma pemaã nüxü̃ chixuxü̃, rü ñoma wüxi ga yatü ga ixũãchichaü̃cü na to ga nachiü̃ãnewa naxũxü̃cèxrüxü̃ nixĩ. Rü yemacèx norü puracütanüxü̃na naxãga na mea nüxna nadaugüxü̃cèx ga guma napata. Rü ñuxũchi wüxichigüna nanaxã ga norü puracü. Rü yẽma ĩã̱xãrü dauruü̃ rü nagu nanamu na mea nadauxü̃taegüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","—¡Rü ngẽmacèx i pema rü name na ípexuãxẽgüxü̃! Erü tama nüxü̃ pecuèx i ñuxgu tá ínangu ya yima cori ya ĩpataarü yora, rü bexmana noxri nachütagu, rü ẽ́xna ngãxü̃cüügu, rü ẽ́xna otá icaxgu, rü ẽ́xna noxri yangóonegu. ¡Rü ngẽmacèx ipedaue na ngürüãchi ínanguxgu tama ípepeeyane pexü̃ na íyanguéü̃xü̃cèx! ");
INSERT INTO tcaNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","—Rü ngẽma ore i pemaã nüxü̃ chixuxü̃, rü guxü̃ i duü̃xü̃gücèx nixĩ. ¡Rü ipedaueecha! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rü taxre ga ngunexü̃ nataxu ga na nawa nanguxü̃ ga Yudíugüarü peta ga Üpetüchiga ga nagu nangõ̱xgüãxü̃ ga pãũ ga ngearü puxẽẽruü̃ã́xü̃. Rü ga paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü ga mugüwa ngu̱xẽẽtaegüxü̃ rü naxcèx nadaugü ga ñuxãcü bexma duü̃xü̃güechita Ngechuchuxü̃ na yayauxgüxü̃ rü na yamèxgüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Yerü nümaxü̃ rü ñanagürügü: —Taxucürüwama ñu̱xma petagu tayayauxgü, erü duü̃xü̃gü rü tá tamaã nanuẽ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Rü Ngechuchu rü Betániãwa naxũ napatawa ga Chimáũ ga rüchaxünecümaã naxugüãcü. Rü yexguma mechawa natoyane, rü yéma ingu ga wüxi ga ngecü ga wüxiweü̃ ga pumara ga yixichixü̃ ga tatanüxü̃chixü̃ yéma ngecü. Rü iyapoyenagu ga yema pumarachixü̃ ga nuta ga mexẽchicünaxcèx, rü Ngechuchuerugu inaba. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Natürü ñuxre ga yema yéma yexmagüxü̃ rü nanuẽ naxcèx ga yema naxüxü̃ ga yema ngecü, rü nügümaã ñanagürügü: —¿Tü̱xcüü̃ ngẽxma inaxaiyaxü̃ i ngẽma pumara? ");
INSERT INTO tcaNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","—Rü narümemaẽ chi nixĩ i 300 tachinü i dĩẽrugu namaã itaxe, rü ñu̱xũchi ngẽma dĩẽrumaã nüxü̃ irüngü̃xẽẽ i ngẽma duü̃xü̃gü i ngearü dĩẽruã̱xgüxü̃ —ñanagürügü. Rü yemaãcü ngĩchiga nidexagü ga yema nge. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —¡Ngexrüma! ¿Tü̱xcüü̃ ngĩxü̃ pechixewe? Erü ngẽma chomaã naxüxü̃, rü wüxi i mexü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","—Rü ngẽma ngearü dĩẽruã̱xgüxü̃ rü guxü̃gutáma petanüwa nangẽxmagü, rü ngẽmaãcü pexü̃́ natauxcha na nüxü̃ perüngü̃xẽẽxü̃ i ngẽxguma penaxwèxegu. Natürü i choma rü tãũtáma guxü̃gu petanüwa changẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","—Rü ñaã nge rü inaxü i guxü̃ma i ngẽma ngĩxü̃́ tauxchaxü̃, rü ngẽmacèx yoxni choxü̃ ipumaraxü̃ne naxü̃pa na ichatáxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","—Rü aixcüma pemaã nüxü̃ chixu rü guxü̃ i naãnewa i ngextá duü̃xü̃gü nüxü̃ íixugügüxü̃wa i ore i maxẽxẽẽruü̃, rü ñaã ngecü chomaã üxü̃ rü tá ta nüxü̃ nixugügü. Rü ngẽmaãcü tá ngĩxna nacuèxãchie i duü̃xü̃gü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Rü Yuda Icariúte ga wüxi ga yema 12 ga ngúexü̃tanüxü̃ ixĩxü̃, rü Yudíugüarü paigüarü ãẽ̱xgacügütanüwa naxũ na namaã yamexẽẽãxü̃cèx na ñuxãcü tá na Ngechuchuxü̃ yayauxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rü yexguma yemaxü̃ naxĩnüẽgu, rü nümagü ga yema ãẽ̱xgacügü rü nataãẽgü. Rü dĩẽru Yudana ngĩxü̃ naxuaxü̃gü. Rü yexgumama inanaxügü ga Yuda ga naxcèx na nadauxü̃ ga ñuxãcü nüxü̃́ na natauxchaxẽẽgüãxü̃ na duü̃xü̃güechita Ngechuchuxü̃ yayauxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Rü nawa nangu ga ngunexü̃ ga nagu inaxügüxü̃ ga yema peta ga pãũ ga ngearü puxẽẽruü̃ã́xü̃ nagu nangõ̱xgüxü̃. Rü yema nixĩ ga ngunexü̃ ga nagu carneruxacü naxcèx yamèxgüxü̃ ga Üpetüchigaarü peta. Rü yexguma ga norü ngúexü̃gü rü Ngechuchuna nacagüe, rü ñanagürügü: —¿Ngextá cunaxwèxe na tanamexẽẽxü̃ i õna i Üpetüchigaarü petagu ingṍxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Rü yexguma ga nüma rü nanamu ga taxre ga norü ngúexü̃gü, rü ñanagürü nüxü̃: —¡Ẽcü, yéa ĩãnewa pexĩ! Rü ngẽxma tá nüxü̃ peyangau i wüxi i yatü i wüxi ya tü̃xü̃ ya dexámaã ããcuxe ngẽxma tüxü̃ ingexü̃. ¡Rü nawe perüxĩ! ");
INSERT INTO tcaNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","—¡Rü yima ĩpata ya nagu yaxücune i ngẽma yatü, rü yima ĩãrü yoramaã nüxü̃ pixu, rü ñapegügü nüxü̃: “Torü ngúexẽẽruü̃ nüxü̃ nacuáxchaü̃ na ngẽxü̃ yiĩxü̃ i ngẽma ucapu i norü ngúexü̃gümaã tá nawa nachibüxü̃ i Üpetüchigaarü õnagu”, ñapegügü nüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","—Rü nüma tá pexü̃ nüxü̃ nadauxẽẽ i wüxi i ucapu i taxü̃ i marü meã mexẽẽxü̃ i norü daxũchiü̃wa ngẽxmaxü̃. ¡Rü nge̱ma penamexẽẽ̱x i tórü õna i Üpetüchigacèx ixĩxü̃! —ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Rü inaxĩãchi ga yema taxre ga ngúexü̃gü, rü ĩãnewa naxĩ. Rü yexma nüxü̃ inayangaugü ga guxü̃ma yema Ngechuchu namaã nüxü̃ ixuxü̃rüü̃. Rü yéma nanamexẽẽ ga õna ga Üpetüchigacèx ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Rü yexguma marü nachütachaü̃gu, rü ínangu ga Ngechuchu namaã ga yema 12 ga norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Rü yexguma mechawa ínachibüeyane, rü Ngechuchu rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü wüxie ya petanüwa i ñu̱xma chomaã nuã chibüxe tá tixĩ ya bexma choxü̃ íyaxuaxü̃xẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Rü yexguma ga nümagü ga norü ngúexü̃gü rü poraãcü nangechaü̃gü. Rü inanaxügüe ga na wüxichigü nüxna icachigüxü̃, rü ñanagürügü: —Pa Corix, ¿choma tá chiĩxü̃ i cuxü̃ íchayaxuaxü̃xü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Rü nüma ga Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Wüxi i pema i 12 tanüwa i daatama poratuwa norü pãũ iwaixẽẽxü̃, rü ngẽma tá nixĩ i choxü̃ íyaxuaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","—Rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü tá chayu ngẽma Tupanaãrü ore i ümatüxü̃ nüxü̃ ixuxü̃rüü̃. Natürü wüxi i ngechaü̃xü̃chi nixĩ naxcèx i ngẽma yatü i choxü̃ íyaxuaxü̃xü̃. Rü narümemaẽ chi nixĩ ga noxtacüma tãũ chima na nabuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Rü yexguma ínachibüeyane, rü Ngechuchu nanayaxu ga pãũ. Rü Tupanana moxẽ naxã, rü inanabücu, rü norü ngúexü̃güxü̃ nayanu. Rü ñanagürü nüxü̃: —¡Penayau̱x i ñaã pãũ! Rü ngẽma rü chaxunechiga nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Rü yemawena nanayaxu ga wüxi ga pochiyu ga binumaã ããcuxü̃. Rü yexgumarüü̃ ta Tupanana moxẽ naxcèx naxãxĩra, rü ñu̱xũchi norü ngúexü̃güna nanaxã. Rü guxü̃ma nawa naxaxegü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Rü ñanagürü nüxü̃: —Daa binu ya chaugü i muxü̃ma i duü̃xü̃gücèx ibacüchiga nixĩ. Rü yimawa Tupana meãma nanango̱xẽẽ na aixcüma yiĩxü̃ i norü uneta. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","—Rü aixcüma pemaã nüxü̃ chixu rü tãxũtáma wena chayaxaxü ya daa binu ñu̱xmatáta Tupana ãẽ̱xgacü íixĩxü̃wa binu ya ngexwacaxü̃cü chayaxaxü̱x —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Rü ñu̱xũchi nawiyaegü ñuxre ga Tupanaãrü wiyaegu. Rü yemawena rü Oríbunecüarü Mèxpǘnewa naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Guxãma i pema rü tá choxü̃ ípetèxgü. Erü ngẽmaãcü nüxü̃ nixu i Tupanaãrü ore i ümatüxü̃ i ñaxü̃: “Tá chayamèx ya carneruarü dauruü̃, rü tá nanaxüanemare i carnerugü”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","—Natürü ngẽxguma marü yuwa ícharüdaxguwena, rü chaxira tá pexü̃pa Gariréaanewa chaxũ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Rü yexguma ga Pedru rü ñanagürü nüxü̃: —Woo guxü̃ma i togü cuxü̃ ítèxgu, rü choma rü tãũtáma cuxü̃ íchatèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Aixcüma cumaã nüxü̃ chixu rü ñomatama i chütaxü̃gu rü naxü̃pa na taxreẽ́xpü̱xcüna yac̱axü̃ i otá, rü tomaẽ̱xpü̱xcüna taxũtáma cugü quixu na chorü duü̃xü̃ quiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Natürü nüma ga Pedru rü ñanagürüama: —Woo wüxigu cumaã chayu̱xgu, rü tãxũtáma chaugü ichicu̱x na curü duü̃xü̃ chiĩxü̃ —ñanagürü. Rü guxü̃ma ga togü ga norü ngúexü̃gü rü ta yema ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Rü yemawena rü Ngechuchu rü norü ngúexü̃gü rü nawa naxĩ ga wüxi ga nachica ga Yechemanígu ãe̱gaxü̃. Rü Ngechuchu rü ñanagürü nüxü̃: —¡Nuã perütogü yoxni paxa yéa chayayumüxẽ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Rü ñu̱xũchi ínayagagü ga Pedru, rü Chaü̃tiágu, rü Cuáü̃. Rü naxcèx inaxügü ga na poraãcü nangechaü̃xü̃ rü naxi̱xãchiãẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Rü yexguma rü ñanagürü nüxü̃: —Poraãcü changechaü̃, rü nagu charüxĩnü na ngẽmamaã tá chayuxü̃. ¡Rü nuxa perücho i pemax, rü ipedaue! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Rü yexguma ga Ngechuchu rü yéaxüra naxũ. Rü ñaxtüanegu nanangücuchi. Rü Tupanana naxcèx naca na nawa ínanguxuchixü̃cèx ga yema ngúxü̃ ga yexguma chi Tupanaãrü ngúchaü̃ yixĩgu. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Rü norü yumüxẽwa rü ñanagürü: —Pa Chaunatüx, cuxcèx rü guxü̃ma natauxcha. ¡Rü nüxna choxü̃ ínanguxuchixẽẽ i ñaã ngúxü̃ i tá choxü̃ üpetüxü̃! Natürü chanaxwèxe i cunaxü i cuxrütama ngúchaü̃ rü tama i choxrü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Rü ñu̱xũchi nataegu ga norü ngúexü̃gü íyexmagüxü̃wa. Rü nüxü̃ inayangau ga na ínapeexü̃. Rü ñanagürü Pedruxü̃: —Pa Chimáũx, ¿ícupe? ¿Tama ẽ́xna namaã cupora na icudauxü̃, rü bai i wüxi i ora? ");
INSERT INTO tcaNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","—¡Rü ipedaue, rü Tupanana naxcèx pec̱a na pexü̃ nangü̃xẽẽxü̃cèx na tama choxü̃ ípetáxü̃cèx i ngẽxguma ṯacü rü guxchaxü̃ pexü̃ üpetügu! Erü aixcüma peãẽwa rü ípememare, natürü pexene nixĩ i ngẽma turaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Rü wenaxãrü ínixũ, rü noxrirüü̃tama nayayumüxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Rü yexguma wenaxãrü norü ngúexü̃gücèx nataegugu, rü nüxü̃ inayangau ga na wenaxãrü ínapeexü̃, yerü poraãcü nayaxtaexüchi. Rü yemacèx ga nümagü rü tama nüxü̃ nacuèxgü ga na ṯacümaã tá nangãxü̃güãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Rü norü tomaẽ̱xpü̱xcüna wenaxãrü norü ngúexü̃gücèx nataegu, rü ñanagürü nüxü̃: —¿Ñu̱xma rü ta ẽ́xna ípepeeama rü iperüngü̃ẽãma? ¡Rü marütama! Erü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃ rü marü nawa nangu i ora na choxü̃ na yayauxgüxü̃ rü nüxna na choxü̃ namugüxü̃cèx i duü̃xü̃gü i chixexü̃ i pecaduã̱xgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","—¡Rü ipechigü, rü ngĩxã ítixĩ! Erü marü ñomama nixĩ i ngẽma choxü̃ íyaxuaxü̃xü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Rü yexguma íyadexayane ga Ngechuchu, rü ínangu ga Yuda ga norü ngúexü̃chirẽ́x ixĩxü̃. Rü nawe narüxĩ ga muxü̃ma ga duü̃xü̃gü ga taramaã rü naĩmaã ixãxnexü̃. Rü yema nixĩ ga duü̃xü̃gü ga yéma namugüxü̃ ga paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü ga mugüwa ngu̱xẽẽtaegüxü̃ rü Yudíugüarü ãẽ̱xgacügüerugü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Rü Yuda ga ínaxuaxü̃xü̃ rü marü yema duü̃xü̃gümaã nanamexẽẽ, rü ñanagürü: “Ngẽma nüxü̃ chachúxuxü̃ nixĩ i Ngechuchu. Rü ngẽma tá nixĩ i piyauxgüxü̃ rü meã peyanáĩãcüma peyagagüxü̃” —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Rü yemaãcü Ngechuchucèx nixũ, rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃x —ñanagürü. Rü ñu̱xũchi nanachúxu. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Rü yexgumatama Ngechuchuxü̃ niyauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Natürü wüxi ga Ngechuchutanüxü̃ nanawẽ́xechi ga norü tara, rü yemamaã paigüarü ãẽ̱xgacüarü duü̃xü̃xü̃ ínadaechinü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Rü yexguma ga Ngechuchu rü yema duü̃xü̃güna naca, rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ taragü rü naĩxmenèxãgümaã chauxcèx nuã pexĩ na choxü̃ peyarüyauxgüxü̃cèx ñoma wüxi i ngĩ́tèxáxü̃ chiĩxü̃rüü̃? ");
INSERT INTO tcaNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","—Rü guxü̃ ga ngunexü̃gu rü petanüwa chayexma ga yexguma tupauca ga taxü̃newa changu̱xẽẽtaegu, rü taguma choxü̃ piyauxgü. Natürü ñaã ñu̱xma ngupetüxü̃, rü nangupetü na yanguxü̃cèx i Tupanaãrü ore i ümatüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Rü yexguma ga guxü̃ma ga norü ngúexü̃gü rü nüxna nibuxmü. Rü nüxĩcatama yéma nanatèxgü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Natürü wüxi ga ngextü̱xücü ga düxruü̃maãxĩca nügü nuquecü nawe nixũchigü. Rü yema duü̃xü̃gü rü nayayauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Natürü nüma rü nüxü̃ ningẽ́x ga yema düxruü̃, rü yemaãcü ngexchiruãcüma niña. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Rü yexguma ga yema duü̃xü̃gü rü paigüarü ãẽ̱xgacüpẽ́xewa nanagagü ga Ngechuchu. Rü yexma nangutaquẽ́xegü ga guxü̃ma ga togü ga paigü ga ãẽ̱xgacügü ixĩgüxü̃, rü yema Yudíugüarü ãẽ̱xgacügüerugü, rü yema ngúexẽẽruü̃gü ga mugüwa ngu̱xẽẽtaegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Natürü ga Pedru rü yaxü̃gu nawe nixãchigü ñu̱xmata guma paigüarü ãẽ̱xgacüpataèxtüwa nangu. Rü purichíagü ga tupauca ga taxü̃neãrü dauruü̃gümaã yéma ĩã̱xtüwa narüto. Rü nügü yéma nanaĩxü̃ üxüxü̃tawa. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Rü yema paigüarü ãẽ̱xgacügü rü guxü̃ma ga yema togü ga ãẽ̱xgacügü ga itaxü̃ rü naxcèx nadaugü ga ñuxãcü Ngechuchuxü̃ na ínaxuaxü̃güxü̃ rü na yamèxgüãxü̃cèx. Natürü taxucürüwa nüxü̃ inayangaugü ga ṯacücèx tá na yamèxgüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yerü woo muxü̃ma ga duü̃xü̃gü rü nüxü̃ nixugüe ga doramare ga nachiga, natürü nügütanüwatama rü tama nawüxigu ga norü ore. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","58","Rü ñuxre ga togü inachigü rü doraxü̃mare nixugüe ga Ngechuchuchiga. Rü ñanagürügü: —Toma nüxü̃ taxĩnüẽ ga na ñaxü̃: “Tá chanangutaxü̃xẽẽ ya daa tupauca ya taxü̃ne ya duü̃xü̃gü üxü̃ne. Rü tomaẽ̱xpü̱x i ngunexü̃gu tá chanaxü ya náĩ ya tama duü̃xü̃gü üxü̃ne”, ñaxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Natürü woo yema oremaã, rü tama nawüxiguéga ga norü ore. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Rü yexguma ga guma paigüarü ãẽ̱xgacü rü guxü̃pẽ́xewa inachi. Rü Ngechuchuna naca, rü ñanagürü: —¿Ẽ́xna taxuxü̃maãma cunangãxü̃ i ñu̱xmax? ¿Rü ṯacü nixĩ i ngẽma nüxü̃ yaxugüxü̃ i cuchiga? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Natürü ga Ngechuchu rü nangeèxmare, rü taxuxü̃maãma nanangãxü̃. Rü yemacèx ga nüma ga paigüarü ãẽ̱xgacü rü wenaxãrü nüxna naca, rü ñanagürü: —¿Rü cuma quiĩxü̃ ya Cristu ya Tupana ya mecü Nane? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Rü Ngechuchu rü ñanagürü nüxü̃: —Ngü̃. Ngẽma nüxü̃ quixuxü̃ chixĩ. Rü tá choxü̃ pedaugü i ngẽxguma Tupana ya poracüarü tügünecüwawa charüto̱xgu rü ngẽxguma caixanexü̃gu wenaxãrü núma chaxũxgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Rü yexguma ga guma paigüarü ãẽ̱xgacü rü norü numaã nügüchirugu nagaugü. Rü ñanagürü: —¿Tü̱xcüü̃ marü tanaxwèxe i to i duü̃xü̃ i nüxü̃ ixugüxü̃ i nachiga? ");
INSERT INTO tcaNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","—Rü pematama marü nüxü̃ pexĩnüẽ na ñuxãcü Tupanamaã naguxchigaxü̃. ¿Rü ñuxũ ñapegüxü̃ i ñu̱xmax? —ñanagürü. Rü guxü̃ma wüxigu narüxĩnüẽ rü: —Aixcüma nixĩ na chixexü̃ naxüxü̃ rü namexü̃ na nayuxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Rü ñuxre ga nümagü rü inanaxügüe ga nüxna na nac̱uaixgüexü̃. Rü nanatüxetügü rü ñu̱xũchi nüxü̃ nidagügü ñaxü̃maã: —¡Nüxü̃ nacuèx na texé cuxü̃ idagüxü̃! —ñanagürügü. Rü yema tupauca ga taxü̃neãrü dauruü̃gü ga purichíagü rü nanapechiwegü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Rü yoxni ga Pedru rü ñaxtüwa ãẽ̱xgacüpataèxtüwa nayexma. Rü yexgumayane yéma ingu ga wüxi ga pacü ga guma ãẽ̱xgacüarü duü̃xü̃ ixĩcü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Rü yexguma Pedruxü̃ nadèu̱xgu ga yéma üxüxü̃tawa nügü na nanaĩxü̃xü̃, rü meã nüxü̃ idawenü, rü ngĩgürügü nüxü̃: —Cuma rü ta namücü quixĩ i ngẽma Ngechuchu i Nacharétucü̱̃ã̱x —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Natürü ga Pedru rü nügü inicu̱x na Ngechuchuarü duü̃xü̃ yiĩxü̃, rü ñanagürü: —Choma rü tama nüxü̃ chacuèx ya yima. Rü tama nüxü̃ chacuèx i ṯacüchiga nixĩ i ngẽma nüxü̃ quixuxü̃ —ñanagürü. Rü yexguma ga nüma rü ĩpataèxtüarü düxétüwa naxũ. Rü yexgumatama nica ga otá. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Natürü ga yema pacü rü wenaxãrü Pedruxü̃ idau, rü inaxügü ga yema togümaã nüxü̃ na yaxuxü̃, rü ngĩgürügü: —Ñaã rü wüxi i natanüxü̃ nixĩ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Natürü nüma ga Pedru rü wena tama nügü nixu. Rü yixcamaxü̃ra rü yema duü̃xü̃gü ga yéma yexmagüxü̃ rü wenaxãrü ñanagürügü nüxü̃: —Aixcüma nixĩ na cuma rü ta ngẽma Ngechuchutanüxü̃ na quiĩxü̃, erü wüxi i Gariréaanecü̱̃ã̱x quixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Rü yexguma ga Pedru rü poraãcü nügü nixã, rü ñanagürü: —Rü aixcüma tama nüxü̃ chacuèx i ngẽma yatü i nachiga pidexagüxü̃. Rü ngẽxguma doraxü̃ chixuxgu rü ¡Tupana choxü̃ poxcux! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Rü yexgumatama norü taxreẽ́xpü̱xcüna nica ga otá. Rü yexguma ga Pedru rü nüxna nacuèxãchi ga yema ore ga ü̃paacü Ngechuchu namaã nüxü̃ ixuxü̃ ga ñaxü̃: “Rü naxü̃pa na taxreẽ́xpü̱xcüna otá ic̱axü̃, rü cuma rü tá tomaẽ̱xpü̱xcüna cugü quicu̱x na chorü duü̃xü̃ quiĩxü̃”, ñaxü̃. Rü yexguma ga Pedru rü poraãcüxüchima naxaxu. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Rü yexguma yangunegu, rü nangutaquẽ́xegü ga ãẽ̱xgacügü ga taxü̃gü ga paigüarü ãẽ̱xgacügü rü Yudíugüarü ãẽ̱xgacügüerugü rü ngúexẽẽruü̃gü ga mugüwa ngu̱xẽẽtaegüxü̃ rü guxü̃ma ga togü ga yema ãẽ̱xgacügütanüwa ügüxü̃. Rü Ngechuchuxü̃ yanèĩ̱xgüchacüüãcüma ãẽ̱xgacü ga Piratuxü̃tawa nanagagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Rü nüma ga Piratu rü Ngechuchuna naca rü ñanagürü: —¿Cuma quiĩxü̃ i Yudíugüarü ãẽ̱xgacü ya tacü? —ñanagürü. Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Ngü̃, yima nüxü̃ quixucü chixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","4","Natürü yema paigüarü ãẽ̱xgacügü rü poraãcü ínanaxuaxü̃güama, rü yemacèx ga Piratu rü wenaxãrü Ngechuchuna naca, rü ñanagürü: —¿Ẽ́xna taxuxü̃maãma cunangãxü̃? ¡Dücèx i ñuxre i cuchiga i nüxü̃ yaxugüexü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Natürü ga Ngechuchu rü taxuxü̃maãma nanangãxü̃. Rü yemacèx ga Piratu rü poraãcü naḇaixãchiãẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Rü gucü ga taunecügu ga yexguma yema Üpetüchigaarü petawa nanguxgu rü Piratu ínananguxuchixẽẽxü̃ ga wüxi ga poxcuxü̃ ga duü̃xü̃gü naxcèx ícagüxü̃, yerü yema nixĩ ga nacüma. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Rü wüxi ga yatü ga Barabágu ãe̱gaxü̃, rü poxcupataü̃gu napoxcu wüxigu namaã ga togü ga natanüxü̃ ga máẽtagüxü̃ ga yexguma ãẽ̱xgacüxü̃ ínatèxüchigüchaü̃gu. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Rü yema duü̃xü̃gü rü yéma Piratuxü̃tawa nangugü. Rü inanaxügüe ga Piratuna na nacagüexü̃ na naxcèx yangéãxü̃cèx ga wüxi ga poxcuxü̃ aixrügumarüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Rü Piratu nanangãxü̃, rü ñanagürü: —¿Penaxwèxexü̃ na pexcèx íchananguxuchixẽẽxü̃ ya yima Ngechuchu ya duü̃xü̃gü Yudíugüarü ãẽ̱xgacümaã naxugüãcü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Rü yema ñanagürü ga Piratu yerü nüxü̃ nacuèx ga na yema paigüarü ãẽ̱xgacügü rü na yaxauxãchiexü̃cèx yiĩxü̃ ga Ngechuchu nüxna yamugüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Natürü ga yema paigüarü ãẽ̱xgacügü rü duü̃xü̃güxü̃ namugü ga na tagaãcü naxcèx ínacagüxü̃ ga na Barabáxü̃ yangéxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Rü yexguma ga Piratu rü nüxna naca, rü ñanagürü: —¿Rü ṯacü nixĩ i penaxwèxexü̃ na chanaxüxü̃ namaã ya yima Yudíugüarü Ãẽ̱xgacügu pexüégacü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Rü nümagü ga duü̃xü̃gü rü tagaãcü nanangãxü̃gü, rü ñanagürügü: —¡Curuchawa yapota! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Rü yexguma ga Piratu rü ñanagürü nüxü̃: —¿Natürü ṯacü rü chixexü̃ naxü? —ñanagürü. Natürü ga nümagü rü wenaxãrü tagaãcü ñanagürügü: —¡Curuchawa yapota! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Rü yexguma ga Piratu rü Barabáxü̃ ínanguxuchixẽẽ, yerü duü̃xü̃güxü̃ nataãẽxẽẽchaü̃. Rü yexguma churaragüxü̃ Ngechuchuxü̃ nac̱uaixẽẽguwena ga Piratu, rü ñu̱xũchi nüxna nanamu na curuchawa yanapotagüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Rü yexguma ga nümagü ga churaragü rü ãẽ̱xgacüpataèxtüwa nanagagü. Rü yéma nanangutaquẽ́xexẽẽ ga guxü̃ma ga namücügü ga churaragü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Rü ñu̱xũchi ga yema churaragü rü wüxi ga máxü̃ ga daucharaxü̃ ga naxchirugu nayacu̱xẽẽgü. Rü naẽruwa nayangèxcuchigü ga wüxi ga boxü̃ ga chuchuxü̃wa naxügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Rü yemawena inanaxügüe na tagaãcü ñagüxü̃: —¡Namaxü̃ ya Yudíugüarü ãẽ̱xgacü! —ñagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Rü wüxi ga naĩxmenèxãmaã naẽruwa nanac̱uaixcagü, rü nüxna nacuaixgüe. Rü napẽ́xegu nacaxã́pü̱xügü rü nüxü̃ nicuèxüü̃güneta. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Rü yexguma yemaãcü nagu yadauxcüraxü̃güguwena, rü ínanacu̱xuchigü ga yema naxchiru ga daucharaxü̃. Rü wenaxãrü naxchirugutama nayacu̱xẽẽgü. Rü ñu̱xũchi ínanagaxüchigü na curuchawa yanapotagüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Rü yéma naxüpetü ga wüxi ga yatü ga Chirenecü̱̃ã̱x ga Chimáũgu ãe̱gacü ga Areyáü̃dru rü Rufu nanatü ixĩcü ga naãnewa ne ũcü. Rü yexguma yéma naxüpetügu rü yema churaragü rü guma yatüxü̃ ngĩxü̃ iningexẽẽgü ga Ngechuchuarü curucha. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Rü Ngechuchuxü̃ nawa nagagü ga wüxi ga nachica ga Górgutagu ãe̱gaxü̃. Rü yema nae̱ga rü: Duü̃xẽẽruchinèxãchitaü̃, ñaxü̃chiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Rü nüxna nanaxãgü ga binu ga miramaã ãe̱ü̃cü. Natürü nüma ga Ngechuchu rü tama nayaxaxü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Rü yemawena curuchawa nayapotagü. Rü nümagü ga churaragü rü wüxi ga dĩẽru ngĩxü̃ nañanagügü na yemawa nüxü̃ nacuèxgüxü̃cèx na ñuxãcü tá nügümaã yatoyeãxü̃cèx ga Ngechuchuchiru, rü ṯacü tá na yangexü̃ ga wüxichigü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Rü meãma 9 arü oragu ga pèxmama nixĩ ga curuchawa yapotagüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rü yéma nayapocuchi ga wüxi ga mürapewa ga ãe̱gatachinüxü̃ ga nüxü̃ ixuxü̃ ga ṯacücèx curuchawa na yapotagüãxü̃. Rü yema nae̱ga ga mürapewagu üxü̃, rü ñanagürü: “Yudíugüarü Ãẽ̱xgacü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Rü naxrüü̃ curuchawa nayapotagü ga taxre ga máẽtagüxü̃ rü wüxi ga norü tügünecüwawa rü to ga norü ṯoxwecüwawa. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Rü yemaãcü ningu ga Tupanaãrü ore ga ümatüxü̃ ga ñaxü̃: “Ngẽma chixexü̃ ügüxü̃tanüwaama natèx”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Rü yema duü̃xü̃gü ga yéma chopetüxü̃, rü Ngechuchumaã naguxchigagü, rü nanexãẽrugüãcüma ñanagürügü: —¡Dücèx! Cuma cunangutaü̃xẽẽe̱ga ya tupauca ya taxü̃ne, rü tomaẽ̱xpü̱x i ngunexü̃gu wenaxãrü ícunadaxẽẽe̱ga. ¡Ẽcü! ¡Cugütama namaxẽẽ i ñu̱xmax, rü írüxĩ i curuchawa! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Rü yexgumarüü̃ ta Ngechuchuxü̃ nacugüecüraxü̃ ga paigüarü ãẽ̱xgacügü, rü ngúexẽẽruü̃gü ga ore ga mugüwa ngu̱xẽẽtaegüxü̃. Rü ñanagürügü: —Nüma rü togüxü̃ namaxẽxẽẽ, natürü taxucürüwama nügütama namaxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","—¡Ñu̱xma rü ínaxĩ̱x i curuchawa i ngẽma Cristu i Iraéanecü̱̃ã̱xãrü Ãẽ̱xgacü na nüxü̃ idaugüxü̃cèx rü nüxü̃́ yaxõgüxü̃cèx! —ñanagürügü. Rü woo ga yema máẽtagüxü̃ ga naxrüü̃ curuchawa ipotagüxü̃, rü namaã naguxchigagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Rü yexguma tocuchiwa nanguxgu, rü guxü̃ ga naãnewa naxẽãne ñu̱xmata yáuanecü tomaẽ̱xpü̱xarü orawa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Rü yematama oragu rü tagaãcü aita naxü ga Ngechuchu, rü ñanagürü: —Eríx, Eríx, ¿damá chabátani? —ñanagürü. Rü ngẽma rü ñaxü̃chiga nixĩ: “Pa Chorü Tupanax, Pa Chorü Tupanax ¿tü̱xcüü̃ choxü̃ nuã cutèx?” ñaxü̃chiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Rü nümaxü̃ ga duü̃xü̃gü ga yéma yexmagüxü̃, rü nüxü̃ naxĩnüẽ rü ñanagürügü: —¡Dücèx, nüxü̃ pexĩnüẽ! Nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Eríacèx naca —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Rü yexguma rü wüxi ga yema duü̃xü̃gü ga yéma yexmagüxü̃, rü inañaãchi rü wüxi ga tüaxmü niwaixẽẽ namaã ga binu ga marü ngúchièxüchicü. Rü wüxi ga dexnewa nayanèĩ̱x, rü ñu̱xũchi Ngechuchuèxgu nanawẽ́x na nüxü̃ natuxuxü̃cèx. Rü yema togüxü̃ ñanagürügü: —¡Yixrüma! ¡Ngĩxã rü itarüdaunü ngoxita Ería nuã ũ na curuchawa ínaxĩxẽẽãxü̃cèx! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Natürü nüma ga Ngechuchu rü tagaãcü aita naxü, rü ñu̱xũchi nayu. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Rü yexguma ga tupauca ga taxü̃neãrü tüyemachiãxü̃ rü taxregu narügaute. Rü daxũwa inaxügü ga na nagautexü̃ rü ñu̱xmata ñaxtüwa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Rü guma churaragüarü ãẽ̱xgacü ga Dumacü̱̃ã̱x ga Ngechuchupẽ́xewa yexmacü, rü yexguma nüxü̃ nadèu̱xgu ga na nayuxü̃, rü ñanagürü: —Aixcüma nixĩ ya daa yatü i Tupana Nane na yiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Rü iyexmagü ta ga ñuxre ga ngecügü ga yéma yaxü̃wa nüxü̃ rüdaunücü. Rü yematanüwa iyexmagü ga María ga Magadácü̱̃ã̱x, rü Charumé, rü María ga Yúche rü Chaü̃tiágu ga rübumaẽcü naẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Rü yema ngecügü iyixĩ ga Ngechuchuxü̃ íixümücügücü rü nüxü̃ rüngü̃xẽẽgücü ga yexguma Gariréaanewa nayexmagu. Rü yexgumarüü̃ ta yéma iyexmagü ga mucüma ga naĩgü ga ngecügü ga Ngechuchuwe rüxĩcü ga yexguma Yerucharéü̃wa naxũxgu. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Rü yexguma marü nachütachaü̃gu ga yema ngunexü̃ ga Yudíugü nagu nügü imexẽẽgüxü̃ naxcèx ga ngü̃xchigaarü ngunexü̃, rü noxtacüma Piratuxü̃tawa naxũ ga Yúche ga Arimatéacü̱̃ã̱x. Rü nüma ga guma Yúche rü Yudíugüarü ãẽ̱xgacügü ga tacütanüwa naxü, rü wüxi ga ãẽ̱xgacü ga poraãcü nüxü̃ nangechaü̃gücü nixĩ. Rü nüma rü ta ínananguxẽẽ na Tupana norü ãẽ̱xgacü yiĩxü̃cèx. Rü Piratuxü̃tawa naxcèx ínayaca ga Ngechuchuxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Rü naḇaixãchiãẽ ga Piratu ga marü na nayuxü̃. Rü yemacèx norü churaragüarü ãẽ̱xgacücèx nangema na nüxna nac̱axü̃cèx na ñuxgumama yiĩxü̃ ga marü na nayuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Rü yexguma norü churaragüarü ãẽ̱xgacü namaã nüxü̃ ixuxgu ga marü na nayuxü̃, rü nüma ga Piratu rü Yúchena nanaxã ga naxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Rü yexguma ga Yúche rü naxcèx nataxe ga wüxi ga naxchápenüü̃ ga mexẽchixü̃. Rü curuchawa nanayaxu ga Ngechuchuxü̃ne, rü yema naxchápenüü̃maã nananuque. Rü wüxi ga mèxpǘne ga nutanaxcèxgu ü̃paacü yacaxmaü̃güxü̃ ga naxmaxü̃gu nayanaxücuchi. Rü ñu̱xũchi wüxi ga nuta ga tacümaã nanangũxtaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Rü María ga Magadácü̱̃ã̱x rü María ga Yúche naẽ rü nüxü̃ irüdaunü ga ngexta na yanaxücuchigüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Rü sabaduarü ngunexü̃guwena, rü María ga Magadácü̱̃ã̱x, rü Charumé, rü María ga Chaü̃tiágu naẽ naxcèx itaxegü ga pumara na namaã nachaãxü̃cèx ga Ngechuchuxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Rü pèxmamaxü̃chi ga noxri üèxcü iyarügoxgu ga yüxüarü ngunexü̃gu, rü yema ngecügü rü íiyadaugü ga yema naxmaxü̃ ga nagu yanaxücuchigüãxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Rü ngĩgü ngĩgürügügü: —¿Texé tá taxcèx ítanaxügachi ya yima nuta ya namaã nangũxtaü̃cü? —ngĩgürügügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Natürü yexguma meãma nüxü̃ nadaunügu, rü nüxü̃ idaugü ga marü na ínaxügachixü̃ ga guma nuta ga tacü ga namaã nangũxtaü̃cü ga yema naxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Rü yexguma nagu nadaugügu ga yema naxmaxü̃, rü nüxü̃ idaugü ga wüxi ga ngextü̱xücü ga mèxchiruxü̃ ga cómüchiruxü̃ ga yéma naxmaxü̃ãrü tügünecüwawa rütoxü̃. Rü poraãcü iḇaixãchiãẽgü ga yema ngecügü. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Natürü nüma rü ñanagürü ngĩxü̃: —¡Tãxṹ i peḇaixãchiexü̃! Pema rü naxcèx pedaugü ya Ngechuchu ya Nacharétucü̱̃ã̱x ga guma curuchawa yapotagüãcü. Marü wena namaxü̃, rü nataxuma i nuã. ¡Dücèx, meã nüxü̃ pedèu̱x i ñaã nachica ga nagu naxügüãxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","—¡Rü paxa ípixĩ rü Pedrumaã rü ngẽma togü i ngúexü̃gümaã nüxü̃ peyarüxugüe, rü ñapegügü nüxü̃: “Nüma ya Ngechuchu rü marü nüxĩra pexü̃pa Gariréaanewa naxũ. Rü nge̱ma tá nüxü̃ peyadaugü ngẽma pemaã nüxü̃ yaxuxü̃rüü̃”, ñapegügü nüxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Rü yexguma ga yema ngecügü rü nüxna íiyabuxmü ga yema naxmaxü̃, yerü ngĩrü muü̃ẽmaã poraãcü iyadu̱ru̱xe. Rü taxúemaãma nüxü̃ iyaxugügü, yerü poraãcü imuü̃ẽ. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Rü yexguma Ngechuchu yuwa írüdaxguwena ga noxri yangunegu ga yüxüarü ngunexü̃gu, rü ngĩxcèxira nango̱x ga María ga Magadácü̱̃ã̱x ga ngĩwa ínawoxü̃ãcü ga 7 ga ngoxogü. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Rü ngĩma rü íiyaxũ, rü namaã nüxü̃ iyarüxu ga yema Ngechuchumücügü ga íngechaü̃güxü̃ rü íxauxexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Natürü ga nümagü rü tama nayaxõgüchaü̃ ga yexguma nüxü̃ naxĩnüẽgu ga na namaxü̃xü̃ ga Ngechuchu rü na nüxü̃ nadauxü̃ ga ngĩmax. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Rü yemawena ga Ngechuchu rü tõõcü nango̱x naxcèx ga taxre ga norü ngúexü̃gü ga yexguma nama ga naãnewaama nadaxü̃gu naxĩxgu. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Rü nümagü rü nawoegu, rü yema togü ga ngúexü̃gümaã nüxü̃ nayarüxugü. Natürü yemagüaxü̃́ rü ta tama nayaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Rü yemawena ga Ngechuchu rü naxcèx nango̱x ga yema 11 ga norü ngúexü̃gü ga yexguma mechawa ínachibüeyane. Rü nayangagü naxcèx ga tama aixcüma na yaxõgüãxü̃ rü tama na inaxĩnüẽxü̃. Yerü ga nümagü rü tama nüxü̃́ nayaxõgüchaü̃ ga yema nüxü̃ daugüxü̃ ga marü wena na namaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Rü ñanagürü nüxü̃: —¡Guxü̃ i naãnewa pexĩ rü guxü̃ i duü̃xü̃gümaã nüxü̃ peyarüxu i ore i mexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","—Rü yíxema yaxṍxẽ rü íbaiexe rü tá tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. Natürü yíxema tama yaxṍxẽ rü tá tapoxcu. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","—Rü ñaã tá nixĩ i cuèxruü̃gü i nawa nüxü̃ icuáxü̃ i ngẽma yaxõgüxü̃. Rü chauégagu tá ínanawoxü̃ i ngoxogü. Rü ngexwacaxü̃xü̃ i nagagüwa tá nidexagü. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","—Rü naxmẽ́xmaã tá nüxü̃ nayayauxãchi i ãxtapegü. Rü ngẽxguma yaxaxgüãgu i ṯacü i nawa iyuxü̃, rü tãũtáma nanachixexẽẽ. Rü tá tüxü̃ ningõgügü ya iḏaaweexe rü tá tümacèx nitaanegü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Rü nüma ga Cori ga Ngechuchu rü yexguma norü ngúexü̃gümaã yadeaxguwena, rü Tupana rü daxũguxü̃ ga naãnewa nanaga. Rü Tupanaãrü tügünecüwawa nayarüto. ");
INSERT INTO tcaNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Rü nümagü ga norü ngúexü̃gü rü inaxĩãchi na guxü̃wama nüxü̃ yanaxugüexü̃ ga ore i mexü̃. Rü nüma ga Cori rü nüxü̃ narüngü̃xẽẽ, rü nanango̱xẽẽ na aixcüma yiĩxü̃ ga yema ore, yerü wüxigu namaã napuracü na naxügüãxü̃cèx ga mexü̃ ga taxü̃gü ga Tupanaãrü poramaã naxügüxü̃.");
INSERT INTO tcaNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Pa Mecü Pa Teóquirux, nayexma ga ṯacü ga totanüwa ngupetüxü̃. Rü muxü̃ma ga duü̃xü̃gü rü marü nanaxümatügü ga yemachiga, yexgumarüü̃ ga tomaã nüxü̃ na yaxugüexü̃rüü̃ ga yema duü̃xü̃gü ga noxriarü ügügumama Ngechuchuxü̃ daugüxü̃ rü nüxü̃ rüngü̃xẽẽgüxü̃ ga norü orearü uchigawa. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","Rü ngẽmacèx, Pa Teóquirux, rü choma rü ta meãma naxcèx íchaca ga nachiga ga guxü̃ma ga yema Ngechuchu üxü̃. Rü ñu̱xma rü chauxcèx rü name na meãma cuxcèx chanaxümatüxü̃ i ngẽma na meãma nüxü̃ cucuáxü̃cèx na aixcüma yiĩxü̃ ga yema ore ga marüchirẽ́x cuxü̃ nangu̱xẽẽgüxü̃ ga togü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Rü yexguma Erode ãẽ̱xgacü ixĩxgu ga Yudéaanewa, rü yéma nayexma ga wüxi ga Yudíugüarü pai ga Zacaríagu ãe̱gacü. Rü pai ga Arã́ũtaa ga Abíatanüxü̃ nixĩ ga nümax. Rü namèxéga rü Erichabé nixĩ. Rü tüma rü ta pai ga Arã́ũtanüxü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Rü nüma ga Zacaría rü namèx ga Erichabé rü meãma Tupanapẽ́xewa, namaxẽ rü aixcüma naga naxĩnüẽ ga norü mugü. Rü yemaãcü taxucürüwa texé chixri nachiga tidexagü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Natürü nangexacügü yerü namèx rü ingexacü. Rü ñu̱xũchi ga nümagü rü marü yaguã̱xgü nixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Rü wüxi ga ngunexü̃gu rü yema paigütücumü ga Zacaría natanüwa üxü̃gu nangu na tupauca ga taxü̃newa Tupanaãrü puracü naxügüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Rü yema paigü rü nacüma nixĩ ga nüxü̃ na naxunetagüxü̃ ga wüxi ga natanüxü̃ na tupaucaarü aixepegu naxücuxü̃cèx rü yéma Tupanacèx na yaguãxü̃cèx ga pumara ga yixixü̃. Rü yema ngunexü̃gu rü Zacaríagu nangu na tupaucaarü aixepegu naxücuxü̃cèx na yéma yaguãxü̃cèx ga pumara. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Rü yema pumara íyaguyane rü guxü̃ma ga duü̃xü̃gü ga düxétüwa yexmagüxü̃ rü ínayumüxẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Rü ngürüãchi Zacaríacèx nango̱x ga wüxi ga Tupanaãrü orearü ngeruü̃ ga daxũcü̱̃ã̱x. Rü yema nachica ga pumara nawa yagugüü̃xü̃ãrü tügünecüwagu nachi. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Rü yexguma Zacaría nüxü̃ dèu̱xgu ga yema Tupanaãrü orearü ngeruü̃ ga daxũcü̱̃ã̱x, rü poraãcü naḇaixãchiãẽ, rü poraãcü namuü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Natürü yema daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃ rü ñanagürü nüxü̃: —Pa Zacaríax, ¡tãxṹ i cumuü̃xü̃! Erü Tupana rü marü nüxü̃ naxĩnü i curü yumüxẽ. Rü cuxmèx i Erichabé rü cuxü̃́ tá ixãxãcü, rü Cuáü̃gu tá cunaxüéga. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","—Rü cuma rü tá poraãcü cutaãẽxü̃chi i ngẽxguma nabuxgu. Rü muxü̃ma i togü i duü̃xü̃gü rü tá ta nataãẽgüxüchi. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","—Erü yima cune rü Tupanapẽ́xewa rü tá wüxi ya mexẽchicü nixĩ. Rü tãũtáma binu nayaxaxü, rü taxuü̃ma to i ṯacü rü ngúchi̱xáxü̃ tá nixaxü. Rü tauta nabuyane rü Tupanaãẽ i Üünexü̃ rü tá nüxna nangu. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","—Rü nüma tá muxü̃ma i Yudíugüxü̃ narüngü̃xẽẽ na norü Cori ya Tupanacèx nawoeguxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","—Rü nüma ya Cuáü̃ rü tá Cori ya Cristupẽ́xegu nixũ. Rü nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Eríarüü̃ tá nixĩ erü tá nüxü̃́ nangẽxma i Tupanaãẽ i poraxü̃. Rü ngẽmaãcü tá nüxü̃ narüngü̃xẽẽ i papágü na naxãcügüxü̃ nangechaü̃xü̃, rü ngẽma tama Tupanaga ĩnüẽchaü̃xü̃ rü na aixcüma inaxĩnüẽxü̃cèx. Rü ngẽmaãcü tá duü̃xü̃güxü̃ ínamexẽẽ naxcèx ya Cori ya Cristu —ñanagürü ga yema daxũcü̱̃ã̱x. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Rü Zacaría rü yema daxũcü̱̃ã̱xna naca, rü ñanagürü: —¿Ñuxãcü tá nixĩ i ngẽma na naxãxãcüxü̃ i choxmèx? Erü marü chayaxüchi i chomax rü ngĩma rü ta marü iya —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Rü Zacaríaxü̃ nangãxü̃ ga yema daxũcü̱̃ã̱x, rü ñanagürü: —Choma nixĩ i Gabi i Tupanaãrü puracü chaxüxü̃. Rü nüma núma choxü̃ namu na cumaã nüxü̃ na chixuxü̃cèx i ñaã ore i mexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","—Natürü ñu̱xma i cuma rü tama choxü̃́ cuyaxõ i ngẽma ore i cumaã nüxü̃ chixuxü̃. Rü ngẽmacèx i ñu̱xma rü tá cungega ñu̱xmatáta nabu i ngẽma cune. Natürü ngẽma cumaã nüxü̃ chixuxü̃, rü aixcüma tá ningu nagu i ngẽma ngunexü̃ i Tupana ixunetaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Rü yoxni ga duü̃xü̃gü rü tupaucaarü düxétüwa Zacaríaxü̃ nananguxẽẽgü. Rü nügüna nacagüe ga ṯacücèx na tama paxa yéma ínaxũxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Rü yexguma Zacaría tupaucawa íxũũxgu, rü taxucürüwa duü̃xü̃gümaã nidexa, yerü nangega. Rü nümagü ga duü̃xü̃gü rü nüxü̃ nicuèxãchitanü ga ṯacüxü̃ na nadauxü̃ ga Zacaría ga tupaucaarü aixepena. Rü Zacaría rü naxmẽ́xmaã duü̃xü̃güxü̃ nüxü̃ nacuèxẽẽ ga ṯacü nüxü̃ na üpetüxü̃, yerü nangega. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Rü yexguma Zacaría nagu̱xẽẽgu ga na naxüãxü̃ ga Tupanaãrü puracü ga tupauca ga taxü̃newa, rü wenaxãrü napatacèx nataegu. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Rü yemawena rü Zacaría namèx ga Erichabé rü ixãxãcü. Rü ngĩpatagu irüxã́ũẽcha, rü wüximẽ́ẽ̱xpü̱x ga tauemacü taguma düxétüwa ixũ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Rü ngĩxĩcatama ngĩgürügü: —Cori ya Tupana rü poraãcü choxü̃ narüngü̃xẽẽ. Rü ñu̱xma rü marü tãũtáma chixri chauchiga nidexagü i duü̃xü̃gü naxcèx na changexacüxü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Rü 6 ga tauemacü marü ngĩxü̃́ mexgu ga Erichabé ga yema na naxãxãcüxü̃, rü Gariréaanewa yexmane ga ĩãne ga Nacharétuwa Tupana nanamu ga norü orearü ngeruü̃ ga Gabi. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Rü ngĩxü̃tawa naxũ ga wüxi ga pacü ga taguma yatü ngĩmaã maü̃xcü. Rü María nixĩ ga ngĩe̱ga. Rü ngĩma rü ixãtechaü̃ namaã ga wüxi ga yatü ga Yúchegu ãe̱gacü. Rü nüma ga Yúche rü nuxcümaü̃cü ga ãẽ̱xgacü ga Dabítanüxü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Rü yema nachica ga María nawa yexmaxü̃gu naxücu ga Gabi, rü ñanagürü ngĩxü̃: —Nuxmaẽ Pa Maríax. Tupana rü poraãcü cumaã nataãẽ. Rü Cori ya Tupana rü cuxü̃tawa nangẽxma, rü guxü̃ i ngexü̃güarü yexera marü cuxü̃ narüngü̃xẽẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Natürü yexguma María nüxü̃ dèu̱xgu ga yema daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃, rü namaã iḇaixãchiãẽ ga yema norü ore ga ngĩmaã nüxü̃ yaxuxü̃. Rü ngĩgüãẽwa nagu irüxĩnü ga tü̱xcüü̃ yemaãcü ngĩxü̃ na namoxẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Rü yexguma ga Gabi rü ñanagürü ngĩxü̃: —Pa Maríax, tama name na cumuü̃xü̃, erü Tupana rü poraãcü cumaã nataãẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","—Rü ñu̱xma rü tá tauemacü cuxü̃ inayarütaxu, rü tá cuxãxãcü, rü tá nayatü i cuxacü. Rü Ngechuchugu tá cunaxüéga. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","—Rü nüma rü wüxi ya ãẽ̱xgacü ya taxüchicü tá nixĩ. Rü Tupana ya Taxüchicü Nane tá nixĩ i nae̱ga. Rü Cori ya Tupana rü tá nuxcümaü̃cü ga ãẽ̱xgacü ga Dabírüü̃ ãẽ̱xgacüxü̃ nayaxĩxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","—Rü nüma rü guxü̃gutáma Yudíugüarü ãẽ̱xgacü nixĩ. Rü tagutáma ínanguxuchi na ãẽ̱xgacü na yiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Rü yexguma ga María rü Gabina ica, rü ngĩgürügü: —¿Ñuxãcü tá nixĩ i ngẽma na chaxãxãcüxü̃, erü tauta chaxãte? —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Rü nüma ga Gabi rü ngĩxü̃ nangãxü̃, rü ñanagürü: —Tupanaãẽ i Üünexü̃ tá cuxna nangu. Rü Tupana ya Tacüarü pora rü wüxi i caixanexü̃rüü̃ tá cugu nayangaixema. Rü ngẽmacèx ngẽma õxchana i namaã cuxãxãcüxü̃ rü Tupanapẽ́xewa mecüxüchi tá nixĩ, rü Tupana Nanemaã tá nanaxugü i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","—Rü cutanüxü̃ i Erichabé rü marü ixãxãcü woo marü yaguã̱xchirẽ́x na yiĩxü̃. Rü woo ga duü̃xü̃gü rü: “Tagutáma ixãxãcü” ñanagürügü ngĩxü̃, natürü i ñu̱xma rü marü 6 ya tauemacü ngĩxü̃́ name na marü naxãxãcüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","—Erü Tupanaãxü̃́ rü taxuü̃ma naguxcha —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Rü yexguma ga María rü ngĩgürügü: —Chorü Cori ya Tupanaãrü duü̃xü̃ chixĩ i chomax. Rü marü name i chomaã nanaxü i ngẽma chomaã nüxü̃ quixuxü̃ãcüma —ngĩgürügü. Rü yexguma ngĩxna ínixũ ga yema Tupanaãrü orearü ngeruü̃ ga daxũcü̱̃ã̱x ga Gabi. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Rü yexgumaü̃cüü ga María rü paxama nawa ixũ ga guma ĩãne ga Zacaríapata nawa yexmane ga Yudéaaneãrü dauxchitawa. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Rü Zacaríapatawa ingu, rü iyaxücu, rü Erichabéxü̃ irümoxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Rü yexguma Erichabé nüxü̃ ĩnügu ga Maríaarü moxẽ, rü ngĩrü õxchana ga ngĩãnüwa yexmaxü̃ rü nixĩã̱xcüü. Rü Tupanaãẽ ga Üünexü̃ rü Erichabéna nangu. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Rü yexguma ga Erichabé rü tagaãcü Maríaxü̃ ngĩgürügü: —Guxü̃ i ngexü̃güarü yexera Tupana cuxü̃ narüngü̃xẽẽ. Rü ngẽxgumarüü̃ ta cunexü̃ narüngü̃xẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","—¿Ṯacüwa chame na nuã chauxü̃tagu cunaxũãnexü̃? Pa Chorü Cori Naẽx. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","—Erü ngẽxguma nüxü̃ chaxĩnügu i curü moxẽ, rü chauxacü i chauanüwa ngẽxmaxü̃ rü norü taãẽmaã nixĩã̱xcüü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","—Cuma rü cutaãẽ erü nüxü̃́ cuyaxõ i norü ore ya Tupana. Rü ngẽmacèx Tupana tá nayanguxẽẽ i ngẽma ore i cumaã nüxü̃ yaxuxü̃ —ngĩgürügü ga Erichabé. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Rü yexguma ga María rü ngĩgürügü: —Choma rü chauãẽwa poraãcü Tupanaxü̃ chicuèxüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","—Rü chorü Cori ya chorü Maxẽẽruü̃maã chataãẽxü̃chi. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","—Rü woo wüxi i Tupanaãrü duü̃xü̃ i ngearü dĩẽruã́xẽ chixĩ, natürü Tupana chaugu narüxĩnü. Rü ñu̱xmaü̃cüü i duü̃xü̃gü rü taãẽ̱xcümaã guxü̃gutáma choxü̃ naxugüe. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","—Erü Tupana ya Poracü rü taxü̃ i mexü̃ chauxcèx naxü. Rü naxüüne i nae̱ga ya Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","—Rü nüma ya Tupana rü guxü̃gutáma nüxü̃́ tangechaü̃tümüü̃gü ya guxãma ya yíxema aixcüma nüxü̃ muü̃ẽxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","—Rü guxü̃ ga norü poramaã tüxü̃ narüyexera ga guxema tügütama icuèxüü̃güxe. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","—Rü marü ínanawoxü̃ ga yema ãẽ̱xgacügü ga nügü icuèxüü̃güxü̃. Natürü guxema duü̃xẽgü ga tama tügü icuèxüü̃güxe, rü poraãcü tüxü̃ narüngü̃xẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","—Rü guxema tüxü̃́ nataxúxe, rü muxü̃ma tüxna naxã. Natürü guxema muãrü dĩẽruã̱xgüxe rü taxuü̃ma tüxna naxããcüma tüxü̃ ínimugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","—Rü poraãcü nüxü̃ narüngü̃xẽẽ ga norü duü̃xü̃gü ga Yudíugü. Rü tama nüxü̃ inarüngüma na nüxü̃́ ingechaü̃tümüü̃güxü̃, yexgumarüü̃ ga nuxcümaü̃güxü̃ ga tatanüxü̃maã na inaxunetaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","—Yerü yemaãcü inaxuneta namaã ga tórü o̱xi ga Abráü̃ rü namaã ga tatanüxü̃gü na guxü̃gutáma tüxü̃ nangü̃xẽẽxü̃ —ngĩgürügü ga María. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Rü tomaẽ̱xpü̱x ga tauemacü Erichabéxü̃tagu irüxã̱ũ̱x ga María. Rü ñu̱xũchi ngĩpatacèx itaegu. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Rü nawa nangu ga ngunexü̃ ga na naxíraxacüxü̃ ga Erichabé. Rü nayatü ga ngĩxãcü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Rü yexguma nüxü̃ nacuèxgügu na ñuxãcü Tupana ngĩmaã mecümaxü̃, rü ngĩrü ngaicamagu pegüxü̃ ga duü̃xü̃gü rü ngĩtanüxü̃gü rü ngĩxü̃ ínayadaugü, rü ngĩxü̃ narümoxẽgü rü ngĩxü̃ nayataãẽgüxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Rü 8 ga ngunexü̃guwena rü ínayawiechèxmüpẽ́xechiraü̃gü ga guma ngĩne. Rü nanatü ga Zacaríagu nanaxüégagüchaü̃ ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Natürü naẽ ga Erichabé rü tama inaxwèxe. Rü ngĩgürügü: —Narümemaẽ nixĩ i Cuáü̃gu tanaxüéga —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Rü duü̃xü̃gü rü ñanagürügü ngĩxü̃: —¿Tü̱xcüü̃ cunaxwèxe i ngẽma nae̱ga? Erü cutanüxü̃tanüwa rü tataxuma ya texé ya ngẽmagu ãe̱gaxe —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Rü yexguma ga duü̃xü̃gü rü naxmẽ́xwa nanatü ga Zacaríana nacagüe ga ṯacü rü nae̱gagu tá na naxüégaãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Rü yexguma ga Zacaría rü poperaxü̃ naxuneta na yexma na naxümatüãxü̃cèx ga nae̱ga. Rü yexma nanaxümatü, rü ñanagürü: “Cuáü̃ tá nixĩ i nae̱ga”, ñanagürü ga namatü. Rü guxü̃ma ga duü̃xü̃gü rü naḇaixãchiãẽgü ga yexguma yema nae̱gaxü̃ nadaugügu. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Rü yexgumatama wenaxãrü nidexa ga Zacaría. Rü inanaxügü ga Tupanaxü̃ na yacuèxüü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Rü yemacèx guxü̃ma ga yema duü̃xü̃gü ga norü ngaicamagu ãpatagüxü̃ rü poraãcü naḇaixãchiãẽgü. Rü guxü̃wama ga yema naãnewa ga Yudéaanewa rü duü̃xü̃gü nüxü̃ nixuchigagü ga yema ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Rü guxü̃ma ga nüxü̃ cuáchigagüxü̃ ga yema ngupetüxü̃, rü nügüãxẽwa nagu narüxĩnüẽẽcha, rü ñanagürügü: —¿Ṯacü tá nixĩ i ngẽma buxü̃? Erü Tupana rü aixcüma naxü̃tawa nangẽxma —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Rü nanatü ga Zacaríana nangu ga Tupanaãẽ i Üünexü̃. Rü nüxü̃ nixu ga yema ore ga Tupana namaã nüxü̃ ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Rü ñanagürü: —Name nixĩ i nüxü̃ ticuèxüü̃gü ya tórü Cori ga nuxcümaü̃cü ga tórü o̱xi ga Iraéarü Tupana. Erü núma tatanüwa nangu na tüxü̃ yamaxẽxẽẽxü̃cèx i yixema i norü duü̃xü̃gü na ixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","—Rü ngẽmacèx tüxna nanamu ya wüxi ya poracü ya tórü maxẽxẽẽruü̃ ga nuxcümaü̃cü ga norü duü̃xü̃ ga Dabítanüxü̃wa ne ũcü. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","—Rü yemaãcü Tupana tamaã inaxuneta nawa ga yema nuxcümaü̃güxü̃ ga norü orearü uruü̃gü ga üünegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","—Rü yema orearü uruü̃güwa nüxü̃ nixu rü tá tüxü̃ ínanguxü̃xẽẽ naxmẽ́xwa i tórü uwanügü rü guxü̃ma i ngema duü̃xü̃gü i taxchi aiexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","—Rü nuxcümaü̃güxe ga tórü o̱xigümaã nüxü̃ nixu na nüxü̃́ tangechaü̃tümüü̃güxü̃ rü tagutáma nüxü̃ iyanangümaxü̃ ga yema tümamaã inaxunetaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","—Rü yemaãcü ga Tupana rü nuxcümaü̃cü ga tórü o̱xi ga Abráü̃maã inaxuneta. Rü namaã nüxü̃ nixu rü tá tüxü̃ ínanguxü̃xẽẽ nüxna i tórü uwanügü na tama imuü̃ẽãcüma naxüxü̃cèx i Tupanaãrü puracü rü aixcüma mecü na ixĩgüxü̃ napẽ́xewa i guxü̃ i tórü maxü̃wa i wüxichigü i ngunexü̃gu —ñanagürü ga Zacaría. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Rü ñanagürü ta: —Cumax, Pa Chaunex, rü Tupana ya Taxüchicüarü orearü uruü̃maã tá cuxü̃ naxugü. Erü cuma rü tá Corixü̃pa yoxni duü̃xü̃gümaã nüxü̃ quixu i nachiga ya Cori. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","—Cuma rü Coriarü duü̃xü̃güxü̃ tá nüxü̃ cucuèxẽẽ na Tupana tá nüxü̃́ nüxü̃ ngechaü̃xü̃ i norü pecadugü na ngẽmaãcü nayauxgüãxü̃cèx i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","—Erü nüxü̃́ tangechaü̃tümüü̃gü ya Tupana ya poraãcü tüxü̃ ngechaü̃cü. Rü ngẽmacèx daxũguxü̃ i naãnewa taxcèx ne nanamu i ñoma i naãneãrü ngóonexẽẽruü̃ i ngexwacaxü̃xü̃ na nangóonetanüxẽẽãxü̃cèx i ngẽma duü̃xü̃gü ga noxri guxü̃guma norü chixexü̃gagu ãũcümaxü̃wa yexmagüxü̃. Rü nüma tá tüxü̃ narüngü̃xẽẽ na Tupanamaã rüngüxmüẽxü̃cèx —ñanagürü ga Zacaría. ");
INSERT INTO tcaNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Rü yema buxü̃ rü niyachigü rü wüxichigü ga ngunexü̃gu yexeraãcü Tupanaxü̃ nicuáchigü. Rü dauxchita ga ngextá taxúema íxãpataxü̃wa nayexma ñu̱xmata yema ngunexü̃wa nangu ga na Yudíugüxü̃ nügü nacuèxẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Rü yexguma Agutu ãẽ̱xgacü ga tacü ixĩxgu ga Dumawa, rü nanaxunagü ga na yaxugüãxü̃ ga guxü̃ma ga duü̃xü̃gü ga guxü̃ ga naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Rü yema nüxĩraü̃xü̃ ga duü̃xü̃güarü ugüchiga, rü nanaxü ga yexguma Quirinu ãẽ̱xgacü ixĩxgu ga Chíriaarü naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Rü guxü̃ma ga duü̃xü̃gü rü wüxichigü norü ĩãne ga nagu nabuxü̃newa nixũchigü ga yéma na yaxugüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Rü yemacèx ga Yúche rü Gariréaanewa yexmane ga ĩãne ga Nacharétuwa ínaxũxũ, rü Yudéaarü naãnewa yexmane ga ĩãne ga Beréü̃wa naxũ. Rü guma nixĩ ga ĩãne ga nuxcümaü̃cü ga ãẽ̱xgacü ga Dabí nagu buxü̃ne. Rü yemacèx nixĩ ga Yúche ga yéma naxũxü̃, yerü Dabítanüxü̃ nixĩ ga nümax. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Rü Beréü̃wa naxũ ga Yúche na yaxugüxü̃cèx wüxigu ngĩmaã ga María ga ngĩmaã naxãmèxchaü̃cü. Natürü ga María rü itacharaü̃ ga na naxãxãcüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Rü yexguma Beréü̃wa nayexmagüyane, ngĩxna nangu ga ngĩrü ngunexü̃ ga na naxíraxacüxü̃ ga María. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Rü yexma nabu ga nüxĩraü̃cü ga ngĩne. Rü naxchápenüü̃maã inanuque. Rü wüxi ga wocaarü chibüchicagumare inacanagüxẽẽ, yerü marü guxü̃ma nixããcu ga ucapu nawa ga guma pegüpataü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Rü Beréü̃ãrü ngaicamana nayexmagü ga ñuxre ga carnerugüarü dauruü̃gü ga chütacü nachitaü̃wa norü carnerugüna ídaugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Rü ngürüãchi yema carnerugüarü dauruü̃gücèx nango̱x ga wüxi ga orearü ngeruü̃ ga daxũcü̱̃ã̱x. Rü Cori ya Tupanaãrü üüne rü nawa nayexma rü yemacèx poraãcü nangóone. Rü yema carnerugüarü dauruxü̃gü rü poraãcü namuü̃ẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Natürü yema orearü ngeruü̃ ga daxũcü̱̃ã̱x, rü ñanagürü nüxü̃: —¡Tãxṹ i pemuü̃ẽxü̃! erü pexcèx nuã chanange i wüxi i ore i mexẽchixü̃ i guxü̃ i duü̃xü̃güarü taãẽxẽẽruü̃ tá ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","—Erü ñu̱xma rü Beréü̃gu nabu ya perü maxẽxẽẽruü̃. Rü nüma rü Cori ya Cristu nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","—Rü ñaã tá nixĩ i perü cuèxruü̃. Rü tá nüxü̃ ipeyangau i wüxi i õxchana i naxchápenüü̃maã nuquexü̃ rü wocaarü chibüchicagu caxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Rü yexgumatama ngürüãchi yema daxũcü̱̃ã̱x ga orearü ngeruü̃xü̃tawa nango̱x ga muxü̃ma ga togü ga daxũcü̱̃ã̱x ga orearü ngeruü̃gü. Rü Tupanaxü̃ nicuèxüü̃gü, rü ñanagürügü: ");
INSERT INTO tcaNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Rü ñu̱xma rü Tupanaxü̃ ínicuèxüü̃gü rü ínataãẽgü i daxũguxü̃ i naãnewa. Rü pema i ñoma i naãnecü̱̃ã̱x i Tupana pemaã taãẽgüe, rü name nixĩ i pegümaã perüngüxmüẽ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Rü yexguma daxũwa naxĩxguwena ga yema orearü ngeruü̃gü rü yema carnerugüarü dauruü̃gü rü nügümaã ñanagürügü: —¡Ngĩxã ítayadau i Beréü̃wa i ngẽma ngupetüxü̃ i Cori ya Tupana tamaã nüxü̃ ixuxü̃ nawa i norü orearü ngeruü̃gü! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Rü paxa inaxĩãchi, rü yéma naxĩ. Rü yexma inayangaugü ga Yúche rü María rü guma bucü ga wocaarü chibüchicagu cacü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Rü yexguma yema bucüxü̃ nadaugügu ga yema carnerugüarü dauruü̃gü, rü duü̃xü̃gümaã nüxü̃ nixugüe ga yema ore ga Tupanaãrü orearü ngeruü̃ ga daxũcü̱̃ã̱x namaã nüxü̃ ixuxü̃ ga guma bucüchiga. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Rü guxü̃ma ga duü̃xü̃gü ga nüxü̃ ĩnüẽxü̃ ga yema carnerugüarü dauruü̃güarü ore rü namaã naḇaixãchiãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Natürü ga María rü inayaxu ga guxü̃ma ga yema ngupetüxü̃ rü ngĩãẽgu namaã inguxü̃ rü nagu irüxĩnüẽcha. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Rü nawoegu ga yema carnerugüarü dauruü̃gü. Rü taãẽãcüma Tupanaxü̃ nicuèxüü̃gü naxcèx ga guxü̃ma ga yema nüxü̃ naxĩnüẽxü̃ rü nüxü̃ nadaugüxü̃ yerü aixcüma yema orearü ngeruü̃ ga daxũcü̱̃ã̱x namaã nüxü̃ ixuxü̃ãcüma nangupetü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Rü yexguma 8 ga ngunexü̃ nüxü̃́ yexmagu ga na nabuxü̃ ga õxchana, rü ínanawiechèxmüpẽ́xechiraü̃gü. Rü Ngechuchugu nanaxüégagü. Rü yematama nixĩ ga nae̱ga ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃ Maríamaã nüxü̃ ixuxü̃ ga tauta namaã naxãxãcügu. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Rü yexguma marü yanguxgu ga yema ngunexü̃ na tupauca ga taxü̃newa Tupanapẽ́xewa na nügü yamexẽẽgüxü̃ rü yéma naxĩ na yemaãcü Tupanapẽ́xewa yanguxẽẽgüãxü̃cèx ga yema Moĩchéarü mugü nüxü̃ ixuxü̃rüü̃. Rü Yerucharéü̃wa ga tupauca ga taxü̃newa nanagagü ga guma bucü na Tupanana namugüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Rü yemaãcü nanaxügü yerü Tupanaãrü mugüwa naxümatü, rü ñanagürü: “Ngẽxguma wüxi i nge rü nayatügu i nüxĩraü̃xü̃ i ngĩxãcü, rü name i Cori ya Tupanana inamu”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Rü yéma naxĩ rü yéma nanagagü ga taxre ga muxtucugü ga yexwacèx yaexü̃, na Tupanacèx nadaiãxü̃cèx ga paigü ga tupaucawa, yerü yema ñanagürü ga Tupanaãrü mugüwa. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","26","Rü yexgumaü̃cüü Yerucharéü̃gu naxãchiü̃ ga wüxi ga yatü ga Chimeṹgu ãe̱gacü. Rü wüxi ga yatü ga mecümacü nixĩ ga nümax, rü aixcüma Tupanaxü̃ ngechaü̃cü nixĩ. Rü nüma rü guxü̃guma ínananguxẽẽ na ñuxguacü tá ínanguxü̃ ya Yudíugüarü nguxü̃xẽẽruü̃ ya Cristu. Rü Tupanaãẽ i Üünexü̃ rü Chimeṹxü̃tawa nayexma, rü nüxü̃ nüxü̃ nacuèxẽẽ na tãũtáma nayuxü̃ ega tama nüxü̃ nadauxiragu ya Cristu ya Cori ya Tupana núma namucü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Rü yema ngunexü̃gu rü tupauca ga taxü̃newa Chimeṹxü̃ naxũxẽẽ ga Tupanaãẽ i Üünexü̃. Rü yéma nayexma ga Chimeṹ ga yexguma Yúche rü María tupaucawa nagagügu ga guma bucü ga Ngechuchu na Tupanana namugüãxü̃cèx na yemaãcü yanguxẽẽgüãxü̃cèx ga Moĩchéarü mu. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Rü Ngechuchuxü̃ naganagü ga Chimeṹ. Rü Tupanaxü̃ nicuèxüü̃, rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Pa Corix, ñu̱xma rü marü name na chayuxü̃, erü marü cuyanguxẽẽ ga yema chomaã icuxunetaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","—Rü chauxetümaãxü̃chi nüxü̃ chadau ya daa Maxẽxẽẽruü̃ ya guxü̃ i duü̃xü̃gücèx núma cunamucü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","—Rü nüma nixĩ i ngóonexẽẽruü̃ naxcèx i guxü̃ma i duü̃xü̃gü i tama Yudíugü ixĩgüxü̃. Rü ñaã õxchanagagu rü togü i duü̃xü̃gü tá nüxü̃ nicuèxüü̃gü i curü duü̃xü̃gü i Yudíugü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Rü Yúche rü María rü naḇaixãchiãẽgü namaã ga Chimeṹãrü ore ga ñuxãcü guma õxchanachigamaã na yadexaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Rü yexguma ga Chimeṹ rü Tupanana naca na meã nüxü̃ nangupetügüxü̃cèx ga Yúche rü María rü guma õxchana. Rü ñanagürü ngĩxü̃ ga María ga Ngechuchu naẽ: —Dücèx, daa õxchana rü tá nanamaxẽxẽẽ i muxü̃ma i Yudíugü, natürü ngẽma tama nüxü̃́ yaxõgüchaü̃xü̃ rü tá inayarütauxe. Rü nüma rü wüxi i cuèxruü̃ tá nixĩ i duü̃xü̃gücèx, rü muxü̃ma tá nüxü̃ naxoe. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","—Rü ngẽmaãcü tá nanango̱xẽẽãma i guxü̃ma i naãẽwa nagu naxĩnüẽxü̃ i muxü̃ma i duü̃xü̃gü. Rü guxü̃ma i ngẽma tá ñaã õxchanaxü̃ ngupetüxü̃ rü ñoma wüxi i cüxchi i curü maxü̃newa yarüwáxü̃rüü̃ tá cuxü̃́ nangu̱x, Pa Maríax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Rü yéma ta iyexma ga wüxi ga ngecü ga Tupanaãrü orexü̃ ixucü. Rü Ana nixĩ ga ngĩe̱ga. Rü Panue̱xãcü iyixĩ, rü Ácherutanüxü̃ iyixĩ. Rü marü yaguã̱xü̃chi iyixĩ. Rü yexguma napaxüchigutama ixãte. Natürü 7 ga taunecü- guxicatama ngĩtemaã iyarüxũũxü̃, yerü nayu ga ngĩte. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Rü yemaãcü wüxi ga yutecü ga yaguã̱xü̃chi iyixĩ, yerü 84 nixĩ ga ngĩrü taunecü. Rü taguma tupauca ga taxü̃newa íixũxũ. Rü guxü̃guma ngunecü rü chütacü rü naxaureãcüma iyumüxẽẽcha. Rü yemaãcü Tupanaxü̃ iyacuèxüü̃ rü inataxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Rü yexgumatama Chimeṹ íidexayane, rü yéma ingu ga Ana. Rü Tupanana moxẽ ixã. Rü iinaxügü ga õxchana ga Ngechuchuchiga na yadexaxü̃ napẽ́xewa ga guxü̃ma ga yema Yudíugü ga Yerucharéü̃cü̱̃ã̱x ga Cristuxü̃ ínanguxẽẽgüxü̃ na norü nguxuchixẽẽruü̃ yiĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Rü yexguma marü yanguxẽẽgüãguwena ga guxü̃ma ga yema Tupanaãrü mugü nüxü̃ ixuxü̃, rü Yúche rü María rü naxcèx nawoegu ga norü ĩãne ga Nacharétu ga Gariréaanewa yexmane. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Rü guma bucü rü niyachigü, rü yexeraãcü niporachigü, rü yexeraãcü nüxü̃ nicuáchigü. Rü Tupana rü poraãcü nüxü̃ narüngü̃xẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nanatü rü naẽ rü gucü ga taunecügu Yerucharéü̃wa taxĩĩxü̃ naxcèx ga Üpetüchigaarü peta. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Rü yexguma Ngechuchu 12 ga taunecü nüxü̃́ yexmagu, rü Yerucharéü̃wa taxĩ namaã ga nanatü rü naẽ, yerü yema nixĩ ga Yudíugücüma naxcèx ga Üpetüchigaarü peta. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Rü yexguma yagúechigagu ga Üpetüchigaarü peta, rü tümachiü̃cèx tawoegu ga nanatü rü naẽ. Natürü ga Ngechuchu rü tümaẽchita tüxna Yerucharéü̃gu narüxã̱ũ̱x. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Rü tüma nüxü̃ tacuèxgügu rü yema muxü̃ ga duü̃xü̃gü ga tümaweama ixĩxü̃tanüxü̃tanügu naxã ga Ngechuchu. Rü yemaãcü marü itaxĩ ga wüxi ga ngunexü̃. Natürü yexguma naxcèx tadaugügu tümatanüxü̃tanügu rü yema tüxü̃ cuèxgüxü̃tanügu rü tama nüxü̃ itayangaugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Rü yemacèx wenaxãrü Yerucharéü̃cèx tawoegu na yexma naxcèx tayadaugüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Rü tomaẽ̱xpü̱x ga ngunexü̃guwena Ngechuchuxü̃ itayangaugü ga tupauca ga taxü̃negu. Rü yéma narüto natanüwa ga yema ngúexẽẽruü̃gü ga Tupanaãrü mugüwa ngu̱xẽẽtaegüxü̃, rü inarüxĩnü ga norü ngu̱xẽẽtae, rü nüxna nicachigü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Rü guxü̃ma ga yema duü̃xü̃gü ga Ngechuchuxü̃ ĩnüẽxü̃, rü naḇaixãchiãẽgü na ñuxãcü nüxü̃ nacuèxüchixü̃ rü meãma nangãxü̃ãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Rü yexguma nanatü rü naẽ nüxü̃ daugügu rü taḇaixãchiãẽgü. Rü naẽ rü ñatarügü nüxü̃: —Pa Chaunex, ¿tü̱xcüü̃ tomaã ngexü̃ cuwagü? Cunatü rü choma rü poraãcü cuxcèx taxoegaãẽãcüma cuxcèx tadaugüecha —ñatarügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Rü yexguma ga Ngechuchu rü ñanagürü: —¿Tü̱xcüü̃ chauxcèx pedaugü? ¿Tama ẽ́xna nüxü̃ pecuèx na woetama Chaunatüchiü̃wa tá changẽxmaxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Natürü ga tümagü rü tama nüxü̃ tacuèxgüéga ga yema tümamaã nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Rü yexguma ga Ngechuchu rü tümawe nataegu ga Nacharétuwa. Rü guxü̃guma meã tümaga naxĩnüẽcha. Rü naẽ ga María rü ngĩãẽwa nagu irüxĩnüẽcha ga guxü̃ma ga yema ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Rü niyachigü ga Ngechuchu, rü yexeraãcü nüxü̃ nicuáchigü. Rü Tupana rü namaã nataãẽ, rü guxü̃ma ga duü̃xü̃gü rü ta namaã nataãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rü yexguma Tibériu 15 ga taunecü Dumaarü ãẽ̱xgacü yixĩxgu, rü yexguma nixĩ ga Pṍũchiu Piratu rü Yudéaaneãrü ãẽ̱xgacü yiĩxü̃, rü Erode rü Gariréaaneãrü ãẽ̱xgacü yiĩxü̃, rü naẽneẽ ga Piripi rü Itúreaane rü Traconíteaneãrü ãẽ̱xgacü yiĩxü̃, rü Lichániã rü Abiríniããneãrü ãẽ̱xgacü yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Rü yexguma ga Aná rü Caipá rü paigüeru nixĩgü. Rü yexguma nixĩ ga Zacaría nane ga Cuáü̃maã yadexaxü̃ ga Tupana ga dauxchitawa ga ngextá taxúema íxãpataxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Rü guxü̃ma ga yema nachicagü ga Yudáü̃cutüarü ngaicamana yexmagüxü̃gu nixũgüchigü ga Cuáü̃. Rü duü̃xü̃gümaã nüxü̃ nixuchigü na nüxü̃ naxoexü̃cèx ga nacümagü ga chixexü̃ rü ínabaiü̃xü̃cèx na yemaãcü Tupana nüxü̃́ nüxü̃ rüngümaxü̃cèx ga norü pecadugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Rü guma nuxcümaü̃cü ga Ichaxía ga Tupanaãrü orearü uruü̃ naxümatüxü̃rüü̃ nixĩ ga nangupetüxü̃. Yerü duü̃xü̃güarü maxü̃ãrü mexẽẽchigaxü̃ nixu ga yexguma ñaxgu: “Ngẽma nachica i ngextá taxúema íxãpataxü̃wa rü tá nangẽxma i wüxi i duü̃xü̃ i nge̱ma tagaãcüma ñaxü̃: ‘¡Pegü pemexẽẽ naxcèx ya Cori! ¡Rü naxcèx ipeyanawẽ́xãchixẽẽ i perü maxü̃!’ ");
INSERT INTO tcaNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Rü guxããrü maxü̃ rü tá inayarüwẽ́xãchi ñoma wüxi i ngatexü̃ rügütaxü̃rüü̃ na iyawéxü̃cèx i nama. Rü guxãma ya yíxema togüétüwa tügü ngẽxmaxẽẽgüxe rü tá ítarüxĩ ñoma wüxi ya mèxpǘne rü wüxi i ngüchitaeru idoxochixẽẽxü̃rüü̃. Rü guxü̃ma i nacüma i wü̃xü̃ rü tá inayarüwẽ́xãchigü. Rü ngẽma duü̃xü̃güarü maxü̃wa tama mexü̃ rü tá nayamexẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Rü guxü̃ma i duü̃xü̃gü rü tá nüxü̃ nadaugü ya yima Maxẽxẽẽruü̃ ya Tupana núma namucü”, ñanagürü ga Ichaxía ümatüxü̃ ga ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Rü yexguma Cuáü̃xü̃tawa naxĩxgu ga duü̃xü̃gü na ínabaiü̃xẽẽãxü̃cèx, rü nüma ga Cuáü̃ rü ñanagürüama nüxü̃: —Pa Ãxtapearü Duü̃xü̃güx ¿Rü ñuxãcü nagu perüxĩnüe na naxchaxwa pibuxmüxü̃ i ngema poxcu i marü ingaicamaxü̃ ega tama nüxü̃ perüxoegu i pecüma i chixexü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","—¡Rü meã pemaxẽ na ngẽmaãcü guxü̃ma i duü̃xü̃gü nüxü̃ daugüxü̃cèx na aixcüma marü nüxü̃ perüxoexü̃ i pecüma i chixexü̃! Rü tama name i ñaperügügü: “Tãũtáma Tupana toxü̃ napoxcue, erü Abráü̃tanüxü̃ tixĩgü” ñaperügügü. Erü tama ngẽmacèx nixĩ ya Tupana i duü̃xü̃güxü̃ nayaxuxü̃. Rü pemaã nüxü̃ chixu rü ngẽxguma Tupana naxwèxegu rü tama nüxü̃́ naguxcha na daa nutawa Abráü̃tanüxü̃ nanguxü̃xẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","—Tupanaãrü yuema rü marü íimemare na yadaxü̃ãxü̃cèx i ngẽma nanetügü i tama mexü̃. Rü guxü̃ma i nanetügü i chixearü õṍxü̃ rü tá nadaxü̃, rü ñu̱xũchi üxüwa tá ínagu —ñanagürü ga Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Rü yexguma ga duü̃xü̃gü rü Cuáü̃na nacagü, rü ñanagürügü: —¿Ṯacü ẽ́xna nixĩ i mexü̃ na tanaxüxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Rü Cuáü̃ rü nanangãxü̃ rü ñanagürü: —Texé ya taxrearü gáuxü̃chiruã́xẽ rü name nixĩ i texé ya tüxü̃́ nataxúxena tanaxã. Rü texé ya õnaã́xẽ rü name nixĩ i texé ya ngearü õnaã́xẽmaã tangau i tümaãrü õna —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Rü Cuáü̃xü̃tawa naxĩ ta ga ñuxre ga yatügü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ideetanüxü̃. Rü nanaxwèxegü ga Cuáü̃ na ínabaiü̃xẽẽxü̃. Rü Cuáü̃na nacagü, rü ñanagürügü: —Pa Ngúexẽẽruü̃x, ¿Ṯacü nixĩ i mexü̃ na tanaxüxü̃ i tomax? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Rü Cuáü̃ rü ñanagürü nüxü̃: —Tama name i ãẽ̱xgacü pemaã nüxü̃ ixuxü̃ãrü yexera penayauxgü i dĩẽru i duü̃xü̃güxü̃tawa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Rü ñuxre ga churaragü rü ta Cuáü̃na nacagüe, rü ñanagürügü: —¿Toma rü ṯacü nixĩ i mexü̃ na tanaxüxü̃? —ñanagürügü. Rü nanangãxü̃ ga Cuáü̃ rü ñanagürü: —Tama name i texéxü̃ pexãxũneãcüma tümaãrü ngẽmaxü̃gü pepuxü̃. Rü tama name i ṯacü rü doraxü̃ tümachigaxü̃ pixu na ngẽmaãcü tümaãrü ngẽmaxü̃gü pepuxü̃xü̃cèx. Rü name nixĩ i ngẽma dĩẽru i ãẽ̱xgacü pexü̃́ ngĩmaã naxütanücümaãtama petaãẽgü rü tama yexeracücèx ípeca —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Rü yexguma ga duü̃xü̃gü rü poraãcü ínananguxẽẽgü na paxa ínanguxü̃ ga Tupana Nane ga Cristu. Rü nagu narüxĩnüẽ ga na bexmana Cuáü̃ rü Cristu yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Natürü ga Cuáü̃ rü guxãxü̃ ñanagürü: —Aixcüma i choma rü dexáwamare pexü̃ íchabaiü̃xẽẽ, natürü tá ínangu i to i Tupanaãrü orearü uruü̃, rü nüma tá pexna nananguxẽẽ i Tupanaãẽ i Üünexü̃ wüxi i üxüemarüü̃. Erü nüma rü poraãcü choxü̃ narüyexera na ãẽ̱xgacü yiĩxü̃. Rü choma rü napẽ́xewa rü taxuwama chame rü bai i norü chapatucunüãrü wẽgüwa chame. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","—Rü nüma rü marü ínamemare na ñoma i naãnewa yadexechiãxü̃cèx i norü duü̃xü̃gü ñoma wüxi ya yatü trigu naã́tüna idexechixü̃rüü̃. Rü ngẽmaãcü tá nayadexechi i ngẽma noxrü ixĩgüxü̃ na naxü̃- tawa nangẽxmagüxü̃cèx, natürü ngẽma tama noxrü ixĩgüxü̃, rü tá ínanagu nawa ya yima üxü ya taguma ixoxü̃ne —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Rü yema oremaã rü muxü̃ma ga to ga ucu̱xẽgümaã, rü Cuáü̃ duü̃xü̃gümaã nüxü̃ nixu ga ore ga mexü̃ ga Ngechuchuchiga. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Rü Cuáü̃ rü ãẽ̱xgacü ga Erodexü̃ nanga, yerü ngĩmaã naxãmèx ga Erodía ga naẽneẽ ga Piripi namèx. Rü nananga ta naxcèx ga yema togü ga chixexü̃ ga naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Natürü ga Erode rü tama Cuáü̃ga naxĩnü. Rü yexeraxü̃ ga chixexü̃ naxü, yerü poxcupataü̃wa Cuáü̃xü̃ namu. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Rü yexguma taxũta napoxcugu ga Cuáü̃, rü guxü̃ ga duü̃xü̃güxü̃ ínabaiü̃xẽẽxyane, rü yexguma ta nixĩ ga Ngechuchuxü̃ ínabaiexẽẽxü̃. Rü yexguma Ngechuchu íyumüxẽyane rü ningena ga daxũguxü̃ ga naãne. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Rü Tupanaãẽ i Üünexü̃ rü wüxi ga muxtucurüü̃ inanago rü Ngechuchuna nangu. Rü daxũwa inanaxũ ga wüxi ga naga ga ñaxü̃: —Cuma nixĩ, Pa Chaunex, i cuxü̃ changechaü̃xü̃chixü̃ rü cumaã chataãẽxü̃ —ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ngechuchu rü 30 ga taunecü nüxü̃́ nayexma ga yexguma ínaxügüãgu na guxü̃wama duü̃xü̃gümaã nüxü̃ yaxuxü̃ ga Tupanaarü Ore. Rü duü̃xü̃gü nagu narüxĩnüẽ rü Yúche nane nixĩ ga nümax. Rü Yúche rü Erí nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Rü Erí rü Matáx nane nixĩ. Rü Matáx rü Lebí nane nixĩ. Rü Lebí rü Merequí nane nixĩ. Rü Merequí rü Yana nane nixĩ. Rü Yana rü Yúche nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Rü Yúche rü Matatía nane nixĩ. Rü Matatía rü Amó nane nixĩ. Rü Amó rü Naṹü̃ nane nixĩ. Rü Naṹü̃ rü Echi nane nixĩ. Rü Echi rü Nagaí nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Rü Nagaí rü Maã́x nane nixĩ. Rü Maã́x rü Matatía nane nixĩ. Rü Matatía rü Chemeĩ́ nane nixĩ. Rü Chemeĩ́ rü Yuchéx nane nixĩ. Rü Yuchéx rü Yudá nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Rü Yudá rü Yuanáü̃ nane nixĩ. Rü Yuanáü̃ rü Récha nane nixĩ. Rü Récha rü Chorobabé nane nixĩ. Rü Chorobabé rü Charatía nane nixĩ. Rü Charatía rü Nerí nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Rü Nerí rü Merequí nane nixĩ. Rü Merequí rü Adí nane nixĩ. Rü Adí rü Cocháü̃ nane nixĩ. Rü Cocháü̃ rü Elmadáü̃ nane nixĩ. Rü Elmadáü̃ rü Erú nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Rü Erú rü Yochué nane nixĩ. Rü Yochué rü Erieché nane nixĩ. Rü Erieché rü Yoríü̃ nane nixĩ. Rü Yoríü̃ rü Matáx nane nixĩ. Rü Matáx rü Lebí nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Rü Lebí rü Chimeṹü̃ nane nixĩ. Rü Chimeṹü̃ rü Yudá nane nixĩ. Rü Yudá rü Yúche nane nixĩ. Rü Yúche rü Yonáü̃ nane nixĩ. Rü Yonáü̃ rü Eriaquíü̃ nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Rü Eriaquíü̃ rü Meréa nane nixĩ. Rü Meréa rü Ména nane nixĩ. Rü Ména rü Matáta nane nixĩ. Rü Matáta rü Natáü̃ nane nixĩ. Rü Natáü̃ rü Dabí nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Rü Dabí rü Ichaxí nane nixĩ. Rü Ichaxí rü Obé nane nixĩ. Rü Obé rü Boó nane nixĩ. Rü Boó rü Cháru nane nixĩ. Rü Cháru rü Nachóü̃ nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Rü Nachóü̃ rü Aminadá nane nixĩ. Rü Aminadá rü Admíü̃ nane nixĩ. Rü Admíü̃ rü Arni nane nixĩ. Rü Arni rü Esróü̃ nane nixĩ. Rü Esróü̃ rü Fare nane nixĩ. Rü Fare rü Yudá nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Rü Yudá rü Acóbu nane nixĩ. Rü Acóbu rü Ichaá nane nixĩ. Rü Ichaá rü Abráü̃ nane nixĩ. Rü Abráü̃ rü Taré nane nixĩ. Rü Taré rü Nacúx nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Rü Nacúx rü Cherúx nane nixĩ. Rü Cherúx rü Ragáu nane nixĩ. Rü Ragáu rü Peréx nane nixĩ. Rü Peréx rü Ebéx nane nixĩ. Rü Ebéx rü Cháru nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Rü Cháru rü Caináü̃ nane nixĩ. Rü Caináü̃ rü Arpacháx nane nixĩ. Rü Arpachá rü Chéü̃ nane nixĩ. Rü Chéü̃ rü Noe̱ nane nixĩ. Noe̱ rü Laméx nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Rü Laméx rü Matucharéü̃ nane nixĩ. Rü Matucharéü̃ rü Enóx nane nixĩ. Rü Enóx rü Yaréx nane nixĩ. Rü Yaréx rü Maararéx nane nixĩ. Rü Maararéx rü Caináü̃ nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Rü Caináü̃ rü Enóx nane nixĩ. Rü Enóx rü Chex nane nixĩ. Rü Chex rü Adáü̃ nane nixĩ. Rü Adáü̃ rü Tupana nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ngechuchuxü̃tawa nayexma ga Tupanaãẽ i Üünexü̃. Rü yexguma Yudáü̃chiüwa ínaxü̃ãchigu ga Ngechuchu, rü Tupanaãẽ i Üünexü̃ rü dauxchitawa ga ngextá taxúema íxãpataxü̃wa nanaga. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Rü yéma nayexma ga 40 ga ngunexü̃. Rü ngoxo ga Chataná rü nüxü̃ naxü. Rü yexguma yéma nayexmagu rü taguma nachibü. Natürü ga yixcama rü nataiya. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Rü yexguma ga ngoxo ga Chataná rü ñanagürü nüxü̃: —Ega aixcüma Tupana Nane quixĩgu, rü ¡daa nutamaã nüxü̃ ixu na pãũxü̃ nanguxuchixü̃cèx! —ñanagürü ga Chataná. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Tãũtáma õnamaãxĩca namaxẽ i duü̃xü̃gü, natürü guxü̃ma i ore i Tupana nüxü̃ ixuxü̃ tá nixĩ i duü̃xü̃güxü̃ maxẽxẽẽxü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Rü yexguma ga ngoxo ga Chataná rü wüxi ga mèxpǘnechitaeruwa nanaga. Rü yéma paxaãchi nüxü̃ nüxü̃ nadauxẽẽ ga guxü̃ma ga nachiü̃ãnegü ga ñoma ga naãnecü̱̃ã̱x. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Rü Chataná rü ñanagürü nüxü̃: —Guxü̃ i ñaã nachiü̃ãnegü i mexü̃ rü norü ngẽmaxü̃gü rü chi cuxna chanaxã. Erü choxrü nixĩ i guxü̃ma i ñaãgü, rü tüxna chanaxã ya texé ya choma chorü me ixĩxẽ na tüxna na chanaxãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","—Rü ngẽxguma chi chopẽ́xegu cucaxã́pü̱xügu rü choxü̃ quicuèxüü̃gu rü cuxrü chi nixĩ i guxü̃ma i ñaã cuxü̃ chawéxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Natürü ga Ngechuchu rü nanangãxü̃, rü ñanagürü: —¡Choxna ixũgachi! Pa Chata- náx. Erü Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “¡Nüxü̃ icuèxüü̃ ya Cori ya curü Tupana, rü yimaãxü̃́xĩcatama napuracü!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Rü yexguma ga ngoxo ga Chataná rü Yerucharéü̃ ga ĩãnewa nanaga. Rü tupauca ga taxü̃netapẽ́xegu nanamunagü. Rü ñanagürü nüxü̃: —Ega aixcüma Tupana Nane quixĩgu, rü ¡nuã cugü rütae! ");
INSERT INTO tcaNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","—Erü Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Tupana tá nanamu i norü orearü ngeruü̃gü i daxũcü̱̃ã̱x na cuxna nadaugüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Rü naxmẽ́xmaã tá cuxü̃ niyauxgü na tama ṯacü rü nutagu cunguxü̃cèx”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Tupanaãrü ore i ümatüxü̃wa rü ñanagürü ta: “¡Tama name i nüxü̃ na cuxüxü̃ ya Cori ya curü Tupana!”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Rü yexguma marü taxucürüwama Ngechuchuxü̃ naxü̱xgu, rü nüma ga Chataná rü nüxna niña ñu̱xmata nüxü̃ iyangau na ñuxãcü wena nüxü̃ na naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Rü Ngechuchu rü Gariréaanecèx nataegu. Rü Tupanaãẽ i Üünexü̃ rü naxü̃tawa nayexma rü poraãcü nanaporaxẽẽ. Rü ga duü̃xü̃gü rü nachiga nidexagü ga guxü̃ ga yema naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Rü wüxichigü ga ĩãneãrü ngutaquẽ́xepataü̃güwa rü nangu̱xẽẽtae. Rü guxü̃ma ga duü̃xü̃gü rü nüxü̃ nicuèxüü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Rü Nacharétuwa naxũ ga Ngechuchu. Rü guma nixĩ ga ĩãne ga nanatügü nawa nayaxẽẽgüne. Rü ngü̃xchigaarü ngunexü̃gu rü ngutaquẽ́xepataü̃gu naxücu, yerü yema nixĩ ga nacüma ga guxü̃ ga ngü̃xchigaarü ngunexü̃gu. Rü yéma inachi rü duü̃xü̃gücèx nüxü̃ nadaumatü ga Tupanaãrü ore ga ümatüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Rü nüxna nanaxãgü ga popera ga Tupanaãrü orearü uruü̃ ga Ichaxía ümatüxü̃. Rü yexguma yangenaã́tüãgu, rü nüxü̃ inayangau ga ngextá ínaxümatüxü̃wa ga ore ga ñaxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Cori ya Tupanaãẽ rü chauxü̃tawa nangẽxma. Rü nüma rü choxü̃ naxuneta na nüxü̃ chixuxü̃cèx i ore i mexü̃ namaã i ngẽma duü̃xü̃gü i ngearü ngẽmaxü̃ã̱xgüxü̃. Rü choxü̃ namu na ngẽma duü̃xü̃gü i pecadutüü̃wa ngẽxmagüxü̃maã nüxü̃ na chixuxü̃cèx rü tá na ínanguxü̃xü̃. Rü choxü̃ namu na chayadauchixetüxẽẽgüxü̃cèx i ngẽma ingexetügüxü̃ rü na íchananguxü̃xẽẽxü̃cèx i ngẽma duü̃xü̃gü i togümẽ́xẽwa ngẽxmagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Rü núma choxü̃ namu na duü̃xü̃gümaã nüxü̃ chixuxü̃cèx na Tupana nüxü̃ rüngü̃xẽẽchaü̃xü̃ i ngẽma nüxü̃́ yaxõgüxü̃”, ñanagürü ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Rü yexguma ga Ngechuchu rü nügüna nananu̱xãchiátü ga popera. Rü ngutaquẽ́xepataü̃ãrü dauruü̃na nanaxã rü ñu̱xũchi ínarüto. Natürü guxü̃ma ga yema ngutaquẽ́xepataü̃wa yexmagüxü̃ ga duü̃xü̃gü rü nüxü̃ narüdaunüẽcha. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Rü yexguma ga Ngechuchu rü inanaxügü ga na yadexaxü̃, rü ñanagürü: —Ñu̱xmatama nixĩ i pepẽ́xewa Tupana yanguxẽẽxü̃ i ñaã ore ga Ichaxía ümatüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Rü guxü̃ma ga duü̃xü̃gü rü meã Ngechuchuchiga nidexagü. Rü naḇaixãchiãẽgü namaã ga yema ore ga mexü̃ ga namaã nüxü̃ yaxuxü̃. Natürü tama aixcüma nayaxõgüchaü̃. Rü yemacèx nügüna nacagü rü ñanagürügü: —¿Taux ẽ́xna daa yiĩxü̃ ya Yúche nane? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Rü Ngechuchu rü ñanagürü nüxü̃: —Choma nüxü̃ chacuèx rü tá chomaã penaxuxuchi i ngẽma ore i ñaxü̃: “Pa Duturux ¡Cugütama rümexẽẽ!” ñaxü̃. Rü ẽ́xna tá choxü̃ ñaperügügü: “Yema mexü̃ ga taxü̃ ga nüxü̃ taxĩnüẽxü̃ ga Tupanaãrü poramaã cuxüxü̃ ga Capernáũwa, rü tanaxwèxe i nuã curü ĩãnewa rü ta na cunaxüxü̃”, ñaperügügü tá. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Rü nayadaxẽẽ ga Ngechuchu na yadexaü̃ rü ñanagürü: —Aixcüma pemaã nüxü̃ chixu rü guxü̃ma i Tupanaãrü orearü uruü̃, rü norü ĩãnewatama i duü̃xü̃gü rü tama meã nanayauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","—Rü aixcüma pemaã nüxü̃ chixu rü Iraéanewa rü nayexma ga muxũchixü̃ma ga ngexü̃gü ga iyutegüxü̃ ga yexguma Ería maü̃xgu. Rü yexguma nixĩ ga tomaẽ̱xpü̱x ga taunecüarü ngãxü̃ rü taguma napuxü̃, rü poraãcü nangúxü̃ ga taiya ga guxü̃ ga ñaa nachixü̃anewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","—Natürü ga Tupana rü tama wüxi ga Iraéanecü̱̃ã̱x ga yutecüxü̃tawa Eríaxü̃ namu. Natürü ngĩxü̃tawa nanamu ga yema yutecü ga Charépacü̱̃ã̱x ga Chidã́ũãrü ĩãneãrü ngaicamagu ãchiü̃cü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","—Rü yexguma namaü̃xgu ga Erichéu, rü Iraéanewa nayexmagü ta ga muxü̃ma ga duü̃xü̃gü ga chaxünemaã iḏaaweexü̃. Natürü taxuü̃ma ga yema iḏaaweexü̃ ga Iraéanewa yexmagüxü̃ rü naxcèx nitaaneẽ. Rü Namáü̃ ga Chíriaanecü̱̃ã̱xĩcatama nixĩ ga guma naxcèx yataanecü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Rü yexguma yema orexü̃ naxĩnüẽgu, rü guxü̃ma ga yema duü̃xü̃gü ga guma ngutaquẽ́xepataü̃wa yexmagüxü̃ rü poraãcü naxcèx nanuẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Rü inachigü ga duü̃xü̃gü rü Ngechuchuxü̃ ínatèxüchigü ga guma ĩãnewa. Rü guma mèxpǘne ga guma ĩãne nawa yexmanechitaeruwa nanagagü na yéma yanataegüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Natürü ga Ngechuchu rü norü ngãxü̃tanüwa ínaxũxũãma, rü ínixũ. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Rü yexguma ga Ngechuchu rü Gariréaaneãrü ĩãne ga Capernáũwa naxũ. Rü ngü̃xchigaarü ngunexü̃gu yéma duü̃xü̃güxü̃ nangúexẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Rü duü̃xü̃gü rü naḇaixãchiãẽgü namaã ga norü ngu̱xẽẽtae, yerü Tupanaãrü poramaã nidexa. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Rü guma ngutaquẽ́xepataü̃wa nayexma ga wüxi ga yatü ga ngoxo nawa yexmaxü̃. Rü aita yéma naxü, rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Toxna ixũgachi! ¿Tü̱xcüü̃ totanüwa cuxũ, Pa Ngechuchux, Pa Nacharétucü̱̃ã̱x? ¿Nuã cuxũ na toxü̃ cudèi̱xü̃cèx? Choma cuxü̃ chacuèx na Tupana Nane ya Üünecü na quiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Rü Ngechuchu nananga ga yema ngoxo rü ñanagürü: —¡Iyarüngeèx rü ínaxũxũ nawa ya yima yatü! —ñanagürü. Rü yexguma ga yema ngoxo rü duü̃xü̃güpẽ́xegu nayanguxẽẽ ga guma yatü, rü nawa ínaxũxũ. Natürü tama nanapi̱xẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Rü guxü̃ma ga duü̃xü̃gü rü naḇaixãchiãẽgü. Rü nügümücügümaãchigü nachiga nidexagü, rü ñanagürügü: —¿Ṯacü rü ore nixĩ i ngẽma? Erü ñaã yatü rü aixcüma ngẽma ngoxogümaã inacuèx rü poraãcü nanamu. Rü nümagü rü naga naxĩnüẽ, rü ínachoxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Rü guxü̃wama ga yema naãnewa rü Ngechuchuchigaxü̃ nixugüe ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Rü guma ngutaquẽ́xepataü̃wa ínaxũxũ ga Ngechuchu rü Chimáũpatawa naxũ. Rü Chimáũ nèxẽ rü poraãcü iyaxaxüne. Rü Ngechuchuna nacagüe ga ngĩxcèx na yataanexẽẽãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Rü nüma rü ngĩxü̃tagu nayachi rü narümèxãchi rü nananga ga yema axüne. Rü yexgumatama igèu̱xãchi ga na yaxaxünexü̃. Rü yexgumatama íirüda, rü naxcèx inamexẽẽ ga õna. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Rü yexguma marü yanaxücuchaü̃gu ga üèxcü, rü Ngechuchuxü̃tawa nanagagü ga guxü̃ma ga duü̃xü̃gü ga nagúxü̃raü̃xü̃ ga ḏaaweanemaã iḏaaweexü̃. Rü ga Ngechuchu rü wüxichigü ga yema duü̃xü̃güxü̃ ningõgü, rü yemaãcü naxcèx nayataanexẽẽchigü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Rü nanameẽxẽẽ ga muxü̃ma ga duü̃xü̃gü ga iḏaaweexü̃ ga ngoxo nawa yexmagüxü̃. Rü yema ngoxogü rü aita naxüe, rü ñanagürügü: —Cuma nixĩ i Tupana Nane quiĩxü̃ —ñanagürügü. Natürü ga Ngechuchu rü nayangagü ga yema ngoxogü. Rü nüxna nanachu̱xu ga na yadexagüxü̃, yerü yema ngoxogü rü nüxü̃ nacuèxgü na Cristu yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Rü yexguma noxri yangóonegu rü yema ĩãnewa ínaxũxũ ga Ngechuchu. Rü wüxi ga nachica ga taxúema íxãpataxü̃wa naxũ. Natürü ga duü̃xü̃gü rü naxcèx nadaugü rü düxwa naxü̃tawa nangugü. Rü nüxü̃ nacèèxü̃gü ga tama na ínaxũxũxü̃cèx ga yema norü naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —Taxucürüwama petanügu charüxã́ũẽcha erü chanaxwèxe na náĩgü ya ĩãnegüwa ngẽxmagüxü̃ i duü̃xü̃gümaã rü ta nüxü̃ chixuxü̃ na ñuxãcü ãẽ̱xgacü yiĩxü̃ ya Tupana. Erü woetama ngẽmacèx núma choxü̃ namu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Rü yemaãcü Ngechuchu nüxü̃ nixuchigü ga ore ga ngutaquẽ́xepataü̃güwachigü ga guxü̃ma ga Gariréaanewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Rü wüxicana ga yexguma naxtaxa ga Yenecharétuanacüwa nayexmagu ga Ngechuchu, rü muxü̃ma ga duü̃xü̃gü rü naxü̃tawa nangugü. Rü düxwa yéma nayaxãũtügü, yerü nüxü̃ naxĩnüẽchaü̃ ga Tupanaãrü ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Rü Ngechuchu yéma nüxü̃ nadau ga taxre ga ngue ga ingeãcune. Rü guma nguegü rü naxnecüpechinüwa nanadagü, yerü ga püchaetanüxü̃ rü nüxna yéma ínachoü̃, yerü norü pücha niyauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Rü wüxi ga guma nguegu nixüe ga Ngechuchu. Rü guma ngue rü Chimáũãrü nixĩ. Rü Chimáũna naca ga naxnecüpechinüãrü ngãxü̃tüwaxüra na nangeaxü̃cèx. Rü guma nguewa narüto ga Ngechuchu. Rü yéma inanaxügü ga duü̃xü̃güxü̃ na nangúexẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Rü yexguma yagúegagu ga Ngechuchu ga na yadexaxü̃, rü Chimáũxü̃ ñanagürü: —¡yéa ínamátamaxü̃wa namaã naxã ya daa ngue. Rü nge̱ma penatáe i perü pücha na choxnita piyauxgüxü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Rü Chimáũ nanangãxü̃, rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃x, ngewèx rü guxü̃ i chütaxü̃ rü tapüchae, natürü taxuü̃ma i choxni tiyaxu. Natürü ñu̱xma na choxü̃ cumuxü̃ rü wena táxarü íchanatáe i chorü pücha —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Rü yexguma ínatáegüãgu ga norü pücha, rü muxü̃ma ga choxni ínayauxü̃. Rü düxwa narügáuxchaü̃ ga norü pücha yerü namuxũchi ga choxni. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Rü naxmẽ́xmaã náĩ ga nguewa yexmagüxü̃ ga natanüxü̃gücèx nacagü na nüxü̃ yanangü̃xẽẽgüxü̃cèx. Rü yéma naxĩ ga yema natanüxü̃gü ga naxcèx nacagüxü̃. Rü nanaxüãcugü ga guma taxre ga ngue rü wixgutaèx inangutaü̃gü yerü namuxũchi ga choxni. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Rü yexguma yemaxü̃ nadèu̱xgu ga Chimáũ ga Pedru, rü Ngechuchupẽ́xegu nayacaxã́pü̱xü, rü ñanagürü nüxü̃: —¡Choxna ixũgachi! Pa Corix. Erü choma rü wüxi i duü̃xü̃ i pecaduã́xü̃ chixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Rü yema ñanagürü ga Chimáũ yerü nüma rü guxü̃ma ga natanüxü̃gü rü namaã naḇaixãchiãẽgü ga yema muxü̃ma ga choxni na ínayauxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Rü naḇaixãchiãẽgü ta ga Chimáũmücügü ga Chaü̃tiágu rü Cuáü̃ ga Zebedéu nanegü. Natürü Ngechuchu rü Chimáũxü̃ ñanagürü: —¡Tãxṹ i cumuü̃xü̃! Erü ñu̱xmacürüwa rü tá choxü̃́ cupuracü na chauxü̃tawa cunagagüxü̃cèx i duü̃xü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Rü yexguma naxãnacüwa namaã nangugügu ga naweü̃gü, rü yéma nanawogü ga norü guxü̃ma rü Ngechuchuwe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Rü yexguma wüxi ga yéma yexmagüne ga ĩãnewa nayexmagu ga Ngechuchu, rü yéma naxü̃tawa nangu ga wüxi ga yatü ga chaxünemaã iḏaawexü̃. Rü yexguma Ngechuchuxü̃ nadèu̱xgu rü napẽ́xegu nayacaxã́pü̱xü rü yexma nanangücuchi. Rü Ngechuchuxü̃ nacèèxü̃, rü ñanagürü: —Pa Corix, ngẽxguma cuma cunaxwèxegu, rü cuxü̃́ natauxcha na choxü̃ curümexẽẽxü̃ nawa i chorü ḏaawe —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Rü yexguma ga Ngechuchu rü nüxü̃ ningõgü, rü ñanagürü nüxü̃: —Ngü̃, chanaxwèxe. ¡Rüme! —ñanagürü. Rü yexguma yema ñaxgu ga Ngechuchu, rü naxcèx nitaane ga yema yatü ga chaxüneã́xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Rü Ngechuchu nanaxucu̱xẽ rü ñanagürü nüxü̃: —¡Dücèx, taxúemaãtáma nüxü̃ quixu, natürü paixü̃ cugü yadauxẽẽ na curümexü̃ rü yanguxẽẽ i ngẽma Tupana Moĩchéwa nüxü̃ ixuxü̃ na duü̃xü̃gü nüxü̃ cuáxü̃cèx na marü curümexü̃ nawa i curü ḏaawe! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Natürü ga Ngechuchuchiga rü guxü̃wama ninguchigüama. Rü muxü̃ma ga duü̃xü̃gü rü naxcèx naxĩtaquẽ́xegü na norü orexü̃ naxĩnüẽxü̃cèx, rü naxcèx na yataaneẽxẽẽãxü̃cèx ga norü ḏaawegüwa. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Natürü Ngechuchu rü ñuxguacü rü ngextá taxúema íxãpataxü̃wa naxũũxü̃. Rü yéma nayayumüxẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Rü wüxi ga ngunexü̃ Ngechuchu íngu̱xẽẽtaeyane, rü yéma narütogü ga ñuxre ga Parichéugü rü ñuxre ga ngúexẽẽruü̃gü ga Moĩchéarü mugümaã ngu̱xẽẽtaegüxü̃ ga guxü̃ ga Gariréaaneãrü ĩãnexãcügüwa ne ĩxü̃, rü Yudéaanewa ne ĩxü̃, rü Yerucharéü̃wa ne ĩxü̃. Rü Tupana rü poraãcü Ngechuchuwa inanawẽ́x ga norü pora rü muxü̃ma ga iḏaaweexü̃ narümeẽxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Rü Ngechuchuxü̃tawa nangugü ga ñuxre ga yatügü, rü naxcèx yéma nanangetaü̃gü ga wüxi ga yatü ga naw̱ãĩxãchicü. Rü ĩpatagu nanangecuchitaü̃güchaü̃ na Ngechuchupẽ́xegu yaxütaü̃güãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Natürü taxuacüma yexma nanangecuchitaü̃güéga, yerü namuxũchi ga duü̃xü̃gü. Rü yemacèx ĩãcèxwẽ́xgu naxĩgü. Rü meãma Ngechuchu íyexmaxü̃e̱tüwa ínanapogüãxü̃gü ga guma ĩpata. Rü yéma duü̃xü̃gütanüwa Ngechuchupẽ́xewa ínanac̱ẖüxüetaü̃gü ga guma naw̱ãĩxãchicü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga na nüxü̃́ yaxõgüãxü̃ ga yema yatügü, rü ñanagürü guma naw̱ãĩxãchicüxü̃: —Pa Chaunex, marü cuxü̃́ nüxü̃ changechaü̃ i curü pecadugü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Natürü yema ngúexẽẽruü̃gü ga Moĩchéarü mugüarü ngu̱xẽẽtaeruü̃gü rü Parichéugü, rü nagu narüxĩnüẽ, rü nügüãẽwa ñanagürügü: —¿Ṯacü nixĩ i ñaã yatü ecèx Tupanamaã chixexü̃ yaxugüxü̃? Erü taxúema pora tüxü̃́ nangẽxma na duü̃xü̃güaxü̃́ pecaduxü̃ tangechaü̃xü̃. Rü Tupanaxĩcatama nixĩ ya nüxü̃́ nangẽxmacü i ngẽma pora —ñanagürügü naãẽwa. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Natürü ga Ngechuchu rü nüxü̃ nacuèx ga ṯacügu na ínaxĩnüẽxü̃. Rü yemacèx ñanagürü nüxü̃: —¿Tü̱xcüü̃ ngẽ-magu perüxĩnüẽ i pemax? ");
INSERT INTO tcaNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—¿Ṯacü nixĩ irütauxchamaẽxü̃ na namaã nüxü̃ ixuxü̃ ya daa yatü ya naw̱ãĩxãchicü: “Curü pecadugü rü marü cuxü̃́ nüxü̃ changechaü̃”, rü ẽ́xna: “¡Inachi rü íixũ!” ñágüxü̃ nüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","—Natürü ñu̱xma rü tá pexü̃ nüxü̃ chadauxẽẽ na Chaunatü núma choxü̃ muxü̃ na duü̃xü̃güaxü̃́ nüxü̃ changechaü̃xü̃cèx i norü pecadugü —ñanagürü. Rü yexguma yema ñaxguwena rü guma naw̱ãĩxãchicüxü̃ ñanagürü: —Cumaã nüxü̃ chixu rü ¡inachi, rü nayaxu i curü caruü̃, rü cupatawa naxũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Rü yexgumatama guxü̃ ga duü̃xü̃güpẽ́xewa inachi ga guma naw̱ãĩxãchicü. Rü nanayaxu ga norü caruü̃ ga nagu nacaxü̃. Rü Tupanaxü̃ yacuèxüü̃chigüãcüma napatawa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Rü guxü̃ma ga duü̃xü̃gü rü naḇaixãchiãẽgü. Rü Tupanaxü̃ nicuèxüü̃gü. Rü poraãcü namuü̃ẽãcüma ñanagürügü: —Ñu̱xma rü nüxü̃ tadaugü i ñuxre i Tupanaãrü puracügü i aixcüma mexẽchixü̃gü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Rü yemawena ga Ngechuchu rü ínaxũxũ ga guma ĩwa. Rü wüxi ga yatü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ideetanüxü̃xü̃tawa naxüpetü. Rü guma yatü rü Lebí nixĩ ga nae̱ga. Rü yéma dĩẽru ngĩxü̃ ínadexü̃wa narüto. Rü Ngechuchu rü ñanagürü nüxü̃: —¡Chowe rüxũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Rü inachi ga Lebí, rü yéma nanatèx ga norü guxü̃ma, rü Ngechuchuwe narüxũ. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Rü yixcama ga Lebí rü Ngechuchucèx napatawa wüxi ga taxü̃ ga õna naxü. Rü muxü̃ma ga yatügü ga Lebírüü̃ dĩẽruarü degüwa puracüexü̃, rü muxü̃ma ga togü ga duü̃xü̃gü rü ta yéma mechawa narütogü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Natürü ga yema Parichéugü rü ngúexẽẽruü̃gü ga Moĩchéarü mugüarü ngu̱xẽẽtaeruü̃gü, rü inanaxügüe na Ngechuchuarü ngúexü̃güchigagu chixri yadexagüxü̃. Rü ñanagürügü: —¿Tü̱xcüü̃ wüxiwa pechibüe rü namaã pexaxegü i ngẽma yatügü i Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ dexü̃ rü ngẽma pecaduã̱xgüxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Ngẽma poraexü̃ rü taxucèxma duturu nanaxwèxegü, natürü ngẽma iḏaaweexü̃ nixĩ i duturu naxwèxegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","—Choma rü tama mexü̃güna na chaxuxü̃cèx nixĩ i núma chaxũxü̃, natürü pecaduã̱xgüxü̃na na chaxuxü̃cèx nixĩ i núma chaxũxü̃ na ngẽmaãcü nüxü̃ naxoexü̃cèx i nacümagü i chixexü̃gü rü Tupanawe naxĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Rü yexguma Ngechuchuna nacagüe ga duü̃xü̃gü, rü ñanagürügü: —Cuáü̃ ya baiü̃xẽẽruü̃ãrü ngúexü̃gü rü Parichéugüarü ngúexü̃gü rü nayumüxẽgüecha, rü muẽ̱xpü̱xcüna rü naxauree rü tama nachibüe erü Tupanagu narüxĩnüẽ. Natürü i curü ngúexü̃gü, rü guxü̃guma nachibüe rü naxaxegümare —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Natürü ga Ngechuchu rü nanangãxü̃, rü wüxi ga ore ga nügüchigaxü̃tama namaã nixu, rü ñanagürü: —¿Ẽ́xna wüxi i ngĩgüarü petawa rü pexcèx namexü̃ na penaxaureexẽẽxü̃ i ngẽma nüxna naxugüxü̃ ega natanüwa nangẽxmagu i ngẽma yatü i ngexwacèx ãmaxü̃? Rü tama nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","—Natürü wüxi i ngunexü̃ rü ngẽma yatü i ngexwacèx ãmaxü̃, rü tá namücügüna nixũgachi. Rü ngẽma ngunexü̃gu tá nixĩ i aixcüma naxaureexü̃ i namücügü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Rü yexguma ga Ngechuchu rü namaã nüxü̃ nixu ga wüxi ga ore ga yema duü̃xü̃gücüma ga nuxcümaü̃xü̃chiga rü noxrütama ngu̱xẽẽtae i ngexwacaxü̃xü̃chiga. Rü ñanagürü: —Taxúema wüxi i ngexwacaxü̃xü̃ i naxchiruta tiyo na namaã tanapaitaxü̃cèx i wüxi i naxchiru i marü ngauxü̃. Erü ngẽxguma ngẽmaãcü tanaxü̱xgu rü tanachixexẽẽ i ngẽma naxchiru i ngexwacaxü̃xü̃. Rü ñu̱xũchi ngẽma natüchi i ngexwacaxü̃xü̃ rü tama nüxü̃ nayatãũxü̃ i ngẽma naxchiru i marü ngauxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Rü ngẽxgumarüü̃ ta rü taxúema ngexwacaxü̃cü ya binu rü nagu tayabacuchi i wüxi i naxchiü̃ i marü ngauxü̃ i naxchèxmünaxcèx. Erü ngẽxguma ngẽmaãcü naxü̱xgu rü yima binu ya ngexwacaxü̃cü rü tá narüngu, rü tá nayawã̱ĩ̱xẽẽ i ngẽma naxchiü̃ i ngauxü̃ i naxchèxmünaxcèx. Rü ngẽxma tá nayarütaxu ya binu rü ngẽma naxchiü̃ rü ta. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","—Rü ngẽmacèx tanaxwèxe na yima ngexwacaxü̃cü ya binu rü ngexwacaxü̃xü̃ i naxchiü̃gu yabacuchixü̃. Rü ngẽmaãcü rü taxuü̃táma inayarütaxu. ");
INSERT INTO tcaNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","—Rü taxúema ya texé ya tümamaã yaxǘxe na ngúchiacü ya binu tayaxaxüxü̃ rü tüxü̃́ nangúchaü̃ na tayaxaxüxü̃ ya binu ya ngexwacaxü̃cü ya maĩcuracü. Rü ngẽxgumarüü̃ ta nixĩ i ngẽma duü̃xü̃gü i marü namaã yaxüxü̃ i nuxcümaü̃xü̃ i nacüma i chixexü̃ rü tama nanayauxgüchaü̃ i ngẽma mexü̃ i ngu̱xẽẽtae i ngexwacaxü̃xü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Rü wüxi ga ngü̃xchigaarü ngunexü̃gu rü Ngechuchu rü norü ngúexü̃gümaã trigunecüwa nachopetü. Rü norü ngúexü̃gü rü inaxĩãcüma yoxocüne trigu nicãũtanü. Rü naxmẽ́xmaã nanadaxi ga trigu rü nayangṍẽtanü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Rü ñuxre ga Parichéugü rü yema ngúexü̃güna nacagü, rü ñanagürügü: —¿Tü̱xcüü̃ ngü̃xchigaarü ngunexü̃gu penabuxu i trigu? Erü ngü̃xchigaarü ngunexü̃gu rü nachu̱xu na texé puracüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —¿Taguma ẽ́xna poperawa nüxü̃ pedau ga ṯacü na naxüxü̃ ga nuxcümaü̃cü ga ãẽ̱xgacü ga Dabí ga yexguma nataiyagu ga nüma rü natanüxü̃gü? ");
INSERT INTO tcaNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","—Rü Tupanapatagu naxücu rü nüxü̃ nadau ga yema pãũ ga üünexü̃ ga yexma nuxü̃. Rü yema pãũ rü nachu̱xu ga ngexerǘxemare na nangṍxü̃, rü paigücèxicatama nixĩ. Natürü Dabí nanayaxu ga yema pãũ rü nanangõ̱x, rü natanüxü̃maã rü ta nangau —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Rü ñanagürü ta ga Ngechuchu: —Tupana Nane ya duü̃xü̃xü̃ ixĩcü rü namaã inacuèx i ngü̃xchigaarü ngunexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Rü to ga ngü̃xchigaarü ngunexü̃gu rü Ngechuchu rü ngutaquẽ́xepataü̃gu naxücu. Rü inanaxügü ga na nangu̱xẽẽtaexü̃. Rü yéma nayexma ga wüxi ga yatü ga norü tügünewa yumécü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rü yema ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ rü Parichéugü, rü Ngechuchuxü̃ nangugügü ngoxita ngü̃xchigaarü ngunexü̃gu guma yumécüxü̃ namexẽẽ, yerü naxcèx nadaugü ga ñuxãcü norü ãẽ̱xgacügüxü̃tawa na ínaxuaxü̃güãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Natürü nüma ga Ngechuchu rü nüxü̃ nacuèx ga yema naãẽwa nagu naxĩnüẽxü̃ ga yema yatügü. Rü yemacèx guma yumécüxü̃ ñanagürü: —¡Írüda rü nuxã ngãxü̃tanügu yachi! —ñanagürü. Rü guma yumécü rü inachi rü norü ngãxü̃tanügu nayachi. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Rü yexguma ga Ngechuchu rü nüxna naca ga yema Parichéugü rü yema mugüwa ngu̱xẽẽtaegüxü̃, rü ñanagürü nüxü̃: —¿ṯacü nixĩ i ngema mexü̃ ixüxü̃ i ngü̃xchigaarü ngunexü̃gu? ¿Rü ngema mexü̃ rü ẽ́xna chixexü̃? ¿Rü namexü̃ i na namaxẽẽxü̃ rü ẽ́xna yamáxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Rü yexguma Ngechuchu nüxü̃ nidaugüãchi ga yema duü̃xü̃gü ga yéma yexmagüxü̃. Rü guma yumécüxü̃ ñanagürü: —¡Iyanawẽ́xãchixẽẽ ya cuxmẽ́x! —ñanagürü. Rü guma yatü rü nügü inayarüwẽ́xãchimẽ́xẽxẽẽ, rü narümemẽ́x. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Natürü yema Parichéugü rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü poraãcü nanuẽ. Rü nügü nixucu̱xẽgü na ñuxãcü tá Ngechuchuxü̃ na yamèxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Rü yexguma ga Ngechuchu rü dauxchitawa, wüxi ga mèxpǘnewa naxũ na yéma yayumüxẽxü̃cèx. Rü guxü̃ ga yema chütaxü̃gu rü yéma nayumüxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Rü yexguma yangóonegu, rü Ngechuchu norü ngúexü̃gücèx naca. Rü natanüwa nayadexechi ga 12. Rü yema nixĩ ga yatügü ga Ngechuchu nüxü̃ unetagüxü̃ na tóxnamana nangegüãxü̃cèx ga norü ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Rü yema yatügü ga nadexü̃ rü Chimáũ ga Pedrugu nanaxüéga nixĩ ga wüxi. Rü to nixĩ ga Aü̃dré ga Chimáũ naẽneẽ, rü Chaü̃tiágu rü Cuáü̃, rü Piripi, rü Baturumé, ");
INSERT INTO tcaNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","rü Mateu, rü Tumachi, rü Chaü̃tiágu ga Arupéu nane rü Chimáũ ga iporaãẽcüücü, ");
INSERT INTO tcaNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","rü Yuda ga Chaü̃tiágueneẽ, rü Yuda Icariúte ga yixcama Ngechuchuxü̃ íxuaxü̃xü̃ naẽchita. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Rü Ngechuchu rü yema yatügü ga nadexü̃maã ínarüxĩgü nawa ga guma mèxpǘne. Rü wüxi ga nachica ga ínametachinüãnexü̃wa nayachaxãchitanü. Rü yéma nayexmagü ga muxü̃ma ga duü̃xü̃gü ga guxü̃ ga Yudéaanewa ne ĩxü̃, rü Yerucharéü̃wa ne ĩxü̃, rü taxtü ga taxü̃ãnacüwa ga Chidã́ũwa rü Tiruwa ne ĩxü̃. Rü yéma naxĩ yerü Ngechuchuxü̃ naxĩnüẽchaü̃, rü nanaxwèxegü ga Ngechuchu na nameẽxẽẽxü̃ ga norü ḏaawegüwa. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Rü yema duü̃xü̃gü ga chixexü̃ ga naãẽ nawa yexmagüxü̃ rü ta naxcèx nitaanegü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Rü guxü̃ma ga duü̃xü̃gü rü Ngechuchuxü̃ ningõgügüchaü̃, yerü norü poramaã nanameẽxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Rü yexguma Ngechuchu rü norü ngúexü̃güxü̃ nadawenü, rü ñanagürü nüxü̃: —¡Petaãẽgü i pema ya ingearü ngẽmaxü̃ã̱xgüxe! Rü Tupana ãẽ̱xgacü íixĩxü̃wa rü pema rü tá ta pexãchica. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","—¡Rü petaãẽgü i pema i ñu̱xma taiyaexe! ¡Rü tá meãma pingãxcharaü̃gü! ¡Rü petaãẽgü i pema i ñu̱xma auxexe! Rü yixcama rü tá pecugüe. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","—¡Rü petaãẽgü i pema i ngẽxguma duü̃xü̃gü pexchi aiegu, rü pexü̃ ínawoü̱̃xgu, rü ṯacü pemaã yaxugüegu, rü chaugagu chixri pechiga yadexagügu! ");
INSERT INTO tcaNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","—Rü ngẽxguma ngẽma pexü̃ üpetügu, rü ¡petaãẽgüama rü tama pexoegaãẽgü! Erü daxũguxü̃ i naãnewa rü tá penayauxgü i wüxi i perü ãmare i mexẽchixü̃. Rü dücax, ñaã duü̃xü̃gü i ñu̱xma pexchi aiexü̃ãrü o̱xigü rü yexgumarüü̃ ta nixĩ ga naxchi na naxaiexü̃ ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","—Natürü wüxi i ngechaü̃ tá nixĩ i pexcèx i pema ya muãrü ngẽmaxü̃ã̱xgüxe erü núma ñoma i naãnewa rü marü petaãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","—Rü wüxi i ngechaü̃ tá nixĩ i pexcèx i pema ya marü ingaxcharaü̃güxe erü tá petaiyae. Rü wüxi i ngechaü̃ tá nixĩ i pexcèx i pema i ñu̱xma marü cugüexe, erü yixcama rü perü ngechaü̃maã tá pexauxe. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","—Rü wüxi i ngechaü̃ tá nixĩ i pexcèx i ngẽxguma guxü̃ma i duü̃xü̃gü pexü̃ icuèxüü̃gügu. Erü ngẽma duü̃xü̃gü i ñu̱xma pexü̃ icuèxüü̃güxü̃ãrü o̱xigü rü yexgumarüü̃ nüxü̃ nicuèxüü̃gü ga nuxcümaü̃güxü̃ ga orearü uruü̃güneta. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Natürü pema i ñu̱xma na choxü̃ pexĩnüẽxü̃ rü pemaã nüxü̃ chixu rü: —¡Nüxü̃ pengechaü̃ i ngema pemaã rüxuwanügüxü̃! ¡Rü meã nüxü̃ perüngü̃xẽẽ̱x i ngẽma pexchi aiexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","—¡Rü meã nachiga pidexagü rü naxcèx ípeca i Tupanaãrü ngü̃xẽẽ naxcèx i ngẽma pemaã guxchigagüxü̃! ¡Rü naxcèx peyumüxẽgü i ngẽma chixri pechigamaã idexagüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","—Rü ngẽxguma texé cumaã nuxgu rü cuxü̃ tapechiwegu rü name nixĩ i tama cuxütanü ega woo curü tochiwewa rü ta cuxü̃ tapechiwegu. Rü ngẽxguma texé cuxü̃ napuarü gáuxü̃chiruã̱xgu, rü name nixĩ i tüxü̃ cungechaü̃ãma ega woo curü daxũ rü ta cuxna tanapuxgu. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","—¡Rü tüxna naxã ya texé ya curü ngẽmaxü̃cèx íc̱axe! Rü ngẽxguma texé curü ngẽmaxü̃ cuxna napuxgu, rü tama name i naxcèx cungema. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","—Rü ngẽma mexü̃ i pema penaxwèxexü̃ na togü pemaã naxüxü̃, rü name nixĩ i pema rü ta ngẽmaãcü mexü̃ namaã pexü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","—Rü ngẽxguma pema rü ngẽma duü̃xü̃gü i pexü̃ ngechaü̃xü̃xü̃xĩcatama pengechaü̃gu, rü ¿ṯacüwa namexü̃ i ngẽma? Erü ngẽma duü̃xü̃gü i tama yaxõgüxü̃ rü ngẽmaãcü nanaxügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","—Rü ngẽxguma ngẽma duü̃xü̃gü i cuxü̃ rüngü̃xẽẽxü̃xü̃xĩcatama curüngü̃xẽẽgu, rü ¿ṯacüwa namexü̃ i ngẽma? Erü ngẽma duü̃xü̃gü i tama yaxõgüxü̃ rü ngẽmaãcü nanaxügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","—Rü ngẽxguma ngẽma duü̃xü̃gü i ixããrü dĩẽruã́xü̃naxĩcatama cunaxãxgu i curü dĩẽru, rü ¿ṯacüwa namexü̃ i ngẽma? Erü ngẽma duü̃xü̃gü i tama yaxõgüxü̃ rü ngẽmaãcü nanaxügü, erü nüxü̃ nacuèxgü rü tá nüxü̃́ nanataeguxẽẽ i ngẽma dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","—Natürü pema rü name nixĩ i nüxü̃ pengechaü̃ i ngema pemaã rüxuwanügüxü̃, rü nüxü̃ perüngü̃xẽẽ. Rü ngẽxguma ṯacücèx pexna nacaxgu, rü name nixĩ i tama pexoegaãẽãcüma nüxna penaxã ega woo nagu perüxĩnüẽgu na ngürüãchi tãũtáma pexü̃́ nataeguxẽẽãxü̃. Erü ngẽxguma ngẽmaãcü penaxü̱xgu, rü Tupana rü ngẽmaãrü yexera tá poraãcü pexü̃́ nanataeguxẽẽ, rü naxãcügü tá pixĩgü ya yima Tupana ya Poraxüchicü ya nüxü̃ rüngü̃xẽẽcü ta i ngẽma taguma moxẽ nüxna ãgüxü̃ rü ngẽma chixecümagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","—Rü pema rü name nixĩ i pengechaü̃w̱axegü, ngẽma Penatü ya Tupana na ngechaü̃w̱axexü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","—¡Rü taxũ i togüxü̃ pixuxü̃! Rü ngẽxguma ya Tupana rü tãxũtáma pexü̃ nixu na pechixexü̃. ¡Rü taxũ i poxcu namaã pexueguxü̃ i togü! Rü ngẽxguma ya Tupana rü tãxũtáma poxcu pemaã naxuegu. ¡Rü nüxü̃́ nüxü̃ perüngü̃mae i norü chixexü̃ i togü! Rü ngẽxguma ya Tupana rü tá pexü̃́ nüxü̃ narüngü̃ma i perü chixexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","—¡Rü togümaã pengau i perü ngemaxü̃gü! Rü ngexguma ya Tupana rü tá pexna nanaxã. Rü ñoma wüxi i choca i meãma napaxü̃rüü̃ rü meama ípoõcuxü̃rüü̃ tá Tupana pexna nanaxã. Erü ngema nguruxü̃ i namaã cumücüna cuxãxü̃ i curü ngemaxü̃ rü ngematama nguruxü̃maã tá Tupana cuxna nanaxã —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Rü Ngechuchu rü ñaã cuèxruü̃ norü ngúexü̃gümaã nixu, rü ñanagürü: —¿Ñuxãcü i wüxi i ngexetüxü̃ rü to i ngexetüxü̃xü̃ namaxü̃ nacuèxẽẽxü̃? Erü ngẽma taxre i ngexetüxü̃ rü wüxi i ãxmaxü̃gu tá nügümaã nayayicu. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","—Rü taxuü̃ma i ngúexü̃ rü norü ngúexẽẽruü̃xü̃ narüyexera. Natürü ngexguma meã nangu̱xgu rü tá naxrüxü̃ nixĩ ya norü ngúexẽẽruü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—¿Rü tü̱xcüü̃ nachiga quidexa i cumücü naxcèx i ngẽma íraxü̃ i chixexü̃ i naxüxü̃ natürü tama cugütama cungugü naxcèx i ngẽma chixexü̃ i taxü̃ i cuxüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","—Rü ngẽxguma tama nüxna cucuèxãchigu i ngẽma chixexü̃ i taxü̃ i cumatama cuxüxü̃, rü ¿ñuxũcürüwa i nagu curüxĩnüxü̃ na cunamexẽẽxü̃ i ngẽma cumücüarü chixexü̃ i íraxü̃? Pa Duü̃xü̃ i Meã Maxnetaxü̃x, name nixĩ i cuxira nüxü̃ curüxo i ngẽma chixexü̃ i taxü̃ i cumatama cuxüxü̃, rü ngẽxguma tá cume na nüxü̃ curüngü̃xẽẽxü̃cèx i cumücü na nüxü̃ naxoxü̃cèx i ngẽma chixexü̃ i íraxü̃ i naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","—Nataxuma i nanetü i mexü̃ i chixearü oóxü̃. Rü nataxuma i nanetü i chixexü̃ i meãrü oóxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","—Rü wüxichigü i nanetü rü norü owa nixĩ i nüxü̃ icuáxü̃. Rü wüxi i torawa rü taxucürüwama wüxi i ori̱x i imúxü̃ tayaxu. Rü wüxi i chuxchuxü̃wa rü taxucürüwa uba tayaxu. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","—Rü wüxi ya mecü ya yatü rü mexü̃ i orexü̃ nixu, erü naãẽwa rü aixcüma mexü̃gu narüxĩnü. Natürü wüxi i yatü i chixecümaxü̃ rü chixexü̃ i orexü̃ nixu, erü chixexü̃gu narüxĩnü. Rü ngẽma naãẽwa ngexmaxü̃ i chixexü̃ nixĩ i nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","—¿Tü̱xcüü̃ i pema rü: “Pa Torü Corix” ñaperügü choxü̃, natürü tama penaxü i ngẽma pemaã nüxü̃ chixuxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","—Rü ñu̱xma tá pemaã nüxü̃ chixu na ñuxãcü tiĩxü̃ ya yíxema chowe rüxũxẽ rü choxü̃ ĩnüxẽ rü naxǘxe i ngẽma tümamaã nüxü̃ chixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","—Rü tüma rü wüxi ga yatü ga üpatacü rü yamèxmaü̃cü ga norü caxta ñu̱xmata nutawa nangucürüü̃ tixĩ. Rü yexguma namèxgu ga taxtü rü yabaixü̃gu ga napata, rü woo ga na naporaü̃chiüxü̃, rü tama niwèxtaü̃, yerü meãma inapugüarü caxtaã̱x ga guma ĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","—Natürü yíxema nüxü̃ ĩnümarexe i chorü ore natürü tama naxǘxe i ngẽma tümamaã nüxü̃ chixuxü̃, rü wüxi ga yatü ga naxnücüétügumare üpatacürüü̃ tixĩ. Rü yexguma namèxgu ga taxtü, rü nibaixü̃ ga napata, rü naporaü̃chiü. Rü niwèxtaü̃ ga napata, rü yexma nayarüxo ga guma ĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Rü yexguma nüxü̃ nachauxgu ga duü̃xü̃gümaã na yadexaxü̃ ga Ngechuchu, rü Capernáũwa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Rü yéma nayexma ga wüxi ga churaragüarü capitáü̃ ga Dumacü̱̃ã̱x. Rü guma capitáü̃ rü nüxü̃́ nayexma ga wüxi ga norü duü̃xü̃ ga poraãcü nüxü̃ nangechaü̃xü̃. Rü yema norü duü̃xü̃ rü niḏaawe, rü naturaxüchi. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Rü yexguma Ngechuchuxü̃ naxĩnüchigagu ga guma capitáü̃, rü Ngechuchuxü̃tawa nanamugü ga ñuxre ga Yudíugüarü ãẽ̱xgacügüerugü. Rü ñanagürü nüxü̃: —¡Nge̱ma Ngechuchuxü̃tawa pexĩ na nüxü̃ pecèèxü̃güxü̃cèx rü núma naxũ na chorü duü̃xü̃cèx yanataanexẽẽãxü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Rü Ngechuchuxü̃tawa naxĩ, rü poraãcü nüxü̃ nacèèxü̃gü, rü ñanagürügü: —Name nixĩ i nüxü̃ curüngü̃xẽẽ ya torü capitáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","—Erü nüma rü guxü̃ i Yudíugüxü̃ nangechaü̃. Rü nümatama nanaxütanü na naxügüãxü̃cèx ga torü ngutaquẽ́xepataü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Rü yexguma ga Ngechuchu rü nawe narüxũ. Natürü yexguma marü capitáü̃pataxü̃ yangaicagu, rü nüma ga capitáü̃ rü Ngechuchucèx yéma nanamu ga ñuxre ga namücügü na namaã nüxü̃ yanaxugüxü̃cèx ga norü ore ga ñaxü̃: —Pa Corix, tama cuxü̃ chachixewechaü̃ na chopatawa cunguxü̃ erü choma rü taxuwama chame na chopatagu na cuxücuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","—Rü ngẽmacèx nixĩ i tama chomatama cuxcèx chayac̱axü̃. Rü chanaxwèxe i curü orewaxicatama nüxü̃ quixu na naxcèx yataanexü̃ tá i chorü duü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","—Erü choma rü ta chorü ãẽ̱xgacümẽ́xẽwa changẽxma, rü cho̱xmẽ́xwa nangẽxmagü ta i ñuxre i churaragü. Rü ngẽxguma chanamu̱xgu i wüxi na ngextá naxũxü̃cèx, rü nge̱ma naxũ. Rü ngẽxguma chaugüxü̃tawa naxcèx changemagu i to, rü chauxü̃tawa nangu. Rü ngẽxguma chorü duü̃xü̃xü̃ chamu̱xgu na ṯacü na naxüxü̃cèx, rü choxü̃́ nanaxü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Rü nüma ga Ngechuchu rü yexguma nüxü̃ naxĩnügu ga yema capitáü̃ãrü ore rü naḇaixãchiãẽ. Rü yema duü̃xü̃gü ga nawe rüxĩxü̃xü̃ nadawenü, rü ñanagürü: —Aixcüma pemaã nüxü̃ chixu rü taxuü̃ma i Yudíugütanüwa nüxü̃ ichayangau i wüxi i duü̃xü̃ i ngẽma yatürüü̃ aixcüma yaxõxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Rü yexguma nawoegugu ga yema capitáü̃mücügü ga Ngechuchuxü̃tawa namugüxü̃, rü nüxü̃ inayangaugü ga marü naxcèx na yataanexü̃ ga yema capitáü̃ãrü duü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Rü yemawena ga Ngechuchu rü wüxi ga ĩãne ga Naĩ́gu ãe̱ganewa naxũ. Rü nawe narüxĩ ga norü ngúexü̃gü, rü muxü̃ma ga togü ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Rü yexguma guma ĩãneãrü ngaicamana nanguxgu, rü tüxü̃ nadau ga wüxi ga yueta ga tèxgüwa tüxü̃ nangegüxe. Rü guxema yuetaarü mamá rü tayute rü guma yucü rü guxicatama nixĩ ga tümane ixĩcü. Rü muxü̃ma ga duü̃xü̃gü ga guma ĩãnecü̱̃ã̱x rü tüxü̃ ínixümücügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Rü yexguma Cori ga Ngechuchu guma yucüarü mamaxü̃ dèu̱xgu, rü nüxü̃́ ingechaü̃tümüü̃. Rü ñanagürü ngĩxü̃: —¡Tãxṹ i cuxaxuxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Rü yexguma ga Ngechuchu rü yuetacèx nixũ, rü nüxü̃ ningõgü ga tümachiü̃. Rü yema tüxü̃ ingetaü̃güxü̃ rü tümamaã inayachiãchitanü. Rü ñanagürü ga Ngechuchu tüxü̃ ga guxema yueta: —Pa Ngextü̱xücüx, ¡írüda! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Rü yexguma ga guxema yuchiréxe rü ítarüto, rü itanaxügü ga na tidexaxü̃. Rü Ngechuchu rü tümaẽna tüxü̃ namu. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Rü yexguma yemaxü̃ nadaugügu ga duü̃xü̃gü, rü guxü̃ma namuü̃ẽ. Rü inanaxügüe ga Tupanaxü̃ na yacuèxüü̃güxü̃. Rü ñanagürügü: —Wüxi i Tupanaãrü orearü uruü̃ i poraxü̃ tatanüwa nango̱x. Rü ñanagürügü ta: —Tupana nuã naxũ na norü duü̃xü̃güxü̃ yanangü̃xẽẽxü̃cèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Rü guxü̃ma ga Yudéaanewa rü norü ngaicamana, rü duü̃xü̃gü nüxü̃ nacuáchigagü ga yema Ngechuchu üxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Rü Cuáü̃ ga baiü̃xẽẽruü̃ rü nüxü̃ nacuáchiga ga guxü̃ma ga yema Ngechuchu üxü̃, yerü norü ngúexü̃gü ga Cuáü̃ rü namaã nüxü̃ nixugü. Rü yemacèx ga Cuáü̃ rü taxre ga norü ngúexü̃gücèx naca. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Rü Ngechuchuxü̃tawa nanamugü. Rü Cuáü̃ rü ñanagürü nüxü̃: —¡Nge̱ma pexĩ rü Ngechuchuna peca rü ñapegügü nüxü̃: “¿Cuma yiĩxü̃ i Cristu i cuxü̃ ítananguxẽẽxü̃, rü ẽ́xna to tá yixĩ i Cristu?” ñapegügü nüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Rü yema yatügü ga Cuáü̃ Ngechuchuxü̃tawa mugüxü̃, rü Ngechuchucèx naxĩ. Rü ñanagürügü nüxü̃: —Cuáü̃ ya baiü̃xẽẽruü̃ núma cuxü̃tawa toxü̃ namugü na cuxna tayacagüxü̃cèx rü ¿aixcüma cuma quiĩxü̃ i Cristu ya núma nguxchaü̃cü, rü ẽ́xna to tá yixĩ i Cristu? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Rü yexgumatama Ngechuchuxü̃tawa nangugügu ga Cuáü̃ãrü ngúexü̃gü, rü Ngechuchu nanameẽxẽẽ ga muxü̃ma ga duü̃xü̃gü ga nagúxü̃raü̃xü̃ ga ḏaawemaã iḏaaweexü̃ rü yema ingoxoã́xü̃. Rü nayadauchigüxẽẽ ga muxü̃ma ga ingexetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Rü yemacèx Ngechuchu nanangãxü̃ rü ñanagürü: —¡Pewoegu rü Cuáü̃maã nüxü̃ peyarüxu i ngẽma pematama nüxü̃ pedauxü̃ rü nüxü̃ pexĩnüẽxü̃! ¡Rü namaã nüxü̃ pixu i ñuxãcü i ngẽma ingexetüxü̃ rü marü nidauchigü, rü ngẽma ichixeparaxü̃ rü marü inachigü, rü ngẽma chaxüneã̱xgüxü̃ rü marü naxcèx nitaanegü, rü ngẽma ngauchi̱xẽgüxü̃ rü marü ningo̱xnamachi̱xẽgü, rü ngẽma yuexü̃ rü wenaxãrü namaxẽ, rü ngẽma ingearü ngẽmaxü̃ã́xü̃maã rü marü nüxü̃ tixu i Tupanaãrü ore i mexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","—Rü tataãẽ ya yíxema texé ya tama choxü̃ rüxoxe —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Rü yexguma nawoegu̱xgu ga yema duü̃xü̃gü ga Cuáü̃ yéma mugüxü̃, rü Ngechuchu inanaxügü ga guma Cuáü̃chiga na yadexaxü̃. Rü duü̃xü̃gümaã nüxü̃ nixu, rü ñanagürü: —¿Ṯacü nixĩ ga pema ípeyadaugüxü̃ ga dauxchitawa ga taxúema íxãpataxü̃wa? ¿Ẽ́xna wüxi ga yatü ga turaxü̃ ga ñoma dexne ga buanecü yaxĩã̱xtanücüüxẽẽcürüü̃ ixĩxü̃ nixĩ ga ípeyadaugüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","—Rü ẽ́xna tama guma ípeyadaugügu, ¿rü ṯacü nixĩ ga ípeyadaugüxü̃? ¿Ẽ́xna wüxi ga yatü ga poraãcü nügü ngèxãẽcü ípeyadaugü? Pema nüxü̃ pecuèx i ngẽma poraãcü nügü ngèxãẽgüxü̃ rü ãẽ̱xgacügü ya tacügüpatawa nangẽxmagü, rü taxucèxma dauxchitawa nangẽxmagü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","—¿Ṯacü ẽ́xna nixĩ ga ípeyadaugüxü̃? ¿Ẽ́xna wüxi ga Tupanaãrü orearü uruü̃? Ngẽmáãcü aixcüma yema nixĩ ga ípeyadaugüxü̃. Rü pemaã nüxü̃ chixu rü Cuáü̃ ya baiü̃xẽẽruü̃ rü tama wüxi i ngẽxü̃rüüxü̃ i Tupanaãrü orearü uruü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","—Rü Cuáü̃chiga nixĩ ga naxümatüxü̃ ga yema Tupanaãrü ore ga ñaxü̃: “Cupẽ́xegu chayamu i chorü orearü ngeruü̃ na cuxcèx namexẽẽãxü̃cèx i duü̃xü̃güarü maxü̃”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","—Rü pemaã nüxü̃ chixu rü guxü̃ i duü̃xü̃gütanüwa rü nataxuma i Tupanaãrü orearü uruü̃ i Cuáü̃ ya baiü̃xẽẽruü̃ãrü yexera. Natürü yíxema Tupana ãẽ̱xgacü íixĩxü̃wa wixwexüchi üxe, rü Cuáü̃ãrü yexera tixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Rü guxü̃ma ga duü̃xü̃gü rü woo yema yatügü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ideetanüxü̃, rü nüxü̃ naxĩnüẽ ga yema Ngechuchuarü ore rü ñu̱xũchi Tupanaxü̃ nicuèxüü̃gü yerü nüxü̃ nicuèxãchitanü na aixcüma mecü yiĩxü̃ ga Tupana. Rü yema nixĩ ga duü̃xü̃gü ga ü̃paacü Cuáü̃ íbaiü̃xẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Natürü yema Parichéugü rü yema ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ rü tama nanaxwèxegü ga Cuáü̃ na ínabaiü̃xẽẽxü̃. Rü yemaãcü nüxü̃ naxoe ga yema mexü̃ ga Tupana naxcèx üxchaü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Rü nüma ga Cori ga Ngechuchu rü ñanagürü: —¿Ṯacügu tá chanangu i ñomaü̃cüü maxẽxü̃ i duü̃xü̃gü? ¿Rü nanaṯacüraü̃gü? ");
INSERT INTO tcaNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","—Rü ñaã duü̃xü̃gü rü taxuxü̃maãma nataãẽgü ngẽxgumarüü̃ i ngema buxü̃gü i ĩã̱xtüwa rütogüxü̃, rü íxĩnücèxwèxegüxü̃, rü tagaãcü namücügüxü̃ ñagüxü̃: “Marü wowerumaã pexcèx tapaxetagü natürü tama ípixü̃ãchitanüxü̃. Rü marü ngechaü̃xü̃ i wiyaegu pexcèx tawiyaegü natürü tama pexauxe”, ñagüxü̃. Rü ngẽma buxü̃gürüü̃ taxuxü̃maãma nataãẽgü i ñomaü̃cüü i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","—Yerü ga Cuáü̃ ga baiü̃xẽẽruü̃ rü núma naxũ, rü tama pãũ nangõ̱x rü tama binu nayaxaxü. Rü yexguma ga pema rü: “Nangoxoã̱x” ñaperügü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","—Rü ñu̱xũchi núma chaxũ i choma ya Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü õna changõ̱x rü binu chayaxaxü. Rü ngẽxguma i pema rü ñaperügügü choxü̃: “Choma rü chataanüxü̃chi rü changãxwèxe, rü pecaduã̱ x-güxü̃ i duü̃xü̃gümaã chaxãmücü, rü yatügü i Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ideetanüxü̃maã chaxãmücü”, ñaperügügü choxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","—Natürü Tupanaãrü cuèx rü meãma nango̱x tümawa ya yíxema aixcüma nawe rüxĩxẽ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Rü wüxi ga Parichéu rü Ngechuchuna naxu na napatawa nachibüxü̃cèx. Rü yéma naxũ ga Ngechuchu rü yema Parichéuarü mechawa nayarüto. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Rü wüxi ga ngecü ga chixri maü̃xcü ga guma ĩanecüã̱x, rü yexguma nüxü̃ nacuáchigagu na Parichéupatawa tá na nachibüxü̃ ga Ngechuchu, rü yéma ixũ. Rü yéma inange ga wüxi ga pumara ga yixixü̃ ga wüxi ga butiya ga nutanaxcèxmaã ãxchiü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Rü naxauxãcüma Ngechuchucutüxü̃tawa iyarütoxõchi. Rü ngĩxgüxü̃xẽtümaã iyawaicutüxẽẽ. Rü ngĩyaemaã íinapicutü, rü inachuxcutü. Rü ñu̱xũchi yema pumaramaã inachacutü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Rü yexguma yemaxü̃ nadèu̱xgu ga yema Parichéu ga Ngechuchuna uxü̃, rü naãẽwa nagu narüxĩnü rü nügümaãtama ñanagürü: —Ngẽxguma chi ñaã Ngechuchu rü aixcüma wüxi i Tupanaãrü orearü uruü̃ yixĩgu, rü nüxü̃ chi nacuèx na ṯacü yiĩxü̃ i ñaã ngexü̃ i nüxü̃ ingõgüxü̃ rü ñuxãcü na namaxü̃xü̃ rü poraãcü na napecaduã́xü̃ —ñanagürü ga naãẽwa. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Rü yexguma ga Ngechuchu rü nüxü̃ nacuèxama rü Parichéuxü̃ ñanagürü: —Pa Chimáũx, choxü̃́ nangẽxma i wüxi i ore i cumaã nüxü̃ chixuxchaü̃xü̃ —ñanagürü. Rü nüma ga Parichéu rü Ngechuchuxü̃ nangãxü̃, rü ñanagürü: —¡Ẽcü, chomaã nüxü̃ ixu, Pa Ngúexẽẽruü̃x! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Rü ñanagürü ga Ngechuchu: —Taxre ga yatügü rü wüxi ga corixü̃tawa nanangetanü. Rü wüxi nanangetanü ga 500 tachinü ga dĩẽru rü to nanangetanü ga 50 tachinü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","—Natürü yema taxre rü taxuacü nanaxütanü ga norü ngetanü. Rü yemacèx düxwa yema norü cori rü nüxü̃́ nüxü̃ narüngü̃ma ga yema nüxü̃́ na nangetanügüãxü̃. Rü ñu̱xmax, Pa Chimáũx, rü ¡chomaã nüxü̃ ixu! rü ¿ngẽxü̃rüüxü̃ ga yema taxre ga yatügü rü yexeraãcü norü corixü̃ nangechaü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Rü Ngechuchuxü̃ nangãxü̃ ga Chimáũ, rü ñanagürü: —Chauxcèx ga yema yexeraãcü nüxü̃́ nangetanüxü̃ nixĩ ga yexeraãcü norü corixü̃ ngechaü̃xü̃ —ñanagürü. Rü Ngechuchu rü ñanagürü nüxü̃: —Ngẽmáãcü aixcüma nüma nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Rü yexguma ga Ngechuchu rü ngĩxü̃ nadawenü ga yema ngecü, rü ñanagürü Chimáũxü̃: —¿Ngĩxü̃ cudauxü̃ i ñaã ngecü? Rü cupatagu chaxücu i chomax, Pa Chimáũx, natürü tama dexá choxnata cuxã chorü yauxcutüruü̃. Natürü ñaã ngecü rü ngĩxgüxü̃xetümaã choxü̃ iyawaicutüxẽẽ, rü ngĩyaemaã choxü̃ íipicutü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","—Cuma rü tama choxü̃ cuchuxu i noxri choxü̃ curümoxẽgu, natürü ngĩma i ñaã ngecü rü noxri núma changuxgumama rü choxü̃ iyachuxcutüchigü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","—Cuma rü tama pumaramaã choxü̃ cuchaeruxüra, natürü ngĩma i ñaã ngecü rü chaucutügu inaba i pumara. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","—Rü ngẽmacèx woo namu i ngĩrü pecadugü natürü Tupana ngĩxü̃́ nüxü̃ nangechaü̃ i guxü̃ma, erü ngĩma rü aixcüma choxü̃ ingechaü̃. Natürü yíxema tama aixcüma ngechaü̃cèx íyac̱axe, rü tama poraãcü Tupanaxü̃ tangechaü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Rü yexguma ga Ngechuchu rü yema ngecüxü̃ ñanagürü: —Curü pecadugü rü marü cuxü̃́ nüxü̃ changechaü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Rü yema togü ga nüxna naxugüxü̃ ga yéma Ngechuchumaã mechawa yexmagüxü̃, rü inanaxügü ga nügümücügümaãchigü na yadexagüxü̃. Rü ñanagürügü: —¿Ṯacü nixĩ i ñaã yatü, ecèx ngẽmaãcü duü̃xü̃güaxü̃́ pecaduxü̃ nangechaü̃xü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Natürü Ngechuchu rü ñanagürü ngĩxü̃ ga yema ngecü: —Marü cuxü̃́ nangẽxma i maxü̃ i taguma gúxü̃, erü choxü̃́ cuyaxõ. ¡Ñu̱xma rü taãẽãcüma cuchiü̃wa naxũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Rü yemawena ga Ngechuchu rü Gariréaaneãrü ĩãnegügu nixũãgüchigü. Rü duü̃xü̃gümaã nüxü̃ nixuchigü ga Tupanaãrü ore na ñuxãcü ãẽ̱xgacü yiĩxü̃ ya Tupana. Rü ínayaxümücügü ga yema 12 ga ngúexü̃gü ga marü nadexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Rü yexgumarüü̃ ta íiyaxümücügü ga ñuxre ga ngecügü ga ü̃paacü ngoxogü ngĩwa ínawoxü̃cü rü ngĩrü ḏaaweewa ngĩxü̃ nameẽxẽẽcü. Rü yematanüwa iyexma ga María ga Magadácü̱̃ã̱xmaã ngĩxü̃ naxugücü ga ü̃paacü Ngechuchu 7 ga ngoxo ngĩwa ínawoxü̃cü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Rü yéma iyexma ta ga Cuána ga Cuchu naxmèx. Rü Cuchu nixĩ ga wüxi ga ãẽ̱xgacü ga Erodeaxü̃́ puracüxü̃. Rü yéma nayexmagü ta ga Chuchana rü mucüma ga náĩgü ga ngecügü ga ngĩrü dĩẽrumaã Ngechuchuxü̃ rüngü̃xẽẽgücü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Rü muxü̃ma ga yema ĩãnegücü̱̃ã̱x ga duü̃xü̃gü, rü Ngechuchuxü̃tawa ínayadaugü. Rü yexguma yéma nangutaquẽ́xegügu ga muxü̃ma ga duü̃xü̃gü, rü Ngechuchu namaã nüxü̃ nixu ga wüxi ga ore ga cuèxruü̃, rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Wüxi ga yatü ga toecü rü trigumaã nanagüane. Rü yexguma trigumaã nagüaneãgu rü ñuxre ga trigu, rü namagu nayi. Rü duü̃xü̃gü nawa nangagüxü̃, rü werigü rü nanawecu. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","—Rü náĩgü ga trigu rü nutatanügu nayi. Rü yexguma naxügügu ga guma trigu, rü nipagü rü nayuemare, yerü nataxuma ga norü waianexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","—Rü náĩgü ga trigu rü tuxunecügu nayi. Natürü yexguma nayaegu ga tuxugü rü guma triguxü̃ inawocu rü nanadai. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","—Natürü náĩgü ga trigu rü mexü̃ ga waixü̃mügu nayi. Rü yemacèx ga yexguma nayaegu rü muxü̃ma ga trigu nawa ínanguxuchi. Rü wüxipü̱xü ga triguwa ínanguxuchi ga 100 pü̱xü ga trigu —ñanagürü. Rü yemawena rü Ngechuchu tagaãcü ñanagürü nüxü̃ ga duü̃xü̃gü: —Rü yíxema ãchi̱xẽgüxe, rü ¡naga taxĩnüẽ i ngẽma ore! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Rü yexguma ga norü ngúexü̃gü rü nüxna nacagüe na ṯacüchiga yiĩxü̃ ga yema ore ga yatü ga toecügu ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Rü Ngechuchu ñanagürü nüxü̃: —Tupana rü pexü̃ nüxü̃ nacuèxẽẽ i ngẽma ẽxü̃guxü̃ i taxuü̃ma i togü nüxü̃ cuáxü̃ i ñuxãcü ãẽ̱xgacü na yiĩxü̃ i nümax. Natürü togücèx rü cuèxruü̃gu chayaxúãcüma namaã nüxü̃ chixu i ore. Rü ngexguma woo nüxü̃ nadaugügu rü ñoma tama nüxü̃ nadaugüxü̃rüü̃ nixĩgü, rü woo nüxü̃ naxĩnüẽgu rü ñoma tama nüxü̃ naxĩnüẽxü̃rüü̃ nixĩgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Rü Ngechuchu rü ñanagürü: —Ngẽma ore i toecüchigagu pemaã chixuxü̃ rü ñaãchiga nixĩ. Rü ngẽma trigupü̱xü rü Tupanaãrü orechiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","—Rü guma trigu ga namagu y̱ixü̃nerüü̃ nixĩ i duü̃xü̃gü i ngẽma orexü̃ ĩnüẽxü̃. Natürü Chataná rü ngẽma duü̃xü̃güxü̃ nüxü̃ inayarüngümaẽxẽẽ i ngẽma ore, na tama yaxõgüãxü̃cèx rü tama nayauxgüãxü̃cèx i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","—Rü guma trigu ga nutatanügu y̱ixü̃ne, rü ngẽma nixĩ i duü̃xü̃gü i nüxü̃ ĩnüẽxü̃ i Tupanaãrü ore rü taãẽãcüma yaxõgüxü̃. Natürü tama aixcüma nanayauxgü i ngẽma ore, erü paxaãchi nayaxõgü, rü yixcüra guxchaxü̃ nüxü̃ üpetügu, rü nüxü̃ narüxoe i ngẽma ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","—Rü guma trigu ga tuxunecügu y̱ixü̃ne, rü ngẽma nixĩ i duü̃xü̃gü i Tupanaãrü orexü̃ ĩnüẽxü̃ rü yaxõgüxü̃ natürü ñoma i naãneãrü ngẽmaxü̃cèx oegaãẽgüxü̃, rü norü ngẽmaxü̃guama rüxĩnüẽxü̃ rü tama nüxü̃ rüxoechaü̃xü̃ i norü ngúchaü̃gü. Rü ngẽmagagu düxwa tama Tupanacèx namaxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","—Natürü guma trigu ga mexü̃ ga waixü̃mügu y̱ixü̃ne, rü ngẽma nixĩ i duü̃xü̃gü i aixcüma taãẽãcüma nayauxgüxü̃ i Tupanaãrü ore, rü naga ĩnüẽxü̃, rü meã naxcèx maxẽxü̃. Rü ngẽma nixĩ i duü̃xü̃gü i aixcüma Tupanawe rüxĩxü̃ rü naxügüxü̃ i ngẽma nüma nanaxwèxexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Taxúema wüxi i omüwa tanangixichi na tanatüxpechitaxü̃cèx rü ẽ́xna tümaãrü pechicatüü̃gu tayaxücuchixü̃cèx. Natürü ngóxü̃gu tanaxǘ na tüxü̃ nabaxixü̃cèx ya yíxema ngexma chocuxe. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","—Rü ngẽxgumarüü̃ ta i guxü̃ma i ṯacü i cúãcüma ixüxü̃ rü yixcüra rü duü̃xü̃gü tá nüxü̃ nacuèxgüama. Rü guxü̃ma i ngẽma ñu̱xma duü̃xü̃gücèx ẽxü̃guxü̃ rü tá nango̱xoma. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","—¡Meã iperüxĩnüẽ i ñu̱xmax! Erü texé ya naga ĩnüxẽ i ngẽma ore i mexü̃, rü Tupana tá yexeraãcü tüxü̃ nüxü̃ nacuèxẽẽ. Natürü yíxema tama naga ĩnüxẽ, rü yexeraãcü tá tüxna nanayaxu i ngẽma íraxü̃ i tümaãrü cuèx i noxri tüxü̃́ ngẽxmachiréxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Rü naẽ ga Ngechuchu rü naẽneẽgü, rü yema Ngechuchu íyexmaxü̃wa tangugü. Natürü taxuacü naxü̃tawaxüchi tangugü, yerü namuxũchi ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Rü wüxi ga duü̃xü̃ Ngechuchumaã nüxü̃ nixu, rü ñanagürü: —Yéa düxétüwa tangẽxma ya cue rü cueneẽgü, rü cuxü̃ tadaugüchaü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Natürü nüma ga Ngechuchu rü ñanagürü nüxü̃ ga duü̃xü̃gü: —Rü yíxema nüxü̃ ínü̃exe i Tupanaãrü ore rü nagu maxexe rü yíxema tixĩ ya chaue rü chaueneẽgü ixĩgüxe —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Rü wüxi ga ngunexü̃gu ga Ngechuchu rü norü ngúexü̃gümaã wüxi ga nguegu nichoü̃. Rü ñanagürü nüxü̃: —¡Ngĩxã daa naxtaxaarü tocutüwa taxĩ! —ñanagürü. Rü inaxĩãchi. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Rü yexguma yaxãü̃yane rü nipechigü ga Ngechuchu. Rü ngürüãchi yexma nüxü̃ naxü ga wüxi ga tacü ga buanecü. Rü guma nguewa rü niyauxcuchichigü ga dexá. Rü düxwa inayangutaü̃güchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Rü yemacèx nüma ga norü ngúexü̃gü rü Ngechuchuxü̃ nacagü ga na ínadaxü̃cèx. Rü ñanagürügü nüxü̃: —Pa Ngúexẽẽruü̃x, ngẽmama itabaxü̃gü —ñanagürügü. Rü yexguma ga Ngechuchu rü ínarüda, rü buanecüxü̃ rü yuapexü̃ nanga. Rü ínayachaxãchi ga buanecü, rü inayarüxo ga yuape, rü ínachaxanemare. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —¿Ṯacü pexü̃ naxüpetü ecèx tama meã peyaxõgüxü̃? —ñanagürü. Natürü ga nümagü rü naḇaixãchiãẽgü. Rü nügümücügüna nicachigü, rü ñanagürügü: —¿Ṯacü ẽ́xna nixĩ i ñaã yatü rü ngẽmacèx èi̱xrücü ya buanecü rü yuape rü naga naxĩnüẽxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Rü düxwa naxtaxaarü tocutüwa nangugü ga Gadáraarü naãnewa. Rü yema naane rü Gariréaaneãrü to̱xmèxtawa nayexma. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Rü yexguma marü nguewa ínaxüegu, ga Ngechuchu, rü naxcèx nixũ ga wüxi ga yatü ga guma ĩãnecü̱̃ã̱x ga mucü ga taunecü ngoxogü nawa yexmagücü. Rü guxü̃guma nangexchiruecha. Rü tama ĩwa nayexma, yerü duü̃xẽchíquẽ́xetanügu nayarüxauxchigünexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Rü yexguma Ngechuchuxü̃ nadèu̱xgu, rü napẽ́xegu nayacaxã́pü̱xü. Rü aita naxüãcüma ñanagürü: —¿Tü̱xcüü̃ nuã choxü̃ cuyachixewe, Pa Ngechuchux, Pa Tupana ya Tacüxüchi Nanex? Rü cuxü̃ chacèèxü̃ na tama ngúxü̃ choxü̃ quingexẽẽxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Rü yema ñanagürü yerü Ngechuchu marü nanamu ga yema ngoxogü na ínachoxü̃xü̃cèx. Rü muẽ̱xpü̱xcüna rü guma yatüxü̃ naxãũãẽxẽẽxü̃ ga yema ngoxogü. Rü duü̃xü̃gü rü cadenamaã nayanèĩ̱xchacüügüxü̃ rü nayanèĩ̱xparagüxü̃ na taxuwama naxũxü̃cèx. Natürü nüma rü nagu nacaugüama ga cadenagü. Rü yema ngoxogü rü dauxchitawa ga taxúema íxãpataxü̃wa nanagagü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Rü Ngechuchu nüxna naca rü ñanagürü: —¿Ṯacü nixĩ i cuéga? —ñanagürü. Rü nüma rü Ngechuchuxü̃ nangãxü̃, rü ñanagürü: —Muxũchixü̃ nixĩ i chauéga —ñanagürü. Rü yema ñanagürü yerü namuxũchi ga yema ngoxogü ga guma yatügu chocuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Rü yema ngoxogü rü Ngechuchuna nacagü ga tama ngẽma poxcuchica i ãxmaxü̃ i taguma iyacuáxü̃gu na nawocuãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Rü guma mèxpǘneãrü tuãchiwa nayexmagü ga muxü̃ma ga cuchigü ga yéma chibüexü̃. Rü yemacèx ga yema ngoxogü rü Ngechuchuxü̃ nacèèxü̃gü na yema cuchigügu nayachocuxü̃cèx. Rü Ngechuchu rü: —Ngü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Rü yexguma ga yema ngoxogü rü guma yatüwa ínachoxü̃ rü yema cuchigügu nayachocu. Rü guxü̃ma ga yema cuchigü rü inaxü̃ãchi, rü naxtaacutüarü mèxpǘxü̃wa nayarüyuxgü, rü yexma nayi. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Rü yexguma yema cuchigüarü dauruü̃gü nüxü̃ daugügu ga yema ngupetüxü̃, rü naḇaixãchiãẽgü rü ínibuxmü. Rü ĩãnewa nüxü̃ nayarüxugüe, rü yema ĩãneãrü ngaicamana ipeagüxü̃ ga duü̃xü̃gütanüwa rü ta nüxü̃ nayarüxugügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Rü ga duü̃xü̃gü rü ínayadaugü ga yema ngupetüxü̃. Rü yexguma Ngechuchuxü̃tawa nangugügu, rü yéma nüxü̃ nadaugü ga guma yatü ga ngoxoã̱xchirécü. Rü Ngechuchucutüxü̃tawa narüto, rü marü tama naxãũãẽ. Rü namuü̃ẽ ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Rü yema duü̃xü̃gü ga nüxü̃ daugüxü̃ ga yema ngupetüxü̃, rü yema íyadaugüxü̃maã nüxü̃ nixugügü ga ñuxãcü Ngechuchu na namexẽẽxü̃ ga guma yatü ga ngoxoã̱xchirécü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Rü yexguma yemaxü̃ naxĩnüẽgu, rü guxü̃ma ga yema Gadáraanecü̱̃ã̱x ga duü̃xü̃gü, rü Ngechuchuxü̃ nacèèxü̃gü na ínaxũxũxü̃cèx ga yema naãnewa, yerü poraãcü namuü̃ẽ. Rü yemacèx ga Ngechuchu rü nguegu nixüe, rü inaxũãchi. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Rü guma yatü ga ngoxoã̱xchirécü rü Ngechuchuxü̃ nacèèxü̃ ga nawe na naxũxü̃cèx. Natürü ga Ngechuchu rü nanamu ga yexma na naxã́ũxü̃cèx, rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—¡Cuchiü̃wa naxũ, rü duü̃xü̃gümaã nüxü̃ yarüxu ga ṯacü cuxcèx na naxüxü̃ ga Tupana! —ñanagürü. Rü ínixũ ga guma yatü, rü guxü̃ma ga yema ĩãnecü̱̃ã̱x ga duü̃xü̃gümaã nüxü̃ nayarüxu ga ṯacü naxcèx na naxüxü̃ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Rü yexguma Ngechuchu wenaxãrü taegugu ga naxtaxaarü tocutüwa, rü duü̃xü̃gü rü taãẽãcüma nanayauxgü, yerü guxü̃ma ínananguxẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Rü yéma Ngechuchuxü̃tawa nangu ga wüxi ga yatü ga Yáiru ga nae̱ga. Rü nüma ga Yáiru rü wüxi ga ngutaquẽ́xepataü̃ãrü ãẽ̱xgacü nixĩ. Rü Ngechuchupẽ́xegu nayacaxã́pü̱xü rü nüxü̃ nacèèxü̃ ga napatawa na naxũxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Yerü nüxü̃́ iyexma ga wüxi ga naxãcü ga ngĩgümaã wüxicacü, rü iyaḏaawe, rü ituraxüchi. Rü ngĩma rü maneca 12 ga taunecü ngĩxü̃́ nayexma. Rü yexguma Yáirupatawa naxũxgu ga Ngechuchu, rü muxũchixü̃ ga duü̃xü̃gü nawe narüxĩ, rü düxwa ínayaxũxtügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Rü yema duü̃xü̃gütanüwa iyexma ga wüxi ga ngecü ga 12 ga taunecü ãgüechacü. Rü yemamaã iyaḏaaweecha. Rü duturugüxü̃tagu ngĩxü̃ igu̱xẽẽ ga gu̱xcü ga ngĩrü dĩẽru, natürü taxúema ga texé ngĩxcèx tayataanexẽẽe̱ga. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Rü yema ngecü ga Ngechuchuweama ne ixü̃, rü naxpechinüchirugu iyangõgü. Rü yexgumatama ínayachaxãchi ga na naxãgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Rü yexguma ga Ngechuchu rü duü̃xü̃güna naca, rü ñanagürü: —¿Texé tixĩ ya choxü̃ ingõgüxe? —ñanagürü. Rü guxü̃ma ga duü̃xü̃gü rü: —Taxúema —ñanagürügü. Rü yexguma ga Pedru rü namücügü rü ñanagürügü: —Pa Ngúexẽẽruü̃x, cuma nüxü̃ cudau i ñuxre i duü̃xü̃gü nge̱ma cuxü̃ na nayaxũxtügüxü̃, rü ngẽxguma rü ta: “¿Texé ya choxü̃ ingõgüxe?” ñacuxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Natürü ga Ngechuchu rü ñanagürü: —Ngẽmáãcü wüxie choxü̃ tingõgü, erü nüxü̃ chicuèxãchi na chorü poramaã tüxü̃ na charümexẽẽxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Rü yexguma nango̱xomagu ga na nüxü̃ nacuèxamaxü̃ ga Ngechuchu ga yema nüxü̃ na yangõgüxü̃, rü yadu̱ru̱xãcüma naxü̃tawa ixũ ga yema ngecü. Rü napẽ́xegu iyacaxã́pü̱xü. Rü guxü̃ ga duü̃xü̃güpẽ́xewa namaã nüxü̃ iyaxu ga ṯacücèx nüxü̃ na yangõgüxü̃, rü ñuxãcü yexgumatama ngĩxcèx na yataanexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Rü yexguma ga Ngechuchu rü ñanagürü ngĩxü̃: —Pa Chauxacüx, cuxcèx nitaane, erü cuyaxõ. ¡Rü ñu̱xma rü taãẽãcüma íixũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Rü yexguma íyadexayane ga Ngechuchu, rü yéma nangu ga wüxi ga duü̃xü̃ ga ngutaquẽ́xepataü̃ãrü ãẽ̱xgacü ga Yáirupatawa ne ũxü̃. Rü ñanagürü Yáiruxü̃: —Cuxacü rü marü iyu. ¡Rü tãxṹ i cuyachixewechigüxü̃ ya Ngúexẽẽruü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Natürü yexguma yema orexü̃ naxĩnügu ga Ngechuchu, rü ñanagürü Yáiruxü̃: —¡Tãxṹ i cuyanguãẽxü̃! Erü ngẽxguma cuyaxõ̱xgu rü cuxacü rü tá wena imaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Rü yexguma Yáirupatawa nangugügu, rü Ngechuchu nayachocuxẽẽ ga Pedru rü Chaü̃tiágu rü Cuáü̃ rü ngĩnatü rü ngĩẽ ga yema bucü ga yu̱xcü. Natürü tama nanaxwèxe na togü yexma chocuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Rü guxü̃ma ga duü̃xü̃gü ga yéma yexmagüxü̃ rü naxauxe rü ngĩxcèx nangechaü̃gü. Natürü Ngechuchu rü ñanagürü nüxü̃: —¡Tãxṹ i pexauxexü̃! Erü ngẽma bucü rü tama nixĩ i nayuxü̃. Rü ipemare —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Natürü ga yema duü̃xü̃gü rü Ngechuchuxü̃ nacugüeama, yerü ngĩxü̃ nadaugü rü aixcüma marü iyu. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Rü yexguma ga Ngechuchu rü ngĩxmẽ́xgu nayayauxãchi, rü tagaãcü ñanagürü: —Pa Bucüx, ¡írüda! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Rü yexguma ga ngĩma rü wena imaxü̃, rü yexgumatama íirüda. Rü Ngechuchu rü duü̃xü̃gümaã nüxü̃ nixu na ngĩxü̃ naxüwemügüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Rü ngĩnatü rü ngĩẽ ga yema bucü, rü poraãcü taḇaixãchiãẽgü. Natürü Ngechuchu rü tüxü̃ namu na taxúemaãma nüxü̃ na tixuxü̃cèx ga yema ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Rü Ngechuchu rü nanangutaquẽ́xexẽẽ ga yema 12 ga norü ngúexü̃gü. Rü pora nüxna naxã rü nüxna naxãga na ínawoxü̃ãxü̃cèx ga nagúxü̃raü̃xü̃ ga ngoxogü, rü na nameẽxẽẽãxü̃cèx ga duü̃xü̃gü ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Rü nayamugü na duü̃xü̃gümaã nüxü̃ yaxugüexü̃cèx ga ore ga mexü̃ na ñuxãcü ãẽ̱xgacü yiĩxü̃ ya Tupana, rü na nameẽxẽẽãxü̃cèx ga duü̃xü̃gü ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Rü ñanagürü nüxü̃: —¡Rü taxuxü̃táma ípinge i perü namawaü̃, rü bai ya perü caxü̃chigüxü̃ ya naĩxmenèxã, rü bai i perü choca, rü bai i perü pãũ, rü bai i perü dĩẽru. Rü wüxitama i perü daxũ ípinge, rü tama i taxre! ");
INSERT INTO tcaNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","—Rü ngẽxguma wüxi ya ĩãnewa pengugügu, ¡rü wüxi ya ĩpatagutama perücho rü ñu̱xmata ipexĩãchi nawa ya yima ĩãne! ");
INSERT INTO tcaNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","—Rü ngextá tama pexü̃ ínayauxgüxü̃wa, ¡rü ípechoxü̃ nawa ya yima ĩãne! Rü ngẽxguma nge̱ma ipexĩãchigu ¡rü ipepagücutü i perü üxaxü̃cutü na ngẽmawa nüxü̃ nacuèxgüxü̃cèx na chixexü̃ naxügüxü̃ i ngẽma duü̃xü̃gü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Rü inaxĩãchi, rü guxü̃ma ga ĩãnexãcügüwa naxĩ. Rü nüxü̃ nixugüetanü ga Tupanaãrü ore ga mexü̃. Rü guxü̃wama nanameẽxẽẽtanü ga duü̃xü̃gü ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Rü Gariréaaneãrü ãẽ̱xgacü ga Erode, rü nüxü̃ nacuáchiga ga guxü̃ma ga yema Ngechuchu üxü̃. Rü poraãcü nagu narüxĩnü rü naxoegaãẽ ga Erode, yerü nümaxü̃ ga duü̃xü̃gü rü ñanagürügü: —Cuáü̃ ya baiü̃xẽẽruü̃ nixĩ ya yima, rü marü wena namaxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Natürü togü rü ñanagürügü: —Nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ería nixĩ, rü wena nango̱x —ñanagürügü. Rü togü rü ñanagürügü: —Bexmana náĩ ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ nixĩ, rü wena namaxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Natürü Erode rü ñanagürü: —Chomatama chanamu ga churaragü na Cuáü̃xü̃ yadaenaxãgüxü̃cèx. ¿Rü ṯacü ẽ́xna nixĩ i ngẽma yatü i duü̃xü̃gü ngẽmaãcü poraãcü nüxü̃ ixuchigagüechaxü̃? —ñanagürü. Rü Erode rü nüxü̃́ nangúchxü̃xü̃chi na ñuxãcü Ngechuchuxü̃ na nadauxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Rü yexguma nawoeguxgu ga yema Ngechuchuarü ngúexü̃gü ga yamugüxü̃, rü Ngechuchumaã nüxü̃ nixugüe ga yema naxügüxü̃. Rü nüma ga Ngechuchu rü yema norü ngúexü̃gümaã nixũgachi, rü Bechaídaarü ĩãnewa namaã naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Natürü yexguma duü̃xü̃gü nüxü̃ cuèxgügu ga ngextá na nayexmaxü̃, rü Ngechuchuwe narüxĩ. Rü Ngechuchu rü meãma yema duü̃xü̃güxü̃ nayaxu, rü namaã nüxü̃ nixu na ñuxãcü ãẽ̱xgacü yiĩxü̃ ya Tupana. Rü nanameẽxẽẽ ga yema duü̃xü̃gü ga iḏaaweexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Rü yexguma marü nayáuanegu, rü Ngechuchucèx naxĩ ga yema 12 ga ngúexü̃gü ga yamugüxü̃. Rü ñanagürügü nüxü̃: —¡Íyamugü i ñaã duü̃xü̃gü na ĩãnexãcügü rü ĩpatagü ya ngaicamana ngẽxmagünewa na naxĩxü̃cèx, rü ngẽxma na napegüxü̃cèx rü norü õnatèèx yataxegüxü̃cèx! Erü nuã íingẽxmagüxü̃wa rü nataxuma i ṯacü rü õna —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Natürü Ngechuchu rü ñanagürü nüxü̃: —¡Pematama penaxüwemü! —ñanagürü. Rü nanangãxü̃gü, rü ñanagürügü: —Wüximẽ́ẽ̱xpü̱x i pãũ rü taxre i choxnixĩcatama toxü̃́ nangẽxma. ¿Rü ẽ́xna cunaxwèxe na naxcèx tayataxegüxü̃ i õna naxcèx i guxü̃ma i ñaã duü̃xü̃gü? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Rü 5000 ga yatügü nixĩ ga yema yéma yexmagüxü̃. Natürü Ngechuchu rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —¡Ẽcü ípenatogüxẽẽ̱x rü 50 chigü i wüxi tücumüwachigü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Rü yemaãcü nanaxügü ga norü ngúexü̃gü. Rü ínanatogüxẽẽ ga guxü̃ma ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Rü yexguma ga Ngechuchu rü nanade ga yema wüximẽ́ẽ̱xpü̱x ga pãũ rü yema taxre ga choxni. Rü daxũgu nadawenüãcüma Tupanana moxẽ naxã, rü ñu̱xũchi inanabücu ga yema pãũ rü choxni. Rü norü ngúexü̃güna nanaxã na nüxü̃ yanuãxü̃cèx ga yema duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Rü guxü̃ma ga yema duü̃xü̃gü rü meãma nachibüe. Rü yemawena rü 12 ga pexchigü nanapagüamatama namaã ga yema pãũ rü choxnichipẽ́xegü ga iyaxügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Rü wüxi ga ngunexü̃ rü Ngechuchu norü ngúexü̃gümaã noxrüwama yayumüxẽgu, rü nüma rü norü ngúexü̃güna naca, rü ñanagürü: —¿Ñuxũ ñaxü̃ i duü̃xü̃gü i chauchiga i choma na texé chiĩxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rü norü ngúexü̃gü nanangãxü̃gü rü ñanagürügü: —Nangẽxma i duü̃xü̃gü rü: “Cuáü̃ ya baiü̃xẽẽruü̃ quixĩ”, ñagüxü̃, rü togü rü: “Ería quixĩ”, ñagüxü̃, rü togü rü: “Wüxi ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ i wena maxü̃cü quixĩ”, ñagüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Rü yexguma Ngechuchu nüxna naca rü ñanagürü: —¿Rü pema i ñuxũ ñapegüxü̃ choxü̃ na texé chiĩxü̃? —ñanagürü. Rü Pedru nanangãxü̃ rü ñanagürü: —Cuma nixĩ i Cristu i Tupana Nane —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Rü Ngechuchu rü nayaxucu̱xẽgü ga norü ngúexü̃gü na taxúemaãma nüxü̃ yaxugüexü̃cèx ga nüma rü Cristu na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü poraãcü ngúxü̃ tá chinge. Rü choxü̃ tá naxoo̱xgü i Yudíugüarü ãẽ̱xgacügüerugü, rü paigüarü ãẽ̱xgacügü, rü ngẽma ngúexẽẽruü̃gü i Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃. Rü tá choxü̃ nimèxgü, natürü tomaẽ̱xpü̱x i ngunexü̃gu rü wena táxarü chamaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Rü yixcama rü guxü̃ma ga norü ngúexü̃güxü̃ ñanagürü: —Rü ngẽxguma texé chowe rüxũxchaü̃gu, ¡ẽcü nüxü̃ tarüxo i tümaãrü ngúchaü̃, rü namaã tapora i ngẽma guxchaxü̃gü i tümacèx ínguxü̃ i ñoma curuchawa tipotaxü̃rüü̃ tüxü̃ ixĩxẽẽxü̃, rü ngẽmae̱tüwa chowe tarüxũãma! ");
INSERT INTO tcaNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","—Erü yíxema tügü maxẽchaxẽẽchaü̃xẽ rü tá tayu, natürü yíxema chauxcèx yuxe rü aixcüma tá tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Rü ṯacüwa i nüxü̃́ namexü̃ ya wüxi ya yatü ega nayauxãgu i guxü̃ma i ñoma i naãneãrü ngẽmaxü̃gü, natürü iyanatauxẽẽãgu i norü maxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","—Rü ngẽxguma texé chauxcèx ãnegu rü naxcèx taxãnegu i chorü ore, rü choma i Tupana Nane i duü̃xü̃xü̃ na chiĩxü̃ rü tá ta tümacèx chaxãne i ngẽxguma ãẽ̱xgacü chixĩãcüma núma chaxũxgu. Rü ngẽxguma wenaxãrü núma chaxũxgu rü Chaunatü ya Tupanarüü̃ tá chapora, rü daxũcü̱̃ã̱x i Tupanaãrü orearü ngeruü̃gü i üünegüxü̃rüü̃ tá chamexẽchi. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","—Rü aixcüma pemaã nüxü̃ chixu rü ñuxre i duü̃xü̃gü i nuã ngẽxmagüxü̃ rü tá nüxü̃ nadaugü na ñuxãcü ãẽ̱xgacü na yiĩxü̃ ya Tupana naxü̃pa na nayuexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Rü 8 ga ngunexü̃guwena ga na yema ñaxü̃, rü Ngechuchu rü wüxi ga mèxpǘnewa naxũ na yéma yayumüxẽxü̃cèx. Rü ínayaxümücügü ga Pedru rü Chaü̃tiágu rü Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Rü yexguma ínayumüxẽyane ga Ngechuchu rü nachiwe rü ngürüãchi niy̱auracüü, rü naxchiru rü ta niy̱auracüü, rü poraãcüxüchima nacómü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Rü yexguma rü yéma nango̱x ga taxre ga yatügü ga Ngechuchumaã idexagüxü̃. Rü Moĩché nixĩ ga wüxi, rü Ería nixĩ ga to. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Rü yema taxre íyexmagüxü̃wa rü poraãcüxüchi nangóone. Rü ínidexagü nachiga ga ñuxãcü Yerucharéü̃gu tá na nayuxü̃ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Rü woo ga Pedru rü namücügü rü poraãcü na nayaxtaexü̃ rü tama napee. Rü nüxü̃ nadaugü ga ñuxãcü poraãcü na nangóonexü̃ ga naxü̃tawa ga Ngechuchu rü yema taxre ga yatügü ga namaã yexmagüxü̃xü̃tawa. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Rü yexguma yema taxre ga yatügü Ngechuchuna ixĩgachitanügu, rü Pedru rü ñanagürü Ngechuchuxü̃: —Pa Ngúexẽẽruü̃x, namexẽchi nixĩ na nuã ingẽxmagüxü̃. ¡Rü ngĩxã tanaxü ya tomaẽ̱xpü̱x ya düxenü, rü wüxi ya cuxcèx, rü náĩ ya Moĩchécèx, rü náĩ ya Eríacèx! —ñanagürü. Natürü ga Pedru rü tama nüxü̃ nacuèx ga na ñuxũ ñaxü̃ yerü poraãcü naḇaixãchiãẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Rü yexguma íyadexayane ga Pedru, rü wüxi ga caixanexü̃ natanügu nayangèi̱xema. Rü poraãcü namuü̃ẽ ga yema ngúexü̃gü ga yexguma yema caixanexü̃ natanügu yangèi̱xemagu. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Rü yema caixanexü̃wa inanaxũ ga wüxi ga naga ga ñaxü̃: —Daa nixĩ ya Chaune ya nüxü̃ changechaü̃xü̃chicü. ¡Rü naga pexĩnüẽ! —ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Rü yexguma yema ñaxguwena ga yema naga rü Ngechuchuarü ngúexü̃gü rü taxúexü̃ma ga toguexü̃ nadaugü, rü Ngechuchuxü̃xĩcatama nadaugü. Rü yema ngúexü̃gü rü taxúemaãma nüxü̃ nixugüe ga yema nüxü̃ nadaugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Rü yexguma moxü̃ãcü ga guma mèxpǘnewa yanachoü̃gu, rü muxü̃ma ga duü̃xü̃gü yexma Ngechuchuxü̃ nayangaugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","39","Rü yema duü̃xü̃gütanüwa rü wüxi ga yatü tagaãcü Ngechuchuxü̃ ñanagürü: —Pa Ngúexẽẽruü̃x, ¡choxü̃ rüngü̃xẽẽ, rü tüxü̃ nadau ya chaune! Erü tügümaã choxü̃́ tawüxicèx, rü wüxi i ngoxo tümawa nangẽxma. Rü ngẽxguma tüxü̃ naxüxgu, rü aita tüxü̃ naxüxẽẽ, rü tüxü̃ naxãũãẽxẽẽ, rü tüxü̃ narüchièxẽẽ. Rü chixexü̃ tümamaã naxü, rü tama tüxü̃ ningéxchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Rü marü nüxü̃ chacèèxü̃ i curü ngúexü̃gü na tümawa ínatèxüchigüãxü̃cèx i ngẽma ngoxo, natürü tama nüxü̃́ inaxĩnü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Rü yexguma Ngechuchu nanangãxü̃, rü ñanagürü: —Pa Duü̃xü̃gü i Tama Yaxõgüxü̃x, ¿Ñuxguratáta i pemaã chanuxmaxü̃ rü yaxna pemaã cha xĩ-nüxü̃? ¡Nuã naga ya cune! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Natürü yexguma Ngechuchuxü̃tawa nanguxgu ga guma bucü, rü yema ngoxo rü guma bucüxü̃ ñaxtüanegu nayanguxẽẽ, rü nanaxãũãẽxẽẽ. Natürü Ngechuchu nananga ga yema ngoxo, rü nanamexẽẽ ga guma bucü. Rü ñu̱xũchi nanatüxü̃tawa nanamu. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Rü guxü̃ma ga duü̃xü̃gü rü naḇaixãchiãẽgü ga yexguma nüxü̃ nadaugügu ga ñuxãcü na naporaxü̃ ya Tupana. Rü yexguma duü̃xü̃gü namaã ḇaixãchieyane ga yema Ngechuchu üxü̃, rü ñanagürü ga Ngechuchu nüxü̃ ga norü ngúexü̃gü: ");
INSERT INTO tcaNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—¡Meã iperüxĩnüẽ i ñaã ore i pemaã nüxü̃ chixuxü̃! ¡Rü tãũtáma nüxü̃ ipeyarüngümaẽ! Choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü chauechita tá choxü̃ ínaxuaxü̃gü i duü̃xü̃gü na ãẽ̱xgacügü choxü̃ iyauxgüxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Natürü ga norü ngúexü̃gü rü tama nüxü̃ nacuèxgüéga ga yema namaã nüxü̃ yaxuxü̃. Yerü Tupana rü tama naxcèx nanango̱xẽẽ ga yema ore na nüxü̃ nacuèxgüxü̃cèx. Rü yema ngúexü̃gü rü namuü̃ẽ ga Ngechuchuna na nacagüxü̃ na meã namaã nango̱xẽẽãxü̃cèx ga yema namaã nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Rü yexguma ga norü ngúexü̃gü rü inanaxügüe ga nügümaã na yaporagatanücüüxü̃ nachiga ga texé tá tiĩxü̃ ya natanüwa guxããrü yexera ixĩxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Natürü Ngechuchu rü nüxü̃ nacuèxama ga yema norü ngúexü̃gü nagu rüxĩnüẽxü̃. Rü yemacèx wüxi ga buxü̃ nügüxü̃tawa naga, rü nügüxü̃tagu nayachixẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Texé ya ñaã buxü̃xü̃ meã yaxúxe chauégagu, rü choxü̃ nixĩ i tayaxuxü̃. Rü yíxema meã choxü̃ yaxúxe, rü Chaunatü ya núma choxü̃ mucüxü̃ rü ta meã tayaxu. Rü yíxema guxããrü yexera tügü írüxíraxe, rü yíxema tixĩ ya guxããrü yexera ixĩxẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Rü yexguma ga Cuáü̃ rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃x, nüxü̃ tadau ga wüxi ga yatü ga cuégagu ngoxogü íwoxü̃xü̃. Rü toma nüxna tanachu̱xu ga yema yerü tama tatanüxü̃ nixĩ ga nümax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Natürü Ngechuchu rü ñanagürü nüxü̃: —Tama name i nüxna na penachu̱xuxü̃. Erü texé ya tama taxchi aixe, rü tórü ngü̃xẽẽruü̃ tixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Rü yexguma marü yangaicagu ga Ngechuchu ga daxũguxü̃ ga naãnewa na naxũxü̃, rü tama namuü̃ãcüma inaxũãchi ga Yerucharéü̃wa na naxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Rü nügüpẽ́xegu nayamugü ga ñuxre ga norü orearü ngeruü̃gü. Rü nümagü rü nawa naxĩ ga wüxi ga ĩãnexãcü ga Chamáriaanewa yexmane, na yexma naxcèx yadaugüxü̃cèx ga wüxi ga ĩ na Ngechuchu nagu pexü̃nexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Natürü yema Chamáriaanecü̱̃ã̱x rü tama nanayauxgüchaü̃, yerü nüxü̃ nacuèxgü ga Yerucharéü̃wa tá na naxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Rü yexguma yemaxü̃ nadaugügu ga norü ngúexü̃gü ga Chaü̃tiágu rü Cuáü̃, rü ñanagürügü Ngechuchuxü̃: —Pa Corix, ¿cunaxwèxexü̃ na Tupanana naxcèx tacaxü̃ na daxũwa ne namuãxü̃cèx ya üxü na nagu̱xẽẽãxü̃cèx i guxü̃ma i ñaã duü̃xü̃gü, yema nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ería üxü̃rüü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Rü yexguma ga Ngechuchu rü nüxü̃ nadawenü, rü nayangagü, rü ñanagürü nüxü̃: —Pema rü tama nagu perüxĩnüẽ na texéarü duü̃xü̃gü pixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","—Erü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü tama duü̃xü̃güarü tauxexẽẽwa núma chaxũ, natürü núma chaxũ na duü̃xü̃güxü̃ chamaxẽxẽẽxü̃cèx —ñanagürü. Rü yexguma rü náĩ ga ĩãnexãcüwa naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Rü yexguma namagu naxĩxgu rü wüxi ga yatü Ngechuchuxü̃ ñanagürü: —Pa Corix, cuwe charüxũxchaü̃ i ngextá cuma ícuxũxü̃wa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Ngowagü rü nüxü̃́ nangẽxma i naxmaxü̃gü, rü werigü rü nüxü̃́ nangẽxma i naxchiãü̃gü, natürü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü nataxuma i chauchica i ngextá nagu chicuxeruxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Rü Ngechuchu ñanagürü nüxü̃ ga wüxi ga to ga yatü: —¡Chowe rüxũ! —ñanagürü. Natürü nüma ga yema yatü rü ñanagürü nüxü̃: —Pa Corix, noxri chanawèxe i chaunatüxü̃ ichayatèxira —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Nüe̱ ngẽma cutanüxü̃ i tama yaxõgüxü̃ iyatèxgü i ngẽma naxrüü̃ yuexü̃, natürü cuma rü curü puracü nixĩ na paxa duü̃xü̃gümaã nüxü̃ cuyarüxuxü̃ i Tupanaãrü ore na ñuxãcü guxããrü ãẽ̱xgacü na yiĩxü̃ i nümax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Rü wüxi ga to ga duü̃xü̃ rü ñanagürü Ngechuchuxü̃: —Pa Corix, ngẽmáãcü cuwe charüxũxchaü̃, natürü noxri chanaxwèxe i nüxü̃ chayarümoxẽ i ngẽma chopatacü̱̃ã̱xgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Natürü Ngechuchu rü ñanagürü nüxü̃: —Texé ya yíxema inaxügüxe na Tupanaãrü puracüwa tapuracüxü̃ natürü tümaãrü ngẽmaxü̃guama rüxĩnüxẽ, rü tama tame na Tupanaãxü̃́ tapuracüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Rü yemawena ga Cori ga Ngechuchu rü nayadexechi ga 72 ga to ga norü ngúexü̃gü. Rü taxrechigü inayamugü na yoxni guxü̃ ga yema ĩãnegü rü nachicagü ga Ngechuchu nawa ũxchaü̃xü̃wa na naxĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Rü ñanagürü nüxü̃: —Aixcümaxü̃chi nangẽxma i muxũchixü̃ i duü̃xü̃gü i yaxõgüchaü̃xü̃ natürü ngema Tupanaarü orearü uwa puracüexü̃ rü noxretama nixĩ. Rü ngẽmacèx name i perü yumü̃xẽwa nüxna peca ya yima puracüarü yora na ngema norü puracüwa namugüãxü̃cèx i to i puracütanüxü̃.. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","—¡Rü ipexĩãchi rü nge̱ma pexĩ! Rü dücax, ñoma carnerugü i aigütanüwa imugüxü̃rüü̃ nixĩ i pexü̃ chimugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","—¡Rü tãũtáma choca ípinge, rü bai i perü dĩẽru, rü bai i perü chapatu! Rü tama chanaxwèxe i namagu penuxcü i ngẽxguma namawa texéxü̃ perümoxẽgügu. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","—Rü ngẽxguma wüxi ya ĩwa pengugügu, rü ñaããcü tá nüxü̃ perümoxẽgü i ngẽma duü̃xü̃gü: “¡Petaãxẽ erü Tupana rü napetanügu!”, ñaperügügü tá. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","—Rü ngẽxguma nge̱ma nangẽxmagu i duü̃xü̃gü i Tupanaxü̃ cuèxgüchaü̃xü̃ rü Tupana rü tá nüxna nanaxã i taãxẽ. Natürü ngẽxguma nge̱ma nataxu̱xgu i duü̃xü̃gü i Tupanaxü̃ cuèxgüchaü̃xü̃, rü ngema Tupanaarü taãxẽ rü pexrütáma nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","—¡Rü wüxi ya ĩgutama perücho, rü nge̱ma pechibüe rü peyaxü i ngẽma nüxü̃́ ngẽxmaxü̃ i ngẽma ĩcü̱̃ã̱xgü! Erü wüxi i puracütanüxü̃ rü name nixĩ na nayauxãxü̃ i norü natanü naxcèx i norü puracü. Rü yima ĩãnewa pengẽxmagüyane rü tama chanaxwèxe i náĩ ya ĩgu peyapegü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","—Rü ngẽxguma wüxi ya ĩãne ya nawa meã pexü̃ nayaxunewa pengugügu, ¡rü penangṍ i ngẽma õna i pexna naxãgüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","—¡Rü penameẽxẽẽ̱x i ngẽma iḏaaweexü̃ i yima ĩãnewa ngẽxmagüxü̃! ¡Rü namaã nüxü̃ pixu rü ñapegügü nüxü̃: “Tupanaãrü pora rü marü pexna nangaicama rü napexü̃tagu”, ñapegügü nüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","—Natürü ega nawa pengugügu ya wüxi ya ĩãne i ngextá duü̃xü̃gü tama meã pexü̃ íyauxgüxü̃wa, ¡rü ngẽma ítamü̃gu ípechoxü̃ rü ñapegügü nüxü̃ i ngẽma ĩãnecü̱̃ã̱x!: ");
INSERT INTO tcaNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Rü woo ñaã perü ĩãneãrü üxaxü̃ i tocutüwa yaxṹxü̃, rü itanapagü, na ngẽmawa nüxü̃ pecuáxü̃cèx na Tupana rü tama pemaã nataãẽxü̃. ¡Natürü tama nüxü̃ ipeyarüngümaẽ na marü pexna nangaicamaxü̃chichiréxü̃ ya Tupana na perü ãẽ̱xgacü yiĩxü̃”, ñaperügügü tá nüxü̃ i ngẽma ĩãnecü̱̃ã̱x! ");
INSERT INTO tcaNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","—Rü pemaã nüxü̃ chixu rü ngẽma ngunexü̃ i nagu nagúxü̃ i naãne, rü Chodomacü̱̃ã̱x i duü̃xü̃güarü yexera Tupana tá nanapoxcue i ngẽma duü̃xü̃gü i tama meã pexü̃ yauxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—Rü wüxi i ngechaü̃ nixĩ i pexcèx, Pa Corachĩ́cü̱̃ã̱x rü Bechaídacü̱̃ã̱x i Duü̃xü̃güx, yerü yexguma chi Tiruarü ĩãnewa rü Chidã́ũãrü ĩãnewa chanaxü̱xgu ga yema mexü̃gü ga cuèxruü̃gü ga Tupanaãrü poramaã petanüwa chaxüxü̃, rü woo ga na poraãcü yachixexü̃ ga yema Tirucü̱̃ã̱x rü Chidã́ũcü̱̃ã̱x ga duü̃xü̃gü rü nuxcümama chitama nüxü̃ narüxoe ga nacüma ga chixexü̃, rü poraãcüxüchi chima nügümaã nangechaü̃gü rü naxauxe, yerü chi nügü nicuèxãchitanü ga na yapecaduã̱xgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","—Natürü pemaã nüxü̃ chixu rü ngẽma ngunexü̃ i Tupana nagu napoxcuexü̃ i pecaduã̱xgüxü̃, rü ngẽma ngunexü̃gu rü Tirucü̱̃ã̱x rü Chidã́ũcü̱̃ã̱xãrü yexera tá pexü̃ napoxcue i pemax. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","—Rü pemax, Pa Capernáũcü̱̃ã̱xgü i Duü̃xü̃güx ¿ẽ́xna pema nagu perüxĩnüẽgu rü daxũguxü̃ i naãnewa tá pexĩxü̃? Pemaã nüxü̃ chixu rü naãnetüü̃wa i ngextá Tupana Chatanáxü̃ ípoxcuxü̃wa tá nixĩ i pewogüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Rü ñu̱xũchi norü ngúexü̃güxü̃ ñanagürü: —Rü yíxema pega ĩnüẽxẽ, rü chauga rü ta taxĩnüẽ. Natürü yíxema tama pega ĩnüẽxẽ, rü chauga rü ta tama taxĩnüẽ. Rü yíxema tama chauga ĩnüẽxẽ, rü tama naga taxĩnüẽ ya Chaunatü ya núma choxü̃ mucü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Rü taãẽãcüma nawoegu ga yema 72 ga norü ngúexü̃gü ga yamugüxü̃. Rü ñanagürügü nüxü̃: —Pa Corix, ngẽxguma cuégagu tidexagügu, rü èi̱xrüxü̃ i ngoxogü rü toga naxĩnüẽ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Rü Ngechuchu rü ñanagürü nüxü̃: —Ngẽmáãcü aixcüma nixĩ. Yerü nüxü̃ chadau ga Chataná ga daxũguxü̃ ga naãnewa na natáexü̃ wüxi ga ãẽmacürüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","—Rü choma nixĩ ga pexna chanaxãxü̃ ga pora na tama chixexü̃ pemaã naxügüxü̃cèx ega woo ãxtapegüwa rü ẽ́xna tuxchinawegüwa pengagügu. Rü yexgumarüü̃ ta pexna chanaxã ga pora na nüxü̃ perü- yexeraxü̃cèx i guxü̃ma i Chatanáãrü pora na ngẽmaãcü taxucürüwama ṯacü rü chixexü̃ pemaã naxüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","—¡Natürü tãxṹ i petaãẽgüxü̃ naxcèx i ngẽma na pega naxĩnüẽxü̃ i ngoxogü! Rü narümemaẽ nixĩ i petaãẽgü naxcèx na marü naxümatüxü̃ i peéga i Tupanaãrü poperawa i daxũguxü̃ i naãnewa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Rü yexgumatama ga Tupanaãẽ ga Üünexü̃ rü poraãcü Ngechuchuxü̃ nataãẽxẽẽ. Rü ñanagürü ga Ngechuchu: —Pa Chaunatü, Pa Daxũguxü̃ i Naãne rü Ñoma i Naãneãrü Yorax, cuxü̃ chicuèxüü̃, yerü ñaã chorü ngúexü̃güxü̃ nüxü̃ cucuèxẽẽ i ñaã ore ga naxchaxwa iquicúxü̃ ga duü̃xü̃gü i ñoma i naãnewa nüxü̃ cuèxüchigüxü̃. Rü yemaãcü cunaxü, Pa Chaunatüx yerü yemaãcü nixĩ ga cunaxwèxexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Rü ñanagürü ga Ngechuchu: —Chaunatü choxna nanaxã i guxü̃ma i ṯacü i ngẽxmaxü̃. Rü taxúema choxü̃ tacuèx na Tupana Nane chiĩxü̃. Rü Chaunatüxicatama nixĩ ya choxü̃ cuácü na Nane chiĩxü̃. Rü ngẽxgumarüü̃ ta taxúema nüxü̃ tacuèx na texe yiĩxü̃ ya Chaunatü. Rü choma ya Nane rü ngẽma duü̃xü̃gü i Chaunatüxü̃ nüxü̃ chadauxẽẽchaü̃xü̃xĩcatama nixĩ i nüxü̃ cuèxgüxü̃ na texe yiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Rü yexguma norü ngúexü̃güxü̃ nadawenü, rü namaãxĩca ñanagürü: —Tataãẽgü ya yíxema tümaxẽtümaãxü̃chi nüxü̃ daugüxe i ñaã ñu̱xma pema nüxü̃ pedaugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","—Erü pemaã nüxü̃ chixu, rü muxü̃ma ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü rü ãẽ̱xgacügü ga tacügü, rü nüxü̃́ nangúchaü̃ ga nüxü̃ na nadaugüchaü̃xü̃ i ñaã ñu̱xma pema chauxü̃tawa nüxü̃ pedaugüxü̃. Natürü tama nüxü̃ nadaugü. Rü nüxü̃́ nangúchaü̃ ga nüxü̃ na naxĩnüẽchaü̃xü̃ i ñaã ñu̱xma pema chauxü̃tawa nüxü̃ pexĩnüẽxü̃. Natürü tama nüxü̃ naxĩnüẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Rü yexguma inachi ga wüxi ga ngúexẽẽruü̃ ga Moĩchéarü mugüwa ngu̱xẽẽtaexü̃, rü Ngechuchuxü̃tawa naxũ na namaã yanadexaxü̃cèx. Rü Ngechuchuxü̃ naxüxchaü̃, rü yemacèx nüxna naca rü ñanagürü: —Pa Ngúexẽẽruü̃ ya Ngechuchux, ¿Ṯacü nixĩ i mexü̃ na chanaxüxü̃ na choxü̃́ nangẽxmaxü̃cèx i maxü̃ i taguma gúxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —¿Ñuxũ ñaxü̃ i ngẽma ore i Moĩchéarü mugüwa ümatüxü̃? ¿Rü ṯacüxü̃ i cumaã yaxuxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Rü yema ngúexẽẽruü̃ ga Moĩchéarü mugüwa ngu̱xẽẽtaexü̃, rü Ngechuchuxü̃ nangãxü̃, rü ñanagürü: —¡Nüxü̃ nangechaü̃ ya Cori ya curü Tupana i guxü̃ma i curü maxü̃maã, rü guxü̃ i cuãẽmaã, rü guxü̃ i curü poramaã, rü guxü̃ i nagu curüxĩnüxü̃maã! ¡Rü nüxü̃ nangechaü̃ i cumücü ngẽma na cugütama cungechaü̃xü̃rüü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Ngẽma ore i choxü̃ namaã cungãxü̃xü̃ rü marü name. Rü ngẽxguma ngẽma ore quinguxẽẽ̱xgu, rü tá cunayaxu i maxü̃ i taguma gúxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Natürü ga yema ngúexẽẽruü̃ ga Moĩchéarü mugüwa ngu̱xẽẽtaexü̃, rü nügüétüwa nachogüchaü̃. Rü yemacèx Ngechuchuna naca, rü ñanagürü: —¿Rü texé tixĩ ya chomücü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Rü yexguma ga Ngechuchu rü nanangãxü̃, rü ñanagürü nüxü̃: —Wüxi ga yatü Yerucharéü̃wa ne naxũ, rü Yericú ga ĩãnewa naxũ. Rü namagu nüxü̃ nangaugü ga ngĩ́tèèxgüxü̃. Rü guxü̃ma ga norü yemaxü̃cèx nangĩ̱xgü, rü èi̱xrüxü̃ ga naxchiru rü ta naxcèx nangĩ̱xgü. Rü nanac̱uaixgü, rü nayayuãchixẽẽgü, rü yemaãcü yéma nanatèxgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","—Rü yematama namawa naxüpetü ga wüxi ga Yudíugüarü pai. Natürü yexguma yema yatüxü̃ nadèu̱xgu rü nüxü̃ yéma naxüpetümare. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","—Rü yéma naxüpetü ta ga wüxi ga Lebítanüxü̃ ga tupauca ga taxü̃newa puracüxü̃. Rü yexguma yema yatüxü̃ nadèu̱xgu, rü nüma rü ta nüxü̃ naxüpetümare. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","—Natürü yixcüra rü wüxi ga Chamáriaanecü̱̃ã̱x ga yatü rü yematama namawa naxüpetü. Rü yexguma guma yatüxü̃ nadèu̱xgu rü nüxü̃́ nangechaü̃tümüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","—Rü guma yatücèx nixũ. Rü chixü̃ rü binumaã nanaxüxü̃ ga norü o̱xrigü, rü meãma nayanèĩ̱xgü ga yema norü o̱xrigü. Rü ñu̱xũchi norü burugu nanamunagü, rü wüxi ga pegüchicawa nanaga. Rü yéma nüxna nadau. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","—Rü moxü̃ãcü ga yexguma inaxũãchigu ga yema Chamáriaanecü̱̃ã̱x, rü ngĩxü̃ nayaxu ga taxretachinü ga norü dĩẽru, rü yema pegüchicaarü yorana ngĩxü̃ naxã. Rü ñanagürü nüxü̃: “¡Nüxna nadau i ñaã yatü! Rü ngẽxguma yexeragu naxãtanügu na nuã nangẽxmaxü̃, rü choma tá cuxü̃́ chanaxütanü i ngẽxguma chataeguxgu”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Rü ñanagürü ga Ngechuchu nüxü̃ ga yema ngúexẽẽruü̃ ga Moĩchéarü mugüwa ngu̱xẽẽtaexü̃: —Ñu̱xma chanaxwèxe i chomaã nüxü̃ quixu i ngẽxü̃rüüxü̃ ga yema tomaẽ̱xpü̱xtanüwa ga aixcüma namücü ixĩxü̃ ga yema yatü ga ngĩ́tèèxgüxü̃ imèxgüxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Rü yexguma ga yema ngúexẽẽruü̃ ga Moĩchéarü mugüwa ngu̱xẽẽtaexü̃ rü ñanagürü: —Yema Chamáriaanecü̱̃ã̱x nixĩ ga yema yatümücü ixĩxü̃, yerü nüxü̃́ nangechaü̃tümüü̃ —ñanagürü. Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Ñu̱xma rü íixũ rü yema Chamáriaanecü̱̃ã̱x üxü̃rüü̃ naxü! —ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Rü yexguma Ngechuchu namagu ixũxgu norü ngúexü̃gümaã rü wüxi ga ĩãnexãcüwa nangu. Rü yéma guma ĩãnexãcüwa rü wüxi ga nge ga Martagu ãe̱gacü ngĩgüpatawa inanguxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Rü Martaaxü̃́ iyexma ga wüxi ga ngĩẽyèx ga Maríagu ãe̱gacü. Rü ngĩma rü Ngechuchucutüxü̃tawa irüto na inaxĩnüxü̃cèx ga Ngechuchuarü ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Natürü ga Marta rü itaarü puracüã̱x rü yemaãcü ngĩrü puracüguama irüxĩnü. Rü yemacèx Ngechuchucèx iyaxũ, rü ngĩgürügü nüxü̃: —Pa Corix, ¿tama ẽ́xna nagu curüxĩnü i ngẽma na chataarü puracüã́xü̃ rü ngẽma chaueyèx rü choxnaxĩca na natáãxü̃ i guxü̃ma i ngẽma puracü? ¡Rü namaã nüxü̃ ixu na choxü̃ nangü̃xẽẽxü̃cèx! —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Natürü Ngechuchu rü ngĩxü̃ nangãxü̃, rü ñanagürü ngĩxü̃: —Pa Martax, cuma rü poraãcü curü puracücèx cuxoegaãẽ, rü muxü̃ma i ngẽmaxü̃gu curüxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","—Natürü wüxixicatama nixĩ i guxü̃ãrü yexera i mexü̃ na nagu rüxĩnüxü̃. Rü María iyixĩ i ngẽmagu rüxĩnücü. Rü taxúetáma ngĩxna tayanuxü̃ i ngẽma —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Rü wüxicana wüxi ga nachicawa nayumüxẽ ga Ngechuchu. Rü yexguma nüxü̃ nachauxgu, rü wüxi ga norü ngúexü̃ rü ñanagürü nüxü̃: —Pa Corix ¡toxü̃ nangúexẽẽ na ñuxãcü tayumüxẽgüxü̃, yema Cuáü̃ ga baiü̃xẽẽruü̃ norü ngúexü̃güxü̃ nangúexẽẽxü̃rüü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Rü Ngechuchu ñanagürü nüxü̃: —Rü ngẽxguma peyumüxẽgügu rü ñaperügügü tá: “Pa Tonatü ya Daxũgucüx, rü aixcüma Üünecü quixĩ i cumax. ¡Rü núma naxũ na torü ãẽ̱xgacü quiĩxü̃cèx! Rü tanaxwèxe i curü ngúchaü̃ na naxügüxü̃ i duü̃xü̃gü i ñoma i naãnewa, ngẽma daxũguxü̃ i naãnewa na curü ngúchaü̃ ínaxügüxü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","¡Rü toxna naxã i torü õna i wüxichigü i ngunexü̃cèx ixĩxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","¡Rü toxü̃́ nüxü̃ nangechaü̃ i torü pecadugü, erü toma rü ta tüxü̃́ nüxü̃ tangechaü̃ ya guxãma ya yíxema chixri tomaã chopetüxe! ¡Rü tãxṹ i ṯacü rü chixexü̃pẽ́xewa toxü̃ cuwogüxü̃ na tama nagu tayixü̃cèx!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Rü ñanagürü ta ga Ngechuchu: —Ngẽxguma chi wüxie i pema rü tüxü̃́ nangẽmaxgu i wüxi i tümamücü, rü chi ngãxü̃cüü napatawa taxũxgu rü ñatagügu nüxü̃: “Pa Chomücüx, ¡tomaẽ̱xpü̱x i pãũ choxna naxã! ");
INSERT INTO tcaNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","—Erü wüxi i chomücü rü yaxü̃wa ne naxũ, rü ngexwacèx chopatawa nangu. Rü choma rü changearü õnaã̱x, rü taxuü̃maãma chanachibüxẽẽe̱ga”, ñatagügu. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","—Rü ngẽma tümamücü i napatawa ngẽxmaxü̃, rü chi tüxü̃ nangãü̃xgu rü ñaxgu: “¡Tãxṹ i choxü̃ cuchixewexü̃! Chorü ĩã̱x rü marü narüwãxta, rü choma rü chauxacügü rü ngürücarewa tangẽxmagü. Rü ngẽmacèx taxucürüwa ícharüda na ṯacü cuxna na chaxãxü̃cèx”, ñaxgu chi tüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","—Rü pemaã nüxü̃ chixu, rü ngẽma na tümamücü yiĩxü̃cèx rü tãũtáma ínarüda na ṯacü tüxna naxãxü̃cèx. Natürü tá ínarüda na tama tanachixeweechaxü̃cèx, rü tá tüxna nanaxã i guxü̃ma i ṯacü i tanaxwèxexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","—Rü ngẽmacèx pemaã nüxü̃ chixu rü, ¡Naxcèx ípec̱a rü Tupana rü tá pexna nanaxã! ¡Rü Tupanacèx pedèu̱x rü tá nüxü̃ ipeyangau! ¡Rü ĩã̱xwa: Tu tu tu ñapegü, rü tá pexcèx niwãxna i ĩã̱x! ");
INSERT INTO tcaNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","—Erü guxãma ya yíxema naxcèx íc̱axe rü tanayaxu, rü guxãma ya naxcèx dauxe rü nüxü̃ itayangau. Rü guxãma ya ĩã̱xwa: Tu tu tu ñagüxe, rü tümacèx tá niwãxna i ĩã̱x. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","—¿Rü ñuxãcü i wüxi i pema na papágü piĩxü̃ rü penena penaxãxü̃ ya wüxi ya nuta ega pãũcèx pexna nacaxgu, rü ẽ́xna wüxi i ãxtape ega choxnicèx pexna nacaxgu? ");
INSERT INTO tcaNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","—¿Rü texé i petanüwa rü penena penaxã i tuxchinawe ega wüxi ya otacharaü̃cèx pexna nacaxgu? ");
INSERT INTO tcaNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","—Rü ngẽma pema na pichixecümachiréxü̃ natürü nüxü̃ pecuèx na ñuxãcü mexü̃ i ãmare pexacügüna na pexãxü̃, rü pemaã nüxü̃ chixu rü Penatü ya Daxũgucü rü perü yexera tá nixĩ na pexna mexü̃ naxãxü̃. Rü guxãma ya yíxema Tupanaxü̃tawa Naãẽ i Üünexü̃cèx íc̱axe, rü tá tüxna nanaxã —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Rü Ngechuchu ínanatèxüchi ga wüxi ga ngoxo ga wüxi ga yatüxü̃ ngegaxẽẽxü̃. Rü yexguma ínaxũü̃xgu ga yema ngoxo rü guma yatü rü nidexa. Rü guxü̃ma ga duü̃xü̃gü rü naḇaixãchiãẽgü ga yexguma yemaxü̃ nadaugügu. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Natürü ñuxre ga duü̃xü̃gü rü ñanagürügü: —Ñaã yatü i Ngechuchu, rü Bechebú i ngoxogüarü ãẽ̱xgacüarü poramaã nixĩ i ínanawoxü̃ãxü̃ i ngoxogü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Natürü ga togü rü nüxü̃ naxügüchaü̃, rü yemacèx naxcèx ínacagü ga nüxü̃ na nawéaxü̃ ga wüxi ga cuèxruü̃ ga daxũcü̱̃ã̱x na yemawa nüxü̃ nacuèxgüxü̃cèx rü ngoxi aixcüma Cristu yiĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Natürü nüma ga Ngechuchu rü nüxü̃ nacuèxama ga ṯacügu na naxĩnüẽxü̃, rü yemacèx ñanagürü nüxü̃: —Ngẽxguma chi wüxi i nachiü̃ãnecü̱̃ã̱x i duü̃xü̃gü nügü itoyegu rü nügütanüwa chitama nügü nadaixgu, rü nügü chitama nagu̱xẽẽ. Rü ngẽxguma chi wüxi ya ĩcü̱̃ã̱x nügümaã nuẽẽchagu rü nügü nadaixgu, rü nügü chitama nagu̱xẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","—¿Rü ngẽxguma chi Chataná nügümaãtama nuxgu, rü nügütama yamèxgu, rü ñuxãcü chi i ãẽ̱xgacüecha yiĩxü̃? Rü ngẽma ñacharügü i ñu̱xma erü pema choxü̃ pixuxgu rü Bechebúarü poramaã íchanawoxü̃ i ngoxogü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","—Natürü ngẽxguma chi Chatanáãrü poramaã íchanawoxü̃gu i ngoxogü, rü perü ngúexü̃gü rü chita Chatanáãrü poramaã ínanawoxü̃ i ngoxogü. Rü ngẽmawa meã nüxü̃ tacuèx na pema rü ípetüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","—Natürü pemaã nüxü̃ chixu rü aixcüma Tupanaãrü poramaã nixĩ i íchanawoxü̃xü̃ i ngoxogü. Rü ngẽmawa pexü̃ nüxü̃ chacuèxẽẽ na núma petanüwa nanguxü̃ ya Tupana na ãẽ̱xgacü yiĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","—Rü ngẽxguma wüxi ya yatü ya poracü rü meãma nügü naxüxnegu rü nüxna nadèu̱xgu ya napata, rü taxúetáma naxcèx tangĩ̱x i norü ngẽmaxü̃ i napatawa ngẽxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","—Natürü ngẽxguma ínanguxgu i to i yatü i nüxü̃ rüporamaẽxü̃, rü nüxü̃ nayexeragu, rü tá nüxna nanapuxü̃ ya naxne ya nügü namaã ínaporaãxü̃ne, rü tá nüxna nanapuxü̃ i guxü̃ma i norü ngẽmaxü̃, rü tá nayana. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Yíxema tama choxü̃ ngechaü̃xẽ rü chauxchi taxai. Rü yíxema tama choxü̃ rüngü̃xẽe̱xẽ na Tupanacèx tayagagüxü̃ i duü̃xü̃gü rü chauxchawa tanangianexẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—Rü ngẽxguma wüxi i ngoxo rü wüxi ya yatüwa ínaxũü̃xgu, rü dauxchitagu nanañaãne, rü naxcèx nadau na ngextá na nangü̃xü̃. Rü ngẽxguma taxuguma nangü̃e̱gagu, rü nügü ínicuèx rü ñanagürü: “Maneca naxcèx tá chataegu ya yima yatü ga noxri nawa íchaxũxũchirécü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","—Rü ngẽxguma nataegugu, rü yima yatüxü̃ inayangau na ñoma wüxi ya ĩ ya mexẽe̱ne rü meã nabixichinerüü̃ na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","—Rü ínixũ rü naxcèx nayadau i to i 7 i ngoxogü i norü yexera i chixexü̃. Rü guxü̃ma i ngẽma ngoxogü rü wüxigu yima yatügu nachocu, rü ngẽxma naxãchiü̃gü. Rü ngẽxguma ya yima yatü rü noxriarü yexera nachixe —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Rü yemaxü̃ íyaxuyane, rü wüxi ga ngecü rü duü̃xü̃gütanüwa tagaãcü ngĩgürügü: —Tataãẽ ya yíxema tügüanüwa cuxü̃ yaxẽe̱xẽ rü tügü nixü̃wa cuxü̃ maĩxẽ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Natürü ga Ngechuchu rü ñanagürü: —Yexeraãcü tataãẽ ya yíxema nüxü̃ ĩnüxẽ i Tupanaãrü ore rü naga ĩnüxẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Rü nimuẽtanü ga duü̃xü̃gü ga Ngechuchuxü̃tawa ngutaquẽ́xegüxü̃. Rü inanaxügü ga Ngechuchu ga namaã na yadexaxü̃. Rü ñanagürü: —Ñaã duü̃xü̃gü i ñomaü̃cüü maxẽxü̃ rü nichixecüma. Rü naxcèx ínacagü i wüxi i cuèxruü̃ i mexü̃ i Tupanaãrü poramaã üxü̃. Natürü Tupana rü wüxixicatama i cuèxruü̃ tá nüxü̃ nawẽ́x. Rü ngẽma nixĩ i cuèxruü̃ ga Tupanaãrü orearü uruü̃ ga Yonáwa duü̃xü̃güxü̃ nawéxü̃ na nüxü̃ nacuèxgüxü̃cèx na aixcüma Tupana yiĩxü̃ ga guma yéma namucü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","—Rü yexgumarüü̃ ga Yoná rü wüxi ga cuèxruü̃ nixĩ naxcèx ga Nínibecü̱̃ã̱x ga duü̃xü̃gü, rü ngẽxgumarüü̃ tá ta nixĩ ya Tupana Nane ya duü̃xü̃xü̃ ixĩcü na wüxi i cuèxruü̃ tá yiĩxü̃ naxcèx i ñomaü̃cüü maxẽxü̃ i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","—Rü ngẽxguma naãneãrü gu̱xgu rü Tupana rü ñomaü̃cüü maxẽxü̃ i duü̃xü̃güna nacèxgu i norü pecaduchigacèx, rü ngĩma ga nuxcümaü̃cü ga Chabaaneãrü ãẽ̱xgacü tá íirüda rü tá íinaxuaxü̃ i ñomaü̃cüü maxẽxü̃ i duü̃xü̃gü. Yerü ngĩma rü yaxü̃waxüchi ne ixũ ga na ãẽ̱xgacü ga Charumóũxü̃ naxĩnüxü̃cèx ga ñuxãcü poraãcü nüxü̃ na nacuèxüchixü̃. Natürü ñu̱xma nuã petanüwa nangẽxma i wüxi i Charumóũãrü yexera ixĩcü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","—Rü ngẽxguma naãneãrü gu̱xgu rü Tupana rü ñomaü̃cüü maxẽxü̃ i duü̃xü̃güna nacèxgu norü pecaduchigacèx, rü nuxcümaü̃güxü̃ ga Nínibecü̱̃ã̱x ga duü̃xü̃gü rü tá ínarüdagü rü tá ínanaxuaxü̃gü i ñomaü̃cüü maxẽxü̃ i duü̃xü̃gü. Yerü nümagü ga Nínibecü̱̃ã̱xgü ga duü̃xü̃gü rü nüxü̃ narüxoe ga nacümagü ga chixexü̃ ga yexguma Yoná namaã nüxü̃ ixuxgu ga Tupanaãrü ore. Natürü ñu̱xma nuã petanüwa nangẽxma i wüxi i Yonáãrü yexera ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Taxúema wüxi i omüwa tanangixichi rü ñu̱xũchi itayacu̱x rü ẽ́xna ṯacütüü̃gu tayaxücuchi. Natürü norü üchicaü̃gu tanaxünagü na nge̱ma tüxü̃ nabaxixü̃cèx ya yíxema duü̃xẽgü ya yima ĩgu chocuxe. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","—Cuxetügü rü ñoma wüxi i omürüü̃ nixĩ i cuxunecèx. Rü ngẽxguma ngẽma Tupana cuxü̃́ naxwèxexü̃cèx cudèu̱xgu, rü guxü̃ma i curü maxü̃ rü name. Natürü ngẽxguma ñoma i naãneãrü ngúchaü̃cèx cudèu̱xgu, rü guxü̃ma i curü maxü̃ rü chixexü̃wa nangẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","—¡Meã cugüna nadau na tama ẽãnexü̃xü̃ nanguxuchixü̃cèx i ngẽma ore i mexü̃ i cuxü̃́ ngẽxmaxü̃, i ñoma wüxi i omürüü̃ ixĩxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","—Ngẽxguma chi guxü̃ i curü maxü̃wa nangẽxmagu i Tupanaãrü ngóonexü̃ rü taxuwama nachixẽ́xgu i curü maxü̃, rü meã chi nüxü̃ cucuèx i Tupanaãrü ngúchaü̃ ñoma wüxi i omü i cuxü̃ baxixü̃rüü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Rü yexguma nüxü̃ nachauxgu ga na yadexaxü̃ ga Ngechuchu rü wüxi ga Parichéu nüxna naxu ga napatawa na yachibüxü̃cèx. Rü yema Parichéupatawa naxũ, rü mechawa nayarüto. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Rü yema Parichéu rü naḇaixãchiãẽ ga yexguma Ngechuchuxü̃ nadèu̱xgu na tama yanguxẽẽãxü̃ ga yema Moichéarü mu na nay̱auxmẽ́xgüxiraxü̃ ga yexguma nachibüegu. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Natürü nüma ga Cori ga Ngechuchu rü ñanagürü nüxü̃: —Pema i Parichéugü rü ñoma pochiyu rü poratu i düxétüwaxicatama iyaxuxü̃rüü̃ pixĩgü. Natürü i peãxẽwa rü nagu perüxĩnüẽ na pengíxü̃ rü chixexü̃ pexüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","—Pa Naẽchitamare Maxẽxü̃x, ¿tama ẽ́xna nüxü̃ pecuèx na guma Tupana ga naxücü i ngẽma tórü düxétüxü̃newa ngẽxmaxü̃, rü gumatama yiĩxü̃ ga naxücü ga tórü maxü̃ i tórü aixepewa ngẽxmaxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","—Rü name nixĩ i Tupanana penaxã i perü maxü̃ na aixcüma naxcèx pemaxẽxü̃cèx. Rü ngẽmaãcü tá pime i guxü̃wama. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","—Natürü wüxi i ngechaü̃ nixĩ i pexcèx, Pa Parichéugüx, erü pema rü perü ngẽmaxü̃wa rü meã Tupanana penaxã i ngẽma noxrü ixĩxü̃, natürü perü maxü̃wa rü tama aixcüma naga pexĩnüẽ rü tama nüxü̃ pengechaü̃. Rü marü name na perü ngẽmaxü̃wa Tupanana penaxãxü̃ i ngẽma noxrü ixĩxü̃. Natürü perü maxü̃wa rü ta penaxwèxe i meã naga na pexĩnüẽxü̃ rü nüxü̃ na pengechaü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","—Rü wüxi i ngechaü̃ nixĩ i pexcèx, Pa Parichéugüx, erü pema rü pexü̃́ nangúchaü̃ i ãẽ̱xgacüchicagüwa na perütogüxü̃ i ngutaquẽ́xepataü̃güwa. Rü penaxwèxe na ñoma ãẽ̱xgacüxü̃ rümoxẽxü̃rüü̃ na meã pexü̃ namoxẽgüxü̃ i duü̃xü̃gü i ítamü̃güwa. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","—Rü wüxi i ngechaü̃ nixĩ i pexcèx, erü ñoma yuetamaü̃gü i tama nüxü̃ idauxü̃ i duü̃xü̃gü naẽchitamare nae̱tüwa chopetüxü̃rüü̃ pixĩgü. Erü woo perü düxétüwa pime, natürü aixepewa i peãẽwa rü poraãcü pichixe —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Rü wüxi ga ngúexẽẽruü̃ ga Moĩchéarü mugüwa ngu̱xẽẽtaexü̃, rü Ngechuchuxü̃ nangãxü̃ rü ñanagürü: —Pa Ngúexẽẽruü̃ Pa Ngechuchux, rü ngẽma na ngẽma ñacuxü̃, rü toma rü toãẽwa nangu̱x —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Natürü Ngechuchu rü ñanagürü nüxü̃: —Wüxi i ngechaü̃ nixĩ i pexcèx, Pa Ngúexẽẽruü̃gü i Moĩchéarü Mugüwa Ngu̱xẽẽtaegüxü̃x, erü poraãcü penamu i duü̃xü̃gü na naga naxĩnüẽxü̃cèx i ngẽma Moĩchéarü mugü i guxchaxü̃ i pematama bai i írarüwa naga pexĩnüẽchaü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","—Rü wüxi i ngechaü̃ nixĩ i pexcèx, erü peyamexẽẽgü i tümamaü̃gü ga guxema nuxcümaü̃güxe ga Tupanaãrü orearü uruü̃gü ga perü o̱xigü tüxü̃ dèi̱xe. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","—Rü ngẽmawa nüxü̃ tacuèx na pema rü ta ipexãgüxü̃ nawa ga yema chixexü̃ ga perü o̱xigü ügüxü̃. Yerü nümagü rü tüxü̃ nadai ga guxema Tupanaãrü orearü uruü̃gü, rü ñu̱xma i pema rü peyamexẽẽgü i tümamaü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","—Rü yemacèx nixĩ ga Tupana ga ñaxü̃: “Ngẽma duü̃xü̃gütanüwa tá chanamugü i chorü orearü uruü̃gü rü chorü orearü ngeruü̃gü. Natürü ngẽma duü̃xü̃gü i chixexü̃gü rü tá nanadai i nümaxü̃ rü togüxü̃ rü tá nachixewegü rü tá nawe ningẽxü̃tanü”, ñaxü̃ ga Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Rü ñanagürü ga Ngechuchu: —Rü pemaã nüxü̃ chixu rü Tupana tá nayapeguãchixẽẽ i pema i ñu̱xma maxẽxẽ erü pema rü ta perü o̱xigücümagu pexĩ. Nümagü rü noxritama naãneãrü ügügumama rü nanadai ga muxü̃ma ga Tupanaãrü orearü uruü̃gü. Rü nüxĩra nayamèxgü ga Abé rü gumawena nayadaietanü ga muxü̃ma ga togü ñu̱xmata Zacaría ga tupauca ga taxü̃negu yamèxgüãcüwa nangu. Rü guxü̃ma ga yema orearü uruü̃gü ga perü o̱xigü dèi̱xü̃cèx rü Tupana tá pexna naca, erü pema rü ta perü o̱xigürüü̃tama pixĩgü rü tama nüxü̃ perüxoechaü̃ i ngẽma chixexü̃ i pexüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","—Rü wüxi i ngechaü̃ nixĩ i pexcèx, Pa Ngúexẽẽruü̃gü i Moĩchéarü Mugüwa Ngu̱xẽẽtaegüxü̃x, erü duü̃xü̃güchaxwa ipeyacu̱x i Tupanaãrü ore i aixcüma ixĩxü̃ i pematama tama pixõgüxü̃. Rü nüxna penachu̱xu i togü i duü̃xü̃gü i aixcüma yaxõgüchaü̃xü̃ na nümagü rü ta tama yaxõgüãxü̃cèx —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Rü yexguma Ngechuchu yema ñaxgu, rü yema ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ rü yema Parichéugü rü poraãcü Ngechuchumaã nanuẽ. Rü inanaxügü ga nüxna na nacagüexü̃ naxcèx ga muxü̃ma ga ore ga guxchaxü̃maã na yemaãcü chi nüxü̃ iyangaugüxü̃cèx ga ore ga chixexü̃ na yemamaã norü ãẽ̱xgacügüxü̃- tawa Ngechuchuxü̃ íyaxuaxü̃güxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Rü yoxni yexma nangutaquẽ́xegü ga muxũchixü̃ ga duü̃xü̃gü. Rü yema na namuxũchixü̃cèx rü düxwa nügücutüwa ningagüetanü ga duü̃xü̃gü. Rü Ngechuchu inanaxügü ga norü ngúexü̃gümaãxĩra na yadexaxü̃, rü ñanagürü: —¡Pexuãẽgü naxcèx i Parichéugü! Erü duü̃xü̃güpẽ́xewa meã namaxẽneta natürü naãẽwa rü chixexü̃gu narüxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","—Natürü guxü̃ma i ṯacü i wüxie cúãcü üxü̃ rü tá nango̱xoma. Rü guxü̃ma i ṯacü iicúxü̃ rü yixcüra rü tá duü̃xü̃gü nüxü̃ nacuèxgüama. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","—Rü ngẽmacèx guxü̃ma i ngẽma ore i ẽãnexü̃wa cúãcü nüxü̃ pixuxü̃ rü yixcüra rü tá nango̱xoma rü guxü̃ i duü̃xü̃gü tá nüxü̃ naxĩnüẽ. Rü ngẽma ore i ucapuarü aixepewa cúãcü nüxü̃ pixuxü̃, rü yixcüra rü guxãpẽ́xewa tá nüxü̃ nixugügü i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Rü ngẽmacèx i pemax, Pa Chomücügüx, rü pemaã nüxü̃ chixu rü ¡tama nüxü̃ pemuü̃ẽ i ngẽma duü̃xü̃gü i pexü̃ daixchaü̃xü̃! Erü taxünexü̃xĩcatama nimèxgü, natürü taxucürüwama taãẽxü̃ nimèxgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","—Natürü pemaã tá nüxü̃ chixu na texéxü̃ tá na pemuü̃ẽxü̃. ¡Nüxü̃ pemuü̃ẽ ya Tupana! Erü nüma nüxü̃́ nangẽxma i pora na yamáãxü̃ i pexene, rü napoxcuãxü̃ i peãẽ i ngextá ngoxogüxü̃ ínapoxcuxü̃gu. ¡Rü yimaxü̃ tá nixĩ i pemuü̃ẽxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","—¿Tama ẽ́xna taxretachinü i dĩẽruxacügu namaã petaxe i wüximẽ́ẽ̱xpü̱x i werixacügü? Natürü Tupana rü tama tüxü̃ inayarüngüma ya yíxema werixacüã̱xgü, rü bai ya wüxi. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","—Rü woo i peyaegü rü Tupana nüxü̃ nacuèx na ñuxre i peyae ngẽxmaxü̃. Rü ngẽmacèx, ¡tãxṹ i pexoegaãẽgüxü̃! Erü pema rü muxü̃ma i werixacügüarü yexeraxüchi pexü̃ nangechaü̃ ya Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—Rü pemaã nüxü̃ chixu rü guxãma ya texé i ñoma i naãnewa duü̃xü̃güpẽ́xewa tügü ixuxe na chorü duü̃xü̃ tiĩxü̃, rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü napẽ́xewa i Tupanaãrü orearü ngeruü̃gü i daxũcü̱̃ã̱x rü tá tüxü̃ chixu na chorü duü̃xü̃ tiĩxü̃ i tümax. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","—Natürü texé ya ñoma i naãnewa duü̃xü̃güpẽ́xewa tügü ixuxe na tama chorü duü̃xü̃ tiĩxü̃, rü choma rü tá ta napẽ́xewa i Tupanaãrü orearü ngeruü̃gü i daxũcü̱̃ã̱x rü tá tüxü̃ chixu na tama chorü duü̃xü̃ tiĩxü̃ i tümax. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","—Rü guxãma ya texé ya chixri chauchiga idexaxe i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü Tupana tá tüxü̃́ nüxü̃ nangechaü̃ i ngẽma. Natürü texé ya Tupanaãẽ i Üünexü̃chiga chixri idexaxe, rü Tupana rü tãũtáma tüxü̃́ nüxü̃ nangechaü̃ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","—Rü ngẽxguma duü̃xü̃gü ngutaquẽ́xepataü̃güwa rü ẽ́xna ãẽ̱xgacügüpẽ́xewa pexü̃ nagagügu na pexü̃ napoxcuexü̃cèx, rü ¡tãxṹ i pexoegaãẽgüxü̃ na ṯacümaã tá penangãxü̃xü̃ rü ẽ́xna ṯacüxü̃ tá namaã na pixuxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","—Erü ngẽxguma nawa nanguxgu na pidexagüxü̃, rü Tupanaãẽ i Üünexü̃ tá pexü̃ nangu̱xẽẽ na ṯacüxü̃ tá namaã pixuxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Rü yema duü̃xü̃gütanüwa rü wüxi ga yatü Ngechuchuxü̃ ñanagürü: —Pa Ngúexẽẽruü̃x, ¡namaã nüxü̃ ixu ya chaueneẽ rü choxna naxãã i ngẽma chaunatü ga yucüarü ngẽmaxü̃ i choxna üxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Natürü Ngechuchu rü ñanagürü nüxü̃: —Pa Yatüx, ¿texé perü ãẽ̱xgacüxü̃ choxü̃ tingucuchixẽẽ na chayatoyexü̃cèx i ngẽma penatüarü ngẽmaxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Rü ñanagürü ta ga Ngechuchu: —¡Pexuãẽ na tama pexü̃́ nangúchaü̃xü̃cèx i togüarü ngẽmaxü̃! Erü wüxi i duü̃xü̃ rü tama ngẽma na namuãrü ngẽmaxü̃ã́xü̃cèx nixĩ i nayauxãxü̃ i norü maxü̃ i taguma gúxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Rü yexguma wüxi ga ore ga cuèxruü̃xü̃ namaã nixu, rü ñanagürü: —Nayexma ga wüxi ga yatü ga muãrü dĩẽruã́cü, rü guxü̃ma ga yema nanetügü ga naãnegu natogüxü̃ rü meãma nüxü̃́ nixo. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","—Rü guma yatü rü nagu narüxĩnü rü naãẽwa ñanagürü: “¿Ṯacü tá chaxüxü̃ i ñu̱xmax? Erü nataxuma i chorü nachica i ngexta namaã na changuxü̃xü̃ i chaunetügüarü o”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","—Rü naãẽwa ñanagürü: “Marü nüxü̃ chacuèx na ṯacü tá chaxüxü̃. Rü nagu tá chapogü ya guxü̃nema ya chorü ĩpatagü ga nagu namaã changuxü̃ne ga chaunetügüarü o. Rü náĩ ya taxüragüne tá chaxü na ngẽxma namaã changuxü̃xü̃cèx i guxü̃ma i chaunetügüarü o rü guxü̃ma i chorü ngẽmaxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","—Rü ngẽxguma marü namexgu i guxü̃ma, rü chaugümaã tá ñacharügü: ‘Ñu̱xma rü tá icharüngü̃ rü meã tá chachibü rü meã chaxaxe rü ngẽmaãcü tá chataãẽ. Erü namuxũchi i chorü ngẽmaxü̃gü, rü mucüma ya taunecü tá choxü̃́ natai’, ñacharügü tá chaugümaã”. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","—Natürü Tupana rü ñanagürü guma yatüxü̃: “Pa Yatüx, cungẽãẽmare i cuma erü ñoma i chütaxü̃gu tátama cuyu. Rü ngẽma curü ngẽmaxü̃gü i namaã cunguxü̃xü̃, rü ¿texéarü tá nixĩ i ngẽxguma?” ñanagürü ga Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","—Rü ngẽxgumarüü̃ tá ta namaã nangupetü i ngẽma duü̃xü̃gü i nügücèxtama norü ngẽmaxü̃gümaã nguxü̃xü̃ rü tama nügü ímexẽẽxü̃ i Tupanapẽ́xewa —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Rü yemawena rü norü ngúexü̃güxü̃ ñanagürü ga Ngechuchu: —Pemaã nüxü̃ chixu ¡rü tãxṹ i pexoegaãẽgüxü̃ naxcèx i ṯacü tá na pengṍxü̃ rü ṯacümaã tá na pixãxchiruxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","—Erü perü maxü̃ rü õnaãrü yexera nixĩ, rü pexene rü naxchiruarü yexera nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","—¡Dücèx penangugü i werigü i tama toegüchiréxü̃, rü tama nanetüarü o ibuxgüxü̃, rü ngepatagüxü̃ na ngexta namaã nanguxü̃güxü̃cèx i norü õna! Natürü Tupana rü nanaxüwemü. Rü pema rü Tupanacèx rü poraãcü guxü̃ma i werigüarü yexera pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","—Rü taxuwama name na pexoegaãẽgüxü̃. Erü taxucürüwama wüxie i pema rü pegütama ipemèxãchixẽẽ ngãxü̃ ya metrugu ega woo poraãcü naxcèx pexoegaãẽgügu. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","—Rü ngẽxguma tama pemaã nanguxü̃ i ngẽma íraxü̃ rü taxucürüwama pegütama ipemèxãchixẽẽ ega woo naxcèx pexoegaãẽgügu, rü ¿tü̱xcüü̃ i ngẽxguma rü ta ṯacü i togü i ngẽmaxü̃gücèx pexoegaãẽgüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","—¡Dücèx penangugü i putüragü na ñuxãcü nayaexü̃ i nachacu! Rü tama napuracüexü̃, rü tama nügü üxchirugüxü̃. Natürü woo guma ãẽ̱xgacü ga Charumóũ ga na namexẽchixü̃ ga naxchiru rü taguma wüxi ga putürachacuarü mexü̃rüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","—Rü marü nüxü̃ pedau i ñuxãcü Tupana na nangèxãẽxü̃ i putüragü i ñu̱xma naãnewa rüxügümarexü̃ natürü moxü̃ rü marü taxuxü̃. Rü ngẽxguma Tupana ngẽmaãcü nangèxãẽgu i putüragü rü pema rü tá ngẽmaãrü yexera pexchiru pexna naxã, Pa Duü̃xü̃gü i Írarüwatama Yaxõgüxü̃x. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","—Rü ngẽmacèx tama name i pexoegaãẽ naxcèx i ṯacü tá na pengṍxü̃ rü ṯacü tá na pixaxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","—Erü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü rü naxcèx nadaugü i guxü̃ma i ngẽma pemaã nüxü̃ chixuxü̃. Natürü pema rü pexü̃́ nangẽxma ya Penatü ya Tupana ya nüẽchama nüxü̃ cuácü na pexü̃́ nataxuxü̃ i guxü̃ma i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","—Rü ngẽmacèx narümemaẽ nixĩ na Tupanaãrü ngúchaü̃cèx pedaugüxü̃ na perü ãẽ̱xgacü yiĩxü̃cèx. Rü ñu̱xũchi nüma rü tá pexna nanaxã i guxü̃ma i ṯacü i pexü̃́ taxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—¡Tãxṹ i pemuü̃ẽxü̃, Pa Chauxacügüx! Pema rü noxretama pixĩgü natürü Penatü ya Tupana rü norü ngúchaü̃ nixĩ na pexna naxããxü̃ i pechica i ngextá nüma ãẽ̱xgacü íyiĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","—¡Rü namaã petaxe i perü ngẽmaxü̃gü rü togü i duü̃xü̃gü i nüxü̃́ nataxuxü̃na penaxã i ngẽma dĩẽru! Rü ngẽmaãcü tá pegüxü̃́ penangẽxmaxẽẽ i perü ngẽmaxü̃gü i taguma pexü̃́ ngauxü̃ rü taguma gúxü̃ i daxũguxü̃ i naãnewa i ngextá tama íyaxücuxü̃wa i ngĩ́tèxáxü̃ rü naweane tama ínachixexẽẽxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","—Erü ngextá ínangẽxmaxü̃wa i perü ngẽmaxü̃gü, rü ngẽxma nixĩ i perüxĩnüẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—¡Rü ípememare namaã i perü omügü i naĩgüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","—Rü name nixĩ i wüxi i coriarü duü̃xü̃gü i ímemaregüxü̃rüü̃ na pixĩgüxü̃. Rü penaxwèxe na ñoma duü̃xü̃gü i ĩã̱xwa norü corixü̃ nanguxẽẽgüxü̃rüü̃ na pixĩgüxü̃. Rü ngẽxguma norü cori rü wüxi i ngĩgüarü petawa ne naxũxgu rü: Tu tu tu ñaxgu, rü paxa naxcèx nayawãxnagü i ĩã̱x. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","—Rü nataãẽgü i ngẽma coriarü duü̃xü̃gü ega inadauegu i ngẽxguma ínanguxgu i norü cori. Rü pemaã nüxü̃ chixu rü ngẽma cori rü norü mechawa tátama nanatogüxẽẽ i ngẽma norü duü̃xü̃gü i nüxü̃ ínanguxẽẽgüxü̃, rü nüma tátama ngẽma norü duü̃xü̃güxü̃ inaxüwemü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","—Rü woo ngãxü̃cüü ínanguxgu rü ẽ́xna marü yangunechaü̃gu rü nataãẽgü i ngẽma coriarü duü̃xü̃gü ega inadauegu i ngẽxguma ínanguxgu i norü cori. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","—Rü ngẽxguma chi wüxi ya ĩãrü yora nüxü̃ cuèxgu na ñuxguacü ínanguégaxü̃ i ngĩ́tèxáxü̃, rü tãũ chima nape. Rü chi nüxna nadau ya napata na tama yawãxnaãxü̃cèx rü tama na nüxü̃́ nangĩ́xü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","—Rü pema rü ta penaxwèxe na ípememarexü̃. Erü ngürüãchi tama nagu íperüxĩnüẽyane tá íchangu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Rü yexguma ga Pedru rü Ngechuchuna naca rü ñanagürü: —Pa Corix, ¿toxcèxicatama ẽ́xna nixĩ i ñaã ore i cuèxruü̃ i tomaã nüxü̃ quixuxü̃, rü ẽ́xna guxü̃ i duü̃xü̃gücèx yiĩxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Rü ñanagürü ga Cori ga Ngechuchu: —¿Texé tiĩxü̃ ya yíxema tümaãrü coriarü duü̃xẽ ya aixcüma yanguxẽe̱xẽ rü meã tümaãẽxü̃ cuáxe? ¿Tama ẽ́xna yíxema tiĩxü̃ ya tümaãrü cori tüxna ãgaxe na meã nüxna tadauxü̃cèx rü meã oragu tanachibüexẽẽxü̃cèx i norü duü̃xü̃gü? ");
INSERT INTO tcaNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","—Rü tataãẽ ya yíxema coriarü duü̃xẽ i ngẽxguma ínanguxgu i tümaãrü cori rü tüxü̃ íyangueü̃gu na meãma ítanaxüxü̃ i ngẽma puracü i nagu tüxü̃ namuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","—Rü aixcüma pemaã nüxü̃ chixu rü ngẽma tümaãrü cori rü tá guxü̃ma i norü ngẽmaxü̃güarü dauruü̃xü̃ tá tüxü̃ nixĩxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","—Natürü ngẽxguma chi ngẽma duü̃xü̃ nagu rüxĩnügu rü norü cori rü tama paxa na ínanguxü̃, rü inaxügüãgu na chixri namuãxü̃ i natanüxü̃gü i yatüxü̃gü rü ngexü̃gü, rü peta naxü̱xgu rü nachibüxgu, rü naxaxegu, rü nügü nangãxẽẽgu, rü ngürüãchi ngẽma ngunexü̃ rü ngẽma ora i tama nagu ínanguxẽẽãxü̃gu tá ínangu i norü cori. Rü poraãcüxüchi tá nanapoxcu ngẽma duü̃xü̃gü i tama norü coriga ĩnüẽxü̃xü̃ napoxcuexü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","—Rü ngẽma coriarü duü̃xü̃ i nüxü̃ cuèxchiréxü̃ na ṯacü nanaxwèxexü̃ i norü cori, natürü tama nügü ímexẽẽxü̃ rü tama norü coriga ĩnüxü̃, rü tá poraãcü nanac̱uaxi. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","—Natürü ngẽma coriarü duü̃xü̃ i tama nüxü̃ nacuáãcüma chixri norü coriga ĩnüxü̃, rü chixexü̃ üxü̃, rü tá írarüwaxüra nanac̱uaxi. Rü texé ya Tupana muxü̃ma tüxna ãxẽ, rü muxü̃cèxtáma tüxna naca. Rü texé ya muxü̃na tüxü̃ nadauxẽe̱xẽ rü tá yexeraãcü tüxna naca. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Núma chaxũ na ñoma i naãnewa duü̃xü̃güxü̃ chidauchitanüxẽẽxü̃cèx. Rü chierü aixcüma marü yadauchitanügu. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","—Rü choma rü tá poraãcü ngúxü̃ chinge, rü chanaxi̱xãchiãẽ ñu̱xmatáta yangu i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","—Rü tama name i nagu perüxĩnüẽ na núma chaxũxü̃ na guxü̃ i duü̃xü̃gü rü wüxigu naxĩnüẽxü̃cèx. Natürü pemaã nüxü̃ chixu rü núma chaxũ na chaugagu yatoyexü̃cèx i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","—Erü ñaãwena ega wüxi ya ĩpatawa nangẽxmagu i wüximẽ́ẽ̱xpü̱x i duü̃xü̃gü, rü tomaẽ̱xpü̱x tá choxü̃́ nayaxõgü rü taxre i tama, rü ẽ́xna taxre tá choxü̃́ nayaxõgü rü tomaẽ̱xpü̱x i tama. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","—Rü wüxi i papá tá nayaxõ rü nane rü tãũtáma nayaxõ, rü ẽ́xna nane tá nayaxõ natürü nanatü i tama. Rü ngẽxgumarüü̃ ta wüxi i mamá tá iyaxõ rü ngĩxãcü rü tãũtáma iyaxõxchãü̃, rü ẽ́xna ngĩxãcü tá iyaxõ rü ngĩẽ rü tãũtáma iyaxõxchãü̃. Rü wüxi ya ngĩ̱xẽ tá iyaxõ rü ngĩneã̱x rü tãũtáma iyaxõ, rü ẽ́xna ngĩneã̱x tá iyaxõ rü ngĩ̱xẽ rü tãũtáma iyaxõ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Rü Ngechuchu ñanagürü ta nüxü̃ ga duü̃xü̃gü: —Ngẽxguma nüxü̃ pedèu̱xgu na naxẽãchianexü̃, rü nagu perüxĩnüẽ tá na napuxü̃. Rü aixcüma ngẽmaãcü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","—Rü pema nüxü̃ pecuèx na ñuxãcü penangugüxü̃ ya buanecü, rü ngẽmaãcü nüxü̃ pecuèx rü tá na nangu̱xetüxü̃. Rü aixcüma ngẽmaãcü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","—Pa Duü̃xü̃güx, pema rü togü i duü̃xü̃güpẽ́xewa meã pemaxẽneta, natürü peãẽwa rü chixexü̃gu perüxĩnüẽ. Pema nüxü̃ pecuèx na ñuxãcü penangugüxü̃ ega tá napuxgu rü ẽ́xna tá nangu̱xetügu. ¿Rü ñuxãcü i ñu̱xma i tama nüxü̃ pecuáxü̃ na Tupana yiĩxü̃ ya petanüwa ngucü? ");
INSERT INTO tcaNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—Rü tü̱xcüü̃ tama nüxü̃ pecuáxchaü̃ i ngẽma nama i mexü̃ i Tupana pexü̃́ naxwèxexü̃ na nagu pexĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","—Rü ngẽxguma chi wüxie wüxi i ngetanücèx cuxü̃ íxuaxü̃gu rü ãẽ̱xgacüxü̃tawa cuxü̃ tagaxgu, rü name nixĩ i namawatama tüxü̃ icurüngüxmüxẽẽ na tama ãẽ̱xgacüpẽ́xewa cuxü̃ tagaxü̃cèx. Erü wüxicana na ãẽ̱xgacüxü̃tawa cunguxü̃ rü ãẽ̱xgacü tá purichíagüna cuxü̃ namu. Rü purichíagü tá cuxü̃ napoxcu. ");
INSERT INTO tcaNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","—Rü cumaã nüxü̃ chixu rü ngẽxma poxcuchicagu tá curüxã̱ũ̱x ñu̱xmatáta ngĩxü̃ cuxütanü i gu̱xcü i dĩẽru i nüxü̃́ ngĩxü̃ cungetanücü. Rü aixcüma ngẽxgumarüü̃ tá cumaã nanaxü ya Tupana ega tama namaã cunamexẽẽ̱xgu i curü maxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Rü yexgumatama Ngechuchuxü̃tawa nangugü ga ñuxre ga duü̃xü̃gü. Rü Ngechuchumaã nüxü̃ nixugü ga na ñuxãcü ãẽ̱xgacü ga Piratu namuxü̃ ga norü churaragü na nadaiãxü̃cèx ga ñuxre ga yatügü ga Gariréaanecü̱̃ã̱x ga yexguma yema yatügü rü Tupanacèx carneru nadaixgu tupauca ga taxü̃newa. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Rü Ngechuchu nüxna naca rü ñanagürü nüxü̃: —¿Pema nagu perüxĩnüẽgu rü yemaãcü nüxü̃ nangupetü ga yema yatügü, yerü yema togü ga Gariréaanecü̱̃ã̱xãrü yexera nipecaduã̱xgü? ");
INSERT INTO tcaNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","—Pemaã nüxü̃ chixu rü tama nixĩ. Rü ngẽxguma chi pema rü tama nüxü̃ perüxoegu i pecüma i chixexü̃, rü guxãma i pema rü tá ta ipeyarütauxe. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","—¿Rü ẽ́xna pema nagu perüxĩnüẽgu rü guxü̃ ga Yerucharéü̃cü̱̃ã̱xãrü yexera nipecaduã̱xgü ga yema 18 ga yatügü ga yuexü̃ ga yexguma Chiruéwa yexmaxü̃ ga dauxü̃taechica nae̱tü rüngutaü̃gu? ");
INSERT INTO tcaNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","—Pemaã nüxü̃ chixu rü tama nixĩ. Rü ngẽxguma chi pema rü tama nüxü̃ perüxoegu i pecüma i chixexü̃, rü guxãma i pema rü tá ta ipeyarütauxe —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Rü nüma ga Ngechuchu rü nüxü̃ nixu ga wüxi ga ore ga igueragu ixuxü̃, rü ñanagürü: —Rü wüxi ga yatü nüxü̃́ nayexma ga wüxi ga ubanecü. Rü yexma nanato ga wüxi ga iguera. Rü nüma ga guma yatü rü ínayadauuxü̃ ga yema iguera rü ngoxi naxõṍ, natürü taxuxü̃ma ga norü oxü̃ inayangau. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","—Rü yemacèx yema norü duü̃xü̃ ga norü naãnena dauxü̃xü̃ ñanagürü: “Dücèx, tomaẽ̱xpü̱x ya taunecü guxü̃guma íchayadauxü̃ i ñaã iguera, rü taguma naxo. Rü ngẽmacèx chanaxwèxe na cuyadaxüchixü̃ na tama natücèxma nuã naãnewa naxíaneã̱xü̃cèx”, ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","—Natürü ga yema norü duü̃xü̃ ga norü naãnena dauxü̃, rü norü corixü̃ nangãxü̃, rü ñanagürü: “Pa Corix, ¡nüe̱tama doma taunecüxicatama nangẽmèx! Rü tá chanaxaimüãnepǘne rü waxmüãnexü̃maã tá chanagüpǘne. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","—Rü bexmana ngẽxguma rü tá naxo. Natürü ngẽxguma tãũtáma naxo̱xgu rü tá chayadaxüchi”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Rü wüxi ga ngü̃xchigaarü ngunexü̃gu rü Ngechuchu nangu̱xẽẽtae ga wüxi ga ngutaquẽ́xepataü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Rü yéma iyexma ga wüxi ga ngecü ga 18 ga taunecü iḏaawecü. Rü ipücèxwe yerü wüxi ga ngoxo ngĩxü̃ napücèxwexẽẽ, rü taxuacüma iyarüwẽ́xãchi. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Rü yexguma Ngechuchu ngĩxü̃ dèu̱xgu rü ngĩxcèx naca, rü ñanagürü ngĩxü̃: —Pa Ngecüx, ñu̱xma rü marü cuxcèx nitaane i curü ḏaawewa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Rü yexguma rü ngĩxü̃ ningõgü, rü yexgumatama iyarüwẽ́xãchiwemüxü̃, rü inaxügü ga Tupanaxü̃ na yacuèxüü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Natürü yema ngutaquẽ́xepataü̃ãrü ãẽ̱xgacü rü nanu, yerü Ngechuchu rü ngü̃xchigaarü ngunexü̃gu ngĩxü̃ narümexẽẽ ga yema nge. Rü yemacèx ga yema ãẽ̱xgacü rü ñanagürü duü̃xü̃güxü̃: —Nangẽxma i 6 i ngunexü̃ i nagu namexü̃ na ipuracüexü̃. Rü ngẽma ngunexü̃gügu nixĩ i namexü̃ na nuã pexĩxü̃ na pegü peyarümexẽẽgüxü̃cèx rü tama i ngü̃xchigaarü ngunexü̃gu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Rü yexguma ga Cori ga Ngechuchu rü nanangãxü̃, rü ñanagürü: —Pa Duü̃xü̃güx, pema rü togü i duü̃xü̃güpẽ́xewa meã pemaxẽneta, natürü peãẽwa rü chixexü̃gu perüxĩnüẽ. ¿Tama ẽ́xna guxã i pema rü ngü̃xchigaarü ngunexü̃gu peyawẽxü̃ i perü woca rü ẽ́xna perü buru na peyaxaxexẽẽgüxü̃cèx? ");
INSERT INTO tcaNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","—Rü ñaã ngecü rü Abráü̃tanüxü̃ iyixĩ, rü Chataná rü 18 ya taunecü ngĩxü̃ nachixexẽẽ namaã i ñaã ḏaawe. ¿Rü taux ẽ́xna i namexü̃ na ngĩxcèx chayataanexẽẽxü̃ i ngü̃xchigaarü ngunexü̃gu? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Rü yexguma yema ñaxgu ga Ngechuchu, rü guxü̃ma ga norü uwanügü rü poraãcü naxãneẽ. Natürü guxü̃ma ga togü ga duü̃xü̃gü rü nataãẽgü ga yexguma nüxü̃ nadaugügu ga yema mexü̃gü ga Ngechuchu üxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Rü ñanagürü ga Ngechuchu: —¿Ñuxãcü nixĩ i ãẽ̱xgacü na yiĩxü̃ ya Tupana, rü nañuxraü̃xü̃ i nüma ãẽ̱xgacü íyiĩxü̃wa? ¿Rü ṯacügu tá chanangu? ");
INSERT INTO tcaNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","—Maneca wüxi ya motachachire ya wüxi ya yatü naãnegu toxü̃nerüü̃ nixĩ. Rü woo naxíraxüchichirẽ́x ya naxchire natürü narüxü, rü naya ñu̱xmata wüxi i nanetü i taetaxü̃ nixĩ. Rü ngẽmacèx i werigü rü natanügu nixüachiãü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Rü ñanagürü ta ga Ngechuchu: —¿Ñuxãcü nixĩ i Tupana ãẽ̱xgacü íixĩxü̃wa? ¿Rü ṯacügu tá chanangu? ");
INSERT INTO tcaNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","—Rü pãũãrü puxẽẽruü̃rüü̃ nixĩ na guxü̃wama nanguxü̃. Erü wüxi i ngecü rü íraxü̃- tama i pãũãrü puxẽẽruü̃maã inaxüéü̃ i taxü̃ i ngĩrü pãũchara. Rü ngẽma pãũãrü puxẽẽruü̃ rü woo naxíra rü nayapuxẽẽ i guxü̃ma i ngĩrü pãũchara —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Rü inixũchigü ga Ngechuchu ga Yerucharéü̃wa na naxũxü̃. Rü yexguma namagu yaxũxgu rü ĩãnegüwa rü ĩãnexãcügüwa nixüpetüchigü, rü yéma nayangúexẽẽtanü ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Rü wüxi ga duü̃xü̃ nüxna naca rü ñanagürü: —Pa Corix ¿noxretátama nixĩ i ngẽma nayauxgüxü̃ i maxü̃ i taguma gúxü̃? —ñanagürü. Rü nüma ga Ngechuchu nanangãxü̃, rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Daxũguxü̃ i naãneãrü ĩã̱x rü naxíraxüchi. ¡Rü paxa naxcèx pedau na nawa pichocuxü̃cèx! Erü pemaã nüxü̃ chixu rü muxũchixü̃ma i duü̃xü̃gü tá nüxü̃́ nangúchaü̃ na nawa yachocuxü̃, natürü tãũtáma nawa nichocu. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","—Erü ngẽxguma ĩãrü yora marü nawãxtagu i ĩã̱x, rü pema i düxétüwa ngẽxmagüxe rü tá penatutuã́ü̃. Rü ñaperügügü tá: “Pa Corix, ¡paxa toxcèx yawãxna i ĩã̱x!” ñaperügügü tá. Natürü nüma i cori rü tá pexü̃ nangãxü̃, rü ñanagürü tá: “Tama pexü̃ chacuèx na ngextácü̱̃ã̱x pixĩgüxü̃”, ñanagürü tá pexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","—Rü ngẽxguma rü tá ñaperügügü nüxü̃: “Cumaãchirẽ́x wüxiwa tachibüe rü taxaxegü. Rü toxü̃ cungúexẽẽ ga torü ĩãneãrü ítamü̃güwa”, ñaperügügü tá. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","—Natürü nüma rü tá pexü̃ nangãxü̃ rü ñanagürü tá: “Marü pemaã nüxü̃ chixu rü tama pexü̃ chacuèx na ngextácü̱̃ã̱xgü pixĩgüxü̃. ¡Rü ípixĩ i nuã chauxü̃tawa i guxãma i pemax, Pa Chixri Maxẽxü̃x!” ñanagürü tá. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","—Rü nge̱ma tá pexauxe, rü tá pixü̃́xchapütagü i ngẽxguma nüxü̃ pedèu̱xgu i Abráü̃ rü Ichaá rü Acobu rü guxü̃ma i Tupanaãrü orearü uruü̃gü na Tupana ãẽ̱xgacü íixĩxü̃wa na nangẽxmagüxü̃ rü pema rü nüxna na ípewoxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","—Erü guxü̃watáma ne naxĩ i duü̃xü̃gü. Rü Tupana ãẽ̱x- gacü íixĩxü̃wa tá nangẽxmagü. Rü nge̱ma tá narütogü na nge̱ma nachibüexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","—Rü tá nangẽxma i nümaxü̃ i ñoma i naãnewa duü̃xü̃gü nüxü̃ oexü̃, natürü daxũguxü̃ i naãnewa rü Tupana tá wixpẽ́xewa nanaxügüxẽẽ. Rü tá nangẽxma i nümaxü̃ i ñoma i naãnewa duü̃xü̃gü nüxü̃ icuèxüü̃güxü̃, natürü daxũguxü̃ i naãnewa rü Tupana rü tá wixweama nanaxügüxẽẽ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Rü yematama ga ngunexü̃gu rü Ngechuchuxü̃tawa nangugü ga ñuxre ga Parichéugü. Rü ñanagürügü Ngechuchuxü̃: —¡Íixũ i nuã! Erü ãẽ̱xgacü ya Erode rü cuxü̃ nimèxéga —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Natürü nüma ga Ngechuchu nanangãxü̃ rü ñanagürü: —¡Naxü̃tawa pexĩ i ngẽma yatü i nüxü̃ cuèxüchixü̃ na ñuxãcü duü̃xü̃güxü̃ nawomüxẽẽxü̃, rü namaã nüxü̃ pixu rü ñu̱xma rü moxü̃ rü tá íchana- woxü̃ i ngoxogü, rü tá chanameẽxẽẽ i ngẽma duü̃xü̃gü i iḏaaweexü̃, rü pèxmaãcü tá chanagu̱xẽẽ! ");
INSERT INTO tcaNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","—Natürü chanaxwèxe i ichixũchigü i ñu̱xma rü moxü̃ rü paxmaãcü ñu̱xmatáta Yerucharéü̃wa changu. Erü Yerucharéü̃gu nixĩ i na nayuexü̃ i guxü̃ma i Tupanaãrü orearü uruü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—Rü dücax, Pa Yerücharéü̃cü̱̃ã̱x, pema peyadaietanü i Tupanaãrü orearü uruü̃gü, rü nutamaã ípenamuxũchigü i Tupanaãrü orearü ngeruü̃gü i pexcèx núma namugüxü̃. Rü ñuxreẽ́xpü̱xcüna wüxigu chaugüxü̃tagu pexü̃ chanutaquẽ́xexẽẽchaü̃, ñoma wüxi i ota ya naxãcüã̱x nügütüü̃gu tüxü̃ nutaquẽ́xexü̃rüü̃. Natürü pema rü tama penaxwèxe. ");
INSERT INTO tcaNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","—Dücèx i ñu̱xma ya perü ĩãne, rü Tupana tá ínanatèx. Rü pemaã nüxü̃ chixu rü tãũtáma wena choxü̃ pedau ñu̱xmatáta daxũguxü̃ i naãnewa ne chaxũ. Rü ngẽxguma rü tá choxü̃ pedau rü tá ñaperügügü: “Namexẽchi nixĩ ya yima Cori ya Tupana núma namucü”, ñaperügügü tá —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Rü wüxi ga ngü̃xchigaarü ngunexü̃gu rü Ngechuchu rü wüxi ga Parichéupatawa nayachibü. Rü yéma nayexmagü ga togü ga Parichéugü ga yéma bexma Ngechuchuxü̃ ngugüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Rü yéma nayexma ta ga wüxi ga yatü ga iḏaawexü̃ ga rüchaxünexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Rü yexguma ga Ngechuchu rü yema ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃na rü Parichéugüna naca, rü ñanagürü: —¿Tama penachu̱xuxü̃ ega ngü̃xchigaarü ngunexü̃gu chanamexẽẽ̱xgu i wüxi i iḏaawexü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Natürü ga nümagü rü nangeèxgümare. Rü yexguma ga Ngechuchu rü naxmẽ́xgu nayayauxãchi ga yema iḏaawexü̃, rü nanamexẽẽ. Rü namaã nüxü̃ nixu ga na íyaxũxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Rü Ngechuchu rü ñanagürü Parichéugüxü̃: —¿Texé i pema i ngẽxguma perü buru rü ẽ́xna perü woca puchugu nagoxgu, rü taux ẽ́xna i ngẽxgumatama ípeyadauxü̃ rü ípe- yatúãchixü̃ i woo ngü̃xchigaarü ngunexü̃gu? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Rü nümagü rü taxuü̃maãma nanangãxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Rü yexguma mechawa natogüchaü̃gu ga yema nüxna naxugüxü̃, rü Ngechuchu nüxü̃ nadau na wüxichigü rü ĩãrü yoraxü̃tawaxüchi natoxchaü̃xü̃. Rü yexguma yemaxü̃ nadèu̱xgu rü nayaxucu̱xẽgü, rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ngẽxguma texé cuxna uxgu i wüxi i ngĩgüarü petawa, rü tama name i petaarü yoraxü̃tawaxüchi üxü̃ i naxmèxwẽ́xewa cuyarüto. Erü yixcüra ngürüãchi tá ínangu i to i nüxna naxuxü̃ i curü yexeraxüchi ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","—Rü ngẽma petaarü yora i pexna uxü̃, rü tá cumaã nüxü̃ nayarüxu na icuchixü̃cèx i ngẽma nachicawa na nge̱ma natoxẽẽãxü̃cèx i ngẽma to i curü yexera ixĩxü̃. Rü ngẽxguma i cuma rü poraãcü cuxãneãcüma rü nawa iyacuáxü̃ i naxmèxwẽ́xewa tá cuyarüto. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","—Rü narümemaẽ ega texé cuxna uxgu, rü nawa iyacuáxü̃ i naxmèxwẽ́xewa curüto. Rü ngẽxguma i ngẽma petaarü yora i cuxna uxü̃ rü ñanagürü tá cuxü̃: “Pa Chomücüx, ¡nuã chauxü̃tawa yarüto!” ñanagürü tá cuxü̃. Rü ngẽmaãcü ngẽma petaarü yora rü wüxi i mexü̃ tá cumaã naxü napẽ́xewa i guxü̃ma i duü̃xü̃gü i nüxna naxuxü̃ i cumaã nge̱ma rütogüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","—Erü texé ya tügü írütaxe rü Tupana tá tüxü̃ naxãnexẽẽ. Natürü texé ya tügü írüxíraxe rü Tupana tá tüxü̃ nicuèxüü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Rü ñanagürü ta ga Ngechuchu nüxü̃ ga yema yatü ga nüxna uxü̃: —Rü ngẽxguma wüxi i õnacèx rü ẽ́xna petacèx texéna cuxuxchaü̃gu, rü tama name i nüxna cuxu i cumücügü, rü bai i cueneẽgü, rü bai i cutanüxü̃gü, rü bai i curü ngaicamagu pegüxü̃ i duü̃xü̃gü i dĩẽruã̱xgüxü̃. Erü nümagü rü tá nüxĩ cuxna naxugüe, rü ngẽmaãcü tá cuxü̃́ nanaxütanügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","—Natürü ngẽxguma wüxi i peta cuxü̱xgu, rü narümemaẽ nixĩ i nüxna cuxu i duü̃xü̃gü i ngearü dĩẽruã̱xgüxü̃, rü duü̃xü̃gü i taxucürüwama puracüexü̃, rü ngẽma ichixeparagüxü̃, rü ngẽma ingexetügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","—Rü tá cutaãẽxü̃chi i ngẽxguma erü nümagü rü taxucürüwa cuxü̃́ nanaxütanügü. Natürü tá cunayaxu i curü natanü i ngẽxguma wena namaxẽgu i Tupanaãrü duü̃xü̃gü i mexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Rü yexguma yemaxü̃ naxĩnügu ga wüxi ga yatü ga mechawa rütoxü̃ rü Ngechuchuxü̃ ñanagürü: —Rü tataãẽ ya yíxema Tupana ãẽ̱xgacü íixĩxü̃wa chibüxe —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Wüxi ga yatü nanaxü ga wüxi ga õna ga taxü̃. Rü norü duü̃xü̃xü̃ namu na nüxna yaxuxü̃cèx ga muxü̃ma ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","—Rü yexguma marü namexgu ga norü õna, rü wena norü duü̃xü̃xü̃ namu na yema duü̃xü̃gü ga marü nüxna naxugüxü̃maã nüxü̃ na yanaxuxü̃cèx ga marü na namemarexü̃ ga norü õna, rü paxa yéma na naxĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","—Natürü guxü̃ma ga yema nüxna naxugüxü̃, rü inanaxügü ga nügü na ínaxuegüxü̃. Rü yema nüxĩra nüxna naxu rü ñanagürü: “Ngexwacaxtama naxcèx chataxe i wüxi i naãne. Rü paxa tá íchayadau. ¡Rü namaã nüxü̃ ixu i cori rü taxucürüwama nge̱ma chaxũ!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","—Rü ga yema to rü ñanagürü: “10 i wocagü i puracüruü̃cèx chataxe, rü tá ngẽmaxü̃ chayaxü. ¡Rü namaxã nüxü̃ ixu i cori rü taxucürüwama nge̱ma chaxũ!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","—Rü ga to rü ñanagürü: “Ngexwacaxtama chaxãmèx rü ngẽmacèx taxucürüwama nge̱ma chaxũ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","—Rü yexguma nataegugu ga yema coriarü duü̃xü̃, rü norü corimaã nüxü̃ nixu ga guxü̃ma ga yema ore. Rü yexguma ga norü cori rü nanu, rü ñanagürü nüxü̃ ga norü duü̃xü̃: “¡Paxa nge̱ma ĩtamügü i taxü̃wa rü ĩtamüacügüwa naxũ, rü nuã nagagü i ngẽma duü̃xü̃gü i ngearü dĩẽruã̱xgüxü̃, rü ngẽma duü̃xü̃gü i taxucürüwama puracüexü̃, rü ngẽma ichixeparagüxü̃, rü ngẽma ingexetügüxü̃!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","—Rü yixcamaxü̃ra ga yema norü cori namaã nüxü̃ ixuxü̃ naxü̱xguwena rü yema norü duü̃xü̃ ñanagürü nüxü̃: “Pa Corix, marü chanaxü i ngẽma chomaã nüxü̃ quixuxü̃rüü̃, natürü naxãchicaaneãmatama i nuã cupatawa”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","—Rü yexguma ga norü cori rü ñanagürü nüxü̃: “¡Paxa nge̱ma nama i taxü̃güwa rü nama i íraxü̃güwa naxũ, rü nuã nagagü i togü i duü̃xü̃gü na nuxã chopatagu nachocuxü̃cèx, rü ngẽmaãcü na naxããcuxü̃cèx ya daa chopata! ");
INSERT INTO tcaNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Erü pemaã nüxü̃ chixu rü taxuü̃ma ga yema nüxĩra nüxna chaxuxü̃ rü nuã chorü õnawa tá nachibüe”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Rü muxũchixü̃ma ga duü̃xü̃gü Ngechuchuwe narüxĩ. Rü nadauegu ga Ngechuchu, rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Rü ngẽxguma texé chowe rüxũxchaü̃gu, rü tanaxwèxe i choxü̃ tangechaü̃ tümanatüarü yexera, rü tümaẽãrü yexera, rü tümamèxãrü yexera, rü tümaxãcügüarü yexera, rü tümaẽneẽgüarü yexera, rü tümaẽyèxgüarü yexera, rü tümaãrü maxü̃ãrü yexera rü ta. Rü ngẽxguma tama ngẽmaãcü choxü̃ tangechaü̃gu rü taxucürüwama aixcüma chorü ngúexü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","—Rü yíxema tama naxwèxexẽ na chaugagu ngúxü̃ tingeãcüma chowe tarüxũxü̃, rü taxucürüwama chorü ngúexü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—Rü ngẽxguma chi wüxie i petanüwa rü wüxi ya ĩpata ya taxü̃ne taxüxchaü̃gu, ¿rü tama ẽ́xna i noxri i tanangugüxiraxü̃ na ñuxre i dĩẽru tá nagu ngĩxü̃ ítatáxü̃? Rü ngẽmawa nüxü̃ tacuèx rü marü tüxü̃́ iyangu i ngẽma tümaãrü dĩẽru i tüxü̃́ ngẽxmacü na tayanguxẽẽxü̃cèx ya yima ĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","—Erü ngẽxguma chi tama meã tanangugügu i tümaãrü dĩẽru na ñuxregu tá naxãtanüxü̃ ya yima ĩ, rü norü caxtaxica chi itapugügu rü yixcüra rü taxucürüwa chi tanagu̱xẽẽgu i ngẽma puracü, rü guxü̃ma i duü̃xü̃gü i nüxü̃ daugüxü̃ i ngẽma tümaãrü puracü rü tá tüxü̃ nacugüe. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","—Rü ñanagürügü tá: “Ngẽma yatü inanaxügü na naxüpataxü̃, natürü taxucürüwama nayanguxẽẽ”, ñanagürügü tá. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","—Rü ngẽxguma wüxi i nachiü̃ãneãrü ãẽ̱xgacü rü to i nachiü̃ãneãrü ãẽ̱xgacümaã nügü nadaixchaü̃gu, ¿rü tama ẽ́xna i noxri inangugüãxü̃ rü ngoxi 10,000 i churaragü rü yangu na nügü nadaixü̃cèx namaã i norü uwanü i 20,000 i churaragü nüxü̃́ ngẽxmaxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","—Rü ngẽxguma nangugüãgu na tama yanguxü̃ i norü churaragü rü, ¿taux ẽ́xna i ngẽxguma yaxü̃wa nangẽxmagutama i norü uwanü, rü naxü̃tawa namugüãxü̃ i norü orearü ngeruü̃gü, rü namaã nüxü̃ na yanaxugüexü̃cèx na nügümaã nangüxmüẽxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","—Rü ngẽxgumarüü̃ tá ta nixĩ i pemax, erü ngẽxguma ngexerüxǘxe i petanüwa tama nge̱ma tanawogügu i guxü̃ma i tüxü̃́ ngẽxmaxü̃ na chowe tarüxũxü̃cèx, rü taxucürüwama aixcüma chorü ngúexü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Pema rü ñoma yucürarüü̃ pixĩgü i ñoma i naãnewa, erü yima yucüra rü õna na namexẽẽxü̃rüü̃ rü pema rü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gütanüwa rü norü mexẽẽruü̃ pixĩgü. Name ya yucüra. Natürü ngẽxguma chi nangeacagu, ¿rü ñuxãcü tá wenaxãrü naxããca? ");
INSERT INTO tcaNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","—Rü taxuwama name. Rü woo waixü̃müãrü waxmüãnexẽẽruü̃cèx rü tama name. Rü ítanatèxmare. Rü yíxema aixcüma ãchi̱xe̱xẽ, ¡rü name nixĩ i nagu tarüxĩnüẽ i ñaã ore! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Rü guxü̃ma ga yema yatügü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ideetanüxü̃, rü togü ga duü̃xü̃gü ga chixexü̃ ga nacümagu ĩxü̃, rü Ngechuchucèx naxĩ na iyanaxĩnüẽxü̃cèx ga norü ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Rü yemacèx ga Parichéugü rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü Ngechuchuxü̃ nixugüe, rü ñanagürügü: —Ñaã yatü rü norü me nixĩ i pecaduã̱xgüxü̃maã na naxãmücüxü̃, rü namaã na nachibüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Rü yexguma ga Ngechuchu rü ñaã ore ga cuèxruü̃xü̃ namaã nixu, rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Texé i petanüwa rü ngẽxguma tüxü̃́ nangẽxmagu i 100 i tümaãrü carnerugü rü wüxi tüxü̃́ iyarütau̱xgu, rü taux ẽ́xna i nachitaü̃wa tanawogüxü̃ i ngẽma 99, rü naxcèx tayadauxü̃ i ngẽma tüxü̃́ iyarütaxuxü̃ ñu̱xmata nüxü̃ itayangau? ");
INSERT INTO tcaNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","—Rü ngẽxguma nüxü̃ itayangèu̱xgu rü taãẽãcüma tügüãtügu tayagaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","—Rü ngẽxguma tümapatawa tanguxgu, rü tanangutaquẽ́xexẽẽ i tümamücügü, rü duü̃xü̃gü i tümaãrü ngaicamagu pegüxü̃, rü ñatagüxü̃ nüxü̃: “¡Wüxigu chomaã petaãẽgü, Pa Chomücügüx! Erü marü nüxü̃ ichayangau i ngẽma chorü carneru ga iyarütaxuxü̃”, ñatagüxü̃ nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","—Rü pemaã nüxü̃ chixu rü ngẽxgumarüü̃ ta nataãẽgü i daxũcü̱̃ã̱x i ngẽxguma nangẽxmagu i 99 i duü̃xü̃gü i mexü̃gü i marü Tupanaãrü ixĩgüxü̃, natürü yexeraãcü nataãẽgü i ngẽxguma wüxi i duü̃xü̃ i pecaduã́xü̃ nüxü̃ rüxo̱xgu i nacüma i chixexü̃ rü Tupanaãxü̃́ yaxõõgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Rü Ngechuchu rü wüxi ga to ga ore ga cuèxruü̃xü̃ nixu, rü ñanagürü: —Ngẽxguma chi wüxi i ngecüaxü̃́ nangẽxmagu i 10 tachinü i dĩẽru, rü wüxi ngĩxü̃́ iyarütau̱xgu, ¿rü taux ẽ́xna i omüwa nangixichiãxü̃ rü nabixichiãxü̃ ya ngĩpata, rü meãma ngĩxcèx nadauxü̃ ñu̱xmata ngĩxü̃ iyangau? ");
INSERT INTO tcaNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","—Rü ngẽxguma ngĩxü̃ iyangauxgu, rü inangutaquẽ́xexẽẽ i ngĩmücügü i ngexü̃gü rü ngĩtanüxü̃gü i ngĩrü ngaicamagu pegüxü̃, rü ngĩxü̃ nüxü̃: “¡Wüxigu chomaã petaãẽgü, Pa Chomücügüx! Erü marü ngĩxü̃ ichayangau i ngẽma chorü dĩẽru ga iyarütau̱xchirẽ́xcü”, ngĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","—Rü pemaã nüxü̃ chixu rü ngẽxgumarüü̃ ta nataãẽgü i daxũcü̱̃ã̱x i Tupanaãrü orearü ngeruü̃gü i ngẽxguma wüxi i duü̃xü̃ i pecaduã́xü̃ nüxü̃ rüxo̱xgu i nacüma i chixexü̃ rü Tupanaãxü̃́ yaxõõgu —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Rü ñanagürü ta ga Ngechuchu: —Nayexma ga wüxi ga yatü ga taxre ga nane nüxü̃́ yexmacü. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","—Rü guma rübumaẽcü, rü nanatüxü̃ ñanagürü: “Pa Pa, ¡choxna naxã i ngẽma curü ngẽmaxü̃gü i choxna üxü̃!” ñanagürü. Rü yexguma ga nanatü rü yema taxre ga nanemaã nayatoye ga norü yemaxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","—Rü ñuxre ga ngunexü̃guwena rü guma nane ga rübumaẽcü rü nananutaquẽ́xe ga guxü̃ma ga norü yemaxü̃gü rü namaã nataxe. Rü yema dĩẽrumaã rü to ga nachiü̃ãnewa naxũ. Rü chixri yéma namaxü̃, rü yemaãcü ngĩxü̃ nagu̱xẽẽ ga gu̱xcüma ga norü dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","—Natürü yexguma marü ngĩxü̃ nagu̱xẽẽguwena ga gu̱xcüma ga norü dĩẽru, rü poraãcü nataxu ga õna ga yema nachiü̃ãnewa. Rü yemacèx ga guma ngextü̱xücü rü inanaxügü ga taiya nüxü̃́ na ngúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","—Rü yexguma rü norü puracücèx nadau naxü̃tagu ga wüxi ga yatü ga yema nachiü̃ãnecü̱̃ã̱x. Rü nüma ga yema yatü rü norü naãnewa nanamu na yéma norü cuchigüna yadauxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","—Rü düxwa nüxü̃́ nachi̱xéga ga yema cuchiwemü, yerü poraãcü nataiyaxüchi. Natürü taxúema õna nüxna taxã. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","—Rü yexguma naãẽwa nagu narüxĩnü, rü ñanagürü: “¿Ñuxre i chaunatüarü puracütanüxü̃ rü nüxü̃́ nangẽxma i õna rü nüxü̃́ ínayaxü? Rü choma i nuã rü taiyamaã tá nuxma chayu. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","—Rü chaunatücèx tá chataegu, rü ñachagürü tá tüxü̃: ‘Pa Papax, marü chixexü̃ Tupanapewa chaxü rü cupewa rü ta. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","—Rü tama marü chame na Chaune, ñacuxü̃ choxü̃. ¡Rü wüxi i curü puracütanüxü̃xü̃ choxü̃ ixĩxẽẽ!’ ñacharügü tá tüxü̃ ya chaunatü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","—Rü inaxũãchi rü nanatüpatacèx nataegu. Rü yexguma yangaicagu ga nanatüpata, rü yaxü̃gu nüxü̃ tadau ga nanatü, rü tüxü̃́ nangechaü̃tümüü̃. Rü naxcèx tiña, rü nüxna tanèĩ̱xãchi, rü nüxü̃ tachúxu. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","—Rü yexguma ga nüma ga tümane rü ñanagürü tüxü̃: “Pa Papax, marü chixexü̃ Tupanapewa chaxü, rü cupewa rü ta. Rü ngemacèx marü tama name na ‘Chaune’ ñacuxü̃ choxü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","—Natürü tüma ga nanatü rü tümaãrü duü̃xü̃güxü̃ ñatarügü: “¡Paxa nuã penange i naxchiru i mexẽchixü̃ rü peyacu̱xcuchi̱x! ¡Rü wüxi i anera ta naxmẽ́xwa ngĩxü̃ pingèxcuchix! ¡Rü chapatu rü ta nuãta penge, rü peyacuaixcuchix! ");
INSERT INTO tcaNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","—¡Rü peyayaxu̱x i ngẽma wocaxacü i rüngümaexü̃, rü peyamá, rü ngĩxã namaã tachibüe rü tapetae! ");
INSERT INTO tcaNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","—Erü daa chaune rü chauxcèx rü marü nayu, natürü maxü̃cü chauxcèx ínangu. Rü marü inayarütauxchirẽ́x, rü wenaxãrü nango̱x”, ñanagürü. Rü yexguma inanaxügüe ga na napetaegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","—Rü yoxni ga guma nane ga rüyamaẽcü, rü naãnewa nayexma. Rü yexguma nataegugu rü marü ĩãrü ngaicamana nangugu, rü nüxü̃ naxĩnü ga na ínapaxetagüxü̃ rü íyaxü̃ãchitanüxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","—Rü wüxi ga nanatüarü duü̃xü̃cèx naca, rü nüxna naca ga ṯacü na ínaxüexü̃ ga ĩwa. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","—Rü yema nanatüarü duü̃xü̃ rü nanangãxü̃, rü ñanagürü: “Cueneẽ rü marü ínangu. Rü ngẽmacèx cunatü toxü̃ tamu na tayamáxü̃cèx i ngẽma wocaxacü i rüngümaexü̃, erü cueneẽ rü mecü ínangu rü tama niḏaawe”, ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","—Natürü ga guma naẽneẽ ga rüyamaẽcü rü nanu, rü tama ĩgu naxücuchaü̃. Rü yemacèx düxwa ga nanatü rü naxcèx ítaxũxũ, rü nüxü̃ tayacèèxü̃ na yaxücuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","—Rü nüma rü ñanagürü tüxü̃ ga nanatü: “Cuma nüxü̃ cucuèx i ñuxre ya taunecü cuxü̃́ chapuracü, rü taguma chixri cuga chaxĩnü. Rü bai i ñuxgu wüxicana wüxi i chibuxacü choxna cumu na chomücügümaã chapetaexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","—Natürü ñu̱xma na ínanguxü̃ i ngẽma cune i chixri curü dĩẽru ngĩxü̃ gu̱xẽẽxü̃ nagu i ngexü̃gü i ngẽãẽxü̃, rü naxcèx cuyamèx i ngẽma wocaxacü i rüngümaexü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","—Rü yexguma ga nanatü rü ñatarügü nüxü̃: “Pa Chaunex, cuma rü guxü̃guma chauxü̃tawa cungẽxma, rü guxü̃ma i chorü ngẽmaxü̃gü rü cuxrü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","—Natürü ñu̱xma rü name nixĩ na ipetaegüxü̃ rü na itaãẽgüxü̃ erü cueneẽ ga guma chauxcèx rü marü yucü, rü maxü̃cü taxcèx ínangu. Rü woo tüxna inayarütaxu, rü wenaxãrü taxcèx nango̱x”, ñatarügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Rü ñanagürü ta ga Ngechuchu norü ngúexü̃güxü̃: —Nayexma ga wüxi ga cori ga muãrü yemaxü̃ã̱xü̃chixü̃. Rü nüxü̃́ nayexma ga wüxi ga norü duü̃xü̃ ga norü yemaxü̃ãrü dauruü̃. Natürü togü ga duü̃xü̃gü rü norü corimaã nüxü̃ nixugü na yema norü duü̃xü̃ rü chixri norü yemaxü̃na na nadauxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","—Rü yexguma ga yema cori rü yema norü duü̃xü̃cèx naca, rü ñanagürü nüxü̃: “Dücèx, cuchigaxü̃ chomaã nixugügü i duü̃xü̃gü. ¿Rü ṯacü nixĩ i ngẽma? ¡Rü chomaã nüxü̃ ixu rü ñuxãcü nixĩ i curü puracü, erü marü tãũtáma chorü ngẽmaxü̃ãrü dauruü̃xü̃ cuxü̃ chixĩxẽẽ!” ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","—Rü yexguma ga yema coriarü duü̃xü̃ rü nagu narüxĩnü, rü nügüãẽwa ñanagürü: “¿Ṯacü tá chaxü i ñu̱xmax, erü chorü cori rü marü choxü̃ ínatèxüchi i ngẽma chorü puracüwa? Tama chapora na naãnewa chapuracüxü̃cèx, rü chaxãne na dĩẽrucèx na íchac̱axü̃ nüxna i togü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","—Rü marü nüxü̃ chacuèx na ṯacü tá na chaxüxü̃ na choxü̃́ nangẽxmaxü̃cèx na texé tümapatawa choxü̃ yaxuxü̃ i ngẽxguma changearü puracüã̱xgu”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","—Rü yexguma nügüxü̃tawa naxcèx naca ga wüxichigü ga yema duü̃xü̃gü ga norü coriaxü̃́ yangetanügüxü̃. Rü yema nüxĩra yéma naxü̃tawa nguxü̃na naca, rü ñanagürü: “¿Ñuxre i nüxü̃́ cungetanüxü̃ i chorü cori?” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","—Rü nüma nanangãxü̃, rü ñanagürü: “Nüxü̃́ chanangetanü i 100 i data i chixü̃”, ñanagürü. Rü yema coriarü duü̃xü̃ rü ñanagürü nüxü̃: “Ñaã nixĩ i popera i curü ngetanü nawa ngóxü̃. ¡Rü paxa írüto rü to i popera naxü, rü 50 i dataguxicatama naxü i curü ngetanü!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","—Rü yemawena rü yema to ga duü̃xü̃ ga norü coriaxü̃́ nangetanüxü̃na naca, rü ñanagürü: “¿Cuma rü ñuxre yiĩxü̃ i nüxü̃́ cungetanüxü̃ i chorü cori?” ñanagürü. Rü nüma rü nanangãxü̃, rü ñanagürü: “Nüxü̃́ chanangetanü i 100 i choca i trigu”, ñanagürü. Rü yema coriarü duü̃xü̃ rü ñanagürü nüxü̃: “Ñaã nixĩ i popera i curü ngetanü nawa ngóxü̃. ¡Rü paxa írüto rü to i popera naxü rü 80 i chocaguxicatama naxü i curü ngetanü!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","—Rü norü cori rü nüxü̃ nicuèxüü̃ãma ga yema norü duü̃xü̃ ga chixexü̃, yerü nüxü̃ nadau ga ñuxãcü na naxããẽxü̃chixü̃. Rü pemaã nüxü̃ chixu rü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü, rü ngẽma Tupanaãxü̃́ yaxõgüxü̃ i duü̃xü̃güarü yexera paxa naxcèx nadaugü na ñux- ãcü nüxü̃ natúxü̃ i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","—Rü pemaã nüxü̃ chixu rü ngẽma ñoma i naãne i chixexü̃wa pexü̃́ ngẽxmaxü̃ rü name nixĩ i ngẽmamaã nüxü̃́ penangúchaü̃xẽẽ i duü̃xü̃gü na Tupanaxü̃tawa nangugüxü̃. Rü ngẽmaãcü i ngẽxguma nagu̱xgu i ngẽma ñoma i naãnewa pexü̃́ ngẽxmaxü̃ rü peyu̱xgu, rü tá pexü̃́ nangẽxma ya Penatü ya pexü̃ yaxucü i daxũguxü̃ i naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","—Yíxema meã namaã icuáxe ega woo noxretama tümamẽ́xẽwa ngẽxmagu, rü ngẽxguma muxü̃ma tümamẽ́xẽwa ngẽxmagu rü tá ta meã namaã itacuèx. Natürü yíxema chixri namaã icuáxe ega noxretama tümamẽ́xẽwa ngẽxmagu, rü ngẽxguma muxü̃ma tümamẽ́xẽwa ngẽxmagu rü ngẽxgumarüü̃ tá ta chixri namaã itacuèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","—Rü ngẽxguma tama meã namaã ipecuèxgu i ngẽma pexmẽ́xwa ngẽxmaxü̃ i ñoma i naãne i chixexü̃wa, ¿rü texé tá pexmẽ́xgu tanaxü i ngẽma aixcüma mexü̃ i Tupanaãrü ixĩxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","—Rü ngẽxguma tama meã namaã ipecuèxgu i ngẽma Tupana pexna ãxü̃ i ñoma i naãnewa, ¿rü ñuxãcü tá pexna nanaxã i pechica i daxũguxü̃ i naãnewa? ");
INSERT INTO tcaNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","—Taxucürüwama i wüxi i duü̃xü̃ rü nataxrearü coriã̱x. Erü wüxi i norü corichi rü tá naxai, rü ngẽma to rü tá nüxü̃ nangechaü̃. Rü ẽ́xna wüxicèx rü tá meã napuracü rü ngẽma to rü tá nüxü̃ naxo. Rü pema rü taxucürüwama Tupanacèx pemaxẽ ega perü dĩẽruguxicatama perüxĩnüẽgu —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Natürü ga yema Parichéugü rü poraãcü norü dĩẽruguama narüxĩnüẽ. Rü yemacèx Ngechuchuxü̃ nacugüe ga yexguma nüxü̃ naxĩnüẽgu ga guxü̃ma ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Pema nixĩ i duü̃xü̃güpẽ́xewa meã pemaxẽnetaxü̃, natürü Tupana pexü̃ nacuèx na ṯacügu perüxĩnüẽxü̃. Rü woo duü̃xü̃gü pexü̃ nicuèxüü̃gü naxcèx i ngẽma pexüxü̃, natürü Tupana rü naãẽwa nangu̱x i ngẽma —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Rü yexguma ga Ngechuchu rü ñanagürü: —Noxri nayexma ga Tupanaãrü mugü ga Moĩché duü̃xü̃güxü̃ ngu̱xẽẽxü̃, rü yema ngu̱xẽẽtae ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü duü̃xü̃güxü̃ namaã ngu̱xẽẽxü̃. Natürü yexguma Cuáü̃ ga baiü̃xẽẽruü̃ ínguxguwena, rü marü duü̃xü̃gümaã nüxü̃ chixuchiga i Tupanaãrü ore i mexü̃ i ñuxãcü ãẽ̱xgacü na yiĩxü̃. Rü ñu̱xma rü guxü̃ma i ngẽma duü̃xü̃gü rü poraãcü nügü naporaexẽẽ na yachocuxü̃cèx i nge̱ma Tupana ãẽ̱xgacü íixĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","—Naxü̃pa na yanguxü̃ i Tupanaãrü mugü rü woo wüxi i mu i íramarexü̃ yixĩgu, rü naguxchaxüchi na iyanaxoxü̃ i ngẽma nüxü̃ yaxuxü̃. Natürü aixcüma narütauxchamaẽ nixĩ na iyanaxoxü̃ i ñoma i naãne rü guxü̃ma i ngẽma daxũwa nüxü̃ idauxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Ngẽxguma wüxi ya yatü ítámèxgu rü naĩ i ngemaã naxãmèxgu rü Tupanapẽ́xewa rü pecadu naxü. Rü texé ya yíxema ngĩmaã ãmaxẽ i wüxi i nge i ngĩte ngĩxü̃ ítèxcü, rü Tupanapẽ́xewa rü tüma rü ta pecadu taxü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Nayexma ga wüxi ga yatü ga dĩẽruã̱xü̃chixü̃ ga guxü̃guma mexẽchixü̃ ga naxchirugu icúxü̃. Rü guxü̃ ga ngunexü̃gu rü taxü̃ma ga õna naxü rü napetaexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","—Rü nayexma ta ga wüxi ga yatü ga ngearü dĩẽruã́cü ga Dácharugu ãe̱gacü. Rü guxü̃guma yema dĩẽruã̱xü̃chixü̃pataèxwa nayarütooxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","—Rü guma Dácharu rü nanangṍxchaü̃ ga yema õnatüchi ga yema yatü ga dĩẽruã̱xü̃chixü̃ãrü mechawa rüyiiixü̃. Rü naxcèx naxĩ ga airugü, rü nanawearü o̱xriã̱xgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","—Rü wüxi ga ngunexü̃ nayu ga guma ngearü dĩẽruã́cü, rü daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃gü rü daxũguxü̃ ga naãnewa nanagagü na wüxiwa Abráü̃maã nayexmaxü̃cèx. Rü nayu ta ga yema yatü ga dĩẽruã̱xü̃chixü̃, rü inayatèxgü ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","—Rü ngẽma nachica i Tupana ngoxogüxü̃ nagu poxcuxü̃wa naxũ ga yema yatü ga dĩẽruã̱xü̃chixü̃ rü yéma poraãcü ngúxü̃ ninge. Rü daxũ nadau, rü yaxü̃gu Abráü̃xü̃ nadau na Dácharumaã wüxiwa nayexmaxü̃ ga daxũguxü̃ ga naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","—Rü yexguma ga yema yatü ga dĩẽruã̱xü̃chichiréxü̃ rü aita naxü rü ñanagürü: “Pa O̱xi Pa Abráü̃x, ¡cuxü̃́ changechaü̃tümüü̃, rü nuã namu ya Dácharu na dexámaã nügü yawaixpẽ́xemẽ́xẽãcüma choxü̃ yanawaixpẽ́xearü conüã́xü̃cèx! Erü poraãcü choxü̃́ nangu̱x i nuã üxüwa”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","—Natürü Abráü̃ rü ñanagürü nüxü̃: “Pa Chaunex, ¡nüxna nacuèxãchi na taxuü̃ma cuxü̃́ taxuxü̃ ga yexguma cumaü̃xgu! Natürü Dácharu rü poraãcü chixexü̃ nüxü̃ naxüpetü. Rü ngẽmacèx i ñu̱xma rü nuã mexü̃wa nangẽxma, rü cuma rü nge̱ma poxcuchicawa ngúxü̃ quinge. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","—Rü ñu̱xũchi nangẽxma i wüxi i taxüchixü̃ i ngatexü̃ i tórü ngãxü̃wa üxü̃. Rü ngẽmacèx ega númacü̱̃ã̱x nge̱ma ĩxchaü̃gu, rü taxucürüwama nge̱ma naxĩ. Rü woo nge̱macü̱̃ã̱x núma ĩxchaü̃gu rü taxucürüwama núma naxĩ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","—Rü yexguma ga yema yatü ga dĩẽruã̱xü̃chichiréxü̃ rü ñanagürü: “Cuxü̃ chacèèxü̃, Pa O̱xi, Pa Abráü̃x, na chaunatüpatawa cunamuxü̃cèx ya Dácharu. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","—Erü nge̱ma nangẽxmagü ya wüximẽ́ẽ̱xpü̱x ya chaueneẽgü. Rü chanaxwèxe na namaã nüxü̃ na yanaxuxü̃cèx na tama nuã ñaã poxcuchica i poraãcü choxü̃́ ínangúxü̃wa naxĩxü̃cèx”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","—Natürü ga Abráü̃ rü ñanagürü nüxü̃: “Cueneẽgü nüxü̃́ nangẽxma i Tupanaãrü mugü ga Moĩché ümatüxü̃ rü yema ore ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü ümatüxü̃. Rü name nixĩ i ngẽma orega na naxĩnüẽxü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","—Rü yexguma ga yema yatü ga dĩẽruã̱xü̃chichiréxü̃ rü Abráü̃xü̃ nangãxü̃, rü ñanagürü: “Ngẽmáãcü, Pa O̱xi, Pa Abráü̃x, natürü ngẽxguma chi wüxi i duü̃xü̃ i yuchiréxü̃ nge̱ma ũxgu rü namaã nüxü̃ yanaxuxgu, rü chi nüxü̃ narüxoe i nacüma i chixexü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","—Natürü Abráü̃, rü ñanagürü nüxü̃: “Ngẽxguma tama naga naxĩnüẽgu ga yema ore ga Moĩché ümatüxü̃ rü yema ore ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü ümatüxü̃, rü woo chi wüxi i marü yuwa írüdaxü̃ i duü̃xü̃ nge̱ma ũxgu, rü namaã nüxü̃ yanaxuxgu i ore, rü tãũ chima nüxü̃́ nayaxõgü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Rü Ngechuchu rü norü ngúexü̃güxü̃ ñanagürü: —Rü guxü̃gutáma nangẽxma i ṯacü i duü̃xü̃güxü̃ pecaduã̱xẽẽxü̃. Natürü wüxi i ngechaü̃ tá tümacèx nixĩ ya yíxema duü̃xẽ ya togüxü̃ pecadugu nguxẽe̱xẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","3","—Rü tümacèx rü narümemaẽ nixĩ na tümanaxãwa yangacuchixü̃ ya wüxi ya nuta ya tacü rü ngẽmaãcü taxtüwa tüxü̃ na itáexü̃ naxü̃pa na pecadugu tananguxẽẽxü̃ i wüxi i chorü duü̃xü̃. ¡Rü ngẽmacèx name nixĩ i pexuãẽgü i pemax! Rü ngẽxguma wüxi i cueneẽ chixexü̃ cumaã ü̱xgu rü ¡meã naxuxcu̱xẽ! Rü ngẽxguma nüxü̃ naxoxgu i nacüma i chixexü̃ rü ¡nüxü̃́ nüxü̃ nangechaü̃ i ngẽma! ");
INSERT INTO tcaNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","—Rü woo 7 ẽ́xpü̱xcüna chixexü̃ cumaã naxü̱xgu i wüxi i ngunexü̃gu, rü 7 ẽ́xpü̱xcüna cuxna yacaxgu na nüxü̃́ nüxü̃ cungechaü̃xü̃cèx, rü name nixĩ i nüxü̃́ nüxü̃ cungechaü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Rü norü ngúexü̃gü ga norü orearü uwa namugüxü̃ rü ñanagürügü: —Pa Corix, ¡toxü̃ rüngü̃xẽẽ na yexeraãcü tayaxõgüxü̃cèx! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Rü yexguma ga Cori ga Ngechuchu rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Rü ngẽxguma chi woo naxíraxüchigu i perü õ, rü daa naĩ rü chi pega naxĩnü ega ñapegügu: “¡Cugü nabẽ́x i nuã rü taxtüchiügu cugü yato!” ñapegügu, rü chi pega naxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Ngẽxguma chi wüxie i petanüwa rü tüxü̃́ nangẽxmagu i wüxi i tümaãrü duü̃xü̃ i tümaãnewa ne ũxü̃ i puracüwa rü ẽ́xna carneruarü dauwa, rü tama nügücèxira naxüwemü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","—Natürü norü corixü̃xĩra naxüwemü na nachibüxü̃cèx rü naxaxexü̃cèx, rü nüma rü yixcama nachibü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","—Rü norü cori rü tama moxẽ nüxna naxã na naxüwemüãxü̃cèx, erü woetama ngẽma nixĩ i norü puracü i ngẽma norü duü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","—Rü ngẽxgumarüü̃ tá pixĩgü i pemax. Erü ngẽxguma ngẽma Tupana pexü̃ üxẽẽxü̃xĩcatama pexü̱xgu, rü penaxwèxe i pegü ñaperügügü: “Puracütanüxü̃ i taxuwama mexü̃ tixĩgü, erü ngẽma nawa tüxü̃ namuxü̃xĩcatama nixĩ i tinguxẽẽxü̃”, ñaperügügü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Rü yexguma namagu yaxũxgu ga Ngechuchu ga Yerucharéü̃wa na naxũxü̃, rü Chamáriaane rü Gariréaane nügümaã íxüyexü̃wa naxüpetü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Rü yexguma wüxi ga ĩãnexãcüwa nanguxgu, rü yexma napẽ́xegu nayayi ga 10 ga yatügü ga chaxünemaã iḏaaweexü̃. Rü yaxü̃gu nüxü̃́ nachigü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Rü tagaãcü ñanagürügü nüxü̃: —Pa Ngechuchux, Pa Ngúexẽẽruü̃x, ¡cuxü̃́ tangechaü̃tümüü̃gü! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu, rü ñanagürü nüxü̃: —¡Yéa paigüxü̃tawa pexĩ, rü nüxü̃ pegü peyawẽ́xgü! —ñanagürü. Rü yexguma namagu naxĩyane, rü naxcèx nitaanetanü ga yema yatügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Natürü natanüwa rü nayexma ga wüxi ga Ngechuchucèx taeguxü̃ ga yexguma marü nügü nadèu̱xgu ga naxcèx na yataanexü̃. Rü tagaãcü Tupanaxü̃ nicuèxüü̃chigü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Rü Ngechuchupẽ́xegu nanangücuchi rü moxẽ nüxna naxã. Rü yema yatü rü Chamáriaanecü̱̃ã̱x nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Rü yexguma ga Ngechuchu rü ñanagürü: —¿Taux ẽ́xna i 10 chirẽ́x pixĩgüxü̃ na pexcèx chayataanexẽẽgüxü̃? ¿Ngẽxü̃gü nixĩ i ngẽma togü i 9 i yatügü? ");
INSERT INTO tcaNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","—¿Rü ñaã to i nachiü̃ãnecü̱̃ã̱x i duü̃xü̃xĩcatama nixĩ itaeguxü̃ na Tupanaxü̃ yacuèxüü̃xü̃cèx? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Rü yexguma rü guma yatüxü̃ ñanagürü: —¡Inachi rü íĩxũ! Cuxcèx nitaane, erü cuyaxõ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Rü Parichéugü rü Ngechuchuna nacagü, rü ñanagürügü: —¿Ñuxgu tá nixĩ na yangucuchixü̃ ya Tupana na ãẽ̱xgacü yiĩxü̃cèx i núma? —ñanagürügü. Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Norü nguchiga ya Tupana rü tama wüxi i ṯacü i nüxü̃ idauxü̃rüü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","—Rü taxuacüma ñaperügügü: “Daa nixĩ”, rü ẽ́xna “Gua nixĩ”, ñaperügügü. Erü marü petanüwa nangu ya Tupana na ãẽ̱xgacü yiĩxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Rü yexguma norü ngúexü̃güxü̃ ñanagürü: —Rü tá pexcèx ínangu i ngunexü̃ i nagu poraãcü tá choxü̃ pedaugüchaü̃xü̃ woo wüxi i paxaãchicèxtama yixĩgu. Natürü tãũtáma choxü̃ pedaugü i ngẽxguma. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","—Rü duü̃xü̃gü rü tá ñanagürügü pexü̃: “Daa nixĩ ya Cristu”, rü ẽ́xna, “Gua nixĩ ya Cristu”, ñanagürügü tá. Natürü pemax ¡rü tãũtáma nüxü̃́ peyaxõgü, rü tãũtáma nawe perüxĩ! ");
INSERT INTO tcaNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","—Rü ngẽxguma íchanguxgu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü wüxi i ãẽmacü i guxü̃ãneguma baxixü̃rüü̃ tá chixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","—Natürü noxri rü tá poraãcü ngúxü̃ chinge, rü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü i ñu̱xma maxẽxü̃ rü tá choxü̃ naxoe. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","—Rü yexgumarüü̃ ga duü̃xü̃gü na chixri maxẽxü̃ ga yexguma Noe̱ maü̃xgu, rü ngẽxgumarüü̃ tá ta chixri namaxẽ i duü̃xü̃gü i ngẽxguma íchanguxgu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","—Rü ga duü̃xü̃gü ga yexguma rü nachibüe, rü naxaxegü, rü nixãmèxgü, rü nixütexacügü ñu̱xmata nawa nangu ga yema ngunexü̃ ga Noe̱ naweü̃gu nagu ixüexü̃. Rü ínangu ga mucü ga taxüchicü, rü guxü̃ma ga yema duü̃xü̃gü rü nayue. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","—Rü yexgumarüü̃ ta nangupetü ga yexguma nuxcümaü̃cü ga Lox maü̃xgu. Rü duü̃xü̃gü rü nachibüe, rü naxaxegü, rü norü yemaxü̃cèx nataxegü, rü namaã nataxegü, rü nixüanegü rü nitoegü, rü nixüpatagü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","—Natürü yexguma Lox ixũxgu nawa ga guma ĩãne ga Chodoma, rü daxũwa narüyi ga üxü ga naxĩchine, rü nanadai ga guxü̃ma ga yema duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","—Rü ngẽxgumarüü̃ tá ta nangupetü i ngẽxguma íchanguxgu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Rü ngẽma ngunexü̃gu rü texé tama tümapataarü aixepewa ngẽxmagu, rü tama name i tümapatagu tayangaxi na tümaãrü ngẽmaxü̃gü tayatoxü̃cèx. Rü texé ya tümaãnewa ngẽxmaxẽ, rü tama name i tümapatacèx tataegu na ṯacü nge̱ma tayayaxuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","—Rü nüxna pecuèxãchie ga ñuxãcü ngĩxü̃ na naxüpetüxü̃ ga Lox namèx ga na nayuxü̃, ga yexguma ngĩgüweama nadèu̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","—Erü yíxema tügü maxẽchaxẽẽchaü̃xẽ rü tá itayarütaxu, natürü yíxema chauxcèx yuxe rü aixcüma tá tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","—Rü pemaã nüxü̃ chixu rü ngẽma chütaxü̃gu rü wüxi i ngürücarewa tá nangẽxmagü i taxre i duü̃xü̃gü. Rü wüxi tá niga, rü ngẽma to rü tá nge̱ma natèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","—Rü taxre i ngexü̃gü tá nügümaã ínacaegü. Rü wüxi tá niga rü ngẽma to rü tá nge̱ma natèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","—Rü taxre i yatügü rü wüxi i naãnewa tá nangẽxmagü. Rü wüxi tá niga rü ngẽma to rü tá nge̱ma natèx —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Rü yemaxü̃ naxĩnüẽgu ga norü ngúexü̃gü, rü Ngechuchuna nacagü, rü ñanagürügü: —Pa Corix, ¿ngextá tá nixĩ i nangupetüxü̃ i ngẽma nüxü̃ quixuxü̃? —ñanagürügü. Rü nüma ga Ngechuchu rü nanangãxü̃, rü ñanagürü: —Duü̃xü̃gü rü tá chauxcèx nangutaquẽ́xegü ñoma ẽxchagü nawemücèx ngutaquẽ́xexü̃rüü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Rü Ngechuchu rü wüxi ga to ga orexü̃ namaã nixu na yemawa nangúexẽẽãxü̃cèx na ñuxãcü nanaxwèxexü̃ na taguma nüxü̃ nachaueãcüma guxü̃guma nayumüxẽgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Wüxi ga ĩãnewa nayexma ga wüxi ga ãẽ̱xgacü ga tama Tupanaga ĩnüxü̃ rü taxúexü̃ma ngechaü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","—Rü guma ĩãnewatama iyexma ga wüxi ga nge ga yutecü ga ngixü̃́ nayexmacü ga wüxi ga guxcha namaã ga to ga duü̃xü̃. Rü yemacèx yema ãẽ̱xgacüxü̃tawa ixũxecha na ngixü̃́ namexẽẽãxü̃cèx ga yema guxcha. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","—Rü muẽ̱xpü̱xcüna yéma ixũũxü̃, natürü yema ãẽ̱xgacü rü tama ngĩxü̃ narüngü̃xẽẽchaü̃. Natürü düxwa nagu narüxĩnü ga yema ãẽ̱xgacü rü naãẽwa ñanagürü: “Choma rü tama Tupanaxü̃ changechaü̃, rü taxúexü̃ma chacuáxchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","—Natürü ngẽma choxü̃ na nachixeweechaxü̃cèx i ñaã nge, rü noxtacüma tá ngĩxü̃ charüngü̃xẽẽ na tama yeü̃cürü choxü̃ nachixeweechaxü̃cèx”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Rü Cori ga Ngechuchu rü ñanagürü: —Yema nixĩ ga norü ore ga yema ãẽ̱xgacü ga chixexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","—¿Taux ẽ́xna i Tupana rü paxa tüxü̃ ínapoxü̃xü̃ ya yíxema duü̃xẽ ya tüxü̃ nayaxuxe i ngẽxguma chütacü rü ngunecü rü norü ngü̃xẽẽcèx nüxna tacaxgu i tümaãrü yumüxẽwa? ");
INSERT INTO tcaNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","—Rü pemaã nüxü̃ chixu rü Tupana rü paxatáma tüxü̃ narüngü̃xẽẽ. Natürü ngẽxguma wenaxãrü núma chaxũxgu i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, ¿rü ñuxre i duü̃xü̃gü i aixcüma yaxõgüxü̃xü̃ tá ichayangau i ñoma i naãnewa? —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Rü Ngechuchu rü nüxü̃ nixu ga ñaã ore nachiga ga yema duü̃xü̃gü ga nügü írümegünetaxü̃ rü tama togüxü̃ cuáxchaü̃güxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Rü ñanagürü: —Taxre ga yatü rü tupauca ga taxü̃newa nayayumüxẽgü. Rü wüxi rü Parichéu nixĩ, rü yema to rü wüxi ga yatü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ dexü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","—Rü yema Parichéu rü yexma nachi, rü ñaããcü nayumüxẽ: “Pa Tupanax, moxẽ cuxna chaxã erü tama togü i duü̃xü̃gürüü̃ chixĩ. Rü tama togürüü̃ changĩ́tèx, rü tama ngẽmarüü̃ taxü̃ i chixexü̃ chaxü rü ẽ́xna wüxi i nge i ãtecümaã ichape. Rü bai i ñaã yatü i Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ dexü̃rüü̃ chixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","—Choma rü guxcü ya yüxügu rü taxreẽ́xpü̱xcüna chaxaure rü tama chachibü na cugu charüxĩnüxü̃cèx. Rü chorü dĩẽruwa rü guxü̃guma meã cuxna chanaxã i ngẽma cuxna üxü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","—Natürü ga guma yatü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ decü, rü yaxü̃gu narüxã̱ũ̱x. Rü namuü̃ ga daxũ na nadawenüxü̃, rü yema norü ngechaü̃maã nügü napaxremü, rü ñanagürü: “Pa Tupanax, ¡Cuxü̃́ changechaü̃tümüü̃! Erü wüxi i pecaduã́xü̃ chixĩ”, ñanagürü ga guma yatü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","—Rü ngẽmacèx pemaã nüxü̃ chixu rü guma yatü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ decü rü yexguma napatacèx nataegugu rü Tupanapẽ́xewa rü mecü nixĩ. Natürü yema Parichéu rü Tupana rü tama namaã nataãẽ. Erü texé ya tügü icuèxüxü̃xe rü Tupana tá tüxü̃ naxãnexẽẽ. Natürü texé ya tama tügü icuèxüxü̃xe rü Tupana rü tá tüxü̃ nicuèxüxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Rü yéma Ngechuchuxü̃tawa tüxü̃ tagagü ta ga buã̱xgü na tüxü̃ yangõgüchigüxü̃cèx. Natürü yexguma norü ngúexü̃gü yemaxü̃ dauxgügu rü tüxü̃ ningagü ga guxema tümaxãcüegü Ngechuchuxü̃tawa tüxü̃ gagüxe. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Natürü Ngechuchu rü nügüxü̃tawa tümacèx naca ga guxema buã̱xta rü ñanagürü norü ngúexü̃güxü̃: —Chanaxwèxe i chauxü̃tawa naxĩ i buxü̃gü. ¡Rü tãxṹ i nüxna penachu̱xuxü̃! Erü Tupana ãẽ̱xgacü íixĩxü̃wa rü tümacèx nixĩ ya yíxema ñaã buxü̃gürüü̃ ixĩgüxe. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","—Aixcüma pemaã nüxü̃ chixu rü texé ya tama wüxi i buxü̃rüü̃ Tupanaxü̃ yaxúxe na tümaãrü ãẽ̱xgacü na yiĩxü̃cèx, rü tagutáma nagu taxücu i Tupana ãẽ̱xgacü íixĩxü̃wa —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Rü wüxi ga yema Yudíugüarü ãẽ̱xgacü rü Ngechuchuna naca rü ñanagürü: —Pa Ngúexẽẽruü̃ ya Mecüx, ¿ṯacü tá chaxüxü̃ na chanayaxuxü̃cèx i maxü̃ i taguma gúxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ “Mecü” ñacurügü choxü̃? Erü Tupanaxĩcatama nixĩ ya mecü ixĩcü, rü nataxuma i to i mecü ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","—Cuma nüxü̃ cucuèx i Tupanaãrü mugü i ñaxü̃: “¡Tãũtáma naĩ i ngemaã icupe, rü tãũtáma cumáẽta, rü tãũtáma cungĩ́tèèx, rü tãũtáma doraxü̃ quixu i togüchiga, rü tümaga naxĩnü ya cunatü rü cue!” ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Rü yexguma ga guma yatü rü ñanagürü Ngechuchuxü̃: —Woetama chorü bucüma meãma chayanguxẽẽ i guxü̃ma i ngẽma mugü i nüxü̃ quixuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Rü yemaxü̃ naxĩnügu ga Ngechuchu rü ñanagürü: —Wüxixicatama cuxü̃́ nataxu, rü ngẽma nixĩ na namaã cutaxexü̃ i guxü̃ma i curü ngẽmaxü̃gü rü togü i ngearü ngẽmaxü̃ã̱xgüxü̃na na cunaxãxü̃ i curü natanü, rü ngẽxguma rü tá cuxü̃́ nangẽxma i cuchica i daxũguxü̃ i naãnewa. Rü ñu̱xũchi marü name i chowe curüxũ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Natürü yemaxü̃ naxĩnügu ga guma yatü rü poraãcü inayarümaãchi, yerü namuãrü dĩẽruã̱xü̃chi. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga ñuxãcü na nangechaü̃xü̃, rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Naguxchaxüchi tá nixĩ na Tupana ãẽ̱xgacü íixĩxü̃wa na yachocuxü̃ i ngẽma dĩẽruã̱xü̃chigüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","—Rü dücax, wüxi i cameyu rü taxucürüwama wüxi ya ucumaxẽtüwa naxüpetü. Rü ngẽxgumarüü̃ ta nixĩ i wüxi i duü̃xü̃ i dĩẽruã̱xü̃chixü̃ rü taxucürüwama Tupana ãẽ̱xgacü íixĩxü̃wa nixücu ega norü dĩẽruguama naxĩnügu rü tama yaxõõgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Rü yexguma yemaxü̃ naxĩnüẽgu ga duü̃xü̃gü rü ñanagürügü: —¿Ẽ́xna texé tá ya nayaxúxe i maxü̃ i taguma gúxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Rü Ngechuchu ñanagürü nüxü̃: —Duü̃xü̃gü rü taxuacüma nügü namaxẽẽ, natürü Tupanaãxü̃́ rü natauxcha na namaxẽxẽẽãxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Rü Pedru ñanagürü Ngechuchuxü̃: —Pa Corix, toma rü yéma tanawogü ga guxü̃ma ga torü yemaxü̃gü na cuwe tarüxĩxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃ ga norü ngúexü̃gü: —Aixcüma pemaã nüxü̃ chixu rü texé ya Tupanacèx tümapatana, rü ẽ́xna tümanatüna, rü ẽ́xna tümaẽna, rü ẽ́xna tümaẽneẽgüna, rü ẽ́xna tümaẽyèxgüna, rü ẽ́xna tümamèxna, rü ẽ́xna tümaxãcügüna nge̱ma ixũxẽ na Tupanaãxü̃́ tapuracüxü̃cèx, rü ñoma i naãnewa tátama poraãcü tanayaxu i tümaãrü natanü. Rü daxũguxü̃ i naãnewa rü tá ta tanayaxu i maxü̃ i taguma gúxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Rü Ngechuchu rü noxrüwama naxcèx naca ga norü ngúexü̃gü, rü ñanagürü nüxü̃: —Ñu̱xma rü Yerucharéü̃wa tá taxĩ na nge̱ma yanguxü̃cèx i guxü̃ma ga yema ore ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü ümatüxü̃ ga chauchiga. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","—Rü Yerucharéü̃cü̱̃ã̱x i duü̃xü̃gü rü tá to i nachiü̃ãnecü̱̃ã̱xna choxü̃ namugü. Rü ngẽma duü̃xü̃gü rü tá chaugu nidauxcüraü̃gü, rü tá chomaã naguxchigagü, rü tá chauchiwewa nacuaixgüe. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","—Rü tá choxü̃ nac̱uaixgü, rü yixcüra rü tá choxü̃ nimèxgü. Natürü tomaẽ̱xpü̱x i ngunexü̃guwena rü tá wenaxãrü chamaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Natürü yema norü ngúexü̃gü rü tama nüxü̃ nacuèxgüéga ga na ṯacüchiga yiĩxü̃ ga yema ore ga namaã nüxü̃ yaxuxü̃. Yerü poraãcü nüxü̃́ naguxcha ga aixcüma nüxü̃ na nacuèxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Rü yexguma Ngechuchu ĩãne ga Yericúwa nguxchaü̃gu, rü yéma namacüwawa narüto ga wüxi ga yatü ga ngexetücü ga dĩẽrucèx yéma iwémécü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Rü yexguma guma ngexetücü nüxü̃ ĩnügu ga muxü̃ma ga duü̃xü̃gü na yéma chopetüxü̃, rü duü̃xü̃güna naca ga ṯacü na ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Rü nanangãxü̃gü, rü ñanagürügü: —Ngechuchu ya Nacharétucü̱̃ã̱x nuã naxüpetü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Rü yexguma ga guma ngexetücü rü tagaãcü ñanagürü: —Pa Ngechuchux, Pa Dabítanüxü̃x, ¡cuxü̃́ changechaü̃tümüü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Rü yema duü̃xü̃gü ga Ngechuchupẽ́xegu ĩxü̃, rü nanangagü ga na iyanangeáxü̃cèx. Natürü guma ngexetücü rü yexeraãcü tagaãcü ñanagürü: —Pa Dabítanüxü̃x, ¡cuxü̃́ changechaü̃tümüü̃! —ñanagürüama. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Rü yexma nayachiãchi ga Ngechuchu, rü duü̃xü̃güxü̃ namu na naxü̃tawa nagagüãxü̃cèx. Rü yexguma marü naxü̃tawa nanguxgu, rü guma ngexetücüna naca ga Ngechuchu, rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ṯacü i cunaxwèxexü̃ na cumaã chanaxüxü̃? —ñanagürü. Rü guma ngexetücü nanangãxü̃ rü ñanagürü: —Pa Corix, chanaxwèxe na choxü̃ quidauchixẽẽxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Rü Ngechuchu ñanagürü nüxü̃ —¡Idauchi! Rü marü cuxcèx nitaane erü cuyaxõ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Rü yexgumatama nidauchi ga guma ngexetücü, rü Ngechuchuwe narüxũ, rü Tupanaxü̃ nicuèxüü̃chigü. Rü guxü̃ma ga duü̃xü̃gü ga nüxü̃ daugüxü̃ ga yema ngupetüxü̃ rü Tupanaxü̃ nicuèxüü̃gü ta. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Rü Ngechuchu rü Yericúarü ĩanewa naxüpetü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Rü yéma nayexma ga wüxi ga yatü ga dĩẽruã̱xü̃chixü̃ ga Zaquéugu ãe̱gaxü̃. Rü nüma nixĩ ga naẽru ga yema yatügü ga Dumaãrü ãẽ̱xgacücèx dĩẽru ngĩxü̃ ideetanüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rü yema Zaquéu rü poraãcü nüxü̃́ nangúchaü̃ ga Ngechuchuxü̃ na nadauxü̃ na nüxü̃ nacuáxü̃cèx. Natürü taxuacüma nüxü̃ nadau, yerü namuxũchi ga duü̃xü̃gü, rü ñu̱xũchi nanuxchanexü̃chi ga nümax. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Rü yemacèx Ngechuchupẽ́xegu nayangu, rü namacüwawa wüxi ga naĩgu naxĩnagü na Ngechuchuxü̃ nadauxü̃cèx ga yexguma yéma naxüpetügu. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Rü yexguma yéma naxüpetügu ga Ngechuchu, rü daxũ nadau natüü̃wa ga guma naĩ. Rü ñanagürü nüxü̃: —Pa Zaquéux, ¡paxa írüxĩ i nge̱ma! Erü cupatawa tá changu i ñu̱xma —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Rü paxa ínarüxĩ ga Zaquéu, rü taãẽãcüma Ngechuchuxü̃ nayaxu. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Rü yexguma yemaxü̃ nadaugügu ga duü̃xü̃gü, rü guxü̃ma inanaxügüe ga chixri Ngechuchuchiga na yadexagüxü̃. Rü ñanagürügü: —¿Ñuxãcü i nüma rü wüxi i duü̃xü̃ i pecaduã́xü̃patawa nangu? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Rü yexguma ga Zaquéu rü inachi rü ñanagürü Ngechuchuxü̃: —Dücèx, Pa Corix, choma rü ngearü dĩẽruã̱xgüxü̃na tá chanaxã i ngãxü̃gu i guxü̃ma i chorü ngẽmaxü̃gü. Rü ngẽxguma chi texé tüxü̃ chawomüxẽẽãcüma tüxü̃́ changĩ̱xgu, rü ãgümücüẽ́xpü̱xcüna tá tüxü̃́ ngĩxü̃ chataeguxẽẽ i ngẽma tümaãrü dĩẽru —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Rü Ngechuchu rü ñanagürü nüxü̃: —Rü ñoma i ngunexü̃gu cupatawa nangu i maxü̃ i taguma gúxü̃, erü cuma rü ta rü Abráü̃rüü̃ cuyaxõ. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","—Rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü ñoma i naãnewa chaxũ na naxcèx chayadauxü̃cèx i ngẽma duü̃xü̃gü i iyarütauxexü̃ na chanamaxẽxẽẽxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Rü yoxni yema Ngechuchuarü ore inaxĩnüẽyane ga duü̃xü̃gü, rü Ngechuchu rü wüxi ga to ga ore ga cuèxruü̃xü̃ namaã nixu, yerü marü Yerucharéü̃xü̃ ningaica, rü duü̃xü̃gü nagu rüxĩnüẽgu rü paxa tá ínangu ga Tupana na norü ãẽ̱xgacü yiĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Rü yexguma ga Ngechuchu rü nügüchiga nidexa rü ñanagürü nüxü̃: —Nayexma ga wüxi ga yatü ga taxü̃ ga cori ixĩcü ga nayaxucü ga ore na nachiü̃ãneãrü ãẽ̱xgacüxü̃tawa naxũxü̃cèx ga yaxü̃wa na yema ãẽ̱xgacü nüxü̃ unetaxü̃cèx na guma nawa ne naxũxü̃ne ga ĩãneãrü ãẽ̱xgacü yiĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","—Rü yexguma tauta inaxũãchigu, rü naxcèx nangema ga 10 ga norü duü̃xü̃gü. Rü wüxichigüna ngĩxü̃ naxã ga wüxitachinü ga tatanücü ga dĩẽru. Rü ñanagürü nüxü̃: “¡Ngĩmaã pepuracüe rü ngĩxü̃ pimuxẽẽ i ñaã dĩẽru ñu̱xmatáta chataegu!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","—Natürü yema ĩãnecü̱̃ã̱x ga duü̃xü̃gü rü naxchi naxaie ga guma cori. Rü yemacèx nawenaãma nayamugü ga ñuxre ga orearü ngeruü̃gü na nachiü̃ãneãrü ãẽ̱xgacümaã nüxü̃ yanaxugüxü̃cèx na tama nanaxwèxegüxü̃ na norü ãẽ̱xgacüxü̃ na yiĩxü̃cèx ga guma cori. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","—Natürü nachiü̃ãneãrü ãẽ̱xgacü rü nayangucuchixẽẽãma ga guma cori. Rü ñu̱xũchi ga guma cori rü norü ĩãnecèx nataegu na yéma ãẽ̱xgacü na yiĩxü̃cèx. Rü yexguma ínanguxgu rü naxcèx nangema ga yema 10 ga norü duü̃xü̃gü ga dĩẽru nüxna ngĩxü̃ naxãxü̃, yerü nüxü̃ nacuáxchaü̃ ga ñuxrechigü ngĩxü̃ na yamuxẽẽxü̃ ga norü dĩẽru ga wüxichigü ga yema norü duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","—Rü yema nüxĩra dĩẽru nüxna ngĩxü̃ naxãxü̃ rü norü corixü̃tawa nangu, rü ñanagürü: “Pa Corix, curü dĩẽru rü 10 ẽ́xpü̱xcüna ngĩxü̃ chimuxẽẽ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","—Rü guma Cori ga yexwaca ãẽ̱xgacüxü̃ ingucuchicü rü nanangãxü̃, rü ñanagürü: “Wüxi i mexü̃ i chorü duü̃xü̃ quixĩ. Maneca meãma namaã cupuracü i ngẽma íraxü̃ i dĩẽru i cuxna chaxãxü̃. Rü ñu̱xma rü 10 ya ĩãnegüarü ãẽ̱xgacüxü̃ tá cuxü̃ chixĩxẽẽ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","—Rü yéma nangu ga to ga norü duü̃xü̃, rü ñanagürü: “Pa Corix, curü dĩẽru rü wüximẽ́ẽ̱xpü̱xcüna ngĩxü̃ chimuxẽẽ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","—Rü norü cori nanangãxü̃ rü ñanagürü nüxü̃: “Cuma rü wüximẽ́ẽ̱xpü̱x ya ĩãnegüarü ãẽ̱xgacüxü̃ tá cuxü̃ chixĩxẽẽ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","—Rü yéma nangu ga to ga norü duü̃xü̃ rü ñanagürü nüxü̃: “Pa Corix, ñaã iyixĩ i curü dĩẽru. Rü wüxi ya dechugu ngĩxü̃ chanuque, rü ngẽmaãcü ngĩmaã changuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","—Yerü cuxcèx chamuü̃, erü wüxi i yatü i aüxü̃ quixĩ. Rü cunayauxtanü i ngẽma tama cuxrü ixĩxü̃, rü cunayaxu i nanetüarü o i ngextá tama cuma ícutoexü̃wa”. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","—Rü yexguma ga guma ãẽ̱xgacü rü ñanagürü nüxü̃: “Wüxi i chorü duü̃xü̃ i chixexü̃ quixĩ i cumax. Rü curü oretama nixĩ i cuxü̃ ixuxü̃ na cuchixexü̃. Marü nüxü̃ cucuèxchirẽ́x ga na chaxaüxü̃, rü chanayautanüxü̃ i ngẽma tama choxrü ixĩxü̃, rü chanayaxuxü̃ i nanetüarü o i tama choma ichatoxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","—¿Natürü tü̱xcüü̃ tama bancugu choxü̃́ ngĩmaã cunguxü̃ i chorü dĩẽru na nge̱ma choxü̃́ ngĩxü̃ yamuxẽẽgüxü̃cèx, rü ngẽmaãcü mucü ngĩxü̃ na chayaxuxü̃cèx i ngẽxguma íchanguxgu?” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","—Rü yexguma ga ãẽ̱xgacü rü yema yexmagüxü̃maã nüxü̃ nixu, rü ñanagürü: “¡Nüxna ngĩxü̃ peyaxu i ngẽma dĩẽru, rü ngẽma 10 i dĩẽru nüxü̃́ ngẽxmaxü̃na ngĩxü̃ pexã!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","—Rü nümagü rü nanangãxü̃gü, rü ñanagürügü: “Natürü, Pa Corix, nüma rü marü nüxü̃́ ingẽxma i 10 i dĩẽru”, ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","—Rü guma ãẽ̱xgacü nanangãxü̃, rü ñanagürü: “Pemaã nüxü̃ chixu rü texé ya chauga ĩnüxẽ rü yexera tá tüxna chanaxã. Natürü texé ya tama chauga ĩnüxẽ rü tá tüxna chanayaxu i woo ngẽma íraxü̃ i tüxü̃́ ngẽxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","—Rü yema chorü uwanügü ga tama naxwèxegüxü̃ ga norü ãẽ̱xgacüxü̃ na chiĩxü̃, ¡rü nuã penagagü, rü nuã chopẽ́xegu peyaḏai!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Rü yema orexü̃ yaxuxguwena ga Ngechuchu, rü inixũchigü ga Yerucharéü̃wa na naxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Rü yexguma marü nawa nangugüchaü̃gu ga guma ĩãnegü ga Bechagué rü Betániã ga Oríbunecüarü Mèxpǘneãrü ngaicamana yexmagüne, rü Ngechuchu nanamu ga taxre ga norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Rü ñanagürü nüxü̃: —¡Gua ĩãnexãcüwa pexĩ! Rü ngẽxma tá nüxü̃ peyangau i wüxi i buru i ngexwaca yaxü̃ i ngẽxma ngaxü̃xü̃ i taguma texé natagu aunagüxü̃. ¡Rü peyawẽxü̃, rü nuã penaga! ");
INSERT INTO tcaNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","—Rü ngẽxguma texé pexna c̱axgu na ṯacücèx peyawẽxü̃xü̃ i ngẽma buru, ¡rü tümamaã nüxü̃ pixu rü ñapegügü: “Torü Cori nanaxwèxe”, ñapegügü tüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Rü yéma naxĩ ga yema taxre ga norü ngúexü̃gü. Rü yexma nüxü̃ nayangau ga yema buru ga Ngechuchu namaã nüxü̃ ixuxü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Rü yexguma yawẽxü̃güãgu ga yema buru, rü norü yoragü rü yema ngúexü̃güna nacagüe, rü ñanagürügü: —¿Tü̱xcüü̃ peyawẽxü̃ i ngẽma buru? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Rü nümagü nanangãxü̃gü, rü ñanagürügü: —Rü tayawẽxü̃ erü torü Cori nanaxwèxe —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Rü Ngechuchuxü̃tawa nanagagü ga yema buru. Rü yema norü ngúexü̃gü rü norü gáuxü̃chirumaã nanatütagü. Rü ñu̱xũchi Ngechuchuxü̃ natagu naxaunagüxẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Rü duü̃xü̃gü rü Ngechuchupẽ́xewa norü gáuxü̃chirumaã nayac̱ẖamagü ga nama. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Rü yexguma inaxügüãgu na ínaxĩgüxü̃ nawa ga yema nama ga Oríbunecüarü Mèxpǘnewa yarüdaexü̃, rü guxü̃ma ga yema duü̃xü̃gü ga yaxõgüxü̃ ga nawe rüxĩxü̃ rü inanaxügü ga taãẽãcüma aita na naxüexü̃ rü tagaãcü Tupanaxü̃ na yacuèxüü̃güxü̃ naxcèx ga guxü̃ma ga yema cuèxruü̃gü ga taxü̃ ga nüxü̃ nadaugüxü̃ ga Tupanaãrü poramaã naxüxü̃ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Rü ñanagürügü: —¡Namecümaxüchi ya daa tórü ãẽ̱xgacü ya Tupanaégagu núma ũcü! ¡Rü pema rü ta, Pa Daxũcü̱̃ã̱x, rü petaãxẽgü rü nüxü̃ picuèxüü̃gü ya Tupana! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Rü yéma duü̃xü̃gütanüwa nayexmagü ga ñuxre ga Parichéugü. Rü ñanagürügü Ngechuchuxü̃: —Pa Ngúexẽẽruü̃x, ¡Yangagü i ngẽma cuwe rüxĩxü̃ i duü̃xü̃gü na yanachianegüxü̃cèx! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Natürü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Pemaã nüxü̃ chixu rü ngẽxguma chi iyanangeèxgügu i ñaã duü̃xü̃gü, rü daa nutagü ya namacüwawa ngẽxmagücü rü chi nüxĩ aita naxüe —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Rü yexguma Yerucharéü̃ãrü ngaicamana nanguxgu ga Ngechuchu, rü guma ĩãnecü̱̃ã̱x ga duü̃xü̃gücèx naxaxu. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Rü ñanagürü: —Pa Yerucharéü̃cü̱̃ã̱xgü, chierü ñoma i ngunexü̃gu nüxü̃ pecuèxgu na texé aixcüma taãẽ pexna ãxü̃. Natürü ngẽma rü pexchawa inicu̱x i ñu̱xma, rü taxuacüma nüxü̃ pecuèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","—Rü tá guxchaxü̃gü pexü̃ naxüpetü. Rü perü uwanügü tá nanaxü i norü poxü̃chica i norü guxü̃cüwawa ya perü ĩãne. Rü norü churaragü tá pexü̃ ínachoeguãchi, rü guxü̃cüwawa tá pexcèx ne naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","—Rü tá nagu napogüe ya perü ĩãne, rü tá pexü̃ nadai. Rü taxucütáma ya nuta ngextá nügüxétü nanugüxüra i perü ĩãneãrü poeguxü̃tapüwa. Rü ngẽmaãcü tá pexü̃ naxüpetü, yerü tama nüxü̃ pecuèxgüchaü̃ ga yexguma Tupana petanügu naxũãnegu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Rü Ngechuchu rü tupauca ga taxü̃newa nangu rü yexma naxücu. Rü inanaxügü na ínawoxü̃ãxü̃ ga yema duü̃xü̃gü ga tupauca ga taxü̃newa taxegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Rü Ngechuchu rü ñanagürü nüxü̃: —Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Chopata rü yumüxẽpataü̃ nixĩ”. Natürü pema rü ngĩ́tèèxgüxü̃pataü̃ peyaxĩxẽẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Rü guxü̃ ga ngunexü̃gu rü tupauca ga taxü̃newa nayangu̱xẽẽtae ga Ngechuchu. Natürü ga paigüarü ãẽ̱xgacügü, rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü Yerucharéü̃ãrü ãẽ̱xgacügü, rü naxcèx nadaugü ga ñuxãcü tá na yamèxgüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Natürü taxucürüwa ṯacü namaã naxügü, yerü guxü̃ma ga duü̃xü̃gü rü namaã nataãẽgü, rü meã inarüxĩnüẽ ga norü ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wüxi ga ngunexü̃ ga Ngechuchu rü tupauca ga taxü̃newa nayexma. Rü nanangúexẽẽ ga duü̃xü̃gü, rü namaã nüxü̃ nixu ga Tupanaãrü ore. Rü yexguma íyadexayane rü yéma nangugü ga paigüarü ãẽ̱xgacügü, rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü Yudíugüarü ãẽ̱xgacügüerugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Rü ñanagürügü nüxü̃: —¿Texéarü mugagu nixĩ i cunaxüxü̃ i ngẽma núma cuxüxü̃? ¿Rü texé cuxü̃ tamu na cunaxüxü̃cèx i ngẽma? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Choma rü tá ta pexna chaca, rü chanaxwèxe i choxü̃ pengãxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","—¿Rü texé tanamu ga Cuáü̃ na duü̃xü̃güxü̃ ínabaiü̃xẽẽxü̃cèx? ¿Pexcèx rü Tupana yiĩxü̃ ga namucü rü ẽ́xna duü̃xü̃gümare? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Rü yexguma ga Parichéugü rü inanaxügüe ga nügümaã na yaporagatanücüüxü̃. Rü nügümaãtama ñanagürügü: —¿Ñuxũ ñagügüxü̃ tá? Erü ngẽxguma chi: “Tupana núma nanamu”, ñagügu, rü nüma rü chi ñanagürü tüxü̃: “¿Rü tü̱xcüü̃ ga tama nüxü̃́ peyaxõgüxü̃?” ñanagürü chi tüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","—Rü ngẽxguma chi ñagügu: “Yatügümare nuã nanamu”, ñagügu, rü guxü̃ i duü̃xü̃gü chi nutamaã tüxü̃ ínamuxũchigü, rü tüxü̃ chi nadai. Erü nümagü i duü̃xü̃gü rü nagu narüxĩnüẽ na Tupana yiĩxü̃ ga Cuáü̃xü̃ mucü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Rü Ngechuchuxü̃ nangãxü̃gü rü ñanagürügü: —Tama nüxü̃ tacuèx ga texé núma na namuxü̃ ga Cuáü̃ ga baiü̃xẽẽruü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Choma rü ta tãũtáma pemaã nüxü̃ chixu na texé choxü̃ muxü̃ na chanaxüxü̃cèx i ngẽma choxna naxcèx pec̱axü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Rü inanaxügü ga Ngechuchu ga duü̃xü̃gümaã na yadexaxü̃. Rü ñaã ore ga cuèxruü̃xü̃ namaã nixu, rü ñanagürü: —Nayexma ga wüxi ga yatü ga wüxi ga ubanecü ücü ga norü naãnewa. Rü ñu̱xũchi ñuxre ga puracütanüxü̃na nanaxã na nüxna nadaugüxü̃cèx rü yixcama rü norü yoramaã na yayauxyegüãxü̃cèx ga yema norü o. Rü ñu̱xũchi ga guma yatü rü nixũ ga yéma rü nuxcüma nataegu. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","—Rü yexguma nawa nanguxgu ga na yadauxü̃ ga yema ubagü, rü guma yatü rü yéma puracütanüxü̃güxü̃tawa nanamu ga wüxi ga norü duü̃xü̃ na naxcèx íyac̱axü̃cèx ga yema ubagü ga nüxna üxü̃. Natürü yema puracütanüxü̃gü rü nanac̱uaixgü ga guma yatüarü duü̃xü̃, rü taxuü̃ma ga uba nüxna naxãgü. Rü yemaãcü ínayamugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","—Rü yexguma ga guma yatü rü wenaxãrü to ga norü duü̃xü̃ yéma ta namu. Natürü ga yema puracütanüxü̃gü rü chixexü̃ namaã nixugüe, rü nanac̱uaixgü, rü taxuü̃ma ga uba nüxna naxãgü. Rü yemaãcü ínayamugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","—Rü wenaxãrü to ga norü duü̃xü̃ yéma ta namu ga guma yatü. Natürü ga yema puracütanüxü̃gü rü nanapi̱xẽẽ, rü ínanatèxüchigü ga yema naãnewa. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","—Rü düxwa ñanagürü ga guma naãneãrü yora: “¿Ṯacü tá chaxüxü̃ i ñu̱xmax? Rü name nixĩ i chaune ya nüxü̃ changechaü̃cü nge̱ma chanamu. Rü ngẽxguma nüxü̃ nadaugügu rü bexmana naga tá naxĩnüẽ”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","—Natürü ga yema puracütanüxü̃gü rü yexguma guma yatü nanexü̃ nadaugügu, rü nügümaã ñanagürügü: “Ñaããrü tá nixĩ i ñaã naãne i yixcama. ¡Rü ngĩxã tayamèxgü na tórü na yiĩxü̃cèx!” ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","—Rü ínanatèxüchigü ga yema naãnewa, rü nayamèxgü —ñanagürü ga Ngechuchu. Rü yexguma ga Ngechuchu rü duü̃xü̃güna naca, rü ñanagürü: —¿Ṯacü tá ngẽma puracütanüxü̃maã naxü i ngẽma naãneãrü yora i ñu̱xmax? ");
INSERT INTO tcaNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","—Rü nge̱ma tá naxũ rü tá nanadai i ngẽma puracütanüxü̃gü, rü togüna tá nanaxã i norü naãne —ñanagürü ga Ngechuchu. Rü yexguma yemaxü̃ naxĩnüẽgu ga duü̃xü̃gü rü ñanagürügü: —Chierü tama ngẽmaãcü nangupetüxẽẽãxgu ya Tupana —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Natürü Ngechuchu rü nüxü̃ nadawenü, rü ñanagürü nüxü̃: —¿Natürü ñuxũ ñaxü̃chiga nixĩ i ngẽma Tupanaãrü ore i ümatüxü̃ i ñaxü̃?: “Yima nuta ya mecü ya ĩãrü üruü̃gü nüxü̃ oechirécü, rü ñu̱xma rü yimatama nixĩ ya Tupana nüxĩra yaxücuchicü na namaã inaxügüãxü̃ ya ĩpata”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Rü ñanagürü ta ga Ngechuchu: —Texé ya yima nutamaã yarüñaxẽ, rü tá itapoü̃gü. Rü yíxema tümae̱tügu nanguxe ya yima nuta, rü tá tüxü̃ niñáĩxmü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Rü ga paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃, rü yexgumatama Ngechuchuxü̃ niyauxgüchaü̃. Yerü nüxü̃ nacuèxgü ga nachiga na yiĩxü̃ ga yema ore ga cuèxruü̃ ga nüxü̃ yaxuxü̃. Natürü tama nayayauxgü, yerü duü̃xü̃güxü̃ namuü̃ẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Rü yemacèx ga yema paigüarü ãẽ̱xgacügü rü Ngechuchuxü̃tawa nanamugü ga ñuxre ga norü duü̃xü̃gü na mexü̃ i duü̃xü̃gürüü̃ yéma iyanaxĩnüẽxü̃cèx natürü naxcèx na nadaugüxü̃cèx ga ñuxãcü nachiü̃ãneãrü ãẽ̱xgacüxü̃tawa Ngechuchuxü̃ na ínaxuaxü̃güxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Rü yemacèx Ngechuchuna nacagü rü ñanagürügü: —Pa Ngúexẽẽruü̃x, toma nüxü̃ tacuèx rü aixcüma nixĩ i ngẽma nüxü̃ quixuxü̃ rü ngẽma namaã cungúexẽẽtaexü̃. Rü tama duü̃xü̃ãrü düxétüxü̃negu cudawenü erü nacüma nixĩ i cungugüxü̃. Rü aixcüma cunangúexẽẽ i duü̃xü̃gü na Tupana naxwèxexü̃ãcüma namaxẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","—Rü dücax, ngẽma ĩãneãrü dĩẽru i ãẽ̱xgacü ya tacü ya Dumacü̱̃ã̱x naxwèxexü̃ na tanaxütanüxü̃, ¿rü namexü̃ yiĩxü̃ na nüxü̃́ tanaxütanüxü̃ rü ẽ́xna tama? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Natürü Ngechuchu nüxü̃ nacuèxama na chixexü̃gu naxĩnüẽxü̃ ga yema duü̃xü̃gü, rü yemacèx ñanagürü nüxü̃: —¿Tü̱xcüü̃ i chixexü̃gu choxü̃ penguxẽẽchaü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—¡Choxü̃ ngĩxü̃ pewé i wüxi i dĩẽru na ngĩxü̃ chadauxü̃cèx! ¿Rü texéchicünèxã rü texééga ngĩgu ü̱x? —ñanagürü. Rü nanangãxü̃gü rü ñanagürügü: —Dumacü̱̃ã̱x ya ãẽ̱xgacü ya tacüchicünèxã nixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Ãẽ̱xgacüna ngĩxü̃ pexã i ngẽma ãẽ̱xgacüarü ixĩcü, rü Tupanana ngĩxü̃ pexã i ngẽma Tupanaãrü ixĩcü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Rü yemaãcü ga Ngechuchu rü woo norü orewa rü taxucürüwama chixexü̃gu nananguxẽẽgü ga duü̃xü̃güpẽ́xewa, yerü meãma nanangãxü̃. Rü guxü̃ma ga duü̃xü̃gü rü nangeèxgümare yerü naḇaixãchiãẽgü namaã ga yema norü ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Rü Ngechuchuxü̃tawa ínayadaugü ga ñuxre ga Chaduchéugü. Rü nümagü nixĩ ga nagu naxĩnüẽxü̃ na tagutáma wena namaxẽxü̃ i yuexü̃. Rü yemacèx Ngechuchuxü̃ ñanagürügü: ");
INSERT INTO tcaNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Pa Ngúexẽẽruü̃x, Moĩchéarü mugüwa rü ñanagürü: “Ngẽxguma wüxi ya yatü naxmèx ngexacüyane nayu̱xgu, rü name nixĩ i naẽneẽtama ngĩmaã naxãmèx i ngẽma yutecü i naxü̃mèx, na ngẽmaãcü naxãxãcüxü̃cèx nüxü̃́ ya naẽneẽ ya marü yucü”, ñanagürü ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Rü ñanagürügü ta ga Chaduchéugü: —Nayexma ga 7 ga nügüeneẽ. Rü naxãmèx ga guma yacü, natürü tauta naxãxãcüyane nayu. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","—Rü yexguma naĩ ga naẽneẽ nüxĩ ngĩmaã naxãmèx ga yema ngecü. Rü guma rü ta nayu, rü nangexacü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","—Rü yexguma rü naĩ ga naẽneẽ nüxĩ ngĩmaã naxãmèx. Rü yemaãcü gucüma ga guma 7 ga nügüeneẽgü rü ngĩmaã naxãmèx ga yema nge. Rü gucüma nayue tauta naxãxãcüyane. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","—Rü ngĩma rü ta düxwa iyu ga yema nge. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Rü ngẽxguma yuexü̃ wena maxẽgu, ¿rü ngecürüücü naxmèx tá iyixĩ i ngẽma nge? Yerü yexguma namaxẽgu rü gucüma ga guma 7 ga nügüeneẽ ngĩmaã naxãmèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Rü yexguma ga Ngechuchu rü nanangãxü̃ rü ñanagürü: —Ñoma i naãnewa rü yatügü rü nixãmèxgü rü ngexü̃gü rü nixãtegü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","—Natürü ngẽma duü̃xü̃gü i Tupanapẽ́xewa mexü̃ na wena namaxẽxü̃ na daxũguxü̃ i naãnewa naxĩxü̃cèx rü nge̱ma rü tãũtáma nixãmèxgü rü ẽ́xna nixãtegü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","—Erü nge̱ma rü tagutáma nayue. Rü daxũcü̱̃ã̱x i Tupanaãrü orearü ngeruü̃gürüü̃ tá nixĩgü. Rü aixcüma Tupanaxãcügü nixĩgü erü yuwa ínarüdagü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","—Rü yema ore ga naĩxãcü ga iy̱auratanücüxǘnechigawa, rü Moĩché tüxü̃ nüxü̃ nacuèxẽẽ rü yuexü̃ rü tá wena na namaxẽxü̃. Erü yema orewa, rü ñanagürü ga Cori ga Tupana: “Choma nixĩ i Abráü̃ãrü Tupana, rü Ichaáarü Tupana, rü Acobuarü Tupana”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","—Rü ngẽmawa nüxü̃ tacuèx rü woo ñoma i naãnewa nayuegu i duü̃xü̃gü, natürü Tupanacèx rü guxü̃guma namaxẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Rü yexguma ga ñuxre ga ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ rü ñanagürügü: —Aixcüma meãma nüxü̃ quixu, Pa Ngúexẽẽruü̃x —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Rü yemawena rü marü namuü̃ẽ ga ṯacüchigacèx Ngechuchuna na nacagüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Rü Ngechuchu rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ duü̃xü̃gü nüxü̃ nixugüe rü Cristu rü nuxcümaü̃cü ga ãẽ̱xgacü ga Dabítaa nixĩ? ");
INSERT INTO tcaNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","—Yerü Dabítama ñaããcü nanaxümatü ga Wiyaegüarü poperawa: “Tupana rü chorü Cori ya Cristuxü̃ ñanagürü: ‘¡Nuã chorü tügünecüwawa rüto, ñu̱xmatáta cuxmẽ́xwa chanangẽxmagüxẽẽ i curü uwanügü na namaã icucuáxü̃cèx!’ ” ñaããcü nanaxümatü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Rü ñanagürü ga Ngechuchu: —¿Ñuxũcürüwa i Dabítaa yiĩxü̃ ya Cristu ega nümatama ga Dabí rü norü Corimaã naxuãgu? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Rü guxü̃ma ga duü̃xü̃gü rü yéma inarüxĩnüẽ ga yexguma Ngechuchu norü ngúexü̃güxü̃ ñaxgu: ");
INSERT INTO tcaNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—¡Pexuãẽgü naxcèx i ngẽma ngúexẽẽruü̃gü i Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃! Erü nümagü rü norü me nixĩ i mexü̃ i naxchirumaã na naxĩãneãxü̃. Rü ítamü̃wa nanaxwèxegü na duü̃xü̃gü meã nüxü̃ rümoxẽgüxü̃. Rü ngutaquẽ́xepataü̃güwa rü norü me nixĩ i ãẽ̱xgacügümèxwẽ́xewa na natogüxü̃. Rü õna i taxü̃wa rü ngẽma õnaãrü yoraxü̃tawa ügüxü̃ i nachicacèx nadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","—Rü tüxü̃ nawomüxẽẽgüãcüma tüxna nanapuxü̃ ya tümapatagü ya yíxema yutegüxe. Rü ñu̱xũchi nanamèxẽẽ i norü yumüxẽgü na duü̃xü̃gü nagu rüxĩnüẽxü̃cèx na aixcüma mexü̃gü yiĩgüxü̃. Natürü nümagü tá nixĩ i yexeraãcü napoxcuexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Rü yexguma tupauca ga taxü̃newa nayexmagu ga Ngechuchu, rü yéma nüxü̃ nadau ga ñuxãcü duü̃xü̃gü ga idĩẽruã́xü̃ Tupanana ngĩxü̃ na naxãgüxü̃ ga norü dĩẽru ga tupaucaarü dĩẽruchiü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Rü ngĩxü̃ nadau ta ga wüxi ga ngecü ga yutecü ga ngearü dĩẽruã̱xcü ga tupaucaarü dĩẽruchiü̃gu taxretachinü ga íraxüchicü ga dĩẽru ngĩxü̃ ixücuchicü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Rü ñanagürü ga Ngechuchu: —Aixcüma pemaã nüxü̃ chixu rü ñaã ngecü i yutecü i ngearü dĩẽruã̱xcü rü guxü̃ i togü i dĩẽru ngĩxü̃ ixãgüxü̃ãrü yexera ngĩxü̃ ixã. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","—Erü guxü̃ma i togü rü ngĩxü̃ inaxã i ngema nüxü̃́ íyaxügücü. Natürü ngĩma ngĩxü̃́ natauxyane ngĩxü̃ ixã i gu̱xcüma i ngĩxü̃́ ngexmaxcü i ngĩrü õnatanü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Rü ñuxre ga norü ngúexü̃gü rü nidexagü nachiga ga tupauca ga taxü̃ne ga ñuxãcü na namexẽchixü̃ ga naxtapü̱x ga nutanaxcèxgü, rü na namexẽchixü̃ ga guxü̃ma ga guma tupaucaarü yemaxü̃gü ga duü̃xü̃gü nüxna ãmarexü̃. Rü yexguma ga Ngechuchu rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Rü nawa tá nangu i ngunexü̃gü i guxü̃netama ya daa tupauca ya nüxü̃ pedauxü̃ne, rü tá nagu napogüe. Rü naxtapü̱xarü nutagü rü taxucütáma nügüétü naxüxüra, rü bai ya wüxi —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Rü yexguma ga norü ngúexü̃gü rü Ngechuchuna nacagü, rü ñanagürügü: —Pa Ngúexẽẽruü̃x, ¿ñuxgu tá nixĩ i nangupetüxü̃ i ngẽma nüxü̃ quixuxü̃? ¿Rü ṯacüwa tá nüxü̃ tacuèx na nangupetüxü̃ tá i ngẽma? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Rü Ngechuchu rü ñanagürü: —¡Pexuãẽgü tá na taxuü̃ma pexü̃ womüxẽẽxü̃cèx! Erü muxũchixü̃ tá chaugu nügü nicu̱xgü rü tá ínangugü rü ñanagürügü tá: “Choma nixĩ i Cristu, rü paxa tá nagu̱x i naãne”, ñanagürügü tá pexü̃. ¡Natürü tãũtáma nüxü̃́ peyaxõgü! ");
INSERT INTO tcaNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","—Rü ngẽxguma tá nüxü̃ pexĩnüẽgu na nügü nadèi̱xü̃ i wüxi i nachiü̃ãne to i nachiü̃ãnemaã, rü ẽ́xna nüxü̃ pexĩnüẽgu na wüxi i nachiü̃ãnewatama rü duü̃xü̃gü rü norü ãẽ̱xgacümaã nügü nadèi̱xü̃, ¡rü tãũtáma peḇaixãchiãẽgü! Erü ngẽmaãcü tá nangupetü i noxrix. Natürü tãũtáma naãneãrü gu̱x nixĩ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","—Erü wüxi i ãẽ̱xgacüarü churaragü rü to i ãẽ̱xgacüarü churaragümaã tá nügü nadai. Rü wüxi i nachiü̃ãne rü to i nachiü̃ãnemaã tá nügü nadai. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","—Rü nümaxü̃ i nachiü̃ãnegüwa rü poraãcü tá naxĩã̱xãchiane, rü poraãcü tá nangu̱x i taiya, rü tá nataxüchi i ḏaaweane. Rü duü̃xü̃gü tá nüxü̃ nadaugü i daxũwa i ṯacü i namaã naḇaixãchiexü̃, rü taxü̃ i cuèxruü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","—Natürü naxü̃pa i guxü̃ma i ngẽma rü duü̃xü̃gü tá pexü̃ ínayauxü̃, rü tá pewe ningẽxü̃tanü. Rü ngutaquẽ́xepataü̃güwa tá pexü̃ nagagü na nge̱ma pexna nacagüxü̃cèx, rü tá pexü̃ napoxcue. Rü nachiü̃ãnegüarü ãẽ̱xgacügüpẽ́xewa tá pexü̃ nagagü, naxcèx na chorü duü̃xü̃gü pixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","—Rü ngẽmaãcü tá pexü̃́ natauxcha na ãẽ̱xgacügümaã nüxü̃ pixuxü̃ i chauchiga. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","—Rü ngẽxguma tá nge̱ma pexü̃ nagagügu, ¡rü tãxṹ i pexoegaãẽgüxü̃ naxcèx na ṯacümaã tá penangãxü̃xü̃ na pegüétüwa pechogüxü̃cèx! ");
INSERT INTO tcaNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","—Erü choma tá pexü̃ charüngü̃xẽẽ na nüxü̃ pecuáxü̃cèx na ṯacümaã penangãxü̃xü̃ i perü uwanügü. Rü nümagü rü tãũtáma nüxü̃ nacuèxgü na ṯacümaã pexü̃ nangãxü̃güxü̃ i ngẽxguma. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","—Natürü pema rü woo penatügü, rü peegü, rü peeneẽgü, rü peeyèxgü, rü petanüxü̃gü, rü pemücügü rü tá napeechitaegü na purichíagüxü̃tawa pexü̃ íyaxuaxü̃güxü̃. Rü purichíagü rü tá pexü̃ nadai i ñuxre i pemax. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","—Rü guxü̃ i naãnewa rü duü̃xü̃gü tá pexchi naxaie, erü choxü̃́ peyaxõgü rü chorü duü̃xü̃gü pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","—Natürü woo ṯacü pexü̃ üpetügu rü Tupanamẽ́xẽwa tá pengẽxmagü, rü nüma tá pexü̃ ínapoxü̃ rü bai i wüxi i peyae tá inayarütaxu. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","—Rü ngẽxguma aixcüma peyaxõgüamagu rü tama choxü̃ ípetèxgu, rü tá penayauxgü i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Rü ngẽxguma nüxü̃ pedèu̱xgu na perü uwanügüarü churaragü Yerucharéü̃xü̃ íchomaẽguãchixü̃, rü ngẽmawa tá nüxü̃ pecuèx na paxa tá nagu napogüexü̃ ya yima ĩãne. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","—Rü yíxema Yudéaanewa ngẽxmagüxe rü name nixĩ i mèxpǘneãnewa tabuxmü. Rü yíxema Yerucharéü̃wa ngẽxmagüxe rü tanaxwèxe na paxa ítachoxü̃xü̃. Rü yíxema tümaãnewa ngẽxmagüxe rü tama name na ĩãnecèx tawoeguxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","—Erü ngẽma ngunexü̃gügu tá ínangu i Tupanaãrü poxcu. Rü ngẽmaãcü tá nayanguxẽẽ i guxü̃ma i ngẽma norü ore i ümatüxü̃wa nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","—Rü ngẽma ngunexü̃gügu rü tá poraãcü tüxü̃́ naguxcha ya yíxema ngexegü ya iitacharaü̃güxe rü yíxema imaĩxãcügüxe. Erü tá nangẽxma i taxü̃ i ngúxü̃, rü Tupana rü poraãcü tá nanapoxcue i ngẽma duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","—Rü ñuxre, rü tá norü uwanügü taramaã nanadai. Rü togü, rü tá ínanayauxü̃ na to i nachiü̃ãnewa nagagüãxü̃cèx. Rü ñu̱xũchi i ngẽma norü uwanügü rü tá nagu napogüe ya yima ĩãne ya Yerucharéü̃. Rü ngẽmaãcü tá nangupetü ñu̱xmatáta nawa nangu na Tupana ínamuxü̃xü̃ i nge̱ma. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—Rü ngexguma rü tá nango̱x i cuèxruxü̃gü. Rü üèxcü rü tauemacü rü woramacurigü rü tá nixĩgachitanü i nachicawa.. Rü guxü̃ i nachiü̃ãnegüwa rü duü̃xü̃gü rü tá nanaxi̱xãchiãẽtanü rü tá naḇaixãchiãẽgü namaã na poraãcü naxãũgaãchixü̃ i taxü̃ i taxtü rü norü yuapegü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","—Rü duü̃xü̃gü rü norü muü̃maã tá inayayiãxẽ i ngẽxguma nüxü̃ nadaugu i ngẽma üpetüchaü̃xü̃ i ñoma i naãnewa. Erü woo guxü̃ma i ṯacü i daxũwa nüxü̃ idauxü̃ rü tá naxĩã̱xãchitanü rü tá nu ne nanaxĩmare. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","—Rü ngẽxguma rü guxü̃ i duü̃xü̃gü i ñoma i naãnecü̱̃ã̱x rü tá choxü̃ nadaugü i ngẽxguma wüxi i caixanexü̃gu ícharüxĩ̱xgu rü núma chaxũxgu namaã i chorü pora rü üüne. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","—Rü ngẽxguma inaxügügu na naxüpetüxü̃ i ngẽma pemaã nüxü̃ chixuxü̃, rü name nixĩ na petaãẽgüxü̃ rü meã pedaunagüxü̃, erü paxa tá íchangu na pexü̃ íchanguxü̃xẽẽxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Rü yemawena rü wüxi ga ore ga cuèxruü̃xü̃ namaã nixu ga Ngechuchu, rü ñanagürü: —¡Dücèx penangugü i iguera, rü ẽ́xna ngẽxü̃rüüxü̃mare i to i naĩgü! ");
INSERT INTO tcaNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","—Rü ngẽxguma nüxü̃ pedèu̱xgu na ngexwaca naxüátüxü̃, rü ngẽmawa nüxü̃ pecuèx na paxa tá taunecü na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","—Rü ngẽxgumarüü̃ ta i ngẽxguma nüxü̃ pedèu̱xgu na nangupetüxü̃ i ngẽma pemaã nüxü̃ chixuxü̃, rü ngẽmawa tá nüxü̃ pecuèx na yimama yiĩxü̃ ya Tupana na ãẽ̱xgacü yiĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","—Aixcüma pemaã nüxü̃ chixu rü guxü̃ma i ngẽma nüxü̃ chixuxü̃ rü tá ningu naxü̃pa na nayuexü̃ i duü̃xü̃gü i ñu̱xma maxẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","—Daxũguxü̃ i naãne rü ñoma i naãne rü tá nagu̱x. Natürü chorü ore rü tagutáma inayarüxo. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","—¡Pexuãẽgü na tama ṯacü rü chixexü̃gagu düxwa nüxü̃ perüxoexü̃ na peyaxõgüxü̃! Rü ngẽmacèx penaxwèxe na pegüna pedaugüxü̃ na tama pengãxẽxü̃ rü ẽ́xna ñoma i naãneãrü ngúchaü̃guama na perüxĩnüẽxü̃. Erü ngürüãchi ngẽmagu íperüxĩnüẽyane tá pexü̃ íchayaḇaixgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","—Rü ñoma wüxi ya yüta ya ngürüãchi ṯacü iyaxúnerüü̃ tá nixĩ naxcèx i guxü̃ma i duü̃xü̃gü i ñoma i naãnecü̱̃ã̱x i ngẽxguma wenaxãrü núma chaxũxgu. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","—Rü ngẽmacèx name nixĩ i pegü ípemexẽẽgü. ¡Rü guxü̃guma peyumüxẽgü na ngẽmaãcü tama pexü̃ naxüpetüxü̃cèx i ngẽma ãũcümaxü̃gü, rü aixcüma pimexü̃cèx i ngẽxguma chopẽ́xewa pengugügu! —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Rü guxü̃ ga ngunexü̃gügu rü tupauca ga taxü̃newa nayexma ga Ngechuchu, rü duü̃xü̃güxü̃ nangúexẽẽ. Rü chütacü rü guma Mèxpǘne ga Oríbunecügu ãe̱ganegu nayapeexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Rü guxü̃ma ga duü̃xü̃gü rü pèxmamaxü̃chi tupauca ga taxü̃newa nangugüxü̃ na Ngechuchuxü̃ naxĩnüẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Rü marü ningaica ga Yudíugüarü peta ga Üpetüchiga ga nagu nangõ̱xgüãxü̃ ga pãũ ga ngearü puxẽẽruü̃ã́xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Rü ga paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ rü naxcèx nadaugü ga ñuxãcü duü̃xü̃güechita Ngechuchuxü̃ na yamèxgüxü̃, yerü duü̃xü̃güxü̃ namuü̃ẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Rü yexguma ga Chataná rü Yuda ga Icariútegu nangaxi. Rü nüma ga Yuda rü yema 12 ga Ngechuchuarü ngúexü̃gü ga imugüxü̃tanüxü̃chirẽ́x nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Rü nüma ga Yuda rü ínayadau natanüwa ga paigüarü ãẽ̱xgacügü rü tupauca ga taxü̃neãrü purichíagüarü ãẽ̱xgacügü. Rü namaã nüxü̃ nixu ga ñuxãcü na natauxchaxü̃ ga Ngechuchuxü̃ na yayauxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Rü nümagü ga yema ãẽ̱xgacügü rü nataãẽgü. Rü dĩẽru Yudana ngĩxü̃ naxuaxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Rü Yuda rü ngixü̃ nayaxu ga yema dĩẽru. Rü inanaxügü ga naxcèx na nadauxü̃ ga ñuxãcü duü̃xü̃güechita Ngechuchuxü̃ na yayauxgüxü̃ ga ãẽ̱xgacügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Rü nawa nangu ga yema petaarü ngunexü̃ ga nagu nangõ̱xgüãxü̃ ga pãũ ga ngearü puxẽẽruü̃ã́xü̃. Rü yema nixĩ ga ngunexü̃ ga nagu carneruxacü yamèxgüxü̃ naxcèx ga Üpetüchigaarü peta. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Rü Ngechuchu nanamu ga Pedru rü Cuáü̃, rü ñanagürü nüxü̃: —¡Peyamexẽẽ̱x i tórü õna i Üpetüchigacèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Rü nümagü Ngechuchuxü̃ nangãxü̃gü, rü ñanagürügü: —¿Ngextá nixĩ i cunaxwèxexü̃ na tanamexẽẽxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Ngẽxguma Yerucharéü̃wa pengugügu rü ngẽxma tá nüxü̃ peyangau i wüxi ya yatü i wüxi i tü̃xü̃ i dexámaã ããcuxcü ngĩxü̃ ingexü̃. ¡Rü nawe perüxĩ ñu̱xmatáta napatawa pengugü! ");
INSERT INTO tcaNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","—¡Rü yima ĩpata ya nagu yaxücune ya yima yatü, rü yima ĩãrü yoramaã nüxü̃ pixu rü ñapegügü nüxü̃: “Torü ngúexẽẽruü̃ rü nüxü̃ nacuáxchaü̃ na ngẽxü̃rüüxü̃ yiĩxü̃ i ngẽma ucapu i norü ngúexü̃gümaã tá nawa nachibüxü̃ i Üpetüchigaarü õnacèx”, ñapegügü nüxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","—Rü tá pexü̃ nüxü̃ nadauxẽẽ i wüxi i ucapu i taxü̃ i marü mexẽẽxü̃ i norü daxũchiü̃wa ngẽxmaxü̃. ¡Rü ngẽmawa tá penamexẽẽ i ngẽma õna i Üpetüchigacèx ixĩxü̃! —ñanagürü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Rü yéma naxĩ ga nümagü rü nüxü̃ inayangaugü ga guxü̃ma yema Ngechuchu namaã nüxü̃ ixuxü̃rüü̃. Rü yéma nanamexẽẽgü ga õna ga Üpetüchigacèx ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Rü yexguma nawa nanguxgu ga ora ga na nachibüexü̃, rü mechawa narüto ga Ngechuchu namaã ga norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Rü yexguma ga Ngechuchu rü ñanagürü: —Ñuxãcü poraãcü choxü̃́ nangúchaü̃ na pemaã chachibüxü̃ i ñaã Üpetüchigaarü õnawa naxü̃pa na chayuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","—Natürü pemaã nüxü̃ chixu rü tãũtáma wenaxãrü Üpetüchigaarü õnawa chachibü, ñu̱xmatáta chowa yangu i ngẽma Tupana naxwèxexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Rü yexguma nanayaxu ga wüxi ga pochiyu ga binumaã ããcuxü̃. Rü Tupanana moxẽ naxãxĩra, rü ñu̱xũchi ñanagürü nüxü̃ ga norü ngúexü̃gü: —¡Peyaxaxü ya daa binu, rü pegümaã pengau! ");
INSERT INTO tcaNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","—Erü pemaã nüxü̃ chixu rü tagutáma wena chayaxaxü ya binu ñu̱xmatáta nawa nangu na pecaduarü ütanücèx chayuxü̃ na aixcüma pemaã inacuáxü̃cèx ya Tupana —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Rü nanayaxu ta ga pãũ, rü Tupanana moxẽ naxcèx naxã. Rü ñu̱xũchi inanabücu, rü norü ngúexü̃güna nanaxã. Rü ñanagürü nüxü̃: —Ñaã pãũ rü chaxune i pexcèx yuxü̃chiga nixĩ. ¡Rü ñaãwena rü ñaãcü tá penaxü na choxna pecuèxãchiexü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Rü marü chibüwena rü to ga pochiyu ga binumaã ããcuxü̃ norü ngúexü̃güna naxã, rü ñanagürü: —Daa binu rü Tupanaãrü uneta i ngexwacaxü̃xü̃ãrü cuèxruü̃ nixĩ. Rü chaugü ya pexcèx ibacüwa Tupana pexü̃ nüxü̃ nadauxẽẽ na aixcüma yiĩxü̃ i ngẽma norü uneta. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","—Natürü ngẽma yatü i chauechita ãẽ̱xgacügüna choxü̃ muxchaü̃xü̃, rü nuã mechawa tamaã narüto i ñu̱xmax. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","—Rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü Chaunatü ixunetaxü̃rüü̃ tá chayu. Natürü wüxi i ngechaü̃xü̃chi tá nixĩ naxcèx i ngẽma yatü i ãẽ̱xgacügüna choxü̃ muxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Rü yexguma ga norü ngúexü̃gü rü inanaxügüe ga nügüna na nacagüexü̃, rü ñanagürügü: —¿Texé tá tixĩ ya yíxema naẽchita ãẽ̱xgacügüna namuxẽ? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Rü yexguma ga yema ngúexü̃gü rü nügümaã niporagatanücüü nachiga na texé tá tiĩxü̃ ya natanüwa guxããrü yexera ixĩxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —Ñoma i naãnewa rü guxü̃ i nachiü̃ãnegüarü ãẽ̱xgacügü, rü poraãcü norü duü̃xü̃güxü̃ namugü. Rü ñu̱xũchi nügü yaxugügu rü norü duü̃xü̃güarü dauruü̃ i mexü̃gü nixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","—¡Natürü pema rü tãũtáma ngẽxgumarüü̃ pixĩgü! Rü ngẽxguma texé naxwèxegu na guxããrü yexera tiĩxü̃ i petanüwa, rü name nixĩ na tügü ítarüxíraxü̃ i guxü̃ma i tümamücügütanüwa. Rü texé naxwèxegu na peeru tiĩxü̃ i petanüwa, rü name nixĩ i noxri rü guxããrü ngü̃xẽẽruü̃ tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","—Rü ñoma i naãnewa rü corigü rü mechawa narütogü na nachibüexü̃cèx, rü norü duü̃xü̃gü nixĩ i ngẽma naxcèx õna ixüxü̃ rü nüxü̃ rüngü̃xẽẽxü̃. Natürü tatanüwa rü tama ngẽmaãcü nixĩ, erü choma i perü cori na chiĩxü̃ rü perü ngü̃xẽẽruü̃ chixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Rü pemagü nixĩ ga guxü̃guma chauxü̃tawa peyexmagüxü̃ ga yexguma ngúxü̃ chingexgu. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","—Rü ngẽmacèx i choma rü ãẽ̱xgacügüxü̃ pexü̃ chixĩgüxẽẽ yema chaunatü ãẽ̱xgacüxü̃ choxü̃ ingucuchixẽẽxü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","—Rü ngẽmaãcü ãẽ̱xgacü íchixĩxü̃wa rü chomaã tá pechibüe rü tá pexaxegü. Rü ãẽ̱xgacüchicawa tá perütogü na norü maxü̃cèx nüxna pecagüxü̃ i guxü̃ma i Yudíugü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Rü Pedruxü̃ ñanagürü ta ga Cori ga Ngechuchu: —Pa Pedrux, Chataná rü pexcèx ínaca na chixexü̃maã poraãcü pexü̃ naxüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","—Natürü choma rü Chaunatüxü̃ cuxcèx chacèèxü̃ na taguma nüxü̃ curüxoxü̃cèx na cuyaxõxü̃. Rü ngẽmacèx i cumax, Pa Pedru, rü ngẽxguma chauxcèx cutaeguxgu, rü chanaxwèxe i nüxü̃ curüngü̃xẽẽ i cumücügü na nümagü rü yaxõgüechaãxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Rü ñanagürü ga Pedru: —Pa Corix, choma rü marü íchamemare na wüxigu cumaã na chapoxcuxü̃ rü ẽ́xna wüxigu cumaã na chayuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Natürü Ngechuchu rü ñanagürü nüxü̃: —Pa Pedrux, cumaã nüxü̃ chixu rü ñomatama i chütaxü̃gu naxü̃pa na otá ic̱axü̃, rü cuma rü tomaẽ̱xpü̱xcüna tá nüxü̃ quixu na tama choxü̃ cucuáxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Rü yexguma ga Ngechuchu rü norü ngúexü̃güna naca, rü ñanagürü: —Yexguma pexü̃ chimugügu ngearü chocaã̱xgüxemaã rü ngearü dĩẽruã̱xgüxemaã rü ngearü chapatuã̱xgüxemaã, ¿rü ṯacü pexü̃́ taxuxü̃ ga yexguma? —ñanagürü. Rü nümagü nanangãxü̃gü rü ñanagürügü: —Taxuü̃ma —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Rü yexguma norü ngúexü̃güxü̃ ñanagürü ga Ngechuchu: —Natürü ñu̱xma rü texé ya petanüwa ya chocaã́xẽ rü tanaxwèxe na ítayangexü̃ i tümaãrü choca rü tümaãrü dĩẽruchixü̃ rü ta. Rü ngẽxguma texé ngearü taraã̱xgu rü tanaxwèxe i namaã tataxe i tümaãrü gáuxü̃chiru na tümaãrü poxü̃ruü̃ i taracèx tataxexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","—Erü pemaã nüxü̃ chixu rü chauchiga nixĩ i ngẽma Tupanaãrü ore i ümatüxü̃ i ñaxü̃: “Wüxi i máẽtaxü̃rüü̃ tá nanapoxcugü rü tá nayamèxgü”, ñaxü̃. Erü guxü̃ma i ngẽma chauchiga ümatüxü̃ i Tupanaãrü ore i ümatüxü̃wa rü aixcüma ngẽmaãcü tá ningu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Rü yexguma ga norü ngúexü̃gü rü ñanagürügü: —Pa Corix, nuã nangẽxma i taxre i tara —ñanagürügü. Rü nüma ga Ngechuchu rü nanangãxü̃ rü ñanagürü: —Marü ningu i ngẽma —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Rü yexguma ga Ngechuchu rü ínaxũxũ ga guma ĩãnewa. Rü Oríbunecüarü Mèxpǘnewa naxũ, yerü woetama nacüma nixĩ ga yéma na naxũũxü̃xü̃. Rü norü ngúexü̃gü rü ta nawe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Rü yexguma yema nachicawa nanguxgu, rü norü ngúexü̃güxü̃ ñanagürü: —¡Tupanana naxcèx pec̱a na pexü̃ nangü̃xẽẽxü̃cèx na tama Chatanáãrü ügagu chixexü̃gu pey̱ixü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Rü yexguma ga Ngechuchu rü yéamaxü̃ra 50 ga metruwa norü ngúexü̃güna naxũ. Rü yexma nacaxã́pü̱xü rü nayumüxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Rü ñanagürü: —Pa Chaunatüx, ngẽxguma cuma cunaxwèxegu, ¡rü nüxna choxü̃ ínanguxuchixẽẽ i ñaã ngúxü̃ i tá choxü̃ üpetüxü̃! Natürü chanaxwèxe i cunaxü i curü ngúchaü̃ rü tama i choxrü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Rü yexguma wüxi ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃ rü naxcèx nango̱x, rü nanaporaxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Rü poraãcü nanaxi̱xãchiãẽ ga Ngechuchu, rü yemacèx yexeraãcü nayumüxẽ. Rü yema na naxi̱xãchiãẽxü̃maã poraãcü nanaxaiyaãchi. Rü guma norü aiyacümaã nichuruxü̃ne. Rü ñoma nagü waixü̃müãnewa ichuruxü̃rüü̃ nixĩ ga norü aiyacü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Rü yema ínayumüxẽxü̃wa rü inachi ga Ngechuchu, rü norü ngúexü̃gütanüwa naxũ. Rü nüxü̃ inayangau ga na ínapeexü̃ yerü norü ngechaü̃maã düxwa nayaxtae. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ ípepee? ¡Íperüdagü rü Tupanana naxcèx pec̱a na pexü̃ nangü̃xẽẽxü̃cèx na tama Chatanáãrü ügagu chixexü̃gu pey̱ixü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Rü yexguma íyadexayane ga Ngechuchu, rü yéma nangugü ga muxü̃ma ga duü̃xü̃gü. Rü Yuda ga Ngechuchuarü ngúexü̃chirẽ́x ixĩxü̃ nixĩ ga naxũpẽ́xexü̃. Rü Ngechuchucèx nixũ na nüxü̃ nachúxãcüma nüxü̃ namoxẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Rü Ngechuchu rü ñanagürü: —Pa Yudax, ¿tü̱xcüü̃ wüxi i chúxumaã cuchauechitae? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Rü yema togü ga Ngechuchuarü ngúexü̃gü ga naxü̃tawa yexmagüxü̃, rü yexguma nüxü̃ nadaugügu ga yema ngupetüxü̃ rü ñanagürügü nüxü̃: —Pa Corix, ¿cunaxwèxexü̃ na taramaã tanadèi̱xü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Rü wüxi ga Ngechuchuarü ngúexü̃ rü paigüarü ãẽ̱xgacüarü duü̃xü̃xü̃ nanapi̱xẽẽ, rü ínanadae ga norü tügünechinü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Natürü Ngechuchu rü ñanagürü: —¡Ngexrüma na pegü namaã pedèi̱xü̃! —ñanagürü. Rü yexguma ga Ngechuchu rü yema yatü ga ídaechinüxü̃xü̃ ningõgü, rü nanamexẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Rü Ngechuchu namaã nidexa ga yema ãẽ̱xgacügü ga norü yauxwa yéma ĩxü̃. Rü yema ãẽ̱xgacügütanüwa nayexmagü ga paigüarü ãẽ̱xgacügü, rü tupauca ga taxü̃neãrü purichíagüarü ãẽ̱xgacügü, rü Yudíugüarü ãẽ̱xgacügüerugü. Rü Ngechuchu rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ taragü rü naĩxmenèxãgümaã chauxcèx nuã pexĩ ñoma wüxi i ngĩ́tèxáxü̃ chiĩxü̃rüü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","—Rü guxü̃ ga ngunexü̃gu ga yexguma petanüwa chayexmagu ga tupauca ga taxü̃newa, rü tama choxü̃ piyauxgü. Natürü marü nawa nangu na pexü̃́ natauxchaxü̃ na choxü̃ piyauxgüxü̃, erü ñoma nixĩ i ora na naporaxü̃ i Chataná —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Rü Ngechuchuxü̃ niyauxgü, rü paigüarü ãẽ̱xgacüpatawa nanagagü. Rü Pedru rü nawe narüxũ, natürü yaxü̃guma nüxü̃́ nixũchigü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Rü yéma paigüarü ãẽ̱xgacüpataèxtüarü ngãxü̃wa, rü purichíagü nanaxügü ga wüxi ga üxü. Rü nüxü̃ ínachomaẽguãchi. Rü Pedru rü ta yéma natanüwa narüto. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Rü yexguma yéma üxücutüwa nato̱xgu ga Pedru, rü wüxi ga ngecü ga ãẽ̱xgacüarü duü̃xü̃ nüxü̃ idau. Rü meãma nüxü̃ idawenü, rü ngĩgürügü: —Ñaã yatü rü Ngechuchutanüxü̃ nixĩ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Natürü Pedru rü tama nüxü̃ nacuáxchaü̃ ga yema ore, rü ñanagürü: —Pa Ngecüx, choma rü tama nüxü̃ chacuèx ya yima Ngechuchu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Natürü yixcamaxü̃ra rü to ga duü̃xü̃ Pedruxü̃ nadau, rü ñanagürü nüxü̃: —Cuma rü ta Ngechuchutanüxü̃ quixĩ —ñanagürü. Natürü Pedru nanangãxü̃ rü ñanagürü: —Tama nixĩ, Pa Yatüx. Tama natanüxü̃ chixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Rü wüxi ga ora ngupetüguwena rü to ga duü̃xü̃ rü nüxĩ ñanagürüama: —Aixcümaxü̃chi ñaã yatü rü Ngechuchutanüxü̃ nixĩ, erü Gariréaanecü̱̃ã̱x nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Rü yexguma ga Pedru rü ñanagürü: —Pa Yatüx, tama nüxü̃ chacuèx na ṯacüchigaxü̃ quixuxü̃ —ñanagürü. Rü yexgumatama Pedru íidexayane rü nica ga otá. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Rü yexguma ga Cori ga Ngechuchu rü Pedrucèx nügü ínidau. Rü nüma ga Pedru rü nüxna nacuèxãchi ga yema ore ga Cori ga Ngechuchu namaã nüxü̃ ixuxü̃ ga ñaxü̃: “Ñomatama i chütaxü̃gu naxü̃pa na otá ic̱axü̃, rü tomaẽ̱xpü̱xcüna taxũtáma cugü quixu na chorü duü̃xü̃ quiĩxü̃”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Rü yexguma ga Pedru rü ínaxũxũ ga yéma. Rü poraãcüxüchi naxaxu. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Rü yema yatügü ga Ngechuchuna daugüxü̃, rü nagu nidauxcüraü̃gü, rü nüxna nanac̱uaixcagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Rü nayadüxétügü, rü nachiwegu nidagügü, rü ñanagürügü: —¡Nüxü̃ nacuèx na texé cuxü̃ na idagüxü̃! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Rü muxü̃ma ga to ga ore ga chixexü̃ namaã nixugüe. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Rü yexguma yangunegu rü nangutaquẽ́xegü ga Yudíugüarü ãẽ̱xgacügüerugü, rü paigüarü ãẽ̱xgacügü, rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃. Rü ñu̱xũchi norü purichíagüxü̃ namu na napẽ́xewa Ngechuchuxü̃ nagagüxü̃cèx. Rü yéma Ngechuchuna nacagü, rü ñanagürügü: ");
INSERT INTO tcaNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Toma rü nüxü̃ tacuáxchaü̃ rü cuma quiĩxü̃ i Cristu rü ẽ́xna tama. ¡Tomaã cugü ixu! —ñanagürügü. Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Ngẽxguma chi pemaã nüxü̃ chixuxgu na choma chiĩxü̃ i Cristu, rü tãũ chima choxü̃́ peyaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","—Rü ngẽxguma chi pexna chacaxgu na ṯacücèx choxna pec̱axü̃, rü tãũ chima choxü̃ pengãxü̃ga, rü tãũ chima choxü̃ pingẽ́xgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","—Natürü ñu̱xmawena rü choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃ rü Chaunatü ya Tupana ya poracüxü̃tawa tá changẽxma —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Rü yexguma guxü̃ma ga yema ãẽ̱xgacügü nüxna nacagü, rü ñanagürügü: —¿Ẽ́xna cuma quiĩxü̃ i Tupana Nane? —ñanagürügü. Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Ngü̃. Tupana Nane chixĩ ngẽxgumarüü̃ i pematama nüxü̃ pixuxü̃rüü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Rü yexguma nügümaã ñanagürügü ga yema ãẽ̱xgacügü: —Ñu̱xma rü marü taxucèxma naxcèx tadau i to i duü̃xü̃gü i nüxü̃ ixuxü̃ i ñaã yatüchiga. Erü yixematama marü naã̱xwatama nüxü̃ taxĩnüẽ i norü ore na ñuxũ ñaxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Rü guxü̃ma ga yema ãẽ̱xgacügü rü inachigü, rü ãẽ̱xgacü ga Dumacü̱̃ã̱x ga Piratuxü̃tawa Ngechuchuxü̃ nagagü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Rü yéma Piratupẽ́xewa inanaxügüe ga Ngechuchuxü̃ na yaxugüexü̃. Rü ñanagürügü: —Ñaã yatü rü nüxü̃ itayangaugü na cumaã nanuẽxẽẽãxü̃ i duü̃xü̃gü. Rü tomaã nüxü̃ nixu na tama namexü̃ na ãẽ̱xgacü ya Dumawa ngẽxmacüaxü̃́ na tanaxütanüxü̃. Rü nügü nixu na nüma na yiĩxü̃ i torü ãẽ̱xgacü i Cristu —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Rü yexguma ga Piratu rü Ngechuchuna naca rü ñanagürü: —¿Cuma quiĩxü̃ i Yudíugüarü ãẽ̱xgacü? —ñanagürü. Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Ngẽmáãcü, ngẽma nüxü̃ quixuxü̃ chixĩ i chomax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Rü yexguma ga Piratu rü ñanagürü nüxü̃ ga paigüarü ãẽ̱xgacügü rü togü ga duü̃xü̃gü: —Chauxcèx rü taxuü̃ma i chixexü̃ naxü i ñaã yatü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Natürü nümagü rü yexeraãcü Ngechuchuxü̃ nixugüeama, rü ñanagürügü: —Nüma rü guxü̃ i Yudéaanewa nanangúexẽẽ i duü̃xü̃gü na cuxchi naxaiexü̃cèx. Rü Gariréaanewa inanaxügü ga yemaãcü na duü̃xü̃güxü̃ nangúexẽẽxü̃, rü ngẽmaãcü nanaxü ñu̱xmata núma Yudéaanewa nangu —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Rü yexguma yemaxü̃ naxĩnügu ga Piratu, rü duü̃xü̃güna naca rü ngoxi Gariréaanecü̱̃ã̱x yixĩ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Rü yexguma Piratu nüxü̃ ĩnügu ga aixcüma Gariréaanecü̱̃ã̱x na yiĩxü̃ ga Ngechuchu rü Gariréaaneãrü ãẽ̱xgacü ga Erodexü̃tawa nanamu, yerü Yerucharéü̃wa nayexma ga Erode ga yexguma. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Rü yexguma Ngechuchuxü̃ nadèu̱xgu ga Erode rü nataãẽxü̃chi. Yerü nuxcümama poraãcü nüxü̃ nadauxchaü̃, yerü ü̃paacü nüxü̃ naxĩnü ga nachiga. Rü ínananguxẽẽ na Ngechuchuxü̃ nadauxchaü̃xü̃ na napẽ́xewa naxüãxü̃ ga wüxi ga mexü̃ ga taxü̃ ga Tupanaãrü poramaã naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Rü muẽ̱xpü̱xcüna Ngechuchuna naca ga Erode. Natürü Ngechuchu rü tama nanangãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Rü yéma nayexmagü ta ga paigüarü ãẽ̱xgacügü rü ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃. Rü nümagü rü poraãcü Ngechuchuxü̃ ínaxuaxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Rü yexguma ga Erode rü norü churaragü rü poraãcü chixri Ngechuchumaã nachopetü. Rü nagu nidauxcüraü̃gü. Rü ñu̱xũchi wüxi ga ãẽ̱xgacüchirugu nayacu̱xẽẽgü na yemaãcü nüxü̃ nacugüexü̃cèx. Rü yemawena Piratuxü̃ta wenaxãrü Ngechuchuxü̃ namu ga Erode. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Rü woo ü̃paacü ga Piratu rü Erodemaã nügüchi na naxaiexü̃, natürü yema ngunexü̃gu nixĩ ga nügümaã nangüxmüẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Rü yexguma ga Piratu rü nanangutaquẽ́xexẽẽ ga paigüarü ãẽ̱xgacügü, rü togü ga Yudíugüarü ãẽ̱xgacügü, rü guxü̃ma ga duü̃xü̃gü ga yéma yexmagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Rü Piratu ñanagürü nüxü̃: —Pema nuã chauxcèx penaga i ñaã yatü, rü nüxü̃ pixu na chomaã nanuẽxẽẽãxü̃ i duü̃xü̃gü. Natürü pepẽ́xewa nüxna chaca i ngẽmachiga rü ñu̱xma rü marü nüxü̃ pedau na taxuü̃ma nawa ichayangauxü̃ i ngẽma chixexü̃ i naxcèx ípenaxuaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","—Rü Erode rü ta taxuü̃ma nawa inayangau i ngẽma chixexü̃, rü ngẽmacèx wenaxãrü taxcèx nanamuẽgu. Rü dücax, taxuü̃ma i chixexü̃ naxü na ngẽmagagu nayuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","—Rü ngẽmacèx chorü churaragüxü̃ tá chamu na nac̱uaixgüãxü̃cèx, rü ñu̱xũchi tá chayangẽ́x —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Rü nüma ga Piratu rü guxü̃guma ga yexguma yema petawa nanguuü̃xgu rü duü̃xü̃güxü̃ nataãẽxẽẽchaü̃ namaã ga na yangéãxü̃ ga wüxi ga yatü ga poxcuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Natürü guxü̃ma ga yema duü̃xü̃gü rü wüxigu inanaxügüe ga aita na naxüexü̃. Rü ñanagürügü: —¡Napoxcu i ngẽma Ngechuchu! ¡Rü Barabáxü̃ waxi ínanguxuchixẽẽ! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Rü yema Barabá rü napoxcu yerü ü̃paacü Yerucharéü̃wa ãẽ̱xgacümaã nananuẽxẽẽ ga duü̃xü̃gü, rü ñu̱xũchi namáẽta. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Natürü ga Piratu rü wenaxãrü duü̃xü̃gümaã nidexa, yerü nüma rü Ngechuchuxü̃ ningéxchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Natürü ga duü̃xü̃gü rü yexeraãcü aita naxüe rü ñanagürügü: —¡Curuchawa yapota! ¡Curuchawa yapota! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Rü Piratu norü tomaẽ̱xpü̱xcüna duü̃xü̃gümaã nidexa, rü ñanagürü: —Dücèx, ¿ṯacü rü chixexü̃ ẽ́xna naxü? Choma rü taxuü̃ma i chixexü̃xü̃ nawa ichayangau na ngẽmacèx chanayuxẽẽxü̃. Rü chorü churaragüxü̃ tá chamu na nac̱uaixgüãxü̃cèx, rü ñu̱xũchi tá chayangẽ́x —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Natürü nümagü ga duü̃xü̃gü rü yexeraãcü aita naxüeama, rü naxcèx ínacagü na curuchawa yapotaãxü̃cèx. Rü yema na nayexeragüamaxü̃ ga yema duü̃xü̃gü rü düxwa ga Piratu rü duü̃xü̃güga naxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Rü nüma ga Piratu rü norü churaragüxü̃ namu na naxügüãxü̃cèx ga yema duü̃xü̃gü naxwèxegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Rü Barabáxü̃ ningẽ́x, yerü yema nixĩ ga duü̃xü̃gü naxcèx ícagüxü̃. Rü yema Barabá nixĩ ga poxcuxü̃ naxcèx na duü̃xü̃güxü̃ ãẽ̱xgacümaã nanuẽxẽẽxü̃ rü namáẽtaxü̃. Rü yexguma ga Piratu rü duü̃xü̃güna Ngechuchuxü̃ namu na namaã naxügüãxü̃cèx ga yema nümagü nanaxwèxegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Rü yema duü̃xü̃gü rü Ngechuchuxü̃ nigagü na curuchawa yanapotagüãxü̃cèx. Rü yexguma Ngechuchuxü̃ yagagüyane, rü yexma namagu nüxü̃ nangaugü ga wüxi ga yatü ga Chirenecü̱̃ã̱x ga naãnewa ne ũcü. Rü Chimáũ nixĩ ga nae̱ga. Rü Chimáũxü̃ niyauxgü ga duü̃xü̃gü, rü naãtügu ngĩxü̃ naxünagügü ga curucha na Ngechuchuwe ngĩxü̃ nangexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Rü muxü̃ma ga duü̃xü̃gü rü nawe narüxĩ. Rü yema duü̃xü̃gütanüwa nayexmagü ga muxü̃ma ga ngexü̃gü ga auxexü̃ rü aita üexü̃, yerü Ngechuchucèx nangechaü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Natürü ga Ngechuchu rü yema ngexü̃güxü̃ nadawenü, rü ñanagürü nüxü̃: —Pa Ngecügüx, Pa Yerucharéü̃cü̱̃ã̱x ¡tãxṹ i chauxcèx pexauxexü̃, natürü pegücèxtama pexauxe rü pexacügücèx! ");
INSERT INTO tcaNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","—Erü nawa tá nangu i ngunexü̃gü i nagu ñagüxü̃ tá i duü̃xü̃gü: “Tataãẽgü ya yíxema ngeã̱xta ya taxuacüma ãxãcügüxe, rü taguma tacharaü̃güxe, rü taguma maĩxãcügüxe, erü taxucatáma tümaxãcügücèx taxauxe”, ñagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","—Rü ngẽxguma i duü̃xü̃gü rü tá mèxpǘnegüxü̃ nacèèxü̃gü rü ñanagürügü tá: “¡Toétügu rübuemü!” ñanagürügü tá. Rü tá ngüchitaerugüxü̃xü̃ nacèèxü̃gü, rü ñanagürügü tá: “¡Toxü̃ idüxétügü!” ñanagürügü tá. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","—¿Erü ñuxãcü tá namaã nachopetü i ngẽma duü̃xü̃gü i aixcüma chixexü̃ ügüxü̃, ega ñaã chixexü̃ chomaã naxügügu na woo taxuü̃ma i chixexü̃ chaxüchiréxü̃? —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Rü yéma nanagagü ta ga taxre ga máẽtagüxü̃ na Ngechuchurüü̃ curuchawa yanapotagüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Rü yexguma nawa nangugügu ga yema nachica ga Duü̃xẽẽruchinèxãgu ãe̱gaxü̃, rü yéma curuchawa Ngechuchuxü̃ nipotagü. Rü yema taxre ga máẽtagüxü̃ rü ta Ngechuchurüü̃ curuchawa nipotagü, wüxi ga norü tügünecüwawa rü to ga norü ṯoxwecüwawa. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Rü yexguma Ngechuchuxü̃ curuchawa íyapotagüyane, rü ñanagürü ga Ngechuchu: —Pa Chaunatüx, ¡nüxü̃ nangechaü̃ i ñaã duü̃xü̃gü, erü tama nüxü̃ nacuèxgü na ṯacü rü chixexü̃ naxüexü̃! —ñanagürü. Rü yema churaragü rü nanade ga Ngechuchuchiru. Rü ñu̱xũchi wüxi ga dĩẽru ngĩxü̃ nañanagügü na yemawa nüxü̃ nacuèxgüxü̃cèx na texéarü tá yiĩxü̃ ga yema Ngechuchuchiru. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Rü duü̃xü̃gü rü yéma inarüdaunü. Natürü yema Yudíugüarü ãẽ̱xgacügü rü Ngechuchuxü̃ nacugüe, rü ñanagürügü: —Nüma rü togüxü̃ namaxẽxẽẽ. ¡Ẽcü, ñu̱xma rü nügütama namaxẽẽ ega aixcüma Cristu ya Tupana nüxü̃ unetacü yixĩgu! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Rü yema churaragü rü ta Ngechuchuxü̃ nacugüe. Rü naxü̃tawa naxĩ, rü nüxna nanaxã ga binu ga üxchiücü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Rü ñanagürügü nüxü̃: —Ega Yudíugüarü ãẽ̱xgacü ya tacü quixĩgu, ¡rü cugütama rüngü̃xẽẽ i ñu̱xmax, na ícunguxuchixü̃cèx! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Rü norü curuchatapẽ́xewa nipota ga wüxi ga mürapewaxacü ga ãe̱gatachinüxü̃ ga Griégugügawa rü Dumacü̱̃ã̱xgügawa rü Yudíugügawa ümatüxü̃ ga ñaxü̃: —Daa nixĩ ya Yudíugüarü Ãẽ̱xgacü ya Tacüxüchi —ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Rü wüxi ga yema máẽtaxü̃ ga naxrüü̃ curuchawa ipotaxü̃ rü Ngechuchumaã naguxchiga, rü ñanagürü: —Ega aixcüma Cristu quixĩgu, ¡rü cugütama rüngü̃xẽẽ na ícunguxuchixü̃cèx, rü toxü̃ rü ta rüngü̃xẽẽ na ítanguxü̃xü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Natürü ga yema to ga máẽtaxü̃ rü namücüxü̃ ínangaxüchiama, rü ñanagürü nüxü̃: —Cuma rü naxrüü̃ na curuchawa quipotachiréxü̃, ¿rü ngẽxguma rü ta tama Tupanaxü̃ cumuü̃xü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","—Yixema rü name nixĩ na ipoxcuexü̃ erü tagagutama nixĩ i ngúxü̃ ingegüxü̃ erü ngẽma nixĩ i tórü natanü naxcèx ga yema chixexü̃ ga ixügüxü̃. Natürü daa yatü rü taxuü̃ma i chixexü̃ naxü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Rü yexguma ga yema máẽtaxü̃ rü ñanagürü: —Pa Ngechuchux, ¡choxna nacuèxãchi i ngẽxguma wenaxãrü núma cuxũxgu rü ãẽ̱xgacüxü̃ ícunguxgu! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Aixcüma cumaã nüxü̃ chixu rü ñomatátama i ngunexü̃gu chomaã cungẽxma i mexẽchixü̃ i naãnewa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Rü yexguma tocuchiwa nanguxgu rü guxü̃wama naxẽãne ñu̱xmata tomaẽ̱xpü̱xarü orawa nangu ga yáuanecü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Rü ga üèxcü rü nixo. Rü tupauca ga taxü̃neãrü tüyemachiü̃xü̃ rü ngãxü̃gu narügaute. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Rü yexguma ga Ngechuchu rü poraãcü aita naxü rü ñanagürü: —Pa Chaunatüx, cuxmẽ́xwa chanangẽ́x i chauãẽ —ñanagürü. Rü yema ñaxguwena rü nayu. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rü yexguma yema churaragüarü ãẽ̱xgacü ga Dumacü̱̃ã̱x nüxü̃ dèu̱xgu ga yema ngupetüxü̃, rü Tupanaxü̃ nicuèxüü̃, rü ñanagürü: —Aixcüma ñaã yatü rü taxuü̃ma i chixexü̃ naxü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Rü guxü̃ma ga yema togü ga duü̃xü̃gü ga yéma yexmagüxü̃ rü nüxü̃ daugüxü̃ ga yema ngupetüxü̃, rü poraãcü nangechaü̃güãcüma napatacèx nawoegu. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Natürü guxü̃ma ga yema duü̃xü̃gü ga aixcüma Ngechuchuxü̃ cuèxgüxü̃ rü yaxü̃wa- tama nüxü̃ narüdaunü ga yema ngupetüxü̃. Rü yema duü̃xü̃gütanüwa ta iyexmagü ga yema ngecügü ga Ngechuchuwe rüxĩcü ga yexguma Gariréaanewa ne naxũxgu. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Rü nayexma ga wüxi ga yatü ga Yudéaanewa yexmane ga ĩãne ga Arimatéacü̱̃ã̱x, rü Yúche nixĩ ga nae̱ga. Rü nüma rü Yudíugüarü ãẽ̱xgacügütanüwa naxü, natürü namecüma rü meã namaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Rü nüma rü poraãcü ínananguxẽẽ na ínanguxü̃ ga Tupana na yéma ãẽ̱xgacü yiĩxü̃cèx. Rü yemacèx tama norü me nixĩ ga yema Ngechuchumaã naxügüxü̃ ga yema togü ga namücügü ga ãẽ̱xgacügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Rü nüma ga Yúche rü Piratuxü̃tawa naxũ, rü Ngechuchuxü̃necèx ínayaca. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Rü curuchawa nayayaxu ga Ngechuchuxü̃ne, rü wüxi ga düxruü̃maã nananuque. Rü wüxi ga naxmaü̃ ga nutaarü mèxpǘxü̃wa yacaxmaü̃güxü̃gu nayanaxücuchi. Rü yema naxmaü̃ rü nayexwacaxü̃, rü taguma texéxü̃ nagu yaxücuchigüxü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Rü yema nixĩ ga ngunexü̃ ga nagu Yudíugü nügü imexẽẽgüxü̃ naxcèx ga ngü̃xchigaarü ngunexü̃. Rü marü ningóonechaü̃ ga yema ngü̃xchigaarü ngunexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Rü yema ngecügü ga Ngechuchumaã Gariréaanewa ne ĩcü, rü Ngechuchuxü̃ íyaxücuchigüxü̃wa íiyadaugü. Rü nüxü̃ idaugü ga ñuxãcü na íyaxücuchigüãxü̃ ga naxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Rü yexguma ngĩpatawa nangugügu, rü inamexẽẽgü ga pumara rü chixü̃. Rü irüngü̃gü ga ngü̃xchigaarü ngunexü̃gu, yerü yema nixĩ ga Tupanaãrü mu. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Rü pèxmamaxü̃chi ga yüxüarü ngunexü̃gu, rü yema ngecügü rü wenaxãrü naxmaü̃wa íiyadaugü. Rü yéma inangegü ga yema pumara ga yamexẽẽgüxü̃. Rü naĩgü ga ngecügü rü ta ngĩxü̃ íiyaxümücügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Rü yexguma yéma nangugügu, rü nüxü̃ iiyangaugü ga marü na ínaxügachixü̃ ga guma nuta ga naxmaü̃ãrü ngũxtaü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Rü yexma nagu ichocu, natürü taxuü̃ma idaugü ga naxü̃ne ga Cori ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Rü yema ngecügü rü poraãcü iḇaixãchiãẽgü, rü tama nüxü̃ icuèxgüéga ga ṯacü na naxügüxü̃. Rü ngürüãchi nüxü̃ idaugü ga taxre ga yatügü ga ngĩxü̃tagu chigüxü̃ ga poraãcü iy̱aurachirutanücüüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Rü yema ngecügü rü iyarümaxãchierugü, yerü poraãcü imuü̃ẽ. Rü yemacèx ga yema yatügü rü ñanagürügü ngĩxü̃: —¿Tü̱xcüü̃ nuxã yuetamaü̃gu naxcèx peyadau ya yima maxü̃cü? ");
INSERT INTO tcaNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","—Nataxuma i nuã ya Ngechuchu, erü marü wena namaxü̃. ¡Rü nüxna pecuèxãchie ga yema ore ga pemaã nüxü̃ yaxuxü̃ ga yexguma Gariréaanewa nayexmagu! ");
INSERT INTO tcaNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","—Yerü pemaã nüxü̃ nixu ga ñuxãcü pecaduã̱xgüxü̃ tá na yayauxgüxü̃, rü curuchawa na yapotagüãxü̃, rü ñuxãcü tomaẽ̱xpü̱x i ngunexü̃gu tá wena na namaxü̃xü̃ —ñanagürügü ga yema yatügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Rü yexguma ga yema ngecügü rü nüxna icuèxãchie ga yema Ngechuchuarü ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Rü nüxna iwoegu ga yema naxmaü̃. Rü yema 11 ga Ngechuchuarü ngúexü̃gümaã nüxü̃ iyarüxugüe ga guxü̃ma ga yema nüxü̃ nadaugüxü̃. Rü guxü̃ma ga togü ga yaxõgüxü̃ ga yéma yexmagüxü̃maã rü ta nüxü̃ iyarüxugüe. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Rü María ga Magadácü̱̃ã̱x, rü Cuána, rü María ga Chaü̃tiágu naẽ, rü naĩgü ga ngecügü iyixĩ ga wüxigu yéma Ngechuchuarü ngúexü̃güxü̃tawa nangegücü ga yema ore. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Natürü yema ngúexü̃gücèx rü ĩnücamare nixĩ ga yema ore, rü tama ngĩxü̃́ nayaxõgüchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Natürü ga Pedru rü inañaãchi, rü ínayadau ga naxmaü̃wa. Rü yexguma nagu yadaucuchigu ga naxmaü̃, rü nüxü̃ nadau ga düxruü̃gü ga wüxicüwagu na nanuxü̃. Rü poraãcü naḇaixãchiãẽ namaã ga yema ngupetüxü̃, rü ḇaixãchiãẽãcüma napatacèx nataegu. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Rü yema ngunexü̃gutama rü taxre ga yema Ngechuchuarü ngúexü̃gü rü wüxi ga ĩãne ga Emaṹwa naxĩ. Rü norü yaxü̃ ga guma ĩãne rü 11 ga kilómetru nixĩ nüxna ga Yerucharéü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Rü yexguma namagu naxĩyane, rü nachigagu nidexatanü ga guxü̃ma ga yema ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Rü yexguma yemachigagu iyadexatanüyane, rü nümatama ga Ngechuchu rü ngürüãchi naxcèx yéma nixũ, rü natanügu nixũchigü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Natürü yema ngúexü̃gü rü woo Ngechuchuxü̃ nadaugü, rü tama nüxü̃ nacuèxgüéga na Ngechuchu yiĩxü̃, yerü Tupana rü nanatoõẽgü na tama Ngechuchuxü̃ nacuèxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Rü yexguma ga Ngechuchu, rü yema taxre ga ngúexü̃güna naca, rü ñanagürü: —¿Ṯacüchiga nixĩ i pidexatanüxü̃ na nuxã namagu na pexĩxü̃? ¿Rü ṯacücèx nixĩ i pengechaü̃ẽxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Rü wüxi ga yema ngúexü̃ ga Creopágu ãe̱gaxü̃ nanangãxü̃, rü ñanagürü: —Guxü̃ma i duü̃xü̃gü nixĩ i nüxü̃ cuáxü̃ ga yema yexwaca ngupetüxü̃ ga Yerucharéü̃wa. Rü cuma na yexma cunaxũãnechiréxü̃ rü maneca cuxicatama nixĩ i tama nüxü̃ cucuáxü̃ ga yema ngupetüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Rü yexguma ga nüma ga Ngechuchu rü ñanagürü: —¿Ṯacü nangupetü ga Yerucharéü̃wa? —ñanagürü. Rü nanangãxü̃gü ga yema ngúexü̃gü, rü ñanagürügü: —Poraãcü chixexü̃ nüxü̃ naxüpetü ga Ngechuchu ga Nacharétucü̱̃ã̱x. Nüma ga Ngechuchu rü Tupanaãrü orearü uruü̃ ga mecü nixĩ. Rü Tupanapẽ́xewa rü duü̃xü̃güpẽ́xewa namecüma rü nanaxü ga taxü̃ ga cuèxruü̃gü ga Tupanaãrü poramaã naxüxü̃, rü meã duü̃xü̃güxü̃ nangúexẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","—Natürü ga paigüarü ãẽ̱xgacügü rü tórü ãẽ̱xgacügü rü nayayauxgü. Rü Dumacü̱̃ã̱x ga ãẽ̱xgacügüna nanamugü na curuchawa yapotagüãcüma nayuxẽẽgüãxü̃cèx. Rü yemaãcü nayamèxgü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","—Toma nüxü̃ tacuèxgu rü nüma tá nixĩ i tomaã naporaxü̃ na ínanguxuchixü̃cèx i tachiü̃ãne nüxna i Dumacü̱̃ã̱xãrü ãẽ̱xgacü. Rü ñu̱xma rü marü tomaẽ̱xpü̱x i ngunexü̃ nawena nixĩ ga na yamèxgüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","—Natürü tama ngẽxĩcatama nixĩ, yerü ñuxre ga ngexü̃gü ga totanüxü̃ rü toxü̃ ínayaḇaixgügü. Yerü yema ngexü̃gü rü pèxmamaxü̃chi ínayadaugü ga naxmaü̃wa, rü tama nüxü̃ inayangaugü ga naxü̃ne ga guma Ngechuchu. Rü yemacèx ga yema ngexü̃gü rü toxcèx nawoegu, rü tomaã nüxü̃ nayarüxugüe ga nüxü̃ na nadaugüxü̃ ga Tupanaãrü orearü ngeruü̃gü ga daxũcü̱̃ã̱x. Rü yema daxũcü̱̃ã̱xgü rü namaã nüxü̃ nixugügü ga Ngechuchu rü na namaxü̃xü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Rü yexguma yema ngexü̃güarü orexü̃ taxĩnüẽgu, rü ñuxre ga tomücügü rü naxmaü̃wa ínayadaugü. Rü yema ngexü̃gü nüxü̃ ixugüxü̃rüü̃ nüxü̃ inayangaugü ga naxmaü̃. Natürü tama Ngechuchuxü̃ nadaugü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ tama peãẽta ipexü i pemax? ¿Rü ñuxgura tá ta ipeyaxõgüxü̃ i nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃güarü ore? ");
INSERT INTO tcaNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Rü tama ẽ́xna nüxü̃ pecuèx ga yema ngúxü̃ tá na yangexü̃ ga Cristu naxü̃pa na daxũguxü̃ i naãnewa naxũxü̃, na nge̱ma ãẽ̱xgacü yiĩxü̃cèx? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Rü yexguma inanaxügü ga namaã na nango̱xẽẽãxü̃ ga guxü̃ma ga Tupanaãrü ore ga nachiga ümatüxü̃. Rü yema Tupanaãrü ore ga Moĩché ümatüxü̃maã inanaxügü. Rü ñu̱xũchi namaã nüxü̃ nixu ga guxü̃ma ga yema Tupanaãrü ore ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü ümatügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Rü yexguma yema ĩãne ga Emaṹwa nangugügu, rü Ngechuchu rü nümaxü̃ toxnamana nügü naxũxẽẽneta. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Natürü ga yema ngúexü̃gü rü nüxü̃ nacèèxü̃gü na yexma naxã́ũxü̃cèx, rü ñanagürügü: —¡Nuxma toxü̃tagu nape, erü marü nayáuane, rü paxa tá nachüta! —ñanagürügü. Rü yexguma ga Ngechuchu rü nawe yexma narüxã̱ũ̱x. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Rü yexguma chibücèx wüxiwa mechawa natogügu, rü Ngechuchu nanayaxu ga pãũ. Rü Tupanana moxẽ naxcèx naxã. Rü ñu̱xũchi inanabücu, rü wüxichigüna nanaxã. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Rü yexgumatama naãẽxü̃ nicuèxãchitanü. Rü nüxü̃ nacuèxgü na guma yiĩxü̃ ga Ngechuchu. Natürü yexgumatama ngürüãchi inayarütaxu ga nümax. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Rü yema taxre ga ngúexü̃gü rü nügümaã ñanagürügü: —¿Tama ẽ́xna ga itaãẽgüxü̃ ga tórü maxü̃newa ga yexguma namawa tamaã yadeaxgu rü tamaã nango̱xẽẽãgu ga Tupanaãrü ore i ümatüxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Rü yexgumatama ga yema taxre ga ngúexü̃gü rü inaxĩãchi ga Yerucharéü̃cèx na nawoeguxü̃. Rü yexma nüxü̃ nayangau ga na ínangutaquẽ́xegüxü̃ ga yema 11 ga Ngechuchuarü ngúexü̃gü rü togü ga natanüxü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Rü yema duü̃xü̃gü ga íngutaquẽ́xegüxü̃ rü ñanagürügü nüxü̃: —Aixcüma nixĩ i marü wena namaxü̃xü̃ ya Cori ya Ngechuchu. Rü Chimáũ ga Pedru rü marü nüxü̃ nadau —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Rü yexguma ga yema taxre ga ngúexü̃gü rü ta nüxü̃ nixugügü ga yema nüxü̃ ngupetüxü̃ ga namawa, rü ñuxãcü nüxü̃ na yacuèxãchitanüxü̃ ga guma na yiĩxü̃ ga Ngechuchu ga yexguma pãũ inabücu̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Rü yexguma yemaãcü íyadexagüyane, rü ngürüãchi norü ngãxü̃tanügu nachi ga Ngechuchu. Rü nüxü̃ narümoxẽ, rü ñanagürü: —Nuxmaẽ Pa Chorü Duü̃xü̃güx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Natürü nümagü rü naḇaixãchiãẽgü, rü poraãcü namuü̃ẽ, yerü nagu naxĩnüẽgu rü wüxi ga naxchi̱xixü̃mare nadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —¿Tü̱xcüü̃ peḇaixãchiãẽgü rü tama peyaxõgü na choma chiĩxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","—¡Dücèx, nüxü̃ pedèu̱x ya cho̱xmẽ́xgü rü chaucutügü! Rü chomatama chixĩ. ¡Rü choxü̃ pingõgü rü meã choxü̃ perüdaunü! Erü wüxi i naxchi̱xi rü tama choxü̃ pedauxü̃rüü̃ naxãmachi rü naxãxchinèxã —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Rü yema ñaxguwena, rü nüxü̃ nanawẽ́x ga naxmẽ́x rü nacutü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Natürü ga yema duü̃xü̃gü rü yexguma rü ta tama nüxü̃́ nayaxõgü, yerü naḇaixãchiãẽgü rü nataãẽgü. Rü yemacèx ga Ngechuchu rü nüxna naca rü ñanagürü nüxü̃: —¿Pexü̃́ nangẽxmaxü̃ i õna i nuã? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Rü yexguma nüxna nanaxãgü ga wüxi ga choxni ga iguxü̃chipẽ́xe rü wüxiweü̃ ga berure. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Rü nüma ga Ngechuchu rü nanayaxu. Rü yema duü̃xü̃güpẽ́xewa nanangõ̱x. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Rü ñu̱xũchi ñanagürü nüxü̃: —Rü yema choxü̃ ngupetüxü̃ rü yema nixĩ ga pemaã nüxü̃ chixuxü̃ ga yexguma tauta chayu̱xgu rü petanüwa chayexmagu. Yerü yexguma rü pemaã nüxü̃ chixu rü ñacharügü: “Rü tá ningu i guxü̃ma i Tupanaãrü ore i chauchiga ümatüxü̃ i Wiyaegüarü poperawa, rü Moĩché ümatüxü̃ i mugüwa, rü ore i nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü ümatüxü̃wa”, ñacharügüchirẽ́x pexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Rü yemaãcü namaã nanango̱xẽẽ ga Tupanaãrü ore ga ümatüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Rü ñanagürü nüxü̃: —Tupanaãrü ore i ümatüxü̃wa rü nüxü̃ nixu rü choma i Cristu rü tá chayu, rü tomaẽ̱xpü̱x i ngunexü̃gu rü tá wena chamaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","—Rü yematama ore i ümatüxü̃wa nüxü̃ nixu rü tá chauégagu tá nixĩ i nüxü̃ yaxugüxü̃ i ore i mexü̃. Rü Yerucharéü̃wa tá inaxügü i ngẽma ñu̱xmatáta guxü̃ i naãnewa nangu na ngẽmaãcü duü̃xü̃gü nüxü̃ rüxoexü̃cèx i nacüma i chixexü̃ na Tupana nüxü̃́ nüxü̃ ngechaü̃xü̃cèx i norü pecadugü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","—Rü ñu̱xma rü pematama nixĩ i chorü orearü uruü̃gü, rü tá duü̃xü̃gümaã nüxü̃ pixu ga yema chauxü̃tawa nüxü̃ pedaugüxü̃ rü nüxü̃ pexĩnüẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","—Rü dücax, choma rü pexcèx tá núma chanamu i Naãẽ i Üünexü̃ ga pexcèx nüxü̃ naxunetaxü̃ ya Chaunatü. Natürü chanaxwèxe i númatátama daa ĩãne ya Yerucharéü̃wa pengẽxmagü, ñu̱xmatáta penayauxgü i ngẽma Tupanaãẽ i Üünexü̃ i daxũwa ne ũxü̃ i tá pexü̃ poraexẽẽxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Rü yexguma ga Ngechuchu rü Yerucharéü̃ãrü toxnamana norü ngúexü̃güxü̃ nagagü, ñu̱xmata Betániããrü ngaicamana nangugü. Rü yéma norü ngúexü̃güétü nawémẽ́x, rü Tupanana naxcèx naca na nüxü̃ nangü̃xẽẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Rü yexguma yema ngúexü̃gücèx nayumüxẽguwena rü nüxna nixũgachi. Rü Tupana daxũguxü̃ ga naãnewa nanaga. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Rü nümagü ga norü ngúexü̃gü rü Ngechuchuxü̃ nicuèxüü̃gü. Rü ñu̱xũchi taãẽãcüma Yerucharéü̃cèx nawoegu. ");
INSERT INTO tcaNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Rü guxü̃guma tupauca ga taxü̃newa naxĩĩxü̃, rü yéma Tupanaxü̃ nicuèxüü̃gü. Rü ngẽmaãcü yiĩ.");
INSERT INTO tcaNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Naxü̃pa ga guxü̃ma, rü marü nayexma ga Tupana Nane. Rü Tupanamaã nayexma rü woetama Tupana nixĩ ga nümax. Nüma rü Tupanaãrü Ore nixĩ i nae̱ga erü tamaã nüxü̃ nixu i Tupanachiga. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Rü naxü̃pa ga guxü̃ma rü nüma ga Tupana Nane rü naxü̃tawatama nayexma. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Rü guma Nanexü̃ nixĩ ga namuxü̃ ga Tupana na naxüãxü̃cèx ga guxü̃ma. Rü nataxuma i ṯacü i ñu̱xma ngẽxmaxü̃ i tama nüma naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Rü Nanewa nixĩ i nangexmaxü̃ i maxü̃. Rü ngema maxü̃ rü guxü̃ i duü̃xü̃güarü ngóonexẽẽruü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Rü yima Nane rü woo chixexü̃ íporaxü̃wa rü duü̃xü̃güxü̃ nüxü̃ nacuèxẽẽ i Tupanachiga. Rü ngẽma chixexü̃ rü taxucü-rüwama ngẽma mexü̃xü̃ narüyexera. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Rü nayexma ga wüxi ga yatü ga Cuáü̃ ga baiü̃xẽẽruü̃gu ãe̱gacü. Rü guma nixĩ ga Tupana núma namucü na nüxü̃ yaxuxü̃cèx ga nachiga ga guma ngóonexẽẽruü̃ na yemaãcü guxãma nüxü̃́ yaxõgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Rü nüma ga Cuáü̃ rü tama Tupana Nane ya duü̃xü̃güarü ngóonexẽẽruü̃ nixĩ. Natürü nüma nixĩ ga Tupana núma namuxü̃ na nüxü̃ yaxuxü̃cèx ga nachiga ga guma ngóonexẽẽruü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Rü ñoma ga naãnewa nangu ya yima aixcüma Tupana Nane ixĩcü i guxü̃ma i duü̃xü̃güxü̃ ngóonetanüxẽẽcü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Rü nüma ga guma Nane ga Tupanaãrü Ore ixĩcü rü ñoma ga naãnewa nayexma. Rü woo nagagu nixĩ ga naxüãxü̃ ga guxü̃ma ga ñoma ga naãne, natürü ñoma ga naãne-cü̱̃ã̱x ga duü̃xü̃gü rü tama nüxü̃ nacuèxgü na texe yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nuã norü naãnewatama nangu, natürü norü duü̃xü̃gü ga Yudíugü rü tama nanayauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Natürü guxema nayauxgüxe rü nüxü̃́ yaxõgüxe rü tüxü̃́ nanatauxchaxẽẽ na Tupanaxãcügü tixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Rü ñu̱xma rü Tupanaxãcügü tixĩgü ga guxema yaxõgüxe. Natürü tama noxri tabuexü̃gagu nixĩ i ngẽma rü tama tümanatügüarü ngúchaü̃gagu nixĩ. Natürü i ñu̱xma rü Tupanaxãcügü tixĩgü ga guxema yaxõgüxe yerü nümatama ga Tupana rü naxãcügüxü̃ tüxü̃ nixĩgüxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Rü nüma ya yima Nane ya Tupanaãrü ore ixĩcü rü duü̃xü̃ãcü nango̱x. Rü totanüwa nayexma rü poraãcü toxü̃ nangechaü̃ rü aixcüma nixĩ ga norü ore. Rü toma nüxü̃ tadaugü ga ñuxãcü na naxüünexü̃. Rü Nanatüxü̃tawa nanayaxu ga yema üüne yerü nügümaã nüxü̃́ nawüxicèx ga nüma. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Rü gumachigaxü̃ nixĩ ga yaxuxü̃ ga Cuáü̃ ga yexguma ñaxgu: —Daa nixĩ ga guma pemaã nüxü̃ chixuchigacü ga yexguma ñachaxgu: “Rü yima choweama ne ũcü rü choxü̃ rüyexeracü nixĩ, yerü woetama marü nayexma ga tauta chabuxgu ga chomax”, ñanagürü ga Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Rü yima Tupana Nane rü namecümaxü̃chi rü naxmẽ́xwa nangẽxma i guxü̃ma. Rü naxü̃tawa nixĩ i nayauxgüxü̃ i guxü̃ma i ngü̃xẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Rü Moĩchéxü̃ nixĩ ga namuxü̃ ga Tupana na tüxü̃ nangúexẽẽxü̃cèx ga yema norü mugü. Natürü Ngechuchu ya Cristuxü̃ nixĩ ga namuxü̃ na tüxü̃ nangúexẽẽxü̃cèx na yigü ingechaü̃güxü̃ rü nagu imaxẽxü̃cèx i ore i aixcüma ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Taguma texé ñuxgu nüxü̃ tadau ga Tupana. Natürü Nane ya nügümaã nüxü̃́ wüxicacü nixĩ ya tüxü̃ nüxü̃ cuèxẽẽcü. Rü yima Nane rü Tupanaxü̃chi nixĩ, rü Nanatümaã wüxiwa nangẽxmagü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Rü yema Yudíugüarü ãẽ̱xgacügü ga Yerucharéü̃cü̱̃ã̱x rü Cuáü̃ ga baiü̃xẽẽruü̃xü̃tawa nanamugü ga paigü rü Lebítanüxü̃gü na nüxna yacagüexü̃cèx na texe yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Rü nüma ga Cuáü̃ rü meãma nügü nixu, rü ñanagürü: —Tama nixĩ i Cristu chiĩxü̃ i chomax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Rü wenaxãrü nüxna nacagü rü ñanagürügü: —¿Texé ẽ́xna quixĩ? ¿Ẽ́xna cuma ga nuxcümaü̃cü ga Tupanaãrü orearü uruü̃ ga Ería quiĩxü̃? —ñanagürügü. Rü Cuáü̃ nanangãxü̃ rü ñanagürü: —Tama Ería chixĩ —ñanagürü. Rü nümagü rü wenaxãrü nüxna nacagüe rü ñanagürügü: —¿Ẽ́xna cuma quiĩxü̃ ya yima orearü uruü̃ ga Moĩché nüxü̃ ixucü ga ínguxchaü̃cü? —ñanagürügü. Rü Cuáü̃ nanangãxü̃ rü ñanagürü: —Tama yima chixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Rü yexguma ñanagürügüama: —¿Ẽ́xna texé quiĩxü̃? Erü tanaxwèxe i ngẽma núma toxü̃ mugüxü̃xü̃tawa tanange i curü ngãxü̃ga. ¿Rü ñuxũ ñacuxü̃ i ñu̱xma na texé quiĩxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Rü Cuáü̃ nanangãxü̃ rü ñanagürü nüxü̃: —Choma nixĩ i ngẽma duü̃xü̃ i dauxchitawa i ngextá taxúema íxãpataxü̃wa tagaãcü ñachaxü̃: “¡Rü nüxü̃ perüxoe i pecüma i chixexü̃ rü ipeyanawẽ́xãchixẽẽ̱x i perü maxü̃ naxcèx ya Cori ya Tupana!” ñachaxü̃, guma nuxcümaü̃cü ga orearü uruü̃ ga Ichaxía nüxü̃ ixuxü̃rüü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Rü yexguma ga yema paigü rü Parichéugü yéma mugüxü̃ ga Cuáü̃maã na yanadexagüxü̃cèx rü wenaxãrü nüxna nacagüe, rü ñanagürügü: —Rü ngẽxguma tama Cristu quixĩgu, rü tama Ería quixĩgu, rü tama yima orearü uruü̃ ya ínguxchaü̃cü quixĩgu, ¿rü tü̱xcüü̃ i duü̃xü̃güxü̃ ícubaiü̃xẽẽxü̃ i ñu̱xmax? —ñanagürügü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Rü Cuáü̃ nanangãxü̃ rü ñanagürü: —Choma rü dexáwamare íchanabaiü̃xẽẽ i duü̃xü̃gü. Natürü petanüwa nangẽxma ya yima tama nüxü̃ pecuácü ya choweama ne ũcü. Rü choma rü napẽ́xewa rü taxuwama chame, rü bai i norü chapatucunügüarü wẽgüwa chame —ñanagürü ga Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Rü yema nachica ga Betániãgu ãe̱gaxü̃wa nixĩ ga Cuáü̃ ga nüxü̃ yaxuxü̃ ga yema ore. Rü natü ga Yudáü̃ãrü tocutüwa nixĩ ga yema nachica ga ngextá Cuáü̃ duü̃xü̃güxü̃ íbaiü̃xẽẽxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Rü moxü̃ãcü ga Cuáü̃ rü Ngechuchuxü̃ nadau ga naxcèx na yaxũxü̃. Rü ñanagürü ga Cuáü̃: —¡Rü dücax! Daa nixĩ ya yima Tupana núma namucü na nayuxü̃cèx na ñoma i naãnecü̱̃ã̱x i duü̃xü̃güarü pecaduxü̃ iyanaxoxẽẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","—Rü choma rü daa Ngechuchuchigaxü̃ nixĩ ga chixuxü̃ ga yexguma ñachagu: “Rü choweama ne naxũ ya wüxi ya chorü yexeracü, yerü nüma rü woetama nayexma ga tauta chabuxgu ga chomax”, ñachagu. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","—Rü chomatama ga noxri rü tama nüxü̃ chacuèx ga texe na yiĩxü̃ ga nümax. Natürü núma chaxũ na dexáwamare duü̃xü̃güxü̃ íchibaiü̃xẽẽtanüxü̃cèx na tatanüxü̃ i Yudíugü nüxü̃ cuèxgüxü̃cèx na texé yiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Rü ñanagürü ta ga Cuáü̃: —Rü chomatama nüxü̃ chadau ga Tupanaãẽ ga Üünexü̃ ga yexguma wüxi ga muxtucurüü̃ daxũwa ínaxexeegu rü Ngechuchuxü̃negu yanawèxgux. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","—Choma rü noxri tama nüxü̃ chacuèx ga texe na yiĩxü̃ ga nümax. Natürü ga Tupana ga choxü̃ mucü na dexáwamare duü̃xü̃güxü̃ íchabaiü̃xẽẽxü̃cèx, rü ñanagürü choxü̃: “Rü yima nüxü̃ cudaucü ya chauãẽ i Üünexü̃ nae̱tügu írüxexeecü, rü yima tá nixĩ ya chauãẽ i Üünexü̃ duü̃xü̃güna nguxẽẽcü”, ñanagürü choxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","—Choma rü marü yima Ngechuchuxü̃ chadau rü pemaã nüxü̃ chixu na nüma rü aixcüma Tupana Nane yiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Moxü̃ãcü rü wenaxãrü Cuáü̃maã yema nachicawa tayexmagü ga toma ga taxre ga norü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Rü yexguma Ngechuchuxü̃ nadèu̱xgu ga yéma na naxüpetüxü̃, rü Cuáü̃ rü ñanagürü toxü̃: —¡Dücèx! Yima nixĩ ya Tupana núma namucü na pecaducèx nayuxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Rü toma ga Cuáü̃ãrü ngúexü̃gü rü nüxü̃ taxĩnüẽ ga yexguma yema ñaxgu. Rü Ngechuchuwe tarüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Rü nügü ínidau ga Ngechuchu, rü toxü̃ nadau ga nawe na tarüxĩxü̃. Rü toxna naca rü ñanagürü toxü̃: —¿Ṯacücèx pedau? —ñanagürü. Rü tomagü rü ñatarügügü: —Pa Ngúexẽẽruü̃x, ¿ngexta nixĩ i cupexü̃? —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Rü Ngechuchu toxü̃ nangãxü̃, rü ñanagürü toxü̃: —¡Nuã chowe perüxĩ rü ípeyadèu̱x! —ñanagürü. Rü nawe tarüxĩ, rü nüxü̃ tadaugü ga na ngexta napexü̃. Rü yexguma yéma tangugügu, rü marü ãgümücüarü orawa nangu ga na nayáuanexü̃. Rü yexma naxü̃tagu tarücho rü ñu̱xmata nachüta. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Rü choma chixĩ ga noxri Cuáü̃ ga baiü̃xẽẽruü̃xü̃ chaxĩnüxü̃ ga yixcama Ngechuchuwe charüxũxü̃. Rü chomücü rü Aü̃dré nixĩ. Rü nüma rü Pedru ga Chimáũẽneẽ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Rü yexgumatama ga Aü̃dré, rü naẽneẽ ga Chimáũcèx nayadau. Rü ñanagürü nüxü̃: —Rü marü nüxü̃ itayangau ya yima Cristu ga nuxcüma Tupana nüxü̃ unetacü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Rü yemawena, rü Ngechuchu íyexmaxü̃wa Chimáũxü̃ naga ga Aü̃dré. Rü yexguma Ngechuchu Chimáũxü̃ dèu̱xgu, rü ñanagürü nüxü̃: —Cuma nixĩ i Chimáũ i Cuáü̃ nane quiĩxü̃. Natürü i ñu̱xmawena rü Nuta tá nixĩ i cuéga —ñanagürü. Rü ngẽma nae̱ga rü Pedru ñaxü̃chiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Rü moxü̃ãcü ga Ngechuchu rü nügü namexẽẽ na Gariréaanewa naxũxü̃cèx. Rü Piripixü̃ inayangau rü ñanagürü nüxü̃: —¡Chowe rüxũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Rü nüma ga Piripi rü ĩãne ga Bechaídacü̱̃ã̱x nixĩ. Rü yémacü̱̃ã̱x ta nixĩ ga Aü̃dré rü Pedru. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Rü Piripi rü Natanae̱cèx nayadau, rü ñanagürü nüxü̃: —Marü nüxü̃ itayangau ya yima Cristu ga Moĩché nachiga naxümatücü ga mugüarü poperawa, rü nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü ta nachiga naxümatügücü. Yima nixĩ ya Yúche nane ya Ngechuchu ya Nacharétucü̱̃ã̱x —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Rü ñanagürü ga Natanae̱: —¿Ñuxãcü i ṯacü rü mexü̃ i Nacharétuwa ne naxũxü̃? —ñanagürü. Rü Piripi nanangãxü̃, rü ñanagürü nüxü̃: —¡Dücèx, ngĩxã rü ítayadau! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Rü yexguma Ngechuchu Natanae̱xü̃ dèu̱xgu ga naxcèx na yaxũxü̃, rü ñanagürü: —¡Dücèx! Yéa ne naxũ i wüxi i yatü i aixcüma Yudíu ixĩxü̃ i aixcüma ngearü chixexü̃ã́xü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Rü yexguma ga Natanae̱ rü Ngechuchuna naca, rü ñanagürü nüxü̃: —¿Ñuxãcü i choxü̃ cucuáxü̃? —ñanagürü. Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Naxü̃pa ga Piripi cuxcèx na yac̱axü̃, rü choma rü cuxü̃ chadau ga yexguma ori̱x ga igueratüü̃gu curüxã̱ũ̱xgux —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Rü Natanae̱ nanangãxü̃ rü ñanagürü nüxü̃: —Pa Ngúexẽẽruü̃x, cuma rü Tupana Nane quixĩ. Rü cuma nixĩ i guxü̃ma i Yudíugüarü Ãẽ̱xgacü quiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Cuma rü choxü̃́ cuyaxõ erü cumaã nüxü̃ chixu na igueratüü̃wa cuxü̃ na chadauxü̃. Rü ngẽmacèxicatama nixĩ i cuyaxõxü̃. Natürü ngẽma ñu̱xma nüxü̃ cudauxü̃ãrü yexera tá nixĩ i nüxü̃ cudauxü̃ i yixcüra —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Rü ñanagürü ta ga Ngechuchu: —Rü aixcüma pemaã nüxü̃ chixu rü tá nüxü̃ pedaugü na yawãxnaxü̃ i daxũguxü̃ i naãne. Rü tá nüxü̃ pedaugü i Tupanaãrü orearü ngeruü̃gü i daxũcü̱̃ã̱x i nge̱ma daxũ ĩgüxü̃ rü írüxĩgüüxü̃ i nae̱tüwa ya Tupana Nane ya duü̃xü̃xü̃ ixĩcü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rü yexguma marü tomaẽ̱xpü̱x ga ngunexü̃ Gariréaanearü ĩane ga Canáwa nayexmagu ga Ngechuchu, rü nayexma ga wüxi ga ngĩarü peta. Rü yemawa ngixna naxugü ga naẽ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Rü Ngechuchuna rü toxna rü ta naxugüe na yéma taxĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Rü nagu̱x ga norü axexü̃ ga binu. Rü Ngechuchu naẽ ngĩgürügü nüxü̃ ga Ngechuchu: —Marü nagúarü binuã̱xgü —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Natürü Ngechuchu ngĩxü̃ nangãxü̃, rü ñanagürü: —Pa Mamax, ¿tü̱xcüü̃ chomaã nüxü̃ quixu i ngẽma? Erü tauta nawa nangu na chanaxüxü̃cèx i ṯacü rü mexü̃ i Tupanaãrü poramaã üxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Natürü ga ngĩma ga naẽ rü ngĩgürügü nüxü̃ ga yema baegüxü̃ namaã ga binuchiü: —¡Penaxü̱x i guxü̃ma i ngẽma nüma pemaã nüxü̃ yaxuxü̃! —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Rü yéma iyexma ga 6 ga tü̃xü̃ ga nutagüngĩxcèx. Rü wüxichigü ga yema tü̃xü̃wa rü maneca yexma name ga 50 rü ẽ́xna 70 litrugü ga dexá. Rü yema tü̃xü̃gü iyixĩ ga yema Yudíugü ngĩxü̃ ixügüãcugücü ga yexguma dexámaã nügü yayauxmẽ́xgüchaü̃gu na Tupanacèx nügü yamexẽẽgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Rü Ngechuchu rü yema baegüxü̃xü̃ namu, rü ñanagürü: —¡Dexámaã ngĩxü̃ pixügüãcu i ñaã tü̃xü̃gü! —ñanagürü. Rü nümagü ga yema baegüxü̃ rü meãma ngĩxü̃ nixügüãcu. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Rü Ngechuchu ñanagürü nüxü̃: —Rü ñu̱xma chanaxwèxe i íraxü̃ peyaxu, rü petaarü yoraxü̃tawa penange —ñanagürü. Rü yemaãcü nanaxügü ga yema baegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Rü yema petaarü yora nüxü̃ naxaxneta ga yema dexá ga binuxü̃ nacèxichixü̃. Natürü tama nüxü̃ nacuèx ga ngextá na nayauxgüãxü̃. Rü yema baegüxü̃xĩcatama nixĩ ga nüxü̃ cuèxgüxü̃ ga dexámare na yiĩxü̃ ga noxrix. Rü yexgumatama ga yema petaarü yora rü yema yatü ga ingĩxü̃cèx naca. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Rü ñanagürü nüxü̃: —Guxü̃ i naãnewa rü duü̃xü̃gü rü noxri rü namaã nabae ya mecü ya binu. Rü ngẽxguma marü meãma guxü̃ma axegügu i ngẽma nüxna naxuxü̃, rü ngẽmawena rü nüxna nanaxã ya ngexcürüücümare ya binu. Natürü i cuma rü marü nagúxchaü̃gu i peta, rü mexẽchicü ya binumaãtama cuyaxaxegüxẽẽ i duü̃xü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Rü guma Gariréaanewa yexmane ga ĩãne ga Canáwa nixĩ ga yema naxüxü̃ ga Ngechuchu. Rü yema nixĩ ga nüxĩraü̃xü̃ ga cuèxruü̃ ga Tupanaãrü poramaã üxü̃ ga nawa nügü inawéxü̃ ga Tupana Nane na yiĩxü̃. Rü toma ga norü ngúexü̃gü rü nüxü̃́ tayaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Rü yemawena rü Capernáũ ga ĩãnewa naxũ ga Ngechuchu. Rü naẽ rü naẽneẽgü rü toma ga norü ngúexü̃gü rü ta ítayaxümücügü. Rü yéma guma ĩãnewa tayexmagü ga ñuxre ga ngunexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Rü toma ga Yudíugü rü marü ningaica ga torü peta ga Üpetüchiga. Rü yemacèx ga Ngechuchu rü Yerucharéü̃wa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Rü yexma tupauca ga taxü̃negu nüxü̃ nayangau ga duü̃xü̃gü ga yéma norü wocagümaã rü carnerugümaã rü muxtucugümaã taxegüxü̃. Rü yéma nüxü̃ nadau ta ga duü̃xü̃gü ga norü taxechicawa rütogüxü̃ rü Tupanaarü ãmarewa mexü̃ ga dĩẽrumaã yéma taxegüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Rü yexguma yemaxü̃ nadèu̱xgu ga Ngechuchu, rü nanaxü ga wüxi ga c̱uaixruü̃ ga naxchèxmünaxcèx. Rü yemamaã tupauca ga taxü̃newa ínanawoxü̃ ga yema duü̃xü̃gü guxü̃ma ga norü carnerugümaã rü wocagümaã. Rü yema dĩẽrucèx taxegüxü̃ãrü dĩẽru rü ngĩxü̃ narüwoü̃ ñaxtüanegu. Rü norü mechagü rü ta nüxü̃ nawoneta. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Rü yema muxtucugümaã taxegüxü̃xü̃ ñanagürü: —¡Ípeyana i ngẽma perü muxtucugü i nuã! Tama name i taxepataü̃xü̃ peyaxĩxẽẽ ya daa Chaunatüpata —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Rü yexguma ga toma ga norü ngúexü̃gü rü nüxna tacuèxãchie ga nuxcümaü̃xü̃ ga ümatüxü̃ ga ñaxü̃: “Duü̃xü̃gü rü tá chauxchi naxaie erü chanachu̱xu i ṯacü i chixexü̃ na naxügüxü̃ i Tupanapatawa”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Rü yexguma ga yema ãẽ̱xgacügü rü Ngechuchuna nacagü, rü ñanagürügü: —¿Ṯacü rü cuèxruü̃xü̃ toxü̃ cudauxẽẽ na nawa nüxü̃ tacuáxü̃cèx na aixcüma Tupana yiĩxü̃ ya cuxü̃ mucü na ícunawoxü̃xü̃cèx i ñaã duü̃xü̃gü i nuã? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —¡Nagu pepogüe ya daa tupauca ya taxü̃ne! Rü choma rü tomaẽ̱xpü̱x i ngunexü̃gu rü tá wena íchanadaxẽẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Rü yexguma ga yema ãẽ̱xgacügü rü nanangãxü̃gü, rü ñanagürügü: —Rü 46 ga taunecü nawa napuracüe ga duü̃xü̃gü na naxügüãxü̃cèx ga daa tupauca ya taxü̃ne. ¿Rü ñuxãcü tá i cuma i tomaẽ̱xpü̱x i ngunexü̃ tátama wena ícunadaxẽẽxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Natürü guma Tupanapata ga Ngechuchu nachiga idexane rü naxü̃nechigatama nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Rü yemacèx ga toma ga norü ngúexü̃gü, rü yexguma Ngechuchu yuwa írüdaxgu, rü nüxna tacuèxãchie ga yema ore ga Ngechuchu nüxü̃ ixuxü̃. Rü aixcüma tayaxõgü ga yema ore ga nüxü̃ yaxuxü̃ rü yema Tupanaãrü ore ga nuxcümaü̃güxü̃ ga orearü uruü̃gü Ngechuchuchigagu ümatügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Rü yexguma Ngechuchu Üpetüchigaarü petacèx Yerucharéü̃wa yexmagu, rü muxü̃ma ga duü̃xü̃gü rü nüxü̃́ nayaxõgü, yerü nüxü̃ nadaugü ga yema taxü̃ ga mexü̃gü ga Tupanaãrü poramaã naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Natürü ga nüma ga Ngechuchu rü tama yema duü̃xü̃gümẽ́xẽwa nügü nayexmaxẽẽchaü̃, yerü woetama marü nüxü̃ nacuèx ga ṯacügu na naxĩnüẽxü̃ ga guxü̃ma ga yema duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Rü yemacèx ga nüma rü taxucèxma texé namaã nüxü̃ tixu na ṯacügu naxĩnüẽxü̃ ga yema duü̃xü̃gü. Yerü nümatama marü nüxü̃ nacuèx ga ṯacügu na naxĩnüẽxü̃ ga naãẽwa ga wüxichigü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nayexma ga wüxi ga Parichéu ga Nicodémugu ãe̱gacü. Rü nüma rü wüxi ga ãẽ̱xgacü ga nüxü̃ nangechaü̃gücü nixĩ ga Yudíugütanüwa. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Rü guma Nicodému rü Ngechuchuxü̃tagu nanaxũãne ga chütacü. Rü ñanagürü Ngechuchuxü̃: —Pa Ngúexẽẽruü̃x, toma nüxü̃ tacuèx na aixcüma Tupana núma cuxü̃ muxü̃ na toxü̃ cungúexẽẽxü̃cèx. Erü taxucürüwa texé cuxrüü̃ tanaxü i ngẽma taxü̃ i mexü̃gü i Tupanaãrü poramaã üxü̃, ega tama Tupana tümaxü̃tawa ngẽxmagu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Aixcüma cumaã nüxü̃ chixu, rü yíxema tama wenaxãrü buxe rü taxucürüwama Tupana ãẽ̱xgacü íixĩxü̃wa tangu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Rü Nicodému rü Ngechuchuna naca, rü ñanagürü nüxü̃: —¿Natürü ñuxãcü i wüxi i yatü i marü yaxü̃ i wena nabuxü̃? ¿Ẽ́xna wena naẽãnügu naxücuxü̃ rü ngẽmaãcü wena nabuxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Rü aixcüma cumaã nüxü̃ chixu rü yíxema tama nüxü̃ rüxoxe i tümaãrü pecadu rü tama Tupanaãẽ i Üünexü̃wa nayaxúxe i maxü̃ i ngexwacaxü̃xü̃, rü taxucürüwama Tupana ãẽ̱xgacü íixĩxü̃wa tichocu ");
INSERT INTO tcaNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","—Yíxema duü̃xü̃wa buxe rü duü̃xü̃tama tixĩ. Natürü yíxema Naãẽ i Üünexü̃wa nayaxúxe i maxü̃ i ngexwacaxü̃xü̃, rü Tupanaxãcü tixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","—¡Tãũtáma cuḇaixãchiãẽ na cumaã nüxü̃ chixuxü̃ na Tupana naxwèxexü̃ na guxü̃ma i duü̃xü̃gü rü wena nabuexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","—Ya buanecü rü nüma ínanaxwèxexü̃wa nabu. Rü nüxü̃ cuxĩnü i naga, natürü tama nüxü̃ cucuèx na ngextáama ne naxũxü̃ rü ngextáama na naxũxü̃. Rü ngẽxgumarüü̃ ta tixĩgü ya guxãma ya yíxema Naãẽ i Üünexü̃wa nayaxúxe i maxü̃ i ngexwacaxü̃xü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Rü Nicodému wenaxãrü Ngechuchuna naca, rü ñanagürü: —¿Natürü ñuxãcü nixĩ i ngẽma? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Cuma rü Yudíugüarü ngúexẽẽruü̃ i nüxü̃ cuáxü̃ quixĩ. ¿Rü ñuxãcü chi i cuma i tama nüxü̃ cucuáxü̃ i ngẽma? ");
INSERT INTO tcaNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","—Aixcüma cumaã nüxü̃ chixu rü toma rü namaã tidexagü i ngẽma nüxü̃ tacuáxü̃. Rü norü uruü̃ tixĩgü i ngẽma nüxü̃ tadaugüxü̃. Natürü pema rü tama toxü̃́ peyaxõgü i ngẽma pemaã nüxü̃ tixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","—Rü ñu̱xma na tama choxü̃́ peyaxõgüxü̃ i ngẽma pemaã nüxü̃ chixuxü̃ i ñoma i naãneãrü ngẽmaxü̃chiga, rü ¿ñuxãcü tá peyaxõgüxü̃ ega pemaã nüxü̃ chixuxgu i daxũguxü̃ i naãneãrü ngẽmaxü̃chiga? ");
INSERT INTO tcaNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","—Taguma texé daxũguxü̃ i naãnewa taxũ. Natürü i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃, rü chaxicatama nixĩ i nge̱ma ne chaxũxü̃ rü nge̱ma tá chaxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","—Pema nüxü̃ pecuèx ga ñuxãcü nuxcümaxü̃chima yema nachica ga ngextá taxúema íxãpataxü̃wa, rü Moĩché wüxi ga naĩgu nanaxünagü ga yema ãxtape ga dĩẽrumünaxcèx. Rü ngẽxgumarüü̃ tá ta i choma i Tupana Nane i duü̃xü̃xü̃ chiĩxü̃, rü wüxi i naĩgu tá choxü̃ naxünagügü i duü̃xü̃gü na guxãma ya texé ya choxü̃́ yaxõgüxe rü tüxü̃́ nangẽxmaxü̃cèx i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—Rü Tupana rü poraãcü nüxü̃ nangechaü̃ i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü. Rü yemacèx inanamu ga Nane ga nügümaã wüxicacü na guxãma ya texé ya nüxü̃́ yaxõgüxe rü tama itarütauxexü̃cèx rü tüxü̃́ nangẽxmaxü̃cèx i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","—Yerü ga Tupana rü tama ñoma ga naãnewa nanamu ga Nane na duü̃xü̃gümaã naxueguãxü̃cèx na napoxcuexü̃. Natürü núma nanamu na namaxẽxẽẽãxü̃cèx i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","—Rü yíxema Tupana Naneãxü̃́ yaxṍxẽ, rü Tupana rü tama tümamaã nanaxuegu na tapoxcuxü̃. Natürü yíxema tama nüxü̃́ yaxṍxẽ, rü marü tümamaã nanaxuegu na tapoxcuxü̃, erü tama nüxü̃́ tayaxõ ya yima Tupana Nane ya nügümaã wüxicacü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","—Rü yíxema tama nüxü̃́ yaxõgüxe, rü Tupana rü marü tümamaã nanaxuegu na tapoxcuexü̃. Yerü yexguma ñoma ga naãnewa nanguxgu ga Tupana Nane ya duü̃xü̃güarü ngóonexẽẽruü̃, rü tama nawe tarüxĩxchaü̃. Natürü yexera tümaãrü me nixĩ ga ẽãnexü̃waama na tayexmagüxü̃, yerü chixexü̃ taxügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","—Guxãma ya yíxema chixexü̃ ügüxe rü naxchi taxaie i ngóonexü̃. Rü tama nüxna tangaicamagüchaü̃ erü tama tanaxwèxe na nangóxü̃ i ngẽma chixexü̃ i ítaxügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","—Natürü yíxema aixcüma Tupanaãrü ore nüxü̃ ixuxü̃ãcüma meã maxẽxẽ rü nüxna tangaicama i ngẽma ngóonexü̃. Rü ngẽmaãcü tanaxü na meã nangóxü̃cèx na Tupanaãrü ngúchaü̃ãcüma na yiĩxü̃ i guxü̃ma i ngẽma taxügüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Rü yemawena rü tomaã Yudéaanewa naxũ ga Ngechuchu. Rü ñuxre ga ngunexü̃ tomaã yéma nayexma rü yéma duü̃xü̃güxü̃ ítabaiü̃xẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Rü Cuáü̃ ga baiü̃xẽẽruü̃ rü Enóãrü ĩãnewa ga Charíarü ngaicamana rü ínanabaiü̃xẽẽ ta ga duü̃xü̃gü yerü yéma nayexma ga taxü̃ ga dexá. Rü yema yéma íngugüetanüxü̃ ga duü̃xü̃gü, rü Cuáü̃ ínayabaiü̃xẽẽtanü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Rü yemaãcü nangupetü naxü̃pa ga na poxcupataü̃gu yatèxcuchixü̃ ga Cuáü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Rü yexguma rü ñuxre ga norü ngúexü̃gü ga Cuáü̃, rü wüxi ga Yudíumaã niporagatanücüü nachiga ga nacümagü na ñuxãcü namexü̃ na Tupanacèx nügü yamexẽẽgüxü̃ ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Rü Cuáü̃maã nüxü̃ nayarüxugüe, rü ñanagürügü: —Pa Ngúexẽẽruü̃x, dücax guma yatü ga tomaã nüxü̃ quixucü rü cumaã yexmacü ga natü i Yudáü̃ãrü tocutüwa, rü yima rü ñu̱xma rü duü̃xü̃güxü̃ ínabaiü̃xẽẽ, rü guxü̃ma i duü̃xü̃gü rü nawe narüxĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Rü Cuáü̃ nanangãxü̃ rü ñanagürü nüxü̃: —Taxúema ṯacü tüxü̃́ nangẽxma ega Tupana tama tüxna naxãxgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","—Pematama rü marü choxü̃ pexĩnüẽ ga yexguma ñachagu: “Choma rü tama Cristu chixĩ. Natürü choma chixĩ i Tupana yima Cristupẽ́xegu choxü̃ imuxü̃ na nüxü̃ chixuxü̃cèx i nachiga”, ñachagu. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","—Rü wüxi i ngĩgüwa rü yima yatü ya ingĩcü rü naxmèxãrü yora nixĩ. Rü yima yatümücü i naxü̃tawa ngẽxmaxü̃ rü nüxü̃́ inarüxĩnü i norü ore. Rü nataãẽ i ngẽxguma nüxü̃ naxĩnügu i ngẽma na yadexaxü̃. Rü ngẽxgumarüü̃ i choma rü aixcüma Cristumaã chataãẽxü̃chi i ñu̱xmax. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","—Nüma rü tá nixĩnagüchigü na ãẽ̱xgacü yiĩxü̃, natürü i choma rü tá ícharüxĩchigü. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","—Rü yima Cristu ya daxũwa ne ũxcü rü guxãe̱tüwa nangẽxma. Natürü i choma rü ñoma i naãnewa changẽxma, rü ñoma i naãnecü̱̃ã̱x chixĩ, rü ngẽma ñoma i naãnewa ngẽxmaxü̃chigaxü̃ chixu. Natürü i nüma ya Cristu ya daxũwa ne ũxcü, rü guxãe̱tüwa nangẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","—Rü nüma rü tamaã nüxü̃ nixuchiga ga yema nüxü̃ nadauxü̃ rü nüxü̃ naxĩnüxü̃. Natürü noxretama nüxü̃́ nayaxõgü i ngẽma nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","—Natürü ngẽxguma texé nüxü̃́ yaxõxgu i norü ore, rü ngẽmaãcü tanango̱xẽẽ na aixcüma yiĩxü̃ i ngẽma Tupana nüxü̃ ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","—Rü yima Tupana núma namucü, rü Tupanaãrü orexü̃ nixu. Erü Tupana rü nüxna nanamu i Naãẽ i Üünexü̃ na guxü̃guma naxü̃tawa nangẽxmaxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","—Rü Tanatü ya Tupana rü Nanexü̃ nangechaü̃. Rü ngẽmacèx marü naxmẽ́xwa nanangẽxmaxẽẽ i guxü̃ma i ṯacü i ngẽxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","—Rü yíxema Tupana Naneãxü̃́ yaxṍxẽ rü tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. Natürü yíxema tama nüxü̃́ yaxõxchaü̃xẽ ya Tupana Nane, rü tãũtáma tüxü̃́ nangẽxma i ngẽma maxü̃ i taguma gúxü̃. Natürü tá tanayaxu i ngẽma ãũcümaxü̃ i poxcu i Tupana tá namaã tüxü̃ poxcuxü̃ —ñanagürü ga Cuáü̃ ga baiü̃xẽẽruü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Rü Parichéugü rü nüxü̃ nacuáchigagü ga Ngechuchu rü Cuáü̃ãrü yexera nüxü̃́ na nayexmaxü̃ ga norü ngúexü̃gü, rü norü yexera duü̃xü̃güxü̃ na ínabaiü̃xẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Natürü tama Ngechuchu nixĩ ga ínabaiü̃xẽẽcü ga duü̃xü̃gü. Rü toma ga norü ngúexü̃gü tixĩ ga tanaxüxü̃ ga yema. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Rü yexguma Ngechuchu nüxü̃ ĩnügu ga Parichéugü rü nachigagu na yadexagüxü̃, rü yéma Yudéaanewa ítachoxü̃ na Gariréaanecèx tawoeguxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Natürü ga yema nama ga nagu tawoeguxü̃ rü Chamáriaanewa nadapetü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Rü yemacèx ga toma rü nawa tangugü ga wüxi ga Chamáriaaneãrü ĩãne ga Chicaru. Rü guma ĩãneãrü ngaicamana nayexma ga yema naãne ga nuxcümaü̃cü ga Acobuaxü̃́ yexmaxü̃ rü yixcama rü nane ga Yúchena naxãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Rü yéma nayexma ga wüxi ga puchu ga duü̃xü̃gü dexácèx ixaixmaü̃gücü ga Acobuarü Puchugu ãe̱gacü. Rü poraãcü nipa ga Ngechuchu ga namagu na yaxũxü̃. Rü yemacèx guma puchuxü̃tawa nayarütoõchi. Rü tocuchiwa nanguxchaü̃ ga yexguma. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Rü toma ga norü ngúexü̃gü rü guma ĩãnewa taxĩ na torü õnacèx tayataxegüxü̃cèx. Rü towena yéma ingu ga wüxi ga ngecü ga Chamáriaanecü̱̃ã̱x ga guma puchuwa dexáwa ũcü. Rü Ngechuchu rü ñanagürü ngĩxü̃: —¡Íraxü̃ i dexá choxna naxã! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Natürü ga yema nge rü iḇaixãchiãẽ yerü ga Yudíugü rü Chamáriaanecü̱̃ã̱xgümaã nügüchi naxaie rü yemacèx ga yema nge rü inangãxü̃ rü ngĩgürügü nüxü̃: —¿Ñuxãcü i cuma na Yudíu quiĩxü̃ i dexácèx choxna cuc̱axü̃ i choma na Chamáriaanecü̱̃ã̱x chiĩxü̃? —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Rü Ngechuchu ngĩxü̃ nangãxü̃, rü ñanagürü: —Ngẽxguma chi nüxü̃ cucuèxgu i ngẽma mexü̃ i Tupana cuxna ãxchaü̃xü̃, rü chi nüxü̃ cucuèxgu na texé yiĩxü̃ ya yima dexá cuxna tac̱acü, rü cuma rü chi nüxnata cuca i dexá i maxü̃ nawa ngẽxmaxü̃ rü nüma rü chi cuxna nanaxã i ngẽma dexá —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Rü yema ngecü inangãxü̃, rü ngĩgürügü nüxü̃: —Pa Corix, ¿ñuxãcü tá i dexáta cuyaxu? Erü daa puchu rü namátamaxü̃chi rü cuxü̃́ nataxuma na ṯacümaã cunayaxuxü̃cèx i dexá. ¿Rü ngextá tá i cunayaxuxü̃ i ngẽma dexá i maxü̃ nawa ngẽxmaxü̃ na choxna cunaxãxü̃cèx? ");
INSERT INTO tcaNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","—Nuxcümaü̃cü ga tórü o̱xi ga Acobu toxcèx núma Chamáriaanewa nanatèx ga daa puchu. Rü gumawa nixĩ ga naxaxexü̃ ga nüma rü nanegü rü norü wocagü. ¿Rü ñuxãcü chi i cuma i norü yexera quiĩxü̃? —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Rü Ngechuchu ngĩxü̃ nangãxü̃, rü ñanagürü: —Rü guxãma ya texé ya daa puchuarü dexáwa axexe, rü wena táxarü tiṯawae. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","—Natürü texé ya yíxema choma tüxna chaxãxü̃ i dexáwa axexe, rü tagutáma wena tiṯawa. Erü ngẽma dexá i choma tüxna chaxãxü̃ rü wüxi ya puchu ya guxü̃guma ibaibecürüü̃ tá nixĩ i tümawa, erü ngẽma dexáwa nangẽxma i maxü̃ i taguma gúxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Rü ngĩma ga yema nge rü inangãxü̃ rü ngĩgürügü: —Pa Corix, ¡choxna naxã i ngẽma dexá na taguma wena chiṯawaxü̃cèx, rü taguma wena daa puchuwa dexáwa chaxũxü̃cèx! —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Rü Ngechuchu ñanagürü ngĩxü̃: —¡Íyadau ya cute, rü naxcèx yaca, rü nuã pexĩ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Rü yema ngecü rü inangãxü̃, rü ngĩgürügü nüxü̃: —Nataxuma ya chaute —ngĩgürügü. Rü Ngechuchu ñanagürü ngĩxü̃: —Aixcüma nixĩ i ngẽma nüxü̃ quixuxü̃ na nataxuü̃ma ya cute. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","—Yerü wüximẽ́ẽ̱xpü̱xchirẽ́x nixĩ ga cute, rü yima ñu̱xma cuxü̃tawa ngẽxmacü rü tama aixcüma cutexüchi nixĩ. Rü ngẽmacèx aixcüma nixĩ i curü ore i chomaã nüxü̃ quixuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Rü yexguma yemaxü̃ naxĩnügu ga yema ngecü, rü ngĩgürügü: —Pa Corix, nüxü̃ chicuèxãchi rü cuma rü wüxi i Tupanaãrü orearü uruü̃ quixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","—Nuxcümaü̃güxü̃ ga torü o̱xigü ga Chamáriaanecü̱̃ã̱xgü rü daa mèxpǘne ga Garachíü̃wa Tupanaxü̃ nicuèxüü̃gü. Natürü i pema i Yudíugü rü ñaperügügü: “Rü Yerucharéü̃ nixĩ i nachica i mexü̃ i ngextá Tupanaxü̃ ticuèxüü̃gü”, ñaperügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","22","Rü Ngechuchu ngĩxü̃ nangãxü̃ rü ñanagürü: —Pema i Chamáriaanecü̱̃ã̱xgü rü tama aixcüma nüxü̃ pecuèxgü ya yima nüxü̃ picuèxüü̃gücü. Natürü toma i Yudíugü rü aixcüma nüxü̃ tacuèx ya yima nüxü̃ ticuèxüü̃gücü, erü Yudíugügagu nixĩ i Tupana namaxẽxẽẽxü̃ i guxü̃ma i duü̃xü̃gü. ¡Choxü̃́ yaxõ, Pa Ngecüx! Rü aixcüma ínangu tá i ngunexü̃ na tãũtáma daa mèxpǘnewa rü ẽ́xna Yerucharéü̃wa tá nüxü̃ na picuèxüü̃güxü̃ ya Tanatü ya Tupana. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","—Erü yíxema aixcüma Tupanaxü̃ icuèxüü̃güxe rü nüe̱tama nixĩ i ngẽxü̃rüüxü̃mare i nachicawa Tupanaxü̃ ticuèxüü̃gü. Erü ñu̱xma rü ngẽma Naãẽ i Üünexü̃ naxwèxexü̃ nixĩ na guxü̃ma i tümaãẽmaã rü tümaãrü maxü̃maã aixcüma Tupanaxü̃ ticuèxüü̃güxü̃. Rü ngẽmaãcü nixĩ i nanaxwèxexü̃ ya Tanatü na nüxü̃ ticuèxüü̃güxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","—Erü Tupana rü wüxi i Naãẽ nixĩ. Rü ngẽmacèx yíxema texé ya nüxü̃ icuèxüü̃güxe rü tanaxwèxe i guxü̃ma i tümaãẽmaã rü tümaãrü maxü̃maã na aixcüma nüxü̃ ticuèxüü̃güxü̃, ngẽma Naãẽ i Üünexü̃ naxwèxexü̃ãcüma —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Rü yema ngecü inangãxü̃ rü ngĩgürügü: —Choma nüxü̃ chacuèx rü tá ñoma i naãnewa nangu ya yima Cristu ya Tupana nüxü̃ unetacü. Rü ngẽxguma yima núma ũxgu rü tá tamaã nanango̱xẽẽ i guxü̃ma i Tupanachiga —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Rü Ngechuchu rü ñanagürü ngĩxü̃: —Choma na cumaã chidexaxü̃, rü yima chixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Rü yexguma íyadexayane rü ítangugü ga toma ga norü ngúexü̃gü. Rü taḇaixãchiãẽgü yerü ga Ngechuchu rü wüxi ga ngecümaã ínidexa. Natürü taxúema ga toma rü togü taporaxẽẽ ga nüxna na tacagüxü̃ ga ṯacü ngĩmaã na nanaxwèxexü̃ rü ṯacüchiga yiĩxü̃ ga ngĩmaã na íyadexaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Rü yexguma ga yema ngecü rü yéma ngĩxü̃ itèx ga ngĩrü tü̃xü̃. Rü ĩãnewa ixũ na duü̃xü̃gümaã nüxü̃ yanaxuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Rü ngĩgürügü: —¡Ngĩxã rü ítayadaugü i wüxi i yatü i chomaã nüxü̃ ixuxü̃ ga guxü̃ma ga ṯacü ga chaxüxü̃! ¿Taux ẽ́xna yima yiĩxü̃ ya Cristu? —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Rü inaxĩãchi ga yema ĩãnecü̱̃ã̱x, rü Ngechuchu íyexmaxü̃wa naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Rü yoxni ga toma ga norü ngúexü̃gü rü Ngechuchuxü̃ tachixewegü na nachibüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Natürü ga nüma rü ñanagürü toxü̃: —Choma rü choxü̃́ nangẽxma i chowemü i pema tama nüxü̃ pecuáxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Rü yexguma ga toma ga norü ngúexü̃gü rü togüna tacagüe, rü ñatarügügü: —Bexmana marü ¿texé nuã tanange i nawemü? —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Natürü ga Ngechuchu rü ñanagürü toxü̃: —Ngẽma õna i choxü̃ poraxẽẽxü̃ nixĩ na chanaxüxü̃ i norü ngúchaü̃ ya yima nuã choxü̃ mucü ya Chaunatü, rü na chayanguxẽẽxü̃ i norü puracü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","—Rü pema rü ñaperügügü: “Rü ãgümücü ya tauemacü nataxu na yabuxgüxü̃ i trigu”, ñaperügügü. Natürü i choma rü ñacharügü pexü̃: “¡Dücèx, rü meã penangugü i duü̃xü̃gü! Erü marü ínamegü na Tupanaxü̃ nayauxgüxü̃cèx, ngẽxgumarüü̃ i wüxi i trigunecü i marü nawa nanguxü̃ na yabuxgüxü̃ erü marü nidau”. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","—Rü yíxema Tupanacèx nadexe i duü̃xü̃gü rü tá tanayaxu i tümaãrü natanü. Rü guxü̃ma i ngẽma duü̃xü̃gü i tüxü̃́ irüxĩnüẽxü̃ rü tá nanayauxgü i maxü̃ i taguma gúxü̃. Rü ngẽmaãcü rü wüxigu tá tataãẽgü ya yíxema tüxira ngẽma duü̃xü̃gümaã Tupanaãrü orexü̃ ixuxe rü yíxema yixcama ngẽma duü̃xü̃güxü̃ Tupanacèx dexe. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","—Rü aixcüma nixĩ i ngẽma ore i ñaxü̃: “Wüxie tixĩ ya namaã toexe i trigu rü togue tixĩ ya yíxema yabuxgüxe i norü o”, ñaxü̃. Rü ngẽxgumarüü̃ rü wüxie tixĩ ya tüxira duü̃xü̃gümaã nüxü̃ ixuxe i Tupanaãrü ore, rü togue tixĩ ya yixcama ngẽma duü̃xü̃güxü̃ dexe Tupanacèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","—Rü noxri rü togü nixĩ ga duü̃xü̃gümaã nüxü̃ ixuxü̃ ga Tupanaãrü ore, natürü ga duü̃xü̃gü rü tama nayaxõgü ga yexguma. Rü yemawena rü pexü̃ chamu na yema duü̃xü̃gümaã nüxü̃ pixuxü̃cèx ga yema ore. Rü pema nixĩ ga yema duü̃xü̃güxü̃ pedexü̃ Tupanacèx, yerü nayaxõgü ga yexguma namaã nüxü̃ pixuxgu ga yema ore. Rü yemaãcü ga pema rü marü peyoxniẽ nawa ga togüarü puracü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Rü muxü̃ma ga guma Chamáriaanewa yexmane ga ĩãnecü̱̃ã̱x rü Ngechuchuaxü̃́ nayaxõgü, yerü nüxü̃́ nayaxõgü ga yema ore ga yema ngecü namaã nüxü̃ ixuxü̃ ga yexguma ngĩxgu: “Guxü̃ma ga ṯacü ga ü̃pa chaxüxü̃ rü chomaã nüxü̃ nixu” ngĩxgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Rü yemacèx ga yema Chamáriaanecü̱̃ã̱xgü rü yexguma Ngechuchuxü̃tawa nangugügu rü nüxü̃ nacèèxü̃gü ga yexma natanügu na naxã́ũxü̃cèx. Rü taxre ga ngunexü̃ yexma natanügu narüxã̱ũ̱x ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Rü muxü̃ma ga togüamachigü ga Chamáriaanecü̱̃ã̱xgü rü Ngechuchuaxü̃́ nayaxõgü ga yexguma nüxü̃ naxĩnüẽgu ga yema norü ore ga nümatama nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Rü yexguma ga yema duü̃xü̃gü rü ñanagürügü ngĩxü̃ ga yema ngecü: —Ñu̱xma waxi nixĩ i aixcüma nüxü̃́ tayaxõgüxü̃ erü tomatama nüxü̃ taxĩnüẽ i ngẽma norü ore i tomaã nüxü̃ yaxuxü̃. Rü ngẽmawa nüxü̃ tacuèx na aixcüma yima yiĩxü̃ ya Cristu ya ñoma i naãnecü̱̃ã̱x i duü̃xü̃güarü maxẽxẽẽruü̃. Rü tama ngẽma cuma tomaã nüxü̃ quixuxü̃cèxicatama tayaxõgü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Rü taxre ga ngunexü̃guwena ga Ngechuchu rü tomaã inaxũãchi ga Chamáriaanewa na Gariréaanewa naxũxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Rü nümatama ga Ngechuchu ga ü̃paacü rü ñanagürü: —Wüxi i Tupanaãrü orearü uruü̃, rü norü naãnewatama i duü̃xü̃gü rü tama meã nanayauxgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Natürü yexguma Gariréaanewa tangugügu, rü yema naãnecü̱̃ã̱x ga duü̃xü̃gü rü meãma nanayauxgü. Yerü nümagü ga yema naãnecü̱̃ã̱xgü rü Yerucharéü̃wa naxĩ ta naxcèx ga Üpetüchigaarü peta, rü yéma nüxü̃ nadaugü ga yema taxü̃ ga mexü̃gü ga Tupanaãrü poramaã naxüxü̃ ga Ngechuchu ga yexguma. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Rü ga Ngechuchu rü tomaã nataegu naxcèx ga guma ĩãne ga Caná ga Gariréaanewa yexmane. Rü guma ĩãnewa nixĩ ga binuxü̃ nanguxuchixẽẽãxü̃ ga dexá. Rü ĩãne ga Capernáũwa nayexma ga wüxi ga tacü ga ãẽ̱xgacü, rü niḏaawe ga wüxi ga nane. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Rü yexguma guma ãẽ̱xgacü nüxü̃ cuáchigagu ga Ngechuchu rü Gariréaanewa na nanguxü̃ ga Yudéaanewa na ne naxũxü̃, rü naxü̃tawa naxũ. Rü nüxü̃ nayacèèxü̃ na napatawa naxũxü̃cèx, rü naxcèx na yanataanexẽẽãxü̃cèx ga guma nane ga marü turaxüchicü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Pema rü tama peyaxõgü ega tama nüxü̃ pedauxiragu i taxü̃ i cuèxruü̃gü i Tupanaãrü poramaã üxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Natürü ga guma ãẽ̱xgacü rü ñanagürü nüxü̃: —Pa Corix, ¡paxa chowe rüxũ naxü̃pa na nayuxü̃ ya chaune! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —¡Nataegu i cupatawa! Erü cune rü marü naxcèx nitaane —ñanagürü. Rü guma yatü rü nayaxõ ga yema ore ga Ngechuchu namaã nüxü̃ ixuxü̃. Rü napatacèx nataegu. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Rü yexguma napatawa nanguxchaü̃gu ga guma ãẽ̱xgacü, rü norü duü̃xü̃gü napẽ́xegu nayayi, rü ñanagürügü nüxü̃: —Cune rü marü naxcèx nitaane —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Rü yexguma rü norü duü̃xü̃güna naca, rü ñanagürü nüxü̃: —¿Ṯacü rü oragu inaxügüxü̃ na naxcèx yataanexü̃? —ñanagürü. Rü yema norü duü̃xü̃gü nanangãxü̃ rü ñanagürügü: —Ĩne tocuchiguwena nixĩ ga nüxü̃ nangupetüxü̃ ga na yaxaxünexü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Rü guma bucü nanatü rü nüxna nacuèxãchi ga yema oragu na yiĩxü̃ ga Ngechuchu ga ñaxü̃ nüxü̃: “Cune rü marü naxcèx nitaane” ñaxü̃. Rü nüma ga guma ãẽ̱xgacü rü guxü̃ma ga napatacü̱̃ã̱x rü Ngechuchuaxü̃́ nayaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Rü yexguma Yudéaanewa ne naxũxgu ga Ngechuchu, rü yema nixĩ ga norü taxre ga cuèxruü̃ ga taxü̃ ga Tupanaãrü poramaã duü̃xü̃güxü̃ nawéxü̃ ga Gariréaanewa. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Rü ñuxre ga ngunexü̃gü ngupetüguwena rü nayexma ga wüxi ga peta ga Yudíugü auregüxü̃ na yemaãcü Tupanaxü̃ yacuèxüü̃güxü̃cèx. Rü yemacèx ga Ngechuchu rü Yerucharéü̃cèx nataegu. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Rü guma ĩãneãrü poxeguxü̃ rü nüxü̃́ nayexma ga wüxi ga ĩã̱x ga Carneruarü Choxü̃chicagu ãe̱gaxü̃. Rü yema ĩã̱xãrü ngaicamana nayexma ga wüxi ga puchu ga Yudíugügawa Betechagu ãe̱gaxü̃. Rü guma puchuanacüwa nayexma ga wüximẽ́ẽ̱xpü̱x ga chopetüchica ga ãxpataü̃e̱tügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Rü yema chopetüchicagu nacagü ga muxü̃ma ga duü̃xü̃gü ga iḏaaweexü̃. Rü nümaxü̃ rü nangexetügü, rü togü rü nachixeparagü, rü togü rü nanaw̱ãĩxãchigü. Rü yema iḏaaweexü̃ rü yéma nananguxẽẽgü ga guma puchu ga na naxĩã̱xãchichiüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Yerü ñuxguacü rü guma puchugu ínarüxĩĩxü̃ ga wüxi ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃, rü nayaxĩã̱xchiücüüxẽẽxü̃. Rü guxema tüxira tügü yéma táexe nachiüwa ga guma puchu ga yexguma yaxĩã̱xchiücüügu, rü tümacèx nitaane woo ga ngẽxü̃rüü̃mare ga ḏaawe tüxü̃́ yexmaxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Rü yéma natanüwa nayexma ga wüxi ga yatü ga marü 38 ga taunecü iḏaawecü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Rü yexguma Ngechuchu nüxü̃ dèu̱xgu ga guma yatü ga yexma na nacaxü̃, rü nüxü̃ nacuáchiga ga marü mucüma ga taunecü na yaḏaawexü̃. Rü yemacèx nüxna naca rü ñanagürü nüxü̃: —¿Cunaxwèxexü̃ i cuxcèx na yataanexü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Rü Ngechuchuxü̃ nangãxü̃ ga guma iḏaawecü, rü ñanagürü: —Pa Corix, tataxuma ya texé ya choxü̃ rüngü̃xẽẽxẽ na nge̱ma choxü̃ tatáexü̃cèx i ngẽxguma naxĩã̱xãchichiügu ya daa puchu. Rü guxü̃guma i ngẽxguma nge̱ma chaugü chatáechaü̃gu, rü yoxni i togü rü marü nüxĩra nügü nge̱ma natáegü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Rü Ngechuchu rü ñanagürü nüxü̃: —¡Inachi, rü nayaxu i curü caruü̃, rü íixũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","10","Rü yexgumatama naxcèx nitaane ga guma yatü. Rü nanayaxu ga norü caruü̃, rü ínixũ. Natürü ga yema ngunexü̃ rü ngü̃xchigaarü ngunexü̃ nixĩ. Rü yemacèx ga yémacü̱̃ã̱xgü ga Yudíugüarü ãẽ̱xgacügü rü ñanagürügü nüxü̃ ga guma yatü ga naxcèx itaanecü: —Ñoma nixĩ i ngü̃xchigaarü ngunexü̃. Rü ngẽmacèx nachu̱xu nixĩ na cuyangexü̃ i curü caruü̃ erü yemaãcü tamaã nüxü̃ nixu ga Moĩché —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Natürü ga guma yatü rü yema Yudíugüarü ãẽ̱xgacügüxü̃ nangãxü̃, rü ñanagürü: —Yima choxü̃ rümexẽẽcü rü ñanagürü choxü̃: “¡Nayaxu i curü caruü̃ rü íixũ!” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Rü yexguma ga yema ãẽ̱xgacügü rü nüxna nacagü, rü ñanagürügü: —¿Texé ngẽma ñatarügü cuxü̃: “¡Nayaxu i curü caruü̃ rü íixũ!” ñatarügü cuxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Natürü ga guma yatü rü tama nüxü̃ nacuèx ga texé naxcèx na yataanexẽẽxü̃, yerü namuxũchi ga duü̃xü̃gü ga yéma, rü yexma nayarütaxu ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Natürü yixcama ga Ngechuchu rü tupauca ga taxü̃negu nüxü̃ nayangau ga guma yatü, rü ñanagürü nüxü̃: —¡Dücèx i ñu̱xma marü cuxcèx na yataanexü̃, rü tãũtáma wena chixexü̃ cuxü na tama quiḏaawexü̃cèx namaã i wüxi i ḏaawe i ngẽma marü cuxü̃ ngupetüxü̃ãrü yexera ixĩxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Rü ínixũ ga guma yatü, rü Yudíugüarü ãẽ̱xgacügümaã nüxü̃ nayarüxu ga Ngechuchu na yiĩxü̃ ga guma namexẽẽcü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Rü yemacèx nixĩ ga yema ãẽ̱xgacügü ga Ngechuchucèx nadaugüxü̃ na yamèxgüãxü̃cèx, yerü ngü̃xchigaarü ngunexü̃gu napuracü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —Chaunatü ya Tupana rü guxü̃ i ngunexü̃gu napuracü rü mexü̃ naxü. Rü ngẽmacèx i choma rü ta naxrüü̃ chapuracü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Rü yemacèx ga yema Yudíugüarü ãẽ̱xgacügü rü yexeraãcü Ngechuchuxü̃ nimèxgüchaü̃. Yerü tama naxrüü̃ nanaxaure ga ngü̃xchigaarü ngunexü̃ rü ñu̱xũchi nüxü̃ nixu ga Nanatüxüchi na yiĩxü̃ ga Tupana, rü yemaãcü nügü nixu ga Nanatü ga Tupanamaã na nawüxiguxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃ ga yema ãẽ̱xgacügü: —Aixcüma pemaã nüxü̃ chixu rü choma i Tupana Nane rü tama chorü poramaã chanaxü i ṯacü rü puracü i mexü̃. Natürü ngẽma nüxü̃ chadauxü̃ i Chaunatü üxü̃xĩcatama nixĩ ichaxüxü̃. Rü guxü̃ma i ngẽma Chaunatü üxü̃, rü choma ya Nane rü ta chanaxü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","—Chaunatü ya Tupana rü choxü̃ nangechaü̃, rü ngẽmacèx choxü̃ nüxü̃ nadauxẽẽ i guxü̃ma i ṯacü i nüma naxüxü̃. Rü ngẽma ñu̱xma choxü̃ nüxü̃ nadauxẽẽxü̃ãrü yexera tá choxü̃ nüxü̃ nadauxẽẽ i yixcüra. Rü ngẽxguma i pema ega ngẽmaxü̃ pedaugügu, rü tá peḇaixãchiãẽgü namaã. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","—Rü Chaunatü rü ínanadagüxẽẽ i yuexü̃gü rü wena nanamaxẽxẽẽ. Rü ngẽxguma-rüü̃ ta i choma i Nane rü tüxna chanaxã i maxü̃ ya yíxema chatümawèxéxe na tüxna chanaxãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","—Rü tama Chaunatü nixĩ ya duü̃xü̃güxü̃ icagücü i norü maxü̃chiga. Natürü choxü̃ nixĩ i namuxü̃ na chanaxüxü̃cèx i ngẽma, na choxü̃ yacuèxüü̃güxü̃cèx i duü̃xü̃gü, ngẽma Chaunatüxü̃ na yacuèxüü̃güxü̃rüü̃. Rü yíxema tama choxü̃ icuèxüxü̃́xẽ, rü tama nüxü̃ ticuèxüü̃ ta ya Chaunatü ya choxü̃ nuã mucü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","—Aixcüma pemaã nüxü̃ chixu rü yíxema texé ya choxü̃́ irüxĩnüxẽ i chorü ore, rü nüxü̃́ yaxṍxẽ ya yima Chaunatü ya núma choxü̃ mucü, rü tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. Rü Chaunatü rü tãũtáma tümamaã nanaxuegu na tapoxcuxü̃ erü marü nawa ítanguxuchi na tayuxü̃, rü tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","—Rü aixcüma pemaã nüxü̃ chixu rü marü nawa tá nangu i ngunexü̃ rü ñu̱xmatama nixĩ i chauga naxĩnüẽxü̃ tá i ngẽma duü̃xü̃gü i norü pecadugu yuexü̃ rü iyarütauxexü̃. Rü texé ya chauga ĩnüẽxẽ rü tá tamaxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","—Nüma ya Chaunatü rü nüxü̃́ nangẽxma i pora na namaxẽxẽẽãxü̃cèx i duü̃xü̃gü. Rü ngẽma pora rü choxna nanaxã ya Chaunatü na choma rü ta duü̃xü̃güxü̃ chamaxẽxẽẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","—Rü Chaunatü ya Tupana choxü̃ namu na duü̃xü̃güna chac̱axü̃cèx naxcèx i norü maxü̃chiga, erü choma nixĩ i Nane i duü̃xü̃xü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","—¡Tãxṹ i peḇaixãchiãẽgüxü̃ namaã i ñaã ore i pemaã nüxü̃ chixuxü̃! Erü tá ínangu i ngẽma ngunexü̃ i nagu guxü̃ma i duü̃xü̃gü i yuexü̃ rü tá na nüxü̃ naxĩnüẽxü̃ i chauga. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","—Rü naxmaü̃güwa tá ínachoxü̃. Rü ngẽma meã maxẽxü̃, rü tá ínarüdagü na nayauxgüãxü̃cèx i maxü̃ i taguma gúxü̃. Natürü ngẽma chixexü̃ ügüxü̃, rü tá ínarüdagü na napoxcuexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—Choma rü taxucürüwa ṯacü chaxü chauechamatama ega tama choxü̃ naxüxẽẽãgu ya Chaunatü. Rü Chaunatü chomaã nüxü̃ ixuxü̃ãcüma nixĩ i nüxna chac̱axü̃ i duü̃xü̃gü i norü maxü̃chiga. Rü ngẽxguma nüxna chacaxgu rü aixcüma meãma chanangugü i duü̃xü̃gü. Erü tama choxrütama ngúchaü̃ nixĩ i ngẽma chaxüxü̃, natürü Chaunatü ya nuã choxü̃ mucüarü ngúchaü̃ nixĩ i ngẽma chaxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","—Rü ngẽxguma chi chauchigaxü̃tama chixuxgu rü taxuwama name i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","—Natürü nangẽxma i to i chauchigaxü̃ ixuxü̃. Rü nüxü̃ chacuèx rü aixcüma nixĩ i norü ore i pemaã nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Pema rü Cuáü̃ ya baiü̃xẽẽruü̃xü̃tawa penamugü ga perü duü̃xü̃gü na nüxü̃ pecuáxü̃cèx ga ore ga aixcüma ixĩxü̃ ga chauchiga. Rü yema ore ga Cuáü̃ pexü̃ namaã ngãxü̃xü̃ rü aixcüma nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","—Natürü i choma rü tama chanaxwèxe i ṯacü rü yatü chauétüwa nachogü, erü choma tátama chaugüna chadau. Natürü pemaã nüxü̃ chixu i ngẽma Cuáü̃ãrü ore na choxü̃́ peyaxõgüxü̃cèx rü na penayauxgüxü̃cèx i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","—Cuáü̃ rü wüxi ga omü ga iy̱auracüüxü̃ rü pexü̃ báxixü̃-rüü̃ nixĩ ga pexcèx. Rü pema rü paxaãchi namaã petaãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","—Natürü nangẽxma i ṯacü i Cuáü̃ãrü orearü yexera chauétüwa íchogüxü̃. Rü ngẽma nixĩ ga yema taxü̃gü ga cuèxruü̃gü ga Chaunatü choxü̃ muxü̃ na norü poramaã chanaxüxü̃cèx. Rü yemawa pexü̃ nüxü̃ chadauxẽẽ na aixcüma Chaunatü ya Tupana yiĩxü̃ ga núma choxü̃ mucü. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","—Rü ngẽxgumarüü̃ ta ya Chaunatü ga guma núma choxü̃ mucü, rü marü chauétüwa ínachogü, woo taguma nüxü̃ pexĩnüẽ ga naga rü taguma nüxü̃ pedau. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","—Rü ngẽma Chaunatüarü ore rü ta tama peãẽwa nixücu, erü tama choxü̃́ peyaxõgü woo Chaunatü núma choxü̃ na muxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","40","—Pema meãma nawa pengúe i Tupanaãrü ore i ümatüxü̃, erü nagu perüxĩnüẽ rü ngẽmawa tá nüxü̃ ipeyangau i perü maxü̃ i taguma gúxü̃. Natürü woo ngẽmatama Tupanaãrü ore i ümatüxü̃wa rü chauchiga meã na yadexaxü̃, natürü i pema rü tama choxü̃́ peyaxõgüchaü̃ na ngẽmaãcü penayauxgüxü̃cèx i ngẽma maxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","42","—Rü choma rü tama chanaxwèxe na choxü̃ picuèxüü̃güxü̃ erü meãma pexü̃ chacuèx, rü nüxü̃ chacuèx na tama aixcüma Tupanaxü̃ pengechaü̃güxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","—Chaunatü ya Tupana nixĩ ga núma choxü̃ mucü, natürü i pema rü tama choxü̃ peyauxgüchaü̃. Natürü ngẽxguma chi tomare i yatü nagagutama núma ũxgu, rü ngẽma chi nixĩ i taãẽãcüma peyauxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","—¿Rü ñuxãcü chi choxü̃́ peyaxõgü ega penaxwèxegu na pemücügütama pemaã taãẽxü̃ rü tama naxcèx pedaugügu na Tupanaxü̃chi pemaã taãẽxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","—¡Tãxṹ i nagu perüxĩnüẽxü̃ na choma tá yiĩxü̃ na pexü̃ chixugüxü̃ i Chaunatüxü̃tawa! Erü Moĩché ga guma perü maxü̃cèx nüxü̃́ peyaxõgücü tátama nixĩ ya yima pexü̃ ixugücü i Chaunatüxü̃tawa. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","—Rü ngẽxguma chi peyaxõgügu i ngẽma ore ga Moĩché ümatüxü̃, rü choxü̃́ rü chi ta peyaxõgü. Yerü ga Moĩché rü chauchigagu nixĩ ga naxümatüãxü̃ ga norü poperawa. ");
INSERT INTO tcaNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","—Natürü ngẽxguma tama peyaxõgügu i ngẽma Moĩché ümatüxü̃ i ore, ¿rü ñuxãcü tá peyaxõgü i ngẽma choma pemaã nüxü̃ chixuxü̃? —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Rü yemawena ga Ngechuchu rü naxtaxa ga Gariréagu ãe̱ganearütocutüwa tomaã naxũ. Rü norü toéga ga guma naxtaxa rü Tibéria nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Rü muxü̃ma ga duü̃xü̃gü rü nawe narüxĩ. Yerü ü̃paacü rü marü nüxü̃ nadaugü ga ñuxãcü Ngechuchu na naxüxü̃ ga taxü̃ ga mexü̃gü ga Tupanaãrü poramaã üxü̃ ga yexguma duü̃xü̃gü ga iḏaaweegüxü̃cèx yataanexẽẽgüãgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Rü yexguma ga Ngechuchu rü wüxi ga mèxpǘnewa tomaã ínaxü̃ãchi. Rü wüxigu tomaã yéma narüto. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Rü marü ningaica ga yema Yudíugüarü peta ga Üpetüchiga. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Rü yexguma Ngechuchu nüxü̃ dawenügu rü nüxü̃ nadau ga muxü̃ma ga duü̃xü̃gü ga nawe rüxĩxü̃. Rü yemacèx Piripina naca, rü ñanagürü: —¿Rü ngextá tá naxcèx tataxe i nawemü i ñaã duü̃xü̃gü na nachibüexẽẽxü̃cèx? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Rü nümatama ga Ngechuchu rü marü nüxü̃ nacuèx ga ṯacü tá na naxüxü̃. Natürü yema ñanagürü Piripixü̃, yerü nüxü̃ nacuáxchaü̃ ga ṯacümaã tá na nangãxü̃ãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Rü yexguma Ngechuchuxü̃ nangãxü̃ ga Piripi, rü ñanagürü: —Woo chi naxcèx itaxegügu i 200 i dĩẽru naguxü̃ i pãũ, rü tãũ chima nüxü̃́ ningu ega woo wüxichigüna íraxü̃ ixãchigügu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Rü yexguma ga Aü̃dré ga Ngechuchuarü ngúexü̃ ga Pedru ga Chimáũ naẽneẽ, rü ñanagürü: —Nuã nangẽxma i wüxi i buxü̃ rü nüxü̃́ nangẽxma i 5 i pãũ i chebadanaxcèx rü taxre ta i choxni. ¿Natürü ṯacüwa name i ngẽma naxcèx i ñaã muxũchixü̃ i duü̃xü̃gü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Rü yexguma ga Ngechuchu rü ñanagürü toxü̃: —¡Ẽcü, namaã nüxü̃ pixu i duü̃xü̃gü na ínatogüxü̃cèx! —ñanagürü. Rü yema nachicawa rü nametẽ́xeane ga guma maxẽ. Rü gumatẽ́xewa narütogü ga duü̃xü̃gü. Rü maneca 5000 wa nangu ga yexguma yatügüxica ixugügu. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Rü yexguma ga Ngechuchu rü nanade ga yema pãũgü, rü Tupanana moxẽ naxã. Rü yemawena rü toxü̃ nayanu na yema duü̃xü̃gü ga yéma rütogüxü̃xü̃ tayanuxü̃cèx. Rü yexgumarüü̃ ta ga choxni rü nüxü̃ toxü̃ nayanuxẽẽ, ñu̱xmata meãma nachibüe ga guxü̃ma ga yema duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Rü yexguma marü meã nachibüegu ga guxü̃ma, rü Ngechuchu toxü̃ namu rü ñanagürü toxü̃: —¡Penade i ngẽma naxchipẽ́xegü i íyaxügüxü̃ na tama inaxaiyèxü̃xü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Rü tanade ga yema naxchipẽ́xegü ga yema 5 ga pãũwa íyaxüxü̃, rü 12 ga pexchi namaã tanaxüãcugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Rü yexguma yema duü̃xü̃gü nüxü̃ daugügu ga yema mexü̃ ga taxü̃ ga Tupanaãrü poramaã naxüxü̃ ga Ngechuchu, rü ñanagürügü: —Aixcümaxü̃chi daa nixĩ ya Tupanaãrü orearü uruü̃ ga guma ínanguxẽẽcü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Natürü ga Ngechuchu rü nüxü̃ nicuèxãchi ga duü̃xü̃gü rü na norü ãẽ̱xgacüxü̃ yangu-cuchixẽẽgüchaü̃ãxü̃. Rü yemacèx nüxna nixũgachi rü yéamaxü̃ra naxũ nawa ga guma mèxpǘne na nüxĩcatama nayexmaxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Rü yexguma marü nachütagu, rü toma ga Ngechuchuarü ngúexü̃gü rü wenaxãrü naxtaacutüwa taxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Rü poraãcü naxẽãne. Rü tama ínangu ga Ngechuchu. Rü yemacèx wüxi ga ngue ga taxü̃negu tichoü̃, rü itaxĩãchi ga na tocutüwa taxĩxü̃ ga Capernáũãrü ĩãnewa na tangugüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Rü yexguma tixãü̃yane rü inaxügü ga na poraãcü yabuaxü̃. Rü yemagagu rü poraãcü nayuape. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Rü yexguma marü 5 ga kilómetru tixãü̃gu, rü Ngechuchuxü̃ tadaugü ga na dexáchiüétügu yaxũxü̃. Rü toma ga norü ngúexü̃gü rü poraãcü tamuü̃ẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Natürü nüma ga Ngechuchu rü ñanagürü toxü̃: —Choma chixĩ. ¡Rü tãxṹ i pemuü̃ẽxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Rü yexguma ga toma ga norü ngúexü̃gü rü taãẽãcüma tanayauxgüchaü̃ ga toweü̃wa. Rü yexgumatama ítangugü ga yema ítaxĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Rü moxü̃ãcü ga yema duü̃xü̃gü ga naxtaxaarü tocutügu rüchoxü̃, rü nüxü̃ nicuèxãchitanü ga toma ga Ngechuchuarü ngúexü̃gü ga marü nagu na taxĩxü̃ ga guma ngue ga taxü̃ne ga nügümaã wüxicane. Rü nüxü̃ nacuèxgü ta ga Ngechuchu rü tama towe na naxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Rü yexguma yemagu ínaxĩnüẽyane, rü yoxocüne ínangugü ga náĩgü ga ngue ga itaxü̃ne ga Tibériaarü ĩãnewa ne ĩxü̃ne. Rü norü ngaicamana nangugü ga yema nachica ga ngextá Ngechuchu ínachibüexẽẽxü̃wa ga yema muxü̃ma ga duü̃xü̃gü ga yexguma moxẽ inaxãxgu naxcèx ga yema pãũ. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Rü yexguma yema duü̃xü̃gü nüxü̃ daugügu ga guma nguewa na Ngechuchu rü toma ga na tatauxexü̃ma rü yexma guma nguegügu nichoü̃ na Ngechuchucèx yadaugüxü̃ Capernáũãrü ĩãnegu. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Rü yexguma guma naxtaxaarü tocutüwa nangugügu ga yema duü̃xü̃gü, rü Ngechuchuxü̃ yexma nayangaugü. Rü nüxna nacagüe, rü ñanagürügü: —Pa Ngúexẽẽruü̃x, ¿ñuxgu nixĩ i nuã cunguxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü tama yema nüxü̃ na picuèxãchitanüxü̃cèx ga yema mexü̃gü ga Tupanaarü poramaa chaxüxü̃ nixĩ i chauxcèx pedaugüxü̃. Natürü chauxcèx pedaugü yerü meãma pechibüe nawa ga yema õna ga pexna chaxãxü̃.. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","—¡Tãxṹ i naxcèx pepuracüexü̃ i õna i paxama gúxü̃! Rü narümemaẽ nixĩ i naxcèx pepuracüe i ngema maxü̃ i aixcüma ixĩxü̃ i taguma gúxü̃. Rü ngẽma nixĩ i maxü̃ i choma i Tupana Nane ya duü̃xü̃xü̃ chixĩcü tá pexna chaxãxü̃, erü Chaunatü ya Tupana rü marü nanango̱xẽẽ na aixcüma Nane chiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Rü yexguma ga nümagü rü nüxna nacagü, rü ñanagürügü: —¿Ṯacü tá taxüe na tayanguxẽẽxü̃cèx i ngẽma Tupana toxü̃́ naxwèxexü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Rü Tupana rü núma choxü̃ namu. Rü ngẽma nüma pexü̃́ nanaxwèxexü̃ nixĩ na choxü̃́ peyaxõgüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Rü yexguma ga nümagü rü nüxna nacagü, rü ñanagürügü nüxü̃: —¿Ṯacü rü cuèxruü̃xü̃ tá toxü̃ cudauxẽẽ na cuxü̃́ tayaxõgüxü̃cèx na aixcüma Cristu quiĩxü̃? ¿Rü ṯacü i to i mexü̃ tá toxcèx cuxüxü̃ i ñu̱xmax? ");
INSERT INTO tcaNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Yerü nuxcümaü̃güxü̃ ga tórü o̱xigü, rü nanangõ̱xgü ga yema pãũ ga Tupana nüxna ãxü̃ ga chianexü̃wa ga ngextá taxúema íxãpataxü̃wa. Rü Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Tupana rü daxũcü̱̃ã̱x ga pãũmaã nanachibüexẽẽ ga duü̃xü̃gü”, ñanagürü i ngẽma orewa. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü tama nixĩ ga Moĩché yiĩxü̃ ga nüxna naxãxü̃ ga yema pãũ ga daxũ- cü̱̃ã̱x, natürü Chaunatü ga Tupana nixĩ ga nüxna naxãcü. Rü nüma nixĩ i ñu̱xma i pexna naxããxü̃ i pãũ i aixcüma ixĩxü̃ i daxũwa ne ũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","—Erü ngẽma pãũ i Tupana ixãxü̃, rü daxũguxü̃ i naãnewa ne naxũ rü nanamaxẽxẽẽ i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Rü nümagü rü naxcèx ínacagü, rü ñanagürügü nüxü̃: —Pa Corix, ¡guxü̃guma toxna naxãẽcha i ngẽma pãũ! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Rü Ngechuchu ñanagürü nüxü̃: —Choma nixĩ i ngẽma pãũ i maxẽxẽẽruü̃ chiĩxü̃. Rü yíxema texé ya chauxü̃tawa ũxẽ rü tagutáma tataiya. Rü texé ya choxü̃́ yaxṍxẽ rü tagutáma tiṯawa. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","—Natürü marü pemaã nüxü̃ chixu rü woo na choxü̃ pedaugüxü̃ rü tama choxü̃́ peyaxõgü i pemax. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","—Rü guxãma ya yíxema duü̃xẽgü ya Chaunatü choxna tüxü̃ mugüxe rü chorü duü̃xü̃gü tixĩgü. Rü texé ya choxü̃́ yaxõgüxe rü tãũtáma tüxü̃ chaxoo̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","—Yerü tama choxrütama ngúchaü̃ na chaxüxü̃cèx nixĩ ga daxũguxü̃ ga naãnewa ne chaxũxü̃. Natürü núma chaxũ na chanaxüxü̃cèx i norü ngúchaü̃ ya Chaunatü ya núma choxü̃ mucü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","—Rü ngẽma norü ngúchaü̃ ya Chaunatü ya Tupana ya núma choxü̃ mucü nixĩ i na taxúexü̃ma ichayarütauxẽẽxü̃ ya yíxema choxna tüxü̃ namugüxe. Erü nüma ya Chaunatü nanaxw̱ae na tüxü̃ yuwa ícharüdagüxẽẽxü̃ i naãneãrü gu̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","—Choma nixĩ i Tupana Nane chiĩxü̃. Rü ngẽma norü ngúchaü̃ ya Chaunatü ya Tupana ya núma choxü̃ mucü nixĩ na tüxü̃́ nangẽxmaxü̃ i maxü̃ i taguma gúxü̃ ya guxãma ya texé ya choxü̃ daugüxe rü choxü̃́ yaxõgüxe. Erü choma tá nixĩ i tüxü̃ ícharüdagüxẽẽxü̃ i naãneãrü gu̱xgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Rü yexguma yema orexü̃ naxĩnüẽgu ga yema Yudíugü, rü inanaxügüe ga Ngechuchuchiga na yadexagüxü̃. Yerü ñanagürü ga Ngechuchu: —Choma nixĩ i pãũ i daxũguxü̃ i naãnewa ne chaxũxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Rü ñanagürügü: —¿Taux ẽ́xna ñaã yiĩxü̃ i Ngechuchu i Yúche nane? Rü yixema rü tüxü̃ tacuèx ya nanatü rü naẽ. ¿Rü ñuxãcü i nüma i “Daxũwa ne naxũxü̃”, ñaxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Rü Ngechuchu ñanagürü nüxü̃: —¡Nüxü̃ perüxoe na choxü̃ na pixuechaxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","—Taxúema chauxü̃tawa tangu ega tama choxna tüxü̃ namu̱xgu ya chaunatü ga guma núma choxü̃ mucü. Rü texé ya chauxü̃tawa ngugüxe rü choma rü tá wena tüxü̃ chamaxẽxẽẽ i naãneãrü gu̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","—Nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃güarü poperawa naxümatü i ore i ñaxü̃: “Tupana tá guxãxü̃ nangúexẽẽ”, ñaxü̃. Rü ngẽmacèx guxãma ya texé ya Chaunatüxü̃ ĩnüxẽ rü naxü̃tawa ngúxe, rü chauxü̃tawa taxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","—Taguma texé Chaunatü ya Tupanaxü̃ tadau. Rü chaxicatama nixĩ i nüxü̃ chadauxü̃ erü naxü̃tawa ne chaxũ. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","—Aixcüma pemaã nüxü̃ chixu rü texé ya choxü̃́ yaxṍxẽ rü tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","—Choma nixĩ i pãũ i maxẽxẽẽruü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","—Rü perü o̱xigü ga nuxcümaü̃güxü̃ rü nanangõ̱x ga yema pãũ ga Tupana nüxna ãxü̃ ga yema nachica ga ngextá taxúema íxãpataxü̃wa. Natürü woo nanangõ̱xgü ga yema pãũ rü nayueamatama. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","—Natürü ñaã pãũ i pemaã nüxü̃ chixuxü̃ i daxũwa ne ũxü̃ rü chomatama chixĩ. Rü guxãma ya texé ya choxü̃ yaxúxe ñoma pãũ tangṍxü̃rüü̃ rü tá tamaxẽcha. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","—Chomatama nixĩ i pãũ i maxẽxẽẽruü̃ i daxũwa ne chaxũxü̃. Rü texé ya ñoma chomaã taxãwemüxü̃rüü̃ choxü̃́ yaxṍxẽ rü guxü̃gutáma tamaxẽcha. Erü ngẽma pãũ i choma tüxna chaxãxü̃ rü chaxunetama nixĩ. Rü ichanaxã i chaxune na namaxẽxü̃cèx i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Rü yexguma ga yema Yudíugü rü poragaãcü nügüna nacagüe, rü ñanagürügü: —¿Ñuxãcü tá i ñaã yatü i naxü̃ne tátama tüxü̃ nangõ̱xẽẽxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Rü Ngechuchu ñanagürü nüxü̃: —Rü choma i Tupana nane na duü̃xü̃xü̃ chiĩxü̃ rü aixcüma pemaã nüxü̃ chixu rü ngẽxguma pema rü tama chaxunemaã pexãwemügügu rü tama nawa pexaxegügu ya chaugü, rü tãũtáma pexü̃́ nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","—Texé ya chaxunemaã ãwemüxẽ rü chaugüwa axexe rü tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. Erü choma rü tá tüxü̃ chamaxẽẽ ega naãneãrü gu̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","—Erü chaxune rü õnaxü̃chi nixĩ rü chaugü rü axexü̃xü̃chi nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","—Texé ya chaxunemaã ãwemüxẽ rü chaugüwa axexe rü chowa tayaxũ̱x rü choma i tümawa. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","—Chaunatü ga núma choxü̃ mucü rü namaxü̃. Rü nüma choxna nanaxã i maxü̃. Rü ngẽxgumarüü̃ ta i choma rü tá tüxna chanaxã i maxü̃ ya yíxema choxü̃ yaxúxe rü choxü̃́ yaxṍxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","—Marü pemaã nüxü̃ chixu na choma rü pãũ i daxũwa ne ũxü̃ chiĩxü̃. Natürü choma rü tama yema pãũ ga nuxcümaü̃güxü̃ ga perü o̱xigü ngõ̱xgüxü̃ ga pãũrüü̃ chixĩ. Yerü woo ga yema pãũ na nangõ̱xgüxü̃ ga perü o̱xigü rü nayueamatama. Natürü texé ya choxü̃ yaxúxe, ñoma pãũ tangṍxü̃rüü̃, rü choxü̃́ yaxṍxẽ rü guxü̃gutáma tamaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Rü Ngechuchu rü duü̃xü̃gümaã nüxü̃ nixu ga yema ore ga yexguma nangúexẽẽãgu ga Yudíugüarü ngutaquẽ́xepataü̃wa ga ĩãne ga Capernáũwa. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Rü yexguma nüxü̃ naxĩnüẽgu ga yema ngu̱xẽẽtae, rü muxü̃ma ga yema duü̃xü̃gü ga nawe rüxĩxü̃ rü ñanagürügü: —Rü ngẽma tamaã nüxü̃ yaxuxü̃, rü naguxchaxüchi na nüxü̃ icuáxü̃ na ñuxũ ñaxü̃. ¿Ñuxãcü texé tüxü̃́ natauxcha na naga taxĩnüxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Natürü ga Ngechuchu rü nüxü̃ nacuèxama ga yemaãcü nügümaã na íyadexagüxü̃ naxcèx ga yema ngu̱xẽẽtae, rü yemacèx nüxna naca, rü ñanagürü: —¿Ẽ́xna peãẽwa nangu̱x i ngẽma ore? ");
INSERT INTO tcaNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","—Rü ngẽxguma peãẽwa nangu̱xgu i ngẽma ore i pemaã nüxü̃ chixuxü̃, rü ¿ṯacügu chi perüxĩnüẽxü̃ ega choxü̃ pedèu̱xgu na wenaxãrü daxũ na chaxĩxü̃, ga noxri ne chaxũxü̃wa na chaxũxü̃ i choma i Tupana Nane na duü̃xü̃xü̃ chiĩxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","—Tupanaãẽ i Üünexü̃ nixĩ i inaxãxü̃ i maxü̃ i taguma gúxü̃. Rü tama pexene nixĩ i pexü̃ maxẽxẽẽxü̃. Rü ngẽma ore i pemaã nüxü̃ chixuxü̃ rü peãẽcèx nixĩ, rü nawa nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","—Natürü tangẽxma i petanüwa ya ñuxre ya tama yaxõgüxe —ñanagürü. Rü yema ñanagürü ga Ngechuchu yerü noxriarü ügügumama marü nüxü̃ nacuèx ga texé tá nüxü̃́ na yaxõgüxü̃, rü texé tá cúãcü ínaxuaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Rü ñanagürü ta: —Rü ngẽmacèx marü pemaã nüxü̃ chixu rü taxuacüma texé chauxü̃tawa tangu ega tama Chaunatü chauxü̃tawa tüxü̃ gaxgu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Rü yexguma inanaxügüe ga nüxna na yaxĩgüxü̃ ga muxü̃ma ga yema duü̃xü̃gü ga noxri nawe rüxĩchiréxü̃. Rü marü tama nawe ínaxĩĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Rü yexguma ga Ngechuchu rü norü 12 ga ngúexü̃güna naca, rü ñanagürü nüxü̃: —¿Ẽ́xna pema rü ta choxna pixĩgachitanüchaü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Natürü Chimáũ ga Pedru rü nanangãxü̃, rü ñanagürü: —Pa Corix, ¿Texéxü̃tawa chi taxĩxü̃ ega cuxna tixĩgachitanügu? Erü cuma rü cuxü̃́ nangẽxma i ore i nawa nangẽxmaxü̃ i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","—Toma rü marü cuxü̃́ tayaxõgü, rü nüxü̃ tacuèx na cuma quiĩxü̃ ya Cristu ya Üünecü ya Tupana Nane —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Rü Ngechuchu toxü̃ nangãxü̃, rü ñanagürü: —¿Taux ẽ́xna choma yiĩxü̃ ga pexü̃ chidexechixü̃ ga pema ga 12? Natürü nangẽxma i wüxi i petanüwa i Chatanáãrü duü̃xü̃ ixĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Rü Yuda ga Icariúte ga Chimáũ nanechiga nixĩ ga yadexaxü̃ ga Ngechuchu. Yerü Yuda tá nixĩ ga cúãcü ínaxuaxü̃xü̃ rü woo ga nüma rü wüxi ga totanüxü̃chirẽ́x na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Rü yemawena ga Ngechuchu rü Gariréaanewa yexmagüne ga ĩãnegügu nixũãgüchigü. Rü tama Yudéaanewa nayexmachaü̃ yerü yémacü̱̃ã̱x ga Yudíugüarü ãẽ̱xgacügü rü naxcèx nadaugü ga na yamèxgüchaü̃ãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Natürü marü ningaica ga yema Yudíugüarü peta ga nagu norü düxenügü yaxügüxü̃ na yemawa nüxna nacuèxãchiexü̃cèx ga ñuxãcü nuxcümaü̃güxü̃ ga norü o̱xigü na naxügüxü̃ ga norü düxenügü ga naĩxã́tünaxcèx ga yexguma Moĩchéwe naxĩxgu ga ngextá taxúema íxãpataxü̃wa. Rü yemacèx nixĩ ga Düxenügüarü Petagu naxãe̱gaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Rü naẽneẽgü ga Ngechuchu rü ñanagürügü nüxü̃: —Tama name i nuxã Gariréaarü naãnegu curüxã̱ũ̱x. Rü name nixĩ i petacèx Yudéawa cuxũ, na ngẽma duü̃xü̃gü i cuwe rüxĩxü̃ i nge̱ma ngẽxmagüxü̃ nüxü̃ daugüxü̃cèx i ngẽma cuèxruü̃gü i mexü̃gü i Tupanaãrü poramaã cuxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","—Erü ngẽxguma chi wüxi ya yatü rü duü̃xü̃güxü̃ nügü nacuèxẽẽchaü̃gu rü tama cúãcü nanaxü i ṯacü i naxüxü̃. Rü ñu̱xma na cunaxüxü̃ i muxü̃ma i mexü̃gü i Tupanaãrü poramaã cuxüxü̃, rü name nixĩ i guxü̃ i duü̃xü̃güpẽ́xewa cunaxü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Rü yema ñanagürügü ga naẽneẽgü yerü woo ga nümagü rü ta tama nüxü̃́ nayaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Rü yexguma ga Ngechuchu rü nanangãxü̃, rü ñanagürü nüxü̃: —Tauta nawa nangu i ngunexü̃ na petawa chaxũxü̃. Natürü pexcèx rü ngẽxü̃rüüxü̃mare i ngunexü̃ nixĩ i mexü̃ na petawa nagu pexĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","—Ngẽma duü̃xü̃gü i ñoma i naãnecü̱̃ã̱x rü tama pexchi naxaie. Natürü chauxchi naxaie erü chanango̱xẽẽ i ngẽma naxügüxü̃ rü na nachixexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","—Name nixĩ i petawa pexĩ i pemax. Choma rü tauta nge̱ma chaxũ erü tauta nawa nangu i ngunexü̃ i nagu nge̱ma chaxũxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Rü yexguma yema ñaxguwena, rü Gariréaanegu narüxã̱ũ̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Natürü nawena ga naẽneẽgü ga petawa na naxĩxü̃, rü Ngechuchu rü ta yéma naxũ. Natürü cúãcü yéma naxũ, rü tama poraãcü duü̃xü̃güxü̃ nügü nadauxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Rü yema Yudíugüarü ãẽ̱xgacügü rü naxcèx nadaugü ga yema petawa, rü ñanagürügü: —¿Ngextá nangẽxma i ngẽma yatü? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Rü nügütanüwa ga yema duü̃xü̃gü ga yéma yexmagüxü̃, rü poraãcü Ngechuchuchiga ínidexagü. Rü ñuxre ga yema duü̃xü̃gü rü ñanagürügü: —Yima rü wüxi ya yatü ya mecü nixĩ —ñanagürügü. Natürü ga togü rü ñanagürügü: —Ngẽma yatü rü tama name erü duü̃xü̃güxü̃ nawomüxẽẽ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Natürü taxuü̃ma ga duü̃xü̃gü rü mea togüpẽ́xewa Ngechuchuxü̃ nicuèxüü̃güchaü̃, yerü yema Yudíugüarü ãẽ̱xgacügüxü̃ namuü̃ẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Rü yexguma marü yema petaarü ngãxü̃wa nanguxgu, rü nixücu ga Ngechuchu nawa ga tupauca ga taxü̃ne. Rü inanaxügü ga na nangu̱xẽẽtaexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Rü yema Yudíugüarü ãẽ̱xgacügü, rü naḇaixãchiãẽgü namaã ga yema ore ga Ngechuchu nüxü̃ ixuxü̃. Rü ñanagürügü: —¿Ñuxãcü i ngẽmaãcü poraãcü nüxü̃ nacuáxü̃, rü taguma texé nangu̱xẽẽ? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Ñaã chorü ngu̱xẽẽtae rü tama choxrü nixĩ, erü Chaunatü ya núma choxü̃ mucüarü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","—Ngẽxguma texé naxüxchaü̃gu i Tupanaãrü ngúchaü̃ rü yíxema tá nüxü̃ tacuèx ngoxi aixcüma Tupanaxü̃tawa chanayaxu i ngẽma chorü ngu̱xẽẽtae rü ẽ́xna chaugüxü̃tawatama chayaxuxü̃ yixĩ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","—Yíxema texé ya mexü̃ i tümachigaxü̃tama ixuxe rü ngẽmaãcü tanaxü erü tanaxwèxe i duü̃xü̃gü na tüxü̃ icuèxüü̃güxü̃. Natürü texé nüxü̃ tixu i ore i mexü̃ nachiga i ngẽma tüxü̃ muxü̃, rü aixcüma nixĩ i tümaãrü ore. Rü tama dora nixĩ i ngẽma nüxü̃ tixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","—¿Tama ẽ́xna aixcüma yiĩxü̃ ga Moĩché pexna naxãxü̃ ga Tupanaãrü mugü? Natürü taxúema i pema naga pexĩnüẽ i ngẽma mugü. ¿Rü ñu̱xma rü tü̱xcüü̃ nixĩ i choxü̃ pimèxgüchaü̃xü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Rü yema duü̃xü̃gü nanangãxü̃gü, rü ñanagürügü: —Cuma rü ngoxo cuwa nangẽxmamare. ¿Ẽ́xna texé cuxü̃ timèxgüchaü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —Choma rü ngü̃xchigaarü ngunexü̃gu chanamexẽẽ ga wüxi ga yatü. Rü guxãma i pema rü penuãẽgü naxcèx ga yema wüxitama ga mexü̃ ga ngü̃xchigaarü ngunexü̃gu chaxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","—Natürü pema rü ta ngü̃xchigaarü ngunexü̃gu pepuracüe na nagu pexĩxü̃cèx ga Moĩchéarü mugü. Rü Moĩché pemaã nüxü̃ nixu na tüxü̃ ípewiechèxmüpẽ́xechiraü̃xü̃ ya guxãma ya yatüxe ya buxe. Natürü tama Moĩché nixĩ ga inaxügücü ga yema, yerü nuxcümaü̃güxü̃ ga perü o̱xigüwa nixĩ ga ne naxũxü̃. Rü ñu̱xma i pema rü yema mugagu rü tüxü̃ ípewiechèxmüpẽ́xechiraü̃ ya guxãma ya buxe ya yatüxe woo ngü̃xchigaarü ngunexü̃ yixĩgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","—Rü ngẽmaãcü i pema rü ngü̃xchigaarü ngunexü̃gu buxexü̃ ípewiechèxmüpẽ́xechiraü̃ erü naga pexĩnüẽchaü̃ i Moĩchéarü mugü. ¿Rü ñu̱xma rü tü̱xcüü̃ yiĩxü̃ i chomaã penuẽxü̃ naxcèx na ngü̃xchigaarü ngunexü̃gu chanamexẽẽxü̃ ga wüxi ga yatü ga iḏaaweecü? ");
INSERT INTO tcaNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","—Rü ngẽmacèx tama name i ngürümare penangugü i ngẽma chaxüxü̃. Rü penaxwèxe i meã nagu perüxĩnüẽxira, na aixcüma meã penangugüxü̃cèx —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Rü ñuxre ga yema duü̃xü̃gü ga Yerucharéü̃gu ãchiü̃güxü̃ rü nügüna nacagüe, rü ñanagürügü: —¿Taux ẽ́xna daa yiĩxü̃ ya yima yatü ya ãẽ̱xgacügü naxcèx daugücü na yamèxgüchaü̃ãxü̃cèx? ");
INSERT INTO tcaNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","—¡Dücèx! Gua nixĩ rü yéa guxü̃ i duü̃xü̃güpẽ́xewa nidexa rü taxúema ñuxũ ñatarügü nüxü̃. ¿Taux ẽ́xna i tórü ãẽ̱xgacügü i marü nüxü̃́ yaxõgüãxü̃ na aixcüma Cristu na yiĩxü̃ i nümax? ");
INSERT INTO tcaNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","—Natürü i yixema rü nüxü̃ tacuèxgü na ngextá ne naxũxü̃ i nümax. Natürü ngẽxguma aixcüma Cristu núma ũxgu rü taxúetáma nüxü̃ tacuèx na ngextá na ne naxũxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Rü nüma ga Ngechuchu rü tupauca ga taxü̃newa ínanangúexẽẽ ga duü̃xü̃gü. Rü yexguma nüxü̃ naxĩnügu ga yema ore ga Yudíugü nüxü̃ ixugüexü̃ ga nachiga, rü tagaãcü ñanagürü: —Pema rü marü choxü̃ pecuèx rü nüxü̃ pecuèx na ngextá na ne chaxũxü̃. Natürü tama chaugagu nixĩ i núma chaxũxü̃. Choma núma chaxũ yerü núma choxü̃ namu ga Tupana ya naxwèxecü na nüxü̃́ yaxõgüxü̃ natürü i pema rü tama nüxü̃ pecuácü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","—Choma rü nüxü̃ chacuèx yerü naxü̃tawa ne chaxũ, rü nüma nixĩ i núma choxü̃ namuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Rü yexguma ga yema ãẽ̱xgacügü rü Ngechuchuxü̃ niyauxgüchaü̃. Natürü taxuü̃ma nayayauxgü, yerü tauta nawa nangu ga ngunexü̃ ga na yayauxgüãxü̃ rü na yamèxgüãxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Natürü muxü̃ma ga duü̃xü̃gü rü nüxü̃́ nayaxõgü. Rü ñanagürügü: —¿Ngẽxguma ínanguxgu ya Cristu rü ṯacü rü cuèxruü̃ i taxü̃ tá naxü ya daa yatü tama üxü̃ i ñu̱xmax? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Rü yema Parichéugü rü duü̃xü̃güxü̃ naxĩnüẽ ga yemaãcü Ngechuchuchiga na yadexagüxü̃. Rü yemacèx ga nümagü rü paigüarü ãẽ̱xgacügü rü yéma nanamugü ga tupauca ga taxü̃neãrü purichíagü na Ngechuchuxü̃ yanayauxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Paxaãchi tátama nixĩ i petanüwa changẽxmaxü̃, rü ñu̱xũchi tá chataegu naxü̃tawa ya yima núma choxü̃ mucü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","—Pema rü tá chauxcèx pedaugü, natürü tãũtáma choxü̃ ipeyangaugü. Erü ngẽma ngextá tá íchangẽxmaxü̃wa rü taxuacü nge̱ma pengugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Rü yexguma ga yema Yudíugüarü ãẽ̱xgacügü rü nügüna nacagüe, rü ñanagürügü: —¿Ngextá tá naxũ ega taxuacütáma nüxü̃ iyarüngaugügu? ¿Ẽ́xna ngẽma Yudíugü i to i nachiü̃ãnewa ngẽxmagüxü̃tanüwa tá naxũ rü ẽ́xna ngẽma tama Yudíugü ixĩgüxü̃tanüwa tá naxũ na yangúexẽẽãxü̃cèx? ");
INSERT INTO tcaNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","—¿Rü ṯacüchiga nixĩ i ngẽma na ngẽma ñaxü̃: “Tá chauxcèx pedaugü natürü tãũtáma choxü̃ ipeyangaugü, erü taxuacütáma nge̱ma pexĩ i ngẽma tá íchangẽxmaxü̃wa”, ñaxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Rü yema nawa iyacuáxü̃ ga petaarü ngunexü̃ nixĩ ga guxü̃ ga togü ga ngunexü̃ãrü yexera rümemaẽxü̃ naxcèx ga Yudíugü. Rü yema ngunexü̃gu nixĩ ga inachixü̃ ga Ngechuchu rü tagaãcü ñaxü̃: —Rü ngẽxguma texé iṯawaxgu rü ¡nuã chauxü̃tawa taxũ rü tayaxaxe! ");
INSERT INTO tcaNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","—Rü “texé ya choxü̃́ yaxṍxẽ rü tümaãrü maxü̃newa tá nibaibe i taxü̃ i dexá i maxẽẽruü̃” ngẽma Tupanaãrü ore i ümatüxü̃ nüxü̃ ixuxü̃rüü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Rü yexguma yema ñaxgu ga Ngechuchu rü Tupanaãẽ i Üünexü̃chiga nixĩ ga yadexaxü̃. Rü nüxü̃ nixu ga guxü̃ma ga yema nüxü̃́ yaxõgüxü̃ rü tá na nayauxgüãxü̃ i Naãẽ i Üünexü̃. Natürü tama yexgumatama nanayauxgü, yerü tauta wenaxãrü daxũguxü̃ ga naãnecèx nataegu ga Ngechuchu na guxü̃ãrü ãẽ̱xgacü na yiĩxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Rü nümaxü̃ ga yema duü̃xü̃gü rü yexguma nüxü̃ naxĩnüẽgu ga yema Ngechuchu nüxü̃ ixuxü̃, rü ñanagürügü: —Aixcüma ñaã yatü nixĩ i ngẽma Tupanaãrü orearü uruü̃ i ínguxchaü̃xü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Rü togü rü ñanagürügü: —Daa nixĩ ya Cristu —ñanagürügü. Natürü togü rü ñanagürügü: —Tama nixĩ, erü taxucürüwa Gariréaanecü̱̃ã̱x nixĩ ya Cristu. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","—Erü Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Cristu rü tá Dabítaa nixĩ, rü tá nango̱x i ĩãne i Beréü̃wa ga ngextá Dabí íbuxü̃wa”, ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Rü yemaãcü Ngechuchugagu nügü nitoye ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Rü ñuxre ga yema duü̃xü̃gü rü Ngechuchuxü̃ niyauxgüchaü̃, natürü taxuü̃ma nayayauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Rü yema tupauca ga taxü̃neãrü purichíagü, rü Parichéugücèx rü paigüarü ãẽ̱xgacügücèx nawoegu. Rü yema ãẽ̱xgacügü rü nüxna nacagü, rü ñanagürügü: —¿Tü̱xcüü̃ tama nuã penaga? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Rü yema purichíagü rü nanangãxü̃gü rü ñanagürügü: —Taguma texé tidexa i ñaã yatü idexaxü̃rüü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Rü yexguma ga Parichéugü rü ñanagürügü nüxü̃: —¿Ẽ́xna pexü̃ rü ta marü nawomüxẽẽ i nümax? ");
INSERT INTO tcaNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","—Dücèx, rü taxúema i tomax i Parichéugü rü taxuü̃ma i tórü ãẽ̱xgacügü rü nüxü̃́ nayaxõgü i ngẽma Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","—Natürü ñaã duü̃xü̃gü i tama Tupanaãrü mugüxü̃ cuèxgüxü̃ rü marü nachixexü̃gugü —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Natürü Nicodému ga Parichéu ixĩcü ga wüxicana Ngechuchuxü̃tagu naxũãnecü, rü ñanagürü nüxü̃: ");
INSERT INTO tcaNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Ngẽma tórü mugü i ümatüxü̃wa rü ñanagürü: “Taxuacüma wüxi i yatüxü̃ tapoxcu ega tama nüxü̃ ixĩnüẽxĩragu i norü dexa na nüxü̃ icuáxü̃cèx na ṯacü na naxüxü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Rü yexguma ga natanüxü̃gü rü nanangãxü̃gü, rü ñanagürügü nüxü̃: —¿Ẽ́xna cuma rü ta Gariréaanecü̱̃ã̱x quixĩ? ¡Nawa nangu̱x i Tupanaãrü ore i ümatüxü̃ rü nge̱ma tá nüxü̃ cudau rü taxuü̃táma i Tupanaãrü orearü uruü̃ rü Gariréaanecü̱̃ã̱x nixĩ! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Rü yexguma ga wüxichigü rü nachiü̃wa naxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Rü Ngechuchu rü Oríbunecügu ãe̱gane ga mèxpǘnewa naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Rü moxü̃ãcü ga yexguma yangunegu, rü wenaxãrü tupauca ga taxü̃necèx nataegu. Rü ga duü̃xü̃gü rü naxcèx naxĩ. Rü nüma ga Ngechuchu rü ínarüto, rü inanaxügü ga na nangúexẽẽãxü̃ ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Rü yema ngúexẽẽruü̃gü ga Moĩchéarü mugüwa ngu̱xẽẽtaegüxü̃ rü Parichéugü, rü Ngechuchuxü̃tawa ngĩxü̃ nagagü ga wüxi ga nge ga ãtecü ga ngĩxü̃ nadaugücü ga naĩ ga yatümaã na inapexü̃. Rü guxü̃ma ga yema duü̃xü̃gü ga yéma yexmagüxü̃pẽ́xegu ngĩxü̃ nayachixẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Rü ñanagürügü Ngechuchuxü̃: —Pa Ngúexẽẽruü̃x, ñaã nge i ãtecü rü ngĩxü̃ itayangau na naĩ ya yatümaã na inapexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moĩchéarü mugüwa tamaã nüxü̃ nixu na nutamaã ngĩxü̃ íimuxũchiãcüma ngĩxü̃ imáxü̃ i wüxi i nge i ngẽmaãcü maxü̃cü. ¿Ñuxũ ñacuxü̃ i cuma i ñu̱xmax? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Rü yema ñanagürügü ga nümagü, yerü Ngechuchuxü̃ guxchaxü̃gu nanguxẽẽgüchaü̃ na nüxü̃́ nayexmaxü̃cèx ga ṯacücèx na ínaxuaxü̃güãxü̃. Natürü ga Ngechuchu rü inayarümaxãchi rü inanaxügü ga naxmẽ́xmaã waixü̃müwa na naxümatüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Natürü nüxü̃ nacèèxü̃güama, rü yemacèx düxwa wenaxãrü nadaunagü ga Ngechuchu, rü ñanagürü nüxü̃: —Ngexerǘxe i petanüwa ya ngearü pecaduã́xẽ rü tüxira nuta ngĩxü̃ tanaṉ̃a —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Rü wenaxãrü inayarümaxãchi ga Ngechuchu rü naxmẽ́xmaã nanaxümatü ga waixü̃müwa. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Natürü yexguma nüxü̃ naxĩnüẽgu ga yema ore ga Parichéugü rü inanaxügüe ga nügü na yawüxíxü̃ ga nügüwe na ínachoxü̃xü̃. Rü yaguã̱xgü ga Parichéugüwa inaxügü ga na ínachoxü̃xü̃ rü düxwa guxü̃ma ínachoxü̃. Rü yexguma marü guxü̃ma ga Parichéugü íchoü̃xgu, rü Ngechuchu rü yema ngecüxicatama yéma duü̃xü̃güpẽ́xewa nayaxügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Rü yexguma ga Ngechuchu rü wena nadaunagü. Rü ngĩxna naca rü ñanagürü ngĩxü̃: —Pa Ngecüx, ¿Ngẽxü̃gü nixĩ i ngẽma cuxü̃ ixugüexü̃? ¿Rü taxuü̃ma cuxü̃ imáxchaü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Rü ngĩma rü ngĩgürügü nüxü̃: —Taxuü̃ma Pa Corix —ngĩgürügü. Rü yexguma ga Ngechuchu rü ñanagürü ngĩxü̃: —Choma rü ta tama cuxü̃ chapoxcu. Ñu̱xma rü marü name rü íquixũ rü tama wena pecadu cuxü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Rü wenaxãrü duü̃xü̃gümaã nidexa ga Ngechuchu, rü ñanagürü nüxü̃: —Choma nixĩ i ñoma i naãnecü̱̃ã̱xãrü ngóonexẽẽruü̃. Rü yíxema chowe rüxũxẽ rü chorü ngóonexü̃wa tangẽxma rü tüxna chanaxã i maxü̃. Rü tá nüxna ítanguxuchi i tümaãrü chixexü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Rü yexguma ga Parichéugü rü ñanagürügü nüxü̃: —Cuma rü cugüchigaxü̃tama quixu. Rü ngẽma cuchiga i nüxü̃ quixuxü̃ rü taxuwama name —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Rü ngẽma ore i chauchiga nüxü̃ chixuxü̃ rü aixcüma nixĩ woo chomatama yixĩgu i namaã chaugüétüwa chidexaxü̃. Erü choma rü nüxü̃ chacuèx i ngextá ne chaxũxü̃, rü ngextá tá chaxũxü̃. Natürü pema rü tama nüxü̃ pecuèx na ngextá ne chaxũxü̃ rü tama nüxü̃ pecuèx na ngextá tá chaxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Pema rü choxü̃ pengugü i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü nagu rüxĩnüẽxü̃ãcümamare. Natürü i choma rü taxúexü̃ma changugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Natürü ngẽxguma chi texéxü̃ changugügu rü aixcüma meãma tüxü̃ changugü. Erü tama chaxicatama tüxü̃ changugü, natürü yima Chaunatü ga núma choxü̃ mucümaã nixĩ i wüxigu tüxü̃ tangugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Rü ngẽma mugü ga Moĩché ümatüxü̃ i nagu pexĩxü̃, rü ñanagürü: “Ngẽxguma taxre i duü̃xü̃gü rü wüxitama i orexü̃ yaxugügu, rü ngẽmawa ãẽ̱xgacü nüxü̃ nacuèx na aixcüma yiĩxü̃ i ngẽma nüxü̃ yaxugüexü̃”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Rü dücax, choma nixĩ i wüxi i chauchigaxü̃ chixuxü̃ rü Chaunatü ga núma choxü̃ mucü nixĩ ya naĩ. ¿Rü tü̱xcüü̃ tama choxü̃́ peyaxõgüchaü̃ i ñu̱xmax? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Rü yexguma ga nümagü rü nüxna nacagüe rü ñanagürügü: —¿Ngexcü ya yima Cunatü? —ñanagürügü. Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Choxü̃ rü tama pecuèx rü Chaunatüxü̃ rü ta tama pecuèx. Rü ngẽxguma chi choxü̃ pecuèxgügu rü Chaunatüxü̃ rü chi ta pecuèxgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Rü yema orexü̃ nixu ga Ngechuchu ga yexguma nangu̱xẽẽtaegu ga tupauca ga taxü̃newa naxü̃tawa ga yema nachica ga ngextá duü̃xü̃gü tupaucana dĩẽru ngĩxü̃ íxãgüxü̃wa. Natürü taxuü̃ma Ngechuchuxü̃ niyauxgü, yerü tauta nawa nangu ga yema ngunexü̃ ga nagu yayauxgüãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Rü Ngechuchu rü wenaxãrü namaã nüxü̃ nixu, rü ñanagürü: —Choma rü tá pexna chixũ i núma, rü pema rü tá chauxcèx pedaugü, natürü tá perü pecadugu peyue. Rü ngextá íchaxũxü̃wa rü taxucürüwama nge̱ma pexĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Rü yexguma ga yema Yudíugü rü ñanagürügü: —¿Ẽ́xna nügü tátama nimèx rü ngẽmacèx tamaã nüxü̃ yaxuxü̃ na taxucürüwama nge̱ma ixĩxü̃ i ngẽma ínaxũxü̃wa? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Rü Ngechuchu ñanagürü nüxü̃: —Pema rü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü pixĩgü, natürü i choma rü daxũguxü̃ i naãnewa ne chaxũ. Pema rü ñoma i naãneãrü duü̃xü̃gü pixĩgü natürü i choma rü tama ñoma i naãnecü̱̃ã̱x chixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","—Rü ngẽmacèx pemaã nüxü̃ chixu rü tá perü pecadugu peyue. Erü ngẽxguma tama choxü̃́ peyaxõgügu na choma chiĩxü̃ ya Cristu, rü perü pecadugu tá peyue —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Rü yexguma nüxna nacagüe, rü ñanagürügü: —¿Natürü texé quixĩ i cumax? —ñanagürügü. Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Marü noxritama pemaã nüxü̃ chixu na texé chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","—Rü choma rü choxü̃́ nangẽxma i muxü̃ma i ṯacü i chomatama pexü̃ changúexẽẽchaü̃xü̃ rü ṯacücèx pexna na chac̱axü̃, natürü tãũtáma chanaxü i ngẽma. Erü yima Chaunatü ga núma choxü̃ mucü chomaã nüxü̃ ixuxü̃ i orexicatama nixĩ i ñoma i naãnecü̱̃ã̱xgümaã nüxü̃ chixuxü̃. Rü guxü̃ma i ngẽma nüxü̃ yaxuxü̃ ya Chaunatü, rü aixcüma nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Natürü nümagü rü tama nüxü̃ nacuèxgüéga ga Nanatü ya Tupanachiga na yiĩxü̃ na yema ñaxü̃ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Rü yemacèx ga Ngechuchu rü ñanagürü nüxü̃: —Choma nixĩ i Tupana Nane i duü̃xü̃xü̃ chiĩxü̃. Rü yixcüra ngẽxguma curuchawa choxü̃ pipotagügu, rü tá nüxü̃ picuèxãchitanü na Cristu na chiĩxü̃. Rü tá nüxü̃ pecuèx na taxuü̃ma chauechamatama chaxüxü̃. Rü ngẽma Chaunatü chomaã nüxü̃ ixuxü̃xĩcatama nixĩ i pemaã nüxü̃ chixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","—Yima núma choxü̃ mucü ya Chaunatü rü chauxü̃tawa nangẽxma. Rü taguma choxna nixũgachi, erü choma rü guxü̃guma chanaxü i ngẽma norü ngúchaü̃ ixĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Rü yexguma yema ñaxgu ga Ngechuchu rü muxü̃ma ga duü̃xü̃gü nüxü̃́ nayaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃ ga yema Yudíugüarü ãẽ̱xgacügü ga nüxü̃́ yaxõgüxü̃: —Ngẽxguma pema meãma peyaxõgüechagu i ngẽma pemaã nüxü̃ chixuxü̃, rü aixcümaxü̃chi tá chorü ngúexü̃gü pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","—Rü tá nüxü̃ pecuèx i ore i aixcüma ixĩxü̃. Rü ngẽma ore tá pexü̃ ínanguxü̃xẽẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Rü nümagü rü Ngechuchuxü̃ nangãxü̃gü, rü ñanagürügü: —Toma rü nuxcümaü̃cü ga torü o̱xi ga Abráü̃taa tixĩgü rü taguma texémẽ́xẽwa tangẽxmagü. ¿Ñuxãcü i cumax rü tá na ítanguxü̃xü̃, ñacuxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Rü Ngechuchu ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü guxãma ya pecaduã́xẽ rü pecadutüü̃wa tangẽxmagü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","—Wüxi i coriarü duü̃xü̃mare rü tama norü coripatacü̱̃ã̱x nixĩ. Natürü wüxi i cori nane rü guxü̃guma nanatü nane nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","—Choma rü Tupana Nane chixĩ. Rü ngẽxguma chi choma pecaduna pexü̃ íchanguü̃xẽẽgu, rü aixcüma tá nüxna ípenguü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","—Marü nüxü̃ chacuèx na Abráü̃taa pixĩgüxü̃ i pemax. Natürü choxü̃ pimèxgüchaü̃ erü tama aixcüma choxü̃́ peyaxõgü i ngẽma ore i pemaã nüxü̃ chixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","—Choma rü yema Chaunatü choxü̃ wéxü̃ nixĩ i pemaã nüxü̃ chixuxü̃. Natürü pema rü penaxü i ngẽma penatü pemaã nüxü̃ ixuxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Rü nümagü rü Ngechuchuxü̃ nangãxü̃ rü ñanagürügü: —Torü o̱xi nixĩ ga Abráü̃ —ñanagürügü. Natürü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Ngẽxguma chi aixcüma Abráü̃taa pixĩgügu rü chi Abráü̃ üxü̃rüü̃ penaxü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","—Natürü woo pemaã nüxü̃ chixu i ore i aixcüma ixĩxü̃ ga Chaunatü ga Tupana choxü̃ ngu̱xẽẽxü̃, rü pema rü choxü̃ pimèxgüchaü̃. Natürü ga Abráü̃ rü taguma yemaãcü nanaxü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","—Pema rü penaxü i penatügücümatama —ñanagürü. Rü yexguma ga nümagü rü ñanagürügü: —Toma rü tama tangürüwaü̃gümare, rü toxü̃́ nangẽxma ya wüxitama ya tonatü. Rü yima nixĩ ya Tupana —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Ngẽxguma chi aixcüma Tupana yixĩgu ya penatü rü choxü̃ chi pengechaü̃, erü choma rü Tupanaxü̃tawa nixĩ i ne chaxũxü̃, rü ngẽmacèx chanuxma. Rü tama chauechamatama núma chaxũ, natürü núma chaxũ yerü Chaunatü ya Tupana núma choxü̃ namu. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","—¿Tü̱xcüü̃ tama nüxü̃ pecuèxéga i ngẽma pemaã nüxü̃ chixuxü̃? Pexü̃́ naguxcha erü woetama tama iperüxĩnüẽchaü̃ i ngẽma pemaã nüxü̃ chixuxü̃ i ore. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","—Penatü rü Chataná nixĩ rü pema rü naxãcügü pixĩgü. Rü ngẽmacèx penaxü i ngẽma nüma pexü̃́ nanaxwèxexü̃. Rü ngẽma Chataná rü noxriarü ügügumama wüxi i máẽtaxü̃ nixĩ. Rü taguma ore i aixcümaxü̃gu narüxĩnü rü taguma ore i aixcümaxü̃ nixu. Rü ngẽxguma yadeaxgu rü doraxü̃xĩcatama nixu, erü nüma rü wüxi i doratèxáxü̃ nixĩ. Rü guxü̃ma i doratèxáxü̃natü nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","—Natürü i pema rü tama choxü̃́ peyaxõgüchaü̃ erü ore i aixcümaxü̃ chixu. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","—¿Texé ya petanüwa choxü̃ dauxe na pecadu chaxüxü̃? Rü ñu̱xma na nüxü̃ chixuxü̃ i ore i aixcüma ixĩxü̃, rü ¿tü̱xcüü̃ tama choxü̃́ peyaxõgü? ");
INSERT INTO tcaNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","—Texé ya Tupanaãrü duü̃xü̃ ixĩxẽ rü itarüxĩnü i Tupanaãrü ore. Natürü i pema rü tama Tupanaãrü duü̃xü̃gü pixĩgü, rü ngẽmacèx nixĩ i tama iperüxĩnüẽchaü̃xü̃ i Tupanaãrü ore —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Rü yexguma ga yema Yudíugüarü ãẽ̱xgacügü rü ñanagürügü nüxü̃: —Rü aixcüma nixĩ ga yema torü ore ga yexguma ñatagügügu: “Cuma rü wüxi i Chamáriacü̱̃ã̱x quixĩ, rü ngoxo cuwa nangẽxma”, ñatagügügu —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Chowa rü nataxuma i ngoxo. Rü ngẽma chaxüxü̃ nixĩ na Chaunatüxü̃ chicuèxüü̃xü̃, natürü i pema rü chixri chauchiga pidexagü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","—Choma rü tama naxcèx chadau na texé choxü̃ icuèxüü̃güxü̃cèx. Natürü Tupana nixĩ ya naxwèxecü na duü̃xü̃gü choxü̃ icuèxüü̃güxü̃. Rü nüma tá nanapoxcue i ngẽma chauxchi aiexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","—Aixcüma pemaã nüxü̃ chixu, rü texé ya naga ĩnüxẽ i ngẽma tümamaã nüxü̃ chixuxü̃ rü guxü̃gutáma tamaxẽcha —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Rü yexguma ga yema Yudíugüarü ãẽ̱xgacügü, rü Ngechuchuxü̃ nangãxü̃gü, rü ñanagürügü: —Ñu̱xma rü meãxü̃chima nüxü̃ tacuèx na cuwa nangẽxmaxü̃ i wüxi i ngoxo. Yerü ga Abráü̃ rü guxü̃ma ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü rü nayue. Natürü cuma rü ñu̱xma tomaã nüxü̃ quixu rü texé ya naga ĩnüxẽ i ngẽma curü ore rü guxü̃gutáma tamaxẽcha —ñacurügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","—¿Ẽ́xna cuma rü tórü o̱xi ga Abráü̃ãrü yexera quixĩ? Yerü nüma rü nayu rü guxü̃ma ga nuxcümaü̃güxü̃ ga Tupanaãrü orearü uruü̃gü rü ta nayue. ¿Rü cugücèx rü texé quixĩ? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Ega chaugü chitama chicuèxüü̃gu rü ngẽma rü taxuwama name. Natürü yima choxü̃ icuèxüü̃cü rü Chaunatü nixĩ. Rü yima Chaunatütama nixĩ ya perü Tupana ixĩcü —ñapegücü nüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","—Natürü i pema rü tama aixcüma nüxü̃ pecuèx ya Chaunatü ya Tupana. Natürü i choma rü ngẽmáãcü nüxü̃ chacuèx. Rü ngẽxguma chi: “Tama nüxü̃ chacuèx”, ñachaxgu, rü pexrüü̃ chi wüxi i doratèxáxü̃ chixĩ. Natürü i choma rü aixcümaxü̃chima nüxü̃ chacuèx ya Chaunatü ya Tupana, rü naga chaxĩnü i guxü̃ma i norü ore i chomaã nüxü̃ yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","—Perü o̱xi ga Abráü̃ rü nataãẽ yerü aixcüma nayaxõ rü tá na íchanguxü̃ i ñoma i naãnewa. Rü yemaxü̃ nacuèx rü yemacèx nataãẽ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Rü yexguma ga yema Yudíugüarü ãẽ̱xgacügü rü Ngechuchuxü̃ nangãxü̃gü, rü ñanagürügü: —Cuma rü tauta 50 ya taunecü cuxü̃́ nangẽxma. ¿Ñuxãcü Abráü̃xü̃ cudau ga tauta cungo̱xgux ga yexguma? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü tauta Abráü̃ ngo̱xgu rü choma rü marü chayexma —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Rü yexguma ga nümagü rü nutane nanayauxgü na gumamaã ínamuxũchigüãxü̃cèx. Natürü ga Ngechuchu rü naxchaxwa inicu̱x. Rü yemaãcü ínaxũxü̃ nawa ga guma tupauca ga taxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Rü yexguma namagu tomaã yaxũxgu ga Ngechuchu, rü yéma nüxü̃ nadau ga wüxi ga yatü ga woetama norü bucüma ngexetücü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Rü toma ga norü ngúexü̃gü rü nüxna tacagü, rü ñatarügügü: —Pa Ngúexẽẽruü̃x, ¿Tü̱xcüü̃ ngexetücüma nabu ya daa yatü? ¿Ẽ́xna nanatü rü naẽãrü pecadugagu rü ẽ́xna norü pecadugagutama? —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Rü Ngechuchu toxü̃ nangãxü̃, rü ñanagürü toxü̃: —Tama norü pecadugagu rü tama i nanatü rü naẽãrü pecadugagu nixĩ i ngẽmaãcü nabuxü̃. Natürü ngẽmaãcü nabu na nawa nüxü̃ pedauxü̃cèx na ñuxãcü Tupana tüxü̃ na rümexẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","—Rü ñoma rü ta nangune rü name nixĩ na paxama na naxüxü̃ i ngẽma puracü ya Chaunatü ga núma choxü̃ mucü tüxna ãxü̃. Erü paxa tá nachüta rü ngẽxguma rü taxucürüwama texé tá tapuracü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","—Rü ñu̱xma na ñoma i naãnewa changẽxmaxü̃ rü ñoma i naãneãrü ngóonexẽẽruü̃ chixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Rü yexguma yema ñaxguwena rü Ngechuchu waixü̃müãnewa nacuaxi. Rü yema waixü̃mü ga iwaixü̃maã nanachaxetü ga guma yatü ga ngexetücü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Rü yexguma guma ngexetücüxü̃ ñanagürü: —¡Dexámaã cugü yayauxetü i Chiruéarü puchuwa! —ñanagürü. Rü ngẽma nae̱ga rü “Tüxü̃ muxü̃”, ñaxü̃chiga nixĩ. Rü yéma naxũ ga guma ngexetücü rü nügü dexámaã nayauxetü. Rü yexguma nataegugu rü marü nidauchixetü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Rü yexguma ga yema duü̃xü̃gü ga guma ngexetücüpataarü ngaicamagu pegüxü̃ rü yema duü̃xü̃gü ga ü̃paacü nüxü̃ daugüxü̃ ga na nangexetüxü̃, rü ñanagürügü: —¿Taux ẽ́xna i ñaã yiĩxü̃ ga yema yatü ga ngexetüchiréxü̃ ga duü̃xü̃güxü̃ dĩẽrucèx cèèxü̃xü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Rü nümaxü̃ rü ñanagürügü: —Ngẽmáãcü nüma nixĩ —ñanagürügü. Rü togü rü ñanagürügü: —Tama nixĩ i yima yiĩxü̃, natürü nanangẽxgumaraü̃xü̃chi —ñanagürügü. Natürü nümatama ga guma yatü ga ngexetüchirécü, rü ñanagürü: —Ngẽmáãcü choma chixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Rü yexguma ga yema duü̃xü̃gü rü nüxna nacagü rü ñanagürügü: —¿Rü ñuxãcü nixĩ i marü quidauchixü̃ i ñu̱xmax? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Rü nüma nanangãxü̃ rü ñanagürü: —Yima yatü ya Ngechuchugu ãe̱gacü rü yima waixü̃müãnewa nacuaxi. Rü yema waixü̃mü ga iwaixü̃maã choxü̃ nachaxetü. Rü ñanagürü choxü̃: “¡Yéa Chiruéarü puchuwa naxũ rü nge̱ma dexámaã cugü yayauxetü!” ñanagürü choxü̃. Rü yéma chaxũ, rü yexguma dexámaã chaugü chayauxetügu rü chidauchi —ñanagürü ga guma yatü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Rü yexguma nüxna nacagüe, rü ñanagürügü: —¿Ngextá nangẽxmaxü̃ i ñu̱xma ya yima yatü ya cuxü̃ rümexẽẽcü? —ñanagürügü. Rü nüma ga guma yatü ga ngexetüchirécü rü ñanagürü: —Tama nüxü̃ chacuèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Natürü yema ngunexü̃ ga Ngechuchu nagu namexẽẽxü̃ ga guma ngexetücü, rü ngü̃xchigaarü ngunexü̃ nixĩ. Rü yemacèx ga duü̃xü̃gü rü Parichéugüxü̃tawa nanagagü ga guma yatü ga ngexetüchirécü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Rü yexguma ga yema Parichéugü rü nüxna nacagüe ga guma yatü, rü ñanagürügü: —¿Ñuxãcü i marü curümexẽtüxü̃ i ñu̱xmax? —ñanagürügü. Rü nüma nanangãxü̃ rü ñanagürü: —Waixü̃mü ga naxbüxágümaã yawaixẽẽxü̃maã choxü̃ nachaxetü ga Ngechuchu, rü ñu̱xũchi dexámaã chaugü chayayauxetü, rü ngẽmacèx marü chidauchi —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Rü yexguma ga ñuxre ga Parichéugü rü ñanagürügü: —Yema yatü ga cuxü̃ rümexẽẽxü̃ rü tama Tupanaãrü duü̃xü̃ nixĩ, erü tama nanaxaure i ngü̃xchigaarü ngunexü̃ —ñanagürügü. Natürü togü ga Parichéugü rü ñanagürügü: —¿Ñuxãcü nanaxü i ngẽma cuèxruü̃ i mexü̃ i taxü̃ ega wüxi i pecaduã́xü̃ yixĩxgux? —ñanagürügü. Rü yemaãcü nügü nitoye ga nagu naxĩnüẽxü̃wa ga yema Parichéugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Rü wena nüxna nacagüe ga guma yatü ga ngexetüchirécü, rü ñanagürügü: —¿Natürü cuma rü ñuxũ ñacuxü̃ nachiga i ngẽma yatü ga cuxü̃ rümexẽẽxü̃? —ñanagürügü. Rü nüma nanangãxü̃, rü ñanagürü: —Chauxcèx rü wüxi i Tupanaãrü orearü uruü̃ nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Natürü ga yema Yudíugüarü ãẽ̱xgacügü rü tama nüxü̃́ nayaxõgüchaü̃ ga nüma na yiĩxü̃ ga na nangexetüchiréxü̃ ga noxrix, rü ñu̱xma rü marü na yadauchixü̃. Rü yemacèx ga yema ãẽ̱xgacügü rü tümacèx nangemagü ga nanatü rü naẽ ga guma yatü ga rümexẽtücü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Rü tüxna nacagü, rü ñanagürügü: —¿Daa yiĩxü̃ ga guma pene ga nüxü̃ pixucü ga woetama ngexetüãcü bucü? ¿Ñuxãcü i ñu̱xma i yadauchixü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Rü nanatü rü naẽ tanangãxü̃gü rü ñatarügügü: —Ngẽmáãcü nüxü̃ tacuèx rü daa nixĩ ya tone ga ngexetüãcüma buchirécü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Natürü tama nüxü̃ tacuèx ga ñuxãcü na yadauchixü̃ i ñu̱xmax. Rü tama nüxü̃ tacuèx ga texé na namexẽtüxẽẽxü̃. ¡Ẽcü nüxnatama pecagü! Erü nüma rü marü naya, rü nümatama pemaã nüxü̃ na yaxuxü̃cèx —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Rü yema ñatarügügü ga nanatü rü naẽ, yerü tamuü̃ẽ. Yerü ga Yudíugüarü ãẽ̱xgacügü rü marü nügümaã nanamexẽẽgü na tüxü̃ ínatèxüchigüxü̃cèx ga ngutaquẽ́xepataü̃wa ga texé ga Ngechuchuaxü̃́ yaxṍxẽ na Cristu yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rü yemacèx nixĩ ga nanatü rü naẽ ga ñatagügüxü̃: “¡Ẽcü, nüxnatama pecagü! Erü nüma rü marü naya rü nümatama pemaã nüxü̃ na yaxuxü̃cèx”, ñatagügüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Rü yexguma ga yema Yudíugüarü ãẽ̱xgacügü rü wenaxãrü naxcèx nacagü ga guma ngexetüchirécü. Rü ñanagürügü nüxü̃: —Rü ñu̱xma tanaxwèxe i Tupanapẽ́xewa rü aixcüma tomaã nüxü̃ quixu na texé cuxü̃ rümexẽẽxü̃. Erü toma rü meãma nüxü̃ tacuèx i ngẽma Ngechuchu rü wüxi i pecaduã́xü̃ na yiĩxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Rü nüma nanangãxü̃ rü ñanagürü nüxü̃: —Choma rü tama nüxü̃ chacuèx ega wüxi i pecaduã́xü̃ yixĩgu rü ẽ́xna tama. Rü ngẽma nüxü̃ chacuáxü̃ nixĩ ga na changexetüchiréxü̃ ga noxrix rü ñu̱xma rü na chidauchixü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Rü wenaxãrü nüxna nacagüe, rü ñanagürügü: —¿Rü ṯacü nixĩ ga cumaã naxüxü̃? ¿Rü ñuxãcü ga naxüãxü̃ ga cuxü̃ na yadauchixetüxẽẽxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rü nanangãxü̃ rü ñanagürü nüxü̃: —Marü pemaã nüxü̃ chixu, rü tama choxü̃́ iperüxĩnüẽchaü̃. ¿Tü̱xcüü̃ penaxwèxe na wena pemaã nüxü̃ chixuxü̃? ¿Ẽ́xna pema rü ta nüxü̃́ peyaxõgüchaü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Rü yexguma rü guma yatümaã chixexü̃ nixugüe, rü ñanagürügü: —Cumaẽrü nixĩ i nüxü̃́ cuyaxõxü̃ i ngẽma yatü, natürü i toma rü Moĩchéarü oreaxü̃́ nixĩ i tayaxõgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","—Toma rü nüxü̃ tacuèx ga Tupana rü aixcüma Moĩchémaã na yadexaxü̃, natürü ngẽma Ngechuchu rü tama nüxü̃ tacuèx na ngextá na ne naxũxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Rü guma yatü nanangãxü̃, rü ñanagürü nüxü̃: —¿Ñuxãcü nixĩ i ngẽma? Nüma rü marü choxü̃ narümexẽtüxẽẽ, natürü ¿ñuxãcü i pema i tama nüxü̃ pecuáxü̃ na ngextá ne naxũxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","—Rü guxãma i yixema rü meãma nüxü̃ tacuèx rü Tupana tama nüxü̃ naxĩnü i pecaduã̱xgüxü̃ãrü yumüxẽ. Natürü Tupana rü tüxü̃́ nüxü̃ naxĩnü i tümaãrü yumüxẽ ya yíxema nüxü̃ icuèxüü̃güxe rü naxǘxe i Tupanaãrü ngúchaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","—Taguma ñuxgu nüxü̃ taxĩnüchiga i wüxi i yatü na yadauchixẽẽãxü̃ i wüxi i duü̃xü̃ i norü bucüma ngexetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","—Rü ngẽxguma chi tama Tupana núma namu̱xgux ya daa yatü ya choxü̃ rümexẽẽcü, rü taxuacü chima mexü̃ naxü —ñanagürü ga guma yatü ga ngexetüchirécü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Rü yexguma ga yema Yudíugüarü ãẽ̱xgacügü, rü ñanagürügü nüxü̃: —Cuma na pecadugu na cubuxü̃, ¿rü ñuxãcü cunaxwèxe na toxü̃ cungúexẽẽchaü̃xü̃? —ñanagürügü. Rü ñu̱xũchi ínanatèxüchigü ga ngutaquẽ́xepataü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Rü Ngechuchu rü nüxü̃ nacuáchiga ga na ínatèxüchigüãxü̃ ga guma ngexetüchirécü. Rü yexguma nüxü̃ nadèu̱xgu, rü ñanagürü nüxü̃: —¿Nüxü̃́ cuyaxõxü̃ ya Tupana Nane ya duü̃xü̃xü̃ ixĩcü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Rü yexguma ga nüma rü Ngechuchuxü̃ nangãxü̃ rü ñanagürü: —Pa Corix, ¡chomaã nüxü̃ ixu na texe yiĩxü̃ na nüxü̃́ chayaxõxü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Marü nüxü̃ cudau ya Tupana Nane. Rü chomatama nixĩ i cumaã na íchidexaxü̃ chiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Rü yexguma ga guma yatü ga ngexetüchirécü rü Ngechuchupẽ́xegu nacaxã́pü̱xü, rü nüxü̃ nicuèxüü̃, rü ñanagürü nüxü̃: —Ngẽmáãcü cuxü̃́ chayaxõ, Pa Corix —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Rü yexguma ga Ngechuchu rü ñanagürü: —Rü ñoma i naãnewa chaxũ na chayadexechixü̃cèx i chorü duü̃xü̃gü nüxna i ngẽma duü̃xü̃gü i tama choxrü ixĩgüxü̃. Rü nuã chaxũ na chanameẽxẽẽxü̃cèx i ngẽma duü̃xü̃gü i noxri tama Tupanaxü̃ cuèxgüxü̃. Rü ngẽxgumarüü̃ ta núma chaxũ na duü̃xü̃gü i tama choxü̃ cuèxgüchaü̃xü̃xü̃ chanawéxü̃ na duü̃xü̃gü i ngexetüxü̃rüü̃ na yixĩgüxü̃, erü tama choxü̃́ nayaxõgüchaü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Rü ñuxre ga Parichéugü ga yéma Ngechuchumaã yexmagüxü̃, rü yexguma yema orexü̃ naxĩnüẽgu, rü Ngechuchuna nacagü, rü ñanagürügü: —¿Ẽ́xna toma rü ta tama Tupanaxü̃ tacuèxgü ñacuxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Ngẽxguma chi tama aixcüma Tupanaxü̃ pecuèxgügu rü tãũ chima pegagu nixĩ na pepecaduã̱xgüxü̃. Natürü ngẽma na pegü pixuxü̃ na Tupanaxü̃ pecuáxü̃ rü ngẽmacèx pegagutama nixĩ na pepecaduã̱xgüxü̃ i ñu̱xmax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Rü yexguma ga Ngechuchu rü ñanagürü: —Rü aixcüma pemaã nüxü̃ chixu rü ngẽma yatü i tama carnerupǘxü̃ãrü ĩã̱xwa ixücuxü̃ rü wüxi i ngĩ́tèxáxü̃ nixĩ i ngẽma, erü ngextámare nixücu. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","—Natürü ngẽma carnerupǘxü̃ãrü ĩã̱xwa meãma ixücuxü̃, rü ngẽma nixĩ i norü dauruü̃xü̃chi i carnerugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","—Rü ngẽma yatü i carnerupǘxü̃ãrü ĩã̱xna dauxü̃ rü nayawãxna i ĩã̱x na yaxücuxü̃cèx i carnerugüarü dauruü̃. Rü nüma i carnerugü rü nüxü̃ nacuèxgü i naga i ngẽma norü dauruü̃. Rü ngẽma norü dauruü̃ rü wüxichigü i norü carneru rü nae̱gamaã naxcèx naca na ínamuxü̃ãxü̃cèx i naxpǘxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","—Rü ngẽxguma ínamuxü̃ã̱xgu i guxü̃ma i norü carnerugü, rü nüma i norü dauruü̃ rü napẽ́xegu nixũchigü. Rü nümagü i carnerugü rü nawe narüxĩ, erü nüxü̃ nacuèxgü i naga. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","—Natürü ngẽxguma wüxi i yatü i tama aixcüma norü dauruü̃ ixĩxü̃, rü tama nawe narüxĩ i ngẽma carnerugü. Rü nüxna naxĩgü, erü tama nüxü̃ nacuèxgü i naga i ngẽma tama norü dauruü̃ ixĩxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Rü Ngechuchu rü duü̃xü̃gümaã nüxü̃ nixu ga yema ore ga cuèxruü̃, natürü ga nümagü rü tama nüxü̃ nacuèxgüéga ga ṯacüchiga na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Rü yexguma ga Ngechuchu rü wenaxãrü ñanagürü nüxü̃: —Aixcüma pemaã nüxü̃ chixu rü choma nixĩ i carnerupǘxü̃ãrü ĩã̱x i nawa yachocuxü̃xü̃ i carnerugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Guxü̃ma ga yema chopegu nüxira núma ĩxü̃ rü ngĩ́tèèxgüxü̃ rü máẽtagüxü̃ nixĩgü. Natürü yema carnerugü rü tama naga naxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Choma nixĩ i ĩã̱x. Rü texé ya chowa ixücuxe rü tá tamaxü̃. Rü meãma tá tüxü̃ naxüpetü ngẽxgumarüü̃ i wüxi i carneru i naxpǘxü̃gu ücuxü̃ rü íxũxũxü̃xü̃ rü nüxü̃ iyangaucü ya mecü ya maxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ngẽma ngĩ́tèxáxü̃ rü núma naxũ na yangĩ́xü̃cèx rü namáẽtaxü̃cèx rü nachixexẽẽãxü̃cèx. Rü ngẽmacèxicatama núma naxũ. Natürü i choma rü núma chaxũ na chanamaxẽxẽẽxü̃cèx i duü̃xü̃gü rü na aixcüma nüxü̃́ nangẽxmaxü̃cèx i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Choma nixĩ i carneruarü dauruü̃ ya mecü chiĩxü̃. Erü wüxi i carneruarü dauruü̃ ya mecü rü norü carnerugüxü̃ ínapoxü̃ rü ñu̱xmata naxcèx nayu̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Natürü ngẽma dĩẽrucèxmare puracüxü̃, rü ega ngẽxguma aixü̃ nadèu̱xgux rü carnerugüna nge̱ma niña. Rü ngẽmaãcü nanaxü erü tama aixcüma norü dauruü̃ nixĩ i nümax, rü tama noxrü nixĩ i ngẽma carnerugü. Rü ngẽma ai rü carnerugüxü̃ ínayauxü̃ rü ngẽxma tüxü̃ naxüanexẽẽmare. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Rü ngẽma yatü rü niña, erü norü dĩẽrucèxicatama nge̱ma napuracü. Rü tama aixcüma carnerugügu narüxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Choma nixĩ i carnerugüarü dauruü̃ ya mecü chiĩxü̃. Rü ngẽxgumarüü̃ ya Chaunatü na choxü̃ nacuáxü̃ rü choma rü Chaunatüxü̃ na chacuáxü̃, rü ngẽxgumarüü̃ ta nüxü̃ chacuèx i chorü carnerugü, rü nümagü rü choxü̃ nacuèxgü. Rü choma rü naxcèx chayu i chorü carnerugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Rü choxü̃́ nangẽxmagü ta i togü i carnerugü i tama ñaã naxpǘxü̃wa ngẽxmagüxü̃. Rü ngẽmagü rü tá ta nuã chanagagü, rü tá chauga naxĩnüẽ. Rü wüxitücumü tátama nixĩ rü choma tátama nixĩ i norü dauruü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Chaunatü rü choxü̃ nangechaü̃, erü chorü carnerugücèx chayu rü wena táxarü chamaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Taxúema choxü̃ tayuxẽẽ, natürü chomatama chorü ngúchaü̃maãtama ichanaxã i chorü maxü̃. Erü cho̱xmẽ́xwa nangẽxma na ichanaxãxü̃cèx, rü wena na chanayaxuxü̃cèx, yerü yemaãcü choxü̃ namu ga Chaunatü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Rü yexguma yema orexü̃ naxĩnüẽgu ga yema Yudíugüarü ãẽ̱xgacügü rü wenaxãrü nügü nitoye ga yema nagu naxĩnüẽxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Rü muxü̃ma ga nümagü rü ñanagürügü: —¿Tü̱xcüü̃ nüxü̃́ iperüxĩnüẽ i ñaã yatü i ngẽãẽxü̃ i ngoxo nawa ngẽxmaxü̃? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Natürü ga togü rü ñanagürügü: —Taxuü̃ma i yatü i ngoxo nawa ngẽxmaxü̃ rü ñaãrüü̃ meã nidexa. ¿Ñuxãcü i wüxi i yatü i ngoxo nawa ngẽxmaxü̃ rü tüxü̃ narümexẽtüxẽẽ ya wüxi ya ngexetüxe? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Rü nawa nangu ga yema peta ga gucü ga taunecügu norü tupauca ga taxü̃necèx naxügüxü̃ ga Yudíugü na nüxna nacuèxãchigüxü̃cèx ga yema ngunexü̃ ga nagu yanguxü̃ ga guma tupauca. Rü nagáuane ga Yerucharéü̃wa ga yexguma. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Rü guma tupauca ga taxü̃newa nayexma ga wüxi ga chopetüchica ga Charumóũãrü Chopetüchicagu ãe̱gaxü̃. Rü yemagu nayarüxũũxü̃ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Rü ga yema Yudíugüarü ãẽ̱xgacügü rü nüxü̃ ínachomaẽguãchi, rü ñanagürügü nüxü̃: —¿Ñuxguratáta tomaã quixaixcüma na cugü quixuxü̃ na texé na quiĩxü̃? Ega aixcüma cuma rü Cristu quixĩgu, rü ¡meã noxtacüma tomaã nüxü̃ ixu! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Marü pemaã nüxü̃ chixu, natürü i pema rü tama choxü̃́ peyaxõgü. Guxü̃ma i ṯacü i chaxüxü̃ rü Chaunatüarü poramaã nixĩ i chanaxüxü̃, rü ngẽmawa meãma pexü̃ nüxü̃ chadauxẽẽ na choma rü Cristu na chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","—Natürü pema rü tama peyaxõgü, erü tama chorü carnerugütanüxü̃ pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","—Chorü carnerugü rü nüxü̃ nacuèx i chauga, rü choma rü chorü carnerugüxü̃ chacuèx, rü nüma rü chowe narüxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","—Rü choma rü nüxna chanaxã i maxü̃ i taguma gúxü̃. Rü nümagü rü tagutáma inayarütauxe, rü taxúetáma choxna tanapuxü̃ i cho̱xmẽ́xwa. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","—Rü yíxema Chaunatü choxna tüxü̃ mugüxe ya chorü carnerugü, rü guxü̃ãrü yexera tixĩ i napẽ́xewa. Rü taxúema texé nüxna tüxü̃ tapuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","—Chaunatü rü choma rü wüxitama tixĩgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Rü yexguma ga yema Yudíugüarü ãẽ̱xgacügü rü wenaxãrü nutane nanayauxgü na gumamaã Ngechuchuxü̃ ínamuxũchigüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Natürü ga Ngechuchu rü ñanagürü nüxü̃: —Pepẽ́xewa chanaxü i muxü̃ma i mexü̃gü i Chaunatüarü poramaã chaxüxü̃. ¿Rü ngẽxü̃rüüxü̃ i ngẽma mexü̃ i chaxüxü̃cèx nixĩ i choxü̃ nutamaã ípemuxũchigüchaü̃xü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Rü yema Yudíugüarü ãẽ̱xgacügü rü Ngechuchuxü̃ nangãxü̃gü, rü ñanagürügü: —Tama wüxi i puracü i mexü̃cèx cuxü̃ ítamuxũchigüchaü̃. Natürü cuxü̃ ítamuxũchigüchaü̃ erü Tupanamaã rü ṯacü quixugü. Cuma rü wüxi i duü̃xü̃mare quixĩ rü cugü Tupanaxü̃ quixĩxẽẽchaü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Rü nüma ga Ngechuchu rü ñanagürü nüxü̃: —Perü mugüpanewa rü naxümatü i Tupanaãrü ore i ñaxü̃: “Rü pematama nixĩ i tupanagü pixĩgüxü̃”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","—Rü ngẽma Tupanaãrü ore i ümatüxü̃wa nüxü̃ yaxuxü̃, rü nüxü̃ tacuèx rü taxucürüwama texé itayanaxoxẽẽ. Rü ngẽma orewa rü Tupana rü ñanagürü: “Guxãma ya yíxema texé yanayauxgüxe i chorü ore rü tupanagü tixĩgü”, ñanagürü i ngẽma orewa. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","—Rü Tupana choxü̃ nayaxu na chanaxüxü̃cèx i norü puracü, rü yemacèx ñoma ga naãnewa choxü̃ namu. ¿Rü ñuxãcü i pema nagu perüxĩnüẽgu rü chixexü̃ Tupanamaã chaxüxü̃ i ngẽxguma Tupana Nane chixĩ —ñachagu pemaã? ");
INSERT INTO tcaNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","—Rü ngẽxguma chi tama chanaxü̱xgu i ngẽma mexü̃ i Chaunatü üxü̃, rü marü name ega woo tama choxü̃́ peyaxõgügu. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","—Natürü ngẽxguma chanaxü̱xgu i ngẽma Chaunatü üxü̃, rü woo tama choxü̃́ peyaxõgügu, rü chanaxwèxe i nüxü̃́ peyaxõgü i ngẽma taxü̃ i mexü̃gü i Chaunatüarü poramaã chaxüxü̃. Erü ngẽmawa tá nüxü̃ pecuèx na Chaunatü rü chowa nangẽxmaxü̃ rü choma i nawa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Rü wenaxãrü Ngechuchuxü̃ niyauxgüchaü̃ ga yema Yudíugüarü ãẽ̱xgacügü. Natürü nüma ga Ngechuchu rü naxchaxwa niña. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Rü yexguma ga Ngechuchu rü natü ga Yudáü̃ãrü tocutücèx tomaã nataegu. Rü yema nachica ga Cuáü̃ duü̃xü̃güxü̃ ü̃paacü nawa íbaiü̃xẽẽxü̃gu tomaã narüxã̱ũ̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Rü muxü̃ma ga duü̃xü̃gü rü Ngechuchuxü̃ ínayadaugü, rü ñanagürügü: —Cuáü̃ rü taxuü̃ma ga taxü̃ ga mexü̃ ga cuèxruü̃ naxü ga Tupanaãrü poramaã. Natürü guxü̃ma ga ore ga Cuáü̃ tamaã nüxü̃ ixuxü̃ ga ñaã yatüchiga rü aixcüma nixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Rü yema nachicawa rü muxü̃ma ga duü̃xü̃gü rü Ngechuchuaxü̃́ nayaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Nayexma ga wüxi ga yatü ga iḏaawecü ga Dácharugu ãe̱gacü. Rü nüma rü naẽyèxgü ga María rü Marta rü ĩãne ga Betániãcü̱̃ã̱x nixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Rü yema María iyixĩ ga Cori ga Ngechuchucutügu pumara bacü rü ñu̱xũchi ngĩyaemaã ínapicutücü. Rü guma Dácharu ga iḏaawecü nixĩ ga ngĩẽneẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Rü poraãcü niḏaawe ga Dácharu. Rü yemacèx ga naẽyèxgü, rü Ngechuchuxü̃tawa imugagü, rü ngĩgürügügü: “Pa Corix, cumücü ya Dácharu ya nüxü̃ cungechaü̃cü rü niḏaawe”, ngĩgürügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Rü yexguma yema orexü̃ naxĩnügu ga Ngechuchu, rü ñanagürü: —Ngẽma ḏaawe rü tãũtáma yumaã inayacuèx. Natürü niḏaawe na duü̃xü̃gü nüxü̃ nadaugüxü̃cèx na ñuxãcü naporaxü̃ ya Tupana rü ñuxãcü choma i Nane rü ta na chaporaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Rü Ngechuchu poraãcü María rü Marta rü Dácharuxü̃ nangechaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Natürü yexguma nüxü̃ naxĩnügu ga na yaḏaawexü̃ ga Dácharu, rü tama paxa ínayadau. Rü taxre ga ngunexü̃ãmatama yexma narüxã̱ũ̱x ga yema nachica ga nawa nayexmaxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Rü yixcama ga yemawena rü toxü̃ ñanagürü: —¡Ngĩxã rü wena Yudéaanewa taxĩ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Rü toma ga norü ngúexü̃gü rü ñatarügügü nüxü̃: —Pa Ngúexẽẽruü̃x, yexwacatama nixĩ ga yémacü̱̃ã̱x ga Yudíugüarü ãẽ̱xgacügü yexma nutamaã cuxü̃ ímuxũchigüchaü̃xü̃. ¿Rü tü̱xcüü̃ wena nge̱ma cuxũxchaü̃ i ñu̱xmax? —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Rü Ngechuchu rü tomaã nüxü̃ nixu ga wüxi ga ore na nüxü̃ tacuèxgüxü̃cèx na tauta nawa nanguxü̃ na nayuxü̃ ga nümax. Rü ñanagürü toxü̃: —¿Taux ẽ́xna i wüxi i ngunexü̃ rü 12 i ora nawa ngẽxmaxü̃? Ngẽxguma texé ngunecü ixũxgu rü tama ṯacümaã itayarüña, erü tümacèx nangóone. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","—Natürü ngẽxguma wüxie chütacü ixũxgu rü ngẽmáãcü ṯacümaã itayarüña, erü tümacèx naxẽãne —ñanagürü. Rü yemaãcü nanango̱xẽẽ na tauta nawa nanguxü̃ na nayuxü̃ ga nümax. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Rü yemawena ga Ngechuchu rü ñanagürü toxü̃: —Tamücü ya Dácharu rü napemare. Natürü ñu̱xma rü tá chayaḇaixãchixẽẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Rü yexguma ga toma ga norü ngúexü̃gü rü ñatarügügü: —Pa Corix, ega napemaregu, rü ngẽmawa nüxü̃ tacuèx na naxcèx tá yataanexü̃ —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Natürü ga Ngechuchu rü nüxü̃ nixuxchaü̃chirẽ́x ga Dácharu ga marü na nayuxü̃. Natürü ga toma nüxü̃ tacuèxgügu rü na napemarexü̃chigaxü̃ yiĩxü̃ ga tomaã yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Rü yexguma ga Ngechuchu rü meãma tomaã nüxü̃ nixu rü ñanagürü: —Dácharu rü marü nayu. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","—Natürü choma rü chataãẽ na tama nge̱ma changẽxmaxü̃, erü ngẽmaãcü nixĩ i namemaẽxü̃ i pexcèx na choxü̃́ peyaxõgüxü̃cèx. ¡Rü ngĩxã rü ítayadaugü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Rü yéma nayexma ga totanüxü̃ ga Tumachi ga Wüxigu Buexü̃ ga Taxreẽ́xpǘxü̃maã, naxugüxü̃. Rü nüma ga Tumachi rü ñanagürü toxü̃: —¡Ngĩxã i yixema rü ta nge̱ma taxĩ na wüxigu Ngechuchumaã iyuexü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Rü yexguma Betániãwa tomaã nanguxgu ga Ngechuchu, rü marü ãgümücü ga ngunexü̃ nangupetü ga na iyatèxgüãxü̃ ga Dácharu. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Rü guma Betániã rü Yerucharéü̃ãrü ngaicamana nayexma. Rü tomaẽ̱xpü̱x ga kilómetru nixĩ ga norü yaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Rü muxü̃ma ga Yudíugü rü Dácharueyèx ga Marta rü Maríaxü̃tawa naxĩ na ngĩxü̃ yataãẽxẽẽgüxü̃cèx, yerü nayu ga ngĩẽneẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Rü yexguma Marta nüxü̃ cuèxgu ga marü na ínanguxü̃ ga Ngechuchu, rü nüxü̃ iyatüxãchi. Natürü ga María rü ĩxgutama irüxã̱ũ̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Rü Marta rü ngĩgürügü nüxü̃ ga Ngechuchu: —Pa Corix, yexguma chi cuma cunumèxgu rü tãũ chima nayu ga chaueneẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","—Natürü choma nüxü̃ chacuèx na woo i ñu̱xma na nayuxü̃, rü Tupana tá cuxna nanaxã i guxü̃ma i ṯacü i naxcèx ícuc̱axü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Rü Ngechuchu ngĩxü̃ nangãxü̃ rü ñanagürü: —Cueneẽ rü wena tá namaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Rü Marta ngĩgürügü nüxü̃: —Ngẽmáãcü nüxü̃ chacuèx rü wena tá namaxü̃ i ngẽxguma nagu̱xgu i naãne rü ngẽxguma wena namaxẽgu i guxü̃ma i yuexü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Rü yexguma ga Ngechuchu rü ñanagürü: —Choma nixĩ i íchanadagüxẽẽxü̃ i yuexü̃gü, rü wena chanamaxẽxẽẽxü̃. Rü yíxema choxü̃́ yaxṍxẽ rü woo tayu̱xgu rü tá wenaxãrü tamaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","—Rü guxãma ya texé ya maxü̃́xẽ rü choxü̃́ yaxṍxẽ, rü guxü̃gutáma tamaxü̃. ¿Cuyaxõxü̃ yĩĩxü̃ i ngẽma? —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Rü ngĩma rü ngĩgürügü nüxü̃: —Ngü̃, Pa Corix, choma rü chayaxõ na cuma rü Tupana Nane ya Cristu ga ítananguxẽẽcü na quiĩxü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Rü yema ñaxguwena rü Marta rü ngĩẽyèx ga Maríacè x iyaca. Rü bexma ngĩmaã nüxü̃ iyarüxu, rü ngĩgürügü: —Marü nuã nangu ya Ngúexẽẽruü̃ ya Ngechuchu, rü choxü̃ cuxcèx nayacaxẽẽ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Rü yexguma María nüxü̃ ĩnügu ga marü yéma na nanguxü̃ ga Ngechuchu, rü paxa ichi, rü Ngechuchuxü̃ íiyadau. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Rü Ngechuchu rü tauta ĩãnewa nangu ga yexguma, rü yema nachica ga Marta nüxü̃ ídauxü̃watama nixĩ ga nayexmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Rü Maríapatawa nayexma ga ñuxre ga yémacü̱̃ã̱x ga Yudíugüarü ãẽ̱xgacügü ga ngĩxü̃ yéma taãẽxẽẽgüxü̃. Rü yexguma ngĩxü̃ nadaugügu ga paxa na inachixü̃ rü na ínaxũxũxü̃, rü ngĩwe narüxĩ. Yerü nüma nüxü̃ nacuèxgügu rü yéma Dácharu itáxü̃wa ixũ na yéma yaxaxuxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Rü yexguma Ngechuchuxü̃tawa nanguxgu ga María, rü napẽ́xegu iyacaxã́pü̱xü, rü ngĩgürügü: —Pa Corix, yexguma chi cuma cunumèxgu rü tãũ chima nayu ga chaueneẽ ya Dácharu —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Rü yexguma Ngechuchu ngĩxü̃ dèu̱xgu ga na naxaxuxü̃ rü na naxauxexü̃ ga yema Yudíugüarü ãẽ̱xgacügü ga ngĩwe rüxĩxü̃, rü poraãcü ngechaü̃ nüxü̃́ nangu̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Rü Ngechuchu nüxna naca rü ñanagürü: —¿Ngexta nixĩ i ipenatáxü̃? —ñanagürü. Rü nümagü nanangãxü̃ rü ñanagürügü: —Pa Corix, ¡dücax, nuã naxũ, rü íyadau! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Rü naxaxu ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Rü yema Yudíugü rü ñanagürügü: —¡Dücèx ñuxãcü poraãcü Dácharuxü̃ nangechaü̃! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Natürü ñuxre ga yema ãẽ̱xgacügü ga Yudíugüarü rü ñanagürügü: —Daa nixĩ ga guma yatü ga ngexetücüxü̃ rümexẽẽcü. ¿Rü tü̱xcüü̃ taxucürüwa ṯacü rü mexü̃ Dácharucèx naxü na tama nayuxü̃cèx? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Rü Ngechuchu poraãcü ngechaü̃ nüxü̃́ nangu̱x rü Dácharumaxü̃cèx nixũ. Rü wüxi ga mèxpǘneãrü ãxmaxü̃ nixĩ ga yema naxmaxü̃. Rü nayexma ga wüxi ga nuta ga norü ngũxtaü̃ruü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Rü Ngechuchu rü ñanagürü: —¡Ípenangũxgachi̱x ya yima nuta ya namaã nangũxtaü̃cü! —ñanagürü. Natürü ga Marta ga Dácharueyèx rü ngĩgürügü: —Pa Corix, cuxá marü nayixane nixĩ, erü marü ãgümücü i ngunexü̃ nae̱tü nixĩ ga na nayuxü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Natürü ga Ngechuchu rü ñanagürü ngĩxü̃: ¿Taux ẽ́xna i marü cumaã nüxü̃ chixuchiréxü̃ rü ngẽxguma cuyaxõ̱xgu rü tá nüxü̃ cudau i wüxi i mexü̃ i taxü̃ i Tupana üxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Rü yexguma ínanangũxgachigü ga guma nuta. Rü Ngechuchu daxũgu nadawenüãcüma ñanagürü: —Pa Chaunatü Pa Tupanax, moxẽ cuxna chaxã erü marü choxü̃ cuxĩnü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","—Choma nüxü̃ chacuèx rü guxü̃guma choxü̃ cuxĩnü. Natürü moxẽ cuxna chaxã i ñu̱xma erü chanaxwèxe i ñaã duü̃xü̃gü na yaxõgüãxü̃ na cuma núma choxü̃ cumuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Rü yexguma yema ñaxguwena, rü tagaãcü ñanagürü: —Pa Dácharux, ¡ínaxũxü̃ i nge̱ma! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Rü ínaxũxü̃ ga Dácharu ga naxchápenüü̃maã guxü̃wama rübuxpüxü̃cü. Rü Ngechuchu ñanagürü nüxü̃ ga duü̃xü̃gü: —¡Ípeyawẽxpüxü̃ na íyaxũxü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Rü yema Yudíugüarü ãẽ̱xgacügü ga Maríawe rüxĩxü̃ rü nüxü̃ nadaugü ga yema Ngechuchu üxü̃, rü muxü̃ma Ngechuchuaxü̃́ nayaxõgü ga yexguma nüxü̃ nadaugügu ga ñuxãcü wena Dácharuxü̃ na namaxẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Natürü ñuxre ga yema ãẽ̱xgacügü rü Parichéugümaã nüxü̃ nayarüxugü ga yema Ngechuchu üxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Rü yexguma ga yema Parichéugü rü paigüarü ãẽ̱xgacügü rü nangutaquẽ́xegü namaã ga guxü̃ma ga yema ãẽ̱xgacügütücumüwa ügüxü̃. Rü ñanagürügü: —¿Ṯacü tá taxüe? Erü ñaã yatü i Ngechuchu rü nanaxü i muxü̃ma i mexü̃ i cuèxruü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","—Ngẽxguma chi tama yayauxgügu, rü guxü̃táma i duü̃xü̃gü rü tá nüxü̃́ nayaxõgü, rü Dumacü̱̃ã̱xgüarü churaragü rü núma chi naxĩ rü nagu napogüe ya tórü tupauca ya taxü̃ne, rü düxwa tãũ chima tóxrü nixĩ i ñaã tachiü̃ãne —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Natürü guma taunecügu rü yema paigütanüwa rü Caipá nixĩ ga norü ãẽ̱xgacü. Rü nüma rü ñanagürü nüxü̃: —Pemagü rü taxuü̃ma pecuèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","—¿Ẽ́xna tama nüxü̃ pecuèx rü taxcèx rü na namemaẽxü̃ na wüxitama i yatü guxü̃ i duü̃xü̃gücèx na yuxü̃, na tama nayuexü̃cèx i guxü̃ma i tachiü̃ãnecü̱̃ã̱x i duü̃xü̃gü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Natürü ga Caipá rü tama nüẽchama yema ñanagürü, yerü guma taunecügu rü nüma nixĩ ga paigüarü ãẽ̱xgacü yiĩxü̃. Rü yemacèx rü Tupana nixĩ ga Caipáwa idexacü ga yexguma nüxü̃ yaxuxgu na Ngechuchu rü guxü̃ma i Yudíugücèx tá na nayuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Rü yema orewa rü nanango̱xẽẽ na tama Yudíugücèxicatama tá na nayuxü̃, natürü guxü̃ma i Tupanaãrü duü̃xü̃gü i guxü̃ i naãnewa ngẽxmagüxü̃cèx rü tá ta na nayuxü̃, na ngẽmaãcü wüxigu nangutaquẽ́xexü̃cèx i guxü̃ma i ngẽma duü̃xü̃gü i Tupanaãrü ixĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Rü yexgumaü̃cüü nixĩ ga inaxügüeãxü̃ ga Yudíugüarü ãẽ̱xgacügü ga nagu na naxĩnüẽxü̃ ga ñuxãcü tá na Ngechuchuxü̃ yamèxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rü yemacèx ga Ngechuchu rü marü tama yema Yudíugü ímuxü̃tanügu naxã. Rü tomaã ínaxũxũ ga Yudéaanewa, rü wüxi ga ĩãnexãcü ga Efraĩ́gu ãe̱ganewa naxũ. Rü yexma tomaã narüxã̱ũ̱x. Rü guma ĩãne rü wüxi ga nachica ga ngextá taxúema íxãpataxü̃ãrü ngaicamana nayexma. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Rü marü ningaica ga yema Yudíugüarü peta ga Üpetüchiga. Rü yemacèx muxü̃ma ga duü̃xü̃gü ga náĩ ga ĩãnecü̱̃ã̱x rü Yerucharéü̃wa naxĩ na Tupanacèx nügü yamexẽẽgüxü̃cèx naxü̃pa ga yema peta. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Rü Ngechuchucèx nadaugü ga duü̃xü̃gü. Rü tupauca ga taxü̃newa nügüna nicagüetanü, rü ñanagürügü: —¿Ñuxũ ñapegüxü̃ i pemax? ¿Ñoma i petawa tá naxũxü̃ rü ẽ́xna tama? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Rü yema Parichéugü rü paigüarü ãẽ̱xgacügü rü duü̃xü̃güna naxãgagü, rü ñanagürügü: —Ngẽxguma ngextá nüxü̃ pedaugügu i ngẽma Ngechuchu, ¡rü tomaã nüxü̃ peyarüxu na tayayauxgüxü̃cèx! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Rü 6 ga ngunexü̃ naxü̃pa ga Üpetüchigaarü peta, rü Ngechuchu rü tomaã Betániãwa naxũ. Rü guma ĩãne nixĩ ga nagu naxãchixü̃ne ga Dácharu ga Ngechuchu wena namaxẽẽcü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Rü yéma Dácharuchixü̃wa Ngechuchucèx nanaxügü ga taxü̃ ga õna. Rü totanüwa ga yema mechawa yexmagüxe rü Dácharu nixĩ ga Ngechuchuxü̃tawaama chibücü. Rü Marta iyixĩ ga inaxücü ga õna. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Rü yexguma ga María rü yéma inange ga wüxi ga taxüraweü̃xü̃ ga pumara ga yixichixü̃ rü tatanüxü̃chixü̃. Rü Ngechuchuxü̃ namaã iyixcutü. Rü ñu̱xũchi ngĩyaemaã íinapicutü. Rü guma ĩ rü guxü̃wama nayixmachĩã namaã ga yema pumara. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Rü yexguma ga Yuda ga Icariúte ga wüxi ga totanüxü̃chirẽ́x ixĩxü̃ ga yixcama bexma cúãcü Ngechuchuxü̃ íxuaxü̃xü̃, rü ñanagürü: —¿Tü̱xcüü̃ tama tatanüxü̃gu namaã itaxe i ngẽma pumara na ngẽma dĩẽrumaã nüxü̃ nangü̃xẽẽxü̃cèx i ngẽma duü̃xü̃gü i ngearü dĩẽruã̱xgüxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Natürü ga Yuda rü tama aixcüma nagu narüxĩnü ga yema ngearü dĩẽruã̱xgüxü̃. Natürü yema ñanagürü yerü nüma rü wüxi ga ngĩ́tèxáxü̃ nixĩ. Rü naxmẽ́xwa nayexma ga yema choca ga dĩẽru ngĩxü̃ nagu taxügüxü̃ ga guxãma ga toma ga Ngechuchuarü ngúexü̃gü. Rü Yuda rü ñuxguacü rü noxrüxü̃tama ngĩxne nangĩ̱xĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —¡Tãxṹ i ngĩxü̃ cuchixewexü̃! Erü choma rü paxa tá chayu rü tá ichatèx. Rü ngẽmacèx nixĩ i ngẽma pumaramaã choxü̃ nachaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","—Ngẽma ngearü dĩẽruã̱xgüxü̃ rü guxü̃gutáma petanüwa nangẽxmagü. Natürü i choma rü tãũtáma guxü̃gu petanüwa changẽxma —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Rü muxü̃ma ga Yudíugü rü nüxü̃ nacuáchiga ga Betániãwa na nayexmaxü̃ ga Ngechuchu. Rü yéma naxĩ na nüxü̃ nadaugüxü̃cèx. Rü tama Ngechuchuxü̃xĩcatama nadaugüchaü̃ natürü nüxü̃ nadaugüchaü̃ ta ga Dácharu ga Ngechuchu wena namaxẽẽcü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Rü yexguma ga paigüarü ãẽ̱xgacügü rü nügümaã nanamexẽẽgü ga Dácharuxü̃ rü ta na yamèxgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Yerü Dácharugagu nixĩ ga muxü̃ma ga Yudíugü ga Ngechuchuaxü̃́ yaxõgüãxü̃ rü yema paigüna naxĩgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Rü muxü̃ma ga duü̃xü̃gü rü Yerucharéü̃wa naxĩ naxcèx ga Üpetüchigaarü peta. Rü moxü̃ãcü duü̃xü̃gü nüxü̃ nacuáchigagü ga Ngechuchu rü guma ĩãnewa na nanguxchaü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Rü yexguma moruátüta nadaü̃gü rü yemamaã Ngechuchuxü̃ nayatüxgütanüãchi. Rü tagaãcü ñanagürügü: —¡Rü naxüüne rü namecümaxüchi ya daa Tupanaégagu núma ũcü! ¡Rü yixema na Iraétanüxü̃ ixĩgüxü̃ rü namecümaxüchi ya daa tórü ãẽ́xgacü! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Rü Ngechuchu nüxü̃ inayangau ga wüxi ga buru, rü nae̱tügu naxaunagü ga yema Tupanaãrü ore ga ümatüxü̃ nüxü̃ ixuxü̃rüü̃ ga yexguma ñaxgu: ");
INSERT INTO tcaNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“¡Tãxṹ i pemuü̃ẽxü̃, Pa Yerucharéü̃cü̱̃ã̱xgüx! ¡Rü iperüdaunü na nge̱ma ne naxũxü̃ ya perü ãẽ̱xgacü ya wüxi i buru i íraxü̃e̱tügu aunagücü!” ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Rü noxri ga toma ga norü ngúexü̃gü rü tama nüxü̃ tacuèxgüéga ga Ngechuchuchiga na yiĩxü̃ ga yema ore. Natürü yixcüra marü Ngechuchu Tupanaxü̃tawa ũxgu, rü yexguma nixĩ ga nüxna tacuèxãchiexü̃ ga guxü̃ma ga yema Ngechuchuxü̃ ngupetüxü̃, rü yema Tupanaãrü ore nüxü̃ ixuxü̃ãcütama nüxü̃ na nangupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Rü yema duü̃xü̃gü ga Ngechuchuxü̃tawa yexmagüxü̃ ga yexguma Dácharuxü̃ wena namaxẽẽgu, rü nüxü̃ nixugüe ga yema nüxü̃ nadaugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Rü yemacèx nixĩ ga duü̃xü̃gü ga Ngechuchuxü̃ yatüxãchitanüxü̃ na nayauxgüãxü̃cèx, yerü nüxü̃ nacuáchigagü ga yema taxü̃ ga mexü̃ ga Tupanaãrü poramaã naxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Natürü ga yema Parichéugü rü nügümaã ñanagürügü: —Marü nüxü̃ pedauxü̃ i ñu̱xma na taxucürüwama ṯacü namaã ixüxü̃. ¡Rü dücax, guxü̃ma i duü̃xü̃gü rü nawe narüxĩ! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Rü muxü̃ma ga duü̃xü̃gü rü petacèx Yerucharéü̃wa naxĩ na yéma Tupanaxü̃ na yanacuèxüü̃güxü̃cèx. Rü yema duü̃xü̃gütanüwa nayexma ga ñuxre ga Griégugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Rü yema Griégugü rü Piripicèx naxĩ. Rü nüma ga Piripi rü Gariréaaneãrü ĩãne ga Bechaídacü̱̃ã̱x nixĩ. Rü nüxü̃ nacèèxü̃gü rü ñanagürügü: —Pa Corix, nüxü̃ tadauxchaü̃ ya Ngechuchu —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Rü Piripi rü Aü̃drémaã nüxü̃ nayarüxu. Rü yema taxre rü wüxigu Ngechuchuxü̃tawa naxĩ, rü namaã nüxü̃ nayarüxugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Rü marü nawa nangu tá na chayuxü̃ rü wenaxãrü Chaunatüxü̃tawa tá na chaxũxü̃ i choma i Tupana Nane i duü̃xü̃xü̃ chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","—Rü aixcüma pemaã nüxü̃ chixu rü ngẽxguma chi wüxipü̱xü i trigu tama waixü̃müãnegu toxgu rü wüxipü̱xüechatama nixĩ. Natürü ega waixü̃mügu natoxgu, rü nge̱ma naxüxgu, rü muxũchinema ínanguxuchi. Rü ngẽxgumarüü̃ tá ta Tupanaxü̃tawa nangugü i muxü̃ma i duü̃xü̃gü ega chayu̱xgux. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","—Rü pemaã nüxü̃ chixu rü texé ya yíxema tümaãrü maxü̃xü̃ ngechaü̃xẽ i ñoma i naãnewa rü tá itayarütaxu. Natürü texé ya yíxema tama tümaãrü maxü̃xü̃ ngechaü̃xẽ rü tama yuxü̃ muü̃xẽ i ñoma i naãnewa, rü tá tüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","—Rü ngẽxguma texé choxü̃́ puracüchaü̃gu rü name nixĩ i chowe tarüxũ. Rü ngẽma choma tá íchangẽxmaxü̃wa rü nge̱ma rü tá ta tangẽxma i tümax. Rü ngẽxguma texé choxü̃́ puracügu rü Chaunatü ya Tupana rü tá tümamaã nataãẽ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Rü Ngechuchu ñanagürü: —Rü ñu̱xma rü poraãcü changechaü̃ rü chanaxi̱xãchiãẽ. ¿Rü ṯacüxü̃ tá Chaunatümaã chixuxü̃? Taxucürüwa namaã nüxü̃ chixu na choxü̃ ínanguxuchixẽẽxü̃cèx na tama chayuxü̃cèx, erü woetama ngẽmacèx núma chaxũ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Rü ñanagürü: —Pa Chaunatüx, ¡Choxü̃ rüngü̃xẽẽ na duü̃xü̃güpẽ́xewa cuxü̃ chataxẽẽxü̃cèx! —ñanagürü. Rü yexguma ga yema duü̃xü̃gü ga yéma yexmagüxü̃ rü nüxü̃ naxĩnüẽ ga wüxi ga naga ga daxũwa inaxũxü̃ ga ñaxü̃: —Marü cuxü̃ charüngü̃xẽẽ na choxü̃ cutaxẽẽxü̃ ga noxrix, rü wena táxarü cuxü̃ charüngü̃xẽẽ na choxü̃ cutaxẽẽxü̃cèx —ñanagürü ga yema naga. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Rü yema duü̃xü̃gü ga yéma yexmagüxü̃ ga nüxü̃ ĩnüẽxü̃ ga yema naga, rü ñanagürügü: —Wüxi i duruanexü̃ nixĩ —ñanagürügü. Natürü togü rü ñanagürügü: —Wüxi i Tupanaãrü orearü ngeruü̃ i daxũcü̱̃ã̱x nixĩ i namaã idexaxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Tama chauxcèx nixĩ i nüxü̃ pexĩnüẽxü̃ i ngẽma naga. Rü pexcèxtama nixĩ i nüxü̃ pexĩnüẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","—Rü ñu̱xma tá nixĩ i Tupana inaxügüãxü̃ na tüxü̃ napoxcuexü̃ ya duü̃xẽ naxcèx i tümaãrü pecadugü. Rü ñu̱xma tá nixĩ i Tupana ínatèxüchixü̃ i ngẽma ñoma i naãnewa poraxü̃ i Chataná. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","—Rü ngẽxguma curuchawa chipotagu rü chaugüxü̃tawa tá chanagagü i guxü̃ma i duü̃xü̃gü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rü yema orewa duü̃xü̃gümaã nüxü̃ nixu ga ñuxãcü tá na nayuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Rü yema duü̃xü̃gü nanangãxü̃gü, rü ñanagürügü: —Torü mugü i ümatüxü̃wa nüxü̃ tadaugü na guxü̃gutáma namaxẽchaxü̃ ya Cristu. ¿Rü ñuxãcü i cuma rü ñacurügü: “Rü Tupana Nane ya duü̃xü̃xü̃ ixĩcü rü curuchawa tá nipota”, ñacurügü? ¿Rü texé tixĩ ya yíxema Tupana Nane ya duü̃xü̃xü̃ ixĩxẽ? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Ñoma rü ta petanüwa changẽxma na ñoma i naãnewa pexü̃ changúexẽẽxü̃cèx rü ngẽmaãcü pexü̃ changóonetanüxẽẽxü̃cèx. Natürü paxaãchicèxicatama petanüwa changẽxma. Rü name nixĩ i paxa choxü̃́ peyaxõgü ñoma rü ta pexcèx chanangóonexẽẽ naxü̃pa na naxẽãnexü̃. Erü yíxema ẽãnexü̃wa ngẽxmaxẽ rü tama nüxü̃ tacuèx na ngextá taxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","—Rü ñoma rü ta petanüwa changẽxma rü name nixĩ i paxa choxü̃́ peyaxõgü na chorü ngóonexü̃wa pengẽxmagüxü̃cèx —ñanagürü. Rü yema ñaxguwena rü natanüwa ínaxũxü̃ ga Ngechuchu. Rü naxchaxwa inicu̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Rü woo ga Ngechuchu rü duü̃xü̃güpẽ́xewa nanaxü ga muxü̃ma ga taxü̃ ga mexü̃ ga cuèxruü̃gü ga Tupanaãrü poramaã naxüxü̃, natürü yexguma rü ta tama nüxü̃́ nayaxõgü ga duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Rü yemaãcü Tupana nayanguxẽẽ ga yema ore ga Ichaxía ümatüxü̃ ga ñaxü̃: “Pa Corix, taxúema tayaxõ ga yema ore ga tüxü̃ tangúexẽẽxü̃. Rü woo nüxü̃ tadaugü na ñuxãcü naporaxü̃ ya Tupana, rü tama tayaxõgü”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","40","Rü yemaãcü ga yema duü̃xü̃gü rü tama nayaxõgü yema Ichaxía ümatüxü̃wa nüxü̃ yaxuxü̃rüü̃, rü: “Yema duü̃xü̃gü rü tama nüxü̃ nadaugüchaü̃ rü tama nayaxõgüchaü̃ rü tama Tupanacèx nawoeguchaü̃. Rü yemacèx ga Tupana rü nüxna nixũ na tama nüxü̃ nadaugüxü̃cèx rü tama yaxõgüãxü̃cèx rü tama naxcèx nawoeguxü̃cèx na nüma nüxna naxããxü̃cèx i maxü̃ i ngexwacaxü̃xü̃”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Rü yema ñanagürü ga Ichaxía yerü nango̱xetügu marü nüxü̃ nadau na ñuxãcü ãẽ̱xgacü ya tacüxüchi na yiĩxü̃ ya Ngechuchu ya Cristu. Rü yemaãcü nachiga nidexa. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Natürü muxü̃ma ga yema Yudíugüarü ãẽ̱xgacügü rü Ngechuchuaxü̃́ nayaxõgü, rü woo ga ñuxre ga naẽrugü rü ta nayaxõgü, natürü tama nügü nixugüchaü̃ ga duü̃xü̃güpẽ́xewa, yerü namuü̃ẽ na Parichéugü ngutaquẽ́xepataü̃wa ínawoxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rü yemaãcü tama nügü nixugüchaü̃, yerü norü me nixĩ ga duü̃xü̃gü namaã nataãẽgüxü̃ rü tama aixcüma naxcèx nadaugü na Tupana namaã taãẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Rü tagaãcü ñanagürü ga Ngechuchu: —Texé ya choxü̃́ yaxṍxẽ rü tama choxü̃́xĩcatama tayaxõ. Natürü Chaunatü ya núma choxü̃ mucüaxü̃́ rü ta tayaxõ. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","—Rü texé ya choxü̃ dauxe, rü Chaunatü ya núma choxü̃ mucüxü̃ rü ta tadau. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","—Choma na ngóonexẽẽruü̃ chiĩxü̃, rü ñoma i naãnewa changu na guxãma ya texé ya choxü̃́ yaxṍxẽ rü tama ẽãnexü̃wa na tangẽxmagüechaxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","—Natürü ngẽxguma texé nüxü̃ ĩnügu i chorü ore rü tama tayaxõ̱xgu rü tama choma nixĩ i tüxü̃ chapoxcuxü̃. Erü tama ñoma i naãnewa changu na chanapoxcuexü̃cèx i duü̃xü̃gü, natürü núma chaxũ na chanamaxẽxẽẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","—Yíxema texé ya tama choxü̃́ yaxṍxẽ rü tama chauga ĩnüxẽ rü marü tüxü̃́ nangẽxma na ṯacücèx tá Tupana tüxü̃ poxcuxü̃. Erü ngẽma ore i nüxü̃ chixuxü̃gagu tátama nixĩ ya Tupana i tüxü̃ napoxcuxü̃ i naãneãrü gu̱xgu, erü tama tayaxõ i ngẽma ore i nüxü̃ chixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","—Tama chaugagutama chidexa, natürü guma Chaunatü ga núma choxü̃ mucü, rü guma nixĩ ga chomaã nüxü̃ ixucü na ṯacüxü̃ tá duü̃xü̃gümaã chixuxü̃ rü ñuxãcü tá chanangúexẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","—Rü nüxü̃ chacuèx na Chaunatüarü orewa nangẽxmaxü̃ i maxü̃ i taguma gúxü̃. Rü ngẽmacèx i ngẽma ore i nüxü̃ chixuxü̃, rü ngẽmatama ore nixĩ i Chaunatü choxü̃ muxü̃ na nüxü̃ chixuxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Rü wüxi ga ngunexü̃ nataxu ga nawa na nanguxü̃ ga yema Yudíugüarü peta ga Üpetüchiga. Rü Ngechuchu nüxü̃ nacuèx ga marü nawa na nanguxü̃ ga ñoma ga naãnewa na yaxũxü̃ rü wenaxãrü Nanatüxü̃tawa na naxũxü̃. Rü nüma rü yexguma ñoma ga naãnewa nayexmagu rü guxü̃guma tüxü̃ nangechaü̃ ga guxema noxrü ixĩgüxe. Rü yexgumarüü̃ ta ga yexguma toxna yaxũxchaü̃gu ga daxũguxü̃ ga naãnewa na naxũxü̃, rü yemaãcü poraãcü toxü̃ nangechaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Natürü ga Chataná rü marü Yuda ga Chimáũ ga Icariúte nanena nangu na bexma cúãcü Ngechuchuxü̃ ínaxuaxü̃xü̃cèx. Rü Ngechuchu rü marü nüxü̃ nacuèx ga Nanatüxü̃tawa na ne naxũxü̃ rü wena táxarü Nanatücèx na nataeguxü̃. Rü nüxü̃ nacuèx ga Nanatü rü naxmẽ́xgu na naxüãxü̃ ga guxü̃ma ga pora. Rü yemacèx ga yema chütaxü̃gu ga yexguma mechawa ítachibüeyane, rü inachi ga Ngechuchu. Rü ínacu̱xuchi ga norü gáuxü̃chiru, rü wüxi ga tuayamaã nügü nigoye. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Rü ñu̱xũchi yauxmẽ́xü̃páxü̃gu dexáta naba, rü toxü̃ niyauxgücutü. Rü guma tuaya ga namaã yagoyecümaã toxü̃ ínapigücutü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Rü yexguma Chimáũ ga Pedruxü̃ nayauxcutüchaü̃gu rü ñanagürü ga Pedru: —Pa Corix, ¿ñuxãcü tá i cuma i choxü̃ cuyauxcutüxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Ñu̱xma rü tama nüxü̃ cucuèx i tü̱xcüü̃ na chanaxüxü̃ i ñaã, natürü yixcama rü tá nüxü̃ cucuèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Natürü ga Pedru rü ñanagürü: —Choma rü tãũtáma chanaxwèxe na choxü̃ cuyauxcutüxü̃ —ñanagürü. Rü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Ngẽxguma tama cuxü̃ chayauxcutügu, rü tãũtáma choxrü quixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Rü yexguma ga Chimáũ ga Pedru rü ñanagürü nüxü̃: —Pa Corix, ¡Tama choxü̃ cuyauxcutüxicatama! Natürü chanaxwèxe i choxü̃ cuyauxmẽ́x rü choxü̃ cuyauxeru ta —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Natürü Ngechuchu nanangãxü̃ rü ñanagürü nüxü̃: —Texé ya ngexwacèx aiyaxe rü tanaxwèxe i tümacutüxicatama tayaxu, erü guxü̃wama tangemata. Rü pema rü marü pingematagü, natürü tama guxãma aixcüma tingemata —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Rü Ngechuchu nüxü̃ nacuèx na texé tá bexma cúãcü ínaxuaxü̃xü̃, rü yemacèx ñanagürü nüxü̃: —Natürü tama guxãma aixcüma tingemata —ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Rü yexguma toxü̃ yayauxgücutüguwena, rü Ngechuchu wena nicu̱xcuchi ga norü gáuxü̃chiru. Rü wenaxãrü mechawa narüto. Rü ñanagürü toxü̃: —¿Nüxü̃ pecuáxü̃ yiĩxü̃ i ngẽma chaxüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","—Pema rü: “Pa Ngúexẽẽruü̃” rü “Pa Corix”, ñaperügü choxü̃. Rü marü name i ngẽma ñaperügü, erü aixcümaxü̃chi ngẽma chixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","—Rü ñu̱xma i choma na ngúexẽẽruü̃ chixĩxü̃ rü pemaã na ichacuáxü̃, rü pexü̃ chiyauxgücutü. Rü ngexgumarüxü̃ ta i pema rü name i wüxichigü i pemücüxü̃ piyauxgücutü.. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","—Choma rü pexü̃ nüxü̃ chadauxẽẽ na ñuxãcü tá penaxüxü̃ na pema rü ngema pemaã chaxüxü̃ãcü penaxüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","—Rü aixcüma pemaã nüxü̃ chixu rü taxuü̃ma i wüxi i coriarü duü̃xü̃ rü norü coriétüwa nügü nangexmaxẽẽ. Rü taxuxü̃ma i ãẽ̱xgacüarü orearü ngeruxü̃ i norü ãẽ̱xgacü i namuxü̃étüwa nügü nangexmaxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","—Rü ngẽxguma nüxü̃ pecuèxgu i chorü ore rü penaxü̱xgu i ngẽma pemaã nüxü̃ chixuxü̃, rü aixcüma tá petaãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","—Rü tama guxãma i pechiga nixĩ i chidexaxü̃. Erü choma rü tüxü̃ chacuèx rü texégü tixĩ ya yíxema tüxü̃ chidexechíxe. Natürü Tupana nayanguxẽẽchaü̃ i norü ore i ümatüxü̃ i ñaxü̃: “Texé ya chomaã chibüxe rü chomaã tarüxuwanü”, ñaxü̃. Rü ngẽmaãcü tá nangupetü na yanguxü̃cèx i ngema Tupanaarü ore. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","—Natürü naxü̃pa na nangupetüxü̃ i ngẽma, rü pemaã nüxü̃ chixu na choxü̃́ peyaxõgüxü̃cèx i ngẽxguma nangupetüxgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","—Aixcüma pemaã nüxü̃ chixu rü texé ya tüxü̃ yaxúxe ya yíxema choma nge̱ma tüxü̃ chamuxẽ, rü choxü̃ nixĩ i tayaxuxü̃. Rü texé ya choxü̃ yaxúxe, rü Chaunatü ga núma choxü̃ mucüxü̃ nixĩ i tayaxuxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Rü yexguma yema ñaxguwena ga Ngechuchu rü poraãcü ngechaü̃ nüxü̃́ nangu̱x, rü meãma tomaã nanango̱xẽẽ, rü ñanagürü toxü̃: —Aixcüma pemaã nüxü̃ chixu rü wüxie i petanüwa tá nixĩ i bexma cúãcü choxü̃ ítaxuaxü̃xü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Rü yexguma ga toma ga norü ngúexü̃gü rü wüxichigü togü tadawenü, rü tama nüxü̃ tacuèxgü ga texéchiga na yema ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Rü choma ga norü ngúexü̃ ga poraãcü choxü̃ nangechaü̃xẽ rü nacüwawa charüto ga Ngechuchu ga mechawa. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Rü Chimáũ ga Pedru rü bexma choxü̃ naxuneta ga na Ngechuchuna chac̱axü̃cèx ga texéchiga na yiĩxü̃ ga yema. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Rü yexguma ga choma rü yexeraãcü Ngechuchuna chimaxcuchi rü nüxna chaca, rü ñacharügü: —Pa Corix, ¿texé tá tixĩ ya yíxema? —ñacharügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Rü Ngechuchu choxü̃ nangãxü̃, rü ñanagürü: —Wüxi i pãũãrü bücuxü̃ tá íchacúe, rü yíxema tüxna chanaxãxẽ, rü yíxema tixĩ —ñanagürü. Rü yexguma ínanacúe ga wüxi ga pãũãrü bücuxü̃ rü Yuda ga Icariúte ga Chimáũ nanena nanaxã. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Rü yexgumatama Yuda nayauxgu ga yema pãũãrü bücuxü̃ rü ngoxo ga Chataná rü Yudagu naxücu. Rü yexguma ga Ngechuchu rü ñanagürü nüxü̃: —Rü ngẽma cuxüxchaü̃xü̃, ¡rü paxa naxü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Natürü taxúema ga toma ga mechawa chibüexe nüxü̃ tacuèxgü ga ṯacüchiga na yiĩxü̃ ga yema ñaxü̃ ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Rü nüma ga Yuda rü dĩẽruchiü̃ãrü dauruü̃ nixĩ. Rü yemacèx ñuxre ga toma nüxü̃ tacuèxgügu rü Ngechuchu taxewa nanamu, na ṯacücèx yataxexü̃cèx naxcèx ga peta, rü ẽ́xna duü̃xü̃gü ga ngearü dĩẽruã́xü̃na ngĩxü̃ na naxãxü̃cèx ga dĩẽru. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Rü yexguma Yuda nayauxgu ga yema pãũ, rü ínaxũxũ ga yema ucapuwa. Rü marü nachüta ga yexgumax. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Rü yexguma Yuda íxũxguwena, rü Ngechuchu rü ñanagürü: —Rü ñu̱xma rü tá aixcüma nango̱x na ñuxãcü naporaxü̃ ya Tupana Nane ya duü̃xü̃xü̃ ixĩcü. Rü yimawa tá nixĩ i nango̱xẽẽãxü̃ ya Tupana i norü pora. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","—Rü ngẽxguma yima Tupana Nane nango̱xẽẽ̱xgu i Tupanaãrü pora, rü ngẽxgumarüü̃ tá ta ya Tupana rü nanango̱xẽẽ i Naneãrü pora. Rü paxa tá nixĩ i ngẽma. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","—Pa Chauxacüã̱xgüx, tãũtáma muxü̃ i ngunexü̃ petanüwa changẽxma. Rü pema rü tá chauxcèx pedaugü, natürü ngẽma choma íchaxũxü̃wa rü taxucürüwama nge̱ma pexĩ. Rü ñaãtama ore nixĩ ga marü Yudíugüarü ãẽ̱xgacügümaã nüxü̃ chixuxü̃, rü ñu̱xma rü pemaã rü ta nüxü̃ chixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","—Rü pemaã nüxü̃ chixu i wüxi i ngexwacaxü̃xü̃ i mu. Rü ngẽma pexü̃ chamuxü̃ nixĩ i pemücügüxü̃ na pengechaü̃xü̃ i wüxichigü. Rü ngẽma na choma pexü̃ changechaü̃xü̃rüü̃, rü chanaxwèxe i wüxichigü i pema rü pemücügüxü̃ pengechaü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","—Rü ngẽxguma wüxichigü pemücügüxü̃ pengechaü̃gu, rü guxü̃ma i duü̃xü̃gü tá nüxü̃ nicuèxãchitanü na chorü ngúexü̃gü pixĩgüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Rü Chimáũ ga Pedru rü Ngechuchuna naca, rü ñanagürü: —Pa Corix ¿ngextá tá cuxũ? —ñanagürü. Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Nge̱ma íchaxũxü̃wa rü taxucürüwa chowe curüxũ i ñu̱xmax. Natürü yixcama rü ngẽmáãcü tá chowe curüxũ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Rü yexguma ga Pedru rü ñanagürü: —Pa Corix, ¿tü̱xcüü̃ taxucürüwa cuwe charüxũ i ñu̱xmax? Erü marü íchamemare na cuxcèx na chayuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —¿Aixcüma yiĩxü̃ i marü ícumemarexü̃ na chauxcèx cuyuxü̃? Aixcüma cumaã nüxü̃ chixu rü tãũtátama yacaxgu ya otá, rü tomaẽ̱pü̱xcüna tá nüxü̃ quixu na tama choxü̃ cucuáxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","—¡Tãxṹ i penaxi̱xãchiãẽgüxü̃ i pemax! ¡Tupanaãxü̃́ peyaxõgü rü choxü̃́ rü ta peyaxõgü! ");
INSERT INTO tcaNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","—Chaunatüxü̃tawa nangẽxma i muxũchixü̃ma i nachicagü. Ngẽxguma chi natau̱xguma, rü tãũ chima pemaã nüxü̃ chixu na pexcèx chayamexẽẽxü̃cèx i pechicagü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","—Rü ngẽxguma marü nge̱ma chaxũxgu rü wüxi i pechica chamexẽẽxgu, rü wena táxarü núma chaxũ. Rü pexü̃ tá chayagagü na ngẽma nachica i chomatátama nawa changẽxmaxü̃wa na pengẽxmagüxü̃cèx i pemax. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","—Rü pema rü nüxü̃ pecuèx na ngextá tá na chaxũxü̃, rü marü nüxü̃ pecuèx i nama i nge̱ma nadaxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Rü Tumachi rü ñanagürü: —Pa Corix, tama nüxü̃ tacuèx na ngextá na cuxũxü̃. ¿Rü ñuxãcü tá i nüxü̃ tacuáxü̃ i ngẽma nama? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Choma nixĩ i ngẽma nama i Chaunatüxü̃tawa nadaxü̃ chiĩxü̃. Rü aixcüma nixĩ i ngẽma ore i nüxü̃ chixuxü̃. Rü choma nixĩ i duü̃xü̃güxü̃ chamaxẽxẽẽxü̃. Rü chaugaguxicatama nixĩ i Chaunatüxü̃tawa nangugüxü̃ i duü̃xü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","—Rü ngẽxguma chi pema rü aixcüma meã choxü̃ pecuèxgügu, rü Chaunatüxü̃ rü chi ta pecuèxgü. Rü ñu̱xmaü̃cüü nixĩ i Chaunatüxü̃ pecuáxü̃, erü marü nüxü̃ pedaugüecha —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Rü yexguma ga Piripi rü ñanagürü: —Pa Corix, ¡Toxü̃ nüxü̃ nadauxẽẽ ya Cunatü! Rü ngẽxĩcatama i tanaxwèxegüxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Pa Piripix, ¿ñuxre ya taunecü marü petanüwa changẽxma rü ñu̱xma rü ta tama choxü̃ cucuèxégaxü̃? Yíxema choxü̃ dauxe rü Chaunatüxü̃ rü ta tadau. ¿Rü tü̱xcüü̃ i ngẽxguma rü ta cunaxwèxexü̃ i pexü̃ nüxü̃ na chadauxẽẽxü̃ ya Chaunatü? ");
INSERT INTO tcaNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","—¿Tama ẽ́xna cuyaxõ na choma rü Chaunatümaã rü wüxitama tixĩgüxü̃? Rü guxü̃ma i ore i pemaã nüxü̃ chixuxü̃ rü tama chauechama nüxü̃ chixu. Erü yima Chaunatü ya wüxiwa chomaã ngẽxmacü, rü yima nixĩ ya naxücü i guxü̃ma i noxrütama puracü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","—Chanaxwèxe i choxü̃́ peyaxõgü na choma rü Chaunatümaã wüxitama tixĩgüxü̃. Natürü woo tama ngẽma pixõgügu rü chanaxwèxe na choxü̃́ peyaxõgüxü̃ naxcèx i ngẽma mexü̃gü i taxü̃ i Tupanaãrü poramaã chaxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","—Aixcüma pemaã nüxü̃ chixu rü yíxema choxü̃́ yaxṍxẽ rü tá tanaxü i guxü̃ma i choma chaxüxü̃. Rü ngẽma chaxüxü̃ãrü yexera tá taxü, erü choma rü tá Chaunatüxü̃tawa chaxũ. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","—Rü guxü̃ma i ṯacü i chauégagu Tupanaxü̃tawa naxcèx ípec̱axü̃ rü tá pexna chanaxã. Rü ngẽmaãcü tá chanaxü na chaugagu nangóxü̃cèx i Chaunatüarü pora. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","—Rü choma tá chanaxü i guxü̃ma i ṯacü i chauégagu choxna naxcèx pec̱axü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Rü ngẽxguma aixcüma choxü̃ pengechaü̃gu, rü naga tá pexĩnüẽ i chorü mugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","—Rü choma tá Chaunatüna naxcèx chaca na núma pexcèx namuãxü̃cèx i to i perü ngü̃xẽẽruü̃ i Naãẽ i Üünexü̃, na guxü̃gutáma petanüwa nangẽxmaxü̃cèx. Rü nüma tá nixĩ i pexcèx nango̱xẽẽãxü̃ i ore i aixcüma ixĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","—Rü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü rü taxucürüwama nanayauxgü, erü tama nüxü̃ nadaugü rü tama nüxü̃ nacuèxgü. Natürü i pema rü marü nüxü̃ pecuèx, erü nüma rü petanüwa nangẽxma. Rü guxü̃gutáma pemaã inarüxã̱ũ̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","—Rü tãũtáma núma pexü̃ chawogümare i chomax, erü wena táxarü pexcèx chataegu, na petanüwa changẽxmaxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","—Rü paxa tá nixĩ na tãũtáma choxü̃ nadaugüxü̃ i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü. Natürü i pema rü tá choxü̃ pedaugü. Rü tá pemaxẽ, erü choma rü chamaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","—Rü ngẽxguma yuwa ícharüdaxgu rü wena chamaü̃xgu, rü ngẽxguma tá nüxü̃ picuèxãchitanü na choma rü Chaunatüwa chamaxü̃xü̃ rü pema i chowa rü choma i pewa. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","—Yíxema texé ya nüxü̃ cuáxe rü naga ĩnüxẽ i chorü mugü, rü tanango̱xẽẽ na aixcüma choxü̃ tangechaü̃xü̃. Rü Chaunatü tá tüxü̃ nangechaü̃ ya yíxema choxü̃ ngechaü̃xẽ, rü choma rü tá ta tüxü̃ changechaü̃. Rü tüxü̃ tá chaugü chawẽ́x —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Rü nayexma ga to ga Ngechuchuarü ngúexü̃ ga Yudagu ãe̱gaxü̃ ta. Rü yema rü ñanagürü: —Pa Corix, ¿tü̱xcüü̃ toxü̃ cugü cuwẽ́x, rü tama ñoma i naãnecü̱̃ã̱x i duü̃xü̃güxü̃ cugü cuwẽ́x? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Yíxema choxü̃ ngechaü̃xẽ rü naga taxĩnü i ngẽma ore i tümamaã nüxü̃ chixuxü̃. Rü Chaunatü tá tüxü̃ nangechaü̃. Rü choma rü Chaunatümaã wüxigu tümaxü̃tawa tá tangẽxmagü. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","—Yíxema tama choxü̃ ngechaü̃xẽ rü tama naga taxĩnü i ngẽma chorü ore. Rü ngẽma ore i chauxü̃tawa nüxü̃ pexĩnüẽxü̃ rü tama chorü ore nixĩ, natürü guma Chaunatü ga núma choxü̃ mucüarü ore nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","—Ñoma rü ta petanüwa changẽxma rü pemaã nüxü̃ chixu i guxü̃ma i ngẽma ore i pexcèx choxü̃́ ngẽxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","—Natürü Chaunatü rü tá chauégagu núma nanamu i Naãẽ i Üünexü̃ na pexü̃ nangü̃xẽẽxü̃cèx. Rü nüma i Naãẽ i Üünexü̃ tá pexü̃ nangúexẽẽ i guxü̃ma, rü tá nüxna pexü̃ nacuèxãchixẽẽ i guxü̃ma i ore ga pemaã nüxü̃ chixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","—Rü ñu̱xma na pexna íchixũxü̃, rü pexna chanaxã i taãẽ. Natürü ngẽma taãẽ i pexna chaxãxü̃, rü tama ñoma i naãnecü̱̃ã̱x pexna ãxü̃ i taãẽrüü̃ nixĩ. Rü tama chanaxwèxe i penaxi̱xãchiãẽgü rü pemuü̃ẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","—Marü pemaã nüxü̃ chixu na pexna tá íchixũxü̃ rü wena táxarü pexcèx chataeguxü̃ na pemaã changẽxmaxü̃cèx. Rü choxü̃ pexĩnüẽ ga yexguma yema ñachaxgu. Rü ngẽxguma aixcüma choxü̃ pengechaü̃gu rü tá petaãẽgü ega nüxü̃ pecuèxgu na Chaunatücèx chataeguxü̃, erü Chaunatü rü chorü yexera nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","—Rü naxü̃pa na nangupetüxü̃ i ngẽma, rü pemaã nüxü̃ chixu na choxü̃́ peyaxõgüxü̃cèx i ngẽxguma nangupetügu. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","—Marü tãũtáma poraãcü pemaã chidexa, erü marü ínangu i Chataná i ñoma i naãneãrü ãẽ̱xgacü ixĩxü̃. Natürü nüma rü taxuwama choxü̃ narüyexera. ");
INSERT INTO tcaNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","—Natürü ngẽma tá choxü̃ ngupetüxü̃, rü ngẽmaãcü tá nixĩ na guxü̃ma i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü nüxü̃ nacuáxü̃cèx na choma rü Chaunatüxü̃ na changechaü̃xü̃, rü chanaxüxü̃ i ngẽma nüma choxü̃ namuxü̃. ¡Rü ipechigü, rü ngĩxã ítixĩ! —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Rü ñanagürü ga Ngechuchu: —Choma nixĩ i ñoma wüxi i ubanerüü̃ chiĩxü̃ rü Chaunatü nixĩ ya norü yora ixĩcü i ngẽma uba. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","—Rü chorü duü̃xü̃gü rü ngẽma ubachacüügürüü̃ nixĩgü. Rü ngẽma ubachacüü i tama oxü̃, rü norü yora rü nayadae. Natürü ngẽma nachacüü i oxü̃, rü meã nanamexẽẽtanü na yexeraãcü poraãcü naxoxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","—Pema rü marü pime, yerü naga pexĩnüẽ ga yema ore ga pexü̃ changúexẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","—Rü name nixĩ i guxü̃guma chowa peyaxũ̱xgü, ngẽma na choma rü pewa chayaxṹxü̃rüü̃. Erü wüxi i ubachacüü rü tama nüxĩca naxo, ega tama nanewa yaxũ̱xgux. Rü ngẽxgumarüü̃ ta i pema rü taxuacüma chauxcèx pemaxẽ, ega tama chowa peyaxũ̱xgüechagu. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","—Choma nixĩ i ubane, rü pema i nachacüügü. Rü yíxema chowa yaxṹẽchaxe rü choma i tümawa, rü aixcüma tá chauxcèx tamaxü̃. Rü ngẽmaãcü wüxi i ubachacüü i oxü̃rüü̃ tá tixĩ. Natürü ngẽxguma tama chowa peyaxũ̱xgüechagu, rü taxucürüwama ṯacü pexüe. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","—Rü texé ya tama chowa yaxṹẽchaxe rü tá ítatèxüchi. Rü wüxi i ubachacüü i daexü̃ rü ipaxü̃ rü iguxü̃rüü̃ tá tixĩ, rü ngẽxma tá tayarüxo. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","—Rü ngẽxguma chowa peyaxũ̱xgüechagu rü taguma nüxü̃ ipeyarüngümaẽgu i ngẽma ore i pexü̃ changúexẽẽxü̃, rü marü name i naxcèx ípeca i ṯacü i penaxwèxexü̃, rü choma rü tá pexna chanaxã. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","—Rü ngẽxguma aixcüma meã chauxcèx pemaxẽgu, rü Chaunatüxü̃ tá nicuèxüü̃gü i duü̃xü̃gü. Rü ngẽmaãcü aixcüma chorü ngúexü̃gü tá pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","—Choma rü pexü̃ changechaü̃ ngẽma na Chaunatü choxü̃ ngechaü̃xü̃rüü̃. Rü chanaxwèxe i aixcüma meã chauga pexĩnüẽẽcha, erü choma rü guxü̃guma pexü̃ changechaü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","—Choma rü naga chaxĩnü i Chaunatüarü mugü rü nüma rü guxü̃guma choxü̃ nangechaü̃. Rü ngẽxgumarüü̃ tá ta nixĩ ega naga pexĩnüẽgu i chorü mugü, rü guxü̃gutáma pexü̃ changechaü̃ẽcha. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","—Choma rü ngẽmaãcü pemaã nüxü̃ chixu na wüxigu chomaã petaãẽgüxü̃cèx. Rü ngẽmaãcü tá aixcüma petaãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","—Rü choma pexü̃ chamu na pemücügüxü̃ pengechaü̃güxü̃cèx, ngẽma choma na pexü̃ changechaü̃xü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","—Rü ngẽxguma wüxie aixcüma tümamücüxü̃ ngechaü̃gu, rü nüxü̃ tangechaü̃ãma rü nüe̱tama ega woo tümamücücèx tayu̱xgu. Rü nataxuma i to i ngechaü̃ i ngẽmaãrü yexera. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","—Pema rü chomücügü pixĩgü i ngẽxguma chauga pexĩnüẽgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","—Choma rü marü tama chorü duü̃xü̃gümareãcü pexü̃ chaxu. Erü wüxi i coriarü duü̃xü̃mare rü tama nüxü̃ nacuèx i ngẽma norü cori üxü̃. Natürü ñu̱xma rü chomücügümaã pexü̃ chaxu, erü pexü̃ nüxü̃ chacuèxẽẽ i guxü̃ma i ore ga Chaunatü chomaã nüxü̃ ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","—Pema rü tama pexira chauxcèx pedaugü, natürü chaxira nixĩ ga pexcèx chadauxü̃ rü pexü̃ chamuxü̃ na aixcüma chauxcèx pemaxẽxü̃cèx rü chauxü̃tawa penagagüxü̃cèx i muxü̃ma i duü̃xü̃gü na guxü̃guma choxü̃́ yaxõgüãxü̃cèx. Rü Chaunatü ya Tupana tá pexna nanaxã i guxü̃ma i ṯacü i chauégagu nüxna naxcèx pec̱axü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","—Rü ngẽma nixĩ i pexü̃ chamuxü̃ na pemücügüxü̃ pengechaü̃güxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—Ngẽxguma ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü pexchi aiegu, rü ¡nüxna pecuèxãchie ga chaxira chauxchi na naxaiexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","—Rü ngẽxguma chi ñoma i naãnecü̱̃ã̱x i duü̃xü̃gürüü̃ pixĩgügu, rü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü rü chi pexü̃ nangechaü̃gü ngẽma natanüxü̃güxü̃ na nangechaü̃güxü̃rüü̃. Natürü choma nixĩ ga pexcèx chadauxü̃ natanüwa ga ñoma ga naãnecü̱̃ã̱x ga duü̃xü̃gü. Rü ngẽmacèx nixĩ i pexchi naxaiexü̃, erü marü tama naxrüü̃ pixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","—¡Nüxna pecuèxãchie ga pemaã ñachagu: “Taxuxü̃ma i wüxi i coriarü duü̃xü̃ rü norü coriétüwa nügü nangexmaxẽẽ”, ñachagu! Rü yema na chauxchi na naxaiexü̃, rü pexchi rü tá ta naxaie. Rü yexguma chi chauga naxĩnüẽgu rü ñu̱xma rü chi ta pega naxĩnüẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","—Rü ngẽmaãcü ta chaugagu pexchi naxaie i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü erü tama nüxü̃ nacuèxgü ya Chaunatü ga núma choxü̃ mucü. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","—Rü ngẽxguma chi choma tama namaã chanango̱xẽẽgu na ñuxãcü chixri na namaxẽxü̃, rü tãũ chima nüxü̃ nacuèxgü ga pecadu na naxügüxü̃. Natürü ñu̱xma namaã nüxü̃ na chixuxü̃ na ñuxãcü chixri namaxẽxü̃, rü ngẽmacèx i ñu̱xma rü taxuacüma nüxü̃ nixugü na yangearü pecaduã́xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","—Rü guxü̃ma i duü̃xü̃gü i chauxchi aiexü̃ rü Chaunatüchi rü ta naxaie. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","—Rü ngẽma duü̃xü̃güpẽ́xewa rü Tupanaãrü poramaã chanaxü i mexü̃gü i taxü̃ i taguma texé ya togue üxü̃. Rü ngẽxguma chi tama napẽ́xewa chanaxü̱xgu i ngẽma mexü̃gü rü tãũ chima Tupana namaã nanaxuegu na nagagutama yapecaduã̱xgüxü̃. Natürü na woo marü nüxü̃ nadaugüxü̃ i ngẽma mexü̃gü i taxü̃ i Tupanaãrü poramaã chaxüxü̃, rü ngẽxguma rü ta chauxchi naxaieama rü Chaunatüchi rü ta naxaie. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","—Natürü ngẽmaãcü nangupetü erü Tupana nayanguxẽẽchaü̃ i norü ore i ümatüxü̃ i ñaxü̃: “Chauxchi naxaie woo taxuü̃ma i chixexü̃ chaxü̱xgu”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","—Natürü choma rü tá Chaunatüégagu pexcèx núma chanamu i perü ngü̃xẽẽruü̃ i Tupanaãẽ i Üünexü̃ i tá pexü̃ nüxü̃ cuèxẽẽxü̃ i ore i aixcüma ixĩxü̃. Rü nüma tá nixĩ i meãma pemaã nüxü̃ yaxuxü̃ i chauchiga. ");
INSERT INTO tcaNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","—Rü pema rü tá ta chauchigaxü̃ pixugüe, yerü noxri ichanaxügügu ga duü̃xü̃gümaã nüxü̃ na chixuxü̃ ga chorü ore, rü woetama marü chauxü̃tawa peyexmagü —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Rü Ngechuchu rü ñanagürü nüxü̃: —Rü pemaã nüxü̃ chixu i ñaã ore na tama nüxü̃ na perüxoexü̃cèx na choxü̃́ peyaxõgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","—Rü ngutaquẽ́xepataü̃güwa tá pexü̃ ínawoxü̃. Rü aixcüma tá nawa nangu na texé pexü̃ dèi̱xü̃ rü tá nagu tarüxĩnüxü̃ na ngẽmaãcü mexü̃ Tupanacèx taxüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","—Rü ngẽmaãcü tá pemaã namaxẽ i duü̃xü̃gü, erü taguma nüxü̃ nacuèxgü ya Chaunatü, rü choxü̃ rü ta tama nacuèxgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","—Rü pemaã nüxü̃ chixu i ñaã ore i ñu̱xmax, na nüxna pecuèxãchiexü̃cèx i ngẽxguma yixcüra ngẽmaãcü pexü̃ nangupetügu. —Noxri rü tama pemaã nüxü̃ chixu i ñaã ore, yerü petanügu charüxã̱ũ̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","—Natürü i ñu̱xma rü tá pexna íchixũ na Chaunatü ga núma choxü̃ mucüxü̃tawa na changẽxmaxü̃cèx. Rü pema rü taxúema choxna peca na ngextá tá na chaxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","—Natürü poraãcü pengechaü̃güama erü pemaã nüxü̃ chixu i ngẽma ore. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","—Natürü aixcüma pemaã nüxü̃ chixu rü pexcèx narümemaẽ nixĩ na Chaunatücèx chataeguxü̃. Rü ngẽxguma chi tama Chaunatüxü̃tawa chaxũxgu rü tãũ chima núma naxũ i Naãẽ i Üünexü̃ i pexü̃ rüngü̃xẽẽxü̃. Natürü ngẽxguma nge̱ma chaxũxgu rü choma tá núma chanamu i Naãẽ i Üünexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","—Rü ngẽxguma Naãẽ i Üünexü̃ núma ũxgu rü tá guxü̃ i duü̃xü̃güxü̃ nüxü̃ nacuèxẽẽ na yapecaduã̱xgüxü̃. Rü tá nanango̱xẽẽ i ñuxãcü na yiĩxü̃ i ngẽma maxü̃ i Tupanapẽ́xewa aixcüma mexü̃. Rü tá duü̃xü̃güxü̃ nüxü̃ nacuèxẽẽ na Tupana tá napoxcuexü̃ i duü̃xü̃gü naxcèx i norü pecadugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","—Rü nüma i Naãẽ i Üünexü̃ tá duü̃xü̃güxü̃ nüxü̃ nacuèxẽẽ na pecaduã̱xgüxü̃ yiĩxü̃ erü tama choxü̃́ nayaxõgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","—Rü tá nanangúexẽẽ i ñuxãcü na yiĩxü̃ i ngẽma maxü̃ i Tupanapẽ́xewa aixcüma mexü̃, erü choma rü tá Chaunatüxü̃tawa chaxũ, rü pema rü tãũtáma marü choxü̃ pedaugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","—Rü Naãẽ i Üünexü̃ tá duü̃xü̃güxü̃ nüxü̃ nacuèxẽẽ na Tupana tá napoxcuexü̃ i duü̃xü̃gü i chixexü̃ ügüxü̃, erü Tupana rü namaã nanaxuegu na marü napoxcuãxü̃ i Chataná i ñoma i naãnemaã icuáxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","—Choma rü choxü̃́ nangẽxma i muxü̃ma i to i ore i pemaã nüxü̃ chixuxchaü̃chiréxü̃. Natürü ega ñu̱xma chi pemaã nüxü̃ chixuxgu rü tãũ chima nüxü̃ pecuèxgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","—Rü Tupanaãẽ i Üünexü̃ rü nüxü̃ nixu i ore i aixcüma ixĩxü̃xĩcatama. Rü ngẽxguma núma naxũxgu rü nüma tá pexü̃ nangúexẽẽ i guxü̃ma i ore i aixcüma ixĩxü̃. Erü nüma rü tama nüẽchama tá nidexa, natürü ngẽma ore i Chaunatüxü̃tawa rü chauxü̃tawa nüxü̃ naxĩnüxü̃xü̃xica tátama nixu. Rü tá pexü̃ nüxü̃ nacuèxẽẽ i guxü̃ma i ṯacü i yixcüra tá ngupetüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","—Rü nüma rü tá choxü̃ nataxẽẽ, erü chauxü̃tawa tá nanayaxu i norü ngu̱xẽẽtae, rü ñu̱xũchi tá pexü̃ nangúexẽẽ namaã i ngẽma ngu̱xẽẽtae. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","—Guxü̃ma i Chaunatüaxü̃́ ngẽxmaxü̃ rü choxrü ta nixĩ. Ngẽmacèx pemaã nüxü̃ chixu rü Naãẽ i Üünexü̃ rü chauxü̃tawa tá nanayaxu i norü ngu̱xẽẽtae, rü ñu̱xũchi pexü̃ tá namaã nangúexẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—Rü paxa tãũtáma choxü̃ pedau. Natürü ngẽmawena rü wena táxarü choxü̃ pedau erü Chaunatüxü̃tawa tá chaxũ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Rü yexguma ñuxre ga toma ga Ngechuchuarü ngúexü̃gü rü togüna tacagü, rü ñatarügügü: —¿Ṯacüchiga nixĩ na ngẽma ñaxü̃: “Rü paxa tãũtáma choxü̃ pedaugü. Natürü ngẽmawena rü wena táxarü choxü̃ pedaugü”, ñaxü̃? ¿Rü ṯacüchiga ta nixĩ na ñaxü̃: “Choma rü Chaunatüxü̃tawa tá chaxũ”, ñaxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","—¿Rü ṯacüchiga ta nixĩ na ñaxü̃: “Rü paxa tãũtáma choxü̃ pedaugü”, ñaxü̃? Rü yixema rü tama nüxü̃ tacuèxgüéga na ṯacüchigaxü̃ tamaã yaxuxü̃ —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Rü Ngechuchu rü nüxü̃ nacuèxama ga nüxna na tacagüchaü̃xü̃ ga tomax. Rü yemacèx ñanagürü toxü̃: —Choma rü marü pemaã nüxü̃ chixu rü paxa tãũtáma choxü̃ pedau, natürü ngẽmawena rü wena táxarü choxü̃ pedau. ¿Rü ngẽma dexacèxtama i pegüna pecagüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","—Rü aixcüma pemaã nüxü̃ chixu rü pema rü tá pexauxe, rü tá pengechaü̃gü. Natürü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü rü tá nataãẽgü. Natürü woo pema tá pengechaü̃gü, rü ngẽma perü ngechaü̃ rü tá taãẽxü̃ nananguxuchi. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","—Ngẽxguma wüxi i nge íraxacüchaü̃gu rü inaxi̱xãchiãẽ, erü ingu̱xneca. Natürü ngẽxguma marü tabuxgu ya ngĩrü õxchana, rü nüxü̃ iyarüngüma na ñuxãcü poraãcü ngĩxü̃́ na nangu̱xchiréxü̃ i noxrix, erü tümamaã itaãẽ ya ngĩrü õxchana. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","—Rü ngẽxgumarüü̃ tá ta pexü̃ nangupetü i pemax, erü ñu̱xma rü penaxi̱xãchiãẽgü. Natürü wena táxarü chataegu rü pexü̃ íchayadau. Rü ngẽxguma rü tá pexü̃́ nangẽxma i wüxi i taãẽ i taxucürüwama texé pexna yaxuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","—Rü ngẽxguma ínanguxgu tá i ngẽma ngunexü̃ na yanguxü̃ i ñaã pemaã nüxü̃ chixuxü̃, rü taxucèxtáma ṯacücèx choxna pecagü erü aixcüma Chaunatü tá nixĩ ya pexna naxãcü i guxü̃ma i ṯacü i chauégagu nüxna naxcèx pec̱axü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","—Ñu̱xmarüta i pema rü taxuü̃cèxma chauégagu ípecagü. ¡Naxcèx ípeca rü tá penayaxu i ngẽma naxcèx ípec̱axü̃! Rü ngẽmaãcü rü tá aixcüma petaãẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Ñu̱xma rü cuèxruü̃gügu chayaxuãcüma pemaã nüxü̃ chixu i ore. Natürü nawa tá nangu i ngunexü̃ i marü tãũtáma ngẽmaãcü pemaã nüxü̃ chixu. Rü ngẽxguma rü tá noxtacüma meã pemaã chanango̱xẽẽ i Chaunatüchiga. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","27","—Rü ngẽma ngunexü̃gu i pema rü Chaunatüxü̃tawa tá chauégagu naxcèx ípeca i ṯacü i penaxwèxexü̃. Rü taxucèxma tü̱xcüü̃ choma tá Chaunatüxü̃tawa pexü̃́ naxcèx íchaca, erü nümatama ya Chaunatü rü woetama pexü̃ nangechaü̃, erü pema rü choxü̃ pengechaü̃ rü peyaxõgü na naxü̃tawa ne chaxũxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","—Chaunatüxü̃tawa ne chaxũ na ñoma ga naãnewa chaxũxü̃cèx. Rü ñu̱xma rü tá nüxna chataegu i ñoma i naãne na wenaxãrü Chaunatüxü̃tawa chaxũxü̃cèx —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Rü yexguma ga toma ga norü ngúexü̃gü rü ñatarügügü: —Ñu̱xma waxi nixĩ i meãxü̃chima tomaã cunango̱xẽẽxü̃ i curü ore i tomaã nüxü̃ quixuxü̃. Rü tama ṯacügu ixuxü̃ãcüma tomaã nüxü̃ quixu. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","—Rü ñu̱xma rü nüxü̃ tacuèx na aixcüma guxü̃xü̃ma na cucuáxü̃. Rü taxuacüma texé ñuxũ ñatagürü cuxü̃. Rü ngẽmacèx nixĩ i tayaxõgüxü̃ na aixcüma Tupanaxü̃tawa na ne cuxũxü̃ —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Rü Ngechuchu toxü̃ nangãxü̃ rü ñanagürü: —¿Aixcüma peyaxõgüxü̃ i ñu̱xmax? ");
INSERT INTO tcaNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","—Rü nawa tá nangu i ngunexü̃ rü ñu̱xmatátama nixĩ i na pegü pewoonexü̃. Rü wüxichigü i pema rü tá pepatawa pexĩ, rü chaxica tá nuã choxü̃ petèx. Natürü tama chaxica tá icharüxã̱ũ̱x, erü Chaunatü rü chauxü̃tawa nangẽxma. ");
INSERT INTO tcaNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","—Rü guxü̃ma i ñaã ore rü pemaã nüxü̃ chixu na chaugagu petaãẽgüxü̃cèx. Rü ñoma i naãnewa rü tá ngúxü̃ pinge. Natürü ¡peporae! erü choma rü marü nüxü̃ charüyexera i guxü̃ma i ṯacü i ñoma i naãnewa ngẽxmaxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Rü yema ñaxguwena rü Ngechuchu daxũgu nadawenü, rü ñanagürü: —Pa Chaunatüx, marü nawa nangu i ngunexü̃ na chayuxü̃. Rü chanaxwèxe na duü̃xü̃güxü̃ nüxü̃ cucuèxẽẽxü̃ na aixcüma choma rü cune chiĩxü̃. Rü ngẽmaãcü i choma rü tá nüxü̃ nüxü̃ chacuèxẽẽ na cuma rü aixcüma Tupana na quiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","—Erü marü guxü̃ i duü̃xü̃güarü ãẽ̱xgacüxü̃ choxü̃ quixĩxẽẽ, na chanamaxẽxẽẽxü̃cèx i guxü̃ma i duü̃xü̃gü i choxna cumugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","—Rü ngẽma duü̃xü̃gü tá nüxü̃́ nangẽxma i maxü̃ i taguma gúxü̃ ega cuxü̃ nacuèxgügu na cuxicatama Tupana na quiĩxü̃, rü choxü̃ nacuèxgügu na choma rü Cristu ga núma choxü̃ cumucü na chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","—Choma rü marü cuxü̃ chataxẽẽ i ñoma i naãnewa rü chayanguxẽẽ i guxü̃ma i puracü ga nawa choxü̃ cumuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","—Rü ñu̱xma Pa Chaunatüx, rü chanaxwèxe i cugüxü̃tawa choxü̃ cungẽxmaxẽẽ na choxü̃́ nangẽxmaxü̃cèx ga yematama pora ga cumaã choxü̃́ yexmaxü̃ ga noxri tauta naãne ü̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","—Rü guxema duü̃xẽgü ya tüxü̃ quidexechixe ga ñoma ga naãnewa na choxna tüxü̃ cumugüxü̃cèx, rü marü tüxü̃ nüxü̃ chacuèxẽẽ i texé na quiĩxü̃ i cumax. Rü woetama cuxrügü tixĩgü rü cuma nixĩ ga choxna tüxü̃ cumugüxü̃. Rü tümagü rü marü naga taxĩnüẽ i curü ore. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","—Rü ñu̱xma rü marü nüxü̃ tacuèx rü guxü̃ma i ngẽma choxna cuxãxü̃, rü aixcüma cuxü̃tawa ne naxũ. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","—Rü choma rü marü tümamaã nüxü̃ chixu ga curü ore ga chomaã nüxü̃ quixuxü̃. Rü tümagü rü marü tayaxõgü i ngẽma ore. Rü nüxü̃ ticuèxãchitanü na aixcüma cuxü̃tawa na ne chaxũxü̃ i chomax. Rü tayaxõgü ga cuma núma choxü̃ na cumuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","—Rü ngẽmacèx cuxna chaca na tüxü̃ na curüngü̃xẽẽxü̃cèx. Rü tama cuxna chaca na nüxü̃ curüngü̃xẽẽxü̃cèx i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü, natürü cuxna chaca na tüxü̃ curüngü̃xẽẽxü̃cèx ya guxema choxna tüxü̃ cumugüxe, erü curü duü̃xü̃gü tixĩgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Rü guxãma ya yíxema choxrügü ixĩgüxe rü cuxrügü tixĩgü. Rü guxãma ya cuxrügü ixĩgüxe rü choxrügü tixĩgü. Rü tümagagu rü duü̃xü̃gü choxü̃ nicuèxüü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","—Choma rü marü tãũtáma ñoma i naãnewa changẽxmaẽcha, natürü i tümagü rü ngẽmáãcü ñoma i naãnewa tá tangẽxmagü ngẽxguma cuxü̃tawa chaxũyane. Pa Chaunatü ya Üünecüx, rü chanaxwèxe na curü pora ga choxna cuxãxü̃maã tüxna cudauxü̃ ya yíxema choxna tüxü̃ cumugüxe, na ngẽmaãcü guxãma wüxigu rüxĩnüẽxü̃cèx, ngẽma cuma rü choma na wüxigu rüxĩnüẽxü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","—Rü yexguma guxema choxna tüxü̃ cumugüxetanüwa chayexmagu ga ñoma ga naãnewa, rü curü pora ga choxna cuxãxü̃maã tüxna chadau rü tüxü̃ íchapoxü̃. Rü taxúema ga guxema choxna tüxü̃ cumugüxe rü itayarütauxe. Rü Yuda ga woetama iyarütaxuxü̃xicatama inayarütaxu na yanguxü̃cèx i curü ore i ümatüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","—Rü ñu̱xma rü cuxü̃tawa tá chaxũ. Natürü ñomarüta ñoma i naãnewa changẽxma-yane rü nüxü̃ chixu i ñaã curü ore na tümagü rü ta tüxü̃́ nangẽxmaxü̃cèx i ngẽma taãẽ i aixcüma ixĩxü̃ i choma choxü̃́ ngẽxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","—Choma rü marü tümamaã nüxü̃ chixu i curü ore. Natürü ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü rü tümachi naxaie, erü tüma rü tama naxrüü̃ tixĩgü, ngẽxgumarüü̃ i choma rü tama ñoma i naãnecü̱̃ã̱xrüü̃ chixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","—Tama cuxna tümacèx chaca na tüxü̃ na quigagüxü̃cèx i ñoma i naãnewa. Natürü cuxna chaca na tüxü̃ na ícupoxü̃xü̃cèx nüxna i ngoxo i Chataná. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","—Choma rü tama ñoma i naãnecü̱̃ã̱x chixĩ. Rü tümagü rü ta tama ñoma i naãnecü̱̃ã̱x tixĩgü, erü cuxrügü tixĩgü i ñu̱xmax. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","—Curü ore rü aixcüma nixĩ. Rü chanaxwèxe i tüxü̃ cungúexẽẽ i curü ore, na aixcüma cupẽ́xewa tixüünexü̃cèx ya yíxema choxna tüxü̃ cumugüxe. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","—Rü yexgumarüü̃ ga ñoma ga naãnecü̱̃ã̱x ga duü̃xü̃gütanüwa choxü̃ na cumuxü̃rüü̃, rü ngẽxgumarüü̃ i choma rü ta ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü-tanüwa tüxü̃ chamugü. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","—Rü tümagagu chaugü ichaxã na tüxü̃ changúexẽẽxü̃cèx i curü ore i aixcüma ixĩxü̃, na cupẽ́xewa tixüünexü̃cèx ya yíxema choxna tüxü̃ cumugüxe. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","—Natürü tama yíxema ñu̱xma yaxõgüxecèxicatama cuxna chaca. Natürü cuxna chaca ta tümacèx ya yíxema yixcüra tá yaxõgüxe nagagu i tümaãrü ore ya yíxema ñu̱xma yaxõgüxe. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","—Rü guxãma ya yíxemacèx cuxna chaca na aixcüma wüxitama tixĩgüxü̃cèx. Rü ngẽma cuma rü choma na wüxitama ixĩgüxü̃rüü̃, Pa Chaunatüx, rü chanaxwèxe i guxãma i tüma rü ta wüxitama tixĩgü. Rü ngẽmaãcü i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü, rü tá nayaxõgü na cuma núma choxü̃ cumuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","—Rü choma rü marü tüxna chanaxã i ngẽmatama pora i cuma choxna cuxãxü̃ na ngẽmaãcü wüxitama tixĩgüxü̃cèx ngẽma cuma rü choma na wüxitama ixĩgüxü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","—Rü chanaxwèxe na tümawa changẽxmaxü̃ rü cuma i chowa na cungẽxmaxü̃ na ngẽmaãcü aixcüma wüxi-tama ixĩgüxü̃ i guxãma i yixema. Rü ngẽmaãcü i ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü rü tá nüxü̃ nicuèxãchitanü na cuma núma choxü̃ cumuxü̃, rü tá nüxü̃ nicuèxãchitanü na tüxü̃ cungechaü̃xü̃ ya yíxema choxna tüxü̃ cumugüxe ngẽma na choxü̃ cungechaü̃xü̃rüü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","—Pa Chaunatüx, cuma choxna tüxü̃ cumugü. Rü chanaxwèxe i chauxü̃tawa tangẽxmagü i nge̱ma tá íchangẽxmaxü̃wa, na nüxü̃ tadaugüxü̃cèx i chorü pora ga choxna cuxãxü̃. Yerü choxü̃ cungechaü̃ ga yexguma tauta naãne ixügügumama. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","—Pa Chaunatü ya Mecüx, ñoma i naãnecü̱̃ã̱x i duü̃xü̃gü rü tama cuxü̃ nacuèxgü. Natürü choma rü cuxü̃ chacuèx. Rü yíxema choxna tüxü̃ cumugüxe rü ta marü nüxü̃ tacuèxgü na cuma núma choxü̃ cumuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","—Rü marü tüxü̃ nüxü̃ chacuèxẽẽ na texé quiĩxü̃. Rü guxü̃gutáma tüxü̃ nüxü̃ chicuèxẽẽãmachigü na cuma choxü̃ cungechaü̃xü̃rüü̃ tügü tangechaü̃güxü̃cèx rü choma rü tümaxü̃tawa na changẽxmaxü̃cèx —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Rü yema ñaxguwena ga Ngechuchu rü tomaã inaxũãchi, na Cheduruarü ngatexü̃ãrü tocutüwa taxĩxü̃cèx. Rü yéma nayexma ga wüxi ga nanetünecü. Rü yemawa naxũ ga Ngechuchu tomaã. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Rü Yuda ga yema bexma cúãcü Ngechuchuxü̃ íyaxuaxü̃xü̃ rü nüxü̃ nacuèx ga yema nachica, yerü Ngechuchu rü muẽ̱xpü̱xcüna yéma tomaã nangutaquẽ́xexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Rü yéma nangu ga Yuda namaã ga ñuxre ga churaragü rü ñuxre ga tupauca ga taxü̃neãrü purichíagü ga yéma namugüxü̃ ga paigüarü ãẽ̱xgacügü rü parichéugü. Rü meãma nixãxne, rü yéma nanangegü ga omügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Natürü ga Ngechuchu rü marü nüxü̃ nacuèx ga guxü̃ma ga ṯacü tá nüxü̃ na ngupetüxü̃. Rü yemacèx naxcèx nixũ, rü nüxna naca, rü ñanagürü: —¿Texécèx nixĩ i pedaugüxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rü nümagü rü Ngechuchuxü̃ nangãxü̃gü, rü ñanagü-rügü: —Nacharétucü̱̃ã̱x i Ngechuchucèx nixĩ i tadaugüxü̃ —ñanagürügü. Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Choma chixĩ —ñanagürü. Rü Yuda ga bexma cúãcü ínaxuaxü̃xü̃ rü yema churaragütanüwa nayexma. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Rü yexguma yema ñaxgu ga Ngechuchu: “Choma chixĩ”, ñaxgu, rü nügüweama nacaixü̃tanü ga yema churaragü, rü yexma nayayi. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Rü yexguma ga Ngechuchu rü wena nüxna naca, rü ñanagürü: —¿Texécèx nixĩ i pedaugüxü̃? —ñanagürü. Rü nümagü rü nanangãxü̃gü rü ñanagürügü: —Nacharétucü̱̃ã̱x i Ngechuchucèx nixĩ i tadaugüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Rü Ngechuchu rü wenaxãrü ñanagürü nüxü̃: —Marü pemaã nüxü̃ chixu rü choma chixĩ. Rü ngẽxguma chauxcèx pedaugügu rü ¡ípeyaxĩxẽẽ i ñaã chorü ngúexü̃gü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Rü yemaãcü nangupetü na yanguxü̃cèx ga norü ore ga nümatama ga Ngechuchu nüxü̃ yaxuxü̃ ga ñaxgu: “Yíxema Chaunatü choxna tüxü̃ mugüxe rü taxúetáma itayarütauxe”, ñaxgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Rü Chimáũ ga Pedru rü nüxü̃́ iyexma ga wüxi ga cüxchi. Rü ngĩxü̃ nayaxu ga norü cüxchi rü yemamaã ínanadaechinü ga paigüarü ãẽ̱xgacüarü duü̃xü̃ ga Macugu ãe̱gaxü̃. Rü norü tügünechinü ínadae. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Natürü ga Ngechuchu rü Pedruxü̃ ñanagürü: —¡Ngĩxchixü̃gu ngĩxü̃ ixücuchi i curü cüxchi! ¿Tama ẽ́xna nüxü̃ cucuèx na choma rü tá ngúxü̃ chingexü̃ ngẽma Chaunatü chomaã naxueguxü̃rüü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Rü yexguma ga churaragüarü ãẽ̱xgacü, namaã ga norü churaragü rü tupaucaarü purichíagü, rü Ngechuchuxü̃ niyauxgü. Rü nayanèĩ̱xchacüügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Rü noxri rü ãẽ̱xgacü ga Anápatawa nanagagü. Rü Aná rü Caipánèxtü nixĩ. Rü guma taunecügu ga Caipá rü paigüeru nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Rü yema Caipá nixĩ ga ü̃paacü yema Yudíugüarü ãẽ̱xgacügümaã nüxü̃ ixuxü̃ ga na namemaẽxü̃ ga wüxitama ga yatü guxü̃ma ga Yudíugücèx na yuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Rü choma rü Chimáũ ga Pedru rü wüxigu Ngechuchuwe tarüxĩ. Rü yema paigüarü ãẽ̱xgacü rü choxü̃ nacuèx. Rü yemacèx ga choma rü wüxigu Ngechuchumaã tichocu ga ãẽ̱xgacüpataèxtüwa. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Natürü ga Pedru rü ĩã̱xãrü düxétügutama narüxã̱ũ̱x. Rü yemacèx íchaxũxü̃ ga choma, rü yema ĩã̱xãrü dauruü̃ ga ngecümaã chayarüdexa rü yexguma Pedruxü̃ iyamucuchi. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Rü yexguma ga yema ngecü ga ĩã̱xãrü dauruü̃, rü Pedruna ica, rü ngĩgürügü: —¿Tama ẽ́xna cuma rü ta wüxi i norü ngúexü̃ quiĩxü̃ i ngẽma yatü i yayauxgüxü̃? —ngĩgürügü. Rü Pedru ngĩxü̃ nangãxü̃, rü ñanagürü: —Tama nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Rü yéma ĩã̱xtüwa rü ãẽ̱xgacüarü duü̃xü̃gü rü purichíagü rü nanaxügü ga wüxi ga üxü, yerü nagáuane. Rü guma üxüxetüarü ngaicamagu nachigü, rü yéma nügü ninaĩxü̃gü. Rü Pedru rü ta yéma nügü nanaĩxü̃ naxẽtüwa ga guma üxü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Rü yema paigüarü ãẽ̱xgacü rü inanaxügü ga Ngechuchuna na nac̱axü̃, rü ñanagürü: —¿Ṯacü nixĩ ga duü̃xü̃güxü̃ namaã cungúexẽẽxü̃? ¿Rü texégü tixĩ ya yíxema curü ngúexü̃gü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Rü Ngechuchu ñanagürü nüxü̃: —Choma rü guxü̃ ga duü̃xü̃güpẽ́xewa nüxü̃ chixu ga chorü ore. Rü ngutaquẽ́xepataü̃güwa rü tupauca ya taxü̃newa i ngextá guxü̃ma i Yudíugü íngutaquẽ́xegüxü̃wa chanangúexẽẽ ga duü̃xü̃gü. Rü yemaãcü taxuü̃ma ichicu̱x ga chorü ore. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","—¿Rü tü̱xcüü̃ i choxna cuc̱axü̃ i ñu̱xmax? Ẽcü, ¡nüxna naca i ngẽma duü̃xü̃gü ga nüxü̃ ĩnüẽxü̃ ga chorü ore! Rü nümagü tá cumaã nüxü̃ nixugüe ga ṯacüchigaxü̃ namaã na chixuxü̃. Erü nümagü rü nüxü̃ nacuèxgü i guxü̃ma ga ṯacü ga namaã nüxü̃ chixuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Rü yexguma Ngechuchu yema ñaxgu, rü wüxi ga tupauca ga taxü̃neãrü purichía ga naxü̃tagu chixü̃, rü Ngechuchuchiwegu nidagü. Rü ñanagürü Ngechuchuxü̃: —¿Tü̱xcüü̃ ngẽmaãcü cunangãxü̃ ya daa paigüarü ãẽ̱xgacü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Rü ngẽxguma ṯacü rü chixexü̃xü̃ chixuxgu, ¡rü nüxü̃ ixu na ñuxãcü chixri na chidexaxü̃! Natürü ega chorü ore rü aixcüma yixĩgu, rü ¿tü̱xcüü̃ i choxü̃ quidagüxü̃ i ñu̱xmax? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Rü yexguma ga Aná rü Ngechuchuxü̃ yanáĩãcüma paigüarü ãẽ̱xgacü ga Caipáxü̃tawa nanamu. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Rü yoxni ga Pedru rü üxüarü ngaicamagu nachiecha, rü yéma nügü nanaĩxü̃ãma. Rü yema yéma yexmagüxü̃ rü nüxna nacagüe, rü ñanagürügü: —¿Tama ẽ́xna cuma rü ta norü ngúexü̃ quiĩxü̃ i ngẽma yatü i yayauxgüxü̃? —ñanagürügü. Natürü ga Pedru rü tama nügü nixu, rü ñanagürü: —Tama nixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Rü yéma nayexma ga wüxi ga paigüarü ãẽ̱xgacüarü duü̃xü̃. Rü yema rü Pedru ídaechinüxü̃tanüxü̃ nixĩ. Rü Pedruna naca, rü ñanagürü: —¿Tama ẽ́xna cuma yiĩxü̃ ga nanetünecüwa Ngechuchumaã cuxü̃ chadauxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Rü Pedru rü wena tama nügü nixu. Rü yexgumatama nica ga otá. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Rü yexguma Ngechuchumaã nüxü̃ nachauegu ga nüxna na nacagüxü̃, rü Caipápatawa ínanagaxüchigü rü Yudéaaneãrü ãẽ̱xgacü ga Dumacü̱̃ã̱xpatawa nanagagü. Natürü marü ningóonechaü̃ ga yexguma rü yemacèx ga yema Yudíugü rü tama guma ãẽ̱xgacüpatagu nachocu, yerü norü mugü nüxü̃ nixu rü taxü̃ ga pecadu nixĩ na wüxi ga Dumacü̱̃ã̱xpatagu na nachocuxü̃ ga yema ngunexü̃gu. Rü yemaãcü tama Tupanapẽ́xewa nügü nixüxaarü maxü̃ã̱xẽẽgüchaü̃, yerü yexguma nügü yaxüxaarü maxü̃ã̱xẽẽgügu, rü taxucürüwa nanangõ̱xgü ga õna ga Üpetüchigaarü petacèx namexẽẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Rü yemacèx ga guma ãẽ̱xgacü ga Dumacü̱̃ã̱x ga Piratu rü napatawa ínaxũxũ ga duü̃xü̃gümaã na yadexaxü̃cèx. Rü ñanagürü nüxü̃: —¿Ṯacücèx ípenaxuaxü̃ ya daa yatü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Rü nümagü rü Piratuxü̃ nangãxü̃gü, rü ñanagürügü: —Ngẽxguma chi tama wüxi i taxü̃ i chixexü̃ naxü̱xgu, rü tãũ chima cuxü̃tawa tanaga —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Rü yexguma ga Piratu rü ñanagürü nüxü̃: —¡Ẽcü perü ãẽ̱xgacügüxü̃tawa penaga, rü perü mugü pemaã nüxü̃ ixuxü̃ãcüma penapoxcux! —ñanagürü. Natürü ga yema Yudíugü rü Piratuxü̃ nangãxü̃gü, rü ñanagürügü: —Natürü pema i Dumacü̱̃ã̱xgü rü marü toxna penachu̱xu na texéxü̃ timèxgüxü̃ tümaãrü chixexü̃cèx —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Rü yemaãcü ningu ga yema ore ga Ngechuchu ü̃paacü nüxü̃ ixuxü̃ ga ñuxãcü tá na nayuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Rü Piratu rü wenaxãrü napatagu naxücu, rü Ngechuchucèx nangema. Rü nüxna naca, rü ñanagürü: —¿Cuma yiĩxü̃ i Yudíugüarü Ãẽ̱xgacü quiĩxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Rü Ngechuchu ñanagürü nüxü̃: —¿Cuechamatama i nagu curüxĩnüxü̃ na ngẽmaãcü choxna cuc̱axü̃, rü ẽ́xna togü marü cumaã nüxü̃ nixu na ngẽmaãcü choxna cuc̱axü̃cèx? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Rü Piratu Ngechuchuxü̃ nangãxü̃, rü ñanagürü: —¿Ẽ́xna cuma nagu curüxĩnügu rü Yudíu chiĩxü̃? Rü ngẽma cuchiü̃ãnecü̱̃ã̱xgü rü paigüarü ãẽ̱xgacügütama nixĩ i chauxü̃tawa cuxü̃ gagüxü̃. ¿Ẽ́xna ṯacü rü chixexü̃ cuxü? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Rü yexguma ga Ngechuchu rü nanangãxü̃, rü ñanagürü: —Choma rü tama ñoma i naãnewa ãẽ̱xgacü chixĩ. Rü ngẽxguma ñoma i naãnewa ãẽ̱xgacü chixĩgu, rü chorü duü̃xü̃gü rü chi Yudíugüarü ãẽ̱xgacügümaã nügü nadai rü tãũ chima choxü̃ niyauxgü i ngẽxguma. Natürü tama ñoma i naãnewa ãẽ̱xgacü chixĩ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Rü yexguma ga Piratu rü ñanagürü nüxü̃: —¿Ẽ́xna to i nachiü̃ãneãrü ãẽ̱xgacü quixĩ i cumax? —ñanagürü. Rü Ngechuchu nanangãxü̃ rü ñanagürü: —Cumatama marü nüxü̃ quixu na ãẽ̱xgacü chiĩxü̃. Rü yemacèx ga choma rü chabu rü ñoma ga naãnewa chaxũ na duü̃xü̃gümaã nüxü̃ chayarüxuxü̃cèx i ore i aixcüma ixĩxü̃. Rü guxãma ya texé ya nüxü̃ cuáxchaü̃xẽ i ngẽma ore i aixcüma ixĩxü̃, rü choxü̃́ itarüxĩnüẽ i ngẽma ore i nüxü̃ chixuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Rü Piratu rü ñanagürü nüxü̃: —¿Ṯacü nixĩ i ngẽma ore i aixcüma ixĩxü̃? —ñanagürü. Rü yemaãcü Ngechuchuna nacaxguwena ga Piratu, rü wenaxãrü Yudíugümaã nayarüdexa. Rü ñanagürü nüxü̃: —Taxuü̃ma i chixexü̃xü̃ nawa chadau i ñaã yatü. ¿Rü tü̱xcüü̃ chi inapoxcuxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","—Natürü guxü̃guma ega Üpetüchigaarü petawa nanguxgu, rü pecüma nixĩ na choxna naxcèx na pec̱axü̃ na íchananguxuchixẽẽxü̃cèx i wüxi i duü̃xü̃ i poxcuxü̃. ¿Rü penaxwèxexü̃ na pexcèx íchananguxuchixẽẽxü̃ i ñaã perü ãẽ̱xgacü, Pa Yudíugüx? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Rü yexguma ga guxü̃ma ga yema duü̃xü̃gü, rü tagaãcü aita naxüe, rü ñanagürügü: —Tama tanaxwèxe na cuya-ngéxü̃ i ngẽma yatü. Rü Barabá waxi nixĩ i tanaxwèxexü̃ na cuyangéxü̃ —ñanagürügü. Rü yema Barabá rü wüxi ga máẽtaxü̃ nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Rü yexguma ga Piratu rü churaragüxü̃ namu na Ngechuchuxü̃ nac̱uaixgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Rü yema churaragü rü chuchuxü̃wa nanaxügü ga wüxi ga boxü̃, rü ñu̱xũchi naẽruwa nayangèxcuchigü. Rü wüxi ga máxü̃ ga naxchiru ga dauxcharaxü̃gu nayacu̱xẽẽgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Rü ñu̱xũchi naxcèx naxĩ, rü nüxü̃ nacugüeãcüma ñanagürügü nüxü̃: —¡Namaxü̃, Pa Yudíugüarü Ãẽ̱xgacüx! —ñanagürügü. Rü nanapechiwegü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Rü Piratu rü wenaxãrü düxétüwa naxũ, rü Yudíugüxü̃ ñanagürü: —¡Dücèx! ñu̱xma tá nuã pepẽ́xewa chanaga na nüxü̃ pecuáxü̃cèx na taxuü̃ma i chixexü̃xü̃ nawa chadauxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Rü düxétüwa naxũ ga Ngechuchu. Rü namaã nangèxcueru ga yema boxü̃ ga chuchuxü̃wa naxügüxü̃. Rü nagu nicu̱x ga yema máxü̃ ga naxchiru ga dauxcharaxü̃. Rü yex-guma ga Piratu rü Yudíugüxü̃ ñanagürü: —Daa nixĩ ya yima yatü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Natürü yexguma Ngechuchuxü̃ nadaugügu ga paigüarü ãẽ̱xgacügü rü purichíagü, rü inanaxügüe ga aita na naxüexü̃. Rü ñanagürügü: —¡Curuchawa yapota! ¡Curuchawa yapota! —ñanagürügü. Rü Piratu rü ñanagürü nüxü̃: —¡Ẽcü, peyaga rü pematama curuchawa peyapota! Erü choma rü taxuü̃ma i chixexü̃xü̃ nawa chadau —ñanagürü ga Piratu. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Natürü ga yema Yudíugü rü Piratuxü̃ nangãxü̃gü, rü ñanagürügü: —Toma toxü̃́ nangẽxma i wüxi i torü mu. Rü ngẽma torü mu toxü̃ nüxü̃ nacuèxẽẽ na namexü̃ na nayuxü̃ i ñaã yatü, yerü nüma rü nüxü̃ nixu ga Tupana Nane na yiĩxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Rü yexguma yemaxü̃ naxĩnügu ga Piratu, rü yexeraãcü namuü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Rü wena Ngechuchumaã napatagu naxücu. Rü yéma Ngechuchuna nayaca, rü ñanagürü: —¿Ngextácü̱̃ã̱x quixĩ i cumax? —ñanagürü. Natürü ga Ngechuchu rü tama nanangãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Rü yexguma ga Piratu rü Ngechuchuxü̃ ñanagürü: —¿Ẽ́xna ngẽma tãũtáma choxü̃ cungãxü̃? ¿Tau ẽ́xna i nüxü̃ cucuáxü̃ na cho̱xmẽ́xwa cungẽxmaxü̃ na curuchawa cuxü̃ chipotaxü̃ rü ẽ́xna cuxü̃ na íchanguxuchixẽẽxü̃cèx? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Tãũ chima cuxmẽ́xwa changẽxma, ega tama Tupana naxwèxegu. Rü ngẽmacèx nixĩ i ngẽma duü̃xü̃gü i cuxna choxü̃ mugüxü̃ rü curü yexera poraãcü napecaduã̱xgü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Rü yemawena rü Piratu nagu narüxĩnü ga ñuxãcü Ngechuchuxü̃ na ínanguxuchixẽẽe̱gaxü̃. Natürü yema Yudíugü rü poraãcü aita naxüe, rü ñanagürügü: —Ngẽxguma tá ícunanguxuchixẽẽ̱xgu rü tama curü ãẽ̱xgacü ya tacü ya Dumacü̱̃ã̱x ya Chécharuxü̃ cungechaü̃. Erü ngexerǘxe ya ãẽ̱xgacü ya tacüxü̃ tügü ingucuchixẽe̱xẽ, rü Dumacü̱̃ã̱x ya ãẽ̱xgacü ya tacü ya Chécharuarü uwanü tixĩ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Rü yexguma yemaxü̃ naxĩnügu ga Piratu, rü churaragüxü̃ namu ga Ngechuchuxü̃ düxétüwa na nagagüxü̃cèx. Rü nawa nayarüto ga wüxi ga tochicaü̃ ga taxü̃ ga nutagünaxcèx ga togawa rü Gabatagu ãe̱gaxü̃. Rü yema nachicawa nixĩ ga poxcuexü̃ ga duü̃xü̃güna nac̱axü̃ ga ãẽ̱xgacü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Rü wüxi ga ngunexü̃ nataxu ga Üpetüchigaarü petawa na nanguxü̃ ga yexguma, rü marü tocuchiwa nangu. Rü Piratu rü Yudíugüxü̃ ñanagürü: —¡Daa nixĩ ya yima perü ãẽ̱xgacü! ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Natürü ga nümagü rü aita naxüe, rü ñanagürügü: —Tanaxwèxe na nayuxü̃. Rü ¡curuchawa yapota! —ñanagürügü. Rü Piratu nüxna naca rü ñanagürü nüxü̃: —¿Ñuxãcü i choma rü ichanamu na curuchawa yapotagüãxü̃cèx ya perü ãẽ̱xgacü? —ñanagürü. Natürü ga paigüarü ãẽ̱xgacügü rü Piratuxü̃ nangãxü̃gü, rü ñanagürügü: —Yima ãẽ̱xgacü ya tacü ya Chécharu ya Dumawa ngẽxmacü rü yima nixĩ ya torü ãẽ̱xgacü, rü nataxuma i to —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Rü yexguma ga Piratu rü yema Yudíugüna Ngechuchuxü̃ namu na curuchawa yapotagüãxü̃cèx. Rü nümagü rü nayagagü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Rü ínaxũxü̃ ga Ngechuchu, rü norü curucha ngĩxü̃ ininge. Rü yéma nanagagü nawa ga wüxi ga nachica ga “Duü̃xẽẽruchinèxãgu” ãe̱gaxü̃. Rü yema rü Górguta nixĩ ga nae̱ga ga togawa. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Rü yéma curuchawa Ngechuchuxü̃ nayarüpotagü. Rü Ngechuchurüü̃ curuchawa nayapotagü ga taxre ga to ga yatügü, rü wüxi ga norü tügünecüwawa rü to ga norü ṯoxwecüwawa. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Rü Piratu rü churaragüxü̃ namu na Ngechuchuarü curuchatapẽ́xewa na yapocuchigüãxü̃cèx ga wüxi ga mürapewaxacü ga ãe̱gatachinüxü̃ ga ñaxü̃: “Ngechuchu ya Nacharétucü̱̃ã̱x ya Yudíugüarü Ãẽ̱xgacü”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Rü muxü̃ma ga yema Yudíugü nüxü̃ nadaumatü ga yema namatü ga mürapewaxacügu üxü̃. Yerü yema nachica ga Ngechuchuxü̃ curuchawa íyanapotagüxü̃wa, rü ĩãneãrü ngaicamana nixĩ. Rü tomaẽ̱xpü̱x ga nagawa naxümatü ga yema nae̱ga ga yema mürapewawa. Rü togawa rü Griégugügawa rü Dumacü̱̃ã̱xgügawa naxümatü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Rü yemacèx ga yema Yudíugüarü paigüarü ãẽ̱xgacügü rü Piratuxü̃ ñanagürügü: —Toma rü tama tanaxwèxe i cunaxümatü i “Yudíugüarü Ãẽ̱xgacü”, ñaxü̃. Rü narümemaẽ nixĩ i cunaxümatü rü ñacurügü: “Nügü ixucü na Yudíugüarü Ãẽ̱xgacü yiĩxü̃”, ñacurügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Natürü Piratu nanangãxü̃ rü ñanagürü: —Ngẽma chaxümatüxü̃ rü marü ngẽxma naxümatü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Rü curuchawa marü Ngechuchuxü̃ yapotagüguwena ga churaragü, rü nanade ga Ngechuchuchiru. Rü yema ãgümücü ga churaragü rü nügümaã nayatoye ga naxchiru. Rü nanayauxgü ta ga norü gáuxü̃chiru ga máxü̃. Natürü taxuwama narüngèi̱xte, yerü woetama yemaãcü naxü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Rü yemacèx ga yema churaragü rü nügümaã ñanagürügü: —¡Tãũtáma nagu tagaugüe! Rü narümemaẽ nixĩ i naxcèx tá naxĩnücèxwẽ́xegü rü ngĩxü̃ tañanagügü i wüxi i dĩẽru na ngẽmawa nüxü̃ icuèxgüxü̃cèx na texéarü tá na yiĩxü̃ —ñanagürügü. Rü yemaãcü ningu ga Tupanaãrü ore ga ümatüxü̃ ga ñaxü̃: “Nügümaã nayatoye i chauxchiru, rü naxcèx ngĩxü̃ tanañanagügü i wüxi i dĩẽru”, ñaxü̃. Rü aixcüma yemaãcü nixĩ ga naxügüãxü̃ ga churaragü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Rü Ngechuchuarü curuchapünewa iyexma ga naẽ ga María, rü ngĩẽyèx, rü María ga Creopá naxmèx, rü María ga Magadácü̱̃ã̱x. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Rü yexguma Ngechuchu naẽxü̃ dèu̱xgu ga yexma chauxü̃tagu na nachixü̃, rü ñanagürü ngĩxü̃: —Pa Mamax, yima nixĩ ya cune, —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Rü yemawena, rü ñanagürü choxü̃: —Ngẽma iyixĩ i cue —ñanagürü. Rü yexgumamama rü chopatawa ngĩxü̃ chayaxu. Rü chauxü̃tawa iyexmaẽcha. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Rü Ngechuchu nüxü̃ nacuèx ga marü na yanguxü̃ ga guxü̃ma ga norü puracü ga ñoma ga naãnewa. Rü yema Tupanaãrü ore ga ümatüxü̃ na yanguxẽẽxü̃cèx, rü ñanagürü: —Chiṯawa —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Rü yéma iyexma ga wüxi ga tü̃xü̃xãcü ga binu ga marü üxchiücümaã ããcuxcü. Rü wüxi ga tüèxmü guma binumaã niwaixẽẽgü, rü wüxi ga dexnemenèxãwa nayanèĩ̱x. Rü yemamaã naã̱xgu nanawẽ́xgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Rü Ngechuchu nayaxaxü ga guma binu ga üxchiücü rü ñanagürü: —Marü ningu i guxü̃ma i chorü puracü —ñanagürü. Rü ñu̱xũchi inayarümaxãchieru, rü nayu. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Natürü ga yema Yudíugüarü ãẽ̱xgacügü rü tama nanaxwèxegü ga curuchagüwa na nayexmagüxü̃ ga yema naxü̃negü. Yerü moxü̃ãcü rü ngü̃xchigaarü ngunexü̃ nixĩ. Rü yema Yudíugücèx rü yema nixĩ ga guxü̃ ga ngü̃xchigaarü ngunexü̃ãrü yexera ga üünexü̃, yerü norü peta ga Üpetüchigaarü ügü nixĩ. Rü yemacèx Piratuna naxcèx nacagü na churaragü yéma namugüxü̃cèx na yapoyeparagüãxü̃cèx na paxa nayuexü̃cèx ga yema curuchawa ipotagüxü̃, rü paxa na nadeãxü̃cèx ga curuchawa naxü̃pa ga ngü̃xchigaarü ngunexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Rü yéma naxĩ ga churaragü rü inanapoeparagü ga yema taxre ga yatügü ga Ngechuchumaã yéma curuchawa ipotagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Rü Ngechuchucèx naxĩ ga churaragü, natürü nüxü̃ nadaugü ga marü na nayuxü̃. Rü yemacèx tama nayapoyeparagü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Natürü wüxi ga churara rü Ngechuchuxü̃ nacanapacütüxü̃. Rü yexgumatama ínayèxüchi ga nagü rü dexá. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Rü choma i Cuáü̃ rü nüxü̃ chadau i guxü̃ma ga ñaã pemaã nüxü̃ chixuxü̃. Rü aixcüma nixĩ i ñaã chorü ore. Rü chomatama nüxü̃ chacuèx i aixcüma na yiĩxü̃, rü pemaã nüxü̃ chixu na pema rü ta peyaxõgüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Rü yema nangupetü na yanguxü̃cèx i Tupanaãrü ore i ümatüxü̃ i ñaxü̃: “Rü taxúnetáma ya naxchinèxã nipoyegü”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Rü toxnamana i Tupanaãrü ore i ümatüxü̃wa rü ñanagürü: “Tá nüxü̃ narüdaunü ya yima nacanapacütüxü̃güãcü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Rü nayexma ga wüxi ga yatü ga Arimatéacü̱̃ã̱x ga Yúchegu ãe̱gacü. Rü nüma rü ta Ngechuchuaxü̃́ nayaxõ, natürü cúãcü nayaxõ yerü natanüxü̃ ga Yudíugüarü ãẽ̱xgacügüxü̃ namuü̃. Rü guma nixĩ ga Piratuna yac̱acü na nayauxãxü̃cèx ga Ngechuchuxü̃ne. Rü Piratu rü: —Ngü̃, —ñanagürü. Rü yexguma ga Yúche rü yéma naxũ ga curuchawa íyapotaxü̃wa, rü curuchawa nayayaxu ga naxü̃ne ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Rü yéma nangu ga Nicodému ga ü̃paacü chütacü Ngechuchuxü̃tagu naxũãnecü. Rü yéma nanange ga 30 kilo naguxü̃ ga pumara ga yixichixü̃ na Ngechuchuxü̃ namaã nachaxünegüxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Rü yemaãcü ga Yúche rü Nicodému rü curuchawa nanayauxgü ga naxü̃ne ga Ngechuchu. Rü naxchiru ga marü pumaracharaxü̃maã nayanáĩxpüxü̃gü. Yerü yema nixĩ ga tocüma ga toma ga Yudíugü ga yexguma wüxi ga yueta tüxü̃ itatèxgügu. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Rü yema nachica ga Ngechuchu curuchawa íipotaxü̃wa nayexma ga wüxi ga nanetünecü. Rü yema nanetünecüwa nayexma ga wüxi ga naxmaxü̃ ga yexwacaxü̃xü̃ ga taguma texéxü̃ nagu natèxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Rü yema naxmaxü̃gu nayaxücuchigü ga Ngechuchuxü̃ne yerü nangaicama, rü paxa tá ningune ga ngü̃xchigaarü ngunexü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Rü yüxüarü pèxmamaxü̃chi ga tauta meã yangóonegu, rü María ga Magadácü̱̃ã̱x rü Ngechuchuxü̃ íyaxücuchigüxü̃wa ixũ. Rü nüxü̃ idau ga guma nuta ga Ngechuchumaxü̃ namaã rüngũxtaü̃cü, rü marü na ínaxügachixü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Rü yexgumatama iiñaãchi, rü yema choma rü Chimáũ ga Pedrumaã ítayexmagüxü̃wa iña. Rü ngĩgürügü toxü̃: —Rü marü nanayauxgü ya Cori ya Ngechuchu i naxmaxü̃wa. Rü tama nüxü̃ tacuèx na ngexta na naxügüãxü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Rü yexguma ga choma rü Pedru rü Ngechuchuxü̃ íyaxücuchigüxü̃wa taxĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Rü wüxigu itaxü̃ãchi ga tomax, natürü ga choma rü poraãcü Pedruarü yexera ichañaãchi. Rü chaxira Ngechuchuxü̃ íyaxücuchixü̃wa changu. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rü ichayarümaxãchi na nagu chidaucuchixü̃cèx. Rü nüxü̃ chadau ga naxchiru ga namaã yanáĩxpüxü̃güãxü̃ ga yexma na naxüxü̃. Natürü tama aixepegu chaxücu. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Rü choweama ínangu ga Chimáũ ga Pedru. Rü nüma rü yema naxmaxü̃gu naxücu. Rü nüma rü ta nüxü̃ nadau ga yema naxchiru ga namaã yanáĩxpüxü̃chiréxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Rü nüxü̃ nadau ta ga naxchiru ga namaã yanèĩ̱xẽrugüãxü̃ ga meãma dixcumüxü̃ ga nüxrüguma üxü̃. Rü tama wüxigu namaã nanu ga yema naxchiru ga namaã yanáĩxpüxü̃güãxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Rü yexguma ga choma ga chaxiraxüchi yéma na changuxü̃, rü choma rü ta chixücu. Rü nüxü̃ chadau ga guxü̃ma, rü chayaxõ ga Ngechuchu rü marü wena na namaxü̃xü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yerü noxri rü tama nüxü̃ tacuèxgüéga ga yema Tupanaãrü ore ga ümatüxü̃ ga ñaxü̃: “Cristu rü tá wena namaxü̃”, ñaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Rü yexguma ga toma rü tochiü̃cèx tawoegu. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Natürü ga María rü yexma irüxã̱ũ̱x naxü̃tagu ga Ngechuchumaxü̃. Rü yéma ixaxu. Rü naxauxãcüma iyarümaxãchi, rü nagu iyadaucuchi ga naxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Rü nüxü̃ idau ga taxre ga daxũcü̱̃ã̱x ga Tupanaãrü orearü ngeruü̃gü ga icómüchiruxü̃. Rü Ngechuchuxü̃ne ixüchiréxü̃wa narütogü, rü wüxi ga Ngechuchueru ixüxü̃waama rü to ga nacütawaama. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Rü yema daxũcü̱̃ã̱x ga duü̃xü̃gü rü ngĩxna nacagüe, rü ñanagürügü: —Pa Ngecüx, ¿ṯacücèx cuxaxu? —ñanagürügü. Rü ngĩma rü inangãxü̃, rü ngĩgürügü: —Chaxaxu erü nayangegü i naxü̃ne ya chorü Cori, rü tama nüxü̃ chacuèx na ngexta naxügüãxü̃ —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Rü yexgumatama yema ngĩxgu, rü ngĩgüweama idau. Rü nüxü̃ idau ga Ngechuchu ga ngĩxü̃tawa na nayexmaxü̃. Natürü tama nüxü̃ icuèx ga Ngechuchu na yiĩxü̃ ga guma. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Rü yexguma ga Ngechuchu rü ngĩxna naca, rü ñanagürü: —Pa Ngecüx, ¿ṯacücèx cuxaxu? ¿Rü texécèx nixĩ i cudauxü̃? —ñanagürü. Rü ngĩma nüxü̃ nacuèxgu rü yema nixĩ ga yema nanetünecüarü dauruü̃. Rü yemacèx ngĩgürügü nüxü̃: —Pa Corix, ega cuma cuyangexgu i naxü̃ne ya Ngechuchu, rü ¡chomaã nüxü̃ ixu na ngexta na cunaxüxü̃ na choma chayayaxuxü̃cèx! —ngĩgürügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Rü yexguma ga Ngechuchu rü ñanagürü ngĩxü̃: —Pa Maríax —ñanagürü. Rü ngĩma rü naxcèx idaueguãchi, rü togawa ngĩgürügü nüxü̃: —Pa Rabunix —ngĩgürügü. Rü ngẽma rü “Pa Ngúexẽẽruü̃x”, ñaxü̃chiga nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Rü Ngechuchu rü ñanagürü ngĩxü̃: —¡Tãxṹ i choxü̃ quingõgüxü̃, erü tauta Chaunatüxü̃tawa chaxũ! ¡Natürü nge̱ma chaueneẽgütanüwa naxũ rü namaã nüxü̃ yarüxu na choma rü tá Chaunatü ya chorü Tupana ya Penatü ya perü Tupanaxü̃tawa chaxũxü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Rü yexguma ga María ga Magadácü̱̃ã̱x rü tomaã nüxü̃ iyarüxu ga marü nüxü̃ na nadauxü̃ ga Cori ga Ngechu-chu. Rü ñu̱xũchi tomaã nüxü̃ iyaxu ga yema ore ga Ngechuchu ngĩmaã nüxü̃ ixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Rü yema yüxüarü ngunexü̃ãrü chütacü, rü tangutaquẽ́xegü ga toma ga Ngechuchuarü ngúexü̃gü. Rü togü tarüwãtaü̃gü, yerü yema Yudíugüarü ãẽ̱xgacügüxü̃ tamuü̃ẽ. Rü Ngechuchu rü ngürüãchi yéma nango̱x, rü torü ngãxü̃tanügu nachi. Rü toxü̃ narümoxẽ, rü ñanagürü: —¡Petaãẽgü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Rü yema ñaxguwena rü toxü̃ nügü nawémẽ́x, rü nügü inawépacütüxü̃. Rü tomagü ga norü ngúexü̃gü rü tataãẽgü, yerü nüxü̃ tadaugü ga guma torü Cori. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Rü yexguma rü wenaxãrü ñanagürü toxü̃: —¡Petaãẽgü! Rü yema Chaunatü núma choxü̃ na muxü̃rüü̃ tátama nixĩ i pexü̃ chamuxü̃ i chomax —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Rü yexguma rü toétü “cue” ñanagürü ga Ngechuchu. Rü ñu̱xũchi ñanagürü toxü̃: —¡Penayauxgü i Tupanaãẽ i Üünexü̃! ");
INSERT INTO tcaNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Rü ngẽxguma duü̃xü̃gü nüxü̃ rüxoegu i norü pecadugü, rü pema rü pexü̃́ nangẽxma i pora na namaã nüxü̃ pixuxü̃ na Tupana marü nüxü̃́ nüxü̃ rüngümaxü̃ i norü pecadugü. Natürü ngẽxguma duü̃xü̃gü tama nüxü̃ rüxoegu i norü pecadugü, rü pema rü pexü̃́ nangẽxma i pora na namaã nüxü̃ pixuxü̃ na marü ngẽma norü pecadugüwatama nangẽxmagüxü̃ —ñanagürü ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Natürü totanüxü̃ ga Tumachi ga Wüxigu Buexü̃maã taxugüxü̃, rü tama totanüwa nayexma ga yexguma Ngechuchu toxcèx ngo̱xgu. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Rü yixcama ga toma rü Tumachimaã nüxü̃ tixugüe, rü ñatarügügü: —Marü nüxü̃ tadau ya tórü Cori ya Ngechuchu —ñatarügügü. Natürü ga Tumachi rü toxü̃ nangãxü̃ rü ñanagürü: —Ngẽxguma tama nüxü̃ chadèu̱xgu i norü itapuamaxü̃ i naxmẽ́xwa rü tama nüxü̃ chingõgügu i ngẽma itapuamaxü̃ rü ngẽma norü cana-pacütüxü̃, rü tãũtáma chayaxõ i ngẽma ore i chomaã nüxü̃ pixuxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Rü 8 ga ngunexü̃guwena rü wenaxãrü tangutaquẽ́xegü ga toma ga wüxi ga ĩpatawa. Rü totanüwa nayexma ga Tumachi ga yexguma. Rü woo ga na nawãxtaxü̃ ga ĩã̱x, rü ngürüãchi yéma nango̱x ga Ngechuchu, rü torü ngãxü̃tanügu nachi. Rü toxü̃ narümoxẽ, rü ñanagürü: —¡Petaãẽgü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Rü yexguma Tumachixü̃ ñanagürü ga Ngechuchu: —¡Nüxü̃ ingõgü i ñaã chorü itapuamaxü̃ i cho̱xmẽ́xwa ngẽxmaxü̃, rü nüxü̃ nadau ya daa cho̱xmẽ́x! ¡Rü nuxa chorü canapacütüxü̃gu ingõgü! ¡Rü nüxü̃ rüxo na tama cuyaxõxü̃! ¡Rü meãma yaxõ i ñu̱xmax! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Rü yexguma ga Tumachi rü Ngechuchuxü̃ nangãxü̃, rü ñanagürü: —Pa Chorü Corix, cuma nixĩ i chorü Tupana quiĩxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Rü Ngechuchu rü ñanagürü nüxü̃: —Pa Tumachix, cuma cuyaxõ i ñu̱xma erü choxü̃ cudau. Natürü tataãẽgü ya yíxema tama choxü̃ daugüãcüma yaxõgüxe —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Rü Ngechuchu rü topẽ́xewa nanaxü ga muxü̃ma ga to ga mexü̃gü ga cuèxruü̃gü i tama ñaã poperagu ümatüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Natürü guxü̃ma i ñaã poperagu ümatüxü̃, rü naxümatü na peyaxõgüxü̃cèx na Ngechuchu rü Cristu ya Tupana Nane na yiĩxü̃. Rü ngẽxguma nüxü̃́ peyaxõgügu rü tá pexü̃́ nangẽxma i maxü̃ i taguma gúxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Rü yemawena ga Ngechuchu rü wenaxãrü toxcèx nango̱x naxtaxa ga Gariréaanacüwa. Rü Tibéria nixĩ ga to ga nae̱ga. Rü ñaãcü nixĩ ga toxcèx nangóxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Rü wüxiwa tayexmagü ga choma rü Chaü̃tiágu ga Zebedeu nanegü rü Chimáũ ga Pedru, rü Tumachi ga Wüxigu Buexü̃maã taxugüxü̃, rü Natanae̱ ga Gariréaanegune ga ĩãne ga Canácü̱̃ã̱x, rü to ga taxre ga tomücügü ga Ngechuchuarü ngúexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Rü Chimáũ ga Pedru rü ñanagürü toxü̃: —Tá chayapüchae —ñanagürü. Rü yexguma ga toma rü tanangãxü̃gü, rü ñatarügügü nüxü̃: —Toma rü tá ta cuwe tarüxĩ —ñatarügügü. Rü yéma taxĩ, rü wüxi ga nguegu tichoü̃. Natürü yema chütaxü̃gu rü taxuü̃ma ga choxni tiyauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Rü yexguma noxri yangóonegu rü Ngechuchu toxcèx nango̱x ga naxtaxaanacüwa. Natürü ga toma rü tama nüxü̃ tacuèxgü ga Ngechuchu na yiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Rü yexguma ga Ngechuchu rü toxna naca, rü ñanagürü toxü̃: —Pa Ngextü̱xücügüx, ¿ẽ́xna taxuü̃ma i choxni piyauxgü? —ñanagürü. Rü toma rü tanangãxü̃gü rü ñatarügügü: —Taxuü̃ma —ñatarügügü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Rü yexguma ga Ngechuchu rü ñanagürü toxü̃: —¡Peweü̃ãrü tügünecüwawaama penatáe i perü pücha! rü tá ípenayauxü̃ i choxni —ñanagürü. Rü yémaãma tanatáegü ga torü pücha, rü taxucürüwa ítanatúãchigü, yerü muxũchixü̃ ga choxni tiyauxgü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Rü yexguma ga choma rü Pedruxü̃ ñacharügü: —Yima nixĩ ya Cori ya Ngechuchu —ñacharügü. Rü yexguma yemaxü̃ naxĩnügu ga Pedru ga guma na yiĩxü̃ ga Cori, rü nicu̱xcuchi ga naxchiru yerü noxri rü ínacu̱xuchichirẽ́x. Rü natüchiüwa nayuxu, rü naxãnacüwa naxcèx nawẽxẽ. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Rü toma ga natanüxü̃ rü nguemaãtama naxãnacüwa taxãgü. Rü yéma tanatúgü ga yema pücha ga choxnimaã ããcuxü̃ yerü 100 metruxicatama nataxu ga na naxãnacüwa na tangugüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Rü yexguma nguewa ítachoü̃gu rü yéma nüxü̃ tadau ga wüxi ga üxü, rü naxẽtügu naxü ga wüxi ga choxni. Rü yéma nayexma ta ga wüxi ga pãũ. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Rü Ngechuchu rü ñanagürü toxü̃: —¡Nuãta penge i ñuxre i ngẽma choxni i ípeyauxü̃xü̃! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Rü Chimáũ ga Pedru rü nguegu nixüe. Rü yema püchamaã naxnücügu ínanatúãchiwetaü̃ ga choxni ga ínayauxü̃xü̃. Rü 153 ga choxni ga itaxü̃ nayexma nawa ga yema pücha. Rü woo ga na namuxũchixü̃, rü tama narügáu ga pücha. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Rü yexguma ga Ngechuchu rü ñanagürü toxü̃: —¡Nuã pexĩ rü peyachibüe! —ñanagürü. Rü taxúema ga toma rü nüxna tacaxchaü̃ na texé yiĩxü̃ ga nümax, yerü marü nüxü̃ tacuèxgü ga guma na yiĩxü̃ ga Cori ga Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Rü yexguma ga Ngechuchu rü yéma toxü̃tawa naxũ. Rü nanayaxu ga pãũ rü wüxichigü toxna nanaxã. Rü yexgumarüü̃ ta ga choxni rü toxna nanaxã. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Rü yema nixĩ ga norü tomaẽ̱xpü̱xcüna ga toxcèx na nangóxü̃ ga Ngechuchu ga yuwa ínadaxguwena. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Rü yexguma chibüewa tingugüguwena rü Ngechuchu rü Chimáũ ga Pedruna naca, rü ñanagürü: —Pa Chimáũ Pa Cuáü̃ Nanex, ¿aixcüma choxü̃ cungechaü̃xü̃ i ñaã cumücügüxü̃ na cungechaü̃xü̃ãrü yexera? —ñanagürü. Rü Pedru nanangãxü̃, rü ñanagürü: —Ngü̃, Pa Corix, cuma nüxü̃ cucuèx na cuxü̃ changechaü̃xü̃ —ñanagürü. Rü Ngechuchu rü ñanagürü nüxü̃: —¡Nachibüexẽẽ i chorü duü̃xü̃gü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Rü wenaxãrü Pedruna naca, rü ñanagürü: —Pa Chimáũ Pa Yoná Nanex, ¿aixcüma i choxü̃ cungechaü̃xü̃? —ñanagürü. Rü Pedru nanangãxü̃, rü ñanagürü: —Ngü̃, Pa Corix, cuma nüxü̃ cucuèx na cuxü̃ changechaü̃xü̃ —ñanagürü. Rü Ngechuchu rü ñanagürü nüxü̃: —Ẽcü, ¡nüxna nadau i chorü duü̃xü̃gü! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Rü norü tomaẽ̱xpü̱xcüna wenama Pedruna naca, rü ñanagürü: —Pa Chimáũ Pa Yoná Nanex, ¿aixcümaxü̃chi yiĩxü̃ i choxü̃ cungechaü̃xü̃? —ñanagürü. Rü yexguma ga Pedru rü düxwa nangechaü̃, yerü norü tomaẽ̱xpü̱xcüna Ngechuchu nüxna naca ngoxi aixcüma nüxü̃ nangechaü̃. Rü ñanagürü ga Pedru: —Pa Corix, cuma nüxü̃ cucuèx i guxü̃ma. Rü cuma nüxü̃ cucuèx na aixcümaxü̃chi cuxü̃ changechaü̃xü̃ —ñanagürü. Rü Ngechuchu ñanagürü nüxü̃: —Ẽcü ¡nachibüexẽẽ i chorü duü̃xü̃gü! ");
INSERT INTO tcaNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","—Rü aixcüma cumaã nüxü̃ chixu rü yexguma cungextü̱xügu rü cugü quicu̱xcuchi ga na ngextá cuma ícunaxwèxexü̃wa cuxũxü̃cèx. Natürü ngẽxguma yaguã̱x quixĩgu rü tá quixuuchichacüü na togue cuxü̃ icu̱xcuchixü̃cèx. Rü ngẽma tama cuma ícunaxwèxexü̃wa tá cuxü̃ nagagü —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Rü Ngechuchu rü yema ñanagürü na nüxü̃ nüxü̃ nacuèxẽẽxü̃cèx ga ñuxãcü tá na nayuxü̃ ga Pedru na yemaãcü Tupanaxü̃ nataxẽẽxü̃cèx. Rü yemawena ga Ngechuchu rü ñanagürü nüxü̃: —¡Chowe rüxũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Rü yexguma nügüweama nadèu̱xgu ga Pedru rü choxü̃ nadau ga naweama na ne chaxũxü̃. Rü chomachirẽ́x nixĩ ga chibüwa Ngechuchucüwawa charütoxü̃ rü nüxna chac̱axü̃ rü ñachaxü̃: “Pa Corix, ¿texé tá tixĩ ya yíxema bexma cuechita cuxü̃ íxuaxü̃xẽ?” ñachaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Rü yexguma Pedru choxü̃ dèu̱xgu rü Ngechuchuna naca, rü ñanagürü: —Pa Corix, ¿ñaã Cuáü̃ rü ṯacü tá nüxü̃ üpetüxü̃? —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Rü Ngechuchu nanangãxü̃, rü ñanagürü nüxü̃: —Ngẽxguma choma chanaxwèxegu rü chanamaxẽẽ ñu̱xmatáta wena núma chaxũ. ¿Rü tüxcüxü̃ i nagu curüxĩnüxü̃ i ngema? Rü cuma ¡rü chowe rüxũ! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Rü yexguma yema chomücügü nüxü̃ ĩnüẽgu ga yema chauchiga, rü nagu narüxĩnüe na taxũtáma chayuxü̃. Natürü Ngechuchu rü tama nüxü̃ nixu ga tãxũtáma na chayuxü̃. Natürü ñanagürümare: “Ngẽxguma choma chanaxwèxegu rü chanamaxẽẽ ñu̱xmatáta wena núma chaxũ. ¿Rü tüxcüxü̃ i nagu curüxĩnüxü̃ i ngẽma?”, ñanagürümare. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Rü chomatama nixĩ ga nüxü̃ chadauxü̃ i guxü̃ma i ñaã pemaã nüxü̃ chixuxü̃, rü chomatama nixĩ i pexcèx chanaxümatüxü̃ i ñaã ore. Rü guxãma i toma rü nüxü̃ tacuèx na aixcüma na yiĩxü̃ i ñaã pemaã nüxü̃ chixuxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Rü nayexma ga to ga muxũchixü̃ma ga ṯacü ga Ngechuchu üxü̃. Rü ngẽxguma chi naxümatügu i guxü̃ma ga yema naxüxü̃chiga, rü nagu charüxĩnügu rü tãũ chima ñoma i naãnegu name i ngẽma poperagü i nachiga ümatüxü̃.");
INSERT INTO tcaNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Pa Mecü Pa Teóquirux, nüxĩra chaxümatüxü̃ ga poperawa cumaã nüxü̃ chixu ga guxü̃ma ga Ngechuchu üxü̃ rü duü̃xü̃güxü̃ namaã nangúexẽẽxü̃ ga noxritama inaxügüãgu ga norü puracü ñu̱xmata yema ngunexü̃ ga Tupana daxũguxü̃ ga naãnewa nagaxgu. Rü yexguma tauta daxũguxü̃ ga naãnewa naxũxgu ga Ngechuchu rü nayadexechi ga norü ngúexü̃gü ga yamugüchaü̃xü̃ na Tupanaãrü puracü naxügüxü̃cèx. Rü Tupanaãẽ i Üünexü̃ãrü poramaã nanangúexẽẽ ga yema duü̃xü̃gü, rü namaã nüxü̃ nixu ga ṯacü tá na naxüexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Rü yexguma marü yuwa ínadèxguwena ga nüma ga Ngechuchu rü 40 ga ngunexü̃gu rü nügü nango̱xẽẽxü̃ naxcèx ga norü ngúexü̃gü rü muxü̃ma ga togü ga nüxü̃́ yaxõgüxü̃ na yemaãcü nüxü̃ nacuèxgüxü̃cèx na aixcüma wena namaxü̃xü̃. Rü namaã nüxü̃ nixuchiga na ñuxãcü na yixĩxü̃ i Tupana ãẽ̱xgacü íyixĩxü̃wa. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Rü yexguma yema ngúexü̃gü ga yamugüxü̃tanüwa nayexmagu ga Ngechuchu, rü namaã nüxü̃ nixu ga tama nüxna na ngextá naxĩxü̃cèx ga Yerucharéü̃. Rü ñanagürü nüxü̃: —¡Ípenanguxẽẽx i ngẽma Tupanaãẽ i Üünexü̃ ga Chaunatü pemaã ixunetaxü̃ ga pemaã nüxü̃ chixuchigaxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Aixcüma nixĩ ga Cuáü̃ rü dexáwa duü̃xü̃güxü̃ ínabaiü̃xẽẽxü̃, natürü i pema rü tãũtáma muxü̃ i ngunexü̃ nangupetü na Tupanaãẽ i Üünexü̃ tá pexna nguxü̃ —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Rü yexguma nangutaquẽ́xegügu ga yema norü duü̃xü̃gü, rü Ngechuchuna nacagü, rü ñanagürügü: —Pa Corix, ¿ẽ́xna ñoma tá nixĩ i ngunexü̃ i marü ícunawoxü̃ i nuã Yudíugüchiü̃ãnewa i torü uwanügüarü churaragü na wenaxãrü tomatama namaã itacuáxü̃cèx i ñaã tochiü̃ãne? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Rü Ngechuchu nanangãxü̃, rü ñanagürü: —Pema rü taxucèxma nüxü̃ pecuáxchaü̃ i ñuxgu tá nixĩ i ngẽma ngunexü̃, erü Chaunatüxicatama nüxü̃́ nangẽxma i pora na nüxü̃ naxunetaxü̃ i ngẽma ngunexü̃ i choxna naxcèx pec̱axü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Natürü ngẽxguma pexna nanguxgu i Tupanaãẽ i Üünexü̃, rü tá pexü̃ naporaexẽẽ. Rü tá ípechoxü̃ na nüxü̃ peyarüxugüexü̃cèx i chauchiga i Yerucharéü̃wa, rü guxü̃ma i Yudéaanewa, rü Chamáriaanewa, rü ñu̱xmatáta guxü̃ i naãnewa nangu —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Rü yexguma yema ñaxguwena rü nüxü̃ ínadaunüyane ga norü ngúexü̃gü, rü Tupana rü daxũguxü̃ ga naãnewa Ngechuchuxü̃ naga. Rü wüxi ga caixanexü̃gu nayaxücu, rü yemaãcü tama wenaxãrü nüxü̃ nadaugü. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Rü yexguma Ngechuchuxü̃ ínadaunüyane ga daxũwa na naxũxü̃, rü ngürüãchi natanüwa nango̱x ga taxre ga yatü ga icómüchiruxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Rü ñanagürügü nüxü̃: —Pa Yatügü i Gariréaanecü̱̃ã̱x, ¿tü̱xcüü̃ daxũgu íperüdaunü? Erü daatama Ngechuchu ga petanüwa yexmacü rü ñu̱xma Tupana daxũwa nagacü, rü ngẽma ñu̱xma nüxü̃ na pedauxü̃ na ñuxãcü daxũwa naxũxü̃, rü ngẽmaãcü tátama nixĩ i wena núma naxũxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Rü yema ngúexü̃gü ga Ngechuchu imugüxü̃ na Tupanaãrü puracü naxügüxü̃cèx, rü nüxna ínixĩ ga guma mèxpǘne ga Oríbunecügu ãe̱gane. Rü Yerucharéü̃cèx nawoegu. Rü guma ĩanearü yaxü̃ nüxna ga guma mèxpǘne rü wüxi ga kilómetru nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Rü yexguma Yerucharéü̃ãrü ĩãnewa nangugügu, rü nagu nachocu ga guma ĩ ga nagu napegüne. Rü dauxna naxĩgü naxcèx ga yema ucapu ga taxü̃ ga nagu napegüxü̃. Rü nümagü nixĩ ga Pedru, rü Cuáü̃, rü Chaü̃tiágu, rü Aü̃dré, rü Piripi, rü Tumachi, rü Baturumé, rü Mateu, rü Chaü̃tiágu ga Arupéu nane, rü Chimáũ ga Iporaãẽcüücü, rü Yuda ga Chaü̃tiágu naẽneẽ. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Rü guxü̃ma ga nümagü rü guxü̃guma nangutaquẽ́xegüxü̃ na wüxigu nayumüxẽgüxü̃cèx namaã ga Ngechuchueneẽgü, rü ngĩmaã ga María ga Ngechuchu naẽ, rü ñuxre ga togü ga ngexü̃gü. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Rü guxü̃ma ga yema ngunexü̃gügu rü nangutaquẽ́xegüxü̃ ga yema yaxõgüxü̃. Rü 120 nixĩ. Rü wüxi ga ngunexü̃gu ga Pedru rü inachi ga norü ngãxü̃tanüwa, rü ñanagürü: ");
INSERT INTO tcaNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Pa Chomücügüx, marü ningu ga yema Tupanaãẽ i Üünexü̃ nuxcüma Dabíxü̃ muxü̃ na naxümatüãxü̃cèx nachiga ga Yuda ga namaãrü cuèxruü̃ ixĩxü̃ naxcèx ga yema duü̃xü̃gü ga Ngechuchuxü̃ iyauxgüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","—Rü tatanüxü̃chirẽ́x nixĩ ga Yuda, rü nüma rü ta taxrüü̃ ñaã Tupanaãrü puracüwa napuracü ga noxrix. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","—Natürü nüma ga Yuda rü bexma Ngechuchuxü̃ ínaxuaxü̃. Rü yemacèx ga ãẽ̱xgacügü rü nüxü̃́ nanaxütanü. Natürü yixcama ga Yuda rü naxcèx ínicuèx ga yema chixexü̃ ga naxüxü̃, rü yemacèx nanataeguxẽẽ ga yema dĩẽru. Rü yemawena rü nügü nawẽxnaxã rü naĩtanüwa nügü narütáe. Rü yexguma duü̃xü̃gü nadaexü̃gügu rü inanago, rü niwã́ĩxpütüwe rü ínayixü̃ ga naü̃nüta. Rü yema dĩẽru ga nataeguxẽẽxü̃maã ga ãẽ̱xgacügü rü naxcèx nataxe ga wüxi ga naãne. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","—Rü nüxü̃ nacuáchigagü ga guxü̃ma ga Yerucharéü̃cü̱̃ã̱x, rü yemacèx Achédamagu nanaxüéga ga yema naãne. Rü ngẽma nixĩ i “Nagüchitaü̃” ñaxü̃chiga. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","—Rü Wiyaegüarü poperawa yemachiga nanaxümatü ga Dabí, rü ñanagürü: “Yixrüma rü nge̱ma natá ya napata, rü taxúema nagu pe”, ñanagürü. Rü toxnamana i ngẽma poperawa rü ñanagürü ta: “Rü name nixĩ na togue naxüxü̃ i ngẽma norü puracü”, ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","—Rü nuã tatanüwa nangẽxmagü i ñuxre i yatügü ga guxü̃guma tüxü̃ ümücügüxü̃ ga yexguma tatanüwa nanuxmagu ga Cori ga Ngechuchu. Rü nümagü rü tawe narüxĩ ga noxritama Cuáü̃ Ngechuchuxü̃ íbaiexẽẽgu rü ñu̱xmata yema ngunexü̃ ga daxũguxü̃ ga naãnewa naxũxgu. Rü name nixĩ i ngẽmatanüwa na nayaxuxü̃ i wüxi i Yudachicüüxü̃ na tamücü yiĩxü̃cèx rü tarüü̃ nüxü̃ yaxuxü̃cèx i ñuxãcü wena na namaxü̃xü̃ ya Ngechuchu. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Rü yemawena rü nüxü̃ naxunetagü ga taxre ga yatügü. Rü wüxi nixĩ ga Yúche ga Yuchugu ãe̱gaxü̃ ga Bachabámaã naxugüxü̃. Rü Matía nixĩ ga to. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Rü ñaãcü nayumüxẽgü: —Pa Corix, cuma nüxü̃ cucuèx i guxü̃ma i duü̃xü̃güarü maxü̃. ¡Rü ñu̱xma rü toxü̃ nawẽ́x i ngẽxü̃rüüxü̃ i cuxcèx mexü̃ i ñaã taxrewa na cunamuxü̃cèx rü nüma na naxüãxü̃cèx i ñaã puracü ga Yuda ítáxü̃ ga yexguma norü poxcuwa naxũxgu! —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Rü wüxi ga dĩẽru ga cuèxruü̃ ngĩxü̃ nañanagügü na yemawa nüxü̃ nacuèxgüxü̃cèx ga ngẽxü̃rüüxü̃ ga yema taxre tá na ixücuxü̃. Rü Matíagu nangu na yangucuchixü̃cèx. Rü yexgumatama rü yema 11 ga duü̃xü̃gü ga Ngechuchu imugüxü̃tanügu naxã ga Matía. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Rü nawa nangu ga yema Yudíugüarü peta ga Pẽtecóstegu ãe̱gaxü̃. Rü yema ngunexü̃gu rü guxü̃ma ga yema yaxõgüxü̃ rü wüxi ga nachicawa nangutaquẽ́xegü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Rü ngürüãchi daxũwa ne naxũ ga wüxi ga naga ñoma wüxi ya buanecü ya taxüchicü icuxcugurüü̃, rü guxü̃ne ga guma ĩ ga nawa nayexmagünegu nayaxũga. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Rü naxcèx nango̱x ga üxüema ga ñoma naconügüraü̃xü̃. Rü yema üxüema rü nügüna nixĩgü, rü wüxichigü ga yema yaxõgüxü̃na ninguchigü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Rü guxü̃ma ga yema yexmagüxü̃ rü Tupanaãxẽ ga Üünexü̃ nüxna nangu. Rü yema Naãẽ i Üünexü̃ yadexagüxẽẽxü̃ãcüma inanaxügüe ga to ga nagawachigü na yadexagüxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Rü yema ngunexü̃gügu rü yema petacèx Yerucharéü̃wa nayexmagü ga muxü̃ma ga toxnamana ne ĩxü̃ ga Yudíugü ga Tupanaga ĩnüẽxü̃ ga guxü̃ ga togü ga nachiü̃ãnewa ne ĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Rü yexguma nüxü̃ naxĩnüẽgu ga ñuxãcü na yadexagüxü̃ ga yema yaxõgüxü̃, rü nangutaquẽ́xegü ga muxü̃ma ga yema duü̃xü̃gü ga toxnamana ne ĩxü̃. Rü naḇaixãchiãẽgü yerü yema yaxõgüxü̃ rü wüxichigü ga yema togü ga duü̃xü̃gügawachigü nidexagü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Rü yema na poraãcü naḇaixãchiãẽgüxü̃cèx, rü nügümaã rü ñanagürügü: —¿Tama ẽ́xna Gariréaanecü̱̃ã̱x yixĩgüxü̃ i guxü̃ i ñaã duü̃xü̃gü i tagawa idexagüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","—¿Rü ñuxãcü ẽ́xna i nüxü̃ ixĩnüẽxü̃ i wüxichigü i yixema i taga i nawa iyaexü̃wa na yadexagüxü̃? ");
INSERT INTO tcaNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","—Yixema tixĩgü i Pártiaanecü̱̃ã̱x, rü Médiaanecü̱̃ã̱x, rü Eraṹãnecü̱̃ã̱x, rü Mechopotámiããnecü̱̃ã̱x, rü Yudéaanecü̱̃ã̱x, rü Capadochíaanecü̱̃ã̱x, rü Põtuanecü̱̃ã̱x, rü Áchiaarü naãnecü̱̃ã̱x, rü Piríquiaanecü̱̃ã̱x, rü Paü̃píriaanecü̱̃ã̱x, rü Equituarü naãnecü̱̃ã̱x, rü Díbiaarü naãnecü̱̃ã̱x i Chirenecü̱̃ã̱x. Rü tatanüwa nangẽxma ta i duü̃xü̃gü i Crétaanewa rü Arábiaarü naãnewa ne ĩxü̃. Rü ñuxre i yixema rü Dumacü̱̃ã̱x i Yudíugü tixĩgü. Rü nuã tatanüwa nangẽxma ta i Dumacü̱̃ã̱x i tama Yudíugü ixĩgüxü̃ natürü tacümagu ĩxü̃. Rü guxãma rü nüxü̃ taxĩnüẽ na wüxichigü i tagawachigü na yadexagüxü̃ i ñaã ngúexü̃gü. Rü tagawa tamaã nüxü̃ nixugüe i ñuxãcü na namexẽchixü̃ ya Tupana —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Rü guxü̃ma poraãcü naḇaixãchiãẽgü, rü tama nüxü̃ nacuèxgü ga ñuxãcü na yiĩxü̃ ga yema. Rü nügüna nacagüe, rü ñanagürügü: —¿Ṯacüchiga nixĩ i guxü̃ma i ñaã? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Natürü ga togü rü nüxü̃ nacugüecüraxü̃, rü ñanagürügü: —Nangãxẽmare rü ngẽmacèx nixĩ i ngẽmaãcü yadexagüxü̃ —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Rü yexguma inachi ga Pedru namaã ga yema 11 ga namücügü, rü tagaãcüma ñanagürü: —Pa Yudíugü i nuxma Yerucharéü̃gu naxĩãnexü̃ rü Pa Nuãcü̱̃ã̱xgüx, ¡rü dücax, meã iperüxĩnüẽ i ñaã tá pemaã nüxü̃ chixuxü̃! ");
INSERT INTO tcaNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","—Rü ñaã chomücügü rü tama nangãxẽ i pema nagu perüxĩnüẽxü̃rüü̃, erü pèxmamatama nixĩ rü ngexwacèx 9 arü orawa nangu. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","—Natürü ñaã ñu̱xma nüxü̃ pedauxü̃ nixĩ ga yema Tupanaãrü orearü uruü̃ ga Yoé marü nüxü̃ ixuchigaxü̃ ga yexguma ñaxgux: ");
INSERT INTO tcaNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Rü ñanagürü ya Tupana: ‘Ngẽma nawa iyacuáxü̃ i ngunexü̃gügu rü guxü̃ i duü̃xü̃gütanüwa tá chanamu i Chauãẽ i Üünexü̃, rü penegü rü pexacügü rü tá chauchigagu nidexagü. Rü choma rü tá chayango̱xetüxẽẽ i perü ngextü̱xüxü̃gü rü tá nüxü̃ nadaugü i ngẽma tá nüxü̃ chawéxü̃. Rü perü yaguã̱xgümaã tá chidexa i nanegüwa. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Rü chorü duü̃xü̃gütanüwa tá chanamu i Chauãẽ i Üünexü̃ i ngẽma ngunexü̃gügu, rü tá chauchigagu nidexagü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Rü naãnetüwewa tá ichanawẽ́x i mexü̃gü i taguma nüxü̃ idauxü̃. Rü ñoma i naãnewa tá ichanawẽ́x i cuèxruü̃gü i nagü, rü üxüema, rü taemaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Rü üèxcü rü tá nixoema rü tauemacü rü tá nagürüü̃ naduema naxü̃pa na wenaxãrü núma naxũxü̃ ya Cori. Rü ngẽma ngunexü̃ i nagu núma naxũxü̃, rü wüxi i ngunexü̃ i mexẽchixü̃ tá nixĩ. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Rü guxãma ya yíxema Corina c̱axe na tüxü̃ nangü̃xẽẽxü̃cèx, rü tá tamaxẽ’ ”, ñanagürü ga yema orewa. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Rü ñanagürü ga Pedru: —Pa Duü̃xü̃gü Pa Yudíugüx, ¡iperüxĩnüẽ i ñaã ore! Rü pema rü meãma nüxü̃ pecuèx rü Ngechuchu ga Nacharétucü̱̃ã̱x rü guma nixĩ ga wüxi ga yatü ga Tupana pepẽ́xewa nüxü̃ yaxucü na Nanexü̃chi yiĩxü̃. Rü yemacèx ga Tupana rü norü poramaã nüxü̃ nanaxüxẽẽ ga muxü̃ma ga mexü̃gü rü cuèxruü̃gü ga noxri taguma nüxü̃ idauxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","—Rü Tupana pexna nanamu ga guma Ngechuchu na pecaducèx nayuxü̃cèx yerü yemaãcü nanaxüxchaü̃ ga Tupana, rü yemaãcü nagu narüxĩnü ga noxri tauta naxü̱xgux ga naãne. Rü pema penamu ga yatügü ga tama yaxõgüxü̃ na yayauxgüãxü̃cèx rü curuchawa na yapotagüãxü̃cèx. Rü yemaãcü penayuxẽẽ. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","—Rü woo nayuchirẽ́x natürü tama yexma nayacuèx, yerü Tupana wena nanamaxẽẽ rü ínanadaxẽẽ. Rü yemaãcü ga yema yu rü taxuacüma marü nüxü̃ narüporamaẽẽcha. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","—Yerü ga ãẽ̱xgacü ga Dabí rü Ngechuchuchigagu nidexa, rü ñanagürü: “Guxü̃guma nachauxü̃tagu ya Cori ya Tupana rü choxü̃ narüngü̃xẽẽ na taxucèxma chaxoegaãẽxü̃cèx. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rü yemacèx marü chataãẽ rü taãẽxü̃ ga oremaã chidexa. Rü choma nüxü̃ chacuèx na mexü̃ tá choxü̃ üpetüxü̃ i ngẽxguma chayu̱xgux. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Erü cuma tãũtáma yuexü̃chicawa choxü̃ cutèx, rü tãũtáma cunaxwèxe na yayixixü̃ i chaxune i choma ya Cune ya Üünecü na chiĩxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Marü choxü̃ nüxü̃ cucuèxẽẽ i ñuxãcü tá chanayaxu i maxü̃ i taguma gúxü̃, rü tá poraãcü choxü̃ cutaãẽxẽẽ, erü chomaã tá icurüxã̱ũ̱x”, ñanagürü ga Dabí. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Rü ñanagürü ga Pedru: —Pa Chaueneẽgüx, rü aixcüma pemaã nüxü̃ chixu na nayuxü̃ ga nuxcümaü̃cü ga tórü ãẽ̱xgacü ga Dabí, rü marü inatèx, rü ñu̱xma rü ta tatanüwa nangẽxma i naxmaxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","—Natürü nüma ga Dabí rü wüxi ga Tupanaãrü orearü uruü̃ nixĩ. Rü yemacèx nüxü̃ nacuèx rü wüxi ga nataa tá nixĩ i ãẽ̱xgacü ya Cristuxü̃ ingucuchicü, yerü ga Tupana rü yemaãcü namaã inaxuneta. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","—Rü yemacèx nuxcümaxü̃chima ga Dabí rü ñoma marü nüxü̃ nadauxuchixü̃rüü̃ nüxü̃ nixu rü Cristu rü tá yuwa ínarüda rü tãũtáma naxmaxü̃wa nangẽxmaẽcha rü tãũtáma niyixi i naxü̃ne. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","—Rü ñu̱xma ya Tupana rü marü wena nanamaxẽẽ ga guma Ngechuchu, rü guxãma ga toma rü nüxü̃ tadaugü na wena namaxü̃xü̃, rü ngẽmacèx pemaã nüxü̃ tixuchiga. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","—Rü Tupana rü daxũguxü̃ ga naãnewa nanaga na norü tügünecüwawa yanatoxü̃cèx. Rü Tanatü ya Tupana rü marü nüxna nanamu ga Naãẽ i Üünexü̃ ga nuxcüma nüxü̃ yaxuxü̃ rü tá nuã na namuãxü̃. Rü ñu̱xma ya yima Ngechuchu rü núma totanüwa nanamu i ngẽma Naãẽ i Üünexü̃. Rü ngẽma Naãẽ nuã üxü̃ nixĩ i ñu̱xma nüxü̃ pedauxü̃ rü nüxü̃ pexĩnüẽxü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","—Rü taguma daxũwa naxũ ga Dabí, natürü nümatama rü ñanagürü: “Tupana rü chorü Cori ya Cristumaã nüxü̃ nixu rü ñanagürü: ‘¡Rü chorü tügünecüwawa rüto ñu̱xmatáta cuxmẽ́xwa chanangẽxmagüxẽẽ i curü uwanügü!’ ” ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Rü ñanagürü ga Pedru: —Name nixĩ i guxãma i pema i Yudíugü na nüxü̃ pecuèxgüxü̃ rü guma Ngechuchu ga curuchawa peyapotacü, rü Tupana rü marü perü Cori ya Cristuxü̃ nayaxĩxẽẽ —ñanagürü ga Pedru. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Rü yexguma yemaxü̃ naxĩnüẽgu ga yema duü̃xü̃gü ga yéma yexmagüxü̃, rü poraãcü nanaxi̱xãchiãẽgü. Rü Pedruna nacagüe, rü yema togü ga Pedrumücügüna rü ta nacagüe, rü ñanagürügü: —¿Rü ṯacü tá taxüexü̃ i ñu̱xmax, Pa Toeneẽgüx? —ñanagürügü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Rü Pedru nanangãxü̃, rü ñanagürü: —¡Nüxü̃ perüxoe i pecüma i chixexü̃ rü Tupanacèx pedaugüe rü Ngechuchuégagu ípebaiü̃ na pexü̃́ nüxü̃ nangechaü̃xü̃cèx i perü pecadugü ya Tupana! Rü Tupana tá pexna nanamu i Naãẽ i Üünexü̃. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","—Rü ñaã Tupanaãrü uneta, rü pexcèx nixĩ, rü pexacügücèx, rü guxü̃ i duü̃xü̃gü i yaxü̃wa ngẽxmagüxü̃cèx nixĩ. Erü guxü̃ i duü̃xü̃gü i tórü Cori ya Tupana nügüxü̃tawa naxcèx c̱axü̃cèx nixĩ i ngẽma uneta —ñanagürü ga Pedru. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Rü yema oremaã rü muxü̃ma ga to ga oremaã nayaxucu̱xẽgü ga Pedru, rü ñanagürü: —¡Nüxna pixĩgachi i ngẽma duü̃xü̃gü i chixexü̃ ügüxü̃ na pema rü ta tama chixexü̃ pexügüxü̃cèx! —ñanagürü. ");
INSERT INTO tcaNT_vpl VALUES ("AC2_41"