﻿USE sofia;
DROP TABLE IF EXISTS sofia.tbzsim_vpl;
CREATE TABLE tbzsim_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tbzsim_vpl WRITE;
INSERT INTO tbzsim_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Kuyie nyóó dɔɔ̀ kutenkù kɛ́dɔɔ̀ tiwɛtì nti nɛ̀ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Kɛ̀ kɛtenkɛ̀ í mmɔkɛ kɛ̀ dòmmɛ̀, dɛ̀mɑrɛ̀ í mbo, kɛ̀ do dò nkubinku nku kɛ dò mbì. Kɛ̀ Kuyie nYɑɑ́ nnɔ́nkɛ́ ku ĩ́nkɛ̀ kɛ nɑmpú. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Kɛ̀ Kuyie mbɛ́i nkɛ dɔ̀: Kuwennikuu yɛ̀nní! Kɛ̀ kùu yɛ̀nní. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Kɛ̀ kùu pɛ́nsìrì kuwenniku kɛ́ kù cɑ̃̀ńnɛ́ nɛ̀ dibiìnnì, ");
INSERT INTO tbzsim_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","kɛ́yú kuwenniku kɛ dɔ̀ kuyie, nkɛ́yú dibiìnnì kɛ dɔ̀ kɛyènkɛ̀. Kɛ̀ kuyuokuu buotɛ́ kɛ̀ dikṹnweńnìi buotɛ́. Diyiè ketirì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kɛ̀ Kuyie ndɔ̀: Tiwɛtìi buotɛ́ kɛ́totɛ́ mɛniɛ kɛ̀ miɛ nní ḿbo kɛĩ́nkɛ̀ kɛ̀ mɛtɛ̃mɛ̀ bo kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kù bɛ́i mmɛmmɛ kɛ̀ tiwɛtìi buotɛ́ kɛ́totɛ́ mɛniɛ, miɛ nkɛĩ́nkɛ̀ mɛtɛ̃mɛ̀ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Kɛ̀ kùu yú kɛĩ́nkɛ̀ kɛ dɔ̀ tiwɛtì. Kɛ̀ kuyuokuu buotɛ́ kɛ̀ dikṹnweńnìi buotɛ́. Diyiè dɛ́rì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kɛ̀ Kuyie mbɛ́i nkɛ dɔ̀: Mɛniɛ mmɛ̀ɛ̀ kpɑɑ́ mɛ̀ɛ tíí ndɛ̀mɑrɛ̀ mɑ́ɑ̀, kɛ̀ kɛtenkɛ̀ɛ feitɛ́. Kɛ̀ dɛ̀ɛ dɔɔ̀ kù yɛ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kɛ̀ kùu yú dɛ̀ɛ̀ wɑɑ́nnì kɛ dɔ̀ kɛtenkɛ̀, kɛ́yú mɛniɛ nkɛ dɔ̀ dɑ̀mɛ́ɛ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Kɛ̀ Kuyie ndɔ̀: Titieti nɛ̀ timútì dɛ̀ɛ yɛ̀nní dɛbotí dɛbotí kɛ́mpɛí yɛbɛ. Kɛ̀ dɛ̀ɛ dɔɔ̀ kù yɛ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Timútì nɛ̀ titieti kɛ̀ dɛ̀ɛ yɛ̀nní kɛ́mpɛí dɛ bɛ, dɛ bɛ. Kɛ̀ kùu dɛ̀ pɛ́nsìrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kɛ̀ kuyuokuu buotɛ́ kɛ̀ dikṹnweńnìi buotɛ́. Diyiè tɑ̃ɑ̃́nnì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Kɛ̀ Kuyie nyíɛ́ kɛ́bɛ́i nkɛ dɔ̀: Kuwenniku ḿbo kɛĩ́nkɛ̀ kɛ́mbɑɑ̀tì kɛyènkɛ̀ nɛ̀ kuyie nnɛ̀ yɛmɔ̀rɛ̀ nɛ̀ yɛwe nɛ̀ yɛbie, ");
INSERT INTO tbzsim_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","kɛ́mmí kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀. Kɛ̀ dɛ̀ɛ dɔɔ̀ kù yɛ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Kɛ̀ Kuyie ndɔɔ̀ dɛ̀mɑrɛ̀ dɛ̀dɛ́rɛ̀ dɛ̀ɛ̀ bo mmí, kɛ̀ dɛdiɛrɛ̀ ntú diyiè dìì bo mmí kuyie, kɛ̀ dɛsɑ́m̀pɔ́rɛ̀ ntú otɑ̃̀nkù wèè bo mmí kɛyènkɛ̀, kɛ yíɛ́nɛ̀ siwɑ̃̀ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Kɛ̀ Kuyie ndɛ̀ ɑ̃nnɛ́ kɛĩ́nkɛ̀ kɛ̀ dɛ̀ mmí kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Kɛ̀ dɛ̀ mmí kuyie nnɛ̀ kɛyènkɛ̀, kɛ bɑɑ̀tì kuwenniku nɛ̀ dibiìnnì. Kɛ̀ kùu dɛ̀ pɛ́nsìrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kɛ̀ kuyuokuu buotɛ́ kɛ̀ dikṹnweńnìi buotɛ́. Diyiè nɑɑnnì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kɛ̀ Kuyie ndɔ̀: Dɛsĩ́ntɛ́kpɛrɛ dɛmɔuu buotɛ́ mɛniɛ mmiɛkɛ, kɛ̀ sinɔɔ buotɛ́ kɛ́nhɛintɛ kɛĩ́nkɛ̀, kɛ̀ dɛ̀ɛ dɔɔ̀ kù bɛ́immɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kɛ̀ kùù dɔɔ̀ siyĩĩ diɛsì nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ fòù mɛniɛ mmiɛkɛ, dɛbotí dɛbotí nɛ̀ sinɔɔ sibotí sibotí. Kɛ̀ kùu dɛ̀ pɛ́nsìrì, ");
INSERT INTO tbzsim_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","kɛ́ dɛ̀ pɑ̃ mɛsɑ̀ɑ̀ nkɛ dɔ̀ dɛ̀ɛ piɛ́ kɛ́sṹṹ, nkɛ̀ siyĩĩ sṹṹ mmɛniɛ mmiɛkɛ, kɛ̀ sinɔɔ sṹṹ nkɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kɛ̀ kuyuokuu buotɛ́ kɛ̀ dikṹnweńnìi buotɛ́. Diyiè nummurì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kɛ̀ Kuyie ndɔ̀: Kɛtenkɛ̀ɛ pɛitɛ́ iwũɔ̃ imɔu botí. Icɛ̃wũɔ̃ diɛyì nɛ̀ isɑ́m̀pɔ́ì nɛ̀ ikpɑwũɔ̃ ibotí ibotí nɛ̀ dɛbɑmbɑɑ̀nnɛ̀ dɛbotí dɛbotí. Kɛ̀ dɛ̀ɛ dɔɔ̀ kù yɛ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kɛ̀ Kuyie ndɔɔ̀ iwũɔ̃ ibotí ibotí nɛ̀ icɛ̃wũɔ̃ nɛ̀ dɛbɑmbɑɑ̀nnɛ̀ dɛmɔu. Kɛ̀ kùu dɛ̀ pɛ́nsìrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Kɛ̀ Kuyie ndɔ̀: Tí dɔɔ̀nɛ̀ onìtì kòo nti dònnɛ̀, kɛ́mbɑkɛ́ siyĩĩ nɛ̀ sinɔɔ sìì pùtì kɛĩ́nkɛ̀, nɛ̀ iwũɔ̃ ìì bo kɛtenkɛ̀ nɛ̀ dɛbɑmbɑɑ̀nnɛ̀ dɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kɛ̀ Kuyie ndɔɔ̀ onìtì kòo nkù dònnɛ̀. Kù do dɔ̀ɔ̀ onitidɔ̀ù nɛ̀ onitipòkù nwe. Kù bɛ̀ dɔ̀ɔ̀ kɛ̀ bɛ̀ nkù dònnɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kɛ̀ kùu bɛ̀ pɑ̃ mɛsɑ̀ɑ̀ nkɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Piɛ́nnɛ̀ kɛ́sṹṹ nkɛ́píɛ nkɛtenkɛ̀ kɛmɔu, kɛ́ nkɛ̀ bɑkɛ́, kɛ́mbɑkɛ́ siyĩĩ nɛ̀ sinɔɔ sìì pùtì kɛĩ́nkɛ̀, nɛ̀ iwũɔ̃ imɔu ìì bo kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kɛ̀ Kuyie ndɔ̀: N di duɔ́mmu timútì timɔu tìì pɛí nɛ̀ dɛtie ndɛmɔu dɛ̀ɛ̀ pɛí, kɛ̀ dɛ̀ bo ntú di kó mudiì. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","N duɔ́mmu timútì nɛ̀ titieti kɛ̀ tì bo ntú iwũɔ̃ imɔu nɛ̀ tinɔ̀tì timɔu, nɛ̀ dɛbɑmbɑɑ̀nnɛ̀ dɛmɔu dɛ kó mudiì. Kɛ̀ dɛ̀ɛ dɔɔ̀ kù yɛ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kɛ̀ kùu yɑ̀ kù dɔ̀ɔ̀ dɛ̀ dɛmɔu kɛ́ dɛ̀ pɛ́nsìrì. Kɛ̀ kuyuokuu buotɛ́, kɛ̀ dikṹnweńnìi buotɛ́. Diyiè kuɔ́nnì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Mɛm̀mɛ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ dɛ̀ dɔ̀ɔ̀mɛ̀ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Kuyie mpĩ́ nku tɔ̃mmú mumɔu yɛwe yɛ̀kuɔ̀ ndi, kɛ́om̀pɛ̀ diyiè yiénnì yiè. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kù dì pɑ̃mu mɛsɑ̀ɑ̀ nkɛ dì cɑ̃̀ńnɛ́ kɛ̀ dì tu ku kpɛri, kɛ yɛ̃́ kù dèèmɛ̀ ku tɔ̃mmú mumɔu kɛ òmpɛ̀ diì yiè. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Miɛ m̀botí nku Kuyie ndɔ̀ɔ̀mɛ̀ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀, nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo. Ti Yiɛ̀ nKuyie ndɔ̀ɔ̀ dìì mɔ̀nnì kɛtenkɛ̀ nɛ̀ kɛĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","titieti nɛ̀ timútì dɛ̀ do í bo, ti Yiɛ̀ nKuyie mmu ndo í duɔnní fɛtɑɑfɛ̀, onìtì mu ndo í bo kɛ bo nkuuti. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Mupɑ̃̀ɑ̃ mmɑmù muù do yiɛ̀ní kɛ yɔ́ɔ́rì kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kɛ̀ ti Yiɛ̀ nKuyie ndɔɔ̀ onìtì nɛ̀ mutɑ̃́ɑ̃́, nkɛ́fuutɛ o ɔ̃nnì muyɑɑ́ nkòo mɔɔtɛ mufòmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Kɛ̀ ti Yiɛ̀ nKuyie mbuɔtí dɛtie nkupúú sɑ̀ɑ̀kù Edɛnni, diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀, kɛ́kɑnnɛ kù dɔ̀ɔ̀ wèè nìtì dɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kɛ̀ ti Yiɛ̀ nKuyie nduɔ́ nkɛ̀ dɛtesɑ̀ɑ̀rɛ̀ dɛbotí dɛbotíi yɛ̀nní, kɛ́mpɛí yɛbɛ kɛ̀ yɛ̀ wenni kɛ nɑɑti. Kɛ̀ kùu soó nkupúú cuokɛ̀ mutie mùù duɔ̀ mmufòmmu nɛ̀ mùù yĩ́ɛ̃́kùnko mɛsɑ̀ɑ̀ ǹnɛ̀ mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Kɛ̀ kukó ndiɛkù nyiɛ̀ní Edɛnni kɛ yɔ́ɔ́rì dɛ kó kupúú kɛ́totɛ́ kucɛ mɛ̀nɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Kuketikù yètìrì tu Pisɔ̃ɔ̃ kɛ̀ kù fitɛ́ dihɛì bɛ̀ tu dì Afidɑɑ. Kɛ̀ mɛsɔɔ mbo dɛ kó dihɛì miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","mɛsɔɔ nkperímɛ̀ nɛ̀ tihúúntì fɔ̃ɔ̃ti nɛ̀ yɛtɑ̃́sɑ̀ɑ̀yɛ̀ yɛ̀ɛ̀ donku dɛu. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kɛ̀ kudɛ́ríkù yètìrì tu Kiyɔ̃ɔ̃ kuù fitɛ́ dihɛì bɛ̀ tu dì Kuusi. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kɛ̀ kutɑ̃ɑ̃́nkù kpɛri tú Tikidi, kuù pũɔ̃̀ ndiyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kɛ firì dihɛì bɛ̀ tu dì Asidii, kɛ̀ kunɑɑnkù kpɛri tú Efɑdɑti. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kɛ̀ ti Yiɛ̀ nKuyie nkɑnnɛ onìtì dɛ kó kupúú miɛkɛ kòò bo nkù kuuti kɛ kù bɑ̀ɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ yɛtɑnnɔ̀ kɛ dɔ̀: A bo nɑ kɛ́nyo ndɛtie ndɛmɔu dɛ̀ɛ̀ bo kupúú dɛ kó yɛbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","A nɛ́ bɑ́ɑ́ di mùù yĩ́ɛ̃́kùnko mɛsɑ̀ɑ̀ nnɛ̀ mɛyɛi mmu bɛ, kɑ̀ɑ yɛ̀ di dìì yiè ɑ kumu. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́i nkɛ dɔ̀: Dɛ̀ í wenni onìtì bo mbomɛ̀ omɑ́ɑ̀, m bo ò dɔ̀ɔ̀ wèè yó nhò dònnɛ̀ koò teénnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Kɛ̀ ti Yiɛ̀ nKuyie ntúótɛ́ mutɑ̃́ɑ̃́ nkɛ́dɔɔ̀nɛ̀ iwũɔ̃ imɔu, nɛ̀ tinɔ̀tì timɔu kɛ́duɔ́ nkɛ̀ dɛ̀ nkɔrìní onìtì borɛ̀, kɛ̀ kù bo yɑ̀ ò yóó dɛ̀ yu yɛ̀ɛ̀ yètɛ̀. Bɑ́ dɛ̀, dɛ̀ do dò nkɛ́mmɔkɛmu diyètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Kɛ̀ Adɑmmuu duɔ́ nyicɛ̃wũɔ̃ i yètɛ̀ kɛ́duɔ́ nyikpɑkpɛyi i yètɛ̀, kɛ́duɔ́ nsinɔɔ si yètɛ̀. Ò mɛ nyí mpɛ̀tɛ́ wèè bo nhò dònnɛ̀ koò teénnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kɛ̀ ti Yiɛ̀ nKuyie nduɔ́ nkòo yɛ̃̀ nkɛ́duɔ́, kɛ̀ kùu dɛitɛ kucĩntóo kùmɑ́ɑ̀ kɛ́wɛ̃tɛ kɛ́pɔ̃nnɛ́ tikɔ̃̀ntì, ");
INSERT INTO tbzsim_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","kɛ́túótɛ́ dɛ kó kucĩntóo kɛ́dɔɔ̀nɛ̀ onitipòkù kóò duɔ́ nhonitidɔ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kòo ò yɑ̀ kɛ dɔ̀: ɛ̃̀hɛ̃́ɛ̃̀! Ntɛ wèè tu n kṹɔ̃̀ kó dikɔ̃́ũ̀, n kɔ̃̀ntì kó tikɔ̃̀ntì. Bɛ̀ bo nhò yu kɛ tú onitipòkù kɛ yɛ̃́ Kuyie nhò dɔ̀ɔ̀nɛ̀mɛ̀ onitidɔ̀ù kó dikɔ̃́ũ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Dɛɛ̀ te kòo nitidɔ̀ù bo yóu o cicɛ nɛ̀ o yɔ̃, kɛ́tɑunnɛ̀ o pokù kɛ̀ bɛ̀ɛ nɑɑ́ nhonìtì omɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Onitidɔ̀ù nɛ̀ o pokù bɛ̀ do bo yɛfɔ̃̀kperɛ̀ nyɛ, ifɛi mɛ nyí mbɛ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Fɛwɑ̀ɑ̀fɛ̀ fɛɛ̀ do ciìnɛ̀ tiwɑnwɑntì timɔu ti Yiɛ̀ nKuyie ndɔ̀ɔ̀ tì. Kɛ̀ fɛ̀ɛ bekɛ onitipòkù kɛ dɔ̀: Mɔ́mmuɔ nwe Kuyie nyɛ̃mmɛ̀ di bɑ́ nyo nkupúú kó yɛtebɛ yɛmɔuɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kòo nitipòkùu fɛ̀ tɛ̃̀ńnɛ́ kɛ dɔ̀: Ti yommu kupúú kó yɛtebɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Mutie mùù nɛ́ bo kupúú cuokɛ̀, Kuyie ntú ti bɑ́ɑ́ di mu kó yɛtebɛ, ti ketɛ́ kɛ bɑ́ɑ́ yɛ̀ kɑ̀ɑ́kɛ́. Kɛ̀ ti yɛ̀ di ti bo kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kɛ̀ fɛwɑ̀ɑ̀fɛ̀ dɔ̀: Di í yóó kú bìtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Kuyie nyɛ̃́mu kɛ tú kɛ̀ di yɛ̀ di dìì yiè, di nuɔ ḿbo wéntɛ́, kɛ̀ di kù nɑɑ́nnɛ̀ kɛ́yĩ́ɛ̃́tɛ́ mɛsɑ̀ɑ̀ ǹnɛ̀ mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Kòo nitipòkùu wéntɛ́ kɛ́yɑ̀ yɛtebɛ bo nnɑɑtimɛ̀, kɛ wenni fɛnɔ̀nfɛ̀, kɛ bo nɑ kóò duɔ́ mmɛciì, kɛ́tɔ̃tɛ, kɛ́di kɛ́duɔ́ nho dɔù wèè ò bonɛ̀, kòo di. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kɛ̀ bɛ nuɔ nwéntɛ́, kɛ̀ bɛ̀ɛ bɑntɛ́ bɛ̀ bomɛ̀ yɛfɔ̃̀kperɛ̀, kɛ́wɑɑ́ ntifɑ̃ɑ̃̀tì kɛ́yi. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kuyuoku mɔ̀nnì kɛ̀ ti Yiɛ̀ nKuyie nní nceǹtì kupúú miɛkɛ kɛ nɑ́ɑ́ nkɛ̀ bɛ̀ yo, kɛ́sɔri titieti miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kɛ̀ ti Yiɛ̀ nKuyie nyú onitidɔ̀ù kɛ dɔ̀: A borɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kòo kù tɛ̃̀ńnɛ́ kɛ dɔ̀: N kèè ɑ tɑmmɛ̀ mmɛ kupúú miɛkɛ kɛ̀ kufɔ̃wɑɑ́ nni mpĩ nkɛ̀ n sɔ̀ri, kɛ yɛ̃́ m bomɛ̀ difɔ̃̀kperì. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: We ndɑ nɑ̀kɛ́ kɛ tú ɑ bo difɔ̃̀kperì, yɑ́ɑ̀ ɑ di ditebii n yɛ̃ nhɑ bɑ́ɑ́ di dì ndi? ");
INSERT INTO tbzsim_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kòo nitidɔ̀ù dɔ̀: Onitipòkù ɑ mɛ nni nduɔ́ nwè kɛ̀ ti bo, weè ǹ duɔ́ ndɛ kó ditebii kɛ̀ ǹ di. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kɛ̀ ti Yiɛ̀ nKuyie mbekɛ onitipòkù kɛ dɔ̀: Dɛ̀ yĩ́mɛ kɑ̀ɑ dɔ̀ɔ̀ mɛmmɛ? Kòò dɔ̀: Fɛwɑ̀ɑ̀fɛ̀ fɛɛ̀ ǹ soutɛ́ kɛ̀ ǹ di ditebii. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ fɛwɑ̀ɑ̀fɛ̀ kɛ dɔ̀: Fɔ̃́ɔ̃̀ mɛ ntemɛ̀ kɛ̀ dɛ̀ dɔ̀ɔ̀ miɛ n dɑ cɔ̃ɔ̃mu tiwɑnwɑntì timɔu miɛkɛ, ɑ bo nfũrì ɑ pɔutì, kɛ yo mmutɑ̃́ɑ̃́ nsɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nɛ̀ ɑ bo mbomɛ̀, fɔ̃́ nnɛ̀ onitipòkù di bɑ́ɑ́ nɑrikɛ, o fuku nɛ̀ ɑ kɔku dɛ̀ bɑ́ɑ́ nɑrikɛ. O fuku bo pɔntɛ ɑ yuu, kɑ̀ɑ kɔkuu dɔntɛ́ o nɑcɛ̀nkénnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ onitipòkù kɛ dɔ̀: A pɛitímù bo yonkɛ mɛdiɛ̀. A níí bo fɛ̃́ṹtɛ́ mɛdiɛ̀ nkɛ nɛ́ nɑ kɛ́pɛitɛ́, ɑ bo mbúɔ́ ɑ dɔù kòò dɑ bɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ onitidɔ̀ù kɛ dɔ̀: A mɛ̀ nyiemmɛ̀ ɑ pokù kpɛti kɛ di ditebii n yɛ̃ nhɑ bɑ́ɑ́ di dì. M bo cɔ̃ɔ̃ kɛtenkɛ̀, ɑ níí bo kúútí kɛ́fɛ̃́ṹtɛ́ mɛdiɛ̀ nkɛ nɛ́ nɑ kɛ́pɛ́tɛ́ kɛ́di. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Kɛtenkɛ̀ bo mpɛí ipo nɛ̀ tisɑ̃mpotì, kɑ̀ɑ nyo ndɛpɑɑ nkpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","A níí yóó kɑ̃́tɛ́ mɛyɔ̃́ɔ̃̀ mmɛ kɛ́nɑ kɛ́pɛ́tɛ́ kɛ́di, kɛ yɑ̀ɑ wɛ̃tɛnɛ̀ mutɑ̃́ɑ̃́ mmiɛkɛ n dɑ dɔ̀ɔ̀nɛ̀ mù. N dɑ dɔ̀ɔ̀nɛ̀ mutɑ̃́ɑ̃́ mmu kɑ̀ɑ yóó wɛ̃tɛ kɛ́nɑɑ́ mmutɑ̃́ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Kɛ̀ Adɑmmuu yú o pokù kɛ dɔ̀ Ɛfu, dɛ̀ɛ̀ tu mufòmmu, kɛ yɛ̃́ weè tumɛ̀ bɛnìtìbɛ̀ bɛmɔu yɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kɛ̀ ti Yiɛ̀ nKuyie ńnukú tikɔ̃̀ntì kɛ́ bɛ̀ dɑ̀tínnɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","kɛ́bɛ́i nkɛ dɔ̀: Onìtì nɑɑ́nnɛ̀ tí mbɛ kɛ yɛ̃́ mɛsɑ̀ɑ̀ nnɛ̀ mɛyɛi, ti bɑ́ɑ́ yie nkòo tɔ̃tɛ ditebii dìì duɔ̀ mmufòmmu kɛ́di kɛ́nfòù sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kɛ̀ kùu bɛti onìtì kupúú Edɛnni miɛkɛ, kòo kɔtɛ kɛ́nkúútí kɛtenkɛ̀, kù ò dɔ̀ɔ̀nɛ̀ kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Mɛm̀mɛ ti Yiɛ̀ nKuyie mbɛtimɛ̀ onìtì kupúú Edɛnni miɛkɛ, kɛ́cónnɛ́ bɛĩ́nkɛ̀mbɑ̀rìbɛ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kɛ̀ bɛ̀ mbɑɑ mutie mùù duɔ̀ mmufòmmu, kɛ ɛinko yɛse kɛ̀ yɛ̀ cɔ̀ú nkɛ dò mmuhɑ̃ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Kɛ̀ Adɑmmuu duɔ́nɛ̀ o pokù Ɛfu, kòo púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ kɛ́ dɛ̀ yu kɛ dɔ̀ Kɑyɛ̃ɛ̃, kɛ dɔ̀: Ti Yiɛ̀ nKuyie nkuù te kɛ̀ m̀ pɛitɛ́ onìtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kòo yíɛ́ kɛ́pɛitɛ́ o nɑntɛ̀ Abɛɛdi. Kɛ̀ Abɛɛdi ntú owũɔ̃cɛ̃nti kɛ̀ Kɑyɛ̃ɛ̃ tu otenkútì. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kɛ̀ tidiitìi bi, kɛ̀ Kɑyɛ̃ɛ̃ wɑɑ́ nkɛ́pɑ̃ ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kɛ̀ Abɛɛdi yie tɔní o pedɑkɛ̀ yɛketiyɛ̀ kó dìmɑrì, dìì ɑ̃ mɛkùɔ̀ nkɛ́pɑ̃ ti Yiɛ̀ nKuyie. Kɛ̀ kùu ò pɛ́nsìrì kɛ́cɔutɛ́ o pɑ̃nnì, ");
INSERT INTO tbzsim_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","kɛ́yetɛ Kɑyɛ̃ɛ̃ nɛ̀ o pɑ̃nnì, kòo miɛkɛɛ pɛikɛ mɛdiɛ̀ n kòo ììkɛ̀ɛ sɔutɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kɛ̀ ti Yiɛ̀ nKuyie nhò bekɛ kɛ dɔ̀: Kɑyɛ̃ɛ̃ dɛ̀ dòmmɛ kɑ̀ɑ miɛkɛ pɛikɛ kɑ̀ɑ ììkɛ̀ sɔ̀ùtɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Kɑ̀ɑ dɔ̀ɔ̀ mɛsɑ̀ɑ̀ nhɑ yɛ̀mmɛ̀ yóó nɑrikɛmu, kɑ̀ɑ mɛ ndɔ̀ɔ̀ dɛ̀ɛ̀ í wenni, mɛyɛi mbo ɑ bòrì kɛ dɑ díí, yetoo kɛ́ mɛ̀ nɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Mɛm̀mɛ kɛ̀ Kɑyɛ̃ɛ̃ nɑ́kɛ́ o nɑntɛ̀ Abɛɛdi kɛ dɔ̀: Tí kɔ̃tɛ́. Bɛ̀ kɔ̃tɛ́ dìì mɔ̀nnì kɛ̀ Kɑyɛ̃ɛ̃ pĩ́ nho nɑntɛ̀ Abɛɛdi kɛ́kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kɛ̀ ti Yiɛ̀ nKuyie mbekɛ Kɑyɛ̃ɛ̃ kɛ dɔ̀: Yé ɑ nɑntɛ̀ Abɛɛdi borɛ̀? Kɛ̀ Kɑyɛ̃ɛ̃ dɔ̀: N yí yɛ̃́ tɛ̀ borɛ̀, n túmu n nɑntɛ̀ kóo bɑ̀rɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kɛ̀ Kuyie ndɔ̀: A dɔ̀ɔ̀ bɑ? A nɑntɛ̀ yĩ̀ĩ̀ nkuɔ̀ nkɛtenkɛ̀ kɛ tú ḿ pɛitɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Di mmɔ̀nnì n dɑ cɔ̃ɔ̃mu kɑ̀ɑ bo ítɛ́ kɛ́dɛ́tɛ́nɛ̀ kɛtenkɛ̀ kɛ̀ɛ̀ yɑ̃̀ ɑ nɑntɛ̀ kó mɛyĩ̀ĩ̀ nhɑ kùɔ tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","A níí bo kúútí, ɑ bɑ́ɑ́ dɛitɛ, ɑ bo nfirì tipíìtì timɔu kɛ tú ocièntì. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kɛ̀ Kɑyɛ̃ɛ̃ nɑ́kɛ́ ti Yiɛ̀ nKuyie nkɛ dɔ̀: A n toú ndìì tɔu cɛ̃́ɛ̃̀mu, m bɑ́ɑ́ nɑ kɛ́ dì tɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","A mɛ nni mbɛ̀timɛ̀ yíe nkɛtensɑ̀ɑ̀kɛ̀, kɛ̀ n yóó dɑ dɛ́tɛ́nɛ̀ kɛ́nfirì tipíìtì timɔu kɛ tú ocièntì, kòò mɔù ǹ yɑ̀ ò yó n kuɔmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Dɛ mɔ̀nnì kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Kòò mɔù kùɔ Kɑyɛ̃ɛ̃ m bo pɛitɛ kucɛ mɛ̀yiekɛ̀. Kɛ̀ ti Yiɛ̀ nKuyie ncɑnnɛ Kɑyɛ̃ɛ̃ mɛcɑnnimɛ̀ mɑmɛ̀ mɛ̀ɛ̀ yó nte kɛ̀ wèè ò yɑ̀ ò bɑ́ɑ́ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Kɛ̀ Kɑyɛ̃ɛ̃ ítɛ́ ti Yiɛ̀ nKuyie mborɛ̀, kɛ́kɔtɛ kɛ́mbo bɛ̀ tu dɛ̀ Nɔdi, kupúú Edɛnni, diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Kɛ̀ Kɑyɛ̃ɛ̃ duɔ́nɛ̀ o pokù, kòo púó nkɛ́pɛitɛ́ Enɔki. Kòo mɑɑ́ dihɛì kɛ́ dì yu o birɛ yètìrì kɛ dɔ̀ Enɔki. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kɛ̀ Enɔkii pɛitɛ́ Idɑdi, kɛ̀ Idɑdi pɛitɛ́ Mɛuyɛɛdi. Kɛ̀ Mɛuyɛɛdii pɛitɛ́ Mɛtusɑyɛɛdi, kɛ̀ Mɛtusɑyɛɛdii pɛitɛ́ Demɛki. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Kɛ̀ Demɛkii puokɛ bɛnitipòbɛ̀ bɛ̀dɛ́bɛ̀, kòo ketiwè yètìrì ntú Adɑ, kòo dɛ́rì kpɛri ntú Sidɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adɑ weè do pɛitɛ́ Yɑbɑɑdi bɛ̀ɛ̀ ɑ̃ titouti, kɛ cɛ̃mmù inɑ̀ɑ̀kɛ bɛ yɑ̀ɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yɑbɑɑdi nɑntɛ̀ do tú Yubɑɑdi bɛ̀ɛ̀ bie ntikùtìdùùtì, kɛ eu itɑ̃rí bɛ yɑ̀ɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Kɛ̀ Sidɑ yie múnkɛɛ pɛitɛ́ dɛnitidɑbirɛ, Tubɑɑdi-Kɑyɛ̃ɛ̃, kòo mmɑ́ɑ́tí tinɛntì tibotí tibotí, mɛnɑtimɛ̀ kpɛti nɛ̀ mɛbiɛrimɛ nɛ̀ timɑ́tì. Kòo tɑ̃ũ̀ yètìrì ntú Nɑɑmɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Kɛ̀ Demɛkii nɑ́kɛ́ o pobɛ̀ kɛ dɔ̀: Adɑ nɛ̀ Sidɑ, kéntɛ́nɛ̀ n kpɛti! Díndi Demɛki pobɛ̀ keènɛ̀ n tú mù! Onìtì n kɔ̀ùtɛ kɛ̀ nh ò kùɔ, odɑpɑ̀ɑ̀ nni mpotɛ́ kɛ̀ dɛ̀ mɑ̀tìnnɛ kɛ̀ nh ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kɛ̀ bɛ̀ bo kuɔ bɛnìtìbɛ̀ bɛ̀yiekɛ̀ kɛ́pɛitɛ Kɑyɛ̃ɛ̃ bɑ̀nnì, bɛ̀ bo kuɔ sipísìyiekɛ̀ nɛ̀ bɛ̀yiekɛ̀, kɛ́pɛitɛ m bɑ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Kɛ̀ Adɑmmuu duɔ́nɛ̀ o pokù kòo púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ, kòo dɛ̀ yu kɛ dɔ̀ Sɛti, dɛ̀ɛ̀ tu Kuyie nhò duɔ́ ndɛbirɛ kɛ̀ dɛ̀ còḿmú Abɛɛdi fɔ̃̀tìrì Kɑyɛ̃ɛ̃ do kùɔ wè. ");
INSERT INTO tbzsim_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kɛ̀ Sɛti múnkɛɛ pɛitɛ́ dɛnitidɑbirɛ, kɛ́ dɛ̀ yu kɛ dɔ̀ Enɔsi. Dɛ mɔ̀nnì ndi bɛnìtìbɛ̀ ketɛ́mɛ̀ bɛ̀ bo mbɑ́ɑ́mmɛ̀ Kuyie nkɛ kù yu kɛ tú ti Yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ntɛ Adɑmmu kó kufuku. Kuyie ndɔ̀ɔ̀ dìì mɔ̀nnì onìtì kóò dònnɛnɛ̀ kumɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kù dɔ̀ɔ̀ onitidɔ̀ù nɛ̀ onitipòkù nwe kɛ́ bɛ̀ pɑ̃ mɛsɑ̀ɑ̀, kɛ pɑ̃̀nkɛɛ bɛ̀ yu kɛ dɔ̀ onìtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adɑmmu mɔ̀kɛ dìì mɔ̀nnì yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìtɑ̃ɑ̃ti (130) kɛ́pɛitɛ́ dɛnitidɑbirɛ kɛ̀ dɛ̀ nhò dònnɛ̀ sósó. Kòo dɛ̀ yu kɛ dɔ̀: Sɛti. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adɑmmu pɛitɛ́ dìì mɔ̀nnì Sɛti kɛ́deè, kɛ́nfòù kɛ́tuɔkɛ yɛbie nsikɔusìnì (800), kɛ́piɛ́ initidɑbí nɛ̀ initipobí. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Ò do mɔkɛ yɛbie nsikɔusìwɛi nɛ̀ sipísìtɑ̃ɑ̃ti (930) ndi kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sɛti mɔ̀kɛ dìì mɔ̀nnì yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ yɛ̀nùmmù (105) kɛ́pɛitɛ́ dɛnitidɑbirɛ Enɔsi. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Ò pɛitɛ́ dìì mɔ̀nnì Enɔsi kɛ́deè kɛ́mmɔkɛ yɛbie nsikɔusìni nɛ̀ yɛ̀yiekɛ̀ (807), kɛ́piɛ́ initidɑbí nɛ̀ initipobí pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sɛti do mɔkɛ yɛbie nsikɔusìwɛi nɛ̀ tɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀ (912) ndi kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enɔsi mɔ̀kɛ dìì mɔ̀nnì yɛbie nsipísìwɛi, kɛ́pɛitɛ́ dɛnitidɑbirɛ Kenɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Dɛ kó difɔ̃nkúò kɛ́mɔɔtɛ yɛbie nsikɔusìni nɛ̀ tɛpíítɛ̀ nɛ̀ yɛ̀nùmmù (815) kɛ́piɛ́ initidɑbí nɛ̀ initipobí. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Ò do mɔkɛ yɛbie nsikɔusìwɛi nɛ̀ yɛ̀nùmmù (905) ndi kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kɛ̀ Kenɑnni mmɔkɛ yɛbie nsipísìyiekɛ̀, kɛ́pɛitɛ́ dɛnitidɑbirɛ Mɑdɑdeyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Dɛ kó difɔ̃nkúò kɛ́mmɔkɛ yɛbie nsikɔusìni nɛ̀ sipísìnɑ̀ɑ̀ (840), kɛ́piɛ́ initidɑbí nɛ̀ initipobí. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Ò do mɔkɛ yɛbie nsikɔusìwɛi nɛ̀ tɛpíítɛ̀ (910) ntɛ kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mɑdɑdeyɛɛdi do mɔkɛ yɛbie nsipísìkuɔ̀ nɛ̀ yɛ̀nùmmù ndi, kɛ́pɛitɛ́ dɛnitidɑbirɛ Yederi. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Ò pɛitɛ́ Yederi kɛ́deè, kɛ́mmɔkɛ yɛbie nsikɔusìni nɛ̀ sipísìtɑ̃ɑ̃ti (830), kɛ́wɛ̃tɛ kɛ́piɛ́ initidɑbí nɛ̀ initipobí pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Ò do mɔkɛ yɛbie nsikɔusìni nɛ̀ sipísìwɛi nɛ̀ yɛ̀nùmmù (895) ndi kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Kɛ̀ Yederi mmɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìkuɔ̀ nɛ̀ yɛ̀dɛ́ɛ̀ (162), kɛ́pɛitɛ́ dɛnitidɑbirɛ Enɔki. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Ò pɛitɛ́ Enɔki kɛ́deè kɛ́yíɛ́ kɛ́mɔɔtɛ yɛbie nsikɔusìni (800), yɛ miɛkɛ nkɛ ò piɛ́mɛ̀ initidɑbí nɛ̀ initipobí pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Ò do mɔkɛ yɛbie nsikɔusìwɛi nɛ̀ sipísìkuɔ̀ nɛ̀ yɛ̀dɛ́ɛ̀ (962) ndi kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Kɛ̀ Enɔki mmɔkɛ yɛbie nsipísìkuɔ̀ nɛ̀ yɛ̀nùmmù kɛ́pɛitɛ́ dɛnitidɑbirɛ Mɑtusɑdɛmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Ò pɛitɛ́ Mɑtusɑdɛmmu kɛ́deè, kɛ́mmɔkɛ yɛbie nsikɔusìtɑ̃ɑ̃ti (300), kɛ́ntɑunɛ̀ Kuyie, kɛ́piɛ́ initidɑbí nɛ̀ initipobí pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Ò do mɔkɛ yɛbie nsikɔusìtɑ̃ɑ̃ti nɛ̀ sipísìkuɔ̀ nɛ̀ yɛ̀nùmmù (365) ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Ò do tɑunɛ̀ Kuyie nku, kɛ̀ kùu ò tùótɛ́ kɛ́kònnɛ̀ ku ciɛ kɛ̀ bɛ̀ɛ ò mɔ̀ńtóo. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Mɑtusɑdɛmmu do mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìni nɛ̀ yɛ̀yiekɛ̀ (187) ndi kɛ́pɛitɛ́ dɛnitidɑbirɛ Demɛki. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Ò pɛitɛ́ Demɛki kɛ́deè kɛ́mmɔkɛ yɛbie nsikɔusìyiekɛ̀ nɛ̀ sipísìni nɛ̀ yɛ̀dɛ́ɛ̀ (782), kɛ́piɛ́ initidɑbí nɛ̀ initipobí pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Ò do mɔkɛ yɛbie nsikɔusìwɛi nɛ̀ sipísìkuɔ̀ nɛ̀ yɛ̀wɛi (969) ndi kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Kɛ̀ Demɛki mmɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìni nɛ̀ yɛ̀dɛ́ɛ̀ (182), kɛ́pɛitɛ́ dɛnitidɑbirɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","kɛ́ dɛ̀ yu kɛ dɔ̀ Nɔwee, kɛ́nnɑ́ɑ́ nkɛ tú: Yie nweè yóó ti bɑ́ntɛ̀ nɛ̀ mutɔ̃mmú ti pĩ́ mmù yɛwe yɛmɔu, kɛ yɛ̃́ ti Yiɛ̀ nKuyie ncɔ̃ɔ̃mɛ̀ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Ò pɛitɛ́ Nɔwee kɛ́deè, kɛ́wɛ̃tɛ kɛ́mɔɔtɛ yɛbie nsikɔusìnùmmù nɛ̀ sipísìwɛi nɛ̀ yɛ̀nùmmù (595), kɛ́piɛ́ initidɑbí nɛ̀ initipobí pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Ò do mɔkɛ yɛbie nsikɔusìyiekɛ̀ nɛ̀ sipísìyiekɛ̀ nɛ̀ yɛ̀yiekɛ̀ (777) ndi kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nɔwee do yóó mɔɔtɛ initidɑbí ìtɑ̃ɑ̃ti ìì yètɛ̀ tu Sɛmmu nɛ̀ Kɑmmu nɛ̀ Sɑfɛti kɛ mɔkɛ yɛbie nsikɔusìnùmmù (500) ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Bɛnìtìbɛ̀ sũ̀ṹ ndìì mɔ̀nnì kɛtenkɛ̀ ĩ́nkɛ̀ kɛ́piɛ́ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Kɛ̀ kɛĩ́nkɛ̀ kó bɛkperíbɛ̀ɛ yɑ̀ dɛ kó bɛsɑpɑ̀mbɛ̀ wennimɛ̀ mɛsɑ̀ɑ̀, kɛ́tɑ̃nkɛ́ bɛ̀ dɔ́ bɛ̀, kɛ́puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: M bɑ́ɑ́ yóu kɛ̀ bɛnìtìbɛ̀ biɛ nní nfòù kɛ́mɔntɛ, bɛ̀ tu bɛnìtìbɛ̀ mbɛ, bɛ̀ bo mmɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìdɛ́ (120) kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Tidɑdiɛtì tiì do bo dɛ mɔ̀nnì kɛ́nsɔkɛ́ kɛ bo. Kɛĩ́nkɛ̀ kó bɛkperíbɛ̀ do kɔ̀tɛní kɛ́duɔ́nɛ̀ bɛsɑpɑ̀mbɛ̀ kɛ̀ bɛ̀ɛ piɛ́ tìnti, tiì do nɔ ndɛmɔu kɛ̀ ti yètɛ̀ feí. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Kɛ̀ ti Yiɛ̀ nKuyie nyɑ̀ bɛnìtìbɛ̀ borimɛ í wennimɛ̀ kɛ̀ bɛ̀ bɑɑ dɔ́ kɛ́ndɔɔri mɛyɛi nsɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Kɛ̀ ti Yiɛ̀ nKuyie nyɛ̀mmɛ̀ɛ cɑɑ̀rɛ̀ kɛ̀ kùu demmu kù dɔ̀ɔ̀mɛ̀ onìtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: M bo kuɔ bɛnìtìbɛ̀ n dɔ̀ɔ̀ bɛ̀, kɛ́kuɔ iwũɔ̃ diɛyì nɛ̀ isɑ́m̀pɔ́ì nɛ̀ sinɔɔ, n dèmmumu n dɛ̀ dɔ̀ɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kɛ̀ Nɔwee yie mɛ mpɛ́tɛ́ mɛsɑ̀ɑ̀ nti Yiɛ̀ nKuyie mborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nɔwee do tú onitisɑ̀ù nwe kɛ dɔɔri Kuyie ndɔ́mɛ̀ kɛ kù tũ, ");
INSERT INTO tbzsim_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","kɛ́pɛitɛ́ initidɑbí ìtɑ̃ɑ̃ti: Sɛmmu nɛ̀ Kɑmmu, nɛ̀ Sɑfɛti. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Dɛ kó dimɔ̀nnì bɛnìtìbɛ̀ do dɔrimu, kɛ mɛ̀nkɛ dɔri mɛdiɛ̀ mbɑ́ dɛ̀ í nnɑɑti Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Kɛ̀ kùu wéntɛ́ kutenkù kɛ́nsɔ̃́ nkù cɑ̀ɑ̀rɛ̀, kɛ̀ bɛnìtìbɛ̀ bɛmɔu dɔ̀ri bɑ́ bɛ borimɛ í wenni. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kɛ̀ Kuyie nnɑ́kɛ́ Nɔwee kɛ dɔ̀: M bo kuɔ dì mmɔ̀nnì bɛnìtìbɛ̀ bɛmɔu bɛ̀ dɔ̀nnɛmu, kɛ̀ bɛ yonku dɛukɛ, m bo bɛ̀ kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Á dɔɔ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ nɛ̀ idɛí ìì kpeńnì, kɛ́cíékɛ́ tidieti kɛ̀ tì nsũ, kɛ́wɑɑ́ mmumɔ̀mmu kɛ́fiɛtí mɛfíè ntɛ miɛkɛ nɛ̀ tɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ntɛ ɑ yóó tɛ̀ dɔ̀ɔ̀ mɛ̀ɛ̀ botí: Tɛ okùmɛ̀ ḿbo mɛ́tìrì tɛkɔ̀ùtɛ̀ nɛ̀ sipísìnùmmù (150), mɛpɛ̃kùmɛ̀ mɛ́tìrì sipísìdɛ́ nɛ̀ bɛ̀nùmmù, mɛcómmɛ̀ mɛ́tìrì tɛpíítɛ̀ nɛ̀ bɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Á tɛ̀ dɔ̀ɔ̀ kɛ́pĩ́ĩ́ ntipĩ́mpĩ́ntì nɛ̀ kumɑrí dɛ cuokɛ̀, kɛ̀ mɛfíè nní nfeí kɛ mɑ̀nnɛ̀ mɛ́tìrì kó dikéè. Kɑ̀ɑ keutɛ́ dibòrì tɛ píkù, kɛ́ɑ̃nnɛ́ timùmmùntì tìtɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Dɛ mɔ̀nnì m bo duɔ́ nkɛ̀ fɛtɑɑfɛ̀ɛ ni kɛ̀ mɛniɛ mpíɛ nkɛ́kuɔ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ fòù kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Dɛ mɔ̀nnì m bo dɑ dɔɔ̀nɛ̀ mɛtɑummɛ̀ kɑ̀ɑ tɑ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ miɛkɛ nɛ̀ ɑ pokù nɛ̀ ɑ bí nɛ̀ i pobɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Á tɑnnɛ́ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ fòù kɛtenkɛ̀ ĩ́nkɛ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ miɛkɛ, dɛdɑɑrɛ̀ nɛ̀ dɛniirɛ kɛ̀ dɛ̀ɛ yentɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tiwɑnwɑntì timɔu botí nɛ̀ iwũɔ̃ dɛdɑɑrɛ̀ nɛ̀ dɛniirɛ, sinɔɔ diɛsì nɛ̀ sisɑ́m̀pɔ́sì, nɛ̀ dɛbɑmbɑɑ̀nnɛ̀ dɛbotí dɛbotí, dɛ̀ yóó kɔtɛnímu ɑ borɛ̀ kɛ bo yentɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Á wɑɑ́ mmudiì mubotí mubotí, ɑ kɔ̃mu nɛ̀ tiwɑnwɑntì kɔ̃mu kɛ̀ dí nyo. ");
INSERT INTO tbzsim_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kɛ̀ Nɔwee yie nkɛ́dɔɔ̀ Kuyie nhò nɑ̀kɛ́ tì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Nɔwee kɛ dɔ̀: Tɑ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ fɔ̃́ nnɛ̀ ɑ cĩ́ɛ̃̀tɛ̀ kɔbɛ. N sɔ̃́ nfɔ̃́ɔ̃̀ mɑ́ɑ̀ yie n kpɛti ɑ kɔbɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Á túótɛ́ iwũɔ̃ ibotí ibotí bɛ̀ n feu ì ìdɛ́ì ìdɛ́ì, fɛdɑɑfɛ̀ nɛ̀ fɛnifɛ kucɛ mɛ̀yiekɛ̀ kɛ́túótɛ́ bɛ̀ í n feu ì ìdɛ́ì mɑ́ɑ̀ fɛdɑɑfɛ̀ nɛ̀ fɛnifɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","kɛ́túótɛ́ sinɔɔ sibotí sibotí sìdɛ́sì dɛ́sì, tɛdɑɑtɛ̀ nɛ̀ tɛniitɛ kucɛ mɛ̀yiekɛ̀, kɛ̀ sìi sɔɔtɛ́ kubotí kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Yɛwe yɛ̀yiekɛ̀ kó difɔ̃nkúò n yóó cṹũnko fɛtɑɑfɛ̀ nfɛ kɛ̀ fɛ̀ nniu kɛ dɔ̀ yɛwe sipísìnɑ̀ɑ̀ nɛ̀ dɛyènnɛ̀ sipísìnɑ̀ɑ̀, kɛ́kuɔ n dɔ̀ɔ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kɛ̀ Nɔwee yie nkɛ́dɔɔ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Mɛniɛ ndo yóó píɛ nkɛtenkɛ̀ kɛ sɔ̃́ nNɔwee mɔ̀kɛ yɛbie nsikɔusìkuɔ̀ (600) ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Wenwe nɛ̀ o pokù kɛ̀ bɛ̀ɛ tɑ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ nɛ̀ o bí nɛ̀ i pobɛ̀ kɛ bo yentɛ́nɛ̀ mɛnɛ́diɛmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","nɛ̀ iwũɔ̃ bɛ̀ feu ì Kuyie nnɛ̀ bɛ̀ í kù feu ì, nɛ̀ sinɔɔ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ fòù kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","Kɛ̀ dɛ̀ nkɔrìní dɛdɑɑrɛ̀ nɛ̀ dɛniirɛ, kɛ tɑɑ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ Nɔwee borɛ̀ Kuyie mbɛ́i mmɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Yɛwe yɛ̀yiekɛ̀ kó difɔ̃nkúò kɛ̀ fɛtɑɑfɛ̀ɛ tuɔkɛní, kɛ́nniu kɛ́píɛ nkɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nɔwee do mɔkɛ yɛbie nsikɔusìkuɔ̀ (600) ndi, dibenni kóo tɑ̃̀nkù dɛ́ríwè diyiè tɛpíítɛ̀ nɛ̀ diyiénnì, kɛ̀ yɛbirɛ ntɔ̃nní mɛniɛ nkɛ̀ iwɛtiborii kpetɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Kɛ̀ fɛtɑɑfɛ̀ nniu kɛ dɔ̀ iyie nsipísìnɑ̀ɑ̀ dɛyènnɛ̀ sipísìnɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Dɛ mɔ̀nnì Nɔwee nɛ̀ o pokù nɛ̀ o bí Sɛmmu nɛ̀ Kɑmmu nɛ̀ Sɑfɛti nɛ̀ bɛ pobɛ̀, kɛ̀ bɛ̀ tɑ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ ");
INSERT INTO tbzsim_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","nɛ̀ tiwɑnwɑntì tibotí tibotí, nɛ̀ iwũɔ̃ ibotí ibotí nɛ̀ tinɔ̀tì nɛ̀ dɛbɑmbɑɑ̀nnɛ̀ nɛ̀ tipumpùtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Dɛ̀ɛ̀ kó dimɑ̀ɑ̀ weí kɛ̀ dɛ̀ nkɔrì Nɔwee borɛ̀ dɛbotí dɛbotí, dɛdɑɑrɛ̀ nɛ̀ dɛniirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kɛ̀ dɛ̀ɛ kɔtoo bɑ́ dɛ̀ kɛ̀ dɛ̀ nnɛínɛ̀ dɛ pokù kɛ́tɑ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́ Nɔwee kɛ dɔ̀ dɛ̀ yóó ndòmmɛ̀. Kɛ̀ Kuyie nkpetínnɛ́ dibòrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Kɛ̀ fɛtɑɑfɛ̀ nniu kɛ dɔ̀ yɛwe sipísìnɑ̀ɑ̀, kɛ̀ mɛniɛ nsṹũnko kɛ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ nɔ̀ńkɛ́ mɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Kɛ̀ mɛniɛ mpíɛ mmɛdiɛ̀ nkɛ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ nnɔ́nkɛ́ mɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Kɛ̀ mɛniɛ ndɔkɛ píɛ nkɛ́dɑ́tínnɛ́ yɛtɑ̃rɛ̀ diɛyɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","kɛ́dɑ́tínnɛ́ yɛtɑ̃rɛ̀ yɛ̀ɛ̀ dɔ̀kɛ dɛu mɛdiɛ̀, kɛ́séntɛ́ kɛ̀ dɛ̀ɛ pɛ̃ɛ̃tɛ́ mɛ́tìrì bɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Kɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ fòù kɛtenkɛ̀ ĩ́nkɛ̀, iwũɔ̃, nɛ̀ tiwɑnwɑntì nɛ̀ dɛsĩ́ntɛ́kpɛrɛ dɛmɔu, dɛ̀ɛ̀ bo kɛtenkɛ̀ ĩ́nkɛ̀ kɛ̀ dɛ̀ɛ kú dɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Dɛmɔu dɛ̀ɛ̀ bo kɛtenkɛ̀ ĩ́nkɛ̀ kɛ weí kɛ̀ dɛ̀ɛ kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Mɛm̀mɛ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ weí: Bɛnìtìbɛ̀ nɛ̀ iwũɔ̃ nɛ̀ tiwɑnwɑntì, dɛ̀ kumɛ̀. Kɛ̀ Nɔwee weè mɑ́ɑ̀ nkpɑɑ́ nɛ̀ o cĩ́ɛ̃̀tɛ̀ kɔbɛ bɛ̀ɛ̀ do ò bonɛ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kɛ̀ mɛniɛ nní mpíɛ́kɛ́ kɛtenkɛ̀ kɛ dɔ̀ yɛwe tɛkɔ̀ùtɛ̀ nɛ̀ sipísìnùmmù (150). ");
INSERT INTO tbzsim_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Kuyie nyí nyɛ̃̀ nNɔwee kpɛ́í nnɛ̀ iwũɔ̃ nɛ̀ tiwɑnwɑntì dɛ̀ɛ̀ do ò bonɛ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ miɛkɛ, kɛ́duɔ́ nkɛ̀ kuyɑɑkù nfuu kɛtenkɛ̀ kɛ̀ mɛniɛ nní nkɛ̃́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Kɛ̀ yɛbirɛɛ yóu yɛ̀ bo ntɔ̃mmɛ̀ mɛniɛ, kɛ̀ iwɛtiborii ĩ́tínnɛ́ kɛ̀ fɛtɑɑfɛ̀ɛ cómmú. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Yɛwe tɛkɔ̀ùtɛ̀ nɛ̀ sipísìnùmmù (150) kó difɔ̃nkúò kɛ̀ mɛniɛ nní nkɛ̃́kú sɑ́m̀pɔ́ sɑ́m̀pɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Otɑ̃̀nkù yiénwè diyiè tɛpíítɛ̀ nɛ̀ diyiénnì kɛ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ɛ cómmú ditɑ̃rì bɛ̀ yu dì kɛ tú Adɑdɑti di ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kɛ̀ mɛniɛ nní nkpɑɑ́ yɑɑri kɛ́tuɔkɛ otɑ̃̀nkù píínwè diyiè ketirì yiè, kɛ̀ yɛtɑ̃rɛ̀ yómmɛ̀ɛ feitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Diyiè sipísìnɑ̀ɑ̀ yiè kɛ̀ Nɔwee kpetɛ́ tɛbòtɛ̀ ò do ɑ̃nnɛ́ tɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","kɛ́dennɛ dikɑ̃kɑ̃ɑ̃̀ kɛ̀ dìì kɔtɛ kɛ́wɛ̃tɛní. Kòo nkpɑɑ́ kémmú mɛniɛ mbo deèmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Dɛ kó difɔ̃nkúò kòo dennɛ tɛnɔ́nkpetɛ kɛ bo yɑ̀ kɛ̀ mɛniɛ ncɔ̀ɔ̀tɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Tɛ̀ mɛ nyí mpɛ̀tɛ́ tɛ̀ bo cómmú dɛ̀, kɛ yɛ̃́ mɛniɛ ndo kpɑɑ́ píɛ́kɛ́mɛ̀ kɛtenkɛ̀ kɛmɔu, kɛ̀ tɛ̀ɛ wɛ̃tɛní o borɛ̀, kòo youtɛ o nɔ̀ùtɛ̀ kɛ́ tɛ̀ pĩ nkɛ́tɑnnɛ́ kudieku, ");
INSERT INTO tbzsim_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","kɛ́yóu kɛ̀ dɛ̀ mmɔkɛ yɛwe yɛ̀yiekɛ̀ kòo wɛ̃tɛ kɛ́ tɛ̀ dènnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kɛ̀ tɛ̀ nwɛ̃tiní kuyuoku kɛ tɔní kufɑ̃ɑ̃̀sũ̀ũ̀kù mɑkù, kɛ̀ Nɔwee bɑntɛ́ mɛniɛ ncɔ̀ɔ̀tɛmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","kɛ́yóu kɛ̀ dɛ̀ mmɔkɛ yɛwe yɛ̀yiekɛ̀ kòo wɛ̃tɛ kɛ́ tɛ̀ dènnɛ, bɑ́ tɛ̀ í nwɛ̃̀tɛní. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Dibenni pɑ̀nnì kó diyiè ketirì yiè, kɛ sɔ̃́ nNɔwee mɔ̀kɛ yɛbie nsikɔusìkuɔ̀ nɛ̀ dìmɑ́ɑ̀ (601) kɛ̀ mɛniɛ nkṹṹ, kòo dɑ́tɛ́ tipĩ́mpĩ́ntì kɛ́yɑ̀ mɛ̀ kũ̀ṹmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Dibenni pɑ̀nnì kóo tɑ̃̀nkù dɛ́ríwè, diyiè sipísìdɛ́ nɛ̀ diyiénnì kɛ̀ kɛtenkɛ̀ɛ kpeí pɑíí. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Kɛ̀ Kuyie nnɑ́kɛ́ Nɔwee kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","Yɛ̀ nɛ̀ ɑ pokù nɛ̀ ɑ bí nɛ̀ i pobɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Dennɛ iwũɔ̃ ibotí ibotí tiwɑnwɑntì nɛ̀ tinɔ̀tì nɛ̀ dɛbɑmbɑɑ̀nnɛ̀, kɛ̀ dɛ̀ɛ pɛ̃tɛ́ kɛ́sṹṹ nkɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kɛ̀ Nɔwee yɛ̀ nɛ̀ o pokù nɛ̀ o bí nɛ̀ i pobɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","kɛ́dennɛ tiwɑnwɑntì nɛ̀ iwũɔ̃ dɛbotí dɛbotí nɛ̀ sinɔɔ nɛ̀ dɛbɑmbɑɑ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Kɛ̀ Nɔwee mɑɑ́ diwũɔ̃tɔ̀nnì ti Yiɛ̀ nKuyie nkpɛ́í, kɛ́túótɛ́ iwũɔ̃ nɛ̀ sinɔɔ bɛ̀ feu dɛ̀ ti Yiɛ̀ nKuyie ndɛ̀mɑrɛ̀ mɑrɛ̀, kɛ́ dɛ̀ fìé ti Yiɛ̀ nKuyie ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀ kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kɛ̀ ti Yiɛ̀ nKuyie nkeè dɛ kó kufɔ̃ɔ̃ku kɛ̀ dɛ̀ɛ kù nɑrikɛ kɛ̀ kù dɔ̀: N tɛ̃́nkɛ í yóó cɔ̃ɔ̃ kɛtenkɛ̀, kɛ yɛ̃́ onìtì yɛ̀mmɛ̀ í wennimɛ̀ nɛ̀ ò bomɛ̀. N tɛ̃́nkɛ bɑ́ɑ́ kuɔ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ weí m mɛ ndɔ̀ɔ̀ mɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nɛ̀ kɛtenkɛ̀ bo mbomɛ̀, mubɔtimù nɛ̀ mudidɛ̀ì, muséé nnɛ̀ kuyiìnkù, dipɑɑ̀ nɛ̀ diyɔ̃ɔ̃̀, kuyie nnɛ̀ kɛyènkɛ̀, dɛ̀ yó mbomu sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kɛ̀ Kuyie mpɑ̃ Nɔwee mɛsɑ̀ɑ̀ wenwe nɛ̀ o bí kɛ dɔ̀: Piɛ́nɛ̀ kɛ́sṹṹ nkɛ́píɛ nkɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Tiwɑnwɑntì timɔu: Iwũɔ̃ nɛ̀ sinɔɔ nɛ̀ siyĩĩ, dɛbɑmbɑɑ̀nnɛ̀ dɛmɔu dɛ̀ bo ndi dé, kɛ̀ dí ndɛ̀ bɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Dɛ̀ɛ̀ kó dimɑ̀ɑ̀ nɑmpú kɛ weí n dɛ̀ ndi duɔ́mmu kɛ̀ dɛ̀ bo ntú di kó mudiì, n di duɔ́ mmɛ̀ɛ̀ botí titebiiti. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Di nɛ́ bɑ́ɑ́ cɑ́ɑ́kɛ́ fɛɔ̃̀fɛ̀ yĩ̀ĩ̀, mmufòmmu bo mɛɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Nyɛ̃́nɛ̀ kɛ tú n yóó pɛitɛmu bɛ̀ɛ̀ kɔ̀ù bɛnìtìbɛ̀ kɛ́pɛitɛ iwũɔ̃ nɛ̀ tiwɑnwɑntì tìì kɔ̀ù bɛnìtìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wèè kùɔ onìtì, onìtì weè múnkɛ yóó ò kùɔ. Kɛ yɛ̃́ n dɔ̀ɔ̀mɛ̀ onìtì kɛ dònnɛnɛ̀ m mɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Di piɛ́ mɛsɑ̀ɑ̀ nkɛ́sṹṹ kɛtenkɛ̀ ĩ́nkɛ̀, kɛ́ nkɛ̀ bɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kɛ̀ Kuyie nyíɛ́ kɛ́nɑ́kɛ́ Nɔwee nɛ̀ o bí kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","N di dɔúnnɛ̀ dinùù ndi fɔ̃́ nnɛ̀ ɑ yɑɑ̀bío, ");
INSERT INTO tbzsim_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","nɛ̀ iwũɔ̃ ìì do di bonɛ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ miɛkɛ sinɔɔ nɛ̀ iwũɔ̃ nɛ̀ tiwɑnwɑntì dɛ̀ɛ̀ yóó buotɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","N di dɔúnnɛ̀ dinùù ndi kɛ tú, n tɛ̃́nkɛ bɑ́ɑ́ duɔ́ nkɛ̀ mɛniɛ mpíɛ nkɛtenkɛ̀ kɛ́kuɔ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ntɛ n yóó dɔɔ̀ mɛ̀ɛ̀ bɛnkùmɛ̀ kɛ̀ mɛ̀ mbo sɑ̃́ɑ̃̀, kɛ bɛnkú mí nnɛ̀ díndi nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ weí ti kó mɛtɑummɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Nh ɑ̃nnɛ́ kutɑ̃mmɛyɑ̃rí nku tiwɛtì kɛ̀ kù bo mbɛnkú mí nnɛ̀ díndi ti kó mɛtɑummɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","kɛ̀ fɛtɑɑfɛ̀ níí kpèri kùu yɛ̀nní, ");
INSERT INTO tbzsim_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kɛ̀ n dentɛní mɛtɑummɛ̀ mɛ̀ɛ̀ bo mí nnɛ̀ díndi nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ weí kɛtenkɛ̀ ĩ́nkɛ̀ ti cuokɛ̀, mɛniɛ ntɛ̃́nkɛ bɑ́ɑ́ píɛ nkɛtenkɛ̀ kɛ́ di kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kutɑ̃mmɛyɑ̃rí níí bo yɛ̀nní yɛwɛtɛ̀ ĩ́nkɛ̀, kɛ̀ n kù yɑ̀, kɛ́dentɛní mɛtɑummɛ̀ mɛ̀ɛ̀ bo mí nnɛ̀ díndi nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ weí kɛtenkɛ̀ ĩ́nkɛ̀ ti cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kɛ̀ Kuyie nnɑ́kɛ́ Nɔwee kɛ dɔ̀: Kutɑ̃mmɛyɑ̃rí kuù yó mbɛnkú n tɑunɛ̀mɛ̀ kɛtenkɛ̀ kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nɔwee bí ì do yɛ̀nnímɛ̀ tɛdɑbɛɛcĩ́ɛ̃̀tɛ̀ iǹyi: Sɛmmu nɛ̀ Kɑmmu nɛ̀ Sɑfɛti. Kɑmmu weè nɑɑ́ nKɑnnɑhɑ̃ɑ̃ kɔbɛ kóo cicɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Nɛ̀ Nɔwee bí itɑ̃ɑ̃ti miɛkɛ nkɛ ibotí sũ̀ṹmmɛ̀ kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nɔwee weè tu otenkútì ketiwè weè fìíkú dɛtie mbɛ̀ tu dɛ̀ fínyĩ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","kɛ́yɑ̃̀ dɛ kó mɛnɑɑ̀ nkɛ́muɔ́ nkɛ́dɑ́tɛ́ o yɑ̀ɑ̀tì kɛ́nduɔ́ o dieku difɔ̃̀kperì. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kɛ̀ Kɑmmu Kɑnnɑhɑ̃ɑ̃ kɔbɛ kóo cicɛɛ yɑ̀ o cicɛ Nɔwee fũ̀ɔ̃̀ feímɛ̀, kɛ́yɛ̀ kɛ́nɑ́kɛ́ o tebìí sidɛ́ ditowɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kɛ̀ Sɛmmu nɛ̀ Sɑfɛti kɛ̀ bɛ̀ɛ buutɛ́ kuyɑ̀ɑ̀kù kɛ́nkérí bɛ fɔ̃nkúò kɛ́tuɔkɛ kóò dɑ̀tínnɛ́, bɑ́ bɛ̀ í nyɑ̀ bɛ cicɛ fũ̀ɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nɔwee nɑɑ̀ nyɛ̀ dìì mɔ̀nnì kòo keè o bíyɑ̃ɑ̃tɛ̀ dɔ̀ɔ̀ dɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","kɛ́bɛ́i nkɛ dɔ̀: A bo yɑ̀ fɔ̃́ nKɑnnɑhɑ̃ɑ̃! A bo ntú ɑ tebìí miɛkɛ kudɑɑkù sɔnsɔnku, ");
INSERT INTO tbzsim_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kòo yíɛ́ kɛ́bɛ́i nkɛ dɔ̀: Ti Yiɛ̀ nKuyie ńdɔɔ̀ mɛsɑ̀ɑ̀ nSɛmmu kɛ̀ Kɑnnɑhɑ̃ɑ̃ ńtú o kó kudɑɑkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Kuyie ńdɔɔ̀ mɛsɑ̀ɑ̀ nSɑfɛti nɛ̀ Sɛmmu kɛ̀ bɛ̀ ńwɛ̃ nkɛ bo, kɛ̀ Kɑnnɑhɑ̃ɑ̃ ńtú bɛ kó kudɑɑkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Mɛniɛ nkùɔ dìì mɔ̀nnì bɛnìtìbɛ̀ kɛ́deè, kɛ̀ Nɔwee mmɔkɛ yɛbie nsikɔusìtɑ̃ɑ̃ti nɛ̀ sipísìnùmmù (350) ndi, ");
INSERT INTO tbzsim_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","kɛ́ nyóó kú kɛ mɔkɛ yɛbie nsikɔusìwɛi nɛ̀ sipísìnùmmù (950). ");
INSERT INTO tbzsim_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ntɛ Nɔwee bí, Sɛmmu nɛ̀ Kɑmmu nɛ̀ Sɑfɛti kó kufuku mɛniɛ ndo kùɔ bɛnìtìbɛ̀ kɛ́deè, kɛ̀ bɛ̀ɛ piɛ́mu ibí. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Sɑfɛti kó ibí tú: Kɔmɛɛ nɛ̀ Mɑkɔku nɛ̀ Mɑdɑii nɛ̀ Yɑfɑ̃ɑ̃ nɛ̀ Tubɑɑdi nɛ̀ Mɛsɛki nɛ̀ Tidɑɑsi. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Kɔmɛɛ kó ibí tú: Asekenɑɑsi nɛ̀ Difɑti nɛ̀ Tokɑdimɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yɑfɑ̃ɑ̃ kó ibí tú: Edisɑɑ nɛ̀ Tɑdisisi nɛ̀ Kitimmu nɛ̀ Dodɑnimmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Bɛɛ̀ do sũ̀ṹ nkɛ́cíɛ́tɛ́ kɛ́mɑɑ́ dɑ̀mɛ́ɛ̀rì tɑkɛ́ kɛ́cɑ̃́nnɛ́ cɑ̃́nnɛ́ ibotí bɛ nɑ́ɑǹtì dò ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kɑmmu kó ibí tú: Kuusi nɛ̀ Misidɑimmu nɛ̀ Puti nɛ̀ Kɑnnɑhɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kuusi kó ibí tú: Sebɑɑ nɛ̀ Afidɑɑ nɛ̀ Sɑbitɑɑ nɛ̀ Dɑyemɑɑ nɛ̀ Sɑbitekɑɑ. Dɑyemɑɑ kó ibí tú: Sebɑɑ nɛ̀ Dedɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuusi weè do wɛ̃̀tɛ kɛ́pɛitɛ́ Nɛmmudoti wèè do nɑɑ́ nhokpɑ̀rì ketiwè kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Nɛmmudoti do tú opɑɑwɑɑ̀ ndiɛwè nwe kɛ̀ ti Yiɛ̀ nKuyie nwùó. Dɛɛ̀ te kɛ̀ bɛ̀ ɔ̃ɔ̃ yĩ́ ti Yiɛ̀ nKuyie ndɑ teennɛ̀ kɑ̀ɑ ntú opɑɑwɑɑ̀ ndiɛwè Nɛmmudoti do dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ntɛ yɛhɛkɛ̀ ketiyɛ̀ ò do bɑkɛ́ yɛ̀: Bɑbɛɛdi nɛ̀ Edɛsi nɛ̀ Akɑdi nɛ̀ Kɑdinɛɛ. Dɛ kó yɛhɛkɛ̀ do bo Sindeɑɑ miɛkɛ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kɛ̀ Nɛmmudotii ítɛ́ dɛ kó dihɛì kɛ́kɔtɛ Asidii kɛ́mɑɑ́ Ninifu nɛ̀ Debotidii nɛ̀ Kɑdɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Kɛ̀ Desɑ̃ɑ̃ ɛì dii ḿbo Ninifu nɛ̀ Kɑdɑɑ dihɛidiɛ̀ dɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misidɑimmu yɑɑ̀bí tú Dudimmu nɛ̀ Anɑmimmu nɛ̀ Deɑbimmu nɛ̀ Nɑfutuyimmu ");
INSERT INTO tbzsim_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","nɛ̀ Pɑtidoosi nɛ̀ Kɑsiduimmu nɛ̀ Kɑfutɔɔ, bɛ̀ɛ̀ piɛ́ Fidisitɛ̃ɛ̃bɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kɛ̀ Kɑnnɑhɑ̃ɑ̃ pɛitɛ́ Sidonni o kóò Po nɛ̀ Ɛti. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Kɛ̀ Kɑnnɑhɑ̃ɑ̃ yɑɑ̀bí ntú: Yebusiibɛ nɛ̀ Amɔriibɛ nɛ̀ Kidikɑsiibɛ ");
INSERT INTO tbzsim_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","nɛ̀ Efiibɛ nɛ̀ Adikiibɛ nɛ̀ Siniibɛ ");
INSERT INTO tbzsim_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","nɛ̀ Adifɑdiibɛ nɛ̀ Semɑdiibɛ nɛ̀ Amɑtiibɛ. Dɛ kó difɔ̃nkúò kɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛɛ cíɛ́tɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","kɛ́kɑri Sidonni bɛ tenkɛ̀ dɛ nketɛ́ kɛ́cuó nKedɑɑdi nɛ̀ Kɑsɑɑ, Sodɔmmu nɛ̀ Komɔɔ bíɛ́kɛ̀, Adimɑɑ nɛ̀ Seboimmu kɛ́ntɔ kɛ́tuɔkɛ Desɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Kɑmmu kó ibí nyi ìì do yɑ̀tɛ tinɑɑ̀mùntì, kɛ́kɑri yɛhɛkɛ̀ bɛ nɑ́ɑǹtì cɑ̃̀ɑ̃́ ncɑ̃́ɑ̃́mmɛ̀ nɛ̀ bɛ botí. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Kɛ̀ Sɑfɛti kóo kótì Sɛmmu múnkɛɛ mɔɔtɛ ibí, weè tu Ebɛɛ kóo yɑ̀ɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Kɛ̀ Sɛmmu kó ibí ntú Edɑmmu nɛ̀ Asuu nɛ̀ Adipɑkisɑdi nɛ̀ Dudi nɛ̀ Arɑmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Kɛ̀ Arɑmu kó ibí ntú: Uusi nɛ̀ Udi nɛ̀ Ketɛɛ nɛ̀ Mɑɑsi. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Kɛ̀ Adipɑkisɑdi ntú Sedɑɑ cicɛ, kɛ̀ Sedɑɑ ntú Ebɛɛ cicɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Kɛ̀ Eebɛɛ mmɔkɛ ibí ìdɛ́ì, kɛ̀ dɛketirɛ̀ yètìrì ntú Pedɛki (dɛ̀ɛ̀ tu mɛyɑtimɛ̀). Dɛ kó dimɔ̀nnì ndi ibotí do yɑ̀tɛmɛ̀, kòo nɑntɛ̀ yètìrì ntú Yokitɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Kɛ̀ Yokitɑ̃ɑ̃ pɛitɛ́ Adimɔdɑdi nɛ̀ Sedɛfu nɛ̀ Asɑdimɑfɛti nɛ̀ Yedɑki, ");
INSERT INTO tbzsim_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","nɛ̀ Adodɑmmu nɛ̀ Usɑdi nɛ̀ Dikidɑ, ");
INSERT INTO tbzsim_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","nɛ̀ Obɑɑdi nɛ̀ Abimmɑyɛɛdi nɛ̀ Sebɑɑ, ");
INSERT INTO tbzsim_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","nɛ̀ Ofiidi nɛ̀ Afidɑɑ nɛ̀ Yobɑbu. Bɛmɔu mɛmmɛ bɛ̀ tu Yokitɑ̃ɑ̃ bí nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Bɛ̀ do bo Mɛsɑ ɛì ndi kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Sefɑɑdi tɑ̃rì, diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Kɛ̀ Sɛmmu kɔbɛ múnkɛɛ yɛ̀ kɛ́cɑ̃́nnɛ́ yɛhɛkɛ̀, yɛhɛkɛ̀ bɛ nɑ́ɑǹtì dò mmɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nɔwee bí kó iwuɔ nyi mɛmmɛ, bɛ̀ ì cɑ̃̀ńnɛ́mɛ̀ ibotí ibotí. Mɛniɛ ndo kùɔ bɛnìtìbɛ̀ kɛ́deè kɛ̀ bɛɛ̀ piɛ́ ibotí imɔu ìì bo kutenkù miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bɛnìtìbɛ̀ bɛmɔu do nɑ́ɑ́ ntinɑ́ɑǹtì timɑ́ɑ̀ ndi, onìtì nɑ́ɑǹtì do í cɑ̃́ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kɛ̀ bɛ̀ɛ kɔtɛ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kɛ́yɑ̀ kubiriku mɑkù, dihɛì bɛ̀ tu dì Sindeɑɑ kɛ bo mɑɑ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","kɛ́nɑ́kɛ́ bɛtɔbɛ̀ kɛ dɔ̀: Ítɛ́nɛ̀ kɛ̀ ti pííkú yɛdombiɛ, kɛ́ yɛ̀ pũ̀ńnɛ́ kɛ̀ yɛ̀ɛ kpenkɛ kɛ́ndò nyɛtɑ̃́rɛ̀, kɛ̀ tí wɑɑ́ nkùtìnɔ́ɔ̀ kɛ́nsĩɛ̃kù. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Kɛ̀ tí mɑɑ́ dihɛì, kɛ́mɑɑ́ didènnì kɛ̀ dìi kɑ́ɑ́kɛ́ tiwɛtì, kɛ̀ ti yètìrìi feitɛ́, kɛ̀ ti bɑ́ɑ́ cíɛ́tɛ́ kɛtenkɛ̀ kɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Kɛ̀ ti Yiɛ̀ nKuyie ncútɛ́ní kɛ bo yɑ̀ bɛnìtìbɛ̀ mɑɑ́ dìì ɛì nɛ̀ didènnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Kɛ dɔ̀: Bɛ̀ mɛ̀ ntúmɛ̀ kubotí kùmɑ́ɑ̀ kɔbɛ kɛ nɑ́ɑ́ ntinɑ́ɑǹtì tìmɑ́ɑ̀, dɛ̀mɑrɛ̀ í yóó bɛ̀ dìtínnɛ́ bɛ̀ yóó nɑmu kɛ́dɔɔ̀ bɛ̀ dɔ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ti cútɛ́nɛ̀ kɛ́kɔkɛ́ bɛ nɑ́ɑǹtì, kɛ̀ bɛ̀ nnɑ́ɑ́ nkɛ í yo bɛtɔbɛ̀ tu mù. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ cíɛ nkɛtenkɛ̀ kɛmɔu, bɑ́ bɛ̀ í mmɑɑ́ dɛ kó dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Dɛɛ̀ te kɛ̀ bɛ̀ yu dɛ kó didènnì kɛ tú Bɑbɛɛdi. Ti Yiɛ̀ nKuyie ndɛ nkɔkɛ́ bɛnìtìbɛ̀ nɑ́ɑǹtì, kɛ́ bɛ̀ cíɛ nkɛtenkɛ̀ kɛmɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sɛmmu kó kufuku tú kuu: Ò do mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ (100) ntɛ kɛ́pɛitɛ́ Adipɑkisɑdi kɛ sɔ̃́ ndɛ̀ mɔ̀kɛ yɛbie nyɛ̀dɛ́ɛ̀ nɛ̀ mɛniɛ nkùɔmɛ̀ bɛnìtìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Dɛ kó difɔ̃nkúò, kɛ́mmɔkɛ yɛbie nsikɔusìnùmmù (500) kɛ́piɛ́ bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Kɛ̀ Adipɑkisɑdi mmɔkɛ yɛbie nsipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀nùmmù kɛ́pɛitɛ́ Sedɑɑsi. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Dɛ kó difɔ̃nkúò kɛ́mmɔkɛ yɛbie nsikɔusìnɑ̀ɑ̀ nɛ̀ yɛ̀tɑ̃ɑ̃ti (403), kɛ́piɛ́ bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Kɛ̀ Sedɑɑ mmɔkɛ yɛbie nsipísìtɑ̃ɑ̃ti kɛ́pɛitɛ́ Ebɛɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Dɛ kó difɔ̃nkúò kɛ̀ Ebɛɛ mmɔkɛ yɛbie nsikɔusìnɑ̀ɑ̀ nɛ̀ yɛ̀tɑ̃ɑ̃ti (403) kɛ́piɛ́ bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Kɛ̀ Ebɛɛ pɛitɛ́ Pɛdɛki kɛ́deè kɛ́mmɔkɛ yɛbie nsipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀nɑ̀ɑ̀ kɛ́pɛitɛ́ Pedɛki. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Dɛ kó difɔ̃nkúò kɛ̀ Ebɛɛ mmɔkɛ yɛbie nsikɔusìnɑ̀ɑ̀, nɛ̀ sipísìtɑ̃ɑ̃ti (430) kɛ́piɛ́ bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Kɛ̀ Pedɛki mmɔkɛ yɛbie nsipísìtɑ̃ɑ̃ti kɛ́pɛitɛ́ Deyuu. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Dɛ kó difɔ̃nkúò kɛ́mmɔkɛ yɛbie nsikɔusìdɛ́ nɛ̀ yɛ̀wɛi (209), kɛ́piɛ́ bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Kɛ̀ Deyuu mmɔkɛ yɛbie nsipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀dɛ́ɛ̀ kɛ́pɛitɛ́ Seduki. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Dɛ kó difɔ̃nkúò kɛ́mmɔkɛ yɛbie nsikɔusìdɛ́ nɛ̀ yɛ̀yiekɛ̀ (207) kɛ́piɛ́ bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Kɛ̀ Seduki mmɔkɛ yɛbie nsipísìtɑ̃ɑ̃ti kɛ́pɛitɛ́ Nɑɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Dɛ kó difɔ̃nkúò kɛ́mmɔkɛ yɛbie nsikɔusìdɛ́ (200) kɛ́piɛ́ bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Kɛ̀ Nɑɔɔ mmɔkɛ yɛbie nsipísìdɛ́ nɛ̀ yɛ̀wɛi kɛ́pɛitɛ́ Tedɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Dɛ kó difɔ̃nkúò kɛ́mmɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ tɛpíítɛ̀ nɛ̀ yɛ̀wɛi (119), kɛ́piɛ́ bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kɛ̀ Tedɑɑ mmɔkɛ yɛbie nsipísìyiekɛ̀, kɛ́pɛitɛ́ Abɑrɑmmu nɛ̀ Nɑɔɔ nɛ̀ Atɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tedɑɑ kó kufuku nku, weè pɛitɛ́ Abɑrɑmmu nɛ̀ Nɑɔɔ nɛ̀ Atɑ̃ɑ̃. Kɛ̀ Atɑ̃ɑ̃ pɛitɛ́ dɛnitidɑbirɛ Dɔti, ");
INSERT INTO tbzsim_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","kɛ́kú, bɛ̀ ò pɛitɛ́ dìì ɛì Uudi Bɑbidɔnni kó kɛtenkɛ̀ miɛkɛ, kòo cicɛ Tedɑɑ kpɑɑ́ fòù. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Kɛ̀ Abɑrɑmmuu puokɛ Sɑrɑii kɛ̀ Nɑɔɔ puokɛ Midikɑɑ Atɑ̃ɑ̃ kóo sɑpɑ̀ɑ̀. Atɑ̃ɑ̃ weè múnkɛ do pɛitɛ́ Isikɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sɑrɑii do tú tɛhɑ̃ũntɛ ntɛ kɛ́nkpɑ dɛbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Kɛ̀ Tedɑɑ túótɛ́ o kóo dɑpɑ̀ɑ̀ nhAbɑrɑmmu nɛ̀ o yɑɑ̀birɛ Dɔti Atɑ̃ɑ̃ birɛ nɛ̀ o cɔ̀kù Sɑrɑii o kóo dɑpɑ̀ɑ̀ nhAbɑrɑmmu pokù. Kɛ̀ bɛ̀ɛ ítɛ́ Uudi ɛì Bɑbidɔnni tenkɛ̀ kɛ́kɔtɛ Kɑnnɑhɑ̃ɑ̃ tenkɛ̀, kɛ́tuɔkɛ Anɑɑ ɛì kɛ́ nkɛ mbo. ");
INSERT INTO tbzsim_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Kɛ̀ Tedɑɑ nyóó kú kɛ mɔkɛ yɛbie nsikɔusìdɛ́ nɛ̀ yɛ̀nùmmù (205). ");
INSERT INTO tbzsim_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Abɑrɑmmu kɛ dɔ̀: Ítɛ́ ɑ tenkɛ̀, ɑ kɔbɛ borɛ̀, ɑ cicɛ cĩ́ɛ̃̀tɛ̀, kɛ́kɔtɛ n yóó dɑ bɛnkɛ kɛ̀ɛ̀ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","M bo dɑ dɔɔ̀ mɛsɑ̀ɑ̀ nkɑ̀ɑ botíi sṹṹ, kɑ̀ɑ yètìrìi feitɛ́ mɛdiɛ̀. Fɔ̃́ɔ̃̀ yó nte kɛ̀ ibotí imɔuu pɛ́tɛ́ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","M bo dɔɔ̀ mɛsɑ̀ɑ̀ mbɛ̀ɛ̀ yóó dɑ dɔɔ̀ mɛsɑ̀ɑ̀, kɛ́dɔɔ̀ mɛyɛi mbɛ̀ɛ̀ bo ndɑ dɔ́nɛ̀ mɛyɛi. Fɔ̃́ɔ̃̀ yó nte kɛ̀ n dɔɔ̀ ibotí imɔu mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Dɛ mɔ̀nnì kɛ sɔ̃́ nhAbɑrɑmmu mɔ̀kɛ yɛbie nsipísìyiekɛ̀ nɛ̀ yɛ̀nùmmù. Kɛ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ kɛ dɔ̀: Ítɛ́ Anɑɑ ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Kòo yie nkɛ́ítɛ́ kɛ́nnɛínɛ̀ o pokù Sɑrɑii nɛ̀ o nɑntɛ̀ birɛ Dɔti kɛ́ntɔ o kpɛrɛ dɛmɔu nɛ̀ o dɑɑtì ò do dontɛ́ tì Anɑɑ ɛì, kɛ́kétɛ́ kɛ́cuó nKɑnnɑhɑ̃ɑ̃ bíɛ́kɛ̀, kɛ́tuɔkɛ Kɑnnɑhɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Mɛm̀mɛ kɛ̀ Abɑrɑmmuu pɛ̃ɛ̃tɛ́ Sisɛmmu ɛì kɛ́tuɔkɛ dibòrì mɑrì bɛ̀ tu dì Mɔdee mutie mɑmù borɛ̀. Dɛ kó dimɔ̀nnì Kɑnnɑhɑ̃ɑ̃ kɔbɛ bɛɛ̀ do dɛ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kɛ̀ ti Yiɛ̀ nKuyie mbɛnkɛ kumɑ́ɑ̀ Abɑrɑmmu kóò nɑ̀kɛ́ kɛ dɔ̀: N yóó duɔ́ nkɛ ntenkɛ̀ nkɛ ɑ yɑɑ̀bí. Kɛ̀ Abɑrɑmmuu mɑɑ́ ti Yiɛ̀ nKuyiendiwũɔ̃tɔ̀nnì dɛ kó dibòrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ò dɛ nyìtɛ́ kɛ́kɔtɛ yɛtɑ̃rɛ̀ kó dihɛì Betɛɛdi diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀, kɛ́kɑri Betɛɛdi nɛ̀ Aii dɛ cuokɛ̀ kɛ tó mɑɑ́ ti Yiɛ̀ nKuyie ndiwũɔ̃tɔ̀nnì tɛrì kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ́ kù yu kɛ dɔ̀ o Yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kɛ̀ Abɑrɑmmu ńkɑ̀tì kɛ sɔɔti kɛ wetí Nɛkɛbu tempɛ̃ mbíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kɛ̀ dikònnì diɛrìi tɑnní dihɛì kɛ̀ Abɑrɑmmuu ítɛ́, kɛ́kɔtɛ Esibiti tenkɛ̀ kɛ́mbo kɛ dɔ̀ yɛmɔ̀rɛ̀ mɑyɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Bɛ̀ tùɔ̀kɛ dìì mɔ̀nnì Esibiti kɛ́ntɑti dihɛì, kɛ̀ Abɑrɑmmuu nɑ́kɛ́ o pokù Sɑrɑii kɛ dɔ̀: N yɛ̃́mu ɑ túmɛ̀ oposɑ́ɑ́tì, ");
INSERT INTO tbzsim_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Esibiti kɔbɛ yóó yɑ̀ ɑ wennimɛ̀ kɛ dɔ̀ ɑ tú m pokù nwe, kɛ́ n kuɔ kɛ́ dɑ yóu. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Á bɛ̀ nɑ̀kɛ́ kɛ dɔ̀ n tú ɑ tɑ̃ũ̀ nwe kɛ̀ bɛ̀ nni ndɔɔri mɛsɑ̀ɑ̀ nhɑ kpɛ́í, kɛ̀ nní nfòù. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Bɛ̀ tùɔ̀koo dìì mɔ̀nnì Esibiti miɛkɛ kɛ̀ Esibiti kɔbɛɛ yɑ̀ o pokù wennimɛ̀ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kɛ̀ Esibiti kóo kpɑ̀ɑ̀tì kó bɛtɔ̃mbɛ̀ɛ kɔtɛ kɛ́ nhò sɑ̃ntí okpɑ̀ɑ̀tì ììkɛ̀, kóò tùótɛ́ kɛ́kɔtɛnɛ̀ okpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Nɛ̀ o kpɛ́í nkòo kpɑ̀ɑ̀tìi dɔ̀ɔ̀ mɛsɑ̀ɑ̀ nhAbɑrɑmmu kóò pɑ̃mmú ipe nɛ̀ sibɔɔ́ nɛ̀ inɑ̀ɑ̀kɛ nɛ̀ tidɑɑtì bɛnitipòbɛ̀ nɛ̀ bɛnitidɑɑbɛ̀ nɛ̀ sɑ̃mmɑrímúbɛ̀ nɛ̀ yòyóbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kɛ̀ ti Yiɛ̀ nKuyie mpotɛ́ okpɑ̀ɑ̀tì nɛ̀ o cĩ́ɛ̃̀tɛ̀ kɔbɛ mɛdiɛ̀ nhAbɑrɑmmu pokù Sɑrɑii kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kɛ̀ Esibiti kóo kpɑ̀ɑ̀tìi yú Abɑrɑmmu kóò bekɛ kɛ dɔ̀: Dɛ̀ yĩ́mɛ kɑ̀ɑ n dɔ̀ɔ̀ miɛ? Dɛ̀ dòmmɛ̀ kɑ̀ɑ í n nɑ̀kɛ́ kɛ tú ɑ pokù nwe? ");
INSERT INTO tbzsim_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Dɛ̀ dòmmɛ̀ kɑ̀ɑ n nɑ̀kɛ́ kɛ yɛ̃ nhɑ tɑ̃ũ̀ nwe kɛ̀ nh ò tùótɛ́ kɛ bo puokɛ? Nto ɑ pokù kɛ́pɛ̃ɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kòo kpɑ̀ɑ̀tìi duɔ́ nkòo tɔ̃mbɛ̀ɛ bɛti Abɑrɑmmu nɛ̀ o kpɛrɛ dɛmɔu dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Mɛm̀mɛ kɛ̀ Abɑrɑmmuu túótɛ́ o pokù nɛ̀ o kpɛrɛ ò mɔ̀kɛ dɛ̀, kɛ̀ Dɔti nwe nɛínɛ̀ kɛ̀ bɛ̀ɛ wɛ̃tɛ Nɛkɛbu tempɛ̃ mbíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abɑrɑmmu do mɔkɛ tikpɑ̀tì nti mɛsɑ̀ɑ̀, nnɛ̀ timɑ́tì pɛ́ítì nɛ̀ mɛsɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Kɛ̀ Abɑrɑmmuu ítɛ́ Nɛkɛbu tempɛ̃ kɛ́tuɔkɛ Betɛɛdi nɛ̀ Aii dɛ cuokɛ̀ ò do ketɛ́ kɛ́bɑ́tɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Ò do mɑɑ́ dɛ̀ diwũɔ̃tɔ̀nnì kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ́ kù yu kɛ dɔ̀ o Yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Dɔti wèè do nɛínɛ̀ Abɑrɑmmu ò múnkɛ do mɔkɛmu ipe nɛ̀ sibɔɔ́ nɛ̀ inɑ̀ɑ̀kɛ. Kɛ mɔkɛ tiyɑ̀ɑ̀tì bɛ̀ dɔ̀ɔ̀rinɛ̀ tì titouti. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Bɑ́ kɛtenkɛ̀ í mbɛ̀ sɑ̀nnɛ̀ kɛ yɛ̃́ bɛ̀ do mɔkɛmɛ̀ iwũɔ̃ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kɛ̀ Abɑrɑmmu kó bɛnɑɑcɛ̃mbɛ nɛ̀ Dɔti kɔbɛ kɛ̀ bɛ̀ɛ kpɑ. Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Pedisiibɛ do dɛ mbo. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Kɛ̀ Abɑrɑmmuu nɑ́kɛ́ Dɔti kɛ dɔ̀: Mí nnɛ̀ fɔ̃́ ti í dò nkɛ́kpɑ, ti nɑɑcɛ̃mbɛ mɛ nyí dò nkɛ́kpɑ, kɛ yɛ̃́ ti wɛ̃ḿmɛ̀ tɛcĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Á wéntɛ́ kɛ́dɛitɛ ɑ dɔ́ kùù píkù kɛ̀ tí yɑtɛ. Kɑ̀ɑ kɔ̀tɛ kubɑkù yoú n kɔtɛ kucɑ̃̀nku. Kɑ̀ɑ mɛ nkɔ̀tɛ kucɑ̃̀nku ń kɔtɛ kuyoú. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Kɛ̀ Dɔtii wéntɛ́ kɛ́yɑ̀ Suditɛ̃ɛ̃ kó kɛtenkɛ̀ kɛ̀ kɛ̀ boo bɑ̀mmùù kɛ́tuɔkɛnɛ̀ Soɑɑ ɛì. Ti Yiɛ̀ nKuyie mu ndo í cɔ́u ndìì mɔ̀nnì Sodɔmmu ɛì nɛ̀ Komɔɔ ɛì kɛ̀ dɛ kó kɛtenkɛ̀ nɛ̀ Soɑɑ ɛì kɛ̀ dɛ̀ boomu, kɛ wenni kɛ dò nti Yiɛ̀ nKuyie ndo dɔ̀ɔ̀ kùù púú, kɛ nɑɑti kɛ dònnɛ̀ Esibiti kó kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kɛ̀ Dɔtii tɑ̃ɑ̃tɛ́ Suditɛ̃ɛ̃ kó kubiriku bíɛ́kɛ̀, kɛ́ kɛ nkɔtɛ. Mɛm̀mɛ bɛ̀ yɑ̀tɛmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Kɛ̀ Abɑrɑmmu ḿbo Kɑnnɑhɑ̃ɑ̃ kó dihɛì, kɛ̀ Dɔti ḿbo kubiriku kó yɛhɛkɛ̀, kɛ cónnɛ́ tiyɑ̀ɑ̀tì kó titouti kɛ́tuɔkɛnɛ̀ Sodɔmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodɔmmu kɔbɛ do tú bɛnitiyonkubɛ mbɛ, kɛ dɔɔri mɛyɛi ndiɛmɛ̀ kɛ̀ dɛ̀ yóù Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Dɔti nɛ̀ Abɑrɑmmu bɛ̀ yɑ̀tɛ dìì mɔ̀nnì, kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Abɑrɑmmu kɛ dɔ̀: Wéntɛ́ ɑ cómmú dɛ̀, kɛ́wéntɛ́ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀, kɛ́wéntɛ́ ɑ bɑkù yoú nɛ̀ kucɑ̃̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","A mɛ̀ nwùó nkɛ̀ɛ̀ tenkɛ̀ n yóó kɛ̀ ndɑ duɔ́mmu fɔ̃́ nnɛ̀ ɑ yɑɑ̀bío sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","M bo duɔ́ nkɑ̀ɑ yɑɑ̀bíi sṹṹ mmɛsɑ̀ɑ̀ mmubirímú kɔ̃mɛ. Wèè bo nɑ kɛ́kɑɑ mmubirímú, weè bo nɑ kɛ́kɑɑ nhɑ yɑɑ̀bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ítɛ́ kɛ́ce, ndɛ kó kɛtenkɛ̀ kɛmɔu kɛ̀ duɔ́mɛ̀ n kɛ̀ ndɑ duɔ́mmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kɛ̀ Abɑrɑmmuu ítɛ́ dɛborɛ̀ kɛ́sɔɔ́ nkɛ́kɑri dibòrì mɑrì bɛ̀ tu dì Mɑmmudee kó mutie borɛ̀ Ebunɔɔ tɑkɛ́, kɛ́mɑɑ́ diwũɔ̃tɔ̀nnì kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Dɛ kó dimɔ̀nnì kɛ̀ Amudɑfɛɛdi Sindeɑɑ ɛì kóo kpɑ̀ɑ̀tì nɛ̀ Adiyɔki Edɑsɑɑ ɛì kóo kpɑ̀ɑ̀tì nɛ̀ Kedɔɔdɑomɛɛ Edɑmmu ɛì kóo kpɑ̀ɑ̀tì nɛ̀ Tideɑdi Koyimmu ɛì kóo kpɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Kɛ̀ bɛ̀ɛ ítɛ́ kɛ́ndokùnɛ̀ Bedɑɑ Sodɔmmu kóo kpɑ̀ɑ̀tì nɛ̀ Bidisɑɑ Komɔɔ kóo kpɑ̀ɑ̀tì, nɛ̀ Sinɛɑbu Adimɑ kóo kpɑ̀ɑ̀tì, nɛ̀ Simmɛbɛɛ Seboimmu kóo kpɑ̀ɑ̀tì nɛ̀ Bedɑɑ bɛ̀ tu dìì ɛì Soɑɑ kóo kpɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Kɛ̀ bɛ̀ɛ tíí Sidimmu kó kubiriku, dɛ̀ɛ̀ nɑɑ́ nyíe ndɑ̀mɛ́ɛ̀rì wèè kó mɛniɛ ndò mmukɔ́kúɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Yɛbie ntɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀ miɛkɛ kɛ̀ Kedɔɔdɑomɛɛ mbɛ̀ bɑkɛ́. Yɛbie ntɛpíítɛ̀ nɛ̀ ditɑ̃ɑ̃́nnì miɛkɛ kɛ̀ bɛ̀ɛ ò yetɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Yɛbie ntɛpíítɛ̀ nɛ̀ dinɑɑnnì miɛkɛ kɛ̀ Kedɔɔdɑomɛɛ nɛ̀ bɛkpɑ̀ɑ̀tìbɛ̀ bɛ̀ɛ̀ ò wɛ̃ńnɛ̀ kɛ̀ bɛ̀ɛ ítɛ́ kɛ́pɔntɛ Defɑiibɛ bɛ̀ɛ̀ bo Asitɑdoti-Kɑnnɑimmu ɛì, nɛ̀ Susiibɛ bɛ̀ɛ̀ bo Ammu ɛì nɛ̀ Emiibɛ bɛ̀ɛ̀ bo Kidiyɑtɑimmu ɛì ");
INSERT INTO tbzsim_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","nɛ̀ Oriibɛ bɛ̀ɛ̀ bo Seii kó yɛtɑ̃rɛ̀ miɛkɛ, kɛ́ bɛ̀ bɛ̀ti kɛ́tuɔkɛnɛ̀ Edi-Pɑdɑnni kó dihɛì dìì tɔ̀kɛ́nɛ̀ tɛdɔntɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","kɛ́nkũntiní kɛ́pɔntɛ Ammisipɑti bɛ̀ tu dìì ɛì Kɑdɛɛsi, kɛ́pɔntɛ Amɑdesiibɛ kó kɛtenkɛ̀ kɛmɔu, nɛ̀ Amɔriibɛ bɛ̀ɛ̀ bo Asɑsɔnni-Tɑmɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mɛm̀mɛ kɛ̀ Sodɔmmu kóo kpɑ̀ɑ̀tì nɛ̀ Komɔɔ kou nɛ̀ Adimɑ kou nɛ̀ Seboimmu kóo kpɑ̀ɑ̀tì nɛ̀ Bedɑɑ, nɛ̀ Soɑɑ kó bɛkpɑ̀ɑ̀tìbɛ̀, kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ kɛ́kɔtɛ Sidimmu kó kubiriku, ");
INSERT INTO tbzsim_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","kɛ́dokɛ́nɛ̀ Kedɔɔdɑomɛɛ Edɑmmu kóo kpɑ̀ɑ̀tì, nɛ̀ Tedeɑdi Koyimmu ɛì kóo kpɑ̀ɑ̀tì Amudɑfɛɛdi Sinnɛɑɑ ɛì kóo kpɑ̀ɑ̀tì nɛ̀ Adiyɔki Edɑsɑɑ ɛì kóo kpɑ̀ɑ̀tì. Kɛ̀ bɛkpɑ̀ɑ̀tìbɛ̀ bɛ̀nùmmù ndokùnɛ̀ bɛkpɑ̀ɑ̀tìbɛ̀ bɛ̀nɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidimmu kó kubiriku do mɔkɛ yɛfɔ̃̀tɛ̀ nyɛ kɛ̀ kùtìnɔ́ɔ̀ pìɛ́kɛ́ yɛ miɛkɛ. Kɛ̀ Sodɔmmu kóo kpɑ̀ɑ̀tìi nɛ̀ Komɔɔ kou kɛ̀ bɛ̀ɛ cokɛ́ kɛ́duó yɛ miɛkɛ, kɛ̀ bɛsɔmbɛɛ cokɛ́ kɛ́dekɛ ditɑ̃rì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kɛ̀ bɛ̀ɛ nɑ Sodɔmmu nɛ̀ Komɔɔ kɔbɛ kɛ́túótɛ́ bɛ kpɑ̀tì, nɛ̀ bɛ diitì kɛ́kònnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Kɛ múnkɛɛ túótɛ́nɛ̀ Dɔti Abɑrɑmmu nɑntɛ̀ birɛ nɛ̀ o kpɑ̀tì timɔu kɛ́kònnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kòò mɔùu cokɛ́ kɛ́kɔtɛ kɛ́nɑ́kɛ́ Abɑrɑmmu, Ebedeebɛ botí kou, ò borɛ̀ Amɔriibɛ botí kou Mɑmmudee kó dɛtie mborɛ̀. Mɑmmudee tebìí do tú Ɛsikɔɔdi nɛ̀ Anɛɛ. Bɛtɑ̃ɑ̃ti mɛmmɛ bɛ̀ do wɛ̃ńnɛ̀ Abɑrɑmmu nwe didootitĩ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abɑrɑmmu kèè dìì mɔ̀nnì bɛ̀ kònnɛ̀mɛ̀ Dɔti koò kpetí, kɛ́duɔ́ nkòo tɔ̃mbɛ̀ bɛ̀ piɛ́ bɛ̀ o cĩ́ɛ̃̀tɛ̀ kɛ̀ bɛ̀ɛ bɑ́ɑ́tí, sikɔusìtɑ̃ɑ̃ti nɛ̀ tɛpíítɛ̀ nɛ̀ bɛ̀ni (318), kɛ̀ bɛ̀ɛ tũnnɛ kɛ́tuɔkɛ Dɑnni tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Kɛ̀ Abɑrɑmmu bɛ̀ totí yɛtĩ̀rɛ̀ yɛtĩ̀rɛ̀ pɛ́u, kɛ̀ bɛ̀ɛ cɛ̃tìnnɛ bɛ dootitɔbɛ̀ kɛ́ bɛ̀ nɑ, kɛ́ bɛ̀ bɛ̀ti kɛ́tuɔkɛnɛ̀ Obɑɑ, dihɛì dìì bo Dɑmɑɑsi bɑkù yoú bíɛ́kɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","kɛ́fietɛ bɛ̀ do tùótɛ́ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ nɛ̀ Dɔti nɛ̀ o kpɛrɛ dɛmɔu nɛ̀ bɛnitipòbɛ̀ nɛ̀ bɛnitidɑɑbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abɑrɑmmu nɑ dìì mɔ̀nnì okpɑ̀ɑ̀tì Kedɔɔdɑomɛɛ nɛ̀ bɛkpɑ̀ɑ̀tìbɛ̀ bɛ̀ɛ̀ ò wɛ̃ńnɛ́ kɛ́nkũnti, kɛ̀ Sodɔmmu kóo kpɑ̀ɑ̀tìi yɛ̀nní kóò co Sɑfee kó kubiriku miɛkɛ, bɛ̀ tu kù okpɑ̀ɑ̀tì biriku. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Kɛ̀ Mɛsisedɛki Sɑdɛmmu kóo kpɑ̀ɑ̀tì wèè tu Kuyie nkùù bɑkɛ́ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ ku kuɔ́ nìùtì, kòo kɔtɛnní pɛ̃́ɛ̃̀ nɛ̀ mɛnɑɑ̀ nkóò co, ");
INSERT INTO tbzsim_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","kɛ́mɔɔ Kuyie nkó mɛsɑ̀ɑ̀ nhAbɑrɑmmu kpɛ́í nkɛ dɔ̀: Kuyie nkùù bɑkɛ́ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ kù dɑ dɔɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kuyie nkùù bɑkɛ́ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ kɛ te kɑ̀ɑ nɑ ɑ dootitɔbɛ̀ ku yètìrì ndɛu! Kɛ̀ Abɑrɑmmuu dɛitɛ ò tɔní dɛ̀ bɑ́ tɛ̀ɛ̀ píítɛ̀ miɛkɛ, dɛmɑ́ɑ̀ dɛmɑ́ɑ̀ kóò duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Kɛ̀ Sodɔmmu kóo kpɑ̀ɑ̀tìi nɑ́kɛ́ Abɑrɑmmu kɛ dɔ̀: N duɔ́ mbɛnìtìbɛ̀ kɛ́nte tinɛntì ɑ ɛí tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Kɛ̀ Abɑrɑmmuu ò tɛ̃̀ńnɛ́ kɛ dɔ̀: N youtɛ n nɔ̀ùtɛ̀ ntɛ, ti Yiɛ̀ nKuyie nkùù bɑkɛ́ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ ku ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","kɛ pɑ̀rìkɛ̀ kɛ tú n yí yóó túótɛ́ ɑ kpɛrɛ mɑrɛ̀ bɑ́ fɛpɑ̀ɑ̀konyĩɛ̃̀fɛ̀ yoo kunɛùkù kó kuhɔ̃ũ, ɑ yɑ̀ɑ̀ bo yĩ́ fɔ̃́ɔ̃̀ te mí nhAbɑrɑmmu kɛ̀ n nɑɑ́ nhokpɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","N yí yóó túótɛ́ dɛ̀mɑrɛ̀, kɛ̀ dɛ̀ í tú n kó bɛnìtìbɛ̀ di dɛ̀. Bɛ̀ɛ̀ n cíe mbɛɛ̀ tu: Anɛɛ nɛ̀ Ɛsikɔɔdi nɛ̀ Mɑmmudee, bɛɛ̀ bo túótɛ́ bɛ kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛnkɛ kumɑ́ɑ̀ Abɑrɑmmu kóò nɑ̀kɛ́ kɛ dɔ̀: Bɑ́ nyĩɛ̃̀kù! Míì tu ɑ kó kudɔpìkù, m bo dɑ cú dɛ̀ bo ndɛu mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Kɛ̀ Abɑrɑmmu dɔ̀: Ti Yiɛ̀ nKuyie nhɑ bo n duɔ́ mbɑ? N yí mɔkɛ dɛbirɛ, kɛ̀ n kóo tɔ̃ntì Ediesɛɛ Dɑmɑɑsi ɛì kou, wèè bo n cĩ́ɛ̃̀tɛ̀, weè yóó túótɛ́ n kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kɛ̀ ti Yiɛ̀ nKuyie nhò tɛ̃̀ńnɛ́ kɛ dɔ̀: Weè í yóó túótɛ́ ɑ kpɛrɛ. A yóó pɛitɛ́ dɛ̀ɛ̀ birɛ dɛɛ̀ yóó dɛ̀ tùótɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Kɛ̀ Kuyie ndennɛ Abɑrɑmmu ditowɑɑ̀ kóò nɑ̀kɛ́ kɛ dɔ̀: Bɔ́útɛ́ tiwɛtì kɛ́yɑ̀ siwɑ̃̀ɑ̃, ɑ bo nɑ kɛ́ sì kɑ̀ɑnɑɑ̀? Kɛ̀ kù yíɛ́ kɛ dɔ̀: Siwɑ̃̀ɑ̃ dòmmɛ̀, ɑ yɑɑ̀bí yóó sṹṹ mmɛɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Kɛ̀ Abɑrɑmmuu yie nti Yiɛ̀ nKuyie mbɛ́i ntì, kɛ̀ dɛɛ̀ nte kɛ̀ kù dɔ̀, ò dɔ̀ɔ̀ri kù dɔ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́i nkɛ dɔ̀: Míì dɑ íinní Uudi ɛì, Bɑbidɔnni kó kɛtenkɛ̀, kɛ bo dɑ duɔ́ kɛ ntenkɛ̀ ɑ mɛ̀ mbo kɛ̀ɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Kɛ̀ Abɑrɑmmu dɔ̀: Ti Yiɛ̀ nKuyie, m bo yĩ́mɛ kɛ́bɑntɛ́ n yóó tiekɛmɛ̀ dɛ kó kɛtenkɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kɛ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ kɛ dɔ̀: Wɑɑnní dinɑɑsɛrì nɛ̀ dibɔsɛrì nɛ̀ dipedɑɑ̀, dɛ̀ɛ̀ mɔ̀kɛ yɛbie nyɛ̀tɑ̃ɑ̃ti nɛ̀ tɛnɔ́nkpetɛ nɛ̀ dikpɛtìnɔ́nkperi. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kɛ̀ Abɑrɑmmu wɑɑnní iwũɔ̃ inyi, kɛ́kékɛ́ i cuokɛ̀, kɛ́ ì dɔú nkɛ́cuó nyitɔbɛ̀, ò mɛ nyí nkèkɛ́ sinɔ́nkpeé. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Kɛ̀ timɑncòntìi kɔtɛní, kɛ bo cɔ dɛ kó imɑɑ, nkòo tì bɛ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Diyiè tɑti dìì mɔ̀nnì kɛ̀ inuɔ mpĩ́ nhAbɑrɑmmu kòo duɔ́ mɛdiɛ̀, kɛ̀ dibiìnnì diɛrì mɑrìi ò sɔ̃̀ńtɛ́, kɛ̀ kufɔ̃wɑɑ́ nhò pĩ mmɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Kɛ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ kɛ dɔ̀: A nyɛ̃́ kɛ tú ɑ yɑɑ̀bí bo kɔtɛ dihɛì mɑrì dìì í tú i kpɛri, kɛ́ nkɛ̀ bo kɛ dɔ̀ yɛbie nsikɔusìnɑ̀ɑ̀ (400), kɛ tú tidɑɑtì kɛ̀ bɛ̀ ì fɛ̃́ũnko. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Kɛ̀ n fɛ̃́ũ ndɛ kó kubotí kùù ì fɛ̃́ũnko, kɑ̀ɑ yɑɑ̀bí nyɛtì kɛ tɔ tikpɑ̀tì mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Fɔ̃́ nhɑ yó mbonɛ̀ diwɛ̀ì ndi kɛ yɑ̀ɑ kótɛ́ kɛ́kú, kɛ̀ bɛ̀ dɑ kũnnɛ́ ɑ yɛmbɛ̀ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","A yɑɑ̀bí kó iyɑɑ̀bí, iì wɛ̃tiní kɛ ntenkɛ̀. Kɛ yɛ̃́ Amɔriibɛ yɛi mu nyí sũ̀ṹmmɛ̀ kɛ tùɔ̀kɛ m bo bɛ̀ bɛ̀ti dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Diyiè tɑ dìì mɔ̀nnì kɛ̀ dɛ̀ɛ biitɛ sɑ̃̀ṹ, kɛ̀ Kuyie nkɔtɛní kɛ́ndò mmuhɑ̃ɑ̃́ nnɛ̀ kuyukú nɛ̀ fɛhɑ̃ɑ̃dɛɛ̀nfɛ̀, kɛ pɛ̃nkù iwũɔ̃ bɛ̀ kèkɛ́ ì sɑ̀ku. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Dɛ yiè ndi ti Yiɛ̀ nKuyie ntɑ̀unnɛ̀mɛ̀ kumɑ́ɑ̀ Abɑrɑmmu kɛ dɔ̀: N yóó duɔ́ ndɛ kó kɛtenkɛ̀ ɑ yɑɑ̀bí nyi kɛ̀ ì nkɛ̀ te, kɛ́túótɛ́ kukó kùù bo Esibiti mɑ̀nku, kɛ́kɑ̃́ɑ̃́ kukó ndiɛkù Efɑdɑti. ");
INSERT INTO tbzsim_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Keniibɛ nɛ̀ Kenisiibɛ nɛ̀ Kɑdimɔniibɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","nɛ̀ Itiibɛ nɛ̀ Pedisiibɛ nɛ̀ Defɑiibɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","nɛ̀ Amɔriibɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Kidikɑsiibɛ nɛ̀ Yebusiibɛ, bɛɛ̀ te dɛ kó kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abɑrɑmmu pokù Sɑrɑii do í pɛitɛ́ dɛbirɛ. Kɛ nɛ́ mmɔkɛ kunitipodɑɑkù mɑkù, Esibiti kɔku, kɛ̀ ku yètìrì tu Akɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Kɛ̀ Sɑrɑii nɑ́kɛ́ o dɔù kɛ dɔ̀: A wúómmu ti Yiɛ̀ nKuyie nyí m pɑ̃mɛ̀ ibí. Duɔ́nɛ̀ n kó kudɑɑkù, kɛ̀ dɛ yɛ̀mmɛ̀ ò bo m pɛitɛ́ dɛbirɛ. Kɛ̀ Abɑrɑmmuu yie ndɛ kó tinɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Kɛ̀ Sɑrɑii túótɛ́ o kó kudɑɑkù Esibiti tenkɛ̀ kɔku Akɑɑ kɛ́puó nho dɔù Abɑrɑmmu. Dɛ̀ do sɔ̃́ nhò mɔ̀kɛ yɛbie ntɛpíítɛ̀ ntɛ Kɑnnɑhɑ̃ɑ̃ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kɛ̀ Abɑrɑmmuu duɔ́nɛ̀ Akɑɑ kòo púó. Ò bɑntɛ́ dìì mɔ̀nnì ò pùómmɛ̀ kɛ́senkɛ̀rì Sɑrɑii ò tu wèè kó kudɑɑkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kɛ̀ Sɑrɑii nɑ́kɛ́ Abɑrɑmmu kɛ dɔ̀: Fɔ̃́ɔ̃̀ te kɛ̀ bɛ̀ n sɑ̃̀ɑ̃́. Míì tùótɛ́ n kó kudɑɑkù kɛ dɑ puó, nɛ̀ kù bɑntɛ́mɛ̀ kɛ dò nkù pùó nkù tɛ̃́nkɛ í n wúó. Ti Yiɛ̀ nKuyie kuù bo ti pútɛ́ fɔ̃́ nnɛ̀ mí. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Kɛ̀ Abɑrɑmmuu nɑ́kɛ́ Sɑrɑii kɛ dɔ̀: A kó kudɑɑkù nku, kɛ̀ fɔ̃́ɔ̃̀ kù te, dɔɔ̀ ku ɑ dɔ́mɛ̀. Mɛm̀mɛ kɛ̀ Sɑrɑii fɛ̃́ũ nhAkɑɑ mmɛdiɛ̀, kòo cokɛ́ kɛ́tɑ dikpɑ́ɑ̀ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃nnìi ò yɑ̀ dikpɑ́ɑ̀ cuokɛ̀ tɛbintɛ mɑtɛ̀ tɑkɛ́, Suudi kó kucɛ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Kóò bekɛ kɛ dɔ̀: Akɑɑ ɑ bonní dɛ, ɑ kɔri kɛ? Kòò dɔ̀: N cokù Sɑrɑii nwe n tú wèè kó kudɑɑkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃nnìi ò nɑ̀kɛ́ kɛ dɔ̀: Wɛ̃tɛ o borɛ̀ kɛ́nyíé nhò yɛ̃ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kɛ̀ dìi yíɛ́ kɛ dɔ̀: Ti Yiɛ̀ nKuyie mbo duɔ́ nkɑ̀ɑ yɑɑ̀bíi sṹṹ mmɛdiɛ̀, bɑ́ òmɔù bɑ́ɑ́ nɑ kɛ́ ì kɑ̀ɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","A púó nkɛ yóó pɛitɛ́ dɛnitidɑbirɛ ndɛ, ɑ́ dɛ̀ yu kɛ dɔ̀ Isimɑyɛɛri, kɛ yɛ̃́ ti Yiɛ̀ nKuyie nkèèmɛ̀ ɑ sɑ́útìi. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Dɛ kó dɛbirɛ yó ndò ndikpɑ́ɑ̀ kóo sɑ̃mmɑrímú nwe, kɛ́nkpɑnnɛ̀ bɛnìtìbɛ̀ bɛmɔu, kɛ̀ bɛ̀ ndɛ kpɑ̀nnɛ̀, kɛ̀ dɛ̀ ncɑ̃́ɑ̃́ nkɛ ɑ̃ dɛmɑ́ɑ̀, kɛ dɛ́tirinɛ̀ dɛ kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Kɛ̀ Akɑɑ yú Kuyie nkùù o bɛ́innɛ̀ kɛ dɔ̀ Atɑ-Edii-Doyii (dɛ̀ɛ̀ tu: Ti Yiɛ̀ nKuyie nkùù n wùó). Kɛ dɔ̀: M mɛ̀nkɛ yɑ̀mu Kuyie nkɛ kpɑɑ́ fòùɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Dɛɛ̀ te kɛ̀ bɛ̀ yu tɛbintɛ tɛ̀ɛ̀ bo Kɑdɛɛsi, nɛ̀ Bedɛdi dɛ cuokɛ̀ kɛ tú: Dɑɑyii-Doyii (dɛ̀ɛ̀ tu: Kuyie kùù ǹ wùó nku kó tɛbintɛ). ");
INSERT INTO tbzsim_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kɛ̀ Akɑɑ pɛitɛ́ dɛnitidɑbirɛ, kɛ̀ dɛ cicɛ Abɑrɑmmuu dɛ̀ yu kɛ dɔ̀ Isimɑyɛɛri. ");
INSERT INTO tbzsim_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Akɑɑ do yóó pɛitɛ́ Abɑrɑmmu dɛbirɛ kɛ sɔ̃́ nhò mɔ̀kɛ yɛbie nsipísìni nɛ̀ yɛkuɔ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abɑrɑmmu mɔ̀kɛ dìì mɔ̀nnì yɛbie nsipísìwɛi nɛ̀ yɛ̀wɛi, kɛ̀ ti Yiɛ̀ nKuyie nhò bɛnkɛ kumɑ́ɑ̀, kóò nɑ̀kɛ́ kɛ dɔ̀: Míì tu Kuyie mmuwɛ̃rímú mumɔu yiɛ̀. A ndɔɔri n dɔ́mɛ̀ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","M bo dɑ tɑunnɛ̀ m mɑ́ɑ̀, kɛ́duɔ́ nkɑ̀ɑ yɑɑ̀bíi sṹṹ mmɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Kɛ̀ Abɑrɑmmuu nínkú kɛ́sĩ́nnɛ́ kɛtenkɛ̀, kɛ̀ Kuyie nhò nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","Ntɛ n yóó dɑ tɑunnɛ̀ mɛ̀ɛ̀ botí m mɑ́ɑ̀, fɔ̃́ɔ̃̀ yóó nɑɑ́ nyibotí pɛ́u cicɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","A yètìrì tɛ̃́nkɛ í yó ntú Abɑrɑmmu, bɛ̀ yó ndɑ yu kɛ tú Abɑrɑhɑmmu nwe, kɛ yɛ̃́ fɔ̃́ɔ̃̀ yóó nɑɑ́mmɛ̀ ibotí pɛ́u cicɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","M bo duɔ́ nkɑ̀ɑ yɑɑ̀bíi sṹṹ mmɛdiɛ̀ mmɔ́mmɔmmɛ, kɛ̀ bɛkpɑ̀ɑ̀tìbɛ̀ɛ ɑ̃nnɛ́ i miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","N yó ndɑ tɑummu, ɑ kó difɔ̃nkúò kɛ́ntɑunɛ̀ ɑ yɑɑ̀bí, itɔ̃ntì itɔ̃ntì, kɛ́ ndɑ te fɔ̃́ nnɛ̀ ɑ yɑɑ̀bí sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Fɔ̃́ nnɛ̀ ɑ yɑɑ̀bí m bo di duɔ́ nkɛtenkɛ̀ ɑ mɛ̀ mbo kɛ̀ kupɔ̀ɔ̀kù, di bo tiekɛ Kɑnnɑhɑ̃ɑ̃ omɔu sɑ̃́ɑ̃̀, mí nKuyie nkɛ̀ nní ndi te. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Kɛ̀ Kuyie nyíɛ́ kɛ́nɑ́kɛ́ Abɑrɑhɑmmu kɛ dɔ̀: Fɔ̃́ nnɛ̀ ɑ yɑɑ̀bí nɛ̀ di bo mbomɛ̀, di mpĩ́ n kó mɛtɑummɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Ntɛ di dò nkɛ́ndɔɔrimɛ̀ ti kó mɛtɑummɛ̀ miɛkɛ: Di fuku miɛkɛ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ tu bɛnitidɑɑbɛ̀ bɛ̀ ncɑ̃mmù. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Di kó mucɑ̃mmù muù yó mbɛnkú mí nnɛ̀ díndi ti tɑumɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","kɛ́ncɑ̃mmù nɛ̀ tidɑɑtì bɛ̀ piɛ́ tì di cɛ̃́ĩ nɛ̀ di do ntì, nɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ di bonɛ̀. Kɛ̀ di níí pɛitɛ́ dɛnitidɑbirɛ, dɛ̀ mmɔkɛ yɛwe yɛ̀ni kɛ dí dɛ̀ cɑ̃ntɛ́. Di yó mmɛ nhɔ̃ nkɛ̀ dɛ̀ ntú ti kó mɛtɑummɛ̀ kó mɛcɑnnimɛ̀ mí nnɛ̀ díndi sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Kɛ̀ wèè í cɑ̃ntɛ́ dí ò dènnɛ di cuokɛ̀, ò í tũ̀nnɛ mɛ̀ɛ̀ kpɛ́í n tɑummɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kɛ̀ Kuyie nnɑ́kɛ́ Abɑrɑhɑmmu kɛ dɔ̀: A tɛ̃́nkɛ bɑ́ nyu ɑ pokù kɛ tú Sɑrɑii, o yètìrì yó ntú Sɑrɑɑ nwe. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","M bo ò dɔ̀ɔ̀ mɛsɑ̀ɑ̀ nkòò dɑ pɛitɛ́ dɛnitidɑbirɛ, ò bo nɑɑ́ nyibotí pɛ́u yɔ̃. O yɑɑ̀bí miɛkɛ bɛkpɑ̀ɑ̀tìbɛ̀ bo buotɛ́ pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Kɛ̀ Abɑrɑhɑmmuu nínkú kɛ́sĩ́nnɛ́ kɛtenkɛ̀, kɛ́dɑɑ́, kɛ́bɛ́i nnɛ̀ o yɛ̀mmɛ̀ miɛkɛ kɛ dɔ̀: M bo yĩ́mɛ kɛ́pɛitɛ́ dɛbirɛ mí nwèè mɔ̀kɛ yɛbie ntɛkɔ̀ùtɛ̀ (100), kɛ̀ Sɑrɑɑ mɔ̀kɛ yɛbie n sipísìwɛi, ò bo yĩ́mɛ kɛ́pɛitɛ́? ");
INSERT INTO tbzsim_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kɛ̀ Abɑrɑhɑmmuu nɑ́kɛ́ Kuyie nkɛ dɔ̀: Kɛ̀ Isimɑyɛɛri cɛ̃́nkɛ fòù, kɑ̀ɑ ò dɔ̀ɔ̀ mɛsɑ̀ɑ̀, m bɑ́ɑ́ bekɛ òmɔù tɛ̃́nkɛ! ");
INSERT INTO tbzsim_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Kɛ̀ Kuyie nnɑ́kɛ́ Abɑrɑhɑmmu kɛ dɔ̀: A pokù Sɑrɑɑ bo dɑ pɛitɛ́ dɛnitidɑbirɛ, kɑ̀ɑ dɛ̀ yu kɛ dɔ̀ Isɑki. M bo nhò tɑunɛ̀ nɛ̀ o yɑɑ̀bío sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","A m bekɛ tì Isimɑyɛɛri kpɛ́í, n yiemmu kɛ yóó ò dɔɔ̀ mɛsɑ̀ɑ̀. Ò bo pɛitɛ́ mɛsɑ̀ɑ̀, nkòo botíi sṹṹ, bɛkpɑ̀ɑ̀tìbɛ̀ tɛpíítɛ̀ nɛ̀ bɛ̀dɛ́bɛ̀ bo yɛ̀nní o botí miɛkɛ, kòò ntú kubotí diɛkù yɑ̀ɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","N nɛ́ yó n tɑunɛ̀ Isɑki nwe, dɛ̀ yɑ̀ɑ yó nkɑ̃́ɑ̃́kɛ́ miɛ nkɛ̀ Sɑrɑɑ pɛitɛ́ wè. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kuyie nnɑ̀kɛ́ dìì mɔ̀nnì Abɑrɑhɑmmu kɛ́deè, kɛ́ítɛ́ kɛ́dekɛ kɛĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Kɛ̀ Abɑrɑhɑmmuu túótɛ́ o birɛ Isimɑyɛɛri nɛ̀ tidɑɑtì tìì piɛ́ o cĩ́ɛ̃̀tɛ̀ nɛ̀ ò do ntìì kó dimɑ̀ɑ̀ kɛ́ tì cɑ̃mmú dɛ kó diyiè Kuyie nhò nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Abɑrɑhɑmmu do mɔkɛ yɛbie nsipísìwɛi nɛ̀ yɛ̀wɛi ndi, kòo birɛ Isimɑyɛɛri mɔ̀kɛ tɛpíítɛ̀ nɛ̀ yɛ̀tɑ̃ɑ̃ti, kɛ̀ bɛ̀ɛ ò cɑ̃ntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abɑrɑhɑmmu nɛ̀ o birɛ Isimɑyɛɛri bɛ̀ ɛ̀nnɛ kɛ́cɑ̃ntɛ́ diyiè dìmɑ́ɑ̀ ndì, ");
INSERT INTO tbzsim_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","nɛ̀ tidɑɑtì bɛ̀ piɛ́ tì o cĩ́ɛ̃̀tɛ̀ nɛ̀ ò do ntì. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Dɛ mɔ̀nnì kɛ̀ ti Yiɛ̀ nKuyie mbɛnkɛ kumɑ́ɑ̀ Abɑrɑhɑmmu dibòrì bɛ̀ tu dì Mɑmmudee kó dɛtie mborɛ̀, kɛ sɔ̃́ ndiyiè còḿmú yɛyɔ kɛ̀ kuyiìnkù bo, kòò kɑ̀ri kutouku bòrìnùù, ");
INSERT INTO tbzsim_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","kɛ́yɑ̀ bɛnìtìbɛ̀ bɛ̀tɑ̃ɑ̃ti kɛ̀ bɛ̀ còḿmú o tɑkɛ́. Kòo ítóo kɛ́ bɛ̀ co kɛ́nínkú kɛ́sĩ́nnɔ́ɔ bɛ ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","kɛ́nɑ́kɛ́ bɛ kóò mɔù kɛ dɔ̀: Di bɑ́ɑ́ pɛ̃ɛ̃tɛ́ mí nhɑ kóo tɔ̃ntì n cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Yóunɛ̀ kɛ̀ bɛ̀ɛ wɑɑnní mɛniɛ nkɛ̀ dí ɔ́ú di nɑɑ̀cɛ̀i, kɛ́om̀pɛ̀ mutie muu ntɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","M bo wɑɑ́ mmudiì kɛ́ di duɔ́ nkɛ̀ dí di, kɛ́pɛ́tɛ́ muwɛ̃rímú, kɛ́nɑ kɛ́sɔɔtɛ́ di cɛ, di bɑ́ɑ́ pɛ̃ɛ̃tɛ́ n cĩ́ɛ̃̀tɛ̀ mɛmmɛ. Kɛ̀ bɛ̀ dɔ̀: Dɔɔ̀ ɑ bɛ́i ntì. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kɛ̀ Abɑrɑhɑmmuu cokɛ́ mɛcɑ̃ɑ̃ nkɛ́tɑroo kutouku Sɑrɑɑ borɛ̀, kóò nɑ̀kɛ́ kɛ dɔ̀: Wɑɑ́ mmuyuo mmù yó nsɑ̀nnɛ̀mɛ̀ kɛ́ɑ̃ntɛ kɛ́dɔɔ̀ tipɛ̃́mpɛ̃ńtì tìtɑ̃ɑ̃ti mɛcɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Dɛ kó difɔ̃nkúò kɛ̀ Abɑrɑhɑmmuu cokɛ́ kɛ́pĩ́nní dinɑɑdɑbii dìì wenni, kɛ ɑ̃ mɛkùɔ̀ nkɛ́duɔ́ nho kóo n tɔ̃ntì mɔù kòo dì kùɔ kɛ́bénnɛ́ mɛcɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Imɑɑ mbi dìì mɔ̀nnì kòo ì tùótɛ́ kɛ́wɑɑ́ mmɛnɑɑmiɛ̀ mmɛ̀ɛ̀ kɑ̃ntɛ́ nɛ̀ mɛ̀ɛ̀ ũmmú bɑ̀mbɑ̀ nkɛ́ bɛ̀ ĩ̀ńnɛ́, kɛ̀ bɛ̀ nyo nkòò còḿmú bɛ tɑkɛ́, kɛ dírí mutie. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Kɛ̀ bɛ̀ɛ bekɛ Abɑrɑhɑmmu kɛ dɔ̀: A pokù Sɑrɑɑ borɛ? Kòò dɔ̀: Ò bo kutouku miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kɛ̀ Kuyie ntɔ̃rɛ̀ kó dìmɑrì dɔ̀: Dɛ̀ yɑ̀ɑ bo nkɑ̃́ɑ̃́kɛ́ miɛ, kɛ̀ nní nwɛ̃tiní ɑ cĩ́ɛ̃̀tɛ̀ kɛ sɔ̃́ nhɑ pokù Sɑrɑɑ pɛitɛ́ dɛnitidɑbirɛ ndɛ. Kɛ̀ Sɑrɑɑ còḿmú kutouku bòrìnùù Abɑrɑhɑmmu fɔ̃nkúò kɛ yo. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abɑrɑhɑmmu nɛ̀ Sɑrɑɑ bɛ̀ do kòtɛ́ mɛdiɛ̀ mmɛ, bɑ́ Sɑrɑɑ tɛ̃́nkɛ í nyuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kɛ̀ Sɑrɑɑ dɑɑ́ omɑ́ɑ̀ borɛ̀ kɛ dɔ̀: N kòtɛ́mu n tɛ̃́nkɛ í yuɔ, kɛ̀ n dɔù múnkɛ kòtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kɛ̀ ti Yiɛ̀ nKuyie mbekɛ Abɑrɑhɑmmu kɛ dɔ̀: Dɛ̀ yĩ́mɛ kɛ̀ Sɑrɑɑ dɑɑ́, kɛ tú ò kòtɛ́ kɛ pɛ̃ɛ̃tɛ́ ò bo pɛitɛ́mɛ̀ dɛbirɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Dɛ̀mɑrɛ̀ bo ti Yiɛ̀ nKuyie nyĩɛ̃kú dɛ̀ɑ̀? Dɛ̀ yɑ̀ɑ bo nkɑ̃́ɑ̃́kɛ́ miɛ nkɛ̀ nní nwɛ̃tiní ɑ cĩ́ɛ̃̀tɛ̀ kɛ sɔ̃́ nSɑrɑɑ pɛitɛ́mu dɛnitidɑbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Kɛ̀ Sɑrɑɑ kɔ̃m̀bùɔ̀tìi do, kòo nɛnni kɛ dɔ̀: N yí dɑɑ́. Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: A dɑɑ́mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kɛ̀ dɛ kó bɛnìtìbɛ̀ɛ ítɛ́ kɛ́cuó nSodɔmmu bíɛ́kɛ̀, kɛ̀ Abɑrɑhɑmmuu bɛ̀ cíe. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́i nkɛ dɔ̀: M bɑ́ɑ́ sɔnnɛ Abɑrɑhɑmmu n yóó dɔɔ̀ tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","O kó kubotí yóó dɛukɛ mɛdiɛ̀ mmɛ kɛ́nkpeńnì. Weè yó nte kɛ̀ ibotí imɔuu pɛ́tɛ́ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","N we ntɑ̃ɑ̃tɛ́ kɛ bo duɔ́ nkòo bí nɛ̀ o yɑɑ̀bí kɛ̀ bɛ̀ nyíé n kuɔ́, kɛ̀ i borimɛ ńwenni kɛ̀ ì dɔ̀ɔ̀ri n dɔ́mɛ̀, kɛ̀ dɛ̀ɛ yie nkɛ̀ nh ò dɔ̀ɔ̀ mɛsɑ̀ɑ̀ n yɛ̃ n yóó ò dɔ̀ɔ̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Abɑrɑhɑmmu kɛ dɔ̀: Bɛnìtìbɛ̀ kuɔ̀nnɛ̀ Sodɔmmu nɛ̀ Komɔɔ dɛ kɔbɛ mɛdiɛ̀ mmɛ, bɛ cɑɑ̀rìmɛ̀ dɛumu. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","M bo kɔtɛ kɛ́síékɛ́, kɛ̀ bɛ̀ mɛ̀nkɛ cɑɑrimu n yɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Kɛ̀ bɛ̀dɛ́bɛ̀ɛ kétɛ́ kɛ́nkɔri Sodɔmmu bíɛ́kɛ̀ kɛ̀ ti Yiɛ̀ nKuyie nní nkpɑɑ́nɛ̀ Abɑrɑhɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Mɛm̀mɛ kɛ̀ Abɑrɑhɑmmu tɔ́ɔ́nko ti Yiɛ̀ nKuyie mborɛ̀ kɛ́ kù bekɛ kɛ dɔ̀: A bo yie nkɛ́wɛ̃nnɛ́ onitisɑ̀ù nɛ̀ oyɛiwe kɛ́kuɔɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Kɛ̀ bɛnitisɑ̀ɑ̀bɛ̀ bo Sodɔmmu sipísìnùmmù, ɑ bo bɛ̀ wɛ̃nnɛ́nɛ̀ kɛ́kuɔɑ̀? A bɑ́ɑ́ bɛ̀ cĩ̀ɛ̃́ nkɛ́yóu dihɛì bɛ kpɛ́ínɑ́ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Bìtì! A bɑ́ɑ́ yie nkɛ́ mɛ̀ dɔ̀ɔ̀. A bɑ́ɑ́ yie nkɛ́túótɛ́ onitisɑ̀ù kɛ́wɛ̃nnɛ́nɛ̀ oyɛiwe kɛ́kuɔ, kòò sɑ̀ùu cɔutɛ́ oyɛiwe kó tiyɛ̃ĩti. Fɔ̃́ nwèè bekùnɛ̀ kutenkù kumɔu, ɑ bɑ́ɑ́ yóu ɑ bo dɔɔ̀mɛ̀ dɛ̀ɛ̀ wenni. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Kɛ̀ ǹ yɑ̀ bɛnitisɑ̀ɑ̀bɛ̀ sipísìnùmmù Sodɔmmu miɛkɛ m bo cĩ́ɛ̃́ ndihɛì dimɔu bɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Kɛ̀ Abɑrɑhɑmmu dɔ̀: Yóu kɛ̀ n yíɛ́ dɑ bɛ́innɛ̀ n Yiɛ̀ nKuyie mí nwèè tu mutɑ̃́ɑ̃́ nkɛ tú mutɑ́pɛí. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kɛ̀ bɛ̀ í tùɔ̀kɛ sipísìnùmmù, kɛ bo sipísìnɑ̀ɑ̀ nɛ̀ bɛ̀nùmmù ɑ́ pɔntɛ dɛ kó dihɛìɑ̀ɑ̀? Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Kɛ̀ n yɑ̀ bɛ̀ɛ̀ wenni kɛ̀ bɛ̀ bo sipísìnɑ̀ɑ̀ nɛ̀ bɛ̀nùmmù, m bɑ́ɑ́ pɔntɛ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Kɛ̀ Abɑrɑhɑmmuu yíɛ́ kɛ́bɛ́i nkɛ dɔ̀: Kɛ̀ bɛ̀ɛ̀ wenni kɛ̀ bɛ̀ nɛ́ bo sipísìnɑ̀ɑ̀ tɑ́? Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Kɛ̀ bɛ̀ bo sipísìnɑ̀ɑ̀ m bɑ́ɑ́ pɔntɛ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Kɛ̀ Abɑrɑhɑmmu dɔ̀: A miɛkɛ bɑ́ɑ́ pɛikɛ n dɑ bɑ́ɑ́mmu, kɛ̀ bɛ̀ bo sipísìtɑ̃ɑ̃ti tɑ́? Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Kɛ̀ bɛ̀ bo sipísìtɑ̃ɑ̃ti m bɑ́ɑ́ dì pɔ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kɛ̀ Abɑrɑhɑmmu dɔ̀: N dɑ bɑ́ɑ́mmu yóu kɛ̀ n yíɛ́ kɛ́bɛ́i, kɛ̀ bɛ̀ bo sipísìdɛ́ tɑ́? Kɛ̀ ti Yiɛ̀ nKuyie n dɔ̀: Kɛ̀ bɛ̀ bo sipísìdɛ́ m bɑ́ɑ́ pɔntɛ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Kɛ̀ Abɑrɑhɑmmu yíɛ́ kɛ́bɛ́i nkɛ dɔ̀: N Yiɛ̀ nKuyie nhɑ bɑ́ɑ́ nh ɔunɛ̀, n yóó bɛ́i mmɛsɔmmɛ mmɛ. Bɛ̀ɛ̀ wenni kɛ̀ bɛ̀ bo tɛpíítɛ̀ tɑ́? Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Kɛ̀ bɛ̀ bo tɛpíítɛ̀ m bɑ́ɑ́ pɔntɛ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Bɛ̀ nɑ̀kɛ́ mɛmmɛ kɛ́deè, kɛ̀ ti Yiɛ̀ nKuyie nyítɛ́, kɛ̀ Abɑrɑhɑmmuu kò nho cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Kɛ̀ Kuyie ntɔ̃rɛ̀ yɛ̀dɛ́ɛ̀ tuɔkoo Sodɔmmu kuyuoku kɛ sɔ̃́ nDɔti kɑ̀ri dihɛì kó dibòrì, kɛ́ yɛ̀ yɑ̀ní kɛ́ítɛ́ kɛ́ yɛ̀ co, kɛ́nínkóo kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Kɛ dɔ̀: N di bɑ́ɑ́mmu kɛ tú dí kɔtɛ n cĩ́ɛ̃̀tɛ̀ kɛ́ɔ́ú di nɑɑ̀cɛ̀i, kɛ́yié nkɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ dí pɛ̃ɛ̃tɛ́. Kɛ̀ yɛ̀ dɔ̀: Áɑ̀, ti bo yiénko tikɑ̃titouti. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kɛ̀ Dɔtii yetoo kɛ̀ bɛ̀ɛ kò nho cĩ́ɛ̃̀tɛ̀, kòo dɔɔ̀ mudiì nɛ̀ pɛ̃́ɛ̃̀ wèè í kɔɔrɛnɛ̀ mutie mùù muuti kɛ̀ bɛ̀ɛ di. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bɛ̀ ketɛ́ kɛ mu nyí nduɔ́, kɛ̀ Sodɔmmu kó bɛnitidɑɑbɛ̀ bɛmɔu, ibí nɛ̀ bɛkótíbɛ̀, kɛ̀ bɛ̀ɛ kɔtɛní kɛ́cɛ̃ɛ̃tɛ tɛcĩ́ɛ̃̀tɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","kɛ́bekɛ Dɔti kɛ dɔ̀: Yé bɛnìtìbɛ̀ bɛ̀ɛ̀ bɑ̀tɛ́ ɑ cĩ́ɛ̃̀tɛ̀ kuyuoku? Dennɛní bɛ kɛ̀ tí bɛ̀ duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Kɛ̀ Dɔtii yɛ̀nní kɛ́cómmú ditowɑɑ̀ kɛ́kpetínnɛ́ dicɑ̀ù, ");
INSERT INTO tbzsim_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: N nɛ́pobɛ̀, bɑ́ɑ́ dɔɔ̀nɛ̀ mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","M mɔkɛ bɛsɑpɑ̀mbɛ̀ bɛ̀dɛ́bɛ̀ bɛ̀ɛ̀ mu nyí yɛ̃́ onitidɔ̀ù, m bo bɛ̀ dènnɛní kɛ̀ dí bɛ̀ dɔ̀ɔ̀nɛ̀ di dɔ́mɛ̀, kɛ̀ biɛ, n kó bɛpɔ̀ɔ̀bɛ̀ mbɛ, di bɑ́ɑ́ bɛ̀ dɔ̀ɔ̀ mɛyɛi mbɛ̀ tɑ n cĩ́ɛ̃̀tɛ̀ ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Kɛ̀ bɛ̀ɛ nɑ́kɛ́ Dɔti kɛ dɔ̀: Ítɛ́ dɛndɛ! A tú opɔ̀ɔ̀ nwe diɛ. Fɔ̃́ɔ̃̀ bɑ́ɑ́ ti nɑ́kɛ́ ti dò nkɛ́dɔɔ̀mɛ̀. Kɑ̀ɑ í yɛ̃́ tí dɑ dɔɔ̀ mɛyɛi nkɛ̀ mɛ̀ɛ pɛ̃ɛ̃tɛ́ ti nɑ mbɛ̀ dɔ̀ɔ̀ mɛ̀. Bɛ̀ yĩ mɛmmɛ kóò tèntoo kɛ́ndɔ́ kɛ́pɔntɛ dicɑ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kɛ̀ dɛ kó bɛnìtìbɛ̀ bɛdɛ́bɛ̀ɛ dɛtɛ Dɔti kɛ́tɑnnɔ̀ɔ bɛ borɛ̀, kɛ́kpetínnɛ́ dicɑ̀ù, ");
INSERT INTO tbzsim_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","kɛ́ bɛ̀ bɔntɛ́ tiyũ̀ɔ̃̀ntì bɛmɔu, ibí nɛ̀ bɛkótíbɛ̀, kɛ̀ bɛ̀ nhɑ̀rì ditowɑɑ̀ bɑ́ bɛ̀ í nyɑ̀ dibòrì bo kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kɛ̀ Kuyie ntɔ̃rɛ̀ yɛdɛ́ɛ̀ nɑ́kɛ́ Dɔti kɛ dɔ̀: Kɑ̀ɑ mɔ̀kɛ ɑ kɔbɛ dihɛì diì mmiɛkɛ, ɑ cɔ̀ɔ̀bɛ̀ nɛ̀ initidɑbí nɛ̀ initipobí, ɑ bɛ̀ dènnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ti Yiɛ̀ nKuyie nkèè bɛnìtìbɛ̀ kuɔ̀nnɛ̀mɛ̀ mmɛ dihɛì diì nkɔbɛ, kɛ ti tɔ̃nní kɛ̀ ti yóó dì pɔ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kɛ̀ Dɔtii yɛ̀ kɛ́nɑ́kɛ́ o cɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ do pɔ̃ o sɑpɑ̀mbɛ̀, kɛ dɔ̀: Yɛ̀nnɛ̀ dihɛì diì mmɛcɑ̃ɑ̃, ti Yiɛ̀ nKuyie nyóó dì pɔ̀ntɛmu. Kɛ̀ bɛ yɛ̀mmɛ̀ ndò nhò nu nwɑ́ntí. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kukṹnwentóo mɔ̀nnì kɛ̀ Kuyie ntɔ̃rɛ̀ɛ nɑ́kɛ́ Dɔti kɛ dɔ̀: Mɔ́nnɛ́ mɛcɑ̃ɑ̃ nkɛ́túótɛ́ ɑ pokù, nɛ̀ ɑ sɑpùmbí idɛ́ kɛ̀ di yɛ̀ dihɛì, kɛ̀ dɛ̀ í dò mmɛmmɛ di bo kú mɛyɛi mbo tuɔkɛní dìì mɔ̀nnì dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Kɛ̀ Dɔti nhɔɔtí kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃rɛ̀ɛ bɛ̀ dɛ̀tɛ, wenwe nɛ̀ o pokù nɛ̀ o sɑpùmbí idɛ́, kɛ́yɛ̀nnɛ̀ dihɛì mɑ̀nku, kɛ yɛ̃́ ti Yiɛ̀ nKuyie ndɔ́mɛ̀ kóò dɛɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kuyie ntɔ̃rɛ̀ bɛ̀ dènnɛ dìì mɔ̀nnì dihɛì mɑ̀nku, kɛ̀ dìmɑrì mɑ́ɑ̀ ò nɑ̀kɛ́ kɛ dɔ̀: Cokɛ́ kɛ́dɛɛtɛ́ ɑ fòmmu, ɑ bɑ́ɑ́ wɛ̃ɛ̃tɛ ɑ fɔ̃nkúò, ɑ bɑ́ɑ́ cómmú dɛ̀mɑrɛ̀ kutempɛ̃ nkuù mmiɛkɛ. Á cokɛ́ kɛ́sɔri ditɑ̃rì diì mborɛ̀ kɛ́dontɛ́ ɑ ɔ̃nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Kɛ̀ Dɔti dɔ̀: Áɑ̀, m bɑ́ɑ́ nɑ! ");
INSERT INTO tbzsim_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","A n dɔ̀ɔ̀mu mɛsɑ̀ɑ̀, kɛ n kuɔ́ mmɛsémmɛ̀ kɛ n dɛɛtɛ́. N yí yóó nɑ kɛ́cokɛ́ kɛ́tuɔkɛ di ntɑ̃rì kɛ̀ mɛyɛi nkpɑɑní, n yó nkpɑɑ́ cokù kɛ̀ mɛ̀ n nìntɛmu kɛ́ n kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ntɛ tɛhɛitɛ̀ sɑ́m̀pɔ́tɛ̀ tɛ̀ɛ̀ tɔ̀kɛ́ní, n yóó nɑ kɛ́cokɛ́ kɛ́tuɔkɛ tɛ̀. Tɛ̀ mɑ̀ sɑ́m̀pɔ́rɛ̀ ndɛ, yóu kɛ̀ n cokɛ́ kɛ́ dɛ nsɔri kɛ́dontɛ́ nh ɔ̃nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kɛ̀ Kuyie ntɔ̃nnì dɔ̀: Ɛ̃ɛ̃, n yiemmu kɛ bo wɛ̃tɛ kɛ́ dɑ dɔɔ̀ mɛsɑ̀ɑ̀ nkɛ́yóu dɛ kó tɛhɛitɛ̀ ɑ yɛ̃ ntɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Kɔtɛ mɛcɑ̃ɑ̃ nkɛ́sɔri, kɑ̀ɑ í tùɔ̀kɛ n yí yóó dɔɔ̀ tìmɑtì. Kɛ̀ bɛ̀ɛ yú dɛ kó dihɛì kɛ dɔ̀ Soɑɑ (dɛ̀ɛ̀ tu tɛhɛitɛ̀). ");
INSERT INTO tbzsim_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Kɛ̀ Dɔti nyóó tuɔkɛ Soɑɑ kɛ sɔ̃́ ndiyiè yɛ̀nní. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie ncṹũnní muhɑ̃pòpùo nSodɔmmu ɛì nɛ̀ Komɔɔ ɛì ĩ́nkɛ̀, kɛ̀ mù ncɔ́ú. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Kɛ̀ dɛ kó yɛhɛkɛ̀ yɛdɛ́ cɔ́útɛ́, nɛ̀ kɛtenkɛ̀ nɛ̀ bɛnìtìbɛ̀ nɛ̀ dɛtie. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kɛ̀ Dɔti pokùu wɛ̃ɛ̃tɛ o fɔ̃nkúò kɛ́nɑɑ́ ndikɔ́kɛ́tɑ̃́rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Abɑrɑhɑmmuu yɛ̀ dikṹnweńnì sɛ̀ì, kɛ́kɔtɛ ti Yiɛ̀ nKuyie nwee ò nɑ̀ɑ́nnɛ̀ dɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","kɛ́wéntɛ́ Sodɔmmu nɛ̀ Komɔɔ nɛ̀ yɛhɛkɛ̀ yɛ̀ɛ̀ dɛ̀ tɔ̀kɛ́ kɛ́yɑ̀ kuyukú kɛ̀ kù yìɛ̀ kɛ dò nfɛhɑ̃ɑ̃tofɛ kɔku. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Kuyie ndɔ́ kɛ́cɔ́u ndìì mɔ̀nnì yɛhɛkɛ̀ Dɔti do bo kɛ̀ɛ̀ tenkɛ̀ kpɛyɛ, kɛ́coo mmu Dɔti kù yɛ̃́ mɛ̀ɛ̀ kpɛ́í nhAbɑrɑhɑmmu kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Dɛ mɔ̀nnì kɛ̀ Dɔtii yɔtɛ ò bo mbomɛ̀ Soɑɑ ɛì, kɛ́ítɛ́ nɛ̀ o sɑpɑ̀mbɛ̀ bɛdɛ́ kɛ́kɔtɛ kɛ́nhɑ̃ kutɑ̃dènkù mɑkù miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Kɛ̀ Nkɔɔ nɑ́kɛ́ o nɑntɛ̀ kɛ dɔ̀: Ti cicɛ kòtɛ́mu, òmɔù mɛ nyí bo wèè bo ti puokɛ kɛ́ndònnɛ̀ ibotí imɔu dɔ̀ɔ̀rimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Yóu kɛ̀ tí ò duɔ́ mmɛnɑɑ̀ nkòo yɑ̃̀ kɛ́muɔ́, kɛ̀ tí kɔtoo kɛyènkɛ̀, kòo ti duɔ́nɛ̀ kɛ̀ tí pɛitɛ́ ibí kɛ̀ ìi sɔɔtɛ́ o cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Dɛ kó kuyuoku kɛ̀ bɛ̀ɛ duɔ́ mbɛ cicɛ mɛnɑɑ̀ nkòo muɔ́, kɛ̀ Nkɔɔ kɔtɛ bɑ́ o cicɛ í yɛ̃́ ò tɑroo dìì mɔ̀nnì yoo ò yɛ̀ dìì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Kɛ̀ dɛ̀ɛ wentɛ́ kòo nɑ́kɛ́ o nɑntɛ̀ kɛ dɔ̀: Nɛ̀ n cicɛ ti duɔ́mu kɛyènkɛ̀. Tí wɛ̃tɛ kóò duɔ́ mmɛnɑɑ̀ nkòo muɔ́, nkɑ̀ɑ mɛ ntó kɔtɛ kɛ nyènkɛ̀ kóò duɔ́nɛ̀, ti yóó mɛ nyĩ́ kɛ́pɛitɛ́ ibí kɛ̀ ìì sɔɔtɛ́ o cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Kɛ̀ bɛ̀ tó ò duɔ́ mmɛnɑɑ̀ nkòo muɔ́, kòo sɑ́m̀pɔ́ù mɛ ntó kɔtɛ kóò duɔ́nɛ̀, bɛ cicɛ í nyɛ̃́ ò kɔ̀too dìì mɔ̀nnì nɛ̀ ò ìtɛ́ dìì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Mɛm̀mɛ Dɔti pòńnɛ́mɛ̀ o sɑpɑ̀mbɛ̀ bɛdɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Kɛ̀ Nkɔɔ pɛitɛ́ dɛnitidɑbirɛ kɛ́ dɛ̀ yu kɛ dɔ̀: Mɔɑbu. Weè yɑɑ̀bí tú Mɔɑbiibɛ yíe nkó diyiè. ");
INSERT INTO tbzsim_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kòo sɑ́m̀pɔ́ùu pɛitɛ́ dɛnitidɑbirɛ kɛ́ dɛ̀ yu kɛ dɔ̀: Bɛni-Ami. Bɛ̀ yu weè kó iyɑɑ̀bí kɛ tú Amɔniibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Kɛ̀ Abɑrɑhɑmmuu ítɛ́ Nɛkɛbu tempɛ̃ kɛ́kɑri Kɑdɛɛsi nɛ̀ Suudi ɛì dɛ cuokɛ̀, kɛ́ dɛ̀ ìtɛ́ kɛ́kɑri Kedɑɑri ɛì, ");
INSERT INTO tbzsim_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","kɛ́nnɑ́ɑ́ nkɛ tú o pokù Sɑrɑɑ tu o tɑ̃ũ̀. Kɛ̀ Abimɛdɛki Kedɑɑri kóo kpɑ̀ɑ̀tìi túótɛ́ Sɑrɑɑ kɛ́kònnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kɛ̀ Kuyie nnɑ́kɛ́ Abimɛdɛki nɛ̀ tidɔuǹtì kɛyènkɛ̀ kɛ dɔ̀: A mɛ ntùótɛ́ wèè nitipòkù ɑ yóó kúmu, ò yemmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Kɛ sɔ̃́ nhAbimɛdɛki mu nyí ò duɔ́nɛ̀, kɛ́nɑ́kɛ́ Kuyie nkɛ dɔ̀: N Yiɛ̀, n yí cɑ̀ɑ̀rɛ̀, ɑ bo sɔ̃́ntɛ́ kɛ́ n kuɔɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abɑrɑhɑmmu n nɑ̀kɛ́ kɛ tú o tɑ̃ũ̀ nwe, kòo nitipòkù múnkɛ yɛ̃ nho tɑ̃ũ̀ nwe. N yí ò tòú kɛ yĩɛ̃̀kù, n yí cɑ̀ɑ̀rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Kɛ̀ Kuyie nyíɛ́ kóò bɛ́innɛ̀ tidɔuǹtì kɛ dɔ̀: N yɛ̃́mu kɛ tú ɑ ò tòú kɛ̀ í yĩɛ̃̀kù. N yí dɔ́ ɑ n yetɛ́nɛ̀mu, dɛɛ̀ te kɛ̀ n yí yóu kɑ̀ɑ ò duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Tɛ̃́nnɛ́ dɛ kóo nitipòkù o dɔù. Ò dɔù tu m pɑ̃ɑ̃nɑ́ɑǹtì nɑ́ɑǹtò nwe. Ò bo m bɑ́ntɛ̀ ɑ kpɛ́í kɑ̀ɑ nfòù. Kɑ̀ɑ mɛ nyí ò tɛ̃̀ńnɛ́, ɑ́ nyɛ̃́ kɛ tú ɑ yóó kúmu nɛ̀ ɑ kɔbɛ bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kɛ̀ Abimɛdɛkii entɛ dikṹnweńnì sɛ̀ì, kɛ́yú o kó bɛtũ̀mbɛ̀, kɛ́ bɛ̀ nɑ̀kɛ́ dɛ̀ɛ̀ dɔ̀ɔ̀, kɛ̀ kufɔ̃wɑɑ́ mbɛ̀ pĩ. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Kɛ̀ Abimɛdɛkii yú Abɑrɑhɑmmu kóò bekɛ kɛ dɔ̀: Dɛ̀ yĩ́mɛ kɑ̀ɑ ti dɔ̀ɔ̀ miɛ? N dɑ cɑ̀ɑ̀rɛ̀ bɑ, kɑ̀ɑ dɔ́ mɛyɛi ndiɛmɛ̀ɛ do mí nnɛ̀ n kɔbɛ ti ĩ́nkɛ̀? A n dɔ̀ɔ̀ onìtì í dɔɔrimɛ̀ mmɛ otɔù, ");
INSERT INTO tbzsim_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","bɑ nte kɑ̀ɑ dɔ̀ɔ̀ mɛmmɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Kɛ̀ Abɑrɑhɑmmu dɔ̀: N yɛ̀mmɛ̀ do dò ndi nhɛì kɔbɛ í dému Kuyie nkɛ yó n kuɔ m pokù kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ò tu n tɑ̃ũ̀ nwe bɑkɛ yie, kɛ̀ ti wɛ̃ nti cicɛ omɑ́ɑ̀ kɛ̀ ti yɔ̃bɛ̀ nɛ́ cɑ̃́ɑ̃́. Kɛ̀ nh ò puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Kuyie nduɔ́ ndìì mɔ̀nnì kɛ̀ n yìtɛ́ n cicɛ cĩ́ɛ̃̀tɛ̀, n nɑ̀kɛ́ diì mɔ̀nnì m pokù kɛ dɔ̀: Kɛ̀ ti kɔ̀tɛ kɛ̀ɛ̀ bíɛ́kɛ̀ ɑ dɔ̀ ɑ tú n tɑ̃ũ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Kɛ̀ Abimɛdɛkii túótɛ́ ipe nɛ̀ sibɔɔ́ nɛ̀ inɑ̀ɑ̀kɛ nɛ̀ tidɑɑtì, bɛnitidɑɑbɛ̀ nɛ̀ bɛnitipòbɛ̀, kɛ́duɔ́ nhAbɑrɑhɑmmu, kóò tɛ̃̀ńnɛ́ o pokù Sɑrɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Kóò nɑ̀kɛ́ kɛ dɔ̀: Ntɛ dihɛì dimɔu, wéntɛ́ ɑ dɔ́ kɛ̀ɛ̀ bíɛ́kɛ̀ kɛ́mɑɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Kòo nɑ́kɛ́ Sɑrɑɑ kɛ dɔ̀: N duɔ́mmu ɑ tɑ̃ũ̀ mɛdítíbii ntɛkɔupíítɛ̀ (1000), kɛ̀ dɛ̀ bo bɛnkɛ ɑ kɔbɛ bɛmɔu ɑ í dɔ̀ɔ̀mɛ̀ mmɛ tìmɑtì tinɑ́ɑǹtì tii mmiɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Kɛ̀ Abɑrɑhɑmmuu bɑ́ntɛ̀ Kuyie, kɛ̀ Abimɛdɛki nɛ̀ o pokù nɛ̀ o bí kɛ̀ bɛ̀ɛ miɛtɛ́, kɛ́piɛ́ ibí. ");
INSERT INTO tbzsim_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Kɛ yɛ̃́ ti Yiɛ̀ nKuyie ndo duɔ́mmɛ̀ kɛ̀ Abimɛdɛki cĩ́ɛ̃̀tɛ̀ kɔbɛ bɛmɔu tɛ̃́nkɛ í mpɛí, Abɑrɑhɑmmu pokù Sɑrɑɑ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Ti Yiɛ̀ nKuyie nyí nyɛ̃̀ nkù do yɛ̃ nkù yóó dɔɔ̀ tì Sɑrɑɑ, kɛ́ tì dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kɛ̀ Sɑrɑɑ púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ Kuyie ndo yɛ̃ nhò yóó dɛ̀ pɛitɛ́ dìì mɔ̀nnì. Kɛ sɔ̃́ nhAbɑrɑhɑmmu kòtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Kɛ̀ Abɑrɑhɑmmuu yú o pokù Sɑrɑɑ ò pɛitɛ́ dɛ̀ɛ̀ birɛ kɛ dɔ̀ Isɑki. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Kɛ̀ Abɑrɑhɑmmu dɛ̀ cɑ̃ntɛ́ diyiè niínnì yiè Kuyie ntì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Bɛ̀ do yóó pɛitɛ́ Isɑki kɛ sɔ̃́ nhAbɑrɑhɑmmu mɔ̀kɛ yɛbie ntɛkɔ̀ùtɛ̀ (100) ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Kɛ̀ Sɑrɑɑ bɛ́i nkɛ dɔ̀: Kuyie nni n dɔ̀ɔ̀ diwɛ̀ì ndi. Bɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo keè Isɑki kpɛ́í diwɛ̀ì bo bɛ̀ pĩ n kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kòo yíɛ́ kɛ́bɛ́i nkɛ dɔ̀: We ndo yɛ̃́ kɛ dò nSɑrɑɑ bo piɛ́ Abɑrɑhɑmmu ibí diyiè mɑrì! Ntɛ mí nkoò pɛitɛ́ dɛnitidɑbirɛ o kótì cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kɛ̀ dɛbirɛɛ kótɛ́, dɛ̀ cɑ̀tɛ́ dìì yiè kɛ̀ Abɑrɑhɑmmuu ɑ̃nnɛ́ dibɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Kɛ̀ Esibiti kóo nitipòkù pɛitɛ́ dɛ̀ɛ̀ birɛ Abɑrɑhɑmmu, Isimɑyɛɛri ndɑú Isɑki kɛ̀ Sɑrɑɑ dɛ̀ yɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","kɛ́nɑ́kɛ́ Abɑrɑhɑmmu kɛ dɔ̀: Bɛti kudɑɑkù kuù nnɛ̀ ku birɛ. Dɛdɑɑbirɛ bɑ́ɑ́ wɛ̃nnɛ́nɛ̀ n kpɛrɛ Isɑki kɛ́tiekɛ ɑ kpɛrɛ ɑ kṹṹ nkó difɔ̃nkúò. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Kɛ̀ dɛ kó tinɑ́ɑǹtìi yonkɛ Abɑrɑhɑmmu mɛdiɛ̀, kɛ yɛ̃́ Isimɑyɛɛri múnkɛ do túmɛ̀ o birɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kɛ̀ Kuyie nnɑ́kɛ́ Abɑrɑhɑmmu kɛ dɔ̀: Kudɑɑkù nɛ̀ ku birɛ kó tinɑ́ɑǹtì bɑ́ɑ́ dɑ yonkɛ, yie nSɑrɑɑ dɑ nɑ́ɑ́ ntì. Isɑki kó kufuku miɛkɛ nkɛ ɑ yóó pɛ́tɛ́mɛ̀ iyɑɑ̀bí, kɛ̀ dɛ̀ɛ dɔɔ̀ n dɑ nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","N yóó duɔ́ nkɛ̀ dɛdɑɑbirɛ kó kuwuɔ mmúnkɛɛ pɛ̃kɛ̀mu, kɛ yɛ̃́ dɛ̀ tumɛ̀ ɑ birɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Dikṹnweńnì sɛ̀ì kɛ̀ Abɑrɑhɑmmuu túótɛ́ pɛ̃́ɛ̃̀ kɛ́cũɔ̃́ mɛniɛ nkudɔukù miɛkɛ, kɛ́duɔ́ nhAkɑɑ, kóò duɔ́ nho birɛ, kóò bɛ̀ti, kòo kɔtɛ kɛ́nhɑ̀rì dikpɑ́ɑ̀ cuokɛ̀ bɛ̀ tu dì Bɛɛrisebɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mɛniɛ ndèè dìì mɔ̀nnì kudɔukù miɛkɛ kòo dɔú ndɛbirɛ tɛtietɛ mɑtɛ̀ tɑkɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","kɛ́kɔtɛ kɛ́nkɑri mɛdɛ́timɛ̀ kɛ̀ dɛ̀ mɑ̀nnɛ̀ ɑ bo tɑ̃ũmɛ̀ kupie, kɛ kuɔ̀ nkɛ tú: N yí dɔ́ ń yɑ̀ m birɛ kɔ̃ ndɛ̀! ");
INSERT INTO tbzsim_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Kɛ̀ Kuyie nkeè dɛbirɛ kuɔ̀mmɛ̀, kɛ̀ ku tɔ̃nnì ḿboní kɛĩ́nkɛ̀ kɛ́yú Akɑɑ kɛ dɔ̀: Dɛ̀ dòmmɛ? Bɑ́ nyĩɛ̃̀kù Kuyie nkèèmu dɛbirɛ kuɔ̀mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ítɛ́ kɛ́íi nhɑ birɛ kɛ́ dɛ̀ dɛ̀tɛ, dɛɛ̀ yóó nɑɑ́ nkuwuɔ ndiɛkù cicɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kɛ̀ Kuyie nkpetɛ́ Akɑɑ nuɔ nkòo yɑ̀ tɛbintɛ mɑtɛ̀, kɛ́kɔtɛ kɛ́píɛ mmɛniɛ nho dɔukù miɛkɛ kɛ́duɔ́ nho birɛ kɛ̀ dɛ̀ɛ yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Kɛ̀ Kuyie nní ntɔ dɛbirɛ, kɛ̀ dɛ̀ɛ kótɛ́ dikpɑ́ɑ̀ cuokɛ̀ kɛ́ nɑɑ́ nhohoditɑ̃ũtì diɛwè. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Bɛ̀ do bo dikpɑ́ɑ̀ bɛ̀ tu dì ndi Edi-Pɑdɑnni, kòo yɔ̃ ò puó nhEsibiti kóo nitipòkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Dɛ kó dimɔ̀nnì, kɛ̀ Abimɛdɛkii kɔtɛní Abɑrɑhɑmmu borɛ̀ kɛ nɛínɛ̀ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ kóo kótì Pikɔdi, kɛ́nɑ́kɛ́ Abɑrɑhɑmmu kɛ dɔ̀: Kuyie ndɑ bonɛ̀mu ɑ tɔ̃mmú mumɔu miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","bɛ́i nkɛ́yú Kuyie nyètìrì kɛ dɔ̀, ɑ í yó n soutɛ́ mí nnɛ̀ m bí nɛ̀ n yɑɑ̀bío, kɛ yó nni n dɔɔri mɛsɑ̀ɑ̀ nnɛ̀ nh ɛì ɑ bo dìì miɛkɛ, kɛ́ndònnɛ̀ n dɑ dɔ̀ɔ̀mɛ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kɛ̀ Abɑrɑhɑmmu dɔ̀: N yiemmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Kɛ nɛ́ bɛ́innɛ̀ Abimɛdɛki tɛbintɛ mɑtɛ̀ kpɛ́í, Abimɛdɛki kó bɛtɔ̃mbɛ̀ do fìètɛ tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kɛ̀ Abimɛdɛki dɔ̀: N yí yɛ̃́ dɛ kó tinɑ́ɑǹtì, ɑ í tì nni n nɑ̀kɛ́, yíe nwe n tì kèèmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kɛ̀ Abɑrɑhɑmmuu duɔ́ nyipe nɛ̀ inɑ̀ɑ̀kɛ Abimɛdɛki, kɛ̀ bɛ̀ɛ tɑunnɛ̀ bɛtɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Kɛ̀ Abɑrɑhɑmmuu dɛitɛ yɛpesɛrɛ̀ yɛ̀yiekɛ̀ kɛ́cɑ̃́nnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kɛ̀ Abimɛdɛki dɔ̀: Bɑ nkpɛ́í nte kɑ̀ɑ cɑ̃̀ńnɛ́ yɛpesɛrɛ̀ yɛ̀yiekɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Kɛ̀ Abɑrɑhɑmmu dɔ̀: Cɔutɛ́ yɛ, kɛ̀ dɛ̀ mbɛnkú míì keúmɛ̀ tɛbintɛ tiɛ nkɛ tɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Kɛ̀ bɛ̀ɛ yú dɛborɛ̀ kɛ dɔ̀: Bɛɛrisebɑɑ, kɛ yɛ̃́ bɛ̀ dɛ nwɛ̃nnɛ́mɛ̀ dinùù. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Bɛ̀ dɛ ntɑunnɛ̀ bɛtɔbɛ̀, kɛ̀ Abimɛdɛkii ítɛ́ kɛ́wɛ̃tɛ Fidisitɛ̃ɛ̃bɛ kó dihɛì, kɛ nɛínɛ̀ Pikɔdi o ɑ̃ɑ̃pɔ̀mbɛ̀ kóo kótì. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Kɛ̀ Abɑrɑhɑmmuu fííkú Bɛɛrisebɑɑ ɛì dɛtie mbɛ̀ tu dɛ̀ tɑmɑdii, kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie, kɛ́ kù yu kɛ dɔ̀ o Yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Kɛ̀ Abɑrɑhɑmmu ḿbo Fidisitɛ̃ɛ̃bɛ ɛì kɛ́mɔntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Kɛ̀ Kuyie nní nyóó yɑ́ɑ́kɛ́ Abɑrɑhɑmmu kɛ dɔ̀: Abɑrɑhɑmmu! Kòò dɔ̀: Ntɛ mí. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Kɛ̀ kù dɔ̀: Túótɛ́ ɑ birɛ Isɑki dɛ̀ɛ̀ bo dɛmɑ́ɑ̀, kɑ̀ɑ dɛ̀ dɔ́, kɛ́kɔtɛnɛ̀ Mɔdiyɑɑ kó dihɛì, ditɑ̃rì n yóó dɑ bɛnkɛ dì ĩ́nkɛ̀ kɛ́ dɛ̀ nni féútɛ́ kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kɛ̀ dɛ̀ɛ wentɛ́, dikṹnweńnì sɛ̀ì, kɛ̀ Abɑrɑhɑmmuu ítɛ́ kɛ́yɑrí idɛí, kɛ́ɑ̃nnɛ́ sɑ̃mmɑrímú tinɛntì, kɛ́túótɛ́ o tɔ̃mbɛ̀ bɛ̀dɛ́bɛ̀ nɛ̀ o birɛ Isɑki, kɛ̀ bɛ̀ɛ kétɛ́ kɛ́nkɔri Kuyie nhò bɛnkɛ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Diyiè tɑ̃ɑ̃́nnì yiè, kòo wéntɛ́ mɛdɛ́timɛ̀ kɛ́yɑ̀ ditɑ̃rì bɛ̀ kɔ̀ri dì, ");
INSERT INTO tbzsim_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","kɛ́nɑ́kɛ́ o tɔ̃mbɛ̀ kɛ dɔ̀: Nkpɑɑ́nɛ̀ diɛ nnɛ̀ sɑ̃mmɑrímú, mí nnɛ̀ odɑpɑ̀ɑ̀ nkɛ̀ tí dekɛ ditɑ̃rì kɛ́bɑ́ntɛ̀ Kuyie nkɛ́wɛ̃tɛní di borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kòo toú nho birɛ Isɑki idɛí kɛ́ntɔ muhɑ̃ɑ̃́ nnɛ̀ disiè, kɛ̀ bɛ̀ nkérí bɛdɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Kɛ̀ Isɑkii yú o cicɛ kɛ dɔ̀: N cicɛ! Kòò dɔ̀: Ntɛ mí. Kɛ̀ Isɑki dɔ̀: Ti tɔ muhɑ̃ɑ̃́ nnɛ̀ idɛí, yé fɛpìèfɛ̀ ti yóó kuɔ fɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Kɛ̀ Abɑrɑhɑmmu dɔ̀: M birɛ Kuyie nkuù yóó ti duɔ́ nfɛpìèfɛ̀. Mɛm̀mɛ kɛ̀ bɛ nnɛí, kɛ kérí bɛdɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Bɛ̀ tùɔ̀kɛ dìì mɔ̀nnì Kuyie nhò bɛnkɛ dɛ̀, kɛ̀ Abɑrɑhɑmmuu mɑɑ́ diwũɔ̃tɔ̀nnì, kɛ́dɔɔ̀ idɛí kɛ́dɑɑ́ nkɛ́boú o birɛ Isɑki kɛ́nɔ́ɔ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","kɛ́túótɛ́ disiè kɛ bo dɛ̀ fèútɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃nnìi yúní Abɑrɑhɑmmu kɛĩ́nkɛ̀ kɛ dɔ̀: Abɑrɑhɑmmu! Abɑrɑhɑmmu! Kòò dɔ̀: Ntɛ mí. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kɛ̀ dì dɔ̀: Kuyie ntu, ɑ bɑ́ɑ́ dɔɔ̀ dɛbirɛ mɛyɛi mmɑmɛ̀, kù bɑntɛ́mu di mmɔ̀nnì ɑ kù démɛ̀ kɛ í kù yetɛnɛ̀ ɑ birɛ dɛ̀ɛ̀ bo dɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kɛ̀ Abɑrɑhɑmmuu wéntɛ́ kɛ́yɑ̀ dipedɑɑ̀, kɛ̀ dì còḿmú kɛ̀ di yìè nsɑ̀kɛ difɑ̃pèù, kòo dì dɛ̀tɛ kɛ́kuɔ o birɛ Isɑki kó difɔ̃̀tìrì, ");
INSERT INTO tbzsim_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","kɛ́yú dɛ kó dibòrì kɛ dɔ̀ Kuyie nduɔ́. Dɛɛ̀ te kɛ̀ bɛ̀ yu dɛ kó ditɑ̃rì nɛ̀ yíenní kɛ tú: Ti Yiɛ̀ nKuyie nduɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃nnìi yúní Abɑrɑhɑmmu kɛĩ́nkɛ̀ kucɛ mɛdɛ́rímɛ̀ ");
INSERT INTO tbzsim_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","kɛ dɔ̀: Kuyie ntu kuù bɛ́i nkɛ tú ɑ í mɛ̀ nkù yetɛ́nɛ̀mɛ̀ ɑ birɛ dɛ̀ɛ̀ bo dɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","Kù bo dɑ dɔɔ̀ mɛsɑ̀ɑ̀ nkɑ̀ɑ yɑɑ̀bíi sṹṹ nsiwɑ̃̀ɑ̃ kɔ̃mɛ, kɛ́ndònnɛ̀ dɑ̀mɛ́ɛ̀rì nùù kó mubirímú, kɛ́tiekɛ i dootitɔbɛ̀ ɛkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","nɛ̀ iì borɛ̀ ndɛ kù yóó dɔɔ̀mɛ̀ ibotí imɔu mɛsɑ̀ɑ̀, nhɑ yie mmɛ̀ɛ̀ kpɛ́í nku kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Kɛ̀ Abɑrɑhɑmmuu wɛ̃tɛní o tɔ̃mbɛ̀ borɛ̀, kɛ̀ bɛ̀ɛ kò mBɛɛrisebɑɑ Abɑrɑhɑmmu ciɛ kɛ́mbo. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Dɛ kó difɔ̃nkúò, kɛ̀ Abɑrɑhɑmmuu keè o nɑntɛ̀ Nɑɔɔ pokù Midikɑɑ ò piɛ́mɛ̀ ibí, ");
INSERT INTO tbzsim_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","22","Uusi, weè do tú Mpo kɛ́nɑntɛ Buusi, nɛ̀ Kemmuyɛɛdi Arɑmu cicɛ nɛ̀ Kesɛdi, nɛ̀ Asoo nɛ̀ Pididɑɑsi nɛ̀ Idudɑfu nɛ̀ Betuyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Kɛ̀ Betuyɛɛdi pɛitɛ́ Debekɑɑ, Midikɑɑ bí nyi ò pɛitɛ́nɛ̀ ì Nɑɔɔ Abɑrɑhɑmmu nɑntɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kòo pocɛ̃nnì Deyumɑɑ múnkɛɛ ò piɛ́ ibí. Tebɑɑ nɛ̀ Kɑɑmmu nɛ̀ Tɑɑsi nɛ̀ Mɑɑkɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sɑrɑɑ do mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìdɛ́ nɛ̀ yɛ̀yiekɛ̀ (127) ndi kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Ò ku Kidiyɑti-Adibɑ kó dihɛì ndi, bɛ̀ tu dì Ebunɔɔ Kɑnnɑhɑ̃ɑ̃ kó kutempɛ̃ mmiɛkɛ, kɛ̀ Abɑrɑhɑmmuu dɔɔ̀ ikuɔ́ kɛ́kɔmmú o pokù kṹṹ, ");
INSERT INTO tbzsim_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","kɛ́deè kɛ́ítɛ́ kɛ́kɔtɛ kɛ́yɑ̀ Ɛti kó ibí Itiibɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","M bo diɛ nkɛ tú opɔ̀ɔ̀ nwe, ḿ pɑ̃nɛ̀ kɛtenkɛ̀ kɛ̀ n kũnnɛ́ ocíì kóò díɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Kɛ̀ Ɛti kó ibíi Itiibɛɛ ò tɛ̃̀ńnɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","Okótì ɑ tú okpɑ̀ɑ̀tì nwe ti cuokɛ̀, kɛ̀ Kuyie nkó mɛsɑ̀ɑ̀ ndɑ bonɛ̀. Kũnnɛ́ ɑ cíì ɑ dɔ́ kùù fɔ̃ti, òmɔù í yóó dɑ yetɛnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Kɛ̀ Abɑrɑhɑmmuu nínkú dihɛì yɛmbɛ̀ Ɛti kɔbɛ ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","kɛ dɔ̀: Kɛ̀ di yie nkɛ̀ m bo kũnnɛ́ ocíì diɛ, dí m bɑ́ntɛ̀ Efunɔɔ Soɑɑ birɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kòo n duɔ́ nho fɔ̃ti kùù bo Mɑkpedɑɑ o pɑku nùù, kɛ̀ n yietí kudonku di ììkɛ̀ kɛ̀ kù ntú n kɔku kɛ̀ nní nkũrì bɛcíríbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Kɛ̀ Efunɔɔ kɑ̀ri o kɔbɛ Itiibɛ borɛ̀, kɛ́tɛ̃́nnɛ́ Abɑrɑhɑmmu ditĩ̀nnì dìì tìí ndihɛì kó dibòrì borɛ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","Áɑ̀, n Yiɛ̀! N dɑ pɑ̃mu kupɑku nɛ̀ kufɔ̃ti n kɔbɛ ììkɛ̀. Kũnnɛ́ ocíì. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Kɛ̀ Abɑrɑhɑmmuu nínkú dihɛì yɛmbɛ̀ ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","kɛ́nɑ́kɛ́ Efunɔɔ kɛ dɔ̀: N dɑ bɑ́ɑ́mmu bɛnìtìbɛ̀ ììkɛ̀ kɛ tú ɑ́ n fítɛ́nɛ̀ ku kɛ̀ n kũnnɛ́ ocíì. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Kɛ̀ Efunɔɔ tɛ̃́nnɛ́ Abɑrɑhɑmmu ");
INSERT INTO tbzsim_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","kɛ dɔ̀: Yie n yóó dɑ nɑ́kɛ́ tì, mɛdítíbii nsikɔusìnɑ̀ɑ̀ (400) kpɛti tú bɑ fɔ̃́ nnɛ̀ mí nti cuokɛ̀? Kũnnɛ́ o cíì. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Kɛ̀ Abɑrɑhɑmmu bɑntɛ́ Efunɔɔ yɛ̀mmɛ̀, kɛ́kɑɑ nyidíítí Itiibɛ ììkɛ̀, mɛdítíbii nsikɔusìnɑ̀ɑ̀ (400), dɛ mɔ̀nnì kó idíítí, kóò duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Mɛm̀mɛ, Efunɔɔ pɑku kùù bo Mɑkpedɑɑ, kùù wetí Mɑmmudee nɛ̀ kufɔ̃ti kùù bo dɛ miɛkɛ nɛ̀ dɛtie ndɛmɔu dɛ̀ɛ̀ dɛ̀ bo, ");
INSERT INTO tbzsim_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","kɛ̀ dɛ̀ɛ nɑɑ́ nhAbɑrɑhɑmmu kpɛrɛ, Itiibɛ bɛ̀ɛ̀ tìí ndihɛì kó dibòrì bɛ ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Kɛ̀ Abɑrɑhɑmmuu kũnnɛ́ o pokù Sɑrɑɑ kufɔ̃ti kùù bo kupɑku Mɑkpedɑɑ, kɛ wetí Mɑmmudee bɛ̀ yu dɛ̀ Ebunɔɔ, Kɑnnɑhɑ̃ɑ̃ kó kɛtenkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Dɛ mɔ̀nnì, kɛ̀ Abɑrɑhɑmmuu tiekɛ kupɑku nɛ̀ kufɔ̃ti dɛ̀ɛ̀ do tú Itiibɛ kpɛrɛ, kɛ́nkũrì o círíbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abɑrɑhɑmmu do kòtɛ́ mɛdiɛ̀ mmɛ, kɛ̀ ti Yiɛ̀ nKuyie nhò dɔ̀ɔ̀ mɛsɑ̀ɑ̀ ndɛmɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Diyiè mɑrì kòo nɑ́kɛ́ o kóo tɔ̃ntì kótì wèè bɑ̀ɑ̀ o cĩ́ɛ̃̀tɛ̀, kɛ bɑɑ o kpɑ̀tì kɛ dɔ̀: Sɛu nhɑ nɔ̀ùtɛ̀ n kpèrì. Bɛ kó dimɔ̀nnì bɛ̀ do ɔ̃ nkɑ̀ɑ bo pɑrìkɛ̀ ɑ ɔ̃ɔ̃ mɛ ndɔɔ̀ kɛ̀ dɛ̀ɛ bɛnkɛ kɛ dò nhɑ yóó dɔɔ̀ ɑ bɛ́i ntì. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Bɛ́i nkɛ́yú ti Yiɛ̀ nKuyie Mpɑkɛdɑɑ yètìrì kɛ dɔ̀ ɑ í yóó wɑɑ́ m birɛ onitipòkù Kɑnnɑhɑ̃ɑ̃ kɔbɛ m bo bɛ̀ɛ̀ cuokɛ̀, bɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kɑ̀ɑ kɔ̀ri n ciɛ nkɛ, n nɑɑ̀mùnkù miɛkɛ kɛ yóó kɛ nwɑɑ́ nhonitipòkù, kɛ́puó m birɛ Isɑki. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kòo tɔ̃ntì dɔ̀: Kɛ̀ dɛ̀ yɛ̀mmɛ̀ onitipòkù bɑ́ɑ́ yie nkɛ́ n nɛinɛ̀ní diɛ di nhɛì, ɑ birɛ yó nni nnɛínɛ̀mu dɛ bíɛ́kɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Kɛ̀ Abɑrɑhɑmmu dɔ̀: A bɑ́ɑ́ dítínnɛ́ ɑ mɑ́ɑ̀ kɛ́nɛinɛ̀ m birɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Ti Yiɛ̀ nKuyie Mpɑkɛdɑɑ wèè n dènnɛní n cicɛ cĩ́ɛ̃̀tɛ̀ nɛ̀ nh ɛì kɛ n nɑ̀kɛ́ kɛ tú: M bo dɑ duɔ́ di nhɛì kɑ̀ɑ yɑɑ̀bí di tiekɛ. Kù bo duɔnní ku tɔ̃nnì kɛ̀ dì ndɑ ní kɑ̀ɑ wɑɑnní onitipòkù kɛ́puó m birɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kòo nitipòkù yetɛ ò bo ndɑ nɛínnímɛ̀, ɑ bɛ́i ndìì nùù í yóó dɑ pĩ́. A cɛ̃́nkɛ bɑ́ nnɛínɛ̀ m birɛ dɛ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kòo tɔ̃ntìi sɛu nho nɔ̀ùtɛ̀ Abɑrɑhɑmmu kpèrì kɛ́bɛ́i nkɛ dɔ̀: M bo dɔɔ̀ ɑ bɛ́i ntì. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Kòo tɔ̃ntìi túótɛ́ Abɑrɑhɑmmu yòyóbɛ̀ tɛpíítɛ̀ nɛ̀ yɛpɑ̃rɛ̀ sɑ̀ɑ̀yɛ̀, kɛ́kɔtɛ Mɛsopotɑmii, Nɑɔɔ ciɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ò tùɔ̀kɛ dìì mɔ̀nnì tɛbintɛ dihɛì mɑ̀nku kɛ́duɔ́ nkɛ̀ yòyóbɛ̀ɛ nínkú. Dɛ̀ do tú kuyuoku nku dikónnɛ́tɑrì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Kòo bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ dɔ̀: N Yiɛ̀ nKuyie nhAbɑrɑhɑmmu tũ nkù n dɑ bɑ́ɑ́mmu yóu kɛ̀ n yɑ̀ n wɑnti dɛ̀ yíe. Dɔɔ̀ n yiɛ̀ nhAbɑrɑhɑmmu mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","M bo tɛbintɛ tɑkɛ́ nkɛ kɛ̀ dihɛì kó bɛsɑpɑ̀mbɛ̀ yó ntɑɑ̀ní mudúò. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","M bo mɔɔ wèè sɑpɑ̀ɑ̀ nkɛ dɔ̀: Bíi nhɑ dúù kɛ̀ ǹ yɑ̃̀, kòo n tɛ̃́nnɛ́ kɛ yĩ́: Yɑ̃̀ kɛ̀ n duɔ́ nhɑ yòyóbɛ̀ kɛ̀ bɛ̀ɛ yɑ̃̀. M bo bɑntɛ́ kɛ dɔ̀ weǹwe ɑ tɑ̃ɑ̃tɛ́mɛ̀ ɑ kóo tɔ̃ntì Isɑki kpɛ́í, kɛ dɔ̀ɔ̀ mɛsɑ̀ɑ̀ n yiɛ̀ nhAbɑrɑhɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Ò kpɑɑ́ mɛ nnɑ́ɑ́ nkɛ̀ Abɑrɑhɑmmu nɑntɛ̀ Nɑɔɔ pokù Midikɑɑ birɛ Betuyɛɛdi kóo sɑpɑ̀ɑ̀ Debekɑɑ yɛ̀nní kɛ tɔ didúù. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Dɛ kóo sɑpɑ̀ɑ̀ ndo wenni mɛdiɛ̀ mmɛ, kɛ mu nyí yɛ̃́ onitidɔ̀ù, kòo dó mɛniɛ nkɛ́píɛ nho dúù kɛ́tɔ nkɛ́nkũnti. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Kɛ̀ Abɑrɑhɑmmu kóo tɔ̃ntìi cokɛ́ kóò co kóò nɑ̀kɛ́ kɛ dɔ̀: Yóu kɛ̀ n yɑ̃̀ ɑ dúù kó mɛniɛ nsɑ́m̀pɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kòo sɑpɑ̀ɑ̀ dɔ̀: Yɑ̃̀. Kɛ bíi mmɛcɑ̃ɑ̃ nho dúù kóò duɔ́ nkòo yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ò dèè dìì mɔ̀nni kòò dɔ̀: M bo duɔ́ nhɑ yòyóbɛ̀, kɛ̀ bɛ̀ɛ yɑ̃̀ kɛ́nsɑ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Kòo utɛ́ mɛniɛ mmɛcɑ̃ɑ̃ nyiwũɔ̃ yɔ̃̀ ndɛ̀, kɛ́cokɛ́ kɛ́dónní kɛ́duɔ́ nyòyóbɛ̀ bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Kɛ̀ dɛ̀ɛ di Abɑrɑhɑmmu kóo tɔ̃ntì kòo nhò wùó nkɛ dò nyúóó, kɛ bo yɑ̀ kɛ̀ ti Yiɛ̀ nKuyie nkuù dɔ̀ɔ̀ri ò kù bekɛ tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kɛ̀ yòyóbɛ̀ɛ yɑ̃̀ kɛ́deè kòo túótɛ́ mumɑ́mɑ́ɑ́ mmɛsɔɔ nkɔ̃mu bɛ̀ tũɔ̃̀mù dihɔ̃nnì nɛ̀ sinɛí sìdɛ́sì mɛsɔɔ nkpɛsi, ");
INSERT INTO tbzsim_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","kóò bekɛ kɛ dɔ̀: We nkóo sɑpɑ̀ɑ̀ ndɑ tú? N dɑ bɑ́ɑ́mmu mɛfíè mbo mbo ɑ cicɛ cĩ́ɛ̃̀tɛ̀ nɛ̀ n kɔbɛ kɛ̀ tí yiénɑ́ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Kòò dɔ̀: N tú Midikɑɑ nɛ̀ Nɑɔɔ bɛ kóo dɑpɑ̀ɑ̀ Betuyɛɛdi kóo sɑpɑ̀ɑ̀ nwe. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Kòo yíɛ́ kɛ́bɛ́i nkɛ dɔ̀: Timúkpetì bomu nɛ̀ tisũ̀ũ̀tì pɛ́u, kɛ̀ di bo duɔ́ dɛ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kòo tɔ̃ntìi nínkú kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie, ");
INSERT INTO tbzsim_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","kɛ́bɛ́i nkɛ dɔ̀: Ti Yiɛ̀ nKuyie, n yiɛ̀ nhAbɑrɑhɑmmu tũ nkù yètìrì ndɛu, kuù ò kuɔ́ mmɛsémmɛ̀ koò dɔ̀ɔ̀ mɛsɑ̀ɑ̀, kɛ n niitɛ́ kɛ̀ ǹ tùɔ̀kɛní o kɔbɛ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Kòo sɑpɑ̀ɑ̀ ncokóo tɛcĩ́ɛ̃̀tɛ̀ kɛ́nɑ́kɛ́ o yɔ̃ dɛ kó tinɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Debekɑɑ do mɔkɛ o tɑ̃ũ̀ mɔù nwe kòo yètìrì tu Dɑmɑɑ kòo yɑ̀ mumɑ́mɑ́ɑ́ nnɛ̀ sinɛí kɛ́keè ò nɑ̀ɑ́ ntì kɛ́ítɛ́ mɛcɑ̃ɑ̃ nkɛ́kɔtɛ tɛbintɛ borɛ̀ kɛ́ yɑ̀ dɛ kóo nìtì nɛ̀ o yòyóbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Kɛ dɔ̀: Fɔ̃́ nti Yiɛ̀ nKuyie nkó mɛsɑ̀ɑ̀ mbonɛ̀ wè, kɔtɛní kɛ̀ tí kò. Dɛ̀ yĩ́mɛ kɑ̀ɑ bo dikpɑ́ɑ̀? N tũ̀ntɛmu tɛcĩ́ɛ̃̀tɛ̀ kɛ wɑɑ́ nyòyóbɛ̀ yó mborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kòo tuɔkoo tɛcĩ́ɛ̃̀tɛ̀ kɛ̀ Dɑmɑɑ duɔ́ nkɛ̀ bɛ̀ɛ boutɛ́ yòyóbɛ̀ tinɛntì, kòo bɛ̀ duɔ́ ntimúkpetì nɛ̀ tisũ̀ũ̀tì, kɛ́duɔ́ mmɛniɛ nhAbɑrɑhɑmmu kóo tɔ̃ntì nɛ̀ o nɛínɛ̀ bɛ̀, kɛ̀ bɛ̀ɛ ɔ́ú bɛ nɑɑ̀cɛ̀i. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Kɛ̀ bɛ̀ɛ ò duɔ́ mmudiì kòo yetɛ kɛ dɔ̀: Kɛ̀ n yí nɑ̀kɛ́ n tɔ tì m bɑ́ɑ́ di. Kɛ̀ Dɑmɑɑ dɔ̀: Bɛ́i! ");
INSERT INTO tbzsim_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kòò dɔ̀: N tú Abɑrɑhɑmmu kóo tɔ̃ntì nwe. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Ti Yiɛ̀ nKuyie nkuù dɔ̀ɔ̀ n yiɛ̀ nhAbɑrɑhɑmmu mɛsɑ̀ɑ̀, kòò kpenkɛ kɛ mɔkɛ tikpɑ̀tì mɛdiɛ̀. Kɛ mɔkɛ iwũɔ̃ nɛ̀ idíítí nɛ̀ mɛsɔɔ nnɛ̀ bɛtɔ̃mbɛ̀ bɛnitidɑɑbɛ̀ nɛ̀ bɛnitipòbɛ̀ nɛ̀ yòyóbɛ̀ nɛ̀ sɑ̃mmɑrímúbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Kɛ̀ Sɑrɑɑ o pokù ò pɛitɛ́ dɛnitidɑbirɛ o kótì cuokɛ̀, kòo dɛ̀ duɔ́ nhò mɔ̀kɛ dɛ̀ɛ̀ kó dimɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Kɛ̀ n yiɛ̀ nhAbɑrɑhɑmmu duɔ́ nkɛ̀ m bɛ́i nkɛ yu ti Yiɛ̀ nKuyie nyètìrì kɛ yĩ n yí yóó túótɛ́ onitipòkù Kɑnnɑhɑ̃ɑ̃ kɔbɛ ò bo bɛ̀ɛ̀ cuokɛ̀ kɛ́puó nho birɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kɛ̀ n yóó kɔtɛ o nɑɑ̀mùnkù kɔbɛ borɛ̀ ndɛ, o cicɛ cĩ́ɛ̃̀tɛ̀ kɛ́wɑɑ́ nhonitipòkù kɛ́puó nho birɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Kɛ̀ nh ò nɑ̀kɛ́ kɛ yĩ kɛ̀ dɛ̀ yɛ̀mmɛ̀ onitipòkù bɑ́ɑ́ yie nkɛ́ n nɛinɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Kòò n tɛ̃̀ńnɛ́ kɛ tú o Yiɛ̀ nKuyie nhò tũ nkù yó n niitɛ́mu kɛ̀ m pɛ́tɛ́ onitipòkù o kɔbɛ cuokɛ̀, o cicɛ cĩ́ɛ̃̀tɛ̀ miɛkɛ, kɛ́kònnɛ̀nko kɛ́puó nhò kóò dɑpɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kɛ̀ ǹ kɔ̀tɛ o cĩ́ɛ̃̀tɛ̀ kɔbɛ borɛ̀, kɛ̀ bɛ̀ í yie, ò bɛ́i ndìì nùù bɑ́ m pĩ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","N tùɔ̀kɛní tɛbintɛ borɛ̀ yíe nkɛ bɑ́ntɛ̀mu Kuyie nkɛ yĩ: Ti Yiɛ̀ nKuyie nhAbɑrɑhɑmmu tũ nkù yóu kɛ̀ n yɑ̀ n wɑnti dɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","n yó mbo tɛbintɛ tɑkɛ́ nkɛ, osɑpɑ̀ɑ̀ nwèè bo tɑnní mudúò kɛ̀ nh ò mɔɔ mɛniɛ nkɛ yĩ́: Yóu kɛ̀ ǹ yɑ̃̀ ɑ dúù kó mɛniɛ nsɑ́m̀pɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Kòò n tɛ̃́nnɛ́ kɛ dɔ̀: Yɑ̃̀ kɛ̀ n dó kɑ̀ɑ yòyóbɛ̀ɛ yɑ̃̀, n yóó bɑntɛ́mu ɑ we ntɑ̃ɑ̃tɛ́mɛ̀ kòò yóó yenkɛ n yiɛ̀ mbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","N kpɑɑ́ mɛ nnɑ́ɑ́ nkɛ̀ Debekɑɑ tùɔ̀kɛní kɛ tɔ didúù kɛ dó tɛbintɛ, kɛ̀ ǹ yĩ́: N dɑ bɑ́ɑ́mmu m pɑ̃ mɛniɛ nkɛ̀ n yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Kòò toutɛ́ o dúù mɛcɑ̃ɑ̃ nkɛ bɛ́i nkɛ yĩ: Yɑ̃̀, kɑ̀ɑ yɑ̃̀ kɛ dèè, n dó kɛ́duɔ́ nhɑ yòyóbɛ̀. Kɛ̀ n yɑ̃̀ kɛ́deè kòo duɔ́ n yòyóbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kɛ̀ nh ò bekɛ kɛ yĩ: We nkóo sɑpɑ̀ɑ̀ ndɑ tú? Kòò yɛ̃ nNɑɔɔ nɛ̀ Midikɑɑ bɛ birɛ Betuyɛɛdi kóo sɑpɑ̀ɑ̀ nhò tu, kɛ̀ n tɔ̃nnɛ́ o ɔ̃nnì mumɑ́mɑ́ɑ́ koò ũ̀ńnɛ́ sinɛí. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Dɛ mɔ̀nnì ndi n nìńkúmɛ̀ kɛ dɔunnɛ̀ mutɔ̃mmú ti Yiɛ̀ nKuyie nhAbɑrɑhɑmmu tũ nkù, kù n niitɛ́mɛ̀ weti weti kɛ̀ m bo túótɛ́ o tebitɛ kóo sɑpɑ̀ɑ̀ nkɛ́puó nho birɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Kɛ̀ di yie nkɛ bo dɔɔ̀ n yiɛ̀ mmɛsɑ̀ɑ̀ nweti weti dí n nɑ́kɛ́, kɛ̀ di mɛ nyetɛ dí n nɑ́kɛ́ kɛ̀ n sɔɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Dɑmɑɑ nɛ̀ Betuyɛɛdi kɛ̀ bɛ̀ dɔ̀: Ti Yiɛ̀ nKuyie nkuù yɛ̃ ndɛ̀ mmɛ̀ ndò! Ti bɑ́ɑ́ nɑ kɛ́bɛ́i ntìmɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ntɛ Debekɑɑ, túótɛ́ we kɛ́kònnɛ̀ kɛ́puó nhɑ yiɛ̀ nkóo dɑpɑ̀ɑ̀, kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ntì ndɑ nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Abɑrɑhɑmmu kóo tɔ̃ntì kèè dìì mɔ̀nnì dɛ kó tinɑ́ɑǹtì, kɛ́nínkú kɛ́sɑ̃ntɛ ti Yiɛ̀ nKuyie nnɛ̀ mutɔ̃mmú, ");
INSERT INTO tbzsim_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","kɛ́dɛitɛ timɑ́tì pɛ́ítì nɛ̀ mɛsɔɔ nkó tinɛntì nɛ̀ tiyɑ̀ɑ̀tì kɛ́duɔ́ Debekɑɑ, kɛ́pɑ̃ yɛpɑ̃rɛ̀ sɑ̀ɑ̀yɛ̀ o tɑ̃ũ̀ nɛ̀ o yɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Kɛ̀ bɛ̀ɛ di kɛ́yɑ̃̀, wenwe nɛ̀ bɛ̀ɛ ò cíe, kɛ́deè kɛ́yié. Kɛ̀ dɛ̀ɛ wentɛ́ dikṹnweńnì kòò dɔ̀: Yóunɛ̀ kɛ̀ n kò n yiɛ̀ mborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kòo sɑpɑ̀ɑ̀ ntɑ̃ũ̀ nɛ̀ o yɔ̃ kɛ̀ bɛ̀ dɔ̀: Yóu kòo nti kpɑɑ́nɛ̀ kɛ dɔ̀ yɛwe tɛpíítɛ̀ kɛ̀ di nɛ́ kò. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Kòo tɔ̃ntì dɔ̀: Ti Yiɛ̀ nKuyie nni nteennɛ̀mu kɛ̀ ǹ yɑ̀ n wɑnti dɛ̀, bɑ́ nni nhɔɔtínɛ̀, yóunɛ̀ kɛ̀ n kò n yiɛ̀ mborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Kɛ̀ bɛ̀ dɔ̀: Ti yúnɛ̀ osɑpɑ̀ɑ̀ nkóò bekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kɛ̀ bɛ̀ɛ yú Debekɑɑ kóò bekɛ kɛ dɔ̀: A dɔ́ kɛ́nɛinɛ̀ onìtì yie nkɛ̀ dí kònɑ̀ɑ̀? Kòò dɔ̀: Ɛ̃ɛ̃, m bo ò nɛinɛ̀! ");
INSERT INTO tbzsim_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kɛ̀ bɛ̀ɛ yóu Debekɑɑ nɛ̀ kudɑɑkù kùù ò yɔ, kɛ̀ bɛ̀ bo nɛinɛ̀ Abɑrɑhɑmmu kóo tɔ̃ntì nɛ̀ bɛ̀ɛ̀ ò cíenní kɛ̀ bɛ̀ɛ kò. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Kɛ̀ bɛ̀ɛ mɔɔ Kuyie nkó mɛsɑ̀ɑ̀ nDebekɑɑ kpɛ́í nkɛ dɔ̀: A bo piɛ́ kɛ̀ dɛ̀ nsũ mɛsɑ̀ɑ̀, kɑ̀ɑ yɑɑ̀bíi tiekɛ ɑ níìmbɛ̀ ɛkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kɛ̀ Debekɑɑ ítɛ́ nɛ̀ o tɔ̃mbɛ̀ kɛ́dekɛ yòyóbɛ̀, kɛ́tũnnɛ dɛ kóo nìtì kɛ̀ bɛ̀ɛ kò. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Dɛ mɔ̀nnì kɛ̀ Isɑki ìtɛ́ Dɑɑyii-Doyii kɛ konní kɛ bo Nɛkɛbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Kuyuoku mɑkù kɛ̀ Isɑkii yɛ̀ kɛ́ncentì dikpɑ́ɑ̀, kɛ́wéntɛ́ kɛ́yɑ̀ yòyóbɛ̀ kɛ̀ bɛ̀ kèríní. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Kɛ̀ Debekɑɑ wéntɛ́ kɛ́yɑ̀ Isɑki kɛ́cútɛ́ní yòyó ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","kɛ́bekɛ́ Abɑrɑhɑmmu kóo tɔ̃ntì kɛ dɔ̀: Wenninwe wèè kèríní ti bíɛ́kɛ̀? Kòò dɔ̀: N yiɛ̀ nwe. Kɛ̀ Debekɑɑ kɑ̃ɑ̃́ nkuyɑ̀ɑ̀kù o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kòo tɔ̃ntìi nɑ́kɛ́ Isɑki ò dɔ̀ɔ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Dɛ kó difɔ̃nkúò kɛ̀ Isɑkii tɑnnɛ́ Debekɑɑ o yɔ̃ Sɑrɑɑ kó kudieku kɛ́puokɛ, kɛ́ nhò dɔ́ kòo yɛ̀mmɛ̀ɛ cɑ́tɛ́ kɛ yɛ̃́ o yɔ̃ kumɛ̀ kòo yɛ̀mmɛ̀ cɑ̀ɑ̀rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Kɛ̀ Abɑrɑhɑmmuu puokɛ onitipòkù tɔù kɛ̀ bɛ̀ ò tu Ketudɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kòo o pɛitɛ́ Simmudɑnni Yokisɑ̃ɑ̃ nɛ̀ Mɛdɑnni nɛ̀ Mɑndiyɑ̃ɑ̃ nɛ̀ Isibɑki nɛ̀ Suɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Kɛ̀ Yokisɑ̃ɑ̃ pɛitɛ́ Sebɑɑ nɛ̀ Dedɑnni. Kɛ̀ Dedɑnnii piɛ́ Asudiibɛ, Detusiibɛ nɛ̀ Deumiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Kɛ̀ Mɑndiyɑ̃ɑ̃ pɛitɛ́ Efɑɑ nɛ̀ Efɛɛ nɛ̀ Enɔki nɛ̀ Abidɑɑ nɛ̀ Edidɑɑ. Bɛmɔu mɛmmɛ bɛ̀ tu Ketudɑɑ yɑɑ̀bí nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Kɛ̀ Abɑrɑhɑmmuu duɔ́ nyIsɑki o kpɛrɛ dɛmɔu, ");
INSERT INTO tbzsim_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","kɛ́nkpɑɑ́ fòù kɛ́pɑ̃mmú o pocɛ̃mbí yɛpɑ̃rɛ̀, kɛ́duɔ́ nkɛ̀ ìi kɔtɛ diyiè yìɛní kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abɑrɑhɑmmu do yóó kú kɛ mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìyiekɛ̀ nɛ̀ yɛ̀nùmmù (175) ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ò do kòtɛ́ mɛdiɛ̀ mmɛ kɛ́mbo diwɛ̀ì miɛkɛ kɛ́kúnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Kòo bí Isɑki nɛ̀ Isimɑyɛɛri kɛ̀ bɛ̀ɛ o kũnnɛ́ Mɑkpedɑɑ kó kufɔ̃ti, Efunɔɔ, Soɑɑ birɛ, Itiibɛ ɛì kou pɑku miɛkɛ, kùù wetí Mɑmmudee, ");
INSERT INTO tbzsim_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abɑrɑhɑmmu do dontɛ́ kùnku nɛ̀ Itiibɛ. Dɛndɛ bɛ̀ múnkɛ do kũnnɛ́mɛ̀ Abɑrɑhɑmmu nɛ̀ o pokù Sɑrɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abɑrɑhɑmmu ku dìì mɔ̀nnì kɛ̀ Kuyie nkó mɛsɑ̀ɑ̀ nsɔɔtɛ́ o birɛ Isɑki ĩ́nkɛ̀ kòò mbo Dɑɑyii-Doyii kó tɛbintɛ tɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ntɛ Abɑrɑhɑmmu pokù Sɑrɑɑ kó kudɑɑkù, Esibiti ɛì kou Akɑɑ kó dɛbirɛ Isimɑyɛɛri kó kufuku, bɛ̀ bɛ̀ pɛí kɛ̀ bɛ̀ tũmmɛ̀ bɛtɔbɛ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Nɛbɑyɔti nɛ̀ Kedɑɑ nɛ̀ Adiberi nɛ̀ Mibisɑmmu ");
INSERT INTO tbzsim_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","nɛ̀ Misemɑɑ nɛ̀ Dumɑɑ nɛ̀ Mɑsɑ ");
INSERT INTO tbzsim_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","nɛ̀ Adɑdi nɛ̀ Temɑɑ nɛ̀ Yetuu, nɛ̀ Nɑfisi nɛ̀ Kedimɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Isimɑyɛɛri kó ibí nyi tɛpíítɛ̀ nɛ̀ ìdɛ́ì. Bɑ́ wè kòo ḿbɑkɛ́ o botí kɛ́duɔ́ nho yètìrì o kɑrì, o ɛitɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimɑyɛɛri do mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀yiekɛ̀ (137) ndi, kɛ́kú kɛ̀ bɛ̀ɛ ò kũnnɛ́ o yɛmbɛ̀ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Kòo bí nkɑri Afidɑɑ kɛ́tuɔkɛnɛ̀ Suudi kɛ́ntɔ́kɛ́nɛ̀ Esibiti, kɛ wetí Asidii, kɛ cɑ̃́ɑ̃́ mbɛmɑ́ɑ̀ kɛ kɑri. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ntɛ Abɑrɑhɑmmu birɛ Isɑki kó tinɑ́ɑǹtì, Abɑrɑhɑmmu weè do pɛitɛ́ Isɑki. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isɑki do mɔkɛ yɛbie nsipísìnɑ̀ɑ̀ ndi kɛ́puokɛ Debekɑɑ, Betuyɛɛdi Arɑmu botí kou kóo sɑpɑ̀ɑ̀, Dɑmɑɑ tɑ̃ũ̀. Bɛ̀ do ɑ̃ Mɛsopotɑmii nwe. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isɑki pokù Debekɑɑ do tú tɛhɑ̃ũntɛ ntɛ, kòo bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ̀ kùu yie nkòo pùó nyitɑ́ɑ́tɛ́bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Kɛ̀ ibí ḿbokù ìtɔbɛ̀ i yɔ̃ pɔutì miɛkɛ, kòò dɔ̀: Kɛ̀ dɛ̀ dò mmiɛ mmɛ, bɑ nte kɛ̀ m pùó? Kòo kɔtɛ kɛ́bekɛ ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kɛ̀ kù dɔ̀: A púó nyibotí ìdɛ́ì nyi, kɛ̀ ì bo yɛ̀nní kɛ́ncɑ̃́ɑ̃́, kɛ̀ kùmɑkù nkpeńnìnɛ̀ kutɛkù. Osɑ́m̀pɔ́ù bo mbɑkɛ́ okótì. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Kòo pɛitɛ́ yièe tuɔkɛní, kòo pɛitɛ́ itɑ́ɑ́tɛ́bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kòo ketiwèe yɛ̀nní kɛ wũɔ̃ nɛ̀ o yùtòo, kɛ dɑ́ɑ́tí ticìtì o kɔ̃̀ntì timɔu, kɛ̀ bɛ̀ɛ ò yu kɛ dɔ̀ Esɑyuu. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kòo nɑntɛ̀ nyɛtìní kɛ pĩ́ nho nɑcɛ̀nkénnì, kɛ̀ bɛ̀ɛ ò yu kɛ dɔ̀ Sɑkɔbu. Bɛ̀ yóó bɛ̀ pɛitɛ́ kɛ sɔ̃́ nyIsɑki mɔ̀kɛ yɛbie nsipísìkuɔ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Kɛ̀ bɛ̀ɛ kótɛ́ kɛ̀ Esɑyuu nɑɑ́ nhopɑɑwɑɑ̀ ndiɛwè wèè nɔ nkupɑɑwɑɑ́, nkɛ níí ntṹṹ ndikpɑ́ɑ̀, kɛ̀ Sɑkɔbu ntú onitiyɔɔ̀nwè kɛ kɑri tɛcĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Kɛ̀ Isɑki ndɔ́ Esɑyuu o tɑ̃ũ mɛ̀ɛ̀ kpɛ́í nsiweí kòò cɑ̀ɑ́, kɛ̀ Debekɑɑ ndɔ́ Sɑkɔbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Diyiè mɑrì kɛ̀ Esɑyuu ḿboní kupɑɑwɑɑ́ nkɛ ɔ̀u mɛdiɛ̀ nkɛ́nsɔ̃́ nSɑkɔbu bèrí itũ. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Kɛ̀ Esɑyuu dɔ̀: N dɑ bɑ́ɑ́mmu nh ɔ̀u mɛdiɛ̀ mmɛ, yóu kɛ̀ ǹ cɑ́ɑ́kɛ́ itũ iwũɔ̃ì ii. Dɛɛ̀ te kɛ̀ bɛ̀ɛ ò yu kɛ dɔ̀ Edɔmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Kɛ̀ Sɑkɔbu dɔ̀: N fítɛ́nɛ̀ Mpo ɔ̃ nte dɛ̀ yíe. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Kɛ̀ Esɑyuu dɔ̀: Dikònnì yó n kuɔ kɛ̀ Mpo ɔ̃ nte dɛ̀ ń dɔɔ̀ bɑ? ");
INSERT INTO tbzsim_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kɛ̀ Sɑkɔbu dɔ̀: Bɛ́i nkɛ́yú Kuyie nyètìrì. Kɛ̀ Esɑyuu yú Kuyie nyètìrì kóò fìtɛ́nɛ̀ Mpo ɔ̃ nte dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Dɛ mɔ̀nnì ndi Sɑkɔbu duɔ́mmɛ̀ Esɑyuu pɛ̃́ɛ̃̀ nɛ̀ itũ kòo cɑ́ɑ́kɛ́, kɛ́yɑ̃̀ mɛniɛ. Mɛm̀mɛ ò sènkɛ̀rìmɛ̀ Mpo ɔ̃ nte dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Kɛ̀ dikònnì diɛrìi tɑnní kɛ́ndònnɛ̀ dìì do tɑnní Abɑrɑhɑmmu kó dimɔ̀nnì, kɛ̀ Isɑkii kɔtɛ Fidisitɛ̃ɛ̃bɛ kóo kpɑ̀ɑ̀tì Abimɛdɛki borɛ̀ Kedɑɑri ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Kɛ̀ ti Yiɛ̀ nKuyie mbɛnkɛ kumɑ́ɑ̀ Isɑki, kóò nɑ̀kɛ́ kɛ dɔ̀: A bɑ́ɑ́ kɔtɛ Esibiti, ḿbo n yóó dɑ bɛnkɛ dìì ɛì, ");
INSERT INTO tbzsim_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ɑ́ ndi mbo, n yó ndɑ bonɛ̀mu kɛ dɑ dɔɔ̀ mɛsɑ̀ɑ̀, n yóó duɔ́ nfɔ̃́ nwe nɛ̀ ɑ yɑɑ̀bí dɛ kó yɛhɛkɛ̀, kɛ́dɔɔ̀ n do yɛ̃ n yóó dɔɔ̀ tì ɑ cicɛ Abɑrɑhɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","M bo duɔ́ nkɑ̀ɑ yɑɑ̀bíi sṹṹ nsiwɑ̃̀ɑ̃ kɔ̃mɛ, kɛ̀ n yì duɔ́ ndɛ kó yɛhɛkɛ̀ yɛmɔu. Nɛ̀ ɑ yɑɑ̀bí borɛ̀ ndɛ n yóó dɔɔ̀mɛ̀ ibotí imɔu mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kɛ yɛ̃́ Abɑrɑhɑmmu yíémmɛ̀ n kuɔ́ imɔu nɛ̀ n tɑnnɔ̀ yɛmɔu, nɛ̀ n tié nnɛ̀ nh ò nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kɛ̀ Isɑki ḿbo Kedɑɑri ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Kɛ̀ bɛnìtìbɛ̀ nhò bèkú o pokù kpɛ́í, kòò dɔ̀: N tɑ̃ũ̀ nwe. Kɛ yɛ̃́ ò do yĩɛ̃̀kùmɛ̀ dɛ kó dihɛì kɔbɛ bo ò kùɔmɛ̀ Debekɑɑ wenniku kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Kɛ̀ bɛ̀ ḿbo dɛborɛ̀ kɛ́mɔntɛ, kɛ̀ Abimɛdɛki nsíékɛ́ diyiè mɑrì fenɛ́tì, kɛ́yɑ̀ Isɑki kòò kpɛ̀itinɛ̀ o pokù Debekɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Kòo ò yu kóò nɑ̀kɛ́ kɛ dɔ̀: A pokù nwe! Dɛ̀ yĩ́mɛ kɑ̀ɑ yɛ̃ nhɑ tɑ̃ũ̀? Kòò dɔ̀: N yĩɛ̃̀kù bɛ̀ bo n kuɔmɛ̀ mmɛ o kpɛ́í kɛ yɛ̃ n tɑ̃ũ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kɛ̀ Abimɛdɛki dɔ̀: A ti dɔ̀ɔ̀ bɑ? Dɛ̀ kpɑɑ́ sɑ́m̀pɔ́rɛ̀ ndɛ òmɔù nɑ nduɔ́nɛ̀mɛ̀ ɑ pokù, kɑ̀ɑ ti tɑnnɛ́ mɛyɛi mmiɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kɛ̀ Abimɛdɛkii nɑ́kɛ́ bɛnìtìbɛ̀ bɛmɔu kɛ dɔ̀: Wèè kɑ̀ɑ́kɛ́ onìtì yie nyoo o pokù ti yóó ò kùɔmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Dɛ benni kɛ̀ Isɑkii buɔtí tidiitì, kɛ́kɔ̃ṹ kɛ̀ dɛ̀ mmɑ̀nnɛ̀ ò do buɔtí dɛ̀ kucɛ tɛkɔ̀ùtɛ̀ (100). Kɛ yɛ̃́ ti Yiɛ̀ Kuyie nhò dɔ̀ɔ̀mɛ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Kòo kpɑ̀tìi dɛukɛ kòo mɔɔtɛ o kpɛrɛ mɛsɑ̀ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","kɛ́mɔɔtɛ iwũɔ̃ nɛ̀ tidɑɑtì. Kɛ̀ Fidisitɛ̃ɛ̃bɛ miɛkɛ nhò pɛ́ì. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kɛ̀ bɛ̀ɛ ĩ́tínnɛ́ mutɑ̃́ɑ̃́ sibií o cicɛ Abɑrɑhɑmmu tɔ̃mbɛ̀ do keú sì. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kɛ̀ Abimɛdɛkii nɑ́kɛ́ Isɑki kɛ dɔ̀: Ítɛ́ ti ɛì, ɑ kpenkɛ kɛ tì pɛ̃ɛ̃tɛ́mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kɛ̀ Isɑkii ítɛ́ dɛborɛ̀ kɛ́kɔtɛ kɛ́kɑri Kedɑɑri kó kubiriku, ");
INSERT INTO tbzsim_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","kɛ́wɛ̃tɛ kɛ́ĩ́tɛ́ o cicɛ Abɑrɑhɑmmu do keú sìì bií, kɛ̀ Fidisitɛ̃ɛ̃bɛ sì ĩ̀tínnɛ́. Kòo wɛ̃tɛ kɛ́ sì duɔ́ nsi yètɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Kɛ̀ Isɑki tɔ̃mbɛ̀ɛ keú tɛbintɛ kubiriku kɛ́pɛ́tɛ́ mɛnɛ́sɑ̀ɑ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kɛ̀ bɛnɑɑcɛ̃mbɛ bɛ̀ɛ̀ bo Kedɑɑri kɛ̀ bɛ̀ɛ kpɑnnɛ̀ Isɑki kɔbɛ kɛ dɔ̀: Tíì te tɛbintɛ. Kɛ̀ Isɑkii yú dɛ kó tɛbintɛ kɛ dɔ̀ Esɛki (dɛ̀ɛ̀ tu dikpɑ̀nnì). ");
INSERT INTO tbzsim_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kòo tɔ̃mbɛ̀ɛ keú tɛbintɛ tɛtɛ̀ kɛ̀ bɛ̀ɛ yíɛ́ kɛ́kpɑ ntɛ kpɛ́í nkɛ̀ Isɑkii tɛ̀ yu kɛ dɔ̀ Sitinɑɑ (dɛ̀ɛ̀ tu mɛbootimɛ̀). ");
INSERT INTO tbzsim_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Kòo sɔɔ́ nkɛ́keú tɛbintɛ tɛtɛ̀ bɑ́ bɛ̀ í nkpɑ, kòo tɛ̀ yu kɛ dɔ̀ Deobɔti (dɛ̀ɛ̀ tu mɛom̀pùmɛ̀), kɛ́bɛ́i nkɛ dɔ̀: Ti Yiɛ̀ nKuyie nti om̀pùnnɛ kɛ̀ ti bo pɛ́tɛ́ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Kòo ítɛ́ dɛborɛ̀ kɛ́kɔtɛ Bɛɛrisebɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Kɛ̀ Kuyie nhò bɛnkɛ kumɑ́ɑ̀ kɛyènkɛ̀ kóò bɛ́innɛ̀ kɛ dɔ̀: Míì tu Kuyie, ɑ cicɛ Abɑrɑhɑmmu do tũ nkù, bɑ́ nyĩɛ̃̀kù n dɑ bonɛ̀mu nɛ̀ n kóo tɔ̃ntì Abɑrɑhɑmmu kpɛ́í m bo dɑ dɔɔ̀ mɛsɑ̀ɑ̀, kɑ̀ɑ botíi sṹṹ. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kòo mɑɑ́ diwũɔ̃tɔ̀nnì, kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie, kɛ́cónnɛ́ o touku, kòo tɔ̃mbɛ̀ɛ keú tɛbintɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Kɛ̀ Abimɛdɛkii ítɛ́ní Kedɑɑri ɛì kɛ bo yɑ̀ Isɑki kɛ nɛínɛ̀ o nɛ́po Ausɑti nɛ̀ Pikɔdi wèè bɑkɛ́ o ɑ̃ɑ̃pɔ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Kɛ̀ Isɑki dɔ̀: Di kɔ̀tɛní kɛ yɛ̃ mbɑ? Díndi bɛ̀ɛ̀ í n dɔ́ kɛ m bɛ̀ti di ciɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Kɛ̀ bɛ̀ dɔ̀: Ti yɑ̀ ɑ Yiɛ̀ nKuyie ndɑ bonɛ̀mɛ̀ mmɛ kɛ dɔ́ ti tɑu ntínti nɛ̀ fɔ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Bɛ́i nkɛ yú ɑ Yiɛ̀ nKuyie nyètìrì kɛ dɔ̀ ɑ í yóó ti dɔɔ̀ mɛyɛi mmɑmɛ̀. Ti mɔ́mmɔmbɛ ti í dɑ dɔ̀ɔ̀ mɛyɛi, ti dɑ yóumu, kɑ̀ɑ ìtɛ́ nɛ̀ diwɛ̀ì, kɛ̀ Kuyie ndɑ dɔ̀ɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kɛ̀ Isɑkii bɛ̀ ɑ̃nnɛ́ kupɔ̀ɔ̀kù kɛ̀ bɛ̀ɛ di kɛ́yɑ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","kɛ́ítɛ́ dikṹnweńnì sɛ̀ì kɛ cɑnnɛnɛ̀ bɛtɔbɛ̀ yɛnɔ̀ kɛ dɔ̀, bɛ̀ bɑ́ɑ́ dɔɔ̀ bɛtɔbɛ̀ mɛyɛi, kɛ̀ bɛ̀ɛ cɑu nyIsɑki kɛ́kònnɛ̀ diwɛ̀ì. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Diì yiè dimɑ́ɑ̀ miɛkɛ nkɛ Isɑki tɔ̃mbɛ̀ ò nɑ̀kɛ́mɛ̀ kɛ dɔ̀: Ti nìntɛ mɛniɛ nti keù tɛ̀ɛ̀ bintɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kɛ̀ Isɑkii yú dɛ kó tɛbintɛ kɛ dɔ̀ Sibɑɑ (dɛ̀ɛ̀ tu mɛnucɑnnimɛ̀). Kɛ̀ dɛ kó dihɛì kpɑɑ́ tɔ dɛ kó diyètìrì nɛ̀ yíenní, kɛ̀ bɛ̀ dì tu Bɛɛrisebɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esɑyuu do mɔkɛ yɛbie nsipísìnɑ̀ɑ̀ ndi kɛ́puokɛ Itiibɛ, Suditi Bedii kóo sɑpɑ̀ɑ̀ nnɛ̀ Bɑsimɑti Edonni kóo sɑpɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Kɛ̀ dɛ̀ɛ yonkɛ Isɑki nɛ̀ Debekɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Kɛ̀ Isɑkii kótɛ́ kɛ tɛ̃́nkɛ í nwúó, kɛ́yú o kóo Po Esɑyuu, kòò dɔ̀: Ntɛ mí. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kɛ̀ Isɑki dɔ̀: N kòtɛ́mu, n yí yɛ̃́ n kṹṹ nyiè. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Túótɛ́ ɑ tɑ̃mmù nɛ̀ ɑ pie nkɛ́tɑ dikpɑ́ɑ̀ kɛ́ n kuɔní tɛhontɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","kɛ́bénnɛ́ n dɔ́ mùù diì kɛ́kɔtɛnɛ̀ní kɛ̀ ǹ di, kɛ́ dɑ pɑ̃ mɛsɑ̀ɑ̀ nkɛ nɛ́ nɑ kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kɛ̀ Debekɑɑ keè Isɑki nɑ̀kɛ́ tì Esɑyuu kɛ tú wèe tɑ dikpɑ́ɑ̀ kóò kùɔní tɛhontɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","kɛ́nɑ́kɛ́ Sɑkɔbu kɛ dɔ̀: N kèè ɑ cicɛ nɑ̀kɛ́mɛ̀ ɑ kóo kótì Esɑyuu kɛ tú ");
INSERT INTO tbzsim_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","wèe tɑ dikpɑ́ɑ̀ kóò kùɔní tɛhontɛ̀ kɛ́bénnɛ́ mudiì ò dɔ́ mù, kòo di, kóò pɑ̃ ti Yiɛ̀ nKuyie nkó mɛsɑ̀ɑ̀ nkɛ́nɑ kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","M birɛ kéntɛ́ kɛ́keè n yóó dɑ nɑ́kɛ́ tì kɛ́ tì dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Kɔtɛ kɛ́pĩ́nní yɛbɔpɑ̀ɑ̀ nyɛ̀dɛ́ɛ̀ kɛ̀ m bénnɛ́ ɑ cicɛ dɔ́ mùù diì. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Kɑ̀ɑ ò duɔ́ nkòo di, kɛ́ dɑ pɑ̃ mɛsɑ̀ɑ̀ nkɛ́nɑ kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kɛ̀ Sɑkɔbuu nɑ́kɛ́ o yɔ̃ kɛ dɔ̀: N kóo kótì Esɑyuu mɔ̀kɛ ticìtì nti, mí m mɛ nyí tì mɔ̀kɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kɛ̀ dɛ̀ yɛ̀mmɛ n cicɛ n kɑ́ɑ́kɛ́ kɛ́yɑ̀ n yí mɔkɛmɛ̀ ticìtì kɛ̀ n nɑɑ́ siyɑ́ɑ̀bìsí yiɛ̀, kòò n dɔɔ̀ mɛyɛi nkɛ̀ m mɔ́ntɛ́ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Kòo yɔ̃ dɔ̀: Kòò dɑ dɔ̀ɔ̀ mɛyɛi mmɛ̀ɛ do n yĩ́nkɛ̀. Cɛ̃́nkɛɛ yie n dɑ nɑ̀kɛ́ tì kɛ́pĩ́nní yɛbɔpɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kɛ̀ Sɑkɔbuu kɔtɛ kɛ́pĩ́nní yɛbɔpɑ̀ɑ̀ nkɛ́duɔ́ nho yɔ̃, kòo bénnɛ́ o cicɛ dɔ́ mùù diì. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kɛ̀ bɛ yɔ̃ Debekɑɑ túótɛ́ o kóò Po Esɑyuu yɑɑ̀sɑ̀ɑ̀tì tìì bo tɛcĩ́ɛ̃̀tɛ̀ kɛ́dɑ́tínnɛ́ Sɑkɔbu o bíyɑ̃ɑ̃tɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","kɛ́túótɛ́ kubɔkɔ̃̀nkù kɛ́dɑ́tínnɛ́ o nɔu nɛ̀ o fɔ̃̀níí, ");
INSERT INTO tbzsim_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","kóò duɔ́ mmudiì ò bèńnɛ́ mù nɛ̀ pɛ̃́ɛ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Kɛ̀ Sɑkɔbuu kɔtɛ o cicɛ borɛ̀ kɛ dɔ̀: N cicɛ! Kòò dɔ̀: Ntɛ mí! Fɔ̃́ nwennìnwe? ");
INSERT INTO tbzsim_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Kɛ̀ Sɑkɔbu dɔ̀: N cicɛ mínwe ɑ kóo Po Esɑyuu. N dɔ̀ɔ̀ ɑ yɛ̃ n dɔɔ̀ dɛ̀ ndɛ. N dɑ bɑ́ɑ́mmu, ítɛ́ kɛ́kɑri kɛ́cɑ́ɑ́kɛ́ iorimɑɑ n kùɔní ì, kɛ́ m pɑ̃ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kɛ̀ Isɑki dɔ̀: A pɑ̃̀nkɛ pɛ̀tɛ́mu dɛndɛ bɑ̀mbɑ̀ ntɛhontɑ̀ɑ̀? Kòò dɔ̀: A Yiɛ̀ nKuyie nkuù tɛ̀ kɔ̀tɛnɛ̀ní n yììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kɛ̀ Isɑki dɔ̀: Tɔ́ɔ́nní kɛ̀ n dɑ kɑ́ɑ́kɛ́ kɛ́yɑ̀ kɛ̀ nsɑ̀ kɛ̀ fɔ̃́ nwe m birɛ Esɑyuu. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kɛ̀ Sɑkɔbuu tɔ́ɔ́nko, kòo cicɛ Isɑkii ò kɑ̀ɑ́kɛ́ kɛ dɔ̀: Mɛtɑmmɛ̀ dònnɛ̀ Sɑkɔbu kɔ̃mɛ kɛ̀ dɛbɑɑ̀ ndònnɛ̀ Esɑyuu kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Bɑ́ ò í nhò bɑntɛ́, kɛ yɛ̃́ o bɑɑ̀ ndo ɑ̃mɛ̀ ticìtì kɛ dònnɛ̀ o kóo kótì Esɑyuu kpɛrɛ, kòo ò dɔ̀ɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Kóò bekɛ kɛ dɔ̀: Fɔ̃́ nwe m birɛ Esɑyuɑ̀ɑ̀? Kòò dɔ̀: Ɛ̃ɛ̃ mínwe. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kɛ̀ Isɑki dɔ̀: Nh ɑ̃nnɛ́, kɛ̀ n cɑ́ɑ́kɛ́ iorimɑɑ nkɛ́ dɑ pɑ̃ mɛsɑ̀ɑ̀. Kɛ̀ Sɑkɔbuu ɑ̃nnɛ́ o cicɛ, kòo cɑ́ɑ́kɛ́, kòo ò duɔ́ mmɛnɑɑ̀ nkòo yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kɛ dɔ̀: Tɔ́ɔ́nní m birɛ kɛ́ nh ɔrí. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kòo tɔ́ɔ́nko kóò ɔrí kòo keè o yɑ̀ɑ̀tì nɔ́ú, kóò pɑ̃ mɛsɑ̀ɑ̀ nkɛ dɔ̀: M birɛ kó kunɔ́ú dònnɛ̀ dikpɑ́ɑ̀ ti Yiɛ̀ nKuyie mpɑ̃ dì mɛsɑ̀ɑ̀ nkó kunɔ́ú nku. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Kuyie ndɑ pɑ̃ kɛĩ́nkɛ̀ kó kubooku, kɑ̀ɑ pɑɑ nní mpɛí mɛsɑ̀ɑ̀, kɑ̀ɑ mmɔkɛ tidiitì nɛ̀ mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kɑ̀ɑ mbɑkɛ́ ibotí imɔu, kɛ̀ titentì timɔu kɔbɛ nninku ɑ ììkɛ̀, kɑ̀ɑ mbɑkɛ́ ɑ tebìí kɛ sì ninku ɑ ììkɛ̀. Kɛ̀ wèè dɑ dɔ̀ɔ̀ mɛyɛi nwèe pɛ́tɛ́ mɛyɛi, kɛ̀ wèè dɑ dɔ̀ɔ̀ mɛsɑ̀ɑ̀ nwèe pɛ́tɛ́ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Isɑki pɑ̃ dìì mɔ̀nnì Sɑkɔbu mɛsɑ̀ɑ̀ nkɛ dèè kòo nyiti, kòo kóo kótì Esɑyuu konní kupɑɑwɑɑ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","kɛ́bénnɛ́ mudiì kɛ́tɔo kɛ́duɔ́ nho cicɛ kɛ dɔ̀: N cicɛ ítɛ́ kɛ́cɑ́ɑ́kɛ́ iorimɑɑ n kùɔní ì kɛ́ m pɑ̃ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kɛ̀ Isɑkii bekɛ kɛ dɔ̀: Fɔ̃́ nwennìnwe? Kòò dɔ̀: Mínwe Esɑyuu ɑ kóo Po. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Kɛ̀ dɛ̀ɛ di Isɑki mɛdiɛ̀ nkòo kɔ̃̀ntìi ɑɑ́, kòò dɔ̀: Wenninwe wèè kùɔní tɛhontɛ̀ kɛ n duɔ́ nkɛ̀ n cɑ̀ɑ́kɛ́ kɛ dèè kɑ̀ɑ kpɑɑní, kɛ̀ nh ò pɑ̃ mɛsɑ̀ɑ̀ nkòo yóó mɛ̀ pɛ̀tɛ́? ");
INSERT INTO tbzsim_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Kɛ̀ Esɑyuu keè o cicɛ bɛ́i ntì kòo yɛ̀mmɛ̀ɛ cɑɑ̀rɛ̀, kòo kuɔ́nko mɛdiɛ̀ nkɛ dɔ̀: N cicɛ múnkɛ m pɑ̃ mɛsɑ̀ɑ̀! ");
INSERT INTO tbzsim_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kɛ̀ Isɑki dɔ̀: A nɑntɛ̀ tɛɛ̀ kɔ̀tɛní kɛ soutɛ́ kɛ cɔutɛ́ ɑ kó mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Kɛ̀ Esɑyuu dɔ̀: Bɛ̀ ò yu kɛ tú Sɑkɔbu osoùntì, dɛɛ̀ te kòò n soutɛ́ kucɛ mɛ̀dɛ́mɛ̀ kɛ cɔutɛ́ Mpo ɔ̃ nte dɛ̀ kɛ wɛ̃̀tɛ kɛ cɔutɛ́ n kó mɛsɑ̀ɑ̀. Kɛ dɔ̀: Mɛsɑ̀ɑ̀ mmɑmɛ̀ í kpɑɑ́ n kpɛ́ínɑ́ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Kɛ̀ Isɑki dɔ̀: M bɛ́immu kɛ tú ò bo n dɑ bɑkɛ́, kɑ̀ɑ tebìí simɔu ntú o kó bɛtɔ̃mbɛ̀. M bɛ́immu kɛ tú ò bo mmɔkɛ tidiitì nɛ̀ mɛnɑɑ̀, n tɛ̃́nkɛ bo nɑ kɛ́ dɑ dɔɔ̀ bɑ m birɛ! ");
INSERT INTO tbzsim_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Kɛ̀ Esɑyuu dɔ̀: N cicɛ ɑ mɔkɛ mɛɛ̀ sɑ̀ɑ̀ mmɑ́ɑ̀? Múnkɛ n dɔɔ̀ mɛsɑ̀ɑ̀. Dɛ mɔ̀nnì kɛ́kuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kɛ̀ Isɑki dɔ̀: A bo mbo kɛ̀ɛ̀ tenkɛ̀ bɑ́ nnɑɑti, kɛĩ́nkɛ̀ kó kubooku bɑ́ɑ́ cútɛ́ní ɑ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","A níí yóó dokɛ́mu kɛ́pɛ́tɛ́ kɛ́di, kɛ́ntú ɑ nɑntɛ̀ kóo tɔ̃ntì, kɛ́nhɑ̃́ɑ̃ntɛ tipíìtì timɔu, diyiè mɑrì kɛ́ nɛ́ fietɛ ɑmɑ́ɑ̀ ɑ nɑntɛ̀ nɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Kɛ̀ Esɑyuu miɛkɛɛ pɛikɛ mɛdiɛ̀ nSɑkɔbu o cicɛ o pɑ̃ mɛ̀ɛ̀ kpɛ́í mmɛsɑ̀ɑ̀, kòò nnɑ́ɑ́ nkɛ tú: Dɛ̀ í kpɑɑ́ dɛ́tirì n cicɛ bo kúmɛ̀, kɛ̀ ǹ kuɔ n nɑntɛ̀ Sɑkɔbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kɛ̀ bɛ̀ɛ nɑ́kɛ́ Debekɑɑ Esɑyuu nɑ̀ɑ́ ntì, kòo nɑ́kɛ́ Sɑkɔbu kɛ dɔ̀: A kóo kótì Esɑyuu miɛkɛ dɑ pɛikɛmu kòò dɔ́ kɛ́ dɑ kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","M birɛ kéntɛ́ n yóó dɑ nɑ́kɛ́ tì, kɛ́cokɛ́ kɛ́kɔtɛ n tɑ̃ũ̀ Dɑmɑɑ ciɛ Anɑɑ ɛì, ");
INSERT INTO tbzsim_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","kɛ́ nkɛ mbo kòo miɛkɛ yɑ̀ɑ donɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Kòo yɛ̃̀ nhɑ ò dɔ̀ɔ̀ dɛ̀, kɛ̀ n dɑ nɑ́kɛ́ kɑ̀ɑ wɛ̃tɛní. N yí dɔ́ ndi pɑɑ̀ didɛ́ diyiè dimɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kɛ̀ Debekɑɑ nɑ́kɛ́ Isɑki kɛ dɔ̀: N dɛmmu mufòmmu nɛ̀ n cɔ̀ɔ̀bɛ̀ Itiibɛ kó mɛdɔɔ̀rìmɛ̀ kpɛ́í, kɛ̀ Sɑkɔbu puokɛ di nhɛì kóo nitipòkù kɛ̀ n ku dɛ̀ ntɔ̃ũ. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kɛ̀ Isɑkii yú Sɑkɔbu kóò pɑ̃ mɛsɑ̀ɑ̀ nkɛ dɔ̀: A bɑ́ɑ́ puokɛ Kɑnnɑhɑ̃ɑ̃ kɔbɛ kóo sɑpɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ítɛ́ kɛ́kɔtɛ Mɛsopotɑmii Betuyɛɛdi ɑ yɔ̃ tɑ̃ũ̀ cĩ́ɛ̃̀tɛ̀, kɛ́puokɛ o kóo sɑpɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kuyie mmuwɛ̃rímú mumɔu yiɛ̀ mbo dɑ dɔɔ̀ mɛsɑ̀ɑ̀ nkɑ̀ɑ piɛ́ kɛ́sṹṹ, kɛ́nɑɑ́ nyibotí pɛ́u cicɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kuyie ndɑ dɔɔ̀ mɛsɑ̀ɑ̀ nfɔ̃́ nnɛ̀ ɑ yɑɑ̀bí kù dɔ̀ɔ̀mɛ̀ Abɑrɑhɑmmu, kɑ̀ɑ tiekɛ dihɛì ɑ mɛ̀ mbo dì kupɔ̀ɔ̀kù, kù duɔ́ ndì Abɑrɑhɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kɛ̀ Isɑkii duɔ́ nkɛ̀ Sɑkɔbuu kɔtɛ Mɛsopotɑmii, Betuyɛɛdi birɛ Dɑmɑɑ ciɛ ò do tú Arɑmu botí kou nwe Debekɑɑ tɑ̃ũ̀, Sɑkɔbu nɛ̀ Esɑyuu bɛ yɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Kɛ̀ Esɑyuu keè Isɑki pɑ̃mɛ̀ mɛsɑ̀ɑ̀ nSɑkɔbu, kɛ duɔ́ nkòò kɔ̀tɛ Mɛsopotɑmii kɛ bo túótɛ́ onitipòkù, kɛ́keè ò nɑ̀kɛ́mɛ̀ Sɑkɔbu kɛ tú: A bɑ́ɑ́ túótɛ́ Kɑnnɑhɑ̃ɑ̃ kɔbɛ kóo nitipòkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Kɛ̀ Sɑkɔbu yie nho cicɛ nɛ̀ o yɔ̃ bɛ kpɛti, kɛ kɔ̀tɛ Mɛsopotɑmii. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Kɛ̀ Esɑyuu bɑntɛ́ o cicɛ í dɔ́mɛ̀ Kɑnnɑhɑ̃ɑ̃ kó bɛnitipòbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","kɛ́kɔtɛ kɛ́túótɛ́ onitipòkù Mɑɑdɑti, Abɑrɑhɑmmu birɛ Isimɑyɛɛri kó dɛbirɛ Nɛbɑyɔti tɑ̃ũ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Kɛ̀ Sɑkɔbuu ítɛ́ Bɛɛrisebɑɑ kɛ́nkɔri Anɑɑ ɛì, ");
INSERT INTO tbzsim_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","kɛ́mberínɛ̀ dibòrì mɑrì kɛ̀ diyiè tɑ, kòo wɑɑ́ nditɑ̃́rì kɛ́ceé nho yuu kɛ́nduɔ́ dɛborɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","kɛ́yɑ̀ tidɔuǹtì mɑtì kɛ̀ kudìɛ̀ti cómmú kɛtenkɛ̀ kɛ kɑ́ɑ́ ntiwɛtì, kɛ̀ Kuyie ntɔ̃rɛ̀ dèkù kɛ cuuti. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kɛ̀ ti Yiɛ̀ nKuyie ncòḿmú o tɑkɛ́ koò nɑ̀ɑ́ nkɛ tú: N tú ɑ Yiɛ̀ nKuyie nku ɑ yɑ̀ɑ̀rì Abɑrɑhɑmmu nɛ̀ Isɑki bɛ̀ do tũ nkù. A duɔ́ kɛ̀ɛ̀ tenkɛ̀, n kɛ̀ ndɑ duɔ́mmu fɔ̃́ nnɛ̀ ɑ yɑɑ̀bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","A yɑɑ̀bí bo sṹṹ mmubirímú kɔ̃mɛ kɛ́pitɛ́ tipíìtì timɔu: Diyiè yìɛ̀ní kɛ̀ nɛ̀ dì tɑɑ̀ kɛ̀, kubɑkù cɑ̃̀nku nɛ̀ kuyoú. Fɔ̃́ nnɛ̀ ɑ yɑɑ̀bí díì yó nte kɛ̀ ǹ dɔɔ̀ ibotí imɔu mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","N yó ndɑ bonɛ̀mu kɛ dɑ kɑ̃nkɛ́ bɑ́ kɛ̀ɛ̀ bíɛ́kɛ̀, kɛ́ dɑ wɛ̃tɛnɛ̀ní di nhɛì. N yí yóó dɑ yóu, n yóó dɑ dɔɔ̀mu n dɑ nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Kɛ̀ Sɑkɔbuu entɛní kɛ dɔ̀: Ti Yiɛ̀ nKuyie nkuù bo diɛ mbɑ́ n do í yɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Kɛ̀ kufɔ̃wɑɑ́ nhò pĩ nkòò dɔ̀: Dibòrì dii ndò nkɛ́ndému, Kuyie ncĩ́ɛ̃̀tɛ̀ ntɛ, kɛĩ́nkɛ̀ kó dibòrì diì kpetɛ́ diɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kɛ̀ Sɑkɔbuu ítɛ́ dikṹnweńnì sɛ̀ì kɛ́túótɛ́ ditɑ̃́rì ò do cekɛ́ dì o yuu kɛ́fíí, nkɛ́cóú mmɛkùɔ̀ ndi ĩ́nkɛ̀ kɛ bo ndenniní, ");
INSERT INTO tbzsim_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","kɛ́yú dɛ kó dibòrì kɛ dɔ̀ Betɛɛdi (dɛ̀ɛ̀ tu Kuyie ncĩ́ɛ̃̀tɛ̀). Nɛ̀ dimɔ̀nnì bɛ̀ do dɛ yu kɛ tú Duusi nwe. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Kɛ̀ Sɑkɔbuu cɑnnɛnɛ̀ dinùù Kuyie nkɛ dɔ̀: Kɛ̀ Kuyie nni m bonɛ̀ n cèmmu miɛkɛ, kɛ n kɑ̃nkɛ́ kɛ n duɔ̀ mmudiì nɛ̀ tiyɑ̀ɑ̀tì, ");
INSERT INTO tbzsim_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kɛ̀ n wɛ̃̀tɛ kɛ kò n cicɛ cĩ́ɛ̃̀tɛ̀ nɛ̀ kukɔ̃ǹnɑɑtí, ti Yiɛ̀ nKuyie bo ntú n Yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","M mɛ ncónnɛ́ dìì tɑ̃́rì bo ntú Kuyie ncĩ́ɛ̃̀tɛ̀, kɛ̀ kù n duɔ́ ndɛ̀ n dɛitɛ dɛmɑ́ɑ̀ tɛpíítɛ̀ miɛkɛ kɛ́ kù duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Kɛ̀ Sɑkɔbuu sɔɔtɛ́ mucèmmu kɛ́nkɔri diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","kɛ́tuɔkɛ dibòrì mɑrì kɛ́yɑ̀ tɛbintɛ mɑtɛ̀. Kɛ̀ ditɑ̃́rì diɛrì pòkɛ, kɛ̀ tipecɛ̃nti tìtɑ̃ɑ̃ti duɔ́ dɛborɛ̀, bɛ̀ do dɛ ntì nììnko. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Tipecɛ̃nti do ɔ̃ɔ̃ dɛ ntíí, nkɛ̀ bɛ̀ɛ pootɛ ditɑ̃́rì kɛ́ tì nìì nkɛ́deè kɛ́wɛ̃tɛ kɛ́poo. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Kɛ̀ Sɑkɔbuu bekɛ bɛpecɛ̃mbɛ kɛ dɔ̀: Di ciɛ borɛ̀? Kɛ̀ bɛ̀ dɔ̀: Ti ciɛ bo Anɑɑ ɛì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Kòò dɔ̀: Di yɛ̃́ Nɑɔɔ birɛ Dɑmɑɑ? Kɛ̀ bɛ̀ dɔ̀: Ti ò yɛ̃́mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Kòò dɔ̀: Ò bo kɛ̀ dɛ̀ nɑɑtɑɑ̀? Kɛ̀ bɛ̀ dɔ̀: Ɛ̃ɛ̃, dɛ̀ nɑɑtimu! Ntɛ o kóo sɑpɑ̀ɑ̀ nDɑsɛɛdi kɛ kéríní nɛ̀ o pecɛ̃nku. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Kɛ̀ Sɑkɔbu dɔ̀: Diyiè kpɑɑ́ dɛumu nɛ̀ di bo tíímmɛ̀ ipe, niinnɛ̀ i kɛ́ ì kɔ̀tɛnɛ̀ kɛ̀ ìi di. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kɛ̀ bɛ̀ dɔ̀: Kɛ̀ ipe í tìí nyimɔu ti bɑ́ɑ́ nɑ, ì ɔ̃ɔ̃ tíí nyimɔu ndi kɛ̀ tí pootɛ ditɑ̃́rì kɛ́ ì nìì. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Kɛ̀ bɛ̀ nkpɑɑ́ kɛ mɛ nnɑ́ɑ́ nkɛ̀ Dɑsɛɛdii tuɔkɛní nɛ̀ o cicɛ pecɛ̃nku. Ò do tú opecɛ̃nti nwe. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Kɛ̀ Sɑkɔbuu ò yɑ̀ nɛ̀ o yɔ̃ tɑ̃ũ̀ Dɑmɑɑ pecɛ̃nku, kɛ́pootɛ tɛbintɛ kɛ́nii nyipe. Dɑsɛɛdi do tú Sɑkɔbu yɔ̃ tɑ̃ũ̀ Dɑmɑɑ birɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Kɛ̀ Sɑkɔbuu ò ɔrí kɛ dɔ̀ ò bo pĩ́ nhomɑ́ɑ̀ kɛ́yĩɛ̃kɛ, kɛ́kuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Kɛ̀ Sɑkɔbuu nɑ́kɛ́ Dɑsɛɛdi kɛ dɔ̀: N tú ɑ cicɛ tɑ̃ũ̀ Debekɑɑ birɛ ndɛ. Kɛ̀ Dɑsɛɛdii cokɛ́ kɛ́kò nkɛ́ tì nɑ̀kɛ́ o cicɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Kɛ̀ Dɑmɑɑ keè o tɑ̃ũ̀ birɛ Sɑkɔbu kpɛ́í, kɛ́cokɛ́ kóò ɔrí, kɛ̀ bɛ̀ɛ kò ntɛcĩ́ɛ̃̀tɛ̀, kɛ̀ Sɑkɔbuu ò nɑ̀kɛ́ dɛ̀ dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Kɛ̀ Dɑmɑɑ dɔ̀: Ti cĩ́ɛ̃̀tɛ̀ tɛmɑ́ɑ̀ ndi. Kɛ̀ Sɑkɔbu nhò bonɛ̀ kɛ dɔ̀ otɑ̃̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Kɛ̀ Dɑmɑɑ dɔ̀: A bo nni mpĩ́ mmutɔ̃mmú fɑ̀ɑ̀rɛ̀ ɑ tú mɛ̀ɛ̀ kpɛ́í n cĩ́ɛ̃̀tɛ̀ kouɑ̀? Nɑ́kɛ́ ɑ dɔ́ n dɑ yietí mù. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Dɛ mɔ̀nnì kɛ sɔ̃́ nDɑmɑɑ mɔ̀kɛ bɛsɑpɑ̀mbɛ̀ bɛ̀dɛ́bɛ̀. Kòo kótì tu Deɑ, kòo sɑ́m̀pɔ́ù tu Dɑsɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Kɛ̀ Deɑ nuɔ nyí nnɑɑti mɛsɑ̀ɑ̀ nkɛ̀ Dɑsɛɛdi tu oposɑ́ɑ́tì kɛ sɑ̀nnɛ̀ onitipòkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Kɛ̀ Sɑkɔbu ndɔ́ Dɑsɛɛdi kɛ dɔ̀: N dɔ́ Dɑsɛɛdi nwe, ɑ bíyɑ̃ɑ̃tɛ̀, kɛ bo dɑ pĩ́ mmutɔ̃mmú yɛbie nyɛ̀yiekɛ̀, kóò puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Kɛ̀ Dɑmɑɑ yie nkɛ dɔ̀: Kɛ̀ n we ndɑ duɔ́ ndɛ̀ wenninɛ̀ m bo ò duɔ́mmɛ̀ okpɑ́kpɑ̀rì. Á mbo n cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kɛ̀ Sɑkɔbu ḿbo koò pĩ mmutɔ̃mmú kɛ dɔ̀ yɛbie nyɛ̀yiekɛ̀, kɛ̀ dɛ kó yɛbie nní ndò nyɛ̀ í mɔ̀ntɛ ò dɔ́ mɛ̀ɛ̀ kpɛ́í nDɑsɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Kɛ̀ Sɑkɔbuu nɑ́kɛ́ Dɑmɑɑ kɛ dɔ̀: Dɛ mɔ̀nnì tùɔ̀kɛmu, n duɔ́ m pokù kɛ̀ nh ò puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kɛ̀ Dɑmɑɑ dɔɔ̀ dibɑnni kɛ́yú dihɛì kɔbɛ bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Kuyuoku mɔ̀nnì kɛ́túótɛ́ Deɑ kɛ́duɔ́ nSɑkɔbu kòo ò duɔ́nɛ̀ kɛyènkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Kɛ̀ Dɑmɑɑ túótɛ́ Sidipɑɑ o kóo nitipotɔ̃ntì kɛ́duɔ́ nDeɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Sɑkɔbu nsɔ̃́ nDeɑ nwe, kòo bekɛ Dɑmɑɑ kɛ dɔ̀: A n dɔ̀ɔ̀ bɑ! N dɑ pĩ mmutɔ̃mmú yɛbie nyɛ̀yiekɛ̀ Dɑsɛɛdi kpɛ́í nkɛ. Dɛ̀ yĩ́mɛ kɑ̀ɑ n soutɛ́? ");
INSERT INTO tbzsim_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Kɛ̀ Dɑmɑɑ dɔ̀: Ti ciɛ osɑ́m̀pɔ́ù ɔ̃ɔ̃ í nyenkɛ kòo kótì kpɑɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Yóu kɛ̀ dibɑnni kó yɛwe yɛ̀yiekɛ̀ɛ dèè kɛ̀ ti dɑ duɔ́ nhosɑ́m̀pɔ́ù, kɑ̀ɑ sɔɔtɛ́ mutɔ̃mmú yɛbie nyɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Kɛ̀ Sɑkɔbuu yie, kɛ̀ dɛ̀ mmɔkɛ yɛwe yɛ̀yiekɛ̀, kɛ̀ Dɑmɑɑ ò duɔ́ nDɑsɛɛdi, ");
INSERT INTO tbzsim_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","kɛ́túótɛ́ o kóo nitipotɔ̃ntì Bidɑɑ kɛ́duɔ́ nDɑsɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Kɛ̀ Sɑkɔbuu duɔ́nɛ̀ Dɑsɛɛdi, kɛ́ nhò dɔ́ kɛ̀ dɛ̀ pɛ̃ɛ̃tɛ́ Deɑ. Kòo yíɛ́ pĩ́ Dɑmɑɑ mmutɔ̃mmú yɛbie nyɛ̀yiekɛ̀ o kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Kɛ̀ ti Yiɛ̀ nKuyie nyɑ̀ Sɑkɔbu í dɔ́mɛ̀ Deɑ kɛ́duɔ́ nkòo mpɛí, kɛ̀ Dɑsɛɛdi yie ntú tɛhɑ̃ũntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Kɛ̀ Deɑ púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ, kɛ́ dɛ̀ yu kɛ dɔ̀ Dubɛnni, dɛ̀ɛ̀ tu: Ti Yiɛ̀ nKuyie nyɑ̀ n sémmɛ̀. Kɛ dɔ̀: N dɔù bo n dɔkɛ di mmɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Kòo wɛ̃tɛ kɛ́púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ kɛ dɔ̀: Ti Yiɛ̀ nKuyie mbɑntɛ́ bɛ̀ í n dɔ́mɛ̀, kɛ n yìɛ́ dɛbirɛ tɛrɛ̀. Kòo yu dɛ kó dɛbirɛ kɛ̀ dɔ̀ Simmɛɔ̃ɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Kòo wɛ̃tɛ kɛ́púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ kɛ dɔ̀: Di mmɔ̀nnì n dɔù yɛ̀mmɛ̀ bo mbo m bíɛ́kɛ̀. Kɛ̀ Sɑkɔbuu dɛ̀ yu kɛ̀ dɔ̀ Defii. ");
INSERT INTO tbzsim_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Kɛ̀ Deɑ yíɛ́ kɛ́púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ, kɛ dɔ̀: Di mmɔ̀nnì m bo sɑ̃ntɛ ti Yiɛ̀ nKuyie, kɛ́ dɛ̀ yú kɛ dɔ̀ Sudɑɑ. Dɛ mɔ̀nnì kɛ́cómmú kupɛitóo. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Dɑsɛɛdi yɑ̀ dìì mɔ̀nnì wè í pɛímɛ̀ kɛ̀ dɛ̀ɛ ò yonkɛ, kòo nɑ́kɛ́ Sɑkɔbu kɛ dɔ̀: Duɔ́ nkɛ̀ m pɛitɛ́, kɛ̀ mɛɛ̀ dɔkɛ n kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Kɛ̀ Sɑkɔbu miɛkɛɛ pɛikɛ Dɑsɛɛdi, kòo ò nɑ̀kɛ́ kɛ dɔ̀: N tú Kuyie nkuɑ̀ɑ̀? Kuyie nkuù dɑ mɔ̀ntɛ kupɛitóo. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Kɛ̀ Dɑsɛɛdi dɔ̀: Duɔ́nɛ̀ n kóo tɔ̃ntì kòo m piɛ́ ibí. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Kòo duɔ́ mBidɑɑ Sɑkɔbu kòo ò duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Kɛ̀ Bidɑɑ púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kɛ̀ Dɑsɛɛdi dɔ̀: Kuyie nni ǹ kòńnɛ́, kɛ kèè n sɑ́útìi, kɛ m pɑ̃ dɛnitidɑbirɛ. Kɛ yu dɛ kó dɛbirɛ kɛ dɔ̀ Dɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Kɛ̀ Bidɑɑ yíɛ́ púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Kɛ̀ Dɑsɛɛdi dɔ̀: M mɑnɛ̀ n kóo kótì kɛ nɑ, kɛ́ dɛ̀ yu kɛ dɔ̀ Nɛfutɑdii. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kɛ̀ Deɑ yɑ̀ ò tɛ̃́nkɛ í pɛímɛ̀, kɛ́túótɛ́ o kóo tɔ̃ntì Sidipɑɑ kɛ́duɔ́ nSɑkɔbu kòo puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Kɛ̀ Sidipɑɑ pɛitɛ́ dɛnitidɑbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Kɛ̀ Deɑ dɔ̀: N yuu diì nɑɑti! Kòo dɛ̀ yu kɛ dɔ̀ Kɑdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Kɛ̀ Sidipɑɑ yíɛ́ kɛ́pɛitɛ́ dɛnitidɑbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Kɛ̀ Deɑ dɔ̀: Dɛ̀ ǹ nɑrikɛ, di mmɔ̀nnì bɛnitipòbɛ̀ bo nni ntú diwɛ̀ì yiɛ̀. Kòo dɛ̀ yu kɛ dɔ̀ Asɛɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Mudidɛ̀ì mɔ̀nnì kɛ̀ Dubɛnnii kɔ̃tɛ́ kupɑku, kɛ́tɔ̃ũní yɛtebɛ bɛ̀ tu yɛ̀ mɑntidɑkɔ́ɔ̀, kɛ́tɔní kɛ́duɔ́ nho yɔ̃ Deɑ, kɛ̀ Dɑsɛɛdii ò mɔɔ kɛ dɔ̀: M pɑ̃ ɑ birɛ tɔní yɛ̀ɛ̀ tebɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Kɛ̀ Deɑ dɔ̀: A fìètɛ n dɔù kɛ̀ dɛ̀ í dɑ sɑnnɛ̀ kɑ̀ɑ wɛ̃̀tɛ kɛ dɔ́ kɛ́cɔutɛ́ m birɛ tɔní yɛ̀ɛ̀ tebɛɑ̀? Kɛ̀ Dɑsɛɛdi dɔ̀: Kɑ̀ɑ m pɑ̃ yɛtebɛ ò bo tɑ ɑ borɛ̀ kɛ nyènkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Kɛ̀ Sɑkɔbu nkũntiní kupɑku kuyuoku, kɛ̀ Deɑ ò co kɛ dɔ̀: A tɑti m borɛ̀ ndɛ yíe, n dɑ dontɛ́nɛ̀ m birɛ tɔní yɛ̀ɛ̀ tebɛ nyɛ. Kɛ̀ Sɑkɔbuu tɑ o borɛ̀ dɛ kó kɛyènkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Kɛ̀ Kuyie nteennɛ̀ Deɑ kòo púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ nummurɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","kɛ́bɛ́i nkɛ dɔ̀: Kuyie nni nyietí n duɔ́ mmɛ̀ɛ̀ kpɛ́í nkɛ n kóo tɔ̃ntì n dɔù. Kòo dɛ̀ yu kɛ dɔ̀ Isɑkɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Kòo wɛ̃tɛ kɛ́púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ kuɔ́nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Kɛ̀ Deɑ dɔ̀: Kuyie nni mpɑ̃ dipɑ̃nnì sɑ̀ɑ̀rì, di mmɔ̀nnì n dɔù bo m pɛ́nsìrì kɛ yɛ̃́ nh ò pɛitɛ́mɛ̀ initidɑbí ìkuɔ̀. Kòo dɛ̀ yu kɛ dɔ̀ Sɑbunɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Kòo yíɛ́ kɛ́pɛitɛ́ dɛnitipobirɛ kɛ́ dɛ̀ yu kɛ dɔ̀ Dinɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Kuyie nyí nyɛ̃̀ nDɑsɛɛdi kpɛ́í, kóò teennɛ̀ kòo bo piɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Kòo pɛitɛ́ dɛnitidɑbirɛ, kɛ́bɛ́i nkɛ dɔ̀: Kuyie nni ndènnɛ ifɛi. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kòo dɛ̀ yu kɛ dɔ̀ Sosɛfu, kɛ dɔ̀: Ti Yiɛ̀ nKuyie nhɑ n yíɛ́ dɛnitidɑbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Dɑsɛɛdi pɛitɛ́ dìì mɔ̀nnì Sosɛfu kɛ́deè, kɛ̀ Sɑkɔbuu nɑ́kɛ́ Dɑmɑɑ kɛ dɔ̀: M pɑ̃ kucɛ kɛ̀ ǹ kò n ciɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","N duɔ́ m pobɛ̀ nɛ̀ m bí n dɑ pĩ mutɔ̃mmú bɛ̀ɛ̀ kpɛ́í. A yɛ̃́mu m pĩ mmùù tɔ̃mmú ɑ cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kɛ̀ Dɑmɑɑ dɔ̀: Kéntɛ́ n dɔ́ kɛ́ dɑ nɑ́kɛ́ tì, m bɑntɛ́mu fɔ̃́ɔ̃̀ temɛ̀ kɛ̀ ti Yiɛ̀ nKuyie nni n dɔ̀ɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kɛ̀ Dɑmɑɑ dɔ̀: Nɑ́kɛ́ n yóó dɑ yietí mù kɛ̀ n dɑ yietí. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Kɛ̀ Sɑkɔbu dɔ̀: A yɛ̃́mu n dɑ pĩ mmɛ̀ɛ̀ botí mutɔ̃mmú kɑ̀ɑ wũɔ̃ sũ̀ṹ. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","N do yóó tuɔkɛní kɑ̀ɑ wũɔ̃ í sũ, kɛ̀ ǹ tùɔ̀kɛní kɛ̀ ì sũ̀ṹ. Míì te kɛ̀ ti Yiɛ̀ nKuyie ndɑ dɔ̀ɔ̀ mɛsɑ̀ɑ̀. Yóu di mmɔ̀nnì kɛ̀ m pĩ́ n kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Kɛ̀ Dɑmɑɑ bekɛ Sɑkɔbu kɛ dɔ̀: N yóó dɑ yietí bɑ? Kòò dɔ̀: A í yó n yietí mùmɑmù. Kɑ̀ɑ yie n yóó dɑ nɑ́kɛ́ tì, n sɔɔtɛ́ kɛ́ncɛ̃mmù ɑ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ò bɛ́i mɛmmɛ kɛ dɔ̀: M bo bɑtɛ yíe nhɑ pe nɛ̀ sibɔɔ́ kɛ́cɑ̃́nnɛ́, dɛ̀ɛ̀ ɑ̃ sisuɔ, nɛ̀ dɛ̀ɛ̀ dò nyɑ̀ùyɑ̀ù dɛɛ̀ yó ntú n kó tiyeti. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","A bo kɔtɛní dìì mɔ̀nnì kɛ́yɑ̀ m pecɛ̃nku, ɑ bo bɑntɛ́ n nɑ́ɑ́mmɛ̀ timɔ́mmɔnti. Kɑ̀ɑ sɔ̃́ nyipe nɛ̀ sibɔɔ́ dɛ̀ɛ̀ í mɔkɛ sisuɔ nɛ̀ dɛ̀ɛ̀ í dò nyɑ̀ùyɑ̀ù kɛ̀ dɛ̀ bo n kpɛyi miɛkɛ, n dɛ̀ yùúkúmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Kɛ̀ Dɑmɑɑ dɔ̀: N yiemmu ɑ bɛ́i ntì. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Dɛ kó diyiè mɔ́mmɔnni, kɛ̀ Dɑmɑɑ bɑtɛ ipe nɛ̀ sibɔɔ́ dɛ̀ɛ̀ ɑ̃ sisuɔ nɛ̀ dɛ̀ɛ̀ dò nyɑ̀ùyɑ̀ù, kɛ́duɔ́ nho bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Kɛ̀ bɛ̀ɛ ítɛ́ kɛ́mmɔkɛ mucèmmu yɛwe yɛ̀tɑ̃ɑ̃ti kɛ́dɛ́tɛ́nɛ̀ Sɑkɔbu. Kɛ̀ Sɑkɔbu nkpɑɑ́ cɛ̃mmú Dɑmɑɑ kpɛyi ìì kpɑɑ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","kɛ́wɑɑ́ ndɛtie mmɑrɛ̀ dɛtɑ̃ɑ̃ti kó ibɑkɛ, kɛ́ ì cìku yɛpíɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","kɛ́búú ndɛ kó idɛí iwũɔ̃ yɔ̃̀ ndɛ̀, kɛ̀ ì nkɔrìní muyɑ̃̀ɑ̃̀ kɛ ì yɑ̀u kɛ dekù itɔbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","kɛ pɛí sisuɔ kpɛyi nɛ̀ ìì dò nyɑ̀ùyɑ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kɛ̀ Sɑkɔbu mbɑɑ̀tì ìì ɑ̃ sisuɔ nɛ̀ ìì dò nyɑ̀ùyɑ̀ù, kɛ cɑ̃́nnìnko. Kɛ̀ Sɑkɔbuu mɔɔtɛ o kó kupecɛ̃nku kɛ̀ kù ncɑ̃́ɑ̃́nnɛ̀ Dɑmɑɑ kɔku. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Iwũɔ̃ ìì kpeńnì kɛ̀ ì dɔ́ kɛ́dekɛ dìì mɔ̀nnì wèe mɛ́ú ndɛ kó idɛí ì yɔ̃̀ ndɛ̀ kɛ̀ ì ndekù kɛ ì wùó. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Kɛ̀ icĩ̀rìyì dɔ́ kɛ́dekɛ ò bɑ́ɑ́ mɛ́ú ndɛ kó idɛí. Mɛm̀mɛ kɛ̀ icĩ̀rìyì ntú Dɑmɑɑ kpɛyi kɛ̀ ikpéríyì tu Sɑkɔbu kpɛyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Kɛ̀ Sɑkɔbuu kpɑrìkɛ̀ mɛdiɛ̀, kɛ́mɔɔtɛ ipe nɛ̀ sibɔɔ́ pɛ́u, bɛnitidɑtɔ̃mbɛ̀ nɛ̀ bɛnitipotɔ̃mbɛ̀, yòyóbɛ̀ nɛ̀ sɑ̃mmɑrímúbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kɛ̀ Sɑkɔbuu keè Dɑmɑɑ bí nɑ́ɑ́mmɛ̀ kɛ tú: Sɑkɔbu fìètɛ ti cicɛ kpɑ̀tì nti, dɛɛ̀ te kòò kpenkɛ miɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kòo yɑ̀ Dɑmɑɑ yɛ̀mmɛ̀ tɛ̃́nkɛ í ò nɑɑtinɛ̀mɛ̀ mɛ̀ do ɔ̃ ndòmmɛ̀ nɛ̀ dimɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Sɑkɔbu kɛ dɔ̀: Kò nhɑ cicɛ ciɛ bɛ̀ dɑ pɛitɛ́ dɛ̀. N yó ndɑ bonɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kɛ̀ Sɑkɔbuu yú Dɑsɛɛdi nɛ̀ Deɑ dikpɑ́ɑ̀ ò cɛ̃mmú dɛ̀ o wũɔ̃, ");
INSERT INTO tbzsim_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: N yɑ̀ di cicɛ yɛ̀mmɛ̀ tɛ̃́nkɛ í n nɑɑtinɛ̀mɛ̀ mɛ̀ do ɔ̃ ndòmmɛ̀, Kuyie n cicɛ tũ nkù mɛ nni m bonɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Di yɛ̃́mu m pĩ̀ḿmɛ̀ di cicɛ mutɔ̃mmú nɛ̀ n wɛ̃rímú mumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Kòò n ciitɛ́, kɛ cèètɛ n yeti kucɛ tɛpíítɛ̀, Kuyie mmɛ nyí yóu kòò n dɔ̀ɔ̀ mɛyɛi mmɑmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Ò yĩ dìì mɔ̀nnì ìì ɑ̃ sisuɔ ì bo ntú n kpɛyi kɛ̀ ìi piɛ́ ìì ɑ̃ sisuɔ, kòò dɔ̀ ìì dò nyɑ̀ùyɑ̀ù ì bo ntú n kpɛyi, kɛ̀ ìi piɛ́ ìì dò nyɑ̀ùyɑ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Kuyie nkuù cɔutɛ́ di cicɛ wũɔ̃ kɛ n duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ipe nɛ̀ sibɔɔ́ dɛ̀ dèkù dìì mɔ̀nnì, kɛ̀ n yɑ̀ nɛ̀ tidɔuǹtì dɛ̀ɛ̀ ɑ̃ sisuɔ nɛ̀ dɛ̀ɛ̀ dò nyɑ̀ùyɑ̀ù dɛɛ̀ dèkùmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kɛ̀ Kuyie ntɔ̃nnì n yú kɛ dɔ̀: Sɑkɔbu! Kɛ̀ n dɔ̀: Ntɛ mí. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kɛ̀ dì dɔ̀: Wéntɛ́ kɛ́yɑ̀ yɛbɔdɑkɛ̀ nɛ̀ ipe dɛ̀ɛ̀ dò nyɑ̀ùyɑ̀ù dɛɛ̀ dèkùmɛ̀. N yɑ̀mu Dɑmɑɑ dɑ dɔɔ̀rimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Míì tu di Yiɛ̀ nKuyie nhɑ do yɑ̀ kù Betɛɛdi, kɛ́fíí nditɑ̃́rì, kɛ́cóú mmɛkùɔ̀ nkɛ́ n nɑ́kɛ́ ɑ dɔ́ tì. Di mmɔ̀nnì, ítɛ́ kɛ́kò nhɑ ɛì bɛ̀ dɑ pɛitɛ́ dì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kɛ̀ Dɑsɛɛdi nɛ̀ Deɑ kɛ̀ bɛ̀ dɔ̀: Ti cicɛ í yóó kú kɛ̀ ti túótɛ́ dɛ̀mɑrɛ̀ o cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ò ti wèńtɛ́ bɛpɔ̀ɔ̀bɛ̀ mbɛ, kɛ tì fìtɛ́ kɛ di ti díítí, bɑ́ wè í ti duɔ́ nwe do dò nkɛ́ ti duɔ́ nyì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kuyie ncɔutɛ́ tìì kpɑ̀tì ti cicɛ borɛ̀ kɛ dɑ duɔ́ ntì tu ti kpɛti nti, tínti nɛ̀ ti bí, dɔɔ̀ Kuyie ndɑ nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kɛ̀ Sɑkɔbuu bɑ́ɑ́tí, kɛ́dee nho bí nɛ̀ o pobɛ̀ yòyóbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","kɛ́túótɛ́ o wũɔ̃ nɛ̀ o kpɑ̀tì timɔu ò pɛ̀tɛ́ tì Mɛsopotɑmii, kɛ́kétɛ́ kɛ́nkũnti o cicɛ Isɑki borɛ̀ Kɑnnɑhɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kɛ sɔ̃́ nDɑmɑɑ kɔ̀tɛ kɛ kɛ̃ĩ o pe cìtì, kɛ̀ Dɑsɛɛdi yúúkú o bɔkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Kɛ̀ Sɑkɔbuu soutɛ́ Dɑmɑɑ Arɑmu botí kou, kɛ́ítɛ́ bɑ́ ò í ò cɑu, ");
INSERT INTO tbzsim_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","kɛ́túótɛ́ o kpɛrɛ dɛmɔu kɛ́cokɛ́, kɛ́séntɛ́ kukó ndiɛkù Efɑdɑti, kɛ́kétɛ́, kɛ́nwetí Kɑdɑɑdi tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Diyiè tɑ̃ɑ̃́nnì yiè kɛ̀ bɛ̀ɛ nɑ́kɛ́ Dɑmɑɑ Sɑkɔbu cokɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kòo túótɛ́ o kɔbɛ, kɛ́tũnnɛ Sɑkɔbu kɛ́mmɔkɛ yɛwe yɛ̀yiekɛ̀, kóò nìntɛ Kɑdɑɑdi tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Kɛ̀ Kuyie nnɑ́kɛ́ Dɑmɑɑ, Arɑmu botí kou nɛ̀ tidɔuǹtì kɛ dɔ̀: A bɑ́ɑ́ dɔɔ̀ Sɑkɔbu tìmɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Wè ò nìntɛ mɛmmɛ kɛ sɔ̃́ nSɑkɔbu còńnɛ́ o touku Kɑdɑɑdi tɑ̃rì ĩ́nkɛ̀, kɛ̀ Dɑmɑɑ múnkɛɛ cónnɛ́ o kɔku, ");
INSERT INTO tbzsim_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","kɛ́bekɛ Sɑkɔbu kɛ dɔ̀: A n dɔ̀ɔ̀ bɑ, kɛ n soutɛ́? Kɛ tùótɛ́ n kó bɛsɑpɑ̀mbɛ̀ kɛ dò nhɑ kpɑ̀ nkɛ bɛ̀ ɛí. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Dɛ̀ dòmmɛ kɑ̀ɑ n soutɛ́, kɛ sɔ̀ri kɛ cokɛ́, bɑ́ ɑ í n nɑ̀kɛ́? Ti nɑ n dɑ cíemmu kɛ́ndiè, kɛ bie nyɛbɑ̀rɛ̀ nɛ̀ tikùtìdùùtì kɛ̀ dɛ̀ nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","A í yóu kɛ̀ nh ɔrí n kó bɛsɑpɑ̀mbɛ̀ nɛ̀ n yɑɑ̀bí. A dɔ̀ɔ̀ dɛyɛinkpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","M mɔkɛmu muwɛ̃rímú kɛ nɑ ndɑ dɔ̀ɔ̀ mɛyɛi, kɛ̀ Kuyie nhɑ cicɛ tũ nkù nɛ́ n nɑ̀kɛ́ kɛyènkɛ̀ kɛ̀ɛ̀ pɛ̃ɛ̃tɛ́ kɛ tú m bɑ́ɑ́ dɑ dɔɔ̀ tìmɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","A dɔ́ mɛcɑ̃ɑ̃ mmɛ kɛ bo kò nhɑ cicɛ cĩ́ɛ̃̀tɛ̀, dɛ̀ nɛ́ yĩ́mɛ kɑ̀ɑ yùúkú m bɔkɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Kɛ̀ Sɑkɔbu dɔ̀: N yĩɛ̃̀kù ɑ bo fietɛ mɛ̀mmɛ ɑ kó bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Wéntɛ́ n kó bɛnìtìbɛ̀, kɑ̀ɑ yɑ̀ wèè borɛ̀ ɑ bɔkɛ̀ bɛ̀ɛ ò kùɔ. Sɑkɔbu do í yɛ̃́ kɛ dò nDɑsɛɛdi weè yɛ̀ tùótɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kɛ̀ Dɑmɑɑ tɑ Sɑkɔbu kó kutouku, kɛ́tɑ Deɑ kɔku, kɛ́tɑ o kó bɛnitipotɔ̃mbɛ̀ bɛdɛ́ kpɛti, ò í nyɑ̀ mùmɑmù, kɛ́yɛ̀ kɛ́tɑ Dɑsɛɛdi kɔku. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Kɛ yɛ̃́ bɑ! Kɛ̀ Dɑsɛɛdi weè yɛ̀ tùótɛ́ kɛ sɔ̀nnɛ yɛsɑ̃nkɔ̃̀nkɛ̀ miɛkɛ kɛ kɑri yɛ ĩ́nkɛ̀. Kɛ̀ Dɑmɑɑ wɑmmú titouti timɔu miɛkɛ kɛ́mɔ́ntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Kɛ̀ Dɑsɛɛdi dɔ̀: N cicɛ ɑ miɛkɛ bɑ́ɑ́ pɛikɛ n yí mɛ̀ nyìtɛ́mɛ̀ n kɑ̀rì, m bo n tɑ̃̀nkù yɛirɛ ndɛ. Kɛ̀ Dɑmɑɑ wɑmmú kɛ́mɔ́ntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kɛ̀ dɛ̀ɛ yonkɛ Sɑkɔbu kòo nkpɑnnɛ̀ Dɑmɑɑ, kɛ tú: N cɑ̀kɛ bɑ? N dɔ̀ɔ̀ ɔ̃̀mmɛ yɛi nkɑ̀ɑ n tũ̀ nnɛ̀ kɛmiɛkɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","A fiɛ́mu n nɛntì, ɑ yɑ̀ bɑ dɛ̀ɛ̀ tu ɑ kpɛrɛ? Bɛnkɛ dɛ n kɔbɛ nɛ̀ ɑ kɔbɛ, kɛ̀ bɛ̀ɛ yɑ̀ kɛ́ ti pútɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","M bo ɑ cĩ́ɛ̃̀tɛ̀ kɛ mɔkɛ yɛbie nsipísìdɛ́ ndi, m mɛ nyí cɑ̀ɑ́kɛ́ ɑ pedɑɑ̀ mɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Musĩ̀mmù í pĩ nhɑ ɔ̃̀fɛ̀ mɑfɛ̀, kɛ̀ n fɛ̀ tɔní kɛ dɑ bɛnkɛ, nh ɔ̃ɔ̃ fɛ̀ yietímu. Kɑ̀ɑ m békú bɛ̀ yúúkú ì kuyie nnɛ̀ kɛyènkɛ̀, kɛ̀ ǹ dɑ yietí. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Kɛ̀ fɛwentɑɑfɛ̀ m potɛ́, kɛ̀ muséé nni m potɛ́ kɛyènkɛ̀, kɛ̀ n níí nyié nkɛ wúó. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Yɛbie nsipísìdɛ́ ndi m bomɛ̀ ɑ cĩ́ɛ̃̀tɛ̀, kɛ pĩ mmutɔ̃mmú yɛbie ntɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀ ɑ kó bɛsɑpɑ̀mbɛ̀ kpɛ́í, nkɛ cɛ̃mmú ɑ wũɔ̃ yɛbie nyɛ̀kuɔ̀. Kɑ̀ɑ cèètɛ n yeti kucɛ tɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kɛ̀ Kuyie, n yɑ̀ɑ̀rì Abɑrɑhɑmmu do tũ nkù, n cicɛ Isɑki dé kù do í n teennɛ̀, ɑ nɑ nni m bɛ̀ti n nɔu sinùmmù ndi. Kù mɛ nyɑ̀mu n fɛ̃̀ṹtɛ́mɛ̀ ɑ cĩ́ɛ̃̀tɛ̀, kɛ n teennɛ̀ wenkɛ kɛyènkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Dɛ mɔ̀nnì kɛ̀ Dɑmɑɑ ò tɛ̃̀ńnɛ́ kɛ dɔ̀: N kó bɛsɑpɑ̀mbɛ̀ tu biɛ, bɛ bí tú n kpɛyi nyi, kɛ̀ iwũɔ̃ ii ntú n kpɛyi, dɛmɔu ɑ mɛ̀ nwùó ndɛ̀ tu n kpɛrɛ ndɛ. M mɛ nyí yóó nɑ kɛ́dɔɔ̀nɛ̀ mùmɑmù n kó bɛsɑpɑ̀mbɛ̀ nɛ̀ bɛ bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yóu kɛ̀ ti tɑu mmí nnɛ̀ fɔ̃́ nkɛ́dɔɔ̀ mɛbɛnkùmɛ̀ mɑmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Kɛ̀ Sɑkɔbuu túótɛ́ ditɑ̃́rì kɛ́fíí, ");
INSERT INTO tbzsim_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","kɛ́nɑ́kɛ́ o kɔbɛ kɛ dɔ̀: Wɑɑ́nnɛ̀nní yɛtɑ̃́rɛ̀! Kɛ̀ bɛ̀ɛ yɛ̀ wɑɑnní kɛ́cóú nditɑ̃́cóù, kɛ̀ bɛ̀ɛ kɑri bɛmɔu di ĩ́nkɛ̀ kɛ́di. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Kòo dì yu kɛ dɔ̀: Mɛtɑummɛ̀ kó mɛbɛnkùmɛ̀ kó ditɑ̃́cóù. Nɛ̀ Dɑmɑɑ kó tinɑ́ɑǹtì Yekɑɑ-Sɑɑdutɑɑ nɛ̀ Sɑkɔbu kpɛti Kɑdɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kɛ̀ Dɑmɑɑ dɔ̀: Di ntɑ̃́cóù diì yó mbɛnkú mí nnɛ̀ fɔ̃́ nti tɑummɛ̀. Nɛ̀ dɛ kpɛ́í nkɛ bɛ̀ɛ dì yu kɛ dɔ̀ Kɑdɛdi, ");
INSERT INTO tbzsim_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","kɛ́yíɛ́ kɛ́ dì yu kɛ dɔ̀ Misipɑɑ. Kɛ̀ Dɑmɑɑ dɔ̀: Ti Yiɛ̀ nKuyie nní nti wúó nti dɛ̀tɛ́nɛ̀ dìì mɔ̀nnì titɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Kɑ̀ɑ fɛ̃́ũnko n kó bɛsɑpɑ̀mbɛ̀, kɛ tùókɛ́ bɛtɔbɛ̀, ɑ nyɛ̃́ kɛ dò nhonìtì weè í ti wúó, Kuyie nkuù ti wúó. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Kɛ̀ Dɑmɑɑ dɔ̀: Ntɛ ditɑ̃́cóù n còú ndì nɛ̀ ditɑ̃́rì n fìí ndì mí nnɛ̀ fɔ̃́ nti cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Di ntɑ̃́cóù nɛ̀ di ntɑ̃́rì dɛ̀ ntú ti tɑummɛ̀ kó dibɛnkɛ̀rì. M bɑ́ɑ́ dɛ̀ pɛ̃ɛ̃tɛ́ kɛ́kɔtɛ ɑ bíɛ́kɛ̀ kɛ́dɔɔ̀ mɛyɛi, ɑ mɛ mbɑ́ɑ́ dɛ̀ pɛ̃ɛ̃tɛ́ kɛ́kɔtɛní m bíɛ́kɛ̀ kɛ́dɔɔ̀ mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Kuyie nhAbɑrɑhɑmmu nɛ̀ Nɑɔɔ bɛ̀ tũ nkù ni nti wúó! Kɛ̀ Sɑkɔbuu pɑrìkɛ̀ kɛ́yú Kuyie nho cicɛ Isɑki dé kù yètìrì, ");
INSERT INTO tbzsim_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","kɛ́féútɛ́ fɛɔ̃̀fɛ̀ Kuyie, kɛ́yú o kɔbɛ kɛ̀ bɛ̀ɛ cɑ́ɑ́kɛ́ kɛ́nyié nditɑ̃rì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Kɛ̀ dɛ̀ɛ wentɛ́ dikṹnweńnì, kɛ̀ Dɑmɑɑ ɔrí o kó bɛsɑpɑ̀mbɛ̀ nɛ̀ bɛ bí, kɛ́ ì pɑ̃ mɛsɑ̀ɑ̀ nkɛ́kò. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Kɛ̀ Sɑkɔbuu sɔɔtɛ́ o cèmmu, kɛ̀ Kuyie ntɔ̃rɛ̀ɛ ò co. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Kòo yɛ̀ yɑ̀ kɛ dɔ̀: Kuyie nkó dikɑ̀rì ndi diɛ. Mɛm̀mɛ ò dɛ̀ yumɛ̀ kɛ dɔ̀ Mɑɑnɑimmu (dɛ̀ɛ̀ tu yɛkɑ̀rɛ̀ yɛ̀dɛ́ɛ̀). ");
INSERT INTO tbzsim_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Kòo tɔ̃ mbɛnìtìbɛ̀ Seii Edɔmmu kó kutempɛ̃ mmiɛkɛ o kóo kótì Esɑyuu borɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Di nɑ́kɛ́ n yiɛ̀ nhEsɑyuu kɛ dɔ̀: A kóo tɔ̃ntì Sɑkɔbu kɔ̀tɛ Dɑmɑɑ ciɛ nkɛ, kɛ kɛ mbo kɛ tùɔ̀kɛnɛ̀ní yíe. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kɛ mɔkɛ inɑ̀ɑ̀kɛ nɛ̀ sɑ̃mmɑrímúbɛ̀ nɛ̀ ipe nɛ̀ sibɔɔ́ nɛ̀ bɛnitidɑtɔ̃mbɛ̀ nɛ̀ bɛnitipotɔ̃mbɛ̀, kɛ tú fɔ̃́ nho yiɛ̀ nhɑ ò cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Kɛ̀ Sɑkɔbu do tɔ̃ mbɛ̀ɛ wɛ̃tɛní kóò nɑ̀kɛ́ kɛ dɔ̀: Ti kɔ̀tɛmu kɛ yɑ̀ ɑ kóo kótì Esɑyuu, kòò kèríní nɛ̀ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔusìnɑ̀ɑ̀ (400). ");
INSERT INTO tbzsim_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Kɛ̀ kufɔ̃wɑɑ́ nhɑutɛ́ Sɑkɔbu mɛdiɛ̀ nkòo totɛ́ bɛ̀ɛ̀ ò nɛínɛ̀ yɛtĩ̀rɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ iwũɔ̃ ò do tɔ ì, ipe nɛ̀ sibɔɔ́, inɑ̀ɑ̀kɛ nɛ̀ yòyóbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Kɛ nɑ́ɑ́ nkɛ tú: Kɛ̀ Esɑyuu kùɔ ditĩ̀nnì mɑrì, ditɛrìi cokɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Kɛ̀ Sɑkɔbuu bɑ́ntɛ̀ Kuyie nkɛ dɔ̀: Kuyie n yɑ̀ɑ̀rì Abɑrɑhɑmmu nɛ̀ n cicɛ Isɑki do tũ nkù, fɔ̃́ɔ̃̀ n nɑ̀kɛ́ kɛ tú: Wɛ̃tɛ ɑ ciɛ, ɑ kɔbɛ borɛ̀ kɛ̀ ǹ dɑ dɔɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","N yí mɑ̀nnɛ̀ mɛsɑ̀ɑ̀ nhɑ do yɛ̃ nhɑ yó n dɔɔ̀ mɛ̀ kɛ mɛ̀ dɔ̀ɔ̀, mí nhɑ kóo tɔ̃ntì. N do senti kukó nSuditɛ̃ɛ̃ kɛ pikú m pɑ̀ɑ̀ti mɑ́ɑ̀ ndi, di mmɔ̀nnì kɛ nɑɑ́ nyɛtĩ̀rɛ̀ yɛ̀dɛ́ɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","N dɛɛtɛ́nɛ̀ n kóo kótì Esɑyuu, n yĩɛ̃̀kù ò bo kɔtɛnímɛ̀ mmɛ kɛ́ n kuɔ nɛ̀ m pobɛ̀ nɛ̀ m bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","A do bɛ́immu kɛ dɔ̀ ɑ yó n dɔɔ̀ mɛsɑ̀ɑ̀, nkɛ̀ n yɑɑ̀bíi sṹṹ nkɛ́ndò ndɑ̀mɛ́ɛ̀rì nùù kó mubirímú, bɑ́ bɛ̀ bɑ́ɑ́ nɑ kɛ́ ì kɑ̀ɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Kɛ̀ Sɑkɔbuu bɑ́tɛ́ dɛborɛ̀ kɛ́yié, kɛ́dɛitɛ ò do mɔkɛ dɛ̀ miɛkɛ ò yóó pɑ̃ dɛ̀ o kóo kótì Esɑyuu. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Sibɔniisi sikɔusìdɛ́ (200) nɛ̀ yɛbɔdɑkɛ̀ sipísìdɛ́ nɛ̀ ipeni sikɔusìdɛ́ (200) nɛ̀ yɛpedɑkɛ̀ sipísìdɛ́ ");
INSERT INTO tbzsim_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","nɛ̀ yòyóbɛ̀ bɛniibɛ bɛ̀ɛ̀ tɔ ibí sipísìtɑ̃ɑ̃ti nɛ̀ bɛ̀ bío nɛ̀ inɑɑni sipísìnɑ̀ɑ̀ nɛ̀ yɛnɑɑdɑkɛ̀ tɛpíítɛ̀ nɛ̀ sɑ̃mmɑrímúbɛ̀ niibɛ sipísìdɛ́ nɛ̀ isɑ̃mmɑrímbí tɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kòo dɛ̀ totɛ́ dɛ tɔ̃ntì dɛ tɔ̃ntì, kɛ́duɔ́ nho tɔ̃mbɛ̀ kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Niitɛ́nɛ̀ kɛ̀ mɛfíè nní nsokɛ́ di cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Kòo nɑ́kɛ́ oketiwè kɛ dɔ̀: Kɛ̀ n kóo kótì Esɑyuu dɑ conɛ̀ kɛ bekɛ kɛ tú: We ndɑ te? A kɔri kɛ? We nte iwũɔ̃ ìì ni ɑ ììkɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","A dɔ̀: A kóo tɔ̃ntì Sɑkɔbu weè dɛ̀ te, kɛ dɛ̀ ndɑ pɑ̃ kɛ tũ̀nní. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Kɛ̀ Sɑkɔbu mɛ nnɑ́kɛ́ odɛ́rì nɛ̀ otɑ̃ɑ̃́nwè nɛ̀ bɛsɔmbɛ bɛ̀ɛ̀ tũ̀ nkɛ dɔ̀: Kɛ̀ di yɑ̀ n yiɛ̀ nhEsɑyuu di mɛ nhò nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","A kóo tɔ̃ntì Sɑkɔbu tũ̀nnímu. Sɑkɔbu do nɑ́ɑ́nnɛ̀ o yɛ̀mmɛ̀ mmɛ kɛ tú, yɛpɑ̃rɛ̀ yiɛ mbo bónkùnnɛ o miɛkɛ, kɛ̀ tí mɑ́ɑ́ kòo n cɔutɛ́ nɛ̀ diwɛ̀ì. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kɛ̀ bɛ̀ɛ kétɛ́nɛ̀ yɛpɑ̃rɛ̀ kɛ̀ wenwe nkpɑɑ́ dɛ kó kɛyènkɛ̀ bɛ̀ bɑ̀tɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Mɛm̀mɛ kòo ítɛ́ dɛ kó kɛyènkɛ̀ kɛ́túótɛ́ o pobɛ̀ bɛdɛ́ nɛ̀ o nitipotɔ̃mbɛ̀ bɛdɛ́ nɛ̀ o bí tɛpíítɛ̀ nɛ̀ dɛmɑ́ɑ̀ kɛ bo séntɛ́ tipètì-yɛ̀rì, bɛ̀ tu kùù kó nSɑbɔki. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kòo bɛ̀ sée nkukó nkɛ́séennɛ̀ o mɔ̀kɛ dɛ̀ɛ̀ kó dimɑ̀ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","kɛ́ ndɛ̀ kpɑɑ́ omɑ́ɑ̀ kɛ́nyié nkɛ mɑùnɛ̀ onìtì mɔù nɛ̀ kukṹnwentóo. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Kɛ̀ dɛ kóo nìtì nsɔ̃́ nwè í yóó nɑ Sɑkɔbu, kɛ́potɛ́ o kpeyuu kòo nɑɑ́ ndikpɛ̃nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Kɛ̀ dɛ kóo nìtì dɔ̀: N yóu kɛ̀ m pɛ̃ɛ̃tɛ́! Kɛ̀ Sɑkɔbu dɔ̀: Kɑ̀ɑ í m pɑ̃ mɛsɑ̀ɑ̀ m bɑ́ɑ́ dɑ yóu. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kɛ̀ dɛ kóo nìtìi bekɛ Sɑkɔbu kɛ dɔ̀: A yètìrì tu bɑ? Kòò dɔ̀: Sɑkɔbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kòò dɔ̀: Bɛ̀ tɛ̃́nkɛ í yó ndɑ yu kɛ tú Sɑkɔbu, bɛ̀ yó ndɑ tú Isidɑyɛɛri nwe, kɛ yɛ̃́ ɑ mɑnɛ̀mɛ̀ ti Yiɛ̀ nKuyie nnɛ̀ bɛnìtìbɛ̀ kɛ nɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kɛ̀ Sɑkɔbu dɔ̀: N dɑ bɑ́ɑ́mmu n nɑ́kɛ́ ɑ yètìrì, kòò dɔ̀: Bɑ nte kɑ̀ɑ m bèkú n yètìrì? Ò mɛ nyĩ kóò dɔ̀ɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Kɛ̀ Sɑkɔbu dɔ̀: N yɑ̀ Kuyie nkɛ kpɑɑ́ fòù. Mɛm̀mɛ kòo yú dɛ kó dibòrì kɛ dɔ̀ Penniyɛɛdi (dɛ̀ɛ̀ tu ti Yiɛ̀ nKuyie nyììkɛ̀). ");
INSERT INTO tbzsim_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Sɑkɔbu nsenti Penniyɛɛdi kó kukó nkɛ̀ diyiè yɛ̀nní kòò cèntì dikpɛ̃nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Dɛɛ̀ te nɛ̀ yíenní kɛ̀ Isidɑyɛɛribɛ í yo nfɛɔ̃̀fɛ̀ kpeyuu kó kumɑɑ nkɛ yɛ̃́ ti Yiɛ̀ nKuyie ndo dɛ mpotɛ́mɛ̀ Sɑkɔbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Sɑkɔbu yɑ̀ dìì mɔ̀nnì Esɑyuu duunnímɛ̀, kɛ nɛínɛ̀ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔusìnɑ̀ɑ̀ (400), kɛ́totí ibí Deɑ nɛ̀ Dɑsɛɛdi nɛ̀ bɛnitipotɔ̃mbɛ̀ bɛdɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","kɛ́nií nhonitipotɔ̃mbɛ̀ nɛ̀ bɛ bí, Deɑ nɛ̀ o kpɛyi kɛ̀ bɛ̀ mpokoo, Dɑsɛɛdi nɛ̀ Sosɛfu kɛ̀ bɛ̀ ntũ. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Kòo niitɛ́ o mɔ́mmuɔ mbɛ ììkɛ̀, kɛ́yɑ̀ o kóo kótì Esɑyuu, kɛ́nínkóo o ììkɛ̀ kucɛ mɛ̀yiekɛ̀ kɛ yɑ̀ɑ tɔ́ɔ́nnɛ̀nko ò borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kɛ̀ Esɑyuu cokɛ́ní kóò ɔrí, kɛ̀ diwɛ̀ìi bɛ̀ ɑutɛ́, kɛ̀ bɛ̀ɛ kuɔ́ mbɛdɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Kɛ̀ Esɑyuu yɑ̀ bɛnitipòbɛ̀ nɛ̀ ibí, kɛ́bekɛ kɛ dɔ̀: Ɔ̃̀mbɛ mbɛ biɛ mbɛ̀ɛ̀ dɑ nɛínɛ̀? Kɛ̀ Sɑkɔbu dɔ̀: Ti Yiɛ̀ nKuyie m pɑ̃ bɛ̀mbɛ mí nhɑ kóo tɔ̃ntì. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kòo nitipotɔ̃mbɛ̀ɛ tɔ́ɔ́nní nɛ̀ bɛ bí kɛ́nínkóo o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kɛ̀ Deɑ tɔ́ɔ́nní kɛ́nínkóo o ììkɛ̀ nɛ̀ o bí. Kɛ̀ Dɑsɛɛdi nɛ̀ Sosɛfu kɛ̀ bɛ̀ múnkɛɛ mɛ nyĩ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Kɛ̀ Esɑyuu o bekɛ kɛ dɔ̀: A dɔ́ kɛ́dɔ̀ɔ̀nɛ̀ bɑ m mɛ̀ n conɛ̀ ìì wũɔ̃? Kòò dɔ̀: N dɔ́ fɔ̃́ n yiɛ̀ nhɑ́ n cɔutɛ́ mɛsɑ̀ɑ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kɛ̀ Esɑyuu dɔ̀: M mɔkɛ kɛ̀ dɛ̀ sũmu n nɑntɛ̀, ńte ɑ kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Kɛ̀ Sɑkɔbu dɔ̀: N dɑ bɑ́ɑ́mmu, kɑ̀ɑ n cɔutɛ́mu, cɔutɛ́ m pɑ̃rɛ̀, n dɑ yɑ̀ kɛ̀ dɛ̀ dò n yɑ̀ Kuyie nku, kɛ yɛ̃́ ɑ n cɔutɛ́mɛ̀ nɛ̀ diwɛ̀ì. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","N dɑ bɑ́ɑ́mmu cɔutɛ́ n dɑ pɑ̃ dɛ̀, ti Yiɛ̀ nKuyie nni n dɔ̀ɔ̀mu mɛsɑ̀ɑ̀, kɛ̀ m̀ mɔ̀kɛ dɛmɔu. Kɛ̀ Sɑkɔbuu yetoo kɛ̀ Esɑyuu cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kɛ̀ Esɑyuu dɔ̀: Ítɛ́nɛ̀ kɛ̀ tí nɛi kɛ́kò. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kɛ̀ Sɑkɔbu dɔ̀: N yiɛ̀ nhɑ yɛ̃́mu kɛ dò nyibí kpɑɑ́ yɔɔ̀, kɛ̀ ipe bo nɛ̀ inɑ̀ɑ̀kɛ nɛ̀ tinɑɑbiiti, kɛ̀ ti ì kètɛ́nɛ̀ mɛcɑ̃ɑ̃ ndiyiè mɑrì mɑ́ɑ̀ ì bo kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Fɔ̃́ n yiɛ̀ nhɑ́ niitɛ́, mí nhɑ kóo tɔ̃ntì kɛ̀ nní ntũ mmɛyɔɔ̀mmɛ̀ nɛ̀ iwũɔ̃ nɛ̀ ibí kɛ́tuɔkoo ɑ ciɛ Seii. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kɛ̀ Esɑyuu dɔ̀: M bo dɑ yóunɛ̀ n kó bɛnìtìbɛ̀ mɑbɛ̀. Kɛ̀ Sɑkɔbu dɔ̀: Kɛ̀ bɛ̀ɛ dɔɔ̀ bɑ? Fɔ̃́ ncɛ̃́nkɛ n cɔutɛ́nɛ̀ diwɛ̀ì. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Dɛ kó diyiè dimɑ́ɑ̀ miɛkɛ kɛ̀ Esɑyuu kétɛ́ kɛ́nwɛ̃ti Seii. ");
INSERT INTO tbzsim_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kɛ̀ Sɑkɔbuu kɔtɛ Sukɔti kɛ́mɑɑ́ tɛcĩ́ɛ̃̀tɛ̀, kɛ́dɔɔ̀ o wũɔ̃ titouti. Dɛɛ̀ te kɛ̀ bɛ̀ yu dɛ kó dibòrì kɛ tú Sukɔti (dɛ̀ɛ̀ tu titouti). ");
INSERT INTO tbzsim_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Sɑkɔbu dɛ nyìtɛ́ Mɛsopotɑmii, kɛ́tuɔkɛnɛ̀ kukɔ̃ǹnɑɑtí Sisɛmmu Kɑnnɑhɑ̃ɑ̃ kó kɛtenkɛ̀, kɛ́kɑri dihɛì mɑ̀nku, ");
INSERT INTO tbzsim_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","kɛ́dontɛ́ kɛtenkɛ̀ mɛdítíbii ntɛkɔ̀ùtɛ̀ (100) Amɔɔ bí borɛ̀, ìì te kɛtenkɛ̀ Sisɛmmu, kɛ́cónnɛ́ o touku, ");
INSERT INTO tbzsim_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","kɛ́mɑɑ́ diwũɔ̃tɔ̀nnì, kɛ́ dì yu kɛ dɔ̀ Edi-Edowɛɛ-Isidɑyɛɛri (dɛ̀ɛ̀ tu ti Yiɛ̀ nKuyie nyIsidɑyɛɛribɛ tũ nkù). ");
INSERT INTO tbzsim_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Diyiè mɑrì kɛ̀ Dinɑ, Deɑ kóo sɑpɑ̀ɑ̀ ńyɛ̀ kɛ bo dɔu ndihɛì kó bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Kɛ̀ Efiibɛ kóo kpɑ̀ɑ̀tì Amɔɔ kóo dɑpɑ̀ɑ̀ Sisɛmmuu ò yɑ̀, kóò pĩ nkɛ́duɔ́nɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","kóò pɛ́nsìrì mɛdiɛ̀, kɛ́ndɔ́ kɛ́yṹɔ̃́ nhosɑpɑ̀ɑ̀ nyɛ̀mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Mɛm̀mɛ Sisɛmmu nɑ̀kɛ́mɛ̀ o cicɛ Amɔɔ kɛ dɔ̀: Kɔtɛ kɛ́yɑ̀ osɑpɑ̀ɑ̀ nyie nyɛmbɛ̀, n dɔ́ kóò puokɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Kɛ̀ Sɑkɔbuu keè Sisɛmmu duɔ́nɛ̀mɛ̀ Dinɑ, kɛ sɔ̃́ nho kó bɛdɑpɑ̀mbɛ̀ bo kupɑku kɛ cɛ̃mmú iwũɔ̃. Kòò ndò nyúóó kɛ kémmú bɛ̀ bo konnímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Kɛ̀ Sisɛmmu cicɛ Amɔɔ kɔtɛ Sɑkɔbu borɛ̀ kɛ bo ò nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Kòo kó bɛdɑpɑ̀mbɛ̀ nkũntiní kupɑku kɛ́keè dɛ̀ɛ̀ dɔ̀ɔ̀, kɛ̀ dɛ̀ɛ bɛ̀ yonkɛ, kɛ̀ bɛ̀ miɛkɛɛ pɛikɛ, kɛ yɛ̃́ Sisɛmmu dɔ̀ɔ̀mɛ̀ dɛ̀ɛ̀ tu isɔkɛ Isidɑyɛɛribɛ miɛkɛ, kɛ duɔ́nɛ̀ Sɑkɔbu kóo sɑpɑ̀ɑ̀, dɛ̀ɛ̀ do ci Isidɑyɛɛribɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Kɛ̀ Amɔɔ dɔ̀: N kóo dɑpɑ̀ɑ̀ nSisɛmmu yɛ̀mmɛ̀ mɛɛ̀ tɑ di kóo sɑpɑ̀ɑ̀, di we nhò duɔ́ nkòo puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ti wɛ̃nnɛ́nɛ̀ kɛ̀ tí mpuokú di kó bɛsɑpɑ̀mbɛ̀ kɛ̀ di puokú ti kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Kɛ̀ tí nwɛ̃ nkɛ bo, kɛ̀ dihɛì ntú di kpɛri, kɛ̀ di ndɔɔri kupotɑɑ́ nkɛ mɔkɛ sibɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kɛ̀ Sisɛmmuu nɑ́kɛ́ osɑpɑ̀ɑ̀ ncicɛ nɛ̀ o tɑ̃bɛ̀ kɛ dɔ̀: Kɛ̀ di n dɔ̀ɔ̀ mɛsɑ̀ɑ̀ nkɛ bekɛ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ n di duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Kɛ̀ di n yiennɛ̀ di kóo sɑpɑ̀ɑ̀ nkɛ bekɛ tipocòntì kɛ̀ ti dɛu kɛ mɑmɛ̀ nɛ̀ yɛpɑ̃rɛ̀ n di duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kɛ̀ Sɑkɔbu kó bɛdɑpɑ̀mbɛ̀ɛ nɑ́kɛ́ Sisɛmmu nɛ̀ o cicɛ nɛ̀ mɛciì nkɛ yɛ̃́ ò pĩ̀ḿmɛ̀ bɛ tɑ̃ũ̀ Dinɑ nɛ̀ muwɛ̃rímú kɛ duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Kɛ̀ bɛ̀ dɔ̀: Ti bɑ́ɑ́ nɑ kɛ́duɔ́ nti tɑ̃ũ̀ wèè í cɑ̃ntɛ́, dɛ̀ tu mɛyɛi mmɛ ti borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ti í yóó yie ndi yɛ̃ mmù, kɛ̀ di í cɑ̃mmú bɛnitidɑɑbɛ̀ bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Dɛ mɔ̀nnì ndi ti bo di duɔ́mmɛ̀ ti kó bɛsɑpɑ̀mbɛ̀, kɛ́túókɛ́ di kɔbɛ, kɛ̀ ti ńwɛ̃ nkɛ bo, kɛ́nɑɑ́ nkubotí kumɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kɛ̀ di mɛ nyetɛ ti yɛ̃ mmù tí túótɛ́ ti tɑ̃ũ̀ kɛ́pɛ̃ɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Amɔɔ nɛ̀ o birɛ Sisɛmmu kɛ̀ bɛ̀ɛ pɛ́nsìrì dɛ kó tinɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Bɑ́ odɑpɑ̀ɑ̀ nyí nhɔɔtɛ ò bo dɔɔ̀mɛ̀ bɛ̀ bɛ́i ntì, kɛ yɛ̃́ ò dɔ́mɛ̀ osɑpɑ̀ɑ̀ mmɛdiɛ̀. Bɛ̀ do we ntɑ̃́ okpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀ miɛkɛ kɛ̀ dɛ̀ pɛ̃ɛ̃tɛ́ bɛtɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Amɔɔ nɛ̀ o birɛ Sisɛmmu, kɛ̀ bɛ̀ɛ kɔtɛ dihɛì kó dibòrì, kɛ́nɑ́kɛ́ bɛ kɔbɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Bɛnìtìbɛ̀ biɛ ntu diwɛ̀ì kɔbɛ mbɛ, yóunɛ̀ kɛ̀ bɛ̀ mbo ti ɛì, kɛ dɔɔri kupotɑɑ́, dihɛì í kɛ̃ńnì, kɛ̀ ti ḿpuokú bɛ kó bɛsɑpɑ̀mbɛ̀, kɛ̀ bɛ̀ puokú ti kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bɛ̀ tu, kɛ̀ ti yie mbɛ̀ yɛ̃ mmù, kɛ cɑ̃mmú bɛnitidɑɑbɛ̀ bɛmɔu, bɛ̀ bo ti wɛ̃nnɛ́nɛ̀ kɛ̀ ti nɑɑ́ nkubotí kumɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Kɛ̀ ti yie mbɛ̀ yɛ̃ mmù, kɛ̀ bɛ̀ ti bonɛ̀, tíì yóó tiekɛ bɛ wũɔ̃ nɛ̀ bɛ kpɛrɛ dɛmɔu bɛ̀ mɔ̀kɛ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Bɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo dɛborɛ̀ kɛ̀ bɛ̀ɛ yie nhAmɔɔ nɛ̀ o birɛ Sisɛmmu bɛ̀ nɑ̀kɛ́ tì, kɛ̀ dihɛì dimɔu kó bɛnitidɑɑbɛ̀ɛ cɑ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Diyiè tɑ̃ɑ̃́nnì yiè, dɛ̀ dɔ̀kɛ yóù dìì yiè kɛ̀ bɛ̀ kɑ̀ri kɛ í yɛ̃́ tìmɑtì, Simmɛɔ̃ɔ̃ nɛ̀ Defii Dinɑ tɑ̃bɛ̀ kɛ̀ bɛ̀ɛ túótɛ́ bɛ kpɑ̀rìse kɛ́tɑ dihɛì kɛ́kuɔ bɛnitidɑɑbɛ̀ bɛmɔu, ");
INSERT INTO tbzsim_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","kɛ́kuɔ Amɔɔ nɛ̀ o birɛ Sisɛmmu, kɛ́dɛitɛ bɛ tɑ̃ũ̀ Dinɑ Sisɛmmu cĩ́ɛ̃̀tɛ̀ kɛ́kònnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Kɛ̀ Sɑkɔbu bí tɛìi ítɛ́ kɛ́túótɛ́ tikúnɛntì nɛ̀ dihɛì kpɛrɛ, kɛ yɛ̃́ bɛ̀ pĩ̀ḿmɛ̀ bɛ tɑ̃ũ̀ nɛ̀ muwɛ̃rímú kɛ duɔ́nɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","kɛ́kpɑɑkɛ bɛ pe nɛ̀ bɛ nɑ̀ɑ̀kɛ nɛ̀ sɑ̃mmɑrímúbɛ̀ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo dihɛì nɛ̀ dɛpɑɑ, ");
INSERT INTO tbzsim_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","kɛ́hɛí bɛ kpɑ̀tì timɔu, bɛ bí nɛ̀ bɛ pobɛ̀ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo bɛ cɛ̃́ĩ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Kɛ̀ Sɑkɔbuu nɑ́kɛ́ Simmɛɔ̃ɔ̃ nɛ̀ Defii kɛ dɔ̀: Di n cɑ̀kɛmu, kɛ̀ ǹ nɑɑ́ nhoyɛiwe Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Pedisiibɛ bɛ ììkɛ̀. N kɔbɛ í sũ, bɛ̀ yóó tíímmu kɛ́ n dokɛ́nɛ̀, kɛ́ n nɑ, kɛ́ n kuɔ nɛ̀ n cĩ́ɛ̃̀tɛ̀ tɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Kɛ̀ bɛ̀ dɔ̀: Ti nɑ nyóu kɛ̀ bɛ̀ɛ wéntɛ́ ti tɑ̃ũ̀ onitipòkù wèè dɔuti dɔutinɛ̀ bɛnitidɑɑbɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Diyiè mɑrì kɛ̀ Kuyie nnɑ́kɛ́ Sɑkɔbu kɛ dɔ̀: Ítɛ́ kɛ́kɔtɛ Betɛɛdi kɛ́ m mɑɑ́ diwũɔ̃tɔ̀nnì, n do dɛ ndɑ bɛnkɛ m mɑ́ɑ̀ ɑ do cokùnɛ̀ dìì mɔ̀nnì ɑ kóo kótì Esɑyuu. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kɛ̀ Sɑkɔbuu nɑ́kɛ́ o cĩ́ɛ̃̀tɛ̀ kɔbɛ nɛ̀ bɛ̀ɛ̀ do ò bonɛ̀ bɛmɔu kɛ dɔ̀: Bɔntɛ́nko yɛbɔkɛ̀ kɛ́wénkùnnɛ dimɑ́ɑ̀, kɛ́ceetɛ di yɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Bɑ́ɑ́tínɛ̀ kɛ̀ tí kɔtɛ Betɛɛdi kɛ́mɑɑ́ diwũɔ̃tɔ̀nnì Kuyie nkpɛ́í, kɛ yɛ̃́ kuù do n teennɛ̀mɛ̀ n do ɑ́ɑ́rì dìì mɔ̀nnì, kɛ́ nni mbonɛ̀ n cèmmu mumɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kɛ̀ bɛ̀ɛ duɔ́ mbɛ bɔkɛ̀ yɛmɔu Sɑkɔbu nɛ̀ bɛ mɑ́mɑ́nnɛ̀ bɛ̀ do tũɔ̃́ dɛ̀ bɛ to, kòo dɛ̀ kũnnɛ́ mutie diɛmù tɑkɛ́ Sisɛmmu, ");
INSERT INTO tbzsim_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","kɛ́pɛ̃ɛ̃tɛ́. Kɛ̀ Kuyie mbɔntɛ́ kufɔ̃wɑɑ́ nyɛhɛkɛ̀ yɛ̀ɛ̀ dɛ̀ tɔ̀kɛ́, bɑ́ bɛ̀ í ndɑ̀ɑ́tí kɛ́ bɛ̀ tũ̀nnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Sɑkɔbu nɛ̀ o kɔbɛ bɛmɔu kɛ̀ bɛ̀ɛ tuɔkɛ Duusi bɛ̀ tu dɛ̀ Betɛɛdi, Kɑnnɑhɑ̃ɑ̃ kó dihɛì, ");
INSERT INTO tbzsim_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","kɛ́mɑɑ́ diwũɔ̃tɔ̀nnì kɛ́ dì yu kɛ dɔ̀ Kuyie-mbo-Betɛɛdi, kɛ yɛ̃́ kù do dɛ nhò bɛnkɛmɛ̀ kumɑ́ɑ̀ ò cokùnɛ̀ dìì mɔ̀nnì o kóo kótì. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Kɛ̀ Deborɑɑ, Debekɑɑ kóo yuɔ̀rìi kú kɛ̀ bɛ̀ɛ ò kũnnɛ́ Betɛɛdi tɑkɛ́, mutie diɛmù mɑmù yuu, bɛ̀ tu mù yɛdɑbùò nkɔ̃mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Sɑkɔbu kũntiní dìì mɔ̀nnì Mɛsopotɑmii kɛ̀ Kuyie nyíɛ́ kóò bɛnkɛ kumɑ́ɑ̀, kóò pɑ̃ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Kóò nɑ̀kɛ́ kɛ dɔ̀: A yètìrì tu Sɑkɔbu nwe, di mmɔ̀nnì kɛ yó ntú Isidɑyɛɛri. Mɛm̀mɛ Kuyie nhò yúmɛ̀ kɛ dɔ̀ Isidɑyɛɛri. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Kɛ̀ kùu ò nɑ̀kɛ́ kɛ dɔ̀: Míì tu Kuyie nkɛ kpeńnì. A bo piɛ́ kɑ̀ɑ botíi sṹṹ nkɑ̀ɑ nɑɑ́ nyibotí pɛ́u cicɛ, kɛ̀ bɛkpɑ̀ɑ̀tìbɛ̀ɛ yɛ̀nní i miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","N duɔ́ ndìì ɛì Abɑrɑhɑmmu nɛ̀ Isɑki, m bo dì ndɑ duɔ́ nkɛ́ dì duɔ́ nhɑ yɑɑ̀bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Kuyie nhò nɑ̀kɛ́ mɛmmɛ kɛ́deè kɛ́ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Kɛ̀ Sɑkɔbuu fíí nditɑ̃́rì, kɛ́cóú mmɛkùɔ̀ nnɛ̀ mɛnɑɑ̀ nkɛ bo ndenniní, ");
INSERT INTO tbzsim_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","kɛ́yú Kuyie ndo ò nɑ̀ɑ́nnɛ̀ dìì bòrì kɛ dɔ̀ Betɛɛdi (dɛ̀ɛ̀ tu Kuyie ncĩ́ɛ̃̀tɛ̀). ");
INSERT INTO tbzsim_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Sɑkɔbu nɛ̀ o kɔbɛ kɛ̀ bɛ̀ɛ ítɛ́ Betɛɛdi, kɛ́nkpɑɑ́ díɛtirìnɛ̀ sɑ́m̀pɔ́ Efɑdɑtɑ, kɛ̀ Dɑsɛɛdi ndɔ́ kɛ́pɛitɛ́ kɛ̀ dɛ̀ɛ yonkɛ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Kɛ̀ dɛbirɛ nyɛtìní wèè ò pɛinko kòo nɑ́kɛ́ Dɑsɛɛdi kɛ dɔ̀: Bɑ́ nyĩɛ̃̀kù ɑ wɛ̃̀tɛ kɛ pɛitɛ́ dɛnitidɑbirɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Kɛ̀ Dɑsɛɛdi ḿmɑunɛ̀ mukṹṹ nkɛ́yú dɛbirɛ kɛ dɔ̀: Bɛni-Oni (dɛ̀ɛ̀ tu: Mɛyɛi mbirɛ). Kɛ̀ Sɑkɔbuu dɛ̀ yu kɛ dɔ̀ Bɛnsɑmɛɛ (dɛ̀ɛ̀ tu kubɑkù yoú). ");
INSERT INTO tbzsim_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Kɛ̀ Dɑsɛɛdii kú kɛ̀ bɛ̀ɛ ò kũnnɛ́ Efɑdɑtɑ kó kucɛ, bɛ̀ yu dɛ̀ yíe nkɛ tú Bɛtideɛmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Kɛ̀ Sɑkɔbuu cónnɛ́ ditɑ̃́rì Dɑsɛɛdi fɔ̃ti ĩ́nkɛ̀ kɛ́ dì yu kɛ dɔ̀ Dɑsɛɛdi fɔ̃titɑ̃́rì, kɛ̀ dì kpɑɑ́ bo nɛ̀ yíenní. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Kɛ̀ Sɑkɔbuu ítɛ́ dɛborɛ̀ kɛ́kɑri Mikidɑɑ-Edɛɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","kɛ́mbo dɛ kó dihɛì kɛ̀ Dubɛnni duɔ́nɛ̀ Bidɑɑ onitipotɔ̃ntì o cicɛ po wè. Kɛ̀ Sɑkɔbuu keè, kɛ̀ dɛ̀ɛ ò yonkɛ. Sɑkɔbu do mɔkɛ ibí tɛpíítɛ̀ nɛ̀ ìdɛ́ì nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Kɛ̀ Deɑ kó ibí tú: Dubɛnni, Sɑkɔbu kóò Po nɛ̀ Simmɛɔ̃ɔ̃ nɛ̀ Defii nɛ̀ Sudɑɑ nɛ̀ Isɑkɑɑ nɛ̀ Sɑbunɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Kɛ̀ Dɑsɛɛdi kpɛyi tú Sosɛfu nɛ̀ Bɛnsɑmɛɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Kɛ̀ Bidɑɑ Dɑsɛɛdi nitipotɔ̃ntì kpɛyi tú Dɑnni nɛ̀ Nɛfutɑdii. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Kɛ̀ Sidipɑɑ Deɑ kóo nitipotɔ̃ntì kpɛyi tú Kɑdi nɛ̀ Asɛɛ. Sɑkɔbu nitidɑbí nyi ò piɛ́ ì Mɛsopotɑmii. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Kɛ̀ Sɑkɔbuu tuɔkɛ o cicɛ Isɑki borɛ̀ Mɑmmudee, dɛ̀ɛ̀ tɔ̀kɛ́nɛ̀ Kidiyɑ-Adibɑ. Bɛ̀ tu dɛ̀ yíe nhEbunɔɔ. Abɑrɑhɑmmu nɛ̀ Isɑki bɛ̀ do borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Isɑki do mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìni (180) ndi, ");
INSERT INTO tbzsim_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","ò do yóó kú kɛ kòtɛ́ mɛdiɛ̀ mmɛ. Kòo bí Esɑyuu nɛ̀ Sɑkɔbu kɛ̀ bɛ̀ɛ ò kũnnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ntɛ Esɑyuu bɛ̀ tu wè Edɔmmu o kó kufuku: ");
INSERT INTO tbzsim_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Ò do puokɛ Kɑnnɑhɑ̃ɑ̃ kó bɛnitipòbɛ̀ mbɛ, Adɑ Edonni birɛ, Itiibɛ kó kubotí kou, nɛ̀ Odibɑmɑɑ Anɑ birɛ, wèè yɑ̀ɑ̀rì tu Sibeɔ̃ɔ̃ Efiibɛ kó kubotí kou ");
INSERT INTO tbzsim_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","nɛ̀ Bɑsimɑti Isimɑyɛɛri birɛ Nɛbɑyɔti tɑ̃ũ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Kɛ̀ Adɑ pɛitɛ́ Edifɑsi, kɛ̀ Bɑsimɑtii pɛitɛ́ Deuyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Kɛ̀ Odibɑmɑɑ pɛitɛ́ Yeusi nɛ̀ Yɑedɑmmu nɛ̀ Kodɑɑ Esɑyuu nitidɑbí nyi ò piɛ́ ì Kɑnnɑhɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Kɛ̀ Esɑyuu túótɛ́ o pobɛ̀ nɛ̀ o nitidɑbí, nɛ̀ o nitipobí nɛ̀ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo o cĩ́ɛ̃̀tɛ̀ nɛ̀ o wũɔ̃ nɛ̀ ò pɛ̀tɛ́ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ Kɑnnɑhɑ̃ɑ̃, kɛ́kɔtɛ dihɛì tɛrì kɛ́dɛ́tɛ́nɛ̀ o nɑntɛ̀ Sɑkɔbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Bɛ̀ do mɔkɛ tikpɑ̀tì nti mɛdiɛ̀, mbɛ̀ bɑ́ɑ́ nɑ kɛ́nwɛ̃ nkɛ kɑri, bɛ̀ bo kɛ̀ɛ̀ tenkɛ̀ í sɑ̀nnɛ̀ bɛ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Kɛ̀ Esɑyuu bɛ̀ tu wè Edɔmmuu kòo kɔtɛ kɛ́mbo Seii tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ntɛ Esɑyuu wèè tu Edɔmiibɛ yɑ̀ɑ̀rì wèè do bo Seii tɑ̃rì o fuku: ");
INSERT INTO tbzsim_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Edifɑsi Adɑ birɛ nɛ̀ Deuyɛɛdi Bɑsimɑti birɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Edifɑsi bí tú: Temɑɑ nɛ̀ Omɑɑdi nɛ̀ Sefoo nɛ̀ Kɑtɑmmu nɛ̀ Kenɑsi. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Timunɑ do tú Edifɑsi pocɛ̃nnì ndi, kóò pɛitɛ́ Amɑdɛki. Adɑ Esɑyuu pokù yɑɑ̀bí nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Deuyɛɛdi bí tú: Nɑɑti nɛ̀ Sedɑɑ nɛ̀ Sɑmɑɑ nɛ̀ Misɑɑ. Bɑsimɑti Esɑyuu pokù yɑɑ̀bí nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ntɛ Odibɑmɑɑ Anɑ birɛ, Sibeɔ̃ɔ̃ yɑɑ̀birɛ Esɑyuu pokù bí: Yeusi Yɑedɑmmu nɛ̀ Kodɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Ntɛ Esɑyuu yɑɑ̀bí ìì di tikpɑ̀tì: Temɑɑ nɛ̀ Omɑɑ nɛ̀ Sefoo nɛ̀ Kenɑsi nɛ̀ Kodɑɑ nɛ̀ Kɑtɑmmu nɛ̀ Amɑdɛki. Bɛɛ̀ do tú bɛkpɑ̀ɑ̀tìbɛ̀ Edɔmmu, Esɑyuu nɛ̀ o pokù Adɑɑ bɛ kóò Po Edifɑsi bí nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Nɑɑti nɛ̀ Sedɑɑ nɛ̀ Sɑmɑɑ nɛ̀ Misɑɑ bɛ̀ do tú bɛkpɑ̀ɑ̀tìbɛ̀ mbɛ Edɔmmu. Esɑyuu nɛ̀ o pokù Bɑsimɑti bɛ birɛ Deuyɛɛdi bí nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Yeusi nɛ̀ Yɑedɑmmu nɛ̀ Kodɑɑ bɛ̀ do tú bɛ̀ɛ̀ bɑkɛ́ bɛ̀ mbɛ. Esɑyuu nɛ̀ o pokù Odibɑmɑɑ Anɑ birɛ bɛ bí nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Esɑyuu yɑɑ̀bí nyi ìì do tú Edɔmiibɛ kó bɛkpɑ̀ɑ̀tìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Seii botí kou bɛ̀ tu wè Oditi o yɑɑ̀bí, iì do ketɛ́ kɛ́mbo Edɔmmu. Ɔriibɛ kpɑ̀ɑ̀tìbɛ̀ do tú: Dotɑ̃ɑ̃ nɛ̀ Sobɑdi nɛ̀ Sibeɔ̃ɔ̃ nɛ̀ Anɑ nɛ̀ Disɔ̃ɔ̃ nɛ̀ Esɛɛ nɛ̀ Disɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Kɛ̀ Dotɑ̃ɑ̃ bí ntú: Ɔɔri nɛ̀ Emɑmmu kòo tɑ̃ũ̀ ntú Timunɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Kɛ̀ Sobɑdi bí ntú: Adifɑnni Mɑnɑɑti nɛ̀ Ebɑɑdi nɛ̀ Sefoo nɛ̀ Onɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Kɛ̀ Sibeɔ̃ɔ̃ kpɛyi tú Ayɑ nɛ̀ Anɑ. Anɑ weè do pɛ̀tɛ́ tɛbintɛ tonnìtɛ̀ dikpɑ́ɑ̀ cuokɛ̀, kɛ cɛ̃mmú o cicɛ Sibeɔ̃ɔ̃ sɑ̃mmɑrímúbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anɑ bí tú Disɔ̃ɔ̃ nɛ̀ dɛnitipobirɛ Odibɑmɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Kɛ̀ Disɔ̃ɔ̃ kó ibí ntú: Emmutɑ̃ɑ̃ nɛ̀ Esibɑnni nɛ̀ Itidɑnni nɛ̀ Kedɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Kɛ̀ Esɛɛ kpɛyi ntú: Bideɑnni nɛ̀ Sɑfɑ̃ɑ̃ nɛ̀ Akɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Kɛ̀ Disɑ̃ɑ̃ kpɛyi ntú Uusi nɛ̀ Adɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Oriibɛ bɛ̀ɛ̀ do di tikpɑ̀tì Seii bɛɛ̀ tu: Dotɑ̃ɑ̃ nɛ̀ Sobɑdi nɛ̀ Sibeɔ̃ɔ̃ nɛ̀ Anɑ nɛ̀ Disɔ̃ɔ̃ nɛ̀ Esɛɛ nɛ̀ Disɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Isidɑyɛɛribɛ mu ndo í mɔkɛ dìì mɔ̀nnì okpɑ̀ɑ̀tì kɛ̀ bɛ̀ɛ̀ ntɔu tikpɑ̀tì Edɔmmu tenkɛ̀ kɛ feimmu bɛtɔbɛ̀, ntɛ bɛ yètɛ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beɔɔ birɛ Bedɑɑ Dinɑbɑɑ ɛì kou, weè do ketɛ́ kɛ́tɔ tikpɑ̀tì Edɔmmu, ");
INSERT INTO tbzsim_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","kɛ́kú kɛ̀ Bosedɑɑ ɛì kou Sedɑɑ birɛ Yobɑbuu cɔutɛ́ tikpɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","39","O kó difɔ̃nkúò kɛ̀ Temɑɑ ɛì kou Usɑmmuu cɔutɛ́ tikpɑ̀tì, kɛ́kú kɛ̀ Afiti ɛì kou Bedɑdi birɛ Adɑdii cɔutɛ́ tikpɑ̀tì, kɛ́kú, weè do dokɛ́nɛ̀ Mɑndiyɑ̃ɑ̃bɛ Mɔɑbu tenkɛ̀ miɛkɛ kɛ́ bɛ̀ nɑ. O kó difɔ̃nkúò kɛ̀ Mɑsedekɑɑ ɛì kou Sɑ̃mudɑɑ cɔutɛ́ tikpɑ̀tì, kɛ́kú kɛ̀ kukó ndiɛkù kó dihɛì Deobɔti ɛì kou Sɑudii cɔutɛ́ tikpɑ̀tì kɛ́kú, kɛ̀ Akibɔɔ birɛ Bɑɑdi-Anɑnni cɔutɛ́ tikpɑ̀tì kɛ́kú. Kɛ̀ Pɑuu ɛì kou Adɑdii cɔutɛ́ tikpɑ̀tì, weè do puokɛ Mɑtidɛti kóo sɑpɑ̀ɑ̀ Mɛtɑbeyɛɛdi. O pokù yɔ̃ kótì yètìrì do tú Mɛsɑɑbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Esɑyuu weè tu Edɔmiibɛ yɑ̀ɑ̀rì. Ntɛ dɛ kó bɛkpɑ̀ɑ̀tìbɛ̀ yètɛ̀: Timunɑ nɛ̀ Adifɑɑ nɛ̀ Yetɛti nɛ̀ Odibɑmɑɑ nɛ̀ Edɑɑ nɛ̀ Pinɔɔ nɛ̀ Kenɑsi nɛ̀ Temɑɑ nɛ̀ Mibisɑɑ nɛ̀ Mɑkidiyɛɛdi nɛ̀ Idɑmmu. Edɔmiibɛ kpɑ̀ɑ̀tìbɛ̀ mbɛ bɑ́ wè nɛ̀ o ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Kɛ̀ Sɑkɔbu ḿbo Kɑnnɑhɑ̃ɑ̃ o cicɛ do borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ntɛ Sɑkɔbu bí kó tinɑ́ɑǹtì. Sosɛfu do mɔkɛ yɛbie ntɛpíítɛ̀ nɛ̀ yɛ̀yiekɛ̀ ndi, kɛ́nnɛitinɛ̀ o kó bɛkótíbɛ̀ Bidɑɑ nɛ̀ Sidipɑɑ Sɑkɔbu pobɛ̀ bí, kɛ̀ bɛ̀ cɛ̃mmù iwũɔ̃, kɛ̀ Sosɛfu kũũnní kɛ nɑ́ɑ́ nho cicɛ o kó bɛkótíbɛ̀ nɑ́ɑntɛ tìì nɑ́ɑǹyɛiti. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Sɑkɔbu do dɔ́ Sosɛfu nwe kɛ̀ dɛ̀ pɛ̃ɛ̃tɛ́ o bí tɛì kɛ yɛ̃́ ò do ò pɛitɛ́mɛ̀ o kótì cuokɛ̀ nkɛ, kóò yɑ́ ndiyɑɑ̀bòrì sɑ̀ɑ̀rì iníɛkɛ kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kòo kó bɛkótíbɛ̀ɛ yɑ̀ o cicɛ ò dɔ́mɛ̀ mɛdiɛ̀, kɛ̀ bɛ miɛkɛ nhò pɛ́ì, bɑ́ bɛ̀ í nhò dɔ́nɛ̀ tinɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Diyiè mɑrì kɛ̀ Sosɛfuu duɔ́ tidɔuǹtì kɛ́nɑ́kɛ́ o kó bɛkótíbɛ̀. Kɛ̀ bɛ miɛkɛ dɔ̀kɛɛ ò pɛikɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Ntɛ dɛ kó tidɔuǹtì do tú mù: ");
INSERT INTO tbzsim_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Kòò dɔ̀: N duɔ́ kɛ̀ ti bo kupɑku nku kɛ boú yɛyobuo, kɛ̀ n kpɛri cómmú dɛ cuokɛ̀, kɛ̀ di kpɛyɛ dì cɛ̃̀ɛ̃̀tɛ kɛ nínkú di ììkɛ̀, kɛ̀ bɛ miɛkɛ dɔ̀kɛɛ ò pɛikɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kòo kó bɛkótíbɛ̀ dɔ̀: A yɛ̀mmɛ̀ dò nfɔ̃́ɔ̃̀ yóó ti bɑɑtɛ́, kɛ́nɑɑ́ nti kóo kpɑ̀ɑ̀tɑ̀ɑ̀? Kɛ̀ bɛ miɛkɛ dɔ̀kɛɛ ò pɛikɛ nɛ̀ ò yɑ̀u tìì dɔuǹtì kɛ bɛ̀ nɑ̀ɑ́ nti kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Kòo yíɛ́ duɔ́ tidɔuǹtì tɛtì, kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: N yɑ̀ tidɔuǹtì tɛtì nti. Diyiè nɛ̀ otɑ̃̀nkù nɛ̀ siwɑ̃̀ɑ̃ tɛpíítɛ̀ nɛ̀ tɛmɑ́ɑ̀ kɛ̀ dɛ̀ nìńkú n yììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kòo tì nɑ̀kɛ́ o cicɛ, kòo ò kpɑnnɛ̀ kɛ dɔ̀: Bɑ nkó tidɔuǹtì nti? A yɛ̀mmɛ̀ dò mmí nnɛ̀ ɑ yɔ̃ nɛ̀ ɑ kó bɛkótíbɛ̀ ti bo nínkú ɑ ììkɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kòo kó bɛkótíbɛ̀ miɛkɛ nhò pɛ́ì, kòo cicɛ yie mɛ ntoti o yɛ̀mmɛ̀ dɛ kó tidɔuǹtì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Diyiè mɑrì kɛ̀ Sosɛfu kó bɛkótíbɛ̀ɛ kɔtɛ Sisɛmmu kɛ́ncɛ̃mmú bɛ cicɛ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Kòo cicɛɛ ò yu, kɛ dɔ̀: M bo dɑ tɔ̃ nkɑ̀ɑ kɔtɛ Sisɛmmu kɛ́yɑ̀ ɑ kó bɛkótíbɛ̀ cɛ̃mmú dɛ̀ iwũɔ̃. Kòò dɔ̀: Ɛ̃ɛ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Kòo cicɛ dɔ̀: Kɔtɛ Sisɛmmu kɛ́yɑ̀ bɛ kɔ̃nnɑɑtí, kɛ́yɑ̀nɛ̀ iwũɔ̃, kɛ́wɛ̃tɛní kɛ́ n nɑ́kɛ́ dɛ̀ dòmmɛ̀. Kɛ̀ Sosɛfuu ítɛ́ Ebunɔɔ kɛ́kɔtɛ Sisɛmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Kɛ̀ òmɔùu ò yɑ̀ kòò ɑ̀rì dikpɑ́ɑ̀ miɛkɛ. Kɛ̀ dɛ yiɛ̀ nhò bekɛ kɛ dɔ̀: A wɑnti bɑ? ");
INSERT INTO tbzsim_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Kɛ̀ Sosɛfu dɔ̀: N wɑnti n kó bɛkótíbɛ̀ mbɛ, n nɑ́kɛ́ bɛ cɛ̃mmú dɛ̀ bɛ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Kɛ̀ dɛ kóo nìtìi ò nɑ̀kɛ́ kɛ dɔ̀: Bɛ̀ í kpɑɑ́ diɛ. N kèè kɛ̀ bɛ̀ tu bɛ̀ kɔ̀ri Dotɑ̃ɑ̃. Kɛ̀ Sosɛfuu kɔtɛ Dotɑ̃ɑ̃ kɛ́ bɛ̀ yɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kɛ̀ bɛ̀ɛ ò yɑ̀ní mɛdɛ́timɛ̀ kɛ́dɑkɛ kɛ bo ò kùɔ, ");
INSERT INTO tbzsim_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","kɛ́nnɑ́ɑ́ mbɛtɔbɛ̀ kɛ tú: Ntɛnɛ̀ tidɔuǹtì yiɛ̀ nkɛ kéríní. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Yóunɛ̀ kɛ̀ tí ò kùɔ kɛ́dootóo tɛbintɛ miɛkɛ, kɛ dɔ̀ musĩ̀mmù muù ò pĩ, nkɛ́yɑ̀ o dɔuǹtì yóó yĩ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kɛ̀ Dubɛnnii keè kɛ́yetɛ kɛ dɔ̀: Ti bɑ́ɑ́ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ãnnɛ́nɛ̀ we tɛbintɛ tiɛ mmiɛkɛ! Di bɑ́ɑ́ ò kùɔ. Ò do dɔ́ kóò dɛɛtɛ́mu kóò kpɛ̃nnɛ́ o cicɛ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Sosɛfu tùɔ̀koo dìì mɔ̀nnì o kó bɛkótíbɛ̀ borɛ̀, kɛ̀ bɛ̀ɛ ò pĩ nkɛ́dɑ́tɛ́ o yɑɑ̀bòrì sɑ̀ɑ̀rì iníɛkɛ kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Kóò dootóo tɛbintɛ miɛkɛ, dɛ kó tɛbintɛ do í ɑ̃ mɛniɛ mbɑ́ sɑ́m̀pɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Bɛ dèè mɛmmɛ kɛ́nkɑri kɛ yo nkɛ́yɑ̀ní Isimɑyɛɛribɛ kɛ̀ bɛ̀ boní Kɑdɑɑdi kɛ dekɛ yòyóbɛ̀ kɛ tɔ tihúúntì nɛ̀ mɛkùɔ̀ nnɛ̀ dɛtie nkɛ kɔri Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kɛ̀ Sudɑɑ dɔ̀: Ti yóó sɔri kɛ́kuɔ ti nɑntɛ̀ kɛ́yɑ̀ bɑ? ");
INSERT INTO tbzsim_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Tí ò fìtɛ́nɛ̀ Isimɑyɛɛribɛ ti bɑ́ɑ́ ò kùɔ, ò tu ti cĩ́ɛ̃̀tɛ̀ kou nwe, ti nɑntɛ̀, kɛ̀ ti wɛ̃ mmɛyĩ̀ĩ̀ mmɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Kɛ̀ bɛ̀ɛ yie nkóò dènnɛní tɛbintɛ kɛ́fítɛ́nɛ̀ Isimɑyɛɛribɛ mɛdítíbii nsipísìdɛ́ kɛ̀ bɛ̀ɛ ò kònnɛ̀ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Kɛ̀ Dubɛnni wɛ̃tɛní kɛ́síékɛ́ tɛbintɛ kɛ́nsɔ̃́ nSosɛfu í dɛ̀ kpɑɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Kòo yɛ̀mmɛ̀ɛ cɑɑ̀rɛ̀ kòo kɛ̃tɛ́ o yɑɑ̀bòrì, kɛ́wɛ̃tɛ o kɔbɛ borɛ̀ kɛ dɔ̀: Dɛbirɛ í dɛ̀ kpɑɑ́, n yóó yĩ́mɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Kɛ̀ bɛ̀ɛ kuɔ dibɔdɑɑ̀ kɛ́túótɛ́ Sosɛfu yɑɑ̀bòrì kɛ́tɛí mɛyĩ̀ĩ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","kɛ́ di duɔ́nko bɛ cicɛ kɛ dɔ̀: Ntɛ ti yɑ̀ dìì yɑɑ̀bòrì, wéntɛ́ kɛ́yɑ̀ ɑ birɛ kpɛri bɑ́ nni ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Kòo dì bɑntɛ́, kɛ dɔ̀: M birɛ yɑɑ̀bòrì ndi. Musĩ̀mmù mɑmù muù ò pĩ nkɛ cɑ̀ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kòo kɛ̃tɛ́ o yɑɑ̀bòrì kɛ́dɑ́ɑ́tí tifɔ̀ɔ̀tɔ̃̀ntì, kɛ́kɑri o birɛ kṹṹ nkɛ̀ dɛ̀ɛ mɔntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Kòo kó bɛdɑpɑ̀mbɛ̀ nɛ̀ o kó bɛsɑpɑ̀mbɛ̀ kɛ̀ bɛ̀ɛ ò bɑ̀ḿmú kòo yetɛ kɛ dɔ̀: N yó n kuɔ̀mmu m birɛ kɛ yɑ̀ɑ dɛ̀ sɔ̃̀ńtɛ́nko kudɔnkù, kɛ́nkuɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Kɛ̀ Isimɑyɛɛribɛɛ kɔtɛ kɛ́fítɛ́nɛ̀ Sosɛfu Potifɑɑ, bɛhɑ̃ɑ̃pɔ̀mbɛ̀ bɛ̀ɛ̀ bɑɑ̀ Esibiti kóo kpɑ̀ɑ̀tì bɛ kóo kótì. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Dɛ mɔ̀nnì kɛ̀ Sudɑɑ ítɛ́ o tebìí borɛ̀ kɛ́kɔtɛ Adudɑmmu Idɑɑ borɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","kɛ́yɑ̀ osɑpɑ̀ɑ̀ mmɔù, Kɑnnɑhɑ̃ɑ̃ kou bɛ̀ tu wè Suɑɑ birɛ kóò tùótɛ́ kɛ́puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kòo púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ kòò dɛ̀ yu kɛ dɔ̀ Ɛɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","kɛ́yíɛ́ kɛ́púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ kɛ́ dɛ̀ yú kɛ dɔ̀ Onɑɑ, ");
INSERT INTO tbzsim_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","kɛ́yíɛ́ kɛ́púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ kɛ́ dɛ̀ yu kɛ dɔ̀ Sedɑɑ. Ò do bo Kesibu nwe kóò pɛitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Kɛ̀ Sudɑɑ túótɛ́ onitipòkù bɛ̀ tu wè Tɑmɑɑ kóò puo nho kóò Po Ɛɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kɛ̀ Ɛɛ ndɔɔri dɛ̀ɛ̀ í wenni ti Yiɛ̀ nKuyie nkɛ̀ kùu ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kɛ̀ Sudɑɑ nɑ́kɛ́ Onɑɑ kɛ dɔ̀: Túótɛ́ ɑ kóo kótì pokù, kòo piɛ́ ibí kɛ̀ ìi sɔɔtɛ́ ɑ kóo kótì cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kɛ̀ Onɑɑ nyɛ̃́ kɛ dò nweè í yó nte ibí, kɛ níí ò duɔ́nɛ̀ kɛ́dɛitɛ kɛ́yɛ̃nkɛ kɛtenkɛ̀, kòo bɑ́ɑ́ pɛitɛ́ ibí o kóo kótì. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Kɛ̀ dɛ kó mɛdɔɔ̀rìmɛ̀ɛ yonkɛ ti Yiɛ̀ nKuyie nkɛ̀ kù múnkɛɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Kɛ̀ Sudɑɑ nɑ́kɛ́ o cɔ̀kù Tɑmɑɑ kɛ dɔ̀: Kò nhɑ cicɛ borɛ̀ kɛ́mbɑɑ̀ Sedɑɑ bo kótɛ́mɛ̀. Ò do yĩɛ̃̀kù Sedɑɑ bo kúmɛ̀ mmɛ o kó bɛkótíbɛ̀ kɔ̃mɛ. Kɛ̀ Tɑmɑɑ kò nho cicɛ cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Kɛ̀ dɛ̀ɛ mɔntɛ kɛ̀ Sudɑɑ pokù Suɑɑ birɛɛ kú, kòo kɑri mukṹṹ nkɛ́deè. Nɛ̀ o nɛ́po Idɑɑ Adudɑmmu kɛ̀ bɛ̀ɛ kɔtɛ Timunɑ kɛ bo yɑ̀ bɛ̀ kɛ̃ĩ dɛ̀ o pe cìtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Kɛ̀ Tɑmɑɑ keè o cɔ̀kù kɔ̀rimɛ̀ Timunɑ o pe cìtì kɛ̃ĩ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","kɛ́dɛitɛ tikúpoyɑ̀ɑ̀tì kɛ́dɑ́tínnɛ́ o ììkɛ̀ kuyɑ̀ɑ̀kù, kɛ́kɔtɛ kɛ́nkɑri Enɑimmu ɛì mɑ̀nku, Timunɑ kó kucɛ kɛ yɛ̃́ ò do yɑ̀mɛ̀ Sedɑɑ kòtɛ́mɛ̀ bɑ́ bɛ̀ í wè nhò duɔ́ nkòò bo ò yenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Kɛ̀ Sudɑɑ ò yɑ̀ kɛ́nyɛ̃́ kɛ tú onitipòkù wèè dɔuti dɔutinɛ̀ wènwe bɛnitidɑɑbɛ̀, kɛ yɛ̃́ ò dɑ̀ɑ́tímɛ̀ o ììkɛ̀ kuyɑ̀ɑ̀kù. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Sudɑɑ í nyɛ̃́ kɛ dò nho cɔ̀kù nwe, kɛ́kétóo o borɛ̀ kɛ dɔ̀: Yóu kɛ̀ n dɑ duɔ́nɛ̀. Kòò dɔ̀: Kɑ̀ɑ ǹ duɔ́nɛ̀ ɑ bo n duɔ́ mbɑ? ");
INSERT INTO tbzsim_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Kòò dɔ̀: M bo dɑ duɔ́ ndibɔbii. Kòo nitipòkù dɔ̀: Ɛ̃ɛ̃, ɑ́ nɛ́ dɔú nhɑ kpɛrɛ mɑrɛ̀, kɑ̀ɑ duɔnní dìì mɔ̀nnì dibɔbii ɑ́ dɛ̀ tùótɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Kòò dɔ̀: N yóó dɑ duɔ́ mbɑ? Kòò dɔ̀: A cɑnnimɛ̀ nɛ̀ ɑ ɔ̃ũ nɛ̀ ɑ pɑ̀ɑ̀ti. Kòo dɛ̀ nhò duɔ́, kóò duɔ́nɛ̀, kòo púó, ");
INSERT INTO tbzsim_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","kɛ́ítɛ́ kɛ́kò nkɛ́dɑ́tɛ́ kuyɑ̀ɑ̀kù kɛ́dɑ́ɑ́tí tikúpoyɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Kɛ̀ Sudɑɑ tɔ̃nnɛ̀nní tɛbuɔtɛ̀ o nɛ́po Idɑɑ Adudɑmmu kou kòò bo cɔutóo o nɛntì, bɑ́ wè í nhò yɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","kɛ́bekɛ dɛborɛ̀ kɔbɛ kɛ dɔ̀: Yé onitipòkù wèè dɔuti dɔutinɛ̀ bɛnitidɑɑbɛ̀, kɛ ɔ̃ nkɑrì diɛ? Kɛ̀ bɛ̀ dɔ̀: Onitipòkù mɔù í buotɛ́ diɛ ndiyiè mɑrì kɛ dɔuti dɔutinɛ̀ bɛnitidɑɑbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kòo wɛ̃tɛ kɛ́nɑ́kɛ́ Sudɑɑ kɛ dɔ̀: N yí ò yɑ̀, kɛ̀ bɛ̀ɛ̀ dɛ̀ bo kɛ̀ bɛ̀ tu onitipòkù mɔù ketɛ́ kɛ í dɛ̀ buotɛ́ diyiè mɑrì kɛ dɔuti dɔutinɛ̀ bɛnitidɑɑbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Kɛ̀ Sudɑɑ dɔ̀: Wèe kɔtɛnɛ̀ tinɛntì, ti bɑ́ɑ́ yóu kɛ̀ bɛ̀ ti dɑɑ́, n dɑ duɔ́mmu tɛbuɔtɛ̀ kɑ̀ɑ kɔ̀tɛ koò mɔ̀ńtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kɛ̀ dɛ̀ mmɔkɛ bɛtɑ̃̀ɑ̃̀bɛ̀ bɛ̀tɑ̃ɑ̃ti, kɛ̀ bɛ̀ɛ nɑ́kɛ́ Sudɑɑ kɛ dɔ̀: A cɔ̀kù dɔuti dɔutinɛ̀ bɛnitidɑɑbɛ̀ mbɛ kɛ pùó. Kòò dɔ̀: Dennɛnní we kóò cɔ́u. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kɛ̀ bɛ̀ɛ ò dènnɛnní, kòo tɔ̃ nkɛ̀ bɛ̀ɛ nɑ́kɛ́ o cɔ̀kù Sudɑɑ kɛ dɔ̀: N dɑ bɑ́ɑ́mmu, bɑntɛ́ wèè te mɛcɑnnimɛ̀ miɛ nnɛ̀ kuhɔ̃ũ nɛ̀ ku mpɑ̀ɑ̀ti, weè m̀ pòńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Kɛ̀ Sudɑɑ bɑntɛ́ tinɛntì, kɛ́bɛ́i nkɛ́ dɔ̀: Ò tũ̀nnɛmu ikuɔ́ kɛ m pɛ̃ɛ̃tɛ́, n do dò nkóò duɔ́mmu n kóo dɑpɑ̀ɑ̀ nSedɑɑ kòo yenkɛ, m mɛ̀ nyí wè nhò duɔ́. Sudɑɑ tɛ̃́nkɛ í nhò duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Kòò nyóó pɛitɛ́, kɛ́pɛitɛ́ itɑ́ɑ́tɛ́bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kɛ̀ dɛketirɛ̀ɛ dennɛní dɛ bɑkù, wèè pɛinko kòo dɛ̀ ũ̀ńnɛ́ mupɑ̀ɑ̀konwũɔ̃́ nkɛ dɔ̀: Diɛ ndɛɛ̀ tu dɛketirɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kɛ̀ dɛ̀ɛ wɛ̃tɛ kɛ́tɛ̃́nnɔ́ɔ dɛ bɑkù, kɛ̀ dɛtɛrɛ̀ɛ yɛ̀nní. Kɛ̀ Sudɑɑ dɛ̀ yu kɛ dɔ̀ Pedɛsi (dɛ̀ɛ̀ tu Okpetíwè). ");
INSERT INTO tbzsim_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Dɛ kó difɔ̃nkúò kɛ̀ bɛ̀ do ũ̀ńnɛ́ dɛ̀ mupɑ̀ɑ̀konwũɔ̃́ nkɛ̀ dɛ̀ɛ yɛ̀nní, kɛ̀ bɛ̀ɛ dɛ̀ yu kɛ dɔ̀ Sedɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Kɛ̀ Isimɑyɛɛribɛɛ kɔtɛnɛ̀ Sosɛfu Esibiti, kóò fìtɛ́nɛ̀ Potifɑɑ, Esibiti ɛì kou. Potifɑɑ do tu tɛkpɑ̀ɑ̀tìcĩ́ɛ̃̀tɛ̀ kóo kótì nwe kɛ bɑkɛ́ tihɑ̃ɑ̃pɔ̀ntì tìì Esibiti kóo kpɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Kɛ̀ ti Yiɛ̀ nKuyie nni mbonɛ̀ Sosɛfu, kòò dɔ̀ɔ̀ dɛ̀, dɛ̀ɛ yie, kòò ḿbo o yiɛ̀ ncĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Kòo yiɛ̀ Potifɑɑ yɑ̀ ti Yiɛ̀ nKuyie nhò bonɛ̀mɛ̀ kòò dɔ̀ɔ̀ri dɛ̀ dɛmɔu yíé, ");
INSERT INTO tbzsim_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","kóò pɛ́nsìrì kóò duɔ́ mmutɔ̃mmú o cĩ́ɛ̃̀tɛ̀ kóò bɑ̀nnɛ o kpɛrɛ dɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Nɛ̀ Sosɛfu kpɛ́í nkɛ̀ ti Yiɛ̀ nKuyie ndɔ̀ɔ̀ Potifɑɑ mɛsɑ̀ɑ̀, kòò kpɛrɛ dɛmɔu nɛ̀ o pɑɑ nkɛ̀ dɛ̀ nyíé. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kɛ̀ Potifɑɑ túótɛ́ o kpɛrɛ dɛmɔu kɛ́ dɛ̀ bɑ̀nnɛ Sosɛfu, ò tɛ̃́nkɛ í ndɔɔri mùmɑmù kɛ̀ dɛ̀ í tú ò bo dimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Sosɛfu do tú fɛdɑduonfɛ nfɛ kɛ tú odɑsɑ́ɑ́tì, kɛ̀ Potifɑɑ pokùu ò pɛ́nsìrì kóò nɑ̀kɛ́ diyiè mɑrì kɛ dɔ̀: N duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kɛ̀ Sosɛfuu yetɛ, kɛ́nɑ́kɛ́ onitipòkù kɛ dɔ̀: N yiɛ̀ nni nyɑ́rímu, kɛ n nií mmutɔ̃mmú mumɔu tɛcĩ́ɛ̃̀tɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ò í dɛu kɛ m pɛ̃ɛ̃tɛ́ tɛcĩ́ɛ̃̀tɛ̀ tiɛ mmiɛkɛ. Ò í n yetɛnɛ̀ dɛ̀mɑrɛ̀ kɛ̀ dɛ̀ í tú fɔ̃́, kɛ yɛ̃́ ɑ túmɛ̀ o pokù. Dɛ̀ bo yĩ́mɛ kɛ̀ n dɔɔ̀ mɛyɛi ndiɛmɛ̀ miɛ nkɛ́yetɛ́nɛ̀ Kuyie? ");
INSERT INTO tbzsim_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Kòo nnɑ́ɑ́nnɛ̀ Sosɛfu yɛwe yɛmɔu kɛ tú wèe ò duɔ́nɛ̀, kɛ̀ Sosɛfu yetírí. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Diyiè mɑrì kɛ̀ Sosɛfuu tɑ tɛcĩ́ɛ̃̀tɛ̀, kɛ bo pĩ́ mmutɔ̃mmú kɛ sɔ̃́ nhotɔ̃ntì mɔù í bo tɛcĩ́ɛ̃̀tɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Kɛ̀ Potifɑɑ pokùu pĩ́ nho yɑɑ̀bòrì, kɛ dɔ̀: N duɔ́nɛ̀. Kɛ̀ Sosɛfuu yóu o yɑɑ̀bòrì kɛ́cokɛ́ kɛ́yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Kòo nitipòkùu yɑ̀ ò yóumɛ̀ o yɑɑ̀bòrì, kɛ cokɛ́ kɛ yɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","kɛ́yú bɛtɔ̃mbɛ̀ kɛ dɔ̀: Wéntɛ́nɛ̀ n dɔù tɔní Ebedeebɛ botí kou wè kòò ti dɑú, ò kɔ̀tɛní kɛ bo n duɔ́nɛ̀mu, kɛ̀ m mɛ nkuɔ́nko, ");
INSERT INTO tbzsim_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","kòò cokɛ́ kɛ yɛ̀ kɛ yóu o yɑɑ̀bòrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Kòo nitipòkùu dɔú ndɛ kó diyɑɑ̀bòrì kɛ́mbɑɑ̀ o dɔù bo konnímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Kòo konní kòò mɛ nhò nɑ̀kɛ́ kɛ dɔ̀: Ebedeebɛ botí kó kudɑɑkù ɑ tɔní kù, kuù kɔ̀tɛní m borɛ̀ kɛ bo m pĩ́ nkɛ́duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Kɛ̀ n kuɔ́nko kɛ̀ kù yóu ku yɑɑ̀bòrì kɛ cokɛ́ kɛ yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Kòo dɔùu keè dɛ kó tinɑ́ɑǹtì, kɛ̀ dɛ̀ɛ ò yonkɛ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Kòò duɔ́ nkɛ̀ bɛ̀ɛ pĩ́ nSosɛfu kɛ́kpetínnɛ́ bɛ̀ kpetì dɛ̀ bɛkpɑ̀ɑ̀tìbɛ̀ kó tikpetíntì. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kɛ̀ ti Yiɛ̀ nKuyie nní mbonɛ̀ Sosɛfu kóò dɔ̀ɔ̀ mɛsɑ̀ɑ̀, kɛ̀ kuhɑ̃ɑ̃pɔ̀nkù kùù bɛ̀ bɑ̀ɑ̀ kɛ̀ kùu ò pɛ́nsìrì, ");
INSERT INTO tbzsim_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","kɛ́duɔ́ nkòo mbɑkɛ́ tikpetíntì timɔu dikpetíntou miɛkɛ. Dɛ̀mɑrɛ̀ do ɔ̃ɔ̃ í ndɔ̀ɔ̀ kɛ̀ Sosɛfu í yɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kuhɑ̃ɑ̃pɔ̀nkù kùù bɑɑ tikpetíntì kɛ̀ kùu ò yóu kòò ndɔɔri ò dɔ́mɛ̀, kɛ yɛ̃́ ti Yiɛ̀ nKuyie ndo bonɛ̀mɛ̀ Sosɛfu kòo tɔ̃mmú kérí. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Wèè bɑkɛ́ Esibiti kóo kpɑ̀ɑ̀tì nɑɑ̀kɔ̀tìbɛ̀ nɛ̀ wèè bɑkɛ́ bɛ̀ɛ̀ dɔ̀ɔ̀ri pɛ̃́ɛ̃̀bɛ̀, kɛ̀ bɛ̀ɛ cɑɑ̀rɛ̀ okpɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Kòo kpɑ̀ɑ̀tì miɛkɛɛ pɛikɛ tɛkpɑ̀ɑ̀tìcĩ́ɛ̃̀tɛ̀ kó bɛkótíbɛ̀ bɛmbɛ bɛdɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","kòo bɛ̀ kpetínnɛ́, wèè ni bɛ̀ɛ̀ bɑ̀ɑ tikpetíntì o kó dikpetíntou, Sosɛfu kpetí dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Kɛ̀ bɛ̀ɛ̀ bɑ̀ɑ tikpetíntì bɛ kóo kótìi bɛ̀ duɔ́ nSosɛfu, kɛ̀ bɛ̀ ḿbo dikpetíntou yɛmɔ̀rɛ̀ mɑyɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Kɛyènkɛ̀ mɑkɛ̀, kɛ̀ wèè bɑkɛ́ okpɑ̀ɑ̀tì nɑɑ̀kɔ̀tìbɛ̀ nɛ̀ wèè bɑkɛ́ pɛ̃́ɛ̃̀ dɔɔ̀rìbɛ̀, kɛ̀ bɛ̀ɛ yɑ̀ tidɔuǹtì, bɑ́ wè kòo kpɛti ncɑ̃́ɑ̃́ ntì dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Sosɛfuu bɛ̀ yɑ̀ kɛ sɔ̃́ mbɛ ììkɛ̀ sɔ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kòo bɛ̀ bekɛ kɛ dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di ììkɛ̀ sɔ̀ù yíe mmiɛ mbotí? ");
INSERT INTO tbzsim_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Kɛ̀ bɛ̀ dɔ̀: Ti yɑ̀ tidɔuǹtì nti, òmɔù mɛ nyí bo diɛ nwèè bo ti nɑ́kɛ́ tì tu mù. Kɛ̀ Sosɛfu dɔ̀: Kuyie mbo nɑ kɛ́ di nɑ́kɛ́ tì tu mù. Di nɛ́ tì nni nnɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Wèè bɑkɛ́ bɛnɑɑkɔ̀tìbɛ̀ kòò dɔ̀: N duɔ́ kɛ yɑ̀ fínyĩ̀ kó mutie mmu kɛ̀ mù cómmú n yììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Kɛ mɔkɛ ibɑkɛ ìtɑ̃ɑ̃ti, kɛ pòrí, kɛ pɛitɛ́ yɛbɛ kɛ̀ yɛ̀ bi. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Kɛ̀ ǹ tɔ okpɑ̀ɑ̀tì bòòfɛ̀ kɛ tɔ̃ũ yɛbɛ kɛ niu fɛ miɛkɛ koò duɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Kɛ̀ Sosɛfu dɔ̀: Ntɛ ɑ kó tidɔuǹtì tu mù: Ibɑkɛ itɑ̃ɑ̃ti tú yɛwe yɛ̀tɑ̃ɑ̃ti ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Yɛwe yɛ̀tɑ̃ɑ̃ti kó difɔ̃nkúò okpɑ̀ɑ̀tì bo dɑ kpetɛ́ kɛ́wɛ̃tɛ kɛ́ dɑ cónnɛ́ ɑ fɔ̃̀tìrì, kɑ̀ɑ nhò duɔ̀ mmɛnɑɑ̀ nhɑ sòò dɔ̀ɔ̀rimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","A nɛ́ nyɛ̃́ n kpɛ́í nhɑ bo di dìì mɔ̀nnì diwɛ̀ì, n dɑ bɑ́ɑ́mmu ɑ́ n dɔɔ̀ mɛsɑ̀ɑ̀ nkɛ́nɑ́kɛ́ okpɑ̀ɑ̀tì n kpɛ́í, kɛ́ n dennɛ dikpetíntou. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Bɛ̀ ǹ dɛ̀ìtɛní nɛ̀ muwɛ̃rímú mmu Ebedeebɛ tenkɛ̀ kɛ n tɔní diɛ. Bɑ́ bɛ̀ mɛ nni nkpetímɛ̀ n yí cɑ̀ɑ̀rɛ̀ mùmɑmù. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wèè bɑkɛ́ pɛ̃́ɛ̃̀ dɔɔ̀rìbɛ̀ kòo yɑ̀ Sosɛfu nɑ̀kɛ́mɛ̀ otɔù kó tidɔuǹtì kɛ̀ dɛ̀ wenni, kɛ dɔ̀: N duɔ́nɛ̀ tidɔuǹtì kɛ tɔ titòtòòtì tìtɑ̃ɑ̃ti ndi, kɛ̀ pɛ̃́ɛ̃̀bɛ̀ ɑ̃ dɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kutòtòkù kùù sɔkɛ́ dɛĩ́nkɛ̀ kɛ̀ kù pìɛ́kɛ́ pɛ̃́ɛ̃̀bɛ̀ bɛbotí bɛbotí okpɑ̀ɑ̀tì nɔnnɛ̀ bɛ̀, kɛ̀ tinɔ̀tì kɔ̀rìní kɛ bɛ̀ sɛ̃ĩ n yuu ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Kɛ̀ Sosɛfu dɔ̀: Ntɛ ɑ kó tidɔuǹtì tu mù: Titòtòòtì tìtɑ̃ɑ̃ti tú yɛwe yɛ̀tɑ̃ɑ̃ti ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Yɛwe yɛ̀tɑ̃ɑ̃ti kó difɔ̃nkúò okpɑ̀ɑ̀tì bo dɑ féútɛ́, kɛ́ dɑ sɑɑ mmutie kɛ̀ tinɔ̀tì dɑ cɔ. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Diyiè tɑ̃ɑ̃́nnì yiè kòo kpɑ̀ɑ̀tìi ɑ̃nnɛ́ o pɛitɛ́yiè kó dibɑnni kɛ́yú o kó bɛtũ̀mbɛ̀, kɛ́kpetɛ́ wèè bɑkɛ́ bɛnɑɑkɔ̀tìbɛ̀ nɛ̀ wèè bɑkɛ́ pɛ̃́ɛ̃̀ dɔɔ̀rìbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","kɛ́wɛ̃tɛ kɛ́cónnɛ́ wèè bɑkɛ́ bɛnɑɑkɔ̀tìbɛ̀ o fɔ̃̀tìrì, kòo nhò duɔ̀ mmɛnɑɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","kɛ́féútɛ́ wèè bɑkɛ́ pɛ̃́ɛ̃̀ dɔɔ̀rìbɛ̀ kɛ́sɑɑ mmutie, kɛ̀ dɛ̀ɛ dɔ̀ɔ̀ Sosɛfu nɑ̀kɛ́mɛ̀ dɛ kó tidɔuǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Wèè bɑkɛ́ bɛnɑɑkɔ̀tìbɛ̀ kòo yɛ̃̀ nSosɛfu kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Kɛ̀ dɛ̀ mmɔkɛ yɛbie nyɛ̀dɛ́ɛ̀, kòo kpɑ̀ɑ̀tìi duɔ́ kɛ́yɑ̀ tidɔuǹtì kɛ bo kukó ndiɛkù Niidi tɑkɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","kɛ yɑ̀ inɑ̀ɑ̀kɛ ìyiekɛ̀ kɛ̀ ì wenni kɛ ɑ̃ mɛkùɔ̀, kɛ yɛ̀nní kukó nkɛ diiti timútì. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Kɛ̀ itɛì ìyiekɛ̀ ìì í wenni fɛnɔ̀nfɛ̀ kɛ kũ̀ɔ̃ mmɛdiɛ̀ nkɛ̀ ìi yɛ̀nní kɛ́sɔ̃́ntóo itɛì kukó mbɛ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Kɛ̀ ìì í wenni kɛ kũ̀ɔ̃ nkɛ̀ ìi cɑ́ɑ́kɛ́ ìì wenni kɛ ɑ̃ mɛkùɔ̀. Kòo entɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Kòo kpɑ̀ɑ̀tìi wɛ̃tɛ kɛ́duɔ́ kɛ́yɑ̀ kuyòùkù kùmɑ́ɑ̀ kɛ̀ kù òtɛ tiyòùtì tìyiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Kɛ̀ kuyòùkù tɛkù òtɛ tiyòùtì tìyiekɛ̀ tìì pɔɔ̀, kɛ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó kuyɑɑkù tì potɛ́ kɛ̀ tì mɔ̀tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kɛ̀ tìi mɑɑ́nko titɛtì tìyiekɛ̀ tìì wenni kɛ ɑ̃ mɛbii. Kòo entɛní kɛ́ nsɔ̃́ ntidɔuǹtì nti. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kɛ̀ dɛ̀ɛ ò di, kɛ̀ dɛ̀ɛ wentɛ́ kòo yú Esibiti ɛì kó bɛnitinɔ̀mbɛ̀ nɛ̀ mɛciì nyɛmbɛ̀, kɛ́ bɛ̀ nɑ̀kɛ́ o dɔuǹtì. Òmɔù mɛ nyí nnɑ kóò nɑ̀kɛ́ dɛ kó tidɔuǹtì tu mù. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Kɛ̀ bɛnɑɑkɔ̀tìbɛ̀ kóo kótìi bɛ́i nkɛ dɔ̀: Okpɑ̀ɑ̀tì n dèntɛní ti do dɑ cɑ̀ɑ̀rɛ̀mɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","kɑ̀ɑ miɛkɛɛ ti pɛikɛ mí nnɛ̀ pɛ̃́ɛ̃̀ dɔɔ̀rìbɛ̀ kóo kótì, kɑ̀ɑ ti kpetínnɛ́ wèè bɑkɛ́ tikpetíntì o kó dikpetíntou. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Kɛ̀ tí yɑ̀ tidɔuǹtì kɛyènkɛ̀ kɛ̀mɑ́ɑ̀ bɑ́ wè kòo kpɛti ncɑ̃́ɑ̃́ ntì bɛnkú mù. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Kɛ sɔ̃́ nhodɑpɑ̀ɑ̀ mmɔù dɛ̀ bo, kɛ tú Ebedeebɛ botí kou, wèè bɑkɛ́ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ o kó kudɑɑkù. Kɛ̀ tí ò nɑ̀kɛ́ dɛ kó tidɔuǹtì, kòo nɑ́kɛ́ bɑ́ tì tì tu mù. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Kɛ̀ dɛ̀ɛ dɔɔ̀ kɛ́ndò nhò ti nɑ̀kɛ́mɛ̀ kɛ̀ bɛ̀ɛ wɛ̃tɛ kɛ́ n cónnɛ́ n fɔ̃̀tìrì, kɛ́kuɔ otɔù. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Mɛm̀mɛ, kɛ̀ Esibiti kóo kpɑ̀ɑ̀tìi duɔ́ nkɛ̀ bɛ̀ɛ kɔtɛ mɛcɑ̃ɑ̃ nkɛ́dennɛní Sosɛfu dikpetíntou, kóò kuó, kóò cèètɛ tiyɑ̀ɑ̀tì, kóò kɔ̀tɛnɛ̀ okpɑ̀ɑ̀tì borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Kòo kpɑ̀ɑ̀tì dɔ̀: N yɑ̀ tidɔuǹtì mɑtì nti, òmɔù mɛ nyí nɑ kɛ n nɑ̀kɛ́ tì tu mù. Kɛ̀ n kèè kɛ̀ bɛ̀ tu, kɛ̀ bɛ̀ dɑ nɑ̀kɛ́ tidɔuǹtì ɑ ɔ̃ɔ̃ nɑ́kɛ́mu tì tu mù. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Kɛ̀ Sosɛfu dɔ̀: Míì í yóó dɑ nɑ́kɛ́, Kuyie nkuù yóó dɑ nɑ́kɛ́ ɑ dɔuǹtì tu mù. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kòo kpɑ̀ɑ̀tì dɔ̀: N yɑ̀ tidɔuǹtì nti kɛ bo kukó ndiɛkù Niidi tɑkɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","kɛ yɑ̀ inɑ̀ɑ̀kɛ ìyiekɛ̀ kɛ̀ ì wenni kɛ ɑ̃ tikɔ̃̀ntì kɛ̀ ì yɛ̀nní kɛ diiti timútì. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Kɛ̀ itɛì ìyiekɛ̀ ìì í wenni fɛnɔ̀nfɛ̀ kɛ kũɔ̃nnì kɛ̀ ì yɛ̀nní, m mu nyí yɑ̀ dɛ kó inɑ̀ɑ̀kɛ botí Esibiti miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kɛ̀ ìì í wenni fɛnɔ̀nfɛ̀ kɛ kũɔ̃ nkɛ̀ ì cɑ̀ɑ́kɛ́ iketiyì ìì wenni kɛ ɑ̃ mɛkùɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kɛ bɑɑ ndò nyì do dòmmɛ̀ kɛ kũɔ̃nnì, mɛm̀mɛ kɛ̀ ǹh entɛní. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Kɛ̀ n wɛ̃tɛ kɛ́yɑ̀ tidɔuǹtì tɛtì kɛ̀ kuyòùkù kùmɑ́ɑ̀ òtɛ tiyòùtì tìyiekɛ̀, kɛ̀ tì ɑ̃ mɛbii nkɛ wenni. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Kɛ̀ kutɛkùu yɛ̀nní kɛ́otɛ tiyòùtì tìyiekɛ̀ tìì pɔɔ̀ kɛ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó kuyɑɑkù tì potɛ́ kɛ̀ tì mɔ̀tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Tìì mɛ mpɔɔ̀ kɛ̀ tìi mɑɑnko titɛtì tìyiekɛ̀ tìì wenni kɛ ɑ̃ mɛbii. Kɛ̀ n tì nɑ̀kɛ́ bɛnitinɔ̀mbɛ̀, òmɔù mɛ nyí nɑ kɛ n nɑ̀kɛ́ tì tu mù. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kɛ̀ Sosɛfuu nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Dɛ kó tidɔuǹtì wɛ̃ ntì tu mù mmu. Kuyie nkuù dɑ bɛnkɛ kù yóó dɔɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Inɑ̀ɑ̀kɛ ìyiekɛ̀ ìì wenni nɛ̀ tiyòùtì tìyiekɛ̀ tìì wenni dɛ̀ tu yɛbie nyɛ̀yiekɛ̀ ndi, tidɔuǹtì tìmɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Kɛ̀ inɑ̀ɑ̀kɛ ìyiekɛ̀ ìì í wenni fɛnɔ̀nfɛ̀ kɛ kũɔ̃nnì, nɛ̀ tiyòùtì tìyiekɛ̀ tìì pɔɔ̀, kɛ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó kuyɑɑkù ti potɛ́ kɛ̀ tì mɔ̀tɛ́, dɛ̀ tu yɛbie nyɛ̀yiekɛ̀ nyɛ, dikònnì kpɛyɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","M mɛ ndɑ nɑ̀kɛ́ tì, Kuyie nkuù dɑ bɛnkɛ kù yóó dɔɔ̀ tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Yɛbie nyɛ̀yiekɛ̀ yó ntú tidiitì kpɛyɛ nyɛ Esibiti kó kɛtenkɛ̀ kɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Dɛ kó difɔ̃nkúò kɛ̀ yɛbie nyɛ̀yiekɛ̀, dikònnì kpɛyɛɛ tũnnɛní kɛ́fɛ̃́ũ mbɛnìtìbɛ̀, kɛ̀ bɛ̀ɛ yɛ̃̀ nyɛ̀ɛ̀ do mɔkɛ tidiitì yɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Dɛ kó dikònnì bo ndɛu mɛdiɛ̀, bɛ̀ tɛ̃́nkɛ bɑ́ nyɛ̃́ kɛ dò ntidiitì do bo. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","A yɑ̀ dɛ kó tidɔuǹtì kucɛ mɛ̀dɛ́mɛ̀ kɛ̀ dɛ̀ bo bɛnkɛ kɛ dò nKuyie nkuù dɔ́ kɛ́ dɛ̀ dɔ̀ɔ̀, kù mɛ nyí yóó ɔɔtɛ kù bo dɛ̀ dɔ̀ɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Okpɑ̀ɑ̀tì bɑ̀mbɑ̀ mmiɛ nhɑ́ yɑ̀ onìtì wèè ciì, kóò nií nhEsibiti tenkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","kɛ́wɑɑ́ mbɛnìtìbɛ̀ dɛ kó yɛbie nyɛ̀yiekɛ̀ tidiitì kpɛyɛ miɛkɛ, kɛ̀ bɛ̀ níí kɔ̃ṹ tidiitì kɛ̀ tiyɔ̀tì bo tìnùmmù bɛ̀ɛ dɛitɛ kùmɑ́ɑ̀ kɛ́cɑ̃́nnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Duɔ́ nkɛ̀ bɛ̀ɛ wɑɑ́ ntidiitì tibotí tibotí dɛ kó yɛbie nsɑ̀ɑ̀yɛ̀ miɛkɛ kɛ́ɑ̃nnɛ́ yɛbuɔ, kɑ̀ɑ ndɑkɛ dɛ kpɛ́í nkɛ̀ bɛ̀ ntì bɑ̀ɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Kɛ̀ dɛ kó tidiitì ḿbo, kɛ̀ yɛbie nyɛ̀yiekɛ̀ dikònnì kpɛyɛ tùɔ̀kɛní dì bɑ́ɑ́ kuɔ bɛnìtìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Dɛ mɔ̀nnì okpɑ̀ɑ̀tì nɛ̀ o tũ̀mbɛ̀ kɛ̀ bɛ̀ɛ pɛ́nsìrì dɛ kó tinɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Kòo kpɑ̀ɑ̀tì dɔ̀: Ti bɑ́ɑ́ pɛ́tɛ́ onìtì mɔù wèè dònnɛ̀ yie, kɛ̀ Kuyie nYɑɑ́ nhò pìɛ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mɛm̀mɛ ò nɑ̀kɛ́mɛ̀ Sosɛfu kɛ dɔ̀: Kuyie mmɛ̀ ndɑ bɛnkɛmɛ̀ dɛmɔu, òmɔù í bo wèè mɔ̀kɛ mɛyɛ̀mmɛ̀ kɛ ciì kɛ dɑ dònnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Fɔ̃́ɔ̃̀ yó mbɑkɛ́ nh ɛì dimɔu, kɛ̀ bɛnìtìbɛ̀ bɛmɔu nyíé nhɑ kpɛti, n kpɑ̀ɑ̀tì yètìrì diì mɑ́ɑ̀ yó nte kɛ̀ nni ndɑ dɛunɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","N dɑ duɔ́mmu muwɛ̃rímú, kɑ̀ɑ bo mbɑkɛ́ Esibiti omɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kòo kpɑ̀ɑ̀tìi ṹtɛ́ mukpɑ̀ɑ̀tìmɑ́mɑ́ɑ́ nho nɔ̀ùtɛ̀ kɛ́ṹnnɛ́ Sosɛfu, kóò dɑ̀tínnɛ́ tiyɑɑ̀kpetì, kóò dùú mmɛsɔɔfĩmmɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","kóò dèe ntɛkpɑ̀rìsɑ̃ntɛ̀ kɛ̀ tɛ̀ ntũ nho kpɛtɛ, kɛ̀ bɛnìtìbɛ̀ pĩɛ̃kù kɛ tú: Ǹninkunɛ̀. Mɛm̀mɛ okpɑ̀ɑ̀tì duɔ́mmɛ̀ Sosɛfu muwɛ̃rímú kòo bɑɑtɛ́ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Kòo kpɑ̀ɑ̀tìi nɑ́kɛ́ Sosɛfu kɛ dɔ̀: Míì tu Esibiti kóo kpɑ̀ɑ̀tì, òmɔù bɑ́ɑ́ dɔɔ̀ tìmɑtì Esibiti miɛkɛ kɑ̀ɑ í duɔ́ ndinùù. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Kòo kpɑ̀ɑ̀tìi yú Sosɛfu Esibiti kó diyètìrì kɛ dɔ̀ Sɑfidɑti-Pɛnnɛɑ, kóò puó Asenɑti dihɛì kóo kótì Potifedɑɑ, Onni ɛì kó ikuɔ́ nìùtì kóo sɑpɑ̀ɑ̀. Sosɛfu do yóó tũnnɛ okpɑ̀ɑ̀tì kɛ mɔkɛ yɛbie nsipísìtɑ̃ɑ̃ti ndi, kɛ́ítɛ́ kɛ́ce nhEsibiti kó dihɛì dimɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Yɛbie nyɛ̀yiekɛ̀ tidiitì kpɛyɛ miɛkɛ kɛ̀ tidiitìi piɛ́ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Kɛ̀ Sosɛfuu cuɔ́ tidiitì dɛpɑɑ nkɛ́cũɔ̃́ yɛbuɔ yɛhɛkɛ̀ diɛyɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Kɛ̀ Sosɛfuu koú kɛ́koú tidiitì kɛ̀ dɛ̀ nsũ kɛ́ndò ndɑ̀mɛ́ɛ̀rì nùù kó mubirímú kɛ̀ bɛ̀ɛ yĩɛ̃kɛ bɛ̀ bo nkɑɑ̀mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Kɛ̀ dikònnì kó yɛbie nní nkpɑɑní kɛ̀ Sosɛfu pokù Asenɑti, Potifedɑ birɛɛ ò pɛitɛ́ initidɑbí ìdɛ́ì. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Kɛ̀ Sosɛfuu yú dɛketirɛ̀ kɛ dɔ̀: Mɑnɑnsee kɛ yɛ̃́ Kuyie nhò teemmɛ̀ kòò yɛ̃̀ mmɛfɛ̃́ṹtímɛ̀ nɛ̀ ò yɑ̀tɛnɛ̀mɛ̀ o kɔbɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","kɛ́yú dɛdɛ́rɛ̀ kɛ dɔ̀ Efɑdɑimmu kɛ yɛ̃́ Kuyie nhò teemmɛ̀ kòò piɛ́ ibí ò di dìì ɛì mɛsémmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Kɛ̀ yɛbie nyɛ̀yiekɛ̀ tidiitì kpɛyɛɛ pɛ̃ɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Kɛ̀ yɛbie nyɛ̀yiekɛ̀ dikònnì kpɛyɛɛ tuɔkɛní kɛ́ndònnɛ̀ Sosɛfu tì nɑ̀kɛ́mɛ̀. Kɛ̀ tidiitì bɑɑ mbo Esibiti miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Kɛ̀ dikònnìi pĩ́ nhEsibiti ɛì kɔbɛ bɛmɔu kɛ̀ bɛ̀ɛ kɔtɛ kɛ́yɑ̀ okpɑ̀ɑ̀tì, kòò dɔ̀: Kɔtɛnɛ̀ kɛ́yɑ̀ Sosɛfu, kòò di nɑ̀kɛ́ tì, di ti ndɔɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Kɛ̀ dikònnìi tɑ dihɛì kɛ̀ Sosɛfuu dennɛní tidiitì, kɛ́nfiitinɛ̀ Esibiti kɔbɛ, kɛ̀ dikònnì dɔ̀kɛ dɛ́úkú. ");
INSERT INTO tbzsim_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Kɛ̀ yɛhɛkɛ̀ yɛmɔu kɔbɛ ńkɔrìní Esibiti Sosɛfu borɛ̀ kɛ do ntidiitì, kɛ yɛ̃́ dikònnì do tɑmɛ̀ titentì timɔu ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Mɛm̀mɛ kɛ̀ Sɑkɔbuu keè tidiitì bomɛ̀ Esibiti kɛ́nɑ́kɛ́ o bí kɛ dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di kɑri kɛ wúó nditɔbɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","N yo kɛ̀ bɛ̀ tu tidiitì bo Esibiti. Kɔtɛnɛ̀ kɛ́dontɛ́ní, kɛ̀ tí nyo nkɛ́nfòù, kɛ bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Kɛ̀ Sosɛfu kó bɛkótíbɛ̀ tɛpíítɛ̀ɛ kɔtɛ Esibiti kɛ bo dontɛ́ní tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Sɑkɔbu mɛ nyí nyie nkɛ̀ Bɛnsɑmɛɛ, Sosɛfu nɑntɛ̀ nnɛí. Ò do yĩɛ̃̀kù mɛyɛi mmɑmɛ̀ yɑ̀ɑ̀ bo ò tùɔ̀kɛnímɛ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Kɛ̀ Sɑkɔbu bíi ítɛ́, kɛ́nɛinɛ̀ bɛ̀ɛ̀ múnkɛ kɔrì mudidommu Esibiti, kɛ yɛ̃́ dikònnì do bomɛ̀ Kɑnnɑhɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Sosɛfu weè do bɑkɛ́ dihɛì, kɛ̀ weè fiitinɛ̀ bɛpɔ̀ɔ̀bɛ̀ tidiitì, kòo kó bɛkótíbɛ̀ɛ tuɔkoo kɛ́nínkóo o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Kɛ̀ Sosɛfuu yɑ̀ o kó bɛkótíbɛ̀ kɛ́ bɛ̀ bɑntɛ́, kɛ́dɔɔ̀ kɛ́ndò nwè í bɛ̀ bɑntɛ́, kɛ́ bɛ̀ bɛ́innɛ̀ mɛkperímɛ̀ kɛ dɔ̀: Di yɛ̀nní dɛ? Kɛ̀ bɛ̀ dɔ̀: Ti yɛ̀nní Kɑnnɑhɑ̃ɑ̃ nwe, kɛ dɔ́ kɛ́dontɛ́ tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Sosɛfu yie do bɛ̀ bɑntɛ́mu, bɛmbɛ mɛ nyí nhò bɑntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Kɛ̀ Sosɛfuu dentɛní ò do yɑ̀ tìì dɔuǹtì, kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Di tú bɛnitiyɛibɛ mbɛ, kɛ kɔ̀tɛní kɛ bo yɑ̀ dihɛì cĩĩnnì kùù píkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Kɛ̀ bɛ̀ dɔ̀: Áɑ̀, ti yiɛ̀, ti kɔ̀tɛní kɛ bo dontɛ́ tidiitì nti. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ti tú onìtì omɑ́ɑ̀ kó ibí nyi, kɛ tú bɛnitisɑ̀ɑ̀bɛ̀, ti í tú bɛnitiyɛibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Kɛ̀ Sosɛfu dɔ̀: Bìtì! Di kɔtɛní kɛ bo yɑ̀ dihɛì cĩĩnnì kùù píkù nku. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Kɛ̀ bɛ̀ dɔ̀: Mɛɛ̀ dɔkɛ. Ti do bo bɛnìtìbɛ̀ tɛpíítɛ̀ nɛ̀ bɛ̀dɛ́bɛ̀ ndi, ti cicɛ ti pɛitɛ́mɛ̀ Kɑnnɑhɑ̃ɑ̃. Kòo sɑ́m̀pɔ́ù kpɑɑ́ tɛcĩ́ɛ̃̀tɛ̀ ti cicɛ borɛ̀, kòo tɔù feti. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Kɛ̀ Sosɛfu dɔ̀: M bɑɑ di nɑ́ɑ́mmu kɛ tú di tú bɛnitiyɛibɛ mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Di nɑntɛ̀ sɑ́m̀pɔ́tɛ̀ bo tuɔkɛní dìì mɔ̀nnì m bo dɛ m bɑntɛ́ di nɑ́ɑ́mmɛ̀ timɔ́mmɔnti. Míì bɛ́i nnɛ̀ okpɑ̀ɑ̀tì kó diyètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Di yó nkpetímu diɛ nkòo mɔù mɑ́ɑ̀ kò nkɛ́yúní di nɑntɛ̀. Mɛm̀mɛ ti bo bɑntɛ́mɛ̀ di nɑ́ɑ́mmɛ̀ timɔ́mmɔnti kɛ mɛɛ̀ dɔkɛ m bɛ́immu nɛ̀ okpɑ̀ɑ̀tì kó diyètìrì kɛ tú di kɔ̀tɛní kɛ bo pɑɑtɛ́ dihɛì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Mɛm̀mɛ kòo bɛ̀ kpetínnɛ́ yɛwe yɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Diyiè tɑ̃ɑ̃́nnì yiè kɛ̀ Sosɛfu dɔ̀: Dɔɔ̀nɛ̀ n yóó di nɑ́kɛ́ tì kɛ́nfòù kɛ yɛ̃́ n démɛ̀ Kuyie nku. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Kɛ̀ di mɛ̀nkɛ tú bɛnitisɑ̀ɑ̀bɛ̀ mbɛ di kóò mɔù nkpɑɑ́ kpetí, kɛ̀ bɛsɔmbɛɛ tɔ tidiitì kɛ́kò nkɛ́duɔ́ ndi cɛ̃́ĩ kɔbɛ kɛ̀ bɛ̀ɛ di. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kɛ̀ dí tɔní di nɑntɛ̀, kɛ̀ m bɑntɛ́ di nɑ́ɑ́mmɛ̀ timɔ́mmɔnti, kɛ dí cootɛ́. Kɛ̀ bɛ̀ɛ yie nhò yĩ́ mù, ");
INSERT INTO tbzsim_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","kɛ́nnɑ́ɑ́ mbɛmɑ́ɑ̀ kɛ tú: Ti dɔ̀ɔ̀ mɛ̀ɛ̀ yɛi nti nɑntɛ̀ mɛɛ̀ te kɛ̀ bɛ̀ ti kpetí, ò do kuɔ̀mmu kɛ ti békú mɛcĩ́ɛ̃́mmɛ̀ kɛ̀ tí yetɛ, dɛɛ̀ ti tùɔ̀kɛní di mmɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Kɛ̀ Dubɛnni dɔ̀: N do di nɑ̀kɛ́mu kɛ̀ ǹ dɔ̀, ti bɑ́ɑ́ dɔɔ̀ mɛyɛi ndɛbirɛ, kɛ̀ dí yetɛ. Mɛɛ̀ yɛi nkó tiyeti tiì tùɔ̀kɛní. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Bɛ̀ do í yɛ̃́ kɛ do nSosɛfu yo bɛ̀ tu mù. Kɛ yɛ̃́ ò do ɔ̃ mbɛ̀ nɑ̀ɑ́nnɛ̀mɛ̀ kɛ̀ bɛ̀ tùònkomu. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Kɛ̀ Sosɛfuu kɛntɛ́ kɛ́kuɔ́, kɛ́wɛ̃tɛní kɛ́pĩ́ nSimmɛɔ̃ɔ̃ bɛ ììkɛ̀ kɛ́kpetínnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Kɛ̀ Sosɛfu dɔ̀: Bɛ̀ɛ píɛ ntidiitì bɛ yɔ̀tì, kɛ́wɛ̃tɛ kɛ́ bɛ̀ tɛ̃̀ńnɛ́ bɛ díítí bɛ yɔ̀tì miɛkɛ, kɛ́ bɛ̀ duɔ́ mmudiì kucɛ kpɛ́í. Kɛ̀ bɛ̀ɛ mɛ̀ ndɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Kɛ̀ bɛ̀ɛ boú bɛ diitì sɑ̃mmɑrímúbɛ̀ ĩ́nkɛ̀ kɛ́kétɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Bɛ̀ yóó yié ndɛ̀ kucɛ kòò mɔù bɛ miɛkɛ boutɛ́ kuyɔ̀rìkù kɛ bo duɔ́ nsɑ̃mmɑrímú mudiì kɛ́yɑ̀ idíítí kuyɔ̀rìkù nùù, ");
INSERT INTO tbzsim_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","kɛ́nɑ́kɛ́ o tebìí kɛ dɔ̀: Bɛ̀ ǹ tɛ̃̀ńnɛ́ idíítí! Ntɛ i kuyɔ̀rìkù miɛkɛ. Kɛ̀ kufɔ̃wɑɑ́ mbɛ̀ pĩ nkɛ̀ bɛ kɔ̃̀ntì nhɑu. Kɛ̀ bɛ̀ dɔ̀: Kuyie nti dɔ̀ɔ̀ bɑ! ");
INSERT INTO tbzsim_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kɛ̀ bɛ̀ɛ tuɔkɛ bɛ cicɛ Sɑkɔbu borɛ̀ Kɑnnɑhɑ̃ɑ̃, kóò nɑ̀kɛ́ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Kɛ dɔ̀: Onìtì wèè bɑkɛ́ dɛ kó dihɛì, wè ti kpɑnnɛ̀mu kɛ yɛ̃ nti tú bɛnitiyɛibɛ, kɛ dɔ́ kɛ́pɑɑtɛ́ dihɛì kɛ́ dì pɔ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Kɛ̀ ti yĩ: Ti í kɔ̀tɛní kɛ bo pɑɑtɛ́ dihɛì, ti tú bɛnitisɑ̀ɑ̀bɛ̀ mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Ti do bo bɛnìtìbɛ̀ tɛpíítɛ̀ nɛ̀ bɛ̀dɛ́bɛ̀ ndi ti cicɛ ti pɛitɛ́mɛ̀, kòo sɑ́m̀pɔ́ù kpɑɑní tɛcĩ́ɛ̃̀tɛ̀ ti cicɛ borɛ̀ Kɑnnɑhɑ̃ɑ̃, kòo tɔù feti. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Kòò dɔ̀: Di bo yĩ́mɛ kɛ̀ m bɑntɛ́ di túmɛ̀ bɛnitisɑ̀ɑ̀bɛ̀. Yóunɛ̀ di kóò mɔù kòo nkpɑɑ́ m borɛ̀, kɛ̀ dí wɑɑ́ ntidiitì kɛ́kò nkɛ́duɔ́ ndi cɛ̃́ĩ kɔbɛ kɛ́tɔní di nɑntɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Dɛ mɔ̀nnì ndi, m bo bɑntɛ́mɛ̀ kɛ dò ndi í tú bɛnitiyɛibɛ kɛ tú bɛnitisɑ̀ɑ̀bɛ̀, kɛ di tɛ̃́nnɛ́ di tebitɛ kɛ̀ di ce ndihɛì dimɔu di dɔ́ mɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Mɛm̀mɛ kɛ̀ bɛ̀ɛ yóótɛ́ tidiitì, bɑ́ wè kòo yɑ̀ o díítí o yɔ̀rìkù miɛkɛ, kɛ̀ kufɔ̃wɑɑ́ mbɛ̀ pĩ mbɛmbɛ nɛ̀ bɛ cicɛ Sɑkɔbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Kɛ̀ Sɑkɔbu dɔ̀: Di yóó deè m bí nyi. Sosɛfu í kpɑɑ́, kɛ̀ bɛ̀ pĩ nSimmɛɔ̃ɔ̃ kɛ̀ di wɛ̃̀tɛ kɛ dɔ́ kɛ́túótɛ́ Bɛnsɑmɛɛ. Dɛ kó mɛyɛi mmɛmɔu duò míì yuu ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Kɛ̀ Dubɛnni dɔ̀: Kɛ̀ n yí wɛ̃̀tɛnɛ̀ní Bɛnsɑmɛɛ, ɑ kuɔ m bí idɛ́. N duɔ́ nwe kɛ̀ n yóó ò wɛ̃̀tɛnɛ̀nímu. ");
INSERT INTO tbzsim_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kɛ̀ Sɑkɔbu dɔ̀: M birɛ bɑ́ɑ́ di nɛinɛ̀. Kɛ̀ mɛyɛi mmɑmɛ̀ dɛ̀ tùɔ̀kɛní kucɛ dí dɔɔ̀ bɑ? Di bɑ́ ntɑnnɛ́ kudɔnkù mí nhodɑkótì nɛ̀ tiyùpɛ́ítì. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Kɛ̀ dikònnì bɑɑ nsɔkɛ́ kɛ dɛ́úkú Kɑnnɑhɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Sɑkɔbu nɛ̀ o bí kɛ̀ bɛ̀ɛ deè tidiitì bɛ̀ sòò dontɛ́ní tì Esibiti, kɛ̀ Sɑkɔbu dɔ̀: Wɛ̃tɛnɛ̀ kɛ́dontɛ́ní tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Kɛ̀ Sudɑɑ dɔ̀: Dɛ kóo nìtì ti nɑ̀kɛ́mu weti weti kɛ tú kɛ̀ ti í nɛinko ti nɑntɛ̀ ò bɑ́ɑ́ ti cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Kɑ̀ɑ yie nkɛ̀ ti nɑntɛ̀ bo ti nɛinɛ̀ tí kɔtɛ kɛ́ dɑ dontɛ́ní tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Kɑ̀ɑ mɛ nyí wè nti duɔ́ nti bɑ́ɑ́ kɔtɛ, kɛ yɛ̃́ wè ti nɑ̀kɛ́mɛ̀ kɛ tú kɛ̀ ti í tɔo ti nɑntɛ̀ ò í yóó ti cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Kɛ̀ Sɑkɔbu dɔ̀: Bɑ nte kɛ̀ di nɑ̀kɛ́ dɛ kóo nìtì kɛ yɛ̃ ndi nɑntɛ̀ bo? Di cɑ̀ɑ̀rɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Kɛ̀ bɛ̀ dɔ̀: Weè ti bìékɛ́ tinɑ́ɑǹtì pɛ́u ti cĩ́ɛ̃̀tɛ̀ kpɛti kɛ tú: Di cicɛ kpɑɑ́ boɑ̀? Di yɔ̃fũ̀ɔ̃̀ kou mɔù boɑ̀? Kɛ̀ ti tɛ̃̀ńnɛ́ ò ti bekɛ tì. Ti do yɛ̃́mu kɛ dò nhò bo yĩ́ tí tɔní ti nɑntɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kɛ̀ Sudɑɑ nɑ́kɛ́ bɛ cicɛ kɛ dɔ̀: N duɔ́ ndɛbirɛ, kɛ̀ tí kɔtɛ, kɛ bɑ́ɑ́ kúnɛ̀ dikònnì, fɔ̃́ nnɛ̀ tínti nɛ̀ ti bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Mí m bo ndɑkɛ dɛ kpɛ́í nkɛ̀ n yí dɛ̀ wɛ̃̀tɛnɛ̀ní kɛ dɑ duɔ́, nni ntú ocɑɑ̀rìwè ɑ ììkɛ̀ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Kɛ̀ ti do í ɔɔtí nɛ̀ miɛ nti do kɔ̀tɛmu kɛ yĩ kucɛ mɛ̀dɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kɛ̀ bɛ cicɛ dɔ̀: Kɛ̀ dɛ̀ dò mmɛmmɛ wɑɑ́nnɛ̀ mɛkɔpempemmɛ̀ nɛ̀ mɛcekùɔ̀ nnɛ̀ tihúúntì nɛ̀ mutie nɛ̀ yɛtebɛ bɛ̀ cɑ̀ɑ́ nyɛ̀, kɛ bií pɑ̃ dɛ kóo nìtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Dí wɑɑ́ nyidíítí tɛì kɛ yíɛ́nɛ̀ di yɑ̀ ì di yɔ̀tì miɛkɛ kɛ́ntɔ, kɛ̀ dɛ̀ yɛ̀mmɛ̀ bɛ̀ yetɛ́mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Túótɛ́nɛ̀ di nɑntɛ̀ kɛ́wɛ̃tɛ dɛ kóo nìtì borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Kuyie mmuwɛ̃rímú mumɔu yiɛ̀ nyóó di teennɛ̀mu kɛ̀ dɛ kóo nìtì dí kuɔ́ mmɛsémmɛ̀, kɛ́ di duɔ́ ndi tebitɛ tɛ̀ɛ̀ kpɑɑní nɛ̀ Bɛnsɑmɛɛ kɛ̀ dí konní. Kɛ̀ m mɛ ndò nkɛ́ pɑɑ̀ m bí nyi, n yì pɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Mɛm̀mɛ kɛ̀ bɛ̀ɛ túótɛ́ yɛpɑ̃rɛ̀ nɛ̀ idíítí kucɛ mɛ̀dɛ́mɛ̀, nɛ̀ Bɛnsɑmɛɛ kɛ́kétɛ́ kɛ́kɔtɛ Esibiti Sosɛfu borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Kòo yɑ̀ bɛ̀ nɛínɛ̀mɛ̀ Bɛnsɑmɛɛ kɛ́nɑ́kɛ́ o tɔ̃mbɛ̀ kóo kótì kɛ dɔ̀: Kpɛ̃nnɛ́ bɛ nnìtìbɛ̀ n cĩ́ɛ̃̀tɛ̀ kɛ́kuɔ fɛɔ̃̀fɛ̀ kɛ́bénnɛ́, bɛ̀ yóó di n cĩ́ɛ̃̀tɛ̀ ntɛ kuyie mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kɛ̀ dɛ kóo nìtìi bɛ̀ tɔ kɛ bo kpɛ̃nnɛ́ Sosɛfu cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kɛ̀ bɛ̀ ntɑti Sosɛfu cĩ́ɛ̃̀tɛ̀, kɛ̀ bɛ̀ nɑ̀ɑ́ mbɛmɑ́ɑ̀ kɛ tú: Bɛ̀ sòò wɛ̃̀tɛ kɛ́cũɔ̃́ ìì díítí tiyɔ̀tì miɛkɛ iì te kɛ̀ bɛ̀ ti tɑtinɛ̀ diɛ, kɛ bo ti fɛ̃́ũ nkɛ́fekɛ ti sɑ̃mmɑrímúbɛ̀, kɛ́ ti dɔɔ̀ tidɑɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Bɛ̀ tɑti dìì mɔ̀nnì tɛcĩ́ɛ̃̀tɛ̀ kɛ̀ bɛ̀ɛ nɑ́kɛ́ Sosɛfu tɔ̃mbɛ̀ kóo kótì kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Ti yiɛ̀ nti sòò kɔ̀tɛnímu diɛ nkɛ́dontɛ́ tidiitì, ");
INSERT INTO tbzsim_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","kɛ́nkũnti kɛ́ nyóó yié nkucɛ, kɛ́boutɛ́ ti yɔ̀tì, bɑ́ wè kòo yɑ̀ o díítí, kɛ̀ ti ì tɔní imɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ti í yɛ̃́ wèè sòò ì ɑ̃nnɛ́ ti yɔ̀tì miɛkɛ. Ti tɔnímu itɛì kɛ bo wɛ̃tɛ kɛ́dontɛ́ tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Kòò dɔ̀: Diwɛ̀ì ndi bo, di bɑ́ nyĩɛ̃̀kù. Kuyie ndi cicɛ tũ nkù kuù ɑ̃nnɛ́ idíítí di yɔ̀tì miɛkɛ. N sòò cɔutɛ́mu di yietí ì. Dɛ mɔ̀nnì kɛ̀ Sosɛfu tɔ̃mbɛ̀ kóo kótìi kpetɛ́ní Simmɛɔ̃ɔ̃, ");
INSERT INTO tbzsim_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","kɛ́duɔ́ nkɛ̀ bɛ̀ɛ tɑ Sosɛfu cĩ́ɛ̃̀tɛ̀ kudieku, kɛ̀ bɛ̀ɛ bɛ̀ duɔ́ mmɛniɛ nkɛ̀ bɛ̀ɛ ɔ́ú bɛ nɑɑ̀cɛ̀i, kɛ̀ bɛ̀ɛ duɔ́ mmudiì sɑ̃mmɑrímúbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Kɛ̀ bɛ̀ ntũnni bɛ pɑ̃rɛ̀ kɛ kémmú Sosɛfu bo konnímɛ̀ kuyie mmɔ̀nnì, kɛ yɛ̃́ bɛ̀ bɛ̀ nɑ̀kɛ́mɛ̀ kɛ tú bɛ̀ yóó we nwɛ̃nnɛ́nɛ̀ kɛ́di. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Sosɛfu tùɔ̀kɛní dìì mɔ̀nnì tɛcĩ́ɛ̃̀tɛ̀, kɛ̀ bɛ̀ɛ ò duɔ́ nyɛpɑ̃rɛ̀, kɛ́do, kɛ́nínkú o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Kɛ̀ Sosɛfuu bɛ̀ dɔunnɛ̀ diwɛ̀ì kɛ dɔ̀: Di kɔ̃̀ntì nɑɑtɑɑ̀? Di cicɛ odɑkótì di sòò nɑ̀ɑ́ nwèè kpɛ́í, ò kpɑɑ́ fòù kòo kɔ̃̀ntì nɑɑtɑɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Kɛ̀ bɛ̀ dɔ̀: A kóo tɔ̃ntì ti cicɛ fòùmu kòo kɔ̃̀ntì nɑɑti. Kɛ̀ bɛ̀ɛ wɛ̃tɛ kɛ́do kɛ́nínkú o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Kɛ̀ Sosɛfuu wéntɛ́ kɛ́yɑ̀ Bɛnsɑmɛɛ o nɑntɛ̀ nɛ̀ wè bɛ̀ wɛ̃ mbɛ yɔ̃ kɛ dɔ̀: Di sòò nɑ̀ɑ́ ndi nɑntɛ̀ tiɛ nkpɛ́í nkɑɑ̀? Kóò bɛ́innɛ̀ kɛ dɔ̀: Kuyie ndɑ dɔɔ̀ mɛsɑ̀ɑ̀ m birɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Kòo kɔ̃̀ntì dɔ̀ yúrùrùù, kòo tɑ kudieku mɛcɑ̃ɑ̃ nkɛ́kuɔ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","kɛ́deè kɛ́yuutɛ́ o ììkɛ̀, kɛ́yɛ̀nní kɛ́mmi nkɛ bɛ̀ kɑ̀rinɛ̀, kɛ dɔ̀: Ãnnɛ́nɛ̀ mudiì. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Kɛ̀ bɛ̀ɛ ɑ̃nnɛ́ Sosɛfu kɛ́cɑ̃́nnɛ́, kɛ́ɑ̃nnɛ́ o tebìí kɛ́cɑ̃́nnɛ́, kɛ́ɑ̃nnɛ́ Esibiti kɔbɛ kɛ́cɑ̃́nnɛ́. Esibiti kó ikuɔ́ do í yíé mbɛ̀ bo wɛ̃nnɛ́nɛ̀mɛ̀ Ebedeebɛ kɛ́di. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀nnɛ bɛ̀ dò ndòmmɛ̀, kɛ́ketɛ́ Mpo kɛ́dentɛ tɛyɑ̃ɑ̃tɛ̀, kɛ̀ bɛ̀ nkɑri koò wetí kɛ wéí bɛtɔbɛ̀ kɛ̀ dɛ̀ bɛ̀ di. ");
INSERT INTO tbzsim_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Kɛ̀ Sosɛfuu bɛ̀ duɔ́ mmudiì, kɛ̀ Bɛnsɑmɛɛ kɔ̃mu nsũ kucɛ mɛ̀nùmmù kɛ́pɛ̃ɛ̃tɛ́ bɛtɔbɛ̀ kɔ̃mu, kɛ̀ bɛ̀ɛ yɑ̃̀ mɛnɑɑ̀ nkɛ̀ bɛ̀ yɛ̀mmɛ̀ɛ cɑ́tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Dɛ mɔ̀nnì kɛ̀ Sosɛfuu nɑ́kɛ́ o tɔ̃mbɛ̀ kóo kótì kɛ dɔ̀: Píɛ mbɛ yɔ̀tì tidiitì bɛ̀ yóó nɑ kɛ́tɔ mɛ̀ɛ̀ botí, kɛ́ɑ̃nnɛ́ bɑ́ wè o kó idíítí o yɔ̀rìkù nùù, ");
INSERT INTO tbzsim_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","kɛ́túótɛ́ n sɔɔbòòfɛ̀ kɛ́ɑ̃nnɛ́ tɛyɑ̃ɑ̃tɛ̀ kó kuyɔ̀rìkù, kɛ́nɔ́ɔ́ nho díítí kuyɔ̀rìkù nùù. Kòo tɔ̃ntìi mɛ ndɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kɛ̀ dɛ̀ɛ wentɛ́ dikṹnweńnì sɛ̀ì kɛ̀ bɛ̀ɛ duɔ́ nkɛ̀ bɛ̀ɛ kétɛ́ nɛ̀ bɛ sɑ̃mmɑrímúbɛ̀. Kɛ̀ bɛ̀ nkũnti, ");
INSERT INTO tbzsim_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","kɛ mu nyí ndɛ́tɛ́nɛ̀ dihɛì kɛ̀ Sosɛfuu nɑ́kɛ́ o kóo tɔ̃ntì kɛ dɔ̀: Tũnnɛ bɛ. Kɑ̀ɑ bɛ̀ nìntɛ ɑ dɔ̀: Dɛ̀ yĩ́mɛ kɛ̀ bɛ̀ di dɔ̀ɔ̀ mɛsɑ̀ɑ̀ nkɛ̀ di dɔ̀ɔ̀ mɛyɛi? ");
INSERT INTO tbzsim_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Dɛ̀ dòmmɛ kɛ̀ di tùótɛ́ n yiɛ̀ mbòòfɛ̀ o yɔ̃̀nnɛ̀ fɛ̀ kɛ fɛ̀ pɑ̃ũ̀nɛ̀, di cɑ̀ɑ̀rɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Kòo tɔ̃ntìi bɛ̀ nìntɛ kɛ́ tì mbɛ̀ nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Kɛ̀ bɛ̀ɛ ò tɛ̃̀ńnɛ́ kɛ dɔ̀: Ti yiɛ̀ ndɛ̀ yĩ́mɛ kɑ̀ɑ nɑ̀ɑ́ mmɛmmɛ? Ti bɑ́ɑ́ yie nkɛ́dɔɔ̀ mɛmmɛ kóò botí. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ti tɔnímu ti sòò kò nKɑnnɑhɑ̃ɑ̃ kɛ́yɑ̀ ìì díítí kɛ dɑ duɔ́, ti bo yĩ́mɛ kɛ́yúúkú idíítí yoo mɛsɔɔ nhɑ yiɛ̀ ncĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Kɑ̀ɑ yɑ̀ wèè borɛ̀ dɛ kó fɛbòòfɛ̀ ɑ́ o kùɔ, tínti bɛsɔmbɛ kɛ̀ tí nɑɑ́ ndi kó tidɑɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Kɛ̀ Sosɛfu tɔ̃ntì dɔ̀: N yiemmu di yĩmù n nɛ́ bo yɑ̀ wèè borɛ̀ dɛ kó fɛbòòfɛ̀ weè yóó nɑɑ́ n kó kudɑɑkù, díndi bɛsɔmbɛ kɛ̀ di kpɛti bɑ́ mbo. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kɛ̀ bɛ̀ɛ cṹũnní bɛ yɔ̀tì kɛ́boutɛ́ mɛcɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Kòo ketɛ́ kɛ́fiɛ́ bɛ kóo Po kɔku kɛ́dentɛnɛ̀ tɛyɑ̃ɑ̃tɛ̀ Bɛnsɑmɛɛ kɔku, kɛ́ fɛ̀ yɑ̀ dɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kɛ̀ bɛ yɛ̀mmɛ̀ɛ cɑɑ̀rɛ̀ kɛ̀ bɛ̀ɛ kɛ̃rí bɛ yɑɑ̀bòrɛ̀, kɛ́boú bɛ nɛntì bɛ sɑ̃mmɑrímúbɛ̀ kɛ́wɛ̃tɛ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Sudɑɑ nɛ̀ o kɔbɛ kɛ̀ bɛ̀ɛ tuɔkoo kɛ́sɔ̃́ntɛ́ Sosɛfu, kɛ́do kɛ́nínkóo o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Kɛ̀ Sosɛfu dɔ̀: Di dɔ̀ɔ̀ bɑ? Di í yɛ̃́ kɛ do nhonìtì wèè dò m mɛ̀ ndòmmɛ̀ ò bo nɑ kɛ́nyɛ̃́ dɛmɔuɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Kɛ̀ Sudɑɑ dɔ̀: Okótì, ti bo dɑ nɑ́kɛ́ ɔ̃̀nti kɑ̀ɑ bɑntɛ́ ti í cɑ̀ɑ̀rɛ̀mɛ̀? Kuyie mbɛnkɛmu ti yɛi, kɛ̀ ti bo ntú ɑ kó tidɑɑtì, tínti nɛ̀ bɛ̀ yɑ̀ wèè kó tinɛntì miɛkɛ fɛbòòfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kɛ̀ Sosɛfu dɔ̀: Kuyie mbɑ́ɑ́ yie nkɛ̀ n dɔɔ̀ dɛndɛ. Bɛ̀ yɑ̀ wèè nɛntì miɛkɛ fɛbòòfɛ̀ weè yó ntú n kó kudɑɑkù, díndi bɛsɔmbɛ di kpɛti í bo, kònnɛ̀ di cicɛ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Kɛ̀ Sudɑɑ tɔ́ɔ́nko Sosɛfu borɛ̀ kɛ dɔ̀: Okótì, n dɑ bɑ́ɑ́mmu, yóu kɛ̀ m bɛ́i, ɑ miɛkɛ bɑ́ɑ́ pɛikɛ, kɛ yɛ̃́ ɑ í cɑ̃́ɑ̃́nnɛ̀mɛ̀ okpɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Okótì ɑ sòò ti bekɛmu kɛ dɔ̀: Ti cicɛ kpɑɑ́ boɑ̀? Kɛ̀ ti tebitɛ mɑtɛ̀ kpɑɑ́nɑ́ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Kɛ̀ tí dɑ tɛ̃́nnɛ́ kɛ dɔ̀: Ti cicɛ bomu kɛ kòtɛ́ mɛdiɛ̀ nkɛ̀ ti nɑntɛ̀ bo, ti cicɛ pɛitɛ́ tɛ̀ o kótì miɛkɛ, kɛ̀ tɛ kóo kótì nɛ̀ wè bɛ̀ wɛ̃ mbɛ yɔ̃ kòò ku, kòò kpɑɑ́ omɑ́ɑ̀, kɛ̀ ti cicɛ ò tɑ̃́ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Kɑ̀ɑ dɔ̀: Ti ò kɔ̀tɛnɛ̀ní kɑ̀ɑ ò yɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Okótì, kɛ̀ ti dɑ tɛ̃́nnɛ́ kɛ dɔ̀: Ò bɑ́ɑ́ nɑ kɛ́ítɛ́ o cicɛ borɛ̀, kòò ìtɛ́ o cicɛ yóó kúmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kɑ̀ɑ dɔ̀: Kɛ̀ ti í nɛinɛ̀ní ti nɑntɛ̀ ɑ bɑ́ɑ́ ti cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kɛ̀ tí wɛ̃tɛ ɑ kóo tɔ̃ntì ti cicɛ borɛ̀ kóò nɑ̀kɛ́ ɑ yɛ̃ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Dɛ kó difɔ̃nkúò kɛ̀ ti cicɛ dɔ̀: Kɔtɛnɛ̀ kɛ́dontɛ́ tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Kɛ̀ tí ò nɑ̀kɛ́ kɛ dɔ̀: Kɛ̀ ti í nɛínɛ̀ ti nɑntɛ̀ ti bɑ́ɑ́ nɑ kɛ́kɔtɛ. Kɛ̀ ti kɔ̀tɛ wèè bɑkɛ́ ò bɑ́ɑ́ ti cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Kɑ̀ɑ kóo tɔ̃ntì ti cicɛ ti tɛ̃́nnɛ́ kɛ dɔ̀: Di yɛ̃́mu kɛ tú m pokù m̀ pɛitɛ́nɛ̀ ibí ìdɛ́ì nyi. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Kɛ̀ dɛ̀mɑrɛ̀ mɑ́ɑ̀ yɛ̀ kɛ̀ dɛ̀ yɛ̃ nyúóó, kɛ̀ n yɛ̀mmɛ̀ dò mmusĩ̀mmù muù bo ndɛ̀ cɑ̀ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Kɛ̀ di tùótɛ́ yie nkɛ̀ mɛyɛi mmɑmɛ̀ ò tùɔ̀kɛní di bo duɔ́ nkɛ̀ dɛ̀ n yonkɛ mí nhodɑkótì kɛ̀ n tɑ kudɔnkù nɛ̀ tiyùpɛ́ítì. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Okótì kɛ̀ ti wɛ̃̀tɛ ti cicɛ borɛ̀ kɛ í nɛínɛ̀ dɛbirɛ diɛ nhò dɔ́ dɛ̀ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Kɛ̀ ti wɛ̃̀too kɛ í nɛínɛ̀ dɛbirɛ dɛ̀ yóó ò yonkɛmu wenwe odɑkótì, kòo tɑ kudɔnkù nɛ̀ tiyùpɛ́ítì, dɛndɛ bɑ̀mbɑ̀ nkɛ̀ dɛ̀ ntú ti kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","N sòò ò nɑ̀kɛ́mu kɛ dɔ̀: Kɛ̀ n yí wɛ̃̀tɛnko dɛbirɛ m bo ntú ocɑɑ̀rìwè sɑ̃́ɑ̃̀ o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","N dɑ bɑ́ɑ́mmu yóu kɛ̀ míì cɔutɛ́ dɛbirɛ fɔ̃̀tìrì kɛ́ n tú ɑ kó kudɑɑkù kɛ̀ dɛ̀ɛ nɛinɛ̀ bɛtɔbɛ̀ kɛ́kò. ");
INSERT INTO tbzsim_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","M bɑ́ɑ́ nɑ kɛ́wɛ̃tɛ n cicɛ borɛ̀ kɛ í tɔ dɛbirɛ, n yí dɔ́ n yɑ̀ o yɛǹcɑɑ̀rìmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Dɛ mɔ̀nnì Sosɛfu í nnɑ kɛ bo pĩ́ nhomɑ́ɑ̀, kɛ́duɔ́ nkɛ̀ bɛnìtìbɛ̀ɛ yɛ̀ bɛmɔu. Kòò nkpɑɑ́ nɛ̀ o tebìí, kɛ́ bɛ̀ nɑ̀kɛ́ ò tumɛ̀ bɛ kou nwe, ");
INSERT INTO tbzsim_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","kɛ́kuɔ́ mmɛdiɛ̀ nkɛ̀ Esibiti kɔbɛɛ kèè, kɛ̀ tinɑ́ɑǹtìi tuɔkɛ okpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Kɛ̀ Sosɛfuu nɑ́kɛ́ o tebìí kɛ dɔ̀: Míì tu Sosɛfu, n cicɛ kpɑɑ́ fòùɑ̀? Kɛ̀ dɛ̀ɛ bɛ̀ di kɛ́ bɛ̀ kpeí bɑ́ bɛ̀ í nnɑ kóò tɛ̃̀ńnɛ́ tìmɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kòò dɔ̀: Tɔ́ɔ́nnɛ̀nní. Kɛ̀ bɛ̀ɛ tɔ́ɔ́nní, kòò dɔ̀: Míì tu Sosɛfu di nɑntɛ̀ di fìtɛ́ tɛ̀ kɛ̀ bɛ̀ tɛ̀ kɔ̀tɛnɛ̀ní Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Di yɛ̀mmɛ̀ nɛ́ bɑ́ɑ́ cɑɑ̀rɛ̀, kɛ̀ dɛ̀ di yonkɛ di n fìtɛ́ mɛ̀ɛ̀ kpɛ́í, Kuyie nkuù n niinní diɛ nkɛ̀ m bo di dɛɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yɛbie nyɛ̀dɛ́ɛ̀ ndi dikònnì bomɛ̀, dɛ̀ kpɑɑ́ yɛ̀nùmmù, onìtì í yóó buɔtí ò mɛ nyí yóó kɔ̃ṹ. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kuyie nkuù ǹ niinní kɛ̀ m̀ bo di dɛɛtɛ́, kɛ̀ di kó kubotí bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Díì í n duɔnní diɛ, Kuyie nkuù ǹ duɔ́nní, kɛ̀ n tũ̀ nhokpɑ̀ɑ̀tì kɛ ni o cĩ́ɛ̃̀tɛ̀ nɛ̀ Esibiti omɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ítɛ́nɛ̀ mɛcɑ̃ɑ̃ nkɛ́kò nkɛ́nɑ́kɛ́ n cicɛ kɛ dɔ̀: Kuyie nkɑ̀nnɛ ɑ birɛ Sosɛfu Esibiti, kɛ̀ dɛ̀ bɑkɛ́, kɛ tú ɑ ítɛ́ mɛcɑ̃ɑ̃ nkɛ́kɔtoo o borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Kɛ tú ɑ kɔtoo nɛ̀ ɑ́ bí nɛ̀ ɑ yɑɑ̀bí nɛ̀ ɑ pe nɛ̀ ɑ nɑ̀ɑ̀kɛ nɛ̀ ɑ kpɛrɛ dɛmɔu, kɛ́kɑri Kosɛnni tempɛ̃ kɛ́ nhò tɔ̀kɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Kòò n dɑ duɔ̀ mmudiì fɔ̃́ nnɛ̀ ɑ cĩ́ɛ̃̀tɛ̀ kɔbɛ kɑ̀ɑ nfòù, kɛ yɛ̃́ yɛbie nkpɑɑ́mɛ̀ yɛ̀nùmmù dikònnì kpɛyɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Di bɑntɛ́mu weti weti kɛ dò mmí nSosɛfu míì di nɑ́ɑ́nnɛ̀, fɔ̃́ mBɛnsɑmɛɛ n nɑntɛ̀ kɑ̀ɑ múnkɛ bɑntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kònnɛ̀ kɛ́nɑ́kɛ́ n cicɛ n yo ntìì kpɑ̀tì Esibiti, kóò nɑ̀kɛ́ di yɑ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀, kóò kɔ̀tɛnɛ̀ní diɛ mmɛcɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kɛ̀ Sosɛfuu ɔrí Bɛnsɑmɛɛ o nɑntɛ̀ kɛ̀ diwɛ̀ìi ò ɑutɛ́ kòo kuɔ́, nkòò múnkɛɛ kuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Kɛ̀ Sosɛfu ńhɔrì o kó bɛkótíbɛ̀ tɔbɛ̀ kɛ kuɔ̀, ndɛ mɔ̀nnì ndi bɛ̀ dɑ̀ɑ́tímɛ̀ kóò bɛ́innɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Kòo kpɑ̀ɑ̀tìi keè Sosɛfu tebìí kɔ̀tɛnímɛ̀, kɛ̀ dɛ̀ɛ ò nɑrikɛ wenwe nɛ̀ o kó bɛtũ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Kòo kpɑ̀ɑ̀tìi nɑ́kɛ́ Sosɛfu kɛ dɔ̀: Nɑ́kɛ́ ɑ tebìí kɛ tú, n yɛ̃ mbɛ̀ɛ boú bɛ nɛntì sɑ̃mmɑrímúbɛ̀ kɛ́kò nKɑnnɑhɑ̃ɑ̃, ");
INSERT INTO tbzsim_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","kɛ́túótɛ́ní bɛ cicɛ nɛ̀ bɛ cɛ̃́ĩ kɔbɛ, kɛ́wɛ̃tɛní kɛ̀ m bɛ̀ bɛnkɛ dikɑrì sɑ̀ɑ̀rì Esibiti kɛ̀ bɛ̀ nkɑri kɛ yo ndɛsɑ̀ɑ̀rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Á bɛ̀ nɑ̀kɛ́ kɛ̀ bɛ̀ɛ túótɛ́ sinɑɑsɛ̃ĩ́ kɛ́tɔnɛ̀ní bɛ pobɛ̀ nɛ̀ bɛ bí nɛ̀ bɛ cicɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Bɛ̀ bɑ́ mbɔti bɛ̀ yóó yóu dɛ̀ kpɛti, dɛsɑ̀ɑ̀rɛ̀ dɛ̀ɛ̀ bo Esibiti dɛ̀ tu bɛ kpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kɛ̀ Sɑkɔbu bíi dɔɔ̀ bɛ̀ yɛ̃mmɛ̀ kɛ̀ Sosɛfuu bɛ̀ duɔ́ nsinɑɑsɛ̃ĩ́ okpɑ̀ɑ̀tì yɛ̃mmɛ̀, kɛ́ bɛ̀ duɔ́nnɛ̀ mudiì bɛ̀ bo nyo mmù kucɛ, ");
INSERT INTO tbzsim_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","kɛ́pɑ̃ bɑ́ wè diyɑɑ̀bòrì pɑ̀nnì, kɛ́pɑ̃ Bɛnsɑmɛɛ yie yɛ̀nùmmù nɛ̀ mɛdítíbii nsikɔusìtɑ̃ɑ̃ti (300), ");
INSERT INTO tbzsim_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","kɛ́duɔ́ nho cicɛ sɑ̃mmɑrímúbɛ̀ tɛpíítɛ̀, kɛ̀ bɛ̀ ntɔ Esibiti kpɛrɛ dɛsɑ̀ɑ̀rɛ̀, bɛtɔbɛ̀ tɛpíítɛ̀ kɛ̀ bɛ̀ ntɔ tidiitì nɛ̀ pɛ̃́ɛ̃̀ nɛ̀ mudiì tɛ̃mù bɛ̀ bo nkérí kɛ diiti mù kucɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Kɛ̀ Sosɛfuu nɑ́kɛ́ o tebìí kɛ dɔ̀: Kònnɛ̀, di nɛ́ bɑ́ɑ́ kpɑ nkucɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Kɛ̀ bɛ̀ɛ ítɛ́ Esibiti kɛ́kò nKɑnnɑhɑ̃ɑ̃ bɛ cicɛ Sɑkɔbu borɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","kɛ́ ò nɑ̀kɛ́ kɛ dɔ̀: Sosɛfu kpɑɑ́ fòùmu, kɛ̀ weè ni Esibiti omɔu. Dɛ̀ mɛ nyí nnɑmpɛ bɛ cicɛ, ò í nyie ndɛ kó tinɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Kɛ̀ bɛ̀ɛ ò nɑ̀kɛ́ Sosɛfu do bɛ̀ nɑ̀kɛ́ tì timɔu, kóò bɛnkɛ sinɑɑsɛ̃ĩ́ ò duɔnní sì kɛ̀ sì bo ò tɔo, dɛ mɔ̀nnì ndi o yɛ̀mmɛ̀ tɔ̀ɔ́nnímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Kòò dɔ̀: M bɑntɛ́mu m birɛ Sosɛfu fòùmɛ̀, m bo kɔtɛ kóò yɑ̀ kɛ nɛ́ nɑ kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Mɛm̀mɛ kɛ̀ Sɑkɔbuu túótɛ́ o kpɛrɛ dɛmɔu kɛ́kétɛ́ kɛ́mberínɛ̀ Bɛɛrisebɑɑ, kɛ́féútɛ́ fɛɔ̃̀fɛ̀ Kuyie nho cicɛ Isɑki do tũ nkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Kɛ̀ Kuyie nhò yu kɛyènkɛ̀ kɛ dɔ̀: Sɑkɔbu! Sɑkɔbu! Kòò dɔ̀: Ntɛ mí. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Kɛ̀ kù dɔ̀: Míì tu Kuyie nhɑ cicɛ do tũ nkù. Bɑ́ nyĩɛ̃̀kù ɑ bo kɔtɛmɛ̀ Esibiti. N yóó duɔ́ nkɑ̀ɑ botíi nsṹṹmmu mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","N yó ndɑ nɛínɛ̀mu kɛ, kɛ́wɛ̃tɛ kɛ́ dɑ tɛ̃́nnɛ́ní. Sosɛfu weè yó mbo ɑ kɔ̃ ndɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Kɛ̀ Sɑkɔbuu ítɛ́ Bɛɛrisebɑɑ kòo bíi ò dèe nsinɑɑsɛ̃ĩ́ wenwe nɛ̀ bɛnitipòbɛ̀ nɛ̀ ibí. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Kɛ̀ bɛ̀ ntɔ bɛ wũɔ̃ nɛ̀ bɛ kpɛrɛ dɛmɔu bɛ̀ do mɔ̀kɛ dɛ̀ Kɑnnɑhɑ̃ɑ̃ kɛ́kɔtɛnɛ̀ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Mɛm̀mɛ Sɑkɔbu kòmmɛ̀ Esibiti nɛ̀ o bí. Initidɑbí nɛ̀ initipobí nɛ̀ o yɑɑ̀bí initidɑbí nɛ̀ initipobí. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ntɛ Sɑkɔbu bí ìì ìtɛ́ Kɑnnɑhɑ̃ɑ̃ kɛ kò nhEsibiti i yètɛ̀: Dubɛnni bɛ kóò Po. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Dubɛnni kó ibí initidɑɑì tu: Enɔki nɛ̀ Pɑduu nɛ̀ Ɛtisidonni nɛ̀ Kɑdimii. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simmɛɔ̃ɔ̃ kó ibí initidɑɑì tu: Yemmuyɛɛdi nɛ̀ Yɑminni nɛ̀ Oɑdi nɛ̀ Yɑkinni nɛ̀ Soɑɑ nɛ̀ Sɑuri Kɑnnɑhɑ̃ɑ̃ kóo nitipòkù kó dɛbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Defii kó ibí initidɑɑì tu: Kɛrisonni nɛ̀ Keɑti nɛ̀ Mɛdɑdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Sudɑɑ kó ibí initidɑɑì tu: Kedɑɑ nɛ̀ Pɛdɛsi nɛ̀ Sedɑɑ. Sudɑɑ kó ibí tɛì: Ɛɛ nɛ̀ Onɑɑ bɛ̀ do kumu Kɑnnɑhɑ̃ɑ̃. Kɛ̀ Pɛdɛsi kó ibí ntú Ɛtisidonni nɛ̀ Amudi. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isɑkɑɑ kó ibí initidɑɑì tu: Todɑɑ nɛ̀ Puwɑɑ nɛ̀ Yobu nɛ̀ Simudonni. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sɑbunɔɔ kó ibí initidɑɑì tu: Sedɛti nɛ̀ Edonni nɛ̀ Yɑdeyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Sɑkɔbu pokù Deɑ ò piɛ́ bɛ̀ɛ̀ dɑpɑ̀mbɛ̀ mbɛ nɛ̀ bɛ tɑ̃ũ̀ Dinɑ Mɛsopotɑmii tenkɛ̀. Bɛmbɛ nɛ̀ bɛ bí bɛ̀ wɛ̃nnɛ́ sipísìtɑ̃ɑ̃ti nɛ̀ bɛ̀tɑ̃ɑ̃ti ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Kɑdi kó ibí initidɑɑì tu Sefonni nɛ̀ Akii nɛ̀ Suni nɛ̀ Ɛsibonni nɛ̀ Ɛdi nɛ̀ Adodi nɛ̀ Adedii. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asɛɛ kó ibí initidɑɑì tu Immunɑ nɛ̀ Isifɑɑ nɛ̀ Isifi nɛ̀ Bediyɑ nɛ̀ bɛ tɑ̃ũ̀ Sedɑɑ. Kɛ̀ Bediyɑ kó ibí ntú: Ebɛɛ nɛ̀ Mɑdikiyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Sidipɑɑ, Dɑmɑɑ do duɔ́ nwèè nitipotɔ̃ntì nwe o kóo sɑpɑ̀ɑ̀ nDeɑ kó ibí nyi tɛpíítɛ̀ nɛ̀ ìkuɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Sɑkɔbu pokù Dɑsɛɛdi kó ibí tú: Sosɛfu nɛ̀ Bɛnsɑmɛɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Kɛ̀ Sosɛfu pokù Potifedɑ, dihɛì Onni kóo kótì kóo sɑpɑ̀ɑ̀ nhAsenɑtii o pɛitɛ́nɛ̀ initidɑbí ìdɛ́ì Esibiti: Mɑnɑnsee nɛ̀ Efɑdɑimmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Kɛ̀ Bɛnsɑmɛɛ pɛitɛ́ initidɑbí tɛpíítɛ̀: Bedɑɑ nɛ̀ Bekɛɛ nɛ̀ Asebɛɛdi nɛ̀ Kedɑ nɛ̀ Nɑɑmɑɑ nɛ̀ Eii nɛ̀ Odoki nɛ̀ Upĩmmu nɛ̀ Mupĩmmu nɛ̀ Adidi. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Sɑkɔbu pokù Dɑsɛɛdi yɑɑ̀bí nyi tɛpíítɛ̀ nɛ̀ ìnɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Kɛ̀ Dɑnni kó dɛbirɛ ntú: Usimmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nɛfutɑdii kó ibí tú: Yɑsiyɛɛdi nɛ̀ Kunni nɛ̀ Yesɛɛ nɛ̀ Sidɛmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bidɑɑ, Dɑmɑɑ do duɔ́ nwèè nitipotɔ̃ntì Dɑsɛɛdi kó iyɑɑ̀bí nyi ìyiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Sɑkɔbu bí nɛ̀ o yɑɑ̀bí ìì do kɔ̀tɛ Esibiti ì do bo sipísìkuɔ̀ nɛ̀ ìkuɔ̀ ndi. Bɛ̀ í kɑ̀ɑnnɛ̀ ibí nɛ̀ bɛnitipòbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","kɛ́wɛ̃nnɛ́ nSosɛfu nɛ̀ o pɛitɛ́ ìì bí ìdɛ́ì Esibiti, kɛ̀ bɛ̀ ḿbo bɛmɔu bɛnìtìbɛ̀ sipísìyiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kɛ̀ Sɑkɔbuu tɔ̃ nSudɑɑ kòo nɑ́kɛ́ Sosɛfu kɛ tú bɛ̀ tùɔ̀kɛní Kosɛnni, kòo kɔtoo. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Kɛ̀ Sosɛfuu túótɛ́ o nɑɑsɑ̃ntɛ̀ kɛ́kɔtɛ kóò co, kóò yɑ̀ kɛ́cokóo kóò ɔrí kɛ̀ diwɛ̀ìi ò ɑutɛ́ kòo ńkuɔ̀ nkɛ̀ dɛ̀ɛ mɔntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Kɛ̀ Sɑkɔbu dɔ̀: Di mmɔ̀nnì n yí yetɛ m bo kúmɛ̀ kɛ yɛ̃́ n dɑ yɑ̀mɛ̀ kɑ̀ɑ kpɑɑ́ fòù. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kɛ̀ Sosɛfuu nɑ́kɛ́ o tebìí nɛ̀ o cicɛ nɛ̀ o kɔbɛ kɛ dɔ̀: M bo kɔtɛ kɛ́nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀ di ìtɛ́ Kɑnnɑhɑ̃ɑ̃ kɛ kɔ̀tɛní m borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","M bo ò nɑ̀kɛ́ kɛ dɔ̀: Di tú bɛnɑɑcɛ̃mbɛ mbɛ, kɛ tɔ di pe nɛ̀ di nɑ̀ɑ̀kɛ nɛ̀ di kpɛrɛ dɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Kòo kpɑ̀ɑ̀tì di yu kɛ di bekɛ kɛ tú: Di tɔ̃mmú tú ɔ̃̀mmu? ");
INSERT INTO tbzsim_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Di dɔ̀, di tú bɛnɑɑcɛ̃mbɛ mbɛ nɛ̀ di bomɛ̀. Di yɛmbɛ̀ bɛɛ̀ do ì cɛ̃mmù kɛ̀ di múnkɛ ì cɛ̃mmù. Mɛm̀mɛ, di bo nɑmɛ̀ kɛ́mbo Kosɛnni kɛ yɛ̃́ Esibiti kɔbɛ wúómmɛ̀ munɑɑcɛ̃mmu mɛyɛi mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Mɛm̀mɛ kɛ̀ Sosɛfuu kɔtɛ kɛ́nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: N tebìí nɛ̀ n cicɛ bɛ̀ ìtɛ́ní Kɑnnɑhɑ̃ɑ̃ kɛ tùɔ̀kɛní kɛ tɔ bɛ pe nɛ̀ bɛ nɑ̀ɑ̀kɛ nɛ̀ bɛ kpɛrɛ dɛmɔu, kɛ bɑ̀tɛ́ Kosɛnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kɛ̀ Sosɛfuu túótɛ́ o kó bɛkótíbɛ̀ bɛ̀nùmmù kɛ́bɛnkɛ okpɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Kòo bɛ̀ bekɛ kɛ dɔ̀: Di pĩ́ nhɔ̃̀mmu tɔ̃mmú botí? Kɛ̀ bɛ̀ dɔ̀: Okpɑ̀ɑ̀tì, ti cɛ̃mmù inɑ̀ɑ̀kɛ nyi ti yɛmbɛ̀ do ì cɛ̃mmùmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Kɛ̀ bɛ̀ɛ nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Dikònnì diì bo ti ciɛ kɛ̀ timútì dèè Kɑnnɑhɑ̃ɑ̃ kɛ̀ ti kɔ̀tɛní kɛ yɛ̃ nhɑ tí pɑ̃ Kosɛnni kó kutempɛ̃, kɛ̀ tí ḿbo. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Kòo kpɑ̀ɑ̀tìi nɑ́kɛ́ Sosɛfu kɛ dɔ̀: A cicɛ nɛ̀ ɑ tebìí bɛ̀ kɔ̀tɛní ɑ borɛ̀ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Fɔ̃́ɔ̃̀ te Esibiti, kɑnnɛ bɛ dibòrì sɑ̀ɑ̀rì Kosɛnni, kɛ̀ bɛ̀mɑbɛ̀ bo bɛ miɛkɛ kɛ bo nɑ, ɑ́ bɛ̀ duɔ́ n kó iwũɔ̃ kɛ̀ bɛ̀ ncɛ̃mmù. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Kɛ̀ Sosɛfuu kɔtɛnɛ̀ o cicɛ Sɑkɔbu, kóò bɛnkɛ okpɑ̀ɑ̀tì kɛ̀ Sɑkɔbuu ò dɔu nkɛ dɔ̀: Kuyie ndɑ pɑ̃ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Kòo kpɑ̀ɑ̀tìi o bekɛ kɛ dɔ̀: A bie mbo yɛ̀dɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Kɛ̀ Sɑkɔbu dɔ̀: M bie mbo tɛkɔ̀ùtɛ̀ nɛ̀ sipísìtɑ̃ɑ̃ti (130) ndi, kɛ̀ n kɑ̀tì kɛ sɔɔti tipíìtì timɔu, kɛ fɛ̃́ṹrì, m bie nyí tùɔ̀kɛ n yɛmbɛ̀ kpɛyɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kɛ̀ Sɑkɔbuu cɑu nhokpɑ̀ɑ̀tì kɛ́deè kɛ́ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kɛ̀ Sosɛfuu kɑnnɛ o cicɛ nɛ̀ o tebìí dibòrì sɑ̀ɑ̀rì Dɑmmusɛsi, kɛ́ bɛ̀ pɑ̃ kɛtenkɛ̀, kɛ́ndònnɛ̀ okpɑ̀ɑ̀tì do bɛ́immɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Kɛ̀ Sosɛfuu pɑ̃ tidiitì o cicɛ nɛ̀ o tebìí nɛ̀ bɛ kɔbɛ, bɛ̀ sũ kɛ mɑ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kɛ̀ dikònnìi dɛukɛ mɛdiɛ̀ nhEsibiti nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɛ̀ bɛnìtìbɛ̀ nkɔ̃nnɛ̀ dikònnì. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Kɛ̀ Sosɛfuu tíí nyidíítí Esibiti kɔbɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ donnɛ̀ ì tidiitì, kɛ́kɔtɛnɛ̀ okpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kɛ̀ idíítíi deè Esibiti nɛ̀ Kɑnnɑhɑ̃ɑ̃, kɛ̀ Esibiti kɔbɛɛ kɔtɛ kɛ́yɑ̀ Sosɛfu kɛ dɔ̀: Ti duɔ́ ntidiitì, bɑ́ɑ́ yóu kɛ̀ tí kú dikònnì, idíítí í kpɑɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Kɛ̀ Sosɛfu dɔ̀: Kɛ̀ idíítí í kpɑɑ́ n duɔ́nnɛ̀ di wũɔ̃ kɛ̀ n di duɔ́ ntidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kɛ̀ bɛ̀ ńtɔuní bɛ wũɔ̃, sisɛ̃ĩ́ nɛ̀ ipe nɛ̀ inɑ̀ɑ̀kɛ nɛ̀ sɑ̃mmɑrímúbɛ̀, kɛ̀ Sosɛfu bɛ̀ duɔ̀ ntidiitì dɛ kó dibenni. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kɛ̀ dɛ kó dibennii deè kɛ̀ bɛ̀ɛ kɔtɛní Sosɛfu borɛ̀ kɛ dɔ̀: Okótì, ti bɑ́ɑ́ dɑ sɔnnɛ, tidiitì í kpɑɑ́ kɛ̀ ti dɑ duɔ́ nti wũɔ̃ imɔu, tíì kpɑɑ́ ti mɔ́mmɔmbɛ nɛ̀ ti tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Bɑ́ɑ́ yóu kɛ̀ tí kú dikònnì kɛ̀ ti tenkɛ̀ɛ yɛi, tí dontɛ́ tínti nɛ̀ ti tenkɛ̀ kɛ̀ tí ntú okpɑ̀ɑ̀tì tɔ̃mbɛ̀ kɛ́ ti duɔ́ ntidiitì nɛ̀ tidibotì kɛ̀ ti bɑ́ɑ́ kú, kɛ̀ ti tenkɛ̀ɛ yɛi. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kɛ̀ Sosɛfuu do nhEsibiti kó kɛtenkɛ̀ kɛmɔu, kɛ́duɔ́ nhokpɑ̀ɑ̀tì. Dikònnì diì do bo, bɑ́ wè kòo fítɛ́ o tenkɛ̀. Mɛm̀mɛ kɛ̀ kɛtenkɛ̀ kɛmɔu nɑɑ́ nhokpɑ̀ɑ̀tì kɔkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Kɛ̀ Sosɛfuu do nhEsibiti kɔbɛ bɛmɔu kɛ̀ bɛ̀ɛ nɑɑ́ ntidɑɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Bɛ̀ í ndo nyikuɔ́ nìùbɛ̀ kó kɛtenkɛ̀ kɛ yɛ̃́ okpɑ̀ɑ̀tì do ɑ̃nnɛ́mɛ̀ ikuɔ́ mɑì kɛ̀ bɛ̀ mbɛ̀ duɔ̀ nkɛ̀ bɛ̀ yo, dɛ̀ í ndò mbɛ̀ɛ fítɛ́ bɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Kɛ̀ Sosɛfuu nɑ́kɛ́ bɛnìtìbɛ̀ kɛ dɔ̀: N di dontɛ́mu díndi nɛ̀ di tenkɛ̀ kɛ̀ okpɑ̀ɑ̀tì di tiekɛ. Ntonɛ̀ tidibotì di yóó buɔtí tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Kɛ̀ di kɔ̃ṹ tidiitì, kɛ̀ tiyɔ̀tì bo tìnùmmù di dɛitɛ kùmɑ́ɑ̀ kɛ́duɔ́ nhokpɑ̀ɑ̀tì, kɛ̀ tìnɑ̀ɑ̀ ntú di kpɛti, di yó nti nyonnɛ̀ di bí nɛ̀ di cɛ̃́ĩ kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Kɛ̀ bɛ̀ dɔ̀: Okótì, ɑ ti dɛɛtɛ́mu kɛ̀ ti cɛ̃́nkɛ pɛ̀tɛ́ mɛsɑ̀ɑ̀, ti yiemmu kɛ bo ntú okpɑ̀ɑ̀tì kó tidɑɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Kɛ̀ Sosɛfuu dɔú ndɛ kó dinùù kɛ̀ dì kpɑɑ́ bo nɛ̀ yíenní kɛ̀ wèè dɛ̀itɛ tidiitì tiyɔ̀tì tìnùmmù wèe duɔ́ nkuyɔ̀rìkù kùmɑ́ɑ̀ okpɑ̀ɑ̀tì. Ikuɔ́ nìùbɛ̀ bɛɛ̀ mɑ́ɑ̀ kó kɛtenkɛ̀ do í tú okpɑ̀ɑ̀tì kɔkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Kɛ̀ Isidɑyɛɛribɛ ḿbo Kosɛnni, Esibiti kó kɛtenkɛ̀, kɛ́mɔɔtɛ bɛ kpɛrɛ kɛ́piɛ́ kɛ́sṹṹ mmɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Kɛ̀ Sɑkɔbu ḿbo Esibiti kɛ dɔ̀ yɛbie ntɛpíítɛ̀ nɛ̀ yɛ̀yiekɛ̀. Sɑkɔbu do yóó kú kɛ mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìnɑ̀ɑ̀ nɛ̀ yɛ̀yiekɛ̀ (147) ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Kɛ̀ Sɑkɔbu tɔ́ɔ́nnɛ̀ mukṹṹ nkɛ́yú o birɛ Sosɛfu kɛ dɔ̀: N dɑ bɑ́ɑ́mmu kɑ̀ɑ n dɔ́ sɛu nhɑ nɔ̀ùtɛ̀ n kpèrɛ̀, kɛ́bɛ́i nkɛ dɔ̀: A í yó n kũnnɛ́ diɛ nhEsibiti miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Kɛ̀ ǹ kú ɑ n tɔ kɛ́yɛ̀nnɛ̀ Esibiti kɛ́ n kũnnɛ́ n yɛmbɛ̀ kó kufɔ̃ti. Kɛ̀ Sosɛfuu yie. ");
INSERT INTO tbzsim_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Kòo yíɛ́ kɛ dɔ̀: Bɛ́i nkɛ́yú Kuyie nyètìrì. Kɛ̀ Sosɛfuu yú Kuyie nyètìrì kòo sĩ́nnɔ́ɔ o dɔ́ù ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kɛ̀ bɛ̀ɛ nɑ́kɛ́ Sosɛfu kɛ dɔ̀: A cicɛ kɔ̃̀ntì í nɑɑti. Kòo túótɛ́ o bí idɛ́ Mɑnɑnsee nɛ̀ Efɑdɑimmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Kɛ̀ Sɑkɔbuu keè o birɛ Sosɛfu kɔ̀roomɛ̀ o borɛ̀ kɛ́yetoo kɛ́ítɛ́ kɛ́kɑri o dɔ́ù ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","kɛ́nɑ́kɛ́ Sosɛfu kɛ dɔ̀: Kuyie nkpeńnìmu kɛ m bɛnkɛ kumɑ́ɑ̀ Duusi, Kɑnnɑhɑ̃ɑ̃ kó kɛtenkɛ̀ kɛ m pɑ̃ mɛsɑ̀ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","kɛ bɛ́i nkɛ yĩ kù bo duɔ́ nkɛ̀ m piɛ́ kɛ́sṹṹ, kɛ́nɑɑ́ nyibotí pɛ́u yɑ̀ɑ̀rì, kɛ̀ n yɑɑ̀bíi tiekɛ dɛ kó kɛtenkɛ̀ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ibí ɑ pɛitɛ́ ì diɛ nhEsibiti Efɑdɑimmu nɛ̀ Mɑnɑnsee kɛ m̀ mu nyí tùɔ̀kɛní ì tu n kpɛyi nyi kɛ dònnɛ̀ Dubɛnni nɛ̀ Simmɛɔ̃ɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kɛ̀ ǹ tùɔ̀kɛní kɑ̀ɑ piɛ́ ì tu ɑ kpɛyi. Bɛ kó bɛkótíbɛ̀ kó kɛtenkɛ̀ miɛkɛ nkɛ bɛ̀ yóó pɛ́tɛ́mɛ̀ bɛ kɔkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","N dɔ̀ɔ̀ mɛmmɛ, n do dɔ́ mɛ̀ɛ̀ kpɛ́í nkɛ ɑ yɔ̃ Dɑsɛɛdi. N yìtɛ́ní Mɛsopotɑmii nwe kɛ́mberínɛ̀ Efɑdɑtɑ, Kɑnnɑhɑ̃ɑ̃ kó dihɛì kòo kú n nɔ̀ùtɛ̀ miɛkɛ, kɛ̀ nh ò kũnnɛ́ Efɑdɑtɑ kucɛ nùù bɛ̀ tu dɛ̀ yíe mBɛtideɛmmu. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kɛ̀ Sɑkɔbuu yɑ̀ Sosɛfu bí idɛ́ kɛ́bekɛ Sosɛfu kɛ dɔ̀: Ɔ̃̀mbɛ mbɛ biɛ? ");
INSERT INTO tbzsim_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Kɛ̀ Sosɛfu dɔ̀: Kuyie nni m pɑ̃ ìì bí nyi diɛ nhEsibiti. Kɛ̀ Sɑkɔbu dɔ̀: Duɔ́ nkɛ̀ bɛ̀ɛ tɔ́ɔ́nní kɛ̀ m bɛ̀ pɑ̃ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Sɑkɔbu do kòtɛ́mu mɛsɑ̀ɑ̀ mbɑ́ o nuɔ ntɛ̃́nkɛ í nnɑɑti, kɛ̀ Sosɛfuu duɔ́ nkòo bí tɔ́ɔ́nko Sɑkɔbu borɛ̀, kòo ì ɔrí, ");
INSERT INTO tbzsim_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","kɛ́nɑ́kɛ́ Sosɛfu kɛ dɔ̀: N do í yɛ̃́ kɛ dò m bo wɛ̃tɛ kɛ́ dɑ yɑ̀, kɛ̀ Kuyie nduɔ́ nkɛ̀ n dɑ yɑ̀ nɛ̀ ɑ bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Kɛ̀ Sosɛfuu íinní o bí o cicɛ kpèrɛ̀ ĩ́nkɛ̀, kɛ́nínkú o ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","kɛ́túótɛ́ ibí idɛ́ kɛ́tɔ́ɔ́nko o cicɛ borɛ̀. Kɛ̀ Efɑdɑimmu ḿbo Sosɛfu bɑkù yoú, Sɑkɔbu kó kucɑ̃̀nku, kɛ̀ Mɑnɑnsee ḿbo Sosɛfu bɑkù cɑ̃̀nku, Sɑkɔbu kó kuyoú. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Kɛ̀ Sɑkɔbu petìnnɛ o bɑɑ̀ nkɛ́nɔ́ɔ́ nho nɔ̀ùtɛ̀ youtɛ Efɑdɑimmu osɑ́m̀pɔ́ù, kɛ́nɔ́ɔ́ ntɛcɑ̃̀nkutɛ̀ Mɑnɑnsee okótì. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Kòo pɑ̃ Sosɛfu Kuyie nkó mɛsɑ̀ɑ̀ nkɛ dɔ̀: Kuyie n yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki bɛ̀ do tũ nkù, kuù m bonɛ̀ kɛ n tɔ nɛ̀ yíenní. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Kuyie nkùù ǹ dɛɛrí nɛ̀ mɛyɛi mmɛmɔu, kùu dɔɔ̀ ì mbí mɛsɑ̀ɑ̀, nɛ̀ dɛ kpɛ́í nkɛ̀ n yètìrì ńsɔkɛ́, kɛ́dònnɛ̀ n yɑ̀ɑ̀rì Abɑrɑhɑmmu nɛ̀ n cicɛ Isɑki bɛ kpɛyɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Kɛ̀ Sosɛfuu yɑ̀ o cicɛ nɔ̀ɔ́mmɛ̀ o nɔ̀ùtɛ̀ youtɛ Efɑdɑimmu ĩ́nkɛ̀ bɑ́ dɛ̀ í nhò nɑrikɛ, kòo tɛ̀ nɔ̀ɔ́tɛ́ kɛ bo nɔ́ɔ́ mMɑnɑnsee ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Kɛ dɔ̀: N cicɛ ɑ yetɛ́mu, yie nweè tu Mpo, nɔ́ɔ́ nhɑ nɔ̀ùtɛ̀ youtɛ o ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kòo cicɛɛ yetɛ kɛ dɔ̀: M birɛ n yɛ̃́mu. Mɑnɑnsee kó kubotí múnkɛ yó ndɛumu kòo sɑ́m̀pɔ́ù nɛ́ ò pɛ̃ɛ̃tɛ́ mɛdiɛ̀, kɛ́nɑɑ́ nyibotí pɛ́u yɑ̀ɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Kɛ̀ Sɑkɔbuu bɛ̀ pɑ̃ Kuyie nkó mɛsɑ̀ɑ̀ nkɛ dɔ̀: Kuyie ndi dɔɔ̀ mɛsɑ̀ɑ̀ nyIsidɑyɛɛribɛ cuokɛ̀, kɛ̀ bɛ̀ níí yĩ́ Kuyie ndɑ dɔɔ̀ mɛsɑ̀ɑ̀ nkù dɔ̀ɔ̀mɛ̀ Efɑdɑimmu nɛ̀ Mɑnɑnsee. Mɛm̀mɛ ò niímmɛ̀ Efɑdɑimmu kɛ́tũ̀nnɛ Mɑnɑnsee. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Kɛ̀ Sɑkɔbuu nɑ́kɛ́ Sosɛfu kɛ dɔ̀: N yóó kúmu kɛ̀ Kuyie nní ndi bonɛ̀, kɛ́duɔ́ nkɛ̀ di wɛ̃tɛ di yɛmbɛ̀ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","N dɑ duɔ́mmu Sisɛmmu n dokɛ́nɛ̀ Amɔriibɛ kɛ cɔutɛ́ kɛ̀ɛ̀ tenkɛ̀ kɛ̀ kɛ̀ pɛ̃ɛ̃tɛ́ ɑ tebìí kɔkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Mɛm̀mɛ, kɛ̀ Sɑkɔbuu yú o bí kɛ dɔ̀: Tíínnɛ̀nní kɛ̀ ǹ di nɑ́kɛ́ tìì yóó di tuɔkɛní diyiè mɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Tíínnɛ̀nní kɛ́keè, mí ndi cicɛ Sɑkɔbu n tú mù, mí nyIsidɑyɛɛri n yóó di nɑ́kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Dubɛnni, fɔ̃́ɔ̃̀ tu n kóo Po, m pɛitɛ́ wè nɛ̀ n dɑcɛ̃ntì miɛkɛ, kɑ̀ɑ pɛ̃nkù bɛsɔmbɛ muwɛ̃rímú kɛ̀ bɛ̀ dɑ dé. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","A dònnɛ̀ fɛnɛ́wuonfɛ nfɛ. A tɛ̃́nkɛ nɛ́ í yó ntú Mpo. Kɛ yɛ̃́ ɑ duɔ́nɛ̀mɛ̀ m pokù, kɛ sĩ̀nkùnnɛ n dɔ́ù. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simmɛɔ̃ɔ̃ nɛ̀ o nɑntɛ̀ Defii, di tú bɛkpɑ̀rìbɛ̀ mbɛ kɛ kpɑnnɛ̀ muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","N yí kɔkɛ́ di kpɛti miɛkɛ, n yí di wɛ̃ńnɛ̀, di kùɔ bɛnìtìbɛ̀ mbɛ nɛ̀ kɛmiɛkɛ, kɛ kèkɛ́ yɛnɑɑdɑkɛ̀ duɔti dɛtetìrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Di bɑ́ɑ́ pɛ́tɛ́ mɛsɑ̀ɑ̀, di kùɔ bɛnìtìbɛ̀ mbɛ nɛ̀ kɛmiɛkɛ, di tɛ̃́nkɛ í yó nwɛ̃ńnɛ̀ Isidɑyɛɛribɛ. N yóó di cíɛmmu Isidɑyɛɛribɛ ɛì dimɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Sudɑɑ, ɑ tebìí yó nsɑ̃ntí fɔ̃́ nwe, ɑ bo nnɔ nhɑ dootitɔbɛ̀, kɑ̀ɑ tebìí nninku ɑ ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","M birɛ Sudɑɑ, ɑ dònnɛ̀ dicìrícìrì ndi, dìì kɔ̀tɛ kupɑɑwɑɑ́ nkɛ kùɔ kɛ duɔ́ dɛ tɑkɛ́. We mbo dɑ́ɑ́tí kɛ dì íi. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Dikpɑ̀ɑ̀tìkɑ̀rì nɛ̀ fɛkpɑ̀ɑ̀tìpɑ̀tìfɛ̀ dɛ̀ yó mbo Sudɑɑ kó kufuku miɛkɛ nkɛ, kɛ tikpɑ̀tì yiɛ̀ mmɔ́mmuɔ nyɑ̀ɑ tuɔkɛnní, ibotí yó nyíé nwèè kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Sudɑɑ, ɑ bo mpiiti ɑ sɑ̃mmɑrímú nɛ̀ dɛ bii fínyĩ̀ kó mutie. A bo mmɔkɛ mɛnɑɑ̀ mpɛ́u, kɛ níí yɑ̃̀ kɛ́yĩɛ̃kɛ kɛ́hɔ́únɛ̀ ɑ yɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","A nuɔ mbo wũɔ̃tɛ́nɛ̀ mɛnɑɑ̀, nkɑ̀ɑ nìì mpɛikɛnɛ̀ mɛnɑɑmiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sɑbunɔɔ, ɑ bo mbo dɑ̀mɛ́ɛ̀rì tɑkɛ́ bɑ̀tóòbɛ̀ commu dɛ̀, kɑ̀ɑ tenkɛ̀ nkɑ̃́ɑ̃́kɛ́ Sidonni. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isɑkɑɑ, ɑ tú sɑ̃mmɑrímú nwe, wèè kpeńnì, kɛ nɛ́ dɔ́ mɛdɛ́ɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Bɛ̀ bo ndɑ tounko yɛtuɔ diɛyɛ̀ kɑ̀ɑ yɑ̀ɑ nɑɑ́nnɛ̀ kudɑɑkù. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dɑnni, ɑ yó ntú obeéntì nwe Isidɑyɛɛribɛ tɔbɛ̀ dòmmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","kɛ́ndò nfɛwɑ̀ɑ̀fɛ̀ fɛ̀ɛ̀ duɔ́ kucɛ kɛ dò ndidɑutiri, kɛ dɔmmù sisɛ̃ĩ́ kpɛ̀ɛ̀tɛ̀, kɛ̀ si dèèbɛ̀ duò. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Ti Yiɛ̀ nKuyie nfɔ̃́ɔ̃̀ yó n dɛɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kɑdi, ɑ dootitɔbɛ̀ yóó dɑ pimu, kɑ̀ɑ kóntɛ́ kɛ́ bɛ̀ pi kɛ́ bɛ̀ bɛ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asɛɛ, ɑ pɑɑ mbo mpɛí tidiitì sɑ̀ɑ̀tì, tìì dò mbɛkpɑ̀ɑ̀tìbɛ̀ kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nɛfutɑdii, ɑ yó ndò ntɛyúɔ́tɛ̀ ntɛ kɛ te ɑ mɑ́ɑ̀ kɑ̀ɑ nɑ́ɑǹtì nɛ́ nnɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Sosɛfu ɑ dònnɛ̀ mutie mmu mùù còḿmú mɛniɛ ntɑkɛ́, kɛ̀ mu bɑkɛ yɛ̀ kɛ pɛ̃ɛ̃tɛ́ iduotí. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Kɑ̀ɑ dootitɔbɛ̀ dɑ cɛ̃̀ɛ̃̀tɛ kɛ dɑ tɑ̃ũ ipie. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kɑ̀ɑ còḿmú tei tei, kɛ tɔ ɑ tɑ̃mmù, Kuyie mmí nSɑkɔbu n tũ nkù kpeńnìmu kɛ dɑ ni kɛ dɑ kɑ̃nkɛ́ kɛ tú ɑ kó muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Kuyie nhɑ cicɛ do tũ nkù dɑ teennɛ̀, Kuyie mmuwɛ̃rímú mumɔu yiɛ̀ ndɑ dɔɔ̀ mɛsɑ̀ɑ̀, kɛ́ dɑ duɔ́ nfɛtɑɑfɛ̀ kɛ̀ mɛniɛ nní mbo, kɑ̀ɑ pobɛ̀ ḿpɛí kɛ mɔkɛ mɛmiɛ̀, kɑ̀ɑ wũɔ̃ ḿpɛí. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","A pɑɑ mbo piɛ́ nɛ̀ yɛtɑ̃rɛ̀ ĩ́nkòo, kɛ̀ yɛtɑ̃rɛ̀ diɛyɛ̀ dɑ dɔɔ̀ mɛsɑ̀ɑ̀. Dɛ kó mɛsɑ̀ɑ̀ mmɛmɔu tu fɔ̃́ nSosɛfu wèè bɑkɛ́ ɑ tebìí ɑ kɔ̃mɛ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Bɛnsɑmɛɛ ɑ tú kumuntũnkù nku, kɛ kɔù dikṹnweńnì nɛ̀ kuyuoku kɛ cɑ́ɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isidɑyɛɛri bí nyi tɛpíítɛ̀ nɛ̀ idɛ́ì. Bɛ cicɛ bɛ̀ nɑ̀kɛ́ tìnti kɛ́ bɛ̀ pɑ̃ Kuyie nkó mɛsɑ̀ɑ̀ mbɑ́ wè ò dò nkɛ́pɛ́tɛ́ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Kɛ̀ Sɑkɔbuu nɑ́kɛ́ o bí kɛ dɔ̀: Kɛ̀ ǹ ku dí n kũnnɛ́ n yɛmbɛ̀ fɔ̃ti Mɑkpedɑɑ, Efunɔɔ, Itiibɛ botí kou pɑku borɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","kɛ́ntɔ́kɛ́nɛ̀ Mɑmmudee Kɑnnɑhɑ̃ɑ̃ kó kɛtenkɛ̀. Abɑrɑhɑmmu weè do dontɛ́ dɛ kó kupɑku nɛ̀ dɛ kó kufɔ̃ti Efunɔɔ, Itiibɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Bɛ̀ dɛ nkũnnɛ́ Abɑrɑhɑmmu nɛ̀ o pokù Sɑrɑɑ, kɛ́ dɛ nkũnnɛ́ Isɑki nɛ̀ o pokù Debekɑɑ, kɛ dɛ nkũnnɛ́ Deɑ. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Dɛ kó kupɑku bɛ̀ kù dontɛ́nɛ̀ Itiibɛ mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Kɛ̀ Sɑkɔbuu duɔ́ nho bí itié, nkɛ́deè kɛ́duɔ́ o dɔ́ù kɛ́kú, kɛ́kò nho yɛmbɛ̀ kũũ̀ nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Dɛ mɔ̀nnì kɛ̀ Sosɛfuu ò ɔrí kɛ́kuɔ́, ");
INSERT INTO tbzsim_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","kɛ́duɔ́ nkɛ̀ bɛdòòtórìbɛ̀ bɛ̀ɛ̀ pĩ nho tɔ̃mmú, kɛ̀ bɛ̀ɛ ɑ̃nnɛ́ o cicɛ Isidɑyɛɛri mutie kòò bɑ́ɑ́ pɑ̃ɑ̃kɛ. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kɛ̀ bɛ̀ nhò ɑ̃ɑ̃̀ mutie kɛ dɔ̀ yɛwe sipísìnɑ̀ɑ̀, kɛ̀ Esibiti kɔbɛɛ kɑri o kṹṹ nkɛ dɔ̀ yɛwe sipísìyiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Kɛ̀ dɛ kó yɛwee pɛ̃ɛ̃tɛ́ kɛ̀ Sosɛfuu nɑ́kɛ́ okpɑ̀ɑ̀tì tɔ̃mbɛ̀ kɛ dɔ̀: N di bɑ́ɑ́mmu kɛ̀ di bo yie ndi nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","N cicɛ yóó kú kɛ bɛ́immu kɛ tú, kòò ku nh ò kũnnɛ́ kufɔ̃ti o dontɛ́ kù Kɑnnɑhɑ̃ɑ̃ tenkɛ̀, kɛ̀ n yie nkɛ yu Kuyie nyètìrì. N dɔ́ kɛ́kɔtɛ kɛ we nkũnnɛ́ kɛ́wɛ̃tɛní. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Kòo kpɑ̀ɑ̀tì dɔ̀: Kɔtɛ kɛ́kũnnɛ́ ɑ cicɛ, kɛ́ndònnɛ̀ ò bɛ́immɛ̀, kɑ̀ɑ yie. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Kɛ̀ Sosɛfu nkɔri kɛ bo kũnnɛ́ o cicɛ, kɛ̀ Esibiti kó bɛhɛikɛ̀nkótíbɛ̀ nɛ̀ okpɑ̀ɑ̀tì tɔ̃mbɛ̀ diɛbɛ̀ kɛ̀ bɛ̀ɛ̀ ò cíe. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Sosɛfu cĩ́ɛ̃̀tɛ̀ tɛmɔu nɛ̀ o tebìí nɛ̀ si kɔbɛ, nɛ̀ o cicɛ kɔbɛ kɛ̀ bɛ̀ɛ ítɛ́ bɛmɔu kɛ́súɔ́ nyibí mɑ́ɑ̀ ndi nɛ̀ iwũɔ̃ Kosɛnni. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kɛ̀ ditĩ̀nnì ndɛu mɛdiɛ̀ nkɛ̀ sinɑɑsɛ̃ĩ́ nɛ̀ bɛsɑ̃ndèèbɛ̀ kɛ̀ dɛ̀ ḿbo. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Kɛ̀ bɛ̀ɛ séntɛ́ kukó nSuditɛ̃ɛ̃ kɛ́tuɔkɛ Atɑɑdi kó kuwenniku, kɛ́kuɔ́ nyɛkúdɑbùò, kɛ̀ Sosɛfu ndɔɔri ikúkuɔ́ o cicɛ kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kɑnnɑhɑ̃ɑ̃ kɔbɛ bɛ̀ɛ̀ bo dɛborɛ̀ kɛ̀ bɛ̀ɛ yɑ̀ ikúkuɔ́ bɛ̀ dɔ̀ɔ̀ ì Atɑɑdi kó kuyiɛ́ kɛ dɔ̀: Ntɛnɛ̀ Esibiti kɔbɛ kó ikúkuɔ́ diɛyì. Dɛɛ̀ te kɛ̀ bɛ̀ yu dɛborɛ̀ kɛ tú Abɛdi-Misidɑimmu. Kukó nSuditɛ̃ɛ̃ kó diyɑ́ɑ̀ do ndi. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Mɛm̀mɛ Sɑkɔbu bí dɔ̀ɔ̀mɛ̀ ò do ì nɑ̀kɛ́ tì, ");
INSERT INTO tbzsim_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","kóò tɔ kɛ́kònnɛ̀ Kɑnnɑhɑ̃ɑ̃, kóò kũnnɛ́ Mɑkpedɑɑ kupɑku, kufɔ̃ti Abɑrɑhɑmmu do dontɛ́ kù nɛ̀ Efunɔɔ Itiibɛ botí kou, Mɑmmudee tɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Kɛ̀ Sosɛfuu kũnnɛ́ o cicɛ kɛ́deè. O tebìí nɛ̀ bɛ̀ɛ̀ ò cíe nkɛ̀ bɛ̀ɛ wɛ̃tɛ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Sɑkɔbu ku mɛmmɛ, kɛ̀ Sosɛfu tebìí yɑ̀ bɛ cicɛ kumɛ̀ kɛ dɔ̀: Kɛ̀ dɛ̀ yɛ̀mmɛ̀ Sosɛfu bo ti fɔ́kɛ́ mɛyɛi nti ò dɔ̀ɔ̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Kɛ̀ bɛ̀ɛ duɔ́ nkɛ̀ bɛ̀ɛ nɑ́kɛ́ Sosɛfu kɛ dɔ̀: A cicɛ yóó kú kɛ́bɛ́immu kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Tí dɑ nɑ́kɛ́ kɑ̀ɑ ti cĩ́ɛ̃́ mmɛyɛi nti dɑ dɔ̀ɔ̀ mɛ̀. A ti cĩ́ɛ̃́ nti yɛi, ti tú Kuyie nhɑ cicɛ do tũ nkù kó bɛtɔ̃mbɛ̀ mbɛ. Kɛ̀ Sosɛfuu keè dɛ kó tinɑ́ɑǹtì kɛ́kuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kòo kó bɛkótíbɛ̀ɛ kɔtoo bɛmɔ́mmɔmbɛ kɛ nínkú o ììkɛ̀ kɛ dɔ̀: Ti tú ɑ kó tidɑɑtì nti. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Kɛ̀ Sosɛfu dɔ̀: Di bɑ́ nyĩɛ̃̀kù, míì í tú Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Di do dɔ́ kɛ́ n dɔɔ̀ mɛyɛi mmɛ kɛ̀ Kuyie mmɛ mmɛ̀ pèntɛ mɛsɑ̀ɑ̀, kɛ bo dɛɛtɛ́ kubotí pɛ́u, kɛ́ndònnɛ̀ di wúómmɛ̀ yíe. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Bɑ́ nyĩɛ̃̀kùnɛ̀ n yó ndi tɔmu díndi nɛ̀ di bí. Mɛm̀mɛ, ò bɛ̀ bɑ̀ńtɛ̀mɛ̀, kɛ́nɑ́ríkùnnɛ bɛ yɛ̀mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Sosɛfu nɛ̀ o kɔbɛ kɛ̀ bɛ̀ mbo Esibiti, kɛ̀ Sosɛfu dɔ̀ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ tɛpíítɛ̀ (110), ");
INSERT INTO tbzsim_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","kɛ́yɑ̀ o birɛ Efɑdɑimmu yɑɑ̀bí kɛ́yɔ o birɛ Mɑnɑnsee birɛ Mɑkii bí. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kɛ̀ Sosɛfuu nɑ́kɛ́ o kɔbɛ kɛ dɔ̀: N yóó kúmu. Kuyie nyó nyɛ̃́mu di kpɛ́í, kɛ dí wɛ̃tɛnɛ̀ kù do yɛ̃ nkù yóó duɔ́ ndìì ɛì Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Kɛ̀ dɛ yiè tùɔ̀kɛ, kɛ̀ Kuyie ndi dènnɛ, kɛ̀ di yɛtì dí ntɔ n kṹɔ̃̀. Kɛ bɛ̀ɛ yie nkɛ́yú Kuyie nyètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Sosɛfu yóó kú kɛ mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ tɛpíítɛ̀ (110) ntɛ kɛ́kú kɛ̀ bɛ̀ɛ ò ɑ̃nnɛ́ mutie mùù bo nte kòò bɑ́ɑ́ pɑ̃ɑ̃kɛ, kóò ɑ̃nnɛ́ ditɔu Esibiti tenkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ntɛ Sɑkɔbu bí ìì do ò nɛínɛ̀ kɛ́kò nhEsibiti i yètɛ̀, bɑ́ wè nɛ̀ o cĩ́ɛ̃̀tɛ̀ kɔbɛ: ");
INSERT INTO tbzsim_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Dubɛnni nɛ̀ Simmɛɔ̃ɔ̃ nɛ̀ Defii nɛ̀ Sudɑɑ, ");
INSERT INTO tbzsim_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","nɛ̀ Isɑkɑɑ nɛ̀ Sɑbunɔɔ nɛ̀ Bɛnsɑmɛɛ, ");
INSERT INTO tbzsim_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","nɛ̀ Dɑnni nɛ̀ Nɛfutɑdii nɛ̀ Kɑdi nɛ̀ Asɛɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Sɑkɔbu bí nɛ̀ o yɑɑ̀bí bɛmɔu bɛ̀ do bo sipísìyiekɛ̀ ndi. Sosɛfu do diɛ nkɛ́mbomu Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Kɛ̀ Sosɛfuu kú kɛ̀ dɛ̀ ḿboní kòo tebìí kú, bɛ kó kutɔ̃nkù kumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Kɛ̀ Isidɑyɛɛribɛɛ piɛ́, kɛ́sṹṹ nkɛ́píɛ ndihɛì, kɛ́nkpénkú. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Kòo kpɑ̀ɑ̀tì pɑ̀nwè mɔùu buotɛ́ wèè í yĩ̀ɛ̃́tɛ́ Sosɛfu, ");
INSERT INTO tbzsim_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","kɛ́nɑ́kɛ́ o kɔbɛ kɛ dɔ̀: Wéntɛ́nɛ̀ Isidɑyɛɛribɛ sũ̀ṹnkomɛ̀ kɛ kpénkú kɛ ti pɛ̃nkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tí yɑ̀nnɛ̀ dɛ̀ yóó yĩ́mɛ̀ kɛ̀ bɛ̀ bɑ́ nsṹũnko. Dikpɑ̀nnì mɑrì yɑ̀ɑ̀ bo ɑ̃nnɛ́ kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ nɛ̀ ti dootitɔbɛ̀ kɛ́ ti dókɛ́nɛ̀ kɛ́yɛ̀ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Mɛm̀mɛ kɛ̀ bɛ̀ɛ wɑɑ́ mbɛ̀ɛ̀ yó mbɑɑ bɛtɔ̃mbɛ̀ kɛ̀ bɛ̀ mbɛ̀ bɑ̀ɑ, kɛ bɛ̀ fɛ̃́ũnko. Mɛm̀mɛ kɛ̀ bɛ̀ɛ mɑɑ́ Pitommu nɛ̀ Dɑmmusɛsi kó yɛhɛkɛ̀, kòo kpɑ̀ɑ̀tì bo nhɑ̃ɑ̃̀ tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Kɛ̀ bɛ̀ mbɛ̀ fɛ̃́ũnko kɛ̀ bɛ̀ nɛ́ dɔkɛ sṹũnko kɛ kpénkú, kɛ̀ bɛ̀ bɛ̀ dé. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Kɛ̀ Esibiti kɔbɛ nfɛ̃́ũnko Isidɑyɛɛribɛ nɛ̀ muwɛ̃rímú kɛ̀ bɛ̀ pĩ mmutɔ̃nkperímù. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Bɛ̀ do bɛ̀ fɛ̃́ũnko mɛdiɛ̀ mmɛ, kɛ̀ bɛ̀ nɑ̀ù titɑ̃́tì kɛ piiku yɛdombiɛ nkɛ pĩ́ ndɛpɑɑ nkó mutɔ̃mmú. Bɛ̀ do bɛ̀ dɔ̀ɔ̀ri mɛmmɛ nɛ̀ kuyonku nku. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Kòo kpɑ̀ɑ̀tìi nɑ́kɛ́ Sifɑɑ nɛ̀ Puɑɑ bɛ̀ɛ̀ pɛinko Ebedeebɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Kɛ̀ di níí pɛinko Ebedeebɛ kɛ yɑ̀ kɛ̀ dɛnitidɑbirɛ ndɛ, dí dɛ̀ kùɔ, kɛ̀ dɛnitipobirɛ mɛ nni ndɛ, di yóu kɛ̀ dɛ̀ nfòù. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Bɛnitipòbɛ̀ bɛ̀ɛ̀ pɛinko kɛ̀ bɛ̀ɛ depɛ Kuyie nkɛ́yetɛ okpɑ̀ɑ̀tì bɛ̀ nɑ̀kɛ́ tì, kɛ níí yóu initidɑbí kɛ̀ ì ńfòù. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kòo kpɑ̀ɑ̀tìi bɛ̀ yu kɛ́ bɛ̀ bekɛ kɛ dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di dɔɔri mɛmmɛ kɛ you initidɑbí kɛ̀ ì fòù? ");
INSERT INTO tbzsim_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Kɛ̀ bɛ̀ dɔ̀: Ebedeebɛ kó bɛnitipòbɛ̀ í dònnɛ̀ Esibiti kɔbɛ, bɛ̀ kpeńnìmu kɛ ɔ̃ nyóó pɛitɛ́ kɛ̀ wèè pɛinko kòò mu nyí tùɔ̀koo. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛɛ sṹṹ nkɛ́kpenkɛ kɛ̀ Kuyie ndɔɔ̀ bɛ̀ɛ̀ pɛinko mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Kɛ̀ bɛ̀ɛ piɛ́ ibí bɛ cɛ̃́ĩ kɛ yɛ̃́ bɛ̀ démɛ̀ Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kòo kpɑ̀ɑ̀tìi duɔ́ ndinùù o kɔbɛ kɛ dɔ̀ bɛ̀ mbuɔ̀nko Ebedeebɛ pɛí ìì nitidɑbí kukó nNiidi miɛkɛ, kɛ you initipobí. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Kɛ̀ Defii nɑɑ̀mùnkù kou mɔùu puokɛ bɛ nɑɑ̀mùnkù kóo sɑpɑ̀ɑ̀ mmɔù. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Kòo púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ, kɛ́yɑ̀ dɛ̀ wennimɛ̀, kɛ́ dɛ̀ sɔ̀nnɛ bɛtɑ̃̀ɑ̃̀bɛ̀ bɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Ò tɛ̃́nkɛ í nnɑ kɛ bo ndɛ̀ sɔ̀rì, kɛ́tɛí dikũ̀mɑ̀nnì kùtìnɔ́ɔ̀, kɛ́ dɛ̀ ɑ̃nnɛ́ di miɛkɛ, kɛ́tɑ kɛ́dɔú nkukó nNiidi tipèntì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Kɛ̀ dɛbirɛ tɑ̃ũ̀ ńsɔri mɛkɛntímɛ̀ kɛ bo yɑ̀ dɛ̀ɛ̀ yóó tuɔkɛní dɛbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Kòo kpɑ̀ɑ̀tì kóo sɑpɑ̀ɑ̀ ńtɑ kukó mmuhɔ̀rìmù kɛ nɛínɛ̀ o dúɔ̀bɛ̀. Kòo dúɔ̀bɛ̀ ńcentì kukó ntɑkɛ́, kòo yɑ̀ dikũ̀mɑ̀nnì, kɛ́tɔ̃ nho kóo tɔ̃ntì kòo dì tùótɛ́ní. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Kòo pootɛ kɛ́yɑ̀ dɛnitidɑbirɛ kɛ̀ dɛ̀ kuɔ̀, kɛ̀ mɛsémmɛ̀ɛ ò pĩ nkòò dɔ̀: Ebedeebɛ kó dɛbirɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Kɛ̀ dɛbirɛ tɑ̃ũ̀ũ ò bekɛ kɛ dɔ̀: A dɔ́ kɛ̀ ń kɔtɛ kɛ́ dɑ wɑɑnní Ebedee kóo nitipòkù mɔù kòò ndɛ̀ ndɑ yɑ̃ɑ̃nkoɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Kòò dɔ̀: Ɛ̃ɛ̃, kɔtɛ! Kòo kɔtɛ kɛ́yúní dɛbirɛ yɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Kòo kpɑ̀ɑ̀tì kóo sɑpɑ̀ɑ̀ ndɔ̀: Túótɛ́ dɛbirɛ diɛ nkɛ́ ndɛ̀ nni nyɑ̃ɑ̃nko kɛ̀ n dɑ yietí. Kòo nitipòkùu dɛ̀ tùótɛ́ kɛ́nyɑ̃ɑ̃nko. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Kɛ̀ dɛ̀ɛ kótɛ́ kòo dɛ̀ duɔ́ nhokpɑ̀ɑ̀tì sɑpɑ̀ɑ̀, kɛ̀ dɛ̀ɛ nɑɑ́ nho birɛ, kòo dɛ̀ yu kɛ dɔ̀: Mɔyiisi, dɛ̀ɛ̀ tu ò dɛ̀ dɛ̀itɛ mɛniɛ mmiɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Kɛ̀ Mɔyiisii kótɛ́ kɛ́kɔtɛ o kɔbɛ borɛ̀, kɛ́yɑ̀ bɛ̀ bɛ̀ fɛ̃́ũnkonɛ̀mɛ̀ mutɔ̃mmú, kɛ́yɑ̀ Esibiti kou mɔù puotìmɛ̀ o kou Ebedee. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Kòo wéntɛ́ wéntɛ́, ò í nyɑ̀ òmɔù, kɛ́potɛ́ Esibiti kou kɛ́kuɔ, kɛ́kũnnɛ́ mubirímú miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Kɛ̀ dɛ̀ɛ wentɛ́ kòò tó yɛ̀ diyiè tɛrì kɛ́yɑ̀ Ebedeebɛ mɑ́ɑ̀ kɛ̀ bɛ̀ kpɑ̀ nkòo bekɛ wèè í nɑɑti kɛ dɔ̀: Dɛ̀ dòmmɛ kɑ̀ɑ puotì ɑ tebitɛ? ");
INSERT INTO tbzsim_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Kòo ò tɛ̃̀ńnɛ́ kɛ dɔ̀: We ndɑ pĩ ntikpɑ̀tì kɑ̀ɑ bo nti bekùnɛ̀? A dɔ́ kɛ́ n kuɔ ɑ wee kùɔmɛ̀ mmɛ Esibiti kouɑ̀? Kɛ̀ Mɔyiisi kɔ̃m̀bùɔ̀tìi do, kòò dɔ̀: Bɛnìtìbɛ̀ kèèmu ti nnɑ́ɑǹtɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Kòo kpɑ̀ɑ̀tìi keè dɛ̀ɛ̀ dɔ̀ɔ̀, kɛ́ndɔ́ kɛ́kuɔ Mɔyiisi. Kòo cokɛ́ kɛ́kɔtɛ Mɑndiyɑ̃ɑ̃ kó kɛtenkɛ̀ kɛ́nkɑri tɛbintɛ bɛ̀ keú tɛ̀ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Mɑndiyɑ̃ɑ̃ tenkɛ̀ kɔbɛ do mɔkɛ ikuɔ́ nìùtì mɔù nwe kòò mɔ̀kɛ bɛsɑpɑ̀mbɛ̀ bɛ̀yiekɛ̀, kɛ̀ bɛ̀ɛ tɑnní tɛbintɛ kɛ bo dó kɛ́nii mbɛ cicɛ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kɛ̀ bɛnɑɑcɛ̃mbɛɛ bɛ̀ bɛ̀ti, kɛ̀ Mɔyiisii yetɛ kɛ́nii mbɛ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Kɛ̀ bɛ̀ɛ wɛ̃tɛ kɛ́kò mbɛ cicɛ borɛ̀ Deuyɛɛdi, kòo bɛ̀ bekɛ kɛ dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di konní mɛcɑ̃ɑ̃ nyíe? ");
INSERT INTO tbzsim_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Kɛ̀ bɛ̀ dɔ̀: Esibiti kou mɔù weè ti dɛɛtɛ́nɛ̀ bɛnɑɑcɛ̃mbɛ, kɛ nìi nti wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Kɛ̀ bɛ̀ cicɛ dɔ̀: Ò borɛ? Dɛ̀ dòmmɛ kɛ̀ di kɛ̀ nhò yóu? Kɔtɛnɛ̀ kóò yuní kòo di. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mɛm̀mɛ kɛ̀ Mɔyiisi ḿbo dɛ kóo nìtì borɛ̀, kòo ò duɔ́ nho kóo sɑpɑ̀ɑ̀ nSefodɑɑ kòo puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Kòo púó nkɛ́pɛitɛ́ dɛnitidɑbirɛ, kòo dɛ̀ yu kɛ dɔ̀ Mbo-Kupɔ̀ɔ̀kù. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Kɛ̀ dɛ̀ɛ mɔntɛ kɛ̀ Esibiti kóo kpɑ̀ɑ̀tìi kú, kɛ̀ Isidɑyɛɛribɛ bɑɑ nfɛ̃́ũ̀rìnɛ̀ mutɔ̃mmú kɛ kuɔ̀, kɛ̀ bɛ dɑbùò ntuɔkɛ Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Kɛ̀ kùu keè bɛ dɑbùò nkɛ́dentɛní mɛtɑummɛ̀ kù do dɔ̀ɔ̀nɛ̀mɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu, ");
INSERT INTO tbzsim_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","kɛ́wéntɛ́ kɛ́yɑ̀ Isidɑyɛɛribɛ kɛ́bɑntɛ́ bɛ̀ fɛ̃́ũ̀rìmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mɛm̀mɛ kɛ̀ Mɔyiisi ńcɛ̃mmú o cɔ̀kù Mɑndiyɑ̃ɑ̃bɛ kuɔ́ nìùtì Setidoo wũɔ̃, kɛ́kɔtɛnɛ̀ dikpɑ́ɑ̀, kɛ́tuɔkɛ Odɛbu, Kuyie ntɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Kɛ̀ ti Yiɛ̀ nKuyie nhò bɛnkɛ kumɑ́ɑ̀, kòo yɑ̀ difɑ̃pèù mɑrì kɛ̀ dì cɔ̀ú nfɛhɑ̃ɑ̃dɛɛ̀nfɛ̀, bɑ́ ti fɑ̃ɑ̃̀tì í cɔ́ú. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Kɛ̀ Mɔyiisii yɑ̀ difɑ̃pèù cɔ̀úmmɛ̀ kɛ́dɑutɛ́ kɛ bo yɑ̀ mùù dɔ̀ɔ̀ri, mùù te kɛ̀ difɑ̃pèù cɔ̀ú mbɑ́ tifɑ̃ɑ̃̀tì í cɔ́ú. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Kɛ̀ ti Yiɛ̀ nKuyie nyɑ̀ ò dɑutɛ́mɛ̀ kɛ bo yɑ̀, kóò yu kɛ dɔ̀: Mɔyiisi, Mɔyiisi! Kòò dɔ̀: Ntɛ mí. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kɛ̀ Kuyie ndɔ̀: Bɑ́ɑ́ tɔ́ɔ́nní diɛ. Dɛitɛ ɑ nɛùtì, ɑ cómmú dìì bòrì cɑ̃̀ɑ̃́mmu, ");
INSERT INTO tbzsim_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","kɛ yíɛ́ kɛ dɔ̀: N tú Kuyie nku, ɑ yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu, bɛ̀ do tũ nkù. Kɛ̀ Mɔyiisii sɔnnɛ o ììkɛ̀, ò í ndɑ̀ɑ́tí kɛ bo nwúó nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: N yɑ̀mu n kó bɛnìtìbɛ̀ yo mmɛ̀ɛ̀ sémmɛ̀ Esibiti, n kèèmu bɛ̀ bɛ̀ fɛ̃́ũnkomɛ̀ kɛ̀ bɛ̀ kuɔ̀, n yɑ̀mu bɛ̀ fɛ̃́ũ̀rìmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Dɛɛ̀ te kɛ̀ n cùtɛ́ní kɛ bo bɛ̀ dɛɛtɛ́nɛ̀ Esibiti kɔbɛ, kɛ́ bɛ̀ kɔ̀tɛnɛ̀ kɛtenkɛ̀ sɑ̀ɑ̀kɛ̀ kɛ̀ɛ̀ dɛu, mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃̀ nkɛ̀. Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Itiibɛ nɛ̀ Amɔriibɛ nɛ̀ Pedisiibɛ nɛ̀ Efiibɛ nɛ̀ Sebusiibɛ bɛ̀ bo kɛ̀ɛ̀ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Isidɑyɛɛribɛ kuɔ́mmu kɛ̀ n kèè bɛ̀ dɑbùò, kɛ yɑ̀ Esibiti kɔbɛ bɛ̀ fɛ̃́ũnko mɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","N dɑ tɔ̃mmu Esibiti kóo kpɑ̀ɑ̀tì borɛ̀. Kɔtɛ kɛ́dennɛ n kó ibí Isidɑyɛɛribɛ Esibiti miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Kɛ̀ Mɔyiisii nɑ́kɛ́ Kuyie nkɛ dɔ̀: N tú we, kɛ̀ míì bo kɔtɛ Esibiti kóo kpɑ̀ɑ̀tì borɛ̀ kɛ́dennɛ Isidɑyɛɛribɛ? ");
INSERT INTO tbzsim_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kɛ̀ Kuyie ndɔ̀: N yó ndɑ bonɛ̀mu, ntɛ dɛ̀ɛ̀ yóó bɛnkɛ míì dɑ tɔ̃mmɛ̀: Kɑ̀ɑ bɛ̀ dènnɛ dìì mɔ̀nnì di mpĩ́ n tɔ̃mmú di ntɑ̃rì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Kɛ̀ Mɔyiisi dɔ̀: M bo kɔtɛ kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀ Kuyie ndi yɛmbɛ̀ do tũ nkù, kuù n tɔ̃nní di borɛ̀. Kɛ̀ bɛ̀ nɛ́ yĩ: Ku yètìrì tu bɑ? N dɔ̀ bɑ? ");
INSERT INTO tbzsim_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Kɛ̀ Kuyie nhò nɑ̀kɛ́ kɛ dɔ̀: N tú wèè bo wè nwe. Kɛ̀ bɛ̀ dɑ bekɛ ɑ dɔ̀: Wèè yètìrì tu Mbo, weè n tɔ̃nní di borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Kɛ̀ Kuyie nwɛ̃tɛ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Mí ndi Yiɛ̀ nKuyie di yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu bɛ̀ do tũ nkù, míì dɑ tɔ̃ mbɛ borɛ̀, n yètìrì mɛ ntú, di yó mmɛ nni n yu sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Kɔtɛ kɛ́tíí nyIsidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ dɔ̀: Mí ndi Yiɛ̀ nKuyie ndi yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu bɛ̀ do tũ nkù míì tu n yɑ̀mu bɛ̀ di fɛ̃́ũnkomɛ̀ Esibiti kɛ dɔ́ kɛ́ di dɛɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","N dɔ́ kɛ́ di dennɛmu Esibiti bɛ̀ di fɛ̃́ũnko dɛ̀, n yóó di kɔtɛnɛ̀ mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃̀ ndɛ̀ ndɛ, Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Itiibɛ nɛ̀ Amɔriibɛ nɛ̀ Pedisiibɛ nɛ̀ Efiibɛ nɛ̀ Sebusiibɛ bɛ̀ bo kɛ̀ɛ̀ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Kɑ̀ɑ bɛ̀ nɑ̀kɛ́ bɛ̀ í yóó yetɛ. Á nnɛínɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ̀ di kɔtɛ kɛ́yɑ̀ Esibiti kóo kpɑ̀ɑ̀tì, kóò nɑ̀kɛ́ kɛ dɔ̀ mí ndi Yiɛ̀ nKuyie díndi Ebedeebɛ di tũ nkù, míì di bɛnkɛ m mɑ́ɑ̀ kɛ tú ò di yóu kɛ̀ di ce nyɛwe yɛ̀tɑ̃ɑ̃ti kɛ́kɔtɛ dikpɑ́ɑ̀ cuokɛ̀ kɛ́ n fíé iwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","N yɛ̃́mu kɛ tú okpɑ̀ɑ̀tì í yóó yie nkɛ̀ dí yɛ̀ kɛ̀ n sɑ̀ɑ̀ í ò dɔ̀ɔ̀nɛ̀ muwɛ̃rímú mmu. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Dɛɛ̀ te kɛ̀ n yóó bɛnkɛ n wɛ̃rímú, kɛ́dɔɔ̀ tidiɛtì pɛ́u, kòo kpɑ̀ɑ̀tì di yóu kɛ̀ di yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","M bo duɔ́ nkɛ̀ Esibiti kɔbɛɛ di dɔɔ̀ mɛsɑ̀ɑ̀, di í yóó yɛ̀ di nɔu sitetìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Bɑ́ wèè nitipòkù bo mɔɔ o pɛɛtitɔù yoo wèè bo o cĩ́ɛ̃̀tɛ̀ idíítí nɛ̀ mɛsɔɔ nnɛ̀ tiyɑ̀ɑ̀tì, kɛ̀ di toú ndi kó bɛdɑpɑ̀mbɛ̀ nɛ̀ bɛsɑpɑ̀mbɛ̀. Di yó nyɛtì kɛ tɔmu Esibiti kɔbɛ kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Kɛ̀ Mɔyiisi tɛ̃́nnɛ́ kɛ dɔ̀: Bɛ̀ í yóó yie, bɛ̀ í yó n kéntɛ́. Bɛ̀ yóó yĩ́mu ti Yiɛ̀ nKuyie mmɑkù í m bɛnkɛ kumɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: A tɔ bɑ? Kòò dɔ̀: Kupɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Kɛ̀ kù dɔ̀: Dɔú nku kɛtenkɛ̀. Kòo kù dɔú nkɛ̀ kùu nɑɑ́ nfɛwɑ̀ɑ̀fɛ̀, kòo cokɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Pĩ́ nfɛ yóú. Kòo pĩ́ nfɛ yóú kɛ̀ fɛ̀ɛ wɛ̃tɛ kɛ́nɑɑ́ nkupɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Kɛ̀ kù dɔ̀: A yóó mɛ nyĩ́ kɛ̀ bɛ̀ɛ bɑntɛ́ mí ndi Yiɛ̀ nKuyie, nhɑ yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu bɛ̀ do tũ nkù míì dɑ bɛnkɛmɛ̀ m mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Kɛ yíɛ́ kɛ́bɛ́i nkɛ dɔ̀: Bɑɑ́ ɑ nɔ̀ùtɛ̀ ɑ pɛ̃tɛ́mpĩɛ̃̀kù. Kɛ̀ Mɔyiisii bɑɑ́, kɛ́ nyóó dɛitɛní o nɔ̀ùtɛ̀ kɛ sɔ̃́ ntikɔ̀ntì tɛ̀ pĩ nkɛ̀ tɛ̀ pɛikɛ kɛ do ntipɑ̀ɑ̀kóntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Wɛ̃tɛ kɛ́bɑɑ́ ɑ pɛ̃tɛ́mpĩɛ̃̀kù. Kòo bɑɑ́ kɛ́ nyóó dɛitɛní o nɔ̀ùtɛ̀ kɛ sɔ̃́ ntɛ̀ nɑɑ́ ntɛ̀ do dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Kɛ̀ kù dɔ̀: Kɑ̀ɑ dɔ̀ɔ̀ tidiɛtì ketitì kɛ̀ bɛ̀ yetɛ, ɑ yóó dɔɔ̀ dɛdɛ́rɛ̀ kɛ̀ bɛ̀ɛ yiemmu. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Kɑ̀ɑ dɔ̀ɔ̀ dɛdɛ́ mɛmmɛ, kɛ̀ bɛ̀ yetɛ ɑ́ yɛ̃ntɛ́ kukó nNiidi kó mɛniɛ nkɛ́cóú nkɛtenkɛ̀ mɛ̀ yóó nɑɑ́ mmɛyĩ̀ĩ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Kɛ̀ Mɔyiisi dɔ̀: N dɑ bɑ́ɑ́mmu n Yiɛ̀ nKuyie, n yí tú onɑ́ɑǹtì. Dɛ̀ í tú yíe nyoo wenkɛ yoo sòkɛ, nɛ̀ m bomɛ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: We nhɑ̃nnɛ́ onìtì dinùù? We nhɔ̃ nte kòo nìtì nɔ́ndɛnfɛ̀ɛ dɑri yoo wèe ɔ̃? Yoo wè nwúó? Yoo wèe yɛ̃ĩ? Dɛ̀ í tú mí nKuyie nnɑɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Kɔtɛ! Míì yó ndɑ nɑ́ɑ́ nhɑ yó nnɑ́ɑ́ ntì, kɛ dɑ bɛnkú ɑ yó nnɑ́ɑ́ ntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Kɛ̀ Mɔyiisi dɔ̀: Kuyie, n dɑ bɑ́ɑ́mmu, tɔ̃ nhotɔù mɔù. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛɛ pɛikɛ Mɔyiisi mɛdiɛ̀. Kɛ̀ kù dɔ̀: Defii kó kuwuɔ nkou ɑ kóo kótì Anɔɔ nɔmmu kɛ nɑ́ɑ́. Ò kèrínímu kɛ bo dɑ co, kɛ dɑ yɑ̀ kòo yɛ̀mmɛ̀ɛ nɑrikɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Á ò nɑ̀kɛ́ n dɑ nɑ̀kɛ́ tì, kóò tùo n nɑ́ɑǹtì, míì yó ndi bonɛ̀, kɛ di nɑ́ɑ́ ndi yó nnɑ́ɑ́ ntì, kɛ di bɛnkú di yó nnɑ́ɑ́ ntì nɛ̀ di yó ndɔɔri dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Anɔɔ weè yó ncómmú ɑ fɔ̃̀tìrì kɛ nɑ́ɑ́nnɛ̀ bɛnìtìbɛ̀, kɛ̀ nní ndɑ duɔ̀ ntinɑ́ɑǹtì kɑ̀ɑ ò nɑ̀ɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","A yó ntɔ ku mpɑ̀ɑ̀ti nku kɛ dɔɔrinɛ̀ tidiɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Kɛ̀ Mɔyiisii kò nho cɔ̀kù Setidoo borɛ̀, kóò nɑ̀kɛ́ kɛ dɔ̀: N dɔ́ kɛ́kɔtɛ n kɔbɛ borɛ̀ ndɛ Esibiti kɛ́yɑ̀ bɛ̀ bo nkpɑɑ́ fòù. Kɛ̀ Setidoo dɔ̀: Kɔtɛ kɛ̀ dɛ̀ ńnɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi Mɑndiyɑ̃ɑ̃ kó kɛtenkɛ̀ miɛkɛ kɛ dɔ̀: Wɛ̃tɛ Esibiti, bɛ̀ɛ̀ do dɔ́ kɛ dɑ kuɔ bɛ̀ kumu bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kɛ̀ Mɔyiisii túótɛ́ o pokù nɛ̀ o bí kɛ́dee nsɑ̃mmɑrímúbɛ̀, kɛ́túótɛ́ Kuyie nkó kupɑ̀ɑ̀ti kɛ́pikú kɛ̀ bɛ̀ nwɛ̃ti Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: N dɑ duɔ́mmu muwɛ̃rímú kɑ̀ɑ bo dɔɔ̀ tidiɛtì tibotí tibotí okpɑ̀ɑ̀tì ììkɛ̀, n nɛ́ yóó kpénkùnnɛmu o to kòo yetɛ di bo yɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Á nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Ti Yiɛ̀ nKuyie ntú: Isidɑyɛɛribɛ kó kuwuɔ ntú m birɛ ndɛ, n kóo po, ");
INSERT INTO tbzsim_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","míì tu ɑ́ yóu m birɛ kɛ̀ dɛ̀ɛ yɛ̀, kɛ́ n fìé iwũɔ̃, kɑ̀ɑ yetɛ m bo kuɔ ɑ kóo po. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Kɛ̀ Mɔyiisi nkérí kɛ́ndɔ́ kɛ́yié nkucɛ dibòrì mɑrì, kɛ̀ ti Yiɛ̀ nKuyie nkɔtɛní kɛ́ndɔ́ kóò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Kòo pokù Sefodɑɑ túótɛ́ ditɑ̃́rì dìì ɑ̃ mɛnɑtimɛ̀ kɛ́cɑ̃ntɛ́ o birɛ, kɛ́kɑ́ɑ́kɛ́ kutɑkɔ̃̀nkù Mɔyiisi tɑkɛ́ kɛ dɔ̀: A tú n kpɛ́í mmɛyĩ̀ĩ̀ nkóo dɔù nwe. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Kɛ̀ ti Yiɛ̀ nKuyie nyóu Mɔyiisi kɛ́ítɛ́. Mɛm̀mɛ Sefodɑɑ yumɛ̀ Mɔyiisi kɛ dɔ̀: Mɛyĩ̀ĩ̀ nkóo dɔù, mucɑ̃mmù kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Anɔɔ kɛ dɔ̀: Kɔtɛ kɛ́co Mɔyiisi dikpɑ́ɑ̀. Kɛ̀ Anɔɔ kɔtɛ, kóò yɑ̀ Kuyie ntɑ̃rì kóò ɔrí. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Kòo ò nɑ̀kɛ́ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tìì kó dimɑ̀ɑ̀ kóò nɑ̀kɛ́ kù yɛ̃ nwèe dɔɔ̀ tìì diɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mɛm̀mɛ kɛ̀ bɛ̀ɛ nɛi kɛ́kɔtɛ kɛ́tíí nyIsidɑyɛɛribɛ kó bɛkótíbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Kɛ̀ Anɔɔ bɛ̀ nɑ̀kɛ́ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ tìì kó dimɑ̀ɑ̀ Mɔyiisi, kɛ́dɔɔ̀ tidiɛtì kɛ̀ bɛ̀ɛ yɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","kɛ́yie. Kòo bɛ̀ nɑ̀kɛ́ ti Yiɛ̀ nKuyie nyɑ̀mɛ̀ bɛ̀ fɛ̃́ũ̀rìmɛ̀ kɛ dɔ́ kɛ́ bɛ̀ dɛɛtɛ́, kɛ̀ bɛ̀ɛ do kɛ́nínkú Kuyie n yììkɛ̀ kɛ́ kù bɑ̀ńtɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ kɔtɛ kɛ́nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Ti Yiɛ̀ nKuyie, tínti Isidɑyɛɛribɛ ti tũ nkù tu ɑ́ ti yóu kɛ̀ tí kɔtɛ dikpɑ́ɑ̀ kɛ́dɔɔ̀ dibɑnni, kɛ́dɛ́úkùnnɛ ku yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Kɛ̀ Esibiti kóo kpɑ̀ɑ̀tì dɔ̀: We ntú di Yiɛ̀ nKuyie nkɛ̀ m bo yie nho kpɛti kɛ́ di yóu kɛ̀ dí yɛ̀? N yí ò yɛ̃́, m mɛ nyí yóó di yóu kɛ̀ dí yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ dɔ̀: Ti Yiɛ̀ nKuyie ntínti Ebedeebɛ ti tũ nkù ti bɛnkɛmu kumɑ́ɑ̀. Á ti pɑ̃ kucɛ kɛ̀ tí ce nyɛwe yɛ̀tɑ̃ɑ̃ti kɛ́kɔtɛ dikpɑ́ɑ̀ kɛ́ kù fìé iwũɔ̃, kɛ̀ mɛɛ̀ dɔkɛ kù bo duɔnní mumɔmmú kɛ̀ ti kú, yoo ti dootitɔbɛ̀ɛ tí kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Kòo kpɑ̀ɑ̀tì dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di sukíí Isidɑyɛɛribɛ kɛ̀ bɛ̀ bo yóu mutɔ̃mmú? Kɔtɛnɛ̀ di tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Di mmɔ̀nnì ndi bɛ̀ sũ̀ṹmmɛ̀ kɛ̀ di wɛ̃̀tɛ kɛ dɔ́ kɛ́duɔ́ nkɛ̀ bɛ̀ɛ yóu mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Dɛ kó diyiè mɔ́mmɔnni kòo kpɑ̀ɑ̀tìi nɑ́kɛ́ bɛ̀ɛ̀ ni mutɔ̃mmú nɛ̀ bɛ̀ɛ̀ bɛ̀ bɑɑ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Di tɛ̃́nkɛ bɑ́ nduɔ̀ nyIsidɑyɛɛribɛ timúkpetì kɛ̀ bɛ̀ piikunɛ̀ yɛdombiɛ. Bɛ̀ ńkɔrì bɛ mɔ́mmɔmbɛ kɛ tì wɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Bɛ̀ mɛ mbɑɑ yó mpiiku yɛdombiɛ nkɛ̀ yɛ̀ tùɔ̀kù yɛ̀ sòò mɑ̀mɛ̀ mmɛ, di bɑ́ɑ́ yɑɑtɛ. Bɛtɔ̃nnɛ́kótíbɛ̀ mbɛ, dɛɛ̀ te kɛ̀ bɛ̀ tu, tí bɛ̀ yóu kɛ̀ bɛ̀ɛ kɔtɛ kɛ́fíé Kuyie nyiwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Kɛ̀ bɛ̀ pĩ mmutɔ̃mmú mɛdiɛ̀ mbɛ̀ í yóó pɛ́tɛ́ bɛmɑ́ɑ̀ kɛ́ndɑkɛnɛ̀ tiyɑ́ɑ̀bìsínɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Bɛ̀ɛ̀ bɑkɛ́ mutɔ̃mmú nɛ̀ bɛ̀ɛ̀ mù pɑkɛ́, kɛ̀ bɛ̀ɛ kɔtɛ kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Okpɑ̀ɑ̀tì tu bɛ̀ tɛ̃́nkɛ bɑ́ ndi duɔ̀ ntimúkpetì. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Kɔtɛnɛ̀ kɛ́wɑmmú timúkpetì! Díì yɛ̃́ di yóó tì pɛ̀tɛ́ dɛ̀, kɛ bɑɑ nɛ́ mpiiku yɛdombiɛ nkɛ̀ yɛ̀ mmɑ̀nnɛ̀ yɛ̀ sòò ɔ̃ mmɑ̀mɛ̀, ti í yóó yɑɑtɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Kɛ̀ Isidɑyɛɛribɛɛ cíɛ́tɛ́ Esibiti omɔu miɛkɛ kɛ́nwɑɑ̀ ntimúkpetì. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Bɛ̀ɛ̀ bɛ̀ bɑ̀ɑ kɛ̀ bɛ̀ mbɛ̀ kpɑ̀nnɛ̀ kɛ tú: Pííkúnɛ̀ yɛdombiɛ nkɛ̀ yɛ̀ɛ tuɔkɛ bɛ̀ sòò di duɔ̀ ntimútì kɛ̀ yɛ̀ mɑ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Kòo kpɑ̀ɑ̀tì kɔbɛ bɛ̀ɛ̀ bɑkɛ́, kɛ̀ bɛ̀ ḿpuotì Isidɑyɛɛribɛ bɛ̀ɛ̀ bɑ̀ɑ bɛtɔ̃mbɛ̀ kɛ tú: Dɛ̀ yĩ́mɛ wenkɛ nɛ̀ yíe nkɛ̀ di í pìíkú yɛdombiɛ nkɛ̀ yɛ̀ tùɔ̀kɛ di sòò piiku kɛ̀ yɛ̀ mɑ̀mɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Kɛ̀ Isidɑyɛɛribɛ bɛ̀ɛ̀ bɑ̀ɑ bɛtɔ̃mbɛ̀, kɛ̀ bɛ̀ɛ kɔtɛ kɛ́yɑ̀ okpɑ̀ɑ̀tì kɛ dɔ̀: Dɛ̀ dòmmɛ kɑ̀ɑ ti fɛ̃́ũnko mɛmmɛ, tínti ɑ kó bɛtɔ̃mbɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Bɛ̀ tɛ̃́nkɛ í ti duɔ̀ ntimútì kɛ tú tí mpiiku yɛdombiɛ nkɛ̀ yɛ̀ tùɔ̀kù yɛ̀ sòò mɑ̀mɛ̀, kɛ ti puotì kɛ dò nti cɑ̀ɑ̀rɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Kòo kpɑ̀ɑ̀tì dɔ̀: Di tú bɛtɔ̃nnɛ́díébɛ̀ mbɛ, bɛtɔ̃nnɛ́kótíbɛ̀. Dɛɛ̀ te kɛ̀ di tú di bo kɔtɛ kɛ́fíé di Yiɛ̀ nKuyie nyiwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Kɔtɛnɛ̀ kɛ́pĩ́ ndi tɔ̃mmú, bɛ̀ í yó ndi duɔ̀ ntimútì, di mɛ mbɑɑ nɛ́ yó mpiiku yɛdombiɛ nkɛ̀ yɛ̀ tùɔ̀kù yɛ̀ sòò ɔ̃ mmɑ̀mɛ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Kɛ̀ Isidɑyɛɛribɛ bɛ̀ɛ̀ bɑ̀ɑ bɛtɔ̃mbɛ̀, kɛ̀ bɛ̀ɛ bɑntɛ́ bɛ̀ bɑɑ bɛ̀ fɛ̃́ũnkomɛ̀mu kɛ dɔ́ bɛ̀ mpiiku yɛdombiɛ nkɛ̀ yɛ̀ tùɔ̀kù yɛ̀ sòò ɔ̃ mmɑ̀mɛ̀, bɛ̀ í yóó yɑɑtɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Kɛ̀ bɛ̀ nyɛtìní okpɑ̀ɑ̀tì borɛ̀ kɛ́yɑ̀ Mɔyiisi nɛ̀ Anɔɔ, kɛ̀ bɛ̀ bɛ̀ bɑ̀ɑ. Kɛ̀ bɛ̀ɛ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ti Yiɛ̀ nKuyie ndi wúómmu kɛ yóó di bekɛ́nɛ̀, díì te kòo kpɑ̀ɑ̀tì tɛ̃́nkɛ í dɔ́ ti kpɛti, díì ò duɔ́ ndisiè, kòò yóó ti kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Kɛ̀ Mɔyiisii bɛ́innɛ̀ ti Yiɛ̀ nKuyie nkɛ dɔ̀: Dɛ̀ yĩ́mɛ kɑ̀ɑ fɛ̃́ũnko ku mbotí? Dɛ̀ dòmmɛ kɑ̀ɑ n tɔ̃nní diɛ? ");
INSERT INTO tbzsim_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Nɛ̀ n kɔ̀tɛmɛ̀ kɛ yɑ̀ okpɑ̀ɑ̀tì koò bɛ́innɛ̀ ɑ kó diyètìrì, ò fɛ̃́ũnkomu ti kó kubotí, ɑ mɛ nyí kù dɛɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: A bo yɑ̀ di mmɔ̀nnì n yóó dɔɔ̀ dɛ̀ okpɑ̀ɑ̀tì. M bo ò dɔ̀ɔ̀nɛ̀ muwɛ̃rímú kòò di yóu kɛ̀ dí yɛ̀. M bo ò ɛ̃̀ṹtɛ́ kòo di bɛti. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kóò nɑ̀kɛ́ kɛ dɔ̀: Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","M bɛnkɛmu m mɑ́ɑ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu n túmɛ̀ di Yiɛ̀ nKuyie nkɛ̀ kpeńnì. Bɛ̀ nɛ́ do í yɛ̃́ kɛ dò mmíì tu bɛ Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","N do bɛ̀ tɑunnɛ̀mu m mɑ́ɑ̀, kɛ dɔ̀ n yóó bɛ̀ duɔ́ nKɑnnɑhɑ̃ɑ̃, kɛtenkɛ̀ bɛ̀ do bo kɛ̀ kupɔ̀ɔ̀kù. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","N kèèmu Esibiti tenkɛ̀ kɔbɛ di fɛ̃́ũnkomɛ̀ kɛ̀ di kuɔ̀ nkɛ̀ n dèntɛní ti kó mɛtɑummɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Dɛɛ̀ te kɛ̀ n tu ɑ kɔtɛ kɛ́nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀ n tú: Mí ndi Yiɛ̀ nKuyie n yóó di dɛɛtɛ́nɛ̀mu mudɑɑtɔ̃mmú Esibiti kɔbɛ di duɔ́ mmù, kɛ́ di om̀pùnnɛ. N yóó bɛnkɛmu Esibiti kɔbɛ n wɛ̃rímú kɛ́ bɛ̀ potɛ́, kɛ́ di dɛɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kɛ̀ di ntú n kɔbɛ kɛ̀ n di te. Kɛ̀ di n yɛ̃́ míì di dènnɛmɛ̀ Esibiti kó mudɑɑtɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Mí ndi Yiɛ̀ nKuyie mmíì bɛ́i nkɛ tú m bo di kɔtɛnɛ̀ n do yɛ̃ n yóó duɔ́ nkɛ̀ɛ̀ tenkɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu kɛ̀ di kɛ̀ tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Kɛ̀ Mɔyiisii tì nɑ̀kɛ́ Isidɑyɛɛribɛ. Kɛ̀ bɛ̀ í nyie, kɛ yɛ̃́ bɛ̀ fɛ̃́ũ̀rìnɛ̀mɛ̀ mutɔ̃mmú mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","Kɔtɛ kɛ́nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀, wèe yóu Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ yɛ̀ o tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Kɛ̀ Mɔyiisi dɔ̀: Isidɑyɛɛribɛ í yie n kpɛti, kɛ̀ m bo nɑ kɛ́nɑ́kɛ́nɛ̀ okpɑ̀ɑ̀tì nwe, mí nwèè í nɔ nkɛ nɑ́ɑ́nnɑ́ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ bɛ̀ yóó nɑ́kɛ́ tì Isidɑyɛɛribɛ nɛ̀ Esibiti kóo kpɑ̀ɑ̀tì, kɛ̀ dɛ̀ɛ yie nkɛ̀ bɛ̀ɛ dennɛ Isidɑyɛɛribɛ Esibiti tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ntɛ Isidɑyɛɛribɛ bɛ̀ɛ̀ bɑkɛ́ Isidɑyɛɛribɛ nɑɑ̀mùntì bɛ yètɛ̀: Sɑkɔbu kóo po Dubɛnni bí: Enɔki nɛ̀ Pɑduu nɛ̀ Ɛtisidonni nɛ̀ Kɑdimii bɛɛ̀ do tú Dubɛnni nɑɑ̀mùnkù kó bɛyɑ̀ɑ̀rìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simmɛɔ̃ɔ̃ bí tú: Yemmuyɛɛdi nɛ̀ Yɑminni nɛ̀ Oɑdi nɛ̀ Yɑkinni nɛ̀ Soɑ nɛ̀ Sɑudi Kɑnnɑhɑ̃ɑ̃ kóo nitipòkù birɛ bɛɛ̀ do tú Simmɛɔ̃ɔ̃ nɑɑ̀mùnkù kó bɛyɑ̀ɑ̀rìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Kɛ̀ Defii pɛitɛ́ initidɑbí ìtɑ̃ɑ̃ti: Kɛrisonni nɛ̀ Keɑti nɛ̀ Mɛdɑdi kɛ̀ bɛ̀ múnkɛ piɛ́ ibí. Defii do yóó kú kɛ mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀yiekɛ̀ (137) ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Kɛrisonni bí tú: Dibinii nɛ̀ Simɛii. Bɛɛ̀ do tú bɛ kó bɛyɑ̀ɑ̀rìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kɛ̀ Keɑti bí ntú: Amudɑmu nɛ̀ Isɑɑdi nɛ̀ Ebunɔɔ nɛ̀ Usiyɛɛdi. Keɑti yóó kú kɛ mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀tɑ̃ɑ̃ti (133) ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Kɛ̀ Mɛdɑdi bí ntú: Mɑdi nɛ̀ Musi. Bɛɛ̀ do tú Defii nɑɑ̀mùnkù kó bɛyɑ̀ɑ̀rìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Kɛ̀ Amudɑmuu puokɛ o cicɛ tɑ̃ũ̀ Yokebɛti kòo ò pɛitɛ́ initidɑbí ìdɛ́ì, Anɔɔ nɛ̀ Mɔyiisi. Amudɑmu do yóó kú kɛ mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀yiekɛ̀ (137) ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Kɛ̀ Isɑɑdi bí ntú: Kodee nɛ̀ Nɛfɛki nɛ̀ Sikidii. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Kɛ̀ Usiyɛɛdi kpɛyi ntú: Mikɑyɛɛdi nɛ̀ Edisɑfɑ̃ɑ̃ nɛ̀ Sitidi. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Kɛ̀ Anɔɔ puokɛ Edisebɑɑ Amminɑdɑbu kóo sɑpɑ̀ɑ̀, Nɑsɔ̃ɔ̃ tɑ̃ũ̀ kòo ò pɛitɛ́ initidɑbí ìnɑ̀ɑ̀: Nɑdɑbu nɛ̀ Abiu nɛ̀ Edeɑsɑɑ nɛ̀ Itɑmɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kɛ̀ Kodee bí ntú: Asii nɛ̀ Ɛdikɑnɑɑ nɛ̀ Abiyɑsɑfu, Kodee nɑɑ̀mùnkù kɔbɛ kó bɛyɑ̀ɑ̀rìbɛ̀ mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Kɛ̀ Edeɑsɑɑ, Anɔɔ birɛɛ puokɛ Pusiyɛɛdi kóo sɑpɑ̀ɑ̀ nkòo ò pɛitɛ́ dɛnitidɑbirɛ kɛ́ dɛ̀ yu kɛ dɔ̀ Pinɑsi. Defiibɛ yɑ̀ɑ̀rìbɛ̀ kó yɛyètɛ̀ nyɛ mɛmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Anɔɔ nɛ̀ Mɔyiisi nwe ti Yiɛ̀ nKuyie nnɑ̀kɛ́mɛ̀ kɛ tú: Dennɛnɛ̀ Isidɑyɛɛribɛ Esibiti bɛ nɑú dò ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Bɛɛ̀ do nɑ̀kɛ́ Esibiti kóo kpɑ̀ɑ̀tì kɛ dɔ̀ wèe yóu kɛ̀ Isidɑyɛɛribɛ yɛ̀ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi Esibiti tenkɛ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Míì tu di Yiɛ̀ nKuyie, ɑ́ nɑ́kɛ́ Esibiti kóo kpɑ̀ɑ̀tì n dɑ nɑ̀kɛ́ tì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Kɛ̀ Mɔyiisi dɔ̀: N yí nɔ nkɛ nɑ́ɑ́ nhokpɑ̀ɑ̀tì bo yie n kpɛtɑɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: N yóó dɑ duɔ́mmu n kó muwɛ̃rímú kɑ̀ɑ kɔtɛ okpɑ̀ɑ̀tì borɛ̀, nɛ̀ n kó diyètìrì, kɑ̀ɑ kóo kótì Anɔɔ nnɑ́ɑ́ nhɑ ò nɑ̀ɑ́ ntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Fɔ̃́ɔ̃̀ yó nnɑ́ɑ́ nhɑ kóo kótì n dɑ nɑ́ɑ́ ntì, kòò tì cɛ̃́ĩ́nko okpɑ̀ɑ̀tì, kòo di yóu kɛ̀ di yɛ̀ o tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","N yóó kpénkùnnɛmu okpɑ̀ɑ̀tì to, kɛ́dɔɔ̀ tidiɛtì nɛ̀ mɛbɛnkùmɛ̀ pɛ́u Esibiti miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Okpɑ̀ɑ̀tì yóó yetɛmu di kpɛti, kɛ̀ m bɛnkɛ n wɛ̃rímú Esibiti miɛkɛ kɛ́ bɛ̀ potɛ́, kɛ́dennɛ díndi n nìtìbɛ̀ Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","M bo bɛnkɛ dìì mɔ̀nnì n wɛ̃rímú Esibiti tenkɛ̀ kɔbɛ kɛ́ di dennɛ Esibiti tenkɛ̀. Dɛ mɔ̀nnì bɛ̀ bo bɑntɛ́ n túmɛ̀ di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ dɔɔ̀ ti Yiɛ̀ nKuyie mbɛ̀ nɑ̀kɛ́ tì weti weti. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Bɛ̀ do yó nnɑ́ɑ́nnɛ̀ okpɑ̀ɑ̀tì kɛ̀ Mɔyiisi mɔ̀kɛ yɛbie nsipísìni ndi kɛ̀ Anɔɔ mɔ̀kɛ yɛbie nsipísìni nɛ̀ yɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Kòo kpɑ̀ɑ̀tì di bekɛ kɛ tú dí dɔɔ̀ tidiɛtì mɑtì, fɔ̃́ mMɔyiisi ɑ́ nɑ́kɛ́ Anɔɔ kòo túótɛ́ o pɑ̀ɑ̀ti kɛ́dɔúnko okpɑ̀ɑ̀tì ììkɛ̀, kɛ̀ kùu nɑɑ́ nfɛwɑ̀ɑ̀fɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ kɔtɛ okpɑ̀ɑ̀tì borɛ̀ kɛ́dɔɔ̀ ti Yiɛ̀ nKuyie mbɛ̀ nɑ̀kɛ́ tì. Kɛ̀ Anɔɔ dɔúnko o pɑ̀ɑ̀ti okpɑ̀ɑ̀tì nɛ̀ o tɔ̃mbɛ̀ bɛ ììkɛ̀, kɛ̀ kùu nɑɑ́ nfɛwɑ̀ɑ̀fɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Kòo kpɑ̀ɑ̀tìi yúní bɛhɛikɛ̀nkótíbɛ̀ nɛ̀ bɛnitinɔ̀mbɛ̀ nɛ̀ bɛtetiebɛ Esibiti kɔbɛ. Kɛ̀ bɛ̀ múnkɛɛ dɔ̀ɔ̀ mɛbotí, ");
INSERT INTO tbzsim_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","kɛ́dɔú ndɔú mbɛ kó ipɑ̀ɑ̀ti kɛ ìi nɑɑ́ nyiwɑ̀ɑ̀kɛ. Kɛ̀ Anɔɔ kó kupɑ̀ɑ̀tii mɑɑ́ mmɑɑ́nko bɛ kpɛyi. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kòo kpɑ̀ɑ̀tìi kpénkùnnɛ o to, ò í nyie mMɔyiisi nɛ̀ Anɔɔ bɛ kpɛti kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì mbɛ̀ nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Okpɑ̀ɑ̀tì to kpenkɛmu, kòò yetɛ Isidɑyɛɛribɛ bo yɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Túótɛ́ kupɑ̀ɑ̀ti kùù do nɑɑ́ nfɛwɑ̀ɑ̀fɛ̀ kɛ́kɔtɛ dikṹnweńnì sɛ̀ì okpɑ̀ɑ̀tì tɑɑ̀ dìì mɔ̀nnì kukó nNiidi, kɛ̀ dí ḿmɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kɑ̀ɑ ò nɑ̀kɛ́ kɛ dɔ̀: Ti Yiɛ̀ nKuyie ntínti Ebedeebɛ ti tũ nkù kuù n tɔ̃nní, kɛ tú n dɑ nɑ́kɛ́ kɑ̀ɑ ti yóu kɛ̀ tí kɔtɛ dikpɑ́ɑ̀ kɛ́ kù fìé iwũɔ̃, ɑ mɛ nyí yie. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Dɛɛ̀ te kɛ̀ kù bɛ́i nkɛ tú, nɛ̀ mɛ ndɔɔ̀rìmɛ̀ miɛkɛ nkɛ ɑ yóó bɑntɛ́mɛ̀ kù tumɛ̀ ti Yiɛ̀ nKuyie. M bo potɛ́ kupɑ̀ɑ̀ti m mɛ ntɔ kù mɛniɛ nkɛ̀ mɛ̀ɛ nɑɑ́ mmɛyĩ̀ĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Kɛ̀ siyĩĩ kú, kɛ̀ mɛniɛ nhɑ̃nnɛ́ kunɔ́ú, kɛ̀ Esibiti kɔbɛɛ yĩɛ̃kɛ mɛ muyɑ̃̀ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisii kɛ dɔ̀: Nɑ́kɛ́ Anɔɔ kòo youtɛ o pɑ̀ɑ̀ti Esibiti kó ikó ndiɛyì nɛ̀ isɑ́m̀pɔ́ì nɛ̀ yɛbirɛ nɛ̀ sikondɑkɛsí dɛ bíɛ́kɛ̀ Esibiti omɔu miɛkɛ. Kɛ̀ dɛ kó mɛniɛ nnɑɑ́ mmɛyĩ̀ĩ̀ nkɛ́dɑ́tínnɛ́ kɛtenkɛ̀ kɛmɔu kɛ́tɑunnɛ̀ yɛdɔ́ nɛ̀ yɛdíè ndɛ miɛkoo. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ dɔɔ̀ ti Yiɛ̀ nKuyie mbɛ̀ nɑ̀kɛ́ tì, kɛ̀ Anɔɔ youtɛ kupɑ̀ɑ̀ti kɛ́potɛ́ mɛniɛ nhokpɑ̀ɑ̀tì nɛ̀ o tɔ̃mbɛ̀ bɛ ììkɛ̀, kɛ̀ kukó nkumɔuu nɑɑ́ mmɛyĩ̀ĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kɛ̀ siyĩĩ kú, kɛ̀ mɛniɛ nhɑ̃nnɛ́ kunɔ́ú, kɛ̀ Esibiti kɔbɛɛ yĩɛ̃kɛ muyɑ̃̀ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Kɛ̀ Esibiti kó bɛnitinɔ̀mbɛ̀ múnkɛɛ dɔɔ̀ mɛbotí. Kòo kpɑ̀ɑ̀tì to bɑɑ ńkpeńnì kòo yetɛ Mɔyiisi nɛ̀ Anɔɔ bɛ kpɛti, kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo bɛ̀ nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Kòo kpɑ̀ɑ̀tìi ítɛ́ kɛ́kò nho cĩ́ɛ̃̀tɛ̀, kɛ́ketɛ́ kɛ í ndɑkɛ bɛ tɛrɛ̀ kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Kɛ̀ Esibiti tenkɛ̀ kɔbɛɛ dɑmmú sibií kukó ntɑkɛ́ kɛ bo pɛ́tɛ́ mɛnɛ́sɑ̀ɑ̀mɛ̀, kɛ yɛ̃́ kukó nkɔ̃mɛ do í dòmmɛ̀ kɛ́yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mɛniɛ ndo nɑɑ́ mmɛyĩ̀ĩ̀ nkɛ̀ dɛ̀ mmɔkɛ yɛwe yɛ̀yiekɛ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Kɛ̀ ti Yiɛ̀ Kuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Kɔtɛ kɛ́nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Ti Yiɛ̀ nKuyie ntu, ɑ́ yóu kɛ̀ ku kó bɛnìtìbɛ̀ɛ kɔtɛ kɛ́ kù fìé iwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Kɑ̀ɑ yetɛ kù bo duɔ́ nkɛ̀ yɛcɛdɑkɛ̀ɛ píɛ nhɑ tenkɛ̀ kɛmɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Yɛcɛdɑkɛ̀ bo píɛ nkukó nkɛ́yɛ̀nní kɛ́tɑ ɑ kpɑ̀ɑ̀tìcĩ́ɛ̃̀tɛ̀, ɑ dieku ɑ dɔu dɛ̀ nɛ̀ ɑ dɔ́ù ĩ́nkɛ̀ nɛ̀ ɑ tɔ̃mbɛ̀ kó sicɛ̃́ĩ nɛ̀ ɑ kɔbɛ kpɛsi, nɛ̀ bɛ̀ pũũ dɛ̀ pɛ̃́ɛ̃̀ nɛ̀ bɛ̀ ò piiku dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Yɛcɛdɑkɛ̀ bo ndekù ɑ ĩ́nkɛ̀ nɛ̀ ɑ tɔ̃mbɛ̀ ĩ́nkɛ̀ nɛ̀ ɑ kɔbɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Nɑ́kɛ́ Anɔɔ kòo youtɛ o pɑ̀ɑ̀ti ikó nnɛ̀ sikondɑkɛsí nɛ̀ yɛbirɛ dɛ bíɛ́kɛ̀, kɛ̀ yɛcɛdɑkɛ̀ɛ píɛ nhEsibiti kó kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Kɛ̀ Anɔɔ youtɛ o nɔ̀ùtɛ̀ Esibiti kó ikó mbíɛ́kɛ̀, kɛ̀ yɛcɛdɑkɛ̀ɛ píɛ nhEsibiti tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Kɛ̀ bɛnitinɔ̀mbɛ̀ múnkɛɛ dɔɔ̀ mɛbotí, kɛ́dennɛní yɛcɛdɑkɛ̀ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Kòo kpɑ̀ɑ̀tìi yú Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: Bɑ́ntɛ̀nɛ̀ di Yiɛ̀ nKuyie nkɛ̀ kù ti dennɛ yɛcɛdɑkɛ̀ mí nnɛ̀ n kɔbɛ, kɛ̀ n di yóu kɛ̀ di kɔtɛ kɛ́ kù fìé iwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Kɛ̀ Mɔyiisii nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: N nɑ́kɛ́ ɑ dɔ́ m bɑ́ntɛ̀ dìì mɔ̀nnì Kuyie nfɔ̃́ nnɛ̀ ɑ tɔ̃mbɛ̀ nɛ̀ ɑ kɔbɛ di kpɛ́í, kɛ̀ yɛcɛdɑkɛ̀ɛ yɛ̀ dihɛì, kɛ́nkpɑɑ́ kukó mmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kòo kpɑ̀ɑ̀tì dɔ̀: Nɑnkɛ. Kɛ̀ Mɔyiisi dɔ̀: N yiemmu kɛ bo kù bɑ̀ńtɛ̀, kɑ̀ɑ bɑntɛ́ kɛ dò nhòmɔù í dònnɛ̀ ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Yɛcɛdɑkɛ̀ yóó yɛ̀mu fɔ̃́ nnɛ̀ ɑ tɔ̃mbɛ̀ nɛ̀ ɑ kɔbɛ di cɛ̃́ĩ, kɛ́nkpɑɑ́ kukó mmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ ítɛ́ okpɑ̀ɑ̀tì borɛ̀ kɛ̀ Mɔyiisi bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ dɔ̀ kùu dɛitɛ yɛcɛdɑkɛ̀ kù do tɑnnɛ́ yɛ̀ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Kɛ̀ ti Yiɛ̀ nKuyie ndɔɔ̀ Mɔyiisi kù bekɛ tì kɛ̀ yɛcɛdɑkɛ̀ɛ kú sicɛ̃́ĩ miɛkɛ nɛ̀ yɛtowɑɑrɛ̀ nɛ̀ dɛpɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Kɛ̀ bɛ̀ɛ yɛ̀ tìkú kɛ́cóú nyɛcúò yɛcúò, kɛ̀ dihɛìi dɑ́tínnɛ́ kunɔ́ú. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Kòo kpɑ̀ɑ̀tìi yɑ̀ yɛcɛdɑkɛ̀ dèèmɛ̀ kòo toò kpenkɛ, kòo yetɛ Mɔyiisi nɛ̀ Anɔɔ bɛ kpɛti, kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Nɑ́kɛ́ Anɔɔ kòo youtɛ o pɑ̀ɑ̀ti kɛ́potɛ́ mutɑ̃́ɑ̃́ nkɛ̀ mùu nɑɑ́ nyinɑmɛ́í Esibiti tenkɛ̀ kɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Kɛ̀ bɛ̀ɛ yie nKuyie mbɛ̀ nɑ̀kɛ́ tì, kɛ̀ Anɔɔ youtɛ́ o pɑ̀ɑ̀ti kɛ́potɛ́ mutɑ̃́ɑ̃́ nkɛ̀ mùu nɑɑ́ nyinɑmɛ́í kɛ́pɔ̃nnɛ́ bɛnìtìbɛ̀ nɛ̀ iwũɔ̃, kɛ̀ mutɑ̃́ɑ̃́ mmumɔu nɑɑ́ nyinɑmɛ́í Esibiti tenkɛ̀ kɛmɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Kɛ̀ bɛnitinɔ̀mbɛ̀ múnkɛ ndɔ́ kɛ́dennɛní bɛ kó inɑmɛ́í kɛ́yĩɛ̃kɛ, kɛ̀ inɑmɛ́í mpũɔ̃́ bɛnìtìbɛ̀ nɛ̀ iwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Kɛ̀ bɛnitinɔ̀mbɛ̀ɛ nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Kuyie nkó tɛnɔ̀ùtɛ̀ ntɛ. Kòo kpɑ̀ɑ̀tì bɑɑ kpénkùnnɛ o to kɛ́yetɛ Mɔyiisi nɛ̀ Anɔɔ bɛ kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: A nɑɑ yɛ̀ dikṹnweńnì sɛ̀ì kɛ́sɔ̃́ntɛ́ okpɑ̀ɑ̀tì ò yɛ̀tì dìì mɔ̀nnì kɛ tɑti kukó, kɑ̀ɑ ò nɑ̀kɛ́ kɛ dɔ̀: Kuyie ntú ɑ yóu ku kɔbɛ kɛ̀ bɛ̀ɛ kɔtɛ kɛ́ kù fìé iwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Kɑ̀ɑ mɛ nyetɛ, kù bo dennɛní tidɔndɔntì yɛiti, kɛ̀ tì ndɑ dɔmmù nɛ̀ ɑ tɔ̃mbɛ̀ nɛ̀ ɑ nìtìbɛ̀, tì bo píɛ nhEsibiti kɔbɛ kó sicɛ̃́ĩ, kɛ́dɑ́tínnɛ́ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Kɛ̀ dɛ kó tidɔndɔntì yɛ̀nní, kù í yóó yie nkɛ̀ tì mbo Kosɛnni, ku kɔbɛ ɛì, kɑ̀ɑ bɑntɛ́ kù bɛ̀ bonɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Kù bo nkɑ̃nkɛ́ ku kɔbɛ kɛ́yóu ɑ kɔbɛ. Dɛ̀ nɑɑ yóó dɔɔ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Kɛ̀ ti Yiɛ̀ nKuyie ndɔɔ̀ kù bɛ́i ntì, kɛ̀ tidɔndɔntì yɛitii tɑnní kɛ́nsũ kɛ́píɛ nhokpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀ nɛ̀ o tɔ̃mbɛ̀ kpɛsi nɛ̀ Esibiti tenkɛ̀ kɛmɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Kɛ̀ dihɛìi cɑkɛ kòo kpɑ̀ɑ̀tìi yú Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: Kɔtɛnɛ̀ kɛ́fíé nyiwũɔ̃ Kuyie ndi tenkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Kɛ̀ Mɔyiisii yetɛ kɛ dɔ̀: Dɛ̀ bɑ́ɑ́ yie! Ti yóó fíé ìì wũɔ̃ ti Yiɛ̀ nKuyie nyì dò nhEsibiti kɔbɛ borɛ̀ isɔkɛ nyì, kɛ̀ ti ì feu kɛ̀ bɛ̀ ti yɑ̀ bɛ̀ yóó ti búɔ́tí yɛtɑ̃́rɛ̀ nyɛ kɛ́kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ti yó mmɔkɛ kucɛ yɛwe yɛ̀tɑ̃ɑ̃ti ndi dikpɑ́ɑ̀ miɛkɛ, kɛ́fíé ti Yiɛ̀ nKuyie nyiwũɔ̃ kù yɛ̃ dɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Kòo kpɑ̀ɑ̀tì dɔ̀: N yiemmu kɛ bo di yóu kɛ̀ di kɔtɛ dikpɑ́ɑ̀ kɛ́fíé ìwũɔ̃ di Yiɛ̀ nKuyie, di nɛ́ bɑ́ɑ́ dɛ́tɛ́, dí kù bɑ̀ńtɛ̀ n kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Kɛ̀ Mɔyiisi dɔ̀: N yóó ítɛ́ ɑ borɛ̀ kɛ́bɑ́ntɛ̀mu ti Yiɛ̀ nKuyie nkɛ̀ kù nɑɑ dennɛ tidɔndɔntì ɑ cĩ́ɛ̃̀tɛ̀ nɛ̀ ɑ tɔ̃mbɛ̀ kpɛsi nɛ̀ ɑ nìtìbɛ̀ kpɛsi. A nɛ́ bɑ́ɑ́ ti soutɛ́ kɛ́yetɛ Isidɑyɛɛribɛ bo kɔtɛmɛ̀ kɛ́fíé iwũɔ̃ ti Yiɛ̀ Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Kɛ̀ Mɔyiisii ítɛ́ okpɑ̀ɑ̀tì borɛ̀ kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Kɛ̀ ti Yiɛ̀ nKuyie ndɔɔ̀ wè kù bekɛ tì, kɛ́dennɛ tidɔndɔntì okpɑ̀ɑ̀tì nɛ̀ o tɔ̃mbɛ̀ nɛ̀ o nìtìbɛ̀ bɛ cɛ̃́ĩ, kudɔndɔnkù mɑkù í nkpɑɑ́ bɑ́ kumɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kòo kpɑ̀ɑ̀tì bɑɑ wɛ̃tɛ kɛ́kpénkùnnɛ o to kɛ́yetɛ Isidɑyɛɛribɛ bo yɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Kɔtɛ okpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀ kóò nɑ̀kɛ́ kɛ dɔ̀: Ti Yiɛ̀ nKuyie, tínti Ebedeebɛ ti tũ nkù tu ɑ́ yóu tínti kù kó bɛnìtìbɛ̀ kɛ̀ tí yɛ̀ kɛ́ kù fìé iwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Kɑ̀ɑ yetɛ bɛ̀ bo yɛ̀mɛ̀, kɑ̀ɑ bɑɑ kpɑɑ́ yetírí, ");
INSERT INTO tbzsim_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","kù bo duɔ́ nkɛ̀ muwũɔ̃̀kṹṹ ntɑnní mɛdiɛ̀ nkɛ́kuɔ ɑ wũɔ̃: Sisɛ̃ĩ́ nɛ̀ sɑ̃mmɑrímúbɛ̀ nɛ̀ yòyóbɛ̀ nɛ̀ inɑ̀ɑ̀kɛ nɛ̀ ipe nɛ̀ sibɔɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Ti Yiɛ̀ nKuyie nyó nyɛ̃́mu tínti Isidɑyɛɛribɛ ti kó iwũɔ̃ kpɛ́í mbɑ́ fɛ̀mɑfɛ̀ bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́i nkɛ dɔ̀: Nɑnkɛ nwe n yóó dɔɔ̀mɛ̀ dɛ kó tidiɛtì Esibiti tenkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ ti Yiɛ̀ nKuyie mmɛ ndɔɔ̀ kɛ̀ Esibiti kɔbɛ kó iwũɔ̃ kú, bɑ́ Isidɑyɛɛribɛ kɔfɛ mɑfɛ̀ í nku bɑ́ fɛ̀mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Kòo kpɑ̀ɑ̀tìi tɔ̃ nkɛ̀ bɛ̀ɛ síékɛ́ kɛ́nsɔ̃́ nyIsidɑyɛɛribɛ kó iwũɔ̃ í ku bɑ́ fɛ̀mɑ́ɑ̀, kòò to bɑɑ ńkpeńnì, kòo yetɛ Isidɑyɛɛribɛ bo yɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: Koutɛ́nɛ̀ mutɑ́pɛí, nkɛ̀ Mɔyiisii mù ùtóo kɛĩ́nkɛ̀ okpɑ̀ɑ̀tì ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Kɛ̀ mùu nɑɑ́ nkutɑ̃ɑ̃yukú kɛ́dɑ́tínnɛ́ Esibiti tenkɛ̀ kɛmɔu, kɛ́dɑri bɛnìtìbɛ̀ nɛ̀ iwũɔ̃ kɛ́nɑɑ́ nyɛnúútɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ koutɛ́ mutɑ́pɛí nkɛ́kɔtɛ okpɑ̀ɑ̀tì borɛ̀ kɛ̀ Mɔyiisii mù ùtóo kɛĩ́nkɛ̀ okpɑ̀ɑ̀tì ììkɛ̀ kɛ̀ mùu dɑ́tínnɛ́ bɛnìtìbɛ̀ kɛ́nɑɑ́ nyɛnúútɛ̀ nɛ̀ yɛmuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Esibiti kó bɛnitinɔ̀mbɛ̀ í nnɑ kɛ kɔ̀tɛ Mɔyiisi borɛ̀ kɛ yɛ̃́ yɛnúútɛ̀ múnkɛ do bɛ̀ pĩ̀ḿmɛ̀, yɛ̀ pĩ mmɛ̀ɛ̀ botí bɛtɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nkpénkùnnɛ okpɑ̀ɑ̀tì to, kòo yetɛ Mɔyiisi nɛ̀ Anɔɔ bɛ kpɛti kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Á yɛ̀ dikṹnweńnì sɛ̀ì kɛ́nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Ti Yiɛ̀ nKuyie tínti Ebedeebɛ ti tũ nkù tu, ɑ́ ti yóu, kɛ̀ tí yɛ̀ kɛ́ kù fìé iwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Kɛ̀ dɛ̀ í dò mmɛmmɛ kù bo dɑ potɛ́, fɔ̃́ nnɛ̀ ɑ tɔ̃mbɛ̀ nɛ̀ ɑ nìtìbɛ̀, kɑ̀ɑ bɑntɛ́ òmɔù í bomɛ̀ kɛtenkɛ̀ kɛ kù mɑ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Kɛ̀ kù do tú kù bo duɔnní mumɔmmú kɛ̀ mù dɑ kuɔ fɔ̃́ nnɛ̀ ɑ kɔbɛ nɛ̀ miɛ ndi do í kpɑɑ́ bo kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kù nɛ́ dɑ yóu kɑ̀ɑ kpɑɑ́ fòù, kɛ bo yɑ̀ ku wɛ̃rímú mmu kɛ̀ bɛ̀ɛ dɛ́úkùnnɛ ku yètìrì kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kɑ̀ɑ mɛ mbɑɑ dɔ́ kɛ́mpĩ́ nku nìtìbɛ̀ kɛ yetírí bɛ̀ bo yɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Dɛ̀ nɑɑ bo nkɑ̃́ɑ̃́kɛ́ miɛ nkɛ̀ kùu duɔnní fɛtɑɑfɛ̀ nɛ̀ yɛmɑ́tɑ̃́rɛ̀ diɛyɛ̀, di mu nyí dɛ̀ yɑ̀ nɛ̀ Esibiti bomɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Á tɑnnɛ́ ɑ kó iwũɔ̃ tɛcĩ́ɛ̃̀tɛ̀ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ tu ɑ kpɛrɛ, iwũɔ̃ ìì bo mbo dikpɑ́ɑ̀ nɛ̀ bɛnìtìbɛ̀ kɛ í ntɑ tɛcĩ́ɛ̃̀tɛ̀, yɛmɑ́tɑ̃́rɛ̀ yɛɛ̀ yóó dɛ̀ bùɔ́tí kɛ̀ dɛ̀ɛ kú. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Kòo kpɑ̀ɑ̀tì tɔ̃mbɛ̀ mɑbɛ̀ɛ depɛ Kuyie nnɑ̀kɛ́ tì, kɛ́tɑnnɛ́ bɛ wũɔ̃ nɛ̀ bɛ tɔ̃mbɛ̀ dɛ yiè. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Bɛ̀ɛ̀ sènkɛ̀rì dɛ kó tinɑ́ɑǹtì kɛ̀ bɛmbɛɛ yóu bɛ wũɔ̃ nɛ̀ bɛ̀ kó bɛtɔ̃mbɛ̀ dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Youtɛ ɑ nɔ̀ùtɛ̀ kɛĩ́nkɛ̀, kɛ̀ yɛmɑ́tɑ̃́rɛ̀ɛ duoní Esibiti tenkɛ̀ kɛmɔu miɛkɛ, bɛnìtìbɛ̀ nɛ̀ iwũɔ̃ nɛ̀ dɛpɑɑ ntidiitì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Kɛ̀ Mɔyiisii youtɛ o pɑ̀ɑ̀ti tiwɛtì bíɛ́kɛ̀, kɛ̀ ti Yiɛ̀ nKuyie nduɔ́ nkɛ̀ fɛtɑɑfɛ̀ mmíí nkɛ pɛ́ú kɛ̀ yɛmɑ́tɑ̃́rɛ̀ duòní Esibiti tenkɛ̀ kɛmɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Esibiti kɔbɛ mu ndo í yɑ̀ dɛ kó fɛtɑɑfɛ̀ botí nɛ̀ bɛ̀ bomɛ̀, fɛ̀ɛ̀ mìí nkɛ pɛ́ú kɛ̀ yɛmɑ́tɑ̃́rɛ̀ duòní. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Kɛ̀ yɛmɑ́tɑ̃́rɛ̀ɛ búɔ́tí bɛnìtìbɛ̀ nɛ̀ iwũɔ̃ kɛ́kuɔ, kɛ́cɑkɛ tidiitì nɛ̀ dɛtie. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kɛ̀ Kosɛnni Isidɑyɛɛribɛ kó dikɑrì diì mɑ́ɑ̀ nsokɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Kòo kpɑ̀ɑ̀tìi yú Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: Di mmɔ̀nnì mí nnɛ̀ n kɔbɛ ti cɑ̀ɑ̀rɛ̀mu, di Yiɛ̀ nKuyie nkuù wenni. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bɑ́ntɛ̀nɛ̀ ku, kɛ̀ yɛmɑ́tɑ̃́rɛ̀ nɛ̀ itɑpíɛ kɛ̀ dɛ̀ɛ cómmú kɛ̀ n di yóu kɛ̀ dí yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Kɛ̀ Mɔyiisi dɔ̀: N yóó yɛroomu dihɛì kɛ́youtɛ n nɔu kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie, kɛ̀ itɑpíɛ nɛ̀ yɛmɑ́tɑ̃́rɛ̀ kɛ̀ dɛ̀ɛ cómmú, kɑ̀ɑ bɑntɛ́ kuù temɛ̀ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","N nɛ́ yɛ̃́mu kɛ tú fɔ̃́ nnɛ̀ ɑ tũ̀mbɛ̀ di mu nyí depɛ ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Dɛ̀ do sɔ̃́ ntidiitì òtɛmu, kɛ̀ titɔ̃̀ntì pòrí, kɛ̀ fɛtɑɑfɛ̀ mɑ́tɑ̃́rɛ̀ dɛ̀ potɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Tidiniiti tiì mɑ́ɑ̀ do yentɛ́ kɛ yɛ̃́ ti mu ndo í òtɛmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Kɛ̀ Mɔyiisii ítɛ́ okpɑ̀ɑ̀tì borɛ̀, kɛ́tɑ dikpɑ́ɑ̀, kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ̀ itɑpíɛ nɛ̀ yɛmɑ́tɑ̃́rɛ̀ kɛ̀ dɛ̀ɛ cómmú, bɑ́ fɛtɑɑfɛ̀ tɛ̃́nkɛ í nniu. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Kòo kpɑ̀ɑ̀tìi yɑ̀ fɛtɑɑfɛ̀ nɛ̀ yɛmɑ́tɑ̃́rɛ̀ nɛ̀ itɑpíɛ dɛ̀ dèèmɛ̀, kòo too wɛ̃tɛ kɛ́kpenkɛ wenwe nɛ̀ o tũ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Kòò bɑɑ n kpɑɑ́ yetírí Isidɑyɛɛribɛ bo yɛ̀mɛ̀ kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Kɔtɛ okpɑ̀ɑ̀tì borɛ̀, míì kpénkùnnɛ o to nɛ̀ o tũ̀mbɛ̀ kpɛyɛ kɛ bo dɔɔ̀ tidiɛtì bɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Kɑ̀ɑ tì nɑ̀kɛ́ ɑ bí nɛ̀ ɑ yɑɑ̀bí n dɔ̀ɔ̀ dɛ̀ Esibiti kɔbɛ nɛ̀ n dɔ̀ɔ̀ tìì diɛtì bɛ cuokɛ̀. Kɛ̀ di nyɛ̃́ n túmɛ̀ di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ kɔtɛ okpɑ̀ɑ̀tì borɛ̀ kóo nɑ̀kɛ́ kɛ dɔ̀: Ti Yiɛ̀ nKuyie ntínti Ebedeebɛ ti tũ nkù tu, ɑ yóó kɛ̃́kùnnɛ ɔ̃̀mmɔ̀nnì ɑmɑ́ɑ̀ ku ììkɛ̀, kɛ́ ti yóu kɛ̀ tí yɛ̀ kɛ kù fìé iwũɔ̃? ");
INSERT INTO tbzsim_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Kɑ̀ɑ yetɛ ti bo yɛ̀mɛ̀, kù bo duɔnní fɛcofɛ nɑnkɛ ɑ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Kɛ̀ fɛ̀ɛ dɑ́tínnɛ́ kɛtenkɛ̀ bɑ́ kɛ̀ tɛ̃́nkɛ bɑ́ nfeí, fɛ̀ bo cɑ́ɑ́kɛ́ yɛmɑ́tɑ̃́rɛ̀ sùɔ́ ndɛ̀, kɛ́cɑ́ɑ́kɛ́ dɛtie ndɛmɔu kó tifɑ̃ɑ̃̀tì dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Fɛ̀ bo píɛ nhɑ cĩ́ɛ̃̀tɛ̀ nɛ̀ ɑ tũ̀mbɛ̀ kpɛsi nɛ̀ ɑ nìtìbɛ̀ kpɛsi. A cicɛbɛ̀ nɛ̀ ɑ yɑ̀ɑ̀rìbɛ̀ bɛ̀ mu nyí yɑ̀ dɛ kó kubotí nɛ̀ bɛ̀ bomɛ̀. Mɔyiisi bɛ́i mmɛmmɛ kɛ́ítɛ́ okpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀ kɛ́yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Kòo kpɑ̀ɑ̀tì tũ̀mbɛ̀ɛ ò nɑ̀kɛ́ kɛ dɔ̀: Onìtì yiè nyóó yóu ɔ̃̀mmɔ̀nnì ò bo nti buɔ̀mmɛ̀ mɛyɛi? Yóu bɛ kɛ̀ bɛ̀ɛ yɛ̀ kɛ́fíé bɛ Yiɛ̀ nKuyie nyiwũɔ̃. A í wúó nhEsibiti kɔbɛ deumɑ̀ɑ̀! ");
INSERT INTO tbzsim_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kɛ̀ bɛ̀ɛ yúní Mɔyiisi nɛ̀ Anɔɔ okpɑ̀ɑ̀tì borɛ̀ kòo bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Kɔtɛnɛ̀ kɛ́fíé iwũɔ̃ di Yiɛ̀ nKuyie. Ɔ̃̀mbɛ kɔri? ");
INSERT INTO tbzsim_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Kɛ̀ Mɔyiisi dɔ̀: Ti kɔri timɔu ndi. Ibí nɛ̀ bɛkótíbɛ̀ bɛnitidɑɑbɛ̀ nɛ̀ bɛnitipòbɛ̀ nɛ̀ ti nɑ̀ɑ̀kɛ nɛ̀ ti pe nɛ̀ ti bɔɔ́. Ti Yiɛ̀ nKuyie mbɑnni ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Kòo kpɑ̀ɑ̀tì dɔ̀: Di yɛ̀mmɛ̀ dò m bo di yóumu kɛ̀ di kɔtɛ dimɔu, di pobɛ̀ nɛ̀ di bíɑ̀ɑ̀? M bɑ́ɑ́ dɛ̀ dɔ̀ɔ̀! N yɛ̃́mu kɛ dò ndi dɔ́ tì í wenni. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Bìtì! M bɑ́ɑ́ di yóu. Kɔtɛnɛ̀ díndi bɛnitidɑɑbɛ̀ mɑ́ɑ̀ kɛ́fíé iwũɔ̃ di Yiɛ̀ nKuyie di do mɛ nyɛ̃. Kɛ̀ bɛ̀ɛ bɛ̀ bɛ̀ti okpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Youtɛ ɑ nɔ̀ùtɛ̀ Esibiti ĩ́nkɛ̀, kɛ̀ fɛcofɛɛ kɔtɛní kɛ́cɑ́ɑ́kɛ́ yɛmɑ́tɑ̃́rɛ̀ sùɔ́ ndɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Kɛ̀ Mɔyiisii youtɛ kupɑ̀ɑ̀ti Esibiti tenkɛ̀ ĩ́nkɛ̀, kɛ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó kuyɑɑkù ntṹṹ nkɛ fuuti, kɛ́nyié nkɛ fuuti kɛ̀ dɛ̀ nyóó wentɛ́ kɛ̀ kù tɔní fɛcofɛ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Kɛ̀ fɛ̀ɛ tɑnní Esibiti tenkɛ̀ kɛ́nsũ, kɛ́dɑ́tínnɛ́ Esibiti tentɑ̃́ɑ̃́ mmumɔu miɛkɛ. Bɛ̀ mu nyí yɑ̀ fɛ kóo botí Esibiti, fɛ kóo botí mɛ nyí kpɑɑ́ bo buotɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Kɛ̀ fɛcofɛɛ dɑ́tínnɛ́ kɛtenkɛ̀ kɛmɔu, kɛ̀ dɛ̀ɛ bitoo, kɛ̀ fɛ̀ɛ cɑ́ɑ́kɛ́ tidiitì nɛ̀ yɛtebɛ yɛmɑ́tɑ̃́rɛ̀ do sùɔ́ ndɛ̀. Timútì nɛ̀ tifɑ̃ɑ̃̀tì dɛ̀ tɛ̃́nkɛ í nkpɑɑ́ Esibiti tenkɛ̀ kɛmɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Kòo kpɑ̀ɑ̀tìi yú Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: N yetɛ́nɛ̀ di Yiɛ̀ nKuyie nku, kɛ di yetɛ́nɛ̀ di mɔ́mmɔmbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Di wɛ̃tɛ kɛ́ n cĩ́ɛ̃́ n yɛi nkɛ́bɑ́ntɛ̀ di Yiɛ̀ nKuyie nkɛ̀ kùu fũũ mmɛyɛi nsĩ̀mmɛ̀ miɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kɛ̀ Mɔyiisii ítɛ́ okpɑ̀ɑ̀tì borɛ̀, kɛ́bɑ́ntɛ̀ ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Kɛ̀ kùu duɔ́ nkɛ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó kuyɑɑkùu fuutɛ kɛ́túótɛ́ fɛcofɛ kɛ́tɑnnɛ́ tipèntì kóo dɑ̀mɛ́ɛ̀rì, bɑ́ fɛ̀mɑfɛ̀ í nkpɑɑ́ Esibiti tempɛ̃ nkumɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Kɛ̀ ti Yiɛ̀ nKuyie nkpénkùnnɛ okpɑ̀ɑ̀tì to, kòo yetɛ Isidɑyɛɛribɛ bo yɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Youtɛ ɑ nɔ̀ùtɛ̀ kɛ̀ dibiìnnìi tɑnní Esibiti tenkɛ̀ kɛmɔu miɛkɛ kɛ́ncɛ̃́ɛ̃̀ kɛ dò nhonìtì bo nɑ kɛ́ dì kɑ̀ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Kɛ̀ Mɔyiisii youtɛ o nɔ̀ùtɛ̀ kɛ̀ dibiìnnì diɛrìi tɑnní Esibiti tenkɛ̀ kɛmɔu miɛkɛ kɛ́mmɔkɛ yɛwe yɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Òmɔù tɛ̃́nkɛ í nwúó nhotɔù, òmɔù í nyìtɛ́ o kɑ̀rì, kɛ̀ kuwenniku nɛ́ mbo Isidɑyɛɛribɛ kó dikɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Kòo kpɑ̀ɑ̀tìi yú Mɔyiisi kóò nɑ́kɛ́ kɛ dɔ̀: Di bo nɑ kɛ́kɔtɛ dimɔu, di pobɛ̀ nɛ̀ di bí kɛ́fíé iwũɔ̃ di Yiɛ̀ nKuyie. Di wũɔ̃ iì mɑ́ɑ̀ yó nkpɑɑ́ diɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Kɛ̀ Mɔyiisi dɔ̀: Fɔ̃́ɔ̃̀ yóó ti duɔ́ nti yóó fíé ìì wũɔ̃ ti Yiɛ̀ nKuyie nnɛ̀ ti yóó kù pɑ̃ ì kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Ti yó ntɔmu ti wũɔ̃ imɔu, fɛ̀mɑfɛ̀ í yó nkpɑɑ́, iì miɛkɛ nkɛ, ti yóó tɑ̃ɑ̃tɛ́mɛ̀ kɛ́fíé ti Yiɛ̀ nKuyie. Ti mɛ nyí yɛ̃́ ti yóó tɑ̃ɑ̃tɛ́ ì, ti yóó kɛ ntuɔkɛ kɛ́ ì yɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kɛ̀ ti Yiɛ̀ nKuyie nkpénkùnnɛ okpɑ̀ɑ̀tì to, kòo yetɛ bɛ̀ bo yɛ̀mɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","kɛ́bɛ́i nkɛ dɔ̀: Ítɛ́ m borɛ̀, kɑ̀ɑ wɛ̃̀tɛní dìì yiè ɑ kumu. ");
INSERT INTO tbzsim_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Kɛ̀ Mɔyiisi dɔ̀: A bɛ́i ntì tiǹti, n tɛ̃́nkɛ í wɛ̃tiní ɑ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Dɛ mɔ̀nnì kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: M bo yíɛ́ kɛ́potɛ́ mɛsɔmmɛ okpɑ̀ɑ̀tì nɛ̀ o kɔbɛ kɛ̀ bɛ̀ di yóu kɛ̀ dí yɛ̀, bɛ̀ yóó di bɛtimu kɛ̀ dí yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Nɑ́kɛ́ bɑ́ wèè nitidɔ̀ù, bɑ́ wèè nitipòkù kòo mɔɔ o cɛ̃pɛɛtitɔù yɛsɔɔbɔ nɛ̀ timɑ́tì pɛ́ítì kpɛyɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Kɛ̀ ti Yiɛ̀ nKuyie nduɔ́ nkɛ̀ Esibiti kɔbɛɛ dɔɔ̀ Isidɑyɛɛribɛ mɛsɑ̀ɑ̀. Okpɑ̀ɑ̀tì tũ̀mbɛ̀ nɛ̀ bɛnìtìbɛ̀ bɛmɔu Esibiti tenkɛ̀ miɛkɛ kɛ̀ bɛ̀ ndé Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Kɛ̀ Mɔyiisii nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Ti Yiɛ̀ nKuyie ntu kù bo tɑnní Esibiti kɛyènkɛ̀ cuokɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","kɛ́kuɔ bɛ̀ɛ̀ tu Mpo bɛmɔu Esibiti tenkɛ̀ miɛkɛ, kɛ́kuɔnɛ̀ ɑ kóo Po, wèè yóó dɑ cɔutɛ́ tikpɑ̀tì, kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kunitipodɑɑkù kùù te munɑ̀mmù ku kóò po nɛ̀ iwũɔ̃ idɑɑì imɔu ìì tu iketiyì. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Yɛkúdɑbùò mbo dɑ́tínnɛ́ Esibiti tenkɛ̀ kɛmɔu miɛkɛ, yɛ kóo botí mu nyí ɑ̃nnɛ́, yɛ̀ mɛ nyí kpɑɑ́ bo ɑ̃nnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Isidɑyɛɛribɛ kó dikɑrì nɑ́kɛ bɛ̀ bɑ́ɑ́ keè tɛmɔtɛ̀ oomɛ̀ onìtì yoo fɛɔ̃̀fɛ̀. Kɛ̀ di bɑntɛ́ ti Yiɛ̀ nKuyie ncɑ̃́nnìnkomɛ̀ Esibiti kɔbɛ nɛ̀ Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Dɛ mɔ̀nnì ɑ tũ̀mbɛ̀ bo kɔtɛní kɛ́nínkú n yììkɛ̀ kɛ dɔ̀: Yɛ̀, fɔ̃́ nnɛ̀ ɑ kɔbɛ. Kɛ̀ n yɛ̀. Mɔyiisi bɛ́i mɛmmɛ kɛ́yɛ̀nnɛ̀ kɛmiɛkɛ diɛkɛ̀ okpɑ̀ɑ̀tì cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Kɛ̀ n yí dɔ̀ɔ̀ tidiɛtì Esibiti tenkɛ̀, okpɑ̀ɑ̀tì í yóó di yóu kɛ̀ dí yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mɔyiisi nɛ̀ Anɔɔ bɛ̀ do dɔ̀ɔ̀mu tidiɛtì pɛ́u okpɑ̀ɑ̀tì ììkɛ̀, kɛ̀ ti Yiɛ̀ nKuyie nnɛ́ kpénkùnnɛ okpɑ̀ɑ̀tì to kòo yetɛ bɛ̀ bo yɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ Esibiti tenkɛ̀ miɛkɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","We ntɑ̃̀nkù weè yó ntú di borɛ̀ dibenni kóo tɑ̃̀nkù ketiwè. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Á nɑ́kɛ́ Isidɑyɛɛribɛ, we ntɑ̃̀nkù kó diyiè píínnì bɑ́ tɛ̀ɛ̀ cĩ́ɛ̃̀tɛ̀ tɛ̀ɛ tɑ̃ɑ̃tɛ́ fɛpìèfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Kɛ̀ tɛcĩ́ɛ̃̀tɛ̀ mɑtɛ̀ kɛ̃ńnì kɛ í yóó nɑ kɛ́cɑ́ɑ́kɛ́ tɛ kó fɛpìèfɛ̀ kɛ́deè, tɛ̀ɛ yɑ̀ tɛcɛ̃pɛɛtitɔbɛ̀ kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ kɛ́yɑ̀ bɛ̀ mɑ̀mɛ̀ kɛ bo nɑ kɛ́ fɛ̀ cɑ̀ɑ́kɛ́ kɛ́deè. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Dɛ kó fɛpìèfɛ̀ yó ntú fɛ̀ɛ̀ kpɑ fɛ̀nfɛ kuyɛ̀nkù kɛ́ntú fɛdɑɑfɛ̀, kɛ́mmɔkɛ dibenni dìmɑ́ɑ̀. Dɛ̀ ntú fɛpìèfɛ̀ yoo tɛbuɔtɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Dí nfɛ̀ wèí kɛ dɔ̀ yɛwe tɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀. Dɛ yiè ndi bɑ́ tɛ̀ɛ̀ cĩ́ɛ̃̀tɛ̀ yóó kuɔ̀mɛ̀ tɛ kɔfɛ dihúríkɛ̀pɑ̀nnì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Kɛ̀ bɛ̀ɛ níɛ́tɛ́ mɛyĩ̀ĩ̀ ndibòrì tipíìtì tidɛ́ nɛ̀ dibòrì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Kɛ̀ bɛ̀ɛ pṹnnɛ́ dɛ kó imɑɑ nkɛ́ ì cɑ̀ɑ́kɛ́ kɛyènkɛ̀ nɛ̀ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti nɛ̀ tikũnfɑ̃ɑ̃̀tì tiiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ì bɑ́ nkpɑɑ́ kɛ bɛ nkɛ̀ dí ì cɑ̀ɑ́kɛ́, di mɛ mbɑ́ɑ́ ì bèńnɛ́, dí ì pũ̀ńnɛ́ imɔu, diyuu nɛ̀ itɑ̀ɑ̀kɛ nɛ̀ tinɑutì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Dí bɑ́ɑ́ cɑ́ɑ́kɛ́ kɛ́súɔ́ ndɛ̀mɑrɛ̀. Kɛ̀ dɛ̀ɛ̀ kpɑɑ́ kɛ̀ dɛ̀ wentɛ́ dí dɛ̀ cɔ́u. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Dí nfɛ̀ cɑ̀ɑ́ nkɛ yi di nɑɑ̀kũ̀ɔ̃ nkɛ níɛ́ di nɛùtì kɛ tɔ di pɑ̀ɑ̀ti, kɛ́ nfɛ̀ cɑ̀ɑ́ nkɛ dɔ́ mɛcɑ̃ɑ̃. Diyentɛ́bɑnni ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Dɛ kó kɛyènkɛ̀ m bo fitɛ́ kɛtenkɛ̀ kɛmɔu kɛ́kuɔ bɛ̀ɛ̀ tu Mpo Esibiti miɛkɛ nɛ̀ iwũɔ̃ idɑɑyì iketiyì. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Di nìɛ́kɛ́ mɛ̀ɛ̀ yĩ̀ĩ̀ ndi bòrɛ̀, mɛɛ̀ yó nte kɛ̀ m pɛ̃ɛ̃tɛ́ di cɛ̃́ĩ kɛ́kuɔ Esibiti bɛ̀ɛ̀ tu Mpo kɛ́ di yóu. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Di yó mbɑɑ̀mmu dɛ kó diyiè kɛ denniní n kpɛ́í nsɑ̃́ɑ̃̀, ikuɔ́ nyi n di duɔ́ nyì kɛ̀ ì yó mbo. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yɛwe yɛ̀yiekɛ̀ miɛkɛ di bɑ́ nyo mpɛ̃́ɛ̃̀ wèè kɔɔrɛnɛ̀ mutie mùù muuti pɛ̃́ɛ̃̀, diyiè ketirì yiè dí mù dènnɛ di cɛ̃́ĩ, yɛwe yɛ̀yiekɛ̀ yɛnyɛ miɛkɛ. Kɛ̀ wèè cɑ̀ɑ́kɛ́ pɛ̃́ɛ̃̀ wèè kɔɔrɛnɛ̀ mutie mùù muuti pɛ̃́ɛ̃̀ bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Dɛ kóo tɑ̃̀nkù yiè ketirì nɛ̀ diyiénnì di níí tíí nkɛ́bɑɑ́ ndibɑnni, di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù dɛ kó yɛwe kɛ̀ dɛ̀ í tú di bo bénnɛ́mɛ̀ mudiì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Di yó mbɑɑ̀ ndɛ kó dibɑnni kɛ denniní n di dènnɛ dìì yiè ndi Esibiti tenkɛ̀. Dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀ kɛ̀ di nyì dɔ̀ɔ̀ri. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Dɛ kóo tɑ̃̀nkù diyiè tɛpíítɛ̀ nɛ̀ dinɑɑnnì yiè kuyuoku kɛ́tuɔkɛnɛ̀ sipísìdɛ́ nɛ̀ dìmɑ́ɑ̀ yiè kuyuoku, di bo ncɑ́ɑ́ mpɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti bɛ̀mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Dɛ kó yɛwe yɛ̀yiekɛ̀ miɛkɛ mutie mùù ɔ̃ nte kɛ̀ pɛ̃́ɛ̃̀ múútí mù bɑ́ mbo di cɛ̃́ĩ. Dɛ kó yɛwe miɛkɛ wèè bo cɑ́ɑ́kɛ́ pɛ̃́ɛ̃̀ wèè kɔɔrɛnɛ̀ mutie mùù muuti bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ cuokɛ̀, bɑ́ kòò tu opɔ̀ɔ̀ yoo Isidɑyɛɛri. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Bɑ́ kɛ̀ di bo kɛ̀ɛ̀ bíɛ́kɛ̀ di bɑ́ ncɑ́ɑ́ mpɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ kɔɔrɛnɛ̀ mutie mùù muuti dɛ kó yɛwe. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Kɛ̀ Mɔyiisii yú Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Kònnɛ̀ kɛ́pĩ́mmú ipe yoo sibɔɔ́ bɑ́ tɛ̀ɛ̀ cĩ́ɛ̃̀tɛ̀, kɛ́fíé diyentɛ́bɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Dí wɑɑ́ ìsɔ́pù kó tifɑ̃ɑ̃̀tì kɛ́pɔɔ̀tɛ̀ mɛyĩ̀ĩ̀ ndinɑɑbuu miɛkɛ kɛ́níɛ́tɛ́ dibòrì tipíìtì tidɛ́ nɛ̀ dibòrì ĩ́nkɛ̀. Òmɔù bɑ́ɑ́ yɛ̀ ditowɑɑ̀ kɛ̀ dɛ̀ yɑ̀ɑ wentɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Di Yiɛ̀ nKuyie ntɑtinímu kɛyènkɛ̀ kɛ bo kuɔ Esibiti kɔbɛ, kɛ̀ kù yɑ̀ mɛyĩ̀ĩ̀ ndibòrì kù bɑ́ɑ́ yóu kòo kɔ̀ùtìi tɑ di cɛ̃́ĩ. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Di yó ndɔɔrimu dɛ kó ikuɔ́ sɑ̃́ɑ̃̀ nɛ̀ di yɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Kɛ̀ di tɑ kɛtenkɛ̀ di Yiɛ̀ nKuyie nyɛ̃ nkù yóó di duɔ́ nkɛ̀, dí ndɔɔri dɛ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Kɛ̀ di bí di bekɛ kɛ tú, ɔ̃̀nyi kuɔ́ nyi di dɔɔrimɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Di dɔ̀: Ti dɔɔri diyentɛ́bɑnni kó ikuɔ́ nyi kɛ dɛ́úkùnko ti Yiɛ̀ nKuyie nyètìrì, kù do pɛ̃ɛ̃tɛ́mɛ̀ ti cɛ̃́ĩ kɛ́kuɔ Esibiti kɔbɛ kɛ́ ti yóu. Dɛ mɔ̀nnì kɛ̀ Isidɑyɛɛribɛɛ sĩ́nnɔ́ɔ kɛ́nínkú, ");
INSERT INTO tbzsim_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","kɛ́ítɛ́ kɛ́kũṹ mbɛ cɛ̃́ĩ kɛ́dɔɔ̀ Kuyie ndo nɑ̀kɛ́ ti Mɔyiisi nɛ̀ Anɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Kɛyènkɛ̀ cuokɛ̀ kɛ̀ ti Yiɛ̀ nKuyie nkɔtɛní kɛ́kuɔ bɛ̀ɛ̀ tu Mpo Esibiti tenkɛ̀ miɛkɛ, kɛ́kuɔ okpɑ̀ɑ̀tì kóo po, wèè do yóó ò cɔutɛ́ tikpɑ̀tì kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kudɑɑkù kùù bo dikpetíntou ku kóo po nɛ̀ iwũɔ̃ idɑɑì iketiyì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Okpɑ̀ɑ̀tì nɛ̀ o tũ̀mbɛ̀ nɛ̀ o nìtìbɛ̀ kɛ̀ bɛ̀ɛ entɛ kɛyènkɛ̀ kɛ́nkuɔ̀ nhEsibiti yɛkúdɑbùò, kɛ yɛ̃́ tɛcĩ́ɛ̃̀tɛ̀ mɑtɛ̀ do í sokɛ́mɛ̀ tɛ̀ɛ̀ kou í ku. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Kòo kpɑ̀ɑ̀tìi yú Mɔyiisi nɛ̀ Anɔɔ dɛ kó kɛyènkɛ̀ kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Díndi nɛ̀ di kɔbɛ yɛ̀nnɛ̀ n kɔbɛ cuokɛ̀, kɔtɛnɛ̀ kɛ́fíé iwũɔ̃ di Yiɛ̀ nKuyie kɛ́ndònnɛ̀ di bɛ́immɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Túótɛ́nɛ̀ di wũɔ̃ imɔu kɛ́yɛ̀ kɛ́ndònnɛ̀ di bɛ́immɛ̀. Di bɑ́ntɛ̀ Kuyie nkɛ̀ kù n dɔɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Kɛ̀ Esibiti kɔbɛ ńkuɔ̀ nkɛ tú, ti yóó kú timɔu ndi, kɛ́mpɛ́inko Isidɑyɛɛribɛ kɛ tú: Yɛ̀nnɛ̀ mɛcɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kɛ̀ bɛ̀ɛ túótɛ́ tipɛ̃́ɛ̃̀cootì tìì í mùútí nɛ̀ yɛbɔ kɛ́ditìnnɛ kɛ́tɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Kɛ̀ bɛ̀ɛ dɔɔ̀ Mɔyiisi bɛ̀ nɑ̀kɛ́ tì kɛ́múɔ́kɛ́ Esibiti kɔbɛ yɛsɔɔbɔ nɛ̀ timɑ́tì pɛ́ítì kpɛyɛ nɛ̀ tiyɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Kɛ̀ ti Yiɛ̀ nKuyie ndɔɔ̀ Isidɑyɛɛribɛ mɛsɑ̀ɑ̀, kɛ̀ Esibitii kɔbɛ mbɛ̀ pɑ̃ɑ̃ mbɛ̀ mɔ̀ú dɛ̀. Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛɛ tɔ Esibiti kɔbɛ kpɛrɛ kɛ́yɛ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ Dɑmmusɛsi kɛ́kɔtɛ Sukɔti, bɛ̀ do bo ntùɔ̀kɛ bɛnìtìbɛ̀ sikɔupíkɔ̀usìkuɔ̀ (600000). Bɛ̀ í nkɑ̀ɑ mbɛnitipòbɛ̀ nɛ̀ ibí. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Kɛ̀ sɔ̃́ntíkɛ kɔbɛ mɑbɛ̀ mbɛ̀ nɛínɛ̀ nɛ̀ iwũɔ̃ pɛ́u nɛ̀ ipe nɛ̀ inɑ̀ɑ̀kɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Kɛ̀ bɛ̀ɛ pṹnnɛ́ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti, kɛ́ yɛ̃́ bɛ̀ do bɛ̀ bɛ̀timɛ̀ Esibiti, kɛ̀ bɛ̀ nyɛtì mɛcɑ̃ɑ̃, mbɛ̀ í ntɔ tidiitì mɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Isidɑyɛɛribɛ do bo Esibiti kɛ dɔ̀ yɛbie sikɔusìnɑ̀ɑ̀ nɛ̀ sipísìtɑ̃ɑ̃ti (430) ndi, ");
INSERT INTO tbzsim_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","kɛ́yɛ̀ bɛ nɑɑ̀mùntì tũ̀ ntũ̀ mmɛ̀ɛ̀ botí titɔbɛ̀. Bɛ̀ do yɛ̀ yɛbie nsikɔùsìnɑ̀ɑ̀ nɛ̀ sipísìtɑ̃ɑ̃ti kpɛri kó diyiè sɔnni ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Dɛ kó diyiè kó kɛyènkɛ̀ bɛ̀ yó nkɛ̀ bɑɑ̀mmu sɑ̃́ɑ̃̀ kɛ dɛ́úkùnko ti Yiɛ̀ nKuyie nyètìrì, kù bɛ̀ dɛɛtɛ́ kɛ̀ɛ̀ yènkɛ̀ nkɛ Esibiti tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: Ntɛ diyentɛ́bɑnni kó ikuɔ́: Opɔ̀ɔ̀ mɔù bɑ́ɑ́ di dɛ kó mudiì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Kɛ̀ kudɑɑkù bo bɛ̀ dontɛ́ kù, dí kù cɑ̃ntɛ́ kɛ̀ kùu di dɛ kó mudiì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Opɔ̀ɔ̀ nɛ̀ otɔ̃ntì bɛ̀ bɑ́ɑ́ mù di. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Dɛ kó imɑɑ ndi yóó ì cɑ̀ɑ́kɛ́ kudieku miɛkɛ nkɛ, di bɑ́ɑ́ ì yɛ̀nnɛ̀ ditowɑɑ̀, di mɛ mbɑ́ɑ́ kéétɛ́ dikɔ̃́ũ̀ mɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isidɑyɛɛribɛ bɛmɔu bɛɛ̀ yó mbɑɑ̀ ndɛ kó dibɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Kòo pɔ̀ɔ̀ mɔù dɔ́ kɛ́bɑɑ́ ndɛ kó dibɑnni kɛ́dɛ́úkùnnɛ mí ndi Yiɛ̀ nKuyie nyètìrì, wèe cɑ̃mmú o cĩ́ɛ̃̀tɛ̀ bɛnitidɑɑbɛ̀ bɛmɔu. Mɛm̀mɛ ò bo nɑmɛ̀ kɛ́ ndi kɔkɛ́nɛ̀, kòò í cɑ̃ntɛ́ ò bɑ́ɑ́ di dɛ kó mudiì. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Dɛ kó ikuɔ́ yó mbo díndi Isidɑyɛɛribɛ di kpɛ́í nkɛ nɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ bo di cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Kɛ̀ Isidɑyɛɛribɛɛ dɔɔ̀ Mɔyiisi nɛ̀ Anɔɔ bɛ̀ nɑ̀kɛ́ tì weti weti. ");
INSERT INTO tbzsim_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Dɛ kó diyiè ndi ti Yiɛ̀ nKuyie mbɛ̀ dènnɛmɛ̀, kɛ́ bɛ̀ tũ̀nnɛ bɛ nɑú bɛ nɑú, bɛ̀ dò nkɛ́ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","Dí nni nduɔ̀ mbɛ̀ɛ̀ tu Mpo nɛ̀ iwũɔ̃ ketiyì, dɛ̀ tu n kpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Kɛ̀ Mɔyiisii nɑ́kɛ́ bɛnìtìbɛ̀ kɛ dɔ̀: Dí ndenniní diyiè diì nkpɛ́í, di yɛ̀ dì Esibiti. Di do kɛ̀ tu tidɑɑtì nti, kɛ̀ ti Yiɛ̀ nKuyie ndi dènnɛní nɛ̀ ku kó muwɛ̃rímú. Kɛ̀ di bɑɑ̀ ndɛ kó dibɑnni di bɑ́ nyo mpɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ kɔɔrɛnɛ̀ mutie mùù muuti. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Di yɛ̀mu nyíe nhEsibiti mudidɛ̀ì kóo tɑ̃̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Kɛ̀ ti Yiɛ̀ nKuyie nti tɑnnɛ́ kù do yɛ̃ nkù yóó duɔ́ nkɛ̀ɛ̀ tenkɛ̀ ti yɛmbɛ̀, mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃̀ ndɛ̀, Kɑnnɑhɑ̃ɑ̃ botí kɔbɛ borɛ̀, Itiibɛ nɛ̀ Amɔriibɛ nɛ̀ Efiibɛ nɛ̀ Sebusiibɛ. Dí mbɑɑ̀ ndɛ kó dibɑnni bɑ́ dìì benni dɛ kóo tɑ̃̀nkù Kuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Yɛwe yɛ̀yiekɛ̀ miɛkɛ dí ncɑ́ɑ́ mpɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti diyiénnì yiè kɛ́bɑɑ́ ndiyentɛ́bɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Dɛ kó yɛwe yɛ̀yiekɛ̀ miɛkɛ di bɑ́ ncɑ́ɑ́ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ kɔɔrɛnɛ̀ mutie mùù muuti, dɛ kóo pɛ̃́ɛ̃̀ mɛ mbɑ́ mbo di cɛ̃́ĩ miɛkɛ, dɛ kó mutie mɛ mbɑ́ mbo dihɛì dimɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Dɛ kó diyiè di nnɑ́ɑ́ ndi bí kɛ tú: Ti bɑɑ̀ ndɛ kó dibɑnni ti Yiɛ̀ nKuyie nti dɔ̀ɔ̀ dɛ̀ kpɛ́í nkɛ ti yɛtì dìì mɔ̀nnì Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Dɛ kó dibɑnni yó ńdò ndibɛnkɛ̀rì ndi di kpɛ́í, kɛ̀ dí dì dɔ̀ɔ̀ mɛcɑnnimɛ̀ kɛ́ mmɛ̀ ũ di nɔu kɛ mɛ̀ ìrí di tĩ́ĩ̀, kɛ̀ mɛ̀ di denniní di Yiɛ̀ nKuyie nkó ikuɔ́ kùù di dènnɛ Esibiti nɛ̀ ku wɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Bɑ́ dìì benni di níí dɔɔ̀ dɛ kó ikuɔ́ dɛ kó dimɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Kɛ̀ ti Yiɛ̀ nKuyie nti tɑnnɛ́ Kɑnnɑhɑ̃ɑ̃ tenkɛ̀ kù dò yɛ̃ nkù yóó duɔ́ nkɛ̀ ti yɛmbɛ̀ nɛ̀ tínti. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Tí nkù duɔ̀ mbɛ̀ɛ̀ tu Mpo nɛ̀ iwũɔ̃ dɑɑì ketiyì, kuù dɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Disɑ̃mmɑrímbii didɑɑrì ketirì di níí dì cèètɛ nɛ̀ dipebii. Kɑ̀ɑ mɛ nyí yóó di cèètɛ, ɑ pitɛ́ di fɔ̃̀níí kɛ́kuɔ, kɛ níí kù dontɛ́nɛ̀ bɛ̀ɛ̀ tu Mpo. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Kɛ̀ ti bí ti bekɛ kɛ tú dɛ kó mɛdɔɔ̀rìmɛ̀ tu bɑ? Ti dɔ̀: Kuyie nti dènnɛ dìì yiè ndì Esibiti nɛ̀ ku wɛ̃rímú ti do tú dɛ̀ tidɑɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Okpɑ̀ɑ̀tì weè do kpénkùnnɛ o to kɛ́yetɛ ti bo yɛ̀mɛ̀ kɛ̀ ti Yiɛ̀ nKuyie nkuɔ Esibiti kɔbɛ bɛ̀ɛ̀ tu Mpo nɛ̀ iwũɔ̃ ketiyì. Dɛɛ̀ kpɛ́í nte kɛ̀ ti kù duɔ̀ nyiwũɔ̃ ketiyì kɛ ɔ̃ɔ̃ kù dontɛ́nɛ̀ bɛ̀ɛ̀ tu Mpo. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Dɛ kó ikuɔ́ yó ntú dibɛnkɛ̀rì ndi di kpɛ́í, kɛ̀ di ì dɔ̀ɔ̀ mɛcɑnnimɛ̀ kɛ́ṹ di nɔu kɛ ì ìrí di tĩ́ĩ̀ nkɛ̀ ì ndi denniní ti Yiɛ̀ nKuyie ndi dènnɛmɛ̀ Esibiti nɛ̀ ku kó muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Okpɑ̀ɑ̀tì yóu dìì mɔ̀nnì Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ yɛ̀, kɛ̀ Kuyie nyí nyóu kɛ̀ bɛ̀ɛ yɛ̀ Fidisitɛ̃ɛ̃bɛ tenkɛ̀ kó kucɛ kùù tɔ̀kɛ́, bɛ̀ yɑ̀ɑ̀ bo yɔtɛ mudoò kɛ́wɛ̃tɛ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kɛ̀ kùu duɔ́ nkɛ̀ bɛ̀ɛ kɔ́ntɛ́ dikpɑ́ɑ̀ kɛ́wetínnɛ́ tipèntì kóo dɑ̀mɛ́ɛ̀rì. Isidɑyɛɛribɛ do yɛtì Esibiti tenkɛ̀ kɛ tũ mbɛ nɑú bɛ nɑú nyi, bɛ̀ dò nkɛ́ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Kɛ̀ Mɔyiisii túótɛ́ Sosɛfu kṹɔ̃̀ kɛ yɛ̃́ ò do duɔ́mmɛ̀ kɛ̀ Isidɑyɛɛri bíí yú Kuyie nyètìrì, kòò dɔ̀: Kuyie nyóó di dennɛmu diɛ, kɛ̀ di yɛtì dí ntɔ n kṹɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Kɛ̀ bɛ̀ɛ ítɛ́ Sukɔti kɛ́kɑri Etɑmmu dikpɑ́ɑ̀ nùù. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Kɛ̀ ti Yiɛ̀ nKuyie nní mbɛ̀ ni, kɛ níí ndò ndiwɛtirì kuyie mmɔ̀nnì, kɛ́ndò ndihɑ̃ɑ̃tĩnni kɛyènkɛ̀. Kɛ̀ bɛ̀ɛ nɑ kɛ́nkérí kɛyènkɛ̀ nɛ̀ kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Dɛ kó diwɛtirì do ɔ̃ɔ̃ í nyìtɛ́ bɛ ììkɛ̀ kuyie mmɔ̀nnì, kɛyènkɛ̀ dihɑ̃ɑ̃tĩnni mɛ mbɑ́ɑ́ ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ̀ dí kɔ́ntɛ́ kɛ́bɑ́tɛ́ Pi-Aidɔti, Mikidɔdi nɛ̀ dɑ̀mɛ́ɛ̀rì dɛ cuokɛ̀. Di yóó dɛ mbɑ́tɛ́, kɛ́nco Bɑɑri-Sefɔ̃ɔ̃, kɛ́ntɔ́kɛ́nɛ̀ dɑ̀mɛ́ɛ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Okpɑ̀ɑ̀tì yɛ̀mmɛ̀ yó ndò ndi fetimu dikpɑ́ɑ̀ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Kɛ̀ n kpénkùnnɛ o to, kòo di tũnnɛ kɛ̀ nh ò kùɔ nɛ̀ o ɑ̃ɑ̃pɔ̀mbɛ̀ kɛ́dɛ́úkùnnɛ n yètìrì, kɛ̀ Esibiti kɔbɛɛ bɑntɛ́ míì tumɛ̀ di Yiɛ̀ nKuyie. Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛɛ dɔɔ̀ Kuyie mbɛ́i ntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kɛ̀ bɛnìtìbɛ̀ɛ nɑ́kɛ́ okpɑ̀ɑ̀tì kɛ dɔ̀: Isidɑyɛɛribɛ cokɛ́mu, kòo yɛ̀mmɛ̀ɛ ceetɛ, wenwe nɛ̀ o tũ̀mbɛ̀, kɛ̀ bɛ̀ dɔ̀: Ti dɔ̀ɔ̀ bɑ kɛ yóu kɛ̀ bɛ̀ yɛ̀, kɛ yóu mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kòo kpɑ̀ɑ̀tìi tũntɛ o kpɑ̀rìsɑ̃ntɛ̀ kɛ́bɑ́ɑ́tí nɛ̀ o ɑ̃ɑ̃pɔ̀mbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","kɛ́túótɛ́ Esibiti kó sikpɑ̀rìsɛ̃ĩ́ simɔu sìì kpeńnì kɛ̀ sì ḿbo sikɔu sìkuɔ̀ (600), bɑ́ tɛ̀ɛ kpɑ̀rìsɑ̃ntɛ̀ nɛ̀ tɛ dèèbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Kɛ̀ ti Yiɛ̀ nKuyie nkpénkùnnɛ o to, kòo bɛ̀ tũ̀nnɛ. Isidɑyɛɛribɛ do í yɛ̀ disɔ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Okpɑ̀ɑ̀tì nɛ̀ o ɑ̃ɑ̃pɔ̀mbɛ̀ nɛ̀ sikpɑ̀rìsɛ̃ĩ́ nɛ̀ si dèèbɛ̀ kɛ̀ bɛ̀ɛ bɛ̀ tũ̀nnɛ kɛ́ bɛ̀ nìntɛ Pi-Aidɔti tɑkɛ́ kɛ̀ bɛ̀ co Bɑɑdi-Sefɔ̃ɔ̃, kɛ́ntɔ́kɛ́nɛ̀ dɑ̀mɛ́ɛ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Kɛ̀ Isidɑyɛɛribɛɛ wéntɛ́ kɛ́ bɛ̀ yɑ̀, kɛ sɔ̃́ nhokpɑ̀ɑ̀tì ɑutóo, kɛ̀ kufɔ̃wɑɑ́ mbɛ̀ ɑutɛ́ kɛ̀ bɛ̀ nkuɔ̀ nkɛ yu ti Yiɛ̀ nKuyie, ");
INSERT INTO tbzsim_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Ifɔ̃ti í bo Esibitɑ̀ɑ̀? Dɛ̀ dòmmɛ kɑ̀ɑ ti dènnɛní Esibiti kɛ̀ ti bo kú dikpɑ́ɑ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Ti sòò dɑ nɑ̀kɛ́mu ti kpɑɑ́ bo dìì mɔ̀nnì Esibiti kɛ dɔ̀: A ti yóu ti bo mpĩ́mmɛ̀ Esibiti kó mutɔ̃mmú, dɛ̀ tɔ̃ũnɛ̀ ti bo kúmɛ̀ dikpɑ́ɑ̀ diì mmiɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Kɛ̀ Mɔyiisi dɔ̀: Di bɑ́ nyĩɛ̃̀kù, yĩ́nɛ̀ só kɛ́yɑ̀ Kuyie nyóó di dɛɛtɛ́nɛ̀mɛ̀ Esibiti kɔbɛ di mɛ nwúó mbɛ̀, di tɛ̃́nkɛ í yóó bɛ̀ yɑ̀ diyiè mɑrì bìtì! ");
INSERT INTO tbzsim_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Ndònnɛ̀ bɛ́u! Ti Yiɛ̀ nKuyie nkuù yóó kpɑ ndi kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Dɛ̀ yĩ́mɛ kɑ̀ɑ n yu? Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ kétɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Youtɛ ɑ pɑ̀ɑ̀ti dɑ̀mɛ́ɛ̀rì ĩ́nkɛ̀ kɛ̀ mɛniɛ nkéétɛ́, kɛ̀ bɛ̀ɛ nɑ dɛkperɛ̀ kɛ́séntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","N yóó kpénkùnnɛmu Esibiti kɔbɛ to, kɛ̀ bɛ̀ di tũnnɛ, kɛ̀ n kuɔ okpɑ̀ɑ̀tì nɛ̀ o ɑ̃ɑ̃pɔ̀mbɛ̀ nɛ̀ o nɑɑsɛ̃ĩ́ nɛ̀ si dèèbɛ̀ kɛ́dɛ́úkùnnɛ n yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","M bo kuɔ mɛ̀ɛ̀ botí okpɑ̀ɑ̀tì nɛ̀ o ɑ̃ɑ̃pɔ̀mbɛ̀ nɛ̀ o kpɑ̀rìsɛ̃ĩ́ nɛ̀ si dèèbɛ̀ bo nte kɛ̀ Esibiti kɔbɛɛ bɑntɛ́ míì tumɛ̀ di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Kuyie ntɔ̃nnì dìì ni Isidɑyɛɛribɛ kɛ̀ dìi ítɛ́ bɛ ììkɛ̀ kɛtũnnɛ bɛ fɔ̃nkúò. Kɛ̀ diwɛtirì dìì ni bɛ ììkɛ̀ kɛ̀ dìi ítɛ́ kɛ́tũnnɛ bɛ̀ fɔ̃nkúò, ");
INSERT INTO tbzsim_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","kɛ́sootɛ́ Esibiti kɔbɛ nɛ̀ Isidɑyɛɛribɛ bɛ cuokɛ̀, kɛ́ntú dibiìnnì Esibiti kɔbɛ bíɛ́kɛ̀, kɛ tú kuwenniku Isidɑyɛɛribɛ bíɛ́kɛ̀. Bɛ̀ í ntɔ̀ɔ́nnɛ̀ bɛtɔbɛ̀ kɛyènkɛ̀ kɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Kɛ̀ Mɔyiisii youtɛ o nɔ̀ùtɛ̀ dɑ̀mɛ́ɛ̀rì ĩ́nkɛ̀, kɛ̀ ti Yiɛ̀ nKuyie nduɔnní diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó kuyɑɑkù, kɛ̀ kù nyié nkɛ fuuti, kɛ́kéétɛ́ mɛniɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Kɛ̀ mɛ̀ɛ kpɛ̃́nnɛ́ tipíìtì tìdɛ́ kɛ́ndò nyiduotí, kɛ̀ Isidɑyɛɛribɛɛ nɑ dɛkperɛ̀ kɛ́séntɛ́ bɑ́ bɛ nɑɑ̀cɛ̀i í mbùútɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Kɛ̀ Esibiti kɔbɛɛ bɛ̀ tũ̀nnɛ nɛ̀ okpɑ̀ɑ̀tì nɛ̀ o kpɑ̀rìsɛ̃ĩ́ nɛ̀ si dèèbɛ̀, kɛ́tɑ dɑ̀mɛ́ɛ̀rì cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Kukṹnwentóo mɔ̀nnì kɛ̀ ti Yiɛ̀ nKuyie nwéntɛ́ní dihɑ̃ɑ̃tĩnni nɛ̀ diwɛtirì miɛkɛ kɛ́yɑ̀ Esibiti kɔbɛ kó fɛhɑ̃ɑ̃pɔ̀nnɑfɛ, kɛ́ bɛ̀ bɔntɛ́ dikɔnkɔɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Kɛ̀ bɛ kpɑ̀rìsɛ̃ĩ́ĩ cɑkɛ kɛ̀ bɛ̀ɛ yĩɛ̃kɛ mucèmmu, kɛ dɔ̀: Tí cokɛ́nɛ̀, bɛ Yiɛ̀ nKuyie nkuù bɛ̀ kòḿmú kɛ ti kpɑ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Youtɛ ɑ nɔ̀ùtɛ̀ dɑ̀mɛ́ɛ̀rì ĩ́nkɛ̀ kɛ̀ mɛniɛ nwɛ̃tɛ kɛ́dɑ́tínnɛ́ Esibiti kɔbɛ nɛ̀ bɛ kpɑ̀rìsɛ̃ĩ́ nɛ̀ si dèèbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Kɛ̀ Mɔyiisii youtɛ o nɔ̀ùtɛ̀ dɑ̀mɛ́ɛ̀rì ĩ́nkɛ̀ kukṹnwentóo mɔ̀nnì kɛ̀ mɛniɛ nwɛ̃tɛní mɛ̀ do dòmmɛ̀, kɛ̀ Esibiti kɔbɛɛ mɛ̀ yɑ̀ kɛ́ncokù kɛ̀ ti Yiɛ̀ nKuyie nduɔ́ nkɛ̀ mɛ̀ɛ bɛ̀ pɔ̃ntɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Kɛ̀ mɛniɛ dɑ́tínnɛ́ sikpɑ̀rìsɛ̃ĩ́ nɛ̀ si dèèbɛ̀ nɛ̀ okpɑ̀ɑ̀tì ɑ̃ɑ̃pɔ̀mbɛ̀ bɛ̀ɛ̀ tũ nyIsidɑyɛɛribɛ, bɑ́ òmɔù í nyentɛ́ bɑ́ omɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Mɛniɛ ndo kpɛ̃̀ńnɛ́ kɛ́ndò nyiduotí nyi, kubɑkù yoú nɛ̀ kucɑ̃̀nku, kɛ̀ Isidɑyɛɛribɛ nɑ dɛkperɛ̀ késéntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Dɛ yiè ndi ti Yiɛ̀ nKuyie ndɛɛtɛ́nɛ̀mɛ̀ Isidɑyɛɛribɛ Esibiti kɔbɛ kɛ̀ Isidɑyɛɛribɛ yɑ̀ Esibiti kɔbɛ kumɛ̀ dɑ̀mɛ́ɛ̀rì nùù, ");
INSERT INTO tbzsim_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","kɛ́yɑ̀ ti Yiɛ̀ nKuyie nkpeńnìmɛ̀ kɛ kùɔ Esibiti kɔbɛ kɛ́ kù yɔ̀tɛ, kɛ́yie nku kpɛti nɛ̀ ku kóo tɔ̃ntì Mɔyiisi kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Mɔyiisi nɛ̀ Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ dentɛ̀ fɛyɛ̀nfɛ̀ fiɛ nkɛ́sɑ̃ntɛnɛ̀ ti Yiɛ̀ nKuyie nkɛ dɔ̀: M bo ndiè nkɛ sɑ̃ntí ti Yiɛ̀ nKuyie, kù bɛnkɛmɛ̀ ku wɛ̃rímú dɛumɛ̀, kɛ diu ntɛsɑ̃ntɛ̀ nɛ̀ tɛ dèètì kɛ̀ dɛ̀ pɔ̃ntɛ́ dɑ̀mɛ́ɛ̀rì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Ti Yiɛ̀ nKuyie nkuù tu n wɛ̃rímú n yó ndiè nkɛ ku nsɑ̃ntí, kuù n dɛɛtɛ́, kuù n te, n yó nku ndonti, n cicɛ do ku ntũ, n yó ndɛ́úkùnko kuù yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Ti Yiɛ̀ nKuyie ntú okpɑ̀rì nwe, kɛ sɑ̀nnɛ̀ o yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Kuù dìu nhokpɑ̀ɑ̀tì kpɑ̀rìsɛ̃ĩ́ nɛ̀ o ɑ̃ɑ̃pɔ̀mbɛ̀ dɑ̀mɛ́ɛ̀rì miɛkɛ kuù duɔ́ nkɛ̀ iwɛ̃ĩ yɛmbɛ̀ pɔ̃ntɛ́ tipèntì kóo dɑ̀mɛ́ɛ̀rì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Kɛ̀ dɑ̀mɛ́ɛ̀rì fũ̀ɔ̃̀ kó mɛniɛ mbɛ̀ dɑ̀tínnɛ́, kɛ̀ bɛ̀ dìu kɛ cùtóo ditɑ̃́rì kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Ti Yiɛ̀ nKuyie nhɑ kpeńnìmu, Ti Yiɛ̀ nKuyie nfɔ̃́ɔ̃̀ kèkíí ɑ dootitɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","A kó tikpetì tiì te kɑ̀ɑ nɑ ɑ dootitɔbɛ̀, kɑ̀ɑ miɛkɛ kó muhɑ̃ɑ̃́ mbɛ̀ cɔ̀útɛ́ timúkpetì kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Kuyie fɔ̃́ɔ̃̀ wei kɛ̀ mɛniɛ nkpɛ̃̀ńnɛ́ kɛ̀ yɛnɛ́fĩ̀nfĩ̀rɛ̀ nɑɑ́ nyiduotí, kɛ còḿmú kɛ tɛ̃́nkɛ í pũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ti dootitɔbɛ̀ do nɑ́ɑ́mmu kɛ tú: Ti bo bɛ̀ tũ̀nnɛ kɛ́ bɛ̀ nìntɛ, kɛ́fekɛ bɛ kpɛrɛ, kɛ́di kɛ́nsɑ̀nnɛ̀. Ti bo kpɑtɛ ti se kɛ́ bɛ̀ kùɔ bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Kuyie nkɑ̀ɑ wei kɛ̀ dɑ̀mɛ́ɛ̀rì bɛ̀ dɑ̀tínnɛ́, kɛ̀ bɛ̀ dìu kɛ cùtóo dibiɛrìmínnì kɔ̃mɛ mɛnɛ́kperímɛ̀ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","We mbo kɛ dɑ dònnɛ̀ fɔ̃́ nti Yiɛ̀ nKuyie? Kɛ dò mpɑ́íí, kɛ kpɑ mɛyɛi nkɛ kpeńnì, kɛ dɔɔri tidiɛtì kɛ̀ bɛ̀ ò dé. Fɔ̃́ɔ̃̀ nɔ nkɛ dɔɔri tidiɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Kuyie nfɔ̃́ɔ̃̀ yòùtɛ ɑ nɔ̀ùtɛ̀ mɛ̀mɑ́ɑ̀ kɛ̀ kɛtenkɛ̀ bɛ̀ mɑɑ́nko. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Nɛ̀ ɑ kó mɛsɑ̀ɑ̀ nkɛ niitɛ́ ɑ nìtìbɛ̀ ɑ dontɛ́ bɛ̀ nɛ̀ ɑ wɛ̃rímú, kɛ bɛ̀ kɔ̀rinɛ̀ ɑ tenkɛ̀ sɑ̀ɑ̀kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kɛ̀ bɛnìtìbɛ̀ tì kèè kɛ̀ bɛ̀ kɔ̃̀ntì ɑu, kɛ̀ Fidisitɛ̃ɛ̃bɛ kɔ̃m̀bùɔ̀tì duò. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Kɛ̀ Edɔmmu kó bɛkpɑ̀ɑ̀tìbɛ̀ yĩ̀ɛ̃̀kù, kɛ̀ kufɔ̃wɑɑ́ mpĩ Mɔɑbu kó bɛkpɑ̀ɑ̀tìbɛ̀, kɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ kɔ̃̀ntì yɑ̃rikɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Kufɔ̃wɑɑ́ ndiɛkù nɛ̀ kukɔ̃m̀bɔ̀dorí kɛ̀ dɛ̀ bɛ̀ ɑutɛ́. A nɔ̀ùtɛ̀ kpeńnìmu tɛɛ̀ te kɛ̀ dɛ̀ bɛ̀ kpeí, kɛ bɛ̀ dò nkɑ́rɛ́, kɛ kémmúnɛ̀ ɑ nìtìbɛ̀ bo pɛ̃ɛ̃tɛ́mɛ̀, ɑ nìtìbɛ̀ ɑ dontɛ́ bɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kɑ̀ɑ bɛ̀ kɔ̀rinɛ̀ ɑ tɑ̃rì ĩ́nkɛ̀, kɛ bo bɛ̀ kɑ̀nnɛ ɑ ɑ̃ dɛ̀. Ti Yiɛ̀ nKuyie nfɔ̃́ɔ̃̀ tũ̀ntɛ dikɑrì ɑ yó mborɛ̀, nɛ̀ ɑ nɔ̀ùtɛ̀ ntɛ ɑ mɑɑ́mɛ̀ ɑ cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ti Yiɛ̀ nKuyie nfɔ̃́ɔ̃̀ yó ntú okpɑ̀ɑ̀tì sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Okpɑ̀ɑ̀tì sɛ̃ĩ́ nɛ̀ o kpɑ̀rìsɛ̃ĩ́ nɛ̀ si dèèbɛ̀ dɛ̀ dìu dìì mɔ̀nnì mɛniɛ, kɛ̀ ti Yiɛ̀ nKuyie nduɔ́ nkɛ̀ dɛ̀ɛ pɔ̃ntɛ́, kɛ̀ Isidɑyɛɛribɛ biɛ séntɛ́ bɑ́ bɛ nɑɑ̀cɛ̀i í bùútɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Kɛ̀ Midiyɑmmu, Anɔɔ tɑ̃ũ̀ Kuyie mpɑ̃ɑ̃nɑ́ɑǹtì nɑ́ɑǹtò túótɛ́ dibɑ̀rì kɛ̀ Isidɑyɛɛribɛ kó bɛnitipòbɛ̀ bɛmɔuu ò tũ̀nnɛ, kòo mbie nkɛ̀ bɛ̀ ɑu. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Kòò dìè nkɛ tú: Nsɑ̃ntínɛ̀ ti Yiɛ̀ nKuyie kù bɛnkɛmɛ̀ ku wɛ̃rímú dɛumɛ̀, kɛ duɔ́ nkɛ̀ tɛsɑ̃ntɛ̀ dìu nɛ̀ tɛ̀ dèètì kɛ̀ dɛ̀ pɔ̃ntɛ́ dɑ̀mɛ́ɛ̀rì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Kɛ̀ Mɔyiisii bɛ̀ íi ntipèntì kóo dɑ̀mɛ́ɛ̀rì kɛ̀ bɛ̀ɛ kétɛ́ kɛ́nwetí dikpɑ́ɑ̀ diɛrì Suudi, kɛ́mmɔkɛ yɛwe yɛ̀tɑ̃ɑ̃ti bɑ́ bɛ̀ í pɛ̀tɛ́ mɛniɛ, ");
INSERT INTO tbzsim_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","kɛ́tuɔkɛ Mɑɑrɑ kɛ́yɑ̀ mɛniɛ mbɛ̀ í nnɑ kɛ mɛ̀ yɑ̃̀, kɛ yɛ̃́ mɛ̀ tiimɛ̀. Mɛ tiiku kpɛ́í nte kɛ̀ bɛ̀ mɛ̀ tu Mɑɑrɑ. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Kɛ̀ bɛnìtìbɛ̀ ńkpɑnnɛ̀ Mɔyiisi kɛ tú: Ti yóó yɑ̃̀ bɑ? ");
INSERT INTO tbzsim_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Kɛ̀ Mɔyiisii kuɔ́nnɛ̀ ti Yiɛ̀ nKuyie, kɛ̀ kùu ò bɛnkɛ kudɔú mɑkù, kòo kù mɛ̀ú nkɛ̀ mɛ̀ɛ nɑrikɛ. Kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ duɔ́ nyikuɔ́ kɛ́bɛnkɛ bɛ̀ yó ndɔɔrimɛ̀. Dɛǹdɛ Kuyie mbɛ̀ yɑ̀ɑ́kɛ́mɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Kɛ̀ di kémmú mí ndi Yiɛ̀ nKuyie n kpɛti, kɛ dɔɔri n dɔ́mɛ̀, kɛ kémmú n di nɑ́ɑ́ ntì, kɛ dɔɔri n kuɔ́ yɛ̃mmɛ̀, m bɑ́ɑ́ dì bɔntɛ́ mumɔmmú m bɔntɛ́ mù Esibiti kɔbɛ. Míì tu di Yiɛ̀ nKuyie nkùù di miɛkùnko. ");
INSERT INTO tbzsim_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Kɛ̀ bɛ̀ɛ tuɔkɛ dibòrì mɑrì bɛ̀ tu dì Edimmu kɛ̀ sibií dɛ̀ bo tɛpíítɛ̀ nɛ̀ sìdɛ́sì nɛ̀ dɛpuonnɛ sipísìyiekɛ̀ kɛ̀ bɛ̀ɛ dɛ̀ bɑ̀tɛ́ kɛ́ntɔ́kɛ́nɛ̀ mɛniɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ bɛmɔu Edimmu kɛ́tuɔkɛ Sinni kó dikpɑ́ɑ̀, Edimmu nɛ̀ Sinɑii dɛ cuokɛ̀, otɑ̃̀nkù dɛ́ríwè diyiè tɛpíítɛ̀ nɛ̀ dinummurì nɛ̀ bɛ̀ yɛ̀mɛ̀ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Kɛ̀ Isidɑyɛɛribɛ ńkpɑnnɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ tú: ");
INSERT INTO tbzsim_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Dɛ̀ yĩ́mɛ kɛ̀ ti Yiɛ̀ nKuyie nyí ti kùɔ Esibiti tenkɛ̀, ti do ɔ̃ nkɑri dɛ̀ kɛ̀ simɑnkṹmboó ĩ́ĩ́kú kɛ̀ ti yo nkɛ sɑnnɛ̀? Kɛ̀ di ti tɔní diɛ ndikpɑ́ɑ̀ diì mmiɛkɛ kɛ̀ ti bo kú timɔu nɛ̀ dikònnì? ");
INSERT INTO tbzsim_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: M bo cṹũnko kɛĩ́nkɛ̀ kó mudiì, bɑ́ wè ò níí yɛ̀ kɛ́koú ò yóó nɑ kɛ́dimɛ̀ dɛ kó diyiè. Mɛm̀mɛ n yóó di yɑ́ɑ́kɛ́mɛ̀ kɛ́yɑ̀ kɛ̀ di yie n nɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Diyiè kuɔ́nnì yiè, di níí yóó bénnɛ́ kɛ̀ dɛ̀ mmɑ̀nnɛ̀ di ɔ̃ɔ̃ bénnɛ́ mɛ̀mmɛ kucɛ mɛ̀dɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀: Kuyuoku kuù ndi bo bɑntɛ́ ti Yiɛ̀ nKuyie nkuù di dènnɛnímɛ̀ Esibiti tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Nɑnkɛ dikṹnweńnì kɛ́yɑ̀ ti Yiɛ̀ nKuyie nkó tikpetì, kù kèèmu di kù kpɑ̀nnɛ̀mɛ̀. Ti tú ɔ̃̀mbɛ kɛ̀ di ti kpɑnnɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Kɛ̀ Mɔyiisi dɔ̀: Kuyuoku kuù nti Yiɛ̀ nKuyie nyóó di duɔ́mmu imɑɑ nkɛ̀ dì cɑ́ɑ́kɛ́, nɑnkɛ dikṹnweńnì kɛ̀ kù di duɔ́ mmudiì kɛ̀ di di kɛ́nsɑ̀nnɛ̀. Kù kèèmu di kù kpɑ̀nnɛ̀mɛ̀. Ti tú ɔ̃̀mbɛ kɛ̀ di ti kpɑnnɛ̀? Di kpɑnnɛ̀ Kuyie nku. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Kɛ̀ Mɔyiisii nɑ́kɛ́ Anɔɔ kɛ dɔ̀: Nɑ́kɛ́ Isidɑyɛɛribɛ bɛmɔu kɛ̀ bɛ̀ɛ tɔ́ɔ́nní Kuyie mborɛ̀, kù kèèmu bɛ̀ kù kpɑnnɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Kɛ̀ Anɔɔ nkpɑɑ́ nɑ́ɑ́nnɛ̀ Isidɑyɛɛribɛ, kɛ̀ bɛ̀ɛ wɛ̃ɛ̃tɛ dikpɑ́ɑ̀ bíɛ́kɛ̀ kɛ́yɑ̀ ti Yiɛ̀ nKuyie nkó tikpetì diwɛtirì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú: Di níí bo cɑ́ɑ́kɛ́ imɑɑ nkuyuoku, dikṹnweńnì kɛ́di mudiì kɛ́nsɑ̀nnɛ̀, kɛ́bɑntɛ́ míì tumɛ̀ di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Kuyuoku mɔ̀nnì kɛ̀ yɛpɛ̀pɛ́rɛ̀ɛ yɛ̀nní kɛ́píɛ mbɛ kɑrì. Dikṹnweńnì kɛ̀ bɛ̀ɛ yɑ̀ dɛ̀ mɑ̀ntɛ̀mɛ̀ kɛ bɛ̀ fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Timɑɑ̀ntì yòtɛ dìì mɔ̀nnì kɛ̀ dɛ̀mɑrɛ̀ nkpɑɑ́ nɔ́nkɛ́ kɛtenkɛ̀ kɛ dò mmɛdibii nkɛ dò mmupɑ̃̀ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Kɛ̀ Isidɑyɛɛribɛ dɛ̀ yɑ̀ kɛ́nwúó nkɛ békú bɛtɔbɛ̀ kɛ tú: Bɑ́ nnì mmu? Kɛ̀ Mɔyiisii bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Kuyie ndi duɔ́ mmùù diì mmu. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ntɛ ti Yiɛ̀ nKuyie nyɛ̃ ndɛ̀ ndòmmɛ̀: Bɑ́ wè ò níí koú bɛnìtìbɛ̀ mɑ̀mɛ̀ o cĩ́ɛ̃̀tɛ̀. Dɛmɔ́mbirɛ dɛ̀mɑ́ɑ̀ onìtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Kɛ̀ Isidɑyɛɛribɛɛ koú, kɛ̀ bɛ̀mɑbɛ̀ kpɛrɛ ńsũ kɛ̀ bɛtɔbɛ̀ kpɛrɛ kɛ̃ńnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Kɛ̀ bɛ̀ɛ berínɛ̀ dɛmɔ́mbirɛ, kɛ̀ wèè do koú pɛ́u o kpɛrɛ í mpɛ̃ɛ̃tɛ́ dɛmɔ́mbirɛ, wèè do koú sɑ́m̀pɔ́ o kpɛrɛ í ndòńtɛ́ dɛmɔ́mbirɛ. Bɑ́ wè kɛ̀ dɛ̀ nhò sɑ̀nnɛ̀ ò bo dimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Kɛ̀ Mɔyiisii bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Òmɔù bɑ́ɑ́ súɔ́ mmudiì nɑnkɛ dikṹnweńnì kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kɛ̀ bɛ̀mɑbɛ̀ɛ yetɛ kɛ́súɔ́ nkɛ̀ yɛbiɛ̀ dɛ̀ tɑ, kɛ̀ dɛ̀ɛ ɑ̃nnɛ́ kunɔ́ú. Kɛ̀ Mɔyiisi miɛkɛɛ bɛ̀ pɛikɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Kɛ̀ bɛ̀ níí pikɛ koú bɛ̀ dò nkɛ́di kɛ̀ dɛ̀ mmɑmɛ̀, kɛ̀ diyiè tònkɛ̀ dɛ̀ɛ yɛntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Diyiè kuɔ́nnì yiè kɛ̀ bɛ̀ɛ koú dɛmɔ́mbirɛ mɛ̀dɛ́mɛ̀ dɛ́mɛ̀ onìtì. Kɛ̀ bɛkótíbɛ̀ɛ kɔtɛ kɛ́nɑ́kɛ́ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Kɛ̀ Mɔyiisi dɔ̀: Kuyie nyɛ̃ ndí ndɔɔri mɛ̀mmɛ. Nɑnkɛ tú tɛom̀pùtɛ̀ ntɛ̀, diyiè sɑ̀ɑ̀rì Kuyie ntɑ̃ɑ̃tɛ́ dì. Ciennɛ̀ di dɔ́ kɛ́cie ndɛ̀, kɛ́bénnɛ́ di dɔ́ kɛ́bénnɛ́ dɛ̀. Kɛ̀ di di kɛ̀ dɛ̀ɛ̀ sùɔ́ ndí dɛ̀ ĩ̀ńnɛ́ kɛ́mbɑɑ̀ nɑnkɛ dikṹnweńnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kɛ̀ bɛ̀ɛ súɔ́ nnɑnkɛ kpɛ́í, kɛ́ndònnɛ̀ Mɔyiisi bɛ̀ nɑ̀kɛ́mɛ̀. Kɛ̀ dɛ̀ɛ wentɛ́ dɛ̀ í nhɑ̃nnɛ́ kunɔ́ú, yɛbiɛ̀ mɛ nyí ndɛ̀ tɑ. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kɛ̀ Mɔyiisi dɔ̀: Dinɛ̀ tɛom̀pùtɛ̀ ntɛ yíe, Kuyie nkó diyiè. Kɛ̀ di yɛ̀ di í yóó pɛ́tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Di níí yóó koú yɛwe yɛ̀kuɔ̀ ndì. Diyiénnì yiè mù í yó mbo. Tɛom̀pùtɛ̀ ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kɛ̀ bɛ̀mɑbɛ̀ ncĩ́ɛ̃́kɛ́ kɛ́yɛ̀ diyiè yiénnì yiè kɛ bo koú kɛ́mɔ́ntɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kɛ̀ ti Yiɛ̀ nKuyie mbekɛ́ Mɔyiisi kɛ dɔ̀: Di yóó yie nhɔ̃̀mmɔ̀nnì, n di nɑ̀kɛ́ tì nɛ̀ n kuɔ́? ");
INSERT INTO tbzsim_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","N di duɔ́mmɛ̀ tɛom̀pùtɛ̀, dɛɛ̀ te kɛ̀ nh ɔ̃ɔ̃ di duɔ́ mmudiì diyiè kuɔ́nnì yiè kucɛ mɛ̀dɛ́mɛ̀. Tɛom̀pùtɛ̀ yiè bɑ́ wè ò níí nkɑri o cĩ́ɛ̃̀tɛ̀ ò bɑ́ɑ́ yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛ nhompu diyiè yiénnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Kɛ̀ Isidɑyɛɛribɛɛ yú dɛ kó mudiì kɛ dɔ̀: Mɑ́nnì. Mù do dònnɛ̀ mɛdibii mmɛ, kɛ wɛɛti kɛ dònnɛ̀ mucekɔ̀yuo. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Kɛ̀ Mɔyiisi dɔ̀: Ntɛ ti Yiɛ̀ nKuyie ntu mù: Bennɛ́nɛ̀ mɑ́nnì dɛmɔ́mbirɛ mɛ̀mɑ́ɑ̀ kòo mbo kɛ̀ di yɑɑ̀bí níí ò yɑ̀ kɛ́bɑntɛ́ mí nKuyie n di dènnɛ Esibiti kɛ́ ndi duɔ̀ mmùù diì dikpɑ́ɑ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Kɛ̀ Mɔyiisii nɑ́kɛ́ Anɔɔ kɛ dɔ̀: Bennɛ́ mɑ́nnì dɛmɔ́mbirɛ mɛ̀mɑ́ɑ̀ kɛ́utɛ́ diconkurì kɛ́ĩ́nnɛ́ ti Yiɛ̀ nKuyie ntɑummɛ̀ tɔu miɛkɛ kɛ̀ di bí nhò yɑ̀u. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Kɛ̀ Anɔɔ yie nti Yiɛ̀ nKuyie nnɑ̀kɛ́ tì Mɔyiisi kɛ́ɑ̃nnɛ́ mɑ́nnì diconkurì kɛ́ĩ́nnɛ́ mɛtɑummɛ̀ tɔu miɛkɛ ikuɔ́ nɛntì ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isidɑyɛɛribɛ do yo mmɑ́nnì nwe kɛ dɔ̀ yɛbie nsipísìnɑ̀ɑ̀. Bɛ̀ do yo mmɑ́nnì nwe kɛ yɑ̀ɑ tuɔkɛnɛ̀ Kɑnnɑhɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Bɛ̀ do bennɛ́nɛ̀ dɛ̀ɛ̀ mɔ́mbirɛ mɑ́nnì kɛ ĩ́nnɛ́ dɛ̀ do mɑ̀nnɛ̀ dítìrì mɛ̀nɑ̀ɑ̀ ndi.) ");
INSERT INTO tbzsim_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kɛ̀ Isidɑyɛɛribɛɛ yie nti Yiɛ̀ nKuyie mbɛ̀ nɑ̀kɛ́ tì, kɛ́ítɛ́ Sinni kó dikpɑ́ɑ̀, kɛ́nkérí kɛ́bɑ́tɛ́ Defidimmu, bɛ̀ í mpɛ̀tɛ́ mɛniɛ nkɛ yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kɛ̀ bɛnìtìbɛ̀ɛ íi ndikpɑ̀nnì nɛ̀ Mɔyiisi, kɛ́ntú: Tí duɔ́nnɛ̀ mɛniɛ nkɛ̀ tí yɑ̃̀. Kɛ̀ Mɔyiisi dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di n kpɑnnɛ̀? Dɛ̀ dòmmɛ kɛ̀ di yɑ́ú ti Yiɛ̀ nKuyie? ");
INSERT INTO tbzsim_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Kɛ̀ sinɛ́yɛ̃ĩ ɑutɛ́ bɛnìtìbɛ̀ kɛ̀ bɛ̀ ò kpɑ̀nnɛ̀ kɛ tú: A ti dènnɛní Esibiti kɛ̀ sinɛ́yɛ̃i siì bo ti kuɔ tínti nɛ̀ ti bí nɛ̀ ti wũɔ̃ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kɛ̀ Mɔyiisi kuɔ́nnɛ̀ ti Yiɛ̀ nKuyie nkɛ dɔ̀: N yóó dɔɔ̀ bɑ bɛnìtìbɛ̀ biɛ? Dɛ̀ kpɑɑ́ sɑ́m̀pɔ́ nwe kɛ̀ bɛ̀ m búɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Dɛitɛ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ mɑbɛ̀, kɛ́túótɛ́ ɑ pɑ̀ɑ̀ti ɑ do potɛ́nɛ̀ kù kukó nkɛ́niitɛ́ dɛ ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","N yó mbomu ditɑ̃rì Odɛbu kó dipèrì borɛ̀, kɑ̀ɑ dì potɛ́, kɛ̀ mɛniɛ nyɛ̀nní kɛ̀ bɛnìtìbɛ̀ɛ yɑ̃̀. Kɛ̀ Mɔyiisii dɔɔ̀ Kuyie nhò nɑ̀kɛ́ tì Isidɑyɛɛribɛ kó bɛkótíbɛ̀ ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Kɛ̀ bɛ̀ɛ yú dɛ kó dibòrì kɛ dɔ̀: Mɑsɑ nɛ̀ Mɛdibɑ, dɛ̀ɛ̀ tu Dikpɑ̀nnì nɛ̀ mɛyɑ́ɑ̀mɛ̀. Bɛ̀ do dɛ nyíinnɛ̀ dikpɑ̀nnì Mɔyiisi, kɛ́yɑ́ɑ́kɛ́ ti Yiɛ̀ nKuyie, kɛ́mbékú bɛmɑ́ɑ̀ kɛ tú: Kuyie nti bonɑ̀ɑ kɛ̀ kù í ti bonɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Kɛ̀ Amɑdesiibɛɛ dintɛ́ Isidɑyɛɛribɛ mudoò Defidimmu. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Kɛ̀ Mɔyiisi nɑ́kɛ́ Sosuwee kɛ dɔ̀: Tɑ̃ɑ̃tɛ́ bɛnìtìbɛ̀ kɛ́kɔtɛ kɛ́kpɑnnɛ̀ Amɑdesiibɛ. N nɑɑ yó mbo ditɑ̃rì ĩ́nkɛ̀ nkɛ, kɛ tɔ Kuyie mpɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Kɛ̀ Sosuwee dɔɔ̀ Mɔyiisi ò nɑ̀kɛ́ tì, kɛ́kɔtɛ kɛ́nkpɑnnɛ̀ Amɑdesiibɛ, Mɔyiisi nɛ̀ Anɔɔ nɛ̀ Uuri kɛ̀ bɛ̀ bo ditɑ̃rì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Kɛ̀ Mɔyiisi yùo o bɑkù Isidɑyɛɛribɛ ńnɔ, kɛ̀ kù cɔ̃̀nnɛ̀ Amɑdesiibɛ ńnɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Kɛ̀ Mɔyiisi bɑɑ̀ nhɔu, Anɔɔ nɛ̀ Uuri kɛ̀ bɛ̀ɛ wɑɑ́ nditɑ̃́rì, kòo kɑri, kɛ̀ yiè nni mpĩ nho bɑkù yoú, kòo tɔù pĩ nkucɑ̃̀nku. Kòo bɑɑ̀ nni nyuo kɛ̀ diyiè yɑ̀ɑ tɑnnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Kɛ̀ Sosuwee nɑ Amɑdesiibɛ, kɛ́ bɛ̀ kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Wɑ̃ri dɛ kó tinɑ́ɑǹtì dipɑ́tíri miɛkɛ kɛ̀ dí ntì yɛ̃́. N yóó kuɔmu Amɑdesiibɛ pɑ́í pɑ́í, bɑ́ òmɔù tɛ̃́nkɛ bɑ́ ndenniní bɛ kpɛ́í kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Kɛ̀ Mɔyiisii mɑɑ́ diwũɔ̃tɔ̀nnì kɛ́ dì yu kɛ dɔ̀: Ti Yiɛ̀ nKuyie ntú n kó mɛcɑnnimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Kɛ bɛ́i nkɛ dɔ̀: Amɑdesiibɛ mɛ̀ ndɑ̀ɑ́tímɛ̀ kɛ kpɑnnɛ̀ ti Yiɛ̀ nKuyie, kuù yó mbɛ̀ kpɑ̀nnɛ̀ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Kɛ̀ Setidoo Mɑndiyɑ̃ɑ̃bɛ kuɔ́ nìùtì, Mɔyiisi cɔ̀kùu keè ti Yiɛ̀ nKuyie ndɔ̀ɔ̀ dɛ̀ Mɔyiisi nɛ̀ Isidɑyɛɛribɛ, kɛ́keè kù bɛ̀ dènnɛmɛ̀ Esibiti, ");
INSERT INTO tbzsim_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","kɛ́túótɛ́ Mɔyiisi pokù Sefodɑɑ ò do duɔ́ nkɛ̀ wèe kònko, wenwe nɛ̀ o bí idɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Dɛketirɛ̀ yètìrì do tú Kɛdisɔmmu (dɛ̀ɛ̀ tu Mbo-Kupɔ̀ɔ̀kù). ");
INSERT INTO tbzsim_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Kòo sɑ́m̀pɔ́ù kpɛri tú Kù-Nteennɛ̀ (Nɛ̀ bɛ̀ kó tinɑ́ɑǹtì Ediesɛɛ). Kòò dɔ̀: Kuyie n cicɛ do tũ̀ nkù, kuù n teennɛ̀, kɛ̀ n yentɛ́nɛ̀ okpɑ̀ɑ̀tì siè. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Kɛ̀ Setidoo Mɔyiisi cɔ̀kùu túótɛ́ Mɔyiisi pokù nɛ̀ o bí idɛ́, kɛ́kɔtɛ Mɔyiisi borɛ̀, kɛ sɔ̃́ mbɛ̀ bɑ̀tɛ́ Kuyie ntɑ̃rì tɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Kòo nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Mí nSetidoo ɑ cɔ̀kù, míì tɔní ɑ pokù nɛ̀ ɑ bí idɛ́, kɛ kɔ̀tɛnɛ̀ní ɑ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Kɛ̀ Mɔyiisi ò co, kóò ɔrí, kɛ̀ bɛ̀ɛ bekɛ bɛtɔbɛ̀ kɔ̃nnɑɑtí, kɛ́tɑ Mɔyiisi tou. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Kòo nɑ́kɛ́ ò cɔ̀kù ti Yiɛ̀ nKuyie ndɔ̀ɔ̀mɛ̀ Esibiti kóo kpɑ̀ɑ̀tì nɛ̀ o kɔbɛ, Isidɑyɛɛribɛ kpɛ́í nnɛ̀ bɛ̀ mɑ̀ɑ́nɛ̀ mɛ̀ɛ̀ ɑ́ɑ́rìmɛ̀, kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ dɛɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Kɛ̀ dɛ̀ɛ nɑrikɛ Setidoo ti Yiɛ̀ nKuyie ndɔ̀ɔ̀mɛ̀ mɛsɑ̀ɑ̀ nyIsidɑyɛɛribɛ, kɛ bɛ̀ dɛɛtɛ́nɛ̀ Esibiti kɔbɛ. Kòò dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ti Yiɛ̀ nKuyie nyètìrì ńdɛu, kunku kùù di dɛɛtɛ́nɛ̀ okpɑ̀ɑ̀tì nɛ̀ Esibiti kɔbɛ bɛ nɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","M bɑntɛ́mu di mmɔ̀nnì ti Yiɛ̀ nKuyie pɛ̃ɛ̃tɛ́mɛ̀ yɛbɔkɛ̀, kù bɛnkɛmɛ̀ ku wɛ̃rímú Esibiti kɔbɛ fɛ̃́ũnko dìì mɔ̀nnì Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Kɛ̀ Setidoo Mɔyiisi cɔ̀kùu kuɔ Kuyie nfɛɔ̃̀fɛ̀ kɛ́tuɔ nkɛ́ kù kùɔ fɛtɛfɛ̀ kɛ́bénnɛ́. Anɔɔ nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ̀ bɛ̀ɛ ò wɛ̃nnɛ́nɛ̀, kɛ̀ bɛ̀ɛ di Kuyie nyììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Kɛ̀ dɛ̀ɛ̀ wentɛ́ kɛ̀ Mɔyiisii kɑri kɛ́mbekùnɛ̀ bɛnìtìbɛ̀ dikṹnweńnì nɛ̀ kuyuokoo, kɛ̀ bɛ̀ còḿmú o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Kòo cɔ̀kùu yɑ̀ dɛ̀ɛ̀ dɔ̀ɔ̀ri kóò bekɛ kɛ dɔ̀: A dɔɔri bɑ? Dɛ̀ yĩ́mɛ kɑ̀ɑ kɑ̀ri ɑmɑ́ɑ̀ kɛ̀ bɛnìtìbɛ̀ dɑ murí, dikṹnweńnì nɛ̀ kuyuokoo. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Kɛ̀ Mɔyiisi dɔ̀: Bɛ̀ kɔ̀tɛní m borɛ̀ kɛ dɔ́ kɛ́keè Kuyie mbo bɛ̀ nɑ̀kɛ́ tì nti. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Kɛ̀ bɛ̀ mɔ̀kɛ tìmɑtì bɛ̀ ɔ̃ɔ̃ kɔtɛní m borɛ̀ ndɛ, kɛ̀ n tì mbɛ̀ tũ̀ntɛ, kɛ́ bɛ̀ nɑ̀kɛ́ Kuyie nkuɔ́ nɛ̀ ku tié. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Kòo cɔ̀kù dɔ̀: A dɔɔri dɛ̀ í wenni. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","A bo ɔu, kɛ̀ bɛnìtìbɛ̀ múnkɛɛ ɔu kɛ́yĩɛ̃kɛ. Dɛ kó mutɔ̃mmú dɑ dɛunɛ̀mu, ɑ bɑ́ɑ́ nɑ kɛ́ mù pĩ nhɑmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Yie n yóó dɑ duɔ́ nyìì tié nkɛ̀ Kuyie ndɑ teennɛ̀. Fɔ̃́ɔ̃̀ yó ntɔu bɛnìtìbɛ̀ kpɛti tìì yóù kɛ kɔrìnɛ̀ Kuyie mborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Nɑ́kɛ́ bɛ Kuyie nkuɔ́ nɛ̀ ku tié, kɛ́ bɛ̀ bɛnkɛ kucɛ bɛ̀ dò nkɛ́ntũ nkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Tɑ̃ɑ̃tɛ́ bɛnìtìbɛ̀ mɔ́mmɔmbɛ, bɛ̀ɛ̀ dé Kuyie nkɛ nɑ́ɑ́ ntimɔ́mmɔnti, bɛ̀ɛ̀ í dɔ́ ticuuti kó mudiì, kɛ̀ bɛ̀ mbɑkɛ́ yɛtĩ̀rɛ̀. Yie mbɛnìtìbɛ̀ tɛkɔupíítɛ̀ (1000), otɔù tɛkɔ̀ùtɛ̀ (100), otɔù sipísìnùmmù, otɔù tɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Bɛɛ̀ yó mbekùnɛ̀ bɛnìtìbɛ̀. Kɛ̀ tìì dɛu bɛ̀ɛ tì ndɑ nɑ́kɛ́, kɛ̀ tìì kɛ̃ńnì bɛ̀ɛ tì bekɛ́ bɛmɑ́ɑ̀. Yɑɑtɛ ɑ tɔu kɛ̀ bɛ̀ɛ dì ndɑ totɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Kɑ̀ɑ dɔ̀ɔ̀ mɛmmɛ kɛ tũ̀ nKuyie ndɑ nɑ̀kɛ́ tì ɑ bɑ́ɑ́ ɔu. Bɛnìtìbɛ̀ níí bo nkũnti kɛ̀ diwɛ̀ì bɛ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Kɛ̀ Mɔyiisii yie nho cɔ̀kù ò nɑ̀kɛ́ tì, kɛ́ tì dɔ̀ɔ̀ timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Mɛm̀mɛ ò tɑ̃nkɛ́mɛ̀ Isidɑyɛɛribɛ miɛkɛ bɛnìtìbɛ̀ mɔ́mmɔmbɛ, kɛ̀ bɛ̀ mbɑkɛ́ bɛnìtìbɛ̀. Yiè ntɛkɔupíítɛ̀ (1000), otɔù tɛkɔ̀ùtɛ̀ (100), otɔù sipísìnùmmù, otɔù tɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Kɛ̀ bɛ mbekùnɛ̀ bɛnìtìbɛ̀ sɑ̃́ɑ̃̀ kɛ kɔrìnɛ̀ní Mɔyiisi borɛ̀ tìì dɛu, kɛ bekù tìì kɛ̃ńnì bɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Kòo cɔ̀kùu ò cɑu nkɛ́kò nho ciɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ Defidimmu, kɛ́tuɔkɛ Sinɑii tɑ̃rì kpɑ́ɑ̀, otɑ̃̀nkù tɑ̃ɑ̃́nwè kó diyiè diketirì do ndi nɛ̀ bɛ̀ yɛ̀mɛ̀ Esibiti, kɛ̀ bɛ̀ɛ bɑ́tɛ́ ditɑ̃rì tɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Kɛ̀ Mɔyiisii dekɛ ditɑ̃rì ĩ́nkɛ̀, kɛ bo yɑ̀ ti Yiɛ̀ nKuyie. Kɛ̀ kùu ò yu ditɑ̃rì ĩ́nkɛ̀ kɛ dɔ̀: Á nɑ́kɛ́ Sɑkɔbu kɔbɛ, Isidɑyɛɛribɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Di yɑ̀mu n dɔ̀ɔ̀ dɛ̀ Esibiti kɔbɛ, kɛ di tɔ fɛtúúfɛ̀ tɔu mɛ̀ɛ̀ botí fɛ bí, kɛ kɔ̀tɛnɛ̀ní diɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Kɛ̀ di yie n kpɛti, kɛ pĩ́ n kó mɛtɑummɛ̀, di bo ntú n kɔbɛ ibotí imɔu miɛkɛ. Míì te kɛtenkɛ̀ kɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Di botí bo ntú mí nKuyie n kuɔ́ nìùbɛ̀, kubotí n cɑ̃̀ńnɛ́ kù, kɛ̀ kù pĩ n tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Kɛ̀ Mɔyiisii cútɛ́ní kɛ́yú Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ́ bɛ̀ nɑ̀kɛ́ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Kɛ̀ bɛnìtìbɛ̀ɛ yie mbɛmɔu kɛ dɔ̀: Ti yóó dɔɔ̀mu ti Yiɛ̀ nKuyie mbɛ́i ntì. Kɛ̀ Mɔyiisii kpɛ́ntɛ́ kɛ́ tì nɑ̀kɛ́ ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: M bo kɔtɛní kɛ́mbo diwɛtirì miɛkɛ kɛ dɑ nɑ́ɑ́nnɛ̀, kɛ̀ bɛ̀ yo n tɑmmɛ̀, kɛ́nyíé nhɑ kpɛti sɑ̃́ɑ̃̀. Kɛ̀ Mɔyiisi yíɛ́ kɛ́ kù nɑ̀kɛ́ bɛnìtìbɛ̀ ò nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Nɑ́kɛ́ bɛnìtìbɛ̀ kɛ̀ bɛ̀ɛ dɔɔ̀ bɛmɑ́ɑ̀ mɛwénkùmɛ̀ kó ikuɔ́ yíe nnɑnkɛ kɛ́hɔ́ú bɛ yɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Kɛ̀ dí nni mbɑɑ diyiè tɑ̃ɑ̃́nnì yiè, n cutoomu Sinɑii tɑ̃rì ĩ́nkɛ̀, kɛ̀ bɛnìtìbɛ̀ bɛmɔu bo n yɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Á níɛ́tɛ́ kumɑ̀nku, kɛ́fii nditɑ̃́rì kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Òmɔù bɑ́ɑ́ dekɛ ditɑ̃rì yoo wèe dì kɑ̀ɑ́kɛ́, kɛ̀ wèè dì kɑ̀ɑ́kɛ́ bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kɛ̀ fɛɔ̃̀fɛ̀ nfɛ yoo onìtì, di bɑ́ɑ́ dɛ̀ kɑ̀ɑ́kɛ́, di dɛ̀ bùɔ́tí yɛtɑ̃́rɛ̀ yoo di dɛ̀ tɑ̃ɑ̃́ ipie. Di bɑ́ɑ́ yóu kɛ̀ dɛ̀ nfòù. Di bo keè dìì mɔ̀nnì ditɑ̃tɛheù, bɛ̀ɛ̀ dò nkɛ́dekɛní ditɑ̃rì dɛ mɔ̀nnì ndì bɛ̀ dèètìnímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Kɛ̀ Mɔyiisii cútɛ́ní kɛ́nɑ́kɛ́ bɛnìtìbɛ̀ kɛ̀ bɛ̀ɛ dɔɔ̀ bɛmɑ́ɑ̀ mɛwénkùmɛ̀ kó ikuɔ́, kɛ́hɔ́ú bɛ yɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Kòo bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Dí mbɑɑti yɛwe yɛ̀tɑ̃ɑ̃ti miɛkɛ, òmɔù bɑ́ɑ́ duɔ́nɛ̀ onitipòkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Diyiè tɑ̃ɑ̃́nnì yiè dikṹnweńnì sɛ̀ì, kɛ̀ fɛtɑɑfɛ̀ mpɛ́ú, kɛ míí nkɛ̀ kuyukú fĩ nditɑ̃rì ĩ́nkɛ̀ kɛ̀ ditɑ̃tɛheù kuɔ̀ mmɛdiɛ̀ nkɛ̀ Isidɑyɛɛribɛ bɛmɔu kɔ̃̀ntì ɑu sicɛ̃́ĩ. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Kɛ̀ Mɔyiisii bɛ̀ dènnɛ kɛ̀ bɛ̀ bo kɔtɛ kɛ́yɑ̀ Kuyie nkɛ̀ bɛ̀ɛ tuɔkoo kɛ́ncómmú ditɑ̃rì pɛ̃ri. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Kɛ̀ Sinɑii tɑ̃rì fĩ nkuyukú, ti Yiɛ̀ nKuyie nkuù do cùtɛ́ní muhɑ̃ɑ̃́ mmiɛkɛ, kɛ̀ dɛ kó kuyukú ńyiɛ̀ kɛ dò nfɛpɛ̃́ɛ̃̀pṹnnɛ́tofɛ kɔku, kɛ̀ ditɑ̃rì dimɔu sɑ̃̀nti. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kɛ̀ ditɑ̃tɛheù tɑmmɛ̀ dɔ̀kɛ kpénkú, kɛ̀ Mɔyiisi nnɑ̀ɑ́nnɛ̀ Kuyie nkɛ̀ kù ò tɛ̃́nnìnko kɛ pɛ́ú mɛtɑmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Kɛ̀ ti Yiɛ̀ nKuyie ncútɛ́ní Sinɑii tɑ̃rì kɛ́yú Mɔyiisi kòo dekoo. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Kɛ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ kɛ dɔ̀: Cútɛ́ kɛ́nɑ́kɛ́ bɛnìtìbɛ̀ kɛ̀ bɛ̀ bɑ́ɑ́ cokɛ́ní kɛ bo n yɑ̀, kusṹkù yɑ̀ɑ̀ bo kú. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Bɑ́ ikuɔ́ nìùbɛ̀ bɛ̀ɛ̀ dò nkɛ́ n tɔ́ɔ́nnɛ̀ bɛ̀ɛ dɔɔ̀ bɛmɑ́ɑ̀ mɛwénkùmɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Kɛ̀ Mɔyiisi dɔ̀: Bɛnìtìbɛ̀ í deètìní. A sòò ti nɑ̀kɛ́mu kɛ tú ti níɛ́tɛ́ kumɑ̀nku kɛ̀ bɛnìtìbɛ̀ ḿbo ditɑ̃rì pɛ̃ri. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Cútɛ́ kɛ́nɑ́kɛ́ ikuɔ́ nìùbɛ̀ nɛ̀ bɛnìtìbɛ̀ kɛ̀ bɛ̀ bɑ́ɑ́ dekɛní bɛ̀ yɑ̀ɑ̀ bo kú, nɛ̀ Anɔɔ kɛ̀ dí dekɛní. ");
INSERT INTO tbzsim_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Kɛ̀ Mɔyiisii cútɛ́ní kɛ́nɑ́kɛ́ bɛnìtìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Mɛm̀mɛ kɛ̀ Kuyie nnɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Míì tu di Yiɛ̀ nKuyie, kɛ̀ míì di dènnɛní Esibiti di do tú kɛ̀ tidɑɑtì. Onìtì fɔ̃́: ");
INSERT INTO tbzsim_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","A bɑ́ ntũ ndɛtɛrɛ̀ mɑrɛ̀ kɛ̀ dɛ̀ í tú mí nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","A bɑ́ɑ́ dɔɔ̀ tɛtenkɑɑnìtɛ̀ kɛ́donnɛnɛ̀ dɛ̀ɛ̀ bo kɛĩ́nkɛ̀, yoo kɛtenkɛ̀ kpɛrɛ, yoo mɛniɛ mmiɛkɛ kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","A bɑ́ɑ́ nínkú dɛ ììkɛ̀ kɛ́ dɛ̀ bɑ̀ńtɛ̀, míì mɑ́ɑ̀ tu ɑ Yiɛ̀ nKuyie! Kɛ yóó kpetínnɛ́ wèè yetɛ n kpɛti nɛ̀ o bí nɛ̀ o yɑɑ̀bí nɛ̀ i kó ibí. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","N yóó dɔɔ̀mu mɛsɑ̀ɑ̀ nwèè yie n kpɛti nɛ̀ o bí nɛ̀ o yɑɑ̀bío, kucɛ tɛkɔupíítɛ̀ (1000). ");
INSERT INTO tbzsim_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","A bɑ́ɑ́ yú mí nhɑ Yiɛ̀ nKuyie nyètìrì sɔ̃́ntíkɛ, kɛ yɛ̃́ n yí yóó yóu wèè bo yú n yètìrì dɛtetìrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","A nyɛ̃́ tɛom̀pùtɛ̀ yiè kpɛ́í, kɛ̀ dì ncɑ̃́ɑ̃́ nkɛ́ntú n kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","A níí pĩ́ nhɑ tɔ̃mmú mumɔu yɛwe yɛ̀kuɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Diyiénnì yiè tu mí nhɑ Yiɛ̀ nKuyie n kpɛri ndi. A bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù dɛ yiè. Bɑ́ ɑ birɛ, bɑ́ ɑ kóo tɔ̃ntì onitidɔ̀ù yoo onitipòkù, bɑ́ ɑ ɔ̃̀fɛ̀, bɑ́ opɔ̀ɔ̀ wèè bo ɑ cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Kɛ yɛ̃́ n dɔ̀ɔ̀mɛ̀ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo yɛwe yɛ̀kuɔ̀ ndì kɛ om̀pɛ̀ diyiénnì, dɛɛ̀ kpɛ́í nte kɛ̀ n dì pɑ̃ mɛsɑ̀ɑ̀, kɛ tú dì ncɑ̃́ɑ̃́ nkɛ tú n kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","A ndé ɑ cicɛ nɛ̀ ɑ yɔ̃, kɛ̀ dɛ̀ɛ yie nkɑ̀ɑ fòmmuu okɛ̀, mí nhɑ Yiɛ̀ nKuyie n yóó dɑ duɔ́ nkɛ̀ɛ̀ tenkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","A bɑ́ɑ́ kuɔ onìtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","A bɑ́ɑ́ duɔ́nɛ̀ wèè í tú ɑ pokù yoo wèè í tú ɑ dɔù. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","A bɑ́ɑ́ yúúkú. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","A bɑ́ɑ́ soutɛ́ kɛ́cɑɑ̀rɛ̀ ɑ kou tɔù yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","A bɑ́ɑ́ yɑɑ nhotɔù kpɛrɛ mɑrɛ̀, o cĩ́ɛ̃̀tɛ̀, yoo o pokù, yoo o kóo tɔ̃ntì, yoo o nɑ̀ɑ̀fɛ̀, yoo o sɑ̃mmɑrímú. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Kɛ̀ bɛnìtìbɛ̀ɛ keè fɛtɑɑfɛ̀ pɛ̀úmɛ̀ kɛ̀ ditɑ̃tɛheù kuɔ̀, kɛ́yɑ̀ fɛtɑɑfɛ̀ mìímmɛ̀ kɛ̀ ditɑ̃rì fĩ nkuyukú, kɛ̀ kufɔ̃wɑɑ́ mbɛ̀ pĩ nkɛ̀ bɛ̀ ncómmú mɛkɛntímɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Nti nɑ́ɑ́nnɛ̀ ɑ mɔ́mmuɔ nti yóó yiemmu, Kuyie mbɑ́ nti nɑ́ɑ́nnɛ̀ ti yɑ̀ɑ̀ bo kú. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Kɛ̀ Mɔyiisi dɔ̀: Di bɑ́ nyĩɛ̃̀kù, Kuyie ndi tɔ̀ɔ́nnɛ̀ kɛ bo di bɛnkɛmu kɛ̀ dì bɑntɛ́ kù kpeńnìmɛ̀ kɛ́ kù depɛ, kɛ́ bɑ́ ndɔɔri mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Kɛ̀ bɛnìtìbɛ̀ nciɛ́, kɛ̀ Mɔyiisii tɔ́ɔ́nnɛ̀ diwɛtirì Kuyie mborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀ n tú: Di yɑ̀mu n di bɛ́innɛ̀nnímɛ̀ kɛĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Dí n tũ mmíì mɑ́ɑ̀, di bɑ́ɑ́ dɔɔ̀ timɑ́tì pɛ́ítì nɛ̀ mɛsɔɔ nkó sitenkɑɑnìi. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Di níí m mɑɑ́ diwũɔ̃tɔ̀nnì n tɑ̃ɑ̃tɛ́ dìì bòrì, kɛ́ nni nfeu ipe nɛ̀ inɑ̀ɑ̀kɛ, kɛ́nkɔù itɛì kɛ tuɔ̀, kɛ̀ n kɔ̀rìní kɛ di pɑ̃ɑ̃ mmɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Kɛ̀ di yóó mɑɑ́ diwũɔ̃tɔ̀nnì nɛ̀ yɛtɑ̃́rɛ̀ di bɑ́ɑ́ yɛ̀ cìɛ́kɛ́, kɛ̀ di yɛ̀ cìɛ́kɛ́ di yɛ̀ sĩnkùnnɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Di níí bɑ́ɑ́ mɑɑ́ diwũɔ̃tɔ̀nnì kɛ́ɑ̃nnɛ́ yɛdɛtìsɑ̀kɛ̀, bɛ̀ yɑ̀ɑ̀ bo yɑ̀ wèè dèètì o fɛ̀i. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: N tɛ ikuɔ́ ɑ yóó duɔ́ nyì Isidɑyɛɛribɛ: ");
INSERT INTO tbzsim_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Kɛ̀ wèè dontɛ́nɛ̀ Ebedeebɛ kudɑɑkù, kù mpĩ́ mmutɔ̃mmú yɛbie nyɛ̀kuɔ̀, kɛ́yɛ̀ diyiénnì bɑ́ kù bɑ́ɑ́ yietí mùmɑmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Kɛ̀ wèè yóó dontɛ́ kudɑɑkù kɛ̀ kù kɔ̀kɛ́, kùu yɛ̀ kutetìrì, kɛ̀ kù mɛ̀ ndo po kùu yɛ̀nnɛ̀ ku pokù. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Kɛ̀ ku yiɛ̀ nweè mɛ nkù duɔ́ nhonitipòkù kòò pɛitɛ́ ibí, ku yiɛ̀ nweè yó nyì te kɛ̀ kùu yɛ̀ kutetìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Kɛ̀ kudɑɑkù mɛ nyĩ: N dɔ́mu n yiɛ̀ nkɛ dɔ́ m pokù nɛ̀ m bí, n yí dɔ́ kɛ́yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","Ku yiɛ̀ nkù còńnɛ́ dibòrìnùù kɛ́yú Kuyie nyètìrì kɛ́keutɛ́ ku toò, kɛ̀ kù ntú o kóo tɔ̃ntì sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Kòò mɔù mɛ nfìtɛ́ o kóo sɑpɑ̀ɑ̀ nkòò tu kudɑɑkù, ò bɑ́ɑ́ nɑ kɛ́yɛ̀ tidɑɑtì yìɛ̀ mɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Kòò mɛ nkù dontɛ́ kɛ yóó puokɛmu, kɛ tɛ̃́nkɛ í kù dɔ́, wèe wɛ̃tɛ kɛ́ kù fìtɛ́nɛ̀ ku cicɛ. Ò bɑ́ɑ́ kù fìtɛ́nɛ̀ kubotí tɛkù. Kòò dɔ̀ɔ̀ mɛmmɛ wè kù yetɛ́nɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Kòò mɛ nkù dontɛ́ kɛ bo duɔ́ nho birɛ ndɛ, wè nkù dɔ̀ɔ̀ri ò dɔ̀ɔ̀rimɛ̀ o kó bɛsɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Kɛ̀ dɛ̀ boní kɛ̀ dɛ kó dɛbirɛ wɑɑ́ nhonitipòkù tɔù, dɛ̀ bɑ́ɑ́ yɑɑtɛ dɛ̀ do pɑ̃ɑ̃ mmùù diì okótì nɛ̀ tiyɑ̀ɑ̀tì nɛ̀ mudɔmmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Kòò í ò dɔ̀ɔ̀ri dɛnɛnnɛ̀ dɛ̀tɑ̃ɑ̃ti dɛndɛ, ò bo nɑ kɛ́yɛ̀ bɑ́ ò bɑ́ɑ́ yietí idíítí. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Kɛ̀ wèè potɛ́ onìtì kɛ kùɔ bɛ̀ɛ̀ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Kòò mɛ nyí ó kùɔ kɛ dɔ́, kòo nɔ̀ùtɛ̀ tɛɛ̀ ò yetɛ́nɛ̀, wèe sɔri n yóó di bɛnkɛ dìì ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Kòò mɛ nhò kùɔ kɛ dɔ́mu, yoo wè ò kùɔnɛ̀ mɛciì, bɑ́ kòò cokɛ́ kɛ sɔ̀ri n wũɔ̃tɔ̀nnì borɛ̀, dí ò dɛ̀itɛ kɛ́kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wèè potɛ́ o cicɛ yoo o yɔ̃, bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wèè yùúkú onìtì koò fìtɛ́ yoo ò bo o cĩ́ɛ̃̀tɛ̀, bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wèè sɑ̃̀ɑ̃́ nho cicɛ yoo o yɔ̃ bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Kɛ̀ bɛnìtìbɛ̀ kpɑ̀ nkòò mɔù potɛ́ otɔù kòò do kɛ í ku. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","Kòò nɑ kɛ ìtɛ́ kɛ centìnɛ̀ kupɑ̀ɑ̀ti, bɛ̀ bɑ́ɑ́ kuɔ wèè ò kɔ̀ùtɛ, wèè ò kɔ̀ùtɛ wèe ò yietí ò ò kɔ̀ùtɛmɛ̀, kɛ́ nhò tɑɑ̀ nkòo miɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Kòò mɔù puotí o kó kudɑɑkù, kunitidɑɑkù yoo kunitipòrìkù, kɛ̀ kù ku bɛ̀ɛ pɛitɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Kɛ̀ kù mɛ mmɔ̀kɛ diyiè yoo yɛwe yɛ̀dɛ́ɛ̀ kɛ ku bɛ̀ bɑ́ɑ́ pɛitɛ kɛ̀ yɛ̃́ weè kù dontɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Kɛ̀ bɛnìtìbɛ̀ kpɑ̀ nkɛ bòòtɛ onitipòkù wèè pùó nkòo pɔutì donní kòò í kɔ̀ùtɛ, o dɔùu bɛ̀ yu bɛbeémbɛ̀ borɛ̀, kɛ̀ bɛ̀ɛ ò yietí ò kèétɛ́ ìì díítí. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Kɛ̀ mɛyɛi mmɑmɛ̀ mɛ ntùɔ̀kɛní onitipòkù kòò ku, bɛ̀ɛ kuɔ wèè ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Kɛ̀ wèè kpɛ̀ɛ́tɛ́ otɔù nɔ̀nfɛ̀, bɛ̀ɛ kpɛ́ɛ́tɛ́ o kɔfɛ, kɛ̀ wèè feutɛ́ otɔù nìnnì, bɛ̀ɛ feutɛ́ o kpɛri, kɛ̀ wèè kèétɛ́ otɔù nɔ̀ùtɛ̀, bɛ̀ɛ kéétɛ́ o kpɛtɛ, kɛ̀ wèè kèétɛ́ otɔù nɑɑ̀cɛ̀tɛ̀ bɛ̀ɛ kéétɛ́ o kpɛtɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Kɛ̀ wèè cɔ́u nhotɔù, bɛ̀ɛ ò cɔ́u, kɛ̀ wèè kɔ̀ùtɛ otɔù, bɛ̀ɛ ò kɔ̀ùtɛ, kɛ̀ wèè ɑ̃nnɛ́ otɔù kuyɛ̀nkù, bɛ̀ɛ kù nhò ɑ̃nnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Kòo nìtì potɛ́ o dɑɑkù, kunitidɑɑkù yoo kunitipòrìkù, kɛ kpɛ̀ɛ́tɛ́ ku nɔ̀nfɛ̀, wèe kù fĩ́ĩ nkù tɛ̃́nkɛ bɑ́ ntú kudɑɑkù ò kpɛ̀ɛ́tɛ́ mɛ̀ɛ̀ kpɛ́í nku nɔ̀nfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Kòò feutɛ́ ku nìnnì wèe kù fĩ́ĩ nhò feutɛ́ mɛ̀ɛ̀ kpɛ́í nku nìnnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Kɛ̀ fɛnɑ̀ɑ̀fɛ̀ kùɔ onitidɔ̀ù yoo onitipòkù, dɛ̀ í tú fɛ yiɛ̀ nkó mɛyetímɛ̀, bɛ̀ɛ fɛ̀ bùɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ, bɛ̀ mɛ mbɑ́ɑ́ fɛ̀ cɑ̀ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kɛ̀ dɛ kó fɛnɑ̀ɑ̀fɛ̀ mɛ nkũ̀mmùmu, kɛ̀ bɛ̀ nɑ̀kɛ́ fɛ yiɛ̀ nkòò í fɛ̀ pĩ nkɛ̀ fɛ̀ kùɔ onìtì, bɛ̀ɛ fɛ̀ bùɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ, kɛ́kuɔnɛ̀ fɛ yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Kɛ̀ bɛ̀ yɛ̃ nfɛ yiɛ̀ nyietí kɛ́cootɛ́, wèe yietí bɛ̀ ò bekɛ dɛ̀ɛ̀ kó dimɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kɛ̀ fɛ̀ kùɔ dɛnitidɑbirɛ yoo dɛnitipobirɛ, bɛ̀ɛ dɔɔ̀ mɛɛ̀ mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kɛ̀ fɛ̀ mɛ nkùɔ kudɑɑkù kunitidɑɑkù yoo kunitipòrìkù, bɛ̀ɛ yietí ku yiɛ̀ mmɛdítíbii nsipísìtɑ̃ɑ̃ti, kɛ́ fɛ̀ bùɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Kòò mɔù kpetɛ́ tɛbintɛ yoo wè tɛ̀ keú, kɛ í pòo nkɛ̀ fɛnɑ̀ɑ̀fɛ̀ yoo sɑ̃mmɑrímú do dɛ miɛkɛ kɛ ku, ");
INSERT INTO tbzsim_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","wèe yietí dɛ yiɛ̀ nkɛ́ dɛ̀ tùótɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kòò mɔù nɑ̀ɑ̀fɛ̀ kɔ̀ùtɛ otɔù kɔfɛ, kɛ̀ fɛ̀ ku bɛ̀ɛ fɛ̀ fìtɛ́ kɛ́totɛ́ idíítí, kɛ́totɛ́ fɛ̀ɛ̀ ku. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kɛ̀ dɛ kó fɛnɑ̀ɑ̀fɛ̀ mɛ ndo kũmmù itɛì nyi, kɛ̀ bɛ̀ nɑ̀kɛ́ fɛ yiɛ̀ nkòò í fɛ̀ pĩ nwèe yietí fɛ̀ kùɔ wèe kɔfɛ fɛnɑ̀ɑ̀fɛ̀, kɛ́túótɛ́ fɛ̀ɛ̀ ku. ");
INSERT INTO tbzsim_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Kòò mɔù yùúkú otɔù nɑ̀ɑ̀fɛ̀ kɛ kùɔ yoo ò fìtɛ́, wèe yietí fɛnɑ̀ɑ̀fɛ̀ yiɛ̀ nyinɑ̀ɑ̀kɛ ìnùmmù. Kɛ̀ fɛpìèfɛ̀ mɛ nni nfɛ wèe yietí ipe ìnɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Kòo yúókù yùúkú kɛyènkɛ̀, kɛ̀ bɛ̀ ò sɔ̃̀ńkɛ́ koò kùɔ, dɛ̀ í tú munitikɔ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Kɛ̀ diyiè mɛ nyɛ̀nní kɛ̀ bɛ̀ ò kùɔ, munitikɔ̀ù mmu. Kòo yúókù mɔù mɛ nyí mɔkɛ dɛ̀mɑrɛ̀ kɛ bo yietí ò yùúkú dɛ̀ bɛ̀ɛ ò fìtɛ́ kɛ́yietí. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Kòo yùúkú fɛnɑ̀ɑ̀fɛ̀ nfɛ yoo sɑ̃mmɑrímú yoo fɛpìèfɛ̀, kɛ̀ dɛ̀ kpɑɑ́ o cĩ́ɛ̃̀tɛ̀ wèe dɛ̀ tɛ̃̀ńnɛ́ kɛ́nɔ́ɔ́ ndɛtɛrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Kòo mɔù yóu kòo wũɔ̃ cɑ̀ɑ́kɛ́ otɔù diitì yoo o tebɛ, wèè te fɛɔ̃̀fɛ̀ wèe dɛitɛ o kó kupɑku tidiitì sɑ̀ɑ̀tì yoo o tebɛ sɑ̀ɑ̀yɛ̀ kɛ́yietí o ɔ̃̀fɛ̀ di wèè diitì. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Kòò mɔù cɔ́u ndikpɑ́ɑ̀, kɛ̀ dɛ̀ cɔ̀útɛ́ òmɔù diitì, tì còú dɛ̀ yoo tì kpɑɑ́ cómmú dɛ̀, wèe yietí tidiitì yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Kòò mɔù sɔ̀nnɛ o diitì yoo o kpɛrɛ otɔù borɛ̀, kòò mɔù dɛ̀ yùúkú kɛ̀ bɛ̀ ò yɑ̀, wèe yietí kucɛ mɛ̀dɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Kɛ̀ bɛ̀ í yɑ̀ wèè yùúkú, dɛ̀ do duɔ́ wèè cĩ́ɛ̃̀tɛ̀ɛ yú mí nKuyie nyètìrì kɛ́bɛ́i nkɛ dɔ̀: N yí tùótɛ́ n kou kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Kɛ̀ bɛ̀mɑbɛ̀ nɛ̀nni fɛnɑ̀ɑ̀fɛ̀ kpɛ́í nyoo sɑ̃mmɑrímú, yoo fɛpìèfɛ̀, yoo kuyɑ̀ɑ̀kù, yoo dɛ̀mɑrɛ̀ kpɛ́í, bɛ̀ɛ kɔtɛ m borɛ̀, kɛ̀ n yĩ wèè í nɑɑti, wèe yietí kucɛ mɛ̀dɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Kòo mɔù tɑnnɛ́nɛ̀ otɔù fɛnɑ̀ɑ̀fɛ̀, yoo sɑ̃mmɑrímú, yoo fɛpìèfɛ̀, yoo fɛɔ̃̀fɛ̀ tɛfɛ̀ mɑfɛ̀, kɛ̀ fɛ̀ ku yoo fɛ̀ kèétɛ́, yoo bɛ̀ fɛ̀ yùúkú, bɑ́ bɛ̀ í fɛ̀ yɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Fɛɔ̃̀fɛ̀ tɑɑ̀ wèè borɛ̀ɛ yú n yètìrì kɛ dɔ̀, ò í fɛ̀ tùótɛ́. Kòò ĩ mɛmmɛ wèè te fɛɔ̃̀fɛ̀ wèe yie nhò bɛ́i ntì bɑ́ ò bɑ́ɑ́ yietí. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Kòò mɛ nyóu kɛ̀ bɛ̀ fɛ̀ yùúkú o cĩ́ɛ̃̀tɛ̀, wèe yietí fɛɔ̃̀fɛ̀ yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Kɛ̀ musĩ̀mmù muù mɛ nfɛ̀ pĩ nwèe tɔní mù cɑ̀ɑ́kɛ́ kɛ sùɔ́ ndɛ̀, kɛ́bɛnkɛ fɛ yiɛ̀ nhò bɑ́ɑ́ yietí dɛ̀mɑrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Kòò mɔù yɑ̃ũtɛ́ otɔù fɛɔ̃̀fɛ̀, kɛ̀ fɛ̀ kèétɛ́, yoo fɛ̀ ku, bɑ́ fɛ yiɛ̀ nyí dɛ̀ bo, wèè fɛ̀ yɑ̃ũtɛ́ wèe yietí fɛ yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Kɛ̀ fɛɔ̃̀fɛ̀ yiɛ̀ ndɛ̀ bo, ò bɑ́ɑ́ yietí mùmɑmù, kòò mɛ nfɛ̀ yɑ̃ũtɛ́ kɛ yietímu, dɛ kó tiyeti ńsɑ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Kòò mɔù ciitɛ́ osɑpɑ̀ɑ̀ nwèè í yɛ̃́ onitidɔ̀ù, ò mɛ nyí mɔkɛ didɑcɛ̃nnì, koò duɔ́nɛ̀, wèe yietí tipocòntì kóò tùótɛ́ kɛ́puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Kòo sɑpɑ̀ɑ̀ ncicɛ mɛ nhò yetɛnɛ̀ o kóo sɑpɑ̀ɑ̀ nwèe yietí idíítí kɛ̀ ì mmɑ̀nnɛ̀ osɑpɑ̀ɑ̀ nkó tipocòntì kpɛyi bɑkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Dí kuɔ bɛnitipòbɛ̀ bɛ̀ɛ̀ tu bɛnitinɔ̀mbɛ̀ di cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Kòò mɔù duɔ́nɛ̀ fɛɔ̃̀fɛ̀ bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Kòò mɔù fèútɛ́ fɛɔ̃̀fɛ̀ dibɔɔ̀, kɛ yóu mí nKuyie, mbɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Di bɑ́ nfɛ̃́ũnko bɛpɔ̀ɔ̀bɛ̀ yoo dí mbɛ̀ cií. Kɛ yɛ̃́ di do túmɛ̀ bɛpɔ̀ɔ̀bɛ̀ mbɛ Esibiti tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Di bɑ́ nfɛ̃́ũnko bɛkúpobɛ̀ nɛ̀ iciribí. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Kɛ̀ di bɛ̀ fɛ̃́ũnko, kɛ̀ bɛ̀ sɑutɛ kɛ n yu n yóó keèmu. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kɛ̀ m miɛkɛɛ di pɛikɛ, kɛ̀ n duɔ́ nkɛ̀ di dootitɔbɛ̀ di kuɔ, kɛ̀ di pobɛ̀ɛ nɑɑ́ mbɛkúpobɛ̀, kɛ̀ di bíi nɑɑ́ nyiciribí. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Kɛ̀ wèè pèntɛ ocĩ̀rì idíítí o kó kubotí miɛkɛ o bɑ́ ndɔ́ wèe ò yietí kɛ́nɔ́ɔ́ mbɛtɔbɛ̀ ɔ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Kɛ̀ wèè kou yóó ò yɑ̃ũtɛ́ dɛ̀mɑrɛ̀ kòò tùótɛ́ o yɑ̀ɑ̀kù wèe kù nhò tɛ̃̀ńnɛ́ kɛ̀ diyiè mu nyí tɑ. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Kɛ yɛ̃́ ò ku mmɔkɛmɛ̀ kumɑ́ɑ̀ kɛ dɑɑti, kɛ̀ kù í bo ò bo duɔ́nɛ̀ bɑ, ò yóó sɑutɛmu kɛ̀ n keè, kɛ yɛ̃́ m mɔkɛmɛ̀ mɛsémmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Di bɑ́ɑ́ sɑ̃́ɑ̃́ mmí nKuyie, di mɛ mbɑ́ɑ́ sɑ̃́ɑ̃́ ndi kóo kpɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Di níí n duɔ́ ndi diitì ketitì nɛ̀ di tebɛ ketiyɛ̀ nɛ̀ bɛ̀ɛ̀ tú Mpo. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Kɛ̀ wèè nɑ̀ɑ̀fɛ̀ yoo o pìèfɛ̀ pɛitɛ́ fɛ birɛ ḿmɔkɛ yɛwe yɛ̀yiekɛ̀, diniínnì yiè kòò dɛ̀ nni nféútɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Di tú n kó bɛnìtìbɛ̀ mbɛ, ńdònnɛ̀ pɑ́íí! Dì bɑ́ ncɑ́ɑ́ mmusĩ̀mmù pĩ nfɛ̀ɛ̀ ɔ̃̀fɛ̀, di níí fɛ̀ duɔ́ n simɔɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Òmɔù bɑ́ɑ́ keè siyɑ́ɑ̀bìsí kɛ́ ntì sɔkɛ́nɛ̀. Òmɔù bɑ́ɑ́ kónnɛ́ oyɛiwe. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Òmɔù bɑ́ɑ́ tũnnɛ kusṹkù kɛ́dɔɔ̀ mɛyɛi. Òmɔù bɑ́ɑ́ yie nkusṹkù kpɛti kɛ́dɔɔ̀ dɛ̀ɛ̀ í wenni. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Òmɔù bɑ́ɑ́ kónnɛ́ òmɔù kòò í nɑɑti, bɑ́ kòò tu ocĩ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Kɛ̀ wèè yɑ̀ o dùɔ̀ntɔù nɑ̀ɑ̀fɛ̀, yoo o sɑ̃mmɑrímú kɛ̀ dɛ̀ feti, wèe dɛ̀ nhò tɔní. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Kɛ̀ wèè dùɔ̀ntɔù sɑ̃mmɑrímú ɔ̀unɛ̀ ditɔu kɛ do, wèe ò teennɛ̀ kɛ̀ bɛ̀ɛ dɛ̀ boutɛ́ tinɛntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Kòo cĩ̀rì nɑɑti di bɑ́ɑ́ yóu di bo ò kòńnɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Di bɑ́ nyíé nsiyɑ́ɑ̀bìsí, di bɑ́ɑ́ kuɔ wèè í dɔ̀ɔ̀ mɛyɛi. N yí kómmú wèè cɑ̀ɑ̀rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Di bɑ́ ncɔú ticuuti, tì yɛ̃̀ĩkùnkomu bɛ̀ɛ̀ nuɔ nwùó, kɛ sĩnkùnko wèè nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Di bɑ́ nfɛ̃́ũnko bɛpɔ̀ɔ̀bɛ̀, di yɛ̃́mu kupɔ̀ɔ̀kù dòmmɛ̀, Di do tú bɛpɔ̀ɔ̀bɛ̀ mbɛ Esibiti tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Di yó nkuuti yɛbie nyɛ̀kuɔ̀ yɛ̀kuɔ̀ ndi kɛ dɛì di diitì. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Dibenni diyiénnì kɛ́yóu kɛtenkɛ̀ kɛ̀ kɛ̀ɛ om̀pɛ̀, kɛ̀ dihɛì kó bɛcĩ̀rìbɛ̀ɛ pɛ́tɛ́ kɛ́di, kɛ̀ tikpɑsĩ̀ntìi di dɛsɔnnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Di níí yóó pĩ́ ndi tɔ̃mmú yɛwe yɛ̀kuɔ̀ ndi, kɛ́om̀pɛ̀ ndiyiénnì, kɛ̀ di nɑ̀ɑ̀kɛ nɛ̀ di sɑ̃mmɑrímúbɛ̀ kɛ̀ dɛ̀ɛ om̀pɛ̀. Kòo pɔ̀ɔ̀ nɛ̀ kudɑɑkù nɛ̀ ku birɛ kɛ̀ dɛ̀ɛ wei. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Di ḿpĩ́ n di nɑ̀kɛ́ tì timɔu, di bɑ́ nyu yɛbɔkɛ̀ yètɛ̀, di bɑ́ nnɑ́ɑ́ nyɛ kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Bɑ́ dìì benni dí ɑ̃nnɛ́ yɛbɑɑ nyɛ̀tɑ̃ɑ̃ti kɛ́dɛ́úkùnnɛ n yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Dibɑnni ketirì yó ntú pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie bɛ kpɛri ndi. Kɛ̀ di ndì bɑɑ̀ nkɛ dɔ̀ yɛwe yɛ̀yiekɛ̀ kɛ cɑ́ɑ́ mpɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti, kɛ́ndònnɛ̀ n di nɑ̀kɛ́mɛ̀ di yɛtì dìì mɔ̀nnì Esibiti. Di n dì bɑɑ̀ ndididɛ̀ì kóo tɑ̃̀nkù. Kɛ̀ di níí kɔrìní m borɛ̀ di bɑ́ɑ́ kɔtɛní di nɔu sitetìsì. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Di ḿbɑɑ̀ ntidipɑ̀ntì kó dibɑnni, kɛ bɑɑ̀ ndididɛ̀ì bɑnni dibenni kṹṹ mmiɛkɛ, di dɛ̀itɛ dìì mɔ̀nnì tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Kucɛ mɛ̀tɑ̃ɑ̃ti dibenni miɛkɛ bɛnìtìbɛ̀ níí kɔtɛní mí ndi Yiɛ̀ nKuyie m borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Òmɔù bɑ́ n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́wɛ̃nnɛ́nɛ̀ fɛ yĩ̀ĩ̀ mpɛ̃́ɛ̃̀ wèè kɔɔrɛnɛ̀ mutie mùù muuti, fɛ kùɔ̀ mmɛ mbɑ́ nyĩ́ĩ́kú kɛyènkɛ̀ kɛ̀ dɛ̀ɛ wentɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Di ntɔuní tidipɑ̀ntì mí ndi Yiɛ̀ nKuyie ncĩ́ɛ̃̀tɛ̀ nɛ̀ yɛtebɛ ketiyɛ̀. Di níí bɑ́ɑ́ bénnɛ́nɛ̀ dibɔbii di yɔ̃ miɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","N duɔ́nkomu n tɔ̃nnì kɛ̀ dì bo ndi ni kɛ di kɑ̃nkɛ́ kɛ̀ dí tuɔkɛnɛ̀ kɛtenkɛ̀ n tũ̀ntɛ kɛ̀ di kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Di ńdɑkɛ kɛ bɑ́ɑ́ yetɛ n tɔ̃nnì kpɛti, kɛ̀ di tì yetɛ dì í yóó di cĩ́ɛ̃́ ndi yetímɛ̀ kɛ yɛ̃́ míì dì tɔ̃nkomɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Kɛ̀ di yíé ndi kpɛti kɛ tũ n dì nɑ̀ɑ́ ntì, m bo nníí mbɛ̀ɛ̀ di níí, kɛ̀ di dùɔ̀ntɔbɛ̀ ntú n dùɔ̀ntɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","N tɔ̃nnì yóó di niitɛ́mu, Amɔriibɛ nɛ̀ Itiibɛ nɛ̀ Pedisiibɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Efiibɛ nɛ̀ Sebusiibɛ borɛ̀ kɛ̀ m bɛ̀ kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Di bɑ́ɑ́ nínkú bɛ bɔkɛ̀ ììkɛ̀, di bɑ́ɑ́ yɛ̀ fìé iwũɔ̃, di mɛ mbɑ́ɑ́ teetɛ́ bɛ borimɛ. Dí bɛ̀ kùɔ kɛ́puɔ mbɛ bɔkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Dí ntũ mmí ndi Yiɛ̀ nKuyie mmɑ́ɑ̀, kɛ̀ n di dɔɔ̀ mɛsɑ̀ɑ̀ nkɛ́ ndi duɔ̀ ntidiitì nɛ̀ mɛniɛ, kɛ́ ndi péìrì mumɔmmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Di kó kɛtenkɛ̀ miɛkɛ onitipòkù pɔutì bɑ́ɑ́ donní, tɛhɑ̃ũntɛ bɑ́ mbo, kɛ̀ n yíɛ́ di fòmmu kɛ̀ dí nfòù kɛ́mɔntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","M bo nni di ììkɛ̀ kɛ ɑ̃ɑ̃̀ bɛnìtìbɛ̀ kufɔ̃wɑɑ́, kɛ̀ di tùɔ̀kɛ kùù botí ciɛ kùu cokɛ́, di dootitɔbɛ̀ bo ndi cokù. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","M bo nií nyɛcɑ̃nkɛ̀ndèèsùɔ̀ di ììkɛ̀, kɛ̀ yɛ̀ mbɛtì Efiibɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Itiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","N yí yóó bɛ bɛ̀ti dibenni dìmɑ́ɑ̀ miɛkɛ dihɛì yɑ̀ɑ̀ bo nɑɑ́ ndikpɑ́ɑ̀, kɛ̀ dɛpĩ́mpĩ́nnɛ̀ɛ sṹṹ. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","N yó mbɛ̀ bɛ̀tì sɑ́m̀pɔ́ sɑ́m̀pɔ́ nwe, kɛ̀ di yɑ̀ɑ sṹṹnnɛ̀ kɛ́tiekɛ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Di tenkɛ̀ yóó ketɛ́ dɑ̀mɛ́ɛ̀rì wũɔ̃wè nwe kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Fidisitɛ̃ɛ̃bɛ kóo dɑ̀mɛ́ɛ̀rì, kɛ́túótɛ́ dikpɑ́ɑ̀ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kukó ndiɛkù Efɑdɑtɑɑ bɛ̀ɛ̀ dɛ̀ bo, n yóó duɔ́ nkɛ̀ di bɛ̀ bɛ̀timu. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Di bɑ́ mbɛ̀ mɔ̀kɛnɛ̀ mɛtɑummɛ̀ mɑmɛ̀ di mɛ mbɑ́ɑ́ fíé iwũɔ̃ bɛ bɔkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Bɛ̀ bɑ́ nkpɑɑ́ di tenkɛ̀ miɛkɛ, bɛ̀ yɑ̀ɑ̀ bo di tentɛ kɛ̀ di dɔɔ̀ mɛyɛi nkɛ́ n yetɛ́nɛ̀, kɛ́fíé iwũɔ̃ bɛ bɔkɛ̀, kɛ̀ dɛ̀ di bɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Fɔ̃́ nnɛ̀ Anɔɔ nɛ̀ Nɑdɑbu nɛ̀ Abiu nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ sipísìyiekɛ̀ dí dekɛní ditɑ̃rì. Kɛ̀ di kpɑɑ́ díɛ́tìrìní di nínkú. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Kɛ̀ bɛtɔbɛ̀ ndɛ nkpɑɑ́, kɑ̀ɑ tɔ́ɔ́nní m borɛ̀ ɑmɑ́ɑ̀, kubotí mɛ mbɑ́ɑ́ dekɛní. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Kɛ̀ Mɔyiisi kɔtɛ kɛ́ tì nɑ̀kɛ́ bɛnìtìbɛ̀, kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛmɔu kɛ dɔ̀: Ti yiemmu kɛ bo dɔɔ̀ ti Yiɛ̀ nKuyie nyɛ̃ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Kɛ̀ Mɔyiisii wɑ̃ri ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì timɔu, kɛ́ítɛ́ dikṹnweńnì sɛ̀ì kɛ́mɑɑ́ diwũɔ̃tɔ̀nnì ditɑ̃rì pɛ̃ri kɛ́fíí nyɛtɑ̃́rɛ̀ tɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀, Isidɑyɛɛribɛ wuɔ ntɛpíítɛ̀ nɛ̀ ìdɛ́ì kpɛyɛ, ");
INSERT INTO tbzsim_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","kɛ́tɑ̃ɑ̃tɛ́ Isidɑyɛɛribɛ miɛkɛ bɛdɑpɑ̀mbɛ̀, kɛ̀ bɛ̀ɛ fíé ti Yiɛ̀ nKuyie nyiwũɔ̃ kɛ́tuɔ nkɛ́fíé yɛnɑɑdɑkɛ̀ mɛtɑummɛ̀ kpɛyɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Kɛ̀ Mɔyiisii ceé mmɛyĩ̀ĩ̀ ndibuu miɛkɛ, kɛ́túótɛ́ mɛsɔmmɛ kɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì, ");
INSERT INTO tbzsim_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","kɛ́túótɛ́ mɛtɑummɛ̀ kó dipɑ́tíri, kɛ́kɑɑ mbɛnìtìbɛ̀ bɛmɔu ììkɛ̀. Kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛmɔu kɛ dɔ̀: Ti yiemmu kɛ bo dɔɔ̀ ti Yiɛ̀ nKuyie mbɛ́i ntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Kɛ̀ Mɔyiisii túótɛ́ mɛyĩ̀ĩ̀ nkɛ́míɛ́tɛ́ bɛnìtìbɛ̀ kɛ dɔ̀: Mɛ nyĩ̀ĩ̀ mmɛɛ̀ bɛnkú ti Yiɛ̀ nKuyie ndi tɑunnɛ̀mɛ̀ kumɑ́ɑ̀ nɛ̀ ku nɑ́ɑǹtì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Dɛ kó difɔ̃nkúò Mɔyiisi nɛ̀ Anɔɔ nɛ̀ Nɑdɑbu nɛ̀ Abiu nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ sipísìyiekɛ̀, kɛ̀ bɛ̀ɛ dekɛ ditɑ̃rì, ");
INSERT INTO tbzsim_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","kɛ́yɑ̀ Kuyie nyIsidɑyɛɛribɛ tũ nkù, kɛ̀ ku nɑɑ̀cɛ̀i nɑ dɛ̀ dò nditɑ̃sɑ̀ɑ̀rì kɛ miɛti, kɛ dò ntiwɛtì kɛ wenni pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Kuyie mmɛ nyí ndɔ̀ɔ̀ mɛyɛi mmɑmɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀, kɛ̀ bɛ̀ɛ kù yɑ̀, kɛ́deè kɛ́di kɛ́yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Dekɛní m borɛ̀ ditɑ̃rì kɛ̀ n dɑ duɔ́ ntitɑ̃́píɛ̀tì n wɑ̃̀ri tìì ĩ́nkɛ̀ ikuɔ́, kɑ̀ɑ ì tié nyIsidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Kɛ̀ Mɔyiisii nɛinɛ̀ Sosuwee o kóo tɔ̃ntì, kɛ̀ bɛ̀ɛ dekɛ Kuyie ntɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Kɛ̀ Mɔyiisi nɑ́kɛ́ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ dɔ̀: Nkpɑɑ́nɛ̀ diɛ nkɛ̀ ti wɛ̃tɛní. Kòò mɔù mɔ̀kɛ tìmɑtì wèe yɑ̀ Anɔɔ nɛ̀ Uuri. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Kɛ̀ Mɔyiisi ńdeètì ditɑ̃rì kɛ̀ diwɛtirìi dì kɑ̃ɑ̃́nko. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nkó tikpetì ḿbo Sinɑii tɑ̃rì ĩ́nkɛ̀, kɛ̀ diwɛtirì ndì dɑ̀ɑ́tí kɛ́ dɔ̀ yɛwe yɛ̀kuɔ̀, diyiénnì yiè, kɛ̀ ti Yiɛ̀ nKuyie nyú Mɔyiisi diwɛtìrì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Kɛ̀ Isidɑyɛɛribɛ nwúó nti Yiɛ̀ nKuyie nkó tikpetì kɛ̀ tì dò mmuhɑ̃ɑ̃́ mmùù cɔ̀ú. ");
INSERT INTO tbzsim_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Kɛ̀ Mɔyiisii tɑ diwɛtirì miɛkɛ, kɛ́dekoo ditɑ̃rì ĩ́nkɛ̀ kɛ dɔ̀ iyiè nsipísìnɑ̀ɑ̀, dɛyènnɛ̀ sipísìnɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ̀ bɛ̀ n cuɔ́ yɛpɑ̃rɛ̀, bɛ̀ɛ̀ dɔ́ kɛ́ m pɑ̃ bɛ kpɛrɛ nɛ̀ bɛ̀ yɛ̀mmɛ̀ mɛmɔu dí cuɔ́ bɛɛ̀ kó yɛpɑ̃rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ntɛ di yóó cuɔ́ yɛ̀ɛ̀ pɑ̃rɛ̀: Mɛsɔɔ nnɛ̀ timɑ́tì pɛ́ítì nɛ̀ disɔɔwũɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","nɛ̀ mupɑ̀ɑ̀kómmú mùù dò mmɛbèrìmɛ̀ nɛ̀ mùù dò nfɛtònfɛ̀ nɛ̀ mùù dò mmɛyĩ̀ĩ̀ nnɛ̀ mupɑ̀ɑ̀konkperímù nɛ̀ tibɔcìtì, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","nɛ̀ tipekɔ̃̀ntì wũɔ̃tì nɛ̀ dɛtekperɛ̀ kó idɛí, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","nɛ̀ mɛfìtíkùɔ̀ nnɛ̀ mɛkɔutɛ́kùɔ̀ mmɛ̀ɛ̀ kɔkɛ́nɛ̀ tùdɑ̀ɑ̀rí nɛ̀ tihúúntì bɛ̀ tùɔ̀ ntì, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","nɛ̀ yɛtɑ̃́rɛ̀ yɛ̀ɛ̀ sɔ̀ù kɛ do ndimɑntɔ̃nnì nɛ̀ yɛtɑ̃́sɑ̀ɑ̀yɛ̀ tɛyɛ̀ nɛ̀ dikɔutɛ́yɑɑ̀bòrì sɑ́m̀pɔ́rì nɛ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì ikuɔ́ nìùtì kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Kɛ̀ dí n dɔɔ̀ mɛtɑummɛ̀ tou n yó mbo dì di cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Di yóó dì dɔ̀ɔ̀ nɛ̀ di nɛntì kɛ̀ dì ndònnɛ̀ n yóó dɑ bɛnkɛ mɛ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Dí dɔɔ̀nɛ̀ ditɔu nɛ̀ dɛtekperɛ̀ kó idɛí, kɛ̀ di okùmɛ̀ ḿbo mɛ́tìrì omɑ́ɑ̀ nɛ̀ sɑ̃ntimɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù, kɛ̀ di pɛ̃kùmɛ̀ ḿbo sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù, di cómmɛ̀ sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Kɛ̀ dí dì dɑ̀ri mɛsɔɔ mmɔ́mmɔmmɛ di miɛkɛ, nɛ̀ di ĩ́nkɛ̀ kɛ́ mɛ̀ kpɛ̃̀ ndi nùù, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","kɛ́dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ dɛ̀nɑ̀ɑ̀ bɑ́ kùù mɑ̀nku mùmɑ́ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","kɛ́dɔɔ̀ dɛtekperɛ̀ kó idɛí kó ipɑ̀ɑ̀ti ìdɛ́ì, kɛ́ ì dɑ̀ri mɛsɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kɛ̀ dí ì tɔ̃nnɛ́ dɛmɑ́mɑ́nnɛ̀ dɛ̀ɛ̀ cɑ̀ɑ́tí ditɔu, kɛ̀ bɛ̀ ndi tòúnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Dɛ kó ipɑ̀ɑ̀ti yó ndɛ ntũɔ̃̀ sɑ̃́ɑ̃̀, di bɑ́ɑ́ ì dɛ̀itɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Di yóó dɛ nhɑ̃nnɛ́ n tɑnnɔ̀ kó titɑ̃́píɛ̀tì n yóó dɑ duɔ́ ntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Kɛ̀ dí dɔɔ̀ kupòkù nɛ̀ mɛsɔɔ mmɔ́mmɔmmɛ, kɛ̀ ku okùmɛ̀ ḿbo mɛ́tìrì òmɑ́ɑ̀ nɛ̀ sɑ̃ntimɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù, ku pɛ̃kùmɛ̀ sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Kɛ̀ dí mɑ́ bɛĩ́nkɛ̀mbɑ̀rìbɛ̀ bɛ̀dɛ́bɛ̀ kó tifèntì nɛ̀ mɛsɔɔ mmɑ́ɑ̀, kɛ́cónnɛ́ ditɔu pòkù ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","kɛ́cónnɛ́ kuu ku m̀píkù, kutɛkù kupíkù tɛkù, kɛ̀ tì ntɑunɛ̀ ditɔu pòkù, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","kɛ́nco titɔbɛ̀ kɛ wetí ditɔu pòkù, kɛ yuo ti fìɛ̀ti kɛ dɑ́ɑ́tí ditɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kɛ̀ dí ɑ̃nnɛ́ n tɑnnɔ̀ kó titɑ̃́píɛ̀tì n yóó dɑ duɔ́ ntì ditɔu miɛkɛ, kɛ́poo nkupòkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","N níí yóó kɔtoo ditɔu ĩ́nkɛ̀ nkɛ bɛĩ́nkɛ̀mbɑ̀rìbɛ̀ bɛ̀dɛ́bɛ̀ fèntì sɑku, tìì còḿmú n tɑummɛ̀ tɔu ĩ́nkɛ̀, kɛ́ dɑ nɑ́kɛ́ n dɔ́ ɑ́ nɑ́kɛ́ tì Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Dí bɑɑkɛ́ tɑ́bùrì, nɛ̀ dɛtekperɛ̀ kó idɛí kòo okùmɛ̀ ḿbo mɛ́tìrì òmɑ́ɑ̀, mɛpɛ̃kùmɛ̀ mɛ́tìrì kó dikéè, mɛcómmɛ̀ sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","kɛ̀ dí ò dɑ̀ri mɛsɔɔ mmɔ́mmɔmmɛ, kɛ́ mɛ̀ kpɛ̃ nho nùù. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Kɛ̀ dí ò ɑ̃nnɛ́ kuperí kɛ́fii ntipíìtì tìnɑ̀ɑ̀ kɛ̀ mɛpɛ̃kùmɛ̀ ḿbo sɑ̃ntimɛ́tìrì mɛ̀ni, kɛ̀ dí kù kpɛ̃ mmɛsɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Dí dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ kɛ́cɑ́tínnɛ́ tɑ́bùrì mɑ̀nkɛ inɑ̀ɑ̀, o tɑ̀ɑ̀kɛ berí ndɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Dɛ kó dɛmɑ́mɑ́nnɛ̀ yó ncɑ́ɑ́tí kɛ tɔ́kɛ́nɛ̀ kuperí nku, kɛ̀ bɛ̀ níí tɔ̃nnɛ́ ipɑ̀ɑ̀ti kɛ́túótɛ́ tɑ́bùrì, ");
INSERT INTO tbzsim_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","kɛ́dɔɔ̀ dɛtekperɛ̀ kó idɛí kó ipɑ̀ɑ̀ti ìdɛ́ì kɛ́ ì dɑ̀ri mɛsɔɔ, nyìì yó ntóúnɛ̀ tɑ́bùrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Dí dɔɔ̀ tisɔɔnɛntì mɔ́mmɔnti: Yɛsékɛ́bɔ nɛ̀ ibòòkɛ nɛ̀ yɛbɔ di yó ndɔɔri ndɛ̀ ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Weè tɑ́bùrì ĩ́nkɛ̀ nkɛ di yó ndɑkùmɛ̀ pɛ̃́ɛ̃̀bɛ̀ di m pɑ̃ɑ̃ mbɛ̀, kɛ̀ bɛ̀ mbo sɑ̃́ɑ̃̀ n yììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Dí dɔɔ̀ tɛsɔɔfitíkɛ̀kɛ̀tɛ̀ kɛ́ tɛ̀ mɑ́nɛ̀ mɛsɔɔ mmɑ́ɑ̀, tɛ tɑ̀rì nɛ̀ tɛ̀ bɑkɛ nɛ̀ tɛ tòkɛ̀ nɛ̀ dɛ̀ɛ̀ dò mmutepóó nnɛ̀ tɛ kɛ̀kɛ̀ɛ dɛ̀ yó ntɑumu. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Kɛ̀ tɛ bɑkɛɛ yɑtɛ ìkuɔ̀, ku mpíkù ìtɑ̃ɑ̃ti, kutɛkù ìtɑ̃ɑ̃ti nɛ̀ dɛ cuokɛ̀ kɔku. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Kɛ̀ dɛ kó ibɑkɛ ìkuɔ̀ mmɔkɛ bɑ́ kù yɛtòkɛ̀ yɛ̀tɑ̃ɑ̃ti, kɛ̀ yɛ̀ ńdònnɛ̀ yɛtebɛ bɛ̀ tu yɛ̀ ɑmɑndì nɛ̀ dɛ̀ɛ̀ dò mmutepóó. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kɛ̀ dɛ cuokɛ̀ kɔku mmɔkɛ yɛtòkɛ̀ yɛ̀nɑ̀ɑ̀, nɛ̀ dɛ̀ɛ̀ dò mmutepóó nkɛ dònnɛ̀ yɛtebɛ, bɛ̀ tu yɛ̀ ɑmɑndì. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Tɛ bɑkɛ ìtɑ̃ɑ̃ti tuutɛ́ ndɛ̀ dɛ cuokɛ̀ kó kudɔú kɛ̀ dɛ̀ mmɔkɛ yɛtòkɛ̀ yɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Yɛtòkɛ̀ nɛ̀ tɛ bɑkɛ kɛ̀ dɛ̀ ntú mɛsɔɔ mmɔ́mmɔmmɛ kɛ tɑu. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Kɛ̀ dí dɔɔ̀ sikɛ̀kɛ̀ɛ sìyiekɛ̀ kɛ́toú ntoú nkɛ̀ sì ncɔ́ú nkɛ̀ dɛ̀ wenni dɛ ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Dí dɔɔ̀ ihɑɑkɛ́ nɛ̀ dɛ̀ɛ̀ yó nkounɛ̀ mutɑ́pɛí nkɛ̀ dɛ̀ ntú mɛsɔɔ mmɔ́mmɔmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Tɛfitíkɛ̀kɛ̀tɛ̀ nɛ̀ tɛ nɛntì dɛ̀ yóó dɔɔ̀nɛ̀ mɛsɔɔ mmɔ́mmɔmmɛ mmɛ, cìdóòbɛ̀ sipísìtɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Fɔ̃́ mMɔyiisi, ɑ́ tũnnɛ n dɑ bɛnkɛmɛ̀ diɛ nditɑ̃rì ĩ́nkɛ̀ kɛ̀ dí tɛ̀ dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Di dɔɔ̀ n tɑummɛ̀ tou nɛ̀ tiyɑɑ̀yɔ́ntì tɛpíítɛ̀ tìì dùɔ̀kɛnɛ̀ mupɑ̀ɑ̀konkperímù nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀, nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀, dí kpɛ̃ mbɛĩ́nkɛ̀mbɑ̀rìbɛ̀ kó tifèntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Kɛ̀ ti okùmɛ̀ ḿbo mɛ́tìrì tɛpíítɛ̀ nɛ̀ mɛ̀nɑ̀ɑ̀, ti pɛ̃kùmɛ̀ mɛ́tìrì mɛ̀dɛ́mɛ̀. Timɔu ti yó mmɛ mmɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Kɛ̀ dí tì tɑu ntìnùmmù, tìnùmmù, ");
INSERT INTO tbzsim_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","kɛ́cɑ́tínnɛ́ tiketitì mɑ̀nku tipecìtì kó iwɛ̃ĩ ìì dò mmɛbèrìmɛ̀, kɛ́ mɛ ndɔɔ̀ tisɔnti. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Dɛ kó iwɛ̃ĩ yó mbo sipísìnùmmù ndi, ku mpíkù nɛ̀ kutɛkù kɛ dò nyitɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Dí dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ sipísìnùmmù dɛ̀ɛ̀ sɛùnɛ̀, kɛ̀ dɛ̀ɛ tɑu ndɛ kó tiyɑ̀ɑ̀tì tidɛ́, kɛ̀ tìi nɑɑ́ nkùmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Kɛ̀ dí duɔkɛnɛ̀ tibɔcìtì tiyɑɑ̀yɔ́ntì tɛpíítɛ̀ nɛ̀ kùmɑ́ɑ̀. Dɛ kó tiyɑ̀ɑ̀tì tiì yó nkɑ̃nkɛ́ n tɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Dɛ kó tiyɑɑ̀yɔ́ntì okùmɛ̀ yó ḿbo mɛ́tìrì tɛpíítɛ̀ nɛ̀ mɛ̀nùmmù ndi, kɛ̀ ti pɛ̃kùmɛ̀ mbo mɛ́tìrì mɛ̀dɛ́ mɛ̀dɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Kɛ̀ dí tɑu ntìnùmmù, kɛ́tɑu ntitɛtì tìkuɔ̀, kukuɔ́nkù kunku kuù yó nkɑ̃nkɛ́ mɛtɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kɛ̀ dí cɑ́tínnɛ́ kuyɑ̀ɑ̀kù ketikù mɑ̀nku kù tuutɛ́nɛ̀ dɛ̀ kudɛ́ríkù iwɛ̃ĩ sipísìnùmmù, kɛ́cɑ́tínnɛ́ kudɛ́ríkù mɑ̀nku iwɛ̃ĩ sipísìnùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Kɛ̀ dí dɔɔ̀ dibiɛrìmínnì kó dɛmɑ́mɑ́nnɛ̀ sipísìnùmmù, kɛ́sɛunnɛ̀ dɛ kó iwɛ̃ĩ, kɛ̀ dɛ̀ɛ nɑɑ́ nkuyɑ̀ɑ̀kù kùmɑ́ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","kɛ̀ dí tì dɑ̀tínnɛ́ kɛ̀ ti okùmɛ̀ nsúɔ́ nkɛ bɛkɛ mɛtɑummɛ̀ tou fɔ̃nkúò bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kɛ̀ ti pɛ̃kùmɛ̀ nsúɔ́ nkɛ bɛkɛ tipíìtì tidɛ́, kɛ́nkɑ̃nkɛ́ n tɑummɛ̀ tou mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Kɛ̀ dí wɑɑ́ ntipedɑkɔ̃̀ntì wũɔ̃tì kɛ́tɑu, kɛ́wɑɑ́ nkukɔ̃̀nkù kperíkù kɛ́nɔ́ɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Kɛ̀ dí wɑɑ́ n tɑummɛ̀ tou kó tidɑbɛɛtì kó idɛí, kɛ̀ ì ntú dɛtekperɛ̀ kó idɛí. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Bɑ́ kù, kɛ̀ ku okùmɛ̀ ḿbo mɛ́tírìbɛ̀ bɛ̀nùmmù kɛ̀ kù pɛ̃kùmɛ̀ ḿbo sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Dí tì wɑɑ́ nkɛ̀ tì mmɔkɛ mɛyɑ̀ɑ̀ mmɛ̀dɛ́mɛ̀ dɛ́mɛ̀ mɛ̀ɛ̀ yóó sɛunnɛ̀ timɑ́tì pɛ́ítì kó yɛcɑubɛ. Di tì dɔ̀ɔ̀ timɔu kɛ̀ tì mmɛ ndò. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Dí tì wɑɑ́ nkɛ̀ tì ḿbo sipísìdɛ́, kɛ́ncómmú kɛ wetí kubɑkù cɑ̃̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Kɛ̀ dí dɔɔ̀ timɑ́tì pɛ́ítì kó yɛcɑubɛ sipísìnɑ̀ɑ̀, kɛ́sɛu mbɑ́ dìì sɑ̃ɑ̃̀ fũ̀ɔ̃̀ yɛ̀dɛ́ɛ̀ yɛ̀dɛ́ɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Kɛ̀ tidɑbɛɛtì tɛtì múnkɛ ḿbo sipísìdɛ́ kubɑkù yoú bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Kɛ̀ dí dɔɔ̀ timɑ́tì pɛ́ítì kó yɛcɑubɛ sipísìnɑ̀ɑ̀ kɛ́sɛu mbɑ́ dìì sɑ̃ɑ̃̀ fũ̀ɔ̃̀ yɛ̀dɛ́ɛ̀ yɛ̀dɛ́ɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Kɛ̀ dí wɑɑ́ ntidɑbɛɛtì tìkuɔ̀ kɛ́cónnɛ́ dɛ ììkɛ̀ bíɛ́kɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","kɛ́wɑɑ́ ntitɛtì tìdɛ́tì mɛtɑummɛ̀ tou kentímɛ̀ dɛ ììkɛ̀ bíɛ́kɛ̀ kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Kɛ̀ tì ntɑu tìdɛ́tì dɛ́tì ti fũ̀ɔ̃̀, kɛ́tɑu mɛyómmɛ̀ nɛ̀ mumɑ́mɑ́ɑ́, kɛ mmɛ ndò tipíìtì tidɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kɛ̀ dɛ̀ɛ wɛ̃nnɛ́ tidɑbɛɛtì tìni, timɑ́tì pɛ́ítì kó yɛcɑubɛ tɛpíítɛ̀ nɛ̀ yɛ̀kùɔ̀, bɑ́ kùù dɑbɛkù yɛ̀dɛ́ɛ̀ yɛ̀dɛ́ɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Dí cíɛ́kɛ́ dɛtekperɛ̀ kó idɛí kó ipɑ̃nní ìnùmmù kɛ́pɑ̃́nnɛ́ mɛtɑummɛ̀ tou miɛkɛ kupíkù ketikù. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","Kɛ̀ kupíkù dɛ́ríkù kpɛyi ḿbo ìnùmmù, dɛ ììkɛ̀ kpɛyi ìnùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Kɛ̀ dɛ cuokɛ̀ kó kupɑ̃nníi tɔ̃nnɛ́ yɛsɑ̃ǹkɛ̀ cuokɛ̀ ku mmɑ̀nku nɛ̀ kutɛkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Kɛ̀ dí dɑri yɛsɑ̃ǹkɛ̀ nɛ̀ ipɑ̃nní mɛsɔɔ nkɛ́dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ ɑ yóó tɔ̃nnɛ́ dɛ̀ɛ̀ miɛkɛ ipɑ̃nní. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Á tũnnɛ n dɑ bɛnkɛmɛ̀ diɛ nditɑ̃rì ĩ́nkɛ̀ kɛ̀ dí tɛ̀ dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Dí dɔɔ̀ kuyɑɑ̀kpenkpetínkù nɛ̀ mupɑ̀ɑ̀konkperímù nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀, kɛ́kpɛ̃ nkɛ̀ dɛ̀ ndò mbɛĩ́nkɛ̀mbɑ̀rìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kɛ̀ dí kù nùńnɛ́ dɛtekperɛ̀ kó idɛí kó yɛsɑ̃ǹkɛ̀ yɛ̀nɑ̀ɑ̀ kó ibɑɑkɛ́ ìì dɑ̀ri mɛsɔɔ, kɛ́sɛunɛ̀ timɑ́tì pɛ́ítì kó yɛcɑubɛ yɛ̀nɑ̀ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","kɛ́núnnɛ́ kuyɑ̀ɑ̀kù ibɑɑkɛ́, kɛ́tɑnnɛ́ n tɑummɛ̀ tɔu dɛ miɛkɛ. Dɛ kó kuyɑ̀ɑ̀kù kuù yó nyɑɑ̀tì ikuɔ́ dieku nɛ̀ ikuɔ́ nɛntì kó kufɑ̃́ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Kɛ̀ dí poo nkupòkù n tɑummɛ̀ tɔu kɛ́ĩ́nnɛ́ ikuɔ́ nɛntì kó kufɑ̃́ɑ̃́ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Kɑ̀ɑ ĩ́nnɛ́ tɑ́bùrì kudieku tɛkù, kubɑkù yoú bíɛ́kɛ̀, kɛ́ĩ́nnɛ́ tɛfitíkɛ̀kɛ̀tɛ̀ kubɑkù cɑ̃̀nku bíɛ́kɛ̀, kɛ́wetínnɛ́ tɑ́bùrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Dí dɔɔ̀ dibòrì kó kuyɑ̀ɑ̀kù nɛ̀ mupɑ̀ɑ̀konkperímù mùù kɔkɛ́nɛ̀ tipecìtì, tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò nfɛtònfɛ̀ nɛ̀ tìì do mmɛyĩ̀ĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Dí dɔɔ̀ kuyɑɑ̀kpenkpetínkù kó idɛí dɛtekperɛ̀ kpɛyi ìnùmmù, kɛ́ ì dɑ̀ri mɛsɔɔ, kɛ́ɑ̃nnɛ́ yɛsɔɔbɑ̀kɛ̀ yɛ̀nùmmù nɛ̀ dibiɛrìmínnì kó yɛcɑubɛ yɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Dí dɔɔ̀ diwũɔ̃tɔ̀nnì nɛ̀ dɛtekperɛ̀ kó idɛí, kɛ̀ di okùmɛ̀ ḿbo mɛ́tìrì mɛ̀dɛ́ nɛ̀ dikéè. Dì yó mmɑ̀ di píìtì timɔu ndi, kɛ̀ di cómmɛ̀ ḿbo mɛ́tìrì mɛ̀mɑ́ɑ̀ nɛ̀ dikéè. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Kɛ̀ dí ɑ̃nnɛ́ yɛbɑ̀kɛ̀ di kentímɛ̀ mɛnɑ̀ɑ̀ dɛ ĩ́nkɛ̀, kɛ̀ yɛ̀ ntɑunɛ̀ diwũɔ̃tɔ̀nnì, kɑ̀ɑ yɛ̀ dɑ̀ri disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Dí dɔɔ̀ diwũɔ̃tɔ̀nnì kó tinɛntì nɛ̀ disɔɔwũɔ̃̀: Dɛ̀ɛ̀ kounɛ̀ mutɑ́pɛí nnɛ̀ yɛkɑ̃ nɛ̀ yɛbɔ bɛ̀ yó mmɛ́ínɛ̀ yɛ̀ mɛyĩ̀ĩ̀ nnɛ̀ sikṹmboó, ");
INSERT INTO tbzsim_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","kɛ́dɔɔ̀ disɔɔwũɔ̃̀ kó tɛdìtɛ̀ nɛ̀ dɛ kó dɛmɑ́mɑ́nnɛ̀ dɛ̀nɑ̀ɑ̀ kɛ́cɑ́tínnɛ́ di kentímɛ̀ mɛnɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Kɛ̀ dí tɛ̀ sɑ̀ɑ nkɛ̀ tɛ̀ ḿberínɛ̀ diwũɔ̃tɔ̀nnì cuokɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","kɛ́dɔɔ̀ dɛtekperɛ̀ kó idɛí kó ipɑ̀ɑ̀ti ìdɛ́ì, kɛ́ ì dɑ̀ri disɔɔwũɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","kɛ́ ì tɔ̃nnɛ́ diwũɔ̃tɔ̀nnì kó dɛmɑ́mɑ́nnɛ̀ tipíìtì tidɛ́ kɛ̀ dí ndì tɔunɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Di yóó dì dɔ̀ɔ̀ kɛ̀ dì nhorímu kɛ́ndò n dɑ bɛnkɛmɛ̀ diɛ nditɑ̃rì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Ntɛ di yóó dɔɔ̀mɛ̀ kuperí nɛ̀ mupɑ̀ɑ̀konkperímù kɛ́cɛ̃ɛ̃tɛ n tɑummɛ̀ tou: Kubɑkù cɑ̃̀nku bíɛ́kɛ̀ kó mɛokùmɛ̀ ḿbo mɛ́tírì sipísìnùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Kɛ̀ yɛsɑ̃ǹkɛ̀ ḿbo sipísìdɛ́ nɛ̀ disɔɔwũɔ̃̀ kó yɛcɑubɛ sipísìdɛ́ nɛ̀ timɑ́tì pɛ́ítì kó ibɑɑkɛ́ nɛ̀ ti kó ipɑ̀ɑ̀ti tiyɑ̀ɑ̀tì yóó núnnɛ́ ì. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Kubɑkù yoú bíɛ́kɛ̀ kó mɛokùmɛ̀ ḿmɑ̀, kɛ́ndò mmɛtɛ̃mɛ̀ dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Kɛ̀ dɛ ììkɛ̀ bíɛ́kɛ̀ kó mɛpɛ̃kùmɛ̀ ḿbo mɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù nɛ̀ yɛsɑ̃ǹkɛ̀ tɛpíítɛ̀ nɛ̀ yɛ kó yɛcɑubɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Kɛ̀ didonfũ̀ɔ̃̀ bíɛ́kɛ̀ kó mɛpɛ̃kùmɛ̀ ḿbo mɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Dibòrì píìtì tidɛ́ bɑ́ kù, kù mmɔkɛ mɛ́tìrì mɛ̀yiekɛ̀ nɛ̀ dikéè, nɛ̀ yɛsɑ̃ǹkɛ̀ yɛ̀tɑ̃ɑ̃ti nɛ̀ yɛ kó yɛcɑubɛ yɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Kuperí kó dibòrì kó kuyɑ̀ɑ̀kù yó ḿbo mɛ́tìrì tɛpíítɛ̀ ntɛ, kɛ́ndò mmɛbèrìmɛ̀, kɛ dò nfɛtònfɛ̀, kɛ dò mmɛyĩ̀ĩ̀, kɛ dùɔ̀kɛnɛ̀ mupɑ̀ɑ̀konkperímù, kɛ kpɛ̃̀. Kɛ̀ yɛsɑ̃ǹkɛ̀ ḿbo yɛ̀nɑ̀ɑ̀ nɛ̀ yɛ kó yɛcɑubɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Yɛsɑ̃ǹkɛ̀ yɛmɔu yó ntɑunɛ̀ yɛtɔbɛ̀ timɑ́tì pɛ́ítì kó iwɛ̃ĩ nyi. Kɛ̀ ibɑɑkɛ́ ntú timɑ́tì pɛ́ítì kɛ̀ yɛcɑubɛ ntú disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kuperí okùmɛ̀ yó mbo mɛ́tìrì sipísìnùmmù ndi, kɛ̀ mɛpɛ̃kùmɛ̀ ḿbo mɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù, kɛ̀ mɛcómmɛ̀ ḿbo mɛ́tìrì mɛ̀dɛ́mɛ̀ nɛ̀ dikéè. Kuperí yóó dɔɔ̀nɛ̀ mupɑ̀ɑ̀konkperímù mmu, kɛ̀ yɛsɑ̃ǹkɛ̀ kó yɛcɑubɛ ntú disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Bɛ̀ yó mpĩĩnnɛ̀ tìì nɛntì n cĩ́ɛ̃̀tɛ̀ tɔ̃mmú nɛ̀ yɛsɑ̃ǹkɛ̀ tɛcĩ́ɛ̃̀tɛ̀ kpɛyɛ nɛ̀ kuperí kpɛyɛ yó ntú disɔɔwũɔ̃̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Fɔ̃́ mMɔyiisi ɑ́ duɔ́ nkɛ̀ Isidɑyɛɛribɛ dɑ díí mɛkɔsɑ̀ɑ̀mɛ̀ odìfíè kó yɛtebɛ kɔ̃mɛ, kɛ̀ dɛ̀ɛ yie nkɛ̀ fitírɛ̀ ńcɔ́ú nsɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Anɔɔ nɛ̀ o bí bɛɛ̀ níí yóó dɛ̀ tùɔ nkɛ́ĩ́nnɛ́ kuyɑ̀ɑ̀kù kùù kɑ̃nkɛ́ mí ndi Yiɛ̀ nKuyie ntɔu kupíkù tɛkù bíɛ́kɛ̀, kɛ̀ dɛ̀ ncɔ́ú nkuyuoku nɛ̀ dikṹnweńnɔ̀ɔ mí nKuyie nyììkɛ̀. Dɛ̀ yó ntú Isidɑyɛɛribɛ kuɔ́ nyi sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Kɛ̀ Kuyie mbɛ́i nkɛ dɔ̀: Fɔ̃́ mMɔyiisi ɑ́ yú ɑ kóo kótì Anɔɔ nɛ̀ o bí Nɑdɑbu nɛ̀ Abiu nɛ̀ Edeɑsɑɑ nɛ̀ Itɑmɑɑ kɛ́ bɛ̀ cɑ̃̀ńnɛ́ nɛ̀ Isidɑyɛɛribɛ tɔbɛ̀, kɛ̀ bɛ̀ ntú ikuɔ́ nìùbɛ̀ kɛ pĩ́ n tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Á dɔɔ̀ ɑ kóo kótì Anɔɔ tiyɑɑ̀kpetì ikuɔ́ kpɛti, tìì yó mbɛnkú ò cɑ̃̀ɑ̃́nnɛ̀mɛ̀ bɛtɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Á nɑ́kɛ́ bɛyɑɑ̀dùɔ̀bɛ̀ n duɔ́ mbɛ̀ mɛciì nkɛ̀ bɛ̀ɛ dɔɔ̀ Anɔɔ tiyɑ̀ɑ̀tì kòò ntì dɑɑti kɛ pĩĩnnɛ̀ n tɔ̃mmú kɛ̀ tì mbɛnkú ò cɑ̃̀ɑ̃́mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Dɛ kó tiyɑ̀ɑ̀tì yó ntú dicĩ̀ncĩ̀nkɔ̃̀nnì, nɛ̀ tɛkɔutɛ́yɑɑ̀bòtɛ̀, nɛ̀ dikɔutɛ́yɑɑ̀bòkũpuri nɛ̀ dikɔutɛ́yɑɑ̀bòhokùrì dìì kpɛ̃̀, nɛ̀ fɛítòòdɑ́fɛ̀ nɛ̀ fɛnɑɑ̀kɔ̃̀nfɛ̀. A kóo kótì Anɔɔ nɛ̀ o bí bɛ̀ níí yó nti ndɑ́ɑ́tí kɛ pĩ́nnɛ̀ ikuɔ́ tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Bɛ̀ yóó tì kpɛ̃ nnɛ̀ tipecìtì nti tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò nfɛtònfɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ musɔɔpɑ̀ɑ̀kómmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Á duɔ́ nkɛ̀ bɛ̀ɛ dɔɔ̀ tɛkɔutɛ́yɑɑ̀bòtɛ̀ nɛ̀ mupɑ̀ɑ̀konkperímù nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀, nɛ̀ tìì dò nfɛtònfɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ musɔɔpɑ̀ɑ̀kómmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Dɛ kó tɛkɔutɛ́yɑɑ̀bòtɛ̀ yó mmɔkɛ ibɑɑtí nyi tipíìtì tidɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kuyɑɑ̀bomboúnkù múnkɛ yóó dɔɔ̀ nɛ̀ muù pɑɑ̀kómmú botí, kɛ́ntɑunɛ̀ tɛkɔutɛ́yɑɑ̀bòtɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Á wɑɑ́ nyɛtɑ̃́rɛ̀ yɛ̀dɛ́ɛ̀ yɛ̀ɛ̀ dò ndimɑntɔ̃nnì kɛ́kerí Isidɑyɛɛribɛ bí yètɛ̀ yɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Yɛyètɛ̀ yɛ̀kuɔ̀ ditɑ̃́ketirì ĩ́nkɛ̀, yɛtɛyɛ̀ yɛ̀kuɔ̀ didɛ́rì ĩ́nkɛ̀, kɛ̀ yɛ̀ ntũ nyɛtɔbɛ̀ bɛ̀ bɛ̀ piɛ́ mɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Otɑ̃́cíɛ́tì weè yóó kérí yɛyètɛ̀ yɛtɑ̃́rɛ̀ yɛdɛ́ ĩ́nkɛ̀ kɛ́ yɛ̀ dɑ̀nnɛ nɛ̀ mɛsɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Wèe yɛ̀ cɑ̀tínɛ́ tɛkɔutɛ́yɑɑ̀bòtɛ̀ bɑɑti idɛ́, kɛ̀ yɛ̀ ḿbɛnkú Isidɑyɛɛribɛ botí tɛpíítɛ̀ nɛ̀ ìdɛ́ì, kɛ̀ Anɔɔ níí ntɑti n tɑummɛ̀ tou kɛ̀ dì ɑ̃, mí ndi Yiɛ̀ nKuyie nkɛ̀ m bɑ́ɑ́ di yɛ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","A yóó dɑnnɛ dɛ̀ɛ̀ ĩ́nkɛ̀ yɛtɑ̃́rɛ̀ yó ntú mɛsɔɔ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Á dɔɔ̀ mɛsɔɔfĩmmɛ mɔ́nmɔmmɛ mɛ̀dɛ́mɛ̀ kɛ̀ mɛ̀ ndò nyiwɛ̃ĩ, kɑ̀ɑ mɛ̀ cɑ̀tínnɛ́ yɛtɑ̃́rɛ̀ dɑ̀ri dɛ̀ɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Á duɔ́ nkɛ̀ bɛ̀ɛ dɔɔ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì nɛ̀ mupɑ̀ɑ̀konkperímù mùù kɔkɛ́nɛ̀ tipecìtì, tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò nfɛtònfɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nkɛ́kpɛ̃̀nnɛ̀ musɔɔpɑ̀ɑ̀kómmú tɛkɔutɛ́yɑɑ̀bòtɛ̀ kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Di yóó poo mmɛ̀dɛ́mɛ̀ mmɛ, di okùmɛ̀ nɛ̀ di pɛ̃kùmɛ̀ kɛ̀ dɛ̀ mbo sɑ̃ntimɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kɛ̀ dí dì dɑ̀ri itɑ̃́cuɔ́ ìnɑ̀ɑ̀. Kucuɔ́ kuketikù kpɛyɛ, diketirì ndò ntisɛ̃ũmíɛ́tì, kɛ̀ didɛ́rì ndò ntiyɑ̃pemíɛ́tì, kɛ̀ ditɑ̃ɑ̃́nnì ndò mmɛnɔ́ɔ̀nnúɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Kɛ̀ kucuɔ́ dɛ́ríkù kpɛyɛ, dìì dò mmɛcũ̀mmɛ̀, nɛ̀ dìì dò ntiwɛtì nɛ̀ dìì dò nsɑ̀ncìrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Kucuɔ́ ntɑ̃ɑ̃́nkù kpɛyɛ, dìì dò ncòdóò, nɛ̀ dìì dò mpũ̀tìpũ̀tì, nɛ̀ dìì dò mmɛtekɑ̃ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Kucuɔ́ nnɑɑnkù kpɛyɛ, dìì dò ntinɔ́bɛ́ntì nɛ̀ dìì dò ndimɑntɔ̃nnì nɛ̀ dìì dò nditɑ̃́wũɔ̃̀. Bɑ́ dìì tɑ̃́rì yóó dɑnnɛ mɛsɔɔ nyĩ́nkɛ̀ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Otɑ̃́cíɛ́tìi kerí Isidɑyɛɛri bí tɛpíítɛ̀ nɛ̀ ìdɛ́ì bɑ́ dɛ̀ dɛ yètìrì ditɑ̃́rì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Kɛ̀ dí ɑ̃nnɛ́ dicĩ̀ncĩ̀nkɔ̃̀nnì mɛsɔɔfĩmmɛ mɔ́mmɔmmɛ mɛ̀dɛ́mɛ̀ kɛ̀ mɛ̀ ndò nyiwɛ̃ĩ, ");
INSERT INTO tbzsim_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","nɛ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ dɛ̀dɛ́rɛ̀ kɛ́ dɛ̀ cɑ̀tínnɛ́ dicĩ̀ncĩ̀nkɔ̃̀nnì yómmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Kɛ̀ dí dɛ̀ cɑ̀tínɛ́ mɛsɔɔfĩmmɛ kó iwɛ̃ĩ idɛ́ nɛ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì kó dɛmɑ́mɑ́nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Kɛ̀ dí tuutɛ́ iwɛ̃ĩ yómmɛ̀ tɛ̃mɛ̀ yɛbɑkóyɔ borɛ̀, dɛ ììkɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Dí dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ tɛrɛ̀ dɛ̀dɛ́rɛ̀ kɛ́cɑ́tínnɛ́ kɛ̀ dɛfũ̀ɔ̃̀ bíɛ́kɛ̀ nkɑ́ɑ́ ntɛkɔutɛ́yɑɑ̀bòtɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kɛ̀ dí dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ tɛrɛ̀ dɛ̀dɛ́rɛ̀ kɛ́cɑ́tínnɛ́ tɛkɔutɛ́yɑɑ̀bòtɛ̀ fũ̀ɔ̃̀, fɛnɑɑ̀kɔ̃̀nfɛ̀ yɑ́ ndɛ kó diyuu. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Kɛ̀ dí dɔɔ̀ kuhɔ̃ũ kɛ́sɛu ndicĩ̀ncĩ̀nkɔ̃̀nnì kó dɛmɑ́mɑ́nnɛ̀ nɛ̀ tɛkɔutɛ́yɑɑ̀bòtɛ̀ kpɛrɛ kɛ̀ dɛ̀ nwɛ̃ nkɛ tɑu, kɛ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì bɑ́ɑ́ totɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Kɛ̀ Anɔɔ níí ntɑti n tɑummɛ̀ tou kɛ dɑ́ɑ́tí dicĩ̀ncĩ̀nkɔ̃̀nnì, kɛ̀ Isidɑyɛɛri bí yètɛ̀ ńdɑri o cĩ̀ncĩ̀nnì, mí ndi Yiɛ̀ nKuyie nkɛ̀ m bɑ́ɑ́ di yɛ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Fɔ̃́ mMɔyiisi ɑ́ ɑ̃nnɛ́ udimmu nɛ̀ tumimmu Anɔɔ cĩ̀ncĩ̀nkɔ̃̀nnì miɛkɛ, kɛ̀ Anɔɔ níí nkɔri m borɛ̀ kɛ̀ di dɑ̀ɑ́tí, kɛ̀ dɛ̀ɛ yie nkòo bɑntɛ́ n dɔ́nɛ̀ tì Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Dikɔutɛ́yɑɑ̀bòkũpuri Anɔɔ yó nhɑ̃ɑ̃̀ dì yóó duɔkɛnɛ̀ tipecìtì nti tìì dò mmɛbèrìmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kɛ̀ diyuu yó nyiɛ̀ dɛ̀ borɛ̀ɛ duɔkɛ yɛ̃́kɛ́ yɛ̃́kɛ́ kɛ bɑ́ɑ́ kɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kɛ̀ dí kpɛ̃̀ ndiyɑɑ̀bòrì fũ̀ɔ̃̀ kɛ́fitɛ́ nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò nfɛtònfɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nkɛ̀ dɛ̀ ndò nyɛtebɛ bɛ̀ tu yɛ̀ kedenɑ́tì kɛ́cɑ́tínnɛ́ isɔɔdede. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Kɛ̀ ì nsokɛ́ kedenɑ́tìbɛ̀ cuokɛ̀. Diɛ nkedenɑ́tì, diɛ nfɛsɔɔdedefɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Anɔɔ yó ndɑ́ɑ́tí diì yɑɑ̀bòrì kɛ pĩ́nnɛ̀ n kuɔ́ tɔ̃mmú. Ò tɑti dìì mɔ̀nni nɛ̀ ò yɛ̀tì dìì mɔ̀nnì bɛ̀ nyo idedekɛ́ kuɔ̀mmɛ̀ kɛ̀ dɛ̀ɛ yie kòò bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Dí dɔɔ̀ mɛsɔɔ mmɔ́mmɔmmɛ kó tɛmɑ́tìpɛ̀tɛ̀ kɛ́kerí tɛ ĩ́nkɛ̀ kɛ dɔ̀: Wèè cɑ̃̀ɑ̃́ nti Yiɛ̀ nKuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kɛ̀ dí tɛ̀ pĩ̀ńnɛ́nɛ̀ kuhɔ̃ũ kùù dò mmɛbèrìmɛ̀ kuyɑɑ̀bomboúnkù ĩ́nkɛ̀ o tĩ́nnì níí yó mberínɛ̀ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Dɛ kó tɛsɔɔmɑ́tìpɛ̀tɛ̀ níí yó mberínɛ̀ o tĩ́nnì ndi ò kɔ̀ri dìì mɔ̀nnì m borɛ̀, tɛɛ̀ yó mbɛnkú kɛ dò nhAnɔɔ tɔ Isidɑyɛɛribɛ kó mɛyɛi mbɛ̀ dɔ̀ɔ̀ri mɛ̀ nɛ̀ bɛ pɑ̃rɛ̀ miɛkɛ tɛɛ̀ yó nte kɛ̀ ǹ cɔutɛ́ bɛ pɑ̃rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Dí dɔɔ̀ Anɔɔ dikɔutɛ́yɑɑ̀bòhokùrì dìì dùɔ̀kɛnɛ̀ mupɑ̀ɑ̀konkperímù, nɛ̀ kuyɑɑ̀bomboúnkù nɛ̀ fɛnɑɑ̀kɔ̃̀nfɛ̀ fɛ̀ɛ̀ kpɛ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Dí dɔɔ̀ Anɔɔ bí yɛyɑɑ̀bòrɛ̀ nɛ̀ inɑɑkũ̀ɔ̃ nnɛ̀ tiyɑɑ̀bomboúntì kɛ̀ dɛ̀ɛ bɛ̀ cɑ̃̀ńnɛ́ nɛ̀ bɛtɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Á dɑ́tínnɛ́ Anɔɔ nɛ̀ o bí tiyɑ̀ɑ̀tì kɛ́cóú mmɛkùɔ̀ mbɛ̀ yɔ ĩ́nkɛ̀, kɛ́ bɛ̀ wénkùnnɛ, kɛ̀ bɛ̀ ntú ikuɔ́ nìùbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Dí bɛ̀ dɔ̀ɔ̀ yɛyɑɑ̀tɑ̀ɑ̀kékɛ̀ kɛ̀ bɛ̀ɛ kɑ̃ɑ̃́ mbɛ fɔ̃̀. Yɛ̀ yó mberínɛ̀ bɛ kɑ nyɛ kɛ kɑ̃ɑ̃́ mbɛ kpèrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ níí ɑ̃nnɛ́ kɛ́tɑnnɛ̀ n tɑummɛ̀ tou, yoo kɛ́pĩ́nnɛ̀ diwũɔ̃tɔ̀nnì kó mutɔ̃mmú, kɛ̀ bɛ̀ bɑ́ɑ́ yɑ̀ bɛ fɛi kɛ̀ bɛ̀ɛ kú. Dɛ̀ yó ntú Anɔɔ nɛ̀ o bí nɛ̀ o yɑɑ̀bío bɛ kó ikuɔ́ nyì sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Ntɛ ɑ yóó yĩ́mɛ̀ kɛ́cɑ̃́nnɛ́ Anɔɔ nɛ̀ o bí n tɔ̃mmú kpɛ́í: Tɑ̃ɑ̃tɛ́ dinɑɑdɑɑ̀ nɛ̀ yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀ yɛ̀ɛ̀ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Á dɔɔ̀ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti, kɛ́wɑɑ́ mmuyuo nkɛ́ mù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ nkɛ́pɛ̃mmú, kɛ́ tì wɑɑrɛ mɛkùɔ̀, ɑ́ dɛ̀ dɔ̀ɔ̀nɛ̀ dɛmɔu muyuo mmùù í kɔɔrɛnɛ̀ mutie mùù muuti pɛ̃́ɛ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","kɛ́ dɛ̀ ɑ̃nnɛ́ dimɑ́mmùyɑ́ɑ̀ kɛ́wɛ̃nnɛ́nɛ̀ dinɑɑdɑɑ̀ nɛ̀ yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀ kɛ́tɑnnɛ́ n tɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kɑ̀ɑ dèè ɑ kɔtɛnɛ̀ Anɔɔ nɛ̀ o bí n tɑummɛ̀ tou borɛ̀ kɛ́ bɛ̀ wùɔ, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","kɛ́dɑ́tínnɛ́ Anɔɔ tikɔutɛ́yɑ̀ɑ̀tì: Diyɑɑ̀bòrì okùrì, nɛ̀ dikũpuri nɛ̀ disɑ́m̀pɔ́rì nɛ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì, kɛ́boú tɛyɑɑ̀bòtɛ̀ kó fɛnɑɑ̀kɔ̃̀nfɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","kɛ́boú o yuu kuyɑɑ̀bomboúnkù, kóò ĩ́nnɛ́ mɛtɑ̃ɑ̃tímɛ̀ kó fɛyítòòdɑ́fɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Kɑ̀ɑ dèè ɑ́ túótɛ́ ikuɔ́ kó mɛkùɔ̀ nkɛ́cóú nho yuu kóò cɑ̃̀ńnɛ́ n tɔ̃mmú kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Dɛ kó difɔ̃nkúò kɑ̀ɑ duɔ́ nkɛ̀ Anɔɔ bíi tɔ́ɔ́nní kɑ̀ɑ ì dɑ̀tínnɛ́ yɛkɔutɛ́yɑɑ̀bòhokùyɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","kɛ́ bɛ̀ boú inɑɑkũ̀ɔ̃, nkɛ́boú bɛ yɔ tiyɑɑ̀bomboúntì kɛ̀ bɛ̀ɛ nɑɑ́ n tɔ̃mbɛ̀ sɑ̃́ɑ̃̀. Ntɛ ɑ yóó dɔɔ̀mɛ̀ Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ nɛ́ nɑ kɛ́ketɛ́ bɛ tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Á túótɛ́ dinɑɑdɑɑ̀ kɛ́kɔtɛnɛ̀ n tɑummɛ̀ tou bòrì, Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ nɔ́ɔ́ mbɛ nɔu di yuu ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Kɑ̀ɑ dì fèútɛ́ n yììkɛ̀ n tɑummɛ̀ tou bòrì, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","kɛ́pɔɔ̀tɛ̀ ɑ nɔ́mbii mɛyĩ̀ĩ̀ nkɛ́wɑɑrɛ diwũɔ̃tɔ̀nnì bɑ̀kɛ̀, kɛ́cóú mmɛsɔmmɛ diwũɔ̃tɔ̀nnì fũ̀ɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","kɛ́túótɛ́ tinɑutì kó mɛkùɔ̀ nnɛ̀ yɛɔ̃, yɛceumbɛ̀ nɛ̀ yɛ̀ kó mɛkùɔ̀ nkɛ́ dɛ̀ nni ntuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","kɛ́túótɛ́ dɛsɔnnɛ, imɑɑ nnɛ̀ kukɔ̃̀nkù nɛ̀ tinɑutì kɛ́ dɛ̀ tùɔ nditowɑɑ̀ ikuɔ́ nìùbɛ̀ yɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Dɛ kó difɔ̃nkúò kɛ́túótɛ́ dipedɑɑ̀ ketirì, Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ nɔ́ɔ́ mbɛ nɔu di yuu ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Kɑ̀ɑ dì fèútɛ́ kɛ́túótɛ́ mɛyĩ̀ĩ̀ nkɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì ĩ́nkɛ̀ di píìtì timɔu, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","kɛ́kékɛ́ imɑɑ, kɛ́hɔ́ú tinɑutì nɛ̀ itɑ̀ɑ̀kɛ nɛ̀ diyuu kɛ́wɛ̃nnɛ́nɛ̀ imɑɑ nkɛ́dɑɑ́ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","kɛ́tuɔ nfɛɔ̃̀fɛ̀ fɛmɔu, dɛ̀ yó ntú dipɑ̃nnì ndi, mí ndi Yiɛ̀ nKuyie n dɔ́ dìì kó kufɔ̃ɔ̃ku. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kɑ̀ɑ dèè ɑ túótɛ́ dipedɑɑ̀ tɛrì. Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ nɔ́ɔ́ mbɛ nɔu di yuu ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Kɑ̀ɑ dì fèútɛ́ kɛ́pɔɔ̀tɛ̀ mɛyĩ̀ĩ̀ nkɛ́kɑ́ɑ́kɛ́ Anɔɔ toòyouri kó mɛyómmɛ̀ nɛ̀ o bí kɔ̃mɛ, bɛ nɔ́mbídɑkɛ̀ bɛ nɔu nɛ̀ bɛ nɑɑ̀cɛ̀i kpɛyɛ, kɛ́míɛ́tɛ́ mɛsɔmmɛ diwũɔ̃tɔ̀nnì píìtì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kɑ̀ɑ dèè ɑ́ wɑɑ́ mmɛyĩ̀ĩ̀ nsɑ́m̀pɔ́ diwũɔ̃tɔ̀nnì ĩ́nkɛ̀, kɛ́wɑɑ́ nyikuɔ́ kó mɛkùɔ̀ nsɑ́m̀pɔ́ kɛ́míɛ́tɛ́ Anɔɔ nɛ̀ o yɑ̀ɑ̀tì nɛ̀ o bí nɛ̀ i kpɛti, kɛ̀ bɛ̀ɛ wenkɛ bɛmbɛ nɛ̀ bɛ̀ yɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","A yóó kuɔ fɛpìèfɛ̀ dɛ́rífɛ̀ nfɛ kɛ́ bɛ̀ tɑnnɛ́ ikuɔ́ tɔ̃mmú. Kɑ̀ɑ fɛ̀ kùɔ ɑ́ túótɛ́ kuyóú nɛ̀ tinɑutì kó mɛkùɔ̀ nnɛ̀ yɛɔ̃ nɛ̀ yɛceumbɛ̀ nɛ̀ yɛ kó mɛkùɔ̀ nnɛ̀ dikpèrì youri, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","kɛ́dɛitɛ pɛ̃́ɛ̃̀ òmɑ́ɑ̀ nɛ̀ dikɑ̀tìndɑ̀ɑ̀ nɛ̀ kupɛ̃́mpɛ̃ńkù, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","kɛ́ dɛ̀ duɔ́ nhAnɔɔ nɛ̀ o bí, kɛ́ bɛ̀ nɑ̀kɛ́ kɛ̀ bɛ̀ɛ dɛ̀ nni mpɑ̃ ikuɔ́ kó dipɑ̃nnì kɛ́ dɛ̀ nni mbɛnkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Dɛ kó difɔ̃nkúò kɑ̀ɑ dɛ̀ cɔutɛ́ bɛ nɔu miɛkɛ kɛ́wɛ̃nnɛ́nɛ̀ dipɑ̃nnì bɛ̀ m pɑ̃ dì kɛ́tuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti, ");
INSERT INTO tbzsim_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","kɛ́túótɛ́ mɛcɑ̃́nnímɛ̀ kó fɛpìèfɛ̀ ɑ cɑ̃́nnɛ́nɛ̀ fɛ̀ Anɔɔ nɛ̀ o bí fɛ cĩ̀ncĩ̀nnì, kɛ́ m bɛnkɛ ikuɔ́ yɛ̃mmɛ̀, kɛ̀ di dèè ɑ́ dì tùótɛ́ ɑ kó kumɑɑ nku. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","A túótɛ́ dipedɑɑ̀ bɛ̀ cɑ̃̀ńnɛ́nɛ̀ dì Anɔɔ di kó imɑɑ mmiɛkɛ dicĩ̀ncĩ̀nnì nɛ̀ dikpèrì, bɛ̀ dɛ̀ nni mpɑ̃mu, kɛ́ dɛ̀ nni mbɛnkɛ, ɑ́ dɛ̀ cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Isidɑyɛɛribɛ yó ndɛìmu dɛ kó kumɑɑ mbɛ̀ feu ìì wũɔ̃ mɛtɑummɛ̀ kpɛ́í nkɛ kù duɔ̀ nhAnɔɔ nɛ̀ o yɑɑ̀bío sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Kɛ̀ Anɔɔ ku bɛ̀ɛ duɔ́ nyikuɔ́ yɑ̀ɑ̀tì o bí, kɛ̀ ìì tì dɑ̀ɑ́tí bɛ̀ ì cɑ̃́nnìnko dìì yiè, kɛ̀ ì bo tɑ ikuɔ́ tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Anɔɔ bí miɛkɛ bɛ̀ tɑ̃ɑ̃tɛ́ wè kòò bo ntú ikuɔ́ nìùtì kɛ tɑɑ̀ mí nKuyie n kuɔ́ nɛntì bo kùù fɑ̃́ɑ̃́, kɛ pĩ́ nyikuɔ́ tɔ̃mmú, ò ndɑ́ɑ́tí ikuɔ́ yɑ̀ɑ̀tì kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Kɑ̀ɑ túótɛ́ fɛpìèfɛ̀ fɛ̀ɛ̀ bɛ̀ tɑnnìnko ikuɔ́ tɔ̃mmú fɛ mɑɑ, kɛ́ ì bèńnɛ́ dibòrì bɛ̀ tɑ̃ɑ̃tɛ́ dì dɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ ì cɑ̀ɑ́kɛ́ n tɑummɛ̀ tou kó dibòrì nɛ̀ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ ɑ̃ dɛmɔ́mbirɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Bɛɛ̀ mɑ́ɑ̀ yóó cɑ́ɑ́kɛ́ bɛ̀ dɔ̀ɔ̀nɛ̀ ìì mɑɑ nyikuɔ́ bɛ yɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́ bɛ̀ cɑ̃̀ńnɛ́ kɛ̀ bɛ̀ɛ tɑ ikuɔ́ tɔ̃mmú. Otɔù mɔù bɑ́ɑ́ ì cɑ̀ɑ́kɛ́, bɛ̀ ì cɑ̃̀ńnɛ́mu kɛ ì nni mpɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Kɛ̀ dɛ̀ wentɛ́ kɛ̀ imɑɑ nyoo pɛ̃́ɛ̃̀, kɛ̀ dɛ̀ sùɔ́ ndí dɛ̀ tùɔ, di bɑ́ɑ́ dɛ̀ cɑ̀ɑ́kɛ́. Bɛ̀ dɛ̀ cɑ̃̀nnɛ́mu kɛ dɛ̀ nni mpɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","A dɔɔ̀ Anɔɔ nɛ̀ o bí kɛ́ntũ nweti weti n dɑ nɑ̀kɛ́ tì, kɛ́ bɛ̀ tɑnnɛ́ ikuɔ́ tɔ̃mmú, ɑ yóó bɛ̀ dɔ̀ɔ̀ ìì kuɔ́ yó mmɔkɛ yɛwe yɛ̀yiekɛ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Bɑ́ dìì yiè ɑ níí kuɔ dinɑɑdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́wénkùnnɛ diwũɔ̃tɔ̀nnì, kɛ́ dì còú mmɛkùɔ̀ nkɛ́ dì cɑ̃̀ńnɛ́, kɛ̀ dì ntú n kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Á yó mmɛ ndɔɔri kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀, kɛ̀ diwũɔ̃tɔ̀nnìi wenkɛ mɛdiɛ̀, kòo nìtì yoo dɛ̀mɑrɛ̀ dì kɑ̀ɑ́kɛ́ dɛ̀ɛ kú. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Bɑ́ dìì yiè ɑ níí n féútɛ́ yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀, yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ ɑ yó mmɛ nhɔ̃ nsɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Kɛ níí féútɛ́ dìmɑrì dikṹnweńnì ditɛrì kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","Dipedɑɑ̀ ɑ yóó féútɛ́ dì dikṹnweńnì nɛ̀ kuyuoku kpɛri, ɑ níí wɑɑ́ mmuyuo ncìdóò bɛ̀tɑ̃ɑ̃ti, kɛ́ɑ̃ntɛnɛ̀ mɛkɔ̀sɑ̀ɑ̀mɛ̀ dítìrì òmɑ́ɑ̀ nɛ̀ mɛnɑɑ̀ mbɛ̀ tu mɛ̀ dìfɛ̃́ɛ̃̀, dítìrì òmɑ́ɑ̀. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Di yó nni nfeumu dɛ kó iwũɔ̃ sɑ̃́ɑ̃̀ n tɑummɛ̀ tou kó dibòrì borɛ̀ kɛ̀ n kɔ̀rìní kɛ dɑ nɑ́ɑ́nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","N níí yóó dɛ nkɔtɛní kɛ́mɑ́ɑ́nɛ̀ Isidɑyɛɛribɛ kɛ̀ n kó kuwennikuu wénkùnnɛ dɛ kó dibòrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Míì mɔ́mmuɔ nyóó wénkùnnɛ dɛ kó dibòrì kɛ́wénkùnnɛ Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ mpĩ́ nyikuɔ́ tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Mí nKuyie kɛ̀ nní ḿbo Isidɑyɛɛribɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kɛ̀ bɛ̀ɛ bɑntɛ́ míì tumɛ̀ bɛ Yiɛ̀ nKuyie nkɛ̀ míì bɛ̀ dènnɛní Esibiti, kɛ bo mbɛ̀ bonɛ̀. Míì tu bɛ Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","A dɔɔ̀nɛ̀ dɛtekperɛ̀ kó idɛí dihúúntɔ̀nnì di yó ntuɔ̀ ndìì ĩ́nkɛ̀ tihúúntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Kɛ̀ dì mmɑ di píìtì timɔu, di pɛ̃kùmɛ̀ ḿbo mɛ́tìrì kó dikéè, mɛokùmɛ̀ mɛ́tìrì kó dikéè, mɛcómmɛ̀ mɛ́tìrì omɑ́ɑ̀, kɛ́ dì ɑ̃nnɛ́ yɛbɑ̀kɛ̀ tipíìtì tinɑ̀ɑ̀ kɛ̀ yɛ̀ ntɑunɛ̀ diwũɔ̃tɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kɑ̀ɑ dì dɑ̀ri mɛsɔɔ ndi píìtì timɔu nɛ̀ di ĩ́nkɛ̀ kɛ́kpɛ̃ mmɛsɔɔ nkɛ́fitɛ́ nɛ̀ di bɑ̀kɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","kɛ́ dì ɑ̃nnɛ́ dɛsɔɔmɑ́mɑ́nnɛ̀ dɛ̀dɛ́rɛ̀ bɑ́ kùù píkù, mɛsɔɔ nkpɛ̃ ndɛ kó difũ̀ɔ̃̀. Di yóó dɛ ntɔ̃nnɛ́ ipɑ̀ɑ̀ti kɛ́ ndì tɔunɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","A cíɛ́kɛ́ dɛtekperɛ̀ kó idɛí kó ipɑ̀ɑ̀ti ìdɛ́ì kɛ́ ì dɑ̀ri mɛsɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Á dì ĩ̀ńnɛ́ kudieku kùù bɑkɛ́ní kuyɑ̀ɑ̀kù kpetí kùù fɑ̃́ɑ̃́ mɛtɑummɛ̀ tɔu ĩ́ĩ́kú kù. N níí yóó kɔtoo ikuɔ́ dieku nku kɛ̀ ti mɑ́ɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Anɔɔ níí yóó cɔ́ú ndiì wũɔ̃tɔ̀nnì ĩ́nkɛ̀ tihúúntì bɑ́ dìì kṹnweńnì, ò dɔ́ kɛ́ũtɛ́ dìì mɔ̀nnì n tɑummɛ̀ tou kó ifìtíì. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Kuyuoku kòò yóó cɔ́ú nfìtíì wèe tuɔ ntihúúntì. Di yó ntuɔ̀mmu tihúúntì n kpɛ́í nsɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Di bɑ́ ntuɔ bɑ́ tìì úúntì dɛ kó diwũɔ̃tɔ̀nnì ĩ́nkɛ̀, yoo iwũɔ̃ di n feu ì kɛ tuɔ̀, yoo yɛpɑ̃rɛ̀ tidiitì kpɛyɛ di m pɑ̃ɑ̃ nyɛ̀. Di bɑ́ m pɑ̃ mɛnɑɑ̀ nkɛ cóú ndɛ kó diwũɔ̃tɔ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Bɑ́ dìì benni Anɔɔ níí túótɛ́ fɛɔ̃̀fɛ̀ bɛ̀ fèútɛ́ fɛ̀ kɛ̀ m bo bɛ̀ cĩ̀ɛ̃́ mbɛ yɛi, fɛ kó mɛyĩ̀ĩ̀, nkɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì bɑ̀kɛ̀ kɛ́ dì wénkùnnɛ kɛ̀ dì ncɑ̃́ɑ̃́ nkɛ tú n kpɛri kɛ wenni pɑ́íí. Dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀ bɑ́ dìì benni kucɛ mɛ̀mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","Kɛ̀ mukɑ̀mmù níí bo dìì mɔ̀nnì bɑ́ wèè nìtìi yietí o ɔ̃nnì kpɛ́í, mumɔmmú mɑmù yɑ̀ɑ̀ bo di tuɔkɛní mukɑ̀mmù miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Bɑ́ wè wèè tùɔ̀kɛ bɛ̀ bo ò kɑ̀ɑ ndɛ̀ wèe yietí fɛdífɛ̀, bɛ̀ kèétɛ́ kɛ̀ fɛ̀ mɑ̀mɛ̀ n tɑummɛ̀ tou kpɛ́í. Di yóó cuɔ́ dɛ kó idíítí n kpɛ́í nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Bɛ̀ kɑ̀ɑ mbɛ̀ɛ̀ kó dimɑ̀ɑ̀ kɛ́túótɛ́ yɛbie nsipísìdɛ́ yɛmbɛ̀ kɛ́ndeètìnko, bɑ́ wè wèe yietí dɛ kó fɛdífɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Okpɑ̀ɑ̀tì nɛ̀ fɛdɑwɑnfɛ̀ bɑ́ wè wèè yietí fɛdífɛ̀ bɛ̀ kèétɛ́ kɛ̀ fɛ̀ mɑ̀mɛ̀. Okpɑ̀ɑ̀tì kɔfɛ bɑ́ɑ́ pɛ̃ɛ̃tɛ́, fɛdɑwɑnfɛ̀ kɔfɛ mɛ mbɑ́ɑ́ dóntɛ́, bɑ́ wè wèe yietí o ɔ̃nnì kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Kɑ̀ɑ cɔutɛ́ dɛ kó idíítí imɔu Isidɑyɛɛribɛ borɛ̀, ɑ́ nyì tũnninɛ̀ n tɑummɛ̀ tou. Mɛm̀mɛ n yó nyɛ̃́mɛ̀ Isidɑyɛɛribɛ kpɛ́í kɛ́nkɑ̃nkɛ́ bɛ fòmmu. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","Dɔɔ̀ disɔɔwũɔ̃̀ kó kunɑnkú, kɛ̀ ku tɑ̀rì ntú disɔɔwũɔ̃̀, kɑ̀ɑ kù ĩ̀ńnɛ́ diwũɔ̃tɔ̀nnì nɛ̀ n tou dɛ sɑku kɛ́ɑ̃nnɛ́ mɛniɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ ńniitì kɛ ɔu bɛ nɑɑ̀cɛ̀i. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Kɛ̀ dɛ̀ɛ yie nkɛ̀ bɛ̀ bɑ́ɑ́ kú bɛ̀ tɑti dìì mɔ̀nnì n tɑummɛ̀ tou kɛ bo tuɔ nyɛpɑ̃rɛ̀ diwũɔ̃tɔ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Bɛ̀ ńniitì kɛ ɔu bɛ nɑɑ̀cɛ̀i. Dɛ̀ yó ntú bɛ kó ikuɔ́ nyi sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","Wɑɑ́ ntihúúntì tìì kó kufɔ̃ɔ̃ku nɑɑti, tibotí tibotí míírì kpɛti cìdóòbɛ̀ bɛ̀nùmmù nɛ̀ sinɑmɔ́nnì kpɛti cìdóòbɛ̀ bɛ̀dɛ́bɛ̀ nɛ̀ dikéè nɛ̀ kɑnɛ́dì kpɛti cìdóòbɛ̀ bɛ̀dɛ́bɛ̀ nɛ̀ dikéè ");
INSERT INTO tbzsim_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","nɛ̀ kɑɑ́sì kpɛti cìdóòbɛ̀ bɛ̀nùmmù. Kɛ́ dɛ̀ bennɛ́ n yɛ̃ ndí dɛ̀ bennɛ́ mɛ̀ɛ̀ botí, nɛ̀ odìfíè kó mɛkùɔ̀ ndítìrìbɛ̀ bɛ̀kuɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Wèè pĩ ndɛ kó mutɔ̃mmú kòò mɛ̀ kɔɔrɛ kɛ̀ mɛ̀ ntú mɛcɑ̃́nnímɛ̀ kó ikuɔ́ kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","A yóó mɛ mmiɛtɛ́ n tou nɛ̀ n tɔu, ");
INSERT INTO tbzsim_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","nɛ̀ tɑ́bùrì nɛ̀ o kó tinɛntì, tɛfitíkɛ̀kɛ̀tɛ̀ nɛ̀ tɛ kó tinɛntì diwũɔ̃tɔ̀nnì bɛ̀ yó ntuɔ̀ ndɛ̀ tihúúntì, ");
INSERT INTO tbzsim_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","nɛ̀ diwũɔ̃tɔ̀nnì bɛ̀ yó ntuɔ̀ ndɛ̀ iwũɔ̃, nɛ̀ di kó tinɛntì, nɛ̀ disɔɔwũɔ̃̀ kó dibuu nɛ̀ di tɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Á dɛ̀ cɑ̃̀ńnɛ́ dìì mɔ̀nnì dɛ̀ ntú dɛ̀ɛ̀ wenni pɑ́íí. Dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo dɛ̀ tɔ̀ɔ́nnɛ̀ dɛ̀ ntú dɛ̀ɛ̀ wenni pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","A yóó mɛ mmíɛ́tɛ́ Anɔɔ nɛ̀ o bí kɛ́ bɛ̀ cɑ̃̀ńnɛ́ kɛ̀ bɛ̀ ntú ikuɔ́ nìùbɛ̀ kɛ́mpĩ́ n tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Á nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú dɛ kó mɛkùɔ̀ ntú ikuɔ́ kɔ̃mɛ mmɛ, bɛ̀ yó mmɛ̀ pĩ̀ńnɛ̀ ikuɔ́ tɔ̃mmú mɑ́ɑ̀ ndi sɑ̃́ɑ̃̀ nɛ̀ bɛ̀ bo mbomɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Di bɑ́ mmɛ̀ pe, òmɔù mɛ mbɑ́ɑ́ kɔɔrɛ o kɔ̃mɛ mɛ kóo botí. Mɛ̀ tu n kɔ̃mɛ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Kòò mɔù kɔɔrɛ o kɔ̃mɛ mɛ kóo botí, kòò mɔù mɛ̀ pe mbɛ̀ í cɑ̃̀ńnɛ́ wè n kuɔ́ tɔ̃mmú kpɛ́í, bɛ̀ɛ ò dènnɛ o kɔbɛ tĩ̀nnì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Wɑɑ́ ntihúúntì tìì kó kufɔ̃ɔ̃ku nɑɑti tibotí tibotí, sitodɑ́sì kpɛti, onikísì kpɛti nɛ̀ kɑdibɑnúmmù kpɛti kɛ́wɑɑ́ nhɑ̃nsɑ̃́sì kpɛti kɛ̀ ti mmɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Wèè pĩ ndɛ kó mutɔ̃mmú kòò tì kɔɔrɛnɛ̀ mukɔ́kúɔ́ kɛ̀ tì ntú n kpɛti kɛ wenni pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Kɑ̀ɑ tì nɑ̀ɑ mmuyuo mbɛ̀ yó nyɔ́ɔ́rìmù n tou, n tɔu ĩ́ĩ́kú dɛ̀, n kɔ̀rìní dɛ̀ kɛ̀ ti mɑu. Dɛ kó tihúúntì yó ntú n kpɛti nti, kɛ̀ di yɛ̃́ ti kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Òmɔù bɑ́ɑ́ kɔɔrɛ o kó tihúúntì mɛ botí. Tì yó ntú n kuɔ́ tɔ̃mmú mɑ́ɑ̀ kpɛti nti. ");
INSERT INTO tbzsim_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Kòò mɔù dɔ̀ɔ̀ ti botí kɛ bo nyo kufɔ̃ɔ̃ku, bɛ̀ɛ ò dènnɛ o kɔbɛ tĩ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","Míì tɑ̃ɑ̃tɛ́ Bɛsɑdɛdi Uuri yɑɑ̀birɛ, Urii kó dɛbirɛ, Sudɑɑ nɑɑ̀mùnkù kou. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Koò duɔ́ mmɛciì kòò bo nyɛ̃́ dɛmɔu kɛ nɔ nkɛ dɛ̀ dɔ̀ɔ̀ri. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Kòò níí bo nɑ kɛ́keutɛ́ dɛ̀ɛ̀ mu nyí bo, kɛ́ dɛ̀ dɔ̀ɔ̀nɛ̀ mɛbiɛrimɛ, nɛ̀ mɛsɔɔ nnɛ̀ disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Kòò bo nnɔ kɛ cɛ́ú yɛtɑ̃́rɛ̀ kɛ yɛ̀ dɑ̀rì, kɛ nɔ nkɛ sɔ̃́ṹ idɛí kɛ nɔ ndɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Koò yìɛ́nɛ̀ Odiyɑbu Ayisɑmɑki birɛ Dɑnni nɑɑ̀mùnkù kou nɛ̀ bɛtɔbɛ̀ n duɔ́ mbɛ̀ mɛciì. Bɛɛ̀ yó ndɔɔri mutɔ̃mmú mumɔu n dɑ duɔ́ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Mùù tu mɛtɑummɛ̀ tou kɔ̃mu, n tɑummɛ̀ tɔu, nɛ̀ di yɑ̀ɑ̀kù nɛ̀ di nɛntì ");
INSERT INTO tbzsim_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","nɛ̀ n tɑ́bùrì nɛ̀ o nɛntì, nɛ̀ tɛsɔɔfitíkɛ̀kɛ̀tɛ̀ nɛ̀ tɛ nɛntì nɛ̀ diwũɔ̃tɔ̀nnì bɛ yó ntuɔ̀ ndì tihúúntì, ");
INSERT INTO tbzsim_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","nɛ̀ bɛ̀ yó tuɔ̀ ndì iwũɔ̃ nɛ̀ di nɛntì nɛ̀ disɔɔwũɔ̃̀ kó dibuu nɛ̀ di tɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Ikuɔ́ kó tiyɑ̀ɑ̀tì Anɔɔ nɛ̀ o bí bɛ̀ yó ndɑɑti tì kɛ pĩ́ n kuɔ́ tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Mɛcɑ̃́nnímɛ̀ kó mɛkùɔ̀ nnɛ̀ mɛteniɛ n tɑummɛ̀ tou kpɛ́í. Dɛndɛ kó dimɑ̀ɑ̀ bɛ̀ yó ntũ n dɑ bɛnkɛ mɛ̀ mmɛ kɛ́ dɛ̀ dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ̀ bɛ̀ nhompu tɛom̀pùtɛ̀ yiè. Dɛ kó diyiè yó ndò ndibɛnkɛ̀rì ndì, mí nnɛ̀ díndi ti cuokɛ̀, diì yó mbɛnkú míì di tɑ̃ɑ̃tɛ́mɛ̀ kɛ̀ di bo ntú n kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Di nyɛ̃́ dɛ kó diyiè kpɛ́í nkɛ̀ dì ncɑ̃̀ɑ̃́, di níí bɑ́ɑ́ pĩ́ mmutɔ̃mmú dɛ kó diyiè. Kɛ̀ wèè pĩ mmutɔ̃mmú bɛ̀ɛ ò dènnɛ o kɔbɛ cuokɛ̀ kóò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Mutɔ̃mmú kó yɛwe bo yɛ̀kuɔ̀ ndi semɛ́nnì miɛkɛ. Diyiénnì tu n kpɛri ndi. Wèè pĩ mmutɔ̃mmú dɛ kó diyiè bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Isidɑyɛɛribɛ nyɛ̃́ tɛom̀pùtɛ̀ kó diyiè kpɛ́í, kɛ̀ dì ntú ti kó mɛtɑummɛ̀ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Dɛ kó diyiè yó ndò dibɛnkɛ̀rì ndi mí nnɛ̀ Isidɑyɛɛribɛ ti cuokɛ̀ kɛ bɛnkú n dɔ̀ɔ̀mɛ̀ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ yɛwe yɛ̀kuɔ̀ ndi kɛ om̀pɛ̀ diyiénnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi Sinɑii tɑ̃rì ĩ́nkɛ̀ kɛ́deè kóò duɔ́ ntitɑ̃́píɛ̀tì tìdɛ́tì kumɔ́mmɔnku kù wɑ̃̀ri tìì ĩ́nkɛ̀ kù kuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛ nsɔ̃́ mMɔyiisi í cɑ̃rikɛ kɛ bo cútɛ́ní ditɑ̃rì, kɛ̀ bɛ̀ɛ tíí nhAnɔɔ borɛ̀ kóò nɑ̀kɛ́ kɛ dɔ̀: Ti í yɛ̃́ tìì tùɔ̀kɛní Mɔyiisi wèè ti dènnɛní Esibiti. Tí dɔɔ̀ kuyie nkùù yó nti ní. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Kɛ̀ Anɔɔ dɔ̀: Tɔ̃tɛ́nɛ̀ di pobɛ̀ tootɔ̃rɛ nɛ̀ di bí initidɑbí nɛ̀ initipobí kpɛyɛ kɛ́ n duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kɛ̀ Isidɑyɛɛribɛ bɛmɔuu tɔ̃tɛ́ bɛ tootɔ̃rɛ kɛ́duɔ́ nhAnɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Kòo yɛ̀ yìɛ̀ nkɛ́utɛ́ kɛ̀ dɛ̀ɛ nɑɑ́ nfɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀. Kɛ̀ Isidɑyɛɛribɛɛ pĩɛ̃kɛ́ kɛ dɔ̀: Ntɛnɛ̀ ti kó kuyie nkùù ti dènnɛní Esibiti! ");
INSERT INTO tbzsim_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Kɛ̀ Anɔɔ mɑɑ́ diwũɔ̃tɔ̀nnì fɛ ììkɛ̀ kɛ́deè kɛ dɔ̀: Nɑnkɛ, ti ɑ̃nnɛ́ dibɑnni ti Yiɛ̀ nKuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Kɛ̀ dɛ̀ɛ wentɛ́ dikṹnweńnì sɛ̀ì kɛ̀ bɛ̀ɛ kuɔ iwũɔ̃ kɛ́tuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, kɛ́kuɔ itɛì mɛtɑummɛ̀ kpɛ́í, kɛ̀ bɛ̀ɛ kɑri kɛ́di kɛ́yɑ̃̀ mɛnɑɑ̀ nkɛ́ítɛ́ kɛ́nhɑu. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi ditɑ̃rì ĩ́nkɛ̀ kɛ dɔ̀: Cútɛ́ mɛcɑ̃ɑ̃, bɛnìtìbɛ̀ ɑ dènnɛní bɛ̀ Esibiti bɛ̀ dɔ̀ɔ̀ mɛyɛi ndiɛmɛ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Bɛ̀ pɑ̃̀nkɛ bútínnɛ́mu kucɛ m bɛ̀ bɛnkɛ kù. Bɛ̀ dɔ̀ɔ̀ fɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀ nfɛ kɛ ninku fɛ ììkɛ̀, kɛ fìé iwũɔ̃, kɛ nɑ́ɑ́ nkɛ tú: Isidɑyɛɛribɛ, ntɛnɛ̀ ti kó kuyie nkùù ti dènnɛní Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Dɛ kó bɛnìtìbɛ̀ to yɛɛ̀ kpeńnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Yóu kɛ̀ m miɛkɛɛ bɛ̀ yɛ̀ kɛ̀ m bɛ̀ kùɔ, kɛ́ dɑ dɔɔ̀ kubotí diɛkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Kɛ̀ Mɔyiisii bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ dɔ̀: N Yiɛ̀ bɑ nkpɛ́í mbo nte kɑ̀ɑ miɛkɛ yɛ̀ ɑ nìtìbɛ̀ ɑ bɛnkɛ bɛ̀ ɑ wɛ̃rímú nɛ̀ ɑ kpetì kɛ bɛ̀ dènnɛ Esibiti? ");
INSERT INTO tbzsim_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Kɑ̀ɑ bɛ̀ kùɔ Esibiti kɔbɛ yóó yĩ́ ɑ bɛ̀ dènnɛ nɛ̀ kɛmiɛkɛ nkɛ kɛ bo bɛ̀ kùɔ yɛtɑ̃rɛ̀ miɛkɛ kɛ́ bɛ̀ dèè, n Yiɛ̀ ḿbonkùnnɛ ɑ miɛkɛ kɛ́yóu ɑ bo bɛ̀ cɑ̀ɑ̀rɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Dentɛní ɑ tɔ̃mbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu bɛ kpɛ́í nhɑ do nɑ̀kɛ́ bɛ̀ kɛ dɔ̀: Míì bɛ́i nkɛ tú: M bo duɔ́ nkɛ̀ di botíi sṹṹ, kɛ̀ n di duɔ́ nkɛtenkɛ̀ n yɛ̃ n yóó di duɔ́ nkɛ̀, kɛ̀ dí nkɛ̀ te sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie nyóu kù bo dɔɔ̀mɛ̀ ku nìtìbɛ̀ mɛyɛi nkù nɑ mbɛ̀ dɔ̀ɔ̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Kɛ̀ Mɔyiisi ncutiní ditɑ̃rì kɛ tɔ titɑ̃́píɛ̀tì tìdɛ́tì kɛ̀ tì wɑ̃̀ri tipíìtì tidɛ́ Kuyie ntɑnnɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Kuyie nkuù do dɔ̀ɔ̀ dɛ kó titɑ̃́píɛ̀tì kɛ́ tì wɑ̃̀ri nɛ̀ ku nɔ̀ùtɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Kɛ̀ Sosuwee keè kutoweku kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: N yo dikpɑ̀nnì kó kutoweku Isidɑyɛɛribɛ kɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Kɛ̀ Mɔyiisi dɔ̀: Dɛ̀ í tú bɛ̀ nɑmɛ̀ bɛ dootitɔbɛ̀ kó kutoweku, yoo bɛ̀ dootitɔbɛ̀ bɛ̀ nɑmɛ̀ kɔku, dibɑnni kó iyiɛ nyi. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Bɛ̀ tɔ̀ɔ́nní dìì mɔ̀nnì Isidɑyɛɛribɛ kɑrì, kɛ̀ Mɔyiisii yɑ̀ fɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀ kɛ̀ bɛnìtìbɛ̀ ɑu, kòo miɛkɛɛ pɛikɛ mɛdiɛ̀ nkòo dootóo titɑ̃́píɛ̀tì ditɑ̃rì pɛ̃ri kɛ̀ tìi pɔntɛ pɔntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Kòo túótɛ́ fɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀ kɛ́cɔ́u kɛ̀ dɛ̀ nsúɔ́ nkòo dɛ̀ nɑ̀ɑ kɛ́ɑ̃nnɛ́ mɛniɛ mmiɛkɛ kɛ́ bɛ̀ duɔ́ nkɛ̀ bɛ̀ɛ yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Kòo bekɛ Anɔɔ kɛ dɔ̀: Bɛnìtìbɛ̀ dɑ dɔ̀ɔ̀ bɑ kɑ̀ɑ bɛ̀ tɑnnɛ́ mɛyɛi ndiɛmɛ̀ miɛ mmiɛkɛ? ");
INSERT INTO tbzsim_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Kɛ̀ Anɔɔ dɔ̀: N dɑ bɑ́ɑ́mmu ɑ miɛkɛ bɑ́ɑ́ pɛikɛ, ɑ yɛ̃́mu ɑ mɔ́mmuɔ mbɛ nnìtìbɛ̀ nɔnnɛ̀mɛ̀ mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bɛ̀ kɔ̀tɛní m borɛ̀ ndɛ kɛ yĩ: Ti í yɛ̃́ tìì tùɔ̀kɛní Mɔyiisi wèè ti dènnɛní Esibiti. A ti dɔɔ̀ dɛ̀ɛ̀ yó ntú ti kó kuyie nkɛ ti ni. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kɛ̀ m bɛ̀ bekɛ kɛ yĩ: Di we mmɔ̀kɛ mɛsɔɔ? Tɔ̃tɛ́nɛ̀ní di tootɔ̃rɛ kɛ́ n duɔ́. Kɛ̀ bɛ̀ n duɔ́ kɛ n yɛ̀ ɑ̃nnɛ́ muhɑ̃ɑ̃́ mmiɛkɛ kɛ̀ dɛ̀ nɑɑ́ fɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Kɛ̀ Mɔyiisii bɑntɛ́ Isidɑyɛɛribɛ dɔ́mɛ̀ mɛyɛi, kɛ̀ Anɔɔ bɛ̀ yóu kɛ̀ bɛ̀ dɔ̀ɔ̀ri bɛ̀ dɔ́mɛ̀, kɛ yɑ́úkùnnɛ bɛmɑ́ɑ̀ bɛ dootitɔbɛ̀ ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Kɛ̀ Mɔyiisii kɔtɛ kɛ́cómmú Isidɑyɛɛribɛ kɑrì ììkɛ̀ kɛ́bɛ́i nkɛ dɔ̀: Bɛ̀ɛ̀ dɔ́ ti Yiɛ̀ nKuyie mbɛ̀ɛ kɔtɛní m borɛ̀. Kɛ̀ Defii nɑɑ̀mùnkù kɔbɛɛ kɔtoo. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Kòo bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Ntɛ ti Yiɛ̀ nKuyie nyIsidɑyɛɛribɛ tũ nkù tu mù: Bɑ́ wè wèe túótɛ́ o siè kɛ̀ dí ce ndi kɑrì tipíìtì timɔu, bɑ́ wè kòo kuɔ o tebitɛ, o nɛ́po, o cĩ́ɛ̃̀tɛ̀ kou. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Kɛ̀ Defiibɛɛ yie mMɔyiisi bɛ̀ nɑ̀kɛ́ tì, kɛ́kuɔ Isidɑyɛɛribɛ sikɔupísìtɑ̃ɑ̃ti (3000). ");
INSERT INTO tbzsim_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Kɛ̀ Mɔyiisii nɑ́kɛ́ Defiibɛ kɛ dɔ̀: Di duɔ́ ndimɑ́ɑ̀ ndi yíe Kuyie ntɔ̃mmú kpɛ́í, di í yetɛ di bo kuɔ̀mɛ̀ bɑ́ di bí mɔ́mmɔnyi yoo di tebìí. Ti Yiɛ̀ nKuyie ndí dɔɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Mɔyiisii nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀: Di cɑ̀ɑ̀rɛ̀ kɛ̀ dɛ̀ dɛumu, n yóó wɛ̃tɛ kɛ́dekɛmu ditɑ̃rì ĩ́nkɛ̀ ti Yiɛ̀ nKuyie mborɛ̀, kɛ́ kù bɑ́ntɛ̀ kɛ̀ kù bo yie nkù di cĩ́ɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mɛm̀mɛ kɛ̀ Mɔyiisii wɛ̃tɛ ti Yiɛ̀ nKuyie mborɛ̀ kɛ́ kù nɑ̀kɛ́ kɛ dɔ̀: Áú! N Yiɛ̀, dɛ kó bɛnìtìbɛ̀ cɑ̀ɑ̀rɛ̀mu mɛdiɛ̀, bɛ̀ dɔ̀ɔ̀ fɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","N dɑ bɑ́ɑ́mmu cĩ́ɛ̃́ mbɛ, kɛ̀ mɛɛ̀ dɔkɛ, ɑ́ ũtɛ́ n yètìrì ɑ pɑ́tíri miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: Áɑ̀! N yóó ũtɛ́ bɛ̀ɛ̀ cɑ̀ɑ̀rɛ̀ bɛ kó yɛyètɛ̀ nyɛ m pɑ́tíri miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Kɔtɛ kɛ́niitɛ́ n nìtìbɛ̀ n yɛ̃ nhɑ́ bɛ̀ kɔ̀tɛnɛ̀ kɛ̀, n tɔ̃nnì yó ndɑ bonɛ̀mu kɛ̀ m mɔ̀nnì tùɔ̀kɛ dìì yiè m bɛ̀ potɛ́ bɛ cɑ̀ɑ̀rɛ̀mɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Kɛ̀ ti Yiɛ̀ nKuyie ḿpotɛ́ Isidɑyɛɛribɛ bɛ̀ duɔ́ nkɛ̀ Anɔɔ bɛ̀ dɔ̀ɔ̀ fɛ̀ɛ̀ sɔɔmɑ́tìnɑ̀ɑ̀fɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Ítɛ́nɛ̀ dɛborɛ̀ fɔ̃́ nnɛ̀ Isidɑyɛɛribɛ ɑ dènnɛní bɛ̀ Esibiti, kɛ̀ dí kɔtɛ kɛtenkɛ̀ n do yɛ̃ n yóó duɔ́ nkɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu nɛ̀ bɛ yɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","M bo duɔ́ n tɔ̃nnì kɛ̀ dì ndi ni kɛ bɛtì Kɑnnɑhɑ̃ɑ̃ kɔbɛ, nɛ̀ Amɔriibɛ, nɛ̀ Itiibɛ, nɛ̀ Efiibɛ nɛ̀ Pedisiibɛ nɛ̀ Sebusiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Kɛ̀ dí tɑ kɛtenkɛ̀ mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃̀ nkɛ̀, n nɛ́ í yó ndi nɛínɛ̀ m mɔ́mmuɔ, di to yɛɛ̀ kpeńnì, n yɑ̀ɑ̀ bo di kuɔ kucɛ kɛ́deè. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kɛ̀ bɛ̀ɛ keè dɛ kó tinɑ́ɑǹtì kɛ̀ bɛ̀ yɛ̀mmɛ̀ɛ cɑɑ̀rɛ̀, òmɔù tɛ̃́nkɛ í ndɑ̀ɑ́tí kɛ bo nsɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́mu Mɔyiisi kɛ dɔ̀: Nɑ́kɛ́ bɛ kɛ dɔ̀, bɛ to yɛɛ̀ kpeńnì, kɛ̀ m bɛ̀ nɛínɛ̀ n yɑ̀ɑ̀ bo bɛ̀ kùɔ kucɛ bɛmɔu dimɔ̀nnì dìmɑ́ɑ̀. Bɛ̀ɛ dɛitɛ bɛ sɑ̃tì kɛ n yɑ̀ n dò nkɛ́ bɛ̀ dɔ̀ɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kɛ̀ bɛ̀ nyiti Odɛbu bɑ́ Isidɑyɛɛribɛ tɛ̃́nkɛ í ɑ̃ bɛ sɑ̃tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Kɛ̀ bɛ̀ bɑ̀tɛ́ dɛ̀ Mɔyiisii cónnɛ́ ti Yiɛ̀ nKuyie ntɑummɛ̀ tou kɛ̀ dì nciɛ́nnɛ̀ bɛ̀ bɑ̀tɛ́ dɛ̀ mɛsɑ̀ɑ̀, kɛ̀ bɛ̀ ndì yu kɛ tú: Kuyie ntɑummɛ̀ tou. Wèè dɔ́ kɛ́bɛ́innɛ̀ Kuyie nwèe yɛ̀nní bɛ̀ bɑ̀tɛ́ dɛ̀ kɛ́kɔtɛ Kuyie ntou borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Kɛ̀ Mɔyiisi ìtɛ́ kɛ bo tɑ Kuyie ntɑummɛ̀ tou, bɑ́ wè wèe ítɛ́ kɛ́cómmú o tou bòrì kɛ̀ bɛ̀ nwúó mMɔyiisi kòò yɑ̀ɑ tɑnnɛ̀ Kuyie ntɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Kòò tɑ, diwɛtirìi kɔtɛní kɛ́kɑ̃ɑ̃́ nti Yiɛ̀ nKuyie ntɑummɛ̀ tou kó dibòrì kɛ̀ Mɔyiisi nnɑ́ɑ́nnɛ̀ Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kɛ̀ Isidɑyɛɛribɛ yɑ̀ dìì mɔ̀nnì diwɛtirì, bɑ́ wè wèe nínkú kɛ́sĩ́nnɔ́ɔ kɛtenkɛ̀ o tou bòrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Kɛ̀ ti Yiɛ̀ nKuyie nni nnɑ́ɑ́nnɛ̀ Mɔyiisi onìtì ɔ̃ nnɑ́ɑ́nnɛ̀mɛ̀ o nɛ́po. Kù dèè dìì mɔ̀nnì kɛ̀ Mɔyiisii wɛ̃tɛ bɛ̀ bɑ̀tɛ́ dɛ̀, kòo kóo tɔ̃ntì Sosuwee Nunni birɛ nkpɑɑ́ Kuyie ntou miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Kɛ̀ Mɔyiisi nɑ́kɛ́ ti Yiɛ̀ nKuyie nkɛ dɔ̀: N Yiɛ̀, fɔ̃́ɔ̃̀ yɛ̃ n niitɛ́ bɛ nnìtìbɛ̀, ɑ mɛ nyí m bɛnkɛ wèè bo n teennɛ̀. Fɔ̃́ɔ̃̀ mɛ mbɛ́i nkɛ tú: A yɛ̃́mu kɑ̀ɑ kó mɛsɑ̀ɑ̀ nni mbonɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Kɑ̀ɑ kó mɛsɑ̀ɑ̀ mɛ̀nkɛ m bonɛ̀mu, m bɛnkɛ ɑmɑ́ɑ̀ kɛ̀ n dɑ yĩ́ɛ̃́tɛ́ weti weti, kɛ́mmɔkɛ ɑ kó mɛsɑ̀ɑ̀. A nyɛ̃́ bɛ nnìtìbɛ̀ tumɛ̀ ɑ kɔbɛ mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: N kɔroomu m mɔ́mmuɔ nhɑ bɑ́ nyĩɛ̃̀kù. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Kɛ̀ Mɔyiisi dɔ̀: Kɑ̀ɑ í kɔriní ɑ mɔ́mmuɔ nhɑ bɑ́ɑ́ yóu kɛ̀ ti ítɛ́ diɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Kɑ̀ɑ í ti nɛínɛ̀ bɛ̀ bo yĩ́mɛ kɛ́bɑntɛ́ ɑ sɑ̀ɑ̀ nti bonɛ̀mɛ̀ mí nnɛ̀ ɑ kó bɛnìtìbɛ̀. A borimɛ ti cuokɛ̀ mɛɛ̀ yó nti yɑɑ̀tì tínti nɛ̀ ibotí tɛì kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: N yóó dɔɔ̀mu ɑ bɛ́i ntì, n sɑ̀ɑ̀ ndɑ bonɛ̀mu kɛ yɛ̃́ míì dɑ tɑ̃ɑ̃tɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Kɛ̀ Mɔyiisi dɔ̀: M bɛnkɛ ɑ kpetì. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: N yóó pɛ̃ɛ̃tɛ́mu ɑ borɛ̀ nɛ̀ n sɑ̀ɑ̀, n yóó dɑ nɑ́kɛ́mu n yètìrì. Nh ɔ̃ɔ̃ kuɔ́ mmɛsémmɛ̀ n dɔ́ kɛ́ mɛ̀ kuɔ́ nwènwe, kɛ́cĩ́ɛ̃́ n dɔ́ kɛ́cĩ́ɛ̃́ nwè. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Á nɛ́ í yóó yɑ̀ n yììkɛ̀, kɛ yɛ̃́ onìtì í yó n yɑ̀mɛ̀ kɛ́nfòù. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Dipèrì mɑrì bomu diɛ n tɑkɛ́, ɑ́ ncómmú di ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Kɛ̀ m pɛ̃nkɛ́ dìì mɔ̀nnì nɛ̀ n kpetì n yóó dɑ sɔnnɛ dipèrì fíè mmɛ̀ kɛ́ n dɑ kɑ̃nkɛ́ n nɔ̀ùtɛ̀ kɛ yɑ̀ɑ pɛ̃ɛ̃tɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Kɛ̀ m pɛ̃ɛ̃tɛ́ n dɛitɛ n nɔ̀ùtɛ̀ kɑ̀ɑ yɑ̀ n yĩ́nkɛ̀ kɛ yɛ̃́ onìtì í yóó nɑmɛ̀ kɛ́yɑ̀ n yììkɛ̀ kɛ́nfòù. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Cíɛ́kɛ́ titɑ̃́píɛ̀tì tìdɛ́tì kɛ̀ tì ndònnɛ̀ tiketitì ɑ pɔ̀ntɛ tì kɛ̀ n wɑ̃ri tinɑ́ɑǹtì n do wɑ̃̀ri tì tiketitì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Bɑ́ɑ́tí nɑnkɛ dikṹnweńnì kɛ́dekɛní Sinɑii tɑ̃rì kɛ́ nni mbɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Òmɔù bɑ́ɑ́ dɑ nɛinɛ̀ní, òmɔù mɛ m̀bɑ́ɑ́ dekɛ ditɑ̃rì kupíkù mɑkù. Inɑ̀ɑ̀kɛ nɛ̀ ipe mɛ m̀bɑ́ɑ́ dekɛní. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kɛ̀ Mɔyiisi cíɛ́kɛ́ titɑ̃́píɛ̀tì tìdɛ́tì kɛ̀ tì ndònnɛ̀ tiketitì. Kòo pikɛ cutɛ dikṹnweńnì sɛ̀ì kɛ́dekɛ ditɑ̃rì Sinɑii, kɛ tɔ titɑ̃́píɛ̀tì tidɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Kɛ̀ ti Yiɛ̀ nKuyie ncútɛ́ní diwɛtirì miɛkɛ kɛ́cómmú Mɔyiisi tɑkɛ́. Kɛ̀ Mɔyiisii yú ku yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Kɛ̀ ti Yiɛ̀ nKuyie mpɛ̃ɛ̃tɛ́ Mɔyiisi borɛ̀ kɛ bɛ́i nkɛ dɔ̀: Míì tu di Yiɛ̀ nKuyie nkɛ kuɔ̀ mmɛsémmɛ̀ kɛ cĩ́ɛ̃nko, kɛ m miɛkɛ boo, kɛ̀ n sɑ̀ɑ̀ ndɛu, kɛ̀ n dɔ̀ɔ̀ri m bɛ́i ntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Míì ɔ̃ɔ̃ dɔɔ̀ mɛsɑ̀ɑ̀ nhonìtì nɛ̀ o yɑɑ̀bío, tidɑpùntɔ̃ntì titɔ̃ntì tɛkɔupíítɛ̀ (1000). Nh ɔ̃ɔ̃ cĩ́ɛ̃́mmu onìtì o yɛi nnɛ̀ o cɑɑ̀rìmɛ̀ nɛ̀ o yetímɛ̀, m mɛ nhɔ̃ɔ̃ í nwúónko oyɛiwe kɛ dò nhò í cɑ̀ɑ̀rɛ̀ dɛ̀mɑrɛ̀ nh ɔ̃ɔ̃ potɛ́mu oyɛiwe nɛ̀ o yɑɑ̀bío tidɑpùntɔ̃ntì tìtɑ̃ɑ̃ti yoo tìnɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Dɛ mɔ̀nnì kɛ̀ Mɔyiisii nínkóo kɛ́bɑ́ntɛ̀ Kuyie, ");
INSERT INTO tbzsim_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","kɛ ítɛ́ní kɛ́bɛ́i nkɛ dɔ̀: N Yiɛ̀ nkɑ̀ɑ sɑ̀ɑ̀ m mɛ̀nkɛ m bonɛ̀mu n dɑ bɑ́ɑ́mmu ɑ́ nti nɛínɛ̀. N yɛ̃́mu kɛ dò mbɛ nnìtìbɛ̀ to kpeńnì, ɑ nɛ́ ti cĩ́ɛ̃́ nkɛ́ nti wúó nhɑ kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: N yóó di dɔɔ̀nɛ̀ mɛtɑummɛ̀ mmɛ. M bo dɔɔ̀ dɛ̀ ɑ nìtìbɛ̀ cuokɛ̀, dɛ̀ mu n yí buotɛ́ kɛtenkɛ̀ ĩ́nkɛ̀ yoo kubotí mɑkù miɛkɛ. Isidɑyɛɛribɛ yóó yɑ̀mu mutɔ̃mmú n yóó dɑ pĩ́nnɛ́ mù mù dɛumu. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ntũnnɛ weti weti n di nɑ́ɑ́ ntì yíe, kɛ̀ m bɛti Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Amɔriibɛ nɛ̀ Itiibɛ nɛ̀ Pedisiibɛ nɛ̀ Efiibɛ nɛ̀ Sebusiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Dí ndɑkɛ kɛ bɑ́ɑ́ tɑunnɛ̀ dimɑ́ɑ̀ dɛ kó bɛnìtìbɛ̀ bɛ̀ yɑ̀ɑ̀ bo nɑɑ́ ndidíìntɑ̃́rì di kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Dí puɔ mbɛ wũɔ̃tɔ̀rɛ̀ kɛ́u yɛtɑ̃́rɛ̀ bɛ̀ fìíkú yɛ̀ kɛ́kékɛ́ bɛ tewuó. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Di bɑ́ɑ́ fíé bɛ bɔkɛ̀, mí ndi Yiɛ̀ nKuyie n dɔ́ di ntũ mmí nwe m mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Di bɑ́ɑ́ bɛ̀ mɔ̀ɔ̀tɛnɛ̀ mɛtɑummɛ̀ mɑmɛ̀, kɛ̀ di bɛ̀ tɑunnɛ̀ bɛ̀ yóó fíému yɛbɔkɛ̀ kɛ́ di yú kɛ̀ dí wɛ̃nnɛ́ kɛ́di, ");
INSERT INTO tbzsim_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Kɛ̀ dí túókɛ́ bɛ kó bɛsɑpɑ̀mbɛ̀ kɛ́puó ndi kó bɛdɑpɑ̀mbɛ̀ kɛ̀ bɛ̀ɛ bɛ̀ tɑnnɛ́ mubɔɔféù miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Di bɑ́ mmɑ́ɑ́tí yɛmɑ́tìbɔkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Dí níí bɑɑ́ mpɛ̃́ɛ̃̀ wèè í kɔɔrɛnɛ̀ mutie mùù muuti dɛ kó dibɑnni kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀ n dì bennɛ́ yɛ̀ɛ̀ we dididɛ̀ì kóo tɑ̃̀nkù miɛkɛ di ncɑ́ɑ́ mpɛ̃́ɛ̃̀ wèè í kɔɔrɛnɛ̀ mutie mùù muuti, kɛ́ndò n di nɑ̀kɛ́mɛ̀ weè tɑ̃̀nkù miɛkɛ nkɛ di yɛ̀mɛ̀ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Di bí ìì tu Mpo i yó ntú n kɔbɛ mbɛ nɛ̀ di wũɔ̃ ketiyì ìì tu idɑɑì, inɑ̀ɑ̀kɛ nɛ̀ ipe nɛ̀ sibɔɔ́, dí ndɛ̀ nni duɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Disɑ̃mmɑrímbii didɑɑrì ketirì di níí dì cèètɛnɛ̀ dipebii didɑɑrì, kɑ̀ɑ mɛ̀ nyí yóó di cèètɛ ɑ pitɛ́ di fɔ̃̀níí kɛ́kuɔ, kɛ nni ndonnɛ̀ di bí ìì tu Mpo. Di níí bɑ́ nkɔrìní m borɛ̀ di nɔu sitetìsì. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Di níí pĩ́ mmutɔ̃mmú yɛwe yɛ̀kuɔ̀, diyiénnì yiè kɛ́om̀pɛ̀ bɑ́ mudɔ̀rìmù mɔ̀nnì, bɑ́ mudidɛ̀ì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Di níí ɑ̃nnɛ́ tidipɑ̀ntì kó dibɑnni kɛ́ɑ̃nnɛ́ dididɛ̀ì bɑnni dipɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Di nìtìbɛ̀ níí kɔtɛní m borɛ̀ dibenni miɛkɛ kucɛ mɛ̀tɑ̃ɑ̃ti, mí ndi Yiɛ̀ nKuyie nyIsidɑyɛɛribɛ tũ nkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","N yóó bɛtimu ibotí kɛ́pɛ̃kùnnɛ di tenkɛ̀, di kɔ̀tɛní dìì mɔ̀nnì m borɛ̀ dibenni miɛkɛ kucɛ mɛ̀tɑ̃ɑ̃ti, dɛ kó mɛfíè mmiɛkɛ òmɔù bɑ́ɑ́ cɔutɛ́ di tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Di bɑ́ɑ́ féútɛ́ fɛɔ̃̀fɛ̀ kɛ́wɛ̃nnɛ́nɛ̀ fɛ yĩ̀ĩ̀ mpɛ̃́ɛ̃̀ wèè í kɔɔrɛnɛ̀ mutie. Diyentɛ́bɑnni ɔ̃̀fɛ̀ kó imɑɑ mbɑ́ nkpɑɑ́ kɛ́tuɔkɛnɛ̀ dikṹnweńnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Di níí tɔní tidipɑ̀ntì mí ndi Yiɛ̀ nKuyie ncĩ́ɛ̃̀tɛ̀ nɛ̀ yɛtebɛ ketiyɛ̀. Di níí bɑ́ɑ́ bénnɛ́nɛ̀ dibɔbii di yɔ̃ miɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Kɛ̀ ti Yiɛ̀ nKuyie nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Wɑ̃ri dɛ kó tinɑ́ɑǹtì tiì tu mí nnɛ̀ fɔ̃́ nnɛ̀ Isidɑyɛɛribɛ ti kó mɛtɑummɛ̀ kũ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Kɛ̀ Mɔyiisi mbonɛ̀ ti Yiɛ̀ nKuyie nditɑ̃rì ĩ́nkɛ̀ kɛ dɔ̀ yɛwe sipísìnɑ̀ɑ̀ nɛ̀ dɛyènnɛ̀ sipísìnɑ̀ɑ̀, ò í di, ò mɛ nyí yɑ̃̀ mɛniɛ. Kɛ̀ ti Yiɛ̀ nKuyie nwɑ̃ri titɑ̃́píɛ̀tì tìdɛ́tì ĩ́nkɛ̀ ku tɑnnɔ̀ tɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Kɛ̀ Mɔyiisi ncutiní Sinɑii tɑ̃rì kɛ tɔ Kuyie ntɑnnɔ̀ kó titɑ̃́píɛ̀tì tìdɛ́tì. Bɑ́ ò í yɛ̃́ kɛ dò nho ììkɛ̀ mìɛti ò do nɑ́ɑ́nnɛ̀ mɛ̀ɛ̀ kpɛ́í nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Anɔɔ nɛ̀ Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ yɑ̀ o ììkɛ̀ mìɛtimɛ̀ kɛ́yɔtɛ bɛ̀ bo ò tɔ̀ɔ́nnɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Kɛ̀ Mɔyiisii yú Anɔɔ nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ̀ bɛ̀ɛ kɔtɛní kòo mbɛ̀ nɑ̀ɑ́nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Dɛ kó difɔ̃nkúò kɛ̀ Isidɑyɛɛribɛ bɛmɔuu kɔtɛní kòo mbɛ̀ nɑ̀ɑ́ nti Yiɛ̀ nKuyie nhò duɔ́ ntì Sinɑii tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mɔyiisi bɛ̀ nɑ̀kɛ́ dìì mɔ̀nnì kɛ dèè kɛ́kɑ̃ɑ̃́ nkuyɑ̀ɑ̀kù o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Kòò tɑti dìì mɔ̀nnì ti Yiɛ̀ nKuyie ncĩ́ɛ̃̀tɛ̀ wèe dɛitɛ kuyɑ̀ɑ̀kù. Kòò tɑ kɛ yɛ̀nní wè mbɛ̀ nɑ̀ɑ́ nKuyie nhò duɔ́ ntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Kɛ̀ Isidɑyɛɛribɛ nwúó nho ììkɛ̀ mìɛtimɛ̀. Kòò bɛ̀ nɑ̀kɛ́ kɛ dèè wèe kɑ̃ɑ̃́ nkuyɑ̀ɑ̀kù kɛ́mbɑɑnɛ̀ ò bo wɛ̃tɛ kɛ́tɑmɛ̀ ti Yiɛ̀ nKuyie mborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Kɛ̀ Mɔyiisi tíí nyIsidɑyɛɛribɛ bɛmɔu kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Ntɛnɛ̀ ti Yiɛ̀ nKuyie nni nduɔ́ ntì kɛ yɛ̃ ntí ntì tũ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Yɛwe bo yɛ̀kuɔ̀ ndi semɛ́nnì miɛkɛ mutɔ̃mmú kpɛyɛ. Diyiénnì tu tɛom̀pùtɛ̀ ntɛ, kɛ tú ti Yiɛ̀ nKuyie nkpɛri. Wèè pĩ mmutɔ̃mmú dɛ kó diyiè bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Bɑ́ kɛ̀ di borɛ̀ di bɑ́ɑ́ tɔtìnnɛ muhɑ̃ɑ̃́ ntɛom̀pùtɛ̀ yiè. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Kɛ̀ Mɔyiisii sɔɔtɛ́ kɛ́nnɑ́ɑ́ nyIsidɑyɛɛribɛ ti Yiɛ̀ nKuyie nhò duɔ́ ntì kɛ tú: ");
INSERT INTO tbzsim_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Wèè yɛ̀mmɛ̀ dɔ́ wèe pɑ̃ nyɛpɑ̃rɛ̀ ti Yiɛ̀ nKuyie nyɛbotí yɛbotí, mɛsɔɔ nyoo ntimɑ́tì pɛ́ítì yoo disɔɔwũɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","nɛ̀ mupɑ̀ɑ̀kómmú mùù dò mmɛbèrìmɛ̀ nɛ̀ mùù dò nfɛtònfɛ̀ nɛ̀ mùù dò mmɛyĩ̀ĩ̀ nnɛ̀ mupɑ̀ɑ̀konkperímù nɛ̀ tibɔcìtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","Tipedɑkɔ̃̀ntì wũɔ̃tì nɛ̀ tikɔ̃nkpetì nɛ̀ dɛtekperɛ̀ kó idɛí. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Fìtírɛ̀ kó mɛkùɔ̀ nnɛ̀ tihúúntì kɛ̀ bɛ̀ɛ kɔɔrɛnɛ̀ ikuɔ́ kó mɛkùɔ̀ nnɛ̀ tihúúntì bɛ̀ tùɔ̀ ntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Yɛtɑ̃́rɛ̀ yɛ̀ɛ̀ dò ndimɑntɔ̃nnì nɛ̀ yɛtɑ̃́sɑ̀ɑ̀yɛ̀ tɛyɛ̀ nɛ̀ dikɔutɛ́yɑɑ̀bòrì sɑ́m̀pɔ́rì nɛ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì ikuɔ́ nìùtì kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Kɛ̀ mɛciì nyɛmbɛ̀ɛ kɔtɛní bɛmɔu kɛ́dɔɔ̀ mutɔ̃mmú ti Yiɛ̀ nKuyie nyɛ̃ ntí dɔɔ̀ mù. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Mùù tu Kuyie ntou nɛ̀ di yɑ̀ɑ̀kù nɛ̀ di mɑmɑ́nnɛ̀ nɛ̀ di bòrɛ̀ kó idɛí nɛ̀ ticɑ́dɔɔti nɛ̀ yɛsɑ̃ǹkɛ̀ nɛ̀ yɛcɑubɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Kuyie ntɔu nɛ̀ di pɑ̀ɑ̀ti nɛ̀ di pòkù nɛ̀ kuyɑɑ̀kpenkpetínkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Tɑ́bùrì nɛ̀ o pɑ̀ɑ̀ti nɛ̀ o nɛntì nɛ̀ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ pɑ̃ bɛ̀ Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","Tɛfitíkɛ̀kɛ̀tɛ̀ nɛ̀ tɛ nɛntì nɛ̀ tɛ bɑkɛ nɛ̀ mɛkùɔ̀ mbɛ̀ yó ntɛ̀ tùɔ̀nnɛ̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","Diwũɔ̃tɔ̀nnì bɛ̀ yó ntuɔ̀ ndì tihúúntì nɛ̀ di pɑ̀ɑ̀ti nɛ̀ ikuɔ́ kó mɛkùɔ̀ nnɛ̀ tihúúntì bɛ̀ yó ntuɔ̀ ntì, nɛ̀ kuyɑɑ̀kpenkpetínkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Diwũɔ̃tɔ̀nnì bɛ̀ yó ntuɔ̀ ndì iwũɔ̃ nɛ̀ disɔɔwũɔ̃̀ kó tɛdìtɛ̀ nɛ̀ di kó ipɑ̀ɑ̀ti nɛ̀ di nɛntì nɛ̀ di buu nɛ̀ di tɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","Kudɑ̀nkù kó kuperí nɛ̀ ku kó yɛsɑ̃ǹkɛ̀ nɛ̀ yɛcɑubɛ nɛ̀ kudɑ̀nkù kó dibòrì kó kuyɑɑ̀kpenkpetínkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","Kuyie ntɑummɛ̀ tou nɛ̀ kuperí dɛ kó yɛsɑ̃ǹkɛ̀ nɛ̀ yɛ wɛ̃ĩ, ");
INSERT INTO tbzsim_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","nɛ̀ ikuɔ́ yɑ̀ɑ̀tì bɛ̀ bo mpĩ́nnɛ̀ tì Kuyie ncĩ́ɛ̃̀tɛ̀ mutɔ̃mmú nɛ̀ ikuɔ́ yɑ̀ɑ̀tì Anɔɔ nɛ̀ o bí bɛ̀ yó ndɑɑti tì kɛ pĩ́nnɛ̀ Kuyie ncĩ́ɛ̃̀tɛ̀ mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Kɛ̀ Isidɑyɛɛribɛ bɛmɔuu ítɛ́ Mɔyiisi borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Dɛ kó difɔ̃nkúò bɛ̀ɛ̀ kó dimɑ̀ɑ̀ yɛ̀mmɛ̀ dɔ́ bɛ̀ bo pɑ̃mɛ̀ kɛ̀ bɛ̀ ntɔuní bɛ pɑ̃rɛ̀ bɛ̀ pɑ̃ yɛ̀ ti Yiɛ̀ nKuyie, nkɛ bo dɔɔ̀nɛ̀ ku tɑummɛ̀ tou, nɛ̀ tinɛntì bɛ̀ yó mpĩ́nnɛ̀ tì ku tɔ̃mmú nɛ̀ tikɔutɛ́yɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Bɛnitidɑɑbɛ̀ nɛ̀ bɛnitipòbɛ̀ bɛ̀ɛ̀ yɛ̀mmɛ̀ dɔ́ kɛ̀ bɛ̀ ntɔuní mɛsɔɔ nkó tisɑ̃tì tibotí tibotí: Yɛtootɔ̃rɛ nɛ̀ dɛmɑ́mɑ́nnɛ̀ nɛ̀ sipɑpɑ́heú nɛ̀ mɛfĩmmɛ kɛ dɛ̀ nkù pɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Bɛ̀ɛ̀ mɔ̀kɛ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò nfɛtònfɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nɛ̀ mupɑ̀ɑ̀konkperímù nɛ̀ tibɔcìtì nɛ̀ tikɔ̃nkpetì kɛ̀ bɛ̀ ndɛ̀ tɔuní. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Kɛ̀ bɛtɔbɛ̀ tɔuní timɑ́tì pɛ́ítì nɛ̀ disɔɔwũɔ̃̀ kɛ pɑ̃ɑ̃ nti Yiɛ̀ nKuyie. Bɛ̀ɛ̀ mɔ̀kɛ dɛtekperɛ̀ kó tidɑbɛɛtì kɛ̀ bɛ̀ ntì tɔuní kɛ bo dɔɔ̀nɛ̀ Kuyie ntou. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Bɛnitipòbɛ̀ bɛ̀ɛ̀ nɔ nkɛ duɔ̀kù kɛ̀ bɛ̀ ntɔuní mupɑ̀ɑ̀konkperímù bɛ̀ dùɔ̀kù mù nɛ̀ mùù dùɔ̀kɛnɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Kɛ̀ bɛnitipòbɛ̀ tɔbɛ̀ bɛ̀ɛ̀ nɔ nkɛ duɔ̀kù tibɔcìtì kɛ̀ bɛ̀ ntì dùɔ̀kù. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Kɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ ntɔuní yɛ́tɑ̃́sɑ̀ɑ̀yɛ̀ yɛbotí yɛbotí yɛ̀ɛ̀ yóó dɑri tɛkɔutɛ́yɑɑ̀bòtɛ̀ nɛ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Kɛ tɔuní mɛkùɔ̀ mmɛ̀ɛ̀ cɔ́unkonɛ̀ fitírɛ̀ nɛ̀ ikuɔ́ kó mɛkùɔ̀ nnɛ̀ tihúúntì tìì tùɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isidɑyɛɛribɛ bɛmɔu bɛnitidɑɑbɛ̀ nɛ̀ bɛnitipòbɛ̀ bɛ̀ɛ̀ yɛ̀mmɛ̀ dɔ́, kɛ̀ bɛ̀ ntɔuní bɛ pɑ̃rɛ̀ kɛ pɑ̃ɑ̃ nti Yiɛ̀ nKuyie, kɛ̀ bɛ̀ bo dɔɔ̀nɛ̀ ku tɔ̃mmú kù tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Dɛ kó difɔ̃nkúò kɛ̀ Mɔyiisii nɑ́kɛ́ Isidɑyɛɛribɛ bɛmɔu kɛ dɔ̀: Ti Yiɛ̀ nKuyie nkuù tɑ̃ɑ̃tɛ́ Sudɑɑ nɑɑ̀mùnkù miɛkɛ Uuri kó dɛbirɛ Bɛsɑdɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Koò píɛ nku Yɑɑ́ nkoò duɔ́ mmɛciì nkòò yɛ̃́ mutɔ̃mmú mumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Kɛ ɔ̃ɔ̃ nɑ kɛ́keutɛ́ mɛciì, kɛ nɔ nkɛ mɑ́ɑ́tí mɛsɔɔ nnɛ̀ timɑ́tì pɛ́ítì nɛ̀ disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Kɛ nɔ nkɛ cɛ́ú yɛtɑ̃́sɑ̀ɑ̀yɛ̀ kɛ yɛ̀ dɑ̀rì ò yɛ̀ dɔ́nɛ̀ dɛ̀, kɛ nɔ nkɛ cɛ́ú idɛí. Ò do tú oyɑ́ntì nwe. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Kɛ̀ múnkɛ mɛ ndɔɔ̀ Dɑnni nɑɑ̀mùnkù kou Ayisɑmɑki birɛ Odiyɑbu kɛ̀ bɛ̀ nnɔ nkɛ bɛnkú bɛnìtìbɛ̀ mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Kuyie mbɛ̀ duɔ́mmu mɛciì nkɛ̀ bɛ̀ nɔ nkɛ cɛ́ú yɛtɑ̃́sɑ̀ɑ̀yɛ̀, kɛ nɔ nkɛ dɔɔri tifèntì, kɛ kpɛ̃nti mupɑ̀ɑ̀kómmú mùù dò mmɛbèrìmɛ̀, nɛ̀ mùù dò mmɛyĩ̀ĩ̀ nnɛ̀ mùù dò nfɛtònfɛ̀ nɛ̀ mupɑ̀ɑ̀konkperímù, kɛ nɔ nkɛ duɔ̀kù tiyɑ̀ɑ̀tì. Bɛ̀ do nɔmmu kɛ yɑ́ntí dɛmɔu botí. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Mɛm̀mɛ kɛ̀ Bɛtisɑdiɛdi nɛ̀ Odiyɑbu nɛ̀ bɛyɑ́ntìbɛ̀ tɔbɛ̀ ti Yiɛ̀ nKuyie nduɔ́ mbɛ̀ mɛciì nkɛ̀ bɛ̀ nɔ nkɛ yɑ́ntí, kɛ bo nɑ kɛ́dɔɔ̀ tikɔutɛ́nɛntì bɛ̀ yó mpĩ́nnɛ̀ tì ti Yiɛ̀ nKuyie n tou miɛkɛ mutɔ̃mmú kɛ́ntũ nKuyie ntì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Kɛ̀ Mɔyiisii yú Bɛtisɑdiɛdi nɛ̀ Odiyɑbu nɛ̀ bɛnìtìbɛ̀ tɔbɛ̀ ti Yiɛ̀ nKuyie nduɔ́ mbɛ̀ mɛciì nkɛ̀ bɛ̀ nɔ nkɛ yɑ́ntí, kɛ duɔ́ mbɛmɑ́ɑ̀ kɛ bo pĩ́ ndɛ kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Kòo bɛ̀ duɔ́ nyIsidɑyɛɛribɛ pɑ̃ɑ̃ nyɛ̀ɛ̀ pɑ̃rɛ̀, kɛ̀ bɛ̀ bo dɔɔ̀nɛ̀ Kuyie ntɑummɛ̀ tou. Bɑ́ dìì kṹnweńnì kɛ̀ bɛnìtìbɛ̀ bɑɑ ntɔuní bɛ pɑ̃rɛ̀ bɛ̀ pɑ̃ yɛ̀ Kuyie. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Dɛ mɔ̀nnì bɛtɔ̃mbɛ̀ bɛmɔu bɛ̀ɛ̀ duɔ́ mbɛmɑ́ɑ̀ kɛ dɔɔri Kuyie ntɑummɛ̀ tou kɛ̀ bɛ̀ɛ kṹnnɛ́ bɛ tɔ̃mmú, kɛ́kɔtɛ Mɔyiisi borɛ̀ kóò nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Bɛnìtìbɛ̀ pɑ̃mmú yɛ̀ɛ̀ pɑ̃rɛ̀ sɑ̀nnɛ̀mu kɛ pɛ̃ɛ̃tɛ́ ketíkɛ ti bo dɔɔ̀nɛ̀mɛ̀ ti Yiɛ̀ nKuyie ntɑummɛ̀ tou kù yɛ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Kɛ̀ Mɔyiisi pɑ̃̀nkɛɛ duɔ́ nkɛ̀ bɛ̀ɛ pĩɛ̃kɛ́ Isidɑyɛɛribɛ kɑrì kɛ dɔ̀: Onitidɔ̀ù yoo onitipòkù, òmɔù tɛ̃́nkɛ bɑ́ɑ́ pɑ̃ dɛ̀mɑrɛ̀ Kuyie ntou kpɛ́í. Dɛ mɔ̀nnì kɛ̀ bɛ̀ɛ yóu bɛ̀ bo mpɑ̃ɑ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Bɛ̀ do pɑ̃mu kɛ̀ dɛ̀ nsɑ̀nnɛ̀ bɛ̀ bo dɔɔ̀nɛ̀mɛ̀ ti Yiɛ̀ nKuyie ntɑummɛ̀ tou kɛ́súɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Mɛm̀mɛ kɛ̀ bɛyɑ́ntìbɛ̀ mɔ́mmɔmbɛɛ dɔɔ̀ Kuyie ntou, kɛ́duɔkɛnɛ̀ mupɑ̀ɑ̀konkperímù tiyɑɑ̀yɔ́ntì tɛpíítɛ̀ tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀, kɛ́ ti kpɛ̃ nkɛ̀ dɛ̀ ndò mbɛĩ́nkɛ̀mbɑ̀rìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Kɛ̀ ti okùmɛ̀ ḿbo mɛ́tìrì tɛpíítɛ̀ nɛ̀ mɛ̀nɑ̀ɑ̀ kɛ̀ ti pɛ̃kùmɛ̀ ḿbo mɛ́tìrì mɛ̀dɛ́mɛ̀, kɛ̀ tì mmɑ̀ timɔu tɛpíítɛ̀ tɛntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Kɛ̀ bɛ̀ɛ tì tɑu ntìnùmmù tìnùmmù, ");
INSERT INTO tbzsim_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","kɛ́cɑ́tínɛ́ tiketitì tìnùmmù mɑ̀nku iwɛ̃ĩ ìì dò mmɛbèrìmɛ̀ kɛ́ mɛ nyĩ́ titɛtì tìnùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Kɛ̀ dɛ kó iwɛ̃ĩ ḿbo sipísìnùmmù ku mpíkù nɛ̀ kutɛkù kɛ dò nyitɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Kɛ̀ bɛ̀ɛ dɔɔ̀ mɛsɔɔ nkó iyɑ́rí kɛ̀ ì ndò nyifɔ́dìnyɑ́rí ìì yó mpɛ̃ũnɛ̀ sipísìnùmmù kɛ̀ bɛ̀ɛ tɑunnɛ̀ dɛ kó tiyɑ̀ɑ̀tì kɛ̀ tìì nɑɑ́ nkùmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Dɛ kó difɔ̃nkúò kɛ́duɔkɛnɛ̀ tibɔcìtì tiyɑɑ̀yɔ́ntì tɛpíítɛ̀ nɛ̀ kùmɑ́ɑ̀, dɛ kó kuyɑɑ̀dɛ́ríkù kuù yó nkɑ̃nkɛ́ Kuyie ntou. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Kɛ̀ dɛ kó tiyɑɑ̀yɔ́ntì okùmɛ̀ ḿbo mɛ́tìrì tɛpíítɛ̀ nɛ̀ mɛ̀nùmmù kɛ̀ ti pɛ̃kùmɛ̀ ḿbo mɛ́tìrì mɛ̀dɛ́ mɛ̀dɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Kɛ̀ bɛ̀ɛ ketɛ́ kɛ́tɑu ntìnùmmù kɛ́ mɛ nyĩ́ tisɔnti tikuɔ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","kɛ́cɑ́tínnɛ́ kuyɑ̀ɑ̀kù ketikù mɑkù kù tuutɛ́nɛ̀ dɛ̀ kutɛkù iwɛ̃ĩ sipísìnùmmù, kɛ́ mɛ nyĩ́ kutɛkù, ");
INSERT INTO tbzsim_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","kɛ́dɔɔ̀ disɔɔwũɔ̃̀ kó iyɑ́rí sipísìnùmmù kɛ́sɛunnɛ̀ dɛ kó iwɛ̃ĩ kɛ̀ dɛ̀ɛ nɑɑ́ kuyɑ̀ɑ̀kù kùmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Kɛ̀ bɛ̀ɛ nukú tipekɔ̃̀ntì kɛ́ tì cɛ̃kɛ́ kɛ̀ tìi wũɔ̃tɛ́ kɛ̀ bɛ̀ɛ dɑ́tínnɛ́ Kuyie ntɑummɛ̀ tou kɛ́ nɔ́ɔ́ kukɔ̃̀nkperíkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Kɛ̀ bɛ̀ɛ deè kɛ́dɔɔ̀ nKuyie ntou nɛ̀ dɛtekperɛ̀ kó tidɑbɛɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Bɑ́ kùù dɑbɛkù kɛ̀ ku okùmɛ̀ ḿbo mɛ́tìrì mɛ̀nùmmù, mɛpɛ̃kùmɛ̀ sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Bɑ́ kùù dɑbɛkù kɛ̀ kù mmɔkɛ mɛyɑ̀ɑ̀ mmɛ̀dɛ́mɛ̀ dɛ́mɛ̀ mɛ̀ɛ̀ yóó sɛunɛ̀ timɑ́tì pɛ́ítì kó yɛcɑubɛ. Kuyie ntɑummɛ̀ tou kó tidɑbɛɛtì timɔu do mɛ ndò. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Kɛ̀ bɛ̀ɛ dɔɔ̀ tidɑbɛɛtì sipísìdɛ́ tìì yó mbo diyiè yìɛ̀ní kɛ̀ kubɑkù cɑ̃̀nku bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Kɛ̀ bɛ̀ɛ dɔɔ̀ yɛmɑ́tìcɑubɛ sipísìnɑ̀ɑ̀ tidɑbɛɛtì yó ncómmú yɛ̀ɛ̀ ĩ́nkɛ̀, bɑ́ kùù dɑbɛkù yɛcɑubɛ yɛ̀dɛ́ɛ̀ yɛtɔ̃rɛ dò mmɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Kɛ̀ bɛ̀ɛ dɔɔ̀ tidɑbɛɛtì tɛtì sipísìdɛ́ tìì yó mbo kubɑkù yoú bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Yɛmɑ́tìcɑubɛ pɛ́íyɛ̀ sipísìnɑ̀ɑ̀ bɑ́ kùù dɑbɛkù yɛcɑubɛ yɛ̀dɛ́ɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","kɛ́dɔɔ̀ tidɑbɛɛtì tìkuɔ̀ tìì yó mbo dɛ kó ditou fitímɛ̀ dɛ̀ ììkɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Kɛ̀ titɛtì ncɑ̃́ɑ̃́ nkɛ bo tìdɛ́tì tìì bo ditou kentímɛ̀ mɛfitímɛ̀ dɛ ììkɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Kɛ̀ dɛ kó tidɑbɛɛtì ndɛ́tirìnɛ̀ titɔbɛ̀ kɛ̀ dɛ̀ sɑ̀nnɛ̀ kɛ́dekoo kɛ́mɑ́ɑ́ dɛ ĩ́nkɛ̀ kɛ̀ bɛ̀ɛ tì pĩ́nnɛ́nɛ̀ mumɑ́mɑ́ɑ́. Ti do mɛ ndò ntidɛ́ ditou kentímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kɛ̀ ditou fɔ̃nkúò bíɛ́kɛ̀ mmɔkɛ tidɑbɛɛtì tìni timɑ́tì pɛ́ítì kó yɛcɑubɛ tɛpíítɛ̀ nɛ̀ yɛ̀kuɔ̀ bɑ́ kùù dɑbɛkù yɛcɑubɛ yɛ̀dɛ́ɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Kɛ̀ bɛ̀ɛ cíɛ́kɛ́ dɛtekperɛ̀ kó tidɑbɛɛtì ipɑ̀ɑ̀ti kɛ̀ ì mbo ìnùmmù bɑ́ kùù píkù, kɛ̀ ì bo mpĩ́ nKuyie ntɑummɛ̀ tou, ");
INSERT INTO tbzsim_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","itɛyì ìnùmmù kupíkù tɛkù. Itɛì ìnùmmù dɛ ììkɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Kɛ̀ dɛ cuokɛ̀ kó kupɑ̃nníi tɔ̃nnɛ́ yɛsɑ̃ǹkɛ̀ cuokɛ̀ ku mmɑ̀nku nɛ̀ kutɛkù. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Kɛ̀ bɛ̀ɛ tì dɑ̀ri timɔu mɛsɔɔ ntidɑbɛɛtì nɛ̀ ipɑ̃nní kɛ́dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ ipɑ̃nní yó ntũɔ̃̀ dɛ̀ɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Kɛ̀ bɛyɑ́ntìbɛ̀ɛ dɔɔ̀ kuyɑɑ̀kpenkpetínkù nɛ̀ mupɑ̀ɑ̀konkperímù nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀. Kɛ̀ bɛ̀ɛ kù kpɛ̃ ntifèntì kɛ̀ dɛ̀ ndò mbɛĩ́nkɛ̀mbɑ̀rìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Kɛ̀ bɛ̀ɛ cíɛ́kɛ́ dɛtekperɛ̀ kó idɛí yɛsɑ̃ǹkɛ̀ yɛ̀nɑ̀ɑ̀, kɛ́ yɛ̀ dɑ̀ri mɛsɔɔ, nkɛ́ɑ̃nnɛ́ yɛbɑ̀kɛ̀ bɛ̀ níí yóó sɑɑ nyɛ̀ kuyɑ̀ɑ̀kù, kɛ́dɔɔ̀ yɛmɑ́tìcɑubɛ nɛ̀ timɑ́tì pɛ́ítì yɛsɑ̃ǹkɛ̀ yó ncómmú yɛ̀ɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Kɛ̀ bɛ̀ɛ dɔɔ̀ kuyɑɑ̀kpenkpetínkù kùù yó nkpetí ikuɔ́ dieku kɛ́ kù kpɛ̃ mmupɑ̀ɑ̀konkperímù nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀, nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì do nfɛtònfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Dɛ kó difɔ̃nkúò kɛ́dɔɔ̀ bɑ́ dìì sɑ̃ɑ̃̀ dibɑ̀ù nɛ̀ mɛyɑ̀ɑ̀ nɛ̀ idɛí pɑ̃́mpɑ̃́nníyì, kɛ́ dɛ̀ dɑ̀ri dɛmɔu mɛsɔɔ, nkɛ́dɔɔ̀nɛ̀ disɔɔwũɔ̃̀ kó yɛcɑubɛ yɛ̀nùmmù, bɑ́ dìì sɑ̃ɑ̃̀ di kó dicɑubii. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Dɛ kó difɔ̃nkúò kɛ̀ Bɛtisɑdiɛdii dɔɔ̀ Kuyie ntɑummɛ̀ tɔu kɛ́ dì dɔ̀ɔ̀nɛ̀ dɛtekperɛ̀ kó tidɑbɛɛtì, kɛ̀ di okùmɛ̀ ḿbo mɛ́tìrì òmɑ́ɑ̀ nɛ̀ sɑ̃ntimɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù, mɛpɛ̃kùmɛ̀ sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù, di cómmɛ̀ sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Kɛ̀ bɛ̀ɛ di dɑ̀ri mɛsɔɔ ndi ĩ́nkɛ̀ nɛ̀ di miɛkɛ kɛ́ dì kpɛ̃ mmɛsɔɔ ndi ĩ́nkɛ̀ kɛ́fitɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","kɛ́dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ dɛ̀nɑ̀ɑ̀, bɑ́ kùù mɑ̀nku mùmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Kòo cíɛ́kɛ́ dɛtekperɛ̀ kó tidɑbɛɛtì ipɑ̀ɑ̀ti kɛ́ ì dɑ̀ri mɛsɔɔ, ");
INSERT INTO tbzsim_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","kɛ́ ì tɔ̃nnɛ́ di píìtì kɛ bo ndì tɔunɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Ò dèè mɛmmɛ kɛ́dɔɔ̀ tɛ pòkù nɛ̀ mɛsɔɔ mmɑ́ɑ̀ kɛ̀ ku okùmɛ̀ ḿbo mɛ́tìrì òmɑ́ɑ̀ nɛ̀ sɑ̃ntimɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù, kɛ̀ ku pɛ̃kùmɛ̀ ḿbo sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù, ");
INSERT INTO tbzsim_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","kɛ́ kù dɔɔ̀nɛ̀ mɛsɔɔ mmɑ́ɑ̀ kɛ́dɔɔ̀ tifèntì tìdɛ́tì ku ĩ́nkɛ̀ kɛ̀ tì ndò mbɛĩ́nkɛ̀mbɑ̀rìbɛ̀ kɛ cómmú mɛtɑummɛ̀ tɔu píìtì tidɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Kɛ̀ ku nfènkù ḿbo ku mpíkù kutɛkù kupíkù tɛkù, kɛ̀ tì nwɛ̃ nkɛ dì tɑunɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","kɛ cómmú kɛ wetí titɔbɛ̀, kɛ̀ ti ììkɛ̀ co ditɔu, kɛ̀ ti fìɛ̀ti dì dìɛ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Dɛ kó difɔ̃nkúò kɛ́dɔɔ̀ tɑ́bùrì nɛ̀ dɛtekperɛ̀ kó tidɑbɛɛtì, kòo okùmɛ̀ ḿbo mɛ́tìrì òmɑ́ɑ̀, mɛpɛ̃kùmɛ̀ mɛ́tìrì kó dikéè, mɛcómmɛ̀ sɑ̃ntimɛ́tìrì sipísìyiekɛ̀ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Kòo ò dɑ̀ri mɛsɔɔ nsɑ̀ɑ̀mɛ̀, kòo mmɔkɛ kukɑ̃kú kɛ́fitɛ́, kɛ̀ bɛ̀ɛ kù kpɛ̃̀ mmɛsɔɔ, ");
INSERT INTO tbzsim_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","kɛ́dɔɔ̀ kudɑbɛkù kɛ̀ kù pɛ̃kùmɛ̀ mmɑ̀nnɛ̀ tɛnɔ̀ùtɛ̀ kɔ̃mɛ kɛ́fii nyi mɑ̀nkɛ ìnɑ̀ɑ̀ kɛ́ kù kpɛ̃ mmɛsɔɔ nkɛ́fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Kòo dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ dɛ̀nɑ̀ɑ̀ kɛ́tɔ̃nnɛ́ i mɑ̀nkɛ ìnɑ̀ɑ̀ tɑ́bùrì tuutɛ́ ndɛ̀ o tɑ̀ɑ̀kɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Kɛ̀ dɛ̀ ntɔ́kɛ́nɛ̀ kudɔú bɛ̀ fìí nkù kɛ̀ bɛ̀ɛ tɔ̃nnɛ́ ipɑ̀ɑ̀ti bɛ̀ yó nhò tɔunɛ̀ ì. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Kòo cíɛ́kɛ́ dɛtekperɛ̀ kó tidɑbɛɛtì ipɑ̀ɑ̀ti, kɛ́ ì dɑ̀ri mɛsɔɔ mbɛ̀ yó ntɔunɛ̀ ì tɑ́bùrì, ");
INSERT INTO tbzsim_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","kɛ́dɔɔ̀ yɛbɔ kɛ́ĩ́nnɛ́ tɑ́bùrì ĩ́nkɛ̀ nɛ̀ ibòòkɛ nɛ̀ icuutí nɛ̀ sibúkúsí bɛ̀ níí yóó míɛ́tɛ́nɛ̀ dɛ̀. Kɛ̀ bɛ̀ɛ dɛ̀ dɔ̀ɔ̀nɛ̀ dɛmɔu mɛsɔɔ nsɑ̀ɑ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Dɛ kó difɔ̃nkúò kɛ̀ bɛ̀ɛ dɔɔ̀ tɛsɔɔfitíkɛ̀kɛ̀tɛ̀ nɛ̀ mɛsɔɔ nsɑ̀ɑ̀mɛ̀, kɛ́ tɛ̀ utɛ́ kɛ̀ tɛ̀ nwɛ̃ ntimɑ́tì tìmɑ́ɑ̀, tɛ̀ tɑ̀rì nɛ̀ tɛ bɑ̀kɛ̀ nɛ̀ tɛ tòkɛ̀ nɛ̀ tɛ kɛ̀kɛ̀ɛ nɛ̀ dɛ̀ɛ̀ dò mmutepóó. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kɛ̀ tɛ cuokɛ̀ kó kudɔú ḿbo kɛ̀ ibɑkɛ bo ku mpíkù ìtɑ̃ɑ̃ti, kutɛkù ìtɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Bɑ́ kùù bɑ̀ku kɛ̀ kù mɔ̀kɛ yɛtòkɛ̀ yɛ̀tɑ̃ɑ̃ti kɛ̀ yɛ̀ dònnɛ̀ mutie bɛ̀ tu mù ɑmɑndíè kó mupóó. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Kɛ̀ dɛ̀ cuokɛ̀ kó kudɔú mɔkɛ yɛtòkɛ̀ yɛ̀nɑ̀ɑ̀ kù tuutɛ́nɛ̀ dɛ̀ ibɑkɛ, kɛ̀ yɛ̀ dònnɛ̀ mutie bɛ̀ tu mù ɑmɑndíè mu kó mùpóó. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Dɛ kó ibɑ̀kɛ ku mpíkù ìtɑ̃ɑ̃ti kutɛkù ìtɑ̃ɑ̃ti tuutɛ́nɛ̀ dɛ̀, dɛ cuokɛ̀ kó kudɔú kɛ̀ dɛ̀ mɔ̀kɛ yɛtòkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Yɛtòkɛ̀ nɛ̀ ibɑkɛ kɛ̀ dɛ̀ wɛ̃ nkɛ tú mɛsɔɔ nsɑ̀ɑ̀mɛ̀ mɑ́ɑ̀ bɛ̀ yìɛmmɛ̀ kɛ utɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Kɛ̀ bɛ̀ɛ dɔɔ̀ sikɛ̀kɛ̀ɛ kɛ̀ sì ḿbo sìyiekɛ̀ nɛ̀ tinɛntì tɛtì: Ihɑɑkɛ́ nɛ̀ dɛ̀ɛ̀ yó nkounɛ̀ mutɑ́pɛí. Dɛmɔu kɛ̀ dɛ̀ ntú mɛsɔɔ nsɑ̀ɑ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Bɛ̀ do dɔ̀ɔ̀nɛ̀ mɛ̀ɛ̀ sɔɔ ntɛfitíkɛ̀kɛ̀tɛ̀ nɛ̀ tɛ nɛntì, mɛ cɛ̃́ɛ̃́kù do bo cìdóòbɛ̀ sipísìtɑ̃ɑ̃ti ndi, mɛsɔɔ nsɑ̀ɑ̀mɛ̀ mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Dɛ kó difɔ̃nkúò kòo dɔɔ̀ diwũɔ̃tɔ̀nnì bɛ̀ yó ntuɔ̀ ndɛ̀ tihúúntì kɛ́ dì dɔ̀ɔ̀nɛ̀ dɛtekperɛ̀ kó tidɑbɛɛtì, kɛ̀ di okùmɛ̀ ḿbo mɛ́tìrì kó dikéè, mɛpɛ̃kùmɛ̀ mɛ́tìrì kó dikéè. Dì do mɑ̀mu tipíìtì tinɑ̀ɑ̀, mɛcómmɛ̀ mɛ́tìrì òmɑ́ɑ̀. Kɛ̀ bɛ̀ɛ dì ɑ̃nnɛ́ yɛbɑ̀kɛ̀ kɛ̀ yɛ̀ ndì tɑunɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Kɛ̀ bɛ̀ɛ dì dɑ̀ri mɛsɔɔ nkɛ́fítɛ́ di píìtì timɔu, di ĩ́nkɛ̀ nɛ̀ di miɛkɛ nɛ̀ di bìɛ̀ nkɛ́ dì kpɛ̃ mmɛsɔɔ nkɛ́fítɛ́ nɛ̀ di bɑ̀kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Kɛ̀ bɛ̀ɛ dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ dɛ̀dɛ́rɛ̀ kɛ dì tɔ̃nnɛ́ di píìtì, kukɑ̃kú bɛ̀ kpɛ̃̀ nkù kó difũ̀ɔ̃̀ kɛ́ dɛ̀ tɔ̃nnɛ́ ìdɛ́ì kɛ bo ndi tɔunɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","kɛ́cíɛ́kɛ́ dɛtekperɛ̀ kó tidɑbɛɛtì ipɑ̀ɑ̀ti ìdɛ́ì kɛ́ ì dɑ̀ri mɛsɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Bɛ̀ɛ̀ dɔ̀ɔ̀ri tihúúntì kɛ̀ bɛ̀ɛ dɔɔ̀ ikuɔ́ kó mɛkùɔ̀ nnɛ̀ tihúúntì tìì fɔ̃ɔ̃ku nɑɑti bɛ̀ yó ntuɔ̀ ntì diwũɔ̃tɔ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Dɛ kó difɔ̃nkúò kɛ̀ Bɛtisɑdiɛdii dɔɔ̀ diwũɔ̃tɔ̀nnì bɛ̀ yó ntuɔ̀ ndìì ĩ́nkɛ̀ iwũɔ̃ bɛ̀ feu ì Kuyie, kɛ́ dì dɔ̀ɔ̀nɛ̀ dɛtekperɛ̀ kó tidɑbɛɛtì, kɛ̀ di okùmɛ̀ ḿbo mɛ́tìrì mɛ̀dɛ́mɛ̀ nɛ̀ dikéè, kɛ̀ di pɛ̃kùmɛ̀ mmɛ mbo, dì do mɑmu di píìtì tinɑ̀ɑ̀. Kɛ̀ di cómmɛ̀ ḿbo mɛ́tìrì òmɑ́ɑ̀ nɛ̀ dikéè. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Kɛ̀ bɛ̀ɛ dɔɔ̀ bɑ́ kùù mɑ̀nku dɛ ĩ́nkɛ̀ kɔku bɑ́ kù dibɑ̀ù kɛ̀ yɛ̀ ntɑunɛ̀ diwũɔ̃tɔ̀nnì kɛ wɛ̃ ntimɑ́tì tìmɑ́ɑ̀ kɛ̀ bɛ̀ɛ yɛ̀ dɑ̀ri disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Kòo deè kɛ́dɔɔ̀ dɛ kó titɔ̃nnɛntì tibotí tibotí: Yɛbɔ nɛ̀ tikɑ̃penti nɛ̀ yɛbɔ diɛyɛ̀ nɛ̀ simɑ́tìkũmpeé yɛnìì nkpɛsi nɛ̀ tikɑ̀dɑ̀ɑ̀buuti. Dɛmɔu kɛ̀ bɛ̀ɛ dɛ̀ dɔ̀ɔ̀nɛ̀ disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Kɛ̀ bɛ̀ɛ dɔɔ̀ disɔɔwũɔ̃̀ kó tɛdìtɛ̀ kɛ̀ tɛ̀ pɑ̃̀ńnɛ́ diwũɔ̃tɔ̀nnì cuokɛ̀, fɛkpɛ̃ntìfɛ̀ fũ̀ɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","kɛ́dɔɔ̀ dɛmɑ́mɑ́nnɛ̀ dɛ̀nɑ̀ɑ̀ kɛ́cɑ́tínnɛ́ tɛdìtɛ̀ mɑ̀nkɛ ìnɑ̀ɑ̀ bɛ̀ yó ntũɔ̃̀ dɛ̀ ipɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Kɛ̀ bɛ̀ɛ cíɛ́kɛ́ idɛí nɛ̀ dɛtekperɛ̀ kó tidɑbɛɛtì kɛ́ ì dɑ̀ri disɔɔwũɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","bɛ̀ níí yóó tɔ̃nnɛ́ ì diwũɔ̃tɔ̀nnì píìtì kɛ́nɑ kɛ́ dì tùótɛ́. Bɛ̀ do dì dɔ̀ɔ̀nɛ̀ tidɑbɛɛtì nti kɛ̀ mɛfíè nni mbo di miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Kɛ̀ bɛ̀ɛ dɔɔ̀ disɔɔwũɔ̃̀ kó dibuu nɛ̀ di kó ditɑ̀rì kɛ̀ dì ntú bɛnitipòbɛ̀ bɛ̀ɛ̀ do ɔ̃ mbo Kuyie ntou bòrì bɛ kó tɛ̀wéìtɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Dɛ kó difɔ̃nkúò kòo dɔɔ̀ kuyɑ̀ɑ̀kù nɛ̀ mupɑ̀ɑ̀konkperímù kɛ́fii nKuyie ntɑummɛ̀ tou difɔ̃nkúò kubɑkù cɑ̃̀nku bíɛ́kɛ̀. Kɛ̀ ku okùmɛ̀ ḿbo mɛ́tìrì sipísìnùmmù, ");
INSERT INTO tbzsim_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","kɛ́ kù pìtínnɛ́ ipɑ̀ɑ̀ti sipísìdɛ́ dɛ kó ipɑ̀ɑ̀ti nɛ̀ yɛcɑubɛ yɛ̀ɛ̀ ì tɔ, kɛ̀ dɛ̀ tu disɔɔwũɔ̃̀. Dɛ kó ipɑ̀ɑ̀ti kó yɛbɑ̀kɛ̀ nɛ̀ ipɑ̀ɑ̀ti ìì pɑ̃̀ḿmú kɛ̀ dɛ̀ tu timɑ́tì pɛ́ítì. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kɛ̀ kubɑkù cɑ̃̀nku bíɛ́kɛ̀ kpɛrɛ mɛ ndò. Kɛ̀ dɛ̀ okùmɛ̀ mɛ mmɑ, kɛ bɑɑ cɑ́ɑ́tí mɛɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Kɛ̀ diyiè tɑɑ̀ kɛ̀ɛ̀ bíɛ́kɛ̀ kpɛrɛ mɛ ndò, kɛ̀ dɛ kó mɛokùmɛ̀ ḿbo mɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù, kɛ̀ bɑɑ píítí mɛɛ̀ botí, kɛ̀ dɛ kó idɛí bo tɛpíítɛ̀ nɛ̀ yɛcɑubɛ tɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ dibòrì bo kùù píkù kɛ̀ ku pɛ̃kùmɛ̀ múnkɛ ḿbo mɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Dibòrì píìtì tidɛ́ bɑ́ kùù píkù kɛ̀ kuyɑ̀ɑ̀kù okùmɛ̀ ḿbo mɛ́tìrì mɛ̀yiekɛ̀ nɛ̀ dikéè. Bɑ́ kùù píkù ipɑ̀ɑ̀ti ìtɑ̃ɑ̃ti nɛ̀ yɛcɑubɛ yɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Dɛ kó kuyɑ̀ɑ̀kù kumɔu bɛ̀ fii nkù Kuyie ntɑummɛ̀ tou, kù do tú kùù dùɔ̀kɛnɛ̀ kùnku mupɑ̀ɑ̀konkperímù. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Dɛ kó idɛí kó yɛcɑubɛ do tú disɔɔwũɔ̃̀ ndi, yɛbɑ̀kɛ̀ nɛ̀ idɛí ìì pɑ̃̀ḿmú kɛ̀ dɛ̀ tu timɑ́tì pɛ́ítì kɛ tuutɛ́nɛ̀ ìì pɑ̃̀ḿmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Kɛ̀ bɛyɑ́ntìbɛ̀ɛ kpɛ̃ nkuyɑɑ̀kpenkpetínkù mupɑ̀ɑ̀konkperímù mùù dò mmɛbèrìmɛ̀ nɛ̀ mùù dò mɛyĩ̀ĩ̀ nnɛ̀ mùù dò nfɛtònfɛ̀. Kɛ̀ ku okùmɛ̀ ḿbo mɛ́tìrì tɛpíítɛ̀, mɛcómmɛ̀ mɛ́tìrì mɛ̀dɛ́mɛ̀ nɛ̀ dikéè. Kɛ̀ ku pɛ̃kùmɛ̀ mɑ̀nnɛ̀ kuyɑ̀ɑ̀kù kùù fitɛ́ Kuyie ntɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Kɛ̀ kù mpíítí yɛsɑ̃ǹkɛ̀ yɛ̀nɑ̀ɑ̀ kɛ̀ yɛ̀ còḿmú yɛcɑubɛ yɛ̀nɑ̀ɑ̀ ĩ́nkɛ̀, dɛmɔu kɛ̀ dɛ̀ tu disɔɔwũɔ̃̀, kɛ̀ yɛbɑ̀kɛ̀ tu timɑ́tì pɛ́ítì, yɛ yɑtimɛ̀, nɛ̀ idɛí ìì pɑ̃̀ḿmú kɛ ì dɑ̀ri timɑ́tì pɛ́ítì. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Idɛí bɛ̀ fii nyì Kuyie ntou nɛ̀ dɛ kó kudɑ̀nkù kɛ̀ dɛ̀ tu disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ntɛ bɛ̀ do dɔ̀ɔ̀nɛ̀ tìì nɛntì Kuyie ntɑummɛ̀ tou tì mɑ̀mɛ̀: Ikuɔ́ nɛntì do bo dìì miɛkɛ. Mɔyiisi weè do duɔ́ nkɛ̀ Kuyie nkuɔ́ nìùtì Anɔɔ birɛ Itɑmɑɑ nɛ̀ Defiibɛ kɛ̀ bɛ̀ɛ kɑɑ ndɛ kó tinɛntì. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Sudɑɑ nɑɑ̀mùnkù kou Uu yɑɑ̀birɛ Uuri kó dɛbirɛ Bɛtisɑdiɛdi, weè do pĩ́ mmutɔ̃mmú mumɔu kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo mù duɔ́mmɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Kɛ̀ Dɑnni nɑɑ̀mùnkù kou Ayisɑmɑki birɛ Odiyɑbu nhò teénnɛ̀, ò do tú oyɑ́ntì nwe kɛ nɔ nkɛ cɛ́ú idɛí, kɛ dɔɔri tifèntì, kɛ kpɛ̃ntinɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Isidɑyɛɛribɛ do pɑ̃ mɛ̀ɛ̀ sɔɔ nkó dimɑ̀ɑ̀ kɛ̀ bɛ̀ bo dɔɔ̀nɛ̀ Kuyie ntɑummɛ̀ tou mɛ̀ do bo cìdóòbɛ̀ sikɔu sìni nɛ̀ sipísìyiekɛ̀ nɛ̀ bɛ̀yiekɛ̀ (877) nɛ̀ kɑdɑ́mmù sikɔu sìtɑ̃ɑ̃ti (300) ndi. Bɛ̀ do beúnɛ̀ tɛ̀ɛ̀ biètɛ̀ tinɛntì tìì yóó dɔɔ̀nɛ̀ Kuyie ntɑummɛ̀ tou tɛ̀ do cɑ̃́ɑ̃́mmu. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Isidɑyɛɛribɛ bɛ̀ do kɑ̀ɑ mbɛ̀ kɛ̀ bɛ̀ɛ pɑ̃ timɑ́tì pɛ́ítì kɛ̀ tì mbo cìdóòbɛ̀ sikɔupísìtɑ̃ɑ̃ti nɛ̀ tɛpíítɛ̀ nɛ̀ bɛ̀yiekɛ̀ (3017) nɛ̀ kɑdɑ́mmù sikɔu sìyiekɛ̀ nɛ̀ sipísìnùmmù (750) dɛ kó tɛbiètɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Bɛnìtìbɛ̀ bɛ̀ do kɑ̀ɑ mbɛ̀ do bo sikɔupíkɔu sìkuɔ̀, nɛ̀ sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔu sìnùmmù nɛ̀ sipísìnùmmù (603550) bɛ̀ɛ̀ do mɔkɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko bɛɛ̀ do pɑ̃ sɑ́m̀pɔ́ sɑ́m̀pɔ́ kɛ̀ dɛ̀ɛ wɛ̃nnɛ́ mɛmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Kɛ̀ bɛ̀ɛ túótɛ́ cìdóòbɛ̀ sikɔupísìtɑ̃ɑ̃ti (3000) timɑ́tì pɛ́ítì kɛ́dɔɔ̀ yɛcɑubɛ tɛkɔ̀ùtɛ̀ (100) Kuyie ntɑummɛ̀ tou kó yɛsɑ̃ǹkɛ̀ kpɛ́í, nnɛ̀ kuyɑɑ̀kpenkpetínkù, dɛ miɛkɛ kɔku, bɑ́ dìì cɑubii kɛ̀ dì mmɔkɛ cìdóòbɛ̀ sipísìtɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Cìdóòbɛ̀ tɛpíítɛ̀ nɛ̀ bɛ̀yiekɛ̀ nɛ̀ dikéè bɛɛ̀ do kpɑɑ́, kɛ̀ bɛ̀ɛ tì tùótɛ́ kɛ́dɔɔ̀nɛ̀ yɛsɑ̃ǹkɛ̀ kó yɛbɑ̀kɛ̀ kɛ́dɑri yɛ yɑtimɛ̀ timɑ́tì, kɛ́ tì ndɔ̀ɔ̀nɛ̀ ipɑ̀ɑ̀ti ìì yóó pɑ̃́nnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Disɔɔwũɔ̃̀ bɛ̀ do pɑ̃ dì kɛ̀ dindi ḿbo cìdóòbɛ̀ sikɔupísìdɛ́ nɛ̀ tɛkɔ̀ùtɛ̀ nɛ̀ sipísìdɛ́ nɛ̀ bɛ̀nɑ̀ɑ̀ (2124). ");
INSERT INTO tbzsim_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Kɛ̀ bɛ̀ɛ dì tùótɛ́ kɛ́dɔɔ̀nɛ̀ Kuyie ntɑummɛ̀ tou bòrì kó yɛcɑubɛ, kɛ́ di ntùótɛ́ kɛ́dɔɔ̀nɛ̀ diwũɔ̃tɔ̀nnì, nɛ̀ tɛdìtɛ̀ nɛ̀ diwũɔ̃tɔ̀nnì nɛntì sɔnti. ");
INSERT INTO tbzsim_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Kɛ̀ bɛ̀ɛ di ndɔɔ̀nɛ̀ yɛsɑ̃ǹkɛ̀ yɛ̀ɛ̀ fitɛ́ Kuyie ntɑummɛ̀ tou kó yɛcɑubɛ nɛ̀ dibòrì kpɛyɛ dɛmɔu nɛ̀ Kuyie ntɑummɛ̀ tou kó yɛsɑ̃ǹkɛ̀ nɛ̀ yɛ̀ɛ̀ dì fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Kɛ̀ bɛ̀ɛ túótɛ́ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀, kɛ́dɔɔ̀nɛ̀ ikuɔ́ nìùtì Anɔɔ tiyɑ̀ɑ̀tì ò yó mpĩ́nnɛ̀ tì ti Yiɛ̀ nKuyie ntɑummɛ̀ tou miɛkɛ mutɔ̃mmú, kɛ̀ bɛ̀ɛ tì dɔ̀ɔ̀ kɛ́ndònnɛ̀ Kuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Kɛ̀ bɛ̀ɛ dɔɔ̀nɛ̀ dikɔutɛ́yɑɑ̀bòrì nɛ̀ mupɑ̀ɑ̀konkperímù mùù kɔkɛ́nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀, kɛ́ dì kpɛ̃̀ mmɛsɔɔ, ");
INSERT INTO tbzsim_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","kɛ́ dì detí mɛsɔɔ nkó iwɛ̃ĩ, kɛ́nkɔɔ́nnɛ̀ mupɑ̀ɑ̀konkperímù mùù dò mmɛbèrìmɛ̀ nɛ̀ mùù dò mmɛyĩ̀ĩ̀ nnɛ̀ mùù dò nfɛtònfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Kɛ̀ bɛ̀ɛ dɔɔ̀ iyɑɑ̀bòbɑɑtí ìdɛ́ì kɛ́tuutɛ́ diyɑɑ̀bòrì mɑ̀nkɛ bɛ̀ níí bo dì bɑ̀ɑ́tínɛ̀ ì. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Kɛ̀ bɛ̀ɛ dɔɔ̀ kuyɑɑ̀bomboúnkù kɛ kù nwɛ̃nnɛ́ diyɑɑ̀bòrì kɛ tɑu kɛ dò ndɛ tɔbɛ̀. Bɛ̀ do dì dɔ̀ɔ̀ kɛ̀ dì ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ mmɛ Mɔyiisi, ");
INSERT INTO tbzsim_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","kɛ́dɔɔ̀ yɛtɑ̃́sɑ̀ɑ̀yɛ̀ bɛ̀ tu yɛ̀ kɔdinɑdínnì kɛ́wɛ̃nnɛ́ kɛ́ yɛ̀ dɑ̀nnɛ nɛ̀ mɛsɔɔ yɛbɑɑyɔ, kɛ́kerí yɛ ĩ́nkɛ̀ Sɑkɔbu bí yètɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Kɛ̀ bɛ̀ɛ yɛ̀ cɑ̀tínɛ́ diyɑɑ̀bòrì kó iwɛ̃ĩ yɛbɑɑyɔ ĩ́nkɛ̀ kòò bo nyɛ̃́ Isidɑyɛɛribɛ botí tɛpíítɛ̀ nɛ̀ ìdɛ́ì kɔ̃mɛ. Bɛ̀ tũ̀nnɛ ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ mmɛ Mɔyiisi kɛ́ dɛ̀ dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Kɛ̀ bɛyɑ́ntìbɛ̀ɛ dɔɔ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì nɛ̀ mupɑ̀ɑ̀konkperímù mùù kɔkɛ́nɛ̀ tipecìtì tìì dò mmɛ̀bèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kɛ̀ bɛ̀ɛ tì pòo mmɛ̀dɛ́mɛ̀ kɛ̀ di okùmɛ̀ nɛ̀ di pɛ̃kùmɛ̀ kɛ̀ dɛ̀ mmɑ̀nnɛ̀ sɑ̃ntimɛ́tìrì sipísìdɛ́ nɛ̀ mɛ̀nùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Kɛ̀ bɛ̀ɛ dì dɑ̀ri itɑ̃́cuɔ́ ìnɑ̀ɑ̀. Kucuɔ́ ketikù kpɛyɛ, kɛ̀ diketirì ndò ntisɛ̃ũmíɛ́tì, kɛ̀ didɛ́rì ndò ntiyɑ̃pemíɛ́tì. Kɛ̀ ditɑ̃ɑ̃́nnì ndò mmɛnɔ́ɔnnúɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Kucuɔ́ dɛ́ríkù kpɛyɛ kɛ̀ diì nni ndò mmɛcũ̀mmɛ̀ kɛ̀ ditɛrì dò ǹnùúsí kɛ̀ ditɛrì dò nsɑ̀ncìrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Kucuɔ́ tɑ̃ɑ̃́nkù kpɛyɛ kɛ̀ dii nní ndò ntiwɛtì kɛ̀ ditɛrì dò mpũ̀tìpũ̀tì kɛ̀ ditɛrì dò mmɛtekɑ̃ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Kucuɔ́ nɑɑnkù kpɛyɛ kɛ̀ diì nní ndò tinɔ́bɛ́ntì kɛ̀ ditɛrì dò ntimɑntɔ̃ntì kɛ̀ ditɛrì do nditɑ̃́wũɔ̃̀ kɛ̀ bɛ̀ɛ dɑnnɛ bɑ́ dìì tɑ̃́rì mɛsɔɔ nyĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Kɛ̀ bɛ̀ɛ kerí Isidɑyɛɛri bí tɛpíítɛ̀ nɛ̀ ìdɛ́ì yètɛ̀ dɛ kó yɛtɑ̃́rɛ̀ ĩ́nkɛ̀. Bɑ́ dìì tɑ̃́rì diyètìrì dìmɑ́ɑ̀, bɛ̀ do yɛ̀ kerí bɛ̀ ɔ̃ɔ̃ kerí mɛ̀ɛ̀ botí nku onìtì cɑnnimɛ̀ tɑ̃̀mpɔ̃́ɔ̃̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kɛ̀ bɛ̀ɛ ɑ̃nnɛ́ dicĩ̀ncĩ̀nkɔ̃̀nnì mɛsɔɔfĩmmɛ mɛ̀dɛ́mɛ̀ kɛ̀ mɛ̀ ndò nyiwɛ̃ĩ, ");
INSERT INTO tbzsim_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","kɛ́dɔɔ̀ isɔɔwɛ̃ĩ ìdɛ́ì nɛ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ dɛ̀dɛ́rɛ̀ kɛ́ dɛ̀ cɑ̀tínnɛ́ diyɑɑ̀bòrì mɑ̀nkɛ dɛĩ́nkɛ̀ kpɛyi idɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Kɛ̀ bɛ̀ɛ cɑ́tínɛ́ mɛsɔɔfĩmmɛ kó iwɛ̃ĩ idɛ́ dicĩ̀ncĩ̀nkɔ̃̀nnì kó dɛmɑ́mɑ́nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Kɛ̀ bɛ̀ɛ tuutɛ́ iwɛ̃ĩ yómmɛ̀ tɛ̃mɛ̀ yɛbɑkóyɔ borɛ̀, dɛ̀ bo yiemmɛ̀ kɛ̀ tɛkɔutɛ́yɑɑ̀bòtɛ̀ níí mbo o cĩ̀ncĩ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Kɛ̀ bɛ̀ɛ dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ tɛrɛ̀ dɛ̀dɛ́rɛ̀ kɛ́cɑ́tínnɛ́ dɛ fũ̀ɔ̃̀ tɛkɔutɛ́yɑɑ̀bòtɛ̀ dɛ miɛkɛ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Kɛ̀ bɛ̀ɛ dɔɔ̀ dɛsɔɔmɑ́mɑ́nnɛ̀ tɛrɛ̀ dɛ̀dɛ́rɛ̀ kɛ́cɑ́tínnɛ́ tɛkɔutɛ́yɑɑ̀bòtɛ̀ bɑɑti fũ̀ɔ̃̀ kuyɑɑ̀bomboúnkù yɑ́ ndɛ̀ yuu. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Kɛ̀ bɛ̀ɛ dɔɔ̀ kuhɔ̃ũ kùù dò mmɛbèrìmɛ̀ kɛ́sɛu ndicĩ̀ncĩ̀nkɔ̃̀nnì kó dɛmɑ́mɑ́nnɛ̀ nɛ̀ tɛkɔutɛ́yɑɑ̀bòtɛ̀ kpɛrɛ kɛ̀ dɛ̀ ńwɛ̃ nkɛ tɑu kɛ̀ dicĩ̀ncĩ̀nkɔ̃̀nnì bɑ́ɑ́ totɛ. Bɛ̀ do dɛ̀ dɔ̀ɔ̀ kɛ̀ dɛ̀ ndònnɛ̀ ti Yiɛ̀ nKuyie ntì nɑ̀kɛ́mɛ̀ mmɛ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Kɛ̀ bɛ̀ɛ duɔkɛnɛ̀ tipecìtì tìì do mmɛbèrìmɛ̀ dikɔutɛ́yɑɑ̀bòrì tɛkɔutɛ́yɑɑ̀bòtɛ̀ yó nnɔ́nkɛ́ dìì ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","kɛ́duɔkɛ diyuu yó nyiɛ̀ dɛ̀, kɛ̀ dɛ̀ ndò nyɛ̃́kɛ́yɛ̃́kɛ́ kɛ bɑ́ɑ́ kɛ̃tɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","kɛ́kpɛ̃ ndiyɑɑ̀bòrì fũ̀ɔ̃̀ kɛ́fitɛ́ nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì dò mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀ nɛ̀ mupɑ̀ɑ̀konkperímù kɛ̀ dɛ̀ ndò nyɛtebɛ bɛ̀ tu yɛ̀ kèdènɑ́tì. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Kɛ̀ bɛ̀ɛ dɔɔ̀nɛ̀ mɛsɔɔ nsɑ̀ɑ̀mɛ̀ isɔɔdede kɛ́cɑ́tínɛ́ diyɑɑ̀bòrì fũ̀ɔ̃̀ kɛ́fitɛ́, kɛ́nsokù diɛ nkèdènɑ́tì, diɛ nfɛdedefɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Bɛ̀ do cɑ̀tínnɛ́ kèdènɑ́tìbɛ̀ nɛ̀ idedekɛ́ kɛ́soó nsoó ndɛ tɔbɛ̀ cuokɛ̀ nkɛ, kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Kɛ̀ bɛ̀ɛ yíɛ́ kɛ́duɔkɛ yɛyɑɑ̀bòrɛ̀ nɛ̀ mupɑ̀ɑ̀konkperímù Anɔɔ nɛ̀ o bí kpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","kɛ́dɔɔ̀ fɛyítoodɑ́fɛ̀ nɛ̀ mupɑ̀ɑ̀konkperímù nɛ̀ tiyɑɑ̀bomboúntì nɛ̀ ifiɛtí. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Kɛ̀ bɛ̀ɛ dɔɔ̀ kuyɑɑ̀bomboúnkù kɛ́ kù kpɛ̃ nnɛ̀ mmupɑ̀ɑ̀konkperímù mùù kɔkɛ́nɛ̀ tipecìtì tìì dò mmɛbèrìmɛ̀ nɛ̀ tìì do mmɛyĩ̀ĩ̀ nnɛ̀ tìì dò nfɛtònfɛ̀. Kɛ̀ bɛ̀ɛ dɛ̀ dɔ̀ɔ̀ kɛ̀ dɛ̀ ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Dɛ kó difɔ̃nkúò kɛ̀ bɛ̀ɛ dɔɔ̀ mɛsɔɔ nsɑ̀ɑ̀mɛ̀ kó tɛmɑ́tìpɛ̀tɛ̀, kɛ́kerí ikuɔ́ kó mɛcɑnnimɛ̀ kɛ dɔ̀: Wèè cɑ̃̀ɑ̃́ nti Yiɛ̀ nKuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Kɛ̀ bɛ̀ɛ tɛ̀ pĩ̀ńnɛ́nɛ̀ kuhɔ̃ũ kùù dò mmɛbèrìmɛ̀ o tĩ́nnì kuyɑɑ̀bomboúnkù ĩ́nkɛ̀ kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Isidɑyɛɛribɛ do tũ̀nnɛmu nweti weti tì Yiɛ̀ nKuyie nnɑ̀kɛ́ tì Mɔyiisi, kɛ́dɔɔ̀ Kuyie ntɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Bɛ̀ dèè dìì mɔ̀nnì kɛ́ dɛ̀ tɔní dɛmɔu kɛ́duɔ́ mMɔyiisi Kuyie ntɑummɛ̀ tou nɛ̀ di kó tinɛntì timɔu: Yɛsɑ̃ǹkɛ̀ nɛ̀ yɛbɑ̀kɛ̀ nɛ̀ idɛí ipɑ̃́mpɑ̃́nníyì nɛ̀ tidɑbɛɛtì nɛ̀ yɛmɑ́tìcɑubɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","Kupekɔ̃̀nkù kó kuyɑɑ̀wũɔ̃kù nɛ̀ kukɔ̃̀kperíkù, nɛ̀ kuyɑ̀ɑ̀kù kùù kpetí dɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Kuyie ntɑummɛ̀ tɔu nɛ̀ di nɛntì tìì bo di miɛkɛ nɛ̀ di pɑ̀ɑ̀ti nɛ̀ di pòkù ");
INSERT INTO tbzsim_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","nɛ̀ tɑ́bùrì nɛ̀ o nɛntì nɛ̀ pɛ̃́ɛ̃̀ bɛ̀ yó mpɑ̃ɑ̃ mbɛ̀ Kuyie nnɛ̀ dɛ kóo pɛ̃́ɛ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","Tɛsɔɔfitíkɛ̀kɛ̀tɛ̀ nɛ̀ tɛ kó sibúkúsí nɛ̀ tɛ nɛntì nɛ̀ mɛkùɔ̀ mbɛ̀ yó ntɛ̀ tùɔ̀nnɛ̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Diwũɔ̃tɔ̀nnì nɛ̀ ikuɔ́ kó mɛkùɔ̀ nnɛ̀ tihúúntì bɛ̀ yó tuɔ̀ ntì nɛ̀ kuyɑɑ̀kpenkpetínkù kùù yó nkpetí Kuyie ntɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Disɔɔwũɔ̃̀ kó diwũɔ̃tɔ̀nnì nɛ̀ di dìtɛ̀, dɛmɔu disɔɔwũɔ̃̀ nɛ̀ dɛ kó ipɑ̀ɑ̀ti nɛ̀ di nɛntì, nɛ̀ dinɑɑbuu bɛ̀ yó nniitì dì nɛ̀ di kó ditɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Nɛ̀ tiyɑ̀ɑ̀tì bɛ̀ fii ntì Kuyie ntɑummɛ̀ tou kó kudɑ̀nkù nɛ̀ dɛ kó yɛsɑ̃ǹkɛ̀, nɛ̀ dɛ kó yɛcɑubɛ, nɛ̀ kuyɑɑ̀kpenkpetínkù kùù yó nkpetí dibòrì kudɑ̀nkù kpɛri, nɛ̀ ku kó iwɛ̃ĩ nɛ̀ yɛsɑ̃ǹkɛ̀, nɛ̀ tinɛntì timɔu tìì yó mpĩ́nnɛ̀ Kuyie ntɑummɛ̀ tou miɛkɛ mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Tikɔutɛ́yɑ̀ɑ̀tì ikuɔ́ nìùbɛ̀ níí yó ndɑ́ɑ́tí tì kɛ pĩ́nnɛ̀ Kuyie ncĩ́ɛ̃̀tɛ̀ miɛkɛ mutɔ̃mmú. Nɛ̀ ikuɔ́ nìùtì diɛwè Anɔɔ nɛ̀ o bí bɛ̀ yó ndɑɑti tì kɛ pĩĩnnɛ̀ bɛ tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isidɑyɛɛribɛ do tũ̀nnɛ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ mɛ̀ mmɛ Mɔyiisi kɛ́dɔɔ̀ dɛ kó mutɔ̃mmú mumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Kɛ̀ Mɔyiisi yɑ̀ bɛ̀ dɔ̀ɔ̀mɛ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀, kɛ́ bɛ̀ pɑ̃ Kuyie nkó mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Dɛ mɔ̀nnì kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","Dibenni kóo tɑ̃̀nkù ketiwè kó diyiè ketirì yiè ɑ́ cónnɛ́ mɛtɑummɛ̀ tou, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","kɛ́ĩ́nnɛ́ mɛtɑummɛ̀ tɔu, ikuɔ́ nɛntì bo dìì miɛkɛ, ɑ dì ĩ̀ńnɛ́ kufɑ̃́ɑ̃́ mbɛ̀ í yó ndì wùó ndɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","A yóó dɛ nyĩ́nnɛ́ tɑ́bùrì, kɛ́dɑɑ́ mpɛ̃́ɛ̃̀bɛ̀ di m pɑ̃ bɛ̀, kɛ́tɔní tɛfitíkɛ̀kɛ̀tɛ̀ kɛ́cɔ́u ntɛ fìtíyì. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Kɑ̀ɑ dɛ̀ tɑnnɛ́ disɔɔhúúntɔ̀nnì di yó ntuɔ̀ ndìì ĩ́nkɛ̀ tihúúntì, kɛ́ dì ĩ̀ńnɛ́ kɛ̀ dì nwetí mɛtɑummɛ̀ tɔu. Kɑ̀ɑ núnnɛ́ kuyɑ̀ɑ̀kù kùù yó nkpetí ikuɔ́ tou kó dibòrì, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","kɛ́cónnɛ́ diwũɔ̃tɔ̀nnì di yó ntuɔ̀ ndìì ĩ́nkɛ̀ iwũɔ̃ di n feu ì, kɛ̀ dì ḿbo n tɑummɛ̀ tou bòrì ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kɑ̀ɑ ĩ́nnɛ́ dinɑɑbuu di níí yó nniitì dìì miɛkɛ ditou nɛ̀ diwũɔ̃tɔ̀nnì dɛ sɑku, kɛ́ dì píɛ mmɛniɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","A fii mɛtɑummɛ̀ tou tiyɑ̀ɑ̀tì kɛ́ɑ̃nnɛ́ dibòrì kɛ́ di kpetínnɛ́ kuyɑ̀ɑ̀kù. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Kɑ̀ɑ dèè mɛmmɛ ɑ́ túótɛ́ mɛkùɔ̀ nkɛ́yɔɔrɛ mɛtɑummɛ̀ tou ĩ́nkɛ̀ nɛ̀ tinɛntì tìì kó dimɑ̀ɑ̀ bo di miɛkɛ kɛ́ tì cɑ̃̀ńnɛ́, kɛ̀ tìì wenkɛ, kɛ́nwenni. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","A múnkɛɛ yɔɔrɛ mɛkùɔ̀ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, kɛ́ dì cɑ̃̀ńnɛ́ kɛ́ dì wénkùnnɛ, kɛ̀ dì ntú dìì wenni pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Nɛ̀ mɛɛ̀ kùɔ̀ mmɑ́ɑ̀ ndi ɑ yóó wénkùnnɛmɛ̀ dinɑɑbuu nɛ̀ di kó ditɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Kɑ̀ɑ dèè mɛmmɛ ɑ́ yú Anɔɔ nɛ̀ o bí kɛ́ bɛ̀ kɔ̀tɛnɛ̀ mɛtɑummɛ̀ tou bòrì kɛ́ bɛ̀ wùɔ, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","kɛ́dɑ́tínnɛ́ Anɔɔ ikuɔ́ yɑ̀ɑ̀tì, kóò cɑ̃̀ńnɛ́ kòo ntú ikuɔ́ nìùtì kɛ pĩ́ n tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Kɑ̀ɑ duɔ́ nkɛ̀ Anɔɔ bíí tɔ́ɔ́nní kɑ̀ɑ bɛ̀ dɑ̀tínnɛ́ sikɔutɛ́yɑɑ̀bòo, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","kɛ́ bɛ̀ còú mmɛkùɔ̀ nkɛ́ bɛ̀ cɑ̃̀ńnɛ́ ɑ dɔ̀ɔ̀mɛ̀ bɛ cicɛ, kɛ̀ bɛ̀ ntú ikuɔ́ nìùbɛ̀ kɛ́mpĩ́ n tɔ̃mmú. A yóó bɛ̀ còú mmɛ̀ɛ̀ kùɔ̀, mmɛɛ̀ yó nte bɛmbɛ nɛ̀ bɛ yɑɑ̀bío kɛ̀ bɛ̀ ncɑ̃́ɑ̃́ kɛ tú ikuɔ́ nìùbɛ̀ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Kɛ̀ Mɔyiisi dɔɔ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì weti weti. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kɛ̀ bɛ̀ɛ cónnɛ́ Kuyie ntɑummɛ̀ tou dibenni dɛ́rì kóo tɑ̃̀nkù ketiwè diyiè ketirì nɛ̀ bɛ̀ yɛ̀mɛ̀ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Kɛ̀ Mɔyiisi fíí nyɛcɑubɛ nɛ̀ tidɑbɛɛtì nɛ̀ idɛí pɑ̃́mpɑ̃́nníyì nɛ̀ dɛ kó yɛsɑ̃ǹkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","kɛ̀ bɛ̀ɛ dì dɑ̀tínnɛ́ kuyɑ̀ɑ̀kù kɛ́nɔ́ɔ́ nkutɛkù kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Kɛ̀ Mɔyiisi túótɛ́ Kuyie ntɑnnɔ̀ tɛpíítɛ̀ wɑ̃̀ri tìì tɑ̃́píɛ̀tì ĩ́nkɛ̀ kɛ́ɑ̃nnɛ́ ku tɑummɛ̀ tɔu miɛkɛ kɛ̀ bɛ̀ɛ tɔ̃nnɛ́ ipɑ̀ɑ̀ti, kɛ́ dì pòo ndi pòkù, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","kɛ́ dì tɑnnɛ́ ti Yiɛ̀ nKuyie ntɑummɛ̀ tou miɛkɛ, kɛ́kpetínnɛ́ kuyɑ̀ɑ̀kù kɛ̀ bɛnìtìbɛ̀ bɑ́ ndì yɑ̀u, Kuyie ndo tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Kòo tɑnnɛ́ tɑ́bùrì dɛ miɛkɛ, kóò ĩ̀ńnɛ́ kubɑkù yoú bíɛ́kɛ̀ kɛ́pɛ́ɛ́nnɛ̀ kuyɑ̀ɑ̀kù kùù kpetí dibòrì, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","kɛ́dɑɑ́ ndɛ ĩ́nkɛ̀ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ pɑ̃ bɛ̀ ti Yiɛ̀ nKuyie, kù do tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Kòo tɑnnɛ́ tɛfitíkɛ̀kɛ̀tɛ̀ Kuyie ntou miɛkɛ, kɛ́ĩ́nnɛ́ kubɑkù cɑ̃̀nku bíɛ́kɛ̀ kɛ́wetínnɛ́ tɑ́bùrì, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","kɛ́tuɔ ntɛ fìtíyì ti Yiɛ̀ nKuyie nyììkɛ̀, kɛ́ndònnɛ̀ kù tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Kòo ĩ́nnɛ́ disɔɔhúúntɔ̀nnì dɛ miɛkɛ kɛ́wetínnɛ́ kuyɑ̀ɑ̀kù kùù kpetí dibòrì, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","kɛ́cɔ́u ntihúúntì dɛ ĩ́nkɛ̀, Kuyie tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Kòo núnnɛ́ kuyɑ̀ɑ̀kù dibòrì kɔku, ");
INSERT INTO tbzsim_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","kɛ́cónnɛ́ diwũɔ̃tɔ̀nnì bɛ̀ yó ntuɔ̀ ndìì ĩ́nkɛ̀ ti Yiɛ̀ nKuyie nyiwũɔ̃ kɛ̀ dì ntɔ́kɛ́nɛ̀ dibòrì, kɛ̀ bɛ̀ɛ féútɛ́ Kuyie nfɛɔ̃̀fɛ̀ kɛ́tuɔ nkɛ́ kù pɑ̃nɛ̀ yɛpɑ̃rɛ̀ tɛyɛ̀. Kù do tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Kòo ĩ́nnɛ́ dinɑɑbuu diwũɔ̃tɔ̀nnì nɛ̀ Kuyie ntɑummɛ̀ tou dɛ sɑku, kɛ́ dì píɛ mmɛniɛ nkɛ̀ bɛ̀ bo nhɔunɛ̀ bɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mɔyiisi nɛ̀ Anɔɔ nɛ̀ o bí bɛ̀ do mɛ nniitìnɛ̀ kɛ mɛ nhɔunɛ̀ bɛ nɑɑ̀cɛ̀i. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Bɛ̀ do ɔ̃ɔ̃ mɛ nhɔ́únɛ̀ bɛmɑ́ɑ̀ bɛ̀ tɑti dìì mɔ̀nnì ti Yiɛ̀ nKuyie ntɑummɛ̀ tou, yoo bɛ̀ dɔ́ kɛ́tɔ́ɔ́nnɛ̀ dìì mɔ̀nnì diwũɔ̃tɔ̀nnì. Kuyie ndo mɛ ntì nɑ̀kɛ́ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Kɛ̀ Mɔyiisii fíí nyidɛí Kuyie ntɑummɛ̀ tou nɛ̀ dihúúntɔ̀nnì kɛ́kpetínnɛ́ kudɑ̀nkù kó dibòrì kuyɑ̀ɑ̀kù. Ò do mɛ ndèè o tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Dɛ mɔ̀nnì kɛ̀ diwɛtirìi kɔtɛní kɛ́dɑ́tínnɛ́ ti Yiɛ̀ nKuyie ntɑummɛ̀ tou kɛ̀ ku diɛtìi dì píɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mɔyiisi í nnɑ kɛ bo tɑ ti Yiɛ̀ nKuyie ntɑummɛ̀ tou miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Kɛ̀ diwɛtirì ìtɛ́, bɛ̀ɛ ítɛ́, bɛ̀ do mɛ nhɔ̃ mbɛ cèmmu mumɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Kɛ̀ diwɛtirì í nɑmpɛ bɛ̀ bɑ́ɑ́ ítɛ́ bɛ̀ mbɑɑ̀ dì bo ítɛ́ dìì yiè. ");
INSERT INTO tbzsim_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kɛ̀ dì níí ndɑ́ɑ́tí ti Yiɛ̀ nKuyie ntɑummɛ̀ tou kuyie mmɔ̀nnì, kɛyènkɛ̀ kɛ́ndò ndihɑ̃ɑ̃tĩnni, bɛ cèmmu mumɔu miɛkɛ. Bɛ̀ do ɔ̃ nkɛ̀ bɛ̀ bɑ̀tɛ́ dɛ̀, dɛ̀ mmɛ ndò. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Ti Yiɛ̀ nKuyie ndo yúo Mɔyiisi ku tɑummɛ̀ tou borɛ̀ ndɛ kóò nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","Á nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀ mí ndi Yiɛ̀ nKuyie n tú: Kɛ̀ di kóò mɔù dɔ́ kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀, fɛ̀ bo nɑ kɛ́ntú fɛdiɛfɛ̀ yoo fɛsɑ́m̀pɔ́fɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kɛ̀ wèè dɔ́ kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́tuɔ, fɛ̀ ntú fɛdɑɑfɛ̀ kɛ́nkpɑ kuyɛ̀nkù, kòo fɛ̀ kùɔ mɛtɑummɛ̀ tou bòrìnùù kɛ̀ n cɔutɛ́ o pɑ̃nnì. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Wèe dɑɑ́ nho nɔ̀ùtɛ̀ fɛ yuu kɛ́ fɛ̀ nni nféútɛ́ kɛ́tuɔ kɛ̀ n cɔutɛ́ o pɑ̃nnì kóò cĩ̀ɛ̃́ nho yɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Dɛ kó difɔ̃nkúò kòo n féútɛ́ o ɔ̃̀fɛ̀ mɛtɑummɛ̀ tou ììkɛ̀ kɛ̀ ikuɔ́ nìùbɛ̀ Anɔɔ bíi míɛ́tɛ́ mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì dìì bo mɛtɑummɛ̀ tou bòrìnùù kɛ́fitɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","kɛ́ fɛ̀ fɛ̃̀tɛ́ kɛ́kékɛ́ fɛ tùòti. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Kɛ̀ ikuɔ́ nìùbɛ̀ Anɔɔ bíi tɔtìnnɛ muhɑ̃ɑ̃́ ndiwũɔ̃tɔ̀nnì kɛ́tií nyidɛí, ");
INSERT INTO tbzsim_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","kɛ́túótɛ́ itùòti nɛ̀ diyuu nɛ̀ mɛkùɔ̀ nkpɛrɛ kɛ́dɑɑ́ ndiwũɔ̃tɔ̀nnì muhɑ̃ɑ̃́ ǹyĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","kɛ́hɔ́útɛ́ tinɑutì nɛ̀ yɛkpɑ́ɑ̀ nkɛ̀ ikuɔ́ nìùtìi dɛ tuɔ ndɛmɔu diwũɔ̃tɔ̀nnì ĩ́nkɛ̀. Dɛ kó fɛɔ̃̀fɛ̀ yóó tuɔmmu kɛ́ntú dipɑ̃nnì dìì kó kufɔ̃ɔ̃ku n nɑɑti mí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Kòò mɔù mɛ ndɔ́ kɛ́féútɛ́ fɛpìèfɛ̀ yoo tɛbuɔtɛ̀ kɛ́ m pɑ̃ kɛ́tuɔ ndɛ̀ ntú dɛdɑɑrɛ̀ kɛ́nkpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Kòò dɛ̀ nni n féútɛ́ diwũɔ̃tɔ̀nnì bɑkù cɑ̃̀nku bíɛ́kɛ̀ mɛtɑummɛ̀ tou bòrìnùù, kɛ̀ ikuɔ́ nìùbɛ̀ Anɔɔ bíi míɛ́tɛ́ mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì kɛ́fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Kòo kékɛ́ fɛ tùòti kɛ̀ ikuɔ́ nìùtìi ì dɑɑ́ ndiwũɔ̃tɔ̀nnì muhɑ̃ɑ̃́ ǹyĩ́nkɛ̀ nɛ̀ diyuu nɛ̀ mɛkùɔ̀ nkpɛrɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","kɛ́ɔ́útɛ́ tinɑutì nɛ̀ yɛkpɑ́ɑ̀ nkɛ̀ ikuɔ́ nìùtìi dɛ̀ nni mbɛnkɛ kɛ̀ dí dɛ̀ tùɔ ndɛmɔu diwũɔ̃tɔ̀nnì ĩ́nkɛ̀. Dɛ kó fɛɔ̃̀fɛ̀ yóó tuɔmmu kɛ́ntú dipɑ̃nnì dìì kó kufɔ̃ɔ̃ku n nɑɑti mí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Kòò mɔù mɛ ndɔ́ kɛ́kuɔ tɛnɔ̀tɛ̀ kɛ́ m pɑ̃ kɛ́tuɔ, wèe tɔní tɛnɔ́nkpetɛ yoo dikpɛtinɔ́nkperi. ");
INSERT INTO tbzsim_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Kɛ̀ ikuɔ́ nìùtìi tɛ̀ kɔ̀tɛnɛ̀ diwũɔ̃tɔ̀nnì borɛ̀ kɛ́yĩ́ṹtɛ́ tɛ fɔ̃̀níí kɛ́tɔ̃tɛ tɛ yuu kɛ́ dì tùɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, kɛ́dɛitɛ tɛ yĩ̀ĩ̀ nkɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì píkù, ");
INSERT INTO tbzsim_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","kɛ́dɛitɛ tɛ bòtìrì nɛ̀ tɛ cìtì, kɛ́ dɛ̀ ùtóo diwũɔ̃tɔ̀nnì píkù diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ bɛ̀ uutoo dɛ̀ mutɑ́pɛí mmɛkùɔ̀ nkɔ̃mu, ");
INSERT INTO tbzsim_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","kɛ́yɑtɛ́ tɛnɔ̀tɛ̀ tɛ fìɛ̀ti sɑku, kɛ́yóu kɛ̀ dɛ̀ nkpɑɑ́ cɑ́ɑ́tí kòo tɛ̀ tùɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, tɛ̀ yóó tuɔmmu kɛ́ntú dipɑ̃nnì dìì fɔ̃ɔ̃ku n nɑɑti mí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Kòò mɔù dɔ́ kɛ́ m pɑ̃ tidiitì tì ntú tisɑ̀ɑ̀tì, kòò tì nɑ̀ɑ nkɛ́yɔɔrɛ mɛkùɔ̀ nkɛ́cɔ̃nnɛ́ tihúúntì, ");
INSERT INTO tbzsim_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","kɛ́tɔní dɛ kó muyuo nkɛ́duɔ́ nyikuɔ́ nìùbɛ̀ Anɔɔ bí, kɛ̀ bɛ̀ɛ yɛ̃tɛ́ dɛ kó muyuo mmùù mɛ nkɔkɛ́nɛ̀ mɛkùɔ̀ nkɛ́yóótɛ́ tihúúntì timɔu dɛ ĩ́nkɛ̀ kɛ́tuɔ nkɛ̀ dɛ̀ɛ bɛnkɛ kɛ dò ndipɑ̃nnì dimɔu tú n kpɛri. Dɛ kó dipɑ̃nnì yóó tuɔmmu kɛ́ntú dipɑ̃nnì dìì fɔ̃ɔ̃ku n nɑɑti mí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Dɛ kó muyuo mmùù sùɔ́, mmù yó ntú Anɔɔ nɛ̀ o bí bɛ̀ kɔ̃mu mmu kɛ yɛ̃́ bɛ̀ mù nni mpɑ̃mɛ̀ mu kɛ̀ mù cɑ̃̀ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","Kɛ̀ wèè dɔ́ kɛ́ m pɑ̃ tidiitì kó dipɑ̃nnì, kòò dɔ́ kɛ́pṹnnɛ́mu dɛ kó tidiitì wèe ɑ̃ntɛnɛ̀ dɛ kó muyuo nsɑ̀ɑ̀mù nɛ̀ mɛkùɔ̀ nkɛ bɑ́ɑ́ ɑ̃nnɛ́ mutie mùù muuti pɛ̃́ɛ̃̀, kɛ́pṹnnɛ́ dɛ kó mudiì kɛ́wɑɑrɛ mɛkùɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kɛ̀ kupɛ̃́mpɛ̃ńkù mɛ nni nku, wèe ɑ̃ntɛnɛ̀ muyuo nsɑ̀ɑ̀mù nɛ̀ mɛkùɔ̀ mmɑ́ɑ̀, kɛ bɑ́ɑ́ ɑ̃nnɛ́ mutie mùù muuti pɛ̃́ɛ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","kɛ́ kù wɛ̀rí kɛ́yɔɔrɛ mɛkùɔ̀ nku ĩ́nkɛ̀. Tidiitì kó dipɑ̃nnì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kɛ̀ wèè dɔ́ kɛ́ m pɑ̃ tidiitì kó dipɑ̃nnì, kòò dɔ́ kɛ́ tì cìemmu wèe ɑ̃ntɛnɛ̀ mɛkùɔ̀ ndɛ kó muyuo. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Wèè mɛ ndɔ́ kɛ́ m pɑ̃ dɛ kó dipɑ̃nnì, kòò dì tũ̀ntɛ kɛ dèè wèe tɔní kɛ́duɔ́ nyikuɔ́ nìùtì kòò dì kɔ̀tɛnɛ̀ diwũɔ̃tɔ̀nnì borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Dɛ kó dipɑ̃nnì miɛkɛ nkɛ, ikuɔ́ nìùtì yóó yɛ̃tɛ́mɛ̀ kɛ́tuɔ, nkɛ̀ dɛ̀ɛ bɛnkɛ kɛ dò ndipɑ̃nnì dimɔu tú n kpɛri. Dɛ kó dipɑ̃nnì yó ntú dìì tùɔ dìndi dìì kó kufɔ̃ɔ̃ku n nɑɑti mí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Dɛ kó muyuo mmùù sùɔ́ mmù yó ntú Anɔɔ nɛ̀ o bí bɛmɑ́ɑ̀ kɔ̃mu mmu, kɛ yɛ̃́ bɛ̀ mù nni mpɑ̃mɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Di yóó m pɑ̃ tìì diitì kó dimɑ̀ɑ̀ tì níí bɑ́ nkɔkɛ́nɛ̀ mutie mùù muuti pɛ̃́ɛ̃̀, di bɑ́ɑ́ tì kɔɔrɛnɛ̀ mutie mùù muuti yoo mɛcekùɔ̀ nkɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Di bo nɑ kɛ́ m pɑ̃ di pɑɑ nkó tidiketitì, tì nɛ́ bɑ́ ntú tìì yóó tuɔ ntìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Di níí ɑ̃nnɛ́ mukɔ́kúɔ́ nyɛpɑ̃rɛ̀ yɛmɔu di yóó nní mpɑ̃ɑ̃ nyɛ̀, di níí bɑ́ɑ́ yóu di bo ɑ̃nnɛ́mɛ̀ mukɔ́kúɔ́ nyɛpɑ̃rɛ̀ yɛmɔu yɛ̀ɛ̀ tu tidiitì. Mukɔ́kúɔ́ mbɛnkú mɛtɑummɛ̀ n di dɔ̀ɔ̀nɛ̀ mɛ̀ yó mbomɛ̀ mmɛ sɑ̃́ɑ̃̀. Yɛpɑ̃rɛ̀ yɛmɔu di m pɑ̃ɑ̃ nyɛ̀ níí nhɑ̃ mukɔ́kúɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Kɛ̀ di yóó m pɑ̃ di pɑɑ nkó tidiketitì dí tì pũ̀ńnɛ́ kɛ́ũntɛ́ kɛ́puɔ mbɑ́ di bɑ́ɑ́ fṹṹtí, ");
INSERT INTO tbzsim_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","kɛ́yɔɔrɛ mɛkùɔ̀ nkɛ́cɔ̃nnɛ́ tihúúntì. Tidiitì kó dipɑ̃nnì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kɛ̀ ikuɔ́ nìùtìi yɛ̃tɛ́ dɛ kó muyuo mmùù mɛ nkɔkɛ́nɛ̀ mɛkùɔ̀ nkɛ́yóótɛ́ tihúúntì timɔu dɛ ĩ́nkɛ̀ kɛ́tuɔ, nkɛ̀ dɛ̀ɛ bɛnkɛ kɛ dò ndipɑ̃nnì dimɔu tú n kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nni nsɔkɛ́ ku nɑ́ɑǹtì kɛ́bɛ́i nkɛ dɔ̀: Kòò mɔù yó n féútɛ́ fɛɔ̃̀fɛ̀ mɛtɑummɛ̀ kɔfɛ, kɛ̀ dinɑɑdɑɑ̀ ndi yoo fɛnifɛ fɛ̀ ntú fɛ̀ɛ̀ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Wèe tɔní o ɔ̃̀fɛ̀ mɛtɑummɛ̀ tou bòrìnùù kɛ́nɔ́ɔ́ nho nɔu fɛ yuu kɛ́ fɛ̀ fèútɛ́, kɛ̀ ikuɔ́ nìùtì Anɔɔ bíi míɛ́tɛ́ mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì kɛ́fitɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","kɛ́dɛitɛ mɛtɑummɛ̀ kó fɛɔ̃̀fɛ̀ kó imɑɑ mmiɛkɛ bɛ̀ yó n tuɔ nyì: Tinɑutì kó mɛkùɔ̀ nnɛ̀ mɛ̀ɛ̀ tì dɑ̀ɑ́tí. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","Nɛ̀ yɛceumbɛ̀ yɛdɛ́ nɛ̀ yɛ kó mɛkùɔ̀ nnɛ̀ kutúúkú nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ cɑ̀ɑ́tínɛ̀ yɛɔ̃ nɛ̀ yɛceumbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Kɛ̀ Anɔɔ bíi dɛ̀ tùótɛ́ kɛ́wɛ̃nnɛ́nɛ̀ bɛ̀ yóó tuɔ nfɛ̀ kɛ́dɑɑ́ ndiwũɔ̃tɔ̀nnì idɛí ĩ́nkɛ̀ kɛ́tuɔ. Dɛ̀ tu dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Kɛ̀ fɛɔ̃̀fɛ̀ sɑ́m̀pɔ́fɛ̀ mɛ nni nfɛ ò dɔ́ kɛ́ n féútɛ́mɛ̀ mɛtɑummɛ̀ kpɛ́í, kɛ̀ fɛdɑɑfɛ̀ nfɛ̀ yoo fɛnifɛ fɛ̀ ntú fɛ̀ɛ̀ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Kɛ̀ fɛpìèfɛ̀ mɛ nni nfɛ ò dɔ́ kɛ́ n féútɛ́mɛ̀, wèe fɛ̀ tɔní mɛtɑummɛ̀ tou ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","kɛ́nɔ́ɔ́ nho nɔ̀ùtɛ̀ fɛ yuu kɛ́ fɛ̀ fèútɛ́ mɛtɑummɛ̀ tou bòrìnùù, kɛ̀ Anɔɔ bíi míɛ́tɛ́ mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì kɛ́fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Dɛ kó fɛɔ̃̀fɛ̀ mɛtɑummɛ̀ kɔfɛ, bɛ̀ɛ dɛitɛ mɛkùɔ̀ nkpɛrɛ kɛ̀ dɛ̀ ntú n kpɛrɛ, kɛ̀ bɛ̀ɛ dɛ̀ tùɔ nkɛ́kéétɛ́ kuyóú kumɔu kù tuutɛ́nɛ̀ dɛ̀ kudiiku, nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ cɑ̀ɑ́tínɛ̀ tinɑutì nɛ̀ mɛ̀ɛ̀ tì dɑ̀ɑ́tí. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","Yɛceumbɛ̀ yɛdɛ́ nɛ̀ yɛ kó mɛkùɔ̀ nnɛ̀ kudiiku nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ cɑ̀ɑ́tí yɛɔ̃ nɛ̀ yɛceumbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Kɛ̀ ikuɔ́ nìùtìi dɛ̀ nni ntuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, n kpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Kɛ̀ tɛbuɔtɛ̀ mɛ nni ntɛ, wèe tɛ̀ tɔní mɛtɑummɛ̀ tou ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","kɛ́nɔ́ɔ́ nho nɔ̀ùtɛ̀ tɛ yuu kɛ́ tɛ̀ fèútɛ́ mɛtɑummɛ̀ tou bòrìnùù. Kɛ̀ Anɔɔ bíi míɛ́tɛ́ mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì kɛ́fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Dɛ kó difɔ̃nkúò, ntɛ ò yóó tuɔ ndɛ̀ n kpɛ́í, mɛkùɔ̀ mmɛ̀ɛ̀ cɑ̀ɑ́tínɛ̀ tinɑutì nɛ̀ mɛ̀ɛ̀ tì dɑ̀ɑ́tí. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","Yɛceumbɛ̀ yɛdɛ́ nɛ̀ yɛ kó mɛkùɔ̀ nnɛ̀ kudiiku nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ dɑ̀ɑ́tí yɛɔ̃ nɛ̀ yɛceumbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Kɛ̀ ikuɔ́ nìùtìi tuɔ ndɛ kó imɑɑ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀. N kpɛrɛ ndɛ dipɑ̃nnì dìì kó kufɔ̃ɔ̃ku n nɑɑti. Mɛkùɔ̀ nkpɛrɛ kó dimɑ̀ɑ̀, mí ndi Yiɛ̀ nKuyie mmíì dɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Òmɔù bɑ́ nyo mmɛkùɔ̀ nnɛ̀ mɛyĩ̀ĩ̀ mbɑ́ kɛ̀ di bo kɛ̀ɛ̀ bíɛ́kɛ̀, dɛ̀ tu ikuɔ́ nyi di kpɛ́í nnɛ̀ di yɑɑ̀bío sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀: Kɛ̀ dɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò dɔ̀ɔ̀ ikuɔ́ yetɛ dɛ̀, kòò dɔ̀ɔ̀ n yɛ̃ di bɑ́ɑ́ dɔɔ̀ dɛ kó dɛ̀mɑrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Kɛ̀ dɛ̀ dò nyikuɔ́ nìùtì bɛ̀ cɑ̃̀ńnɛ́ wè n tɔ̃mmú kpɛ́í weè yetɛ́ kɛ dɔ̀ɔ̀ mɛyɛi nkɛ tɑnnɛ́ n nìtìbɛ̀ mɛyɛi mmiɛkɛ. Wè n féútɛ́ dinɑɑdɑɑ̀ dìì kpɑ kuyɛ̀nkù, mɛyɛi nhò dɔ̀ɔ̀mɛ̀ kó mɛcĩ́ɛ̃́mmɛ̀ kó fɛɔ̃̀fɛ̀ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Wèe fɛ̀ tɔní mɛtɑummɛ̀ tou ììkɛ̀, kɛ́dɑɑ́ nho nɔ̀ùtɛ̀ di yuu ĩ́nkɛ̀ kɛ́ di nni nféútɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","kɛ́yɛ̃ntɛ́ mɛyĩ̀ĩ̀ nkɛ́tɑnnɛ̀ mɛtɑummɛ̀ tou, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","kɛ́pɔɔ̀tɛ̀ o nɔ́mbii kɛ́míɛ́tɛ́ kucɛ mɛ̀yiekɛ̀ kuyɑ̀ɑ̀kù kùù kpetí mɛtɑummɛ̀ tou bòrì dɛ miɛkɛ kpɛri, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","kɛ́cɔ̃nnɛ́ dɛ kó mɛyĩ̀ĩ̀ nhò yɛ̃ntɛ́mɛ̀ dihúúntɔ̀nnì dìì bo mɛtɑummɛ̀ tou miɛkɛ di kó yɛbɑ̀kɛ̀ ĩ́nkɛ̀. Kòò dèè wèe cóú mmɛyĩ̀ĩ̀ nsɔmmɛ diwũɔ̃tɔ̀nnì dìì bo mɛtɑummɛ̀ tou bòrìnùù di fũ̀ɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Ntɛ bɛ̀ yóó dɔɔ̀mɛ̀ dɛ kó dinɑɑdɑɑ̀ bɛ̀ n fèútɛ́ di mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, mɛkùɔ̀ mmɛ̀ɛ̀ cɑ̀ɑ́tínɛ̀ tinɑutì nɛ̀ mɛ̀ɛ̀ tì dɑ̀ɑ́tí, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","nɛ̀ yɛceumbɛ̀ yɛdɛ́ nɛ̀ yɛ kó mɛkùɔ̀ nnɛ̀ kudiiku nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ dɑ̀ɑ́tí yɛɔ̃ nɛ̀ yɛceumbɛ̀ yɛdɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","kɛ́ndònnɛ̀ bɛ̀ bɑɑ ɔ̃ɔ̃ dɛitɛ dɛ̀ fɛɔ̃̀fɛ̀ bɛ̀ n fèútɛ́ fɛ̀ mɛtɑummɛ̀ kpɛ́í nkɛ̀ ikuɔ́ nìùtìi dɛ̀ tùɔ mbɛ̀ tùɔ̀ ndɛ̀ bɛ̀ n feu ìì wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Dɛ kó dinɑɑdɑɑ̀ kɔ̃̀nkù nɛ̀ di mɑɑ nnɛ̀ di yuu nɛ̀ di kpɑ́ɑ̀ nnɛ̀ di nɑutì nɛ̀ di piti, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","di mɑɑ nyimɔu cɛ̃́nkɛ, bɛ̀ɛ ì tɔ kɛ́dennɛ bɛ̀ kɑrì, kɛ́kɔtɛnɛ̀ dibòrì dìì cɑ̃̀ɑ̃́, bɛ̀ uutoo dɛ̀ iwũɔ̃ kó mɛkùɔ̀ nkó mutɑ́pɛí, kɛ́tɔtìnnɛ muhɑ̃ɑ̃́ ndibòrì bɛ̀ tɑ̃ɑ̃tɛ́ dì kɛ uutoo iwũɔ̃ kó mutɑ́pɛí mbɛ̀ yóó dɛ ndì tùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Kɛ̀ dɛ̀ dò ndɛ̀ kpɛtɛ́nɛ̀ Isidɑyɛɛribɛ bɛmɔu ndi, kɛ̀ bɛ̀ dɔ̀ɔ̀ n yɛ̃ mbɛ̀ bɑ́ɑ́ dɔɔ̀ dɛ kó dɛ̀mɑrɛ̀ bɑ́ bɛ̀ í yɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Kɛ̀ bɛ̀ bɑntɛ́ dìì mɔ̀nnì dɛ kó mɛyɛi mbɛ̀ɛ wɑɑ́ ndinɑɑdɑɑ̀ dìì kpɑ kuyɛ̀nkù kɛ́ dì kɔ̀tɛnɛ̀ní mɛtɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Dɛǹdɛ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ yóó nɔ́ɔ́mmɛ̀ bɛ nɔu dinɑɑdɑɑ̀ yuu ĩ́nkɛ̀ mɛtɑummɛ̀ tou ììkɛ̀ kɛ́ dì nni nféútɛ́ kɛ̀ n di cĩ́ɛ̃́ ndi yɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Kɛ̀ ikuɔ́ nìùtì diɛwèe wɑɑ́ mmɛyĩ̀ĩ̀ nkɛ́tɑnnɛ́ mɛtɑummɛ̀ tou miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","kɛ́pɔɔ̀tɛ̀ o nɔ́mbii mɛyĩ̀ĩ̀ nkɛ́míɛ́tɛ́ kucɛ mɛ̀yiekɛ̀ kuyɑ̀ɑ̀kù kùù kpetí mɛtɑummɛ̀ tou bòrì dɛ miɛkɛ kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Kòò dèè wèe cɔ̃nnɛ́ dɛ kó mɛyĩ̀ĩ̀ nhò mìɛ́tɛ́mɛ̀ dihúúntɔ̀nnì dìì bo mɛtɑummɛ̀ tou miɛkɛ di kó yɛbɑ̀kɛ̀, kòò dèè wèe cóú mmɛyĩ̀ĩ̀ nsɔmmɛ diwũɔ̃tɔ̀nnì dìì bo mɛtɑummɛ̀ tou bòrì di fũ̀ɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Kòo dɛitɛ dɛ kó dinɑɑdɑɑ̀ kó mɛkùɔ̀ mmɛmɔu kɛ́ mɛ̀ tùɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Ò bɑɑ do dɔ̀ɔ̀mɛ̀ o kó dinɑɑdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri ò yóó mɛ ndɔɔ̀ bɛ kpɛri, kɛ́ bɛ̀ dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́, kɛ̀ m bɛ̀ cĩ̀ɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Wèe dennɛ dɛ kó dinɑɑdɑɑ̀ Isidɑyɛɛribɛ kɑrì kɛ́ dì tùɔ nhò do tùɔ mmɛ̀ɛ̀ botí o kpɛri. Isidɑyɛɛribɛ bɛmɔu yɛi ncĩ́ɛ̃́mmɛ̀ kpɛri ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Kɛ̀ dɛ̀ dò ndɛ̀ kpɛtɛ́nɛ̀ wèè bɑkɛ́, kòò dɔ̀ɔ̀ mí ndi Yiɛ̀ nKuyie nyí dɔ́ dɛ kó dɛ̀mɑrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Kɛ̀ bɛ̀ ò nɑ̀kɛ́ o yɛi nhò dɔ̀ɔ̀ mɛ̀, wèe tɔní dibɔdɑɑ̀ dìì kpɑ kuyɛ̀nkù, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","kɛ́nɔ́ɔ́ nho nɔ̀ùtɛ̀ di yuu ĩ́nkɛ̀ kɛ́ dì nni nféútɛ́ bɛ̀ feu dɛ̀ iwũɔ̃ bɛ̀ tùɔ̀ nyì. O yɛi ncĩ́ɛ̃́mmɛ̀ kó fɛɔ̃̀fɛ̀ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Kɛ̀ ikuɔ́ nìùtì diɛwèe pɔɔ̀tɛ̀ mɛyĩ̀ĩ̀ nho nɔ́mbii kɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì bɑ̀kɛ̀, kɛ́cóú mmɛyĩ̀ĩ̀ nsɔmmɛ dɛ kó diwũɔ̃tɔ̀nnì fũ̀ɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","kɛ́tuɔ nfɛ kùɔ̀ mmɛmɔu dɛ kó diwũɔ̃tɔ̀nnì ĩ́nkɛ̀ bɛ̀ ɔ̃ɔ̃ dɔɔ̀mɛ̀ mɛtɑummɛ̀ kɔfɛ kɔ̃mɛ, kóò dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ kóò dɛɛtɛ́nɛ̀ o yɛi nkɛ̀ nh ò cĩ̀ɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Kɛ̀ dɛ̀ dò ndɛ̀ kpɛtɛ́nɛ̀ bɛnìtìbɛ̀ miɛkɛ nkɛ òmɔù, kòò dɔ̀ɔ̀ n yɛ̃ mbɛ̀ bɑ́ɑ́ dɔɔ̀ dɛ kó dɛ̀mɑrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Kɛ̀ bɛ̀ ò nɑ̀kɛ́ ò dɔ̀ɔ̀ mɛ̀ɛ̀ yɛi nwèe wɑɑ́ tɛbɔniitɛ tɛ̀ɛ̀ kpɑ kuyɛ̀nkù, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","kɛ́nɔ́ɔ́ nho nɔ̀ùtɛ̀ tɛ yuu kɛ́ tɛ̀ nni nféútɛ́ bɛ̀ feu dɛ̀ iwũɔ̃ bɛ̀ tùɔ̀ nyì. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Kɛ̀ ikuɔ́ nìùtì diɛwèe pɔɔ̀tɛ̀ mɛyĩ̀ĩ̀ nho nɔ́mbii kɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì bɑ̀kɛ̀, kɛ́cóúnko mɛyĩ̀ĩ̀ nsɔmmɛ dɛ kó diwũɔ̃tɔ̀nnì fũ̀ɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","kɛ́dɛi dɛ̀ɛ̀ kó dimɑ̀ɑ̀ tu mɛkùɔ̀ mbɛ̀ ɔ̃ɔ̃ dɛi mɛ̀ɛ̀ botí fɛɔ̃̀fɛ̀ bɛ̀ kùɔ fɛ̀ mɛtɑummɛ̀ kpɛ́í nfɛ kɔ̃mɛ, kɛ́ mɛ̀ tùɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀ mɛ̀ tu dipɑ̃nnì ndi dìì fɔ̃ɔ̃ku n nɑɑti, kóò dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ kɛ̀ nh ò cĩ̀ɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Kɛ̀ dɛ yiɛ̀ mmɛ ndɔ́ kɛ́féútɛ́ fɛpìèfɛ̀ nfɛ kɛ́ m pɑ̃, wèe tɔní fɛnifɛ fɛ̀ɛ̀ kpɑ kuyɛ̀nkù, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","kɛ́nɔ́ɔ́ nho nɔ̀ùtɛ̀ fɛ yuu kɛ́ fɛ̀ nni nféútɛ́ bɛ̀ feu dɛ̀ iwũɔ̃ bɛ̀ tùɔ̀ nyì. ");
INSERT INTO tbzsim_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Kɛ̀ ikuɔ́ nìùtìi pɔɔ̀tɛ̀ o nɔ́mbii fɛ yĩ̀ĩ̀ nkɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì, bɛ̀ tùɔ̀ ndìì ĩ́nkɛ̀ iwũɔ̃ di bɑ̀kɛ̀, kɛ́cóúnko mɛsɔmmɛ di fũ̀ɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","kɛ́dɛi mɛkùɔ̀ mmɛmɔu bɛ̀ ɔ̃ɔ̃ dɛimɛ̀ mɛtɑummɛ̀ kó fɛɔ̃fɛ̀ kɔ̃mɛ kɛ́ mɛ̀ wɛ̃nnɛ́nɛ̀ dɛ̀ɛ̀ ɔ̃ɔ̃ tuɔ nkɛ́tuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀ n kpɛ́í, kɛ́dɔɔ̀ dɛ yiɛ̀ mmɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ kɛ̀ nh ò cĩ̀ɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Kɛ̀ dɛ̀ dò ndɛ̀mɑrɛ̀ dɔ̀ɔ̀ kɛ̀ bɛ̀ wɑɑ̀ mbɛ̀ɛ̀ yɑ̀, kɛ nɑ́ɑ́ nkɛ tú dɛ yiɛ̀ mbo yɑ̀, kɑ̀ɑ yɛ̃́ kɛ cĩ́ɛ̃́kɛ́ kɛ yetɛ ɑ bo bɛ́immɛ̀, fɔ̃́ɔ̃̀ te mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Kòo mɔù weè mɛ nkɑ̀ɑ́kɛ́ dɛ̀mɑrɛ̀ ikuɔ́ yɛ̃ ndɛ̀ɛ̀ sĩ, kɛ̀ kuwɑnwɑnkù mɑkù nku yoo fɛɔ̃̀fɛ̀ yoo dɛbɑmbɑɑ̀nnɛ̀, kòò dɛ̀ kɑ̀ɑ́kɛ́ bɑ́ ò í yɛ̃́, kɛ sĩ̀nkùnnɛ omɑ́ɑ̀ kɛ tɔ dɛ kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Kòò mɛ nkɑ́ɑ́kɛ́ onìtì mɔù nwe ikuɔ́ yɛ̃ nwèè sĩ̀ mbɑ́ ò í dɑkɛ, kɛ̀ dɛ̀ boní kòò bɑntɛ́ ò tɔmɛ̀ dɛ kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Kòò mɔù weè nùù mɛ nhò fítɛ́nɛ̀ kòò pɑ̀rìkɛ̀nɛ̀ mí nKuyie n yètìrì, bɑ́ ò í totí o yɛ̀mmɛ̀, kɛ̀ dɛ̀ boní kòò bɑntɛ́ ò tɔmɛ̀ dɛ kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Kòò tɔ dɛ kó mɛyɛi nkó mɛ̀mɑmɛ̀ ò dò nkɛ́ mɛ̀ dɑ́ɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Wèe tɔní fɛpenifɛ yoo tɛbɔniitɛ kɛ́ũtɛ́ dɛ kó mɛyɛi, kɛ̀ ikuɔ́ nìùtìi o dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́, kóò dɛɛtɛ́nɛ̀ dɛ kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Kɛ̀ dɛ̀ dò nhòmɔù í mɔkɛ fɛpìèfɛ̀ yoo tɛbuɔtɛ̀ kɛ bo n féútɛ́ ò dɔ̀ɔ̀ mɛ̀ɛ̀ yɛi nkpɛ́í kɛ̀ nh ò cĩ̀ɛ̃́, wèe tɔní sinɔ́nkperípíɛ́ sìdɛ́sì yoo yɛkpɛtinɔ́nkperɛ yɛ̀dɛ́ɛ̀, kɛ́ n féútɛ́ tɛmɑ́ɑ̀ kɛ́tuɔ nkɛ́nféútɛ́ tɛtɛtɛ̀ ò dɔ̀ɔ̀ mɛ̀ɛ̀ yɛi nkpɛ́í kɛ̀ nh ò cĩ̀ɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Wèe dɛ̀ tɔní kɛ́duɔ́ nyikuɔ́ nìùtì kòo ketɛ́ kɛ́féútɛ́ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛtɛ. Wèe ĩ́ṹtɛ́ tɛ fɔ̃̀níí ò mɛ mbɑ́ɑ́ tɔ̃tɛ tɛ yuu, ");
INSERT INTO tbzsim_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","kɛ́dɛitɛ tɛ yĩ̀ĩ̀ nkɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì píkù kɛ́cóúnko mɛsɔmmɛ diwũɔ̃tɔ̀nnì fũ̀ɔ̃̀, mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛtɛ ntɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","kɛ́kuɔ tɛdɛ́tɛ̀ kɛ́tuɔ nyikuɔ́ yɛ̃mmɛ̀. Kɛ̀ ikuɔ́ nìùtìi ò dɔɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́, kɛ̀ nhò cĩ̀ɛ̃́ nho yɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Kɛ̀ dɛ̀ mɛ ndò nhòmɔù í mɔkɛ sinɔ́nkpeé yoo yɛkpɛtinɔ́nkperɛ, wèe tɔní muyuo ncìdóòbɛ̀ bɛ̀nɑ̀ɑ̀, ò bɑ́ɑ́ mù yɔɔrɛ mɛkùɔ̀ nhò mɛ mbɑ́ɑ́ cɔ̃nnɛ́ tihúúntì mu ĩ́nkɛ̀, kɛ yɛ̃́ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kɔ̃mu mmumɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Wèe mù tɔní kɛ́duɔ́ nyikuɔ́ nìùtì, kòo mù yɛ̃tɛ́ dinɑcɛkutiri, kɛ́wɛ̃nnɛ́nɛ̀ dɛ̀ɛ̀ yóó tuɔ nkɛ́tuɔ, kɛ̀ dɛ̀ɛ bɛnkɛ mumɔu mù tumɛ̀ n kɔ̃mu mmu, mù yóó ntu mɛyɛi ncĩ́ɛ̃́mmɛ̀ kɔ̃mu mmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Kɛ̀ ikuɔ́ nìùtìi ò dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ kɛ̀ nhò cĩ̀ɛ̃́ nho yɛi. Kɛ̀ ikuɔ́ nìùtì nte musɔmmu ò ɔ̃ nte mɛ̀ɛ̀ botí tidiitì kó yɛpɑ̃rɛ̀ kɔ̃mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","Kɛ̀ dɛ̀ dò ndɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò kɑ̀ɑ́kɛ́ yɛpɑ̃rɛ̀ bɛ̀ m pɑ̃ɑ̃ nyɛ̀, wèe tɔní dipedɑɑ̀ dìì kpɑ kuyɛ̀nkù dìì donku mɑ̀nnɛ̀ bɛ̀ kèétɛ́ ìì díítí n tɑummɛ̀ tou kpɛ́í, mmɛyɛi nhũtímù kó fɛɔ̃̀fɛ̀ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Wèe yietí ò yùúkú dɛ̀ n tɑummɛ̀ tou kɛ́nɔ́ɔ́ nkɛ̀ dɛ̀ mmɑ̀nnɛ̀ ò bo totɛ́mɛ̀ ò yùúkú dɛ̀ yɛwɛ́tiyɛ̀ yɛ̀nùmmù kó dìmɑ́ɑ̀ kòo dɛ̀ duɔ́ nyikuɔ́ nìùtì. Kɛ̀ ikuɔ́ nìùtìi féútɛ́ diì pedɑɑ̀ kóò dɔ̀ɔ̀ mɛyɛi nhũtímù kó ikuɔ́ kɛ̀ nh ò cĩ̀ɛ̃́ nho yɛi. Dɛ kó ikuɔ́ nyi mɛmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Kòò mɔù yetɛ́ kɛ dɔ̀ɔ̀ n yɛ̃ n yí dɔ́ dɛ̀, kɛ í yɛ̃́, dɛ kó mɛyɛi mbɑɑ bo o yuu ĩ́nkɛ̀ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Kɛ̀ dɛ̀ boní kòò bɑntɛ́ wèe dɛitɛ o wũɔ̃ miɛkɛ dipedɑɑ̀ dìì kpɑ kuyɛ̀nkù kɛ̀ di donku mɑ̀nnɛ̀ bɛ̀ kèétɛ́ ìì díítí mɛyɛi nhũtímù kpɛ́í nkɛ̀ ikuɔ́ nìùtìi ò dɔ̀ɔ̀ mɛyɛi nhò dɔ̀ɔ̀ mɛ̀ kɛ í yɛ̃́ mɛ kó ikuɔ́ kɛ̀ nh ò cĩ̀ɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Dɛ kó dipedɑɑ̀ tu mɛyɛi nhũtímù kpɛri ndi. Kɛ yɛ̃́ dɛ yiɛ̀ nni nyetɛ́nɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́i nkɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","Kɛ̀ dɛ̀ mɛ ndò nhòmɔù weè ciitɛ́ o kou kɛ n yetɛ́nɛ̀, kòo kou ò dɔúnnɛ̀ dɛ̀mɑrɛ̀ yoo ò dɛ̀ nhò bɑ̀nnɛ̀, kòò ò ciitɛ́ kɛ di o kpɛrɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","kòò mɛ mpɛtɛ́ dɛ̀mɑrɛ̀ ndɛ kɛ nɛ̀nni, kɛ pɑrìkɛ̀ kɛ bo sɔnnɛ, nɛ̀ dɛ kó mɛdɔɔ̀rìmɛ̀ yɛimɛ botí. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","Kòò dɔ̀ɔ̀ dɛ kó mɛyɛi mbotí ò dò nkɛ́ dɛ̀ fɔ̀ɔ́mmu, ò yùúkú dɛ̀ yoo ò fìetɛ dɛ̀ yoo bɛ̀ ò dɔúnnɛ̀ dɛ̀, yoo ò pɛ̀tɛ́ dɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","yoo ò soú nkɛ pɑrìku. Nɛ̀ dɛ kpɛ́í nwèe yietí kɛ́nɔ́ɔ́ nkɛ̀ dɛ̀ mmɑ̀nnɛ̀ kòò do dɛ̀ totɛ́ kucɛ mɛ̀nùmmù dɛ̀mɑ́ɑ̀ nɑ mmɑ̀mɛ̀. Bɛ̀ ò yɑ̀ dìì yiè dimɔ́mmɔnni ndi ò dòmmɛ̀ kɛ́yietí wèè te dɛnɛnnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","Kòò dèè mɛmmɛ ò nɛ́ dɛitɛní dipedɑɑ̀ o wũɔ̃ miɛkɛ dìì kpɑ kuyɛ̀nkù, dìì mɑ̀nnɛ̀ ikuɔ́ nìùtì kèétɛ́ ìì díítí mɛyɛi nhũtímù kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Kɛ̀ ikuɔ́ nìùtìi ò dɔ̀ɔ̀ mɛyɛi nhũtímù kó ikuɔ́ kɛ̀ nhò cĩ̀ɛ̃́ mbɑ́ kòò do dɔ̀ɔ̀ mɛ̀ɛ̀ yɛi mbotí. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","Nɑ́kɛ́ Anɔɔ nɛ̀ o bí kɛ tú: N yɛ̃ nkɛ̀ bɛ̀ n fèútɛ́ fɛɔ̃̀fɛ̀ kɛ tuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀ bɛ̀ bɑ́ɑ́ yie nkɛ̀ dɛ kó muhɑ̃ɑ̃́ nkú. Mù nyié nkɛ cɔ́ú nkɛ̀ dɛ̀ɛ wentɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Kɛ̀ ikuɔ́ nìùtìi dɑ́ɑ́tí dikɔutɛ́yɑɑ̀bòrì, dìì dùɔ̀kɛnɛ̀ mupɑɑ̀konkperímù, kɛ́yi dɛfɛtirɛ dɛ̀ɛ̀ dùɔ̀kɛnɛ̀ mupɑɑ̀konkperímù, kɛ́deè kɛ nɛ́ koutɛ́ mutɑ́pɛí mmɛkùɔ̀ nkɔ̃mu bɛ̀ n tùɔ nfɛ̀ɛ̀ ɔ̃̀fɛ̀ kɔ̃mu kɛ́ mù ĩ̀ńnɛ́ diwũɔ̃tɔ̀nnì píkù, ");
INSERT INTO tbzsim_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","kɛ́dɛitɛ o yɑ̀ɑ̀tì kɛ́ɑ̃nnɛ́ titɛtì kɛ́ mù tɔ kɛ́dennɛ bɛ̀ kɑrì, kɛ́kɔtɛnɛ̀ dibòrì bɛ̀ tɑ̃ɑ̃tɛ́ dì dɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Diwũɔ̃tɔ̀nnì kó muhɑ̃ɑ̃́ mbɑ́ɑ́ kú. Bɑ́ dìì kṹnweńnì ikuɔ́ nìùtì níí mù tií nkɛ́nɔ́ɔ́ nfɛɔ̃̀fɛ̀ fɛ̀ɛ̀ ɔ̃ɔ̃ tuɔ nkɛ nɛ́ nɑ kɛ́tuɔ mmɛkùɔ̀ mmɛtɑummɛ̀ kó ikuɔ́ kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Diwũɔ̃tɔ̀nnì kó muhɑ̃ɑ̃́ nyó ncɔ́úmmu nsɑ̃́ɑ̃̀ mù bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Ntɛ tidiitì kó yɛpɑ̃rɛ̀ kó ikuɔ́ yo ndòmmɛ̀: Anɔɔ bí iì níí yóó yɛ̀ tɔní dihúúntɔ̀nnì borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Bɛ̀ níí yɛ̃tɛ́ muyuo nnɛ̀ mɛkùɔ̀ nnɛ̀ tihúúntì timɔu bɛ̀ ɔ̃ɔ̃ cɔ̃nnɛ́ tì mu ĩ́nkɛ̀, kɛ́tuɔ ndihúúntɔ̀nnì ĩ́nkɛ̀, dɛ̀ɛ̀ bɛnkú mumɔu mù tumɛ̀ n kɔ̃mu, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ di dɛsɔnnɛ, bɛ̀ mɛ mbɑ́ɑ́ kɔɔrɛnɛ̀ mutie mùù muuti pɛ̃́ɛ̃̀, bɛ̀ bɑ́ɑ́ kɑri sɔ̃́ntíkoo kó dibòrì kɛ́ mù di. Bɛ̀ɛ kɑri mɛtɑummɛ̀ tou kó kudɑ̀nkù nku kɛ́ mù di. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Dɛ kó mudiì bɛ̀ bɑ́ɑ́ mù kɔɔrɛnɛ̀ mutie mùù muuti kɛ́pṹnnɛ́ kɛ yɛ̃́ bɛ̀ m pɑ̃ tìì diitì kɛ tùɔ ntiì sùɔ́mmɛ̀, tì tu n kpɛti nti kɛ dònnɛ̀ bɛ̀ ɔ̃ɔ̃ m pɑ̃ fɛɔ̃̀fɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í nyoo mɛyɛi nhũtímù kpɛ́í nkɛ̀ dɛ̀ɛ súɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Anɔɔ kó kuwuɔ nkɔbɛ bɛɛ̀ yóó nyo ndɛ kó mudiì bɛ̀ m pɑ̃ kɛ yɛ̃tɛ́ kɛ sùɔ́ mmù, dɛ̀ yó ntú di kó ikuɔ́ nyi sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ntɛ Anɔɔ nɛ̀ o bí bɛ yó m pɑ̃ dìì pɑ̃nnì bɛ̀ yóó bɛ̀ cɑ̃̀ńnɛ́ dìì yiè ikuɔ́ tɔ̃mmú kpɛ́í. Bɛ̀ɛ wɑɑ́ mmuyuo nsɑ̀ɑ̀mù cìdóòbɛ̀ bɛ̀tɑ̃ɑ̃ti, kɛ́totɛ́ mu cuokɛ̀, muu ndikṹnweńnì mutɛ̃mù kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Bɛ̀ɛ mù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ nkɛ́pɛ̃mmú kɛ́wɛ́rí kɛ́ m pɑ̃. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Anɔɔ wuɔ mmiɛkɛ kɛ̀ bɛ̀ yóó cɑ̃́nnɛ́ òmɔù kòò ntú ikuɔ́ nìùtì, wèe mɛ ndɔɔ̀. Dɛ kó ikuɔ́ yó mbo sɑ̃́ɑ̃̀ ndi, dɛ kó dipɑ̃nnì níí yó ntú dìì tùɔ ndìndi pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Kɛ̀ ikuɔ́ nìùtì m pɑ̃ tidiitì kó dipɑ̃nnì bɛ̀ɛ dì tùɔ, mbɛ̀ bɑ́ɑ́ dì di. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Kɛ̀ ti Yiɛ̀ nKuyie nni nsɔkɛ́ ku nɑ́ɑǹtì kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Nɑ́kɛ́ Anɔɔ nɛ̀ o bí kɛ tú: N yɛ̃ nkɛ̀ bɛ̀ yó n féútɛ́ fɛɔ̃̀fɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í mbɛ̀ɛ fɛ̀ nni nféútɛ́ mɛtɑummɛ̀ tou ììkɛ̀ bɛ̀ n feu dɛ̀ bɛ̀ tùɔ̀ nyì. Bɛ̀ fɛ̀ nni mpɑ̃mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Ikuɔ́ nìùtì wèè kùɔ dɛ kó fɛɔ̃̀fɛ̀, weè dò nkɛ́ fɛ̀ di ò mɛ mbɑ́ɑ́ kɑri sɔ̃́ntíkoo kó dibòrì kɛ́ fɛ̀ cɑ̀ɑ́kɛ́, wèe kɑri mɛtɑummɛ̀ tou kó kudɑ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Kòo tɔù mɔù kɑ̀ɑ́kɛ́ dɛ kó kumɑɑ nhò kúmu, kɛ̀ mɛyĩ̀ĩ̀ mmɛɛ̀ mɛ ndɑ̀ri o yɑ̀ɑ̀tì, wèe tì ɔ̀ú dibòrì bɛ̀ tɑ̃ɑ̃tɛ́ dì dɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Kɛ̀ bɛ̀ ì bèńnɛ́nɛ̀ tiyɑɑtì kó tɛkṹmbotɛ̀ kɛ dèè bɛ̀ɛ tɛ̀ pɔ̀ntɛ. Kɛ̀ disɔɔwũɔ̃̀ kpɛtɛ mɛ nni ntɛ bɛ̀ɛ tɛ̀ ɔ̀ú mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ikuɔ́ nìùbɛ̀ cɛ̃́ĩ kɔbɛ bɛɛ̀ bo nɑ kɛ́ ì di, dɛ kó imɑɑ ntu bɛ̀ m pɑ̃ ì nyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kɛ̀ bɛ̀ n fèútɛ́ fɛ̀ɛ̀ ɔ̃̀fɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í nkɛ tɑnnɛ̀ fɛ yĩ̀ĩ̀ mmɛtɑummɛ̀ tou miɛkɛ kɛ dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ bɛ̀ɛ fɛ̀ cɔ́u. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Ntɛ mɛyɛi nhũtímù kó ikuɔ́ yó ndòmmɛ̀: Dɛ kó fɛɔ̃̀fɛ̀ níí yó ntú bɛ̀ m pɑ̃ fɛ̀ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Bɛ̀ɛ fɛ̀ nni nféútɛ́ bɛ̀ feu dɛ̀ bɛ̀ tùɔ̀ nyì, kɛ̀ ikuɔ́ nìùtìi míɛ́tɛ́ mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì kɛ́fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Kɛ̀ bɛ̀ n duɔ́ ndɛ̀ɛ̀ tu mɛkùɔ̀ nkpɛrɛ, kuyóú nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ dɑ̀ɑ́tí tinɑutì ");
INSERT INTO tbzsim_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","nɛ̀ yɛceumbɛ̀ nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ yɛ̀ dɑ̀ɑ́tí nɛ̀ kutúúkú nɛ̀ yɛɔ̃ kó mɛkùɔ̀ nnɛ̀ yɛceumbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kɛ̀ dí dɛ̀ nni ntuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀. Mɛyɛi nhũtímù kó fɛɔ̃̀fɛ̀ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Ikuɔ́ nìùbɛ̀ cɛ̃́ĩ kɔbɛ bɛɛ̀ mɑ́ɑ̀ bo nɑ kɛ́di dɛ kó imɑɑ. Bɛ̀ mɛ mbɑ́ nkɑri sɔ̃́ntíkoo kó dibòrì kɛ́ ì di, bɛ̀ fɛ̀ nni mpɑ̃mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Mɛyɛi nhũtímù nɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ dɛmɑ́ɑ̀ ndi, ikuɔ́ nìùtì wèè dɔ̀ɔ̀ dɛ kó ikuɔ́ weè níí yó nte fɛ kó imɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Kɛ̀ bɛ̀ n fèútɛ́ fɛɔ̃̀fɛ̀ kɛ tùɔ, nyikuɔ́ nìùtì wèè dɔ̀ɔ̀ dɛ kó ikuɔ́ weè yó nte fɛ kɔ̃̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kɛ̀ bɛ̀ mɛ nni mpɑ̃ tidiitì nti, kɛ tì pũ̀ńnɛ́ yoo kɛ tì fìu nyoo kɛ tì pɛ̃mmú, ikuɔ́ nìùtì wèè dɔ̀ɔ̀ ikuɔ́ weè yó ntì te. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Kɛ̀ bɛ̀ mɛ nni mpɑ̃ tidiitì tìì kɔɔrɛnɛ̀ mɛkùɔ̀ nnɛ̀ tìì í mɛ̀ kɔɔrɛnɛ̀ tìì kó dimɑ̀ɑ̀ í pũ̀ńnɛ́ Anɔɔ bí tì totí kɛ̀ dɛ̀ mmɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Ntɛ ikuɔ́ di yó nni n feu mɛ̀ɛ̀ botí iwũɔ̃ mɛtɑummɛ̀ kpɛ́í: ");
INSERT INTO tbzsim_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Kòò mɔù dɔ́ kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀ disɑ̃nni kpɛ́í nwèe yíɛ́nɛ̀ yɛkɑ̀tìndɑ̀ yɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti, bɛ̀ ɑ̃̀ntɛnɛ̀ yɛ̀ɛ̀ cootì mɛkùɔ̀ nnɛ̀ tipɛ̃́mpɛ̃ńtì tìì wɑɑrɛ mɛkùɔ̀ nnɛ̀ muyuo nsɑ̀ɑ̀mù kɛ́ mù kɔɔrɛnɛ̀ mɛkùɔ̀ nkɛ́píítɛ́ kɛ́pṹnnɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","kɛ́wɑɑ́nnɛ̀ pɛ̃́ɛ̃̀ wèè kɔɔrɛnɛ̀ mutie mùù muuti kɛ́yíɛ́nɛ̀ fɛɔ̃̀fɛ̀ bɛ̀ yó n féútɛ́ fɛ̀ mɛtɑummɛ̀ kpɛ́í nyoo disɑ̃nni kó fɛɔ̃̀fɛ̀ ");
INSERT INTO tbzsim_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Kɛ̀ bɛ̀ɛ dɛitɛ dɛ kó mudiì miɛkɛ dɛ̀ɛ̀ yó ntú n kpɛrɛ, ikuɔ́ nìùtì wèè mìɛ́tɛ́ mɛtɑummɛ̀ ɔ̃̀fɛ̀ kó mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì weè dɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Bɛ̀ n fèútɛ́ dìì yiè dɛ kó fɛɔ̃̀fɛ̀ diǹdi bɛ̀ yóó fɛ̀ cɑ̀ɑ́kɛ́mɛ̀, bɛ̀ bɑ́ɑ́ súɔ́ ndɛ̀mɑrɛ̀ kɛ̀ dɛ̀ nyĩ́ĩ́kú kɛ́wentɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Kòo nìtì weè mɛ nni ncɑ̀nnɛ̀nɛ̀ dinùù kɛ dɔ́ kɛ́ fɛ̀ nni nféútɛ́ yoo ò bɑɑ dɔ́ kɛ́ fɛ̀ nni nkuɔ nɛ̀ o yɛ̀mmɛ̀ mmɛ, bɛ̀ɛ fɛ̀ cɑ̀ɑ́kɛ́ dɛ yiè nɛ̀ nɑnkoo. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Kɛ̀ fɛ mɑɑ nkpɑɑ́ kɛ tùɔ̀kɛ diyiè tɑ̃ɑ̃́nnì yiè bɛ̀ɛ ì cɔ́u. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Kɛ̀ bɛ̀ ì cɑ̀ɑ́kɛ́ diyiè tɑ̃ɑ̃́nnì yiè dɛ kó dipɑ̃nnì nɑɑ́ ndɛtetìrɛ̀ ndɛ, n tɛ̃́nkɛ bɑ́ɑ́ dì cɔutɛ́, dɛ kó imɑɑ ntú ìì sĩ̀ntɛ ì nyi, kɛ̀ wèè ì di weè tɔ dɛ kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Kɛ̀ imɑɑ mmɑì kɑ̀ɑ́kɛ́ dɛ̀mɑrɛ̀ ikuɔ́ yɛ̃ ndɛ̀ɛ̀ sĩ̀ mbɛ̀ bɑ́ɑ́ ì di, bɛ̀ɛ ì cɔ́u. Wèè wenni ikuɔ́ yɛ̃mmɛ̀ weè bo nɑ kɛ́di mɛtɑummɛ̀ kó fɛɔ̃̀fɛ̀ kó imɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Kɛ̀ wèè sĩ̀ nyikuɔ́ yɛ̃mmɛ̀ kɛ ì cɑ̀ɑ́kɛ́ bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ tĩ̀nnì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Kòò mɔù kɑ̀ɑ́kɛ́ dɛ̀mɑrɛ̀ ikuɔ́ yɛ̃ ndɛ̀ɛ̀ sĩ̀ kòo nìtì nwe yoo kuwɑnwɑnkù yoo dɛ̀tɛrɛ̀ mɑrɛ̀ ikuɔ́ yetɛ dɛ̀, kɛ cɑ̀ɑ́kɛ́ fɛɔ̃̀fɛ̀ bɛ̀ n fèútɛ́ fɛ̀ mɛtɑummɛ̀ kpɛ́í nfɛ kó imɑɑ, dɛ yiɛ̀ mbɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ tĩ̀nnì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Kɛ̀ ti Yiɛ̀ nKuyie nni nsɔkɛ́ ku nɑ́ɑǹtì kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú: Di bɑ́ nyo mmɛnɑɑkùɔ̀ nnɛ̀ ipe nɛ̀ sibɔɔ́ dɛ kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Kɛ̀ fɛɔ̃̀fɛ̀ mɑfɛ̀ ku yoo musĩ̀mmù fɛ̀ pĩ, di bɑ́ɑ́ cɑ́ɑ́kɛ́ fɛ kùɔ̀, di nɛ́ bo nɑ kɛ́ mmɛ̀ pĩ̀ńnɛ̀ mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Kòò mɔù cɑ̀ɑ́kɛ́ mɛkùɔ̀ mbɛ̀ ɔ̃ɔ̃ n kuɔ fɛɔ̃̀fɛ̀ kɛ́dɛitɛ mɛ̀ kɛ́tuɔ. Bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ tĩ̀nnì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Bɑ́ kɛ̀ di bo kɛ̀ɛ̀ bíɛ́kɛ̀ di bɑ́ nyo mmɛyĩ̀ĩ̀, bɑ́ tɛnɔ̀tɛ̀ kɔ̃mɛ yoo itɑ̀ɑ̀kɛ inɑ̀ɑ̀ kpɛrɛ kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Kɛ̀ wèè di mɛyĩ̀ĩ̀ mbɑ́ kòò tu wè bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ tĩ̀nnì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","Kòò mɔù n fèútɛ́ fɛɔ̃̀fɛ̀ wèe dɛitɛ kumɑɑ nkùù tu n kɔku. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Wèe dɛitɛ o mɔ́mmuɔ nyìì tu n kpɛyi, mɛkùɔ̀ nkpɛrɛ nɛ̀ dicĩ̀ncĩ̀nnì kɛ́ dɛ̀ nni mbɛnkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Kɛ̀ ikuɔ́ nìùtìi tuɔ mmɛkùɔ̀ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀ Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ túótɛ́ dicĩ̀ncĩ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Mɛtɑummɛ̀ kó iwũɔ̃ di n feu ì miɛkɛ, di níí dɛitɛ dikpèrì youri kɛ́duɔ́ nyikuɔ́ nìùtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Anɔɔ bí ìì yóó míɛ́tɛ́ mɛtɑummɛ̀ kó fɛɔ̃̀fɛ̀ kó mɛyĩ̀ĩ̀ nkɛ́tuɔ mmɛkùɔ̀. Bɛɛ̀ yó nte dɛ kó dikpèrì. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Mí ndi Yiɛ̀ nKuyie mmíì tu: Di níí dɛitɛ di n feu ìì wũɔ̃ mɛtɑummɛ̀ kpɛyi miɛkɛ dicĩ̀ncĩ̀nnì kɛ́ m bɛnkɛ kɛ́dɛitɛ dikpèrì Anɔɔ nɛ̀ o bí bɛ kpɛrɛ ndɛ. Dɛ̀ yó ntú di kó ikuɔ́ nyi sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Nɛ̀ bɛ̀ cɑ̃̀ńnɛ́ dìì yiè ndi Anɔɔ nɛ̀ o bí n tɔ̃mmú kpɛ́í n dɛ̀itɛmɛ̀ dɛ kó imɑɑ nyiwũɔ̃ bɛ̀ n feu ì kɛ tuɔ̀ nyi miɛkɛ kɛ dɔ̀, ì bo ntú bɛ kpɛyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Diì yiè ndi m bɛ́immɛ̀ kɛ dɔ̀ bɛ̀ níí dɛ̀ mbɛ̀ duɔ́, kɛ dɔ̀: Dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Ntɛ bɛ̀ yó nni nfeu ìì wũɔ̃ kɛ tuɔ̀ nnɛ̀ bɛ̀ yó nni mpɑ̃ɑ̃ ntìì diitì kɛ tuɔ̀ nnɛ̀ bɛ̀ yó nni nfeu ìì wũɔ̃ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í nnɛ̀ mɛyɛi nhũtímù kpɛ́í, nɛ̀ bɛ̀ níí bo nyóó cɑ̃́nnɛ́mɛ̀ ikuɔ́ nìùtì, nɛ̀ mɛtɑummɛ̀ kpɛyi dɛ kó ikuɔ́ duɔ́ kɛ mɛ ndò. ");
INSERT INTO tbzsim_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́ tì nti Mɔyiisi Sinɑii tɑ̃rì ĩ́nkɛ̀ kù bɛ̀ nɑ̀ɑ́ ndìì yiè kɛ tú bɛ̀ nkù feu iwũɔ̃ Sinɑii kó dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","Yú Anɔɔ nɛ̀ o bí kɛ́túótɛ́ ikuɔ́ yɑ̀ɑ̀tì nɛ̀ ikuɔ́ kó mɛkùɔ̀ nkɛ́wɑɑ́ ndinɑɑdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri nɛ̀ yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀, kɛ́ɑ̃nnɛ́ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti kuhɔnku miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","kɛ́yú Isidɑyɛɛribɛ tĩ̀nnì dimɔu kɛ̀ dìi tíí mmɛtɑummɛ̀ tou bòrì borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Kɛ̀ Mɔyiisii tũnnɛ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì kɛ́tíí nyIsidɑyɛɛribɛ bɛmɔu mɛtɑummɛ̀ tou bòrì borɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","kɛ́ bɛ̀ nɑ̀kɛ́ ti Yiɛ̀ nKuyie nyɛ̃ nwèe dɔɔ̀mɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","kɛ́deè kɛ́duɔ́ nhAnɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ tɔ́ɔ́nní kòo bɛ̀ wùɔ ikuɔ́ yɛ̃mmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","kɛ́dɑ́tínnɛ́ Anɔɔ dikɔutɛ́yɑɑ̀bòrì kɛ́boú fɛnɑɑ̀kɔ̃̀nfɛ̀, kɛ́nɔ́ɔ́ ndikɔutɛ́yɑɑ̀bòkũpuri, kɛ́nɔ́ɔ́ ntɛkɔutɛ́yɑɑ̀bòtɛ̀ kɛ́boú fɛnɑɑ̀kɔ̃̀nfɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","kɛ́deè kɛ́nɔ́ɔ́ ndicĩ̀ncĩ̀nkɔ̃̀nnì, kɛ́ɑ̃nnɛ́ di miɛkɛ ikuɔ́ nɛntì bɛ̀ tu tì udimmu nɛ̀ tumimmu ");
INSERT INTO tbzsim_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","kɛ́boú o yuu kuyɑɑ̀bomboúnkù, kóò ìńnɛ́ fɛsɔɔyítòòdɑ́fɛ̀, dɛɛ̀ yóó bɛnkɛ kɛ dò mbɛ̀ ò cɑ̃̀ńnɛ́ n kó mutɔ̃mmú kpɛ́í. Ti Yiɛ̀ nKuyie ndo ti nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Kɛ̀ Mɔyiisii túótɛ́ ikuɔ́ kó mɛkùɔ̀ nkɛ́míɛ́tɛ́ mɛtɑummɛ̀ tou kɛ́ dì cɑ̃̀ńnɛ́ dindi nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo di miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","kɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì kucɛ mɛ̀yiekɛ̀, dindi nɛ̀ di nɛntì, kunɑnkú nɛ̀ ku tɑ̀rì, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","kɛ́cóú nyikuɔ́ kó mɛkùɔ̀ nhAnɔɔ yuu ĩ́nkɛ̀, kóò cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Kɛ̀ Mɔyiisii duɔ́ nkɛ̀ Anɔɔ bíí kɔtɛní kòo ì dɑ̀tínnɛ́ yɛkɔutɛ́yɑɑ̀bòrɛ̀ kɛ́boú inɑɑkũ̀ɔ̃ nkɛ́ bɛ̀ boú tiyɑɑ̀bomboúntì bɛ yɔ, kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Dɛ kó difɔ̃nkúò kɛ́túótɛ́ní dinɑɑdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri, Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ nɔ́ɔ́ mbɛ nɔu di yuu ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Kɛ̀ Mɔyiisi dì fèútɛ́ kɛ́pɔɔ̀tɛ̀ mɛyĩ̀ĩ̀ nho nɔ́mbii kɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì bɑ̀kɛ̀ kɛ́fítɛ́, kɛ́ dì wèńkùnnɛ kɛ́ dì cɑ̃̀ńnɛ́ kɛ̀ dì ntú mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri kɛ́cóúnko mɛsɔmmɛ diwũɔ̃tɔ̀nnì fũ̀ɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","kɛ́deè kɛ́túótɛ́ mɛkùɔ̀ mmɛ̀ɛ̀ dɑ̀ɑ́tí tinɑutì, nɛ̀ mɛ̀ɛ̀ cɑ̀ɑ́tí yɛɔ̃ nɛ̀ yɛceumbɛ̀ yɛdɛ́ nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ yɛ̀ cɑ̀ɑ́tínɛ̀ kɛ́ dɛ̀ tùɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","kɛ́túótɛ́ di kɔ̃̀nkù nɛ̀ di mɑɑ nnɛ̀ di piti kɛ́dennɛ Isidɑyɛɛribɛ kɑrì kɛ́tuɔ nti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Kɛ̀ Mɔyiisii duɔ́ nkɛ̀ bɛ̀ɛ túótɛ́ní dipedɑɑ̀ bɛ̀ yóó kuɔ dì kɛ́tuɔ. Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ nɔ́ɔ́ mbɛ nɔu di yuu ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Kɛ̀ Mɔyiisii dì fèútɛ́ kɛ́míɛ́tɛ́ mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì kɛ́fitɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","kɛ́ dì kèkɛ́ kɛ́wɛ̃nnɛ́nɛ̀ di yuu nɛ̀ di kùɔ̀ nkɛ́tuɔ, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","kɛ́ɔ́útɛ́ di nɑutì nɛ̀ di kpɑ́ɑ̀ nkɛ́ dɛ̀ wɛ̃nnɛ́ dɛmɔu kɛ́tuɔ. Dì tu fɛɔ̃̀fɛ̀ fɛ̀ɛ̀ tùɔ nfɛ̀nfɛ dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku nɑɑti ti Yiɛ̀ nKuyie, kɛ́ndònnɛ̀ kù do tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Kɛ̀ Mɔyiisii túótɛ́ dipedɑɑ̀ tɛrì ikuɔ́ nìùbɛ̀ kó mucɑ̃́nnímù kpɛri, Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ nɔ́ɔ́ mbɛ nɔu di yuu ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Kòo dì fèútɛ́ kɛ́fɛtɛ́ mɛyĩ̀ĩ̀ nhAnɔɔ tofɛ́kérì youri nɛ̀ o nɔ̀ùtɛ̀ youtɛ kó dinɔ́mbídɑɑ̀ nɛ̀ o nɑɑ̀cɛ̀tɛ̀ youtɛ kpɛri, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","kɛ́deè kɛ́yú Anɔɔ bí kɛ́fɛtɛ́ mɛyĩ̀ĩ̀ mbɛ tofɛ́kérɛ̀ youyɛ nɛ̀ bɛ nɔu yousi kó yɛnɔ́mbídɑkɛ̀ nɛ̀ bɛ nɑɑ̀cɛ̀i yousi kpɛyɛ kɛ́míɛ́tɛ́ mɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì kɛ́fitɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","kɛ́túótɛ́ mɛkùɔ̀ nnɛ̀ kuyóú nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ dɑ̀ɑ́tí tinɑutì nɛ̀ mɛ̀ɛ̀ cɑ̀ɑ́tí yɛɔ̃ nɛ̀ yɛceumbɛ̀ nɛ̀ yɛ kó mɛkùɔ̀ nnɛ̀ dikpèrì youri, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","kɛ́dɛitɛ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti, bɛ̀ pɑ̃ bɛ̀ ti Yiɛ̀ nKuyie mbɛ miɛkɛ omɑ́ɑ̀ nɛ̀ dikɑ̀tìndɑ̀ɑ̀ nɛ̀ kupɛ̃́mpɛ̃ńkù kɛ́ dɛ̀ wɛ̃nnɛ́nɛ̀ dikpèrì youri, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","kɛ́ dɛ̀ duɔ́ nhAnɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ dɛ̀ nni mbɛnkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","kɛ́deè kɛ̀ Mɔyiisii dɛ̀ cɔutɛ́ kɛ́wɛ̃nnɛ́nɛ̀ fɛɔ̃̀fɛ̀ fɛ̀ɛ̀ yóó tuɔ nkɛ́tuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀. Ikuɔ́ nìùbɛ̀ cɑ̃̀ńnímù kó fɛɔ̃̀fɛ̀ nfɛ, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku nɑɑti ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Kɛ̀ Mɔyiisii túótɛ́ dicĩ̀ncĩ̀nnì kɛ́bɛnkɛ mí ndi Yiɛ̀ nKuyie. Ikuɔ́ nìùbɛ̀ kó mucɑ̃́nnímù kó fɛpìèfɛ̀ nfɛ, kɛ̀ dɛ kó kumɑɑ ntu Mɔyiisi kɔku. Ti Yiɛ̀ nKuyie ndo ti nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Kɛ̀ Mɔyiisii túótɛ́ ikuɔ́ kó mɛkùɔ̀ nnɛ̀ mɛyĩ̀ĩ̀ mmɛ̀ɛ̀ do bo diwũɔ̃tɔ̀nnì kɛ́míɛ́tɛ́ Anɔɔ nɛ̀ o yɑ̀ɑ̀tì nɛ̀ o bí nɛ̀ i yɑ̀ɑ̀tì kɛ́ bɛ̀ cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Ò dèè mɛmmɛ kɛ́nɑ́kɛ́ Anɔɔ nɛ̀ o bí kɛ dɔ̀: Bénnɛ́nɛ̀ imɑɑ mmɛtɑummɛ̀ tou bòrìnùù kɛ́ dɛ nyì cɑ̀ɑ́kɛ́, kɛ́wɛ̃nnɛ́nɛ̀ ikuɔ́ kóo pɛ̃́ɛ̃̀, bɛ̀ ɔ̃ɔ̃ cɑ̃́nnɛ́nɛ̀ wè ikuɔ́ nìùbɛ̀, kù n nɑ̀kɛ́ kɛ yɛ̃ ndi níí dɛ̀ di mɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Imɑɑ nyìì bo súɔ́ nnɛ̀ pɛ̃́ɛ̃̀ wèè bo súɔ́ ndi dɛ̀ tùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Dí mbo mɛtɑummɛ̀ tou bòrìnùù kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀, di bɑ́ɑ́ ítɛ́ dɛborɛ̀ kɛ́nkémmúnɛ̀ di cɑ̃́nnímù kó yɛwe bo deèmɛ̀. Di cɑ̃́nnímù kó yɛwe yó mbo yɛwe yɛ̀yiekɛ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Ti Yiɛ̀ nKuyie nkuù yɛ̃ ntí dɔɔ̀, ti mɛ̀ ndɔ̀ɔ̀mɛ̀ yíe. Di yɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ nyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Dí mbo mɛtɑummɛ̀ tou bòrìnùù kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀ nɛ̀ dɛyènnɛ̀ dɛ̀yiekɛ̀ kɛ dɔɔri ti Yiɛ̀ nKuyie ndi nɑ̀kɛ́ tì, kɛ̀ dɛ̀ɛ yie nkɛ̀ di bɑ́ɑ́ kú. Kù n nɑ̀kɛ́ dìì nùù ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ɛ dɔɔ̀ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ Mɔyiisi kɛ yɛ̃ mbɛ̀ɛ dɔɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Diyiè niínnì yiè kɛ̀ Mɔyiisii yú Anɔɔ nɛ̀ o bí nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","kɛ́nɑ́kɛ́ Anɔɔ kɛ dɔ̀: Wɑɑnní dinɑɑdɑbii mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri nɛ̀ dipedɑɑ̀ ɑ yóó féútɛ́ dì ti Yiɛ̀ nKuyie nkɛ́tuɔ. Dɛdɛ́ kɛ̀ dɛ̀ ntú dɛ̀ɛ̀ kpɑ kuyɛ̀nkù, kɑ̀ɑ dɛ̀ tɔní mɛtɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Kɑ̀ɑ dèè ɑ nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀: Wɑɑ́nnɛ̀ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri nɛ̀ dinɑɑdɑbii nɛ̀ dipedɑbii dɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀, kɛ kpɑ kuyɛ̀nkù kɛ́ dɛ̀ fèútɛ́ ti Yiɛ̀ nKuyie nkɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Kɛ̀ di dèè di tɔní dinɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀ mɛtɑummɛ̀ kpɛyɛ kɛ́ yɛ̀ nkù fèútɛ́ mɛtɑummɛ̀ tou ììkɛ̀ kɛ́wɑɑ́ nnɛ̀ muyuo mmùù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀. Yíe nkù yóó di bɛnkɛmu ku mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Kɛ̀ bɛ̀ɛ wɑɑnní Mɔyiisi yɛ̃ mbɛ̀ɛ wɑɑnní dɛ̀ kɛ́deè kɛ́tíínní bɛmɔu mɛtɑummɛ̀ tou ììkɛ̀ kɛ́ncómmú. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Kɛ̀ Mɔyiisi dɔ̀: Ntɛ ti Yiɛ̀ nKuyie nyɛ̃ ndí dɔɔ̀mɛ̀ kɛ́yɑ̀ ku kpetì. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Kɛ̀ Mɔyiisii nɑ́kɛ́ Anɔɔ kɛ dɔ̀: Tɔ́ɔ́nní diwũɔ̃tɔ̀nnì borɛ̀ kɛ́féútɛ́ ɑ ɔ̃̀fɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kɔfɛ kɛ́féútɛ́ fɛtɛfɛ̀ kɛ́tuɔ, kɛ́dɔɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ ɑ mɔ́mmuɔ nkpɛ́í nnɛ̀ ɑ cĩ́ɛ̃̀tɛ̀ kɔbɛ kpɛ́í. Kɑ̀ɑ dèè ɑ féútɛ́ bɛnìtìbɛ̀ yɛi ncĩ́ɛ̃́mmɛ̀ kɔfɛ, kɛ́ bɛ̀ dɔɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́, kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie mbɛ́immɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Kɛ̀ Anɔɔ tɔ́ɔ́nní diwũɔ̃tɔ̀nnì borɛ̀ kɛ́féútɛ́ ti Yiɛ̀ nKuyie ndinɑɑdɑbii o mɔ́mmuɔ nho yɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Kòo bíí ò duɔ́ mmɛyĩ̀ĩ̀ nkòo pɔɔ̀tɛ̀ o nɔ́mbifɛ kɛ́fɛtɛ́ diwũɔ̃tɔ̀nnì bɑ̀kɛ̀, kɛ́deè kɛ́cóúnko mɛsɔmmɛ di fũ̀ɔ̃̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","kɛ́dɛitɛ mɛkùɔ̀ nkpɛrɛ nɛ̀ yɛceumbɛ̀ nɛ̀ yɛ kùɔ̀ nnɛ̀ yɛɔ̃ kɔ̃mɛ, kɛ́ dɛ̀ tùɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Kɛ̀ bɛ̀ɛ dennɛ imɑɑ nnɛ̀ kukɔ̃̀nkù Isidɑyɛɛribɛ kɑrì kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Kɛ̀ Anɔɔ féútɛ́ dipedɑɑ̀ bɛ̀ yóó tuɔ ndì, kòo bíí ò duɔ́ ndi yĩ̀ĩ̀ nkòo míɛ́tɛ́ diwũɔ̃tɔ̀nnì kɛ́fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Kɛ̀ bɛ̀ɛ ò duɔ́ ndɛ kó fɛɔ̃̀fɛ̀ kó imɑɑ nnɛ̀ diyuu, kòo dɛ̀ wɛ̃nnɛ́ kɛ́tuɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","kɛ́ɔ́ú tinɑutì nɛ̀ yɛkpɑ́ɑ̀ nkɛ́wɛ̃nnɛ́nɛ̀ fɛɔ̃̀fɛ̀ fɛ̀ɛ̀ yóó tuɔ nkɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Ò bɛnkɛ dìì mɔ̀nnì ti Yiɛ̀ nKuyie mbɛnìtìbɛ̀ kù pɑ̃ yɛ̀ɛ̀ pɑ̃rɛ̀ kɛ́deè kɛ́túótɛ́ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri kɛ́ dì fèútɛ́ ò do fèútɛ́ mɛ̀ɛ̀ botí diketirì, ");
INSERT INTO tbzsim_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","kɛ́tuɔ ndɛ kó iwũɔ̃ idɛ́ ikuɔ́ yɛ̃mmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","kɛ́túótɛ́ní bɛ̀ pɑ̃ mùù yuo nti Yiɛ̀ nKuyie nkɛ́yɛ̃tɛ́ kɛ́cóú ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀ nɛ̀ iwũɔ̃ bɛ̀ ɔ̃ɔ̃ fíé ì bɑ́ dìì kṹnweńnì kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Mɛm̀mɛ ò fèútɛ́mɛ̀ bɛnìtìbɛ̀ tɔní dìì nɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀ mɛtɑummɛ̀ kpɛ́í kòo bíí ò duɔ́ mmɛyĩ̀ĩ̀ nkòo míɛ́tɛ́ diwũɔ̃tɔ̀nnì kɛ́fitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Dɛ kó dinɑɑdɑɑ̀ kó mɛkùɔ̀ nnɛ̀ dipedɑɑ̀ kɔ̃mɛ nɛ̀ kuyóú nɛ̀ ku kó mɛkùɔ̀ nnɛ̀ yɛceumbɛ̀ nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ cɑ̀ɑ́tínɛ̀ yɛɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Kòo dɛ̀ dɑɑ́ nyiwũɔ̃ idɛ́ inyi kó yɛcĩ̀ncĩ̀rɛ̀ ĩ́nkɛ̀, kɛ́deè kɛ́ dɛ̀ tùɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","kɛ́túótɛ́ dɛ kó yɛcĩ̀ncĩ̀rɛ̀ nɛ̀ dikpèrì youri kɛ́ dɛ̀ bɛnkɛ ti Yiɛ̀ nKuyie nkù do tì nɑ̀kɛ́mɛ̀ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Kɛ̀ Anɔɔ fíé ti Yiɛ̀ nKuyie nyiwũɔ̃ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, nnɛ̀ ìì yóó tuɔ mmɛtɑummɛ̀ kpɛ́í, kɛ́youtɛ o nɔu bɛnìtìbɛ̀ bíɛ́kɛ̀ kɛ́ bɛ̀ pɑ̃ ti Yiɛ̀ nKuyie nkó mɛsɑ̀ɑ̀ nkɛ́cútɛ́ní diwũɔ̃tɔ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ nɛi kɛ́tɑ mɛtɑummɛ̀ tou, kɛ́nɛi kɛ́yɛ̀nní kɛ́pɑ̃ ti Yiɛ̀ nKuyie nkó mɛsɑ̀ɑ̀ mbɛnìtìbɛ̀. Kɛ̀ Isidɑyɛɛribɛɛ yɑ̀ ti Yiɛ̀ nKuyie nkó tikpetì. ");
INSERT INTO tbzsim_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Kɛ̀ kɛĩ́nkɛ̀ kó muhɑ̃ɑ̃́ ncùtɛ́ní kɛ́tuɔ mmɛkùɔ̀ nnɛ̀ iwũɔ̃ bɛ̀ fìé ì kɛ bo tuɔ ndɛ kó diyiè. Kɛ̀ Isidɑyɛɛribɛɛ dɛ̀ yɑ̀ kɛ́ii bɛmɔu kɛ́nínkú kɛ́sĩ́nnɔ́ɔ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Anɔɔ bí Nɑdɑbu nɛ̀ Abiyu kɛ̀ bɛ̀ɛ túótɛ́ bɑ́ wè tɛsɔɔsékɛ́buutɛ kɛ́wɑɑ́ mmuhɑ̃ɑ̃́ nsɔ̃́ntíkɛ kɔ̃mu, ikuɔ́ yetɛ mù kɛ́tuɔ ntihúúntì ti Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kɛ̀ muhɑ̃ɑ̃́ nyɛ̀nní ikuɔ́ nɛntì kó kufɑ̃́ɑ̃́ nkó dibòrì kɛ́ bɛ̀ cɔ̀útɛ́ kɛ̀ bɛ̀ɛ kú ti Yiɛ̀ nKuyie ntɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Kɛ̀ Mɔyiisii nɑ́kɛ́ Anɔɔ kɛ dɔ̀: Ti Yiɛ̀ nKuyie ndo ti nnɑ́ɑ́ kù tu dìì mɔ̀nnì bɛ̀ɛ̀ kù tɔ̀kɛ́nɛ̀ kù bo bɛ̀ bɛnkɛ kù dòmmɛ̀ pɑ́í pɑ́í, kɛ̀ Isidɑyɛɛribɛ bɛmɔu nkù dɛ̀úkùnko. Kɛ̀ Anɔɔ ndò nkɑ́rɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mɛm̀mɛ kɛ̀ Mɔyiisii yú Anɔɔ cicɛ nɑntɛ̀ Usiyɛɛdi bí Mikɑyɛɛdi nɛ̀ Edisɑfɑ̃ɑ̃ kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Kɔtɛnɛ̀ kɛ́túótɛ́ di cicɛ nɑntɛ̀ bí ìì ku kɛ duɔ́ mɛtɑummɛ̀ tou bòrìnùù, kɛ́dennɛ Isidɑyɛɛribɛ kɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Kɛ̀ bɛ̀ɛ dɔɔ̀ Mɔyiisi bɛ̀ nɑ̀kɛ́ tì kɛ́ bɛ̀ tùótɛ́ nɛ̀ bɛ kuɔ́ yɑɑ̀bòrɛ̀ kɛ́dennɛ Isidɑyɛɛribɛ kɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Kɛ̀ Mɔyiisii nɑ́kɛ́ Anɔɔ bí ìì kpɑɑ́, Edeɑsɑɑ nɛ̀ Itɑmɑɑ kɛ dɔ̀: Di bɑ́ɑ́ yóu kɛ̀ di yùtìi yɛ̃kɛ́. Di mɛ mbɑ́ɑ́ kɛ̃rí di yɑɑ̀bòrɛ̀ kɛ bo bɛnkɛ di kɑrimɛ̀ mukṹṹ di yɑ̀ɑ̀ bo kú kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛɛ pɛikɛ Isidɑyɛɛribɛ bɛmɔu. Isidɑyɛɛribɛ sɔmbɛ bɛɛ̀ yóó kɔmmú ti Yiɛ̀ nKuyie nkùɔnɛ̀ bɛ̀ muhɑ̃ɑ̃́ mbɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Díndi bɑ́ɑ́ ítɛ́ mɛtɑummɛ̀ tou bòrìnùù di yɑ̀ɑ̀ bo kú! Bɛ̀ di còú nyikuɔ́ kó mɛkùɔ̀ mmɛ kɛ di cɑ̃̀ńnɛ́ ti Yiɛ̀ nKuyie ntɔ̃mmú kpɛ́í. Kɛ̀ bɛ̀ɛ yie nkɛ́dɔɔ̀ Mɔyiisi bɛ̀ nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","Fɔ̃́ nnɛ̀ ɑ bí kɛ̀ di níí kɔri mɛtɑummɛ̀ tou di bɑ́ɑ́ yɑ̃̀ dìfɛ̃́ɛ̃̀ yoo mɛnɑɑ̀ ntɛ̃mɛ̀ mɑmɛ̀ mɛ̀ɛ̀ muɔ̀ nkɛ̀ dɛ̀ɛ yie nkɛ̀ di bɑ́ɑ́ kú. Dɛ yó ntú ikuɔ́ nyi di kpɛ́í nnɛ̀ di yɑɑ̀bío sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Kɛ̀ dɛ̀ɛ yie nkɛ̀ di nɑ kɛ́mbɑɑ̀tì dɛ̀ɛ̀ tu n kpɛrɛ, nɛ̀ dɛ̀ɛ̀ í tú n kpɛrɛ. Dɛ̀ɛ̀ ci nɛ̀ dɛ̀ɛ̀ í ci, ");
INSERT INTO tbzsim_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","kɛ́nɑ kɛ́bɛnkɛ Isidɑyɛɛribɛ bɛmɔu n duɔ́ nyìì tié mMɔyiisi kòò ì ndi nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Dɛ mɔ̀nnì kɛ̀ Mɔyiisii nɑ́kɛ́ Anɔɔ nɛ̀ o bí ìì kpɑɑ́ Edeɑsɑɑ nɛ̀ Itɑmɑɑ kɛ dɔ̀: Kɛ̀ bɛ̀ pɑ̃ ti Yiɛ̀ nKuyie ntidiitì, kɛ tùɔ ntìì kpɑɑ́ di kpɛti nti. Dí cɑ́ɑ́kɛ́ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti diwũɔ̃tɔ̀nnì borɛ̀, bɛ̀ bɛ̀ nkù pɑ̃mu, kɛ̀ dɛ̀ cɑ̃̀ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Di bɑ́ nkɑri sɔ̃́ntíkoo kó dibòrì kóò cɑ̀ɑ́kɛ́, kɛ yɛ̃́ bɛ̀ kù pɑ̃ tìì diitì miɛkɛ nkɛ kù dɛ̀itɛmɛ̀ kɛ di duɔ́. Kù ti nni nnɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Di níí cɑ́ɑ́kɛ́ dicĩ̀ncĩ̀nnì bɛ̀ bɛnkɛ dì Kuyie nnɛ̀ dikpèrì bɛ̀ dɛ̀itɛ dì, di bɑ́ɑ́ kɑri sɔ̃́ntíkoo kó dibòrì kɛ́ dɛ̀ cɑ̀ɑ́kɛ́. Bɛ̀ kù fìé ìì wũɔ̃ mɛtɑummɛ̀ kpɛ́í nyi miɛkɛ nkɛ bɛ̀ dɛ̀itɛmɛ̀ kɛ dì duɔ́. A bí initipoì bo nɑ kɛ di wɛ̃nnɛ́nɛ̀ kɛ́ ì cɑ̀ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Dicĩ̀ncĩ̀nnì bɛ̀ kù bɛnkɛ dì nɛ̀ dikpèrì bɛ̀ dɛ̀itɛ dì bɛ̀ níí dɛ̀ wɛ̃nnɛ́nɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ yóó tuɔ nkɛ́ dɛ̀ bɛnkɛ Kuyie nkɛ́deè, kɛ̀ dí dɛ̀ tùótɛ́ fɔ̃́ nnɛ̀ ɑ bí, di kpɛrɛ yó nni ndɛ sɑ̃́ɑ̃̀, kù ti nni nnɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Kɛ̀ Mɔyiisii bɛ̀ bekɛ bɛ̀ yĩ́mɛ̀ dibɔdɑɑ̀ bɛ̀ do kùɔ dì mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í. Kɛ̀ bɛ̀ɛ ò nɑ̀kɛ́ kɛ dɔ̀ bɛ̀ dì tùɔmmu, kòo miɛkɛɛ pɛikɛ Anɔɔ bí ìì kpɑɑ́, Edeɑsɑɑ nɛ̀ Itɑmɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","Kòo bɛ bekɛ kɛ dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di í kɑri bɛ̀ tɑ̃ɑ̃tɛ́ dìì bòrì dɛ kpɛ́í nkɛ dì cɑ̀ɑ́kɛ́. Kɛ yɛ̃́ bɛ̀ dì pɑ̃mɛ̀ ti Yiɛ̀ nKuyie nku kɛ̀ dì cɑ̃̀ɑ̃́, kɛ̀ di dì dɔ̀ɔ̀nɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́, kɛ dɛ̀itɛ Isidɑyɛɛribɛ kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Di í mɛ ntɑnnɛ́mɛ̀ mɛyĩ̀ĩ̀ mmɛtɑummɛ̀ tou di nɑ nkɑ̀ri dibòrì bɛ̀ tɑ̃ɑ̃tɛ́ dìndi dɛ kpɛ́í nkɛ dì cɑ̀ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Kɛ̀ Anɔɔ nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Bɛ̀ dì fèútɛ́ ti Yiɛ̀ nKuyie nku mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í nkɛ tùɔ. A mɔ́mmuɔ nhɑ yɛ̃́mu tìì n tùɔ̀kɛní kɛ̀ n cɑ̀ɑ́kɛ́ yíe nfɛɔ̃̀fɛ̀ bɛ̀ kùɔ fɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, dɛ̀ bo nɑrikɛ ti Yiɛ̀ nKuyie nnɑɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Kɛ̀ Mɔyiisi nsɔ̃́ ndɛ kó tinɑ́ɑǹtì wenni. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","Nɑ́kɛ́nɛ̀ Isidɑyɛɛribɛ kɛ dɔ̀ n tú: Ntɛnɛ̀ iwũɔ̃ nɛ̀ tiwɑnwɑntì di yó nyo ndɛ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Fɛɔ̃̀fɛ̀ yoo kuwɑnwɑnkù dɛ̀ɛ̀ kó yɛkpɛ̀ɛ̀tɛ̀ yɑ̀tɛ yɛ̀dɛ́ɛ̀ kɛ̀ dɛ̀ dukii, di bo nɑ kɛ́ ndɛ̀ yo, ");
INSERT INTO tbzsim_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","iwũɔ̃ yoo tiwɑnwɑntì dɛ̀ɛ̀ mɔ̀kɛ yɛkpɛ̀ɛ̀tɛ̀ kɛ dùkii. Ntɛ di yó nci dɛ̀: Di bɑ́ nyo nyòyó bɑ́ nɛ̀ ò mɛ ndukiimɛ̀ o kpɛ̀ɛ̀tɛ̀ í yɑ̀tɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Di bɑ́ nyo ndisetiri bɑ́ nɛ̀ di mɛ ndukiimɛ̀ dì í mɔkɛ yɛkpɛ̀ɛ̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Di bɑ́ nyo ntɛhòntɛ̀ bɑ́ nɛ̀ tɛ̀ mɛ ndukiimɛ̀ tɛ í mɔkɛ yɛkpɛ̀ɛ̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Di bɑ́ nyo ndifɔ̃̀nkɛ̀rì bɑ́ di mɛ mmɔkɛmɛ̀ yɛkpɛ̀ɛ̀tɛ̀ kɛ̀ yɛ̀ yɑ̀tɛ, dì í dukii, ikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Di bɑ́ ndɛ̀ yo nkɛ̀ dɛ̀ mɛ nku di bɑ́ɑ́ dɛ̀ kɑ̀ɑ́kɛ́, ikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Ntɛ tiwɑnwɑntì mɛniɛ mmiɛkɛ kpɛti di bo nyo ntì: Siyĩĩ sìì kó dimɑ̀ɑ̀ mɔ̀kɛ icietí nɛ̀ yɛyíɛ́kɛ̀ kɛ̀ sì bo mɛniɛ mmiɛkɛ, dɑ̀mɛ́ɛ̀rì yoo ikó mmiɛkɛ di bo nɑ kɛ́ nsì yo. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Sìì mɛ nyí mɔkɛ icietí nɛ̀ yɛyíɛ́kɛ̀ kɛ bo dɑmɛ́ɛ̀rì miɛkɛ yoo ikó mmiɛkɛ, nɛ̀ dɛsĩ́ntɛ́kpɛrɛ mɛniɛ mmiɛkɛ kpɛrɛ, di bɑ́ ndɛ̀ yo ikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Di bɑ́ ndɛ̀ yo nkɛ̀ dɛ̀ mɛ nku di bɑ́ɑ́ dɛ̀ kɑ̀ɑ́kɛ́, ikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Tiwɑnwɑntì tìì kó dimɑ̀ɑ̀ bo mɛniɛ mmiɛkɛ kɛ í mɔkɛ icietí nɛ̀ yɛyíɛ́kɛ̀ ikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Sinɔɔ miɛkɛ, ntɛ di yó nci sì, di bɑ́ nsì yo ikuɔ́ dɛ̀ yetɛmu: Kumɑncònkù nɛ̀ ditúsɔ̀ù nɛ̀ dɑ̀mɛ́ɛ̀rì kó fɛtúúfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","Kuwɑ̀nkù nɛ̀ kutúbotí kumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","Nɛ̀ kukɑ̃kɑ̃botí kumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","Fɛcònfɛ̀ diɛfɛ̀ nɛ̀ dihonduò nɛ̀ tɛkónnɛ́nɔ̀tɛ̀ nɛ̀ fɛcĩrifɛ nɛ̀ kucĩntibotí kumɔu, ");
INSERT INTO tbzsim_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","nɛ̀ fɛkonkpɑ̀nfɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","kucɑ́duonku nɛ̀ dikonnɛ́you nɛ̀ kuyómmúpɛ́íkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","Kutenkɑtíkɑ̀dɑ́ɑ́kù nɛ̀ kuyĩnwuokù kó kubotí kumɔu, nɛ̀ dikũntìbɑ́rì nɛ̀ kudéíkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","Yɛcɑndúɔ̀ nyɛ̀ɛ̀ mɔ̀kɛ tibɑ̀ɑ̀tì tìnɑ̀ɑ̀ kɛ í nɔ nkɛ puù, ikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Yɛcɑndúɔ̀ mmiɛkɛ di bo nyo nyɛ̀ tu: Yɛ̀ɛ̀ mɔ̀kɛ tibɑ̀ɑ̀tì tinɑ̀ɑ̀ kɛ nɔ nkɛ puù. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Di nyo nkucɑ́dɔ́mbotí kumɔu nɛ̀ fɛcofɛ nɛ̀ sibɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Dɛsɔnnɛ dɛ̀ɛ̀ mɔ̀kɛ tibɑ̀ɑ̀tì tinɑ̀ɑ̀ ikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Iwũɔ̃ bomu nɛ̀ tiwɑnwɑntì kɛ̀ dɛ̀ ku kɑ̀ɑ dɛ̀ kɑ̀ɑ́kɛ́ ɑ sĩ̀ntɛmu dɛ kó diyiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Kɛ̀ wèè dɛ̀ tɔ wèe ɔ́ú o yɑ̀ɑ̀tì, ò sĩ̀ntɛmu dɛ kó diyiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","Iwũɔ̃ yoo tiwɑnwɑntì dɛ̀ɛ̀ mɔ̀kɛ yɛkpɛ̀ɛ̀tɛ̀ bɑ́ yɛ̀ í yɑɑti dɛ̀ mɛ nyi dukii ikuɔ́ dɛ̀ yetɛmu. Kɛ̀ wèè dɛ̀ kɑ̀ɑ́kɛ́ ò sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Iwũɔ̃ yoo tiwɑnwɑntì dɛ̀ɛ̀ mɔ̀kɛ itɑ̀ɑ̀kɛ ìnɑ̀ɑ̀ kɛ centì dɛ nɑɑ̀cɛ̀i yómmɛ̀ ikuɔ́ dɛ̀ yetɛmu. Kɛ̀ wèè dɛ̀ kɑ̀ɑ́kɛ́ ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Ikuɔ́ dɛ̀ yetɛmu, kɛ̀ wèè dɛ̀ kɑ̀ɑ́kɛ́ wèe ɔ́ú o yɑ̀ɑ̀tì, o sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Ntɛ tiwɑnwɑntì tìì bɑ̀ɑ̀ntɛ di yó nci tì: Tɛkɔ̀cɑ̃̀ɑ̃̀tɛ̀ nɛ̀ diyíù nɛ̀ kuhurímbotí kumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","Didukpɛ̃nnì nɛ̀ dikpeunnì nɛ̀ dikũri nɛ̀ kudɑɑ̀tìkonkonkù nɛ̀ kuwɑ̀ɑ̀tóntónkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Tiwɑnwɑntì miɛkɛ di bɑ́ nyo ndɛ kó tiwɑnwɑntì, kɛ̀ kùmɑkù ku kɛ̀ wèè kù kɑ̀ɑ́kɛ́ ò sĩ̀ntɛmu dɛ kó diyiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Kɛ̀ dɛ kó kuwɑnwɑnkù mɑkù ku kɛ kɑ̀ɑ́kɛ́ kunɛnkù mɑkù, dɛ kó kunɛnkù sĩ̀ntɛmu, tinɛntì idɛí kpɛti nɛ̀ tiyɑ̀ɑ̀tì nɛ̀ kukɔ̃̀nkù nɛ̀ tidɔutì tinɛmpĩ́mpĩ́ntì timɔu bɑ́ kɛ̀ kùù nɛnkù botí nku. Dí kù ɔ̀útɛ́ kɛ̀ kù nsĩ̀ ndɛ kó diyiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. Dɛ kó difɔ̃nkúò kɛ́wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Kɛ̀ dɛ kó kuwɑnwɑnkù mɑkù tɑ kunɛnkù titɑ̃́tì kɔku miɛkɛ dí kù pɔ̀ntɛ. Dɛ̀ɛ̀ bo ku miɛkɛ di bɑ́ɑ́ dɛ̀ di, dɛ̀ sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Kɛ̀ bɛ̀ mɛ nyɛ̃ntɛ́nɛ̀ dɛ kó kunɛnkù mɑkù mɛniɛ nkɛ ɑ̃nnɛ́ tidiitì bɛ̀ yo ntì, tì sĩ̀ntɛmu bɑ́ kɛ̀ mɛnɛ́sɑ̀ɑ̀mɛ̀ mmɛ bɛ̀ yɔ̃̀ mmɛ̀ mɛ̀ sĩ̀ntɛmu, bɑ́ kɛ̀ mɛ̀ ɑ̃ kùù nɛnkù botí miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Kɛ̀ dɛ kó tiwɑnwɑntì kó kùmɑkù do kunɛnkù mɑkù miɛkɛ kù sĩ̀ntɛmu, kɛ tɛfiuntɛ̀ miɛkɛ nkɛ yoo kɛdɛkɛ̀ mɑkɛ̀ dí dɛ̀ pɔ̀ntɛ, dɛ̀ sĩ̀ntɛmu kɛ yó ntú dɛ̀ɛ̀ sĩ̀ ndi kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Kɛ̀ dɛ̀ mɛ ndò nkuwɑnwɑnkù mɑkù do kufɔ̃̀tìkù yoo tɛbintɛ yoo kubinku mɑkù, mɛniɛ mmiɛ yó nwennimu, wèè kù wuotɛ́ weè sĩ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Kɛ̀ kù mɛ ndo tidibotì miɛkɛ nkɛ, tì yó nkpɑɑ́ kɛ wennimu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Kɛ̀ dɛ̀ mɛ nsɔ̃́ mbɛ̀ tì búú nkɛ bo dimu, tì sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Bɑ́ kɛ̀ kuwɑnwɑnkù di yo nkùnku, kɛ̀ kù ku kɛ̀ wèè kù kɑ̀ɑ́kɛ́ ò sĩ̀ntɛmu dɛ kó diyiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Kɛ̀ wèè kù cɑ̀ɑ́kɛ́ wèe ɔ́ú o yɑ̀ɑ̀tì, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku, wèè kù tùótɛ́ wèe ɔ́ú o yɑ̀ɑ̀tì, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","Dɛbɑmbɑɑ̀nnɛ̀ kó dimɑ̀ɑ̀ di bɑ́ ndɛ̀ yo nyikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Dɛ̀ɛ̀ kó dimɑ̀ɑ̀ fũrì dɛ pɔutì ĩ́nkɛ̀ nɛ̀ dɛ̀ɛ̀ bɑ̀ɑ̀ntɛ, dɛbɑmbɑɑ̀nnɛ̀ kó dimɑ̀ɑ̀ cɛ̃́nkɛ, di bɑ́ ndɛ yo, ikuɔ́ dɛ̀ yetɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Di bɑ́ɑ́ ɑ̃nnɛ́ dimɑ́ɑ̀ isɔkɛ nɛ̀ dɛ kó dɛbɑmbɑɑ̀nnɛ̀ yoo di yóu kɛ̀ dɛ̀ di sĩnkùnnɛ di bɑ́ɑ́ yóu kɛ̀ dɛ̀ di cɑkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Mí ndi Yiɛ̀ nKuyie mmíì di te kɛ̀ di dò nkɛ́ncɑ̃́ɑ̃́ nkɛ tú n kɔbɛ kɛ dò mpɑ́íí n dòmmɛ̀ pɑ́íí, di bɑ́ɑ́ yóu kɛ̀ dɛ kó dɛbɑmbɑɑ̀nnɛ̀ kó dɛ̀mɑrɛ̀ di sĩnkùnnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Mí ndi Yiɛ̀ nKuyie míì di dènnɛní Esibiti, kɛ bo ndi te, ńdònnɛ̀ pɑ́íí kɛ yɛ̃́ n dòmmɛ̀ pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Kuyie mbɛ̀ duɔ́ nyìì kuɔ́ nyi, iwũɔ̃ nɛ̀ tiwɑnwɑntì nɛ̀ sinɔɔ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo mɛniɛ mmiɛkɛ nɛ̀ dɛbɑmbɑɑ̀nnɛ̀ dɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Iì kuɔ́ yó nte kɛ̀ bɛ̀ mbɑɑ̀tì dɛ̀ɛ̀ ci nɛ̀ dɛ̀ɛ̀ í ci, bɛ̀ bo nyo ndɛ̀ nɛ̀ bɛ̀ bo nci dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nní nsɔkɛ́ ku nɑ́ɑǹtì kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú: Kòo nitipòkù pɛitɛ́ dɛnitidɑbirɛ ò sĩ̀ntɛmu kɛ́ntɔ kɛ́tuɔkɛnɛ̀ yɛwe yɛ̀yiekɛ̀, kɛ́ndònnɛ̀ ò ɔ̃ nyúɔ́ nkɛ dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Diyiè niínnì yiè bɛ̀ɛ cɑ̃ntɛ́ dɛbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Dɛ kó difɔ̃nkúò kòo mbɑɑ̀ yɛwe sipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀tɑ̃ɑ̃ti kòo nɛ́ nɑ kɛ́wenkɛ. Dɛ kó yɛwe miɛkɛ ò bɑ́ɑ́ kɑ́ɑ́kɛ́ dɛ̀ɛ̀ cɑ̃̀ɑ̃́ nkɛ tú n kpɛrɛ, ò mɛ mbɑ́ɑ́ kɔtɛ n tɑummɛ̀ tou, kɛ́mbɑɑnɛ̀ dɛ kó yɛwe bo deèmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Kòò mɛ mpɛitɛ́ dɛnitipobirɛ ndɛ ò sĩ̀ntɛmu kɛ́ntɔ kɛ́tuɔkɛnɛ̀ semɛ́nnì bɛ̀dɛ́bɛ̀ kɛ́ndònnɛ̀ ò ɔ̃ nyúɔ́ nkɛ dòmmɛ̀. Dɛ kó difɔ̃nkúò kɛ́mbɑɑ yɛwe sipísìkuɔ̀ nɛ̀ yɛkuɔ̀ kòo nɛ́ nɑ kɛ́wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Kɛ̀ dɛ kó yɛwe pɛ̃ɛ̃tɛ́, kɛ̀ dɛnitidɑbirɛ ndɛ yoo dɛnitipobirɛ, wèe tɔní dipedɑbii dìì mɔ̀kɛ dibenni dìmɑ́ɑ̀, ò yó n kùɔ dì kɛ́tuɔ, kɛ́duɔ́ nyikuɔ́ nìùtì mɛtɑummɛ̀ tou bòrìnùù, kɛ́wɑɑ́nnɛ̀ dikpɛtinɔ́nkperi yoo tɛnɔ́nkpetɛ tɛ̀ɛ̀ yó ntú mɛwénkùmɛ̀ kpɛtɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Kɛ̀ ikuɔ́ nìùtìi dɛ̀ nni mbɛnkɛ, kɛ́dɔɔ̀ mɛwénkùmɛ̀ kó ikuɔ́ kòo wenkɛ. Ikuɔ́ ìì tukúnɛ̀ ìnyi onitipòkù wèè pɛitɛ́ dɛnitidɑbirɛ yoo dɛnitipobirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Kòò í nɑ kɛ bo pɛ́tɛ́ dipedɑbii wèe wɑɑ́ nyɛkpɛtinɔ́nkperɛ yɛ̀dɛ́ɛ̀ yoo sinɔ́nkpeé, kɛ̀ tɛ̀mɑ́ɑ̀ ntú bɛ̀ yó n féútɛ́ tɛ̀ kɛ́tuɔ, nkɛ̀ tɛtɛtɛ̀ ntú mɛwénkùmɛ̀ kpɛtɛ. Kɛ̀ ikuɔ́ nìùtìi ò dɔ̀ɔ̀ mɛwénkùmɛ̀ kó ikuɔ́ kòo nɑɑ́ nwèè nɔ̀ùtɛ̀ feitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́innɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","Kɛ̀ dimutiri mɑrì yɛ̀nní onìtì kɔ̃̀ntì kɛ dò ntɛcɛ̀tɛ̀ yoo tinɑɑndotì, kɛ̀ di sɔ̃́ ndɛ̀ dò ntikɔ̀ntì, dí ò kɔ̀tɛnɛ̀ ikuɔ́ nìùtì Anɔɔ borɛ̀, yoo o bí ikuɔ́ nìùbɛ̀ kóò mɔù borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Kɛ̀ ikuɔ́ nìùtìi wéntɛ́ dɛ kó mumɔmmú mùù bo o kɔ̃̀ntì ĩ́nkɛ̀ kɛ̀ dɛborɛ̀ kó ticìtì cèètɛ kɛ pɛikɛ, kɛ̀ dɛborɛ̀ sɑ̃́kɛ nɑɑ́ ntɛfɔ̃̀tɛ̀, tikɔ̀ntì nti ò mɔmmɛ̀, ikuɔ́ nìùtìi ò nɑ̀kɛ́ kɛ tú o mɔmmú tú musĩ̀mmù mmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Kɛ̀ dɛ̀ mɛ ndò ndɛ kó diciitirì pɛ́ì mɑ́ɑ̀ ndi, bɑ́ dɛborɛ̀ í do ntɛfɔ̃̀tɛ̀, bɑ́ ticìtì í pɛikɛ, ikuɔ́ nìùtìi ò cɑ̃̀ńnɛ́ omɑ́ɑ̀ kɛ̀ dɛ̀ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Diyiè yiénnì yiè kòo wɛ̃tɛ kóò wèńtɛ́, kòò sɔ̃́ ndɛ kó mumɔmmú bɑɑ dò mmu dòntì kɛ í pɛ̃̀kɛ̀, wèe wɛ̃tɛ kóò kɑ̀nnɛ kɛ̀ dɛ̀ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Kòo wɛ̃tɛ kóò wèńtɛ́ diyiè yiénnì yiè, kòò sɔ̃́ ndɛ̀ tɔ̃ũkɛ kɛ í pɛ̃̀kɛ̀, wèe ò nɑ̀kɛ́ kɛ tú o mɔmmú í tú musĩ̀mmù. Dɛ̀ tu tɛcɛ̀tɛ̀ ntɛ cɛ̃́nkoo, wèe ɔ́útɛ́ o yɑ̀ɑ̀tì mɑ́ɑ̀ ndi kɛ́wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Kɛ̀ ikuɔ́ nìùtì ò nɑ̀kɛ́ kɛ tú o mɔmmú í tú musĩ̀mmù, kòò ítóo kɛ̀ dɛ kó tɛwũɔ̃tɛ̀ pɛ̃̀kɛ̀, wèe wɛ̃tɛ kɛ́bɛnkɛ omɑ́ɑ̀ ikuɔ́ nìùtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Kòo ò wèńtɛ́ kòò sɔ̃́ ndɛ kó tɛwũɔ̃tɛ̀ pɛ̃̀kɛ̀, wèe ò nɑ̀kɛ́ kɛ dɔ̀: A mɔmmú tú tikɔ̀ntì nti, ɑ sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Kɛ̀ tikɔ̀ntì feitɛ́ òmɔù, bɛ̀ɛ ò kɔ̀tɛnɛ̀ ikuɔ́ nìùtì borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Kòo ò wèńtɛ́, kòò sɔ̃́ ndinútírì mɑrì ɑ̃nnɛ́ o kɔ̃̀ntì, kɛ̀ ticìtì wũɔ̃tɛ́ dɛborɛ̀ kɛ̀ dɛ̀ tɔ̀tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","Dɛ kó mumɔmmú ò bimu. Ikuɔ́ nìùtìi ò nɑ̀kɛ́ kɛ dɔ̀ ò sĩ̀mmu, ò bɑ́ɑ́ bennɛ́ kóò cɑ̃̀nnɛ́ omɑ́ɑ̀ borɛ̀ kɛ bo ò wèńní ò sĩ̀mmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Kɛ̀ dɛ kó inútíbí mɛ mpitɛ́ o kɔ̃̀ntì timɔu ĩ́nkɛ̀, o yuu nɛ̀ o nɑɑ̀cɛ̀io, ikuɔ́ nìùtì bo nɑ kɛ́wéntɛ́ dɛ̀ɛ̀ kó dimɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","Kòò wèńtɛ́ kɛ sɔ̃́ ndɛ kó mumɔmmú bo o kɔ̃̀ntì timɔu ndi wèe ò nɑ̀kɛ́ kɛ dɔ̀ ò í sĩ̀. Kɛ yɛ̃́ o kɔ̃̀ntì timɔu tiì pɛikɛmɛ̀, ò í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Kɛ̀ dɛ̀ mɛ mboní kɛ̀ dɛ̀mɑrɛ̀ tɔ̀tɛ́ kɛ nɑɑ́ ndɛmɔnnɛ ò sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Kɛ̀ ikuɔ́ nìùtì wèńtɛ́ dɛ kó ditɔ́tírì wèe ò nɑ̀kɛ́ kɛ dɔ̀ ò sĩ̀mmu, tikɔ̀ntì nti. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Kɛ̀ dɛ kó ditɔ́tírì wɛ̃̀tɛ kɛ pɛikɛ wèe yɑ̀ ikuɔ́ nìùtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Kòo ò wèńtɛ́ kòò sɔ̃́ ndɛ kó ditɔ́tírì pɛikɛ wèe ò nɑ̀kɛ́ kɛ dɔ̀ o mɔmmú í tú musĩ̀mmù, ò í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Kɛ̀ dɛ̀ mɛ ndò ndinútírì diì yɛ̀ òmɔù kɛ miɛtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","Kɛ̀ dimutiri dii mɛ nhɑ̃nnɛ́ dinútírì do borɛ̀, kɛ dɔ́ kɛ́mpɛ́ì kɛ wɛ̃̀tɛ kɛ wũɔ̃, dɛ yiɛ̀ mbɛnkɛ omɑ́ɑ̀ ikuɔ́ nìùtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Kòò ò wèńtɛ́, kòò sɔ̃́ ntikɔ̃̀ntì dɔ́ kɛ́nɑɑ́ ntɛfɔ̃̀tɛ̀ dɛborɛ̀ kɛ̀ ticìtì pɛikɛ, wèe ò nɑ̀kɛ́ kɛ tú: Mumɔmmú sĩ̀mmù muù dɔ́ kɛ́feitɛ́ dinútírì do yɛ̀ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Kòò mɛ nhò wèńtɛ́ kɛ sɔ̃́ nticìtì í pɛikɛ, tikɔ̃̀ntì mɛ nyí nɑɑ́ ntɛfɔ̃̀tɛ̀ dɛborɛ̀ kɛ̀ dɛ̀ dɔ́ kɛ́ceetɛ, weè ò kɑ̀nnɛ kɛ̀ dɛ̀ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Kɛ̀ mù pɛ̃̀kɛ̀ o kɔ̃̀ntì wèe ò nɑ̀kɛ́ kɛ tú dɛ kó mumɔmmú tú musĩ̀mmù mmu, tikɔ̀ntì nti. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Kɛ̀ dɛ̀ mɛ ndò ndɛ̀ í pɛ̃̀kɛ̀ o kɔ̃̀ntì ĩ́nkɛ̀, dinútírì kó kufíɛ̀kù nku, wèe ò nɑ̀kɛ́ kɛ dɔ̀ ò í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Kɛ̀ dɛ̀ mɛ ndò nhòmɔù weè cɔ̀útɛ́ kɛ̀ dinútírì yɛ̀ dɛ kó kuhɑ̃ɑ̃tɔ̀ntɔ̀nkù ĩ́nkɛ̀, kɛ wɛ̃̀tɛ kɛ dɔ́ kɛ́nwũɔ̃, kɛ dɔ́ kɛ́mpɛ́ì yoo dɛ̀ pɛ́ì, ");
INSERT INTO tbzsim_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ikuɔ́ nìùtìi ò wèńtɛ́, kòò sɔ̃́ nticìtì dɔ́ kɛ́pɛikɛ yoo tikɔ̃̀ntì dɔ́ kɛ́nɑɑ́ ntɛfɔ̃̀tɛ̀ dɛborɛ̀, tikɔ̀ntì tiì ò pĩ. Ikuɔ́ nìùtìi ò nɑ̀kɛ́ kɛ dɔ̀ o mɔmmú tú musĩ̀mmù mmu, ò sĩ̀mmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Kɛ̀ dɛ̀ mɛ ndò nyikuɔ́ nìùtì ò wèńtɛ́ kɛ sɔ̃́ nticìtì í pɛikɛ dɛborɛ̀, tikɔ̃̀ntì mɛ nyí nɑɑ́ ntɛfɔ̃̀tɛ̀ dɛborɛ̀ kɛ cèètɛ kɛ pɛikɛ, wèe ò kɑ̀nnɛ kɛ̀ dɛ̀ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Diyiè yiénnì yiè wèe wɛ̃tɛ kóò wèńtɛ́, kɛ̀ dɛ kó tɛwũɔ̃tɛ̀ pɛ̃̀kɛ̀, wèe ò nɑ̀kɛ́ kɛ dɔ̀ o mɔmmú tú musĩ̀mmù mmu, ò sĩ̀mmu, tikɔ̀ntì nti. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Kɛ̀ dɛ kó tɛwũɔ̃tɛ̀ mɛ nyí dɛukɛ, kɛ dò ntɛdòntì kɛ pètìnkɛ dɔ́ kɛ́ceetɛ, muhɑ̃ɑ̃́ mmuù ò cɔ̀útɛ́ kɛ̀ dɛ̀ dɔ́ kɛ́pɛikɛ, ikuɔ́ nìùtìi ò nɑ̀kɛ́ kɛ dɔ̀ o mɔmmú í tú musĩ̀mmù, kuhɑ̃ɑ̃tɔ̀ntɔ̀nkù kó kufíɛ̀kù nku. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Kɛ̀ yɛmuɔ nhɑ̃nnɛ́ onitidɔ̀ù yoo onitipòkù yuu yoo o kúóǹnì: ");
INSERT INTO tbzsim_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","Ikuɔ́ nìùtìi wéntɛ́ dɛ kó dɛmɔnnɛ, kòò sɔ̃́ ndɛ̀ dɔ́ kɛ́nɑɑ́ ntɛfɔ̃̀tɛ̀ dɛborɛ̀, kɛ̀ ticìtì wũɔ̃tɛ́ kɛ yɛ̃ ntimɑ timɑ, wèe ò nɑ̀kɛ́ kɛ dɔ̀ o mɔmmú tú musĩ̀mmù mmu, yɛyukɔ̃̀rɛ̀ kó mumɔmmú mmu yoo dikúònnì kɔ̃mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Kɛ̀ dɛ̀ dò nyikuɔ́ nìùtì ò wèńtɛ́ kɛ sɔ̃́ nyɛyukɔ̃̀rɛ̀ í ɑ̃nnɛ́ tɛfɔ̃̀tɛ̀ dɛborɛ̀ yoo tiyùtì í sɔ̀utɛ, wèe ò kɑ̀nnɛ kòò dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Diyiè yiénnì yiè kòo ò wèńtɛ́ kòò sɔ̃́ ndɛ kó mumɔmmú í pɛ̃̀kɛ̀ tiyùtì mɛ nyí wũɔ̃tɛ́, dɛ̀ mɛ nyí nɑɑ́ ntɛfɔ̃̀tɛ̀ dɛborɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","omuɔntii kuó kɛ́soó ndɛ kó dibòrì kɛ̀ ikuɔ́ nìùtìi yíɛ́ kóò kɑ̀nnɛ kòò dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Diyiè yiénnì yiè kòò ò wèńtɛ́ kɛ sɔ̃́ mmù í pɛ̃̀kɛ̀, dɛ̀ mɛ nyí nɑɑ́ ntɛfɔ̃̀tɛ̀ dɛborɛ̀, wèe ò nɑ̀kɛ́ kɛ dɔ̀ ò wenkɛmu, kòo ɔ́ú o yɑ̀ɑ̀tì kɛ́wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Kòò mɛ nhɔ́ú o yɑ̀ɑ̀tì kɛ dèè kɛ̀ dɛ kó mumɔmmú pɛ̃̀kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Ikuɔ́ nìùtìi wɛ̃tɛ kóò wèńtɛ́ kòò sɔ̃́ ndɛ kó mumɔmmú pɛ̃̀kɛ̀ kɛ̀ tiyùtì wũɔ̃tɛ́ ò sĩ̀mmu. Ikuɔ́ nìùtì bɑ́ɑ́ bennɛ́ kɛ́nwéí tiyùtì bo wũɔ̃tɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Kɛ̀ mù í tòtɛ, kɛ bɑɑ dò mmudòntì. Kɛ̀ tiyusɔ̀ùtì yɛ̀, ò miɛtɛ́mu, ò í sĩ̀. Ikuɔ́ nìùtìi ò nɑ̀kɛ́ kɛ dɔ̀: A í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Kòo nitidɔ̀ù nwe yoo onitipòkù, kòò sɔ̃́ nho kɔ̃̀ntì ɑ̃nnɛ́ tɛpɛ́ítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","Ikuɔ́ nìùtìi ò wèńtɛ́. Kɛ̀ dɛ kó tɛpɛ́ítɛ̀ dò ntɛdòntì kɛ í cèètɛ, mùmɑmù í ò dò ntɛpɛ́ítɛ̀ tɛɛ̀ cɛ̃́nkɛ ɑ̃nnɛ́ o kɔ̃̀ntì, ò í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Kòo nìtì yuu fɔ̃ũ ò mɔ̀kɛ mɛyukɑ́nkɑ́mmɛ̀ mmɛ, ò í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Kòo tĩ́nnì kó tiyùtì tiì mɛ nfɔ̃̀ũ mɛyukɑ́nkɑ́mmɛ̀ mmɛ ò í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Kɛ̀ diciitirì mɑrì mɛ nhɑ̃nnɛ́ mɛɛ̀ yukɑ́nkɑ́mmɛ̀ miɛkɛ, kòo bɔri ndi yoo o tĩ́nnì kɛ dɔ́ kɛ́mpɛ́ì kɛ wɛ̃̀tɛ kɛ dɔ́ kɛ́nwũɔ̃, tikɔ̀ntì nti. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Ikuɔ́ nìùtìi ò wèńtɛ́, kòò sɔ̃́ ndiciitirì ɑ̃nnɛ́ o bɔri yoo o tĩ́nnì, kɛ wɛ̃̀tɛ kɛ dɔ́ kɛ́nwũɔ̃, kòò sɔ̃́ ndɛ̀ dò ntikɔ̀ntì, ");
INSERT INTO tbzsim_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","dikɔ̀nnì ndi, ikuɔ́ nìùtìi ò nɑ̀kɛ́ kɛ tú ò sĩ̀mmu, tikɔ̀ntì tiì pĩ nho yuu. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Kɛ̀ tikɔ̀ntì pĩ nwè ndɑ́ɑ́tí tiyɑ̀ɑ̀tì tìì kɛ̃rí kɛ yóu kòò yùtìi yɛ̃kɛ́ kòo nkɑ̃nkɛ́ o nucìtì, kɛ pĩɛ̃kù kɛ tú: N sĩ̀mmu! N sĩ̀mmu! ");
INSERT INTO tbzsim_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Kɛ̀ dɛ kó mumɔmmú kpɑɑ́ koò bo yɛ̀ɛ̀ we miɛkɛ ò yó sĩ̀mmu, ò bɑ́ mbo Isidɑyɛɛribɛ kɑrì, ò mbo mɛkɛntímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","Kɛ̀ tiyɑ̀ɑ̀tì bɛ̀ dùɔ̀kɛnɛ̀ tì tipecìtì yoo mupɑɑ̀konkperímù kɛ̀ tì pũ̀ũti. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","Kɛ̀ dɛ̀ tu kuyɑ̀ɑ̀kù yoo kuyɑɑ̀dɑ́ndɑ́tínkù nku bɛ̀ dùɔ̀kɛnɛ̀ kù tipecìtì yoo mupɑɑ̀konkperímù, kɛ̀ dɛ̀ mɛ ntú kukɔ̃̀nkù nku yoo kunɛnkù mɑkù bɛ̀ dɔ̀ɔ̀nɛ̀ kù kukɔ̃̀nkù, ");
INSERT INTO tbzsim_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","dɛɛ̀ pũ̀ũti kuyɑ̀ɑ̀kù ĩ́nkɛ̀ yoo kukɔ̃̀nkù yoo kuyɑɑ̀dɑ́ndɑ́tínkù yoo kunɛnkù kukɔ̃̀nkù kɔku ĩ́nkɛ̀, kɛ̀ dɛ̀ dò mmɛnɔ́ɔnnúɔ̀ nyoo dɛ̀ dɔ́ kɛ́ nwũɔ̃, bɛ̀ɛ dɛ̀ bɛnkɛ ikuɔ́ nìùtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Kòo wéntɛ́ dɛ kó kunɛnkù pũ̀ũti dɛ̀, kɛ́ kù dɔú nkumɑ́ɑ̀ kɛ̀ dɛ̀ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Diyiè yiénnì yiè kòò sɔ̃́ ndɛ̀ pɛ̃̀kɛ̀ dɛ kó kuyɑ̀ɑ̀kù ĩ́nkɛ̀ yoo kuyɑɑ̀dɑ́ndɑ́tínkù yoo kukɔ̃̀nkù yoo kunɛnkù mɑkù bɛ̀ dɔ̀ɔ̀nɛ̀ kù kukɔ̃̀nkù, bɑ́ kɛ̀ dɛ kó kunɛnkù tu kùù botí dɛ̀ í yóó deè, dɛ kó kunɛnkù sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Ikuɔ́ nìùtìi tuɔ ndɛ kó kuyɑ̀ɑ̀kù, yoo kuyɑɑ̀dɑ́ndɑ́tínkù kùù dùɔ̀kɛnɛ̀ tipecìtì, yoo mupɑɑ̀konkperímù, kɛ̀ dɛ̀ mɛ ntu kukɔ̃̀nkù kó kunɛnkù mɑkù nku, bɑ́ kɛ̀ kù tu kùù botí kɛ nɛ́ pũ̀ũti dɛ̀ í yóó deè bɛ̀ɛ kù tùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Kɛ̀ ikuɔ́ nìùtì mɛ nsɔ̃́ ndɛ̀ɛ̀ pũ̀ũti dɛ̀ í pɛ̃̀kɛ̀ kuyɑ̀ɑ̀kù yoo kuyɑɑdɑ́ndɑ́tínkù yoo kunɛnkù bɛ̀ dɔ̀ɔ̀nɛ̀ kù kukɔ̃̀nkù ku ĩ́nkɛ̀. Bɑ́ kɛ̀ kù tu kùù botí, ");
INSERT INTO tbzsim_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","wèe duɔ́ nkɛ̀ bɛ̀ɛ kù ɔ̀útɛ́ kòo kù dɔú nku mɑ́ɑ̀ borɛ̀, kɛ̀ dɛ̀ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Dɛ kó difɔ̃nkúò dɛ̀ɛ̀ pũ̀ũti kɛ̀ dɛ̀ bɑɑ dò ndɛ dòntì kɛ í pɛ̃̀kɛ̀, dɛ kó kunɛnkù sĩ̀mmu, wèe kù tùɔ. Bɑ́ kɛ̀ kù pũ̀ũti ku ĩ́nkɛ̀ yoo ku miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Kòò mɛ nsɔ̃́ mbɛ̀ kù ɔ̀ú kɛ̀ dɛ̀ dɔ́ kɛ́deè kɛ kɑ́ntɛ́, wèe kɛ̃tɛ́ dɛ kó dibòrì. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Kɛ̀ dɛ̀ mɛ ndò nkù sɔɔ nkɛ pũ̀ũti kupíkù tɛkù dɛ kó kuyɑ̀ɑ̀kù ĩ́nkɛ̀ yoo kuyɑɑ̀dɑ́ndɑ́tínkù ĩ́nkɛ̀ yoo kunɛnkù bɛ̀ dɔ̀ɔ̀nɛ̀ kù kukɔ̃̀nkù ku ĩ́nkɛ̀, dɛ̀ tùòtìmu, wèe kù tùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Kɛ̀ bɛ̀ mɛ nkù ɔ̀útɛ́ kɛ dèè kɛ̀ dɛ̀ tɛ̃́nkɛ í wɛ̃̀tɛní bɛ̀ɛ yíɛ́ kɛ́ kù ɔ̀útɛ́. Dɛ kó difɔ̃nkúò kù í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Dɛ kó ikuɔ́ tukúnɛ̀ tiyɑ̀ɑ̀tì tìì pũ̀ũti tìnti, tìì dùɔ̀kɛnɛ̀ tipecìtì yoo mupɑɑ̀konkperímù yoo kuyɑɑ̀dɑ́ndɑ́tínkù yoo kunɛnkù tɛkù mɑkù bɛ̀ dɔ̀ɔ̀nɛ̀ kù kukɔ̃̀nkù. Bɑ́ kɛ̀ kù tu kùù botí. Dɛɛ̀ yó nte kɛ̀ bɛ̀ níí nɑ kɛ́bɑtɛ kùù sĩ̀ nnɛ̀ kùù wenni. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","Ntɛ ikuɔ́ di níí yóó tũnnɛ ì kɛ́wénkùnnɛ tikɔ̀ntì pĩ nwè. Di níí ò kɔ̀tɛnɛ̀ ikuɔ́ nìùtì borɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","kɛ̀ ikuɔ́ nìùtìi yɛ̀nní Isidɑyɛɛribɛ kɑrì kóò wèńtɛ́. Kòo ò wèńtɛ́ kɛ sɔ̃́ nhò miɛtɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","wèe duɔ́ nkɛ̀ bɛ̀ɛ wɑɑnní sinɔɔ sìdɛ́sì bɛ̀ n feu sì, bɛ̀ yóó wénkùnnɛ wè kpɛ́í, nnɛ̀ sɛ́tìrì kó kudɔú nɛ̀ tipecìtì tìì tò mmɛwũɔ̃̀ nnɛ̀ ìsɔ́pù kó tifɑ̃ɑ̃̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Kɛ̀ ikuɔ́ nìùtìi duɔ́ nkɛ̀ bɛ̀ɛ wɑɑ́ ndibuu tiyɑɑtì kpɛri kɛ́ɑ̃nnɛ́ mɛnɛ́sɑ̀ɑ̀mɛ̀ di miɛkɛ kɛ́ n féútɛ́ tɛnɔ̀tɛ̀ tɛmɑ́ɑ̀ mɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Kòò dèè wèe túótɛ́ tɛnɔ̀tɛ̀ tɛ̀ɛ̀ kpɑɑ́ fòù nɛ̀ sɛ́tìrì kó kudɔú nɛ̀ tipecìtì tìì tò mmɛwũɔ̃̀ nnɛ̀ ìsɔ́pù kó tifɑ̃ɑ̃̀tì kɛ́ dɛ̀ wɛ̃nnɛ́ dɛmɔu nɛ̀ tɛnɔ̀tɛ̀ tɛ̀ɛ̀ kpɑɑ́ fòù kɛ́pɔɔ̀tɛ̀ bɛ̀ fèútɛ́ tɛ̀ mɛnɛ́sɑ̀ɑ̀mɛ̀ miɛkɛ tɛ kó mɛyĩ̀ĩ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","kɛ́míɛ́tɛ́ bɛ̀ dɔ kɛ́wénkùnnɛ wè kucɛ mɛ̀yiekɛ̀, kòo wenkɛ kɛ tɛ̃́nkɛ bɑ́ nsĩ̀ kòo fĩ́ĩnko tɛnɔ̀tɛ̀ tɛ̀ɛ̀ kpɑɑ́ fòù kɛ̀ tɛ̀ɛ puu kɛ́tɑ dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Kɛ̀ bɛ̀ wèńkùnko wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́kuó o cìtì timɔu kɛ́wuɔ, ò tɛ̃́nkɛ í sĩ̀. Kòò dèè mɛmmɛ ò bo nɑ kɛ́tɑ Isidɑyɛɛribɛ kɑrì ò mɛ mbɑ́ɑ́ tɑ o tou kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Diyiè yiénnì yie kòo kuó o cìtì: O yùtì nɛ̀ o dɛɛ̀nfɛ̀ nɛ̀ o nɔncìtì, o cìtì timɔu cɛ̃́nkɛ, kɛ́ɔ́ú o yɑ̀ɑ̀tì, kɛ́wuɔ. Ò tɛ̃́nkɛ í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Diyiè niínnì yiè wèe wɑɑ́ nyɛpedɑbɛ yɛ̀dɛ́ɛ̀ nɛ̀ dipesɛrì dìì mɔ̀kɛ dibenni dìmɑ́ɑ̀, kɛ̀ dɛ̀ nkpɑ kuyɛ̀nkù, nɛ̀ muyuo nsɑ̀ɑ̀mù bɛ̀ yó m pɑ̃ mù, cìdóòbɛ̀ bɛ̀wɛi, kɛ́ mù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ ndítìrì kó dikéè. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Kɛ̀ ikuɔ́ nìùtì wèè dɔ̀ɔ̀ri mɛwénkùmɛ̀ kó ikuɔ́ kòo cónnɛ́ onìtì ò dɔ́ kɛ́wénkùnnɛ wè nɛ̀ o pɑ̃rɛ̀ mɛtɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Kɛ̀ ikuɔ́ nìùtìi túótɛ́ yɛpedɑbɛ kó dìmɑrì kɛ́féútɛ́ mɛyɛi nhũtímù kpɛ́í. Kòò dèè wèe túótɛ́ mɛkùɔ̀ ndítìrì dikéè kɛ́ dɛ̀ nni mbɛnkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Ikuɔ́ nìùtì weè yó n féútɛ́ dɛ kó dipedɑbii mɛtɑummɛ̀ tou ììkɛ̀, bɛ̀ n feu dɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛyi nɛ̀ bɛ̀ tùɔ̀ nyì. Dɛ kó fɛɔ̃̀fɛ̀ ikuɔ́ nìùtì weè yó nfɛ̀ te, bɛ̀ ɔ̃ ntemɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kɔfɛ. Bɛ̀ fɛ̀ nni mpɑ̃mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Kɛ̀ ikuɔ́ nìùtìi wɑɑ́ mmɛyĩ̀ĩ̀ nkɛ́fɛtɛ́ bɛ̀ wèńkùnko wè tofɛ́kérì youri, nɛ̀ o nɔ̀ùtɛ̀ youtɛ kó dinɔ́mbídɑɑ̀ nɛ̀ o nɑɑ̀cɛ̀tɛ̀ youtɛ kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Kòò dèè wèe bɑ́útɛ́ o nɔ̀ùtɛ̀ cɑ̃̀nkutɛ̀ mɛkùɔ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","kɛ́pɔɔ̀tɛ̀ o nɔ̀ùtɛ̀ youtɛ kó dinɔ́mbii mɑrì kɛ́míɛ́tɛ́ mɛtɑummɛ̀ tou kucɛ mɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Kòò dèè wèe pɔɔ̀tɛ̀ mɛkùɔ̀ mmɛ̀ɛ̀ kpɑɑ́ o nɔ̀ùtɛ̀ miɛkɛ, kɛ́fɛtɛ́ ò wèńkùnko wè tofɛ́kérì youri nɛ̀ o nɔ̀ùtɛ̀ youtɛ kó dinɔ́mbídɑɑ̀ nɛ̀ o nɑɑ̀cɛ̀tɛ̀ youtɛ kpɛri, ò do fɛtɛ́ dɛ̀ mɛyɛi nhũtímù kó fɛɔ̃̀fɛ̀ kó mɛyĩ̀ĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kòò dèè, mɛkùɔ̀ mmɛ̀ɛ̀ kpɑɑ́ wèe mɛ̀ wɑɑrɛ ò wèńkùnko wè yuu, kóò dɔ̀ɔ̀ mɛwénkùmɛ̀ kó ikuɔ́, mɛtɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kɛ̀ ikuɔ́ nìùtìi féútɛ́ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó fɛɔ̃̀fɛ̀ kóò ũtɛ́ mɛyɔ̃́ɔ̃̀, kòò dèè ò nɛ́ n féútɛ́ fɛ̀ɛ̀ yóó tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kɛ̀ bɛ̀ɛ fɛ̀ wɛ̃nnɛ́nɛ̀ muyuo mbɛ̀ m pɑ̃ mù kɛ́tuɔ, kóò dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́. Ò tɛ̃́nkɛ í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Kòò mɛ ntu ocĩ̀rì nwe, wèe wɑɑ́ ndipedɑbii dimɑ́ɑ̀ mɛyɛi nhũtímù kpɛ́í, kɛ̀ bɛ̀ɛ dì fèútɛ́ kɛ́ m bɛnkɛ kóò dɔ̀ɔ̀ mɛwénkùmɛ̀ kó ikuɔ́, kɛ́wɑɑ́nnɛ̀ muyuo nsɑ̀ɑ̀mù cìdóòbɛ̀ bɛ̀tɑ̃ɑ̃ti kɛ́ mù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ mbɛ̀ yó m pɑ̃ mùù yuo mmu kɛ́yíɛ́nɛ̀ mɛkùɔ̀ ndítìrì dikéè. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Kòo wɑɑ́nnɛ̀ sinɔ́nkpeé sìdɛ́sì yoo yɛkpɛtinɔ́nkpedípɑ̀ɑ̀ nyɛ̀dɛ́ɛ̀. Kòò nɑ kɛ sì pɛ̀tɛ́, tɛ̀mɑ́ɑ̀ ntú bɛ̀ yó n féútɛ́ tɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í nkɛ́ n féútɛ́ tɛtɛtɛ̀ kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Diyiè niínnì yiè ndi, ò yóó dɛ̀ tɔnímɛ̀ kɛ́duɔ́ nyikuɔ́ nìùtì mɛtɑummɛ̀ tou ììkɛ̀ mɛwénkùmɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Kɛ̀ ikuɔ́ nìùtìi túótɛ́ dipedɑbii mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri nɛ̀ mɛkùɔ̀ ndítìrì dikéè kɛ́ dɛ̀ nni mbɛnkɛ mɛtɑummɛ̀ tou ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","kɛ́féútɛ́ dɛ kó dipedɑbii mɛyɛi nhũtímù kpɛri, kɛ́pɔɔ̀tɛ̀ mɛyĩ̀ĩ̀ nkɛ́fɛtɛ́ bɛ̀ wénkùnko wè tofɛ́kérì youri nɛ̀ o nɔ̀ùtɛ̀ youtɛ kó dinɔ́mbídɑɑ̀ nɛ̀ o nɑɑ̀cɛ̀tɛ̀ youtɛ kpɛri, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","kɛ́cíú nho nɔ̀ùtɛ̀ cɑ̃̀nkutɛ̀ kɛ́bɑ́útɛ́ mɛkùɔ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","kɛ́ mɛ̀ pɔ̀ɔ̀tɛ̀ kɛ́míɛ́tɛ́ mɛtɑummɛ̀ tou kucɛ mɛ̀yiekɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","kɛ́ mɛ̀ fɛtɛ́ ò wèńkùnko wè tofɛ́kérì youri nɛ̀ o nɔ̀ùtɛ̀ youtɛ kó dinɔ́mbídɑɑ̀ nɛ̀ o nɑɑ̀cɛ̀tɛ̀ youtɛ kpɛri, ò do fɛtɛ́ dɛ̀ mɛyɛi nhũtímù kó fɛɔ̃̀fɛ̀ kó mɛyĩ̀ĩ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","kɛ́deè, mɛkùɔ̀ mmɛ̀ɛ̀ kpɑɑ́ o nɔ̀ùtɛ̀ miɛkɛ wèe mɛ̀ wɑɑrɛ ò wèńkùnko wè yuu kóò dɔ̀ɔ̀ mɛwénkùmɛ̀ kó ikuɔ́ mí ndi Yiɛ̀ nKuyie n tɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Sinɔ́nkpeé sìdɛ́sì sinsi kó tɛ̀mɑtɛ̀ yoo yɛkpɛtinɔ́nkperɛ yɛ̀dɛ́ kó dìmɑrì ò nɑ kɛ pɛ̀tɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Kɛ̀ ikuɔ́ nìùtì n féútɛ́ tɛ̀mɑ́ɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ n féútɛ́ tɛtɛtɛ̀ kɛ́tuɔ nkɛ́wɛ̃nnɛ́nɛ̀ muyuo mbɛ̀ m pɑ̃ mù nɛ̀ ò nɑ kɛ pɛ̀tɛ́ dɛ̀, kóò dɔ̀ɔ̀ mɛwénkùmɛ̀ kó ikuɔ́, mí ndi Yiɛ̀ nKuyie n tɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Dɛ kó ikuɔ́ tukúnɛ̀ tikɔ̀ntì bo pĩ́ nwè nwe kòò í mpɛ̀tɛ́ ò dò nkɛ́ nɑ nwɑɑ́ ndɛ̀ kɛ́dɔɔ̀nɛ̀ mɛwénkùmɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Kɛ̀ ti Yiɛ̀ nKuyie nni nsɔkɛ́ ku nɑ́ɑǹtì kɛ́nɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","Kɛ̀ di tùɔ̀kɛ dìì mɔ̀nnì Kɑnnɑhɑ̃ɑ̃ ɛì n yóó di duɔ́ ndì kɛ̀ dí dì tiekɛ, kɛ̀ n duɔ́ nkɛ̀ sicɛ̃́ĩ di yóó tiekɛ sì kó tɛ̀mɑtɛ̀ pũ̀ũti. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","Kɛ̀ tɛcĩ́ɛ̃̀tɛ̀ yiɛ̀ nkɔ̀tɛ kɛ nɑ̀kɛ́ ikuɔ́ nìùtì kɛ yĩ: N yɑ̀ n cĩ́ɛ̃̀tɛ̀ miɛkɛ nkɛ dɛ̀mɑrɛ̀ fɛmɑrifɛ pũ̀ũtimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Ikuɔ́ nìùtìi duɔ́ nkɛ̀ bɛ̀ɛ dennɛ tinɛntì dɛ kó tɛcĩ́ɛ̃̀tɛ̀ miɛkɛ, kòò nɛ́ nɑ kɛ́tɑ kɛ́ tɛ̀ wèńtɛ́. Kɛ̀ dɛ̀ɛ yie nkɛ̀ dɛ̀ɛ kó dimɑ̀ɑ̀ bo tɛcĩ́ɛ̃̀tɛ̀ kɛ̀ dɛ̀ bɑ́ɑ́ sĩntɛ, kɛ̀ ikuɔ́ nìùtì mu nyí kɔ̀tɛ kɛ tɛ̀ wèńtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Kòò tɛ̀ wèńtɛ́ kɛ sɔ̃́ nsifɔ̃ɔ̃ ɑ̃nnɛ́ imɑrí ĩ́nkɛ̀ kɛ dò mmɛnɔ́ɔnnúɔ̀ nkɛ wɛ̃̀tɛ kɛ dɔ́ kɛ́nwũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Ò nyɛtìní dibòrì kɛ́duɔ́ nkɛ̀ bɛ̀ɛ tɛ̀ kpetínnɛ́ kɛ̀ tɛ̀ dɔ̀ yɛwe yɛ̀yiekɛ̀ kɛ kpetí. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Kòo wɛ̃tɛ diyiè yiénnì yiè kɛ́ tɛ̀ wèńtɛ́ kòò sɔ̃́ ntɛfɔ̃̀tɛ̀ pɛ̃̀kɛ̀ imɑrí ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","wèe duɔ́ nkɛ̀ bɛ̀ɛ dɛi yɛtɑ̃́rɛ̀ yɛ̀ɛ̀ pũ̀ũti kɛ́ yɛ̀ ùtóo dihɛì mɑ̀nku bɛ̀ uutoo dɛ̀ dɛsĩ̀nnɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","kɛ́duɔ́ nkɛ̀ bɛ̀ɛ kũrí tɛcĩ́ɛ̃̀tɛ̀ miɛkɛ imɑrí kɛ́koú bɛ̀ kũrí dɛ̀ kɛ́dennɛ dihɛì mɑ̀nku kɛ́útóo bɛ̀ uutoo dɛ̀ dɛsĩ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Kɛ̀ bɛ̀ɛ wɑɑ́ nyɛtɑ̃́rɛ̀ tɛyɛ̀ kɛ́ɑ̃nnɛ́ bɛ̀ dɛ̀i yɛ̀ kó yɛfɔ̃̀tɛ̀ kɛ́bí tibítì tɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Kɛ̀ bɛ̀ dɛ̀itɛ yɛtɑ̃́rɛ̀ kɛ kũrí dɛ̀ɛ̀ pũ̀ũti kɛ bi tibítì tɛtì, kɛ̀ dɛ̀ wɛ̃̀tɛ kɛ feítɛ́ tɛcĩ́ɛ̃̀tɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","Ikuɔ́ nìùtìi wɛ̃tɛ kɛ́ tɛ̀ wèńtɛ́, kòò sɔ̃́ ndɛ̀ pɛ̃̀kɛ̀ dɛ̀ í yóó deè, dɛ kó tɛcĩ́ɛ̃̀tɛ̀ sĩ̀mmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Bɛ̀ɛ tɛ̀ pùɔ nkɛ́ koú tɛ tɑ̃́ɑ̃́ nnɛ̀ tɛ dɛí nɛ̀ tɛ bítì kɛ́dennɛ dihɛì kɛ́útóo bɛ̀ uutoo dɛ̀ dɛsĩ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Kɛ̀ wèè tɑ dɛ kó tɛcĩ́ɛ̃̀tɛ̀ tɛ̀ kpɑɑ́ kpetí dìì mɔ̀nnì ò sĩ̀ntɛmu dɛ kó diyiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","kɛ̀ wèè duɔ́ tɛ miɛkɛ yoo ò di tɛ miɛkɛ wèe ɔ́ú o yɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Kɛ̀ ikuɔ́ nìùtì mɛ nkɔ̀tɛ kɛ wèńtɛ́ kɛ sɔ̃́ ndɛ̀ í pɛ̃̀kɛ̀ nɛ̀ bɛ̀ tɛ̀ bimɛ̀ kɛ dèè, wèè bɛ́i nkɛ dɔ̀: Tɛ̀ í sĩ̀, ndɛ̀ɛ̀ do pũ̀ũti dɛ̀ dèèmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Kɛ̀ tɛ yiɛ̀ nwɑɑ́ nsinɔɔ sìdɛ́sì nɛ̀ sɛ́tìrì kó kudɔú nɛ̀ tipecìtì tìì to mmɛwũɔ̃̀ nnɛ̀ ìsɔ́pù kó tifɑ̃ɑ̃̀tì kɛ́ tɛ̀ wénkùnnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Kɛ̀ ikuɔ́ nìùtìi ɑ̃nnɛ́ mɛnɛ́sɑ̀ɑ̀mɛ̀ tiyɑɑtì kó dibuu miɛkɛ, kɛ́féútɛ́ tɛnɔ̀tɛ̀ tɛmɑ́ɑ̀ dɛ miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","kɛ́deè kɛ́túótɛ́ sɛ́tìrì kó kudɔú nɛ̀ ìsɔ́pù kó tifɑ̃ɑ̃̀tì nɛ̀ tipecìtì tìì to mmɛwũɔ̃̀ nnɛ̀ tɛnɔ̀tɛ̀ tɛ̀ɛ̀ kpɑɑ́ kɛ fòù, kɛ́pɔɔ̀tɛ̀ tɛnɔ̀tɛ̀ bɛ̀ fèútɛ́ tɛ̀ mɛnɛ́sɑ̀ɑ̀mɛ̀ miɛkɛ tɛ yĩ̀ĩ̀, nkɛ́míɛ́tɛ́ tɛcĩ́ɛ̃̀tɛ̀ kucɛ mɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Ò dɔ̀ɔ̀ dìì mɔ̀nnì tɛcĩ́ɛ̃̀tɛ̀ mɛwénkùmɛ̀ kó ikuɔ́ nɛ̀ tɛnɔ̀tɛ̀ ò fèútɛ́ tɛ̀ mɛnɛ́sɑ̀ɑ̀mɛ̀ miɛkɛ tɛ kó mɛyĩ̀ĩ̀ nnɛ̀ sɛ́tìrì kó kudɔú nɛ̀ ìsɔ́pù kó tifɑ̃ɑ̃̀tì nɛ̀ tipecìtì tìì to mmɛwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kòò dèè wèe fĩ́ĩnko tɛnɔ̀tɛ̀ tɛ̀ɛ̀ kpɑɑ́ kɛ fòù dihɛì mɑ̀nku kɛ̀ tɛ̀ɛ tɑ dikpɑ́ɑ̀. Bɛ̀ dɔ̀ɔ̀ dìì mɔ̀nnì mɛwénkùmɛ̀ kó ikuɔ́ kɛ dèè tɛcĩ́ɛ̃̀tɛ̀ tɛ̃́nkɛ í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Dɛ kó ikuɔ́ tukúnɛ̀ tikɔ̀ntì nɛ̀ yɛyukɔ̃̀rɛ̀ ĩ́nkɛ̀ kó mumɔmmú mmu, ");
INSERT INTO tbzsim_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","nɛ̀ tiyɑ̀ɑ̀tì nɛ̀ sicɛ̃́ĩ dɛ̀ bo pũũtimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","Nɛ̀ yɛnúútɛ̀ bo dɑ yɛ̀mɛ̀ nɛ̀ tɛcɛ̀tɛ̀ bo dɑ pĩ́mmɛ̀ nɛ̀ diciitirì bo ɑ̃nnɛ́mɛ̀ ɑ kɔ̃̀ntì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Dɛ kó ikuɔ́ iì yó mbɑɑ̀tì dɛ̀ɛ̀ sĩ̀ nnɛ̀ dɛ̀ɛ̀ í sĩ̀. Tikɔ̀ntì nɛ̀ dɛ̀mɑrɛ̀ bo pũũtimɛ̀ kó ikuɔ́ nyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɑɑ nsɔkɛ́ kɛ nɑ́ɑ́nnɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ́bɛ́i nkɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","Nɑ́kɛ́nɛ̀ Isidɑyɛɛribɛ kɛ tú: Kòo nitidɔ̀ù mɔù tùɔ̀ti yɛfɔtɛ̀ kɛ̀ mɛniɛ nyiɛ̀, dɛ kó mɛniɛ nhò sĩ̀nkùnnɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Ntɛ dɛ̀ yó nhò dòmmɛ̀ ò mɔ nyɛ̀ɛ̀ we miɛkɛ: Kɛ̀ mɛniɛ nyiɛ̀ yoo mɛ í yiɛ̀ ò sĩ̀mmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kòò duɔ́ dìì dɔ́ù ĩ́nkɛ̀ dì sĩ̀ntɛmu, kòò kɑ̀ri dìì kɑ̀rì ĩ́nkɛ̀ dì sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Kɛ̀ wèè kɑ̀ɑ́kɛ́ dɛ yiɛ̀ ndɔ́ù wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Kɛ̀ wèè kɑ̀rì dikɑ̀rì ò kɑ̀rì dìì ĩ́nkɛ̀ wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Wèè kɑ̀ɑ́kɛ́ dɛ yiɛ̀ nwèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Kɛ̀ dɛ yiɛ̀ ntĩ̀ṹtɛ́ òmɔù, ò mɛ ntĩ̀ṹtɛ́ wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kòò kɔ̀ri mucèmmu kɛ kɑri dìì sɑ̃nkɑ̀rì dì sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Kɛ̀ wèè kɑ̀ɑ́kɛ́ kunɛnkù mɑkù ò yɑ̃̀kɛ kùù ĩ́nkɛ̀, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. Kɛ̀ wèè tùótɛ́ dɛ kó kunɛnkù wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Kɛ̀ dɛ kóo nìtì kɑ̀ɑ́kɛ́ òmɔù kɛ í nìtɛ, ò kɑ̀ɑ́kɛ́ wèe ɔ́ú o yɑ̀ɑ̀tì, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Kɛ̀ dɛ kóo nìtì kɑ̀ɑ́kɛ́ kunɛnkù tiyɑɑtì kɔku bɛ̀ɛ kù pɔ̀ntɛ, kɛ̀ kudɔú kɔku mɛ nní nku bɛ̀ɛ kù ɛitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Kɛ̀ dɛ̀ yiɛ̀ mmiɛtɛ́ ò mbɑɑ̀ yɛwe yɛ̀yiekɛ̀ kɛ nɛ́ nɑ kɛ́wenkɛ. Wèe ɔ́ú o yɑ̀ɑ̀tì nɛ̀ mɛniɛ mmɛ̀ɛ̀ pũɔ̃̀ nkɛ nɛ́ wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Diyiè niínnì yiè kɛ́wɑɑ́ nsinɔ́nkpeé sìdɛ́sì yoo yɛkpɛtinɔ́nkperípɑ̀ɑ̀ nyɛ̀dɛ́ɛ̀, kɛ́ dɛ̀ tɔní kɛ́duɔ́ nyikuɔ́ nìùtì mɛtɑummɛ̀ tou bòrìnùù. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Kòo túótɛ́ tɛ̀mɑ́ɑ̀ kɛ́kuɔ mɛyɛi nhũtímù kpɛ́í, kɛ́túótɛ́ tɛtɛtɛ̀ kɛ́kuɔ kɛ́tuɔ nkóò dɔ̀ɔ̀ mɛwénkùmɛ̀ kó ikuɔ́ kòo wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Kòo nitidɔ̀ù duɔ́ kɛ yɛ̃nkɛ omɑ́ɑ̀ wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Kɛ̀ tiyɑ̀ɑ̀tì nti yoo kɛ̀ kukɔ̃̀nkù nku o tɑniɛ ndɑ̀rimɛ̀ wèe dɛ̀ ɔ́ú, dɛ̀ sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kòo nitidɔ̀ù duɔ́nɛ̀ onitipòkù bɛ̀ɛ wuɔ. Bɛ̀ sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Kòo nitipòkù yúɔ́ nhò sĩ̀ntɛmu kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀, kɛ̀ wèè ò kɑ̀ɑ́kɛ́ ò sĩ̀ntɛmu dɛ yiè, kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kòò duɔ́ dìì dɔ́ù dì sĩ̀ntɛmu, kòò kɑ̀ri dìì kɑ̀rì dì sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Kɛ̀ wèè kɑ̀ɑ́kɛ́ o dɔ́ù wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ. Ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Kɛ̀ wèe kɑ̀ɑ́kɛ́ kunɛnkù mɑkù ò kɑ̀ri kùù ĩ́nkɛ̀ wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Kɛ̀ kunɛnkù mɑkù bo o dɔ́ù ĩ́nkɛ̀ yoo ò kɑ̀ri dɛ̀ɛ̀ ĩ́nkɛ̀, kòò mɔù dɛ̀ kɑ̀ɑ́kɛ́ ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Kòo nitidɔ̀ù duɔ́nɛ̀ onitipòkù ò yùɔ́ ndìì mɔ̀nnì ò sĩ̀ntɛmu kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀ kòò duɔ́ dìì dɔ́ù ĩ́nkɛ̀ dì sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Kòo nitipòkù yùɔ́ nkɛ̀ dɛ̀ pɛ̃ɛ̃tɛ́ dɛ we kɛ̀ tì mu nyí dèè, yɛwe yɛ̀ɛ̀ sɔɔtɛ́ yɛ miɛkɛ ò bɑɑ yó nsĩ̀ nhò ɔ̃ nyúɔ́ nkɛ̀ dɛ̀ dòmmɛ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Dɛ kó yɛwe yɛ̀ɛ̀ sɔɔtɛ́ yɛ miɛkɛ kòò duɔ́ dìì dɔ́ù yoo ò kɑ̀ri dìì kɑ̀rì ĩ́nkɛ̀, dì sĩ̀ntɛmu kɛ́ndònnɛ̀ o yɔ́ntì kó yɛwe ɔ̃ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Kɛ̀ wèè kɑ̀ɑ́kɛ́ o dɔ́ù yoo o kɑ̀rì, wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Kòo yɔ́ntì còḿmú ò mmɔkɛ yɛwe yɛ̀yiekɛ̀ kɛ nɛ́ nɑ kɛ́wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Diyiè niínnì yiè kòo wɑɑ́ nsinɔ́nkpeé sìdɛ́sì yoo yɛkpɛtinɔ́nkperípɑ̀ɑ̀ nkɛ́ dɛ̀ tɔní kɛ́duɔ́ nyikuɔ́ nìùtì mɛtɑummɛ̀ tou bòrìnùù. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kòo kuɔ tɛ̀mɑ́ɑ̀ mɛyɛi nhũtímù kpɛ́í nkɛ́kuɔ tɛtɛtɛ̀ kɛ́tuɔ mmɛtɑummɛ̀ tou ììkɛ̀, kóò dɔ̀ɔ̀ mɛwénkùmɛ̀ kó ikuɔ́ kòo wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Dí nɑ́kɛ́ Isidɑyɛɛribɛ kɛ̀ bɛ̀ níí nciɛ́ mbɛ̀ sĩ̀ nyɛ̀ɛ̀ we, bɛ̀ bɑ́ɑ́ tɑ n tɑummɛ̀ tou bɛ̀ yɑ̀ɑ̀ bo dì sĩ̀nkùnnɛ kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Dɛ kó ikuɔ́ tukúnɛ̀ onitidɔ̀ù wèè bo tuɔti wènwe yɛfɔtɛ̀ kɛ̀ mɛniɛ nní nyiɛ̀ nɛ̀ wèè bo duɔ́ kɛ́yɛ̃nkɛ omɑ́ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","nɛ̀ onitipòkù wèè yúɔ́, nɛ̀ onitidɔ̀ù yoo onitipòkù wèè bo tuɔti yɛfɔtɛ̀ kɛ̀ mɛniɛ nní nyiɛ̀, nɛ̀ onitidɔ̀ù wèè bo duɔ́nɛ̀ onitipòkù ò yùɔ́ ndìì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́inɛ̀ Mɔyiisi. Dɛ̀ do sɔ̃́ nhAnɔɔ bí idɛ́ kumu, ìì do tùɔ ntihúúntì ti Yiɛ̀ nKuyie ntɑummɛ̀ tou miɛkɛ nɛ̀ muhɑ̃ɑ̃́ nsɔ̃́ntíkoo kɔ̃mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Dɛ mɔ̀nnì kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: Nɑ́kɛ́ ɑ kóo kótì Anɔɔ kɛ dɔ̀ n yɛ̃ nhò bɑ́ ntɑɑ̀ mɛtɑummɛ̀ tou yɛwe yɛmɔu kɛ fiitì kuyɑ̀ɑ̀kù fɔ̃nkúò mɛtɑummɛ̀ tɔu ĩ́ĩ́kú dɛ̀, ò yɑ̀ɑ̀ bo kú, kɛ yɛ̃́ n níí yóó dɛ̀ kɔ̀toomɛ̀ diwɛtirì miɛkɛ kɛ́ bɛ̀ bɛnkɛ m mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Kòò níí tɑti mɛtɑummɛ̀ tou wèe wɑɑ́ ndinɑɑdɑɑ̀ mɛyɛi nhũtímù kpɛ́í, kɛ́wɑɑ́ ndipedɑɑ̀ ò yó n féútɛ́ dì kɛ́tuɔ, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","kɛ́dɑ́ɑ́tí dikɔutɛ́yɑɑ̀bòrì dìì dùɔ̀kɛnɛ̀ mupɑɑ̀konkperímù kɛ́inɛ̀ dɛ kó dɛfɛtirɛ kɛ́boú mu kó fɛnɑɑ̀kɔ̃̀nfɛ̀, kɛ́boú o yuu mu kó kuyɑɑ̀bomboúnkù. Ikuɔ́ nɛntì nti, ò níí wuɔ kɛ nɛ́ nɑ kɛ́ tì ɑ̃nnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Kɛ̀ Isidɑyɛɛribɛɛ ò duɔ́ nyɛbɔdɑkɛ̀ yɛ̀dɛ́ɛ̀ mɛyɛi nhũtímù kpɛ́í nnɛ̀ dipedɑɑ̀ dìmɑ́ɑ̀ ò yó n féútɛ́ dì kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Kɛ̀ Anɔɔ ketɛ́ kɛ́ n féútɛ́ dinɑɑdɑɑ̀ o mɔ́mmuɔ nhò kó mɛyɛi nhũtímù kpɛ́í nnɛ̀ o cĩ́ɛ̃̀tɛ̀ kɔbɛ kɔ̃mɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","kɛ́deè kɛ́túótɛ́ yɛbɔdɑkɛ̀ yɛ̀dɛ́ɛ̀ kɛ́ yɛ̀ còńnɛ́ mɛtɑummɛ̀ tou bòrìnùù, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","kɛ́tɑ̃ũ tɛ́tɛ́ kɛ́yɑ̀ dìì yó ntú n kpɛri nɛ̀ bɛ̀ yóó fĩ́ĩnko dì kɛ̀ dìi tɑ dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Kɛ̀ Anɔɔ n féútɛ́ n kpɛri mɛyɛi nhũtímù kpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","kɛ́túótɛ́ bɛ̀ yóó tɑnnɛ́ dì dikpɑ́ɑ̀ kɛ́cónnɛ́ mɛtɑummɛ̀ tou ììkɛ̀, kɛ́dɔɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ kɛ́deè kɛ̀ bɛ̀ɛ dì tɑnnɛ́ dikpɑ́ɑ̀ tɛdɔntɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Dɛ kó difɔ̃nkúò kɛ́túótɛ́ní dinɑɑdɑɑ̀ o mɔ́mmuɔ nho yɛi nhũtímù kpɛ́í nnɛ̀ o cĩ́ɛ̃̀tɛ̀ kɔbɛ kɔ̃mɛ kpɛ́í nkɛ́ dì nni mbɛnkɛ kɛ́dɔɔ̀ mɛyɛi nhũtímù kó ikuɔ́ kɛ́ dì nni nféútɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Kòò dèè wèe túótɛ́ tɛsɔɔsékɛ́buutɛ, kɛ́koutɛ́ yɛhɑ̃ɑ̃kũɔ̃ ndiwũɔ̃tɔ̀nnì dìì bo mɛtɑummɛ̀ tou ììkɛ̀ kɛ́ɑ̃nnɛ́ dɛ miɛkɛ, kɛ́yɛ̃tɛ́ tihúúntì dinɑcɛkutiri mɛ̀dɛ́mɛ̀, kɛ́ dɛ̀ tɑnnɛ́ dɛmɔu mɛtɑummɛ̀ tou kó kufɑ̃́ɑ̃́ nkuyɑ̀ɑ̀kù kpetí kù, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","kɛ́tuɔ ntihúúntì mɛtɑummɛ̀ tɔu ikuɔ́ nɛntì ɑ̃ dɛ̀ ììkɛ̀, kɛ̀ kuyukúu dɑ́tínnɛ́ di ĩ́nkɛ̀ nɛ̀ di pòkù, kɛ̀ dɛ̀ɛ yie nkòò bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Dɛ kó difɔ̃nkúò kɛ́pɔɔ̀tɛ̀ dinɑɑdɑɑ̀ kó mɛyĩ̀ĩ̀ nkɛ́miɛtɛ́ mɛtɑummɛ̀ tɔu kó kupòkù diyiè yiɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ mɛ̀mɑ́ɑ̀, di ììkɛ̀ mɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Dɛ kó difɔ̃nkúò kɛ́ n féútɛ́ kubotí kó mɛyɛi nhũtímù kó dibɔdɑɑ̀, kɛ́tɑnnɛ́ di yĩ̀ĩ̀ nkuyɑ̀ɑ̀kù kpetí kùù fɑ̃́ɑ̃́ nkɛ́dɔɔ̀nɛ̀ di yĩ̀ĩ̀ nhò do dɔ̀ɔ̀mɛ̀ dinɑɑdɑɑ̀ kɔ̃mɛ kɛ́míɛ́tɛ́ mɛtɑummɛ̀ tɔu pòkù fɔ̃nkúò nɛ̀ di ììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","kɛ́dɔɔ̀ mɛyɛi nhũtímù kó ikuɔ́ kufɑ̃́ɑ̃́ mmiɛkɛ. Isidɑyɛɛribɛ cɑɑ̀rìmɛ̀ kpɛ́í nnɛ̀ bɛ yetírímɛ̀ n kpɛti nɛ̀ bɛ cɑɑ̀rìmɛ̀, kɛ múnkɛɛ mɛ ndɔɔ̀ mɛtɑummɛ̀ tou dimɔu kɛ yɛ̃́ di bomɛ̀ bɛnìtìbɛ̀ bɛ̀ɛ̀ sĩ̀ mbɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Òmɔù bɑ́ mbo mɛtɑummɛ̀ tou miɛkɛ ò tɑti dìì mɔ̀nnì kɛ bo dɔɔ̀ mɛyɛi nhũtímù kó ikuɔ́, nɛ̀ ò bo tɑmɛ̀ kɛ́yɛ̀nnɛ̀nní, kòò dɔ̀ɔ̀ o mɔ́mmuɔ nho kó mɛyɛi nhũtímù kó ikuɔ́ nɛ̀ o cĩ́ɛ̃̀tɛ̀ kɔbɛ kɔ̃mɛ nɛ̀ kubotí kɔ̃mɛ kpɛ́í nkɛ dèè. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Wèe yɛ̀nní kɛ́kɔtɛ diwũɔ̃tɔ̀nnì dìì bo mɛtɑummɛ̀ tou ììkɛ̀ kɛ́ dì dɔ̀ɔ̀ mɛyɛi nhũtímù kó ikuɔ́, kɛ́wɑɑ́ ndinɑɑdɑɑ̀ nɛ̀ dibɔdɑɑ̀ kó mɛyĩ̀ĩ̀ nkɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì bɑ̀kɛ̀ kɛ́fitɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","kɛ́pɔɔ̀tɛ̀ o nɔ́mbii dɛ kó mɛyĩ̀ĩ̀ nkɛ́míɛ́tɛ́ diwũɔ̃tɔ̀nnì kucɛ mɛ̀yiekɛ̀ kɛ́ dì wénkùnnɛ Isidɑyɛɛribɛ kó mɛyɛi mmɛ̀ɛ̀ do di sĩ̀nkùnnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Kòò wèńkùnnɛ dìì mɔ̀nnì mɛtɑummɛ̀ tou kufɑ̃́ɑ̃́ nnɛ̀ ditou dimɔu nɛ̀ diwũɔ̃tɔ̀nnì kɛ dèè, bɛ̀ɛ túótɛ́ní dibɔdɑɑ̀ dìì kpɑɑ́ kɛ fòù. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Kɛ̀ Anɔɔ nɔ́ɔ́ nho nɔu di yuu ĩ́nkɛ̀ nɛ̀ Isidɑyɛɛribɛ bɛmɔu kó diyètìrì, kɛ́yie mbɛ cɑɑ̀rìmɛ̀ nɛ̀ bɛ̀ yetírímɛ̀ n kpɛti, kɛ́ dì toú ndɛ kó mɛyɛi nkɛ́deè kɛ́ dì duɔ́ nhonìtì bɛ̀ tɑ̃ɑ̃tɛ́ wè kòò dì tɑnnɛ́ dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Kɛ̀ dibɔdɑɑ̀ tɔ bɛ yɛi mɛmɔu kɛ́tɑnnɛ́ dikpɑ́ɑ̀ tɛdɔntɛ̀ kɛ dèè. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Kɛ̀ Anɔɔ kɔtɛ mɛtɑummɛ̀ tou kɛ́dɛitɛ mupɑ̀ɑ̀konkperímù kó tiyɑ̀ɑ̀tì, ò do ɑ̃nnɛ́ tì kɛ́tɑnnɛ́ mɛtɑummɛ̀ tou kó kufɑ̃́ɑ̃́, kɛ́ tì dɔú ndɛborɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","kɛ́cómmú dibòrì bɛ̀ tɑ̃ɑ̃tɛ́ dì kɛ́wuɔ kɛ́wɛ̃tɛ kɛ́dɑ́ɑ́tí o yɑ̀ɑ̀tì tɛtì kɛ́yɛ̀nní kɛ́kɔtɛ kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́tuɔ nkɛ́ n féútɛ́ kubotí kɔfɛ kɛ́tuɔ, kɛ́dɔɔ̀ mɛyɛi nhũtímù kó ikuɔ́, o mɔ́mmuɔ nho kpɛ́í nnɛ̀ kubotí kpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","kɛ́tuɔ nyiwũɔ̃ bɛ̀ n kùɔ ì mɛyɛi nhũtímù kpɛ́í nyi kó mɛkùɔ̀ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Wèè do tɑnnɛ́ dibɔdɑɑ̀ dikpɑ́ɑ̀ tɛdɔntɛ̀ kòò ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ kɛ nɛ́ nɑ kɛ́tɑ Isidɑyɛɛribɛ kɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Dinɑɑdɑɑ̀ nɛ̀ dibɔdɑɑ̀ bɛ̀ do n féútɛ́ dɛ̀ mɛyɛi nhũtímù kpɛ́í, nkɛ́tɑnnɛ̀ mɛyĩ̀ĩ̀ mmɛtɑummɛ̀ tou kɛ́dɔɔ̀ mɛyɛi nhũtímù kó ikuɔ́, bɛ̀ɛ dɛ̀ dènnɛ Isidɑyɛɛribɛ kɑrì kɛ́tuɔ ndɛ kɔ̃̀ntì nɛ̀ dɛ mɑɑ nnɛ̀ dɛ piti. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Wèè dɛ̀ tùɔ nwèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, kɛ nɛ́ nɑ kɛ́tɑ Isidɑyɛɛribɛ kɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Dɛ yó ntú ikuɔ́ nyi di kpɛ́í nsɑ̃́ɑ̃̀, dibenni tɑ̃̀nkù oyiénwè kó diyiè píínnì, di níí boú dinùù di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù, dihɛì yɛmbɛ̀ nɛ̀ bɛpɔ̀ɔ̀bɛ̀ dimɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Dɛ yiè ndi bɛ̀ yóó di dɔɔ̀mɛ̀ mɛyɛi nhũtímù kó ikuɔ́ kɛ́ di wénkùnnɛ di yɛi mɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Dɛ yiè yó ndònnɛ̀ tɛom̀pùtɛ̀ kpɛri ndi di kpɛ́í, kɛ̀ di níí boú dinùù. Dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Ikuɔ́ nìùtì bɛ̀ cɑ̃̀ńnɛ́ wè koò còú mmɛkùɔ̀ nkòò cɔutɛ́ o cicɛ kó difɔ̃̀tìrì, weè níí yóó dɑ́ɑ́tí ikuɔ́ yɑ̀ɑ̀tì mupɑɑ̀konkperímù kpɛti kɛ́dɔɔ̀ mɛyɛi nhũtímù kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Weè níí yóó dɔɔ̀ ikuɔ́ kɛ́wénkùnnɛ mɛtɑummɛ̀ tou kó kufɑ̃́ɑ̃́ nnɛ̀ di mɔ́mɔnni nɛ̀ diwũɔ̃tɔ̀nnì weè níí yóó dɔɔ̀ ikuɔ́ kɛ́wénkùnnɛ ikuɔ́ nìùbɛ̀ nɛ̀ kubotí kumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Dɛ̀ yó ntú ikuɔ́ nyi di kpɛ́í nsɑ̃́ɑ̃̀ kɛ̀ di níí ì dɔ̀ɔ̀ kucɛ mɛmɑ́ɑ̀ dibenni miɛkɛ. Isidɑyɛɛribɛ bɛmɔu kó mɛyɛi nhũtímù kpɛ́í. Kɛ̀ Anɔɔ dɔ̀ɔ̀ Mɔyiisi ò nɑ̀kɛ́ tì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nni nsɔkɛ́ ku nɑ́ɑǹtì kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","Nɑ́kɛ́ Anɔɔ nɛ̀ o bí nɛ̀ Isidɑyɛɛribɛ kɛ dɔ̀: Mí ndi Yiɛ̀ nKuyie n tú: ");
INSERT INTO tbzsim_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Di miɛkɛ kòò mɔù fèútɛ́ fɛnɑ̀ɑ̀fɛ̀ yoo fɛpìèfɛ̀ yoo tɛbuɔtɛ̀ di kɑrì, yoo ò dɛ̀ yɛ̀nnɛ̀ di kɑrì kɛ dɛ̀ fèútɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","kòò í dɛ̀ kɔ̀tɛnɛ̀ní mɛtɑummɛ̀ tou ììkɛ̀ kɛ dɛ̀ nni mbɛnkɛ, dɛ̀ doti o yuu ĩ́nkɛ̀ nkɛ, di ò dènnɛ Isidɑyɛɛribɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Kɛ̀ di níí dɔ́ kɛ́ n féútɛ́ dɛ̀, dí dɛ̀ tɔní kɛ́duɔ́ nyikuɔ́ nìùtì mɛtɑummɛ̀ tou bòrìnùù, kòò dɛ̀ nni fíé mɛtɑummɛ̀ kpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","kɛ́cóú mmɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀ dìì bo mɛtɑummɛ̀ tou ììkɛ̀ kɛ́tuɔ mmɛkùɔ̀ ndipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Di bɑ́ m bútínnɛ́ kɛ́nfeu iwũɔ̃ sibɔɔtenkɑɑnìi sìì dò nyɛbɔdɑkɛ̀. Dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀ di kpɛ́í nnɛ̀ di yɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Á tì mbɛ̀ nɑ̀kɛ́ kɛ̀ bɛ kóò mɔù yoo bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ bɛ̀ bonɛ̀, kòò mɔù n fèútɛ́ fɛɔ̃̀fɛ̀ kɛ tùɔ nyoo ò bɑɑ fɛ̀ nni nfèútɛ́mu, ");
INSERT INTO tbzsim_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","kɛ í fɛ̀ kɔ̀tɛnɛ̀ní mɛtɑummɛ̀ tou borìnùù, kɛ fɛ̀ nni nfèútɛ́ bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Di miɛkɛ kɛ̀ di kóò mɔù di mɛyĩ̀ĩ̀ nyoo bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ di bonɛ̀ kɛ̀ bɛɛ̀ kóò mɔù mɛ̀ di, bɑ́ mùù botí kó mɛyĩ̀ĩ̀, m miɛkɛ bo ò yɛ̀, kɛ̀ nh ò dènnɛ Isidɑyɛɛribɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Kɛ yɛ̃́ mufòmmu bomɛ̀ mɛyĩ̀ĩ̀ mmiɛkɛ nkɛ. Dɛɛ̀ te kɛ̀ n yɛ̃ ndí mmɛ ndɔɔrinɛ̀ ikuɔ́ diwũɔ̃tɔ̀nnì ĩ́nkɛ̀ di yɛi nhũtímù kpɛ́í, kɛ́nfòù, mɛyĩ̀ĩ̀ mmɛɛ̀ ɔ̃ nte kòo nìtìi wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Dɛɛ̀ te kɛ̀ n tu díndi Isidɑyɛɛribɛ nɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ di bonɛ̀, di bɑ́ nyo mɛyĩ̀ĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Kɛ̀ Isidɑyɛɛri yoo opɔ̀ɔ̀ wèè di bonɛ̀, kòò kɔ̀tɛ kupɑɑwɑɑ́ nkɛ kùɔ tɛhontɛ̀ yoo tɛnɔ̀tɛ̀ di yo ndɛ̀, wèe yóu kɛ̀ dɛ yĩ̀ĩ̀ nyɛ̀ kòò mɛ̀ dɑ̀tínnɛ́ mutɑ̃́ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Kɛ yɛ̃́ bɑ́ dɛ̀ dɛ fòmmu bomɛ̀ dɛ yĩ̀ĩ̀ mmiɛkɛ nkɛ. Dɛɛ̀ te kɛ̀ n tu díndi Isidɑyɛɛribɛ di bɑ́ɑ́ di fɛɔ̃̀fɛ̀ mɑfɛ̀ kó mɛyĩ̀ĩ̀, bɑ́ dɛ̀ dɛ fòmmu bo dɛ yĩ̀ĩ̀ mmiɛkɛ nkɛ, kɛ̀ wèè di mɛyĩ̀ĩ̀ mbɛ̀ɛ ò dɛitɛ Isidɑyɛɛribɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Bɑ́ wè dihɛì yiɛ̀ nyoo opɔ̀ɔ̀ kòò di dɛ̀ɛ̀ ku, yoo musĩ̀mmù pĩ ndɛ̀ wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ, ò sĩ̀ntɛmu dɛ yiè kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. Dɛ kó difɔ̃nkúò ò tɛ̃́nkɛ í sĩ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Kòò mɛ nyí ɔ̀ú o yɑ̀ɑ̀tì ò mɛ nyí wùɔ dɛ kó mɛyɛi mbo o yuu ĩ́nkɛ̀ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Kɛ̀ ti Yiɛ̀ Kuyie nní nsɔkɛ́ ku nɑ́ɑǹtì kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ mmí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Di bɑ́ɑ́ tũnnɛ Esibiti kɔbɛ di do bo bɛ̀ɛ̀ cuokɛ̀ bɛ kó mɛborimɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ n di kɔrinɛ̀ kɛ̀ɛ̀ tenkɛ̀ kɔbɛ kɔ̃mɛ nɛ̀ bɛ kuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","N di nɑ̀kɛ́ tì dí nti mpĩ nkɛ tũ n kuɔ́. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Dí ntũ n kuɔ́ nɛ̀ n tɑnnɔ̀, wèè dɔ̀ɔ̀ri n kuɔ́ nɛ̀ n tɑnnɔ̀ dɛ̀ yɛ̃mmɛ̀, weè yó nfòù. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Di kóò mɔù bɑ́ɑ́ duɔ́nɛ̀ nɛ̀ wè bɛ̀ tu mɛyĩ̀ĩ̀ mmɛmɑ́ɑ̀ kɔbɛ! Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Di miɛkɛ òmɔù bɑ́ɑ́ duɔ́nɛ̀ o yɔ̃, kɛ́fɛìkùnnɛ o cicɛ, ò bɑ́ɑ́ duɔ́nɛ̀ o yɔ̃ kɛ́yɑ̀ o fɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Di kóò mɔù bɑ́ɑ́ duɔ́nɛ̀ o cicɛ pokù kóò fɛ̀ìkùnnɛ, o cicɛ pokù nwe. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Òmɔù di miɛkɛ bɑ́ɑ́ duɔ́nɛ̀ o tɑ̃ũ̀, kɛ̀ bɛ̀ wɛ̃ mbɛ yɔ̃ yoo bɑ́ kòo yɔ̃ yɑnto kou nwe. Kɛ̀ bɛ̀ ò pɛitɛ́ tɛcĩ́ɛ̃̀tɛ̀ yoo bɛ̀ ò pɛitɛ́ kupíkù mɑkù, ò bɑ́ɑ́ ò duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Di miɛkɛ òmɔù bɑ́ɑ́ duɔ́nɛ̀ o birɛ kóo sɑpɑ̀ɑ̀ nyoo o kóo dɑpɑ̀ɑ̀ nkou, o mɔ́mmuɔ nho kóo sɑpɑ̀ɑ̀ nwe. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Òmɔù bɑ́ɑ́ duɔ́nɛ̀ o tɑ̃ũ̀ nɛ̀ wè bɛ̀ wɛ̃ mbɛ cicɛ, o cicɛ birɛ ndɛ, kòò tu o tɑ̃ũ̀, ò bɑ́ɑ́ ò duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Di kóò mɔù bɑ́ɑ́ duɔ́nɛ̀ o cicɛ tɑ̃ũ̀, kɛ yɛ̃́ o cicɛ nɛ̀ o tɑ̃ũ̀ bɛ̀ tumɛ̀ mɛyĩ̀ĩ̀ mmɛ̀mɑ́ɑ̀ kɔbɛ mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Di miɛkɛ òmɔù bɑ́ɑ́ duɔ́nɛ̀ o yɔ̃ nɑntɛ̀ yoo o yɔ̃ kóo kótì nɛ̀ o yɔ̃ bɛ̀ tu mɛyĩ̀ĩ̀ mmɛ̀mɑ́ɑ̀ kɔbɛ mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Òmɔù bɑ́ɑ́ duɔ́nɛ̀ o cicɛ nɑntɛ̀ pokù, kɛ yɛ̃́ o cicɛ nɑntɛ̀ pokù nwemɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Di miɛkɛ òmɔù bɑ́ɑ́ duɔ́nɛ̀ o birɛ pokù, o kóo dɑpɑ̀ɑ̀ mpokù nwe, ò bɑ́ɑ́ ò duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Di miɛkɛ òmɔù bɑ́ɑ́ duɔ́nɛ̀ o nɑntɛ̀ pokù. O nɑntɛ̀ pokù nwe, ò bɑ́ɑ́ ò duɔ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Di kóò mɔù bɑ́ɑ́ duɔ́nɛ̀ onitipòkù mɔù kɛ́wɛ̃tɛ kɛ́duɔ́nɛ̀ o kóo sɑpɑ̀ɑ̀ nyoo o kóo dɑpɑ̀ɑ̀ mbirɛ, bɛ̀ tu mɛyĩ̀ĩ̀ mmɛ̀mɑ́ɑ̀ kɔbɛ mbɛ, dɛ̀ tu isɔkɛ nyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Di miɛkɛ òmɔù bɑ́ɑ́ túótɛ́ o pokù nɑntɛ̀ yoo o kóo kótì, kòo pokù kpɑɑ́ kɛ fòù kɛ̀ bɛ̀ɛ yɑntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","Di miɛkɛ òmɔù bɑ́ɑ́ duɔ́nɛ̀ onitipòkù ò yùɔ́ ndìì mɔ̀nnì, ò sĩ̀mmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Òmɔù bɑ́ɑ́ duɔ́nɛ̀ otɔù pokù, kòò ò duɔ́nɛ̀ ò sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Di miɛkɛ òmɔù bɑ́ɑ́ féútɛ́ o birɛ dibɔɔ̀ Mɔdɔki kɛ́tuɔ kɛ́cɑkɛ n yètìrì. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Di miɛkɛ òmɔù bɑ́ɑ́ duɔ́nɛ̀ onitidɔ̀ù bɛ̀ dɔunɛ̀ mɛ̀ɛ̀ botí onitipòkù. Dɛ tu isɔkɛ nyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","Di miɛkɛ òmɔù bɑ́ɑ́ duɔ́nɛ̀ fɛɔ̃̀fɛ̀ kɛ́sĩnkùnnɛ omɑ́ɑ̀, onitipòkù mɛ mbɑ́ɑ́ yóu kɛ̀ fɛɔ̃̀fɛ̀ɛ ò duɔ́nɛ̀. Dɛ̀ tu isɔkɛ nyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","Di bɑ́ɑ́ sĩnkùnnɛ dimɑ́ɑ̀ nɛ̀ dɛ kó mɛborimɛ botí, yɛbotɛ̀ yɛ̀ɛ̀ bo di ììkɛ̀ n yóó bɛti yɛ̀, yɛ̀ mɛ ndɔ̀ɔ̀ kɛ sĩ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Dihɛì di mɔ́mmɔnni kɛ̀ dì sĩ̀ntɛ kɛ̀ ndì potɛ́, di yɛi nkpɛ́í nkɛ̀ dì tɔ̃́ di nìtìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Díndi mpĩ́ ndi nɑ̀kɛ́ tì nɛ̀ n kuɔ́. Dihɛì yɛmbɛ̀ nɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ di bonɛ̀ bɛ kóò mɔù bɑ́ɑ́ dɔɔ̀ dɛ kó isɔkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Kɛ yɛ̃́ bɛ̀ɛ̀ di niitɛ́nɛ̀ní dɛ kó dihɛì miɛkɛ bɛ̀ i ndɔ̀ɔ̀, kɛ̀ dihɛì sĩ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Kɛ̀ di dɔ̀ɔ̀ dɛ kó isɔkɛ dihɛì múnkɛ yóó di tɔ̃́mu dì tɔ̃́ mɛ̀ɛ̀ botí bɛ̀ɛ̀ di niitɛ́nɛ̀ní. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Kɛ̀ wèè dɔ̀ɔ̀ dɛ kó isɔkɛ botí, bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Mpĩ́nnɛ̀ n kuɔ́ kɛ bɑ́ɑ́ dɔɔ̀ dɛ kó isɔkɛ bɛ̀ɛ̀ di niitɛ́nɛ̀ní bɛ̀ do dɔ̀ɔ̀ri ì. Di bɑ́ɑ́ sĩnkùnnɛ dimɑ́ɑ̀. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nni nsɔkɛ́ ku nɑ́ɑǹtì kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ bɛmɔu kɛ tú: Mí ndi Yiɛ̀ nKuyie mmíì di te, ndònnɛ̀ mpɑ́íí, kɛ yɛ̃́ n dòmmɛ̀ pɑ́íí nwe. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Bɑ́ wè, wè ndé o yɔ̃ nɛ̀ o cicɛ kɛ́ntũ n di nɑ̀kɛ́ tì tɛom̀pùtɛ̀ kó diyiè kpɛ́í, mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","Di bɑ́ɑ́ duɔ́ ndimɑ́ɑ̀ yɛbɔkɛ̀, di bɑ́ɑ́ yiɛ̀ ntimɑ́tì kɛ́utɛ́ sibɔɔtenkɑɑnìi, mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Kɛ̀ di yó m pɑ̃ fɛɔ̃̀fɛ̀ mɛtɑummɛ̀ kpɛ́í ndi fɛ̀ nni mpɑ̃ dɛ̀ bo yiennɛ̀mɛ̀ kɛ̀ n fɛ̀ cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Kɛ̀ di fɛ̀ nni nfèútɛ́ di fɛ̀ cɑ̀ɑ́kɛ́ dɛ yiè nɛ̀ dɛ̀ bo wentɛ́mɛ̀, kɛ̀ fɛ̀ kpɑɑ́ kɛ tùɔ̀kɛnɛ̀ diyiè tɑ̃ɑ̃́nnì di fɛ̀ tùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Kòò mɔù fɛ̀ cɑ̀ɑ́kɛ́ diyiè tɑ̃ɑ̃́nnì, dɛ yiɛ̀ n tɛ̃́nkɛ bɑ́ɑ́ ò cɔutɛ́, dɛ̀ ò sĩ̀nkùnnɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Kɛ̀ wèè ì cɑ̀ɑ́kɛ́ weè tɔ dɛ kó mɛyɛi, nkɛ yɛ̃́ ò í ì wèńtɛ́ kɛ dò mbɛ̀ ì nni mpɑ̃. Bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Kɛ̀ di níí dɛ̀itɛ di pɑɑ nkó tidiitì di bɑ́ɑ́ tɑunnɛ̀ tìì bo di pɑɑ mmɑ̀nku, kɛ̀ di dɛ̀itɛ di diitì kɛ dèè di bɑ́ɑ́ kóntɛ́ kɛ́dɛ́rí. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Kɛ̀ di mɛ ntɔ̃̀ũ dɛtie mbɛ̀ tu dɛ̀ fínyĩ̀ dɛ bɛ nyɛ, di bɑ́ɑ́ kóntɛ́ kɛ́tɑ̃nkɛ́ yɛbɛ yɛ̀ɛ̀ duò yoo dí dɛ́rí. Di níí yɛ̀ yóu bɛcĩ̀rìbɛ̀ nɛ̀ bɛpɔ̀ɔ̀bɛ̀ kpɛ́í. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","Di miɛkɛ òmɔù bɑ́ɑ́ yúúkú o kou, yoo wèe ò soutɛ́ yoo wèe ò ciitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","Di níí bɑ́ɑ́ pɑrìkɛ̀ nɛ̀ n yètìrì kɛ nɛ́ soú, kɛ̀ di dɔ̀ɔ̀ mɛmmɛ di cɑ̀ɑ̀rɛ̀ n yètìrì ndi mí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Di miɛkɛ òmɔù bɑ́ɑ́ ciitɛ́ otɔù kɛ́di o kpɛrɛ, ò mɛ mbɑ́ɑ́ ò yùúkú, otɔ̃ntì kó tiyeti mɛ mbɑ́ɑ́ wentɛ́ di kóò mɔù borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Di miɛkɛ òmɔù bɑ́ɑ́ sɑ̃́ɑ̃́ ndiɔ̃̀nnì, òmɔù mɛ mbɑ́ɑ́ dɔú mmɛdíímmɛ̀ kuyũ̀ɔ̃̀nkù kó kucɛ miɛkɛ. Di nni ndé. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","Òmɔù bɑ́ɑ́ bekɛ́ tibeéntì mɛyɛi. Mɛbɑtimɛ̀ bɑ́ mbo, òmɔù bɑ́ɑ́ kónnɛ́ ocĩ̀rì, òmɔù mɛ mbɑ́ɑ́ yɔtɛ okperì. Bɑ́ wè ò níí bekɛ́ tibeéntì tì dò nwèe tì bekɛ́ mɛ̀ɛ̀ botí. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","Di miɛkɛ òmɔù bɑ́ɑ́ wɑ́tí o kou, òmɔù bɑ́ɑ́ tou nho kou tinɑ́ɑǹtì kɛ́nte kɛ̀ bɛ̀ɛ ò kùɔ. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","Òmɔù bɑ́ nníí nho kou tɔù, kɛ̀ dɛ̀ nɛ́ dò nhɑ ò kpɑnnɛ̀, ɑ bɑ́ɑ́ yóu ɑ bo ò kpɑnnɛ̀mɛ̀ kɛ̀ dɛ̀ɛ̀ yie nkɑ̀ɑ bɑ́ɑ́ tɔ mɛyɛi mmɑmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Di miɛkɛ òmɔù bɑ́ɑ́ pɛitɛ yoo ò nhu o kou mɛdɔ̀mmɛ̀, bɑ́ wè, wè ndɔ́ o kou tɔù ò dɔ́ mɛ̀ɛ̀ botí omɑ́ɑ̀. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","Di ntũ n kuɔ́, òmɔù di miɛkɛ bɑ́ɑ́ yóu kòo wũɔ̃ ìì cɑ̃̀ɑ̃́ nkubotí kɛ̀ ìì dekɛ itɔbɛ̀, òmɔù bɑ́ɑ́ buɔtí kupɑku kùmɑ́ɑ̀ idibotí ìdɛ́ì ìì cɑ̃̀ɑ̃́. Òmɔù di miɛkɛ níí bɑ́ɑ́ dɑ́ɑ́tí tiyɑ̀ɑ̀tì tìì dùɔ̀kɛnɛ̀ mupɑɑ̀kómmú mùù cɑ̃̀ɑ̃́ nyibotí. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Kòò mɔù duɔ́nɛ̀ kudɑɑkù, kɛ̀ dɛ̀ sɔ̃́ nhòmɔù kù cɛ̃, ò mɛ mmu nyí wɛ̃̀tɛ kɛ kù dontɛ́ ku yiɛ̀ mborɛ̀ ku yiɛ̀ mmɛ mmu nyí kù fĩ́ĩ, nwèe yietí kɛ́fɔ́ɔ́, mbɛ̀ mɛ mbɑ́ɑ́ bɛ̀ kùɔ, kɛ yɛ̃́ ò do kpɑɑ́ túmɛ̀ kudɑɑkù nku. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Wèe wɑɑ́ ndipedɑɑ̀ mɛyɛi nhũtímù kpɛ́í, kɛ́ dì kɔ̀tɛnɛ̀ní mɛtɑummɛ̀ tou bòrìnùù. Mɛyɛi nhũtímù kó fɛɔ̃̀fɛ̀ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kɛ̀ ikuɔ́ nìùtìi dɔɔ̀ dɛ yiɛ̀ mmɛyɛi nhũtímù kó ikuɔ́ kɛ̀ nh ò cĩ̀ɛ̃́ mmɛyɛi nhò dɔ̀ɔ̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Kɛ̀ di tɑ dìì mɔ̀nnì Kɑnnɑhɑ̃ɑ̃ kó dihɛì kɛ fìíkú dɛtie ndɛ botí dɛ botí dɛ̀ɛ̀ pɛí, dɛ̀ pɛí yɛ̀ɛ̀ bɛ yó ntú yɛsĩ̀nyɛ nyɛ di kpɛ́í yɛbie nyɛ̀tɑ̃ɑ̃ti di bɑ́ nyɛ̀ yo. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Dibenni nɑɑnnì kɛ̀ dí ɑ̃nnɛ́ dibɑnni kɛ́ n dɔunnɛ̀ mutɔ̃mmú kɛ́ yɛ̀ nni mpɑ̃ yɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Dibenni nummurì ndi di yóó dimɛ̀ dɛ bɛ, kɛ́ yɛ̀ dɛ̀itɛ kɛ́ yɛ̀ ntú di kpɛyɛ. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","Òmɔù bɑ́ɑ́ cɑ́ɑ́kɛ́ fɛɔ̃̀fɛ̀ bɛ̀ í fèútɛ́ fɛ̀ kɛ̀ fɛ yĩ̀ĩ̀ ncòú. Òmɔù bɑ́ mpɑ̃ũ̀ yoo wè ndɔɔri dɛnitinɔ̀nkpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","Di níí bɑ́ɑ́ kuó kɛ́cíútɛ́, di mɛ nníí bɑ́ɑ́ kuó di nucìtì kɛ́soó nfɛdɛɛ̀nfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","Di níí bɑ́ ndɔɔri ikúsié kɛ yɔ́ú dimɑ́ɑ̀, di bɑ́ ndɔ́ú dimɑ́ɑ̀. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","Òmɔù bɑ́ɑ́ duɔ́ nho birɛ tɛbɔɔcĩ́ɛ̃̀tɛ̀ kɛ́nte kɛ̀ dɛ̀ɛ tũnnɛ yɛbɔkɛ̀, kɛ́nte kɛ̀ dihɛì dimɔuu ndɛ dɔunɛ̀ kɛ dɔɔri isɔkɛ kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","Dí ntũ ndi nɑ̀kɛ́ tì tɛom̀pùtɛ̀ ĩ́nkɛ̀, kɛ́mmɔkɛ mɛtɑummɛ̀ tou kó kufɔ̃wɑɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","Di bɑ́ nkɔrì bɛ̀ɛ̀ bourí tinùbootì nɛ̀ bɛpɑ̃ɑ̃bɛ̀ borɛ̀, dɛ̀ di sĩnkùnkomu. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","Kòo kótì níí tùɔ̀kɛní ɑ́ ítɛ́ kóò feí ndikɑ̀rì kɛ́ndé odɑkótì nɛ̀ dɛɛ̀ miɛkɛ nkɛ di bo bɛnkɛmɛ̀ kɛ dò ndi n dé, mí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Kòo pɔ̀ɔ̀ kɔ̀tɛní kɛ di bonɛ̀ di bɑ́ nhò cií. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Opɔ̀ɔ̀ wèè di bonɛ̀ dí nhò wùó nkɛ dò ndi kou, kɛ́ nhò dɔ́ di dɔ́ mɛ̀ɛ̀ botí dimɑ́ɑ̀, kɛ yɛ̃́ di múnkɛ do túmɛ̀ bɛpɔ̀ɔ̀bɛ̀ mbɛ Esibiti. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","Di dɔɔ̀rìmɛ̀ ntú mɛ̀ɛ̀ wenni dɛmɔu miɛkɛ. Kɛ̀ di dɔ́ dìì mɔ̀nnì kɛ́bennɛ́ dɛ̀mɑrɛ̀ dɛ pɛ̃kùmɛ̀ yoo dɛ cɛ̃́ɛ̃́kù dí bennɛ́ kɛ̀ dɛ̀ nwenni. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Di biepeé nɛ̀ di cìdóòbɛ̀ dɛ̀ níí ntú dɛ̀ɛ̀ wenni, kɛ̀ dí bennɛ́ kɛ̀ dɛ̀ nwenni. Mí ndi Yiɛ̀ nKuyie mmíì di te, kɛ di dènnɛní Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","Dí mpĩ́ n di nɑ̀kɛ́ tì timɔu nɛ̀ n tié nyimɔu, kɛ́ndɔɔri dɛ̀ yɛ̃mmɛ̀. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú, kɛ̀ di kóò mɔù yoo opɔ̀ɔ̀ wèè di bonɛ̀ kòò fèútɛ́ o birɛ dibɔɔ̀ Mɔdɔki bɛ̀ɛ ò kùɔ. Dihɛì yɛmbɛ̀ɛ ò bùɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Kòò mɔù mɛ̀ dɔ̀ɔ̀ mí m mɔ́mmuɔ m miɛkɛ yóó ò yɛ̀mu, kɛ̀ nh ò dènnɛ o kɔbɛ miɛkɛ. Kɛ yɛ̃́ ò fèútɛ́mɛ̀ o birɛ dibɔɔ̀ Mɔdɔki kɛ sĩ̀nkùnnɛ mɛtɑummɛ̀ tou, kɛ cɑ̀kɛ n yetisɑ̀ɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Kɛ dihɛì yɛmbɛ̀ bùútóo dɛ kpɛti, kɛ í dɔ́ kóò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","Mí m mɔ́mmuɔ mmíì miɛkɛ yóó ò yɛ̀, wenwe nɛ̀ o fuku kumɔu, kɛ̀ m bɛ̀ dènnɛ bɛ kɔbɛ miɛkɛ, nɛ̀ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ ò tũ̀nnɛ kɛ fìé dɛ kó dibɔɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Kɛ̀ wèè bùtínnɛ́ mí ndi Yiɛ̀ nKuyie nkɛ kɔrì bɛ̀ɛ̀ bourí tinubootì nɛ̀ bɛpɑ̃ɑ̃bɛ̀ borɛ̀, m miɛkɛ yóó ò yɛ̀mu kɛ̀ nhò dènnɛ o kɔbɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ncɑ̃́ɑ̃́nnɛ̀ kɛ dò mpɑ́í pɑ́í mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Dí ntũ n tié nkɛ ndɔɔri n yɛ̃mmɛ̀ mí ndi Yiɛ̀ nKuyie mmíì di tɑ̃ɑ̃tɛ́ kɛ̀ di cɑ̃́ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Wèè sɑ̃̀ɑ̃́ nho cicɛ yoo o yɔ̃ bɛ̀ɛ ò kùɔ. Ò kùɔ omɑ́ɑ̀ ndi kɛ yɛ̃́ o sɑ̃̀ɑ̃́mmɛ̀ o cicɛ nwe yoo o yɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Kɛ̀ wèè duɔ́nɛ̀ otɔù pokù bɛ̀ɛ bɛ̀ kùɔ bɛdɛ́, wenwe nɛ̀ dɛ kóo nitipòkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Kòò mɔù duɔ́nɛ̀ o cicɛ pokù bɛ̀ɛ bɛ̀ kùɔ bɛdɛ́ wenwe nɛ̀ dɛ kóo nitipòkù. Bɛ̀ kùɔ bɛmɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Kɛ̀ wèè duɔ́nɛ̀ o birɛ pokù ò dɔ̀ɔ̀ isɔkɛ nyi bɛ̀ɛ bɛ̀ kùɔ. Bɛ̀ kùɔ bɛmɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Kòò mɔù duɔ́nɛ̀ onitidɔ̀ù bɛ̀ dɔunɛ̀mɛ̀ onitipòkù, bɛ̀ dɔ̀ɔ̀ isɔkɛ nyi, bɛ̀ɛ bɛ̀ kùɔ bɛdɛ́. Bɛ̀ kùɔ bɛmɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Kòò mɔù po onitipòkù kɛ wɛ̃̀tɛ kɛ tùótɛ́ dɛ kóo nitipòkù yɔ̃, isɔkɛ nyi bɛ̀ɛ bɛ̀ cɔ́u nwenwe nɛ̀ dɛ kóo nitipòkù kɛ́dɛitɛ isɔkɛ di cuokɛ̀. Bɛ̀ kùɔ bɛmɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Kòò mɔù duɔ́nɛ̀ fɛɔ̃̀fɛ̀ bɛ̀ɛ ò kùɔ kɛ́kuɔ dɛ kó fɛɔ̃̀fɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Kòo nitipòkù mɔù yóu kɛ̀ fɛɔ̃̀fɛ̀ ò duɔ́nɛ̀ bɛ̀ɛ ò kùɔ kɛ́kuɔnɛ̀ dɛ kó fɛɔ̃̀fɛ̀. Dɛ̀ kùɔ dɛmɑ́ɑ̀ ndi dɛdɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Kòò mɔù puokɛ o tɑ̃ũ̀ kɛ̀ bɛ̀ cɑ̃̀ɑ̃́ mbɛ yɔ̃ yoo bɛ cɑ̃̀ɑ̃́ mbɛ cicɛ, kòò ò duɔ́nɛ̀ ifɛi kpɛrɛ ndɛ. Bɛ̀ɛ bɛ̀ dɛ̀itɛ bɛ botí kɔbɛ miɛkɛ bɑ́ wè kòò nwúó, dɛ kó mɛyɛi mbo bɛ yɔ ĩ́nkɛ̀ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Kɛ̀ wèè mɛ nduɔ́nɛ̀ onitipòkù ò yùɔ́ ndìì mɔ̀nnì, kɛ yɑ̀ o yɔ́ntì bɛ̀ɛ bɛ̀ dènnɛ Isidɑyɛɛribɛ miɛkɛ. Kɛ yɛ̃́ bɛ̀ yɛ̃́mɛ̀mu bɛdɛ́ ò yùɔ́mmɛ̀ kɛ duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","Òmɔù bɑ́ɑ́ duɔ́nɛ̀ o yɔ̃ nɑntɛ̀ yoo o yɔ̃ kóo kótì yoo o cicɛ tɑ̃ũ̀. Di tú mɛyĩ̀ĩ̀ mmɛ̀mɑ́ɑ̀ kɔbɛ mbɛ, kòò mɛ̀ dɔ̀ɔ̀ bɛɛ̀ yóó tɔ dɛ kó mɛyɛi. Wèè mɛ̀ dɔ̀ɔ̀ wenwe nɛ̀ ò duɔ́nɛ̀ wè bɛ̀ tɔ bɛdɛ́ ndi dɛ kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Kɛ̀ wèè puokɛ o cicɛ nɑntɛ̀ pokù yoo o cicɛ kóo kótì kou bɛdɛ́ bɛ̀ɛ tɔ dɛ kó mɛyɛi. Bɛ̀ bo kú bɑ́ bɛ̀ í mɔ̀ɔ̀tɛ dɛbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Wèè puokɛ o nɑntɛ̀ pokù yoo o kóo kótì pokù ò sĩ̀nkùnnɛ omɑ́ɑ̀ ndi, bɛ̀ bɑ́ɑ́ pɛ́tɛ́ dɛbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","Dí mpĩ́ n di nɑ̀kɛ́ tì timɔu nɛ̀ n tié nkɛ́ndɔɔri dɛ̀ yɛ̃ mmù kɛ̀ dɛ̀ɛ yie nkɛ̀ dihɛì n di kɔrinɛ̀ dì bɑ́ɑ́ di tɔ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Di bɑ́ɑ́ tũnnɛ ibotí n yóó bɛti ì dɛ kó dihɛì miɛkɛ ì borimɛ, bɛ̀ mɛ ndɔ̀ɔ̀ kɛ̀ m bɛ̀ pɛ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","N di nɑ̀kɛ́mu kɛ tú: Míì mɔ́mmuɔ nyóó di duɔ́ ndɛ kó kɛtenkɛ̀, mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃̀ nkɛ̀. Mí ndi Yiɛ̀ nKuyie mmíì di te kɛ di cɑ̃̀ńnɛ́ nɛ̀ ibotí tɛì. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Mbɑɑ̀tìnɛ̀ tũnkɛ́ iwũɔ̃, n yɛ̃ ndí nyo nyì nɛ̀ n yɛ̃ ndí nci ì. Di bɑ́ɑ́ di n yɛ̃ ndí nci kùù wɑnwɑnkù yoo tɛ̀ɛ̀ nɔ̀tɛ̀ yoo dɛ̀ɛ̀ bɑmbɑɑ̀nnɛ̀ kɛ́sĩnkùnnɛ dimɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ndònnɛ̀ pɑ́íí, kɛ́ncɑ̃́ɑ̃́ nkɛ tú n kɔbɛ, kɛ yɛ̃́ mí ndi Yiɛ̀ nKuyie ndòmmɛ̀ pɑ́íí nwe, kɛ̀ míì di cɑ̃̀ńnɛ́nɛ̀ ibotí tɛì, kɛ̀ di bo ntú n kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Di miɛkɛ kòo nitidɔ̀ù mɔù yoo onitipòkù tu opɑ̃ũ̀ yoo ò boorí tinubootì, bɛ̀ɛ ò bùɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ. Ò kùɔ omɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nní nsɔkɛ́ ku nɑ́ɑǹtì kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Nɑ́kɛ́ ikuɔ́ nìùbɛ̀ Anɔɔ bí kɛ dɔ̀: Ikuɔ́ nìùtì mɔù bɑ́ɑ́ tɔ́ɔ́nnɛ̀ o cĩ́ɛ̃̀tɛ̀ kóo cíì mɔù kɛ́sĩnkùnnɛ omɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Kɛ̀ dɛ̀ sɑ̀ɑ̀ í tú o cĩ́ɛ̃̀tɛ̀ kou mɔ́mmuɔ nwe. O cicɛ yoo o yɔ̃ yoo o birɛ yoo o nɑntɛ̀ yoo o kóo kótì. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","Nɛ̀ o tɑ̃ũ̀ wèè kpɑɑ́ tɛcĩ́ɛ̃̀tɛ̀ kɛ mu nyí yĩ̀ɛ̃́tɛ́ onitidɔ̀ù kɛ yɛ̃́ ò mu nyí yenkɛmɛ̀, ò bo nɑ kóò kɑ̀ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Wenwe wèè ni bɛnìtìbɛ̀, ò bɑ́ɑ́ dɔɔ̀ dɛ̀ɛ̀ ci o cĩ́ɛ̃̀tɛ̀ miɛkɛ kɛ́sĩ̀nkùnnɛ omɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Ikuɔ́ nìùbɛ̀ níí bɑ́ɑ́ fentɛ́ fentɛ́ tiyùtì bɛ yɔ ĩ́nkɛ̀, yoo bɛ̀ɛ kuó bɛ nucìtì kɛ́soó mbɛ dɛbìi, bɛ̀ mɛ mbɑ́ɑ́ dúɔ́kɛ́ bɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Bɛ̀ cɑ̃̀ɑ̃́mmu kɛ bo n kó mutɔ̃mmú kpɛ́í. Bɛ̀ bɑ́ɑ́ cɑkɛ n yètìrì, bɛɛ̀ n feu iwũɔ̃ bɛ̀ m pɑ̃ɑ̃ nyì. Nɛ̀ dɛ kpɛ́í mbɛ̀ dò nkɛ́ndò mpɑ́íí nwe. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Dɛ̀ cimu ikuɔ́ nìùtì bo puokɛmɛ̀ onitipòkù wèè dɔuti dɔutinɛ̀ bɛnitidɑɑbɛ̀ yoo osɑpɑ̀ɑ̀ mbɛ̀ cɑ̀kɛ wè, yoo onitipòkù wèè yenkɛ kɛ yentɛ́, ikuɔ́ nìùtì cɑ̃̀ɑ̃́mmu kɛ tú n kóo nìtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Di dò nkɛ́nwúó nyikuɔ́ nìùbɛ̀ bɛnìtìbɛ̀ n tɑ̃ɑ̃tɛ́ bɛ̀mbɛ n tɔ̃mmú kpɛ́í bɛ̀ cɑ̃̀ɑ̃́mmu, kɛ yɛ̃́ bɛɛ̀ n feumɛ̀ iwũɔ̃ di m pɑ̃ɑ̃ nyì. Dí mbɛ̀ wùó mbɛnìtìbɛ̀ bɛ̀ɛ̀ cɑ̃̀ɑ̃́ nkɛ dò mpɑ́íí. Mí ndi Yiɛ̀ nKuyie mmíì bɛ̀ cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Kɛ̀ ikuɔ́ nìùtì mɔù kóo sɑpɑ̀ɑ̀ ncɑ̀kɛ omɑ́ɑ̀ kɛ dɔuti dɔutinɛ̀ bɛnitidɑɑbɛ̀ ò ɑ̃nnɛ́ o cicɛ nwe ifɛi, bɛ̀ɛ cɔ́u ndɛ kóo sɑpɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Ikuɔ́ nìùtì diɛwè wèè bɑkɛ́ bɛsɔmbɛ, bɛ̀ còú nwèè yuu mɛkùɔ̀ nkoò cɑ̃̀ńnɛ́ kòò dɑɑti ikuɔ́ yɑ̀ɑ̀tì, ò bɑ́ɑ́ yóu kòo yùtìi yɛ̃kɛ́ ò mɛ mbɑ́ɑ́ yóu kòo yɑ̀ɑ̀tìi kɛ̃rí. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Ò bɑ́ɑ́ tɔ́ɔ́nnɛ̀ ocíì kɛ́sĩnkùnnɛ omɑ́ɑ̀, bɑ́ kòo cicɛ nwe yoo o yɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ò bɑ́ɑ́ yɛ̀ mɛtɑummɛ̀ tou, ò yɑ̀ɑ̀ bo dì sĩ̀nkùnnɛ mɛ̀ɛ̀ kpɛ́í. Bɛ̀ ò còú mmɛkùɔ̀ mmɛ koò cɑ̃̀ńnɛ́ mí nKuyie n kpɛ́í. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Wèe puokɛ osɑpɑ̀ɑ̀ nwèè mu nyí yɛ̃́ onitidɔ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Ò bɑ́ɑ́ puokɛ okúpokù yoo wèè yenkɛ kɛ yentɛ́ yoo wèè dɔuti dɔutinɛ̀ bɛnitidɑɑbɛ̀ kɛ cɑ̀kɛ omɑ́ɑ̀. Ikuɔ́ nìùbɛ̀ botí miɛkɛ nkɛ ò dò nkɛ́tɑ̃ɑ̃tɛ́mɛ̀ osɑpɑ̀ɑ̀ nwèè mu nyí yɛ̃́ onitidɔ̀ù, kɛ́puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Ò yɑ̀ɑ̀ bo sĩ̀nkùnnɛ o fuku. Mí ndi Yiɛ̀ nKuyie mmíì ò cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","Nɑ́kɛ́ Anɔɔ kɛ tú n yɛ̃ nnɛ̀ bɛ̀ bo mbomɛ̀ nɛ̀ bɛ yɑɑ̀bío ikuɔ́ nìùtì wèè mɔ̀kɛ kuyɛ̀nkù ó bɑ́ n féútɛ́ fɛɔ̃̀fɛ̀ yoo ò m pɑ̃ tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Kòò mɔ̀kɛ kuyɛ̀nkù bɑ́ kùù botí ò bɑ́ɑ́ nɑ kɛ́pĩ́ ndɛ kó mutɔ̃mmú, kòò tu kuyũ̀ɔ̃̀nkù yoo dikpɛ̃nnì yoo dɛ̀mɑrɛ̀ yetɛ́ o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Kòo tɑ̀ɑ̀ku kuù mɛ nkèétɛ́ yoo o bɑkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Kòò tu tɛhùtɛ̀ yiɛ̀, yoo ò dò ndɛcĩ̀ĩ̀rɛ̀ yoo ò ɑ̃ dinɔmpénnì yoo mɛkpɑ̃̀ɑ̃̀, yoo tɛwũɔ̃tɛ̀ mɑtɛ̀ ɑ̃ o kɔ̃̀ntì yoo o tɑkuò mpɔ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Anɔɔ kó kufuku miɛkɛ ikuɔ́ nìùtì mɔù bɑ́ n féútɛ́ fɛɔ̃̀fɛ̀ yoo ò m pɑ̃ tidiitì kɛ́nsɑ̀ kòò mɔ̀kɛ kuyɛ̀nkù, ò bɑ́ɑ́ nɑ kɛ́pĩ́ nyikuɔ́ nìùtì kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Dɛ yiɛ̀ mbo nɑ kɛ́di bɛ̀ m pɑ̃ tìì diitì yoo bɛ̀ m pɑ̃ dɛ̀ kɛ yɛ̃tɛ́ kɛ tuɔ nkɛ sùɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Ò mɛ mbɑ́ɑ́ tɑ mɛtɑummɛ̀ tou kuyɑ̀ɑ̀kù kpetí dɛ̀ yoo wèe tɔ́ɔ́nnɛ̀ diwũɔ̃tɔ̀nnì, ò tu kuyɛ̀nkù yiɛ̀ nwe, ò yɑ̀ɑ̀ bo sĩnkùnnɛ mɛtɑummɛ̀ tou nɛ̀ di nɛntì. N tú di Yiɛ̀ nKuyie nku kɛ míì dɛ̀ cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Mɛm̀mɛ, kɛ̀ Mɔyiisii tì nɑ̀kɛ́ Anɔɔ nɛ̀ o bí nɛ̀ Isidɑyɛɛribɛ sɔmbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","Nɑ́kɛ́ Anɔɔ nɛ̀ o bí, n yɛ̃ nkòo nìtì níí dòmmɛ̀ ò bɑ́ɑ́ di Isidɑyɛɛribɛ m pɑ̃ dɛ̀ kɛ́sĩnkùnnɛ n yetìsɑ̀ɑ̀rì. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Nɑ́kɛ́ bɛ kɛ tú, n yɛ̃ mbɛ kó kufuku nɛ̀ bɛ yɑɑ̀bío kɛ̀ wèè sĩ̀ nkɛ kɑ̀ɑ́kɛ́ bɛ̀ m pɑ̃ dɛ̀, bɛ̀ɛ ò dènnɛ n kɔbɛ miɛkɛ míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Anɔɔ kó kufuku miɛkɛ kɛ̀ tikɔ̀ntì pĩ nhòmɔù yoo ò tùɔ̀ti yɛfɔtɛ̀ kɛ̀ mu nyí wenkɛ ò bɑ́ɑ́ di bɛ̀ m pɑ̃ dɛ̀. Dɛ̀ mɛ ndò nɛ̀ wèè kɑ̀ɑ́kɛ́ ocíì kɛ sĩ̀ntɛ nɛ̀ wèè bo nduɔ́ kɛ́yɛ̃nkɛ nɛ̀ omɑ́ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","nɛ̀ wèè bo kɑ́ɑ́kɛ́ dɛbɑmbɑɑ̀nnɛ̀ mɑrɛ̀ kɛ́sĩntɛ, yoo òmɔù wèè kɑ̀ɑ́kɛ́ dɛ̀ɛ̀ sĩ̀ nkɛ́sĩnkùnnɛ omɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Kòò sĩ̀nkùnnɛ omɑ́ɑ̀ mɛbotí ò sĩ̀mmu kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. Ò bɑ́ɑ́ nɑ kɛ́di bɛ̀ m pɑ̃ dɛ̀ kɛ́mbɑɑnɛ̀ ò bo wuɔmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Kuyuoku mɔ̀nnì ò wenkɛmu ò bo nɑ kɛ́di bɛ̀ m pɑ̃ dɛ̀ kɛ yɛ̃́ ò kó mudiì mmumɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Òmɔù di miɛkɛ bɑ́ɑ́ di fɛɔ̃̀fɛ̀ fɛ̀ɛ̀ ku yoo musĩ̀mmù pĩ nfɛ̀. Kòò fɛ̀ di ò sĩ̀ntɛmu. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Bɛ̀ ntũ m bɛ̀ nɑ̀kɛ́ tì kɛ̀ dɛ̀ɛ yie nkɛ̀ bɛ̀ bɑ́ɑ́ di ikuɔ́ yetɛ dɛ̀ kɛ́tɔ dɛ kó mɛyɛi, kɛ̀ bɛ̀ dɛ̀ di, bɛ̀ yɑ̀ɑ̀ bo kú. Míì tu di Yiɛ̀ nKuyie mmíì di cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Kɛ̀ bɛ̀ m pɑ̃ dɛ̀mɑrɛ̀ wèè í tú ikuɔ́ nìùtì ò bɑ́ɑ́ dɛ̀ di. Bɑ́ kɛ̀ ikuɔ́ nìùtì kóo pɔ̀ɔ̀ nwe yoo o kóo tɔ̃ntì ò bɑ́ɑ́ dɛ̀ di. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Kɛ̀ ikuɔ́ nìùtì mɛ ndontɛ́ kudɑɑkù, kù bo nɑ kɛ́ dɛ̀ di kɛ́ndònnɛ̀ bɛ̀ pɛitɛ́ kù tɛcĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Kɛ̀ ikuɔ́ nìùtì mɔ̀kɛ osɑpɑ̀ɑ̀ nkòò yenkɛ wèè í tú ikuɔ́ nìùtì ò bɑ́ɑ́ nɑ kɛ́di bɛ̀ m pɑ̃ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Kòo dɔù mɛ nku yoo bɛ̀ ò bɛ̀ti kòò konní bɑ́ ò í mɔkɛ dɛbirɛ, kɛ wɛ̃̀tɛní kɛ bo o cĩ́ɛ̃̀tɛ̀ ò do bɛ̀ bonɛ̀ kɛ dòmmɛ̀. Ò bo nɑ kɛ́di o cicɛ yo ntìì diitì. Ikuɔ́ nìùtì cĩ́ɛ̃̀tɛ̀ kou í tú wè bɑ́ɑ́ nɑ kɛ́ tì di. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Kòò mɔù di bɛ̀ m pɑ̃ dɛ̀ bɑ́ ò í yɛ̃́, kɛ̀ dɛ̀ boní kòò yĩ̀ɛ̃́tɛ́ wèe dɛ̀ yietí ikuɔ́ nìùtì kɛ́nɔ́ɔ́ nkɛ̀ dɛ̀ mmɑ̀nnɛ̀ ò yietí dɛ kó yɛwɛ́tiyɛ̀ yɛ̀nùmmù kó dìmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Ikuɔ́ nìùbɛ̀ bɑ́ɑ́ yóu kɛ̀ bɛ̀ɛ̀ í dò nkɛ́di bɛ̀ m pɑ̃ dɛ̀, kɛ̀ bɛ̀ɛ dɛ̀ di. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Kɛ̀ bɛ̀ dɛ̀ di, ikuɔ́ nìùbɛ̀ bɛ̀ toú mmɛyɛi mmɛ bɛ̀ɛ yietí kɛ́fɔ́ɔ́. Mí ndi Yiɛ̀ nKuyie mmíì dɛ̀ cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Kɛ̀ ti Yiɛ̀ nKuyie nní nsɔkɛ́ ku nɑ́ɑǹtì kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","Nɑ́kɛ́ Anɔɔ nɛ̀ o bí nɛ̀ Isidɑyɛɛribɛ bɛmɔu kɛ tú n yɛ̃ ndi miɛkɛ yoo opɔ̀ɔ̀ wèè di bonɛ̀, kɛ̀ wèè dɔ́ kɛ́ m pɑ̃ dipɑ̃nnì yoo ò dɔ́ kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́tuɔ nhò n dɔúnnɛ̀ dìì nùù kpɛ́í nyoo kòò mɛ mbɑɑ dɔ́ kɛ́ fɛ̀ nni nféútɛ́mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","Kòò dɔ́ n cɔutɛ́ dɛ kó dipɑ̃nnì dɛ̀ ntú dinɑɑdɑɑ̀ yoo dipedɑɑ̀ yoo dibɔdɑɑ̀ dɛ̀ɛ̀ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Kɛ̀ di n fèútɛ́ fɛɔ̃̀fɛ̀ fɛ̀ɛ̀ mɔ̀kɛ kuyɛ̀nkù m bɑ́ɑ́ cɔutɛ́ dɛ kó dipɑ̃nnì. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Kɛ̀ fɛɔ̃̀fɛ̀ mɛtɑummɛ̀ kɔfɛ nfɛ òmɔù dɔ́mɛ̀ kɛ n féútɛ́ yoo ò dɔ́ kɛ́dɛitɛ ò n dɔúnnɛ̀ dìì nùù yoo ò bɑɑ dɔ́ kɛ́ m pɑ̃ dipɑ̃nnì ndi, dɛ kó fɛɔ̃̀fɛ̀ dò nkɛ́ntú di n feu fɛ̀ nfɛ, kɛ́nkpɑ kuyɛ̀nkù kɛ̀ n nɛ́ fɛ̀ cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Mí ndi Yiɛ̀ nKuyie ndi bɑ́ n féútɛ́ fɛɔ̃̀fɛ̀ fɛ̀ɛ̀ yɛ̃ĩ yoo fɛ̀ ɑ̃ dikpɛ̃nnì yoo bɛ̀ fɛ̀ fɛ̃̀tɛ yoo fɛ̀ ɑ̃ mɛkpɑ̃̀ɑ̃̀ nyoo fɛ̀ ɑ̃ tifíɛ̀tì yoo fɛ̀ ɑ̃ yɛmuɔ. Di bɑ́ɑ́ dɑɑ́ ndɛ kó fɛɔ̃̀fɛ̀ botí kó kumɑɑ ndiwũɔ̃tɔ̀nnì kɛ́ntú di kù nni mpɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Di bo nɑ kɛ́ n féútɛ́ diwɛ̀ì kó dipɑ̃nnì: Fɛnɑ̀ɑ̀fɛ̀ yoo fɛpìèfɛ̀ dɛ̀ɛ̀ mɔ̀kɛ kuyɛ̀nkù yoo dɛ̀ pusi yoo dɛ tɑ̀ɑ̀kɛ okù kɛ tontɛ́. Di mɛ mbɑ́ɑ́ dɛ̀ nni nféútɛ́ di n dɔúnnɛ̀ dìì nùù kpɛ́í, nkɛ̀ di dɛ̀ nni nfèútɛ́ m bɑ́ɑ́ dɛ̀ cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Di bɑ́ n féútɛ́ fɛɔ̃̀fɛ̀ fɛ̀ɛ̀ kó yɛtɑkuò ntɑ yoo bɛ̀ fɛ̀ fɔ̃̀ntɛ yoo bɛ̀ yɛ̀ kèétɛ́. Di kó dihɛì miɛkɛ òmɔù bɑ́ɑ́ dɛ̀ dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Kòo pɔ̀ɔ̀ mɔù mɛ ntɔní dɛ kó fɛɔ̃̀fɛ̀ botí dí bɑ́ɑ́ fɛ̀ cɔutɛ́ kɛ́ fɛ̀ nni nféútɛ́, mí nKuyie mmíì di te, kɛ̀ bɛ̀ fɛ̀ fɔ̃̀ntɛ dɛ̀ nɑɑ́ nkuyɛ̀nkù nku, m bɑ́ɑ́ fɛ̀ cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Kɛ̀ ti Yiɛ̀ nKuyie nní nsɔkɛ́ ku nɑ́ɑǹtì kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","Kɛ̀ fɛnɑ̀ɑ̀fɛ̀ yoo fɛpìèfɛ̀ yoo tɛbuɔtɛ̀ kɛ̀ dɛ̀ pɛitɛ́ dɛbirɛ dɛdɑɑrɛ̀, dɛ̀ mbo dɛ yɔ̃ borɛ̀ kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀, diyiè niínnì yiè kɛ̀ di dɛ̀ nni nféútɛ́, m bo cɔutɛ́ dɛ kó dipɑ̃nnì. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Di bɑ́ɑ́ kuɔ dɛnɑɑbirɛ yoo dɛpebirɛ yoo dɛbɔbirɛ nɛ̀ dɛ yɔ̃ diyiè dìmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kɛ̀ di dɔ́ kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́ n sɑ̃ntɛ dí fɛ̀ nni nféútɛ́ dɛ̀ bo yiennɛ̀mɛ̀ kɛ̀ n fɛ̀ cɔutɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Kɛ̀ di fɛ̀ nni nfèútɛ́ dí fɛ̀ cɑ̀ɑ́kɛ́ dɛ yiè, di bɑ́ɑ́ súɔ́ nkɛ̀ dɛ̀ɛ wentɛ́. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Dí mpĩ n tɑnnɔ̀ nkɛ́ndɔɔri yɛ̀ yɛ̃ mmù míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Di bɑ́ɑ́ cɑkɛ n yètisɑ̀ɑ̀rì díndi Isidɑyɛɛribɛ n dɔ́ dí nyɛ̃́mu n dòmmɛ̀ pɑ́íí mí ndi Yiɛ̀ nKuyie mmíì di cɑ̃̀ńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Míì di dènnɛní Esibiti kɛ̀ di bo ntú n kɔbɛ. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ bɛ̀ yo mbɑɑ̀ nyɛ̀ɛ̀ bɑɑ n kpɛ́í. Dɛ kó yɛbɑɑ mmiɛkɛ di níí tíí nkɛ́ n sɑ̃ntɛ. N yóó di bɛnkɛmu dɛ kó yɛmɔ̀rɛ̀ di níí yoo tíí nyɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Di níí pĩ́ ndi tɔ̃mmú yɛwe yɛ̀kuɔ̀ miɛkɛ, diyiénnì tu tɛom̀pùtɛ̀ ntɛ. Di níí tíí ndɛ yiè kɛ́ n sɑ̃ntɛ, dɛ yiè di bɑ́ɑ́ pĩ́ mmutɔ̃mmú bɑ́ kɛ̀ di bo kɛ̀ɛ̀ bíɛ́kɛ̀ dɛ kó diyiè tu n kpɛri ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Ntɛ yɛbɑɑ nkó yɛmɔ̀rɛ̀ tɛyɛ̀ di níí yóó tíí nyɛ̀ɛ̀ miɛkɛ kɛ́ n sɑ̃ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Dibenni tɑ̃̀nkù ketiwè kó diyiè tɛpíítɛ̀ nɛ̀ dinɑɑnnì kó dihuri mɔ̀nnì yó ntú diyentɛ́bɑnni ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Dɛ kóo tɑ̃̀nkù omɑ́ɑ̀ kó diyiè tɛpíítɛ̀ nɛ̀ dinummurì yó ntú pɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti bɛ kó dibɑnni ndi. Dí nyo mpɛ̃́ɛ̃̀bɛ̀ bɛ̀ɛ̀ í kɔɔrɛnɛ̀ mutie mùù muuti kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Diyiè ketirì yiè di tíí nkɛ́ n sɑ̃ntɛ, dɛ yiè di bɑ́ɑ́ pĩ́ mmutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Yɛwe yɛ̀yiekɛ̀ miɛkɛ kɛ́ nni mpɑ̃ɑ̃ nyɛpɑ̃rɛ̀ kɛ tuɔ̀. Diyiè yiénnì kɛ́tíí nkɛ́ n sɑ̃ntɛ, di bɑ́ɑ́ pĩ́ mmutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkɛ̀ di tɑ dìì mɔ̀nnì dihɛì n di duɔ́ ndì kɛ kùútí, kɛ dɛ̀i tidiketitì, di boú dibou kɛ́duɔ́ nyikuɔ́ nìùtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kòò dɛ̀ nni mbɛnkɛ, kɛ̀ dɛ̀ɛ yie nkɛ̀ n dì cɔutɛ́. Tɛom̀pùtɛ̀ yiè kó diwentɛ́tɛrì ndi ikuɔ́ nìùtì yóó dɛ̀ nni mbɛnkɛmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","kɛ́ n féútɛ́ dipedɑbii dìì mɔ̀kɛ dibenni dimɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù kɛ́tuɔ, ");
INSERT INTO tbzsim_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","kɛ́wɑɑ́ mmuyuo ncìdóòbɛ̀ bɛ̀kuɔ̀ kɛ́ mù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀, nkɛ́wɑɑ́ mmɛnɑɑ̀ mbɛ̀ tumɛ̀ difɛ̃́ɛ̃̀ dítìrì dikéè kɛ́cóú ndɛĩ́nkɛ̀ kɛ́tuɔ. N dɔkɛ dɔ́ dìì pɑ̃nnì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Di bɑ́ɑ́ di di pɑɑ nkó tidiitì, di bɑ́ɑ́ ti dɔ̀ɔ̀nɛ̀ pɛ̃́ɛ̃̀, di mɛ mbɑ́ɑ́ tì pũ̀ńnɛ́ kɛ́cɑ́ɑ́kɛ́, yoo dí ntì cɑ̀ɑ́ ntibɛ́ntì kɛ í ketɛ́ kɛ dɛ̀ boú dibou kɛ m pɑ̃. Dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀ nɛ̀ di yɑɑ̀bío bɑ́ kɛ̀ di bo kùù píkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Kɛ̀ di níí m pɑ̃ tidipɑ̀ntì dìì yiè, di bɑ́ɑ́ kɑɑ ndɛ kó diyiè kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ di ketɛ́ kɛ́kɑɑ nkɛ dɔ̀ semɛ́nnìbɛ̀ bɛ̀yiekɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Semɛ́nnì oyiénwè wenwe kó tɛom̀pùtɛ̀ yiè, dɛ̀ yóó mbo yɛwe sipísìnùmmù ndi, kɛ̀ di m pɑ̃ tidiitì. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Dɛ yiè bɑ́ wè wèè wɑɑ́ ntidipɑ̀ntì kó muyuo nsɑ̀ɑ̀mù cìdóòbɛ̀ bɛ̀tɑ̃ɑ̃ti kɛ́dɔɔ̀nɛ̀ pɛ̃́ɛ̃̀bɛ̀ bɛ̀dɛ́bɛ̀ kɛ́kɔɔrɛnɛ̀ mutie mùù muuti kɛ̀ di tɔní dɛ kó dipɑ̃nnì kɛ́ m bɛnkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Pɛ̃́ɛ̃̀ kó difɔ̃nkúò kɛ̀ dí n féútɛ́ yɛpedɑbɛ yɛ̀yiekɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀, kɛ kpɑ kuyɛ̀nkù nɛ̀ dinɑɑdɑpɑ̀nnì dìmɑ́ɑ̀ nɛ̀ yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀ kɛ́ yɛ̀ wɛ̃nnɛ́nɛ̀ tidiitì di m pɑ̃ tì, kɛ́ dɛ̀ còú mmɛnɑɑ̀ mbɛ̀ tu mɛ̀ difɛ̃́ɛ̃̀ kɛ́tuɔ, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Kɛ̀ di dèè dí wɑɑ́ ndibɔdɑɑ̀ mɛyɛi nhũtímù kpɛ́í nnɛ̀ yɛpedɑbɛ yɛ̀dɛ́ɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ́ n féútɛ́ mɛtɑummɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Kɛ̀ ikuɔ́ nìùtìi dɛ̀ nni mbɛnkɛ kɛ́ dɛ̀ nni nféútɛ́ mɛtɑummɛ̀ tou borɛ̀, kɛ́wɛ̃nnɛ́nɛ̀ tidipɑ̀ntì kóo pɛ̃́ɛ̃̀ nɛ̀ yɛpedɑbɛ yɛdɛ́. Dɛ̀ tu n kpɛrɛ ndɛ bɛ̀ m pɑ̃ dɛ̀ ikuɔ́ nìùbɛ̀ yóo nte dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Dɛ kó diyiè kɛ́tíí nkɛ́ n sɑ̃ntɛ, dí bɑ́ɑ́ pĩ́ mmutɔ̃mmú dɛ yiè. Dɛ̀ yó ntú ikuɔ́ nyi di kpɛ́í nsɑ̃́ɑ̃̀ nɛ̀ di yɑɑ̀bío bɑ́ kɛ̀ di bo kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Kɛ̀ di dɛi tidiitì di bɑ́ɑ́ dɛitɛ kɛ́tɑunnɛ̀ tìì bo di pɑɑ mmɑ̀nku, di mɛ mbɑ́ɑ́ kóntɛ́ kɛ́dɛ́rí, dí tì yóu bɛcĩ̀rìbɛ̀ nɛ̀ bɛpɔ̀ɔ̀bɛ̀ kpɛ́í. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú: Dibenni tɑ̃̀nkù yiénwè kó diyiè ketirì níí yó ntú tɛom̀pùtɛ̀ ntɛ, di níí tíí nkɛ́ n sɑ̃ntɛ nɛ̀ tipíɛ́tì nɛ̀ siheú. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Dɛ yiè di bɑ́ɑ́ pĩ́ mmutɔ̃mmú, dí n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","Otɑ̃̀nkù yiénwè yiè píínnì yó ntú mɛyɛi nhũtímù yiè ndi, di níí tíí nkɛ́ n sɑ̃ntɛ, kɛ́boú dinùù kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù dɛ yiè mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó diyiè ndi, bɛ̀ yóó di dɔɔ̀ dì mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ kɛ̀ n di cĩ́ɛ̃́ mmí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Kɛ̀ wèè í boú dinùù dɛ yiè bɛ̀ɛ ò dènnɛ o kɔbɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Kɛ̀ wèè pĩ mmutɔ̃mmú dɛ yiè m bo ò dɛ̀itɛ o kɔbɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Di bɑ́ɑ́ pĩ́ mmutɔ̃mmú dɛ yiè dɛ̀ yóó ntú ikuɔ́ nyi di kpɛ́í nsɑ̃́ɑ̃̀ bɑ́ kɛ̀ di bo kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Dɛ kó diyiè yó ntú n kpɛri ndi, otɑ̃̀nkù yiè wɛínnì kó kuyuoku nku di yóó boúmɛ̀ dinùù kɛ́ntɔ kɛ́tuɔkɛnɛ̀ diyiè tɛrì kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Kɛ̀ ti Yiɛ̀ nKuyie nní nsɔkɛ́ ku nɑ́ɑǹtì kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nhotɑ̃̀nkù yiénwè yiè tɛpíítɛ̀ nɛ̀ dinummurì di níí ɑ̃nnɛ́ titouti kó dibɑnni kɛ́ n sɑ̃ntɛ, kɛ̀ dì mbo kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Diyiè ketirì yiè di tíí nkɛ́ n sɑ̃ntɛ, dɛ yiè òmɔù bɑ́ɑ́ pĩ́ mmutɔ̃ncɛ̃́ɛ̃́mù. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Yɛwe yɛ̀yiekɛ̀ yɛnyɛ miɛkɛ, bɑ́ dì di níí n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́tuɔ. Diyiè niínnì yiè kɛ́tíí nkɛ́ n sɑ̃ntɛ kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́tuɔ. Di bɑ́ɑ́ pĩ́ mmutɔ̃ncɛ̃́ɛ̃́mù dibɑnni denni dìì yiè. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: M mɛ ntɑ̃ɑ̃tɛ́ yɛ̀ɛ̀ we di níí yóó yɛ ntíí kɛ́ n sɑ̃ntɛ, kɛ́ n fíé iwũɔ̃ kɛ́tuɔ kɛ́ m pɑ̃ tidiitì kó yɛpɑ̃rɛ̀, kɛ́ n fíénɛ̀ iwũɔ̃ mɛtɑummɛ̀ kpɛyi, kɛ́cóú mmɛnɑɑ̀ nkɛ́tuɔ kɛ́ntũ mbɑ́ dìì yiè di kuɔ́ dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Kɛ nɛ́ yíɛ́nɛ̀ iwũɔ̃ di n feu ì siom̀pùsi kó yɛwe nɛ̀ yɛpɑ̃rɛ̀ di m pɑ̃ɑ̃ nyɛ̀ nɛ̀ iwũɔ̃ di n feu ì, di n dɔunkonɛ̀ yɛ̀ɛ̀ nɔ̀ kpɛ́í nnɛ̀ yɛpɑ̃rɛ̀ diwɛ̀ì kpɛyɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Dɛ kó difɔ̃nkúò otɑ̃̀nkù yiénwè kó diyiè tɛpíítɛ̀ nɛ̀ dinummurì kɛ sɔ̃́ ndi dɛ̀itɛ di diitì kɛ dèè, dí ɑ̃nnɛ́ titouti kó dibɑnni kɛ́ nni nsɑ̃ntí kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. Dibɑnni yiè ketirì nɛ̀ diniínnì yó ntú tɛom̀pùtɛ̀ ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Diyiè ketirì, dí wɑɑ́ nyɛtebɛ sɑ̀ɑ̀yɛ̀ nɛ̀ tipuonti nɛ̀ kukó nkó titieti, kɛ́nyɑ̃nku mɛtɑummɛ̀ tou di Yiɛ̀ nKuyie nyììkɛ̀ kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Dibenni miɛkɛ di níí ɑ̃nnɛ́ dibɑnni kɛ́ nni nsɑ̃ntí kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. Dɛ̀ yó ntú ikuɔ́ nyi di kpɛ́í nsɑ̃́ɑ̃̀ nɛ̀ di yɑɑ̀bío. Dibenni tɑ̃̀nkù yiénwè miɛkɛ nkɛ di níí yóó ɑ̃nnɛ́mɛ̀ dɛ kó dibɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Isidɑyɛɛribɛ di níí yó mbo titouti miɛkɛ nkɛ kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Kɛ̀ dɛ̀ɛ yie kɛ̀ di yɑɑ̀bíi bɑntɛ́ kɛ do ndi dò ɑ̃ titouti miɛkɛ nkɛ, n di dènnɛní dìì mɔ̀nnì Esibiti. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Kɛ̀ Mɔyiisii nɑ́kɛ́ Isidɑyɛɛribɛ yɛmɔ̀rɛ̀ bɛ̀ yó mbɑɑ̀ nyɛ̀ ti Yiɛ̀ nKuyie nkó yɛbɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ̀ bɛ̀ dɑ duɔ́ nhodìfíè kó mɛkɔ̀sɑ̀ɑ̀mɛ̀ di bo ntuɔ̀nnɛ̀mɛ̀ tɛfitíkɛ̀kɛ̀tɛ̀ dɛyuo ndɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Kɛ̀ Anɔɔ tɛ̀ ĩ̀ńnɛ́ mɛtɑummɛ̀ tou miɛkɛ kuyɑ̀ɑ̀kù kùù pì mɛtɑummɛ̀ tɔu ĩ́ĩ́kú dɛ̀ ku ììkɛ̀, kɛ̀ tɛ̀ níí nyié nkɛ cɔ́ú mí ndi Yiɛ̀ nKuyie n yììkɛ̀ kɛ́wentɛ́nɛ̀. Dɛ̀ yóó ntú ikuɔ́ nyi di kpɛ́í nnɛ̀ di yɑɑ̀bío sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Anɔɔ yóó dɛ nyĩ́nnɛ́ tɛfitíkɛ̀kɛ̀tɛ̀ mɛsɔɔ nsɑ̀ɑ̀mɛ̀ kpɛtɛ kɛ́cɔ̃nnɛ́ tɛ búkúsí kɛ̀ dɛ̀ níí ncɔ́ú nkɛyènkɛ̀ kɛmɔu n yììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","A wɑɑ́ mmuyuo nsɑ̀ɑ̀mù kɛ́dɔɔ̀nɛ̀ pɛ̃́ɛ̃̀bɛ̀ tɛpíítɛ̀ nɛ̀ bɛ̀dɛ́bɛ̀ bɑ́ wèè pɛ̃́ɛ̃̀ kòo yuo ncɛ̃́ɛ̃́kù mbo cìdóòbɛ̀ bɛ̀kuɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Kɑ̀ɑ bɛ̀ dɑɑ́ mmɛsɔɔ nsɑ̀ɑ̀mɛ̀ kóo tɑ́bùrì ĩ́nkɛ̀ icuɔ́ ìdɛ́ì bɛ̀kuɔ̀ bɛ̀kuɔ̀ mí ndi Yiɛ̀ nKuyie n yììkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","kɛ́cóú mbɑ́ kùù cuɔ́ ĩ́nkɛ̀ tihúúntì sɑ̀ɑ̀tì bɛ̀ yóó tuɔ ntì, kɛ̀ dɛ̀ɛ bɛnkɛ pɛ̃́ɛ̃̀ omɔu túmɛ̀ mí ndi Yiɛ̀ nKuyie n kou. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Bɑ́ tɛ̀ɛ̀ om̀pùtɛ̀ ntɛ bɛ̀ níí yóó dɑɑ́mmɛ̀ dɛ kóo pɛ̃́ɛ̃̀ mɛsɔɔ nsɑ̀ɑ̀mɛ̀ kóo tɑ́bùrì ĩ́nkɛ̀ mí ndi Yiɛ̀ nKuyie n yììkɛ̀. Díndi Isidɑyɛɛribɛ di dò nkɛ́ mmɛ ndɔɔri sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Anɔɔ nɛ̀ o bí bɛɛ̀ yó nte dɛ kóo pɛ̃́ɛ̃̀, bɛ̀ níí nkɑri mɛtɑummɛ̀ tou kó kudɑ̀nkù kɛ́ bɛ̀ cɑ̀ɑ́kɛ́ kɛ yɛ̃́ bɛ̀ bɛ̀ nni mpɑ̃mɛ̀mu kɛ̀ bɛɛ̀ cɑ̃̀ɑ̃́ nkɛ̀ bɛɛ̀ dò nkɛ́ bɛ̀ di. Dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Dɑnni kóo nitipòkù mɔù weè do bo Isidɑyɛɛribɛ cuokɛ̀ kòo yètìrì tu Dibidi, kòo pɛitɛ́ osɑpɑ̀ɑ̀ nkòo yètìrì ntu Sedomii, kòo pɛitɛ́nɛ̀ Esibiti kou mɔù odɑpɑ̀ɑ̀. Diyiè mɑrì kɛ̀ dɛ̀ kóo dɑpɑ̀ɑ̀ nnɛ̀ Isidɑyɛɛri kou, kɛ̀ bɛ̀ nkpɑ nkɛ̀ dɛ kóo dɑpɑ̀ɑ̀ nsɑ̃́ɑ̃́ nKuyie, kɛ̀ bɛ̀ɛ ò kɔ̀tɛnɛ̀ Mɔyiisi borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Kɛ̀ bɛ̀ɛ ò kɑ̀nnɛ kɛ́ nhò bɑ̀ɑ kɛ kémmúnɛ̀ ti Yiɛ̀ nKuyie mbo bɛ̀ nɑ̀kɛ́mɛ̀ bɛ̀ dò nkóò dɔ̀ɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","Dɛ kóo dɑpɑ̀ɑ̀ wèè n sɑ̃́ɑ̃́ mmí nKuyie, ɑ́ ò dènnɛ Isidɑyɛɛribɛ kɑrì, bɛ̀ɛ̀ kó dimɑ̀ɑ̀ kèè ò n sɑ̃̀ɑ̃́mmɛ̀ mí nKuyie nkɛ̀ bɛ̀ɛ nɔ́ɔ́ mbɛ nɔu o yuu ĩ́nkɛ̀ kɛ̀ Isidɑyɛɛribɛ bɛmɔuu ò bùɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Kɑ̀ɑ nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkɛ̀ wèè n sɑ̃̀ɑ̃́ mmí nKuyie nkùù ò te weè tɔ dɛ kó mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Kɛ̀ wèè n sɑ̃̀ɑ̃́ mbɛ̀ dò nkóò bùɔ́tí yɛtɑ̃́rɛ̀ nyɛ kɛ́kuɔ, kòò tu opɔ̀ɔ̀ yoo dihɛì yiɛ̀ nkɛ nɛ́ n sɑ̃̀ɑ̃́ mbɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Kɛ̀ wèè potɛ́ otɔù kɛ kùɔ, bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Kɛ̀ wèè kùɔ otɔù kó fɛɔ̃̀fɛ̀ wèe ò yietí fɛfòùfɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Wèè kɔ̀ùtɛ otɔù bɛ̀ múnkɛɛ ò kɔ̀ùtɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Wèè kèétɛ́ otɔù kɔ̃́ũ̀ bɛ̀ɛ kèétɛ́ o kpɛri. Kɛ̀ wèè kpɛ́ɛ́tɛ́ otɔù nɔ̀nfɛ̀ bɛ̀ɛ kpɛ́ɛ́tɛ́ o kɔfɛ. Kɛ̀ wèè feutɛ́ otɔù nìnnì bɛ̀ɛ feutɛ́ o kpɛri. Kɛ̀ wèè ɑ̃nnɛ́ otɔù kuyɛ̀nkù bɛ̀ɛ kù nhò ɑ̃nnɛ́ múnkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Kɛ̀ wèè potɛ́ fɛɔ̃̀fɛ̀ kɛ kùɔ wèe yietí kɛ́fɔ́ɔ́, kɛ̀ wèè potɛ́ onìtì kɛ kùɔ bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Di bekùnɛ̀ mɛ̀ɛ̀ botí dihɛì yɛmbɛ̀ di yó mmɛ mbekùnɛ̀ bɛpɔ̀ɔ̀bɛ̀. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mɔyiisi tì nɑ̀kɛ́ dìì mɔ̀nnì Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ dennɛ dɛ kóo dɑpɑ̀ɑ̀ nwèè sɑ̃̀ɑ̃́ nKuyie mbɛ kɑrì kóò bùɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ. Mɛm̀mɛ bɛ̀ dɔ̀ɔ̀mɛ̀ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ tì Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi Sinɑii tɑ̃rì ĩ́nkɛ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkɛ̀ di tɑ dìì mɔ̀nnì dihɛì n di duɔ́ ndì, dí soó mmukútímù, kɛ̀ kɛtenkɛ̀ɛ om̀pɛ̀ kɛ̀ dɛ̀ ntú n kó disɑ̃nni. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Dí nkuuti kɛ dɔ̀ yɛbie nyɛ̀kuɔ̀, kɛ́mbuɔtì di diitì, kɛ́píenko fínyĩ̀ kó dɛtie nkɛ tɔ̃ũ̀ dɛ bɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Dibenni yiénnì miɛkɛ kɛtenkɛ̀ kó diom̀pùbenni ndi, di bɑ́ɑ́ buɔtí, di mɛ mbɑ́ɑ́ píe nfínyĩ̀ kó dɛtie. Dɛ̀ yó ntú n kó disɑ̃nni ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Kɛ̀ tididenti yɛ̀ di bɑ́ɑ́ tì dɛ̀itɛ, bɑ́ nɛ̀ di í mɛ mpíemmɛ̀ di tie nkɛ̀ dɛ̀ pɛitɛ́, di bɑ́ɑ́ tɔ̃ũ dɛ bɛ, kɛtenkɛ̀ om̀pùbenni ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Dí nyo ntididenti díndi nɛ̀ di kó tidɑɑtì nɛ̀ di kó bɛtɔ̃mbɛ̀ nɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ di bonɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Nɛ̀ dɛ kó tidiitì miɛkɛ nkɛ di wũɔ̃ yóó pɛ́tɛ́mɛ̀ kɛ́di nɛ̀ dihɛì kó tiwɑnwɑntì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","Di níí kɑɑ̀ nyɛbie nyɛ̀yiekɛ̀ yɛ̀yiekɛ̀ kucɛ mɛ̀yiekɛ̀. Dɛ kó yɛbie nyó mbo yɛbie nsipísìnɑ̀ɑ̀ nɛ̀ yɛ̀wɛi ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Dibenni sipísìnɑ̀ɑ̀ nɛ̀ diwɛínnì kóo tɑ̃̀nkù yiénwè kó diyiè píínnì, diyiè diɛrì ndi, mɛyɛi nhũtímù kpɛ́í. Dí duɔ́ nkɛ̀ bɛ̀ɛ eé ditɑ̃tɛheù dihɛì dimɔu miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","kɛ́pĩɛ̃kɛ́, dibenni sipísìnùmmù kpɛri yó ntúmɛ̀ tidɑɑtì fĩ́ĩmmù kpɛri ndi, dibɑnni diɛrì kó dibenni ndi, òmɔù tɛ̃́nkɛ bɑ́ ntú kudɑɑkù n kó kɛtenkɛ̀ kɛmɔu miɛkɛ. Dɛ kó dibenni bɑ́ wè ò bo nɑ kɛ́wɛ̃tɛ kɛ́tiekɛ o tenkɛ̀, bɑ́ wè kòo kò nho cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Dibenni sipísìnùmmù kpɛri yó ntú tidɑɑtì fĩ́ĩmmù kpɛri ndi, dibɑnni diɛrì kó dibenni ndi. Dɛ benni di bɑ́ɑ́ buɔtí di mɛ mbɑ́ɑ́ dɛitɛ tididenti yoo dí tɔ̃ũ dɛtie mbɛ̀ tu dɛ̀ fínyĩ̀ dɛ bɛ, di í píe ndɛ kó yɛbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Dɛ kó dibenni tú tidɑɑtì fĩ́ĩmmù kpɛri ndi, dɛ kó dibenni miɛkɛ di yó nyo ntididenti nti. Diwɛ̀ì kó dibenni ndi, dí ndì wùó ndìì cɑ̃̀ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Dɛ kó dibenni miɛkɛ bɑ́ wè ò bo nɑ kɛ́wɛ̃tɛ kɛ́tiekɛ o tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Kòò mɔù fiitinɛ̀ o kou kɛtenkɛ̀ yoo ò kɛ̀ nhò donnɛ̀, ò bɑ́ɑ́ ò ciitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Wèe wéntɛ́ dɛ̀ kpɑɑ́ yɛbie nyɛ̀dɛ̀ kɛ̀ n kó dibennii tuɔkɛní, dɛ miɛkɛ nkɛ ò yóó nɑmɛ̀ kóò kèétɛ́ idíítí. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Kɛ̀ yɛbie nsũ idíítí nsũ kɛ̀ yɛ̀ mɛ nkɛ̃ńnì idíítí nkɛ̃ńnì, di yó nwéí yɛbie mmɑmɛ̀ mmɛ kɛ kékíí idíítí. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Di miɛkɛ òmɔù bɑ́ɑ́ ciitɛ́ otɔù. Di nni ndé, mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","Dí mpĩ́ n tié nnɛ̀ n kuɔ́ kɛ́ndɔɔri dɛ̀ yɛ̃mmɛ̀, mɛmmɛ di bo mbomɛ̀ di tenkɛ̀ kɛ bɑ́ nyĩɛ̃̀kù dɛ̀mɑrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Kɛ̀ di pɑɑ nní mpɛí, kɛ̀ di yo nkɛ sɑ̀nnɛ̀ kɛ́mbo kɛ í yĩɛ̃̀kù. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Kɛ̀ dɛ̀ yɛ̀mmɛ̀ di bo bekɛ dimɑ́ɑ̀ kɛ dɔ̀: Ti nɛ́ yó nyo mbɑ kɛ̀ ti í kùútí dibenni yiénnì kɛ dɛ̀itɛ tidiitì? ");
INSERT INTO tbzsim_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","N yóó duɔ́ nkɛ̀ n kó mɛsɑ̀ɑ̀ mmɛɛ̀ níí mbo di ĩ́nkɛ̀, dibenni kuɔ́nnì miɛkɛ kɛ̀ di pɑɑ nníí pɛitɛ́, kɛ̀ dɛ̀ nsɑ̀nnɛ̀ di bo nyommɛ̀ kɛ dɔ̀ yɛbie nyɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Kɛ̀ di buɔtí dibenni niínnì miɛkɛ di bo nɑ kɛ́nyo ntidikótì kɛ́tuɔkɛnɛ̀ dibenni wɛínnì di bo dɛitɛmɛ̀ tipɑ̀ntì. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Òmɔù bɑ́ɑ́ fítɛ́ kɛtenkɛ̀ sɑ̃́ɑ̃̀ kɛ̀ dɛ̀ɛ deè kɛ yɛ̃́ míì temɛ̀ kɛtenkɛ̀ kɛ̀ di tú bɛpɔ̀ɔ̀bɛ̀ kɛ bo kɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Dihɛì n yóó di duɔ́ ndì miɛkɛ, dí dɔú nyikuɔ́ kòò mɔù fìtɛ́ o tenkɛ̀ wèe nɑ kɛ́wɛ̃tɛ kɛ́ kɛ̀ dontɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Kòò mɔù tebitɛ tɑ ticĩ̀tì kɛ fìtɛ́ kɛtenkɛ̀, o cĩ́ɛ̃̀tɛ̀ kou wèè ò tɔ̀kɛ́nɛ̀ weè dò nkɛ́wɛ̃tɛ kɛ́ kɛ̀ dontɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Kòò mɔù mɛ nyí mɔkɛ wèè ò tɔ̀kɛ́nɛ̀ kɛ bo nɑ kɛ́ kɛ̀ dontɛ́, kòò wɛ̃̀tɛ kɛ pɛ̀tɛ́ dìì yiè idíítí ò bo nɑ kɛ́wɛ̃tɛ kɛ́dontɛ́ o tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","Bɛ̀ɛ kɑɑ̀ nyɛbie nyɛ̀ɛ̀ pɛ̃ɛ̃tɛ́ kɛ́bɑtɛ yɛ̀ɛ̀ kpɑɑ́, kɛ̀ tidɑɑtì fĩ́ĩmmù benni nɛ́ nɑ kɛ́tuɔkɛní kòo ò tɛ̃̀ńnɛ́, kɛ́wɛ̃tɛ kɛ́tiekɛ o tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Kòò mɛ nyí pɛ̀tɛ́ ò bo yietí mù wèè kɛ̀ dontɛ́ wè nkpɑɑ́ kɛ kɛ̀ te, kɛ bɑɑnɛ̀ tidɑɑtì fĩ́ĩmmù benni kòò nɛ́ nɑ kɛ́wɛ̃tɛ kɛ́cɔutɛ́ o tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Kòò mɛ nfìtɛ́ tɛcĩ́ɛ̃̀tɛ̀ kɛ̀ tɛ̀ bo dihɛì iduotí fitɛ́ dì, dibenni dìmɑ́ɑ̀ kó mukṹṹ mmiɛkɛ nkɛ ò bo nɑmɛ̀ kɛ́wɛ̃tɛ kɛ́ tɛ̀ dontɛ́. Kòò dɔ́ kɛ́wɛ̃tɛ kɛ́ tɛ̀ dontɛ́ dɛ̀ bɑ́ɑ́ pɛ̃ɛ̃tɛ́ dibenni nɛ̀ ò tɛ̀ fìtɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Kɛ̀ dɛ̀ pɛ̃ɛ̃tɛ́ dibenni kòò í wɛ̃̀tɛ kɛ tɛ̀ dontɛ́, wèè tɛ̀ dontɛ́ weè yó ntɛ̀ te sɑ̃́ɑ̃̀ nɛ̀ o yɑɑ̀bío. Tɛ yiɛ̀ mbɑ́ɑ́ wɛ̃tɛ kɛ́ tɛ̀ cɔutɛ́ tidɑɑtì fĩ́ĩmmù bo tuɔkɛmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Kɛ̀ sicɛ̃́ĩ sìì bo yɛhɛkɛ̀ iduotí í fitɛ́ yɛ̀ si yó ndònnɛ̀ dɛpɑɑ ndòmmɛ̀ mmɛ, tɛ yiɛ̀ nníí bo nɑ kɛ́wɛ̃tɛ kɛ́ tɛ̀ dontɛ́ yoo wèe wɛ̃tɛ kɛ́ tɛ̀ cɔutɛ́ tidɑɑtì fĩ́ĩmmù bo tuɔkɛmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Defiibɛ biɛ yó mmɔkɛmu kucɛ kɛ níí nɑ kɛ́wɛ̃tɛ kɛ́dontɛ́ bɛ tenkɛ̀ yoo bɛ cɛ̃́ĩ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Bɑ́ kɛ̀ Defii botí kou weè dontɛ́nɛ̀ o tebitɛ tɛcĩ́ɛ̃̀tɛ̀, kɛ̀ tidɑɑtì fĩ́ĩmmù benni tùɔ̀kɛ wèe wɛ̃tɛ kɛ́ tɛ̀ duɔ́ ntɛ yiɛ̀, kɛ yɛ̃́ bɛ cɛ̃́ĩ siì tumɛ̀ bɛ kpɛrɛ bɛ̀ mɔ̀kɛ dɛ̀ Isidɑyɛɛribɛ tenkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Bɛ̀ bɑ́ɑ́ fítɛ́ bɛ pénnɛ̀ bɛ kó kɛtenkɛ̀ yó nni nkɛ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Kòò mɔù kou tɑ ticĩ̀tì miɛkɛ kɛ tɛ̃́nkɛ í mɔkɛ mùmɑmù, wè nhò tɔ, kòò mɛ ntú opɔ̀ɔ̀ nwe ò nhò tɔ, kɛ̀ dɛ̀ɛ yie nkòò mbo o borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Ò bɑ́ nwɑnti mucɔ̃́ntimu o ĩ́nkɛ̀, ò bɑ́ nwɑnti kɛ bo ò di. Ò ndé mí ndi Yiɛ̀ nKuyie nkɛ̀ o kou nhò bonɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Kòò mɛ nhò pèntɛ idíítí nyi ò bɑ́ nwɑnti kɛ́cɔ̃ntɛ, kɛ̀ tidiitì mɛ nni nti ò bɑ́ nwɑnti wèe ò tɛ̃̀ńnɛ́ kɛ́nɔ́ɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Mí ndi Yiɛ̀ nKuyie mmíì di te kɛ̀ di dènnɛní Esibiti kɛ bo di duɔ́ nKɑnnɑhɑ̃ɑ̃ tenkɛ̀, kɛ̀ di ntú n kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Kòò mɔù kou tɑ mɛsémmɛ̀ miɛkɛ kɛ tɛ̃́nkɛ í mɔkɛ mùmɑmù, kɛ fìtɛ́nɛ̀ omɑ́ɑ̀ otɔù kɛ bo mpĩ́ nho tɔ̃mmú, wèè ò dontɛ́ ò bɑ́ɑ́ ò pĩ̀ńnɛ́ mudɑɑtɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Wè nhò bonɛ̀ kɛ dònnɛ̀ o kóo tɔ̃ntì yoo wèè kɔ̀tɛní kɛ ò tɑɑ̀nɛ̀. Wè nhò pĩ̀ńnɛ̀ mutɔ̃mmú kɛ̀ tidɑɑtì fĩ́ĩmmù benni yɑ̀ɑ tuɔkɛnní. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Kɛ̀ tidɑɑtì fĩ́ĩmmù benni tùɔ̀kɛní, wèe kò nwenwe nɛ̀ o bí o kɔbɛ borɛ̀, kɛ́kɑri o yɛmbɛ̀ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Di tú n kó bɛtɔ̃mbɛ̀ mbɛ, kɛ̀ n di dènnɛní Esibiti, òmɔù bɑ́ɑ́ fítɛ́ omɑ́ɑ̀ bɛ̀ ɔ̃ɔ̃ fítɛ́mɛ̀ kudɑɑkù. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Di miɛkɛ òmɔù bɑ́ɑ́ dɔɔ̀nɛ̀ otɔù muwɛ̃rímú. Mí ndi Yiɛ̀ nKuyie mmíì di te, di nni ndé! ");
INSERT INTO tbzsim_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Di kó tidɑɑtì tinitidɑɑtì nɛ̀ tinitipòtì tì yóó yɛ̀nní yɛhɛkɛ̀ yɛ̀ɛ̀ di fitɛ́ yɛ̀nyɛ. Di yó mbɛ ndonnɛ̀ tidɑɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ kɔ̀tɛní kɛ di bonɛ̀, di bo nɑ kɛ níí dontɛ́ bɛ bí, yoo bɛ̀ɛ̀ do di bonɛ̀ nɛ̀ dimɔ̀nnì bɛ yɑɑ̀bí. Bɛ̀ bɛ̀ pɛitɛ́ di tenkɛ̀ nkɛ díì bɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Di bo kú kɛ́yóu dɛ̀ di bí iì dò nkɛ́ dɛ̀ tùótɛ́, kɛ̀ bɛmbɛ ntú di kó tidɑɑtì sɑ̃́ɑ̃̀. Kɛ̀ di tebìí Isidɑyɛɛribɛ tɔbɛ̀, òmɔù bɑ́ɑ́ dɔɔ̀nɛ̀ otɔù muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Kɛ̀ dɛ̀ mɛ ndò mbɛpɔ̀ɔ̀bɛ̀ yoo bɛ̀ɛ̀ kɔ̀tɛnɛ̀ kɛ di bonɛ̀ bɛ kóò mɔù mɔ̀kɛ idíítí, kɛ̀ di tebitɛ mɑtɛ̀ ò mɔ̀kɛnɛ̀ dibɑ̀nnì, koò fìtɛ́nɛ̀ tɛmɑ́ɑ̀ yoo bɑ́ kɛ̀ bɛpɔ̀ɔ̀bɛ̀ kó dɛyɑɑ̀birɛ mɑrɛ̀ ndɛ tɛ̀ fìtɛ́nɛ̀mɛ̀ tɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Di mɔkɛmu kucɛ kɛ bo nɑ kɛ́wɛ̃tɛ kɛ́dontɛ́ di tebitɛ, di kou mɔù bo nɑ kɛ́wɛ̃tɛ kɛ́dontɛ́ di tebitɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","O cicɛ kou yoo o cicɛ kou kó dɛbirɛ bo nɑ kɛ́wɛ̃tɛ kɛ́ tɛ̀ dontɛ́, yoo otɔù mɔù nɛ̀ wè bɛ̀ tu mɛyĩ̀ĩ̀ mmɛ̀mɑ́ɑ̀ kɔbɛ. Kɛ̀ dɛ̀ í dò mmɛmmɛ tɛ̀ wɛ̃̀tɛ kɛ pɛ̀tɛ́ tɛ kpɛrɛ tɛ̀ bo nɑ kɛ́wɛ̃tɛ kɛ́dontɛ́ tɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Kɛ̀ tɛ̀ yóó dontɛ́ tɛmɑ́ɑ̀ bɛ̀ɛ nɑ́kɛ́ nɛ̀ wèè do nkɛ́ tɛ̀ dontɛ́, kɛ̀ bɛ̀ɛ kɑɑ nyɛbie nwèè do tɛ̀ dontɛ́ ò tɛ̀ dontɛ́ kɛ̀ yɛ̀ɛ̀ bie sootɛ́ dɛ cuokɛ̀, kɛ̀ n kó dibenni nɛ́ nɑ kɛ́tuɔkɛní. Bɛ̀ yóó wéntɛ́ yɛbie nyɛ̀ɛ̀ sokɛ́ yɛ̀nyɛ dɛ cuokɛ̀ kɛ nɛ́ nɑ kɛ́kéétɛ́ idíítí bɑ́ dìì yiè kɛ̀ idíítí mmɑ̀nnɛ̀ bɛ̀ ɔ̃ɔ̃ yietí ì otɔ̃ntì diyiè dìmɑ́ɑ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Kɛ̀ dɛ kó yɛbie nkpɑɑ́ kɛ sũ ò yóó yietí kɛ̀ ì nsũmu kɛ̀ di tebitɛ nɑ kɛ́wɛ̃tɛ kɛ́dontɛ́ tɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Kɛ̀ yɛbie mmɛ nyí kpɑɑ́ sũ kɛ̀ tidɑɑtì fĩ́ĩmmù benni tùɔ̀kɛní tɛ̀ tó yietí kɛ̀ dɛ̀ mmɑ̀nnɛ̀ yɛbie mmɑ̀mɛ̀, kɛ̀ tɛ̀ɛ wɛ̃tɛ kɛ́dontɛ́ tɛmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Kɛ̀ bɛ̀ dontɛ́ òmɔù ò níí yó mbo wèè ò dontɛ́ o cĩ́ɛ̃̀tɛ̀ kɛ dò nho tɔ̃ntì nwe, di bɑ́ɑ́ yie nkɛ̀ bɛ̀ nhò dɔ̀ɔ̀rinɛ̀ muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Kòò mɛ nyí nɑ kɛ bo wɛ̃tɛ kɛ́dontɛ́ omɑ́ɑ̀ dɛ kó mɛborimɛ mɛdɛ́ miɛkɛ wè mbɑɑ tidɑɑtì fĩ́ĩmmù benni kɛ́yɛ̀ wenwe nɛ̀ o bí. ");
INSERT INTO tbzsim_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Díndi Isidɑyɛɛribɛ di tú n kó bɛtɔ̃mbɛ̀ mbɛ kɛ̀ n di dènnɛní Esibiti kó kɛtenkɛ̀. Mí ndi Yiɛ̀ nkuyie míì di dènnɛní Esibiti tenkɛ̀. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Di bɑ́ɑ́ dɔɔ̀ sitenkɑɑnìi kɛ́ sì fìíkú yoo di fííkú yɛsĩ̀mpókɛ̀, di bɑ́ɑ́ cíɛ́kɛ́ yɛtɑ̃́rɛ̀ kɛ́ yɛ̀ kèrí tifèntì kɛ́fííkú kɛ́nninku yɛ ììkɛ̀. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Dí mpĩ́ n di nɑ̀kɛ́ tì siom̀pùsi ĩ́nkɛ̀, kɛ́ndé n tɑummɛ̀ tou. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Isidɑyɛɛribɛ kɛ dɔ̀: Kɛ̀ di yie nkɛ pĩ́ n tié nnɛ̀ n tɑnnɔ̀ kɛ dɔɔri dɛ̀ yɛ̃mmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","m bo ndi duɔ̀ nfɛtɑɑfɛ̀ fɛ mɔ̀nnì, kɛ̀ di pɑɑ nní mpɛí mɛsɑ̀ɑ̀ nkɛ̀ di tebiiti mpɛí mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Kɛ̀ di níí mpuotì tidiitì kɛ̀ di tebiitii binɛ̀, kɛ̀ di ntɔ̃ũ di tebiiti kɛ́tuɔkɛnɛ̀ di bo buɔtímɛ̀ tidiitì, kɛ̀ di nyo kɛ sɑ̀nnɛ̀ kɛ́mbo bɑ́ dɛ̀mɑrɛ̀ í di kɔɔ́nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Kɛ̀ n di duɔ́ ndiwɛ̀ì dihɛì miɛkɛ, kɛ̀ di níí nduɔ́ kɛ í yĩɛ̃̀kù. Kɛ̀ n kɛi ndɛsĩ̀nnɛ̀, mudoò tɛ̃́nkɛ bɑ́ɑ́ ɑ̃nnɛ́ di kó kɛtenkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Kɛ̀ di mbɛtì di dootitɔbɛ̀ kɛ bɛ̀ kɔ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Di miɛkɛ bɛnìtìbɛ̀ bɛ̀nùmmù níí bo mbɛtì tɛkɔ̀ùtɛ̀ (100), kɛ̀ tɛkɔ̀ùtɛ̀ mbɛtì tɛkɔupípíítɛ̀ (10000) kɛ̀ di bɛ̀ kɔ̀ù. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Kɛ̀ nní mbo difɔ̃nkó kɛ́duɔ́ nkɛ̀ di piɛ́ kɛ̀ nní mpĩ́ n di dɔ̀ɔ̀nɛ̀ mɛ̀ɛ̀ tɑummɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Kɛ̀ di níí nyo ndi diitì kɛ̀ tipɑ̀ntìi bi, kɛ̀ di cṹũnní tikótì kɛ́ɑ̃nnɛ́ tipɑ̀ntì. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Kɛ̀ n cĩ́ɛ̃̀tɛ̀ mbo di cuokɛ̀ sɑ̃́ɑ̃̀, m bɑ́ɑ́ di pɛ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","M bo mbo di cuokɛ̀, kɛ di te kɛ̀ di tú n kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Mí ndi Yiɛ̀ nKuyie mmíì di te, kɛ di dènnɛní Esibiti. Kɛ̀ dɛ̀ bo yie nkɛ̀ di tɛ̃́nkɛ bɑ́ ntú tidɑɑtì, kɛ toutɛ́ di tuɔ Esibiti kɔbɛ do di toú nyɛ̀, kɛ dí nɑ kɛ ɔ̃ nkérí kɛ yíéo. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Kɛ̀ ti Yiɛ̀ nKuyie nní nsɔkɛ́ ku nɑ́ɑǹtì kɛ́bɛ́i nkɛ dɔ̀: Kɛ̀ di mɛ nyetɛ n kpɛti kɛ í tũ̀nnɛ n tɑnnɔ̀ yɛmɔu, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","kɛ̀ di bùtínnɛ́ n kuɔ́ kɛ pɛ̃̀ n tié, kɛ̀ di tɔ̃̀tɛ n di dɔ̀ɔ̀nɛ̀ mɛ̀ɛ̀ tɑummɛ̀, kɛ yóu kɛ tɛ̃́nkɛ í dɔɔri n tɑnnɔ̀ yɛmɔu yɛ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","Ntɛ n yóó di dɔɔ̀mɛ̀: M bo duɔ́ nkɛ̀ mɛyɛi ndiɛmɛ̀ di do kɛ́ di kũɔ̃ nkɛ̀ kukɔ̃ntonnɔɔ diɛkù di pĩ́ nkɛ̀ di nuɔ ntɑ, kɛ̀ kùu tɑ kɛ́ncɑ́ɑ́ ndi kɔ̃̀ntì. Kɛ̀ di níí buɔtí tidiitì kɛ̀ tìi bi kɛ̀ di dootitɔbɛ̀ɛ kɔtɛní kɛ́ tì dɛ̀itɛ bɑ́ di bɑ́ɑ́ cɔ̃ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Kɛ̀ n di bútínnɛ́ kɛ̀ di dootitɔbɛ̀ɛ di nɑ, di níìmbɛ̀ bo di bɑɑtɛ́ kɛ̀ di ncooti bɑ́ bɛ̀ í di bɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Bɑ́ nɛ̀ mɛmmɛ kɛ̀ di í kèńtɛ́ n kpɛti, nní ndi sɔkɛ́ tiyɛ̃ĩti di yɛi nkpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","kɛ́pɔntɛ di wɛ̃rímú mùù te kɛ̀ di mɔkɛ tɛfentɛ̀, m bo duɔ́ nkɛ̀ tiwɛtìi kpenkɛ timɑ́tì tɛ̃mɛ̀ bɑ́ fɛtɑɑfɛ̀ bɑ́ nniu, kɛ̀ kɛtenkɛ̀ɛ kpenkɛ kɛ́dontɛnɛ̀ disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Kɛ̀ di sɔ̃́ntɛ́ kɛ́ndeu di wɛ̃rímú dɛtetìrɛ̀ bɑ́ di pɑɑ mbɑ́ mpɛí. Di pɑɑ nkó titebiiti mɛ mbɑ́ mpɛí. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Nɛ̀ mɛmmɛ kɛ̀ di yetɛ, kɛ í dɔ́ kɛ́ n kéntɛ́, nní ndi sɔkɛ́ tiyɛ̃ĩti di yɛi mmɑmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","kɛ́duɔ́ nkɛ̀ dɛsĩ̀nnɛ̀ɛ yɛ̀nní kɛ́mpĩĩ ndi bí, kɛ́deè di wũɔ̃, dɛsĩ̀nnɛ̀ bo di yɑɑtɛ kɛ̀ di cɛ di do keri ìi kpɑ́nnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Kɛ̀ n yĩ mɛmmɛ kɛ̀ dɛ̀ í sɑ̀nnɛ̀ kɛ bo di tié, kɛ̀ dɛ̀ dò ndi kpɑɑ́ sɔkɛ́ kɛ yetírí n kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","Dɛ mɔ̀nnì mí mmɔ́mmuɔ mmíì nɛ́ yóó cómmú kɛ́ di potɛ́ di yɛi nkpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","kɛ́duɔ́ nkɛ̀ di dootitɔbɛ̀ ndi kɔù, kɛ pɛiri di tɔ̃̀tɛ mɛ̀ɛ̀ kpɛ́í n di dɔ̀ɔ̀nɛ̀ mɛ̀ɛ̀ tɑummɛ̀. Kɛ̀ di cokɛ́ kɛ tìí ndi ɛkɛ̀ miɛkɛ, n duɔ́nko mutenkṹṹ nnɛ̀ dɛ kpɛ́í nkɛ̀ di tɑ di dootitɔbɛ̀ nɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kɛ̀ n di mɔntɛ mudiì, kɛ̀ bɛnitipòbɛ̀ tɛpíítɛ̀ níí wɛ̃nnɛ́ kɛ́pṹnnɛ́ pɛ̃́ɛ̃̀ dipɛ̃́ɛ̃̀fiunnì dimɑ́ɑ̀ miɛkɛ, kɛ́ wè ndi duɔ́ nkɛ̀ dí ò berí kɛ́wɛ́rí kɛ́cɑ́ɑ́kɛ́ bɑ́ di bɑ́ nsɑ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Kɛ̀ n yĩ mɛmmɛ kɛ̀ di bɑɑ yetɛ kɛ í dɔ́ kɛ n kéntɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","m miɛkɛ bo di yɛ̀, kɛ̀ n di ɑ̃nnɛ́ tiyɛ̃ĩti di yɛi nkpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","kɛ̀ di nkɔù di bí kɛ cɑ́ɑ́, initidɑɑì nɛ̀ initipòì, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","kɛ puɔ ndi bɔɔwũɔ̃tɔ̀rɛ̀ nɛ̀ di wũɔ̃tɔ̀rɛ̀ di tuɔ̀ nyɛ̀ɛ̀ ĩ́nkɛ̀ tihúúntì kɛ́ di kuɔ kɛ́wɛ̃nnɛ́nɛ̀ di bɔkɛ̀ m pùɔ nyɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","M miɛkɛ bo di yɛ̀ kɛ̀ n duɔ́ nkɛ̀ di ɛkɛ̀ɛ nɑɑ́ ntidobontì, kɛ̀ m puɔ ndi wũɔ̃tɔ̀rɛ̀, n tɛ̃́nkɛ bɑ́ nkémmú tihúúntì di tuɔ̀ ntì kó kufɔ̃ɔ̃ku. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Míì mɔ́mmuɔ nyóó pɔntɛ di kó dihɛì kɛ́dɛ́ítɛ́, kɛ̀ dɛ̀ɛ di di dootitɔbɛ̀ bɛ̀ɛ̀ kɔ̀riní kɛ bo mbo dɛ kó dihɛì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Kɛ̀ n duɔ́ nkɛ̀ mudoò tɑnní kɛ̀ dí cíɛ́tɛ́, kɛ̀ di cɛ̃́ĩĩ nɑɑ́ ntidobontì, kɛ̀ di tenkɛ̀ɛ dɔúnko. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Di bo mbo dìì mɔ̀nnì di dootitɔbɛ̀ tenkɛ̀ miɛkɛ, dɛ mɔ̀nnì di tenkɛ̀ bo pɛ́tɛ́ tɛom̀pùtɛ̀ di do kɛ̀ mɔ̀ntɛ tɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","kɛ̀ bo om̀pɛ̀, dɛ mɔ̀nnì kɛ́fɔ́ɔ́ ndi do kɛ̀ yetɛnɛ̀ tɛ̀ɛ̀ om̀pùtɛ̀ di bo dìì mɔ̀nnì kɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Di kɔbɛ bɛ̀ɛ̀ bo yentɛ́ di dootitɔbɛ̀ ɛkɛ̀ miɛkɛ m bo bɛ̀ ɑ̃nnɛ́ kufɔ̃wɑɑ́, mbɑ́ kɛ̀ kufɔ̃kpɛ̃̀rìkù nɑmpɛ bɛ̀ɛ cokɛ́ kɛ́ndò nhòmɔù bɛ̀ bɛ̀ti nɛ̀ disiè, kɛ̀ bɛ̀ ncokù kɛ duò bɑ́ òmɔù í bɛ̀ bɛ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Bɛ̀ bo ncokù kɛ bétírí bɛtɔbɛ̀ kɛ dò mbɛ dootitɔbɛ̀ bɛ̀ bɛ̀ti, òmɔù mɛ nyí bɛ̀ bɛ̀ti. Di bɑ́ɑ́ nɑ kɛ́bɑɑo di dootitɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Kɛ̀ di yɛi ndi dootitɔbɛ̀ tenkɛ̀ miɛkɛ, kɛ̀ kɛ̀ di di. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Di miɛkɛ bɛ̀ɛ̀ bo yentɛ́ kɛ́mbo bɛ dootitɔbɛ̀ ɛkɛ̀ miɛkɛ bɛ̀ bo ncĩtiri, bɛ mɔ́mmɔmbɛ bɛ yɛi nkpɛ́í nnɛ̀ bɛ yɛmbɛ̀ kɔ̃mɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Dɛ mɔ̀nnì ndi Isidɑyɛɛribɛ bɛ̀ɛ̀ yó nkpɑɑ́ bɛ̀ yóó bɑntɛ́mɛ̀ bɛmbɛ nɛ̀ bɛ yɛmbɛ̀ bɛ̀ dɔ̀ɔ̀mɛ̀ mɛyɛi nkɛ́ mɛ̀ dɑ́ɑ nkɛ dɔ̀: Ti cɑ̀ɑ̀rɛ̀mu ti yetɛmɛ̀ ɑ kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Dɛ mɔ̀nnì kɛ́bɑntɛ́ kɛ dò mmíì còḿmú kɛ bɛ̀ dènnɛ bɛ tenkɛ̀, kɛ bɛ̀ kɔ̀tɛnɛ̀ bɛ dootitɔbɛ̀ ciɛ. Dɛ mɔ̀nnì bɛmbɛ bɛ̀ɛ̀ to do kpeńnì kɛ̀ bɛ̀ɛ kɛ̃́kùnnɛ bɛmɑ́ɑ̀ kɛ́yie mbɛ cɑɑ̀rìmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Dɛ mɔ̀nnì kɛ̀ n dɑɑtɛní n dɔ̀ɔ̀nɛ̀ mɛ̀ɛ̀ tɑummɛ̀ Sɑkɔbu nɛ̀ Isɑki nɛ̀ Abɑrɑhɑmmu nɛ̀ n do nɑ̀kɛ́ tì bɛ kó dihɛì kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Bɛ̀ í bo yɛ̀ɛ̀ mɔ̀rɛ̀ miɛkɛ bɛ ɛì, dì bo om̀pɛ̀. Kɛ sɔ̃́ mbɛ̀ ìtɛ́ kɛ̀ dì dɔúnko, dɛ mɔ̀nnì kɛ̀ bɛ̀ɛ yɑ̀ mɛyɛi nkó mucɔ̃́ntimu bɛ̀ yetɛ mɛ̀ɛ̀ kpɛ́í n tié nkɛ pɛ̃̀ n kuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Bɑ́ nɛ̀ bɛ̀ yó mmɛ mbomɛ̀ bɛ dootitɔbɛ̀ ciɛ n yí yóó bɛ̀ dootóo, yoo m miɛkɛɛ bɛ̀ yɛ̀ kɛ̀ mbɛ̀ kùɔ pɑ́íí, kɛ́tɔ̃tɛ mɛtɑummɛ̀ n do bɛ̀ dɔ̀ɔ̀nɛ̀ mɛ̀. Mí mbɛ Yiɛ̀ nKuyie mmíì bɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","N yóó dɑɑtɛmu bɛ kpɛ́í nkɛ́dɑɑtɛní n do dɔ̀ɔ̀nɛ̀ mɛ̀ɛ̀ tɑummɛ̀ bɛ yɛmbɛ̀ kɛ́ bɛ̀ dènnɛ Esibiti ibotí tɛì nuɔ mmiɛkɛ kɛ bo ntú bɛ Yiɛ̀ nKuyie. Míì tu di Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Yɛɛ̀ tɑnnɔ̀ nyɛ ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́mɛ̀ Mɔyiisi nɛ̀ ku tié nnɛ̀ ku kuɔ́ Sinɑii tɑ̃rì ĩ́nkɛ̀ Isidɑyɛɛribɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkòò mɔù dɔ́ kɛ́dɛitɛ dinùù ò n dɔúnnɛ̀ dì, kòò n dɔúnnɛ̀ dinùù kɛ bennɛ́ nɛ̀ onìtì nwe. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Onìtì wèè mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ yɛbie nsipísìkuɔ̀ o díítí bo mɛdítíbii nsipísìnùmmù ndi, bɛ̀ kèétɛ́ ì mɛtɑummɛ̀ tou kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Kòo nitipòkù nwe o díítí bo mɛdítíbii nsipísìtɑ̃ɑ̃ti ndi. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Kɛ̀ dɛbirɛ ndɛ dɛ̀ɛ̀ mɔ̀kɛ yɛbie nyɛ̀nùmmù kɛ́ntɔ kɛ́tuɔkɛnɛ̀ sipísìdɛ́, kɛ̀ dɛ̀ tu dɛnitidɑɑrɛ ndɛ dɛ díítí mbo mɛdítíbii nsipísìdɛ́, kɛ̀ dɛnitipòrɛ̀ mɛ nni ndɛ ì mbo mɛdítíbii ntɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Dɛ̀ɛ̀ mɔ̀kɛ otɑ̃̀nkù òmɑ́ɑ̀ kɛ́ntɔ kɛ́tuɔkɛ yɛbie nyɛ̀nùmmù, kɛ̀ dɛnitidɑɑrɛ̀ ndɛ dɛ díítí mbo mɛdítíbii mmɛ̀nùmmù, kɛ̀ dɛnitipòrɛ̀ ndɛ mɛ̀ mbo mɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Yɛbie nsipísìkuɔ̀ kó difɔ̃nkúò kɔbɛ, kòo nitidɔ̀ù nwe mɛdítíbii ntɛpíítɛ̀ nɛ̀ mɛ̀nùmmù, onitipòkù mɛdítíbii ntɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Kòo mɔù mɛ ncĩ̀tɛ kɛ í dò nhò bo nɑ kɛ́yietí dɛ kó idíítí, bɛ̀ɛ ò tɔní ikuɔ́ nìùtì borɛ̀, kɛ̀ ikuɔ́ nìùtìi kéétɛ́ o díítí. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Kɛ̀ dɛ̀ mɛ ndò mbɛ̀ m pɑ̃ dɛ̀ tu fɛɔ̃̀fɛ̀ nfɛ bɛ̀ n feu fɛ̀, fɛ̀ tu n kɔfɛ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Bɛ̀ bɑ́ɑ́ nɑ kɛ́ fɛ̀ cèètɛnɛ̀ fɛtɛfɛ̀ fɛsɑ̀ɑ̀fɛ̀ yoo fɛsĩ̀nfɛ̀. Kɛ̀ bɛ̀ tùótɛ́ fɛɔ̃̀fɛ̀ bɛ̀ m pɑ̃ fɛ̀ kɛ cèètɛnɛ̀ fɛtɛfɛ̀ idɛ́ ì nɑɑ́ n kpɛyi nyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Kɛ̀ dɛ kó fɛɔ̃̀fɛ̀ mɛ ntu ikuɔ́ yetɛ fɛ̀nfɛ, bɛ̀ɛ fɛ̀ bɛnkɛ ikuɔ́ nìùtì bɑ́ kɛ̀ fɛ̀ tu fɛ̀ɛ̀ botí, ");
INSERT INTO tbzsim_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","kòo fɛ̀ wèńtɛ́ kɛ́yɑ̀ fɛ̀ wenni yoo fɛ̀ sĩ̀ nkɛ́kéétɛ́ fɛ díítí. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Kɛ̀ fɛ yiɛ̀ nweè mɛ ndɔ́ kɛ́wɛ̃tɛ kɛ́ fɛ̀ dontɛ́ wèe yietí bɛ̀ fɛ̀ kèétɛ́ ìì díítí kɛ́nɔ́ɔ́ nkɛ ì mmɑ̀nnɛ̀ ò bo totɛ́mɛ̀ ò mɛ nyietí ì yɛcúò yɛ̀nùmmù kó dìmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Kòò mɔù m pɑ̃ o cĩ́ɛ̃̀tɛ̀, ikuɔ́ nìùtìi tɛ̀ wèńtɛ́, kɛ̀ tɛ̀ wenni yoo tɛ sĩ̀, kòò yĩ́ mù, mummu. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Kɛ̀ tɛ̀ yiɛ̀ nweè mɛ ndɔ́ kɛ́wɛ̃tɛ kɛ́ tɛ̀ dontɛ́ wèe yietí bɛ̀ tɛ̀ kèétɛ́ ìì díítí kɛ́nɔ́ɔ́ nkɛ̀ ì mmɑ̀nnɛ̀ bɛ̀ bo totɛ́mɛ̀ ò yietí ì yɛcúò yɛ̀nùmmù kó dìmɑ́ɑ̀ kɛ́ ntɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Kòò mɔù m pɑ̃ kɛtenkɛ̀, dí wéntɛ́ bɛ̀ bo kɛ̀ buɔtí tidibotì kɛ̀ tì mmɑ̀mɛ̀, kɛ́kéétɛ́ kɛ díítí. Kɛ̀ kɛ̀ dò nkɛ bo nɑ kɛ́cɔutɛ́ tidibotì cìdóòbɛ̀ sikɔusìtɑ̃ɑ̃ti (300) kɛ díítí mbo mɛdítíbii nsipísìnùmmù. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Kòò yó m pɑ̃ dɛ kó kɛtenkɛ̀, kɛ sɔ̃́ tidɑɑtì fĩ́ĩmmù benni bo kɛ díítí bɑɑ mmɛ mmɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Kɛ̀ tidɑɑtì fĩ́ĩmmù benni mɛ mpɛ̃ɛ̃tɛ́, kòò kɛ̀ nni mpɑ̃, ikuɔ́ nìùtìi kɑɑ̀ nyɛbie nyɛ̀ɛ̀ kpɑɑ́ kɛ̀ tidɑɑtì fĩ́ĩmmù benni tɛrìi tuɔkɛní kɛ́kéétɛ́ kɛ díítí. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Kɛ̀ kɛ̀ yiɛ̀ nwɛ̃̀tɛ kɛ dɔ́ kɛ́ kɛ̀ dontɛ́ wèe yietí ikuɔ́ nìùtì kèétɛ́ ìì díítí kɛ́nɔ́ɔ́ nkɛ ì mmɑ̀nnɛ̀ bɛ̀ bo totɛ́mɛ̀ ò yietí ì yɛcúò yɛ̀nùmmù kó dìmɑ́ɑ̀ kɛ́ kɛ̀ tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Kòo mɛ nyí kɛ̀ dontɛ́ o mɔ́mmuɔ nkòò kɛ̀ fìtɛ́nɛ̀ otɔù mɔù dɛ̀ dèèmu. Ò tɛ̃́nkɛ bɑ́ɑ́ nɑ kɛ́ kɛ̀ dontɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Kɛ̀ tidɑɑtì fĩ́ĩmmù benni mɛ ntùɔ̀kɛ, wèè mɛ nkɛ̀ dontɛ́ wèe kɛ̀ yóu, kɛ̀ nɑɑ́ n kɔkɛ nkɛ. Ikuɔ́ nìùbɛ̀ bɛɛ̀ kɛ̀ tiekɛ. Bɛ̀ kɛ̀ nni mpɑ̃mu. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Kòò mɔù m pɑ̃ kɛtenkɛ̀ ò dontɛ́ kɛ̀, kɛ̀ dɛ̀ í tú o yɛmbɛ̀ kɔkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ikuɔ́ nìùtìi wéntɛ́ yɛbie nyɛ̀ɛ̀ kpɑɑ́ kɛ̀ tidɑɑtì fĩ́ĩmmù bennii tuɔkɛní kɛ́kéétɛ́ kɛ díítí wèè kɛ̀ nni mpɑ̃ɑ̃ nkòo yietí kɛ díítí dɛ yiè, ì tu n kpɛyi nyi. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Kɛ̀ tidɑɑtì fĩ́ĩmmù benni tùɔ̀kɛ wèè do kɛ̀ te nɛ̀ dimɔ̀nnì wèe wɛ̃tɛ kɛ́ kɛ̀ cɔutɛ́, o yɛmbɛ̀ kɔkɛ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Bɛ̀ níí yóó tũnnɛ idìítí ìì kèétɛ́ mɛtɑummɛ̀ tou kpɛ́í i kó kukperíkù nku, kɛ́kéétɛ́ dɛ kó idíítí. Dɛ kó idíítí kó fɛsɑ́m̀pɔ́fɛ̀ cɛ̃́ɛ̃́kù bo kɑ̀dɑ́mmù tɛpíítɛ̀ ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Òmɔù bɑ́ m pɑ̃ o ɔ̃̀fɛ̀ pɛitɛ́ fɛ̀ mɛketimɛ̀ kɛ̀ fɛ̀ tu fɛdɑɑfɛ̀, fɛ̀ diɛ nkɛ tú n kɔfɛ nfɛ. Kòo nɑ̀ɑ̀fɛ̀ nfɛ yoo o pìèfɛ̀ yoo o buɔtɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Kòò mɔù m pɑ̃ fɛɔ̃̀fɛ̀ bɛ̀ í n feu fɛ̀, bɛ̀ bo nɑ kɛ́wɛ̃tɛ kɛ́ fɛ̀ dontɛ́ kɛ́yietí fɛ díítí kɛ́nɔ́ɔ́ nkɛ̀ dɛ̀ mmɑ̀nnɛ̀ bɛ̀ bo totɛ́mɛ̀ o yietí ì yɛcúò yɛ̀nùmmù kó dìmɑ́ɑ̀. Kɛ̀ fɛ yiɛ̀ mɛ nyí dɔ́ kɛ́wɛ̃tɛ kɛ́ fɛ̀ dontɛ́ bɛ̀ɛ fɛ̀ fìtɛ́ fɛ díítí. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Kòò mɔù m pɑ̃ dɛ̀mɑrɛ̀ kɛ tú, ò dɛ̀ nni mpɑ̃mu sɑ̃́ɑ̃̀, bɛ̀ bɑ́ɑ́ nɑ kɛ́wɛ̃tɛ kɛ́ dɛ̀ dontɛ́ yoo bɛ̀ɛ dɛ̀ fìtɛ́. Kòo nìtì nwe yoo fɛɔ̃̀fɛ̀ yoo o yɛmbɛ̀ o yóunɛ̀ kɛ̀ɛ̀ tenkɛ̀, bɛ̀ m pɑ̃ɑ̃ ndɛ̀ɛ̀ kó dimɑ̀ɑ̀ mɛbotí dɛ̀ tu n kpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Kòo nìtì nwe bɛ̀ m pɑ̃mɛ̀ bɛ̀ bɑ́ɑ́ nɑ kɛ́wɛ̃tɛ kóò dontɛ́, bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","Kɛ̀ di dɛ̀itɛ di pɑɑ nkó tidiitì nɛ̀ di tebiiti dí dɛ̀ berí kɛ́dɛitɛ dɛ̀ɛ̀ tu dɛpííndɛ̀, dɛ̀ tu n kpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Kòò mɔù dɔ́ kɛ́wɛ̃tɛ kɛ́dontɛ́ o kó dɛpííndɛ̀ kó dɛ̀mɑrɛ̀ wèe yietí kɛ́nɔ́ɔ́ nkɛ̀ dɛ̀ mmɑ̀nnɛ̀ bɛ̀ bo totɛ́mɛ̀ ò yietí ì yɛcúò yɛ̀nùmmù kó dìmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Dɛ̀ɛ̀ kó dimɑ̀ɑ̀ tu iwũɔ̃, inɑ̀ɑ̀kɛ nɛ̀ ipe nɛ̀ sibɔɔ́, fɛ̀ɛ̀ ɔ̃̀fɛ̀ níí tú fɛpíínfɛ̀ fɛ̀ tu nkɔfɛ nfɛ. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Dí níí bɑ́ɑ́ fɛ̀ cèètɛnɛ̀ fɛsɑ̀ɑ̀fɛ̀ yoo fɛsĩ̀nfɛ̀. Kòò mɔù fɛ̀ cèètɛ, fɛnfɛ nɛ̀ ò cèètɛnɛ̀ fɛ̀ idɛ́ ì nɑɑ́ n kpɛyi nyi, bɛ̀ mɛ mbɑ́ɑ́ nɑ kɛ́wɛ̃tɛ kɛ́ ì dontɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Ti Yiɛ̀ nKuyie ndo duɔ́ nyìì kuɔ́ nyi Mɔyiisi Sinɑii tɑ̃rì ĩ́nkɛ̀ Isidɑyɛɛribɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Isidɑyɛɛribɛ yɛ̀ Esibiti kɛ̀ dɛ̀ mmɔkɛ dibenni ndi. Dibenni dɛ́rì kóo tɑ̃̀nkù odɛ́rì kó diyiè ketirì, kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi Sinɑii kó dikpɑ́ɑ̀ ku tɑummɛ̀ tou miɛkɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","Kɑɑnnɛ̀ Isidɑyɛɛribɛ kɛ́ntũ mbɛ nɑɑ̀mùntì tũmmɛ̀ titɔbɛ̀ nɛ̀ bɛ cɛ̃́ĩ tũ ntũmmɛ̀ sitɔbɛ̀, di kɑɑ mbɛ̀ɛ̀ kó dimɑ̀ɑ̀ tu bɛnitidɑɑbɛ̀ kɛ́wɑ̃ri bɑ́ wè o yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Mɔyiisi fɔ̃́ nnɛ̀ Anɔɔ di kɑɑ nyIsidɑyɛɛribɛ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ntɔ kɛ deètìnko bɛ̀ɛ̀ bo nɑ kɛ́kɔtɛ mudoò bɛ tĩ̀rɛ̀ dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Bɑ́ kùù nɑɑ̀mùnkù bɛ cɛ̃́ĩ miɛkɛ dí dɛitɛ okótì òmɑ́ɑ̀ òmɑ́ɑ̀ kɛ̀ bɛ̀ ndi nɛínɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Ntɛ bɛ̀ɛ̀ yóó di nɛinɛ̀ bɛ yètɛ̀: Dubɛnni kó kunɑɑ̀mùnkù miɛkɛ, Sedeuu birɛ Edisuu. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","Simmɛɔ̃ɔ̃ kɔku miɛkɛ, Sudisɑdɑii birɛ Sedumiɛri. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","Sudɑɑ kɔku, Amminɑdɑbu birɛ Nɑsɔ̃ɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","Isɑkɑɑ kɔku, Suɑɑ birɛ Nɛtɑnnɛyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","Sɑbunɔɔ kɔku, Edonni birɛ Ediɑbu. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","Sosɛfu kó ibí Efɑdɑimmu nɛ̀ Mɑnɑnsee bɛ kó tinɑɑ̀mùntì kɔbɛ: Efɑdɑimmu kɔku, Ammiudi birɛ Edisɑmɑ. Mɑnɑnsee kɔku, Pedɑsuu birɛ Kɑmmidiyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","Bɛnsɑmɛɛ kɔku, Kideonii birɛ Abidɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","Dɑnni kɔku, Amisɑdɑii birɛ Ayiesɛɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","Asɛɛ kɔku, Okɑdɑnni birɛ Pɑkiyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","Kɑdi kɔku, Deuyɛɛdi birɛ Ediɑsɑfu. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","Nɛfutɑdii kɔku, Enɑnni birɛ Aidɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Dɛ kó bɛnìtìbɛ̀ do tú bɛ̀ tɑ̃ɑ̃tɛ́ bɛ̀mbɛ. Bɛ̀ do tú bɛ̀ɛ̀ kòtí bɛ̀mbɛ bɛ botí miɛkɛ kɛ ni bɛnìtìbɛ̀ sikɔupí. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mɛm̀mɛ Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ túótɛ́ dɛ kó bɛnìtìbɛ̀ bɛ̀ tɑ̃ɑ̃tɛ́ bɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","kɛ́tíí nyIsidɑyɛɛribɛ bɛmɔu otɑ̃̀nkù dɛ́rì kó diyiè ketirì, kɛ̀ Isidɑyɛɛribɛɛ bɑtɛ bɛ nɑɑ̀mùntì nɛ̀ bɛ cɛ̃́ĩ, kɛ̀ bɛ̀ɛ dɛi bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ sìdɛ́ kɛ́ndeètìnko. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Mɛm̀mɛ Mɔyiisi bɛ̀ kɑ̀ɑmmɛ̀ Sinɑii kó dikpɑ́ɑ̀ miɛkɛ ti Yiɛ̀ nKuyie ndo tì nhò nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Bɛ̀ bɑ̀tɛ dìì mɔ̀nnì Dubɛnni wèè tu Isidɑyɛɛribɛ kóo po kó kunɑɑ̀mùnkù kɛ́deè kɛ̀ bɛ̀ɛ kɑɑ mbɛ̀ɛ̀ kó dimɑ̀ɑ̀ tùɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò mbɛ̀ bo nɑ kɛ́kɔtɛ mudoò. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Bɛ̀ do kɑ̀ɑ mbɛ̀ Dubɛnni kó kunɑɑ̀mùnkù bɛ̀ do bo sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔupísìkuɔ̀ nɛ̀ sikɔusìnùmmù ndi (46500). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Kɛ̀ bɛ̀ɛ bɑtɛ Simmɛɔ̃ɔ̃ kó kunɑɑ̀mùnkù kɛ́kɑɑ mbɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko bɛnitidɑɑbɛ̀ mɑ́ɑ̀ kɛ́wɑ̃ri bɛ yètɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Kɛ̀ bɛ̀ ḿbo sikɔupípísìnùmmù nɛ̀ sikɔupísìwɛi nɛ̀ sikɔusìtɑ̃ɑ̃ti (59300). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Kɛ̀ bɛ̀ɛ bɑtɛ Kɑdi nɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀ bɛnitidɑɑbɛ̀, bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Kɛ̀ bɛ̀ ḿbo sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔupísìnùmmù nɛ̀ sikɔusìkuɔ̀ nɛ̀ sipísìnùmmù (45650). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Kɛ̀ bɛ̀ɛ bɑtɛ Sudɑɑ nɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀ bɛnitidɑɑbɛ̀, bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Kɛ̀ bɛ̀ ḿbo sikɔupípísìyiekɛ̀ nɛ̀ sikɔupísìnɑ̀ɑ̀ nɛ̀ sikɔusìkuɔ̀ (74600). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Kɛ̀ bɛ̀ɛ bɑtɛ Isɑkɑɑ nɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀ bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","kɛ̀ bɛ̀ ḿbo sikɔupípísìnùmmù nɛ̀ sikɔupísìnɑ̀ɑ̀ nɛ̀ sikɔusìnɑ̀ɑ̀ (54400). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Kɛ̀ bɛ̀ɛ bɑtɛ Sɑbunɔɔ nɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀ bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","kɛ̀ bɛ̀ ḿbo sikɔupípísìnùmmù nɛ̀ sikɔupísìyiekɛ̀ nɛ̀ sikɔusìnɑ̀ɑ̀ (57400). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Kɛ̀ bɛ̀ɛ bɑtɛ Sosɛfu birɛ Efɑdɑimmu kó kunɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀ bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","kɛ̀ bɛ̀ ḿbo sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔusìnùmmù (40500). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Kɛ̀ bɛ̀ɛ bɑtɛ Mɑnɑnsee, Sosɛfu birɛ tɛrɛ̀ kó kunɑɑ̀mùnkù kɔbɛ, bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","kɛ̀ bɛ̀ ḿbo sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìdɛ́ nɛ̀ sikɔusìdɛ́ (32200). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Kɛ̀ bɛ̀ɛ bɑtɛ Bɛnsɑmɛɛ kó kunɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀ bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","kɛ̀ bɛ̀ ḿbo sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìnùmmù nɛ̀ sikɔusìnɑ̀ɑ̀ (35400). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Kɛ̀ bɛ̀ɛ bɑtɛ Dɑnni kó kunɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀, bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","kɛ̀ bɛ̀ ḿbo sikɔupípísìkuɔ̀ nɛ̀ sikɔupísìdɛ́ nɛ̀ sikɔusìyiekɛ̀ (62700). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Kɛ̀ bɛ̀ɛ bɑtɛ Asɛɛ kó kunɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀, bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","kɛ̀ bɛ̀ ḿbo sikɔupípísìnɑ̀ɑ̀ nɛ̀ tɛkɔupíítɛ̀ nɛ̀ sikɔusìnùmmù (41500). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Kɛ̀ bɛ̀ɛ bɑtɛ Nɛfutɑdii kó kunɑɑ̀mùnkù kɔbɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀, bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Kɛ̀ bɛ̀ ḿbo sikɔupípísìnùmmù nɛ̀ sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìnɑ̀ɑ̀ (53400). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Mɛm̀mɛ Mɔyiisi nɛ̀ Anɔɔ nɛ̀ Isidɑyɛɛribɛ kó tinɑɑ̀mùntì tɛpíítɛ̀ nɛ̀ tìdɛ́tì kó bɛkótíbɛ̀ kɑ̀ɑmmɛ̀ Isidɑyɛɛribɛ bɛ cɛ̃́ĩ dò ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Kɛ̀ bɛ̀ɛ bɑtɛ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛmɔu kɛ́mbo sikɔupíkɔùsìkuɔ̀ nɛ̀ sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìnùmmù nɛ̀ sipísìnùmmù (603550). ");
INSERT INTO tbzsim_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Bɛ̀ nɛ́ í nwɛ̃nnɛ́nɛ̀ Defii kó kuwuɔ nkɛ kɑ̀ɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","A bɑ́ɑ́ kɑɑ nDefii kó kuwuɔ, ɑ bɑ́ɑ́ bɛ̀ kɑ̀ɑnnɛ̀ Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Á bɛ̀ duɔ́ mmɛtɑummɛ̀ tou kó mutɔ̃mmú, kɛ̀ bɛ̀ ndɑkɛ n nɛntì kpɛ́í nnɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ cɛ̃́nkɛ tú mɛtɑummɛ̀ tou kpɛrɛ. Bɛɛ̀ yó ntɔu n tɑummɛ̀ tou nɛ̀ di nɛntì, bɛɛ̀ yó nte dɛ kó mutɔ̃mmú, kɛ̀ di bɑ̀tɛ́ dɛ̀ bɛɛ̀ yóó fitɛ́ mɛtɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Kɛ̀ mɛtɑummɛ̀ tou do nkɛ́sɔɔ́ ndikɑrì bɛɛ̀ yóó dì kpèétɛ́, kɛ̀ dì tùɔ̀kɛ dì bo cómmú dɛ̀, bɛ̀ɛ dì còńnɛ́. Wèè í tú Defii botí kou kòò dì tɔ̀ɔ́nnɛ̀ bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Isidɑyɛɛribɛ bɑ́ dìì tĩ̀nnì dì níí bɑ́tɛ́ di kó mɛfíè, di kó mɛcɑnnimɛ̀ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Kɛ̀ Defiibɛ bɛɛ̀ bɑ́tɛ́ kɛ́fitɛ́ mɛtɑummɛ̀ tou, kɛ̀ dɛ̀ɛ yie mmí nKuyie nkɛ̀ m miɛkɛ bɑ́ɑ́ do Isidɑyɛɛribɛ. Defiibɛ bɛɛ̀ yó mpĩ́ mɛtɑummɛ̀ tou miɛkɛ mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛɛ tũnnɛ weti weti ti Yiɛ̀ nKuyie nnɑ̀kɛ́ tì Mɔyiisi bɛ kpɛ́í nkòò tì mbɛ̀ nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Dɛ kó difɔ̃nkúò kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Isidɑyɛɛribɛ bɑ́ dìì tĩ̀nnì dì níí bɑ́tɛ́ di wuɔ nkó mɛcɑnnimɛ̀ borɛ̀ kɛ́fitɛ́ mɛtɑummɛ̀ tou, kɛ́ ndì ciɛ́nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","8","Sudɑɑ kó ditĩ̀nnì kɔbɛ nɛ̀ Isɑkɑɑ kpɛri kɔbɛ nɛ̀ Sɑbunɔɔ kpɛri bɛɛ̀ yóó wɛ̃nnɛ́ kɛ́bɑ́tɛ́ mɛtɑummɛ̀ tou diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀, Sudɑɑ kó mɛcɑnnimɛ̀ borɛ̀. Kɛ̀ Amminɑdɑbu birɛ Nɑsɔ̃ɔ̃ nni Sudɑɑ kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì kɛ̀ dì ḿbo bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìyiekɛ̀ nɛ̀ sikɔupísìnɑ̀ɑ̀ nɛ̀ sikɔusìkuɔ̀ (74600). Kɛ̀ Suɑɑ birɛ Nɛtɑnnɛ yɛɛdi nni Isɑkɑɑ kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìnùmmù nɛ̀ sikɔupísìnɑ̀ɑ̀ nɛ̀ sikɔusìnɑ̀ɑ̀ (54400). Kɛ̀ Edonni birɛ Ediɑbu ni Sɑbunɔɔ kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìnùmmù nɛ̀ sikɔupísìyiekɛ̀ nɛ̀ sikɔusìnɑ̀ɑ̀ (57400). ");
INSERT INTO tbzsim_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛmɔu kɛ́mbo bɛhɑ̃ɑ̃pɔ̀mbɛ̀ tɛkɔupíkɔ̀ùtɛ̀ nɛ̀ sikɔupípísìni nɛ̀ sikɔupísìkuɔ̀ nɛ̀ sikɔusìnɑ̀ɑ̀ (186400). Bɛɛ̀ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì níí yóó niitɛ́ kɛ́ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","16","Dubɛnni kó ditĩ̀nnì kɔbɛ nɛ̀ Simmɛɔ̃ɔ̃ kó ditĩ̀nnì kɔbɛ nɛ̀ Kɑdi kó ditĩ̀nnì kɔbɛ bɛɛ̀ yóó wɛ̃nnɛ́ kɛ́bɑ́tɛ́ mɛtɑummɛ̀ tou bɑkù cɑ̃̀nku bíɛ́kɛ̀, Dubɛnni kó mɛcɑnnimɛ̀ borɛ̀. Kɛ̀ Sedeuu birɛ, Edisuu nni Dubɛnni kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔupísìkuɔ̀ nɛ̀ sikɔusìnùmmù (46500). Kɛ̀ Sudisɑdɑii birɛ Sedumiɛri nni Simmɛɔ̃ɔ̃ kó ditĩ̀nnì kɔbɛ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìnùmmù nɛ̀ sipísìwɛi nɛ̀ sikɔusìtɑ̃ɑ̃ti (59300). Kɛ̀ Deuyɛɛdi birɛ Ediɑsɑfu nni Kɑdi kó ditĩ̀nnì kɔbɛ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔupísìnùmmù nɛ̀ sikɔusìkuɔ̀ nɛ̀ sipísìnùmmù (45650). Kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛmɔu kɛ́mbo bɛhɑ̃ɑ̃pɔ̀mbɛ̀ tɛkɔupíkɔ̀ùpíítɛ̀ nɛ̀ sikɔupípísìnùmmù nɛ̀ tɛkɔupíítɛ̀ nɛ̀ sikɔusìnɑ̀ɑ̀ nɛ̀ sipísìnùmmù (151450). Bɛɛ̀ yó mpokoo Sudɑɑ nɛ̀ o kɔbɛ bɛ kó yɛtĩ̀rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Bɛ kó difɔ̃nkúò kɛ̀ Defiibɛɛ tũnnɛ nɛ̀ mɛtɑummɛ̀ tou, Defiibɛ kó dikɑrì diì níí yó mbo dɛ cuokɛ̀. Bɛ̀ yó ntũ mbɛ̀ bɑ̀tɛ́ mɛ̀ɛ̀ botí nku kɛ iiti, bɑ́ wè ò níí yó mbo o kó mɛcɑnnimɛ̀ borɛ̀ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","24","Efɑdɑimmu kó ditĩ̀nnì kɔbɛ nɛ̀ Mɑnɑnsee kpɛri bɛɛ̀ yóó wɛ̃nnɛ́ kɛ́bɑ́tɛ́ mɛtɑummɛ̀ tou diyiè tɑɑ̀ kɛ̀ɛ̀ bíɛ́kɛ̀ Efɑdɑimmu kó mɛcɑnnimɛ̀ borɛ̀. Kɛ̀ Ammiudi birɛ Edisɑmɑ nni Efɑdɑimmu kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔusìnùmmù (40500). Kɛ̀ Pedɑsuu birɛ Kɑmmidiyɛɛri nni Mɑnɑnsee kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìdɛ́ nɛ̀ sikɔusìdɛ́ (32200). Kɛ̀ Kideonii birɛ Abidɑnni nni Bɛnsɑmɛɛ kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìnùmmù nɛ̀ sikɔusìnɑ̀ɑ̀ (35400). Kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛmɔu bɛhɑ̃ɑ̃pɔ̀mbɛ̀ tɛkɔupíkɔ̀ùpíítɛ̀ nɛ̀ sikɔupísìni nɛ̀ tɛkɔ̀ùtɛ̀ (108100). Bɛɛ̀ níí yó ntú ditĩ̀nnì tɑ̃ɑ̃́nnì kɛ́ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","31","Dɑnni kó ditĩ̀nnì kɔbɛ nɛ̀ Asɛɛ kó ditĩ̀nnì kɔbɛ nɛ̀ Nɛfutɑdii kó ditĩ̀nnì kɔbɛ bɛɛ̀ yóó wɛ̃nnɛ́ kɛ́bɑ́tɛ́ mɛtɑummɛ̀ tou bɑkù yoú bíɛ́kɛ̀, Dɑnni kó mɛcɑnnimɛ̀ borɛ̀. Kɛ̀ Amisɑdɑii birɛ Ayiesɛɛ nni Dɑnni kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì kɔbɛ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìkuɔ̀ nɛ̀ sikɔupísìdɛ́ nɛ̀ sikɔusìyiekɛ̀ (62700). Kɛ̀ Okɑdɑnni birɛ Pɑkiyɛɛdi nni Asɛɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì kɔbɛ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìnɑ̀ɑ̀ nɛ̀ tɛkɔupíítɛ̀ nɛ̀ sikɔusìnùmmù (41500). Kɛ̀ Enɑnni birɛ Aidɑ nni Nɛfutɑdii kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì sikɔupípísìnùmmù nɛ̀ sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìnɑ̀ɑ̀ (53400). Kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛmɔu bɛhɑ̃ɑ̃pɔ̀mbɛ̀ tɛkɔupíkɔ̀ùtɛ̀ nɛ̀ sikɔupípísìnùmmù nɛ̀ sikɔupísìyiekɛ̀ nɛ̀ sikɔusìkuɔ̀ (157600). Bɛɛ̀ níí yó ntú bɛsɔmbɛ kɛ́ítɛ́. Bɑ́ dìì ɑ̃ɑ̃pɔ̀ntĩ̀nnì níí yó mbo di kó mɛcɑnnimɛ̀ borɛ̀ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Isidɑyɛɛribɛ mbɛ bɛ̀ do kɑ̀ɑ mbɛ̀ kɛ́ bɛ̀ bɑ̀tɛ bɛ cɛ̃́ĩ dòmmɛ̀, bɛ kó yɛhɑ̃ɑ̃pɔ̀ntĩ̀rɛ̀ yɛmɔu kɛ̀ yɛ̀ɛ wɛ̃nnɛ́ kɛ́mbo bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sikɔupípísìkuɔ̀ nɛ̀ sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìnùmmù nɛ̀ sipísìnùmmù (603550). ");
INSERT INTO tbzsim_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Bɛ̀ mɛ nyí nkɑ̀ɑnnɛ̀ Defiibɛ Isidɑyɛɛribɛ tɔbɛ̀ cuokɛ̀ ti Yiɛ̀ nKuyie ndo ti nɑ̀kɛ́ Mɔyiisi kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Kɛ̀ Isidɑyɛɛribɛɛ tũnnɛ weti weti ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́ tì Mɔyiisi. Mɛm̀mɛ kɛ̀ bɛ̀ɛ cómmú bɛmɑ bɛmɑ bɛ cɑnnimɛ̀ dò ndòmmɛ̀. Mɛm̀mɛ bɛ̀ ìtɛ́mɛ̀ bɛ kɑrì bɑ́ wè o nɑɑ̀mùnkù dòmmɛ̀ nɛ̀ o cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Ntɛ Mɔyiisi nɛ̀ Anɔɔ bɛ kó iwuɔ. Ti Yiɛ̀ nKuyie ndo yóó bɛ́innɛ̀ Mɔyiisi Sinɑii tɑ̃rì ĩ́nkɛ̀ kɛ̀ Anɔɔ mɔ̀kɛ ibí ìnɑ̀ɑ̀ ndi ìì yètɛ̀ tu: ");
INSERT INTO tbzsim_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Nɑdɑbu weè do tú Mpo, kɛ́nɑntɛ Abiu, kòo nɑntɛ Edeɑsɑɑ nɛ̀ Itɑmɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Anɔɔ kó ibí nyi mɛmmɛ, bɛ̀ do còú mbɛ̀ɛ̀ yɔ mɛkùɔ̀ nkɛ bɛ̀ cɑ̃̀ńnɛ́ kɛ̀ bɛ̀ bo mpĩ́ nyikuɔ́ tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Nɑdɑbu nɛ̀ Abiu kɛ̀ bɛ̀ɛ kú Sinɑii kó dikpɑ́ɑ̀ mɛtɑummɛ̀ tou bòrìnùù, kɛ yɛ̃́ bɛ̀ do tùɔnnɛ̀mɛ̀ ti Yiɛ̀ nKuyie ntihúúntì muhɑ̃ɑ̃́ nsɔ̃́ntíkɛ kɔ̃mu. Bɛ̀ do yóó kú kɛ í mɔkɛ ibí. Edeɑsɑɑ nɛ̀ Itɑmɑɑ kɛ̀ bɛ̀ɛ sɔɔtɛ́ kɛ́mpĩ́nnɛ̀ bɛ cicɛ Anɔɔ ikuɔ́ tɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","Duɔ́ nkɛ̀ Defii kó kuwuɔ nkɔbɛɛ tíínní, kɑ̀ɑ bɛ̀ duɔ́ nhAnɔɔ kɛ̀ bɛ̀ nwɛ̃ nkɛ pĩ́ mmutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Kɛ̀ bɛ̀ɛ nhò teénnɛ̀ kɛ̀ bɛ̀ mpĩ́ mmutɔ̃mmú mɛtɑummɛ̀ tou, Isidɑyɛɛribɛ bɛmɔu kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Bɛɛ̀ yó ndɑkɛ mɛtɑummɛ̀ tou kó tinɛntì kpɛ́í kɛ́mpĩ́ nyIsidɑyɛɛribɛ kó mutɔ̃mmú mɛtɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Á duɔ́ nDefiibɛ Anɔɔ nɛ̀ o bí, míì bɛ̀ dɛ̀itɛ Isidɑyɛɛribɛ miɛkɛ kɛ yɛ̃ nhɑ́ bɛ̀ mbɛ̀ duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Anɔɔ nɛ̀ o bí bɛɛ̀ mɑ́ɑ̀ yó ntú ikuɔ́ nìùbɛ̀, kɛ́mpĩ́ nyikuɔ́ tɔ̃mmú, kɛ̀ wèè í tú Defii botí kou kòò kɑ̀ɑ́kɛ́ dɛ kó mutɔ̃mmú bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Kɛ̀ ti Yiɛ̀ nKuyie nní nsɔkɛ́ ku nɑ́ɑǹtì kɛ́bɛ́i nkɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","Míì tɑ̃ɑ̃tɛ́ Defiibɛ Isidɑyɛɛribɛ sɔmbɛ cuokɛ̀, kɛ̀ bɛ̀ bo cɔutɛ́ bɛ̀ɛ̀ tu Mpo bɛ kó difɔ̃̀tìrì kɛ́mpĩ́ n tɔ̃mmú, míì bɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Kɛ yɛ̃́ bɛ̀ɛ̀ tu Mpo bɛ kó dimɑ̀ɑ̀ tumɛ̀ n kɔbɛ mbɛ. M potɛ́ dìì yiè Esibiti tenkɛ̀ miɛkɛ bɛ̀ɛ̀ tu Mpo, dɛ yiè ndi n cɑ̃̀ńnɛ́mɛ̀ Isidɑyɛɛribɛ miɛkɛ bɛ̀ɛ̀ tu Mpo nɛ̀ bɛ wũɔ̃ piɛ́ ìì bí ketiyì kɛ̀ ì tu idɑɑì, kɛ̀ dɛ̀ bo ntú mí ndi Yiɛ̀ nKuyie n kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi Sinɑii kó dikpɑ́ɑ̀ miɛkɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","Á kɑɑ nDefii kó ibí initidɑɑì bɛ nɑɑ̀mùntì nɛ̀ bɛ cɛ̃́ĩ, kɛ́ketɛ́nɛ̀ ìì mɔ̀kɛ otɑ̃̀nkù òmɑ́ɑ̀ òmɑ́ɑ̀ kɛ́ndeètìnko. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Kɛ̀ Mɔyiisii tũnnɛ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì kɛ́ bɛ̀ kɑ̀ɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Ntɛ Defii bí kó yɛyètɛ̀: Kɛrisonni nɛ̀ Keɑti nɛ̀ Mɛdɑdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Kɛ̀ Kɛrisonni kó ibí ntú: Dibini nɛ̀ Simɛii. Bɛ kó tinɑɑ̀mùntì nti mɛmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Kɛ̀ Keɑti kó ibí ntú: Amudɑmu nɛ̀ Isɑɑdi nɛ̀ Ebunɔɔ nɛ̀ Usiyɛɛdi. Bɛ kó tinɑɑ̀mùntì nti mɛmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Kɛ̀ Mɛdɑdi kpɛyi ntú: Mɑdi nɛ̀ Musi. Defii kó ibí nyi mɛmmɛ bɛ nɑɑ̀mùntì nɛ̀ bɛ cɛ̃́ĩ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Kɛrisonni kó tinɑɑ̀mùntì do tú: Dibunii kɔku nɛ̀ Semmɛii kɔku kɛ̀ bɛ̀ ntú Kɛrisonniibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ́tuotɛ́ initidɑbí ìì mɔ̀kɛ otɑ̃̀nkù kɛ́ntɔ kɛ deètìnko kɛ̀ bɛ̀ mbo sikɔupísìyiekɛ̀ nɛ̀ sikɔusìnùmmù (7500). ");
INSERT INTO tbzsim_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Kɛrisonniibɛɛ kó tinɑɑ̀mùntì kɔbɛ bɛɛ̀ do kɑri mɛtɑummɛ̀ tou fɔ̃nkúò diyiè tɑɑ̀ kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Dɑyɛɛdi birɛ Ediɑsɑfu weè do tú bɛ kó tɛcĩ́ɛ̃̀tɛ̀ kóo kótì. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Kɛrisonniibɛ kó mutɔ̃mmú do tú bɛ̀ bo ndɑkɛmɛ̀ mɛtɑummɛ̀ tou kpɛ́í nnɛ̀ kuyɑ̀ɑ̀kù kùù dì dɑ̀ɑ́tí nɛ̀ kùù kpetí dibòrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","Nɛ̀ tìì fitɛ́ kudɑ̀nkù nɛ̀ kùù kpetí ditowɑɑ̀ kó dibòrì nɛ̀ dɛ kó iwɛ̃ĩ bɛ̀ ɔ̃ɔ̃ pítínnɛ́ ì dɛ kó tiyɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Keɑti kó tinɑɑ̀mùntì do tú: Amudɑɑbɛ nɛ̀ Isɑɑbɛ nɛ̀ Ebunɔɔbɛ nɛ̀ Usiyɛɛdibɛ bɛ kó tinɑɑ̀mùntì nti mɛmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ́túótɛ́ initidɑbí ìì mɔ̀kɛ otɑ̃̀nkù òmɑ́ɑ̀ kɛ́ndeètìnko kɛ̀ bɛ̀ ḿbo sikɔupísìni nɛ̀ sikɔusìkuɔ̀ (8600) bɛɛ̀ do pĩ́ mmɛtɑummɛ̀ tou kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Keɑtiibɛ kó tinɑɑ̀mùntì kɔbɛ bɛɛ̀ do kɑri mɛtɑummɛ̀ tou bɑkù cɑ̃̀nku bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Usiyɛɛdi birɛ Edisɑfɑ̃ɑ̃ weè do tú bɛ cĩ́ɛ̃̀tɛ̀ kóo kótì. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Bɛɛ̀ do te bɛ̀ bo ndɑkɛmɛ̀ mɛtɑummɛ̀ tɔu kpɛ́í nnɛ̀ tɑ́bùrì nɛ̀ tɛfitíkɛ̀kɛ̀tɛ̀ nɛ̀ yɛwũɔ̃tɔ̀rɛ̀ nɛ̀ tinɛntì tɛtì bɛ̀ pĩĩnnɛ̀ tì ikuɔ́ tɔ̃mmú nɛ̀ kuyɑ̀ɑ̀kù dɛ miɛkɛ kɔku nɛ̀ iwɛ̃ĩ ìì kù pìítínɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Bɛɛ̀ do pĩ́ mmɛtɑummɛ̀ tou miɛkɛ mutɔ̃mmú kɛ̀ bɛ kóo kótì tu ikuɔ́ nìùtì Anɔɔ birɛ Edeɑsɑɑ, kɛ̀ weè mbɛ̀ bɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mɛdɑdi kó tinɑɑ̀mùntì kɔbɛ do tú: Mɑdiibɛ nɛ̀ Musiibɛ. Mɛdɑdi kó tinɑɑ̀mùntì nti mɛmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Kɛ̀ bɛ̀ɛ kɑɑ nyinitidɑbí ìì mɔ̀kɛ otɑ̃̀nkù kɛ́ntɔ kɛ deètìnko kɛ̀ bɛ̀ mbo sikɔupísìkuɔ̀ nɛ̀ sikɔusìdɛ́ (6200). ");
INSERT INTO tbzsim_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Kɛ̀ Abiyɑi birɛ Sudiyɛɛdi weè ntú bɛ kó tɛcĩ́ɛ̃̀tɛ̀ kóo kótì, bɛɛ̀ do kɑri mɛtɑummɛ̀ tou bɑkù yoú. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Mɛdɑdi kó tinɑɑ̀mùntì kɔbɛ kó mutɔ̃mmú do tú bɛ̀ bo ndɑkɛmɛ̀ mɛtɑummɛ̀ tou kó tidɑbɛɛtì kpɛ́í nnɛ̀ ticɑ́dɔɔti nɛ̀ yɛsɑ̃ǹkɛ̀ nɛ̀ yɛ kó yɛtɛitiyɛ̀ nɛ̀ di kó tinɛntì tɛtì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","Bɛɛ̀ do dɑkɛnɛ̀ mɛtɑummɛ̀ tou kó kudɑ̀nkù kó yɛsɑ̃ǹkɛ̀ kpɛ́í nnɛ̀ yɛ kó yɛtɛitiyɛ̀ nɛ̀ dɛ kó ibɑɑkɛ́ nɛ̀ dɛ kó iwɛ̃ĩ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mɔyiisi nɛ̀ Anɔɔ nɛ̀ bɛ bí kɛ̀ bɛ̀ɛ kɑri mɛtɑummɛ̀ tou diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ dibòrì bo kɛ̀ɛ̀ bíɛ́kɛ̀, kɛ́mpĩ́ nyikuɔ́ tɔ̃mmú Isidɑyɛɛribɛ kpɛ́í. Kɛ̀ wèè í tú Defii botí kou kɛ dɛ̀ tɔ́ɔ́nko, bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Kɛ̀ bɛ̀ɛ kɑɑ nDefiibɛ kɛ́túótɛ́ initidɑbí ìì mɔ̀kɛ otɑ̃̀nkù kɛ́ndeètìnko, bɛmɔu kɛ̀ bɛ̀ ḿbo sikɔupípísìdɛ́ nɛ̀ sikɔupísìdɛ́ (22000). Mɔyiisi nɛ̀ Anɔɔ bɛɛ̀ do bɛ̀ kɑ̀ɑ kɛ́ntũ mbɛ nɑɑ̀mùntì dò ndòmmɛ̀, ti Yiɛ̀ nKuyie ndo bɛ̀ nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Kɑɑ nyIsidɑyɛɛribɛ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ tu Mpo bɛmɔu, kɛ́ketɛ́nɛ̀ ibí ìì mɔ̀kɛ otɑ̃̀nkù òmɑ́ɑ̀ kɛ́ndeètìnko, ɑ́ bɛ̀ kɑ̀ɑ nkɛ́wɑ̃ri bɛ yètɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Kɑ̀ɑ dèè, ɑ́ túótɛ́ Defiibɛ kɛ́ bɛ̀ nni nduɔ́, Isidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo bɛ kó difɔ̃̀tìrì kɛ̀ bɛ̀ ntú n kɔbɛ, kɛ́túótɛ́ bɛ wũɔ̃ kɛ́ceetɛnɛ̀ Isidɑyɛɛribɛ kó iwũɔ̃ piɛ́ ìì bí ketiyì kɛ̀ ì tu idɑɑì. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Kɛ̀ Mɔyiisii kɑɑ nyIsidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Kɛ̀ bɛ̀ɛ kɑɑ nkɛ́wɑ̃ri bɛ yètɛ̀ kɛ́túótɛ́ ibí ìì mɔ̀kɛ otɑ̃̀nkù kɛ́ndeètìnko kɛ̀ bɛ̀ mbo sikɔupípísìdɛ́ nɛ̀ sikɔupísìdɛ́ nɛ̀ sikɔusìdɛ́ nɛ̀ sipísìyiekɛ̀ nɛ̀ bɛ̀tɑ̃ɑ̃ti (22273). ");
INSERT INTO tbzsim_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","Túótɛ́ Defiibɛ kɛ́cónnɛ́ Isidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo bɛ kó difɔ̃̀tìrì kɛ̀ nní mbɛ̀ te kɛ́túótɛ́ Defiibɛ kó iwũɔ̃ piɛ́ ìì bí ketiyì kɛ̀ ì tu idɑɑì kɛ́ceetɛnɛ̀ Isidɑyɛɛribɛ kpɛyi Defiibɛ, míì yó mbɛ̀ te, mí mbɛ Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Isidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo bɛ̀ɛ̀ nɔ̀ńkɛ́ Defiibɛ ĩ́nkɛ̀ sikɔusìdɛ́ nɛ̀ sipísìyiekɛ̀ nɛ̀ bɛ̀tɑ̃ɑ̃ti (273). ");
INSERT INTO tbzsim_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","A cɔutɛ́ bɑ́ wè yuu ĩ́nkɛ̀ mɛdítíbii mmɛ̀nùmmù ìì kèétɛ́ mɛtɑummɛ̀ tou kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Kɑ̀ɑ duɔ́ ndɛ kó idíítí Anɔɔ nɛ̀ o bí, kɛ̀ bɛ̀ɛ do mbɛ̀ɛ̀ tu Mpo bɛ̀ɛ̀ nɔ̀ńkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Kɛ̀ Mɔyiisi cuɔ́ dɛ kó idíítí kɛ̀ bɛ̀ bo donnɛ̀ Isidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo bɛ̀ɛ̀ nɔ̀ńkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Kɛ̀ bɛ̀ɛ ì cuɔ́ kɛ̀ ì ḿbo mɛdítíbii ntɛkɔupíítɛ̀ nɛ̀ sikɔusìtɑ̃ɑ̃ti nɛ̀ sipísìkuɔ̀ nɛ̀ mɛ̀nùmmù (1365) bɛ̀ do kèétɛ́ ìì díítí nyi mɛtɑummɛ̀ tou kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Kòo ì duɔ́ nhAnɔɔ nɛ̀ o bí ti Yiɛ̀ nKuyie ndo tì nhò nɑ̀kɛ́ wenwe Mɔyiisi kɛ nyɛ̃ bɛ̀ɛ dɔɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","Kɑɑnnɛ̀ Defiibɛ nɑɑ̀mùntì miɛkɛ Keɑti kó ibí bɛ nɑɑ̀mùntì dòmmɛ̀ nɛ̀ bɛ cɛ̃́ĩ, ");
INSERT INTO tbzsim_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","kɛ́ketɛ́nɛ̀ bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìtɑ̃ɑ̃ti kɛ́ntɔ kɛ́tuɔkɛnɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìnùmmù kɛ dò nkɛ́nɑ kɛ́pĩ́ mɛtɑummɛ̀ tou kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Keɑti nɑɑ̀mùntì kɔbɛ kó mutɔ̃mmú yó ntú bɛ̀ bo ndɑkɛmɛ̀ ikuɔ́ nɛntì kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Kɛ̀ dɛ̀ níí tùɔ̀kɛ di bo ítɛ́mɛ̀ di bɑ̀tɛ́ dɛ̀ kɛ́sɔɔ́, Anɔɔ nɛ̀ o bí bɛ̀ɛ kɔtɛní kɛ́núntɛ́ kuyɑ̀ɑ̀kù kùù pi ikuɔ́ nɛntì kó kufɑ̃́ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Bɛ̀ɛ kù pɔ̃ṹ mmɛtɑummɛ̀ tɔu. Kɛ̀ bɛ̀ dèè bɛ̀ɛ di dɑ́tínnɛ́ kukɔ̃̀nkperíkù kɛ́nɔ́ɔ́ nkuyɑ̀ɑ̀kù kùù wũ̀ɔ̃ tibedɛncɛ̃ɛ̃̀tì kɛ́ dì tɔ̃nnɛ́ ipɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Kɛ̀ bɛ̀ dèè bɛ̀ɛ dɑ́tínnɛ́ kuyɑ̀ɑ̀kù kùù do wũ̀ɔ̃ tibedɛncɛ̃ɛ̃̀tì tɑ́bùrì bɛ̀ dɑkù dɛ̀ pɛ̃́ɛ̃̀bɛ̀ bɛ̀ m pɑ̃ɑ̃ mbɛ̀ mí ndi Yiɛ̀ nKuyie, kɛ́cɔ̃nnɛ́ yɛbɔ nɛ̀ ibòòkɛ nɛ̀ yɛbɔ yɛ̀ɛ̀ yĩɛ̃̀nnɛ̀ mɛniɛ nnɛ̀ yɛdíè nyikuɔ́ kó mɛnɑɑ̀ nhɔ̃ nhɑ̃ yɛ̀ɛ̀ miɛkɛ, bɛ̀ yó ndɛ ndɑkù pɛ̃́ɛ̃̀bɛ̀ bɛ̀ yó nni mpɑ̃ɑ̃ mbɛ̀ sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Bɛ̀ɛ dɑ́tínnɛ́ dɛ ĩ́nkɛ̀ kuyɑ̀ɑ̀kù kùù wũ̀ɔ̃ tibedɛncɛ̃ɛ̃̀tì kɛ́nɔ́ɔ́ nkukɔ̃̀nkperíkù kɛ́tɔ̃nnɛ́ tɑ́bùrì kó ipɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Kɛ̀ bɛ̀ dèè bɛ̀ɛ dɑ́tínnɛ́ tɛfitíkɛ̀kɛ̀tɛ̀ kuyɑ̀ɑ̀kù kùù wũ̀ɔ̃ tibedɛncɛ̃ɛ̃̀tì nɛ̀ yɛfitibɔ nɛ̀ dɛ kó siseú nɛ̀ dɛ̀ɛ̀ kounɛ̀ mutɑ́pɛí nnɛ̀ mɛkùɔ̀ ncũɔ̃̀ sìì bukúsí miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Kɛ̀ bɛ̀ɛ dɛ̀ wɛ̃nnɛ́ kɛ́pɔ̃ṹ nkukɔ̃̀nkperíkù, kɛ́dɑɑ́ nkudɑbɛkù ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","kɛ́dɑ́tínnɛ́ disɔɔwũɔ̃tɔ̀nnì kuyɑ̀ɑ̀kù kùù wũ̀ɔ̃ tibedɛncɛ̃ɛ̃̀tì kɛ nɔ́ɔ́ nkukɔ̃̀nkperíkù kɛ́tɔ̃nnɛ́ ipɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Kɛ̀ bɛ̀ dèè bɛ̀ɛ túótɛ́ bɛ̀ pĩ̀ńnɛ̀ tìì nɛntì ikuɔ́ tɔ̃mmú kɛ́pɔ̃ṹ nkuyɑ̀ɑ̀kù kùù wũ̀ɔ̃ tibedɛncɛ̃ɛ̃̀tì nkɛ́nɔ́ɔ́ nkukɔ̃̀nkperíkù kɛ́ dɛ̀ wɛ̃nnɛ́ kɛ́dɑɑ́ nkudɑbɛkù ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Kɛ̀ bɛ̀ koutɛ́ diwũɔ̃tɔ̀nnì kó mutɑ́pɛí nkɛ dèè bɛ̀ɛ dì dɑ̀tínnɛ́ kuyɑɑ̀wũɔ̃kù, ");
INSERT INTO tbzsim_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","bɛ̀ yóó dɛ ndɑɑ́ nyikuɔ́ nɛntì timɔu bɛ̀ tùɔ̀nnɛ̀ tì tihúúntì nɛ̀ simɑ́tìkũmpeé yɛnìì nkpɛsi nɛ̀ tikɑ̃penti nɛ̀ ibòòkɛ bɛ̀ mɛ̀ínɛ̀ ì mɛyĩ̀ĩ̀, diwũɔ̃tɔ̀nnì kó tinɛntì timɔu cɛ̃́nkɛ, kɛ́ dɛ̀ dɑ̀tínnɛ́ kukɔ̃̀nkperíkù kɛ́tɔ̃nnɛ́ ipɑ̀ɑ̀ti kɛ bo ndi tòúnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ pɔ̃ṹ ndìì mɔ̀nnì ikuɔ́ nɛntì kɛ dèè. Kɛ̀ dɛ̀ tùɔ̀kɛ di bo ítɛ́ dɛ̀ kɛ́sɔɔ́, Keɑti kó ibí kɔtɛní kɛ́ dɛ̀ tɔ, bɛ̀ nɛ́ bɑ́ɑ́ yie nkɛ̀ bɛ nɔ̀ùtɛ̀ɛ kɑ́ɑ́kɛ́ ikuɔ́ nɛntì, kɛ̀ bɛ̀ tì kɑ̀ɑ́kɛ́ bɛ̀ yóó kúmu. Bɛ kó mutɔ̃mmú tú bɛ̀ bo ntɔumɛ̀ ikuɔ́ nɛntì. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Kɛ̀ ikuɔ́ nìùtì Anɔɔ birɛ Edeɑsɑɑ yie kó mutɔ̃mmú yó ntú ò bo ndɑkɛmɛ̀ mmɛ tɛfitíkɛ̀kɛ̀tɛ̀ kó mɛkùɔ̀ nkpɛ́í nɛ̀ tihúúntì kufɔ̃ɔ̃ku kpɛti. Nɛ̀ tidiitì bɛ̀ m pɑ̃ɑ̃ ntì yɛwe yɛmɔu nɛ̀ mɛkùɔ̀ mbɛ̀ ɔ̃ɔ̃ cóú mmɛ̀ onìtì yoo dɛ̀mɑrɛ̀ kɛ́ dɛ̀ cɑ̃̀ńnɛ́ n tɔ̃mmú kpɛ́í. Weè yó ndɑkɛ mɛtɑummɛ̀ tou dimɔu kpɛ́í nnɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo di miɛkɛ nɛ̀ ikuɔ́ nɛntì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","Dí ndɑkɛ kɛ̀ Keɑti nɑɑ̀mùnkù kɔbɛ bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Ntɛnɛ̀ di bo yĩ́mɛ̀ kɛ̀ dɛ̀ɛ yie nkɛ̀ bɛ̀ bɑ́ɑ́ kɑ́ɑ́kɛ́ ikuɔ́ nɛntì tìì bo kufɑ̃́ɑ̃́ mmiɛkɛ kɛ́kú. Anɔɔ nɛ̀ o bí bɛɛ̀ yóó bɛ̀ bɛnkɛ bɑ́ wè o tɔ̃mmú nɛ̀ ò yó ntɔu tìì nɛntì. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Di bɑ́ɑ́ yie nkɛ̀ bɛ̀ɛ yɑ̀ ikuɔ́ nɛntì tìì bo kufɑ̃́ɑ̃́, kɛ̀ bɛ̀ tì yɑ̀ bɑ́ sɑ́m̀pɔ́ bɛ̀ kumu. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","Kɑɑ nKɛrisonni kɔbɛ bɛ nɑɑ̀mùntì dò ndòmmɛ̀ nɛ̀ bɛ cɛ̃́ĩ. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Á kɑɑ mbɛnitidɑɑbɛ̀ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ mɔ̀kɛ yɛbie nsipísìtɑ̃ɑ̃ti kɛ́ntɔ kɛ́tuɔkɛnɛ̀ sipísìnùmmù kɛ dò nkɛ́nɑ kɛ́pĩ́ mmɛtɑummɛ̀ tou kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Ntɛ Kerisonni nɑɑ̀mùntì kɔbɛ kó mutɔ̃mmú yó ntú mù nɛ̀ bɛ̀ yó ntɔu dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Bɛ̀ yó ntɔu mɛtɑummɛ̀ tou kó tiyɑ̀ɑ̀tì nti, kuyɑ̀ɑ̀kù kùù ɔ̃ɔ̃ di dɑ̀tínnɛ́ nɛ̀ dɛ kó kukɔ̃̀nkù nɛ̀ kuyɑ̀ɑ̀kù kùù ɔ̃ɔ̃ kpetínnɛ́ mɛtɑummɛ̀ tou kó dibòrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","Nɛ̀ kuyɑ̀ɑ̀kù kùù fitɛ́ mɛtɑummɛ̀ tou nɛ̀ diwũɔ̃tɔ̀nnì nɛ̀ kùù kpetí dɛ kó kudɑ̀nkù kó dibòrì nɛ̀ iwɛ̃ĩ bɛ̀ ɔ̃ɔ̃ núnnɛ́ ì kuyɑ̀ɑ̀kù nɛ̀ ikuɔ́ nɛntì timɔu tìì pĩĩnnɛ̀ ikuɔ́ tɔ̃mmú. Bɛɛ̀ yó nte dɛ kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","28","Anɔɔ nɛ̀ o bí bɛɛ̀ yó mbɛnkú Kerisonni nɑɑ̀mùntì kɔbɛ bɛ kó mutɔ̃mmú nɛ̀ bɛ̀ yó ntɔu tìì nɛntì, kɛ̀ Itɑmɑɑ ikuɔ́ nìùtì Anɔɔ birɛ mbɛ̀ ni. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: Kɑɑ Mɛdɑdi kɔbɛ bɛ nɑɑ̀mùntì nɛ̀ bɛ cɛ̃́ĩ dò ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Á kɑɑ̀ mbɛnitidɑɑbɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìtɑ̃ɑ̃ti kɛ́ntɔ kɛ́tuɔkɛnɛ̀ yɛbie nsipísìnùmmù kɛ dò nkɛ́nɑ kɛ́pĩ́ mɛtɑummɛ̀ tou kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Ntɛ bɛ kó mutɔ̃mmú yó ntú mù: Bɛɛ̀ yó nte bɛ̀ bo ntɔumɛ̀ mɛtɑummɛ̀ tou kó tidɑbɛɛtì nɛ̀ di kó ipɑ̀ɑ̀ti nɛ̀ di kó yɛsɑ̃ǹkɛ̀ nɛ̀ yɛ kó yɛtɛitiyɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","yɛsɑ̃ǹkɛ̀ yɛ̀ɛ̀ fitɛ́ mɛtɑummɛ̀ tou kó kudɑ̀nkù nɛ̀ yɛ kó yɛtɛitiyɛ̀ nɛ̀ dɛ kó ibɑɑkɛ́ nɛ̀ dɛ kó iwɛ̃ĩ nɛ̀ dɛ kó tinɛntì timɔu. Dí bɛnkɛ bɑ́ wè ò dò nkɛ́ntɔu tìì nɛntì. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Mɛdɑdi nɑɑ̀mùntì kɔbɛ kó mutɔ̃mmú mmu bɛ̀ yó mpĩ́ mmù mɛtɑummɛ̀ tou miɛkɛ. Itɑmɑɑ ikuɔ́ nìùtì Anɔɔ birɛ, weè yó mbɛ̀ ni dɛ kó mutɔ̃mmú miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","49","Mɔyiisi nɛ̀ Anɔɔ nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ̀ bɛ̀ɛ kɑɑ nDefiibɛ bɛ nɑɑ̀mùntì nɛ̀ bɛ cɛ̃́ĩ dò ndòmmɛ̀. Keɑti nɑɑ̀mùntì kɔbɛ nɛ̀ Kɛrisonni nɑɑ̀mùntì kɔbɛ nɛ̀ Mɛdɑdi nɑɑ̀mùntì kɔbɛ, kɛ́ketɛ́nɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìtɑ̃ɑ̃ti kɛ́ntɔ kɛ́tuɔkɛnɛ̀ yɛbie nsipísìnùmmù kɛ dò nkɛ́pĩ́ mmɛtɑummɛ̀ tou kó mutɔ̃mmú. Kuyie ndo nɑ̀kɛ́ Mɔyiisi nwe kòo duɔ́ nkɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo: Keɑti nɑɑ̀mùntì kɔbɛ sikɔupísìdɛ́ nɛ̀ sikɔusìyiekɛ̀ nɛ̀ sipísìnùmmù (2750). Kɛrisonni nɑɑ̀mùntì kɔbɛ sikɔupísìdɛ́ nɛ̀ sikɔusìkuɔ̀ nɛ̀ sipísìtɑ̃ɑ̃ti (2630). Mɛdɑdi nɑɑ̀mùntì kɔbɛ sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìdɛ́ (3200). Bɛmɔu kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ kɛ́mbo sikɔupísìni nɛ̀ sikɔusìnùmmù nɛ̀ sipísìni (8580). Kɛ̀ bɛ̀ɛ bɛ̀ nɑ̀kɛ́ bɛ̀ dò nkɛ́pĩ́ mmùù tɔ̃mmú nɛ̀ tinɛntì bɛ̀ dò nkɛ́ntɔu tì, ti Yiɛ̀ nKuyie ndo ti nɑ̀kɛ́ Mɔyiisi kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú kɛ̀ tikɔ̀ntì pĩ nhòmɔù yoo ò tùɔ̀ti yɛfɔtɛ̀ yoo ò kɑ̀ɑ́kɛ́ ocíì. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Kòo nitidɔ̀ù nwe yoo onitipòkù dí ò bɛ̀ti kóò dènnɛ di kó dikɑrì. Kɛ̀ dɛ̀ɛ yie ndíndi Isidɑyɛɛribɛ kɛ̀ di bɑ́ɑ́ sĩnkùnnɛ di kó dikɑrì, m borɛ̀ di cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Kɛ̀ Isidɑyɛɛribɛɛ dɔɔ̀ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ tì Mɔyiisi bɛ kpɛ́í kòò tì mbɛ̀ nɑ̀kɛ́, kɛ́mbɛtì bɛ kó dikɑrì bɛ̀ɛ̀ kó dimɑ̀ɑ̀ sĩ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú: Kòò mɔù cɑ̀ɑ̀rɛ̀ o kou tɔù kpɛrɛ yoo ò dɔ̀ɔ̀ mɛyɛi mmɑmɛ̀, ò cɑ̀ɑ̀rɛ̀ mí ndi Yiɛ̀ nKuyie mmí nwe. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Wèe dɑ́ɑ ndɛ kó mɛyɛi nhò dɔ̀ɔ̀ mɛ̀ kɛ́tɛ̃́nnɛ́ ò cɑ̀ɑ̀rɛ̀ dɛ̀ dɛ yiɛ̀, kɛ́nɔ́ɔ́ nkɛ̀ dɛ̀ mmɑnɛ̀ ò cɑ̀ɑ̀rɛ̀ dɛ kó mɛtotímɛ̀ yɛwɛ́tiyɛ̀ yɛ̀nùmmù kó dìmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Kɛ̀ bɛ̀ cɑ̀ɑ̀rɛ̀ wè mɛ nkumu kɛ í mɔkɛ o cɛ̃dɛ́tɛ̀ kou, bɛ̀ nɑ nhò yietí dɛ̀, bɛ̀ɛ dɛ̀ duɔ́ mmí ndi Yiɛ̀ nKuyie nkɛ̀ ikuɔ́ nìùtìi dɛ̀ tùótɛ́, kɛ nɛ́ mbúútí dipedɑɑ̀ mɛyɛi nhũtímù kpɛri, ò yóó dɔɔ̀nɛ̀ dì mɛwénkùmɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Kɛ̀ Isidɑyɛɛribɛ níí dɛ̀itɛ dɛ̀mɑrɛ̀ dɛ̀ɛ̀ tu n kpɛrɛ dɛ miɛkɛ kɛ duɔ́ nyikuɔ́ nìùtì o kpɛrɛ ndɛ, n yɛ̃ ndi mbɛ̀ duɔ̀ ndɛ̀ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kɛ̀ bɛ̀ cɑ̃̀ńnɛ́ dɛ̀ n kpɛ́í bɛ̀ɛ dɛ̀ duɔ́ nyikuɔ́ nìùtì, kɛ̀ bɛ̀ duɔ́ ndɛ̀ ikuɔ́ nìùtì o kpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Kɛ̀ ti Yiɛ̀ nKuyie m bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀: Kòo mɔù kóo pokù dɔuti dɔutinɛ̀ bɛnitidɑɑbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","kɛ duɔ́nɛ̀ onitidɔ̀ù mɔù kòo dɔù í bɛ̀ sɔ̃̀ńkɛ́, kòò sɑ̃ũ nhomɑ́ɑ̀ bɑ́ òmɔù í ò yɑ̀, bɛ̀ mɛ nyí ò sɔ̃̀ńkɛ́ bɛ̀ duɔ́ dɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","yoo kòo dɔù yɛ̀mmɛ̀ mɛɛ̀ mɛ yetɛ kòò ò wɑ́tìrì dɛtetìrɛ̀, yoo ò mɛ̀nkɛ dɛ̀ dɔ̀ɔ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Kɛ̀ dɛ̀ tùɔ̀kɛní kɛ dò mmɛ botí dɛ yiɛ̀ nkɔtɛnɛ̀ o pokù ikuɔ́ nìùtì borɛ̀, kɛ́ntɔnɛ̀ muyuo ncìdóòbɛ̀ bɛ̀tɑ̃ɑ̃ti, ò bɑ́ɑ́ mù yɔɔrɛ mɛkùɔ̀ nyoo tihúúntì, kɛ yɛ̃́ dɛ̀ tumɛ̀ mɛpútímɛ̀ kó mɛdɔɔ̀rìmɛ̀ mmɛ, mɛɛ̀ yóó bɛnkɛ bɛ̀ wɑ́tìrì wè dɔ̀ɔ̀mɛ̀ mɛyɛi nyoo ò í mɛ̀ dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Ikuɔ́ nìùtìi kɔtɛnɛ̀ dɛ kóo nitipòkù mí ndi Yiɛ̀ nKuyie ncĩ́ɛ̃̀tɛ̀ kóò còńnɛ́ n yììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Kɛ̀ ikuɔ́ nìùtìi yɑutɛ́ ikuɔ́ kó mɛniɛ ndibuu miɛkɛ kɛ́yɛ̃tɛ́ n cĩ́ɛ̃̀tɛ̀ kó mutɑ̃́ɑ̃́ nkɛ́ɑ̃nnɛ́ dɛ miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","kɛ́cónnɛ́ onitipòkù n yììkɛ̀ kɛ́dɑ́tɛ́ o yuu kuyɑ̀ɑ̀kù, kɛ́duɔ́ nkòo ceé nho nɔu, kòo ɑ̃nnɛ́ mɛpútímɛ̀ kó muyuo nhò dɔù wɑɑnní mù kɛ bo ò yɑ̀ɑ́kɛ́nɛ̀, kɛ̀ ikuɔ́ nìùtì mɔ́mmuɔ nní ntɔ mɛnɛ́tiimɛ mɛ̀ɛ̀ tɔuní mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Dɛ mɔ̀nnì kɛ̀ ikuɔ́ nìùtìi bɛ́i nhonitipòkù ììkɛ̀ kɛ dɔ̀: Kɛ̀ nsɑ̀ kɑ̀ɑ í duɔ́nɛ̀ onitidɔ̀ù tɔù, kòò mɔù í dɑ yùúkú kɛ duɔ́nɛ̀ kɛ dɑ sɑ̃ũ, mɛnɛ́tiimɛ miɛ̀ mmɛ̀ɛ̀ tɔ kusĩ̀nkù mɛ̀ bɑ́ɑ́ dɑ tɔní mɛyɛi mmɑmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Kɑ̀ɑ mɛ nduɔ́nɛ̀mu onitidɔ̀ù tɔù, kɛ soú nkɛ̀ dɛ̀ tu mɔ́mmuɔ nwe onitidɔ̀ù tɔù dɑ duɔ́nɛ̀mɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ti Yiɛ̀ nKuyie ndɑ cɔ̃ɔ̃ kɑ̀ɑ nitipòtìi kṹṹ kɑ̀ɑ nɑɑ́ ntɛhɑ̃ũntɛ, kɛ́suɔ nkɛ́nɑɑ́ ndibɛnkɛ̀rì, kɑ̀ɑ botí kɔbɛ níí nnɑ́ɑ́ nhɑ kpɛ́í mbɛ̀ dɔ́ dìì mɔ̀nnì kɛ́pɑrìkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Kɛ̀ mɛniɛ mmiɛ̀ ntɑ ɑ pɔutì ɑ nitipòtìi kṹṹ kɑ̀ɑ suɔ. Kòo nitipòkùu cɔ́útɛ́ kɛ dɔ̀: Dɛ̀ mmɛ ndò. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Kɛ̀ ikuɔ́ nìùtìi wɑ̃ri yɛtɑnnɔ̀ yɛiyɛ ò bɛ́i nyɛ̀ kɛ́ yɛ̀ ɔ̀útɛ́nɛ̀ mɛnɛ́tiimɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","kɛ bo nii nhonitipòkù dɛ kó mɛnɛ́tiimɛ mɛmmɛ mɛ̀ɛ̀ tɔuní mɛyɛi nkòo yɑ̃̀ dɛ kó mɛnɛ́tiimɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Kɛ̀ ikuɔ́ nìùtìi cɔutɛ́ muyuo mɛpútímɛ̀ kɔ̃mu kɛ́ mù bɛnkɛ ti Yiɛ̀ nKuyie kɛ́ mù kɔ̀tɛnɛ̀ diwũɔ̃tɔ̀nnì borɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","kɛ́fɔ́ɔ́tɛ́ dɛ kó muyuo nkɛ̀ mù ndò ndibɛnkɛ̀rì kòo mù tùɔ ndiwũɔ̃tɔ̀nnì ĩ́nkɛ̀ kɛ nɛ́ nɑ kɛ́nii ndɛ kó mɛniɛ nhonitipòkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Kòò mɛ̀ yɑ̃̀ kɛ sɔ̃́ nhò mɛ̀nkɛ duɔ́nɛ̀mu onitidɔ̀ù tɔù kɛ soú, kɛ̀ dɛ kó mɛnɛ́tiimɛ mɛ̀ɛ̀ tɔ kusĩ̀nkù tɑ o pɔutì mɛ̀ bo nte kòo nitipòtìi kṹṹ, kòo nɑɑ́ ntɛhɑ̃ũntɛ, kɛ́suɔ nkɛ́nɑɑ́ ndibɛnkɛ̀rì kòo botí kɔbɛ níí bɛ́i nho kpɛ́í bɛ̀ dɔ́ dìì mɔ̀nnì kɛ́pɑrìkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Kɛ̀ dɛ̀ mɛ nsɔ̃́ nhò í duɔ́nɛ̀ onitidɔ̀ù tɔù kɛ dò mpɑ́í pɑ́í kɛ̀ dɛ̀ sɔ̃́ nhò í sɑ̃ũ omɑ́ɑ̀ mɛyɛi mmɑmɛ̀ bɑ́ɑ́ ò tùɔ̀kɛní kòò nsɔkɛ́ kɛ pɛí ibí. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Dɛ kó ikuɔ́ tú mɛpútímɛ̀ kpɛyi nyi, kɛ tukúnɛ̀ onitipòkù wèè bo nye nkòo nitidɔ̀ù tɔùu ò duɔ́nɛ̀ kóò sĩ̀nkùnnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","Kɛ̀ dɛ̀ mɛ ndò nhonitipòkù í dɔ̀ɔ̀ dɛ̀mɑrɛ̀ kòo dɔù yóù mɛ̀ɛ̀ kpɛ́í nho ĩ́nkɛ̀ kɛ̀ dɛɛ̀ te, kòò ò kɔ̀tɛnɛ̀ ikuɔ́ nìùtì borɛ̀ kɛ̀ ikuɔ́ nìùtì ò dɔ̀ɔ̀ dɛ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Bɛ̀ í yóó sɛi nhonitidɔ̀ù ò wɑ̀tí mɛ̀ɛ̀ kpɛ́í nho pokù, kòo nitipòkù mɛ mmɛ̀nkɛ mɛ dɔ̀ɔ̀mu weè yóó tɔ dɛ kó mucɔ̃́ntimu. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkòo nitidɔ̀ù yoo onitipòkù n cɑ̀nnɛnɛ̀ dinùù kɛ bo soó ntiyùtì kɛ̀ dɛ̀ɛ bɛnkɛ ò n cɑ̀nnɛmɛ̀ dinùù. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","Ò bɑ́ nyɔ̃̀ mmɛnɑɑ̀ mbɛ̀ tumɛ̀ difɛ̃́ɛ̃̀ nɛ̀ mɛtɛ̃mɛ̀ mɛ̀ɛ̀ muɔ̀, ò bɑ́ nyɔ̃ mmɛnɑcɛ́duo, kɛ̀ bɛ̀ nìú fínyĩ̀ kó yɛbɛ ò bɑ́ɑ́ yɑ̃̀ dɛ kó dinɑɑbɛ́nnì, ò mɛ mbɑ́ɑ́ cɑ́ɑ́kɛ́ fínyĩ̀ kó yɛbɛ sũ̀ũ̀yɛ̀ yoo yɛkperɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Dɛ kó yɛwe wè n cɑ̀nnɛnɛ̀ yɛ̀ dinùù yɛ miɛkɛ, ò bɑ́ɑ́ di fínyĩ̀ kpɛrɛ mɑrɛ̀, yɛtebɛ kó tiwɛ́ɛ́tì yoo yɛ kó mɛbii. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Dɛ kó yɛwe ò n cɑ̀nnɛnɛ̀ yɛ̀ dinùù yɛ miɛkɛ kuponkù bɑ́ɑ́ kɑ́ɑ́kɛ́ o yuu yoo o dɛɛ̀nfɛ̀ kɛ̀ dɛ kó yɛwe ò n cɑ̀nnɛnɛ̀ yɛ̀ dinùù yɑ̀ɑ deènɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Dɛ kó yɛwe ò n cɑ̀nnɛnɛ̀ yɛ̀ dinùù yɛ miɛkɛ ò bɑ́ɑ́ tɔ́ɔ́nnɛ̀ ocíì. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Kòo cicɛ nwe yoo o yɔ̃ yoo o kóo kótì yoo o nɑntɛ̀ yoo o tɑ̃ũ̀ ò bɑ́ɑ́ ò tɔ̀ɔ́nnɛ̀, kɛ́sĩnkùnnɛ omɑ́ɑ̀. Ò cɑ̃̀ɑ̃́mmu n kó mutɔ̃mmú kpɛ́í kɛ sokɛ́ tiyùtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Ò sokɛ́ yɛ̀ɛ̀ we tiyùtì yɛ miɛkɛ ò cɑ̃̀ɑ̃́mmu n kó mutɔ̃mmú kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Kɛ̀ dɛ̀ mɛ ndò nhòmɔù ku o tɑkɛ́ mɛtòntòmmɛ̀ kɛ sĩ̀nkùnnɛ o yùtì diyiè yiénnì yiè wèe kuó o yùtì kɛ́wénkùnnɛ omɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Diyiè niínnì yiè kɛ́wɑɑ́ nsinɔ́nkpeé sìdɛ́sì yoo yɛkpɛtìnɔ́nkperɛ kó yɛpɑ̀ɑ̀ nyɛ̀dɛ́ɛ̀ kɛ́ dɛ̀ duɔ́ nyikuɔ́ nìùtì mɛtɑummɛ̀ tou bòrì nùù. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Kɛ̀ ikuɔ́ nìùtìi féútɛ́ tɛ̀mɑ́ɑ̀ mɛyɛi n cĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́féútɛ́ tɛtɛtɛ̀ kɛ́tuɔ nkɛ́deè kóò dɔ̀ɔ̀ ikuɔ́ mɛwénkùmɛ̀ kpɛyi, kóò wénkùnnɛ ò tɔ̀ɔ́nnɛ́mɛ̀ ocíì kɛ sĩ̀ntɛ. Dɛ kó diyiè kòo wɛ̃tɛ kɛ́nɑɑ́ nwèè cɑ̃̀ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Kòo wɛ̃tɛ kɛ́cɑ̃́nnɛ́ omɑ́ɑ̀ mɛpɑ̀mmɛ̀ kɛ́soó ntiyùtì kɛ́wɑɑ́ ndipedɑbii dìì mɔ̀kɛ dibenni dìmɑ́ɑ̀ kɛ dì nni nféútɛ́ mɛyɛi nhũtímù kpɛ́í, yɛwe yɛ̀ɛ̀ pɛ̃ɛ̃tɛ́ yɛ̀ tɛ̃́nkɛ í kɑɑ̀ nkɛ yɛ̃́ ò sòò sĩ̀nkùnnɛmɛ̀ o yùtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Ntɛ wèè n cɑ̀nnɛnɛ̀ dinùù dɛ kó ikuɔ́ yó ndòmmɛ̀, kɛ̀ dɛ kó yɛwe dèè dìì mɔ̀nnì wèe kɔtɛ mɛtɑummɛ̀ tou, ");
INSERT INTO tbzsim_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","kɛ́ntɔnɛ̀ o wũɔ̃ ò yó n féútɛ́ ì dipedɑbii dìì mɔ̀kɛ dibenni dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù kɛ́ dì nni nféútɛ́ kɛ́tuɔ, nnɛ̀ dipesɛrì dìì mɔ̀kɛ dibenni dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù kɛ dì nni nféútɛ́ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í nnɛ̀ dipedɑɑ̀ dìì kpɑ kuyɛ̀nkù mɛtɑummɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","Muyuo nsɑ̀ɑ̀mù bɛ̀ ɑ̃̀ntɛnɛ̀ mù mɛkùɔ̀ nkó yɛkɑ̀tìndɑ̀ dɛmɔ́mbirɛ nɛ̀ muyuo mmùù í kɔɔrɛnɛ̀ mutie mùù muuti pɛ̃́ɛ̃̀ mu kó tipɛ̃́mpɛ̃ńtì kɛ́ tì wɑɑrɛ mɛkùɔ̀ nnɛ̀ muyuo, ò yó m pɑ̃ mù nɛ̀ mɛnɑɑ̀ mbɛ̀ ɔ̃ɔ̃ yɔɔrɛ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Kòo dɛ̀ tɔo dɛmɔu mɛtɑummɛ̀ tou borɛ̀, kɛ̀ ikuɔ́ nìùtìi dɛ̀ nni mbɛnkɛ kɛ́féútɛ́, mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó fɛɔ̃̀fɛ̀ nɛ̀ fɛ̀ɛ̀ yóó tuɔ nhò n cɑ̀nnɛnɛ̀ dìì nùù kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Kòò dèè ò n féútɛ́ dipedɑɑ̀ mɛtɑummɛ̀ kpɛ́í nkɛ́ n duɔ́ mmuyuo mmùù í kɔɔrɛnɛ̀ mutie mùù muuti mu kó yɛkɑ̀tìndɑ̀ dɛmɔ́mbirɛ, kɛ̀ ikuɔ́ nìùtì n duɔ́ ndɛ kó dipɑ̃nnì kɛ́ di yɔɔrɛ mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Kòò dèè, wèè n cɑ̀nnɛnɛ̀ dinùù wèe kuó o yùtì mɛtɑummɛ̀ tou bòrìnùù, kɛ́túótɛ́ o yùtì ò kuó tì kɛ́wɛ̃nnɛ́nɛ̀ mɛtɑummɛ̀ kó fɛɔ̃̀fɛ̀ kɛ́cɔ́u. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Kɛ̀ ikuɔ́ nìùtìi túótɛ́ dipedɑɑ̀ kó kubɑkù kùù bèńnɛ́ kɛ́dɛitɛ muyuo mmùù í kɔɔrɛnɛ̀ mutie mùù muuti mu kó dikɑ̀tìndɑ̀ɑ̀ dìmɑ́ɑ̀ dɛmɔ́mbirɛ miɛkɛ nɛ̀ mu kó kupɛ̃́mpɛ̃ńkù kùmɑ́ɑ̀, kɛ́ dɛ̀ duɔ́ nwèè n cɑ̀nnɛnɛ̀ dinùù ò kuó dìì mɔ̀nnì o yùtì kɛ dèè. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ikuɔ́ nìùtì mɔ́mmuɔ nwèè yóó dɛ̀ bɛnkɛ mí ndi Yiɛ̀ nKuyie nkɛ́dɔɔ̀ dɛ kó ikuɔ́, o kpɛrɛ ndɛ kɛ nɛ́ mbúútí dicĩ̀ncĩ̀nnì kó kumɑɑ ndi yòutɛ kù kɛ m bɛnkɛ nɛ̀ dikpèrì bɛ̀ cɑ̃̀ńnɛ́ dì. Dɛ mɔ̀nnì wèè n cɑ̀nnɛnɛ̀ dinùù ò bo nɑ kɛ́wɛ̃tɛ kɛ́yɑ̃̀ mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Wèè cɑ̀nnɛnɛ̀ mí ndi Yiɛ̀ nKuyie ndinùù o kó ikuɔ́ nyi mɛmmɛ nɛ̀ ò dò nkɛ́kuɔ ìì wũɔ̃ ò dɔ́ kɛ́kuó dìì yie, kòò mɔ̀kɛ yɛpɑ̃rɛ̀ kɛ bo yíɛ́, dɛ̀ í yetɛ, ò nɛ́ dò nkɛ́dɔɔ̀mu o korimù yiè ò n cɑ̀nnɛnɛ̀ dìì nùù kó ikuɔ́ bekɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","Nɑ́kɛ́ Anɔɔ nɛ̀ o bí kɛ tú n yɛ̃ mbɛ̀ níí pɑ̃ mɛsɑ̀ɑ̀ n kó bɛnìtìbɛ̀ Isidɑyɛɛribɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Ti Yiɛ̀ nKuyie ndi dɔɔ̀ mɛsɑ̀ɑ̀ nkɛ́ ndi kɑ̃nkɛ́! ");
INSERT INTO tbzsim_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ti Yiɛ̀ nKuyie ndi wéntɛ́ fɛnɔnsɑ̀ɑ̀fɛ̀ kɛ́ di pɑ̃ diwɛ̀ì! ");
INSERT INTO tbzsim_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ti Yiɛ̀ nKuyie nwéntɛ́ní di bíɛ́kɛ̀ kɛ dí duɔ́ ndiwɛ̀ì! ");
INSERT INTO tbzsim_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Bɛ̀ níí yóó mɛ nyú n yètìrì Isidɑyɛɛribɛ ĩ́nkɛ̀ kɛ̀ ḿ bɛ̀ dɔ̀ɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Mɔyiisi dèè dìì mɔ̀nnì mɛtɑummɛ̀ tou kó mudɔɔ̀rìmù kɛ́ dì còú mmɛkùɔ̀ nkɛ́ dì cɑ̃̀ńnɛ́ nɛ̀ di nɛntì timɔu nɛ̀ diwũɔ̃tɔ̀nnì nɛ̀ di kó tinɛntì timɔu. Ò dɛ̀ còú ndìì mɔ̀nnì mɛkùɔ̀ nkɛ dɛ̀ cɑ̃̀ńnɛ́ kɛ dèè, ");
INSERT INTO tbzsim_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","dɛ yiè kɛ̀ Isidɑyɛɛribɛ cɛ̃́ĩ kó bɛkótíbɛ̀ bɛ̀ɛ̀ bɑkɛ́ bɛ nɑɑ̀mùntì bɛ̀ɛ̀ do ni mukɑ̀mmù kó mutɔ̃mmú kɛ̀ bɛ̀ɛ pɑ̃mmú yɛpɑ̃rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Kɛ̀ bɛ̀ɛ tɔní bɛ pɑ̃rɛ̀ mɛtɑummɛ̀ tou ti Yiɛ̀ nKuyie nyììkɛ̀, sinɑɑsɛ̃ĩ́ sìkuɔ̀ kɛ sì dɑ̀ɑ́tí tiyɑ̀ɑ̀tì nɛ̀ inɑ̀ɑ̀kɛ tɛpíítɛ̀ nɛ̀ ìdɛ́ì, bɛkótíbɛ̀ bɛ̀dɛ́bɛ̀, tɛnɑɑsɑ̃ntɛ̀ tɛ̀mɑ́ɑ̀, bɑ́ wè fɛnɑ̀ɑ̀fɛ̀ fɛ̀mɑ́ɑ̀. Kɛ̀ bɛ̀ɛ dɛ̀ tɔní dɛmɔu mɛtɑummɛ̀ tou borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","Cɔutɛ́ dɛ bɛ borɛ̀, kɛ́ dɛ̀ duɔ́ mmɛtɑummɛ̀ tou mí ndi Yiɛ̀ nKuyie n tɔ̃mmú kpɛ́í. Á dɛ̀ duɔ́ nDefiibɛ bɑ́ wè o tɔ̃mmú dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Kɛ̀ Mɔyiisii túótɛ́ sinɑɑsɛ̃ĩ́ nɛ̀ inɑ̀ɑ̀kɛ kɛ́ dɛ̀ duɔ́ nDefiibɛ ");
INSERT INTO tbzsim_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","kɛ́duɔ́ nKɛrisonni nɑɑ̀mùntì kɔbɛ sinɑɑsɛ̃ĩ́ sìdɛ́sì nɛ̀ inɑ̀ɑ̀kɛ ìnɑ̀ɑ̀ kɛ́ntũ mbɛ tɔ̃mmú dòmmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","kɛ́duɔ́ mMɛdɑdi nɑɑ̀mùntì kɔbɛ sinɑɑsɛ̃ĩ́ sìnɑ̀ɑ̀ nɛ̀ inɑ̀ɑ̀kɛ ìni kɛ́ntũ mbɛ tɔ̃mmú dòmmɛ̀. Ikuɔ́ nìùtì Anɔɔ birɛ Itɑmɑɑ do bɛ̀ ni kɛ̀ bɛ̀ pĩ́ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Bɛ̀ í n duɔ́ nKeɑti kɔbɛ biɛ mùmɑmù kɛ yɛ̃́ bɛmbɛ do bukùmɛ̀mu ikuɔ́ nɛntì bɛ̀ do dò nkɛ́ntɔu tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Bɛ̀ do cɑ̃́nnìnko dìì yiè diwũɔ̃tɔ̀nnì Kuyie nkpɛ́í kɛ̀ Isidɑyɛɛribɛɛ pɑ̃mmú yɛpɑ̃rɛ̀ diwũɔ̃tɔ̀nnì kó mucɑ̃́nnímù kpɛ́í, kɛ́ yɛ̀ tɔní diwũɔ̃tɔ̀nnì borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Bɑ́ dìì yiè Isidɑyɛɛribɛ kó bɛkótíbɛ̀ miɛkɛ òmɑ́ɑ̀ níí tɔní yɛpɑ̃rɛ̀ kɛ̀ bɛ̀ɛ cɑ̃́nnɛ́nɛ̀ diwũɔ̃tɔ̀nnì Kuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Mɛm̀mɛ kɛ̀ bɛ̀ nkɔrìnní bɛmɑ bɛmɑ bɛ pɑ̃rɛ̀. Diyiè ketirì yiè Sudɑɑ nɑɑ̀mùnkù kou, Nɑsɔ̃ɔ̃ birɛ Amminɑdɑbu. Didɛ́rì yiè Isɑkɑɑ nɑɑ̀mùnkù kou Suɑɑ birɛ nNɛtɑnnɛyɛɛdi. Ditɑ̃ɑ̃́nnì yiè Sɑbunɔɔ nɑɑ̀mùnkù kou Edonni birɛ Ediɑbu. Dinɑɑnnì yiè Dubɛnni nɑɑ̀mùnkù kou Sedeuu birɛ Edisuu. Dinummurì yiè Simmɛɔ̃ɔ̃ nɑɑ̀mùnkù kou Sudisɑdɑii birɛ Sedumiɛri. Dikuɔ́nnì yiè Kɑdi nɑɑ̀mùnkù kou Deuyɛɛdi birɛ Ediɑsɑfu. Diyiénnì yiè Efɑdɑimmu nɑɑ̀mùnkù kou Ammiudi birɛ Edisɑmɑ. Diniínnì yiè Mɑnɑnsee nɑɑ̀mùnkù kou Pedɑsuu birɛ Kɑmmidiyɛɛri. Diyiè wɛínnì yiè Bɛnsɑmɛɛ nɑɑ̀mùnkù kou Kideoni birɛ Abidɑnni. Diyiè píínnì yiè Dɑnni nɑɑ̀mùnkù kou Amisɑdɑii birɛ Ayiesɛɛ. Diyiè tɛpíítɛ̀ nɛ̀ dìmɑ́ɑ̀ yiè Asɛɛ nɑɑ̀mùnkù kou Okɑdɑnni birɛ Pɑkiyɛɛdi. Diyiè tɛpíítɛ̀ nɛ̀ didɛ́rì yiè Nɛfutɑdii nɑɑ̀mùnkù kou Enɑnni birɛ Aidɑ. Ntɛ bɑ́ wè ò do tɔní yɛ̀ɛ̀ pɑ̃rɛ̀: Timɑ́tì pɛ́ítì kó kubuuku cɛ̃́ɛ̃́kù do bo cìdóò òmɑ́ɑ̀ nɛ̀ sɑ́m̀pɔ́rɛ̀ nɛ̀ timɑ́tì pɛ́ítì kó dibuu dìì yó mmɛ́ínɛ̀ mɛyĩ̀ĩ̀ kɛ̀ di cɛ̃́ɛ̃́kù mbo cìdóò kó dikéè nɛ̀ sɑ́m̀pɔ́ bɛ̀ do kèétɛ́ wèè cìdóò nwe ti Yiɛ̀ nKuyie ncĩ́ɛ̃̀tɛ̀ kpɛ́í. Kɛ̀ Muyuo nsɑ̀ɑ̀mù mùù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ nkɛ̀ mù pìɛ́kɛ́ dɛ kó yɛbɔ. Tidiitì kó dipɑ̃nnì ndi. Fɛsɔɔbòòfɛ̀ fɛ̀mɑ́ɑ̀ fɛ̀ɛ̀ cɛ̃́ɛ̃́kù bo kɑ̀dɑ́ɑ̀mmù tɛkɔ̀ùtɛ̀ kɛ̀ tihúúntì pìɛ́kɛ́ dɛ miɛkɛ bɛ̀ ɔ̃ɔ̃ tuɔ ntì. Dinɑɑdɑɑ̀ dìmɑ́ɑ̀ nɛ̀ dipedɑbii dìì mɔ̀kɛ dibenni dìmɑ́ɑ̀ bɛ̀ ɔ̃ɔ̃ kuɔ dì kɛ́tuɔ nnɛ̀ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛrɛ. Inɑ̀ɑ̀kɛ ìdɛ́ì, yɛpedɑkɛ̀ yɛ̀nùmmù, yɛbɔdɑkɛ̀ yɛ̀nùmmù nɛ̀ yɛpedɑbɛ yɛ̀nùmmù yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀, bɛ̀ ɔ̃ɔ̃ féútɛ́ yɛ̀ ti Yiɛ̀ nKuyie mmɛtɑummɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Isidɑyɛɛribɛ kó bɛkótíbɛ̀ do pɑ̃mmú yɛ̀ɛ̀ pɑ̃rɛ̀ kɛ bo cɑ̃́nnɛ́nɛ̀ diwũɔ̃tɔ̀nnì Kuyie nkpɛ́í, ntɛ yɛ̀ do wɛ̃nnɛ́ yɛmɔu kɛ́mbomɛ̀: Timɑ́tì pɛ́ítì kó tibuuti tɛpíítɛ̀ nɛ̀ tìdɛ́ nɛ̀ yɛbɔ tɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀ yɛ̀ɛ̀ yó mmɛ́ínɛ̀ mɛyĩ̀ĩ̀ nnɛ̀ isɔɔbòòkɛ tɛpíítɛ̀ nɛ̀ ìdɛ́ì. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Bɑ́ kùù buuku kó kucɛ̃́ɛ̃́kù do bo cìdóò òmɑ́ɑ̀ ndi nɛ̀ sɑ́m̀pɔ́, bɑ́ dìì buu kɛ̀ di kɔku ḿbo cìdóò òmɑ́ɑ̀ kó dikéè nɛ̀ sɑ́m̀pɔ́, timɑ́tì pɛ́ítì kó yɛbɔ yɛnyɛ kɛ̀ yɛ cɛ̃́ɛ̃́kùu wɛ̃nnɛ́ cìdóòbɛ̀ sipísìdɛ́ nɛ̀ bɛ̀nɑ̀ɑ̀. Bɛ̀ kèétɛ́ wèè cìdóò nwe ti Yiɛ̀ nKuyie ncĩ́ɛ̃̀tɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Bɑ́ fɛ̀ɛ̀ sɔɔbòòfɛ̀ kó kucɛ̃́ɛ̃́kù do bo kɑ̀dɑ́ɑ̀mmù tɛkɔ̀ùtɛ̀, kɛ̀ ì mbo tɛpíítɛ̀ nɛ̀ ìdɛ́ì, kɛ̀ dɛ cɛ̃́ɛ̃́kùu wɛ̃nnɛ́ cìdóò òmɑ́ɑ̀ nɛ̀ sɑ́m̀pɔ́, kɛ̀ tihúúntì bɛ̀ tùɔ̀ ntì pìɛ́kɛ́ i miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Kɛ nɛ́ mbúútí yɛnɑɑdɑkɛ̀ tɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑkɛ̀ tɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑbɛ tɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀. Bɛ̀ do yóó kuɔ yɛ̀ kɛ́tuɔ kɛ́wɛ̃nnɛ́nɛ̀ tidiitì kó yɛpɑ̃rɛ̀ nɛ̀ yɛbɔdɑkɛ̀ tɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀ bɛ̀ yóó kuɔ yɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Kɛ̀ dɛ̀ɛ wɛ̃nnɛ́ yɛnɑɑdɑkɛ̀ sipísìdɛ́ nɛ̀ yɛ̀nɑ̀ɑ̀, yɛpedɑkɛ̀ sipísìkuɔ̀, yɛbɔdɑkɛ̀ sipísìkuɔ̀ yɛpedɑbɛ sipísìkuɔ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀. Bɛ̀ yóó kuɔ yɛ̀ mɛtɑummɛ̀ kpɛ́í. Bɛ̀ do pɑ̃ yɛ̀ɛ̀ pɑ̃rɛ̀ nyɛ kɛ̀ bɛ̀ bo cɑ̃́nnɛ́ diwũɔ̃tɔ̀nnì Kuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Mɔyiisi tɑ dìì mɔ̀nnì mɛtɑummɛ̀ tou kɛ bo bɛ́innɛ̀ ti Yiɛ̀ nKuyie kɛ́keè ti Yiɛ̀ nKuyie ntɑmmɛ̀ mɛtɑummɛ̀ tɔu ĩ́nkɛ̀ bɛĩ́nkɛ̀mbɑ̀rìbɛ̀ kó sitenkɑɑnìi sìdɛ́sì cuokɛ̀ sìì còḿmú mɛtɑummɛ̀ tɔu ikuɔ́ nɛntì ɑ̃ dɛ kó kupòkù ĩ́nkɛ̀. Mɛm̀mɛ kòò nkù nɑ̀ɑ́nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","Nɑ́kɛ́ Anɔɔ kɛ tú, kòò yóó cónnɛ́ tɛfitíkɛ̀kɛ̀tɛ̀, wèe dɔɔ̀ kɛ̀ tɛ̀ nwetí dɛ ììkɛ̀, kɛ̀ ifìtíì ìyiekɛ̀ mmí dɛ ììkɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Kɛ̀ Anɔɔ dɔɔ̀ ti Yiɛ̀ nKuyie ntì nɑ̀kɛ́mɛ̀ Mɔyiisi, kɛ́cónnɛ́ tɛfitíkɛ̀kɛ̀tɛ̀ kɛ̀ tɛ fitíì nwetí dɛyììkɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Dɛ kó tɛfitíkɛ̀kɛ̀tɛ̀ bɛ̀ do yìɛ mmɛsɔɔ mmɛ kɛ́ tɛ̀ utɛ́, tɛ tɑ̀rì nɛ̀ tɛ bɑ̀kɛ nɛ̀ dɛ̀ɛ̀ dò mmutepóó. Bɛ̀ do tɛ̀ dɔ̀ɔ̀ kɛ̀ tɛ̀ ndònnɛ̀ ti Yiɛ̀ nKuyie ndo bɛnkɛ tɛ̀ntɛ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","Tɑ̃ɑ̃tɛ́ Isidɑyɛɛribɛ botí miɛkɛ Defiibɛ kɛ́ bɛ̀ dɔ̀ɔ̀ mɛwénkùmɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Ntɛ ɑ yóó bɛ̀ wénkùnnɛ mɛ̀ɛ̀ botí: Á bɛ̀ mìɛ́tɛ́ ikuɔ́ kó mɛniɛ kɛ̀ bɛ̀ɛ kuó bɛ cìtì timɔu kɛ́ɔ́ú bɛ yɑ̀ɑ̀tì kɛ́wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Kɑ̀ɑ dèè bɛ̀ɛ tɔní dinɑɑdɑpɑ̀nnì nɛ̀ muyuo nsɑ̀ɑ̀mù bɛ̀ ɑ̃̀ntɛnɛ̀ mù mɛkùɔ̀. Kɑ̀ɑ túótɛ́ dinɑɑdɑpɑ̀nnì tɛrì ɑ yóó kuɔ dì mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Á duɔ́ nkɛ̀ Defiibɛɛ kɔtɛní mɛtɑummɛ̀ tou borɛ̀, kɑ̀ɑ tíí nyIsidɑyɛɛribɛ bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Kɛ̀ Defiibɛ tɔ̀ɔ́nní dìì mɔ̀nnì mɛtɑummɛ̀ tou bòrì n yììkɛ̀, ɑ́ duɔ́ nkɛ̀ Isidɑyɛɛribɛɛ bɛ̀ nɔ̀ɔ́ nsinɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Kɛ̀ Anɔɔ bɛ̀ tùótɛ́ Isidɑyɛɛribɛ borɛ̀, kɛ́ bɛ̀ nni m bɛnkɛ bɛ̀ ɔ̃ɔ̃ dɔɔ̀mɛ̀ bɛ̀ m pɑ̃ dìì pɑ̃nnì, kɛ́deè kɛ̀ bɛ̀ nɛ́ nɑ kɛ́tɑ n kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Dɛ kó difɔ̃nkúò kɛ̀ Defiibɛɛ nɔ́ɔ́ mbɛ nɔu yɛnɑɑdɑkɛ̀ yɔ ĩ́nkɛ̀, kɑ̀ɑ féútɛ́ dìmɑ́ɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́féútɛ́ ditɛrì kɛ́tuɔ, kɛ́dɔɔ̀ Defiibɛ mɛwénkùmɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Kɑ̀ɑ còńnɛ́ dìì mɔ̀nnì Defiibɛ Anɔɔ nɛ̀ o bí bɛ ììkɛ̀, fɔ̃́ mMɔyiisi ɑ́ bɛ̀ nni mbɛnkɛ di ɔ̃ɔ̃ m bɛnkɛ mɛ̀ɛ̀ botí dipɑ̃nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Mɛm̀mɛ ɑ yóó dɔɔ̀mɛ̀ kɛ́cɑ̃́nnɛ́ Defiibɛ Isidɑyɛɛribɛ cuokɛ̀ kɛ̀ bɛ̀ ntú n kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Dɛ mɔ̀nnì ndi Defiibɛ bo nɑmɛ̀ kɛ́ketɛ́ n tɔ̃mmú mɛtɑummɛ̀ tou miɛkɛ. Mɛm̀mɛ ɑ yóó bɛ̀ wénkùnnɛmɛ̀ nɛ̀ mɛwénkùmɛ̀ kó ikuɔ́ kɛ́ bɛ̀ nni mbɛnkɛ kɛ́ bɛ̀ nni nduɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Kɛ yɛ̃́ bɛ̀ cɑ̃̀ɑ̃́mmɛ̀mu kɛ tú n kɔbɛ kɛ cɔutɛ́ Isidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo kó difɔ̃̀tìrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Isidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo míì bɛ̀ te, kɛ́túótɛ́ n kùɔ dìì yiè bɛ̀ɛ̀ tu Mpo Esibiti miɛkɛ nɛ̀ yíenní, míì te bɛ̀ɛ̀ tu Mpo nɛ̀ iwũɔ̃ pɛí ìì bí iketiyì kɛ̀ ì tu idɑɑì, dɛ yiè ndi m bɛ̀ tɑ̃ɑ̃tɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Isidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo bɛ kó difɔ̃̀tìrì ndi n tùótɛ́mɛ̀ Defiibɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","kɛ bɛ̀ duɔ́ nhAnɔɔ nɛ̀ o bí, m bɛ̀ nhò duɔ́mmu kɛ̀ bɛ̀ bo mpĩ́ mmɛtɑummɛ̀ tou miɛkɛ mutɔ̃mmú Isidɑyɛɛribɛ kpɛ́í. Bɛɛ̀ yó ndɔɔri mɛwénkùmɛ̀ kó ikuɔ́ Isidɑyɛɛribɛ kɛ̀ dɛ̀ɛ yie nkɛ̀ bɛ̀ tɔ̀ɔ́nnɛ̀ mɛtɑummɛ̀ tou m bɑ́ɑ́ bɛ̀ potɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mɔyiisi nɛ̀ Anɔɔ nɛ̀ Isidɑyɛɛribɛ sɔmbɛ kɛ̀ bɛ̀ɛ tũnnɛ ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́ Mɔyiisi kɛ dɔ̀ bɛ̀ɛ dɔɔ̀mɛ̀ Defiibɛ, kɛ̀ bɛ̀ɛ mɛ mbɛ̀ dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Kɛ̀ Defiibɛɛ wénkùnnɛ bɛmɑ́ɑ̀ kɛ́ɔ́ú bɛ yɑ̀ɑ̀tì kɛ̀ Anɔɔ bɛ̀ duɔ́ nti Yiɛ̀ nKuyie nkɛ́ bɛ̀ dɔ̀ɔ̀ dɛ kó ikuɔ́, kɛ́deè kɛ́ bɛ̀ dɔ̀ɔ̀ mɛwénkùmɛ̀ kpɛyi, kɛ́ bɛ̀ wénkùnnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Mɛm̀mɛ kɛ̀ Defiibɛ nɛ́ nɑ kɛ́ketɛ́ bɛ tɔ̃mmú mɛtɑummɛ̀ tou miɛkɛ. Anɔɔ nɛ̀ o bí kɛ̀ bɛ̀ mbɛ̀ ni ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́mɛ̀ Mɔyiisi Defiibɛ kpɛ́í, kɛ̀ bɛ̀ɛ mɛ ndɔɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Defiibɛ níí yó mmɔkɛ yɛbie nsipísìdɛ́ nɛ̀ yɛ̀nùmmù ndi kɑ̀ɑ bɛ̀ duɔ́ mmutɔ̃mmú mɛtɑummɛ̀ tou miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Kɛ̀ wèè tùɔ̀kɛ yɛbie nsipísìnùmmù wèe yóu mutɔ̃mmú kɛ tɛ̃́nkɛ bɑ́ mpĩ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Ò nɛ́ bo nɑ kɛ́nteénnɛ̀ o kɔbɛ mutɔ̃mmú mɛtɑummɛ̀ tou miɛkɛ, ò nɛ́ tɛ̃́nkɛ bɑ́ mmɔkɛ o kɔ̃mu ò wetí mù. Defiibɛ tɔ̃mmú kó ikuɔ́ yó mmɛ ndò. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Isidɑyɛɛribɛ do bo bɛ benni didɛ́rì miɛkɛ nkɛ nɛ̀ bɛ̀ yɛ̀mɛ̀ Esibiti otɑ̃̀nkù ketiwè kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi Sinɑii kó dikpɑ́ɑ̀ miɛkɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","Isidɑyɛɛribɛ dò nkɛ́mbɑɑ̀mmu diyentɛ́bɑnni n yɛ̃ mbɛ̀ ndì bɑɑ̀ ndìì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Otɑ̃̀nkù yie nkó diyiè tɛpíítɛ̀ nɛ̀ dinɑɑnnì yie ndi dihuri, di yóó ketɛ́mɛ̀ dɛ kó dibɑnni. Dí ntũ ndɛ kó ikuɔ́ nɛ̀ dɛ kó itié n di nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Kɛ̀ Mɔyiisii nɑ́kɛ́ bɛnìtìbɛ̀ kɛ dɔ̀: Bɑɑ́nnɛ̀ diyentɛ́bɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Kɛ̀ bɛ̀ɛ di bɑɑ́ nSinɑii kó dikpɑ́ɑ̀ miɛkɛ, otɑ̃̀nkù ketiwè kó diyiè tɛpíítɛ̀ nɛ̀ dinɑɑnnì yiè kó dihuri. Kɛ̀ Isidɑyɛɛribɛɛ dɔɔ̀ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ tì Mɔyiisi timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Kɛ̀ bɛnìtìbɛ̀ mɑbɛ̀ ḿbo kɛ í nnɑ kɛ bɑɑ́ ndiyentɛ́bɑnni bɛ̀ kɑ̀ɑ́kɛ́ mɛ̀ɛ̀ kpɛ́í nhocíì kɛ sĩ̀ntɛ kɛ́ítɛ́ dɛ yiè kɛ́kɔtɛ kɛ́yɑ̀ Mɔyiisi nɛ̀ Anɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Kɛ dɔ̀: Ti kɑ̀ɑ́kɛ́ mɛ̀ɛ̀ kpɛ́í nhocíì, kɛ sĩ̀ntɛ dɛɛ̀ bo nte kɛ̀ ti bɑ́ɑ́ pɑ̃ ti Yiɛ̀ nKuyie nyɛpɑ̃rɛ̀ Isidɑyɛɛribɛ tɔbɛ̀ kɔ̃mɛ diyentɛ́bɑnni yièɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Kɛ̀ Mɔyiisii bɛ̀ tɛ̃̀ńnɛ́ kɛ dɔ̀: Ncómmúnɛ̀ dɛndɛ kɛ̀ n yɑ̀ ti Yiɛ̀ nKuyie mbo n nɑ́kɛ́ tì di kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ ndíndi nɛ̀ di yɑɑ̀bío kòò mɔù kɑ̀ɑ́kɛ́ ocíì kɛ sĩ̀ntɛ yoo ò bo kupɔ̀ɔ̀kù dɛdɛ́tirɛ̀ ò dò nkɛ́bɑɑ́mmu diyentɛ́bɑnni. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Otɑ̃̀nkù dɛ́rì kó diyiè tɛpíítɛ̀ nɛ̀ dinɑɑnnì kó dihuri ndi diyentɛ́bɑnni, dɛ yiè di níí cɑ́ɑ́kɛ́ dipedɑbii kó imɑɑ nnɛ̀ pɛ̃́ɛ̃̀ wèè í kɔɔrɛnɛ̀ mutie mùù muuti, kɛ́ ì cɑ̀ɑ́kɛ́ nɛ̀ tikũnfɑ̃ɑ̃̀tì tiiti. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Di níí bɑ́ɑ́ dì cɑ̀ɑ́kɛ́ kɛ́súɔ́ nkɛ̀ dɛ̀ɛ wentɛ́, di mɛ mbɑ́ɑ́ kéétɛ́ dikɔ̃́ũ̀ mɑrì. Dí ntũ ndiyentɛ́bɑnni kó ikuɔ́ duɔ́ kɛ dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Kòò mɔù í sɑ̃ũ nhomɑ́ɑ̀, ò mɛ nyí kɔ̀tɛ kupɔ̀ɔ̀kù kɛ nɛ́ yóu ò bo bɑɑ́mmɛ̀ diyentɛ́bɑnni kɛ́pɑ̃ mí ndi Yiɛ̀ nKuyie ndipɑ̃nnì, dɛ yiɛ̀ mbɛ̀ɛ ò dɛ̀itɛ o kɔbɛ cuokɛ̀, kòò sèńtɛ́ diyentɛ́bɑnni kó diyiè n dɔú ndì, o yɛi mbo o yuu ĩ́nkɛ̀ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Kòo pɔ̀ɔ̀ mɔù bo di cuokɛ̀ kɛ dɔ́ kɛ́bɑɑ́ ndiyentɛ́bɑnni, wèe tũnnɛ diyentɛ́bɑnni kó itié nnɛ̀ dɛ kó ikuɔ́ duɔ́ kɛ dòmmɛ̀. Diyentɛ́bɑnni kó ikuɔ́ imɑ́ɑ̀ ndi, wèè tu Isidɑyɛɛri o kpɛ́í, nnɛ̀ wèè tu opɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Bɛ̀ còńnɛ́ dìì yiè Kuyie ntou mɛtɑummɛ̀ tɔu bo dìì miɛkɛ kɛ́deè kɛ̀ diwɛtirìi kɔtɛní kɛ́ dì dɑ̀tínnɛ́ kuyuoku kɛ́ndò mmuhɑ̃ɑ̃́ nkɛ̀ dɛ̀ yɑ̀ɑ wentɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Kɛ̀ dìi sɔɔtɛ́ kɛ́ mmɛ ndò, kɛ níí ntú kuyie mmɔ̀nnì diwɛtirì kɛ́ntú muhɑ̃ɑ̃́ nkɛyènkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Kɛ̀ diwɛtirì ìtɛ́ dìì mɔ̀nnì Kuyie ntɑummɛ̀ tou ĩ́nkɛ̀ Isidɑyɛɛribɛɛ ítɛ́. Kɛ̀ dì kɔ̀tɛ kɛ còḿmú dɛ̀, bɛ̀ɛ dɛ mbɑ́tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Kɛ̀ Isidɑyɛɛribɛ mmɛ ndɔɔri, kɛ̀ diwɛtirì ìtɛ́ bɛ̀ɛ ítɛ́, kɛ̀ dì còḿmú bɛ̀ɛ bɑ́tɛ́, kɛ̀ diwɛtirì mɛ nyí ìtɛ́ bɛ̀ bɑ́ɑ́ ítɛ́ ti Yiɛ̀ nKuyie ndo ti mbɛ̀ nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Kɛ̀ diwɛtirì còḿmú Kuyie ntou ĩ́nkɛ̀ kɛ yĩ yɛwe pɛ́u, Isidɑyɛɛribɛ múnkɛ bɑ́ɑ́ ítɛ́ bɛ̀ ndɛ mbo kɛ pĩ́ ti Yiɛ̀ nKuyie mbɛ̀ nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Kɛ̀ dɛ̀ mɛ ndò ndiwɛtirì í mɔ̀ntɛ bɛ̀ ḿbo, kɛ̀ ti Yiɛ̀ nKuyie mmɛ nyĩ́ bɛ̀ɛ ítɛ́, bɛ̀ɛ ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Di mɔ̀nnì mɑrì diwɛtirì níí ncómmú Kuyie ntou ĩ́nkɛ̀ kuyuoku nɛ̀ dɛ bo wentɛ́mɛ̀, dikṹnweńnì kɛ̀ dì ìtɛ́ bɛ̀ɛ ítɛ́, yoo dì ncómmú kɛ dɔ̀ kɛyènkɛ̀ kɛ̀mɑ́ɑ̀, kuyie nkùmɑ́ɑ̀, kɛ̀ diwɛtirì ìtɛ́ dìì mɔ̀nnì bɛ̀ɛ ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Yoo dì dɔ̀ yɛwe yɛ̀dɛ́ɛ̀, yoo otɑ̃̀nkù yoo dibenni, kɛ̀ diwɛtirì còḿmú Kuyie ntou ĩ́nkɛ̀ kɛ í ìtɛ́ Isidɑyɛɛribɛ nkɑri bɛ̀ bɑ̀tɛ́ dɛ̀, bɛ̀ bɑ́ɑ́ ítɛ́. Kɛ̀ dì mɛ nyìtɛ́ dìì mɔ̀nnì bɛ̀ɛ ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Isidɑyɛɛribɛ do ɔ̃ nkɛ̀ bɛ̀ bɑ̀tɛ́ bɛ̀ nkɑrimu, kɛ̀ ti Yiɛ̀ nKuyie nyí yĩ: Ítɛ́nɛ̀. Bɛ̀ bɑ́ɑ́ ítɛ́. Kɛ̀ kù mɛ nyĩ: Ítɛ́nɛ̀! Bɛ̀ɛ ítɛ́. Bɛ̀ do tũ nti Yiɛ̀ nKuyie mbɛ̀ nɑ̀ɑ́ tì nti nɛ̀ Mɔyiisi nùù miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","Duɔ́ nkɛ̀ bɛ̀ɛ yiɛ ntimɑ́tì pɛ́ítì kɛ́dɔɔ̀ yɛmɑ́tìtɑ̃tɛhe yɛ̀dɛ́ɛ̀, bɛ̀ níí yóó yɛ nheé kɛ̀ dí tíí, yoo bɛ̀ɛ eé kɛ̀ dí ítɛ́ di bɑ̀tɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Bɛ̀ níí yóó yɛ nheé kɛ̀ Isidɑyɛɛribɛ bɛmɔuu tíí nhɑ borɛ̀ mɛtɑummɛ̀ tou borìnùù. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Kɛ̀ bɛ̀ níí eé ditɑ̃tɛheù dìmɑ́ɑ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ nɛ̀ sikpɑ̀ɑ̀tìbìí bɛɛ̀ dò nkɛ́tíí nhɑ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Kɛ̀ bɛ̀ mɛ nheé kɛ iinɛ̀ bɛ̀ɛ̀ kɑ̀ri mɛtɑummɛ̀ tou diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ bɛ̀ɛ ítɛ́ kɛ́kétɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Kɛ̀ bɛ̀ yíɛ́ kɛ eé kɛ iinɛ̀, kubɑkù cɑ̃̀nku kɔbɛɛ ítɛ́ kɛ́kétɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Kɛ̀ dì mɛ ndɔ́ kɛ́tíí nyIsidɑyɛɛribɛ bɛmɔu ndi, dí eé di bɑ́ɑ́ iinɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Anɔɔ bí ikuɔ́ nìùbɛ̀ bɛɛ̀ yó nheu yɛtɑ̃tɛhe, dɛ yó ntú di kó ikuɔ́ nyi nɛ̀ di yɑɑ̀bío sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Kɛ̀ di mɛ mbɑ̀ɑ́tí kɛ bo do di dootitɔbɛ̀ bɛ̀ɛ̀ di fɛ̃́ũnko bɛ̀mbɛ mudoò, di eé ditɑ̃tɛheù kɛ́iinɛ̀. Mí ndi Yiɛ̀ nKuyie mmí nwèè di te n yóó dentɛnímu di kpɛ́í nkɛ́ di dɛɛtɛ́nɛ̀ di dootitɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Kɛ̀ di mɛ nhɑ̃nnɛ́ tikpɛitì nti yoo dibɑnni n kpɛ́í nyoo otɑ̃̀nkù pɑ̀nwè kó dibɑnni, kɛ̀ di yó n fíé dìì mɔ̀nnì iwũɔ̃ kɛ́tuɔ nyoo mɛtɑummɛ̀ kpɛyi, dí eé ditɑ̃tɛheù kɛ̀ n dentɛní di kpɛ́í. Mí ndi Yiɛ̀ nKuyie mmíì di te. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Isidɑyɛɛribɛ do yɛ̀ Esibiti kɛ́mbo bɛ benni dɛ́rì otɑ̃̀nkù dɛ́rì kó diyiè sipísìdɛ́ kó diyiè ndi, diwɛtirì ìtɛ́mɛ̀ Kuyie ntɑummɛ̀ tou mɛtɑummɛ̀ tɔu bo dìì miɛkɛ di ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ Sinɑii kó dikpɑ́ɑ̀ kɛ́dɔ́ɔ́tɛ́ bɛ̀ dò nkɛ́kétɛ́ mɛ̀ɛ̀ botí. Kɛ̀ diwɛtirìi kɔtɛ kɛ́cómmú Pɑdɑnni kpɑ́ɑ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Mɛɛ̀ do tú kucɛ mɛketimɛ̀ bɛ̀ ìtɛ́mɛ̀ kɛ́ntũ ti Yiɛ̀ nKuyie ndo ti nɑ̀kɛ́mɛ̀ Mɔyiisi kòo tì mbɛ̀ nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","16","Sudɑɑ kó ditĩ̀nnì kɔbɛ nɛ̀ Isɑkɑɑ kpɛri kɔbɛ nɛ̀ Sɑbunɔɔ kpɛri kɔbɛ bɛɛ̀ yó ntú bɛketibɛ̀ kɛ́ítɛ́nɛ̀ bɛ kó mɛcɑnnimɛ̀ kɛ̀ Amminɑdɑbu birɛ Nɑsɔ̃ɔ̃ nni Sudɑɑ kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì. Kɛ̀ Suɑɑ Nɛtɑnnɛyɛɛdi nni Isɑkɑɑ kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì kɛ̀ Edonni birɛ Ediɑbu nni Sɑbunɔɔ kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Kɛ̀ bɛ̀ɛ uutɛ́ mɛtɑummɛ̀ tou kɛ́kpɛ́ú. Kɛrisonni bí nɛ̀ Mɛdɑdi kpɛyi bɛɛ̀ do te bɛ̀ bo ndì tɔumɛ̀ kɛ̀ bɛ̀ɛ tɔ kɛ́kétɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","20","Bɛ kó difɔ̃nkúò kɛ̀ Dubɛnni kó ditĩ̀nnì kɔbɛ nɛ̀ Simmɛɔ̃ɔ̃ kó ditĩ̀nnì nɛ̀ Kɑdi kó ditĩ̀nnì kɔbɛ kɛ̀ bɛ̀ɛ ntú bɛdɛ́ríbɛ̀ kɛ́kétɛ́nɛ̀ bɛ kó mɛcɑnnimɛ̀ kɛ̀ Sedeuu birɛ Edisuu nni Dubɛnni kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì. Kɛ̀ Sudisɑdɑii birɛ Sedumiɛri nni Simmɛɔ̃ɔ̃ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì. Kɛ̀ Deuyɛɛdi birɛ Ediɑsifu nni Kɑdi kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Bɛ kó difɔ̃nkúò kɛ̀ Keɑti nɑɑ̀mùnkù kɔbɛ bɛ̀ɛ̀ tɔu Kuyie ntɑummɛ̀ tɔu kɛ̀ bɛ̀ɛ kétɛ́, Defiibɛ tɔbɛ̀ do niitɛ́mu kɛ́cónnɛ́ mɛtɑummɛ̀ tou kɛ̀ bɛ̀ bo ntuɔ̀kòo. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","24","Bɛ kó difɔ̃nkúò kɛ̀ Efɑdɑimmu kó ditĩ̀nnì kɔbɛ nɛ̀ Mɑnɑnsee kó ditĩ̀nnì kɔbɛ nɛ̀ Bɛnsɑmɛɛ kó ditĩ̀nnì kɔbɛ kɛ̀ bɛɛ̀ ntú bɛtɑ̃ɑ̃́mbɛ̀ kɛ́kétɛ́ nɛ̀ bɛ kó mɛcɑnnimɛ̀ kɛ̀ Ammiudi birɛ Edisɑmɑ nni Efɑdɑimmu kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì kɛ̀ Pedɑsuu birɛ Kɑmmidiyɛɛri nni Mɑnɑnsee kɔbɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì kɛ̀ Kideonii birɛ Abidɑnni nni Bɛnsɑmɛɛ kɔbɛ kó dihɑ̃ɑ̃pɔ̀nntĩ̀nnì ");
INSERT INTO tbzsim_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","27","Bɛ kó difɔ̃nkúò kɛ̀ Dɑnni kɔbɛ kó ditĩ̀nnì nɛ̀ Asɛɛ kɔbɛ kó ditĩ̀nnì nɛ̀ Nɛfutɑdii kɔbɛ kó ditĩ̀nnì kɛ̀ bɛ̀ɛ yɑ̃ɑ̃ nfɛnɑfɛ fũ̀ɔ̃̀ nɛ̀ bɛ kó mɛcɑnnimɛ̀. Kɛ̀ Amisɑdɑii birɛ Ayesɛɛ nni Dɑnni kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì kɛ̀ Okɑdɑnni birɛ nni Asɛɛ kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì kɛ̀ Enɑnni birɛ Aidɑ nni Nɛfutɑdii kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Isidɑyɛɛribɛ kó yɛtĩ̀rɛ̀ do iiti miɛ̀ mbotí nku bɛ ɑ̃ɑ̃pɔ̀nkɑrɛ̀ kɛ keri. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mɛm̀mɛ kɛ̀ Mɔyiisii nɑ́kɛ́ o cɔ̀kù Deuyɛɛdi, Mɑndiyɑ̃ɑ̃ ɛì kou kó dɛbirɛ Obɑbu kɛ dɔ̀: Ti kɔri ti Yiɛ̀ nKuyie nyɛ̃ nkù yóó ti duɔ́ ndìì ɛì ndi, yóu kɛ̀ tí nnɛí, ɑ yóó pɛ́tɛ́mu mɛsɑ̀ɑ̀ ti Yiɛ̀ nKuyie nyɛ̃ nkù yóó ti duɔ́ mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Kɛ̀ Obɑbuu ò tɛ̃̀ńnɛ́ kɛ dɔ̀: N bɑ́ɑ́ nɛi n kũnti n ciɛ nkɛ n kɔbɛ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Kɛ̀ Mɔyiisi dɔ̀: Bɑ́ɑ́ ti bɔntóo fɔ̃́ɔ̃̀ yɛ̃́ dikpɑ́ɑ̀ miɛkɛ dɛ̀ɛ̀ dò nkɛ́bɑ́tɛ́, fɔ̃́ɔ̃̀ dò nkɛ́ tí niitɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Kɑ̀ɑ ti nɛinɛ̀ kɛ̀ ti Yiɛ̀ nKuyie nti dɔ̀ɔ̀ dìì mɔ̀nnì kù do yɛ̃ nkù yóó ti dɔɔ̀ mɛ̀ɛ̀ sɑ̀ɑ̀ ɑ í yóó mɔ́ntɛ́ ɑ kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Mɛm̀mɛ kɛ̀ bɛ̀ɛ ítɛ́ ti Yiɛ̀ nKuyie ntɑ̃rì kɛ́mmɔkɛ yɛwe yɛ̀tɑ̃ɑ̃ti mucèmmu kɛ̀ Kuyie ntɑummɛ̀ tɔu ni bɛ ììkɛ̀, dɛ kó yɛwe yɛ̀tɑ̃ɑ̃ti miɛkɛ kɛ bo yɑ̀ bɛ̀ bo bɑ́tɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Bɛ̀ do ìtɛ́ kuyie nku, kɛ̀ Kuyie nkó diwɛtirì mbɛ̀ dɑ̀ɑ́tí. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Kuyie ntɑummɛ̀ tɔu ketɛ́ dìì mɔ̀nnì kɛ̀ Mɔyiisii kuɔ́nko kɛ dɔ̀: Kuyie, nyítɛ́ kɛ́cómmú! Kɑ̀ɑ dootitɔbɛ̀ɛ cíɛ́tɛ́, kɑ̀ɑ níímbɛ̀ ncokù ɑ ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Kɛ̀ bɛ̀ ĩ̀ńnɛ́ dìì mɔ̀nnì mɛtɑummɛ̀ tɔu wèe pĩɛ̃kɛ́ kɛ dɔ̀: Ti Yiɛ̀ nKuyie nwɛ̃tɛní kɛ́mbo ɑ kɔbɛ kuwuɔ ndiɛkù Isidɑyɛɛribɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Diyiè mɑrì kɛ̀ Isidɑyɛɛribɛɛ tuutɛ kɛ́kpɑnnɛ̀ ti Yiɛ̀ nKuyie nkɛ̀ kùu dɛ̀ kèè kɛ̀ ku miɛkɛɛ bɛ̀ pɛikɛ kɛ̀ kùù cṹũnní muhɑ̃ɑ̃́ nkɛ̀ mùu cɔ́útɛ́ bɛ kɑrì kupíkù kùmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Kɛ̀ bɛ̀ɛ kuɔ́nnɛ̀ Mɔyiisi kòo bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ̀ muhɑ̃ɑ̃́ nkú. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Kɛ̀ bɛ̀ɛ yú dɛborɛ̀ kɛ dɔ̀ Tɑbedɑɑ (dɛ̀ɛ̀ tu kuhɑ̃ɑ̃tɔ̀ntɔ̀nkù), kɛ yɛ̃́ ti Yiɛ̀ nKuyie ndo dɛ ncɔ́ummɛ̀ bɛ kɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Kɛ̀ kuníí pĩ́ mbɛsĩ́ntɛnìtìbɛ̀ bɛ̀ɛ̀ do nɛínɛ̀ Isidɑyɛɛribɛ bɛ̀ yɛ̀tì dìì mɔ̀nnì Esibiti, Isidɑyɛɛribɛ mɔ́mmɔmbɛ kɛ̀ bɛ̀ɛ tuutɛ kɛ́nkpɑnnɛ̀ ti Yiɛ̀ nKuyie nkɛ tú: We mbo ti duɔ́ nyimɑɑ nkɛ̀ ti cɑ́ɑ́kɛ́? ");
INSERT INTO tbzsim_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Ti kpɑɑ́ wúónnímu siyĩĩ ti do cɑ́ɑ́ nsì Esibiti fɑ̀ɑ̀rɛ̀ nɛ̀ yɛpérɛ̀ nɛ̀ yɛyɑɑ̀ nwɛɛtìyɛ̀ nɛ̀ tikũnfɑ̃ɑ̃̀tì nɛ̀ yɛdimɑsirɛ̀ dɛbotí dɛbotí. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Ti dɛ mpɑ̀ɑ̀ diɛ nkɛ kɔ̃nnɛ̀ dikònnì. Mɑ́nnì mɑ́ɑ̀ mɑ́ɑ̀ bɑɑ nɛ́ nwe yɛwe yɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mɑ́nnì do ɔ̃ ndònnɛ̀ mɛdibii mmɛ kɛ pɛ́ì. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Timɑɑ̀ntì tiì ɔ̃ɔ̃ nwɛ̃nnɛ́ dɛ kó tidiitì kɛ́yɛ̀nní kɛyènkɛ̀ mɔ̀nnì. Kɛ̀ dɛ̀ wentɛ́ bɛ̀ɛ cíɛ́tóo kɛ́koúní, kɛ́nɑɑ nyoo bɛ̀ɛ ti kɛ́bénnɛ́, kɛ̀ bɛ̀ mɛ ndɔ́ bɛ̀ɛ dɔɔ̀ yɛpɔ̃́mpũɔ̃. Dɛ kó tidiitì nɑɑtí do ɔ̃ ndònnɛ̀ yɛkɑ̀tìndɑ̀ kó kunɑɑtí nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Kɛ̀ Mɔyiisii keè Isidɑyɛɛribɛ tùùtɛmɛ̀ kɛ kpɑnnɛ̀ ti Yiɛ̀ nKuyie mbɑ́ tɛ̀ɛ̀ cĩ́ɛ̃̀tɛ̀ tɛ touku bòrìnùù. Kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛ pɛikɛ mɛdiɛ̀ nkɛ̀ Mɔyiisi yɛ̀mmɛ̀ɛ cɑɑ̀rɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","kòo kuɔ́nnɛ̀ ti Yiɛ̀ nKuyie nkɛ dɔ̀: Kuyie mbɑ nkpɛ́í nte kɑ̀ɑ yóu kɛ̀ tiì nni ntùɔ̀kɛní? Dɛ̀ yĩ́mɛ kɑ̀ɑ n yetɛnɛ̀ ɑ kó mɛsɑ̀ɑ̀, kɛ n tou nditɔu diì nkɛ tú nní nni bɛ nnìtìbɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Míì í pùó ndɛ kó kubotí, míì mɛ nyí kù pɛitɛ́. Dɛ̀ nɛ́ yĩmɛ kɑ̀ɑ tu nní mbɛ̀ ùúkú kubíyɔ̃kù ɔ̃ nhúúkúmɛ̀ ku birɛ, kɛ́ bɛ̀ tɑnnɛ̀ dihɛì ɑ do yɛ̃ nhɑ yóó duɔ́ ndì bɛ yɛmbɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","M bo pɛ́tɛ́ dɛ imɑɑ nkɛ́duɔ́ nkubotí kuu? Bɛ̀ n kuɔ̀nnɛ̀mu kɛ tú m bɛ̀ duɔ́ nyimɑɑ nkɛ̀ bɛ̀ɛ cɑ́ɑ́kɛ́! ");
INSERT INTO tbzsim_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","M bɑ́ɑ́ nɑ m mɑ́ɑ̀ kɛ́tɔ bɛnìtìbɛ̀ biɛ, dɛ kó ditɔu n cɛ̃́ɛ̃́nɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Kɛ̀ dɛ̀ yó nni ndò mmiɛ̀, ɑ pɑ̃̀nkɛ n kuɔ. Kuyie mbɑ́ɑ́ yóu kɛ̀ n tɛ̃́nkɛɛ yɑ̀ mɛyɛi mmiɛ, n dɑ bɑ́ɑ́mmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Tíí nyIsidɑyɛɛribɛ miɛkɛ bɛkotibɑɑbɛ̀ kɛ̀ bɛ̀ ḿbo sipísìyiekɛ̀. A yɛ̃́ kɛ̀ bɛ̀ɛ̀ tu Isidɑyɛɛribɛ miɛkɛ bɛkótíbɛ̀ nɛ̀ bɛ̀ɛ̀ bɑkɛ́, kɛ̀ di kɔtɛní mɛtɑummɛ̀ tou fɔ̃́ nnɛ̀ bɛ kɛ́cómmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","N cutoomu kɛ bo dɑ bɛ́innɛ̀, n yóó bɛ̀ duɔ́ mmuyɑɑ́ nhɑ mɔkɛ mù botí nku, dɛ mɔ̀nnì kɛ̀ bɛ̀ dɑ teennɛ̀ bɛ nnìtìbɛ̀ kó ditɔu, kɑ̀ɑ tɛ̃́nkɛ bɑ́ ndi tɔ ɑmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Á bɛ̀ nɑ̀kɛ́ kɛ̀ bɛ̀ɛ wénkùnnɛ bɛmɑ́ɑ̀: Nɑnkɛ di yóó cɑ́ɑ́kɛ́mu imɑɑ nkɛ yɛ̃́ díì n kuɔ́nnɛ̀mɛ̀ mí ndi Yiɛ̀ nKuyie nkɛ tú: We mbo ti duɔ́ nyimɑɑ nkɛ̀ ti cɑ́ɑ́kɛ́? Ti do bo Esibiti kɛ yo nkunɑɑtí nku! Nɛ̀ dɛ kpɛ́í mí ndi Yiɛ̀ nKuyie n yóó di duɔ́mmu imɑɑ nkɛ̀ di cɑ́ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Dɛ̀ í tú diyiè dìmɑ́ɑ̀ miɛkɛ, yoo yɛ̀dɛ́ɛ̀ yoo yɛ̀nùmmù yoo tɛpíítɛ̀ yoo sipísìdɛ́ di yó nyì cɑ̀ɑ́mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Di yó nyì cɑ̀ɑ́ nkɛ́deè otɑ̃̀nkù nwe, di bo ciɛ̀ nkɛ́keè i nɔ́ú kɛ́ ì pɛ̃̀ kɛ yɛ̃́ mí ndi Yiɛ̀ nKuyie ndi bonɛ̀mɛ̀mu kɛ̀ di m bùtínnɛ́ kɛ kuɔ̀ nkɛ tú: Bɑ nte kɛ̀ ti yɛ̀nní Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Kɛ̀ Mɔyiisi dɔ̀: Bɛnìtìbɛ̀ bɛ̀ɛ̀ m bonɛ̀ kɛ dò nkɛ́nɑ kɛ́kɔtɛ mudoò bɛ̀ bo sikɔupíkɔusìkuɔ̀ ndi (600000) kɑ̀ɑ tu ɑ bo mbɛ̀ duɔ́ nyimɑɑ nkɛ dɔ̀ otɑ̃̀nkɑ̀ɑ̀! ");
INSERT INTO tbzsim_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Bɑ́ kɛ̀ ti fìé iwũɔ̃ imɔu bɛ̀ɛ cɑ́ɑ́kɛ́ kɛ́nsɑ̀nnɑ̀ɑ̀? Bɑ́ kɛ̀ ti ũrí dɑ̀mɛ́ɛ̀rì kó siyĩĩ simɔu bɛ̀ bo cɑ́ɑ́kɛ́ kɛ́nsɑ̀nnɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Kɛ̀ ti Yiɛ̀ nKuyie ntɛ̃́nnɛ́ Mɔyiisi kɛ dɔ̀: Mí ndi Yiɛ̀ nKuyie n nɔ̀ùtɛ̀ kũpúrìmɑɑ̀? A yóó yɑ̀mu kɛ́nsɑ̀ kɛ̀ n dɑ nɑ̀kɛ́ tì bo dɔɔ̀ yoo tì bɑ́ɑ́ dɔɔ̀! ");
INSERT INTO tbzsim_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Kɛ̀ Mɔyiisii yɛ̀nní kɛ́nɑ́kɛ́ bɛnìtìbɛ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì, kɛ́deè kɛ́tíí nyIsidɑyɛɛribɛ miɛkɛ bɛkotibɑɑbɛ̀ sipísìyiekɛ̀ kɛ́duɔ́ nkɛ̀ bɛ̀ɛ cómmú kɛ́fitɛ́ mɛtɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Kɛ̀ ti Yiɛ̀ nKuyie ncútɛ́ní diwɛtirì miɛkɛ kɛ́bɛ́innɛ̀ Mɔyiisi kɛ́duɔ́ mmuyɑɑ́ nhò mɔ̀kɛ mù botí bɛkotibɑɑbɛ̀ sipísìyiekɛ̀ bɛmbɛ. Kuyie nYɑɑ́ mbɛ tɑ dìì mɔ̀nnì kɛ̀ bɛ̀ nnɑ́ɑ́ nKuyie mpɑ̃ɑ̃nɑ́ɑǹtì dɛ kó dimɔ̀nnì dìmɑ́ɑ̀ miɛkɛ, bɛ̀ mɛ nyí sɔkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Dɛ̀ do sɔ̃́ mbɛkotibɑɑbɛ̀ sipísìyiekɛ̀ bɛmbɛ miɛkɛ bɛ̀dɛ́bɛ̀ bɛɛ̀ kpɑɑní bɛ̀ bɑ̀tɛ́ dɛ̀, kòò mɔù yètìrì tu Edidɑdi kòo tɔù kpɛri tú Mɛdɑdi, kɛ̀ Kuyie nYɑɑ́ ncútɛ́ní bɛ ĩ́nkɛ̀, bɑ́ bɛ̀ í mɛ nkɔ̀tɛnímɛ̀ mɛtɑummɛ̀ tou, kɛ̀ bɛ̀ɛ ketɛ́ kɛ́nnɑ́ɑ́ nKuyie mpɑ̃ɑ̃nɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Kòo dɑpɑ̀ɑ̀ mmɔùu cokɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Edidɑdi nɛ̀ Mɛdɑdi bɛ̀ nɑ̀ɑ́ nKuyie mpɑ̃ɑ̃nɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Dɛ mɔ̀nnì Nunni birɛ Sosuwee wèè do nɛitinɛ̀ Mɔyiisi nɛ̀ o bíkɛ́mbɛ́ntì, kòo bɛ́i nkɛ dɔ̀: Okótì pɑɑ mbɛ kɛ̀ bɛ̀ bɑ́ nnɑ́ɑ́ nKuyie mpɑ̃ɑ̃nɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Kɛ̀ Mɔyiisii ò tɛ̃̀ńnɛ́ kɛ dɔ̀: A yĩɛ̃̀kùmu n kpɛ́ínɑ́ɑ̀? Mí n dɔ́ Kuyie nduɔ́mmu ku Yɑɑ́ mbɛnìtìbɛ̀ bɛmɔu kɛ̀ bɛ̀ nnɑ́ɑ́ nku pɑ̃ɑ̃nɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Mɛm̀mɛ Mɔyiisi nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ̀ bɛ̀ɛ kò mbɛ̀ bɑ̀tɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Kɛ̀ ti Yiɛ̀ nKuyie nduɔnní kuyɑɑkperíkù mɑkù dɑ̀mɛ́ɛ̀rì bíɛ́kɛ̀, kɛ̀ kùu tɔní yɛpɛ̀pɛ́rɛ̀ kɛ́cóú mbɛ kɑrì kɛ̀ yɛ̀ɛ fitɛ́ tipíìtì timɔu kɛ́dɔú ntɛbɑ̀tɛ̀ mɛsɑ̀ɑ̀, kɛ́mmɑ̀nnɛ̀ ɑ bo cemmɛ̀ diyiè dìmɑ́ɑ̀ miɛkɛ, kɛ́ncóú kɛ ìtɛ́nɛ̀ kɛtenkɛ̀ kɛ mmɑ̀nnɛ̀ mɛ́tìrì òmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Kɛ̀ bɛnìtìbɛ̀ ntṹṹ nkɛ kou, kɛ yɑ̀ɑ nyié nkɛ kou kɛ̀ dɛ̀ yɑ̀ɑ wentɛ́nko. Wèè tu ò í koú kɛ̀ dɛ̀ sũ dɛ̀ í ndòńtɛ́ cìdóò sikɔu sikɔu kɛ̀ bɛ̀ɛ yɛ̀ yennɛ́ kɛ́fitɛ́ bɛ kɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Kɛ̀ yɛ̀ nkpɑɑ́ kɛ ɑ̃ bɛ nɔ̀ miɛkɛ bɑ́ bɛ̀ mu nyí cɑ̀ɑ́kɛ́ yɛ kó imɑɑ nkɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛ bɛ pɛikɛ kɛ̀ kùu bɛ̀ potɛ́ kuyɛ̃ĩku diɛkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Kɛ̀ bɛ̀ɛ yú dɛborɛ̀ kɛ dɔ̀ Kibodoti-Atɑɑfɑ, dɛ̀ɛ̀ tu kuníí kó kufɔ̃ti, kɛ yɛ̃́ bɛ̀ do dɛ nkũnnɛ́mɛ̀ kuníí do pĩ mbɛ̀ kɛ̀ bɛ̀ ndɔ́ kɛ́cɑ́ɑ́kɛ́ imɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Bɛ̀ dɛ nyìtɛ́ kɛ́kɔtɛ kɛ́bɑ́tɛ́ Asedɔti kɛ́kɑri. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Kɛ Midiyɑmmu nnɑ́ɑ́nnɛ̀ Anɔɔ kɛ kpɑ Mɔyiisi tùótɛ́ mɛ̀ɛ̀ kpɛ́í Kuusi botí kóo nitipòkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Kɛ̀ bɛ̀ nnɑ́ɑ́ nkɛ tú: Ti Yiɛ̀ nKuyie nnɑ́ɑ́nnɛ̀ Mɔyiisi mɑ́ɑ̀ ndi kɛ í ti nɑ́ɑ́nnɑ́ɑ̀? Kɛ̀ ti Yiɛ̀ nKuyie nkeè. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Mɔyiisi do tú onìtì wèè í mɔkɛ wènwe tɛfentɛ̀ bɑ́ sɑ́m̀pɔ́, bɑ́ òmɔù í bo kutenkù miɛkɛ wèè ò dònnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Dɛndɛ bɑ̀mbɑ̀ kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ nɛ̀ Midiyɑmmu kɛ dɔ̀: Dí kɔtɛní dimɔu, di tɑ̃ɑ̃ti mɛmmɛ mɛtɑummɛ̀ tou borɛ̀. Kɛ̀ bɛ̀ɛ kɔtɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Kɛ̀ ti Yiɛ̀ nKuyie ncútɛ́ní diwɛtirì miɛkɛ kɛ́cómmú mɛtɑummɛ̀ tou bòrìnùù kɛ yú Anɔɔ nɛ̀ Midiyɑmmu kɛ̀ bɛ̀ɛ kɔtoo bɛdɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ bɛ́innɛ̀ kɛ dɔ̀: Kéntɛ́nɛ̀ n yóó di nɑ́kɛ́ tì, kòò mɔù tu di miɛkɛ mpɑ̃ɑ̃nɑ́ɑǹtì nɑ́ɑǹtò mí nKuyie n yóó ò bɛnkɛ m mɑ́ɑ̀ nɛ̀ mɛbɛnkùmɛ̀ miɛkɛ nkɛ, kɛ́ nhò nɑ̀ɑ́nnɛ̀ tidɔuǹtì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","N kóo tɔ̃ntì Mɔyiisi kpɛrɛ í mɛ ndò, ò pĩ n nìtìbɛ̀ mɛsɑ̀ɑ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nɛ̀ wenwe ti ɔ̃ nnɑ́ɑ́ nkɛ cɔ́ú ntitɔbɛ̀ mbɛ kɛ̀ dɛ̀ feío, n yí ò nɑ̀ɑ́nnɛ̀ yɛnɑ́ɑǹhɑ̃ntíyɛ̀, nh ɔ̃ɔ̃ ò bɛnkɛmu m mɑ́ɑ̀ kòo yɑ̀ n fènkù. Dɛ̀ dòmmɛ kɛ̀ di í ò dé, wenwe n kóo tɔ̃ntì Mɔyiisi? ");
INSERT INTO tbzsim_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mɛm̀mɛ ti Yiɛ̀ nKuyie mmiɛkɛ bɛ̀ yɛ̀mɛ̀ kɛ̀ kùu ítɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Diwɛtirì kɑ̃ɑ̃tɛ́ dìì mɔ̀nnì mɛtɑummɛ̀ tou ĩ́nkɛ̀, kɛ̀ bɛ̀ nsɔ̃́ ntikɔ̀ntì pĩ mMidiyɑmmu kòo kɔ̃̀ntì pɛikɛ kɛ nɑɑ́ ntikóntì kɛ̀ Anɔɔ ò yɑ̀ kɛ́nsɔ̃́ ntikɔ̀ntì tiì ò pĩ. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Kòo nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Áú n yiɛ̀! N dɑ bɑ́ɑ́mmu bɑ́ɑ́ yóu kɛ̀ mɛyɛi nti dɔ̀ɔ̀ mɛ̀ɛ do ti yɔ ĩ́nkɛ̀, ti dɔ̀ɔ̀ tiyɛìntì nti, ti cɑ̀ɑ̀rɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","N dɑ bɑ́ɑ́mmu ɑ bɑ́ɑ́ yóu kòo kɔ̃̀ntì dɔntɛ́ dɔntɛ́ bɛ̀ pɛitɛ́ wè dicírì kpɛti kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Kɛ̀ Mɔyiisii kuɔ́nnɛ̀ Kuyie nkɛ dɔ̀: N dɑ bɑ́ɑ́mmu wɛ̃́ɛ̃́roo kóò miɛkùnnɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Kɛ̀ Kuyie ntɛ̃́nnɛ́ Mɔyiisi kɛ dɔ̀: Kòo cicɛ weè do ntĩ̀ṹtɛ́ o ììkɛ̀ tinɔ́ntɔ̃ũtì, ifɛi nɑɑ bɑ́ nhò bo kɛ dɔ̀ yɛwe yɛ̀yiekɑ̀ɑ̀? Mɛɛ̀ botí nku di dòmmɛ̀ kóò dènnɛ di kó dikɑrì, kɛ̀ yɛwe yɛ̀yiekɛ̀ɛ pɛ̃ɛ̃tɛ́ kòo wɛ̃tɛní. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Mɛm̀mɛ kɛ̀ bɛ̀ɛ dennɛ Midiyɑmmu bɛ kɑrì kɛ́nkémmú yɛwe yɛ̀yiekɛ̀ bo pɛ̃ɛ̃tɛ́mɛ̀ kòo wɛ̃tɛní kɛ̀ bɛ̀ nɛ́ nɑ kɛ́pɛ̃ɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Dɛ kó difɔ̃nkúò kɛ̀ bɛ̀ɛ ítɛ́ Asedɔti kɛ́kɔtɛ kɛ́bɑ́tɛ́ Pɑdɑnni kó dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","Á dɛitɛ Isidɑyɛɛribɛ botí miɛkɛ bɛkotibɑɑbɛ̀, bɑ́ kùù botí miɛkɛ onìtì òmɑ́ɑ̀ òmɑ́ɑ̀ kɛ́ bɛ̀ tɔ̃ nkɛ̀ bɛ̀ɛ pɑɑtɛ́ Kɑnnɑhɑ̃ɑ̃ kó dihɛì n yɛ̃ n yóó di duɔ́ ndì. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Kɛ̀ Mɔyiisii tũnnɛ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì dɛndɛ Pɑdɑnni kó dikpɑ́ɑ̀ miɛkɛ, kɛ́dɛi Isidɑyɛɛribɛ miɛkɛ bɛkotibɑɑbɛ̀ kɛ́tɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ntɛ ò do tɔ̃ mbɛ̀ kó yɛyètɛ̀: Dubɛnni kó kubotí kou do tú Sɑkuu birɛ Sɑmmuɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Kɛ̀ Simmɛɔ̃ɔ̃ kó kubotí kou ntú Ɔɔri birɛ Sɑfɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Kɛ̀ Sudɑɑ kó kubotí kou ntú Yefundee birɛ Kɑdɛbu. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Kɛ̀ Isɑkɑɑ kó kubotí kou ntú Sosɛfu birɛ Ikɑdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Kɛ̀ Efɑdɑimmu kó kubotí kou ntú Nunni birɛ Oseɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Kɛ̀ Bɛnsɑmɛɛ kó kubotí kou ntú Dɑfuu birɛ Pɑditi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Kɛ̀ Sɑbunɔɔ kó kubotí kou ntú Sodi birɛ Kɑdiyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Kɛ̀ Sosɛfu kó kubotí nɛ̀ Mɑnɑnsee kɔku kɛ̀ bɛ kou ntú Susi birɛ Kɑdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Kɛ̀ Dɑnni kó kubotí kou ntú Kemɑdi birɛ Amiyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Kɛ̀ Asɛɛ kó kubotí kou ntú Mikɑyɛɛri birɛ Sefudi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Kɛ̀ Nɛfutɑdii kó kubotí kou ntú Fofisi birɛ Nɑbi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Kɛ̀ Kɑdi kó kubotí kou ntú Mɑkii birɛ Ketuyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Bɛnìtìbɛ̀ Mɔyiisi do tɔ̃ mbɛ̀ kɛ̀ bɛ̀ bo pɑɑtɛ́ dihɛì bɛ yètɛ̀ nyɛ mɛmmɛ. Kɛ̀ Mɔyiisii yú Nunni birɛ Oseɑ kɛ dɔ̀ Sosuwee. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Kɛ̀ Mɔyiisii bɛ̀ tɔ̃ nkɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Di kétɛ́ kɛ́tɑ Kɑnnɑhɑ̃ɑ̃ tenkɛ̀ kubɑkù cɑ̃̀nku bíɛ́kɛ̀, kɛ́pɛ̃ɛ̃tɛ́ kɛ́dekɛ yɛtɑ̃rɛ̀ ĩ́nkɛ̀ kó yɛhɛkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","kɛ́pɑɑtɛ́ dihɛì mɛsɑ̀ɑ̀ nkɛ́yɑ̀ dì dòmmɛ̀ nɛ̀ bɛnìtìbɛ̀ bɛ̀ɛ̀ bo di miɛkɛ bɛ̀ dòmmɛ̀, kɛ̀ bɛ̀ kpeńnì yoo bɛ̀ cĩ̀ĩnnì kɛ̀ bɛ̀ sũ yoo bɛ̀ í sũ. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Dí pɑɑtɛ́ bɛ tenkɛ̀ dòmmɛ̀, kɛ̀ kɛ̀ wenni yoo kɛ̀ sĩ̀, nɛ̀ bɛ̀ bo yɛ̀ɛ̀ ɛkɛ̀ dòmmɛ̀, kɛ̀ iduotí yɛ̀ fitɛ́ yoo yɛ̀ feío, ");
INSERT INTO tbzsim_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","kɛ́yɑ̀ kɛ̀ kɛtenkɛ̀ nɑɑti yoo kɛ̀ sɛɛ, kɛ̀ titieti bo yoo ti kpɑ, yɑ́úkùnnɛnɛ̀ di kɔ̃̀ntì. Dí ntɔní bɛ tenkɛ̀ kó yɛtebɛ. Dɛ̀ do sɔ̃́ ndɛtie mbɛ̀ tu dɛ̀ fínyĩ̀ dɛ bɛ ketiyɛ̀ biì dìì mɔ̀nnì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Kɛ̀ bɛ̀ɛ kɔtɛ kɛ́pɑɑtɛ́ Kɑnnɑhɑ̃ɑ̃ tenkɛ̀, kɛ́túótɛ́ Sinni kpɑ́ɑ̀ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Deɔbu Amɑti tenkɛ̀ mɑ̀nku, ");
INSERT INTO tbzsim_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","kɛ́kɔtɛ kɛ́tɑ dihɛì kubɑkù cɑ̃̀nku bíɛ́kɛ̀ Ebunɔɔ kó diberímberi, Anɑkii yɑɑ̀bí tidɑdiɛtì, Aimɑnni nɛ̀ Sesɑii nɛ̀ Tɑdimɑii bɛ kó dikɑrì. Ebunɔɔ kó dihɛì mɑɑ́ kɛ̀ dɛ̀ mmɔkɛ yɛbie nyɛ̀yiekɛ̀ ndi kɛ̀ bɛ̀ nɛ́ nɑ kɛ́mɑɑ́ Esibiti kpɛri bɛ̀ tu dì Tɑniisi. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Kɛ̀ bɛ̀ɛ tuɔkɛ Ɛsikɔɔdi biriku kɛ́kɔ̃ṹ fínyĩ̀ kó yɛbɛ tɛyùtɛ̀ kɛ́sɛu nkudɔú kɛ́buutɛ́ bɛnìtìbɛ̀ bɛ̀dɛ́bɛ̀, nɛ̀ yɛtebɛ tɛyɛ̀ bɛ̀ tu yɛ̀ kèdènɑ́tì nɛ̀ fìkíè kó yɛbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Kɛ̀ bɛ̀ɛ yú dɛborɛ̀ kɛ dɔ̀ Ɛsikɔɔdi biriku, dɛ̀ɛ̀ tu siyuu biriku, bɛ̀ dɛ̀ kɔ̃ũ mɛ̀ɛ̀ kpɛ́í yɛtebɛ kó siyuu. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Yɛwe sipísìnɑ̀ɑ̀ kó difɔ̃nkúò bɛ̀ɛ̀ do kɔ̀tɛ dihɛì pɑɑtímù kɛ̀ bɛ̀ɛ konní, ");
INSERT INTO tbzsim_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","kɛ́kɔtɛ kɛ́yɑ̀ Mɔyiisi nɛ̀ Anɔɔ nɛ̀ Isidɑyɛɛribɛ sɔmbɛ Pɑdɑnni kó dikpɑ́ɑ̀ Kɑdɛɛsi kó kutempɛ̃ mmiɛkɛ kɛ́ bɛ̀ nɑ̀kɛ́ bɛ̀ yɑ̀ní tìì kó dimɑ̀ɑ̀, kɛ́ bɛ̀ bɛnkɛnɛ̀ yɛtebɛ bɛ̀ tɔní yɛ̀ dɛ kó kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Kɛ̀ bɛ̀ɛ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Ti kɔ̀tɛmu dihɛì ɑ ti tɔ̃ ndì tenkɛ̀ miɛkɛ. Mɔ́mmuɔ nwe mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃̀mmu. Ntɛ ti tɔní yɛ̀ɛ̀ tebɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Bɛnìtìbɛ̀ bɛ̀ɛ̀ bo dɛ kó dihɛì miɛkɛ bɛɛ̀ nɛ́ kpeńnì kɛ̀ iduotí fitɛ́ bɛ ɛkɛ̀, kɛ̀ ti yɑ̀ yɛ miɛkɛ Anɑkii yɑɑ̀bí tidɑdiɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amɑdesiibɛ bɛɛ̀ bo kubɑkù cɑ̃̀nku bíɛ́kɛ̀ kó kutempɛ̃, kɛ̀ Itiibɛ nɛ̀ Sebusiibɛ nɛ̀ Amɔriibɛ kɛ̀ bɛ̀ bo yɛtɑ̃rɛ̀ ĩ́nkɛ̀, kɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ bo dɑ̀mɛ́ɛ̀rì nɛ̀ Suditɛ̃ɛ̃ dɛ pɛɛ́mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Dɛ mɔ̀nnì kɛ̀ Kɑdɛbuu duɔ́ nkɛ̀ bɛnìtìbɛ̀ bɛ̀ɛ̀ kpɑ̀nnɛ̀ Mɔyiisi kɛ̀ bɛ̀ dɔ̀ yúóó. Kòò dɔ̀: Tí kɔtɛnɛ̀ ti yóó bɛ̀ nɑmu kɛ́fietɛ bɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Bɛnìtìbɛ̀ ò do nɛinɛ̀ bɛ̀ kɛ̀ bɛmbɛ dɔ̀: Ti bɑ́ɑ́ nɑ kɛ́dokɛ́nɛ̀ dɛ kó bɛnìtìbɛ̀, bɛ̀ kpeńnìmu kɛ ti pɛ̃ɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Kɛ̀ bɛ̀ɛ ketɛ́ bɛ̀ bo nsĩnkùnkomɛ̀ dɛ kó kɛtenkɛ̀, kɛ́nnɑ́ɑ́ nyIsidɑyɛɛribɛ kɛ tú: Dɛ kó kɛtenkɛ̀ yo mbɛnìtìbɛ̀ mbɛ! Ti yɑ̀ bɛ̀ɛ̀ nìtìbɛ̀ kɛ miɛkɛ bɛ̀ tu tidɑdiɛtì nti. ");
INSERT INTO tbzsim_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Anɑkiibɛ bɛɛ̀ kɛ̀ bo, ti do bo bɛ ììkɛ̀ kɛ do nyɛcɑ́dúɔ̀ nyɛ, kɛ̀ bɛ̀ múnkɛ mmɛ nti wúó. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Kɛ̀ Isidɑyɛɛribɛ kó ditĩ̀nnìi tiitɛ́ yɛdɑbùò nkɛ́ nyié nkɛ kuɔ̀ nkɛyènkɛ̀ kɛmɔu, ");
INSERT INTO tbzsim_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","kɛ́nkpɑnnɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ nɑ́ɑ́ nkɛ tú: Kɛ̀ ti do nku Esibiti nwe yoo dikpɑ́ɑ̀ miɛkɛ dɛ̀ ntɔ̃ũ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Bɑ nte kɛ̀ ti Yiɛ̀ nKuyie nti tɔní dikpɑ́ɑ̀ diì mmiɛkɛ kɛ̀ ti dootitɔbɛ̀ bo ti kuɔ kɛ́hɛí ti pobɛ̀ nɛ̀ ti bí? Kɛ̀ ti wɛ̃̀tɛ Esibiti dɛ̀ bɑ́ ntɔ̃ũɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Kɛ̀ bɛ̀ nnɑ́ɑ́ mbɛtɔbɛ̀ kɛ tú: Tí tɑ̃ɑ̃tɛ́nɛ̀ wèè bo ntú ti kóo kpɑ̀ɑ̀tì kɛ́wɛ̃tɛ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ do kɛ́sĩ́nnɔ́ɔ Isidɑyɛɛribɛ bɛmɔu ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Kɛ̀ Nunni birɛ Sosuwee nɛ̀ Yefundee birɛ Kɑdɛbu bɛ̀ɛ̀ do kɔ̀tɛ kɛ́pɑɑtɛ́ kɛtenkɛ̀ kɛ̀ bɛ̀ɛ kɛ̃rí bɛ yɑ̀ɑ̀tì, ");
INSERT INTO tbzsim_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","kɛ́nɑ́kɛ́ Isidɑyɛɛribɛ bɛmɔu tĩ̀nnì kɛ dɔ̀: Kɛtenkɛ̀ ti kɔ̀tɛ kɛ yɑ̀ kɛ̀, kɛ̀ tu kɛtensɑ̀ɑ̀kɛ̀ nkɛ, dihɛì sɑ̀ɑ̀rì mɔ́mmɔnni. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ti Yiɛ̀ nKuyie nti kómmúmu kɛ yóó ti tɑnnɛ́ dɛ kó kɛtenkɛ̀ mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃̀ nkɛ̀, kɛ́ kɛ̀ nti duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ti bɑ́ɑ́ tuutɛnɛ̀ Kuyie, ti bɑ́ɑ́ yɔtɛ dɛ kó kɛtenkɛ̀ kɔbɛ. Ti yóó bɛ̀ ɑutɛ́mu dimɔ̀nnì dìmɑ́ɑ̀ miɛkɛ. Bɛ bɔkɛ̀ cokɛ́mu! Ti Yiɛ̀ nKuyie nti bonɛ̀mu, di bɑ́ mbɛ̀ dé. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛ bɛmɔu tĩ̀nnì nnɑ́ɑ́ nkɛ́tú, bɛ̀ bo búɔ́tí Mɔyiisi nɛ̀ Anɔɔ yɛtɑ̃́rɛ̀ kɛ́kuɔ. Bɛ̀ kpɑɑ́ mɛ nnɑ́ɑ́ nkɛ̀ ti Yiɛ̀ nKuyie nkó tikpetìi cútɛ́ní mɛtɑummɛ̀ tou ĩ́nkɛ̀ Isidɑyɛɛribɛ bɛmɔu nuɔ mmiɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́inɛ̀ Mɔyiisi kɛ dɔ̀: Dɛ̀ yó nkɑ̃́ɑ̃́kɛ́ dɛ kɛ̀ bɛ nnìtìbɛ̀ yóu bɛ̀ bo nni nsenkumɛ̀? Dɛ̀ yó nkɑ̃́ɑ̃́kɛ́ dɛ kɛ̀ bɛ̀ɛ yie n kpɛti? M mɛ ndɔ̀ɔ̀mu tidiɛtì bɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","N yóó bɛ̀ bɔntɛ́ mutenkṹṹ mmu kɛ̀ bɛ̀ɛ kú kɛ́deè pɑ́í pɑ́í kɛ̀ n duɔ́ nkɑ̀ɑ botíi sṹṹ nkɛ́ bɛ̀ pɛ̃ɛ̃tɛ́, kɛ́kpenkɛ kɛ́ bɛ̀ pɛ̃ɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Kɛ̀ Mɔyiisii nɑ́kɛ́ ti Yiɛ̀ nKuyie nkɛ dɔ̀: Esibiti kɔbɛ kèèmu fɔ̃́ɔ̃̀ dènnɛmɛ̀ ɑ nìtìbɛ̀ bɛ ɛì miɛkɛ nɛ̀ ɑ kó muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Dihɛì diì nkɔbɛ kèèmu fɔ̃́ ti Yiɛ̀ nKuyie nhɑ bɛ̀ bonɛ̀mɛ̀ kɛ bɛ̀ bɛnkú ɑmɑ́ɑ̀, kɑ̀ɑ wɛtirì ɔ̃ mbɛ̀ dìɛ́kɛ́ kuyie nkɛ́ mbɛ̀ mí kɛyènkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Kɑ̀ɑ bɛ̀ kùɔ́ dimɔ̀nnì dìmɑ́ɑ̀ miɛkɛ, bɛ̀ɛ̀ do kèè bɛ̀ nɑ̀ɑ́mmɛ̀ ɑ kpɛ́í mbɛ̀ bo yĩ́, ");
INSERT INTO tbzsim_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","fɔ̃́ nti Yiɛ̀ nKuyie nhɑ yĩɛ̃kɛ ɑ bo bɛ̀ tɑnnɛ́mɛ̀ mmɛ kɛtenkɛ̀ ɑ do yɛ̃ nhɑ yóó bɛ̀ duɔ́ nkɛ̀, dɛɛ̀ te kɑ̀ɑ bɛ̀ kùɔ dikpɑ́ɑ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","N Yiɛ̀ nKuyie n dɑ bɑ́ɑ́mmu, bɛnkɛ ɑ wɛ̃rímú ɑ bɛ́i nkɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","A bɛ́immu kɛ tú fɔ̃́ nti Yiɛ̀ nKuyie nhɑ miɛkɛ boo, kɑ̀ɑ sɑ̀ɑ̀ ndɛu, kɛ̀ bɛnìtìbɛ̀ ɔ̃ ndɑ cɑɑ̀ri kɛ yetírí ɑ kpɛti, kɑ̀ɑ mmi ɑ mɛ nhɔ̃ í nwúónko oyɛiwe kɛ ɔ̃ɔ̃ kpetínnɛ́ ibí i yɛmbɛ̀ yɛi nkpɛ́í nnɛ̀ bɛ yɑɑ̀bí kó iyɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ti Yiɛ̀ nKuyie nhɑ sémmɛ̀ dɛumu, cĩ́ɛ̃́ mbɛ kɛ́ndònnɛ̀ ɑ bɛ̀ cĩ̀ɛ̃́nkomɛ̀ nɛ̀ bɛ̀ yɛ̀mɛ̀ Esibiti kɛ tùɔ̀kɛnní yíe. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Kɛ̀ ti Yiɛ̀ nKuyie ndɔ̀: A mɛ̀ nni mbɑ́ntɛ̀mɛ̀ m bɛ̀ cĩ̀ɛ̃́mmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Mí ndi Yiɛ̀ nKuyie m bomu! Kɛ̀ n kpetì pìɛ́kɛ́ kutenkù kumɔu dɛ̀ bɑ́ɑ́ pɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","Bɛ̀ɛ̀ kó dimɑ̀ɑ̀ yɑ̀ n kpetì nɛ̀ n dɔ̀ɔ̀ tìì diɛtì Esibiti nɛ̀ dikpɑ́ɑ̀ miɛkɛ, nɛ̀ mɛmmɛ kɛ cĩ́ɛ̃́kɛ́ kɛ n yɑ́ú kɛ tùɔ̀kɛ kucɛ tɛpíítɛ̀ bɑ́ bɛ̀ í yie n kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","M pɑrìkɛ̀mu bɛ kóò mɔù bɑ́ɑ́ yɑ̀ dihɛì n do yɛ̃ n yóó duɔ́ ndì bɛ yɛmbɛ̀, bɛ̀ɛ̀ n sènkɛ̀rì, bɛ kóò mɔù bɑ́ɑ́ dì yɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","N kóo tɔ̃ntì Kɑdɛbu yie kó mɛyɛ̀mmɛ̀ mɛ ncɑ̃̀ɑ̃́mmɛ̀, kòò yié n kpɛti timɔu, n yóo ò tɑnnɛ́mu dɛ kó dihɛì ò kɔ̀tɛ kɛ yɑ̀ dì, kòo yɑɑ̀bí di tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Amɑdesiibɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ mɛ̀ mbomɛ̀ kubiriku bíɛ́kɛ̀ kó yɛhɛkɛ̀, di nɑɑ kɔ́ntɛ́ kɛ́yɛ̀ dikpɑ́ɑ̀ kɛ́tũnnɛ kucɛ kùù yìɛ̀nɛ̀ tipèntì kóo dɑ̀mɛ́ɛ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́inɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","Dɛ̀ yó nkɑ̃́ɑ̃́kɛ́ dɛ kɛ̀ kubotí yɛiku kuù nyóu kù bo nni nkpɑ̀nnɛ̀mɛ̀ kɛ yetírí n kpɛti? N kèèmu bɛ̀ tùùtɛ kɛ nɑ́ɑ́ ntì. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Nɑ́kɛ́ bɛ kɛ dɔ̀ n tú: Mí ndi Yiɛ̀ nKuyie m bomu kɛ̀ míì bɛ́i, n yóó di dɔɔ̀ di nɑ̀kɛ́ tìnti. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Di yóó kú dikpɑ́ɑ̀ miɛkɛ nkɛ díndi bɛ̀ kɑ̀ɑ mbɛ̀ kó dimɑ̀ɑ̀ kɛ́túótɛ́ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko. Díndi bɛ̀ɛ̀ kó dimɑ̀ɑ̀ tùùtɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","di í tɑti kɛtenkɛ̀ n do bɛ́i nkɛ́pɑrìkɛ̀ kɛ dɔ̀ n yóó di duɔ́ nkɛ̀, kɛ̀ dɛ̀ í tú Yefundee birɛ Kɑdɛbu nɛ̀ Nunni birɛ Sosuwee. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Di yɑɑ̀bí di do yɛ̃ mbɛ̀ yóó di kuɔ kɛ́hɛí ì, n yóó i ntɑnnɛ́ kɛtenkɛ̀ di sènkɛ̀rì kɛ̀, kɛ̀ ìi kɛ̀ tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Kɛ̀ díndi biɛ di yóó kú dikpɑ́ɑ̀ miɛkɛ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Di n yetɛ mɛ̀ɛ̀ kpɛ́í nte kɛ̀ di bí yó nhɑ̃́ɑ̃́ ndikpɑ́ɑ̀ miɛkɛ kɛ dɔ̀ yɛbie nsipísìnɑ̀ɑ̀ kɛ fɛ̃́ũ̀rì kɛ bɑɑnɛ̀ di bo kúmɛ̀ dimɔu kɛ́deè. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Yɛwe sipísìnɑ̀ɑ̀ di do dɔ̀ɔ̀ yɛ̀ di kɔ̀tɛ dìì mɔ̀nnì kɛ bo pɑɑtɛ́ kɛtenkɛ̀, yɛ̀ bo nɑɑ́ nyɛbie nsipísìnɑ̀ɑ̀. Dibenni dìmɑ́ɑ̀ diyiè dìmɑ́ɑ̀ kpɛ́í, di bo yɑ̀ di yɛi nkó tiyeti kɛ́bɑntɛ́ di bo yetɛmɛ̀ n kpɛti dɛ̀ mɔ̀kɛ mùù cɔ̃́ntimu. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Mí ndi Yiɛ̀ nKuyie mmíì bɛ́i nkɛ yóó tì dɔ̀ɔ̀, kubotí yɛiku kuù nkɔbɛ bɛ̀ɛ̀ wɛ̃nnɛ́ kɛ yetɛ n kpɛti, bɛ̀ yóó kú dikpɑ́ɑ̀ dii mmiɛkɛ nkɛ, bɑ́ òmɔù bɑ́ɑ́ súɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Dɛ kó bɛnìtìbɛ̀ Mɔyiisi do tɔ̃ mbɛ̀ kɛ̀ bɛ̀ɛ kɔtɛ kɛ́pɑɑtɛ́ dihɛì kɛ́wɛ̃tɛní kɛ́sukú bɛtɔbɛ̀ kɛ̀ bɛ̀ɛ tuutɛ kɛ́nsĩnkùnko dɛ kó kɛtenkɛ̀ bɛ̀ kɔ̀tɛ kɛ yɑ̀ kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","Bɛ̀ɛ̀ do tùùtɛ kɛ nnɑ́ɑ́ ntìì í wenni dɛ kó kɛtenkɛ̀ kpɛ́í ti Yiɛ̀ nKuyie ndo bɛ̀ potɛ́mu kɛ̀ bɛ̀ɛ do ku ììkɛ̀ kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Nunni birɛ Sosuwee nɛ̀ Yefundee birɛ Kɑdɛbu bɛɛ̀ do kpɑɑ́ kɛ í nku bɛ̀ɛ̀ do kɔ̀tɛ kɛ́pɑɑtɛ́ kɛtenkɛ̀ bɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Kɛ̀ Mɔyiisii kɔtɛ kɛ́nɑ́kɛ́ Isidɑyɛɛribɛ bɛmɔu ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì kɛ̀ bɛ̀ɛ tiitɛ́ yɛdɑbùò. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ bɛ̀ɛ pikɛ cutɛ kɛ́dekɛ ditɑ̃rì ĩ́nkɛ̀ kɛ́nnɑ́ɑntɛ kɛ tú: Ti bɑntɛ́mu ti cɑ̀ɑ̀rɛ̀mɛ̀, ti nɛ́ bɑ̀ɑ́tímu kɛ kɔri ti Yiɛ̀ nKuyie nti duɔ́ ndìì ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Kɛ̀ Mɔyiisii bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di dɔ́ kɛ́yetɛ ti Yiɛ̀ nKuyie nkpɛti. Di í yóó nɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Bɑ́ɑ́ kɔtɛnɛ̀ ti Yiɛ̀ nKuyie nyí di bonɛ̀, di bɑ́ɑ́ bennɛ́ kɛ́kɔtɛ kɛ̀ di dootitɔbɛ̀ di kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amɑdesiibɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ bɛ̀ɛ̀ bo di ììkɛ̀, bɛ̀ yóó di fíému, di bùtínnɛ́mu ti Yiɛ̀ nKuyie, kù tɛ̃́nkɛ í di bonɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Kɛ̀ Isidɑyɛɛribɛɛ yetɛ kɛ́kpénkùnnɛ bɛ to kɛ dɔ̀: Ti deètìmu ditɑ̃rì ĩ́nkɛ̀ kó kutempɛ̃. Kɛ̀ Mɔyiisi yie mɛ nni nkpɑɑ́ bɛ kɑrì nɛ̀ Kuyie ntɑummɛ̀ tɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Mɛm̀mɛ Amɑdesiibɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ cùtɛ́nímɛ̀ kɛ́potɛ́ Isidɑyɛɛribɛ kɛ́ mbɛ̀ bɛ̀tì kɛ kɔù kɛ́tuɔkɛnɛ̀ Ɔdimɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀ n tú: Kɛ̀ di tɑ dìì mɔ̀nnì kɛtenkɛ̀ n yɛ̃ n yóó di duɔ́ nkɛ̀ kɛ̀ dí mbo, ");
INSERT INTO tbzsim_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kɛ̀ di yó n féútɛ́ fɛɔ̃̀fɛ̀ kɛ́tuɔ nyoo mɛtɑummɛ̀ kpɛ́í, kòò mɔù mɛ nyó n féútɛ́ fɛɔ̃̀fɛ̀ ò n cɑ̀nnɛnɛ̀ dìì nùù kpɛ́í, yoo ò bɑɑ dɔ́ kɛ́ m pɑ̃ dipɑ̃nnì ndi, yoo dibɑnni mɑrì kpɛ́í, kòò yó n féútɛ́ fɛɔ̃̀fɛ̀ diɛfɛ̀ nfɛ, yoo fɛsɑ́m̀pɔ́fɛ̀, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti, ");
INSERT INTO tbzsim_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","wèè te fɛɔ̃̀fɛ̀ wèe wɑɑ́ mmuyuo nsɑ̀ɑ̀mù cìdóò bɛ̀tɑ̃ɑ̃ti kɛ́ mù ɑ̃̀ntɛnɛ̀ mɛkɔsɑ̀ɑ̀mɛ̀ dítìrì nɛ̀ dikéè. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Kɛ̀ dipebii mɛ nni ndi dɛ yiɛ̀ ndɔ́ kɛ́ n féútɛ́mɛ̀ kɛ́tuɔ nyoo mɛtɑummɛ̀ kpɛ́í, wèe wɑɑ́ mmɛnɑɑ̀ ndítìrì òmɑ́ɑ̀ nɛ̀ dikéè. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Kɛ̀ dipedɑɑ̀ mɛ nni ndi wèe wɑɑ́ mmuyuo nsɑ̀ɑ̀mù cìdóò bɛ̀kuɔ̀ kɛ́ mù ɑ̃̀ntɛnɛ̀ mɛkɔsɑ̀ɑ̀mɛ̀ dítìrì bɛ̀dɛ́bɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","kɛ́yɔɔrɛnɛ̀ mɛnɑɑ̀ ndítìrì bɛ̀dɛ́bɛ̀. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kɛ̀ fɛnɑ̀ɑ̀fɛ̀ mɛ nni nfɛ ò yó n féútɛ́mɛ̀ kɛ́tuɔ nyoo mɛtɑummɛ̀ kpɛ́í, yoo ò dɔ́ kɛ́ n féútɛ́ fɛɔ̃̀fɛ̀ ò n cɑ̀nnɛnɛ̀ dìì nùù kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","Dinɑɑdɑɑ̀ dìmɑ́ɑ̀ wèe wɑɑ́ mmuyuo ncìdóò bɛ̀wɛi, kɛ́ɑ̃ntɛnɛ̀ mɛkùɔ̀ ndítìrì bɛ̀tɑ̃ɑ̃ti, ");
INSERT INTO tbzsim_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","kɛ́yɔɔrɛnɛ̀ difɛ̃́ɛ̃̀ dítìrì bɛ̀tɑ̃ɑ̃ti. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","12","Bɑ́ kɛ̀ ì sũ kɛ mɑmɛ̀ di yó mmɛ ndɔɔri bɑ́ fɛ̀ɛ̀ ɔ̃̀fɛ̀ ĩ́nkɛ̀ kɛ́ntũ nfɛ kuɔ́ duɔ́ kɛ dòmmɛ̀, kɛ̀ fɛnɑ̀ɑ̀fɛ̀ nfɛ yoo dipedɑɑ̀ yoo dipedɑbii yoo tɛbuɔtɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Isidɑyɛɛribɛ níí yóó mɛ ndɔɔ̀ bɛ̀ m pɑ̃ɑ̃ nyɛ̀ɛ̀ pɑ̃rɛ̀ kɛ tuɔ̀. Yɛpɑ̃rɛ̀ nyɛ yɛ̀ɛ̀ kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ bo di cuokɛ̀ yoo bɛ̀ɛ̀ kó bɛyɑ̀ɑ̀rìbɛ̀ do kɔ̀tɛní kɛ́ ndi bonɛ̀, bɛ miɛkɛ kòò mɔù dɔ́ kɛ́ m pɑ̃ mí ndi Yiɛ̀ nKuyie ndipɑ̃nnì kɛ́tuɔ ò yóó mɛ ndɔɔ̀. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Dɛ kó ikuɔ́ yó mbomu ditĩ̀nnì dimɔu kpɛ́í nsɑ̃́ɑ̃̀ nɛ̀ di yɑɑ̀bío opɔ̀ɔ̀ kpɛ́í nnɛ̀ tɛhɛikɛ̀mbitɛ kpɛ́í. Tɛhɛikɛ̀mbitɛ dɔɔrimɛ̀ opɔ̀ɔ̀ yóó mmɛ ndɔɔri. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Ikuɔ́ imɑ́ɑ̀ yó nni nyi mɛdɔɔ̀rìmɛ̀ mɛmɑ́ɑ̀, díndi nɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ di bonɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀ n tú: Kɛ̀ di tɑ dìì mɔ̀nnì kɛtenkɛ̀ n di kɔrinɛ̀ kɛ̀ɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","Kɛ̀ di dɔ̀ɔ̀ pɛ̃́ɛ̃̀bɛ̀ kɛ bo cɑ́ɑ́kɛ́, dí dɛitɛ mí ndi Yiɛ̀ nKuyie n kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","21","Kɛ̀ di níí nɑ̀ɑ mmuyuo kɛ dɔ̀ɔ̀ tipɛ̃́mpɛ̃ńtì dí dɛitɛ n kɔku, di ɔ̃ɔ̃ dɛitɛ mɛ̀ɛ̀ botí tidiketitì miɛkɛ n kpɛti, di tì puotì dìì mɔ̀nnì kuyiɛ́. Di yó mmɛ ndɔɔri sɑ̃́ɑ̃̀ nɛ̀ di yɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́i nkɛ dɔ̀: Kɛ̀ dɛ̀ dò ndɛ̀ di kpɛtɛ́nɛ̀ kɛ di yetɛnɛ̀ n duɔ́ nyìì kuɔ́ Mɔyiisi kòò ì ndi tùo i kó ìmɑì, kɛ́túótɛ́ yíe nnɛ̀ di bo mbomɛ̀ nɛ̀ di yɑɑ̀bío, ");
INSERT INTO tbzsim_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","kɛ̀ dɛ̀ dò ndɛ̀ kpɛtɛ́nɛ̀ òmɔù kɛ̀ ditĩ̀nnì dimɔu í yɛ̃́ kɛ yetɛ́nɛ̀ ikuɔ́ mɑì, di wɛ̃nnɛ́ kɛ́wɑɑ́ ndinɑɑdɑɑ̀, kɛ́ dì nni nféútɛ́ kɛ́wɛ̃nnɛ́nɛ̀ muyuo mmùù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ nnɛ̀ mɛnɑɑ̀ kɛ́tuɔ nyikuɔ́ yɛ̃mmɛ̀. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti, dí wɑɑ́nnɛ̀ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kɛ̀ ikuɔ́ nìùtìi dɔɔ̀ ditĩ̀nnì dimɔu mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́, kɛ̀ n di cĩ́ɛ̃́ nkɛ yɛ̃́ dɛ̀ di kpɛtɛ́nɛ̀mɛ̀mu. Kɛ̀ dí tɔní di diitì kó yɛpɑ̃rɛ̀ di yó m pɑ̃ yɛ̀ kɛ́tuɔ, kɛ́fíénɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó iwũɔ̃ kɛ yɛ̃́ dɛ̀ di kpɛtɛ́nɛ̀mɛ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Dɛ mɔ̀nnì n yóó di cĩ́ɛ̃́mmu di yɛi ndíndi Isidɑyɛɛribɛ nɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ di bonɛ̀ kɛ yɛ̃́ dɛ̀ di kpɛtɛ́nɛ̀mu dimɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Kɛ̀ dɛ̀ mɛ ndò ndɛ̀ kpɛtɛ́nɛ̀ onìtì òmɑ́ɑ̀ ndi kòò dɔ̀ɔ̀ mɛyɛi nwèe wɑɑ́ ndibɔsɛrì dìì mɔ̀kɛ dibenni dìmɑ́ɑ̀ kɛ́ dì nni nféútɛ́ o yɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Kɛ̀ ikuɔ́ nìùtìi ò dɔ̀ɔ̀ mɛyɛi nhũtímù kó ikuɔ́ mɛtɑummɛ̀ tou ììkɛ̀ kɛ̀ nhò cĩ̀ɛ̃́, ");
INSERT INTO tbzsim_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","díndi Isidɑyɛɛribɛ kɛ̀ di kóò mɔù nwe yoo opɔ̀ɔ̀ wèè di bonɛ̀ ikuɔ́ imɑ́ɑ̀ yóó nni nyi ìì tukúnɛ̀ dɛ̀ bo kpɛtɛ́nɛ̀ wè, kòo yetɛ́nɛ̀ ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Kɛ̀ wèè yie bo ncɑɑ̀ri kɛ yɛ̃́, kòò tu Isidɑyɛɛri nwe yoo ò tu opɔ̀ɔ̀ ò cɑ̀ɑ̀rɛ̀ mí ndi Yiɛ̀ nKuyie mmí nwe. Dí ò dènnɛ di cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Dɛ kóo nìtì botí ò sènkɛ̀rì mí ndi Yiɛ̀ nKuyie n nɑ́ɑǹtì nti kɛ cɑɑri n kuɔ́, dí ò dɛ̀itɛ di cuokɛ̀, o yɛi mbo o yuu ĩ́nkɛ̀ nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Isidɑyɛɛribɛ do bo dìì mɔ̀nnì dikpɑ́ɑ̀ miɛkɛ, diyiè mɑrì kɛ̀ bɛ̀mɑbɛ̀ɛ yɑ̀ òmɔù kòò kɑu idɛí tɛom̀pùtɛ̀ yiè ");
INSERT INTO tbzsim_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","kɛ̀ bɛ̀ɛ ò kɔ̀tɛnɛ̀ Mɔyiisi nɛ̀ Anɔɔ nɛ̀ Isidɑyɛɛribɛ sɔmbɛ borɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","kɛ́duɔ́ nkɛ̀ bɛ̀ nhò bɑ̀ɑ kɛ yɛ̃́ ikuɔ́ mu ndo í nɑ̀kɛ́mɛ̀ bɛ̀ dò nkóò dɔ̀ɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Dɛ kóo nìtì dò nkɛ́kuɔ̀mu, Isidɑyɛɛribɛ dimɔu dí ò dènnɛ di kó dikɑrì kóò bùɔ́tí yɛtɑ̃́rɛ̀ kɛ́kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Mɛm̀mɛ kɛ̀ ditĩ̀nnì dimɔuu ò dènnɛ bɛ kɑrì kɛ́ nhò buɔti yɛtɑ̃́rɛ̀ kòò yɑ̀ɑ kúnɛ̀, ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́mɛ̀ Mɔyiisi kɛ nyɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","Á nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀ n tú: Díndi nɛ̀ di yɑɑ̀bío di nhɑ̃ɑ̃̀ iyɑɑ̀yuɔ́ ndi yɑ̀ɑ̀tì, kɛ̀ di níí yɑ ntiyɑ̀ɑ̀tì di ɑ̃nnɛ́ mupɑɑ̀kómmú mùù wũɔ̃ tiɔ̃̀tì tìì dònnɛ̀ tibedɛncɛ̃ɛ̃̀tì mu kó iyúɔ́ nti mɑ̀nkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Di yɑ̀ɑ̀tì níí nhɑ̃ iyúɔ́ nkɛ̀ di nyì yɑ̀u kɛ denniní n kuɔ́ mí ndi Yiɛ̀ Kuyie nkɛ tũ nyì yɛ̃mmɛ̀, kɛ bɑ́ ndɔɔri di yɛ̀mmɛ̀ dɔ́ dɛ̀ nɛ̀ di nuɔ ndɔ́ dɛ̀, dɛ̀ yɑ̀ɑ̀ bo nte kɛ̀ dí m bútínnɛ́ mí ndi Yiɛ̀ nKuyie. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Mɛm̀mɛ di bo ndennimɛ̀ n tɑnnɔ̀ yɛmɔu. Kɛ dɔɔri yɛ̀ yɛ̃mmɛ̀ kɛ̀ dɛ̀ɛ bɛnkɛ kɛ dò ndi cɑ̃́ɑ̃́ nkɛ tú n kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Mí ndi Yiɛ̀ nKuyie m míì di te kɛ di dènnɛní Esibiti kɛ̀ di bo ntú n kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Defii mɔù Keɑti nɑɑ̀mùnkù kou weè do pɛitɛ́ Isɑɑdi kɛ̀ Isɑɑdi pɛitɛ́ Kodee. Kòo sukú Dubɛnni nɑɑ̀mùnkù kɔbɛ bɛ̀tɑ̃ɑ̃ti, Ediɑbu bí Dɑtɑnni nɛ̀ Abidɑmmu nɛ̀ Pedɛti birɛ Onni. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Nɛ̀ Isidɑyɛɛribɛ sikɔusìdɛ́ nɛ̀ sipísìnùmmù (250), bɛ̀ɛ̀ do tú bɛ botí miɛkɛ bɛkótíbɛ̀ kɛ ni bɛ tĩ̀rɛ̀ kɛ̀ bɛ yètɛ̀ feí. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Kɛ̀ bɛ̀ɛ cɛ̃ɛ̃tɛ Mɔyiisi nɛ̀ Anɔɔ kɛ́ mbɛ̀ kpɑ̀nnɛ̀ kɛ tú: Di tɛrɛ̀ tontɛ́mu Isidɑyɛɛribɛ botí kumɔu tu Kuyie nkɔbɛ mbɛ, kɛ̀ kù bɛ̀ bonɛ̀. Dɛ̀ yĩmɛ kɛ̀ di dɔ́ kɛ́ nti bɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Mɔyiisi kèè dìì mɔ̀nnì dɛ kó tinɑ́ɑǹtì kɛ́do kɛ́sĩ́nnɔ́ɔ kɛtenkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","kɛ́nɑ́kɛ́ Kodee nɛ̀ o kó ditĩ̀nnì kɔbɛ kɛ dɔ̀: Nɑnkɛ dikṹnweńnì ti Yiɛ̀ nKuyie mbo bɛnkɛ wèè tu ku kou, kù tɑ̃ɑ̃tɛ́ wè koò cɑ̃̀ńnɛ́, kòò bo nkù tɔkunɛ̀, dɛ yiɛ̀ nweè yó nkù tɔkunɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Nɛ́ ntɛ di dò nkɛ́dɔɔ̀mɛ̀: Fɔ̃́ nKodee nɛ̀ ɑ kó ditĩ̀nnì kɔbɛ bɛmɔu túótɛ́nɛ̀ sisɔɔsékɛ́búkúsí, ");
INSERT INTO tbzsim_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","di nɑɑ sì ɑ̃nnɛ́ muhɑ̃ɑ̃́ nkɛ́yɔɔrɛ tihúúntì mu ĩ́nkɛ̀ ti Yiɛ̀ nKuyie ntɑummɛ̀ tou ììkɛ̀, kɛ̀ tí yɑ̀ ti Yiɛ̀ nKuyie nyóó tɑ̃ɑ̃tɛ́ wè, wèè tu ku kou kù cɑ̃̀ńnɛ́ wè. Díndi Defiibɛ di kpɛrɛ dɛɛ̀ tontɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Kɛ̀ Mɔyiisii wɛ̃tɛ kɛ́nɑ́kɛ́ Kodee kɛ dɔ̀: Kéntɛ́nɛ̀ díndi Defiibɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","dɛ̀ í di sɑ̀nnɛ̀ ti Yiɛ̀ nKuyie nyIsidɑyɛɛribɛ tũ̀ nkù di tɑ̃ɑ̃tɛ́mɛ̀ Isidɑyɛɛribɛ botí miɛkɛ, kɛ di yu kɛ di dɔ̀ɔ̀ ku tɔ̃mbɛ̀ kɛ̀ di pĩ́ nku tɑummɛ̀ tou miɛkɛ ku tɔ̃mmú nɛ̀ Isidɑyɛɛribɛ bɛmɔu kó diyètìrɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Kuyie ndɑ yu fɔ̃́ nKodee nɛ̀ ɑ kɔbɛ Defiibɛ bɛmɔu kɛ̀ di kù tɔ̀kɛ́nɛ̀ kɛ̀ di nɛ́ tontɛ́ kɛ wɑnti kɛ́nɑɑ́ nyikuɔ́ nìùbɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Fɔ̃́ nnɛ̀ ɑ kó ditĩ̀nnì kɔbɛ di kpɑnnɛ̀ ti Yiɛ̀ nKuyie nku. Anɔɔ tu we kɛ̀ di bo nhò sɛí? ");
INSERT INTO tbzsim_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Kɛ̀ Mɔyiisii tɔ̃ nkɛ̀ bɛ̀ bo yúní Ediɑbu kó ibí Dɑtɑnni nɛ̀ Abidɑmmu kɛ̀ bɛ̀ɛ ò tɛ̃̀ńnɛ́ kɛ dɔ̀: Ti í kɔroo? ");
INSERT INTO tbzsim_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","A ti dènnɛní mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ dɛ̀ pũɔ̃̀ ndɛ̀, kɛ ti kɔ̀tɛnní dikpɑ́ɑ̀ tɛdɔntɛ̀ tiɛ̀ mmiɛkɛ kɛ̀ dɛ̀ í dɑ sɑ̀nnɛ̀ kɑ̀ɑ wɛ̃̀tɛ kɛ dɔ́ kɛ́ nti kpɑɑtìrɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ti yetɛmu! Bìtì bìtì ɑ í ti niitɛ́ mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃̀ ndɛ̀, ɑ mɛ nyí ti duɔ́ nkɛtenkɛ̀ nɛ̀ dɛpɑɑ nnɛ̀ fínyĩ̀ kó dɛtie. A ti wúó ntiyũ̀ɔ̃̀ntì ntɑɑ̀? Ti í kɔroo! ");
INSERT INTO tbzsim_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Kɛ̀ Mɔyiisi miɛkɛɛ cɔ́útɛ́ mɛdiɛ̀ nkòo nɑ́kɛ́ ti Yiɛ̀ nKuyie nkɛ dɔ̀: A bɑ́ɑ́ cɔutɛ́ bɛ pɑ̃rɛ̀, n yí cɔutɛ́ bɛ mɔù kóo sɑ̃mmɑrímú, m mɛ nyí yetɛ́nɛ̀ òmɔù. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mɛm̀mɛ kɛ̀ Mɔyiisii nɑ́kɛ́ Kodee kɛ dɔ̀: Nɑnkɛ fɔ̃́ nnɛ̀ ɑ kó ditĩ̀nnì kɔbɛ nɛ̀ Anɔɔ, dí kɔtɛní kɛ́cómmú mɛtɑummɛ̀ tou ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","A kɔbɛ sikɔusìdɛ́ nɛ̀ sipísìnùmmù (250), bɑ́ wè wèe túótɛ́ o sɔɔsékɛ́buutɛ kɛ́ɑ̃nnɛ́ tihúúntì kɛ́tɔní ti Yiɛ̀ nKuyie tou ììkɛ̀, fɔ̃́ nKodee nɛ̀ Anɔɔ kɛ̀ di múnkɛ mɛ ndɔɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Kɛ̀ Kodee tíí nyIsidɑyɛɛribɛ nɛ̀ o kɔbɛ kɛ̀ bɛ̀ɛ yie mbɑ́ wè kòo túótɛ́ o sɔɔsékɛ́buutɛ kɛ́ɑ̃nnɛ́ muhɑ̃ɑ̃́, nkɛ́yɔɔrɛ tihúúntì muhɑ̃ɑ̃́ nyĩ́nkɛ̀ kɛ́kɔtɛ kɛ́cómmú mɛtɑummɛ̀ tou bòrìnùù, Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ múnkɛ mɛ ndɔɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Kɛ̀ Kodee tíí nyIsidɑyɛɛribɛ bɛmɔu Mɔyiisi nɛ̀ Anɔɔ bɛ ììkɛ̀ mɛtɑummɛ̀ tou bòrìnùù. Kɛ̀ ti Yiɛ̀ nKuyie nkó tikpetìi cútɛ́ní bɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","Kɛntɛ́nɛ̀ dimɑ́ɑ̀ dɛ kó bɛnìtìbɛ̀, n yóó bɛ̀ kùɔ̀mu dimɔ̀nnì dimɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ do kɛ́sĩ́nnɔ́ɔ kɛtenkɛ̀ kɛ́kuɔ́nko kɛ dɔ̀: Áú Kuyie! Fɔ̃́ nwèè duɔ̀ mmufòmmu dɛ̀ɛ̀ kó dimɑ̀ɑ̀ fòù, ɑ miɛkɛ bo do kubotí kumɔu onìtì omɑ́ɑ̀ kó mɛcɑɑ̀rìmɛ̀ kpɛ́ínɑ́ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","Á nɑ́kɛ́ Isidɑyɛɛribɛ botí kumɔu kɛ dɔ̀: Bɛ̀ɛ kɛntɛ́nɛ̀ Kodee cĩ́ɛ̃̀tɛ̀ nɛ̀ Dɑtɑnni nɛ̀ Abidɑmmu bɛ kpɛsi. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mɛm̀mɛ kɛ̀ Mɔyiisii ítɛ́ kɛ́nkɔri Dɑtɑnni nɛ̀ Abidɑmmu bɛ borɛ̀ kɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ ò tũ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Kòo nɑ́kɛ́ ditĩ̀nnì kɛ dɔ̀: Kɛntɛ́nɛ̀ bɛnitidɔnnibɛ̀ biɛ ncɛ̃́ĩ borɛ̀, di bɑ́ɑ́ kɑ́ɑ́kɛ́ dɛ̀mɑrɛ̀ dɛ̀ɛ̀ tu bɛ kpɛrɛ di yɑ̀ɑ̀ bo kú bɛ kó mɛcɑɑ̀rìmɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Kɛ̀ bɛ̀ɛ ítɛ́ kɛ dɛ́tɛ́nɛ̀ Kodee cĩ́ɛ̃̀tɛ̀. Dɑtɑnni nɛ̀ Abidɑmmu bɛ̀ do yɛ̀nní kɛ́ncómmú bɛ touti bòrɛ̀ nyɛ nɛ̀ bɛ pobɛ̀ nɛ̀ bɛ bí nɛ̀ bɛ yɑɑ̀bí. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Kɛ̀ Mɔyiisii bɛ́i nkɛ dɔ̀: Di yóó bɑntɛ́ diɛ ndɛ kɛ dò ti Yiɛ̀ nKuyie nkuù n tɔ̃nní kɛ̀ m pĩ ndɛ kó mutɔ̃mmú mumɔu kɛ̀ dɛ̀ í tú m mù pĩ̀ńnɛ̀ m mɑ́ɑ̀ kó muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Kɛ̀ dɛ kó bɛnìtìbɛ̀ ku mukṹṹ mbɛtɔbɛ̀ kɔ̃ mmù kɛ í ku kɛ̀ dɛ̀ cɑ̃̀ɑ̃́nnɛ̀ bɛtɔbɛ̀ kɔ̃mmɛ̀ ti Yiɛ̀ nKuyie nkuù í n tɔ̃nní. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Kɛ̀ dɛ̀ dò nti Yiɛ̀ nKuyie mbo dɔɔ̀ tidiɛtì kpɛrɛ mɑrɛ̀, kɛ̀ kɛtenkɛ̀ɛ ɑɑtɛ kɛ́mɑɑ́nko dɛ kó bɛnìtìbɛ̀ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ tu bɛ kpɛrɛ kɛ̀ bɛ̀ɛ tɑ kudɔnkù bɛfòùbɛ̀, di bo bɑntɛ́ kɛ dò ndɛ kó bɛnìtìbɛ̀ cɑ̀ɑ̀rɛ̀ ti Yiɛ̀ nKuyie nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Mɔyiisi kpɑɑ́ kɛ mɛ nnɑ́ɑ́ nkɛ̀ kɛtenkɛ̀ɛ yɑtɛ́ bɛ̀ còḿmú dɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","kɛ́ɑɑtɛ kɛ́ bɛ̀ mɑɑ́nko bɛmbɛ nɛ̀ bɛ cɛ̃́ĩ kɔbɛ nɛ̀ Kodee nɛ̀ o kó ditĩ̀nnì kɔbɛ nɛ̀ bɛ kpɛrɛ dɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Kɛ̀ bɛ̀ɛ tɑ kudɔnkù bɛfòùbɛ̀ nɛ̀ bɛ kpɛrɛ bɛ̀ mɔ̀kɛ dɛ̀, kɛ̀ kɛtenkɛ̀ɛ mutìnnɛ. Mɛm̀mɛ bɛ̀ kpɑɑkɛmɛ̀ bɛ kɔbɛ Isidɑyɛɛribɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Bɛ̀ɛ̀ kó dimɑ̀ɑ̀ dɛ̀ bo kɛ̀ bɛ̀ɛ keè bɛ dɑbùò kɛ́ncooti kɛ tú: Tí cokɛ́nɛ̀ kɛtenkɛ̀ yɑ̀ɑ̀ bo ti mɑɑ́nko! ");
INSERT INTO tbzsim_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie ncṹũnní muhɑ̃ɑ̃́ nkɛ̀ mùù cɔ́útóo bɛnìtìbɛ̀ sikɔusìdɛ́ nɛ̀ sipísìnùmmù (250) bɛmbɛ bɛ̀ɛ̀ do tuɔ̀ ntihúúntì. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","Nɑ́kɛ́ Anɔɔ birɛ Edeɑsɑɑ ikuɔ́ nìùtì kɛ tú n yɛ̃ nwèe pṹtɛ́ sisɔɔsékɛ́búkúsí kɛ́fũũ mmuhɑ̃ɑ̃́. Kɛ yɛ̃́ bɛ̀ sì nni nduɔ́mmɛ̀mu kɛ̀ sì tu n kpɛsi. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Bɛ̀ɛ̀ sì tɔní kɛ̀ bɛ̀ ku kɛ yietí bɛ yɛi. Dí sì mɑ timɑ́tipenti kɛ́dɑri n wũɔ̃tɔ̀nnì kɛ̀ dɛ̀ ndò mmɛbɛnkùmɛ̀ Isidɑyɛɛribɛ bɛmɔu kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Kɛ̀ ikuɔ́ nìùtì Edeɑsɑɑ túótɛ́ disɔɔwũɔ̃̀ kó sisɔɔsékɛ́búkúsí dɛ kó bɛnìtìbɛ̀ do tɔní sì kɛ̀ muhɑ̃ɑ̃́ nsì cɔ̀útɛ́, kɛ̀ bɛ̀ɛ sì mɑ timɑ́tipenti kɛ́dɑri diwũɔ̃tɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Bɛ̀ do mɑ tìì mɑ́tìpenti kɛ́dɑri diwũɔ̃tɔ̀nnì tiì do denniní Isidɑyɛɛribɛ òmɔù í dòmmɛ̀ kɛ́ntuɔ̀ ntihúúntì ti Yiɛ̀ nKuyie nyììkɛ̀ kɛ̀ dɛ̀ í tú Anɔɔ nɛ̀ o yɑɑ̀bí, kɛ̀ wèè mɛ̀ dɔ̀ɔ̀ tìì tùɔ̀kɛní Kodee nɛ̀ o kɔbɛ tiì yóó ò tùɔ̀kɛní ti Yiɛ̀ nKuyie ndo mɛ ntì nɑ̀kɛ́ Mɔyiisi kòò tì mbɛ̀ nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Kɛ̀ dɛ̀ɛ̀ wentɛ́ kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ bɛ botí kumɔu kɛ́nkpɑnnɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ tú: Díì kùɔ ti Yiɛ̀ nKuyie nkɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Bɛ̀ cɛ̃̀ɛ̃̀tɛ dìì mɔ̀nnì Mɔyiisi nɛ̀ Anɔɔ kɛ́wɛ̃ɛ̃tɛ mɛtɑummɛ̀ tou bíɛ́kɛ̀ kɛ́nsɔ̃́ diwɛtirì dɑ̀tínnɛ́ mɛtɑummɛ̀ tou, kɛ̀ bɛ̀ɛ yɑ̀ ti Yiɛ̀ nKuyie nkó tikpetì. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ kɔtɛ mɛtɑummɛ̀ tou ììkɛ̀ ");
INSERT INTO tbzsim_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Yɛ̀nnɛ̀ dɛ kó ditĩ̀nnì cuokɛ̀, n yóó bɛ̀ kùɔmu dimɔ̀nnì dimɑ́ɑ̀ kɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ do kɛ́sĩ́nnɔ́ɔ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Kɛ̀ Mɔyiisii nɑ́kɛ́ Anɔɔ kɛ dɔ̀: Túótɛ́ tɛsɔɔsékɛ́buutɛ kɛ́dɛitɛ diwũɔ̃tɔ̀nnì ĩ́nkɛ̀ kó muhɑ̃ɑ̃́ nkɛ́ɑ̃nnɛ́ tɛ miɛkɛ kɛ́tuɔ ntihúúntì kɛ́cokóo ditĩ̀nnì borɛ̀, kɛ́dɔɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ kɛ yɛ̃́ ti Yiɛ̀ nKuyie mmiɛkɛ cɔ̀útɛ́mɛ̀ kɛ̀ bɛnìtìbɛ̀ ketɛ́ mukṹṹ. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Kɛ̀ Anɔɔ túótɛ́ tɛsɔɔsékɛ́buutɛ nɛ̀ muhɑ̃ɑ̃́ Mɔyiisi tì nhò nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀, kɛ́cokóo ditĩ̀nnì cuokɛ̀, kɛ́nsɔ̃́ bɛnìtìbɛ̀ ketɛ́ mukṹṹ, kòo tuɔ ntihúúntì kɛ́dɔɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́ Isidɑyɛɛribɛ kpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","kɛ́ncómmú bɛcíríbɛ̀ nɛ̀ bɛfòùbɛ̀ bɛ cuokɛ̀ kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ potɛ́ kùù yɛ̃ĩnkuu cómmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Bɛnìtìbɛ̀ bɛ̀ɛ̀ do ku bɛ̀ do bo tɛkɔupípíítɛ̀ nɛ̀ sikɔupísìnɑ̀ɑ̀ nɛ̀ sikɔusìyiekɛ̀ ndi (14700) kɛ́ nɛ́ mbúútí bɛ̀ɛ̀ do ku Kodee kó mɛcɑɑ̀rìmɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Kɛ̀ Anɔɔ wɛ̃tɛní Mɔyiisi borɛ̀ mɛtɑummɛ̀ tou bòrìnùù, kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ potɛ́ kùù yɛ̃ĩkuu cómmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","Á nɑ́kɛ́ Isidɑyɛɛribɛ wuɔ ntɛpíítɛ̀ nɛ̀ ìdɛ́ì, bɑ́ kùù wuɔ nkɛ̀ ku kóo kpɑ̀ɑ̀tì dɑ tɔní kupɑ̀ɑ̀ti. A yóó ì cuɔ́ kɛ̀ ì mbo tɛpíítɛ̀ nɛ̀ ìdɛ́ì nyi, kɑ̀ɑ wɑ̃ri bɑ́ kùù wuɔ nkóo kpɑ̀ɑ̀tì tɔní kùù pɑ̀ɑ̀ti ĩ́nkɛ̀ dɛ kó kuwuɔ nyètìrì, ");
INSERT INTO tbzsim_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","kɛ́wɑ̃ri Defii kó kupɑ̀ɑ̀ti ĩ́nkɛ̀ Anɔɔ kó diyètìrì. Mɛm̀mɛ bɑ́ kùù wuɔ nkóo kpɑ̀ɑ̀tì yó mmɔkɛmɛ̀ kupɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","A yóó ì dɔú mmɛtɑummɛ̀ tou miɛkɛ nkɛ Kuyie ntɑummɛ̀ tɔu ììkɛ̀, mí nnɛ̀ fɔ̃́ nti ɔ̃ɔ̃ mɑ́ɑ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Onìtì wèè kó kupɑ̀ɑ̀ti bo yɛ tifɑ̃ɑ̃̀tì weǹwe n tɑ̃ɑ̃tɛ́mɛ̀. Dɛ mɔ̀nnì kɛ̀ m pɑɑ nyɛsɑ̃́ɑ̃̀mbɛ̀ Isidɑyɛɛribɛ di sɑ̃́ɑ̃́ nyɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Kɛ̀ Mɔyiisii tì nɑ̀kɛ́ Isidɑyɛɛribɛ wuɔ ntɛpíítɛ̀ nɛ̀ ìdɛ́ì miɛkɛ bɑ́ kùù wuɔ nkɛ̀ ku kóo kpɑ̀ɑ̀tìi tɔní kupɑ̀ɑ̀ti bɛ wuɔ ndò ndòmmɛ̀ imɔu kɛ̀ ìì wɛ̃nnɛ́ tɛpíítɛ̀ nɛ̀ ìdɛ́ì, kɛ̀ Anɔɔ kɔku nsokɛ́ i cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Kɛ̀ Mɔyiisi ì tɑnnɛ̀ mɛtɑummɛ̀ tou miɛkɛ kɛ́ ì dɔú ti Yiɛ̀ nKuyie nyììkɛ̀ mɛtɑummɛ̀ tɔu borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Mɔyiisi mbo tuɔkoo kɛ sɔ̃́ nhAnɔɔ Defii kó kuwuɔ nkou kó kupɑ̀ɑ̀ti yɛ̀ tifɑ̃ɑ̃̀tì kɛ pòrí kɛ pɛitɛ́ yɛbɛ kɛ̀ yɛ̀ bi. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Kɛ̀ Mɔyiisii ì koutɛ́ imɔu ti Yiɛ̀ nKuyie nyììkɛ̀ kɛ́kɔtɛnɛ̀ kɛ́bɛnkɛ Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ ì yɑ̀ bɛmɔu, bɑ́ wè kòo túótɛ́ o kɔku. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Dɔú nhAnɔɔ kó kupɑ̀ɑ̀ti ikuɔ́ tɔu ììkɛ̀, kɛ̀ kù ndò ndibɛnkɛ̀rì dɛ kó itookperí yɛmbɛ̀ kpɛ́í. Dɛ mɔ̀nnì kɛ̀ m pɑɑ nyɛsɑ̃́ɑ̃̀mbɛ̀ bɛ̀ di sɑ̃́ɑ̃́ nyɛ̀, kɛ̀ yɛ̀ tùɔ̀kɛní m borɛ̀ kɛ̀ bɛ̀ tɛ̃́nkɛ bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Kɛ̀ Mɔyiisii dɔɔ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Dɛ mɔ̀nnì kɛ̀ Isidɑyɛɛribɛɛ nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Ti yóó kúmu, ti kumu kɛ dèè. ");
INSERT INTO tbzsim_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Kòò mɔù tɔ̀ɔ́nnɛ̀ mɛtɑummɛ̀ tou ò ɔ̃ɔ̃ kúmu, ti yóó mɛ nhɔ̃ nkɛ yɑ̀ɑ deèɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Anɔɔ kɛ dɔ̀: Kòò mɔù yetɛ́nɛ̀ mɛtɑummɛ̀ tou fɔ̃́ nnɛ̀ ɑ bí díì te mɛyetímɛ̀. Kòò mɔù cɑ̀ɑ̀rɛ̀ ikuɔ́ tɔ̃mmú díì te dɛ kó mɛcɑɑ̀rìmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","A yú ɑ cicɛ nɑɑ̀mùnkù kɔbɛ Defiibɛ kɛ̀ bɛ̀ dɑ wɛ̃nnɛ́nɛ̀ kɛ́ ndɑ teénnɛ̀ mutɔ̃mmú. Fɔ̃́ nnɛ̀ ɑ bí díì níí yóó tɑ mɛtɑummɛ̀ tou kɛ́pĩ́ nyikuɔ́ tɔ̃mmú mɛtɑummɛ̀ tɔu ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Bɛ̀ɛ̀ yó ndɑ teénnɛ̀ mɛtɑummɛ̀ tou dimɔu kó mutɔ̃mmú bɛ̀ nɛ́ bɑ́ɑ́ tɔ́ɔ́nnɛ̀ ikuɔ́ nɛntì mɑtì yoo diwũɔ̃tɔ̀nnì, kɛ̀ dɛ̀ɛ yie nkɛ̀ di bɑ́ɑ́ kú kɛ́ bɛ̀ wɛ̃nnɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Bɛ̀ɛ̀ yó ndɑ wɛ̃nnɛ́ kɛ dɑ teennɛ̀ mɛtɑummɛ̀ tou kó mutɔ̃mmú mumɔu, wèè í tú Defii botí kou ò bɑ́ɑ́ di wɛ̃nnɛ́nɛ̀ mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Fɔ̃́ nnɛ̀ ɑ bí díì te mɛtɑummɛ̀ tou nɛ̀ diwũɔ̃tɔ̀nnì dɛ kó mutɔ̃mmú kɛ̀ dɛ̀ɛ yie nkɛ̀ m miɛkɛ bɑ́ɑ́ do Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Míì tɑ̃ɑ̃tɛ́ ɑ kɔbɛ Defiibɛ Isidɑyɛɛribɛ cuokɛ̀, bɛ̀ tu n kɔbɛ mbɛ kɛ̀ m bɛ̀ ndɑ duɔ́ nkɛ̀ bɛ̀ bo mpĩ́ mmɛtɑummɛ̀ tou kó mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Fɔ̃́ nhAnɔɔ nɛ̀ ɑ bí n duɔ́ ndí mbɛ ikuɔ́ kó mutɔ̃mmú diwũɔ̃tɔ̀nnì ĩ́nkɛ̀ nɛ̀ ikuɔ́ nɛntì kó kufɑ̃́ɑ̃́ nkuyɑ̀ɑ̀kù pi kù, n duɔ́ ndí mbɛ dɛ kó mutɔ̃mmú, wèè í tú Defii botí kou kɛ dɛ̀ tɔ̀ɔ́nnɛ̀ ò kumu. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Anɔɔ kɛ dɔ̀: Míì dɑ duɔ́ nkɑ̀ɑ bo ndɑkɛ Isidɑyɛɛribɛ m pɑ̃ɑ̃ nyɛ̀ɛ̀ pɑ̃rɛ̀ kpɛ́í, ɑ níí yóó dɛ ndɛitɛ dɛ̀ɛ̀ tu ɑ kpɛrɛ, n dɑ còú mmɛkùɔ̀ mmɛɛ̀ kpɛ́í nkɛ dɑ cɑ̃̀ńnɛ́ fɔ̃́ nnɛ̀ ɑ bí n tɔ̃mmú kpɛ́í, dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀ nɛ̀ ɑ yɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Ntɛ dɛ̀ɛ̀ yó ntú ɑ kpɛrɛ, bɛ̀ m pɑ̃ɑ̃ nyɛ̀ɛ̀ pɑ̃rɛ̀ miɛkɛ, kɛ́mbúútí yɛ̀ɛ̀ yóó tuɔ. Muyuo nkó yɛpɑ̃rɛ̀ nɛ̀ bɛ̀ n fìé ìì wũɔ̃ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í nnɛ̀ mɛyɛi nhũtímù kpɛ́í. Bɛ̀ m pɑ̃ɑ̃ nyɛ̀ɛ̀ pɑ̃rɛ̀ kó dimɑ̀ɑ̀ tu ɑ kpɛyɛ nyɛ fɔ̃́ nnɛ̀ ɑ yɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Díì níí dɛ̀ di dɛ̀ tu n kpɛrɛ ndɛ, bɛnitidɑɑbɛ̀ bɛ̀ɛ̀ bo di cɛ̃́ĩ bɛ̀ bo nɑ kɛ́ dɛ̀ di. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Ntɛ dɛtɛrɛ̀ dɛ̀ɛ̀ níí yó ntú ɑ kpɛrɛ Isidɑyɛɛribɛ dɛ̀ìtɛ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ kɛ m pɑ̃ kɛ dɛ̀ nni nyòutɛ, n dɛ̀ ndɑ duɔ́mmu fɔ̃́ nnɛ̀ ɑ yɑɑ̀bío initidɑɑì nɛ̀ initipòì. Bɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo ɑ cĩ́ɛ̃̀tɛ̀ kɛ wenni bɛ̀ bo nɑ kɛ́ dɛ̀ di. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","N di duɔ́mmu tidiketitì kó yɛpɑ̃rɛ̀ sɑ̀ɑ̀yɛ̀ Isidɑyɛɛribɛ m pɑ̃ɑ̃ nyɛ̀: Mɛkùɔ̀ nnɛ̀ mɛnɑɑ̀ nnɛ̀ tidiitì bɛ̀ tu tì bèdéè. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Bɛ ɛì kó tidiketitì bɛ̀ m pɑ̃ɑ̃ ntìì kó dimɑ̀ɑ̀, n ti n di duɔ́mmu bɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo di cɛ̃́ĩ kɛ wenni bɛ̀ bo nɑ kɛ́ dɛ̀ di. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Kɛ̀ Isidɑyɛɛribɛ níí m pɑ̃ dɛ̀ kɛ tú bɛ̀ dɛ̀ nni m pɑ̃mu sɑ̃́ɑ̃̀, díì yó ndɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Isidɑyɛɛribɛ bɛ̀ɛ̀ tu Mpo nɛ̀ bɛ wũɔ̃ ketiyì bɛ̀ m pɑ̃ɑ̃ ndɛ̀ tu di kpɛrɛ ndɛ. Bɛ̀ɛ̀ tu Mpo bɛ̀ níí bɛ̀ ndi dontɛ́nɛ̀, kɛ̀ fɛɔ̃̀fɛ̀ ketifɛ̀ mɑfɛ̀ tu bɛ̀ í n feu fɛ̀ bɛ̀ɛ fɛ̀ ndi dontɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Dɛnitidɑbirɛ dɛ̀ɛ̀ mɔ̀kɛ otɑ̃̀nkù omɑ́ɑ̀ dɛ donku dò nkɛ́mbo mɛdítíbii mmɛ̀nùmmù ndi bɛ̀ kèétɛ́mɛ̀ mɛtɑummɛ̀ tou kpɛ́í, mɛ̀ɛ̀ cɛ̃̀ɛ̃́kù bo kɑ̀dɑ́ɑ̀mmù tɛpíítɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Kɛ̀ fɛnɑ̀ɑ̀fɛ̀ nfɛ yoo fɛpìèfɛ̀ yoo tɛbuɔtɛ̀ dɛ̀ pɛitɛ́ ìì bí idɑɑì mɛketimɛ̀, bɛ̀ ì nni nfeumu, bɛ̀ bɑ́ɑ́ wɛ̃tɛ kɛ́ ì ndi dontɛ́nɛ̀, dí ì nni nféútɛ́ kɛ́cóú mmɛyĩ̀ĩ̀ ndiwũɔ̃tɔ̀nnì, kɛ́tuɔ ndɛ̀ɛ̀ tu mɛkùɔ̀ nkpɛrɛ, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Imɑɑ ntu di kpɛyi nyi, kɛ́yíɛ́nɛ̀ di n yòùtɛ ì, dicĩ̀ncĩ̀nnì nɛ̀ dikpèrì youri. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Isidɑyɛɛribɛ ɔ̃ɔ̃ dɛitɛ yɛ̀ɛ̀ pɑ̃rɛ̀ kɛ́ m pɑ̃, n yɛ̀ ndi duɔ́mmu díndi nɛ̀ di yɑɑ̀bío, initidɑɑì nɛ̀ initipòì, dɛ kó mɛtɑummɛ̀ yó mbomu, n di dɔúnnɛ̀ dìì nùù ndi sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Anɔɔ kɛ dɔ̀: N duɔ́ nkɛ̀ɛ̀ tenkɛ̀ Isidɑyɛɛribɛ, kɛ miɛkɛ ɑ í yó mmɔkɛ ɑ kɔkɛ, míì yó ntú ɑ kpɛrɛ Isidɑyɛɛribɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Díndi Defiibɛ, kɛ̀ Isidɑyɛɛribɛ níí dɛ̀itɛ bɛ̀ mɔ̀kɛ dɛ̀ miɛkɛ dɛpííndɛ̀ kɛ m pɑ̃, n dɛ̀ ndi duɔ́mmu di pĩ́ mmùù tɔ̃mmú kpɛ́í mɛtɑummɛ̀ tou. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Isidɑyɛɛribɛ sɔmbɛ bɑ́ ntɔkunɛ̀ mɛtɑummɛ̀ tou bɛ̀ yɑ̀ɑ̀ bo cé mbɛmɑ́ɑ̀ mɛyɛi nkɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Díndi Defiibɛ díì mɑ́ɑ̀ yó mpĩ́ mmɛtɑummɛ̀ tou kó mutɔ̃mmú, kòò mɔù yetɛ́nɛ̀ mɛtɑummɛ̀ tou díì te dɛ kó mɛyetímɛ̀, dɛ kó ikuɔ́ yó mbomu sɑ̃́ɑ̃̀. Di í yó mmɔkɛ di kó kɛtenkɛ̀ Isidɑyɛɛribɛ tɔbɛ̀ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Isidɑyɛɛribɛ ɔ̃ɔ̃ dɛitɛ dɛ̀ bɛ̀ mɔ̀kɛ dɛ miɛkɛ dɛ̀ɛ̀ tu dɛpííndɛ̀ kɛ́ m pɑ̃, n dɛ̀ ndi duɔ́mmu. Dɛɛ̀ te kɛ̀ n tu di í yó mmɔkɛ di kó kɛtenkɛ̀ Isidɑyɛɛribɛ cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","Á nɑ́kɛ́ Defiibɛ kɛ tú n yɛ̃ nkɛ̀ Isidɑyɛɛribɛ níí dɛ̀itɛ bɛ̀ mɔ̀kɛ dɛ̀ miɛkɛ dɛ̀ɛ̀ tu dɛpííndɛ̀ n yɛ̃ mbɛ̀ ndi duɔ̀ ndɛ̀ kɛ bɛ duɔ́, bɛ̀ɛ dɛitɛ dɛ miɛkɛ dɛ̀ɛ̀ tu dɛpííndɛ̀ kɛ́ n duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Dɛɛ̀ múnkɛ yó ntú bɛ kpɛrɛ bɛ̀ mɔ̀kɛ dɛ kó dɛpííndɛ̀. Bɛ kɔbɛ dɛ̀ìtɛ mɛ̀ɛ̀ botí tidiitì kó dɛpííndɛ̀ nɛ̀ mɛnɑɑ̀ nkɛ dɛ̀ mbɛ̀ duɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Bɛ̀ níí dɛitɛ Isidɑyɛɛribɛ dɛ̀itɛ dɛ̀ bɛ̀ mɔ̀kɛ dɛ̀ miɛkɛ, dɛ̀ɛ̀ tu dɛpííndɛ̀ kɛ́ bɛ̀ duɔ́, bɛ̀ɛ dɛitɛ dɛpííndɛ̀ dɛ miɛkɛ n kpɛrɛ ndɛ, dí dɛ̀ duɔ́ nyikuɔ́ nìùtì Anɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Bɛ̀ yó ndi duɔ̀ nyɛ̀ɛ̀ pɑ̃rɛ̀ yɛmɔu ĩ́nkɛ̀ di níí dɛitɛ bɑ́ dìì pɑ̃nnì ĩ́nkɛ̀ dɛ̀ɛ̀ tu dɛsɑ̀ɑ̀rɛ̀ kɛ́cɑ̃́nnɛ́ n kpɛ́í, n kpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Nɑ́kɛ́ bɛ kɛ̀ bɛ̀ dɛ̀itɛ dìì mɔ̀nnì dɛ̀ɛ̀ tu dɛsɑ̀ɑ̀rɛ̀ n kpɛrɛ tú dɛ̀, kɛ cɑ̃̀ńnɛ́ dɛ̀ɛ̀ kpɑɑ́ dɛ̀ tu bɛ kpɛrɛ ndɛ. Kɛ́ndònnɛ̀ Isidɑyɛɛribɛ ɔ̃ɔ̃ súɔ́mmɛ̀ bɛ diitì nɛ̀ bɛ nɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Di bo nɑ kɛ́ dɛ̀ di bɑ́ kɛ̀ɛ̀ bíɛ́kɛ̀ nɛ̀ di cɛ̃́ĩ kɔbɛ bɛmɔu. Dɛ̀ tu di kó tiyeti nti mutɔ̃mmú di pĩ́ mmù mɛtɑummɛ̀ tou mu kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Di dɛ̀itɛ dìì mɔ̀nnì dɛ̀ɛ̀ tu dɛsɑ̀ɑ̀rɛ̀ n kpɛrɛ tú dɛ̀, kɛ n duɔ́, dí di dɛsɔnnɛ. Dɛ mɔ̀nnì dɛ̀ í tú mɛyɛi, di yó mmɛ ndɔɔri kɛ bɑ́ɑ́ sĩnkùnnɛ Isidɑyɛɛribɛ m pɑ̃ɑ̃ nyɛ̀ɛ̀ pɑ̃rɛ̀ kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","Mí ndi Yiɛ̀ nKuyie míì di dɔúnnɛ̀ ikuɔ́. Dí nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ mbɛ̀ɛ wɑɑ́ nfɛnɑɑ̀wũɔ̃fɛ̀ fɛ̀ɛ̀ í mɔkɛ kuyɛ̀nkù bɑ́ sɑ́m̀pɔ́, bɛ̀ mu nyí buú nfɛ̀ kudɔú kɛ̀ fɛ̀ dùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Kɛ̀ di fɛ̀ duɔ́ nyikuɔ́ nìùtì Edeɑsɑɑ kòo fɛ̀ dènnɛ dihɛì mɑ̀nku kɛ̀ dí fɛ̀ fèútɛ́ o ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Kɛ̀ ikuɔ́ nìùtì Edeɑsɑɑ pɔɔ̀tɛ̀ o nɔ́mbii fɛ yĩ̀ĩ̀ nkɛ́míɛ́tɛ́ mɛtɑummɛ̀ tou bòrìnùù kucɛ mɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Kɛ̀ dí fɛ̀ tùɔ nkɛnkɛ ikuɔ́ nìùtì ììkɛ̀ kɛ́tuɔ nfɛ yĩ̀ĩ̀ nnɛ̀ fɛ mɑɑ nnɛ̀ fɛ kɔ̃̀nkù nɛ̀ fɛ piti. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Kɛ̀ ikuɔ́ nìùtìi wɑɑ́ mmutie bɛ̀ tu mù sɛ́tìrì mu kó kudɔú nɛ̀ bɛ̀ tu mù ìsɔ́pù mu kɔku nɛ̀ tipècìtì tìì to mmɛwũɔ̃̀ nkɛ́ dɛ̀ wɛ̃nnɛ́ kɛ́ɑ̃nnɛ́ muhɑ̃ɑ̃́ mbɛ̀ tùɔ mmùù miɛkɛ fɛnɑ̀ɑ̀fɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Kòò dèè wèe ɔ́ú o yɑ̀ɑ̀tì kɛ́wuɔ kɛ nɛ́ nɑ kɛ́kò mbɛ̀ bɑ̀tɛ́ dɛ̀. Ò yó nsĩ̀mmu kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Wèè tùɔ nfɛnɑ̀ɑ̀fɛ̀ kòò ɔ́ú o yɑ̀ɑ̀tì, kɛ́wuɔ. Ò yó nsĩ̀mmu kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Onìtì wèè í sɑ̃ũ nhomɑ́ɑ̀ kɛ̀ wèe koutɛ́ mutɑ́pɛí mbɛ̀ tùɔ nfɛ̀ɛ̀ nɑ̀ɑ̀fɛ̀ kɔ̃mu, kɛ́ mù fũ̀tɛnɛ̀ bɛ kɑrì kɛ́cóú ndibòrì bɛ̀ tɑ̃ɑ̃tɛ́ dì dɛ kpɛ́í, kɛ̀ mù mbo Isidɑyɛɛribɛ kpɛ́í kɛ̀ bɛ̀ mmù dɔ̀ɔ̀rinɛ̀ mɛwénkùmɛ̀ kó mɛniɛ. Dɛ kó ikuɔ́ yó ndònnɛ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛyi nyi. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Wèè koutɛ́ dɛ kó fɛnɑ̀ɑ̀fɛ̀ kó mutɑ́pɛí nwèe ɔ́ú o yɑ̀ɑ̀tì ò yó nsĩ̀mmu kɛ́tuɔkɛnɛ̀ kuyuoku. Dɛ kó ikuɔ́ yó mbomu Isidɑyɛɛribɛ kpɛ́í nnɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ bɛ̀ bonɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Kɛ̀ wèè kɑ̀ɑ́kɛ́ ocíì, bɑ́ wèè cíì botí cɛ̃́nkɛ ò sĩ̀ntɛmu, kɛ́nsĩ̀ nkɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Wèe wuɔnɛ̀ mmɛwénkùmɛ̀ kó mɛniɛ diyiè tɑ̃ɑ̃́nnì nɛ̀ diyiénnì kɛ nɛ́ nɑ kɛ́wenkɛ. Kòò í wùɔ diyiè tɑ̃ɑ̃́nnì nɛ̀ diyiénnì ò bɑ́ɑ́ wenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Wèè bo kɑ́ɑ́kɛ́ ocíì kɛ í nwùɔnɛ̀ mɛwénkùmɛ̀ kó mɛniɛ nhò sĩ̀nkùnko mí ndi Yiɛ̀ nKuyie n cĩ́ɛ̃̀tɛ̀ ntɛ, dɛ yiɛ̀ mbɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ cuokɛ̀, ò sĩ̀mmu kɛ yɛ̃́ ò í wùɔmɛ̀ ikuɔ́ kó mɛniɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Ntɛnɛ̀ ikuɔ́ tɛì: Kòò mɔù ku ditou mɑrì miɛkɛ kɛ̀ wèè tɑ di miɛkɛ ò sĩ̀ntɛmu wenwe nɛ̀ bɛ̀ɛ̀ bo di miɛkɛ kɛ́nsĩ̀ nkɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Tinɛntì tìì kó dimɑ̀ɑ̀ bo mbo dɛ kó ditou miɛkɛ kɛ í pokɛ kɛ boú teitei tì sĩ̀ntɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Kòò mɔù kèrí dikpɑ́ɑ̀ miɛkɛ kɛ kɑ̀ɑ́kɛ́ ocíì bɛ̀ kùɔ wè yoo ò nɑ òmɔù kó yɛkṹɔ̃̀ yoo kufɔ̃ti ò sĩ̀ntɛmu kɛ yó nsĩ̀ nkɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Kòo nìtì sĩ̀ntɛ kɛ̀ di yóó ò wénkùnnɛ, dí wɑɑ́ nfɛnɑɑ̀wũɔ̃fɛ̀ fɛnfɛ bɛ̀ kùɔ fɛ̀ kó mutɑ́pɛí nkɛ́ɑ̃nnɛ́ dibuu miɛkɛ kɛ́ɑ̃nnɛ́ mɛniɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Kɛ̀ di dèè onìtì wèè í sɑ̃ũ nhomɑ́ɑ̀ wèe wɑɑ́ ìsɔ́pù kó kudɔú kɛ́pɔɔ̀tɛ̀ dɛ kó mɛniɛ nkɛ́míɛ́tɛ́ míɛ́tɛ́ dɛ kó ditou nɛ̀ tinɛntì nɛ̀ bɛnìtìbɛ̀ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo dɛ kó ditou miɛkɛ nɛ̀ wèè kɑ̀ɑ́kɛ́ bɛ̀ kùɔ wè yoo ò nɑ òmɔù kó yɛkṹɔ̃̀ yoo ò nɑ̀ kufɔ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Onìtì wèè í sɑ̃ũ nhomɑ́ɑ̀ weè yóó míɛ́tɛ́ mɛniɛ nhonìtì wèè sɑ̃ũ nhomɑ́ɑ̀ diyiè tɑ̃ɑ̃́nnì nɛ̀ diyiénnì. Diyiénnì yiè wèe ɔ́ú o yɑ̀ɑ̀tì, kɛ́wuɔ kɛ́wenkɛ kuyuoku mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Wèè bo sɑ̃ũ nhomɑ́ɑ̀ kɛ í ndɔ́ kɛ́wénkùnnɛ omɑ́ɑ̀ bɛ̀ɛ ò dènnɛ Isidɑyɛɛribɛ cuokɛ̀, kɛ yɛ̃́ ò sĩ̀nkùnnɛmɛ̀ mí ndi Yiɛ̀ nKuyie n cĩ́ɛ̃̀tɛ̀ ntɛ. Ò mɛ nyí wùɔnɛ̀ ikuɔ́ kó mɛniɛ, nnɛ̀ dɛ kpɛ́í nhò sĩ̀mmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Dɛ̀ yó ntú ikuɔ́ nyi sɑ̃́ɑ̃̀, wèè bo míɛ́tɛ́ ikuɔ́ kó mɛniɛ nwèe ɔ́ú o yɑ̀ɑ̀tì, kɛ̀ wèè kɑ̀ɑ́kɛ́ dɛ kó mɛniɛ nhò sĩ̀ntɛmu kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Wèè sɑ̃ũ nhomɑ́ɑ̀ kòò kɑ̀ɑ́kɛ́ dɛ̀, dɛ̀ sĩ̀ntɛmu, kɛ̀ wèè kɑ̀ɑ́kɛ́ dɛ̀ɛ̀ sĩ̀ nhò sĩ̀ntɛmu kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kuyuoku. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Dibenni tɑ̃̀nkù ketiwè kɛ̀ Isidɑyɛɛribɛ tĩ̀nnìi tuɔkɛ Sinni kó dikpɑ́ɑ̀ kɛ́bɑ́tɛ́ Kɑdɛɛsi kɛ́kɑri. Midiyɑmmu dɛ nku kɛ̀ bɛ̀ɛ ò kũnnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Bɛ̀ í mpɛ̀tɛ́ mɛniɛ nkɛ bo yɑ̃̀ kɛ́tíí nkɛ́nkpɑnnɛ̀ Mɔyiisi nɛ̀ Anɔɔ kɛ tú: ");
INSERT INTO tbzsim_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kɛ̀ ti Yiɛ̀ nKuyie ndo nti wɛ̃nnɛ́nɛ̀ ti kɔbɛ bɛ̀ɛ̀ ku kɛ́potɛ́, kɛ̀ ti kú dɛ̀ í ntɔ̃ũɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Dɛ̀ yĩ́mɛ kɛ̀ di tɔní tínti ti Yiɛ̀ nKuyie nkɔbɛ kɛ kɔ̀tɛnní dikpɑ́ɑ̀ diì mmiɛkɛ kɛ̀ ti bo kú tínti nɛ̀ ti wũɔ̃? ");
INSERT INTO tbzsim_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Bɑ nte kɛ̀ di ti dènnɛní Esibiti kɛ ti tɔní dibòrì yɛiri dii? Dɛ̀ í dò mbuɔtí dɛ̀mɑrɛ̀, dɛtie mbɛ̀ tu dɛ̀ fìkíè dɛ̀ í bo kɛ̀ ti nɛ́ bɑ́ɑ́ buɔ́nɛ̀ fínyĩ̀ nɛ̀ kèdènɑ́tì kpɛrɛ, mɛniɛ nketɛ́ kɛ í bo kɛ dò nyɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mɛm̀mɛ Mɔyiisi nɛ̀ Anɔɔ bɛ̀ ìtɛ́mɛ̀ Isidɑyɛɛribɛ borɛ̀ kɛ́kɔtɛ mɛtɑummɛ̀ tou borìnùù kɛ́do kɛ́sĩ́nnɔ́ɔ kɛtenkɛ̀ kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ bɛnkɛ ku kpetì, ");
INSERT INTO tbzsim_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","Túótɛ́ ɑ pɑ̀ɑ̀ti fɔ̃́ nnɛ̀ ɑ kóo kótì Anɔɔ kɛ̀ di tíí nyIsidɑyɛɛribɛ, kɛ̀ bɛ̀ mbo kɛ wúó nkɑ̀ɑ bɛ́innɛ̀ diperì kɛ̀ mɛniɛ nyɛ̀nní, kɑ̀ɑ duɔ́ nkɛ̀ bɛ̀ɛ yɑ̃̀ bɛmbɛ nɛ̀ bɛ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Kɛ̀ Mɔyiisii túótɛ́ o pɑ̀ɑ̀ti mɛtɑummɛ̀ tou miɛkɛ kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie ndo tì nhò nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Wenwe nɛ̀ Anɔɔ kɛ̀ bɛ̀ɛ tíí nyIsidɑyɛɛribɛ dipèrì borɛ̀, kòo bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Kéntɛ́nɛ̀ díndi itookperí yɛmbɛ̀! Ti bo dennɛní mɛniɛ ndipèrì dii mmiɛkɛ nkɛ kɛ̀ di yɑ̃̀ɑ̃̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Mɛm̀mɛ ò yòùtɛmɛ̀ o pɑ̀ɑ̀ti kɛ́potɛ́ dipèrì mɛ̀dɛ́mɛ̀, kɛ̀ mɛniɛ nyɛ̀nní mɛdiɛ̀. Isidɑyɛɛribɛ nɛ̀ bɛ wũɔ̃ kɛ̀ dɛ̀ɛ yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ Anɔɔ kɛ dɔ̀: Di yɛ̀mmɛ̀ í mɛ nyiemmɛ̀ kɛ dò ndɛ̀ bo dɔɔ̀, di í mɛ ndɛ́úkùnnɛmɛ̀ n yètìrì Isidɑyɛɛribɛ ììkɛ̀, dì tɛ̃́nkɛ í yóó tɑnnɛ́ n nìtìbɛ̀ kɛtenkɛ̀ m bɛ̀ duɔ́ nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Dɛɛ̀ do te kɛ̀ bɛ̀ɛ yú dɛ kó mɛniɛ nkɛ dɔ̀ Mɛdibɑ, dɛ̀ɛ̀ tu dikpɑ̀nnì, kɛ yɛ̃́ Isidɑyɛɛribɛ do dɛ̀ nwɛ̃̀ńtɛ́mɛ̀ ti Yiɛ̀ nKuyie nkɛ̀ kùu bɛ̀ bɛnkɛ kù dòmmɛ̀ pɑ́í pɑ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Kɛ̀ bɛ̀ mbo Kɑdɛɛsi kɛ̀ Mɔyiisii dɛitɛ bɛnìtìbɛ̀ kɛ́ bɛ̀ tɔ̃ nkɛ dɔ̀ bɛɛ̀ kɔtɛ kɛ́nɑ́kɛ́ Edɔmmu kóo kpɑ̀ɑ̀tì kɛ dɔ̀: Tínti ɑ tebìí tíì tu ɑ yɛ̃́mu ti tɑmɛ̀ mɛhɑ́ɑ́rìmɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ti yɛmbɛ̀ bɛɛ̀ do kɔ̀tɛ Esibiti kɛ̀ ti nkɛ bo kɛ́mɔntɛ kɛ̀ Esibiti kɔbɛ ti fɛ̃́ũ tínti nɛ̀ ti yɛmbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Kɛ̀ ti kuɔ́nnɛ̀ ti Yiɛ̀ nKuyie nkɛ̀ kùu keè ti dɑbònnì kɛ́duɔnní ku tɔ̃nnì kɛ̀ dì ti dènnɛní Esibiti. Kɛ̀ ti tùɔ̀kɛní diɛ nKɑdɛɛsi dihɛì dìì bo ɑ tenkɛ̀ mɑ̀nku, ");
INSERT INTO tbzsim_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","kɑ̀ɑ bo yie, nyóu kɛ̀ ti pɛ̃ɛ̃tɛ́ ɑ ɛì miɛkɛ, ti í yɛtì dɛpɑɑ mmiɛkɛ yoo fínyĩ̀ kó dɛtie mmiɛkɛ, ti í yóó yɑ̃̀ ɑ kó sibií kó mɛniɛ, ti yóó kétɛ́ kucɛ diɛkù nku kɛ́pɛ̃ɛ̃tɛ́nɛ̀ ɑ ɛì, ti í yóó dɑutɛ́ kupíkù mɑkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Kɛ̀ Edɔmmu kóo kpɑ̀ɑ̀tìi bɛ̀ tɛ̃̀ńnɛ́ kɛ dɔ̀: Di í yóó pɛ̃ɛ̃tɛ́ diɛ nh ɛì. Kɛ̀ di mɛ nyetɛ n yóó bɑ́ɑ́tóomu kɛ́ di co kɛ̀ tí dokɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Kɛ̀ Isidɑyɛɛribɛɛ ò tɛ̃̀ńnɛ́ kɛ dɔ̀: Ti yóó kétɛ́ kucɛ diɛkù mɑ́ɑ̀ ndi kɛ ti yɑ̃̀ ɑ ɛì kó mɛniɛ tínti nɛ̀ ti wũɔ̃ ti bo dɑ yietí. Dɛ̀ í tú tìmɑtì, ti yóó nɑ ɑ tenkɛ̀ mɑ́ɑ̀ ndi kɛ́pɛ̃ɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Kɛ̀ Edɔmmu kóo kpɑ̀ɑ̀tìi bɛ̀ tɛ̃̀ńnɛ́ kɛ dɔ̀: Di í pɛ̃nkɛ́. Kɛ̀ Edomiibɛɛ bɑ́ɑ́tí nɛ̀ bɛhɑ̃ɑ̃pɔ̀nkperíbɛ̀ pɛ́u kɛ́ bɛ̀ co. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Mɛm̀mɛ Edɔmmu kóo kpɑ̀ɑ̀tì yetɛmɛ̀ Isidɑyɛɛribɛ bo pɛ̃ɛ̃tɛ́mɛ̀ o ɛì, kɛ̀ Isidɑyɛɛribɛ pɛɛ́ nkupíkù tɛkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ Kɑdɛɛsi kɛ́kɔtɛ ditɑ̃rì bɛ̀ tu dì Ɔdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Ti Yiɛ̀ nKuyie ndɛ mbɛ́innɛ̀ Mɔyiisi nɛ̀ Anɔɔ Ɔdi tɑ̃rì Edɔmmu temmɑ̀nku kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","Anɔɔ kũnti o yɛmbɛ̀ borɛ̀ ndɛ, ò í tɑti dihɛì n yɛ̃ n yóó duɔ́ ndì Isidɑyɛɛribɛ kɛ yɛ̃́ di do yetɛmɛ̀ n kpɛti Mɛdibɑ kó mɛniɛ mborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Túótɛ́ Anɔɔ nɛ̀ o birɛ Edeɑsɑɑ kɛ̀ di dekɛ Ɔdi tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Kɑ̀ɑ dɑ́tɛ́ Anɔɔ yɑ̀ɑ̀tì kɛ́dɑ́tínnɛ́ o birɛ Edeɑsɑɑ. Anɔɔ yóó dɛ nkú. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Kɛ̀ Mɔyiisii dɔɔ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì Isidɑyɛɛribɛ bɛmɔu ììkɛ̀, kɛ̀ bɛ̀ɛ dekɛ Ɔdi tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Kɛ̀ Mɔyiisii dɑ́tɛ́ Anɔɔ yɑ̀ɑ̀tì kɛ́dɑ́tínnɛ́ o birɛ Edeɑsɑɑ. Anɔɔ dɛ nku Ɔdi tɑ̃rì ĩ́nkɛ̀. Mɔyiisi nɛ̀ Edeɑsɑɑ kɛ̀ bɛ̀ɛ cútɛ́ní. ");
INSERT INTO tbzsim_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Isidɑyɛɛribɛ tĩ̀nnì dimɔu kɛ̀ bɛ̀ɛ yɑ̀ Anɔɔ kumɛ̀ kɛ́kɔmmú o kṹṹ nkɛ dɔ̀ yɛwe sipísìtɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mɛm̀mɛ Kɑnnɑhɑ̃ɑ̃ kóo kpɑ̀ɑ̀tì Adɑdi wèè do bo Nɛkɛbu ò kèèmɛ̀ Isidɑyɛɛribɛ kèróomɛ̀ Atɑdimmu kó kucɛ, kɛ́ítɛ́ní kɛ́ bɛ̀ do kɛ́pĩ́mmú bɛ miɛkɛ bɛ̀mɑbɛ̀ kɛ́dɔɔ̀ tidɑɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Kɛ̀ Isidɑyɛɛribɛɛ dɔúnnɛ̀ ti Yiɛ̀ nKuyie ndinùù kɛ dɔ̀: Ti Yiɛ̀ nKuyie nkɑ̀ɑ ti duɔ́ mbɛ nnìtìbɛ̀ ti bo bɛ̀ kùɔ pɑ́íí kɛ́pɔntɛ bɛ ɛì kɛ́dɛ́ítɛ́ ti bɑ́ɑ́ súɔ́ ndɛ̀mɑrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Kɛ̀ ti Yiɛ̀ nKuyie nkeè bɛ bɑ́ɑmmìi kɛ́ɑ̃nnɛ́ Kɑnnɑhɑ̃ɑ̃ kɔbɛ bɛ nɔu miɛkɛ, kɛ̀ bɛ̀ɛ bɛ̀ kùɔ pɑ́íí kɛ́pɔntɛ bɛ ɛkɛ̀ kɛ́dɛ́ítɛ́ kɛ́ dɛ̀ yu kɛ dɔ̀ Ɔdimɑɑ, dɛ̀ɛ̀ tu tidobontì. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ Ɔdi tɑ̃rì kɛ́tũnnɛ kucɛ kùù yìɛ̀nɛ̀ dɑ̀mɛ́ɛ̀rì tipèntì kou kɛ bo kɔ́ntɛ́ kɛ bɑ́ɑ́ yɛ̀nnɛ̀ Edɔmmu tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Bɛ̀ kètɛ́ mɛm̀mɛ kɛ́nkɑ̃́ɑ̃́kɛ́ kucɛ kɛ̀ mɛminnímɛ̀ɛ bɛ̀ dòńtɛ́. Kɛ̀ bɛ̀ɛ ketɛ́ bɛ̀ bo nkpɑ̀nnɛ̀mɛ̀ ti Yiɛ̀ nKuyie nnɛ̀ Mɔyiisi kɛ tú: Bɑ nte kɛ̀ di ti dènnɛní Esibiti kɛ̀ ti bo kú dikpɑ́ɑ̀ dii mmiɛkɛ? Tidiitì sɑ̀ɑ̀tì mɑtì í bo, mɛniɛ mmɛ nyí bo, kɛ̀ ti bɑɑ nɛ́ yó nyo tisénnìndiitì tii nti yɛwe yɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie nduɔnní iwɑɑyɛiyi kɛ̀ ì mbɛ̀ dɔmmù kɛ̀ bɛ̀ɛ kú kusṹkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Bɛ̀ɛ̀ kpɑɑ́ kɛ̀ bɛ̀ɛ nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Ti cɑ̀ɑ̀rɛ̀mu, ti tùùtɛnɛ̀mɛ̀ ti Yiɛ̀ nKuyie nkɛ dɑ kpɑnnɛ̀. Nɛ̀ dɛ kpɛ́í, nhɑ́ bɑ́ntɛ̀ ti Yiɛ̀ nKuyie nkɛ̀ kùu dɛ́tìnnɛ dɛ kó iwɑ̀ɑ̀kɛ. Kɛ̀ Mɔyiisii kuɔ́nnɛ̀ ti Yiɛ̀ nKuyie mbɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Túótɛ́ disɔɔwũɔ̃̀ kɛ́dɔɔ̀nɛ̀ fɛwɑ̀ɑ̀fɛ̀ kɛ́ fɛ̀ dɑ̀nnɛ kudɔú kɛ́cónnɛ́, kɛ̀ fɛwɑ̀ɑ̀fɛ̀ níí dɔntɛ́ wè kòò fɛ̀ bɔ̀útɛ́ ò bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mɛm̀mɛ kɛ̀ Mɔyiisii dɔ̀ɔ̀ disɔɔwũɔ̃̀ kó fɛwɑ̀ɑ̀fɛ̀ kɛ́cónnɛ́, kɛ̀ fɛwɑ̀ɑ̀fɛ̀ níí dɔntɛ́ wè kòò fɛ̀ bɔ̀útɛ́ o bɑ́ɑ́ kú. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ dɛborɛ̀ kɛ́kɔtɛ kɛ́bɑ́tɛ́ Obɔti, ");
INSERT INTO tbzsim_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","kɛ́ítɛ́ dɛndɛ kɛ́bɑ́tɛ́ Iyee-Abɑdimmu kpɑ́ɑ̀ kɛ́nwetí Mɔɑbu diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Kɛ̀ bɛ̀ɛ ítɛ́ dɛndɛ kɛ́bɑ́tɛ́ kukó nSedɛti kó mɛpɛɛ́mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Bɛ̀ ìtɛ́ dɛ̀ndɛ kɛ́séntɛ́ kukó nhAdinɔ, kùù pũɔ̃̀ nkɛ pɛ̃nkù dikpɑ́ɑ̀ kɛ kɔrì Amɔriibɛ tenkɛ̀. Dɛ kó kukó kuù tu Mɔɑbu kɔbɛ nɛ̀ Amɔriibɛ bɛ tenkɛ̀ mɑ̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Dɛɛ̀ kpɛ́í nte kɛ̀ tì wɑ̃̀ri ti Yiɛ̀ nKuyie nkó mudoò pɑ́tíri miɛkɛ kɛ tú...Wɑɛbu, Sufɑ tempɛ̃ mmiɛkɛ nɛ̀ Adinɔ nɛ̀ dɛ kó ikó, ");
INSERT INTO tbzsim_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","nɛ̀ ikó ntɛì ìì pũɔ̃̀ nkɛ tɑɑ̀ Adinɔ dihɛì Adi píkù iì tu Mɔɑbu tenkɛ̀ mɑ̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Bɛ̀ dɛ nyìtɛ́ kɛ́bɑ́tɛ́ bɛ̀ tu dɛ̀ tɛbintɛ, ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́ dɛ̀ Mɔyiisi kɛ dɔ̀: Tíí nyIsidɑyɛɛribɛ kɛ̀ m bɛ̀ duɔ́ mmɛniɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Dɛ mɔ̀nnì ndi Isidɑyɛɛribɛ dèntɛ̀mɛ̀ fɛyɛ̀nfɛ̀ kɛ dɔ̀: Tí dentɛ̀ kɛ̀ mɛniɛ nyɛ̀nní tɛbintɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Tɛbintɛ sikpɑ̀ɑ̀tìbìí keú tɛ̀, dihɛì kó bɛkótíbɛ̀ tũ tɛ̀ nɛ̀ bɛ pɑ̀ɑ̀ti nɛ̀ bɛ dɔ̀. Bɛ̀ dɛ nyìtɛ́ kɛ́kɔtɛ kɛ́bɑ́tɛ́ Mɑtɑnɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","kɛ́ítɛ́ dɛndɛ kɛ́bɑ́tɛ́ Nɑɑdiɛdi, kɛ́ítɛ́ dɛborɛ̀ kɛ́kɔtɛ Bɑmɔti. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Bɛ̀ ìtɛ́ Bɑmɔti nwe kɛ́kɔtɛ Mɔɑbu kpɑ́ɑ̀ kɛ́nwetí Pisikɑɑ tɑ̃rì, dìì sĩ̀ĩ́ ntɛdɔntɛ̀ kó dikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛɛ dɛitɛ yɛtɔ̃rɛ̀ kɛ́tɔ̃ nkɛ̀ bɛ̀ɛ nɑ́kɛ́ Amɔriibɛ kóo kpɑ̀ɑ̀tì Sionni kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","Ti dɔ́ kɛ́pɛ̃ɛ̃tɛ́ ɑ ɛì miɛkɛ nkɛ, ti í yóó tɑ dɛpɑɑ mmiɛkɛ yoo fínyĩ̀ kó dɛtie mmiɛkɛ, ti í yóó yɑ̃̀ mɛniɛ nti yó mbɔkɛ́ kucɛ diɛkù nku, ti í yóó dɑutɛ́ kɛ yɑ̀ɑ pɛ̃ɛ̃tɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Okpɑ̀ɑ̀tì Sionni mɛ nyí nyie nkɛ̀ Isidɑyɛɛribɛ bo pɛ̃ɛ̃tɛ́ o tempɛ̃, kòo ítɛ́nɛ̀ kɛmiɛkɛ kɛ́tíí nho nìtìbɛ̀ bɛmɔu kɛ̀ bɛ̀ɛ kétɛ́ní kɛ́co Isidɑyɛɛribɛ dikpɑ́ɑ̀ kɛ́ bɛ̀ do mudoò Yɑɑsi ɛì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Kɛ̀ Isidɑyɛɛribɛ bɛ̀ cɔ̀ yɛse kɛ́kuɔ kɛ́fietɛ bɛ tenkɛ̀, kɛ́túótɛ́ kukó nhAdinɔ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Sɑbɔki kɔku kɛ́sɔɔtɛ́ kɛ́tuɔkɛnɛ̀ Amɔniibɛ tenkɛ̀ mɑ̀nku kùù do kpetí mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Kɛ̀ bɛ̀ɛ fietɛ dɛ kó yɛhɛkɛ̀ yɛmɔu, kɛ́tiekɛ Amɔriibɛ tenkɛ̀ kɛmɔu kɛ́kɑri, kɛ́tɑunnɛ̀ Ɛsibonni nɛ̀ sihɛkɛsí sìì dɛ̀ tɔ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Ɛsibonni do tú Amɔriibɛ kpɑ̀ɑ̀tì Sionni bo dìì ɛì ndi. Sionni weè do pɔ̀ntɛ Mɔɑbiibɛ kpɑ̀ɑ̀tì ketiwè kɛ́fietɛ o tenkɛ̀ kɛmɔu kɛ́kɔtɛ kɛ́dítɛ́nɛ̀ kukó nhAdinɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Dɛɛ̀ te kɛ̀ bɛyɛndèmbɛ̀ dìè nkɛ tú: Tí kɔtɛnɛ̀ Ɛsibonni ɛì, tí kɔtɛ kɛ́wɛ̃tɛ kɛ dì mɑɑ́, tí wɛ̃tɛ kɛ́ dì còńnɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Muhɑ̃ɑ̃́ mmuù yɛ̀nní Ɛsibonni, Sionni ɛì miɛkɛ nkɛ mù tĩ̀ɛ̃́tɛ́mɛ̀ kɛ cɔ̀útɛ́ Adi ɛì Mɔɑbu tempɛ̃ mmiɛkɛ, kɛ cɔ̀útɛ́nɛ̀ Bɑɑdi kó yɛtɔ̀rɛ̀ yɛ̀ɛ̀ bo kukó nhAdinɔ pɛɛ́mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Díndi Mɔɑbu tenkɛ̀ kɔbɛ di bo yɑ̀ di fetimu díndi dibɔɔ̀ Kɛmɔɔsi kɔbɛ di dɑpɑ̀mbɛ̀ cokɛ́mu kɛ̀ bɛ̀ pĩ̀ḿmú di sɑpùmbí kɛ kònnɛ̀ kɛ duɔ́ nhAmɔriibɛ kpɑ̀ɑ̀tì Sionni. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Díndi Ɛsibonni kɔbɛ bɛ̀ di tɑ̃ɑ̃́ ipie nyi, kɛ di bɛ̀ti kɛ tùɔ̀kɛnɛ̀ Dibonni kɛ̀ di ɛkɛ̀ dɔúnko kɛ́túótɛ́nɛ̀ Dofɑɑ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Mɛdebɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Kɛ̀ Isidɑyɛɛribɛɛ tɑ Amɔriibɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Kɛ̀ Mɔyiisii tɔ̃ nkɛ̀ bɛ̀ɛ pɑɑtɛ́ Yɑsɛɛ ɛì kɛ́deè kɛ̀ bɛ̀ɛ di do, kɛ́bɛti Amɔriibɛ bɛ̀ɛ̀ dɛ̀ bo nɛ̀ sihɛkɛsí sìì dɛ̀ tɔ̀kɛ́ si kɔbɛ kɛ́fietɛ bɛ ɛkɛ̀ kɛ́kɑri. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Bɛ̀ kɑ̀ri mɛm̀mɛ kɛ́kétɛ́ kɛ́wetínnɛ́ Bɑsɑ̃ɑ̃ ɛì bíɛ́kɛ̀. Kɛ̀ Bɑsɑ̃ɑ̃ kóo kpɑ̀ɑ̀tì Ɔkuu ítɛ́ní nɛ̀ o nìtìbɛ̀ kɛ bo do Isidɑyɛɛribɛ mudoò Etedeii ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: A bɑ́ nhò yĩ̀ɛ̃̀kù, n wè ndi duɔ́mmu kɛ̀ di bo ò nɑ wenwe nɛ̀ o nìtìbɛ̀. Kɑ̀ɑ ò dɔ̀ɔ̀ ɑ dɔ̀ɔ̀mɛ̀ Amɔriibɛ kpɑ̀ɑ̀tì Sionni Ɛsibonni ɛì kou. ");
INSERT INTO tbzsim_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Mɛm̀mɛ̀ Isidɑyɛɛribɛ nɑmɛ̀ Ɔku kóò kùɔ wenwe nɛ̀ o bí nɛ̀ o nìtìbɛ̀ bɑ́ òmɔù í nyentɛ́ bɑ́ òmɑ́ɑ̀ kɛ̀ bɛ̀ɛ tiekɛ bɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ dɛborɛ̀ kɛ́bɑ́tɛ́ Mɔɑbu kó kubiriku kukó nSuditɛ̃ɛ̃ yɑ́ɑ̀ kɛ́nwetí Sedikoo. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Kɛ̀ Mɔɑbu kóo kpɑ̀ɑ̀tì Sipɔɔ birɛ Bɑdɑkii yɑ̀ Isidɑyɛɛribɛ dɔ̀ɔ̀ dɛ̀ Amɔriibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Kɛ̀ kufɔ̃wɑɑ́ mbɛ̀ ɑutɛ́ mɛdiɛ̀ wenwe nɛ̀ o kɔbɛ kɛ̀ bɛ̀ɛ yɔtɛ Isidɑyɛɛribɛ kɛ yɛ̃́ bɛ̀ tumɛ̀ kuwuɔ ndiɛkù nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Kòo tɔ̃ nkɛ̀ bɛ̀ɛ nɑ́kɛ́ Mɑndiyɑ̃ɑ̃ ɛì kó bɛkótíbɛ̀ kɛ dɔ̀: Ditĩ̀nnì dii nyóó dɛ́útóomu dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo ti tenkɛ̀, fɛnɑ̀ɑ̀fɛ̀ ɔ̃ɔ̃ dɛ́útóomɛ̀ mɛmúpɑ̀mmɛ̀. Sipɔɔ birɛ Bɑdɑki weè do tú okpɑ̀ɑ̀tì Mɔɑbu tenkɛ̀ dɛ mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Mɛm̀mɛ kɛ̀ Bɑdɑki dɛitɛ yɛtɔ̃rɛ̀ kɛ́tɔ̃ nho ɛì kótírì Petɔɔ dìì bo kukó nhEfɑdɑti borɛ̀, kɛ̀ yɛ̀ bo nɑ́kɛ́ Beɔɔ birɛ Bɑdɑmmu kɛ dɔ̀: Kubotí mɑkù kùù yɛ̀nní Esibiti kɛ mɔ́nkɛ pitírí kɛtenkɛ̀ kɛ bɑ̀tɛ́ diɛ nh ɛì mɑ̀nku kɛ n wetí. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Dɛ kó kubotí kpeńnìmu kɛ m pɛ̃ɛ̃tɛ́, n dɑ bɑ́ɑ́mmu kɔtɛní kɛ́ bɛ̀ bɔntɛ́ kusĩ̀nkù kɛ̀ dɛ̀ nɑɑti m bɛ̀ nɑ. N yɛ̃́mu kɛ dò nkɑ̀ɑ yĩ wèè yɑ̀ mɛyɛi nhò ɔ̃ɔ̃ mɛ̀ yɑ̀mu. Kɑ̀ɑ yĩ wèè yɑ̀ mɛsɑ̀ɑ̀ nwèe mɛ̀ yɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Mɔɑbu ɛì kó bɛkótíbɛ̀ nɛ̀ Mɑndiyɑ̃ɑ̃ ɛì kɔbɛ kɛ̀ bɛ̀ɛ kɔtɛ kɛ́yɑ̀ Bɑdɑmmu kɛ tɔnɛ̀ ticuuti kɛ bo ò cu, kɛ́tuɔkoo kóò nɑ̀kɛ́ bɛ̀ tɔ tì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Kɛ̀ Bɑdɑmmuu bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Duɔ́nɛ̀, kɛ̀ dɛ̀ wentɛ́ n di nɑ́kɛ́ m beé nti Yiɛ̀ nKuyie nkɛ̀ kù n nɑ̀kɛ́ tì. Mɛm̀mɛ kɛ̀ Mɔɑbu ɛì kó bɛkótíbɛ̀ɛ yié nho cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Kɛ̀ Kuyie nkɔtɛní kɛ́bekɛ Bɑdɑmmu kɛ dɔ̀: Bɛnìtìbɛ̀ ɔ̃̀mbɛ bo ɑ cĩ́ɛ̃̀tɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Kɛ̀ Bɑdɑmmuu kù tɛ̃̀ńnɛ́ kɛ dɔ̀: Sipɔɔ birɛ Bɑdɑki Mɔɑbu ɛì kóo kpɑ̀ɑ̀tì weè bɛ̀ tɔ̃nní kɛ tú: ");
INSERT INTO tbzsim_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","Kubotí mɑkù kuù yɛ̀nní Esibiti kɛ mɔ́nkɛ pitírí kɛtenkɛ̀, kòò tu kɛ̀ m bo yie n kɔtoo kɛ́ bɛ̀ bɔntɛ́ kusĩ̀nkù kɛ̀ dɛ̀ bo yie nwèe bɛ̀ nɑ kɛ́ bɛ̀ bɛ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Kɛ̀ Kuyie nhò nɑ̀kɛ́ kɛ dɔ̀: A bɑ́ɑ́ kɔtɛ, ɑ bɑ́ɑ́ bɛ̀ bɔntɛ́ kusĩ̀nkù, míì bɛ̀ dɔ̀ɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Bɑdɑmmuu bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Kònnɛ̀ di ciɛ, ti Yiɛ̀ nKuyie nyetɛmu kɛ tú m bɑ́ɑ́ di nɛinɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Kɛ̀ Mɔɑbu ɛì kó bɛkótíbɛ̀ɛ ítɛ́ kɛ́kò kɛ́nɑ́kɛ́ Bɑdɑki kɛ dɔ̀: Bɑdɑmmu yetɛmu kɛ tú ò bɑ́ɑ́ ti nɛinní. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Kɛ̀ Bɑdɑkii yíɛ́ kɛ́tɔ̃ nkutɔ̃nkù dɛ́rínkù kɛ̀ kù nsũnɛ̀ kuketikù kɛ tú bɛnitidiɛbɛ̀ kɛ pɛ̃ɛ̃tɛ́ bɛketibɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Kɛ̀ bɛ̀ɛ tuɔkoo Bɑdɑmmu borɛ̀ kóò nɑ̀kɛ́ kɛ dɔ̀: Sipɔɔ birɛ Bɑdɑki weè ti tɔ̃nní kɛ tú ò dɑ bɑ́ɑ́mmu ɑ bɑ́ɑ́ yetɛ ɑ bo kɔtoomɛ̀ o borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Ò tu ò yóó dɑ dɛ́úkùnnɛmu mɛdiɛ̀ nkɛ́dɔɔ̀ ɑ ò nɑ̀kɛ́ tìì kó dimɑ̀ɑ̀, ò tu ò dɑ bɑ́ɑ́mmu ɑ bɑ́ɑ́ yetɛ, ɑ́ kɔtoo kɛ́ bɛ̀ nhò bɔntɛ́ kusĩ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Kɛ̀ Bɑdɑmmuu bɛ̀ tɛ̃̀ńnɛ́ kɛ dɔ̀: Bɑ́ kɛ̀ Bɑdɑki n duɔ́ nho cĩ́ɛ̃̀tɛ̀ kɛ̀ timɑ́tì pɛ́ítì tɛ̀ pìɛ́kɛ́ nɛ̀ mɛsɔɔ nyí yóó nɑ kɛ́dɔɔ̀ tìmɑtì kɛ̀ tì ndɛu yoo tì nkɛ̃ńnì kɛ́petɛnɛ̀ ti Yiɛ̀ nKuyie n tũ nkù bo n nɑ́kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Di nɛ́ yié ndiɛ nkɛyènkɛ̀ kɛ̀ n yɑ̀ ti Yiɛ̀ nKuyie nyóó yíɛ́ kɛ́ n nɑ́kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Kɛ̀ Kuyie nkɔtɛní kɛyènkɛ̀ Bɑdɑmmu borɛ̀ kóò nɑ̀kɛ́ kɛ dɔ̀: Dɛ kó bɛnìtìbɛ̀ mɛ nkɔ̀tɛnímɛ̀ kɛ bo dɑ yú, ítɛ́ kɛ́ bɛ̀ nɛinɛ̀. A nɛ́ yó ndɔɔri n dɑ nɑ́ɑ́ ntì mɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Bɑdɑmmuu boú o sɑ̃mmɑrímú dɛ kɑ̀rì kɛ́nɛinɛ̀ Mɔɑbu ɛì kó bɛkótíbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Kɛ̀ Bɑdɑmmuu ketɛ́ kɛ́nnɛínɛ̀ o kó bɛtɔ̃mbɛ̀ bɛ̀dɛ́bɛ̀, kɛ̀ Kuyie mmiɛkɛ ò yɛ̀ mɛdiɛ̀. Kɛ̀ ti Yiɛ̀ nKuyie nkó ditɔ̃nnìi ò dintɛ́ kɛ́ncómmú kucɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Kɛ̀ sɑ̃mmɑrímúu yɑ̀ ti Yiɛ̀ nKuyie ntɔ̃nnì còḿmúmɛ̀ kucɛ kɛ pikú mɛsebii kɛ̀ sɑ̃mmɑrímúu dɑutɛ́ kɛ́tɑ dɛpɑɑ mmiɛkɛ kɛ̀ Bɑdɑmmuu dɛ̀ potɛ́ kɛ̀ dɛ̀ɛ bɔɔ́ nkucɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃nnìi sɔɔ́ nkɛ́kɔtɛ kɛ́cómmú fínyĩ̀ kó dɛtie nkó kupɑku mɑkù kucɛ pɛ̃̀ṹ dɛ̀ kɛ̀ bɛ̀ mɑɑ́ kɛ pèńnɛ́ ku m̀píkù nɛ̀ kutɛkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Kɛ̀ sɑ̃mmɑrímúu yɑ̀ ti Yiɛ̀ nKuyie ntɔ̃nnì kɛ́dɑutɛ́ kɛ́dínnɛ́nɛ̀ kumɑrí kɛ́hɛ̃́ṹtɛ́ Bɑdɑmmu nɑɑ̀cɛ̀tɛ̀ kumɑrí kòo wɛ̃tɛ kɛ́ dɛ̀ potɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃nnìi sɔɔ́ nkɛ́kɔtɛ kɛ́cómmú kucɛ pɛ̃̀ṹ dɛ̀ mɛfíè nyí borɛ̀ kɛ dò nkɔ́ntɛ́ kubɑkù yoú bíɛ́kɛ̀ yoo kucɑ̃̀nku bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Kɛ̀ sɑ̃mmɑrímúu yɑ̀ ti Yiɛ̀ nKuyie ntɔ̃nnì kɛ́okoo, kɛ̀ Bɑdɑmmu miɛkɛɛ yɛ̀nní kòò dɛ̀ potɛ́ kupɑ̀ɑ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Kɛ̀ ti Yiɛ̀ nKuyie nduɔ́ nkɛ̀ sɑ̃mmɑrímúu nɑ kɛ́bɛ́i, nkɛ́bekɛ́ Bɑdɑmmu kɛ dɔ̀: N dɑ cɑ̀kɛ bɑ kɑ̀ɑ m puotì kucɛ mɛtɑ̃ɑ̃́mmɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Kɛ̀ Bɑdɑmmu dɔ̀: A yetɛ n yɛ̃ mmù mmu dɛɛ̀ te, kɛ̀ n do ntɔ disiè nɛ̀ yíe n do dɑ kùɔ̀mu nɛ̀ dimɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Kɛ̀ sɑ̃mmɑrímúu ò tɛ̃̀ńnɛ́ kɛ dɔ̀: N tú ɑ sɑ̃mmɑrímú mmu kɑ̀ɑ n dèkù sɑ̃́ɑ̃̀, n dɑ dɔ̀ɔ̀ miɛ̀ mbotí diyiè mɑrɑ̀ɑ̀? Kòò dɔ̀: Ɔ́ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Dɛ mɔ̀nnì ndi ti Yiɛ̀ nKuyie nkpetɛ́mɛ̀ Bɑdɑmmu nuɔ nkòo yɑ̀ ku tɔ̃nnì kɛ̀ dì còḿmú kucɛ kɛ pikú mɛsebii nkòo do kɛ́nínkú kɛ́sĩ́nnɔ́ɔ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃nnìi ò bekɛ kɛ dɔ̀: Bɑ nte kɑ̀ɑ potɛ́ sɑ̃mmɑrímú kɛ tùɔ̀kɛ kucɛ mɛ̀tɑ̃ɑ̃ti? Míì dɑ dintɛ́ kɛ bo dɑ pɛ́ítɛ́, kɛ yɛ̃́ ɑ kérímɛ̀ kucɛ yɛiku nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Sɑ̃mmɑrímú n yɑ̀mu kɛ kɔ̀ńtɛ́ kucɛ mɛ̀tɑ̃ɑ̃ti kɛ̀ mɛɛ̀ dɔkɛ nɛ̀ yíe n do dɑ kùɔ̀mu kɛ̀ sɑ̃mmɑrímú nfòù. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Kɛ̀ Bɑdɑmmuu nɑ́kɛ́ ti Yiɛ̀ nKuyie ntɔ̃nnì kɛ dɔ̀: N cɑ̀ɑ̀rɛ̀mu n do í yɛ̃́ kɛ do nfɔ̃́ɔ̃̀ n dintɛ́ kucɛ. Kɛ̀ dɛ̀ í dɑ nɑɑti m bo kɔtɛmɛ̀ dɛ kó kucɛ m bo wɛ̃tɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Kɛ̀ ti Yiɛ̀ nKuyie ntɔ̃nnì dɔ̀: Nɛinɛ̀ bɛ kɛ̀ dí kɔtɛ, ɑ nɛ́ yó nnɑ́ɑ́ nh ɑ̃nnɛ́ tì nti ɑ nùù miɛkɛ. Mɛm̀mɛ kɛ̀ Bɑdɑmmuu nɛinɛ̀ Bɑdɑki tɔ̃nní bɛ̀ɛ̀ kpɑ̀ɑ̀tìbɛ̀ kɛ̀ bɛ̀ɛ kɔtɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Kɛ̀ Bɑdɑkii keè Bɑdɑmmu kèróomɛ̀ kɛ́kétɛ́ní kóò co dihɛì bɛ̀ tu dì Adi-Mɔɑbu dìì tɔ̀kɛ́nɛ̀ kukó nhAdinɔ kùù tu bɛ tenkɛ̀ mɑ̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Kòo bekɛ Bɑdɑmmu kɛ dɔ̀: N tɔ̃nko bɛnìtìbɛ̀ kɛ tú bɛ̀ dɑ yúní, dɛ̀ yĩ́mɛ kɑ̀ɑ í kɔ̀tɛní? Yɑ́ɑ̀ ɑ yɛ̀mmɛ̀ do dò n yí yóó dɑ dɛ́úkùnnɛmu? ");
INSERT INTO tbzsim_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Kɛ̀ Bɑdɑmmuu ò tɛ̃̀ńnɛ́ kɛ dɔ̀: Bɑ́ nɛ̀ mmɛ nkɔ̀tɛnímɛ̀ m bo nɑ́kɛ́ ɔ̃̀nti nɛ̀ mmɑ́ɑ̀? Kuyie nhɑ̃nnɛ́ tì n nùù n yóó ti ndɑ nɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Mɛm̀mɛ Bɑdɑmmu nɛinɛ̀mɛ̀ Bɑdɑki kɛ̀ bɛ̀ɛ kò nKidiyɑ-Usoo. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Kɛ̀ Bɑdɑkii fíé inɑ̀ɑ̀kɛ nɛ̀ ipe kɛ́pɑ̃mmú imɑɑ Bɑdɑmmu nɛ̀ bɛkótíbɛ̀ bɛ̀ɛ̀ do ò cíe. ");
INSERT INTO tbzsim_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Bɑdɑkii túótɛ́ Bɑdɑmmu kɛ̀ bɛ̀ɛ dekɛ Bɑmɔti-Bɑɑdi kó ditennì yɛtɔ̀rɛ̀ borɛ̀, kòo nɑ kɛ́yɑ̀ Isidɑyɛɛribɛ kó dikéè. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Kɛ̀ Bɑdɑmmuu duɔ́ nkɛ̀ Bɑdɑki mɑɑ́ yɛwũɔ̃tɔ̀rɛ̀ yɛ̀yiekɛ̀ dɛborɛ̀, kɛ́wɑɑ́ nyɛnɑɑdɑkɛ̀ yɛ̀yiekɛ̀ nɛ̀ yɛpedɑkɛ̀ yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Kɛ̀ Bɑdɑkii dɔɔ̀ Bɑdɑmmu ò nɑ̀kɛ́ tì, kɛ̀ bɛ̀ɛ féútɛ́ bɑ́ dìì wũɔ̃tɔ̀nnì ĩ́nkɛ̀ dinɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Kòo deè kɛ̀ Bɑdɑmmuu nɑ́kɛ́ Bɑdɑki kɛ dɔ̀: Ncómmú diɛ nhɑ wũɔ̃ ɑ fìé ì kɛ tùɔ nyì borɛ̀. Kɛ̀ n kɛntɛ́ kɛ́yɑ̀ ti Yiɛ̀ nKuyie bo m bɛ́innɛ̀ tì, kɛ̀ n wɛ̃tɛní kɛ dɑ nɑ́kɛ́ kù yɛ̃ mmù. Ò mɛ nyĩ kɛ́dekɛ ditɑ̃rì yómmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Kɛ̀ Kuyie nkɔtɛní o borɛ̀ kòo kù nɑ̀kɛ́ kɛ dɔ̀: M mɑɑ́ yɛwũɔ̃tɔ̀rɛ̀ yɛ̀yiekɛ̀ ndi kɛ fèútɛ́ bɑ́ dìì ĩ́nkɛ̀ dinɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀ kɛ tùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Kɛ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tinɑ́ɑǹtì ò bií yóó nɑ́kɛ́ tì Bɑdɑki, kɛ́deè kóò nɑ̀kɛ́ kɛ dɔ̀: Wɛ̃tɛ kɛ́nɑ́kɛ́ Bɑdɑki kɛ dɔ̀ muu. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Kɛ̀ Bɑdɑmmuu wɛ̃too Bɑdɑki borɛ̀ o cómmú dɛ̀ o wũɔ̃ ò fìé ì kɛ tùɔ nyi borɛ̀, wenwe nɛ̀ Mɔɑbu kó bɛkótíbɛ̀ bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Mɛm̀mɛ Bɑdɑmmu dèntɛ̀mɛ̀ o onnìfɛ̀ kɛ dɔ̀: Bɑdɑki duɔ́ nkɛ̀ bɛ̀ n yuní Arɑmu tenkɛ̀ wenwe Mɔɑbu kpɑ̀ɑ̀tì ò duɔ́ nkɛ̀ bɛ̀ n yuní diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó yɛtɑ̃rɛ̀ ĩ́nkɛ̀, Ò tu n kɔtɛní kóò bɔntɛ́ kusĩ̀nkù nku Sɑkɔbu yɑɑ̀bí, kɛ tú nhò cɑ̀ɑ̀rɛ̀ Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","N nɛ́ bo yĩ́mɛ kɛ́bɔntɛ́ kusĩ̀nkù Kuyie nyí bɔntɛ́ bɛ̀ kusĩ̀nkù? M bo yĩ́mɛ kɛ̀ m miɛkɛɛ pɛikɛ ti Yiɛ̀ nKuyie mmiɛkɛ í pɛikɛ bɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","N wúónní Isidɑyɛɛribɛ yɛtɑ̃rɛ̀ ĩ́nkɛ̀ m bɛ̀ pɑɑtɛ́ní ditennì ĩ́nkɛ̀ nkɛ bɛ̀ tu kubotí kùù cɑ̃̀ɑ̃́ nkù nku bɛ̀ í wɛ̃nnɛ́ ibotí tɛì. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","We mbo nɑ kɛ́ bɛ̀ kɑ̀ɑ? Bɛ yɑɑ̀bí dònnɛ̀ mubirímú mmu. We mbo nɑ kɛ́kɑɑ nyIsidɑyɛɛribɛ kó dikéè kɛ́nɑ́kɛ́ bɛ̀ mɑ̀mɛ̀? N dɔ́ kɛ́wɛ̃nnɛ́nɛ̀ dɛ kó bɛnitisɑ̀ɑ̀bɛ̀ mbɛ kɛ́kú. N dɔ́ n fòmmu mɑ̀nku ndònnɛ̀ bɛ kɔ̃mu kɔku nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Kɛ̀ Bɑdɑkii nɑ́kɛ́ Bɑdɑmmu kɛ dɔ̀: A n dɔ̀ɔ̀ bɑ? N dɑ yùní kɑ̀ɑ bo kɔtɛní kɛ́bɔntɛ́ kusĩ̀nkù n dootitɔbɛ̀, kɑ̀ɑ nɛ́ bɛ̀ duɔ̀ mɛsɑ̀ɑ̀nɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Kɛ̀ Bɑdɑmmuu ò tɛ̃̀ńnɛ́ kɛ dɔ̀: Ti Yiɛ̀ nKuyie nhɑ̃nnɛ́ tì n nùù n dò nkɛ́ tì mbɛ́i. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Kɛ̀ Bɑdɑki dɔ̀: Kɔtɛní kɛ̀ ti kɔtɛ kupíkù tɛkù, kɑ̀ɑ bɛ̀ yɑ̀ bɛmɔu, ɑ do yɑ̀ dikéè ndi, dɛborɛ̀ ɑ bo bɛ̀ yɑ̀mu bɛmɔu kɛ́ bɛ̀ nni mbɔntɛ́ kusĩ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Ò mɛ nyĩ kóò kɔ̀tɛnɛ̀ bɛ̀ɛ̀ pɑkɛ́ dihɛì bɛ kó dikɑrì Pisikɑɑ tɑ̃rì yómmɛ̀, kɛ́mɑɑ́ yɛwũɔ̃tɔ̀rɛ̀ yɛ̀yiekɛ̀ kɛ́féútɛ́ bɑ́ dìì wũɔ̃tɔ̀nnì ĩ́nkɛ̀ dinɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀ kɛ́tuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Kɛ̀ Bɑdɑmmuu nɑ́kɛ́ Bɑdɑki kɛ dɔ̀: Ncómmú diɛ ɑ fìé ìì wũɔ̃ borɛ̀ kɛ̀ n kɔtɛ ciɛ nkɛ́yɑ̀ ti Yiɛ̀ nKuyie nyó n nɑ́kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nkɔtɛní Bɑdɑmmu borɛ̀ kɛ́ɑ̃nnɛ́ tinɑ́ɑǹtì ò nùù miɛkɛ kɛ dɔ̀: Wɛ̃too kóò nɑ̀kɛ́ kɛ dɔ̀ muu. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Kɛ̀ Bɑdɑmmu wɛ̃too kɛ́nsɔ̃́ Bɑdɑki bɑɑ cómmú o wũɔ̃ ò fìé ì kɛ tùɔ nyi borɛ̀, wenwe nɛ̀ Mɔɑbu kó bɛkótíbɛ̀ bɛmɔu. Kɛ̀ Bɑdɑkii ò bekɛ dɔ̀: Ti Yiɛ̀ nKuyie ndɑ nɑ̀kɛ́ ɔ̃̀nti? ");
INSERT INTO tbzsim_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Kɛ̀ Bɑdɑmmuu deǹtɛ̀ fɛyɛ̀nfɛ̀ kɛ dɔ̀: Bɑdɑki ítɛ́ kɛ́keè. Fɔ̃́ nSipɔɔ birɛ kéntɛ́ kɛ́keè. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Kuyie nyí tú onìtì kɛ bo soutɛ́, kù mɛ nyí do nhonìtì dòmmɛ̀ kɛ bo bɛ́i nkɛ́ceetɛ, kù ɔ̃ɔ̃ í nnɑ̀kɛ́ tìmɑtì kɛ̀ tì í ntùɔ̀kɛní kù bɛ́i ntì kù ɔ̃ɔ̃ tì dɔ̀ɔ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Kuyie nkuù n nɑ̀kɛ́ kɛ tú m bɛ̀ pɑ̃ mɛsɑ̀ɑ̀, kɛ̀ m mɛ mbɛ̀ pɑ̃, n yí yóó ceetɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Kù í yɑ̀ Isidɑyɛɛribɛ cɑ̀ɑ̀rɛ̀ mù Kù í yɑ̀ Sɑkɔbu yɑɑ̀bí kó mɛyɛi mmɑmɛ̀, bɛ Yiɛ̀ nKuyie mbɛ̀ bonɛ̀mu, kɛ̀ bɛ̀ kù sɑ̃ntí yɛkpɑ̀ɑ̀tìsɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Kuyie nkuù bɛ̀ dènnɛní Esibiti kɛ bɛ̀ duɔ́ mmupɑɑnɑ̀ɑ̀wɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Dɛnitinɔ̀nkpɛrɛ bɑ́ɑ́ nɑ kɛ́dɔɔ̀ dɛ̀mɑrɛ̀ Sɑkɔbu yɑɑ̀bí. Tidiɛtì kpɛrɛ bɑ́ɑ́ kɑ́ɑ́kɛ́ Isidɑyɛɛribɛ. Dɛɛ̀ te kɛ̀ bɛ̀ ɔ̃ mbɛnkú Isidɑyɛɛribɛ kɛ tú: Ntɛ Kuyie ndɔ̀ɔ̀ dɛ̀ bɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Dɛ kó kubotí ɔ̃ɔ̃ ítɛ́ní musĩ̀mmù kɔ̃mɛ mmɛ bɛ̀ còḿmú dicìrícìrì tɛ̃mɛ̀ mmɛ kɛ̀ bɛ̀ í nìntɛ kɛ pĩ nkɛ cɑ̀ɑ́kɛ́ kɛ yɑ̃̀ mɛyĩ̀ĩ̀ mbɛ̀ ɔ̃ɔ̃ í nduɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Kɛ̀ Bɑdɑki dɔ̀: Kɑ̀ɑ í yóó bɛ̀ bɔntɛ́ kusĩ̀nkù ɑ yóu ɑ bo mbɛ̀ pɑ̃ɑ̃mmɛ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Kɛ̀ Bɑdɑmmuu ò tɛ̃̀ńnɛ́ kɛ dɔ̀: N do í dɑ nɑ̀kɛ́ kɛ tú kɛ̀ Kuyie nni nnɑ̀kɛ́ tì, n dò nkɛ́ ti nnɑ́kɑ́ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Kɛ̀ Bɑdɑki dɔ̀: Kɔtɛní kɛ̀ tí kɔtɛ kupíkù tɛkù kɛ̀ dɛ̀ nɑɑti Kuyie nyie nkɑ̀ɑ bɛ̀ nni mbɔntɛ́ kusĩ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Kɛ̀ Bɑdɑkii tɔ Bɑdɑmmu kɛ̀ bɛ̀ɛ dekɛ Peɔɔ tɑ̃rì yómmɛ̀ dìì sĩ̀ĩ́ ndikpɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Kɛ̀ Bɑdɑmmuu nɑ́kɛ́ Bɑdɑki kɛ dɔ̀: Mɑɑ́ diɛ nyɛwũɔ̃tɔ̀rɛ̀ yɛ̀yiekɛ̀ kɛ́féútɛ́ bɑ́ dìì wũɔ̃tɔ̀nnì ĩ́nkɛ̀ dinɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Kɛ̀ Bɑdɑkii dɔɔ̀ Bɑdɑmmu ò nɑ̀kɛ́ tì kɛ́féútɛ́ bɑ́ dìì wũɔ̃tɔ̀nnì ĩ́nkɛ̀ dinɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Kɛ̀ Bɑdɑmmuu bɑntɛ́ ti Yiɛ̀ nKuyie ndɔ́mɛ̀ kɛ́pɑ̃ Isidɑyɛɛribɛ mɛsɑ̀ɑ̀ nkɛ́yóu kɛ tɛ̃́nkɛ í nkɔ̀tɛ kɛ bo wɑmmú ò dò nkɛ́nɑ́kɛ́ tì kɛ́wɛ̃ɛ̃tɛ dikpɑ́ɑ̀ bíɛ́kɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","kɛ́wéntɛ́ kɛ́yɑ̀ Isidɑyɛɛribɛ bɑ̀tɛ́mɛ̀ kɛ kɑri bɛ botí dò ndòmmɛ̀. Mɛm̀mɛ Kuyie nYɑɑ́ ncùtɛ́nímɛ̀ o ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Kòo deǹtɛ̀ fɛyɛ̀nfɛ̀ kɛ dɔ̀: Mí mBeɔɔ birɛ Bɑdɑmmu m bɛ́immu, onìtì wèè wùó ndisɔ̀rì kpɛti míì bɛ́i. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Mí nwèè yo Kuyie ntɑmmɛ̀ mí nwèè ɔ̃ɔ̃ nínkú kɛ́bɑ́ntɛ̀ Kuyie nkɛ̀ kùu kpetɛ́ n nuɔ, mí nwèè yɑ̀u muwɛ̃rímú mumɔu yiɛ̀ nkó mɛbɛnkùmɛ̀ ntɛ n tú mù: ");
INSERT INTO tbzsim_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Díndi bɛ̀ɛ̀ tu Isidɑyɛɛribɛ di kɑrɛ̀ wennimu, Díndi Sɑkɔbu yɑɑ̀bí di ɑ̃ tìì touti wennimu, ");
INSERT INTO tbzsim_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","dɛ̀ pitɛ́ ikó nkɔ̃mɛ mmɛ, kɛ do nkupúú dòmmɛ̀ kukó ntɑkɛ́, kɛ dònnɛ̀ dɛtekperɛ̀ ti Yiɛ̀ nKuyie nfìí ndɛ̀. Kɛ sɑ̃́kɛ́nɛ̀ sɛ́tìrì kó dɛtie ndɛ̀ɛ̀ bo kukó ntɑkɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Kɛ dò mmɛniɛ nhɔ̃ɔ̃ píɛmmɛ̀ kukó kɛ́yɑɑtɛ́ní kɛtenkɛ̀ kɛ́nyɔ́ɔ̀rì tidiitì. Bɛ kóo kpɑ̀ɑ̀tì í wéí okpɑ̀ɑ̀tì Akɑki bɛ kó dikpɑ̀ɑ̀tìyuu kpénkúmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Kuyie mbɛ̀ dènnɛní Esibiti kɛ bɛ̀ duɔ́ mmupɑɑnɑ̀ɑ̀wɛ̃rímú mmu kɛ̀ bɛ̀ kɔ̀ùtì bɛ dootitɔbɛ̀ kɛ bɛ̀ tɑ̃ũ ipie. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Bɛ̀ ɔ̃ nhokɛ yɛcìrícìrɛ̀ kɔ̃mɛ mmɛ kɛ duɔ́ musĩ̀mmù kɔ̃mɛ. We mbo dɑ́ɑ́tí kɛ́ bɛ̀ íi? Mɛsɑ̀ɑ̀ nní mbonɛ̀ bɛ̀ɛ̀ bɛ̀ dɔ́nɛ̀ mɛsɑ̀ɑ̀. Bɛ̀ɛ̀ bɛ̀ dɔ́nɛ̀ mɛyɛi mmɛ̀ɛ do bɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Kɛ̀ dɛ̀ɛ yonkɛ Bɑdɑki kòo potɛ́ o nɔ̀ùtɛ̀ kɛtenkɛ̀ kɛ́nɑ́kɛ́ Bɑdɑmmu kɛ dɔ̀: N do dɑ yùní kɑ̀ɑ bo bɛ̀ bɔntɛ́ kusĩ̀nkù nku, kɑ̀ɑ nɛ́ bɛ̀ pɑ̃ mɛsɑ̀ɑ̀ nkucɛ mɛtɑ̃ɑ̃tɑɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Di mmɔ̀nnì kò nhɑ ciɛ! N do tú m bo dɑ dɛ́úkùnnɛmu, ɑ Yiɛ̀ nKuyie mmɛ ndɛ̀ ndɑ pɑ̀ɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Kɛ̀ Bɑdɑmmuu ò tɛ̃̀ńnɛ́ kɛ dɔ̀: A do tɔ̃nní bɛnìtìbɛ̀ kɛ̀ n yí mbɛ̀ nɑ̀kɑ́ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","N do bɛ̀ nɑ̀kɛ́mu kɛ̀ n dɔ̀: Bɑ́ kɛ̀ Bɑdɑki n duɔ́ ntimɑ́tì pɛ́ítì nɛ̀ mɛsɔɔ ndɛ̀ɛ̀ pìɛ́kɛ́ o cĩ́ɛ̃̀tɛ̀ n yí yóó nɑ kɛ́dɔɔ̀ tìmɑtì nɛ̀ m mɑ́ɑ̀, tisĩ̀ntì yoo tisɑ̀ɑ̀tì. Kuyie nni nnɑ̀kɛ́ tì nti n yóó dɔɔ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","N kũntimu yíe n kɔbɛ borɛ̀ n nɛ́ yóó dɑ nɑ́kɛ́mu Isidɑyɛɛribɛ yóó dɔɔ̀mɛ̀ ɑ nìtìbɛ̀ yɛwe yɛ̀ɛ̀ kpɑɑní yɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Mɛm̀mɛ ò dèntɛ̀mɛ̀ fɛyɛ̀nfɛ̀ kɛ dɔ̀: Mí mBeɔɔ birɛ Bɑdɑmmu m bɛ́immu, mí nhonìtì wèè wùó ndisɔ̀rì kpɛti míì bɛ́i. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Mí nwèè yo Kuyie ntɑmmɛ̀, mí nwèè yɛ̃́ Kuyie nkùù bɑkɛ́ kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ kù dɔ́ kɛ́dɔɔ̀ tì, mí nwèè ɔ̃ɔ̃ nínkú kɛ́bɑ́ntɛ̀ Kuyie nkɛ̀ kùu kpetɛ́ n nuɔ, mí nwèè yɑ̀u muwɛ̃rímú mumɔu yiɛ̀ nkó mɛbɛnkùmɛ̀ ntɛ n tú mù: ");
INSERT INTO tbzsim_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","N yɑ̀mu dɛ̀ɛ̀ kèríní dɛ̀ nɛ́ í yóó tuɔkɛní bɑ̀mbɑ̀ n dɛ̀ wùónnímu dɛ̀ nɛ́ mu nyí tùɔ̀kɛ. Okpɑ̀ɑ̀tì weè yɛ̀tìní Isidɑyɛɛribɛ miɛkɛ, tɛwɑ̃̀tɛ̀ mɑtɛ̀ tɛɛ̀ yɛ̀tìní Sɑkɔbu yɑɑ̀bí miɛkɛ, kɛ yó mpuotì Mɔɑbu kɔbɛ tempɑ́ɑ́tì nɛ̀ tɛ pɑ̀ɑ̀ti kɛ kɔ̃mmù Sɛti yɑɑ̀bí yɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Weè yóó tiekɛ Edɔmmu ɛì, weè yóó fietɛ bɛ dootitɔbɛ̀ Seii ɛì kɔbɛ ɛkɛ̀. Isidɑyɛɛribɛ wɛ̃rímú dɛumu. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Sɑkɔbu yɑɑ̀birɛ dɛɛ̀ yóó bɑɑtɛ́ bɛ dootitɔbɛ̀, kɛ́kuɔ bɛsɔmbɛ bɛ̀ɛ̀ bo yentɛ́ kɛ́nkpɑɑ́ dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Dɛ kó difɔ̃nkúò kɛ̀ Bɑdɑmmuu yɑ̀ Amɑdesiibɛ kɛ́dentɛ̀ o onnìfɛ̀ kɛ dɔ̀: Amɑdesiibɛ bɛɛ̀ tu bɛketibɛ̀ ibotí miɛkɛ kɛ nɛ́ yóó dentɛnɛ̀ bɛ̀ bo bɛ̀ pɔ̀ntɛmɛ̀ pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Kòo yɑ̀ Keniibɛ kɛ dɔ̀: Díndi Keniibɛ di bomu kɛ í yĩɛ̃̀kù di dònnɛ̀ tinɔriyĩ́ɛ̃̀ntì tìì sĩɛ̃kɛ́ ntìnti tipètì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Nɛ̀ mɛmmɛ muhɑ̃ɑ̃́ mmuù nɛ́ yóó cɔ́útɛ́ di kó dihɛì Kɑinni kɛ̀ Asidii kɔbɛɛ di pĩ́mmú kɛ kònnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Kòo sɔɔtɛ́ o onnìfɛ̀ kɛ dɔ̀: Kuyie mbo ítɛ́ kɛ cómmú dìì mɔ̀nnì we mbo nkpɑɑ́ bo? ");
INSERT INTO tbzsim_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ketimmu itimu nɛ̀ bɑ̀tóòbɛ̀ kɛ bo fɛ̃́ũ Asuu ɛì kɔbɛ nɛ̀ Ebɛɛ ɛì kɔbɛ bɛ mɔ́mmɔmbɛ bɛ̀ mɛ mmúnkɛ í yóó cootɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Dɛ kó difɔ̃nkúò kɛ̀ Bɑdɑmmuu ítɛ́ kɛ́kò, kɛ̀ Bɑdɑkii múnkɛɛ ketɛ́ o kó kucɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Mɛm̀mɛ kɛ̀ Isidɑyɛɛribɛ ḿbo Sitimmu kɛ́duɔ́ mbɛ mɑ́ɑ̀ mufòmmu yɛimu kɛ́ndɔuti dɔutinɛ̀ Mɔɑbu ɛì kó bɛnitipòbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Kɛ̀ bɛɛ̀ nitipòbɛ̀ɛ bɛ̀ yũ̀ɔ̃́ nkɛ́tɑnnɛ́ mubɔɔféù miɛkɛ kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ kɛ́di tibɔɔdiitì kɛ́nninku kɛ yɛ̀ bɑ̀ɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Kɛ̀ Isidɑyɛɛribɛɛ fíé iwũɔ̃ dibɔɔ̀ Bɑɑdi-Peɔɔ, kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛɛ bɛ̀ cɔ̀útɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Kɛ̀ kùu nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Tɔní diɛ nyIsidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ́ bɛ̀ nùńnɛ́ diɛ n yììkɛ̀, kɛ́wetínnɛ́ diyiè, kɛ̀ dɛ̀ɛ yie mmí ndi Yiɛ̀ nKuyie nkɛ̀ m miɛkɛɛ do. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Kɛ̀ Mɔyiisii nɑ́kɛ́ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ dɔ̀: Di miɛkɛ bɑ́ wè wèe kuɔ o kó bɛnìtìbɛ̀ bɛ̀ɛ̀ fìé iwũɔ̃ dibɔɔ̀ Bɑɑdi-Peɔɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Mɛm̀mɛ Mɔyiisi nɛ̀ Isidɑyɛɛribɛ sɔmbɛ kɛ̀ bɛ̀ ḿbo mɛtɑummɛ̀ tou bòrìnùù kɛ kuɔ̀. Bɛ nuɔ mmiɛkɛ nkɛ Isidɑyɛɛribɛ kóò mɔù tɔnímɛ̀ Mɑndiyɑ̃ɑ̃bɛ kóo nitipòkù mɔù. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Kɛ̀ ikuɔ́ nìùtì Pinɑsi Edeɑsɑɑ birɛ, Anɔɔ kó dɛyɑɑ̀birɛɛ ítɛ́ Isidɑyɛɛribɛ cuokɛ̀ kɛ́túótɛ́ dɛ kpɑ̃nnì, ");
INSERT INTO tbzsim_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","kóò tũ̀nnɔɔ o touku miɛkɛ kɛ́ bɛ̀ tɑ̃ dikpɑ̃nnì bɛ pɔutì bɛdɛ́ kɛ́kuɔ. Dɛ mɔ̀nnì Kuyie ndo potɛ́ kùù yɛ̃ĩku Isidɑyɛɛribɛ kɛ̀ kùu cómmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Kɛ mɛ nsɔ̃́ mbɛnìtìbɛ̀ kú sikɔupípísìdɛ́ nɛ̀ sikɔupísìnɑ̀ɑ̀ (24000). ");
INSERT INTO tbzsim_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","Ikuɔ́ nìùtì Pinɑsi Edeɑsɑɑ birɛ Anɔɔ yɑɑ̀birɛ bónkùnnɛmu m miɛkɛ kɛ yɛ̃́ Isidɑyɛɛribɛ n dɔ̀ɔ̀ dɛ̀ ò yonkɛmɛ̀. Dɛɛ̀ te kɛ̀ n yí kùɔ Isidɑyɛɛribɛ kɛ bɛ̀ dèè bɑ́ nɛ̀ dɛ̀ do mɛ nni nyonkɛmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Nɛ̀ dɛ kpɛ́í nnɑ́kɛ́ we kɛ tú m bo ò tɑunnɛ̀ kɛ̀ kunɑɑtí mbo ti cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Wenwe nɛ̀ o yɑɑ̀bí nɛ̀ i kó iyɑɑ̀bío bɛ̀ bo ntú ikuɔ́ nìùbɛ̀ sɑ̃́ɑ̃̀ kɛ yɛ̃́ bɛ̀ n dɔ̀ɔ̀ dɛ̀ ò yonkɛmɛ̀, kòò tũ̀ntɛ tìì do bo mí nnɛ̀ Isidɑyɛɛribɛ ti cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Isidɑyɛɛribɛ do wɛ̃nnɛ́nɛ̀ bɛ kou wè nɛ̀ Mɑndiyɑ̃ɑ̃ kóo nitipòkù kɛ́kuɔ o yètìrì do tú Simudi Sɑduu kó dɛbirɛ, ò do tú Simmɛɔ̃ɔ̃ kó kunɑɑ̀mùnkù kóo kótì mɔù nwe. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Kɛ̀ Mɑndiyɑ̃ɑ̃bɛ kóo nitipòkù wenwe yètìrì ntú Kosibi, kòo cicɛ tú Mɑndiyɑ̃ɑ̃bɛ kó kubotí kóo kótì kòo yètìrì tu Tisuu. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","Donɛ̀ Mɑndiyɑ̃ɑ̃ ɛì kɔbɛ mudoò kɛ́ bɛ̀ kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Kɛ yɛ̃́ bɛ̀ do di soutɛ́mɛ̀ kɛ̀ di fìé iwũɔ̃ dibɔɔ̀ Bɑɑdi Peɔɔ tɑ̃rì ĩ́nkɛ̀, kɛ̀ ti Yiɛ̀ nKuyie ndi potɛ́, nɛ̀ tìì do dɔ̀ɔ̀ kɛ̀ bɛ̀ɛ kuɔ Mɑndiyɑ̃ɑ̃ ɛì kɔbɛ kóo kótì kóò sɑpɑ̀ɑ̀ nKosibi. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi nɛ̀ ikuɔ́ nìùtì Edeɑsɑɑ Anɔɔ birɛ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","Kɑɑnnɛ̀ Isidɑyɛɛribɛ botí kumɔu bɛ cɛ̃́ĩ dò ndòmmɛ̀ kɛ́ketɛ́nɛ̀ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsípísìdɛ́ kɛ́ndeètìnko, bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","4","Mɔyiisi nɛ̀ Edeɑsɑɑ ikuɔ́ nìùtì kɛ̀ bɛ̀ɛ dɔɔ̀ ti Yiɛ̀ nKuyie mbɛ̀ nɑ̀kɛ́ tì kɛ́kɑɑ mbɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ntɔ kɛ deètìnko. Bɛ̀ do bɛ̀ kɑ̀ɑ mMɔɑbu biriku miɛkɛ nkɛ kukó nSuditɛ̃ɛ̃ tɑkɛ́, Sedikoo ɛì ììkɛ̀. Ntɛ Isidɑyɛɛribɛ bɛ̀ɛ̀ do yɛ̀ Esibiti kó dihɛì: ");
INSERT INTO tbzsim_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","6","Sɑkɔbu bɛ̀ do yu wè kɛ dɔ̀ Isidɑyɛɛri, o kóo po Dubɛnni weè pɛitɛ́ Enɔki nɛ̀ Pɑduu nɛ̀ Ɛtisidonni nɛ̀ Kɑdimii. Kɛ̀ Anɔkii piɛ́ Anɔkiibɛ. Kɛ̀ Pɑduu piɛ́ Pɑduyiibɛ. Kɛ̀ Ɛtisidonni piɛ́ Ɛtisidonniibɛ. Kɛ̀ Kɑdimii piɛ́ Kɑdimiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Dubɛnni kó tinɑɑ̀mùntì nti mɛmmɛ kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìyiekɛ̀ nɛ̀ sipísìtɑ̃ɑ̃ti (43730). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Pɑduu birɛ mɑrɛ̀ do tú Ediɑbu. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","Kɛ̀ Ediɑbu kó ibí ntú Nɛmmuyɛɛdi nɛ̀ Dɑtɑnni nɛ̀ Abidɑmmu. Dɑtɑnni nɛ̀ Abidɑmmu bɛɛ̀ do niitɛ́ Kodee kó kutɔ̃nkù kɔbɛ bɛ̀ɛ̀ do yetɛ bɛ Yiɛ̀ nKuyie nɛ̀ Mɔyiisi nɛ̀ Anɔɔ bɛ kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Kɛ̀ kɛtenkɛ̀ɛ ɑɑtɛ kɛ́ bɛ̀ mɑɑ́nko, bɛmbɛ nɛ̀ Kodee, kɛ̀ muhɑ̃ɑ̃́ ncɔ́útɛ́ bɛnìtìbɛ̀ sikɔusìdɛ́ nɛ̀ sipísìnùmmù (250), kɛ̀ dɛ̀ bo ndò ndibɛnkɛ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Kɛ̀ Kodee kó ibí iì nkpɑɑ́, inyi do í ku dɛ yiè. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","13","Ntɛ Simmɛɔ̃ɔ̃ nɑɑ̀mùnkù, weè do pɛitɛ́ Yemmuyɛɛdi nɛ̀ Yɑminni nɛ̀ Yɑkinni nɛ̀ Sedɑɑ nɛ̀ Sɑudi. Kòo birɛ Yemmuyɛɛdii piɛ́ Yemmuyɛɛdiibɛ, kɛ̀ Yɑminnii piɛ́ Yɑminniibɛ, kɛ̀ Yɑkinnii piɛ́ Yɑkinniibɛ, kɛ̀ Sedɑɑ piɛ́ Sedɑɑbɛ, kɛ̀ Sɑudii piɛ́ Sɑudiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Simmɛɔ̃ɔ̃ kó tinɑɑ̀mùntì nti mɛmmɛ kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìdɛ́ nɛ̀ sikɔupísìdɛ́ nɛ̀ sikɔusìdɛ́ (22200). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","17","Ntɛ Kɑdi kó kunɑɑ̀mùnkù, weè do pɛitɛ́ Sefonni nɛ̀ Akii nɛ̀ Suni nɛ̀ Osini nɛ̀ Ɛdi nɛ̀ Adodi nɛ̀ Adedii. Kòo birɛ Sefonnii piɛ́ Sefonniibɛ, kɛ̀ Akii piɛ́ Akiibɛ, kɛ̀ Sunni piɛ́ Suniibɛ kɛ̀ Osini piɛ́ Osiniibɛ, kɛ̀ Ɛdii piɛ́ Ɛdiibɛ, kɛ̀ Adodii piɛ́ Adodiibɛ. Kɛ̀ Adedii piɛ́ Adediibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Kɑdi kó tinɑɑ̀mùntì nti mɛmmɛ kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔusìnùmmù (40500). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Sudɑɑ weè do pɛitɛ́ Ɛɛ nɛ̀ Onɑnni kɛ̀ bɛ̀ɛ kú Kɑnnɑhɑ̃ɑ̃ kó dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Kòo yíɛ́ kɛ́pɛitɛ́ Sedɑɑ nɛ̀ Pɛdɛsi nɛ̀ Seedɑ. Kɛ̀ Sedɑɑ piɛ́ Sedɑɑbɛ, kɛ̀ Pɛdɛsii piɛ́ Pɛdɛsiibɛ, kɛ̀ Seedɑɑ piɛ́ Seedɑɑbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Pɛdɛsi weè do yìɛ́ kɛ́pɛitɛ́ Ɛtisidonni nɛ̀ Amudi. Kɛ̀ Ɛtisidonni piɛ́ Ɛtisidonniibɛ, kɛ Amudii piɛ́ Amudiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Sudɑɑ kó tinɑɑ̀mùntì nti mɛmmɛ, kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìyiekɛ̀ nɛ̀ sìkɔupísìkuɔ̀ nɛ̀ sikɔusìnùmmù (76500). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","24","Isɑkɑɑ weè do pɛitɛ́ Todɑ nɛ̀ Puwɑ nɛ̀ Yɑsubu nɛ̀ Simmudonni. Kɛ̀ Todɑɑ piɛ́ Todɑɑbɛ kɛ̀ Puwɑ piɛ́ Puwɑɑbɛ, kɛ̀ Yɑsubuu piɛ́ Yɑsubuubɛ, kɛ̀ Simmudonni piɛ́ Simmudonniibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Isɑkɑɑ kó tinɑɑ̀mùntì nti mɛmmɛ, kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìkuɔ̀ nɛ̀ sikɔupísìnɑ̀ɑ̀ nɛ̀ sikɔusìtɑ̃ɑ̃ti (64300). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sɑbunɔɔ weè do pɛitɛ́ Sedɛdi nɛ̀ Edonni nɛ̀ Yɑdɛɛdi. Kɛ̀ Sedɛdi piɛ́ Sedɛdiibɛ, kɛ̀ Edonni piɛ́ Edonniibɛ, kɛ̀ Yɑdɛɛdi piɛ́ Yɑdɛɛdiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Sɑbunɔɔ kó tinɑɑ̀mùntì nti mɛmmɛ, kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìkuɔ̀ nɛ̀ sikɔusìnùmmù (60500). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Sosɛfu weè do pɛitɛ́ Mɑnɑnsee nɛ̀ Efɑdɑimmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Kɛ̀ Mɑnɑnsee pɛitɛ́ Mɑkiidi, kɛ̀ Mɑkidii piɛ́ Mɑkidiibɛ kɛ yíɛ́ kɛ́pɛitɛ́ Kɑdɑɑdi kòo piɛ́ Kɑdɑɑdiibɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","kɛ́yíɛ́ kɛ́pɛitɛ́ Yesɛɛ nɛ̀ Edɛki. Kɛ̀ Yesɛɛ piɛ́ Yesɛɛbɛ, kɛ̀ Edɛkii piɛ́ Edɛkiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asidiyɛɛdi weè piɛ́ Asidiyɛɛdibɛ, kɛ̀ Sisɛmmu piɛ́ Sisɛmmubɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Kɛ̀ Semidɑɑ piɛ́ Semidɑɑbɛ, kɛ̀ Efɛɛ piɛ́ Efɛɛbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Efɛɛ birɛ Sedofɑdi í mpɛitɛ́ initidɑbí kɛ́piɛ́ initipobí mɑ́ɑ̀. Ntɛ i yètɛ̀: Mɑdɑ nɛ̀ Nɔɑ nɛ̀ Okudɑ nɛ̀ Midikɑ nɛ̀ Tidisɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Mɑnɑnsee kó tinɑɑ̀mùntì nti mɛmmɛ kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìnùmmù nɛ̀ sikɔupísìdɛ́ nɛ̀ sikɔusìyiekɛ̀ (52700). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Kɛ̀ Efɑdɑimmuu pɛitɛ́ Sutedɑɑ nɛ̀ Bekɛɛ nɛ̀ Tɑɑnni. Kɛ̀ Sutedɑɑ piɛ́ Sutedɑɑbɛ, kɛ̀ Bekɛɛ piɛ́ Bekɛɛbɛ, kɛ̀ Tɑɑnnii piɛ́ Tɑɑnniibɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Kɛ̀ Sutedɑɑ yíɛ́ kɛ́pɛitɛ́ Edɑnni kòo piɛ́ Edɑnniibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Efɑdɑimmu kó tinɑɑ̀mùntì nti mɛmmɛ kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìdɛ́ nɛ̀ sikɔusìnùmmù (32500). Sosɛfu bí kó tinɑɑ̀mùntì nti mɛmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","39","Kɛ̀ Bɛnsɑmɛɛ pɛitɛ́ Bedɑɑ nɛ̀ Asebɛɛdi nɛ̀ Ayidɑmmu nɛ̀ Sufɑmmu nɛ̀ Ufɑmmu. Kɛ̀ Bedɑɑ piɛ́ Bedɑɑbɛ, kɛ̀ Asebɛɛdi piɛ́ Asebɛɛdiibɛ, kɛ̀ Ayidɑmmuu piɛ́ Ayidɑmmuubɛ, kɛ̀ Sufɑmmuu piɛ́ Sufɑmmuubɛ, kɛ̀ Ufɑmmu piɛ́ Ufɑmmuubɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Kɛ̀ Bedɑɑ yíɛ́ kɛ́pɛitɛ́ Adidi nɛ̀ Nɑmɑnni. Kɛ̀ Adidi piɛ́ Adidiibɛ, kɛ̀ Nɑmɑnni piɛ́ Nɑmɑnniibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Bɛnsɑmɛɛ kó tinɑɑ̀mùntì nti mɛmmɛ, kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔupísìnùmmù nɛ̀ sikɔusìkuɔ̀ (45600). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","43","Dɑnni kó kunɑɑ̀mùnkù do bo kùmɑ́ɑ̀ ndi, kuù do tú Suɑmiibɛ Suɑmmuu kó ibí, kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìkuɔ̀ nɛ̀ sikɔupísìnɑ̀ɑ̀ nɛ̀ sikɔusìnɑ̀ɑ̀ (64400). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Kɛ̀ Asɛɛ pɛitɛ́ Imunɑ nɛ̀ Isefii nɛ̀ Bediyɑ. Kɛ̀ Imunɑ piɛ́ Imunɑɑbɛ, kɛ̀ Isifii piɛ́ Isifiibɛ, kɛ̀ Bediyɑɑ piɛ́ Bediyɑɑbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Kɛ̀ Bediyɑɑ yíɛ́ kɛ́pɛitɛ́ Ebɛɛ nɛ̀ Mɑdikiyɛɛdi. Kɛ̀ Ebɛɛ piɛ́ Ebɛɛbɛ, kɛ̀ Mɑdikiyɛɛdi piɛ́ Mɑdikiyɛɛdibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Kɛ̀ Asɛɛ pɛitɛ́ dɛnitipobirɛ kɛ́ dɛ̀ yu kɛ dɔ̀: Sedɑki. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Asɛɛ kó tinɑɑ̀mùntì nti mɛmmɛ kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìnùmmù nɛ̀ sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìnɑ̀ɑ̀ (53400). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","49","Kɛ̀ Nɛfutɑdii pɛitɛ́ Yɑseyɛɛdi nɛ̀ Kunni nɛ̀ Yesɛɛ nɛ̀ Sidɛmmu. Kɛ̀ Yɑseyɛɛdii piɛ́ Yɑseyɛɛdiibɛ, kɛ̀ Kunnii piɛ́ Kunniibɛ, kɛ̀ Yesɛɛ piɛ́ Yesɛɛbɛ, kɛ̀ Sidɛmmuu piɛ́ Sidɛmmuubɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Nɛfutɑdii kó tinɑɑ̀mùntì nti mɛmmɛ kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupípísìnɑ̀ɑ̀ nɛ̀ sikɔupísìnùmmù nɛ̀ sikɔusìnɑ̀ɑ̀ (45400). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Isidɑyɛɛribɛ bɛmɔu kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ nkɛ̀ bɛ̀ mbo sikɔupíkɔusìkuɔ̀ nɛ̀ tɛkɔupíítɛ̀ nɛ̀ sikɔusìyiekɛ̀ nɛ̀ sipísìtɑ̃ɑ̃ti (601730). ");
INSERT INTO tbzsim_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Kɛ̀ ti Yiɛ̀ nKuyie nsɔɔtɛ́ kɛ́bɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","Tiì nɑɑ̀mùntì nti di yóó totímɛ̀ kɛtenkɛ̀ kɛ́ntũ mbɛ̀ sũ kɛ dò ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Kɛ̀ bɛ̀ɛ̀ kó kunɑɑ̀mùnkù dɛu bɛ kó kɛtenkɛ̀ ndɛu, kɛ̀ bɛ̀ɛ̀ kɔku kɛ̃ńnì bɛ kɔkɛ nkɛ̃ńnì, di bɛ̀ totí bɑ́ wè o nɑɑ̀mùnkù mɑ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Di yóó tɑ̃ɑ̃́ tɛ́tɛ́ nwe kɛ́totí dɛ kó kɛtenkɛ̀, di níí yóó duɔ́ mbɑ́ wè o kó kɛtenkɛ̀ dí kɑ̀ɑ nho nɑɑ̀mùnkù miɛkɛ bɛnìtìbɛ̀ kɛ̀ bɛ̀ mɑ̀mɛ̀ mmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Tɛ́tɛ́ weè níí yóó bɛnkɛ di yóó duɔ́ nkùù nɑɑ̀mùnkù dɛu kɛtenkɛ̀ kɛ̀ kɛ̀ mmɑmɛ̀, kɛ́duɔ́ nkùù kɛ̃ńnì kɛ̀ kɛ̀ mmɑmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Kɛ̀ bɛ̀ɛ kɑɑ nDefii kó kuwuɔ, ntɛ bɛ̀ do kù kɑ̀ɑ nkɛ̀ kù ndò ndòmmɛ̀. Kɛ̀ Kɛrisonni kó kunɑɑ̀mùnkù ntú Kɛrisonniibɛ, kɛ̀ Keɑti kɔku ntú Keɑtiibɛ, kɛ̀ Mɛdɑdi kɔku ntú Mɛdɑdiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Defii kó tinɑɑ̀mùntì tɛtì do tú: Dibiniibɛ nɛ̀ Ebedoniibɛ nɛ̀ Mɑdiibɛ nɛ̀ Musiibɛ nɛ̀ Kodeyiibɛ. Keɑti weè do pɛitɛ́ Amudɑmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Kɛ̀ Amudɑmuu puokɛ Defii botí kóo sɑpɑ̀ɑ̀ mmɔù, kòo yètìrì tu Yokebɛti bɛ̀ do pɛitɛ́ wè Esibiti kòò ò pɛitɛ́nɛ̀ Anɔɔ nɛ̀ Mɔyiisi nɛ̀ bɛ tɑ̃ũ̀ Midiyɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Kɛ̀ Anɔɔ pɛitɛ́ Nɑdɑbu nɛ̀ Abiu nɛ̀ Edeɑsɑɑ nɛ̀ Idɑmɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Nɑdɑbu nɛ̀ Abiu kɛ̀ bɛ̀ɛ tùɔ nti Yiɛ̀ nKuyie ntihúúntì nɛ̀ muhɑ̃ɑ̃́ nsɔ̃́ntíkɛ kɔ̃mu kɛ́kú. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Kɛ̀ bɛ̀ɛ kɑɑ mbɛnitidɑɑbɛ̀ kɛ́túótɛ́ ibí ìì mɔ̀kɛ otɑ̃̀nkù òmɑ́ɑ̀ kɛ́ntɔ kɛ deètìnko kɛ̀ bɛ̀ ḿbo sikɔupípísìdɛ́ nɛ̀ sikɔupísìtɑ̃ɑ̃ti (23000). Bɛ̀ do í bɛ̀ wɛ̃nnɛ́nɛ̀ Isidɑyɛɛribɛ sɔmbɛ kɛ́kɑɑ, nkɛ yɛ̃́ bɛ̀ do í mɔkɛmɛ̀ kɛtenkɛ̀ Isidɑyɛɛribɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Mɔyiisi nɛ̀ ikuɔ́ nìùtì Edeɑsɑɑ kɛ̀ bɛ̀ɛ bɛ̀ kɑ̀ɑ Mɔɑbu biriku Suditɛ̃ɛ̃ kó ntɑkɛ́ Sedikoo ɛì ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Mɔyiisi nɛ̀ ikuɔ́ nìùtì Anɔɔ bɛ̀ do kɑ̀ɑ mbɛ̀ Sinɑii kó dikpɑ́ɑ̀ miɛkɛ bɛ kóò mɔù tɛ̃́nkɛ do í kpɑɑ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Ti Yiɛ̀ nKuyie nkuù do bɛ́i nkɛ dɔ̀: Bɛmɔu bɛ̀ bo kú dikpɑ́ɑ̀ miɛkɛ, kɛ̀ bɛ̀ mɛ̀nkɛ kú bɑ́ òmɔù í nsùɔ́ mbɑ́ òmɑ́ɑ̀, kɛ̀ dɛ̀ í tú Yefundee birɛ Kɑdɛbu nɛ̀ Nunni birɛ Sosuwee. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Sosɛfu birɛ Mɑnɑnsee kó kunɑɑ̀mùnkù kou mɔù bɛ̀ tu wè Mɑkiidi, weè do pɛitɛ́ Kɑdɑɑdi kòo mɛ ntó pɛitɛ́ Efɛɛ kɛ̀ Efɛɛ pɛitɛ́ Sedofɑdi kòo piɛ́ bɛsɑpɑ̀mbɛ̀ mɑ́ɑ̀ bɛ̀ɛ̀ yètɛ̀ tu: Mɑdɑ nɛ̀ Nɔɑ nɛ̀ Okudɑ nɛ̀ Midikɑ nɛ̀ Tidisɑɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Kɛ̀ bɛ̀ɛ kɔtɛ kɛ́yɑ̀ Mɔyiisi nɛ̀ ikuɔ́ nìùtì Edeɑsɑɑ nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ nɛ̀ Isidɑyɛɛribɛ bɛmɔu mɛtɑummɛ̀ tou borɛ̀, kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","Ti cicɛ ku dikpɑ́ɑ̀ miɛkɛ nkɛ, ò mɛ ndo í kɔkɛ́ Kodee kó kutɔ̃nkù miɛkɛ bɛ̀ɛ̀ do yetɛ ti Yiɛ̀ nKuyie nkpɛti. Ò ku omɑ́ɑ̀ kó mɛyɛi nkó mukṹṹ mmu ò mɛ nyí mɔkɛ dɛnitidɑbirɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Ti cicɛ yètìrì bo kpɑ́nnɛ́ o tebìí nɑɑ̀mùnkù miɛkɛ ò í mɔkɛ mɛ̀ɛ̀ kpɛ́í nhonitidɔ̀ùɑ̀? Dí ti duɔ́ nti kó kɛtenkɛ̀ ti cicɛ tebìí kɔkɛ borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Kɛ̀ Mɔyiisii beé nKuyie, ");
INSERT INTO tbzsim_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Kɛ̀ kùu ò tɛ̃̀ńnɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Sedofɑdi kó bɛsɑpɑ̀mbɛ̀ nɑɑtimu duɔ́ mbɛ bɛ kó kɛtenkɛ̀, bɛ cicɛ tebìí kɔkɛ borɛ̀, bɛɛ̀ yó nte bɛ cicɛ kó kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Kɑ̀ɑ nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú: Kòo nìtì níí ku kɛ í mɔkɛ dɛnitidɑbirɛ, kòò mɔ̀kɛ dɛnitipobirɛ dɛɛ̀ yóó tiekɛ o kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Kòò mɛ nyí mɔkɛ dɛnitipobirɛ o tebìí tiekɛ o kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Kòò í mɔkɛ o tebìí o cicɛ kó sitebìí tiekɛ o kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Kòo cicɛ mɛ nyí mɔkɛ o tebìí o nɑɑ̀mùnkù kou wèè ò tɔ̀kɛ́nɛ̀ wèe dɛ̀ tiekɛ. Isidɑyɛɛribɛ kpɛrɛ bɛ̀ mɔ̀kɛ dɛ kó ikuɔ́ yó nni nyi, ti Yiɛ̀ nKuyie ndo mɛ nnɑ̀kɛ́ Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nsɔɔtɛ́ kɛ́nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: Dekɛ ditɑ̃rì Abɑdimmu ĩ́nkɛ̀, kɛ wéntɛ́ kɛ́yɑ̀ dihɛì n duɔ́ ndì Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Kɑ̀ɑ di yɑ̀ kɛ dèè ɑ kũnti ɑ yɛmbɛ̀ borɛ̀ ndɛ, ɑ kóo kótì Anɔɔ kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Kɛ yɛ̃́ di do í yiemmɛ̀ kɛ tũ̀nnɛ n nùù Sinni kó dikpɑ́ɑ̀ miɛkɛ. Isidɑyɛɛribɛ do tùùtɛ dìì mɔ̀nnì kɛ́ nni nkpɑnnɛ̀, kɛ̀ di ndò nkɛ bɛ̀ duɔ́ mmɛniɛ nkɛ̀ bɛ̀ɛ yɑ̀ n cɑ̃́ɑ̃́mmɛ̀ kɛ kpeńnì, di mɛ nyí mɛ̀ dɔ̀ɔ̀. Kù do buɔ̀ dikpɑ̀nnì kó mɛniɛ mmɛ bɛ̀ do bo dìì mɔ̀nnì Kɑdɛɛsi Sinni kó dikpɑ́ɑ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Kɛ̀ Mɔyiisii nɑ́kɛ́ ti Yiɛ̀ nKuyie nkɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","Ti Yiɛ̀ nKuyie nfɔ̃́ nwèè duɔ̀ ndɛnɛnnɛ̀ dɛmɔu mufòmmu, tɑ̃ɑ̃tɛ́ onìtì wèè yó mbɑkɛ́ ɑ nìtìbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Onìtì wèè yó mbɛ̀ ni dɛmɔu miɛkɛ, wèè níí yóó bɛ̀ dènnɛ kɛ́ bɛ̀ tɑnnɛ́, kɛ̀ dɛ̀ɛ yie nkɛ̀ Isidɑyɛɛribɛɛ bɑ́ ndò ntipìètì tìì kpɑ ocɛ̃nti. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Kɛ̀ ti Yiɛ̀ Kuyie nnɑ̀kɛ́ Mɔyiisi kɛ dɔ̀: Túótɛ́ Nunni birɛ Sosuwee, n kó Muyɑɑ́ mbonɛ̀ wè, kóò nɔ̀ɔ́ nsinɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Kóò bɛnkɛ ikuɔ́ nìùtì Edeɑsɑɑ nɛ̀ Isidɑyɛɛribɛ bɛmɔu kòo dɑ cɔutɛ́ mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Kɑ̀ɑ ò yɑ̀ɑ̀tɛ ɑ kó muwɛ̃rímú kɛ̀ dɛ̀ɛ yie nkɛ̀ Isidɑyɛɛribɛ bɛmɔu nyíé nho kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Wenwe o mɔ́mmuɔ ò níí yóó kɔtɛ ikuɔ́ nìùtì Edeɑsɑɑ borɛ̀ ndɛ kòo m beé nnɛ̀ ikuɔ́ nɛntì bɛ̀ tu tì udimmu. Sosuwee o mɔ́mmuɔ nnɛ̀ Isidɑyɛɛribɛ sɔmbɛ bɛ̀ níí yó ntũ nweè kó dinùù. Kòò yĩ: Yɛ̀nnɛ̀! Bɛ̀ɛ yɛ̀. Kòò yĩ: Tɑnnɛ̀! Bɛ̀ɛ tɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Kɛ̀ Mɔyiisii dɔɔ̀ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì kɛ́kɔtɛnɛ̀ Sosuwee ikuɔ́ nìùtì Edeɑsɑɑ borɛ̀ Isidɑyɛɛribɛ bɛmɔu borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Kóò nɔ̀ɔ́ nsinɔu, kóò duɔ́ mmutɔ̃mmú ti Yiɛ̀ nKuyie ndo ò nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkɛ̀ dɛ̀ níí tùɔ̀kɛ bɛ̀ bo n fíé dɛ̀ iwũɔ̃ kɛ́tuɔ bɛ̀ ndɑkɛ kɛ ì nni nfíé kɛ́tuɔ dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Bɑ́ dìì yiè bɛ̀ níí n féútɛ́ dipedɑbii dìì mɔ̀kɛ dibenni dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. Bɑ́ dìì yiè yɛ̀dɛ́ɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Di níí n féútɛ́ dipedɑpɑ̀nnì dìmɑ́ɑ̀ dikṹnweńnì, didɛ́rì kuyuoku dihuri. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Kɛ̀ dí dì wɛ̃nnɛ́nɛ̀ muyuo nsɑ̀ɑ̀mù cìdóò bɛ̀tɑ̃ɑ̃ti kɛ́ mu kɔɔrɛnɛ̀ mɛkɔ̀sɑ̀ɑ̀mɛ̀ dítìrì omɑ́ɑ̀ nɛ̀ dikéè kɛ́ɑ̃ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Di yó nyi nni nfeumu di do ì nni nfeumɛ̀ Sinɑii tɑ̃rì nɛ̀ dimɔ̀nnì kɛ tuɔ̀, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Dikṹnweńnì kó dipedɑpɑ̀nnì níí yó nnɛínɛ̀ mɛnɑɑ̀ mmɛ dítìrì nɛ̀ dikéè. Mɛtɑummɛ̀ tou miɛkɛ nkɛ di níí yóó mɛ nni ncóúmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Di níí féútɛ́ dipedɑpɑ̀nnì tɛrì kuyuoku dihuri, kɛ yíɛ́nɛ̀ yɛpɑ̃rɛ̀ di bɑɑ do m pɑ̃ɑ̃ nyɛ̀ dikṹnweńnì kó dipedɑpɑ̀nnì ĩ́nkɛ̀, kɛ di nni ntuɔ, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Tɛom̀pùtɛ̀ yiè di níí n féútɛ́ yɛpedɑbɛ yɛ̀dɛ́ɛ̀, yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù, kɛ́yíɛ́nɛ̀ muyuo nsɑ̀ɑ̀mù cìdóò bɛ̀kuɔ̀, kɛ mù ɑ̃̀ntɛnɛ̀ mɛkɔsɑ̀ɑ̀mɛ̀, kɛ yíɛ́nɛ̀ mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Bɑ́ tɛ̀ɛ̀ om̀pùtɛ̀ yiè di níí yóó yíɛ́mu dɛ kó iwũɔ̃ di do n feu ì yɛwe yɛmɔu i ĩ́nkɛ̀ nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Otɑ̃̀nkù yiè ketirì di níí n féútɛ́ yɛnɑɑdɑkɛ̀ yɛ̀dɛ́ɛ̀ kɛ́tuɔ, nnɛ̀ dipedɑɑ̀ dìmɑ́ɑ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ yɛ̀yiekɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Kɛ níí pɑ̃nɛ̀ bɑ́ fɛ̀ɛ̀ ɔ̃̀fɛ̀ ĩ́nkɛ̀ muyuo nsɑ̀ɑ̀mù mùù ɑ̃̀ntɛnnɛ̀ mɛkùɔ̀, ncìdóò bɛ̀wɛi bɑ́ dìì nɑɑdɑɑ̀ ĩ́nkɛ̀, cìdóò bɛ̀kuɔ̀ bɑ́ dìì pedɑɑ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Cìdóò bɛ̀tɑ̃ɑ̃ti bɛ̀tɑ̃ɑ̃ti bɑ́ dìì pedɑpɑ̀nnì ĩ́nkɛ̀, kɛ̀ dí dɛ̀ tùɔ, yɛpɑ̃rɛ̀ nyɛ yɛ̀ɛ̀ kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Mɛnɑɑ̀ ndítìrì bɛ̀tɑ̃ɑ̃ti bɛ̀tɑ̃ɑ̃ti bɑ́ dìì nɑɑdɑɑ̀ ĩ́nkɛ̀, dítìrì bɛ̀dɛ́ bɑ́ dìì pedɑɑ̀ ĩ́nkɛ̀, dítìrì òmɑ́ɑ̀ òmɑ́ɑ̀ nɛ̀ dikéè bɑ́ dìì pedɑpɑ̀nnì ĩ́nkɛ̀. Bɑ́ wèè tɑ̃̀nkù kó diyiè ketirì di níí yó n fíé ìì wũɔ̃ nyi nɛ̀ dɛ kó yɛpɑ̃rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Di níí n féútɛ́ dibɔdɑɑ̀ dìmɑ́ɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́mbúútí di n feu ìì wũɔ̃ kɛ tuɔ̀ nyɛwe yɛmɔu nɛ̀ dɛ kó mɛnɑɑ̀ di m pɑ̃ɑ̃ mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Dibenni tɑ̃̀nkù ketiwè diyiè tɛpíítɛ̀ nɛ̀ dinɑɑnnì di níí bɑɑ́ ndiyentɛ́bɑnni kɛ́dɛ́úkùnnɛ mí ndi Yiɛ̀ nKuyie n yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Diyiè tɛpíítɛ̀ nɛ̀ dinummurì yiè ndi, dibɑnni yóó ketɛ́mɛ̀ kɛ̀ di ncɑ́ɑ́ mpɛ̃́ɛ̃̀ wèè í kɔɔrɛnɛ̀ mutie mùù muuti kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Dibɑnni ketírí dìì yiè di tíí nkɛ́sɑ̃ntɛ mí ndi Yiɛ̀ nKuyie di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù dɛ yiè. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Dɛ yiè di níí n féútɛ́ i nwũɔ̃ kɛ́tuɔ: Yɛnɑɑdɑkɛ̀ yɛ̀dɛ́ɛ̀, dipedɑɑ̀ dìmɑ́ɑ̀ yɛpedɑpɑ̀ɑ̀ nyɛ̀yiekɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Di níí pɑ̃nɛ̀ bɑ́ fɛ̀ɛ̀ ɔ̃̀fɛ̀ yuu ĩ́nkɛ̀ muyuo nsɑ̀ɑ̀mù mùù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ ncìdóò bɛ̀wɛi bɑ́ dìì nɑɑdɑɑ̀ ĩ́nkɛ̀, cìdóò bɛ̀kuɔ̀ bɑ́ dìì pedɑɑ̀ ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","cìdóò bɛ̀tɑ̃ɑ̃ti bɛ̀tɑ̃ɑ̃ti bɑ́ dìì pedɑpɑ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Kɛ̀ di n féútɛ́ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ̀ bɛ̀ di dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Di níí yó n fíé ìì wũɔ̃ nyi kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ tuɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Di yó mmɛ nhɔ̃ nkɛ dɔ̀ yɛwe yɛ̀yiekɛ̀, mudiì mmu di níí yó m pɑ̃ mù kɛ́tuɔ, mùù kó kufɔ̃ɔ̃ku n nɑɑti. Dɛ kó dipɑ̃nnì cɑ̃̀ɑ̃́nnɛ̀ mu di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nnɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Diyiè yiénnì yiè di tíí nkɛ́sɑ̃ntɛ mí ndi Yiɛ̀ nKuyie, di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù dɛ yiè. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Dididɛ̀ìbɑnni yiè, di yó m pɑ̃ dìì yiè tidipɑ̀ntì, dɛ yiè di tíí nkɛ́ n sɑ̃ntɛ, di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Dɛ yiè di n féútɛ́ yɛnɑɑdɑkɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ dipedɑɑ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ nyɛ̀yiekɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ́ dɛ̀ tùɔ, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Kɛ̀ di wɑɑ́ mbɑ́ fɛ̀ɛ̀ ɔ̃̀fɛ̀ yuu ĩ́nkɛ̀ muyuo nsɑ̀ɑ̀mù mùù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ ncìdóò bɛ̀wɛi bɑ́ dìì nɑɑdɑɑ̀ ĩ́nkɛ̀, cìdóò bɛ̀kuɔ̀ bɑ́ dìì pedɑɑ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Cìdóò bɛ̀tɑ̃ɑ̃ti bɛ̀tɑ̃ɑ̃ti bɑ́ dìì pedɑpɑ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Kɛ̀ di kuɔnɛ̀ dibɔdɑɑ̀ kɛ̀ bɛ̀ di dɔɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Di yó n fíé ìì wũɔ̃ nyi kɛ nɛ́ mbúútí di ɔ̃ n fíé ì nɛ̀ tidiitì kó yɛpɑ̃rɛ̀. Dɛ kó iwũɔ̃ yó ntú ìì kpɑ ìnyi kuyɛ̀nkù kɛ́yíɛ́nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Dibenni tɑ̃̀nkù yiénwè kó diyiè ketirì di níí tíí nkɛ́ n sɑ̃ntɛ dɛ yiè, di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù. Disɑ̃nni kó dibɑnni ndi. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Dɛ yiè di n féútɛ́ dinɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ nyɛ̀yiekɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù, kɛ́ dɛ̀ tùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Di wɑɑ́ mbɑ́ fɛ̀ɛ̀ ɔ̃̀fɛ̀ kpɛ́í muyuo nsɑ̀ɑ̀mù mùù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ ncìdóò bɛ̀wɛi dinɑɑdɑɑ̀ ĩ́nkɛ̀, cìdóò bɛ̀kuɔ̀ dipedɑɑ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Cìdóò bɛ̀tɑ̃ɑ̃ti bɛ̀tɑ̃ɑ̃ti bɑ́ dìì pedɑpɑ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Kɛ̀ dí kuɔnɛ̀ dibɔdɑɑ̀ dìmɑ́ɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ̀ bɛ̀ di dɔ̀ɔ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kó ikuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Dɛ kó iwũɔ̃ cɑ̃́ɑ̃́nnɛ̀mu di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nnɛ̀ di m pɑ̃ɑ̃ mmùù diì nɛ̀ dɛ kó mɛnɑɑ̀. Dɛ kó dipɑ̃nnì níí yó ntú di tuɔ ndì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Dibenni tɑ̃̀nkù yiénwè kó diyiè píínnì yiè di níí tíí nkɛ́boú dinùù kɛ́ n sɑ̃ntɛ. Di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Dɛ yiè di n féútɛ́ dinɑɑdɑɑ̀ nɛ̀ dipedɑɑ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ nyɛ̀yiekɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀, kɛ kpɑ kuyɛ̀nkù kɛ́ yɛ̀ nni ntuɔ. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Dí wɑɑ́ mmuyuo nsɑ̀ɑ̀mù mùù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ ncìdóò bɛ̀wɛi dinɑɑdɑɑ̀ ĩ́nkɛ̀, cìdóò bɛ̀kuɔ̀ dipedɑɑ̀ ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","cìdóò bɛ̀tɑ̃ɑ̃ti bɛ̀tɑ̃ɑ̃ti bɑ́ dìì pedɑpɑ̀nnì ĩ́nkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","kɛ́kuɔnɛ̀ dibɔdɑɑ̀ dìmɑ́ɑ̀ mɛyɛi nhũtímù kpɛ́í kɛ̀ bɛ̀ di dɔɔ̀ dɛ kó ikuɔ́, kɛ nɛ́ mbúútí di n fèútɛ́ dì mɛyɛi nhũtímù kó diyiè diɛrì nɛ̀ di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nnɛ̀ dɛ kó mudiì nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Otɑ̃̀nkù yiénwè kó diyiè tɛpíítɛ̀ nɛ̀ dinummurì, di níí tíí nkɛ́ n sɑ̃ntɛ, di bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù. Di yó mbɑɑ̀ mmí ndi Yiɛ̀ nKuyie n kó dibɑnni ndi kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Diyiè ketirì kɛ́ n féútɛ́ yɛnɑɑdɑkɛ̀ tɛpíítɛ̀ nɛ̀ yɛ̀tɑ̃ɑ̃ti kɛ́tuɔ nnɛ̀ yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ntɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. Dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Kɛ̀ di wɑɑ́ mmuyuo mmùù ɑ̃̀ntɛnɛ̀ mɛkùɔ̀ ncìdóò bɛ̀wɛi, bɑ́ dìì nɑɑdɑpɑ̀nnì ĩ́nkɛ̀. Cìdóò bɛ̀kuɔ̀ bɑ́ dìì pedɑɑ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Cìdóò bɛ̀tɑ̃ɑ̃ti bɛ̀tɑ̃ɑ̃ti bɑ́ dìì pedɑpɑ̀nnì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Kɛ̀ di kuɔnɛ̀ dibɔdɑɑ̀ dìmɑ́ɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","Diyiè dɛ́rì yiè dí n féútɛ́ yɛnɑɑdɑpɑ̀ɑ̀ ntɛpíítɛ̀ nɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑkɛ̀ nyɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ntɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Dí nɔ́ɔ́nnɛ̀ tidiitì di ɔ̃ɔ̃ nɔ́ɔ́ nkɛ̀ tì mmɑmɛ̀ bɑ́ fɛ̀ɛ̀ ɔ̃̀fɛ̀ ĩ́nkɛ̀, kɛ́ndònnɛ̀ di mɔkɛmɛ̀ dɛ kó mɛmɑntímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Dí kuɔnɛ̀ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ́tuɔ nnɛ̀ dɛ kó tidiitì nɛ̀ mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","Diyiè tɑ̃ɑ̃́nnì yiè kɛ̀ dí n féútɛ́ yɛnɑɑdɑkɛ̀ tɛpíítɛ̀ nɛ̀ dìmɑ́ɑ̀ nɛ̀ yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ntɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Dí yíɛ́nɛ̀ tidiitì nɛ̀ dɛ kó mɛnɑɑ̀, kɛ̀ dɛ̀ mmɑ̀nnɛ̀ yɛnɑɑdɑkɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ndɛ̀ mɑ̀mɛ̀, kɛ́ndònnɛ̀ di mɔkɛmɛ̀ dɛ kó mɛmɑntímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Dí di kùɔnɛ̀ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ tuɔ nnɛ̀ dɛ kó tidiitì nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","Diyiè nɑɑnnì yiè dí n féútɛ́ yɛnɑɑdɑkɛ̀ tɛpíítɛ̀ nɛ̀ yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀, nɛ̀ yɛpedɑpɑ̀ɑ̀ ntɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Kɛ̀ dí wɑɑ́nnɛ̀ tidiitì nɛ̀ mɛnɑɑ̀ kɛ̀ dɛ̀ mmɑ̀nnɛ̀ iwũɔ̃ mɑmɛ̀, kɛ́ndònnɛ̀ di mɔkɛmɛ̀ dɛ kó mɛmɑntímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Kɛ̀ dí kuɔ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nnɛ̀ dɛ kó tidiitì nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","Diyiè nummurì yiè dí n feutɛ́ yɛnɑɑdɑkɛ̀ yɛ̀wɛi, yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ntɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Kɛ̀ dí yíɛ́nɛ̀ tidiitì nɛ̀ mɛnɑɑ̀ kɛ̀ dɛ̀ mmɑnɛ̀ yɛnɑɑdɑkɛ̀ nɛ̀ yɛpedɑkɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ndɛ̀ mɑ̀mɛ̀, kɛ́ndònnɛ̀ di mɔkɛmɛ̀ dɛ kó mɛmɑntímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Kɛ̀ di kuɔnɛ̀ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nnɛ̀ dɛ kó tidiitì nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","Diyiè kuɔ́nnì yiè kɛ̀ dí n feutɛ́ yɛnɑɑdɑkɛ̀ yɛ̀ni, yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ntɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù, ");
INSERT INTO tbzsim_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","kɛ́ yíɛ́nɛ̀ tidiitì nɛ̀ mɛnɑɑ̀ kɛ̀ dɛ̀ mmɑnnɛ̀ yɛnɑɑdɑkɛ̀ nɛ̀ yɛpedɑkɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ndɛ̀ mɑ̀mɛ̀, kɛ́ndònnɛ̀ di mɔkɛmɛ̀ dɛ kó mɛmɑntímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Kɛ̀ dí kuɔ dibɔdɑɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nnɛ̀ dɛ kó tidiitì nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","Diyiè yiénnì yiè kɛ̀ dí n feutɛ́ yɛnɑɑdɑkɛ̀ yɛ̀yiekɛ̀, yɛpedɑkɛ̀ yɛ̀dɛ́ɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ntɛpíítɛ̀ nɛ̀ yɛ̀nɑ̀ɑ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ kpɑ kuyɛ̀nkù. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Kɛ̀ dí yíɛ́nɛ̀ tidiitì nɛ̀ mɛnɑɑ̀ kɛ̀ dɛ̀ mmɑnnɛ̀ yɛnɑɑdɑkɛ̀ nɛ̀ yɛpedɑkɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ndɛ̀ mɑ̀mɛ̀, kɛ́ndònnɛ̀ di mɔkɛmɛ̀ dɛ kó mɛmɑntímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Kɛ̀ dí kuɔ dibɔdɑɑ̀ dìmɑ́ɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nnɛ̀ dɛ kó tidiitì nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Diyiè niínnì yó ntú dibɑnni denni dìì yiè ndi di bɑ́ mpĩ́ mmutɔ̃mmú mɑmù dɛ kó diyiè. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Dɛ yiè dí n féútɛ́ dinɑɑdɑɑ̀ dìmɑ́ɑ̀, yɛpedɑpɑ̀ɑ̀ nyɛ̀yiekɛ̀ yɛ̀ɛ̀ mɔ̀kɛ dibenni dìmɑ́ɑ̀ dìmɑ́ɑ̀ kɛ́tuɔ, dipɑ̃nnì ndi dìì kó kufɔ̃ɔ̃ku n nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Kɛ̀ dí yíɛ́nɛ̀ tidiitì nɛ̀ mɛnɑɑ̀ kɛ̀ dɛ̀ mmɑnɛ̀ dinɑɑdɑɑ̀ nɛ̀ yɛpedɑkɛ̀ nɛ̀ yɛpedɑpɑ̀ɑ̀ ndɛ̀ mɑ̀mɛ̀, kɛ́ndònnɛ̀ di mɔkɛmɛ̀ dɛ kó mɛmɑntímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Dí kuɔ dibɔdɑɑ̀ dìmɑ́ɑ̀ mɛyɛi ncĩ́ɛ̃́mmɛ̀ kpɛ́í, kɛ́mbúútí di n feu ì yɛwe yɛmɔu kɛ tuɔ̀ nnɛ̀ dɛ kó tidiitì nɛ̀ dɛ kó mɛnɑɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Kɛ̀ dɛ kó dimɔ̀nnì níí tùɔ̀kɛ di yóó i nni nfíé kɛ́mbúútí di n feu ì di n cɑ̀nnɛnɛ̀ yɛ̀ɛ̀ nɔ̀ kpɛ́í nɛ̀ di n feu ì nɛ̀ diwɛ̀ì nɛ̀ di n feu ì kɛ tuɔ̀ nnɛ̀ dɛ kó tidiitì nɛ̀ dɛ kó mɛnɑɑ̀ nnɛ̀ di n feu ì mɛtɑummɛ̀ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Kɛ̀ Mɔyiisii nɑ́kɛ́ Isidɑyɛɛribɛ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì timɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mɛm̀mɛ kɛ̀ Mɔyiisi bɛ́innɛ̀ Isidɑyɛɛribɛ botí kó bɛkótíbɛ̀ kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Ntɛnɛ̀ ti Yiɛ̀ nKuyie mbɛ́i ntì. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","Kù tu kòo mɔù kù cɑ̀nnɛnɛ̀ dinùù kɛ pɑ̀rìkɛ̀ kɛ yu ku yètìrì kɛ yɛ̃ nhò yóó kù dɔ̀ɔ̀ mɛ̀, ò bɑ́ɑ́ yóu ò bo mɛ̀ dɔ̀ɔ̀ mɛ̀. Ò dò nkɛ́ mɛ̀ dɔɔ̀mu mɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Kɛ̀ dɛ̀ dò nhosɑpɑ̀ɑ̀ mmɔù kpɑɑ́ ɑ̃ nɛ̀ o cicɛ kɛ cɑ̀nnɛnɛ̀ ti Yiɛ̀ nKuyie ndinùù kɛ yɛ̃ nhò yóó kù dɔ̀ɔ̀ mɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","kòo cicɛ kèè ò cɑ̀nnɛnɛ̀mɛ̀ ti Yiɛ̀ nKuyie ndinùù kɛ pɑ̀rìkɛ̀. Kòo cicɛ í ò nɑ̀kɛ́ tìmɑtì ò dò nkɛ́ mɛ̀ dɔ̀ɔ̀mu mɛmɔu ò yɛ̃ nhò yóó dɔɔ̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Kɛ̀ dɛ̀ mɛ ndò nho cicɛ ti kèè dìì yiè kòò tì yetɛ ò tɛ̃́nkɛ bɑ́ɑ́ dɔɔ̀ ò kù cɑ̀nnɛnɛ̀ dinùù kɛ pɑ̀rìkɛ̀ kɛ yɛ̃ nhò yóó dɔɔ̀mɛ̀, ti Yiɛ̀ nKuyie nyóó ò cĩ́ɛ̃́mmu kɛ yɛ̃́ o cicɛ weè yetɛmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Kɛ̀ dɛ̀ mɛ ndò nhosɑpɑ̀ɑ̀ mmɔù yenkɛ, kòo nùù ò fìtɛ́nɛ̀ kòò cɑ̀nnɛnɛ̀ ti Yiɛ̀ nKuyie ndinùù kɛ pɑ̀rìkɛ̀ kɛ yunɛ̀ ku yètìrì, ");
INSERT INTO tbzsim_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","kòo dɔù tì kèè dìì yiè kɛ í bɛ́i ntìmɑtì, dɛ kó dinùù kpɑɑ́ cɑmmumu, kòò dò nkɛ́dɔɔ̀ ò pɑ̀rìkɛ̀ kɛ yɛ̃ nhò yóó dɔɔ̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Kɛ̀ dɛ̀ mɛ ndò nho dɔù tì kèè dìì yiè kòò tì yetɛ, o nùù do ò fìtɛ́nɛ̀ kòò kù cɑ̀nnɛnɛ̀ dinùù kɛ́pɑrìkɛ̀ kɛ yɛ̃ nhò yóó dɔɔ̀ mɛ̀, dɛ kó dinùù tɛ̃́nkɛ í yóó nhò pĩ, ti Yiɛ̀ nKuyie nhò cĩ́ɛ̃́mmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Kɛ̀ dɛ̀ mɛ ntu okúpokù nwe yoo wèè yenkɛ kòo dɔù ò yetɛ, kòò cɑ̀nnɛnɛ̀ ti Yiɛ̀ nKuyie ndinùù ò dò nkɛ́ dì dɔ̀ɔ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Kɛ̀ dɛ̀ mɛ ntú o dɔù cĩ́ɛ̃̀tɛ̀ ntɛ ò cɑ̀nnɛ̀nɛ̀mɛ̀ dinùù ti Yiɛ̀ nKuyie nkɛ pɑ̀rìkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","kòo dɔù tì kèè kɛ í ò bɛ́innɛ̀ tìmɑtì ò mɛ nyí yetɛ ò dò nkɛ́dɔɔ̀mu ò kù cɑ̀nnɛnɛ̀ dìì nùù nɛ̀ ò pɑ̀rìkɛ̀ kɛ yɛ̃ nhò yóó dɔɔ̀ tì, bɑ́ kɛ̀ tì tu tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Kɛ̀ dɛ̀ mɛ ndò nho dɔù tì kèè dìì yiè kòò tì yetɛ kɛ pɑ̀ɑ ndɛ kó dinùù nɛ̀ ò pɑ̀rìkɛ̀ kɛ yɛ̃ nhò yóó dɔɔ̀ mɛ̀, mɛ̀ pɑ̀ɑ̀mu kɛ̀ ti Yiɛ̀ nKuyie nhò cĩ́ɛ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Onitipòkù cɑ̀nnɛnɛ̀ yɛ̀ɛ̀ nɔ̀ Kuyie nyɛmɔu nɛ̀ ò pɑ̀rìkɛ̀ kɛ bɛ́i nkɛ yɛ̃ nhò yóó fɛ̃́ṹ mmɛ̀ɛ̀ botí omɑ́ɑ̀, o dɔù bo nɑ kɛ tì pɑ̀ɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Kɛ̀ dɛ̀ mɛ ndò nho dɔù tì kèè kɛ cĩ́ɛ̃́kɛ́ kɛ í ò bɛ́innɛ̀ tìmɑtì, kɛ̀ dɛ̀ wentɛ́ ò yiemmu ò cɑ̀nnɛnɛ̀ tì ti Yiɛ̀ nKuyie nyɛ̀ɛ̀ nɔ̀ yɛmɔu, nɛ̀ ò pɑ̀rìkɛ̀ kɛ bɛí ntì timɔu, kɛ yɛ̃́ ò tì kèè dìì yiè ò í ò nɑ̀kɛ́mɛ̀ tìmɑtì. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Kòo dɔù mɛ nyóu kɛ̀ dɛ̀ wentɛ́ kòò nɛ́ ti pɑ̀ɑ, weè yóó tɔ o pokù kó mɛcɑɑ̀rìmɛ̀ kó tiyeti. ");
INSERT INTO tbzsim_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Ikuɔ́ ti Yiɛ̀ nKuyie nduɔ́ nyìnyi Mɔyiisi dɛ̀ɛ̀ tukúnɛ̀ onitipòkù wèè yenkɛ nɛ̀ osɑpɑ̀ɑ̀ nwèè kpɑɑ́ ɑ̃ o cicɛ cĩ́ɛ̃̀tɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","Dokɛ́nɛ̀ Mɑndiyɑ̃ɑ̃bɛ kɛ́pɛitɛ bɛ̀ dɔ̀ɔ̀ mɛ̀ɛ̀ yɛi nyIsidɑyɛɛribɛ. Kɑ̀ɑ dèè ɑ kũnti ɑ yɛmbɛ̀ borɛ̀ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mɛm̀mɛ kɛ̀ Mɔyiisii nɑ́kɛ́ Isidɑyɛɛribɛ kɛ dɔ̀: Bɛ̀mɑbɛ̀ɛ bɑ́ɑ́tí di miɛkɛ kɛ́kɔtɛ kɛ́do Mɑndiyɑ̃ɑ̃bɛ mudoò kɛ́pɛitɛ ti Yiɛ̀ nKuyie nkó dipɛ̀ì. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Di tɑ̃ɑ̃tɛ́ Isidɑyɛɛribɛ wuɔ mmiɛkɛ bɑ́ kù bɛnìtìbɛ̀ tɛkɔupíítɛ̀ píítɛ̀ (1000) kɛ̀ bɛ̀ɛ kɔtɛ mudoò. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","6","Kɛ̀ bɛ̀ɛ dɛitɛ Isidɑyɛɛribɛ wuɔ mmiɛkɛ bɑ́ kù tɛkɔupíítɛ̀ píítɛ̀ kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛmɔu bɛhɑ̃ɑ̃pɔ̀mbɛ̀ tɛkɔupípíítɛ̀ nɛ̀ sìkɔupísìdɛ́ (12000) kɛ̀ Mɔyiisi duɔ́ nkɛ̀ bɛ̀ɛ kɔtɛ mudoò kòo bɛ̀ nɛínnɛ̀ Edeɑsɑɑ birɛ Pinɑsi ikuɔ́ nìùtì, kòo ntɔ ikuɔ́ nɛntì nɛ̀ sikpɑ̀rìheú. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Kɛ̀ bɛ̀ɛ do Mɑndiyɑ̃ɑ̃bɛ mudoò ti Yiɛ̀ nKuyie ndo tì nɑ̀kɛ́ Mɔyiisi kɛ yɛ̃ ndɛ̀ ndòmmɛ̀, kɛ́kuɔ bɛnitidɑɑbɛ̀ bɛmɔu, ");
INSERT INTO tbzsim_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","kɛ́kuɔnɛ̀ Mɑndiyɑ̃ɑ̃bɛ kó bɛkpɑ̀ɑ̀tìbɛ̀ bɛnùmmù, Efii nɛ̀ Dekɛmmu nɛ̀ Tisuu nɛ̀ Uuri nɛ̀ Debɑɑ kɛ féútɛ́nɛ̀ Beɔɔ birɛ Bɑdɑmmu, ");
INSERT INTO tbzsim_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","kɛ́pĩ́mmú bɛ pobɛ̀ nɛ̀ bɛ bí kɛ́kònnɛ̀, kɛ́pĩ́mmú bɛ wũɔ̃ imɔu kɛ́hɛí bɛ kpɛrɛ dɛmɔu, ");
INSERT INTO tbzsim_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","kɛ́cɔ́u mbɛ ɛkɛ̀ nɛ̀ bɛ ɑ̃ɑ̃pɔ̀nkɑrɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","kɛ́ɛínɛ̀ bɛ kpɛrɛ bɛ̀ yɑ̀ dɛ̀ dɛmɔu nɛ̀ bɛnìtìbɛ̀ nɛ̀ iwũɔ̃, ");
INSERT INTO tbzsim_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","kɛ́ dɛ̀ tɔní dɛmɔu bɛ ɑ̃ɑ̃pɔ̀nkɑrì Mɔyiisi nɛ̀ Edeɑsɑɑ ikuɔ́ nìùtì nɛ̀ Isidɑyɛɛribɛ sɔmbɛ borɛ̀ Mɔɑbu biriku, kukó nSuditɛ̃ɛ̃ borɛ̀ Sedikoo ɛì ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Mɔyiisi nɛ̀ ikuɔ́ nìùtì Edeɑsɑɑ nɛ̀ Isidɑyɛɛribɛ kó bɛkotibɑɑbɛ̀ kɛ̀ bɛ̀ɛ ítɛ́ kɛ́yɛroo bɛ ɑ̃ɑ̃pɔ̀nkɑrì kɛ bo bɛ̀ co. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Kɛ̀ Mɔyiisi miɛkɛɛ pɛikɛ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ iwɛ̃ĩ yɛmbɛ̀ bɛ̀ɛ̀ ni bɛhɑ̃ɑ̃pɔ̀mbɛ̀ tɛkɔupíítɛ̀ píítɛ̀ nɛ̀ tɛkɔ̀ùtɛ̀ kɔ̀ùtɛ̀ bɛ̀ɛ̀ kũntiní mudoò. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Kòo bɛ̀ bekɛ kɛ dɔ̀: Dɛ̀ dòmmɛ kɛ̀ di yóu bɛnitipòbɛ̀ kɛ í bɛ̀ kùɔ? ");
INSERT INTO tbzsim_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Di yɛ̃́mu kɛ dò mbɛɛ̀ nitipòbɛ̀ do tũ̀nnɛ Bɑdɑmmu kó itié nkɛ́nte kɛ̀ Isidɑyɛɛribɛ cɑɑ̀rɛ̀ ti Yiɛ̀ nKuyie mmɛdiɛ̀ mPeɔɔ tɑ̃rì kɛ́nte kɛ̀ kùu bɛ̀ potɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Kuɔnɛ̀ di mmɔ̀nnì initidɑbí imɔu nɛ̀ bɛnitipòbɛ̀ bɛmɔu bɛ̀ɛ̀ yenkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Di yóu isɑpùmbí ìì mu nyi yɛ̃́ onitidɔ̀ù kɛ́puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Díndi bɛ̀ɛ̀ kó dimɑ̀ɑ̀ kùɔ onìtì yoo di kɑ̀ɑ́kɛ́ ocíì, di nciɛ́nnɛ̀ dihɑ̃ɑ̃pɔ̀nkɑrì kɛ dɔ̀ yɛwe yɛ̀yiekɛ̀, kɛ̀ bɛ̀ di dɔɔ̀ mɛwénkùmɛ̀ kó ikuɔ́ diyiè ditɑ̃ɑ̃́nnì nɛ̀ diyiénnì, díndi nɛ̀ di pĩ̀ḿmú bɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Kɛ̀ di múnkɛɛ wénkùnnɛ di yɑ̀ɑ̀tì nɛ̀ di nɛntì tikɔ̃̀ntì kpɛti nɛ̀ tibɔcìtì kpɛti nɛ̀ idɛí kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Mɛm̀mɛ kɛ̀ ikuɔ́ nìùtì Edeɑsɑɑ nɑ́kɛ́ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ iwɛ̃ĩ yɛmbɛ̀ bɛ̀ɛ̀ do kɔ̀tɛ mudoò kɛ dɔ̀: Ntɛnɛ̀ ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́ ìì kuɔ́ Mɔyiisi: ");
INSERT INTO tbzsim_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Mɛsɔɔ nnɛ̀ timɑ́tì pɛ́ítì nɛ̀ disɔɔwũɔ̃̀ nɛ̀ timɑ́tì nɛ̀ mɛbiɛrimɛ nɛ̀ dibiɛrìmínnì, ");
INSERT INTO tbzsim_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","dɛ̀ɛ̀ kó dimɑ̀ɑ̀ í yóó cɔ́útɛ́ di dɛ̀ pũ̀ńnɛ́ muhɑ̃ɑ̃́ nkɛ̀ dɛ̀ɛ wenkɛ. Dɛ̀ɛ̀ yóó cɔ́útɛ́ di dɛ mpɔɔ̀tɛ̀ mɛwénkùmɛ̀ kó mɛniɛ mmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Diyiè yiénnì yiè kɛ̀ di ɔ́ú di yɑ̀ɑ̀tì kɛ́wenkɛ, dɛ mɔ̀nnì di bo nɑ kɛ́kò ndi bɑ̀tɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","Fɔ̃́ nnɛ̀ Edeɑsɑɑ nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ dí kɑɑ mbɛ̀ pĩ̀ḿmúní bɛ̀ɛ̀ nìtìbɛ̀ nɛ̀ ìì wũɔ̃, ");
INSERT INTO tbzsim_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","kɑ̀ɑ dɛ̀ totɛ́ mɛ̀dɛ́mɛ̀, bɛ̀ɛ̀ kɔ̀tɛ mudoò kɛ̀ bɛ̀ nte dikéè dìmɑ́ɑ̀, kɛ̀ bɛtɔbɛ̀ bɛ̀ɛ̀ do kpɑɑ́ kɛ̀ bɛ̀ nte ditɛrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Kɑ̀ɑ dɛitɛ bɛ̀ɛ̀ kɔ̀tɛ mudoò bɛ kpɛri miɛkɛ onìtì òmɑ́ɑ̀ bɛnìtìbɛ̀ sikɔusìnùmmù (500) miɛkɛ kóò cɑ̃̀nnɛ́ n kpɛ́í, kɛ mɛ nyĩ́ inɑ̀ɑ̀kɛ nɛ̀ sɑ̃mmɑrímú nɛ̀ ipe nɛ̀ sibɔɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Kɛ̀ di dɛ̀ duɔ́ nyikuɔ́ nìùtì Edeɑsɑɑ, dɛ̀ tu mí ndi Yiɛ̀ nKuyie n kpɛrɛ ndɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Isidɑyɛɛribɛ sɔmbɛ bɛ̀ɛ̀ do kpɑɑ́ bɛ kó dikéè miɛkɛ, ɑ́ dɛitɛ bɛnìtìbɛ̀ sipísìnùmmù miɛkɛ òmɑ́ɑ̀, kɛ mɛ nyĩ́ inɑ̀ɑ̀kɛ nɛ̀ sɑ̃mmɑrímú nɛ̀ ipe nɛ̀ sibɔɔ́, kɑ̀ɑ dɛ̀ duɔ́ nDefiibɛ bɛ̀ɛ̀ pĩ n cĩ́ɛ̃̀tɛ̀ mutɔ̃mmú. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mɔyiisi nɛ̀ Edeɑsɑɑ ikuɔ́ nìùtì kɛ̀ bɛ̀ɛ dɔɔ̀ ti Yiɛ̀ nKuyie nnɑ̀kɛ́ tì Mɔyiisi. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Bɛ̀ɛ̀ kɔ̀tɛ mudoò bɛ̀ ɛí dɛ̀ɛ̀ kó dimɑ̀ɑ̀ miɛkɛ dɛ̀ɛ̀ kpɑɑ́ kɛ̀ dɛ̀ mbo sikɔupíkɔusìkuɔ̀ nɛ̀ sikɔupípísìyiekɛ̀ nɛ̀ sikɔupísìnùmmù (675000) ipe nɛ̀ sibɔɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Inɑ̀ɑ̀kɛ sikɔupípísìyiekɛ̀ nɛ̀ sikɔupísìdɛ́ (72000). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Sɑ̃mmɑrímú sikɔupípísìkuɔ̀ nɛ̀ tɛkɔupíítɛ̀ (61000). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Isɑpùmbí ìì mu nyí duɔ́nɛ̀ onitidɔ̀ù kɛ̀ ì mbo sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìdɛ́ (32000). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Bɛ̀ duɔ́ ndìì kéè bɛ̀ɛ̀ kɔ̀tɛ mudoò ipe nɛ̀ sibɔɔ́ kɛ̀ dɛ̀ mbo sikɔupíkɔusìtɑ̃ɑ̃ti nɛ̀ sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìyiekɛ̀ nɛ̀ sikɔu sìnùmmù (337500). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Kɛ̀ bɛ̀ɛ dɛitɛ dɛ miɛkɛ sikɔusìkuɔ̀ nɛ̀ sipísìyiekɛ̀ nɛ̀ dɛ̀nùmmù (675) bɛ Yiɛ̀ nKuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Inɑ̀ɑ̀kɛ sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìkuɔ̀ (36000) kɛ̀ bɛ̀ɛ dɛitɛ sipísìyiekɛ̀ nɛ̀ ìdɛ́ì bɛ Yiɛ̀ nKuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Sɑ̃mmɑrímú sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìnùmmù (30500) kɛ̀ bɛ̀ɛ dɛitɛ sipísìkuɔ̀ nɛ̀ dɛ̀mɑ́ɑ̀ bɛ Yiɛ̀ nKuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Bɛnìtìbɛ̀ tɛkɔupípíítɛ̀ nɛ̀ sikɔupísìkuɔ̀ (16000) kɛ̀ bɛ̀ɛ dɛitɛ sipísìtɑ̃ɑ̃ti nɛ̀ bɛ̀dɛ́bɛ̀ bɛ Yiɛ̀ nKuyie nkpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Kɛ̀ Mɔyiisii duɔ́ nyikuɔ́ nìùtì Edeɑsɑɑ dɛ̀ɛ̀ tu ti Yiɛ̀ nKuyie nkpɛrɛ o Yiɛ̀ nKuyie nhò nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","43","Dikéè tɛrì dìì kpɑɑ́ Isidɑyɛɛribɛ kpɛ́í kɛ̀ dì mmɑ̀nnɛ̀ bɛ̀ɛ̀ do kɔ̀tɛ mudoò bɛ kpɛri mɑmɛ̀, ipe nɛ̀ sibɔɔ́ sikɔupíkɔusìtɑ̃ɑ̃ti nɛ̀ sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìyiekɛ̀ nɛ̀ sikɔu sìnùmmù (337500). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","Inɑ̀ɑ̀kɛ sikɔupípísìtɑ̃ɑ̃ti nɛ̀ sikɔupísìkuɔ̀ (36000). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","Sɑ̃mmɑrímú sikɔupísìtɑ̃ɑ̃ti nɛ̀ sikɔusìnùmmù (30500). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","Bɛnìtìbɛ̀ tɛkɔupípíítɛ̀ nɛ̀ sikɔupísìkuɔ̀ (16000). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Kɛ̀ Mɔyiisii dɛitɛ bɛnìtìbɛ̀ sipísìnùmmù miɛkɛ òmɑ́ɑ̀ òmɑ́ɑ̀, iwũɔ̃ mɛmmɛ, kɛ́duɔ́ nDefiibɛ bɛ̀ɛ̀ pĩ Kuyie ncĩ́ɛ̃̀tɛ̀ tɔ̃mmú ti Yiɛ̀ nKuyie ndo ti nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Bɛ̀ɛ̀ do ni mudoò kɛ bɑkɛ́ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ tɛkɔupíítɛ̀ píítɛ̀, tɛkɔ̀ùtɛ̀ kɔ̀ùtɛ̀ kɛ̀ bɛ̀ɛ kɔtɛ kɛ́yɑ̀ Mɔyiisi kóò nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Ti kɑ̀ɑ mbɛhɑ̃ɑ̃pɔ̀mbɛ̀ ti bɑkɛ́ bɛ̀ kɛ sɔ̃́ nhòmɔù í kpɑ bɑ́ òmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Dɛɛ̀ te kɛ̀ ti tɔní ti Yiɛ̀ nKuyie nyɛpɑ̃rɛ̀ kɛ bo mɔɔ ti yɛi ncĩ́ɛ̃́mmɛ̀, mɛsɔɔ nkó tisɑ̃tì ti ɛí tì ti ti ntɔní, yɛtootɔ̃rɛ nɛ̀ sinɛí nɛ̀ mɛfĩmmɛ, nɛ̀ dɛmɑ́mɑ́nnɛ̀ nɛ̀ dɛ̀ɛ̀ ɔ̃ ncɑ́ɑ́tí mɛfĩmmɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mɔyiisi nɛ̀ ikuɔ́ nìùtì Edeɑsɑɑ kɛ̀ bɛ̀ɛ cuɔ́ mɛsɔɔ nkó tisɑ̃tì bɛ̀ tɔní tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Bɛhɑ̃ɑ̃pɔ̀mbɛ̀ bɛ̀ɛ̀ bɑkɛ́ yɛtĩ̀rɛ̀ bɛ̀ do duɔ́ ntìì nɛntì kó kucɛ̃́ɛ̃́kù do bo cìdóò tɛkɔ̀ùtɛ̀ nɛ̀ sipísìyiekɛ̀ (170). ");
INSERT INTO tbzsim_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Kɛ̀ bɛhɑ̃ɑ̃pɔ̀mbɛ̀ sɑ́m̀pɔ́bɛ̀ biɛ tiekɛ bɑ́ wè ò ɛí dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mɔyiisi nɛ̀ Edeɑsɑɑ kɛ̀ bɛ̀ɛ tɑnnɛ́ mɛsɔɔ nkó tinɛntì bɛhɑ̃ɑ̃pɔ̀mbɛ̀ bɛ̀ɛ̀ bɑkɛ́ yɛtĩ̀rɛ̀ tɛkɔupíítɛ̀ píítɛ̀ nɛ̀ tɛkɔ̀ùtɛ̀ kɔ̀ùtɛ̀ bɛ̀ duɔ́ ntì mɛtɑummɛ̀ tou, kɛ̀ dɛ̀ bo yie nkɛ̀ ti Yiɛ̀ nKuyie mbɑ́ɑ́ yɛ̃̀ nyIsidɑyɛɛribɛ kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Dubɛnni nɛ̀ Kɑdi bɛ nɑɑ̀mùnkù kɔbɛ do mɔkɛ iwũɔ̃ nyi kɛ̀ ì sũ mɛdiɛ̀ nkɛ̀ bɛ̀ɛ yɑ̀ Yɑsɛɛ ɛì nɛ̀ Kɑdɑɑdi kpɛri yɛ tenkɛ̀ bo yiénnɛ̀mɛ̀ iwũɔ̃ kó mucɛ̃mmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Mɛm̀mɛ bɛ̀ kɔ̀tɛmɛ̀ kɛ́yɑ̀ Mɔyiisi nɛ̀ Edeɑsɑɑ nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ kɛ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","4","Ti Yiɛ̀ nKuyie nduɔ́ ntínti Isidɑyɛɛribɛ kɛ̀ ti fìètɛ yɛ̀ɛ̀ ɛkɛ̀ yɛ̀ yiénnɛ̀ iwũɔ̃ kó mucɛ̃mmu mmu, tínti ɑ kó bɛtɔ̃mbɛ̀ ti mɛ ntu iwũɔ̃ kó bɛcɛ̃mbɛ mbɛ, dɛ kó yɛhɛkɛ̀ tu: Atɑdoti, Dibonni, Yɑsɛɛ nɛ̀ Nimudɑ, Ɛsibonni nɛ̀ Edeyɑde nɛ̀ Sebɑmmu nɛ̀ Nɛbo nɛ̀ Beonni. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Kɛ̀ bɛ̀ɛ deè kɛ dɔ̀: Mɔyiisi, kɑ̀ɑ bo yie nhɑ ti duɔ́ ndɛ kó kɛtenkɛ̀, di bɑ́ɑ́ ti sée kukó nSuditɛ̃ɛ̃ yɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Kɛ̀ Mɔyiisi bɛ̀ tɛ̃̀ńnɛ́ kɛ dɔ̀: Di tú bɑ? Di tebìí bo nkɔri mudoò kɛ̀ di nɛ́ nkpɑɑ́ diɛnnɑɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Dɛ̀ yĩ́mɛ kɛ̀ di dɔ́ kɛ́yɑ̃́ríkùnnɛ Isidɑyɛɛribɛ kɔ̃̀ntì bɛ̀ bo tɑmɛ̀ dihɛì ti Yiɛ̀ nKuyie mbɛ̀ duɔ́ ndì. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Ti bo dìì mɔ̀nnì Kɑdɛɛsi-Bɑnnɛɑ, kɛ̀ n tɔ̃ ndi cicɛbɛ̀ kɛ̀ bɛ̀ bo pɑɑtɛ́ Kɑnnɑhɑ̃ɑ̃ ɛì kɛ̀ bɛ̀ɛ mɛ ndɔɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","M bɛ̀ tɔ̃ mmɛmmɛ kɛ̀ bɛ̀ɛ kɔtɛ Ɛsikɔɔdi biriku kɛ́yɑ̀ dihɛì kɛ́wɛ̃tɛní kɛ́yɑ̃́ríkùnnɛ Isidɑyɛɛribɛ kɔ̃̀ntì bɛ̀ bo tɑmɛ̀ dihɛì ti Yiɛ̀ nKuyie mbɛ̀ duɔ́ ndì. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛɛ pɛikɛ kɛ̀ kùu pɑrìkɛ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","Bɛnìtìbɛ̀ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ yɛ̀nní Esibiti, kɛ́túótɛ́ bɛ̀ɛ̀ mɔ̀kɛ yɛbie nsipísìdɛ́ kɛ́ndeètìnko òmɔù nɑɑ̀cɛ̀tɛ̀ bɑ́ɑ́ tɑ dihɛì n do yɛ̃ n yóó duɔ́ ndì bɛ yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu, kɛ yɛ̃́ bɛ̀ í yiemmɛ̀ kɛ n tũ̀nnɛ sɛi. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Kɛ̀ dɛ̀ í tú Yefundee Kɑdɛbu Kenɑsi nɑɑ̀mùnkù kou nɛ̀ Nunni birɛ Sosuwee, bɛɛ̀ mɑ́ɑ̀ dì tɑti, kɛ yɛ̃́ bɛɛ̀ yiemmɛ̀ kɛ n tũ̀nnɛ sɛi. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Mɛm̀mɛ ti Yiɛ̀ nKuyie mmiɛkɛ pɛikɛmɛ̀ Isidɑyɛɛribɛ kɛ̀ kùu duɔ́ nkɛ̀ bɛ̀ nhɑ̃́ɑ̃́ ndikpɑ́ɑ̀ miɛkɛ kɛ kémmúnɛ̀ dɛ kó kutɔ̃nkù kɔbɛ bɛ̀ɛ̀ do dɔ̀ɔ̀ kù í dɔ́ dɛ̀ bɛ̀ bo kúmɛ̀ kɛ́deè. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Bɛcɑɑ̀rìbɛ̀ kó kubotí díndi, dɛ̀ yĩ́mɛ kɛ̀ di dɔ́ kɛ́sɔɔtɛ́ di yɛmbɛ̀ tɔ̃mmú kɛ tikii ti Yiɛ̀ nKuyie mmiɛkɛ kó muhɑ̃ɑ̃́ nyIsidɑyɛɛribɛ ĩ́nkɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Kɛ̀ di bùtínnɛ́ di Yiɛ̀ nKuyie nkù bo yóu kɛ̀ di nkpɑɑ́ dikpɑ́ɑ̀ diì mmiɛkɛ kɛ́mɔntɛ, kɛ̀ díì nɛ́ nte kɛ̀ Isidɑyɛɛribɛ bɛmɔuu feti. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Kɛ̀ dɛ kó bɛnìtìbɛ̀ tɔ́ɔ́nkoo Mɔyiisi borɛ̀ kóò nɑ̀kɛ́ kɛ dɔ̀: Ti dɔ́ kɛ́dɔɔ̀ ti wũɔ̃ kó dibɑɑkɛ̀rì ndi kɛ́mɑɑ́ yɛhɛkɛ̀ kɛ̀ ti bí nhɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Ti mɔ́mmɔmbɛ kɛ̀ ti túótɛ́ ti kpɑ̀rìnɛntì kɛ́niitɛ́ fɛnɑfɛ ììkɛ̀, kɛ́kɔtɛ kɛ́tɑnnɛ́ ti tebìí dɛ kó yɛhɛkɛ̀, ti bí sɑ́m̀pɔ́ì ii yó mbo diɛ nyɛhɛkɛ̀ ti yóó mɑɑ́ yɛ̀ kɛ́fii nyiduotí kɛ́nsɔrinɛ̀ dɛ kó kɛtenkɛ̀ kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Kɛ̀ Isidɑyɛɛribɛ bɛmɔu í kɑ̀ri bɑ́ wè o tenkɛ̀ ti í wɛ̃tiní. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Kɛ̀ di ti duɔ́ ndiɛ nti kó kɛtenkɛ̀ ti tɛ̃́nkɛ í yó nwɑnti dí ti duɔ́ nkɛtɛkɛ̀ Suditɛ̃ɛ̃ kó nyɑ́ɑ̀ tɛrì, kɛ yɛ̃́ ti kɔkɛ bomɛ̀ diɛ ndiyɑ́ɑ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kpɛri. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Kɛ̀ Mɔyiisi dɔ̀: Kɛ̀ di pĩ́ ndi bɛ́i ndìì nùù, kɛ̀ di tùótɛ́ di kpɑ̀rìnɛntì kɛ dokɛ́ ti Yiɛ̀ nKuyie nyɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Kɛ̀ di bɑ̀ɑ́tí kɛ sèńtɛ́ Suditɛ̃ɛ̃ di Yiɛ̀ nKuyie nyɛ̃ ndɛ̀ ndòmmɛ̀ kɛ bɑɑnɛ̀ kù bo duɔ́mmɛ̀ kɛ̀ bɛ̀ɛ nɑ bɛ dootitɔbɛ̀ kɛ́ bɛ̀ bɛ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ duɔ́ ndìì mɔ̀nnì bɛ tenkɛ̀, dɛ mɔ̀nnì di bo nɑ kɛ́wɛ̃tɛní di tenkɛ̀, Isidɑyɛɛribɛ bɑ́ɑ́ di sɛi ndi Yiɛ̀ nKuyie mmɛ ntɛ̃́nkɛ bɑ́ɑ́ di sɛi. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Kɛ̀ di mɛ nyí dɔ̀ɔ̀ mɛmmɛ di yetɛ́nɛ̀ ti Yiɛ̀ nKuyie nku, dɛ mɔ̀nnì di nyɛ̃́ kɛ dò ndi yɛi mbo di pĩ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","Mɑɑ́nɛ̀ tũnkɛ́ yɛhɛkɛ̀ kɛ́tɑnnɛ́ di bí sɑ́m̀pɔ́ì, kɛ́dɔɔ̀ di wũɔ̃ kó yɛbɑɑkùyɛ̀, di nɛ́ bɑ́ɑ́ yɛ̃̀ ndi bɛ́i ndìì nùù. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Kɑdi nɑɑ̀mùnkù nɛ̀ Dubɛnni nɑɑ̀mùnkù kɔbɛ kɛ̀ bɛ̀ɛ nɑ́kɛ́ Mɔyiisi kɛ dɔ̀: A kó bɛtɔ̃mbɛ̀ tínti ti yóó dɔ̀ɔ̀mu fɔ̃́ nti yiɛ̀ nhɑ ti nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Ti bí nɛ̀ ti pobɛ̀ nɛ̀ ti pe nɛ̀ ti wũɔ̃ dɛ̀ yó mbo diɛ ndɛ Kɑdɑɑdi ɛkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","A kó bɛtɔ̃mbɛ̀ tínti bɛ̀ɛ̀ bɑ̀ɑ́tí tikpɑ̀rìnɛntì ti kɔrimu kɛ̀ ti Yiɛ̀ nKuyie nyóó ti niitɛ́ kɛ̀ tí bɛ̀ dokɛ́nɛ̀ ɑ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Mɛm̀mɛ kɛ̀ Mɔyiisii nɑ́kɛ́ ikuɔ́ nìùtì Edeɑsɑɑ nɛ̀ Nunni birɛ Sosuwee nɛ̀ Isidɑyɛɛribɛ kó bɛkótíbɛ̀ dɛ kó bɛnìtìbɛ̀ kpɛ́í nkɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","Kɛ̀ Kɑdi nɑɑ̀mùnkù kɔbɛ nɛ̀ Dubɛnni kɔku kɔbɛ bɛ̀ɛ̀ bɑɑti tikpɑ̀rìnɛntì kɛ̀ bɛ̀ di nɛinɛ̀ kɛ́séntɛ́ kukó nkɛ̀ di Yiɛ̀ nKuyie ndi niitɛ́ kɛ̀ di dokɛ́, kɛ̀ di tiekɛ dìì mɔ̀nnì di ɛkɛ̀, dí bɛ̀ duɔ́ nKɑdɑɑdi tenkɛ̀ kɛ̀ bɛ̀ɛ tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Kɛ̀ bɛ̀ mɛ nyí bɑ̀ɑ́tí kɛ di nɛinɛ̀ Kɑnnɑhɑ̃ɑ̃ kó kɛtenkɛ̀ miɛkɛ nkɛ di yóó bɛ̀ duɔ́mmɛ̀ kɛtenkɛ̀ di kɔkɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Kɑdi nɑɑ̀mùnkù kɔbɛ nɛ̀ Dubɛnni nɑɑ̀mùnkù kɔbɛ kɛ̀ bɛ̀ dɔ̀: Ti Yiɛ̀ nKuyie nnɑ̀kɛ́ tì tínti ɑ kó bɛtɔ̃mbɛ̀ ti yóó tì dɔ̀ɔ̀mu. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Ti yóó bɑ́ɑ́tímu ti Yiɛ̀ nKuyie nyɛ̃ ndɛ̀ ndòmmɛ̀ kɛ́kɔtɛ Kɑnnɑhɑ̃ɑ̃, ti nɛ́ dɔ́ tì tu, ɑ tí duɔ́ nti kó kɛtenkɛ̀ Suditɛ̃ɛ̃ kó nyɑ́ɑ̀ dii ndi. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Mɛm̀mɛ kɛ̀ Mɔyiisi duɔ́ nKɑdɑɑdi nɑɑ̀mùnkù kɔbɛ nɛ̀ Dubɛnni nɑɑ̀mùnkù kɔbɛ nɛ̀ Sosɛfu birɛ Mɑnɑnsee botí kɔbɛ dikéè, Amɔriibɛ kpɑ̀ɑ̀tì Sionni kó dikpɑ̀ɑ̀tìyuu nɛ̀ Bɑsɑ̃ɑ̃ kɔbɛ kóo kpɑ̀ɑ̀tì Ɔku kpɛri nɛ̀ yɛhɛkɛ̀ yɛ̀ɛ̀ bo bɛ tenkɛ̀ mɑ̀nku nɛ̀ yɛhɛkɛ̀ yɛ̀ɛ̀ dɛ̀ tɔ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Mɛm̀mɛ kɛ̀ Kɑdi nɑɑ̀mùnkù kɔbɛɛ mɑɑ́ Dibonni nɛ̀ Atɑdoti nɛ̀ Adowɛɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","nɛ̀ Atɑdɔti-Sofɑnni Yɑsɛɛ nɛ̀ Yoboɑ ");
INSERT INTO tbzsim_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","nɛ̀ Bɛti-Nimudɑ nɛ̀ Bɛti-Adɑnnii kɛ yɛ̀ fii nyiduotí, kɛ́mɑɑ́nɛ̀ bɛ wũɔ̃ kó yɛtuo. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Kɛ̀ Dubɛnni nɑɑ̀mùnkù kɔbɛɛ wɛ̃tɛ kɛ́mɑɑ́ Ɛsibonni Edeyɑde nɛ̀ Kidiyɑtɑimmu ");
INSERT INTO tbzsim_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","nɛ̀ Nɛbo nɛ̀ Bɑɑdi-Nɛɔɔ nɛ̀ Sibemɑ kɛ́ yɛ̀ cèètɛ yɛyètɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Mɛm̀mɛ kɛ̀ Mɑnɑsee birɛ Mɑkiidi nɑɑ̀mùnkù kɔbɛɛ do Kɑdɑɑdi ɛì kɛ́bɛti Amɔniibɛ bɛ̀ɛ̀ do dɛ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Kɛ̀ Mɔyiisi bɛ̀ duɔ́ ndɛ kó dihɛì kɛ̀ bɛ̀ɛ kɑri. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Kɛ̀ Mɑnɑsee birɛ tɛrɛ̀ bɛ̀ tu dɛ̀ Yɑii kó kunɑɑ̀mùnkù kɔbɛɛ túótɛ́ Amɔriibɛ ɛkɛ̀ dɛpɑɑ nkpɛyɛ kɛ́ yɛ̀ yu kɛ dɔ̀: Yɑii ɛkɛsí. ");
INSERT INTO tbzsim_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Kɛ̀ Nɔbɑɑ kɔbɛɛ do Kenɑti nɛ̀ yɛhɛkɛ̀ yɛ̀ɛ̀ ò tɔ̀kɛ́nɛ̀ kɛ́ yɛ̀ yu o mɔ́mmuɔ nho kó diyètìrì kɛ dɔ̀ Nɔbɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","Ntɛ Isidɑyɛɛribɛ do yɛtì Esibiti kɛ́dɔ́ɔ́tɛ́mɛ̀ bɛ ɑ̃ɑ̃pɔ̀ntĩ̀rɛ̀ dò ndòmmɛ̀, Mɔyiisi nɛ̀ Anɔɔ kɛ̀ bɛ̀ mbɛ̀ ni kɛ̀ bɛ̀ɛ kétɛ́ kɛ́yɛ̀ yɛ̀ɛ̀ bòrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","Kɛ̀ Ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kòo nwɑ̃ũ bɛ̀ kɑ̀tì dɛ̀ kɛ sɔɔti, ntɛ ò do dɛ̀ wɑ̃̀ũ mɛ̀ɛ̀ botí: ");
INSERT INTO tbzsim_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","Dibenni tɑ̃̀nkù ketiwè do nwe diyiè tɛpíítɛ̀ nɛ̀ dinummurì bɛ̀ bɑɑ́mmɛ̀ diyentɛ́bɑnni, kɛ̀ dɛ̀ɛ wentɛ́ kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ Dɑmmusɛsi ɛì kɛ́nkérí kɛ yɛtì kɛ̀ Esibiti tenkɛ̀ kɔbɛ bɛ̀ wùó nkɛ̀ bɛ̀ kérí. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Dɛ mɔ̀nnì kɛ̀ Esibiti kɔbɛ kũrì bɛcíríbɛ̀, bɛ̀ɛ̀ tu Mpo ti Yiɛ̀ nKuyie ndo potɛ́ bɛ̀ kɛ bo bɛnkɛ Esibiti kɔbɛ kù kpeńnìnɛ̀mɛ̀ bɛ kó yɛbɔkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ Dɑmmusɛsi kɛ́kɔtɛ kɛ́bɑ́tɛ́ Sukɔti, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","kɛ́ítɛ́ Sukɔti kɛ́kɔtɛ kɛ́bɑ́tɛ́ Etɑmmu ɛì tɛdɔntɛ̀ kó dikpɑ́ɑ̀ mɑ̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Bɛ̀ ìtɛ́ Etɑmmu ɛì ndi tɛdɔntɛ̀ kó dikpɑ́ɑ̀ mɑ̀nku kɛ́kɔ́ntɛ́ kɛ́wɛ̃tɛní Pi-Aidɔti, Bɑɑdi-Sefɔ̃ɔ̃ ììkɛ̀, kɛ́bɑ́tɛ́ kɛ́nwetí Mikidɔdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Bɛ̀ ìtɛ́ Mikidɔdi nwe kɛ́séntɛ́ dɑ̀mɛ́ɛ̀rì tipèntì kou, kɛ́tɑ dikpɑ́ɑ̀ tɛdɔntɛ̀ kpɛri, kɛ́mmɔkɛ mucèmmu yɛwe yɛ̀tɑ̃ɑ̃ti Etɑmmu kó dikpɑ́ɑ̀ tɛdɔntɛ̀ kpɛri miɛkɛ, kɛ́kɔtɛ kɛ́bɑ́tɛ́ bɛ̀ tu dɛ̀ Mɑdɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Bɛ̀ ìtɛ́ Mɑɑrɑ nwe kɛ́tuɔkɛ Edimmu sibií do borɛ̀ tɛpíítɛ̀ nɛ̀ sìdɛ́sì nɛ̀ dɛpuonnɛ sipísìyiekɛ̀, kɛ́bɑ́tɛ́ dɛborɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Bɛ̀ ìtɛ́ dɛǹdɛ kɛ́bɑ́tɛ́ tipèntì kóo dɑ̀mɛ́ɛ̀rì pɛɛ́mmɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","kɛ́ítɛ́ tipèntì kóo dɑ̀mɛ́ɛ̀rì pɛɛ́mmɛ̀ kɛ́bɑ́tɛ́ Sinni kpɑ́ɑ̀ miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","kɛ́ítɛ́ Sinni kpɑ́ɑ̀ tɛdɔntɛ̀ kpɛri kɛ́bɑ́tɛ́ Dofikɑɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","kɛ́ítɛ́ Dofikɑɑ kɛ́bɑ́tɛ́ Aduusi, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","kɛ́ítɛ́ Aduusi kɛ́bɑ́tɛ́ Defidimmu kɛ í mpɛ̀tɛ́ dɛborɛ̀ mɛniɛ nkɛ yɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Bɛ̀ ìtɛ́ Defidimmu nwe kɛ́bɑ́tɛ́ Sinɑii kó dikpɑ́ɑ̀ tɛdɔntɛ̀ kpɛri miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Bɛ̀ ìtɛ́ dɛǹdɛ kɛ́bɑ́tɛ́ Kibodoti-Atɑɑfɑ ");
INSERT INTO tbzsim_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","kɛ́ítɛ́ Kibodoti-Atɑɑfɑ kɛ́bɑ́tɛ́ Asedɔti, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","kɛ́ítɛ́ Asedɔti kɛ́bɑ́tɛ́ Ditimɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","kɛ́ítɛ́ Ditimɑ kɛ́bɑ́tɛ́ Dimɔɔ Pɛdɛsi, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","kɛ́ítɛ́ Dimɔɔ Pɛdɛsi kɛ́bɑ́tɛ́ Dibunɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","kɛ́ítɛ́ Dibunɑ kɛ́bɑ́tɛ́ Disɑɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","kɛ́ítɛ́ Disɑɑ kɛ́bɑ́tɛ́ Keedɑtɑ. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Bɛ̀ ìtɛ́ Keedɑtɑ nwe kɛ́bɑ́tɛ́ Sefɛɛdi tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Sefɛɛdi tɑ̃rì ndi bɛ̀ ìtɛ́mɛ̀ kɛ́bɑ́tɛ́ Adɑdɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","kɛ́ítɛ́ Adɑdɑ kɛ́bɑ́tɛ́ Mɑkidɔti, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","kɛ́ítɛ́ Mɑkidɔti kɛ́kɔtɛ kɛ́bɑ́tɛ́ Tɑɑti, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","kɛ́ítɛ́ Tɑɑti kɛ́bɑ́tɛ́ Tedɑɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","kɛ́ítɛ́ Tedɑɑ kɛ́bɑ́tɛ́ Mitikɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","kɛ́ítɛ́ Mitikɑ kɛ́kɔtɛ kɛ́bɑ́tɛ́ Asimɔnɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","kɛ́ítɛ́ dɛndɛ kɛ́kɔtɛ kɛ́bɑ́tɛ́ Mɔsedɔti, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","kɛ́ítɛ́ Mɔsedɔti kɛ́bɑ́tɛ́ Bendee-Yɑkɑnni, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","kɛ́ítɛ́ Bendee-Yɑkɑnni kɛ́bɑ́tɛ́ Ɔdi-Kidikɑɑdi, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","kɛ́ítɛ́ Ɔdi-Kidikɑɑdi kɛ́bɑ́tɛ́ Yotibɑtɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","kɛ́ítɛ́ Yotibɑtɑ kɛ́bɑ́tɛ́ Abudonnɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Bɛ̀ ìtɛ́ dɛǹdɛ kɛ́bɑ́tɛ́ Esiyonni-Kebɛɛ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","kɛ́ítɛ́ Esiyonni-Kebɛɛ kɛ́bɑ́tɛ́ Sinni kpɑ́ɑ̀ tɛdɔntɛ̀ kpɛri bɛ̀ tu dɛ̀ Kɑdɛɛsi. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Bɛ̀ ìtɛ́ Kɑdɛɛsi nwe kɛ́kɔtɛ kɛ́bɑ́tɛ́ Ɔdi tɑ̃rì Edɔmmu tenkɛ̀ mɑ̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","Dɛǹdɛ ti Yiɛ̀ nKuyie nduɔ́mmɛ̀ kɛ̀ ikuɔ́ nìùtì Anɔɔ dekɛ Ɔdi tɑ̃rì ĩ́nkɛ̀, ò dɛ nku, kɛ sɔ̃́ ndɛ̀ mɔ̀kɛ yɛbie nsipísìnɑ̀ɑ̀ nɛ̀ bɛ̀ yɛ̀mɛ̀ Esibiti, dibenni tɑ̃̀nkù nummuwè do nwe diyiè ketirì. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","Dɛndɛ Ɔdi tɑ̃rì ĩ́nkɛ̀ ò kumɛ̀, kɛ nyóó kú kɛ mɔkɛ yɛbie ntɛkɔ̀ùtɛ̀ nɛ̀ sipísìdɛ́ nɛ̀ yɛ̀tɑ̃ɑ̃ti. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Dɛ kó difɔ̃nkúò ndi Kɑnnɑhɑ̃ɑ̃ kɔbɛ kóo kpɑ̀ɑ̀tì Adɑdi Nɛkɛfu ɛì kou kèèmɛ̀ Isidɑyɛɛribɛ kéróomɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Kɛ̀ Isidɑyɛɛribɛ ìtɛ́ Ɔdi tɑ̃rì ĩ́nkɛ̀ kɛ́kɔtɛ kɛ́bɑ́tɛ́ Sɑdimɔnɑ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","kɛ́ítɛ́ Sɑdimɔnɑ kɛ́kɔtɛ kɛ́bɑ́tɛ́ Punɔɔ, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","kɛ́ítɛ́ Punɔɔ kɛ́kɔtɛ kɛ́bɑ́tɛ́ Obɔdi, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","kɛ́ítɛ́ Obɔdi kɛ́bɑ́tɛ́ Iyee-Abɑdimmu, Mɔɑbu tenkɛ̀ mɑ̀nku, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","kɛ́ítɛ́ Iye-Abɑdimmu kɛ́bɑ́tɛ́ Dibonni-Kɑdi, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","kɛ́ítɛ́ Dibonni-Kɑdi kɛ́bɑ́tɛ́ Adimɔnni-Dibɑdɑtɑimmu, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","kɛ́ítɛ́ Adimɔnni-Dibɑdɑtɑimmu kɛ́bɑ́tɛ́ Abɑdimmu tɑ̃rì ĩ́nkɛ̀ kɛ́nwetí Nɛbo ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Bɛ̀ itɛ́ Abɑdimmu tɑ̃rɛ̀ nyɛ kɛ́bɑ́tɛ́ Mɔɑbu tenkɛ̀ kó kubiriku, kukó nSuditɛ̃ɛ̃ tɑkɛ́, kɛ́nwetí Sedikoo. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Bɛ̀ do bɑ̀tɛ́ kɛ́nhɛ́rinɛ̀ kukó nSuditɛ̃ɛ̃ nwe kɛ́túótɛ́ Bɛti-Yesimɔti kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Abɛɛdi-Sitimmu ɛì Mɔɑbu biriku. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Dɛndɛ Mɔɑbu biriku Suditɛ̃ɛ̃ kó ntɑkɛ́ Sedikoo ììkɛ̀ ti Yiɛ̀ nKuyie mbɛ́innɛ̀mɛ̀ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkɛ̀ di sèńtɛ́ Suditɛ̃ɛ̃ kɛ tɑ Kɑnnɑhɑ̃ɑ̃ tenkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","dí bɛti dɛ kó kɛtenkɛ̀ kɔbɛ bɛmɔu, kɛ́mpuɔ̀ mbɛ tenkɑɑnìi yɛtɑ̃́rɛ̀ kpɛsi kɛ́bɔ́kɛ́ timɑ́tì kpɛsi, kɛ́puɔ mbɛ wũɔ̃tɔ̀rɛ̀ kɛ́cɑkɛ bɛ tɔ̀rɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","kɛ́tiekɛ dihɛì kɛ́mbo. N dì ndi duɔ́mmu kɛ̀ di dò nkɛ́ ndi te. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","Di yóó tɑ̃ũ tɛ́tɛ́ nwe kɛ́totí di tenkɛ̀ di nɑɑ̀mùntì dò ndòmmɛ̀, kɛ̀ kùù nɑɑ̀mùnkù sũ ku kó kɛtenkɛ̀ ndɛu, kɛ̀ kùù kɛ̃ńnì ku kɔkɛ nkɛ̃ńnì, kɛ̀ di tɑ̃ũ tɛ́tɛ́ kɛ̀ kùù nɑɑ̀mùnkù do dɛ̀, ku kó kɛtenkɛ̀ kɛ ntú. Di yó ntũ ndi wuɔ ndòmmɛ̀ mmɛ kɛ́totí di tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Kɛ̀ di mɛ nyí bɛ̀ti Kɑnnɑhɑ̃ɑ̃ kɔbɛ bɛmɔu, kɛ̀ di yóu bɛ̀mɑbɛ̀ bɛɛ̀ yó ndo ntipotì kɛ́nkũũ di nuɔ, kɛ́ndò nyinɑɑcɛ̃mpɑ̀ɑ̀ti ìì cùɔ́kɛ́ sikɑ̃ũ kɛ kũũ di píìtì kɛ di ɛ̃́ṹtɛ́ dihɛì di bo dìì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Dɛ mɔ̀nnì n do nɑ mbɛ̀ dɔ̀ɔ̀mɛ̀ kɛ̀ n nɛ́ mɛ̀ dɔ̀ɔ̀ dí mbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkɛ̀ di tùɔ̀kɛ dìì mɔ̀nnì Kɑnnɑhɑ̃ɑ̃ tenkɛ̀ n di duɔ́ nkɛ̀ kɛ̀ di bo tiekɛ, ntɛ di tenkɛ̀ mɑ̀nkɛ yóó dítɛ́ dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Kubɑkù cɑ̃̀nku bíɛ́kɛ̀ di tenkɛ̀ kó kumɑ̀nku yóó dítɛ́ tɛdɔntɛ̀ kó dikpɑ́ɑ̀ Sinni nwe kɛ́mpɛkɛ́nɛ̀ Edɔmmu kó kutempɛ̃. Kɛ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó kumɑ̀nkuu dítɛ́ mukɔ́kúɔ́ nkóo dɑ̀mɛ́ɛ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Kù yóó fitɛ́ kubɑkù cɑ̃̀nku bíɛ́kɛ̀ nkɛ kɛ́kɔ́ntɛ́ kɛ́dekɛ inɑɑ́ nkó ditennì kɛ́yɛ̀nnɛ̀ Sinni, Kɑdɛɛsi-Bɑnnɛɑ kubɑkù cɑ̃̀nku kɛ́tuɔkɛ Asɑɑ-Adɑɑ nɛ̀ Asimɔɔ, ");
INSERT INTO tbzsim_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","kɛ́kɔtɛ kɛ́dítɛ́ Esibiti kó kukó kɛ́ntɔ kɛ́tuɔkɛnɛ̀ dɑ̀mɛ́ɛ̀rì Mɛditedɑndee. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Kɛ̀ diyiè tɑɑ̀ kɛ̀ɛ̀ bíɛ́kɛ̀ kó kumɑ̀nku ntú Mɛditedɑndee kóo dɑ̀mɛ́ɛ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Kɛ̀ kubɑkù yoú bíɛ́kɛ̀ kó kumɑ̀nkuu dítɛ́ Mɛditedɑndee kóo dɑ̀mɛ́ɛ̀rì kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Ɔdi kó ditɑ̃rì, ");
INSERT INTO tbzsim_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","kɛ́ítɛ́ Ɔdi kó ditɑ̃rì kɛ́yɛ̀ Debo-Amɑti kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Sedɑti, ");
INSERT INTO tbzsim_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","kɛ́pɛ̃ɛ̃tɛ́ kɛ́tuɔkɛnɛ̀ Sifunɔɔ, kɛ́pɛ̃ɛ̃tɛ́ kɛ́kɔtɛ Asɑɑ-Anɑnni di kó kutemmɑ̀nku kubɑkù yoú kɔku yó ndɛ kɑ̃́ɑ̃́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kó kumɑ̀nku kunku di kù yɛ̀nnɛ̀ Asɑɑ-Enɑnni kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Sefɑmmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Kɛ̀ kùu ítɛ́ Sefɑmmu kɛ́yɛ̀nnɛ̀ Dibudɑ Ainni diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ ditennì yúnnímɛ̀ Sennɛsɑdɛti kóo dɑ̀mɛ́ɛ̀rì diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Dɛ kó kumɑ̀nku yó mmɛ ndò kɛ́tuɔkɛnɛ̀ Suditɛ̃ɛ̃, kɛ́cɑ́ɑ́tínɛ̀ mukɔ́kúɔ́ nkóo dɑ̀mɛ́ɛ̀rì. Di kó kɛtenkɛ̀ kó kumɑ̀nku yó ndɛ nkɑ̃́ɑ̃́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Mɛm̀mɛ kɛ̀ Mɔyiisi nɑ́kɛ́ Isidɑyɛɛribɛ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì kɛ dɔ̀: Ntɛ ti Yiɛ̀ nKuyie ndi duɔ́ nkɛ̀ɛ̀ tenkɛ̀ díndi iwuɔ nyìwɛi nɛ̀ dikéè kɛ̀ di tɑ̃ɑ̃́ tɛ́tɛ́ kɛ́ kɛ̀ totí. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","15","Kɛ̀ Dubɛnni kó kuwuɔ nkɔbɛ nɛ̀ bɛ cɛ̃́ĩ nɛ̀ Kɑdi kó kuwuɔ nkɔbɛ nɛ̀ bɛ cɛ̃́ĩ kɛ́yíɛ́nɛ̀ Mɑnɑnsee kó kuwuɔ ndikéè, bɛmbɛ cɔutɛ́mu bɛ kó kɛtenkɛ̀ kukó nSuditɛ̃ɛ̃ yɑ́ɑ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ Sedikoo ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","Ntɛ bɛnìtìbɛ̀ bɛ̀ɛ̀ yóó di totí di tenkɛ̀ bɛ yètɛ̀: Edeɑsɑɑ ikuɔ́ nìùtì kɛ́yíɛ́nɛ̀ Nunni birɛ Sosuwee. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","Dí dɛitɛ bɑ́ kùù wuɔ mmiɛkɛ wèè tu okótì kòo di teennɛ̀ kɛtenkɛ̀ kó mutotímù. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Ntɛ dɛ kó bɛnìtìbɛ̀ yètɛ̀: Sudɑɑ kó kuwuɔ Yefundee birɛ Kɑdɛbu, ");
INSERT INTO tbzsim_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Simmɛɔ̃ɔ̃ kó kuwuɔ, Ammiudi birɛ Semmuyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","Bɛnsɑmɛɛ kó kuwuɔ, Kisinɔɔ birɛ Edidɑdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","Dɑnni bí kó kuwuɔ, Yokidi birɛ Bukii. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","Sosɛfu birɛ Mɑnɑnsee kó kuwuɔ, Efodi birɛ Anniyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","Sosɛfu birɛ tɛrɛ̀ Efɑdɑimmu kó kuwuɔ, Sifutɑ̃ɑ̃ birɛ Kemmuyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Sɑbunɔɔ kó kuwuɔ, Pɑdunɑki birɛ Edisɑfɑ̃ɑ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","Isɑkɑɑ kó kuwuɔ Asɑ̃ɑ̃ birɛ Pedɑyɛɛdi, ");
INSERT INTO tbzsim_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","Asɛɛ kó kuwuɔ Sodomii birɛ Aiudi. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","Nɛfutɑdii kó kuwuɔ, Ammiudi birɛ Pedɑyɛɛdi. ");
INSERT INTO tbzsim_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Bɛm̀bɛ ti Yiɛ̀ nKuyie ntɑ̃ɑ̃tɛ́mɛ̀ kɛ̀ bɛ̀ bo totí Kɑnnɑhɑ̃ɑ̃ kó kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi Mɔɑbu kó kubiriku miɛkɛ Suditɛ̃ɛ̃ tɑkɛ́, Sedikoo ììkɛ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ duɔ́ nDefiibɛ kɛtenkɛ̀ bɛ kɔkɛ miɛkɛ nɛ̀ bɛ̀ yóó ncɛ̃mmù dɛ̀ bɛ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Kɛ̀ bɛ̀ mbo dɛ kó yɛhɛkɛ̀ miɛkɛ kɛ cɛ̃mmù bɛ wũɔ̃ yɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Kɛtenkɛ̀ kɛ̀ɛ̀ fitɛ́ dɛ kó yɛhɛkɛ̀ bɛ̀ yó ncɛ̃mmù kɛnkɛ bɛ wũɔ̃, kɛ́túótɛ́ dihɛì kó kuduotí borɛ̀, di kɛ̀ bennɛ́ kɛ̀ kɛ̀ ḿbo mɛ́tìrì sikɔusìnùmmù (500). ");
INSERT INTO tbzsim_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","Kɛ̀ dí túótɛ́ kuduotí borɛ̀ dikpɑ́ɑ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀ kɛ̀ kɛ̀ mbo mɛ́tìrì tɛkɔupíítɛ̀ (1000), kɛ́bennɛ́ kubɑkù yoú bíɛ́kɛ̀ kɛ̀ kɛ̀ mbo mɛ́tìrì tɛkɔupíítɛ̀ (1000), kɛ́bennɛ́ diyiè tɑɑ̀ kɛ̀ɛ̀ bíɛ́kɛ̀ kɛ̀ kɛ̀ mbo mɛ́tìrì tɛkɔupíítɛ̀ (1000), kɛ́bennɛ́ kubɑkù yoú bíɛ́kɛ̀ kɛ̀ kɛ̀ mbo mɛ́tìrì tɛkɔupíítɛ̀ (1000). Kɛ̀ dihɛì nsokɛ́ dɛ cuokɛ̀. Bɛ̀ yó mmɔkɛ kɛ̀ɛ̀ tenkɛ̀ nkɛ bɛ ɛì fitímɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Dí duɔ́ nDefiibɛ yɛhɛkɛ̀ yɛ̀kuɔ̀ disɔ̀rì kpɛyɛ, kɛ̀ dɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò kùɔ onìtì wèe cokɛ́ kɛ́sɔri dɛ kó yɛhɛkɛ̀ miɛkɛ, kɛ́yíɛ́nɛ̀ yɛhɛkɛ̀ tɛyɛ̀ sipísìnɑ̀ɑ̀ nɛ̀ yɛ̀dɛ́ɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Yɛmɔu kɛ̀ yɛ̀ɛ wɛ̃nnɛ́ kɛ́mbo yɛhɛkɛ̀ sipísìnɑ̀ɑ̀ nɛ̀ yɛ̀ni kɛ nɛ́ yíɛ́nɛ̀ kɛtenkɛ̀ bɛ̀ yó ncɛ̃mmù dɛ̀ bɛ wũɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Isidɑyɛɛribɛ wuɔ mmiɛkɛ bɑ́ kù kùu yɑɑtɛ ku ɛkɛ̀ bɛ̀ kù duɔ́ nyɛ̀ miɛkɛ kɛ́duɔ́ nDefiibɛ, kɛ̀ kùù mɔ̀kɛ kɛ̀ yɛ̀ sũ ku kpɛyɛ nsũ, kɛ̀ kùù mɔ̀kɛ kɛ̀ yɛ̀ kɛ̃ńnì ku kpɛyɛ nkɛ̃ńnì. Bɑ́ kùù wuɔ nkùu yɑɑtɛ ku tenkɛ̀ kɛ́duɔ́ nDefiibɛ bɛ̀ kù duɔ́ nkɛ̀ kɛ̀ mɑ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Kɛ̀ Ti Yiɛ̀ nKuyie nnɑ́kɛ́ Mɔyiisi kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú n yɛ̃ nkɛ̀ di sèńtɛ́ dìì mɔ̀nnì kukó nSuditɛ̃ɛ̃ kɛ bo tɑ Kɑnnɑhɑ̃ɑ̃ tenkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","di tɑ̃ɑ̃tɛ́ yɛhɛkɛ̀ yɛ̀ɛ̀ yó ntú di kó disɔ̀rì, kɛ̀ dɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò kùɔ onìtì wèe cokɛ́ kɛ́ dì tɑ kɛ́sɔri. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","Dɛ kó yɛhɛkɛ̀ yó ntú di kó disɔ̀rì ndi kɛ̀ dɛ̀ɛ yie nkɛ̀ dɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò kùɔ onìtì, wèe cokɛ́ kɛ́tɑ kɛ́yentɛ́nɛ̀ wèè dɔ́ kɛ́pɛitɛ. Kɛ̀ dɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò kùɔ onìtì bɛ̀ bɑ́ɑ́ ò kùɔ kɛ mu nyí ò tɔní ditĩ̀nnì ììkɛ̀ kɛ̀ dì ò bekɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Di yóó bɛ̀ duɔ́ nyɛ̀ɛ̀ ɛkɛ̀ miɛkɛ disɔ̀rì kpɛyɛ yó mbo yɛ̀kuɔ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","Di tɑ̃ɑ̃tɛ́ yɛ̀tɑ̃ɑ̃ti Suditɛ̃ɛ̃ kó nyɑ́ɑ̀, yɛ̀tɑ̃ɑ̃ti Kɑnnɑhɑ̃ɑ̃ kó dihɛì. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Dɛ kó yɛhɛkɛ̀ yɛkuɔ̀ yɛnyɛ yó ntú Isidɑyɛɛribɛ kó disɔ̀rì ndi, nɛ̀ bɛpɔ̀ɔ̀bɛ̀ bɛ̀ɛ̀ bo di cuokɛ̀. Kɛ̀ dɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò kùɔ onìtì, dɛ yiɛ̀ mbo nɑ kɛ́cokɛ́ kɛ́sɔri yɛ miɛkɛ dìmɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","Kòò mɔù potɛ́ otɔù nɛ̀ kunɛnkù mɑkù timɑ́tì kɔku, kòò kú, dɛ yiɛ̀ nhonitikɔ̀ùtì nwe, bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","Kòò mɛ nhò bɔ̀tɛ́ ditɑ̃́rì ndi kòò kú dɛ̀ yiɛ̀ nhonitikɔ̀ùtì nwe, bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","Kɛ̀ dɛ̀ mɛ ndò nhò ò potɛ́nɛ̀ kudɔú nku kòò kú, dɛ yiɛ̀ nhonitikɔ̀ùtì nwe, bɛ̀ɛ ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","Wèè dò nkɛ́pɛitɛ kòò ò mɑ̀ɑ́nɛ̀ dɛ̀ wèe ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Kòò mɔù níí nhotɔù koò tèntɛ kòò do yoo ò díi nkóò bɔ̀tɛ́ dɛ̀mɑrɛ̀ kòò ku, ");
INSERT INTO tbzsim_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","yoo kòo miɛkɛ kɛɛ̀ mɛ nhò pɛ́ì kòò ò potɛ́ dinɑcɛkutiri kòò ku, onitikɔ̀ùtì nwe, wèè dò nkɛ́pɛitɛ kòò ò mɑɑ́nɛ̀ dɛ̀ wèe ò kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","Kɛ̀ dɛ̀ mɛ ndò ndɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò tèntɛ òmɔù kòò do kɛ ku, kɛ̀ mɛníìmmɛ̀ í bo bɛ cuokɛ̀, ò mɛ nyí ò dìí nkoò bɔ̀tɛ́ dɛ̀mɑrɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","kòò mɛ ndootɛ́ ditɑ̃́rì ndi kɛ̀ dì ò mɑ̀ɑ́nɛ̀ kòò ku, kɛ do í tú o dootitɔù, kòò do í ò dɔ́nɛ̀ mɛyɛi, ");
INSERT INTO tbzsim_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","kɛ̀ dɛ̀ dò mmɛmmɛ ditĩ̀nnìi tũnnɛ ikuɔ́ ìì tukúnɛ̀ wèè kùɔ nɛ̀ wèè dɔ́ kɛ́pɛitɛ kɛ̀ bɛ̀ɛ bekɛ́nɛ̀ dɛ yiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Kɛ̀ ditĩ̀nnìi dɛɛtɛ́ wèè kùɔ wèè dò nkɛ́pɛitɛ kòò bɑ́ɑ́ ò kùɔ. Ditĩ̀nnìi ò tɛ̃̀ńnɛ́ dihɛì ò do sɔri dì, kòo nkɛ̀ bo kɛ bɑɑnɛ̀ ikuɔ́ nìùtì diɛwè bɛ̀ còú nwe mɛkùɔ̀ nhò bo kúmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Kɛ̀ dɛ̀ mɛ ndò nwèè kùɔ ò yɛ̀nní dihɛì ò do sɔri dì kó mutentɑ̃́ɑ̃́. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","Kɛ̀ wèè dò nkɛ́pɛitɛ kòò ò yɑ̀ kòò í bo dihɛì ò do sɔri dì kó mutentɑ̃́ɑ̃́ nkòò ò kùɔ ò í cɑ̀ɑ̀rɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Kɛ̀ dɛ̀ mɛ nkpɛtɛ́nɛ̀ òmɔù kòò kùɔ onìtì ò dò nkɛ́mbo disɔ̀rì kó dihɛì ndi kɛ bɑɑnɛ̀ ikuɔ́ nìùtì diɛwè bɛ̀ cou nwè mɛkùɔ̀ nhò bo kúmɛ̀ kòò nɛ́ wɛ̃tɛ o ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Di yó ntũ nyiì kuɔ́ nɛ̀ di yɑɑ̀bío bɑ́ kɛ̀ di borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Kɛ̀ dɛ̀ tùɔ̀kɛní kɛ dò mmɛmmɛ wèè kùɔ onìtì bɛ̀ dò nkɛ́ nyóó ò kùɔ kɛ̀ bɛnìtìbɛ̀ pɛ́u bɛɛ̀ yɛ̃́ mùù te, bɛ̀ bɑ́ɑ́ kuɔ òmɔù kòo nìtì òmɑ́ɑ̀ weè tu ò yɛ̃́ mùù te. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Òmɔù bɑ́ɑ́ kuɔ onìtì kɛ́ndò ndi ò kùɔ kɛ̀ dí cɔutɛ́ ticuuti kóò yóu, ò dò nkɛ́kuɔmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Di bɑ́ɑ́ yie nkòò mɔù dí yietí ticuuti kɛ́yɛ̀nní disɔ̀rì kó dihɛì kɛ́konní o ɛì, kɛ̀ ikuɔ́ nìùtì diɛwè mu nyí ku. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Di yóó kɑri dìì ɛì di bɑ́ɑ́ cóú mmɛnitiyĩ̀ĩ̀, mɛnitiyĩ̀ĩ̀ nsĩ̀nkùnko dihɛì ndi, dɛ̀mɑrɛ̀ í bo di bo dɔɔ̀ dɛ̀ kɛ̀ dɛ̀ɛ wénkùnnɛ dihɛì mɛnitiyĩ̀ĩ̀ nsĩ̀nkùnnɛ dì, kɛ̀ dɛ̀ í tú di bo kuɔmɛ̀ wèè kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Di bɑ́ɑ́ sĩnkùnnɛ dihɛì di yóó kɑri dì, n yó mbo dì, mí ndi Yiɛ̀ nKuyie n yó mbomu díndi Isidɑyɛɛribɛ di cuokɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Kɛ̀ Sosɛfu birɛ Mɑnɑnsee birɛ Mɑkiidi kó dɛbirɛ Kɑdɑɑdi nɑɑ̀mùnkù kɔbɛ nɛ̀ Isidɑyɛɛribɛ kó bɛkotibɑɑbɛ̀ nɛ̀ bɛ cɛ̃́ĩ kó bɛkótíbɛ̀ɛ kɔtɛ kɛ́yɑ̀ Mɔyiisi kóò nɑ̀kɛ́ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","Ti Yiɛ̀ nKuyie ndɑ nɑ̀kɛ́mu kɛ tú di tɑ̃ɑ̃́ tɛ́tɛ́ kɛ́totí kɛtenkɛ̀ Isidɑyɛɛribɛ kó iwuɔ kɛ dɑ nɑ̀kɛ́ kɛ tú: Á duɔ́ nti tebitɛ Sedofɑdi kó kɛtenkɛ̀ o sɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Kɛ̀ bɛ̀ mɛ nyenkɛ Isidɑyɛɛribɛ wuɔ mmiɛkɛ kutɛkù mɑkù, ti kéétɛ́ dɛ kó kɛtenkɛ̀ kɛ yíɛ́ bɛ̀ yenkɛ kùù wuɔ nkɔkɛ, dɛ mɔ̀nnì ti kó kɛtenkɛ̀ yóó yɑɑtɛmu. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Kɛ̀ mɛtɛ̃́nnímɛ̀ kó dibenni tùɔ̀kɛ Kuyie nkó dibɑnni diɛrì, bɛ kó kɛtenkɛ̀ɛ nɑɑ́ mbɛ̀ yenkɛ kùù wuɔ nkɔkɛ kɛ tɛ̃́nkɛ bɑ́ ntú bɛ yɛmbɛ̀ kɔkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Mɛm̀mɛ kɛ̀ Mɔyiisii nɑ́kɛ́ Isidɑyɛɛribɛ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì kɛ dɔ̀: Sosɛfu yɑɑ̀bí bɛ́i nkɛ nɑɑtimu. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Ntɛ Ti Yiɛ̀ nKuyie nnɑ̀kɛ́ tì tìì tukúnɛ̀ Sedofɑdi kó bɛsɑpɑ̀mbɛ̀ bɛ̀ɛ̀ yenkɛ bɛ̀ dɔ́ wè, kɛ̀ dɛ yiɛ̀ ncɛ̃́nkɛ tú bɛ kó kuwuɔ nkou. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Kɛ̀ dɛ̀ɛ yie nkɛ̀ Isidɑyɛɛribɛ kó kɛtenkɛ̀ bɑ́ ntɑɑ̀ iwuɔ ntɛì kɔkɛ miɛkɛ, Isidɑyɛɛribɛ bɑ́ kùù wuɔ kɛ̀ kù nkɑri ku yɛmbɛ̀ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Isidɑyɛɛribɛ wuɔ mmiɛkɛ bɛnitipòbɛ̀ bɛ̀ɛ̀ yóó tiekɛ bɛ yɛmbɛ̀ tenkɛ̀ bɛ̀ nyenkú bɛ kó tinɑɑ̀mùntì miɛkɛ nkɛ, kɛ̀ dɛ̀ɛ yie mbɑ́ wèè Isidɑyɛɛri kòo nte o yɛmbɛ̀ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Mɛɛ̀ botí nku bɑ́ kùù nɑɑ̀mùnkù bo ntemɛ̀ ku yɛmbɛ̀ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","11","Mɛm̀mɛ kɛ̀ Tisododi kó bɛsɑpɑ̀mbɛ̀ Mɑdɑ nɛ̀ Tidisɑɑ nɛ̀ Okudɑ nɛ̀ Midikɑ nɛ̀ Nɔɑ kɛ̀ bɛ̀ɛ tũnnɛ ti Yiɛ̀ nKuyie ndo nɑ̀kɛ́ tì Mɔyiisi kɛ́yenkɛ bɛ cicɛ tebìí kó bɛdɑpɑ̀mbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Sosɛfu birɛ Mɑnɑnsee kó ibí nyi bɛ̀ do yenkɛmɛ̀ kɛ̀ bɛ cicɛbɛ̀ tenkɛ̀ nkpɑɑ́ kɛ tú bɛ nɑɑ̀mùnkù kɔkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Isidɑyɛɛribɛ bo dìì mɔ̀nnì Mɔɑbu biriku miɛkɛ kukó nSuditɛ̃ɛ̃ pɛɛ́mmɛ̀ kɛ wetí Sedikoo, dɛndɛ ti Yiɛ̀ nKuyie nduɔ́mmɛ̀ Mɔyiisi i nkuɔ́ nɛ̀ yɛ ntɑnnɛ̀ kòo dɛ̀ mbɛ̀ tùo. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Di m̀pɑ́tíri tɔ tinɑ́ɑǹtì Mɔyiisi do nɑ̀kɛ́ tì nti Isidɑyɛɛribɛ bɛmɔu kɛ sɔ̃́ mbɛ̀ bo kukó nSuditɛ̃ɛ̃ kó diyɑ́ɑ̀ tɛrì dikpɑ́ɑ̀ tɛdɔntɛ̀ Adɑbɑ kɛ wetí Sufu, kɛ̀ Pɑdɑnni kpɑ́ɑ̀ bo ku m̀píkù. Tofɛɛdi nɛ̀ Dɑbɑnni nɛ̀ Asedɔti nɛ̀ Disɑɑbu kɛ̀ yɛ̀ bo kupíkù tɛkù. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","A bo ítɛ́mɛ̀ Odɛbu kɛ́kétɛ́ Seii tɑ̃rɛ̀ ĩ́nkɛ̀ kó kucɛ kɛ́nkɔri Kɑdɛɛsi-Bɑnnɛɑ, dɛ̀ mɔ̀kɛ mucèmmu yɛwe tɛpíítɛ̀ nɛ̀ dìmɑ́ɑ̀ ndi. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Dɛ do sɔ̃́ ndɛ̀ mɔ̀kɛ yɛbie nsipísìnɑ̀ɑ̀ ndi nɛ̀ Isidɑyɛɛribɛ yɛ̀mɛ̀ Esibiti, dibenni tɑ̃̀nkù tɛpíítɛ̀ nɛ̀ òmɑ́ɑ̀ kó diyiè ketirì. Dɛ yiè ndi Mɔyiisi nɑ̀kɛ́mɛ̀ Isidɑyɛɛribɛ ti Yiɛ̀ nKuyie nhò nɑ̀kɛ́ tì timɔu kɛ tú wèe tì mbɛ̀ nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Dɛ̀ do sɔ̃́ mMɔyiisi nɑmu Amɔriibɛ kpɑ̀ɑ̀tì Sionni Ɛsibonni ɛì kou, kɛ nɑ Bɑsɑ̃ɑ̃ kóo kpɑ̀ɑ̀tì Ɔku Etedeii ɛì kou wèè do bo Asitɑdoti. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Bɛ̀ do bo kukó nSuditɛ̃ɛ̃ yɑ́ɑ̀ ndi Mɔɑbu tenkɛ̀, dɛǹdɛ Mɔyiisi bɛ̀ dèntɛmɛ̀ Kuyie nkuɔ́. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Kɛ̀ Mɔyiisii bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Ti do bo dìì mɔ̀nnì ditɑ̃rì Odɛbu ĩ́nkɛ̀ kɛ̀ ti Yiɛ̀ nKuyie nkùù ti te kɛ̀ kùu bɛ́immu kɛ tú: Di bo diɛ nkɛ̀ dɛ̀ mɔ̀ntɛmu, ");
INSERT INTO tbzsim_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ítɛ́nɛ̀ kɛ́kɔtɛ Kɑnnɑhɑ̃ɑ̃ kɔbɛ Amɔriibɛ tɑ̃rɛ̀ nɛ̀ yɛhɛkɛ̀ yɛ̀ɛ̀ dɛ̀ tɔ̀kɛ́, yɛ̀ɛ̀ bo kukó nSuditɛ̃ɛ̃ pɛɛ́mmɛ̀ nɛ̀ tɛdɔntɛ̀ Adɑbɑ yɛtɑ̃rɛ̀ ĩ́nkɛ̀ nɛ̀ Nɛkɛfu nɛ̀ dɑ̀mɛ́ɛ̀rì pɛɛ́mmɛ̀ kó yɛhɛkɛ̀, kɛ́sɔɔtɛ́ kɛ́tuɔkɛ Dimɑɑ tɑ̃rɛ̀ kɛ́pɛ̃ɛ̃tɛ́ kɛ́tuɔkɛ kukó ndiɛkù Efɑdɑti. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","Ntɛnɛ̀ kɛtenkɛ̀ ti Yiɛ̀ nKuyie nkùù di te kù di duɔ́ nkɛ̀. Kɔtɛnɛ̀ kɛ́ kɛ̀ tiekɛ! Kɛ yɛ̃́ kuù do bɛ́immɛ̀ kɛ́pɑrìkɛ̀ kɛ dɔ̀ kù yóó kɛ duɔ́ ndi yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu bɛmbɛ nɛ̀ bɛ yɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Dɛ mɔ̀nnì ndi, n di nɑ̀kɛ́mɛ̀ kɛ̀ n dɔ̀: M bɑ́ɑ́ nɑ kɛ́ ndi ni m mɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Ti Yiɛ̀ nKuyie nkùù di te kù di dɔ̀ɔ̀mu mɛsɑ̀ɑ̀ nkɛ̀ di sũ̀ṹ, ntɛ díndi yíe nkɛ sũ̀ṹ nsiwɑ̃̀ɑ̃ dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","N dɔ́mu ti Yiɛ̀ nKuyie ndi yɛmbɛ̀ do tũ nkùu yóu kɛ̀ di sṹṹ nkɛ́pɛ̃ɛ̃tɛ́ di mɛ̀ mmɑ̀mɛ̀ kucɛ tɛkɔupíítɛ̀ (1000), kɛ̀ kù di dɔɔ̀ mɛsɑ̀ɑ̀ nkɛ́ndònnɛ̀ kù bɛ́imɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","M bo yĩ́mɛ m mɑ́ɑ̀ kɛ́ntũnni di kpɛti nɛ̀ di kó iṹũrii nɛ̀ di kó mutuutimù. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Tɑ̃ɑ̃tɛ́nɛ̀ bɛnìtìbɛ̀ di kó iwuɔ mmiɛkɛ bɛ̀ɛ̀ mɔ̀kɛ mɛyɛ̀mmɛ̀ kɛ ciì kɛ̀ m bɛ̀ duɔ́ ntikótì. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Kɛ̀ di yie nkɛ dɔ̀ m bɛ́i ntì wenni. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Mɛm̀mɛ ǹ tɑ̃ɑ̃tɛ́mɛ̀ di wuɔ mmiɛkɛ bɛ̀ɛ̀ mɔ̀kɛ mɛyɛ̀mmɛ̀ kɛ ciì kɛ́ bɛ̀ bɑɑ́ nyɛtĩ̀rɛ̀ nyɛtĩ̀rɛ̀. Biɛ ntɛkɔupíítɛ̀ (1000) bɛtɔbɛ̀ tɛkɔ̀ùtɛ̀ (100), bɛtɔbɛ̀ sipísìnùmmù, bɛtɔbɛ̀ tɛpíítɛ̀, kɛ nɛ́ yíɛ́nɛ̀ bɛtɔbɛ̀ bɛ̀ɛ̀ ni di wuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Dɛ mɔ̀nnì ndi n nɑ̀kɛ́mɛ̀ bɛ̀ɛ̀ tu bɛnìùbɛ̀ di cuokɛ̀ kɛ̀ n dɔ̀, kɛ̀ bɛ kɔbɛ níí tɔní tinɑ́ɑǹtì bɛ̀ɛ bɛ̀ kèńtɛ́, kɛ̀ bɛ̀ dɔ́ kɛ́ bɛ̀ beé ntìmɑtì bɛ̀ɛ tì tũ̀ntɛ. Kòo nìtì nwe nɛ̀ o kou, yoo onìtì nɛ̀ o kóo pɔ̀ɔ̀ bɛ̀ɛ mɛ ntì tũ̀ntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Bɛ̀ bɑ́ mbekù kɛ bɑɑ̀tì, bɛ̀ kèńtɛ́ mɛ̀ɛ̀ botí osɑ́m̀pɔ́ù bɛ̀ɛ mɛ nkéntɛ́ odiɛwè, bɛ̀ bɑ́ ndé òmɔù bɛ miɛkɛ kɛ yɛ̃́ bɛ̀ bekùmɛ̀ nɛ̀ Kuyie nkó diyètìrì ndi, kɛ̀ tìmɑtì mɛ mpɛ̃ɛ̃tɛ́ bɛ wɛ̃rímú bɛ̀ɛ tì tɔní m borɛ̀ kɛ̀ n tì kèè. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Dɛ mɔ̀nnì kɛ̀ n di nɑ́kɛ́mu di dò nkɛ́ndɔɔrimɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Mɛm̀mɛ kɛ̀ ti ítɛ́ Odɛbu tɑ̃rì kɛ́tɑ fɛkpɑ́fɛ̀ tɛdɔntɛ̀ kɔfɛ di mɛ̀ nkètɛ́ní fɛ̀, kɛ́yɛ̀nnɛ̀nní Amɔriibɛ tɑ̃rɛ̀ ĩ́nkɛ̀ kó kucɛ kɛ́ndònnɛ̀ ti Yiɛ̀ nKuyie nkùù ti te kù do tì nti nnɑ̀kɛ́mɛ̀, kɛ̀ ti tuɔkɛní Kɑdɛɛsi-Bɑnnɛɑ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Kɛ̀ n di nɑ́kɛ́ kɛ̀ n dɔ̀: Ti tùɔ̀kɛ Amɔriibɛ tɑ̃rì ndi ti Yiɛ̀ nKuyie nkùù ti te, kù ti duɔ́ ndì, ");
INSERT INTO tbzsim_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ntɛnɛ̀ kɛtenkɛ̀ ti Yiɛ̀ nKuyie nkùù di te kù di duɔ́ nkɛ̀, kɛ bo di ììkɛ̀. Kɔtɛnɛ̀ kɛ́ kɛ̀ cɔutɛ́ kɛ́tiekɛ ti Yiɛ̀ nKuyie ndi yɛmbɛ̀ do tũ nkù mɛ nyɛ̃. Di bɑ́ nyĩɛ̃̀kù kɛ̀ di kɔ̃m̀bùɔ̀tì nduò. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Kɛ̀ dí kɔtɛní m borɛ̀ kɛ dɔ̀: Tí tɔ̃ mbɛnìtìbɛ̀ kɛ̀ bɛ̀ɛ kɔtɛ kɛ́pɑɑtɛ́ kɛtenkɛ̀ kɛ́wɛ̃tɛní kɛ́ ti nɑ́kɛ́ icɛ ti dò nkɛ́ketɛ́ ì nɛ̀ yɛhɛkɛ̀ ti dò nkɛ́tɑ yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Kɛ̀ m pɛ́nsìrì dɛ kó tinɑ́ɑǹtì kɛ́dɛitɛ di wuɔ mmiɛkɛ onìtì òmɑ́ɑ̀ òmɑ́ɑ̀ kɛ̀ bɛ̀ɛ wɛ̃nnɛ́ bɛnìtìbɛ̀ tɛpíítɛ̀ nɛ̀ bɛ̀dɛ́bɛ̀ kɛ̀ m bɛ tɔ̃. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Kɛ̀ bɛ̀ɛ kétɛ́ kɛ́dekɛ ditɑ̃rì, kɛ́tuɔkɛ Ɛsikɔɔdi biriku kɛ́ kù pɑɑtɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","kɛ́kɔ̃ṹ dɛ kó kɛtenkɛ̀ kó yɛtebɛ kɛ́ntɔní kɛ́ ti bɛnkɛ, kɛ́ ti nɑ́kɛ́ kɛ dɔ̀: Ti Yiɛ̀ nKuyie nkùù di te kù di duɔ́ ndìì ɛì tu disɑ̀ɑ̀rì ndi. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Kɛ̀ di mɛ nyí nyie nkɛ bo kɔtɛ, kɛ́yetɛ ti Yiɛ̀ nKuyie nkùù di te kù di nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","Kɛ̀ dí tuutɛ kɛ́nnɑ́ɑ́ ndi touti miɛkɛ kɛ tú ti Yiɛ̀ nKuyie nyí di dɔ́mu dɛɛ̀ te kɛ̀ kù di dènnɛní Esibiti, kɛ bo di duɔ́ nhAmɔriibɛ kɛ̀ bɛ̀ di kuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","Di kɔ̃̀ntì dɛ nyɑ̃rikɛ kɛ̀ di dɔ̀: Ti kɔbɛ ti nɑ̀kɛ́ tì tiì yɑ̃́ríkùnnɛ ti kɔ̃̀ntì, ti yóó tɑnnɛ́ timɑ́ɑ̀ ɔ̃̀nti miɛkɛ? Bɛ̀ tu dɛ kó bɛnìtìbɛ̀ kpeńnìmu kɛ dɛu, kɛ ti pɛ̃ɛ̃tɛ́. Kɛ̀ tidɑdiɛtì kɛ̀ bo, kɛ̀ bɛ ɛkɛ̀ dɛu iduotí ìì yɛ̀ fitɛ́ kɛ̀ ì dekɛ kɛ́kɑ́ɑ́ ntiwɛtì. Kɛ̀ tidɑdiɛtì Anɑkiibɛ kɛ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Dɛ mɔ̀nnì kɛ̀ n di nɑ́kɛ́ kɛ̀ n dɔ̀: Di kɔ̃̀ntì bɑ́ nhɑu di bɑ́ mbɛ̀ yĩɛ̃̀kù. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Ti Yiɛ̀ nKuyie nkùù di te kù di bonɛ̀mu kɛ yóó bɛ̀ kpɑnnɛ̀ di kpɛ́í, kù kpɑnnɛ̀ mɛ̀ɛ̀ botí Esibiti kɔbɛ kɛ̀ di dɛ̀ yɑ̀ nɛ̀ di nuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","Di yɑ̀mu di mɔ́mmɔmbɛ kuù di tɔmɛ̀ dikpɑ́ɑ̀ tɛdɔntɛ̀ miɛkɛ di cɛ kumɔu onìtì ɔ̃ ntɔmɛ̀ o birɛ, kɛ̀ di mɛ̀ ntùɔ̀kɛnní diɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Nɛ̀ mɛm̀mɛ di mɛ nyí yie nti Yiɛ̀ nKuyie nkùù di te ku kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","Kunku kùù do di ni dikpɑ́ɑ̀ miɛkɛ kɛ di bɛnkú di dò nkɛ́mbɑ́tírí dɛ̀, kɛ níí ndi mí kɛyènkɛ̀ kɛ̀ di wúó nkucɛ kuyie mmɔ̀nnì kɛ níí ndò ndiwɛtirì kɛ di ni. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Kɛ̀ ti Yiɛ̀ nKuyie nkeè di tùùtɛ kɛ nɑ́ɑ́ ntì kɛ̀ ku miɛkɛɛ yɛ̀nní kɛ̀ kùu bɛ́i nkɛ dɔ̀: Mí ndi Yiɛ̀ nKuyie m bɛ́immu, ");
INSERT INTO tbzsim_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","kutɔ̃nkù yɛiku kuu nkɔbɛ kó dimɑ̀ɑ̀, òmɔù bɑ́ɑ́ yɑ̀ kɛtensɑ̀ɑ̀kɛ̀ n do bɛ́i nkɛ dɔ̀ n yóó duɔ́ nkɛ̀ bɛ yɛmbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","Yefundee birɛ Kɑdɛbu weè mɑ́ɑ̀ yóó kɛ̀ yɑ̀, wenwe nɛ̀ o yɑɑ̀bí, bɛm̀bɛ n yóó duɔ́mmɛ̀ kɛtenkɛ̀ ò ce nkɛ pɑɑtɛ́ kɛ̀. Kɛ yɛ̃́ ò yiemmɛ̀ kɛ tũ̀nnɛ n yɛ̃ mmù weti weti. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Díì do te kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛ n yɛ̀nní kɛ̀ kù dɔ̀ bɑ́ mí m mɔ́mmuɔ n yí tɑti dɛ kó kɛtenkɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","kɛ̀ n kóo tɔ̃ntì Sosuwee Nunni birɛ weè yóó kɛ̀ tɑ, kɛ dɔ̀, nh ò yìɛ́ dikɔ̃m̀bùɔ̀, kɛ̀ weè yóó di tɑnnɛ́ díndi Isidɑyɛɛribɛ di tenkɛ̀, kɛ̀ dí kɛ̀ tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Di bí sɑ́m̀pɔ́ì di do yɛ̃ mbɛ̀ yóó túókɛ́ ì, ìì í yɛ̃́ mɛyɛi nnɛ̀ mɛsɑ̀ɑ̀, iì yóó tɑ dɛ kó kɛtenkɛ̀. Iǹyi n yóó kɛ̀ duɔ́mmɛ̀, kɛ̀ ìi kɛ̀ tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Díndi biɛ, wɛ̃tɛnɛ̀ kɛ́wetínnɛ́ dikpɑ́ɑ̀ tɛdɔntɛ̀ tipèntì kóo dɑ̀mɛ́ɛ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Dɛ mɔ̀nnì ndi di nɑ̀kɛ́mɛ̀ kɛ dɔ̀, di cɑ̀kɛ ti Yiɛ̀ nKuyie nku, di yóó bɑ́ɑ́tímu, bɑ́ wè o kpɑ̀rìnɛntì kɛ́kɔtɛ kɛ́ bɛ̀ dokɛ́nɛ̀, di Yiɛ̀ nKuyie nkùù di te kù tì ndi nɑ̀kɛ́ kɛ yɛ̃ mmù. Kɛ̀ dí bɑ́ɑ́tí di kpɑ̀rìnɛntì kɛ bo dekɛ ditɑ̃rì, kɛ̀ di yɛ̀mmɛ̀ dò ndɛ̀ í yóù di bo túótɛ́mɛ̀ kɛtenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Kɛ̀ ti Yiɛ̀ nKuyie nni nnɑ́kɛ́ kɛ dɔ̀: Nɑ́kɛ́ bɛ kɛ̀ bɛ̀ bɑ́ɑ́ kɔtɛ kɛ́do bɛ dootitɔbɛ̀, kɛ yɛ̃́ n yí bɛ̀ bonɛ̀mɛ̀. Bɛ̀ bɑ́ɑ́ bennɛ́ kɛ́kɔtɛ kɛ̀ bɛ dootitɔbɛ̀ɛ bɛ̀ kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Kɛ̀ n tì ndi nɑ́kɛ́ bɑ́ di í nyie nkɛ n kèńtɛ́, kɛ́yetɛ ti Yiɛ̀ nKuyie nkó dinùù, kɛ́kétɛ́ nɛ̀ di mɔ́mmɔmbɛ kó dikɔ̃m̀bùɔ̀ kɛ́ndeètì ditɑ̃rì kɛ bo bɛ̀ dokɛ́nɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Kɛ̀ Amɔriibɛ bɛ̀ɛ̀ mɑɑ́ dɛ kó ditɑ̃rì kɛ̀ bɛ̀ mɛ nyɛ̀nní kɛ́ di munnɛ́ ice kɔ̃mɛ, kɛ́ ndi bɛti Seii tɑ̃rì kɛ kɔùtì kɛ́tuɔkɛnɛ̀ Ɔdimɑɑ ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Di kɛ nkonní kɛ́kuɔ́nnɛ̀ ti Yiɛ̀ nKuyie, kɛ̀ kù í nkèè di dɑbùò bɑ́ kù í ndɑkɛ dɛ kpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Mɛm̀mɛ kɛ̀ dí ḿbo Kɑdɛɛsi kɛ́mɔntɛ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Dɛ kó difɔ̃nkúò ndi ti ìtɛ́mɛ̀ kɛ́kɔ́ntɛ́ kɛ́tũnnɛ dikpɑ́ɑ̀ kó kucɛ kùù yìɛ̀nɛ̀ dɑ̀mɛ́ɛ̀rì tipèntì kou, ti Yiɛ̀ nKuyie nti nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ńdòmmɛ̀. Mɛm̀mɛ kɛ̀ ti nfirì Seii tɑ̃rì kɛ dɔ̀ yɛwe pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Kɛ̀ ti Yiɛ̀ nKuyie nni mbɛ́innɛ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","Di firì di ntɑ̃rì kɛ̀ dɛ̀ mɔ̀ntɛmu, kétɛ́nɛ̀ kubɑkù yoú bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","Nɑ́kɛ́ Isidɑyɛɛribɛ kɛ tú. Bɛ̀ itimu kɛ bo pɛ̃ɛ̃tɛ́ Seii tenkɛ̀ bɛ kɔbɛ Esɑyuu yɑɑ̀bí tenkɛ̀ mɑ̀nku, bɛ̀ yó mbɛ̀ dému bɛ̀ nɛ́ dɔɔ̀ mɛyɔɔ̀mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","Bɛ̀ bɑ́ɑ́ bɛ̀ dokɛ́nɛ̀, n yí yóó bɛ̀ duɔ́ ndɛ̀mɑrɛ̀ bɛ tenkɛ̀ miɛkɛ bɑ́ kɛ̀ dɛ̀ nɛ́ mmɑ̀nnɛ̀ tɛnɑɑ̀cɛ̀tɛ̀ kó mɛpɛ̃kùmɛ̀, kɛ yɛ̃́ n duɔ́mmɛ̀ Esɑyuu nwe Seii tɑ̃rì kó kɛtenkɛ̀ kɛ̀ weè yó nkɛ te. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Bɛ̀ yóó dontɛ́mu Esɑyuu kɔbɛ borɛ̀ tidiitì bɛ̀ yóó di tì nɛ̀ mɛniɛ mbɛ̀ yóó yɑ̃̀ mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Kɛ yɛ̃́ mí mbɛ Yiɛ̀ nKuyie m bɛ̀ dɔ̀ɔ̀mɛ̀ mɛsɑ̀ɑ̀ mbɛ tɔ̃mmú mumɔu miɛkɛ, yɛbie nsipísìnɑ̀ɑ̀ ndi yíe mí mbɛ Yiɛ̀ nKuyie m bɛ̀ bonɛ̀mɛ̀ fɛkpɑ́fɛ̀ fiɛ mmiɛkɛ, dɛ̀mɑrɛ̀ í bɛ̀ dòńtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Mɛm̀mɛ ti ìtɛ́mɛ̀ ti kɔbɛ Esɑyuu yɑɑ̀bí bɛ̀ɛ̀ bo Seii tɑ̃rì bɛ borɛ̀ kɛ́pɛ̃ɛ̃tɛ́ kɛ́pɛɛ́nnɛ̀ kucɛ kùù yíɛ́ Edɑti nɛ̀ Esiyonni-Kebɛɛ tenkɛ̀, kɛ́tũnnɛ dikpɑ́ɑ̀ tɛdɔntɛ̀ Adɑbɑ kó kucɛ kùù yìɛ̀nɛ̀ Mɔɑbu. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Kɛ̀ ti Yiɛ̀ nKuyie nni nnɑ́kɛ́ kɛ dɔ̀: Di bɑ́ɑ́ do Mɔɑbu kɔbɛ mudoò di bɑ́ɑ́ bɛ̀ wɛ̃̀ńtɛ́, n yí yóó di duɔ́ ndɛ̀mɑrɛ̀ bɛ tenkɛ̀ miɛkɛ. Dɔti yɑɑ̀bí nyi n duɔ́mmɛ̀ Adi tenkɛ̀ kɛ̀ bɛ̀ kɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Nɛ̀ dimɔ̀nnì Emiibɛ bɛɛ̀ do dɛ̀ bo, bɛ̀ do tú kuwuɔ ndiɛkù kɔbɛ mbɛ, bɛnitidiɛbɛ̀ kɛ dònnɛ̀ Anɑkiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Bɛ̀ do bɛ̀ kɔɔ́nnɛ̀ Emiibɛ mbɛ nɛ̀ Defɑiibɛ. Kɛ̀ bɛnìtìbɛ̀ yɛ̀mmɛ̀ ndò nhAnɑkiibɛ tu Defɑiibɛ mbɛ, kɛ̀ Mɔɑbu kɔbɛ mbɛ̀ yu kɛ tú Emiibɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Ɔriibɛ bɛɛ̀ do bo Seii nɛ̀ dimɔ̀nnì, kɛ̀ Esɑyuu yɑɑ̀bí bɛ̀ bɛ̀ti kɛ́ bɛ̀ kùɔ bɛmɔu pɑ́íí kɛ́kɑri bɛ tenkɛ̀. Isidɑyɛɛribɛ do mɛ ndɔ̀ɔ̀ kɛtenkɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ duɔ́ nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Dɛ mɔ̀nnì ndi ti Yiɛ̀ nKuyie nti nɑ̀kɛ́mɛ̀ kɛ dɔ̀: Ítɛ́nɛ̀ kɛ́séntɛ́ kukó nSedɛki, kɛ̀ tí kù sèńtɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Ti dɛ nyìtɛ́ Kɑdɛɛsi-Bɑnnɛɑ kɛ́ nyóó tuɔkɛ kukó nSedɛdi kɛ bo séntɛ́, kɛ̀ dɛ̀ ti túótɛ́ yɛbie nsipísìtɑ̃ɑ̃ti nɛ̀ yɛ̀ni. Kɛ̀ ti do iti Kɑdɛɛsi-Bɑnnɛɑ kɛ̀ bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò kɛ̀ bɛ̀ɛ kú bɛmɔu kɛ̀ ti mu nyí tùɔ̀kɛ Sedikoo. Ti Yiɛ̀ nKuyie ndo yɛ̃ ndɛ̀ yó ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Ti Yiɛ̀ nKuyie nkuù do bɛ̀ potɛ́ ku mɔ́mmɔnku kɛ́ bɛ̀ dèè pɑ́íí bɑ́ bɛ̀ kóò mɔù tɛ̃́nkɛ í nkpɑɑ́ bɛ kó dikɑrì. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Bɛ̀ɛ̀ dò nkɛ́nɑ kɛ́kɔtɛ mudoò bɛ̀ ku dìì mɔ̀nnì bɛmɔu kɛ́deè, ");
INSERT INTO tbzsim_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","kɛ̀ ti Yiɛ̀ nní mbɛ́innɛ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","Di mmɔ̀nnì di yóó séntɛ́mu Mɔɑbu tenkɛ̀ kɛ́tɑ Adi kɔkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","Amɔniibɛ tenkɛ̀ di bɑ́ɑ́ bɛ̀ do mudoò di bɑ́ɑ́ bɛ̀ wɛ̃̀ńtɛ́ n yí yóó di duɔ́ ndɛ̀mɑrɛ̀ bɛ tenkɛ̀ miɛkɛ, n kɛ̀ duɔ́ nDɔti yɑɑ̀bí nyi, bɛɛ̀ kɛ̀ te. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Defɑiibɛ ciɛ do nkɛ nɛ̀ dimɔ̀nnì bɛɛ̀ do dɛ̀ bo, kɛ̀ Amɔniibɛ bɛ̀ yu kɛ tú Sɑ̃nsumiibɛ, ");
INSERT INTO tbzsim_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","bɛ̀ do tú kuwuɔ ndiɛkù nku kɛ kpeńnì kɛ dɛu kɛ dònnɛ̀ Anɑkiibɛ, kɛ̀ Amɔniibɛɛ tuɔkɛní kɛ̀ ti Yiɛ̀ nKuyie nduɔ́ nkɛ̀ bɛ̀ɛ bɛ̀ bɛ̀ti kɛ́ bɛ̀ kùɔ pɑ́íí kɛ́kɑri bɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Kù do dɔ̀ɔ̀mɛ̀ Esɑyuu yɑɑ̀bí bɛ̀ɛ̀ do bo Seii, kɛ duɔ́ nkɛ̀ bɛ̀ɛ bɛti Ɔriibɛ kɛ́kɑri bɛ tenkɛ̀, kɛ kpɑɑ́ kɛ̀ dɛ̀ bo nɛ̀ yíenní. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Afiibɛ bɛɛ̀ do bo Kɑsɑɑ ɛì nɛ̀ dɛ kó sihɛkɛsí, kɛ̀ Kɑfutɔɔ ɛì kɔbɛ bɛ̀ do tú bɛ̀ Kɑfutodiibɛ kɛ̀ bɛ̀ɛ kɔtɛní kɛ́ bɛ̀ kùɔ pɑ́íí kɛ́kɑri bɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Dɛ kó difɔ̃nkúò kɛ̀ ti Yiɛ̀ nKuyie nni nnɑ́kɛ́ kɛ dɔ̀: Ítɛ́nɛ̀ kɛ́séntɛ́ kukó nhAdinɔ, n di duɔ́mmu Amɔriibɛ kpɑ̀ɑ̀tì Sionni Ɛsibonni ɛì kou nɛ̀ o tenkɛ̀. Donɛ̀ we mudoò, ");
INSERT INTO tbzsim_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","kɛ́túótɛ́ yíe nnɛ̀ yɛwe yɛ̀ɛ̀ kpɑɑní ibotí imɔu ìì bo kɛtenkɛ̀ ĩ́nkɛ̀ kùmɑkù í yóó di dɑ́ɑ́tí. Bɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo keè di kpɛ́í kufɔ̃wɑɑ́ nkuù yóó bɛ̀ ɑutɛ́ kɛ̀ bɛ̀ nkpeutí. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Mɛm̀mɛ kɛ̀ tí mbo Kedemɔti kó dikpɑ́ɑ̀ tɛdɔntɛ̀ kɛ́dɛitɛ bɛnìtìbɛ̀ kɛ́tɔ̃ nhƐsibonni ɛì kóo kpɑ̀ɑ̀tì Sionni borɛ̀, kɛ̀ bɛ̀ bo ò nɑ̀kɛ́ kɛ dɔ̀: Nɛ̀ diwɛ̀ì ndi ti kéróomɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","Ti dɔ́ kɛ́nɑ ɑ tenkɛ̀ nkɛ kɛ́pɛ̃ɛ̃tɛ́, ti yó mbɔkɛ́ kucɛ mɑ́ɑ̀ ndi ti í yóó dɑutɛ́ kubɑkù yoú yoo kucɑ̃̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Ti yóó dɑ dontɛ́nɛ̀mu tidiitì ti yóó di tì nti kɛ́ dɑ dontɛ́nɛ̀ mɛniɛ nkɛ́yɑ̃̀. Ti yóó nɑ ɑ tenkɛ̀ mɑ́ɑ̀ ndi kɛ́pɛ̃ɛ̃tɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Esɑyuu yɑɑ̀bí ìì bo Seii tenkɛ̀ nɛ̀ Mɔɑbiibɛ bɛ̀ɛ̀ bo Adi ɛì bɛ̀ ti dɔ̀ɔ̀mɛ̀, ti dɔ́ kɛ́séntɛ́ Suditɛ̃ɛ̃ nwe kɛ́kɔtɛ kɛtenkɛ̀ ti Yiɛ̀ nKuyie nkùù ti te kù ti duɔ́ nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Ɛsibonni kóo kpɑ̀ɑ̀tì Sionni mɛ nyí nyie nkɛ bo ti pɑ̃ kucɛ kɛ̀ tí pɛ̃ɛ̃tɛ́ o tenkɛ̀, ti Yiɛ̀ nKuyie nkuù do kpénkùnnɛ o to nɛ̀ o yɛ̀mmɛ̀, kɛ̀ dɛ̀ bo yie nkɛ̀ kùu bɛ̀ ɑ̃nnɛ́ ti nɔu miɛkɛ dɛ̀ mɛ̀ ndòmmɛ̀ yíe. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Mɛm̀mɛ ti Yiɛ̀ nKuyie nni nnɑ̀kɛ́mɛ̀ kɛ dɔ̀: N dɑ duɔ́mmu okpɑ̀ɑ̀tì Sionni nɛ̀ o tenkɛ̀. Do we mudoò kɛ́fietɛ o tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Kòo kpɑ̀ɑ̀tì Sionni ítɛ́nɛ̀ o nìtìbɛ̀ kɛ́ ti do Yɑɑsi ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Kɛ̀ ti Yiɛ̀ nKuyie nhò ɑ̃nnɛ́ ti nɔu miɛkɛ, kɛ̀ ti bɛ̀ potɛ́ wenwe nɛ̀ o nìtìbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","kɛ́fietɛ bɛ ɛkɛ̀ yɛmɔu kɛ́kuɔ bɛnitidɑɑbɛ̀ nɛ̀ bɛnitipòbɛ̀ nɛ̀ ibí, bɑ́ òmɔù í nyentɛ́ bɑ́ òmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Iwũɔ̃ mɑ́ɑ̀ ndi nɛ̀ tinɛntì ti do ɛímɛ̀ dɛ kó dihɛì miɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","kɛ́túótɛ́ Adowɛɛ, dihɛì dìì bo kukó nhAdinɔ kó mɛpɛɛ́mmɛ̀ nɛ̀ dihɛì tɛrì dìì bo Adinɔ biriku miɛkɛ, kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Kɑdɑɑdi tenkɛ̀, dihɛì mɑrì í mbo ti yĩɛ̃kɛ dì. Ti Yiɛ̀ nKuyie nkuù do yɛ̀ nti duɔ́ nyɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Amɔniibɛ tenkɛ̀ mɑ́ɑ̀ ndi ti do í kɑ̀ɑ́kɛ́mɛ̀ nɛ̀ kukó nSɑbɔki kó mɛpɛɛ́mmɛ̀ nɛ̀ yɛtɑ̃rɛ̀ ĩ́nkɛ̀ kó yɛhɛkɛ̀ nɛ̀ yɛbòrɛ̀ tɛyɛ̀ ti Yiɛ̀ nKuyie ndo ti nɑ̀kɛ́ kɛ dɔ̀ ti bɑ́ɑ́ kɑ́ɑ́kɛ́ yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Kɛ̀ tí ítɛ́ dɛ borɛ̀ kɛ́pĩ́ nkucɛ kɛ́nkɔri Bɑsɑ̃ɑ̃. Mɛm̀mɛ Ɔku Bɑsɑ̃ɑ̃ kóo kpɑ̀ɑ̀tì ìtɛ́nímɛ̀ nɛ̀ o ɑ̃ɑ̃pɔ̀mbɛ̀ bɛmɔu kɛ́ ti do mudoò Etedeii ɛì. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Kɛ̀ ti Yiɛ̀ nKuyie nni nnɑ́kɛ́ kɛ dɔ̀: A bɑ́ɑ́ ò yɔ̀tɛ, n we ndɑ duɔ́mmu wenwe nɛ̀ o nìtìbɛ̀ nɛ̀ o ɛì. A yóó ò dɔ̀ɔ̀ ɑ dɔ̀ɔ̀mɛ̀ mmɛ Amɔriibɛ kpɑ̀ɑ̀tì Sionni Ɛsibonni ɛì kou. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Mɛm̀mɛ ti Yiɛ̀ nKuyie nkùù ti te kù ti duɔ́mmɛ̀ Ɔku Bɑsɑ̃ɑ̃ kóo kpɑ̀ɑ̀tì nɛ̀ o nìtìbɛ̀ kɛ ti bɛ̀ potɛ́ kɛ́kuɔ bɑ́ òmɔù í nyentɛ́ bɑ́ òmɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Kɛ̀ ti tiekɛ o ɛkɛ̀ yɛmɔu, dìmɑrì í nkpɑɑ́ kɛ́tú o kpɛri, dɛ kó yɛhɛkɛ̀ do bo yɛmɔu sipísìkuɔ̀ ndi. Adikɔbu kó kutempɛ̃ Bɑsɑ̃ɑ̃ tenkɛ̀ kɛmɔu okpɑ̀ɑ̀tì Ɔku kpɑ̀ɑ̀tìyuu dimɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Dɛ kó yɛhɛkɛ̀ do tú yɛhɛkɛ̀ diɛyɛ̀ nyɛ kɛ̀ iduotí yɛ̀ fitɛ́ kɛ̀ yɛbòrɛ̀ kpetí kɛ pɑ́kɛ́ imɑ́tìdɛí. Kɛ nɛ́ mbúútí yɛhɛkɛ̀ pɛ́u iduotí í fitɛ́ yɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Kɛ̀ tí yɛ̀ pɔ̀ntɛ pɑ́íí kɛ́dɛ́ítɛ́ ti do yĩmɛ̀ Sionni Amɔriibɛ kpɑ̀ɑ̀tì kɛ́kuɔ bɛnitidɑɑbɛ̀ nɛ̀ bɛnitipòbɛ̀ nɛ̀ ibí, ");
INSERT INTO tbzsim_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","kɛ́pĩ́mmú iwũɔ̃ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo yɛhɛkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Mɛm̀mɛ ti fìètɛmɛ̀ Amɔriibɛ kpɑ̀ɑ̀tìbɛ̀ bɛdɛ́ kó yɛhɛkɛ̀ kukó nSuditɛ̃ɛ̃ kó diyɑ́ɑ̀, kɛ́túótɛ́ kutɛkù bɛ̀ yu kù kɛ tú Adinɔ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Ɛdimɔɔ tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidonni ɛì kɔbɛ do yu Ɛdimɔɔ tɑ̃rì kɛ tú Sidiyonni nwe, kɛ̀ Amɔriibɛ di yu kɛ tú Senii. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Kɛ̀ tí fietɛ ditennì kó yɛhɛkɛ̀ yɛmɔu nɛ̀ Kɑdɑɑdi tempɛ̃ nkumɔu kpɛyɛ. Bɑsɑ̃ɑ̃ omɔu kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Sɑdikɑɑ ɛì nɛ̀ Etedeii ɛì, okpɑ̀ɑ̀tì Ɔku kó yɛhɛkɛ̀ nyɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","Ɔku Bɑsɑ̃ɑ̃ kóo kpɑ̀ɑ̀tì weè do yentɛ́ òmɑ́ɑ̀ kɛ kpɑɑ́ fòù Defɑiibɛ botí miɛkɛ, kòo dɔ́ù ntú timɑ́tì kpɛri, kɛ̀ di okùmɛ̀ pɛ̃nkù mɛ́tìrì mɛ̀nɑ̀ɑ̀, kɛ̀ di pɛ̃kùmɛ̀ bo mbo mɛ́tìrì mɛ̀dɛ́mɛ̀, kɛ̀ di mbo Adɑbɑ Amɔniibɛ ɛidiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Mɛm̀mɛ kɛ̀ ti fietɛ dɛ kó kɛtenkɛ̀ kɛmɔu, kɛ́túótɛ́ Adowɛɛ kukó nhAdinɔ pɛɛ́mmɛ̀, kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Kɑdɑɑdi tɑ̃rì nɛ̀ dɛ kó yɛhɛkɛ̀ dikéè, kɛ̀ tí yɛ̀ duɔ́ nDubɛnniibɛ nɛ̀ Kɑdiibɛ, ");
INSERT INTO tbzsim_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","kɛ́túótɛ́ Kɑdɑɑdi tenkɛ̀ kɛ̀ɛ̀ kpɑɑ́ nɛ̀ Bɑsɑ̃ɑ̃ kóo kpɑ̀ɑ̀tì Ɔku kó dikpɑ̀ɑ̀tìyuu dimɔu. Adikɔbu kó kutempɛ̃ nkumɔu kɛ́ dɛ̀ duɔ́ mMɑnɑnsee kó kuwuɔ ndikéè kɔbɛ, bɛ̀ múnkɛ dɛ nyu kɛ tú Defɑiibɛ tenkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Mɑnɑnsee birɛ Yɑii weè do fìètɛ Adikɔbu tempɛ̃ kumɔu, kɛ́kɔtɛ kɛ́dítɛ́ Kesuriibɛ nɛ̀ Mɑkɑtiibɛ bɛ tenkɛ̀ mɑ̀nku, kɛ́yú dɛ kó yɛhɛkɛ̀ Bɑsɑ̃ɑ̃ kpɛyɛ, o mɔ́mmuɔ nho kó diyètìrì kɛ dɔ̀ Yɑii ɛkɛ̀, kɛ̀ bɛ̀ kpɑɑ́ kɛ mɛ nyɛ̀ yu nɛ̀ yíenní. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Kɛ̀ n yɛ̀ duɔ́ nKɑdɑɑdi tenkɛ̀ Mɑkiidi yɑɑ̀bí, Mɑnɑnsee birɛ, ");
INSERT INTO tbzsim_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","kɛ́túótɛ́ Kɑdɑɑdi ɛì kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kukó nhAdinɔ kɛ̀ n dɛ̀ duɔ́ Dubɛnniibɛ nɛ̀ Kɑdiibɛ. Kɛ̀ dɛ kó kukó nni ntú bɛ tenkɛ̀ mɑ̀nku kubɑkù cɑ̃̀nku bíɛ́kɛ̀ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ kukó nSɑbɔki Amɔniibɛ tenkɛ̀ mɑ̀nku. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Kɛ̀ kuù ntú Adɑbɑ nɛ̀ Suditɛ̃ɛ̃ dɛ̀ mɑ̀nkɛ dɛ̀ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Kinnɛdɛti kɛ mmɛ ndò nkɛ́tuɔkɛnɛ̀ Adɑbɑ kóò dɑ̀mɛ́ɛ̀rì kɛ́ntɔ kɛ́tuɔkɛnɛ̀ mukɔ́kúɔ́ nkóo dɑ̀mɛ́ɛ̀rì pɛɛ́mmɛ̀ nɛ̀ Pisikɑɑ tɑ̃rì diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Dɛ mɔ̀nnì ndi m bɛ̀ nɑ̀kɛ́mɛ̀ kɛ̀ n dɔ̀: Ti Yiɛ̀ nKuyie nkùù di te kù di duɔ́mmu dɛ kó kɛtenkɛ̀. Díndi bɛ̀ɛ̀ kó dimɑ̀ɑ̀ tu bɛhɑ̃ɑ̃pɔ̀mbɛ̀ di dò nkɛ́túótɛ́ tikpɑ̀rìnɛntì nti kɛ́niitɛ́ di kɔbɛ Isidɑyɛɛribɛ tɔbɛ̀, kɛ̀ dí séntɛ́ kukó nSuditɛ̃ɛ̃. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Di pobɛ̀ nɛ̀ di bí nɛ̀ di wũɔ̃ dɛɛ̀ yó nkpɑɑ́ yɛhɛkɛ̀ n di duɔ́ nyɛ̀ miɛkɛ, n yɛ̃́mu di wũɔ̃ sũmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","Kɛ̀ díndii kɔtɛ kɛ́teennɛ̀ di kɔbɛ, kɛ́mbɑɑnɛ̀ ti Yiɛ̀ nKuyie nkùù di te bo bɛ̀ duɔ́mmɛ̀ bɛ kó yɛhɛkɛ̀ kukó nSuditɛ̃ɛ̃ yɑ́ɑ̀, diyiè tɑɑ̀ kɛ̀, kɛ́ bɛ̀ kɑ̀nnɛ kɛ́ bɛ̀ om̀pùnnɛ, kù di yĩ́mɛ̀. Dɛ mɔ̀nnì kɛ̀ di nɛ́ wɛ̃tɛní bɑ́ wè o ɛì nh ò duɔ́ ndì. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Dɛ mɔ̀nnì ndi n nɑ̀kɛ́mɛ̀ Sosuwee kɛ̀ n dɔ̀: A yɑ̀mu nɛ̀ ɑ nuɔ nti Yiɛ̀ nKuyie nkùù di te kù dɔ̀ɔ̀mɛ̀ Amɔriibɛ kpɑ̀ɑ̀tìbɛ̀ biɛ mbɛdɛ́, kù yóó mɛ ndɔɔ̀ yɛkpɑ̀ɑ̀tìyɔ yɛmɔu ɑ yóó séntɛ́ kukó nkɛ́tɑ yɛ̀ɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","Di bɑ́ɑ́ bɛ̀ yɔ̀tɛ ti Yiɛ̀ nKuyie nkùù di te kuù yóó kpɑ ndi kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Dɛndɛ n kuɔ́nnɛ̀mɛ̀ ti Yiɛ̀ nKuyie nkɛ́ kù sɑutɛnɛ̀ kɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Áú! N Yiɛ̀ nKuyie nfɔ̃́ɔ̃̀ ketɛ́ ɑ bo bɛnkɛmɛ̀ mí nhɑ kóo tɔ̃ntì ɑ wɛ̃rímú nɛ̀ ɑ kpetì. Kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ duɔ́mɛ̀ òmɔù í bo kɛ dɑ dònnɛ̀ wèè nɑ kɛ dɔ̀ɔ̀ ɑ dɔɔri dɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","N Yiɛ̀ nKuyie, yóu kɛ̀ n séntɛ́ kukó nSuditɛ̃ɛ̃ kɛ́yɑ̀ kɛtensɑ̀ɑ̀kɛ̀ nɛ̀ yɛtɑ̃rɛ̀ sɑ̀ɑ̀yɛ̀, yɛ̀ɛ̀ kɛ̀ bo, nɛ̀ Dimɑɑ kó ditɑ̃sɑ̀ɑ̀rì. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Díì kpɛ́í nkɛ ti Yiɛ̀ nKuyie mmiɛkɛ do m pɛikɛmɛ̀ bɑ́ kù í nkèè n kù kuɔ́nnɛ̀ dìì dɑbònnì, kɛ́ n nɑ́kɛ́ kɛ dɔ̀: Dɛ̀ sɑ̀nnɛ̀mu mɛmmɛ, tɛ̃́nkɛ bɑ́ m bɛ́innɛ̀ dɛ kó tinɑ́ɑǹtì. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","Dekɛ Pisikɑɑ tɑ̃rì yómmɛ̀ kɛ́wéntɛ́ diyiè tɑɑ̀ kɛ̀, nɛ̀ dì yìɛ̀ní kɛ̀, nɛ̀ kubɑkù yoú nɛ̀ kucɑ̃̀nku diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀, kɛ́wéntɛ́ kɛ́ dɛ̀ yɑ̀ nɛ̀ ɑ nuɔ, ɑ nɛ́ í senti kukó nSuditɛ̃ɛ̃ ɑ mɛ̀ nwùó nkù. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","Duɔ́ nyitié nSosuwee, yɑ́ukùnnɛ o kɔ̃̀ntì, yíɛ́ we dikɔ̃m̀bùɔ̀, weè yóó bɛ̀ niitɛ́ kɛ́ bɛ̀ tɑnnɛ́ kɛtenkɛ̀ ɑ mɛ̀ nwùó nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Mɛm̀mɛ kɛ̀ tí mbo Bɛti-Peɔɔ biriku ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Kɛ̀ Mɔyiisii yíɛ́ kɛ́bɛ́i nkɛ dɔ̀: Díndi Isidɑyɛɛribɛ kéntɛ́nɛ̀ ti Yiɛ̀ nKuyie nkuɔ́ nɛ̀ kù di tiè ntì, kɛ́ndɔɔri dɛ̀ yɛ̃mmɛ̀, kɛ̀ dɛ̀ɛ yie nkɛ̀ dí nfòù kɛ́tɑ kɛtenkɛ̀ ti Yiɛ̀ nKuyie ndi yɛmbɛ̀ do tũ nkù di duɔ́ nkɛ̀ kɛ̀ di bo tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","M mɛ̀ ndi duɔ́ nyìì tié ndi bɑ́ɑ́ yɑɑtɛ ìmɑì i miɛkɛ, di mɛ mbɑ́ɑ́ yíɛ́ ìmɑì. Di mpĩ́ nti Yiɛ̀ nKuyie ntɑnnɔ̀ yɛmɔu kɛ́nyíé nyɛ̀ yɛ̃ mmù, n yɛ̀ ndí duɔ́ nkɛ̀ yɛ̀ dòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Di yɑ̀mu nɛ̀ di nuɔ nti Yiɛ̀ nKuyie ndɔ̀ɔ̀ dɛ̀ Bɑɑdi-Peɔɔ. Bɛ̀ɛ̀ kó dimɑ̀ɑ̀ do tũ̀nnɛ dibɔɔ̀ Bɑɑdi, di Yiɛ̀ nKuyie nkùù di te, kù do bɛ̀ kùɔmu bɛmɔu pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Díndi bɛ̀ɛ̀ do dɔɔri ti Yiɛ̀ nKuyie nkùù di te kù dɔ́ dɛ̀, díì mɛ̀ nkpɑɑ́ fòù yíe. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","N Yiɛ̀ nKuyie nni nnɑ̀kɛ́mu ku kuɔ́ nɛ̀ ku tɑnnɔ̀ kɛ̀ ǹ dɛ̀ ndi tùo, kɛ̀ dɛ̀ bo yie nkɛ̀ di tɑ dìì mɔ̀nnì kɛtenkɛ̀ ti Yiɛ̀ nKuyie ndi duɔ́ nkɛ̀, di ndɔɔri dɛ̀ yɛ̃mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Mpĩ́nnɛ̀ Kuyie nkuɔ́ nɛ̀ ku tɑnnɔ̀ kɛ dɔɔri dɛ̀ yɛ̃mmɛ̀. Mɛm̀mɛ di bo ntúmɛ̀ bɛ̀ɛ̀ mɔ̀kɛ mɛyɛ̀mmɛ̀ kɛ ciì ibotí tɛì ììkɛ̀. Kɛ̀ bɛ̀ɛ keè di nɑ́ɑ́mmɛ̀ Kuyie nkuɔ́ nɛ̀ ku tɑnnɔ̀ kɛ́yĩ́: Kuwuɔ ndiɛkù kɔbɛ biɛ̀ ntu bɛ̀ɛ̀ mɔ̀kɛ bɛ̀mbɛ mɛyɛ̀mmɛ̀ kɛ ciì. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Kuwuɔ ndiɛkù ɔ̃̀nku bo kɛ̀ Kuyie mbɛ̀ tɔ̀kɛ́nɛ̀, ti Yiɛ̀ nKuyie nti tɔ́kɛ́nɛ̀ mɛ̀ɛ̀ botì? Bɑ́ kɛ̀ ti kù kuɔ́nnɛ̀ dìì mɔ̀nnì kù ɔ̃ɔ̃ keèmu. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Yɑ́ɑ̀ kuwuɔ ndiɛkù ɔ̃̀nku bo kɛ mɔkɛ ikuɔ́ nɛ̀ yɛtɑnnɔ̀ dɛ̀ɛ̀ tu timɔ́mmɔnti kɛ dònnɛ̀ m mɛ̀ ndi duɔ́ nyìì kuɔ́ nɛ̀ yɛ̀ɛ̀ tɑnnɔ̀ yíe? ");
INSERT INTO tbzsim_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","Dɛ mɔ̀nnì ndi ti Yiɛ̀ nKuyie nni nnɑ̀kɛ́mɛ̀ kɛ dɔ̀: Di nɛ́ dò nkɛ́dɔɔ̀ mɛyɔɔ̀mmɛ̀ mmɛ kɛ́nyɛ̃́ dimɑ́ɑ̀ kpɛ́í, di bɑ́ɑ́ yɛ̃̀ n di nuɔ nyɑ̀ dɛ̀ kpɛ́í, di bɑ́ɑ́ yóu kɛ̀ dɛ̀ɛ yɛ̀ di yɛ̀mmɛ̀ miɛkɛ nɛ̀ di bo mbomɛ̀. Dí dɛ̀ nɑ̀kɛ́ di bí nɛ̀ di yɑɑ̀bío. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","Dentɛnní di do cómmú dìì mɔ̀nnì ditɑ̃rì Odɛbu di Yiɛ̀ nKuyie nkùù di te ku ììkɛ̀, kù do n nɑ̀kɛ́mu kɛ dɔ̀: Tíí n nìtìbɛ̀ n dɔ́ kɛ́ bɛ̀ bɛ́innɛ̀mu kɛ̀ dɛ̀ɛ yie nkɛ̀ bɛ̀ nni ndé sɑ̃́ɑ̃̀ nɛ̀ bɛ̀ bo mbomɛ̀, kɛ́tuo n kuɔ́ bɛ bí. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Kɛ̀ n di nɑ́kɛ́ kɛ̀ di tíínní kɛ́ncómmú ditɑ̃rì pɛ̃ri kɛ̀ dì cɔ̀ú mmuhɑ̃ɑ̃́ nkɛ̀ mù dèkù kɛĩ́nkɛ̀. Kɛ̀ dibiìnnì nɛ̀ yɛwɛtisùɔ̀ kɛ dɛ̀ dɑ̀ɑ́tí. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Kɛ̀ ti Yiɛ̀ nKuyie nni ndi nɑ́ɑ́nnɛ̀ kɛ̀ ku tɑmmɛ̀ yìɛ̀ní muhɑ̃ɑ̃́ mmiɛkɛ kɛ̀ di nyo ku tɑmmɛ̀ mɑ́ɑ̀ bɑ́ di í yɑ̀ ku ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","Kɛ̀ kù di bɛnkɛ ku tɑummɛ̀ kɛ́wɑ̃ri ku tɑnnɔ̀ tɛpíítɛ̀ titɑ̃́píɛ̀tì tìdɛ́ ĩ́nkɛ̀, kɛ yɛ̃ ndí nyɛ̀ tũ̀ nkɛ dɔɔri yɛ̀ yɛ̃ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Dɛ mɔ̀nnì ndi ti Yiɛ̀ nKuyie nni nnɑ̀kɛ́mɛ̀ kɛ dɔ̀: N dí tié nku kuɔ́ nɛ̀ ku tɑnnɔ̀ kɛ̀ di ndɛ̀ tũ̀ nkɛ dɔɔri dɛ̀ yɛ̃mmɛ̀ kɛtenkɛ̀ kù dì duɔ́ nkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Di bɑ́ɑ́ yɛ̃̀ nti Yiɛ̀ nKuyie ndo di nɑ́ɑ́nnɛ̀ dìì yiè ditɑ̃rì Odɛbu kɛ̀ di yo ku tɑmmɛ̀ muhɑ̃ɑ̃́ mmiɛkɛ, di do í yɑ̀ ku ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","Ndɑkɛnɛ̀ mɛsɑ̀ɑ̀! Di bɑ́ɑ́ yie nkɛ́dɔɔ̀ sitenkɑɑnìi kɛ́ sì dònnɛnɛ̀ bɛnitidɑɑbɛ̀ yoo bɛnitipòbɛ̀ kɛ̀ dɔ̀: Kuyie mɛ ndò. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","Yoo dí sì dònnɛ̀nɛ̀ fɛɔ̃̀fɛ̀ mɑfɛ̀, yoo kuwɑnwɑnkù mɑkù, yoo tɛnɔ̀tɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","yoo dɛbɑmbɑɑ̀nnɛ̀ mɑrɛ̀, yoo siyĩĩ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Di bɑ́ɑ́ bɔ́útɛ́ kɛĩ́nkɛ̀ kɛ́yɑ̀ diyiè nɛ̀ otɑ̃̀nkù yoo siwɑ̃̀ɑ̃, dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo kɛĩ́nkɛ̀, kɛ̀ dɛ̀ɛ yṹɔ̃́ ndi yɛ̀mmɛ̀, kɛ̀ dí nínkú kɛ́ dɛ̀ bɑ̀ńtɛ̀. Ti Yiɛ̀ nKuyie ndɛ̀ yóunɛ̀ ibotí tɛì nyi. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Díndi biɛ ti Yiɛ̀ nKuyie ndi dènnɛní Esibiti muhɑ̃ɑ̃́ mmiɛkɛ kɛ̀ di bo ntú ku kɔbɛ mbɛ di mɛ̀ ndòmmɛ̀ yíe. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Díì te kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛ m pɛikɛ kɛ̀ kù bɛ́i nkɛ tú nyí senti kukó nSuditɛ̃ɛ̃, m mɛ n yí tɑti kɛtensɑ̀ɑ̀kɛ̀ kù di duɔ́ nkɛ̀ kɛ̀ di bo kɛ̀ tiekɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","N yóó kú di nhɛì miɛkɛ nkɛ n yí senti kukó nSuditɛ̃ɛ̃, kɛ̀ díndi yóó kù sèńtɛ́ kɛ́tiekɛ kɛtensɑ̀ɑ̀kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","Dɔɔ̀nɛ̀ mɛyɔɔ̀mmɛ̀ kɛ bɑ́ɑ́ yɛ̃̀ nti Yiɛ̀ nKuyie ndi dɔ̀ɔ̀nɛ̀ mɛ̀ɛ̀ tɑummɛ̀. Di bɑ́ɑ́ dɔɔ̀ tɛtenkɑɑnìtɛ̀ yoo dɛ̀mɑrɛ̀, ti Yiɛ̀ nKuyie ndɛ̀ yetɛ́mu. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Ti Yiɛ̀ nKuyie ntú muhɑ̃ɑ̃́ mmu kɛ tuɔ̀, kù dɔ́ kuù mɑ́ɑ̀ ndi te. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Kɛ̀ di kɑ̀ri dìì mɔ̀nnì kɛtenkɛ̀ ti Yiɛ̀ nKuyie ndi duɔ́ nkɛ̀ kɛ mɔ̀ntɛ kɛ piɛ́ ibí, nɛ̀ di yɑɑ̀bío kɛ̀ di do mɛyɛi mmiɛkɛ, kɛ dɔ̀ɔ̀ sitenkɑɑnìi kɛ sì donnɛ̀nɛ̀ dɛ̀mɑrɛ̀, kɛ̀ dɛ̀ dò ndi yetɛ kɛ dɔ̀ɔ̀ di Yiɛ̀ nKuyie nyí dɔ́ dɛ̀ kɛ̀ dɛ̀ kù yonkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ dɛ̀ wùómmu ntì ndi nɑ̀kɛ́mɛ̀ yíe, kɛ̀ di mɛ̀ dɔ̀ɔ̀, di yóó kúmu mɛcɑ̃ɑ̃. Di bɑ́ nfòù kɛ́mɔntɛ kɛtenkɛ̀ di senti Suditɛ̃ɛ̃ kɛ bo tɑ kɛ̀. Ti Yiɛ̀ nKuyie mbo di kuɔ pɑ́íí! ");
INSERT INTO tbzsim_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Di bo nkpɑɑ́ sɑ́m̀pɔ́ kɛ̀ ti Yiɛ̀ nKuyie ndi cíɛ nkɛ̀ dí tɑɑ́ ibotí tɛì miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Dɛ mɔ̀nnì kɛ̀ dí nínkú kɛ́bɑ́ntɛ̀ sitenkɑɑnìi bɛnìtìbɛ̀ cìɛ́kɛ́ sì idɛí nɛ̀ yɛtɑ̃́rɛ̀ bɑ́ sì í wúó sì í mɔkɛ yɛto kɛ ɔ̃ɔ̃ keè, sì mɛ nhɔ̃ɔ̃ í ndi, sì ɔ̃ɔ̃ í nkèè kunɔ́ú. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Di yó nkɛ mbo kɛ́wɑmmú ti Yiɛ̀ nKuyie, kɛ́ kù yɑ̀ kɛ̀ nsɑ̀ kɛ̀ di kù wɑmmú nɛ̀ di yɛ̀mmɛ̀ mɛmɔu nɛ̀ di wɛ̃rímú mumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","N di nɑ̀kɛ́ tìì kó dimɑ̀ɑ̀ bo di tuɔkɛní dìì mɔ̀nni, kɛ̀ dí tɑ mɛyɛǹcɑɑ̀rìmɛ̀ miɛkɛ dɛ mɔ̀nnì di bo wɛ̃tɛ kɛ́tũnnɛ di Yiɛ̀ nKuyie nkɛ́yie nkù yɛ̃ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Kɛ yɛ̃́ ti Yiɛ̀ nKuyie ndi kuɔ̀mmɛ̀ mɛsémmɛ̀ kɛ di dɔ́, kù í yóó di bɔntóo, kù í yóó di kuɔ kɛ di deè, kù í yóó yɛ̃̀ mmɛtɑummɛ̀ kù dɔ̀ɔ̀nɛ̀mɛ̀ di yɛmbɛ̀ kɛ ĩkú mɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","Bekɛnɛ̀ kɛ̀ bɛ̀ di nɑ́kɛ́! Nɛ̀ ti Yiɛ̀ nKuyie ndɔ̀ɔ̀mɛ̀ onìtì kɛtenkɛ̀ ĩ́nkɛ̀, kɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ dɛ̀ mɛ̀ nduɔ́mɛ̀ dɛ̀mɑrɛ̀ dɔ̀ɔ̀ diyiè mɑrì kɛ mɑ̀nnɛ̀ diɛnnɑ̀ɑ̀? Òmɔù mu nkèè tii m̀botí diyiè mɑrɑ̀ɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Kuwuɔ mmɑkù kɔbɛ bo nkeè Kuyie ntɑmmɛ̀ muhɑ̃ɑ̃́ mmiɛkɛ di mɛ̀ mmɛ̀ kèè mɛ̀ɛ̀ botí kɛ kpɑɑ́ kɛ fòùɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Di mu nyɑ̀ dibɔɔ̀ mɑrì dɔ̀ɔ̀mɛ̀ tidiɛtì nɛ̀ mɛbɛnkùmɛ̀ kɛ ɑ̃nnɛ́ kukɔ̃m̀bɔ̀doróo kɛ dènnɛ kubotí mɑkù kutɛkù miɛkɛ, ti Yiɛ̀ nKuyie nkùù di te kù mɛ̀ ndɔ̀ɔ̀mɛ̀ Esibiti kɛ mɑ̀ mɛdiɛ̀ nkɛ di dènnɛníɑ̀? ");
INSERT INTO tbzsim_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Dímbɛ kù bɛnkɛmɛ̀ dɛndɛ kó dimɑ̀ɑ̀, kɛ̀ dɛ̀ bo yie nkɛ̀ di bɑntɛ́ kɛ dò nti Yiɛ̀ nKuyie nkuù mɑ́ɑ̀ tu Kuyie nkɛ̀ kutɛkù mɑkù í bo. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","Kɛĩ́nkɛ̀ nkɛ kù di bɛ́innɛ̀nnímɛ̀ kɛ bo di tié. Nkɛ di bɛnkɛ muhɑ̃ɑ̃́ ndiɛmù kɛtenkɛ̀ kɛ̀ di keè ku tɑmmɛ̀ mu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","Kù do dɔ́ mɛ̀ɛ̀ kpɛ́í ndi yɛmbɛ̀ dɛɛ̀ do te kɛ̀ kù di tɑ̃ɑ̃tɛ́ díndi bɛ yɑɑ̀bí, kɛ di dènnɛní Esibiti nɛ̀ ku kó muwɛ̃rímú, ");
INSERT INTO tbzsim_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","kɛ bɛ̀ti iwuɔ ndiɛyì di ììkɛ̀ ìì dɛu kɛ di pɛ̃ɛ̃tɛ́, kɛ kpeńnì kɛ di pɛ̃ɛ̃tɛ́ kɛ bo di kɑnnɛ bɛ ɛì kɛ̀ dí dì tiekɛ, dɛ̀ mɛ̀ ndòmmɛ̀ yíe. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Yĩ́ɛ̃́tɛ́nɛ̀ ti yíe, ɑ̃nnɛ́nɛ̀ ti di yɛ̀mmɛ̀ miɛkɛ, ti Yiɛ̀ nKuyie nkuù tu Kuyie nkɛĩ́nkɛ̀ nɛ̀ kɛtenkɛ̀ duɔ́mɛ̀, ku kó difɔ̃nkúò kutɛkù mɑkù í bo. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","Mpĩ́nnɛ̀ ku kuɔ́ nɛ̀ ku tɑnnɔ̀ n di duɔ́ ndɛ̀ yíe nkɛ̀ dɛ̀ɛ yie nkɛ̀ di mbo kɛ̀ dɛ̀ di nɑɑti díndi nɛ̀ di bí, kɛ̀ di fòmmuu mɔntɛ kɛtenkɛ̀ ti Yiɛ̀ nKuyie ndi duɔ́ nkɛ̀ kɛ̀ dì bo nkɛ̀ te sɑ̃́ɑ̃̀ kɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Mɛm̀mɛ kɛ̀ Mɔyiisii tɑ̃ɑ̃tɛ́ yɛhɛkɛ̀ yɛ̀tɑ̃ɑ̃ti kukó nSuditɛ̃ɛ̃ kó diyɑ́ɑ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","Kɛ̀ dɛ kó yɛhɛkɛ̀ bo ntú disɔ̀rì kpɛyɛ. Kɛ̀ dɛ̀ dò ndɛ̀ kpɛtɛ́nɛ̀ òmɔù kòò kùɔ otɔù, bɛ̀ mɛ ndo í mɔkɛ tìmɑtì, dɛ yiɛ̀ ncokɛ́ kɛ́tɑ dɛ kó yɛhɛkɛ̀ kó dìmɑrì miɛkɛ kɛ́dɛɛtɛ́ o fòmmu. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Kɛ̀ Dubɛnniibɛ nte Besɛɛ ɛì dìì bo dikpɑ́ɑ̀ ditennì ĩ́nkɛ̀, kɛ̀ Kɑdiibɛ nte Dɑmɔti Kɑdɑɑdi tempɛ̃ nkɛ̀ Mɑnɑnsee te Kodɑnni Bɑsɑ̃ɑ̃ tempɛ̃. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","Ntɛ Mɔyiisi do duɔ́ nyìì kuɔ́ Isidɑyɛɛribɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","Ò do bɛ̀ nɑ̀kɛ́mu ti Yiɛ̀ nKuyie nkuɔ́ nɛ̀ ku tɑnnɔ̀ nɛ̀ ku tié, ò do tì mbɛ̀ nɑ̀kɛ́ bɛ̀ yɛ̀nní dìì mɔ̀nni ndi Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Dɛ̀ do sɔ̃́ mbɛ̀ bo kukó nSuditɛ̃ɛ̃ kó diyɑ́ɑ̀ ndi Bɛti-Peɔɔ biriku ììkɛ̀ Amɔriibɛ kpɑ̀ɑ̀tì Sionni tenkɛ̀. Sionni do bo Ɛsibonni nwe Mɔyiisi nɛ̀ Isidɑyɛɛribɛ kɛ̀ bɛ̀ɛ ò pɔ̀ntɛ bɛ̀ yɛ̀nní dìì mɔ̀nnì Esibiti, ");
INSERT INTO tbzsim_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","kɛ́tiekɛ o tenkɛ̀ kɛ múnkɛɛ fietɛnɛ̀ Ɔku Bɑsɑ̃ɑ̃ kóo kpɑ̀ɑ̀tì kɔkɛ, Amɔriibɛ kpɑ̀ɑ̀tìbɛ̀ bɛdɛ́ bɛ̀ɛ̀ do bo kukó nSuditɛ̃ɛ̃ diyɑ́ɑ̀ diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Kɛ̀ bɛ tenkɛ̀ tùótɛ́ Adowɛɛ ɛì kukó nhAdinɔ pɛɛ́mmɛ̀ kɛ́ntɔ kɛ́tuɔkɛnɛ̀ Siyonni tɑ̃rì bɛ̀ tu dì Ɛdimɔɔ, ");
INSERT INTO tbzsim_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","Kɛ̀ kùu kɔtɛ kɛ́dítɛ́ tɛdɔntɛ̀ Adɑbɑ kó dikpɑ́ɑ̀ kɛ́ntɔ kɛ́séntɛ́ kukó nSuditɛ̃ɛ̃, diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀, kɛ́ntɔ kɛ́tuɔkɛnɛ̀ dɑ̀mɛ́ɛ̀rì mukɔ́kúɔ́ nkou nɛ̀ Pisikɑɑ tɑ̃rì pɛ̃ri. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Kɛ̀ Mɔyiisii tíí nyIsidɑyɛɛribɛ bɛmɔu kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Díndi Isidɑyɛɛribɛ kéntɛ́nɛ̀ Kuyie kuɔ́ nɛ̀ ku tié n di nɑ́ɑ́ ndɛ̀ yíe nkɛ́ dɛ̀ ɑ̃nnɛ́ di yɛ̀mmɛ̀ miɛkɛ kɛ́ndɔɔri dɛ̀ yɛ̃ mmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Ti Yiɛ̀ nKuyie nti dɔ̀ɔ̀nɛ̀mu mɛtɑummɛ̀ Odɛbu tɑ̃rì. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","Dɛ̀ í tú nɛ̀ ti yɛmbɛ̀ mbɛ ti Yiɛ̀ nKuyie ndɔ̀ɔ̀nɛ̀mɛ̀ dɛ kó mɛtɑummɛ̀, nɛ̀ tímbɛ bɛ̀ɛ̀ bo diɛ nyíe nkɛ kpɑɑ́ fòù. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Ti Yiɛ̀ nKuyie ndo di wetínnɛ́mu ditɑ̃rì Odɛbu ĩ́nkɛ̀ kɛ́ di bɛ́innɛ̀nní muhɑ̃ɑ̃́ mmiɛkɛ, ");
INSERT INTO tbzsim_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Dɛ mɔ̀nnì kɛ̀ n còḿmú díndi nɛ̀ ti Yiɛ̀ nKuyie ndi cuokɛ̀ kɛ̀ kù n nɑ̀ɑ́nnɛ̀ kɛ̀ n di nɑ́ɑ́ nkɛ yɛ̃́ di do í dɑ̀ɑ́tímɛ̀ muhɑ̃ɑ̃́ nkɛ́dekoo ditɑ̃rì ĩ́nkɛ̀. Kɛ̀ ti Yiɛ̀ nKuyie mbɛ́i nkɛ dɔ̀: ");
INSERT INTO tbzsim_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","Fɔ̃́ nhonìtì mí nhɑ Yiɛ̀ nKuyie mmíì dɑ te kɛ̀ míì dɑ dènnɛní Esibiti dihɛì ɑ do tú dì kudɑɑkù, ");
INSERT INTO tbzsim_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","Kuyie ntɛkù mɑkù í bo ɑ dò nkɛ́ntũ nkù kɛ̀ dɛ̀ í tú mí. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","A bɑ́ɑ́ dɔɔ̀ tɛtenkɑɑnìtɛ̀ kɛ́donnɛ̀nɛ̀ dɛ̀ɛ̀ bo kɛĩ́nkɛ̀ miɛkɛ yoo kɛtenkɛ̀ ĩ́nkɛ̀, yoo mɛniɛ mmiɛkɛ kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","A bɑ́ɑ́ nínkú dɛ ììkɛ̀ kɛ́ dɛ̀ bɑ̀ńtɛ̀, míì tu Kuyie nkɛ̀ míì mɑ́ɑ̀ dɑ te, kɛ yóó kpetínnɛ́ wèè yetɛ n kpɛti nɛ̀ o yɑɑ̀bí nɛ̀ i kó ibí nɛ̀ i kó iyɑɑ̀bí, ");
INSERT INTO tbzsim_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","kɛ́ndɔɔri mɛsɑ̀ɑ̀ nwèè n dɔ́ kɛ yíé n kpɛti, nɛ̀ o yɑɑ̀bíyúóó. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","A bɑ́ɑ́ yú mí nhɑ Yiɛ̀ nKuyie n yètìrì sɔ̃́ntíkɛ, kɛ yɛ̃́ n yí yóó yóumɛ̀ wèè yu n yètìrì dɛtetìrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","A nyɛ̃́ tɛom̀pùtɛ̀ kó diyiè kpɛ́í nkɛ̀ di ncɑ̃́ɑ̃́ nkɛ tú n kpɛri, mí nhɑ Yiɛ̀ nKuyie n dɑ nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","A níí pĩ́ nhɑ tɔ̃mmú mumɔu yɛwe yɛ̀kuɔ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Diyiénnì tu mí nhɑ Yiɛ̀ nKuyie nkpɛri ndi. A níí bɑ́ɑ́ pĩ́ mmutɔ̃mmú mɑmù dɛ yiè, bɑ́ ɑ birɛ dɛnitidɑɑrɛ̀ yoo dɛnitipòbirɛ bɑ́ ɑ kóo tɔ̃ntì onitipòkù yoo onitidɔ̀ù bɑ́ ɑ nɑ̀ɑ̀fɛ̀ yoo ɑ sɑ̃mmɑrímú yoo ɑ wũɔ̃ tɛì, yoo opɔ̀ɔ̀ wèè bo ɑ cĩ́ɛ̃̀tɛ̀, bɛmɔu bɛ̀ɛ om̀pɛ̀ dɛ yiè ɑ ompumɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","A nyɛ̃́ kɛ dò nhɑ mɔ́mmuɔ nhɑ do bo Esibiti nwe kɛ tú kudɑɑkù, mí nhɑ Yiɛ̀ nKuyie nkɛ̀ m bɛnkɛ n wɛ̃rímú kɛ dɑ dènnɛní nɛ̀ n kó muwɛ̃rímú. Dɛɛ̀ te kɛ̀ n tu ɑ nhom̀pu tɛom̀pùtɛ̀ yiè. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","A ndé ɑ cicɛ nɛ̀ ɑ yɔ̃. Mí nhɑ Yiɛ̀ nKuyie n tì n dɑ nɑ̀kɛ́mɛ̀ kɛ̀ dɛ̀ɛ yie nkɑ̀ɑ fòmmuu okɛ̀ kɛtenkɛ̀ n dɑ duɔ́ nkɛ̀ miɛkɛ, kɑ̀ɑ mbo kɛ̀ dɛ̀ dɑ nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","A bɑ́ɑ́ kuɔ onìtì. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","A bɑ́ɑ́ duɔ́nɛ̀ wèè í tú ɑ pokù yoo wèè í tú ɑ dɔù. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","A bɑ́ɑ́ yúúkú. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","A bɑ́ɑ́ soutɛ́ kɛ́cɑɑ̀rɛ̀ otɔù yètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","A bɑ́ɑ́ yɑɑ nhotɔù pokù, yoo o cĩ́ɛ̃̀tɛ̀, yoo o pɑɑ, nyoo o kóo tɔ̃ntì onitipòkù yoo onitidɔ̀ù yoo o nɑ̀ɑ̀fɛ̀ yoo o sɑ̃mmɑrímú, dɛ̀ɛ̀ kó dimɑ̀ɑ̀ cɛ̃́nkɛ tú o kpɛrɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Ti nnɑ́ɑǹtì, ti Yiɛ̀ nKuyie nkuù do tì ndi nɑ̀kɛ́ di do tíkú dìì mɔ̀nnì ditɑ̃rì Odɛbu ĩ́nkɛ̀. Kù do nɑ́ɑ́nnɛ̀ mɛtɑnkperímɛ̀ mmɛ ditɑ̃rì ĩ́nkɛ̀, muhɑ̃ɑ̃́ ncuokɛ̀, kɛ̀ kuyukú fĩ nnɛ̀ yɛwɛtisùɔ̀, kù í yìɛ́ tìmɑtì. Kù ti nwɑ̃̀ri titɑ̃́píɛ̀tì ĩ́nkɛ̀ kɛ́ n duɔ́ nkɛ̀ ntì ndi nɑ̀kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Di kèè dìì mɔ̀nnì dɛ kó mɛtɑmmɛ̀ kɛ̀ mɛ̀ yìɛ̀ní ditɑ̃rì ĩ́nkɛ̀ dibiìnnì miɛkɛ, kɛ̀ ditɑ̃rì cɔ̀ú mmuhɑ̃ɑ̃́, bɛ̀ɛ̀ bɑkɛ́ di nɑɑ̀mùntì nɛ̀ bɛhɛikɛ̀nkótíbɛ̀ kɛ̀ dí kɔtɛní m borɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Kɛ dɔ̀: Ti Yiɛ̀ nKuyie nti bɛnkɛmu ku kpetì nɛ̀ kù dɛumɛ̀, kɛ ti bɛ́innɛ̀nní muhɑ̃ɑ̃́ mmiɛkɛ, kɛ̀ ti kèè ku tɑmmɛ̀ yíe nti yɑ̀mu kɛ dò nti Yiɛ̀ nKuyie mbo nɑ kɛ́bɛ́innɛ̀ onìtì kɛ̀ wè nkpɑɑ́ fòù. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Bɑ nkpɛ́í nte kɛ̀ ti bo yóu kɛ̀ muhɑ̃ɑ̃́ ndiɛmù ti cɔ́útɛ́ kɛ̀ ti kú? Kɛ̀ ti sɔkɛ́ kɛ yo dɛ kó mɛtɑmmɛ̀ muhɑ̃ɑ̃́ ndiɛmù yóó ti cɔ́útɛ́mu kɛ̀ ti kú. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Onìtì mɔù mu nyí kèè ti kèèmɛ̀ Kuyie ntɑmmɛ̀ kù ò bɛ́innɛ̀mɛ̀ muhɑ̃ɑ̃́ mmiɛkɛ kɛ kpɑɑ́ fòù. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Fɔ̃́ mMɔyiisi, fɔ̃́ɔ̃̀ mɑ́ɑ̀ níí yóó kɔtɛ kɛ̀ ti Yiɛ̀ nKuyie ndɑ nɑ́kɛ́ kɑ̀ɑ wɛ̃tɛní kɛ́ tí nɑ́kɛ́ kù yɛ̃ mmù, ti yóó yiemmu kɛ́ tì dɔ̀ɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Mɛm̀mɛ kɛ̀ ti Yiɛ̀ nKuyie nkeè di nɑ́ɑ́ ntì kɛ́ n nɑ́kɛ́ kɛ dɔ̀: N kèèmu bɛnìtìbɛ̀ bɛmbɛ dɑ nɑ́ɑ́ ntì, tì wennimu. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Kɛ̀ bɛ̀ do n yie nkɛ́mmɔkɛ dɛ kó mɛyɛ̀mmɛ̀ botí sɑ̃́ɑ̃̀, kɛ́ nni ndé kɛ dɔɔri n tɑnnɔ̀ yɛ̃ mmù dɛ̀ nɑ nwennimu, kɛ̀ bɛ̀ dɔ̀ɔ̀ri mɛmmɛ bɛ̀ bo mbo kɛ̀ dɛ̀ bɛ̀ nɑɑti bɛmbɛ nɛ̀ bɛ yɑɑ̀bío sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Kɔtɛ kɛ́ bɛ̀ nɑ̀kɛ́ kɛ dɔ̀: Kònnɛ̀ di cɛ̃́ĩ. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Kɛ̀ fɔ̃́ nni nkpɑɑ́ diɛ m borɛ̀ kɛ̀ n dɑ nɑ́kɛ́ n tɑnnɔ̀ yɛmɔu nɛ̀ n kuɔ́ nɛ̀ n tié kɑ̀ɑ dɛ̀ mbɛ̀ nɑ̀kɛ́ dɛmɔu kɛ̀ bɛ̀ ndɔɔri dɛ̀ yɛ̃ mmù kɛtenkɛ̀ m bɛ̀ duɔ́ nkɛ̀ kɛ̀ bɛ̀ bo kɛ̀ tiekɛ kɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Nyɛ̃́nɛ̀ tũnkɛ́ kɛ́ndɔɔri ti Yiɛ̀ nKuyie ndi tũ nkù yɛ̃ ndi ndɔɔri dɛ̀ dɛmɔu, di bɑ́ɑ́ dɑutɛ́ kucɑ̃̀nku yoo kuyoú. ");
INSERT INTO tbzsim_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","Dí ntũ nkucɛ ti Yiɛ̀ nKuyie ndi tũ nkù di bɛnkɛ kù mɛsɑ̀ɑ̀, kɛ̀ dɛ̀ɛ yie nkɛ̀ dí nfòù kɛ́mbo dihɛì kù di duɔ́ ndì kɛ̀ dɛ̀ nɑɑti, kɛ̀ di fòmmuu mɔntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Ntɛnɛ̀ ti Yiɛ̀ nKuyie nni nduɔ́ nyɛ̀ɛ̀ tɑnnɔ̀ nɛ̀ ìì tié nkɛ yɛ̃ n dɛ̀ ndi tié, kɛ̀ dɛ̀ɛ yie nkɛ̀ di tɑ dìì mɔ̀nnì dihɛì kù yɛ̃ nkù yóó di duɔ́ ndì kɛ̀ di tiekɛ, dí ndɔɔri dɛ̀ yɛ̃ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Mɛm̀mɛ di bo ndémɛ̀ ti Yiɛ̀ nKuyie ndi fòmmu mumɔu miɛkɛ, kɛ́ntũ nku tɑnnɔ̀ yɛmɔu nɛ̀ ku kuɔ́ n di tié ndɛ̀ díndi nɛ̀ di bí nɛ̀ di yɑɑ̀bío kɛ̀ dɛ̀ɛ yie nkɛ̀ di fòmmuu okɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Díndi Isidɑyɛɛribɛ kéntɛ́nɛ̀, kɛ́ndɑkɛ kɛ́ndɔɔri ku kuɔ́ yɛ̃ mmù, kɛ̀ di dɔɔri mɛmmɛ di bo mbo kɛ̀ dɛ̀ di nɑɑti kɛ̀ dí sṹṹ nkɛtenkɛ̀ ti Yiɛ̀ nKuyie ndi duɔ́ nkɛ̀, mɛnɑɑmiɛ̀ nnɛ̀ mɛcekùɔ̀ ndɛ̀ pũɔ̃ nkɛ̀. Ti Yiɛ̀ nKuyie ndi yɛmbɛ̀ do tũ nku kù tu dìì mɔ̀nnì: ");
INSERT INTO tbzsim_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Kéntɛ́nɛ̀ díndi Isidɑyɛɛribɛ ti Yiɛ̀ nKuyie nkùù tu kutenkù kumɔu yiɛ̀: ");
INSERT INTO tbzsim_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","Onìtì fɔ̃́, ɑ ndɔ́ ɑ Yiɛ̀ nKuyie nnɛ̀ ɑ yɛ̀mmɛ̀ mɛmɔu nɛ̀ ɑ wɛ̃nnì dimɔu nɛ̀ ɑ wɛ̃rímú mumɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Kuyie ntɑnnɔ̀ n di tiè nyɛ̀ yíe ndí yɛ̀ ɑ̃nnɛ́ di yɛ̀mmɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","Dí ntì tiè ndi bí di borɛ̀ tɛcĩ́ɛ̃̀tɛ̀ nɛ̀ di borɛ̀ kupɔ̀ɔ̀kù di yóó duɔ́ dìì mɔ̀nnì nɛ̀ di èntɛ dìì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","Dí ntì ṹ di nɔu tɛnɛitɛ kɔ̃mɛ, kɛ́ ntì ìrí bɛ̀ ɔ̃ nyírímɛ̀ kuítùòkù, ");
INSERT INTO tbzsim_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","kɛ́ tì wɑ̃̀ri di cɛ̃́ĩ kó yɛsɑ̃ǹkɛ̀ nɛ̀ yɛbòrɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Ti Yiɛ̀ nKuyie nkùù di te kù bo di tɑnnɛ́ dìì mɔ̀nnì kù do nɑ̀kɛ́ di yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu kɛ́ĩkú kɛ dɔ̀ kù yóó bɛ̀ duɔ́ nkɛ̀ɛ̀ tenkɛ̀ nɛ̀ yɛ̀ɛ̀ ɛkɛ̀ sɑ̀ɑ̀yɛ̀ di í mɑɑ́ yɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","sicɛ̃́ĩ borɛ̀ kɛ píɛ́kɛ́ dɛsɑ̀ɑ̀rɛ̀ dɛmɔu botí, díì mɛ nyí dɛ̀ ɑ̃nnɛ́, sibií borɛ̀ díì mɛ nyí sì keú, dɛtie mbɛ̀ tu dɛ̀ fínyĩ̀ nɛ̀ bɛ̀ tu dɛ̀ odìfíè dɛ̀ borɛ̀ díì mɛ nyí dɛ̀ fìíkú, ");
INSERT INTO tbzsim_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","kɛ yóó sɔ̃́ntɛ́ kɛ́nyo ndi dɔ́mɛ̀. Dí ndɑkɛ kɛ bɑ́ɑ́ yɛ̃̀ nti Yiɛ̀ nKuyie nkùù di dènnɛní Esibiti miɛkɛ di do tú kɛ̀ tidɑɑtì ku kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","Di yóó nku ndé kɛ́ nku mbɑ́ɑ́ nkumɑ́ɑ̀, di níí yóó pɑrìkɛ̀ nɛ̀ kuù kó diyètìrì. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","Di bɑ́ɑ́ tũnnɛ ibotí tɛì ìì di fitɛ́ ì tũ nyɛ̀ɛ̀ bɔkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Ti Yiɛ̀ nKuyie mbomu di cuokɛ̀ kù dɔ́ kuù mɑ́ɑ̀ ndi te, dí ndɑkɛ kɛ bɑ́ɑ́ kù wɛ̃̀ńtɛ́ kɛ̀ ku miɛkɛɛ dí yɛ̀ kɛ̀ kùu di kuɔ pɑ́íí kɛtenkɛ̀ di bo kɛ̀ɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","Di bɑ́ɑ́ yɑ́ɑ́kɛ́ ti Yiɛ̀ nKuyie ndi do kù yɑ̀ɑ́kɛ́mɛ̀ di do bo dìì mɔ̀nnì Mɑsɑ Bɛ̀ bo dìì mɔ̀nnì ndi dikpɑ́ɑ̀ miɛkɛ kɛ̀ mɛniɛ ndɛ mbɛ̀ dòńtɛ́ kɛ̀ Kuyie nduɔ́ nkɛ̀ Mɔyiisii potɛ́ dipèrì kɛ̀ mɛniɛ nyɛnní, kɛ̀ ifɛi bɛ̀ pĩ, mbɛ̀ do yĩɛ̃̀kù mɛ̀ɛ̀ kpɛ́í. (Mudennimù 17:7, Ikuɔ́ kóntímù 6:16, 9:22, Yɛsɑ̃ɑ̃ 95:8-9). ");
INSERT INTO tbzsim_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Dí ndɑkɛ kɛ́ntũ nti Yiɛ̀ nKuyie nkùù di te ku kó yɛtɑnnɔ̀ nɛ̀ ku tié nnɛ̀ ku kuɔ́ kù di duɔ́ ndɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","Dí ndɔɔri dɛ̀ɛ̀ sìɛ́ ti Yiɛ̀ nKuyie ndɔ́ dɛ̀, kɛ̀ dɛ̀ɛ yie nkɛ̀ dí mbo kɛ̀ dɛ̀ di nɑɑti, kɛtensɑ̀ɑ̀kɛ̀ ti Yiɛ̀ nKuyie ndo bɛ́i nkɛ́ĩkú kɛ dɔ̀ kù yóó duɔ́ nkɛ̀ di yɛmbɛ̀, ");
INSERT INTO tbzsim_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","kɛ́bɛ́i nkɛ dɔ̀ kuù yóó bɛti di dootitɔbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Kɛ̀ di bí nɑɑ di bekɛ kɛ yĩ: Bɑ nte kɛ̀ ti Yiɛ̀ nKuyie ndi duɔ́ ku tɑnnɔ̀ nɛ̀ ku kuɔ́ nɛ̀ ku tié? ");
INSERT INTO tbzsim_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","Dí ì nɑ̀kɛ́ kɛ dɔ̀: Ti do bo Esibiti nwe kɛ tú Esibiti kóo kpɑ̀ɑ̀tì kó tidɑɑtì kɛ̀ ti Yiɛ̀ nKuyie nti dènnɛní nɛ̀ ku kó muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","Ti Yiɛ̀ nKuyie ndo dɔ̀ɔ̀ tidiɛtì kpɛrɛ ndɛ nɛ̀ mɛbɛnkùmɛ̀ diɛmɛ̀ kɛ́cɑɑ̀rɛ̀ Esibiti kɔbɛ nɛ̀ bɛ kóo kpɑ̀ɑ̀tì nɛ̀ o cĩ́ɛ̃̀tɛ̀ kɔbɛ, ");
INSERT INTO tbzsim_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","kɛ́ ti dennɛ kɛ ti tɔní diɛ nkɛtenkɛ̀ kù do bɛ́i nkɛ́ĩkú kɛ dɔ̀ kù yóó duɔ́ nkɛ̀ ti yɛmbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Mɛm̀mɛ ti Yiɛ̀ nKuyie nti nɑ̀kɛ́mɛ̀ kɛ dɔ̀, tí ndɔɔri ku kuɔ́ yɛ̃mmɛ̀, kɛ́ nkù dé kɛ̀ dɛ̀ɛ yie nkɛ̀ tí mbo kɛ̀ dɛ̀ ti nɑɑti, kɛ dò nti mɛ̀ nfòù kɛ̀ dɛ̀ ti dòmmɛ̀ yíe. ");
INSERT INTO tbzsim_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Kɛ̀ ti duɔ́ nti yɛ̀mmɛ̀ kɛ tũ nti Yiɛ̀ nKuyie ntɑnnɔ̀ nɛ̀ ku kuɔ́ dɛ̀ yɛ̃mmɛ̀, mɛm̀mɛ ku yɛ̀mmɛ̀ bo nti nɑɑtinɛ̀mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Kɛ̀ Mɔyiisi bɛ́i nkɛ dɔ̀: Kɛ̀ ti Yiɛ̀ nKuyie nkùù di te di tɑnnɛ̀ dìì mɔ̀nnì kɛtenkɛ̀ di yóó tiekɛ kɛ̀ kɛ bɛ̀ti ibotí ìì di sũnɛ̀, ìì tu Itiibɛ nɛ̀ Kidikɑsiibɛ nɛ̀ Amɔriibɛ nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ nɛ̀ Pedisiibɛ nɛ̀ Efiibɛ nɛ̀ Sebusiibɛ. Ibotí inyi iyiekɛ̀ ìì di sũnɛ̀ kɛ di kpeńnìnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","Kɛ̀ ti Yiɛ̀ nKuyie mbɛ̀ ndi duɔ́ dìì mɔ̀nnì kɛ̀ di bɛ̀ nɑ, dí bɛ̀ kùɔ bɛmɔu pɑ́íí kɛ bɑ́ɑ́ súɔ́ nhòmɔù, di bɑ́ɑ́ bɛ̀ dɔ̀ɔ̀nɛ̀ mɛtɑummɛ̀, di bɑ́ɑ́ bɛ̀ kuɔ́ mmɛsémmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","Nɛ̀ dɛ kó ibotí kɔbɛ di bɑ́ mpuokú, di bɑ́ɑ́ duɔ́ ndi kóo sɑpɑ̀ɑ̀ mmɔù bɛ kóo dɑpɑ̀ɑ̀ nkɛ̀ wèe puokɛ, di mɛ mbɑ́ɑ́ túótɛ́ bɛ kóo sɑpɑ̀ɑ̀ mmɔù kɛ́duɔ́ ndi kóo dɑpɑ̀ɑ̀ nkɛ̀ wèe puokɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Kɛ̀ di dɔ̀ɔ̀ mɛmmɛ bɛ̀ yóó dɛ́tìnnɛ di bí nyi Kuyie nkó kucɛ, kɛ́nte kɛ̀ bɛ̀ɛ fíé iwũɔ̃ yɛbɔkɛ̀, kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛɛ di yɛ̀, kɛ̀ kù di kuɔ bɑ́ dɛ̀ bɑ́ɑ́ ɔɔtɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Ntɛ di dò nkɛ́ bɛ̀ dɔ̀ɔ̀mɛ̀. Dí puɔ mbɛ wũɔ̃tɔ̀rɛ̀, kɛ́bɔ́kɛ́ bɛ bɔɔtɑ̃́rɛ̀, kɛ́u bɛ bɔɔ̀ Asedɑɑ kó itedɛí, kɛ́cɔ́u mbɛ bɔkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Di cɑ̃́ɑ̃́mmu kɛ tú ti Yiɛ̀ nKuyie nkɔbɛ, ti Yiɛ̀ nKuyie ntɑ̃ɑ̃tɛ́ dímbɛ ibotí tɛì miɛkɛ, kɛ̀ di bo ntú ku kɔbɛ kù dɔ́ bɛ̀, kɛtenkɛ̀ kɛmɔu duɔmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","Kɛ̀ ti Yiɛ̀ nKuyie ndi tɑunnɛ̀ kumɑ́ɑ̀ kɛ di tɑ̃ɑ̃tɛ́, dɛ̀ í tú di sũ mɛ̀ɛ̀ kpɛ́í. Díì pètìnkɛ tú kubotí sɑ́m̀pɔ́kù ibotí tɛì imɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Kù nɛ́ di dɔ́mu dɛɛ̀ kpɛ́í nte, nɛ̀ kù dɔ́mɛ̀ kɛ́mpĩ́ ndinùù kù do dɔúnnɛ̀ dì di yɛmbɛ̀ kɛ́bɛ́i nkɛ́ĩkú, dɛɛ̀ te kɛ̀ kù bɛnkɛ ku wɛ̃rímú kɛ di dènnɛ tidɑɑtì miɛkɛ, kɛ di dɛɛtɛ́ Esibiti kóo kpɑ̀ɑ̀tì nɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Di tũ mbɑntɛ́ kɛ dò ndi Yiɛ̀ nKuyie nkùù di te kuù tu Kuyie kɛ dɔɔri kù bɛ́i ntì kɛ́mpĩ́ mmɛtɑummɛ̀ kù di dɔ̀ɔ̀nɛ̀ mɛ̀ kɛ dɔɔri mɛsɑ̀ɑ̀ mbɛ̀ɛ̀ kù dɔ́, kɛ pĩ́ nku tɑnnɔ̀ nɛ̀ bɛ yɑɑ̀bíyúóó. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Kɛ ɔ̃ɔ̃ yṹɔ̃́ nwèè yetɛ ku kpɛti o to, bɑ́ dɛ̀ bɑ́ɑ́ ɔɔtɛ, wèè í kù dɔ́ dɛ̀ ɔ̃ɔ̃ í ntùɔ̀kɛ tɛpɛ̃nkpɛ̃̀ntɛ̀ kɛ̀ wèè yɑ̀ o yetímɛ̀ kó tiyeti. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Mpĩ́nnɛ̀ tũnkɛ́ Kuyie ntɑnnɔ̀ nɛ̀ ku kuɔ́ nɛ̀ ku tié, n di duɔ̀ ndɛ̀ yíe nkɛ́ndɔɔri dɛ̀ yɛ̃ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Kɛ̀ di kemmu ku tié nkɛ ì pĩ nkɛ dɔɔri ì yɛ̃mmɛ̀. Mɛm̀mɛ di Yiɛ̀ nKuyie nkùù di te kù bo mpĩ́mmɛ̀ kù di dɔ̀ɔ̀nɛ̀ mɛ̀ɛ̀ tɑummɛ̀ kɛ́ ndi dɔɔri mɛsɑ̀ɑ̀ kù do bɛ́innɛ̀ di yɛmbɛ̀ kɛ ĩkú kɛ dɔ̀ kù yóó mbɛ̀ dɔ̀ɔ̀ri mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","Kù bo ndi dɔ́ kɛ di dɔɔri mɛsɑ̀ɑ̀ nkɛ̀ dí sṹṹ, kɛ̀ kù di duɔ́ nkupɛitóo, kɛ́duɔ́ nkɛ̀ di pɑɑ nni mpɛí, kɛ̀ tidiitì mbo, kɛ̀ fínyĩ̀ kó dɛtie nnɛ̀ odìfíè kó dɛtie kɛ̀ dɛ̀ mpɛí, kɛ̀ di wũɔ̃ mpɛí inɑ̀ɑ̀kɛ nɛ̀ ipe nɛ̀ sibɔɔ́ di tenkɛ̀ Kuyie ndo bɛ́i nkɛ́ĩkú kɛ dɔ̀ kù yóó duɔ́ nkɛ̀ɛ̀ tenkɛ̀ di yɛmbɛ̀ kɛ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","Kù bo dɔɔ̀ di kó kubotí mɛsɑ̀ɑ̀ nkɛ̀ dɛ̀ɛ pɛ̃ɛ̃tɛ́ ibotí tɛì. Di miɛkɛ onitidɔ̀ù mɔù bɑ́ mbo wèè bo yĩɛ̃kɛ ò bo pónnɛ́mɛ̀, tɛhɑ̃ũntɛ mɛ mbɑ́ mbo. Di wũɔ̃ miɛkɛ fɛ̀mɑfɛ̀ bɑ́ɑ́ ɑ̃ṹ. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Ti Yiɛ̀ nKuyie mbo kɛi mmumɔmmú mumɔu di borɛ̀ kù bɑ́ɑ́ di bɔntɛ́ mumɔmmú yɛimu kù do bɔntɛ́ mù Esibiti kɔbɛ di yɛ̃́ mùù kpɛ́í, kù bo mù bɔntɛ́ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ di níí mbɛ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","Ti Yiɛ̀ nKuyie nyóó duɔ́mmu kɛ̀ dí nɑ ibotí tɛì kɔbɛ, dí bɛ̀ kùɔ dí bɑ́ɑ́ kuɔ́ nhòmɔù mɛsémmɛ̀, di mɛ mbɑ́ɑ́ fíé iwũɔ̃ bɛ bɔkɛ̀. Kɛ̀ di dɔ̀ɔ̀ mɛmmɛ yɛ̀ bo nɑɑ́ ndi kpɛ́í ndidíìntɑ̃́rì kɛ di bɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Kɛ̀ dɛ̀ yɛ̀mmɛ̀ di bo yĩ́ nɛ̀ di yɛ̀mmɛ̀ miɛkɛ dɛ kó ibotí mɛ nti sũnɛ̀mɛ̀ ti bo yĩ́mɛ kɛ́fietɛ bɛ tenkɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","Di bɑ́ɑ́ bɛ̀ yɔ̀tɛ, dí dentɛní ti Yiɛ̀ nKuyie nkùù di te kù do dɔ̀ɔ̀mɛ̀ Esibiti kóo kpɑ̀ɑ̀tì nɛ̀ o kɔbɛ bɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Di yɑ̀mu ti Yiɛ̀ nKuyie nkùù di te kù do bɛ̀ yɑ̀ɑ́kɛ́mɛ̀ nɛ̀ kù dɔ̀ɔ̀ tìì diɛtì nɛ̀ mɛ̀ɛ̀ bɛnkùmɛ̀ kó dimɑ̀ɑ̀, kɛ di dènnɛ nɛ̀ muwɛ̃rímú Esibiti, kù yóó mɛ nyĩ́ iwuɔ ndi mɛ̀ ndé ì. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","Ti Yiɛ̀ nKuyie nkùù di te kù yóó nii nyɛcɑ̃nkɛ̀dèèsùɔ̀ nyɛ di ììkɛ̀ kɛ̀ yɛ̀ mbɛtì bɛ̀ɛ̀ yentɛ́ yentɛ́ kɛ wɑnti kɛ́sɔri. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","Di bɑ́ mbɛ̀ dé ti Yiɛ̀ nKuyie nkùù di te kù di bonɛ̀mu, kù kpeńnìmu kɛ dùò tikɔ̃m̀bùɔ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","Dɛ kó iwuɔ ndi yóó nyì kɔ̀ù sɑ́m̀pɔ́ sɑ́m̀pɔ́ nwe kɛ́ ì dèè. Di bɑ́ɑ́ nɑ kɛ́ ì kùɔ dimɔ̀nnì dìmɑ́ɑ̀, kɛ̀ mɛɛ̀ dɔkɛ dɛpĩ́mpĩ́nnɛ̀ bo sṹṹ ndi tenkɛ̀ kɛ́ di cɑ́ɑ́kɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Ti Yiɛ̀ nKuyie nkùù di te kù yóó di duɔ́mmu dɛ kó iwuɔ kɛ̀ di ì bɛ̀ti kɛ̀ kufɔ̃wɑɑ́ ndiɛkùu ì ɑutɛ́ kɛ̀ dí ì kùɔ imɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","Kù yóó ɑ̃nnɛ́mu i kó bɛkpɑ̀ɑ̀tìbɛ̀ di nɔu miɛkɛ kɛ̀ dí bɛ̀ kùɔ kɛ̀ bɛ yètɛ̀ɛ kpɑ́nnɛ́ kutenkù miɛkɛ. Bɛ kóò mɔù í yóó dɑ́ɑ́tí kɛ́cómmú di ììkɛ̀ di yóó bɛ̀ kùɔmu pɑ́íí kɛ́ bɛ̀ dèè. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","Dí cɔ́u mbɛ bɔɔtenkɑɑnìi, di bɑ́ɑ́ túótɛ́ bɛ̀ sì dɑ̀rì tìì mɑ́tì pɛ́ítì nɛ̀ mɛ̀ɛ̀ sɔɔ, di bɑ́ɑ́ dɛ̀ tùótɛ́ kɛ́tiekɛ, dɛ̀ í yóó di dɔɔ̀ mɛsɑ̀ɑ̀, ti Yiɛ̀ nKuyie nkùù di te kù dɛ̀ wùó nyisɔkɛ nyi. ");
INSERT INTO tbzsim_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","Di bɑ́ɑ́ tɑnnɛ́ dɛ kó sibɔɔtenkɑɑnìi di cɛ̃́ĩ miɛkɛ, di mɔ́mmɔmbɛ di yɑ̀ɑ̀ bo sì nɑɑ́nnɛ̀ kɛ̀ bɛ̀ di kuɔ, bɛ̀ yóó sì pùɔ mmɛ̀ɛ̀ botí. Dí nsì wùó nyisɔkɛ kpɛrɛ dɛ̀ɛ̀ dò nkɛ́puɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","Dí mpĩ́ nyɛtɑnnɔ̀ m mɛ ndi duɔ́ nyɛ̀ yíe nkɛ́ndɔɔri yɛ̀ yɛ̃mmɛ̀ kɛ̀ dɛ̀ɛ yie nkɛ̀ dí nfòù kɛ́sṹṹ nkɛ́tiekɛ kɛtenkɛ̀, ti Yiɛ̀ nKuyie ndo bɛ́i nkɛ́ĩkú kɛ dɔ̀ kù yóó duɔ́ nkɛ̀ di yɛmbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","Di bɑ́ɑ́ yɛ̃̀ nti Yiɛ̀ nKuyie nkùù di te kù duɔ́ nkɛ̀ di ce mmùù cèmmu yɛbie nsipísìnɑ̀ɑ̀ dikpɑ́ɑ̀ miɛkɛ, kɛ̀ kù di tɑnnɛ́ mɛhɑ́ɑ́rìmɛ̀ miɛkɛ, kɛ di kɛ̃́kùnnɛ kɛ di yɑ̀ɑ́kɛ́ kɛ bo yɑ̀ di yɛ̀mmɛ̀ dòmmɛ̀, kɛ̀ nsɑ̀ di bo mpĩ́ nku tɑnnɔ̀ yoo di bo yɛ̀ yetɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","Kuù yóu kɛ̀ di tɑ mɛhɑ́ɑ́rìmɛ̀ miɛkɛ kɛ̀ dikònnì di pĩ nkɛ̀ kù di duɔ́ mmudiì bɛ̀ tu mù mɑ́nnì, di do í yɛ̃́ mù díndi nɛ̀ di yɛmbɛ̀, kɛ̀ dɛ̀ bo yie nkɛ̀ dí bɑntɛ́ kɛ dò nhonìtì í fòùnɛ̀ mudiì mɑ́ɑ̀ dɔkɛ, kòò fòùnɛ̀ tìì yìɛ̀ní tìnti ti Yiɛ̀ nKuyie nnùù miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Yɛɛ̀ bie nsipísìnɑ̀ɑ̀ miɛkɛ di yɑ̀ɑ̀tì í kɛ̃rí di nɑɑ̀cɛ̀i mɛ nyí mùútí. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","Bɑntɛ́nɛ̀ kɛ dò nti Yiɛ̀ nKuyie nkùù di te kù di tié nhonìtì ɔ̃ɔ̃ tiémmɛ̀ mmɛ o birɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","Dí nyíé ti Yiɛ̀ nKuyie nkùù di te ku kuɔ́ kɛ́ntũ nku kó kucɛ kɛ́ nkù dé. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Ti Yiɛ̀ nKuyie nkùù di te kù yóó di tɑnnɛ́mu kɛtensɑ̀ɑ̀kɛ̀ ikó mborɛ̀ nɛ̀ sibií nɛ̀ yɛnɛ́bòrɛ̀, kɛ̀ mɛniɛ nyiɛ̀ní itɑ̃fuɔ nnɛ̀ yɛtɑ̃rɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Dɛ kó kɛtenkɛ̀ tidiitì bɛ̀ tu tì bèdéè nɛ̀ titɛtì bɛ̀ tu tì ɔ́dìsì nɛ̀ dɛtie mbɛ̀ tu dɛ̀ fínyĩ̀ nɛ̀ dɛtɛrɛ̀ bɛ̀ tu dɛ̀ fìkíè nɛ̀ dɛtɛrɛ̀ bɛ̀ tu dɛ̀ kèdènɑ́díè, kɛ̀ odìfíè kó dɛtie mbo kɛ̀ mɛcekùɔ̀ mbo. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Dɛ kó kɛtenkɛ̀ miɛkɛ di yóó nyo ndi dɔ́mɛ̀ mmɛ dɛ̀mɑrɛ̀ í yóó di dóntɛ́, bɛ̀ í yó ndi beu tidiitì. Dɛ kó kɛtenkɛ̀ kó yɛtɑ̃́rɛ̀ mɔ̀kɛ timɑ́tì nti, kɛ̀ yɛtɑ̃rɛ̀ mɔ̀kɛ disɔɔwũɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Kɛ̀ di di kɛ sɑ̀nnɛ̀ dí ndɔú nti Yiɛ̀ nKuyie nkùù di te nɛ̀ mutɔ̃mmú dihɛì sɑ̀ɑ̀rì kù di duɔ́ ndì kpɛ́í. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","Dí ndɑkɛ kɛ bɑ́ɑ́ yɛ̃̀ nti Yiɛ̀ nKuyie nkùù di te, kɛ́yóu di bo ntũmmɛ̀ ku tɑnnɔ̀ nɛ̀ ku kuɔ́ nɛ̀ ku tié n di duɔ̀ ndɛ̀ yíe, ");
INSERT INTO tbzsim_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","kɛ̀ di di kɛ sɑ̀nnɛ̀ kɛ mɑɑ́ sicɛ̃sɑ̀ɑ̀sì kɛ ɑ̃, ");
INSERT INTO tbzsim_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","kɛ mɔ̀ɔ̀tɛ iwũɔ̃ pɛ́u idiɛyì nɛ̀ isɑ́m̀pɔ́ì, kɛ mɔ̀ɔ̀tɛ timɑ́tì pɛ́ítì nɛ̀ mɛsɔɔ, kɛ kpɑ̀rìkɛ̀, dɛmɔu kɛ̀ dɛ̀ bo. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Dí dɔɔ̀ mɛyɔɔ̀mmɛ̀ kɛ bɑ́ɑ́ mɔɔtɛ tɛfentɛ̀ kɛ́yɛ̃̀ nti Yiɛ̀ nKuyie nkùù di te kùù di dènnɛní Esibiti di do tú dɛ̀ tidɑɑtì, ");
INSERT INTO tbzsim_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","kɛ duɔ́ nkɛ̀ di cè nfɛkpɑ́fɛ̀ fiɛ mmiɛkɛ, iwɑɑyɛiyi bo dɛ̀ nɛ̀ inɑɑ́, kɛ̀ sinɛ́yɛ̃ĩ di pĩ nkɛ̀ mɛniɛ nyí mbo, kɛ̀ kùu dennɛní mɛniɛ nkupèrìkù miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","Kɛ di duɔ́ mmudiì di yɛmbɛ̀ do í yɛ̃́ mù bɛ̀ tu mù mɑ́nnì kɛ̀ di di. Kù yóu kɛ̀ di tɑ mɛhɑ́ɑ́rìmɛ̀ kɛ̀ kù bo di yɑ́ɑ́kɛ́mu kɛ di kɛ̃́kùnnɛ kɛ́deè kɛ nɛ́ di dɔɔ̀ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","Dí ndɑkɛ kɛ bɑ́ɑ́ yie nkɛ̀ di yɛ̀mmɛ̀ ndò di kó muwɛ̃rímú mmu nɛ̀ di kó mutɔ̃mmú mmu di pɛ̀tɛ́mɛ̀ dɛ kó tikpɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","Di bɑ́ɑ́ yɛ̃̀ nti Yiɛ̀ nKuyie nkpɛ́í, kuù di pɑ̃mɛ̀ muwɛ̃rímú kɛ̀ di pɛ̀tɛ́nɛ̀ dɛ kó tikpɑ̀tì, kù mɛ̀ dɔ̀ɔ̀ kɛ̀ di bo bɑntɛ́ kù pĩ̀ḿmɛ̀ mmɛ mɛtɑummɛ̀ kù do bɛ́i nkɛ́ĩkú kɛ dɔ̀ kù bo dɔɔ̀nɛ̀mɛ̀ di yɛmbɛ̀, dɛ̀ mɛ̀ ndòmmɛ̀ yíe. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","Kɛ̀ di yɛ̃̀ nti Yiɛ̀ nKuyie nkùù di te kɛ tũ̀nnɛ yɛbɔkɛ̀ kɛ yɛ̀ fìé iwũɔ̃, kɛ kɔ̃nkù yɛ̀ ììkɛ̀ kɛ yɛ̀ bɑ̀ɑ́ ndi yóó kúmu. N di cɑummu yíe. ");
INSERT INTO tbzsim_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","Timɔ́mmɔnti nti kɛ̀ di í yie nti Yiɛ̀ nKuyie nkùù di te ku kpɛti di yóó kúmu kɛ́deè ibotí tɛì kù kɔ̀ùtì ì di ììkɛ̀ i kɔ̃mɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Isidɑyɛɛribɛ, kéntɛ́nɛ̀ kɛ́keè! Di yóó séntɛ́mu yíe nkukó nSuditɛ̃ɛ̃ kɛ́kɔtɛ kɛ́bɛti ibotí ìì dɛu kɛ kpeńnì kɛ di pɛ̃ɛ̃tɛ́ kɛ́tiekɛ yɛhɛkɛ̀ diɛyɛ̀ yɛ̀ɛ̀ kó iduotí okù kɛ kɑ́ɑ́ ntiwɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","Di yóó nɑmu Anɑkiibɛ bɛ̀ɛ̀ kpeńnì kɛ tú tidɑdiɛtì kɛ̀ bɛ̀ ɔ̃ nnɑ́ɑ́ mbɛ kpɛ́í nkɛ di yo kɛ̀ bɛ̀ tu Anɑkiibɑɑ? We mbo dɑ́ɑ́tí kɛ́cómmú bɛ ììkɛ̀? ");
INSERT INTO tbzsim_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Dí nyɛ̃́ yíe nkɛ dò nti Yiɛ̀ nKuyie nkùù di te kuù ni di ììkɛ̀ kɛ dò mmuhɑ̃ɑ̃́ nkɛ cɔ́ú ndɛmɔu. Kù yóó kuɔmu dɛ kó iwuɔ nyimɔu, kuù yóó duɔ́ nkɛ̀ bɛ̀ di bɔ́útɛ́ kɛ̀ dí mbɛ̀ bɛ̀tì, kɛ́ bɛ̀ kùɔ kɛ́deè bɑ́ dɛ̀ bɑ́ɑ́ ɔɔtɛ, ti Yiɛ̀ nKuyie ntì ndi nɑ̀kɛ́mu. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Kɛ̀ ti Yiɛ̀ nKuyie nkùù di te bɛ̀ bɛ̀ti di ììkɛ̀ di bɑ́ mpɔtì kɛ tú di wenni mɛ̀ kpɛ́í nte kɛ̀ ti Yiɛ̀ nKuyie ndi tɑnnɛ́ dɛ kó kɛtenkɛ̀, dɛ kó ibotí dɔrimɛ̀ kpɛ́í nte kɛ̀ kù ì bɛ̀ti. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","Dɛ̀ í tú di wetí mɛ̀ɛ̀ kpɛ́í nyoo di yɛ̀mmɛ̀ wenni mɛ̀ɛ̀ kpɛ́í nte kɛ̀ di yóó tiekɛ dɛ kó kɛtenkɛ̀, dɛ kó ibotí kó tidɔnnitì tiì kpɛ́í nte kɛ̀ ti Yiɛ̀ nKuyie nkùù di te kɛ̀ kù yóó bɛ̀ bɛ̀ti, kù dɔ́ mɛ̀ɛ̀ kpɛ́í nkɛ́dɔɔ̀ kù do dɔúnnɛ̀ dìì nùù di yɛmbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","Nyɛ̃́nɛ̀ tũnkɛ́ kɛ dò nkɛ̀ ti Yiɛ̀ nKuyie nkùù di te kuù di duɔ́ ndɛ kó kɛtenkɛ̀ dɛ̀ í tú di wetí mɛ̀ɛ̀ kpɛ́í nte kù di duɔ́mmɛ̀ dɛ kó kɛtensɑ̀ɑ̀kɛ̀, díì pètìnkɛ tú ku botí kùù to kpeńnì. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","Díndi Isidɑyɛɛribɛ di bɑ́ɑ́ yɛ̃̀ ndi do íinkomɛ̀ ti Yiɛ̀ nKuyie nkuù di te ku miɛkɛ dikpɑ́ɑ̀ tɛdɔntɛ̀ cuokɛ̀, kɛ́túótɛ́ di yɛ̀ dìì yiè Esibiti kɛ́ntɔ kɛ́tuɔkɛnɛ̀ní yíe nti mɛ mborɛ̀, di í yie nKuyie nkpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","Odɛbu tɑ̃rì di do íimmu ti Yiɛ̀ nKuyie mmiɛkɛ mɛdiɛ̀ nkɛ̀ kù ndɔ́ kɛ́ di kuɔ dimɔu pɑ́íí. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","N do dèkɛ dìì mɔ̀nnì ditɑ̃rì kɛ̀ ti Yiɛ̀ nKuyie mbo n duɔ́ ntitɑ̃́píɛ̀tì ku tɑummɛ̀ kuɔ́ wɑ̃̀ri tìì ĩ́nkɛ̀, kɛ̀ nní mbo ditɑ̃rì ĩ́nkɛ̀ kɛ dɔ̀ yɛwe sipísìnɑ̀ɑ̀, dɛyènnɛ̀ sipísìnɑ̀ɑ̀ kɛ í yo m mɛ nyí yɔ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","Kɛ̀ ti Yiɛ̀ nKuyie nwɑ̃ri titɑ̃́píɛ̀tì tìdɛ́tì ĩ́nkɛ̀ ku tɑnnɔ̀ kù do di nɑ̀kɛ́ yɛ̀ di tíkú dìì mɔ̀nnì ditɑ̃rì pɛ̃ri kɛ kù di nɑ́ɑ́nnɛ̀nní kɛ̀ di yo ku tɑmmɛ̀ muhɑ̃ɑ̃́ mmiɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","Yɛwe sipísìnɑ̀ɑ̀ nɛ̀ dɛyènnɛ̀ sipísìnɑ̀ɑ̀ kó difɔ̃nkúò kɛ̀ kù n duɔ́ nku tɑummɛ̀ kuɔ́ kó titɑ̃́píɛ̀tì tìdɛ́, ");
INSERT INTO tbzsim_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","kɛ́ n nɑ́kɛ́ kɛ dɔ̀: Ítɛ́ kɛ́cútɛ́ mɛcɑ̃ɑ̃ nhɑ nìtìbɛ̀ ɑ dènnɛní bɛ̀ Esibiti bɛ̀ n cɑ̀kɛmu, bɛ̀ yóumu dɛndɛ bɑ̀mbɑ̀ n kó kucɛ n do bɛ̀ bɛnkɛ kù kɛ dɔ̀ɔ̀ fɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Ti Yiɛ̀ nKuyie dɛ nni nnɑ́kɛ́ kɛ dɔ̀: N yɑ̀mu dɛ kó bɛnìtìbɛ̀ kɛ sɔ̃́ mbɛ to yɛɛ̀ kpeńnì. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","Yóu kɛ̀ m bɛ̀ kùɔ bɛmɔu pɑ́íí kɛ̀ bɛ yètìrìi kpɑ́nnɛ́ kutenkù miɛkɛ kɛ̀ n dɑ dɔɔ̀ kuwuɔ nkperíkù kùù yó nsũ kɛ́pɛ̃ɛ̃tɛ́ kuu. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Mɛm̀mɛ kɛ̀ n cútɛ́ní ditɑ̃rì dìì cɔ̀ú mmuhɑ̃ɑ̃́ ndi ĩ́nkɛ̀, kɛ tɔ Kuyie ntɑummɛ̀ kuɔ́ wɑ̃̀ri tìì tɑ̃́píɛ̀tì ĩ́nkɛ̀, n nɔu sidɛ́. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Kɛ̀ nní nyóó tuɔkɛní kɛ sɔ̃́ ndi bùtínnɛ́ dɛndɛ bɑ̀mbɑ̀ nti Yiɛ̀ nKuyie nkùù di te kɛ mɑ fɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀ kɛ yóu kucɛ ti Yiɛ̀ nKuyie ndi bɛnkɛ kù. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Dɛ mɔ̀nnì kɛ̀ m pĩ́ ntitɑ̃́píɛ̀tì n nɔu sidɛ́ kɛ́ tì bɔ̀tɛ́ kɛtenkɛ̀ di ììkɛ̀, kɛ̀ tìi pɔntɛ pɔntɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Kɛ̀ n doroo kɛtenkɛ̀ ti Yiɛ̀ nKuyie nyììkɛ̀, kɛ́wɛ̃tɛ kɛ dɔ̀ yɛwe sipísìnɑ̀ɑ̀, dɛyènnɛ̀ sipísìnɑ̀ɑ̀ n yí yo, m mɛ nyí yɔ̃̀, mɛyɛi ndi dɔ̀ɔ̀ mɛ̀ kpɛ́í. Di cɑ̀ɑ̀rɛ̀mu dɛɛ̀ te kɛ̀ ti Yiɛ̀ nKuyie mmiɛkɛ di yɛ̀ mɛdiɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","N do yĩɛ̃̀kù ti Yiɛ̀ nKuyie mmiɛkɛ nkɛ, ku miɛkɛ kɛɛ̀ do cɔ̀útɛ́ kɛ̀ kù ndɔ́ kɛ́ di kuɔ pɑ́íí, kɛ̀ n kù bɑ̀ńtɛ̀ kɛ̀ kùu yie nkɛ́wɛ̃tɛ kɛ́cɔutɛ́ m bɑ́ɑmmu dɛ mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Kɛ̀ ku miɛkɛɛ pɛikɛ Anɔɔ mɛdiɛ̀ nkɛ̀ kù ndɔ́ kóò kùɔ, kɛ̀ n kù kuɔ́nnɛ̀ o kpɛ́í, ");
INSERT INTO tbzsim_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","kɛ́túótɛ́ fɛsɔɔmɑ́tìnɑ̀ɑ̀fɛ̀ di bùtínnɛ́ Kuyie nkɛ dɔ̀ɔ̀ fɛ̀, kɛ́ fɛ̀ cɔ̀ú nkɛ̀ fɛ̀ɛ cɔ́útɛ́, kɛ̀ n fɛ̀ pùɔ nkɛ́ fɛ̀ nɑ̀ɑ nkɛ̀ fɛ̀ɛ nɑɑ́ mmuyuo nkɛ̀ m mù ùtóo kukó nkùù bonní ditɑ̃rì ĩ́nkɛ̀ ku miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","Kɛ̀ ti mbo Tɑbedɑɑ nɛ̀ Mɑsɑ nɛ̀ Kibodoti-Atɑɑfɑ kɛ̀ di to íi ti Yiɛ̀ nKuyie mmiɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Kɛ̀ ti mbo Kɑdɛɛsi-Bɑnnɛɑ kɛ̀ ti Yiɛ̀ nKuyie ndi tɔ̃ nkɛ dɔ̀: Kɔtɛnɛ̀ kɛ́fietɛ dihɛì kù di duɔ́ ndì, kɛ̀ di í nyie nkɛ dò nti Yiɛ̀ nKuyie nkùù di te kù bɛ́i ntì bo dɔɔ̀, bɑ́ di í nyie nkù di nɑ̀kɛ́ tì. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","Nɛ̀ m bɑɑ di yɛ̃́mɛ̀ mmɛ, di í yie ndiyiè mɑrì ti Yiɛ̀ nKuyie nkpɛti. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Ti Yiɛ̀ nKuyie ndo tɑ̃ɑ̃tɛ́ kɛ bo di kuɔmu pɑ́íí, mɛm̀mɛ kɛ̀ n do kɛ nínkú ku ììkɛ̀ kɛ́nnínkú kɛ dɔ̀ yɛwe sipísìnɑ̀ɑ̀, dɛyènnɛ̀ sipísìnɑ̀ɑ̀, ");
INSERT INTO tbzsim_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","kɛ bɑ́ɑ́ nti Yiɛ̀ nKuyie nkɛ tú: Ti Yiɛ̀ nKuyie bɑ́ɑ́ kuɔ kubotí kuù nkù tu ɑ kɔku nku ɑ te kù. Nɛ̀ ɑ kó tikpetì miɛkɛ nkɛ ɑ bɛ̀ dɛɛtɛ́mɛ̀ nɛ̀ ɑ kó muwɛ̃rímú mmu ɑ bɛ̀ dènnɛnímɛ̀ Esibiti. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","Dentɛní ɑ kó bɛtɔ̃mbɛ̀ Abɑrɑhɑmmu nɛ̀ Isɑki nɛ̀ Sɑkɔbu bɛ kpɛ́í, ɑ bɑ́ ndɑkɛ kubotí kuu nkó itookperí kpɛ́í nnɛ̀ bɛ kó tidɔnnitì nɛ̀ bɛ̀ dɔ̀ɔ̀ri mɛ̀ɛ̀ yɛi. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","Kɑ̀ɑ dɔ̀ɔ̀ mɛmmɛ, ɑ ti dènnɛní dìì ɛì kɔbɛ bo yĩ́ fɔ̃́ nti Yiɛ̀ nKuyie nhɑ í nɑ kɛ bo ti tɑnnɛ́ dihɛì ɑ do yɛ̃ nhɑ yóó ti duɔ́ ndì. Bɛ̀ bo yĩ́ ɑ ti níímmu dɛɛ̀ kpɛ́í nte kɑ̀ɑ ti dènnɛní kɛ bo ti kuɔ dikpɑ́ɑ̀ tɛdɔntɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","N Yiɛ̀ nKuyie mbɛ̀ tu ɑ kɔbɛ mbɛ, fɔ̃́ɔ̃̀ bɛ̀ te, ɑ bɛ dɛɛtɛ́ nɛ̀ ɑ kó tikpetì nti nɛ̀ ɑ kó muwɛ̃rímú. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Kɛ̀ ti Yiɛ̀ nKuyie nni nnɑ́kɛ́ kɛ dɔ̀: Cíɛ́kɛ́ titɑ̃́píɛ̀tì tìdɛ́tì kɛ̀ tì ndò tiketitì, kɑ̀ɑ dekɛní ditɑ̃rì ĩ́nkɛ̀, ɑ́ nwɑɑ̀ nyidɛí kɛ́dɔɔ̀ ditɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","N yóó wɑ̃ri tinɑ́ɑǹtì tìì sòò bo tìnti tiketitì ɑ pɔ̀ntɛ tì ĩ́nkɛ̀, kɑ̀ɑ tì dɔú nditɔu miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Kɛ̀ n dɔɔ̀ ditɔu nɛ̀ dɛtekperɛ̀ kó idɛí kɛ́cíɛ́kɛ́ titɑ̃́píɛ̀tì tìdɛ́tì kɛ̀ tì ndònnɛ̀ tiketitì kɛ ntì tɔ tìdɛ́ kɛ́dekɛnɛ̀ ditɑ̃rì ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Kɛ̀ ti Yiɛ̀ nKuyie nwɑ̃ri dɛ kó titɑ̃́píɛ̀tì ĩ́nkɛ̀ kù do wɑ̃̀ri tìì nɑ́ɑǹtì tiketitì ĩ́nkɛ̀ kɛ́ tì nni nduɔ́. Ku tɑnnɔ̀ tɛpíítɛ̀ kù do di nɑ́ɑ́ nyɛ̀ ditɑ̃rì ĩ́nkɛ̀ kɛ̀ muhɑ̃ɑ̃́ ncɔ́ú nkɛ̀ di tíkú ditɑ̃rì pɛ̃ri. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Kɛ̀ n wɛ̃tɛ kɛ́cútɛ́ní ditɑ̃rì kɛ dɔú ndɛ kó titɑ̃́píɛ̀tì ditɔu n dɔ̀ɔ̀ dì miɛkɛ kɛ̀ tì dɛ mbo. Ti Yiɛ̀ nKuyie ndo n nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ ndòmmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Kɛ̀ Isidɑyɛɛribɛɛ ítɛ́ Bendee Yɑkɑnni kó sibií borɛ̀ kɛ́kɔtɛ Musedɑɑ. Anɔɔ dɛ nku kɛ̀ bɛ̀ɛ ò kũnnɛ́, kòo birɛ Edeɑsɑɑ sɔɔtɛ́ kɛ́ntú ikuɔ́ nìùtì. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Kɛ̀ bɛ̀ɛ ítɛ́ dɛborɛ̀ kɛ́kɔtɛ Kudikodɑɑ, kɛ́ítɛ́ dɛndɛ kɛ́kɔtɛ Yotibɑtɑ ikó mborɛ̀ pɛ́u. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Dɛǹdɛ ti Yiɛ̀ nKuyie ncɑ̃̀ńnɛ́mɛ̀ Defii kó kuwuɔ nkɔbɛ kɛ̀ bɛ̀ bo ntɔu ku tɑummɛ̀ tɔu kɛ́mbo ku cĩ́ɛ̃̀tɛ̀ kɛ pĩ́ nku tɔ̃mmú kɛ níí yú ti Yiɛ̀ nKuyie nyètìrì kɛ́pɑ̃ bɛnìtìbɛ̀ mɛsɑ̀ɑ̀. Bɛ̀ mɛ ndɔɔri nɛ̀ yíenní. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Dɛɛ̀ te kɛ̀ Defii kó kuwuɔ nkɔbɛ í mɔkɛ kɛtenkɛ̀ bɛ kɔbɛ dòmmɛ̀ bɛ kpɛrɛ tú bɛ̀ bo mpĩ́mmɛ̀ Kuyie ntɔ̃mmú, ti Yiɛ̀ nKuyie ndo tì mbɛ̀ nɑ̀kɛ́mɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Kɛ̀ m bɑɑ mbo ditɑ̃rì ĩ́nkɛ̀ n do kɛ bo mɛ̀ɛ̀ botí mɛketimɛ̀ mɔ̀nnì kɛ dɔ̀ yɛwe sipísìnɑ̀ɑ̀, dɛyènnɛ̀ sipísìnɑ̀ɑ̀ kɛ̀ ti Yiɛ̀ nKuyie nyíɛ́ kɛ́cɔutɛ́ m bɑ́ɑmmu kɛ́yóu, kɛ í ndi kùɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Kɛ̀ kù n nɑ́kɛ́ kɛ dɔ̀: Ítɛ́ kɛ́cútɛ́ kɛ́niitɛ́ n nìtìbɛ̀ kɛ́ bɛ̀ tɑnnɛ́ kɛtenkɛ̀ m bɛ́i nkɛ ĩkú kɛ yɛ̃ n yóó duɔ́ nkɛ̀ bɛ yɛmbɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Díndi Isidɑyɛɛribɛ ti Yiɛ̀ nKuyie nkùù di te kù dɔ́ dí dɔɔ̀ bɑ? Ti Yiɛ̀ nKuyie ndɔ́ tì tu: Onìtì fɔ̃́ nhɑ bo nkù démɛ̀, kɛ tũ nku kó kucɛ, kɛ́ nkù dɔ́ kɛ pĩ́ nku tɔ̃mmú nɛ̀ ɑ yɛ̀mmɛ̀ mɛmɔu nɛ̀ ɑ wɛ̃nnì dimɔu, ");
INSERT INTO tbzsim_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","kɛ́mpĩ́ nku kuɔ́ nɛ̀ ku tɑnnɔ̀ n di duɔ́ ndɛ̀ yíe, kɛ́mbo kɛ̀ dɛ̀ dɑ nɑɑti. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Ti Yiɛ̀ nKuyie nkuù bɑkɛ́ kɛĩ́nkɛ̀ nɛ̀ tiwɛtì, kɛ te kɛtenkɛ̀ nɛ̀ dɛ̀ɛ̀ kó dimɑ̀ɑ̀ bo kɛtenkɛ̀ ĩ́nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Kuù dɔkɛ di yɛmbɛ̀ kɛ bɛ̀ tɑunnɛ̀ kumɑ́ɑ̀ kɛ tɑ̃ɑ̃tɛ́ díndi bɛ yɑɑ̀bí ibotí imɔu miɛkɛ dɛ̀ mɛ̀ ndòmmɛ̀ yíe. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Ceetɛnɛ̀ di yɛ̀mmɛ̀ kɛ́duɔ́ ndimɑ́ɑ̀ ti Yiɛ̀ nKuyie nkɛ tɛ̃́nkɛ bɑ́ɑ́ kpénkùnnɛ di to. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Ti Yiɛ̀ nKuyie nkuù tu Kuyie nkɛ bɑkɛ́ dɛmɔu kɛ tú bɛkpɑ̀ɑ̀tìbɛ̀ kóo kpɑ̀ɑ̀tì kù dɛumu kɛ kpeńnì kɛ duò tikɔ̃m̀bùɔ̀tì kù í bɑɑ̀tì òmɔù kù í cɔú ticuuti. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","Kuù kommu iciribí nɛ̀ bɛkúpobɛ̀ kɛ dɔ́ bɛpɔ̀ɔ̀bɛ̀, kɛ bɛ̀ duɔ̀ ntidiitì nɛ̀ tiyɑ̀ɑ̀tì. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Dí ndɔ́ bɛpɔ̀ɔ̀bɛ̀ kɛ yɛ̃́ di do túmɛ̀ bɛpɔ̀ɔ̀bɛ̀ mbɛ Esibiti tenkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","Ti Yiɛ̀ nKuyie nku di yóó ndémɛ̀ kɛ pĩ́ nku tɔ̃mmú kɛ kù tɑunɛ̀, di níí yóó pɑrìkɛ̀nɛ̀ kunku. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Dí nkù sɑ̃ntí kuù di te, kuù dɔ̀ɔ̀ di cuokɛ̀ tidiɛtì tìì duò tikɔ̃m̀bùɔ̀tì kɛ̀ di tì yɑ̀ nɛ̀ di nuɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Di yɛmbɛ̀ do tɑti Esibiti kɛ bo sipísìyiekɛ̀ ndi, kɛ̀ ti Yiɛ̀ nKuyie nkùù di te kɛ̀ kù duɔ́ nkɛ̀ di sũ̀ṹ nsiwɑ̃̀ɑ̃ dòmmɛ̀ tiwɛtì. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","Dí ndɔ́ ti Yiɛ̀ nKuyie nkùù di te kɛ́ nkù tũ nkɛ dɔɔri ku kuɔ́ nɛ̀ ku tié nnɛ̀ ku tɑnnɔ̀ dɛ̀ yɛ̃ mmù yɛwe yɛmɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Di mɔ́mmɔmbɛ di yɑ̀mu nɛ̀ di nuɔ ti Yiɛ̀ nKuyie nkùù di te kù dɛumɛ̀ kɛ kpeńnì nɛ̀ kù pĩ mmùù tɔ̃mmú Esibiti tenkɛ̀, dɛ̀ í tú di bí. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","Di yɑ̀mu yɛbɛnkùyɛ̀ kù dɔ̀ɔ̀ yɛ̀ Esibiti kó kɛtenkɛ̀ miɛkɛ nɛ̀ ku dɔ̀ɔ̀ dɛ̀ Esibiti kóo kpɑ̀ɑ̀tì nɛ̀ o kɔbɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","Kɛ yɑ̀ kù dɔ̀ɔ̀ dɛ̀ Esibiti kó dihɑ̃ɑ̃pɔ̀ntĩ̀nnì dìì do di bɛtì nɛ̀ bɛ sɛ̃ĩ́ nɛ̀ bɛ kpɑ̀rìnɑɑsɛ̃ĩ́, kɛ yɑ̀ kù duɔ́mmɛ̀ kɛ̀ dɑ̀mɛ́ɛ̀rì tipèntì kou kó mɛniɛ mbɛ̀ dɑ̀tínnɛ́, kɛ bɛ̀ pɔ̃ntɛ́nɛ̀, kɛ bɛ̀ kùɔ kɛ̀ dɛ̀ dèè. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Di yɛ̃́mu kù dɔ̀ɔ̀ dɛ̀ di kpɛ́í ndikpɑ́ɑ̀ tɛdɔntɛ̀ miɛkɛ kɛ̀ di nɑ kɛ tùɔ̀kɛnɛ̀ní diɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","Di í biinnìnɛ̀ kù dɔ̀ɔ̀ dɛ̀ Dubɛnni botí kou Ediɑbu kó ibí idɛ́ Dɑtɑnni nɛ̀ Abidɑmmu, kɛtenkɛ̀ ɑ̀ɑtɛmɛ̀ kɛ bɛ̀ mɑɑnko Isidɑyɛɛribɛ bɛmɔu nuɔ mmiɛkɛ, bɛmbɛ nɛ̀ bɛ cɛ̃́ĩ kɔbɛ nɛ̀ bɛ touti nɛ̀ bɛnìtìbɛ̀ bɛ̀ɛ̀ kó dimɑ̀ɑ̀ do tũ mbɛ fɔ̃nkúò. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Di yɑ̀mu nɛ̀ di nuɔ nti Yiɛ̀ nKuyie mpĩ mmùù tɔ̃mmú diɛmù. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Dí mpĩ́ nku tɑnnɔ̀ m mɛ ndi duɔ́ nyɛ̀ yíe nyɛmɔu, mɛm̀mɛ di bo mmɔkɛmɛ̀ dikɔ̃m̀bùɔ̀ kɛ́kɔtɛ kɛ́cɔutɛ́ kɛtenkɛ̀ di kɔri kɛ bo tɑ kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","Kɛ̀ di dɔ̀ɔ̀ mɛmmɛ di bo mbo kɛ́mɔntɛ kɛtenkɛ̀ ti Yiɛ̀ nKuyie ndo bɛ́i nkɛ́ĩkú kɛ yɛ̃ nkù bo duɔ́ nkɛ̀ di yɛmbɛ̀ nɛ̀ bɛ yɑɑ̀bío, mɛcekùɔ̀ nnɛ̀ mɛnɑɑmiɛ̀ ndɛ̀ pũɔ̃̀ nkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Di tɑti kɛ̀ɛ̀ tenkɛ̀ kɛ̀ í dònnɛ̀ Esibiti dòmmɛ̀, kɛ̀ di níí bo buɔtí kupɑku, kɛ́dɑmmú kukó nkɛ́yṹɔ̃́nní mɛniɛ nkɛ́nyɔ́ɔ̀rì, bɛ̀ ɔ̃ nyɔ́ɔ́rì mɛ̀ɛ̀ botí kukũmpɑku. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Di kɔri kɛ bo tɑ kɛ̀ɛ̀ tenkɛ̀ tu yɛtɑ̃rɛ̀ nɛ̀ tibiti kó kɛtenkɛ̀ nkɛ kɛ̀ fɛtɑɑfɛ̀ nìu, ");
INSERT INTO tbzsim_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","ti Yiɛ̀ nKuyie nkùù di te kù dɑ̀kɛmu dɛ kó kɛtenkɛ̀ kpɛ́í, ku nɔ̀nfɛ̀ í iiti dɛ kó kɛtenkɛ̀ ĩ́nkɛ̀, dibenni bo ketɛ́mɛ̀ nɛ̀ di bo deèmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Bɑ́ wè kòò yie nkɛ tũ n di duɔ́ nyɛ̀ɛ̀ tɑnnɔ̀ yíe kɛ dɔ́ Kuyie nkɛ pĩ́ nku tɔ̃mmú nɛ̀ o yɛ̀mmɛ̀ mɛmɔu nɛ̀ o wɛ̃nnì dimɔu. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","Kù bo ndi duɔ̀ nfɛtɑɑfɛ̀ fɛ mɔ̀nnì fɛĩ́nkɛ̀mbóntɑɑfɛ̀ kɛ́ntɔ kɛ tuɔkɛnɛ̀ fɛtɑdentifɛ̀, kɛ̀ di pɑɑ nní mpɛí dɛtie mbɛ̀ tu dɛ̀ fínyĩ̀ nɛ̀ bɛ̀ tu dɛ̀ fìkíè kɛ̀ dɛ̀ mpɛí, kɛ mɛnɑɑ̀ mpɑ̀mmɛ̀ɛ buotɛ́ nɛ̀ mɛkùɔ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","Kù bo ndènnimuní timútì di pɑɑ nkɛ̀ di wũɔ̃ nyo nkɛ̀ di nyo nkɛ sɑ̀nnɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Dɛ mɔ̀nnì di nɛ́ ndɑkɛ kɛ bɑ́ɑ́ bútínnɛ́ ku kó kucɛ, kɛ bɑ́ɑ́ tũnnɛ yɛbɔkɛ̀ kɛ́nkɔ̃nkù yɛ ììkɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Kɛ̀ di dɔ̀ɔ̀ mɛmmɛ ti Yiɛ̀ nKuyie mmiɛkɛ bo di yɛ̀ kɛ̀ kùu kpetínnɛ́ iwɛtibori bɑ́ fɛtɑɑfɛ̀ tɛ̃́nkɛ bɑ́ nniu, tidiitì tɛ̃́nkɛ bɑ́ mpɛí, bɑ́ di bɑ́ɑ́ ɔɔtɛ di bo kúmɛ̀ kɛtensɑ̀ɑ̀kɛ̀ ti Yiɛ̀ nKuyie ndi duɔ́ nkɛ̀ miɛkɛ. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Dí ɑ̃nnɛ́ Kuyie nnɑ́ɑǹtì di yɛ̀mmɛ̀ miɛkɛ kɛ̀ tìi tɑ di wɛ̃rɛ̀, di ntì ũ di nɔu tɛnɛitɛ kɔ̃mɛ kɛ́ ntì ìrí bɛ̀ ɔ̃ nyírímɛ̀ kuítùòkù. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","Dí nti tiè ndi bí di borɛ̀ tɛcĩ́ɛ̃̀tɛ̀, nɛ̀ di borɛ̀ kupɔ̀ɔ̀kù di yóó duɔ́ dìì mɔ̀nnì nɛ̀ di èntɛ dìì mɔ̀nnì. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","Dí tì wɑ̃̀ri di cɛ̃́ĩ kó yɛsɑ̃ǹkɛ̀ nɛ̀ yɛbòrɛ̀, nɛ̀ dihɛì kó dibòrì. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","Kɛ̀ di dɔ̀ɔ̀ mɛmmɛ díndi nɛ̀ di bí di bo nfòù kɛ́mɔntɛ kɛtenkɛ̀ ti Yiɛ̀ nKuyie ndo bɛ́i nkɛ́ĩkú kɛ́nyɛ̃ nkù yóó duɔ́ nkɛ̀ di yɛmbɛ̀ kɛ̀ dí nkɛ̀ te sɑ̃́ɑ̃̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Kɛ̀ di pĩ́ nweti weti yɛtɑnnɔ̀ kù di duɔ́ nyɛ̀ kɛ dɔɔri yɛ̀ yɛ̃ mmù kɛ dɔ́ ti Yiɛ̀ nKuyie nkùù di te kɛ tũ nku kó kucɛ kɛ kù tɑunnɛ̀ dimɑ́ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","Dɛ mɔ̀nnì kù bo nni kɛ bɛtì iwuɔ ndiɛyì imɔu ìì kpeńnì kɛ di pɛ̃ɛ̃tɛ́, kɛ̀ di tiekɛ i ɛkɛ̀ kɛ́kɑri, ");
INSERT INTO tbzsim_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","di nɑɑ̀cɛ̀tɛ̀ bo nɑ kɛ̀ɛ̀ tenkɛ̀ kó dimɑ̀ɑ̀ yo ntú di kɔkɛ nkɛ, kɛ́túótɛ́ dikpɑ́ɑ̀ tɛdɔntɛ̀ kpɛri kubɑkù cɑ̃̀nku bíɛ́kɛ̀ kɛ́kɔtɛ kɛ́dítɛ́ Dimɑɑ tɑ̃rì kubɑkù yoú bíɛ́kɛ̀ kɛ́ntɔ kɛ́tuɔkɛ kukó ndiɛkù Efɑdɑti diyiè yìɛ̀ní kɛ̀ɛ̀ bíɛ́kɛ̀, kɛ́ntɔ kɛ́tuɔkɛ dɑ̀mɛ́ɛ̀rì Mɛditedɑndee diyiè tɑɑ̀ kɛ̀ɛ̀ bíɛ́kɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Di nɑɑ̀cɛ̀tɛ̀ bo nɑ kɛ̀ɛ̀ tenkɛ̀ kó dimɑ̀ɑ̀ òmɔù bɑ́ɑ́ dɑ́ɑ́tí kɛ́ di bɑɑo. Kuyie mbo duɔ́ nkɛ̀ bɛ̀ ndi dé kɛ̀ bɛ kɔ̃m̀bùɔ̀tì ndi duò Kuyie nti ndi nɑ̀kɛ́ kɛ yɛ̃ ndɛ̀ yó ndònmɛ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","N di pɑ̃mu yíe nkucɛ, tɑ̃ɑ̃tɛ́nɛ̀ mɛsɑ̀ɑ̀ nyoo mɛyɛi, ");
INSERT INTO tbzsim_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Kɛ̀ di yie ti Yiɛ̀ nKuyie nkùù di te ku tɑnnɔ̀ kù di duɔ́ nyɛ̀ yíe, kù bo di pɑ̃ mɛsɑ̀ɑ̀. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Kɛ̀ di mɛ nyɛ̀ yetɛ kɛ bùtínnɛ́ ku kó kucɛ kɛ tũ̀nnɛ yɛbɔkɛ̀ di do í yɛ̃́ yɛ̀, di bo yɑ̀ mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Kɛ̀ ti Yiɛ̀ nKuyie nkùù di te kù di tɑnnɛ́ dìì mɔ̀nnì kɛtenkɛ̀ di yóó tiekɛ kɛ̀, dí dekɛ ditɑ̃rì Kɑrisimmu kɛ́pĩɛ̃kɛ́ ku kó mɛsɑ̀ɑ̀, kɛ́dekɛ ditɑ̃rì Ebɑɑdi kɛ́pĩɛ̃kɛ́ mɛyɛi. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Dɛ kó yɛtɑ̃rɛ̀ bo kukó nSuditɛ̃ɛ̃ yɑ́ɑ̀ ndi diyiè tɑɑ̀ kɛ̀ɛ̀ bíɛ́kɛ̀. Dɛ kó kucɛ kuù yìɛ̀nɛ̀ Kɑnnɑhɑ̃ɑ̃ kɔbɛ kó kɛtenkɛ̀, tɛdɔntɛ̀ kó dikpɑ́ɑ̀ Adɑbɑ bo kukó nSuditɛ̃ɛ̃ kó kubiriku nku, kɛ tɔ́kɛ́nɛ̀ kutieku sɑ̀ɑ̀kù Mɔdee kɛ wetí Kidikɑɑdi. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","Di yóó séntɛ́mu kukó nSuditɛ̃ɛ̃ kɛ́kɔtɛ kɛ́tɑ kɛtenkɛ̀ ti Yiɛ̀ nKuyie nkùù di te kù di duɔ́ nkɛ̀ kɛ́ kɛ̀ fìètɛ kɛ́kɑri. ");
INSERT INTO tbzsim_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","Dí ndɑkɛ kɛ́ndɔɔri Kuyie nkuɔ́ imɔu nɛ̀ ku tɑnnɔ̀ yɛmɔu n di duɔ̀ ndɛ̀ yíe ndɛ̀ yɛ̃ mmù. ");
INSERT INTO tbzsim_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Ntɛnɛ̀ ti Yiɛ̀ nKuyie nkuɔ́ nɛ̀ itié ndi yó ndɑkɛ dɛ̀ɛ̀ kpɛ́í, kɛ́ndɔɔri dɛ yɛ̃ mmù di fòmmu mumɔu miɛkɛ, kɛtenkɛ̀ ti Yiɛ̀ nKuyie ndi yɛmbɛ̀ do tũ nkù di duɔ́ nkɛ̀ kɛ̀ di bo kɑri. ");
INSERT INTO tbzsim_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","Dí puɔ nyɛwũɔ̃tɔ̀rɛ̀ nɛ̀ yɛtɔrɛ̀ di yóó bɛti ìì wuɔ nkɔbɛ do feu yɛ̀ yɛtɑ̃rɛ̀ nɛ̀ sitɑ̃ɑ̃́ dɛ ĩ́nkɛ̀ nɛ̀ dɛtie nyɔ. ");
INSERT INTO tbzsim_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","Di puɔ mbɛ wũɔ̃tɔ̀rɛ̀ kɛ́bɔ́kɛ́ bɛ bɔɔtɑ̃́rɛ̀ kɛ́cɔ́u mbɛ bɔɔ̀ Asedɑɑ kó kutedɔú, kɛ́puɔ nsitenkɑɑnìi kɛ̀ bɛ̀ tɛ̃́nkɛ bɑ́ nnɑ́ɑ́ nsi kpɛ́í dɛ kó dibòrì. ");
INSERT INTO tbzsim_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","Dí bɑ́ɑ́ tekɛ́ dɛ kó ibotí bɑ́ɑ́ mmɛ̀ɛ̀ botí i kó yɛbɔkɛ̀ kɛ́ mmɛ mbɑ́ɑ́ n