﻿USE sofia;
DROP TABLE IF EXISTS sofia.tbx_vpl;
CREATE TABLE tbx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES tbx_vpl WRITE;
INSERT INTO tbx_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kilisi buyeiw leind wei yeip eivek qapiya eno inye eivek velei wei Dawit o, de Dawit on eivek velei wei Apraham o. ");
INSERT INTO tbx_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apraham on Isaka ma, de Isaka yon Yakop ma, de Yakop on Yuda ma me liyeiw is, ");
INSERT INTO tbx_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuda yon Peres aluw Sela mend, de luw tend lei Tamar, de Peres on Hesron ma, de Hesron on Ram ma, ");
INSERT INTO tbx_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram on Aminadap ma, de Aminadap on Nason ma, de Nason on Salmon ma, ");
INSERT INTO tbx_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon on Boas ma de ta lei Rahap, de Boas on Obet ma de ta lei Rut, de Obet on Jesi ma, ");
INSERT INTO tbx_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","de Jesi yon king Dawit ma. De Dawit on Salomo ma, e tiwei ta Yuria venei yo, ");
INSERT INTO tbx_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo yon Rehoboam ma, de Rehoboam on Abiya ma, de Abiya yon Asa ma, ");
INSERT INTO tbx_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa yon Jehosapat ma, de Jehosapat on Jehoram ma, de Jehoram on Usia ma, ");
INSERT INTO tbx_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia yon Jotam ma, de Jotam on Ahas ma, de Ahas on Hesekia ma. ");
INSERT INTO tbx_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekia yon Manase ma, de Manase yon Amon ma, de Amon on Yosia ma. ");
INSERT INTO tbx_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","De Yosia yon Jekonaia ma me moxo lis liyeiw mindei gyeik xel Babilon lam wo vevek me zeimaxoun xel Israel de qou xel me la Babilon. ");
INSERT INTO tbx_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ka xel la Babilon: Woyom Jekonaia yon Seatiel ma, de Seatiel on Serubabel ma. ");
INSERT INTO tbx_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","De Serubabel on Abiut ma, de Abiut on Eliakim ma, de Eliakim on Aso ma. ");
INSERT INTO tbx_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","De Aso yon Sadok ma, de Sadok on Akim ma, de Akim on Eliut ma, ");
INSERT INTO tbx_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","de Eliut on Eliesa ma, de Eliesa yon Matan ma, de Matan on Yakop ma. ");
INSERT INTO tbx_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","De Yakop on Yosep ma, de Yosep on Maria leya, Maria wei qou Yesu wei xel mi taxe bei Kilisi yo, moux on Anutu beyal bei e qou moux alis vex wei e yo noum. ");
INSERT INTO tbx_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Inyon nambei 14 neumambu wei Apraham me ela Dawit o, de 14 neumambu nanghei Dawit me ela tyip ingwei xel la xeitueing anghei Babilon o, deka xel la xeitueing anghei Babilon eno 14 neumambu me ela tyip wou bouk wei Yesu Kilisi yo. ");
INSERT INTO tbx_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tine inye pavulek en ingwei Yesu Kilisi umbek o: Moxo ta Maria eno xel beyal bei e mendei wou Yosep, luw se ghei dei lekti ekom vexo xei qou veil en Laweeng Vambuing nikanzek. ");
INSERT INTO tbx_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maria leya Yosep on tambiy wei bombek om embei se bong niyalenyeing wou vexo eivek xel moux alis vex dalus mend, om embei na veil e xupekeing. ");
INSERT INTO tbx_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ekom Yosep nanghei di wounalei en tine, Tambiy Ngandoung xe angela lam wou e eivek maviing me neil, “Yosep wa velei wei Dawit o, wa seng gwaleeng qe wa qou Maria nambei veneim, en yak tiwei tumi eivek e yon inye lam wou Laweeng Vambuing. ");
INSERT INTO tbx_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tyek vexo bou neu moux ti, yond wa taxe e lei bei Yesu, en tyek devind e xe xel veil xel xe sewokeing.” ");
INSERT INTO tbx_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Lul dalus tine la teyei lek ambei ingwei Tambiy Ngandoung neil eivek poropet mya yo: ");
INSERT INTO tbx_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wei, vexawo wei paleveeng o ti tyek xei qou veil me bou neu moux ti, de tyek xel taxe e bei Imanuel.” Qes ambei nye, “Anutu toundei is xey.” ");
INSERT INTO tbx_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ka Yosep qandi lek de moxo wong ambei kawei Tambiy Ngandoung xe angela neil wou e yo, me qou Maria nambei e venei. ");
INSERT INTO tbx_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ekom moxo se yeip is e qe ka Maria qou neu moux woy le. De moxo taxe neu lei Yesu. ");
INSERT INTO tbx_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ka Yesu umbek eivek Betelem wei Yudia nei, eivek bouk wei king Herot eno xel lundpeyei wei mendalus wei mi yei dee lek betum eno lam anghei ninei me lam Yerusalem ");
INSERT INTO tbx_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","me teling, “Tambiy tiwei umbek ambei king wei Yudayeiw eno toundei inya? Xa xei e xe betum anghei ninei me na lam en xa bei bong lalo wou e.” ");
INSERT INTO tbx_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herot ngo qayeeng tine eno moxo is xel Yerusalem dalus wounaleind ngenong. ");
INSERT INTO tbx_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Woyom moxo taxe xel lumuki leitata me xel putoung wei petieing wei xomaxoneing dalus o, moxo teling wou xel bei Kilisi tyek dumbek anghei inya? ");
INSERT INTO tbx_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xel neil elox, “Eivek Betelem wei Yudia nei, en inye qayeeng vati wei poropet byex takwei yo: ");
INSERT INTO tbx_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Ekom Betelem wang eivek tembuing danghei wei Yuda yo wa leim se nayak en beyeeng leilaing wei Yuda yo, en eivek wang eno tyek wa xe tambiy ti bong ambei wa xe leilaing me tyek mendei bei gyovaxa wei a xe xomaxoneing wei Israel o.’” ");
INSERT INTO tbx_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Woyom Herot taxe xel lundpeyei wei mendalus o xupekeing me ngo teyei wou xel bei lek bouk vati eno betum lam nale. ");
INSERT INTO tbx_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Moxo wong xel la Betelem me neil, “Xam la me wimexe e wo nimza en yak on. Ka xam ghe gweiwou e, xam ghe bong qayeeng nam wou ay, en kandek ana bong lalo wou e is.” ");
INSERT INTO tbx_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ka xel ngo king xe qayeeng woy, xel la wou sakwaing no me la, me betum wei xel yei ghei ninei eno la tax en xel, dekalekom la nale ghey lek beyeeng kawei yak on toundei ghei yo. ");
INSERT INTO tbx_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Gyeik xel yei betum eno xel wo xeindlala ngandoung. ");
INSERT INTO tbx_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Xel la eivek xomek lalei me yei yak on is ta Maria, de xel ev vaxend qatu eivek dom wo lalo wou e. Woyom xel tax xel xe vaxak malew dom wong ghol, me xax myalouk, me xax myalouk nge wei mi wo xeimangou yo la wou e. ");
INSERT INTO tbx_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","De Anutu peti xel eivek maviing bei xel se nox wou Herot, qe xel na nox sakwaing ba me nox bend. ");
INSERT INTO tbx_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ka xel lundpeyei wei mendalus la veil, Tambiy Ngandoung xe angela lam wou Yosep eivek maviing. Me neil, “Qandi lek me qou yak on aluw ta me pek me la Izip. Xam a mi mendei inyon deka a neil wou wang bole, en Herot di yimexe yak on en embei nyeis e mey.” ");
INSERT INTO tbx_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Om moxo qandi lek, me qou yak on aluw ta me la eivek boukeing me la Izip, ");
INSERT INTO tbx_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","de moxo mindei inyon deka Herot mey le. Me lul tine la teyei lek ambei Tambiy Ngandoung neil eivek poropet mya yo. “A taxe neung moux bei e nam veil Izip.” ");
INSERT INTO tbx_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Gyeik Herot woulek bei xel wei lundpeyei wei ninei eno tyoxe e, moxo lalei wo vanei mouyo, om wong qayeeng nikanzek bei xel nyeis xel yak moux dalus eivek Betelem me xel yak wei beyeeng paviyeing wei xel xe vakovek qes yuw o me e teiloum axo, teyei lek bouk wei e ngo wou xel lundpeyei wei ninei yo. ");
INSERT INTO tbx_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Woyom lul tine la teyei lek ambei Anutu neil eivek poropet Yelemia mya yo. ");
INSERT INTO tbx_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Vya ti eno xel ngo eivek beyeeng Rama, inyon engeing me talot ngandoung, Resel di eng en neuyeiw dalus mey, me vexo embei xel se bong e lalei bo nimza, en nambei neuyeiw dalus mey de ti se toundei mapieing.” ");
INSERT INTO tbx_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ka Herot mey woy eno Tambiy Ngandoung xe angela ti lam wou Yosep eivek maviing nanghei Izip ");
INSERT INTO tbx_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","de neil, “Qandi lek, me qou yak on aluw ta me lox me la tembuing wei Israel nei, en xel wei embei nyeis yak on na mey eno mey.” ");
INSERT INTO tbx_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Om moxo qandi lek me qou yak on aluw ta me lal lox me la tembuing wei Israel o. ");
INSERT INTO tbx_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ekom e ngo bei Arkelaus yeiteyei Yudia eivek ma Herot nimbeeng, om moxo yaleeng en embei se na inyon. Ekom Anutu neil wou Yosep eivek maviing ti, om moxo la distrik Galili, ");
INSERT INTO tbx_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","me la dei eivek beyeeng wei xel mi taxe bei Nasaret. Om tine la teyei lek ambei ingwei neil eivek poropet myend o. “Tyek xel taxe e bei tambiy wei Nasaret o.” ");
INSERT INTO tbx_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Eivek bouk ti beimambei yon eno Yoan lipekeing lam, moxo neil qayeeng eivek tembuing bandaing wei Yudia nei ");
INSERT INTO tbx_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","me neil, “Xam pekwi xow, en tete lalei wei tyoung gheyapu eno lam paviy.” ");
INSERT INTO tbx_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tambiy tine inye tiwei Anutu luk en e eivek poropet Yesaya mya yo: “Tambiy ti vya taxe lam anghei tembuing bandaing nei, ‘Menyex wou sakwaing en Tambiy Ngandoung, wong sakwaing on wo bombek en e.’” ");
INSERT INTO tbx_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yoan xe teimb on xel duw angya leliy kamel nivlus, me mi vex let wei xel duw en leliy ninavi yo vivekwou xeikatu. E xeeng yaeing on zevak me beyexta nilouk wei qeis lalei yo. ");
INSERT INTO tbx_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Xomaxoneing nanghei Yerusalem me nanghei Yudia tambak nei me danghei dalus wei memiing Yorodan vi eno xel lam wou e. ");
INSERT INTO tbx_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Xel neil xel xe sewokeing teyei, de Yoan lipek xel eivek memiing Yorodan. ");
INSERT INTO tbx_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ekom moxo yei xel ngenong wei Parisi me Sadyusi lam en embei qou lipekeing, moxo neil wou xel: “Xam on myeiy nilul neu! Eti neil wou xam bei tyek xam a pek me ghe na veil Anutu lalei vanei wei di lam o? ");
INSERT INTO tbx_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wangwei xam pekwi xow neing nei yon kwa wei xam eno talex lek bei xam ghe pekwi xow. ");
INSERT INTO tbx_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","De xam seng boueivek naleimim me na neil wou venaxow bei, ‘Xa mami Apraham.’ A neil wou xam bei Anutu teyei bei bong qakous beimambei ne qandi lek me ghok ambei Apraham neuyeiw. ");
INSERT INTO tbx_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Qov di yeip wou xax qes woy, om xax tambak wei se mi vuk neing nimza eno tyek xel buv veil me banex ena eivek nenyex. ");
INSERT INTO tbx_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“A lipek xam en memiing bei xam pekwi xow. Ekom Tambiy tiwei tyek nam yus en ay eno e nikanzek ghanaw a veil, a se nimza teyei bei qalei e xe vaxalambes. Moxo tyek zipek xam en Laweeng Vambuing me nenyex is. ");
INSERT INTO tbx_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Moxo zeim taliv eivek mema, en embei seyex wit en beyal myapapu veil wit neing, de qekuwou me na toung eivek xomek yaeing, ekom moxo tyek banyuw myapapu lek nenyex wei se mi mey yo.” ");
INSERT INTO tbx_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Woyom Yesu lam anghei Galili me la Yorodan bei Yoan zipek e. ");
INSERT INTO tbx_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ekom Yoan embei paseisexe e me neil, “Teyei bei a qou lipekeing wou wang, nambei nya wang lam wou ay?” ");
INSERT INTO tbx_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yesu neil elox, “Embong ondek wang bong ambei a neil ne, eivek kwa nimza tine uw teyei bei bong sakwaing dalus embo bombek.” Om Yoan betiwou e xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ka Yesu lipek woy, moxo lek lam veil memiing. Gyeik kayon bombek eno tyoung gheyapu tax, de moxo yei Anutu xe Laweeng Vambuing lam ambei menek beliy me dei lek e. ");
INSERT INTO tbx_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Vya ti lam anghei tyoung gheyapu nei me neil, “Tine inye a Neung Moux, wei a laleing vind o. A laleing wo xeilala en e.” ");
INSERT INTO tbx_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Woyom Laweeng Vambuing qou Yesu me la tembuing bandaing nei bei tambiy mapetok bo axeing wou e. ");
INSERT INTO tbx_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu vambu yaeing teyei lek bendiyeing mepyeiyuw me boukeing mepyeiyuw is om maxepya e. ");
INSERT INTO tbx_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tambiy mapetok wei mi wo axeing eno lam wou e me neil, “Wangwei wa Anutu Neu Moux, ond neil me qakous ti beimambei ne pekwi nambei belet.” ");
INSERT INTO tbx_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu neil elox, “Xel byex eivek xoulek eno nambei nye: ‘Xomaxoneing se mindei mapieing en belet venaxow, qe xel mi dei mapieing en qayeeng tambak wei mi lam eivek Anutu mya yo.’ ” ");
INSERT INTO tbx_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Woyom tambiy mapetok qou e me la beyeeng vambuing Yerusalem me wong e nale lek xomek vambuing on pundanghou. ");
INSERT INTO tbx_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Moxo neil, “Wangwei wang on Anutu Neu Moux ond vyeip me la tembuing. En xel byex eivek xoulek eno nambei nye, “‘Moxo tyek bong qayeeng nikanzek wou e xe angela en xel gyeiteyei wang, me tyek xel a zeim wang zekna eivek memend, en kandek qakous ti se byex wa vaxam.’ ” ");
INSERT INTO tbx_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu neil elox wou e, “Inyon xel byex eivek xoulek is bei: ‘Wa se toung wa xe Tambiy Ngandoung Anutu eivek axeing.’” ");
INSERT INTO tbx_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Kalekom tambiy mapetok qou e me la lek lukendu vaxading. De talex tete lalei wei tembuing sapa me lulul nimzamza dalus eno wou e. ");
INSERT INTO tbx_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","E neil, “Wangwei wang dev vaxam qatu eivek me ghe bong lalo wou a nei on tyek am bong lul dalus tine wou wang.” ");
INSERT INTO tbx_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ekom Yesu neil wou e, “Sandang, la dingta veil ay! En xel byex eivek xoulek eno nambei nye, ‘Wang bong lalo wou Tambiy Ngandoung wa xe Anutu me ghe bong xuk wou e venaxow.’ ” ");
INSERT INTO tbx_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Woyom tambiy mapetok la veil e, dom angela lam me vind e. ");
INSERT INTO tbx_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ka Yesu ngo bei xel toung Yoan eivek xeitueing, moxo lox me la Galili. ");
INSERT INTO tbx_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","De la veil Nasaret, me la dei eivek Kapenaom, wei di yeip wou lounyeing Galili vi yo, eivek tembuing wei Sebulon me Naptali. ");
INSERT INTO tbx_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Eivek kwa tine eno Yesu wong e la teyei lek ambei qayeeng wei Anutu neil eivek poropet Yesaya mya yo: ");
INSERT INTO tbx_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Tembuing wei Sebulon me tembuing wei Naptali, eno di yeip wou lounyeing vi, me la valu wei Yorodan nei, me tembuing wei Galili wei xel amba lam dei lek o. ");
INSERT INTO tbx_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Om xomaxoneing wei mindei eivek mapetok ngandoung eno yei xeiyaing ngandoung ti. Me xel wei mindei eivek mapetok eno xeiyaing byex la lek xel.” ");
INSERT INTO tbx_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lek bouk tiyon eno Yesu neil qayeeng atax wou xel, “Xam pekwi xow, en tete lalei wei tyoung gheyapu eno lam paviy.” ");
INSERT INTO tbx_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Bouk ti eno Yesu la ghavineeng wou lounyeing Galili nenyawes, yei tambiy yayuw wei lindama yo, inyon Simon xel mi taxe bei Petele luw li Andrias. Luw di nex lewek eivek lounyeing, en nambei xel on ingwei mi qou woing o. ");
INSERT INTO tbx_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Woyom Yesu neil, “Muw lam me betiwou ay, en tyek a bong muw a qou xomaxoneing nambei muw ghe mi qou woing o.” ");
INSERT INTO tbx_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Lutika eno luw ghanaw luw xe lewek dom betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesu la no, me yei tambiy yayuw inyon Jems wei Sebedi neu moux me li Yoan. Luw toundei eivek bot is ma teiv Sebedi, me di menyex wou lal xe lewek. Woyom Yesu taxe la wou luw. ");
INSERT INTO tbx_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Se wo lululek en luw ghanaw luw xe bot me ma teiv dom betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu la ghavineeng eivek Galili tambak, me di teyoxe xel eivek xomek qekueing ama wei Yudayeiw o, me moxo di neil Xoulek Nimza wei tete lalei, me wong xel wei vanei leimalei eno wo nimzalek eivek xel xomaxoneing on senghoing. ");
INSERT INTO tbx_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Yesu xe pavulek la wo sapa eivek Siria, me xomaxoneing qou xel dalus wei vanei leimalei wong xel o me lam wou e, eti yeiw wei vanei nilul is vanei ngandoung, me laweeng nilul dei eivek xel me xel wei vanei wei nietekeing mi wong xel mi pewilexe lek tembuing me xel wei kanzek mey eno Yesu wong xel wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Xel qendu ngandoung wei betiy e eno lam anghei Galili me Dekapolis, me Yerusalem, me Yudia me Yorodan loxalu nei. ");
INSERT INTO tbx_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu yei xel qendu ngandoung on lam, om moxo lek la lukendu nenyawes. Ka e la dei, e xe xel betiyeing lam wou e. ");
INSERT INTO tbx_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Om moxo teyoxe wou xel me neil, ");
INSERT INTO tbx_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Anutu bo mata wou xel wei woulek bei xel kanyo eivek nund laweeng o, en tete lalei wei tyoung gheyapu eno inyon xel xe. ");
INSERT INTO tbx_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Anutu wong mata la wou eti yeiw wei mi wo talot o, en tyek bo xel laleind vevop. ");
INSERT INTO tbx_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Anutu wong mata la wou eti yeiw wei mi beoux xow o, en tyek bong tembuing tambak wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Anutu wong mata la wou eti yeiw wei mindei maxep me kwend mi tip en sakwaing bombek o, en tyek bong e na teyei lek wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Anutu wong mata la wou eti yeiw wei lalei pyaweing o en tyek talex lalei pyaweing wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Anutu wong mata la wou eti yeiw wei laleind wo vako yo, en tyek xel gyei Anutu. ");
INSERT INTO tbx_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Anutu bo mata wou eti yeiw wei mi leis qayeeng mey me wo lalei vevopeing wou xomaxoneing o, en tyek xel taxe xel bei Anutu neuyeiw. ");
INSERT INTO tbx_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Anutu bo mata wou eti yeiw wei mi qou nimaying en sakwaing bombek o, en tete lalei wei tyoung gheyapu eno inyon xel xe. ");
INSERT INTO tbx_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Anutu bo mata wou xam gyeik xel xomaxoneing embei bo nol wou xam o me na neil qayeeng nilul lek xam, me bo nimaying me tyonyeing lek xam me na neil qayeeng leimalei dalus wei nilul o lek xam en xam ghe mi betiwou ay. ");
INSERT INTO tbx_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Xam laleimim embo nimza me ghe bong xeimimlala, en xam xe xouveing ngandoung toundei eivek tyoung gheyapu, en eivek sakwaing ambei nyon eno xel wo nimaying wou xel poropet eti yeiw wei la tax en xam o. ");
INSERT INTO tbx_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Xam on nambei mileeng wei tembuing o. Ekom wangwei nenyeing wei mileeng on na ma, on tyek xam ghe bong vati wou me mileeng enox bong nenyeing no? Inyon tyek se nox bo nimza no, om xam banex ena myayaing me xel xomaxoneing bakei lek. ");
INSERT INTO tbx_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Xam on xeiyaing wei tembuing sapa yo. Beyeeng ngandoung wei toukale lek qetyei eno se teyei bei ghupek. ");
INSERT INTO tbx_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Xomaxoneing se mi byex eivek lam me toung ela xeinghembi eivek dipek. Qe xel mi lax lek vaxa wei mi nale lek o, me mi wong xeiyaing wou xel dalus wei mindei eivek xomek lalei yo. ");
INSERT INTO tbx_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Om nambei nyon eno xam ghe bong xam xe xeiyaing etel atax wou xomaxoneing mendghalus, en kandek xel gyei xam xe kwa nimza yon me sanghoxe xam Mamim lei eivek tyoung gheyapu. ");
INSERT INTO tbx_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Xam seng bou kwamim bei a lam bei semaleeng qayeeng petieing veil o qayeeng poropet. A se lam bei semaleeng qe a lam bei bong embo neing lek. ");
INSERT INTO tbx_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","A neil wou xam zonghek, ka tyoung gheyapu luw tembuing nati, tyek qayeeng nayaka ti tyek se nati, o dee nayak wei xel byex eno tyek se nati veil petieing qe ka lulul dalus na teyei lek bole. ");
INSERT INTO tbx_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Om wangwei xelti embei gyei qayeeng petieing ne nayak ti nambei lul bandaing me na teyoxe xel valu me xel bong ambei nyon, eno tyek e lei bo nayaka eivek tete lalei wei tyoung gheyapu nei, ekom eti yeiw wei mi betiwou me teyoxe xel moux alis vex en petieing o, eno tyek xel a neil e lei bo ngandoung eivek tete lalei wei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Om a neil wou xam bei wangwei xam se betiwou kwa bombek wei Anutu xe yo, me xam xe kwa bombek se ghanaw kwa bombek wei xel Parisi me xel putoung wei petieing, ond xam seng teyei being na eivek tete lalei wei tyoung gheyapu yo. ");
INSERT INTO tbx_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Xam ghe ngo bei inyon qayeeng wei xel neil wou bumyeiw on takwei nei yo, ‘Xam seng nyeis xel amey, me e tiwei leis nge mey eno tyek bale lek qayeeng.’ Qou e loum 20:13 ");
INSERT INTO tbx_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ekom a neil wou xam eti yeiw wei laleind mi wo myavanei wou liyeiw ba eno tyek bale lek qayeeng. A neil no, eti yeiw wei neil qayeeng nol lek liyeiw ba eno tyek na gyei lei ngandoung wei kanzol o. Ekom wangwei tambiy ti e neil, ‘Wang on bandol!’ eno tyek na eivek nenyex wei beyeeng nilul o. ");
INSERT INTO tbx_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Nambei nyon om wangwei wa being na toung xound lek qeind, ekom wang wou naleim bei lim neil qayeeng ti lek wang, ");
INSERT INTO tbx_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ond wa toung wa xe da e na mya wou qeind. De wang nox me na bole me menyex qayeeng is lim, woyom wang noum me ghe na toung wa xe da. ");
INSERT INTO tbx_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Wa menyex wou qayeeng daing is tambiy wei embei qou wang me na bong qayeeng en wang o. Wang bong inye gyeik ingwei muw anghei di la wou sakwaing o, enok na qou wang me na wou tambiy wei mi ngo qayeeng o, me tambiy wei mi ngo qayeeng eno bong wang na wou beyeiv, me xel a toung wang na eivek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","A neil wou wang zonghek, tyek wa seng teyei bei na myayaing, qe ka wa dexouv xomek xeitueing en wa xe malew kayo dalus bole. ");
INSERT INTO tbx_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Xam ghe ngo qayeeng wei xel neil o, ‘Xam seng bo kwapesiv.’ Qou e Loum 20:14 ");
INSERT INTO tbx_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ekom a neil wou xam bei eti yeiw wei mi yei vex me lalei mi zeim e lek en vex eno inyon wong kwapesiv is e woy eivek lalei. ");
INSERT INTO tbx_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Wangwei wa mam payeiv bo wang bong sewokeing, ond wa qepei veil me banex ena. Inye nimza bei wa saing neing ti na veil de xel se banex wa neing dalus na eivek beyeeng wei nilul o. ");
INSERT INTO tbx_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Me wangwei wa memam payeiv e bo wang bong sewokeing, ond qateiv veil me nex ela. Inye nimza bei wa saing neing ti de xel se banex wa neing dalus na eivek beyeeng wei nilul o. ");
INSERT INTO tbx_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“E neil is ambei nye, ‘Xelti embei qateiv luw venei xe iingama ond e bong qapiya wei qateiveing iingama yo ti wou e.’ ");
INSERT INTO tbx_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ekom a neil wou xam, eti bei qateiv iingama wei luw venei, gyeik venei se wo kwa nol, ond wo venei wong ambei vex wei mi wo kwapesiv o, me eti bei dii vex wei qateiv iingama eno wo kwapesiv is e.” ");
INSERT INTO tbx_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Yesu neil no, “Xam ghe ngo bei inyon xel neil wou bumyeiw takwei nei, ‘Wa se pyalek qayeeng wei wang neil zonghek is inyapunei yo, qe xam ghe gweiteyei qayeeng zonghek is inyapunei wei xam ghe neil wou Tambiy Ngandoung o.’ ");
INSERT INTO tbx_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ekom a neil wou xam, xam se neil qayeeng zonghek is inyapunei. Xam se neil tyoung gheyapu nei bei byexaxoun qayeeng ti, en inye Anutu xe siaking, ");
INSERT INTO tbx_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","o xam se neil lek tembuing, en inye e xe pom wei mi lax vaxa lek o, o xam se neil lek Yerusalem, en inyon beyeeng ngandoung wei King wei ghanaw veil o. ");
INSERT INTO tbx_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Me wa se neil qayeeng zonghek is inyapunei lek lumkanzek, en wa seng teyei bei bong lum velus ti bo teleing o bo ngak. ");
INSERT INTO tbx_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Qe wa mou neimbei ‘E’ o wa neimbei ‘Ma.’ Qayeeng wei xel mi tetulexe eno lam wou tambiy kawei nilul o. ");
INSERT INTO tbx_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Xam ghe ngo qayeeng wei xel neil o woy, ‘Wangwei xelti embo nol wou wa mamghalus, ond wang bo nol wou e manghalus is ambei nyon, me wangwei xelti qatuw wa newoum apek ond wa qatuw e newou pek is ambei nyon.’ ");
INSERT INTO tbx_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ekom a neil wou xam bei xam seng bong myaveweeng nox wou xel wei nilul o. Wangwei xelti petapexe wa ling nge payeiv, ond wa pekwi ling valu nox wou e is. ");
INSERT INTO tbx_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Me wangwei xelti embei bo qayeeng en wang me na qou wa xe teimb, ond wang bong e qou wa xe teimb ding is. ");
INSERT INTO tbx_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wangwei tambiy ti tendu wang bei wa qalei e xe qoupek me ghe na teyei lek kilomita ti, ond wang na is e teyei lek kilomita yuw. ");
INSERT INTO tbx_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Wangwei tambiy ti teling wang en lulti yon wang bong wou e, de tambiy ti embei qou lulti wou wang dekakom bong enoum on wa se pesek. ");
INSERT INTO tbx_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Wang ngo ingwei xel neil o woy, ‘Wa laleim devind nimpapu de ghe gwei xel wei vevek amba bo nol.’ ");
INSERT INTO tbx_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ekom a neil wou wang, wa laleim devind xel wei vevek amba yo me na zeimemam en eti yeiw wei embei bo nol wou wang o, ");
INSERT INTO tbx_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","om nambei nyon xam on tyek mendei nambei Mang wei toundei eivek tyoung gheyapu yo neuyeiw, eno moxo mi wong sayeiv mi siing lek xel nilul me nimza, me wong luing mi tei lek xel wei bombek o me xel wei se bombek o is. ");
INSERT INTO tbx_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Wangwei wa laleim devind eti yeiw wei laleind mi vind wang, on tyek wa qou xouveing vati? Beip xel wei mi qou takis eno se mi wong inyon? ");
INSERT INTO tbx_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Me wangwei wa neil bendiyeing wou limyeiw venaxow, on tyek wa qou lul vati ghanaw xel valu? Xel wei mendalus eno se mi wong inyon is? ");
INSERT INTO tbx_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Xam a mi mendei embo nimzayang, nambei xam Mamim wei tyoung gheyapu mindei nimzayang o. ");
INSERT INTO tbx_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Xam ghe gweiteyei xow en xam seng bong xam xe kwa wei bombek o eivek xel xomaxoneing mend bei xel gyei. Wangwei xam ghe bong ambei nyon nei, ond tyek xam se qou xouveing ti wou xam Mamim eivek tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Om wa being bong lul wou xel wei kanyo yo, ond wa se neil me xel davei vuk me natax en wang nambei xel wei myend yuw mi wong eivek xomek qekueing ama me sakwaing mema nayak, bei xel xomaxoneing bo lei ngandoung wou xel o. A neil wou xam zonghek bei, xel qou nind xouveing dalus woy. ");
INSERT INTO tbx_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ekom gyeik wa being bong wou xel wei kanyo yo, wa seng bong wa memam qeinz boulek vati wei wa memam payeiv embei bong o, ");
INSERT INTO tbx_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","en kandek wa xe wongeing e mi mendei xupekeing. Woyom Mam yei vati wei wang wong xupekeing o, eno tyek bong xouveing wou wang. ");
INSERT INTO tbx_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Me gyeik wa bei zeimemam, wa seng bong ambei xel wei myend yuw o, en xel laleind mi vind bei na mi bale me na zeim memend eivek xomek qekueing ama me na mi bale wou sakwaing nayak en kandek moux alis vex a mi gyei xel. A neil wou xam zonghek bei, xel qou nind xouveing dalus woy. ");
INSERT INTO tbx_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ekom gyeik wa bei zeimemam, ond wang na eivek bam lalei me na toung qapomb zeyi dom na zeimemam wou Mam, wei mi dei xupekeing o. Woyom Mam wei mi yei vati wei mindei xupekeing, eno tyek bong xouveing wou wang. ");
INSERT INTO tbx_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Me gyeik xam a bei zeimemamim, xam se zeimemamim ding nambei xel wei mandalus mi wong o, en xel wou naleind bei tyek Anutu na ngo xel xe qayeeng ngenongakes on. ");
INSERT INTO tbx_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Xam seng ghok xel, gyeik ingwei wa seng ghei teling wou e yo, eno xam Mamim woulek woy en vati wei wambei teling wou e yo. ");
INSERT INTO tbx_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Woyom tine inye xam a bei zeimemamim eno nambei nye: “ ‘Xa Mami eivek tyoung gheyapu, wa leim e mi mendei vambuing. ");
INSERT INTO tbx_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Wa xe tete lalei e nam. Xa teyei bei betiwou wa laleim lek tembuing, nambei xel mi betiwou nanghei tyoung gheyapu yon. ");
INSERT INTO tbx_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Gweimbeeng wang bong xami yaeing wei bouk titi eno wou xa. ");
INSERT INTO tbx_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Wa semaleeng sewokeing wei xa yo, xa is ambei nyon xa semaleeng sewokeing wei xel ba mi wong wou xa yo. ");
INSERT INTO tbx_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Me wa se qou xa na eivek axeing, qe wa qou xa veil tambiy nilul on.’ ");
INSERT INTO tbx_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","En wangwei wa semaleeng sewokeing wei xomaxoneing wong wou wang o, on tyek Mam wei toundei tyoung gheyapu nei tyek semaleeng wa xe sewokeing is. ");
INSERT INTO tbx_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ekom wangwei wa se semaleeng xomaxoneing nge xe sewokeing veil, ond tyek Mam se semaleeng wa xe sewokeing is. ");
INSERT INTO tbx_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Gyeik wambei vambu yaeing, ond wa seng gweimam nol nambei xel wei myend yuw mi wong o, en xel mi wo mend nol me talex wou xel moux alis vex bei xel vambu yaeing. A neil wou xam zonghek, xel qou nind xouveing dalus woy. ");
INSERT INTO tbx_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ekom gyeik wambei vambu yaeing, on wa pelei wel lek lum me davu mam, ");
INSERT INTO tbx_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","om wa seng bong kwa wei vambuing yaing gyeip yaeing wou xomaxoneing mendghalus. Ma, wang bong wou Mam manghalus wei mindei xupekeing o. Mam wei toundei xupekeing eno venaxow mi woulek, vati wei xel mi wong xupekeing o, eno tyek bong xouveing wou wang. ");
INSERT INTO tbx_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Xam se qekuwou xam xe lulul nimzamza lek tembuing ne, wei xevek me niyeis mi wo nol wou yo, me xel wei panaxeing o mi dembu xomek me panax. ");
INSERT INTO tbx_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ekom xam a mi qekuwou xam xe lulul nimzamza e na eivek tyoung gheyapu nei, wei xevek me niyeis se teyei bei bo nol wou, me panaxana se teyei bei dembu me na lalei me panax. ");
INSERT INTO tbx_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","En nanghei ingwei wa xe lul nimza toundei ghei yo, eno wa laleim tyek na mendei is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Xe mendghalus ne lam wei xe neing o. Wangwei wa mam on nimza, on wa neing dalus on tyek na pup en xeiyaing. ");
INSERT INTO tbx_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ekom wangwei wa mam aluw on nilul, yon wa neing dalus on tyek bo mapetok. Om wangwei xeiyaing wei toundei eivek wang on bo mapetok, yon mapetok on tyek bong ngandoung eivek wang mouyo! ");
INSERT INTO tbx_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Tambiy ti se teyei bei bo xuk wou teiv yayuw. Moxo tyek lalei bo nol wou nge, de lalei devind nge, me tyek na mi ngo e xe qayeeng, de na toung demi wou nge. Wa seng teyeimbei bong xuk wou Anutu me malew is. ");
INSERT INTO tbx_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Nambei nyon a neil wou xam bei, xam seng bounaleim ngenong en mapieing wei xam o me na neimbei, ‘Tyek xey a gha vati? O na num va? De xe neing eno tyek xey a byex vati?’ Mapieing ne ngandoung ghanaw yaeing, me neing ne ngandoung ghanaw teimb. ");
INSERT INTO tbx_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xam ghe gwei menek menek wei senghoing bandaing nei, xel se mi xen o se mi qekuwou o toung lulul eivek xomek yaeing. Ekom xam Mamim wei toundei tyoung gheyapu nei eno mi vet xel. Beip xam seng ghanaw menek menek on veil, ei? ");
INSERT INTO tbx_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Eti yeiw wei mi wou naleind ngenong eno teyei bei tetulexe seivma nayaka lek e xe mapieing? ");
INSERT INTO tbx_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Me xam ghe di wou naleimim ngenong en teimb en va? Xam ghe gwei qapaing mavya wei toungale yon. Xel se mi wong pok o duw teimb. ");
INSERT INTO tbx_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ekom a neil wou xam bei Salomo mi vunek en lul nimzamza, ekom e xe vunekeing nimza yon se nambei qapaing mavya ti beimambei ne. ");
INSERT INTO tbx_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wangwei inye Anutu mi vunekwou qeis qeis wei xuk o nambei nyon, ond inyon gweimbeeng me yanyeing eno xel mi nex ela eivek nenyex. Beip moxo se mi vunekwou xam? Xam on xe wongeingis on nayaka. ");
INSERT INTO tbx_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Om xam seng bounaleim ngenong, me na neimbei, ‘Tyek xey a gha vati?’ o ‘Tyek xey a num vati?’ o ‘Tyek xey a bunek en vati?’ ");
INSERT INTO tbx_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","En xel wei mendalus eno mi yimexe lul dalus ti beimambei ne, de xam Mamim wei tyoung gheyapu eno woulek woy en vati wei xam a bei qou yo. ");
INSERT INTO tbx_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ekom xam ghe gwimexe e xe tete lalei me e xe sakwaing bombek bole, de lulul dalus ti beimambei ne eno tyek bong wou xam is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nambei nyon xam seng bou naleimim en yanyeing, en yanyeing tyek bounalei en venaxow. Nimaying wei bouk titi eno teyei lek bouk tiyon venaxow. ");
INSERT INTO tbx_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Xam seng gwei xel nge xe kwa me baluk en, enok Anutu bong kwa nambei nyon wou xam is. ");
INSERT INTO tbx_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","En eivek sakwaing kawei xam ghe wei xel nge me ghe luk en e, eno tyek Anutu bong kwa nambei nyon wou xam, me vati wei xam ghe mi wong wou xel nge yo, tyek Anutu bong ambei nyon wou xam is. ");
INSERT INTO tbx_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Wang wei myasa wei dei eivek lim nge ma yon en va, de wa seng wei pelang wei di yeip eivek wamaxow mam on? ");
INSERT INTO tbx_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Inye nambei nya wang neil wou lim, ‘Wong a laluwexe myasa yon lam myayaing veil wa mamghalus,’ de pelang wei toundei eivek wamaxow mamghalus on? ");
INSERT INTO tbx_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wa tambiy wei wa myam yuw o, myaxeeng eno wa laluwexe pelang veil venaxow mamghalus bole, woyom tyek wang gwei embo nimza me laluwexe myasa veil lim manghalus. ");
INSERT INTO tbx_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Xam se qou lul wei vambuing wei xel wong wou Anutu yo me ghe bong wou xel naw on, me wa se banex wa xe viyaviy na wou xel bok on. Wangwei wang bong nei, tyek xel bakei lek angya vaxend, de woyom tyek xel pekwi me noum wou xam me zanga xam ghe bo tiptip. ");
INSERT INTO tbx_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Xam teling on tyek bong wou xam. Xam ghe gwimexe on tyek xam ghe gweiwou. Xam ghe nyeis memamim lek qapomb on tyek natax veil xam. ");
INSERT INTO tbx_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","En xel dalus wei mi teling eno mi qou, me eti mi yimexe eno mi yeiwou, me eti yeiw wei mi leis memend lek qapomb eno tyek natax. ");
INSERT INTO tbx_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Xam eti yeiw, wangwei e neu moux teling wou en belet, tyek wang bong qakous ti wou e? ");
INSERT INTO tbx_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O wangwei e teling wou wang en woing, tyek wang bong myeiy ti wou e? ");
INSERT INTO tbx_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Xam mayeiw on nilul, ekom xam ghe mi wong lul nimza wou neumyeiw, om xam Mamim wei toundei tyoung gheyapu nei tyek bong lul nimza wou eti yeiw wei mi teling wou e yo! ");
INSERT INTO tbx_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Om kwa tambak wei wambei xel bamba bong wou wang eno wang bong ambei nyon wou xel, eno tine inye qayeeng qes wei petieing o me qayeeng qes wei xel poropet o. ");
INSERT INTO tbx_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Xam a mi na nox tete mya nayak. En tete mya wei ngandoung me sakwaing ngandoung eno inyon la wou beyeeng wei qoueing nilul o, me xel ngenong eno mi la lox. ");
INSERT INTO tbx_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ekom tete mya nayak me sakwaing nayak on la wou beyeeng wei mapieing o, me moux alis vex nuyuw ka mi yei me betiwou. ");
INSERT INTO tbx_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Xam ghe gweiteyei xow en poropet wei tyonyeing. Xel mi lam wou xam eivek teimb wei sipsip nivlus o, ekom xel laleind ond xok ambei naw bemeeng. ");
INSERT INTO tbx_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nangya xel xe kwa yon tyek xam ghe boulek e neing. Beip xel xomaxoneing mi qou xax wain neing lek qeis wei niying o, o xel mi qou xax basunghek lek qeis wei nileli yo? ");
INSERT INTO tbx_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nambei nyon xax sapa wei nimza eno mi vuk neing nimza, dom xax nilul mi vuk neing nilul. ");
INSERT INTO tbx_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Xax nimza ti se teyei bei buk neing nilul, o xax nilul ti se teyei bei buk neing nimza. ");
INSERT INTO tbx_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Xax sapa wei se mi vuk neing nimza eno xel mi vuv veil me nex ela eivek nenyex. ");
INSERT INTO tbx_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Om tyek xam ghe gwei lek xel xe neing me ghe boulek xel. ");
INSERT INTO tbx_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Se xel dalus wei mi taxe a bei, ‘Tambiy Ngandoung, Tambiy Ngandoung,’ eno tyek na eivek tete lalei wei tyoung gheyapu yo, qe eti yeiw wei mi wong e betiwou Mang wei tyoung gheyapu yo lalei. ");
INSERT INTO tbx_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Xel ngenong tyek na neil wou ay lek bouk kayon, ‘Tambiy Ngandoung, Tambiy Ngandoung, beip xa se mi neil qayeeng poropet eivek wa leim, me eivek wa leim eno xa mi tiy memo la myayaing me na wong lulvako ngenong?’ ");
INSERT INTO tbx_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Woyom tyek a neil wou xel bombek, ‘A se woulek xam nayaka. Xam wei ghe mi wo kwa nilul, xam la veil ay!’ ");
INSERT INTO tbx_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Nambei nyon xel sapa wei mi ngo a xe qayeeng tine me mi betiwou eno inye nambei tambiy lupeyei wei ev beeng lek qakous o. ");
INSERT INTO tbx_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Luing tei, me memiing butek, me laweeng vei xomek wo pimapi, ekom xomek se qepei me teila, en nambei mundeeng on nale nikanzek eivek qakous. ");
INSERT INTO tbx_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ekom eti yeiw wei se mi ngo a xe qayeeng ti beimambei ne me betiwou, eno nambei tambiy wei ev xomek lek luzeeng bandaing o. ");
INSERT INTO tbx_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Luing tei, me memiing butek, me laweeng vei xomek wo pimapi, om xomek qepei me teila niseikeing.” ");
INSERT INTO tbx_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu neil qayeeng ti beimambei ne ma woy, xel qendu ngandoung on etek en e xe qayeeng wei di teyoxe yo, ");
INSERT INTO tbx_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","en moxo teyoxe xel teyei lek tambiy wei lei ngandoung o, de se nambei xel xe putoung wei petieing o. ");
INSERT INTO tbx_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Moxo di loum axone veil lukendu, eno xel qendu ngandoung ti betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","De tambiy ti is vanei lepa eno lam ev vaxakatu eivek wou e me neil, “Tambiy Ngandoung, wangwei wa laleim devind nei, yon wang bong am bo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yesu tatei mema la me axlek e, de neil, “A laleing vind! Wang bo vako.” Lutika eno moxo xe vanei lepa yon ma veil e. ");
INSERT INTO tbx_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Woyom Yesu neil wou e, “Wang wei inyon dom wa se neil wou xelti. Qe la, me talex xow wou lumuki me toung xound teyei lek Mose neil o, en xel boulek pavulek ne bei wa xe myavanei yon ma.” ");
INSERT INTO tbx_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ka Yesu la eivek beyeeng Kapenaom, beyeiv wei mi yeiteyei 100 vevekyeiw eno ti lam wou e me teling wou en vineing. ");
INSERT INTO tbx_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Moxo neil, “Tambiy Ngandoung, a xe xukxe eno vanei wong om di yeip lek zek eivek xomek lalei. Moxo kanzek mey me di axe vanei ngandoung.” ");
INSERT INTO tbx_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu neil wou e, “Tyek a nak me na bong embo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ekom beyeiv neil elox bei, “Tambiy Ngandoung, a se nimza bei wang nam eivek a bang lalei. Qe wa mou neil qayeeng dom a xe xukxe e bo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","En a maxow ne a mindei kwanghembi eivek xel wei wo leind ngandoung o, me xel vevek mindei kwanghembi eivek ay. Wangwei a neil wou tine, ‘La,’ ond moxo la. De na neil wou nge yon, ‘Lam,’ ond moxo lam. Me a neil wou a xe xukxe, ‘Wong tine,’ ond moxo mi wong.” ");
INSERT INTO tbx_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu ngo qayeeng tine, moxo etek mouyo me neil wou eti yeiw wei di betiwou e yon, “A neil wou xam zonghek, a se mi xei tambiy ti eivek Israel eno xe wongeingis ambei nye. ");
INSERT INTO tbx_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","A neil wou xam bei inyon xel ngenong tyek nam anghei ninei me xeinei, me nam mendei me gya mata ngandoung on is Apraham aluw Isaka lal Yakop eivek tete lalei wei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ekom xomaxoneing wei Israel wei tete lalei eno tyek Anutu banex xel na myayaing eivek mapetok ngandoung, nanghei inyon eno tyek xel bong talot ngandoung me dexound newound bo nyiknyik.” ");
INSERT INTO tbx_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Woyom Yesu neil wou beyeiv, “La! En tyek na tyip ambei ingwei wang wongis bei etyip o.” De e xe xukxe wo nimzalek seivma kayon. ");
INSERT INTO tbx_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Woyom Yesu lam eivek Petele xe xomek, moxo yei Petele yeing avexta gying wong me e di yeip lek zek. ");
INSERT INTO tbx_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Moxo axlek e mema de gying on ma veil e, me vexo qandi lek me di menyex lulul wou e. ");
INSERT INTO tbx_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Soukeing tiyon, eno xel ngenong wei memo dei eivek xel eno liyeiw qou xel me lam wou Yesu. Me e neil de xel laweeng nilul on la myayaing me wong xel ngenong wei vanei eno wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","De kwa tine la teyei lek vati wei Anutu neil eivek poropet Yesaya mya yo: “E maxow qou xe xe myavanei leimalei me semaleeng xe xe vanei leimalei veil.” ");
INSERT INTO tbx_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Gyeik Yesu yei xel qendu ngandoung wei nale vivekwou e yon, moxo neil nikanzek wou xel betiyeing bei, “Xey a na nge loxalu wei lounyeing nei.” ");
INSERT INTO tbx_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Woyom putoung wei petieing o ti eno lam wou e me neil, “Putoung, wambei mi na inya yo eno tyek a betiwou wang.” ");
INSERT INTO tbx_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu neil elox bei, “Xel naw bemeeng xe eeng me menek menek xe lewis, ekom Xomaxoneing Neu Moux xe beyeeng wei embei ni lu lek eno ma.” ");
INSERT INTO tbx_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Betiyeing nge neil wou e, “Tambiy Ngandoung, wong a la ev mang wole.” ");
INSERT INTO tbx_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ekom Yesu neil wou e, “Wa betiwou ay, dom wong xel meyeing di ev xel venaxow xe meyeing.” ");
INSERT INTO tbx_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Woyom moxo la eivek bot de e xe xel betiyeing betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Se wo lululek, qe laweeng ngandoung ti tyip wou xel lek lounyeing masenghoing, omek laweeng vei lounyeing lam embei sevunexe bot is xel. Ekom Yesu vena di yeip. ");
INSERT INTO tbx_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Xel betiyeing la me piyexe e, me neil, “Tambiy Ngandoung, vind xa! Xey am bim a qou nilul ne!” ");
INSERT INTO tbx_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Moxo neil elox, “Xam xe wongeingis on nayaka, nambei nya xam ghe waleeng?” Woyom moxo qandi lek me luk nikanzek wou laweeng me mamileeng wei di vuk me lam on yeip kanzek, me wo nimza no. ");
INSERT INTO tbx_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Xel moux on etek me teling, “Tambiy tine e vati? Om memiing aluw laweeng ngo e vya!” ");
INSERT INTO tbx_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ka Yesu la tei lounyeing nge loxalu wei Gadarayeiw xe tembuing nei, eno moux yayuw wei memo dei eivek luw eno lam myayaing veil eeng wei xel qateiv eivek qakous o me lam wou e. Tambiy yuw on bemeeng om xelti se teyei bei na nox sakwaing tiyon. ");
INSERT INTO tbx_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Woyom luw ghak, “Anutu Neu Moux, wa being bo vati wou uw? Beip wang lam inye bei bo nol wou uw de bouk anghei?” ");
INSERT INTO tbx_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Bok qendu ngandoung ti di ya ghei dingta ka nanghei inyon en xel. ");
INSERT INTO tbx_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Laweeng nol yon tay wou Yesu, “Wangwei wa tiy xa na myayaing nei, on wong xa la eivek bok qendu ngandoung nei.” ");
INSERT INTO tbx_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Moxo neil wou xel, “Xam la!” Om xel lam myayaing me la eivek xel bok on, me bok qendu tiyon dalus veimyend me la oing mazanghei me heivek lounyeing de mey eivek memiing. ");
INSERT INTO tbx_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Xel wei mi yeiteyei bok on yei tine, om xel veimyend me la eivek beyeeng on me neil qayeeng dalus en tine, me vati wei belup wou moux yuw wei memo mindei eivek luw o. ");
INSERT INTO tbx_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Woyom xel tambak wei beyeeng on la wou Yesu. Me gyeik xel yei e, xel luk nikanzek wou e bei ena veil xel xe tembuing. ");
INSERT INTO tbx_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu lek la eivek bot ti, me la nge loxalu nei me la tyip emaxow beeng qes. ");
INSERT INTO tbx_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Xel valu qou tambiy bezombeing ti wei xel liw lek lelek o me lam. Yesu yei xel xe wongeingis, om neil wou tambiy wei bezomb on, “A neung, wa qou laleim vevopeing. A semaleeng wa xe sewokeing veil.” ");
INSERT INTO tbx_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Xel putoung valu wei petieing eno xel neil wou ma en tine bei, “Tambiy tine embei qou Anutu nimbeeng!” ");
INSERT INTO tbx_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu woulek xel xe woueing nalei me neil, “Xam ghe di wou naleimim nilul eivek laleimim enva? ");
INSERT INTO tbx_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Qayeeng tina inye xeiles bei a neil: ‘A semaleeng wa xe nilul,’ o a neimbei, ‘Qandi lek me la’? ");
INSERT INTO tbx_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ekom inyon xam ghe boulek bei, Xomaxoneing Neu Moux wo lei ngandoung lek tembuing en semalenyeing sewokeing.” Woyom moxo neil wou tambiy wei bezomb on bei, “Qandi lek, de qou wa xe lelek me la bam.” ");
INSERT INTO tbx_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","De moux moxo qandi lek me la beeng. ");
INSERT INTO tbx_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Xel qendu ngandoung on yei tine, xel etek en ingwei xel yei Anutu xe nikanzek me sanghoxe Anutu, e tiwei wong nikanzek wou xomaxoneing ti yo. ");
INSERT INTO tbx_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ka Yesu la nanghei inyon, moxo yei tambiy ti lei Matai toundei eivek xomek takis. Moxo neil wou e, “Betiwou ay,” om Matai qandi lek me betiwou e me la. ");
INSERT INTO tbx_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Kale Yesu di ya eivek Matai xe xomek, xel ngenong wei mi qou takis me xel sewokeing eno lam me di ya is e me e xe xel betiyeing. ");
INSERT INTO tbx_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Xel Parisi yei tine, om xel teling wou xel betiyeing, “Nambei nya xam xe putoung di ya is xel wei mi qou takis me xel wei mi wo sewokeing o?” ");
INSERT INTO tbx_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu ngo tine me neil, “Xel wei vanei ma eno se mi la wou dokta, qe xel wei vanei yo. ");
INSERT INTO tbx_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ekom xam ghe na me na qou kwa wou qayeeng tine qes: ‘A laleing vind lalei pyaweing de a laleing se vind seing xound.’ En a se lam bei taxe xel wei bombek o, qe xel wei sewokeing o.” ");
INSERT INTO tbx_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Woyom Yoan xe xel betiyeing lam me teling wou Yesu, “Nambei nya ekom xa is xel Parisi mi vambu yaeing, de wa xe xel betiyeing se mi vambu yaeing?” ");
INSERT INTO tbx_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu neil elox bei, “Nambei nya xel wei lam en iingama eno na qou laleind maying gyeik tambiy wei embei dii vex eno nanghei toundei is xel? Ka bouk wei xel embei qou tambiy wei iingama yo me na veil xel, woyom tyek xel vambu yaeing. ");
INSERT INTO tbx_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Tambiy ti se mi qou qaeing vako myasepu me duw eivek teimb takwei, en qaeing vako wei xel duw on tyek tetei me zex teimb on bo nilul. ");
INSERT INTO tbx_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Xel ti se mi taw wain vako eivek wain takwei ninavi. Wangwei xel bong ambei nyon nei, wain ninavi yon tyek na tip, de wain on tyek na taw veil de ninavi yon tyek bo nol. Qe xel mi taw wain vako yon eivek ninavi vako, me luw xouing tyek mendei nimza.” ");
INSERT INTO tbx_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ka moxo neil qayeeng tine, gyovaxa ti lam me ev vaxakatu eivek wou e tax me neil, “A neung vex mouk mey. Ekom wang nam a ni memam lek e, en vexo e mendei mapieing no.” ");
INSERT INTO tbx_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu qandi lek me la is e, me e xe betiyeing is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","De woyom vex tiwei mi qou gyand teyei lek vakovek qes xoumeeng yuw eno lam me di la yus en e me axlek e xe teimb ding on myasepu. ");
INSERT INTO tbx_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Vexo neil wou xow, “Wangwei a mou daxlek e xe teimb, on tyek a bo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yesu pekwi me yei vex on me neil, “A neung vex, wa laleim embo nimza, wa xe wongeingis wong wang wo nimzalek.” Om vexo wo nimzalek gyeik kayon. ");
INSERT INTO tbx_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu la eivek gyovaxa xe xomek me yei xel wei di vei sakwep me wo talot me yei xel qendu yon di wo nindenduing, ");
INSERT INTO tbx_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","moxo neil, “Xam la veil. Vexawo ne se mey qe di yeip.” Ekom xel napexe e. ");
INSERT INTO tbx_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ka Yesu tiy xel qendu ngandoung on la myayaing, moxo la lalei me zeim vex on mema, de vexo qandi lek. ");
INSERT INTO tbx_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Qayeeng la wo ngandoung en tine eivek tembuing danghei danghei nei dalus. ");
INSERT INTO tbx_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ka Yesu la nanghei inyon me la, tambiy matekeing yayuw betiwou e, me di taxe la wou e, “Dawit Neu Moux, pyanaleim en uw!” ");
INSERT INTO tbx_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Moxo la eivek xomek, eno tambiy yuw wei mend tekeing o lam wou e, me moxo teling luw, “Muw ghe wongis bei a teyei bei bong tine?” Luw lewexe, “Ee, Tambiy Ngandoung.” ");
INSERT INTO tbx_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Woyom moxo toung mema lek luw mendghalus me neil, “Muw ghe wongis om lul tine e na teyei lek wou muw.” ");
INSERT INTO tbx_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","De luw mendghalus yeila. Yesu peti luw, “Kandek muw seng bong xelti boulek lul tine.” ");
INSERT INTO tbx_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ekom luw la myayaing nei me teyoxe qayeeng on lala en Yesu eivek tembuing danghei danghei dalus tiyon. ");
INSERT INTO tbx_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ka luw la veil, xomaxoneing qou tambiy ti myatueing wei memo dei eivek me se teyei bei baluk o me lam wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Me gyeik Yesu tiy memo yon la myayaing, tambiy wei myatu yon luk. Xel qendu ngandoung on etek me neil, “Lulti nambei tine eno xelti se mi yei eivek Israel ti.” ");
INSERT INTO tbx_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ekom xel Parisi neil, “Moxo mi tiy xel angya nikanzek wei gyovaxa lukanzek wei xel memo yo.” ");
INSERT INTO tbx_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu mi la eivek beyeeng nayak dalus me beyeeng me teyoxe xel eivek xomek qekueing ama wei xel Yuda yo me neil Xoulek Nimza wei tete lalei yo me wong xel wei vanei leimalei eno mi wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Gyeik ingwei yei xel qendu ngandoung on, moxo pyanalei en xel, en nambei xel lundpeyei yon la bandabanda, me xel mindei e wo nol nambei sipsip wei gyovaxa ma veil o. ");
INSERT INTO tbx_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Woyom moxo neil wou e xe xel betiyeing, “Neing zuw ngenong ekom xel xukxe yon nuyuw ka. ");
INSERT INTO tbx_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Om xam teling wou xuk ma bei e bong xel xukxe na eivek e xe xuk me na qou neing eivek xuk.” ");
INSERT INTO tbx_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu taxe e xe xel betiyeing xoumeeng yuw on lam wou e me wong nikanzek wou xel bei xel a mi tiy laweeng nilaxes me bong xel wei vanei leimalei eno bo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Xel sinale xoumeeng yuw ne leind ambei nye. Tiwei tax eno Simon e lei nge xel mi taxe bei Petele me li Andrias, Jems wei Sebedi neu moux o me li Yoan, ");
INSERT INTO tbx_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilip me Batolomiu, Tomas me Matai tambiy wei mi qou takis o, Jems Alpias neu moux, me Tadius, ");
INSERT INTO tbx_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon wei Selot me Yudas Iskariot, tiwei tyek na neil Yesu teyei me na toung e na eivek xel ba memend o. ");
INSERT INTO tbx_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu wong xel xoumeeng yuw ne eno la de peti xel bei, “Xam seng na eivek xel amba senghoing o ghe na eivek Samaria xe beyeeng on ti, ");
INSERT INTO tbx_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","qe xam ghe na wou xel sipsip wei Israel wei lati yo. ");
INSERT INTO tbx_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ka xam a being na eno xam ghe na neil qayeeng tine, ‘Tete lalei wei tyoung gheyapu eno lam paviy.’ ");
INSERT INTO tbx_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xam ghe bong vanei e ma, me xam a piyexe xel meyeing, de ghe bong xel wei lepa yo bo nimzalek me xam a tiy memoyeiw na veil. Lul wei xam ghe qou bandaing, eno xam ghe bong wou xel bandaing. ");
INSERT INTO tbx_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Xam se qou lulti nambei ghol o silva malew o kopa malew gyand eivek xam xe let. ");
INSERT INTO tbx_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Gyeik xam ghe na wou sakwaing eno xam se qou vaxak ti, o teimb yuw, o vaxalambes o patongeeng is. En xel wei mi wo xuk eno tyek xel bong yaeing wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Wangwei xam a being na eivek beyeeng nayak o beyeeng, ond xam ghe gwimexe tambiy wei nimza yo ti me ghe na mendei is e eivek e xe xomek deka xam ghe na veil le. ");
INSERT INTO tbx_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ka xam a being na eivek xomek ti, eno xam a neil bendiyeing wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Wangwei xel wei xomek on na qou xam is xeindlala, xam ghe bong xam xe lalei vevopeing wou xel, ek wangwei na ma, ond xam a qou xam xe lalei vevopeing noum wou xow. ");
INSERT INTO tbx_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wangwei xelti se qou xam o na ngo qayeeng wei xam o, ond xam pepa vegyuveeng veil vaxamim gyeik xam a being na veil xomek o beyeeng nayak o. ");
INSERT INTO tbx_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","A neil wou xam zonghek bei, gyeik bouk wei Anutu embei bo qayeeng en xomaxoneing eno nimaying ngandoung tyek qandi wou beyeeng nayak tiyon ghanaw Sodom aluw Gomora. ");
INSERT INTO tbx_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wei, ambei bong xam ghe na nambei sipsip eivek xel naw bemeeng senghoing. Nambei nyon xam a qou lupeyei nambei myeiy me mendei males nambei beliy. ");
INSERT INTO tbx_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Xam ghe gweiteyei xow en xel xomaxoneing, tyek xel a qou xam me na wou xel kanzol me tyek xel bo nol wou xam me sesa xam eivek xomek qekueing ama. ");
INSERT INTO tbx_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tyek xel a qou xam me na bale wou xel lei ngandoung wei seyap o me xel king mend en ay, en nambei xam ghe mi betiwou ay me ghe neil xoulek teyei wou xel me xel amba. ");
INSERT INTO tbx_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ekom gyeik xel a zeimaxoun xam, xam seng bou kwamim ngenong en vati wei xam ambei neil o, bei tyek xam a neil ambei nya. Lek seivma kayon eno Anutu tyek bong vati wei xam ambei neil o, ");
INSERT INTO tbx_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","en inye tyek xam venaxow se neil, qe inye xam Mamim xe Laweeng eno tyek baluk eivek xam myamim. ");
INSERT INTO tbx_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Li venaxow tyek na neil li teyei me xel nyeis e mey, me ma ti tyek bong ambei nyon wou neu, de neuyeiw tyek bo vevek is mamata me xel ba nyeis xel amey. ");
INSERT INTO tbx_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Xomaxoneing dalus tyek laleind bo nol wou xam en ay, ekom eti yeiw wei nale nikanzek me ena bouk loxyus eno tyek Anutu devind xel veil meyeing. ");
INSERT INTO tbx_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wangwei xel bo nilul wou xam eivek beyeeng ti, ond xam a pek me ghe na beyeeng nge. A neil wou xam zonghek bei Xomaxoneing Neu Moux noum eno tyek xam seng na eivek beyeeng tambak wei Israel o buplek. ");
INSERT INTO tbx_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Yak wei wevek xomek o se ghanaw e xe putoung, o xukxe ti se ghanaw e xe teiv. ");
INSERT INTO tbx_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ekom wangwei yakyak wei wevek xomek o teyei lek e xe putoung, ond inyon woy. Me wangwei xukxe teyei lek e xe teiv, ond inyon woy is ambei nyon. Wangwei xomek ma eno xel taxe bei e Belsebul, ond tyek xel bo lei wei nilul o wou e xe xel wei xomek on! ");
INSERT INTO tbx_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Om xam seng gwaleeng en xel. Lul dalus wei xel vun eno tyek nam yanyateiv. Me qayeeng tambak wei yeip xupekeing eno tyek xomaxoneing boulek. ");
INSERT INTO tbx_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Vati wei a neil wou xam eivek boukeing, eno xam a neil eivek bendiyeing. Me qayeeng wei xam ghe di ngoung wouma eivek nenyamim, eno tyek xam bale lek xomek demi qetyei me na neilteyei. ");
INSERT INTO tbx_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Xam seng gwaleeng en xel wei embei nyeis xam neing a mey yo, dom xel se teyei bei nyeis xam numim pieing. Qe xam ghe gwaleeng en Anutu wei teyei bei bo nol wou xam numim pieing me xam neing eivek nenyex wei luta yo. ");
INSERT INTO tbx_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Beip xel se mi xouv menek nayak yuw en selewa gyand nayak ti? Ek wangwei xam Mamim lalei se devind nei on tyek menek menek nayak on ti se teyei bei deteina lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","De nge is xam lumim velus dalus on eno Anutu pyaw memawou woy. ");
INSERT INTO tbx_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Om xam seng gwaleeng. Xam ghe ghanaw menek nayak ngenong on. ");
INSERT INTO tbx_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Eti yeiw wei mi neil a teyei natax wou xomaxoneing eno tyek a neil e teyei natax wou Mang anghei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ekom eti bei dax a vun atax wou xomaxoneing, eno tyek a dax e vun is ambei nyon atax wou Mang nanghei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Xam seng bou kwamim bei a qou lalei vevopeing me na lam tembuing. A se qou lalei vevopeing me na lam qe ngeyeing vevek. ");
INSERT INTO tbx_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","En a lam bei pekwi ‘moux ti lalei bo nol wou ma, de neu vex ti lalei bo nol wou ta, me neu vex lalei bo nol wou yeing avexta. ");
INSERT INTO tbx_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Moux ti eivek xel venaxow eno tyek bo nol wou emaxow xe xel wei xomek o.’ ");
INSERT INTO tbx_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Xelti embei lalei devind ma luw ta ghanaw ay, eno tyek se bong ambei a xe. Xelti embei lalei devind neu moux aluw neu vex ghanaw ay, ond tyek se bong ambei a xe. ");
INSERT INTO tbx_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Me xelti embei se qalei e xe xax pepeeng me betiwou ay, ond se teyei bei bong ambei a xe. ");
INSERT INTO tbx_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tambiy ti embei bong e xe mapieing embo nimza, on tyek na saing e xe mapieing. Dom xelti embei saing e xe mapieing en ay, ond tyek gyeiwou mapieing zonghek. ");
INSERT INTO tbx_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Tambiy ti embei qou xam eno qou ay, me eti qou ay eno qou tiwei wong a lam o. ");
INSERT INTO tbx_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Tambiy ti embei qou poropet ti me gyeiteyei en nambei e mi neil qayeeng poropet ond tyek na qou xouveing wei poropet o. Me tambiy ti embei qou xel wei bombek o ti me gyeiteyei en nambei e yon tambiy wei bombek o yon tyek na qou xouveing wei tambiy wei bombek o. ");
INSERT INTO tbx_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Me wangwei xelti bong mayamya memiing tyuweing ti wou xel beimambei wei leind maeing on ti en nambei inyon e a xe betiyeing, ond a neil zonghek wou xam bei, moxo tyek se saing e xe xouveing.” ");
INSERT INTO tbx_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ka Yesu neil qayeeng wei embei teyoxe e xe xel betiyeing xoumeeng yuw eno ma, moxo la nanghei inyon me la en embei na teyoxe me na neil qayeeng eivek beyeeng wei Galili nei. ");
INSERT INTO tbx_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Gyeik Yoan ngo eivek xeitueing en vati wei Kilisi di wong o, moxo wong e xe xel betiyeing la, ");
INSERT INTO tbx_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","bei teling e, “Beip inye wang on tiwei tyek nam o, o xa mendi daxe tambiy bange?” ");
INSERT INTO tbx_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu neil elox, “Xam lox neil wou Yoan en vati wei xam ghe ngo me ghe wei yo: ");
INSERT INTO tbx_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xel matekeing eno mend yeila, me xel wei vaxend nol eno di la, me xel wei wo vanei lepa eno wo nimzalek, me xel wei nenyend wo qatu eno ngo wou, me xel meyeing eno qandi lek, de Xoulek Nimza eno xel neil wou xel kanyoyeiw. ");
INSERT INTO tbx_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Mata e na wou xel wei xel xe wongeingis se tei en qayeeng wei ay yo.” ");
INSERT INTO tbx_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ka Yoan xe xel betiyeing la veil, Yesu luk wou xel qendu yon en Yoan: “Xam ghe la tembuing bandaing nei bei na gwei vati? Ghet wei laweeng di vei elox me loum o? ");
INSERT INTO tbx_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wangwei na ma nei, yon xam ghe la being na gwei vati? Moux ti wei vunek en teimb nimza yo? Ma, xel eti yeiw wei mi vunek en teimb nimza eno mindei eivek king beeng. ");
INSERT INTO tbx_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Woyom xam ghe la being na gwei vati? Poropet ti? Ee, a neil wou xam bei, Poropet tiyon ghanaw xel poropet ba veil. ");
INSERT INTO tbx_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tambiy tine tiwei xel byex eivek xoulek eno nambei nye, “ ‘Wei, tyek a bong a xe nenyalesana ti na mamunghexeing en wang, tiwei tyek menyex wou sakwaing atax en wang o.’ ");
INSERT INTO tbx_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","A neil wou xam zonghek: Yoan Lipekeing ghanaw xel wei tayeiw wou xel lek tembuing ne yo leind, ekom e tiwei lei maeing eivek tete lalei wei tyoung gheyapu eno ghanaw e. ");
INSERT INTO tbx_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Eivek bouk wei Yoan Lipekeing neil xoulek me elam tyip gweimbeeng ne, eno xel wo vevek nikanzek en na qou tete lalei wei tyoung gheyapu yo, de xel wo vevek nikanzek om inyon wo nimaying ngenong wou e. ");
INSERT INTO tbx_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","En xel poropet dalus me petieing neil qayeeng poropet me e lam tyip wou bouk wei Yoan o. ");
INSERT INTO tbx_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Me wangwei wa laleim devind bei na qou vati wei a neil ne, ond e yon Eliya wei embei nam o. ");
INSERT INTO tbx_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tambiy wei nenya nale lek e yo, ond e ngo qayeeng tine. ");
INSERT INTO tbx_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Tyek a neil qayeeng lek vati bei talex moux alis vex wei gweimbeeng ne? Xel on ambei yakyak wei mindei eivek beyeeng vateivek me mi taxe la wou xel bamba: ");
INSERT INTO tbx_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Xa vei sakwep en xam, ekom xam seng aw, me xa wong lalo wei lalei pyaweing o, ekom xam seng wong talot.’ ");
INSERT INTO tbx_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","En Yoan lam eno se mi ya yaeing me num numeing, me xel neil, ‘Moxo memo ti toundei eivek e.’ ");
INSERT INTO tbx_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Xomaxoneing Neu Moux lam ya yaeing me num numeing, me xel neil, ‘Wei, inye e wei mi zongaxei me num ngenong o. E yon gweleeng wei xel wei mi qou takis me sewokeing o.’ Ekom e xe lupeyei nimza yon talex bei e xe xuk on la bombek.” ");
INSERT INTO tbx_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Woyom Yesu neil beyeeng tiyon en ingwei mi wong lulvako eivek o, ekom xel on se pekwi xow. ");
INSERT INTO tbx_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Xam Korasin me xam Betsaida ghe gwaleeng amim en tyek xam a tulek nimaying. Wangwei lulvako wei a wong eivek xam eno xel bong eivek Taia me Saidon, on beip xel pekwi xow takwei nei me byex teimb wei talot o de ev vewev me pelei lek xow. ");
INSERT INTO tbx_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ekom a neil wou xam bei, lek bouk wei Anutu embei bong qayeeng en xomaxoneing dalus eno tyek nimaying ngandoung qandi wou xam ghanaw veil nambei ingwei qandi wou Taia me Saidon o. ");
INSERT INTO tbx_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","De xam Kapenaom, tyek xel a zeim xam ghe zekna pu wei tyoung nei? Ma yo, tyek wa deteina beyeeng wei meyeing o. En wangwei lulvako wei a wong wou xam eno xel bong eivek Sodom, yond tyek Sodom na mi mendei me e nam atyip bouk tine is. ");
INSERT INTO tbx_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ekom a neil wou xam bei lek bouk wei ngoeing qayeeng eno tyek bo nimaying ngandoung wou xam ghanaw Sodom.” ");
INSERT INTO tbx_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lek seivma tiyon Yesu neil, “Mang, a sanghoxe wang, Tambiy Ngandoung wei tyoung gheyapu me tembuing o, en nambei wang vun lulti beimambei ne veil xel wei lundpeyei me kwa nimza yo, dom ghe talex eyeip yaing wou xel yakyak. ");
INSERT INTO tbx_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ee Mang, en inye wang betiwou wamaxow xe woueing nalei nimza. ");
INSERT INTO tbx_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Lulul dalusateiv eno Mang toung eivek a memang. Xelti se yeimawou xomaxoneing Neu Moux qe Ma venaxow, me xelti se yeimawou Ma qe Neu Moux venaxow me eti yeiw wei Neu Moux beyal bei talex e wou xel o. ");
INSERT INTO tbx_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Xam dalus wei ghe mi wong pok ngandoung me ghe mi qalei nimaying eno xam lam wou ay me tyek a bong xam ghe na mendei veil xuk wei xam ghe wong o. ");
INSERT INTO tbx_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Xam qalei a xe pelang maying lek xow me qou kwa wou ay, en a ne a laleing xeiles me laleing vevopeing, me tyek xam numim na mendei me na qou laweeng. ");
INSERT INTO tbx_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","En a xe pelang on levismaeing me a xe maying ne vevopeing.” ");
INSERT INTO tbx_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Lek bouk wei Sabat eno Yesu la eivek xuk wei wit. E xe xel betiyeing maxepya xel om xel embei qou wit lu valu me gya. ");
INSERT INTO tbx_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Xel Parisi yei tine, eno xel neil wou e, “Wei! Wa xe xel betiyeing di wong vati wei se la teyei lek petieing o lek bouk wei Sabat o.” ");
INSERT INTO tbx_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Moxo lewexe, “Beip xam seng pyaw vati wei Dawit wong gyeik ingwei e me e xe xel wei mi la is eno maxepya xel o? ");
INSERT INTO tbx_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Om Dawit la eivek xomek wei Anutu xe yo, de e me e xe xel wei mi la is e yo ya belet wei vambuing wei xel peti yo, en inyon xel lumuki venaxow xe. ");
INSERT INTO tbx_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","O xam seng pyaw eivek qapiya wei petieing o, bei lek Sabat eno xel lumuki wei mi wo xuk eivek xomek vambuing eno pyalek petieing wei Sabat o, eno se wo sewokeing? ");
INSERT INTO tbx_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","A neil wou xam bei tiwei toundei inye eno ghanaw xomek vambuing. ");
INSERT INTO tbx_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wangwei xam ghe boulek qayeeng tine qes, “‘A laleing vind lalei pyaweingxow, de se seing xound,’ xam seng teyei bei toung nimaying lek xel wei se wo sewokeing o. ");
INSERT INTO tbx_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","En Xomaxoneing Neu Moux on Tambiy Ngandoung wei Sabat o.” ");
INSERT INTO tbx_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu la veil beyeeng tiyon, me la eivek xel xe xomek qekueing ama, ");
INSERT INTO tbx_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","me tambiy wei mema bezomb eno ti toundei inyon. Xel di yimexe qayeeng qes wei xel embei bong qayeeng en Yesu yo, om xel teling wou e, “Beip inyei teyei lek bei xey a bong xel wei vanei eno bo nimzalek Sabat, o ma?” ");
INSERT INTO tbx_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Moxo neil wou xel, “Wangwei xam ti xe sipsip ti deteina eivek leiveeng lek Sabat, tyek wa seng na zeim e me na puw e nam myayaing? ");
INSERT INTO tbx_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Xel xomaxoneing on ghanaw sipsip veil! Omva petieing neil embei xey a bong kwa nimza lek Sabat.” ");
INSERT INTO tbx_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Woyom moxo neil wou tambiy on, “Tatei memam.” Om moxo tatei mema de mema wo nimza no, nambei mema nge. ");
INSERT INTO tbx_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ekom xel Parisi la myayaing me luk wouma bei tyek xel nyeis Yesu nambei nya. ");
INSERT INTO tbx_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Om Yesu la veil beyeeng tiyon, en woulek vati wei xel Parisi embei bo wou e yo. Xel ngenong betiwou e, me moxo wong xel dalus xe vanei ma, ");
INSERT INTO tbx_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","de peti xel bei eti se neil e teyei bei e eti. ");
INSERT INTO tbx_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kwa tine la teyei lek vati wei Anutu neil eivek poropet Yesaya mya yo. ");
INSERT INTO tbx_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wei, inye a xe xukxe tiwei a beyal o, a laleing vind e me na wo xeinglala en e. Tyek a toung a xe Laweeng lek e, me moxo tyek baluk en kwa bombek wei moux alis vex wei tembuing sapa yo. ");
INSERT INTO tbx_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Tyek moxo se neil qayeeng is lalei vanei me taxe niseikeing, me xelti tyek se ngo e vya eivek sakwaing mema nayak on. ");
INSERT INTO tbx_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Wangwei ghet na pyaw nayaka eno tyek se pyaw veil, me wangwei lam bo lu bandaing tyek moxo se nyeis lam amey, qe ka e menyex wou sakwaing bombek me e bo neing lek. ");
INSERT INTO tbx_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Eivek e lei eno xomaxoneing eivek tembuing bamba tyek na toung mend en e.” ");
INSERT INTO tbx_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Woyom xel qou tambiy wei memo wong e ma tuzeyi me myatu yo me lam wou Yesu, me e wong moxo wo nimzalek, en kandek moxo teyei bei baluk me gyeina. ");
INSERT INTO tbx_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Xomaxoneing dalus etek me neil, “Beip inye Dawit Neu Moux?” ");
INSERT INTO tbx_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ekom gyeik xel Parisi ngo tine, xel neil, “Tambiy tine mi tiy memo en nikanzek wei Belsebul o, lukanzek wei xel memo yo.” ");
INSERT INTO tbx_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu woulek xel xe woueing nalei om neil wou xel, “Tete lalei dalus wei dembuma yo tyek bo nol wouma, me beyeeng ngandoung o xomek ti dembuma on tyek se bale nikanzek. ");
INSERT INTO tbx_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Wangwei Sandang na tiy Sandang na veil, on moxo dembu venaxow. Woyom nambei nya moxo xe tete lalei tyek bale nikanzek? ");
INSERT INTO tbx_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Me wangwei a tiy memo na veil angya Belsebul nikanzek nei, ond eti mi vind xel wei xam o me xel mi tiy memo yon la myayaing? Om xel wei xam eno tyek talex wou xam bei qayeeng wei xam on se la wo bombek. ");
INSERT INTO tbx_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ekom wangwei a tiy memo yon na veil nangya Anutu xe Laweeng, woyom Anutu xe tete lalei eno lam wou xam woy. ");
INSERT INTO tbx_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nambei nya tambiy ti teyei bei na eivek tambiy wei nikanzek o beeng me na qou e xe lulul, ka e tup tambiy nikanzek on bole? Woyom e teyei bei na panax lulul eivek e xe xomek. ");
INSERT INTO tbx_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Moux wei se mindei is ay, eno inye mi wo vevek wou ay, de tambiy wei se mi qekuwou moux alis vex is ay eno mi tiy xel lala. ");
INSERT INTO tbx_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Om a neil wou xam bei, sewokeing tambak me qayeeng lukeingyak wei xomaxoneing mi wong eno Anutu teyei bei semaleeng veil, ekom tambiy ti embei baluk yak lek Laweeng Vambuing eno e xe nilul on tyek se semaleeng veil. ");
INSERT INTO tbx_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tambiy ti embei baluk qayeeng nilul lek Xomaxoneing Neu Moux on tyek semaleeng veil, ekom xelti embei baluk nilul lek Laweeng Vambuing on tyek nilul wei e yon se teyei bei semaleeng veil, eivek bouk tine me bouk loxyus wei di lam o is. ");
INSERT INTO tbx_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Wangwei xax on nimza, ond tyek neing on bo nimza is, o wangwei xax on bo nilul on tyek neing on bo nol is ambei nyon, en xel mi woulek xax lek e neing. ");
INSERT INTO tbx_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Xam on myeiy nilul neuyeiw, nambei nya tyek xam baluk qayeeng nimza? En qayeeng mi lam veil xomaxoneing laleind me xel myend mi luk. ");
INSERT INTO tbx_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Xomaxoneing wei nimza eno tyek bo lulul nimza wei mindei eivek e lalei yo, dom xomaxoneing wei nilul eno tyek bo lul wei nilul wei toundei eivek e yo nam myayaing. ");
INSERT INTO tbx_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ekom a neil wou xam bei gyeik Anutu embei daxe xomaxoneing, xel eti yeiw wei mi neil qayeeng bandabanda dalus eno xel a tul pavulek wei xel o teyei. ");
INSERT INTO tbx_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","En wamaxow xe qayeeng eno tyek Anutu na neimbei wa bombek, de wamaxow xe qayeeng eno tyek na neimbei wa tambiy nilul.” ");
INSERT INTO tbx_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Woyom xel Parisi valu me putoung wei petieing o neil wou Yesu, “Putoung, xa bei ghei dee wei lulvako valu wou wang.” ");
INSERT INTO tbx_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Moxo lewexe, “Xel moux alis vex nilul wei bouk tine wei mi toung demind wou Anutu yo eno mi teling en dee wei lulvako! Ekom xel se teyei bei gyei dee ti, qe tyek xel gyei dee wei poropet Yona yo. ");
INSERT INTO tbx_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","En Yona toundei bendiyeing yal me boukeing yal eivek woing ngandoung on bambou, om Xomaxoneing Neu Moux tyek mendei bendiyeing yal me boukeing yal eivek tembuing lalei. ");
INSERT INTO tbx_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Lek bouk wei ngoeing qayeeng eno xel wei Niniwe tyek qandi me bale me bo qayeeng en xomaxoneing wei gweimbeeng ne me na neil xel xe nilul teyei, en xel pekwi xow gyeik ingwei Yona la neil xoulek o. Wei, gweimbeeng tambiy ti ghanaw Yona veil, eno lam toundei inye. ");
INSERT INTO tbx_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kwin wei xonei eno tyek nam bale lek qayeeng is xel wei gweimbeeng ne me bo qayeeng en xel, en vexo lam anghei tembuing myasepu bei nam a ngo Salomo xe kwa nimza. De gweimbeeng ne tambiy ti ghanaw Salomo eno lam toundei inye. ");
INSERT INTO tbx_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Gyeik laweeng nilaxes lam myayaing veil xomaxoneing ti, eno la eivek beyeeng bandaing me yimexe beyeeng wei embei na qou laweeng o ekom se yeiwou ti. ");
INSERT INTO tbx_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Woyom neil, ‘Tyek a nox mena beyeeng wei a ghanaw o.’ Gyeik e lam tyip me yei xomek wei xelti se qou yo. Eno xel pepa e wo vako me vunekwou e wo nimza. ");
INSERT INTO tbx_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Woyom moxo la me qou laweeng lim yuw ba wei nilul ayang ghanaw e yo, me xel la lalei me dei inyon. Om tambiy tiyon xe deing wo nilul ghanaw ingwei mindei tax o. Inyon tyek bong ambei kayon wou xel nilul wei gweimbeeng ne yo.” ");
INSERT INTO tbx_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Gyeik Yesu di luk is xel qendu yon, moxo ta me liyeiw moux toukale myayaing, en xel embei baluk is e. ");
INSERT INTO tbx_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Xel ti neil wou e, “Wa tam me limyeiw moux lam toukale myayaing, en xel embei baluk is wang.” ");
INSERT INTO tbx_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu neil elox wou e, “A tang eti, me a lingyeiw eti?” ");
INSERT INTO tbx_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Om seloung mema la wou e xe betiyeingyeiw, me neil, “Inye a tang me a lingyeiw moux. ");
INSERT INTO tbx_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","En eti yeiw wei mi betiwou Mang wei toundei eivek tyoung gheyapu yo lalei yond inyon a ling moux me a ling vex me a tang.” ");
INSERT INTO tbx_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lek bouk kayon eno Yesu la myayaing veil xomek me la toundei wou lounyeing vi. ");
INSERT INTO tbx_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","De xel qendu ngandoung ti qekuma vivekwou e om moxo lek la eivek bot ti me la dei eivek lalei, de xomaxoneing dalus on toukale nenyawes. ");
INSERT INTO tbx_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Woyom moxo neil lulul ngenong wou xel eivek qayeeng pakeing, me neil, “Xukana ti la vuw lul vei eivek xuk. ");
INSERT INTO tbx_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ka moxo di vuw lul vei lala, eno valu teila lek sakwaing, me menek menek lam ya e ma. ");
INSERT INTO tbx_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","De valu teila lek tembuing wei qakous o, en inyon tembuing nayaka toundei lek qakous mapu yon. Om belup daing me lam, en nambei tembuing on se la ghembi. ");
INSERT INTO tbx_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ekom gyeik ingwei seiv leklam nale ghey, eno seiv leis vei yuvek lek me mupek, en luselis ma veil. ");
INSERT INTO tbx_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","De vei valu teila senghoing eivek qeis wei yingying o om tyip me sevunexe lulul vei yon. ");
INSERT INTO tbx_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","De vei valu teila lek tembuing nimza, me vuk neing teyei lek 100, me valu vuk 60 de valu 30 inye vati wei ev o. ");
INSERT INTO tbx_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Eti nenya nale lek e, ond wong e ngo.” ");
INSERT INTO tbx_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Xel betiyeing lam wou e me teling, “Nambei nya wang mi luk is xomaxoneing eivek qayeeng pakeing?” ");
INSERT INTO tbx_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Moxo neil elox bei, “Lupeyei nimza wei tete lalei wei tyoung gheyapu wei mi yeip xupekeing eno Anutu wong wou xam dom se wong wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Eti yeiw wei liw nenyend wou a xe qayeeng petieing on tyek lupeyei gyeip yaing wou xel, me xel a qou lupeyei ngenong is. Ekom xel wei se mi ngo, eno lupeyei nayak wei xel qou yon eno tyek Anutu bouveil xel. ");
INSERT INTO tbx_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","En qes tine om a mi luk wou xel eivek qayeeng pakeing. “Xel mendghalus tyek gyei, ekom tyek xel se gyei lulti. Me xel a ngo, ekom tyek xel se ngo wou me boulek qayeeng qes. ");
INSERT INTO tbx_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Om xel wong qayeeng wei poropet Yesaya neil eno wo neing lek. “ ‘Tyek xam a ngo qayeeng lumama ekom tyek xam seng boulek. Tyek xam a mi gwei lumama ekom tyek xam seng gwei lulti. ");
INSERT INTO tbx_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","En xel xomaxoneing tine laleind wo nikanzek, me xel on nenyend wo qatu me xel mendghalus on tuzeyi. Enok xel gyei nangya mendghalus, me na ngo gya nenyend, me boulek eivek naleind me pekwi me noum, de tyek a bong xel bo nimzalek.’ ");
INSERT INTO tbx_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ekom xam Anutu e bong mata wou xam, en nambei xam mamimghalus yei ay me nambei xam nenyamim ngo wou qayeeng. ");
INSERT INTO tbx_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","A neil wou xam zonghek bei xel poropet ngenong me xel moux wei bombek eno embei gyei vati wei xam ghe wei gweimbeeng ekom xel se yei, me xel embei ngo vati wei xam ghe ngo gweimbeeng ekom xel se ngo. ");
INSERT INTO tbx_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Woyom ngo wou vati wei qayeeng pakeing neil en xukana vuw vei eno qes. ");
INSERT INTO tbx_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Gyeik xelti embei ngo qayeeng ne en tete lalei me se boulek nei, on tambiy ka nilul eno lam me tetei vati wei xend eivek e lalei yo veil. Vei tine inye vei wei vuw lek sakwaing o. ");
INSERT INTO tbx_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","De vei wei teila lek tembuing wei qakous qakous, eno inye tambiy wei ngo qayeeng me lutika eno qou is lalei nimza me wo xeilala yo. ");
INSERT INTO tbx_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ekom luselis wei e yo ma om nale nayaka. Gyeik nimaying wei xel mi pesek qayeeng o nimaying wei xomaxoneing wo nol wouma en Anutu xe xoulek eno lam, lutika eno moxo saing e xe wongeingis. ");
INSERT INTO tbx_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","De vei wei teila eivek qeis wei yingying o, eno inyon tambiy wei ngo qayeeng, ekom wounalei en mapieing tine me lul dalus wei tembuing eno sevunexe om se vuk neing. ");
INSERT INTO tbx_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ekom vei wei teila lek tembuing nimza yon, inyon tambiy wei ngo qayeeng me woulek. Moxo vuk neing teyei lek 100 o 60 o 30 inyon vati wei xend o.” ");
INSERT INTO tbx_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu neil qayeeng pakeing nge wou xel no. “Tete lalei wei tyoung gheyapu yon nambei tambiy ti vuw vei nimza eivek e xe xuk o. ");
INSERT INTO tbx_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ekom ka xel dalusateiv yeip, e xe xel vevek amba lam me vuw vyaing eivek wit masenghoing dom la veil. ");
INSERT INTO tbx_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ka wit tyip me lu belup, woyom vyaing tyip is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Xukma xe xukxe lam wou e me neil, ‘Teiv, beip wa seng vuw vei nimza eivek wa xe xuk? De woyom vyaing beimambei ne lam anghei inya?’ ");
INSERT INTO tbx_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Moxo neil elox bei, ‘Vevek amba ti lam wong tine.’ “Xel xukxe teling wou e, ‘Wambei xa na me na puw veil?’ ");
INSERT INTO tbx_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Moxo lewexe bei, ‘Ma, en nambei wa bei puw vyaing eno tyek wa puw wit luselis is. ");
INSERT INTO tbx_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wong luw xouing ling deka bouk wei qoueing neing o le. Lek bouk kayon eno tyek a neil wou xel wei mi qou neing o, “Xam a puw vyaing atax me na tup buing en nyuweing, woyom xam qeku wit me na qou me nam eivek a xe xomek yaeing.” ’ ” ");
INSERT INTO tbx_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Moxo neil qayeeng pakeing nge wou xel no: “Tete lalei wei tyoung gheyapu eno nambei mastet vei, wei tambiy ti qou me xen eivek e xe xuk o. ");
INSERT INTO tbx_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Inyon nayakameng ka veil vei dalus, ekom gyeik ingwei tyip ngandoung, inyon ling ngandoungateiv ghanaw lul dalus wei ev eivek xuk me wong ngandoung nambei xax, omek menek menek wei senghoing bandaing nei mi lam me qo lewis lek mema mema.” ");
INSERT INTO tbx_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu lox neil qayeeng pakeing nge no, “Tete lalei wei tyoung gheyapu yon nambei yis wei xel vex mi qou me maleeng eivek palawa me wong palawa vuklek me wo ngandoung.” ");
INSERT INTO tbx_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu mi luk ti beimambei ne dalus wou xel qendu ngandoung on eivek qayeeng pakeing. Moxo se mi neil qayeeng ti yeipyaing wou xel qe mi neil eivek qayeeng pakeing. ");
INSERT INTO tbx_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Om nambei nyon kwa tine la teyei lek lulti Anutu neil eivek poropet mya. “Tyek a tax myang en neileing qayeeng pakeing. Tyek a neil pavulek en lul leimalei wei mindei xupekeing takwei wei tembuing lam nale yanyateiv o me elam gweimbeeng ne.” ");
INSERT INTO tbx_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Woyom moxo ghanaw xel qendu yon me la eivek xomek. E xe xel betiyeing lam wou e me neil, “Neil e yeip yaing wou xa en qayeeng pakeing qes wei vyaing tyip eivek xuk o.” ");
INSERT INTO tbx_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Moxo lewexe bei, “Tambiy tiwei vuw vei nimza yon, inyon Xomaxoneing Neu Moux. ");
INSERT INTO tbx_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Xuk on tembuing sapa, de vei nimza yon teyei lek neuyeiw wei tete lalei yo. De vyaing on Sandang neuyeiw, ");
INSERT INTO tbx_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","me vevek amba wei vuw xel on inye tambiy kawei mapetok o. De bouk wei qoueing neing on inyon bouk wei embei na tip lek o, de xel wei embei qou neing eno inye xel angela. ");
INSERT INTO tbx_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Ka xel a puw vyaing me banyuw lek nenyex, yon tyek xel bong ambei nyon lek bouk loxyus. ");
INSERT INTO tbx_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Xomaxoneing Neu Moux tyek bong e xe xel angela na myayaing nei, me tyek xel a puw lul dalus wei mi wong sewokeing mi tyip o me xel dalus wei mi wong nilul ayang eno veil e xe tete lalei. ");
INSERT INTO tbx_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tyek xel banex xel na eivek nenyex ngandoung de nanghei inyon eno tyek xel deeng me zanga newound bo nyiknyik. ");
INSERT INTO tbx_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Woyom xel wei bombek o tyek na siing ambei sayeiv eivek tete lalei wei xel Mend xe yo. Tambiy ti nenya nale lek e, ond wong e ngo. ");
INSERT INTO tbx_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Tete lalei wei tyoung gheyapu nei nambei xel vun qoupek wei malew eivek xuk ti. Gyeik tambiy ti yeiwou, eno la vun no, de woyom moxo wo xeilala me la wong vateivek lek lul dalus wei e yo dom la xouv xuk tiyon. ");
INSERT INTO tbx_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Nge no, tete lalei wei tyoung gheyapu eno nambei tambiy wei mi wo vateivek lek lulul o ti eno di yimexe viyaviy nimzamza. ");
INSERT INTO tbx_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Gyeik moxo yeiwou ingwei nimza maseim o ti, moxo la me wong vateivek lek e xe lul dalus de la xouv. ");
INSERT INTO tbx_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Nge no, tete lalei wei tyoung gheyapu yon nambei lewek wei xel nex e teila eivek lounyeing me qou woing leimalei dalus o. ");
INSERT INTO tbx_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Lewek on pup, xel wei mi qou woing eno puw e leklam yasewis. Woyom xel dei tembuing me beyal woing wei nimza me toung eivek pasik ngenong, dom xel nex nilul o la. ");
INSERT INTO tbx_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tine inye vati wei tyek qandi lek bouk loxyus o. Angelayeiw tyek nam me beyal xel wei nilul o veil xel wei bombek o ");
INSERT INTO tbx_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","me banex xel na eivek nenyex ngandoung wei tyek xel na mi deeng me zanga newound bo nyiknyik o.” ");
INSERT INTO tbx_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu teling, “Xam ghe woulek lul dalus ti beimambei ne?” Xel lewexe, “Ee.” ");
INSERT INTO tbx_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Moxo neil wou xel bei, “Nambei nyon xel putoung tambak wei petieing wei woulek tete lalei wei tyoung gheyapu eno nambei xomek ti ma wei qou e xe lul wei xomek vateivek o me lul wei takwei me vako eno is me qou de lam myayaing.” ");
INSERT INTO tbx_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu neil qayeeng pakeing ti beimambei ne ma, moxo la veil inyon. ");
INSERT INTO tbx_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Moxo la beeng qes, me teyoxe xomaxoneing eivek xel xe xomek qekueing ama, om xel etek. Xel neil, “Xomaxoneing ne qou kwa ti beimambei ne nanghei inya me di wong lulvako ne? ");
INSERT INTO tbx_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Beip inye se kamunda neu? De ta se lei Maria, me Jems, me Yosep me Simon me Yudas eno se e liyeiw? ");
INSERT INTO tbx_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Beip inye e liyeiw vex se toundei is xey? Woyom moux tine qou lulti beimambei ne dalus nanghei inya?” ");
INSERT INTO tbx_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","De xel laleind wo maying en e. Ekom Yesu neil wou xel, “Eivek e maxow beeng qes me eivek e maxow xe xomek inyon poropet wei lei maeing o.” ");
INSERT INTO tbx_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Om moxo se wong lulvako ngenong ti nanghei inyon, en nambei xel xe wongeingis eno ma. ");
INSERT INTO tbx_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lek bouk kayon eno Herot seyap tiwei tax o ngo qayeeng en Yesu, ");
INSERT INTO tbx_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","om neil wou e xe xel xukxe bei, “Tambiy tine inye Yoan lipekeing. Moxo qandi veil meyeing! Qes tiyon om qou nikanzek me di wong lulvako tine.” ");
INSERT INTO tbx_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Takwei eno Herot zeimaxoun Yoan me tup e dom toung e eivek xeitueing en Herodias, li Pilip venei, ");
INSERT INTO tbx_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","en nambei Yoan neil wou moxo, “Inye se nimza bei wa qou lim Pilip venei.” ");
INSERT INTO tbx_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot embei nyeis Yoan, ekom moxo yaleeng en xel xomaxoneing on, en inye xel wou kwend bei tambiy on poropet ti. ");
INSERT INTO tbx_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Lek Herot xe bouk wei umbek lek eno lam om Herodias neu vexawo yon lam aw om Herot wo xeilala me lalei vind vexo, ");
INSERT INTO tbx_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","om wong qayeeng neing is nikanzek wou vexo bei tyek bong vati wei embei teling eno wou e. ");
INSERT INTO tbx_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Lek ta xe woueing nalei, vexo neil, “Wang bong Yoan lipekeing lukanzek wou ay lek dipekta ne.” ");
INSERT INTO tbx_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","King moxo lalei wo nimaying, ekom e xe qayeeng wei neil zonghek is vexo me e xe xel wei lam en yaeing o, om moxo neil wou e xe xel bei vexo xe telinyeing embo neing lek ");
INSERT INTO tbx_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","om wong xel la qateiv Yoan kwa tip eivek xomek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Moxo lukanzek eno xel toung lek dipekta me qou me la wong wou vexawo yon, de vexo qou me la wong wou ta. ");
INSERT INTO tbx_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yoan xe xel betiyeing lam me qou e neing me la ev. Woyom xel la neil wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu ngo vati wei belup on, moxo la veil beyeeng me la lek bot me la ingwei xel ma veil o. Xel qendu ngandoung on ngo tine me betiy e me la vaxend nanghei beyeeng nayak ngenong on. ");
INSERT INTO tbx_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu teila me yei xel qendu ngandoung on, moxo lalei pyaxow en xel om wong xel xe vanei wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ka ingwei di souk o, xel betiyeing lam me neil wou e, “Beyeeng bandaing tine xel ma veil, de moxo di bouk tiyo inye mouyo. Wong xel qendu ngandoung on la, en kandek xel na beyeeng nei me na bou xend yaeing valu yo.” ");
INSERT INTO tbx_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu neil elox, “Xel na enva? Xam ghe bong lul yaeing valu wou xel en xel gya.” ");
INSERT INTO tbx_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Xel neil wou e, “Yaing ngenong ma veil xa yo, inye belet lim de woing yuw xemou.” ");
INSERT INTO tbx_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Moxo neil, “Xam qou dalus me lam inye wou ay.” ");
INSERT INTO tbx_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","De moxo neil wou xomaxoneing on bei xel mendei tembuing lek lesilek on. Moxo qou belet lim on me qou woing yuw on is dom yeila tyoung gheyapu nei, me wo dange wou dom dembu. Woyom wong wou e xe xel betiyeing, me xel betiyeing wong wou xel xomaxoneing on. ");
INSERT INTO tbx_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Xel dalus on ya me enden xel, de xel betiyeing qekuwou myapapu wei xel se ya yo eivek pasik xoumeeng yuw. ");
INSERT INTO tbx_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Xel moux wei ya yaeing on teyei lek 5,000. Xel se pyaw memend wou xel vex alis neundyeiw. ");
INSERT INTO tbx_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lutika eno Yesu wong xel betiyeing la eivek bot me la tax en e me la nge loxalu, dekakom wong xel qendu ngandoung on la. ");
INSERT INTO tbx_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ka ingwei wong xel on la woy, moxo venaxow lek la lukendu bei na zeimema. Gyeik ingwei boukeing di lam eno e maxow toundei inyon, ");
INSERT INTO tbx_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ekom bot vena la dingta takwei nei veil tembuing, me laweeng vei mamileeng vuk me lam leislek bot is xel. ");
INSERT INTO tbx_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ka embim boyaing eno Yesu di la wou xel, me la lek lounyeing mapu. ");
INSERT INTO tbx_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Xel betiyeing yei moxo di la lek lounyeing mapu, om xel yaleeng me neil, “Inye memo ti nu.” Om xel yaleeng me nyayek. ");
INSERT INTO tbx_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ekom Yesu wo daing me neil wou xel, “Xam nale nimkanzek! Inye ay yo. Om xam seng gwaleeng.” ");
INSERT INTO tbx_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petele neil elox bei, “Tambiy Ngandoung, wangwei inye wang nei, ond neil me a lak wou wang lek memiing on.” ");
INSERT INTO tbx_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Moxo neil, “Lam.” Woyom Petele teila veil bot, dom la lek memiing mapu me la wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ekom moxo yei laweeng, moxo yaleeng mouyo, me di teila eivek manghembi, om taxe niseikeing, “Tambiy Ngandoung, vind ay!” ");
INSERT INTO tbx_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Lutika eno Yesu tatei mema la me vyex e. Moxo neil, “Wa xe wongeingis on nayaka. Wa laleim on wo yuw enva?” ");
INSERT INTO tbx_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Woyom luw lek la eivek bot, de laweeng on mey. ");
INSERT INTO tbx_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Woyom xel wei toundei eivek bot on wong lalo wou e, me neil, “Neing ayang wang on Anutu Neu Moux.” ");
INSERT INTO tbx_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ka xel la nge loxalu, xel teila Genesaret. ");
INSERT INTO tbx_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Xel xomaxoneing wei beyeeng on woulek Yesu, xel wong qayeeng la wou xel xomaxoneing wei mindei paviy beyeeng dalus on. Xomaxoneing dalus on qou xel xe xel wei vanei yo me lam wou e ");
INSERT INTO tbx_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","me tay wou e bei xel mou daxlek e xe teimb myasepu, me eti yeiw wei axlek e eno wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Woyom xel Parisi valu me xel putoung wei petieing eno lam anghei Yerusalem me lam wou Yesu me teling, ");
INSERT INTO tbx_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nambei nya wa xe xel betiyeing mi pyalek petieing wei buyeiw xe kwa wei takwei yo? Xel se mi sekweyexe memend atax ekom mi ya xend yaeing!” ");
INSERT INTO tbx_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu neil elox bei, “De nambei nya xam ghe pyalek qayeeng petieing wei Anutu xe yo en xam bumim venaxow xe kwa yon? ");
INSERT INTO tbx_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","En Anutu neil, ‘Wa mi gwevek mam aluw tam xe qayeeng’ me ‘Xel tiwei embei neil vyalek ma luw ta eno xel nyeis e mey.’ ");
INSERT INTO tbx_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ekom xam ghe mi neimbei wangwei tambiy ti e neil wou ma luw ta, ‘Vati wei ambei devind muw eno a beyal wou Anutu takwei nei,’ ");
INSERT INTO tbx_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","tambiy moxo tyek se gwevek ma no. Lek kwa tiyon xam ghe mi toung demimim wou Anutu dom ghe mi sanghoxe lul wei xam bumimyeiw o. ");
INSERT INTO tbx_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Xam wei myamim yuw o! Poropet Yesaya neil zonghek gyeik moxo neil en xam xe kwa yo. ");
INSERT INTO tbx_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Xomaxoneing ti beimambei ne mi pamilexe ay en myend, ekom xel laleind on toundei dingta en ay. ");
INSERT INTO tbx_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xel mi wong lalo wou ay bandaing, en xel xe teyoxeing ekom xel xe petieing yon lam wou xomaxoneing.’” ");
INSERT INTO tbx_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Yesu taxe xel qendu yon lam wou e me neil, “Xam a ngo me ghe boulek. ");
INSERT INTO tbx_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Vati wei mi la eivek eti yeiw myend eno se mi wong e wo nilaxes, qe vati wei lam myayaing veil e mya, eno mi wong e wo nilaxes.” ");
INSERT INTO tbx_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Woyom xel betiyeing lam wou e me teling, “Beip wa seng woulek bei xel Parisiyeiw laleind wo myavanei gyeik xel ngo qayeeng tine yo?” ");
INSERT INTO tbx_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Moxo neil elox bei, “Lul dalus wei Mang wei toundei eivek tyoung gheyapu nei se ev eno tyek xel a puw is luselis. ");
INSERT INTO tbx_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wong xel toukale. Xel on mend tuzeyi. Wangwei tambiy wei matekeing o natax en moux wei matekeing, luw xouing tyek deteina eivek leiveeng.” ");
INSERT INTO tbx_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petele neil, “Neil qayeeng pakeing tine qes wou xa.” ");
INSERT INTO tbx_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu teling wou xel, “Beip xam se ghei woulek no? ");
INSERT INTO tbx_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Xam seng wei bei vati wei mi la eivek xomaxoneing myend me la eivek e xeita de woyom lam myayaing veil e me la eivek leiveeng? ");
INSERT INTO tbx_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ekom vati wei lam myayaing veil wa myam inyon lam anghei wa laleim nei, me ti beimambei ne mi wong xomaxoneing mi wo nilaxes. ");
INSERT INTO tbx_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Inyon woueing nalei nilul, leiseing xel, kwa nilul wei iingama, kwa nilul wei kwapesiv o, panaxeing, qayeeng tyonyeing me lukyak lek xel nge eno lam myayaing veil xe laleind. ");
INSERT INTO tbx_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Lulti beimambei ne ingwei mi wong xomaxoneing mi wo nilaxes, ekom yaeing is memend laxes eno se mi wong e wo nilaxes.” ");
INSERT INTO tbx_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu la veil beyeeng tiyon me la tembuing danghei wei Taia me Saidon nei. ");
INSERT INTO tbx_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kenan vex ti lam wou e, me di eng niseikeing, “Tambiy Ngandoung, Dawit Neu Moux, pyanaleim en ay! A neung vex toundei eivek nimaying ngandoung en memo wo nilul wou e.” ");
INSERT INTO tbx_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yesu se neil qayeeng ti lox. Om e xe xel betiyeing lam wou e me neil, “Wong vex on la, en vexo di eng xounaxoun me lam yus en xey.” ");
INSERT INTO tbx_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Moxo lewexe, “Anutu wong a lam en xel sipsip wei Israel o venaxow wei lati yo.” ");
INSERT INTO tbx_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Vex on lam me ev vaxakatu eivek atax wou e de neil, “Tambiy Ngandoung, vind ay!” ");
INSERT INTO tbx_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu neil elox bei, “Inye se nimza bei qoueing yakyak xe belet me banex e na wou xel naw.” ");
INSERT INTO tbx_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Vexo neil, “Ee, Tambiy Ngandoung, ekom xel naw mi ya myapapu wei mi teila eivek xel xe teiv xe lelek xeinghembi yo.” ");
INSERT INTO tbx_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Woyom Yesu lewexe, “Vex, wa xe wongeingis on ngandoung! Wa xe telinyeing on embo neing lek nambei wa laleim vind o.” Om neu vex on wo nimzalek seivma kayon bombek. ");
INSERT INTO tbx_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu la veil beyeeng tiyon dom la lounyeing Galili. Woyom moxo lek la lukendu nenya me dei tembuing. ");
INSERT INTO tbx_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Xel qendu ngandoung on lam wou e, xel qou xel bezombeing, me matekeing, vaxa nol, me myatueing me xel valu beti is me toung xel wou Yesu vaxa, de e wong xel wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Xel xomaxoneing on etek en ingwei xel yei tambiy wei myatu eno luk no, me xel bezombeing wo nimzalek, me vaxa nol la me ingwei matekeing eno yeila. Me xel sanghoxe Anutu wei Israel o. ");
INSERT INTO tbx_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu taxe e xe xel betiyeing la wou e me neil, “A laleing pyaxow en xel xomaxoneing ti beimambei ne, en xel lam toundei inye is ay teyei lek bouk yayal de xel se ya lulti. Ambei se bong xel na maxep, enok xel mend bivek me pewilexe wou sakwaing.” ");
INSERT INTO tbx_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","E xe xel betiyeing lewexe, “Tyek xa qou belet anghei inya me na bong wou xel ngenong ne eivek beyeeng bandaing ne?” ");
INSERT INTO tbx_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu teling, “Xam ghe di qou belet vamva?” Xel neil elox bei, “Lim yuw, de woing nayak matika is.” ");
INSERT INTO tbx_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Moxo neil wou xel qendu yon bei xel mendei lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Woyom qou belet lim yuw on is woing, de wong dange wou woy, om dembu me wong wou xel betiyeing, me xel la wong wou xel xomaxoneing on. ");
INSERT INTO tbx_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Xel on dalus ya me enden xel. Dekalekom xel betiyeing qekuwou myapapu wei wo pupuv o me sei ela eivek pasik lim yuw me e pup. ");
INSERT INTO tbx_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Xel wei ya yaeing on teyei lek 4,000. De xel se pyaw memend wou vex alis neuyeiw. ");
INSERT INTO tbx_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ka Yesu wong xel on la, moxo la eivek bot me la beyeeng wei Magadan nei. ");
INSERT INTO tbx_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Xel Parisi me xel Sadyusi lam wou Yesu me wo axeing wou e me teling wou bei e talex dee wei tyoung gheyapu nei ti wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Moxo neil elox bei, “Gyeik soukeing lam, eno laxap wo gyand om xam ghe neimbei ‘Inye tyek bo nimza,’ ");
INSERT INTO tbx_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","de satiboukeing lul eno xam ghe neimbei, ‘De wangwei sayeiv nam a tyip, me na siing lek tyoung me wo gyand ekom laxap wo xeingak me sevun tyoung, woyom xel woulek bei laweeng tyek na tyip me luing detei.’ Xam ghe mi wei dee wei tyoung me ghe woulek ewo nimza, ekom nambei nya xam seng woulek dee wei bouk ti gweimbeeng ne yo. ");
INSERT INTO tbx_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Xel moux alis vex nilul wei bouk tine wei mi toung demind wou Anutu yo eno xel embei gyei dee wei lulvako yo, ekom xel se teyei bei gyei dee ti qe dee wei poropet Yona yo.” Woyom Yesu la veil xel me la. ");
INSERT INTO tbx_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Gyeik xel betiyeing la is Yesu me la lounyeing nge loxalu, xel naleind ma me se qou belet ti. ");
INSERT INTO tbx_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu neil wou xel, “Xam ghe gweiteyei xow en yis wei xel Parisi me Sadyusiyeiw o.” ");
INSERT INTO tbx_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Xel neil tine eivek ama senghoing me neil, “En inye nambei xey se qou belet ti.” ");
INSERT INTO tbx_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu woulek xel xe qayeeng wei xel di luklek on om neil wou xel, “Xam xe wongeingis on nayaka. Nambei nya xam ghe di pyalek ama en ingwei belet ma yo? ");
INSERT INTO tbx_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Beip xam seng ghei woulek? Beip xam seng wou naleimim en belet lim wei xel xomaxoneing 5,000 ya yo, me pasik vamva wei xam ghe qekuwou yo? ");
INSERT INTO tbx_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","O belet lim yuw wou xel 4,000, me pasik vamva wei xam ghe qekuwou yo? ");
INSERT INTO tbx_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nambei nya xam seng woulek bei a se di luk wou xam en belet om a neil qayeeng tine wou xam? Ekom xam ghe gweiteyei xow en yis wei xel Parisi me Sadyusiyeiw o.” ");
INSERT INTO tbx_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Woyom xel woulek bei moxo se di teling xel bei xel gyei xow teyei en yis wei xel mi toung eivek belet o, qe en teyoxeing wei xel Parisi me Sadyusiyeiw o. ");
INSERT INTO tbx_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu la eivek tembuing danghei wei Sisalia Pilipai eno moxo teling wou e xe xel betiyeing, “Xel xomaxoneing mi neil embei Xomaxoneing Neu Moux on eti?” ");
INSERT INTO tbx_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Xel neil elox bei, “Xel valu mi neil embei wa Yoan lipekeing. De valu mi neil embei wa Eliya, me valu mi neil embei wa Yelemia o tambiy wei poropet o ti.” ");
INSERT INTO tbx_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Om moxo teling xel, “ekom xam ghe neimbei ay eti?” ");
INSERT INTO tbx_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petele lewexe, “Wang on Kilisi, Anutu mapieing neu moux.” ");
INSERT INTO tbx_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu neil elox, “Simon Yona neu, mata e nak wou wang, en xomaxoneing ti se neil inye teyei wou wang, qe inye lam wou Mang wei toundei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","De a neil wou wang bei wang on Petele qes bei qakous, me lek qakous tine tyek a bong a xe xel wongeingis bo ngenong, me bale nikanzek lek e de nikanzek wei meyeing eno tyek se nam lelolexe inyon. ");
INSERT INTO tbx_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tyek am bong ki wei tete lalei wei tyoung gheyapu nei eno wou wang, om vati wei wambei tup lek tembuing eno tyek Anutu na tup anghei tyoung gheyapu nei, de vati wei wa tul lek tembuing ne eno tyek Anutu na tul veil anghei tyoung gheyapu nei.” ");
INSERT INTO tbx_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Woyom moxo peti e xe xel betiyeing bei xel se neilteyei bei e Kilisi. ");
INSERT INTO tbx_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Qandi eivek bouk kayon eno Yesu neilteyei wou e xe xel betiyeing bei tyek na Yerusalem me na qou myavanei ngenong lek xel teivateiv me xel lumuki leitata me xel putoung wei petieing o memend, me xel nyeis e mey de lek bouk yal eno moxo tyek qandi lek veil meyeing. ");
INSERT INTO tbx_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Om Petele qou moxo me la nenyawes me luk niseikeing atax wou e, “Tambiy Ngandoung, se teyei ti! Lul tine tyek se belup wou wang!” ");
INSERT INTO tbx_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu pekwi ma me neil wou Petele, “Sandang, la a deming! Wambei bale zeyi ay. Wa lum on se betiwou lulul wei Anutu yo, qe lulul wei xomaxoneing o.” ");
INSERT INTO tbx_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Woyom Yesu neil wou e xe xel betiyeing, “Wangwei tambiy ti embei betiwou ay, ond e dax xow vun dom qalei e xe xax pepeeng me betiwou ay. ");
INSERT INTO tbx_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","En wangwei xelti embei zeimaxoun e xe mapieing yond tyek na saing veil, ekom xelti embei saing e xe mapieing en ay eno tyek na qou e xe mapieing. ");
INSERT INTO tbx_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wangwei tambiy ti e qou lul dalus wei tembuing sapa ne yo, dom na saing ning mapieing, on tyek na qou lul nimza vati? Moux on tyek bo xouveing vati zeyi ning nu pieing? ");
INSERT INTO tbx_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","En Xomaxoneing Neu Moux tyek nam is Ma xe xeiyaing ngandoung is e xe xel angela, de woyom moxo tyek bong xouveing wou xel titi teyei lek vati wei xel mi wong o. ");
INSERT INTO tbx_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","A neil wou xam zonghek, xel valu wei toukale inye eno tyek se daxe meyeing atax, qe ka xel gyei Xomaxoneing Neu Moux nam eivek e xe tete lalei le.” ");
INSERT INTO tbx_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ka bouk limti la veil eno Yesu qou Petele me Jems me Yoan inyon Jems li, me qou xel venaxow me la lek lukendu vaxading ti. ");
INSERT INTO tbx_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Nanghei inyon eno moxo neing pekwi me wo bange wou xel mend. Me ma siing nambei sayeiv me e xe teimb wo pus ambei xeiyaing. ");
INSERT INTO tbx_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Dekakom Mose luw Eliya lam tyip wou xel mendghalus me di luk is Yesu. ");
INSERT INTO tbx_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Om Petele neil wou Yesu, “Tambiy Ngandoung, inye nimza bei xey a toumendei inye. Wangwei wa laleim devind nei, on tyek a sakev xomek nayak yayal, ti wou wang, de ti wou Mose de ti wou Eliya.” ");
INSERT INTO tbx_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ka moxo di luk, laxap teltyip me lam wo tenu zeyi xel, me vya ti lam anghei laxap nei me neil, “Tine inye a neung, e tiwei a laleing vind o, a wo xeinglala en e. Om xam a mi ngo e!” ");
INSERT INTO tbx_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Xel betiyeing ngo tine me xel ev vaxend qatu eivek de mend la lek tembuing, is yalenyeing mouyo. ");
INSERT INTO tbx_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ekom Yesu lam axlek lal. Moxo neil, “Qandi lek. Mal seng gwaleeng.” ");
INSERT INTO tbx_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Om lal veil mendlek, eno lal se yei xelti, qe Yesu venaxow. ");
INSERT INTO tbx_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ka xel di lam axo veil lukendu, Yesu luk nikanzek wou xel bei, “Xam se neil wou xelti en vati wei xam ghe wei ne, qe ka Xomaxoneing Neu Moux qandi lek veil meyeing le.” ");
INSERT INTO tbx_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Xel betiyeing teling wou e, “Inye xel putoung wei petieing eno neil embei Eliya tyek nam a tax enva?” ");
INSERT INTO tbx_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu neil elox bei, “Xam ghe boulek neing bei Eliya e nam me menyex wou lulul dalus. ");
INSERT INTO tbx_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ekom a neil wou xam bei, Eliya lam takwei nei, ekom xel se woulek e, qe xel wong kwa leimalei wou e teyei lek woueing nalei wei xel o. Eivek sakwaing kayon eno Xomaxoneing Neu Moux tyek na qou nimaying ngandoung lek xel memend.” ");
INSERT INTO tbx_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Woyom xel betiyeing woulek bei moxo di luk en Yoan Lipekeing. ");
INSERT INTO tbx_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesu is betiyeing yal on la wou xel qendu yon. Moux ti lam wou Yesu me ev vaxa qatu eivek wou e manghalus. ");
INSERT INTO tbx_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Moxo neil, “Tambiy Ngandoung, wa pyanaleim en a neung moux en mi puw vaxa mema me mindei eivek nimaying. Moxo mi pewilexe eivek nenyex, o mi teila eivek memiing. ");
INSERT INTO tbx_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A qou e me na lam wou wa xe xel betiyeing, ekom xel se teyei bei bong embo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu neil elox bei, “O xam moux alis vex wei se mi wongis eno xam xe woueing nalei me kwa eno se la teyei lek. Tyek a mendei is xam bouk vamva? Me teyei lek bouk vamva eno tyek a mi qalei nimaying wei xam o? Qou ghavis on me lam wou ay.” ");
INSERT INTO tbx_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yesu neil laweeng nol on, dom e lam myayaing veil ghavis on, om ghavis on wo nimza lek seivma kayon bombek. ");
INSERT INTO tbx_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Woyom xel betiyeing venaxow lam wou Yesu me teling, “Nambei nya ekom xa se teyei bei tiy inyon na myayaing?” ");
INSERT INTO tbx_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Moxo neil elox bei, “Xam xe wongeingis on nayaka. A neil wou xam zonghek, wangwei xam xe wongeingis nayaka nambei mastet neughalus, wa teyei bei neil wou lukendu tine, ‘La veil inye me la inyei,’ on tyek na ngo me na. Lulti tyek se bo pok wou wang.  ");
INSERT INTO tbx_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ekom lul ambei nye tyek se nam myayaing, qe nangya zeimeing me vambueing yaeing.” ");
INSERT INTO tbx_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu is e xe xel betiyeing la me qekuma nanghei Galili, woyom moxo neil wou xel, “Tyek xel a toung Xomaxoneing Neu Moux na eivek xomaxoneing memend. ");
INSERT INTO tbx_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Me tyek xel nyeis e mey, de lek bouk yal eno moxo tyek qandi lek mapieing.” Xel betiyeing ngo qayeeng tine om moxoyeiw laleind wo maying. ");
INSERT INTO tbx_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Ka Yesu lis e xe xel betiyeing la tyip Kapenaom, xel wei mi qou takis wei xomek vambuing eno lam me teling wou Petele, “Beip xam xe putoung se mi toung takis wei xomek vambuing o?” ");
INSERT INTO tbx_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Moxo neil elox wou xel bei, “E, mi toung o.” Ka Petele lam eivek xomek eno Yesu luk ti myaxeeng me teling, “Simon, wang wou naleimim ambei nya? Xel king wei tembuing ne yo mi qou takis leimalei wou eti, wou xel venaxow neundyeiw, o wou xel amba?” ");
INSERT INTO tbx_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petele neil, “Wou xel amba.” Yesu neil wou e, “Om xel venaxow neundyeiw se teyei bei toung takis. ");
INSERT INTO tbx_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ekom xey se bong anghei xel laleind bo nol wou xe nei, om la lounyeing nei me nex wa xe ying la eivek. Woing tiwei wang qou tax o, wa tax e mya de tyek wangwei malew selewa ngandoung ti. Wa qou me ghe na bong wou xel en aning takis de wa nim is ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Lek bouk kayon eno xel betiyeing lam wou Yesu me teling, “Eti wo lei ngandoung eivek tete lalei wei tyoung gheyapu nei?” ");
INSERT INTO tbx_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Moxo taxe yak tika me wong e nale eivek xel senghoing. ");
INSERT INTO tbx_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","De neil, “A neil wou xam zonghek, wangwei xam se pekwi me ghe ghok ambei yak kane, on tyek xam seng teyei bei na eivek tete lalei wei tyoung gheyapu yo. ");
INSERT INTO tbx_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nambei nyon, eti yeiw wei mi beoux xow nambei yak kane eno wo lei ngandoung eivek tete lalei wei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Me eti yeiw wei qou yak ambei nye eivek a leing, eno qou ay. ");
INSERT INTO tbx_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Enok tambiy ti bong yak ti beimambei wei wongis a ne detei en sewokeing, ond inye teyei bei xel banoux qakous ngandoung lek e kwa dom banex e deteina heivek mamileeng me e mey. ");
INSERT INTO tbx_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Inye lalei pyaweing en xomaxoneing wei tembuing ne eno mi wong xel amba mi tei en sewokeing. Zonghek, lul nilul ambei nyon eno tyek nam, ekom tambiy wei wong inyon tyip eno e gyaleeng! ");
INSERT INTO tbx_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Om wangwei wa memam o wa vaxam na toung wang eivek sewokeing, ond qateiv veil me nex e la. Inye nimza bei wang na eivek mapieing luta luta is memam tixemou o vaxam tixemou, enok wa memam yuw o vaxam yuw ekom xel banex wang na eivek nenyex wei luta luta yo. ");
INSERT INTO tbx_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Me wangwei wa mamghalus na toung wang eivek sewokeing, ond qepei e lam myayaing me nex e la. Inye nimza bei wang na mendei mapieing is mamghalus tixemou enok wa mamghalus yuw ekom xel banex wang na eivek nenyex wei luta luta yo. ");
INSERT INTO tbx_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Xam ghe gweiteyei en kandek xam se neimbei yakyak ambei inye lul bandaing. En a neil wou xam bei xel xe angela eivek tyoung gheyapu nei eno mi yei Mang wei tyoung gheyapu nei manghalus. ");
INSERT INTO tbx_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","En Xomaxoneing Neu Moux lam bei qou eti yeiw wei lati yo noum. ");
INSERT INTO tbx_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Wang wou naleim ambei nya? Wangwei tambiy ti xe sipsip teyei lek 100, ekom ti nati, yond tyek moxo se teyei bei ghanaw 99 on lek qetyei dom na gyimexe tiwei lati yo? ");
INSERT INTO tbx_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","De wangwei e gyeiwou nei, a neil wou xam zonghek, moxo tyek bo xeilala en tiwei lati yo de se 99 wei se lati yo. ");
INSERT INTO tbx_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Eivek sakwaing ambei nyon eno Mam wei toundei eivek tyoung gheyapu embei yakyak on ti se nati. ");
INSERT INTO tbx_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Wangwei lim bo sewokeing wou wang, ond eivek muw venaxow senghoing eno la me neil e xe nilul teyei wou e. Wangwei e ngowou wa xe qayeeng, yon nambei wang qou lim loum. ");
INSERT INTO tbx_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ekom wangwei e se ngowou nei, yon wa qou tambiy ti o yuw is xow, en kandek ‘pavulek tambak wei moux yuw o yal eno na byexaxoun qayeeng.’ ");
INSERT INTO tbx_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Wangwei e bei se ngowou xel xe qayeeng, yon wa neil wou kongrikesin dalus. Ek wangwei e pyalek kongrikesin xe qayeeng, ond xam ghe gwei e bei inyon tambiy wei mandalus o tambiy wei mi qou takis o ti. ");
INSERT INTO tbx_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“A neil wou xam zonghek, vatiyeiw wei xam ghe tup lek tembuing eno tyek Anutu na tup eivek tyoung gheyapu, de vatiyeiw wei xam ghe tul lek tembuing eno tyek Anutu na tul veil eivek tyoung gheyapu. ");
INSERT INTO tbx_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“A neil wou xam no bei, wangwei xam on yuw na toung laleimim lekti en vati wei muw ambei teling en eno tyek Mang wei tyoung gheyapu nei bong wou muw. ");
INSERT INTO tbx_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","En wangwei muw yuw o mal yal a being nam qeku lekti eivek a leing, inyon a toundei is mal.” ");
INSERT INTO tbx_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Woyom Petele lam wou Yesu me teling, “Tambiy Ngandoung, teyei lek lu vamva eno a teyei bei semaleeng ling xe nilul gyeik ingwei embo sewokeing wou ay yo? Ena teyei lek lim yuw?” ");
INSERT INTO tbx_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu neil elox, “A neil wou wang, se lu lim yuw, qe teyei lek lu lim yuw me e mi na lumama teyei lek 70. ");
INSERT INTO tbx_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Nambei nyon, tete lalei wei tyoung gheyapu eno inye nambei king ti embei menyex wou malew vateivek is e xe xel xukxe wei xel qou wou e yo. ");
INSERT INTO tbx_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ka moxo qandi en menyex wou malew vateivek, moxo taxe tambiy wei qou malew 10,000 eno lam wou e. ");
INSERT INTO tbx_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ekom moxo se teyei bei bong malew zeyi, om teiv wo qayeeng nikanzek bei xel bong vateivek lek lis venei neu me lulul dalus wei e beeng o de bong ena zeyi malew vateivek wei qou yo. ");
INSERT INTO tbx_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Xukxe ev vaxa qatu eivek atax wou e me tay, ‘Wam di daxe ay, en tyek a bong lulul dalus nouk wou wang.’ ");
INSERT INTO tbx_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Teiv wei xukxe yon pyanalei en e, om semaleeng malew vateivek wei qou yo dom wong e la. ");
INSERT INTO tbx_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ekom xukxe tiyon la myayaing, moxo yeiwou e xe laxous tiwei luw mi wo xuk lekti yo wei qou malew 100 wou e yo. Moxo sex e kwa de luk nikanzek wou e, ‘Wang bong vati wei wang qou wou ay eno noum!’ ");
INSERT INTO tbx_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Moxo xe laxous wei luw mi wong xuk lekti eno ev vaxa qatu eivek me tay wou e, ‘Wam di daxe ay, en tyek a bong malew vateivek wei a qou eno nouk zeyi wou wang.’ ");
INSERT INTO tbx_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Ekom moxo se lewexe lek. Qe la veil de toung laxous la eivek xeitueing deka embong malew vateivek wei qou yo noum zeyi le. ");
INSERT INTO tbx_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Woyom laxousyeiw valu yei vati wei belup on eno xel laleind wo myavanei ngandoung. Om xel la neil wou xel xe teiv en lul sapa wei belup on. ");
INSERT INTO tbx_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Woyom teiv taxe xukxe la lalei me neil, ‘Wa xukxe nilul ayang. A semaleeng wa xe malew vateivek dalus wei wang o, en nambei wang tay wou ay. ");
INSERT INTO tbx_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Se teyei bei wa pyanaleim en laxous nge wei muw ghe mi wo xuk o nambei ingwei a wong wou wang o?’ ");
INSERT INTO tbx_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Teiv moxo lalei wo vanei wou e om toung e la wou xel belimbo wei xeitueing o bei xel bong vanei wou e, deka e bong lulul dalus wei e qou yo noum bole. ");
INSERT INTO tbx_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Tine inye Mang wei tyoung gheyapu nei tyek bong wou xam titi yo, wangwei wa se semaleeng nilul wei limyeiw nge wong wou wang eivek laleim o.” ");
INSERT INTO tbx_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Gyeik Yesu neil qayeeng ti beimambei ne ma, woyom moxo la veil Galili me la eivek tembuing wei Yudia me la loxalu wei memiing Yorodan nei. ");
INSERT INTO tbx_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Xel qendu ngandoung betiwou e, om moxo wong xel wo nimzalek nanghei inyon. ");
INSERT INTO tbx_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Xel Parisi valu lam wou e bei bong axeing wou e. Xel teling, “Beip inyei petieing neil embei moux ti qateiv iingama wei venei yo veil en woueing nalei wei emaxow o?” ");
INSERT INTO tbx_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu neil elox, “Beip xam seng pyaw qayeeng wei di yeip eivek qapiya wei Anutu yo bei, eivek myaxeeng eno ‘Anutu toung xomaxoneing, moux aluw vex,’ Myaxeeng selis 1:27 ");
INSERT INTO tbx_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","de neil, ‘En qes tine moux tyek na veil ma luw ta me luw venei na toung lekti me luw bo neing tixemou?’ Myaxeeng selis 2:24 ");
INSERT INTO tbx_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Om luw se wo yuw no, qe luw wo neing tixemou. Nambei nyon vati wei Anutu tup lekti, eno xomaxoneing ti se qateiv e tip.” ");
INSERT INTO tbx_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Xel teling, “Woyom nambei nya Mose wong qayeeng nikanzek bei moux e bong qapiya wou venei en qateiv iingama de bong vex on na?” ");
INSERT INTO tbx_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu neil elox, “Mose lenghek lek bei xam qateiv iingama en nambei xam laleimim on wo nikanzekta. Ekom myaxeeng eno kwa nambei inyon eno ma. ");
INSERT INTO tbx_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Om a neil wou xam bei wangwei tambiy ti venei se bo kwapesiv is tambiy nge ekom leya qateiv iingama wei luw o, dom dii vex nge yond moux on venaxow wo kwapesiv.” ");
INSERT INTO tbx_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Xel betiyeing neil wou e, “Wangwei kwa nambei nyon gyeip senghoing eivek moux ti luw venei, ond inye nimza bei moux tiyon se dii vex.” ");
INSERT INTO tbx_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu neil elox wou xel bei, “Xel ngenong tyek se qou qayeeng tine, qe wou xel valu wei Anutu wong nikanzek wou xel eno tyek bong ambei nyon de tyek xel se diima. ");
INSERT INTO tbx_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","En moux valu nikanzek wei embei bo yak eno ma gyeik ingwei umbek o, me xel valu eno xomaxoneing veil e nikanzek, de xel valu eno se ii vex en xel wou kwend en xuk tete lalei wei tyoung gheyapu yo. Tambiy ti embei qou kwa nambei nye ond wong e qou.” ");
INSERT INTO tbx_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Woyom xel qou yakyak me lam wou Yesu bei e ni mema lek xel me na zeim wou xel. Ekom xel betiyeing luk nikanzek wou eti yeiw wei qou xel me lam o. ");
INSERT INTO tbx_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu neil, “Wong xel yakyak on lam wou ay, de xam se bale zeyi xel, en tete lalei wei tyoung gheyapu nei eno inye wou xel ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Gyeik e li mema lek xel woy, woyom moxo la veil inyon me la. ");
INSERT INTO tbx_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Tambiy ti lam wou Yesu me teling, “Putoung, lul nimza vati a teyei bei bong dom na qou mapieing luta?” ");
INSERT INTO tbx_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu neil elox, “Wang teling ay en vati wei nimza yo en va? Inyon Anutu venaxow nimza. Wangwei wa bei qou mapieing luta nei, ond wa betiwou qayeeng petieing dalus.” ");
INSERT INTO tbx_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Moux moxo teling, “Tina?” Om Yesu neil elox, “ ‘Wa seng nyeis xel amey. Wa seng bo kwapesiv is vex wei dei leya yo. Wa se panax. Wa seng bong qayeeng tyonyeing wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Wa mi gwevek mam aluw tam. Wa laleim e mi devind nimpapu nambei wa laleim mi vind wamaxow o.’ ” ");
INSERT INTO tbx_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tambiy ghavis on neil wou e, “Petieing dalus eno a mi betiwou. De vati tyek am bong no?” ");
INSERT INTO tbx_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu lewexe, “Wangwei wambei mendei bo nimza nei, ond la wo vateivek lek lulul dalus wei wang o me wong wou xel kanyoyeiw, de tyek wa qou lul nimza ngenong nanghei tyoung gheyapu nei. Woyom wang nam betiwou ay.” ");
INSERT INTO tbx_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ekom tambiy ghavis on ngo qayeeng tine, om moxo lalei wo maying ngandoung me la, en nambei e xe lulul ngenongakes. ");
INSERT INTO tbx_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Woyom Yesu neil wou e xe xel betiyeing, “A neil wou xam zonghek, inye pok ngandoung en lulul ana embei na eivek tete lalei wei tyoung gheyapu nei yo. ");
INSERT INTO tbx_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A neil wou xam no bei, inye pok neing en ingwei kamel embei na eivek ying manghalus wei duweing o, de pok wei malew ana ti embei na eivek tete lalei wei Anutu xe yo eno ghanaw xel amba ne.” ");
INSERT INTO tbx_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu xe xel betiyeing ngo tine, moxoyeiw etek niseikeing me teling, “Wangwei nambei nyon nei ond tyek eti mendei mapieing luta?” ");
INSERT INTO tbx_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu yeila xel de neil, “Wou xel xomaxoneing eno inye se teyei, ekom is Anutu eno lulul dalus on teyei.” ");
INSERT INTO tbx_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Petele lewexe lek e, “Xa ghanaw lul dalus bei betiwou wou wang! Woyom tyek xa qou vati?” ");
INSERT INTO tbx_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu neil wou xel, “A neil wou xam zonghek, gyeik kawei lul dalus embei bong vako, eno Xomaxoneing Neu Moux embei mendei lek e xe sia vambuing wei lei ngandoung o, xam eti yeiw wei ghe mi betiwou ay eno tyek xam mendei lek a xe sia xoumeeng yuw wei vambuing, me ghe gwei veleivlei xoumeeng yuw wei Israel o teyei. ");
INSERT INTO tbx_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Me xel sapa wei ghanaw xel xe xomek, o liyeiw moux, o liyeiw vex, o ma, o ta, o neuyeiw, o xuk en a leing yon tyek na qou 100 ngenong is me tyek xam a qou mapieing luta luta. ");
INSERT INTO tbx_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ekom xel ngenong wei lam atax eno tyek nox yus, de xel ngenong wei lam yus eno tyek na tax.” ");
INSERT INTO tbx_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“En tete lalei wei tyoung gheyapu eno nambei tembuing ma ti la satiboukeing lulayang bei na qou xel moux en xel na bong xuk eivek e xe xuk wain. ");
INSERT INTO tbx_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Moxo lewexe lek xel bei dexouv xel en malew selewa ti lek bouk titi dom wong xel la eivek e xe xuk wain. ");
INSERT INTO tbx_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Lek seivma nambei limvey eno tambiy moxo la me yei xel valu toungale eivek beyeeng vateivek dom xel se di wong lulti. ");
INSERT INTO tbx_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Moxo neil wou xel, ‘Xam is ambei nyon xam ghe na bong xuk eivek a xe xuk wain, de tyek a dexouv xam en xouveing wei bombek o.’ ");
INSERT INTO tbx_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Om moxoyeiw la. “Moxo lox me la lek ingwei seivma evlek me seivma yal soukeing eno wong kwa kawei yo no. ");
INSERT INTO tbx_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lek seivma lim soukeing kayon eno moxo la no me yei xel valu nanghei toungale bandabanda. Moxo teling xel, ‘Nambei nya xam ghe mi nale inye bouk tine dalus dom xuk maeing?’ ");
INSERT INTO tbx_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“ Xel lewexe, ‘En nambei xelti se qou xa en xuk.’ “Moxo neil wou xel, ‘Xam is ambei nyon xam ghe na bong xuk eivek a xe xuk wain.’ ");
INSERT INTO tbx_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Lek soukeing kayon, eno xuk wain ma neil wou e xe tambiy wei lam xeinghembi en e yo bei, ‘Taxe xel wei wo xuk o lam me xouv xel. Myaxeeng eno wa dexouv xel wei lam yusayang o me mendi na dekakom ghe na wou xel wei lam atax o.’ ");
INSERT INTO tbx_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Xel wei wo xuk lek seivma lim eno lam me xel titi qou malew selewa titi. ");
INSERT INTO tbx_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Om gyeik xel wei lam wo xuk atax eno xel embeik nge tyek xel a qou malew zekna ghanaw xel valu wei lam yus o. Ekom xel titi eno qou malew selewa titi. ");
INSERT INTO tbx_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Xel qou xouveing woy, eno moxoyeiw luk ngenong is tembuing ma. ");
INSERT INTO tbx_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Moxoyeiw neil, ‘Xel moux tiwei lam wo xuk yus eno xel wo xuk teyei lek seivma ti, ekom wang wong xel qou malew teyei lek ambei xa wei wo xuk ngandoung wou seiv myavanei lek bouk tine dalus o.’ ");
INSERT INTO tbx_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ekom moxo lewexe lek xel on ti, ‘Gweleeng, a se wo nol wou wang. Beip wa seng lewexe lek bei bong xuk en malew selewa ti? ");
INSERT INTO tbx_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Qou wa xe xouveing me la. Ambei bong malew wou tambiy wei lam wong xuk yus o nambei ingwei a wong wou wang ne yo. ");
INSERT INTO tbx_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Beip inye se di yeip wou a bei a bong vati en a maxow xe malew? O inye a memang les om wang qouwou ay?’ ");
INSERT INTO tbx_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Om nambei nyon xel wei la yus eno tyek na tax, de xel wei lam atax eno tyek na yusayang.” ");
INSERT INTO tbx_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ka Yesu di la pu Yerusalem nei, moxo qou e xe xel betiyeing xoumeeng yuw me xel venaxow la nenyawes me neil wou xel, ");
INSERT INTO tbx_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Wei, xey am bei na pu Yerusalem nei, en Xomaxoneing Neu Moux tyek xel a toung e na eivek xel lumuki leitata me xel putoung wei petieing o memend. Me tyek xel bo qayeeng en e me na neimbei e mey, ");
INSERT INTO tbx_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","me tyek xel a toung e na eivek xel amba memend en xel a neil seloukeing lek e me sesa e me na tuw e lek xax pepeeng. De lek bouk yal eno moxo tyek qandi lek mapieing!” ");
INSERT INTO tbx_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Woyom Sebedi neu luw lam is tend wou Yesu, me ev vaxa qatu eivek me teling Yesu en e xe lalei vineing. ");
INSERT INTO tbx_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Moxo teling, “Inye wa laleim vind vati?” Vexo neil, “A laleind vind bei a neung yuw ne eno nge mendei wou wa memam payeiv de nge wou wa memam qeinz eivek wa xe tete lalei.” ");
INSERT INTO tbx_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu neil wou luw, “Muw seng woulek vati wei muw ghe teling en o. Muw ghe teyei bei num eivek mayamya wei ambei num eivek ne?” Luw neil, “Uw a teyei.” ");
INSERT INTO tbx_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesu neil wou luw, “Tyek muw a num eivek a xe mayamya, ekom deing wou a memang payeiv o qeinz eno inye se wou ay bei a zenghek lek. Beyeeng tine inye wou eti yeiw wei Mang venaxow menyex woy wou xel o.” ");
INSERT INTO tbx_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ka xel xoumeeng ngo qayeeng tine, eno xel wo veweeng wou Yoan aluw li. ");
INSERT INTO tbx_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yesu taxe xel xouing lam me neil, “Xam ghe woulek bei king wei xel amba eno mi wo ninkanzek bei gyeiteyei xel, me xel xe lei ngandoung mi wo ninkanzek bei moux alis vex na mi betiwou qayeeng tambak wei xel o. ");
INSERT INTO tbx_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Om se is xam. Qe eti bei bo lei ngandoung eivek xam senghoing ond e bong ambei xam xe xukxe, ");
INSERT INTO tbx_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","me eti embei na tax ond e bong ambei xam xe xukxe bandaing, ");
INSERT INTO tbx_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","teyei lek ambei nyon eno Xomaxoneing Neu Moux se lam bei tyek moux alis vex devind e, qe lam bei bong e xe mapieing nambei xouveing en xomaxoneing ngenong.” ");
INSERT INTO tbx_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ka Yesu lis e xe xel betiyeing la veil Jeriko, xel qendu ngandoung on betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Moux matekeing yayuw toundei wou sakwaing vi, om gyeik luw ngo bei Yesu di lamela, luw taxe, “Tambiy Ngandoung, Dawit Neu Moux, pyanaleim en uw!” ");
INSERT INTO tbx_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Xel qendu yon luk nikanzek wou luw bei denduing ma, ekom luw taxe niseikeing, “Tambiy Ngandoung, Dawit Neu Moux, pyanaleim en uw!” ");
INSERT INTO tbx_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yesu nale dom taxe luw. Moxo teling, “Muw ambei a bong vati wou muw?” ");
INSERT INTO tbx_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Luw lewexe, “Tambiy Ngandoung, uw ambei gheina yo.” ");
INSERT INTO tbx_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesu lalei pyaxow en luw om axlek luw xouing mendghalus. De se denlek en luw mend yeila de luw betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ka xel la tyip paviy Yerusalem me la Betpage lek lukendu Oliv nei, Yesu wong betiyeing yuw la, ");
INSERT INTO tbx_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","me neil wou luw, “Muw ghe na beyeeng tiwei muw mamim di yeila nei, lutika eno tyek muw ghe gwei dongi ti xel tup anghei inyon, is neu lingheing toukale lip ta. Muw wa tul luw xouing me na qou me ghe nam wou ay. ");
INSERT INTO tbx_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Wangwei xelti neil lulti wou muw, ond muw a neil wou bei Tambiy Ngandoung embei bong xuk en, dom tyek bong luw noum daing.” ");
INSERT INTO tbx_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Lul tine la teyei lek lul tiwei Anutu neil eivek poropet mya yo: ");
INSERT INTO tbx_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Neil wou Sayon neu vex, ‘Wei, xam xe king lam wou xam. Moxo lam ambei tambiy wei lei maeing o me dei lek dongi ti. Moxo dei lek dongi lingheing ti me lam.’” ");
INSERT INTO tbx_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Betiyeing aluw la me wong e la teyei lek kawei Yesu neil wou luw o. ");
INSERT INTO tbx_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Luw qou dongi ta me neu lingheing, me vax luw xe teimb ding lek luw, de Yesu deilek lek. ");
INSERT INTO tbx_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Xel qendu ngandoung on vax xel xe teimb ding lek sakwaing, de xel valu qateiv xax memama me liw lek sakwaing. ");
INSERT INTO tbx_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Xel qendu ngandoung wei la mamunghexeing en e me xel wei di betiwou eno di taxe bei, “Hosana ena wou Dawit Neu Moux! Mata ena wou tiwei lam eivek Tambiy Ngandoung lei yo! Hosana ena eivek tyoung gheyapu nei!” ");
INSERT INTO tbx_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Gyeik Yesu la eivek Yerusalem eno moux alis vex dalus wei beyeeng ngandoung on etek om xel teling, “Tambiy on eti?” ");
INSERT INTO tbx_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Xel qendu yon lewexe, “Tine inye Yesu, poropet wei lam anghei Nasaret eivek Galili yo.” ");
INSERT INTO tbx_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu la eivek tete lalei wei xomek vambuing o me tiy xel wei di xouv lulul me wo vateivek anghei inyon o. Moxo qapyex lelek wei xel di pelipek malew me eti yeiw wei di wo vateivek lek menek beliy o. ");
INSERT INTO tbx_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Moxo neil wou xel, “Xel byex eivek xoulek eno nambei nye, ‘A xe xomek tyek xel taxe bei xomek wei zeimeing mema yo,’ ekom xam ghe pelipek e xok ambei ‘eeng wei xel panaxana yo.’” ");
INSERT INTO tbx_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Xel wei mend tekeing me vaxend nol eno lam wou e eivek xomek vambuing, me moxo wong xel wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ekom xel lumuki leitata me putoung wei petieing lam yei lul nimza wei e wong o me yakyak wo vyend eivek xomek vambuing lalei, “Hosana ena wou Dawit Neu Moux,” om xel laleind wo nilul. ");
INSERT INTO tbx_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xel teling e, “Beip wang ngo vati wei xel yakyak ti beimambei ne di neil ne?” Yesu neil elox. “E. Beip xam seng mi pyaw qayeeng, “‘Eivek yakyak me yakyeis myend wang menyex wou bei xel a mi sanghoxe wa leim’?” ");
INSERT INTO tbx_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Om moxo la veil xel me la Yerusalem me la Betani, de moxo dei inyon boukeing tiyon. ");
INSERT INTO tbx_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Satiboukeing lul, eno Yesu di la wou sakwaing bei nox Yerusalem, ekom maxepya e. ");
INSERT INTO tbx_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Moxo yei xax basunghek ti toukale wou sakwaing nenyawes, om la ingwei xax toukale ghei yo ekom se yei neing ti qe lis bandaing. Woyom moxo neil wou xax on, “Tyek wa seng nox buk neing no!” Se wo lululek en xax basunghek on mupek. ");
INSERT INTO tbx_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Gyeik xel betiyeing yei tine, moxoyeiw etek mouyo. Xel teling, “Xax basunghek tine mupek daing ambei nya?” ");
INSERT INTO tbx_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu neil elox bei, “A neil wou xam zonghek, wangwei wa laleim se bo yuw en wa xe wongeingis nei, ond se nambei vati wei a wong wou xax basunghek ne venaxow, qe wa neil wou lukendu tine is ambei nyon, ‘La nex xow la eivek mamileeng,’ ond tyek bong ambei kawei wang neil o. ");
INSERT INTO tbx_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wangwei wang bongis nei, tyek wa qou vatiyeiw wei wang teling en o eivek zeimeing mema.” ");
INSERT INTO tbx_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Yesu la eivek tete lalei wei xomek vambuing, ka moxo di teyoxe eno xel lumuki leitata me teivateiv wei xomaxoneing o lam wou e. Xel teling, “Wang di wong lulti beimambei ne nangya lei ngandoung wei eti yo? Me eti wong lei ngandoung tine wou wang?” ");
INSERT INTO tbx_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu neil elox bei, “Tyek a bong telinyeing ti wou xam is ambei nyon. Wangwei xam a neil enoum wou a bombek nei, on tyek a neil wou xam en lei ngandoung wei eti ingwei a di wong lulti beimambei ne nangya ne. ");
INSERT INTO tbx_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yoan xe lipekeing on lam anghei inya? Beip inyon lam anghei tyoung gheyapu nei, o inyon lam wou xomaxoneing?” Xel di luk en inye wouma me neil ambei nye, “Wangwei xey a neimbei, ‘Nanghei tyoung gheyapu nei,’ ond moxo tyek teling, ‘Woyom nambei nya xam seng wongis e?’ ");
INSERT INTO tbx_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ek wangwei xey a neimbei, ‘Inyon lam wou xomaxoneing,’ ond xey a ghaleeng en xomaxoneing, en xel dalus woulek bei Yoan ne poropet ti.” ");
INSERT INTO tbx_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Om xel neil e lox wou Yesu, “Xa loungen o.” Woyom moxo neil, “Ay is ambei nyon tyek a se neil wou xam en lei ngandoung vati wei andi wong lulti beimambei ne en o. ");
INSERT INTO tbx_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Xam ghe wou naleimim ambei nya? Inyon tambiy ti neu moux yayuw. Moxo la wou neu nge wei tax o me neil, ‘Neung, la me wo xuk eivek xuk wain gweimbeeng.’ ");
INSERT INTO tbx_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Moxo neil, ‘Tyek a se na.’ Dekalekom moxo lalei pekwi dom la. ");
INSERT INTO tbx_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Woyom ma la wou nge wei moun me neil ambei kawei yo no. Moxo lewexe, ‘Mang, tyek a na yo.’ Ekom moxo se la. ");
INSERT INTO tbx_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Eivek neu yuw on eno luw nge na wong ambei ingwei ma neil o?” Xel lewexe, “Nge wei tax o.” Yesu neil wou xel, “A neil wou xam zonghek, xel wei mi qou takis me vex wei kwapesiv o tyek na eivek tete lalei wei Anutu yo natax en xam. ");
INSERT INTO tbx_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","En Yoan lam wou xam bei talex sakwaing wei bombek ayang o wou xam, ekom xam seng wongis e, qe xel wei mi qou takis me xel vex wei kwapesiv o eno wongis. Me xam ghe wei inye, ekom xam seng pekwi xow me ghe wongis e. ");
INSERT INTO tbx_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Xam a ni nenyamim wou qayeeng pakeing nge no, inyon tembuing ma ti ev e xe xuk wain. Moxo qo tete zeyi e vivekwou, me ev leiveeng wei qeing wain eivek o me ev xomek vaxading wei yeingteyei yo ti. Woyom moxo wong e xe xuk wain wou xel xukana valu dom la sakwaing anding. ");
INSERT INTO tbx_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Bouk wei uleing wain neing o lam paviy, om moxo wong e xe xukxe la wou xel wei yeiteyei xuk wain bei na dul e xe neing valu. ");
INSERT INTO tbx_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Xel wei mi yeiteyei xuk wain eno zeimaxoun e xe xukxeyeiw, xel sesa ti, de leis nge mey, dom nex tiwei yal o en qakous. ");
INSERT INTO tbx_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Woyom moxo wong xukxe valu lox me la wou xel no, xel la ngenong ka ghanaw nge tax veil, me xel wei mi yeiteyei xuk wain eno wong ambei kawei xel wong nge tax o wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ti yusayang eno moxo wong e maxow neu moux la wou xel. Moxo neil, ‘Tyek xel a ni nenyend wou a neung moux xe qayeeng.’ ");
INSERT INTO tbx_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Ekom xel wei mi yeiteyei xuk wain eno yei e neu moux om xel neil wouma, ‘Tine inye xukma neu moux wei tyek na qou lulul dalus o. Xam lam, en xey a nyeis e mey de na qou e xe lulul dalus.’ ");
INSERT INTO tbx_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Om xel zeimaxoun e me nex e la myayaing veil xuk wain de leis e mey. ");
INSERT INTO tbx_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nambei nyon om gyeik xuk wain ma nam, ond tyek moxo bong vati wou xel wei mi yeiteyei xuk wain on?” ");
INSERT INTO tbx_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Xel neil elox bei, “Moxo tyek bo nol wou xel on bo nilul ayang me nyeis xel amey, de tyek moxo bong xuk wain on nox wou xel ba, eti yeiw wei teyei bei tyek bong xuk neing valu wou e gyeik bouk wei uleing neing o.” ");
INSERT INTO tbx_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu neil wou xel, “Xam seng mi pyaw vati wei yeip eivek qapiya vambuing yo: “‘Qakous wei xel kamunda pesek, eno wong ambei qakous ti myaxeeng me mi byexaxoun xomek o. Inye Tambiy Ngandoung venaxow wong tine belup, me wo nimza eivek xa mami’? ");
INSERT INTO tbx_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Nambei nyon a neil wou xam bei Anutu tyek na qou e xe tete lalei veil xam me bong wou xomaxoneing qendu ti wei tyek bong neing atyip o. ");
INSERT INTO tbx_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","De eti detei lek qakous nei tyek dembu me bo myapapu, ekom qakous embei detei lek tambiy ti eno tyek bo myasa bandaing.” ");
INSERT INTO tbx_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gyeik xel lumuki leitata me Parisi ngo Yesu xe qayeeng pakeing tine, xel woulek bei Yesu di neil inye lek xel. ");
INSERT INTO tbx_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Om xel yimexe sakwaing wei xel embei zeimaxoun e yo, ekom xel di yaleeng en xel qendu ngandoung on en nambei xomaxoneing ngenong yei bei e yon poropet. ");
INSERT INTO tbx_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu luk is xel lu nge no eivek qayeeng pakeing, me neil embei, ");
INSERT INTO tbx_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tete lalei wei tyoung gheyapu eno nambei king ti wei menyex wou mata ngandoung wei iingama yo en neu moux. ");
INSERT INTO tbx_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Moxo wong e xe xel xukxe la wou eti yeiw wei wong qayeeng la me neil wou xel bei xel nam en mata ngandoung wei iingama yo, ekom xel pesek bei se nam. ");
INSERT INTO tbx_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Woyom moxo wong xel xukxe valu no la me neil, ‘Neil wou xel wei a wong qayeeng la wou xel bei a menyex wou a xe yaeing woy, “Wei, a xe manghaxo me leliy wei ling tata yo eno xel leis me ghuw, me lul sapa a menyex wou woy. Xam lam en mata ngandoung wei iingama ne.” ’ ");
INSERT INTO tbx_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Ekom xel se di li nenyend wou qayeeng qe xel la. Ti la e xe xuk, de nge la emaxow xe xuk malew. ");
INSERT INTO tbx_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","De xel ba zeimaxoun e xe xel xukxe me wo nol wou xel de leis xel mey. ");
INSERT INTO tbx_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","King moxo lalei wo vanei mouyo. Om wong e xe xel vevekyeiw la me semaleeng xel tiwei leis xel xukxe mey yo me nyuw beyeeng ngandoung wei xel on is. ");
INSERT INTO tbx_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Woyom neil wou e xe xel xukxe bei, ‘A menyex wou mata ngandoung wei iingama eno woy, ekom xel wei a wong qayeeng la bei xel nam eno xel on se nimza teyei bei nam. ");
INSERT INTO tbx_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Om xam ghe na sakwaingta dalus me eti yeiw wei xam ghe gweiwou eno xam a qou me ghe nam eivek mata ngandoung wei iingama ne.’ ");
INSERT INTO tbx_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Om xel xukxe la eivek sakwaingta dalus nei me qekuwou xomaxoneing dalus wei xel yeiwou yo, xel nimza me nilul is, om xomek lalei wei mata ngandoung wei iingama yon puplek en xel. ");
INSERT INTO tbx_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ekom gyeik king lam lalei me yei xel on, moxo woulek bei tambiy ti toundei inyon eno se byex teimb wei iingama yo. ");
INSERT INTO tbx_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Moxo teling, ‘Gweleeng, wang lam eivek xomek ne lalei nambei nya, ekom wang seng byex teimb wei iingama yo?’ Ekom tambiy on se wo lukluk. ");
INSERT INTO tbx_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Woyom king neil wou e xe xel xukxe, ‘Xam tup e mema vaxa, dom nex e la myayaing nei eivek mapetok ngandoung nanghei inyon eno xel mi eng me mi nga newound mi wo nyiknyik.’ ");
INSERT INTO tbx_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“En nambei Anutu taxe xel ngenong, ekom beyal xel nuyuw ka.” ");
INSERT INTO tbx_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Woyom xel Parisi la myayaing me yimexe sakwaing wei xel embei pakei qayeeng lek e en e maxow xe lukeing o. ");
INSERT INTO tbx_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Xel wong xel xe betiyeing la wou e is xel wei Herot o. Xel neil, “Putoung, xa woulek bei wang on moux wei wang mi neil zonghek o me inyon wang mi teyoxe sakwaing wei Anutu xe lalei nimza is zonghek o. Wa seng mi waleeng en xelti, en nambei wa seng mi li nenyam wou xelti xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Woyom neil wou xa, wang wou naleim ambei nya? Beip inye teyeimbei xey a toung takis wou Sisa o xe se toung?” ");
INSERT INTO tbx_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ekom Yesu woulek xel xe woueing nalei nilul on, om neil, “Xam wei myamim yuw o, nambei nya xam ghe di wong en xam ambei bong axeing wou ay? ");
INSERT INTO tbx_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xam talex malew selewa wei xel mi toung takis eno ti me a xei.” Xel qou malew selewa ti me talex wou e, ");
INSERT INTO tbx_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","om Yesu teling xel, “Eti xe tenu tine? Me eti lei tine?” ");
INSERT INTO tbx_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Xel neil elox bei, “Sisa.” Woyom moxo neil wou xel bei, “Xam ghe bong vati wei Sisa xe yo ena wou Sisa, de vati wei Anutu xe yo ena wou Anutu.” ");
INSERT INTO tbx_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Xel ngo tine eno xel etek mouyo. Om xel la veil e me la. ");
INSERT INTO tbx_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lek bouk kayon Sadyusiyeiw wei mi neil embei xel meyeing tyek se qandi lek, eno lam wou e is telinyeing ti. ");
INSERT INTO tbx_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Xel neil, “Putoung, Mose neil wou xa bei wangwei moux ti e mey de neu ema, ond e li moux e dii vexeiv on me bo li neuyeiw en e lei e se ma. ");
INSERT INTO tbx_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Woyom inyon xel lim yuw lindama toundei eivek xa senghoing. Xel lind ti tax o ii vex on me mey, de moxo se wong yak ti, om li nge wei nexlek eno ii li venei vexeiv on. ");
INSERT INTO tbx_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sakwaing kayon eno li nge wei yuw me nge yal, me ela tei lek tiwei lim yuw eno teyeima. ");
INSERT INTO tbx_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","De loxyus eno vex on mey. ");
INSERT INTO tbx_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Woyom lek bouk wei qandieing lek eno eivek xel lim yuw on eti venei? En inyon nambei xel xouing ii vex tiyon.” ");
INSERT INTO tbx_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu neil elox, “Xam ghe neil esewok en inyon xam seng mi pyaw qayeeng wei di yeip eivek qapiya vambuing o me xam seng woulek Anutu xe nikanzek. ");
INSERT INTO tbx_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Gyeik bouk wei qandieing lek veil meyeing eno xomaxoneing tyek se diima o diima nox me noum. Tyek xel ghok ambei angelayeiw wei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ekom qayeeng tiwei qandieing lek veil meyeing, eno beind xam seng pyaw vati wei Anutu neil wou xam bei, ");
INSERT INTO tbx_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘A ne Anutu wei Apraham xe yo, Anutu wei Isaka xe yo me Anutu wei Yakop xe yo.’ Moxo se Anutu wei meyeing o, qe Anutu wei mapieing o.” ");
INSERT INTO tbx_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Xel xomaxoneing qendu tiyon ngo tine, xel etek en e xe teyoxeing. ");
INSERT INTO tbx_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Xel Parisi ngo bei Yesu qateiv xel Sadyusi xe lukeing, om xel Parisiyeiw toung lekti. ");
INSERT INTO tbx_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Eivek xel senghoing eno tambiy ti, wei wo lupeyei en petieing, eno wo axeing wou Yesu en telinyeing tine, ");
INSERT INTO tbx_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Putoung, qayeeng petieing tina inye ngandoung ghanaw veil eivek petieing?” ");
INSERT INTO tbx_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu neil elox, “‘Xam laleimim devind Tambiy Ngandoung xam xe Anutu is xam laleimim dalus me is xam numim dalus me is xam lumimpeyei dalus.’ Petieing 6:5 ");
INSERT INTO tbx_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Tine inye qayeeng petieing tiwei tax o me ngandoung ghanaw veil. ");
INSERT INTO tbx_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","De nge yuw wei teyei lek eno nambei nye, ‘Wa laleim devind nimpapu nge nambei wa laleim mi vind xow o.’ Lumuki 19:18 ");
INSERT INTO tbx_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Petieing dalus me qayeeng poropet dalus eno milek qayeeng petieing yuw ne.” ");
INSERT INTO tbx_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ka xel Parisi di qekuma eno Yesu teling xel, ");
INSERT INTO tbx_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Xam ghe wou naleimim ambei nya en Kilisi? Eti neu e?” Xel neil elox bei, “Dawit neu moux o.” ");
INSERT INTO tbx_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Moxo neil wou xel, “Woyom nambei nya Laweeng Vambuing wong kwa wou Dawit me moxo taxe e ‘Tambiy Ngandoung’? En moxo neil ambei nye, ");
INSERT INTO tbx_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Tambiy Ngandoung neil wou a xe Tambiy Ngandoung, “Dei wou a memang payeiv deka a toung wa xe xel vevek eivek wa vaxam xeinghembi le.”’ ");
INSERT INTO tbx_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Woyom wangwei Dawit a mi taxe e bei ‘Tambiy ngandoung,’ on nambei nya ekom e yon Dawit neu moux?” ");
INSERT INTO tbx_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Xelti se teyei bei neil qayeeng nge nox wou e, de lek bouk kayon me ela eno xelti se mi teling e no en lulti. ");
INSERT INTO tbx_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Woyom Yesu neil wou xel qendu ngandoung on is e xe xel betiyeing, ");
INSERT INTO tbx_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Xel putoung wei petieing me xel Parisi eno mindei lek Mose xe sia. ");
INSERT INTO tbx_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Om xam a mi betiwou xel me ghe bong lul dalus wei xel neil wou xam o. Ekom xam seng bong vati wei xel wong o, en nambei xel se mi wong e teyei lek vati wei xel mi teyoxe yo. ");
INSERT INTO tbx_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Xel tup nimaying ngandoung me toung lek xel xomaxoneing on ghandiwek, ekom xel venaxow se teyei bei zeim lek angya memend deyis bei bong ena veil. ");
INSERT INTO tbx_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Lul sapa wei xel mi wong en embei xel xomaxoneing gyei, me lek xel dambend me memend eno xel mi tup deneing wei xoulek o lek me e wo myasapa, me mi tup yis ding lek xel xe teimb ding myasepu. ");
INSERT INTO tbx_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Xel laleind mi vind bei na mi mendei mya eivek bouk wei mata ngandoung o me eivek xomek qekueing ama lalei. ");
INSERT INTO tbx_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Xel laleind mi vind bei moux alis vex a mi neil bendiyeing wou xel eivek beyeeng vateivek me na mi taxe e bei ‘Putoung.’ ");
INSERT INTO tbx_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ekom xam eno xel se taxe xam ‘Putoung,’ en xam xe putoung tixemou tateis me xam dalus on limim ama. ");
INSERT INTO tbx_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","De xam se taxe xelti lek tembuing bei ‘mang,’ en xam Mamim tixemou, me e toundei eivek tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","O xel ti se taxe xam ‘putoung,’ en xam xe putoung tixemou, inyon Kilisi. ");
INSERT INTO tbx_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Xam xe teiv eivek xam senghoing eno e mi mendei nambei xam xe xukxe. ");
INSERT INTO tbx_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","En wangwei eti yeiw embei sanghoxe xow on tyek e lei detei eivek, de eti embei beoux xow on tyek e lei zekna. ");
INSERT INTO tbx_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Xam putoung wei petieing me xam Parisiyeiw, xam ghe gwaleeng amim, xam wei myamim yuw o! Xam on ghe mi toung xomek mya wei tete lalei wei tyoung gheyapu nei yo zeyi moux alis vex mend. Xam venaxow seng la eivek, me xam ghe mi nale zeyi xel wei di wong me yei en embei na eivek o. ");
INSERT INTO tbx_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Xam putoung wei petieing me xam Parisiyeiw, xam ghe gwaleeng amim, xam wei myamim yuw o, en xam ghe mi wo nol wou xel vexeiv bend, me xam ghe mi tyoing lek me ghe mi zeimemam ding, nambei nyon tyek xam a qou myaveweeng ngandoung. ");
INSERT INTO tbx_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Xam putoung wei petieing me xam Parisiyeiw, xam ghe gwaleeng amim, xam wei myamim yuw o! Xam ghe mi ghavineeng lek tembuing me mamileeng being bong tambiy tixemou bo betiyeing wei xam o, me gyeik e wong ambei betiyeing ti, eno xam ghe mi wong moux on la eivek nilul ngandoung eno ghanaw veil eivek nenyex wei luta yo nambei xam venaxow. ");
INSERT INTO tbx_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Xam wei matekeing ambei talex sakwaing wou xomaxoneing bamba eno xam ghe gwaleeng amim. Xam ghe mi neimbei, ‘Wangwei tambiy ti na neil zonghek is inyapunei lek xomek vambuing, ond inyon se byexaxoun qayeeng. Ekom wangwei e neil zonghek is inyapunei lek ghol wei xomek vambuing o, ond inyon byexaxoun qayeeng.’ ");
INSERT INTO tbx_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Xam on bandol me mamim tekeing! Tina inye ngandoung, ghol o xomek vambuing wei wong ghol wo vambuing o? ");
INSERT INTO tbx_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xam ghe mi neil is ambei nyon bei, ‘Wangwei xelti e neil zonghek lek qeind is inyapunei ond inyon se byexaxoun qayeeng, ekom wangwei xelti neil zonghek is inyapunei lei lek xound wei toundei lek qeind, ond inyon byexaxoun qayeeng.’ ");
INSERT INTO tbx_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Xam moux wei mamim tekeing o. Tina inye ngandoung, xound o qeind wei wong xound on wo vambuing o? ");
INSERT INTO tbx_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Nambei inyon, tambiy tiwei neil zonghek is inyapunei lei lek qeind on neil zonghek is inyapunei lei lek lulul dalus wei toundei lek o. ");
INSERT INTO tbx_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Me tiwei mi neil zonghek is inyapunei lei lek xomek vambuing eno neil lek tiwei mindei eivek o. ");
INSERT INTO tbx_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Me eti neil zonghek is inyapunei lei lek tyoung gheyapu eno neil lek Anutu xe siaking me tiwei mindei lek o. ");
INSERT INTO tbx_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Xam putoung wei petieing me Parisiyeiw, xam ghe gwaleeng amim, xam wei myamim yuw o! Xam ghe wong ti eivek xoumeeng wei lul senyeing wei xuk lalei. Ekom xam ghe saing qayeeng ngandoung dalus wei petieing o veil, nambei qayeeng bombek, lalei pyaweing me wongeingis. Xam betiwou qayeeng ngandoung wei petieing ne yo dom xam naleimim se ma petieing bamba. ");
INSERT INTO tbx_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Xam wei mamim tekeing wei ghe mi talex sakwaing! Xam ghe mi tiy mamayek veil xam xe louk, ekom xam ghe lep kamel. ");
INSERT INTO tbx_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Xam putoung wei petieing me Parisiyeiw, xam ghe gwaleeng amim, xam wei myamim yuw o! Xam ghe mi sekweyexe mayamya me dipek demi, ekom eivek lalei eno pup en kwa eivekeing me ghe mi wou kwamim ngenong en lulul leimalei. ");
INSERT INTO tbx_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Xam Parisiyeiw wei mamim tekeing o! Myaxeeng eno xam sekweyexe mayamya me dipek lalei bole, dekakom demi embo vako is. ");
INSERT INTO tbx_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Xam putoung wei petieing me Parisiyeiw, xam ghe gwaleeng amim, xam wei myamim yuw o! Xam on nambei leiveeng meyeing wei xel pelei pen teleing lek o, wei wo nimza maseim lek demi yo, ekom lalei yon pup en xel meyeing kanzek me lul dalus wei nilaxes o. ");
INSERT INTO tbx_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Xam is ambei nyon eivek sakwaing kayon, eno xel mi yei xam lek demi om xel embeik nge xam on bombek, ekom xam laleimim on pup en kwa wei tyonyeing me kwa wei pyaweing lek qayeeng o. ");
INSERT INTO tbx_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Xam putoung wei petieing me Parisiyeiw, xam ghe gwaleeng amim, xam wei myamim yuw o! Xam ghe ev leiveeng meyeing en xel poropetyeiw me ghe vunekwou leiveeng wei xel bombek o. ");
INSERT INTO tbx_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Me xam ghe neil, ‘Wangwei xa mendei eivek bouk wei xa bumiyeiw, tyek xa se teyei bei devind xel me na nyeis xel poropet a mey.’ ");
INSERT INTO tbx_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Om xam venaxow ghe talex lek xow bei xam on neumambu wei xel wei leis poropetyeiw mey o. ");
INSERT INTO tbx_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Woyom xam la wong sewokeing teyei lek ingwei bumyeiw mi wong o. ");
INSERT INTO tbx_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Xam on myeiy me myeiy nilul neuyeiw xam! Tyek xam a pek veil myaveweeng wei nenyex luta yon nambei nya? ");
INSERT INTO tbx_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nambei nyon tyek a bong xel poropetyeiw me xel wei lundpeyei nimza me xel putoung wei petieing o nak wou xam. Xel valu tyek xam ghe nyeis xel a mey dom na tuw valu lek xax pepeeng, de xel valu tyek xam ghe bo nol wou xel eivek xomek qekueing ama me na tiy xel na beyeeng nge me na nge. ");
INSERT INTO tbx_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Om nambei nyon, xel dalus bombek gyand wei xel leis xel mey lek tembuing eno tyek mendei lek xam, qandi eivek Abel wei bombek o tax me e na Belekia neu moux Sakalias, tiwei xam ghe leis e mey eivek xomek vambuing me qeind senghoing o. ");
INSERT INTO tbx_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","A neil wou xam zonghek, lul nimaying dalus tine tyek nam lek xam qendu ti gweimbeeng ne dalus. ");
INSERT INTO tbx_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O Yerusalem, Yerusalem, xam eti yeiw wei ghe mi leis xel poropetyeiw me ghe nex xel wei lak wou xam en qakous. Taxombouk eno ambei mi qeku xam neumimyeiw lekti, nambei qouklex mi qekuwou neuyeiw eivek banis xeinghembi yo, ekom xam laleimim se vind. ");
INSERT INTO tbx_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wei, xam xe xomek tyek lelolexe me mendei bandaing. ");
INSERT INTO tbx_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","En a neil wou xam bei, tyek xam seng nox gwei a no qe ka xam a neimbei, ‘Mata ena wou e tiwei lam eivek Tambiy Ngandoung lei yo.’ ” ");
INSERT INTO tbx_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu la veil xomek vambuing on me la eno e xe xel betiyeing la wou e. En xel embei talex xomek nimzamza wei toungale is xomek vambuing o wou e. ");
INSERT INTO tbx_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Moxo neil, “Xam ghe wei lulti beimambei ne? A neil wou xam zonghek bei, tyek xel se teyei bei bong qakous nge mendei lek nge, qe tyek xel banex dalus deteina.” ");
INSERT INTO tbx_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ka Yesu toundei lek lukendu Oliv, xel betiyeing venaxow lam wou e me teling. “Neil wou xa, gyeik inya tyek tine belup, me dee vati tyek nam a tax en ingwei wa being nam o me ingwei bouk na tip lek o?” ");
INSERT INTO tbx_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu lewexe, “Xam ghe gweiteyei xow en kandek xelti se nam a tyoxe xam. ");
INSERT INTO tbx_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","En tyek xel ngenong nam lek a leing, me na neimbei, ‘A Kilisi yo,’ me na tyoxe xomaxoneing ngenong. ");
INSERT INTO tbx_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Tyek xam a ngo vevek me qayeeng laweeng wei vevek o, ekom xam seng gwaleeng. Lulti beimambei ne tyek neing atyip, ekom bouk loxyus eno se ghei lam. ");
INSERT INTO tbx_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tembuing nge tyek qandi me bo vevek is tembuing nge, me tete lalei nge tyek bo vevek is tete lalei nge. Inyon tyek maxep ngandoung me tyek tembuing api nanghei beyeeng danghei danghei nei. ");
INSERT INTO tbx_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lul dalus ne inye myavanei nambei myaxeeng wei yak mi umbek o. ");
INSERT INTO tbx_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Woyom tyek xel a zeimaxoun xam me bo nol wou xam de nyeis xam amey, me tembuing sapa tyek laleind bo nol wou xam en ay. ");
INSERT INTO tbx_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Lek bouk kayon xel ngenong tyek na toung demind wou xel xe wongeingis de tyek xel a dax ama vun me laleind bo nol wou ma, ");
INSERT INTO tbx_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","me poropet tyonyeing ngenong tyek nam a tyip me na tyoxe xomaxoneing ngenong. ");
INSERT INTO tbx_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","En kwa nilul on tyek bo ngandoung, de xel ngenong tyek na saing kwa wei lalei vineing o, ");
INSERT INTO tbx_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ekom eti yeiw wei nale nikanzek me ena bouk loxyus eno tyek Anutu devind xel veil meyeing. ");
INSERT INTO tbx_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","De Xoulek Nimza tine en tete lalei eno tyek xel a neil e na eivek tembuing dalus en tembuing sapa na ngo, de woyom bouk loxyus eno tyek nam. ");
INSERT INTO tbx_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Deka xam ghe gwei lul nilul ayang, wei mi wo nol wou lulul eno bale eivek beyeeng vambuing on nambei poropet Daniel neil en o.” Daniel 9:27 (Yon xam wei ghe mi pyaw qayeeng ne eno xam woulek e wo nimza.) ");
INSERT INTO tbx_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Woyom eti yeiw wei mindei eivek Yudia eno xel a pek me na lek lukendu. ");
INSERT INTO tbx_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","De wangwei tambiy ti toumendei lek xomek demi qetyei eno tyek se detei nox a qou lul valu eivek beeng lalei. ");
INSERT INTO tbx_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","De tambiy ti toumendei eivek xuk eno se teyei bei nox me na qou e xe teimb ding nge. ");
INSERT INTO tbx_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Inyon tyek bo nilul ayang lek bouk tiyon en xel vex wei xeipouyek o me tayeiw wei di wo luul wou neu yo! ");
INSERT INTO tbx_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Xam a zeimemamim enok bouk wei pekeing eno qandi lek bouk wei nityuweing o lek bouk wei Sabat o. ");
INSERT INTO tbx_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","En lek bouk tiyon nimaying ngandoung tyek nam. Myaxeeng wei tembuing qandi vako yo me elam tyip gweimbeeng ne, eno nimaying ambei nyon se lam tulek xomaxoneing, de loxyus eno nimaying ambei nye tyek se nox atyip no. ");
INSERT INTO tbx_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Wangwei Anutu se qateiv bouk tiyon bo sepi, yond tyek qetya xomaxoneing on veil, ekom wounalei en moux alis vex wei beyal om qateiv bouk wo sepi. ");
INSERT INTO tbx_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Lek bouk kayon eno wangwei xelti na neil wou wang bei, ‘Wei, Kilisi inye!’ o, ‘Moxo inyei!’ ond wang seng bongis qayeeng on. ");
INSERT INTO tbx_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","En xomaxoneing tyonyeing valu tyek na neimbei a Kilisi o a poropet ti. Me tyek xel nam a tyip me bong dee me lulvako, wangwei xel teyei nei on tyek xel a tyoxe xomaxoneing wei Anutu beyal o. ");
INSERT INTO tbx_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wei, a neil wou xam a tax en lul dalus tine wei tyek nam atyip o. ");
INSERT INTO tbx_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Om wangwei xelti e neil wou xam, ‘Wei, moxo toundei eivek tembuing bandaing nei,’ yon xam seng na inyei, o ‘Moxo inye, toundei eivek xomek lalei nei,’ ond xam seng bongis. ");
INSERT INTO tbx_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","En nambei kawei zivip mi nex mema lam anghei ninei is xeiyaing me byex la lek tembuing tambak nei me la xeinei, om tyek bong ambei nyon lek bouk wei Xomaxoneing Neu Moux embei noum o. ");
INSERT INTO tbx_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Lek beyeeng wei meyeing mi yeip lek o, inyon xel tuw mi qeku lak inyon. ");
INSERT INTO tbx_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ka nimaying sapa tine na ma veil le, woyom lutika eno “‘sayeiv tyek bo mapetok, de dentouk tyek se teyeimbei tel, me betum tyek detei nanghei tyoung nei, de tyoung dalus tyek bo pimapi.’ ");
INSERT INTO tbx_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Lek bouk kayon dee wei Xomaxoneing Neu Moux tyek nam mendei yaingateiv eivek tyoung, me xel veleivlei dalus wei tembuing eno tyek deeng. De tyek xel gyei Xomaxoneing Neu Moux mendi nam lek laxap, is nikanzek me xeiyaing ngandoung. ");
INSERT INTO tbx_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Me moxo tyek bong e xe angelayeiw na is vukxax wei wo vya xoulekeing, me tyek xel qekuwou e xe xomaxoneing wei beyal o eivek tembuing sapa me ena tembuing myasepu dalus. ");
INSERT INTO tbx_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Woyom xam a qou kwa wou xax basunghek. Gyeik xam ghe gwei bei xax mema wo nilouk me lis vako byex lek, xam ghe boulek bei bouk wei seiv embei siing eno lam paviy. ");
INSERT INTO tbx_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nambei nyon om gyeik xam ghe gwei lul dalus ti beimambei ne, xam ghe boulek bei Xomaxoneing Neu lam paviy me toungale wou qapomb. ");
INSERT INTO tbx_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","A neil wou xam zonghek bei, xel moux alis vex ti gweimbeeng ne tyek se mey qe ka lulti beimambei ne neing atyip le. ");
INSERT INTO tbx_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tyoung gheyapu me tembuing tyek nati, ekom a xe qayeeng tyek se teyei bei nati. ");
INSERT INTO tbx_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Xelti se woulek bouk o seivma wei Kilisi embei noum o, xel angela eivek tyoung gheyapu, o Neu moux se woulek, qe Ma venaxow. ");
INSERT INTO tbx_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nambei ingwei eivek bouk wei Noaka yo, om tyek xel bong ambei kayon eivek bouk wei Xomaxoneing Neu Moux embei noum o. ");
INSERT INTO tbx_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Myaxeeng lek bouk wei memiing se ghei butek o, xomaxoneing mi ya me num, me iima, me iima lox me loum, me la tyip wou bouk wei Noaka la eivek sip o. ");
INSERT INTO tbx_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Xel se woulek vati wei embei belup wou xel o dekakom memiing butek me qou xel dalus me la. Kwa kayon eno tyek bong ambei nyon lek bouk wei Xomaxoneing Neu Moux noum o. ");
INSERT INTO tbx_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Moux yayuw toundei eivek xuk yaeing eno tyek Anutu na qou nge na veil de nge na toumendei. ");
INSERT INTO tbx_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Vex yayuw tyek mendi zouk wit, de tyek Anutu na qou nge de nge na toumendei. ");
INSERT INTO tbx_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Nambei nyon xam ghe gweiteyei xow, en nambei xam seng woulek bouk vati wei xam xe Tambiy Ngandoung tyek nam o. ");
INSERT INTO tbx_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ekom xam ghe bou naleimim bei, wangwei xomek ma boulek seivma vati wei xel panaxeing embei nam o, moxo tyek mendei bin e xe xomek en kandek xelti se dembu me na eivek. ");
INSERT INTO tbx_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Om xam is ambei nyon xam ghe gweiwou xow, en Xomaxoneing Neu Moux tyek nam lek seivma wei xam seng woulek bei tyek nam o. ");
INSERT INTO tbx_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Woyom xukxe eti ingwei lupeyei nimza wei mi yeiteyei e xe xuk wo nimza nei? Wei e xe teiv toung e yeiteyei xel xukxe eivek e beeng bei e mi bong yaeing wou xel lek bouk wei teiv beyal o bombek? ");
INSERT INTO tbx_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Inyon nimza wou xukxe tiyon wei e xe teiv yei bei moxo mi wong xuk on gyeik e loum o. ");
INSERT INTO tbx_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","A neil wou xam zonghek bei, teiv tyek na toung embo lei ngandoung en lul dalus eivek e beeng. ");
INSERT INTO tbx_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ekom wangwei xukxe tiyon tambiy nilul ti om mi neil wou xow, ‘A xe teiv la toundei dingta takwei nei,’ ");
INSERT INTO tbx_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","woyom moxo la me leis e xe xel wei xel xouing mi wo xuk lekti yo, de mi ya me num is xel wei mi num me wo nol o. ");
INSERT INTO tbx_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Teiv wei xukxe tiyon tyek noum lek bouk wei xukxe se woulek me seivma wei se woulek o. ");
INSERT INTO tbx_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Teiv tyek bo myaveweeng ngandoung wou e me na toung e na is xel wei myend yuw o, nanghei inyon eno tyek xel deeng me xel newound bo nyiknyik. ");
INSERT INTO tbx_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Lek bouk kayon eno tete lalei wei tyoung gheyapu eno tyek ghok ambei vexawo xoumeeng wei paleveeng eno qou xel xe lam me la bei na daxe moux wei embei dii vex o. ");
INSERT INTO tbx_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Xel lim eno loungeing de xel lim eno lundpeyei nimza. ");
INSERT INTO tbx_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Xel lim wei loungeing eno qou xel xe lam ekom xel se qou wel ti is. ");
INSERT INTO tbx_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","De xel wei lundpeyei nimza eno xel qou wel eivek qakous botol is xel xe lam. ");
INSERT INTO tbx_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Tambiy wei embei dii vex eno se lam daing, om xel xouing mend yeip om xel yeip. ");
INSERT INTO tbx_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Lek boukeing masenghoing eno xel ngo taxeing ti lam, ‘Wei, inye tambiy wei embei dii vex eno lam! Xam lam myayaing me la pelong e!’ ");
INSERT INTO tbx_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Woyom xel vexawo paleveeng tiyon dalus qandi lek me yeiwou xel xe lam. ");
INSERT INTO tbx_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Xel wei loungeing eno neil wou xel wei lundpeyei nimza yo, ‘Xam wong xam xe wel valu wou xa, en xa xe lam embei mey.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Xel neil elox bei, ‘Ma, wel ne se teyei xam me xa is. Embong ondek xam ghe na wou eti yeiw wei mi wo vateivek lek wel o, me ghe na bou valu wou venaxow.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Om ka vex lim on tupwou sakwaing bei na bou wel, tambiy wei embei dii vex eno lam tyip. Vexawo paleveeng wei yeiwou xow eno la lalei is e me la mata ngandoung wei iingama yo. Dom qepei qapomb lox zeyi. ");
INSERT INTO tbx_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kalekom vexawo lim wei loungeing on lam is ambei nyon me neil, ‘Teiv! Teiv! Tax qapomb veil xa!’ ");
INSERT INTO tbx_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ekom moxo neil elox bei, ‘A neil zonghek wou xam bei a loung en xam.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Nambei nyon om xam ghe gweiteyei xow, en xam seng woulek bouk o seivma vati wei embei noum o.” ");
INSERT INTO tbx_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu neil no, “Anutu xe tete lalei inye nambei tambiy ti embei na sakwaing anding, om moxo taxe e xe xel xukxe me toung lul dalus eivek xel memend bei xel a mi gyeiteyei. ");
INSERT INTO tbx_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Moxo wong malew 5,000 wou ti, de malew 2,000 wou nge de malew 1,000 wou nge teyei lek nikanzek wei xel titi yo. De woyom moxo la sakwaing anding. ");
INSERT INTO tbx_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Tambiy tiwei qou 5,000 eno la me wong xuk daing me qou malew valu is no teyei lek malew 5,000. ");
INSERT INTO tbx_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Om nambei nyon is, nge wei qou malew 2,000 eno wo xuk me qou 2,000 lek mapu. ");
INSERT INTO tbx_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ekom tambiy tiwei qou malew 1,000 eno qou inyon dom la, de ev leiveeng eivek tembuing me vun e xe teiv xe malew eivek. ");
INSERT INTO tbx_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ka xel xe teiv la dei enden woy, om moxo loum wou xel xukxe om embei menyex wou malew wei toung is xel o. ");
INSERT INTO tbx_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Moux tiwei qou malew 5,000 eno qou 5,000 nge is me lam. Moxo neil, ‘Teiv, wang wong 5,000 wou ay. Wei, a qou malew 5,000 lek mapu is.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“E xe teiv neil elox bei, ‘Nimzayang, wa xukxe nimza me wang mi wo xuk wo nimza! Wang mi weiteyei xuk wo nimza is lul nayaka. Om tyek a toung wang gweiteyei lul ngenong. Lam me wo xeimlala is wa xe teiv!’ ");
INSERT INTO tbx_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Moux wei qou malew 2,000 eno lam is ambei nyon. Moxo neil, ‘Teiv, wang wong malew 2,000 wou ay. Wei, a wo xuk me na qou 2,000 is no.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“E xe teiv neil elox, ‘Nimzayang, wa xukxe nimza me wang wo xuk wo nimza! Wang mi weiteyei xuk wo nimza is lul nayaka. Om tyek a toung wang gweiteyei lul ngenong. Lam me wo xeimlala is wa xe teiv!’ ");
INSERT INTO tbx_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Woyom tambiy wei qou malew 1,000 eno lam. Moxo neil, ‘Teiv, a woulek woy bei wang on tambiy wei nimseikeing o, wang mi qou neing eivek xuk wei se wa memam xuk o, me ghe mi qekuwou vei wei wa seng vuw o. ");
INSERT INTO tbx_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Om a xaleeng me na la vun wa xe malew eivek tembuing. Wei, Inye vati wei wa xe yo.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“E xe teiv neil elox bei, ‘Wa xukxe nilul wei qabonghapus o! Om wang woulek inyon bei a mi qou neing wei se a memang xuk o me na qekuwou vei wei a se vuw o? ");
INSERT INTO tbx_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Inyon nimza, wang teyei bei toung a xe malew eivek xomek wei malew o, en kandek gyeik ingwei ambei noum ond a na qou is ingwei xel toung valu lek mapu is o. ");
INSERT INTO tbx_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Xam qou malew on veil e me wong e la wou tambiy wei qou malew 10,000 o. ");
INSERT INTO tbx_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","En xel dalus wei qou lul valu woy eno tyek na qou valu lek mapu, en e qou lulul ngenong. Ek wangwei xelti xe lul nayaka ond tyek na zeim lul nayak kayon veil e. ");
INSERT INTO tbx_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Dom banex xukxe nilul on na myayaing eivek mapetok ngandoung. Nanghei inyon eno tyek na deeng de zanga newou bo nyiknyik.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Gyeik ingwei Xomaxoneing Neu Moux embei noum eivek e xe xeiyaing ngandoung, me xel angela dalus is e, eno tyek moxo mendei lek e xe siaking eivek xeiyaing ngandoung wei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Xel xomaxoneing dalus lek tembuing sapa tyek qeku nam wou e manghalus, de moxo tyek na pum xomaxoneing na yuw nambei gyovaxa mi pum sipsip veil xel meme yo. ");
INSERT INTO tbx_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Moxo tyek na toung sipsip na wou mema payeiv de xel meme na wou mema qeinz. ");
INSERT INTO tbx_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Woyom king tyek na neil wou xel wei dei wou e mema payeiv o, ‘Xam tiwei Mang wong mata wou xam eno xam lam, xam a qou xam xe lul dalus eivek tete lalei wei menyex wou woy wou xam gyeik ingwei toung tembuing o. ");
INSERT INTO tbx_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","En maxepya ay eno xam ghe wong yaeing valu me a xa. A kwang tip en memiing eno xam ghe wong me a num. A ne nambei xel amba ekom xam ghe qou ay me la eivek xomek lalei. ");
INSERT INTO tbx_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Teimb ma veil ay ekom xam ghe byex teimb lek ay. Vanei wong ay ekom xam ghe weiteyei ay. A la eivek xeitueing ekom xam ghe lam wei ay.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Woyom xel wei bombek eno tyek na neil e nox wou e, ‘Tambiy Ngandoung, gyeik inya xa xei maxepya wang me na vet wang, o wa kwam tip me xa wong numeing wou wang me wang num? ");
INSERT INTO tbx_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gyeik inya xa xei wang on nambei xel amba om xa qou wang lam, o teimb ma veil wang om xa vunekwou wang? ");
INSERT INTO tbx_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gyeik inya xa xei wang wo vanei o wang la eivek xeitueing me xa lak a xei wang?’ ");
INSERT INTO tbx_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“King tyek na neil enoum, ‘A neil wou xam zonghek, vati wei xam ghe wong wou a lingyeiw ti beimambei ne ti wei lei maeing o, ond inyon xam ghe wong wou ay.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Woyom moxo tyek na neil wou xel wei dei wou e mema qeinz o, ‘Xam la veil ay, xam eti yeiw wei ghe dei eivek myaveweeng o, xam la eivek nenyex wei se mi mey yo wei xel menyexwou tambiy mapetok me e xe angelayeiw o. ");
INSERT INTO tbx_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","En maxepya ay ekom xam seng wo lulti wou ay bei angha. A kwang tip, ekom xam seng wong lulti me a num. ");
INSERT INTO tbx_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","A lam ambei xel amba, ekom xam seng qou a la eivek xomek. A teimb ma ekom xam seng byex teimb ti lek ay. Vanei wong ay me a la eivek xomek xeitueing ekom xam seng weiteyei ay.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Tyek xel a neil enox bei, ‘Tambiy Ngandoung, gyeik inya xa xei maxepya wang o wa kwam tip o wang lam ambei xel amba o teimb ma o vanei wong wang o wang toundei eivek xeitueing ekom xa se vind wang?’ ");
INSERT INTO tbx_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Moxo tyek na neil enox bei, ‘A neil wou xam zonghek, vati wei xam seng wong wou tiwei lei maeing en lulti beimambei ne, ond xam seng wong wou ay.’ ");
INSERT INTO tbx_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Woyom tyek xel na qou myaveweeng wei luta yo, dom xel wei bombek eno tyek na qou mapieing luta luta.” ");
INSERT INTO tbx_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ka Yesu neil qayeeng ti beimambei yon ma woy, moxo neil wou e xe xel betiyeing bei, ");
INSERT INTO tbx_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Xam ghe woulek woy bei, bouk yayuw xemou nanghei di yeip zeyi Pasova, ingwei Xomaxoneing Neu Moux tyek xel bong ena wou xel en xel a tuw e lek xax pepeeng o.” ");
INSERT INTO tbx_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Woyom xel lumuki leitata me xel teivateiv wei xel xomaxoneing qekuma eivek xomek wei lumuki lukanzek, wei lei Kaiapas o, ");
INSERT INTO tbx_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","me xel di luk me yimexe sakwaing wei xel embei tyoxe me na zeimaxoun Yesu me nyeis e mey o. ");
INSERT INTO tbx_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Xel neil ambei nye, “Ekom se lek bouk wei mata ngandoung o, enok xel xomaxoneing on baluk ngenong de nyeis ama.” ");
INSERT INTO tbx_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ka Yesu la Betani me la toundei eivek xomek wei tambiy ti lei Simon, wei takwei eno qou vanei lepa, ");
INSERT INTO tbx_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","de vex ti lam wou e is botol qakous wei wel xeimangou wei malew ngandoung o, de vex on taw wel lek e lu gyeik moxo di yeip pepenyeing lek zek o. ");
INSERT INTO tbx_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ekom xel betiyeing yei tine, eno xel laleind wou nilul, me neil, “Nambei nya vex ne wo nol wou wel ne? ");
INSERT INTO tbx_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wel tine teyei bei xey a bo vateivek lek me na qou malew ngandoung me na bong wou xel kanyoyeiw o.” ");
INSERT INTO tbx_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu woulek inye woy, om neil wou xel, “Nambei nya xam ghe wong nimaying wou vex ne? Vexo wong lul nimza tine wou ay. ");
INSERT INTO tbx_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Xel kanyoyeiw eno tyek na mi mendei is xam taxombouk, dom ay tyek a se mendei is xam taxombouk. ");
INSERT INTO tbx_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Vex ne taw wel lek aneing, om vexo wong inye bei menyex wou a neing en eveing eivek leiveeng meyeing. ");
INSERT INTO tbx_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A neil wou xam zonghek, eivek tembuing sapa wei xel embei na neil Xoulek Nimza nei eno tyek xel a mi neil vati wei vex ne wong ne, me tyek xel a mi bou naleind en e.” ");
INSERT INTO tbx_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Woyom xel xoumeeng yuw on ti lei Yudas Iskariot la wou xel lumuki leitata ");
INSERT INTO tbx_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","me teling, “Xam ambei tyek ghe bong vati wou ay wangwei am bong e nak wou xam nei?” Om xel pyaw memend wou malew teyei lek silva xoumeeng yal (30) wou e. ");
INSERT INTO tbx_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Woyom nanghei inyon me ela eno Yudas di yimexe sakwaing wei embei bong Yesu na eivek xel memend o. ");
INSERT INTO tbx_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lek bouk atax wei Bouk Wei Yaeing Belet Wei Yis Ma Veil o, xel betiyeing lam wou Yesu me teling, “Wambei xa na menyex wou yaeing anghei inya en kandek wang gwa Pasova?” ");
INSERT INTO tbx_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Moxo neil elox, “La eivek beyeeng ngandoung on me ghe na wou tambiy tinei me na neil wou e, ‘Putoung neil embei: A xe bouk wei xel beyal eno paviy. Ay is a xe xel betiyeing bei nak angha Pasova eivek wa bam.’ ” ");
INSERT INTO tbx_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Om xel betiyeing wong ambei kawei Yesu neil wou xel o me menyex wou Pasova. ");
INSERT INTO tbx_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Gyeik ingwei di souk, eno Yesu la dei lek lelek is xel betiyeing xoumeeng yuw. ");
INSERT INTO tbx_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ka xel di ya, moxo neil, “A neil wou xam zonghek bei, xam on ti tyek na neil a teyei me na toung ay eivek xel vevek amba memend.” ");
INSERT INTO tbx_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Xel laleind wo nimaying me xel titi di neil wou e bei, “Tambiy Ngandoung, Beip se ay?” ");
INSERT INTO tbx_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu neil elox bei, “Tiwei embei toung mema eivek dipek is ay eno tyek na neil a teyei me na toung a na eivek xel vevek amba memend. ");
INSERT INTO tbx_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Xomaxoneing Neu Moux tyek na nambei kawei xel byex eivek xoulek en e yo. Ekom nimaying ena wou moux tiwei embei neil Xomaxoneing Neu Moux teyei, dom na toung e na eivek xel ba memend! Inye nimza, bei tambiy tiyon ta se bou e.” ");
INSERT INTO tbx_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Woyom Yudas tambiy tiwei embei neil e teyei me na toung e na eivek xel ba memend o neil, “Putoung, neing ayang beip se ay?” Yesu lewexe, “Nambei wang neil on.” ");
INSERT INTO tbx_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ka xel di ya, Yesu qou belet, de wong dange wou me dembu, de wong wou e xe xel betiyeing, de neil, “Xam qou me wa. Tine inye a neing.” ");
INSERT INTO tbx_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Woyom moxo qou mayamya, me wong dange wou dom wong wou xel de neil, “Xam dalus a num eivek. ");
INSERT INTO tbx_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Tine inye a gyand wei qokatu yo, en a qapyex lek xel ngenong bei e mi semaleeng sewokeing sapa. ");
INSERT INTO tbx_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","A neil wou xam, tyek a se nox me na num wain tine no me e mi na deka bouk tiyon tyek a num wain vako is xam eivek Mang xe tete lalei.” ");
INSERT INTO tbx_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Woyom xel wong lalo ti, de xel la myayaing me la lukendu Oliv. ");
INSERT INTO tbx_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Woyom Yesu neil wou xel, “Boukeing kane tyek xam xe wongeingis detei, en xel byex eivek xoulek eno nambei nye, “‘Tyek a nyeis tambiy wei mi yeiteyei sipsip o, dom xel sipsip na pek me davuna.’ ");
INSERT INTO tbx_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ekom tyek a qandi lek me na tax en xam me nana eivek Galili.” ");
INSERT INTO tbx_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petele neil elox bei, “Wangwei xel betiyeing dalus a saing xel xe wongeingis en wang, ond tyek a se teyei bei saing wang.” ");
INSERT INTO tbx_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu neil elox wou e bei, “A neil wou wang zonghek, boukeing kane, wei qouklex seng ghe sesa vya, tyek wang dax a vun luyal.” ");
INSERT INTO tbx_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ekom Petele neil embei, “Wangwei a mey is wang, ond a se teyei bei dax wang vund.” Me xel betiyeing dalus neil qayeeng kayon teyeima. ");
INSERT INTO tbx_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Woyom Yesu la is e xe xel betiyeing me xel la beyeeng ti lei Getsemani, me moxo neil wou xel, “Xam a toumendei inye nayaka le, dom a na inyei me na zeimemang bole.” ");
INSERT INTO tbx_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Moxo qou Petele me Sebedi neu moux luw xouing is e. Moxo lalei wo nimaying me axe nilul ayang. ");
INSERT INTO tbx_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Moxo neil wou lal, “A nung axe nimaying ngandoung om am bim a mey. Xam a toumendei inye me ghe gweiteyei is ay.” ");
INSERT INTO tbx_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Moxo dula nayaka, de yeip ma eivek tembuing me zeimema, “Mang, wangwei nambei nyon nei, ond teyei bei wa zeim mayamya tine veil ay. Ekom wa se betiwou a xe woueing nalei, qe wa betiwou wamaxow xe woueing nalei.” ");
INSERT INTO tbx_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Woyom moxo loumelam wou betiyeing yal on me yei lal di yeip o. Moxo teling Petele, “Se teyei bei mal mendi gweiteyei is ay teyei lek seivma ti? ");
INSERT INTO tbx_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Xam a mi gweiteyei me na zeimemamim en kandek xam se detei eivek axeing. Laweeng lalei vind bei bong xuk, ekom neing mi wong nimbayaing.” ");
INSERT INTO tbx_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Moxo lox me la luyuw no me zeimema, “Mang, wangwei mayamya tine se teyei bei ghanaw ay me a num, ond wa betiwou wamaxow laleim.” ");
INSERT INTO tbx_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ka moxo loumelam, moxo yei lal di yeip no, en nambei lal mend yeip. ");
INSERT INTO tbx_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Om moxo ghanaw xel me lox tiwei yal o no me zeimema, me neil ambei kawei yo no. ");
INSERT INTO tbx_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Woyom moxo loum wou e xe betiyeing me neil wou lal, “Xam anghei dei weip me ghe qou laweeng? Wei, seivma lam paviy, me gweimbeeng xel neil Xomaxoneing Neu Moux teyei me toung e la eivek xel wei sewokeing o memend. ");
INSERT INTO tbx_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Qandi lek, en xey a na! En inye tambiy wei embei neil a teyei me na toung a na eivek xel memend eno lam!” ");
INSERT INTO tbx_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ka moxo nanghei di luk, Yudas, tambiy tiyon eivek xel xoumeeng yuw eno lam tyip. Xel qendu ngandoung lam is e eno xel qou ngeyeing vevek me pebumeeng. Xel lumuki leitata me xel teivateiv wei xomaxoneing eno wong xel lam. ");
INSERT INTO tbx_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tambiy wei embei neil Yesu teyei me na toung e na eivek xel ba memend eno wong dee ti bei xel boulek: “Tiwei tyek a toung myang lek e ling ond moux tiyo inyon, om xam a zeimaxoun e.” ");
INSERT INTO tbx_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Lutika eno Yudas lam wou Yesu me neil, “Boukeing Putoung!” dom toung mya lek e ling. ");
INSERT INTO tbx_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu neil elox bei, “Gweleeng, wang bong vati wei wang lam en o.” Woyom xel moux on dulam paviy me zeimaxoun e. ");
INSERT INTO tbx_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ekom Yesu xe xelti mema la en e xe ngeyeing vevek, de tetei elam dom qateiv xukxe wei lumuki lukanzek on nenyalis tip veil. ");
INSERT INTO tbx_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu neil wou e, “Toung wa xe ngeyeing vevek on lox eivek beeng, en xel eti yeiw wei puw ngeyeing vevek tyek na mey angya ngeyeing vevek. ");
INSERT INTO tbx_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Xam ghe wou naleimim bei tyek a se teyei bei taxe Mang, me lutika eno moxo tyek bong xel angela ngenong ghanaw xel qendu xoumeeng yuw wei vevek o me nam devind ay? ");
INSERT INTO tbx_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ekom wangwei a bong ambei nyon on qayeeng wei di yeip eivek Anutu xe qapiya vambuing ne tyek se bo neing lek. En Anutu xe qapiya neil embei, lul dalus tine eno e nam belup wou ay.” ");
INSERT INTO tbx_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Lek seivma kayon eno Yesu neil wou xel qendu yon, “Beip a ne tambiy panaxeing me leiseing xel o, om xam ghe lam is ngeyeing aluw pebumeeng bei bo nol wou ay me na zeimaxoun ay? Bouk tambak ne a mindei eivek tete lalei wei xomek vambuing me na mi teyoxe xel, ekom xam seng zeimaxoun ay. ");
INSERT INTO tbx_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ekom tine dalus lam tyip nambei ingwei xel poropet byex eivek qapiya yo embo neing lek.” Woyom xel betiyeing dalus pek veil e me la. ");
INSERT INTO tbx_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Woyom xel moux wei zeimaxoun Yesu eno qou moxo me la wou lumuki lukanzek Kaiapas. Inyon xel putoung wei petieing me xel teivateiv wei di qekuma yo. ");
INSERT INTO tbx_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ekom Petele di betiwou e me la kwanding ka veil e. Moxo la eivek tete lalei wei lumuki lukanzek beeng o. Ka la dei inyon is xel belimbo, bei gyei vati wei embei belup wou Yesu yo. ");
INSERT INTO tbx_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Xel lumuki leitata me xel kanzol dalus di yimexe qayeeng tyonyeing wei xel embei neil lek Yesu en kandek xel na nyeis e mey en o. ");
INSERT INTO tbx_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ekom xel se yeiwou qayeeng ti, de xel ngenong lam neil qayeeng ekom ma. Dekalekom moux yayuw lam ");
INSERT INTO tbx_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","me neil embei, “Tambiy tine neil ambei nye, ‘A teyei bei lelolexe Anutu xe xomek vambuing de na nox me na dev eivek bouk yal.’ ” ");
INSERT INTO tbx_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Woyom lumuki lukanzek nale ghey me neil wou Yesu, “Se teyei bei wa neil qayeeng ti noum? Inye qayeeng vati ingwei xel di neil lek wang ne?” ");
INSERT INTO tbx_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ekom Yesu nanghei toungale kanzek. Om lumuki lukanzek neil wou e, “A teling wou wang eivek Anutu mapieing lei, Neil wou xa wangwei wa Kilisi, Anutu Neu Moux nei.” ");
INSERT INTO tbx_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu neil elox bei, “Ee, nambei kawei wang neil on. Ekom a neil wou xam dalus, kalekom tyek xam ghe gwei Xomaxoneing Neu Moux mendei wou mema payeiv wei Anutu tiwei Nikanzekta me di lam lek laxap wei tyoung gheyapu yo.” ");
INSERT INTO tbx_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Woyom lumuki lukanzek lex e xe teimb de neil, “Moxo lukyak lek Anutu yo! Nambei nya xey a ngo qayeeng valu is no? Wei, xam venaxow ghe ngo qayeeng lukeingyak wei e neil o. ");
INSERT INTO tbx_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Xam ghe wou naleimim ambei nya?” Xel neil elox bei, “Moxo teyei bei mey o.” ");
INSERT INTO tbx_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Woyom xel pesuv myend louk lek e manghalus me lund memend de venoux e, de xel valu petapexe e ");
INSERT INTO tbx_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","me neil, “Kilisi, wa neil qayeeng poropet wou xa. Eti leis wang?” ");
INSERT INTO tbx_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petele moxo toundei myayaing eivek tete lalei wei xomek o. Xukxe vexawo ti lam wou e me neil, “Wang is en wang mindei is Yesu wei Galili yo.” ");
INSERT INTO tbx_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ekom moxo axvun eivek xel dalus mend. E neil elox bei, “A loung en vati wei xam ghe di luk en o.” ");
INSERT INTO tbx_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Woyom moxo la myayaing wei tete mya nei. Inyon vexawo nge yei e me neil wou xel xomaxoneing nanghei inyon, “Tambiy tine mi la is Yesu wei Nasaret o.” ");
INSERT INTO tbx_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petele lox me la axvun no me neil zonghek is inyapunei bei, “A loung en moux tiyon!” ");
INSERT INTO tbx_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Kalekom xel wei toungale inyon eno la wou Petele me neil, “Neing ayang wang on xel xe ti, en xa woulek wa vyam wei wang di luk on.” ");
INSERT INTO tbx_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Woyom moxo neil vya lek xow me luk ninkanzek, “A neil neing wou xam bei, a loung en tambiy tiyon!” Se denlek en qouklex sesa vya. ");
INSERT INTO tbx_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Woyom Petele wou kwa en qayeeng wei Yesu neil o, “Qouklex se ghei sesa vya, eno tyek wang dax a vun luyal.” De moxo la myayaing me la eng ngandoungateiv mouyo. ");
INSERT INTO tbx_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Satiboukeing lulayang, eno xel lumuki leitata dalus me xel teivateiv wei xel xomaxoneing eno lam me di luklek qayeeng bei nyeis Yesu e mey. ");
INSERT INTO tbx_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xel tup e, de qou e me la wou eivek Pailat mema, lei ngandoung wei seyap o. ");
INSERT INTO tbx_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudas tiwei neil Yesu teyei me toung e la eivek xel vevek memend o, yei bei xel byex qayeeng lek Yesu woy bei nyeis e mey, om moxo kwa pakou no me qou malew selewa xoumeeng yal (30) wei xel lumuki leitata me xel teivateiv wong wou e yo me lox wong elox wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Moxo neil, “A wo sewokeing, en a neil tambiy wei nilul ma veil e yo teyei me na toung e lak eivek xam memamim.” Xel neil elox bei, “Inyon se dei yeip wou xa ti. Qe inyon di yeip wou wamaxow o.” ");
INSERT INTO tbx_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Om Yudas nex malew lox eivek xomek vambuing lalei dom la. Woyom Yudas venaxow la qo kwa me mey. ");
INSERT INTO tbx_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Xel lumuki leitata zeim malew lek me neil, “Inye se la teyei lek qayeeng petieing bei xey a toung malew tine na eivek deng xeikatu wei xomek vambuing yo, en inye malew wei qapyex gyand o.” ");
INSERT INTO tbx_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Om xel luk wouma me tup qayeeng bei dexouv tembuing wei xel wei mi betiy dengmuing o en malew tiyon en leiveeng meyeing wei xel amba yo. ");
INSERT INTO tbx_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Om qes ambei nyon xel mi taxe Tembuing on Gyand me elam tyip gweimbeeng ne is. ");
INSERT INTO tbx_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Woyom lul tine la teyei lek lulti Anutu neil eivek poropet Yelemia mya yo. “Xel qou malew selewa xoumeeng yal (30) on teyei lek ambei xouveing wei xel xomaxoneing wei Israel beyal bei dexouv tambiy tiyon o, ");
INSERT INTO tbx_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","me xel xouv tembuing wei xel wei mi betiy dengmuing en o ti, nambei Tambiy Ngandoung peti wou ay yo.” ");
INSERT INTO tbx_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Dekale Yesu nale wou lei ngandoung wei seyap o ma, me moxo teling e, “Beip wang on king wei Yudayeiw o?” Yesu neil elox bei, “Nambei wang neil on.” ");
INSERT INTO tbx_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","De woyom xel lumuki leitata me teivateiv byex qayeeng lek Yesu, moxo se neil qayeeng ti lox wou xel. ");
INSERT INTO tbx_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Woyom Pailat teling e, “Beip inye wa seng ngo pavulek wei xel di luk en wang ne?” ");
INSERT INTO tbx_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ekom Yesu se neil lulti lox, de se neil lulti lek qayeeng wei xel byex lek e yon, om tine wong lei ngandoung wei seyap o wounalei ngenong. ");
INSERT INTO tbx_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Lei ngandoung wei seyap o xe kwa wei mi betiwou lek bouk wei Pasova eno mi tul xeitueing ti la teyei lek xel moux alis vex mi beyal o laleind. ");
INSERT INTO tbx_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Lek bouk kayon eno tambiy nilul ayang ti lei Barabas eno toundei eivek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Om xel qendu yon qekuma, Pailat teling xel, “Luw nge na xam ambei a bong e nak wou xam, Barabas o Yesu wei xel mi taxe bei Kilisi yo?” ");
INSERT INTO tbx_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","En moxo woulek bei xel venaxow xe laleind nilul, om xel qou Yesu me wong wou e. ");
INSERT INTO tbx_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ka Pailat toundei lek sia wei ngoeing qayeeng o, moxo venei wong qayeeng tine lam wou e: “Kandek wa seng bong lulti lek moux wei bombek o, en inye a axe nimaying ngandoung ti gweimbeeng eivek maviing en e.” ");
INSERT INTO tbx_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ekom xel lumuki leitata me xel teivateiv zeim xel qendu ngandoung on laleind lek bei e bong Barabas na wou xel dom nyeis Yesu e mey. ");
INSERT INTO tbx_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Lei ngandoung wei seyap o teling, “Xam ambei a bong luw nge na, nak wou xam?” Xel lewexe bei, “Barabas.” ");
INSERT INTO tbx_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailat teling, “De tyek a bong vati wou Yesu tiwei xel taxe bei Kilisi ne?” Xel dalus lewexe bei, “Tuw e lek xax pepeeng!” ");
INSERT INTO tbx_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailat teling, “En va? E wong sewokeing vati?” Ekom xel taxe lox wou e niseikeing bei, “Tuw e lek xax pepeeng!” ");
INSERT INTO tbx_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat woulek bei tyek xel se ngo e vya, de inyon vevek ngandoung embei qandi lek, om moxo qou memiing me sekweyexe mema eivek xel qendu ngandoung on dalus mend. Moxo neil, “Inye se sewokeing wei ay yo en moux tine gyand. Qe inye di yeip wou xam venaxow!” ");
INSERT INTO tbx_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xomaxoneing dalus lewexe, “Wong e xe gyand on lam lek xa me lek xa neumiyeiw!” ");
INSERT INTO tbx_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Woyom moxo wong Barabas la wou xel. Dom neil wou xel vevekyeiw on bei xel sesa Yesu nangya yisviyeing, dekakom wong e la me xel tuw lek xax pepeeng. ");
INSERT INTO tbx_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Woyom xel vevek wei lei ngandoung wei seyap o qou Yesu me la lalei eivek xomek seyap me qeku xel dalusateiv wei vevekyeiw o nale vivekwou e. ");
INSERT INTO tbx_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xel kwax e xe teimb veil dom byex teimb ding gyand nge lek e no, ");
INSERT INTO tbx_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","de xel bembinexe yis wei ying o lekti nambei qelumking de toung lek e lu. Xel toung xax nayak ti eivek e mema payeiv de dundek wou e ma me luk seloukeing lek e. Me neil, “Bendiyeing, king wei xel Yudayeiw o!” ");
INSERT INTO tbx_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","De xel pesuv myend louk lek e, de xel qou e xe patongeeng me sesa e lu gya lumama. ");
INSERT INTO tbx_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ka xel luk seloukeing lek e woy, xel kwax teimb wei xel byex lek e eno veil dom byex e maxow xe teimb lek no. Woyom xel qou e me la bei na tuw e lek xax pepeeng. ");
INSERT INTO tbx_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Xel di tupwou sakwaing me la, eno xel la tyip wou tambiy wei Sairini yo ti, lei Simon, om xel tendu bei moxo e qalei xax pepeeng. ");
INSERT INTO tbx_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Xel lam tyip wou beyeeng tiwei xel mi taxe bei Golgata (E qes ambei nye bei Beyeeng wei Lukanzek o). ");
INSERT INTO tbx_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Nanghei inyon eno xel wong wain wei xel maleeng is lul senyeing o wou Yesu bei e num. Moxo num me axe le, ekom se num. ");
INSERT INTO tbx_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ka xel tuw e lek xax pepeeng woy, woyom xel nex qakous dee bei dembu e xe teimb wouma. ");
INSERT INTO tbx_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Xel dei tembuing, me di yei e teyei nanghei inyon. ");
INSERT INTO tbx_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Louk apu en e lu eno xel tuw qayeeng vati wei xel wong qayeeng en e yo bei: TINE INYE YESU, KING WEI YUDAYEIW O. ");
INSERT INTO tbx_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tambiy panaxeing yayuw eno xel tuw luw is e, nge wou e mema payeiv, de nge wou e mema qeinz. ");
INSERT INTO tbx_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Eti yeiw wei di lam me la eno lukyak lek e, me bimexe lund ");
INSERT INTO tbx_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","me neil, “Wa kawei wang neimbei tyek lelolexe xomek vambuing dom ghe dev vako eivek bouk yal o inyon, om vind xow! Wangwei wa Anutu Neu Moux nei, tei lam veil xax pepeeng!” ");
INSERT INTO tbx_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Eivek kwa kayon teyeima eno xel lumuki leitata me xel putoung wei petieing me xel teivateiv lukyak lek e. ");
INSERT INTO tbx_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Xel neil, “Moxo vind xel bamba, ekom se teyei bei devind venaxow! Wangwei e king wei xel Israel o, yon e detei nam veil xax pepeeng en kandek xey a bongis e. ");
INSERT INTO tbx_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Moxo mi wongis Anutu. Om wangwei Anutu lalei devind e nei yon e devind moxo, en mi neil embei, ‘A ne Anutu Neu Moux.’ ” ");
INSERT INTO tbx_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Eivek sakwaing ambei nyon eno panaxeing yuw wei xel tuw is e eno lukyak lek e is. ");
INSERT INTO tbx_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lek ingwei seivma evlek me e la seivma yal wei soukeing eno mapetok ngandoung sevunexe tembuing tambak on. ");
INSERT INTO tbx_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Me embim seivma yal eno Yesu taxe niseikeing bei, “Eloi, Eloi, lama sabaktani?” Qes ambei nye bei, “A xe Anutu, a xe Anutu, nambei nya wang saing ay?” ");
INSERT INTO tbx_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Woyom xel valu wei toungale inyon ngo tine, om xel neil embei, “Moxo taxe Eliya yo.” ");
INSERT INTO tbx_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Lutika eno xel xe ti veimya me la qou balam. Moxo toung eivek wain senyeing me e pup, de tup lek xax mema nayak ti, dom zeim e la wou Yesu mya bei e num. ");
INSERT INTO tbx_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Xel valu neil embei, “Wong xey a axe le bei, Eliya nam devind e.” ");
INSERT INTO tbx_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ekom Yesu nyayek niseikeing no, de wong e xe nulaweeng la dom mey. ");
INSERT INTO tbx_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lek kayon bombek eno qaeing ngandoung wei mii eivek xomek vambuing lalei eno lexla yayuw anghei pu me ela nge xo. De tembuing pi me wong qakous on dembu. ");
INSERT INTO tbx_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Leiveeng meyeing ngenong mya tax de xel vambuing ngenong wei mey eno neing qandi lek mapieing. ");
INSERT INTO tbx_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Xel lam myayaing veil leiveeng meyeing, deka Yesu qandi lek woy eno xel la eivek beyeeng vambuing Yerusalem me tyip wou xel xomaxoneing ngenong. ");
INSERT INTO tbx_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lei ngandoung wei vevek o is xel vevekyeiw toukale inyon is e me yei Yesu teyei eno yei tembuing pi me lul dalus tiwei qandi yon, om xel yaleeng, me neil, “Neing ayang tambiy tine inye Anutu Neu Moux!” ");
INSERT INTO tbx_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Xel vex ngenong toukale kwanding, me di yei. Xel on ingwei mi betiwou Yesu nanghei Galili bei na devind e. ");
INSERT INTO tbx_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Eivek vex vex on senghoing, inyon Maria wei Makdala me Maria wei Jems aluw Joses tend, me Sebedi neu luw tend. ");
INSERT INTO tbx_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ka moxo di souk, tambiy wei lulul ana eno lam anghei Arimatia, e lei Yosep. Moxo yon betiyeing wei Yesu yo ti. ");
INSERT INTO tbx_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","La wou Pailat, me teling wou en Yesu neing, om Pailat lewexe lek bei vevekyeiw bong Yesu neing na wou Yosep me e qou me na. ");
INSERT INTO tbx_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yosep qou neing on me beliv eivek qaeing teleing vako ti, ");
INSERT INTO tbx_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","me liw eivek e maxow xe leiveeng meyeing vako wei xel qateiv eivek qakous o. Dom moxo wilexe qakous ngandoung ti la zeyi leiveeng meyeing mya de la. ");
INSERT INTO tbx_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria wei Makdala luw Maria nge eno toundei inyon paviy leiveeng meyeing. ");
INSERT INTO tbx_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Bouk wei Yudayeiw mi menyex wou lulul wei yaing eno lak veil, de bouk Sabat eno xel lumuki leitata me Parisiyeiw la wou Pailat. ");
INSERT INTO tbx_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Xel neil wou e bei, “Teiv, xa wou naleimi en tambiy tiwei tyonyeing on wei nanghei toundei mapieing eno neil, ‘Ka bouk yal nak veil on tyek a qandi lek no.’ ");
INSERT INTO tbx_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Om wang bo qayeeng nikanzek en xel a toung leiveeng on mya zeyi embo nikanzek me ena tyip wou bouk yal. Enok e xe xel betiyeing nam me panax e neing dom na neil wou xel xomaxoneing bei moxo qandi lek veil meyeing. Tyonyeing tiwei yus ne tyek ghanaw tyonyeing wei wong a tax o.” ");
INSERT INTO tbx_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailat neil embei, “Xam a qou xel belimbo wei mi yeiteyei leiveeng meyeing mya yo ti. La wong leiveeng mya yon wo nikanzek nambei xam ghe wou naleimim en o.” ");
INSERT INTO tbx_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Om xel la lax leiveeng mya zeyi me toung newiy lek qakous dom wong xel belimbo la nale zeyi. ");
INSERT INTO tbx_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ka bouk wei Sabat eno la veil, me di wong en embei boyaing lek bouk ti myaxeeng wei sounda qes tiyon o, Maria wei Makdala is Maria nge la en embei na gyei leiveeng meyeing. ");
INSERT INTO tbx_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Woyom lutika eno tembuing pi ngandoung, en nambei Anutu xe angela lep me lam anghei tyoung gheyapu nei, me la ingwei leiveeng meyeing nei, me wilexe qakous la nale nenya dom dei lek. ");
INSERT INTO tbx_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","E ma yon siing ambei zivip, me e xe teimb on teltyip ambei laxap. ");
INSERT INTO tbx_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Xel belimbo yon yaleeng en e, me etek niseikeing de pewilexe la yeip lek tembuing ambei xel meyeing. ");
INSERT INTO tbx_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ekom angela neil wou vex yuw on, “Muw seng gwaleeng, en a woulek bei muw ghe di wimexe Yesu, wei xel tuw lek xax pepeeng o. ");
INSERT INTO tbx_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Moxo se toundei inye, en moxo qandi lek, nambei kawei neil o. Muw lam wei nimbeeng kawei yeip lek o. ");
INSERT INTO tbx_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Muw ghe na daing me ghe na neil wou e xe xel betiyeing, ‘Tambiy moxo qandi lek veil meyeing me la tax en xam me la Galili. Tyek xam ghe na gwei e nanghei inyei.’ Wei, a lam en ambei nam a neil wou xam.” ");
INSERT INTO tbx_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Om xel vex on tup me la nanghei ingwei leiveeng nei. Luw yaleeng ekom luw wo xeindlala mouyo, me veimyend bei na neil wou e xe xel betiyeing. ");
INSERT INTO tbx_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Se denlek en Yesu la tyip wou luw. Moxo neil, “Satiboukeing.” Luw lam wou me axlek e vaxa dom wo lalo wou e. ");
INSERT INTO tbx_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Woyom Yesu neil wou luw, “Muw seng gwaleeng. Muw la neil wou a lingyeiw bei xel na Galili, de tyek xel gyei ay anghei inyei.” ");
INSERT INTO tbx_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ka vex yuw on di la wou sakwaing, xel belimbo yon valu la eivek beyeeng ngandoung me la neil qayeeng on wou xel lumuki leitata en lul dalus wei belup on. ");
INSERT INTO tbx_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xel lumuki leitata is xel teivateiv qekuma me neil qayeeng ti. Xel wong malew ngandoung wou xel vevekyeiw, ");
INSERT INTO tbx_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","me neil wou xel, “Xam a neil ambei nye bei, ‘Gyeik ingwei xa xeip eno moxo xe xel betiyeing lam eivek boukeing me panax e neing de qou me la.’ ");
INSERT INTO tbx_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Wangwei qayeeng tine na wou lei ngandoung wei seyap o, tyek xa menyex wou qayeeng is e, en kandek xam seng na eivek nimaying.” ");
INSERT INTO tbx_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Om xel vevekyeiw qou malew on me wong ambei kawei neil wou xel o. De pavulek tine eno xel Yudayeiw mi neil e lala eivek ama senghoing me e lam tyip bouk ti gweimbeeng ne. ");
INSERT INTO tbx_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Woyom xel betiyeing xoumeeng ti la Galili, me la lukendu tiwei Yesu neil wou xel bei xel na yo. ");
INSERT INTO tbx_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gyeik xel yei e, eno xel wong lalo wou e, ekom xel valu laleind wo yuw. ");
INSERT INTO tbx_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Woyom Yesu lam wou xel me neil, “Lei wei ngandoung dalus eivek tyoung gheyapu me lek tembuing eno Anutu wong wou ay. ");
INSERT INTO tbx_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Nambei nyon xam ghe na bong xomaxoneing wei tembuing sapa ne bong ambei a xe betiyeing, me ghe zipek xel eivek Mang lei me Neu lei me Laweeng Vambuing lei, ");
INSERT INTO tbx_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","me teyoxe xel bei xel bongis lul tambak tiwei a mi peti wou xam o. Wei, inye neing ayang, a mindei is xam teyei lek bouk sapa ne, me tyek a mi mendei is xam me ena tyip wou bouk wei la tip lek o.”");
INSERT INTO tbx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Inye Xoulek Nimza wei myaxeeng en Yesu Kilisi, Anutu Neu Moux o eno nambei, ");
INSERT INTO tbx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Poropet Yesaya byex eivek xoulek eno nambei nye, “Wei! Tyek a bong a xe nenyalesana ti natax en wang, me tyek e menyex wou wa xe sakwaing.” ");
INSERT INTO tbx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Vya taxeing ti lam anghei myayaing wei tembuing bandaing nei, ‘Menyex wou sakwaing en Tambiy Ngandoung, me wong sakwaing e wo bombek en e.’ ” ");
INSERT INTO tbx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Om Yoan Lipekeing lam lipek xel eivek tembuing bandaing me neil xoulek bei xel pekwi xow en Anutu e semaleeng xel xe sewokeing veil en talex lek bei xel pekwi xow. ");
INSERT INTO tbx_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Me danghei wei Yudia nei eno xel dalus is xel dalus wei Yerusalem eno la wou e me neil xel xe sewokeing teyei. De Yoan lipek xel eivek memiing Yorodan. ");
INSERT INTO tbx_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yoan mi byex teimb wei xel menyex wou en kamel nivlus o me vex let wei leliy ninavi yo vivekwou xeikatu. Me mi ya zevak me beyexta nilouk wei qeis lalei yo. ");
INSERT INTO tbx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","De inye e xe xoulek, “Tambiy ti tyek nam yus en ay eno e xe nikanzek ghanaw ay. A se teyeimbei dundek me na tul yis wei e xe vaxalambes. ");
INSERT INTO tbx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A lipek xam en memiing, ekom moxo tyek zipek xam en Laweeng Vambuing.” ");
INSERT INTO tbx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lek bouk tiyon Yoan di lipek xel eno Yesu lam anghei Nasaret wei Galili nei me Yoan lipek e eivek memiing Yorodan. ");
INSERT INTO tbx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ka Yesu leklam veil memiing woyom moxo yei tyoung dembu me tax, me Laweeng Vambuing lep me lam lek e nambei menek beliy ti. ");
INSERT INTO tbx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","De vya ti lam anghei tyoung gheyapu me neil, “Wang on a Neung, wei a laleing vind o. A laleing wo nimza wou wang.” ");
INSERT INTO tbx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Se denlek en Laweeng Vambuing wong Yesu la eivek tembuing bandaing, ");
INSERT INTO tbx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","me Yesu la mindei eivek tembuing bandaing on teyei lek bouk xoumeeng vey (40), me Sandang wo axeing wou e. Moxo mindei is leliy leliy bemeeng de angelayeiw mi vind e. ");
INSERT INTO tbx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ka xel toung Yoan eivek xeitueing, woyom Yesu la eivek Galili, me neil Xoulek Nimza wei Anutu xe yo. ");
INSERT INTO tbx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","E neil, “Bouk wei Anutu neil atax eno wo neing lek. Me Anutu xe tete lalei lam paviy. Om xam pekwi xow me ghe bongis Xoulek Nimza!” ");
INSERT INTO tbx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ka Yesu di tupwou lounyeing Galili vi, moxo yei Simon me li Andrias. Luw di nex lewek eivek lounyeing, en luw mi wong xuk wei qoueing woing o. ");
INSERT INTO tbx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yesu neil, “Muw betiwou ay, me tyek a bong muw ghe bo xuk wei qoueing xomaxoneing o.” ");
INSERT INTO tbx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Lutika eno luw ghanaw luw xe lewek dom betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Gyeik Yesu dula nayaka eno yei Sebedi neu moux Jems me li Yoan toundei eivek bot me di senzi luw xe lewek. ");
INSERT INTO tbx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Moxo taxe luw lutika me luw ghanaw ma Sebedi eivek bot is e xe xukxe wei xouveing o dom betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xel la tyip Kapenaom, me gyeik bouk wei Sabat o lam eno Yesu la eivek xomek qekueing ama me di teyoxe xoulek wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Xel xomaxoneing on etek en qayeeng wei e di teyoxe wou xel on, en se teyoxe xel ambei xel putoung wei petieing o, qe nambei tambiy wei luk is nikanzek o. ");
INSERT INTO tbx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Se denlek en tambiy ti wei laweeng nilaxes toundei eivek e, me toundei eivek xomek qekueing ama is xel eno nyayek ngandoung bei, ");
INSERT INTO tbx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu wei Nasaret, wa being bo vati wou xa? Wang lam bei semaleeng xa veil? A woulek bei wang on eti. Wang on vambuing tiwei Anutu yo!” ");
INSERT INTO tbx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yesu neil e, “Tip lukeing. De lam myayaing veil tambiy yon!” ");
INSERT INTO tbx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Laweeng nilaxes on bimexe moux on nikanzek, de nyayek me lam myayaing veil tambiy on. ");
INSERT INTO tbx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Xomaxoneing tambak on dalus etek en inyon me xel teling ama, “Tine inye vati? Inye teyoxeing vako ti is nikanzek me neil laweeng nilaxes dom xel betiwou e vya.” ");
INSERT INTO tbx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pavulek wei e yo la wo tambak daing eivek tembuing danghei dalus wei Galili yon. ");
INSERT INTO tbx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Xel la veil xomek qekueing ama eno lutika xel la is Jems me Yoan bei na xomek wei Simon me Andrias o. ");
INSERT INTO tbx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon yeing avexta wo gying om di yeip lek zek, me se wo lululek eno xel neil wou Yesu en vexo. ");
INSERT INTO tbx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Om moxo la wou e, me zeim e mema de vind vexo dei ghey. Gying on la veil e dom vexo qandi me di yeiwou yaeing wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ka sayeiv teila me di wo mangamong eno xomaxoneing qou xel dalus wei vanei yo me memo nilul wei dei eivek o me la wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Xel beyeeng dalus on qekuma wou xomek mya, ");
INSERT INTO tbx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","me Yesu yeiwou xel ngenong wei xe vanei leimalei eno ma. Moxo tiy memo ngenong is ambei nyon, ekom se wong memo yon luk, en xel woulek bei e eti. ");
INSERT INTO tbx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Satiboukeing lulayang wei di wo matektekeing, eno Yesu qandi lek me lam veil xomek me la ingwei xel ma veil o, me la di zeimema. ");
INSERT INTO tbx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon me e xe laxousyeiw la bei na gyimexe e, ");
INSERT INTO tbx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","me gyeik xel yeiwou e, xel neil wou e, “Xomaxoneing dalus di yimexe wang!” ");
INSERT INTO tbx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu neil elox, “Xey ambei na beyeeng bamba wei paviyeing nei, en kandek a neil xoulek anghei inyon is. Qes tiyon om a lam.” ");
INSERT INTO tbx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Om moxo ghavineeng la eivek Galili, me la neil xoulek eivek xel xe xomek qekueing ama me tiy xel memo. ");
INSERT INTO tbx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tambiy tiwei vanei lepa yon lam wou Yesu me ev vaxa qatu eivek dom tay wou e, “Wangwei wa laleim e devind nei, yond wang bong am bo vako.” ");
INSERT INTO tbx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesu lalei pyaxow en moxo, yom tatei mema la me axlek moxo. Me neil, “A laleing vind. Wang bo vako!” ");
INSERT INTO tbx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Lutika eno lepa la veil e dom moxo wo vako. ");
INSERT INTO tbx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu wong moxo la lutika dom peti e nikanzek, ");
INSERT INTO tbx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Wang gweiteyei en wa se neil inye wou xelti. Ekom la talex xow wou lumuki me wong da la nambei ingwei Mose wo qayeeng petieing o bei neing ayang wang wo vako no, inye nambei pavulek ti wang bong ambei nyon en tyek xel boulek bei wang nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ekom ma, tambiy on la myayaing me neilteyei wou xel tambakateiv on, om qayeeng la wo sapa en vati wei e wong o. Om nambei nyon Yesu se teyeimbei na eivek beyeeng yanyateiv, om moxo mindei myayaing eivek beyeeng wei xel ma veil o. Ekom xomaxoneing nanghei di lam wou e nanghei beyeeng danghei danghei nei. ");
INSERT INTO tbx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Bouk valu lak veil, eno Yesu lox me la Kapenaom me xomaxoneing ngo bei e toundei eivek beeng. ");
INSERT INTO tbx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Om xomaxoneing ngenong qekuma om xomek lalei yon puplek, me elam myayaing wei xomek mya eno is, de moxo di neil Anutu xe xoulek wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Xomaxoneing valu lam, xel qou tambiy wei vaxa bezomb o ti me lam wou e, moxo kanzek mey, de xel vey qalei e lek lelek. ");
INSERT INTO tbx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Tyek xel se teyeimbei qou e me na wou Yesu en inye xel ngenong pup xomek lek, om xel gwang xomek demi qetyei nanghei kawei Yesu toundei eivek o, de xel wong tambiy wei vaxa bezomb on teila kaka is lelek wei di yeip lek o. ");
INSERT INTO tbx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Gyeik Yesu yei xel xe wongeingis, moxo neil wou vaxa bezombeing on bei, “A neung moux, wa xe sewokeing on a semaleeng veil.” ");
INSERT INTO tbx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","De woyom xel putoung valu wei petieing eno toundei inyon, xel venaxow di wou naleind naleind bei, ");
INSERT INTO tbx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Nambei nya xomaxoneing tine neil qayeeng ambei nyon? Moxo lukyak lek Anutu! Eti teyeimbei semaleeng sewokeing veil, qe Anutu venaxow?” ");
INSERT INTO tbx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Lutika eno Yesu axe lek xow en vati wei xel venaxow di wou naleind en o, om moxo neil wou xel, “Nambei nya xam ghe di wou naleimim en tine? ");
INSERT INTO tbx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Qayeeng vati wo pok bei a neil wou vaxa bezombeing on, ‘Wa xe sewokeing a semaleeng veil,’ o a neimbei, ‘Qandi, de qou wa xe lelek me la?’ ");
INSERT INTO tbx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","En kandek wang boulek bei inyon Xomaxoneing Neu Moux wei wo lei ngandoung lek tembuing bei semaleeng sewokeing.” Moxo neil wou tambiy vaxa bezomb on, ");
INSERT INTO tbx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A neil wou wang, qandi, de qou wa xe lelek me la bam.” ");
INSERT INTO tbx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Moxo qandi lek me qou e xe lelek me la myayaing eivek xomaxoneing on dalus mend. Tine wo etekeing wou xel tambakateiv on om xel sanghoxe Anutu lei, me neil, “Xa se mi xei lulti nambei tine!” ");
INSERT INTO tbx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu la myayaing wei lounyeing Galili nei no. Xel qendu ngandoung ti di lam wou e, me moxo di teyoxe xel. ");
INSERT INTO tbx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ka moxo di la eno yei Alpias neu moux Livai toundei eivek xomek takis. Om Yesu neil wou e, “Betiwou ay.” Om Livai qandi lek me betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ka Yesu di ya eivek Livai beeng, xel wei mi qou takis me xel wei mi wo sewokeing on ngenong eno di ya is e me e xe xel betiyeing, en inyon xel ngenong wei mi betiwou e yo. ");
INSERT INTO tbx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Gyeik xel putoung wei petieing wei Parisi yo yei e di ya is xel sewokeing me xel wei mi qou takis eno xel teling wou e xe xel betiyeing: “Nambei nya moxo di ya is xel wei mi qou takis me xel wei sewokeing o?” ");
INSERT INTO tbx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu ngo qayeeng tine me neil wou xel, “Xel wei vanei ma veil eno se mi yei dokta, qe xel wei vanei eno mi yei dokta. A se lam bei taxe xel wei bombek o, qe xel wei sewokeing o.” ");
INSERT INTO tbx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","De Yoan xe xel betiyeing me xel Parisi eno, mi vambu yaeing. Xomaxoneing valu lam me teling wou Yesu, “Inye nambei nya ekom Yoan xe xel betiyeing me xel betiyeing wei Parisi eno di vambu yaeing, dom wa xe eno ma?” ");
INSERT INTO tbx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu lewexe, “Inye nambei nya ekom xel wei qayeeng la wou xel eno vambu yaeing gyeik e lam toundei is xel ne? Xel se teyei en nambei e nanghei toundei is xel. ");
INSERT INTO tbx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ekom bouk tyek nam gyeik ingwei xel a qou moux wei ii venei yo me na veil xel, dom lek bouk kayon eno tyek xel vambu yaeing.” ");
INSERT INTO tbx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Xelti se teyeimbei duw qaeing vako myasepu eivek qaeing lexeing wei takwei yo, wangwei e bong ambei nyon, qaeing myasepu wei vako eno sul me tetei ingwei takwei yo tip me wo myasapa. ");
INSERT INTO tbx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Me tambiy ti se teyeimbei taw wain vako eivek wain takwei ninavi. Wangwei e bong ambei nyon, wain vako tyek buklek me natax wain takwei yon ninavi, wain vako is leliy ninavi takwei yon luw xouing tyek bo nol. Ma, e taw wain vako yon eivek ninavi vako.” ");
INSERT INTO tbx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Sabat ti eno Yesu di la eivek xuk wei wit o lalei me e xe xel betiyeing di la ghavineeng is, gyeik xel pax me la eno xel pyaw wit neing valu. ");
INSERT INTO tbx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisiyeiw neil wou e, “Wei, nambei nya xel wong lul wei qayeeng petieing peti yo lek bouk wei Sabat o?” ");
INSERT INTO tbx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","E lewexe, “Beip xam seng mi pyaw vati wei Dawit wong o, gyeik e me e xe xel wei mi la is e eno maxepya xel en lul wei yaeing eno ma? ");
INSERT INTO tbx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Eivek bouk wei Abiata lumuki lukanzek eno moxo la eivek Anutu xe xomek me ya belet wei xel mi toung wou Anutu manghalus wei petieing lewexe lek o, inye xel wei lumukiyeiw eno venaxow mi ya. De moxo wong valu wou e xe xel wei mi la is e yo.” ");
INSERT INTO tbx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Woyom moxo neil wou xel, “Sabat on Anutu toung en xomaxoneing, de Anutu se toung xomaxoneing bei devind Sabat. ");
INSERT INTO tbx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Omva Xomaxoneing Neu Moux ne Tambiy Ngandoung me lei ngandoung wei Sabat o.” ");
INSERT INTO tbx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","De Yesu la eivek xomek qekueing ama no, me moux wei mema bezomb eno ti toundei inyon. ");
INSERT INTO tbx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Xel on valu di yimexe qayeeng qes wei xel embei byex qayeeng lek Yesu yo, om xel di yei e teyei teyei bei tyek e bong tambiy on bo nimzalek Sabat. ");
INSERT INTO tbx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yesu neil wou moux wei mema bezomb on bei, “Nale ghey nanghei mya nei wou xel dalus ne mend.” ");
INSERT INTO tbx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Woyom Yesu teling xel, “Beip inye petieing neil en Sabat bei: wongeing nimza o wongeing nilul, vineing xomaxoneing na toumendei mapieing o leiseing e mey?” Ekom xel dei kanzek. ");
INSERT INTO tbx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Moxo yei e vivekwou xel is lalei vanei, me lalei wo maying is en xel laleind on wo nikanzekta, om moxo neil wou moux on, “Tatei memam wo bombek.” Moxo tatei mema, dom mema wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Lutika eno xel Parisi la myayaing me yimexe sakwaing is Herot xe xel valu bei tyek xel nyeis Yesu na mey ambei nya. ");
INSERT INTO tbx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yesu is e xe xel betiyeing vup xow veil xel me la ingwei lounyeing nei, me xomaxoneing ngenong lam anghei Galili eno betiy xel. ");
INSERT INTO tbx_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Xel ngo lul dalus wei e di wong on, om xomaxoneing ngenong lam wou e nanghei Yudia, Yerusalem, Idumia me tembuing danghei wei sekla Yorodan me vivek la pu wei Taia me Saidon nei. ");
INSERT INTO tbx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","En nambei xel qendu ngandoung on lam om Yesu neil wou e xe xel betiyeing bei xel gyeiwou bot nayak ti wou e boy, en kandek xel xomaxoneing on ti se tendu ma nam paviy e. ");
INSERT INTO tbx_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","En e wong xomaxoneing ngenong wo nimzalek, om eti yeiw wei lam is vanei nilul eno tendu ma lam bei daxlek e. ");
INSERT INTO tbx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Xel laweeng nilaxes yei e, xel mi ev vaxend qatu eivek wou e me taxe bei, “Wang on Anutu Neu Moux.” ");
INSERT INTO tbx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ekom Yesu peti xel nikanzek bei xel se neil e teyeimbei e eti. ");
INSERT INTO tbx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yesu la pu wei lukendu nei me taxe la wou xel eti yeiw wei e wounalei en o, me xel lam wou e. ");
INSERT INTO tbx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","E beyal xel xoumeeng yuw me wong lei sinale wou xel, en kandek xel a mi mendei is e me e mi bong xel na myayaing nei me na neil xoulek, ");
INSERT INTO tbx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","me wong nikanzek wou xel bei xel a mi tiy xel memo. ");
INSERT INTO tbx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Inye xel xoumeeng yuw wei e beyal o, Simon, tiwei e taxe e lei nge bei Petele. ");
INSERT INTO tbx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sebedi neu moux Jems me e li Yoan (wei e taxe xel leind bei Boaneges, qes ambei nye bei dewek neuyeiw moux), ");
INSERT INTO tbx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrias, Pilip, Batolomiu, Matai, Tomas, Alpias neu moux Jems, Tadius, Simon wei Selot wei mi wo vevek en xel xe seyap o ");
INSERT INTO tbx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","me Yudas Iskariot, tiwei tyek na neil Yesu teyei me na toung e na eivek xel memend o. ");
INSERT INTO tbx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Woyom Yesu la eivek xomek ti, me xel ngenong qekuma no, omek e is e xe xel betiyeing se teyeimbei gya xend yaeing. ");
INSERT INTO tbx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Gyeik e tamali ngo qayeeng en tine eno xel la bei na qou e, en xel neil embei, “Moxo mav o.” ");
INSERT INTO tbx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Me xel putoung wei petieing o me eti yeiw wei lep me lam anghei Yerusalem eno neil, “Yesu moxo eno Belsebul gyovaxa wei memo eno dei eivek e, om mi tiy memo la myayaing nangya e xe nikanzek.” ");
INSERT INTO tbx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Om Yesu taxe xel me luk wou xel eivek qayeeng pakeing: “Nambei nya Sandang teyeimbei tiy Sandang na myayaing? ");
INSERT INTO tbx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wangwei tete lalei ti venaxow dembu xow na yuw, tete lalei tiyon se teyeimbei bale nikanzek. ");
INSERT INTO tbx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Wangwei xomek ti venaxow dembu xow na yuw, xomek tiyon se teyeimbei bale nikanzek. ");
INSERT INTO tbx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Me wangwei Sandang bo vevek me dembu venaxow na yuw, e maxow se teyeimbei bale nikanzek, en tyek ma na ma. ");
INSERT INTO tbx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ekom xelti se teyeimbei na eivek tambiy wei nikanzek eno beeng me na qou e xe lulul dalus veil e beeng. Qe ka e tup tambiy on natax bole, woyom na qou lulul eivek e xe xomek lalei. ");
INSERT INTO tbx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","A neil wou xam zonghek, sewokeing dalus me lukeingyak wei xomaxoneing eno tyek Anutu semaleeng veil xel. ");
INSERT INTO tbx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ekom wangwei eti yeiw baluk yak lek Laweeng Vambuing, tyek e xe nilul on Anutu se teyeimbei semaleeng veil, ma, nimaying wei e xe sewokeing on tyek na mi gyeip luta luta.” ");
INSERT INTO tbx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Moxo neil tine en nambei xel di neil embei, “E yon laweeng nilaxes toundei eivek.” ");
INSERT INTO tbx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Woyom Yesu ta me liyeiw moux lam tyip me nale myayaing de wong xelti la lalei me taxe e. ");
INSERT INTO tbx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","De xel qendu ngandoung ti toundei vivekwou e. Om xel neil wou e, “Tam alis limyeiw moux toungale myayaing en embei gyei wang.” ");
INSERT INTO tbx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ekom neil elox, “Inyon a tang me a lingyeiw moux on eti?” ");
INSERT INTO tbx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Woyom yei xel wei toundei vivekwou e yon me neil, “Wei! Xel ne a tang me a lingyeiw moux! ");
INSERT INTO tbx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Eti yeiw wei mi wong ambei Anutu lalei vind o, yond inye a ling moux me a ling vex me a tang.” ");
INSERT INTO tbx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu lox teyoxe xel qendu ngandoung wei qekuma is e yon no nanghei lounyeing nenyawes. Inyon xel qendu ngandoung wei nale wou e ma yon ngenong, om moxo la eivek bot lek lounyeing me la dei dom xel xomaxoneing dalus on toungale wou lounyeing nenyawes. ");
INSERT INTO tbx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Om moxo di teyoxe xel en lul ngenong eivek qayeeng pakeing, me eivek e xe teyoxeing eno inye, ");
INSERT INTO tbx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ngo! Xuk ma ti la en embei na davuw e xe lulul vei eivek xuk. ");
INSERT INTO tbx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ka moxo di vuw lulul vei lala, valu teila wou sakwaing, me menek lam ya ema. ");
INSERT INTO tbx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","De valu teila lek qakous qakous, wei tembuing nimza maeing, om lulul vei yon vindek lam daing, nambei tembuing on se la ghembi. ");
INSERT INTO tbx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ekom gyeik sayeiv leklam, lulul vei wei tyip on eno sayeiv leis om xel mey en nambei xel luselis ma. ");
INSERT INTO tbx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","De vei valu teila eivek qeis wei yingying, wei ling me leklam apu me nale zeyi lul tyipeing, om xel se vuk neing. ");
INSERT INTO tbx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","De vei valu teila lek tembuing nimza om tyip me lam apu, ling ngandoung me vuk neing ngenong nambei xoumeeng yal (30), 60 me 100.” ");
INSERT INTO tbx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Woyom Yesu neil, “Eti nenya toundei lek e bei e ngo, yond wong e ngo wou qayeeng.” ");
INSERT INTO tbx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Gyeik xel qendu ngandoung la veil, de e venaxow toundei eno xel betiyeing xoumeeng yuw me xel ba wei vivekwou e eno teling en qayeeng pakeing beimambei ne. ");
INSERT INTO tbx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Moxo neil wou xel, “Anutu xe qayeeng xupekeing wei tete lalei, eno wong wou xam. Ekom wou xel wei toundei myayaing, eno lul dalusateiv a neil eivek qayeeng pakeing. ");
INSERT INTO tbx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Om “‘xel a mi gyei le ekom tyek xel se gyeiwou, me na mi ngo, ekom xel se teyeimbei boulek, wangwei se nambei nyon nei tyek xel pekwi xow me Anutu semaleeng xel xe nilul veil.’” ");
INSERT INTO tbx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Woyom Yesu neil wou xel, “Beip xam seng woulek qayeeng pakeing tine? Woyom nambei nya tyek xam ghe boulek qayeeng pakeing dalus? ");
INSERT INTO tbx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tambiy wei mema xuk eno vuw Anutu xe xoulek. ");
INSERT INTO tbx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Xomaxoneing valu eno nambei vei wei teila lek sakwaing, wei xel vuw xoulek, gyeik kawei xel ngo yo, Sandang lam me zeim xoulek wei xel xen eivek xel eno veil. ");
INSERT INTO tbx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","De xel valu eno nambei vei wei xel vuw xoulek lek qakous qakous o, xel ngo xoulek me lutika eno xel qou is xeindlala. ");
INSERT INTO tbx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ekom xel xe luselis eno ma, xel nale teyei lek seivma nayaka. Gyeik ingwei nimaying o xomaxoneing wo nol wou xel, en ingwei xel betiwou Anutu xe xoulek, om xel nind wongeingis eno tei daing. ");
INSERT INTO tbx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Xel valu nambei vei wei xel vuw eivek yis wei niying o. Xel ngo xoulek, ");
INSERT INTO tbx_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ekom xel wo laleind maying en mapieing tine, kwa wei embei bo lulul ana eno mi tyoxe xel, me woueing nalei en lul valu lam eivek me nale zeyi xoulek, om se wo neing. ");
INSERT INTO tbx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ekom xel valu, eno nambei vei wei xel vuw lek tembuing aneing wei nimza yo, om xel ngo xoulek me laleind vind om xel vuk neing teyei lek xoumeeng yal (30), 60 me 100 inyon vati wei xel ev o.” ");
INSERT INTO tbx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Moxo neil wou xel, “Beip wang qou lam me ghe lam bei toung eivek dengmuing lalei o lelek xeinghembi? Ma, wa toung lek vaxa wei mi nale lek o? ");
INSERT INTO tbx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","En vatiyeiw wei dei xupekeing, eno tyek nam yanyateiv, de vatiyeiw wei yeip xupekeing eno tyek xel a qou me nam myayaing. ");
INSERT INTO tbx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wangwei xelti nenya toundei lek e bei e ngo, ond wong e ngo wou qayeeng.” ");
INSERT INTO tbx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Om moxo neil wou xel, “Xam a ni nenyam wou vati wei xam a bei ngo yo eno xam ghe bou naleimim en embo nimza. Vamva wei xam ghe ngo yo eno tyek Anutu bong lupeyei vamva yon noum wou xam me tyek bong lupeyei valu lek mapu wou xam is. ");
INSERT INTO tbx_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","De wangwei eti na qou lupeyei, ond tyek na qou lupeyei valu lek mapu is. Dom wangwei eti se qou lupeyei ond tyek lupeyei kawei qou yo eno tyek na zeim veil e.” ");
INSERT INTO tbx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","De Yesu neil no, “Tete lalei wei Anutu yo, teyei lek ambei moux ti vuw vei lala lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Boukeing me bendiyeing eno moxo mi yeip o qandi lek, de vei wei xen eno tyip me ling ambei nya eno se woulek. ");
INSERT INTO tbx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tembuing venaxow wong lul on tyip, yateiv belup atax dekakom wo lis lek, de woyom vuk neing lek lu. ");
INSERT INTO tbx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Dekalekom gyeik neing wo ngandoung me zuw, eno moxo zeim ngeyeing wou en nambei inye bouk wei qoueing neing o.” ");
INSERT INTO tbx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","De Yesu neil no, “Tyek xey a boulek Anutu xe tete lalei eno nambei nya? O tyek xey a neil qayeeng pakeing vati en e neilteyei? ");
INSERT INTO tbx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Inye nambei mastet vei, vei ne nayakamaing ka veil vei wei wang mi xen eivek tembuing o. ");
INSERT INTO tbx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ka gyeik eveing o, ling me wo teta me wo ngandoungateiv ghanaw lulul dalus wei eveing eivek xuk on, is mema ngandoung, inyon menek menek tyek nam bako lewis eivek e xe senyoleeng.” ");
INSERT INTO tbx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesu luk qayeeng pakeing ngenong is xoulek wou xel, teyeimbei xel a ngo wou. ");
INSERT INTO tbx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Moxo se neil luti wou xel, qe di neil qayeeng sapa yon eivek qayeeng pakeing. Ekom gyeik e venaxow mindei is e xe xel betiyeing eno moxo mi neil lul dalus yeip yaing wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lek bouk kayon gyeik soukeing di lam, eno moxo neil wou e xe xel betiyeing, “Xey ambei na nge loxalu nei.” ");
INSERT INTO tbx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Xel ghanaw xomaxoneing qendu ngandoung on dom xel qou e me la lek bot tiwei Yesu toundei lek o. Inyon bot valu la is xel. ");
INSERT INTO tbx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","De inyon laweeng valeivek ti tyip, me mamileeng di vuklek me lam leislek bot me embim a puplek. ");
INSERT INTO tbx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Yesu toundei eivek bot leyus, me di yeip lek pilo. Xel betiyeing piyexe e me neil wou e, “Putoung, inyon wa seng pyanaleim en ingwei xey a bim a mey ne?” ");
INSERT INTO tbx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Moxo qandi lek me luk nikanzek wou laweeng de neil wou mamileeng wei di vuk me lam on, “Denduing ma! Dom weip kanzek!” Woyom laweeng mey de mamileeng yeip kanzek. ");
INSERT INTO tbx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","E neil wou xel betiyeing, “Nambei nya ekom xam ghe waleeng? Beip xam seng ghei wongis?” ");
INSERT INTO tbx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Xel yaleeng ngandoung me teling wouma, “Tambiy tine eti? Omek laweeng me mamileeng ngo e vya ne!” ");
INSERT INTO tbx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xel la nge loxalu wei lounyeing Galili me la tembuing danghei wei xel Gerasa nei. ");
INSERT INTO tbx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Gyeik Yesu lam myayaing veil bot, lutika eno moux tiwei laweeng nilaxes dei eivek e eno lam veil beyeeng wei meyeing o, me lam wou e. ");
INSERT INTO tbx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Moux tine mindei eivek beyeeng wei meyeing o, xelti se teyeimbei tup e no, o se teyeimbei xel bako e nangya sen. ");
INSERT INTO tbx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","En e yon xel mi toung sen eivek e mema me vaxa, ekom moxo mi tax sen la yuw me pyaw aen mi pek lek vaxa. Xelti se ninkanzek teyei bei bong embo males. ");
INSERT INTO tbx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Boukeing me bendiyeing eivek eeng wei meyeing me lukendu nayak senghoing, eno moxo mi eng ngandoung me ghuw xow angya qakous. ");
INSERT INTO tbx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Gyeik e yei Yesu nanghei dingta, moxo veimya me la ev vaxa qatu eivek wou e manghalus. ");
INSERT INTO tbx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Moxo ghak niseikeing bei, “Yesu, Anutu Neu wei gheyapu ghanaw veil o, wambei bong vati wou ay? Neil neing lek Anutu lei, bei tyek wa seng bong myaveweeng wou ay!” ");
INSERT INTO tbx_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","En Yesu neil wou e woy bei, “Wa laweeng nilaxes on, lam myayaing veil moux tine!” ");
INSERT INTO tbx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Woyom Yesu teling e, “Wa leim va?” Moxo neil elox, “A leing qendu ngandoung wei vevek, en inye xa ngenong.” ");
INSERT INTO tbx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Om moxo tay wou Yesu lumama bei, e se bong xel na myayaing veil tembuing senghoing kayon. ");
INSERT INTO tbx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Bok qendu ngandoung ti eno di ya paviy lukendu nayak on nenyawes. ");
INSERT INTO tbx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Xel memo on tay wou Yesu bei, “Wong xa la eivek xel bok on.” ");
INSERT INTO tbx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Moxo lenghek lek xel, om laweeng nilaxes on lam myayaing me la eivek bok. Bok qendu ngandoung on teyei lek ambei 2,000 eno veimyend niseikeing me la oing mazanghei me lepla eivek lounyeing me num memiing de mey. ");
INSERT INTO tbx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Xel wei mi vet bok eno pek me la neil qayeeng tine eivek beyeeng nayak me beyeeng beimambei nei om xomaxoneing la myayaing bei na gyei vati wong tiyon. ");
INSERT INTO tbx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Gyeik xel lam wou Yesu, xel yei moux tiwei memo ngenong mindei eivek e yo, eno byex teimb me e lupeyei yon yeip yaing, om xel yaleeng. ");
INSERT INTO tbx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Eti yeiw wei xel yei eno neil wou xomaxoneing en vati wei belup wou moux wei memo mindei eivek o, me neil e lala en bok is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Woyom xomaxoneing tay wou Yesu bei e na veil xel xe tembuing danghei tiyon. ");
INSERT INTO tbx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ka Yesu embei na eivek bot, moux wei memo dei eivek e yon lam tay wou Yesu bei na is e. ");
INSERT INTO tbx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu se lewexe lek e, qe neil, “La bam wou limyeiyeiw me neil wou xel, en vati wei Tambiy Ngandoung wong wou wang o, en ingwei lalei pyaxow en wang o.” ");
INSERT INTO tbx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Om tambiy on la veil e me di neilteyei eivek tembuing danghei dalus wei Dekapolis nei en vati wei Yesu wong wou e yo. Om xomaxoneing dalus on etek en qayeeng on. ");
INSERT INTO tbx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Gyeik Yesu lox me la nge loxalu lek bot eivek lounyeing eno xomaxoneing qendu ngandoung qekuma me lam wou e gyeik e toungale paviy lounyeing o. ");
INSERT INTO tbx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Woyom gyovaxa wei xomek qekueing ama eno ti lei Yairus, lam inyon. Yei Yesu, om moxo ev vaxa qatu eivek wou e vaxa, ");
INSERT INTO tbx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","me tay wou e, “A neung vex yak eno e bim a mey, om lam liw memam lek vexo en kandek e xe vanei e ma dom mendei mapieing.” ");
INSERT INTO tbx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Om Yesu la is e. Xel qendu ngandoung ti betiwou e me vingama vivekwou e. ");
INSERT INTO tbx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Me vex ti mindei inyon, eno e xe gyand mi lam teyei lek vakovek qes xoumeeng yuw. ");
INSERT INTO tbx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Vexo mi qou vanei ngenong wou dokta ngenong me saing malew dalus wei e yo, ekom vanei yon se ma qe mi wo nol wou e. ");
INSERT INTO tbx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Gyeik vexo ngo qayeeng en Yesu, vexo lam apu paviy e demi eivek xel qendu yon me axlek e xe teimb ding, ");
INSERT INTO tbx_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","en vexo wounalei, “Wangwei a mou daxlek e xe teimb, tyek a bong nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lutika eno vexo gyand touk me vexo axe lek xow bei wo nimzalek veil myavanei wei mi qou yo. ");
INSERT INTO tbx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Lutika eno Yesu woulek bei nikanzek valu la veil e. Moxo pekwi ma vivekwou eivek xel qendu ngandoung on me teling, “Eti axlek a xe teimb?” ");
INSERT INTO tbx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E xe xel betiyeing neil elox, “Wang wei xomaxoneing qendu ngandoung on nale lip is wang on, om nambei nya wang teling, ‘Eti axlek ay?’ ” ");
INSERT INTO tbx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ekom Yesu vena di yei e vivekwou bei gyei bei eti ka wong inye. ");
INSERT INTO tbx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Woyom vex on vena woulek vati wei tyip wou e yo, om lam me ev vaxa qatu me yeip ma eivek tembuing me etek is yalenyeing, dom neil wou e zonghek en lul dalus. ");
INSERT INTO tbx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Moxo neil wou vex on, “A neung vex, wa xe wongeingis wong wang wo nimzalek. La is laleim vevopeing. Vanei wei wang qou yo eno ma dom wang wo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ka Yesu nanghei di luk, moux valu lam anghei Yairus xe xomek, inyon gyovaxa wei xomek qekueing ama yo. Xel neil, “Wa neum vex eno mey, wa seng bo nimaying ti wou Putoung no.” ");
INSERT INTO tbx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu se li nenya wou vati wei xel neil o, qe neil wou gyovaxa wei xomek qekueing ama yo, “Wa seng gwaleeng. Qe wang bongis.” ");
INSERT INTO tbx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Moxo se wong xelti betiwou e qe Petele, Jems me Yoan wei Jems li moux o. ");
INSERT INTO tbx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Gyeik xel lam xomek wei gyovaxa wei xomek qekueing ama yo, Yesu yei xomaxoneing di wo nindenduing is engeing me di wo talot. ");
INSERT INTO tbx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Moxo eivek la lalei me neil wou xel, “Nambei nya xam ghe di eng me ghe wong nindenduing ngandoung on enva? Vex yak ne mou se mey ti qe di yeip o.” ");
INSERT INTO tbx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ekom xel napexe e. Ka e tiy xel dalus la myayaing, eno qou vex yak on ma me ta me e xe betiyeing wei la is e yo me xel la eivek ingwei vex yak on di yeip anghei yo. ");
INSERT INTO tbx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","E zeim vexo mema dom neil wou vexo, “Talita kum,” qes ambei nye, “Vex yak, a neil wou wang, qandi lek!” ");
INSERT INTO tbx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","De lutika eno vex on nale ghey me vivek eivek xomek. En inye vex on xe vakovek qes xoumeeng yuw. Om xel on etek niseikeing. ");
INSERT INTO tbx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Moxo wong petieing tine bei xel se bong xelti boulek inye, me neil wou xel bei xel bong lul yaeing valu wou vexo bei e gya. ");
INSERT INTO tbx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu la veil inyon me la e maxow beeng qes Nasaret, me e xe xel betiyeing eno la is e. ");
INSERT INTO tbx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Lek bouk Sabat eno moxo la teyoxe xel eivek xomek qekueing ama me xel ngenong wei ngo e eno etek. Xel neil, “Tambiy tine qou qayeeng me kwa nimza ne nanghei inya, me mi wong lulvako ne nangya mema? ");
INSERT INTO tbx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Beip inye se kamunda? Beip inye se Maria neu moux, Jems, Yosep, Yudas me Simon lind? Beip e liyeiw vex se toundei is xey?” Om xel yei e wo nol. ");
INSERT INTO tbx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu neil wou xel, “Eivek beyeeng valuvalu eno xel mi sanghoxe poropet lei. Ekom eivek e venaxow beeng qes, me eivek e liyeiyeiw senghoing me eivek emaxow beeng, eno inyon poropet wei lei ma yo.” ");
INSERT INTO tbx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","E se teyei bei bong lulvako nanghei inyon, qe liw mema lek xomaxoneing nuyuw wei vanei yo me wong xel wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","De etek en xel on se mi wongis. Woyom Yesu la ghavineeng me teyoxe xel eivek beyeeng nge me la nge. ");
INSERT INTO tbx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dekakom moxo taxe xel betiyeing xoumeeng yuw on lam wou e, me wong xel mi la yuyuw de wong nikanzek wei tiyeing laweeng nilaxes o is wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","De moxo peti xel bei, “Xam se qou lulti en sakwaing qe xam a qou patongeeng dom xam se qou belet, vaxak de malew eivek xam xe bak. ");
INSERT INTO tbx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xam a byex vaxalambes, dom xam se byex teimb nge lek mapu. ");
INSERT INTO tbx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gyeik ingwei xam ghe na eivek xomek ti eno xam a mi mendei inyon deka xam ghe na veil beyeeng nayak tiyon le. ");
INSERT INTO tbx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","De wangwei beyeeng on ti se qou xam, o na ngo xam, ond xam pepa vegyuveeng veil vaxamim gyeik xam a being na veil o, en xel boulek bei xel wo kwa yon nol wou xow.” ");
INSERT INTO tbx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xel la myayaing me neil xoulek bei xomaxoneing pekwi xow. ");
INSERT INTO tbx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Xel di tiy memo ngenong la myayaing me di taw wel lek xomaxoneing ngenong wei vanei wong xel eno is, om xel wong xel wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","King Herot ngo, en Yesu lei wei xel woulek eivek tembuing sapa. Xel valu di neil, “Yoan Lipekeing eno qandi lek veil meyeing, omek mi wong lulvako en nikanzek wei toundei eivek e yo.” ");
INSERT INTO tbx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Xel valu neil embei, “E yon Eliya.” De valu neil embei, “E yon poropet, nambei poropet wei takwei qenang eno ti.” ");
INSERT INTO tbx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ekom gyeik Herot ngo tine, moxo neil, “Yoan, tambiy tiwei a qateiv e kwa tip me e mey, eno qandi lek veil meyeing!” ");
INSERT INTO tbx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","En myaxeeng eno Herot venaxow wong qayeeng nikanzek bei xel a zeimaxoun Yoan, me na tup e me na toung eivek xeitueing. E wong tine en nambei Herodias, wei li Pilip venei wei e ii yo. ");
INSERT INTO tbx_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","En Yoan vena neil wou Herot, “Inye se la teyei lek qayeeng petieing bei wang dii lim venei.” ");
INSERT INTO tbx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Om Herodias lalei wo vanei wou Yoan om embei nyeis e. Ekom vexo se teyei, ");
INSERT INTO tbx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","en nambei Herot yaleeng en Yoan me mi yei e teyei, en woulek bei tambiy on bombek me moux wei vambuing o. Gyeik Herot ngo Yoan, moxo etek niseikeing me wounalei ngenong. Ekom e lalei vind en embei ngo e. ");
INSERT INTO tbx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","De woyom Herodias yimexe sakwaing wei embei nyeis Yoan e mey yo. Om lek bouk wei Herot umbek lek eno moxo wong mata ngandoung wou e xe xel wei leitata me lei ngandoung wei xel vevek me xel wei mi la tax en xel moux wei Galili yo. ");
INSERT INTO tbx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Gyeik Herodias neu vex lam lalei me aw, vex on wo Herot me xel wei di ya is e eno laleind wo nimza. King neil wou vexawo yon, “Wa teling ay en vatiyeiw wei wa laleim vind o, ond tyek am bong wou wang.” ");
INSERT INTO tbx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","De neil zonghek is vex on is qayeeng neing, “Vati wei wambei teling ay eno tyek a bong wou wang. De wangwei wa teling bei a dembu a xe tete lalei na yuw me na bong wou wang on tyek a dembu de na bong veweeng wou wang.” ");
INSERT INTO tbx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Vexo la myayaing me teling wou ta, “Tyek a teling wou en vati?” Ta neil elox bei, “Yoan Lipekeing lukanzek.” ");
INSERT INTO tbx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Lutika eno vexo lox daing me la lalei wou King me neil wou e: “Am bei wang bong Yoan Lipekeing lukanzek wou ay gweimbeeng kane lek dipekta.” ");
INSERT INTO tbx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","King moxo lalei wo maying ngandoung, en nambei ingwei neil zonghek is xel wei lam di ya is e yo, om embei se pesek lek vexawo yon. ");
INSERT INTO tbx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Om wo daing me wong e xe vevek tiwei mi qateiv xel kwend eno is qayeeng nikanzek bei e na qou Yoan lukanzek. Moux moxo la qateiv Yoan kwa eivek xeitueing, ");
INSERT INTO tbx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","de qou e lukanzek lek dipekta me loum. Moxo wong ela wou vexawo yon, me vex on wong ela wou ta. ");
INSERT INTO tbx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gyeik ingwei Yoan xe xel betiyeing ngo tine eno xel lam qou e neing me liw e la eivek leiveeng meyeing ti. ");
INSERT INTO tbx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Woyom sinaleyeiw qekuma vivekwou Yesu me wo qayeeng wou e en lul dalus wei xel wong me teyoxe yo. ");
INSERT INTO tbx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Woyom nambei xomaxoneing ngenong di lox me loum, om xel nind seivma wei xel embei gya eno ma, om moxo neil wou xel, “Xam lam is ay, xam venaxow ghe gwei beyeeng wei xel ma veil o me ghe na qou laweeng.” ");
INSERT INTO tbx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Om xel venaxow la ba nei eivek bot, me la ingwei xel ma veil o. ");
INSERT INTO tbx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ekom xel ngenong yeimend wou xel di la yo om xel veimyend lek vaxend nanghei beyeeng tambak nei me la inyon natax en xel. ");
INSERT INTO tbx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Gyeik Yesu la yasewis eno yei xel qendu ngandoung on, om lalei pyaxow en xel, en xel on xok ambei sipsip wei gyovaxa ma veil o. Om moxo teyoxe xel en lulul ngenong. ");
INSERT INTO tbx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Gyeik ingwei sayeiv di teila eno e xe xel betiyeing lam wou e me neil, “Beyeeng tine xel ma veil, de inye sayeiv di teila. ");
INSERT INTO tbx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Wong xomaxoneing on la en kandek xel na ingwei xuk lalei nei me ne na beyeeng wei toundei paviyeing on me na bou xend lul yaeing valu.” ");
INSERT INTO tbx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ekom moxo lewexe, “Xam venaxow ghe bong lul valu wou xel en xel gya.” Xel neil wou e, “Malew ngandoung ma en ingwei xey a bei bou belet lek wou xel qendu ngandoung tine en yaeing. Tyek inyon teyei lek ambei dentouk qes lim yal en tambiy ti xe malew wei xouveing en xuk o!” ");
INSERT INTO tbx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Moxo teling, “Xam ghe di qou belet vamva? Xam la wei.” Gyeik xel la yeiwou eno xel neil, “Belet lim de woing yuw is.” ");
INSERT INTO tbx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Woyom Yesu wong xel la neil wou xel bei, xel mendei qendu qendu lek lesilek wei neluy yon. ");
INSERT INTO tbx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Om xel dei qendu qendu teyei lek 100 me 50. ");
INSERT INTO tbx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Moxo qou belet lim on me woing yuw on dom yeila tyoung gheyapu, de wong dange wou Anutu me dembu belet lim on. Me wong wou e xe xel betiyeing bei xel bong wou xomaxoneing me moxo vena dembu woing yuw on is ambei nyon wou xel dalus. ");
INSERT INTO tbx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","De xel on dalus ya me enden xel, ");
INSERT INTO tbx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","de xel betiyeing qekuwou belet me woing myapapu wei yo eivek pasik xoumeeng yuw. ");
INSERT INTO tbx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Xomaxoneing wei ya yaeing on, eno moux teyei lek 5,000. ");
INSERT INTO tbx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Lutika eno Yesu tendu e xe xel betiyeing on la eivek bot me wong xel la tax en e me la lounyeing loxalu wei beyeeng Betsaida nei, dekalekom wong xel bembeeng on la. ");
INSERT INTO tbx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ka e wong xel xomaxoneing on la woy, moxo lek me la lukendu nenyawes on bei na zeimema. ");
INSERT INTO tbx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Gyeik ingwei di bouk eivek eno bot la tyip lounyeing masenghoing, dom e venaxow tateis toundei lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Moxo yeila xel betiyeing di wo pok lek sepaeing bot, en nambei laweeng ngandoung vei xel. Embim boyaing eno Yesu di la mapu lek lounyeing wou xel mend bei xel teyei bei gyei e, ");
INSERT INTO tbx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ekom gyeik xel yei e di la lek lounyeing eno xel embeik nge inyon meyeing ti nu. Om xel nyayek niseikeing, ");
INSERT INTO tbx_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","en nambei xel dalus yei e om xel nind yaleeng niseikeing. Lutika eno luk wou xel me neil, “Xam nale nimkanzek! Xam seng gwaleeng en inye ay yo.” ");
INSERT INTO tbx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Om moxo lek la eivek bot is xel, de laweeng ma. Om moxoyeiw etek, ");
INSERT INTO tbx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","en xel se woulek qes wei Yesu wong gyeik dembu belet o. Ma. En inye xel laleind on wo nikanzekta. ");
INSERT INTO tbx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Gyeik xel la nge loxalu, xel la yasewis lek tembuing Genesaret me tup bot nale inyon. ");
INSERT INTO tbx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ka xel lam myayaing veil bot, eno se denlek en xomaxoneing woulek Yesu. ");
INSERT INTO tbx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Xel veimyend me la eivek beyeeng tambak on me qalei xel wei vanei yo lek ghus me qou xel me la ingwei xel ngo bei toundei nanghei yo. ");
INSERT INTO tbx_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Me beyeeng dalus wei moxo la eivek o, beyeeng me beyeeng nayak me beyeeng danghei danghei nei, xel mi toung xel wei vanei eno eivek beyeeng wei vateivek o. Xel mi tay wou bei e bong xel vanei daxlek e xe teimb ding myasepu. Om eti yeiw dalus wei mi axlek e yo eno mi wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Xel Parisi me xel putoung wei petieing eno valu wei lam anghei Yerusalem eno qekuma is Yesu, ");
INSERT INTO tbx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","me yei e xe betiyeing on valu se betiwou kwa wei Yudayeiw wei xel mi sekweyexe memend o qe xel di ya yaeing is memend laxes. ");
INSERT INTO tbx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisi me xel dalus wei Yudayeiw eno se mi ya qe ka xel mi sekweyexe memend wole, nambei xel xe kwa wei buyeiw takwei yo. ");
INSERT INTO tbx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Gyeik xel nam anghei ingwei beyeeng vateivek ond xel se mi ya qe ka xel lipek wole. Me xel mi betiwou lul ngenong valu wei buyeiw takwei yo, nambei ingwei sekweyexeing mayamya, deng, me dengmuing.) ");
INSERT INTO tbx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Om Parisiyeiw me xel putoung wei petieing o teling Yesu, “Nambei nya wa xe xel betiyeing se mi wong e teyei lek kwa takwei wei xel bundyeiw o qe xel mi ya xend yaeing is memend laxes?” ");
INSERT INTO tbx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","E neil elox, “Yesaya neil zonghek gyeik e neil qayeeng poropet en xam wei myamim yuw o. En nambei xel byex eivek qapiya eno nambei nye, “‘Xomaxoneing ti beimambei yon mi sanghoxe ay angya myend bandaing, ekom xel laleind on mindei dingta veil ay. ");
INSERT INTO tbx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xel mi wong lalo wou ay bandaing. Ekom xel mi teyoxe xomaxoneing bei xel a mi betiwou petieing ne nambei Anutu xe.’ ");
INSERT INTO tbx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Xam ghe saing Anutu xe petieing dom ghe di zeimaxoun xomaxoneing xe kwa wei takwei yo.” ");
INSERT INTO tbx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Me e neil wou xel, “Xam ghe woulek ewo nimza en kwa wei toungeing Anutu xe petieing la dei nenyawes bei kandek betiwou bumyeiw xe kwa wei takwei yo! ");
INSERT INTO tbx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","En Mose neil, ‘Wa mi gwevek mam aluw tam xe qayeeng,’ de ‘Eti yeiw wei neil vyalek ma luw ta eno xel nyeis e mey.’ ");
INSERT INTO tbx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ekom xam ghe neimbei wangwei moux ti e neil wou mamata, ‘Vineing vati wei a bei bong wou muw eno inye kolban qes ambei nye lulul da wei a beyal bei na bong wou Anutu yo,’ ");
INSERT INTO tbx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","woyom wa seng wong e lox me la wo vineing ti wou ma o ta. ");
INSERT INTO tbx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nambei xam ghe wong nikanzek wei Anutu xe xoulek eno ma dom ghe mi betiwou xam xe kwa takwei wei xam ghe mi qou wou bumyeiw o. Me ghe wong lulul ngenong ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu taxe xel xomaxoneing ngenong la wou e no me neil, “Xam dalus a ngo wou ay, me na mi bou kwamim en tine bo nimza. ");
INSERT INTO tbx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Lul tiwei mindei myayaing me la eivek xomaxoneing eno se teyeimbei bong embo nilaxes. Qe vati wei lam myayaing veil xomaxoneing laleind eno tiyon mi wong e wo nilaxes.” ");
INSERT INTO tbx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Gyeik e ghanaw xel qendu tiyon me la eivek xomek, e xe xel betiyeing teling e en qayeeng pakeing tine. ");
INSERT INTO tbx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Moxo neil bei, “En xam is ambei nyon xam seng woulek qayeeng ne qes? Beip xam seng woulek bei lulti mi la eivek xomaxoneing nanghei myayaing eno se teyeimbei bong embo nilaxes? ");
INSERT INTO tbx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Lulul ne eno se teyei bei na eivek e lalei qe tyek na eivek e xeita, de e laluwexe ela myayaing eivek leiveeng.” (Eivek neileing tine, Yesu neilteyei bei lul yaeing dalus on vako.) ");
INSERT INTO tbx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Moxo neil no bei, “Vati wei lam myayaing veil xomaxoneing eno inye wong e wo nilaxes. ");
INSERT INTO tbx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","En lam eivek xomaxoneing laleind eno inyon woueing nalei nilul, kwa nilul wei kwapesiv o, panaxeing, leiseing xel a mey. ");
INSERT INTO tbx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Wongeing kwapesiv is vex wei dei leya yo, kwa eivekeing, yei tambiy nge wo nol, tyonyeing, kwa wei betiyeing wou lalei vineing wei neing o, yeimalek, lukyak lek tambiy nge, byexeing vaxa, me kwa wei bandol o. ");
INSERT INTO tbx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kwa nilul beimambei ne dalus eno lam eivek xomaxoneing laleind me wong xomaxoneing wo nilaxes.” ");
INSERT INTO tbx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu la veil beyeeng tiyon me la danghei tiwei Taia nei. E la eivek xomek on ti de embei xelti se boulek e. Ekom se teyeimbei bun xow. ");
INSERT INTO tbx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Qe lutika eno vex tiwei laweeng nilaxes dei eivek neu vex eno ngo qayeeng en e, lam ev vaxa qatu me yeip ma eivek wou e vaxa. ");
INSERT INTO tbx_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Vex tiyon inyon nanghei Grik, me umbek eivek Siria Ponisia. Vexo tay wou Yesu bei e tiy memo yon na myayaing veil e neu vex. ");
INSERT INTO tbx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Moxo neil wou vex on, “Xey a bong yakyak gya vati wei xel laleind vind o dalus me na pup atax bole, en inye se nimza bei qoueing yakyak xe belet me banex ena wou naw.” ");
INSERT INTO tbx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Vexo neil elox, “Ee, Tambiy Ngandoung, ekom xel naw mi ya yaeing myapapu wei yakyak mi wong e mi teila eivek lelek xeinghembi yo.” ");
INSERT INTO tbx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Woyom moxo neil wou vex on, “Wang neil e loum ambei nyon om wang na, en memo la veil neum vexo.” ");
INSERT INTO tbx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Vexo lox beeng me yeimbei neu vexo di yeip lek zek dom memo yon la veil e. ");
INSERT INTO tbx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Woyom Yesu la veil beyeeng danghei wei Taia me la lox danghei wei Saidon, me la lox danghei wei Dekapolis me la tyip ninei wei lounyeing Galili ne. ");
INSERT INTO tbx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nanghei inyon eno xomaxoneing valu qou moux wei nenya wo qatu me mya wo nimaying om se teyeimbei baluk embo nimza yo me lam wou Yesu me xel tay wou e, bei e ni mema lek moux on. ");
INSERT INTO tbx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ka Yesu qou moux on me la nenyawes, dingta ka veil xel qendu ngandoung on, de moxo toung mema deyis la eivek moux on nenya luw. Woyom pesuv myalouk me toung mema deyis lek moux on ghas. ");
INSERT INTO tbx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Moxo yeila tyoung gheyapu dom poux laweeng nikanzek me neil wou e, “Epata.” Qes ambei nye, “Wa tax!” ");
INSERT INTO tbx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","De lutika eno moux moxo nenya deng, me ghas tul de moxo luk eyeip yaing. ");
INSERT INTO tbx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu peti xel lumama bei eti se neil wou xelti en lul tiwei xel yei yo, ekom xel wo nikanzek en neileing qayeeng tine teyei. ");
INSERT INTO tbx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Xomaxoneing on etek niseikeing. De xel neil, “Moxo wong lul sapa wo nimza. Moxo wong nenya qatu ngo wou me myatueing eno luk.” ");
INSERT INTO tbx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lek bouk tine eno xomaxoneing qendu ngandoung nge qekuma no. Gyeik xel xend lul yaeing ma, eno Yesu taxe e xe xel betiyeing lam wou e me neil, ");
INSERT INTO tbx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“A laleing pyaxow en xomaxoneing beimambei ne, xel dei is ay woy teyei lek bouk yal ekom lul wei yaeing eno ma. ");
INSERT INTO tbx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Wangwei a bong xel na bend is maxep, tyek xel mend bivek me pewilexe wou sakwaing, en nambei xel on valu lam anghei dingta.” ");
INSERT INTO tbx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","E xe xel betiyeing lewexe, “Ekom eivek beyeeng wei xel ma veil ne, tyek xey a qou belet e teyeimbei xey a bet xel?” ");
INSERT INTO tbx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu teling, “Xam ghe di qou belet vamva?” Xel neil, “Lim yuw o.” ");
INSERT INTO tbx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Moxo neil wou xel qendu ngandoung on bei xel mendei lek tembuing. Woyom qou belet lim yuw on me wong dange wou Anutu, dom dembu me wong wou e xe xel betiyeing bei xel na bong enana wou xomaxoneing on, me xel pum wou xel qendu ngandoung on. ");
INSERT INTO tbx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","De xel di qou woing nayak matika is ambei nyon om moxo wong dange en woing is, me neil wou xel betiyeing bei xel dembu wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Xomaxoneing on ya me e den xel woy. Dekakom xel betiyeing qekuwou myapapu wei nanghei toundei eno eivek pasik lim yuw. ");
INSERT INTO tbx_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Xel teyei lek ambei 4,000 moux eno lam toundei. Me Yesu wong xel la, ");
INSERT INTO tbx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","de moxo lek la eivek bot is e xe xel betiyeing me la danghei wei Dalmanuta nei. ");
INSERT INTO tbx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","De Parisiyeiw lam me wo vevek wou qayeeng is Yesu. En xel embei daxe e, om xel neil wou e bei embong lulvako yo ti me talex dee wei tyoung gheyapu yo ti me talex bei Anutu wong e lam. ");
INSERT INTO tbx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Moxo axe nimaying me poux laweeng me neil, “Nambei nya xomaxoneing wei gweimbeeng ne mi teling ay en dee wei lulvako yo? A neil wou xam zonghek, tyek xel se gyei dee wei lulvako yo ti.” ");
INSERT INTO tbx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Woyom moxo ghanaw xel, de lox me la eivek bot me la nge loxalu nei lek lounyeing. ");
INSERT INTO tbx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Dom xel betiyeing naleind ma en qoueing belet, ekom inye tixemou wei xel qou is xow eivek bot o. ");
INSERT INTO tbx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu peti xel, “Xam ghe gwei xow teyei. Xam ghe gweiteyei xow en yis wei Parisiyeiw me ingwei Herot o is.” ");
INSERT INTO tbx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Woyom xel betiyeing di luklek tine wouma me neil, “Beind moxo neil qayeeng tine en inye nambei belet ma veil xey.” ");
INSERT INTO tbx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesu woulek qayeeng wei xel di neil wouma yon om teling xel, “Nambei nya xam ghe di luk wouma bei belet ma? Beip xam seng ghei wei o ghe woulek? Beip xam laleimim on nanghei di wo nikanzek? ");
INSERT INTO tbx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Beip xam mamim toundei lek xam, ekom xam seng wei, me xam nenyamim nale lek xam, ekom xam seng ngo me xam seng wou naleimim? ");
INSERT INTO tbx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Gyeik a dembu belet lim on wou xel 5,000, xam ghe qekuwou belet myapapu pup eivek pasik vamva?” Xel neil, “Xoumeeng yuw.” ");
INSERT INTO tbx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Me gyeik a dembu belet lim yuw on wou 4,000, xam ghe qekuwou myapapu pup eivek pasik vamva?” Xel lewexe, “Lim yuw.” ");
INSERT INTO tbx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","E neil wou xel, “Inyei xam seng ghei woulek?” ");
INSERT INTO tbx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Xel lam tei Betsaida, me xomaxoneing valu qou moux matekeing ti me lam tay wou Yesu bei e ni mema lek e. ");
INSERT INTO tbx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Moxo zeim moux matekeing on mema me qou e me la myayaing veil beyeeng. Gyeik ingwei pesuv myalouk lek moux on manghalus, de toung mema lek e, de Yesu teling, “Wang wei lulti?” ");
INSERT INTO tbx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Moxo yeila me neil, “A xei xomaxoneing on eno di ghavineeng me lox me loum ekom xel xok ambei xax.” ");
INSERT INTO tbx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yesu lox toung mema lek moux on manghalus no. Woyom moxo ma yeila me wo nimza me e yei lul dalus on yanyateiv. ");
INSERT INTO tbx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu wong moxo la beeng, dom neil, “Wa seng na eivek beyeeng.” ");
INSERT INTO tbx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu me e xe xel betiyeing la ghavineeng eivek beyeeng nayak nayak wei toundei paviy Sisalia Pilipai. Xel di la wou sakwaing eno moxo teling xel, “Xomaxoneing mi neil embei ay eti?” ");
INSERT INTO tbx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Xel neil elox, “Xel valu mi neil embei wa Yoan Lipekeing, de valu neil embei wa Eliya, de xel valu mi neil embei wang on poropet wei takwei eno ti.” ");
INSERT INTO tbx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Moxo teling, “Dom nambei nya wou xam? Xam ghe mi neil embei ay eti?” Petele lewexe, “Wang on Kilisi yo.” ");
INSERT INTO tbx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yesu peti xel bei xel se neil e teyei wou xelti. ");
INSERT INTO tbx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Woyom moxo teyoxe wou xel bei Xomaxoneing Neu Moux eno na qou myavanei ngenong me xel teivateiv wei Yuda yo me xel lumuki leitata, me xel putoung wei petieing o tyek pesek e de xomaxoneing tyek nyeis e mey deka bouk yal na veil eno moxo tyek qandi lek no. ");
INSERT INTO tbx_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Moxo neil eyeip yaing wou xel en tine, om Petele qou e me la nenyawes me neil e. ");
INSERT INTO tbx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","De Yesu pekwi me yei e xe xel betiyeing, moxo neil Petele. Yesu neil, “Sandang, la a deming! Wa seng wou naleim en lul wei Anutu yo, qe lul wei xomaxoneing o.” ");
INSERT INTO tbx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Woyom moxo taxe xel qendu yon lam wou e is e xe xel betiyeing me neil: “Wangwei xelti embei betiwou ay, ond e daxow vun me qalei e xe xax pepeeng me betiwou ay. ");
INSERT INTO tbx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","En eti yeiw embei zeimaxoun e xe mapieing, on tyek na saing, dom eti yeiw embei saing xel xe mapieing en ay me Xoulek Nimza wei ay eno tyek mendei bo nimza. ");
INSERT INTO tbx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wangwei tambiy ti e qou lul dalus wei tembuing sapa ne yo, ekom na saing e xe mapieing nei, on tyek lulul wei e qou yon devind e nambei nya? ");
INSERT INTO tbx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","O moux on tyek bong vati na zeyi e xe nu pieing? ");
INSERT INTO tbx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Om wangwei xelti nigyaleeng en ay me a xe xoulek eivek bouk wei xel xomaxoneing wei gweimbeeng ne eno toung demind wou Anutu me wo sewokeing nilul wou xel ne mendghalus, yon tyek Xomaxoneing Neu Moux nigyaleeng en e gyeik ingwei embei noum eivek ma xe xeiyaing ngandoung is xel angela vambuing o.” ");
INSERT INTO tbx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Me moxo neil wou xel, “A neil wou xam zonghek, xel valu wei toungale inye eno tyek se balwou meyeing qe ka xel gyei tete lalei wei Anutu xe yo nam is nikanzek bole.” ");
INSERT INTO tbx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ka bouk limti la veil le woyom Yesu qou Petele, Jems me Yoan is xow de qou lal me lek lukendu vaxading ti, wei xel venaxow la toundei yo. De nanghei inyei eno moxo neing pekwi wou lal mend. ");
INSERT INTO tbx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","E xe teimb on teltyip me wou teleing ghanaw eti yeiw lek tembuing sapa wei embei sekweyexe xel xe teimb bo pus o. ");
INSERT INTO tbx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Woyom Eliya me Mose lam nale nanghei inyon wou lal mend me di luk is Yesu. ");
INSERT INTO tbx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petele neil wou Yesu, “Putoung, inye nimza bei xey a toumendei inye. Om xa bei sakev xomek sel yayal, ti wou wang, ti wou Mose de ti wou Eliya.” ");
INSERT INTO tbx_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Moxo neil ambei nyon en se woulek bei na neil vati, en nambei lal yaleeng mouyo.) ");
INSERT INTO tbx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Woyom laxap ti lam me li tenu zeyi xel, de vya ti lam eivek laxap me neil: “Tine inye a Neung Moux, e tiwei a laleing vind o. Xam a mi ngo e vya!” ");
INSERT INTO tbx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Se wo lululek, en gyeik ingwei lal yei e vivekwou eno lal se lox yei xelti no is xel, qe Yesu venaxow. ");
INSERT INTO tbx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ka xel di loum axone veil lukendu, Yesu wong qayeeng nikanzek wou lal bei kandek lal se neil wou xelti en vati wei lal yei yo, qe ka Xomaxoneing Neu Moux qandi lek veil meyeing bole. ");
INSERT INTO tbx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Lal zeimaxoun qayeeng on wou lal venaxow me di luklek, “Qandieing veil meyeing ne inye qes ambei nya?” ");
INSERT INTO tbx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Woyom xel teling e, “Nambei nya putoung wei petieing o neil embei Eliya e nam atax?” ");
INSERT INTO tbx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu neil elox, “Neing o, Eliya lam atax, me menyex wou lul dalus lox eivek no. Ekom qayeeng nge eno xel byex eivek xoulek bei Xomaxoneing Neu Moux na qou myavanei ngandoung me xel pesek e? ");
INSERT INTO tbx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ekom a neil wou xam, Eliya vena lam o, me xel wong vati wei xel wou naleind en o dalus wou e. Nambei ingwei xel byex eivek xoulek en e yo.” ");
INSERT INTO tbx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gyeik xel loum wou xel betiyeing valu, xel yei xel qendu ngandoung ti vivekwou xel me xel putoung wei petieing o di pyalek ama is xel. ");
INSERT INTO tbx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Se denlek en xomaxoneing dalus yei Yesu, xel etek me veimyend me la neil bendiyeing wou e. ");
INSERT INTO tbx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Moxo teling, “Xam ghe di pyalek ama is xel en vati?” ");
INSERT INTO tbx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Moux ti eivek qendu yon lewexe, “Putoung, a qou neung moux me na lam wou wang, en laweeng wei myatueing o ti nale eivek e om se mi luk. ");
INSERT INTO tbx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Gyeik ingwei embei zeimaxoun e nikanzek, eno mi nex e lek tembuing. Moxo myapeleis mi taw lam lox e mya, de newou mi wo nyiknyik me mema vaxa mi wo nikanzek. A teling wou wa xe xel betiyeing bei xel a tiy laweeng nilul on na veil e ekom xel se teyei.” ");
INSERT INTO tbx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Yesu neil elox, “O xam wei gweimbeeng ne xam xe wongeingis eno ma. Tyek a mi mendei is xam bouk vamva? Tyek a qalei nimaying wei xam o bouk vamva? Qou yak on me lam inye wou ay.” ");
INSERT INTO tbx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Om xel qou moxo me lam wou e. Gyeik laweeng on yei Yesu, eno se wo lululek en bimexe yak on la wo peleipelei lek tembuing me myapeleis di taw lam lox e mya. ");
INSERT INTO tbx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yesu teling wou yak on ma, “Moxo mi wong ambei nye teyei lek bouk vamva?” E lewexe, “Gyeik ingwei e nanghei yak o. ");
INSERT INTO tbx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Inye mi nex ela eivek nenyex o memiing lumama bei nyeis e mey. Ekom wangwei wa teyei being bo lulti wou, yon wa pyanaleim en xa me devind xa.” ");
INSERT INTO tbx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu neil, “Nambei nya wang neimbei ‘Wangwei wa teyei nei?’ Ond lul dalus ena teyei lek wou eti yeiw wei mi wongis o.” ");
INSERT INTO tbx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Se wo lululek en ghavis on ma taxe lox, “A wongis o ekom a laleing wo yuw om wa devind ay!” ");
INSERT INTO tbx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Gyeik Yesu yei xel qendu tiyon di veimyend me lam wou xel ne, moxo luk niseikeing wou laweeng nilaxes on. De moxo neil, “Wa laweeng wei nenya qatu me myatueing, a peti wang bei wang nam myayaing veil e dom wa seng nox me na eivek e no.” ");
INSERT INTO tbx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Laweeng on nyayek me bimexe e niseikeing dom la myayaing veil e. Yak on xok ambei xel meyeing, om xel ngenong on neil embei, “Moxo mey o.” ");
INSERT INTO tbx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ekom Yesu zeim e mema me e nale lek vaxa, me nale ghey. ");
INSERT INTO tbx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ka Yesu lox xomek lalei, e xe xel betiyeing teling wou e xupekeing, “Nambei nya xa se teyeimbei tiy e na myayaing?” ");
INSERT INTO tbx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","E neil elox, “Lul ambei nye eno teyeimbei nam myayaing en zeimeing mema tixemou ne.” ");
INSERT INTO tbx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Xel ghanaw beyeeng tiyon me la lox Galili. Yesu embei xelti se boulek ingwei xel toundei ghei yo, ");
INSERT INTO tbx_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","en nambei e di teyoxe e xe xel betiyeing. Moxo neil wou xel, “Tyek xel a toung Xomaxoneing Neu Moux na eivek xomaxoneing memend. Tyek xel nyeis e mey, deka bouk yal ena veil, woyom moxo tyek qandi lek.” ");
INSERT INTO tbx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ekom xel se woulek vati wei e neil o qes de xel yaleeng om xel se teling e en inyon. ");
INSERT INTO tbx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xel lam tyip Kapenaom. Gyeik e la eivek xomek woy, moxo teling xel, “Xam ghe di lam wou sakwaing eno xam ghe pyalek ama en vati?” ");
INSERT INTO tbx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ekom xel toundei kanzek en nambei xel di lam wou sakwaing eno xel pyalek ama bei eti eivek xel eno wo lei ngandoung. ");
INSERT INTO tbx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesu dei tembuing me taxe xel betiyeing xoumeeng yuw on lam me neil, “Wangwei xelti embei na mya, ond e nam ti yusayang, me bong ambei xukxe wei xel dalus o.” ");
INSERT INTO tbx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Moxo qou yak tika me wong e nale eivek xel senghoing. Dom qava e eivek mema me neil wou xel, ");
INSERT INTO tbx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Eti lalei vind yak ambei nye wei wongis me qou e eno qou a manghalus en a leing yond lalei vind me qou ay, me eti lalei vind ay me qou ay eno lalei se vind a maxow me qou ay, qe qou tambiy tiwei wong a lam o.” ");
INSERT INTO tbx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yoan neil, “Putoung, xa xei moux ti di tiy xel memo nangya wa leim om xa neil wou bei e tip, en nambei tambiy ne se mi betiy xey.” ");
INSERT INTO tbx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yesu neil, “Xam se neimbei e tip, en eti yeiw wei di wong lulvako eivek a leing eno tyek se neil nilul ti lek ay. ");
INSERT INTO tbx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","En eti yeiw wei se pesek xey, eno inyon xe xe. ");
INSERT INTO tbx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","A neil wou xam zonghek, eti bong mayamya memiing ti wou xam en a leing, en inye nambei xam on Kilisi xe, yond tyek se teyei bei saing e xe xouveing. ");
INSERT INTO tbx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Me wangwei tambiy ti embei bong yakyak on ti wei wongis ay eno detei en sewokeing, on Anutu tyek bong myaveweeng ngandoung ghanaw veil, nambei ingwei xel tup qakous ngandoung e vivekwou e kwa me banex ena eivek mamileeng o. ");
INSERT INTO tbx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Wangwei wa memam bo wa detei en sewokeing, on wa qateiv veil. Inye nimza bei wang na eivek mapieing is memam tixemou de is mema yuw eno tyek wang na eivek nenyex wei se mi mey yo. ");
INSERT INTO tbx_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nanghei inyon eno xel xe meii se mi mey me nenyex se mi mey. ");
INSERT INTO tbx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Me wangwei wa vaxam bo wa detei en sewokeing nei, on wa qateiv veil. Inye nimza bei wang na eivek mapieing is vaxam tixemou, de wa vaxam yuw eno tyek xel banex wang na eivek beyeeng wei nenyex luta yo. ");
INSERT INTO tbx_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nanghei inyon eno xel xe meii se mi mey me nenyex se mi mey. ");
INSERT INTO tbx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Me wangwei wa mamghalus bo wa detei en sewokeing nei, yond qepei elam myayaing. Inye nimza bei wang na eivek tete lalei wei Anutu is mam tixemou dom se yuw, on tyek banex wang na eivek beyeeng wei nenyex luta yo, ");
INSERT INTO tbx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","nanghei inyon eno “‘xel meii mi byex xomaxoneing neing eno se mi tip, me nenyex se mi mey o.’ ");
INSERT INTO tbx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nenyex tyek detei lek xomaxoneing sapa me bong xel bo vako nambei xel mi selew lulul en mileeng o. ");
INSERT INTO tbx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Mileeng on nimza, ekom wangwei e xe nenyeing on nama eno tyek wang teyei bei bong enox bo nenyeing ambei nya no? Xam ghe teyei lek mileeng om tyek xam mendei lalei vevopeing is ama.” ");
INSERT INTO tbx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Woyom Yesu ghanaw beyeeng tiyon me la eivek tembuing danghei tiwei Yudia nei me la Yorodan veweeng aning. Xomaxoneing qendu ngandoung mi lam wou Yesu no om di teyoxe xel nambei e xe kwa wei e mi teyoxe xel o. ");
INSERT INTO tbx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Parisi valu lam me wo axeing wou e om xel teling, “Beip inyei petieing lenghek bei moux qateiv iingama wei luw venei yo veil o ma?” ");
INSERT INTO tbx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","E neil elox, “Mose wong qayeeng petieing vati wou xam?” ");
INSERT INTO tbx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Xel neil, “Mose lenghek lek bei moux a byex qapiya wei qateiveing iingama veil dom bong vex on na.” ");
INSERT INTO tbx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yesu neil elox, “Inyon Mose byex petieing tine wou xam en inye nambei xam laleimim on wo nikanzek. ");
INSERT INTO tbx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ekom eivek myaxeeng selis wei toung tembuing is tyoung eno ‘Anutu toung xomaxoneing valu moux de valu vex.’ ");
INSERT INTO tbx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘En qes tine moux tyek na veil ma luw ta de luw venei na toung lekti, ");
INSERT INTO tbx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","me tyek luw xouing bo neing tixemou.’ Om luw se wo yuw no qe neing tixemou. ");
INSERT INTO tbx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Nambei nyon vati wei Anutu tendulekti, eno moux ti se qateiv.” ");
INSERT INTO tbx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gyeik xel toundei eivek xomek no, eno xel betiyeing teling Yesu en tine. ");
INSERT INTO tbx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","E lewexe, “Tambiy ti qateiv iingama wei luw venei yo veil, dom dii vex nge no, ond wong kwapesiv wei inye la sewok wou venei. ");
INSERT INTO tbx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","De wangwei vex on qateiv iingama wei luw leya yo veil, dom mendei wou moux nge ond vex on wo kwapesiv.” ");
INSERT INTO tbx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Xel xomaxoneing on di qou yakyak me lam wou Yesu bei e niw mema lek xel, ekom xel betiyeing neil xel. ");
INSERT INTO tbx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Gyeik Yesu yei tine, moxo lalei wo vanei om neil wou xel, “Wong yakyak on lam wou ay. Xam se zeimaxoun xel, en tete lalei wei Anutu xe yo inye xel yakyak ambei nye xe. ");
INSERT INTO tbx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","A neil wou xam zonghek, tambiy ti se teyei bei na eivek tete lalei wei Anutu xe yo wangwei e se ghok xel yakyak wei leind maeing ne.” ");
INSERT INTO tbx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Om moxo qava yakyak on eivek mema me liw mema lek xel dom wo mata wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ka Yesu di la wou sakwaing, moux ti veimya me la wou e me ev vaxa qatu eivek wou e. Moxo teling, “Putoung nimza, a bong vati en na qou mapieing luta luta wei Mang Anutu neil zonghek bei bong wou neuyeiw loxyus o?” ");
INSERT INTO tbx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu neil elox, “Nambei nya wang taxe ay nimza? Xelti se nimza qe Anutu venaxow. ");
INSERT INTO tbx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Wang woulek qayeeng petieing ne woy: ‘Wa seng nyeis xelti na mey, wa seng bo kwapesiv, wa se panax, wa seng bo qayeeng tyonyeing me ghe bo qayeeng en xel nge, wa seng bong tyonyeing me tetei xel nge xe lulul, wa mi sanghoxe mam aluw tam.’ ” ");
INSERT INTO tbx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","E neil e lox wou e, “Putoung, qayeeng ti beimambei ne dalus eno a mi betiwou gyeik ingwei a yak o.” ");
INSERT INTO tbx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu yei e me lalei vind e. Moxo neil, “Wang ma en lul tika. La me wo vateivek lek lul dalus wei wang o de wong malew wou xel kanyo, on tyek wa qou lulul nimzamza eivek tyoung gheyapu. Dom lam betiwou ay.” ");
INSERT INTO tbx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Moxo ngo qayeeng tine om yei manol. De la is lalei maying en nambei e xe lulul ngenongakes. ");
INSERT INTO tbx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesu pekwi ma wou e xe xel betiyeing me neil wou xel, “Inye wo pok en xomaxoneing wei lulul ana embei na eivek tete lalei wei Anutu yo!” ");
INSERT INTO tbx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Xel betiyeing etek en e xe qayeeng. Ekom Yesu neil no, “Xam neungyeiw, inye wo pok en ingwei laeing eivek tete lalei wei Anutu yo! ");
INSERT INTO tbx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Inye wo pok en ingwei kamel embei na nox ying manghalus wei duweing lul en o, nambei nyon eno moux wei lulul ana eno inye wo pok ngandoung en ingwei embei na eivek tete lalei wei Anutu xe yo.” ");
INSERT INTO tbx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Xel betiyeing etek ngandoung, me neil wouma, “Wangwei nambei nyon nei, on tyek eti na eivek Anutu xe tete lalei?” ");
INSERT INTO tbx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu yei xel bombek me neil, “Is xomaxoneing eno xel se teyei, ekom se nambei nyon is Anutu. Anutu teyeimbei bong lulul dalus.” ");
INSERT INTO tbx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Petele neil wou e, “Wei, xa ghanaw xa xe lulul sapa dom na betiwou wang o!” ");
INSERT INTO tbx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesu neil elox, “A neil zonghek wou xam, xel eti yeiw wei ghanaw bend o liyeiw moux o liyeiw vex o tayeiw o neuyeiw o xuk yaeing en ay me Xoulek Nimza ne, ");
INSERT INTO tbx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","de tyek xel a qou 100 lek mapu eivek bouk tine, me tyek xel a qou xomek ngenong, liyeiw moux, liyeiw vex, tayeiw, neuyeiw, me xuk yaeing ngenong, me tyek xel bo nol wou xel is de tyek loxyus eno xel a qou mapieing luta luta. ");
INSERT INTO tbx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ekom xel ngenong wei tax eno tyek nox yus dom xel wei loxyus eno natax.” ");
INSERT INTO tbx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Xel di la wou sakwaing me la pu Yerusalem nei, me Yesu la mamunghexeing, de xel betiyeing eno di wou naleind ngenong me xel wei mi betiwou eno yaleeng. De qou xel betiyeing xoumeeng yuw no me la nenyawes me neil wou xel en vati wei tyek nam belup wou e yo. ");
INSERT INTO tbx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Moxo neil, “Wei, xey a bei na pu wei Yerusalem nei me tyek xel a neil Xomaxoneing Neu Moux teyei me na toung eivek xel lumuki leitata me putoung wei petieing o memend. Tyek xel bo qayeeng en e me natup qayeeng en embei nyeis e mey de bong e na wou xel amba, ");
INSERT INTO tbx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","wei tyek xel baluk yak lek e me pesuv myenlouk lek e, me sesa embo nol me nyeis e mey. Ka bouk yal nak veil moxo tyek qandi lek.” ");
INSERT INTO tbx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Woyom Sebedi neu moux a luw lam wou e. Luw neil, “Putoung, uw ambei wang bong vati wei uw ambei teling wang en eno wou uw.” ");
INSERT INTO tbx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Moxo teling, “Inye muw ambei am bong vati wou muw?” ");
INSERT INTO tbx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Luw neil elox, “Gyeik wa mendei lek wa xe siaking is wa leim ngandoung, yon wong uw nge dei wou wa memam payeiv de nge mendei wou wa memam qeinz.” ");
INSERT INTO tbx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Yesu neil, “Muw seng woulek vati wei muw ghe di teling en o. Muw ghe teyeimbei tyek na num eivek mayamya wei a num eivek o de muw ghe teyei bei zipek is lipekeing wei a lipek en ne?” ");
INSERT INTO tbx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Luw lewexe, “Uw teyei.” Yesu neil wou luw, “Tyek muw teyei bei num eivek mayamya wei a num eivek ne, me ghe zipek is lipekeing wei a lipek is o, ");
INSERT INTO tbx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ekom ingwei deing wou a memang payeiv o qeinz inyon se wou ay bei a zenghek lek. Beyeeng beimambei ne inye wou xel wei Anutu menyex woy wou xel o.” ");
INSERT INTO tbx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Gyeik ingwei xel xoumeeng on ngo qayeeng en tine, xel laleind wo vanei wou Jems me Yoan. ");
INSERT INTO tbx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yesu taxe xel xouing lam wou e me neil, “Xam ghe woulek bei inyon eti yeiw wei xel yei bei inyei gyovaxa wei xel amba wei mi wo nikanzek lek yeing xel teyei, me xel wei wo lunkanzek en xel amba eno mi yeiteyei xel wo nikanzek. ");
INSERT INTO tbx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ekom se nambei nyon is wou xam. Qe eti yeiw wei embei bong lei ngandoung eivek xam senghoing, ond e mi bong ambei xam xe xukxe, ");
INSERT INTO tbx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","me eti yeiw embei na mamunghexeing eivek xam senghoing ond embong ambei xukxe bandaing wei xel dalus o. ");
INSERT INTO tbx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","En Xomaxoneing Neu Moux se lam bei xomaxoneing bo xuk wou e me devind e qe lam bei bong xuk me devind xomaxoneing ngenong me bong mapieing wei e yo nambei malew me na bey xel ngenong.” ");
INSERT INTO tbx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Woyom xel lam Jeriko. Ka Yesu is e xe xel betiyeing, is xel qendu ngandoung on xel xouing lam veil beyeeng on me la eno matekeing ti lei Batimius inyon Timius neu moux toundei wou sakwaing nenyawes me tay lulul wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Gyeik e ngo bei inyon Yesu wei Nasaret o, moxo taxe bei, “Yesu Dawit Neu Moux, wa laleim e pyaxow en ay!” ");
INSERT INTO tbx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Xel ngenongakes luk nikanzek wou e me neil wou embei denduing ma, ekom moxo taxe no niseikeing bei, “Dawit Neu Moux, wa laleim e pyaxow en ay!” ");
INSERT INTO tbx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu nale me neil, “Taxe e lam.” Om xel taxe la wou moux matekeing on, “Wang bo xeimlala dom bale lek vaxam! En moxo taxe wang o.” ");
INSERT INTO tbx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Moxo nex e xe teimb ding nge mapu teila nenyawes, dom vyeip me la wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yesu teling e, “Wambei a bong vati wou wang?” Moux matekeing neil, “Putoung, ambei gheina yo.” ");
INSERT INTO tbx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesu neil, “La, wa xe wongeingis wong wang wo nimzalek.” Lutika eno moxo ma yeila dom betiwou Yesu me tupwou sakwaing. ");
INSERT INTO tbx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ka xel la paviy Yerusalem me la tyip Betpage me Betani lek lukendu Oliv nei, Yesu wong e xe xel betiyeing yayuw la, ");
INSERT INTO tbx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","de neil wou luw, “La wou beyeeng wei di yeip atax wou muw mamim on, de lutika gyeik muw ambeing na eivek, on tyek muw ghe gwei dongi lingheing ti xel tup anghei inyon, dongi lingheing tiyon xelti se ghei dei lek. Muw wa tul yis veil dom na qou me nam inye. ");
INSERT INTO tbx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Wangwei xelti teling muw, ‘Muw ghe di wong ambei nyon enva?’ Yond muw a neil wou e, ‘Tambiy Ngandoung embei bong xuk en dom tyek bong enoum daing.’ ” ");
INSERT INTO tbx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Luw la me yei dongi lingheing ti toungale myayaing eivek sakwaing mema nayak, me xel tup lek xomek mya om luw tul. ");
INSERT INTO tbx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","De xomaxoneing valu toungale inyon eno teling, “Inyon muw ghe di wong vati, me ghe di tul dongi lingheing on?” ");
INSERT INTO tbx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Luw neil elox ambei kawei Yesu neil wou luw o, me xel xomaxoneing on wong luw qou me la. ");
INSERT INTO tbx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Woyom luw qou dongi me la wou Yesu me nex xel xe teimb lek demi, de moxo dei lek. ");
INSERT INTO tbx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Xomaxoneing ngenong vax xel xe teimb wei samyekeing o lek sakwaing de xel valu vax xax mema is lis wei xel qateiv eivek xuk yaeing o. ");
INSERT INTO tbx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Xel wei la mamunghexeing me xel wei di betiy eno taxe bei, “Hosana! Xeilala wei xa yo ena wou tiwei lam eivek Tambiy Ngandoung lei yo! ");
INSERT INTO tbx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Xeilala wei xa yo ena lek tete lalei wei xa bumi Dawit wei di lam o! Hosana ena gheyapu nei!” ");
INSERT INTO tbx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu la eivek Yerusalem me la eivek tete lalei wei xomek vambuing o. Moxo yei e vivekwou lulul sapa, ekom inye embei bouk eivek om la myayaing me lox me la Betani is xel betiyeing xoumeeng yuw. ");
INSERT INTO tbx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Nge yanyeing wei xel di la veil Betani, eno maxepya Yesu. ");
INSERT INTO tbx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Om yeila nanghei dingta me yei xax basunghek ti lis, om la en embei gyei bei ewo neing lek. Gyeik la tyip wou eno se yei lulti qe lis venaxow, en inye se bouk wei xax basunghek mi vuk o. ");
INSERT INTO tbx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Woyom e neil wou xax, “Xelti tyek se nox me na gya neing lek wang no.” Me e xe xel betiyeing ngo ingwei e neil o. ");
INSERT INTO tbx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ka xel la tyip Yerusalem, Yesu la eivek tete lalei wei xomek vambuing me tiy eti yeiw wei di xouv me wo vateivek nanghei inyon o. Moxo qapyex lelek wei xel wei di pelipek malew wei xel bamba yo me qou malew wei xomek vambuing o me sia wei eti yeiw di wo vateivek lek beliy o, ");
INSERT INTO tbx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","me peti xel bei xelti se qalei lulul wei vateivek o me qateiv me na nox tete lalei wei xomek vambuing o. ");
INSERT INTO tbx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Me ka e di teyoxe wou xel, moxo neil, “Inye xel byex eivek Anutu xe xoulek eno neil ambei nye: Yelemia 7:11 “‘A xe xomek tyek xel taxe bei inye xomek wei xel tembuing sapa nam a mi zeimemend eivek o.’ Ekom xam ghe wong e wo ‘xomek xupekeing wei xel panaxana yo.’” ");
INSERT INTO tbx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Xel lumuki leitata me putoung wei petieing o ngo tine me yimexe sakwaing wei xel embei nyeis e mey yo, xel yaleeng en e, en nambei xel dalus wei qekuma yon etek en e xe teyoxeing. ");
INSERT INTO tbx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Gyeik ingwei bouk eivek eno xel lam veil beyeeng ngandoung on me la. ");
INSERT INTO tbx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Eivek satiboukeing, ka xel di la wou sakwaing, eno xel yei xax basunghek mupek lek luselis me la pundanghou. ");
INSERT INTO tbx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petele wounalei en me neil wou Yesu, “Putoung, wei! Xax basunghek wei wang neil vyam lek eno mupek on!” ");
INSERT INTO tbx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu lewexe, “Xam ghe bongis Anutu. ");
INSERT INTO tbx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","A neil wou xam zonghek, wangwei xelti e neil wou lukendu tine, ‘Qandi me nex xow la eivek mamileeng,’ me e lalei se bo yuw qe e bongis vati wei neil, on tyek bo neing lek ambei kawei e neil o. ");
INSERT INTO tbx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nambei nyon a neil wou xam, vati wei xam ghe zeimemamim en, eno xam ghe bongis bei xam ghe qou woy, me inyon tyek bong ambei xam ghe teling en o. ");
INSERT INTO tbx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Me gyeik wa bale en zeimeing mema me wangwei wa laleim embo nilul wou xel nge, ond semaleeng e xe sewokeing veil e, en kandek Mam wei toundei eivek tyoung gheyapu nei eno semaleeng wa xe sewokeing veil.” ");
INSERT INTO tbx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xel la tyip Yerusalem no, me ka Yesu di ghavineeng eivek tete lalei wei xomek vambuing o, xel lumuki leitata me putoung wei petieing o me xel teivateiv lam wou e. ");
INSERT INTO tbx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Xel teling, “Lulul wei gweimbeeng ne eno wang di wong nangya eti lei me eti wong lei ne wou wang bei wang bong tine?” ");
INSERT INTO tbx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesu neil elox, “Tyek am bong telinyeing ti wou xam. Xam ghe zewexe lek ay, on tyek a neil wou xam en lei wei andi wong lulti beimambei ne nangya ne. ");
INSERT INTO tbx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Xam neil wou ay. Yoan xe lipekeing, inyon lam anghei tyoung gheyapu nei, o lam wou xomaxoneing?” ");
INSERT INTO tbx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Xel di luklek inyon wouma eivek xel venaxow senghoing me neil, “Wangwei xey a neimbei, ‘Nanghei tyoung gheyapu,’ on tyek moxo teling, ‘Ekom nambei nya xam seng wongis e?’ ");
INSERT INTO tbx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ek wangwei xey a neimbei, ‘Yoan xe lipekeing on lam wou xomaxoneing on inyon se teyei,’” en xel yaleeng en vati wei xomaxoneing tyek bong o, en xel dalus wongis bei Yoan on poropet ti neing ayang. ");
INSERT INTO tbx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Om xel lewexe lek Yesu, “Xa loungen.” Yesu neil, “Tyek a se neil teyeimbei eti wong lei ne wou ay me andi wong lulti beimambei ne.” ");
INSERT INTO tbx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Woyom Yesu luk wou xel teivateiv eivek qayeeng pakeing. “Tambiy ti ev xuk wain. E qo tete vivekwou, me ev leiveeng wei qeing wain o, me ev xomek vaxading wei yeingteyei xuk wain o. Woyom moxo toung xuk wain eivek xel valu memend bei xel bo xuk vateivek lek me dembu wain neing wou ma, veweeng wou xuk ma de veweeng wou xel venaxow dom la beyeeng dingta. ");
INSERT INTO tbx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lek bouk wei uleing wain neing eno moxo wong xukxe ti la wou xel wei mi yeiteyei xuk bei na qou wain neing valu eivek xuk wain. ");
INSERT INTO tbx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ekom xel zeimaxoun e, me leis e wo nol dom wong moxo lox me la mema nivax. ");
INSERT INTO tbx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Woyom moxo wong xukxe nge la wou xel, me xel sesa moux tine lek e lu de xel se ngo e vya qe xel wo niyalenyeing ngandoung wou e. ");
INSERT INTO tbx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","E wong xukxe nge lox no, om tiyon mou xel leis e mey. E wong xel ngenongakes la, ekom xel sesa valu, de xel leis xel valu mey. ");
INSERT INTO tbx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“E xe tixemou tateis toundei en ingwei embei bong ena yo, neu moux tiwei e lalei vind o. E wong ela ti yusayang, me neil, ‘Tyek xel gwevek a neung xe qayeeng.’ ");
INSERT INTO tbx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ekom xel xukxe wei wain o neil wouma, ‘Tambiy tine tyek na qou ma xe lulul dalus. Xam lam en xey a nyeis e mey o, dom lulul dalus on tyek inyon xe xe.’ ");
INSERT INTO tbx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Om xel zeimaxoun e me leis e mey, dom nex e la myayaing veil xuk wain. ");
INSERT INTO tbx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Woyom Yesu teling xel “tyek xuk wain ma bo vati? Tyek moxo nam dom nyeis xel xukxe dom bong xuk wain na wou xel bange. ");
INSERT INTO tbx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Beip xam seng mi pyaw xoulek tine? “‘Qakous mundeeng ti wei xel kamunda pesek, eno wong ambei qakous ti myaxeeng wei nale me mi byexaxoun xomek o. ");
INSERT INTO tbx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tambiy Ngandoung wong tine, me xa xei lek mami me inye wo etekeing wou xa.’” ");
INSERT INTO tbx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Woyom xel leitata yimexe sakwaing ti en xel embei zeimaxoun e en nambei xel woulek bei e neil qayeeng pakeing lek xel. Ekom xel yaleeng en xel qendu ngandoung on, om xel ghanaw e me la. ");
INSERT INTO tbx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Kalekom xel wong Parisi valu me xel wei Herot o valu la wou Yesu bei tandei e en emaxow xe qayeeng wei embei neil ena sewok o. ");
INSERT INTO tbx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Xel lam wou e me neil, “Putoung, xa woulek bei wang on tambiy neing. Wa seng mi waleeng en xelti, me wa seng mi wei bei inyon xel eti yeiw, qe wang mi teyoxe sakwaing wei Anutu yo me ghe betiwou qayeeng zonghek. Om petieing neil embei xey a toung takis wou Sisa o xe se toung? ");
INSERT INTO tbx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Xey a toung o xe se toung?” Ekom Yesu woulek bei xel on myend yuw om neil wou xel bei, “Nambei nya xam ghe di tandei ay? Qou selewa ti lam wou ay, me a xei.” ");
INSERT INTO tbx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xel qou selewa ti me lam, om moxo teling xel, “Eti xe tenu ing tine? Me eti lei inye?” Xel neil elox, “Sisa.” ");
INSERT INTO tbx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Woyom Yesu neil wou xel, “Xam ghe bong vati wei Sisa xe yo wou Sisa, dom ghe bong vati wei Anutu xe yo wou Anutu.” Om xel on etek en e. ");
INSERT INTO tbx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Woyom xel Sadyusi, wei mi neil embei xel meyeing tyek se qandi lek eno lam wou e is telinyeing ti. ");
INSERT INTO tbx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Xel neil, “Putoung, Mose byex qayeeng wou xey bei wangwei moux ti li na mey de venei nanghei toundei ekom neu ma, yond moux tiyon dii vexeiv on me bo li neuyeiw. ");
INSERT INTO tbx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Woyom xel lim yuw lindama eno toundei. Tiwei tax eno ii vex on me mey ekom se wo neu ti. ");
INSERT INTO tbx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Li nge wei yuw eno ii vexeiv on dom mey is, ekom se wo neu ti. Kwa kayon eno li tiwei yal o betiwou. ");
INSERT INTO tbx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Om nambei nyon eno xel lim yuw on ti se wong neuyeiw ti, dekakom vex on mey loxyus en xel dalus. ");
INSERT INTO tbx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Lek bouk wei qandieing lek, eno tyek vex on eti venei? En inyon xel lim yuw ii vex tiyon.” ");
INSERT INTO tbx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu neil elox, “Xam ghe neil qayeeng on la sewok en xam seng woulek xoulek wei dei yeip eivek qapiya me nikanzek wei Anutu yo. ");
INSERT INTO tbx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Gyeik bouk wei xel meyeing qandi lek, eno xel se teyeimbei diima me diima nox me noum, tyek xel ghok ambei xel angela wei tyoung gheyapu yo. ");
INSERT INTO tbx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","De qayeeng wei meyeing e qandi lek, beip inye xam seng pyaw eivek qapiya wei Mose me eivek pavulek wei nenyex tum lek xax nayaka yo, de eivek pavulek wei Anutu neil wou e yo, ‘A ne Anutu wei Apraham, Anutu wei Isaka me Anutu wei Yakop o?’ ");
INSERT INTO tbx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Moxo se Anutu wei xel meyeing, qe e Anutu wei xel wei mapieing. Om qayeeng wei xam ghe neil on eno la sewok.” ");
INSERT INTO tbx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Putoung wei petieing o ti lam me ngo xel di pyaw lekama lox me loum is Yesu. Me ngo bei Yesu lewexe lek qayeeng on wo nimza, om teling e, “Qayeeng petieing tina, inye ngandoung ghanaw veil en qayeeng petieing dalus?” ");
INSERT INTO tbx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesu lewexe, “Tiwei ngandoung ghanaw veil eno inye: ‘Xam Israel ngo, Tambiy Ngandoung xe xe Anutu, emaxow tixemou yon Tambiy Ngandoung. ");
INSERT INTO tbx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Xam laleimim devind Tambiy Ngandoung xam xe Anutu is laleimim dalus me is numim pieing dalus me is xam lumimpeyei dalus me is xam nimim kanzek dalus.’ ");
INSERT INTO tbx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nge wei yuw eno inye: ‘Wa laleim e mi devind nimpapu nambei wa laleim mi vind xow o.’ Qayeeng petieing ti se ngandoung ghanaw yuw ne.” ");
INSERT INTO tbx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Moux on neil elox, “Putoung, wang neil neing bei Anutu yon tixemou me xel ba ma dom emaxow. ");
INSERT INTO tbx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Laleim vind e is laleim dalus me is wa lumpeyei dalus me is wa nimkanzek dalus me wa laleim devind nimpapu nambei wa laleim mi vind venaxow o. Inyon ngandoungateiv ghanaw xound wei seing dalus o me da leimalei.” ");
INSERT INTO tbx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Gyeik Yesu yei bei e neil qayeeng nambei xel wei lupeyei nimza, om neil wou e, “Wa seng dei dingta veil tete lalei wei Anutu yo.” De woyom xel yaleeng om xelti se lox teling e no. ");
INSERT INTO tbx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ka Yesu di teyoxe xel eivek tete lalei wei xomek vambuing o, e teling, “Nambei nya ekom xel putoung wei petieing o neil embei Kilisi yon Dawit neu? ");
INSERT INTO tbx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dawit venaxow neil angya Laweeng Vambuing, me neilteyei bei: “‘Tambiy Ngandoung neil wou a xe Tambiy Ngandoung: “Wa mendei wou a memang payeiv deka a toung wa xe xel vevek amba na xeinghembi eivek wa vaxam bole.”’ ");
INSERT INTO tbx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dawit venaxow taxe Kilisi ne Tambiy Ngandoung. Nambei nya Kilisi yon Dawit neu is ambei nyon?” Xel qendu ngandoung on liw nenyend wou e is xeindlala. ");
INSERT INTO tbx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ka Yesu teyoxe xel, eno neil, “Xam ghe gwei xow teyei en xel putoung wei petieing o. Xel embei mi ghavineeng is teimb ding me xel embei xel a mi neil bendiyeing teiv wou xel eivek beyeeng wei vateivek o, ");
INSERT INTO tbx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","me xel embei mi mendei lek sia nimza wei xel wei leitata mi deilek o eivek xomek qekueing ama me mindei lek sia nimza wei tax wei xel lei laeing o eivek mata ngandoung. ");
INSERT INTO tbx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Xel mi tyoxe xel vexeiv me qou xel xe xomek me talex xow en zeimeing mema ding. Xel moux ambei nyon eno tyek na qou myaveweeng ngandoung ghanaw xel bamba.” ");
INSERT INTO tbx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu dei paviy ingwei xel mi toung da nanghei yo, me di yei bembeeng vex alis moux di toung xel xe da la eivek qoupek malew wei xomek vambuing o. Xomaxoneing ngenong wei lulul ana eno toung malew ngandoung. ");
INSERT INTO tbx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ekom vexeiv kanyo ti eno lam me toung selewa nayak yayuw, nikanzek wei selewa ne eno teyei lek selewa gyand ti. ");
INSERT INTO tbx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu taxe e xe xel betiyeing lam wou e, me neil, “A neil wou xam zonghek, vexeiv kawei kanyo ne eno toung malew ngandoung eivek qoupek malew wei xomek vambuing o ghanaw xel bamba dalus. ");
INSERT INTO tbx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","En xel dalus wong xel xe lulul dalus eivek lulul ngenong wei xel o. Ekom vex on lulul ma dom wong e xe kayo dalus, de wong ingwei embei toumendei mapieing en eno dalus.” ");
INSERT INTO tbx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ka Yesu la veil tete wei xomek vambuing, eno e xe betiyeing ti neil wou e, “Putoung! Wei, qakous qakous ngandoung nimza yon, me xomek nimzamza yon.” ");
INSERT INTO tbx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yesu lewexe, “Wang wei xomek ngandoung dalus ne? Qakous ne ti tyek se mendei lek nge mapu, qe tyek xel lelolexe dalusateiv dom banex e deteina.” ");
INSERT INTO tbx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ka Yesu dei lek lukendu Oliv nei wou xomek vambuing vi valu nei, Petele me Jems, Yoan me Andrias xel teling wou e xupekeing, ");
INSERT INTO tbx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Neil wou xa, gyeik inya ekom lulti beimambei ne nam atyip? Me dee vati tyek xa boulek bei lul dalus ne embim bo neing lek?” ");
INSERT INTO tbx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu neil wou xel, “Xam ghe gweiteyei xow, en kandek xelti se nam a tyoxe xam. ");
INSERT INTO tbx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Xel ngenong tyek nam lek a leing, me na neimbei, ‘A Mesia,’ me tyek xel a tyoxe xel ngenong. ");
INSERT INTO tbx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Gyeik xam a ngo xel vevek ngandoung me qayeeng laweeng en xel vevek ngandoung o, on xam seng detek, lul ambei nyon tyek nam atyip, ekom bouk loxyus eno nanghei. ");
INSERT INTO tbx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","En xomaxoneing wei tembuing nge tyek qandi lek me bo vevek is xomaxoneing wei tembuing nge yo, tete lalei nge tyek bo vevek is tete lalei nge, me tyek inyon tembuing api eivek beyeeng valu beti, me maxep ngandoung tyek nam. Lulti beimambei ne tyek nam myaxeeng nambei vex wei mi axe vanei natax en ingwei yak mi umbek o. ");
INSERT INTO tbx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Xam a mi gwei xow teyei. En tyek xel a zeim xam me na qou me na wou xel kanzol me xel sesa xam eivek xomek qekueing ama. Tyek xam bale wou lei ngandoung wei seyap o mendghalus me king en ay. De tyek xam a tul pavulek wou xel en vati wei xam ghe wei lek mamim o eno wou xel. ");
INSERT INTO tbx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Me xam a neil Xoulek Nimza wou xomaxoneing tembuing sapa yo bole. ");
INSERT INTO tbx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gyeik ingwei xel embei zeimaxoun xam me bo qayeeng en xam on xam seng bounaleim ngenong en vati wei xam ambei neil o. Xam a neil vati wei Anutu wong wou xam lek bouk kayon bombek. En inye xam venaxow tyek se baluk qe Laweeng Vambuing tyek na neil inyon teyei. ");
INSERT INTO tbx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Li moux tyek na neil li moux teyei me na toung e na eivek xel memend me xel nyeis e mey, de mayeiw tyek bong ambei inyon wou neuyeiw. Neuyeiw tyek bo nol wou mamata me na toung xel na eivek meyeing. ");
INSERT INTO tbx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Me xomaxoneing dalus tyek laleind bo vanei wou xam en ay, ekom eti embei bale nikanzek me ena bouk loxyus wei lulul ne embei na tip lek on tyek Anutu devind xel en xel se mey. ");
INSERT INTO tbx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Deka xam ghe gwei lul nilul ayang, wei mi wo nol wou lulul eno na bale nanghei beyeeng vambuing wei tyek se teyeimbei bale yo.” (Yon xam wei ghe mi pyaw qayeeng ne eno xam woulek.) “De wong xel wei toundei eivek Yudia nei pek me la lukendu qendu nei. ");
INSERT INTO tbx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Wangwei xelti na toumendei lek xomek demi qetyei eno tyek douk me noum, de se na eivek e xe xomek lalei me na qou vati wei e yo me na myayaing. ");
INSERT INTO tbx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wangwei xelti la toundei eivek xuk yaeing eno tyek se nox xomek me na qou e xe teimb ding nge. ");
INSERT INTO tbx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tyek inye bo nilul eivek bouk kayon en xel vex wei xeipouyek o me xel tayeiw wei di wo luul wou neuyeiw o! ");
INSERT INTO tbx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Xam a zeimemamim wou Anutu en kandek lul tine e se nam eivek bouk wei laweeng nityuweing wei nigheghoing o, ");
INSERT INTO tbx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","en bouk ti beimambei yon tyek bo bouk wei nimaying ngandoung me tyek se teyei lek nambei myaxeeng selis wei Anutu toung tembuing me elam tyip gweimbeeng ne yo me lul nimaying ti tyek se nox teyei lek no. ");
INSERT INTO tbx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Wangwei Tambiy Ngandoung se qateiv bouk wei nimaying eno bo sepi, on tyek xelti se mendei mapieing, ekom wounalei en e xe xel wei beyal wou emaxow o, om qateiv bouk wo sepi. ");
INSERT INTO tbx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Lek seivma kayon, wangwei xelti e neil wou xam, ‘Wei, Kilisi inye!’ o ‘Wei, e inyei!’ yond xam seng bongis e xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","En xomaxoneing tyonyeing valu tyek na neimbei a Kilisi o a poropet eno tyek nam a tyip me bong dee me lulvako valu wangwei xel teyei nei on tyek xel dandiy xomaxoneing wei Anutu beyal o. ");
INSERT INTO tbx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Om xam ghe gweiteyei xow. A neil wou xam atax en lul dalus wei bouk tine embei nam o. ");
INSERT INTO tbx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ka bouk ti beimambei wei nimaying ngandoung ne na ma veil, “ ‘Eno sayeiv tyek bo mapetok, me dentouk tyek se tel, ");
INSERT INTO tbx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","de betum tyek detei nanghei tyoung, de lul nikanzek wei tyoung dalusateiv ne eno tyek bo pimapi.’ ");
INSERT INTO tbx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Woyom lek bouk kayon eno xomaxoneing tyek gyei Xomaxoneing Neu Moux tyek nam eivek laxap ngandoung is nikanzek ngandoung me xeiyaing ngandoung. ");
INSERT INTO tbx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Me tyek bong e xe xel angela na qekuwou e xe xel wei beyal o eivek beyeeng dalusateiv me e na tembuing sapa nei, nanghei ingwei tembuing la tip lek o, me ena ingwei tyoung dalus la tip lek o. ");
INSERT INTO tbx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“De xam ghe boulek xax basunghek, gyeik ingwei xax mema byex lis vako lek woy, yon xam ghe boulek bei, buk wei seiv embei siing eno lam paviy. ");
INSERT INTO tbx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Om nambei nyon, gyeik ingwei xam ghe gwei lul beimambei wei a neil wou xam en o belup, on xam ghe boulek bei Xomaxoneing Neu Moux lam paviy, me toungale wou qapomb. ");
INSERT INTO tbx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","A neil wou xam zonghek, xel qendu ti gweimbeeng ne tyek se mey qe ka lul dalus ti beimambei ne nam atyip bole. ");
INSERT INTO tbx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tyoung me tembuing tyek nati, ekom a xe qayeeng tyek se nati. ");
INSERT INTO tbx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Xelti se woulek bouk o seivma, me angelayeiw eivek tyoung gheyapu eno se woulek, o Neu moux se woulek is, qe Ma venaxow. ");
INSERT INTO tbx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Xam ghe gwei xow teyei me mendi daxe! En xam seng woulek bouk kayon bombek. ");
INSERT INTO tbx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Inye nambei tambiy ti la dingta. Gyeik ingwei moxo la veil beeng dom toung e xe xukxe bei xel a mi gyeiteyei e xe lulul, de pum xuk wou xel titi bei xel bong dom neil wou tiwei mi nale zeyi xomek mya bei e mi gyeiteyei. ");
INSERT INTO tbx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Nambei nyon xam a mi gweiteyei me ghe daxe en xam seng woulek bouk gyeik ingwei xomek ma embei noum o, beip eivek soukeing, o boukeing masenghoing, o gyeik ingwei qouklex sesa vya, o di nexla yo. ");
INSERT INTO tbx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wangwei e noum lutika nei, on wei xam seng bong e gyei ingwei xam ghe di weip o. ");
INSERT INTO tbx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Vati wei a neil wou xam, eno a neil wou xel dalus, ‘Xam a mi gweiteyei me ghe daxe!’ ” ");
INSERT INTO tbx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bouk yuw nanghei di yeip zeyi mata ngandoung wei Pasova me mata wei Yaeing Belet Wei Yis Ma Veil o. Om xel lumuki leitata me xel putoung wei petieing eno xel di yimexe sakwaing en xel embei zeimaxoun Yesu xupekeing dom nyeis e mey. ");
INSERT INTO tbx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","En xel neil, “Xey ambei se bong ambei nye lek bouk ngandoung wei lalo yo, enok xel xomaxoneing ne na neilama de vevek qandi lek.” ");
INSERT INTO tbx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ka Yesu la eivek beyeeng Betani, me la toundei eivek Simon beeng, tambiy yon takwei eno qou vanei lepa me di ya lek zek, de vex ti lam is botol qakous wei wel xeimangou wei malew ngandoung o, me lam dembu botol qakous on dom taw wel lek Yesu lu. ");
INSERT INTO tbx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Xel valu wei toundei inyon eno yei tiyon om xel laleind wo nol me luk ngenong wouma, “Nambei nya ekom vex ne wo nol wou wel ne? ");
INSERT INTO tbx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wel tine teyeimbei xey a bong vateivek lek me na qou malew selewa teyei lek xouveing wei vakovek qes ti yo de na bong wou xel kanyo.” De xel neil vex on. ");
INSERT INTO tbx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu neil, “Nambei nya xam ghe wong nimaying wou vex ne? Xam wong e toundei, vex ne wong lul nimza ne wou ay. ");
INSERT INTO tbx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Xel wei kanyo eno tyek na mi mendei is xam takwei takwei, om xam a mi devind xel taxombouk teyei lek ingwei xam ambei bong o. Dom ay ne tyek a se mendei is xam taxombouk. ");
INSERT INTO tbx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Lul vati wei vex on teyeimbei bong eno e wong woy de taw wel lek a neing atax en menyex wou aning meyeing en eveing. ");
INSERT INTO tbx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A neil wou xam zonghek, xel embei mi neil Xoulek Nimza nanghei inyayeiw eivek tembuing sapa eno tyek xel a mi tul pavulek en vati wei vex ne wong wou a ne, eno tyek xel a mi bou naleind en e.” ");
INSERT INTO tbx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Woyom Yudas Iskariot, Yesu xe betiyeing xoumeeng yuw eno ti, la wou xel lumuki leitata me neil e teyei wou xel bei tyek na toung Yesu na eivek xel memend. ");
INSERT INTO tbx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Xel ngo qayeeng tiwei Yudas neil ne om xel wo xeindlala. Me neil zonghek wou e bei tyek xel bong malew valu wou e. Om di yimexe sakwaing wei embei toung Yesu na eivek xel memend o. ");
INSERT INTO tbx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Lek bouk tiwei tax wei Bouk Wei Yaeing Belet Wei Yis Ma Veil eno lam. Om xel betiwou kwa wei xel mi leis sipsip lingheing en yaeing lek bouk wei Pasova yo, eno xel betiyeing neil wou Yesu bei, “Wambei xa na menyex wou mata wei bouk Pasova nanghei tina en kandek wang na gwa eivek?” ");
INSERT INTO tbx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Woyom Yesu wong xel betiyeing yuw la, me neil wou luw ambei nye, “Muw ghe na eivek Yerusalem nei. Moux ti tyek qalei deng mouing is memiing me nam pelong muw, ond muw betiwou e. ");
INSERT INTO tbx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","De muw a neil wou xomek ma tiwei embei deivek na yo bei, ‘Putoung teling, “A xe xomek lalei toundei inya, wei ambei gha yaeing wei bouk Pasova yo is a xe xel betiyeing ne yo?”’ ");
INSERT INTO tbx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Moxo tyek talex xomek lalei ngandoung nge wei di yeip gheyapu eno wou muw, me lulul wei yaeing lek o me deing lek eno xel menyex wou woy. Muw menyex wou lulul yaeing wou xey anghei inyon.” ");
INSERT INTO tbx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Betiyeing aluw la, me la eivek beyeeng on me yei lul dalus e la teyei lek ambei kawei Yesu neil wou luw o. Om luw menyex wou mata wei bouk Pasova yo nanghei inyon. ");
INSERT INTO tbx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Gyeik ingwei bouk eivek eno Yesu lam tyip is e xe xel betiyeing xoumeeng yuw. ");
INSERT INTO tbx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ka xel toundei lek lelek me di ya, moxo neil, “A neil wou xam zonghek bei, tyek xam ti venaxow na neil a teyei me na toung ay eivek xel ba memend, tambiy tiwei di ya yaeing is a ne.” ");
INSERT INTO tbx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Moxoyeiw laleind wo nimaying, om xel titi di teling wou e, “Beip inye se ay, ei?” ");
INSERT INTO tbx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Moxo neil elox, “Xam xoumeeng yuw on ti, tiwei di ya belet lek dipek is ay ne. ");
INSERT INTO tbx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Xomaxoneing Neu Moux tyek betiwou sakwaing kawei xel byex eivek xoulek wei Anutu en e yo. Ekom inye wo lalei pyaweing en tambiy tiwei embei neil Xomaxoneing Neu Moux teyei me na toung e na eivek xel ba memend o, eno tyek na qou myaveweeng ghanaw veil. Om inye nimza bei moux tiyon ta se bou e.” ");
INSERT INTO tbx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ka xel di ya, Yesu qou belet, me wong dange wou dom dembu, me wong wou e xe xel betiyeing, me neil, “Xam qou, tine inye a neing.” ");
INSERT INTO tbx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Woyom moxo qou mayamya wain, me wong dange wou dom wong wou xel, me xel dalus num eivek. ");
INSERT INTO tbx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yesu neil wou xel, “Tine inye a xe gyand wei na byexaxoun qokatu yo, wei a qapyex bei devind xomaxoneing ngenong o. ");
INSERT INTO tbx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","A neil wou xam zonghek, tyek a se nox me na num wain neing no qe ka gyeik bouk wei a num wain vako eivek tete lalei wei Anutu yo.” ");
INSERT INTO tbx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Gyeik xel wong lalo ti woy, xel la myayaing me la lukendu Oliv. ");
INSERT INTO tbx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yesu neil wou xel, “Xam dalus xe wongeingis tyek detei veil en xel byex eivek xoulek wei Anutu yo eno nambei nye: “ ‘Tyek a nyeis gyovaxa wei sipsip o, dom tyek sipsip na pek me davuna.’ ");
INSERT INTO tbx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ekom ka a qandi lek veil meyeing le, tyek a na tax en xam me nana Galili.” ");
INSERT INTO tbx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petele neilteyei, “Wangwei xel dalus xe wongeingis detei veil me xel na veil wang, on tyek a se teyeimbei na veil wang.” ");
INSERT INTO tbx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu lewexe, “A neil zonghek wou wang, gweimbeeng boukeing wei qouklex seng ghei sesa vya luyuw eno tyek wamaxow ghe dax a vun luyal.” ");
INSERT INTO tbx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ekom Petele nale nikanzek en qayeeng me neil wou Yesu, “Ma mouyo wangwei a mey is wang nei on tyek a se teyeimbei dax wang vun!” Me xel betiyeing dalus neil ambei nyon teyeima. ");
INSERT INTO tbx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Xel la beyeeng ti lei bei Getsemani, me Yesu neil wou e xe xel betiyeing, “Xam a toumendei inye dom a na zeimemang.” ");
INSERT INTO tbx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Om Yesu qou Petele luw Jems me Yoan me lal la is e, ekom moxo axe nimaying ngandoung me lalei wo nimaying. ");
INSERT INTO tbx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Yesu neil wou xel, “A axe nimaying ngandoung lek xow teyeimbei a mey. Mal a toumendei inye me ghe gweiteyei teyei embo nimza.” ");
INSERT INTO tbx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesu dula nayaka, de teila yeip ma eivek tembuing dom zeimema bei wangwei inye teyei nei ond nimaying ne deteina veil e. ");
INSERT INTO tbx_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Moxo neil, “Aba, Mang, lulul sapa yon teyeimbei wang bong. Zeim mayamya tine veil ay. Ekom wa se betiwou a laleing, qe wa betiwou wamaxow laleim.” ");
INSERT INTO tbx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Woyom Yesu loumelam wou e xe betiyeing a lal me yei lal di yeip. E neil wou Petele, “Simon, wa ghei di weip? Inye se teyeimbei wam di gweina nayaka, ei? ");
INSERT INTO tbx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Om mal mendi gweiteyei teyei me na zeimemamim en kandek mal se detei en axeing. Xam laleimim embei bong xuk, ekom neing wo nimaing.” ");
INSERT INTO tbx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Lox me la lunge no me zeimema nambei nge tax o. ");
INSERT INTO tbx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gyeik e loumelam, e yei lal lox me la yeip no, en nambei lal mendghalus wo nimaying. Om lal se wou naleind en vati wei lal embei neil wou e yo. ");
INSERT INTO tbx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Yesu loumelam tiwei luyal o, dom neil wou lal, “Mal anghei di weip me ghe qou laweeng. Woy, seivma lam o. Wei, Xomaxoneing Neu Moux xel embei neil e teyei me na toung e na eivek xel wei sewokeing o memend. ");
INSERT INTO tbx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mal qandi lek! Me xey a la! Wei, tiwei embei neil a teyei me na toung a na eivek xel memend eno lam tyip on!” ");
INSERT INTO tbx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ka Yesu nanghei di neil qayeeng, Yudas wei betiyeing xoumeeng yuw eno ti lam tyip is xel qendu ngandoung on, xel zeim ngeyeing vevek me pebumeeng, xel lumuki leitata, me putoung wei petieing o me xel teivateiv eno wong xel lam. ");
INSERT INTO tbx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tambiy tiwei embei neil Yesu teyei me na toung e na eivek xel vevek memend eno talex dee ti wou xel bei, “Tambiy tiwei ambei sesuvexe eno, tiyo inyon, om xam a zeimaxoun e me ghe gweiteyei de na qou e me na.” ");
INSERT INTO tbx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yudas lam me la daing wou Yesu me neil wou bei, “Putoung!” Dom sesuvexe e. ");
INSERT INTO tbx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Om xel xomaxoneing on zeimaxoun Yesu. ");
INSERT INTO tbx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Woyom xel wei toungale paviy yon ti tetei e xe ngeyeing vevek me qateiv xukxe wei lumuki lukanzek on nenyalis nge tip me teila. ");
INSERT INTO tbx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yesu neil wou xel, “Xam ambei a panaxana ti, om xam ghe lam is ngeyeing vevek me pebumeeng bei nam a zeimaxoun a ne? ");
INSERT INTO tbx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Teyei lek bouk tambak eno a mindei is xam, me na wo teyoxeing eivek tete lalei wei xomek vambuing o, ekom xam seng zeimaxoun ay. En qayeeng wei yeip eivek Anutu xe xoulek eno embo neing lek.” ");
INSERT INTO tbx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Woyom xel betiyeing dalus ghanaw e de pek me la. ");
INSERT INTO tbx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Xomaxoneing ghavis ti, se byex lulti qe teimb teleing ti wei sevun xow eno ti, me di betiwou Yesu gyeik ingwei xel zeimaxoun e yo, ");
INSERT INTO tbx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ekom moxo pek veil xel xeitouk me la dom ghanaw e xe teimb teleing on toundei yus. ");
INSERT INTO tbx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Xel qou Yesu me la wou lumuki lukanzek, de xel lumuki leitata dalus me teivateiv, me putoung wei petieing o xel xouing lam qekuma. ");
INSERT INTO tbx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petele di betiwou e me la kwanding, me la eivek tete lalei wei xomek wei lumuki lukanzek o, nanghei inyon eno la dei is xel belimbo wei mi yeiteyei xomek vambuing o me di pavang xow wou nenyex. ");
INSERT INTO tbx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Xel lumuki leitata is xel kanzol dalus eno di yimexe pavulek wei e wong esewok o en ingwei xel embei nyeis e mey yo, ekom xel se yeiwou ti. ");
INSERT INTO tbx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Xel ngenong byex qayeeng tyonyeing lek e, ekom xel xe qayeeng se la teyeima. ");
INSERT INTO tbx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Woyom xel valu nale ghey me wong pavulek tyonyeing tine lek e: ");
INSERT INTO tbx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Xa ngo e neil, ‘Tyek a lelolexe xomek vambuing tine wei xomaxoneing ev ne dom eivek bouk yal eno tyek a dev nge no, wei xomaxoneing se ev angya memend o.’” ");
INSERT INTO tbx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ekom pavulek wei xel neil on la bandabanda de se teyeima. ");
INSERT INTO tbx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Woyom lumuki lukanzek eno nale wou xel mend me teling Yesu, “Qayeeng vati ingwei xel moux tine di byex lek wang ne? Se teyeimbei wa neil qayeeng ti nox wou xel?” ");
INSERT INTO tbx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ekom Yesu toungale kanzek de se neil qayeeng ti lox. Lumuki lukanzek lox me la teling wou e no, “Inye wa Kilisi. Anutu wei xa mi sanghoxe yo neu, ei?” ");
INSERT INTO tbx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu neil, “Inye ay yo. Me tyek xam ghe gwei Xomaxoneing Neu Moux na toumendei wou Anutu Nikanzekta mema payeiv me nam is laxap wei tyoung gheyapu yo.” ");
INSERT INTO tbx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Lumuki lukanzek lex emaxow xe teimb de teling, “Xey a ngo qayeeng wei xel valu byex lek e is en va? ");
INSERT INTO tbx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Emaxow neil teyei me xam ghe ngo qayeeng lukeingyak wei neil lek Anutu yo. Om xam ghe wou naleimim ambei nya?” Xel dalus yei me luk en e bei, “Wo esewok teyei lek ingwei e mey yo.” ");
INSERT INTO tbx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Woyom xel valu pesuv myend louk lek e, me xel tup e ma tuzeyi, de lund memend me venoux e me neil, “Neil qayeeng poropet wou xa bei eti leis wang!” Om xel belimbo wei mi yeiteyei xomek vambuing eno qou e me leis e. ");
INSERT INTO tbx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ka Petele toundei nge xo eivek tete lalei eno, lumuki lukanzek xe xukxe vexawo ti lam. ");
INSERT INTO tbx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Gyeik vexo yei Petele di pavang xow wou nenyex, vexo yei e bombek me neil, “Wang is ambei nyon wang mi la is Yesu wei Nasaret o.” ");
INSERT INTO tbx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ekom Petele axvun. E neil, “A loungen e yo, a se woulek qayeeng tiwei wang di luklek on.” Dom la myayaing paviy tete mya me la nale. De qouklex ti sesa vya. ");
INSERT INTO tbx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Gyeik vex xukxe yei e ghei inyon, vexo neil no wou xel wei toungale yon, “Tambiy tine inye tambiy wei xel o ti.” ");
INSERT INTO tbx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ekom moxo lox me la axvun no. Denlek ka, xel wei toungale paviyeing eno neil wou Petele, “Neing ayang wang on tambiy wei xel o ti, en inye wang lam anghei Galili.” ");
INSERT INTO tbx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Petele neil, “A neil zonghek lek inyapunei lei bei a loung en tambiy tiwei xam ghe di luk en e yon. Wangwei a tyoing nei yon tyek a qou myaveweeng.” ");
INSERT INTO tbx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Se denlek en qouklex sesa vya luyuw. Woyom Petele wounalei no en qayeeng wei Yesu neil woy wou e yo, “Ka qouklex se sesa vya bo luyuw atax eno tyek wang dax a vun luyal.” Om moxo eng niseikeing. ");
INSERT INTO tbx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Eivek satiboukeing lul eno, xel lumuki leitata, is xel teivateiv, me putoung wei petieing o me xel kanzol dalus tup qayeeng ti wouma. Xel tup Yesu dom qou e me la me toung e la eivek Pailat mema. ");
INSERT INTO tbx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat teling, “Inye wa king wei xel Yudayeiw o?” Yesu neil elox bei, “nambei wamaxow ghe neil on.” ");
INSERT INTO tbx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Xel lumuki leitata byex qayeeng lek e en lulul ngenong. ");
INSERT INTO tbx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Om Pailat teling e no, “Inye wambei se neil enox ei? Wei lul vamva eno xel di byex qayeeng lek wang en.” ");
INSERT INTO tbx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ekom Yesu se neil qayeeng ti lox, om Pailat moxo wounalei ngenong. ");
INSERT INTO tbx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","De inye bouk wei Pasova wei Pailat mema mi tena xel xeitueing ti mi la teyei lek ingwei xomaxoneing venaxow laleind vind o. ");
INSERT INTO tbx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Xomaxoneing ti lei Barabas eno la xeitueing is xel valu wei wo vevek wou Rom me leis seyap valu mey o. ");
INSERT INTO tbx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xel qendu ngandoung lam wou Pailat me teling bei, embong wou xel ambei ingwei mi wong o. ");
INSERT INTO tbx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat teling, “Xam ambei a memang tena king wei Yudayeiw eno nak wou xam?” ");
INSERT INTO tbx_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Moxo neil inye en woulek woy bei xel lumuki leitata eno laleind wo nol wou e me zeimaxoun Yesu me qou me lam wou e. ");
INSERT INTO tbx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ekom xel lumuki leitata eno zeim xel qendu ngandoung on laleind lek bei Pailat mema tena Barabas nam wou xel de se Yesu. ");
INSERT INTO tbx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat teling xel no, “De woyom, tyek a bong ambei nya en tambiy tiwei xam ghe taxe bei king wei Yudayeiw ne?” ");
INSERT INTO tbx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Xel taxe niseikeing no, “Tuw e lek xax pepeeng.” ");
INSERT INTO tbx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat teling, “En va? E wong sewokeing vati?” Ekom xel taxe niseikeing la ghey bei, “Tuw e lek xax pepeeng!” ");
INSERT INTO tbx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat embei bong xel qendu ngandoung on laleind bo nimza, om mema tena Barabas lam wou xel. De neil wou e xe xel bei xel sesa Yesu dom wong ela eivek xel vevek memend bei xel atuw e lek xax pepeeng. ");
INSERT INTO tbx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xel vevek qou Yesu me la eivek tete lalei wei seyap bend o me taxe xel vevek on dalus lam. ");
INSERT INTO tbx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xel byex teimb ding mateyek lek e, woyom xel bembinexe qapangek ying lekti nambei qelumking de toung lek e lu. ");
INSERT INTO tbx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Me xel taxe la wou e bei, “Bendiyeing, king wei Yudayeiw o!” ");
INSERT INTO tbx_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Xel sesa e lu lumama nangya lengwes de pesuv myend louk lek e. Xel ev vaxend qatu eivek de sanghoxe e. ");
INSERT INTO tbx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Me gyeik ingwei xel luk seloukeing lek e woy, eno xel kwax teimb ding wei mateyek o veil dom byex emaxow xe teimb lek e. Woyom xel qou e me la myayaing bei na tuw e lek xax pepeeng. ");
INSERT INTO tbx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tambiy ti nanghei Sairini, e lei Simon, Aleksanda luw Rupus mend, moxo di la vaxa wou sakwaing nanghei danghei wei tembuing ba me embei na eivek beyeeng ngandoung on, omva xel tendu bei e qalei xax pepeeng. ");
INSERT INTO tbx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xel qou Yesu me la beyeeng wei xel mi taxe bei Golgata (qes ambei nye bei beyeeng wei lukanzek). ");
INSERT INTO tbx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Woyom xel wong wain wei xel maleeng is xax mer myalouk eno wou e, ekom moxo se num. ");
INSERT INTO tbx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","De xel tuw e lek xax pepeeng. De nex qakous dee bei gyei vati wei xel titi embei qou yo dom xel pum e xe teimb wouma. ");
INSERT INTO tbx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Inye seivma tiwei limvey gyeik xel tuw e lek xax pepeeng o. ");
INSERT INTO tbx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Qayeeng wei xel byex bei bong qayeeng en e yo eno pyaweing ambei nye: KING WEI YUDAYEIW O. ");
INSERT INTO tbx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xel tuw panaxeing yayuw lek xax pepeeng is e, nge wou mema payeiv de nge wou mema qeinz. ");
INSERT INTO tbx_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Me xoulek wei Anutu wei di yeip eivek qapiya eno wo neing lek en ingwei neil embei, “Me xel yei e nambei tambiy wei mi pyalek petieing o.” ");
INSERT INTO tbx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Xel eti yeiw wei di lam me la paviy e eno lukyak lek e, de xel bimexe lund, “Ei! Wa tambiy tiwei tyek lelolexe xomek vambuing ne dom ghe dev eivek bouk yal. ");
INSERT INTO tbx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Woyom wa devind xow me tei lam veil xax pepeeng de wa se mey!” ");
INSERT INTO tbx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Eivek sakwaing ambei nyon eno xel lumuki leitata me putoung wei petieing o eno lukyak lek e eivek xel venaxow senghoing. Xel neil, “E vind xel valu me xel se mey ekom moxo se teyeimbei devind venaxow is ambei nyon! ");
INSERT INTO tbx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Wangwei e Kilisi, me King wei Israel o, ond wong e tei lam gweimbeeng veil xax pepeeng, en kandek xa ghei me na bongis o.” Luyuw wei xel tuw is e eno lukyak lek e is. ");
INSERT INTO tbx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Lek seivma evlek eno mapetok sevunexe tembuing sapa me ela seivma yal. ");
INSERT INTO tbx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","De lek seivma yal eno Yesu nyayek niseikeing me neil, “Eloi, Eloi, lama sabaktani?” Qes ambei nye, “A xe Anutu, a xe Anutu, nambei nya wang saing ay?” ");
INSERT INTO tbx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Gyeik xel valu wei toukale paviyeing eno ngo tine, om xel neil, “Ngo, moxo taxe Eliya yo.” ");
INSERT INTO tbx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tambiy ti veimya me la qou wain senyeing pup eivek balam, me toung lek lengwes de wong ela wou Yesu bei e num. Moxo neil, “Gweimbeeng wong e venaxow toundei. Me xey a xei bei Eliya nam zewax e detei nam.” ");
INSERT INTO tbx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","De woyom Yesu nyayek ngandoung dom mey. ");
INSERT INTO tbx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Qaeing wei xomek vambuing eno lex eivek masenghoing me la yayuw nanghei pu me elam axo myasepu yang. ");
INSERT INTO tbx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Me gyeik beyeiv wei xel vevek eno toungale wou Yesu manghalus me yei Yesu mey ambei nya yo eno neil, “Neing ayang moux tine inye Anutu Neu Moux!” ");
INSERT INTO tbx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Vex valu di yei nanghei dingta. Eivek xel senghoing eno inyon Maria wei Makdala, Maria wei Jems ghavis on ta me Joses, me Salome. ");
INSERT INTO tbx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Eivek Galili eno vex ti beimambei ne mi betiwou e me yeiteyei e en vineing. Vex ngenong valu wei lam apune is e me la Yerusalem eno toundei nanghei inyon is. ");
INSERT INTO tbx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","De inye souk me bouk wei xel embei menyexwou lulul wei Sabat o me bouk ne la tax en Sabat. ");
INSERT INTO tbx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Nambei nyon Yosep wei Arimatia, tambiy yon lei nimza wei kanzol o, wei emaxow mi axe tete lalei wei Anutu yo eno se yaleeng, qe la nale wou Pailat ma me teling en Yesu neing. ");
INSERT INTO tbx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat etek en ngo bei Yesu mey woy, om taxe beyeiv wei xel vevek o me teling e, “Wangwei bei Yesu mey woy?” ");
INSERT INTO tbx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Gyeik Pailat ngo wou beyeiv wei xel vevek bei Yesu mey eno moxo lenghek lek Yesu neing wou Yosep. ");
INSERT INTO tbx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Om Yosep xouv qaeing teleing valu, dom zewax Yesu neing tei lam, me vevilexe eivek qaeing pus dom liw e la eivek leiveeng wei xel qateiv eivek qakous o. Woyom wilexe qakous la zeyi leiveeng mya. ");
INSERT INTO tbx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria wei Makdala me Maria wei Joses ta eno yei ingwei e yeip anghei yo. ");
INSERT INTO tbx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gyeik Sabat la veil, Maria wei Makdala, Maria wei Jems ta, me Salome lal xouv lulul wei xeimangou yo valu is wel en kandek lal na taw lek Yesu neing. ");
INSERT INTO tbx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Satiboukeing lul lek bouk tiwei tax o eivek Sounda tiyon, ka sayeiv lam tyip le, eno lal la ingwei leiveeng meyeing nei. ");
INSERT INTO tbx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Me lal teling wouma, “Eti tyek gwilexe qakous veil leiveeng meyeing mya en ghal?” ");
INSERT INTO tbx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ekom gyeik lal yeila punei, lal yei bei qakous wei wilexe me la toungale yon inyei ngandoungateiv. ");
INSERT INTO tbx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ka lal la eivek leiveeng meyeing lalei, lal yei tambiy ghavis ti, vunek en teimb ding wei teleing o ti me toundei wou mema payeiv om lal etek. ");
INSERT INTO tbx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Om moxo neil, “Mal seng detek en inye mal ghe di wimexe Yesu wei Nasaret o, tiwei xel leis lek xax pepeeng o. Moxo qandi lek! Moxo se toundei inye. Mal lam wei beeng wei xel liw e lek o. ");
INSERT INTO tbx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Dom mal la neil wou e xe xel betiyeing me Petele bei, ‘Moxo la tax en xam me la Galili. Tyek xam ghe gwei e nanghei inyei, nambei kawei neil wou xam o.’ ” ");
INSERT INTO tbx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Xel vex la myayaing de pek me la veil leiveeng meyeing, is etekeing me woueing nalei ngenong, om xel se neil qayeeng en lulti wou xelti, en nambei xel yaleeng. ");
INSERT INTO tbx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Gyeik Yesu qandi lek Sounda satiboukeing lul lek bouk ti tax o, moxo la tyip atax wou Maria wei Makdala, tiwei e tiy memo lim yuw veil e yo. ");
INSERT INTO tbx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Vexo la me neil wou xel wei mi la is e yo, me eti yeiw wei di wo talot me eng o. ");
INSERT INTO tbx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Gyeik xel ngo bei Yesu toundei mapieing me vex on yei e, eno xel se wongis. ");
INSERT INTO tbx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Dekalekom Yesu lam tyip wou luw yayuw wei xel o, ekom wo bange om luw se woulek, gyeik ingwei luw di la wou sakwaing me la beyeeng nayak nei. ");
INSERT INTO tbx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Luw lox me la me neil wou xel betiyeing valu, ekom xel se wongis luw. ");
INSERT INTO tbx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kalekom Yesu la tyip wou xel betiyeing xoumeeng ti gyeik xel toundei me di ya yo, moxo luk niseikeing wou xel en xel se wongis me xel wei laleind wo nikanzek en nambei xel embei se bongis eti yeiw wei yei e yo, gyeik ingwei e qandi lek o. ");
INSERT INTO tbx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Moxo neil wou xel, “Xam la eivek tembuing sapa nei me neil Xoulek Nimza wou xomaxoneing dalus. ");
INSERT INTO tbx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xel tiwei wongis me lipek eno tyek Anutu devind xel en xel se mey, ekom eti yeiw wei se wongis eno tyek na qou myaveweeng gyeik ingwei xel bo qayeeng o. ");
INSERT INTO tbx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Me dee beimambei ne tyek na is eti yeiw wei wongis o. Eivek a leing eno tyek xel a tiy memo na myayaing, de tyek xel baluk eivek vya vako. ");
INSERT INTO tbx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Tyek xel a zeim myeiy angya memend me gyeik xel anum lul wei wevek eno tyek se bo nol wou xelti, tyek xel a niw memend lek xel wei vanei yo, dom tyek xel bo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ka Tambiy Ngandoung Yesu luk is xel woy, woyom Anutu qou e me la ghey eivek tyoung gheyapu me e la dei wou Anutu mema payeiv. ");
INSERT INTO tbx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Woyom xel betiyeing la myayaing me neil xoulek la danghei danghei nei, me Tambiy Ngandoung wo xuk is xel, me byexaxoun e xe qayeeng nangya dee wei di betiwou xuk on.");
INSERT INTO tbx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O lei ngandoung Tiopilas, xel ngenong mi byex pavulek lek vatiyeiw wei Anutu wong ela teyei lek eivek xa senghoing o. ");
INSERT INTO tbx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Xel betiwou eti yeiw wei yei lulul on lek mend atax, gyeik ingwei lulul on qandi lek o. Me xel on xukxe wei Anutu xe xoulek o. Om xel tul pavulek on wou xa. ");
INSERT INTO tbx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Om ay is ambei nyon ambei byex pavulek on me na bong e nak wou wang. A mi wong xuk endenlek telinyeing lulul on qes wo nimza, om a byex ela teyei lek ingwei lulul on qandi yo. ");
INSERT INTO tbx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Wa pyaw dom ghe boulek embo nimza bei qayeeng wei xel teyoxe wou wang on neing ayang. ");
INSERT INTO tbx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Eivek bouk wei Herot king wei Yudia eno lumuki ti mindei e lei Sakalias, e eivek qendu tiwei Abiya yo. Moxo venei Elisabet yon eivek velei wei Aron o. ");
INSERT INTO tbx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Luw xouing mindei ewo bombek wou Anutu manghalus. Me luw mi betiwou Tambiy Ngandoung xe petieing dalus me xoulek dalus, me sewokeing ma veil luw. ");
INSERT INTO tbx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ekom luw neund ma, en Elisabet mi mouyeeng me luw wo teiv aluw vexta. ");
INSERT INTO tbx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Bouk ti gyeik Sakalias xe lumukiyeiw qendu tiyon la wong xuk, eno moxo la wong xuk lumuki wou Anutu manghalus is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Om xel betiwou lumukiyeiw xe kwa wei xel mi nex qakous dee me beyal e, bei ena lalei eivek Tambiy Ngandoung xe xomek vambuing me na besei da wei xeiliy. ");
INSERT INTO tbx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Gyeik bouk wei seing xound xeiliy eno lam tyip, xel dalusateiv di qekuma nanghei Anutu beeng me zeimemend anghei myayaing. ");
INSERT INTO tbx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Woyom Tambiy Ngandoung xe angela ti lam nale wou e, moxo nale wou qeind wei seing xound xeiliy eno nenya valu wei payeiv o. ");
INSERT INTO tbx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Gyeik Sakalias yei angela, eno etek me yaleeng. ");
INSERT INTO tbx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ekom angela neil wou e, “Sakalias wa seng gwaleeng, en Anutu ngo wa xe zeimeing mema. Om veneim Elisabet tyek bou neum moux ti, me tyek wa taxe e lei Yoan. ");
INSERT INTO tbx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Tyek wang bo xeimlala ngandoung me laleim bo nimza. Me xel ngenong tyek bo xeindlala en e xe umbekeing, ");
INSERT INTO tbx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","en moxo tyek bo lei ngandoung wou Tambiy Ngandoung manghalus. Moxo e se num wain o memiing wei nikanzek o. De gyeik ingwei toukami eivek ta veis eno na pup en Laweeng Vambuing. ");
INSERT INTO tbx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Moxo tyek na qou xel Israelyeiw ngenongakes me noumenam wou Tambiy Ngandoung xel xe Anutu. ");
INSERT INTO tbx_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Moxo tyek na qou nikanzek wei Laweeng Vambuing o nambei Eliya wei takwei yo me natax en Tambiy Ngandoung. Moxo tyek bong mayeiw laleind pekwi nox wou neuyeiw. Me moxo tyek pepyawexe xel wei mi pyalek qayeeng o me xel a qou lupeyei nimza nambei xel wei mi betiwou sakwaing bombek o. Moxo tyek menyex wou xomaxoneing en xel gyeiwou xow en Tambiy Ngandoung nam o.” ");
INSERT INTO tbx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sakalias teling angela bei, “Tyek a boulek inyon ambei nya? A wo teiv takwei me a veneing wo vexta is ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angela lewexe bei, “A Gabriel. A mi nale wou Anutu manghalus, om wong a lam a luk is wang me na neil wou wang en xoulek nimza tine. ");
INSERT INTO tbx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Om ngo, gweimbeeng kane wa myam tyek na tu me tyek wa se teyei bei baluk, qe ka bouk wei lulti yon neing etyip bole en wa seng wongis a xe qayeeng. Lulti yon tyek bo neing lek e xe bouk bombek.” ");
INSERT INTO tbx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Dekalekom xomaxoneing di axe Sakalias me di wou naleind bei nambei nya ekom dei enden eivek xomek vambuing. ");
INSERT INTO tbx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Gyeik ingwei moxo lam myayaing, eno moxo se teyeimbei baluk wou xel. Om xel woulek bei mapekwi me yei lulti eivek xomek vambuing, en mi talex lulul angya mema wou xel en se teyeimbei baluk. ");
INSERT INTO tbx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Gyeik bouk wei moxo xe xuk la wou eivek, moxo lox me la beeng. ");
INSERT INTO tbx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kalekom venei Elisabet xei qou veil me e mindei xupekeing teyei lek dentouk qes lim. ");
INSERT INTO tbx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Vexo neil embei, “Tambiy Ngandoung wong tine wou ay eivek bouk ti beimambei ne, moxo talex e xe lalei nimza me zeim a xe niyalenyeing veil eivek xomaxoneing senghoing.” ");
INSERT INTO tbx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Eivek dentouk tiwei limti eno Anutu wong angela Gabriel la Nasaret inyei beyeeng ti eivek Galili. ");
INSERT INTO tbx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","La wou vexawo wei paleveeng o ti wei xel tup qayeeng lekti bei e na wou moux ti e lei Yosep bei e dii, inyon Dawit buyeiw ti. Vexawo paleveeng on lei Maria. ");
INSERT INTO tbx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","De angela la wou vexo me neil embei, “Bendiyeing vex, Anutu lalei wo nimza wou wang. Tambiy Ngandoung e toumendei is wang.” ");
INSERT INTO tbx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria lalei wo maying en e xe qayeeng me wounalei bei, “Qayeeng tine inye nambei nya?” ");
INSERT INTO tbx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ekom angela neil wou vexo bei, “Maria, wa seng gwaleeng, en Anutu lalei wo nimza wou wang. ");
INSERT INTO tbx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wei, tyek wa xeim a qou veil me wang bou neum moux ti, me wa taxe e lei Yesu. ");
INSERT INTO tbx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tyek moxo bo lei ngandoung me tyek xel a neimbei Anutu gheyapu neu moux. De Tambiy Ngandoung Anutu tyek bong siaking wei bu Dawit xe eno wou e. ");
INSERT INTO tbx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Me tyek mendei king en xomek wei Yakop o luta, e xe tete lalei tyek se tip.” ");
INSERT INTO tbx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria teling wou angela bei, “Ekom inyon tyek bong ambei nya, inye a paleveeng o?” ");
INSERT INTO tbx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angela lewexe, “Laweeng Vambuing tyek nam wou wang me Anutu gheyapu xe nikanzek tyek bo tenu zeyi wang. Om yakyeis tiwei wa being bou yon vambuing, me tyek xel a neimbei inyon Anutu Neu Moux. ");
INSERT INTO tbx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Me gweimbeeng nimpapu Elisabet tyek bou neu moux ti eivek ingwei wo vexta yo. Takwei eno xel mi neil embei mi mouyeeng ekom wo neu me dentouk qes limti la veil. ");
INSERT INTO tbx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","En lulti tyek se bo pok wou Anutu.” ");
INSERT INTO tbx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria lewexe, “Ee, a Tambiy Ngandoung xe xukxe vexawo, om e bong wou ay ambei ingwei wang neil on.” Woyom angela la veil e. ");
INSERT INTO tbx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Lek bouk kayon eno Maria yeiwou xow me la daing eivek beyeeng ti lek lukendu wei Yudia nei. ");
INSERT INTO tbx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","De vexo la eivek Sakalias beeng me la neil bendiyeing wou Elisabet. ");
INSERT INTO tbx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Gyeik ingwei Elisabet ngo Maria xe bendiyeing, eno neu vyeip eivek e veis. De Laweeng Vambuing pup Elisabet. ");
INSERT INTO tbx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Om taxe xoulekeing me neil embei: “Anutu wo mata ghanaw veil wou wang eivek vex vex senghoing, me wo mata wou yakyeis tiwei wa being bou yon! ");
INSERT INTO tbx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ekom ay eti om lalei nimza lam wou ay? Me a xe Tambiy Ngandoung ta lam wou ay? ");
INSERT INTO tbx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wei, gyeik ingwei a nenyang ngo wa xe bendiyeing, eno yakyeis wei tumi eivek a veis eno wo xeilala me vyeip. ");
INSERT INTO tbx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nimza e na wou vex wei mi wongis bei vati wei Tambiy Ngandoung neil wou e, eno tyek bo neing lek!” ");
INSERT INTO tbx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Me Maria neil ambei nye: “A nung pieing e sanghoxe Tambiy Ngandoung ");
INSERT INTO tbx_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","me axe laweeng wo xeilala en Anutu, en e axe vineing, ");
INSERT INTO tbx_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","en ay eno e xe xukxe vexawo wei lei maeing ekom yei ay me lalei pyaxow en ay. Om ngo, gweimbeeng me e mi na eno moux alis vex dalus tyek na mi taxe bei Anutu wong mata wou ay. ");
INSERT INTO tbx_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","En tambiy nikanzekta ti wong lul ngandoung tine wou ay, e lei yon vambuing. ");
INSERT INTO tbx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","E lalei mi pyaxow en moux alis vex wei mi yaleeng en e yo, tyek bong ambei nyon wou moux alis vex wei gweimbeeng ne yo, me moux alis vex wei yusyus o. ");
INSERT INTO tbx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E mema wong xuk wei nikanzek o, xel wei mi wou naleind en xow me toxleind eno tiy xel la danghei danghei nei. ");
INSERT INTO tbx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Moxo toung mema lek xel king lox nge xo veil xel xe siaking de zeim xel wei leind maeing eno lek la. ");
INSERT INTO tbx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Moxo wong lul nimzamza ngenong pup wou xel wei maxepya xel o, dom wong xel wei lulul ana eno la bandaing. ");
INSERT INTO tbx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Moxo vind e xe xukxeyeiw wei Israel o, en mi wounalei en e xe lalei pyaweingxow, ");
INSERT INTO tbx_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","wei wong wou Apraham me e neumambu takwei takwei, nambei ingwei e neil wou xey mendyeiw o.” ");
INSERT INTO tbx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria la dei is Elisabet teyei lek dentouk qes yayal o xelti, dekakom lox me la beeng. ");
INSERT INTO tbx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Gyeik bouk la wou eivek ingwei Elisabet embei bou neu yo, om vexo wou neu moux ti. ");
INSERT INTO tbx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Xel wei Elisabet beeng qes o me nipapu wei toundei paviy e eno ngo ingwei Tambiy Ngandoung lalei pyaxow ngandoung en e yo, om xel wo xeindlala is e. ");
INSERT INTO tbx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lek bouk lim yal eno xel lam en xel embei ghuw yak on ninavi. Me xel embei taxe e lei Sakalias, nambei ma lei. ");
INSERT INTO tbx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ekom ta luk me neil embei, “Ma! Tyek xey a taxe e lei Yoan.” ");
INSERT INTO tbx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Xel neil wou vexo, “Eivek xel wei wang eno senghoing xelti se lei nambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Woyom xel talex lek memend wou ma, me xel teling ma bei, moxo embei taxe neu lei va. ");
INSERT INTO tbx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Moxo teling wou xel en tapele, me moxo byex qayeeng bei, “E lei Yoan.” Om xel di wou naleind ngenong. ");
INSERT INTO tbx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Lutika eno Sakalias mya tax, me e ghas vevop me e luk me sanghoxe Anutu. ");
INSERT INTO tbx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Xel wei e beeng qes on yei lulti yon om xel etek me luk ngenong en, de eivek xel beyeeng lukendu wei Yudia nei eno xel tul pavulek en lulti beimambei ne dalus. ");
INSERT INTO tbx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Xel sapa wei ngo pavulek eno xel wou naleind ngenong me teling bei, “Bouk loxyus eno yak tine tyek bong nambei nya?” En Tambiy Ngandoung mema nikanzek toundei is e. ");
INSERT INTO tbx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Moxo ma Sakalias pup en Laweeng Vambuing me neil qayeeng poropet bei: ");
INSERT INTO tbx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Xey a sanghoxe Tambiy Ngandoung, Israel xe Anutu, en lam tul xe xomaxoneing veil nilul. ");
INSERT INTO tbx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Moxo wong tambiy nikanzeta wei vind xey veil nilul eno ti qandi eivek xomek wei e xe xukxe Dawit o, ");
INSERT INTO tbx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","(nambei ingwei e neil eivek e xe xel poropet vambuing myend takwei nei yo), ");
INSERT INTO tbx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Neil embei tyek devind xe veil xel vevek ba memend me xel wei mi yei xey a wo nol o memend is, ");
INSERT INTO tbx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","de talex e xe lalei pyaweingxow wou xe bundyeiw me mi wounalei en e xe qayeeng vambuing wei qokatu yo, ");
INSERT INTO tbx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","de qayeeng zonghek wei neil neing wou xe bund Apraham o: ");
INSERT INTO tbx_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","bei na zeim xe veil xe xe xel vevek ba memend, me bong xey a mi bong e xe xuk de xe se ghaleeng. ");
INSERT INTO tbx_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Eivek bouk sapa wei xey a mindei mapieing eno xey a mi betiwou kwa wei vambuing o, me sakwaing bombek wou e manghalus. ");
INSERT INTO tbx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“De wang, a neung, tyek xel taxe bei wa poropet wei Anutu gheyapu nei yo. En tyek wang natax en Tambiy Ngandoung me menyex wou sakwaing en e, ");
INSERT INTO tbx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","de ghe bong lupeyei wou e xe xomaxoneing en ingwei embei devind xel veil nilul me semaleeng sewokeing wei xel o, ");
INSERT INTO tbx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","en nambei xe xe Anutu lalei pyaxow wo nimzayang en xey, om wong xeiyaing ti lam nambei sayeiv qandi me lam wou xey nanghei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","En enam a siing lek xel wei mindei eivek mapetok ngandoung o, me mindei eivek yalenyeing en meyeing o. De gyeiteyei xe vaxend en xey a betiwou sakwaing wei lalei vevopeing o.” ");
INSERT INTO tbx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Me yak moxo wo teiv me Anutu xe Laweeng wong nikanzek wou e me moxo la mindei eivek tembuing bandaing, deka bouk la wou eivek woyom la talex xow wou Israelyeiw. ");
INSERT INTO tbx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Eivek bouk tiyon eno Sisa Ogastus king wei ngandoung o wong petieing ti la me neil embei xel a qou moux alis vex dalus wei tembuing sapa wei dei xeinghembi eivek Rom eno leind eivek qapiya. ");
INSERT INTO tbx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","(Inye myaxeeng selis wei xel qou xel leind gyeik ingwei Kwirinius wo lei ngandoung wei seyap wei Siria yo.) ");
INSERT INTO tbx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Me xel dalusateiv la venaxow bend qes bei seyap a qou xel leind. ");
INSERT INTO tbx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosep on neumambu wei king Dawit o. Om la veil beyeeng Nasaret eivek Galili, me lek me la Yudia, la Dawit beeng wei Betelem o. ");
INSERT INTO tbx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Moxo la inyei is Maria wei xel tup qayeeng lekti bei e mendei wou e yo bei seyap a qou luw leind, gyeik inyon eno Maria xei qou veil. ");
INSERT INTO tbx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ka luw la toundei inyei, eno bouk la wou eivek ingwei yakyeis on embei dumbek o. ");
INSERT INTO tbx_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Om vexo wou neu touk, me beliv e eivek qaeing me liw eivek manghaxo xe dipek, en xomek wei vateivek o pup zeyi xel. ");
INSERT INTO tbx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Me nanghei inyei eno xel gyovaxa wei sipsip eno valu toundei myayaing veil beyeeng, me di yeiteyei xel xe sipsip qendu ngandoung on eivek boukeing tiyon. ");
INSERT INTO tbx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Dekakom Tambiy Ngandoung xe angela ti lam wou xel, me Tambiy Ngandoung xe xeiyaing ngandoung lam siing e vivekwou xel, om xel yaleeng ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ekom angela neil wou xel bei, “Xam seng gwaleeng. En a qou xoulek nimza me na lam wou xam, bei embong xomaxoneing dalus bo xeindlala ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gweimbeeng kane eivek beyeeng nayak wei Dawit xe eno tambiy tiwei qou xam ghe lam veil nilul eno umbek en xam. E Kilisi me Tambiy Ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Tyek xam ghe boulek dee nambei nye: Tyek xam ghe gwei yakyeis ti xel beliv eivek vetivek mati me liw eivek manghaxo xe dipek.” ");
INSERT INTO tbx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","De lutika eno angela ngenongakes wei tyoung gheyapu eno lam is angela tiyon, me xel sanghoxe Anutu me neil embei, ");
INSERT INTO tbx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Xey a sanghoxe Anutu lei na gheyapu nei, de nanghei tembuing eno xomaxoneing wei Anutu lalei wo nimza wou xel eno na mi mendei is laleind vevopeing.” ");
INSERT INTO tbx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Gyeik ingwei xel angela lox veil xel me la eivek tyoung gheyapu nei, eno xel gyovaxa wei sipsip o neil wouma bei, “Xey a la Betelem me na xei lul tiwei qandi nei, wei Tambiy Ngandoung neil wou xey en o.” ");
INSERT INTO tbx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Om xel la daing me la yeiwou Maria luw Yosep, me yakyeis wei di yeip eivek manghaxo xe dipek o. ");
INSERT INTO tbx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Gyeik ingwei xel yei e, eno xel neil qayeeng la wo sapa en vatiyeiw wei angela neil wou xel en yakyeis tiyon o. ");
INSERT INTO tbx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Me xel dalus wei ngo inye, eno etek en vati wei xel gyovaxa wei sipsip o neil wou xel o. ");
INSERT INTO tbx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ekom Maria mi zeimaxoun qayeeng ti beimambei yon dalus eivek lalei me mi wounalei en. ");
INSERT INTO tbx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Xel gyovaxa wei sipsip eno lox me la me di sanghoxe Anutu me wong xeindlala en lulul dalus wei xel ngo me yei yo. Nambei kawei angela neil wou xel o. ");
INSERT INTO tbx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Lek bouk lim yal, gyeik bouk wei xel embei ghuw yak on ninavi me taxe e lei Yesu. Lei yon angela wong gyeik ingwei se ghei mi eivek ta veis o. ");
INSERT INTO tbx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Gyeik bouk lam tyip en ingwei yeing wou xow bo vako wou Anutu manghalus teyei lek Mose xe petieing eno la wou eivek, om Yosep aluw Maria qou Yesu me la Yerusalem en embei na bong e na wou Tambiy Ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Inyon nambei xel byex eivek Tambiy Ngandoung xe petieing, “Xel yak moux sapa wei umbek atax eno xam ghe bong ena nambei vambuing wou Tambiy Ngandoung nambei e xe.” ");
INSERT INTO tbx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Me luw la sei xound nambei vati wei xel neil eivek Tambiy Ngandoung xe petieing o, “beliy yayuw o banax lingheing yayuw.” ");
INSERT INTO tbx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gweimbeeng eivek Yerusalem eno tambiy ti mindei e lei Simion, tambiy on mindei bombek me mi wong lalo. Moxo mi axe ingwei Mesia embei bong lalei vevopeing wou Israel o, me Laweeng Vambuing mindei eivek e. ");
INSERT INTO tbx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Laweeng Vambuing talex wou e bei, tyek se mey qe ka gyei Tambiy Ngandoung xe Kilisi bole. ");
INSERT INTO tbx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Laweeng Vambuing zeim e lalei lek, me e la eivek tete lalei wei xomek vambuing, de Yesu ma luw ta qou e me la en embei na bong vati wou e nambei kwa wei petieing neil o. ");
INSERT INTO tbx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Me Simion qava e me sanghoxe Anutu me neil: ");
INSERT INTO tbx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Tambiy Ngandoung, wei ghanaw veil, nambei ingwei wang neil zonghek o, wang bong wa xe xukxe na mey eivek lalei vevopeing. ");
INSERT INTO tbx_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","En a manghalus yei wa xe tambiy wei embei devind xa veil nilul o, ");
INSERT INTO tbx_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","wei wang xupexe inye wou xomaxoneing dalus mend o. ");
INSERT INTO tbx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","E xeiyaing tiwei embei talex enam yanyateiv wou xel amba de bong wa xe xel Israel leind zekna.” ");
INSERT INTO tbx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Yesu ma luw ta etek en qayeeng vati wei neil lek e yo. ");
INSERT INTO tbx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Woyom Simion wo mata wou lal me neil wou moxo ta Maria, “Yakyeis tine nambei beyaleing wei tyek bong xel ngenong detei de xel ngenong qandi lek eivek Israel, me tyek mendei nambei dee ti, wei xel ngenong tyek bo vyend wou e yo. ");
INSERT INTO tbx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","En kandek xel ngenong xe laleind peyei eno tyek nam yanyateiv. De ngeyeing vevek ti tyek beum wamaxow num pieing is.” ");
INSERT INTO tbx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nanghei inyon eno poropet vex ti e lei Ana, Penuel neu vex eivek velei wei Asal o. Vexo wo vexta, vexo mindei is leya teyei lek vakovek qes lim yuw takwei gyeik ingwei luw iima yo. ");
INSERT INTO tbx_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","De woyom wo vexeiv teyei lek 84 vakovek qes. Vexo se mindei veil xomek vambuing qe mi wong lalo boukeing aluw bendiyeing, me mi vambu yaeing de mi zeimema. ");
INSERT INTO tbx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Lek bouk kayon eno la paviy xel me wong dange wou Anutu me luk en yakyeis on wou xel dalus wei mi toung mend en ingwei Anutu embei tul xel Yerusalem veil nilul o. ");
INSERT INTO tbx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Gyeik ingwei Yosep me Maria wong lulul dalus la teyei lek petieing wei Tambiy Ngandoung xe yo, luw lox Galili me lox me la luw venaxow xe beyeeng nayak Nasaret. ");
INSERT INTO tbx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Me yakyeis on wo teiv me wo nikanzek. Moxo pup en lupeyei nimza me Anutu xe lalei xeiles toundei eivek e. ");
INSERT INTO tbx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Teyei lek vakovek qes sapa eno moxo ma luw ta mi la Yerusalem en embei na gyei mata ngandoung wei Pasova yo. ");
INSERT INTO tbx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Gyeik Yesu xe vakovek qes xoumeeng yuw, eno xel betiwou xel xe kwa me lek me la yei mata ngandoung wei Pasova yon. ");
INSERT INTO tbx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ka bouk ngandoung wei mata dalus la veil, eno ma luw ta lox me la bend, de Yesu nanghei toundei Yerusalem, ekom luw se woulek inye. ");
INSERT INTO tbx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Luw wou naleind bei la is moux alis vex valu, xel la e teyei lek bouk ti, woyom luw yimexe e eivek nipapu me luw xe gweleeng senghoing. ");
INSERT INTO tbx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Gyeik ingwei luw se yeiwou e, luw lox me la Yerusalem en embei nox gyimexe e. ");
INSERT INTO tbx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ka bouk yayal la veil eno luw yeiwou e nanghei tete lalei wei xomek vambuing o, toundei eivek xel putoung senghoing, di ngo xel me di wo telinyeing wou xel. ");
INSERT INTO tbx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Xel sapa wei ngo e xe qayeeng eno etek en e xe lupeyei me qayeeng bombek wei di neil elox o. ");
INSERT INTO tbx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Gyeik ingwei ma luw ta yei e, eno luw etek. Moxo ta neil wou e bei, “Touk, nambei nya wang wong ambei nyon wou uw? Uw mam laleimi wo maying en wang om uw a mi ximexe wang.” ");
INSERT INTO tbx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Moxo teling wou luw, “Nambei nya muw ghe mi wimexe ay? Muw seng woulek bei a toundei eivek mang beeng?” ");
INSERT INTO tbx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ekom luw se woulek vati wei di neil wou luw o. ");
INSERT INTO tbx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Woyom lep me la xo Nasaret nei is luw me mi betiwou luw xe qayeeng. Ekom moxo ta mi toung lulti beimambei yon dalus eivek lalei me mi wounalei en. ");
INSERT INTO tbx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Me Yesu wo teiv is lupeyei nimza, me Anutu lalei wo nimza wou e me moux alis vex laleind wo nimza wou e is. ");
INSERT INTO tbx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Eivek vakovek qes 15 wei Sisa Taibilias wo king wei Rom gyeik Pontias Pailat wo lei ngandoung wei seyap wei distrik Yudia yo de Herot yeiteyei distrik Galili dom li Pilip yeiteyei distrik Itulia me Tlakonaitis, de Lisanias yeiteyei distrik Abilini. ");
INSERT INTO tbx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Gyeik ingwei Anas aluw Kaiapas wo lumuki lukanzek eno Anutu xe qayeeng lam wou Yoan wei Sakalias neu yo eivek tembuing bandaing. ");
INSERT INTO tbx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Woyom moxo la eivek tembuing danghei dalus wei toundei memiing Yorodan vivi yo, me la neil xoulek wou moux alis vex bei xel pekwi xow me zipek, en kandek Anutu semaleeng xel xe sewokeing veil. ");
INSERT INTO tbx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Lulti yon qandi nambei poropet Yesaya byex eivek qapiya yo, “Vya taxeing ti lam eivek tembuing bandaing bei, ‘Xam menyex wou sakwaing en Tambiy Ngandoung, xam ghe bong sakwaing embo bombek en e. ");
INSERT INTO tbx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Xam samax manya dalus e pup me qandax lukendu is qetyei dalus e deteina. Sakwaing dalus wei wo xeighekeing eno embo bombek, me sakwaing wei wo nol eno embo belin. ");
INSERT INTO tbx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Me xel xomaxoneing dalus tyek gyei Anutu xe sakwaing wei vind xomaxoneing veil nilul o.’” ");
INSERT INTO tbx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yoan neil wou xel qendu ngandoung wei lam bei e zipek xel o, “Xam on myeiy nilul neu xam. Eti peti xam bei tyek xam a pek veil Anutu xe lalei vanei? ");
INSERT INTO tbx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Xam ghe buk neing me talex bei xam ghe pekwi xow, me xam se neil wou ma bei xa bumi Apraham. En a neil wou xam bei, Anutu teyeimbei neil me qakous ti beimambei ne bong ambei Apraham neuyeiw. ");
INSERT INTO tbx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Qov di yeip woy wou xax qes, me xax dalus wei se vuk neing nimza, eno tyek buv veil de banex ena eivek nenyex.” ");
INSERT INTO tbx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Xel moux alis vex ngenong teling bei, “Om tyek xa bong ambei nya?” ");
INSERT INTO tbx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Om Yoan neil elox wou xel bei, “Tambiy ti xe teimb yayuw toundei ond e bong nge wou tambiy wei ning teimb ma yo, de xelti xe yaeing toundei wou e ond e bong ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xel wei mi qou takis, eno valu lam is ambei nyon en embei nam zipek, om xel teling wou bei, “Putoung, tyek xa bong ambei nya?” ");
INSERT INTO tbx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Moxo neil wou xel bei, “Xam a qou takis teyei lek ingwei seyap toung o, de xam se qou e zekna.” ");
INSERT INTO tbx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Woyom xel vevek valu teling wou bei, “Dom xa ne bong ambei nya?” Moxo neil elox wou xel bei, “Xam seng bo nol wou xomaxoneing me panax xel xe malew. Me na byex qayeeng tyonyeing lek xomaxoneing en xel xe malew. Qe xam ghe bou naleimim bei malew wei xam ghe mi qou en xuk on teyei woy.” ");
INSERT INTO tbx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Xel xomaxoneing wei mindei me axe lulti beimambei yon xel dalus di wou naleind ngenong bei, “Beip Yoan on Kilisi?” ");
INSERT INTO tbx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yoan lewexe wou xel dalus bei, “A lipek xam en memiing, ekom tambiy ti nikanzek ghanaw ay eno tyek nam, de a se nimza teyeimbei a tul yis veil e xe vaxalambes. Eno moxo tyek zipek xam en Laweeng Vambuing me nenyex is. ");
INSERT INTO tbx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Moxo zeim taliv eivek mema, en embei beyal wit neing veil myapapu, de qekuwou me na toung eivek xomek yaeing, ekom moxo tyek besei myapapu lek nenyex wei se mi mey yo.” ");
INSERT INTO tbx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yoan neil qayeeng valu wei embei byex xomaxoneing laleind o de neil Xoulek Nimza wou xel. ");
INSERT INTO tbx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ekom gyeik Yoan neil xel xe seyap Herot en sewokeing wei luw Herodias wei li venei yo, me kwa nilul dalus wei mi wong eno is. ");
INSERT INTO tbx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","De Herot tetulexe tine is nilul dalus wei mi wong o, dom toung Yoan la eivek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Gyeik ingwei xomaxoneing dalus di lipek, eno Yesu lipek is. Me ka e di zeimema, eno tyoung gheyapu tax. ");
INSERT INTO tbx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Me Laweeng Vambuing lep me lam wou e, nambei beliy me lam dei lek e. De vya ti lam anghei tyoung gheyapu nei: “Wang on a Neung moux, wei a laleing vind o, a wo xeinglala en wang.” ");
INSERT INTO tbx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu xe vakovek qes la tyip ambei xoumeeng yal (30) gyeik ingwei e wong e xe xuk a tax o. Moxo Yosep neu. Yosep on Heli neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","de Heli yon Matat neu, de Matat on Livai neu, de Livai yon Melki neu, de Melki yon Janai neu, de Janai yon Yosep neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","de Yosep on Matatias neu, de Matatias on Amos neu, de Amos on Nahum neu, de Nahum on Esli neu, de Esli yon Nagai neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","de Nagai yon Mat neu, de Mat on Matatias neu, de Matatias on Semen neu, de Semen on Josek neu, de Josek on Joda neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","de Joda yon Joanan neu, de Joanan on Resa neu, de Resa yon Serubabel neu, de Serubabel on Seatiel neu, de Seatiel on Neri neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","de Neri yon Melki neu, de Melki yon Adi neu, de Adi yon Kosam neu, de Kosam on Elmadam neu, de Elmadam on Er neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","de Er on Yosua neu, de Yosua yon Eliese neu, de Eliese on Jorim neu, de Jorim on Matat neu, de Matat on Livai neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","de Livai yon Simion neu, de Simion on Yuda neu, de Yuda yon Yosep neu, de Yosep on Jonam neu, de Jonam on Eliakim neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","de Eliakim on Melea neu, de Melea yon Mena neu, de Mena yon Matata neu, de Matata yon Natan neu, de Natan on Dawit neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","de Dawit on Jesi neu, de Jesi yon Obet neu, de Obet on Boas neu, de Boas on Salmon neu de Salmon on Nason neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","de Nason on Aminadap neu, de Aminadap on Atmin neu, de Atmin on Arni neu, de Arni yon Hesron neu, de Hesron on Peres neu, de Peres on Yuda neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","de Yuda yon Yakop neu, de Yakop on Isaka neu, de Isaka yon Apraham neu, de Apraham on Tera neu, de Tera yon Nahor neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","de Nahor on Seruk neu, de Seruk on Reu neu, de Reu yon Pelek neu, de Pelek on Eber neu, de Eber on Sela neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","de Sela yon Kainan neu, de Kainan on Apaksat neu, de Apaksat on Sem neu, de Sem on Noaka neu, de Noaka yon Lamek neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","de Lamek on Metusela neu, de Metusela yon Inok neu, de Inok on Zaret neu, de Zaret on Mahalalel neu, de Mahalalel on Kenan neu, ");
INSERT INTO tbx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","de Kenan on Enos neu, de Enos on Set neu, de Set on Adam neu, de Adam on Anutu neu moux. ");
INSERT INTO tbx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu pup en Laweeng Vambuing, om loumelam anghei memiing Yorodan me Laweeng Vambuing qou e me la tembuing bandaing, ");
INSERT INTO tbx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","teyei lek bouk xoumeeng vey (40) eno tambiy mapetok wo axeing wou e. Moxo se ya bambou lek bouk ti beimambei yon, me lek bouk tiwei la tip lek eno maxepya e. ");
INSERT INTO tbx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Om tambiy mapetok neil wou e, “Wangwei wa Anutu Neu Moux nei, ond neil wou qakous tine en e pekwi me bo belet o.” ");
INSERT INTO tbx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu lewexe me neil embei, “Xel byex eivek xoulek eno nambei nye: ‘Xomaxoneing tyek se mendei mapieing en belet venaxow.’” ");
INSERT INTO tbx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tambiy mapetok qou e me lek me la lukendu vaxading ti me talex tete lalei dalus wei tembuing sapa eno daing wou e. ");
INSERT INTO tbx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Me neil wou e, “Tyek am bong lei ngandoung me vunekeing nimzamza ne wou wang, en inye toundei eivek a memang, me ambei bong wou xelti, ond tyek a bong wou e. ");
INSERT INTO tbx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Om wangwei wang bong lalo wou ay, ond tyek wa xe lulul ne dalus.” ");
INSERT INTO tbx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yesu lewexe bei, “Xel byex eivek xoulek eno nambei nye, ‘Wang bong lalo wou Tambiy Ngandoung wa xe Anutu me na mi bong emaxow xe xuk.’” ");
INSERT INTO tbx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Woyom tambiy mapetok qou e me la beyeeng Yerusalem me la lax lek xomek vambuing pundanghou nei. De neil wou e, “Wangwei wa Anutu Neu Moux nei ond wa tetoing anghei inye me ghe na xonei. ");
INSERT INTO tbx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","En xel byex eivek xoulek eno nambei nye, “‘Moxo tyek baluk nikanzek wou e xe angela en xel nam gyeiteyei wang bo nimza. ");
INSERT INTO tbx_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tyek xel a zeim wang zekna nangya memend en kandek wa seng nyeis vaxam lek qakous.’” ");
INSERT INTO tbx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu lewexe bei, “Xoulek neil ambei nye, ‘Wa se toung Tambiy Ngandoung wa xe Anutu eivek axeing.’” ");
INSERT INTO tbx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Gyeik ingwei tambiy mapetok wong axeing ti beimambei yon ma eno mema tena e de di axe deka bouk nge le. ");
INSERT INTO tbx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Laweeng Vambuing wong nikanzek wou Yesu me e lox me la Galili de pavulek wei e eno la teyei lek tembuing danghei tiyon dalus. ");
INSERT INTO tbx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Moxo mi teyoxe xoulek wou xel eivek xel xe xomek qekueing ama me moux alis vex sapa mi sanghoxe e lei. ");
INSERT INTO tbx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Moxo la beyeeng Nasaret, wei wo teiv lek o, de lek bouk wei Sabat eno la eivek xomek qekueing ama wei xel xe eno lalei nambei ingwei mi wong taxombouk o. Me moxo nale ghey en embei pyaw Anutu xe xoulek. ");
INSERT INTO tbx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Xel wong poropet Yesaya xe qapiya vambuing wei xel mi vevilexe lek xax eno wou e. Tul me yeiwou senghoing tiwei qayeeng di yeip lek o: ");
INSERT INTO tbx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tambiy Ngandoung xe Laweeng Vambuing lam dei lek ay en nambei e taw wel lek ay me beyal ay bei a neil Xoulek Nimza wou xel kanyo. Moxo wong a lam bei a nam a neilteyei wou xel wei la dei eivek xomek xeitueing o bei xel bong xel nam myayaing me na neil wou xel wei mend tekeing o bei xel mend gyeina me na bong xel wei xomaxoneing mi wo nol wou xel eno nam myayaing veil nimaying, ");
INSERT INTO tbx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","de na neil vakovek qes wei Tambiy Ngandoung embei bong lulul nimza wou moux alis vex eno teyei.” ");
INSERT INTO tbx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Woyom vevilexe qapiya me wong elox wou xukxe de dei tembuing. Xel wei toundei eivek xomek qekueing ama eno dalusateiv di yei e kanzek. ");
INSERT INTO tbx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Me mouk neil wou xel bei, “Gweimbeeng xoulek wei xam ghe ngo ne wo neing lek.” ");
INSERT INTO tbx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Xel dalus luk nimza en e, en qayeeng nimzamza wei di neil on om xel etek me teling bei, “Beip inye se Yosep neu ei?” ");
INSERT INTO tbx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu neil wou xel bei, “Neing ayang tyek xam a neil qayeeng pakeing tine wou ay: ‘Dokta wamaxow ghe bong xow bo nimzalek! Wang bong lulul vatiyeiw eivek wamaxow bam qes ne, nambei vatiyeiw wei xa ngo wang wong eivek beyeeng Kapenaom o.’” ");
INSERT INTO tbx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Moxo tetulexe qayeeng me neil, “A neil zonghek wou xam, xel xomaxoneing se mi lenghek lek poropet ti eivek emaxow beeng qes. ");
INSERT INTO tbx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","A neil neing wou xam no bei inye vexeiv ngenong toundei eivek Israel eivek bouk wei poropet Eliya yo, gyeik ingwei tyoung xey zeyi teyei lek vakovek qes yal me dentouk limti is me sewis wei maxep ngandoung yeip ela teyei lek tembuing tambak. ");
INSERT INTO tbx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ekom Anutu se wong Eliya la wou xel Israelyeiw on ti, qe wong e la wou vexeiv ti eivek beyeeng Sarepat eivek tembuing wei Saidon nei. ");
INSERT INTO tbx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Me inye moux alis vex ngenong toundei eivek Israel eno vanei lepa wong xel eivek bouk wei poropet Elisa yo, ekom xelti se wo nimzalek, qe Naimang wei Siria nei venaxow.” ");
INSERT INTO tbx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Xomaxoneing dalus wei toundei eivek xomek qekueing ama eno laleind wo vanei ngandoung gyeik ingwei xel ngo qayeeng tiyon o. ");
INSERT INTO tbx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xel qandi lek, me tiy e la myayaing veil beyeeng wei xel ev lek qetyei. Om xel qou e me la lek bembembek wei lukendu yon en embei tendu e doing. ");
INSERT INTO tbx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ekom dembu me la senghoing eivek moux alis vex ngenongakes on de la. ");
INSERT INTO tbx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Woyom moxo lep me la xo Kapenaom nei, beyeeng on toundei eivek distrik Galili, de lek bouk wei Sabat eno mi teyoxe xomaxoneing. ");
INSERT INTO tbx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Xel etek en e xe qayeeng wei teyoxe yo, en e xe qayeeng on lam is nikanzek ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Eivek xomek qekueing ama eno tambiy ti memo laweeng nilaxes mindei eivek e. Moxo eng ngandoungateiv me neil, ");
INSERT INTO tbx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“E! Wa being bong vati wou xa, Yesu wei Nasaret o? Wang lam en wa being nam bo nol wou xa? A woulek wang woy bei wa Tambiy Vambuing tiwei Anutu xe yo!” ");
INSERT INTO tbx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Om Yesu luk niseikeing wou e me neil, “Denduing ma! De lam myayaing veil moux tiyon!” Om memo yon nex tambiy on la lek tembuing wou xel mend de lam myayaing veil e dom se wo nol wou no. ");
INSERT INTO tbx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Xomaxoneing on dalus etek me di neil wouma bei, “Teyoxeing qayeeng tine vati? Om lam is lei ngandoung me nikanzek de luk nikanzek wou laweeng nilaxes me xel lam myayaing!” ");
INSERT INTO tbx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Me e xe pavulek wei wong vatiyeiw eno la teyei lek tembuing tiyon dalus. ");
INSERT INTO tbx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu la veil xomek qekueing ama me la eivek Simon beeng. Gying ngandoung wo nol wou Simon yeing avexta, me gweimbeeng xel teling wou Yesu bei e devind vexo. ");
INSERT INTO tbx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Om la paviy vexo me luk niseikeing wou gying, me ema veil e. Vexo qandi lek lutika me la menyex wou lul yaeing wou xel. ");
INSERT INTO tbx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gyeik ingwei sayeiv teila eno xomaxoneing qou xel dalus wei vanei nelu nelu wong xel o me la wou Yesu me e liw mema lek xel titi, moxo wong xel dalus wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Xel memo ngenongakes lam myayaing veil xomaxoneing ngenong me di taxe bei, “Wang on Anutu Neu Moux!” Ekom moxo luk nikanzek wou xel me peti xel, en nambei xel woulek bei e Kilisi. ");
INSERT INTO tbx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Satiboukeing lul eno Yesu qandi me la ingwei xel ma veil o. Om xomaxoneing mi yimexe e, gyeik ingwei xel la yeiwou e eno xel wong en xel embei neil axound e bei e se na veil xel. ");
INSERT INTO tbx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ekom neil embei, “A na neil Xoulek Nimza wei tete lalei wei Anutu yo, wou xel beyeeng bamba nei is, en qes tiyon om wong a lam.” ");
INSERT INTO tbx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Me moxo la neil xoulek lala eivek xomek qekueing ama dalus wei Yudia nei. ");
INSERT INTO tbx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Bouk ti eno Yesu la nale wou lounyeing Genesaret nenyawes, me xomaxoneing ngenong la vingama e vivekwou e, me di ngo Anutu xe xoulek. ");
INSERT INTO tbx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesu yei bot yayuw di yeip wou lounyeing nenyawes, xel wei mi qou woing eno la veil, en xel la di sekweyexe xel xe lewek. ");
INSERT INTO tbx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu lek la eivek bot ti, tiyon Simon xe, me teling wou Simon bei e tendu bot na nayaka veil lounyeing nenyawes. Woyom la dei lek bot me teyoxe xel ngenongakes on. ");
INSERT INTO tbx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Gyeik ingwei e neil xoulek woy, eno neil wou Simon bei, “Tendu bot e la eivek memiing manghembi me nex lewek teila eivek en kandek na puw woing o.” ");
INSERT INTO tbx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon lewexe bei, “Teiv, boukeing tine xa wong xuk ngandoung ek xa se qou lulti. Ekom wang neil, om tyek a nox banex lewek na eivek memiing no.” ");
INSERT INTO tbx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Gyeik xel wong ambei nyon eno woing ngenong eivek me lewek embei tax. ");
INSERT INTO tbx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Om xel nex memend en xel wei xel xouing mi wong xuk lekti wei toundei lek bot nge yo me xel lam vind xel me toung woing eivek bot luw xouing me e puplek om wong bot luw xouing di teila eivek memiing lalei. ");
INSERT INTO tbx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Gyeik ingwei Simon Petele yei inyon, eno la ev vaxa qatu eivek wou Yesu me neil embei, “Tambiy Ngandoung, la veil ay, en a moux wei sewokeing o.” ");
INSERT INTO tbx_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","En e is liyeiw dalus wei toundei is e eno etek en ingwei xel qou woing ngenong o. ");
INSERT INTO tbx_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Me Sebedi neu Jems aluw Yoan wei luw mi wong xuk woing is Simon, eno luw yei me etek is. Woyom Yesu neil wou Simon bei, “Wa seng gwaleeng. En gweimbeeng me e mi na eno tyek wang bong xuk me na qou xomaxoneing.” ");
INSERT INTO tbx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Om xel puw xel xe bot luw xouing la nale yasewis, woyom xel ghanaw lulul dalus toundei de la betiwou Yesu. ");
INSERT INTO tbx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ka Yesu toundei eivek beyeeng ti, eno tambiy ti lam, ninavi pup en vanei lepa. Gyeik ingwei yei Yesu, moxo yeip ma eivek tembuing wou e me tay wou e, “Tambiy Ngandoung, wangwei wa laleim devind ond wang bong am bo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu tatei mema la me axlek moux tiyon. Moxo neil embei, “A laleing vind, wang bo nimzalek!” De lutika eno lepa ma veil e. ");
INSERT INTO tbx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Woyom Yesu luk nikanzek wou embei, “Wa se neil wou xelti, qe la, me talex xow wou lumuki, me ghe bong xound na nambei Mose neil o en e talex bei wang wo nimzalek, en xel boulek bei wa xe vanei ma.” ");
INSERT INTO tbx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","De pavulek wei Yesu eno la wo ngandoung, om xomaxoneing ngenong lam me ngo e de moxo wong xel xe vanei wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ekom Yesu venaxow mi la veil xel me la tembuing bandaing me la zeimema. ");
INSERT INTO tbx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Bouk ti gyeik Yesu di teyoxe moux alis vex me dei, eno xel Parisi me xel putoung wei petieing eno xel lam anghei beyeeng dalus wei Galili me Yudia me beyeeng Yerusalem, me la toundei inyei. Me Tambiy Ngandoung xe nikanzek lam eivek Yesu me e wong moux alis vex xe vanei wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Xel moux valu qalei tambiy wei bezomb o ti lek lelek me lam, xel di wong me yei en xel embei qou e me na xomek lalei me na niw wou Yesu ma. ");
INSERT INTO tbx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Gyeik ingwei xel lam eno xel ngenongakes toundei zeyi om xel se teyeimbei gyeiwou sakwaing ti me na eivek xomek lalei. Om xel lek xomek demi qetyei me gwang danghei ti me byex yis lek lelek me wong tambiy on di teila kaka eivek moux alis vex senghoing wou Yesu ma. ");
INSERT INTO tbx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Gyeik ingwei Yesu yei xel xe wongeingis, moxo neil embei, “Gweleeng, a semaleeng wa xe sewokeing.” ");
INSERT INTO tbx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Xel Parisi me xel putoung wei petieing o di wou eivek naleind, “Eti ingwei embei qou Anutu nimbeeng nei? Xelti se teyeimbei semaleeng sewokeing, qe Anutu venaxow.” ");
INSERT INTO tbx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu woulek vati wei xel di wou naleind en o me teling, “Nambei nya xam ghe di wou naleimim en lulti beimambei ne eivek laleimim? ");
INSERT INTO tbx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Qayeeng vati teyei bei neileing, ‘A semaleeng wa xe sewokeing’ o neileing bei, ‘Wa qandi lek me ghe na?’ ");
INSERT INTO tbx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ekom inyon xam ghe boulek bei Xomaxoneing Neu Moux qou lei ngandoung lek tembuing en embei semaleeng sewokeing.” Moxo neil wou moux ti bezombeing on, “A neil wou wang, qandi lek, qou wa xe lelek me la bam.” ");
INSERT INTO tbx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Lutika eno moxo qandi lek wou moux alis vex mend me qou e xe vati wei yeip lek o me la beeng de di sanghoxe Anutu. ");
INSERT INTO tbx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Xomaxoneing dalus etek en ingwei xel yei Anutu xe nikanzek me poux zeng, de sanghoxe Anutu me neil embei, “Xey a xei lulvako ngandoung gweimbeeng.” ");
INSERT INTO tbx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ka tine la veil eno Yesu la myayaing me yei tambiy wei mi qou takis o ti lei Livai eno toundei eivek xomek takis. Yesu neil wou bei, “Wa betiy ay.” ");
INSERT INTO tbx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Livai qandi lek me ghanaw lulul dalus de betiwou e. ");
INSERT INTO tbx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Woyom Livai wong mata ngandoung ti wou Yesu eivek xomek wei e nei me xel qendu ngandoung wei mi qou takis o me xel valu lam ya is xel. ");
INSERT INTO tbx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ekom xel Parisi me xel putoung wei petieing o eivek qendu wei Parisi yo di neil Yesu xe xel betiyeing, “Nambei nya xam ghe di wa me ghe num is xel wei mi qou takis me xel wei sewokeing o?” ");
INSERT INTO tbx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu lewexe me neil embei, “Xel wei vanei ma eno se mi la wou dokta, qe xel wei vanei yo. ");
INSERT INTO tbx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","A se lam bei taxe xel wei bombek o, qe xel wei sewokeing o en xel pekwi xow.” ");
INSERT INTO tbx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","De xel neil wou embei, “Xel betiyeing wei Yoan o di vambu yaeing me zeimemend me xel betiyeing wei Parisi yo is, ekom ingwei wang eno di wo eisanou lek yaeing me numeing.” ");
INSERT INTO tbx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu lewexe bei, “Wang teyei bei bong xel wei lam toundei is tambiy wei embei dii vex eno vambu yaeing gyeik e toundei is xel o? ");
INSERT INTO tbx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ekom bouk tyek nam gyeik ingwei xel a qou tambiy tiwei embei dii vex eno me na veil xel, on tyek eivek bouk kayon eno xel vambu yaeing.” ");
INSERT INTO tbx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Me Yesu neil qayeeng pakeing tine wou xel bei, “Xelti se mi qateiv teimb ding myasepu wei vako yo me duw eivek ingwei takwei yo. Wangwei e bong ambei nyon, on tyek zex teimb ding wei vako yo, de ing vako eno tyek se ghok ingwei takwei yo. ");
INSERT INTO tbx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Me xelti se mi taw wain nilouk vako eivek wain takwei ninavi. Wangwei e bong ambei nyon on tyek wain vako zex wain ninavi, de wain tyek na taw veil de wain ninavi zex me bo nol. ");
INSERT INTO tbx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma, xel a taw wain vako eivek wain ninavi vako. ");
INSERT INTO tbx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Me xel tiwei num wain takwei eno tyek laleind se devind bei na num vako, en tyek na neimbei, ‘Takwei nimza.’” ");
INSERT INTO tbx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","De Sabat ti eno Yesu la di ghavineeng eivek xuk lalei wei wit o. Me e xe xel betiyeing ul wit neing valu me liyexe eivek memend me wong navi veil de ya neing. ");
INSERT INTO tbx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Dekakom Parisi valu teling bei, “Xam ghe wong vati wei se la teyei lek o lek Sabat enva?” ");
INSERT INTO tbx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu lewexe me neil, “Xam seng pyaw vati wei Dawit wong gyeik ingwei e is e xe xel maxepya xel o? ");
INSERT INTO tbx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Moxo la eivek Anutu xe xomek, me la qou belet vambuing wei xel mi toung wou Anutu ma yo, moxo ya vati wei petieing lewexe lek bei, xel lumuki venaxow a mi gya yo. De moxo wong valu wou e xe xel me xel ya is.” ");
INSERT INTO tbx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Woyom Yesu neil wou xel bei, “Xomaxoneing Neu Moux ne Tambiy Ngandoung wei Sabat o.” ");
INSERT INTO tbx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Lek Sabat nge eno moxo la eivek xomek qekueing ama me di teyoxe xel. Tambiy ti toundei inyon eno mema payeiv bezomb. ");
INSERT INTO tbx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Xel Parisi me xel putoung wei petieing o di yimexe qes wei xel embei byex qayeeng lek Yesu yo, om xel di yei e teyei teyei bei tyek se bong vanei ti bo nimzalek Sabat. ");
INSERT INTO tbx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ekom Yesu yei woueing nalei wei xel o, om neil wou tambiy wei mema bezomb bei, “Qandi lek me la nale mya wou xel sapa mend.” Om moxo qandi lek me la nale inyei. ");
INSERT INTO tbx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Woyom Yesu neil wou xel, “Ambei teling xam. Nyei vati la teyei lek en bouk wei Sabat o, xey a bong kwa nimza lek, o xey a bong kwa nilul lek? Xey a devind mapieing o xey a bo nol wou?” ");
INSERT INTO tbx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Moxo yei e vivekwou xel dalus, dekalekom neil wou tambiy tiyon bei, “Tatei memam.” Moxo wong ambei nyon de mema wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ekom xel Parisi me xel putoung wei petieing o laleind wo vanei me di neil wouma bei, “Tyek xey a bong vati wou Yesu?” ");
INSERT INTO tbx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Lek bouk on ti eno Yesu lek lukendu ti me la en embei na zeimema. Moxo mi zeimema wou Anutu eivek boukeing tiyon dalus. ");
INSERT INTO tbx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gyeik ingwei woyaing eno Yesu taxe e xe xel betiyeing dalus lam wou e me beyal xel xoumeeng yuw wei taxe sinale lek xel o. ");
INSERT INTO tbx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ti lei Simon (wei Yesu taxe e lei Petele yo), li Andrias, Jems, Yoan, Pilip, Batolomiu, ");
INSERT INTO tbx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matai, Tomas, Jems wei Alpias neu yo, me Simon wei xel taxe bei Selot o, ");
INSERT INTO tbx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yudas wei Jems neu me Yudas Iskariot tiwei toung Yesu eivek xel vevek memend o. ");
INSERT INTO tbx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Woyom Yesu lep lek lukendu me la xonei is e xe xel betiyeing me la nale lek beyeeng wei sambus o. E xe xel betiyeing ngenong toundei inyon me xomaxoneing ngenong lam anghei Yudia sapa, me nanghei beyeeng Yerusalem, me nanghei mamileeng vi wei paviy beyeeng Taia me Saidon eno lam toundei inyon. ");
INSERT INTO tbx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Xel lam en embei ngo e xe qayeeng de e bong xel xe vanei bo nimzalek. Me moux alis vex wei xel laweeng nilaxes wo nol wou xel eno Yesu wong xel wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Me xomaxoneing dalus di wong me yei en xel embei daxlek e, en nambei nikanzek di lam eivek e me wong xel dalus wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu yei e xe xel betiyeing, de neil embei, “Xam wei kanyo yo ghe bo xeimimlala, en Anutu xe tete lalei yon xam xe. ");
INSERT INTO tbx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Xam wei maxep mi ya xam gweimbeeng eno ghe bo xeimimlala en loxyus eno tyek xam ghe gwa me enden xam. Xam wei ghe mi eng gweimbeeng eno ghe bo xeimimlala en tyek loxyus eno xam a mi nap. ");
INSERT INTO tbx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Xam ghe bo xeimimlala gyeik ingwei xel moux laleind bo nol wou xam, gyeik ingwei xel a tiy xam me na neil qayeeng nol lek xam, me pesek xam leimim nambei nilul, qes en Xomaxoneing Neu Moux. ");
INSERT INTO tbx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ond lek bouk kayon xam ghe bo xeimimlala me davyeip davyeip is xeilala, en xam xe xouveing ngandoung toundei eivek tyoung gheyapu nei. En nambei nyon eno xel bundyeiw mi wong kwa kayon wou xel poropet. ");
INSERT INTO tbx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ekom xam wei lulul ana yo ghe gwaleeng amim, en xam ghe qou lulul wei wong xam laleimim wo nimza yo woy. ");
INSERT INTO tbx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Xam wei ghe mi wa ngenong gweimbeeng me enden xam eno xam ghe gwaleeng amim. En tyek loxyus eno maxep gya xam. Xam wei ghe mi nap gweimbeeng ne, xam ghe gwaleeng amim. En tyek loxyus eno xam ghe bo talot me ghe deeng. ");
INSERT INTO tbx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Xam ghe gwaleeng amim gyeik ingwei moux alis vex dalus baluk qayeeng nimza en xam o. En takwei eno xel bundyeiw mi wong ambei nyon wou xel poropet wei tyonyeing o.” ");
INSERT INTO tbx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yesu neil no bei, “A neil wou xam eti yeiw wei ghe mi ngo axe qayeeng o: Xam laleimim devind xel vevek amba wei xam o, de ghe bong nimza wou eti yeiw wei laleind mi wo nilul wou xam o, ");
INSERT INTO tbx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Xam ghe bo mata wou eti yeiw wei mi neil vya lek xam o, dom na zeimemamim en xel wei mi wo nol wou xam o. ");
INSERT INTO tbx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wangwei xelti petapexe wa ling valu ond wa pekwi valu wou en e petapexe is. De wangwei xelti qou wa xe teimb ding, on wa se neil axound wa xe teimb wei embei qou yo. ");
INSERT INTO tbx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xam ghe bong lulul wou xel sapa wei teling xam o, me eti yeiw qou xam xe lulul, on xam se baluk nikanzek bei xel bong enoum. ");
INSERT INTO tbx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Xam ghe bong wou xel bange nambei ingwei xam ambei xel bong wou xam o. ");
INSERT INTO tbx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Wangwei xam laleimim devind xel wei laleind mi vind xam o venaxow, on tyek xam a qou lul nimza vati en inyon? Xel sewokeing is ambei nyon, xel laleind mi vind xel wei laleind mi vind xel o. ");
INSERT INTO tbx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Me wangwei xam ghe bong kwa nimza wou xel wei mi wo nimza wou xam o venaxow, on tyek xam a qou lul nimza vati en inyon? Xel sewokeing mi wong ambei nyon is o. ");
INSERT INTO tbx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Me wangwei xam ghe bong vineing en malew wou moux alis vex valu de ghe wou naleimim bei tyek xel bong xouveing noum wou xam venaxow, ond tyek xam a qou lul nimza vati en inyon? Xel sewokeing is ambei nyon xel mi wong vineing en malew wou xel sewokeing valu en xel woulek bei tyek xel bong xouveing dalus noum zeyi. ");
INSERT INTO tbx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ekom xam laleim devind xel vevek amba, me ghe bong nimza wou xel, de ghe bong lul e na bandaing wou xel de xam seng bou kwamim bei na qou lulul ti noumenam. Woyom tyek xam xe xouveing bo ngandoung, me tyek xam ghe bong ambei Anutu gheyapu neu. En mi wong nimza wou xel wei se mi neil dange wou e yo me xel wei nilul o. ");
INSERT INTO tbx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Xam laleimim e mi pyaxow nambei xam Mamim lalei mi pyaxow en xel o. ");
INSERT INTO tbx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Xam seng gwei xel nge me baluk en e, enok Anutu gyei xam me baluk en xam. Xam se byex qayeeng lek xel nge me na neimbei xel wong nilul. Enok Anutu na byex qayeeng lek xam me na neimbei xam ghe wo nilul. Xam semaleeng nilul wei xel nge yo on tyek Anutu semaleeng nilul wei xam o. ");
INSERT INTO tbx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xam ghe bong wou xel nge, on tyek Anutu bong enoum wou xam. Tyek bong lul ngenong me na toung mema lek e deteina me na qounghexe e pup me qapyex veil me bong wou xam. En lulul vamva wei xam ghe wong wou xel nge, eno tyek Anutu bong lulul vamva yon noum wou xam nambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","De Yesu neil qayeeng pakeing tine wou xel bei, “Teyeimbei moux matekeing ti natax en moux matekeing nge? Yon tyek luw xouing se deivek leiveeng? ");
INSERT INTO tbx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yak qapiya ti se ghanaw e xe putoung, qe ka e gwevek boy on tyek xel titi teyei lek e xe putoung. ");
INSERT INTO tbx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Nambei nya wang wei papu nayaka wei toundei eivek lim ma yon de wa seng wei pelang wei toukale eivek wa venaxow mam on? ");
INSERT INTO tbx_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nambei nya wang neil wou lim bei, ‘Ling, wong a wo papu kawei toundei eivek wa mam on veil’ de wa seng wei pelang wei toukale eivek wa mam on? Wa tambiy wei myam yuw, myaxeeng eno wa pu pelang wei toukale eivek wa mam on, dekakom ghe gwei embo nimza me ghe bong papu nayak kawei toundei eivek lim ma yon veil.” ");
INSERT INTO tbx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Yesu neil no bei, “Xax nimza se mi vuk neing nol, o xax wei nol eno se mi vuk neing nimza. ");
INSERT INTO tbx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Xel xomaxoneing mi yei xaxaneing wole dekakom xel woulek bei inyon xax nimza o inyon xax nol. Xel xomaxoneing se mi la wou yis wei ying o me ul xax basunghek neing lek. Me xel se mi ul wain neing lek xax wei yingying o. ");
INSERT INTO tbx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tambiy wei nimza eno mi wong kwa nimzamza wei toundei eivek e lalei yo, de tambiy wei nilul eno kwa nilul ngenong toundei eivek e lalei. Om mi wong kwa nilul. Kwa vati wei pup e lalei lek eno mya mi neil.” ");
INSERT INTO tbx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu neil no bei, “Nambei nya xam ghe mi taxe ay bei, ‘Tambiy Ngandoung, Tambiy Ngandoung,’ de xam seng mi betiwou qayeeng wei a mi neil o? ");
INSERT INTO tbx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Wangwei xelti nam wou ay me na ngo axe qayeeng me betiwou, on tyek a talex wou xam bei e yon nambei nya. ");
INSERT INTO tbx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Inyon teyei lek moux ti embei dev xomek o. Moxo ev leiveeng la ghembi me lax mundeeng lek qakous tata eivek tembuing lalei. Dekakom ev xomek lek gheyapu. Gyeik ingwei memiing butek me lam bimexe xomek tiyon, eno xomek se qepei, en tambiy tiyon ev xomek wo nikanzekta. ");
INSERT INTO tbx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ekom tambiy tiwei ngo axe qayeeng me se betiwou, eno nambei moux tiwei ev xomek lek tembuing de se ev mundeeng la eivek qakous. Dekakom memiing butekeing lam bimexe lek xomek tiyon eno qepei me lelolexe dalus.” ");
INSERT INTO tbx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Gyeik ingwei Yesu neil qayeeng tiyon dalus ma wou xomaxoneing me xel ngo woy, de moxo la eivek beyeeng Kapenaom. ");
INSERT INTO tbx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nanghei inyei eno beyeiv wei xel vevek wei Rom o ti mindei. E xe xukxe tiwei lalei mi vind e ghanaw veil eno vanei wong me embim amey. ");
INSERT INTO tbx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Gyeik ingwei beyeiv ngo Yesu lam eno wong xel teivateiv wei Yudayeiw eno valu la wou e, me teling wou bei e na bong e xe xukxe bo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Gyeik ingwei xel lam wou Yesu, eno xel tay wou e bei, “Tambiy tine nimza, teyeimbei wa devind e, ");
INSERT INTO tbx_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","en nambei moxo lalei mi vind xey wei Yuda yo, me ev xa xe xomek qekueing ama.” ");
INSERT INTO tbx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Om Yesu la is xel. Moxo la paviy xomek, gyeik inyon eno beyeiv wong gweleeng valu la neil wou embei: “Tambiy Ngandoung, wa seng bo pok wou xow en a se teyei lek bei wang nam eivek a bang. ");
INSERT INTO tbx_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Inye qes ambei nye, om a wou naleing bei a se teyei lek bei a maxow a nak wou wang. Qe wa neil qayeeng dom a xe xukxe embo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","En a maxow is a tambiy wei a mi wevek tambiy wei wo lei ngandoung en ay yo, is axe xel vevek wei mi wevek a xeinghembi yo. A neil wou tine bei, ‘La,’ on moxo la, me nge nei, ‘Lam,’ on moxo lam. A neil wou a xe xukxe bei, ‘Wang bong xuk tine,’ on moxo wong.” ");
INSERT INTO tbx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Gyeik Yesu ngo qayeeng tine eno moxo etek en e, me pekwi ma wou moux alis vex ngenong wei di betiy e yon, me neil wou xel bei, “A neil wou xam, a se xei xelti xe wongeingis wei ngandoung o nambei nye eivek Israel sapa.” ");
INSERT INTO tbx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Woyom xel moux wei beyeiv wong xel la eno loumelam xomek me yeimbei xukxe wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ka enden nayaka le eno Yesu la beyeeng ti xel mi neil Nain, me e xe xel betiyeing me moux alis vex ngenong la is e. ");
INSERT INTO tbx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ka la paviy tete mya wei beyeeng, eno xel qalei meyeing ti me lam myayaing, vexeiv ti neu moux tixemou yon, de moux alis vex ngenong wei beyeeng eno lam is e. ");
INSERT INTO tbx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Me gyeik ingwei Tambiy Ngandoung yei vex on eno lalei pyaxow en e me neil wou e, “Wa seng deeng.” ");
INSERT INTO tbx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Woyom la paviy me axlek qoupek meyeing, me xel wei di qalei eno nale kanzek. De moxo neil, “Moux ghavis, a neil wou wang, qandi lek!” ");
INSERT INTO tbx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","De moux meyeing on qandi lek me dei ghey me luk atax, dekakom Yesu wong e lox me la wou ta. ");
INSERT INTO tbx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Xomaxoneing dalus etek en ingwei xel yei Anutu xe nikanzek me sanghoxe Anutu me neil, “Poropet ngandoung ti qandi eivek xey senghoing, Anutu lam en embei devind e xe xomaxoneing.” ");
INSERT INTO tbx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Pavulek wei Yesu ne eno xel tul ela wo tambak eivek Yudia me tembuing danghei danghei nei. ");
INSERT INTO tbx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Yoan xe xel betiyeing neil wou e en lul dalus ti beimambei wei Yesu wong on. Om moxo taxe e xe xel betiyeing yayuw, ");
INSERT INTO tbx_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","me wong luw la wou Tambiy Ngandoung bei na teling e, “Inye wa tambiy tiwei embei nam o, o xa mi daxe tambiy nge?” ");
INSERT INTO tbx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Gyeik ingwei moux yuw on la wou Yesu, eno luw neil wou e bei, “Yoan Lipekeing wong uw alam wou wang, bei nam a teling, ‘Inye wa tambiy tiwei embei nam o, o xa mi daxe tambiy nge?’” ");
INSERT INTO tbx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Lek bouk tiyon eno Yesu wong moux alis vex ngenong xe vanei leimalei wo nimzalek, me tiy xel laweeng nol wei toundei eivek moux alis vex eno veil, me wong xel ngenong wei mend tekeing eno yeila. ");
INSERT INTO tbx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Om Yesu neil elox wou nenyalesana luw bei, “Muw ghe nox a neil wou Yoan en vati wei muw venaxow ghe wei me ghe ngo yo: Xel wei mend tekeing eno yeila, xel wei vaxend nol eno qeilek me la, xel wei lepa eno wo nimzalek, nenya qatu eno ngowou, de meyeing qandi lek, me xel kanyo eno ngo Xoulek Nimza. ");
INSERT INTO tbx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Xel wei yei ay me xel xe wongeingis se tei eivek en ay eno xel bo xeindlala.” ");
INSERT INTO tbx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ka Yoan xe nenyales aluw lox veil le, eno Yesu neil wou moux alis vex en Yoan bei, “Xam ghe la eivek tembuing bandaing en xam a being na gwei vati? Ghet tiwei laweeng di vei elox me loum o? ");
INSERT INTO tbx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wangwei nama nei, yond xam ghe la bei na gwei vati? Beip xam ghe la di wei tambiy wei byex teimb nimzamza yo? Ma, xel wei mi byex teimb wei malew tata yo me xel xe lul nimzamza wei neing eno mindei eivek xel king bend. ");
INSERT INTO tbx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ekom xam ghe la en xam a being na gwei vati? Poropet ti? Ee, a neil wou xam, poropet tiyon ghanaw xel poropet ba. ");
INSERT INTO tbx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tambiy tiyon xel byex eivek xoulek ambei nye, “‘Wei, tyek a bong axe nenyalesana wei mi neil qayeeng o ti natax en wang, me tyek gyeiwou sakwaing en wang.’ ");
INSERT INTO tbx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","A neil wou xam, eivek xel wei tayeiw wou xel o eno Yoan ghanaw xel. Ekom tambiy wei lei maeing eivek Anutu xe tete lalei eno ghanaw Yoan.” ");
INSERT INTO tbx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","(Xomaxoneing dalus, is xel wei mi qou takis o, gyeik xel ngo Yesu xe qayeeng, eno xel neil embei Anutu xe sakwaing on wo bombek, en nambei Yoan lipek xel. ");
INSERT INTO tbx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ekom xel Parisi is xel wei lupeyei ngandoung en petieing wei Mose eno xel pesek Anutu xe woueing nalei en sakwaing nimza wei xel o, en nambei Yoan se lipek xel.) ");
INSERT INTO tbx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu neil, “Tyek anghei xomaxoneing wei gweimbeeng ne me talex xel lek vati? Xel on nambei nya? ");
INSERT INTO tbx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Xel on teyei lek yakyak wei mindei eivek beyeeng wei vateivek o me taxe la wou xel valu bei, “ ‘Xa vei sakwep en xam ekom xam seng aw, xa wo talot ekom xam seng eng.’ ");
INSERT INTO tbx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","En Yoan Lipekeing lam eno se ya belet me se num wain, eno xam ghe neimbei, ‘Moxo memo toundei eivek e.’ ");
INSERT INTO tbx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","De Xomaxoneing Neu Moux lam ya me num, eno xam ghe neimbei, ‘Tambiy yon mi ya ngenong me mi num wain ngenong de e gweleeng wei xel wei mi qou takis o me sewokeing o.’ ");
INSERT INTO tbx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ekom lupeyei nimza eno yeip yaing bei inye bombek en mapieing wei xel dalus wei mi betiwou yo.” ");
INSERT INTO tbx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","De Parisi ti taxe Yesu bei e na gya is e, om moxo la xomek wei Parisi yo me la dei lek zek me ya. ");
INSERT INTO tbx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Gyeik vex wei sewokeing o ti mindei eivek beyeeng tiyon eno ngo Yesu la di ya eivek Parisi beeng, vexo qou botol qakous nimza is wel xeimangou toukale eivek o me la. ");
INSERT INTO tbx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Vexo la nale wou Yesu demi paviy e vaxa de eng, me malouk taw lek Yesu vaxa. Woyom tul luvelus me vu Yesu vaxa luw angya, me sesuvexe Yesu vaxa lumama de taw wel lek e vaxa luw. ");
INSERT INTO tbx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Gyeik ingwei Parisi tiwei taxe Yesu la eno yei vex tiyon wong ambei nyon, eno luk wou xow bei, “Wangwei tambiy tine poropet ti on tyek boulek bei eti axlek e me vex tiyon nambei nya, vex on sewokeing.” ");
INSERT INTO tbx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu lewexe lek e bei, “Simon, axe qayeeng ti om ambei neil wou wang.” Moxo neil embei, “Putoung wa neil wou ay.” ");
INSERT INTO tbx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Woyom Yesu neil wou e, “Moux yayuw qou malew vateivek wou tambiy ti, nge qou selewa vaxak xoumeeng de nge qou selewa vaxak ti. ");
INSERT INTO tbx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Luw malew ma en ingwei luw embei bong enox zeyi yo, om tambiy on semaleeng malew vateivek wei luw xouing o. Om luw nge na laleind vind e ghanaw veil?” ");
INSERT INTO tbx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon neil elox, “A wou naleing bei, tambiy tiwei e xe malew vateivek ngandoung wei e semaleeng veil o.” Yesu neil embei, “Wang wei me ghe neil bombek.” ");
INSERT INTO tbx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Woyom moxo pekwi ma wou vex me neil wou Simon bei, “Wang wei vex tine? A lam eivek wa bam. Eno wa seng wong memiing valu bei a sekweyexe vaxang, qe vex tine sekweyexe a vaxang en malouk me vu gya luvelus. ");
INSERT INTO tbx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wa seng sesuvexe ay. Qe gyeik a eivek a lam wa bam eno vex tine se tip sesuvexeing a vaxang. ");
INSERT INTO tbx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wa seng taw wel lek a lung, qe vexo taw wel xeimangou yo lek a vaxang. ");
INSERT INTO tbx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Om nambei nyon a neil wou wang, vexo xe sewokeing ngenong eno semaleeng veil, om vexo lalei vind a ghanaw veil. Ekom tambiy wei Anutu semaleeng e xe sewokeing nayaka eno e xe lalei vineing nayaka.” ");
INSERT INTO tbx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Woyom Yesu neil wou vexo, “A semaleeng wa xe sewokeing veil.” ");
INSERT INTO tbx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Xel bamba wei toundei lek zek me ya eno di neil eivek ama senghoing bei, “Eti inye om teyeimbei semaleeng sewokeing veil?” ");
INSERT INTO tbx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu neil wou vex on, “Wa xe wongeingis eno vind wang. Lak is laleim vevopeing.” ");
INSERT INTO tbx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ka tine lak veil Yesu la ghavineeng eivek beyeeng nge me la nge me la valu is me neil Xoulek Nimza wei Anutu xe tete lalei eno teyei. Xel xoumeeng yuw la is e. ");
INSERT INTO tbx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Me vex valu wei Yesu tiy laweeng nol veil xel me wong xel xe vanei wo nimzalek o: Maria (xel mi taxe e bei Makdala) wei memo lim yuw lam myayaing veil e yo, ");
INSERT INTO tbx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Joana ne Kuza venei, inyon tambiy wei wo lei ngandoung en Herot beeng o, Susana, me vex ngenong is. Vex ti beimambei yon mi wong xel venaxow xe lulul bei na mi devind Yesu lis e xe betiyeing. ");
INSERT INTO tbx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Dekalekom xomaxoneing wei beyeeng sapa eno lam wou Yesu me xel qendu ngandoung qekuma me lam dei. De moxo neil qayeeng pakeing tine: ");
INSERT INTO tbx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tambiy tiwei mema xuk eno di vuw wit vei eivek xuk. Ka di vuw vei eivek xuk, eno valu teila lek sakwaing, me xel qeilek de menek lam ya. ");
INSERT INTO tbx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Valu teila lek qakous, om gyeik ingwei xel tyip eno xel mey en tembuing nilouk ma. ");
INSERT INTO tbx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","De vei valu teila eivek yis senghoing wei yingying o, me xel dalus tyip me ding dekakom yis sevunexe wit. ");
INSERT INTO tbx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","De vei valu teila eivek tembuing wei nimza yo, om tyip me vuk neing ngenong teyei lek vaxak ngenong ghanaw ingwei vuw o.” Gyeik ingwei moxo neil qayeeng pakeing tiyon ma, eno taxe bei, “Eti yeiw nenya nale lek e en ngoeing qayeeng, ond wong e ngo.” ");
INSERT INTO tbx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Moxo xe xel betiyeing teling e, “Qayeeng pakeing tine qes ambei nya?” ");
INSERT INTO tbx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","De Yesu neil wou xel, “Lupeyei ngandoung wei qayeeng xupekeing qes wei Anutu xe tete lalei yo, Anutu wong wou xam. Ekom wou xel valu eno a mi luk eivek qayeeng pakeing en kandek, “ ‘xel gyei lumama, ekom xel se gyeiwou, de xel a ngo, ekom xel se boulek e qes.’ ");
INSERT INTO tbx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Tine inye qayeeng pakeing qes: Vei yon Anutu xe xoulek. ");
INSERT INTO tbx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Vei wei teila lek sakwaing eno nambei xel wei ngo Anutu xe xoulek dekakom tambiy mapetok lam zeim veil xel laleind, en kandek xel se bongis me e devind xel. ");
INSERT INTO tbx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","De vei wei tei lek qakous eno nambei xel wei qou xoulek is xeindlala gyeik ingwei xel ngo yo, ekom xel xe luselis se evla eivek tembuing. Xel wongis nayaka, deka bouk wei axeing lam eno xel tei veil. ");
INSERT INTO tbx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","De vei wei teila eivek yis wei yingying o senghoing eno xel teyei lek xel wei ngo Anutu xe qayeeng me betiwou, ekom gyeik xel la eno xel wou naleind en lulul wei deing mapieing wei xel o, me malew ngenongakes me xeilala wei tembuing ne wou xel zeyi om xel xe neing se doung. ");
INSERT INTO tbx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ekom vei wei teila lek tembuing nimza yo, eno teyei lek moux alis vex wei ngo xoulek me zeimaxoun o. Xel laleind nimza me bombek, me xel mi nale nikanzek me vuk neing lek. ");
INSERT INTO tbx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Xelti se mi byex eivek lam me vun eivek deng o mi toung eivek lelek yeipeing lek o xeinghembi. Qe moxo mi toung lek lam vaxa, en kandek xel wei eivek la lalei eno na mi gyei xeiyaing. ");
INSERT INTO tbx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","En lul dalus wei xupek eno tyek xel boulek, me lul dalus wei xel beliv eno tyek nam mendei yanyateiv. ");
INSERT INTO tbx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Nambei nyon xam ghe bou naleimim bo nimza en vati wei xam ambei ngo yo. Xelti xe lupeyei toundei on tyek Anutu bong valu is, ek xelti lupeyei e ma yon vati wei wounalei bei di qou eno tyek Anutu na zeim veil e.” ");
INSERT INTO tbx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesu ta is liyeiw embei nam gyei e, ekom xel se teyeimbei na paviy e, en nambei moux alis vex ngenong qekuma me toundei. ");
INSERT INTO tbx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Xelti neil wou e, “Tam alis limyeiw lam toukale myayaing, me axe en xel embei gyei wang.” ");
INSERT INTO tbx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Moxo neil elox bei, “Moux alis vex wei mi ngo Anutu xe xoulek me betiwou eno inye a tang me a lingyeiw.” ");
INSERT INTO tbx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Bouk ti eno Yesu neil wou e xe xel betiyeing bei, “Xey ambei na lounyeing loxalu nei.” Om xel la eivek bot ti me la. ");
INSERT INTO tbx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ka bot di la eno Yesu yeip. Laweeng ngandoung ti lam lek lounyeing me vei memiing la eivek bot om xel la eivek nimaying ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xel betiyeing la piyexe Yesu, me neil embei, “Teiv, teiv, xey ambei zepna ne!” Moxo qandi lek me neil laweeng me memiing wei di vuklek o, me laweeng valeivek ma de memiing yeip kanzek. ");
INSERT INTO tbx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yesu teling e xe xel betiyeing bei, “Xam amim wongeingis inya?” Xel yaleeng me etek om xel di teling wouma bei, “Tambiy tine e eti? Om luk nikanzek wou laweeng me memiing me xel ngo me betiwou?” ");
INSERT INTO tbx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Xel la loxalu nanghei danghei tiwei Gerasa nei, beyeeng wei toundei lounyeing loxalu wei Galili yo. ");
INSERT INTO tbx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Gyeik Yesu teila me la yasewis eno moux wei memo nale eivek o ti nanghei beyeeng nayak on lam wou e. Takwei yeileing nei eno tambiy tine se mi byex teimb o se mindei eivek xomek ti, qe mindei eivek leiveeng meyeing. ");
INSERT INTO tbx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Gyeik tambiy on yei Yesu, eno nyayek me teila yeip wou Yesu vaxa, de taxe xoulekeing bei, “Yesu, Anutu gheyapu Neu Moux, wa being bong vati wou ay? A tay wou wang bei wa seng bo nol wou ay!” ");
INSERT INTO tbx_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","En Yesu luk niseikeing wou laweeng nilaxes bei enam myayaing veil moux on. Lumama eno laweeng nilaxes mi zeimaxoun e, de xomaxoneing mi qo e mema vaxa nangya sen me xel mi yei e teyei, ekom moxo mi tax sen veil xow de memo mi qou e me la ingwei xel ma veil o. ");
INSERT INTO tbx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu teling e, “Wa leim vati?” Moxo neil elox bei, “Qendu ngandoung.” En nambei memo ngenong la eivek e. ");
INSERT INTO tbx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Me xel tay wou Yesu lumama bei e se tiy xel na eivek leiveeng tiwei qes maeing o. ");
INSERT INTO tbx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Bok qendu ti di ya me nale wou qetyei nenyawes nanghei inyon. Xel memo tay wou Yesu bei e bong xel na eivek xel bok on, om lenghek lek xel. ");
INSERT INTO tbx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Gyeik ingwei xel memo lam myayaing veil moux on, xel la eivek xel bok on, me bok qendu dalus on veimyend me la oing bembembek me heivek lounyeing me mey. ");
INSERT INTO tbx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Gyeik ingwei xel wei mi yeiteyei xel bok on yei vati wei qandi, eno xel veimyend me la neil lulti yon teyei wou xel wei beyeeng nayak, me beyeeng beimambei nei is, ");
INSERT INTO tbx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","me xomaxoneing la yei vati wei qandi yo. Gyeik ingwei xel lam wou Yesu eno xel yei moux tiwei xel memo la veil e yo. De moxo byex teimb me lupeyei wo nimza, me toundei wou Yesu vaxa. De xel yaleeng. ");
INSERT INTO tbx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Xel wei yei lul on qandi, eno xel tul pavulek en wou xomaxoneing en ingwei memo la veil e nambei nya yo me e wo nimzalek o. ");
INSERT INTO tbx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Woyom xomaxoneing dalus wei danghei ti Gerasa yon dalus teling Yesu bei e na veil xel, en nambei xel yaleeng ngandoung. Om lox eivek bot me la. ");
INSERT INTO tbx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Moux tiwei memo la veil on tay wou bei na is e, ekom Yesu wong e la de neil wou bei, ");
INSERT INTO tbx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Wang nox bam me ghe nox a neil vati wei Anutu wong wou wang o teyei.” Om tambiy on la me neil vati wei Yesu wong wou e yo dalus teyei wou moux alis vex wei beyeeng nayak on. ");
INSERT INTO tbx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Gyeik ingwei Yesu lox me la lounyeing loxalu eno moux alis vex qou e is xeindlala, en xel di axe e. ");
INSERT INTO tbx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Woyom moux ti lei Yairus, inyon gyovaxa wei xomek qekueing ama yo, eno lam me ev vaxa qatu eivek wou Yesu vaxa, me wo nikanzek wou e bei Yesu na e beeng, ");
INSERT INTO tbx_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","en nambei e neu vex tixemou yon e xe vakovek qes nambei xoumeeng yuw eno e bim a mey. Ka Yesu di la eno moux alis vex nale vingama zeyi e. ");
INSERT INTO tbx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Me vex ti toukale inyon eno gyand mi lam eivek e teyei lek vakovek qes xoumeeng yuw, me vex tiyon mi saing e xe malew la wou dokta ekom xelti se wong e wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Vexo la nale wou Yesu demi me axlek e xe teimb ding myasepu, lutika eno gyand touk veil e. ");
INSERT INTO tbx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesu teling bei, “Eti axlek ay?” Gyeik xomaxoneing axvun, eno Petele neil, “Teiv, xomaxoneing ngenong nale vingama zeyi wang o.” ");
INSERT INTO tbx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ekom Yesu neil embei, “Xelti axlek ay. A woulek ingwei nikanzek lam myayaing veil ay yo.” ");
INSERT INTO tbx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Woyom vexo yei bei tyek se ghupek, om la is nietekeing me ev vaxa qatu eivek wou Yesu vaxa eivek xomaxoneing dalus mend, vexo neil ingwei nambei nya axlek Yesu me nambei nya wo nimzalek luti. ");
INSERT INTO tbx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Woyom Yesu neil wou vexo, “Neung vex, wa xe wongeingis wong wang wo nimzalek. La is laleim vevopeing.” ");
INSERT INTO tbx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ka Yesu nanghei di luk, eno xelti lam anghei Yairus beeng nei, inyon gyovaxa wei xomek qekueing ama yo. Moxo neil embei, “Neum vex mey om wa seng bo pok wou putoung no.” ");
INSERT INTO tbx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Gyeik Yesu ngo tine eno neil wou Yairus bei, “Wa seng gwaleeng, qe wang bongis, en vexo tyek bo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Gyeik ingwei Yesu la tyip Yairus beeng, eno se wong xel valu la lalei is e qe Petele, Yoan me Jems, me vex yak on ma luw ta. ");
INSERT INTO tbx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dekalekom xomaxoneing dalus di eng me wo talot en e. Yesu neil, “Xam tip engeing. En vexo se mey qe di yeip.” ");
INSERT INTO tbx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Xel napexe e, en xel woulek bei vexo mey. ");
INSERT INTO tbx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ekom moxo zeim vexo mema me neil embei, “A neung yak, qandi lek!” ");
INSERT INTO tbx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Vexo nu loumelam eivek, me lutika eno vexo qandi lek. Woyom Yesu neil wou xel bei xel bong lul yaeing me e gya. ");
INSERT INTO tbx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Vexo ma luw ta etek, ekom Yesu peti luw nikanzek bei, “Muw se neil wou xelti en lul tiwei qandi yon.” ");
INSERT INTO tbx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Gyeik ingwei Yesu taxe sinaleyeiw xoumeeng yuw qekuma, eno wong nikanzek me lei ngandoung wou xel bei xel a tiy memo dalus na myayaing veil moux alis vex me bong xel wei vanei wong eno bo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Me moxo wong xel la bei na neil xoulek wei Anutu xe tete lalei yo me bong xel wei vanei eno bo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Moxo neil wou xel, “Xam a being na eno xam se qou lulti, patongeeng me vaxak me belet me malew, me xam se qou teimb nge is. ");
INSERT INTO tbx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Xomek tiwei xam ghe la eivek eno xam a mi mendei eivek deka xam ghe na veil beyeeng tiyon le. ");
INSERT INTO tbx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wangwei xomaxoneing wei beyeeng ti eno se qou xam, ond xam pepa vegyuveeng veil vaxamim gyeik ingwei xam ghe na veil xel xe beyeeng o, en xel boulek bei xel wo kwa yon nol wou xow.” ");
INSERT INTO tbx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Om xel betiyeing la myayaing veil inyon me la beyeeng danghei danghei nei me neil Xoulek Nimza me wong xomaxoneing wei vanei yo wo nimzalek nanghei danghei danghei nei. ");
INSERT INTO tbx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Seyap Herot ngo lul vatiyeiw dalus wei qandi yon. Me di wounalei ngenong, en nambei xel valu neil embei Yoan qandi lek veil meyeing, ");
INSERT INTO tbx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","de xel valu neil embei Eliya lam tyip, de valu neil embei poropet wei takwei yo ti loumelam qou mapieing no. ");
INSERT INTO tbx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ekom Herot neil embei, “A qateiv Yoan kwa tip. De eti ingwei di wong lulti beimambei yon me a ngo ne?” Me di wong me yei en embei gyei Yesu. ");
INSERT INTO tbx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Gyeik sinaleyeiw loumelam, eno xel neil wou Yesu en vatiyeiw wei xel wong o. Woyom qou xel me xel venaxow la veil moux alis vex me la beyeeng tiwei xel mi neil Betsaida nei, ");
INSERT INTO tbx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ekom moux alis vex ngenong on woulek en ingwei Yesu la om xel betiy e. Moxo wo xeilala en xel lam o me luk wou xel en Anutu xe tete lalei, me wong moux alis vex wei vanei yo wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Soukeinglul eno xel xoumeeng yuw lam wou e me neil, “Wang bong moux alis vex na beyeeng danghei danghei nei en xel na gyei xend lul yaeing me beyeeng wei yeipeing o, en nambei beyeeng wei xey a toundei eivek ne eno xel ma veil.” ");
INSERT INTO tbx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Moxo neil elox bei, “Xam ghe bong lul valu wou xel en xel gya.” Xel lewexe bei, “Xa di qou belet lim ka de woing yayuw, wambei xa na bou lulul yaeing wou xel ngenong ne?” ");
INSERT INTO tbx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Nambei 5,000 moux toundei inyon.) Ekom moxo neil wou e xe xel betiyeing, “Xam ghe bong xel mendei tembuing, e teyei lek 50 eivek qendu titi.” ");
INSERT INTO tbx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Xel betiyeing wong ambei nyon, me xel dalus dei tembuing. ");
INSERT INTO tbx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Woyom Yesu qou belet lim on is woing yuw on me yeima lekla tyoung gheyapu nei, me wong dange wou Anutu. De dembu belet is woing me wong wou xel betiyeing bei xel bong wou xomaxoneing. ");
INSERT INTO tbx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Xel dalus ya me enden xel, de xel betiyeing qekuwou myapapu wei toundei yo me sei e pup eivek pasik xoumeeng yuw. ");
INSERT INTO tbx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Bouk ti Yesu venaxow di zeimema me e xe xel betiyeing toundei is e, moxo teling wou xel bei, “Moux alis vex ngenong mi neil embei ay eti?” ");
INSERT INTO tbx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Xel neil elox bei, “Xel valu neil embei wa Yoan Lipekeing, de valu neil embei Eliya, de valu neil embei poropet wei takwei eno ti loumelam dei mapieing.” ");
INSERT INTO tbx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Moxo teling wou xel, “De xam ambei inya? Xam ghe neimbei ay eti?” Petele lewexe, “Wa Kilisi wei Anutu yo.” ");
INSERT INTO tbx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yesu peti xel nikanzek bei xel se neil inyon wou xelti. ");
INSERT INTO tbx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Me moxo neil embei, “Xomaxoneing Neu Moux tyek na qou myavanei ngenong, me xel teivateiv me xel lumuki leitata yo me xel putoung wei petieing o tyek pesek e me nyeis e mey deka bouk yayal na veil om qandi lek.” ");
INSERT INTO tbx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Woyom moxo neil wou xel dalus bei, “Wangwei xelti embei betiy ay, ond e dax xow vun me qalei e xe xax pepeeng taxombouk me betiwou ay. ");
INSERT INTO tbx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","En xelti embei zeimaxoun mapieing wei e yo ond tyek na saing e xe mapieing, ekom wangwei xelti saing mapieing wei e yo en ay on tyek mendei mapieing luta. ");
INSERT INTO tbx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wangwei xomaxoneing a qou lulul wei tembuing sapa ne ekom na saing mapieing wei e yo? Yon tyek bo nimza wou e nambei nya? ");
INSERT INTO tbx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Wangwei xelti embei nigyaleeng en ay me axe qayeeng, on tyek Xomaxoneing Neu Moux nigyaleeng en e gyeik ingwei embei nam is e xe xeiyaing ngandoung me eivek xeiyaing wei Ma xe yo me xel angela vambuing o. ");
INSERT INTO tbx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","A neil wou xam zonghek, xel wei toukale inye yo valu tyek se daxe meyeing, qe tyek xel gyei Anutu xe tete lalei.” ");
INSERT INTO tbx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nambei bouk lim yal la veil en ingwei Yesu neil inyon o, moxo qou Petele, Yoan me Jems is xow me xel lek lukendu ti me la en embei na zeimema. ");
INSERT INTO tbx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ka e di zeimema, eno mapekwi me e xe teimb teltyip nambei zivip mi nex mema yo. ");
INSERT INTO tbx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Moux yayuw, Mose luw Eliya, ");
INSERT INTO tbx_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","luw lam is xeiyaing ngandoung me di luk is Yesu. Luw di luklek ingwei tyek na veil tembuing ne yo, me embim bong e xe xuk bo neing lek nanghei Yerusalem o. ");
INSERT INTO tbx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petele me luyuw wei la is e eno lal mend yeip om lal yeip, ekom gyeik ingwei lal qandi lek, lal yei e xe xeiyaing ngandoung me moux yuw wei toukale is e yon. ");
INSERT INTO tbx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ka moux yuw on di la veil Yesu, Petele neil wou e, “Teiv, inye nimza bei xey a toumendei inye. Wong xa ev xomek sel yayal, ti wou wang, ti wou Mose de ti wou Eliya.” (Moxo se woulek vati wei neil on.) ");
INSERT INTO tbx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ka moxo di luk eno laxap ti lam me sevunexe xel, me xel yaleeng en ingwei xel la eivek laxap o. ");
INSERT INTO tbx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Vya ti lam eivek laxap, me neil embei, “Tine a Neung, wei a beyal o, xam a mi ngo e.” ");
INSERT INTO tbx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Gyeik vya tiyon luk woy eno xel yei bei inye Yesu venaxow. De xel betiyeing venaxow di wou naleind en inyon, de lek bouk tiyon eno xel se neil wou xelti en vati wei xel yei yo. ");
INSERT INTO tbx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","De bouk nge, gyeik ingwei Yesu lis e xe xel betiyeing lep me loum veil lukendu, eno moux alis vex ngenongakes lam wou e. ");
INSERT INTO tbx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Moux ti eivek xel ngenong on senghoing eno taxe, “Putoung a tay wou wang bei, wang gwei a neung moux, en inyon a neung tixemou ne. ");
INSERT INTO tbx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Laweeng ti mi la eivek e me lutika eno mi nyayek me nex e la di puw mema vaxa lek tembuing de wong myapeleis mi qandi eivek e mya. De laweeng tiyon se mi la veil e qe mi wo nol wou e. ");
INSERT INTO tbx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","A tay wou wa xe xel betiyeing bei xel a tiy laweeng nol e na veil. Ekom xel se teyei.” ");
INSERT INTO tbx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu neil elox, “Xam xomaxoneing wei gweimbeeng ne xam amim wongeingis ma, me xam xe woueing nalei me kwa ne se nimza, tyek a mi mendei is xam teyei lek bouk vamva me qalei xam xe maying? Qou neum me lam inye.” ");
INSERT INTO tbx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ka yak on di lam, memo yon nex e la lek tembuing me di puw mema vaxa eivek. Ekom Yesu neil laweeng nilaxes on, me wong yak on wo nimzalek de wong e lox wou ma. ");
INSERT INTO tbx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Me xomaxoneing dalus on etek en Anutu xe nikanzek ngandoung on. Ka xel dalus di wou naleind en vati wei Yesu wong o, moxo neil wou e xe xel betiyeing bei, ");
INSERT INTO tbx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Xam a ngo embo nimza en vati wei am bim a neil wou xam o. Tyek xel a neil Xomaxoneing Neu Moux teyei me na toung e na eivek xomaxoneing memend.” ");
INSERT INTO tbx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ekom xel se woulek qayeeng on qes. En inyon yeip xupekeing en xel, om xel se woulek, me xel yaleeng en ingwei xel embei teling e yo. ");
INSERT INTO tbx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Woyom xel betiyeing pyalek ama bei eti tyek bo lei ngandoung en xel. ");
INSERT INTO tbx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu yei xel laleind, om qou yak ti me wong e nale wou e wes. ");
INSERT INTO tbx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Woyom moxo neil wou xel betiyeing bei, “Xelti embei zenghek lek yak kane en a leing on lenghek lek ay, me tiwei lenghek lek ay eno lenghek lek tambiy tiwei wong a lam o. En tambiy tiwei lei maeing eivek xam dalus senghoing eno tiyon lei ngandoung.” ");
INSERT INTO tbx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yoan neil embei, “Teiv, xa xei tambiy ti di tiy memo en wa leim, om xa peti e en inyon se tambiy wei xey o ti.” ");
INSERT INTO tbx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ekom Yesu neil wou embei, “Xam se peti e, en xelti embei se bo nol wou xam ond inyon xam xe.” ");
INSERT INTO tbx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ka bouk lam paviy ingwei Anutu embei qou Yesu me zek me nox me na tyoung gheyapu nei, om Yesu wounalei wo nikanzek en embei na Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Me moxo wong nenyalesana valu qou qayeeng me la tax, xel la eivek beyeeng wei Samaria yo ti en xel embei gyeiwou lulul dalus wou e, ");
INSERT INTO tbx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ekom xomaxoneing wei inyon o se lenghek lek e, en embei na Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Gyeik ingwei betiyeing yuw, Jems aluw Yoan, yei kwa tine, eno luw teling, “Tambiy Ngandoung, wambei uw a taxe nenyex nanghei tyoung gheyapu nei nam gya xel ne?” ");
INSERT INTO tbx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ekom Yesu pekwi ma me neil luw, ");
INSERT INTO tbx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","de xel la beyeeng bange. ");
INSERT INTO tbx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ka xel di la wou sakwaing, eno tambiy ti neil wou e, “Beyeeng dalus wei wambei mi na, eno tyek a mi betiwou wang.” ");
INSERT INTO tbx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu neil elox bei, “Naw bemeeng eeng toundei me menek lewis toundei, ekom Xomaxoneing Neu Moux beeng wei embei ni lu lek eno ma.” ");
INSERT INTO tbx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Moxo neil wou moux nge, “Wa betiy ay.” Ekom moux on neil elox bei, “Tambiy Ngandoung, wong a lox a ev mang wole.” ");
INSERT INTO tbx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yesu neil wou e bei, “Wong eyeip, de xel wei meyeing eno venaxow di ev xel xe meyeing, dom wang na neil Anutu xe qayeeng wei tete lalei yo teyei.” ");
INSERT INTO tbx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Xel nge neil embei, “Tambiy Ngandoung, tyek a mi betiy wang, ekom teyeimbei a nox a neil woyo wou mangha tang me lingyeiw bole?” ");
INSERT INTO tbx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu neil elox wou e bei, “Tambiy wei mi zeim taliv ekom mi yei lox demi, eno se teyeimbei bong xuk eivek Anutu xe tete lalei.” ");
INSERT INTO tbx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Kalekom Tambiy Ngandoung beyal xel 72 is me wong xel mi la yuyuw, me xel la tax en e eivek beyeeng nayak me beyeeng sapa wei embim na eivek o. ");
INSERT INTO tbx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Moxo neil wou xel, “Lulul wo neing ngenong woy en qoueing, ekom xel xukxe eno nuyuw. Om xam teling wou Tambiy Ngandoung wei e xe lulul yaeing on, dekakom embong xukxe na eivek e mema xuk on me na qou neing. ");
INSERT INTO tbx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xam la! A wong xam ghe la nambei sipsip lingheing eivek naw bemeeng senghoing. ");
INSERT INTO tbx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Xam se qou vaxak malew, o vaxak, o vaxalambes, me xam se neil bendiyeing wou xel wei di la wou sakwaing o. ");
INSERT INTO tbx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Gyeik xam ghe na eivek xomek ti, myaxeeng eno xam a neil, ‘Lalei vevopeing e nak wou xomek tiyon.’ ");
INSERT INTO tbx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Wangwei tambiy wei lalei vevopeing eno ti na toumendei eivek xomek tiyon, ond tyek wa xe lalei vevopeing na mendei is e, ek wangwei na ma on tyek lalei vevopeing on noumenam wou wang. ");
INSERT INTO tbx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Xam a mi mendei eivek xomek tiyon, me xam ghe gwa me na num vatiyeiw wei xel wong wou xam o, en tambiy wei mi wong xuk eno tyek na qou e xe xouveing. Dom xam seng na ghavineeng eivek xomek nge me ghe na nge. ");
INSERT INTO tbx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Wangwei xam ghe na eivek beyeeng ti me xel a qou xam, ond xam ghe gwa vatiyeiw wei xel yeiwou me toung elam wou xam o. ");
INSERT INTO tbx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Me xam ghe bong xel wei toundei eivek beyeeng on xe vanei bo nimzalek. De na neil wou xel bei, ‘Anutu xe tete lalei lam paviy xam.’ ");
INSERT INTO tbx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ekom wangwei xam ghe na eivek beyeeng ti ek xel se qou xam, ond xam ghe na bale eivek xel xe sakwaing memama me na neimbei, ");
INSERT INTO tbx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Vegyuveeng wei xam xe beyeeng on, wei mil xa vaxami eno xa pepa veil bei e nouk lek xam me talex xam xe nilul. De xam ghe boulek neing bei, Anutu xe tete lalei lam paviy.’ ");
INSERT INTO tbx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A neil wou xam, lek bouk wei wongeing qayeeng eno nimaying wei embei qandi wou beyeeng tiyon eno tyek ghanaw nimaying wei Sodom o. ");
INSERT INTO tbx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Inye wo nimaying en xam Korasin! Inye wo nimaying en xam Betsaida! En wangwei lulvako wei a wong eivek xam bamim eno xelti bong eivek Taia luw Saidon, on tyek xel pekwi xow takwei nei, me na byex teimb wei talot me dev vewev lek xow. ");
INSERT INTO tbx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ekom lek bouk wei wongeing qayeeng, eno nimaying wei xam eno tyek ghanaw nimaying wei Taia luw Saidon o. ");
INSERT INTO tbx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Me Kapenaom wang, tyek xel sanghoxe wang zekna tyoung? Ma, tyek wang na xonei eivek beyeeng wei meyeing o.” ");
INSERT INTO tbx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu neil wou xel betiyeing bei, “Xelti embei ngo xam ond ngo ay, o xelti embei pesek xam ond pesek ay, ekom xel tiwei pesek ay eno pesek tambiy tiwei wong a lam o.” ");
INSERT INTO tbx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xel 72 loumelam is xeilala me neil, “Tambiy Ngandoung, xel memo betiwou xa vyami en wa leim.” ");
INSERT INTO tbx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Moxo neil elox wou xel, “A xei Sandang tei me lam nambei zivip nanghei tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Xam ngo, a wong nikanzek wou xam bei xam bakei lek myeiy, me boklevek, me nikanzek wei xam o tyek ghanaw nikanzek dalus wei tambiy mapetok wei mi wo vevek o, de lulti tyek se bo nol wou xam. ");
INSERT INTO tbx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","De xam seng bo xeimlala bei laweeng nol betiwou xam xe qayeeng, qe xam ghe bo xeimlala bei Anutu byex xam leimim nanghei tyoung gheyapu nei.” ");
INSERT INTO tbx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Lek bouk tiyon eno Laweeng Vambuing wong Yesu pup en xeilala, me neil, “Mang a sanghoxe wang, wa Tambiy Ngandoung wei tyoung gheyapu luw tembuing o, en nambei wang vun lulul ti beimambei ne en xel wei lupeyei me kwa nimza yo, de wang talex wou xel wei nambei yakyak o. Ee, Mang, en inyon wang betiwou wamaxow xe woueing nalei me ghe wong ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Mang wong lulul dalusateiv wou ay, xelti se woulek Neu Moux qe Ma venaxow, me xelti se woulek Ma qe Neu Moux venaxow is xel wei beyal bei tyek talex e wou xel o.” ");
INSERT INTO tbx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Woyom moxo pekwi ma wou e xe xel betiyeing me neil wou xel venaxow xupekeing, “Nimzayang ena wou xel wei yei vati wei xam ghe wei yo. ");
INSERT INTO tbx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","En a neil wou xam bei, poropet ngenong me xel king embei gyei vati wei xam ghe wei yon, ekom xel se yei. Me xel embei ngo qayeeng tiwei xam ghe ngo yon, ekom xel se ngo.” ");
INSERT INTO tbx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Woyom xel wei lupeyei ngandoung en petieing wei Mose yo ti nale ghey bei daxe Yesu. Om teling, “Putoung, tyek a bong vati me na qou deing mapieing luta luta?” ");
INSERT INTO tbx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu neil elox, “Xel byex vati eivek petieing? Wang pyaw ambei nya?” ");
INSERT INTO tbx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Moxo lewexe bei: “‘Wa laleim devind Tambiy Ngandoung wa xe Anutu is laleim dalus me is num pieing dalus me is wa nimkanzek dalus me is wa lumpeyei dalus,’ me ‘Wa laleim devind nimpapu nambei wa laleim vind xow o.’ ” ");
INSERT INTO tbx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu neil elox wou e, “Wang neil e wo bombek, wang bong ambei nyon ond tyek wa mendei mapieing.” ");
INSERT INTO tbx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ekom tambiy on embei talex xow wou Yesu bei e xe deing on bombek, om teling Yesu, “A ningpapu eti?” ");
INSERT INTO tbx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Woyom Yesu neil, “Moux ti la veil Yerusalem me lep me la Jeriko, gyeik la eno la eivek xel panaxeing memend. Xel kwax e xe teimb veil e me qou de leis e wo nol me e mey pesiv de xel la. ");
INSERT INTO tbx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","De lek bouk kayon eno lumuki ti betiwou sakwaing kayon me la xonei, de gyeik moxo yei moux tiyon di yeip wou sakwaing om ghanaw e, de tanewou sakwaing nenyawes valu me la. ");
INSERT INTO tbx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Om Livai ti is ambei nyon gyeik e lam tei wou beyeeng wei moxo di yeip lek o me yei e, eno ghanaw e me tanewou sakwaing nenyawes valu me la. ");
INSERT INTO tbx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ekom Samaria ti di lam anghei ingwei moux on di yeip o, gyeik ingwei yei e eno lalei pyaxow en e. ");
INSERT INTO tbx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Moxo la wou e me taw wel me wain eivek xel qatyex on me tup en banis. Woyom zeim moux on me toung lek emaxow xe dongi, me qou me la eivek xomek wei vateivek o ti me mi yeiteyei e wo nimza. ");
INSERT INTO tbx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","De yanyeing eno wong selewa yayuw wou xomek vateivek ma, de neil wou e bei, ‘Wa mi gweiteyei embo nimza, deka a noum on tyek a bong malew noum zeyi wa xe malew wei wang wong lek mapu yo.’ ");
INSERT INTO tbx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“Wang wou naleim ambei nya, lal yal on eti nipapu ingwei la eivek xel panaxeing memend on?” ");
INSERT INTO tbx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tambiy lupeyei ngandoung wei petieing o neil elox bei, “Tambiy tiwei lalei pyaxow me vind e yo.” Yesu neil wou e, “Wang na me ghe na bong ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ka Yesu is e xe xel betiyeing di la wou sakwaing, eno la eivek beyeeng ti, wei vex ti lei Marata eno tax beeng wou e. ");
INSERT INTO tbx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Vexo li vex ti, lei Maria eno la dei paviy Tambiy Ngandoung vaxa me di ngo qayeeng wei e di neil o. ");
INSERT INTO tbx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ekom Marata di wounalei ngenong en xuk dalus wei di yeiwou lul yaeing o. Vexo lam wou Yesu me teling, “Tambiy Ngandoung, wa seng wou kwam en ingwei a ling vex toundei bandaing de a maxow andi wong xuk ne? Neil wou e en e nam devind ay yo.” ");
INSERT INTO tbx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ekom Tambiy Ngandoung lewexe lek bei, “Marata, Marata, wang di wou kwam ngenong me nimseik en lulul ngenong. ");
INSERT INTO tbx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ekom lulti kawei wa bei qou eno Maria beyal vati wei nimza yo, om tyek xelti se teyeimbei bouveil e.” ");
INSERT INTO tbx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Bouk ti eno Yesu la di zeimema nanghei danghei ti. Gyeik ingwei zeimema woy, eno e xe xel betiyeing ti neil wou e bei, “Tambiy Ngandoung, teyoxe xa en zeimeing mema, nambei Yoan mi teyoxe e xe xel betiyeing o.” ");
INSERT INTO tbx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Moxo neil wou xel, “Gyeik ingwei xam ambei zeimemamim eno xam a neil ambei nye: “‘Mang, wa leim e mi mendei vambuing, wa xe tete lalei enam. ");
INSERT INTO tbx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Wa mi bong xa mi lul yaeing wou xa e teyei lek bouk titi. ");
INSERT INTO tbx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Me wa semaleeng sewokeing wei xa yo, en xa is ambei nyon xa mi semaleeng sewokeing wei xel sapa wong wou xa yo. Me wa seng bong xa na eivek axeing.’” ");
INSERT INTO tbx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Woyom moxo neil wou xel, “Wangwei xam on ti xe gweleeng ti, me e la wou moxo eivek boukeing masenghoing me neil wou, ‘Gweleeng, wang bong belet yayal wou ay, ");
INSERT INTO tbx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","en nambei a xe gweleeng ti mi tupwou sakwaing me lam wou ay, ekom lul yaeing wei ambei bong wou e eno ma.’ ");
INSERT INTO tbx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Woyom tambiy tiwei toundei lalei eno lewexe bei, ‘Wa seng bo pok wou ay. En xomek mya a xey woy, me yakyak di yeip is a lek zek. A se teyeimbei qandi lek me na bong lulul ti wou wang.’ ");
INSERT INTO tbx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","A neil wou xam, moxo tyek se qandi lek me bong belet wou e en nambei inyei e xe gweleeng o, qe en ingwei toungale nikanzek wou e yo, moxo tyek qandi me bong lulul wou e teyei lek ingwei e lalei vind o. ");
INSERT INTO tbx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Om a neil wou xam: Xam teling on tyek bong wou xam, xam ghe gwimexe on tyek xam ghe gweiwou, xam ghe nyeis memamim lek qapomb on tyek natax en xam. ");
INSERT INTO tbx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","En xel sapa wei mi teling en vatiyeiw eno xel mi qou, xel eti yeiw wei mi yimexe eno mi yeiwou, me eti yeiw wei mi leis memend lek qapomb eno mi tax. ");
INSERT INTO tbx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Xam mayeiyeiw on, eti wangwei neum embei teling wang en woing ti, tyek wang bong myeiy wou e? ");
INSERT INTO tbx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O wangwei e teling en neughalus ti, tyek wang bong boklevek wou e? ");
INSERT INTO tbx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nambei nyon xam wei sewokeing on, ekom xam ghe mi woulek lul nimza wei xam a being bong wou neumyeiw o. Yond xam ghe boulek bei xam Mamim wei toundei eivek tyoung gheyapu nei tyek bong Laweeng Vambuing wou xel wei mi teling e yo.” ");
INSERT INTO tbx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yesu tiy memo wei myatu yo veil tambiy ti. Gyeik ingwei memo la veil eno tambiy wei myatu eno luk, om moux alis vex ngenong yei me etek. ");
INSERT INTO tbx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ekom xel on valu neil embei, “En nikanzek wei Belsebul, gyovaxa wei memo, eno e mi tiy memo nangya.” ");
INSERT INTO tbx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Xel valu axe moxo me neil, “Wang bong dee wei lulvako yo ti en xa boulek bei Anutu wong wang lam.” ");
INSERT INTO tbx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu yei woueing nalei wei xel o me neil wou xel, “Tete lalei wei eti yeiw dembuma me wong vevek wou emaxow eno tyek bo nol, me wangwei xomek ti dembuma me bong vevek wouma eno tyek detei eivek. ");
INSERT INTO tbx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wangwei Sandang xe xel dembuma me bong vevek wouma, on tyek e xe tete lalei bale nikanzek ambei nya? A neil tine en nambei xam ghe neimbei a tiy memo nangya Belsebul. ");
INSERT INTO tbx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ekom wangwei a tiy memo na veil angya Belsebul nikanzek nei, ond eti mi vind xel wei xam o me xel mi tiy memo yon la myayaing? Om xel wei xam eno tyek talex wou xam bei qayeeng wei xam on se la wo bombek. ");
INSERT INTO tbx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ekom wangwei a tiy memo nangya Anutu mema deyis, on Anutu xe tete lalei lam wou xam. ");
INSERT INTO tbx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Wangwei moux wei nikanzek o ti bale zeyi beeng is lulul wei vevek o, on tyek e xe lulul a toumendei embo nimza. ");
INSERT INTO tbx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ekom wangwei xelti nikanzek ghanaw e veil, on tyek na bo vevek wou e me bou lul vevek wei di qou nikanzek eivek o veil e, de dembu e ning lulul wou xel ba. ");
INSERT INTO tbx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Xel eti yeiw wei se mindei is ay eno mi wo vevek wou ay, me eti yeiw wei se mi qeku moux alis vex wou is ay, eno mi tiy xel lala.” ");
INSERT INTO tbx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Gyeik ingwei laweeng nilaxes ti lam myayaing veil moux ti, on tyek na ghavineeng eivek tembuing wei memiing ma veil o. Me gyei beyeeng wei embei na qou laweeng o, ek se gyeiwou ti. Woyom tyek na neil, ‘Tyek a nox me na eivek xomek wei a lam veil o.’ ");
INSERT INTO tbx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Gyeik ingwei loum tei eno yei xomek xel pepa e wo vako me menyex wou. ");
INSERT INTO tbx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Woyom la qou laweeng amba lim yuw wei xel ghanaw e veil en kwa nol o, me xel la dei eivek xomek lalei tiyon. Om deing wei tambiy tiyon eno wo nol ghanaw ingwei tax o.” ");
INSERT INTO tbx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ka Yesu di neil ti beimambei ne, eno vex wei toundei eivek qekueing ama yon ti taxe la wou e, “Vex tiwei wou wang me wo luul wou wang eno e mi bo xeilala.” ");
INSERT INTO tbx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Moxo byex e mya leit bei, “Embong ondek xey a neimbei xel wei mi ngo Anutu xe xoulek me betiwou eno na mi bo xeindlala.” ");
INSERT INTO tbx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ka moux alis vex ngenong di lam me nyouk, om Yesu neil, “Xomaxoneing wei gweimbeeng ne nilul ayang. Xel teling en embei gyei dee wei lulvako yo, ekom tyek xel se gyei ti, qe tyek xel gyei lulvako wei Yona yo. ");
INSERT INTO tbx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","En Yona wong ambei dee wou Niniweyeiw, om nambei nyon is, Xomaxoneing Neu Moux tyek bong ambei dee wou xomaxoneing wei gweimbeeng ne. ");
INSERT INTO tbx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“De kwin wei xonei eno tyek qandi lek bouk wei wongeing qayeeng me bo qayeeng en xomaxoneing wei gweimbeeng ne me na neil xel xe nilul teyei, en lam anghei tembuing myasepu en embei ngo Salomo xe lupeyei, me gweimbeeng ne tambiy ti ghanaw Salomo eno toundei inye. ");
INSERT INTO tbx_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Lek bouk wei ngoeing qayeeng eno xel wei Niniwe tyek qandi me bale me bo qayeeng en xomaxoneing wei gweimbeeng ne me na neil xel xe nilul teyei, en xel pekwi xow gyeik ingwei Yona la neil xoulek o. Wei, gweimbeeng ne tambiy ti ghanaw Yona veil eno lam toundei inye. ");
INSERT INTO tbx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Xelti se mi byex eivek lam me toung eivek beyeeng wei embei bund xeiyaing o, o toung eivek deng lalei. Qe xel mi toung leklam vaxa gheyapu, om xel wei la lalei eno mi yei xeiyaing. ");
INSERT INTO tbx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Wa mamghalus on lam wei wa neing o. Wangwei wa mamghalus luw xouing a toumendei embo nimza, on tyek wa neing dalus na pup en xeiyaing. Ekom wangwei luw xouing bo nol on tyek wa neing na pup en mapetok ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Om wang gweiteyei, en xeiyaing wei toundei eivek wang on se bo mapetok. ");
INSERT INTO tbx_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nambei nyon wangwei wa neing dalus on na pup en xeiyaing, me boukeing e ma veil wa neing danghei ti, on wa neing dalus wo xeiyaing, nambei ingwei xeiyaing wei lam mi byex lek wang o.” ");
INSERT INTO tbx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Gyeik ingwei Yesu neil xoulek ma yo, Parisi ti teling bei e na gya is e, om moxo eivek la lalei me la yeip pepeeng lek zek me ya. ");
INSERT INTO tbx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ekom Parisi yei ingwei Yesu se lipek atax ekom ya, om di wounalei ngenong. ");
INSERT INTO tbx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Woyom Tambiy Ngandoung neil wou e, “Xam Parisi ghe mi sekweyexe mayamya luw dipek demi, ekom xam laleimim on pup en kwa eivekeing me nilul. ");
INSERT INTO tbx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xam xomaxoneing on bandol! Beip tambiy tiwei betiy lulul on demi eno se betiy lalei is? ");
INSERT INTO tbx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ekom xam ghe bong vati wei toundei eivek dipek lalei eno wou xel wei kanyo yo, on tyek xam ghe bo vako yang wou Anutu manghalus. ");
INSERT INTO tbx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Xam Parisi ghe gwaleeng amim en nimaying, en xam ghe mi wong ti eivek xoumeeng xoing senyeing me lulul eivek xuk wei xam o, ekom xam ghe saing kwa wei bombek me kwa wei lalei vineing Anutu yo, om xam betiwou kwa ti beimambei yon de xam ghe bong luw xouing bo nimza. ");
INSERT INTO tbx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Xam Parisi ghe gwaleeng amim en nimaying, en nambei xam laleimim mi vind sia nimza wei xomek qekueing ama yo, me xam ambei xel a mi neil bendiyeing teiv wou xam eivek beyeeng wei xel mi wo vateivek lek lulul o. ");
INSERT INTO tbx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Xam ghe gwaleeng amim en nimaying, en xam ghe xok leiveeng meyeing xupekeing wei xomaxoneing qeilek en xel se woulek.” ");
INSERT INTO tbx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Xel wei lupeyei ngandoung en petieing wei Mose yo ti neil wou Yesu, “Putoung, gyeik wang neil qayeeng ambei nyon, eno wang neil xa is.” ");
INSERT INTO tbx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu byex e vya leit bei, “Xam wei lumimpeyei ngandoung en petieing wei Mose eno xam ghe gwaleeng amim en nimaying, en nambei xam ghe mi qou lul nimaying me ghe toung lek xomaxoneing me xel mi wo pok lek qaleing, dom xam memamim ti se mi vind xel.” ");
INSERT INTO tbx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Xam ghe gwaleeng amim en nimaying, en nambei xam ghe mi ev leiveeng meyeing wei xel poropet, wei bumyeiw leis xel mey o. ");
INSERT INTO tbx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Om xam ghe talex lek bei xam ghe lenghek lek vati wei bumyeiw wong o, xel leis xel poropet mey, de xam ghe kwelexe xel xe eeng wei meyeing o. ");
INSERT INTO tbx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“En nambei tiyon, om eivek Anutu xe lupeyei nimza eno neil, ‘Tyek a bong xel poropet me sinaleyeiw wou xel, tyek xel nyeis xel valu mey de bo nol wou xel valu.’ ");
INSERT INTO tbx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nambei nyon xam xomaxoneing wei gweimbeeng ne tyek na qou myaveweeng lek gyand wei xel poropet, wei xel leis gyeik bouk wei Anutu toung tembuing o, ");
INSERT INTO tbx_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","nanghei Abel gyand me e mi la Sakalias gyand, tiwei xel leis e mey eivek qeind aluw xomek vambuing senghoing o. Ee, a neil wou xam, xomaxoneing wei gweimbeeng ne tyek na qou myaveweeng tiyon dalus. ");
INSERT INTO tbx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Xam wei lumimpeyei ngandoung en petieing wei Mose yo ghe gwaleeng amim en nimaying. En xam ghe zeim ki wei qoueing lupeyei nimza yo veil. Xam venaxow seng la eivek, de xam ghe nale zeyi xel wei embei na eivek o.” ");
INSERT INTO tbx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Gyeik ingwei Yesu la veil inyon, eno xel Parisi me xel putoung wei petieing o laleind wo nol wou e, om xel nale zeyi e nangya teling wei nikanzek o. ");
INSERT INTO tbx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Xel di axe e en embei bo qayeeng en e, en ingwei e neil qayeeng ti na sewok o. ");
INSERT INTO tbx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Dekalekom xomaxoneing tausen ngenongakes qekuma, omva xel di qeilekama, om Yesu neil wou e xe xel betiyeing atax bei, “Xam ghe gweiteyei xow en yis wei Parisi mi wong o, en xel on myend yuw. ");
INSERT INTO tbx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Lul dalus wei xel vun eno tyek gyeip yaing wou xel, me lul dalus wei mi yeip xupekeing eno tyek nam myayaing. ");
INSERT INTO tbx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Qayeeng dalus wei xam ghe neil eivek mapetok eno tyek moux alis vex a ngo wou xeiyaing. Me qayeeng dalus wei xam ghe ngoung wouma eivek xomek lalei, eno tyek xel bale lek xomek demi me taxe na wou xel sapa.” ");
INSERT INTO tbx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Xam wei axe gweleeng o, a neil wou xam bei, xam seng gwaleeng en xomaxoneing wei mi leis neing mey yo, dom tyek xel se nox me na bong lulti no. ");
INSERT INTO tbx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ekom tyek a talex wou xam en tambiy tiwei xam a mi gwaleeng en e yo. Xam waleeng en e tiwei tyek nyeis neing a mey, dekakom e xe nikanzek teyeimbei banex xam ghe na eivek nenyex wei luta yo. Ee, a neil wou xam, xam ghe gwaleeng en e. ");
INSERT INTO tbx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Beip xel mi wong vateivek lek menek tetoung lim en selewa gyand nayak yuw? Ekom Anutu nalei se mi ma xel on titi. ");
INSERT INTO tbx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Neing, xam lumim velus on Anutu pyaw memawou dalus. Xam seng gwaleeng, en xam ghe ghanaw tetoung ngenongakes veil. ");
INSERT INTO tbx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“A neil wou xam, xelti embei neilteyei wou moux alis vex en ay, ond Xomaxoneing Neu Moux tyek na neil e teyei wou Anutu xe angela. ");
INSERT INTO tbx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ekom xelti embei dax a vun wou moux alis vex, ond tyek a dax e vun wou Anutu xe angela mendghalus. ");
INSERT INTO tbx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Me xel sapa wei embei neil qayeeng nilul lek Xomaxoneing Neu Moux ond tyek Anutu semaleeng sewokeing wei xel o. Ekom xelti embei baluk yak lek Laweeng Vambuing on tyek Anutu se semaleeng sewokeing wei e yo veil. ");
INSERT INTO tbx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Gyeik ingwei xel a qou xam me na eivek xomek qekueing ama wou xel gyovaxa me xel wei lei ngandoung o, ond xam seng bo lalei maying bei, ‘Tyek xa bale zeyi xow ambei nya, o tyek xa neil vati?’ ");
INSERT INTO tbx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Lek bouk kayon eno Laweeng Vambuing tyek talex wou xam en vati wei xam ambei neil o.” ");
INSERT INTO tbx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Xel wei toundei eivek qendu ngandoung on ti neil wou e, “Putoung, wa neil wou a ling en e pum lulul wei mang ghanaw eno is ay.” ");
INSERT INTO tbx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu neil elox, “Moux, eti beyal ay en ngoeing qayeeng bei a pum lulul eivek senghoing wou muw?” ");
INSERT INTO tbx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Woyom moxo neil wou xel, “Xam ghe gweiteyei xow, en xam seng gweimam lek lulul leimalei. En mapieing wei xomaxoneing eno se toundei eivek e xe lulul ngenong on.” ");
INSERT INTO tbx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Me moxo neil wou xel en qayeeng pakeing tine: “Tambiy wei lulul ana eno xe tembuing wong lulul ngenong wo neing nimza. ");
INSERT INTO tbx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Moxo venaxow wounalei bei, ‘Om tyek a bo vati? A xomek ma en ingwei ambei qeku a xe lulul yaeing eivek o.’ ");
INSERT INTO tbx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Woyom moxo neil embei, ‘Inye vati wei ambei bong o. Tyek a lelolexe xomek yaeing, dom na dev ingwei ngandoung ngandoung o, me nanghei inyon eno tyek a qeku a xe lulul neing dalus me a xe lulul nimzamza dalus eivek. ");
INSERT INTO tbx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Me tyek a neil wou xow bei, “A teyei woy, a xe lulul nimzamza ngenong a toung e toundei teyei lek vakovek qeskes. Tyek a mendei embo nimza, me mendi bong mangha me na num lek me na bong xeinglala.” ’ ");
INSERT INTO tbx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ekom Anutu neil wou e, ‘Wa bandol! Boukeing tine tyek wa mey. De woyom tyek eti na qou lulul wei wang mi qekuwou xow on?’ ");
INSERT INTO tbx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Tiyon tyek na teyei lek xel eti yeiw wei mi qeku lulul wou venaxow o de se wo lulul ana en lulul wei Anutu yo.” ");
INSERT INTO tbx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Woyom Yesu neil wou e xe xel betiyeing bei, “A neil wou xam, xam seng bou naleimim en mapieing wei xam o me na neimbei, ‘Tyek xey a gha vati?’ O xam seng bou naleimim en neing wei xam o me na neimbei, ‘Tyek xey a byex vati?’ ");
INSERT INTO tbx_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mapieing on ghanaw lulul yaeing me neing on ghanaw teimb. ");
INSERT INTO tbx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Xam ghe gwei aoho xel se mi wong xuk o qeku lulul yaeing. Xel se mi ev xomek yaeing, o xomek wei qekueing lulul yaeing eivek o, qe Anutu mi vet xel. De xam xomaxoneing on ghe ghanaw menek veil. ");
INSERT INTO tbx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wangwei xam ti me di bou naleimim ngenong nei, on tyek wa tetulexe seivma nayaka wou wa xe mapieing? ");
INSERT INTO tbx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Wangwei xam seng bong lulul nayak ambei nyon, ond xam ghe di wou naleimim ngenong en lulul valu betiy en va? ");
INSERT INTO tbx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Xam ghe gwei qapaing, bei xel mi tyip ambei nya. Xel se mi wong pok, o xel se mi duw teimb. Ekom a neil wou xam Salomo byex e xe teimb nimzamza, ekom se wo nimza nambei qapaing beimambei ne ti. ");
INSERT INTO tbx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Wangwei Anutu mi vunekwou qapaing wei mi nale lek beyeeng nambei nyon, wei toungale gweimbeeng de yanyeing eno tyek xel banex ena eivek nenyex, om lu vamva eno Anutu se mi vunekwou xam? Xam xe wongeingis on nayaka. ");
INSERT INTO tbx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Me xam seng bou naleimim ngenong bei tyek xam ghe gwa vati, me tyek xam a num vati. Om xam seng bou naleimim ngenong. ");
INSERT INTO tbx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Xel amba wei tembuing tambak o mi wong me yei en xel embei qou lulul tiyon dalus, de xam mamim woulek lulul wei xam naleimim vind o. ");
INSERT INTO tbx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ekom xam a mi gwimexe Anutu xe tete lalei bole, dekakom e bong lulul on lek mapu wou xam is ambei inyon. ");
INSERT INTO tbx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Xam sipsip neuyeiw nayak on seng gwaleeng, en xam mamim lalei wo nimza en embei bong tete lalei wou xam. ");
INSERT INTO tbx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Xam ghe bong vateivek lek lulul wei xam o de ghe bong malew on wou xel wei kanyo yo. Xam a qou xam xe vaxak malew wei se mi wo nol o. Xam qeku lulul nimzamza wei tyoung gheyapu wei mindei luta yo, nanghei inyei xel panaxeing se mi la paviy, de xevek se mi qateiv. ");
INSERT INTO tbx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nanghei ingwei wa xe lulul nimzamza toundei ghei nei, eno wa laleim tyek na mendei is nanghei inyon. ");
INSERT INTO tbx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Xam davex qaeing lek me ghe gweiwou xow en xuk de mendi gweiteyei xam xe lam en emdi tum, ");
INSERT INTO tbx_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","nambei xel moux wei mi a xe xel xe teiv wei embei noum nanghei mata ngandoung wei iingama yo. En kandek gyeik ingwei embei noum nyeis mema lek qapomb, ond xel a tax qapomb daing en e. ");
INSERT INTO tbx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Inyon tyek bo nimza en xel xukxe wei toundei me yeiwou xow me axe xel xe teiv gyeik ingwei e noum me gyei xel o. A neil wou xam zonghek, teiv on tyek bunekwou xow en teimb wei xuk o de na neil wou xel me xel mendei qendu ti lek lelek de bet xel. ");
INSERT INTO tbx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Xel xukxe wei toundei me axe xel xe teiv wei loum yei xel yeiwou xow, o gyeik ingwei la boukeing masenghoing, o ingwei xeiyaing nexla yo ond xel bo xeindlala. ");
INSERT INTO tbx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ekom xam ghe boulek tine bei wangwei xomek ma boulek seivma wei xel panaxeing embei nam o, on tyek se bong xel dembu e beeng me na lalei. ");
INSERT INTO tbx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Xam is ambei nyon xam ghe gweiwou xow boy, en Xomaxoneing Neu Moux tyek nam lek seivma gyeik ingwei xam seng wou naleimim bei tyek nam o.” ");
INSERT INTO tbx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petele teling, “Tambiy Ngandoung, inye wang di neil qayeeng pakeing on wou xa maxow o wou xel sapa?” ");
INSERT INTO tbx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tambiy Ngandoung lewexe me neil embei, “Xukxe eti ingwei lupeyei nimza me mi wong xuk wo nimza yo? Wei e xe teiv beyal e la tax bei e gyeiteyei e xe xukxe me na mi dembu lulul yaeing wou xel lek bouk bombek. ");
INSERT INTO tbx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Wangwei xukxe tiyon di wong xuk me teiv loumelam yei e di wong o yond embo xeilala. ");
INSERT INTO tbx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","A neil wou xam zonghek, moxo tyek beyal xukxe tiyon bo lei ngandoung me gyeiteyei e xe lulul dalus. ");
INSERT INTO tbx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ekom xukxe tiyon se neil wou xow bei, ‘Axe teiv la dei enden de se loum,’ om di leis xel xukxe moux me xukxe vex de di ya me num me num memiing nikanzek me wo nol. ");
INSERT INTO tbx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Xukxe tiyon xe teiv tyek noum lek bouk ti gyeik ingwei se di toung ma en e yo me seivma wei se woulek o. Teiv tyek qateiv xukxe tiyon bo tiptip me na toung e na is xel wei se mi wongis o. ");
INSERT INTO tbx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Xukxe wei woulek e xe teiv lalei, ekom se yeiwou xow me se wong vati wei e xe teiv neil on tyek xel nyeis e lumama. ");
INSERT INTO tbx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ekom xukxe wei se woulek e xe teiv lalei ekom wong lulti sewok eno tyek na qou myaveweeng de xel nyeis e nayaka. Xel wei qou lulul ngenong eno tyek xel bong lulul ngenong nox zeyi. Wangwei xel bong lulul ngenong wou tambiy ti on tyek xel teling bei embong lulul ngenong nox zeyi. ");
INSERT INTO tbx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“A lam me na qou nenyex me na lam me na nex e la lek tembuing, de a laleing vind bei e tum. ");
INSERT INTO tbx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ambei qou lipekeing nelu ti ekom a laleing wo nimaying en a seng ghei qou. ");
INSERT INTO tbx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Xam ghe wou naleimim bei a qou lalei vevopeing me na lam lek tembuing? Ma, a neil wou xam bei a lam en ambei dembu xomaxoneing. ");
INSERT INTO tbx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dom gweimbeeng ne me e mi na, eno moux alis vex lim e toumendei eivek xomek ti, ond tyek xel dembuma na yuw, yal tyek bo nol wou yuw de yuw tyek bo nol wou yal. ");
INSERT INTO tbx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Tyek xel dembuma, ma tyek bo nol wou neu moux de neu moux tyek bo nol wou ma, ta tyek bo nol wou neu vex de neu vex tyek bo nol wou ta, yeing avexta tyek bo nol wou yeing vexawo de yeing vexawo tyek bo nol wou yeing avexta.” ");
INSERT INTO tbx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Woyom Yesu neil wou moux alis vex ngenong on bei, “Gyeik ingwei xam ghe wei laxap ti lam tyip inya xeinei, lutika eno xam ghe neimbei ‘Luing tyek nam,’ eno luing lam. ");
INSERT INTO tbx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Me gyeik ingwei laweeng vei nanghei inya xonei eno xam ghe neimbei, ‘Inye bouk wei seiv tyek bo myavanei yo,’ eno wo neing lek. ");
INSERT INTO tbx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Xam wei myamim yuw o! Xam ghe mi wei mamim wou lulul wei tembuing ne me tyoung o. Nambei nya ekom xam seng wei mamim wou lulul wei di qandi lek gweimbeeng ne yo? ");
INSERT INTO tbx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Nambei nya wa seng mi wou kwam en xow me ghe woulek bei vati la wo bombek bei wang bong? ");
INSERT INTO tbx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wangwei wam di na wou sakwaing is tambiy wei embei bong qayeeng en wang wou tambiy wei mi zeim qayeeng yon wang bo nimkanzek me menyex wou qayeeng is e. Enok na qou wang me na wou tambiy wei mi zeim qayeeng de zeim qayeeng me bo wang na wou beyeiv de beyeiv na toung wang na eivek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","A neil wou wang, wa seng teyei being na myayaing qe ka wang bo malew dalus wei xel lax wou wang o zeyi bole.” ");
INSERT INTO tbx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lek bouk kayon eno xel valu wei toundei inyon eno neil wou Yesu en ingwei Pailat leis moux wei Galili nei valu mey gyeik xel di sei xound o. Me xel gyand semaleeng is leliy gyand. ");
INSERT INTO tbx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu neil wou xel bei, “Xam ghe wou naleimim bei xel Galili yon wong sewokeing ngenong ghanaw Galili valu dalus omek lulti yon qandi wou xel? ");
INSERT INTO tbx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma, a neil wou xam, xam pekwi xow, ek na ma on xam dalus tyek na mey is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","De nambei nya en 18 moux alis vex wei xomek vaxading pek me leis xel mey anghei Siloam o? Xam ghe wou naleimim bei xel wong sewokeing ghanaw xel valu dalus wei toundei eivek Yerusalem nei? ");
INSERT INTO tbx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","A neil wou xam bei, ma! Ekom wangwei xam se pekwi xow, on tyek xam dalus na mey is ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Woyom Yesu neil qayeeng pakeing tine, “Tambiy ti ev xax basunghek eivek e xe xuk wain, me moxo la en embei gyei xax on neing wei toukami lek o, ekom se yei neing ti, ");
INSERT INTO tbx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","om neil wou tambiy wei mi yeiteyei xuk wain o, ‘Eivek vakovek qes yal eno a mi lam a xei xax basunghek on neing, ekom a se xei neing ti, om vuv veil! Nambei nya e puw tembuing denzi bandaing?’ ");
INSERT INTO tbx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Ekom xukxe neil e lox wou bei, ‘Teiv, wong e toukale vakovek qes tine is me a ev tembuing vivekwou me na toung lul denzi yo eivek e qes. ");
INSERT INTO tbx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wangwei e buk neing lek vakovek qes nge yus on nimza, ek na ma ond wang buv veil.’” ");
INSERT INTO tbx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Lek Sabat ti eno Yesu di teyoxe xel eivek xomek qekueing ama ti, ");
INSERT INTO tbx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","me vex ti toundei inyon, eno laweeng ti wong e demi wo qendu teyei lek vakovek qes 18. Me vexo se teyeimbei bale bombek no. ");
INSERT INTO tbx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Gyeik ingwei Yesu yei vexo eno taxe e lam de neil wou e, “Vex, wa xe vanei ma veil wang.” ");
INSERT INTO tbx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Woyom moxo li mema lek e, de lutika eno vexo nale bombek me di sanghoxe Anutu. ");
INSERT INTO tbx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ekom gyovaxa wei xomek qekueing ama eno lalei wo vanei, en ingwei Yesu wong vanei wo nimzalek Sabat o, om neil wou xomaxoneing bei, “Inye bouk wei wongeing xuk eno limti toundei, om xam ghe nam en e gyeiwou xam lek bouk on ti, ek se lek bouk wei Sabat o.” ");
INSERT INTO tbx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Tambiy Ngandoung lewexe wou e, “Xam wei myamim yuw o, xam titi seng la mi tul yis veil xam xe manghaxo o dongi lek Sabat eivek xomek leliy, me dandiy me la bei na bong memiing wou xel? ");
INSERT INTO tbx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","De vex tine nye Apraham neu, Sandang qo e xoun teyei lek vakovek qes 18, om se teyeimbei a tul lul tiwei qo e xoun on lek bouk wei Sabat o de ena nivax?” ");
INSERT INTO tbx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Gyeik ingwei moxo neil tine, eno xel dalus wei pesek e yon ninyaleeng, de xomaxoneing wo xeindlala en lul nimza maseim dalus wei Yesu wong o. ");
INSERT INTO tbx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Woyom Yesu teling bei, “Anutu xe tete lalei teyei lek vati? Tyek a neil lek vati? ");
INSERT INTO tbx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Inyon nambei mastet vei, wei tambiy ti qou me ev eivek e xe xuk yaeing. Mastet on ling me wo ngandoung nambei xax teta me menek lam mi qo lewis lek memama.” ");
INSERT INTO tbx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Moxo lox teling no, “Tyek a neil Anutu xe tete lalei lek vati? ");
INSERT INTO tbx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Inyon nambei yis wei vex ti qou me semaleeng is palawa ngandoung wei dipekta yo, me e wong palawa dalus on vuk lek.” ");
INSERT INTO tbx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Woyom Yesu di tupwou sakwaing me la Yerusalem. Om la eivek beyeeng dalus me beyeeng nayak me teyoxe xomaxoneing. ");
INSERT INTO tbx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Xelti teling wou embei, “Tambiy Ngandoung, inye xomaxoneing nuyuw tyek Anutu devind xel?” Moxo neil wou xel, ");
INSERT INTO tbx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Xam ghe bong nimkanzek me ghe na eivek xomek mya wei nayak o. A neil wou xam bei, xel ngenongakes wong me yei en embei na eivek, ekom xel se teyei. ");
INSERT INTO tbx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Gyeik xomek ma qandi lek me xey qapomb zeyi, tyek xam bale myayaing me ghe nyeis memamim lek qapomb me taxe bei, ‘Teiv, tax qapomb veil xa.’ “Ekom tyek na neil wou xam bei, ‘A loung en xam, xam ghe lam anghei inya?’ ");
INSERT INTO tbx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Woyom tyek xam a neil wou bei, ‘Xa xa me na num is wang, me wang nale eivek xa xe sakwaing mema nayak me ghe teyoxe wou xa.’ ");
INSERT INTO tbx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Ekom moxo tyek na neil enoum bei, ‘A loung en xam, xam ghe lam anghei inya. Xam la veil ay en xam on ghe wong kwa nilul!’ ");
INSERT INTO tbx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Tyek xam ghe deeng me zanga newoumim bo nyiknyik nanghei inyon, gyeik ingwei xam ghe gwei Apraham, me Isaka me Yakop me xel poropet dalus eivek Anutu xe tete lalei yo, dom xam venaxow eno tyek Anutu banex xam ghe na myayaing. ");
INSERT INTO tbx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Xomaxoneing tyek nam anghei ninei me xeinei me punei me xonei, me tyek nam mendei me gya mata eivek Anutu xe tete lalei. ");
INSERT INTO tbx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","De ngo le, xel wei dei yus eno tyek na mendei mya de xel wei dei mya eno tyek nox mendei yus.” ");
INSERT INTO tbx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lek bouk kayon eno Parisi valu lam neil wou Yesu bei, “Wang na bange veil beyeeng ne en Herot embei nyeis wa mey.” ");
INSERT INTO tbx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu neil elox wou xel, “Xam ghe na neil wou naw bemeeng on bei, ‘Gweimbeeng me yanyeing eno tyek a tiy memo na me na bong xomaxoneing wei vanei yo bo nimzalek. De bouk yal eno tyek a bong axe xuk dalus na ma.’ ");
INSERT INTO tbx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ee gweimbeeng me yanyeing, me yanyeing nge eno tyek a na, me neing ayang inye se nimza bei poropet ti e mey anghei myayaing veil Yerusalem! ");
INSERT INTO tbx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Yerusalem, Yerusalem, wang mi leis xel poropet mey, me ghe nex xel wei Anutu wong e lam wou wang o en qakous, taxombouk eno a mi wong en ambei qeku neumyeiw dalus lekti nambei qouklex ta mi qeku neuyeiw eivek banis o. Ekom xam laleimim se mi vind. ");
INSERT INTO tbx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wei, kale tyek wa bam lelolexe me gyeip bandaing. A neil wou xam bei, tyek xam seng gwei a no, qe ka xam a neimbei, ‘Anutu bong mata wou tambiy tiwei lam lek Tambiy Ngandoung lei yo.’” ");
INSERT INTO tbx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Sabat ti, eno Yesu la ya eivek xomek wei lei ngandoung wei Parisi eno ti, de xel di yei e teyei teyei. ");
INSERT INTO tbx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tambiy nivukeing ti eno toundei mya en e nanghei inyon. ");
INSERT INTO tbx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu teling wou xel Parisi is xel lupeyei ngandoung wei petieing o bei, “Beip inyei teyei lek bei xey a bong xel wei vanei eno bo nimzalek Sabat, o ma?” ");
INSERT INTO tbx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ekom xel toundei kanzek. Om zeim tambiy on me wong e wo nimzalek de wong e la. ");
INSERT INTO tbx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Woyom moxo teling xel. “Wangwei xam on ti neum moux ti o manghaxo ti deivek leiveeng memiing lek bouk wei Sabat o, on tyek wa seng na puw enoum myayaing daing?” ");
INSERT INTO tbx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","De xel se neil lulti. ");
INSERT INTO tbx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Gyeik Yesu yei xel wei di lam en mata eno di beyal beyeeng nimza wei mya yo, om moxo neil qayeeng pakeing tine wou xel: ");
INSERT INTO tbx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Gyeik xelti embei taxe wang en mata wei iingama yo, on wa seng na mendei lek leitata bend. Enok ambei nyon tambiy wei e xe mata yon taxe tambiy nge wei lei ghanaw wang o. ");
INSERT INTO tbx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Wangwei tambiy wei taxe muw on, tyek nam a neil wou wang, ‘Wong beyeeng wei wang on wou tambiy tine,’ woyom tyek wa nim gyaleeng de ghe na mendei demiyang. ");
INSERT INTO tbx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ekom wangwei xelti taxe wang en mata ond wang na mendei demi, deka tambiy tiwei taxe wang o nam, ond tyek na neil wou wang, ‘Gweleeng wang na mendei lek beyeeng nimza wei mya nei.’ Woyom tyek wa qou leim ngandoung eivek laxousyeiw dalus mend. ");
INSERT INTO tbx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","En xel sapa wei mi qoxexow eno tyek Anutu beoux xel, de eti yeiw wei mi beoux xow eno Anutu tyek sanghoxe xel.” ");
INSERT INTO tbx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Woyom Yesu neil wou tambiy tiwei taxe e yo bei, “Wangwei wang bong mata ti nei, on wa se taxe wa xe gweleeng, o limyeiw o nimpapu, o xel wei lulul ana wei wa bam qes o. Wangwei wang bong ambei nyon nei on tyek xel taxe wang nox me na gwa is xel no, ond inyon xel wong xouveing loum zeyi wou wang. ");
INSERT INTO tbx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ekom gyeik ingwei wa being bo mata, yon wa taxe xel kanyo, xel wei bezomb o, xel wei vaxa nol o me matekeing o. ");
INSERT INTO tbx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","On tyek wa mendei eivek mata lalei. Xel on tyek se bong xouveing noum wou wang no. Qe Anutu tyek bo xouveing noum wou wang gyeik ingwei xel wei bombek o embei qandi lek veil meyeing o.” ");
INSERT INTO tbx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Gyeik xel wei di ya is e lek lelek on ti ngo inyon om neil wou Yesu, “Mata e gyeip wou tambiy wei tyek na gya eivek Anutu xe tete lalei yo.” ");
INSERT INTO tbx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Yesu neil elox wou e bei, “Tambiy ti embei bong mata ngandoung ti me wong qayeeng la wou xel ngenongakes. ");
INSERT INTO tbx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lek bouk kawei mata eno moxo wong e xe xukxe la neil wou xel wei wong qayeeng la wou xel o. Om xukxe neil, ‘Wei, xam lam. En gweimbeeng xa menyex wou lulul dalus woy.’ ");
INSERT INTO tbx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Ekom xel dalus pakei me neil embei se na. Ti myaxeeng neil embei, ‘A mouk a xouv xuk yaeing ti, om tyek a na ghei, om tyek a se nak.’ ");
INSERT INTO tbx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Nge neil embei, ‘A mouk a xouv manghaxo xoumeeng om ambei na teyoxe xel me na ghei bei xel wo xuk wo nimza, om tyek a se nak.’ ");
INSERT INTO tbx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Ti neil embei, ‘A mouk a ii vex om tyek a se nak.’ ");
INSERT INTO tbx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Xukxe loumelam neil inyon wou e xe teiv. Woyom xomek ma yon lalei wo vanei me luk niseikeing wou e xe xukxe, ‘Wang na daing me betiwou sakwaing ngandoung me nayak eivek beyeeng tine me na qou xel kanyo, me xel wei bezomb o, me xel wei mend tekeing o, me xel wei vaxend nol o.’ ");
INSERT INTO tbx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Xukxe neil embei, ‘Teiv, a wong ambei ingwei wang neil o, ekom xomek lalei valu nanghei di yeip bandaing.’ ");
INSERT INTO tbx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Woyom teiv on neil wou e xe xukxe, ‘Wang na betiwou sakwaing mema mema me betiwou tete wei xuk o, me baluk nikanzek wou moux alis vex me na qou xel me ghe nam en kandek axe xomek e pup. ");
INSERT INTO tbx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","A neil wou xam bei, xel wei a wong qayeeng la wou xel eno ti tyek se daxe a xe mata nayak ti.’” ");
INSERT INTO tbx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Xel qendu ngandoung di betiy Yesu, om pekwi ma me neil wou xel: ");
INSERT INTO tbx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Wangwei xelti embei nam wou ay, ekom se toung demi wou ma luw ta me venei is neuyeiw, me li moux me li vex, ee, de emaxow xe mapieing, on tyek se bong ambei a xe betiyeing. ");
INSERT INTO tbx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Me xelti embei se qalei e xe xax pepeeng me betiy ay, eno tyek se bong ambei a xe betiyeing. ");
INSERT INTO tbx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Wangwei xel wei xam on ti embei dev xomek vaxading ti. On tyek se na mendei tax me gyei e xe malew wei embei dev xomek o teyei, bei malew teyeimbei tyek dev xomek ema? ");
INSERT INTO tbx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ek wangwei se bong ambei nyon nei, qe balax mundeeng bandaing, de se teyeimbei dev epyap, on tyek xel sapa wei yei eno bo vyend wou e, ");
INSERT INTO tbx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","me na neimbei, ‘Tambiy tine ev xomek atax ekom se teyeimbei dev epyap.’ ");
INSERT INTO tbx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“O wangwei king ti embei na bong vevek wou king nge, on tyek se mendei tax me bounalei bo nimza, beip emaxow xe xel vevek on 10,000, de king nge yon lam is 20,000, om embei gyei bei e teyei? ");
INSERT INTO tbx_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ek wangwei bounalei bei se teyei, on tyek beyal xel valu na baluk is king nge yon nanghei ingwei di lam dingta yo me teling wou e en xel gyeiwou qayeeng wei embei bo lalei vevopeing o. ");
INSERT INTO tbx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Nambei nyon is, wangwei xel wei xam on ti embei se toung demi wou e xe lulul dalus, on tyek se mendei nambei a xe betiyeing. ");
INSERT INTO tbx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Mileeng on nimza, ekom wangwei nenyeing na veil, on tyek wang bong enox bo nenyeing ambei nya no? ");
INSERT INTO tbx_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mileeng ambei nyon eno se nimza bei xey a toung eivek tembuing wei xuk o is manghaxo xei qe wa banex ena. “Xomaxoneing ti nenya bale lek e, ond wong e ngo qayeeng tine.” ");
INSERT INTO tbx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Xel wei mi qou takis o me xel wei sewokeing o xel xouing dalus la qekuma vivekwou Yesu me di ngo e xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ekom xel Parisi lis xel putoung wei petieing o neil e, “Tambiy tine mi qou xel wei sewokeing o is xeilala me mi ya is xel.” ");
INSERT INTO tbx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Woyom Yesu neil qayeeng pakeing tine wou xel: ");
INSERT INTO tbx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Wangwei xam on ti xe sipsip 100, ekom ti nati on tyek se bong 99 on na toumbale eivek beyeeng wei myasapa yo dom na gyimexe tiwei lati yo deka gyeiwou le? ");
INSERT INTO tbx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Me gyeik ingwei yeiwou eno wo xeilala de qalei lek ghandiwek me la beyeeng. ");
INSERT INTO tbx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Woyom taxe e xe xel gweleeng me nipapu wei toundei paviy e yo qekuma me neil wou xel, ‘Xam ghe bong xeimlala is ay, en a xeiwou axe sipsip wei lati yo.’ ");
INSERT INTO tbx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","A neil wou xam eivek sakwaing ambei nyon eno xeilala ngandoung mi qandi eivek tyoung gheyapu nei en sewokeing ti embei pekwi xow o, ghanaw 99 xomaxoneing wei bombek me xuk ma en ingwei embei pekwi xow o. ");
INSERT INTO tbx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“O wangwei vex ti xe malew selewa xoumeeng ekom ti nati. On tyek vexo se byex eivek lam, me pepa xomek me gyimexe embo nimza deka gyeiwou le? ");
INSERT INTO tbx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Me gyeik ingwei vexo yeiwou, eno taxe e xe gweleeng me nipapu qekuma me neil embei, ‘Xam ghe bong xeimlala is ay, en a xeiwou axe selewa wei lati yo.’ ");
INSERT INTO tbx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Eivek sakwaing ambei nyon, eno a neil wou xam, xeilala ngandoung mi qandi wou Anutu xe xel angela mendghalus en ingwei sewokeing ti pekwi xow o.” ");
INSERT INTO tbx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu neil no, “Inye tambiy ti neu moux yayuw. ");
INSERT INTO tbx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nge moun neil wou ma bei, ‘Mang, wa pum wa xe lulul na yuw me ghe bong veweeng wei wambei bong eno wou ay.’ Woyom moxo pum e xe lulul la yuw wou luw. ");
INSERT INTO tbx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Se denlek qe neu nge ghavis qou e xe lulul dalusateiv me la tembuing ba wei dingta yo. Nanghei inyon eno saing ning malew lek kwa nilul wei mi wong o. ");
INSERT INTO tbx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ka e saing ning lulul la ma, eno maxep ngandoung qandi wou tembuing sapa tiyon, om maxepya moxo. ");
INSERT INTO tbx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Om moxo la wong xuk wou tambiy wei tembuing qes o ti, tambiy tiyon wong e la mi yeiteyei e xe xel bok me mi vet. ");
INSERT INTO tbx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Moxo bambou ma om embei gya pil ninavi wei bok di ya yon, ekom xelti se wong lulul ti wou e. ");
INSERT INTO tbx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Gyeik ingwei moxo lu yeipyaing en xow om neil, ‘Mang xe xukxe dalus di qou lulul yaeing ngenong, de nanghei inye eno ambei mey en maxep. ");
INSERT INTO tbx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tyek a nox me na wou mang me na neil wou e bei: Mang, a wo sewokeing wou Anutu me wou wang is. ");
INSERT INTO tbx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Me a se nimza bei wa taxe neum lek ay, qe wang gwei ay ambei wa xe xukxe ti.’ ");
INSERT INTO tbx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Om moxo qandi lek me la wou ma. “Ekom gyeik ingwei nanghei di la dingta eno ma yei e me lalei pyaxow en e. Om moxo veimya me la wou neu me sei mema eivek e de sesuvexe e. ");
INSERT INTO tbx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“De neu neil wou e, ‘Mang, a wo sewokeing wou Anutu me wou wang is. A se nimza bei wa taxe neum lek ay.’ ");
INSERT INTO tbx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Ekom ma neil wou e xe xel xukxe bei, ‘Xam la daing! Me qou teimb ding nimza me byex lek e. De byex ring lek e mema deyis me byex vaxalambes lek e vaxa. ");
INSERT INTO tbx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","De xam ghe na qou manghaxo wei ling tata nei me ghe nyeis e mey. En xey a bo mata me na gha me na bong xeindlala. ");
INSERT INTO tbx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","En a neung ne mey ekom loum wou xey mapieing no. Moxo lati ekom xey a xeiwou e.’ Om xel wo mata me di wo xeindlala. ");
INSERT INTO tbx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Dekalekom neu touk la toundei eivek xuk, gyeik ingwei lam paviy xomek, moxo ngo yengheeng me aweing. ");
INSERT INTO tbx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Om moxo taxe xukxe ti lam me teling wou e, ‘Xel di wong vati?’ ");
INSERT INTO tbx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Xukxe neil wou bei, ‘Lim loumelam om mam leis manghaxo lingheing wei ling tata yo ti en nambei mam qou lim loum nimza.’ ");
INSERT INTO tbx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Neu touk lalei wo vanei om pesek bei se na lalei. Om ma la myayaing me lam neil qayeeng xeiles wou e. ");
INSERT INTO tbx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ekom moxo neil elox wou ma bei, ‘Wei! Vakovek qes dalus eno a mi wong xuk bandaing wou wang me a se mi pyalek wa xe qayeeng. Ekom wa seng wong meme lingheing ti wou ay en a bong xeilala is axe xel gweleeng. ");
INSERT INTO tbx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ekom gyeik wa neum tiwei la saing wa xe lulul lek vex wei mi wong kwapesiv o loum beyeeng, wang leis manghaxo wei ling tata yo wou e!’ ");
INSERT INTO tbx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ma neil wou bei, ‘A neung, wang mindei is ay taxombouk, om lulul dalus wei a ne inye wa xe. ");
INSERT INTO tbx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ekom xey ambei bo xeindlala, me laleind bo nimza en nambei lim mey, ekom toundei mapieing no, moxo lati ekom xey a xeiwou.’” ");
INSERT INTO tbx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu neil wou e xe xel betiyeing bei, “Tambiy wei lulul ana yo ti xe lei ngandoung wei mi yeiteyei xuk o ti mindei. Om xel valu lam me byex qayeeng lek e bei, ‘Wa xe lei ngandoung wo nol wou wa xe lulul.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Om moxo taxe e la lalei me teling wou e, ‘Vati ingwei a ngo en wa xe kwa ne? Wang na menyex wou qayeeng wei xuk wei wang o me na neil wou ay, en tyek wa seng bo lei ngandoung no.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“De lei ngandoung neil wou xow bei, ‘Tyek a bong vati gweimbeeng? Axe teiv zeim xuk veil ay. A ninkanzek ma en ingwei ambei bong xuk wou xel nge me qandax tembuing o, de a ning yaleeng en tayeing lulul. ");
INSERT INTO tbx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A woulek vati wei ambei bong o, om gyeik ingwei a noum veil xuk eno tyek xomaxoneing na qou a me na eivek bend.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Om moxo taxe xel wei qou lul vateivek wou e xe teiv ekom se wong zeyi yo, xel titi mi la lalei, moxo teling tambiy tiwei tax o, ‘Wang qou a xe teiv xe lulul vamva?’ ");
INSERT INTO tbx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Moxo neil embei, ‘800 deng oliv wel.’ “Lei ngandoung neil wou e, ‘Wa qou wa xe qapiya me mendei daing me na byex bei 400 deng.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Woyom moxo teling nge wei yuw o, ‘De wang qou vamva?’ “Tambiy on neil elox bei, ‘1,000 bek wit.’ “Lei ngandoung neil wou e, ‘Wa qou wa xe qapiya me na byex bei 800 bek.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“De teiv woulek vati wei lei ngandoung nilul on wong o, om sanghoxe e lei en wong kwa yon nambei xel wei lupeyei nimza yo. En xomaxoneing wei gweimbeeng ne eno kwa ghanaw veil, eno xel mi woulek sakwaing mema mema wei xel mi wong wou xel venaxow xe xel o, me xel ghanaw xel wei mi betiwou kwa wei xeiyaing o. ");
INSERT INTO tbx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","A neil wou xam, xam ghe bo xuk en malew wei tembuing ne en na puw xel nam me ghe bong gweleeng lek xel en kandek bouk wei qoueing malew ema, on xel a qou xam me na eivek xomek wei deing nimza luta luta yo. ");
INSERT INTO tbx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Wangwei xelti mi gyeiteyei lulul wei nayak o bo nimza on tyek gyeiteyei lulul wei ngandoung o bo nimza. Ek wangwei xelti se mi gyeiteyei lulul wei nayak eno bo bombek on tyek se gyeiteyei lulul wei ngandoung eno bo bombek is. ");
INSERT INTO tbx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Om wangwei xam seng gweiteyei malew wei tembuing ne bo bombek, ond tyek eti bong lulul nimza wei tyoung gheyapu yo wou xam en xam ghe gweiteyei? ");
INSERT INTO tbx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Me wangwei xam seng gweiteyei xel nge xe lulul bo nimza, on eti tyek bong wamaxow xe lulul wou wang? ");
INSERT INTO tbx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Xukxe ti se mi wong xuk wou teiv yayuw. En tyek lalei bo nol wou nge de lalei devind nge. O moxo tyek betiwou nge de na toung demi wou nge. Xam seng teyei bei bo xuk wou Anutu de malew is.” ");
INSERT INTO tbx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Xel Parisi laleind mi vind malew, om xel ngo qayeeng tiyon dalus eno xel wo vyend wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Moxo neil wou xel bei, “Xam ghe mi wong xow wo nimza wou moux alis vex mend, ekom Anutu woulek xam laleimim. Lul vatiyeiw wei moux alis vex wou naleind bei inyon nimza maseim, eno inyon nilul ayang wou Anutu manghalus. ");
INSERT INTO tbx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Qayeeng petieing me qayeeng wei xel poropet o mi yeip me elam tyip wou bouk wei Yoan o. Eivek bouk kayon eno Xoulek Nimza wei Anutu xe tete lalei eno xel di neil e la teyei lek beyeeng sapa, me xel dalusateiv di wo ninkanzek me la eivek. ");
INSERT INTO tbx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Inye se wo pok en ingwei tyoung aluw tembuing malang o. Ekom qayeeng wei xel byex eivek petieing eno ti tyek se nati. ");
INSERT INTO tbx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Xelti embei qateiv iingama wei luw venei de dii vex nge, on wo kwapesiv, de wangwei moux ti dii vex wei leya qateiv e veil iingama yo, on wo kwapesiv.” ");
INSERT INTO tbx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu neil no bei, “Inyei tambiy wei lulul ana yo ti mi vunek en teimb teleing me mateyek nimzamza de teyei lek bouk eno mi ya lulul nimza. ");
INSERT INTO tbx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nanghei lulul ana xe tete mya eno kanyo ti eno mindei inyon. E lei Laserus, qatyex sevunexe e ninavi. ");
INSERT INTO tbx_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Moxo mi wounalei bei gya lulul myapapu wei mi teila eivek lelek xeinghembi wei lulul ana xe yo, de woyom xel naw la mi myeil e xe qatyex. ");
INSERT INTO tbx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“De bouk la wou eivek om kanyo tiwei mi tay eno mey me xel angela lam qou e me la toung wou Apraham byek. De tambiy wei lulul ana eno mey is me xel ev. ");
INSERT INTO tbx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Eivek beyeeng wei meyeing xe yo eno moxo valwou myavanei ngandoung. Lulul ana moxo yeila Apraham toundei dingta me Laserus toundei wou e byek. ");
INSERT INTO tbx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Om moxo taxe la wou e bei, ‘Mang Apraham, wa laleim e pyaxow en ay! Wang bong Laserus a toung mema deyis na eivek memiing me nam a toung lek a ghas en embo nityuweing nayaka, en a toundei eivek nenyex tine eno a axe myavanei ngandoung.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Ekom Apraham neil elox wou e, ‘Neung, wang bounaleim en ingwei wang mindei mapieing o, bei wang mi qou lul nimzamza de Laserus mi qou lulul wei nilul o, ekom gweimbeeng ne eno lalei wo nimza nanghei inye de wang valwou myavanei. ");
INSERT INTO tbx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","De lulti nge is, senghoing eivek xa de xam eno Anutu toung vul manghembi ti yeip zeyi woy. En kandek xel ne ti se teyeimbei qayil me nak wou xam de xam on ti se teyeimbei qayil me ghe nam inye wou xa.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Woyom moxo neil, ‘Nambei nyon a tay wou wang, mang, wang bong Laserus na mang beeng. ");
INSERT INTO tbx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","En a lingyeiw lim, om wong Laserus la peti xel en kandek xel se nam eivek beyeeng wei myavanei ngandoung ne is.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ekom Apraham neil elox, ‘Mose xe petieing me xel poropet xe qayeeng eno di yeip wou xel om xel a mi ngo.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Lulul ana neil, ‘Ma, mang Apraham, ekom wangwei xel meyeing ti qandi lek me na wou xel on tyek xel bongis me pekwi xow.’ ");
INSERT INTO tbx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Apraham neil wou embei, ‘Wangwei xel embei se ngo wou Mose me xel poropet, on tyek xel se teyei bei bongis tambiy wei qandi lek veil meyeing o.’” ");
INSERT INTO tbx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu neil wou e xe xel betiyeing bei: “Lul leimalei wei embei bong xomaxoneing detei en sewokeing eno tyek qandi. Ekom tambiy tiwei wong etyip eno e gyaleeng. ");
INSERT INTO tbx_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wangwei tambiy ti embei bong yakyak on ti detei en sewokeing, on inyon nimza bei xel banex e na eivek mamileeng is qakous ngandoung wei xel tup e vivekwou e kwa yo en e se bong kwa yon. Anutu tyek bong myaveweeng ngandoung ghanaw veil en ingwei xel wong o. ");
INSERT INTO tbx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Om xam ghe gweiteyei xow. “Wangwei lim bong sewokeing ond wang na pepyawexe e, ek wangwei e pekwi xow ond wa semaleeng sewokeing wei e yo. ");
INSERT INTO tbx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","De wangwei e bong sewokeing lim yuw wou wang lek bouk tixemou, de lu lim yuw eno loumelam wou wang me neil embei, ‘A pekwi xow,’ ond wa semaleeng sewokeing wei e yo.” ");
INSERT INTO tbx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Xel sinale neil wou Tambiy Ngandoung bei, “Wa tetulexe xa xe wongeingis ena bo ngandoung!” ");
INSERT INTO tbx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Moxo neil elox bei, “Wangwei wongeingis wei xam eno nayaka nambei xax mastet vei on tyek wa neil wou xax ngandoung tine bei wa puw xow me ghe na dev xow eivek mamileeng on tyek betiwou wa xe qayeeng.” ");
INSERT INTO tbx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Wangwei xam on ti xe xukxe la qandax tembuing o la yeiteyei sipsip, gyeik ingwei xukxe loumelam, on tyek wa se teyei bei neil wou bei, ‘Lam dei me wa.’ ");
INSERT INTO tbx_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ekom tyek wa neil wou wa xe xukxe bei, ‘Wang gweiwou lul yaeing wou ay atax me ghe gweiwou xow me na duw lul yaeing en a gha me na num lek boy, dekakom wang gwa me na num lek.’ ");
INSERT INTO tbx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","De tyek e neil dange wou xukxe en ingwei wo xuk ambei ingwei neil wou e yo? Ma. ");
INSERT INTO tbx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Om xam is ambei nyon, gyeik ingwei xam ghe bong xuk dalus wei Anutu neil wou xam bei xam ghe bong o na ma, ond xam a neimbei, ‘Xa xukxe ne se nimza teyei lek. Xuk wei xa mi wong ne inye xuk wei xa mi yo.’” ");
INSERT INTO tbx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu betiwou sakwaing wei la Yerusalem o, om la wou sakwaing wei di yeip senghoing eivek distrik Samaria me Galili yo. ");
INSERT INTO tbx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ka moxo la eivek beyeeng ti eno moux xoumeeng wei vanei lepa wong xel eno la tyip wou e nanghei inyon, xel nale dingta, ");
INSERT INTO tbx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","me taxe xoulekeing bei, “Yesu! Teiv! Pyanaleim en xa!” ");
INSERT INTO tbx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Gyeik ingwei Yesu yei xel, eno neil wou xel, “Xam la talex xow wou xel lumuki.” Ka xel di la eno xel ninavi wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Gyeik xel on ti yei ingwei wo nimzalek, om loumelam wou Yesu, moxo di taxe me sanghoxe Anutu. ");
INSERT INTO tbx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Moxo ev vaxakatu eivek me ma la eivek tembuing wou Yesu vaxa me wo dange wou e, inyon Samaria ti. ");
INSERT INTO tbx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu teling, “Inye xel xoumeeng dalus se wo nimzalek? Xel limvey la nya? ");
INSERT INTO tbx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Xelti se pekwi ma me loumelam sanghoxe Anutu, qe tambiy ba tine venaxow.” ");
INSERT INTO tbx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Woyom Yesu neil wou, “Qandi lek me la. Wa xe wongeingis wong wang wo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Xel Parisi valu teling wou Yesu bei, “Gyeik inya Anutu xe tete lalei nam?” Yesu neil elox wou xel, “Anutu xe tete lalei embei nam, on tyek lulti se nam mendei nambei dee me xam ghe gwei lek mamim. ");
INSERT INTO tbx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","O tyek xomaxoneing se neimbei, ‘Toundei inye,’ o ‘Toundei inyei,’ en nambei Anutu xe tete lalei toundei eivek xam.” ");
INSERT INTO tbx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Woyom moxo neil wou e xe xel betiyeing bei, “Bouk di lam gyeik ingwei xam ghe wou naleimim being gwei Xomaxoneing Neu Moux xe bouk ti. Ekom tyek xam seng gwei. ");
INSERT INTO tbx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Xomaxoneing tyek na neil wou xam bei, ‘Moxo toundei inyei’ o ‘Moxo toundei inye!’ On xam se daveimyamim me ghe na betiy xel. ");
INSERT INTO tbx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","En bouk wei Xomaxoneing Neu Moux embei noum eno tyek nambei zivip mi nex mema nanghei tyoung myasepu valu me ela valu yo. ");
INSERT INTO tbx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ekom myaxeeng eno tyek na qou myavanei ngenong, me xomaxoneing wei bouk tine eno tyek pesek e. ");
INSERT INTO tbx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kwa wei xel wong gyeik bouk wei Noaka yo, on nambei nyon tyek xel nox bong kwa kayon lek bouk wei Xomaxoneing Neu Moux embei noum o. ");
INSERT INTO tbx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Xomaxoneing di ya me num lek me di iima, me neuyeiw di iima lox me loum deka ela tyip wou bouk wei Noaka la eivek sip, woyom memiing butek me lam leis xel dalus. ");
INSERT INTO tbx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Xel wong kwa kayon nambei nyon eivek bouk wei Lot o, xomaxoneing di ya me num lek, me di xouv lulul, me di wong vateivek, xel di ev lulul vei eivek xuk, me xel di ev xomek. ");
INSERT INTO tbx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ekom ka bouk wei Lot la veil Sodom, nenyex is qakous wei wo gyand en nenyex tum lek o tei nambei luing nanghei tyoung nei me ya moux alis vex dalus. ");
INSERT INTO tbx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Tyek xel bong kwa nambei nyon lek bouk wei Xomaxoneing Neu Moux embei noum yanyateiv o. ");
INSERT INTO tbx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lek bouk kayon, xelti embei toumendei lek xomek demi qetyei de e xe lulul nimza na toumendei eivek xomek lalei on tyek se douk me nox a qou lulul. De nambei nyon is, xelti embei toumendei eivek xuk on tyek se nox a qou e xe lulul ti. ");
INSERT INTO tbx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Xam ghe bou naleimim en Lot venei! ");
INSERT INTO tbx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Xelti embei zeimaxoun mapieing wei e yo, on tyek na saing e xe mapieing, ek xelti embei saing mapieing wei e yo, on tyek na zeimaxoun e xe mapieing. ");
INSERT INTO tbx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","A neil wou xam, lek boukeing tiyon eno tambiy yayuw di yeip lek zek tixemou, tyek Anutu na qou nge de nge na toumendei. ");
INSERT INTO tbx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Vex yayuw di louk wit neing bei embo palawa wei belet o. Tyek Anutu na qou nge de nge na toumendei.” ");
INSERT INTO tbx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Xel betiyeing teling, “Tambiy Ngandoung, lul on tyek qandi nanghei inya?” Moxo neil elox, “Lek beyeeng wei meyeing neing mi yeip lek o, inyon tyek xel menek tuw qeku nak inyon.” ");
INSERT INTO tbx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Woyom Yesu neil qayeeng pakeing tine wou e xe xel betiyeing, bei e talex wou xel en xel a mi zeimemend taxombouk, de xel se bo nimaing. ");
INSERT INTO tbx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Moxo neil embei, “Eivek beyeeng ti eno tambiy wei mi zeim qayeeng o ti mindei, wei se mi yaleeng en Anutu, me se mi wounalei en moux alis vex. ");
INSERT INTO tbx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","De vexeiv ti mindei eivek beyeeng tiyon. Om mi qatoloum wou tambiy wei mi ngo qayeeng o. Vexo neil, ‘Tambiy ti embei bo vevek wou ay. Om wa menyex wou qayeeng eivek uw senghoing.’ ");
INSERT INTO tbx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Myaxeeng eno tambiy wei mi ngo qayeeng eno se vind vexo. Dekakom moxo wounalei bei, ‘A se xaleeng en Anutu me a se wou kwang en xomaxoneing ti. ");
INSERT INTO tbx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ekom a xei vexeiv tiyon mi wo maying wou ay me qou e xe nimaying me lam wou ay, om a menyex wou qayeeng enok bo nimbayaing wou ay.’” ");
INSERT INTO tbx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","De Tambiy Ngandoung neil embei, “Xam ngo qayeeng wei tambiy nilul wei mi zeim qayeeng eno neil o. ");
INSERT INTO tbx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","De tyek Anutu menyex wou xomaxoneing wei e beyal o, me xel mi eng wou e bendiyeing aluw boukeing o, tyek na mi daxe de se devind xel daing? ");
INSERT INTO tbx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","A neil wou xam, tyek gyei me menyex wou xel daing. Ekom gyeik bouk wei Xomaxoneing Neu Moux embei noum eno tyek gyei bei moux alis vex wei tembuing ne di wongis e?” ");
INSERT INTO tbx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu neil qayeeng pakeing tine en xel valu wei mi wou naleind bei xel venaxow bombek de xel valu se nimza nambei xel. ");
INSERT INTO tbx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tambiy yayuw lek me la eivek xomek vambuing en embei na zeimemend, nge Parisi ti de nge xel wei mi qou takis o. ");
INSERT INTO tbx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi tiyon nale me zeimema en xow: ‘O Anutu, a wong dange lak wou wang, en a se nambei moux amba, xel mi panax me mi wo nilul me mi wong kwapesiv, de a se nambei tambiy tiwei mi qou takis ne. ");
INSERT INTO tbx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Bouk yayuw eivek sounda sapa eno a mi vambu yaeing, me na mi wong ti eivek xoumeeng en lul dalus wei a mi qou eno wou wang.’ ");
INSERT INTO tbx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ekom tambiy wei mi qou takis eno qandi lek me nale kwanding de se yeima la tyoung gheyapu nei, qe qatu bambou me neil embei, ‘Anutu, a mi wong sewokeing om wa laleim e pyaxow en ay.’ ");
INSERT INTO tbx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“A neil wou xam en tambiy tiwei mi qou takis on bei, gyeik lox beeng nei eno Anutu yei bei e bombek wou e manghalus. Dom Parisi eno ma. En xelti embei sanghoxe xow eno Anutu tyek beoux e, de xelti embei beoux xow eno Anutu tyek sanghoxe e.” ");
INSERT INTO tbx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Xomaxoneing valu qou yakyak me la wou Yesu, xel embei e ni mema lek xel. Ekom gyeik ingwei xel betiyeing yei, eno xel neil xel. ");
INSERT INTO tbx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ekom Yesu taxe yakyak lam wou e de neil embei, “Xam ghe bong yakyak nam wou ay, xam se bale zeyi xel, en Anutu xe tete lalei nei eno xel wei xok ambei yakyak eno xel xe. ");
INSERT INTO tbx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","A neil wou xam zonghek, xelti embei se qou Anutu xe tete lalei nambei yakyak ne, eno tyek se na eivek.” ");
INSERT INTO tbx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Gyovaxa ti teling wou Yesu bei, “Putoung nimza, tyek a bong vati de na qou deing mapieing luta luta?” ");
INSERT INTO tbx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu lewexe, “Nambei nya wang neimbei a nimza? Xelti se nimza qe Anutu venaxow. ");
INSERT INTO tbx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Wang woulek qayeeng petieing: ‘Wa seng bo kwapesiv is xel nge, wa seng nyeis xel nge na mey, wa se panax, wa seng bong qayeeng tyonyeing en xel nge. Wa mi gwevek mam aluw tam xeinghembi.’” ");
INSERT INTO tbx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Gyovaxa neil, “Gyeik a yak me elam tyip gweimbeeng ne, eno a mi betiwou petieing on dalus.” ");
INSERT INTO tbx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Gyeik ingwei Yesu ngo inyon, eno neil wou e bei, “Wang ghei ma en lulti. Wang bo vateivek lek lulul dalus wei wang o, de ghe bong malew on wou xel kanyo, on tyek wa qou lulul nimzamza eivek tyoung gheyapu nei, woyom wang nam betiwou ay.” ");
INSERT INTO tbx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Gyeik ingwei moxo ngo inyon eno lalei wo maying, en nambei tambiy yon xe lulul ngenong. ");
INSERT INTO tbx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu yei e me neil embei, “Inye wo pok en xel wei lulul ana embei na eivek Anutu xe tete lalei yo! ");
INSERT INTO tbx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Wangwei kamel embei na eivek ying manghalus wei duweing lulul o ond tyek bo pok wou e? Ekom xel wei lulul ana embei na eivek Anutu xe tete lalei eno tyek bo pok ngandoung.” ");
INSERT INTO tbx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Xel wei ngo inyon eno teling bei, “Wangwei nambei nyon nei ond tyek eti na mendei mapieing luta luta?” ");
INSERT INTO tbx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu neil elox bei, “Lulul wei xomaxoneing se teyeimbei bong eno Anutu teyeimbei tyek bong.” ");
INSERT INTO tbx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petele neil wou embei, “Wei, xa ghanaw xa xe lulul dalus de betiy wang.” ");
INSERT INTO tbx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu neil wou xel bei, “A neil wou xam zonghek, xelti embei saing beeng o venei o liyeiw o mamata o neuyeiw en Anutu xe tete lalei ");
INSERT INTO tbx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","on tyek xel a qou lul ngenong lumama lek bouk tine, me bouk wei embei nam eno tyek xel a qou deing mapieing luta luta.” ");
INSERT INTO tbx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu qou xel xoumeeng yuw me la nale beyaleing me neil wou xel. “Xey ambei zek me nana Yerusalem, me lulul dalus wei xel poropet byex lek Xomaxoneing Neu Moux eno tyek bo neing lek. ");
INSERT INTO tbx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tyek xel toung moxo na eivek xel amba memend. Tyek xel baluk seloukeing wou e, me bo nol wou e, me pesuv myenlouk lek e, ");
INSERT INTO tbx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","me sesa e, de nyeis e mey. Ekom lek bouk yal eno tyek qandi lek no.” ");
INSERT INTO tbx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Xel betiyeing se woulek qayeeng tine qes en qes xupek en xel, me xel se woulek vati wei di neil o. ");
INSERT INTO tbx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ka Yesu la paviy beyeeng Jeriko, eno tambiy wei matekeing o ti mindei wou sakwaing nenyawes me mi tay lulul me malew wou xel. ");
INSERT INTO tbx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Gyeik ingwei moxo ngo moux alis vex ngenongakes di lam, om teling wou xel bei, “Inyei xel di wo vati?” ");
INSERT INTO tbx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Xel neil wou embei, “Yesu wei Nasaret eno di lamela.” ");
INSERT INTO tbx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Matekeing moxo taxe bei, “Yesu, Dawit Neu Moux, wa laleim e pyaxow en ay.” ");
INSERT INTO tbx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Xel wei di lam atax eno neil e me neil embei e mendei kanzek, ekom moxo taxe xoulekeing, “Dawit Neu moux, wa laleim e pyaxow en ay.” ");
INSERT INTO tbx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu nale me neil nikanzek bei xel a qou moux tiyon me na wou e. Gyeik ingwei moxo la paviy, Yesu teling e, ");
INSERT INTO tbx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wambei am bong vati wou wang?” Moxo neil embei, “Tambiy Ngandoung, ambei gheina yo.” ");
INSERT INTO tbx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu neil wou moxo bei, “Wa mam e gyeina en wa xe wongeingis wong wang wo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lutika eno moxo ma yeila de betiwou Yesu, me di sanghoxe Anutu. Gyeik ingwei xomaxoneing dalus yei inyon eno xel sanghoxe Anutu. ");
INSERT INTO tbx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu la eivek Jeriko me di la. ");
INSERT INTO tbx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tambiy ti mindei inyon e lei Sakius. Moxo lei ngandoung wei xel wei mi qou takis o, me tambiy on lulul ana. ");
INSERT INTO tbx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Moxo embei gyei bei Yesu yon nambei nya. Ekom moxo sepika om se teyeimbei gyei, en inye moux alis vex ngenongakes. ");
INSERT INTO tbx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Om moxo veimya me la tax wou sakwaing wei Yesu embei na nox me lek xax basounghek ti en embei gyei e. ");
INSERT INTO tbx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ka Yesu la paviy xax qes eno veilma lek me neil embei, “Sakius, ouk me lam daing, en ambei na mendei eivek wa bam gweimbeeng.” ");
INSERT INTO tbx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Om moxo ouk me lam daing me qou e is xeilala. ");
INSERT INTO tbx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Xomaxoneing dalus wei yei inyon eno xel ngoung wouma me neil embei, “Moxo la dei is xel wei sewokeing o.” ");
INSERT INTO tbx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kalekom Sakius nale me neil wou Tambiy Ngandoung, “Tambiy Ngandoung, wei! Tyek a dembu lul wei ay eno na yuw de na bong veweeng wou xel kanyo. De wangwei a qou xelti xe lulti en tyonyeing on tyek a bong malew nox zeyi wou e lu vey.” ");
INSERT INTO tbx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu neil wou e bei, “Gweimbeeng Anutu vind xel wei xomek tine yo veil nilul, en nambei tambiy tine inye Apraham neu is. ");
INSERT INTO tbx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","En Xomaxoneing Neu Moux lam en embei gyimexe me devind moux alis vex wei lati yo noumenam.” ");
INSERT INTO tbx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Ka xomaxoneing ngo tiyon, Yesu neil qayeeng pakeing tine no is wou xel, en nambei la paviy Yerusalem, om xel wou naleind bei Anutu xe tete lalei tyek nam atyip daing. ");
INSERT INTO tbx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Moxo neil embei, “Tambiy wei lei ngandoung eno neu ti la tembuing wei dingta yo, en embei xel balax embo king de woyom e noumenam beyeeng. ");
INSERT INTO tbx_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Om moxo taxe e xe xukxe xoumeeng me wong malew ghol titi wou xel, de neil embei, ‘Xam mendi bong vateivek lek malew on deka a noum le.’ ");
INSERT INTO tbx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Ekom xel wei e beeng qes eno laleind wo nol wou e, me wong xel wei xel beyal o valu betiy e me la neil embei, ‘Xa bei tambiy tiyon e se bong xa xe king.’ ");
INSERT INTO tbx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ekom e wo king, me loumelam beyeeng. Woyom moxo wo qayeeng la wou xel xukxe wei wong malew wou xel o, en embei gyei bei xel titi wong xuk lek me qou malew vamva is lek mapu. ");
INSERT INTO tbx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Tambiy tiwei myaxeeng o lam me neil, ‘Teiv, a wong xuk lek wa xe malew ghol tiwei yo me na qou malew ghol xoumeeng is.’ ");
INSERT INTO tbx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“De moxo neil wou bei, ‘Wang on a xe xukxe nimza me wang wo xuk nimza. Wang weiteyei lul wei nayak o, om tyek wang gweiteyei beyeeng ngandoung xoumeeng.’ ");
INSERT INTO tbx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Xukxe nge wei yayuw eno lam neil embei, ‘Teiv, a wong xuk lek wa xe malew ghol tiwei yo me na qou malew ghol lim is.’ ");
INSERT INTO tbx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“E xe teiv lewexe, ‘Nimza, wang gweiteyei beyeeng ngandoung lim.’ ");
INSERT INTO tbx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Woyom xukxe nge lam, me neil embei, ‘Teiv, wa xe malew ghol tiyo inye, a toung eivek qaeing myasepu ti. ");
INSERT INTO tbx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","En a xaleeng en wang, en wa tambiy wei niseikeing o, wang mi qou vati wei wa seng toung o, me wang mi qou lul yaeing wei wa seng ev o.’ ");
INSERT INTO tbx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Woyom king neil wou e xe xukxe, ‘Wa xukxe nilul. Tyek a bong qayeeng en wang en wamaxow xe qayeeng. Wang wei bei a tambiy wei niseikeing, a mi qou vati wei a se toung me na qou lulul yaeing wei a se ev o? ");
INSERT INTO tbx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Nambei nya wa seng toung axe malew eivek xomek malew, en kandek gyeik ingwei a noum ond a qou is malew wei xel toung lek mapu yo?’ ");
INSERT INTO tbx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Woyom king neil wou xel wei toukale paviy e yo, ‘Xam qou malew ghol tiyon veil e me wong wou tambiy wei e xe malew ghol xoumeeng o.’ ");
INSERT INTO tbx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Xel neil wou e, ‘Teiv, xukxe yon qou malew ghol xoumeeng woy!’ ");
INSERT INTO tbx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Moxo neil elox, ‘A neil wou xam, xel eti yeiw wei qou lulul, eno tyek am bong valu is wou xel, ekom wangwei xelti se qou lulul ti, on lul nayak kawei toundei wou e yon, tyek am bouveil e. ");
INSERT INTO tbx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ekom xel vevek amba wei ay yo embei a se bong king wei xel, eno xam a qou xel me ghe nam inye me ghe nyeis xel amey wou a mang.’” ");
INSERT INTO tbx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Ka Yesu neil qayeeng on woy, om betiwou sakwaing me lek me la Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ka Yesu la paviy Betpage me Betani lek qetyei wei xel mi neil embei lukendu Oliv, eno moxo wong e xe xel betiyeing yayuw la me neil wou luw, ");
INSERT INTO tbx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Muw ghe na eivek beyeeng tinei, wangwei muw ghe na, tyek muw ghe gwei dongi lingheing ti xel qoxoun nanghei inyon, xelti seng ghei dei lek. Muw a tul me na qou me ghe nam inye. ");
INSERT INTO tbx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wangwei xelti teling muw, ‘Muw ghe tul dongi yon enva?’ On muw a neil wou e bei, ‘Tambiy Ngandoung embei bong xuk en.’” ");
INSERT INTO tbx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Betiyeing yuw wei wong luw la eno luw yei lul nambei ingwei e neil wou luw o. ");
INSERT INTO tbx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ka luw di tul yis veil dongi eno mayeiw teling wou luw bei, “Muw ghe tul dongi ne enva?” ");
INSERT INTO tbx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Luw neil elox bei, “Tambiy Ngandoung embei bong xuk en.” ");
INSERT INTO tbx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Om luw qou dongi me la wou Yesu. Xel toung xel xe teimb lek dongi demi de toung Yesu la dei lek. ");
INSERT INTO tbx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ka e di la, eno xomaxoneing liw xel xe teimb me teteyexe wou sakwaing. ");
INSERT INTO tbx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Gyeik ingwei moxo la paviy beyeeng wei sakwaing lep me la lukendu Oliv nei, eno e xe xel betiyeing ngenongakes di wong xeindlala me sanghoxe Anutu me wo denduing en lulvako wei xel yei woy o. Xel neil, ");
INSERT INTO tbx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Mata ena wou king tiwei lam lek Tambiy Ngandoung lei yo!” “Lalei vevopeing e gyeip senghoing eivek Anutu wei tyoung gheyapu nei me xey de lei laeing ena wou Anutu.” ");
INSERT INTO tbx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","De xel Parisi valu toundei eivek xel ngenong on lalei, xel neil wou Yesu bei, “Putoung, wa neil wa xe xel betiyeing on, en xel se neil qayeeng on.” ");
INSERT INTO tbx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu neil wou xel, “A neil wou xam! Wangwei xel mendei kanzek, on tyek xel qakous ne taxe xoulekeing.” ");
INSERT INTO tbx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Ka Yesu la paviy Yerusalem me yei beyeeng ngandoung on, eno moxo eng en. ");
INSERT INTO tbx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Me neil embei, “Wangwei wamaxow ghe boulek bouk tine, en sakwaing wei lalei vevopeing lam wou wang ne, ekom gweimbeeng xupek en wa mam. ");
INSERT INTO tbx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bouk ti tyek nam, gyeik wa xe xel vevek nam a poux tembuing apup me bivekwou tete wei wang on. Me tyek xel bale ebivekwou danghei danghei nei zeyi wang. ");
INSERT INTO tbx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tyek xel lelolexe wang na lek tembuing, wang is neumyeiw wei toundei eivek wang on. Tyek xel se bong qakous nge na toumendei lek nge mapu, en nambei wa seng woulek bouk wei Anutu lam en embei devind wang o.” ");
INSERT INTO tbx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Woyom Yesu la eivek tete lalei wei xomek vambuing o me tiy xel wei di wong vateivek lek lulul o. ");
INSERT INTO tbx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Moxo neil wou xel, “Xel byex eivek xoulek eno nambei nye, ‘Axe xomek ne, inye xomek wei zeimeing mema eivek o.’ Ekom xam ghe wong e wong ambei ‘beyeeng xupekeing wei xel panaxeing o.’” ");
INSERT INTO tbx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Taxombouk eno Yesu mi teyoxe xel eivek tete lalei wei xomek vambuing o. Ekom xel lumuki leitata yo, me putoung wei petieing o me gyovaxa wei xomaxoneing o, di wong me yei en xel embei nyeis e mey. ");
INSERT INTO tbx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ekom xel se yeiwou sakwaing ti, en nambei xomaxoneing wei toundei me ngo e xe qayeeng eno wo nikanzek. ");
INSERT INTO tbx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Bouk ti eno Yesu di teyoxe xomaxoneing eivek tete lalei wei xomek vambuing o me neil Xoulek Nimza wou xel, de xel lumuki leitata me putoung wei petieing o dalus is teivateiv lam tyip wou e. ");
INSERT INTO tbx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Xel neil wou e bei, “Neil wou xa, wang qou lei ngandoung me nikanzek tiyon nanghei inya me ghe di wong lulul tiyon angya? Eti wong lei ngandoung on wou wang?” ");
INSERT INTO tbx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Moxo neil elox wou xel, “Ay is ambei nyon ambei teling xam, xam neil wou ay, ");
INSERT INTO tbx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","gyeik ingwei Yoan lipek moux alis vex, inyon lul wei Anutu eivek tyoung gheyapu yo, o lul wei xomaxoneing o?” ");
INSERT INTO tbx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Xel di luk wouma eivek xel venaxow senghoing me neil embei, “Wangwei xey a neimbei lul on Anutu yo, on tyek teling xey, ‘Nambei nya xam seng wongis e?’ ");
INSERT INTO tbx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ekom wangwei xey a neimbei, ‘Lul on xomaxoneing o,’ on tyek moux dalus banex xey en qakous, en xel wongis bei Yoan on poropet.” ");
INSERT INTO tbx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Om xel lewexe, “Xa se woulek bei inyon lam anghei inya.” ");
INSERT INTO tbx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu neil wou xel, “Ay is, tyek a se neil wou xam en lei ngandoung tiwei andi wong lulti beimambei nangya ne.” ");
INSERT INTO tbx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesu neil qayeeng pakeing tine wou xomaxoneing bei, “Tambiy ti wong e xe xuk wain ti, dom wou eivek xel xukana valu memend bei xel a mi bo xuk vateivek lek. De e venaxow la dei enden lek beyeeng nge. ");
INSERT INTO tbx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lek bouk wei uleing wain eno moxo wong xukxe ti la wou xel wei di yeiteyei wain o, en embei xel dul wain on neing valu wou e. Ekom xel wei di yeiteyei wain eno leis e me wong e lox mema bandaing. ");
INSERT INTO tbx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Moxo wong xukxe nge lox me la no, ekom xel leis e is no me wo niyalenyeing wou e de wong e lox mema bandaing. ");
INSERT INTO tbx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Moxo wong xukxe tiwei yal o lox me la no. Ekom xel leis e wo nol me nex e la myayaing. ");
INSERT INTO tbx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Woyom xuk wain ma neil, ‘Tyek am bong ambei nya? Tyek am bong a neung moux tiwei a laleing vind eno na, bei xel se gwevek e xe qayeeng xeinghembi.’ ");
INSERT INTO tbx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Ekom gyeik xel xukana yei e neu di lam, eno xel neil wouma bei, ‘Neu moux tine tyek na qou xuk wain. Xey a leis e mey, de xe venaxow a qou xe xe xuk wain ne.’ ");
INSERT INTO tbx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Om xel nex moxo la myayaing veil xuk wain de leis e mey. “Om tyek xuk wain ma yon bong vati wou xel? ");
INSERT INTO tbx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Moxo tyek nam nyeis xel wei di yeiteyei xuk wain on na mey, de bong xuk wain on wou xel amba.” Gyeik xomaxoneing ngo qayeeng tiyon eno xel neil embei, “Lul ambei nyon eno e se nox qandi no.” ");
INSERT INTO tbx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesu yei xel kanzek, de teling bei, “Qayeeng tiwei xel byex ne qes ambei nya: “‘Qakous mundeeng ti myaxeeng wei xel kamunda pesek, eno wong ambei qakous tiwei nale me mi byexaxoun xomek o’? ");
INSERT INTO tbx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Xel dalus wei oing me teila lek qakous on tyek bo tiptip. Ekom wangwei qakous tiyon detei lek xelti on tyek bo myapapu.” ");
INSERT INTO tbx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Xel putoung wei petieing o me xel lumuki leitata yo di yimexe sakwaing en xel embei zeimaxoun e lutika, en xel woulek bei neil qayeeng pakeing tiyon lek xel. Ekom xel yaleeng en xomaxoneing. ");
INSERT INTO tbx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Xel lumuki leitata me putoung wei petieing o mi yei Yesu teyei teyei, bei bong xel valu na xupekeing me gyei e teyei. Me tyoing lek bei xel bombek bei na ngo e xe qayeeng wei embei neil o, en kandek xel bong e na wou lei ngandoung wei seyap o. ");
INSERT INTO tbx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Om xel teling wou embei, “Putoung, xa woulek qayeeng wei wang mi neil me ghe mi teyoxe eno mi la bombek, me wang mi neil qayeeng la teyeima wou moux alis vex wei lei laeing o me lei maeing o. Me qayeeng zonghek eno wang mi teyoxe xel en Anutu xe kwa. ");
INSERT INTO tbx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Woyom wang wou naleim ambei nya, beip inye teyeimbei xey a toung takis wou Sisa o xe se toung?” ");
INSERT INTO tbx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ekom Yesu woulek bei xel tyoxe e, om neil embei, ");
INSERT INTO tbx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Talex selewa ti wou ay. Inye eti tenu me lei di yeip lek?” Xel neil elox bei, “Sisa.” ");
INSERT INTO tbx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Me moxo neil wou xel, “Lul wei Sisa, eno xam ghe bong wou Sisa. De lul wei Anutu, eno xam ghe bong wou Anutu.” ");
INSERT INTO tbx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Om xel se teyeimbei tyoxe e en qayeeng wei e neil o ti eivek moux alis vex mendghalus, om xel etek en qayeeng wei neil elox wou xel o, om xel dei kanzek. ");
INSERT INTO tbx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xel Sadyusi valu wei mi neil embei xel wei mey, eno tyek se qandi lek. Xel lam wou Yesu is telinyeing ti. ");
INSERT INTO tbx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Xel neil embei, “Putoung, Mose byex qayeeng ti nambei nye wou xey, wangwei tambiy ti dii vex ti ekom mey veil venei de neu ma, ond li e dii vexeiv me bong li wei mey eno neu en mendi zeim li lei xoun. ");
INSERT INTO tbx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Om xel wei lindama eno lim yuw. Tiwei myaxeeng eno ii vex ti ekom mey de neu ma. ");
INSERT INTO tbx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Woyom li nge wei yuw eno ii vexeiv on. ");
INSERT INTO tbx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","De li tiwei yal eno ii vexeiv. Eivek sakwaing ambei nyon eno xel lim yuw wei lindama eno ii vex tiyon me neuyeiw ma, de xel mey. ");
INSERT INTO tbx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Dekakom vex tiyon mey loxyus is. ");
INSERT INTO tbx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Woyom gyeik bouk loxyus wei xel meyeing embei qandi lek, eno eti venei vex tiyon? En moux lim yuw eno ii vex tixemou yon.” ");
INSERT INTO tbx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu neil elox wou xel, “Xomaxoneing wei gweimbeeng ne mi iima me wong vex lox me loum wouma. ");
INSERT INTO tbx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Ekom eivek bouk loxyus eno moux alis vex wei Anutu neil embei xel teyei lek en ingwei xel embei qandi lek veil meyeing me mendei mapieing, eno tyek se diima o bong xel nox me noum wouma. ");
INSERT INTO tbx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Me tyek xel se nox me na mey no, en xel on teyei lek xel angela. Me xel on Anutu neuyeiw, en nambei xel qandi lek veil meyeing. ");
INSERT INTO tbx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ekom Mose talex wou xey bei xel wei mey eno tyek qandi lek veil meyeing, en pavulek wei byex en ingwei nenyex tum lek xax nayaka yo, en taxe Tambiy Ngandoung Anutu wei Apraham o me Anutu wei Isaka yo me Anutu wei Yakop o. ");
INSERT INTO tbx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Moxo se Anutu wei xel meyeing, qe e Anutu wei xel wei mapieing. En eivek Anutu manghalus eno moux alis vex dalus toundei mapieing en e.” ");
INSERT INTO tbx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Xel putoung wei petieing o valu ngo qayeeng wei Yesu neil o, om xel neil wou embei, “Putoung, wa xe qayeeng on nimza.” ");
INSERT INTO tbx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","De xelti se teyeimbei bong telinyeing wou Yesu en lulti no. ");
INSERT INTO tbx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Woyom Yesu neil wou xel bei, “Nambei nya moux alis vex mi neil embei Kilisi yon Dawit Neu Moux? ");
INSERT INTO tbx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawit venaxow neil eivek Qapiya Lalo bei, “ ‘Tambiy Ngandoung neil wou a xe Tambiy Ngandoung bei, “Wa mendei wou a memang payeiv ");
INSERT INTO tbx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","deka a toung wa xe xel vevek na kwanghembi eivek wang le.” ’ ");
INSERT INTO tbx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Dawit taxe e bei ‘Tambiy Ngandoung.’ Nambei nya Kilisi yon Dawit bu?” ");
INSERT INTO tbx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kale xomaxoneing dalus di ngo qayeeng wei Yesu di neil o, de neil wou e xe xel betiyeing bei, ");
INSERT INTO tbx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Xam ghe gweiteyei xow en xel putoung wei petieing o, xel laleind mi vind en xel embei mi byex teimb ding me na ghavineeng. Xel laleind mi vind bei xel a mi neil bendiyeing teiv wou xel eivek beyeeng wei xel mi wong vateivek lek lulul o, me xel la mindei lek beyeeng nimza wei mya eivek xomek qekueing ama me xel la mindei lek leitata bend wei mya eivek mata wei ngandoung o. ");
INSERT INTO tbx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Xel mi tyoxe xel vexeiv me panax xel xe xomek. De xel mi wou naleind bei xel nimza om xel mi zeimemend wo ding. Bouk loxyus eno tyek xel wei nambei nyon eno tyek na qou myaveweeng ngandoung.” ");
INSERT INTO tbx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ka Yesu veilma lek me yei xel wei malew ana yo la di toung xel xe da eivek qoupek malew wei xomek vambuing o. ");
INSERT INTO tbx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","De moxo yei vexeiv kanyo ti is eno toung selewa gyand nayak yayuw la eivek qoupek malew. ");
INSERT INTO tbx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","De Yesu neil embei, “A neil wou xam zonghek, vexeiv kanyo toung malew ngandoung ghanaw moux alis vex valu. ");
INSERT INTO tbx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Xomaxoneing on dalus xe malew ngenong, om xel toung danghei ka la eivek deng xeikatu. De vexeiv on lulul maeing, ekom toung malew dalus wei embei devind e yo.” ");
INSERT INTO tbx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Moxo xe xel betiyeing valu yei xomek vambuing me luk en bei, “Xel qou qakous nimzamza me da wei xel toung wou Anutu yo me vunekwou xomek tiyon en.” Ekom Yesu neil embei, ");
INSERT INTO tbx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Bouk ti tyek nam eno lulul tiwei xam ghe di wei yon, tyek xel lelolexe dalus me banex ena xonei lek tembuing de qakous ti tyek se gyeip lek nge mapu.” ");
INSERT INTO tbx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Om xel teling Yesu bei, “Putoung, gyeik inya lulti yon tyek qandi? Me dee vati tyek talex lek bei lul dalus tine embim nam atyip?” ");
INSERT INTO tbx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu neil embei, “Xam ghe gweiteyei xow, enok xel a tyoxe xam. Xel ngenong tyek nam lek a leing, me nam a neimbei, ‘A Mesia yo,’ me tyek xel a neimbei, ‘Bouk moxo di lam paviy.’ Ekom xam se betiwou xel. ");
INSERT INTO tbx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Gyeik ingwei xam a ngo vevek ngandoung me vevek wei seyap o ngenong qandi, yon xam seng detek. En lul beimambei yon tyek qandi tax, ekom bouk loxyus tyek sim nam daing.” ");
INSERT INTO tbx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Woyom moxo neil wou xel: “Tembuing nge tyek qandi me bong vevek wou tembuing nge, de tete lalei nge tyek bong vevek wou tete lalei nge. ");
INSERT INTO tbx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Gyeik inyon eno tyek tembuing api ngandoung, de eivek beyeeng valu eno maxep ngandoung tyek qandi me vanei ngandoung is. Me tyek xam ghe gwei dee ngandoung nelu nelu valu qandi eivek tyoung me bong yalenyeing ngandoung wou xam. ");
INSERT INTO tbx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Ekom gyeik ingwei lul dalus on seng ghei qandi, eno tyek xel a zeimaxoun xam me bo nol wou xam. Tyek xel a qou xam me na eivek xomek qekueing ama me bong qayeeng en xam, me na toung xam ghe na eivek xeitueing, me tyek xel a qou xam me na bale wou xel king me lei ngandoung wei seyap o mendghalus. En nambei xam ghe mi betiwou ay. ");
INSERT INTO tbx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Lulti yon tyek bong ambei sakwaing wei xam ambei neil axe xoulek teyei wou xel o. ");
INSERT INTO tbx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ekom xam seng bou naleimim ngenong atax bei tyek xam bale zeyi xow ambei nya. ");
INSERT INTO tbx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","En tyek a bong qayeeng wou xam me na bong lupeyei nimza wou xam is, om xel wei embei bong qayeeng en xam eno tyek se pyalek o bakeilek qayeeng wei a wong wou xam o. ");
INSERT INTO tbx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Xam mamatam, me limyeiw, me nimpapu, me gweleeng, eno tyek xel a neil xam teyei me na toung xam eivek xel ba memend me tyek xel nyeis xam valu na mey. ");
INSERT INTO tbx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xel xomaxoneing dalus tyek gyei xam ghe bo nol en xam ghe mi betiwou ay. ");
INSERT INTO tbx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ekom xam lumim velus ti tyek se teyeimbei puw veil. ");
INSERT INTO tbx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Om wangwei xam bale nikanzek ond tyek xam mendei mapieing eivek bouk loxyus. ");
INSERT INTO tbx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Gyeik ingwei xam ghe gwei xel vevek bale ebivekwou Yerusalem, on xam ghe boulek bei bouk wei beyeeng embei lelolexe eno paviy. ");
INSERT INTO tbx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Woyom moux alis vex wei toundei eivek Yudia eno xel a pek me na lukendu. De xel wei toundei eivek Yerusalem eno xel na myayaing veil. De xel wei toundei myayaing en Yerusalem eno se na eivek lalei. ");
INSERT INTO tbx_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","En inye bouk wei Anutu embei bong myaveweeng o, nambei qayeeng wei xel byex eivek xoulek eno tyek bo neing lek. ");
INSERT INTO tbx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Bouk tiyon tyek bo lalei pyaweingxow en vex wei neu pouyek o me vex wei di wong luul wou neu yo! En nimaying ngandoung tyek qandi wou tembuing de Anutu xe lalei vanei tyek detei lek xomaxoneing wei Yuda yo. ");
INSERT INTO tbx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Tyek xel amey en ngeyeing vevek, me tyek xel a qou xel me na xeitueing nanghei tembuing bamba nei. De xel amba tyek bakei vaxend eivek Yerusalem me gyeiteyei deka bouk wei Anutu lax eno na boueivek le.” ");
INSERT INTO tbx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Yesu neil no, “Dee nelu nelu tyek qandi eivek sayeiv, dentouk, me betum, de lek tembuing eno xel xomaxoneing wei tembuing tambak ne eno tyek bou naleind ngenong me gyaleeng ngandoung, en tyek xel a ngo mamileeng buklek me bong nindenduing ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Me lulul wei tyoung gheyapu eno tyek bo pimapi me xomaxoneing tyek gyaleeng ngandoung me mend bivek en vati wei embei nam lek tembuing o. ");
INSERT INTO tbx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Woyom lek bouk tiyon eno moux alis vex tyek gyei Xomaxoneing Neu Moux nam eivek laxap ti is nikanzek me e xe xeiyaing ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Gyeik ingwei lulul beimambei yon di qandi, eno xam qandi lek me ghe beil lumim lek, en bouk wei Anutu embei tul xam veil nilul eno di lam paviy.” ");
INSERT INTO tbx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu neil qayeeng pakeing ti wou xel bei, “Xam ghe gwei xax basunghek me xax sapa yon is. ");
INSERT INTO tbx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Gyeik ingwei xam venaxow ghe gwei xax a byex nelu duing lek eno xam ghe boulek bei sewis di lam paviy. ");
INSERT INTO tbx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Om gyeik ingwei xam ghe gwei lulul on qandi, on xam ghe boulek bei Anutu xe tete lalei di lam paviy. ");
INSERT INTO tbx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“A neil wou xam zonghek bei, neing ayang moux alis vex wei bouk tine eno tyek se mey qe ka lulul ti beimambei yon qandi bole. ");
INSERT INTO tbx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tyoung aluw tembuing tyek na tip, ekom axe xoulek tyek se nati.” ");
INSERT INTO tbx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Yesu neil no, “Xam a mi gweiteyei xow, en xam se num me betiwou Kwa nol wei numeing o xam seng bou naleimim en lulul wei xe neing o, wangwei xam ghe bong ambei nyon, on tyek bouk wei Tambiy Ngandoung xe yo tyek qandi wou xam lutika nambei leliy mi eivek lepulek o. ");
INSERT INTO tbx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","En tyek lulti yon qandi wou moux alis vex dalus wei toundei lek tembuing sapa yo. ");
INSERT INTO tbx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Xam a mi bale nikanzek me ghe gweiteyei xow taxombouk, me na mi zeimemamim wou Anutu, en kandek xam ghanaw lulul wei embei qandi yon. De tyek xam teyeimbei bale wou Xomaxoneing Neu Moux manghalus.” ");
INSERT INTO tbx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Teyei lek bouk titi eno Yesu mi teyoxe xel eivek tete lalei wei xomek vambuing o. De boukeing eno la mi yeip nanghei lukendu wei xel mi neil Oliv nei. ");
INSERT INTO tbx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","De satiboukeing lul eno xomaxoneing dalus mi qandi me lam xomek vambuing en embei na mi ngo e xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lek Bouk Wei Yaeing Belet Wei Yis Ma Veil, wei xel mi taxe bei Pasova eno lam paviy. ");
INSERT INTO tbx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Xel lumuki leitata yo me xel putoung wei petieing o di yimexe sakwaing wei xel embei nyeis Yesu e mey yo. En xel yaleeng en xomaxoneing. ");
INSERT INTO tbx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Woyom Sandang la eivek Yudas, xel mi neil embei Iskariot, xel wei xoumeeng yuw eno ti. ");
INSERT INTO tbx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Me Yudas la luk is xel lumuki leitata yo me xel belimbo wei mi yeiteyei xomek vambuing me yimexe sakwaing wei embei neil Yesu teyei me na toung e na eivek xel memend. ");
INSERT INTO tbx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Xel wo xeindlala en ingwei xel yei e yo me neil wou Yudas bei tyek xel bong malew wou e. ");
INSERT INTO tbx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Om Yudas lewexe lek qayeeng wei xel neil on, de di yimexe sakwaing wei embei bou Yesu eivek xel memend gyeik ingwei moux alis vex ngenong se toundei is e yo. ");
INSERT INTO tbx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Woyom Bouk Wei Yaeing Belet Wei Yis Ma Veil eno lam, wei xel mi leis sipsip lingheing en yaeing lek bouk wei xel mi wou naleind en Pasova yo. ");
INSERT INTO tbx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Om Yesu wong Petele luw Yoan la me neil embei, “Muw ghe na gweiwou mata wei Pasova yo en xey a gha.” ");
INSERT INTO tbx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Om luw teling wou e, “Wambei uw a na gheiwou nanghei inya?” ");
INSERT INTO tbx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Moxo neil elox, “Ka muw ghe na eivek beyeeng ngandoung eno tambiy ti di qalei memiing eivek deng ti eno tyek nam a tyip wou muw. Eno muw betiy e me ghe na eivek xomek tiwei e la eivek o. ");
INSERT INTO tbx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Me muw a neil wou tambiy wei e beeng o bei, ‘Putoung teling wang: Xomek lalei inya wei ambei gha mata wei Pasova is axe xel betiyeing o?’ ");
INSERT INTO tbx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Moxo tyek talex xomek lalei myasapa wei gheyapu nei wou muw, xel menyex wou dalus woy, om muw ghe gweiwou mata nanghei inyon.” ");
INSERT INTO tbx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Luw la me yei lulul la teyei lek ingwei Yesu neil wou luw o. Om luw menyex wou mata wei Pasova yo. ");
INSERT INTO tbx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Seivma la wou eivek ingwei yaeing o, om Yesu lis e xe sinaleyeiw la dei lek zek. ");
INSERT INTO tbx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Me moxo neil wou xel bei, “A laleing vind bei ambei gha mata wei Pasova ne is xam natax dekakom qalei myavanei. ");
INSERT INTO tbx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","En a neil wou xam, tyek a se nox a gha no qe ka lul tine e bong neing lek eivek Anutu xe tete lalei le.” ");
INSERT INTO tbx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ka Yesu qou mayamya wei wain o ti me wong dange wou Anutu de neil embei, “Xam a qou tine me na num eivek ama senghoing. ");
INSERT INTO tbx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","En a neil wou xam tyek a se nox a num wain neing no qe ka Anutu xe tete lalei nam bole.” ");
INSERT INTO tbx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","De moxo qou belet ti, me wong dange wou Anutu me dembu, me wong wou xel betiyeing de neil embei, “Inye a neing wei a wong bei e devind xam. Xam a mi bong ambei nyon en na mi bou naleimim en ay.” ");
INSERT INTO tbx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gyeik xel ya woy eno qou mayamya wain me wong ambei nyon no me neil embei, “Mayamya tine inye qokatu vako, wei a gyand qapyex bei e devind xam o. ");
INSERT INTO tbx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ekom tambiy tiwei embei neil a teyei me na toung ay eivek xel vevek amba memend eno toundei me ya is ay lek zek. ");
INSERT INTO tbx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Xomaxoneing Neu Moux tyek betiwou sakwaing wei Anutu wong wou e yo. Ekom nimaying tyek gyeip wou tambiy tiwei embei neil a teyei me na toung a na eivek xel amba memend o.” ");
INSERT INTO tbx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Xel betiyeing ngo qayeeng tiyon eno xel di teling wouma eivek xel venaxow senghoing bei, “Eti tyek bong kwa tiyon?” ");
INSERT INTO tbx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Dekakom xel betiyeing pyalek ama eivek xel venaxow senghoing me neil embei, eti wo lei ngandoung en xel. ");
INSERT INTO tbx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesu neil wou xel bei, “Xel king wei xel amba eno xel mi wo lei ngandoung me yeiteyei moux alis vex, me xel qou leind ambei nye tambiy wei mi wo nimza wou xel o. ");
INSERT INTO tbx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ekom xam seng bong ambei nyon, qe xelti embei bo lei ngandoung eivek xam senghoing ond e nox yusayang, de xam xe gyovaxa e teyei lek xukxe wei xam o. ");
INSERT INTO tbx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","En inye eti lei ngandoung, beip inye tambiy wei toundei lek zek, o xukxe wei di duw lul yaeing o? Inyei tambiy tiwei toundei lek zek o. Ekom a toundei eivek xam senghoing nambei xukxe wei di duw o. ");
INSERT INTO tbx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ekom xam wei ghe nale is ay gyeik ingwei axeing lam wou ay yo. ");
INSERT INTO tbx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Me a wong tete lalei wou xam, nambei ingwei mang wong wou ay yo. ");
INSERT INTO tbx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","En kandek xam a mi gwa me na num lek axe zek eivek axe tete lalei me mendei lek xel siaking me ghe pepyawexe xel veleivlei xoumeeng yuw wei Israel o.” ");
INSERT INTO tbx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Yesu neil embei, “Simon, Simon, Sandang teling en embei daxe xam nambei xel mi seyex wit me wong ninavi veil o. ");
INSERT INTO tbx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ekom Simon, a zeimemang en wang, en wa xe wongeingis e se detei. Me gyeik ingwei wa pekwi me ghe noum eno wa mi byexaxoun limyeiw.” ");
INSERT INTO tbx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ekom Petele neil elox bei, “Tambiy Ngandoung, a xeiwou xow bei tyek nana xeitueing is wang me na mey is wang.” ");
INSERT INTO tbx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu lewexe bei, “A neil wou wang, Petele, gyeik ingwei qouklex seng ghei sesa vya boukeing tine eno tyek wang dax a vun luyal me na neimbei wa seng woulek ay.” ");
INSERT INTO tbx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Woyom Yesu teling xel, “Gyeik ingwei a wong xam ghe la bandaing veil vaxak malew o vaxak, o vaxalambes, eno xam seng wimexe xow en lulti?” Xel lewexe bei, “Ma.” ");
INSERT INTO tbx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","De moxo neil wou xel, “Ekom gweimbeeng ne wangwei wa xe vaxak malew, ond wa qou, me vaxak is ambei nyon, de wangwei wa se qou ngeyeing vevek ti, on wang bong vateivek lek teimb ding wei wang o de ghe bou ti. ");
INSERT INTO tbx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Xel byex eivek xoulek eno nambei nye, ‘Moux alis vex yei e wo nol ambei tambiy wei nol o.’ A neil wou xam, qayeeng wei xel byex lek ay eivek qapiya eno tyek bo neing lek. Ee, en vati wei xel byex lek ay eno tyek qandi me bo neing lek.” ");
INSERT INTO tbx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","De xel betiyeing neil, “Tambiy Ngandoung, wei, ngeyeing vevek yayuw inye.” Moxo neil elox bei, “Inyon woy.” ");
INSERT INTO tbx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu la lukendu Oliv nambei ingwei mi wong lumama yo, me e xe xel betiyeing betiwou e. ");
INSERT INTO tbx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Moxo la tyip wou beyeeng wei yo, eno neil wou xel, “Xam a mi zeimemamim, on tyek xam se detei en axeing.” ");
INSERT INTO tbx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Moxo dula nayaka nambei ingwei xel mi nex qakous o veil xel, de ev vaxa qatu eivek me zeimema, ");
INSERT INTO tbx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Mang, wangwei wa laleim devind ond wa zeim mayamya tine veil ay. Ekom wa se betiwou a laleing, qe wa betiwou wamaxow laleim.” ");
INSERT INTO tbx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Woyom angela wei tyoung gheyapu nei ti lam wou e me byexaxoun e. ");
INSERT INTO tbx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesu axe myavanei ngandoung, me zeimema nikanzek, me vanei tyip e nambei gyand me teila lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Gyeik ingwei moxo zeimema woy, eno qandi lek me lox me la wou e xe xel betiyeing. Loum yei ekom xel yeip, en xel wo nimaing en xel laleind wo maying. ");
INSERT INTO tbx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yesu teling xel, “Xam ghe weip en vati? Xam qandi lek me zeimemamim, on tyek xam se detei en axeing.” ");
INSERT INTO tbx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ka Yesu nanghei di luk eno xel ngenongakes lam tyip, tambiy tiwei xel neil embei Yudas, xel xoumeeng yuw eno ti qou xel me lam. Moxo la paviy Yesu en embei sesuvexe e, ");
INSERT INTO tbx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ekom Yesu teling e, “Yudas, wambei neil Xomaxoneing Neu Moux teyei me na toung e na eivek xel amba memend en sesuvexeing?” ");
INSERT INTO tbx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Gyeik ingwei Yesu xe xel betiyeing yei vati wei embei qandi, eno xel neil, “Tambiy Ngandoung, tyek xa nyeis xel en xa xe ngeyeing vevek?” ");
INSERT INTO tbx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","De xel wei xel venaxow eno ti leis xukxe wei lumuki lukanzek o me qateiv e nenya nge payeiv tip me teila. ");
INSERT INTO tbx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ekom Yesu neil embei, “Woy! Xam seng bong kwa yon no!” De moxo zeim tambiy on nenya me wong e wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Woyom Yesu neil wou xel lumuki leitata yo, de beyeiv wei xomek vambuing o me xel teivateiv wei lam en e yo bei, “Xam ghe qou ngeyeing vevek me pebumeeng me ghe lam en xam ambei zeim tambiy wei wo vevek, o panaxeing o? ");
INSERT INTO tbx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","A mindei is xam taxombouk eivek tete lalei wei xomek vambuing o, ek xam seng zeimaxoun ay. Ekom inye xam xe seivma, wei mapetok yeiteyei yo.” ");
INSERT INTO tbx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Woyom xel zeimaxoun Yesu me qou e me la eivek lumuki lukanzek o beeng. Petele di betiy xel me di la kwanding ka. ");
INSERT INTO tbx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Ekom gyeik xel vev nenyex eivek tete lalei wei xomek tiyon masenghoing me xel xouing toundei wou, eno Petele la dei is xel. ");
INSERT INTO tbx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Xukxe vex ti yei ingwei e toundei wou nenyex tumeing o. Vex on yei e kanzek me neil embei, “Tambiy tiyon mindei is e.” ");
INSERT INTO tbx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ekom Petele axvun me neil embei, “Vex, a se woulek e.” ");
INSERT INTO tbx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Xel dei nayaka dekakom tambiy nge yei e me neil embei, “Wang on xel wei e yo ti.” Petele neil elox, “Ma, se ay ti!” ");
INSERT INTO tbx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nambei seivma ti la veil om moux nge luk nikanzek me neil embei, “Zonghek ayang tambiy tiyon mendei is e, en inyei e nanghei Galili.” ");
INSERT INTO tbx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petele neil elox bei, “Moux, a se woulek qayeeng tiwei wang di neil on!” Gyeik e ghei di luk eno qouklex wo vya lutika. ");
INSERT INTO tbx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Woyom Tambiy Ngandoung pekwi ma me yei Petele bombek. Woyom Petele wounalei en qayeeng wei Tambiy Ngandoung neil wou e yo: “Gweimbeeng boukeing tine qouklex seng ghei sesa vya eno tyek wang dax a vun luyal.” ");
INSERT INTO tbx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","De Petele la myayaing me la eng ngenong. ");
INSERT INTO tbx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Xel moux wei di yeiteyei Yesu eno xel di luk napeing lek e me petapexe e. ");
INSERT INTO tbx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xel tup e ma zeyi nangya qaeing de neil wou e bei, “Wa baluk poropet! Eti petapexe wang?” ");
INSERT INTO tbx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Me xel lukyak ngenong lek e is. ");
INSERT INTO tbx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","De xeiyaing nexla eno teivateiv wei xel xomaxoneing o, is xel lumuki leitata yo, me xel putoung wei petieing wei kanzol o, xel dalus qekuma, me xel qou Yesu me lam eivek xel xe qekueing ama yon. ");
INSERT INTO tbx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Me xel neil wou e, “Neil wou xa, wangwei bei inyon wa Kilisi?” Ekom neil elox bei, “Wangwei a neil wou xam, on tyek xam seng bongis ay, ");
INSERT INTO tbx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","me wangwei a teling wou xam en qayeeng valu, on tyek xam seng zewexe lek. ");
INSERT INTO tbx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ekom gweimbeeng me e mi na bouk loxyus eno Xomaxoneing Neu Moux tyek mendei wou Anutu nikanzek mema payeiv.” ");
INSERT INTO tbx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Xel dalus teling wou e, “Inyon wa Anutu Neu Moux?” Moxo neil elox, “Xam venaxow ghe neil bombek. Inye ay.” ");
INSERT INTO tbx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Woyom xel neil embei, “Xey a bei se qou pavulek valu en tambiy tine en emaxow mya neil qayeeng tine me xey a ngo woy.” ");
INSERT INTO tbx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Woyom xel qendu dalus on qandi lek me qou Yesu me la wou Pailat. ");
INSERT INTO tbx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Me xel wong qayeeng en e, me neil embei, “Xa xei tambiy tine wo nol wou kwa wei xa Yudayeiw o, me peti xa bei xa se toung takis wou Sisa. De mi neil embei e Kilisi, me e yon king ti.” ");
INSERT INTO tbx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Om Pailat teling wou Yesu, “Inyon wa king wei Yudayeiw o?” Yesu neil elox wou, “Ee inyon nambei wang neil on.” ");
INSERT INTO tbx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Woyom Pailat neil wou xel lumuki leitata is xel qendu ngandoung on bei, “A se xei sewokeing ti lek tambiy tine.” ");
INSERT INTO tbx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ekom xel luk nikanzek me neil embei, “Tambiy on mi ghavineeng me la danghei danghei nei eivek Yudia, myaxeeng anghei distrik Galili me mi lam a zenz inye is, me mi teyoxe xomaxoneing me zeim xel laleind lek.” ");
INSERT INTO tbx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailat ngo tine om teling wou xel, “Moux tine inye Galili ti?” ");
INSERT INTO tbx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Gyeik ingwei Pailat ngo bei Yesu yon nanghei Galili, woyom wong ela wou Herot en nambei Herot yeiteyei beyeeng danghei tiyon. De gyeik bouk kayon eno Herot toundei Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Gyeik ingwei Herot yei Yesu eno wo xeilala ngandoung, en nambei mi toung ma wou en embei gyei e, en vatiyeiw wei e ngo yo, moxo wounalei bei Yesu e bong lulvako valu me e gyei. ");
INSERT INTO tbx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herot wong telinyeing ngenong wou e. Ekom Yesu se neil qayeeng ti lox wou e. ");
INSERT INTO tbx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Xel lumuki leitata yo me putoung wei petieing o toukale inyon, me wong qayeeng en e nikanzek. ");
INSERT INTO tbx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Woyom Herot alis e xe xel vevek wong napeing wou Yesu me lukyak lek e woy, om xel qou teimb nimza maseim ti me byex lek e, dom wong e lox me la wou Pailat. ");
INSERT INTO tbx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lek bouk kayon eno Herot aluw Pailat wo gweleeng lek ama. Takwei eno luw mi wo vevek wouma. ");
INSERT INTO tbx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailat taxe xel lumuki leitata yo me xel gyovaxa me xomaxoneing lam qekuma. ");
INSERT INTO tbx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Me moxo neil wou xel bei, “Xam ghe qou tambiy tine me ghe lam wou ay me ghe neimbei mi zeim xel laleind lek bei xel bo vevek wou seyap. Om a wo telinyeing lumama wou e wou xam mamim, ekom a se xei sewokeing ti wou tambiy tine en vatiyeiw wei xam ghe wong qayeeng en e yo. ");
INSERT INTO tbx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","De Herot is ambei nyon, om wong e loum wou xey. Xam ghe wei, tambiy tine se wong sewokeing ti bei e mey. ");
INSERT INTO tbx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Nambei nyon tyek a sesa moxo de woyom na bong e na.” ");
INSERT INTO tbx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ekom moux alis vex dalus poux avyend lekti me neil embei, “Leis tambiy on mey, de wong Barabas lam wou xa.” ");
INSERT INTO tbx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas on tambiy wei wong vevek eivek beyeeng ngandoung me leis xel valu mey o, om xel toung e la xeitueing. ");
INSERT INTO tbx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailat embei bong Yesu na, om neil wou xel dalus no. ");
INSERT INTO tbx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ekom xel di tetulexe wou taxeing me neil embei, “Tuw e lek xax pepeeng! Tuw e lek xax pepeeng!” ");
INSERT INTO tbx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Lu yayal eno moxo neil wou xel bei, “Enva? Tambiy tine wong sewokeing vati? A se xei sewokeing ti bei e mey, om tyek a sesa e de na bong e na.” ");
INSERT INTO tbx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ekom xel wo ninkanzek me taxe la xoulekeing bei, Pailat e tuw Yesu lek xax pepeeng. Me xel xe taxeing sevunexe Pailat ning qayeeng. ");
INSERT INTO tbx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Om Pailat betiwou qayeeng wei xel o me neilteyei bei Yesu e mey. ");
INSERT INTO tbx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Moxo wong tambiy tiwei toundei eivek xeitueing en ingwei wong vevek me leis xel valu mey, eno la myayaing, tambiy tiwei xel teling en o. De Pailat betiwou xel xe lalei vineing me wong Yesu wou xel vevek. ");
INSERT INTO tbx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ka xel vevek qou Yesu me la, eno xel yei tambiy ti lam anghei beyeeng myayaing nei en embei na eivek Yerusalem, moxo lei Simon wei beyeeng Sairini yo. Xel zeimaxoun e me liw xax pepeeng lek e ghandiwek de e qalei me betiwou Yesu. ");
INSERT INTO tbx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","De xomaxoneing ngenongakes di betiy e, is xel vex ngenong wei laleind pyaxow en e me di wong talot me eng o. ");
INSERT INTO tbx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu pekwi ma me neil wou xel bei, “Xam vex wei Yerusalem o, xam seng deeng en a ti, qe xam ghe deeng en xam venaxow de neumyeiw is. ");
INSERT INTO tbx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","En bouk ti tyek nam gyeik ingwei xam a neimbei, ‘Vex wei mi mouyeeng o, vex wei se wo neu yo me vex wei se di wong luul wou neu eno xel bo xeindlala.’ ");
INSERT INTO tbx_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Woyom moux alis vex tyek “‘na neil wou xel lukendu bei, “Xam qepei lek xa!” me xel qetyei bei, “Xam sevun xa!” ’ ");
INSERT INTO tbx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Gweimbeeng xomaxoneing wong nimaying ne wou ay nambei xax wei nimwis o. Om xam ghe ghok xax wei mupek o om tyek bong ambei nya wou xam loxyus?” ");
INSERT INTO tbx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tambiy yayuw, luw xouing mi wong sewokeing, om xel qou luw me la is Yesu en xel embei na nyeis luw amey is e. ");
INSERT INTO tbx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Gyeik xel la tyip nanghei tiyon, xel mi neil embei Lukanzek, nanghei tiyon eno xel tuw Yesu lek xax pepeeng, me tambiy nilul yayuw is, nge wou e mema payeiv de nge wou e mema qeinz. ");
INSERT INTO tbx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","De Yesu neil embei, “Mang, wa semaleeng sewokeing wei xel o, en xel se woulek vati wei xel di wong ne.” De xel vevek di nex qakous dee me pum e xe teimb wouma. ");
INSERT INTO tbx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Xel xomaxoneing toukale me di yei e, de xel gyovaxa wo vyend wou Yesu bei, “Moxo mi vind xel ba, de wangwei e Kilisi wei Anutu beyal o, on wong e vind xow.” ");
INSERT INTO tbx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Xel vevek wong vyend wou e is ambei nyon. Xel la paviy e me wong wain senyeing wou e. ");
INSERT INTO tbx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","De xel neil embei, “Wangwei wa king wei xel Yudayeiw o, ond vind xow.” ");
INSERT INTO tbx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Lek xax pepeeng pundanghou eno xel byex qayeeng bei, “INYE KING WEI YUDAYEIW O.” ");
INSERT INTO tbx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tambiy nilul yuw wei xel teyu is Yesu, eno nge lukyak lek Yesu, “Wa Kilisi? Ond wa devind xow me uw is.” ");
INSERT INTO tbx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ekom nilul nge neil e, “Wa seng waleeng en Anutu? En wang qalei nimaying teyei lek ambei e? ");
INSERT INTO tbx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Uw a qalei myavanei ne la teyei lek en nimaying vati wei uw a wong o. Ekom tambiy moxne se wong sewokeing ti.” ");
INSERT INTO tbx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Woyom moxo neil embei, “Yesu, wang bounaleim en ay gyeik ingwei wang nam eivek wa xe tete lalei yo.” ");
INSERT INTO tbx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu lewexe wou e bei, “A neil wou wang zonghek, gweimbeeng eno tyek wang na mendei is ay eivek beyeeng nimza wei Anutu yo.” ");
INSERT INTO tbx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Inye nambei seivma evlek eno mapetok ngandoung sevunexe tembuing sapa, me ela teyei lek seivma yal, ");
INSERT INTO tbx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","en nambei sayeiv siing eno tip, de qaeing wei xel teyu eivek xomek vambuing eno lex ela yuw. ");
INSERT INTO tbx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu taxe xoulekeing bei, “Mang, a wong axe laweeng lak eivek wa memam.” Gyeik moxo neil ambei nyon eno puw laweeng wei yus o de mey. ");
INSERT INTO tbx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Beyeiv wei xel vevek o eno yei vati wei qandi yo, me sanghoxe Anutu. Me neil embei “Zonghek ayang, tambiy tine nye bombek.” ");
INSERT INTO tbx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gyeik xomaxoneing dalus wei qeku la toukale eno yeimend wou vatiyeiw wei qandi yo, xel laleind wo maying me qatu bambound de lox me la bend. ");
INSERT INTO tbx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ekom Yesu xe xel gweleeng dalus, is xel vex wei betiy e me lam anghei Galili eno xel toukale kwanding me yei vatiyeiw wei qandi yo. ");
INSERT INTO tbx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tambiy ti lei Yosep, inyon kanzol wei Yudayeiw eno ti, tambiy on nimza me bombek. ");
INSERT INTO tbx_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Moxo lalei se vind woueing nalei me kwa wei xel kanzol wong on. Moxo lam anghei Yudayeiw xe beyeeng nayak wei Arimatia, de moxo mindei me axe Anutu xe tete lalei. ");
INSERT INTO tbx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yosep la wou Pailat me teling wou e en embei qou Yesu neing. ");
INSERT INTO tbx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Woyom moxo la zewax Yesu neing me qou me ouk me loum, de beliv eivek qaeing pus me qou me la liw eivek leiveeng meyeing wei xel kwelexe eivek qakous o. Xel seng ghei liw xelti eivek. ");
INSERT INTO tbx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Inyon bouk wei menyexeing wou lulul en Sabat o, de Sabat lam paviy. ");
INSERT INTO tbx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Xel vex wei lam anghei Galili is Yesu eno betiy Yosep me la yei leiveeng meyeing wei Yosep liw neing di yeip nambei nya yo. ");
INSERT INTO tbx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Woyom xel lox benbend me yeiwou lulul is wel xeimangou yo. De inyon Sabat, om xel toundei lek nambei ingwei Mose xe petieing neil o. ");
INSERT INTO tbx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lek bouk ti myaxeeng wei sounda tiyon satiboukeing lul, eno xel vex qou lulul wei xeimangou wei xel menyex wou yo me la ingwei leiveeng meyeing nei. ");
INSERT INTO tbx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Xel yei qakous wei xel lax zeyi leiveeng meyeing eno xel tatekexe veil leiveeng meyeing mya. ");
INSERT INTO tbx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ekom gyeik ingwei xel la lalei eno xel se yei Tambiy Ngandoung Yesu neing. ");
INSERT INTO tbx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ka xel di wou naleind ngenong en inyon, lutika eno xel yei tambiy yayuw xe teimb on siing niseikeing nambei zivip me toukale wou xel wes. ");
INSERT INTO tbx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Xel vex yaleeng me ev vaxendkatu eivek de mend la tembuing, ekom moux yuw on neil wou xel, “Xam ghe lam di wimexe tambiy wei mapieing o eivek beyeeng wei meyeing o en va? ");
INSERT INTO tbx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Moxo se toundei inye, qe qandi lek! Xam ghe bou naleimim en qayeeng wei neil wou xam, gyeik nanghei toundei is xam eivek Galili yo. ");
INSERT INTO tbx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Neil embei, ‘Tyek xel a toung Xomaxoneing Neu Moux na eivek xel wei sewokeing o memend, en xel atuw e lek xax pepeeng de bouk yal na veil, ond tyek qandi lek no.’” ");
INSERT INTO tbx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Woyom xel wou naleind en Yesu xe qayeeng wei neil o. ");
INSERT INTO tbx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Gyeik ingwei xel loum veil leiveeng meyeing eno xel neil lulti beimambei yon wou xel betiyeing xoumeeng ti me moux alis vex dalus. ");
INSERT INTO tbx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Xel vex wei neil lulti beimambei yon wou sinaleyeiw eno inye, Maria wei Makdala yo, me Joana, me Maria wei Jems ta yo, me vex valu is xel. ");
INSERT INTO tbx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ekom xel se wongis xel vex on, en xel xe qayeeng on wong ambei lul bandaing. ");
INSERT INTO tbx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ekom Petele qandi lek me veimya me la ingwei leiveeng meyeing nei. Dundek me yeila lalei, ekom qaeing toundei bandaing. Moxo lox me la beeng, de venaxow di wounalei bei inye vati wong ambei nye. ");
INSERT INTO tbx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lek bouk kayon eno Yesu xe xel betiyeing yayuw la beyeeng tiwei xel mi neil Emaus nei. Inyon nambei 11 kilomita nanghei Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Luw di la me luk wou ma en lul sapa wei qandi natax o. ");
INSERT INTO tbx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ka luw di luk wouma en lulul ti beimambei yon, eno Yesu venaxow la tyip me di tupwou sakwaing is luw. ");
INSERT INTO tbx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ekom lulti wong luw se yeimend wou bei inyon Yesu. ");
INSERT INTO tbx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Moxo teling luw, “Muw ghe tupwou sakwaing eno muw ghe di luklek vati wouma me ghe lam?” Luw nale me mend talex lek bei luw laleind pyaxow. ");
INSERT INTO tbx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tambiy yuw on eno nge wei lei Kliopas, eno teling e, “Wa tambiy tixemou yon ghe la bei beyeeng amba eivek Yerusalem eno wa seng woulek vati wei qandi nanghei inyei lek bouk senghoing tine yo?” ");
INSERT INTO tbx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu teling luw, “Lul vatiyeiw?” Luw neil elox bei, “Uw andi luk en Yesu wei Nasaret o, moxo poropet ti, mi neil xoulek nikanzek me mi wong lulvako wou Anutu manghalus me xomaxoneing dalus mendghalus is. ");
INSERT INTO tbx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Xel lumuki leitata yo me xe xe gyovaxa toung e la eivek seyap memend me xel wong qayeeng en me neil embei e mey, om xel tuw e lek xax pepeeng, ");
INSERT INTO tbx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ekom xa di toung mami en moxo en inyon e tambiy tiwei Anutu wong e lam bei e nam a tul e xe xel Israel veil nilul o. Me lulti is no, inye bouk yal la veil en ingwei lulul tiyon dalus qandi yo. ");
INSERT INTO tbx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","De gweimbeeng xel vex wei xa eno valu wong xa etek. En xel la ingwei leiveeng meyeing nei satiboukeing lul, ");
INSERT INTO tbx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ekom xel se yei e neing. Xel loum neil wou xa bei, xel mend pekwi me xel yei angelayeiw wei neil embei moxo toundei mapieing. ");
INSERT INTO tbx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Woyom xel wei xa eno valu la ingwei leiveeng meyeing nei, me la yei lul toundei nambei ingwei vex vex neil o. Ekom xel se yei e.” ");
INSERT INTO tbx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu neil wou luw bei, “Muw ghe loung om muw naleimim se qandi lek daing me ghe wongis qayeeng dalus wei xel poropet neil o. ");
INSERT INTO tbx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Beip Kilisi se teyei bei qou myavanei beimambei ne, dekakom na qou lei ngandoung is xeiyaing?” ");
INSERT INTO tbx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Woyom neil myaxeeng wou luw en xoulek dalus wei Mose, me xel poropet o me veil luw lundlek en xoulek qes dalus wei xel neil lek e venaxow eivek xoulek o. ");
INSERT INTO tbx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ka lal la paviy beyeeng tiwei luw embei na yo, woyom Yesu wong ambei embeim di na. ");
INSERT INTO tbx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ekom luw neilaxoun e me neil embei, “Wa toumendei inye is uw en inye paviy soukeing, me inye embim a bouk.” Om moxo eivek la xomek lalei me la toundei is luw. ");
INSERT INTO tbx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Gyeik ingwei Yesu la dei lek lelek is luw, moxo qou belet me wong dange wou Anutu, de dembu me embei mouk bong wou luw. ");
INSERT INTO tbx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Woyom luw mend yeila me luw yeimend wou e, de moxo malang veil luw mend. ");
INSERT INTO tbx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Luw neil wouma bei, “Qayeeng wei neil eno nyuw uw laleind gyeik ingwei e di luk is uw wou sakwaing me veil uw lundlek en Anutu xe xoulek qes o.” ");
INSERT INTO tbx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","De luti eno luw qandi lek me lox me la Yerusalem. Nanghei inyei eno luw yeiwou xel betiyeing xoumeeng ti is moux alis vex valu di qekuma me dei. ");
INSERT INTO tbx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Xel neil wou luw bei, “Inye zonghek ayang Tambiy Ngandoung qandi lek! Moxo talex xow wou Simon.” ");
INSERT INTO tbx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Woyom luw neil wou xel en vati wei qandi wou luw wou sakwaing o, me ingwei luw yeimend wou Yesu gyeik ingwei dembu belet o. ");
INSERT INTO tbx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ka xel betiyeing nanghei di luk wouma en tine, eno Yesu venaxow lam nale eivek xel senghoing me neil wou xel, “Lalei vevopeing e mi mendei is xam.” ");
INSERT INTO tbx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Om xel etek me yaleeng en xel embeik nge xel yei meyeing ti nu. ");
INSERT INTO tbx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Moxo neil wou xel bei, “Xam ghe etek en va? Me xam laleimim wo yuw en va? ");
INSERT INTO tbx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wei lam a memang luw xouing me a vaxang luw xouing. Inye a venaxow o! Xam axlek ay me wei. Meyeing nu eno leyeis me kanzek ma, se nambei ingwei xam ghe wei lek a ne.” ");
INSERT INTO tbx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Gyeik ingwei moxo neil ambei nye, eno talex mema luw me vaxa luw wou xel. ");
INSERT INTO tbx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Dekakom xel seng ghei wongis. En nambei xel wo xeindlala me di wou naleind ngenong, moxo teling wou xel, “Xam ghe di qou lul yaeing valu nanghei inye?” ");
INSERT INTO tbx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Xel wong woing wei nekeing eno danghei ti wou e, ");
INSERT INTO tbx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","de moxo zeim me ya wou xel mendghalus. ");
INSERT INTO tbx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Moxo neil wou xel, “Inye vati wei a neil wou xam gyeik ingwei anghei toundei is xam o, lul sapa wei xel byex lek ay eivek Mose xe petieing, me xel poropet xe qapiya, me qapiya lalo, eno embo neing lek.” ");
INSERT INTO tbx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Woyom moxo veil xel lundlek bei xel boulek xoulek qes wei di yeip eivek qapiya vambuing o. ");
INSERT INTO tbx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Moxo neil wou xel bei, “Inye vati wei xel byex eivek xoulek o, Kilisi tyek na qou myavanei me na mey de qandi lek veil meyeing lek bouk yal. ");
INSERT INTO tbx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","De eivek e lei eno xel a neil xoulek wou xomaxoneing wei tembuing tambak o en xel pekwi xow, me Anutu semaleeng sewokeing wei xel o. Xam ghe bong xuk tiyon nanghei Yerusalem a tax. ");
INSERT INTO tbx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Xam on ingwei xam ghe wei mamim wou lulti beimambei ne dalus woy. ");
INSERT INTO tbx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tyek a na bong lul vati wei mang neil zonghek o wou xam, ekom xam a mi mendei eivek Yerusalem deka xam a qou nikanzek wei Anutu gheyapu yo bole.” ");
INSERT INTO tbx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Gyeik Yesu qou xel betiyeing me la beyeeng Betani nei. Moxo zeim mema luw xouing lek la de wong mata wou xel. ");
INSERT INTO tbx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ka e di wong mata wou xel eno moxo la veil xel, de Anutu qou e me la eivek tyoung gheyapu nei. ");
INSERT INTO tbx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Woyom xel wong lalo wou e, de lox me la Yerusalem is xeindlala ngandoung. ");
INSERT INTO tbx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","De taxombouk eno xel mindei eivek xomek vambuing me sanghoxe Anutu.");
INSERT INTO tbx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Eivek myaxeeng selis eno Qayeeng mindei, me Qayeeng mindei is Anutu, de Qayeeng on Anutu. ");
INSERT INTO tbx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Inye mindei is Anutu eivek myaxeeng selis. ");
INSERT INTO tbx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Eivek Qayeeng tine eno Anutu toung lulul sapa ne dalus, de embei ma veil eno lulti se woxow nambei e toung o. ");
INSERT INTO tbx_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mapieing toundei eivek e, me mapieing tiyon eno inyon xeiyaing wei xel xomaxoneing o. ");
INSERT INTO tbx_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","De xeiyaing tiyon mi siing eivek mapetok, ekom mapetok se teyei bei sevun xeiyaing. ");
INSERT INTO tbx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Inyei tambiy ti Anutu wong e lam, moxo lei Yoan. ");
INSERT INTO tbx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Moxo lam ambei tambiy wei neil Xeiyaing teyei, en kandek eivek moxo eno moux alis vex dalus a ngo e xe qayeeng me bongis. ");
INSERT INTO tbx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Moxo venaxow se xeiyaing. Qe moxo lam bei na neil xeiyaing teyei. ");
INSERT INTO tbx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Xeiyaing on zonghek wei mi wo xeiyaing wou xomaxoneing sapa, wei lam lek tembuing o. ");
INSERT INTO tbx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Moxo mindei lek tembuing, me eivek e eno Anutu toung tembuing, ekom xomaxoneing wei tembuing eno se yeimend wou e. ");
INSERT INTO tbx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Moxo la beeng qes, ekom xel wei e yo eno se qou e. ");
INSERT INTO tbx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Qe moux alis vex dalus wei qou e eno xel wongis e lei, de moxo lewexe lek xel bei xel bong ambei Anutu neu. ");
INSERT INTO tbx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yakyak on se umbek en mamata gyand, o lalei vineing wei xomaxoneing neing o, o lalei vineing wei mayeiw o. Qe eivek Anutu eno wo xel umbek nambei e neuyeiw. ");
INSERT INTO tbx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","De Qayeeng wo xomaxoneing me lam dei eivek xa senghoing. Xa xei e xe xeiyaing ngandoung, inyei xeiyaing ngandoung wei Neu Moux tixemou tateis wei Ma wong e lam o, pup en lalei xeiles me zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yoan neilteyei wou moux alis vex en e me taxe bei, “Inyei tambiy tiwei a neil wou xam bei, ‘Tambiy tiwei lam yus en ay eno ngandoung ghanaw ay, en nambei mindei takwei en ay.’” ");
INSERT INTO tbx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","De e xe lalei xeiles wei pup eivek e yo eno xey xouing a mi qou mata lumama titi teyeima. ");
INSERT INTO tbx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","En petieing eno wong wou xey eivek Mose mema, de lalei xeiles me zonghek eno lam wou xey eivek Yesu Kilisi. ");
INSERT INTO tbx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Xelti se mi yei Anutu, qe Neu tixemou tateis, e maxow Anutu wei mindei wou Ma wes, eno talex Anutu wou xey. ");
INSERT INTO tbx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","De inye Yoan xe pavulek ne, gyeik xel Yudayeiw wei Yerusalem eno wong xel lumuki me Livaiyeiw la teling e bei, “Wang eti?” ");
INSERT INTO tbx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Moxo neil teyei de se axvun qe neil teyei bei, “A se Kilisi.” ");
INSERT INTO tbx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Xel teling e, “Woyom wang eti? Wa Eliya?” Moxo neil, “Se ay.” “Qe wa poropet tiwei xa di axe yo?” Moxo neil embei, “Ma.” ");
INSERT INTO tbx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Woyom xel teling e no, “Wang eti? Wa neilteyei wou xa en xa nox a neil wou xel wei wong xa lam o. Wambei neimbei wamaxow eti?” ");
INSERT INTO tbx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yoan neil nambei poropet Yesaya neil o, “A tambiy tiwei vya taxeing ti lam eivek tembuing bandaing o, ‘Xam pepyawexe sakwaing embo bombek en Tambiy Ngandoung.’” ");
INSERT INTO tbx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Xel Parisi valu wei xel wong xel lam ");
INSERT INTO tbx_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","eno teling e, “Wangwei wa se Kilisi, o Eliya o poropet nei yond nambei nya wang lipek xel?” ");
INSERT INTO tbx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yoan neil elox bei, “A lipek xam en memiing, ekom tambiy ti toungale eivek xam senghoing eno xam seng woulek. ");
INSERT INTO tbx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Inyon tambiy tiwei lam yus en ay yo, de a se nimza teyei bei a tul yis wei e xe vaxalambes o.” ");
INSERT INTO tbx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lulul tine dalus qandi lek nanghei Betani wei memiing Yorodan loxalu nei, wei Yoan mi lipek moux alis vex anghei yo. ");
INSERT INTO tbx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Bouk nge eno Yoan yei Yesu di lam wou e, om neil embei, “Wei, Anutu xe Sipsip Lingheing, tambiy tiwei semaleeng sewokeing veil xomaxoneing wei tembuing sapa yo! ");
INSERT INTO tbx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Inye tambiy tiwei a neil gyeik ingwei a neimbei, ‘Tambiy tiwei lam yus en ay eno ngandoung ghanaw ay en nambei mindei takwei gyeik a se ghei umbek o.’ ");
INSERT INTO tbx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","A maxow eno a se woulek e, ekom qes wei a lam lipek xel en memiing bei bong xel Israel gyeimend wou e.” ");
INSERT INTO tbx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Woyom Yoan neil teyei bei, “A xei Laweeng Vambuing lep me lam anghei tyoung gheyapu nei nambei beliy me la dei lek e. ");
INSERT INTO tbx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","A maxow se woulek e, qe tambiy tiwei wong a lam a lipek moux alis vex en memiing eno neil wou ay, ‘Tambiy tiwei wang wei Laweeng Vambuing lep me lam dei lek e eno tyek zipek xel en Laweeng Vambuing.’ ");
INSERT INTO tbx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","A maxow a xei me na neil wou xam bei tambiy tiyon Anutu Neu Moux.” ");
INSERT INTO tbx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Bouk nge eno Yoan toungale inyon no is e xe betiyeing yayuw. ");
INSERT INTO tbx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","De moxo yei Yesu di la eno neil embei, “Wei, Anutu xe sipsip lingheing!” ");
INSERT INTO tbx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ka betiyeing yuw on ngo ingwei e neil tiyon, eno luw la betiwou Yesu. ");
INSERT INTO tbx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu pekwi ma, me yei luw di betiy e om teling, “Muw ghe di wimexe vati?” Luw neil embei, “Labai” (qes ambei nye Putoung), “wang mindei inya?” ");
INSERT INTO tbx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Moxo neil elox bei, “Muw lam wei.” Om luw la me yei ingwei mindei eivek o, me luw mindei bouk tiyon is e. Inyon nambei seivma qou vey soukeing. ");
INSERT INTO tbx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrias wei Simon Petele li yo, inyon yuw wei ngo qayeeng wei Yoan neil me betiy Yesu eno nge. ");
INSERT INTO tbx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrias la yimexe li Simon me neil wou e tax bei, “Xa xei Mesia” (qes ambei nye Kilisi). ");
INSERT INTO tbx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","De Andrias qou Simon me la wou Yesu. Yesu yei e de neil, “Wa Simon Yoan neu. Tyek xel taxe wa leim bei Sipas.” (Xey a pekwi bei Petele. Qes bei qakous.) ");
INSERT INTO tbx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","De bouk nge eno Yesu embei na Galili. Moxo yeiwou Pilip me neil wou e bei, “Wa betiy ay.” ");
INSERT INTO tbx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilip on tambiy wei Betsaida yo, wei Andrias aluw Petele bend qes. ");
INSERT INTO tbx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilip la yeiwou Natanael me neil wou e, “Xa xei tambiy tiwei Mose byex eivek petieing me xel poropet byex is ambei nyon o. Inyon Yosep neu Yesu wei Nasaret o.” ");
INSERT INTO tbx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanael teling, “Nasaret ei! Inye lul nimza valu tyek nam anghei inyei?” Pilip neil embei, “Lam me wei.” ");
INSERT INTO tbx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ka Yesu yei Natanael di lam eno moxo luk en e bei, “Tambiy tine Israel zonghek. Eivek e eno tyonyeing ma.” ");
INSERT INTO tbx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael teling, “Wang woulek ay ambei nya?” Yesu lewexe bei, “Gyeik Pilip seng ghei taxe wang eno a xei wang toundei eivek xax basunghek xeinghembi.” ");
INSERT INTO tbx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Woyom Natanael neilteyei bei, “Putoung, wang on Anutu Neu Moux, wa king wei Israel o.” ");
INSERT INTO tbx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu neil wou e, “Wang wongis en ingwei a neil wou wang bei a xei wang toundei eivek xax basunghek xeinghembi yo. Tyek wang gwei lul ngandoung valu ghanaw inyon.” ");
INSERT INTO tbx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Woyom moxo tetulexe no, “A neil wou wang zonghek, tyek wang gwei tyoung gheyapu natax, me Anutu xe angelayeiw mendi zek me na gheyapu de mendi douk me noum lek Xomaxoneing Neu Moux.” ");
INSERT INTO tbx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Lek bouk tiwei yal eno iingama ti qandi nanghei beyeeng Kana eivek Galili. Yesu ta la toundei inyon woy atax, ");
INSERT INTO tbx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","me Yesu is e xe xel betiyeing is ambei nyon, xel wo dik wou xel en iingama yon. ");
INSERT INTO tbx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Gyeik ingwei wain ma, eno Yesu ta neil wou e, “Wain ma veil xel o.” ");
INSERT INTO tbx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu neil elox bei, “Tang, wang neil ambei nyon wou ay enva? Bouk wei ay eno se ghei lam.” ");
INSERT INTO tbx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Moxo ta neil wou xel xukxe, “Xam ghe bong vati wei embei neil wou xam o.” ");
INSERT INTO tbx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Deng qakous ngandoung limti mi nale paviy nanghei inyon, xel Yudayeiw mi lipek eivek nambei xel xe kwa. Memiing nimaying nambei 100 lita eno mi nale eivek titi. ");
INSERT INTO tbx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu neil wou xel xukxe bei, “Xam a taw memiing eivek deng qakous on xel xouing.” Om xel taw eivek me e pup. ");
INSERT INTO tbx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Woyom moxo neil wou xel bei, “Xam zakouv valu gweimbeeng me na qou me na wou tambiy wei la tax en mata yo.” Om xel wong ambei nyon, ");
INSERT INTO tbx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","me teiv wei la tax en mata eno num me axe bei memiing pekwi wain. Moxo se woulek bei inyon lam anghei inya, qe xel xukxe wei di taw memiing eno woulek. Woyom moxo taxe moux wei embei dii vex o la beyaleing ");
INSERT INTO tbx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","me neil embei, “Xel dalus mi wong wain wei nenyeing o me xel mi num atax, deka xel num ngenong woy, xel wong ingwei lavus o me xel num yus. Ekom wang byexaxoun ingwei nimza yo de gweimbeeng kane eno wang qou me lam.” ");
INSERT INTO tbx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu wong e xe lulvako tiwei tax o nambei dee nanghei Kana, danghei wei Galili nei. Moxo talex e xe nikanzek ngandoung teyei me e xe xel betiyeing yei me wongis e. ");
INSERT INTO tbx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ka tine la veil eno moxo lep me la xo Kapenaom nei is ta me liyeiw me e xe xel betiyeing. Xel dei bouk valu nanghei inyei. ");
INSERT INTO tbx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ka bouk wo sepi lek en Yudayeiw xe Pasova, Yesu lek me la Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Eivek tete lalei wei xomek vambuing eno moxo yei xel moux di wong vateivek lek manghaxo, me sipsip me beliy, de xel valu toundei lek lelek me pakei malew wouma. ");
INSERT INTO tbx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Om Yesu qou yis valu me viy me tiy xel vula veil xomek vambuing is sipsip me manghaxo. Moxo qapyex malew selewa wei xel di pakei eno veil de qapyex xel xe lelek is. ");
INSERT INTO tbx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Woyom neil wou xel wei di wong vateivek lek beliy o bei, “Xam qou menek beimambei ne me la veil inye! Xam seng bong Mang xe xomek bong ambei xomek wei vateivek o!” ");
INSERT INTO tbx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","De e xe xel betiyeing wounaleind en qayeeng wei yeip eivek qapiya wei petieing o nambei nye, “A laleing vind wa xe xomek om a wong xuk nikanzek bei bong xomek ne na toumendei nimza.” ");
INSERT INTO tbx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Woyom xel Yudayeiw neil wou Yesu bei, “Tyek wa talex dee wei lulvako en vati eno wou xa en xa boulek bei wang wo lei ngandoung en wambei mi bong lulti beimambei yon dalus?” ");
INSERT INTO tbx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu neil wou xel bei, “Xam lelolexe xomek vambuing tine, de tyek a dev epyap no eivek bouk yal.” ");
INSERT INTO tbx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","De Yudayeiw neil elox bei, “Xel wong xuk lek eveing xomek vambuing ne teyei lek vakovek qes mepyeiyuw me lak limti, de tyek wang dev e qandi lek eivek bouk yal?” ");
INSERT INTO tbx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ekom xomek vambuing wei moxo neil on inyon emaxow neing. ");
INSERT INTO tbx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ka Yesu qandi lek veil meyeing, e xe xel betiyeing wou naleind en vati wei e neil o. Woyom xel wongis xoulek wei di yeip eivek qapiya yo me qayeeng wei Yesu neil o. ");
INSERT INTO tbx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ka Yesu toundei Yerusalem eivek mata wei Pasova yo, eno xomaxoneing ngenongakes yei dee wei lulvako wei wong o me wongis e lei. ");
INSERT INTO tbx_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Ekom Yesu venaxow woulek xow om se wongis xel, en moxo woulek xomaxoneing dalus. ");
INSERT INTO tbx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Moxo se wounalei en xelti bei na neil wou xomaxoneing, en moxo woulek vati wei toundei eivek xomaxoneing laleind o. ");
INSERT INTO tbx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","De tambiy wei Parisi yo ti lei Nikodimas, inyon gyovaxa wei kanzol wei xel Yudayeiw o ti. ");
INSERT INTO tbx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Moxo lam wou Yesu eivek boukeing me neil wou, “Putoung, xa woulek bei wang on putoung tiwei Anutu wong e lam o. Wangwei Anutu se mendei is xelti on tyek se bong dee wei lulvako yo nambei ingwei wang mi wong on.” ");
INSERT INTO tbx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu neil elox wou e bei, “A neil wou wang zonghek, xelti embei se dumbek no on tyek se gyei Anutu xe tete lalei.” ");
INSERT INTO tbx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas teling, “Nambei nya tambiy dumbek no gyeik ingwei wo teiv takwei yo? Neing ayang moxo tyek se nox me na eivek ta veis luyuw me dumbek no!” ");
INSERT INTO tbx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu lewexe bei, “A neil wou wang zonghek, xelti embei se dumbek en memiing me Laweeng Vambuing on tyek se na eivek Anutu xe tete lalei. ");
INSERT INTO tbx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lul wei neing wong e umbek eno inyon neing, de lul wei Laweeng Vambuing wong e umbek eno inyon laweeng. ");
INSERT INTO tbx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Wa seng detek en a xe qayeeng, ‘Qe wang dumbek no.’ ");
INSERT INTO tbx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","De laweeng mi vei me la danghei danghei wei embei na yo. Eno wang mi ngo nindenduing, ekom wa seng woulek bei e lam anghei inya o embei na nya. Om inyon teyei lek xel dalus wei umbek vako en Laweeng Vambuing o.” ");
INSERT INTO tbx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas teling, “Lulti yon tyek bong ambei nya?” ");
INSERT INTO tbx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu neil wou, “Wa Israelyeiw xe putoung, ekom wa seng woulek lulti beimambei ne? ");
INSERT INTO tbx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","A neil wou wang zonghek, xa luk en vati wei xa woulek o, me xa neil qayeeng en vati wei xa xei woy yo, ekom xam xomaxoneing seng wongis xa xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","A neil wou xam en lul wei tembuing o ekom xam seng wongis, woyom wangwei a neil wou xam en lul wei tyoung gheyapu yo on tyek xam ghe bongis ambei nya? ");
INSERT INTO tbx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Xelti se la eivek tyoung gheyapu ti qe tambiy tiwei lam anghei tyoung gheyapu nei yo, inyon Xomaxoneing Neu Moux. ");
INSERT INTO tbx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Inye nambei Mose zeim myeiy lek la eivek tembuing bandaing o, om Xomaxoneing Neu Moux eno tyek xel a zeim e zekna, ");
INSERT INTO tbx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","om xel dalus wei embei bongis e eno tyek na qou deing mapieing luta luta. ");
INSERT INTO tbx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“En Anutu lalei vind xomaxoneing wei tembuing sapa yo omek wong emaxow Neu Moux tixemou tateis on, en kandek eti yeiw wei wongis e eno se mey, qe xel a qou deing mapieing luta luta. ");
INSERT INTO tbx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","En Anutu se wong Neu Moux lam lek tembuing bei e nam bong qayeeng en xomaxoneing lek tembuing. Qe wong e lam bei e nam devind xomaxoneing wei tembuing sapa veil meyeing. ");
INSERT INTO tbx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Eti yeiw wei wongis moxo eno se nale lek qayeeng, qe eti yeiw wei se wongis e eno nale lek qayeeng woy. En nambei se wongis Anutu Neu Moux tixemou tateis on lei. ");
INSERT INTO tbx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Xel xe qayeeng on qes ambei nye, xeiyaing lam eivek tembuing, ekom xomaxoneing laleind vind mapetok ghanaw xeiyaing en nambei xel xe kwa yon nilul. ");
INSERT INTO tbx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Xomaxoneing sapa wei mi wo kwa nilul eno mi pesek xeiyaing, om xel embei se nam eivek xeiyaing, en tyek xel xe kwa nilul on nam yanyateiv. ");
INSERT INTO tbx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ekom eti yeiw wei mi betiwou kwa wei zonghek eno mi lam eivek xeiyaing en kandek xel gyei embo nimza bei lulul wei xel mi wong eno xel mi wong xuk en Anutu xe nikanzek.” ");
INSERT INTO tbx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ka tine la veil, eno Yesu lis e xe xel betiyeing la danghei wei Yudia nei. Moxo toundei is xel anghei inyon me lipek moux alis vex. ");
INSERT INTO tbx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yoan lipek xomaxoneing is ambei nyon nanghei Ainon paviy beyeeng Salim, en nambei memiing ngenong di yeip inyon, me xomaxoneing di lam bei e zipek xel. ");
INSERT INTO tbx_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Inyon atax gyeik xel se ghei toung Yoan eivek xeitueing o. ");
INSERT INTO tbx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Xel betiyeing wei Yoan o valu is Yuda ti pyalek ama en kwa wei xel mi lipek me wo vako wou Anutu manghalus o. ");
INSERT INTO tbx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Yoan xe xel betiyeing lam neil wou e bei, “Putoung, tambiy tiwei toundei is wang anghei memiing Yorodan loxalu nei me wang neil e xe qayeeng, eno di lipek moux alis vex, me xel dalus la wou e.” ");
INSERT INTO tbx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yoan neil elox wou xel bei, “Tambiy ti teyei bei qou vatiyeiw, wangwei Anutu wei tyoung gheyapu nei bong wou e yo. ");
INSERT INTO tbx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Xam venaxow a neil teyei en qayeeng wei a neil o bei, ‘A se Kilisi, qe a tambiy tiwei Anutu wong a lam atax en e yo.’ ");
INSERT INTO tbx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tambiy ti dii vex ti eno vex tiyon e venei. De e xe gweleeng mi nale me li nenya wou tambiy wei ii vex o xe lukeing me wo xeilala ngandoung. Om gweimbeeng xeilala tiyon eno pup eivek a laleing. ");
INSERT INTO tbx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Moxo lei e zekna gheyapu, de a leing e deteiwou. ");
INSERT INTO tbx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Tambiy tiwei lam anghei gheyapu eno la ghey en lulul sapa, de tambiy wei lam anghei tembuing eno inyon tembuing, me mi luk en lul wei tembuing o. De tambiy tiwei lam anghei tyoung gheyapu eno la ghey en lulul sapa. ");
INSERT INTO tbx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Moxo mi luk en vati wei yei me ngo yo, ekom xelti se zeimaxoun e xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tambiy tiwei zeimaxoun e xe qayeeng eno talex lek bei Anutu yon zonghek ayang. ");
INSERT INTO tbx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","En tambiy tiwei Anutu wong e lam eno mi neil Anutu xe qayeeng, en Anutu wong Laweeng Vambuing dalus wou e. ");
INSERT INTO tbx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","De Ma lalei vind Neu Moux me toung lulul dalus la eivek e mema. ");
INSERT INTO tbx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Xelti bongis Neu Moux on qou mapieing luta luta, ekom xelti pesek Neu Moux on tyek se gyei mapieing, en tyek Anutu xe lalei vanei detei lek e.” ");
INSERT INTO tbx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","De Parisiyeiw ngo qayeeng bei Yesu lipek xomaxoneing me wong xel wo betiyeing ngenong ghanaw Yoan. ");
INSERT INTO tbx_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ekom Yesu venaxow se lipek xel, qe inyon e xe xel betiyeing. ");
INSERT INTO tbx_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Yesu woulek bei xel Parisi ngo tine om la veil Yudia de lox me la Galili no. ");
INSERT INTO tbx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Dom moxo tupwou sakwaing tiwei la senghoing eivek Samaria nei. ");
INSERT INTO tbx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Om moxo la eivek beyeeng nayak ti lei Sikar eivek tembuing danghei wei Samaria yo. Beyeeng tiyon toundei paviy tembuing wei Yakop wong wou neu Yosep o. ");
INSERT INTO tbx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakop xe leiveeng memiing ti toundei inyei, de Yesu nima en ingwei lam sakwaing anding o, om la dei paviy leiveeng memiing on. Inyon nambei seivma evlek o. ");
INSERT INTO tbx_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Gyeik Samaria vex ti lam en embei nam a puw memiing eno Yesu neil wou vexo, “Tyek wang bong memiing me a num?” ");
INSERT INTO tbx_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Moxo xe xel betiyeing la eivek beyeeng nayak en xel embei na bou lul yaeing. ");
INSERT INTO tbx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samaria vex neil wou e bei, “Wa Yuda ti de a Samaria vex ti. Nambei nya wang teling wou ay en numeing?” En Yudayeiw me Samariayeiw se mindei is ama. ");
INSERT INTO tbx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu lewexe wou vexo, “Wangwei wang boulek lul xeilala wei Anutu embei bong o me eti ingwei teling wang en numeing, on wa teling wou e me embong memiing wei mapieing o wou wang.” ");
INSERT INTO tbx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Vex neil wou bei, “Teiv, deng me yis wei wambei puw memiing nangya eno ma de leiveeng memiing ne la ghembi. Tyek wa qou memiing mapieing tiyon nanghei inya? ");
INSERT INTO tbx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Beip wang ghanaw xe bund Yakop, moxo wong leiveeng memiing tine wou xa de e venaxow is neuyeiw me manghaxo me sipsip is lul dalus mi num memiing tine?” ");
INSERT INTO tbx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu lewexe, “Xomaxoneing sapa wei mi num memiing tine eno tyek kwend a tip no, ");
INSERT INTO tbx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ekom xelti embei num memiing wei ambei bong wou e ne tyek kwa se tip. De memiing wei ambei bong wou e eno tyek na mi puw lulaxeiv eivek e me bong mapieing luta luta wou e.” ");
INSERT INTO tbx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","De vex neil wou e bei, “Teiv, wang bong memiing tiyon wou ay en kandek a kwang se tip no de a se mi nox me noum inye en puweing memiing.” ");
INSERT INTO tbx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Moxo neil wou vexo bei, “La, taxe leyam de muw xouing loum.” ");
INSERT INTO tbx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Vexo neil elox bei, “A leyang ma yo.” Yesu neil wou e, “Wang neil neing, gyeik ingwei wang neimbei wa leyam ma yo. ");
INSERT INTO tbx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","En nambei wa leyam lim, de moux tiwei wang toundei is ne inye se wa leyam. Qayeeng vati wei wang neil on zonghek ayang.” ");
INSERT INTO tbx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","De vexo neil wou e bei, “Teiv, a xei bei inye wa poropet ti. ");
INSERT INTO tbx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Xa bumiyeiw mi wong lalo lek lukendu tine, ekom xam Yudayeiw eno xam ghe mi neimbei beyeeng wei xomaxoneing a mi bong lalo eno eivek Yerusalem.” ");
INSERT INTO tbx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu neil teyei wou e bei, “Vex, wang bongis ay, bouk ti tyek nam eno tyek xam seng bong lalo wou Mang lek lukendu tine o eivek Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Xam Samariayeiw ghe mi wong lalo wou vati wei xam seng woulek o, de xa Yudayeiw a mi wong lalo wou vati wei xa woulek o, en vineing wei qou xa lam veil nilul eno lam wou xa Yuda. ");
INSERT INTO tbx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ekom bouk ti tyek nam, me gweimbeeng ne eno lam woy om gyeik xel embei bong lalo zonghek ond xel bong lalo wou Mang eivek Laweeng me zonghek, en Mang lalei vind xel ambei nyon bei xel a mi bong lalo wou e. ");
INSERT INTO tbx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anutu yon laweeng, om xel wei mi wong lalo wou e eno xel a mi bong lalo eivek Laweeng me eivek zonghek.” ");
INSERT INTO tbx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","De vexo neil embei, “A woulek bei Mesia tiwei xel mi taxe e bei Kilisi eno tyek nam. Om gyeik ingwei moxo embei nam, eno tyek na neil lul dalusateiv teyei wou xey.” ");
INSERT INTO tbx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Woyom Yesu neilteyei wou e bei, “A tambiy tiyon, ingwei di luk is wang ne eno inye ay.” ");
INSERT INTO tbx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Woyom ka e xe xel betiyeing loum eno xel etek en xel yei ingwei di luk is vex ti yo. Ekom xelti se teling, “Wa bei qou vati?” o “Nambei nya wang di luk is vex on?” ");
INSERT INTO tbx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Woyom vexo ghanaw e xe memiing dengmuing toundei de lox me la beyeeng me neil wou xomaxoneing dalus nambei nye, ");
INSERT INTO tbx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Xam lam wei tambiy tiwei neil wou ay en lul dalus wei a mi wong takwei yo. Beip inyei Kilisi?” ");
INSERT INTO tbx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Om xel lam veil beyeeng nayak on me la yei e. ");
INSERT INTO tbx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Dekakom e xe xel betiyeing neil wou e bei, “Putoung, wa lulul ne.” ");
INSERT INTO tbx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ekom moxo neil wou xel, “A xe yaeing wei yaing eno xam seng woulek o.” ");
INSERT INTO tbx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Woyom e xe xel betiyeing di neil wouma bei, “Beip xel valu qou lul yaeing me lam wou e?” ");
INSERT INTO tbx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu neil wou xel, “A xe lul yaeing eno nambei nye, a bei betiwou tambiy tiwei wong a lam eno lalei me na bong e xe xuk e na pyap lek. ");
INSERT INTO tbx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Beip xam seng mi neimbei, ‘Dentouk qes vey di yeip zeyi bouk wei qekuwou lulul yaeing o?’ A neil wou xam, xam ghe gweina xuk danghei danghei nei! Lulul wo neing woy teyei lek qoueing. ");
INSERT INTO tbx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Me gweimbeeng tambiy wei mi qekuwou lulul yaeing eno qou e xe xouveing me di qeku lul yaeing wei deing mapieing luta luta yo, om tambiy wei vuw lul o me tambiy wei wong xuk lek qoueing lulul neing o, eno luw xouing bo xeindlala. ");
INSERT INTO tbx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Inye xel neil, ‘Tambiy nge vuw lulul eivek xuk de nge qekuwou lulul neing’ eno qayeeng ne zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","A wong xam ghe la qekuwou lulul yaeing wei xam seng wo xuk lek o. Qe xel valu wong pok ngandoung lek, de xam ghe la qou vineing lek pok wei xel o.” ");
INSERT INTO tbx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Xel Samaria ngenong wei beyeeng nayak tiyon eno wongis Yesu, en qayeeng wei vex on neil teyei yo, “Moxo neil wou ay en lulul dalus wei a wong takwei yo.” ");
INSERT INTO tbx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Om gyeik ingwei Samariayeiw lam wou moxo eno xel neil wou bei e toumendei is xel, om moxo toundei bouk yayuw is xel. ");
INSERT INTO tbx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","En nambei Yesu xe qayeeng wei neil, eno moux alis vex ngenong wongis. ");
INSERT INTO tbx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Xel neil wou vex on, “Xa se wongis en nambei vati wei wang neil o, qe gweimbeeng xa maxow a ngo me na woulek bei inye neing ayang, tambiy tine qou xey a loum veil nilul wei tembuing sapa yo.” ");
INSERT INTO tbx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ka bouk yuw on la veil eno Yesu la Galili. ");
INSERT INTO tbx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu venaxow neil qayeeng tine, xel se mi wevek poropet ti xeinghembi eivek emaxow beeng qes. ");
INSERT INTO tbx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Om gyeik ingwei moxo la tyip Galili, eno Galiliyeiw wo xeindlala en e. En xel yei lul wei wong eivek Yerusalem gyeik mata wei Pasova yo, en xel la toundei inyei is. ");
INSERT INTO tbx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu lox me la beyeeng Kana eivek Galili no, wei nanghei inyon eno moxo pekwi memiing wo wain. De nanghei inyei eno king xe beyeiv ti neu moux vanei wong me e di yeip anghei Kapenaom. ");
INSERT INTO tbx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Woyom tambiy tiyon ngo bei Yesu la veil Yudia me la toundei Galili, eno moxo la wou e me tay wou Yesu bei e nam bong e neu moux bo nimzalek, en neu e bim amey. ");
INSERT INTO tbx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu neil wou e, “Wangwei xam ne seng gwei dee wei lulvako yo ond xam seng mi wongis.” ");
INSERT INTO tbx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","King xe beyeiv neil wou e, “Teiv, wang nam axone daing enok a neung amey.” ");
INSERT INTO tbx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu neil elox wou e bei, “Wang nox en neum tyek na toumendei mapieing.” De moux tiyon wongis qayeeng wei Yesu neil o me la. ");
INSERT INTO tbx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ka moxo di la wou sakwaing, e xe xel xukxe lam pelong e me neil wou bei, neum toundei mapieing. ");
INSERT INTO tbx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Woyom moxo teling xel en seivma wei neu wo nimzalek, eno xel neil wou e, “Gying ma veil e vezeiveeng soukeing wei seivma ti yo.” ");
INSERT INTO tbx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Woyom ma woulek bei lek seivma kayon eno Yesu neil wou e, “Neum tyek na toumendei mapieing.” Om moxo is nipapu dalus wei e beeng eno wongis. ");
INSERT INTO tbx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Inye dee wei lulvako luyuw wei Yesu wong gyeik e la veil Yudia me la toundei Galili yo. ");
INSERT INTO tbx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ka inyon la veil, eno Yesu lek me la Yerusalem en bouk ngandoung wei lalo wei Yudayeiw o. ");
INSERT INTO tbx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Eivek Yerusalem paviy tete mya wei sipsip eno lounyeing ti mi yeip inyon, xel Hibru mi neil Betesda. Xomek nayak lim toukale wou lounyeing on nenyawes. ");
INSERT INTO tbx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Xel ngenong wei vanei nelu nelu eno mi yeip eivek xomek nayak nanghei inyon, is xel wei matekeing o, me vaxa nol o me xel wei bezomb o.  ");
INSERT INTO tbx_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","En Tambiy Ngandoung xe angela ti mi lam axone eivek bouk titi me la eivek lounyeing me wo pimapi wou, de tambiy ti embei na eivek lounyeing wei di wo pimapi yon atax eno wo nimzalek veil vanei wei wong e yo. ");
INSERT INTO tbx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tambiy ti vanei me e mi yeip eivek xomek nayak wei xel byex wou yon teyei lek vakovek qes 38. ");
INSERT INTO tbx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu yei moxo di yeip inyon eno woulek bei vanei wong e me e mi yeip enden, Yesu teling wou e, “Wa being bo nimzalek?” ");
INSERT INTO tbx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Tambiy wei vanei yon neil elox bei, “Teiv, xel wei embei devind a na eivek memiing gyeik ingwei embei bo pimapi eno ma. A venaxow a mi wong me na xei en ambei na eivek, ekom xel valu mi la eivek ghanaw ay.” ");
INSERT INTO tbx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Woyom Yesu neil wou e, “Qandi lek! De qou wa xe ghus me la.” ");
INSERT INTO tbx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Lutika eno moux on wo nimzalek, de moxo qou e xe ghus me la. Bouk tiyon eno inye Sabat, ");
INSERT INTO tbx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","om xel teivateiv wei Yudayeiw o neil wou moux tiwei wo nimzalek o, “Inye Sabat, petieing peti bei wa se qalei wa xe ghus lek.” ");
INSERT INTO tbx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ekom moxo neil elox bei, “Tambiy tiwei wong a wo nimzalek eno neil wou a bei, ‘Qou wa xe ghus me la vaxam.’” ");
INSERT INTO tbx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Om xel teling e, “Tambiy eti ingwei neil embei wa qou ghus me ghe na vaxam on?” ");
INSERT INTO tbx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Moux tiwei wo nimzalek eno loungen tambiy tiwei neil o, en Yesu la xupekeing eivek xel ngenong senghoing me la. ");
INSERT INTO tbx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kalekom Yesu yei e nanghei tete lalei wei xomek vambuing nei me neil wou e, “Wei, wang wo nimzalek woy. Om wa seng nox bong sewokeing no, enok nimaying ngandoung ti qandi wou wang.” ");
INSERT INTO tbx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Woyom moux tiyon la neil wou teivateiv wei Yudayeiw o bei, “Tambiy tiwei wong a wo nimzalek eno inyon Yesu.” ");
INSERT INTO tbx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Om nambei Yesu di wong lulti beimambei yon lek Sabat, om teivateiv wei Yudayeiw di wo nol wou e. ");
INSERT INTO tbx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu neil elox wou xel, “Mang mi wo xuk taxombouk me elam gweimbeeng, me ay is ambei nyon, a mi wo xuk.” ");
INSERT INTO tbx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","En qes tine Yudayeiw mi wo niqetyei qetyei en embei nyeis Yesu na mey, en se ingwei pyalek petieing wei Sabat o, qe mi neil embei e ma Anutu. Me wong emaxow teyei lek Anutu. ");
INSERT INTO tbx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu lewexe wou xel, “A neil wou xam zonghek, Neu Moux se mi wong lulti nangya emaxow xe kwa, qe moxo tyek bong lul kawei yei Ma wong o, en nambei vatiyeiw wei Ma wong eno Neu Moux tyek bong ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","En Ma lalei vind Neu Moux me talex lulul dalus wei mi wong eno wou e. De ingwei embei bong etekeing wou xam eno Ma tyek talex lul ngandoung valu wou e ghanaw inyon veil. ");
INSERT INTO tbx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","En Ma mi piyexe xel wei mey o me wong mapieing wou xel, om Neu Moux is ambei nyon, moxo mi wong mapieing wou xomaxoneing teyei lek emaxow lalei. ");
INSERT INTO tbx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ma se mi wong qayeeng en xelti, qe wong xuk dalus wei wongeing qayeeng eno wou Neu Moux, ");
INSERT INTO tbx_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","om xel dalus a mi sanghoxe Neu Moux nambei ingwei xel mi sanghoxe Ma yo. Xelti embei se sanghoxe Neu Moux on tyek se sanghoxe Ma tiwei wong e lam o. ");
INSERT INTO tbx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Neing ayang, a neil wou xam, xel tiwei ngo a xe qayeeng me wongis tambiy tiwei wong a lam eno qou mapieing luta luta woy de tyek se teyei bei bale lek qayeeng me na qou myaveweeng. Qe moxo sek me lam veil meyeing woy, de la dei mapieing. ");
INSERT INTO tbx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Neing ayang, neing ayang, a neil wou xam, bouk di lam me gweimbeeng ne eno lam gyeik ingwei xel meyeing embei ngo Anutu Neu Moux vya yo me xelti embei ngowou eno dei mapieing. ");
INSERT INTO tbx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","En Ma xe mapieing toundei eivek emaxow, om moxo wong nikanzek wou Neu Moux bei e qou mapieing eivek venaxow. ");
INSERT INTO tbx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Me Ma wong lei ngandoung wou e bei e mi bong qayeeng en moux alis vex, en nambei e Xomaxoneing Neu Moux. ");
INSERT INTO tbx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Xam seng bou naleimim ngenong en qayeeng tine, en bouk di lam, gyeik ingwei xel wei mey me di yeip eivek xel xe leiveeng meyeing eno tyek na ngo e vya ");
INSERT INTO tbx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","me lam myayaing. Xel wei mi wong kwa nimza eno tyek qandi lek me mendei mapieing, de xel wei mi wong kwa nilul eno tyek qandi lek me na qou myaveweeng. ");
INSERT INTO tbx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","A maxow se mi wong lulti, qe a mi wong qayeeng nambei ingwei a ngo yo, dom na mi zeim qayeeng en moux alis vex. Me qayeeng wei a mi zeim eno mi la bombek, en a se mi wong xeinglala en venaxow qe a mi wong e tiwei wong a lam o wo xeilala. ");
INSERT INTO tbx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Wangwei a neil qayeeng wei a maxow o teyei, ond qayeeng wei a neil on se zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ekom inyei tambiy nge mi neil qayeeng wei ay yo teyei. Me a woulek bei e xe qayeeng on zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Xam ghe wong xel la wou Yoan me e neil qayeeng wei zonghek o teyei. ");
INSERT INTO tbx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","A maxow se qou xomaxoneing xe qayeeng, qe a neil en ambei Anutu devind xam. ");
INSERT INTO tbx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yoan on nambei lam wei tum me wo xeiyaing om xam ghe beyal me ghe wo xeimimlala wou xeiyaing sepika. ");
INSERT INTO tbx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Ekom a xe qayeeng ne eno ghanaw ingwei Yoan o. En xuk dalus wei Mang wong wou ay bei a bong me e ma, eno neil a teyei wou moux alis vex bei Mang wong a lam. ");
INSERT INTO tbx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","De Mang wei wong a lam eno venaxow tul qayeeng en ay. Ekom xam seng mi ngo e vya o ghe mi wei e ma. ");
INSERT INTO tbx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","O moxo xe qayeeng wei mi neil eno se dei eivek xam laleimim, en xam seng wongis e tiwei moxo wong e lam o. ");
INSERT INTO tbx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Xam ghe mi pyaw qayeeng qes wei yeip eivek xoulek me ghe wou naleimim bei tyek xam a qou mapieing luta luta. Qayeeng ti beimambei yon mi neil a teyei, ");
INSERT INTO tbx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ekom xam ghe pesek, en xam ambei seng nam wou ay me na qou mapieing. ");
INSERT INTO tbx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ambei se qou lei ngandoung wou xomaxoneing, ");
INSERT INTO tbx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ekom a woulek xam. A woulek bei xam seng qou Anutu xe lalei vineing eivek laleimim. ");
INSERT INTO tbx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","A lam lek Mang lei, eno xam seng qou ay, qe wangwei xel nge nam lek e venaxow lei ond tyek xam a qou e. ");
INSERT INTO tbx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Xam ghe mi pamilexe lei ngandoung wei xam ghe mi wong wouma yo de lei ngandoung wei lam wou Anutu venaxow eno xam a bei se qou. Om tyek xam ghe bongis ambei nya? ");
INSERT INTO tbx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Ekom xam seng bou naleimim bei tyek a byex qayeeng lek xam wou Mang manghalus, qe tambiy wei embei byex qayeeng lek xam eno inyon Mose, tambiy tiwei xam ghe toung mamim wou bei tyek devind xam o. ");
INSERT INTO tbx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Wangwei xam ghe bongis Mose on tyek xam ghe bongis ay, en moxo byex qayeeng en ay. ");
INSERT INTO tbx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ekom xam seng wongis qayeeng wei byex o, om nambei nya tyek xam ghe bongis vati wei ambei neil o?” ");
INSERT INTO tbx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ka bouk valu lak veil en inyon, eno Yesu la lounyeing Galili loxalu nei, inyei lounyeing lei nge eno Taiberias. ");
INSERT INTO tbx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","De xomaxoneing ngenongakes betiy e me la, en nambei xel yei dee wei lulvako wei wong xel wei vanei eno wo nimzalek o. ");
INSERT INTO tbx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Woyom Yesu lek lukendu me la toundei is e xe xel betiyeing. ");
INSERT INTO tbx_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","De Yudayeiw xe bouk ngandoung wei Pasova eno lam paviy. ");
INSERT INTO tbx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Gyeik ingwei Yesu veilma lek me yei xomaxoneing ngenong di lam wou e, eno neil wou Pilip bei, “Tyek xey a bou belet anghei inya me na bong wou xel beimambei ne en xel gya?” ");
INSERT INTO tbx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Moxo teling tine en embei daxe Pilip, en moxo wounalei en vati wei embei bong o woy. ");
INSERT INTO tbx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilip lewexe wou e bei, “Wangwei xey a bou belet lek malew vaxak yuw on tyek se teyei xel ne titi bei xel gya nayak kaka!” ");
INSERT INTO tbx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Moxo xe betiyeing nge inyon Andrias wei Simon Petele li eno luk bei, ");
INSERT INTO tbx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Yak ti toundei inye eno di qou bali belet nayak lim de woing nayak yayuw, ekom tyek inye devind xomaxoneing ngenong ne nambei nya?” ");
INSERT INTO tbx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu neil embei, “Xam neil wou xomaxoneing on en xel mendei tembuing o.” Qeis ngenong toundei inyon, om xel dei lek. De moux wei dei yon teyei lek ambei 5,000. ");
INSERT INTO tbx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Woyom Yesu qou belet me wong dange wou Anutu de wong wou xomaxoneing dalus wei toundei inyon eno xel ya me enden xel. Moxo wong ambei nyon wou woing is. ");
INSERT INTO tbx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ka xel dalusateiv ya woy, moxo neil wou e xe xel betiyeing bei, “Xam qekuwou myapapu wei toundei yo en kandek ti se nati.” ");
INSERT INTO tbx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Om xel qekuwou myapapu wei belet lim wei xel ya de toundei yo me sei eivek pasik xoumeeng yuw me epup. ");
INSERT INTO tbx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ka xomaxoneing yei dee wei lulvako wei Yesu wong o, eno xel neil embei, “Neing ayang inye Poropet tiwei Anutu neil embei bong e nam lek tembuing o.” ");
INSERT INTO tbx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesu woulek bei xel embei nam tendu e me embo king wei xel o, om moxo venaxow la veil xel me lox me la lukendu no. ");
INSERT INTO tbx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Sayeiv la eivek, eno e xe xel betiyeing lep me la xo wei lounyeing nei, ");
INSERT INTO tbx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","de xel la eivek bot ti me sepa lounyeing me la Kapenaom. Inye bouk, de Yesu se ghei la wou xel. ");
INSERT INTO tbx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Laweeng nikanzek ti vei om lounyeing vuklek. ");
INSERT INTO tbx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Xel di sepa me la teyei lek kilomita lim o limti, de xel yei Yesu di la lek lounyeing mapu me la paviy xel om xel yaleeng ngandoung. ");
INSERT INTO tbx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ekom moxo neil wou xel bei, “Inye ay yo, om xam seng gwaleeng.” ");
INSERT INTO tbx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Woyom xel toung laleind lekti bei qou e me na eivek bot, de lutika eno bot la nenyawes lek beyeeng tiwei xel embei na yo. ");
INSERT INTO tbx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Bouk nge eno moux alis vex nanghei toundei lounyeing nenyawes nge loxalu nei en xel yeimend wou bei bot tixemou di yeip inyei, de Yesu se la is e xe xel betiyeing, qe xel venaxow la. ");
INSERT INTO tbx_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Woyom xel Taiberias xe bot valu lam paviy beyeeng wei Tambiy Ngandoung wong dange en belet me xel ya yo. ");
INSERT INTO tbx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","De xel qendu yon yeimend wou bei Yesu lis e xe xel betiyeing se toundei. Om xel la eivek bot ti beimambei yon me la Kapenaom en xel embei na gyimexe Yesu. ");
INSERT INTO tbx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Gyeik ingwei xel yeiwou e nanghei lounyeing loxalu nei, eno xel teling e, “Putoung, wang lam inye gyeik inya?” ");
INSERT INTO tbx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu lewexe, “A neil wou xam zonghek, xam seng wimexe ay en ingwei xam ghe wei dee wei lulvako yo, qe en ingwei xam ghe wa belet me e den xam o. ");
INSERT INTO tbx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Xam seng bong xuk en lul yaeing wei mi wo nol o, qe en lul yaeing wei emi mendei mapieing luta luta yo, wei Xomaxoneing Neu Moux tyek bong wou xam o. En moxo eno Ma Anutu beyal bei e bong lei ngandoung me bong ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Woyom xel teling wou moxo, “Xa bong vati me na bong Anutu xe xuk?” ");
INSERT INTO tbx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu lewexe bei, “Anutu xe xuk eno nambei nye: Xam ghe bongis tambiy tiwei Anutu wong e lam o.” ");
INSERT INTO tbx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Om xel teling wou e, “Tyek wang bong dee wei lulvako vati yo en xa ghei me na bongis wang? Tyek wang bo vati? ");
INSERT INTO tbx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Xa bumiyeiw ya mana eivek tembuing bandaing, nambei xel byex eivek xoulek bei, ‘Moxo wong belet wei tyoung gheyapu yo me xel ya.’” ");
INSERT INTO tbx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu neil wou xel, “A neil wou xam zonghek, inye Mose se wong belet wei tyoung gheyapu eno wou xam, qe Mang wong belet zonghek wei tyoung gheyapu eno wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","En belet wei Anutu xe eno inye e tiwei lam axone nanghei tyoung gheyapu nei me wong mapieing wou xomaxoneing wei tembuing sapa yo.” ");
INSERT INTO tbx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Xel neil embei, “Teiv, wa mi bong belet tiyon wou xa taxombouk.” ");
INSERT INTO tbx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Woyom Yesu neilteyei bei, “A maxow belet wei mapieing o. Xelti embei nam wou ay eno tyek se na maxep, me xelti embei bongis ay eno tyek kwa se tip en memiing. ");
INSERT INTO tbx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Ekom nambei a neil wou xam o, xam ghe wei ay ekom xam se ghei wongis. ");
INSERT INTO tbx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Xel dalus wei Mang wong wou ay eno tyek nam wou ay, de xelti embei nam wou ay eno tyek a se saing xel. ");
INSERT INTO tbx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","En a lep me lam anghei tyoung gheyapu nei en ambei se betiwou a maxow xe woueing nalei, qe woueing nalei wei tambiy tiwei wong a lam o. ");
INSERT INTO tbx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","De lalei vineing wei tambiy tiwei wong a lam eno nambei nye, tyek a se saing xel wei wong wou ay eno ti, qe tyek a piyexe xel lek bouk loxyus. ");
INSERT INTO tbx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","En Mang xe woueing nalei nambei nye xel eti yeiw wei yei Neu Moux me wongis e eno tyek na qou deing mapieing luta luta, de tyek a piyexe e lek bouk loxyus.” ");
INSERT INTO tbx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Woyom Yudayeiw ngo inyon eno xel luk niseik seik en nambei moxo neil embei, “A belet wei lam axone nanghei tyoung gheyapu yo.” ");
INSERT INTO tbx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xel neil embei, “Beip inye se Yesu Yosep neu wei xey a woulek ma luw ta yo? Nambei nya gweimbeeng neil embei, ‘A lam axone nanghei tyoung gheyapu’?” ");
INSERT INTO tbx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ekom Yesu neil elox bei, “Xam tip lukeing ngenong on eivek xam venaxow senghoing. ");
INSERT INTO tbx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Xelti tyek se nam wou ay qe ka Mang tiwei wong a lam eno na puw e nam le, de tyek a piyexe e qandi lek bouk loxyus. ");
INSERT INTO tbx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Qayeeng yeip eivek xoulek wei xel poropet byex o bei, ‘Anutu tyek teyoxe xel.’ Xel eti yeiw wei mi ngo Mang me qou kwa wou e eno tyek nam wou ay. ");
INSERT INTO tbx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Xelti se yei Mang. Qe e tiwei toundei is Anutu me lam eno emaxow yei Ma. ");
INSERT INTO tbx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","A neil wou xam zonghek, e tiwei mi wongis eno qou mapieing luta luta. ");
INSERT INTO tbx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A maxow belet wei mapieing o. ");
INSERT INTO tbx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Xam bumimyeiw ya mana eivek tembuing bandaing, ekom xel mey. ");
INSERT INTO tbx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ekom inye belet wei lam axone nanghei tyoung gheyapu, bei xomaxoneing gya dom xel se mey. ");
INSERT INTO tbx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","A maxow belet wei mapieing wei lam axone nanghei tyoung gheyapu yo. Wangwei xelti embei gya belet tine, on tyek mendei mapieing luta luta. Belet tine inye a leyeis, wei tyek a bong bei embong mapieing wou xomaxoneing wei tembuing sapa yo.” ");
INSERT INTO tbx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Woyom Yudayeiw di pyalek ama eivek xel venaxow senghoing me neil, “Nambei nya tambiy tine tyek bong emaxow leyeis me xey a gha?” ");
INSERT INTO tbx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu neil wou xel, “A neil wou xam zonghek, wangwei xam ambei seng gwa Xomaxoneing Neu Moux leyeis me na num e gyand ond xam seng qou mapieing eivek xow. ");
INSERT INTO tbx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Xelti embei gya a leyeis me na num a gyand on tyek na qou mapieing luta luta, de tyek a piyexe e lek bouk loxyus. ");
INSERT INTO tbx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","En a leyeis on yaeing zonghek me a gyand on numeing zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Xelti embei gya a leyeis me na num a gyand yond mindei eivek ay de a mindei eivek e. ");
INSERT INTO tbx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nambei ingwei Mang wei mapieing eno wong a lam me a toundei mapieing en Mang, om xelti embei gya a leyeis on tyek mendei mapieing en ay. ");
INSERT INTO tbx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tine inye belet wei lam axone nanghei tyoung gheyapu nei yo. Xam bumimyeiw ya mana de mey, ekom xelti embei gya belet tine ond tyek mendei mapieing luta luta.” ");
INSERT INTO tbx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu neil lul tine gyeik ingwei di teyoxe xel eivek xomek qekueing ama nanghei Kapenaom o. ");
INSERT INTO tbx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Xel ngo inyon de e xe xel betiyeing ngenong neil, “Teyoxeing on wo nimaying. Eti tyek na zeimaxoun inyon?” ");
INSERT INTO tbx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu woulek bei e xe xel betiyeing di luk ngenong en tine, om Yesu neil wou xel, “Qayeeng tine wo nol wou xam laleimim? ");
INSERT INTO tbx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wangwei xam ghe gwei ingwei Xomaxoneing Neu Moux nox me na tyoung gheyapu wei mindei takwei yo on tyek xam ghe bou naleimim ambei nya? ");
INSERT INTO tbx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Laweeng mi wong mapieing wou moux alis vex. Xe neing se teyei bei devind xey. Qayeeng beimambei wei a neil wou xam eno inyon laweeng me xel on mapieing. ");
INSERT INTO tbx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ekom xam valu seng wongis.” En myaxeeng eno Yesu woulek e tiwei se wongis o me tyek na toung e na eivek xel ba memend o. ");
INSERT INTO tbx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Moxo tetulexe me neil embei, “Inye vati wei a neil wou xam bei xelti se teyei bei nam wou ay, qe ka Mang bo nikanzek wou e le.” ");
INSERT INTO tbx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Lek bouk tiyon eno e xe xel betiyeing ngenongakes pekwi me lox me la de xel se betiwou e no. ");
INSERT INTO tbx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu teling wou e xe xel betiyeing xoumeeng yuw on bei, “Xam is xam ambeing na veil ay?” ");
INSERT INTO tbx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petele lewexe wou e, “Tambiy Ngandoung, tyek xa na wou eti? Wa xe qayeeng on mi wo mapieing luta luta. ");
INSERT INTO tbx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Xa wongis me na woulek bei wang on Vambuing tiwei Anutu yo.” ");
INSERT INTO tbx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Woyom Yesu neil elox bei, “A beyal xam xoumeeng yuw. Ekom xam on ti eno laweeng nol!” ");
INSERT INTO tbx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Moxo neil inyon en Yudas wei Simon Iskariot neu moux o, inyon xel xoumeeng yuw eno ti, wei tyek na neil e teyei me na toung e na eivek xel ba memend o. ");
INSERT INTO tbx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ka tine la veil eno Yesu la di ghavineeng eivek Galili, en embei se nox Yudia en Yudayeiw embei nyeis e mey. ");
INSERT INTO tbx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ekom gyeik ingwei xel Yudayeiw xe Bouk ngandoung wei Xomek Laweeng eno paviy, ");
INSERT INTO tbx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","om Yesu liyeiw neil wou e, “Wang na veil Galili me ghe na Yudia, en kandek wa xe xel betiyeing gyei lulvako wei wa being bong o. ");
INSERT INTO tbx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wangwei xelti embei xomaxoneing boulek bei e lei ngandoung on se mi wong xuk eivek xupekeing. Wangwei wa being bong lulti beimambei yon, ond wa talex xow wou xomaxoneing wei tembuing sapa nei.” ");
INSERT INTO tbx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Embong emaxow liyeiw le, ekom xel se wongis e. ");
INSERT INTO tbx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nambei nyon Yesu neil wou xel, “A xe bouk se ghei lam, qe bouk dalus ne eno inye xam xe bouk nimza. ");
INSERT INTO tbx_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Xel xomaxoneing wei tembuing ne eno se teyei bei bo nol wou xam, qe xel mi wo nol wou ay en a mi neil kwa nilul wei xel mi wong o teyei. ");
INSERT INTO tbx_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Xam ghe na Bouk ngandoung on. Dom tyek a se zek me nana Bouk ngandoung tiyon, en nambei a xe bouk se ghei lam.” ");
INSERT INTO tbx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ka neil ambei nyon wou xel woy, dom toundei Galili. ");
INSERT INTO tbx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ka liyeiw la Bouk ngandoung veil, om moxo la is ambei nyon, se la yanyateiv, qe la xupekeing. ");
INSERT INTO tbx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","De eivek Bouk ngandoung eno teivateiv wei Yudayeiw toundei me di yei e teyei teyei me teling bei, “Tambiy tiwei yo inya?” ");
INSERT INTO tbx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eivek xel wei qekuma yon senghoing eno xel di ngoung lumama wouma me luk en moxo. Xel valu neil embei, “Moxo nimza.” De xel valu neil elox bei, “ Ma, tambiy on mi tyoxe xomaxoneing.” ");
INSERT INTO tbx_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ekom xelti se neil lulti yeip yaing lek moxo en xel yaleeng en teivateiv wei Yudayeiw o. ");
INSERT INTO tbx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Eivek bouk senghoing wei Bouk ngandoung eno Yesu lek me la eivek tete lalei wei xomek vambuing o me di teyoxe moux alis vex. ");
INSERT INTO tbx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","De Yudayeiw etek me teling bei, “Tambiy nei qou lupeyei nei nambei nya moxo se wevek ti?” ");
INSERT INTO tbx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu lewexe, “A xe teyoxeing ne inye se a maxow xe. Qe inye lam wou tiwei wong a lam o. ");
INSERT INTO tbx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wangwei xelti beyal bei bong e teyei lek Anutu lalei ond tyek gyei bei teyoxeing wei a ne lam wou Anutu, o a di neil angya a maxow kwang. ");
INSERT INTO tbx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Xelti embei neil qayeeng angya emaxow xe kwa ond inyon mi sanghoxe xow, ekom xelti embei bong xuk me sanghoxe tiwei wong e lam o lei, ond inyon tambiy wei zonghek o. De tyonyeing ma veil e. ");
INSERT INTO tbx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Beip Mose se wong petieing wou xam? Ekom xam ti seng mi betiwou. Nambei nya xam a being nyeis a mey?” ");
INSERT INTO tbx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Xel wei qekuma yon lewexe bei, Memo ti nale eivek wang. “Eti embei nyeis wang?” ");
INSERT INTO tbx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu neil wou xel, “A wong lulvako ti eno xam dalus ghe etek. ");
INSERT INTO tbx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mose wong kwa wei ghuweing ninavi yo, ekom inyon Mose venaxow se wong kwa yon qe inyon lam wou xe bundyeiw, om xam ghe mi ghuw yak ninavi lek bouk wei Sabat o. ");
INSERT INTO tbx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Wangwei xam ambei mi ghuw yakyeis ninavi lek bouk wei Sabat o en kandek xam se pyalek Mose xe petieing, on nambei nya xam laleimim mi wo vanei wou ay en ingwei ambei bong tambiy ti bo nimzalek Sabat o? ");
INSERT INTO tbx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Xam a tip pepyawexeing lul wei xam a being gwei nangya mamim o, de xam pepyawexe en sakwaing bombek.” ");
INSERT INTO tbx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","En qes tiyon xomaxoneing valu wei Yerusalem nei teling, “Beip inyei tambiy tiwei xel embei nyeis e mey o? ");
INSERT INTO tbx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Inye moxo di luk wou xel yanyateiv me xel di yei me ngo e ekom xelti se nale zeyi e, en beip xel gyovaxa woulek neing bei e Kilisi? ");
INSERT INTO tbx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ekom xey a woulek ingwei tambiy tine lam anghei yo, de gyeik ingwei Kilisi embei nam eno tyek xelti se boulek ingwei lam anghei yo.” ");
INSERT INTO tbx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Woyom Yesu nanghei di teyoxe xel eivek tete lalei wei xomek vambuing o, me taxe bei, “Ee, xam ghe woulek ay, me xam ghe woulek ingwei a lam anghei yo? A se lam inye nangya a venaxow xe woueing nalei, qe tambiy tiwei wong a lam eno inye zonghek. De xam seng woulek e, ");
INSERT INTO tbx_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ekom a woulek e en nambei a lam anghei ingwei e toundei nei de moxo wong a lam.” ");
INSERT INTO tbx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Gyeik ingwei Yesu neil tiyon eno xel di wong me yei en xel embei zeimaxoun moxo, ekom xelti se ax mema lek e en nambei moxo xe bouk se ghei lam. ");
INSERT INTO tbx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Moux alis vex ngenong wei toundei eivek qekueing ama yon eno wongis Yesu. Xel neil embei, “Gyeik ingwei Kilisi embei nam eno tyek bong dee wei lulvako yo ngenong ghanaw tambiy tine?” ");
INSERT INTO tbx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","De xel Parisi ngo ingwei moux alis vex di ngoung wouma en lul wei e wong o. Woyom xel lumuki leitata yo me xel Parisi wong xel belimbo wei mi yeiteyei xomek vambuing eno la en xel embei na zeimaxoun e. ");
INSERT INTO tbx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu neil embei, “Tyek a toumendei bouk sepika is xam, dekakom nana wou tambiy tiwei wong a lam o. ");
INSERT INTO tbx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Tyek xam ghe gwimexe ay, ekom tyek xam seng gweiwou ay, me ingwei a la toundei nei, eno xam seng teyei being nam.” ");
INSERT INTO tbx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","De Yudayeiw di neil wouma bei, “Tambiy tine tyek na inya me xe se ghei e? Tyek moxo na wou xel wei xey o, wei xel mindei lala eivek xel Grik senghoing o me teyoxe xel Grik? ");
INSERT INTO tbx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Moxo neil tine en qes ambei nya gyeik ingwei e neil embei, ‘Tyek xam ghe gwimexe ay ekom tyek xam seng gweiwou ay,’ me ‘Ingwei a la toundei nei, eno tyek xam seng nam?’” ");
INSERT INTO tbx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Lek bouk ngandoung tiwei yus o, eno Yesu nale me taxe bei, “Wangwei xelti kwa tip en memiing ond wong e lam wou ay me num. ");
INSERT INTO tbx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Xelti embei bongis ay nambei Xoulek neil o, on tyek memiing veleivlei wei mapieing eno mendi na eivek e lalei me qapyex me na.” ");
INSERT INTO tbx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ekom neil en Laweeng wei xelti embei bongis e eno tyek na qou yo. De ela tyip bouk tine eno Laweeng seng ghei lam, en Yesu seng ghei wo lei ngandoung. ");
INSERT INTO tbx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Xel ngo e xe qayeeng tiyon, eno xomaxoneing valu neil embei, “Neing ayang tambiy tiyon Poropet.” ");
INSERT INTO tbx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","De xel valu neil embei, “Moxo Kilisi.” De xel valu teling bei, “Nambei nya Kilisi tyek nam anghei Galili? ");
INSERT INTO tbx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Beip xoulek se neil embei Kilisi tyek nam eivek Dawit neumambu me nam anghei Betelem, beyeeng wei Dawit mindei lek o?” ");
INSERT INTO tbx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","En nambei Yesu om xomaxoneing dembuma. ");
INSERT INTO tbx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Xel valu embei zeimaxoun e, ekom xelti se ax mema lek moxo. ");
INSERT INTO tbx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Se denlek en xel belimbo wei xomek vambuing o lox me la wou xel lumuki leitata yo me Parisiyeiw, xel teling wou xel, “Nambei nya xam seng qou e me ghe lam lalei?” ");
INSERT INTO tbx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Xel belimbo neilteyei bei, “Xelti se mi neil qayeeng ambei tambiy tine.” ");
INSERT INTO tbx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Xel Parisi neil wou xel bei, “Moxo tyoxe xam is ambei nyon? ");
INSERT INTO tbx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Beip xam ghe wei bei xel gyovaxa me xel Parisi ti wongis e? ");
INSERT INTO tbx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ma! Ekom xel qendu tiyon se woulek lulti eivek petieing. Om tyek Anutu bong myaveweeng wou xel.” ");
INSERT INTO tbx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimas, tambiy tiwei la wou Yesu takwei eno inyon ingwei xel o ti, om teling, ");
INSERT INTO tbx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Beip petieing wei xey o neil embei xey a bo qayeeng en xelti bandaing? Ma, myaxeeng eno xey a ngo e xe qayeeng me na ghei bei e wong vati?” ");
INSERT INTO tbx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Xel neil elox bei, “Wang on Galili is? Wimexe e wo nimza eivek Anutu xe qapiya me wei, Poropet ti tyek se nam eivek Galili.” ");
INSERT INTO tbx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Woyom xel titi lox me la bend bend. ");
INSERT INTO tbx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ekom Yesu la lukendu Oliv. ");
INSERT INTO tbx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ka satiboukeing lul eno moxo lox me la tete lalei wei xomek vambuing o no, me xomaxoneing qekuma vivekwou e, de moxo dei me di teyoxe xel. ");
INSERT INTO tbx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","De xel putoung wei petieing o me xel Parisi yei vex wei mi wong kwapesiv o ti me qou me lam. Xel wong vexo nale wou xomaxoneing wei toundei eivek qendu yon mend ");
INSERT INTO tbx_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","me neil wou Yesu, “Putoung, xa xei vex tine wo kwapesiv. ");
INSERT INTO tbx_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Eivek petieing eno Mose neil embei xey a banex vex ambei nye en qakous me e mey. Wambei neil vati?” ");
INSERT INTO tbx_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xel wong telinyeing tiyon wou e nambei lepulek, en xel di yimexe qes wei xel embei bong qayeeng en e yo. Ekom Yesu dundek me di byex lek tembuing en mema deyis. ");
INSERT INTO tbx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Xel di embek teling e ngenong om moxo nale ghey me neil wou xel, “Wangwei xelti se mi bong sewokeing nei ond e banex vexo en qakous atax.” ");
INSERT INTO tbx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Moxo lox me la dundek no me di byex lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Xel ngo qayeeng on eno xel titi la veil inyon xel wei vakovek qes ngenong eno la tax de xel valu la yus. Dom Yesu venaxow toundei de vex on toukale inyon. ");
INSERT INTO tbx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu nale ghey me teling wou vexo bei, “Vex, xel la inya? Beip xelti se toundei bei bo qayeeng en wang?” ");
INSERT INTO tbx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Vexo neil embei, “Ma, teiv, xelti se toundei.” Woyom Yesu neilteyei bei, “Ay is ambei nyon a se wo qayeeng en wang. La de wa seng nox me na bong sewokeing no.” ");
INSERT INTO tbx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu lox me la luk wou xomaxoneing no, eno moxo neil embei, “A xeiyaing wei tembuing o. Xelti embei betiwou ay eno tyek se teyei bei na eivek mapetok, qe tyek na qou xeiyaing wei mapieing o.” ");
INSERT INTO tbx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Xel Parisi neil wou moxo bei, “Wang mi neil xuk me kwa wei wamaxow o teyei, om qayeeng wei wang on se neing.” ");
INSERT INTO tbx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu lewexe bei, “Ee, a neil lulti beimambei ne lek venaxow, a xe qayeeng ne neing, en a woulek ingwei a lam anghei yo de ingwei ambei na yo. Ekom xam seng woulek ingwei a lam anghei yo me ingwei ambei na yo. ");
INSERT INTO tbx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Xam ghe mi wo qayeeng en kwa wei xomaxoneing o, a se mi wo qayeeng en xelti. ");
INSERT INTO tbx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ekom wangwei ambei bo qayeeng en xelti, ond a xe qayeeng on zonghek, en nambei se a maxow, qe a mi nale is Mang, tiwei wong a lam o. ");
INSERT INTO tbx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Eivek xam venaxow xe petieing eno xel byex ambei nye, wangwei tambiy yayuw embei neil qayeeng teyeima ond luw xe qayeeng on zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","A maxow a mi neil qayeeng en venaxow, de tiwei mi yeimawou yo eno inye Mang tiwei wong a lam o.” ");
INSERT INTO tbx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Woyom xel teling moxo, “Wa mam inya?” Yesu neil elox bei, “Xam seng woulek a Mang. Wangwei xam ghe boulek ay on tyek xam ghe boulek Mang is ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Moxo neil qayeeng tine gyeik di teyoxe xel eivek tete lalei wei xomek vambuing o paviy ingwei xel mi toung da eivek o. Ekom xelti se zeimaxoun e en nambei e xe bouk seng ghei lam. ");
INSERT INTO tbx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu neil no wou xel, “A la, dom tyek xam seng gwei ay, de tyek xam amey eivek sewokeing wei xam o. De ingwei ambei na nei eno tyek xam seng nam.” ");
INSERT INTO tbx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Qayeeng tiyon wong Yudayeiw teling wouma bei, “Tyek moxo nyeis venaxow amey? Om neil embei, ‘Ingwei ambei na eno xam seng teyei bei nam’?” ");
INSERT INTO tbx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ekom Yesu tetulexe bei, “Xam on anghei nge xone de ay anghei nge gheyapu. Xam anghei tembuing de a se nanghei tembuing ne. ");
INSERT INTO tbx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","A neil wou xam woy bei tyek xam amey eivek xam xe sewokeing, wangwei xam seng bongis bei A Maxow Mindei Bei Nye, on tyek xam amey eivek sewokeing wei xam o.” ");
INSERT INTO tbx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Xel teling, “Wang eti?” Yesu neil elox bei, “Kayon a neil wou xam myaxeeng eno. ");
INSERT INTO tbx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","A xe qayeeng ngenong di yeip en ingwei ambei neil me na bong qayeeng en xam o. Ekom tambiy tiwei wong a lam eno e xe kwa yon zonghek, yom vati wei a ngo wou e eno a neil wou xomaxoneing wei tembuing sapa yo.” ");
INSERT INTO tbx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Xel se woulek ingwei Yesu di neil wou xel en Ma yo. ");
INSERT INTO tbx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Om Yesu neil embei, “Gyeik ingwei xam a zeim Xomaxoneing Neu Moux zekna, woyom tyek xam ghe boulek bei A maxow a mindei bei nye de a se mi wong lulti nangya kwang, qe a mi neil qayeeng nambei kawei Mang teyoxe wou ay yo. ");
INSERT INTO tbx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tambiy tiwei wong a lam eno mindei is ay, moxo se mi saing ay de a maxow a mindei, en a mi wong vatiyeiw wei e lalei vind o.” ");
INSERT INTO tbx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Xomaxoneing ngo ingwei moxo neil ambei nyon, eno xel ngenong wongis e. ");
INSERT INTO tbx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu neil wou Yudayeiw wei wongis e yo bei, “Wangwei xam a zeimaxoun a xe qayeeng teyoxeing, ond neing ayang xam on a xe betiyeing. ");
INSERT INTO tbx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Woyom tyek xam ghe boulek qayeeng zonghek, de qayeeng zonghek na tul xam ghe na nivax.” ");
INSERT INTO tbx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Xel lewexe lek e bei, “Xa ne Apraham neumambu, xa se xukxe bandaing wei xelti yo. Nambei nya wang neimbei tyek xa na nivax?” ");
INSERT INTO tbx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu neil elox bei, “A neil zonghek wou xam, xel sapa wei mi wong sewokeing eno xel on xukxe bandaing wei sewokeing o. ");
INSERT INTO tbx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Xukxe bandaing ti se mindei is mamata me neuyeiw takwei takwei qe neu mindei takwei takwei. ");
INSERT INTO tbx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Om wangwei Neu Moux na tul xam ghe na nivax, ond xam ghe la nivax zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","A woulek bei xam on velei wei Apraham o, ekom xam a being nyeis a mey, en nambei a xe qayeeng se yeip eivek xam laleimim. ");
INSERT INTO tbx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","A mi neil wou xam en vati wei a xei lam wou Mang o, de xam ghe mi wong vati wei xam ghe ngo wou xam mamim.” ");
INSERT INTO tbx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Xel lewexe bei, “Apraham on xa mami.” Yesu neil embei, “Wangwei Apraham neuyeiw xam, woyom tyek xam ghe bong lul wei Apraham mi wong o. ");
INSERT INTO tbx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","A tambiy tiwei a mi neil qayeeng zonghek wei a ngo wou Anutu yo, ekom xam a being nyeis a mey. Apraham se mi wong kwa nambei nyon. ");
INSERT INTO tbx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Xam ghe mi wong lulul wei xam venaxow mamim mi wong o.” Xel neil embei, “Xa tamiyeiw se wo kwapesiv me wou xa ti, qe Mang tixemou wei xa xe eno Anutu venaxow.” ");
INSERT INTO tbx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu neil wou xel, “Wangwei Anutu yon xam Mamim, on tyek xam laleimim devind ay, en a toundei is Anutu me na lam. A lam inye. A se lam angya a maxow kwang, qe moxo wong a lam. ");
INSERT INTO tbx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nambei nya a xe qayeeng se yeip yaing wou xam? En qes ambei nye xam seng teyei bei ngo vati wei a neil o. ");
INSERT INTO tbx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Xam mamim on Sandang, me xam ambei mi bong kwa wei xam mamim mi wong o. Myaxeeng eno moxo mi leis xel mey, se mi zeim qayeeng zonghek, en inyei qayeeng zonghek se toundei eivek e. De mi neil qayeeng tyonyeing en inyon emaxow tyonyeing qes, en moxo tyonyeingana me wo ma en tyonyeing. ");
INSERT INTO tbx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","En nambei a mi neil qayeeng zonghek, ekom xam seng mi wongis ay! ");
INSERT INTO tbx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Xel wei xam on valu yei bei a wong sewokeing? Wangwei a mi neil qayeeng zonghek, ond nambei nya xam seng wongis ay? ");
INSERT INTO tbx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tambiy tiwei Anutu xe eno mi ngo vati wei Anutu mi neil o. Xam on Anutu se xe en qes bei xam seng mi ngo vati wei e mi neil o.” ");
INSERT INTO tbx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yudayeiw lewexe wou moxo bei, “Xa neil neing en ingwei xa neimbei wa Samaria ti om memo ti nale eivek wang?” ");
INSERT INTO tbx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu neil embei, “Memo ti se toungale eivek ay ti, qe a mi sanghoxe mang lei de xam ghe mi beoux ay. ");
INSERT INTO tbx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","A se di ximexe lei ngandoung wei a maxow o. Qe inyei xelti di yimexe, de moxo inye tambiy wei mi ngo qayeeng o. ");
INSERT INTO tbx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Neing ayang a neil wou xam, wangwei xelti embei betiwou a xe qayeeng on tyek se teyei bei daxe meyeing.” ");
INSERT INTO tbx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","En tiyon eno xel Yudayeiw neil embei, “Gweimbeeng xa woulek bei memo dei eivek wang! Apraham mey me xel poropet is ambei nyon, de wang neimbei xelti embei betiwou wa xe qayeeng on tyek se teyei bei daxe meyeing. ");
INSERT INTO tbx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Wang ghanaw xe mend Apraham? Moxo mey, me xel poropet is. Wang wou naleim bei wang eti?” ");
INSERT INTO tbx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu neil elox bei, “Wangwei a sanghoxe a maxow leing ond a leing on bandaing. Mang tiwei xam ghe neimbei xam xe Anutu eno mi sanghoxe a leing. ");
INSERT INTO tbx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Xam seng woulek e, qe a woulek e. Wangwei a neimbei a se woulek e on a wo tyonyeing ambei xam, ekom a woulek e me na mi betiwou e xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Xam bumim Apraham wo xeilala en embei gyei a xe bouk, moxo yei woy de wo xeilala.” ");
INSERT INTO tbx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yudayeiw neil wou moxo bei, “Wa xe vakovek qes se ghei la 50, de wang wei Apraham!” ");
INSERT INTO tbx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu lewexe bei, “A neil wou xam zonghek, takwei wei Apraham se ghei umbek eno A Maxow A Mindei.” ");
INSERT INTO tbx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Woyom xel qou qakous en xel embei banex e, ekom Yesu xupek en xel me la myayaing veil tete wei xomek vambuing o. ");
INSERT INTO tbx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ka moxo di la, eno moxo yei moux ti matek gyeik umbek o. ");
INSERT INTO tbx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Moxo xe xel betiyeing teling e, “Putoung, eti wong sewokeing, moux tine venaxow o ma luw ta, om ingwei matek gyeik umbek o?” ");
INSERT INTO tbx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu neil embei, “Moux tine se wong sewokeing o ma luw ta se wo sewokeing, qe lul tine qandi bei Anutu xe xuk e gyeip yaing eivek e xe mapieing. ");
INSERT INTO tbx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kawei bendiyeing ne eno xey a bong xuk wou tambiy tiwei wong a lam o. De boukeing nam eno xelti tyek se bong xuk. ");
INSERT INTO tbx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Gyeik ingwei a toundei eivek tembuing sapa ne, eno a maxow xeiyaing wei tembuing sapa yo.” ");
INSERT INTO tbx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu neil ambei nyon, dom pesuv myalouk lek tembuing me wong e wo bandis de toung lek moux tiyon manghalus. ");
INSERT INTO tbx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Moxo neil wou e, “La, wang na zipek eivek lounyeing wei Siloam nei” (qayeeng tiyon qes ambei inye wong e la). Om moux tiyon la lipek, de loum beeng eno manghalus yeila. ");
INSERT INTO tbx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Moxo xe xel wei e beeng qes o me xel wei yei e takwei gyeik e mindei me tay lulul eno teling bei, “Beip inyei tambiy tiwei mindei me tay lulul o?” ");
INSERT INTO tbx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Xel valu neil embei e inyon. De xel valu neil embei, “Ma, inye xel nge ekom ma nambei e.” Ekom moxo venaxow neil xow teyei bei, “Inye ay yo.” ");
INSERT INTO tbx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Xel teling e, “Woyom nambei nya wa mamghalus yeila?” ");
INSERT INTO tbx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Moxo neil elox bei, “Tambiy tiwei xel mi neil Yesu eno wong tembuing wo bandis me toung lek a mang. Moxo neil wou ay bei a na zipek anghei Siloam. Om a la lipek, de woyom a mang yeila.” ");
INSERT INTO tbx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Xel teling e bei, “Moux tiyon inya?” Moxo neil embei, “A se woulek.” ");
INSERT INTO tbx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Xel qou moux tiwei matekeing eno me la wou xel Parisi. ");
INSERT INTO tbx_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Bouk tiwei Yesu wong tembuing wo bandis me vindek moux tiyon malek eno inyon Sabat. ");
INSERT INTO tbx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Om nambei nyon xel Parisi teling wou e no bei, “Nambei nya wa mam yeila?” Om moxo neil elox, “Moxo toung bandis lek a mang, me a lipek de gweimbeeng a mang yeila.” ");
INSERT INTO tbx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Xel Parisi valu neil embei, “Tambiy tine se lam wou Anutu, en se betiwou petieing wei Sabat o.” Ekom xel valu teling, “Nambei nya xel wei sewokeing o tyek bong dee wei lulvako yo nambei nye?” Om xel dembuma. ");
INSERT INTO tbx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Se denlek en xel pekwi mend wou moux matekeing on no, “Wambei neil ambei nya en e en ingwei wong wa mam yeila yo?” Moux tiyon neil elox bei, “Moxo poropet ti.” ");
INSERT INTO tbx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yudayeiw se ghei wongis bei moxo matek me mavindek lek, deka xel wo qayeeng la wou moux on ma luw ta wole. ");
INSERT INTO tbx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Luw lam de xel teling wou luw, “Inye muw neumim? Inye tambiy tine muw ghe neimbei e matek gyeik umbek o? Nambei nya gweimbeeng e manghalus yeila?” ");
INSERT INTO tbx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ma luw ta lewexe bei, “Uw a woulek bei inye uw neumi, me uw a woulek bei umbek matekeing. ");
INSERT INTO tbx_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ekom e yeila gweimbeeng ne nambei nya, o eti wong e ma yeila eno uw se woulek. Xam teling wou e. Moxo wo teiv om tyek na neil xow teyei.” ");
INSERT INTO tbx_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Moxo ma luw ta neil ambei nyon en luw yaleeng en Yudayeiw, en xel Yudayeiw tup qayeeng bei xelti embei neimbei Yesu e Kilisi, on tyek xel a tiy e veil xomek qekueing ama. ");
INSERT INTO tbx_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Inyon qes tiyon om ma luw ta neil embei, “Moxo wo teiv, om xam teling wou e.” ");
INSERT INTO tbx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Om luyuw eno xel taxe moux tiwei matekeing o me neil wou, “Wa sanghoxe Anutu, en xa woulek bei tambiy tiyon mi wong sewokeing.” ");
INSERT INTO tbx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Moxo neil elox bei, “Beip e mi wo sewokeing o ma, a se woulek. A woulek lulti bei a mang tek ekom gweimbeeng a mang yeila!” ");
INSERT INTO tbx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Woyom xel teling wou e, “Moxo wong ambei nya wou wang? E wong wa mam yeila nambei nya?” ");
INSERT INTO tbx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Moxo lewexe bei, “A neil wou xam woy ekom xam seng ngo. Nambei nya xam ambei ngo no? Xam a being bong ambei e xe betiyeing is?” ");
INSERT INTO tbx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Woyom xel wo vyend wou e me neil embei, “Wang on tambiy tiyon xe betiyeing! De xa ne betiyeing wei Mose yo! ");
INSERT INTO tbx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Xa woulek bei Anutu luk is Mose, ekom en tambiy tiyon, eno xa se woulek bei e lam anghei inya.” ");
INSERT INTO tbx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","De moux on lewexe bei, “Gweimbeeng xam ghe neil qayeeng on nelu ti! Xam seng woulek ingwei e lam anghei yo, qe moxo wong a mang yeila. ");
INSERT INTO tbx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Xey a woulek bei Anutu se mi ngo xel wei sewokeing o. Qe moxo mi ngo xel wei mi wo lalo wou e me betiwou e yo. ");
INSERT INTO tbx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Xelti se mi ngo ka bei, xelti wong tambiy wei umbek matekeing eno ma yeila. ");
INSERT INTO tbx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Wangwei Anutu se bong tambiy tiyon nam, on tyek se bong lulti.” ");
INSERT INTO tbx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Xel neil elox bei, “Sewokeing pup wang gyeik wang umbek o, wambei teyoxe xa!” De xel tiy moxo la. ");
INSERT INTO tbx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu ngo bei xel tiy e, de gyeik ingwei moxo yei e, eno neil wou bei, “Wang wongis Xomaxoneing Neu Moux?” ");
INSERT INTO tbx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Moux on teling bei, “Teiv, tambiy tiyon eti? Wa neil wou ay en a bongis e yo.” ");
INSERT INTO tbx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu neil embei, “Gweimbeeng wang wei e, inye tambiy tiwei di luk is wang ne.” ");
INSERT INTO tbx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Woyom moux on neil embei, “Tambiy Ngandoung, a wongis o,” de moxo wo lalo wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu neil embei, “A lam eivek tembuing tine en qayeeng wongeing, en kandek xel wei mend tekeing eno gyeina de eti yeiw wei mend yeila eno tyek bo mend tekeing.” ");
INSERT INTO tbx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Xel Parisi valu wei toundei is e eno ngo ingwei e neil ambei nyon om xel teling, “Vati? Wambei xa mami tek is?” ");
INSERT INTO tbx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu neil embei, “Wangwei xam mamim atek, on sewokeing ma veil xam, ekom xam ghe mi neimbei xam mamim yeila, om sewokeing nanghei di yeip wou xam.” ");
INSERT INTO tbx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu neil embei, “A neil wou xam zonghek, moux wei se la lox tete mya wei sipsip, qe lek wou tete nanghei ba nei me la lalei eno inyon panaxana me tambiy wei mi wo nol wou xel o. ");
INSERT INTO tbx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","De moux wei mi la lox tete mya eno inyon gyovaxa wei e xe sipsip o. ");
INSERT INTO tbx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","De tambiy tiwei mi yei tete mya teyei eno tax veil moxo, me sipsip mi ngo e vya. Moxo mi taxe e xe sipsip titi leind de mi dandiy xel me la myayaing. ");
INSERT INTO tbx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ka moxo qou e xe sipsip dalus me la myayaing, eno moxo mi la tax en xel, de e xe sipsip mi betiwou e en nambei xel woulek e vya. ");
INSERT INTO tbx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ekom xel se mi betiwou xel bange, xel mi pek en e en nambei xel se woulek xel bange vya.” ");
INSERT INTO tbx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu neil qayeeng pakeing tiyon wou xel, ekom xel se woulek vati wei moxo di neil wou xel o. ");
INSERT INTO tbx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Dekalekom Yesu neil no, “A neil wou xam zonghek, a tete mya wei sipsip o. ");
INSERT INTO tbx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Xel dalus wei lam a tax en ay eno panaxana me mi wo nol wou xel, ekom sipsip se mi ngo xel. ");
INSERT INTO tbx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","A tete mya, wangwei xelti embei nam wou ay me na eivek tete lalei on tyek Anutu devind e. Moxo tyek nam eivek lalei de doukna myayaing, me na qou lulul yaeing. ");
INSERT INTO tbx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Panaxana mi lam en panaxeing tixemou me leiseing xel a mey me mi wo nol wou, ekom a lam bei xel a qou mapieing, me mapieing e pup xel. ");
INSERT INTO tbx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“A maxow gyovaxa nimza wei sipsip o. Gyovaxa nimza wei sipsip eno mi saing e xe mapieing en sipsip. ");
INSERT INTO tbx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","De xukxe wei xel mi xouv e me e mi yeiteyei sipsip eno se gyovaxa wei wo ma en sipsip o, om gyeik ingwei yei naw bemeeng lam, eno saing sipsip de pek la. Woyom naw bemeeng nga sipsip de tiy xel vula. ");
INSERT INTO tbx_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","De moux tiyon pek me la en nambei xel mi xouv en malew om se wounalei ngenong en sipsip. ");
INSERT INTO tbx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“A maxow gyovaxa nimza wei sipsip o, a woulek a xe sipsip de a xe sipsip woulek ay, ");
INSERT INTO tbx_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","nambei kawei Mang woulek ay de a woulek Mang. Me a saing a xe mapieing en sipsip. ");
INSERT INTO tbx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","A xe sipsip valu wei xel se mi nale eivek tete ne. Om a na qou xel me na nam is ambei nyon. De tyek xel a ngo a vyang is ambei nyon, me tyek xel bo sipsip qendu tixemou me gyovaxa wei sipsip o tixemou. ");
INSERT INTO tbx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","En qes tine om Mang lalei vind ay bei a saing a xe mapieing de na qou enoum no. ");
INSERT INTO tbx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Xelti se zeim a xe mapieing veil ay, qe a maxow a zeim a xe mapieing veil. A ningkanzek teyei bei na zeim mapieing wei ay yo veil, de a ningkanzek teyei bei na qou enoum no. En Mang peti wou ay ambei nyon bei a bong.” ");
INSERT INTO tbx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Lek qayeeng ti beimambei ne eno wong Yudayeiw dembuma no. ");
INSERT INTO tbx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Xel ngenong neil embei, “Moxo memo nale eivek e me e wo bandol. Xam ambei ngo e enva?” ");
INSERT INTO tbx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ekom xel valu neil embei, “Inyei se qayeeng wei tambiy wei memo nale eivek o. Memo ti teyei lek bei bong xel wei matekeing o gyeina?” ");
INSERT INTO tbx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Woyom bouk ngandoung wei lalo eno lam tyip en ingwei xel mi wou naleind en xomek vambuing wei xel wong wou Anutu nanghei Yerusalem o. Inyon bouk wei nityuweing o, ");
INSERT INTO tbx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","de Yesu toundei eivek tete lalei wei xomek vambuing o me la di ghavineeng lek zek wei Salomo lei lek o. ");
INSERT INTO tbx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","De Yudayeiw lam nale vivekwou e, me neil embei, “Gyeik inya wa neil xow teyei? Wangwei bei inyon wa Kilisi, neilteyei wou xa.” ");
INSERT INTO tbx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu lewexe bei, “A neil wou xam woy, ekom xam seng wongis. De xuk wei a wong lek Mang lei eno neil a teyei, ");
INSERT INTO tbx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ekom xam seng wongis en nambei xam on a se xe sipsip. ");
INSERT INTO tbx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","A xe sipsip mi ngo a vyang, me a woulek xel, de xel mi betiwou ay. ");
INSERT INTO tbx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","A wong deing mapieing luta luta wou xel, me tyek xel se teyei bei mey, de xelti tyek se tetei xel veil a memang. ");
INSERT INTO tbx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Mang wei wong xel wou ay eno nikanzek ghanaw xel dalus, xelti tyek se tetei xel veil Mang mema. ");
INSERT INTO tbx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ay me Mang eno uw xouing tixemou.” ");
INSERT INTO tbx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Xel Yudayeiw lox me la balu qakous no en xel embei banex e, ");
INSERT INTO tbx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ekom Yesu neil wou xel, “A talex xuk nimza ngenong wei Mang o wou xam. En lul tina eno xam ambei banex ay en qakous?” ");
INSERT INTO tbx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Xel Yudayeiw neil elox bei, “Xa bei se banex wang en qakous en xuk nimza wei wang wong on, qe en ingwei wang lukyak lek Anutu, en nambei wa xomaxoneing bandaing, ekom wang neimbei wa Anutu.” ");
INSERT INTO tbx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu lewexe wou xel, “Inye xel se byex eivek xam xe petieing, ‘A neimbei xam on anutuyeiw?’ ");
INSERT INTO tbx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wangwei moxo na neimbei xel anutu yon inyon wou eti yeiw wei qou qayeeng wei Anutu yo om xoulek on tyek se pakei na ba nge. ");
INSERT INTO tbx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ekom nambei nya xam ghe neimbei a lukyak lek Anutu, en ingwei a neimbei ay Anutu Neu yo? Inye a tambiy tiwei Anutu beyal me wong e lam lek tembuing o. ");
INSERT INTO tbx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wangwei a se bong xuk wei Mang mi wong o ond xam seng bongis ay. ");
INSERT INTO tbx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ekom wangwei a bong e xe xuk, ek xam seng bongis ay, ond xam ghe bongis xuk wei ay yo me ghe boulek bei Mang toundei eivek a laleing, de a toundei eivek Mang lalei.” ");
INSERT INTO tbx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Xel di wong me yei en xel embei zeimaxoun e no, ekom moxo ghanaw xel me la. ");
INSERT INTO tbx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Woyom Yesu lox me la sek memiing Yorodan me la beyeeng wei Yoan lipek xel lek bouk myaxeeng o. Moxo toundei inyon ");
INSERT INTO tbx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","me xomaxoneing ngenong lam wou e. Xel neil embei, “Yoan se wong dee wei lulvako yo ti, qe lul dalus wei Yoan neil lek tambiy tine eno zonghek.” ");
INSERT INTO tbx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","De eivek beyeeng tiyon eno xel ngenongakes wongis Yesu. ");
INSERT INTO tbx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Ekom inyei tambiy ti lei Laserus eno vanei wong. Moxo nanghei Betani, beyeeng wei Maria luw li vex Marata yo. ");
INSERT INTO tbx_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria tiyon, takwei eno taw wel xeimangou lek Tambiy Ngandoung me vu e vaxa en luvelus, eno li moux Laserus vanei wong me e di yeip. ");
INSERT INTO tbx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Om li vex aluw wong qayeeng la wou Yesu bei, “Tambiy Ngandoung, moux tiwei wa laleim vind eno vanei wong.” ");
INSERT INTO tbx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Ka ingwei Yesu ngo inyon eno moxo neil embei, “Vanei yon se en ingwei xomaxoneing embei mey o. Ma, inyon embei talex Anutu xe nikanzek wou moux alis vex en xel bong e lei na, en kandek xel bong Anutu Neu Moux na qou lei ngandoung is.” ");
INSERT INTO tbx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu lalei vind Marata me li vex me Laserus. ");
INSERT INTO tbx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ekom gyeik ingwei moxo ngo bei Laserus vanei wong, eno toundei inyon teyei lek bouk yuw is no. ");
INSERT INTO tbx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Woyom moxo neil wou e xe xel betiyeing bei, “Xey ambei nox me na Yudia.” ");
INSERT INTO tbx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Xel neil embei, “Putoung se ghei denlek ingwei Yudayeiw embei banex wang en qakous o ti, ekom wa being nox me na inyei no?” ");
INSERT INTO tbx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu lewexe, “Beip inye se seivma xoumeeng yuw lek bendiyeing ti? Tambiy tiwei mi velewexe bendiyeing eno se mi beng en mi yei tembuing xe xeiyaing. ");
INSERT INTO tbx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ekom gyeik ingwei e velewexe eivek boukeing eno tyek na beng en xeiyaing ma veil e.” ");
INSERT INTO tbx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","E neil tine dekakom moxo neil wou xel, “Xe xe gweleeng Laserus yeip, ekom ambei na inyei en nana piyexe e.” ");
INSERT INTO tbx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","E xe xel betiyeing neil elox bei, “Tambiy Ngandoung, wangwei emdi gyeip on tyek bo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu neil en ingwei e xe meyeing o, ekom e xe xel betiyeing embeik nge Laserus di yeip. ");
INSERT INTO tbx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Om moxo neilteyei wou xel bei, “Laserus mey, ");
INSERT INTO tbx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","de en xam eno a wo xeinglala ngandoung en a se toundei inyei, om tyek xam ghe bongis. Ekom xey ambei na wou e.” ");
INSERT INTO tbx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Woyom Tomas (wei xel mi neil Didimas) eno neil wou xel betiyeing valu bei, “Wong xey dalus a la, en nana mey is e yo.” ");
INSERT INTO tbx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Gyeik Yesu la eivek Betani eno ngo bei Laserus mey woy me xel ev eivek leiveeng meyeing de bouk vey la veil. ");
INSERT INTO tbx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betani toundei paviy Yerusalem nambei kilomita yayal, ");
INSERT INTO tbx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","de xel Yudayeiw ngenong lam toundei is Marata luw Maria me byexaxoun luw en ingwei li moux mey o. ");
INSERT INTO tbx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marata ngo bei Yesu lam, eno la myayaing en embei na pelong e, dom Maria toundei eivek xomek. ");
INSERT INTO tbx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marata neil wou Yesu bei, “Tambiy Ngandoung, wangwei wa toumendei inye nei on tyek a ling se mey. ");
INSERT INTO tbx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ekom gweimbeeng a woulek bei Anutu tyek bong vati wei wambei teling wou e yo.” ");
INSERT INTO tbx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu neil wou vexo bei, “Wa lim moux tyek qandi lek no.” ");
INSERT INTO tbx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marata lewexe bei, “A woulek bei moxo tyek qandi lek no eivek bouk loxyus wei xel embei qandi lek o.” ");
INSERT INTO tbx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu neil wou vexo bei, “A maxow qandieing lek me mapieing qes. Xelti embei bongis ay eno tyek na toumendei mapieing gyeik e mey o, ");
INSERT INTO tbx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","de xel eti yeiw wei toundei mapieing me wongis ay eno tyek se teyei bei mey. Beip wang wongis tine?” ");
INSERT INTO tbx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Marata neil wou Yesu bei, “Ee, Tambiy Ngandoung, a wongis bei wa Kilisi, Anutu Neu Moux, tambiy tiwei embei nam lek tembuing o.” ");
INSERT INTO tbx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Deka Marata neil tine, eno lox me la taxe li Maria la nenyawes. De ngoung wou e, “Putoung lam toundei inye me di teling en wang.” ");
INSERT INTO tbx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria ngo tine, eno vexo qandi lek daing me la wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Yesu seng ghei la eivek beyeeng, qe nanghei toundei beyeeng wei Marata la pelong e yo. ");
INSERT INTO tbx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Xel Yudayeiw wei toundei is Maria eivek xomek me ghanduxoun e, eno yei ingwei vexo qandi lek daing me la myayaing om xel betiy e, xel embeik nge embei na bo talot anghei ingwei leiveeng meyeing nei. ");
INSERT INTO tbx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria la tyip beyeeng wei Yesu toundei yo me yei e, eno vexo ev vaxakatu eivek wou moxo vaxa me neil, “Tambiy Ngandoung, wangwei wa toumendei inye nei on tyek a ling moux se mey.” ");
INSERT INTO tbx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesu yei ingwei vexo eng, me Yudayeiw wei lam is e eno di eng is, om moxo lalei pyaxow me embei deeng. ");
INSERT INTO tbx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Moxo teling bei, “Xam ghe liw e nanghei inya?” Xel neil elox bei, “Tambiy Ngandoung, lam me wei.” ");
INSERT INTO tbx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu eng. ");
INSERT INTO tbx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Woyom Yudayeiw neil embei, “Xam wei ingwei moxo lalei mi vind e mouyo!” ");
INSERT INTO tbx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ekom xel valu neil embei, “Tambiy tine mi wong xel wei mentekeing eno mi yeila, ekom nambei nya se teyei bei devind tambiy tine veil meyeing?” ");
INSERT INTO tbx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu lalei pyaxow no me la ingwei leiveeng meyeing nei. Inyei eeng wei xel kwelexe eivek qakous me lax mya zeyi yo. ");
INSERT INTO tbx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Moxo neil embei, “Xam wo qakous veil.” Marata wei li moux mey eno neil embei, “Ekom Tambiy Ngandoung, tyek bo niliy, en yeip inyon bouk vey la veil o.” ");
INSERT INTO tbx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Woyom Yesu neil embei, “Beip a se neil wou wang bei wangwei wang bongis, on tyek wang gwei Anutu xe nikanzek ngandoung?” ");
INSERT INTO tbx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Om xel qepei qakous veil. Woyom Yesu veilma lek me neil embei, “Mang, a wong dange wou wang en wang mi ngo ay. ");
INSERT INTO tbx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","A woulek bei taxombouk eno wang mi ngo ay, ekom a neil inye en nimza wei xomaxoneing wei toungale inye, bei xel bongis bei wang wong a lam.” ");
INSERT INTO tbx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ka Yesu neil tine woy, eno taxe xoulekeing bei, “Laserus, lam myayaing!” ");
INSERT INTO tbx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Moux wei mey eno lam myayaing, xel beliv e mema luw me vaxa luw en qaeing de beliv qaeing vivekwou e ma. Yesu neil wou xel “Xam tul qaeing wei leiveeng meyeing eno veil de wong e la.” ");
INSERT INTO tbx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nambei nyon om Yudayeiw ngenong wei lam toundei is Maria, eno yei vati wei Yesu wong, om xel wongis e. ");
INSERT INTO tbx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Ekom xel wei xel eno valu la neil wou xel Parisi en vati wei Yesu wong o. ");
INSERT INTO tbx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Woyom xel lumuki leitata yo is Parisiyeiw taxe qekueing ama wei kanzol o. Xel teling bei, “Tyek xey a bong ambei nya? Tambiy tine wong dee wei lulvako yo ngenong. ");
INSERT INTO tbx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wangwei xey a bong emdi bong ambei nyon, on tyek xel dalus bongis e. De woyom tyek xel Rom nam lelolexe xe xe xomek vambuing de na qou xomaxoneing wei tembuing ne is.” ");
INSERT INTO tbx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Woyom xel wei xel on ti, e lei Kaiapas, moxo wo lumuki lukanzek lek vakovek qes tiyon, eno luk wou xel bei, “Xam lumimpeyei se woulek lulti! ");
INSERT INTO tbx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Xam seng woulek bei inye nimza wou xam en ingwei tambiy ti e mey en xomaxoneing dalus enok xel dalus wei tembuing tine eno na mey.” ");
INSERT INTO tbx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Moxo se neil inyon nangya kwa, qe wo lumuki lukanzek lek vakovek qes tiyon om neil qayeeng poropet lek ingwei Yesu tyek na mey en xel wei Yudayeiw o, ");
INSERT INTO tbx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","De se en Yudayeiw venaxow qe en Anutu neuyeiw wei toundei lala yo en embei qeku xel dalus lekti me xel bo tixemou. ");
INSERT INTO tbx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Om gyeik bouk kayon me e di la eno xel di luklek sakwaing wei xel embei nyeis Yesu e mey yo. ");
INSERT INTO tbx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Nambei nyon om Yesu se lox me la ghavineeng yanyateiv eivek xel Yudayeiw senghoing. Moxo la veil inyon me la beyeeng wei di yeip paviy tembuing bandaing o, la beyeeng wei xel mi neil Epraim nei, me moxo is e xe xel betiyeing la mindei inyon. ");
INSERT INTO tbx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Bouk la paviy Yudayeiw xe Pasova, om xel ngenong wei tembuing danghei danghei nei lek me la Yerusalem en embei na bo xow bo vako natax en Pasova. ");
INSERT INTO tbx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Xel di yimexe Yesu, deka xel toukale eivek tete lalei wei xomek vambuing eno xel di teling wouma, “Xam ghe wou naleimim neing bei moxo tyek nam gyei bouk dalus wei Pasova ne?” ");
INSERT INTO tbx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ekom xel lumuki leitata me Parisiyeiw neil wou moux alis vex bei wangwei xelti boulek ingwei Yesu toundei yo, ond e neil wou xel en xel na zeimaxoun e. ");
INSERT INTO tbx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Bouk limti nanghei di yeip zeyi Pasova, om Yesu la toundei Betani wei Laserus mindei lek o, inyon tambiy tiwei Yesu piyexe e qandi lek veil meyeing o. ");
INSERT INTO tbx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Xel wo xeindlala en Yesu me wo mata ti wou e. Marata di duw yaeing, de Laserus toundei senghoing is xel wei di ya lek lelek is e yo. ");
INSERT INTO tbx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Woyom Maria qou wel xeimangou wei malew ngandoung en o veweeng me taw lek Yesu vaxa de vu e vaxa nangya venaxow luvelus. Me xomek pup en wel on xeimangou. ");
INSERT INTO tbx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ekom e xe betiyeing ti, Yudas Iskariot, wei tyek na neil e teyei me na toung e na eivek xel ba memend loxyus o, eno neil embei, ");
INSERT INTO tbx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Nambei nya wel xeimangou ne xey se wo vateivek lek me na qou malew selewa vaxak yal lek en na bo wou xel kanyo?” ");
INSERT INTO tbx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tambiy on se neil inyon en embei devind xel kanyo, qe nambei moxon panaxana, moxo mi yeiteyei qoupek malew wei xel o, om mi panax malew wei xel mi toung eivek o. ");
INSERT INTO tbx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu neil elox bei, “Wong vex on venaxow toundei, inye wo bombek bei zeimaxoun wel xeimangou yon bei menyex wou a neing en bouk wei eveing o. ");
INSERT INTO tbx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Xel kanyo tyek na mi mendei eivek xam senghoing taxombouk, ekom tyek a se mendei is xam taxombouk.” ");
INSERT INTO tbx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Dekalekom xel qendu ngandoung wei Yudayeiw eno ngo bei Yesu toundei Betani om xel la, se en e maxow qe xel embei na gyei Laserus tambiy tiwei Yesu piyexe e veil meyeing o. ");
INSERT INTO tbx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Om xel lumuki leitata di luklek inye en xel embei nyeis Laserus a mey is, ");
INSERT INTO tbx_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","en nambei xel wounaleind en ingwei Yesu wong wou Laserus, om xel ngenong wei Yudayeiw eno di la wou Yesu me wongis e. ");
INSERT INTO tbx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Bouk nge eno xel qendu ngandoung wei lam en Pasova eno ngo bei Yesu di lam Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Xel qou zangholeng mema me la myayaing en xel embei na pelong e, xel di taxe bei, “Hosana!” “Mata ena wou tambiy tiwei lam lek Tambiy Ngandoung lei yo!” “Mata ena wou king wei Israel xe yo!” ");
INSERT INTO tbx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu yei dongi lingheing ti me dei lek, nambei xel byex eivek xoulek o, ");
INSERT INTO tbx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Sayon neu vex wa seng gwaleeng, wei, wa xe king di lam, Moxo dei lek dongi lingheing ti.” ");
INSERT INTO tbx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Myaxeeng eno e xe xel betiyeing se woulek lulti beimambei ne dalus qes. Qe ka Anutu wo lei ngandoung wou Yesu, om xel woulek xoulek wei yeip eivek qapiya yo, me xel wou naleind en lulti beimambei wei xel wong woy wou e yo. ");
INSERT INTO tbx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nanghei inyei eno xel qendu ngandoung wei toundei is e gyeik ingwei moxo taxe Laserus nanghei leiveeng meyeing me e qandi lek me lam veil meyeing eno xel di tetulexe qayeeng on lala. ");
INSERT INTO tbx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","En qes tine is ambei nyon xomaxoneing ngenong la pelong e en xel ngo ingwei e wong dee wei lulvako yo. ");
INSERT INTO tbx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Om xel Parisiyeiw di neil wouma bei, “Wei, xey se teyei bei bo lulti. Xam ghe wei kwa yon, xel dalusateiv wei tembuing sapa eno la betiwou e.” ");
INSERT INTO tbx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Xel Grik valu lam toundei senghoing eivek moux alis vex wei lam tyip en embei nam bo lalo lek bouk ngandoung tine yo. ");
INSERT INTO tbx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Xel lam wou Pilip, tambiy wei nanghei Betsaida eivek Galili yo. Xel neil embei, “Teiv, xa bei ghei Yesu.” ");
INSERT INTO tbx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilip la neil wou Andrias, de Andrias aluw Pilip la neil wou Yesu. ");
INSERT INTO tbx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu neil elox wou luw, “Bouk la wou eivek en ingwei Xomaxoneing Neu Moux embei bo lei ngandoung o. ");
INSERT INTO tbx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","A neil wou xam zonghek, Wangwei wit vei se detei lek tembuing me na mey, on tyek na toumendei nambei vei tixemou. Ekom wangwei e mey, on tyek bo vei ngenong. ");
INSERT INTO tbx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tambiy ti embei lalei devind mapieing wei e yo on tyek na saing e xe mapieing, ek wangwei tambiy ti embei toung demi wou e xe mapieing lek tembuing tine on tyek na zeimaxoun e xe mapieing luta luta. ");
INSERT INTO tbx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Xelti embei bong a xe xuk ond e mi betiwou ay, me beyeeng wei ambei mendei eno a xe xukxe tyek mendei is ay. De Mang tyek bo lei ngandoung wou tambiy tiwei embei bong a xe xuk o. ");
INSERT INTO tbx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Gweimbeeng a laleing wo maying, me tyek a neil ambei nya? ‘Mang, wa devind a lek seivma tine’? Ma, a se neil ambei nye. En lek qes tiyon om a lam lek seivma tine. ");
INSERT INTO tbx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Mang, wang bo leim bo ngandoung!” Woyom vya ti lam anghei tyoung gheyapu nei bei, “A wong e wo ngandoung woy, me tyek a bong embo ngandoung no.” ");
INSERT INTO tbx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Om xel qendu ngandoung wei toukale inyon ngo vya ti me neil embei dewek toung, de valu neil embei angela ti luk is e. ");
INSERT INTO tbx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu neil embei, “Vya tine embei devind xam, de se ay. ");
INSERT INTO tbx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gweimbeeng inye bouk wei Anutu embei bong qayeeng en tembuing tine, de tyek na tiy gyovaxa tiwei mi yeiteyei tembuing tine yo na. ");
INSERT INTO tbx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ekom Ay, eno wangwei xel a zeim a zekna veil tembuing, on tyek a puw moux alis vex dalus noum wou xow.” ");
INSERT INTO tbx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Moxo neil tiyon en embei talex ingwei tyek na mey ambei nya yo. ");
INSERT INTO tbx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Xel qendu ngandoung on neil embei, “Xa ngo eivek petieing bei Kilisi tyek na mi mendei luta luta, om nambei nya wang neimbei, ‘Xomaxoneing Neu Moux tyek xel a zeim e zekna’? Inyon ‘Xomaxoneing eti Neu Moux’?” ");
INSERT INTO tbx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Woyom Yesu neil wou xel bei, “Tyek xeiyaing a toumendei is xam bouk sepika. Om xam a mi na eivek xeiyaing, enok mapetok nam sevun xam. Tambiy wei mi la eivek mapetok eno se mi woulek ingwei embei na yo. ");
INSERT INTO tbx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Xam a mi bongis xeiyaing wei xam ghe qou yo. En kandek xam ghe bo xeiyaing neuyeiw.” Yesu luk woy, eno moxo la veil xel de la xupek en xel. ");
INSERT INTO tbx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesu wong dee wei lulvako beimambei yon wou xel mend woy, ekom xel se wongis e. ");
INSERT INTO tbx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Tiyon wo neing lek nambei qayeeng wei poropet Yesaya yo: “Tambiy ngandoung, eti wongis xa xe qayeeng me Tambiy Ngandoung mema talex lulul tine lam yanyateiv wou eti?” ");
INSERT INTO tbx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","En qes tiyon om moux alis vex se teyei bei bongis, en nambei Yesaya byex eivek qayeeng nge bei: ");
INSERT INTO tbx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Moxo wong xel mend tek Me wong xel laleind wo nikanzek, enok xel mend gyeina, o xel boulek eivek laleind, o xel pekwi me noum me a bong xel bo nimzalek.” ");
INSERT INTO tbx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesaya neil tine en nambei moxo yei Yesu xe xeiyaing ngandoung om neil inyon en e. ");
INSERT INTO tbx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Neing, xel gyovaxa ngenong wei Yudayeiw o wongis Yesu. Ekom nambei xel Parisi om xel se neil xel xe wongeingis teyei en xel yaleeng enok xel a tiy xel veil xomek qekueing ama. ");
INSERT INTO tbx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","En xel laleind mi vind ingwei moux alis vex mi sanghoxe xel ghanaw ingwei Anutu mi sanghoxe yo. ");
INSERT INTO tbx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Woyom Yesu taxe bei, “Wangwei xelti embei bongis ay, ond moxo se wongis a maxow, qe wongis tambiy tiwei wong a lam o. ");
INSERT INTO tbx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","De moxo embei gyei ay, ond moxo yei tambiy tiwei wong a lam o. ");
INSERT INTO tbx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","A lam tembuing ne nambei xeiyaing, en kandek xel wei wongis ay eno tyek se mendei eivek mapetok. ");
INSERT INTO tbx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“En nambei xelti embei ngo a xe qayeeng ekom se betiwou, ond tyek a se bong qayeeng en e. En a se lam en ambei bong qayeeng en moux alis vex wei tembuing o, qe ambei devind xel veil nilul. ");
INSERT INTO tbx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Inyei tambiy wei mi ngo qayeeng o ti toundei en embei bong qayeeng en tiwei se ngo ay me se qou a xe qayeeng o, qayeeng wei a mi neil eno tyek bo qayeeng en e lek bouk loxyus. ");
INSERT INTO tbx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","En a se mi neil inyon nangya kwang, qe Mang tiwei wong a lam eno peti wou ay en vati wei ambei neil me kwa wei ambei neil o. ");
INSERT INTO tbx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","A woulek bei e xe petieing on mapieing luta luta. Om vati wei a mi neil eno mi la nambei ingwei Mang neil wou ay bei a neil o.” ");
INSERT INTO tbx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Inye bouk paviy mata wei Pasova yo. Yesu woulek bei bouk lam en ingwei embei na veil tembuing me na wou Ma yo. Moxo lalei vind emaxow xe xel wei toundei lek tembuing o, me e lam gweimbeeng ne eno moxo lalei vind xel ghanaw veil. ");
INSERT INTO tbx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","De soukeing wei xel di ya eno Sandang toung kwa eivek Yudas Iskariot, Simon neu woy, bei e toung Yesu na eivek xel ba memend. ");
INSERT INTO tbx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu woulek bei ma toung lulul dalus la eivek e xe nikanzek xeinghembi, me ingwei Anutu wong e lam me ingwei tyek nox me na wou Anutu yo, ");
INSERT INTO tbx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","om moxo qandi lek veil yaeing, me kwax e xe teimb ding veil, de vex vetivek ti vivekwou xeikatu. ");
INSERT INTO tbx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kalekom moxo taw memiing lek dipekta ti de mouk sekweyexe e xe xel betiyeing vaxend, me vu xel vaxend nangya vetivek wei vex evivekwou xeikatu yo. ");
INSERT INTO tbx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Moxo lam wou Simon Petele, e tiwei neil wou bei, “Tambiy Ngandoung, inye wa being zipek a vaxang?” ");
INSERT INTO tbx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu neil elox bei, “Wa seng woulek vati wei a wong gweimbeeng ne, qe kalekom tyek wang boulek loxyus.” ");
INSERT INTO tbx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petele neil embei, “Ma, wa seng teyei bei sekweyexe a vaxang se teyei.” Yesu lewexe bei, “Wangwei a se sekweyexe wang, on a se xe wang.” ");
INSERT INTO tbx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Woyom Simon Petele neil elox bei, “Tambiy Ngandoung, wangwei nambei nyon nei on wa se sekweyexe a vaxang venaxow qe a memang me a lung is ambei nyon!” ");
INSERT INTO tbx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu neil embei, “Tambiy wei lipek woy eno tyek zipek vaxa venaxow dom neing dalus wo vako. De xam ghe wo vako, ekom se xam on dalus.” ");
INSERT INTO tbx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","En Yesu woulek tambiy tiwei embei toung e na eivek xel ba memend o, omek ingwei neil embei xam dalus seng wo vako. ");
INSERT INTO tbx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ka moxo lipek xel vaxend ma, eno moxo byex e xe teimb ding lek de lox me la dei lek nimbeeng. Moxo teling wou xel, “Xam ghe woulek vati wei a wong wou xam ne? ");
INSERT INTO tbx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Xam ghe mi taxe a ‘Putoung’ me ‘Tambiy Ngandoung,’ om inyon nimza, en inyei ay ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","A ne xam xe Tambiy Ngandoung me Putoung, de a lipek xam vaxamim, om xam is ambei nyon xam a mi zipek ama vaxamim. ");
INSERT INTO tbx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","A talex kwa ne wou xam bei xam a mi bong ambei ingwei a wong wou xam ne. ");
INSERT INTO tbx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","A neil wou xam zonghek, xukxe ti se ghanaw e xe teiv, o nenyalesana se ghanaw tambiy wei wong e la yo. ");
INSERT INTO tbx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Gweimbeeng xam ghe woulek lulti beimambei ne, om wangwei xam ghe bong lulti yon dalus on tyek xam a qou mata. ");
INSERT INTO tbx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“A se neil xam dalus. A woulek xam wei a beyal o. Ekom tine embo neing lek ambei ingwei di yeip eivek xoulek o. ‘Tambiy tiwei ya belet is ay eno tyek bo vaxaghelu zekna me bakei ay.’ ");
INSERT INTO tbx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“A neil inye natax wou xam gweimbeeng dom inye se ghei qandi, en kandek gyeik ingwei embei qandi on xam ghe bongis bei A maxow Tambiy Tiyon. ");
INSERT INTO tbx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","A neil wou xam zonghek, xelti embei qou eti yeiw wei a wong e lak on qou ay, me xelti embei qou ay on qou tambiy tiwei wong a lam o.” ");
INSERT INTO tbx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Ka ingwei moxo neil tine, eno Yesu lalei wo maying, me neil embei, “A neil wou xam zonghek, xam venaxow ti tyek na neil a teyei me na toung a na eivek xel ba memend.” ");
INSERT INTO tbx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Moxo xe xel betiyeing di yei ma kanzek en nambei xel se woulek bei neil eti. ");
INSERT INTO tbx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","De Yesu xe betiyeing tiwei lalei mi vind e eno di yeip pepeeng lek zek paviy e. ");
INSERT INTO tbx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Petele bimexe lu me neil wou betiyeing tiyon bei, “Teling wou e bei moxo neil eti.” ");
INSERT INTO tbx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Om betiyeing tiyon li lu la paviy Yesu bambou de teling bei, “Tambiy Ngandoung, inyon eti?” ");
INSERT INTO tbx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu lewexe bei, “Tambiy tiwei ambei toung belet danghei ti eivek louk me na bong wou eno tiyon inyon.” Woyom toung belet danghei ti eivek louk me wong wou Yudas Iskariot Simon neu. ");
INSERT INTO tbx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ka Yudas ya woy, Sandang la eivek e. De Yesu neil wou e, “Lul vati wei wa being bong, eno wang bong daing.” ");
INSERT INTO tbx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ekom xel wei toundei me ya eno ti se woulek bei nambei nya Yesu neil tiyon wou e. ");
INSERT INTO tbx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","En nambei Yudas mi yeiteyei qoupek wei malew o, om xel betiyeing valu embeik nge Yesu neil wou e bei e na bou lulul en mata wei bouk ngandoung, o bong lulul wou xel kanyo. ");
INSERT INTO tbx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Lutika eno Yudas ya belet wei Yesu wong wou e yo, de moxo la myayaing. De inye bouk. ");
INSERT INTO tbx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudas la veil woy, eno Yesu neil embei, “Gweimbeeng Xomaxoneing Neu Moux tyek bo lei ngandoung me Anutu tyek na qou lei ngandoung en Neu. ");
INSERT INTO tbx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Wangwei Anutu na qou lei ngandoung en e, ond Anutu tyek bong lei ngandoung wou emaxow Neu Moux, me tyek bo lei ngandoung wou moxo lutika. ");
INSERT INTO tbx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“A neungyeiw, tyek a toumendei is xam enden nayaka. De tyek xam ghe gwimexe ay, nambei ingwei a neil wou xel Yudayeiw o, om a neil wou xam gweimbeeng: Ingwei ambei na nei eno tyek xam seng nam. ");
INSERT INTO tbx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Ambei bong petieing vako wou xam: Xam laleimim e mi devind xel nge. Nambei ingwei a laleing vind xam o, om xam laleimim emi devind xel nge. ");
INSERT INTO tbx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nangya tine eno wangwei xam laleimim devind xel nge ond tyek xomaxoneing dalus boulek bei xam on a xe betiyeing.” ");
INSERT INTO tbx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petele teling wou bei, “Tambiy Ngandoung, wa being na nya?” Yesu neil elox bei, “Ingwei ambei na nei eno tyek wa se betiwou gweimbeeng, qe tyek wa betiwou loxyus.” ");
INSERT INTO tbx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petele teling, “Tambiy Ngandoung, nambei nya tyek a se betiwou wang gweimbeeng? Tyek a saing a xe mapieing en wang.” ");
INSERT INTO tbx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Woyom Yesu lewexe bei, “Neing, tyek wang teyei bei saing wa xe mapieing en ay? A neil wou wang zonghek, gyeik qouklex se ghei sesa vya, eno tyek wang dax a vun luyal!” ");
INSERT INTO tbx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu neil embei, “Xam laleimim se bo maying. Xam ghe bongis Anutu, me xam ghe bongis ay is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Eivek Mang xe xomek nei eno lalei ngenong, wangwei se nambei nyon nei, on tyek a se neil wou xam. Om ambei na inyei me na menyex beyeeng wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Me wangwei a na menyex wou xam bamim nei, on tyek a noum a qou xam me nana is xow, me beyeeng wei ambei mendei eno tyek xam ghe na mendei is ay. ");
INSERT INTO tbx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Xam ghe woulek sakwaing wei la beyeeng tiwei ambei na yo.” ");
INSERT INTO tbx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas neil wou e, “Tambiy Ngandoung, xa se woulek ingwei wa being na yo, om nambei nya tyek xa boulek sakwaing?” ");
INSERT INTO tbx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu neil embei, “A maxow sakwaing me zonghek me mapieing qes. Xelti tyek se nam wou Mang eivek sakwaing nge qe a maxow. ");
INSERT INTO tbx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wangwei xam ghe boulek a boy nei, on tyek xam ghe boulek Mang is. Gweimbeeng ne me e mi na eno xam ghe woulek moxo me ghe wei e.” ");
INSERT INTO tbx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilip neil embei, “Tambiy Ngandoung, talex Mam wou xa, en e teyei lek xa laleimi yo.” ");
INSERT INTO tbx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu neil embei: “Pilip, inye wa seng ghei woulek ay? De a mindei eivek xam senghoing me enden eno? Xelti embei gyei ay eno yei Mang. Nambei nya wang neimbei, ‘Talex Mang wou xa’? ");
INSERT INTO tbx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Beip wa seng wongis bei a toundei eivek Mang, de Mang toundei eivek ay? Qayeeng wei a neil wou xam eno inye se a maxow. Qe inye Mang toundei eivek Ay, me di wong e xe xuk. ");
INSERT INTO tbx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Xam ghe bongis ay gyeik ingwei a neimbei a toundei eivek Mang de Mang toundei eivek ay, o xam ghe bongis xuk dalus wei a mi wong o. ");
INSERT INTO tbx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","A neil wou xam zonghek, xelti embei bongis ay on tyek bong vati wei a di wong ne, moxo tyek bong lul ngandoung beimambei ne ghanaw ingwei a wong ne, en nambei ambei na wou Mang. ");
INSERT INTO tbx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","De tyek a bong vatiyeiw wei xam ghe teling en eivek a leing o, en kandek Neu Moux bo lei ngandoung wou Ma. ");
INSERT INTO tbx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Xam a mi teling wou ay en lul vatiyeiw eivek a leing, de tyek a bong. ");
INSERT INTO tbx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Wangwei xam laleimim devind ay, on tyek xam betiwou petieing wei a neil wou xam o. ");
INSERT INTO tbx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","De tyek a teling wou Mang, me e bong Vineing nge wou xam en e mi mendei is xam takwei takwei. ");
INSERT INTO tbx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Vineing tiyon Laweeng wei zonghek o. Moux alis vex wei tembuing ne se qou e, en nambei xel se yei moxo, o xel se woulek e. Ekom xam ghe woulek e, en nambei moxo toundei is xam me tyek na toumendei eivek xam. ");
INSERT INTO tbx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tyek a se saing xam nambei yak pemboung. Tyek a mi nam wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Bouk sepika moux alis vex wei tembuing ne tyek se gyei a no, qe tyek xam ghe gwei ay. En nambei a toundei mapieing, de xam is ambei nyon tyek xam a toumendei mapieing. ");
INSERT INTO tbx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lek bouk tiyon eno tyek xam ghe boulek bei a toundei eivek Mang de xam ghe toundei eivek ay, de a toundei eivek xam. ");
INSERT INTO tbx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Xelti embei qou a xe petieing me betiwou, ond tiyon lalei vind ay. Xelti embei lalei devind ay ond tyek Mang lalei devind e, me ay is ambei nyon tyek a laleing devind e me talex xow wou e.” ");
INSERT INTO tbx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Woyom Yudas (se Yudas Iskariot) neil embei, “Ekom Tambiy Ngandoung, nambei nya wambei talex xow wou xa maxow de se wou moux alis vex wei tembuing sapa yo?” ");
INSERT INTO tbx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu neil elox bei, “Wangwei xelti lalei devind ay, ond tyek betiwou a xe teyoxeing. De Mang tyek lalei devind e, me tyek uw a nam wou moxo me na nam a mi mendei is e. ");
INSERT INTO tbx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tambiy ti lalei se mi vind ay eno tyek se betiwou a xe teyoxeing. Qayeeng beimambei wei xam ghe ngo ne eno inyon se a maxow xe, qe xel xouing on Mang tiwei wong a lam eno xe. ");
INSERT INTO tbx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“A neil wou xam en lulul tine dalus gyeik a toundei is xam o. ");
INSERT INTO tbx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ekom Vineing, Laweeng Vambuing, wei Mang tyek bong e nam eivek a leing, eno tyek teyoxe xam en lul dalus me beil xam lumim lek en lulul sapa wei a neil wou xam woy yo. ");
INSERT INTO tbx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Lalei vevopeing a wong e toundei is xam, a xe lalei vevopeing a wong wou xam. A se wong wou xam nambei xel wei tembuing sapa ne mi wong o. Om xam laleimim se bo maying me xam seng gwaleeng. ");
INSERT INTO tbx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Xam ghe ngo ingwei a neil o woy, ‘Ambei na de na noumenam wou xam.’ Wangwei xam laleimim devind ay, ond tyek xam ghe bo xeilala en ingwei ambei na wou Mang o, en Mang lei ngandoung eno ngandoung ghanaw ay. ");
INSERT INTO tbx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","A neil tiyon wou xam atax de se ghei qandi, en kandek gyeik ingwei embei qandi, on tyek xam ghe bongis. ");
INSERT INTO tbx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Tyek a se puw qayeeng is xam, en gyovaxa wei mi yeiteyei tembuing ne eno lam. Moxo nikanzek se teyei bei bo lulti wou ay, ");
INSERT INTO tbx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ekom ambei xomaxoneing wei tembuing sapa eno boulek bei a laleing vind Mang me na mi wong nambei kawei Mang peti bei a bong o. “Xam qandi lek, en xey a na yo.” ");
INSERT INTO tbx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu neil embei, “A maxow yis wain zonghek de Mang on xuk wain ma. ");
INSERT INTO tbx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Moxo pyaw mema dalus wei byexlek ay eno veil en xel se vuk neing lek, de mema mema wei mi vuk eno Mang qateiv veil en kandek embuk neing ngenong lek. ");
INSERT INTO tbx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Xam ghe wo vako woy en qayeeng wei a mi neil wou xam o. ");
INSERT INTO tbx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Xam a mi mendei eivek ay, de tyek a mi mendei eivek xam. Mema ti tyek se buk neing lek nangya emaxow, qe e mendei eivek wain bole. Xam is tyek xam seng buk neing lek qe ka xam mendei eivek a bole. ");
INSERT INTO tbx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“A maxow wain qes, de xam mema mema. Wangwei tambiy ti embei mendei eivek ay me a mendei eivek e, ond tyek buk neing ngenong, ek wambei mendei beyaleing veil ay on tyek wa seng bo lulti. ");
INSERT INTO tbx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Xelti embei se mendei eivek ay, ond inyon nambei mema wei xel nex ela me e mupek o, om mema nambei nyon tyek xel qekuwou me banex ena me besei lek nenyex. ");
INSERT INTO tbx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wangwei xam mendei eivek ay me a xe qayeeng mendei eivek xam, ond xam teling vatiyeiw en woueing nalei wei xam o, on tyek bong wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Xam ghe buk neing ngenong lek en e talex bei xam on a xe betiyeing, de inyon embong lei ngandoung wou Mang. ");
INSERT INTO tbx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Nambei ingwei Mang lalei vind ay, om a laleing vind xam. Gweimbeeng xam a mi mendei eivek a xe lalei vineing. ");
INSERT INTO tbx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Wangwei xam betiwou a xe petieing ond tyek xam mendei eivek a xe lalei vineing, nambei ingwei a betiwou Mang xe petieing me na toundei eivek e xe lalei vineing o. ");
INSERT INTO tbx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","A neil wou xam en tine en kandek a xe xeilala e mi mendei eivek xam de xeilala tiyon e pup xam laleimim lek. ");
INSERT INTO tbx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","A xe petieing eno nambei nye: Xam titi laleimim e mi devind xel nge nambei ingwei a laleing vind xam o. ");
INSERT INTO tbx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Lalei vineing ngandoung wei xelti eno nambei nye, tambiy ti e saing e xe mapieing en e xe gweleeng. ");
INSERT INTO tbx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Xam on a xe gweleeng wangwei xam betiwou petieing wei a neil wou xam o. ");
INSERT INTO tbx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tyek a se nox me na taxe xukxe lek xam no, en nambei xukxe se woulek vati wei e xe teiv mi wong o, qe a taxe gweleeng lek xam, en lulul dalus wei a ngo wou Mang eno a neilteyei wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Xam seng beyal ay, qe a beyal xam bei xam ghe na me ghe buk neing lek, neing on tyek na mi mendei enden. Woyom Mang tyek bong vati wei xam ambei teling en eivek a leing eno wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Inye a xe petieing: Xam titi laleimim e mi devind ama. ");
INSERT INTO tbx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Wangwei moux alis vex wei tembuing ne bo lalei vanei wou xam ond xam ghe bou naleimim bei xel wong lalei vanei wou ay a tax. ");
INSERT INTO tbx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wangwei xam on ingwei tembuing ne yo, on tyek xel laleind devind xam nambei xel venaxow. Ekom xam se ingwei tembuing ne, en a beyal xam veil tembuing. En qes tiyon om moux alis vex wei tembuing ne di wo lalei vanei wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Xam ghe bou naleimim en qayeeng wei a neil wou xam o: ‘Xukxe ti se ghanaw e xe teiv.’ Wangwei xel bo nol wou ay, ond tyek xel bo nol wou xam is. Wangwei xel betiwou a xe teyoxeing ond tyek xel betiwou xam xe is. ");
INSERT INTO tbx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Xel tyek bo nol wou xam en sakwaing ambei nyon en nambei a leing, en xel se woulek tambiy tiwei wong a lam o. ");
INSERT INTO tbx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Wangwei a se nam me baluk wou xel nei ond sewokeing ma veil xel. Ekom gweimbeeng ne xel se teyei bei dax sewokeing wei xel eno vun. ");
INSERT INTO tbx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Xelti embei bo lalei vanei wou ay ond wo lalei vanei wou Mang is. ");
INSERT INTO tbx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wangwei a se nam mendei eivek xel senghoing me na bong pok ngandoung wei xel nge se mi wong o ond tyek sewokeing ama veil xel. De xel yei lulvako beimambei ne woy, ekom xel laleind se vind ay me Mang is. ");
INSERT INTO tbx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ekom inye embei na teyei lek vati wei xel byex eivek petieing o: ‘Xel wo lalei vanei wou ay eno qes maeing.’ ");
INSERT INTO tbx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Gyeik tiwei embei devind en ghanduxoun xam eno nam ond tyek ambong e nak wou xam, inyei lam wou Mang, inyon Laweeng wei zonghek o wei mindei is Mang me lam eno tyek moxo na neil qayeeng en ay. ");
INSERT INTO tbx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Me xam a neil qayeeng en ay is ambei nyon, en nambei xam ghe mindei is ay eivek myaxeeng selis. ");
INSERT INTO tbx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“A neil inye wou xam woy en ambei xam se toung demimim wou ay. ");
INSERT INTO tbx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tyek xel a tiy xam veil xomek qekueing ama, deka bouk wei yo nam on tyek xel nyeis xam amey, de tyek xel bounaleind bei xel sei xound nimza wou Anutu. ");
INSERT INTO tbx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Tyek xel bong kwa ti beimambei yon en xel se woulek Mang o ay. ");
INSERT INTO tbx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","A neil wou xam woy en tine, en kandek gyeik ingwei bouk on embei nam on tyek xam ghe bou naleimim bei a peti xam woy. A se neil ti beimambei ne wou xam myaxeeng en nambei a toundei is xam. ");
INSERT INTO tbx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Ekom gweimbeeng ambei na wou tambiy tiwei wong a lam o, ekom xam ti seng teling ay bei, ‘Wa being na nya?’ ");
INSERT INTO tbx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Qe xam laleimim wo nimaying en nambei a neil ti beimambei ne woy wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ekom a neil wou xam zonghek: Inye nimza wou xam en ingwei ambei na yo. Wangwei a se na, ond tyek Laweeng Vineing wei embei devind xam eno tyek se nam. Ekom wangwei a na, ond tyek a bong e nak wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ka moxo embei nam, ond tyek bong moux alis vex wei tembuing o boulek sewokeing qes me kwa wei bombek eno qes me Anutu embei bong qayeeng eno qes: ");
INSERT INTO tbx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Om sewokeing qes eno nambei nye, xomaxoneing se wongis ay. ");
INSERT INTO tbx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Eivek kwa wei bombek eno nambei nye, ambei na wou Mang, de tyek xam seng nox mena gwei a no. ");
INSERT INTO tbx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Me Anutu embei bong qayeeng eno qes ambei nye, gyovaxa tiwei mi yeiteyei tembuing eno nale lek qayeeng woy. ");
INSERT INTO tbx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“A xe qayeeng ngenong wei ambei neil wou xam, ekom gweimbeeng xam seng teyei bei zeimaxoun. ");
INSERT INTO tbx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ekom gyeik e, Laweeng Zonghek nam, ond tyek beil xam lumim lek en qayeeng zonghek dalus. Moxo tyek se neil qayeeng nangya e maxow xe kwa, qe tyek na neil vati wei ngo yo teyei, me moxo tyek na neil lul wei mendi nam yus o wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Moxo tyek bong lei ngandoung wou ay, en nambei moxo tyek na qou lul wei a xe yo me na neilteyei wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Lulul dalus wei Mang xe eno inye a xe. En qes tiyon om ingwei a neimbei Laweeng tyek na qou lul wei a xe yo me na neilteyei wou xam.” ");
INSERT INTO tbx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesu neil no bei, “Eivek bouk sepika eno tyek xam seng gwei a no, dekakom eivek bouk sepika eno tyek xam ghe gwei ay.” ");
INSERT INTO tbx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Moxo xe xel betiyeing valu di neil wouma bei, “Inye neil qayeeng tine qes nambei nya, wei neil embei, ‘Eivek bouk sepika eno tyek xam seng gwei a no, dekakom eivek bouk sepika eno tyek xam ghe gwei ay.’ De moxo neil is ambei nye, ‘Qes bei ambei na wou Mang’?” ");
INSERT INTO tbx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Xel di embek teling wouma bei, “Moxo neil ‘bouk sepika’ inye qes ambei nya? Xe se woulek vati wei e neil o.” ");
INSERT INTO tbx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu yei bei xel embei teling e en inyon, om moxo neil wou xel bei, “Xam ghe di teling ama en vati wei a neil o qes gyeik ingwei a neimbei, ‘Eivek bouk sepika eno tyek xam seng gwei a no, de woyom ka eivek bouk sepika eno tyek xam ghe gwei ay.’ ");
INSERT INTO tbx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","A neil wou xam zonghek, tyek xam ghe deeng me ghe bo talot, de xomaxoneing wei tembuing sapa eno tyek bo xeindlala, de xam laleimim tyek bo maying, ekom lalei maying wei xam eno tyek pekwi me bo xeilala. ");
INSERT INTO tbx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Vex ti embei bou neu eno axe vanei en e ning bouk lam, ekom gyeik ingwei vexo neu umbek eno wo xeilala de nalei ma vanei yon en nambei neu umbek woy lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Om xam is: Gweimbeeng xam laleimim tyek bo maying, ekom tyek anghei xam no de tyek xam ghe bo xeimimlala, de xelti tyek se zeim xam xe xeilala veil. ");
INSERT INTO tbx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","De eivek bouk tiyon eno tyek xam se teling ay en lulti. A neil wou xam zonghek, Mang tyek bong vatiyeiw wei xam ghe teling en a leing eno wou xam. ");
INSERT INTO tbx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Takwei eno xam seng teling lulul ti en a leing. Xam teling ond tyek xam a qou, de tyek xam xe xeilala na pup xam lek. ");
INSERT INTO tbx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“A mi neil qayeeng wou xam eivek pakeing, de gyeik ingwei bouk ti tyek nam eno tyek a se nox a neil vya nambei nyon no qe tyek a neil e gyeip yaing wou xam en Mang. ");
INSERT INTO tbx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Eivek bouk tiyon eno tyek xam teling en a leing. A se neimbei tyek a teling wou Mang en xam. ");
INSERT INTO tbx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ma. Mang venaxow lalei vind xam en nambei xam laleimim vind a woy me ghe wongis bei a lam anghei ingwei Anutu toundei nei. ");
INSERT INTO tbx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","A lam anghei ingwei Mang toundei nei me na lam tembuing, de gweimbeeng tyek a na veil tembuing me na nox me na wou Mang.” ");
INSERT INTO tbx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Woyom Yesu xe xel betiyeing neil embei, “Gweimbeeng wang neil e yeip yaing dom wa seng neil qayeeng pakeing. ");
INSERT INTO tbx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Xa xei bei wang woulek lulul dalusateiv me wa seng wou naleim bei xelti teling wou wang. Tine wong xa wongis bei wang lam anghei ingwei Anutu mindei nei.” ");
INSERT INTO tbx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu neil embei, “Gweimbeeng xam ghe wongis?” ");
INSERT INTO tbx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ekom bouk di lam paviy, me lam tyip paviy, gyeik ingwei xel embei tiy xam davuna bamim titi yo. Tyek xam ghe na veil ay me a toumendei venaxow, ekom a maxow se toundei, en Mang toundei is ay. ");
INSERT INTO tbx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“A neil wou xam woy en lulul ti beimambei ne, en kandek eivek ay eno tyek xam a qou lalei vevopeing. De eivek tembuing ne eno tyek xam a qou nimaying. Ekom xam laleimim se bo maying! En a xoklek nikanzek wei tembuing ne yo.” ");
INSERT INTO tbx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Ka Yesu neil tiyon woy, eno yeila tyoung gheyapu me zeimema: “Mang, seivma la wou eivek woy. Wang bong lei ngandoung wou Neum Moux, en kandek Neum Moux bo lei ngandoung wou wang. ");
INSERT INTO tbx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","En wang wong lei wei nikanzek eno wou moxo woy ghanaw xomaxoneing sapa wei e teyei bei bong mapieing luta luta wou xel wei wang wo wou e woy yo. ");
INSERT INTO tbx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Inye deing mapieing wei luta luta yo: wei xel woulek wang o, wamaxow tixemou Anutu zonghek, me Yesu Kilisi wei wang wong e lam o. ");
INSERT INTO tbx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","A wong wa leim wo ngandoung lek tembuing, de na wong xuk wei wang wong wou ay bei a bong eno ma. ");
INSERT INTO tbx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","De gweimbeeng, Mang wang bong lei ngandoung wou ay eivek wa mamghalus, lei ngandoung tiwei a qou takwei gyeik a toundei is wang de tembuing se ghei qandi yo. ");
INSERT INTO tbx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“A neil wa leim teyei wou xel wei wang wong wou ay veil tembuing ne yo. Xel ne wa xe, wang wong xel wou ay me xel mi betiwou wa xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Gweimbeeng xel woulek bei lulul sapa wei wang wong wou a ne lam wou wang. ");
INSERT INTO tbx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","En a wong qayeeng dalus wei wang wong wou ay eno wou xel me xel qou dalus. De xel woulek neing ayang bei a lam anghei ingwei wang mindei yon, me xel wongis bei wang wong a lam. ");
INSERT INTO tbx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","A zeimemang en xel. A se zeimemang en xomaxoneing wei tembuing sapa yo, qe xel wei wang wong wou ay yo, en xel on wa xe. ");
INSERT INTO tbx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Xel dalus wei a xe eno inyon wa xe, de xel dalus wei wa xe eno inyon a xe. Me lei wei ngandoung eno lam wou ay eivek xel. ");
INSERT INTO tbx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Tyek a se toumendei enden lek tembuing, qe tyek xel a toumendei lek tembuing, de a di lam wou wang. Mang vambuing, wa mi bale zeyi xel nangya wa leim, lei tiyon wang wong wou ay, en kandek xel bo tixemou nambei uw a wo tixemou yo. ");
INSERT INTO tbx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Bouk wei a mindei is xel, eno a mi nale zeyi xel en wa leim me na mi xeiteyei xel en lei tiwei wang wong wou ay yo. De xelti se lati qe tixemou wei tyek na qou nilul o, en kandek qayeeng wei di yeip eivek qapiya eno bo neing lek. ");
INSERT INTO tbx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“A di lam wou wang gweimbeeng, ekom a neil ti beimambei ne gyeik a toundei lek tembuing ne, en kandek xel a qou a xe xeilala me e pup xel laleind lek. ");
INSERT INTO tbx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","A wong wa xe qayeeng wou xel de moux alis vex wei tembuing ne laleind wo nol wou xel, en xel ne eno se nanghei tembuing ne en nambei a se nanghei tembuing. ");
INSERT INTO tbx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","A xe zeimeing mema ne se en ingwei wambei zeim xel veil tembuing ne qe wa mi bale zeyi xel en tambiy tiwei nilul o. ");
INSERT INTO tbx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Xel ne se nanghei tembuing, nambei a ne se nanghei tembuing. ");
INSERT INTO tbx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Wang bong xel on bo vambuing beyaleing nangya wa xe qayeeng zonghek, en wa xe qayeeng on zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nambei wang wong a lam lek tembuing, om a wong xel la eivek tembuing. ");
INSERT INTO tbx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","En a beyal venaxow wo vambuing en xel, en kandek xel bo vambuing zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“A xe zeimeing mema ne se en xel venaxow. Qe a zeimemang is ambei nyon en xel wei tyek na ngo xel xe qayeeng me bongis ay yo, ");
INSERT INTO tbx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mang, a bei xel bo tixemou, nambei wang mindei eivek ay de a mindei eivek wang o. Me xel mendei eivek uw en kandek moux alis vex wei tembuing ne bongis bei wang wong a lam. ");
INSERT INTO tbx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","A wong lei ngandoung tiwei wang wong wou ay eno wou xel en xel a mi mendei tixemou nambei uw a mindei tixemou yo. ");
INSERT INTO tbx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","A toundei eivek xel de wang toundei eivek ay. De ambei xel mendei tixemou en xel wei tembuing ne boulek bei wang wong a lam, de wa laleim devind xel nambei wa laleim vind ay yo. ");
INSERT INTO tbx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Mang, ambei moux alis vex wei wang wong wou a ne eno na mendei lek beyeeng wei ambei mendei yo, me gyei a xe xeiyaing ngandoung me lei ngandoung wei wang wong wou ay yo, en nambei wa laleim vind ay takwei wei tembuing anghei ma yo. ");
INSERT INTO tbx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Mang wei bombek o, xomaxoneing wei tembuing ne se woulek wang, qe a woulek wang, me xel woulek bei wang wong a lam. ");
INSERT INTO tbx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","A talex wang wou xel, en vati wei wa laleim vind o, me tyek a mi tetulexe wou xel. Woyom tyek xel a qou lalei vineing nambei ingwei wang wong wou ay yo, me tyek a maxow a mi mendei eivek xel.” ");
INSERT INTO tbx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Ka Yesu zeimema woy, eno lis e xe xel betiyeing sek memiing Kidron me la. Nanghei loxalu eno xuk oliv ti toundei inyon, om Yesu lis e xe xel betiyeing la eivek. ");
INSERT INTO tbx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudas tiwei embei neil Yesu teyei me na toung e na eivek xel ba memend eno woulek beyeeng tiyon, en nambei Yesu lis e xe xel betiyeing mi qekuma lumama nanghei inyon. ");
INSERT INTO tbx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Om Yudas lam eivek xuk oliv on me qou xel vevek qendu ti me xel belimbo wei xel lumuki leitata me xel Parisi wong eno me lam, xel zeim lam me zounghexeing me lulul wei vevek o. ");
INSERT INTO tbx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu woulek lul dalus wei embei qandi wou e yo, om moxo la paviy me teling xel, “Xam ghe di wimexe eti?” ");
INSERT INTO tbx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Xel neil elox bei, “Yesu wei Nasaret o.” Yesu neil, “Ay inye.” De Yudas tiwei embei toung e eivek xel memend eno toukale inyon is xel. ");
INSERT INTO tbx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Xel ngo ingwei Yesu neil embei, “Ay inye,” eno xel duxeind me lox dom beng me yeip lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Moxo lox me la teling xel no, “Xam ghe di wimexe eti?” De xel neil, “Yesu wei Nasaret o.” ");
INSERT INTO tbx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu lewexe, “A neil wou xam woy bei ay inye. Wangwei xam mendi gwimexe ay, yond xam ghe bong xel moux beimambei ne na.” ");
INSERT INTO tbx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Tine wong ambei nye en kandek qayeeng wei e neil eno embo neing lek: “Xel wei wang wong wou ay eno ti tyek se nati.” ");
INSERT INTO tbx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Woyom Simon Petele puw e xe ngeyeing vevek me qateiv xukxe wei lumuki lukanzek xe yo nenya payeiv tip. Xukxe tiyon lei Malkus. ");
INSERT INTO tbx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu luk nikanzek wou Petele, “Toung wa xe ngeyeing vevek lox eivek myabelis! Wambei tyek a se num eivek mayamya wei Mang wong wou ay yo?” ");
INSERT INTO tbx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Woyom xel vevek qendu ti me xel beyeiv is xel belimbo wei Yudayeiw o zeimaxoun Yesu. Xel qo moxo nangya yis ");
INSERT INTO tbx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","me qou e me la tax wou Anas, Anas on Kaiapas yeing wei wo lumuki lukanzek lek vakovek qes tiyon o. ");
INSERT INTO tbx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas tiwei wo xoulek wou xel lei ngandoung wei Yuda yo, inye nimza bei moux tixemou e mey en xomaxoneing. ");
INSERT INTO tbx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petele me betiyeing nge di betiy Yesu. En nambei lumuki lukanzek woulek betiyeing tine, om moxo la is Yesu eivek tete lalei wei lumuki lukanzek xe yo, ");
INSERT INTO tbx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ekom Petele toundei myayaing paviy qapomb me axe. De betiyeing nge wei lumuki lukanzek woulek, eno loumelam neil wou vexawo wei di yeiteyei qapomb o me qou Petele me la lalei. ");
INSERT INTO tbx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Vexawo wei mi yeiteyei qapomb eno teling wou Petele, “Wang ond se e xe betiyeing ti?” Moxo neil elox bei, “Ma, se ay.” ");
INSERT INTO tbx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Inye wo nityuweing, om xel xukxe me beyeiv toukale vivekwou nenyex wei xel vev me di pavang xow o. Petele is ambei nyon toukale is xel me pavang xow. ");
INSERT INTO tbx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Dekalekom lumuki lukanzek teling wou Yesu en e xe xel betiyeing me e xe qayeeng wei mi teyoxe yo. ");
INSERT INTO tbx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu neil elox bei, “A mi neil qayeeng yanyateiv wou xomaxoneing sapa, taxombouk eno a mi teyoxe xel eivek xomek qekueing ama, o eivek tete lalei wei xomek vambuing wei xel Yudayeiw mi qekuma yo. A se neil qayeeng ti xupekeing. ");
INSERT INTO tbx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wang teling ay enva? Wa teling xel wei mi ngo a xe qayeeng o. En neing ayang xel woulek vati wei a mi neil o.” ");
INSERT INTO tbx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu neil qayeeng tine woy eno beyeiv wei toukale paviy eno ti petapexe moxo ling. De neil embei, “Inye kwa wei wa being zewexe lek lumuki lukanzek eno nambei nyon?” ");
INSERT INTO tbx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu neil elox bei, “Wangwei a neil lulti sewok, ond wa neil sewokeing tiyon teyei. Ekom wangwei a neil zonghek, ond nambei nya wang petapexe ay?” ");
INSERT INTO tbx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Woyom Anas wong Yesu la is yis wei xel tup e xoun o wou lumuki lukanzek Kaiapas. ");
INSERT INTO tbx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ka Simon Petele toukale me pavang xow, eno xel teling e, “Wangwei bei wa se e xe betiyeing ti?” Moxo axvun me neil embei, “Ma, se ay ti.” ");
INSERT INTO tbx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ekom Lumuki lukanzek xe xukxe ti, inye nipapu wei tambiy tiwei Petele qateiv e nenya tip o neil embei, “Beip a xei wang eivek xuk oliv is e?” ");
INSERT INTO tbx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petele lox me la axvun no, de lutika eno qouklex sesa vya. ");
INSERT INTO tbx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Woyom satiboukeing lul eno xel Yudayeiw qou Yesu me la veil xomek wei Kaiapas o me la xomek wei lei ngandoung wei seyap wei Rom o. Xel wou naleind bei tyek xel bo nilaxes wou Anutu ma, om tyek xel se gya mata wei Pasova yo. Om xel se la eivek xomek lalei wei lei ngandoung wei seyap o. ");
INSERT INTO tbx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Om Pailat lam myayaing wou xel me teling, “Xam a being bong qayeeng lek tambiy tine en vati?” ");
INSERT INTO tbx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Xel neil elox bei, “Wangwei e se bo kwa wei nilul o, ond tyek xa se qou e me na bong e nam wou wang.” ");
INSERT INTO tbx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailat neil embei, “Xam venaxow a qou moxo me ghe na bong qayeeng en e nangya xam venaxow xe petieing.” Xel Yudayeiw neil elox, “Ekom xel peti xa bei xa se nyeis xelti mey.” ");
INSERT INTO tbx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Tine wong ambei nyon en kandek qayeeng wei Yesu neil atax en e xe meyeing wei tyek na mey ambei nya eno bo neing lek. ");
INSERT INTO tbx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Woyom Pailat lox me la eivek xomek lalei wei seyap o me taxe Yesu la wou e, de teling moxo bei, “Inye wa king wei Yudayeiw o?” ");
INSERT INTO tbx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu teling, “Inye wamaxow xe woueing nalei, o xel valu neil wou wang en ay?” ");
INSERT INTO tbx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailat neil elox bei, “Inye a Yuda ti? Wa xe xel is xel lumuki leitata qou wang me lam wou ay. Wang wo vati?” ");
INSERT INTO tbx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu neil embei, “A xe tete lalei se nanghei tembuing ne. Wangwei nambei nyon on tyek a xe xel xukxe bo vevek zeyi ay, en kandek xel lei ngandoung wei Yuda eno se zeimaxoun ay. Ekom a xe tete lalei nanghei beyeeng bange.” ");
INSERT INTO tbx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailat neil, “Inye wa king ti!” Yesu lewexe, “Inye wang neil bombek en ingwei wang neimbei a king ti yo. En qes tiyon om a umbek, me en tiyon eno a lam eivek tembuing en ambei nam a neil qayeeng zonghek teyei. Xel eti yeiw wei mi betiwou qayeeng zonghek eno mi ngo ay.” ");
INSERT INTO tbx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailat teling, “Zonghek on vati?” De lox me la myayaing wou Yudayeiw no, wei di qekuma me neil embei, “A se xeiwou qayeeng qes ti eivek moxo bei xey a bo qayeeng en e. ");
INSERT INTO tbx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ekom inye xam venaxow xe kwa bei a mi bong xel wei toundei eivek xeitueing eno ti nak myayaing wou xam lek bouk wei Pasova yo. Xam ambei a bong king wei Yudayeiw o nak?” ");
INSERT INTO tbx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Xel taxe elox bei, “Ma, se e! Qe wong Barabas lam wou xa!” Barabas on mi wo vevek me mi panax. ");
INSERT INTO tbx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Woyom Pailat qou Yesu me la bei xel sesa e. ");
INSERT INTO tbx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Xel vevek viy yis qapangek lekti me buwexe nambei qelumking me toung lek e lu. De xel byex teimb ding wei mateyek o ti lek e ");
INSERT INTO tbx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","de xel lam wou e lumama me neil embei, “Bendiyeing king wei Yudayeiw o!” Dom xel petapexe e ling. ");
INSERT INTO tbx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailat loumelam myayaing no me neil wou xel Yudayeiw wei di qekuma yo bei, “Wei, a qou e me na loum myayaing bei xam ghe boulek bei a se xeiwou qayeeng qes ti lek e bei a bo qayeeng en e.” ");
INSERT INTO tbx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Om Yesu lam myayaing is qelumking wei qapangek ying wei xel toung lek e lu me teimb ding wei mateyek o de Pailat neil wou xel bei, “Tambiy tiyo inye!” ");
INSERT INTO tbx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ka xel lumuki leitata me xel xe beyeiv yei moxo, eno xel taxe la bei, “Tuw e lek xax pepeeng! Tuw e lek xax pepeeng!” Ekom Pailat neil elox wou xel bei, “Xam venaxow qou e me tuw lek xax pepeeng, en ay eno a se xeiwou qayeeng qes ti bei a bo qayeeng en e.” ");
INSERT INTO tbx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Lei ngandoung wei Yudayeiw neil elox bei, “Xe xe petieing ti, me petieing tiyon neil embei e mey, en emaxow neil embei e Anutu Neu Moux.” ");
INSERT INTO tbx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailat ngo tine, eno moxo yaleeng ngandoung mouyo, ");
INSERT INTO tbx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","de moxo lox lalei eivek xomek seyap. Me teling wou Yesu, “Wang lam anghei inya?” Ekom Yesu se neil lulti wou e. ");
INSERT INTO tbx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailat neil, “Wambei se baluk wou ay? Wa seng woulek bei a xe nikanzek teyei bei bo wang na myayaing o na tuw wang lek xax pepeeng?” ");
INSERT INTO tbx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu neil elox bei, “Wa se xe nikanzek ti ghanaw ay, wangwei Anutu se bong wou wang anghei gheyapu nei. Nambei nyon om tambiy tiwei qou a me lam wou wang ne eno wo sewokeing ghanaw wang veil.” ");
INSERT INTO tbx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Woyom Pailat di wong me yei en embei bo Yesu na myayaing, ekom xel lei ngandoung wei Yudayeiw eno taxe la bei, “Wangwei wang bong tambiy tine na ond wa se gweleeng wei Sisa yo. Tambiy ti embei neimbei emaxow king ond wo vevek wou Sisa.” ");
INSERT INTO tbx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailat ngo tine, eno moxo qou Yesu me la myayaing me deilek sia wei tambiy wei mi ngo qayeeng o nanghei beyeeng wei xel mi neil qakous zek o. Eivek Hibru vyend eno xel mi neil Gabata. ");
INSERT INTO tbx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Inye bouk wei Menyexeing lulul lek Sounda tiwei Pasova yo, inyon nambei seivma evlek. Pailat neil wou xel Yudayeiw, “Inye xam xe king.” ");
INSERT INTO tbx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ekom xel taxe la bei, “Qou e me la veil! Qou e me la veil! De tuw e lek xax pepeeng!” Pailat teling, “Teyei bei a tuw xam xe king lek xax pepeeng?” Xel lumuki leitata lewexe bei, “Xa se xe king ti qe Sisa venaxow.” ");
INSERT INTO tbx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Om Pailat wong e la wou xel bei xel atuw e lek xax pepeeng. Om xel vevek qou Yesu me la. ");
INSERT INTO tbx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","De emaxow qalei e xe xax pepeeng me xel la beyeeng tiwei xel mi taxe lukanzek o. Eivek Hibru vyend eno xel mi taxe bei Golgata. ");
INSERT INTO tbx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nanghei inyon eno xel tuw e lek xax pepeeng is luw yayuw, nge wou valu de nge wou valu de Yesu eivek senghoing. ");
INSERT INTO tbx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailat byex qayeeng ti me tuw lek xax pepeeng, qayeeng tine neil ambei nye: YESU WEI NASARET O, KING WEI YUDAYEIW O. ");
INSERT INTO tbx_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yudayeiw ngenong pyaw dee tiyon, en beyeeng wei xel tuw Yesu lek xax pepeeng on toundei paviy beyeeng ngandoung, dee tiyon xel byex eivek Hibru vyend, me Rom me Grik. ");
INSERT INTO tbx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","De xel lumuki leitata wei Yudayeiw eno neil elox wou Pailat, “Wa se byex bei ‘King wei Yudayeiw o ti,’ qe tambiy tine neil embei, ‘A king wei Yudayeiw o.’” ");
INSERT INTO tbx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pailat lewexe bei, “Vati wei a byex, eno e toumendei nambei a byex woy.” ");
INSERT INTO tbx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Xel vevek tuw Yesu lek xax pepeeng woy, eno xel qou e xe teimb dalus me dembu e la qendu vey, ti wou xel titi, is teimb ding wei xel duw en qaeing tixemou nanghei kwa me e la vaxa yo. ");
INSERT INTO tbx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Xel neil wouma bei, “Xey ambei se zex teimb tine qe xey ambei banex qakous dee me na ghei bei eti tyek na qou.” Tiyon la teyei lek xoulek wei di yeip eivek qapiya wei neil embei, “Xel dembu a xe teimb wouma eivek xel venaxow senghoing de xel nex qakous dee en a xe teimb ding.” Om inye vati wei xel vevek wong o. ");
INSERT INTO tbx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Paviy Yesu xe xax pepeeng eno ta me ta li vex toukale, me Maria wei Klopas venei me Maria wei Makdala yo. ");
INSERT INTO tbx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Gyeik ingwei Yesu yei ta nanghei inyon me betiyeing tiwei e lalei vind o toukale paviyeing, eno Moxo neil wou ta, “Vex wei, wa neum moux inyon,” ");
INSERT INTO tbx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","woyom neil wou betiyeing tiyon bei, “Wei, vex tiyon wa tam.” Lek bouk kayon me e mi la, eno betiyeing tiyon qou vexo me la e maxow beeng. ");
INSERT INTO tbx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kalekom Yesu woulek bei lulul dalus la wou eivek en kandek xoulek wei di yeip eivek qapiya eno bo neing lek, de Yesu neil embei, “A kwang tip.” ");
INSERT INTO tbx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Deng wain senyeing ti toundei inyei, om xel toung balam eivek wain me e pup, dom tup lek xax hisop mema de zeim e lek la wou Yesu mya. ");
INSERT INTO tbx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu num wain ma, eno neil embei, “Moxo ma yo.” De ivma eivek dom wong nulaweeng la. ");
INSERT INTO tbx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Bouk tiyon inye bouk wei Menyexeing wou lulul o, de yanyeing eno inye bouk ngandoung wei Sabat o. Om xel lei ngandoung wei Yudayeiw embei xel neing se toungami lek xax pepeeng lek bouk wei Sabat o, om xel teling wou Pailat bei xel na pyaw xel vaxend apek de zewax xel neing veil. ");
INSERT INTO tbx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Om xel vevek la pyaw tambiy nge myaxeeng wei tumilek xax pepeeng wou Yesu byek o vaxa pek. De woyom xel la pyaw nge wei tumi wou e byek valu yo. ");
INSERT INTO tbx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ekom gyeik ingwei xel lam wou Yesu eno xel yei bei mey woy, om xel se pyaw e vaxa luw xouing. ");
INSERT INTO tbx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Ekom xel vevek ti beum Yesu byek en yiy, de lutika eno gyand aluw memiing lam. ");
INSERT INTO tbx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","De tambiy tiwei yeimalek eno neil qayeeng en, me e xe qayeeng on wo neing. Moxo woulek bei neil zonghek. Om neilteyei en kandek xam ghe bongis ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Lulul ti beimambei yon la teyei lek en kandek xoulek wei di yeip eivek qapiya yo bo neing lek: “Tyek xel se pyaw e kanzek ti pek.” ");
INSERT INTO tbx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","De qayeeng nge neil ambei nye, “Tyek xel mendi gyei tambiy tiwei xel beum o.” ");
INSERT INTO tbx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kalekom Yosep wei Arimatia yo la teling wou Pailat en Yesu neing. Yosep on Yesu xe betiyeing ti, ekom mindei xupekeing en nambei yaleeng en xel lei ngandoung wei Yudayeiw. Pailat lewexe lek e om la qou Yesu neing me la. ");
INSERT INTO tbx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas, tambiy tiwei takwei eno la wou Yesu eivek boukeing eno la is Yosep me qou wel xeimangou wei xel maleeng xax mer me aloes myalouk lekti yo me lam. Nimaying teyei lek xoumeeng yal (30) kilo. ");
INSERT INTO tbx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Tambiy yuw on qou Yesu neing me pelei wel wei xeimangou yo lek de beliv eivek qaeing teleing teyei lek Yudayeiw xe kwa wei xel mi ev xel meyeing o. ");
INSERT INTO tbx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Eivek beyeeng wei xel tuw Yesu lek xax pepeeng nanghei yon eno xuk ti toundei inyon, de eivek xuk tiyon eno leiveeng meyeing vako ti toundei, xel seng ghei liw xelti eivek. ");
INSERT INTO tbx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","En inyon nambei Yudayeiw xe bouk wei menyexeing lulul o de nambei leiveeng meyeing tiyon toundei paviy, om luw lak liw Yesu eivek nanghei inyon. ");
INSERT INTO tbx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Satiboukeing lul wei di nexla lek bouk ti myaxeeng wei sounda tiyon, eno Maria wei Makdala la ingwei leiveeng meyeing nei me yei bei qakous tatekexe veil leiveeng mya. ");
INSERT INTO tbx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Om vexo veimya me loum neil wou Simon Petele luw betiyeing nge wei Yesu lalei mi vind o, me neil embei, “Xel qou Tambiy Ngandoung veil leiveeng meyeing, de xa se woulek ingwei xel liw anghei yo.” ");
INSERT INTO tbx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Om Petele luw betiyeing nge yon qandi me la ingwei leiveeng meyeing nei. ");
INSERT INTO tbx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Luw xouing veimyend me la, ekom betiyeing nge yon veimya me ghanaw Petele me la ingwei leiveeng meyeing nei tax. ");
INSERT INTO tbx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Moxo dundek me yeila qaeing di yeip inyon, ekom se la lalei. ");
INSERT INTO tbx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Woyom Simon Petele betiy e me la inyon, me eivek la lalei me yei qaeing wei di yeip inyon o, ");
INSERT INTO tbx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ka yei qaeing nge wei xel tup e vivekwou Yesu lu, eno xelti pyaw me toung beyaleing veil qaeing ba. ");
INSERT INTO tbx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Woyom betiyeing nge wei la leiveeng meyeing nei tax, eno la lalei is ambei nyon. Moxo yei me wongis. ");
INSERT INTO tbx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Neing, xoulek wei yeip eivek qapiya bei Yesu qandi lek veil meyeing eno xel seng ghei woulek. ");
INSERT INTO tbx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Woyom betiyeing aluw lox me la bend. ");
INSERT INTO tbx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ekom Maria toukale myayaing paviy leiveeng meyeing me di eng. Ka vexo di eng, vexo dundek me yeila leiveeng meyeing lalei. ");
INSERT INTO tbx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Me yei angela yayuw is teimb wei teltyip o. Luw toundei wou kawei xel liw Yesu neing lek o, nge toundei wou e lu de nge toundei wou e vaxa. ");
INSERT INTO tbx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Luw teling wou vexo bei, “Vex, wang eng en vati?” Vexo neil embei, “Xel qou a xe Tambiy Ngandoung, de a se woulek bei xel liw e nanghei inya.” ");
INSERT INTO tbx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Maria neil ambei nyon de pekwi ma me yei e vivekwou eno yei Yesu toukale inyon, ekom vexo se yeimawou bei inyon Yesu. ");
INSERT INTO tbx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu neil embei, “Vex, nambei nya wang di eng? Eti ingwei wang di wimexe yon?” Maria embeik nge inyon tambiy wei mi yeiteyei xuk o, om vexo neil wou bei, “Teiv wangwei wa qalei e me na nei, ond wa neil wou ay en ingwei wang liw e nanghei yo, en kandek a na qou moxo.” ");
INSERT INTO tbx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu neil wou vexo, “Maria.” De vexo pekwi ma me neil wou e eivek Hibru vyend, “Rabuni” qes ambei nye Putoung. ");
INSERT INTO tbx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu neil embei, “Wa seng daxlek ay, en a se ghei lox gheyapu wou Mang. Wang nox wou a lingyeiw me na neil wou xel, ambei nox me na wou Mang me xam Mamim, wou a xe Anutu me xam xe Anutu.” ");
INSERT INTO tbx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maria wei Makdala yo lox wou xel betiyeing me neil embei, “A xei Tambiy Ngandoung!” De vexo neil wou xel en qayeeng wei moxo neil wou e yo. ");
INSERT INTO tbx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Lek soukeing wei bouk ti myaxeeng wei sounda tiyon, xel betiyeing qekuma, eno xel toung qapomb beimambei yond zeyi en xel yaleeng en lei ngandoung wei Yudayeiw, eno Yesu lam me nale eivek xel senghoing me neil, “Lalei vevopeing e mi mendei is xam.” ");
INSERT INTO tbx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ka moxo neil ambei nyon woy, moxo talex mema luw me byek wou xel. De xel betiyeing wo xeindlala ngandoung gyeik ingwei xel yei Tambiy Ngandoung o. ");
INSERT INTO tbx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu neil no bei, “Lalei vevopeing e mi mendei is xam! Nambei ingwei Mang wong a lam. De a wong xam ghe la.” ");
INSERT INTO tbx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","De is inyon eno moxo vei mya laweeng la lek xel de neil embei, “Xam ghe qou Laweeng Vambuing. ");
INSERT INTO tbx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Wangwei xam semaleeng sewokeing wei xelti yo, on tyek Anutu semaleeng sewokeing veil. Ek wangwei xam se semaleeng sewokeing wei xelti yo, ond tyek Anutu se semaleeng sewokeing veil.” ");
INSERT INTO tbx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomas wei xel mi taxe Didimas, xel xoumeeng yuw eno ti, se toundei is xel betiyeing gyeik ingwei Yesu lam o. ");
INSERT INTO tbx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Om xel betiyeing ba neil wou e bei, “Xa xei Tambiy Ngandoung!” Ekom moxo neil wou xel bei, “Wangwei a se ghei beleim mya me na toung memang deyis eivek e mema luw, me na toung memang eivek yiy mya wei e byek o, ond tyek a se bongis.” ");
INSERT INTO tbx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ka sounda qes ti la veil eno e xe xel betiyeing lox me la dei eivek xomek no, me Tomas toundei is xel. De xel toung qapomb zeyi, Yesu lam nale eivek xel senghoing me neil embei, “Lalei vevopeing e mi mendei is xam.” ");
INSERT INTO tbx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Woyom moxo neil wou Tomas bei, “Toung memam deyis lam inye me wei a memang aluw. De tatei memam lam me toung eivek a byek. Tip laleim yuw de wongis.” ");
INSERT INTO tbx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas neil wou e, “A xe Tambiy ngandoung me a xe Anutu.” ");
INSERT INTO tbx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Woyom Yesu neil wou e bei, “En nambei wang wei ay om wang wongis, xeilala e mendei is eti yeiw wei se yei ay qe xel wongis o.” ");
INSERT INTO tbx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu wong dee wei lulvako eno ngenong eivek e xe xel betiyeing mendghalus, ekom xel se byex eivek qapiya tine. ");
INSERT INTO tbx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ekom qayeeng ti beimambei wei a byex ne eno xam a mi bongis bei Yesu e Kilisi, me Anutu Neu Moux, de nangya wongeingis tiyon eno tyek xam a qou mapieing eivek e lei. ");
INSERT INTO tbx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kalekom Yesu talex xow wou e xe xel betiyeing no, nanghei lounyeing wei Taiberias nei. Inyon qandi nambei nye: ");
INSERT INTO tbx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Petele, me Tomas wei xel mi taxe e lei nge Didimas, me Natanael wei Kana eivek Galili yo, de Sebedi neu luw, me betiyeing yayuw is eno xel xouing toundei lekti. ");
INSERT INTO tbx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petele neil wou xel bei, “Ambei na qou woing.” De xel neil embei, “Xa bei na is wang.” Om xel la myayaing me la dei eivek bot, ekom boukeing tiyon eno xel se qou lulti. ");
INSERT INTO tbx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Satiboukeing lul eno Yesu toukale wou mamileeng vi, ekom xel betiyeing se woulek bei inyei Yesu. ");
INSERT INTO tbx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Woyom moxo taxe la wou xel bei, “Xam neungyeiw, xam ghe qou woing valu?” Xel neil elox bei, “Ma.” ");
INSERT INTO tbx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Moxo neil embei, “Xam banex xam xe lewek na eivek bot nenya valu wei payeiv o on tyek xam a qou valu.” Om xel wong ambei nyon, eno xel se teyei bei puw lewek noum en nambei woing on ngenongakes. ");
INSERT INTO tbx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Woyom betiyeing tiwei Yesu lalei mi vind eno neil wou Petele bei, “Inyei Tambiy Ngandoung!” Ka Simon Petele ngo moxo neil embei, “Inyei Tambiy Ngandoung,” om byex e xe teimb ding lek, en kwax veil de di wong xuk. De vyeip me la eivek memiing. ");
INSERT INTO tbx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","De xel betiyeing bamba di betiwou e eivek bot, de xel puw lewek wei pup en woing eno lam, en xel se toundei dingta veil nenyawes, inye nambei 100 mita. ");
INSERT INTO tbx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ka xel lam nenyawes eno xel yei nenyex bapax ti di tum de woing toundei lek, me belet valu is. ");
INSERT INTO tbx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu neil wou xel, “Xam a qou woing wei xam ghe qou yon valu me ghe nam.” ");
INSERT INTO tbx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Petele lek bot me la dandiy lewek la nenyawes. Inye pup en woing ngandoung teyei lek 153, xel woing ne ngenong ekom lewek se lex. ");
INSERT INTO tbx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu neil wou xel, “Xam lam wa.” Xel betiyeing yaleeng om ti se teling e bei, “Inyon wang eti?” En xel woulek bei inye Tambiy Ngandoung. ");
INSERT INTO tbx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu lam qou belet me wong wou xel de wong ambei nyon wou woing is. ");
INSERT INTO tbx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Tine inye luyal en ingwei Yesu talex xow wou e xe xel betiyeing gyeik ingwei qandi veil meyeing o. ");
INSERT INTO tbx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ka xel ya woy, eno Yesu neil wou Simon Petele bei, “Simon Yoan neu, beip wa laleim vind ay zonghek ghanaw xel ne?” Moxo neil embei, “Ee, Tambiy Ngandoung, wang woulek bei a laleing vind wang.” Yesu neil embei, “Wa mi bet a xe sipsip lingheing ne.” ");
INSERT INTO tbx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu neil no, “Simon Yoan neu, wa laleim vind Ay zonghek?” Moxo lewexe bei, “Ee, Tambiy Ngandoung, wang woulek bei a laleing vind wang.” Yesu neil embei, “Wa mi gweiteyei a xe sipsip.” ");
INSERT INTO tbx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Luyal eno moxo neil wou e, “Simon Yoan neu, wa laleim vind ay?” Petele lalei wo maying en nambei Yesu teling e luyal, “Wa laleim vind ay?” Moxo neil embei, “Tambiy Ngandoung, wang woulek lulul dalus, om wang woulek bei a laleing vind wang.” Yesu neil embei, “Wa mi bet a xe sipsip. ");
INSERT INTO tbx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","A neil wou wang zonghek, gyeik ingwei wa ghavis eno wang vunekwou xow me ghe la teyei lek ingwei wang wou naleim en o, ekom gyeik ingwei wang wo teiv eno tyek wa tatei memam luw xouing na, de xel valu tyek bunekwou wang me na qou wang me na ingwei wa bei seng na yo.” ");
INSERT INTO tbx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu neil tine en sakwaing wei Petele tyek na mey de bo lei ngandoung wou Anutu yo. Woyom neil wou moxo bei, “Wang nam betiwou ay!” ");
INSERT INTO tbx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petele pekwi ma me yei betiyeing tiwei Yesu lalei vind eno di betiwou luw. Inyon tambiy tiwei liw lu la lek Yesu bambou me neil, “Tambiy Ngandoung, eti tyek na neil wang teyei me na toung wang na eivek xel ba memend?” ");
INSERT INTO tbx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ka Petele yei e, eno moxo teling bei, “Tambiy ngandoung nambei nya wou e?” ");
INSERT INTO tbx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu neil elox bei, “Wangwei a neimbei e toumendei mapieing deka a noum le, ond inye wo vati wou wang? Wa betiwou ay.” ");
INSERT INTO tbx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Om pavulek la wo sapa eivek xel betiyeing, xel di neil embei betiyeing tine tyek se mey. Ekom Yesu se neil embei moxo tyek se mey, qe neil embei, “Wangwei a laleing devind bei e toumendei mapieing ond tyek na toumendei deka a noum le, ond inye wo vati wou wang?” ");
INSERT INTO tbx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Tine inye betiyeing tiwei neil qayeeng neing en lulul ti beimambei ne de byex dalus eivek qapiya. Me xey a woulek bei e xe qayeeng ne zonghek. ");
INSERT INTO tbx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu wong lulul ngenong valu is ambei nyon. Om wangwei xel a byex dalus nei, ond tyek beyeeng wei tembuing ne na ma en ingwei xey ambei toung qapiya eivek o.");
INSERT INTO tbx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiopilas, Eivek a xe qapiya nge tax, a byex myaxeeng en lulul dalus wei Yesu wong a tax me teyoxe xel o ");
INSERT INTO tbx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","me elam tyip bouk wei Anutu qou e lek la tyoung gheyapu nei, me eivek Laweeng Vambuing eno neil wou sinaleyeiw wei e beyal en xuk leimalei wei xel a mi bong o. ");
INSERT INTO tbx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ka e qou nimaying woy eno moxo talex xow yeip yaing wou moux ti beimambei ne bei toundei mapieing. Moxo belup wou xel lumama teyei lek bouk mepyeiyuw (40) me luk wou xel en tete lalei wei Anutu xe yo. ");
INSERT INTO tbx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ka e nanghei toundei is xel, me ya is xel eno moxo peti xel, “Xam sim ghe na veil Yerusalem, qe xam a mi mendei inye me daxe lul xeilala wei Mang neil zonghek bei bong o. Wei xam ghe ngo ingwei a luk en o. ");
INSERT INTO tbx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yoan lipek moux alis vex en memiing, ekom bouk di lam paviy en ingwei tyek xam ghe zipek en Laweeng Vambuing o.” ");
INSERT INTO tbx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Om gyeik xel sinale me Yesu qekuma, xel teling wou e, “Tambiy Ngandoung, gweimbeeng lek bouk tine eno tyek wang nox me na piyexe tete lalei wei Israel o no?” ");
INSERT INTO tbx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Moxo neil wou xel: “Inye se yeip wou xam bei xam ghe boulek seivma o bouk wei Mang venaxow lax angya emaxow nikanzek o. ");
INSERT INTO tbx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ekom tyek xam a qou nimkanzek gyeik Laweeng Vambuing nam lek xam o, me vati wei xam ghe wei mamim wou woy eno tyek xam a neil a teyei eivek Yerusalem, me ena eivek Yudia dalus me distrik Samaria, me ena tyip wou tembuing myasepu nei.” ");
INSERT INTO tbx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ka Yesu neil qayeeng tine woy, Anutu qou e lek la gheyapu wou xel mendghalus de laxap sevun e om xel se yei e no. ");
INSERT INTO tbx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Xel anghei di yei ingwei e la punei eivek tyoung gyeik e di la yo, lutika eno tambiy yuw byex teimb teleing me nale lip wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Luw neil wou xel, “Xam moux wei Galili yon, xam ghe toungale inye me ghe di domamim la wou tyoung en va? Yesu tiwei, Anutu qou veil xam me la eivek tyoung gheyapu nei, eno tyek noum me nam eivek sakwaing ambei kawei xam ghe wei e la eivek tyoung o.” ");
INSERT INTO tbx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Woyom xel betiyeing la veil lukendu wei xel mi taxe bei Oliv, me lox me la Yerusalem wei toundei paviy lukendu Oliv o, teyei lek ambei kilomita ti. ");
INSERT INTO tbx_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Gyeik xel la tyip, xel la gheyapu eivek xomek lalei wei xel embei mi mendei eivek o. Eti yeiw wei lam eno leind ambei nye, Petele, Yoan, Jems, me Andrias, Pilip me Tomas, Batolomiu me Matai, Alpias neu moux Jems me Simon wei Selot me Yudas on Jems neu moux. ");
INSERT INTO tbx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Xel xouing dalus mi qekuma me toung laleind lekti de mi zeimemend taxombouk, xel vex lam is me Maria wei Yesu ta, me liyeiw moux is. ");
INSERT INTO tbx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Eivek bouk tiyon Petele nale eivek xel wongeingis on senghoing (xel on teyei lek 120) ");
INSERT INTO tbx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","me neil, “Xam lingyeiw, xoulek wei yeip eivek qapiya ne eno embei bong neing lek ambei ingwei Laweeng Vambuing luk takwei nei eivek Dawit mya en Yudas tiwei talex sakwaing wou xel wei embei zeimaxoun Yesu yo. ");
INSERT INTO tbx_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yudas on tambiy wei xey yo ti, me mi wo xuk is xey.” ");
INSERT INTO tbx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Yudas qou malew en sewokeing wei talex Yesu teyei yo, me moxo la xouv tembuing ti en inyon woy. Woyom moxo teibouyek lek tembuing me leis bambou tek de xeixay qapyex lam myayaing. ");
INSERT INTO tbx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Xel dalus eivek Yerusalem eno ngo tine, om xel taxe tembuing tiyon lei eivek vyend bei Akeldama qes ambei nye bei Tembuing wei Gyand o.) ");
INSERT INTO tbx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Petele neil, “En inye xel byex eivek qapiya lalo bei, “‘Teyeimbei e beeng on mendei bandaing en xomaxoneing ti se mendei lek inyon,’ me, “‘teyeimbei tambiy nge e qou e nimbeeng en xuk wei la tax en xel o.’ ");
INSERT INTO tbx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Om inyon nimza bei xey a beyal moux wei mi la me loum is xey bouk sapa gyeik Tambiy Ngandoung Yesu mi dei is xey yo, ");
INSERT INTO tbx_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","lek bouk sapa wei Yoan lipek xel me elam tyip gyeik Yesu lek la gheyapu veil xey o. Om xey a beyal tambiy wei yeimawou woy eno nge en e neil Yesu xe qandieing lek teyei.” ");
INSERT INTO tbx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Om xel beyal moux yayuw: Yosep wei xel mi taxe bei Balsabas (lei nye bei Jastus) me Matias. ");
INSERT INTO tbx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Woyom xel zeimemend, “Tambiy Ngandoung, wang woulek xomaxoneing titi laleind. Talex wou xa bei luyuw ne nge na wang beyal, ");
INSERT INTO tbx_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","bei e gyeiteyei xuk sinale, wei Yudas ghanaw me la wou e maxow xe sakwaing o.” ");
INSERT INTO tbx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Woyom xel nex qakous dee, om qakous teila wou Matias, om moxo la is sinaleyeiw xoumeeng ti yon. ");
INSERT INTO tbx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Gyeik bouk wei Pentikos eno lam, om xel wongeingis dalus qekuma eivek xomek ti. ");
INSERT INTO tbx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Se denlek en nindenduing nambei laweeng nikanzek ti lam anghei tyoung gheyapu nei me pup eivek xomek lalei wei xel toundei eivek on. ");
INSERT INTO tbx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Xel yei lulti nambei nenyex, xok ambei ghas eno dembuma me la dei lek xel on titi. ");
INSERT INTO tbx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Laweeng Vambuing lam pupexe xomaxoneing on lek om xel luk vyend leimalei nambei ingwei Laweeng Vambuing wong wou xel o. ");
INSERT INTO tbx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Gweimbeeng inyon xel wei toundei eivek Yerusalem on Anutu xe xel Yudayeiw wei mi yaleeng en Anutu xe petieing me betiwou e yo, eno lam anghei beyeeng tambak wei mindei xeinghembi en tyoung gheyapu. ");
INSERT INTO tbx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Gyeik xel ngo nindenduing tine, moux alis vex ngenong on lam qekuma is etekeing, en nambei xel titi yon ngo xel di luk eivek xel venaxow titi vyend. ");
INSERT INTO tbx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Xel etek niseikeing, om xel teling: “Beip xel moux alis vex dalus tine eno se Galiliyeiw? ");
INSERT INTO tbx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Woyom nambei nya ekom xey titi ngo qayeeng eivek xe venaxow vyend? ");
INSERT INTO tbx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Xey wei Patia me Midia me Elam me Mesopotamia me Yudia me Kapadosia me Pontus me Esia, ");
INSERT INTO tbx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","me Prigia me Pampilia me Izip me ela valu wei Libia paviy Sairini, me xe valu lam anghei Rom me na lam a toundei inye. ");
INSERT INTO tbx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Xel on valu Yudayeiw me xel ba wei mi betiwou petieing wei Mose yo). Me xel valu wei Krit me Arebia, eno xey a ngo xel di neil xuk nimza maseim wei Anutu xe yo teyei eivek xemaxow vyend.” ");
INSERT INTO tbx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Xel etek me wou naleind ngenong, de teling wouma, “Tine qes nambei nya?” ");
INSERT INTO tbx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Xel valu eno luk seloukeing en xel me neil, “Xel num wain ngenong o.” ");
INSERT INTO tbx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Woyom Petele nale is sinaleyeiw xoumeeng ti yon, de luk me vya lekla dom neil qayeeng wou xel qendu ngandoung on bei, “Xam Yudayeiw me xam dalus wei ghe mindei eivek Yerusalem o, xam wong a neil qayeeng tine wou xam, xam a ngo embo nimza en vati wei ambei neil ne yo. ");
INSERT INTO tbx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Moux ti beimambei ne eno se num me wo nol, nambei ingwei xam ghe di wou naleimim en o. Inye nanghei seivma limvey wei satiboukeing o! ");
INSERT INTO tbx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ma, inye vati wei poropet Yoel neil o: ");
INSERT INTO tbx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“‘Anutu neil, “Eivek bouk loxyus, tyek a qapyex a xe Laweeng Vambuing lek xomaxoneing dalus. Xam neumim moux me xam neumim vex tyek baluk ambei poropet, de xam neumyeiw ghavis tyek mendghalus pekwi me gyei lul leimalei, de teivateiv wei xam o tyek gyei maviing. ");
INSERT INTO tbx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Eivek bouk tiyon eno tyek a qapyex a xe Laweeng Vambuing lek a xe xukxe moux alis vex dalus, me tyek xel a neil qayeeng ambei poropet. ");
INSERT INTO tbx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","De tyek a talex lul nelu nelu eivek tyoung gheyapu nei, me dee wei lulvako eno lek tembuing axone, gyand me nenyex me nenyex lu ngandoung tyek na tyip. ");
INSERT INTO tbx_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sayeiv tyek pekwi me bo mapetok de dentouk tyek bong ambei gyand natax en bouk ngandoung wei Tambiy Ngandoung nam is xeiyaing ngandoung me nikanzek wei e yo. ");
INSERT INTO tbx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Me xel dalus tiwei tyek taxe Tambiy Ngandoung lei yo eno tyek Anutu devind xel noum veil meyeing.”’ ");
INSERT INTO tbx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Xam xomaxoneing wei Israel o li nenyamim wou qayeeng tine, Yesu wei Nasaret on, Tambiy wei Anutu talex wou xam bei wong Yesu lak wou xam is lul nikanzek is dee wei lulvako yo wei xam ghe boulek bei Anutu wong e lam eivek xam senghoing eivek e maxow mema nambei ingwei xam ghe woulek o. ");
INSERT INTO tbx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yesu ne Anutu wou eivek xam memamim betiwou qes me ingwei wounalei en o pyap woy, eivek xel amba wei se mi betiwou qayeeng petieing o memend ekom xam ghe tuw e lek xax pepeeng me ghe leis e mey. ");
INSERT INTO tbx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ekom Anutu piyexe e qandi lek veil myavanei me tul e veil meyeing, en meyeing se teyeimbei zeimaxoun e. ");
INSERT INTO tbx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","De Dawit neil ambei nye lek e, “‘A xei Tambiy Ngandoung mindei paviy ay taxombouk, en moxo toundei wou a memang payeiv om tyek a se detek. ");
INSERT INTO tbx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nambei nyon a laleing mi wo nimza me a myang mi sanghoxe, me tyek a neing a mi mendei me na toung mang en inyon. ");
INSERT INTO tbx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","En tyek wa seng bong a nung na toumendei eivek beyeeng wei meyeing o, o tyek wa xe Tambiy Tiwei Vambuing eno se daxe pataleing. ");
INSERT INTO tbx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wang talex sakwaing wei a mi mendei mapieing eno wou ay me tyek wang bong xeilala e pup ay, wou wa mamghalus.’ ");
INSERT INTO tbx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Xam lingyeiw, a neil neing wou xam en xe bund Dawit bei moxo mey me e xe eeng toundei inye is xey me elam tyip gweimbeeng ne. ");
INSERT INTO tbx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Woyom tambiy on poropet ti om woulek ingwei Anutu neil neing is inya punei bei tyek bong e buyeiw ti mendei lek siaking wei e xe yo. ");
INSERT INTO tbx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Dawit yei tax me neil en qandieing wei Kilisi yo, de Anutu nalei se ma e me wong e toundei eivek leiveeng wei meyeing o, me tyek xel se gyei e neing on patal. ");
INSERT INTO tbx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesu tine Anutu piyexe e qandi lek me xa dalus a xei lek mami. ");
INSERT INTO tbx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","De woyom Yesu lek me la gheyapu woy me la dei wou Anutu mema payeiv me qou Laweeng Vambuing wou Ma, nambei ingwei neil zonghek o. Moxo qapyex tine lam me xam ghe di wei me ghe ngo yo. ");
INSERT INTO tbx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","En Dawit se lek me la eivek tyoung gheyapu, qe emaxow neil embei, “ ‘Tambiy Ngandoung neil wou a xe Tambiy Ngandoung, “Lam dei wou a memang payeiv. ");
INSERT INTO tbx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Deka a toung xel wei mi wo vevek wou wang eno na kwanghembi eivek wa vaxam bole.” ’ ");
INSERT INTO tbx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Nambei nyon xam xomexomek dalus wei Israel o ghe bongis bei Anutu wong Yesu tiwei xam ghe tuw lek xax pepeeng eno wo Tambiy Ngandoung me Kilisi.” ");
INSERT INTO tbx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Gyeik xel xomaxoneing ngo tine, xel laleind wo nimaying me neil wou Petele me sinaleyeiw bei, “Xam lingyeiw, tyek xa bong vati?” ");
INSERT INTO tbx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petele neil elox bei, “Xam dalus on titi pekwi xow me xel zipek xam en Yesu Kilisi lei, en tyek semaleeng xam xe nilul sapa veil, dom tyek Anutu bong Laweeng Vambuing wou xam nambei byeind wei xam o. ");
INSERT INTO tbx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Qayeeng wei neil zonghek ne eno inye wou xam me xam neumyeiw me inye wou xel dalus wei mindei dingta yo, me inye wou xel dalus wei Tambiy Ngandoung xe xe Anutu taxe yo.” ");
INSERT INTO tbx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petele peti xel en qayeeng ngenong. Me byexaxoun xel, “Xam a mi devind ama veil xel nilul wei bouk ti gweimbeeng ne.” ");
INSERT INTO tbx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Om xel wei mi lewexe lek e xe qayeeng me lipek eno teyei lek 3,000 eno tendulek xel lek bouk tiyon. ");
INSERT INTO tbx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Xel moux alis vex wo ninkanzek bei ngo sinaleyeiw xe teyoxeing me toung laleind lekti me wounaleind en Yesu eivek ingwei xel dembu belet o me zeimemend. ");
INSERT INTO tbx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Me sinaleyeiw wong lul nelu nelu ngenong me dee wei lulvako yo ngenong om xel dalus on etek. ");
INSERT INTO tbx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Xel dalus wei mi wongis Yesu eno mi dei is ama me wong lulul dalusateiv on is laleind tixemou. ");
INSERT INTO tbx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Xel mi wo vateivek lek tembuing me lulul wei xel xe yo, de mi wong wou xel wei lulul maeing o. ");
INSERT INTO tbx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Bouk tambak eno xel mi qekuma eivek tete lalei wei xomek vambuing wei qekueing ama yo. Xel mi dembu belet eivek xel xe xomek me ya lekti is laleind nimza me laleind vevopeing. ");
INSERT INTO tbx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xel mi sanghoxe Anutu me mi wo xeindlala en xomaxoneing sapa laleind mi wo nimza wou xel. Me bouk titi eno Tambiy Ngandoung qou xomaxoneing valu is no, me xel wongis e me tendulek xel bamba me xel wo ngenong. ");
INSERT INTO tbx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Bouk ti Petele luw Yoan la xomek vambuing, lek seivma wei zeimeing mema yo, lek soukeing wei seivma yal o. ");
INSERT INTO tbx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nanghei nyon eno moux wei vaxa wo nol eivek ta veis eno xel qalei e me la toung paviy xomek vambuing on mya wei xel mi taxe bei Nimza yo, xel toung e nanghei inyon me e mi teling xomaxoneing wei mi eivek la tete lalei wei xomek vambuing o en malew. ");
INSERT INTO tbx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tambiy on yei Petele luw Yoan embim na eivek tete lalei wei xomek vambuing o, om moxo teling luw bei luw bo malew ti wou e. ");
INSERT INTO tbx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ekom Petele luw Yoan domend wou e me neil, “Wei uw!” ");
INSERT INTO tbx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Om moxo yei luw, de e beiknge tyek na qou malew valu wou luw. ");
INSERT INTO tbx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Woyom Petele neil wou e, “A selewa o ghol wei ambei bong wou wang eno ma, ekom vati wei a xe eno tyek a bong wou wang. Lek Yesu Kilisi wei Nasaret o lei, a neil wou wang, qandi lek me la.” ");
INSERT INTO tbx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Om Petele zeim lek e mema payeiv me vind moxo nale gheyapu, lutika eno e vaxa qatu me vaxalambes wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Moxo vyeip me nale me ghavineeng eivek tete lalei wei xomek vambuing is luw, la ghavineeng me wo vyeip vyeip me sanghoxe Anutu lei. ");
INSERT INTO tbx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Xel xomaxoneing dalus yei ingwei moxo di ghavineeng me sanghoxe Anutu lei yo. ");
INSERT INTO tbx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Xel woulek bei inyon tambiy kawei mindei wou xomek vambuing mya wei xel mi taxe bei Nimza yo, me mi teling lulul wou xel, om xomaxoneing dalus on etek niseikeing en ingwei moxo wo nimzalek o. ");
INSERT INTO tbx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Moxo zeimaxoun Petele luw Yoan omva, xomaxoneing sapa nun la me etek dom tup me la wou lal lek xomek palanda wei xel mi taxe bei palanda wei Salomo yo. ");
INSERT INTO tbx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ekom Petele yei ingwei xel qeku lam o, om neil wou xel bei, “Xam lingyeiw Israel, xam ghe etek enva? Me xam ghe domamim wou uw enva? Beip uw a wong tambiy ne wo nimzalek angya nikanzek wei uw maxow o, o nangya ingwei uw a mindei nimza wou Anutu manghalus o? ");
INSERT INTO tbx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Anutu wei Apraham me Isaka me Yakop o, inye Anutu wei xe mendyeiw me bundyeiw eno wong e xe xukxe Yesu lei wo ngandoung, inyon tambiy tiwei xam ghe pesek me ghe toung e eivek Pailat mema bei xel nyeis e mey, gyeik Pailat embei bong ena bandaing o. ");
INSERT INTO tbx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ekom xam ghe pesek xomaxoneing wei Vambuing me Bombek ayang o, dom ghe teling Pailat en tambiy wei mi leis xel mey o bei embong e noum wou xam. ");
INSERT INTO tbx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Dom xam ghe leis tambiy wei mapieing lukes, ekom Anutu piyexe e qandi lek veil meyeing. De xa maxow a xei tine lek mami. ");
INSERT INTO tbx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Moux tine tiwei xam ghe wei me ghe woulek eno wo nimzalek nangya e xe wongeingis lek Yesu lei. Om tambiy tiyon wongis Yesu lei me wong e wo nimzalek, nambei xam dalus ghe wei yon. ");
INSERT INTO tbx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Gweimbeeng, xam lingyeiw, a woulek inyon bei xam seng woulek om xam ghe wong tiyon, nambei kwa wei xam xe xel gyovaxa yo. ");
INSERT INTO tbx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ekom lulti beimambei yon, Anutu neil atax eivek xel poropet dalus myend, bei e xe Kilisi, tyek na qou myavanei, om wo neing lek eivek sakwaing wei xam ghe wong on. ");
INSERT INTO tbx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Woyom xam pekwi xow, de pekwi me ghe nox wou Anutu, en kandek Anutu e semaleeng xam xe sewokeing veil, dom Tambiy Ngandoung tyek bong nikanzek vako wou xam, ");
INSERT INTO tbx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","me inyon tyek Anutu bong Kilisi, tiwei e beyal wou xam o nam, inyon Yesu. ");
INSERT INTO tbx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Moxo mindei eivek tyoung gheyapu deka bouk wei Anutu embei bong lul dalus bo vako eno nam le, nambei e neil zonghek eivek mya; is e xe xel poropet vambuing atax o. ");
INSERT INTO tbx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","En Mose neil, ‘Xam xe Tambiy Ngandoung Anutu tyek beyal xam xe poropet ti nambei ay, eivek xam venaxow limyeiw senghoing, xam a ngo lul tambak wei embei neil wou xam o. ");
INSERT INTO tbx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Xelti embei se ngo e, eno tyek semaleeng e veil e xe xel xomaxoneing.’ ");
INSERT INTO tbx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Nambei nyon, xel poropet dalus eivek bouk wei Samuel me e lam eno xel ngenongakes luk, me eti yeiw wei lam yus eno luk me neil qayeeng en bouk wei di lam gweimbeeng ne yo. ");
INSERT INTO tbx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Me xam on poropet neuyeiw, me xam on ingwei Anutu qokatu is xam bumimyeiw o. E neil wou Apraham, ‘Eivek wa neumambum xomaxoneing lek tembuing sapa tyek na qou mata.’ ");
INSERT INTO tbx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Woyom Anutu piyexe e xe xukxe qandi lek, de wong moxo lak atax wou xam, bei bong mata wou xam me pekwi xam titi veil xam xe sakwaing wei nilul o.” ");
INSERT INTO tbx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Luw di neil xoulek wou xomaxoneing bembeeng on, de lumukiyeiw is beyeiv wei mi yeiteyei xomek vambuing o, me xel Sadyusi xel xouing lam wou Petele luw Yoan gyeik luw di neil qayeeng wou xel xomaxoneing on. ");
INSERT INTO tbx_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Xel laleind wo vanei ngandoung wou luw en xel woulek bei luw di teyoxe xomaxoneing sapa yon en ingwei Yesu qandi lek veil meyeing o. ");
INSERT INTO tbx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Xel zeimaxoun Petele luw Yoan bei na toung luw na eivek xeitueing deka yanyeing le, en inye souk. ");
INSERT INTO tbx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ekom xel ngenong wei ngo xoulek eno wongis. Me xel moux nyouk teyei lek ambei 5,000. ");
INSERT INTO tbx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","De yanyeing eno xel leitata me teivateiv me xel putoung wei petieing o qekuma nanghei Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas lumuki lukanzek toundei inyon is Kaiapas, me Yoan, me Aleksanda me xel moux valu wei lumuki lukanzek nipapu eno is. ");
INSERT INTO tbx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Om xel qou Petele luw Yoan me lam lax luw wou xel mendghalus dom teling wou luw bei, “Eivek nikanzek vati, me eivek eti lei eno muw ghe wong lulti beimambei yon nangya?” ");
INSERT INTO tbx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Woyom Laweeng Vambuing pupexe Petele, om neil wou xel, “Xam leitata me teivateiv wei xel xomaxoneing o, ");
INSERT INTO tbx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","beip xam ambei teling uw en tambiy tiwei uw a wong e vaxa wo nimzalek o, me xam ambei teling bei, e vaxa wo nimza lek ambei nya. ");
INSERT INTO tbx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Woyom xam ghe bouk lek qayeeng tine, xam me xomaxoneing sapa wei Israel o dalus ghe boulek bei, eivek Yesu Kilisi wei Nasaret o lei, tambiy tiwei vaxa wo nol ne eno wo nimza lek me nale wou xam mamim. Xam ghe tuw Yesu lek xax pepeeng. Ekom Anutu piyexe e qandi lek veil meyeing. ");
INSERT INTO tbx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu yon “‘qakous tiwei xam kamunda ghe pesek, eno wong ambei qakous lukanzek wei mi byexaxoun xomek o.’ ");
INSERT INTO tbx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tambiy ti se teyeimbei devind xey veil meyeing qe Yesu venaxow, en, eivek tyoung gheyapu xeinghembi eno Anutu se neil lei bange wei xelti yo teyei bei devind xey a noum veil meyeing.” ");
INSERT INTO tbx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Xel teivateiv on yei Petele luw Yoan luk is nikanzek de se yaleeng, om xel woulek inyon bei luw xouing se wevek xomek qapiya, luw on moux bandaing, xel etek me wou kwend bei yuw on mi la is Yesu. ");
INSERT INTO tbx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","De xel yei tambiy tiwei luw wong e wo nimzalek o toungale inyon is luw, om xel se teyeimbei neil qayeeng ti nox wou luw. ");
INSERT INTO tbx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Om xel neil wou luw bei luw na veil xomek kanzol, luw la veil de woyom xel luk wouma. ");
INSERT INTO tbx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Xel teling, “Tyek xey a bong vati wou moux yuw ne? En xel sapa wei toundei eivek Yerusalem ne eno woulek bei luw wong xuk dee ne inye nimza, om xe se teyeimbei daxvun. ");
INSERT INTO tbx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ekom tyek xey a peti luw en luw se neil qayeeng tine na bo sapa wou xomaxoneing en lei tine no.” ");
INSERT INTO tbx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Woyom xel lox me la taxe luw me luk nikanzek wou luw bei luw se baluk o teyoxe xomaxoneing en Yesu lei no. ");
INSERT INTO tbx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ekom Petele luw Yoan neil elox bei, “Xam teling ama, beip inye nimza wou Anutu manghalus bei xa betiwou xam de se Anutu? ");
INSERT INTO tbx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ekom uw se teyeimbei tip lukeing en lul sapa wei uw a xei me na ngo woy yo.” ");
INSERT INTO tbx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Xel kanzol on neil qayeeng nikanzek valu no wou luw dom wong luw la, de xel se wo nimaying ti wou luw, en nambei xomaxoneing sapa yon di sanghoxe Anutu lei en vati wei belup on. ");
INSERT INTO tbx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","En tambiy tiwei luw wong e wo nimzalek eno xe vakovek qes ghanaw xoumeeng vey (40). ");
INSERT INTO tbx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Xel kanzol tul Petele luw Yoan woy, woyom luw lox wou luw maxow xe xomaxoneing, me neil qayeeng dalus wei xel lumuki leitata me teivateiv neil wou luw o. ");
INSERT INTO tbx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Xel ngo qayeeng tine woy, xel xouing toung laleind lekti eivek zeimeing mema wou Anutu. Xel neil, “Tambiy Ngandoung nikanzekta, wang toung tyoung me tembuing me mamileeng, me lulul sapa wei toundei eivek o. ");
INSERT INTO tbx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Myaxeeng eno wang luk eivek xa mami Dawit, wa xe xukxe mya nangya Laweeng Vambuing bei: “ ‘Nambei nya xomaxoneing sapa laleind wo myavanei, xomaxoneing beimambei ne tup qayeeng bandaing bei bong kwa nilul enva? ");
INSERT INTO tbx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Xel king wei tembuing eno yeiwou xow en embei bo vevek. Me xel gyovaxa qekuma en xel embei bo vevek wou Tambiy Ngandoung me embei bo vevek wou Kilisi is.’ ");
INSERT INTO tbx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Xa woulek bei vati wei wang neil atax takwei eno wo neing lek zonghek. En Herot aluw Pontias Pailat qeku is xel ba me xel wei Israel, eivek beyeeng ngandoung bei bong nimaying wou Yesu, wa xe xukxe vambuing tiwei wang beyal o. ");
INSERT INTO tbx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Gyeik xel wong lul tine, xel betiwou kwa me wamaxow laleim en nikanzek wei wang o. Takwei eno wang tup qayeeng atax bei lulti beimambei ne eno neing a tyip. ");
INSERT INTO tbx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Gweimbeeng, Tambiy Ngandoung wa bounaleim en xel xe qayeeng wei xel neil me wo yalenyeing wou xa yo, de wa devind xa wei wa xe xukxe yo, bei xa neil wa xe xoulek is nikanzek dom xa se ghaleeng. ");
INSERT INTO tbx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","De wa ni memam na lek xel wei vanei yo en xel bo nimzalek me wang bong dee wei lulvako yo eivek wa xe xukxe vambuing Yesu lei.” ");
INSERT INTO tbx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ka xel zeimemend woy, beyeeng kawei xel di qekuma lek on wo pimapi. Me xel dalus pup en Laweeng Vambuing me neil Anutu xe xoulek nikanzek, dom xel se yaleeng. ");
INSERT INTO tbx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Xel wongeingis laleind me lundpeyei eno la tixemou, xelti se neil embei lulti yon inyon emaxow xe, qe xel vind ama en lulul dalus wei xel xe yo. ");
INSERT INTO tbx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sinaleyeiw di tetulexe qayeeng neileing en ingwei Tambiy Ngandoung Yesu qandi lek o is nikanzek ngandoung me Anutu xe lalei xeiles wei ghanaw veil eno toundei is xel. ");
INSERT INTO tbx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Inyon xel wei kanyo eno ti se toundei eivek xel senghoing, en eivek bouk titi xel eti yeiw wei xe tembuing, o xomek eno wo vateivek lek, me qou malew lek, ");
INSERT INTO tbx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","de toung ela wou sinaleyeiw vaxend, me xel pum malew on wou xel wei lulul maeing o. ");
INSERT INTO tbx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yosep, wei Livai nanghei Saiprus, xel sinale mi taxe e lei nge bei Banabas (qes ambei nye bei tambiy wei mi vind xomaxoneing en qayeeng nimza yo) ");
INSERT INTO tbx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","eno wong vateivek lek e xe tembuing de qou malew me toung ela wou sinaleyeiw. ");
INSERT INTO tbx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Tambiy ti lei Ananias, de venei lei Sapira, luw wong vateivek lek tembuing wei luw eno danghei ti me tambiy nge xouv, ");
INSERT INTO tbx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","De venei woulek is ambei nyon om luw toung malew veweeng wou lumaxow, dom veweeng dalus eno luw qou me la toung wou xel sinale. ");
INSERT INTO tbx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Woyom Petele neil, “Ananias, nambei nya ekom wang wong Sandang pup wa laleim lek, me wang tyoxe Laweeng Vambuing, de ghe toung malew valu wou xow wei wang qou lek tembuing o? ");
INSERT INTO tbx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Myaxeeng wei wa seng ghei wo vateivek lek tembuing on, eno inyon wa xe zonghek. Deka wang wo vateivek lek, eno malew on inye wa xe. Om wang wou eivek naleim en kwa nilul on enva? Wa seng tyoxe xomaxoneing venaxow qe wang tyoxe Anutu is.” ");
INSERT INTO tbx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias ngo qayeeng tine eno moxo teibouyek lek tembuing de mey. Me xel dalus wei ngo qayeeng ne eno yaleeng ngandoung mouyo. ");
INSERT INTO tbx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Woyom xel moux wei ghavis eno lam me beliv e neing eivek qaeing, de xel qalei e neing on me la ev. ");
INSERT INTO tbx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Seivma yal lak veil, Ananias venei lam lalei, ekom vexo se woulek vati wei belup wou leya yo. ");
INSERT INTO tbx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Om Petele teling wou e, “Neil wou ay bei malew wei muw ghe qou lek tembuing eno dalus inye?” Vexo neil, “Ee, malew dalus inyon.” ");
INSERT INTO tbx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Petele neil wou vexo, “Nambei nya muw leyam ghe tyoxe Tambiy Ngandoung xe Laweeng? Wei! Xel moux wei qalei leyam me la ev eno vaxend toungale wou xomek mya yon, om tyek xel qalei wang me na myayaing is ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Lutika eno vexo teibouyek lek tembuing wou Petele vaxa dom mey. Woyom xel ghavis lam lalei me yei bei vexo mey, om xel qalei e me la myayaing me la ev e paviy leya. ");
INSERT INTO tbx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Om xel wongeingis dalus me xel amba dalus wei ngo qayeeng en vati wei belup on eno xel yaleeng ngandoung. ");
INSERT INTO tbx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sinaleyeiw wong lulvako me dee ngenong eivek xel xomaxoneing senghoing. Me xel wongeingis dalus mi toung laleind lekti me qekuma eivek xomek palanda wei xel mi taxe bei palanda wei Salomo mi dei lek o. ");
INSERT INTO tbx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Xel bamba wei se ghei wongis Yesu eno yaleeng bei se na mindei is xel wei wongis o. Ekom xel ngenong mi sanghoxe xel wei wongis o nambei xel on nimza. ");
INSERT INTO tbx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Dekalekom moux alis vex ngenong wongis Tambiy Ngandoung me lam tendulek xel wei wongis o me xel wo ngenong. ");
INSERT INTO tbx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Sinaleyeiw di wong lulvako nimza, om xomaxoneing mi qalei liyeiw wei wo vanei me la eivek sakwaing mema nayak o me liw xel lek lelek me ghus en kandek Petele nak ond e tenu liw la lek xel. ");
INSERT INTO tbx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Xel qendu ngandoung wei mi qekuma eno lam anghei beyeeng wei vivekwou Yerusalem o, me mi qou xel xe xel wei vanei me eti yeiw wei laweeng nol wo nol wou xel, eno dalus wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Woyom lumuki lukanzek me e xe xel dalus wei mi la lekti, xel on inyon Sadyusi, eno laleind mi wo nilul wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Xel zeimaxoun sinaleyeiw me toung xel eivek xeitueing wei beyeeng o. ");
INSERT INTO tbx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ekom eivek boukeing eno angela wei Tambiy Ngandoung xe yo tax xomek mya wei xeitueing o, dom qou xel me la myayaing. ");
INSERT INTO tbx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Moxo neil, “Xam la, nale eivek tete lalei wei xomek vambuing wei qekueing ama yo me neil wou xomaxoneing en qayeeng dalus en mapieing vako tine.” ");
INSERT INTO tbx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Xel ngo inye woy, de yanyeing eno xel eivek la tete lalei wei xomek vambuing wei qekueing ama yo, me teyoxe qayeeng wou xomaxoneing. De xel lumuki lukanzek me e xe xel lam tyip, xel taxe xel kanzol, me xel leitata wei Israel o lam qekuma, me wong xel la xomek xeitueing bei na qou sinaleyeiw me nam. ");
INSERT INTO tbx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Xel belimbo la tyip xomek xeitueing ekom xel se yei xel sinale. Om xel lox me la neil wou teivateiv bei, ");
INSERT INTO tbx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Xa xei xomek xeitueing mya ekom xel toung zeyi, de xel belimbo toungale wou xomek mya. Ekom gyeik ingwei xa tax qapomb eno xa se xei xelti eivek xomek lalei.” ");
INSERT INTO tbx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Woyom beyeiv wei mi yeiteyei xomek vambuing me xel lumuki leitata ngo qayeeng tine eno etek, me wounaleind ngenong bei lul tine nambei nya? ");
INSERT INTO tbx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Woyom tambiy ti lam me neil, “Wei! Xel moux wei xam ghe toung eivek xomek xeitueing eno toungale eivek tete lalei wei xomek vambuing wei ngoeing qayeeng o me di teyoxe xomaxoneing.” ");
INSERT INTO tbx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Om beyeiv tiyon la is xel belimbo me qou sinaleyeiw. Xel se wo lulti wou xel, en nambei xel yaleeng en xel xomaxoneing on tyek banex xel angya qakous. ");
INSERT INTO tbx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Om xel la qou sinaleyeiw, me la lax xel wou xel kanzol mendghalus, bei lumuki lukanzek teling xel. ");
INSERT INTO tbx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","E neil, “Xa wong qayeeng petieing nikanzek wou xam bei, xam se teyoxe xel lek lei tine, ekom xam ghe wong beyeeng Yerusalem ne pup en xam xe teyoxeing me ghe di byex qayeeng lek xa bei xa leis e mey.” ");
INSERT INTO tbx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petele is sinale bamba neil elox wou xel bei, “Tyek xa betiwou Anutu de se xomaxoneing! ");
INSERT INTO tbx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Xam ghe teyu Yesu lek xax pepeeng me ghe leis e mey. Ekom Anutu wei xe bundyeiw eno piyexe Yesu veil meyeing, ");
INSERT INTO tbx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","me toung e la dei wou emaxow mema payeiv, nambei gyovaxa me Tambiy wei vind xey veil nilul o. E wong ambei nye en kandek xel Israel pekwi xow veil nilul de e semaleeng xel xe sewokeing. ");
INSERT INTO tbx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Xa xei mami wou lulti beimambei ne dalus woy, me Laweeng Vambuing byexaxoun qayeeng ne is ambei nyon bei lul beimambei ne neing ayang, wei Anutu wong wou xel wei mi betiwou e yo.” ");
INSERT INTO tbx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Xel kanzol ngo qayeeng tine eno xel laleind wo vanei ngandoung om xel embei nyeis xel amey. ");
INSERT INTO tbx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ekom Parisi ti lei Gameliel, Putoung wei petieing o, wei xomaxoneing mi sanghoxe e lei yo, eno nale gheyapu wou xel kanzol dalus mendghalus me wong qayeeng nikanzek bei xel a qou sinaleyeiw me na myayaing nayaka le. ");
INSERT INTO tbx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Woyom moxo neil qayeeng wou xel, “Xam moux wei Israel, xam ghe bounaleim bo nimza en vati wei xam ambeing bong wou xel moux ti beimambei ne yo. ");
INSERT INTO tbx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Bouk valu la tax veil ekom Teudas lam tyip, me neil embei e lei ngandoung, me moux 400 eno mi betiwou e. Eno xel seyap leis e mey, de e xe xel betiyeing pek, om xuk dalus on wong ambei lul bandaing. ");
INSERT INTO tbx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ka bouk wei seyap qou xel xomaxoneing leind, Yudas wei Galili eno dandiy xomaxoneing ngenong la wou xow. E is ambei nyon xel leis e mey, de e xe xel dalus pek me vu ama lala. ");
INSERT INTO tbx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nambei nyon, gweimbeeng a neil wou xam, xam memamim tena xel moux beimambei ne na! En wangwei xel xe xuk wei xel di wong ne inye xomaxoneing xe, on tyek neing ama veil. ");
INSERT INTO tbx_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ek wangwei inye lam wou Anutu, on xam seng teyeimbei bale zeyi xel moux beimambei ne, tyek xam venaxow gwei bei xam ghe di wo vevek is Anutu.” ");
INSERT INTO tbx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Xel ngo Gameliel xe qayeeng me lewexe lek. Om xel kanzol taxe sinaleyeiw la lalei me wong beyeiv sesa xel. Woyom xel luk nikanzek wou xel bei, “xam seng nox a neil qayeeng lek Yesu lei no,” dom wong xel la. ");
INSERT INTO tbx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Xel sinale ghanaw xel kanzol, me wong xeindlala en Anutu wounalei bei xel ne nimza teyei bei qou niyalenyeing en Yesu lei. ");
INSERT INTO tbx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Teyei lek bouk sapa, xel mi la tete lalei wei xomek vambuing me xomek titi wei xomaxoneing o me teyoxe xel, de xel se tip neileing xoulek Nimza. Ma. Xel neil teyei bei Yesu yon Kilisi. ");
INSERT INTO tbx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Eivek bouk ti beimambei yon eno xel betiyeing di nyouk, xel Yuda valu wei mi luk Grik vyend eno wo veweeng is xel Yuda wei mi luk Hibru yo. Me neil embei xel Yudayeiw mi pum yaeing wou kanyo yeiw de xel se mi vind xa xe vexeiv wei Grik o en yaeing teyei lek bouk. ");
INSERT INTO tbx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Om xel sinale xoumeeng yuw qeku xel betiyeing dalus lekti me neil, “Inye se teyei lek bei xa saing Anutu xe xoulek neileing de na bo xuk lek pumeing lul yaeing. ");
INSERT INTO tbx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Xam lingyeiw, xam beyal moux lim yuw eivek xam senghoing on wei xam ghe woulek bei Laweeng Vambuing pup xel me xel lundpeyei nimza yo. Tyek xa bong xuk tine e nox mena wou xel, ");
INSERT INTO tbx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","de tyek xa bale ding lek zeimeing mema me xuk wei neileing Anutu xe xoulek o.” ");
INSERT INTO tbx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Qayeeng tine wong moux alis vex dalus laleind wo nimza, om xel beyal Setepan, moux wei pup en wongeingis me en Laweeng Vambuing, me Pilip, Plokolas, Nikanor, Timon, Palmenas, me Nikolas nanghei Antiok, wei mi betiwou qayeeng wei Yudayeiw o. ");
INSERT INTO tbx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Xel qou xel moux ti beimambei ne me la wou xel sinale, me xel zeimemend wou xel de liw memend lek xel. ");
INSERT INTO tbx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Om xoulek wei Anutu xe eno la wo sapa. Xomaxoneing ngenong wei Yerusalem eno wong ambei betiyeing me nyouk daing, me lumukiyeiw valu beti eno wongis ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Gweimbeeng Setepan on moux wei pup en Anutu xe lalei xeiles me nikanzek, me mi wong dee wei lulvako ngenong eno eivek xomaxoneing senghoing. ");
INSERT INTO tbx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ekom xomaxoneing valu qandi me wong veweeng is Setepan. Xel on anghei xomek qekueing ama wei xel taxe bei tul e la. Xel on nanghei Yuda eno lam anghei Sairini me Aleksandlia me lam anghei provins wei Silisia me Esia. ");
INSERT INTO tbx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ekom xel se teyeimbei bale zeyi e lupeyei me Laweeng Vambuing wei di luk angya yo. ");
INSERT INTO tbx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Woyom xel xupek me zeim xel valu laleind lek me neil embei, “Xa ngo Setepan lukyak lek Mose me Anutu.” ");
INSERT INTO tbx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Om xel zeim xomaxoneing laleind lek me teivateiv me putoung wei petieing o. Om xel zeimaxoun Setepan me qou e me la wou xel kanzol. ");
INSERT INTO tbx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Xel beyal xel valu bei xel a byex qayeeng tyonyeing lek Setepan me neil ambei nye, “Taxombouk eno tambiy ne se mi tip lukeing nilul lek xomek vambuing tine me e xe qayeeng petieing. ");
INSERT INTO tbx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","En xa ngo e neil tiyon bei, ‘Yesu wei Nasaret o tyek lelolexe xomek vambuing tine me pelipek sakwaing wei Mose wong wou xey yo.’” ");
INSERT INTO tbx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Xel dalus tiwei toundei eivek kanzol beeng eno domend wou Setepan, me xel yei e ma yon siing ambei angela ti manghalus. ");
INSERT INTO tbx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Woyom lumuki lukanzek teling wou e, “Qayeeng tiwei xel neil lek wang ne inye zonghek?” ");
INSERT INTO tbx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Om moxo neil elox, “Xam lingyeiw me xam mangyeiw, xam ngo wou a le! Xeiyaing wei Anutu xe eno lam tyip wou xe mend Apraham gyeik nanghei toundei eivek Mesopotamia, myaxeeng atax en ingwei mindei eivek Haran o. ");
INSERT INTO tbx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Anutu neil wou e, ‘Wang na veil bam me nimpapu, dom ghe na tembuing tiwei tyek a talex wou wang o.’ ");
INSERT INTO tbx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Om Apraham moxo ghanaw tembuing wei Kaldia me la dei eivek Haran. Ka bouk wei Apraham ma mey yo, Anutu wong e la tembuing tiwei xam ghe toundei lek gweimbeeng ne. ");
INSERT INTO tbx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Anutu se wong tembuing ti wou Apraham nanghei inye, me se wong tembuing ti bombek wou e. Qe Anutu neil qayeeng atax wou moxo bei e me e neumambu wei loxyus en e yo tyek na qou nind tembuing kayon, gyeik Apraham neu nanghei ma yo. ");
INSERT INTO tbx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Anutu luk wou Apraham eivek sakwaing tine: Wa neumambum tyek bong ambei xel ba eivek beyeeng wei se xel venaxow xe yo, me tyek xel bo pok ngandoung me xel on tyek bo nilul wou xel teyei lek vakovek qes 400. ");
INSERT INTO tbx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Anutu neil, tyek a bong myaveweeng wou tembuing tiwei mi wo pok ngandoung wou xel o, dekalekom tyek xel nam myayaing veil beyeeng tiyon me bong lalo wou ay eivek beyeeng tine. ");
INSERT INTO tbx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Woyom Anutu wong qokatu wei ghuweing ninavi yo. Me Apraham on Isaka ma gyeik xel ghuw e ninavi lek bouk lim yal o. Me Isaka yon Yakop ma, de Yakop on neuyeiw xoumeeng yuw mend wei xel wo lukanzek en velei xoumeeng yuw o. ");
INSERT INTO tbx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Yakop neuyeiw wei wo lukanzek en velei xoumeeng yuw on laleind wo vanei wou Yosep, om xel wo vateivek lek e wou xel amba, en xuk bandaing eivek Izip. Ekom Anutu vena mindei is e ");
INSERT INTO tbx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","me mi zeim e veil e xe nimaying dalus. De wong lupeyei nimza wou e om king Parao wei Izip o lalei vind Yosep. Om wong Yosep yeiteyei Izip me e xe lulul dalus wei e beeng o. ");
INSERT INTO tbx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Woyom maxep ngandoung ti yeip lek beyeeng Izip dalus me Kenan, om nimaying ngandoung lam wou xomaxoneing, me xe bundyeiw se teyeimbei gyeiwou yaeing ti. ");
INSERT INTO tbx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Om gyeik Yakop ngo bei yaeing toundei eivek beyeeng Izip, moxo wong xe bundyeiw la Izip ti myaxeeng. ");
INSERT INTO tbx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Xel lox me la luyuw, eno Yosep neil xow teyei wou liyeiw, me Parao woulek Yosep liyeiw is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Om Yosep wong qayeeng la wou ma Yakop me e neumambu dalus bei xel nam wou e, xel xouing teyei lek 75. ");
INSERT INTO tbx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Woyom Yakop la xo wei Izip nei, dekakom e me xe mend a bund eno xel xouing mey anghei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xel qou neing wei xel xe meyeing me lox Sekem me toung xel eivek leiveeng meyeing wei Apraham xouv wou Hamor neuyeiw anghei Sekem en malew valu yo. ");
INSERT INTO tbx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Nambei bouk di lam paviy ingwei Anutu embei bong e xe qayeeng zonghek wei mi neil wou Apraham eno embo neing lek, de xel xomaxoneing Israel vamva wei mi dei eivek Izip eno di nyouk. ");
INSERT INTO tbx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Woyom king nge, wei se woulek Yosep, eno yeiteyei Izip. ");
INSERT INTO tbx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","King tiyon mi yei xe xe xomaxoneing wo nilul me mi tyoxe xe bundyeiw me wong nilul wou xel, me mi tendu xel bei xel banex neuyeiw wei yakyeis eno na myayaing en kandek xel amey. ");
INSERT INTO tbx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Lek bouk kayon eno Mose umbek, me Mose yon yakyeis nimza ka wou Anutu manghalus. Moxo mindei eivek ma beeng teyei lek dentouk qes yal. ");
INSERT INTO tbx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Om gyeik xel toung e la myayaing, Parao neu vex zeim e me qou me yeiteyei nambei emaxow neu moux. ");
INSERT INTO tbx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Mose wevek xomek qapiya me qou kwa nimza dalus wei Izip o, me e tambiy wei mi luk nikanzek me mi wo xuk leimalei yon wo nikanzek. ");
INSERT INTO tbx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Gyeik Mose xe vakovek qes xoumeeng vey (40), moxo wou kwa bei embei na gyei liyeiw wei Israel o. ");
INSERT INTO tbx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Moxo yei Izip ti di leis Israel ti, om Mose la vind li Israel on me qou e lu me leis Izip tiyon mey. ");
INSERT INTO tbx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mose wou kwa bei inyon emaxow xe xel Israel tyek boulek inyon bei Anutu wong e lam bei e devind xel, ekom xel se woulek. ");
INSERT INTO tbx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","De yanyeing eno Mose lam me yei Israel yayuw di leis ama. Moxo wong en embei bale zeyi luw me neil, ‘Inyon muw limim ama yo, nambei nya muw ghe leis ama?’ ");
INSERT INTO tbx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Ekom xomaxoneing nge wei wo vevek atax eno tendu Mose la nenya de neil, ‘Eti beyal wang me wong wang wo gyovaxa me tambiy wei ngoeing qayeeng wei xa yo. ");
INSERT INTO tbx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Wa being nyeis a mey nambei ingwei wang leis Izip ti mey vezeiveeng o?’ ");
INSERT INTO tbx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Gyeik Mose ngo qayeeng tine, moxo pek me la Midian, me la dei inyon ambei tambiy ba me wo neu moux yuw. ");
INSERT INTO tbx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ka vakovek qes xoumeeng vey (40) la veil, woyom angela ti tyip wou Mose eivek nenyex magyand wei tum lek xax mema eivek tembuing bandaing paviy lukendu Sinai yo. ");
INSERT INTO tbx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Gyeik Mose yei tine, moxo etek me dula paviy en embei gyei embo nimza, moxo ngo Tambiy Ngandoung vya neil ambei nye, ");
INSERT INTO tbx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘A Anutu wei wa bumyeiw o, Anutu wei Apraham, Isaka me Yakop o.’ Mose etek is yalenyeing me embei se gyei. ");
INSERT INTO tbx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Woyom Tambiy Ngandoung neil wo e, kwax wa xe vaxalambes on veil, en beyeeng kawei wang toungale lek on inye tembuing vambuing. ");
INSERT INTO tbx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","A xei kwa nilul wei xel wong wou a xe xel xomaxoneing eivek Izip o woy. A ngo xel xe engeing, om a lam bei na qou xel noum veil nimaying. Om lam kane, en tyek a bong wang nox me na Izip. ");
INSERT INTO tbx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Mose tine kawei xel pesek e me neil, eti beyal wang en gyovaxa me tambiy wei ngoeing qayeeng wei xa yo? Mose moxo Anutu wong ela bei e gyeiteyei xel me na qou xel angya angela mema wei tyip wou e lek xax nayak o. ");
INSERT INTO tbx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mose tine qou xel me lam veil Izip me wong dee me lulvako eivek Izip, me nanghei Mamileeng Gyand me ela eivek tembuing bandaing on teyei lek vakovek qes xoumeeng vey (40). ");
INSERT INTO tbx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Mose kayon tiwei neil wou Israelyeiw bei, ‘Anutu tyek bong poropet ti nambei ay eivek xam venaxow xe xomaxoneing.’ ");
INSERT INTO tbx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mose tine dei eivek qekueing ama yon eivek tembuing bandaing is xe bundyeiw, me is angela tiwei luk is Mose lek lukendu Sinai yo is xe bundyeiw, me moxo qou qayeeng mapieing me lam bei e nam bong wou xey. ");
INSERT INTO tbx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ekom xe bundyeiw pyalek en xel embei se betiwou e. Qe xel pesek e me eivek xel xe woueing nalei bei xel embei nox me na Izip. ");
INSERT INTO tbx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Om xel neil wou Aron, ‘Wa menyex anutuyeiw en xel natax en xa. En nambei Mose tine eno la tax en xa me lam myayaing veil Izip eno xa loungen bei vati wong e!’ ");
INSERT INTO tbx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Bouk tiyon eno xel betiy manghaxo neu ti tenu. De xel qou lul leimalei me wong ela wou nambei xound me wong xeindlala ngandoung me sanghoxe lul wei xel wong angya memend o. ");
INSERT INTO tbx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ekom Anutu toung demi wou xel me pelipek xel laleind eivek bei xel bong lalo wou sayeiv, dentouk me betum teyei lek qayeeng wei poropet byex eivek qapiya yo: “Xam xomek wei Israel o, beip xam ghe toung xound me da wou ay teyei lek vakovek qes xoumeeng vey (40) wei xam ghe mindei eivek tembuing bandaing o, ei? ");
INSERT INTO tbx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Xam ghe qalei xomek wei Molek me betum wei xam xe anutu Lepan tenu bandaing wei xam ghe betiy bei na mi bo lalo wou yo. Nambei nyon tyek a bong xam ghe na eivek beyeeng tiwei yeip Babilon valu lox nei. ");
INSERT INTO tbx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Lek bouk wei xe bundyeiw dei eivek tembuing bandaing eno xel qalei xomek sel wei Anutu xe qoupek wei petieing mi yeip eivek eno is xel. Xomek tiwei xel lax ne eno Anutu neil wou Mose bei xel balax teyei lek tenu wei talex wou Mose yo. ");
INSERT INTO tbx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kalekom xe bundyeiw is Yosua qou xomek sel me qoupek wei petieing o me lam bei na qou tembuing wei xel amba xe yo. Anutu tiy xel la veil, dom lax xomek sel ne lek tembuing on me elam tyip wou bouk wei Dawit o. ");
INSERT INTO tbx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Dawit tiwei Anutu lalei wo nimza wou e eno teling wou Anutu bei dev xomek nimza ti wou Anutu wei Yakop o. ");
INSERT INTO tbx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Dekakom Salomo ev Anutu xe xomek tiyon. ");
INSERT INTO tbx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Ekom Anutu wei tyoung gheyapu nei se mindei eivek xomek wei xomaxoneing ev o. Nambei poropet neil, ");
INSERT INTO tbx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“‘Tambiy Ngandoung neil, “Tyoung gheyapu yon a xe siaking, me tembuing on a xe zek wei a mi lax vaxang lek o. Om tyek xam ghe dev xomek vati wou ay? O beyeeng wei ambei qou laweeng eno yeip inya? ");
INSERT INTO tbx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Beip a memang se toung lulul dalus ti beimambei ne?”’ ");
INSERT INTO tbx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Xam xomaxoneing on lumimpeyei nikanzek me xam laleimim on wo mapetok me xam nenyamim on wo qatu. Me xam ghe teyei lek bumyeiw, me ghe mi pyalek Laweeng Vambuing. ");
INSERT INTO tbx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Poropet eti eno xam bumyeiw se mi wo nilul wou e? Xel leis xel xomaxoneing wei mi neil Tambiy Ti Bombek o teyei, wei e bei nam o. Me gweimbeeng xam ghe neil e teyei de ghe leis e mey. ");
INSERT INTO tbx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Xam on ghe qou petieing wou angela, ekom xam seng betiwou.” ");
INSERT INTO tbx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Gyeik xel ngo qayeeng tine, xel laleind wo vanei ngandoung wou e, me nga vind wou e. ");
INSERT INTO tbx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ekom Laweeng Vambuing pup Setepan, om yeila tyoung gheyapu nei me yei xeiyaing wei Anutu yo, me yei Yesu toungale wou Anutu mema payeiv. ");
INSERT INTO tbx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","De moxo neil, “Wei, a xei tyoung gheyapu tax me Xomaxoneing Neu Moux toungale wou Anutu mema payeiv.” ");
INSERT INTO tbx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ka xel ngo tine xel sevun nenyend de ghak niseikeing, en xel embei se ngo e vya, xel xouing qapyex me la wou e, ");
INSERT INTO tbx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","de tetei e la myayaing veil beyeeng ngandoung on dom nex e gya qakous. De xel wei wong qayeeng en Setepan eno kwax xel xe teimb me toung wou moux ghavis ti lei Sol eno vaxa. ");
INSERT INTO tbx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ka xel nex Setepan nangya qakous, Setepan zeimema bei, “Tambiy Ngandoung Yesu, wa zeim a nung laweeng veil.” ");
INSERT INTO tbx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Woyom moxo ev vaxa qatu eivek de eng niseikeing bei, “Tambiy Ngandoung, wa seng bo myaveweeng wou xel en sewokeing wei xel o.” Ka neil tine woy, moxo yeip. ");
INSERT INTO tbx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol toundei inyon me yei kwa wei xel wong wou Setepan me e mey yon, eno lalei wo nimza. Lek bouk kawei xel leis Setepan eno xel di wo nol wou xel wongeingis wei mindei eivek Yerusalem. Om xel dalus pek me vuwama lala eivek tembuing danghei wei Yudia me Samaria. Dom sinaleyeiw nanghei toundei eivek Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Anutu xe xel moux wei mi betiwou e xe qayeeng eno ev Setepan me mi wo talot en e xe meyeing. ");
INSERT INTO tbx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ekom Sol anghei di wo nol wou xel wongeingis. Me mi la eivek xomek tambak on titi me tetei moux alis vex, me toung xel eivek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Xel wei pek me vuwama lala, eno mi neil Xoulek Nimza la eivek beyeeng inyayeiw wei xel la dei yo. ");
INSERT INTO tbx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilip la xo wei beyeeng ngandoung nei ti eivek Samaria me neil Kilisi teyei nanghei inyon. ");
INSERT INTO tbx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Gyeik xel qendu ngandoung on ngo Pilip me yei dee leimalei wei e wong o, xel dalus liw nenyend me ngo vati wei e di neil o. ");
INSERT INTO tbx_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","En xel laweeng nilaxes nyayek niseikeing de lam myayaing veil xel ngenong on, de xel ngenong wei bezomb o, me xel wei mema vaxa wo nilul eno wo nimzalek. ");
INSERT INTO tbx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Om moux alis vex wo xeindlala ngandoung eivek beyeeng ngandoung tiyon. ");
INSERT INTO tbx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Xomaxoneing ti mindei eivek beyeeng ngandoung tiyon, e lei Simon eno mi wong palak eivek beyeeng ngandoung ond, om xomaxoneing dalus wei Samaria eno etek, moxo mi byexvaxa bei e tambiy teiv ngandoung ti, ");
INSERT INTO tbx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","de xomaxoneing dalus, me xel wei leind ngandoung me leind nayak toung nenyend wou e me neil, “Moux tine qou nikanzek ngandoung nambei Anutu xe Nikanzek.” ");
INSERT INTO tbx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","De xel liw nenyend wou Simon en nambei e wong etekeing wou xel lumama en e xe palak. ");
INSERT INTO tbx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ekom gyeik Pilip di neil Xoulek Nimza wei Anutu xe tete lalei yo eivek Yesu Kilisi lei, omek xel wongis de xel lipek moux alis vex. ");
INSERT INTO tbx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon venaxow wongis me lipek. Me moxo mi betiwou Pilip me la danghei danghei nei, me yei dee leimalei me lulvako ngandoung wei Pilip wong, om mi wounalei ngenong. ");
INSERT INTO tbx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","De woyom sinaleyeiw wei mindei eivek Yerusalem eno ngo bei Samariayeiw lewexe lek Anutu xe xoulek, om xel wong Petele luw Yoan la wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Gyeik luw la tyip, luw zeimemend wou xel bei xel a qou Laweeng Vambuing, ");
INSERT INTO tbx_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","en nambei Laweeng Vambuing seng ghei lam lek xel valu qe xel qou lipekeing eivek Tambiy Ngandoung Yesu lei venaxow. ");
INSERT INTO tbx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Woyom Petele luw Yoan li memend lek xel, me xel qou Laweeng Vambuing. ");
INSERT INTO tbx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon yei inyon bei Laweeng Vambuing lam lek xel gyeik sinale luw xouing li memend lek xel on, om qou malew me la wou luw, ");
INSERT INTO tbx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","me neil, “Muw wong nikanzek tiyon wou ay, en kandek a ni memang lek xelti ond e qou Laweeng Vambuing o.” ");
INSERT INTO tbx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ekom Petele neil wou e, “Wa xe malew embo nol is wang, en wang wou kwam being bou lul wei Anutu wong bandaing o en malew! ");
INSERT INTO tbx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Wa seng teyeimbei bong Anutu xe xuk tiwei uw andi wong ne, en nambei wa laleim on se wo bombek wou Anutu manghalus. ");
INSERT INTO tbx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Wa pekwi xow veil kwa nilul tiwei wang wong o. Dom na zeimemam wou Tambiy Ngandoung bei e teyeimbei semaleeng wa xe kwa nilul wei di yeip eivek wa laleim on. ");
INSERT INTO tbx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","En a xei bei wa laleim on pup en lul nilul, me lul nilul on tup wang axound.” ");
INSERT INTO tbx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Woyom Simon lewexe, “Muw zeimemamim wou Tambiy Ngandoung en ay, en kandek lulul wei muw ghe neil on ti se balwou ay.” ");
INSERT INTO tbx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Om luw neil Tambiy Ngandoung xe xoulek teyei, de neil wou xel en lulul wei Tambiy Ngandoung wong wou luw o. De Petele me Yoan lox me la Yerusalem, luw di lox eno luw neil Xoulek Nimza eivek beyeeng ngenong wei Samaria yo. ");
INSERT INTO tbx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Dekalekom angela wei Tambiy Ngandoung xe eno ti neil wou Pilip, “La xonei wou sakwaing tembuing bandaing, wei la xo Yerusalem nei me la Gasa yo.” ");
INSERT INTO tbx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Om moxo qandi lek me la, me la tyip wou xomaxoneing wei Itiopia eno ti wou sakwaing, tambiy yon xel veil e nikanzek veil, tambiy yon lei ngandoung wei mi yeiteyei malew wei kwin Kandesi wei Itiopia yo. Xomaxoneing tine la Yerusalem bei na dundek wou Anutu, ");
INSERT INTO tbx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","om loum me lox me la beeng, de deilek e xe karis dom di pyaw qapiya wei poropet Yesaya byex o. ");
INSERT INTO tbx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Laweeng Vambuing neil wou Pilip, “La paviy karis tiyon me la vaxam is e.” ");
INSERT INTO tbx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Woyom Pilip veimya me la wou karis tiyon me ngo ingwei tambiy moxon di pyaw qayeeng wei poropet Yesaya byex o. Om Pilip teling wou e, “Beip wang woulek qayeeng wei wang di pyaw on?” ");
INSERT INTO tbx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Moxo neil embei, “Wangwei xel ti se neil wou a nei, on tyek a boulek ambei nya?” Om moxo neil wou Pilip bei, e zekna mendei is e. ");
INSERT INTO tbx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Tambiy tiwei xel veil e nikanzek veil eno di pyaw xoulek wei yeip eivek qapiya eno nambei nye: “Xel dandiy e nambei sipsip ti me la bei na nyeis e mey, ekom se neil qayeeng ti, me nambei sipsip lingheing wei xel qou me la bei na qateiv e nivlus veil o. ");
INSERT INTO tbx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xel wo niyalenyeing wou e om xel se zeim e xe qayeeng wo nimza. Om eti teyei bei tul pavulek en e neumambu? En xel zeim e xe mapieing veil anghei tembuing.” ");
INSERT INTO tbx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Tambiy tiwei xel veil e nikanzek veil eno teling wou Pilip, “Wa neil neing wou ay, bei poropet di luk en eti, emaxow o xel nge?” ");
INSERT INTO tbx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Woyom Pilip neil qayeeng wei di yeip eivek qapiya yo wou tambiy tiyon, me neil Xoulek Nimza wou e en Yesu. ");
INSERT INTO tbx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ka luw di la wou sakwaing me la tyip wou memiing valu om tambiy on neil, “Wei, memiing inye. Nambei nya ekom a se teyei bei zipek?” ");
INSERT INTO tbx_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","De Pilip neil, “Wangwei wang bongis laleim dalus nei, yond wang teyei being zipek.” De moxo lewexe me neil, “A wongis bei Yesu kilisi yon Anutu Neu Moux.” ");
INSERT INTO tbx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Om moxo neil me karis nale, de luw Pilip xouing teila eivek memiing me Pilip lipek e. ");
INSERT INTO tbx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ka luw lek loum veil memiing, Laweeng Vambuing wei Tambiy Ngandoung eno lam lutika me qou Pilip de malang, om tambiy on se lox yei e no, ekom moxo di la wou sakwaing is xeilala me la beeng. ");
INSERT INTO tbx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","De Pilip yei bei la toundei eivek beyeeng Asdot, om la beyeeng tiyon me neil Xoulek Nimza eivek beyeeng sapa yon dekalekom la tyip Sisalia. ");
INSERT INTO tbx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Kalekom Sol di luk niseikeing en embei bo nol wou Tambiy Ngandoung xe xel betiyeing me nyeis xel a mey, om la wou lumuki lukanzek, ");
INSERT INTO tbx_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","me teling wou moxo bei e byex qapiya ti ena wou xomek qekueing ama eivek Damaskus, en kandek wangwei e gyei eti yeiw mendi betiwou wou Sakwaing Tiyon, moux o vex, ond e zeim axound xel ambei xel wei xeitueing o de na qou me noum Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ka moxo la wou sakwaing me la paviy Damaskus, eno xeiyaing ti lam lutika nanghei tyoung gheyapu nei me tel evivekwou e. ");
INSERT INTO tbx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Moxo oing me teila lek tembuing de ngo vya ti neil wou e, “Sol, Sol, nambei nya wang di wo nimaying wou ay?” ");
INSERT INTO tbx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol teling, “Tambiy Ngandoung wang eti?” Moxo neil, “A Yesu, tiwei wang di wo nimaying wou yo. ");
INSERT INTO tbx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Gweimbeeng qandi lek me la eivek beyeeng wei Damaskus nei, en tyek tambiy ti na neil wou wang en vati wei wang bong o.” ");
INSERT INTO tbx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Xel xomaxoneing wei di la is Sol eno nale inyon de se wo lukluk, xel ngo vya ti ekom xel se yei xelti. ");
INSERT INTO tbx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol qandi lek veil tembuing, ekom gyeik ingwei vindek manghalus lek eno moxo se yei lulti. Om xel zeim e mema me la eivek Damaskus. ");
INSERT INTO tbx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Teyei lek bouk yal eno moxo manghalus nanghei toundei matekeing, om se ya lulti, o se num. ");
INSERT INTO tbx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Betiyeing ti toundei eivek Damaskus e lei Ananias. Tambiy Ngandoung taxe la wou e eivek ingwei manghalus pekwi yo me neil, “Ananias!” Moxo neil elox, “Tambiy Ngandoung a toundei yo.” ");
INSERT INTO tbx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Tambiy Ngandoung neil wou e, “Qandi lek me la xomek wei Yudas o, wou sakwaing mema wei xel mi taxe bei Sakwaing Bombek nei, me teling en xomaxoneing wei lam anghei Tarsus, e lei Sol, wei!, moxo di zeimema. ");
INSERT INTO tbx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Eivek ingwei manghalus pekwi eno yei moux ti lei Ananias lam me liw mema lek e bei bong e manghalus gyeina no.” ");
INSERT INTO tbx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias neil elox bei, “Tambiy Ngandoung, a ngo qayeeng ngenong en moux tine, me nimaying dalus wei mi wong wou wa xe xel wei mi wongis wang eivek Yerusalem o. ");
INSERT INTO tbx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","De e lam inye is nikanzek wei lumuki leitata wong wou bei e nam a zeimaxoun xel dalus wei mi taxe wa leim o.” ");
INSERT INTO tbx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ekom Tambiy Ngandoung neil wou Ananias, “La! tambiy tinei inye a xe xukxe wei a beyal bei e qalei a leing me na wou xel amba, me xel king me wou xomaxoneing wei Israel o. ");
INSERT INTO tbx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tyek a talex wou e en nimaying maying wei embei qalei en a leing o.” ");
INSERT INTO tbx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Woyom Ananias la eivek xomek me la lalei. De li mema lek Sol, moxo neil, “Ling Sol, Ka wang di lam inye eno Tambiy Ngandoung Yesu tyip wou wang wou sakwaing, eno wong a lam bei wang gweina no me Laweeng Vambuing e pup wang lek.” ");
INSERT INTO tbx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","De lutika eno lulti nambei bis teila veil Sol manghalus, om moxo teyeimbei gyeina no. De moxo qandi lek dom lipek, ");
INSERT INTO tbx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ka e ya yaeing valu woy, eno moxo qou nikanzek no. Sol dei inyon bouk valu is xel betiyeing eivek Damaskus. ");
INSERT INTO tbx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Lutika eno moxo neil xoulek eivek xomek qekueing ama wei Yudayeiw bei Yesu yon Anutu Neu Moux. ");
INSERT INTO tbx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Xel dalus tiwei ngo e eno etek me teling, “Beip inyon tambiy tiwei mi leis xel eivek Yerusalem wei mi taxe lei tiyon o? Beip se lam inye bei na qou xel nambei xel xeitueing me na wou xel lumuki leitata?” ");
INSERT INTO tbx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ekom Sol wo nikanzek kamouyo, me neil xoulek yeip yanyateiv wou Yudayeiw wei mindei eivek Damaskus bei “Yesu yon Kilisi.” ");
INSERT INTO tbx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ka bouk ngenong la veil, om Yudayeiw qekuma me tup qayeeng lekti bei, xel embei na zeimaxoun Sol dom nyeis e mey, ");
INSERT INTO tbx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ekom Sol qou kwa woy wou xel xe woueing nalei. Bendiyeing aluw boukeing eno xel mi toung mend wou tete mya wei Damaskus o, en xel embei nyeis e mey. ");
INSERT INTO tbx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ekom e xe xel betiyeing qou e eivek boukeing me lek tete ngandoung wei vivekwou beyeeng on me wong e lep me la eivek pasik ngandoung me e la tete demi veil beyeeng on. ");
INSERT INTO tbx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ka e la tyip Yerusalem, me moxo embei na is xel betiyeing, ekom xel dalus yaleeng en e de xel se wongis bei e wo betiyeing ti neing. ");
INSERT INTO tbx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ekom Banabas qou e me la wou xel wei sinale yo. Moxo neil wou xel bei Sol di lam wou sakwaing eno yei Tambiy Ngandoung me Tambiy Ngandoung luk wou e, me eivek Damaskus e luk nikanzek wou xel on eivek Yesu lei. ");
INSERT INTO tbx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Om Sol toundei is xel me ghavineeng eivek Yerusalem, moxo se yaleeng qe di luk nikanzek en Tambiy Ngandoung lei. ");
INSERT INTO tbx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","E luk me nganeng is Yudayeiw wei mi luk Grik o en Yesu, ekom xel di wong en embei nyeis e mey. ");
INSERT INTO tbx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Gyeik liyeiw ngo qayeeng tine, xel qou e me la Sisalia me wong e la Tarsus. ");
INSERT INTO tbx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Woyom xel wongeingis eivek Yudia, Galili me Samaria eno dei wo nimza is ama. Xel valu se wo nol wou xel, om Laweeng Vambuing byexaxoun xel, de xel dei xeinghembi eivek Tambiy Ngandoung. De xel wongeingis nyouk me wo ngenong. ");
INSERT INTO tbx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ka Petele ghavineeng me la eivek beyeeng valuvalu nei, moxo la en embei na gyei xel wongeingis wei toundei eivek beyeeng Lida nei. ");
INSERT INTO tbx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nanghei inyon eno moxo yei xomaxoneing ti lei Ainias, tambiy on bezomb, om moxo mi yeip lek zek teyei lek vakovek qes lim yal. ");
INSERT INTO tbx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petele neil wou e, “Ainias, Yesu Kilisi wong wang wo nimzalek. Qandi me vevilexe wa xe ghus.” Lutika eno Ainias qandi. ");
INSERT INTO tbx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Xel dalus tiwei mindei eivek Lida me Saron eno yei moxo wo nimzalek, om xel pekwi me loum wou Tambiy Ngandoung. ");
INSERT INTO tbx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Eivek Jopa inyon betiyeing ti lei Tabita (xel pekwi bei Dokas), taxombouk eno vexo mi wo nimza me vind xel wei kanyo yo. ");
INSERT INTO tbx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lek bouk kayon vexo qou myavanei ti me mey, om xel lipek vexo dom liw e la eivek xomek lalei wei yeip ghey yo. ");
INSERT INTO tbx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida yon di yeip paviy Jopa, de xel betiyeing ngo bei Petele la toundei Lida, om xel wong tambiy yuw la wou e me neil wou e, “Wang nam daing wou xa!” ");
INSERT INTO tbx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Petele la is luw, me gyeik e la tyip eno xel qou e me la xomek gheyapu wei Dokas di yeip eivek on, vexeiv dalus on toungale vivekwou e, xel di eng me talex teimb wei Dokas mi duw o gyeik e ghei toundei mapieing is xel o. ");
INSERT INTO tbx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petele wong xel dalus la myayaing veil xomek lalei, woyom moxo ev vaxakatu eivek dom zeim. De pekwi ma lox wou meyeing me neil, “Tabita, qandi.” Vexo vindek malek me yei Petele dom qandi me dei ghey. ");
INSERT INTO tbx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Moxo zeim e lek me vind e nale lek vaxa, woyom taxe xel Wongeingis me xel vexeiv lam, dom talex Tabita wou xel bei toundei mapieing. ");
INSERT INTO tbx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Xuk ti Petele wong ne eno qayeeng la teyei lek beyeeng sapa wei Jopa nei, me xomaxoneing ngenong wongis Tambiy Ngandoung. ");
INSERT INTO tbx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petele dei eivek Jopa teyei lek bouk valu is tambiy ti lei Simon, tambiy on mi wo xuk lek manghaxo ninavi. ");
INSERT INTO tbx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nanghei Sisalia eno tambiy ti mi dei inyon eno lei Konilias, inyon beyeiv wei xel 100 vevekyeiw o wei xel mi taxe bei vevekyeiw qendu ti wei beyeeng Itali yo. ");
INSERT INTO tbx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Moxo lis nipapu mi yaleeng me betiwou Anutu teyei lek bouk tambak, me mi vind xel wei kanyo yo. De taxombouk eno mi zeimema wou Anutu. ");
INSERT INTO tbx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Bouk ti lek seivma yal wei soukeing eno Konilias mapekwi me yei bei Anutu xe angela ti lam di neil qayeeng wou e me neil embei, “Konilias!” ");
INSERT INTO tbx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konilias yaleeng me doma wou e, Moxo teling, “Tambiy Ngandoung, inye va?” Angela lewexe, “Wa xe zeimeing me vineing wei wang mi wong wou xel kanyo eno la gheyapu wou Anutu manghalus nambei da wei woueing nalei en o. ");
INSERT INTO tbx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Om wong moux valu la Jopa me qou tambiy tiwei lei Simon o me loum. Wei xel mi taxe e lei nge eno Petele. ");
INSERT INTO tbx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Moxo mindei is Simon tambiy wei mi wo xuk lek manghaxo ninavi yo, wei e beeng di yeip wou mamileeng nenyawes o.” ");
INSERT INTO tbx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ka angela luk is e woy dom la, woyom Konilias taxe e xe xukxe yuw me xel vevekyeiw eno ti wei mi betiwou Anutu me mi yeiwou xow woy en xuk wei Konilias o. ");
INSERT INTO tbx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Moxo neil wou lal en lulul sapa wei tyip on dom wong lal la Jopa. ");
INSERT INTO tbx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Lek bouk nge yanyeing wei seivma evlek eno tambiy yal on la tyip paviy beyeeng ngandoung Jopa, de Petele lek la xomek demi qetyei bei na zeim mema. ");
INSERT INTO tbx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Moxo maxepya om embei gya lul yaeing valu, ka xel di yeiwou lul yaeing, eno moxo manghalus pekwi me yei. ");
INSERT INTO tbx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Moxo yei tyoung gheyapu tax me lulti nambei qaeing ngandoung ti, wei xel byex yis eivek nenyawes vey de wong e tei lam lek tembuing. ");
INSERT INTO tbx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Eivek qaeing on eno pup en leliy leliy wei vaxa vey eno lam eivek tiyon me ingwei mi yelek tembuing me menek menek o. ");
INSERT INTO tbx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Woyom vya ti neil wou e, “Petele, qandi, de leis me wa.” ");
INSERT INTO tbx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petele neil elox bei, “Se teyei, Tambiy Ngandoung! A se mi xa lul wei nilul o nilaxes o ti.” ");
INSERT INTO tbx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Woyom vya tine neil wou e luyuw, “Wa se taxe lulti nilaxes wei Anutu wong e wo vako yo.” ");
INSERT INTO tbx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tine wo luyal, de lutika eno qaeing ngandoung tiyon leklox me la tyoung gheyapu. ");
INSERT INTO tbx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Kalekom Petele di wounalei ngenong en ingwei manghalus pekwi me yei eno qes, de moux yal wei Konilias wong lal la eno la yeiwou Simon beeng om lal nale wou tete mya. ");
INSERT INTO tbx_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Xel taxe la me teling bei, “Simon tiwei lei nge bei Petele eno toundei inye?” ");
INSERT INTO tbx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ka Petele nanghei di wounalei en ingwei manghalus pekwi me yei vati yo, eno Laweeng Vambuing neil wou e bei, “Simon, moux yayal di yimexe wang o. ");
INSERT INTO tbx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Om qandi me lep me la xonei, wa seng bounaleim ngenong en laeing is lal, en a wong lal lak.” ");
INSERT INTO tbx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petele la xonei me neil wou lal, “A tiwei mal ghe di wimexe eno inye. Mal ghe lam en va?” ");
INSERT INTO tbx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Moux yal on neil elox, “Konilias beyeiv wei xel vevek o wong ghal a lam. E yon bombek me tambiy wei mi yaleeng en Anutu yo, e tiwei xel Yudayeiw dalus mi wevek e xeinghembi yo. Angela vambuing neil wou bei wang na e xe xomek en kandek e ngo vati wei wambei neil o.” ");
INSERT INTO tbx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Woyom Petele neil wou moux yal on me qou lal me la eivek beeng me yeiteyei lal boukeing tiyon. Nge yanyeing eno Petele la is lal me xel wongeingis valu nanghei Jopa eno la is. ");
INSERT INTO tbx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yanyeing eno xel la tyip Sisalia. Konilias di wou kwa en xel, me taxe nipapu dalus me gweleeng yeiw wei mindei paviy e yo me xel qeku la toundei. ");
INSERT INTO tbx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ka Petele la eivek xomek, Konilias la pelong e me ev vaxa qatu eivek de wo lalo wou e. ");
INSERT INTO tbx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ekom Petele wong e nale ghey. De neil wou e, “Nale, a maxow ne moux bandaing.” ");
INSERT INTO tbx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","De Petele la lalei me luk is e, me yei xomaxoneing qendu ngandoung ti di qekuma. ");
INSERT INTO tbx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Moxo neil wou xel, “Xam venaxow ghe woulek e wo nimza bei, Inyei se la teyei lek xa xe petieing bei Yudayeiw ti na mendei is xel amba o na paviy xel. Ekom Anutu talex wou ay bei a se taxe xelti bei e nilul o e nilaxes. ");
INSERT INTO tbx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Om a se pyalek wa vyam wei wang taxe ay yo. Qe a lam teyei lek wa vyam, om ambei teling xam bei xam ghe taxe ay en va?” ");
INSERT INTO tbx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Konilias lewexe, “Bouk vey lak veil eno a toundei eivek bang me na zeimemang lek seivma tine, lek seivma yal wei soukeing o. Lutika eno tambiy ti byex teimb wei teltyip eno nale wou a manghalus ");
INSERT INTO tbx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","me neil, ‘Konilias, Anutu ngo wa xe zeimeing mema me wounalei en wa xe wongeing wei wang mi wong wou xel kanyo yo. ");
INSERT INTO tbx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Om wong xelti la Jopa en Simon wei xel mi taxe lei nge bei Petele yo. Moxo la toundei eivek xomek wei Simon wei mi wo xuk lek manghaxo ninavi yo, wei e xe xomek toundei wou mamileeng nenyawes o.’ ");
INSERT INTO tbx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Om a wong tambiy yal lak lutika, dom inye nimza bei wang lam. Gweimbeeng wei xe xouing dalus a toundei inye wou Anutu manghalus bei na ngo wou lul sapa wei Tambiy Ngandoung peti wou wang bei wa neil wou xa yo.” ");
INSERT INTO tbx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Woyom Petele embei baluk: “Gweimbeeng a woulek zonghek bei inyon Anutu se mi talex lalei vineing wou xelti venaxow ");
INSERT INTO tbx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","qe mi lewexe lek xomaxoneing wei lam anghei tembuing tambak nei me mi yaleeng en e me mi wong vati wei bombek o. ");
INSERT INTO tbx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Xam ghe woulek qayeeng wei Anutu wong ela wou xomaxoneing wei Israel o, me neil Xoulek Nimza wei lalei vevopeing wei lam eivek Yesu Kilisi yo, e tiwei wo Tambiy Ngandoung en lul dalusateiv o. ");
INSERT INTO tbx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Xam ghe woulek lul tambak woy wei belup ela teyei lek tembuing sapa wei Yudia nei. Dekakom Yoan neil qayeeng wei lipekeing o. Lul ne qandi tax eivek Galili. ");
INSERT INTO tbx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xam ghe woulek bei Anutu beyal Yesu wei Nasaret o me wong Laweeng Vambuing me nikanzek wou e, me xam ghe woulek ingwei e la ghavinenyeing me vind xel me wong xel dalus wei mindei xeinghembi eivek nikanzek wei tambiy mapetok o wo nimzalek, en nambei Anutu toundei is e. ");
INSERT INTO tbx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Xa xei lek mami en lul dalus wei Yesu wong eivek tembuing tambak wei Yudayeiw me eivek Yerusalem o. Xel leis e mey nangya ingwei xel teyu e lek xax o, ");
INSERT INTO tbx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ekom Anutu piyexe e veil meyeing lek bouk yal, de lenghek lek bei xomaxoneing gyei e. ");
INSERT INTO tbx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Xomaxoneing dalus on se yei e, qe xel wei yei eno inyon Anutu beyal xel wongeingis wei xa mi xa me na num is e gyeik ingwei qandi lek veil meyeing o. ");
INSERT INTO tbx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","E wong qayeeng nikanzek wou xa bei xa neil qayeeng wou xomaxoneing me na neil teyeimbei, e tambiy tiwei Anutu beyal bei e zeim qayeeng wei mapieing me meyeing o. ");
INSERT INTO tbx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Poropet dalus neil e teyei bei xel dalus wei wongis e eno mi semaleeng xel xe sewokeing veil eivek Yesu lei.” ");
INSERT INTO tbx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ka Petele nanghei di neil qayeeng tine, Laweeng Vambuing lam axone lek xomaxoneing dalus wei ngo qayeeng ne yo. ");
INSERT INTO tbx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Xel wongeingis wei ghuw nindnavi me lam is Petele eno etek en vineing wei Laweeng Vambuing qapyex elam lek xel wei bamba yo is. ");
INSERT INTO tbx_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","En xel ngo ingwei xel on di luk eivek vya vya me sanghoxe Anutu yo. Woyom Petele neil, ");
INSERT INTO tbx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Eti teyeimbei bale zeyi xomaxoneing ne en ingwei xel embei zipek eivek memiing o? En xel qou Laweeng Vambuing nambei ingwei xey a qou ne.” ");
INSERT INTO tbx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Om moxo wong qayeeng nikanzek wou xel bei, “Xel a qou lipekeing eivek Yesu Kilisi lei.” Woyom xel teling wou Petele bei e toumendei is xel bouk valu. ");
INSERT INTO tbx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Xel sinale me liyeiw wei mindei lala eivek distrik Yudia eno ngo qayeeng tiyon bei, xel amba eno qou xoulek wei Anutu yo is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","De gyeik Petele la pu wei Yerusalem nei, xel betiyeing wo ninkanzek en kwa wei ghuweing ninavi veil o, om xel neil qayeeng lox me loum lek e, ");
INSERT INTO tbx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","de xel neil, “Wang la eivek xel moux wei se ghuw ninavi yo bend me ghe wa is xel.” ");
INSERT INTO tbx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Woyom Petele neilteyei wou xel bombek en lul sapa wei belup o: ");
INSERT INTO tbx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Moxo neil, “A mindei eivek beyeeng ngandoung wei Jopa nei me na mi zeimemang eno a manghalus pekwi me na xei. A xei lulti nambei qaeing ngandoung wei xel byex yis lek nenyawes vey eno tei lam anghei tyoung gheyapu, me lam wou ingwei a toundei ghei yo. ");
INSERT INTO tbx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","A xei la eivek lalei me na xei leliy wei vaxa vey wei tembuing o, a xei leliy leliy bemeeng, me leliy leliy wei mi yelek bambound o, me menek menek wei gheyapu yo. ");
INSERT INTO tbx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Woyom a ngo vya ti neil wou ay, ‘Petele, qandi lek, leis leliy on me wa.’ ");
INSERT INTO tbx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“A neil bei, ‘Ma, se teyei ti, Tambiy Ngandoung! Lul wei nilul o, me ingwei nilaxes o ti se mi lam eivek a myang ne.’ ");
INSERT INTO tbx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ekom vya tine luk e loum anghei tyoung gheyapu nei luyuw no, ‘Wa se taxe lul wei Anutu wong e wo vako yon nilaxes.’ ");
INSERT INTO tbx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tine belup luyal, de woyom lul dalus tiyon leklox me la tyoung gheyapu no. ");
INSERT INTO tbx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Lek bouk kayon bombek, eno moux yal wei lam anghei Sisalia eno lam nale ghei ingwei a toundei ghei yo. ");
INSERT INTO tbx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Laweeng Vambuing neil wou ay bei, ‘Wa seng bounaleim ngenong en ingwei wa being na is xel o.’ Moux limti beimambei ne lindama eno lam is ay, me xa la eivek moux moxon beeng. ");
INSERT INTO tbx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Moxo neil wou xa en ingwei yei angela ti eno lam tyip wou e eivek e beeng on me neil, ‘Wong xel la Jopa wou Simon tiwei xel mi taxe e bei Petele yo. ");
INSERT INTO tbx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Moxo tyek na qou qayeeng me nak wou wang, de eivek qayeeng on eno wang me wa xe xel dalus wei xomek on eno tyek Anutu devind xam veil meyeing.’ ");
INSERT INTO tbx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Ka a di luk wou xel eno Laweeng Vambuing lam lek xel nambei ingwei lam lek xey myaxeeng o. ");
INSERT INTO tbx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Woyom a wou naleind en vati wei Tambiy Ngandoung neil o: ‘Yoan lipek xomaxoneing en memiing, ekom tyek xam ghe zipek en Laweeng Vambuing.’ ");
INSERT INTO tbx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Om wangwei Anutu bong lul nimza ti wei teyeima nambei ingwei wong wou xe wei wongis Tambiy Ngandoung Yesu Kilisi, yond ay eti, a teyei bei paseisexe Anutu!” ");
INSERT INTO tbx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ka xel ngo qayeeng tine woy eno xel tip xel xe qayeeng lukeing lox me loum wouma dom sanghoxe Anutu me neil, “Woyom Anutu e zenghek lek xel amba bei xel pekwi xow me na qou mapieing.” ");
INSERT INTO tbx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Gweimbeeng xel wongeingis ngenong pek me vuwama lala en ingwei xel leis Setepan mey o, eno valu pek me la Ponisia, Saiprus me Antiok, eno xel di neil qayeeng wou Yudayeiw venaxow. ");
INSERT INTO tbx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ekom moux valu nanghei Saiprus me Sairini eno la Antiok me luk wou xel Grik is ambei nyon, me neil wou xel en Tambiy Ngandoung Yesu xe Xoulek Nimza. ");
INSERT INTO tbx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tambiy Ngandoung nikanzek toundei is xel, om xomaxoneing ngenong wongis me pekwi xow me loum wou Tambiy Ngandoung. ");
INSERT INTO tbx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Qayeeng tine eno la eivek xel wongeingis anghei Yerusalem o nenyend, om xel wong Banabas la Antiok. ");
INSERT INTO tbx_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ka moxo la tyip me yei Anutu xe lalei xeiles wei wo neing lek eno toundei is xel, om moxo wo xeilala me byexaxoun xel dalus bei xel a mi mendei is laleind tixemou wou Tambiy Ngandoung is laleind dalus. ");
INSERT INTO tbx_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Moxo yon moux nimza, wei pup en Laweeng Vambuing me e xe wongeingis eno wo nikanzek. Me xomaxoneing ngenong eno xel lam is xel wei Tambiy Ngandoung o. ");
INSERT INTO tbx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Woyom Banabas la Tarsus me la yimexe Sol, ");
INSERT INTO tbx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ka moxo yeiwou e, qou e me la Antiok. Lek vakovek qes tiyon dalus, Banabas aluw Sol dei is xel wongeingis me mi teyoxe xomaxoneing ngenongakes. Nanghei Antiok eno xel betiyeing qou leind Klisten ti myaxeeng o. ");
INSERT INTO tbx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Eivek bouk tine eno xel poropet valu lam anghei Yerusalem me lam axo wei Antiok ne. ");
INSERT INTO tbx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Xel poropet on ti, lei Agabus, nale ghey me eivek Laweeng Vambuing eno moxo neilteyei bei tyek maxep ngandoung nam wou xel me na teyei lek tembuing sapa wei Rom o. (Tine lam eivek bouk wei Klodias toundei king o.) ");
INSERT INTO tbx_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Xel betiyeing titi wong malew e teyei lek xel xe nikanzek, xel embei devind liyeiw wei toundei eivek Yudia nei. ");
INSERT INTO tbx_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Xel wong tine, me wong xel xe vineing me Banabas aluw Sol qou me la wou teivateiv wei Yerusalem o. ");
INSERT INTO tbx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lek bouk ambei nye, king Herot zeimaxoun xel valu wei xel wongeingis o, en embei bo nol wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Moxo neil me xel wo nol wou Jems, inyon Yoan li moux, me leis e mey angya ngeyeing vevek. ");
INSERT INTO tbx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herot yei bei lul tiwei e wong ne wo nimza wou xel Yudayeiw mendghalus, om moxo di wong en embei zeimaxoun Petele is ambei nyon. Herot wong tine lek Bouk Wei Yaeing Belet Wei Yis Ma Veil o. ");
INSERT INTO tbx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ka xel zeimaxoun e, Herot toung moxo eivek xomek xeitueing, me wong e la eivek xel belimbo yon memend, xel belimbo yon qendu vey om xel embei qou e me na myayaing me bong qayeeng en e yanyateiv eivek xomaxoneing on mendghalus, loxyus en bouk wei Pasova yo. ");
INSERT INTO tbx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Om xel di yei Petele teyei eivek xomek xeitueing, ekom xel wongeingis di zeimemend bei Anutu e devind Petele. ");
INSERT INTO tbx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Boukeing nge wei la tax en ingwei Herot embei qou e me na eivek xomek wei zeimeing qayeeng o, eno Petele di yeip eivek xel vevek on yuw senghoing, xel tup en sen yuw, de vevekyeiw valu toungale zeyi xomek xeitueing on mya. ");
INSERT INTO tbx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Se wo lululek en angela wei Tambiy Ngandoung xe eno lam tyip me xeiyaing tel la eivek xomek xeitueing on lalei. Angela byex mema lek e byek de piyexe e. Moxo neil, “Qandi lek Daing!” Dom sen kwax veil e mema. ");
INSERT INTO tbx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Woyom angela neil wou e, “vex wa xe let vivekwou xow me byex vaxalambes lek.” Om Petele wong ambei e neil o. Angela neil wou e no, “Byex wa xe teimb ding de betiy ay.” ");
INSERT INTO tbx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Petele betiwou e me la myayaing veil xeitueing, ekom moxo se woulek bei angela di wong tiyon neing ayang wou e, qe moxo embeik nge manghalus pekwi me yei. ");
INSERT INTO tbx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Luw la ghanaw xomek mya tiwei tax o me la nge wei yuw o is xel belimbo yon dom lam wou tiwei mya aen wei la wou beyeeng ngandoung o. Xomek mya aen on venaxow tax en luw, dom luw la lox me la myayaing. Gyeik luw di tupwou sakwaing mema nayak on ti me la, se wou lululek en angela malang. ");
INSERT INTO tbx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Woyom Petele mavindek lek de yeila me neil, “A se bou naleind ngenong en a woulek gweimbeeng bei Tambiy Ngandoung wong e xe angela lam zeim a veil Herot xe lalei vanei me veil lul dalus wei xomaxoneing wei Yudayeiw embei bong o.” ");
INSERT INTO tbx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ka e lu yeip yaing en tine, moxo la Maria beeng. Maria neu yon Yoan de e lei nge eno Malaka, nanghei inyon eno xomaxoneing ngenong qekuma me di zeimemend. ");
INSERT INTO tbx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petele leis mema lek qapomb tiwei myayaing o, me xukxe vex ti lei Roda lam en embei tax qapomb. ");
INSERT INTO tbx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ekom vexo woulek Petele vya, vexo wo xeilala mouyo, om veimya me lox dom se tax xomek mya qe lox me neil embei, “Petele toungale wou qapomb.” ");
INSERT INTO tbx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Xel neil wou e, “Wang loung o.” Ekom vexo di wo lukendu lek me neil embei inye e yo, xel neil no, “Beind inyon e xe angela yo.” ");
INSERT INTO tbx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ekom Petele nanghei di leis mema lek qapomb, om xel tax qapomb me yei e, xel etek en e. ");
INSERT INTO tbx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Om Petele pepeeng xel angya mema bei xel se baluk, qe e neilteyei wou xel en ingwei Tambiy Ngandoung qou e me lam myayaing veil xeitueing o woy, De moxo neil embei, “Xam aneil wou Jems me liyeiw en tine.” Woyom moxo la veil xel me la beyeeng nge. ");
INSERT INTO tbx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","De satiboukeing, eno xel vevekyeiw loung en Petele en mama, om xel etek me neil embei, “Petele la nya?” ");
INSERT INTO tbx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herot wo xuk lek Petele yimexeing ekom se yeiwou e, moxo lox me la wo telinyeing wou xel vevek me luk nikanzek bei xel a mey. Woyom Herot la nanghei Yudia me la Sisalia me la dei inyon nayaka. ");
INSERT INTO tbx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot wo veweeng ngandoung is xomaxoneing wei Taia me Saidon o. Om xel xouing toung lekti me lam yei e bei embo lalei vevopeing is xel, en nambei xel xe beyeeng ngandoung on mi qou vineing en yaeing lam eivek king Herot xe tembuing. Om xel luk is Blastus wei king xe xukxe me e lalei la is xel. ");
INSERT INTO tbx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Lek bouk wei Herot beyal, eno moxo vunek en e xe teimb ding wei king o, me dei lek e xe siaking de wong qayeeng wou xomaxoneing sapa yon. ");
INSERT INTO tbx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","De woyom xel wei ngo qayeeng on taxe bei, “Vya tine inye anutu ti vya, se xomaxoneing ti vya.” ");
INSERT INTO tbx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Om lutika eno angela wei Tambiy Ngandoung xe eno ti leis e, me meii ya e lalei lalei ma de mey en Herot se sanghoxe Anutu. ");
INSERT INTO tbx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ekom xoulek wei Anutu yon la wo ngandoung me la beyeeng tambak. ");
INSERT INTO tbx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","De Banabas aluw Sol wong luw xe xuk sinale ma, om luw loum veil Yerusalem me lox me la Antiok, de luw qou Yoan wei lei nge Malaka eno is xow. ");
INSERT INTO tbx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Eivek kongrikesin wei Antiok eno inye xel poropet me xel putoung mi dei inyon eno xel leind ambei nye: Banabas, me Simion wei xel mi taxe e lei nge bei Ningak me Lusias wei Sairini, me Manain (e nipapu wei Herot seyap ngandoung o) me Sol. ");
INSERT INTO tbx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ka xel di wo lalo wou Tambiy Ngandoung me di vambu yaeing, Laweeng Vambuing neil wou xel bei, “Xam beyal Banabas aluw Sol wou ay en xuk tiwei a taxe luw en o.” ");
INSERT INTO tbx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Om ka xel vambu yaeing me zeimemend, xel liw memend lek luw dom wong luw la. ");
INSERT INTO tbx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Laweeng Vambuing wong luw la xo wei beyeeng Selusia nei me qou sip nanghei inyon me la Saiprus, tembuing danghei tiwei di yeip eivek mamileeng o. ");
INSERT INTO tbx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Luw la tyip Salamis, luw neil Anutu xe xoulek eivek xel Yudayeiw xe xomek qekueing ama. De Yoan mindei is luw nambei luw xe vineing. ");
INSERT INTO tbx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Luw la tup eivek Saiprus tembuing nayak wei mi yeip eivek mamileeng on dalus dekakom luw la tyip beyeeng Papos. Nanghei inyon eno luw yei Yuda ti wei mi wo palak me e poropet wei tyonyeing o lei Ba-Yesu, ");
INSERT INTO tbx_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","tambiy on mindei is lei ngandoung wei seyap o lei Segius Paulus, lei ngandoung wei seyap on lupeyei nimza om wong qayeeng la wou Banabas aluw Sol bei luw na neil Anutu xe xoulek en embei ngo. ");
INSERT INTO tbx_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ekom Elimas on Ba-Yesu (en inye qes wei e lei eno nambei inye) tambiy wei wevek o eno mi pesek xuk wei luw o. En mi wong en embei pelipek seyap lei ngandoung lalei bei e se bongis Yesu. ");
INSERT INTO tbx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Woyom Sol, e lei nge wei xel taxe eno Paulus, eno pup en Laweeng Vambuing, moxo yei Elimas kanzek dom neil, ");
INSERT INTO tbx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Wang on tambiy mapetok neu me wang mi wo vevek is lul dalus wei bombek o! Wang pup en lul nilul leimalei wei tyonyeing o. Gyeik inya ekom wa tip kwa wei wang mi pakei qayeeng neing wei Tambiy Ngandoung eno la wo qayeeng tyonyeing. ");
INSERT INTO tbx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ekom Tambiy Ngandoung mema wo vevek is wang. Wa mam on tyek na tuzeyi, me tyek wa seng gwei xeiyaing wei sayeiv o, qe tyek wa mendei nambei nyon enden ka.” Lutika eno laxap me mapetok lam beliv e manghalus, moxo la bandabanda, me di yimexe xel valu bei xel a zeim e mema me na. ");
INSERT INTO tbx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lei ngandoung wei seyap eno yei vati wei belup on, de moxo wongis, en nambei moxo etek en teyoxeing wei Tambiy Ngandoung xe yo. ");
INSERT INTO tbx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nanghei Papos, Paulus me e xe xel nipapu la lek sip me la beyeeng Pelga eivek tembuing danghei wei Pampilia yo, dekakom Yoan lox veil xel me la Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Nanghei Pelga eno xel la beyeeng nayak Antiok wei tembuing danghei wei Pisidia nei. Lek bouk Sabat eno xel la eivek xomek qekueing ama wei Yudayeiw o me la dei. ");
INSERT INTO tbx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ka gyovaxa wei xomek qekueing ama eno pyaw qayeeng Petieing, me qayeeng Poropet ma woy, tambiy wei mi yeiteyei xomek qekueing ama eno wong qayeeng la wou xel, me neil, “Xam lingyeiw, wangwei xam mendi qou qayeeng wei embei ghandu xound xel xomaxoneing nei, on xam a neil.” ");
INSERT INTO tbx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paulus nale ghey de pepeeng xel angya mema, dom neil: “Xam moux wei Israel me xam ba wei ghe mi waleeng en Anutu yo, xam ngo wou a le! ");
INSERT INTO tbx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Anutu tiwei Israel xe eno beyal xa bumiyeiw. Moxo wong Israelyeiw wo ngenong gyeik xel mindei eivek Izip o, moxo qou xel lam myayaing veil beyeeng tiyon nangya nikanzek ngandoung wei e yo. ");
INSERT INTO tbx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Moxo mi qalei nimaying wei xel xe deing o teyei lek vakovek qes xoumeeng vey (40) eivek beyeeng bandaing on. ");
INSERT INTO tbx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ka Anutu semaleeng xomaxoneing velei lim yuw eivek Kenan, wong xel xe tembuing wou e xe xomaxoneing nambei xel xe lulul nimza. ");
INSERT INTO tbx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Lul tine dalus eno qandi teyei lek vakovek qes 450. “Ka tine la veil eno Anutu beyal xel gyovaxa wei xel gyeiteyei xel Israel me ena tyip wou bouk wei poropet Samuel o. ");
INSERT INTO tbx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Woyom xel moux alis vex teling en king ti, om Anutu wong Sol wei Kis neu moux eno wou xel, inyon velei wei Benyamin o, wei yeiteyei xel teyei lek vakovek qes xoumeeng vey (40). ");
INSERT INTO tbx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ka Anutu laluwexe Sol, moxo beyal Dawit wo xel xe king. Moxo neil e teyei wou xel: ‘A xeiwou Dawit wei Jesi neu moux wei a maxow laleing vind o. Moxo tyek bong lul tambak wei ambei e bong o.’ ");
INSERT INTO tbx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Om Anutu wong Yesu lam, inyon Dawit buyeiw ti, Tambiy wei vind xey veil nimaying eno wou xel Israel, nambei ingwei e neil zonghek o. ");
INSERT INTO tbx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","De gyeik Yesu se ghei lam, Yoan teyoxe xel en qayeeng wei pekwieing xow o me lipekeing eno wou xel Israel dalus. ");
INSERT INTO tbx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Deka lam paviy ingwei Yoan wong e xe xuk ma, moxo neil, ‘Xam ghe wou naleimim bei ay eti? A se tambiy tiyon. Ma, ekom tyek moxo mendi nam yus en ay, e tiwei a se teyei bei tul yis veil e xe vaxalambes o.’ ");
INSERT INTO tbx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Xam lingyeiw wei Apraham neuyeiw, me xam ba wei ghe mi waleeng en Anutu yo, eno xam ngo. Qayeeng tiwei Yesu embei devind e xe moux alis vex veil meyeing eno Anutu wong e lam wou xey. ");
INSERT INTO tbx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Xel xomaxoneing wei mindei eivek Yerusalem me xel xe gyovaxa eno se yeimend wou qayeeng wei xel poropet o, wei xel mi pyaw eivek Sabat titi yo. Qe, xel byex qayeeng lek Yesu me qayeeng wei poropet neil eno wo neing lek. ");
INSERT INTO tbx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","De xel se yeiwou sewokeing ti eivek e bei bo qayeeng en e me nyeis e mey, om xel teling Pailat bei e nyeis e mey. ");
INSERT INTO tbx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Xel wong lul dalus wei xel poropet byex eivek qapiya en e yo woy, eno xel zewax e tei lam veil xax me liw e eivek eeng ti. ");
INSERT INTO tbx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ekom Anutu piyexe e qandi lek veil meyeing, ");
INSERT INTO tbx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","de bouk ngenong eno Yesu talex xow wou xel wei mi la is e eno la veil Galili me la Yerusalem. Gweimbeeng xel wei yeimawou eno neil Yesu teyei wou xa xe xomaxoneing. ");
INSERT INTO tbx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Xa neil Xoulek Nimza wou xam: En vati wei Anutu neil zonghek is xe bundyeiw o ");
INSERT INTO tbx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","moxo wong qayeeng wo neing lek en xey wei xel neundyeiw o, en piyexe Yesu qandi lek veil meyeing. Nambei ingwei xel byex eivek qapiya lalo tiwei yuw o bei: “‘Wang on a neung, gweimbeeng a wong ambei wa mam.’ ");
INSERT INTO tbx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Om Anutu piyexe e veil meyeing, de se teyei bei patal, om neil eivek qayeeng ti beimambei ne: “‘Tyek am bong mata wei vambuing me zonghek wei a neil wou Dawit eno wou xam.’ ");
INSERT INTO tbx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Om moxo neil no eivek qapiya lalo nge nambei nye: “‘Tyek wa seng teyei bei bong wa xe tiwei vambuing eno daxe pataleing.’ ");
INSERT INTO tbx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Eivek bouk wei Dawit mi dei eno mi betiwou Anutu lalei. Deka moxo mey, xel ev is mayeiw me e neing patal. ");
INSERT INTO tbx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ekom e tiwei Anutu piyexe e veil meyeing eno se axe pataleing. ");
INSERT INTO tbx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Nambei nyon, xam lingyeiw, xa neil wou xam bei. Xam ghe boulek bei Yesu wei xa neil wou xam eno teyeimbei semaleeng sewokeing wei xam o. ");
INSERT INTO tbx_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Petieing wei Mose yo se teyei bei semaleeng xam xe sewokeing veil. Ekom wangwei xelti bongis Yesu yond Anutu semaleeng e xe sewokeing dalus de wong e wo bombek. ");
INSERT INTO tbx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Om xam ghe gweiteyei xow en kandek lul wei poropet neil ne eno se nam atyip wou xam: ");
INSERT INTO tbx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“‘Wei, xam wei ghe mi wo vyamim wou Anutu xe qayeeng ne, eno tyek xam ghe detek me ghe bo nol, en tyek am bong lul tiwei tyek xam seng teyei bei bongis eno eivek xam senghoing de woyom wangwei xelti neil wou xam atax en inye nei, ond tyek xam seng bongis.’” ");
INSERT INTO tbx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ka Paulus aluw Banabas la veil xomek qekueing ama, xel xomaxoneing neil wou luw bei luw noum a neil qayeeng valu wou xel lek Sabat nge yus no. ");
INSERT INTO tbx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Moux alis vex la myayaing veil xomek qekueing ama, eno xel Yudayeiw ngenong me xel amba wei mi betiwou kwa wei xel Yuda yo eno xel betiy Paulus aluw Banabas, de luw wo qayeeng wei e beil xel lundlek en xel ami mendei nikanzek eivek Anutu xe lalei xeiles. ");
INSERT INTO tbx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lek bouk Sabat nge yus eno xomaxoneing wei beyeeng ngandoung on valu beti qekuma me la ngo Tambiy Ngandoung xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Gyeik xel Yudayeiw yei Xomaxoneing qendu ngandoung on, xel laleind wo nilul me lukyak lek Paulus en vati wei di neil o. ");
INSERT INTO tbx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Woyom Paulus aluw Banabas luk nikanzek wou xel bei: “Xa bei neil Anutu xe qayeeng wou xam atax. Ekom xam ghe pesek me ghe toung demimim wou en xam ambei se qou mapieing luta luta, om xa pekwi me na la wou xel amba. ");
INSERT INTO tbx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Inye vati wei Tambiy Ngandoung neil wou xa yo: “‘A wo wang wong ambei xeiyaing wei xel amba yo, en kandek wa devind xomaxoneing wei tembuing tambak veil meyeing.’” ");
INSERT INTO tbx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Xel amba ngo tine, xel wo xeindlala me pamilexe Tambiy Ngandoung xe qayeeng. Me xel dalus wei Anutu beyal en mapieing luta luta eno wongis. ");
INSERT INTO tbx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","De Tambiy Ngandoung xe qayeeng on la wo tambak eivek tembuing danghei tiyon dalus. ");
INSERT INTO tbx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ekom Yudayeiw zeim xel vex wei leind tata wei mindei xeinghembi eivek Anutu me zeim xel gyovaxa wei beyeeng ngandoung on laleind lek. Om xel zeimaxoun Paulus aluw Banabas, me tiy luw la veil beyeeng ngandoung on. ");
INSERT INTO tbx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Om luw pepa vegyuveeng veil vaxend bei xel on boulek bei xel wo sewokeing en kwa wei xel wong on, dom luw la veil Antiok me la beyeeng nayak Aikoniam. ");
INSERT INTO tbx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","De xel betiyeing eno pup en xeindlala me Laweeng Vambuing. ");
INSERT INTO tbx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Eivek beyeeng nayak Aikoniam, Paulus me Banabas wong ambei ingwei luw mi wong o, me la eivek xomek qekueing ama wei xel Yudayeiw o. Nanghei inyon eno luw neil xoulek wo nimza om xel ngenong wei Yudayeiw me xel amba eno wongis. ");
INSERT INTO tbx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ekom xel Yudayeiw wei mi pesek en embei se bongis eno zeim xel amba laleind lek me xel laleind wo nilul wou xel wei wongis o. ");
INSERT INTO tbx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Om Paulus aluw Banabas dei enden ka eivek inyon, de luw se yaleeng en neileing qayeeng wei Tambiy Ngandoung xe lalei xeiles o, om Anutu wong ninkanzek wou luw me luw wong dee wei lulvako leimalei yo. ");
INSERT INTO tbx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Xel xomaxoneing wei beyeeng ngandoung on dembuma la yuw, om xel valu la is Yudayeiw, de valu la is sinaleyeiw. ");
INSERT INTO tbx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Woyom xel amba me Yudayeiw is xel xe gyovaxa tup qayeeng wouma bei bo nol wou Paulus aluw Banabas me banex luw a mey angya qakous. ");
INSERT INTO tbx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ekom luw woulek inyon, om luw pek me la eivek tembuing danghei wei Likonia eivek beyeeng nayak yuw wei Listra me Debi, me beyeeng beyeeng wei toundei paviy yo, ");
INSERT INTO tbx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","nanghei inyon eno luw lox me la neil Xoulek Nimza no. ");
INSERT INTO tbx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Eivek Listra inyon tambiy ti mindei, eno vaxa bezomb gyeik ingwei umbek o, om moxo se mi ghavineeng. ");
INSERT INTO tbx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Moxo mi ngo ingwei Paulus mi luk on, Paulus doma wou e, me yeimbei moxo wongis me e teyeimbei bo nimza lek. ");
INSERT INTO tbx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Om Paulus taxe la bei, “Nale lek vaxam!” Woyom moux moxo nale ghey de tetyeik me la. ");
INSERT INTO tbx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Xomaxoneing qendu ngandoung on yei vati wei Paulus wong on, om xel taxe la eivek Likonia vyend bei, “Anutu lam axone wou xey nambei xomaxoneing!” ");
INSERT INTO tbx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Banabas, xel taxe e lei bei anutu Sus, me Paulus xel taxe bei anutu Helmes, en nambei e mi la tax en lukeing. ");
INSERT INTO tbx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Xomek lalo wei anutu Sus eno toundei paviy tete mya wei beyeeng ngandoung on, om lumuki wei xomek lalo yon me xel xomaxoneing on qou manghaxo moux me palawa me la tete mya wei beyeeng ngandoung on en xel embei besei xound wou luw. ");
INSERT INTO tbx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ekom sinale Banabas aluw Paulus ngo tine, luw lex luw xe teimb dom veimyend me la senghoing eivek xel qendu yon me taxe bei: ");
INSERT INTO tbx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Xam moux, xam ghe di wong tine en va? Uw ne xomaxoneing is me xomaxoneing nambei xam. Uw a di qou Xoulek Nimza me na lam wou xam, om uw a neil wou xam bei xam pekwi xow veil lul nilul tine de ghe na wou Anutu mapieing, e tiwei toung tyoung aluw tembuing me mamileeng me lulul sapa wei toundei eivek o. ");
INSERT INTO tbx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Eivek bouk wei takwei yo eno moxo wong xel tembuing dalus on betiwou xel venaxow xe sakwaing. ");
INSERT INTO tbx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ekom e venaxow se xupek en xomaxoneing bei xel se boulek e. Ma. Taxombouk eno moxo mi talex e xe kwa nimza wou xam. Moxo mi wong luing lam anghei tyoung eivek xam xe lulul wei xam ghe ev eivek xuk o, me moxo wong yaeing ngenong wou xam is me wong xam laleimim wo xeilala.” ");
INSERT INTO tbx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Luw neil qayeeng tine wou xel, ekom xel wo nikanzek bei besei xound wou luw. Om luw neil nikanzek bei xel se besei xound wou luw. ");
INSERT INTO tbx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Woyom Yudayeiw valu lam anghei Antiok me Aikoniam me zeim xel qendu yon laleind lek. Om xel nex Paulus angya qakous me tetei ela myayaing veil beyeeng ngandoung on, de xel embeik nge moxo mey. ");
INSERT INTO tbx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ekom ka xel betiyeing qekuma vivekwou e, de moxo qandi lek me lox me la eivek beyeeng ngandoung on. De yanyeing eno Paulus aluw Banabas la Debi. ");
INSERT INTO tbx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Luw neil Xoulek Nimza eivek beyeeng ngandoung tiyon me qou xel ngenong wo betiyeing. Woyom luw lox me la Listra, Aikoniam me Antiok, ");
INSERT INTO tbx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","me luw byexaxoun xel betiyeing laleind me neil qayeeng nikanzek wou xel bei, “Xam a mi mendei embo nikanzek eivek wongeingis me zonghek. Tyek xey a na eivek nimaying ngenong atax en kandek nana eivek tete lalei wei Anutu yo”. ");
INSERT INTO tbx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paulus aluw Banabas beyal xel gyovaxa eivek kongrikesin titi. De luw vambu yaeing me zeimemend, me toung xel la wou Tambiy Ngandoung, inyon eti yeiw wei wongis Tambiy Ngandoung o. ");
INSERT INTO tbx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ka luw la senghoing eivek tembuing danghei wei Pisidia, me la tyip eivek tembuing danghei wei Pampilia, ");
INSERT INTO tbx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","me luw la neil xoulek eivek beyeeng nayak Pelga, dekakom luw la xo wei beyeeng Atalia nei. ");
INSERT INTO tbx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Nanghei Atalia luw la eivek sip me lox me la Antiok, inyon beyeeng wei xel wong luw la eivek lalei xeiles wei Anutu yo en xuk wei luw wong ema gweimbeeng ne yo. ");
INSERT INTO tbx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Luw lam tyip inyon eno luw qeku xel kongrikesin lekti me wo qayeeng dalus wei Anutu wong wou luw me e tax xomek mya wei wongeingis eno wou xel amba yo. ");
INSERT INTO tbx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","De luw dei inyon enden ka is xel betiyeing. ");
INSERT INTO tbx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Xel moux valu lam axone veil Yudia me la Antiok me di teyoxe xel amba wei wongis o bei: “Wangwei xam se ghuw nimim navi nambei Mose xe kwa nei, on tyek Anutu se devind xam veil meyeing.” ");
INSERT INTO tbx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulus me Banabas ngo qayeeng wei xel moux on neil o om luw wo vevek wou qayeeng is xel me vuk lek qayeeng is xel lox me loum. Om xel beyal Paulus me Banabas bei luw na is xel wongeingis valu, bei xel na pu Yerusalem nei me na gyei xel sinale me teivateiv en telinyeing tine. ");
INSERT INTO tbx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","De kongrikesin wong xel la, om xel la lox Ponisia me Samaria senghoing, me di neil wou xel en ingwei xel amba pekwi xow o. Qayeeng nimza tine wong xel wongeingis wo xeindlala. ");
INSERT INTO tbx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ka xel la tyip Yerusalem eno xel wongeingis me xel sinale me gyovaxa qou xel. De Paulus aluw Banabas neil wou xel en lul dalus wei Anutu wong wou xel nangya luw memend o. ");
INSERT INTO tbx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Woyom xel Parisi valu wei wongis eno nale me neil, “Xel amba na mi ghuw ninavi me betiwou petieing wei Mose yo.” ");
INSERT INTO tbx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","De xel sinale me teivateiv qekuma bei menyex wou telinyeing tine. ");
INSERT INTO tbx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Ka xel neil qayeeng ngenong woy, Petele nale ghey me neil wou xel: “Xam lingyeiw, xam ghe woulek bei takwei eno Anutu beyal ay eivek xam senghoing bei a neil Xoulek Nimza wou xel amba en xel a ngo dom bongis. ");
INSERT INTO tbx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Anutu, tiwei woulek xomaxoneing dalus laleind eno talex wou xey bei lewexe lek xel me wong Laweeng Vambuing wou xel, nambei ingwei wong wou xey o. ");
INSERT INTO tbx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Moxo se wong kwa nge wou xel de nge wou xey, qe wong xel laleind wo vako en ingwei xel wongis o. ");
INSERT INTO tbx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Woyom nambei nya xam ambeing bo axeing wou Anutu gweimbeeng? Xam se toung pelang nimaying lek xel betiyeing kwend, beip inyon xey o xe bundyeiw se teyei bei qalei? ");
INSERT INTO tbx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ma! Xey a wongis bei, eivek lalei xeiles wei xe xe Tambiy Ngandoung Yesu eno Anutu vind xey a lam veil meyeing nambei ingwei vind xel on.” ");
INSERT INTO tbx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Xel dalus wei qekuma eno deduingma, en nambei xel di ngo Banabas me Paulus di neil qayeeng wei Anutu wong dee me lulvako eivek xel amba senghoing nangya luw memend o. ");
INSERT INTO tbx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Luw tip qayeeng eno Jems luk elekla bei: “Xam lingyeiw, xam ngo a xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon neil wou xam en vati wei Anutu talex myaxeeng en ingwei mi wou naleind en xel amba yo, bei na qou xel xomaxoneing me xel bong ambei emaxow xe. ");
INSERT INTO tbx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Me qayeeng wei xel poropet eno la teyei lek is ambei nyon, xel byex eyeip eivek xoulek bei, ");
INSERT INTO tbx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“ ‘Ka tine na veil eno tyek a noum me nam me na dev Dawit xe xomek sel no wei pek me teila veil o. Lulul wei xomek lelolexe eno tyek a menyex wou de na dev vako no, ");
INSERT INTO tbx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","en kandek moux alis vex wei xel amba wei se Yuda eno gyimexe Tambiy Ngandoung, me xel amba dalus wei mi wongis a leing o, Tambiy Ngandoung neil embei. E venaxow wong lul tine qandi.’ ");
INSERT INTO tbx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Xel woulek inyon takwei qenang nei. ");
INSERT INTO tbx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Nambei nyon a xe woueing nalei bei, xe se teyei bei bong lulti bo pok en xel amba wei pekwi xow me loum wou Anutu yo. ");
INSERT INTO tbx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Embong ondek xey a byex qapiya wou xel, me na neil wou xel bei xel se qou yaeing wei xel toung ambei da wou tenu bandaing o, me kwa nilul wei kwapesiv o, me leliy leyeis wei xel bembinexe e kwa yo de xel se gya leliy wei gyand o. ");
INSERT INTO tbx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","En eivek beyeeng ngandoung titi eivek bouk wei myaxeeng o xomaxoneing valu mi neil petieing wei Mose yo teyei de xel mi pyaw eivek xomek qekueing ama lek bouk wei Sabat o.” ");
INSERT INTO tbx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Woyom sinaleyeiw me teivateiv, is kongrikesin, xel embei beyal xel venaxow xe moux valu me bong xel na Antiok is Paulus me Banabas. Xel beyal Yudas (xel mi taxe lei nge bei Balsabas) me Silas, moux yuw on teiv eivek liyeiw senghoing. ");
INSERT INTO tbx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Xel wong qapiya tine la is xel: Xa sinaleyeiw me teivateiv ne xam limimyeiw, xa byex qapiya ne lak wou xam wongeingis wei xel amba yo eivek Antiok, Siria me Silisia: Bendiyeing xam. ");
INSERT INTO tbx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Xa ngo bei xomaxoneing valu qandi eivek xa senghoing me lak wo nol wou xam laleimim is xel xe qayeeng me wong nimaying wou xam. Ekom xa se lenghek lek xel me wong xel lak wou xam. ");
INSERT INTO tbx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Om xa dalus a toung laleimi lekti me na beyal xel valu me na wong xel lak wou xam is xa xe gweleeng Banabas me Paulus wei xa laleimi vind o, ");
INSERT INTO tbx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","moux yuw on teyeimbei saing luw xe mapieing en xe xe Tambiy Ngandoung Yesu Kilisi lei. ");
INSERT INTO tbx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nambei nyon xa wong Yudas aluw Silas lak wou xam, bei luw nak a neil qayeeng wei xa byex eno wou xam eivek luw venaxow myend. ");
INSERT INTO tbx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Inye wo nimza wou Laweeng Vambuing me xa bei xa se toung nimaying lek xam. Qe xa neimbei xam a mi betiwou kwa valu nambei nye. ");
INSERT INTO tbx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Xam mendei dingta veil yaeing wei xel toung ambei da wou tenu bandaing o. Xam seng gwa leliy is gyand, me xam se gwa leliy leyeis wei xel qo e kwa yo me xam pesek kwa nilul wei kwapesiv o. Tyek xam ghe bo nimza wangwei xam pesek lulti beimambei ne. Xam a mi mendei embo nimza. ");
INSERT INTO tbx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Woyom xel wong moux ti beimambei yon la xo wei Antiok nei, de xel qeku moux alis vex wei xel wongeingis eno lekti me wong qapiya wei xel byex o wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Xomaxoneing pyaw qayeeng tiyon me xel wo xeindlala en ingwei xel qou qayeeng nimza wei embei devind me bong nikanzek wou xel o. ");
INSERT INTO tbx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Yudas me Silas, luw venaxow on poropet. Om luw neil qayeeng ngenong bei devind me bong nikanzek wou liyeiw. ");
INSERT INTO tbx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Ka luw la dei inyon bouk valu is xel woy, woyom liyeiw wong luw lox is mata wei lalei vevopeing bei luw nox wou xel wei wong luw lam o. ");
INSERT INTO tbx_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ekom Paulus aluw Banabas nanghei toundei eivek Antiok, nanghei inyon eno luw me xel ngenong di teyoxe me neil qayeeng wei Tambiy Ngandoung xe yo. ");
INSERT INTO tbx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Bouk valu la veil woyom Paulus neil wou Banabas, “Uw ambei nox mena me na ghei lindyeiw eivek beyeeng on dalus wei xey a neil Tambiy Ngandoung xe qayeeng eivek o me nanghei bei xel toundei woy.” ");
INSERT INTO tbx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Banabas embei Yoan wei xel mi taxe e lei nge bei Malaka, eno na is luw, ");
INSERT INTO tbx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ekom Paulus wou kwa bei inye se nimza bei e qou Malaka, en nambei la veil luw anghei Pampilia me se lox me la wo xuk is luw no. ");
INSERT INTO tbx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Luw pyalek ama niseikeing me dembuma om luw se wo xuk is ama no. Banabas qou Malaka de luw qou sip me la tembuing nayak Saiprus eivek mamileeng, ");
INSERT INTO tbx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ekom Paulus beyal Silas me luw la, de liyeiw toung luw eivek lalei xeiles wei Tambiy Ngandoung o. ");
INSERT INTO tbx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Moxo la eivek provins wei Siria me provins wei Silisia yo, me byexaxoun xel kongrikesin wei toundei inyon o. ");
INSERT INTO tbx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paulus la beyeeng nayak Debi me la beyeeng nayak Listra is ambei nyon, nanghei inyon eno betiyeing ti lei Timote mindei inyon. Moxo ta yon Yuda vexo wei mi wongis o eno ti, de ma yon nanghei Grik. ");
INSERT INTO tbx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Xel wongeingis wei Listra me Aikoniam eno mi luk en Timote bei, e tambiy nimza. ");
INSERT INTO tbx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Paulus embei qou Timote me na dingta ti is e, om moxo ghuw e ninavi nambei kwa wei Yudayeiw o. En wounalei en Yudayeiw wei mindei eivek beyeeng beimambei yon o, en xel dalus woulek bei e ma yon Grik. ");
INSERT INTO tbx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ka xel la eivek beyeeng nge me la nge, eno xel wong qayeeng wei sinaleyeiw me teivateiv luklek me tup woy eivek Yerusalem eno wou xel, bei xomaxoneing dalus betiwou. ");
INSERT INTO tbx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Om xel kongrikesin on xe wongeingis wo nikanzek me xel di nyouk taxombouk. ");
INSERT INTO tbx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paulus me e xe xel wei mi wo xuk lekti eno la eivek tembuing danghei wei provins Esia nei, en nambei Laweeng Vambuing neil axound bei luw se neil qayeeng ti eivek Prigia me Galesia. ");
INSERT INTO tbx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ka xel la tyip wou tembuing danghei wei Misia, xel wong me yei en xel embei na eivek provins Bitinia, ekom Yesu xe Laweeng Vambuing peti xel bei xel se na inyon. ");
INSERT INTO tbx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Om xel la senghoing eivek Misia de la xo beyeeng nayak Troas nei. ");
INSERT INTO tbx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Eivek boukeing tiyon eno Paulus mapekwi me yei moux wei tembuing danghei wei Masedonia yo ti eno toukale me tay wou e, “Wang nam ingwei Masedonia ne me devind xa.” ");
INSERT INTO tbx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Ka Paulus mapekwi me yei tine, xa xeiwou xow daing bei na Masedonia, xa woulek bei, Anutu taxe bei xa na neil e xe Xoulek Nimza wou xel nei. ");
INSERT INTO tbx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nambei nyon, xa qou sip nanghei beyeeng nayak Troas me na la bombek wou Samotres eivek mamileeng, de yanyeing eno xa la Neapolis. ");
INSERT INTO tbx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nanghei inyon eno xa la Pilipai, wei xel Rom yeiteyei me dei lek takwei yo. Inyon beyeeng ngandoung wei tembuing danghei tiwei myaxeeng wei provins Masedonia yo. Om xa dei inyon bouk valu. ");
INSERT INTO tbx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Lek bouk Sabat eno xa la myayaing veil tete mya wei beyeeng ngandoung on me na la ingwei memiing vi nei, wei xa woulek bei inye beyeeng wei xomaxoneing mi zeim memend anghei yo. Woyom xa dei tembuing me na luk wou xel vex wei qekuma nanghei inyon o. ");
INSERT INTO tbx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Vex wei mindei inyon eno ti lei Lidia, ngo qayeeng tine me mi wo lalo wou Anutu. Vex on beeng qes Taiataira, me vexo mi wo xuk malew en qaeing wei mateyek o. Tambiy Ngandoung pekwi vex on lalei, om li nenya wou qayeeng wei Paulus di neil on. ");
INSERT INTO tbx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ka vex on me e xe xel wei xel xouing mindei eivek xomek on lipek, vexo neil embei, “wangwei xam ghe gwei bei a wongis Tambiy Ngandoung nei, ond xam ghe nam mendei eivek a bang.” Om vexo wo nikanzek en xa, me xa betiwou e xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Bouk ti xa la beyeeng wei zeimeing mema yo, de vexawo xukxe bandaing ti lam pelong xa, laweeng ti mindei eivek e me mi yei me neil vati wei tyek nam loxyus o teyei. Vex on mi qou malew ngenong wou mayeiw en xuk wei mi wong on. ");
INSERT INTO tbx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Vexawo tine eno mi betiwou Paulus me xa dalus, me mi taxe bei, “Xel moux dalus tine inye xukxe wei Anutu Nikanzekta wei Gheyapu nei. Xel mi neil wou xam en sakwaing wei embei devind xam veil meyeing o.” ");
INSERT INTO tbx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Vex tine mi wong ambei nye teyei lek bouk tambak. Dekakom Paulus lalei wo myavanei om pekwi ma wou me neil niseikeing wou laweeng on, “A neil wou wang eivek Yesu Kilisi lei bei, lam myayaing veil vex on!” De lutika eno laweeng la veil vexo. ");
INSERT INTO tbx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ekom vexawo yon mayeiw yei bei sakwaing wei qoueing malew eno lati, om xel zeimaxoun Paulus aluw Silas me tetei luw me qou luw me la nale wou xel gyovaxa mend eivek beyeeng wei xel mi wo vateivek o. ");
INSERT INTO tbx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Xel qou luw me la wou xel wei mi ngo qayeeng o me neil, “Moux yuw ne inye Yuda, luw di wo nol wou xe laleind eivek xe bend ne. ");
INSERT INTO tbx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Me luw embei puw xey a na betiwou kwa valu wei xey a lax petieing zeyi bei xey wei Rom eno se bong o.” ");
INSERT INTO tbx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Xel moux alis vex tendulekti, me byex qayeeng lek Paulus aluw Silas. Me xel wei mi ngo qayeeng eno luk nikanzek wou luw de kwax luw xe teimb veil dom sesa luw en beyei. ");
INSERT INTO tbx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ka xel wo nol wou luw woy, woyom xel toung luw la eivek xomek xeitueing, de wong qayeeng nikanzek wou tambiy wei mi yei xomek xeitueing teyei yo bei, emdi gyeiteyei luw bo nimza. ");
INSERT INTO tbx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Tambiy on ngo petieing wei nge wei mi ngo qayeeng o, om toung luw eivek xeitueing tiwei laleiyang me tup luw vaxend eivek pelang. ");
INSERT INTO tbx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Lek boukeing masenghoing eno Paulus me Silas di zeimemend me wong lalo wou Anutu, me xel valu wei xeitueing eno di ngo luw. ");
INSERT INTO tbx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","De lutika eno tembuing pi me xomek xeitueing on wo pimapi me mundeeng wei xomek xeitueing eno pi. Lutika eno qapomb wei xomek xeitueing on tax, me xel dalus xe sen tax. ");
INSERT INTO tbx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tambiy wei mi yei xomek xeitueing teyei eno qandi, me yei bei xomek xeitueing xe qapomb tax, om moxo puw e xe ngeyeing vevek dom embei nyeis venaxow en embeik nge xel wei la xeitueing eno pek me la. ");
INSERT INTO tbx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ekom Paulus taxe la wou moxo bei, “Wa seng bo nol wou xow! En xa dalus a toundei inye.” ");
INSERT INTO tbx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tambiy wei mi yei xomek xeitueing teyei eno taxe bei xel a qou nenyex tumeing me nam, moxo veimya me la lalei is etekeing me yaleeng de teila paviy Paulus me Silas vaxend. ");
INSERT INTO tbx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Woyom moxo qou luw me la myayaing me teling, “Teiv amuw, tyek am bong ambei nya en kandek Anutu e qou a noum?” ");
INSERT INTO tbx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Luw neil elox bei, “Wang bongis Tambiy Ngandoung Yesu, on tyek Anutu devind wang nam veil meyeing me wa xe xel wei xomek o is.” ");
INSERT INTO tbx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Woyom luw neil qayeeng wei Tambiy Ngandoung o wou e me xel dalus wei e beeng o is. ");
INSERT INTO tbx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Eivek boukeing masenghoing eno tambiy wei xomek xeitueing on qou luw me sekweyexe luw xe qatyex, woyom lutika eno moxo lis nipapu dalus qou lipekeing. ");
INSERT INTO tbx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tambiy wei xomek xeitueing eno qou luw me la eivek beeng me toung lul yaeing eno lam wou luw en moxo pup en xeilala en nambei xel wongis Anutu, e me nipapu dalus. ");
INSERT INTO tbx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Satiboukeing eno tambiy wei mi ngo qayeeng eno wong e xe xel belimbo la wou tambiy wei xomek xeitueing is qayeeng tine bei: “Wong tambiy yuw on la.” ");
INSERT INTO tbx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tambiy wei mi yei xomek xeitueing teyei eno neil wou Paulus bei, “Tambiy wei mi ngo qayeeng eno neil embei wang me Silas ghe na. Muw ghe na is laleim vevopeing.” ");
INSERT INTO tbx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ekom Paulus neil wou lei ngandoung wei xosepu yon: “Uw ne moux wei Rom o. Nambei nya xel wei mi ngo qayeeng eno se ngo qayeeng wei uw eno wo nimza, me yei bei uw a wong sewokeing ti o ma? Ekom xel leis uw bandaing me toung uw eivek xomek xeitueing. Om gweimbeeng xel embei qou uw xupekeing? Ma! Wong xel venaxow lam qou uw me la myayaing.” ");
INSERT INTO tbx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Lei ngandoung wei xosepu eno wong qayeeng tine wou tambiy wei mi ngo qayeeng o, me xel ngo bei Paulus me Silas on Rom yuw, om xel yaleeng. ");
INSERT INTO tbx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Woyom xel wei mi ngo qayeeng eno lam me beoux xow wou luw dom qou luw me la veil xomek xeitueing, de teling wou luw bei luw na veil beyeeng ngandoung on. ");
INSERT INTO tbx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ka Paulus aluw Silas lam myayaing veil xeitueing, luw la Lidia beeng, me la tyip wou liyeiw me byexaxoun xel en qayeeng valu, de woyom luw la. ");
INSERT INTO tbx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Ka luw la eivek beeng nayak Ampipolis me beeng nayak Apolonia, luw la tyip beeng nayak Tesalonika, nanghei inyon eno xomek qekueing ama wei Yudayeiw o ti toukale. ");
INSERT INTO tbx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paulus la eivek xomek qekueing ama nambei e xe kwa wei mi wong o, me eivek Sabat yal eno mi luk is xel en qayeeng wei di yeip eivek Anutu xe qapiya yo. ");
INSERT INTO tbx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Moxo mi neil Anutu xe qayeeng qes teyei me neil ambei nye, Kilisi tyek na qou myavanei ngandoung me na mey, dekakom tyek qandi lek veil meyeing. Moxo neil, “Yesu tiwei andi neilteyei wou xam ne, inye Kilisi.” ");
INSERT INTO tbx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Xel valu wei Yuda eno wongis me betiwou Paulus aluw Silas, me Grik valu ngandoung wei mi wo lalo wou Anutu eno betiwou luw. Me vex ngenong wei leind tata eno betiwou luw is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ekom Yudayeiw qouwou luw, om xel qou xel wei nilul o valu nanghei ingwei beyeeng vateivek nei, me qeku xel ngenong is me xel wo nol wou beyeeng ngandoung tiyon. Xel veimyend me la wou Jeson xe xomek me la yimexe Paulus aluw Silas bei na qou luw me na myayaing wou xel qendu ngandoung on. ");
INSERT INTO tbx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ekom xel se yeiwou luw, om xel tetei Jeson is liyeiw valu me qou xel me la wou xel gyovaxa wei beyeeng on, dom taxe bei, “Moux tine mi wo kwa nol me ghavineeng e lala eivek tembuing sapa nei, om gweimbeeng ne xel lam inye, ");
INSERT INTO tbx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","me Jeson qou xel me la eivek beeng. Xel moux dalus tine mi pyalek Sisa xe qayeeng, me xel mi neil embei, king nge toundei, e lei Yesu” ");
INSERT INTO tbx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Xel xomaxoneing is gyovaxa wei beyeeng nayak on ngo tine, eno xel tambak on etek ngandoung me di wo vyend lala. ");
INSERT INTO tbx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Woyom xel wong Jeson me lei yeiw ba yon xouv xomek wei ngoeing qayeeng o dom wong xel la. ");
INSERT INTO tbx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ka di wo mangamong en embei bouk, Paulus aluw Silas lindyeiw wong luw la beyeeng nayak Belia. Luw la tyip inyon, me xel la eivek Yudayeiw xe xomek qekueing ama. ");
INSERT INTO tbx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Xel Yuda wei mindei Belia eno xel xe kwa yon nimza ghanaw Yudayeiw wei Tesalonika yo, en xel ngo qayeeng wei Paulus neil on me xel laleind vind, teyei lek bouk eno xel mi pyaw qayeeng wei yeip eivek qapiya vambuing o me yeimbei xoulek wei Paulus neil on zonghek, o ma. ");
INSERT INTO tbx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Xel wei Yuda yon eno ngenong wongis, me Grik vex ngenong wei leitata yo, me moux wei Grik eno xouing wongis ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ekom xel Yudayeiw wei mindei eivek Tesalonika woulek bei Paulus di neil qayeeng wei Anutu xe yo eivek Belia, om xel la inyon is, me zeim moux alis vex on laleind lek me wong xel dalus etek mouyo. ");
INSERT INTO tbx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Woyom xel lindyeiw wo daing me wong Paulus la xo mamileeng vi nei, ekom Silas aluw Timote nanghei toundei Belia. ");
INSERT INTO tbx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Xel moux wei la is Paulus eno qou e me la beyeeng nayak Atens, de woyom Paulus wong qayeeng wou xel bei xel a neil wou Silas aluw Timote bei luw na wou e daing. ");
INSERT INTO tbx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ka Paulus di axe luw anghei Atens, moxo yei beyeeng ngandoung on pup en anutu tyonyeing ngenong. Om wong e lalei wo maying. ");
INSERT INTO tbx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Om moxo la eivek xomek qekueing ama wei xel Yudayeiw o me luk is Yudayeiw me xel amba wei mi wo lalo wou Anutu yo. De lek bouk titi moxo mi la beyeeng vateivek me luk is moux alis vex wei lam mindei inyon o. ");
INSERT INTO tbx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Xel moux wei lundpeyei nimza wei Epikurian me xel wei Stoik, eno wo veweeng is e en qayeeng. Xel valu teling, “Tambiy tiwei mi luk bandabanda nei embei neil va?” Om xel valu neil, “Beind moxo di neil qayeeng en anutuyeiw wei beyeeng bamba yo.” Xel neil tine en nambei Paulus di neil Xoulek Nimza en Yesu wei qandi lek veil meyeing o. ");
INSERT INTO tbx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Woyom xel qou Paulus me la qekueing ama wei xel kanzol lek lukendu Areopagus, nanghei inyon eno xel neil wou e, “Teyei bei xa ngo qayeeng vako tiwei wang di teyoxe me ghe wong elam ne? ");
INSERT INTO tbx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Wang wong qayeeng bange valu lam eivek xa nenyami, om xa bei ngo bei qayeeng tine qes ambei nya.” ");
INSERT INTO tbx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(De xel Atensyeiw dalus me xel amba wei mindei inyon eno se mi wo lulti qe xel mindei bandaing me mi luk en lulvako wei xel ngo yo.) ");
INSERT INTO tbx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Woyom Paulus nale ghey eivek qekueing ama wei xel kanzol lek lukendu Areopagus me neil: “Xam moux wei Atens! A xei xam ghe wo nimkanzek en wongeingis kwa leimalei wei lalo yo. ");
INSERT INTO tbx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","En nambei a la ghavinenyeing me na xei e wo nimza me na xei lul wei xam ghe mi wong lalo wou yo. Me a xei qeind ti xel byex qayeeng lek ambei nye: E NA WOU ANUTU TI WEI XA SE WOULEK O. Om Anutu tiwei xam seng woulek on xam ghe mi wo lalo bandaing wou e, om gweimbeeng ambei neil e xe qayeeng wou xam. ");
INSERT INTO tbx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Anutu tiwei toung tembuing me lulul dalus eivek o, inyon Tambiy Ngandoung wei tyoung aluw tembuing, me se mindei eivek xomek vambuing wei xel ev angya memend o. ");
INSERT INTO tbx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Me se mi qou vineing en lul wei xomaxoneing wong angya memend o, me se teyei bei qou lulti, en nambei e maxow wong mapieing me laweeng wou xomaxoneing me lulul dalusateiv. ");
INSERT INTO tbx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Eivek bu tixemou ne eno e toung xomaxoneing lam dei lek tembuing sapa, en kandek xel a mi gyeiteyei tembuing tambak, e maxow beyal bouk wei xel a mi mendei yo, me e maxow lax enghek wei xel xe tembuing o. ");
INSERT INTO tbx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Anutu wong ambei nye en kandek xomaxoneing gyimexe e me nam wou me boulek e zonghek en nambei se dei dingta veil xey. ");
INSERT INTO tbx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","‘En eivek Anutu eno xey a wo xomaxoneing me na toundei mapieing me na mi la me na loum me na dei lek tembuing.’ Nambei xam venaxow xe xel valu wei lupeyei eno neil embei, ‘Xe ne Anutu neuyeiw.’ ");
INSERT INTO tbx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nambei nyon xey a toundei nambei Anutu neuyeiw, om xey se bou naleind bei Anutu yon nambei ghol me silva me qakous, me xe se bou naleind bei e yon tenu bandaing wei xomaxoneing wong angya venaxow memend me lundpeyei wei xe venaxow o. ");
INSERT INTO tbx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Takwei eno xomaxoneing lundpeyei ma, om Anutu se neil qayeeng ti en vati wei xel mi wong o. Ekom gweimbeeng ne neil qayeeng nikanzek wou xomaxoneing dalus lek tembuing sapa bei xel pekwi xow. ");
INSERT INTO tbx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","En e maxow lax bouk wei embei tyek bong qayeeng en xomaxoneing dalus wei tembuing o, om beyal tambiy ti woy. Tambiy tine eno mey ekom Anutu piyexe e qandi lek veil meyeing.” ");
INSERT INTO tbx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Xel ngo Paulus neil qayeeng en xomaxoneing qandi lek veil meyeing, xel valu luk seloukeing lek e, ekom xel valu neil embei, “Xa bei ngo qayeeng valu en lul tine no.” ");
INSERT INTO tbx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dekalekom, Paulus la veil xel kanzol. ");
INSERT INTO tbx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Xel moux valu betiwou Paulus me wongis. Ti lei Dionisius, e kanzol wei xel mi qekuma lek lukendu Areopagus, me vex nge is ambei nyon e lei Damaris, me xomaxoneing valu beti wongis. ");
INSERT INTO tbx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kalekom, Paulus la veil Atens me la beyeeng nayak Korin. ");
INSERT INTO tbx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Nanghei inyon eno moxo la tyip wou Yuda ti, e lei Akwila. Tambiy on beeng qes anghei Pontus, e tiwei lam anghei Itali is venei Prisila yo, en nambei Klodias wo qayeeng wou Yudayeiw dalus bei xel na veil Rom. Om Paulus la en embei gyei xel, ");
INSERT INTO tbx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paulus mi dei me wo xuk is xel, en nambei Paulus, Akwila, Prisila, lal xouing mi wo xuk wei duweing sel o. ");
INSERT INTO tbx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Lek bouk tambak wei Sabat eno Paulus mi la eivek xomek qekueing ama wei Yudayeiw o, me neil qayeeng lumama wou Yudayeiw me xel Grik bei em beil xel lundlek. ");
INSERT INTO tbx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Woyom Silas aluw Timote lam anghei Masedonia, Paulus neil Anutu xe xoulek wou xel Yudayeiw teyei lek bouk tambak me neil wou xel bei Yesu yon Kilisi. ");
INSERT INTO tbx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ekom Yudayeiw se ngo e qe xel pesek e me lukyak lek moxo. Om Paulus pepa vegyuveeng veil e xe teimb me neil wou xel, “Wangwei xam a qou nilul, ond inyon di yeip wou xam venaxow, nimaying on se wou ay. Gweimbeeng ne tyek a na neil xoulek wou xel amba.” ");
INSERT INTO tbx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Woyom Paulus la veil xomek qekueing ama me la eivek xomek wei Titius Jastus wei xel amba yo eno nale paviy xomek qekueing ama wei Yudayeiw o, tambiy yon mi wong lalo wou Anutu. ");
INSERT INTO tbx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Klispas on gyovaxa wei xomek qekueing ama wei Yudayeiw o. E is venei neu dalus mi wongis Tambiy Ngandoung, me xel ngenong wei Korin eno ngo Paulus xe qayeeng me wongis de lipek. ");
INSERT INTO tbx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Boukeing ti eno Tambiy Ngandoung luk wou Paulus eivek ingwei mapekwi yo me neil: “Wa seng gwaleeng qe wa toumbale ding lek lukeing, de wa se mendei kanzek. ");
INSERT INTO tbx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","En a toundei is wang, om xelti se teyei bei zeim wang me bo nol wou wang, en nambei a xe xel ngenong toundei eivek beyeeng ngandoung tine.” ");
INSERT INTO tbx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Om Paulus toundei eivek Korin teyei lek vakovek qes ti me ela dentouk limti, me teyoxe Anutu xe xoulek wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ka Galio wo lei ngandoung wei seyap en provins Akaya, xel Yudayeiw qeku lekti me wo vevek is Paulus me qou e me la wong qayeeng en e. ");
INSERT INTO tbx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Xel wong qayeeng en e me neil, “Tambiy tine, mi teyoxe wou xomaxoneing bei xel se bongis petieing qe xel bong lalo wou Anutu en sakwaing ba.” ");
INSERT INTO tbx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ka Paulus embim a neil qayeeng nox wou xel, ekom Galio pekwi me neil wou xel Yudayeiw bei, “Wangwei tambiy tine qayil petieing o bo sewokeing ti wou xam, ond a teyeimbei ngo qayeeng wei xam o. ");
INSERT INTO tbx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Ekom xam ghe di pyanaleimim en qayeeng me leimim me xam venaxow xe petieing, om xam ghe lam wou ay. A se teyei bei ngo qayeeng en lulul ambei nyon, om xam venaxow menyex wou qayeeng ne.” ");
INSERT INTO tbx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Om moxo wong xel loum myayaing veil wongeing qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","De xel zeimaxoun Sostenes inyon gyovaxa wei xomek qekueing ama wei Yudayeiw o, me xel leis e paviy xomek wei ngoeing qayeeng o. Ekom Galio mou se di wounalei en lul ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus toundei eivek Korin teyei lek bouk matika. Dekalekom moxo ghanaw liyeiw dom qou sip me la provins Siria, Akwila luw venei Prisila la is e. Ka xel embei na, moxo qateiv luvelus veil nanghei beyeeng nayak Senklia en nambei tup qayeeng ti is Anutu. ");
INSERT INTO tbx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Xel la tyip beyeeng nayak Epeses, nanghei inyon eno Paulus ghanaw Prisila luw Akwila. De e maxow la eivek xomek qekueing ama wei Yudayeiw o me neil qayeeng wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Xel teling wou bei e toumendei bouk valu is xel, ekom moxo pesek. ");
INSERT INTO tbx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ekom ka e la, moxo neil wou xel, “Wangwei Anutu lalei devind nei ond tyek a noum wou xam.” Woyom moxo qou sip me la veil Epeses. ");
INSERT INTO tbx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Moxo la tyip Sisalia, dekakom moxo la pu wei Yerusalem nei me la neil bendiyeing wou xel kongrikesin on woy om la xo wei Antiok nei. ");
INSERT INTO tbx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Paulus la dei Antiok bouk valu, dekalekom qandi nanghei inyon me la beyeeng nge me la nge teyei lek tembuing danghei wei Galesia yon me Prigia, me byexaxoun xel betiyeing en qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Dekakom Yuda ti lei Apolos, tambiy wei beeng Aleksandlia, eno lam dei Epeses. Tambiy on mi luk qayeeng nimza, me moxo mi woulek e wo nimza en Anutu xe qayeeng wei di yeip eivek qapiya yo. ");
INSERT INTO tbx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Xel teyoxe e woy en sakwaing wei Tambiy Ngandoung o, me e luk is nikanzek me mi neil wou moux alis vex en Yesu bombek, ekom moxo woulek lipekeing wei Yoan o. ");
INSERT INTO tbx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Moxo neil qayeeng nikanzek eivek xomek qekueing ama wei Yudayeiw o. De Prisila me Akwila ngo e, luw qou e me la xomek wei luw o me neil sakwaing wei Anutu yo en Yesu wou e en kandek moxo boulek embo nimza. ");
INSERT INTO tbx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ka Apolos embei na Akaya, liyeiw wei mi dei Epeses eno byexaxoun e en qayeeng. Me byex qapiya wou xel betiyeing wei Akaya bei xel a qou e. Gyeik e la tyip inyon eno moxo wong vineing ngandoung wou eti yeiw wei Anutu wong lalei xeiles wou xel me xel wongis o. ");
INSERT INTO tbx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Moxo wo nikanzek lek qayeeng neileing bei pelipek Yudayeiw nind qayeeng wou xomaxoneing mendghalus. Moxo neil xoulek eivek Anutu xe qapiya me talex e yeip yaing bei Yesu yon Kilisi. ");
INSERT INTO tbx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ka Apolos toundei eivek Korin, Paulus la ghavineng eivek beyeeng wei toundei lek lukendu nei dekakom la tyip Epeses. Nanghei inyon eno moxo la tyip wou xel betiyeing valu ");
INSERT INTO tbx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","me teling wou xel, “Beip xam ghe qou Laweeng Vambuing gyeik xam ghe wongis o?” Xel lenghek bei, “Ma yo, xa se ngo bei inyon Laweeng Vambuing ti toundei.” ");
INSERT INTO tbx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Om Paulus teling, “Woyom xam ghe qou lipekeing vati?” Xel neil, “Yoan xe lipekeing.” ");
INSERT INTO tbx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","De Paulus neil embei, “Yoan xe lipekeing on lipekeing wei pekwieing xow o. Moxo neil wou xel xomaxoneing on bei xel bongis tambiy tiwei di lam yus en e yo, inyon Yesu.” ");
INSERT INTO tbx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ka xel ngo qayeeng tine, xel qou lipekeing eivek Tambiy Ngandoung Yesu lei. ");
INSERT INTO tbx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Woyom Paulus li mema lek xel, me Laweeng Vambuing lam lek xel, de xel neil qayeeng eivek vya leimalei me neil qayeeng poropet. ");
INSERT INTO tbx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Xel moux dalus tiyon teyei lek xoumeeng yuw. ");
INSERT INTO tbx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Om Paulus la eivek xomek qekueing ama wei Yudayeiw o me neil qayeeng nikanzek nanghei inyon teyei lek dentouk qes yal, moxo luk is nikanzek wou xel me veil xel lundlek en lul dalus wei Anutu xe tete lalei yo. ");
INSERT INTO tbx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ekom xel valu laleind wo nikanzek, om xel se wongis, me eivek xomexomek mendghalus eno xel neil qayeeng nol lek Sakwaing Tiyon. Om Paulus qou xel betiyeing me la veil xomek qekueing ama, de taxombouk eno moxo mi luk wou xel eivek Tiranus xe xomek wei teyoxeing o. ");
INSERT INTO tbx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Moxo mi wong ambei nye teyei lek vakovek qes yuw, en kandek Yudayeiw dalus me xel Grik dalus wei mindei eivek provins Esia eno na ngo Tambiy Ngandoung xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anutu wong lulvako leimalei wei nikanzek eno nangya Paulus mema, ");
INSERT INTO tbx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","om xel moux alis vex mi qou angesip me qaeing myasepu wei Paulus axlek o, dekakom xel mi qou me la toung lek xel wei vanei wong xel o, dom vanei wei xel eno ma, me laweeng nol eno la veil xel is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Xel Yuda valu wei mi la ghavinenyeing me tiy laweeng nol. Xel valu wong en embei neil Tambiy Ngandoung Yesu lei, me na tiy laweeng nol veil xel moux alis vex. Xel mi neil ambei nye, “Eivek Yesu lei, e tiwei Paulus mi neil e xe qayeeng o, a neil nikanzek wou wang bei lam myayaing.” ");
INSERT INTO tbx_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Lumuki leitata wei Yudayeiw o ti lei Skeva eno neu moux lim yuw, eno xel mi wo kwa tine wou laweeng nilul. ");
INSERT INTO tbx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Bouk ti, eno laweeng nol neil elox wou xel, “A woulek Yesu, me a woulek Paulus, ekom xam on eti yeiw?” ");
INSERT INTO tbx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Woyom tambiy tiwei laweeng nol mindei eivek eno vyeip lek xel me leis xel dalus. Moxo leis xel on wo nol ayang, omva xel pek veil xomek on me la xeind touk is gyand. ");
INSERT INTO tbx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Yudayeiw dalus me xel Grik wei mindei eivek Epeses eno ngo tine, om xel yaleeng ngandoung mouyo, om xel sanghoxe Tambiy Ngandoung Yesu lei. ");
INSERT INTO tbx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Xel ngenongakes wei wongis woy, eno lam wou xel moux alis vex ba yon mendghalus, me neil xel xe sewokeing wei xel mi wong takwei eno teyei. ");
INSERT INTO tbx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Moux alis vex ngenong wei mi wo wevek me palak, eno qekuwou qapiya yon me lam sei lek nenyex eivek xel moux alis vex on mendghalus. Xel pyaw memend wou qapiya wei xel xouv eno teyei lek 50,000 malew selewa. ");
INSERT INTO tbx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Eivek sakwaing ambei nye eno Tambiy Ngandoung xe qayeeng wo ngandoung me vula wo tambak is nikanzek. ");
INSERT INTO tbx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ka lul dalus tine tyip woy, Laweeng Vambuing wo kwa wou Paulus bei e na Masedonia me Akaya dekakom na Yerusalem. Om moxo neil, “Kalekom a na Rom is ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Woyom ka moxo wong e xe vineing aluw, Timote me Elastus la Masedonia, dom e maxow toundei eivek provins wei Esia nei me e den nayaka. ");
INSERT INTO tbx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lek bouk kayon eno xel valu wong vevek en qayeeng zeyi Sakwaing Tiyon. ");
INSERT INTO tbx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Moux ti mindei, e lei Demitrius, tambiy on mi yeiwou lulul angya silva me yeiwou tenu nayak nayak teyei lek ambei xomek lalo wei anutu vex Atemis nangya silva, moxo se mi qou malew nayaka lek xuk wei mi wong on. ");
INSERT INTO tbx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Moxo qeku xel xouing lekti, is xel wei mi wong xuk bange yo, me neil: “Xam moux, xam ghe boulek bei xey a mi qou malew wo nimza en xuk tiwei xey a di wong ne. ");
INSERT INTO tbx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Me xam ghe wei me ghe ngo Paulus tiwei di wong me puw xomaxoneing ngenong eivek Epeses nei me pelipek xel laleind, de se eivek Epeses venaxow, qe paviy embim na eivek tembuing dalus wei provins Esia yo is. Me neil embei, ‘Anutu wei xey a wong angya memend ne se anutu zonghek.’ ");
INSERT INTO tbx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Qayeeng tiwei Paulus di neil ne teyei bei bo xe xe xuk vateivek ne lei bo nol. Me lul nge is ambei nyon, qayeeng wei e ne tyek teyeimbei bong xomek qekueing ama wei anutu vex Atemis o bong ambei lul bandaing eivek woueing nalei wei xomaxoneing o, me takwei eno xomaxoneing wei provins Esia me tembuing sapa wei xel mi wo lalo wou anutu vex tine yo. Ekom qayeeng wei Paulus eno embei semaleeng lei laeing wei e yo.” ");
INSERT INTO tbx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Xel ngo qayeeng tine, eno xel laleind wo myavanei me taxe bei, “Atemis anutu wei Epeses, vex on lei laeing!” ");
INSERT INTO tbx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Beyeeng ngandoung on dalus wo nindenduing ngenong, me xomaxoneing dalus on zeimaxoun Gaius me Alistakas me veimyend me la beyeeng wei qekueing ama yo. Tambiy yuw on nanghei Masedonia eno luw mi ghavineng is Paulus. ");
INSERT INTO tbx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus venaxow embei na senghoing is moux alis vex on, ekom xel betiyeing neil axound bei e se na. ");
INSERT INTO tbx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Xel seyap valu nanghei Esia yon Paulus xe gweleeng, om xel wong qayeeng la wou Paulus bei, e se na eivek beyeeng wei qekueing ama yon. ");
INSERT INTO tbx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Xel xomaxoneing dalus on lundpeyei yon la bandabanda. Xel valu di taxe lul nge de valu di taxe lul bange. Xel ngenong on se woulek bei xel di qekuma en vati. ");
INSERT INTO tbx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Xel Yudayeiw tendu Aleksanda la mya nei wou xomaxoneing on mendghalus, xel valu wei toungale yon yei me neil embei, tambiy kawei sewokeing qes o inyon. Om Aleksanda embei neil qayeeng nox wou xel om pepeeng xel angya mema bei xel se baluk. ");
INSERT INTO tbx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ekom xel yei bei e yon tambiy wei Yuda yo ti, om moux alis vex on dalus ghak niseikeing teyei lek seivma yuw me neil embei, “Atemis wei Epeses ne lei yon ngandoung!” ");
INSERT INTO tbx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kuskus wei beyeeng ngandoung Epeses on pepeeng moux alis vex on bei xel denduing ama de neil: “Xam moux wei Epeses on ngo, xomaxoneing eti se woulek bei Epeses ne beyeeng wei yeingteyei xomek wei anutu vex Atemis o, me yeiteyei qakous vambueing tiwei tei lam anghei tyoung o? ");
INSERT INTO tbx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Xomaxoneing ti se teyei bei pyalek qayeeng tine, nambei nyon xam deduingma, xam seng bo daing me ghe bong lulti. ");
INSERT INTO tbx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Xam ghe qou tambiy yuw ne me ghe lam inye, ekom luw se panax lulti eivek xomek lalo, o lukyak lek xe xe anutu vex. ");
INSERT INTO tbx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Woyom wangwei Demitrius me e xe xel xukxe eno xe qayeeng ti wou tambiy ti, ond bouk wei ngoeing qayeeng o di yeip. Me xel seyap toundei, bei xel menyex wou xel xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ek wangwei xam xe qayeeng valu nanghei, ond xam ghe nyeis inyon a mey eivek xel wei qekuma yon. ");
INSERT INTO tbx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","A neil ambei nyon en xey a toundei eivek nimaying ngandoung om seyap wei Rom eno teyei bei bo qayeeng en xey, en kwa wei xey a wong gweimbeeng ne eno qes ma. De wangwei xel teling xey bei xey a lam qekuma me na ghak enva, on tyek xey se teyei bei neil qayeeng ti nox.” ");
INSERT INTO tbx_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ka kuskus neil qayeeng tine woy, moxo wong xel xomaxoneing on la. ");
INSERT INTO tbx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Ka lukeing ngenong wei xomaxoneing on ma, Paulus taxe xel betiyeing qeku lam wou e me luk is xel. Woyom moxo neil qayeeng xeilala wou xel woy, me puw xel memend dom la Masedonia. ");
INSERT INTO tbx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Moxo la ghavineeng eivek danghei tiyon, me wo qayeeng ngenong wou xomaxoneing bei na byexaxoun xel, de woyom la Grik wei xel mi taxe bei provins Akaya is ambei nyon, ");
INSERT INTO tbx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","moxo dei nanghei inyon teyei lek dentouk qes yal. Dekakom Yudayeiw tup qayeeng lekti, bei nyeis e gyeik ingwei embei na Siria yo, om moxo embei nox me na Masedonia. ");
INSERT INTO tbx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Tambiy wei beyeeng Belia, inyon Sopata, Pilas neu moux, Alistakas me Sekandas on lam anghei Tesalonika, Gaius nanghei Debi, Timote is ambei nyon, me Tikikas me Tlopimas nanghei provins Esia nei. ");
INSERT INTO tbx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Xel moux ti beimambei yon la tax en xa me di axe xa nanghei Troas. ");
INSERT INTO tbx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ka bouk wei Yaeing Belet Wei Yis Ma Veil o, eno xa qou sip me na la veil Pilipai, deka bouk lim la veil eno xa la wou xel wei la Troas atax o, me nanghei inyon eno xa dei teyei lek bouk lim yuw. ");
INSERT INTO tbx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Lek bouk ti tax wei Sounda yo xa xouing a lam qekuma lekti bei dembu belet me na gha pasa. Paulus luk wou xel xomaxoneing on en nambei moxo tyek na veil xel lek bouk yanyeing, om moxo di puw qayeeng me ela boukeing masenghoing. ");
INSERT INTO tbx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Inyon lam ngenong di tum eivek xomek lalei tiwei gheyapu yo, nanghei ingwei xa di qekuma yo. ");
INSERT INTO tbx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","De yak ghavis ti toundei paviy xomek mya nayak wei qoueing laweeng o e lei Yutikus, Paulus di puw qayeeng ngenong om moxo ma yeip me nalei maxow. Dekakom moxo oing me teila tembuing nanghei xomek lalei tiwei yal o, om xel la zeim e lek ekom moxo mey. ");
INSERT INTO tbx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paulus la xonei, me yeip lek ghavis on neing, de zeim e mema me neil, “Xam seng detek ti, moxo nanghei di pi yo!” ");
INSERT INTO tbx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Woyom moxo lox me la gheyapu nei de dembu belet me ya is moux alis vex. Dekakom moxo mi luk me ela woyaing, om moxo la. ");
INSERT INTO tbx_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Yak ghavis on toundei mapieing, me xomaxoneing on qou me la beyeeng de xel laleind wo nimza. ");
INSERT INTO tbx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Xa la eivek sip me na la beyeeng nayak Asos, me na di axe Paulus anghei Asos, e maxow neimbei xa na tax, en embei na vaxa. ");
INSERT INTO tbx_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","De moxo la tyip wou xa ghei Asos, om xa qou e lam lek sip me xa xouing a la beyeeng Mitilini. ");
INSERT INTO tbx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Yanyeing eno xa la eivek sip anghei inyon me na la tyip tembuing nayak Kios eivek mamileeng. De yanyeing nge eno xa la liveil me na teila tembuing nayak Samos eivek mamileeng, de yanyeing nge eno xa la tyip beyeeng nayak Miletus. ");
INSERT INTO tbx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paulus wou eivek nalei woy me qou sip me ghanaw Epeses en embei se mendei enden eivek provins Esia, qe embei na daing me na Yerusalem, wangwei e teyei nei, ond embei gyei bouk wei Pentikos o nanghei Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nanghei Miletus, Paulus wong qayeeng la wou teivateiv wei kongrikesin wei Epeses bei xel nam wou e. ");
INSERT INTO tbx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Xel la tyip woy, woyom moxo neil wou xel, “Xam ghe woulek kwa wei a mi wong gyeik a mindei is xam taxombouk o, myaxeeng wei a lam wou xam eivek provins Esia yo. ");
INSERT INTO tbx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","A mi wong Tambiy Ngandoung xe xuk me na mi beoux xow is mang louk, de na mi qalei nimaying wei Yudayeiw mi wong wou ay yo. ");
INSERT INTO tbx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Xam ghe woulek bei a se xaleeng qe a mi neil qayeeng nimza wei embei devind xam o, me na mi teyoxe xam eivek beyeeng senghoing me na la xomek titi is me na teyoxe xam. ");
INSERT INTO tbx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","A mi neil e yeip yaing wou Yudayeiw me Grikyeiw bei xel pekwi xow me noum wou Anutu me bongis xe xe Tambiy Ngandoung Yesu. ");
INSERT INTO tbx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Me gweimbeeng, Laweeng Vambuing neil wou ay bei a na Yerusalem, de a se woulek vati wei embei balwou ay anghei inyei yo. ");
INSERT INTO tbx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ekom a woulek bei eivek beyeeng ngandoung sapa yon eno Laweeng Vambuing peti ay, bei tyek a balwou nimaying ngenong de xel a toung a na eivek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ekom a se axe bei mapieing wei ay eno inyei lul nimza ti qe inye bandaing, en kandek a bong xuk pok me xuk wei Tambiy Ngandoung Yesu wong wou ay eno ema bole. Me na bong xuk tiwei neileing Anutu xe Xoulek Nimza wei lalei xeiles o. ");
INSERT INTO tbx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“De gweimbeeng a woulek bei xam wei a neil qayeeng qes wei tete lalei wou xam o eno tyek xam seng nox me na gwei a manghalus no. ");
INSERT INTO tbx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nambei nyon, a neil e gyeip yaing wou xam gweimbeeng ne bei wangwei xel ti qou myaveweeng wei meyeing luta yo, on inye a se wong esewok. ");
INSERT INTO tbx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","En nambei Anutu xe qayeeng qes wei xam a being boulek, eno a se axvun. ");
INSERT INTO tbx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Xam ghe gwei xow teyei, me moux alis vex dalus wei Laweeng Vambuing wong wou xam bei xam ghe gweiteyei yo, xam on Anutu xe gyovaxa wei kongrikesin o. Wei e xouv xam angya emaxow gyand o. ");
INSERT INTO tbx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ka a bei na ekom a woulek bei, naw bemeeng tyek nam eivek xam senghoing me bo nol wou sipsip yeiw ne. ");
INSERT INTO tbx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","De xam venaxow xe xel valu tyek qandi me bong qayeeng tyonyeing me na puw xel betiyeing valu betiwou xel. ");
INSERT INTO tbx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Om xam ghe gweiteyei xow, xam ghe bounaleim bei teyei lek vakovek qes yal eno a se mi tip neileing wou xam titi boukeing aluw bendiyeing is mang louk. ");
INSERT INTO tbx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Gweimbeeng a toung xam eivek Anutu mema, en ambei xam ghe bou naleimim en e xe qayeeng wei lalei xeiles o. Lalei xeiles tine eno teyeimbei bo nikanzek wou xam, me tyek teyeimbei bong lulul nimza dalus wei Anutu mi wong wou xomaxoneing wei e wong xel wo vambuing o. ");
INSERT INTO tbx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","A se mi xei manglek silva me ghol me qaeing wei xelti xe yo. ");
INSERT INTO tbx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Xam venaxow ghe woulek woy bei a maxow memang ne mi wong vineing wou xow me na mi vind xel wei mindei is ay yo. ");
INSERT INTO tbx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Eivek lul tambak wei a mi wong o, a talex wou xam bei xey a betiwou kwa wei xey a bo xuk nikanzek. En kandek xey a devind xel wei nikanzek maeing o, xey a bou naleind en qayeeng wei Tambiy Ngandoung Yesu venaxow neil o: ‘Inye mata nimza ena wou xel wei mi tatei memend o ghanaw xel wei mi qou e lam wou xow o.’” ");
INSERT INTO tbx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paulus neil qayeeng tine woy, woyom moxo ev vaxa qatu eivek dom zeimema is xel gyovaxa yon dalus. ");
INSERT INTO tbx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Moxoyeiw dalus eng me zeimaxoun Paulus dom ya e ling. ");
INSERT INTO tbx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Xel xouing laleind pyaxow en qayeeng wei e neil o, en tyek xel se nox gyei e ma no. De woyom xel qou e me la eivek sip. ");
INSERT INTO tbx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Ka xa la veil xel teivateiv on, xa la ingwei mamileeng nei me na qou sip de sepa me na la bombek wou ailan Kos. Deka woyaing xa la veil ailan Rodes me na la tyip beyeeng nayak Patara. ");
INSERT INTO tbx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Nanghei inyon eno xa xei sip ti embei na distrik Ponisia, om xa la eivek sip tiyon me sepa me na la. ");
INSERT INTO tbx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ka xa ghei di xeip lek mamileeng eno xa xei la ailan Saiprus nanghei mema qeinz, ekom xa ghanaw tembuing nayak eivek mamileeng on me na la tyip Siria. Xa la liveil anghei beyeeng nayak Taia, nanghei inyon eno sip la toung qoupek teila. ");
INSERT INTO tbx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Xa xei xel betiyeing nanghei inyon, om xa dei is xel teyei lek bouk lim yuw. Eivek Laweeng Vambuing eno xel neil wou Paulus bei e se na pu Yerusalem nei. ");
INSERT INTO tbx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Ekom xa xe seivma la wou eivek, om xa ghanaw beyeeng on me na la. Xel betiyeing dalus lis venei neu xel xouing qou xa me la myayaing veil beyeeng on, de xa ev vaxami qatu eivek lek luzeeng wei mamileeng vi yon de na zeimemami. ");
INSERT INTO tbx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ka xa puw ama memami woy, woyom xa lek la sip, de moxoyeiw lox bend. ");
INSERT INTO tbx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Xa la veil Taia, dom na la tei beyeeng Tolemes. Xa neil bendiyeing wou xel lingyeiw dom na toundei is xel bouk ti. ");
INSERT INTO tbx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lek bouk nge xa la tyip Sisalia me na toundei eivek Pilip xe xomek inyon sinale ti, e eivek xel lim yuw on eno ti wei mi vind xel sinaleyeiw o. ");
INSERT INTO tbx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Moxo neuyeiw vexawo vey wei mi dei paleveeng, eno xel mi neil xoulek ambei poropet. ");
INSERT INTO tbx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ka xa dei teyei lek bouk valu eivek Sisalia, poropet ti lei Agabus eno lam veil Yudia me lam axo wei Sisalia ne. ");
INSERT INTO tbx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Moxo lam wou xa, me qou Paulus xe let, de tup emaxow mema luw vaxa de neil, “Laweeng Vambuing neil ambei nye, ‘Eivek sakwaing tine Yudayeiw wei mindei eivek Yerusalem eno tyek bako tambiy tiwei e xe let ne yo me na toung e na eivek xel amba memend.’” ");
INSERT INTO tbx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Xa ngo tine, eno xa me xel xomaxoneing on eno xa tay wou Paulus bei e se na pu wei Yerusalem nei. ");
INSERT INTO tbx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Woyom Paulus neil embei, “Xam ghe di eng me ghe wong a laleing pyaw xow en va? A xeiwou xow woy bei xel a toung ay eivek xeitueing, me xel nyeis a mey nanghei Yerusalem en Tambiy Ngandoung Yesu lei.” ");
INSERT INTO tbx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Paulus wo nikanzek bei embei na, om xa tip lukeing me na neil, “Lul wei Tambiy Ngandoung wounalei bei etyip, ond inyon etyip.” ");
INSERT INTO tbx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ka bouk valu la veil, xa xeiwou xow me na la pu wei Yerusalem nei. ");
INSERT INTO tbx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Xel betiyeing valu wei mindei Sisalia eno lam is xa me qou xa me la Nason wei Saiprus eno beeng. Inyon betiyeing wei takwei yo ti wei tyek xa toumendei is e yo. ");
INSERT INTO tbx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ka xa la tyip Yerusalem, eno xel lingyeiw qou xa is xeilala. ");
INSERT INTO tbx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Yanyeing eno Paulus me xa dalus a la xei Jems, me teivateiv dalus eno lam toundei inyon. ");
INSERT INTO tbx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paulus neil bendiyeing wou xel, de neil wou xel en vati wei Anutu wong eivek xel amba senghoing en e xe xuk wei wong o. ");
INSERT INTO tbx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ka xel teivateiv ngo Paulus xe qayeeng woy, xel sanghoxe Anutu. De xel neil wou Paulus: “Ling, wang wei, xel ngenongakes wei Yuda eno wongis, om xel dalus on di luk ngenong en qayeeng petieing wei Mose yo. ");
INSERT INTO tbx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ekom xel on valu neil wou xel en wang bei, wang di teyoxe Yudayeiw dalus wei mindei eivek xel amba senghoing bei xel a saing Mose xe petieing, de neil wou xel bei xel se ghuw neundyeiw ninavi, o xam se betiwou kwa wei takwei yo. ");
INSERT INTO tbx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tyek xey a bong vati? Gyeik xel a ngo inye neing bei wang lam, ");
INSERT INTO tbx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","om wong vati wei xa bei neil wou wang ne. Inyon moux vey toundei is xey, xel eti yeiw wei neil qayeeng zonghek ti is Anutu yo. ");
INSERT INTO tbx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Qou xel moux beimambei ne, me xam xouing betiwou kwa wei deing vako yo me wa dexouv xel xe da en kandek xel a puw lund velus veil. Woyom tyek xel dalus boulek zonghek bei neing ma veil qayeeng tiwei xel byex lek wang ne, ekom wamaxow mendi betiwou petieing. ");
INSERT INTO tbx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","De xel amba wei wongeingis, eno xey a byex qapiya wou xel bei xel gyeiteyei xow en yaeing leliy wei xel sei da wou anutu tyonyeing o, me xel se gya leliy wei gyand toundei eivek o, me leliy leyeis wei xel tup xel kwend me xel se bong kwa nilul wei kwapesiv o.” ");
INSERT INTO tbx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Paulus qou xel moux wei xel neil qayeeng zonghek is Anutu woy yo, de yanyeing eno emaxow betiwou kwa dalus wei e bei bo vako yo is xel. Woyom moxo la ingwei xomek vambuing nei me neil wou lumukiyeiw en bouk nge wei tyek xel bo vako yo de tyek xel titi nam a toung xel xe da. ");
INSERT INTO tbx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Gyeik bouk lim yuw embim nama, xel Yudayeiw valu nanghei provins wei Esia eno yei Paulus eivek xomek vambuing. Om xel zeim moux dalus on laleind lek me zeimaxoun e, ");
INSERT INTO tbx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","de xel taxe niseikeing bei, “xam moux wei Israel o, vind xa! Moux tine inye tambiy wei mi teyoxe xomaxoneing dalus la danghei danghei nei me neil nilul lek xe xe xel xomaxoneing me Mose xe petieing me beyeeng tine. Me se tine venaxow, qe qou Grikyeiw me la eivek xomek vambuing lalei me wo nol wou xomek vambuing ne wo nilaxes.” ");
INSERT INTO tbx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(En nambei takwei eno xel yei Tlopimas wei Epeses o toundei eivek Yerusalem is Paulus, me xel embeik nge Paulus qou tambiy on me la eivek xomek vambuing on lalei.) ");
INSERT INTO tbx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Xel xomaxoneing dalus wei beyeeng ngandoung on etek mouyo, me xomaxoneing dalus veimyend me lam anghei danghei danghei nei. Me zeimaxoun Paulus, xel tetei e veil tete lalei wei xomek vambuing on, dom xel wo daing me toung tete mya dalus zeyi. ");
INSERT INTO tbx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Kalekom xel di wong en embei nyeis e, om xel wong qayeeng la wou vevekyeiw xe lei ngandoung wei Rom o bei beyeeng ngandoung wei Yerusalem eno neilama me di leis ama bandabanda. ");
INSERT INTO tbx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Moxo wo daing me qou beyeiv xel lei ngandoung me xel vevek valu dom xel veimyend me la wou xel qendu ngandoung on. Gyeik xel on yei lei ngandoung is e xe xel vevekyeiw, xel tip de se leis Paulus no. ");
INSERT INTO tbx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Lei ngandoung on lam paviy me zeimaxoun Paulus me luk nikanzek wou xel vevek on bei xel atup e nangya sen yayuw. Woyom moxo teling Yudayeiw bei, tambiy yon eti me vati ingwei e di wong on. ");
INSERT INTO tbx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Xel qendu ngandoung on valu taxe lul nge de xel valu taxe lul bange me neil qayeeng la bandabanda, om lei ngandoung wei xel vevek o se teyei bei ngo wou qayeeng qes, om luk nikanzek wou xel vevek bei xel a qou Paulus me na eivek bend. ");
INSERT INTO tbx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ekom gyeik Paulus la tyip wou lewing, xel vevekyeiw yei moux alis vex on ngenong embei nyeis e, om xel qalei moxo me la. ");
INSERT INTO tbx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Xel moux alis vex wei di betiy xel on taxe niseikeing bei, “Leis e mey!” ");
INSERT INTO tbx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ka vevekyeiw qou Paulus me embei na eivek bend, moxo teling wou lei ngandoung bei, “Teyei bei a neil qayeeng ti wou wang?” Lei ngandoung neil embei, “Wang woulek Grik vyend? ");
INSERT INTO tbx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Beip wang on Izip, tiwei wo vevek wou seyap de qou 4,000 moux wei mi wong vevek en ngeyeing me la eivek tembuing bandaing wei bouk valu la veil o?” ");
INSERT INTO tbx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulus neimbei, “A ne Yuda ti, nanghei Tarsus eivek Silisia, a bang nei lei laeing. Teyeimbei a baluk wou xel xomaxoneing ne.” ");
INSERT INTO tbx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Tambiy wei Lei ngandoung on lewexe lek telinyeing tiyon, Paulus nale lek lewing dom pepeeng xel qendu ngandoung on. Ka xel denduing ma, moxo luk wou xel eivek Yuda vyend. ");
INSERT INTO tbx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Xam lingyeiw me xam mangyeiw, xam ngo a xe qayeeng wei ambei neil gweimbeeng ne eno qes teyei.” ");
INSERT INTO tbx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Xel ngo moxo di luk wou xel eivek xel venaxow vyend Hibru, om moxoyeiw denduing ma. De Paulus neil embei: ");
INSERT INTO tbx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","A ne Yuda ti, a umbek eivek Tarsus wei Silisia nei, ekom a ling eivek Yerusalem de Gameliel mi teyoxe ay en petieing wei Mose xe yo, me a mi byexaxoun Anutu xe kwa wei lalei vind xey nambei xam valu ghe di wong gweimbeeng ne. ");
INSERT INTO tbx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","An di wo nol wou xel wei wongis bei na nyeis xel amey, xel wei mi betiwou sakwaing tine, a zeimaxoun xel moux alis vex me na toung xel la eivek xomek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Lumuki lukanzek me xel kanzol dalus tyek na neil a teyei. A qou qapiya wou xel me na la wou lingyeiw eivek Damaskus, me na la inyei bei na bako xel xomaxoneing nanghei inyon me na qou xel me na nam Yerusalem en xel teivateiv bo myaveweeng wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Bendiyeing wei seivma evlek a lam paviy Damaskus, de lutika eno xeiyaing teleing ti lam anghei tyoung gheyapu nei me tel evivekwou ay. ");
INSERT INTO tbx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","A teila lek tembuing me na ngo vya ti neil wou ay, ‘Sol! Sol! Nambei nya wang di wo nol wou ay?’ ");
INSERT INTO tbx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“A teling bei, Tambiy Ngandoung, ‘Wang eti?’ “Moxo neil eloum bei, ‘A Yesu wei Nasaret, tiwei wang di wo nimaying wou yo.’ ");
INSERT INTO tbx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","A xe xel wei mi la is ay yo eno yei xeiyaing, ekom xel se woulek tambiy tiwei di luk is ay eno vya. ");
INSERT INTO tbx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“De a teling, Tambiy Ngandoung, ‘Tyek a bong vati?’ Tambiy Ngandoung neil, ‘Qandi lek me la eivek Damaskus. Nanghei inyon tyek xel a neil wou wang en vati wei wambei bong o.’ ");
INSERT INTO tbx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","A xe xel wei la is ay eno zeim a memang me xa la eivek Damaskus, en nambei xeiyaing on byex a mang tekzeyi. ");
INSERT INTO tbx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Tambiy ti lei Ananias lam me yei ay. Moxo mi wevek Anutu xeinghembi me mi betiwou qayeeng petieing wo nimza. Me Yudayeiw wei mindei inyon eno mi neil embei e moux nimza. ");
INSERT INTO tbx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Moxo nale paviy ay me neil, ‘Ling Sol, wa mamghalus e gyeina!’ De lutika eno a manghalus yeila me a xei e. ");
INSERT INTO tbx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Woyom moxo neil: ‘Anutu wei xe mendyeiw eno beyal wang bei wang boulek e xe lalei vineing me ghe gwei Tambiy Tiwei Bombek ayang o me na ngo e xe qayeeng eivek e mya. ");
INSERT INTO tbx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Wang teyei lek e xe tambiy wei yeimawou woy o, om tyek wa qou vati wei wang wei lek mamghalus me ghe ngo yo me na neil teyei ena wou xomaxoneing sapa. ");
INSERT INTO tbx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Om gweimbeeng ne wang di axe vati? Qandi lek me qou lipekeing. De taxe e lei en e sekweyexe wa xe sewokeing veil o.’ ");
INSERT INTO tbx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ka a loum Yerusalem me na di zeimemang eivek xomek vambuing, a xeip naleing ma, ");
INSERT INTO tbx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","me na xei Tambiy Ngandoung luk wou ay nambei inye. ‘La daing, me la veil Yerusalem lutika, en tyek xel se ngo wa xe qayeeng wei wambei neil a teyei yo.’ ");
INSERT INTO tbx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“A lewexe bei, ‘Tambiy Ngandoung, xel moux tine woulek bei a la Yudayeiw xe xomek qekueing ama, me na la nge me na toung moux alis vex wei wongis wang eno eivek xeitueing de na leis xel. ");
INSERT INTO tbx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","De gyeik xel leis Setepan mey, wa xe tambiy wei mi neil wa xe xoulek eno a toukale paviy me na xei e gyand qapyex o, me na xeiteyei eti yeiw wei leis e yo xe teimb.’ ");
INSERT INTO tbx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Woyom Tambiy Ngandoung neil wou ay, ‘La. Tyek a bong wang na dingta lul nei wou xel amba.’ ” ");
INSERT INTO tbx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Xel qendu tiyon ngo Paulus deka moxo neil tine. Woyom xel taxe niseikeing bei, “Leis e mey! Tambiy ambei nyon se toumendei mapieing lek tembuing!” ");
INSERT INTO tbx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ka xel wo vyend me kwax xel xe teimb ding me nex ela me nex vegyuveeng la gheyapu, ");
INSERT INTO tbx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","om lei ngandoung wei xel vevek o wo qayeeng nikanzek bei xel a qou Paulus me na bend. Moxo neil wou xel bei xel sesa e me bo telinyeing me gyimexe nimaying tiyon qes, embei boulek bei xel xomaxoneing on di wo vyendlek e en va. ");
INSERT INTO tbx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Ka xel tup Paulus mema vaxa bei na sesa e, Paulus neil wou beyeiv wei xel xe yo, wei toukale paviy on me neimbei, “Inye se la teyei lek petieing bei wa sesa tambiy wei Rom wei xam seng ghei wo qayeeng en e yo?” ");
INSERT INTO tbx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Beyeiv ngo qayeeng tine, om moxo la neil wou lei ngandoung wei vevekyeiw o. Moxo teling, “Tyek wang bong ambei nya? Moux tine inye tambiy wei Rom o.” ");
INSERT INTO tbx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Lei ngandoung wei xel vevek o la wou Paulus me teling, “Neil wou ay, inyon wa Rom ti ei?” Moxo lewexe, “Ee inye ay yo.” ");
INSERT INTO tbx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Woyom lei ngandoung neil wou e, “A wong malew ngandoung bei na bong ambei tambiy wei Rom o.” Paulus neil elox bei, “Ekom a umbek eivek beyeeng ne nambei tambiy wei Rom o ti.” ");
INSERT INTO tbx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Eti yeiw wei di wong en embei sesa e eno duxeind lutika. Deka lei ngandoung woulek bei Paulus on tambiy wei Rom, om moxo yaleeng en venaxow neil wou xel vevek bei xel a tup Paulus en sen. ");
INSERT INTO tbx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Yanyeing eno lei ngandoung wei xel vevek o embei boulek qes bei nambei nya ekom Yudayeiw byex qayeeng lek Paulus, om moxo kwax sen veil Paulus. De wong qayeeng la wou xel kanzol me lumuki leitata bei xel nam qekuma. De qou Paulus me lam wong e nale wou xel mendghalus. ");
INSERT INTO tbx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paulus doma wou xel kanzol me neil, “Xam lingyeiw eivek a laleing, a mi la bombek me sewokeing ma veil ay wou Anutu manghalus me e lam tyip gweimbeeng.” ");
INSERT INTO tbx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Moxo neil ambei nyon, eno lumuki lukanzek Ananias neil nikanzek wou xel moux wei toukale paviy Paulus on bei xel petapexe e mya. ");
INSERT INTO tbx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Woyom Paulus neil wou e, “Anutu tyek sesa wang, wang on nambei tete nol wei xel pelei teleing lek o! Wang wou kwam en wa bei betiwou petieing me ghe bo qayeeng en ay, om wang lam toundei inyon, ekom wamaxow ghe pyalek petieing me ghe neil nikanzek bei xel sesa ay.” ");
INSERT INTO tbx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Xel wei toukale paviy Paulus eno neil, “Nambei nya wambei neil qayeeng nol lek Anutu xe lumuki lukanzek on?” ");
INSERT INTO tbx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paulus neil elox bei, “Xam lingyeiw, a se woulek bei inyon moxo lumuki lukanzek. En nambei xel byex eivek xoulek bei: ‘Xam se baluk nilul lek tambiy wei mi yeiteyei wa xe xel xomaxoneing o.’ ” ");
INSERT INTO tbx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Woyom Paulus woulek woy bei, xel on valu yon Sadyusi me xel valu yon Parisi, om taxe la wou xel kanzol, “Xam lingyeiw, a ne Parisi, me Parisi neu moux ay. A nale lek qayeeng wongeing en nambei a mi toung manghalus bei xel meyeing tyek qandi lek.” ");
INSERT INTO tbx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Paulus neil qayeeng tine, eno qayeeng vevek qandi eivek xel Sadyusi me xel Parisi, me xel wei di qekuma eno dembuma is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Xel Sadyusi neil embei xel meyeing tyek se qandi lek, me inyon angela ma me laweeng ma, ekom xel Parisi wongis lul tine dalus.) ");
INSERT INTO tbx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Om bembeeng on wong nindenduing ngandoung kamouyo, me xel putoung wei petieing o valu eno Parisi wei toungale inyon eno luk nikanzek bei, “Xa se xei lulti sewok eivek tambiy ne. Beind laweeng o angela luk wou e.” ");
INSERT INTO tbx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Qayeeng vevek wo ngandoung om lei ngandoung wei xel vevek o yaleeng enok moux alis vex tetei Paulus me e neing a tip. Om moxo wo qayeeng nikanzek wou xel vevekyeiw bei xel na tetei e veil xel me na qou e me na eivek bend. ");
INSERT INTO tbx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Yanyeing boukeing eno Tambiy Ngandoung toungale paviy Paulus me neil, “Wa bale bo nikanzek! Nambei ingwei wang mi neil a xe xoulek eivek Yerusalem o, om wa mi neil a xe qayeeng ambei nyon eivek Rom is.” ");
INSERT INTO tbx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Yanyeing satiboukeing eno Yudayeiw qekuma me tup qayeeng lekti, me xel neil neing is inya punei bei, tyek xel se gya o na num, qe ka xel nyeis Paulus amey bole. ");
INSERT INTO tbx_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Xel moux wei neil qayeeng tine eno teyei lek xoumeeng vey (40). ");
INSERT INTO tbx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Xel la wou xel lumuki leitata yo me teivateiv me neil, “Xa neil neing is inya punei bei, xa se teyei bei gha lulti qe ka xa nyeis Paulus amey le. ");
INSERT INTO tbx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Woyom gweimbeeng, xam me xel kanzol ghe bong qayeeng na wou lei ngandoung, en e qou Paulus me nam axone wou xam. Me na tyoxe e bei xam ambei ngo qayeeng neing valu en tine. Dom xa menyex wou xow en kandek na nyeis e gyeik moxo nam a tyip inye yo.” ");
INSERT INTO tbx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ekom Paulus li vex neu moux ngo qayeeng tine, om moxo la eivek xel vevekyeiw bend me neil wou Paulus. ");
INSERT INTO tbx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Woyom Paulus taxe beyeiv ti me neil wou e, “Qou moux ghavis tine me la wou lei ngandoung wei vevek o. Moxo embei neil qayeeng ngandoung ti wou e.” ");
INSERT INTO tbx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Om moxo qou e me la wou lei ngandoung wei xel vevek o. Beyeiv neil, “Paulus, tambiy wei la xeitueing, taxe a la me teling wou ay bei a qou moux ghavis tine me na nam wou wang en e bei neil lul valu wou wang.” ");
INSERT INTO tbx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Lei ngandoung wei vevek o zeim moux ghavis on mema, de qou e me la nenyawes me teling e, “Inye wambei neil vati wou ay?” ");
INSERT INTO tbx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Moxo neil, “Xel Yuda toung qayeeng lekti bei tyek teling wou wang bei wa qou Paulus me ghe na wou xel kanzol yanyeing. Xel embei tyoxe wang bei na ngo wou qayeeng on qes bo nimza en tambiy yon. ");
INSERT INTO tbx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Wang seng bong e wou xel, en xel on teyei lek xoumeeng vey (40) eno di xupek me axe me neil neing is inya punei bei tyek xel se gya lulti o na num qe ka xel nyeis Paulus amey bole. Xel yeiwou xow gweimbeeng, xel di axe wang bei wang zenghek lek xel xe qayeeng.” ");
INSERT INTO tbx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Lei ngandoung wei xel vevekyeiw o wong ghavis on la de luk nikanzek wou e, “Wa se neil wou xelti bei wang neil qayeeng tine wou ay.” ");
INSERT INTO tbx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Woyom moxo taxe e xe beyeiv yuw me wo qayeeng nikanzek wou luw bei, “Muw ghe gweiwou me na qou 200 vevekyeiw is 70 vevekyeiw wei mi dei lek vuteiv o me na qou 200 moux wei mi wo vevek angya yiy o is. Me xam ghe na Sisalia boukeing lek seivma limvey. ");
INSERT INTO tbx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Xam ghe gweiwou vuteiv wou Paulus is ambei nyon me na qou e me ghe na nimza wou Peliks lei ngandoung wei seyap o.” ");
INSERT INTO tbx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Moxo byex qapiya nambei nye: ");
INSERT INTO tbx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","A Klodias Lisias, a byex qapiya ne lak wou wa Peliks lei ngandoung wei seyap o. Bendiyeing wang. ");
INSERT INTO tbx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Tambiy tine eno Yudayeiw zeimaxoun me xel embim nyeis e, ekom a la is a xe xel vevekyeiw me na la qou e veil xel memend, en a woulek bei inyon e wei nanghei Rom o. ");
INSERT INTO tbx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ambei ngo wou bei nambei nya ekom xel byex qayeeng lek e, om a qou e me na la wou xel xe kanzol. ");
INSERT INTO tbx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","A xei bei xel byex qayeeng lek e me teling wou e en xel venaxow xe petieing, ekom xel se wong qayeeng ti teyei bei e mey o e na xeitueing. ");
INSERT INTO tbx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","De a ngo bei xel tup qayeeng lekti xupekeing en xel embei nyeis tambiy tine na mey, om a wong e lak wou wang lutika. Me a wong qayeeng nikanzek wou xel wei byex qayeeng lek e yo bei xel nak a neil qes tiwei xel zeim e eno wou wang teyei. ");
INSERT INTO tbx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Om xel vevekyeiw, eno betiwou qayeeng nikanzek wei xel e lei ngandoung wei xel vevek o me qou Paulus me lak eivek boukeing me la beyeeng Antipatris. ");
INSERT INTO tbx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Yanyeing eno xel wei mindei lek vuteiv eno la is e, de xel vevekyeiw valu loum bend nanghei Yerusalem. ");
INSERT INTO tbx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Xel vevekyeiw wei mindei lek vuteiv o la tyip Sisalia, xel qou qapiya me la wong wou lei ngandoung wei seyap o de wong Paulus la wou e. ");
INSERT INTO tbx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Lei ngandoung wei seyap o pyaw qapiya, woyom teling Paulus bei, “wang lam anghei provins tina.” Moxo woulek bei Paulus lam anghei Silisia, ");
INSERT INTO tbx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Lei ngandoung wei seyap o neil, “Tyek a ngo wa xe qayeeng gyeik xel wei wong qayeeng en wang o nam a tyip inye.” Woyom e wo qayeeng nikanzek wou belimbo yeiw bei xel gyei Paulus teyei eivek Herot beeng. ");
INSERT INTO tbx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ka bouk lim la veil, woyom Ananias lumuki lukanzek la xo wei Sisalia nei is xel teivateiv valu me tambiy wei lupeyei yeip yaing en petieing wei xel Rom o lei Tetalas, me qou xel xe qayeeng wei xel embei bo qayeeng en Paulus eno wou lei ngandoung wei seyap o manghalus. ");
INSERT INTO tbx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Woyom lei ngandoung Peliks taxe Paulus la lalei, de Tetalas wong qayeeng en e me neil ambei nye: “Lei ngandoung Peliks, xa dei ewo nimza eivek wa xe lalei vevopeing me wang vind xa xe xel me ghe menyex wou lulul ngenong wei takwei wei xel se dei ewo nimza yo. ");
INSERT INTO tbx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Xa xei lulti beimambei ne, om xa laleimi wo nimza mouyo, me na neil dange ngandoung wou wang. ");
INSERT INTO tbx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ekom xa se teyei bei zeimaxoun wang enden. Ambei tay wou wang en wa laleim vevop wou xa me na ngo xa xe qayeeng sepi kane. ");
INSERT INTO tbx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Xa xei tambiy tine eno mi wo nilul ngenong, moxo mi zeim xel laleind lek en vevek eivek Yudayeiw senghoing me la teyei lek tembuing sapa. Tambiy on gyovaxa wei xel qendu tiwei la veil xa dom xel mi taxe bei Nasaret o. ");
INSERT INTO tbx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Me moxo wong me yei en embei bong xomek vambuing on bo nilaxes wou Anutu manghalus, ekom xa zeimaxoun e, me xa bei bo qayeeng en e nangya xa maxow xe petieing. ");
INSERT INTO tbx_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Ekom Lisias lei ngandoung lam is e xe vevekyeiw me wo vevek is xa me tetei Paulus veil xa memami. ");
INSERT INTO tbx_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Dekalekom neil qayeeng nikanzek wou eti yeiw wei embei zeim qayeeng en e eno e nam wou wang. Om wa venaxow ghe gwei embo nimza. Me teling e en tine, me na qou kwa wou emaxow vya en lul beimambei ne bei xa wo qayeeng en e.” ");
INSERT INTO tbx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Xel Yuda vind Tetalas is ambei nyon, me byex qayeeng lek Paulus bei inye zonghek. ");
INSERT INTO tbx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Woyom lei ngandoung wei seyap o tetax kwa bei e baluk om Paulus neil elox: “A woulek bei lek vakovek qes valu eno wang mi zeim qayeeng wei xa xomaxoneing dalus ne. Om a laleind wo nimza me na lewexe lek wa xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Wangwei wa teling enana nei, yon wang boulek bei bouk xoumeeng yuw la veil eno a la pu Yerusalem bei na bong lalo. ");
INSERT INTO tbx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","A xei bei xel wei Yuda eno se yei bei a wo veweeng is xelti eivek xomek vambuing, o xel se yei bei a zeim xel qekueing ama yon laleind lek eivek Yudayeiw xe xomek qekueing ama me eivek beyeeng ngandoung on ti. Ma. ");
INSERT INTO tbx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Me xel se teyei bei talex bei qayeeng wei xel byex lek a ne eno inye zonghek. ");
INSERT INTO tbx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ekom ambei neilteyei bei, a mi wong lalo wou Anutu wei xa bumiyeiw o me na mi betiwou Sakwaing Tiyon, wei xel mi taxe bei bange. A wongis lul dalus wei Mose byex eivek petieing o me xel poropet byex eyeip eivek qapiya yo, ");
INSERT INTO tbx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","me a wongis me na di toung mang en Anutu nambei xel moux beimambei ne bei tyek na piyexe xel wei bombek o me xel wei nilul o eno xel xouing qandi lek veil meyeing. ");
INSERT INTO tbx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Om nambei nyon a mi wo nikanzek me na mi xeiteyei laleing wo nimza bei emi mendei embo bombek wou Anutu manghalus me xel xomaxoneing mendghalus is ambei nyon. ");
INSERT INTO tbx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Ka a la dei vakovek qes valu eivek beyeeng ba, a loum Yerusalem me na qou lul wei xeilala yo valu wou a xe xel xomaxoneing bei na bong wou xel wei kanyo yo de na toung da. ");
INSERT INTO tbx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","De gyeik xel yei ay eivek xomek vambuing eno a wo vako woy wou Anutu manghalus. Me xel ngenong ti se toundei is ay, me wo nindenduing bandabanda. ");
INSERT INTO tbx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ekom Yudayeiw valu lam anghei provins wei Esia nei me zeimaxoun ay. Wangwei xel xe qayeeng ti mendei gyeip wou ay ond inye nimza bei xel venaxow nam inye wou wa manghalus me bong qayeeng en ay. ");
INSERT INTO tbx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","O xel beimambei wei toundei inye eno teyeimbei neil sewokeing vati wei xel yei eivek ay eno teyei gyeik ingwei a nale wou xel kanzol mendghalus o. ");
INSERT INTO tbx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Om qayeeng tixemou wei a taxe eno nambei nye: ‘Qayeeng wei xel meyeing tyek qandi lek veil meyeing, om qes tine gweimbeeng xel wong qayeeng en ay.’ ” ");
INSERT INTO tbx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Woyom Peliks woulek kwa wei xel xomaxoneing ne mi betiwou Sakwaing Tiyon wo nimza yo, om tetulexe bouk dom wong xel lox de neil, “Gyeik Lisias lei ngandoung wei xel vevek o nam, tyek a menyex wou wa xe qayeeng.” ");
INSERT INTO tbx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Moxo wo qayeeng nikanzek wou beyeiv bei e toung Paulus eivek xel belimbo memend, me neil wou xel bei xel se bale zeyi e qe e mi ghavineeng me nox me num eivek xomek lalei me xel se bale zeyi e xe gweleeng qe xel a mi gyei e teyei en lulul vatiyeiw. ");
INSERT INTO tbx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Bouk valu la veil, Peliks lam is venei Drusila, inye Yuda vex ti. Moxo wong qayeeng la wou Paulus me e lam de li nenya wou qayeeng wei e di neil o, Paulus neil wou e en kwa wei wongeingis Yesu Kilisi yo. ");
INSERT INTO tbx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ka Paulus luk is xel en sakwaing bombek, me ingwei xomaxoneing na mi gyeiteyei xow me ingwei Anutu tyek na zeim qayeeng en xey loxyus o. Omva Peliks moxo yaleeng me neil, “Gweimbeeng inye woy! Wang na. Deka anghei sakwaing ti gyeip yaing, on tyek a bong qayeeng nak wou wang.” ");
INSERT INTO tbx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Lek bouk kayon bombek eno moxo embeik nge tyek Paulus bong malew valu wou e, en na zeimaxoun Peliks lalei de na tul e na nivax. Om lumama eno moxo mi wong qayeeng la wou e bei baluk is e. ");
INSERT INTO tbx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ka vakovek qes yuw la veil, Posias Festus qou Peliks nimbeeng. De Peliks embei bong Yudayeiw bo xeindlala en e, om wong Paulus toundei eivek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festus wo seyap wei provins Yudia yo. Ka bouk yal la veil eno Festus la veil Sisalia me la tyip Yerusalem nei. ");
INSERT INTO tbx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Om xel lumuki leitata me Yuda xe gyovaxa lam wou e me byex qayeeng lek Paulus. Xel luk nikanzek wou Festus bei, ");
INSERT INTO tbx_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","e devind xel me bong Paulus na Yerusalem, en nambei xel di yeiwou xow bei nyeis Paulus amey wou sakwaing. ");
INSERT INTO tbx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus lewexe bei, “Paulus toundei eivek xeitueing anghei Sisalia, me a maxow a bim ana inyei paviyeing ka.” ");
INSERT INTO tbx_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Om moxo neil, “Xam xe gyovaxa valu nam is ay me bong qayeeng en tambiy yon, wangwei moxo bong sewokeing ti nei.” ");
INSERT INTO tbx_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Ka Festus dei bouk lim yal o xoumeeng is xel, de moxo la xo wei Sisalia nei, de yanyeing eno moxo la dei eivek xomek wei ngoeing qayeeng me wong qayeeng nikanzek bei xel a qou Paulus me nam wou e. ");
INSERT INTO tbx_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ka Paulus lam woy, xel Yudayeiw wei lam axone nanghei Yerusalem eno nale vivekwou e, xel byex qayeeng nilul leimalei lek e bei bong qayeeng en e, ekom xel se teyei bei talex wou Festus bei qayeeng ne neing. ");
INSERT INTO tbx_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Woyom Paulus neil e xe qayeeng lox wou xel: “A se wong sewokeing ti lek petieing wei xel Yudayeiw, o lek xomek vambuing, o wou Sisa, king wei Rom o.” ");
INSERT INTO tbx_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ekom Festus e bei bong xel Yudayeiw laleind bo nimza wou e, om teling wou Paulus, “Beip wa being na pu wei Yerusalem nei me bale lek qayeeng wou ay anghei inyei en qayeeng ti beimambei ne?” ");
INSERT INTO tbx_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulus lewexe, “Gweimbeeng a nale lek Sisa xe xomek wei ngoeing qayeeng eivek o. Wei tyek a bo qayeeng o. En a se wo sewokeing ti wou xel Yudayeiw, nambei ingwei wamaxow ghe woulek e wo nimza yo. ");
INSERT INTO tbx_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nambei nyon wangwei a bong sewokeing ti teyei bei a mey lek nei, Ond tyek a se pesek en meyeing. Ekom wangwei qayeeng wei xel byex lek a ne se neing, ond xel ti se teyei bei toung ay eivek xel on memend. Tyek a maxow a bong qayeeng wou Sisa me e ngo!” ");
INSERT INTO tbx_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ka Festus luk is e xe xel kanzol, moxo neil: “Wang neimbei Sisa e ngo wa xe qayeeng. Om tyek wang na wou Sisa!” ");
INSERT INTO tbx_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Bouk valu lak veil, King Agripa me Benaisi la tei Sisalia bei na bong luw xe qayeeng nimza wou Festus. ");
INSERT INTO tbx_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ka xel dei luk ngenong nanghei inyon, Festus neilteyei wou king en Paulus xe qayeeng. Moxo neil: “Inyon tambiy ti toundei inye eno Peliks wong e ghei toundei eivek xomek xeitueing. ");
INSERT INTO tbx_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Gyeik a la Yerusalem, xel lumuki leitata me teivateiv wei Yudayeiw eno byex qayeeng lek e me teling bei xel bo myaveweeng wou moxo. ");
INSERT INTO tbx_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“A neil wou xel bei inye se kwa wei xa wei Rom o bei xa toung nimaying lek tambiy ti bandaing, qe ka e bale wou xel wei wo qayeeng en e yo mendghalus bole me na neil qayeeng valu me bale zeyi xow en xel xe qayeeng. ");
INSERT INTO tbx_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Om ka xel lam inye is ay, a se wong xel mi axe ay. Qe a dei eivek xomek wei ngoeing qayeeng eno lek nge yanyeing me na wong qayeeng la bei xel a qou tambiy on me nam. ");
INSERT INTO tbx_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Gyeik xel wei wo qayeeng en e yo nale me luk, ekom xel se neil qayeeng nilul ti lek e nambei a wou eivek naleing o. ");
INSERT INTO tbx_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Qe xel wei pyalek ama is e en xel xe lalo me tambiy wei mey eno lei Yesu, ekom Paulus neil embei moxo toundei mapieing. ");
INSERT INTO tbx_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","A se teyei bei gheiwou qayeeng tine qes, om a teling moxo bei e teyei bei na Yerusalem me na bale lek wongeing qayeeng tine. ");
INSERT INTO tbx_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ekom Paulus neil, embei toumendei eivek xeitueing teyei lek ingwei king Sisa wei Rom eno na ngo qayeeng wei e yo. Om a wong qayeeng nikanzek la bei xel gyei e teyei eivek xeitueing dekakom am bong e na wou Sisa.” ");
INSERT INTO tbx_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Woyom Agripa neil wou Festus, “A venaxow ambei ngo tambiy tine xe qayeeng.” Festus neil elox bei, “Yanyeing tyek wa ngo e xe qayeeng.” ");
INSERT INTO tbx_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Om yanyeing eno Agripa me Benaisi lam is vunekeing nimza me la eivek xomek lalei wei qekueing ama yo is xel wei wo lukanzek en vevekyeiw o me tambiy wei mi la tax en xel moux wei beyeeng ngandoung on o. De Festus neil om xel qou Paulus me lam. ");
INSERT INTO tbx_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Woyom Festus neil, “King Agripa, me eti yeiw dalus wei toundei is xey ne, xam ghe wei tambiy tine! Xel xomaxoneing sapa wei Yuda eno xel taxe la nikanzek wou ay eivek Yerusalem me eivek Sisalia, xel taxe bei a nyeis e mey enok moxo mendei mapieing enden. ");
INSERT INTO tbx_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ekom a xei bei moxo se wo sewokeing ti teyei bei e mey, om e maxow wong e xe qayeeng bei king Sisa e ngo e xe qayeeng, Om a wou naleing bei a bong e na Rom. ");
INSERT INTO tbx_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ekom a se woulek e xe sewokeing ti bei a byex qayeeng vati na wou e xe teiv. Nambei nyon a qou e me na lam wou xam dalus, me na lam wou wang, king Agripa, en kandek xey a ngo e xe qayeeng me a byex lul valu eivek qapiya. ");
INSERT INTO tbx_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","En a wou naleind bei inye se nimza bei a bong xel xeitueing ti na Rom wangwei a se byex sewokeing wei e wong eno eivek qapiya enak is.” ");
INSERT INTO tbx_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Woyom Agripa neil wou Paulus, “a lenghek lek wang bei wa baluk me na neil wamaxow xe qayeeng.” Om Paulus pepeeng angya mema de neil e xe qayeeng: ");
INSERT INTO tbx_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“King Agripa, a wou naleing ambei nye, inye nimza bei a bale wou wa mamghalus gweimbeeng me baluk dom wa ni nenyam wou qayeeng beimambei wei xel Yudayeiw byex lek a ne.” ");
INSERT INTO tbx_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Wang woulek kwa dalus wei Yudayeiw eno woy me vati wei xel mi vuklek ama yo. Nambei nyon ambei wa mendei kanzek dom na ni nenyam wou a xe qayeeng dalus. ");
INSERT INTO tbx_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Xel Yudayeiw dalus on woulek a woy gyeik a yakayang, nanghei myaxeeng wei a mindei eivek a maxow xe tembuing ne, me na mindei eivek Yerusalem is. ");
INSERT INTO tbx_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Xel woulek a woy en xel yeimend wou ay takwei qenang nei, om wangwei xel laleind devind nei, ond xel venaxow teyei bei neil a xe kwa wou wang. Inyon betiwou petieing nikanzek wei xa xe lalo yo, a mindei nambei xel Parisi. ");
INSERT INTO tbx_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","En nambei a mi axe me na toung mang wou vati wei Anutu neil qayeeng zonghek is xa mamiyeiw om a nale lek qayeeng gweimbeeng ne. ");
INSERT INTO tbx_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Tine inye qayeeng zonghek wei xa xe xel veleivlei xoumeeng yuw wei mi toung mend wou bei gyei neing en vati wei xel mi wong lalo wou Anutu bendiyeing aluw boukeing o. Woyom King, en qes tine Yudayeiw byex qayeeng lek ay. ");
INSERT INTO tbx_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Nambei nya xam valu ghe wou kwamim bei Anutu tyek se piyexe xel meyeing qandi lek? ");
INSERT INTO tbx_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Ay is ambei nyon a wou naleing bei bong lul ngenong en na bo nol wou Yesu wei Nasaret o lei. ");
INSERT INTO tbx_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","De inyon vati wei a mi wong anghei Yerusalem o. A qou leing ngandoung wou xel lumuki leitata bei na toung xel vambuing ngenong eivek xeitueing, ay is ambei nyon a neimbei xel amey. ");
INSERT INTO tbx_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Teyei lek bouk ngenong a mi la eivek xomek qekueing ama wei xel Yudayeiw o me na la nge bei bo myaveweeng wou xel me na tendu xel bei xel baluk yak lek Yesu. A mi wong me na xei en ambei xel a neil qayeeng nilul lek Tambiy Ngandoung. A laleing mi wo myavanei wou xel, om a mi la dingta me na ximexe xel bei bo myaveweeng wou xel. ");
INSERT INTO tbx_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Bouk ti a qou qayeeng me lei wei ngandoung o wou xel lumuki leitata bei nana Damaskus om xel wong a la. ");
INSERT INTO tbx_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Woyom king, lek ambei bendiyeing wei seivma evlek eno a di tupwou sakwaing, a xei xeiyaing ti lam anghei tyoung gheyapu nei, xeiyaing ngandoung ghanaw sayeiv, eno siing vivekwou ay me a xe xel wei lam is ay yo. ");
INSERT INTO tbx_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Xa dalus a teila lek tembuing, de a ngo vya ti neil wou ay eivek Yuda vyend, ‘Sol, Sol, wang di wo nimaying wou ay en va? Wang byex vaxam lek lul wei manewou yo, me ghe wong vanei wou xow.’ ");
INSERT INTO tbx_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Woyom a teling, ‘Wang eti, Tambiy Ngandoung?’ “Tambiy Ngandoung neil eloum bei, ‘A Yesu, wei wang di wo nimaying wou yo. ");
INSERT INTO tbx_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Gweimbeeng qandi lek me nale ghey. A talex xow wou wang me na beyal wang ambei a xe xukxe me tyek wa neil lulul vati wei wang wei woy en ay yo teyei, me vati wei tyek a talex wou wang yus o. ");
INSERT INTO tbx_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Tyek a zeim wang veil wamaxow xe xomaxoneing me xel amba memend en xel se bo nol wou wang. Dom na bong wang na wou xel ");
INSERT INTO tbx_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","en wa tax xel mend gyeina me pekwi xel veil mapetok de noum wou xeiyaing, me xel noum veil Sandang nikanzek de noum wou Anutu, om Anutu teyeimbei semaleeng xel xe sewokeing veil de xel teyeimbei mendei is xel wei wo vambuing nangya xel xe wongeingis o.’ ");
INSERT INTO tbx_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Woyom, king Agripa, a se pyalek lul tiwei a mang pekwi me na xei nanghei tyoung gheyapu yo. ");
INSERT INTO tbx_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Ti myaxeeng eno a neil xoulek wou xel wei toundei eivek Damaskus o, woyom a la wou xel wei Yerusalem me eivek Yuda dalus, me na la wou xel amba is, a neil qayeeng wei xel pekwi me noum wou Anutu me xam xe kwa yon e talex bei xam ghe pekwi xow woy. ");
INSERT INTO tbx_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Qes tiyon om Yudayeiw zeimaxoun ay eivek tete lalei wei xomek vambuing me xel embei nyeis a mey. ");
INSERT INTO tbx_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ekom Anutu mi vind ay taxombouk me elam tyip gweimbeeng ne, om a nale inye wou wa mamghalus de na neil qayeeng wou xel wei leind maeing me xel wei leind tata yo is. A se neil qayeeng nge qe vati wei poropetyeiw me Mose neil eno tyek na tyip. ");
INSERT INTO tbx_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Inyon Kilisi tyek na qou myavanei me tyek qandi natax veil meyeing, de tyek na neil qayeeng wei xeiyaing eno teyei wou e maxow xe xomaxoneing me na neil wou xel amba is.” ");
INSERT INTO tbx_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Lek qes tine Festus taxe niseikeing me wo nol wou Paulus xe qayeeng. Moxo taxe bei, “Paulus wa lum on wo bandol o. Wang qou lupeyei ngenong me wa lumpeyei yon wong wang wo bandol.” ");
INSERT INTO tbx_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ekom Paulus neil elox, “Lei ngandoung Festus, a se wo bandol. Vati wei a neil on zonghek me qes nimza. ");
INSERT INTO tbx_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","King woulek lul dalus tine, om a teyei bei baluk wou e de a se xaleeng en e. En a woulek bombek bei lulul beimambei ne lam yeip yaingateiv. ");
INSERT INTO tbx_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","King Agripa, wang wongis qayeeng wei xel poropetyeiw o? A woulek woy, bei wang wongis.” ");
INSERT INTO tbx_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Woyom Agripa neil wou Paulus, “Wang wou naleim bei inyon eivek seivma sepi kane eno tyek wang bong a bo tambiy wei na mi betiwou Kilisi yo?” ");
INSERT INTO tbx_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paulus neil elox bei, “Seivma sepika o dingta, a mi zeimemang wou Anutu bei se wamaxow qe eti yeiw dalus wei di ngo ay gweimbeeng ne tyek xam xouing ghe ghok ay. Ekom ambei xel se tup xam angya sen me xam a toumendei eivek xeitueing.” ");
INSERT INTO tbx_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Woyom king qandi lek, is e xe lei ngandoung wei seyap o me Benaisi me eti yeiw wei toundei is xel o. ");
INSERT INTO tbx_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Xel la veil xomek lalei tiyon, me luk wouma, xel neil, “Tambiy tine se wong lulti wo nilul bei e mey o mendei eivek xeitueing.” ");
INSERT INTO tbx_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa neil wou Festus, “Moux tine teyei bei na nivax, wangwei e maxow se neil wou Sisa bei e ngo e xe qayeeng nei.” ");
INSERT INTO tbx_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Nambei nyon xel tup qayeeng lekti bei xa na eivek sip me nana Itali. De xel toung Paulus me xel wei xeitueing eno valu eivek tambiy ti e lei Julias eno mema wei toundei nambei beyeiv eivek vevekyeiw qendu ti wei king lei ngandoung wei Rom o. ");
INSERT INTO tbx_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Xa la eivek sip wei beyeeng nayak Adlamitium. Sip tine tyek na tupwou mamileeng wei beyeeng nayak nayak wei provins Esia yo, om xa la eivek mamileeng me na la. Alistakas wei beyeeng Tesalonika nanghei tembuing danghei wei Masedonia eno la is xa. ");
INSERT INTO tbx_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","De yanyeing eno xa la tei Saidon, me Julias lalei wo nimza wou Paulus, om wong Paulus la wou e xe xel gweleeng yeiw bei kandek xel bo vineing valu wou e. ");
INSERT INTO tbx_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nanghei inyon eno xa la eivek sip no me na ghanaw tembuing nayak Saiprus eivek mamileeng, en laweeng ngandoung vei sip is xa. ");
INSERT INTO tbx_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Ka xa la eivek sip me na sek mamileeng me na la paviy Silisia me Pampilia eno xa teila nanghei beyeeng Maila eivek Lisia. ");
INSERT INTO tbx_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Nanghei inyon eno beyeiv wei xel vevek eno yei sip ti lam anghei Aleksandlia en embei na Itali om toung xa lek sip tiyon. ");
INSERT INTO tbx_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Xa mi la kaka teyei lek bouk valu en laweeng nikanzek vei sip is xa om wong pok wou xa en ingwei xa bei na Nidus o. Laweeng se wong xa la lox xa xe sakwaing, om xa se teyei bei na no, qe xa pekwi me na la tembuing nayak Krit eivek mamileeng paviy Salmone. ");
INSERT INTO tbx_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Xa wo pok me betiwou mamileeng vi me na la tyip wou beyeeng ti lei Beyeeng Nenyawes Nimza wei toundei paviy beyeeng nayak Lasea. ");
INSERT INTO tbx_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Xa la lek mamileeng bouk valu betiy lak veil, me gweimbeeng eno se bouk nimza wei laeing o, en bouk ngandoung wei Yudayeiw o, bouk wei xel mi vambu xow en yaing o, bouk tine la veil. Om Paulus peti xel bei, ");
INSERT INTO tbx_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Xa me, a xei bei xe xe laeing eno tyek xey a qou nilul ayang eivek sip me xe xe qoupek valu tyek nati, me xemaxow is ambei nyon.” ");
INSERT INTO tbx_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ekom beyeiv wei xel vevek o se ngo vati wei Paulus neil o, qe betiwou tambiy wei mi qou sip o me tambiy wei e xe sip on vyend. ");
INSERT INTO tbx_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Beyeeng tine se nimza bei sip na bale me ghupek eivek en laweeng ngandoung on, om xel moux ngenong on neil embei xel me di na eivek sip me na, xel embei betiwou mamileeng vi wei tembuing nayak Krit eivek mamileeng me na beyeeng nayak Piniks. Myakenu wei toundei nanghei nyon eno wo mya tambak la veweeng axo, me veweeng aning is. Xel embei mendei nanghei nyon en laweeng ngandoung tine tyip. ");
INSERT INTO tbx_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Gyeik laweeng axonei tyip kaka, xel wou kwend en vati wei xel laleind vind o. Om xel puw anka dom xel la paviy mamileeng vi wei Krit o. ");
INSERT INTO tbx_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ekom se wo lululek en laweeng ti xel mi taxe bei valeivek eno lam anghei tembuing nayak Krit. ");
INSERT INTO tbx_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Laweeng ngandoung on vei sip nikanzek om sip se teyei bei na, om xel wong laweeng valeivek on vei sip di la. ");
INSERT INTO tbx_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ka xa la daing me na la tembuing nayak on valu pu wei paseisexe laweeng, wei xel taxe bei Kauda. Xa wo pok ngandoung lek puweing bot nayak lam paviy sip. ");
INSERT INTO tbx_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Woyom xel moux on puw bot leklam lek sip. Dekakom xel tup sel angya yis eivek xeinghembi bei e zeimaxoun e bo nikanzek. Xel yaleeng bei tyek xel na bale lek qakous wei mamileeng masenghoing o paviy Afrika, om xel tup sel angya yis dom wong e teila lek mamileeng dom laweeng di vei sip di la kaka. ");
INSERT INTO tbx_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Valeivek tyip me mamileeng di nex xa lox me loum, omva yanyeing eno xel wei mi wo xuk eivek sip on qou qoupek on me nex ela eivek mamileeng. ");
INSERT INTO tbx_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Lek bouk yal, eno xel nex sel me yis me qasok la veil sip angya memend. ");
INSERT INTO tbx_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Bouk ngenong la veil eno xa se xei seiv o betum ti lam nale en valeivek tine di wo nol wo xa, om xa wou kwami bei tyek xa dalus amey. ");
INSERT INTO tbx_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Bouk tambak eno moux beimambei ne se ya bambound ti, om Paulus nale wou xel mend me neil: “Xam moux, wangwei xam a ngo a xe qayeeng ne me xe se na veil Krit, yon tyek xey se teyei bei balwou nimaying tine me lul sapa ne tyek se nati. ");
INSERT INTO tbx_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ekom gweimbeeng ne a neil wou xam bei, xam laleimim se bo nimaying en tyek xam ti seng teyei bei mey, qe sip venaxow tyek lelolexe. ");
INSERT INTO tbx_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","En vezeiveeng boukeing eno a tiwei Anutu xe, me a mi wong lalo wou eno wong e xe angela ti lam nale paviy a byek ");
INSERT INTO tbx_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","de neil, ‘Paulus, wa seng gwaleeng. Tyek wang mi bale zam wou Sisa manghalus. En, Anutu ngo wa xe zeimeing mema is me wong mapieing wou xel wei la is wang lek sip o.’ ");
INSERT INTO tbx_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Angela neil wou ay, om xam moux on xam seng gwaleeng qe xam bale nikanzek, en a wongis Anutu bei tyek bong neing a tyip nambei kawei neil wou ay yo. ");
INSERT INTO tbx_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Nambei nyon mamileeng emdi qalei sip me na deka xey a na pop lek tembuing nayak on ti eivek mamileeng.” ");
INSERT INTO tbx_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Lek boukeing xoumeeng vey eno laweeng vei xa la lek mamileeng ngandoung wei Mediterenian on me na dula mamileeng wei Adriatik o, de boukeing masenghoing eno xel wei mi yeiteyei sip on axe bei sip embim na paviy mamileeng vi ti. ");
INSERT INTO tbx_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Xel qou mita me yei mamileeng on teyei lek 120 manghembi. Se denlek en xel lox me la qou mita no me yei bei inyon 90 manghembi. ");
INSERT INTO tbx_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Xa xaleeng bei tyek sip na tu xow lek qakous, om xel qou anka vey nanghei ingwei sip nelu nei me wong e lepla dom mi zeimemend bei e boyaing daing. ");
INSERT INTO tbx_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Xel wei mi yeiteyei sip on yimexe sakwaing wei xel embei na veil sip o, om xel tul yis veil bot on teila dom tyoing lek bei xel embei toung anka valu lek sip nelu. ");
INSERT INTO tbx_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Woyom Paulus neil wou beyeiv me xel vevekyeiw on, “Wangwei xel moux tine se toumendei lek sip, on tyek xam xouing a mey ama.” ");
INSERT INTO tbx_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Om xel vevekyeiw on qateiv yis wei mi zeimaxoun bot on veil dom e teila me mamileeng qalei me la. ");
INSERT INTO tbx_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Paviy e bim boyaing om Paulus wong qayeeng wou xel dalus bei xel gya yaeing. Paulus neil, “Xam laleimim on se dei wo nimza, me xam seng wa lulti wou baboumim. En xam ghe mindei bandaing teyei lek bouk xoumeeng vey ne, dom xam seng wa lulti. ");
INSERT INTO tbx_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Gweimbeeng a luk nikanzek wou xam bei xam a qou yaeing valu me ghe gwa. En e devind xam ghe bo nimkanzek. Xam lumim velus ti lek xam ti lumim eno se teyei bei puw me nati veil.” ");
INSERT INTO tbx_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Ka moxo neil tine, moxo qou belet valu me wong dange la wou Anutu eivek xel dalus mendghalus. Woyom moxo dembu dom ya. ");
INSERT INTO tbx_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Xel dalus on laleind wo nimza no me xel venaxow ya xend yaeing valu. ");
INSERT INTO tbx_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Xa dalus tiwei xa toundei lek sip ne eno teyei lek 276. ");
INSERT INTO tbx_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Ka xel ya enden xel, woyom xel nex qoupek wit on la eivek mamileeng bei sip se bo nimaying. ");
INSERT INTO tbx_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","De woyaing, xel se woulek tembuing, qe xel yei luzeeng wei mamileeng vi yo ti, inyon xel embei bong sip na bale ghei tiyon wangwei xel teyei nei. ");
INSERT INTO tbx_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Xel qateiv yis wei anka dalus on teila eivek mam